#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gtk_paradise/require_gtk3'
require 'gtk_paradise/widgets/gtk3/numbered_lines/numbered_lines.rb'

alias e puts

r = Gtk.run

box = Gtk.hbox
box.set_size_request(600, 400)
numbered_lines = Gtk::NumberedLines.new {{ upper_range: 25 }}
use_this_font = numbered_lines.font?
numbered_lines.no_arrows
# numbered_lines.use_a_scrolling_widget
box.minimal(numbered_lines, 0)

text_view = Gtk.text_view
text_view.set_text('OK')
text_view.font = use_this_font
text_view.set_size_request(500, 100)
box.minimal(text_view, 0)

numbered_lines.remove_the_main_vbox
numbered_lines.recalculate
numbered_lines.decide_whether_to_use_a_scrolled_window_or_not

scrolled_window = Gtk.scrolled_window(box)
Thread.new {
  sleep 2 # Sleep for 2 seconds here.
  numbered_lines.cut_down_to(10)
}
r << scrolled_window
r.show_all
r.set_size_request(800, 600)
r.run