#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gtk_paradise/require_gtk3' # Or change to gtk3 here.
require 'verbose_truth'

alias e puts

e
e 'This file will next test various add-ons to GTK core classes.'
e

x = Gtk::ToggleButton.new
x.is_inactive

e 'Does Gtk::ToggleButton respond to .is_inactive() ?'
e
e VerboseTruth[x.respond_to? :is_inactive]
e
e 'Next testing the custom modifications of Gtk::Widget - this'
e 'has to be done indirectly, though, as Gtk::Widget is an'
e 'abstract class.'
e
# x = Gtk::Widget.new
x.set_border_width(10)
x.intelligent_exit
e
pp x
pp x.class
e
e 'Next testing the custom modification of Gtk::Window:'
e
window = Gtk::Window.new
unless Gtk.use_gtk3?
  e 'The xid value is: '+window.xid_value?.to_s
  e
  e 'Assigning the :boat cursor next:'
  e
  # window.use_this_cursor = :boat
  # e 'All done there!'
  # e
end
e
e 'This will not work on ruby-gtk4.'
e
e
e 'Next testing the custom modification of Gtk::Spinner:'
e
spinner = Gtk::Spinner.new
e spinner.active?
spinner.is_active
e spinner.active?
e
e 'Is it still spinning: '+spinner.is_still_spinning?.to_s
e
spinner.is_inactive
e
e 'Is it still spinning: '+spinner.is_still_spinning?.to_s
e
e 'Next returning a scale button via Gtk.return_scale_button():'
e
pp Gtk.return_scale_button
e
e
e 'Next testing the custom modification of Gtk::Label:'
e
label = Gtk::Label.new('This is the label of the text.')
e label.text?
e
e 'Next testing the custom modification of Gtk::CheckButton:'
e
check_button = Gtk.check_button
e 'Running .mark_as_unchecked() next:'
e
check_button.mark_as_unchecked
e
e
e 'Next testing the custom modification of Gtk::SpinButton:'
e
spin_button = Gtk.spin_button
spin_button.transition_change_background_to(:lightblue)
e
