private rule architecture {
	meta:
		bits = 32
		endianness = "little"
		architecture = "ARM"
	condition:
		true
}

rule file_0_0_0 {
	meta:
		name = "_vsnprintf_r"
		size = 132
		refs = "005c _svfprintf_r"
	strings:
		$1 = { 70 40 2D E9 00 40 52 E2 8B 30 A0 B3 00 50 A0 E1 00 30 80 B5 68 D0 4D E2 01 C0 A0 E1 00 00 E0 B3 15 00 00 BA 04 E0 A0 01 01 E0 44 12 03 20 A0 E1 10 C0 8D E5 78 30 9D E5 00 C0 8D E5 05 00 A0 E1 00 C0 E0 E3 0D 10 A0 E1 82 6F A0 E3 14 E0 8D E5 BC 60 CD E1 08 E0 8D E5 BE C0 CD E1 ?? ?? ?? ?? 01 00 70 E3 8B 30 A0 B3 00 30 85 B5 00 00 54 E3 00 30 9D 15 00 20 A0 13 00 20 C3 15 68 D0 8D E2 70 80 BD E8 }
	condition:
		$1
}

rule file_135_0_0 {
	meta:
		name = "_vsniprintf_r"
		size = 132
		refs = "005c _svfiprintf_r"
	strings:
		$1 = { 70 40 2D E9 00 40 52 E2 8B 30 A0 B3 00 50 A0 E1 00 30 80 B5 68 D0 4D E2 01 C0 A0 E1 00 00 E0 B3 15 00 00 BA 04 E0 A0 01 01 E0 44 12 03 20 A0 E1 10 C0 8D E5 78 30 9D E5 00 C0 8D E5 05 00 A0 E1 00 C0 E0 E3 0D 10 A0 E1 82 6F A0 E3 14 E0 8D E5 BC 60 CD E1 08 E0 8D E5 BE C0 CD E1 ?? ?? ?? ?? 01 00 70 E3 8B 30 A0 B3 00 30 85 B5 00 00 54 E3 00 30 9D 15 00 20 A0 13 00 20 C3 15 68 D0 8D E2 70 80 BD E8 }
	condition:
		$1
}

rule file_0_1_0 {
	meta:
		name = "vsnprintf"
		size = 64
		refs = "0030 _vsnprintf_r 003c _impure_ptr"
	strings:
		$1 = { 30 40 2D E9 30 C0 9F E5 00 50 9C E5 00 40 A0 E1 01 E0 A0 E1 02 C0 A0 E1 04 D0 4D E2 00 30 8D E5 05 00 A0 E1 04 10 A0 E1 0E 20 A0 E1 0C 30 A0 E1 ?? ?? ?? ?? 04 D0 8D E2 30 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_154_1_0 {
	meta:
		name = "fread"
		size = 64
		refs = "0030 _fread_r 003c _impure_ptr"
	strings:
		$1 = { 30 40 2D E9 30 C0 9F E5 00 50 9C E5 00 40 A0 E1 01 E0 A0 E1 02 C0 A0 E1 04 D0 4D E2 00 30 8D E5 05 00 A0 E1 04 10 A0 E1 0E 20 A0 E1 0C 30 A0 E1 ?? ?? ?? ?? 04 D0 8D E2 30 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_390_1_0 {
	meta:
		name = "fwrite"
		size = 64
		refs = "0030 _fwrite_r 003c _impure_ptr"
	strings:
		$1 = { 30 40 2D E9 30 C0 9F E5 00 50 9C E5 00 40 A0 E1 01 E0 A0 E1 02 C0 A0 E1 04 D0 4D E2 00 30 8D E5 05 00 A0 E1 04 10 A0 E1 0E 20 A0 E1 0C 30 A0 E1 ?? ?? ?? ?? 04 D0 8D E2 30 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_340_1_0 {
	meta:
		name = "mbrtowc"
		size = 64
		refs = "0030 _mbrtowc_r 003c _impure_ptr"
	strings:
		$1 = { 30 40 2D E9 30 C0 9F E5 00 50 9C E5 00 40 A0 E1 01 E0 A0 E1 02 C0 A0 E1 04 D0 4D E2 00 30 8D E5 05 00 A0 E1 04 10 A0 E1 0E 20 A0 E1 0C 30 A0 E1 ?? ?? ?? ?? 04 D0 8D E2 30 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_1_0 {
	meta:
		name = "mbsrtowcs"
		size = 64
		refs = "0030 _mbsrtowcs_r 003c _impure_ptr"
	strings:
		$1 = { 30 40 2D E9 30 C0 9F E5 00 50 9C E5 00 40 A0 E1 01 E0 A0 E1 02 C0 A0 E1 04 D0 4D E2 00 30 8D E5 05 00 A0 E1 04 10 A0 E1 0E 20 A0 E1 0C 30 A0 E1 ?? ?? ?? ?? 04 D0 8D E2 30 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_189_1_0 {
	meta:
		name = "vasniprintf"
		size = 64
		refs = "0030 _vasniprintf_r 003c _impure_ptr"
	strings:
		$1 = { 30 40 2D E9 30 C0 9F E5 00 50 9C E5 00 40 A0 E1 01 E0 A0 E1 02 C0 A0 E1 04 D0 4D E2 00 30 8D E5 05 00 A0 E1 04 10 A0 E1 0E 20 A0 E1 0C 30 A0 E1 ?? ?? ?? ?? 04 D0 8D E2 30 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_265_1_0 {
	meta:
		name = "vasnprintf"
		size = 64
		refs = "0030 _vasnprintf_r 003c _impure_ptr"
	strings:
		$1 = { 30 40 2D E9 30 C0 9F E5 00 50 9C E5 00 40 A0 E1 01 E0 A0 E1 02 C0 A0 E1 04 D0 4D E2 00 30 8D E5 05 00 A0 E1 04 10 A0 E1 0E 20 A0 E1 0C 30 A0 E1 ?? ?? ?? ?? 04 D0 8D E2 30 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_135_1_0 {
	meta:
		name = "vsniprintf"
		size = 64
		refs = "0030 _vsniprintf_r 003c _impure_ptr"
	strings:
		$1 = { 30 40 2D E9 30 C0 9F E5 00 50 9C E5 00 40 A0 E1 01 E0 A0 E1 02 C0 A0 E1 04 D0 4D E2 00 30 8D E5 05 00 A0 E1 04 10 A0 E1 0E 20 A0 E1 0C 30 A0 E1 ?? ?? ?? ?? 04 D0 8D E2 30 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_155_1_0 {
	meta:
		name = "wcsrtombs"
		size = 64
		refs = "0030 _wcsrtombs_r 003c _impure_ptr"
	strings:
		$1 = { 30 40 2D E9 30 C0 9F E5 00 50 9C E5 00 40 A0 E1 01 E0 A0 E1 02 C0 A0 E1 04 D0 4D E2 00 30 8D E5 05 00 A0 E1 04 10 A0 E1 0E 20 A0 E1 0C 30 A0 E1 ?? ?? ?? ?? 04 D0 8D E2 30 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_0_0 {
	meta:
		name = "scalbn"
		size = 444
		refs = "0048 __muldf3 00a0 copysign 0160 __adddf3"
	strings:
		$1 = { F0 48 2D E9 02 51 C0 E3 25 5A A0 E1 05 5A A0 E1 45 5A B0 E1 00 B0 A0 E1 01 C0 A0 E1 00 60 A0 E1 01 70 A0 E1 00 30 A0 E1 02 40 A0 E1 24 00 00 1A 02 31 C0 E3 01 30 93 E1 1E 00 00 0A 43 24 A0 E3 00 30 A0 E3 05 26 82 E2 ?? ?? ?? ?? C3 3C E0 E3 4F 30 43 E2 03 00 54 E1 00 B0 A0 E1 01 C0 A0 E1 34 00 00 BA 02 51 C0 E3 25 5A A0 E1 05 5A A0 E1 45 5A A0 E1 36 50 45 E2 7F 2E A0 E3 04 50 85 E0 0E 20 82 E2 02 00 55 E1 00 30 A0 E1 15 00 00 DA 0C 30 A0 E1 0B 20 A0 E1 43 1F 8F E2 03 00 91 E8 ?? ?? ?? ?? 01 3C 8F E2 0C 00 93 E8 ?? ?? ?? ?? 00 B0 A0 E1 01 C0 A0 E1 0B 00 A0 E1 0C 10 A0 E1 F0 88 BD E8 7F 2E A0 E3 0F 20 82 E2 02 00 55 E1 20 00 00 0A 7F 2E A0 E3 04 50 85 E0 0E 20 82 E2 02 00 55 E1 E9 FF FF CA 00 00 55 E3 06 00 00 DA 7F 34 C3 E3 0F 36 C3 E3 05 3A 83 E1 03 B0 A0 E1 0B 00 A0 E1 0C 10 A0 E1 F0 88 BD E8 35 00 75 E3 18 00 00 AA C3 3C A0 E3 50 30 83 E2 03 00 54 E1 DA FF FF CA 0B 20 A0 E1 0C 30 A0 E1 80 10 8F E2 03 00 91 E8 ?? ?? ?? ?? 74 30 8F E2 0C 00 93 E8 ?? ?? ?? ?? 00 B0 A0 E1 01 C0 A0 E1 0B 00 A0 E1 0C 10 A0 E1 F0 88 BD E8 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 00 B0 A0 E1 01 C0 A0 E1 0B 00 A0 E1 0C 10 A0 E1 F0 88 BD E8 7F 34 C3 E3 36 50 85 E2 0F 36 C3 E3 05 3A 83 E1 F2 25 A0 E3 03 00 A0 E1 0C 10 A0 E1 01 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 B0 A0 E1 01 C0 A0 E1 C2 FF FF EA 3C E4 37 7E 9C 75 00 88 1F 6E A5 01 59 F3 F8 C2 }
	condition:
		$1
}

rule file_2_0_0 {
	meta:
		name = "argz_extract"
		size = 96
		refs = "0010 argz_count"
	strings:
		$1 = { 70 40 2D E9 01 40 A0 E1 02 50 A0 E1 00 60 A0 E1 ?? ?? ?? ?? 01 00 54 E3 0C 00 00 9A 02 30 54 E2 0A 00 00 0A 01 40 44 E2 04 40 86 E0 00 10 A0 E3 01 20 54 E5 00 00 52 E3 01 10 81 02 00 20 61 00 02 41 85 07 01 30 53 E2 01 40 44 E2 F7 FF FF 1A 00 30 A0 E3 00 60 85 E5 00 31 85 E7 70 80 BD E8 }
	condition:
		$1
}

rule file_3_0_0 {
	meta:
		name = "__hexnan"
		size = 652
		refs = "0228 __hexdig_init 0288 __hexdig"
	strings:
		$1 = { F0 4F 2D E9 7C 42 9F E5 30 30 D4 E5 0C D0 4D E2 00 00 53 E3 04 00 8D E5 01 50 A0 E1 02 90 A0 E1 80 00 00 0A 00 30 95 E5 1F 10 13 E2 C3 32 A0 E1 03 31 89 E0 00 20 A0 E3 04 30 83 12 02 A0 A0 E1 04 20 03 E5 04 20 9D E5 08 10 8D E5 04 10 43 E2 00 10 8D E5 00 50 92 E5 01 80 A0 E1 0A B0 A0 E1 0A 60 A0 E1 01 30 F5 E5 00 00 53 E3 25 00 00 0A 03 20 D4 E7 00 00 52 E3 55 00 00 1A 20 00 53 E3 63 00 00 8A 0B 00 56 E1 F5 FF FF DA 07 00 5A E3 00 30 A0 C3 01 30 A0 D3 08 00 51 E1 00 30 A0 23 00 00 53 E3 0D 00 00 0A 08 70 6A E2 07 71 A0 E1 00 20 91 E5 20 A0 67 E2 01 30 A0 E1 01 C0 A0 E1 04 10 93 E5 11 0A 82 E1 31 27 A0 E1 00 00 83 E5 04 20 A3 E5 03 00 58 E1 F8 FF FF 8A 0C 10 A0 E1 09 00 51 E1 00 30 A0 83 04 30 21 85 03 A0 A0 81 01 30 F5 E5 08 A0 A0 93 06 B0 A0 81 01 80 A0 81 00 00 53 E3 D9 FF FF 1A 00 00 56 E3 42 00 00 0A 07 00 5A E3 00 30 A0 C3 01 30 A0 D3 08 00 51 E1 00 30 A0 23 00 00 53 E3 0B 00 00 0A 08 A0 6A E2 0A A1 A0 E1 00 20 91 E5 20 40 6A E2 01 30 A0 E1 04 00 93 E5 10 C4 82 E1 30 2A A0 E1 00 C0 83 E5 04 20 A3 E5 03 00 58 E1 F8 FF FF 8A 01 00 59 E1 32 00 00 2A 00 00 9D E5 09 30 A0 E1 04 20 91 E4 01 00 50 E1 04 20 83 E4 FB FF FF 2A 00 10 9D E5 00 20 A0 E3 04 20 83 E4 03 00 51 E1 FC FF FF 2A 00 10 9D E5 00 30 91 E5 00 00 53 E3 0A 00 00 1A 00 30 9D E5 03 00 59 E1 00 30 9D 15 02 00 00 1A 2A 00 00 EA 03 00 59 E1 28 00 00 0A 04 20 13 E5 00 00 52 E3 04 30 43 E2 F9 FF FF 0A 05 00 A0 E3 12 00 00 EA 01 A0 8A E2 08 00 5A E3 01 60 86 E2 05 00 00 CA 00 30 91 E5 03 32 A0 E1 0F 20 02 E2 02 20 83 E1 00 20 81 E5 99 FF FF EA 09 00 51 E1 97 FF FF 9A 00 30 A0 E3 04 30 21 E5 01 A0 A0 E3 F5 FF FF EA 29 00 53 E3 14 00 00 0A 04 00 A0 E3 0C D0 8D E2 F0 8F BD E8 ?? ?? ?? ?? 7C FF FF EA 08 20 9D E5 00 00 52 E3 D4 FF FF 0A 00 30 9D E5 08 10 9D E5 00 20 93 E5 20 30 61 E2 00 10 E0 E3 31 33 02 E0 00 20 9D E5 00 30 82 E5 CD FF FF EA 01 30 A0 E3 00 30 89 E5 05 00 A0 E3 EB FF FF EA 04 20 9D E5 01 50 85 E2 00 00 56 E3 00 50 82 E5 A2 FF FF 1A E4 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_0_0 {
	meta:
		name = "_mbsrtowcs_r"
		size = 256
		refs = "0080 _mbrtowc_r 00fc __mb_cur_max"
	strings:
		$1 = { F0 4F 2D E9 00 B0 51 E2 0C D0 4D E2 00 A0 A0 E1 02 60 A0 E1 04 30 8D E5 30 90 9D E5 2F 00 00 0A 04 30 9D E5 00 00 53 E3 03 80 A0 01 04 40 9D 15 1F 00 00 0A C0 70 9F E5 0B 50 A0 E1 00 80 A0 E3 00 20 96 E5 09 00 00 EA 00 20 96 E5 00 00 5B E3 01 40 44 E2 00 20 82 E0 0B 50 A0 01 04 50 85 12 00 00 54 E3 00 20 86 E5 01 80 88 E2 0F 00 00 0A 00 30 97 E5 05 10 A0 E1 0A 00 A0 E1 00 90 8D E5 ?? ?? ?? ?? 00 00 50 E3 EE FF FF CA 02 00 70 E3 0A 00 00 1A 60 10 9F E5 00 20 96 E5 00 30 91 E5 00 00 54 E3 03 20 82 E0 00 20 86 E5 EF FF FF 1A 04 80 9D E5 08 00 A0 E1 0C D0 8D E2 F0 8F BD E8 00 00 50 E3 00 30 A0 13 00 30 89 15 8A 30 A0 13 00 00 86 05 00 30 8A 15 00 80 E0 13 F4 FF FF EA 00 30 92 E5 00 10 E0 E3 0C 60 8D E2 04 30 26 E5 04 10 8D E5 01 40 A0 E1 CD FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_5_0_0 {
	meta:
		name = "_tzset_r"
		size = 1180
		refs = "000c __gettzinfo 001c _getenv_r 002c __tz_lock 0040 strcmp 0054 free 005c strlen 0068 _malloc_r 0078 strcpy 00a0 sscanf 0250 strtoul 0354 __tzcalc_limits 037c __tz_unlock 0484 _tzname 048c _daylight 0490 _timezone"
	strings:
		$1 = { F0 4F 2D E9 24 D0 4D E2 00 50 A0 E1 ?? ?? ?? ?? 58 14 9F E5 00 70 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 60 50 E2 FA 00 00 0A 44 44 9F E5 ?? ?? ?? ?? 00 10 94 E5 00 00 51 E3 04 00 00 0A 06 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 CB 00 00 0A 00 10 94 E5 01 00 A0 E1 ?? ?? ?? ?? 06 00 A0 E1 ?? ?? ?? ?? 01 10 80 E2 05 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 00 00 84 E5 06 10 A0 11 ?? ?? ?? ?? 00 30 D6 E5 F0 53 9F E5 3A 00 53 E3 01 60 86 02 14 40 8D E2 06 00 A0 E1 E0 13 9F E5 05 20 A0 E1 04 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 B3 00 00 DA 14 30 9D E5 03 20 D6 E7 03 60 86 E0 2D 00 52 E3 01 60 86 02 00 80 E0 03 02 00 00 0A 2B 00 52 E3 01 60 86 02 01 80 A0 E3 00 C0 A0 E3 B0 C2 CD E1 BE C1 CD E1 20 C0 8D E2 00 C0 8D E5 06 00 A0 E1 1E C0 8D E2 88 13 9F E5 22 20 8D E2 04 30 A0 E1 10 10 8D E9 0C 40 8D E5 ?? ?? ?? ?? 00 00 50 E3 9A 00 00 DA B2 32 DD E1 B0 22 DD E1 83 01 63 E0 02 13 A0 E1 02 21 41 E0 80 32 83 E0 BE 11 DD E1 03 32 82 E0 01 30 83 E0 98 03 03 E0 14 20 9D E5 40 83 9F E5 02 60 86 E0 0C A0 85 E2 20 30 87 E5 06 00 A0 E1 24 13 9F E5 0A 20 A0 E1 04 30 A0 E1 00 50 88 E5 ?? ?? ?? ?? 00 00 50 E3 BC 00 00 DA 14 30 9D E5 04 A0 88 E5 03 20 D6 E7 03 60 86 E0 2D 00 52 E3 01 60 86 02 00 50 E0 03 02 00 00 0A 2B 00 52 E3 01 60 86 02 01 50 A0 E3 00 C0 A0 E3 14 C0 8D E5 B2 C2 CD E1 B0 C2 CD E1 BE C1 CD E1 20 C0 8D E2 00 C0 8D E5 06 00 A0 E1 1E C0 8D E2 BC 12 9F E5 22 20 8D E2 04 30 A0 E1 10 10 8D E9 0C 40 8D E5 ?? ?? ?? ?? 00 00 50 E3 74 00 00 DA B2 32 DD E1 B0 22 DD E1 83 01 63 E0 02 13 A0 E1 02 21 41 E0 80 32 83 E0 BE 11 DD E1 03 32 82 E0 01 30 83 E0 93 05 05 E0 3C 50 87 E5 14 30 9D E5 03 60 86 E0 07 50 A0 E1 07 80 A0 E1 00 70 D6 E5 2C 00 57 E3 01 70 F6 05 00 A0 A0 E3 4D 00 57 E3 0A 90 A0 E1 26 00 00 0A 4A 00 57 E3 01 60 86 02 06 00 A0 E1 10 10 8D E2 0A 20 A0 E3 07 B0 A0 01 44 B0 A0 13 ?? ?? ?? ?? 10 70 9D E5 00 08 A0 E1 06 00 57 E1 20 08 A0 E1 08 B0 C5 15 14 00 85 15 45 00 00 0A B8 01 CD E1 02 30 A0 E3 00 C0 A0 E3 14 90 8D E5 B2 32 CD E1 B0 C2 CD E1 BE C1 CD E1 00 30 D7 E5 2F 00 53 E3 07 3B A0 13 20 30 83 12 09 60 A0 11 46 00 00 0A 01 A0 8A E2 02 00 5A E3 18 30 85 E5 1C 50 85 E2 25 00 00 0A 06 60 87 E0 00 70 D6 E5 2C 00 57 E3 01 70 F6 05 4D 00 57 E3 D8 FF FF 1A 1A C0 8D E2 00 C0 8D E5 06 00 A0 E1 18 C0 8D E2 A0 11 9F E5 1C 20 8D E2 04 30 A0 E1 10 10 8D E9 0C 40 8D E5 ?? ?? ?? ?? 03 00 50 E3 1E 00 00 1A BC 31 DD E1 00 00 53 E3 1B 00 00 0A 0C 00 53 E3 19 00 00 8A BA 21 DD E1 00 00 52 E3 16 00 00 0A 05 00 52 E3 14 00 00 8A B8 11 DD E1 06 00 51 E3 11 00 00 8A 08 70 C5 E5 0C 30 85 E5 10 20 85 E5 14 10 85 E5 14 70 9D E5 07 70 86 E0 C8 FF FF EA 04 00 98 E5 ?? ?? ?? ?? 3C 10 98 E5 20 30 98 E5 24 21 9F E5 01 10 53 E0 01 10 A0 13 00 10 82 E5 18 21 9F E5 00 30 82 E5 08 70 A0 E1 ?? ?? ?? ?? 24 D0 8D E2 F0 8F BD E8 00 00 5A E3 2B 00 00 1A 03 30 A0 E3 0C 30 88 E5 02 30 A0 E3 10 30 88 E5 4D 30 A0 E3 08 30 C8 E5 14 A0 88 E5 AF FF FF EA 20 30 97 E5 E1 3E 43 E2 3C 30 87 E5 91 FF FF EA 20 C0 8D E2 C8 10 9F E5 22 20 8D E2 04 30 A0 E1 00 C0 8D E5 07 00 A0 E1 1E C0 8D E2 10 10 8D E9 0C 40 8D E5 ?? ?? ?? ?? B2 22 DD E1 B0 12 DD E1 82 31 62 E0 01 03 A0 E1 01 11 40 E0 83 32 82 E0 BE 01 DD E1 03 32 81 E0 14 60 9D E5 00 30 83 E0 A3 FF FF EA ?? ?? ?? ?? 6C 10 9F E5 60 30 9F E5 70 20 9F E5 00 60 81 E5 60 10 9F E5 04 20 83 E5 00 60 81 E5 00 20 83 E5 ?? ?? ?? ?? CF FF FF EA 4D C0 A0 E3 24 C0 C8 E5 0B 30 A0 E3 01 C0 A0 E3 28 30 88 E5 2C C0 88 E5 30 90 88 E5 83 FF FF EA 00 30 98 E5 04 30 88 E5 ?? ?? ?? ?? C3 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_6_1_0 {
	meta:
		name = "_vsiscanf_r"
		size = 116
		refs = "0028 strlen 0064 __ssvfiscanf_r 0070 eofread1"
	strings:
		$1 = { 70 40 2D E9 00 40 A0 E1 68 D0 4D E2 03 50 A0 E1 01 00 A0 E1 81 3F A0 E3 02 60 A0 E1 BC 30 CD E1 00 10 8D E5 10 10 8D E5 ?? ?? ?? ?? 00 C0 A0 E3 00 E0 A0 E1 04 00 A0 E1 30 40 9F E5 44 C0 8D E5 30 C0 8D E5 06 20 A0 E1 00 C0 E0 E3 05 30 A0 E1 0D 10 A0 E1 14 E0 8D E5 20 40 8D E5 04 E0 8D E5 BE C0 CD E1 ?? ?? ?? ?? 68 D0 8D E2 70 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_1_0 {
	meta:
		name = "_vsscanf_r"
		size = 116
		refs = "0028 strlen 0064 __ssvfscanf_r 0070 eofread1"
	strings:
		$1 = { 70 40 2D E9 00 40 A0 E1 68 D0 4D E2 03 50 A0 E1 01 00 A0 E1 81 3F A0 E3 02 60 A0 E1 BC 30 CD E1 00 10 8D E5 10 10 8D E5 ?? ?? ?? ?? 00 C0 A0 E3 00 E0 A0 E1 04 00 A0 E1 30 40 9F E5 44 C0 8D E5 30 C0 8D E5 06 20 A0 E1 00 C0 E0 E3 05 30 A0 E1 0D 10 A0 E1 14 E0 8D E5 20 40 8D E5 04 E0 8D E5 BE C0 CD E1 ?? ?? ?? ?? 68 D0 8D E2 70 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_6_2_0 {
	meta:
		name = "vsiscanf"
		size = 44
		refs = "0024 _vsiscanf_r 0028 _impure_ptr"
	strings:
		$1 = { 04 40 2D E5 02 30 A0 E1 18 20 9F E5 00 40 A0 E1 01 C0 A0 E1 00 00 92 E5 04 10 A0 E1 0C 20 A0 E1 10 00 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_408_1_0 {
	meta:
		name = "__svfiscanf"
		size = 44
		refs = "0024 __svfiscanf_r 0028 _impure_ptr"
	strings:
		$1 = { 04 40 2D E5 02 30 A0 E1 18 20 9F E5 00 40 A0 E1 01 C0 A0 E1 00 00 92 E5 04 10 A0 E1 0C 20 A0 E1 10 00 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_314_1_0 {
	meta:
		name = "__svfscanf"
		size = 44
		refs = "0024 __svfscanf_r 0028 _impure_ptr"
	strings:
		$1 = { 04 40 2D E5 02 30 A0 E1 18 20 9F E5 00 40 A0 E1 01 C0 A0 E1 00 00 92 E5 04 10 A0 E1 0C 20 A0 E1 10 00 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_401_0_0 {
	meta:
		name = "execve"
		size = 44
		refs = "0024 _execve_r 0028 _impure_ptr"
	strings:
		$1 = { 04 40 2D E5 02 30 A0 E1 18 20 9F E5 00 40 A0 E1 01 C0 A0 E1 00 00 92 E5 04 10 A0 E1 0C 20 A0 E1 10 00 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_327_1_0 {
	meta:
		name = "fgets"
		size = 44
		refs = "0024 _fgets_r 0028 _impure_ptr"
	strings:
		$1 = { 04 40 2D E5 02 30 A0 E1 18 20 9F E5 00 40 A0 E1 01 C0 A0 E1 00 00 92 E5 04 10 A0 E1 0C 20 A0 E1 10 00 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_239_5_0 {
	meta:
		name = "fmemopen"
		size = 44
		refs = "0024 _fmemopen_r 0028 _impure_ptr"
	strings:
		$1 = { 04 40 2D E5 02 30 A0 E1 18 20 9F E5 00 40 A0 E1 01 C0 A0 E1 00 00 92 E5 04 10 A0 E1 0C 20 A0 E1 10 00 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_395_1_0 {
	meta:
		name = "freopen"
		size = 44
		refs = "0024 _freopen_r 0028 _impure_ptr"
	strings:
		$1 = { 04 40 2D E5 02 30 A0 E1 18 20 9F E5 00 40 A0 E1 01 C0 A0 E1 00 00 92 E5 04 10 A0 E1 0C 20 A0 E1 10 00 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_443_1_0 {
	meta:
		name = "fseek"
		size = 44
		refs = "0024 _fseek_r 0028 _impure_ptr"
	strings:
		$1 = { 04 40 2D E5 02 30 A0 E1 18 20 9F E5 00 40 A0 E1 01 C0 A0 E1 00 00 92 E5 04 10 A0 E1 0C 20 A0 E1 10 00 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_165_0_0 {
	meta:
		name = "fseeko"
		size = 44
		refs = "0024 _fseek_r 0028 _impure_ptr"
	strings:
		$1 = { 04 40 2D E5 02 30 A0 E1 18 20 9F E5 00 40 A0 E1 01 C0 A0 E1 00 00 92 E5 04 10 A0 E1 0C 20 A0 E1 10 00 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_400_0_0 {
	meta:
		name = "lseek"
		size = 44
		refs = "0024 _lseek_r 0028 _impure_ptr"
	strings:
		$1 = { 04 40 2D E5 02 30 A0 E1 18 20 9F E5 00 40 A0 E1 01 C0 A0 E1 00 00 92 E5 04 10 A0 E1 0C 20 A0 E1 10 00 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_173_0_0 {
	meta:
		name = "read"
		size = 44
		refs = "0024 _read_r 0028 _impure_ptr"
	strings:
		$1 = { 04 40 2D E5 02 30 A0 E1 18 20 9F E5 00 40 A0 E1 01 C0 A0 E1 00 00 92 E5 04 10 A0 E1 0C 20 A0 E1 10 00 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_61_1_0 {
	meta:
		name = "setenv"
		size = 44
		refs = "0024 _setenv_r 0028 _impure_ptr"
	strings:
		$1 = { 04 40 2D E5 02 30 A0 E1 18 20 9F E5 00 40 A0 E1 01 C0 A0 E1 00 00 92 E5 04 10 A0 E1 0C 20 A0 E1 10 00 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_85_1_0 {
	meta:
		name = "strtol"
		size = 44
		refs = "0024 _strtol_r 0028 _impure_ptr"
	strings:
		$1 = { 04 40 2D E5 02 30 A0 E1 18 20 9F E5 00 40 A0 E1 01 C0 A0 E1 00 00 92 E5 04 10 A0 E1 0C 20 A0 E1 10 00 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_208_0_0 {
	meta:
		name = "strtoll"
		size = 44
		refs = "0024 _strtoll_r 0028 _impure_ptr"
	strings:
		$1 = { 04 40 2D E5 02 30 A0 E1 18 20 9F E5 00 40 A0 E1 01 C0 A0 E1 00 00 92 E5 04 10 A0 E1 0C 20 A0 E1 10 00 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_424_1_0 {
	meta:
		name = "strtoul"
		size = 44
		refs = "0024 _strtoul_r 0028 _impure_ptr"
	strings:
		$1 = { 04 40 2D E5 02 30 A0 E1 18 20 9F E5 00 40 A0 E1 01 C0 A0 E1 00 00 92 E5 04 10 A0 E1 0C 20 A0 E1 10 00 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_222_0_0 {
	meta:
		name = "strtoull"
		size = 44
		refs = "0024 _strtoull_r 0028 _impure_ptr"
	strings:
		$1 = { 04 40 2D E5 02 30 A0 E1 18 20 9F E5 00 40 A0 E1 01 C0 A0 E1 00 00 92 E5 04 10 A0 E1 0C 20 A0 E1 10 00 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_42_1_0 {
	meta:
		name = "vasiprintf"
		size = 44
		refs = "0024 _vasiprintf_r 0028 _impure_ptr"
	strings:
		$1 = { 04 40 2D E5 02 30 A0 E1 18 20 9F E5 00 40 A0 E1 01 C0 A0 E1 00 00 92 E5 04 10 A0 E1 0C 20 A0 E1 10 00 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_123_1_0 {
	meta:
		name = "vasprintf"
		size = 44
		refs = "0024 _vasprintf_r 0028 _impure_ptr"
	strings:
		$1 = { 04 40 2D E5 02 30 A0 E1 18 20 9F E5 00 40 A0 E1 01 C0 A0 E1 00 00 92 E5 04 10 A0 E1 0C 20 A0 E1 10 00 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_193_1_0 {
	meta:
		name = "vdiprintf"
		size = 44
		refs = "0024 _vdiprintf_r 0028 _impure_ptr"
	strings:
		$1 = { 04 40 2D E5 02 30 A0 E1 18 20 9F E5 00 40 A0 E1 01 C0 A0 E1 00 00 92 E5 04 10 A0 E1 0C 20 A0 E1 10 00 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_206_1_0 {
	meta:
		name = "vdprintf"
		size = 44
		refs = "0024 _vdprintf_r 0028 _impure_ptr"
	strings:
		$1 = { 04 40 2D E5 02 30 A0 E1 18 20 9F E5 00 40 A0 E1 01 C0 A0 E1 00 00 92 E5 04 10 A0 E1 0C 20 A0 E1 10 00 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_40_2_0 {
	meta:
		name = "vfiprintf"
		size = 44
		refs = "0024 _vfiprintf_r 0028 _impure_ptr"
	strings:
		$1 = { 04 40 2D E5 02 30 A0 E1 18 20 9F E5 00 40 A0 E1 01 C0 A0 E1 00 00 92 E5 04 10 A0 E1 0C 20 A0 E1 10 00 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_422_2_0 {
	meta:
		name = "vfprintf"
		size = 44
		refs = "0024 _vfprintf_r 0028 _impure_ptr"
	strings:
		$1 = { 04 40 2D E5 02 30 A0 E1 18 20 9F E5 00 40 A0 E1 01 C0 A0 E1 00 00 92 E5 04 10 A0 E1 0C 20 A0 E1 10 00 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_247_1_0 {
	meta:
		name = "vsiprintf"
		size = 44
		refs = "0024 _vsiprintf_r 0028 _impure_ptr"
	strings:
		$1 = { 04 40 2D E5 02 30 A0 E1 18 20 9F E5 00 40 A0 E1 01 C0 A0 E1 00 00 92 E5 04 10 A0 E1 0C 20 A0 E1 10 00 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_25_1_0 {
	meta:
		name = "vsprintf"
		size = 44
		refs = "0024 _vsprintf_r 0028 _impure_ptr"
	strings:
		$1 = { 04 40 2D E5 02 30 A0 E1 18 20 9F E5 00 40 A0 E1 01 C0 A0 E1 00 00 92 E5 04 10 A0 E1 0C 20 A0 E1 10 00 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_2_0 {
	meta:
		name = "vsscanf"
		size = 44
		refs = "0024 _vsscanf_r 0028 _impure_ptr"
	strings:
		$1 = { 04 40 2D E5 02 30 A0 E1 18 20 9F E5 00 40 A0 E1 01 C0 A0 E1 00 00 92 E5 04 10 A0 E1 0C 20 A0 E1 10 00 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_421_1_0 {
	meta:
		name = "wcrtomb"
		size = 44
		refs = "0024 _wcrtomb_r 0028 _impure_ptr"
	strings:
		$1 = { 04 40 2D E5 02 30 A0 E1 18 20 9F E5 00 40 A0 E1 01 C0 A0 E1 00 00 92 E5 04 10 A0 E1 0C 20 A0 E1 10 00 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_406_1_0 {
	meta:
		name = "wcstol"
		size = 44
		refs = "0024 _wcstol_r 0028 _impure_ptr"
	strings:
		$1 = { 04 40 2D E5 02 30 A0 E1 18 20 9F E5 00 40 A0 E1 01 C0 A0 E1 00 00 92 E5 04 10 A0 E1 0C 20 A0 E1 10 00 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_0_0 {
	meta:
		name = "wcstoll"
		size = 44
		refs = "0024 _wcstoll_r 0028 _impure_ptr"
	strings:
		$1 = { 04 40 2D E5 02 30 A0 E1 18 20 9F E5 00 40 A0 E1 01 C0 A0 E1 00 00 92 E5 04 10 A0 E1 0C 20 A0 E1 10 00 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_53_1_0 {
	meta:
		name = "wcstoul"
		size = 44
		refs = "0024 _wcstoul_r 0028 _impure_ptr"
	strings:
		$1 = { 04 40 2D E5 02 30 A0 E1 18 20 9F E5 00 40 A0 E1 01 C0 A0 E1 00 00 92 E5 04 10 A0 E1 0C 20 A0 E1 10 00 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_201_0_0 {
	meta:
		name = "wcstoull"
		size = 44
		refs = "0024 _wcstoull_r 0028 _impure_ptr"
	strings:
		$1 = { 04 40 2D E5 02 30 A0 E1 18 20 9F E5 00 40 A0 E1 01 C0 A0 E1 00 00 92 E5 04 10 A0 E1 0C 20 A0 E1 10 00 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_229_0_0 {
	meta:
		name = "write"
		size = 44
		refs = "0024 _write_r 0028 _impure_ptr"
	strings:
		$1 = { 04 40 2D E5 02 30 A0 E1 18 20 9F E5 00 40 A0 E1 01 C0 A0 E1 00 00 92 E5 04 10 A0 E1 0C 20 A0 E1 10 00 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_7_0_0 {
	meta:
		name = "__sprint_r"
		size = 388
		refs = "0094 _malloc_r 00a8 memcpy 00e4 memmove 0130 _realloc_r 0144 _free_r"
	strings:
		$1 = { F0 4F 2D E9 08 50 92 E5 04 D0 4D E2 00 00 55 E3 02 A0 A0 E1 00 00 8D E5 01 40 A0 E1 00 70 92 E5 53 00 00 0A 00 90 A0 E3 09 50 A0 E1 00 00 55 E3 00 00 91 E5 36 00 00 0A 08 60 94 E5 06 00 55 E1 06 80 A0 E1 22 00 00 3A BC 30 D4 E1 12 0D 13 E3 21 00 00 0A 10 10 84 E2 42 00 91 E8 00 80 61 E0 86 60 86 E0 A6 6F 86 E0 01 00 88 E2 C6 60 A0 E1 05 00 80 E0 00 00 56 E1 06 20 A0 E1 00 60 A0 31 06 20 A0 31 01 0B 13 E3 27 00 00 0A 02 10 A0 E1 00 00 9D E5 ?? ?? ?? ?? 00 B0 50 E2 29 00 00 0A 10 10 94 E5 08 20 A0 E1 ?? ?? ?? ?? BC 30 D4 E1 12 3D C3 E3 80 30 83 E3 BC 30 C4 E1 06 30 68 E0 08 00 8B E0 08 30 84 E5 10 B0 84 E5 00 00 84 E5 14 60 84 E5 05 60 A0 E1 05 80 A0 E1 09 10 A0 E1 08 20 A0 E1 ?? ?? ?? ?? 08 30 94 E5 03 60 66 E0 08 60 84 E5 08 30 9A E5 00 00 94 E5 03 50 65 E0 08 00 80 E0 00 00 55 E3 00 00 84 E5 08 50 8A E5 17 00 00 0A 04 50 97 E5 00 00 55 E3 00 90 97 E5 08 70 87 E2 FA FF FF 0A C2 FF FF EA 00 00 9D E5 ?? ?? ?? ?? 00 B0 50 E2 DF FF FF 1A 00 00 9D E5 10 10 94 E5 ?? ?? ?? ?? 00 20 9D E5 0C 30 A0 E3 00 30 82 E5 BC 20 D4 E1 00 30 A0 E3 40 20 82 E3 BC 20 C4 E1 04 30 8A E5 08 30 8A E5 00 00 E0 E3 01 00 00 EA 04 50 8A E5 05 00 A0 E1 04 D0 8D E2 F0 8F BD E8 }
	condition:
		$1
}

rule file_7_1_0 {
	meta:
		name = "_svfiprintf_r"
		size = 3948
		refs = "041c memchr 0e88 strlen 0eac _malloc_r"
	strings:
		$1 = { F0 4F 2D E9 01 B0 A0 E1 BC 10 D1 E1 B4 D0 4D E2 80 00 11 E3 03 80 A0 E1 1C 00 8D E5 02 00 00 0A 10 30 9B E5 00 00 53 E3 9D 03 00 0A 02 60 A0 E1 7C 20 8D E2 00 30 A0 E3 3C 90 8D E2 28 20 82 E2 30 30 8D E5 A4 90 8D E5 AC 30 8D E5 A8 30 8D E5 FC AE 9F E5 18 30 8D E5 34 20 8D E5 09 40 A0 E1 00 30 D6 E5 00 00 53 E3 25 00 53 13 16 00 00 0A 06 50 A0 E1 01 30 F5 E5 25 00 53 E3 00 00 53 13 FB FF FF 1A 06 70 55 E0 05 60 A0 01 0E 00 00 0A A8 30 9D E5 AC 20 9D E5 01 30 83 E2 07 00 53 E3 07 20 82 E0 C0 00 84 E8 AC 20 8D E5 A8 30 8D E5 08 40 84 D2 E4 02 00 CA 18 C0 9D E5 07 C0 8C E0 00 30 D5 E5 18 C0 8D E5 05 60 A0 E1 00 00 53 E3 80 02 00 0A 00 00 A0 E3 00 10 A0 E3 10 00 8D E5 B3 10 CD E5 01 01 8D E9 01 30 86 E2 00 50 E0 E3 2B C0 A0 E3 20 70 A0 E3 03 60 A0 E1 01 20 D6 E4 20 30 42 E2 58 00 53 E3 03 F1 9F 97 A5 01 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 04 30 9D E5 10 30 83 E3 04 30 8D E5 04 C0 9D E5 10 00 1C E3 B7 02 00 0A 08 00 9D E5 00 30 90 E5 04 80 80 E2 00 10 53 E2 01 10 A0 13 01 20 A0 E3 00 C0 A0 E3 B3 C0 CD E5 00 00 55 E3 04 00 9D A5 80 00 C0 A3 04 00 8D A5 00 00 55 E3 01 10 81 13 00 00 51 E3 EA 01 00 0A 01 00 52 E3 8F 02 00 0A 02 00 52 E3 7F 02 00 0A 34 10 9D E5 24 10 8D E5 07 20 03 E2 30 20 82 E2 A3 31 B0 E1 01 20 61 E5 FA FF FF 1A 04 30 9D E5 01 00 13 E3 24 10 8D E5 BC 02 00 0A 30 00 52 E3 F9 02 00 0A 24 20 9D E5 30 30 A0 E3 01 30 62 E5 34 30 9D E5 03 30 62 E0 24 20 8D E5 14 30 8D E5 DD 01 00 EA 04 30 9D E5 10 30 83 E3 04 30 8D E5 04 C0 9D E5 10 20 1C E2 A3 02 00 0A 08 00 9D E5 00 30 90 E5 04 80 80 E2 00 10 53 E2 01 10 A0 13 00 20 A0 E3 CF FF FF EA 04 30 9D E5 10 30 83 E3 04 30 8D E5 04 C0 9D E5 10 00 1C E3 85 02 00 0A 08 00 9D E5 00 30 90 E5 00 00 53 E3 04 80 80 E2 8A 02 00 BA 00 10 A0 03 01 10 A0 13 01 20 A0 E3 C2 FF FF EA 08 10 9D E5 30 20 A0 E3 00 30 91 E5 B0 20 CD E5 78 20 A0 E3 B1 20 CD E5 04 10 9D E9 94 0B 9F E5 02 20 82 E3 04 20 8D E5 00 10 53 E2 01 10 A0 13 04 80 8C E2 30 00 8D E5 02 20 A0 E3 B0 FF FF EA 00 10 A0 E3 08 30 9D E5 B3 10 CD E5 08 20 9D E5 00 30 93 E5 04 20 82 E2 00 00 53 E3 24 30 8D E5 08 20 8D E5 C4 02 00 0A 00 00 55 E3 9A 02 00 BA 24 00 9D E5 00 10 A0 E3 05 20 A0 E1 ?? ?? ?? ?? 00 00 50 E3 9A 02 00 0A 24 10 9D E5 00 00 61 E0 05 00 50 E1 14 00 8D E5 95 02 00 CA 00 C0 A0 E3 20 C0 8D E5 99 01 00 EA 04 20 9D E5 10 20 82 E3 04 20 8D E5 08 20 9D E5 06 30 A0 E1 08 20 8D E5 24 FF FF EA 04 00 9D E5 10 00 10 E3 66 02 00 1A 04 30 9D E5 40 00 13 E3 63 02 00 0A 08 C0 9D E5 18 00 9D E5 00 30 9C E5 04 80 8C E2 B0 00 C3 E1 F2 FE FF EA 06 00 9D E9 10 10 81 E3 04 10 8D E5 06 30 A0 E1 08 20 8D E5 12 FF FF EA 08 C0 9D E5 00 30 9C E5 01 00 A0 E3 00 10 A0 E3 04 C0 8C E2 7C 20 8D E2 0C 00 8D E5 7C 30 CD E5 B3 10 CD E5 08 C0 8D E5 14 00 8D E5 24 20 8D E5 00 10 A0 E3 20 10 8D E5 04 30 9D E5 02 30 13 E2 0C C0 9D 15 04 00 9D E5 02 C0 8C 12 0C C0 8D 15 84 00 10 E2 2C 30 8D E5 28 00 8D E5 B4 00 00 1A 10 10 9D E5 0C 20 9D E5 01 50 62 E0 00 00 55 E3 AF 00 00 DA 10 00 55 E3 6E 02 00 DA 24 0A 9F E5 04 10 A0 E1 AC 20 9D E5 A8 30 9D E5 38 00 8D E5 10 70 A0 E3 A4 80 8D E2 1C 40 9D E5 02 00 00 EA 10 50 45 E2 10 00 55 E3 14 00 00 DA 01 30 83 E2 10 20 82 E2 07 00 53 E3 00 A0 81 E5 04 70 81 E5 AC 20 8D E5 A8 30 8D E5 08 10 81 D2 F3 FF FF DA 04 00 A0 E1 0B 10 A0 E1 08 20 A0 E1 3B FE FF EB 00 00 50 E3 56 01 00 1A 10 50 45 E2 10 00 55 E3 AC 20 9D E5 A8 30 9D E5 09 10 A0 E1 EA FF FF CA 01 40 A0 E1 01 30 83 E2 38 10 9D E5 05 20 82 E0 07 00 53 E3 22 00 84 E8 AC 20 8D E5 A8 30 8D E5 08 40 84 D2 84 00 00 DA 1C 00 9D E5 0B 10 A0 E1 A4 20 8D E2 25 FE FF EB 00 00 50 E3 40 01 00 1A AC 20 9D E5 A8 30 9D E5 09 40 A0 E1 7A 00 00 EA 58 39 9F E5 30 30 8D E5 04 10 9D E5 10 00 11 E3 02 00 00 1A 04 00 9D E5 40 00 10 E3 08 02 00 1A 08 C0 9D E5 00 30 9C E5 04 80 8C E2 04 00 9D E5 00 10 53 E2 01 10 A0 13 01 00 10 E1 30 10 A0 13 B0 10 CD 15 04 10 9D 15 02 10 81 13 B1 20 CD 15 04 10 8D 15 02 20 A0 E3 01 10 A0 13 11 FF FF EA 05 00 9D E9 40 00 80 E3 04 00 8D E5 06 30 A0 E1 08 20 8D E5 A0 FE FF EA 30 10 42 E2 00 00 A0 E3 06 30 A0 E1 01 20 D3 E4 00 01 80 E0 80 00 81 E0 30 10 42 E2 09 00 51 E3 F9 FF FF 9A 10 00 8D E5 03 60 A0 E1 96 FE FF EA 04 30 9D E5 08 20 9D E5 80 30 83 E3 04 30 8D E5 08 20 8D E5 06 30 A0 E1 8D FE FF EA 06 30 A0 E1 01 20 D3 E4 2A 00 52 E3 1A 02 00 0A 30 10 42 E2 09 00 51 E3 00 50 A0 83 EE FF FF 8A 02 60 86 E2 00 50 A0 E3 01 20 56 E5 05 51 85 E0 85 50 81 E0 30 10 42 E2 09 00 51 E3 06 30 A0 E1 01 60 86 E2 F7 FF FF 9A C5 5F 85 E1 03 60 A0 E1 7A FE FF EA 08 20 9D E5 04 10 9D E5 04 10 81 E3 04 10 8D E5 06 30 A0 E1 08 20 8D E5 71 FE FF EA 08 20 9D E5 B3 C0 CD E5 06 30 A0 E1 08 20 8D E5 6C FE FF EA 08 10 9D E5 00 10 91 E5 08 30 9D E5 00 00 51 E3 10 10 8D E5 04 20 83 E2 F0 FF FF AA 10 00 9D E5 00 00 60 E2 10 00 8D E5 E9 FF FF EA 05 00 9D E9 01 00 80 E3 04 00 8D E5 06 30 A0 E1 08 20 8D E5 5B FE FF EA B3 30 DD E5 00 00 53 E3 AE 01 00 1A 08 20 9D E5 B3 70 CD E5 06 30 A0 E1 08 20 8D E5 53 FE FF EA 00 00 52 E3 C9 00 00 0A 01 10 A0 E3 7C 20 CD E5 7C 30 8D E2 00 20 A0 E3 0C 10 8D E5 B3 20 CD E5 14 10 8D E5 24 30 8D E5 41 FF FF EA 7C 07 9F E5 30 00 8D E5 88 FF FF EA AC 20 9D E5 A8 30 9D E5 B3 10 DD E5 00 00 51 E3 0A 00 00 0A 01 30 83 E2 B3 10 8D E2 00 10 84 E5 01 20 82 E2 07 00 53 E3 01 10 A0 E3 04 10 84 E5 AC 20 8D E5 A8 30 8D E5 08 40 84 D2 1A 01 00 CA 2C C0 9D E5 00 00 5C E3 0A 00 00 0A 01 30 83 E2 B0 10 8D E2 00 10 84 E5 02 20 82 E2 07 00 53 E3 02 10 A0 E3 04 10 84 E5 AC 20 8D E5 A8 30 8D E5 08 40 84 D2 16 01 00 CA 28 00 9D E5 80 00 50 E3 AF 00 00 0A 20 00 9D E5 14 10 9D E5 00 50 61 E0 00 00 55 E3 32 00 00 DA 10 00 55 E3 DC 76 9F D5 1D 00 00 DA 04 10 A0 E1 D0 76 9F E5 10 80 A0 E3 1C 40 9D E5 03 00 00 EA 10 50 45 E2 10 00 55 E3 14 00 00 DA AC 20 9D E5 01 30 83 E2 10 20 82 E2 07 00 53 E3 80 01 81 E8 AC 20 8D E5 A8 30 8D E5 08 10 81 D2 F3 FF FF DA 04 00 A0 E1 0B 10 A0 E1 A4 20 8D E2 68 FD FF EB 00 00 50 E3 83 00 00 1A 10 50 45 E2 10 00 55 E3 AC 20 9D E5 A8 30 9D E5 09 10 A0 E1 EA FF FF CA 01 40 A0 E1 01 30 83 E2 05 20 82 E0 07 00 53 E3 00 70 84 E5 04 50 84 E5 AC 20 8D E5 A8 30 8D E5 08 40 84 D2 08 00 00 DA 1C 00 9D E5 0B 10 A0 E1 A4 20 8D E2 52 FD FF EB 00 00 50 E3 6D 00 00 1A AC 20 9D E5 A8 30 9D E5 09 40 A0 E1 14 C0 9D E5 01 30 83 E2 24 00 9D E5 0C 20 82 E0 07 00 53 E3 01 10 84 E8 AC 20 8D E5 A8 30 8D E5 08 40 84 D2 A7 00 00 CA 04 10 9D E5 04 00 11 E3 31 00 00 0A 10 30 9D E5 0C C0 9D E5 03 50 6C E0 00 00 55 E3 BD 00 00 DA 10 00 55 E3 5D 01 00 DA B8 15 9F E5 A8 30 9D E5 38 10 8D E5 10 70 A0 E3 04 10 A0 E1 A4 80 8D E2 1C 40 9D E5 03 00 00 EA 10 50 45 E2 10 00 55 E3 15 00 00 DA AC 20 9D E5 01 30 83 E2 10 20 82 E2 07 00 53 E3 00 A0 81 E5 04 70 81 E5 AC 20 8D E5 A8 30 8D E5 08 10 81 D2 F2 FF FF DA 04 00 A0 E1 0B 10 A0 E1 08 20 A0 E1 20 FD FF EB 00 00 50 E3 3B 00 00 1A 10 50 45 E2 10 00 55 E3 AC 20 9D E5 A8 30 9D E5 09 10 A0 E1 E9 FF FF CA 01 40 A0 E1 01 30 83 E2 38 C0 9D E5 05 20 82 E0 07 00 53 E3 00 C0 84 E5 04 50 84 E5 AC 20 8D E5 A8 30 8D E5 8A 00 00 CA 18 00 9D E5 0C 10 8D E2 0A 00 91 E8 03 00 51 E1 01 00 80 A0 03 00 80 B0 00 00 52 E3 18 00 8D E5 72 00 00 1A 00 C0 A0 E3 A8 C0 8D E5 08 80 9D E5 09 40 A0 E1 79 FD FF EA 00 00 52 E3 23 00 00 1A 04 10 9D E5 01 00 11 E3 20 00 00 0A 30 30 A0 E3 7C 20 8D E2 A3 30 CD E5 27 20 82 E2 01 30 A0 E3 24 20 8D E5 14 30 8D E5 20 50 8D E5 08 80 8D E5 B3 30 DD E5 14 10 9D E5 20 20 9D E5 02 00 51 E1 02 10 A0 B1 00 00 53 E3 0C 10 8D E5 01 10 81 12 0C 10 8D 15 82 FE FF EA AC 30 9D E5 00 00 53 E3 1C 00 9D 15 0B 10 A0 11 A4 20 8D 12 E2 FC FF 1B BC 30 DB E1 18 00 9D E5 40 00 13 E3 00 00 E0 13 18 00 8D E5 18 00 9D E5 B4 D0 8D E2 F0 8F BD E8 34 C0 9D E5 00 00 A0 E3 24 C0 8D E5 14 00 8D E5 E0 FF FF EA 10 10 9D E5 0C C0 9D E5 01 50 6C E0 00 00 55 E3 AC 20 9D D5 49 FF FF DA 10 00 55 E3 18 74 9F D5 1D 00 00 DA 04 10 A0 E1 0C 74 9F E5 10 80 A0 E3 1C 40 9D E5 03 00 00 EA 10 50 45 E2 10 00 55 E3 14 00 00 DA AC 20 9D E5 01 30 83 E2 10 20 82 E2 07 00 53 E3 80 01 81 E8 AC 20 8D E5 A8 30 8D E5 08 10 81 D2 F3 FF FF DA 04 00 A0 E1 0B 10 A0 E1 A4 20 8D E2 B7 FC FF EB 00 00 50 E3 D2 FF FF 1A 10 50 45 E2 10 00 55 E3 AC 20 9D E5 A8 30 9D E5 09 10 A0 E1 EA FF FF CA 01 40 A0 E1 01 30 83 E2 05 20 82 E0 07 00 53 E3 00 70 84 E5 04 50 84 E5 AC 20 8D E5 A8 30 8D E5 08 40 84 D2 1F FF FF DA 1C 00 9D E5 0B 10 A0 E1 A4 20 8D E2 A1 FC FF EB 00 00 50 E3 BC FF FF 1A AC 20 9D E5 A8 30 9D E5 09 40 A0 E1 15 FF FF EA 1C 00 9D E5 0B 10 A0 E1 A4 20 8D E2 97 FC FF EB 00 00 50 E3 B2 FF FF 1A AC 20 9D E5 09 40 A0 E1 4E FF FF EA 1C 00 9D E5 0B 10 A0 E1 A4 20 8D E2 8E FC FF EB 00 00 50 E3 86 FF FF 0A A8 FF FF EA 1C 00 9D E5 0B 10 A0 E1 A4 20 8D E2 87 FC FF EB 00 00 50 E3 A2 FF FF 1A 09 40 A0 E1 12 FD FF EA 1C 00 9D E5 0B 10 A0 E1 A4 20 8D E2 7F FC FF EB 00 00 50 E3 9A FF FF 1A AC 20 9D E5 6C FF FF EA 1C 00 9D E5 0B 10 A0 E1 A4 20 8D E2 77 FC FF EB 00 00 50 E3 92 FF FF 1A AC 20 9D E5 A8 30 9D E5 09 40 A0 E1 DA FE FF EA 1C 00 9D E5 0B 10 A0 E1 A4 20 8D E2 6D FC FF EB 00 00 50 E3 88 FF FF 1A AC 20 9D E5 A8 30 9D E5 09 40 A0 E1 DE FE FF EA 30 00 8D E2 01 10 90 E8 24 C0 8D E5 0C 20 A0 E1 0F 10 03 E2 01 10 D0 E7 23 32 B0 E1 01 10 62 E5 FA FF FF 1A 34 00 9D E5 00 00 62 E0 24 20 8D E5 14 00 8D E5 64 FF FF EA 09 00 53 E3 34 10 9D 95 0A 00 00 9A 34 10 9D E5 38 C2 9F E5 9C 03 82 E0 A2 21 A0 E1 02 01 82 E0 80 00 43 E0 30 00 80 E2 09 00 52 E3 02 30 A0 E1 01 00 61 E5 F5 FF FF 8A 30 30 83 E2 01 20 41 E2 24 20 8D E5 01 30 41 E5 34 30 9D E5 03 30 62 E0 14 30 8D E5 4E FF FF EA 04 10 9D E5 40 00 11 E3 2A 00 00 0A 08 20 9D E5 B0 30 D2 E1 04 80 82 E2 00 10 53 E2 01 10 A0 13 01 20 A0 E3 43 FD FF EA 04 10 9D E5 40 00 11 E3 08 20 9D 15 08 C0 9D 05 F0 30 D2 11 00 30 9C 05 04 80 82 12 04 80 8C 02 00 00 53 E3 74 FD FF AA 2D 20 A0 E3 00 30 63 E2 B3 20 CD E5 00 10 53 E2 01 10 A0 13 01 20 A0 E3 34 FD FF EA 04 30 9D E5 40 10 13 E2 1E 00 00 0A 08 C0 9D E5 B0 30 DC E1 04 80 8C E2 00 10 53 E2 01 10 A0 13 29 FD FF EA 34 C0 9D E5 0C C0 61 E0 14 C0 8D E5 26 FF FF EA 08 10 9D E5 18 20 9D E5 00 30 91 E5 04 80 81 E2 00 20 83 E5 8E FC FF EA 08 C0 9D E5 00 30 9C E5 04 80 8C E2 00 10 53 E2 01 10 A0 13 01 20 A0 E3 18 FD FF EA 08 10 9D E5 B0 30 D1 E1 04 80 81 E2 F5 FD FF EA 08 20 9D E5 06 30 A0 E1 08 20 8D E5 A5 FC FF EA 08 00 9D E5 00 30 90 E5 01 20 A0 E1 04 80 80 E2 00 10 53 E2 01 10 A0 13 09 FD FF EA 00 20 A0 E3 24 00 9D E5 20 20 8D E5 ?? ?? ?? ?? 14 00 8D E5 06 FF FF EA 00 00 A0 E3 14 50 8D E5 20 00 8D E5 02 FF FF EA 40 10 A0 E3 00 20 8D E5 ?? ?? ?? ?? 00 00 50 E3 40 30 A0 13 00 00 8B E5 10 00 8B E5 00 20 9D E5 14 30 8B 15 57 FC FF 1A 1C 00 9D E5 0C 30 A0 E3 00 10 E0 E3 00 30 80 E5 18 10 8D E5 07 FF FF EA 68 C0 9F E5 AC 20 9D E5 A8 30 9D E5 38 C0 8D E5 AD FD FF EA 34 00 9D E5 24 10 9D E5 00 00 61 E0 14 00 8D E5 E6 FE FF EA 40 00 9F E5 A8 30 9D E5 38 00 8D E5 BF FE FF EA 06 00 55 E3 06 50 A0 23 3C C0 9F E5 C5 3F C5 E1 14 50 8D E5 0C 30 8D E5 24 C0 8D E5 67 FD FF EA 08 20 9D E5 00 50 92 E5 04 20 82 E2 C5 5F 85 E1 08 20 8D E5 68 FC FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? CD CC CC CC ?? ?? ?? ?? }
	condition:
		$1
}

rule file_8_0_0 {
	meta:
		name = "wcstok"
		size = 160
	strings:
		$1 = { 00 00 50 E3 70 00 2D E9 20 00 00 0A 00 40 A0 E1 04 50 94 E4 00 30 A0 E3 03 C0 91 E7 00 00 5C E3 04 00 00 0A 0C 00 55 E1 04 30 83 E2 F9 FF FF 1A 04 00 A0 E1 F4 FF FF EA 00 00 55 E3 00 50 82 05 05 00 A0 01 04 00 00 1A 0E 00 00 EA 00 00 5C E3 04 30 83 E2 03 00 00 1A 05 40 A0 E1 04 50 A0 E1 04 60 95 E4 00 30 A0 E3 03 C0 91 E7 0C 00 56 E1 F5 FF FF 1A 00 00 56 E3 06 50 A0 01 00 30 A0 13 00 30 84 15 00 50 82 E5 70 00 BD E8 1E FF 2F E1 00 00 92 E5 00 00 50 E3 DB FF FF 1A F9 FF FF EA }
	condition:
		$1
}

rule file_9_0_0 {
	meta:
		name = "wcslcat"
		size = 168
		refs = "009c wcslen"
	strings:
		$1 = { 00 30 90 E5 00 00 53 E3 10 40 2D E9 00 C0 A0 01 03 40 A0 01 0B 00 00 0A 00 00 52 E3 1C 00 00 0A 02 30 A0 E1 00 C0 A0 E1 01 00 00 EA 01 30 53 E2 02 00 00 0A 04 40 BC E5 00 00 54 E3 FA FF FF 1A 0C 00 60 E0 40 41 A0 E1 04 20 52 E0 11 00 00 0A 00 30 91 E5 00 00 53 E3 03 00 A0 01 08 00 00 0A 01 00 A0 E1 01 00 52 E3 04 30 8C 14 04 30 B0 E5 01 20 42 12 00 00 53 E3 F9 FF FF 1A 00 00 61 E0 40 01 A0 E1 00 30 A0 E3 00 30 8C E5 04 00 80 E0 10 80 BD E8 02 40 A0 E1 01 00 A0 E1 ?? ?? ?? ?? 04 00 80 E0 10 80 BD E8 }
	condition:
		$1
}

rule file_10_0_0 {
	meta:
		name = "_fcntl_r"
		size = 64
		refs = "0020 _fcntl 003c errno"
	strings:
		$1 = { 30 40 2D E9 30 40 9F E5 00 50 A0 E1 01 00 A0 E1 02 10 A0 E1 03 20 A0 E1 00 30 A0 E3 00 30 84 E5 ?? ?? ?? ?? 01 00 70 E3 30 80 BD 18 00 30 94 E5 00 00 53 E3 00 30 85 15 30 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_312_2_0 {
	meta:
		name = "_execve_r"
		size = 64
		refs = "0020 _execve 003c errno"
	strings:
		$1 = { 30 40 2D E9 30 40 9F E5 00 50 A0 E1 01 00 A0 E1 02 10 A0 E1 03 20 A0 E1 00 30 A0 E3 00 30 84 E5 ?? ?? ?? ?? 01 00 70 E3 30 80 BD 18 00 30 94 E5 00 00 53 E3 00 30 85 15 30 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_179_0_0 {
	meta:
		name = "_lseek_r"
		size = 64
		refs = "0020 _lseek 003c errno"
	strings:
		$1 = { 30 40 2D E9 30 40 9F E5 00 50 A0 E1 01 00 A0 E1 02 10 A0 E1 03 20 A0 E1 00 30 A0 E3 00 30 84 E5 ?? ?? ?? ?? 01 00 70 E3 30 80 BD 18 00 30 94 E5 00 00 53 E3 00 30 85 15 30 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_55_0_0 {
	meta:
		name = "_open_r"
		size = 64
		refs = "0020 _open 003c errno"
	strings:
		$1 = { 30 40 2D E9 30 40 9F E5 00 50 A0 E1 01 00 A0 E1 02 10 A0 E1 03 20 A0 E1 00 30 A0 E3 00 30 84 E5 ?? ?? ?? ?? 01 00 70 E3 30 80 BD 18 00 30 94 E5 00 00 53 E3 00 30 85 15 30 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_356_0_0 {
	meta:
		name = "_read_r"
		size = 64
		refs = "0020 _read 003c errno"
	strings:
		$1 = { 30 40 2D E9 30 40 9F E5 00 50 A0 E1 01 00 A0 E1 02 10 A0 E1 03 20 A0 E1 00 30 A0 E3 00 30 84 E5 ?? ?? ?? ?? 01 00 70 E3 30 80 BD 18 00 30 94 E5 00 00 53 E3 00 30 85 15 30 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_404_0_0 {
	meta:
		name = "_write_r"
		size = 64
		refs = "0020 _write 003c errno"
	strings:
		$1 = { 30 40 2D E9 30 40 9F E5 00 50 A0 E1 01 00 A0 E1 02 10 A0 E1 03 20 A0 E1 00 30 A0 E3 00 30 84 E5 ?? ?? ?? ?? 01 00 70 E3 30 80 BD 18 00 30 94 E5 00 00 53 E3 00 30 85 15 30 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_11_0_0 {
	meta:
		name = "iswupper"
		size = 24
		refs = "0008 towlower"
	strings:
		$1 = { 10 40 2D E9 00 40 A0 E1 ?? ?? ?? ?? 04 00 50 E0 01 00 A0 13 10 80 BD E8 }
	condition:
		$1
}

rule file_151_0_0 {
	meta:
		name = "iswlower"
		size = 24
		refs = "0008 towupper"
	strings:
		$1 = { 10 40 2D E9 00 40 A0 E1 ?? ?? ?? ?? 04 00 50 E0 01 00 A0 13 10 80 BD E8 }
	condition:
		$1
}

rule file_12_0_0 {
	meta:
		name = "_fscanf_r"
		size = 48
		refs = "001c __svfscanf_r"
	strings:
		$1 = { 0C 00 2D E9 04 E0 2D E5 04 D0 4D E2 0C C0 8D E2 0C 30 A0 E1 08 20 9D E5 00 C0 8D E5 ?? ?? ?? ?? 04 D0 8D E2 04 E0 9D E4 08 D0 8D E2 1E FF 2F E1 }
	condition:
		$1
}

rule file_245_1_0 {
	meta:
		name = "_diprintf_r"
		size = 48
		refs = "001c _vdiprintf_r"
	strings:
		$1 = { 0C 00 2D E9 04 E0 2D E5 04 D0 4D E2 0C C0 8D E2 0C 30 A0 E1 08 20 9D E5 00 C0 8D E5 ?? ?? ?? ?? 04 D0 8D E2 04 E0 9D E4 08 D0 8D E2 1E FF 2F E1 }
	condition:
		$1
}

rule file_101_1_0 {
	meta:
		name = "_dprintf_r"
		size = 48
		refs = "001c _vdprintf_r"
	strings:
		$1 = { 0C 00 2D E9 04 E0 2D E5 04 D0 4D E2 0C C0 8D E2 0C 30 A0 E1 08 20 9D E5 00 C0 8D E5 ?? ?? ?? ?? 04 D0 8D E2 04 E0 9D E4 08 D0 8D E2 1E FF 2F E1 }
	condition:
		$1
}

rule file_164_1_0 {
	meta:
		name = "_fiprintf_r"
		size = 48
		refs = "001c _vfiprintf_r"
	strings:
		$1 = { 0C 00 2D E9 04 E0 2D E5 04 D0 4D E2 0C C0 8D E2 0C 30 A0 E1 08 20 9D E5 00 C0 8D E5 ?? ?? ?? ?? 04 D0 8D E2 04 E0 9D E4 08 D0 8D E2 1E FF 2F E1 }
	condition:
		$1
}

rule file_468_0_0 {
	meta:
		name = "_fiscanf_r"
		size = 48
		refs = "001c __svfiscanf_r"
	strings:
		$1 = { 0C 00 2D E9 04 E0 2D E5 04 D0 4D E2 0C C0 8D E2 0C 30 A0 E1 08 20 9D E5 00 C0 8D E5 ?? ?? ?? ?? 04 D0 8D E2 04 E0 9D E4 08 D0 8D E2 1E FF 2F E1 }
	condition:
		$1
}

rule file_237_1_0 {
	meta:
		name = "_fprintf_r"
		size = 48
		refs = "001c _vfprintf_r"
	strings:
		$1 = { 0C 00 2D E9 04 E0 2D E5 04 D0 4D E2 0C C0 8D E2 0C 30 A0 E1 08 20 9D E5 00 C0 8D E5 ?? ?? ?? ?? 04 D0 8D E2 04 E0 9D E4 08 D0 8D E2 1E FF 2F E1 }
	condition:
		$1
}

rule file_12_1_0 {
	meta:
		name = "fscanf"
		size = 64
		refs = "0028 __svfscanf_r 003c _impure_ptr"
	strings:
		$1 = { 0E 00 2D E9 04 E0 2D E5 2C 30 9F E5 04 D0 4D E2 0C C0 8D E2 00 10 A0 E1 08 20 9D E5 00 00 93 E5 0C 30 A0 E1 00 C0 8D E5 ?? ?? ?? ?? 04 D0 8D E2 04 E0 9D E4 0C D0 8D E2 1E FF 2F E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_245_0_0 {
	meta:
		name = "diprintf"
		size = 64
		refs = "0028 _vdiprintf_r 003c _impure_ptr"
	strings:
		$1 = { 0E 00 2D E9 04 E0 2D E5 2C 30 9F E5 04 D0 4D E2 0C C0 8D E2 00 10 A0 E1 08 20 9D E5 00 00 93 E5 0C 30 A0 E1 00 C0 8D E5 ?? ?? ?? ?? 04 D0 8D E2 04 E0 9D E4 0C D0 8D E2 1E FF 2F E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_164_0_0 {
	meta:
		name = "fiprintf"
		size = 64
		refs = "0028 _vfiprintf_r 003c _impure_ptr"
	strings:
		$1 = { 0E 00 2D E9 04 E0 2D E5 2C 30 9F E5 04 D0 4D E2 0C C0 8D E2 00 10 A0 E1 08 20 9D E5 00 00 93 E5 0C 30 A0 E1 00 C0 8D E5 ?? ?? ?? ?? 04 D0 8D E2 04 E0 9D E4 0C D0 8D E2 1E FF 2F E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_468_1_0 {
	meta:
		name = "fiscanf"
		size = 64
		refs = "0028 __svfiscanf_r 003c _impure_ptr"
	strings:
		$1 = { 0E 00 2D E9 04 E0 2D E5 2C 30 9F E5 04 D0 4D E2 0C C0 8D E2 00 10 A0 E1 08 20 9D E5 00 00 93 E5 0C 30 A0 E1 00 C0 8D E5 ?? ?? ?? ?? 04 D0 8D E2 04 E0 9D E4 0C D0 8D E2 1E FF 2F E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_237_0_0 {
	meta:
		name = "fprintf"
		size = 64
		refs = "0028 _vfprintf_r 003c _impure_ptr"
	strings:
		$1 = { 0E 00 2D E9 04 E0 2D E5 2C 30 9F E5 04 D0 4D E2 0C C0 8D E2 00 10 A0 E1 08 20 9D E5 00 00 93 E5 0C 30 A0 E1 00 C0 8D E5 ?? ?? ?? ?? 04 D0 8D E2 04 E0 9D E4 0C D0 8D E2 1E FF 2F E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_13_0_0 {
	meta:
		name = "strspn"
		size = 112
	strings:
		$1 = { 30 00 2D E9 00 30 D0 E5 00 00 53 E3 03 00 A0 01 0E 00 00 0A 00 50 D1 E5 00 00 55 E3 00 40 A0 11 10 00 00 0A 05 00 53 E1 01 20 A0 11 03 00 00 1A 08 00 00 EA 0C 00 53 E1 01 20 82 E2 05 00 00 0A 01 C0 D2 E5 00 00 5C E3 F9 FF FF 1A 04 00 60 E0 30 00 BD E8 1E FF 2F E1 01 30 F4 E5 00 00 53 E3 EF FF FF 1A F8 FF FF EA 05 00 A0 E1 F7 FF FF EA }
	condition:
		$1
}

rule file_14_0_0 {
	meta:
		name = "_pvalloc_r"
		size = 24
		refs = "0014 _memalign_r"
	strings:
		$1 = { FF 2E 81 E2 0F 20 82 E2 FF 2E C2 E3 0F 20 C2 E3 01 1A A0 E3 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_15_0_0 {
	meta:
		name = "iso_year_adjust"
		size = 384
	strings:
		$1 = { 14 30 90 E5 76 2E A0 E3 03 00 13 E3 0C 20 82 E2 16 00 00 1A 00 00 53 E3 63 20 E0 A3 58 11 9F E5 03 20 82 E0 92 C1 C1 E0 C2 CF A0 E1 C1 12 6C E0 01 11 81 E0 01 11 81 E0 01 01 52 E1 01 20 A0 13 0A 00 00 0A 18 10 80 E2 0A 00 91 E8 03 32 A0 E1 81 30 83 E0 02 30 83 E0 21 00 53 E3 18 00 00 CA 20 00 53 E3 37 00 00 BA 00 00 E0 E3 1E FF 2F E1 76 2E A0 E3 00 00 53 E3 0C 20 82 E2 63 20 E0 A3 03 30 82 E0 F0 20 9F E5 93 12 C2 E0 C3 1F A0 E1 C2 23 61 E0 02 21 82 E0 02 21 82 E0 02 02 53 E1 18 10 80 E2 0A 00 91 E8 03 32 A0 E1 00 20 A0 13 01 20 A0 03 81 30 83 E0 02 30 83 E0 21 00 53 E3 E6 FF FF DA 5B 2D A0 E3 06 20 82 E2 02 00 53 E1 0D 00 00 DA 5B 2D A0 E3 15 20 82 E2 02 00 53 E1 16 00 00 0A 5B 2D A0 E3 17 20 82 E2 02 00 53 E1 12 00 00 0A 5B 2D A0 E3 13 20 82 E2 02 00 53 E1 0E 00 00 0A 00 00 A0 E3 1E FF 2F E1 5B 2D A0 E3 02 20 82 E2 02 00 53 E1 08 00 00 AA 5A 2D A0 E3 22 20 82 E2 02 00 53 E1 04 00 00 0A F4 FF FF BA 5A 3D 43 E2 32 30 43 E2 02 00 53 E3 F0 FF FF 8A 01 00 A0 E3 1E FF 2F E1 0D 00 53 E3 05 00 00 DA 10 00 53 E3 EA FF FF BA 11 00 53 E3 C1 FF FF DA 1C 30 43 E2 01 00 00 EA 0A 00 53 E3 BD FF FF AA 01 00 53 E3 E2 FF FF 8A BA FF FF EA 1F 85 EB 51 }
	condition:
		$1
}

rule file_15_1_0 {
	meta:
		name = "strftime"
		size = 3844
		refs = "01fc sprintf 0298 snprintf 03d0 __gettzinfo 03d8 __tz_lock 03fc __tz_unlock 041c labs 0738 strftime 07fc strlen 0d24 __modsi3 0d98 abs 0eb0 _tzname"
	strings:
		$1 = { F0 4F 2D E9 76 9E A0 E3 A0 BE 9F E5 A0 AE 9F E5 1C D0 4D E2 00 60 A0 E1 01 80 A0 E1 02 50 A0 E1 03 70 A0 E1 0B 90 89 E2 00 40 A0 E3 00 30 D5 E5 25 00 53 E3 00 00 53 13 79 00 00 1A 00 00 53 E3 F4 02 00 0A 01 00 D5 E5 01 50 85 E2 45 00 50 E3 4F 00 50 13 01 00 F5 05 25 30 40 E2 55 00 53 E3 03 F1 9F 97 67 00 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 02 30 48 E2 03 00 54 E1 36 00 00 2A 14 00 97 E5 00 00 50 E3 2F 03 00 BA D8 2C 9F E5 90 12 C2 E0 C0 3F A0 E1 C2 22 63 E0 02 21 82 E0 02 21 82 E0 02 21 40 E0 04 00 86 E0 BC 1C 9F E5 ?? ?? ?? ?? 00 00 D5 E5 02 40 84 E2 00 00 50 E3 81 02 00 0A 01 50 85 E2 00 30 D5 E5 25 00 53 E3 00 00 53 13 85 FF FF 0A 01 20 48 E2 02 00 54 E1 1D 00 00 2A 04 30 C6 E7 01 50 85 E2 01 40 84 E2 7A FF FF EA 14 00 97 E5 76 CE E0 E3 0B C0 4C E2 0C 00 50 E1 00 C0 A0 A3 01 C0 A0 B3 00 00 50 E3 D8 02 00 BA 50 EC 9F E5 90 1E CE E0 C0 0F A0 E1 CE E2 60 E0 13 E0 8E E2 44 2C 9F E5 00 00 5C E3 40 3C 9F E5 04 00 86 E0 02 30 A0 11 08 10 64 E0 02 C0 6C E2 30 2C 9F E5 00 50 8D E8 ?? ?? ?? ?? 00 40 84 E0 04 00 58 E1 19 00 00 8A 00 40 A0 E3 04 00 A0 E1 1C D0 8D E2 F0 8F BD E8 10 20 97 E5 02 31 9A E7 00 00 53 E3 D1 FF FF DA 01 C0 48 E2 0C 00 54 E1 F4 FF FF 2A 00 30 A0 E3 04 10 86 E0 01 00 00 EA 0C 00 54 E1 EF FF FF 2A 02 21 8A E0 68 20 92 E5 03 20 D2 E7 03 20 C1 E7 10 20 97 E5 02 01 9A E7 01 30 83 E2 03 00 50 E1 01 40 84 E2 F3 FF FF CA 00 00 D5 E5 00 00 50 E3 BC FF FF 1A 3D 02 00 EA 18 20 97 E5 02 21 A0 E1 02 30 8A E0 30 30 93 E5 00 00 53 E3 B5 FF FF DA 01 C0 48 E2 0C 00 54 E1 D8 FF FF 2A 00 30 A0 E3 04 10 86 E0 01 00 00 EA 04 00 5C E1 D3 FF FF 9A 02 20 8A E0 4C 20 92 E5 03 20 D2 E7 03 20 C1 E7 18 20 97 E5 02 21 A0 E1 02 00 8A E0 30 00 90 E5 01 30 83 E2 03 00 50 E1 01 40 84 E2 F1 FF FF CA 00 00 D5 E5 E0 FF FF EA 01 30 48 E2 03 00 54 E1 C2 FF FF 2A 25 30 A0 E3 04 30 C6 E7 00 00 D5 E5 00 00 50 E3 01 40 84 E2 96 FF FF 1A 17 02 00 EA 20 30 97 E5 00 00 53 E3 92 FF FF BA 05 30 48 E2 03 00 54 E1 B5 FF FF 2A ?? ?? ?? ?? 14 00 8D E5 ?? ?? ?? ?? 20 30 97 E5 14 00 9D E5 00 00 53 E3 20 30 A0 D3 3C 30 A0 C3 03 10 90 E7 00 10 61 E2 14 10 8D E5 ?? ?? ?? ?? 14 10 9D E5 C0 EA 9F E5 9E 21 C0 E0 C1 2F A0 E1 01 00 80 E0 C0 02 62 E0 10 20 8D E5 ?? ?? ?? ?? A4 3A 9F E5 93 E0 CC E0 14 10 9D E5 9C EA 9F E5 91 3E CE E0 00 C0 8C E0 C0 3F A0 E1 CC 32 63 E0 03 C3 A0 E1 10 20 9D E5 01 10 8E E0 03 31 4C E0 C1 25 62 E0 00 30 63 E0 74 1A 9F E5 04 00 86 E0 ?? ?? ?? ?? 00 00 D5 E5 00 00 50 E3 05 40 84 E2 66 FF FF 1A E7 01 00 EA 01 30 48 E2 03 00 54 E1 88 FF FF 2A 18 30 97 E5 30 30 83 E2 04 30 C6 E7 01 40 84 E2 00 00 D5 E5 9D FF FF EA 01 30 48 E2 03 00 54 E1 7F FF FF 2A 18 30 97 E5 00 00 53 E3 37 30 A0 03 04 30 C6 07 01 40 84 02 F1 FF FF 1A 00 00 D5 E5 92 FF FF EA 01 30 48 E2 03 00 54 E1 74 FF FF 2A 09 30 A0 E3 04 30 C6 E7 01 40 84 E2 00 00 D5 E5 8A FF FF EA 0B 30 48 E2 03 00 54 E1 6C FF FF 2A 08 30 97 E5 00 00 53 E3 0C 00 53 13 D9 01 00 1A 31 20 A0 E3 04 20 C6 E7 01 30 84 E2 32 20 A0 E3 03 20 C6 E7 01 40 83 E2 3A 30 A0 E3 04 30 C6 E7 01 00 84 E2 8C 19 9F E5 04 20 97 E5 00 00 86 E0 0C 30 8D E5 ?? ?? ?? ?? 0C 30 9D E5 03 20 84 E2 02 30 C6 E7 04 00 84 E2 00 20 97 E5 00 00 86 E0 60 19 9F E5 ?? ?? ?? ?? 20 20 A0 E3 06 30 84 E2 03 20 C6 E7 08 30 97 E5 0B 00 53 E3 41 20 A0 D3 07 30 84 E2 50 20 A0 C3 03 20 C6 D7 08 40 84 D2 03 20 C6 C7 08 40 84 C2 0A 00 00 EA 02 30 48 E2 03 00 54 E1 42 FF FF 2A 08 30 97 E5 0B 00 53 E3 41 30 A0 D3 50 30 A0 C3 04 30 C6 D7 04 30 C6 C7 01 40 84 D2 01 40 84 C2 4D 30 A0 E3 04 30 C6 E7 00 00 D5 E5 00 00 50 E3 01 40 84 E2 0E FF FF 1A 8F 01 00 EA 01 30 48 E2 03 00 54 E1 30 FF FF 2A 0A 30 A0 E3 04 30 C6 E7 00 00 D5 E5 00 00 50 E3 01 40 84 E2 04 FF FF 1A 85 01 00 EA 02 30 48 E2 03 00 54 E1 26 FF FF 2A 10 20 97 E5 01 20 82 E2 F6 FE FF EA 03 30 48 E2 03 00 54 E1 20 FF FF 2A 1C 20 97 E5 04 00 86 E0 01 20 82 E2 A0 18 9F E5 ?? ?? ?? ?? 00 00 D5 E5 00 00 50 E3 03 40 84 E2 F1 FE FF 1A 72 01 00 EA 02 30 48 E2 03 00 54 E1 13 FF FF 2A 07 00 A0 E1 07 FE FF EB 00 30 A0 E1 14 00 97 E5 00 00 50 E3 DE 01 00 BA 40 18 9F E5 90 21 C1 E0 C0 2F A0 E1 C1 22 62 E0 02 21 82 E0 02 21 82 E0 02 21 40 E0 00 00 53 E3 8E 01 00 BA 04 00 00 0A 76 1E E0 E3 14 00 97 E5 0B 10 41 E2 01 00 50 E1 00 30 E0 B3 04 18 9F E5 02 30 83 E0 91 23 C0 E0 C3 2F A0 E1 C0 22 62 E0 02 21 82 E0 02 21 82 E0 02 31 43 E0 64 30 83 E2 93 E1 C1 E0 C3 2F A0 E1 C1 22 62 E0 02 21 82 E0 02 21 82 E0 02 21 43 E0 C1 FE FF EA 02 30 48 E2 03 00 54 E1 EB FE FF 2A BC 37 9F E5 64 00 50 E3 D4 17 9F E5 04 00 86 E0 03 10 A0 01 0C 20 97 E5 ?? ?? ?? ?? 00 00 D5 E5 00 00 50 E3 02 40 84 E2 BA FE FF 1A 3B 01 00 EA 04 00 86 E0 08 10 64 E0 A8 27 9F E5 07 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 D8 FE FF 0A 00 40 84 E0 00 00 D5 E5 00 00 50 E3 AE FE FF 1A 2F 01 00 EA 01 10 48 E2 00 30 A0 E3 04 00 86 E0 01 00 54 E1 CE FE FF 2A 10 20 97 E5 02 21 8A E0 68 20 92 E5 03 20 D2 E7 03 20 C0 E7 01 30 83 E2 03 00 53 E3 01 40 84 E2 F4 FF FF 1A 00 00 D5 E5 DE FE FF EA 01 10 48 E2 00 30 A0 E3 04 00 86 E0 01 00 54 E1 BE FE FF 2A 18 20 97 E5 02 21 8A E0 4C 20 92 E5 03 20 D2 E7 03 20 C0 E7 01 30 83 E2 03 00 53 E3 01 40 84 E2 F4 FF FF 1A 00 00 D5 E5 CE FE FF EA 20 30 97 E5 00 00 53 E3 8A FE FF BA ?? ?? ?? ?? 20 30 97 E5 00 00 53 E3 04 30 A0 C3 00 30 A0 D3 03 00 9B E7 ?? ?? ?? ?? 00 00 50 E3 12 00 00 DA 01 C0 48 E2 0C 00 54 E1 34 01 00 2A 00 30 A0 E3 04 10 86 E0 01 00 00 EA 0C 00 54 E1 2F 01 00 2A 20 20 97 E5 00 00 52 E3 04 20 A0 C3 00 20 A0 D3 02 20 9B E7 03 20 D2 E7 03 20 C1 E7 01 30 83 E2 03 00 50 E1 01 40 84 E2 F2 FF FF CA ?? ?? ?? ?? 00 00 D5 E5 69 FE FF EA 04 00 86 E0 08 10 64 E0 74 26 9F E5 07 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 B1 FF FF 1A 89 FE FF EA 02 30 48 E2 03 00 54 E1 86 FE FF 2A 18 30 97 E5 1C 20 97 E5 00 00 53 E3 07 20 82 E2 06 30 A0 03 01 30 43 12 3C 16 9F E5 02 30 63 E0 93 E1 C1 E0 C3 2F A0 E1 03 30 81 E0 43 21 62 E0 4C FE FF EA 02 30 48 E2 03 00 54 E1 76 FE FF 2A 07 00 A0 E1 6A FD FF EB 18 30 97 E5 00 00 53 E3 06 30 A0 03 01 30 43 12 00 00 50 E3 1C 20 97 E5 01 20 A0 C3 3F FE FF CA FE 00 00 1A 0A 20 82 E2 E4 15 9F E5 02 30 63 E0 93 21 C1 E0 C3 2F A0 E1 03 30 81 E0 43 21 62 E0 36 FE FF EA 02 30 48 E2 03 00 54 E1 60 FE FF 2A 1C 20 97 E5 18 30 97 E5 07 20 82 E2 B0 15 9F E5 02 30 63 E0 93 01 C1 E0 C3 2F A0 E1 03 30 81 E0 43 21 62 E0 29 FE FF EA 08 30 48 E2 03 00 54 E1 53 FE FF 2A 00 C0 97 E5 08 20 97 E5 04 30 97 E5 04 00 86 E0 7C 15 9F E5 00 C0 8D E5 ?? ?? ?? ?? 00 00 D5 E5 00 00 50 E3 08 40 84 E2 22 FE FF 1A A3 00 00 EA 02 30 48 E2 03 00 54 E1 44 FE FF 2A 04 00 86 E0 1C 15 9F E5 00 20 97 E5 ?? ?? ?? ?? 00 00 D5 E5 00 00 50 E3 02 40 84 E2 16 FE FF 1A 97 00 00 EA 05 30 48 E2 03 00 54 E1 38 FE FF 2A 04 00 86 E0 20 15 9F E5 08 20 97 E5 04 30 97 E5 ?? ?? ?? ?? 00 00 D5 E5 00 00 50 E3 05 40 84 E2 09 FE FF 1A 8A 00 00 EA 02 30 48 E2 03 00 54 E1 2B FE FF 2A 04 00 86 E0 B8 14 9F E5 04 20 97 E5 ?? ?? ?? ?? 00 00 D5 E5 00 00 50 E3 02 40 84 E2 FD FD FF 1A 7E 00 00 EA 02 30 48 E2 03 00 54 E1 1F FE FF 2A 08 30 97 E5 00 00 53 E3 0C 00 53 13 7B 00 00 1A 31 20 A0 E3 04 20 C6 E7 01 30 84 E2 32 20 A0 E3 03 20 C6 E7 00 00 D5 E5 00 00 50 E3 01 40 83 E2 EC FD FF 1A 6D 00 00 EA 02 30 48 E2 03 00 54 E1 0E FE FF 2A 68 34 9F E5 6B 00 50 E3 40 14 9F E5 04 00 86 E0 03 10 A0 01 08 20 97 E5 ?? ?? ?? ?? 00 00 D5 E5 00 00 50 E3 02 40 84 E2 DD FD FF 1A 5E 00 00 EA 14 30 97 E5 07 00 A0 E1 0C 30 8D E5 F4 FC FF EB 0C 30 9D E5 00 00 53 E3 00 20 A0 E1 D8 00 00 BA F4 03 9F E5 93 10 C0 E0 C3 1F A0 E1 C0 12 61 E0 13 10 81 E2 18 10 8D E5 03 10 A0 E1 D8 C3 9F E5 91 EC CC E0 C1 0F A0 E1 CC C2 60 E0 0C C1 8C E0 0C C1 8C E0 0C C1 41 E0 00 00 52 E3 6B 00 00 BA 76 1E E0 E3 0B 10 41 E2 01 00 53 E1 00 30 A0 A3 01 30 A0 B3 00 00 52 E3 00 10 A0 D3 01 10 03 C2 00 00 51 E3 01 E0 A0 13 00 20 E0 13 0E 30 A0 11 02 E0 63 02 0C C0 82 E0 01 00 7C E3 56 00 00 0A 64 00 5C E3 18 10 9D 05 01 10 81 02 18 10 8D 05 00 C0 A0 03 68 23 9F E5 68 13 9F E5 00 00 53 E3 00 E0 8D E5 18 E0 9D E5 01 30 A0 01 02 30 A0 11 04 00 86 E0 08 10 64 E0 78 23 9F E5 04 E0 8D E5 08 C0 8D E5 ?? ?? ?? ?? 00 40 84 E0 04 00 58 E1 C5 FD FF 9A 00 00 D5 E5 DE FD FF EA 04 00 86 E0 08 10 64 E0 50 23 9F E5 07 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 E3 FE FF 1A BB FD FF EA 08 30 48 E2 03 00 54 E1 B8 FD FF 2A 14 00 97 E5 00 00 50 E3 10 20 97 E5 0C 30 97 E5 6B 00 00 BA D8 C2 9F E5 90 EC CC E0 C0 1F A0 E1 CC C2 61 E0 0C C1 8C E0 0C C1 8C E0 0C C1 40 E0 04 00 86 E0 01 20 82 E2 F8 12 9F E5 00 C0 8D E5 ?? ?? ?? ?? 00 00 D5 E5 00 00 50 E3 08 40 84 E2 7D FD FF 1A 00 00 58 E3 00 30 A0 13 04 30 C6 17 A0 FD FF EA D0 12 9F E5 93 21 C1 E0 C3 2F A0 E1 C1 20 62 E0 9C C2 9F E5 49 00 50 E3 82 20 82 E0 70 12 9F E5 04 00 86 E0 0C 10 A0 11 02 21 43 E0 ?? ?? ?? ?? 00 00 D5 E5 00 00 50 E3 02 40 84 E2 69 FD FF 1A EA FF FF EA 8C 12 9F E5 93 E1 C1 E0 C3 2F A0 E1 C1 20 62 E0 82 20 82 E0 04 00 86 E0 02 21 43 E0 2C 12 9F E5 ?? ?? ?? ?? 02 40 84 E2 20 FE FF EA 18 00 9D E5 01 00 40 E2 18 00 8D E5 63 C0 A0 E3 A8 FF FF EA 76 1E E0 E3 14 00 97 E5 0A 10 41 E2 01 00 50 E1 01 20 A0 B3 02 E0 A0 B1 02 30 A0 B1 98 FF FF BA 8A FF FF EA 76 1E E0 E3 14 00 97 E5 0A 10 41 E2 01 00 50 E1 01 30 A0 B3 70 FE FF EA ?? ?? ?? ?? 00 40 A0 E3 6D FD FF EA 14 C0 97 E5 00 00 5C E3 09 10 A0 B1 64 10 E0 A3 0C 10 81 E0 03 00 11 E3 0B 00 00 1A 01 00 A0 E1 64 10 A0 E3 10 20 8D E5 0C 30 8D E5 14 C0 8D E5 ?? ?? ?? ?? 00 00 50 E3 10 20 9D E5 0C 30 9D E5 14 C0 9D E5 01 00 A0 13 0B 00 00 1A 00 00 5C E3 09 00 A0 B1 64 00 E0 A3 0C 00 80 E0 19 1E A0 E3 10 20 8D E5 0C 30 8D E5 ?? ?? ?? ?? 0C 30 9D E5 10 20 9D E5 01 00 70 E2 00 00 A0 33 03 20 62 E0 02 20 60 E0 04 00 52 E3 35 20 A0 D3 34 20 A0 C3 1A FD FF EA 76 0E 80 E2 0C 00 80 E2 10 20 8D E5 0C 30 8D E5 ?? ?? ?? ?? 14 C1 9F E5 90 1C CC E0 C0 1F A0 E1 CC C2 61 E0 0C C1 8C E0 0C C1 8C E0 0C C1 40 E0 0C 30 9D E5 10 20 9D E5 8B FF FF EA 76 0E 80 E2 0C 00 80 E2 14 C0 8D E5 ?? ?? ?? ?? DC E0 9F E5 90 2E CE E0 C0 0F A0 E1 CE E2 60 E0 14 C0 9D E5 21 FD FF EA 76 0E 80 E2 0C 00 80 E2 0C 30 8D E5 ?? ?? ?? ?? B4 10 9F E5 90 E1 C1 E0 C0 2F A0 E1 C1 22 62 E0 02 21 82 E0 02 21 82 E0 02 21 40 E0 0C 30 9D E5 1A FE FF EA 76 0E 83 E2 0C 00 80 E2 10 20 8D E5 0C 30 8D E5 ?? ?? ?? ?? 7C E0 9F E5 9E 10 CC E0 14 10 97 E5 C0 0F A0 E1 CC 02 60 E0 00 00 51 E3 18 00 8D E5 10 20 9D E5 0C 30 9D E5 1E FF FF AA 76 0E 81 E2 0C 00 80 E2 10 20 8D E5 0C 30 8D E5 ?? ?? ?? ?? 40 10 9F E5 91 E0 CC E0 C0 1F A0 E1 CC C2 61 E0 0C C1 8C E0 0C C1 8C E0 0C C1 40 E0 0C 30 9D E5 10 20 9D E5 16 FF FF EA 76 0E 80 E2 0C 00 80 E2 ?? ?? ?? ?? 0C 20 9F E5 90 32 C2 E0 CB FC FF EA ?? ?? ?? ?? ?? ?? ?? ?? 1F 85 EB 51 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 89 88 88 88 C5 B3 A2 91 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 93 24 49 92 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? AB AA AA 2A }
	condition:
		$1
}

rule file_16_0_0 {
	meta:
		name = "wmemcmp"
		size = 92
	strings:
		$1 = { 00 00 52 E3 04 40 2D E5 0C 00 00 0A 00 40 90 E5 00 C0 91 E5 0C 00 54 E1 00 30 A0 03 04 00 00 0A 09 00 00 EA 03 41 90 E7 03 C1 91 E7 0C 00 54 E1 05 00 00 1A 01 30 83 E2 03 00 52 E1 F8 FF FF 8A 00 00 A0 E3 10 00 BD E8 1E FF 2F E1 0C 00 54 E1 01 00 A0 C3 00 00 E0 D3 F9 FF FF EA }
	condition:
		$1
}

rule file_18_0_0 {
	meta:
		name = "_fclose_r"
		size = 244
		refs = "0014 __sfp_lock_acquire 0040 _fflush_r 0090 _free_r 00c0 __sfp_lock_release 00d0 __sinit"
	strings:
		$1 = { 70 40 2D E9 00 40 51 E2 00 50 A0 E1 04 60 A0 01 2B 00 00 0A ?? ?? ?? ?? 00 00 55 E3 02 00 00 0A 38 30 95 E5 00 00 53 E3 27 00 00 0A FC 60 D4 E1 00 00 56 E3 21 00 00 0A 05 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 2C 30 94 E5 00 00 53 E3 00 60 A0 E1 05 00 00 0A 05 00 A0 E1 1C 10 94 E5 0F E0 A0 E1 13 FF 2F E1 00 00 50 E3 00 60 E0 B3 BC 30 D4 E1 80 00 13 E3 1A 00 00 1A 30 10 94 E5 00 00 51 E3 05 00 00 0A 40 30 84 E2 03 00 51 E1 05 00 A0 11 ?? ?? ?? ?? 00 30 A0 E3 30 30 84 E5 44 10 94 E5 00 00 51 E3 03 00 00 0A 05 00 A0 E1 ?? ?? ?? ?? 00 30 A0 E3 44 30 84 E5 00 30 A0 E3 BC 30 C4 E1 ?? ?? ?? ?? 06 00 A0 E1 70 80 BD E8 05 00 A0 E1 ?? ?? ?? ?? FC 60 D4 E1 00 00 56 E3 D5 FF FF 1A F6 FF FF EA 05 00 A0 E1 10 10 94 E5 ?? ?? ?? ?? E0 FF FF EA }
	condition:
		$1
}

rule file_18_1_0 {
	meta:
		name = "fclose"
		size = 20
		refs = "000c _fclose_r 0010 _impure_ptr"
	strings:
		$1 = { 08 30 9F E5 00 10 A0 E1 00 00 93 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_104_5_0 {
	meta:
		name = "__sigtramp"
		size = 20
		refs = "000c __sigtramp_r 0010 _impure_ptr"
	strings:
		$1 = { 08 30 9F E5 00 10 A0 E1 00 00 93 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_306_1_0 {
	meta:
		name = "__srget"
		size = 20
		refs = "000c __srget_r 0010 _impure_ptr"
	strings:
		$1 = { 08 30 9F E5 00 10 A0 E1 00 00 93 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_304_0_0 {
	meta:
		name = "cfree"
		size = 20
		refs = "000c _free_r 0010 _impure_ptr"
	strings:
		$1 = { 08 30 9F E5 00 10 A0 E1 00 00 93 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_83_0_0 {
	meta:
		name = "close"
		size = 20
		refs = "000c _close_r 0010 _impure_ptr"
	strings:
		$1 = { 08 30 9F E5 00 10 A0 E1 00 00 93 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_339_1_0 {
	meta:
		name = "erand48"
		size = 20
		refs = "000c _erand48_r 0010 _impure_ptr"
	strings:
		$1 = { 08 30 9F E5 00 10 A0 E1 00 00 93 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_117_0_0 {
	meta:
		name = "free"
		size = 20
		refs = "000c _free_r 0010 _impure_ptr"
	strings:
		$1 = { 08 30 9F E5 00 10 A0 E1 00 00 93 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_270_1_0 {
	meta:
		name = "ftell"
		size = 20
		refs = "000c _ftell_r 0010 _impure_ptr"
	strings:
		$1 = { 08 30 9F E5 00 10 A0 E1 00 00 93 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_308_0_0 {
	meta:
		name = "ftello"
		size = 20
		refs = "000c _ftell_r 0010 _impure_ptr"
	strings:
		$1 = { 08 30 9F E5 00 10 A0 E1 00 00 93 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_177_1_0 {
	meta:
		name = "gets"
		size = 20
		refs = "000c _gets_r 0010 _impure_ptr"
	strings:
		$1 = { 08 30 9F E5 00 10 A0 E1 00 00 93 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_476_1_0 {
	meta:
		name = "jrand48"
		size = 20
		refs = "000c _jrand48_r 0010 _impure_ptr"
	strings:
		$1 = { 08 30 9F E5 00 10 A0 E1 00 00 93 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_117_1_0 {
	meta:
		name = "malloc"
		size = 20
		refs = "000c _malloc_r 0010 _impure_ptr"
	strings:
		$1 = { 08 30 9F E5 00 10 A0 E1 00 00 93 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_113_0_0 {
	meta:
		name = "malloc_trim"
		size = 20
		refs = "000c _malloc_trim_r 0010 _impure_ptr"
	strings:
		$1 = { 08 30 9F E5 00 10 A0 E1 00 00 93 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_200_0_0 {
	meta:
		name = "malloc_usable_size"
		size = 20
		refs = "000c _malloc_usable_size_r 0010 _impure_ptr"
	strings:
		$1 = { 08 30 9F E5 00 10 A0 E1 00 00 93 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_252_1_0 {
	meta:
		name = "mstats"
		size = 20
		refs = "000c _mstats_r 0010 _impure_ptr"
	strings:
		$1 = { 08 30 9F E5 00 10 A0 E1 00 00 93 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_397_1_0 {
	meta:
		name = "nrand48"
		size = 20
		refs = "000c _nrand48_r 0010 _impure_ptr"
	strings:
		$1 = { 08 30 9F E5 00 10 A0 E1 00 00 93 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_228_1_0 {
	meta:
		name = "perror"
		size = 20
		refs = "000c _perror_r 0010 _impure_ptr"
	strings:
		$1 = { 08 30 9F E5 00 10 A0 E1 00 00 93 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_142_1_0 {
	meta:
		name = "putchar_unlocked"
		size = 20
		refs = "000c _putchar_unlocked_r 0010 _impure_ptr"
	strings:
		$1 = { 08 30 9F E5 00 10 A0 E1 00 00 93 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_218_0_0 {
	meta:
		name = "putenv"
		size = 20
		refs = "000c _putenv_r 0010 _impure_ptr"
	strings:
		$1 = { 08 30 9F E5 00 10 A0 E1 00 00 93 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_446_1_0 {
	meta:
		name = "puts"
		size = 20
		refs = "000c _puts_r 0010 _impure_ptr"
	strings:
		$1 = { 08 30 9F E5 00 10 A0 E1 00 00 93 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_309_0_0 {
	meta:
		name = "pvalloc"
		size = 20
		refs = "000c _pvalloc_r 0010 _impure_ptr"
	strings:
		$1 = { 08 30 9F E5 00 10 A0 E1 00 00 93 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_104_1_0 {
	meta:
		name = "raise"
		size = 20
		refs = "000c _raise_r 0010 _impure_ptr"
	strings:
		$1 = { 08 30 9F E5 00 10 A0 E1 00 00 93 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_63_1_0 {
	meta:
		name = "remove"
		size = 20
		refs = "000c _remove_r 0010 _impure_ptr"
	strings:
		$1 = { 08 30 9F E5 00 10 A0 E1 00 00 93 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_105_1_0 {
	meta:
		name = "rewind"
		size = 20
		refs = "000c _rewind_r 0010 _impure_ptr"
	strings:
		$1 = { 08 30 9F E5 00 10 A0 E1 00 00 93 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_166_0_0 {
	meta:
		name = "sbrk"
		size = 20
		refs = "000c _sbrk_r 0010 _impure_ptr"
	strings:
		$1 = { 08 30 9F E5 00 10 A0 E1 00 00 93 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_188_0_0 {
	meta:
		name = "strdup"
		size = 20
		refs = "000c _strdup_r 0010 _impure_ptr"
	strings:
		$1 = { 08 30 9F E5 00 10 A0 E1 00 00 93 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_436_1_0 {
	meta:
		name = "system"
		size = 20
		refs = "000c _system_r 0010 _impure_ptr"
	strings:
		$1 = { 08 30 9F E5 00 10 A0 E1 00 00 93 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_161_0_0 {
	meta:
		name = "times"
		size = 20
		refs = "000c _times_r 0010 _impure_ptr"
	strings:
		$1 = { 08 30 9F E5 00 10 A0 E1 00 00 93 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_407_4_0 {
	meta:
		name = "tmpnam"
		size = 20
		refs = "000c _tmpnam_r 0010 _impure_ptr"
	strings:
		$1 = { 08 30 9F E5 00 10 A0 E1 00 00 93 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_129_0_0 {
	meta:
		name = "unlink"
		size = 20
		refs = "000c _unlink_r 0010 _impure_ptr"
	strings:
		$1 = { 08 30 9F E5 00 10 A0 E1 00 00 93 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_61_0_0 {
	meta:
		name = "unsetenv"
		size = 20
		refs = "000c _unsetenv_r 0010 _impure_ptr"
	strings:
		$1 = { 08 30 9F E5 00 10 A0 E1 00 00 93 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_309_1_0 {
	meta:
		name = "valloc"
		size = 20
		refs = "000c _valloc_r 0010 _impure_ptr"
	strings:
		$1 = { 08 30 9F E5 00 10 A0 E1 00 00 93 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_73_0_0 {
	meta:
		name = "wait"
		size = 20
		refs = "000c _wait_r 0010 _impure_ptr"
	strings:
		$1 = { 08 30 9F E5 00 10 A0 E1 00 00 93 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_365_1_0 {
	meta:
		name = "wctrans"
		size = 20
		refs = "000c _wctrans_r 0010 _impure_ptr"
	strings:
		$1 = { 08 30 9F E5 00 10 A0 E1 00 00 93 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_236_1_0 {
	meta:
		name = "wctype"
		size = 20
		refs = "000c _wctype_r 0010 _impure_ptr"
	strings:
		$1 = { 08 30 9F E5 00 10 A0 E1 00 00 93 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_0_0 {
	meta:
		name = "strerror_r"
		size = 36
		refs = "000c strerror 0020 strncpy"
	strings:
		$1 = { 30 40 2D E9 01 50 A0 E1 02 40 A0 E1 ?? ?? ?? ?? 04 20 A0 E1 00 10 A0 E1 05 00 A0 E1 30 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_21_1_0 {
	meta:
		name = "_siscanf_r"
		size = 128
		refs = "0024 strlen 0068 __ssvfiscanf_r 007c eofread"
	strings:
		$1 = { 0C 00 2D E9 30 40 2D E9 81 3F A0 E3 6C D0 4D E2 00 50 A0 E1 01 00 A0 E1 BC 30 CD E1 00 10 8D E5 10 10 8D E5 ?? ?? ?? ?? 7C C0 8D E2 00 40 A0 E1 00 E0 A0 E3 05 00 A0 E1 3C 50 9F E5 44 E0 8D E5 30 E0 8D E5 78 20 9D E5 00 E0 E0 E3 0C 30 A0 E1 0D 10 A0 E1 14 40 8D E5 20 50 8D E5 04 40 8D E5 BE E0 CD E1 68 C0 8D E5 ?? ?? ?? ?? 6C D0 8D E2 30 40 BD E8 08 D0 8D E2 1E FF 2F E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_167_1_0 {
	meta:
		name = "_sscanf_r"
		size = 128
		refs = "0024 strlen 0068 __ssvfscanf_r 007c eofread"
	strings:
		$1 = { 0C 00 2D E9 30 40 2D E9 81 3F A0 E3 6C D0 4D E2 00 50 A0 E1 01 00 A0 E1 BC 30 CD E1 00 10 8D E5 10 10 8D E5 ?? ?? ?? ?? 7C C0 8D E2 00 40 A0 E1 00 E0 A0 E3 05 00 A0 E1 3C 50 9F E5 44 E0 8D E5 30 E0 8D E5 78 20 9D E5 00 E0 E0 E3 0C 30 A0 E1 0D 10 A0 E1 14 40 8D E5 20 50 8D E5 04 40 8D E5 BE E0 CD E1 68 C0 8D E5 ?? ?? ?? ?? 6C D0 8D E2 30 40 BD E8 08 D0 8D E2 1E FF 2F E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_21_2_0 {
	meta:
		name = "siscanf"
		size = 128
		refs = "001c strlen 0064 __ssvfiscanf_r 0078 _impure_ptr 007c eofread"
	strings:
		$1 = { 0E 00 2D E9 30 40 2D E9 81 2F A0 E3 6C D0 4D E2 BC 20 CD E1 10 00 8D E5 00 00 8D E5 ?? ?? ?? ?? 50 30 9F E5 7C C0 8D E2 00 E0 A0 E3 48 50 9F E5 00 40 A0 E1 44 E0 8D E5 30 E0 8D E5 00 00 93 E5 00 E0 E0 E3 78 20 9D E5 0C 30 A0 E1 0D 10 A0 E1 14 40 8D E5 20 50 8D E5 04 40 8D E5 BE E0 CD E1 68 C0 8D E5 ?? ?? ?? ?? 6C D0 8D E2 30 40 BD E8 0C D0 8D E2 1E FF 2F E1 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_167_2_0 {
	meta:
		name = "sscanf"
		size = 128
		refs = "001c strlen 0064 __ssvfscanf_r 0078 _impure_ptr 007c eofread"
	strings:
		$1 = { 0E 00 2D E9 30 40 2D E9 81 2F A0 E3 6C D0 4D E2 BC 20 CD E1 10 00 8D E5 00 00 8D E5 ?? ?? ?? ?? 50 30 9F E5 7C C0 8D E2 00 E0 A0 E3 48 50 9F E5 00 40 A0 E1 44 E0 8D E5 30 E0 8D E5 00 00 93 E5 00 E0 E0 E3 78 20 9D E5 0C 30 A0 E1 0D 10 A0 E1 14 40 8D E5 20 50 8D E5 04 40 8D E5 BE E0 CD E1 68 C0 8D E5 ?? ?? ?? ?? 6C D0 8D E2 30 40 BD E8 0C D0 8D E2 1E FF 2F E1 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_22_0_0 {
	meta:
		name = "strnlen"
		size = 76
	strings:
		$1 = { 00 00 51 E3 0E 00 00 0A 00 30 D0 E5 00 00 53 E3 0B 00 00 0A 01 10 41 E2 00 30 A0 E1 03 00 00 EA 00 20 D3 E5 00 00 52 E3 01 10 41 E2 02 00 00 0A 00 00 51 E3 01 30 83 E2 F8 FF FF 1A 03 00 60 E0 1E FF 2F E1 00 00 A0 E3 1E FF 2F E1 }
	condition:
		$1
}

rule file_23_0_0 {
	meta:
		name = "envz_remove"
		size = 124
		refs = "0014 envz_entry 0020 strlen 0050 memmove 0064 realloc"
	strings:
		$1 = { F0 40 2D E9 00 50 A0 E1 01 40 A0 E1 00 00 90 E5 00 10 91 E5 ?? ?? ?? ?? 00 70 50 E2 F0 80 BD 08 ?? ?? ?? ?? 00 30 95 E5 00 10 94 E5 00 C0 87 E0 01 20 83 E0 0C 00 52 E1 01 60 80 E2 06 00 00 0A 02 20 67 E0 06 10 87 E0 07 00 A0 E1 02 20 66 E0 ?? ?? ?? ?? 00 30 95 E5 00 10 94 E5 03 00 A0 E1 01 10 66 E0 ?? ?? ?? ?? 00 30 94 E5 03 60 66 E0 00 00 85 E5 00 60 84 E5 F0 80 BD E8 }
	condition:
		$1
}

rule file_24_0_0 {
	meta:
		name = "getchar"
		size = 20
		refs = "000c _getc_r 0010 _impure_ptr"
	strings:
		$1 = { 08 30 9F E5 00 00 93 E5 04 10 90 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_126_0_0 {
	meta:
		name = "getchar_unlocked"
		size = 20
		refs = "000c _getc_unlocked_r 0010 _impure_ptr"
	strings:
		$1 = { 08 30 9F E5 00 00 93 E5 04 10 90 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_25_0_0 {
	meta:
		name = "_vsprintf_r"
		size = 76
		refs = "0034 _svfprintf_r"
	strings:
		$1 = { 10 40 2D E9 02 C1 E0 E3 68 D0 4D E2 01 E0 A0 E1 14 C0 8D E5 08 C0 8D E5 0D 10 A0 E1 00 C0 E0 E3 82 4F A0 E3 10 E0 8D E5 BC 40 CD E1 00 E0 8D E5 BE C0 CD E1 ?? ?? ?? ?? 00 30 9D E5 00 20 A0 E3 00 20 C3 E5 68 D0 8D E2 10 80 BD E8 }
	condition:
		$1
}

rule file_247_0_0 {
	meta:
		name = "_vsiprintf_r"
		size = 76
		refs = "0034 _svfiprintf_r"
	strings:
		$1 = { 10 40 2D E9 02 C1 E0 E3 68 D0 4D E2 01 E0 A0 E1 14 C0 8D E5 08 C0 8D E5 0D 10 A0 E1 00 C0 E0 E3 82 4F A0 E3 10 E0 8D E5 BC 40 CD E1 00 E0 8D E5 BE C0 CD E1 ?? ?? ?? ?? 00 30 9D E5 00 20 A0 E3 00 20 C3 E5 68 D0 8D E2 10 80 BD E8 }
	condition:
		$1
}

rule file_26_0_0 {
	meta:
		name = "funreader"
		size = 100
		refs = "0014 __errno"
	strings:
		$1 = { F0 40 2D E9 01 40 A0 E1 02 70 A0 E1 03 60 A0 E1 00 50 A0 E1 ?? ?? ?? ?? 00 30 A0 E3 00 30 80 E5 07 10 A0 E1 00 00 94 E5 06 20 A0 E1 0F E0 A0 E1 04 F0 94 E5 00 40 50 E2 01 00 00 BA 04 00 A0 E1 F0 80 BD E8 ?? ?? ?? ?? 00 30 90 E5 00 00 53 E3 F9 FF FF 0A ?? ?? ?? ?? 00 30 90 E5 00 30 85 E5 F5 FF FF EA }
	condition:
		$1
}

rule file_26_1_0 {
	meta:
		name = "funwriter"
		size = 100
		refs = "0014 __errno"
		altNames = "fcreader"
	strings:
		$1 = { F0 40 2D E9 01 40 A0 E1 02 70 A0 E1 03 60 A0 E1 00 50 A0 E1 ?? ?? ?? ?? 00 30 A0 E3 00 30 80 E5 07 10 A0 E1 00 00 94 E5 06 20 A0 E1 0F E0 A0 E1 08 F0 94 E5 00 40 50 E2 01 00 00 BA 04 00 A0 E1 F0 80 BD E8 ?? ?? ?? ?? 00 30 90 E5 00 00 53 E3 F9 FF FF 0A ?? ?? ?? ?? 00 30 90 E5 00 30 85 E5 F5 FF FF EA }
	condition:
		$1
}

rule file_26_2_0 {
	meta:
		name = "funseeker"
		size = 100
		refs = "0014 __errno"
	strings:
		$1 = { F0 40 2D E9 01 40 A0 E1 02 70 A0 E1 03 60 A0 E1 00 50 A0 E1 ?? ?? ?? ?? 00 30 A0 E3 00 30 80 E5 07 10 A0 E1 00 00 94 E5 06 20 A0 E1 0F E0 A0 E1 0C F0 94 E5 00 40 50 E2 01 00 00 BA 04 00 A0 E1 F0 80 BD E8 ?? ?? ?? ?? 00 30 90 E5 00 00 53 E3 F9 FF FF 0A ?? ?? ?? ?? 00 30 90 E5 00 30 85 E5 F5 FF FF EA }
	condition:
		$1
}

rule file_26_3_0 {
	meta:
		name = "funcloser"
		size = 108
		refs = "0018 __errno 0040 _free_r"
	strings:
		$1 = { 70 40 2D E9 10 40 91 E5 00 00 54 E3 01 50 A0 E1 00 60 A0 E1 07 00 00 0A ?? ?? ?? ?? 00 30 A0 E3 00 30 80 E5 00 00 95 E5 0F E0 A0 E1 10 F0 95 E5 00 40 50 E2 04 00 00 BA 06 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 70 80 BD E8 ?? ?? ?? ?? 00 30 90 E5 00 00 53 E3 F6 FF FF 0A ?? ?? ?? ?? 00 30 90 E5 00 30 86 E5 F2 FF FF EA }
	condition:
		$1
}

rule file_26_4_0 {
	meta:
		name = "_funopen_r"
		size = 288
		refs = "0040 __sfp 0054 _malloc_r 00f8 __sfp_lock_acquire 0108 __sfp_lock_release 0110 funreader 0114 funwriter 0118 funseeker 011c funcloser"
	strings:
		$1 = { F0 45 2D E9 00 00 53 E3 00 00 52 03 04 D0 4D E2 03 40 A0 E1 16 30 A0 03 02 60 A0 E1 01 80 A0 E1 00 A0 A0 E1 20 70 9D E5 00 30 80 05 00 50 A0 03 02 00 00 1A 05 00 A0 E1 04 D0 8D E2 F0 85 BD E8 ?? ?? ?? ?? 00 50 50 E2 F9 FF FF 0A 0A 00 A0 E1 14 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 24 00 00 0A 00 30 E0 E3 00 00 56 E3 00 80 80 E5 BE 30 C5 E1 1C 00 85 E5 16 00 00 0A 90 30 9F E5 00 00 54 E3 20 30 85 E5 88 30 9F 15 04 30 A0 03 24 30 85 15 10 30 A0 13 04 60 80 E5 08 40 80 15 BC 30 C5 11 24 40 85 05 BC 30 C5 01 08 40 80 05 64 30 9F E5 00 00 57 E3 00 30 A0 03 24 20 9D E5 28 30 85 E5 54 30 9F E5 10 20 80 E5 2C 30 85 E5 0C 70 80 E5 D7 FF FF EA 38 30 9F E5 24 30 85 E5 08 30 A0 E3 08 40 80 E5 20 60 85 E5 04 60 80 E5 BC 30 C5 E1 ED FF FF EA 00 00 8D E5 ?? ?? ?? ?? 00 00 9D E5 BC 00 C5 E1 00 50 A0 E1 ?? ?? ?? ?? C8 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_26_5_0 {
	meta:
		name = "funopen"
		size = 72
		refs = "0038 _funopen_r 0044 _impure_ptr"
	strings:
		$1 = { 30 40 2D E9 38 C0 9F E5 08 D0 4D E2 00 50 9C E5 02 C0 A0 E1 00 40 A0 E1 01 E0 A0 E1 00 30 8D E5 0C 30 A0 E1 14 C0 9D E5 05 00 A0 E1 04 10 A0 E1 0E 20 A0 E1 04 C0 8D E5 ?? ?? ?? ?? 08 D0 8D E2 30 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_0_0 {
	meta:
		name = "strlen"
		size = 156
	strings:
		$1 = { 03 00 10 E3 00 30 A0 01 0B 00 00 0A 00 30 D0 E5 00 00 53 E3 03 00 A0 01 1E FF 2F 01 00 30 A0 E1 02 00 00 EA 00 20 D3 E5 00 00 52 E3 18 00 00 0A 01 30 83 E2 03 00 13 E3 F9 FF FF 1A 00 10 93 E5 00 00 00 EA 04 10 B3 E5 FF 24 81 E2 01 28 42 E2 01 2C 42 E2 01 20 42 E2 01 20 C2 E1 7F 24 C2 E3 7F 28 C2 E3 7F 2C C2 E3 7F 20 C2 E3 00 00 52 E3 F3 FF FF 0A 00 20 D3 E5 00 00 52 E3 02 00 00 0A 01 20 F3 E5 00 00 52 E3 FC FF FF 1A 03 00 60 E0 1E FF 2F E1 03 00 60 E0 1E FF 2F E1 }
	condition:
		$1
}

rule file_28_0_0 {
	meta:
		name = "_strtod_r"
		size = 5520
		refs = "048c __floatunsidf 04bc __muldf3 04e0 __adddf3 053c __fixdfsi 0540 __floatsidf 0554 __subdf3 0590 __ltdf2 05a4 _Bfree 0670 __s2b 0698 __mprec_tens 069c __mprec_bigtens 06a0 .LC2 06a4 .LC0 0734 __ledf2 0748 __fixunsdfsi 07a4 __ulp 0840 _Balloc 0860 memcpy 087c __d2b 088c __i2b 092c __pow5mult 0940 __multiply 0974 __lshift 09dc __mdiff 09f8 __mcmp 0a10 __ratio 0ec4 __gtdf2 0ef8 __gethex 0f30 __copybits 1260 __divdf3 12a4 .LC1 1394 __nedf2 155c __hexnan"
	strings:
		$1 = { F0 4F 2D E9 7C D0 4D E2 00 40 A0 E3 00 30 A0 E3 70 10 8D E5 58 30 8D E5 5C 40 8D E5 24 20 8D E5 00 40 A0 E1 01 20 A0 E1 00 00 D2 E5 2D 00 50 E3 00 F1 9F 97 B4 00 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 70 A0 E3 07 60 A0 E1 07 50 A0 E1 00 C0 A0 E3 0C 20 8D E5 14 C0 8D E5 05 30 A0 E1 0C B0 A0 E1 65 00 50 E3 45 00 50 13 91 00 00 0A 00 20 A0 E3 00 00 55 E3 D2 00 00 1A 0A C0 9C E1 2C 01 00 1A 14 C0 9D E5 00 00 5C E3 63 02 00 0A 00 30 A0 E3 70 10 8D E5 2C 30 8D E5 03 20 A0 E1 24 80 9D E5 00 00 58 E3 70 10 9D 15 2C 90 9D E5 00 10 88 15 00 00 59 E3 02 31 83 12 03 00 A0 E1 02 10 A0 E1 7C D0 8D E2 F0 8F BD E8 01 30 A0 E3 2C 30 8D E5 01 20 82 E2 70 20 8D E5 00 00 D2 E5 00 00 50 E3 E9 FF FF 0A 30 00 50 E3 00 A0 A0 13 5F 00 00 0A 2F 00 50 E3 41 04 00 DA 39 00 50 E3 CF FF FF CA 00 70 A0 E3 07 60 A0 E1 07 50 A0 E1 01 00 00 EA 39 00 50 E3 CC FF FF CA 08 00 55 E3 06 61 86 D0 86 60 80 D0 30 60 46 D2 03 00 00 DA 0F 00 55 E3 07 71 87 D0 87 70 80 D0 30 70 47 D2 01 50 85 E2 05 C0 82 E0 70 C0 8D E5 05 00 D2 E7 2F 00 50 E3 EE FF FF CA 05 30 A0 E1 2E 00 50 E3 F7 00 00 1A 01 00 8C E2 70 00 8D E5 00 00 53 E3 01 00 DC E5 14 02 00 0A 00 C0 A0 E3 0C 20 8D E5 03 50 A0 E1 0C B0 A0 E1 30 80 40 E2 09 00 58 E3 01 90 A0 83 14 90 8D 85 B1 FF FF 8A 70 00 9D E5 14 00 8D E5 01 C0 8C E2 05 90 A0 E1 00 00 58 E3 09 50 A0 01 1E 00 00 0A 01 00 5C E3 0C B0 8B E0 11 00 00 0A 0C 20 89 E0 01 50 42 E2 03 00 A0 E1 09 20 A0 E1 01 20 82 E2 01 30 42 E2 08 00 53 E3 06 61 86 D0 86 60 A0 D1 02 00 00 DA 10 00 52 E3 07 71 87 D0 87 70 A0 D1 05 00 52 E1 F4 FF FF 1A 09 90 8C E0 00 30 A0 E1 01 90 49 E2 08 00 59 E3 06 61 86 D0 01 50 89 E2 86 60 88 D0 00 C0 A0 D3 03 00 00 DA 10 00 55 E3 0A 20 A0 D3 92 87 27 D0 00 C0 A0 E3 14 80 9D E5 01 20 88 E2 70 20 8D E5 01 00 D8 E5 CF FF FF EA 00 00 A0 E3 2C 00 8D E5 9F FF FF EA 01 20 82 E2 70 20 8D E5 46 FF FF EA 00 80 A0 E3 30 00 50 E3 2C 80 8D E5 00 A0 A0 13 9F FF FF 1A 01 30 D2 E5 58 00 53 E3 01 50 82 E2 E8 02 00 0A 78 00 53 E3 01 00 00 1A E5 02 00 EA 01 50 85 E2 70 50 8D E5 00 00 D5 E5 30 00 50 E3 05 20 A0 E1 F9 FF FF 0A 00 00 50 E3 A1 00 00 0A 01 A0 A0 E3 8E FF FF EA 0C 20 85 E1 0A 20 92 E1 72 FF FF 0A 70 10 9D E5 01 80 81 E2 70 80 8D E5 01 00 D1 E5 2B 00 50 E3 27 03 00 0A 2D 00 50 E3 00 20 A0 13 1C 20 8D 15 33 02 00 0A 30 20 40 E2 09 00 52 E3 70 10 8D 85 00 20 A0 83 5C FF FF 8A 30 00 50 E3 05 00 00 1A 70 20 9D E5 01 20 82 E2 70 20 8D E5 00 00 D2 E5 30 00 50 E3 FA FF FF 0A 31 20 40 E2 08 00 52 E3 50 FF FF 8A 70 20 9D E5 20 20 8D E5 01 90 82 E2 70 90 8D E5 20 80 9D E5 30 20 40 E2 01 00 D8 E5 2F 00 50 E3 10 00 00 DA 39 00 50 E3 0E 00 00 CA 02 80 88 E2 28 30 8D E5 02 00 00 EA 39 00 50 E3 01 80 88 E2 07 00 00 CA 70 80 8D E5 30 30 40 E2 00 00 D8 E5 02 21 82 E0 2F 00 50 E3 82 20 83 E0 08 90 A0 E1 F4 FF FF CA 28 30 9D E5 4E 8C A0 E3 28 80 8D E5 20 80 9D E5 09 90 68 E0 4E 8C A0 E3 1F 80 88 E2 08 00 52 E1 08 00 59 D3 1C 90 9D E5 08 20 A0 C1 00 00 59 E3 00 20 62 12 2A FF FF EA 00 00 53 E3 02 20 6B E0 06 00 A0 E1 03 90 A0 11 05 90 A0 01 1C 20 8D E5 ?? ?? ?? ?? 10 00 55 E3 05 80 A0 B1 10 80 A0 A3 09 00 58 E3 58 00 8D E5 5C 10 8D E5 0F 00 00 DA E4 31 9F E5 88 31 83 E0 48 30 43 E2 0C 00 93 E8 ?? ?? ?? ?? 00 A0 A0 E1 07 00 A0 E1 01 B0 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 58 00 8D E5 5C 10 8D E5 0F 00 55 E3 44 00 00 CA 1C 00 9D E5 00 00 50 E3 35 00 00 0A 8B 03 00 DA 1C 10 9D E5 16 00 51 E3 6C 03 00 CA 80 31 9F E5 81 31 83 E0 0C 00 93 E8 58 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 30 A0 E1 01 20 A0 E1 05 FF FF EA 09 00 A0 E1 0C 10 9D E5 ?? ?? ?? ?? ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 09 00 A0 E1 0C 10 9D E5 ?? ?? ?? ?? 20 90 9D E5 00 00 59 E3 14 00 8D E5 18 10 8D E5 4A 02 00 1A 5C 30 9D E5 00 00 53 E3 47 02 00 1A FF B4 CB E3 0F B6 CB E3 00 00 5B E3 43 02 00 1A 01 3C 8F E2 0C 00 93 E8 ?? ?? ?? ?? 00 00 50 E3 95 00 00 AA 04 00 A0 E1 6C 10 9D E5 ?? ?? ?? ?? 04 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 28 10 9D E5 ?? ?? ?? ?? 04 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 58 30 9D E5 5C 20 9D E5 D9 FE FF EA 00 30 A0 E3 03 20 A0 E1 D6 FE FF EA 00 C0 A0 E3 0C 20 8D E5 03 50 A0 E1 0C B0 A0 E1 14 C0 8D E5 C1 FE FF EA 1C 00 9D E5 05 A0 68 E0 00 A0 8A E0 00 00 5A E3 07 03 00 DA 0F 30 1A E2 07 00 00 0A 6C 20 9F E5 83 31 82 E0 58 10 8D E2 03 00 91 E8 0C 00 93 E8 ?? ?? ?? ?? 58 00 8D E5 5C 10 8D E5 0F A0 DA E3 49 01 00 1A 58 10 8D E2 03 00 91 E8 14 00 8D E5 18 10 8D E5 0C 10 9D E5 09 20 A0 E1 05 30 A0 E1 04 00 A0 E1 00 60 8D E5 ?? ?? ?? ?? 1C 20 9D E5 0C 10 80 E2 00 20 62 E2 28 00 8D E5 30 10 8D E5 34 20 8D E5 68 00 00 EA FF FF CF 3F 95 35 A0 94 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 20 00 9D E5 00 00 50 E3 90 01 00 0A FF 25 A0 E3 00 30 A0 E3 03 26 82 E2 60 20 8D E5 64 30 8D E5 00 30 A0 E3 FF 95 A0 E3 58 C0 9D E5 0C 30 8D E5 03 96 89 E2 02 51 CC E3 25 5A A0 E1 7F 34 A0 E3 05 5A A0 E1 0E 36 83 E2 7F B4 A0 E3 03 00 55 E1 0F B6 8B E2 A6 01 00 0A 6A 06 55 E3 00 30 A0 83 01 30 A0 93 00 00 5A E3 00 30 A0 03 00 00 53 E3 1C 00 00 0A BE 24 E0 E3 02 31 A0 E3 09 00 A0 E1 0C 10 9D E5 02 26 42 E2 C3 34 A0 E1 ?? ?? ?? ?? 00 00 50 E3 0F 00 00 CA 0C 10 9D E5 09 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 01 00 A0 03 ?? ?? ?? ?? 20 30 9D E5 0C 10 8D E5 00 00 53 E3 00 30 A0 11 02 31 80 02 0C 20 9D E5 03 10 A0 E1 60 10 8D E5 64 20 8D E5 00 90 A0 E1 60 30 9D E5 6B 36 83 E2 03 30 65 E0 60 30 8D E5 60 C0 8D E2 00 18 9C E8 14 10 8D E2 03 00 91 E8 08 C0 8D E5 ?? ?? ?? ?? 08 C0 9D E5 00 20 A0 E1 01 30 A0 E1 0B 00 A0 E1 0C 10 A0 E1 ?? ?? ?? ?? 14 30 8D E2 0C 00 93 E8 ?? ?? ?? ?? 58 00 8D E5 5C 10 8D E5 58 B0 9D E5 00 00 5A E3 04 00 00 1A 02 31 CB E3 23 3A A0 E1 03 3A A0 E1 03 00 55 E1 4F FF FF 0A 04 00 A0 E1 6C 10 9D E5 ?? ?? ?? ?? 04 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 58 10 8D E2 03 00 91 E8 14 00 8D E5 18 10 8D E5 28 30 9D E5 04 00 A0 E1 04 10 93 E5 ?? ?? ?? ?? 28 80 9D E5 10 20 98 E5 02 20 82 E2 02 21 A0 E1 30 10 9D E5 00 70 A0 E1 0C 00 80 E2 ?? ?? ?? ?? 74 90 8D E2 14 20 8D E2 06 00 92 E8 78 30 8D E2 04 00 A0 E1 00 90 8D E5 ?? ?? ?? ?? 01 10 A0 E3 6C 00 8D E5 04 00 A0 E1 ?? ?? ?? ?? 1C C0 9D E5 00 00 5C E3 34 20 9D B5 78 80 9D E5 00 20 A0 A3 0C 90 A0 A1 00 90 A0 B3 02 B0 A0 A1 02 B0 A0 B1 09 50 A0 A1 09 50 A0 B1 74 30 9D E5 00 00 58 E3 08 B0 82 A0 05 50 68 B0 08 80 6A E0 00 60 A0 E1 FF 1F E0 E3 03 00 88 E0 01 00 50 E1 43 8E 88 B2 03 80 88 B2 36 80 63 A2 0A 50 85 E0 08 50 85 E0 0B 80 88 E0 05 00 58 E1 08 30 A0 B1 05 30 A0 A1 0B 00 53 E1 0B 30 A0 A1 00 00 53 E3 0B B0 63 C0 08 80 63 C0 05 50 63 C0 00 00 52 E3 0E 00 00 0A 06 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 60 A0 E1 06 10 A0 E1 6C 20 9D E5 04 00 A0 E1 ?? ?? ?? ?? 6C 10 9D E5 00 30 A0 E1 04 00 A0 E1 08 30 8D E5 ?? ?? ?? ?? 08 30 9D E5 6C 30 8D E5 00 00 58 E3 04 00 00 DA 08 20 A0 E1 04 00 A0 E1 6C 10 9D E5 ?? ?? ?? ?? 6C 00 8D E5 00 00 59 E3 04 00 00 0A 07 10 A0 E1 09 20 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 70 A0 E1 00 00 55 E3 04 00 00 DA 07 10 A0 E1 05 20 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 70 A0 E1 00 00 5B E3 04 00 00 DA 06 10 A0 E1 0B 20 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 60 A0 E1 6C 10 9D E5 07 20 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 0C 10 90 E5 00 20 A0 E3 20 10 8D E5 0C 20 80 E5 06 10 A0 E1 00 80 A0 E1 ?? ?? ?? ?? 00 00 50 E3 8B 01 00 BA C6 01 00 0A 08 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 01 21 A0 E3 00 30 A0 E3 0C 00 8D E5 10 10 8D E5 ?? ?? ?? ?? 00 00 50 E3 1D FF FF DA FF 25 A0 E3 0C 10 8D E2 03 00 91 E8 02 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 20 30 9D E5 0C 10 8D E5 00 00 53 E3 00 90 A0 E1 00 10 A0 11 02 11 89 02 0C 30 9D E5 01 20 A0 E1 60 20 8D E5 64 30 8D E5 58 C0 9D E5 18 FF FF EA 30 00 50 E3 03 C0 A0 11 06 00 00 1A 02 50 8C E2 03 C0 A0 E1 70 50 8D E5 01 00 D5 E4 30 00 50 E3 01 C0 8C E2 FA FF FF 0A 31 50 40 E2 08 00 55 E3 68 00 00 8A 70 20 9D E5 0C B0 A0 E1 0C 20 8D E5 30 80 40 E2 14 20 8D E5 00 90 A0 E3 01 C0 A0 E3 E2 FD FF EA 49 00 40 E2 25 00 50 E3 00 F1 9F 97 97 FD FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 4D 0F 5A E3 A9 01 00 CA 4A 72 A0 E1 01 00 57 E3 00 A0 A0 D3 F4 B4 1F D5 0E 00 00 DA FC B4 1F E5 58 10 8D E2 03 00 91 E8 0B 80 A0 E1 00 A0 A0 E3 01 00 17 E3 C7 70 A0 E1 0C 00 98 18 ?? ?? ?? ?? 01 00 57 E3 01 A0 8A E2 08 80 88 E2 F7 FF FF CA 58 00 8D E5 5C 10 8D E5 58 30 9D E5 35 36 43 E2 58 30 8D E5 8A A1 8B E0 0C 00 9A E8 58 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 58 00 8D E5 5C 10 8D E5 58 10 9D E5 02 31 C1 E3 23 3A A0 E1 1F 23 A0 E3 03 3A A0 E1 0A 26 82 E2 02 00 53 E1 83 01 00 8A 1F 23 A0 E3 09 26 82 E2 02 00 53 E1 DF 01 00 9A 02 31 E0 E3 01 36 43 E2 58 30 8D E5 00 30 E0 E3 5C 30 8D E5 58 20 8D E2 06 00 92 E8 00 A0 A0 E3 14 10 8D E5 18 20 8D E5 82 FE FF EA 00 50 A0 E3 0C 20 8D E5 01 20 A0 E3 05 B0 A0 E1 14 20 8D E5 29 FD FF EA 01 90 A0 E3 1C 90 8D E5 01 20 88 E2 70 20 8D E5 01 00 D8 E5 C5 FD FF EA 70 20 9D E5 EC 05 1F E5 01 C0 50 E5 00 00 5C E3 EA 01 00 0A 01 30 D2 E5 40 00 53 E3 01 00 00 DA 5A 00 53 E3 20 30 83 D2 0C 00 53 E1 01 20 82 E2 01 00 80 E2 F3 FF FF 0A 1F FD FF EA 70 20 9D E5 24 06 1F E5 01 C0 50 E5 00 00 5C E3 BC 01 00 0A 01 30 D2 E5 40 00 53 E3 01 00 00 DA 5A 00 53 E3 20 30 83 D2 0C 00 53 E1 01 20 82 E2 01 00 80 E2 F3 FF FF 0A 10 FD FF EA 5C 30 9D E5 00 00 53 E3 57 00 00 1A 58 C0 9D E5 FF 34 CC E3 0F 36 C3 E3 00 00 53 E3 0C 30 A0 E1 14 00 00 1A FF 25 A0 E3 0C 10 8D E2 03 00 91 E8 03 26 82 E2 00 30 A0 E3 08 C0 8D E5 ?? ?? ?? ?? 00 00 50 E3 08 C0 9D E5 AB 00 00 AA 00 20 A0 E3 BF 34 A0 E3 FF 95 A0 E3 0C 20 8D E5 0E 36 83 E2 02 96 89 E2 03 00 A0 E1 02 10 A0 E1 60 00 8D E5 64 10 8D E5 5A FE FF EA BF 14 A0 E3 00 20 A0 E3 0F 16 81 E2 FF 95 A0 E3 60 10 8D E5 64 20 8D E5 00 20 A0 E3 03 C0 A0 E1 03 96 89 E2 0C 20 8D E5 4F FE FF EA 35 C6 4C E2 58 C0 8D E5 58 10 8D E2 03 00 91 E8 38 00 8D E5 3C 10 8D E5 60 20 8D E2 06 00 92 E8 40 10 8D E5 44 20 8D E5 14 30 8D E2 0C 00 93 E8 38 10 8D E2 03 00 91 E8 50 20 8D E5 54 30 8D E5 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 40 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 38 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 58 00 8D E5 5C 10 8D E5 58 10 9D E5 02 31 C1 E3 23 3A A0 E1 83 24 E0 E3 03 3A A0 E1 06 26 42 E2 02 00 53 E1 35 B6 81 92 58 B0 8D 95 67 FE FF 9A 02 31 E0 E3 50 20 9D E5 01 36 43 E2 03 00 52 E1 EC 00 00 0A 02 31 E0 E3 01 36 43 E2 58 30 8D E5 00 30 E0 E3 5C 30 8D E5 63 FE FF EA 01 00 53 E3 58 30 9D 15 BF FF FF 1A 58 30 9D E5 00 00 53 E3 BC FF FF 1A 00 30 A0 E3 00 20 A0 E3 58 20 8D E5 5C 30 8D E5 22 30 A0 E3 00 30 84 E5 C0 FD FF EA 14 10 8D E2 03 00 91 E8 F9 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 00 00 50 E3 B9 FD FF BA 14 10 8D E2 03 00 91 E8 3D 3E 8F E2 0C 00 93 E8 ?? ?? ?? ?? 00 00 50 E3 48 FE FF DA B1 FD FF EA C0 63 9F E5 2C 90 9D E5 6C C0 8D E2 04 00 A0 E1 70 10 8D E2 06 20 A0 E1 68 30 8D E2 00 C0 8D E5 04 90 8D E5 ?? ?? ?? ?? 07 80 10 E2 00 70 A0 E1 B6 FD FF 0A 06 00 58 E3 00 30 A0 03 70 50 8D 05 03 20 A0 01 8B FC FF 0A 6C 20 9D E5 00 00 52 E3 05 00 00 0A 00 10 96 E5 48 00 8D E2 ?? ?? ?? ?? 04 00 A0 E1 6C 10 9D E5 ?? ?? ?? ?? 68 30 9D E5 06 00 58 E3 08 F1 9F 97 0A 00 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 02 31 E0 E3 58 30 8D E5 02 31 83 E2 5C 30 8D E5 08 00 17 E3 94 FD FF 0A 58 30 9D E5 5C 20 9D E5 02 31 83 E3 6D FC FF EA 7F 34 A0 E3 0F 36 83 E2 58 30 8D E5 00 30 A0 E3 5C 30 8D E5 F3 FF FF EA 48 30 9D E5 5C 30 8D E5 4C 30 9D E5 58 30 8D E5 EE FF FF EA 4C 20 9D E5 43 3E 83 E2 01 26 C2 E3 03 30 83 E2 03 3A 82 E1 48 20 9D E5 58 30 8D E5 5C 20 8D E5 E5 FF FF EA 00 30 A0 E3 58 30 8D E5 5C 30 8D E5 E1 FF FF EA FF 25 A0 E3 0C 10 8D E2 03 00 91 E8 }
	condition:
		$1
}

rule file_28_1_0 {
	meta:
		name = "strtof"
		size = 80
		refs = "0018 _strtod_r 0024 __isnand 0038 __truncdfsf2 0048 nanf 004c _impure_ptr"
	strings:
		$1 = { 01 20 A0 E1 40 10 9F E5 00 30 A0 E1 30 40 2D E9 00 00 91 E5 03 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 ?? ?? ?? ?? 00 00 50 E3 03 00 00 1A 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 30 80 BD E8 00 00 A0 E3 30 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_28_2_0 {
	meta:
		name = "strtod"
		size = 28
		refs = "0014 _strtod_r 0018 _impure_ptr"
	strings:
		$1 = { 01 20 A0 E1 0C 10 9F E5 00 30 A0 E1 00 00 91 E5 03 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_332_1_0 {
	meta:
		name = "__swbuf"
		size = 28
		refs = "0014 __swbuf_r 0018 _impure_ptr"
	strings:
		$1 = { 01 20 A0 E1 0C 10 9F E5 00 30 A0 E1 00 00 91 E5 03 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_378_1_0 {
	meta:
		name = "_findenv"
		size = 28
		refs = "0014 _findenv_r 0018 _impure_ptr"
	strings:
		$1 = { 01 20 A0 E1 0C 10 9F E5 00 30 A0 E1 00 00 91 E5 03 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_381_0_0 {
	meta:
		name = "calloc"
		size = 28
		refs = "0014 _calloc_r 0018 _impure_ptr"
	strings:
		$1 = { 01 20 A0 E1 0C 10 9F E5 00 30 A0 E1 00 00 91 E5 03 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_352_1_0 {
	meta:
		name = "fdopen"
		size = 28
		refs = "0014 _fdopen_r 0018 _impure_ptr"
	strings:
		$1 = { 01 20 A0 E1 0C 10 9F E5 00 30 A0 E1 00 00 91 E5 03 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_192_1_0 {
	meta:
		name = "fgetpos"
		size = 28
		refs = "0014 _fgetpos_r 0018 _impure_ptr"
	strings:
		$1 = { 01 20 A0 E1 0C 10 9F E5 00 30 A0 E1 00 00 91 E5 03 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_224_1_0 {
	meta:
		name = "fopen"
		size = 28
		refs = "0014 _fopen_r 0018 _impure_ptr"
	strings:
		$1 = { 01 20 A0 E1 0C 10 9F E5 00 30 A0 E1 00 00 91 E5 03 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_71_1_0 {
	meta:
		name = "fputs"
		size = 28
		refs = "0014 _fputs_r 0018 _impure_ptr"
	strings:
		$1 = { 01 20 A0 E1 0C 10 9F E5 00 30 A0 E1 00 00 91 E5 03 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_338_1_0 {
	meta:
		name = "fsetpos"
		size = 28
		refs = "0014 _fsetpos_r 0018 _impure_ptr"
	strings:
		$1 = { 01 20 A0 E1 0C 10 9F E5 00 30 A0 E1 00 00 91 E5 03 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_371_0_0 {
	meta:
		name = "fstat"
		size = 28
		refs = "0014 _fstat_r 0018 _impure_ptr"
	strings:
		$1 = { 01 20 A0 E1 0C 10 9F E5 00 30 A0 E1 00 00 91 E5 03 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_362_1_0 {
	meta:
		name = "fwide"
		size = 28
		refs = "0014 _fwide_r 0018 _impure_ptr"
	strings:
		$1 = { 01 20 A0 E1 0C 10 9F E5 00 30 A0 E1 00 00 91 E5 03 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_75_0_0 {
	meta:
		name = "gettimeofday"
		size = 28
		refs = "0014 _gettimeofday_r 0018 _impure_ptr"
	strings:
		$1 = { 01 20 A0 E1 0C 10 9F E5 00 30 A0 E1 00 00 91 E5 03 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_368_0_0 {
	meta:
		name = "kill"
		size = 28
		refs = "0014 _kill_r 0018 _impure_ptr"
	strings:
		$1 = { 01 20 A0 E1 0C 10 9F E5 00 30 A0 E1 00 00 91 E5 03 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_111_0_0 {
	meta:
		name = "link"
		size = 28
		refs = "0014 _link_r 0018 _impure_ptr"
	strings:
		$1 = { 01 20 A0 E1 0C 10 9F E5 00 30 A0 E1 00 00 91 E5 03 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_252_3_0 {
	meta:
		name = "mallopt"
		size = 28
		refs = "0014 _mallopt_r 0018 _impure_ptr"
	strings:
		$1 = { 01 20 A0 E1 0C 10 9F E5 00 30 A0 E1 00 00 91 E5 03 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_282_0_0 {
	meta:
		name = "memalign"
		size = 28
		refs = "0014 _memalign_r 0018 _impure_ptr"
	strings:
		$1 = { 01 20 A0 E1 0C 10 9F E5 00 30 A0 E1 00 00 91 E5 03 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_302_4_0 {
	meta:
		name = "open_memstream"
		size = 28
		refs = "0014 _open_memstream_r 0018 _impure_ptr"
	strings:
		$1 = { 01 20 A0 E1 0C 10 9F E5 00 30 A0 E1 00 00 91 E5 03 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_230_0_0 {
	meta:
		name = "realloc"
		size = 28
		refs = "0014 _realloc_r 0018 _impure_ptr"
	strings:
		$1 = { 01 20 A0 E1 0C 10 9F E5 00 30 A0 E1 00 00 91 E5 03 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_462_1_0 {
	meta:
		name = "reallocf"
		size = 28
		refs = "0014 _reallocf_r 0018 _impure_ptr"
	strings:
		$1 = { 01 20 A0 E1 0C 10 9F E5 00 30 A0 E1 00 00 91 E5 03 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_178_0_0 {
	meta:
		name = "rename"
		size = 28
		refs = "0014 _rename_r 0018 _impure_ptr"
	strings:
		$1 = { 01 20 A0 E1 0C 10 9F E5 00 30 A0 E1 00 00 91 E5 03 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_257_4_0 {
	meta:
		name = "setlocale"
		size = 28
		refs = "0014 _setlocale_r 0018 _impure_ptr"
	strings:
		$1 = { 01 20 A0 E1 0C 10 9F E5 00 30 A0 E1 00 00 91 E5 03 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_104_7_0 {
	meta:
		name = "signal"
		size = 28
		refs = "0014 _signal_r 0018 _impure_ptr"
	strings:
		$1 = { 01 20 A0 E1 0C 10 9F E5 00 30 A0 E1 00 00 91 E5 03 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_412_0_0 {
	meta:
		name = "stat"
		size = 28
		refs = "0014 _stat_r 0018 _impure_ptr"
	strings:
		$1 = { 01 20 A0 E1 0C 10 9F E5 00 30 A0 E1 00 00 91 E5 03 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_288_0_0 {
	meta:
		name = "strndup"
		size = 28
		refs = "0014 _strndup_r 0018 _impure_ptr"
	strings:
		$1 = { 01 20 A0 E1 0C 10 9F E5 00 30 A0 E1 00 00 91 E5 03 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_407_2_0 {
	meta:
		name = "tempnam"
		size = 28
		refs = "0014 _tempnam_r 0018 _impure_ptr"
	strings:
		$1 = { 01 20 A0 E1 0C 10 9F E5 00 30 A0 E1 00 00 91 E5 03 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_374_1_0 {
	meta:
		name = "towctrans"
		size = 28
		refs = "0014 _towctrans_r 0018 _impure_ptr"
	strings:
		$1 = { 01 20 A0 E1 0C 10 9F E5 00 30 A0 E1 00 00 91 E5 03 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_98_2_0 {
	meta:
		name = "ungetc"
		size = 28
		refs = "0014 _ungetc_r 0018 _impure_ptr"
	strings:
		$1 = { 01 20 A0 E1 0C 10 9F E5 00 30 A0 E1 00 00 91 E5 03 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_29_0_0 {
	meta:
		name = "argz_create_sep"
		size = 272
		refs = "0048 strdup 0060 strlen 0080 strsep 0090 malloc 00a8 free 00f0 memcpy"
	strings:
		$1 = { F0 4F 2D E9 00 40 A0 E3 08 D0 4D E2 00 70 50 E2 03 50 A0 E1 02 B0 A0 E1 00 40 8D E5 00 40 83 E5 02 00 00 0A 00 30 D7 E5 04 00 53 E1 03 00 00 1A 00 00 A0 E3 00 00 8B E5 08 D0 8D E2 F0 8F BD E8 04 10 CD E5 05 40 CD E5 ?? ?? ?? ?? 08 80 8D E2 00 90 A0 E1 08 00 28 E5 04 A0 8D E2 05 00 00 EA ?? ?? ?? ?? 00 30 95 E5 01 30 83 E2 00 30 83 E0 00 30 85 E5 01 40 84 E2 0A 10 A0 E1 0D 00 A0 E1 ?? ?? ?? ?? 00 60 50 E2 F4 FF FF 1A 00 00 95 E5 ?? ?? ?? ?? 00 00 50 E3 00 00 8B E5 0C 00 A0 03 E4 FF FF 0A 09 00 A0 E1 ?? ?? ?? ?? 07 00 A0 E1 ?? ?? ?? ?? 00 00 54 E3 00 00 8D E5 00 90 A0 E1 00 50 9B E5 0D 00 00 0A 0A 10 A0 E1 0D 00 A0 E1 ?? ?? ?? ?? 00 B0 A0 E1 ?? ?? ?? ?? 01 70 80 E2 0B 10 A0 E1 05 00 A0 E1 01 60 86 E2 07 20 A0 E1 ?? ?? ?? ?? 06 00 54 E1 07 50 85 E0 F1 FF FF CA 09 00 A0 E1 ?? ?? ?? ?? 00 00 A0 E3 C9 FF FF EA }
	condition:
		$1
}

rule file_30_0_0 {
	meta:
		name = "atexit"
		size = 20
		refs = "0010 __register_exitproc"
	strings:
		$1 = { 00 10 A0 E1 00 00 A0 E3 00 20 A0 E1 00 30 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_31_0_0 {
	meta:
		name = "print_e"
		size = 432
		refs = "0044 _dtoa_r 01a0 strcpy"
	strings:
		$1 = { F0 40 2D E9 1C D0 4D E2 30 40 9D E5 01 C0 84 E2 00 C0 8D E5 10 C0 8D E2 04 C0 8D E5 18 C0 8D E2 08 C0 8D E5 01 60 A0 E1 14 C0 8D E2 02 10 A0 E1 03 20 A0 E1 02 30 A0 E3 0C C0 8D E5 38 70 9D E5 34 50 DD E5 ?? ?? ?? ?? 27 3C A0 E3 00 10 A0 E1 10 00 9D E5 0F 30 83 E2 03 00 50 E1 4E 00 00 0A 00 20 D1 E5 04 70 97 E1 06 30 A0 E1 01 20 C3 E4 07 40 A0 01 11 00 00 0A 2E 20 A0 E3 01 20 C6 E5 01 20 D1 E5 00 00 52 E3 00 00 54 13 01 30 83 E2 0A 00 00 DA 03 60 86 E2 01 20 46 E5 02 20 D1 E5 01 40 44 E2 00 00 52 E3 00 00 54 13 06 30 A0 E1 01 10 81 E2 01 60 86 E2 F6 FF FF CA 10 00 9D E5 67 00 55 E3 65 50 A0 03 0B 00 00 0A 47 00 55 E3 45 50 A0 03 08 00 00 0A 00 00 54 E3 06 00 00 DA 00 20 A0 E3 30 10 A0 E3 02 10 C3 E7 01 20 82 E2 04 00 52 E1 FB FF FF 1A 02 30 83 E0 01 00 50 E2 03 10 A0 E1 01 50 C1 E4 2B 20 A0 53 00 20 60 42 01 20 C3 55 2D 00 A0 43 00 20 A0 51 01 00 C3 45 01 10 81 42 02 00 A0 41 01 10 81 52 63 00 52 E3 0E 00 00 CA 6C 30 9F E5 92 C3 C3 E0 C2 2F A0 E1 43 21 62 E0 02 C1 82 E0 01 30 A0 E1 30 20 82 E2 01 20 C3 E4 8C 00 40 E0 30 00 80 E2 00 20 A0 E3 01 00 C1 E5 01 20 C3 E5 1C D0 8D E2 F0 80 BD E8 34 30 9F E5 92 C3 C3 E0 C2 2F A0 E1 C3 32 62 E0 03 21 83 E0 02 21 82 E0 30 30 83 E2 02 21 40 E0 01 30 C1 E4 02 00 A0 E1 E5 FF FF EA 06 00 A0 E1 ?? ?? ?? ?? EF FF FF EA 67 66 66 66 1F 85 EB 51 }
	condition:
		$1
}

rule file_31_1_0 {
	meta:
		name = "_gcvt"
		size = 704
		refs = "0028 __ltdf2 0044 __eqdf2 0078 __ledf2 0088 _mprec_log10 00f8 _dtoa_r 02a8 strcpy"
	strings:
		$1 = { F0 47 2D E9 01 50 A0 E1 1C D0 4D E2 02 60 A0 E1 00 80 A0 E1 03 40 A0 E1 01 00 A0 E1 00 30 A0 E3 02 10 A0 E1 00 20 A0 E3 ?? ?? ?? ?? 00 00 50 E3 02 51 85 B2 00 30 A0 E3 05 00 A0 E1 06 10 A0 E1 00 20 A0 E3 ?? ?? ?? ?? 3C 70 9D E5 00 00 50 E3 30 30 A0 03 44 90 9D E5 40 A0 DD E5 00 30 C7 05 01 00 C7 05 81 00 00 0A 05 00 A0 E1 06 10 A0 E1 09 3D 8F E2 0C 00 93 E8 ?? ?? ?? ?? 00 00 50 E3 7D 00 00 DA 04 00 A0 E1 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 76 00 00 DA FF 25 A0 E3 03 26 82 E2 00 30 A0 E3 06 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 18 C0 8D E2 00 00 50 E3 04 C0 8D E5 14 C0 8D E2 06 20 A0 B1 03 30 A0 B3 06 20 A0 A1 02 30 A0 A3 05 10 A0 B1 08 00 A0 B1 05 10 A0 A1 08 00 A0 A1 08 C0 8D E5 10 C0 8D E2 0C C0 8D E5 00 40 8D E5 ?? ?? ?? ?? 18 20 9D E5 27 3C A0 E3 0F 30 83 E2 03 00 52 E1 63 00 00 0A 00 C0 D0 E5 00 00 5C E3 07 30 A0 01 0D 00 00 0A 00 00 52 E3 07 30 A0 C1 02 00 00 CA 5F 00 00 EA 00 00 52 E3 13 00 00 DA 01 C0 C3 E4 18 20 9D E5 01 20 42 E2 18 20 8D E5 01 C0 F0 E5 00 00 5C E3 01 40 44 E2 F5 FF FF 1A 00 00 54 E3 00 00 52 C3 30 10 A0 C3 07 00 00 DA 01 10 C3 E4 18 20 9D E5 01 40 44 E2 01 20 42 E2 00 00 54 E3 00 00 52 C3 18 20 8D E5 F7 FF FF CA 00 00 59 E3 02 00 00 1A 00 20 D0 E5 00 00 52 E3 32 00 00 0A 07 00 53 E1 07 20 A0 01 30 30 A0 03 01 30 C2 04 03 20 A0 11 2E 10 A0 E3 02 30 A0 E1 01 10 C3 E4 18 C0 9D E5 00 00 54 E3 00 10 A0 D3 01 10 A0 C3 AC CF 11 E0 0D 00 00 0A 02 20 82 E2 30 C0 A0 E3 01 C0 42 E5 18 30 9D E5 01 40 44 E2 01 30 83 E2 00 00 54 E3 00 10 A0 D3 01 10 A0 C3 A3 5F 11 E0 18 30 8D E5 02 30 A0 E1 01 20 82 E2 F3 FF FF 1A 00 20 D0 E5 00 00 52 E3 00 10 A0 03 01 10 01 12 00 00 51 E3 05 00 00 0A 01 20 C3 E4 01 20 F0 E5 01 40 44 E2 00 00 52 E3 00 00 54 13 F9 FF FF CA 00 00 59 E3 08 00 00 0A 00 00 54 E3 06 00 00 DA 00 20 A0 E3 30 10 A0 E3 02 10 C3 E7 01 20 82 E2 04 00 52 E1 FB FF FF 1A 02 30 83 E0 00 20 A0 E3 00 20 C3 E5 07 00 A0 E1 1C D0 8D E2 F0 87 BD E8 01 40 44 E2 05 20 A0 E1 06 30 A0 E1 08 00 A0 E1 07 10 A0 E1 10 04 8D E8 08 90 8D E5 EC FE FF EB F3 FF FF EA 00 10 A0 E1 07 00 A0 E1 ?? ?? ?? ?? EF FF FF EA 07 30 A0 E1 B3 FF FF EA E2 36 1A 3F 2D 43 1C EB }
	condition:
		$1
}

rule file_31_2_0 {
	meta:
		name = "ecvtbuf"
		size = 280
		refs = "0050 _dtoa_r 00f8 _realloc_r 0114 _impure_ptr"
	strings:
		$1 = { F0 47 2D E9 14 D0 4D E2 38 40 9D E5 00 00 54 E3 02 50 A0 E1 03 60 A0 E1 00 70 A0 E1 01 80 A0 E1 2B 00 00 0A E8 30 9F E5 00 00 93 E5 34 C0 9D E5 07 10 A0 E1 02 30 A0 E3 08 C0 8D E5 08 20 A0 E1 10 C0 8D E2 04 60 8D E5 0C C0 8D E5 00 50 8D E5 ?? ?? ?? ?? 10 30 9D E5 03 00 50 E1 04 10 A0 21 00 30 A0 23 0A 00 00 2A 04 10 A0 E1 00 20 A0 E1 00 30 A0 E3 03 C0 D0 E7 03 C0 C4 E7 10 C0 9D E5 01 20 82 E2 02 00 5C E1 01 10 81 E2 01 30 83 E2 F7 FF FF 8A 03 00 55 E1 08 00 00 DA 00 20 A0 E3 30 C0 A0 E3 02 C0 C1 E7 01 20 82 E2 03 00 82 E0 00 00 55 E1 FA FF FF CA 05 50 63 E0 05 10 81 E0 00 30 A0 E3 00 30 C1 E5 04 00 A0 E1 14 D0 8D E2 F0 87 BD E8 38 A0 9F E5 00 00 9A E5 50 30 90 E5 02 00 53 E1 54 40 90 C5 CF FF FF CA 01 90 82 E2 54 10 90 E5 09 20 A0 E1 ?? ?? ?? ?? 00 40 50 E2 F0 FF FF 0A 00 00 9A E5 50 90 80 E5 54 40 80 E5 C5 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_31_3_0 {
	meta:
		name = "fcvtbuf"
		size = 360
		refs = "0044 __ltdf2 0064 __gtdf2 0088 _dtoa_r 0144 _realloc_r 0164 _impure_ptr"
	strings:
		$1 = { F0 4F 2D E9 18 D0 4D E2 40 50 9D E5 00 00 55 E3 02 40 A0 E1 03 60 A0 E1 00 80 A0 E1 01 90 A0 E1 3C A0 9D E5 3A 00 00 0A 34 31 9F E5 00 70 93 E5 FF 25 A0 E3 08 00 A0 E1 09 10 A0 E1 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 07 00 00 AA BF 24 A0 E3 08 00 A0 E1 09 10 A0 E1 0F 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 23 00 00 CA 07 00 A0 E1 08 10 A0 E1 09 20 A0 E1 03 30 A0 E3 14 C0 8D E2 50 14 8D E8 ?? ?? ?? ?? 14 30 9D E5 00 10 96 E5 03 00 50 E1 00 10 61 E2 05 20 A0 21 06 00 00 2A 05 20 A0 E1 01 30 D0 E4 01 30 C2 E4 14 30 9D E5 00 00 53 E1 01 10 81 E2 F9 FF FF 8A 01 00 54 E1 08 00 00 DA 00 30 A0 E3 30 C0 A0 E3 03 C0 C2 E7 01 30 83 E2 01 00 83 E0 00 00 54 E1 FA FF FF CA 04 40 61 E0 04 20 82 E0 00 30 A0 E3 00 30 C2 E5 05 00 A0 E1 18 D0 8D E2 F0 8F BD E8 07 00 A0 E1 08 10 A0 E1 09 20 A0 E1 02 30 A0 E3 DA FF FF EA 48 B0 9F E5 00 70 9B E5 50 20 97 E5 23 30 84 E2 03 00 52 E1 54 50 97 C5 BF FF FF CA 24 30 84 E2 03 20 A0 E1 07 00 A0 E1 54 10 97 E5 10 30 8D E5 ?? ?? ?? ?? 00 50 50 E2 10 30 9D E5 E7 FF FF 0A 00 70 9B E5 50 30 87 E5 54 50 87 E5 B2 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_31_4_0 {
	meta:
		name = "_dcvt"
		size = 688
		refs = "01b4 _gcvt 01dc _dtoa_r 029c strcpy"
	strings:
		$1 = { F0 40 2D E9 1C D0 4D E2 38 60 DD E5 45 C0 46 E2 01 50 A0 E1 30 40 9D E5 02 10 A0 E1 3C 70 9D E5 03 20 A0 E1 22 00 5C E3 0C F1 9F 97 59 00 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 60 A0 E1 05 30 A0 E1 00 00 57 E3 6D 00 00 0A 06 00 50 E1 03 20 A0 01 30 30 A0 03 01 30 C2 04 03 20 A0 11 2E 10 A0 E3 02 30 A0 E1 01 10 C3 E4 18 00 9D E5 00 00 54 E3 00 10 A0 D3 01 10 A0 C3 A0 0F 11 E0 0D 00 00 0A 02 20 82 E2 30 00 A0 E3 01 00 42 E5 18 30 9D E5 01 40 44 E2 01 30 83 E2 00 00 54 E3 00 10 A0 D3 01 10 A0 C3 A3 CF 11 E0 18 30 8D E5 02 30 A0 E1 01 20 82 E2 F3 FF FF 1A 00 20 D6 E5 00 00 52 E3 00 10 A0 03 01 10 01 12 00 00 51 E3 05 00 00 0A 01 20 C3 E4 01 20 F6 E5 01 40 44 E2 00 00 52 E3 00 00 54 13 F9 FF FF CA 00 00 54 E3 06 00 00 DA 00 20 A0 E3 30 10 A0 E3 02 10 C3 E7 01 20 82 E2 04 00 52 E1 FB FF FF 1A 02 30 83 E0 00 20 A0 E3 00 20 C3 E5 05 00 A0 E1 1C D0 8D E2 F0 80 BD E8 00 00 54 E3 04 30 A0 11 01 30 A0 03 E0 00 8D E8 ?? ?? ?? ?? F6 FF FF EA 18 C0 8D E2 04 C0 8D E5 14 C0 8D E2 03 30 A0 E3 08 C0 8D E5 10 C0 8D E2 0C C0 8D E5 00 40 8D E5 ?? ?? ?? ?? 18 20 9D E5 27 3C A0 E3 00 00 54 E3 0F 30 83 E2 01 70 A0 13 03 00 52 E1 25 00 00 0A 00 C0 D0 E5 00 00 5C E3 26 00 00 0A 00 00 52 E3 05 30 A0 C1 00 60 A0 C1 02 00 00 CA A7 FF FF EA 00 00 52 E3 A7 FF FF DA 01 C0 C3 E4 18 20 9D E5 01 20 42 E2 18 20 8D E5 01 C0 F6 E5 00 00 5C E3 F6 FF FF 1A 00 00 52 E3 9E FF FF DA 30 C0 A0 E3 01 C0 C3 E4 18 20 9D E5 01 20 42 E2 00 00 52 E3 18 20 8D E5 F9 FF FF CA 00 00 57 E3 97 FF FF 1A 04 00 00 EA 01 20 A0 E1 05 10 A0 E1 D0 00 8D E8 A3 FD FF EB C4 FF FF EA 00 20 D6 E5 00 00 52 E3 BF FF FF 0A 8D FF FF EA 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? BC FF FF EA 00 60 A0 E1 05 30 A0 E1 E3 FF FF EA }
	condition:
		$1
}

rule file_32_0_0 {
	meta:
		name = "fileno"
		size = 52
		refs = "0024 __sinit 0030 _impure_ptr"
	strings:
		$1 = { 28 30 9F E5 00 30 93 E5 00 00 53 E3 10 40 2D E9 00 40 A0 E1 03 00 00 0A 38 20 93 E5 00 00 52 E3 03 00 A0 01 ?? ?? ?? ?? FE 00 D4 E1 10 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_33_1_0 {
	meta:
		name = "fcloseall"
		size = 16
		refs = "0008 _fcloseall_r 000c _global_impure_ptr"
	strings:
		$1 = { 04 30 9F E5 00 00 93 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_64_5_2 {
	meta:
		name = "_ZSt10unexpectedv"
		size = 16
		refs = "0008 _ZN10__cxxabiv112__unexpectedEPFvvE 000c _ZN10__cxxabiv120__unexpected_handlerE"
	strings:
		$1 = { 04 30 9F E5 00 00 93 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_64_3_2 {
	meta:
		name = "_ZSt9terminatev"
		size = 16
		refs = "0008 _ZN10__cxxabiv111__terminateEPFvvE 000c _ZN10__cxxabiv119__terminate_handlerE"
	strings:
		$1 = { 04 30 9F E5 00 00 93 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_415_0_0 {
	meta:
		name = "__errno"
		size = 16
		refs = "000c _impure_ptr"
	strings:
		$1 = { 04 30 9F E5 00 00 93 E5 1E FF 2F E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_221_0_0 {
	meta:
		name = "__getreent"
		size = 16
		refs = "000c _impure_ptr"
	strings:
		$1 = { 04 30 9F E5 00 00 93 E5 1E FF 2F E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_43_10_0 {
	meta:
		name = "_cleanup"
		size = 16
		refs = "0008 _cleanup_r 000c _global_impure_ptr"
	strings:
		$1 = { 04 30 9F E5 00 00 93 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_104_3_0 {
	meta:
		name = "_init_signal"
		size = 16
		refs = "0008 _init_signal_r 000c _impure_ptr"
	strings:
		$1 = { 04 30 9F E5 00 00 93 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_254_1_0 {
	meta:
		name = "drand48"
		size = 16
		refs = "0008 _drand48_r 000c _impure_ptr"
	strings:
		$1 = { 04 30 9F E5 00 00 93 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_46_0_0 {
	meta:
		name = "fork"
		size = 16
		refs = "0008 _fork_r 000c _impure_ptr"
	strings:
		$1 = { 04 30 9F E5 00 00 93 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_370_0_0 {
	meta:
		name = "getpid"
		size = 16
		refs = "0008 _getpid_r 000c _impure_ptr"
	strings:
		$1 = { 04 30 9F E5 00 00 93 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_277_1_0 {
	meta:
		name = "lrand48"
		size = 16
		refs = "0008 _lrand48_r 000c _impure_ptr"
	strings:
		$1 = { 04 30 9F E5 00 00 93 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_252_2_0 {
	meta:
		name = "malloc_stats"
		size = 16
		refs = "0008 _malloc_stats_r 000c _impure_ptr"
	strings:
		$1 = { 04 30 9F E5 00 00 93 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_107_1_0 {
	meta:
		name = "mrand48"
		size = 16
		refs = "0008 _mrand48_r 000c _impure_ptr"
	strings:
		$1 = { 04 30 9F E5 00 00 93 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_82_1_0 {
	meta:
		name = "tmpfile"
		size = 16
		refs = "0008 _tmpfile_r 000c _impure_ptr"
	strings:
		$1 = { 04 30 9F E5 00 00 93 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_169_0_0 {
	meta:
		name = "tzset"
		size = 16
		refs = "0008 _tzset_r 000c _impure_ptr"
	strings:
		$1 = { 04 30 9F E5 00 00 93 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_0_0 {
	meta:
		name = "hsearch"
		size = 40
		refs = "0014 hsearch_r"
	strings:
		$1 = { 04 E0 2D E5 18 C0 9F E5 08 D0 4D E2 04 30 8D E2 00 C0 8D E5 ?? ?? ?? ?? 04 00 9D E5 08 D0 8D E2 00 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_0_0 {
	meta:
		name = "iscntrl"
		size = 28
		refs = "0018 __ctype_ptr__"
	strings:
		$1 = { 10 30 9F E5 00 30 93 E5 00 30 83 E0 01 00 D3 E5 20 00 00 E2 1E FF 2F E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_36_0_0 {
	meta:
		name = "lldiv"
		size = 168
		refs = "0030 __divdi3 0050 __moddi3"
	strings:
		$1 = { 04 D0 4D E2 F0 4B 2D E9 20 30 8D E5 20 90 8D E2 00 03 99 E8 02 50 A0 E1 01 60 A0 E1 08 20 A0 E1 09 30 A0 E1 00 40 A0 E1 01 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 08 20 A0 E1 01 C0 A0 E1 00 B0 A0 E1 09 30 A0 E1 06 00 A0 E1 05 10 A0 E1 0C 70 A0 E1 ?? ?? ?? ?? 00 00 55 E3 0B 60 A0 E1 00 20 A0 E1 01 30 A0 E1 01 00 00 BA 00 00 51 E3 06 00 00 BA 08 20 84 E5 0C 30 84 E5 C0 00 84 E8 04 00 A0 E1 F0 4B BD E8 04 D0 8D E2 1E FF 2F E1 01 00 A0 E3 00 60 9B E0 00 10 A0 E3 01 70 A7 E0 08 20 52 E0 09 30 C3 E0 F1 FF FF EA }
	condition:
		$1
}

rule file_37_0_0 {
	meta:
		name = "iswalnum"
		size = 44
		refs = "0008 iswalpha 001c iswdigit"
	strings:
		$1 = { 10 40 2D E9 00 40 A0 E1 ?? ?? ?? ?? 00 00 50 E3 01 00 A0 13 10 80 BD 18 04 00 A0 E1 ?? ?? ?? ?? 00 00 50 E2 01 00 A0 13 10 80 BD E8 }
	condition:
		$1
}

rule file_38_0_0 {
	meta:
		name = "_iprintf_r"
		size = 52
		refs = "0020 _vfiprintf_r"
	strings:
		$1 = { 0E 00 2D E9 04 E0 2D E5 04 D0 4D E2 0C C0 8D E2 0C 30 A0 E1 08 10 90 E5 08 20 9D E5 00 C0 8D E5 ?? ?? ?? ?? 04 D0 8D E2 04 E0 9D E4 0C D0 8D E2 1E FF 2F E1 }
	condition:
		$1
}

rule file_51_1_0 {
	meta:
		name = "_printf_r"
		size = 52
		refs = "0020 _vfprintf_r"
	strings:
		$1 = { 0E 00 2D E9 04 E0 2D E5 04 D0 4D E2 0C C0 8D E2 0C 30 A0 E1 08 10 90 E5 08 20 9D E5 00 C0 8D E5 ?? ?? ?? ?? 04 D0 8D E2 04 E0 9D E4 0C D0 8D E2 1E FF 2F E1 }
	condition:
		$1
}

rule file_38_1_0 {
	meta:
		name = "iprintf"
		size = 64
		refs = "0028 _vfiprintf_r 003c _impure_ptr"
	strings:
		$1 = { 0F 00 2D E9 04 E0 2D E5 2C 30 9F E5 04 D0 4D E2 00 00 93 E5 0C C0 8D E2 0C 30 A0 E1 08 10 90 E5 08 20 9D E5 00 C0 8D E5 ?? ?? ?? ?? 04 D0 8D E2 04 E0 9D E4 10 D0 8D E2 1E FF 2F E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_51_0_0 {
	meta:
		name = "printf"
		size = 64
		refs = "0028 _vfprintf_r 003c _impure_ptr"
	strings:
		$1 = { 0F 00 2D E9 04 E0 2D E5 2C 30 9F E5 04 D0 4D E2 00 00 93 E5 0C C0 8D E2 0C 30 A0 E1 08 10 90 E5 08 20 9D E5 00 C0 8D E5 ?? ?? ?? ?? 04 D0 8D E2 04 E0 9D E4 10 D0 8D E2 1E FF 2F E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_39_0_0 {
	meta:
		name = "eisinf"
		size = 72
	strings:
		$1 = { B2 21 D0 E1 7F 3C A0 E3 82 28 A0 E1 FF 30 83 E2 A2 28 A0 E1 03 00 52 E1 01 00 00 0A 00 00 A0 E3 1E FF 2F E1 00 30 A0 E3 B3 20 90 E1 00 00 52 E3 02 30 83 E2 F8 FF FF 1A 12 00 53 E3 F9 FF FF 1A 01 00 A0 E3 1E FF 2F E1 }
	condition:
		$1
}

rule file_39_1_0 {
	meta:
		name = "emovi"
		size = 232
	strings:
		$1 = { F2 31 D0 E1 00 00 53 E3 00 20 E0 B3 00 30 A0 A3 B2 20 C1 B0 B2 30 C1 A0 B2 31 D0 E1 02 39 C3 E3 B0 30 C1 E1 01 C0 A0 E1 B2 30 DC E0 7F 2C A0 E3 83 38 A0 E1 FF 20 82 E2 A3 38 A0 E1 02 00 53 E1 0C 00 00 0A 00 30 A0 E3 B2 30 C1 E1 02 C0 8C E2 12 30 40 E2 B0 21 D0 E1 02 00 40 E2 03 00 50 E1 B4 20 C1 E1 02 10 81 E2 F9 FF FF 1A 00 30 A0 E3 B2 31 CC E1 1E FF 2F E1 B2 21 D0 E1 03 20 02 E0 03 00 52 E1 05 00 00 0A 16 30 81 E2 00 20 A0 E3 B2 20 E1 E1 03 00 51 E1 FB FF FF 1A 1E FF 2F E1 00 30 A0 E3 B3 20 90 E1 00 00 52 E3 02 30 83 E2 02 00 00 1A 12 00 53 E3 F9 FF FF 1A F1 FF FF EA 00 20 A0 E3 B0 20 CC E1 14 30 40 E2 B0 21 D0 E1 02 00 40 E2 03 00 50 E1 B4 20 C1 E1 02 10 81 E2 F9 FF FF 1A 1E FF 2F E1 }
	condition:
		$1
}

rule file_39_2_0 {
	meta:
		name = "eshdn1"
		size = 64
	strings:
		$1 = { 16 10 80 E2 00 30 A0 E3 B4 20 D0 E1 01 00 12 E3 01 30 83 13 A2 20 A0 E1 02 00 13 E3 B4 20 C0 E1 02 29 82 13 B4 20 C0 11 02 00 80 E2 01 00 50 E1 1E FF 2F 01 83 38 A0 E1 23 38 A0 E1 F1 FF FF EA }
	condition:
		$1
}

rule file_39_3_0 {
	meta:
		name = "eshup1"
		size = 68
	strings:
		$1 = { 16 30 80 E2 00 20 A0 E3 B2 10 D3 E1 02 09 11 E3 81 C8 A0 E1 01 20 82 13 2C 18 A0 E1 02 00 12 E3 B2 10 C3 E1 01 10 81 13 B2 10 C3 11 02 30 43 E2 00 00 53 E1 1E FF 2F 01 82 28 A0 E1 22 28 A0 E1 F0 FF FF EA }
	condition:
		$1
}

rule file_39_4_0 {
	meta:
		name = "m16m"
		size = 164
	strings:
		$1 = { F0 01 2D E9 00 C0 A0 E3 1C D0 4D E2 00 08 A0 E1 B6 C1 CD E1 B8 C1 CD E1 0D 30 A0 E1 20 08 A0 E1 16 10 81 E2 16 C0 8D E2 02 60 8D E2 B2 40 D1 E1 00 00 54 E3 B2 40 4C 01 0B 00 00 0A 90 04 04 E0 B0 70 DC E1 B2 80 DC E1 04 58 A0 E1 25 58 A0 E1 08 50 85 E0 24 48 87 E0 25 48 84 E0 24 78 A0 E1 B2 70 4C E1 B2 50 CC E1 B0 40 CC E1 02 C0 4C E2 06 00 5C E1 02 10 41 E2 EB FF FF 1A 02 10 A0 E3 81 00 A0 E1 B0 C0 93 E1 01 10 81 E2 0D 00 51 E3 B0 C0 82 E1 F9 FF FF 1A 1C D0 8D E2 F0 01 BD E8 1E FF 2F E1 }
	condition:
		$1
}

rule file_39_5_0 {
	meta:
		name = "edivm"
		size = 652
		refs = "00b8 __udivsi3"
	strings:
		$1 = { F0 4F 2D E9 01 50 A0 E1 B0 10 D1 E1 B4 13 C2 E1 02 80 A0 E1 34 30 82 E2 38 D0 4D E2 B2 20 D5 E1 04 00 8D E5 B2 20 C3 E1 4A 20 88 E2 00 10 A0 E3 B4 10 C3 E1 02 30 83 E2 02 00 53 E1 FA FF FF 1A 05 00 A0 E1 A3 FF FF EB 04 20 9D E5 B6 20 D2 E1 04 30 85 E2 1C 40 8D E2 14 20 8D E5 00 30 8D E5 06 10 85 E2 02 28 62 E0 16 30 84 E2 10 10 8D E5 0C 20 8D E5 08 30 8D E5 18 80 8D E5 08 B0 A0 E1 02 90 A0 E3 14 60 85 E2 00 10 9D E5 10 20 9D E5 B0 00 D1 E1 B0 30 D2 E1 00 08 83 E0 0C 30 9D E5 03 00 50 E1 01 08 A0 83 01 00 40 82 00 70 A0 81 04 00 00 8A 14 10 9D E5 ?? ?? ?? ?? 00 08 A0 E1 20 78 A0 E1 07 00 A0 E1 04 10 9D E5 04 20 A0 E1 A1 FF FF EB 02 30 A0 E3 83 20 A0 E1 B2 10 95 E1 B2 20 94 E1 01 00 52 E1 01 30 83 E2 31 00 00 1A 0D 00 53 E3 F7 FF FF 1A 08 20 9D E5 05 A0 A0 E1 05 30 A0 E1 00 10 A0 E3 B8 C1 D3 E1 B2 00 D2 E1 0C 00 60 E0 00 00 61 E0 02 20 42 E2 20 18 A0 E1 04 00 52 E1 B8 01 C3 E1 01 10 01 E2 02 30 43 E2 F4 FF FF 1A B8 73 CB E1 05 30 A0 E1 B6 10 D3 E1 B4 10 C3 E1 02 30 83 E2 06 00 53 E1 FA FF FF 1A 01 90 89 E2 00 30 9D E5 00 20 A0 E3 0D 00 59 E3 B4 21 C3 E1 02 B0 8B E2 C6 FF FF 1A 18 80 9D E5 16 20 85 E2 00 00 A0 E3 B4 30 DA E1 02 A0 8A E2 02 00 5A E1 03 00 80 E1 FA FF FF 1A 00 30 A0 E3 B4 13 D8 E1 B3 10 85 E1 02 30 83 E2 1A 00 53 E3 02 80 88 E2 F9 FF FF 1A 00 00 50 E2 01 00 A0 13 38 D0 8D E2 F0 8F BD E8 02 00 51 E1 CD FF FF 2A 01 70 47 E2 05 00 9D E9 07 78 A0 E1 27 78 A0 E1 00 10 A0 E1 02 30 A0 E1 00 C0 A0 E3 B2 A0 D3 E1 B8 81 D1 E1 0A 80 68 E0 08 C0 6C E0 B2 C0 C3 E1 02 30 43 E2 2C C8 A0 E1 04 00 53 E1 01 C0 0C E2 02 10 41 E2 F4 FF FF 1A 02 30 A0 E3 83 10 A0 E1 B1 C0 95 E1 B1 10 94 E1 0C 00 51 E1 01 30 83 E2 07 00 00 1A 0D 00 53 E3 B2 FF FF 0A 83 10 A0 E1 B1 C0 95 E1 B1 10 94 E1 0C 00 51 E1 01 30 83 E2 F7 FF FF 0A 01 00 5C E1 AA FF FF 2A 00 30 A0 E3 B2 C0 D2 E1 B8 11 D0 E1 0C 10 61 E0 01 30 63 E0 B2 30 C2 E1 02 20 42 E2 23 38 A0 E1 02 00 54 E1 01 30 03 E2 02 00 40 E2 F4 FF FF 1A 01 70 47 E2 07 78 A0 E1 27 78 A0 E1 9A FF FF EA }
	condition:
		$1
}

rule file_39_6_0 {
	meta:
		name = "emulm"
		size = 304
	strings:
		$1 = { F0 4F 2D E9 01 A0 A0 E1 B0 10 D1 E1 B4 13 C2 E1 02 50 A0 E1 34 90 82 E2 B2 20 DA E1 28 D0 4D E2 B2 20 C9 E1 02 30 A0 E3 05 20 A0 E1 01 30 83 E2 00 10 A0 E3 0D 00 53 E3 B8 13 C2 E1 02 20 82 E2 F9 FF FF 1A 0C 70 8D E2 16 30 87 E2 18 20 89 E2 04 30 8D E5 06 30 89 E2 08 50 8D E5 00 A0 8D E5 02 B0 80 E2 16 60 80 E2 00 80 A0 E3 14 40 49 E2 02 A0 A0 E1 03 50 A0 E1 B2 00 D6 E1 00 00 50 E3 18 00 00 1A B0 30 DA E1 03 80 88 E1 09 30 A0 E1 B6 11 D3 E1 B8 11 C3 E1 02 30 43 E2 04 00 53 E1 FA FF FF 1A 02 60 46 E2 00 20 A0 E3 0B 00 56 E1 B2 20 45 E1 EF FF FF 1A 08 50 9D E5 00 A0 9D E5 00 30 A0 E3 B4 13 D5 E1 B3 10 8A E1 02 30 83 E2 1A 00 53 E3 02 50 85 E2 F9 FF FF 1A 08 00 A0 E1 28 D0 8D E2 F0 8F BD E8 00 10 9D E5 07 20 A0 E1 F6 FE FF EB 04 20 9D E5 09 30 A0 E1 00 10 A0 E3 B8 C1 D3 E1 B2 00 D2 E1 00 00 8C E0 01 00 80 E0 02 20 42 E2 20 18 A0 E1 07 00 52 E1 B8 01 C3 E1 01 10 01 E2 02 30 43 E2 F4 FF FF 1A D4 FF FF EA }
	condition:
		$1
}

rule file_39_7_0 {
	meta:
		name = "ecmp"
		size = 320
	strings:
		$1 = { 70 40 2D E9 B2 21 D0 E1 7F 3C A0 E3 82 28 A0 E1 FF 30 83 E2 A2 28 A0 E1 03 00 52 E1 38 D0 4D E2 01 40 A0 E1 1E 00 00 0A B2 21 D4 E1 7F 3C A0 E3 82 28 A0 E1 FF 30 83 E2 A2 28 A0 E1 03 00 52 E1 22 00 00 0A 1C 50 8D E2 05 10 A0 E1 78 FE FF EB 04 00 A0 E1 0D 10 A0 E1 75 FE FF EB BC 01 DD E1 B0 30 DD E1 00 00 53 E1 0D 60 A0 E1 1F 00 00 0A 01 30 A0 E3 83 20 A0 E1 B2 10 95 E1 00 00 51 E3 01 30 83 E2 26 00 00 1A B2 20 96 E1 00 00 52 E3 23 00 00 1A 0C 00 53 E3 F5 FF FF 1A 00 00 A0 E3 08 00 00 EA 00 30 A0 E3 01 00 00 EA 12 00 53 E3 DC FF FF 0A B3 20 90 E1 00 00 52 E3 02 30 83 E2 F9 FF FF 0A 01 00 E0 E3 38 D0 8D E2 70 80 BD E8 00 30 A0 E3 B3 20 94 E1 00 00 52 E3 02 30 83 E2 F7 FF FF 1A 12 00 53 E3 F9 FF FF 1A D4 FF FF EA 00 00 53 E3 01 00 A0 03 00 00 E0 13 00 30 A0 E3 B3 20 95 E1 B3 10 96 E1 01 00 52 E1 02 30 83 E2 07 00 00 1A 18 00 53 E3 F8 FF FF 1A 00 00 A0 E3 E8 FF FF EA 00 00 50 E3 01 00 A0 03 00 00 E0 13 E4 FF FF EA 02 00 51 E1 00 00 60 22 E1 FF FF EA }
	condition:
		$1
}

rule file_39_8_0 {
	meta:
		name = "eshift"
		size = 420
	strings:
		$1 = { F0 40 2D E9 00 50 51 E2 00 40 A0 E1 05 00 A0 01 F0 80 BD 08 18 70 84 E2 2A 00 00 BA 0F 00 55 E3 04 00 84 C2 05 10 A0 C1 14 20 84 C2 0B 00 00 DA 04 30 A0 E1 B6 C0 D3 E1 B4 C0 C3 E1 02 30 83 E2 02 00 53 E1 FA FF FF 1A 10 10 41 E2 00 30 A0 E3 0F 00 51 E3 B4 31 C0 E1 F4 FF FF CA 0F 50 05 E2 07 00 55 E3 05 C0 A0 C1 16 00 84 C2 0C 00 00 DA 00 30 A0 E1 00 10 A0 E3 B2 20 D3 E1 02 14 81 E1 B2 10 C3 E1 02 30 43 E2 04 00 53 E1 22 14 A0 E1 F8 FF FF 1A 08 C0 4C E2 07 00 5C E3 F3 FF FF CA 07 50 05 E2 00 00 55 E3 04 00 00 DA 01 50 45 E2 04 00 A0 E1 58 FE FF EB 00 00 55 E3 FA FF FF CA 00 00 A0 E3 F0 80 BD E8 00 60 65 E2 0F 00 56 E3 00 50 A0 D3 11 00 00 DA 06 10 A0 E1 00 50 A0 E3 14 20 44 E2 06 00 84 E2 B0 30 D7 E1 03 50 85 E1 04 30 A0 E1 B6 C1 D3 E1 B8 C1 C3 E1 02 30 43 E2 02 00 53 E1 FA FF FF 1A 10 10 41 E2 00 30 A0 E3 0F 00 51 E3 B2 30 40 E1 F2 FF FF CA 0F 60 06 E2 07 00 56 E3 11 00 00 DA 06 C0 A0 E1 16 00 84 E2 00 30 D7 E5 00 10 A0 E3 03 50 85 E1 04 30 A0 E1 B4 20 D3 E1 22 14 81 E1 B4 10 C3 E1 02 30 83 E2 02 2C A0 E1 00 00 53 E1 22 18 A0 E1 F7 FF FF 1A 08 C0 4C E2 07 00 5C E3 F0 FF FF CA 07 60 06 E2 00 00 56 E3 07 00 00 DA B0 30 D7 E1 01 60 46 E2 01 30 03 E2 04 00 A0 E1 03 50 85 E1 12 FE FF EB 00 00 56 E3 F7 FF FF CA 00 00 55 E2 01 00 A0 13 F0 80 BD E8 }
	condition:
		$1
}

rule file_39_9_0 {
	meta:
		name = "enormlz"
		size = 332
	strings:
		$1 = { B4 30 D0 E1 00 00 53 E3 F0 40 2D E9 00 40 A0 E1 04 60 80 E2 31 00 00 1A B6 20 D0 E1 02 09 12 E3 06 70 80 E2 03 50 A0 11 03 50 A0 01 14 10 80 02 28 00 00 1A 00 00 52 E3 0D 00 00 1A 04 30 A0 E1 B6 20 D3 E1 B4 20 C3 E1 02 30 83 E2 01 00 53 E1 FA FF FF 1A 10 50 85 E2 00 30 A0 E3 A0 00 55 E3 B4 31 C6 E1 1B 00 00 0A B0 20 D7 E1 00 00 52 E3 F1 FF FF 0A FF 0C 12 E3 0F 00 00 1A 16 00 84 E2 00 30 A0 E1 00 10 A0 E3 B2 20 D3 E1 02 14 81 E1 B2 10 C3 E1 02 30 43 E2 04 00 53 E1 22 14 A0 E1 F8 FF FF 1A B0 20 D7 E1 FF 0C 12 E3 08 50 85 E2 F2 FF FF 0A 00 00 00 EA B0 20 D7 E1 02 09 12 E3 04 00 A0 E1 03 00 00 1A 01 50 85 E2 E9 FD FF EB A0 00 55 E3 F7 FF FF DA 05 00 A0 E1 F0 80 BD E8 FF 5C 13 E2 0F 00 00 0A 00 20 A0 E1 00 10 A0 E3 16 00 80 E2 00 00 00 EA B4 30 D2 E1 23 14 81 E1 B4 10 C2 E1 02 20 82 E2 03 3C A0 E1 00 00 52 E1 23 18 A0 E1 F7 FF FF 1A B4 30 D4 E1 07 50 E0 E3 00 00 00 EA B0 30 D6 E1 00 00 53 E3 04 00 A0 E1 E8 FF FF 0A 01 50 45 E2 BE FD FF EB 90 00 75 E3 F7 FF FF AA 05 00 A0 E1 F0 80 BD E8 }
	condition:
		$1
}

rule file_39_10_0 {
	meta:
		name = "emdnorm"
		size = 1124
	strings:
		$1 = { F0 4F 2D E9 08 D0 4D E2 03 60 A0 E1 01 40 A0 E1 02 80 A0 E1 00 50 A0 E1 30 70 9D E5 A4 FF FF EB 7F 3C A0 E3 06 60 60 E0 FE 30 83 E2 03 00 56 E1 00 30 A0 C3 01 30 A0 D3 90 00 50 E3 00 30 A0 D3 00 00 53 E3 06 00 00 0A 18 30 85 E2 00 00 A0 E3 B2 00 E5 E1 03 00 55 E1 FB FF FF 1A 08 D0 8D E2 F0 8F BD E8 00 00 56 E3 78 00 00 BA 2C 30 9D E5 00 00 53 E3 18 A0 85 02 5F 00 00 0A 00 20 97 E5 04 10 97 E5 02 00 51 E1 1C 00 00 0A 1A 20 87 E2 00 30 A0 E3 00 90 A0 E3 B3 90 82 E1 02 30 83 E2 1A 00 53 E3 FA FF FF 1A 38 00 51 E3 CC 00 00 0A 8D 00 00 CA 18 00 51 E3 A1 00 00 0A 35 00 51 E3 BC 00 00 0A 0C 20 A0 E3 0B 30 A0 E3 00 B0 E0 E3 01 C0 A0 E3 08 20 87 E5 B4 B1 C7 E1 02 29 A0 E3 B8 C1 C7 E1 0C 30 87 E5 B6 21 C7 E1 01 20 A0 E3 83 30 87 E0 00 10 87 E5 BA 21 C3 E1 01 20 A0 E1 00 00 56 E3 18 30 85 C2 03 A0 A0 C1 57 00 00 DA 08 C0 97 E5 8C B0 A0 E1 BB 00 95 E1 B4 91 D7 E1 8F 00 52 E3 0B B0 85 E0 04 90 8D E5 00 B0 8D E5 09 20 00 E0 12 00 00 CA 01 A0 8C E2 0C 00 5A E3 8A A0 85 D0 0C 00 A0 D1 BE 00 00 CA B0 90 DA E1 01 00 80 E2 00 00 59 E3 01 20 82 13 00 B0 A0 E3 0C 00 50 E3 B2 B0 CA E0 F7 FF FF 1A 8C C0 A0 E1 BC 00 95 E1 0C C0 85 E0 B4 91 D7 E1 00 C0 8D E5 03 A0 A0 E1 00 C0 9D E5 09 00 C0 E1 B0 00 CC E1 B6 01 D7 E1 00 00 12 E1 4A 00 00 0A 00 00 52 E1 40 00 00 0A 00 20 A0 E3 1A 70 87 E2 02 C0 A0 E1 B2 40 93 E1 B8 01 D7 E1 00 00 84 E0 0C 00 80 E0 B2 00 83 E1 02 20 42 E2 20 08 A0 E1 16 00 72 E3 01 C0 00 E2 02 70 47 E2 F4 FF FF 1A 00 00 56 E3 3A 00 00 DA B4 30 D5 E1 00 00 53 E3 02 00 00 0A 05 00 A0 E1 3C FD FF EB 01 60 86 E2 7F 3C A0 E3 FE 30 83 E2 00 00 A0 E3 03 00 56 E1 B0 00 CA E1 09 00 00 DA 02 39 E0 E3 B2 30 C5 E1 02 30 A0 E3 83 20 A0 E1 01 30 83 E2 00 10 A0 E3 0C 00 53 E3 B2 10 85 E1 F9 FF FF 1A 87 FF FF EA 00 00 56 E3 00 20 A0 B3 B2 20 C5 B1 B2 60 C5 A1 82 FF FF EA 90 00 76 E3 18 30 85 B2 50 00 00 AA 00 10 A0 E3 B2 10 E5 E1 03 00 55 E1 FB FF FF 1A 7A FF FF EA 40 00 52 E3 2A 00 00 0A 90 00 52 E3 63 00 00 0A B8 31 D5 E1 05 00 A0 E1 01 30 03 E2 03 40 84 E1 15 FD FF EB 04 10 97 E5 18 30 85 E2 03 A0 A0 E1 01 20 A0 E1 99 FF FF EA 00 00 54 E3 61 00 00 1A 0C 20 97 E5 82 20 A0 E1 B2 00 95 E1 B8 21 D7 E1 02 00 10 E1 B6 FF FF 1A 03 A0 A0 E1 C2 FF FF EA 40 00 51 E3 C2 FF FF 0A 90 00 51 E3 C0 FF FF 0A 05 00 A0 E1 10 FD FF EB BD FF FF EA 40 00 51 E3 1E 00 00 0A 71 00 51 E3 71 FF FF 1A 02 09 E0 E3 0A 30 A0 E3 02 29 A0 E3 B4 01 C7 E1 01 09 A0 E3 08 30 87 E5 B6 01 C7 E1 B8 21 C7 E1 0C 30 87 E5 72 FF FF EA 08 C0 97 E5 8C 30 A0 E1 B3 20 95 E1 B4 31 D7 E1 04 30 8D E5 03 20 02 E0 18 30 85 E2 7C FF FF EA 04 30 A0 E3 FF B0 A0 E3 80 C0 A0 E3 01 0C A0 E3 08 30 87 E5 0C 30 87 E5 B4 B1 C7 E1 B6 C1 C7 E1 B8 01 C7 E1 01 2C A0 E3 5F FF FF EA 07 20 A0 E3 08 20 87 E5 02 29 A0 E3 06 30 A0 E3 B6 21 C7 E1 01 90 A0 E3 00 20 E0 E3 B4 21 C7 E1 B8 91 C7 E1 0C 30 87 E5 01 20 A0 E3 53 FF FF EA 05 00 A0 E1 06 10 A0 E1 58 FE FF EB 00 00 50 E3 01 40 A0 13 2C FF FF EA 3E 2B E0 E3 06 30 A0 E3 B4 21 C7 E1 02 9B A0 E3 01 2B A0 E3 B6 21 C7 E1 08 30 87 E5 B8 91 C7 E1 0C 30 87 E5 02 2B A0 E3 42 FF FF EA 06 30 A0 E3 FF B0 A0 E3 80 C0 A0 E3 01 0C A0 E3 08 30 87 E5 B4 B1 C7 E1 B6 C1 C7 E1 B8 01 C7 E1 0C 30 87 E5 01 2C A0 E3 37 FF FF EA 08 B0 97 E5 8B B0 A0 E1 BB 00 95 E1 B4 91 D7 E1 18 30 85 E2 0B B0 85 E0 00 B0 8D E5 09 20 00 E0 03 A0 A0 E1 52 FF FF EA 00 00 58 E3 58 FF FF 0A 03 A0 A0 E1 64 FF FF EA 8C C0 A0 E1 BC 00 95 E1 0C C0 85 E0 04 90 9D E5 00 C0 8D E5 03 A0 A0 E1 47 FF FF EA }
	condition:
		$1
}

rule file_39_11_0 {
	meta:
		name = "eiremain"
		size = 284
	strings:
		$1 = { F0 4F 2D E9 0C D0 4D E2 01 60 A0 E1 02 40 A0 E1 B2 B0 D0 E1 00 50 A0 E1 8C FE FF EB 0B B0 60 E0 06 00 A0 E1 B2 70 D6 E1 88 FE FF EB 34 80 84 E2 07 70 60 E0 00 30 A0 E3 00 20 A0 E3 B3 20 88 E1 02 30 83 E2 1A 00 53 E3 FA FF FF 1A 07 00 5B E1 24 00 00 CA 16 30 85 E2 08 30 8D E5 18 A0 88 E2 02 30 A0 E3 83 20 A0 E1 B2 10 96 E1 B2 20 95 E1 01 00 52 E1 01 30 83 E2 24 00 00 1A 0D 00 53 E3 F7 FF FF 1A 08 20 9D E5 06 30 A0 E1 00 00 A0 E3 B8 C1 D3 E1 B2 10 D2 E1 0C 10 61 E0 01 10 60 E0 02 20 42 E2 21 08 A0 E1 05 00 52 E1 B8 11 C3 E1 01 00 00 E2 02 30 43 E2 F4 FF FF 1A 01 90 A0 E3 08 00 A0 E1 7F FC FF EB B0 30 DA E1 03 90 89 E1 B0 90 CA E1 01 70 47 E2 06 00 A0 E1 79 FC FF EB 07 00 5B E1 DD FF FF DA 00 C0 A0 E3 0C 10 A0 E1 06 00 A0 E1 07 30 A0 E1 0C 20 A0 E1 04 40 8D E5 00 C0 8D E5 A4 FE FF EB 0C D0 8D E2 F0 8F BD E8 00 90 A0 83 E9 FF FF 8A D9 FF FF EA }
	condition:
		$1
}

rule file_39_12_0 {
	meta:
		name = "enan"
		size = 260
	strings:
		$1 = { 40 00 51 E3 04 40 2D E5 36 00 00 0A 11 00 00 DA 90 00 51 E3 25 00 00 0A D0 00 51 E3 14 00 00 0A 71 00 51 E3 09 00 00 1A C4 10 9F E5 08 C0 A0 E3 00 30 A0 E3 03 20 A0 E1 B3 40 91 E1 01 20 82 E2 02 00 5C E1 B3 40 80 E1 02 30 83 E2 F9 FF FF CA 10 00 BD E8 1E FF 2F E1 18 00 51 E3 1E 00 00 0A 35 00 51 E3 F9 FF FF 1A 04 C0 A0 E3 84 10 9F E5 EE FF FF EA 00 30 A0 E1 00 40 A0 E3 B2 40 C3 E0 02 29 E0 E3 B2 20 C0 E1 03 29 A0 E3 B4 20 C3 E1 B2 40 C3 E1 12 30 80 E2 00 20 A0 E3 B8 20 C0 E1 02 00 80 E2 03 00 50 E1 FA FF FF 1A E7 FF FF EA 00 30 A0 E3 00 20 A0 E3 B3 20 80 E1 02 30 83 E2 10 00 53 E3 FA FF FF 1A 02 39 E0 E3 B2 31 C0 E1 03 39 A0 E3 B0 31 C0 E1 DC FF FF EA 02 C0 A0 E3 14 10 9F E5 D1 FF FF EA 06 C0 A0 E3 0C 10 9F E5 CE FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_39_13_0 {
	meta:
		name = "emovo"
		size = 220
	strings:
		$1 = { B0 30 D0 E1 00 00 53 E3 B2 30 D0 11 B2 30 D0 01 02 39 83 13 02 20 80 E2 B2 31 C1 11 B2 31 C1 01 02 20 82 12 02 20 82 02 04 40 2D E5 7F 3C A0 E3 B2 40 52 E1 FF 30 83 E2 10 C0 81 12 10 C0 81 02 03 00 54 E1 00 30 A0 13 06 00 00 0A B2 10 F2 E1 B3 10 8C E1 02 30 43 E2 12 00 73 E3 FA FF FF 1A 10 00 BD E8 1E FF 2F E1 B2 30 D0 E1 04 30 03 E0 04 00 53 E1 0B 00 00 0A 00 30 A0 E3 00 20 A0 E3 B3 20 81 E1 02 30 83 E2 12 00 53 E3 FA FF FF 1A B2 31 D1 E1 03 30 E0 E1 02 39 03 E2 03 30 E0 E1 B2 31 C1 E1 ED FF FF EA 03 30 A0 E3 83 20 A0 E1 B2 20 90 E1 00 00 52 E3 01 30 83 E2 02 00 00 1A 0D 00 53 E3 F8 FF FF 1A EA FF FF EA 01 00 A0 E1 90 10 A0 E3 10 00 BD E8 87 FF FF EA }
	condition:
		$1
}

rule file_39_14_0 {
	meta:
		name = "emul"
		size = 864
	strings:
		$1 = { F0 47 2D E9 B2 C1 D0 E1 00 50 A0 E1 8C C8 A0 E1 7F 0C A0 E3 FF 00 80 E2 AC C8 A0 E1 00 00 5C E1 40 D0 4D E2 01 60 A0 E1 02 40 A0 E1 03 70 A0 E1 39 00 00 0A B2 21 D6 E1 7F 3C A0 E3 82 28 A0 E1 FF 30 83 E2 A2 28 A0 E1 03 00 52 E1 41 00 00 0A 05 00 A0 E1 80 FB FF EB 00 00 50 E3 4C 00 00 1A 06 00 A0 E1 7C FB FF EB 00 00 50 E3 04 00 00 0A 05 00 A0 E1 E0 12 9F E5 FC FC FF EB 00 00 50 E3 48 00 00 0A 05 00 A0 E1 73 FB FF EB 00 00 50 E3 58 00 00 0A B2 11 D5 E1 7F 3C A0 E3 81 28 A0 E1 FF 30 83 E2 A2 28 A0 E1 03 00 52 E1 49 00 00 0A A1 07 A0 E1 B2 11 D6 E1 7F 3C A0 E3 81 28 A0 E1 FF 30 83 E2 A2 28 A0 E1 03 00 52 E1 39 00 00 0A A1 37 A0 E1 03 00 50 E1 00 30 A0 03 02 39 A0 13 B2 31 C4 01 B2 31 C4 11 00 30 A0 E3 00 20 A0 E3 B3 20 84 E1 02 30 83 E2 12 00 53 E3 FA FF FF 1A B2 31 D4 E1 03 30 E0 E1 02 39 03 E2 03 30 E0 E1 B2 31 C4 E1 40 D0 8D E2 F0 87 BD E8 00 30 A0 E3 01 00 00 EA 12 00 53 E3 C1 FF FF 0A B3 20 95 E1 00 00 52 E3 02 30 83 E2 F9 FF FF 0A 00 30 A0 E3 B3 20 95 E1 B3 20 84 E1 02 30 83 E2 14 00 53 E3 FA FF FF 1A EE FF FF EA 00 30 A0 E3 01 00 00 EA 12 00 53 E3 B9 FF FF 0A B3 20 96 E1 00 00 52 E3 02 30 83 E2 F9 FF FF 0A 00 30 A0 E3 B3 20 96 E1 B3 20 84 E1 02 30 83 E2 14 00 53 E3 FA FF FF 1A DF FF FF EA 06 00 A0 E1 BC 11 9F E5 B3 FC FF EB 00 00 50 E3 AD FF FF 1A 04 00 A0 E1 90 10 A0 E3 1A FF FF EB D6 FF FF EA 00 30 A0 E3 B3 20 96 E1 00 00 52 E3 02 30 83 E2 3D 00 00 1A 12 00 53 E3 F9 FF FF 1A BD FF FF EA 00 30 A0 E3 B3 20 95 E1 00 00 52 E3 02 30 83 E2 37 00 00 1A 12 00 53 E3 F9 FF FF 1A AD FF FF EA 06 00 A0 E1 16 FB FF EB 00 00 50 E3 A2 FF FF 1A 24 A0 8D E2 05 00 A0 E1 0A 10 A0 E1 08 50 8D E2 21 FB FF EB 06 00 A0 E1 05 10 A0 E1 1E FB FF EB B6 62 DD E1 00 00 56 E3 BA 90 DD E1 0A 30 A0 01 14 10 8A 02 17 00 00 0A 09 30 A0 E1 00 00 53 E3 09 80 A0 E1 05 30 A0 01 14 10 85 02 04 00 00 0A 20 00 00 EA B4 20 D3 E1 00 00 52 E3 02 30 83 E2 19 00 00 1A 01 00 53 E1 F9 FF FF 1A 00 30 A0 E3 00 20 A0 E3 B3 20 84 E1 02 30 83 E2 14 00 53 E3 FA FF FF 1A A0 FF FF EA B4 20 D3 E1 00 00 52 E3 02 30 83 E2 29 00 00 1A 01 00 53 E1 F9 FF FF 1A 00 30 A0 E3 00 20 A0 E3 B3 20 84 E1 02 30 83 E2 14 00 53 E3 FA FF FF 1A 93 FF FF EA 00 30 A0 E3 81 FF FF EA 00 00 A0 E3 77 FF FF EA 05 00 A0 E1 1D FD FF EB 09 80 60 E0 05 10 A0 E1 07 20 A0 E1 0A 00 A0 E1 13 FC FF EB FF 3D 46 E2 3E 30 43 E2 00 10 A0 E1 08 30 83 E0 05 00 A0 E1 40 C0 A0 E3 00 20 A0 E3 00 C0 8D E5 04 70 8D E5 61 FD FF EB B4 22 DD E1 B8 30 DD E1 03 00 52 E1 00 20 E0 13 00 30 A0 03 B8 20 CD 11 05 00 A0 E1 04 10 A0 E1 07 20 A0 E1 B8 30 CD 01 F7 FE FF EB 72 FF FF EA 0A 00 A0 E1 00 FD FF EB BA 30 DD E1 00 60 60 E2 B9 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_39_15_0 {
	meta:
		name = "e53toe"
		size = 532
	strings:
		$1 = { 70 40 2D E9 1C D0 4D E2 02 60 A0 E1 00 30 A0 E1 01 40 A0 E1 00 20 A0 E3 0D 50 A0 E1 00 10 A0 E3 B2 10 85 E1 02 20 82 E2 1A 00 52 E3 FA FF FF 1A B0 00 D3 E1 02 09 10 E3 00 20 E0 13 B0 10 CD E1 B0 20 CD 11 0F 20 C0 E3 82 28 A0 E1 7F 1C A0 E3 F0 10 81 E2 A2 28 A0 E1 0F 00 00 E2 01 00 52 E1 10 10 80 E3 B4 10 CD E1 32 00 00 0A 22 22 B0 E1 11 00 00 0A 0F CB 82 E2 B2 C0 CD E1 02 20 83 E2 B2 30 D3 E1 B6 30 CD E1 B4 30 D2 E1 BA 30 CD E1 B2 20 D2 E1 0D 00 A0 E1 04 10 E0 E3 B8 20 CD E1 6A FC FF EB 0D 00 A0 E1 04 10 A0 E1 06 20 A0 E1 C3 FE FF EB 1C D0 8D E2 70 80 BD E8 10 C0 C1 E3 B4 C0 CD E1 02 20 83 E2 B2 30 D3 E1 B6 30 CD E1 B4 30 D2 E1 BA 30 CD E1 0F 3B A0 E3 B2 30 CD E1 B2 20 D2 E1 04 10 E0 E3 0D 00 A0 E1 B8 20 CD E1 56 FC FF EB 0D 00 A0 E1 BD FC FF EB 90 00 50 E3 04 30 85 C2 1C 20 8D C2 34 00 00 DA 00 10 A0 E3 B2 10 43 E1 02 30 83 E2 02 00 53 E1 E0 FF FF 0A 00 10 A0 E3 B2 10 43 E1 02 30 83 E2 02 00 53 E1 F5 FF FF 1A DA FF FF EA 00 00 50 E3 23 00 00 1A B2 20 D3 E1 00 00 52 E3 20 00 00 1A B4 20 D3 E1 00 00 52 E3 1D 00 00 1A B6 30 D3 E1 00 00 53 E3 1A 00 00 1A 00 10 A0 E3 B3 10 84 E1 02 30 83 E2 14 00 53 E3 FA FF FF 1A 00 30 A0 E3 00 20 A0 E3 B3 20 84 E1 02 30 83 E2 12 00 53 E3 FA FF FF 1A B2 31 D4 E1 B0 20 DD E1 A3 37 E0 E1 83 37 E0 E1 00 00 52 E3 B2 31 C4 E1 C1 FF FF 0A 7F 2C A0 E3 83 18 A0 E1 FF 20 82 E2 A1 18 A0 E1 02 00 51 E1 0B 00 00 0A 02 39 23 E2 B2 31 C4 E1 B8 FF FF EA 04 00 A0 E1 90 10 A0 E3 38 FE FF EB B4 FF FF EA B2 30 DD E1 01 30 83 E2 03 00 60 E0 B2 00 CD E1 AB FF FF EA 00 20 A0 E3 B2 10 94 E1 00 00 51 E3 02 20 82 E2 AA FF FF 1A 12 00 52 E3 F9 FF FF 1A EB FF FF EA }
	condition:
		$1
}

rule file_39_16_0 {
	meta:
		name = "ediv"
		size = 916
	strings:
		$1 = { F0 47 2D E9 B2 C1 D0 E1 00 50 A0 E1 8C C8 A0 E1 7F 0C A0 E3 FF 00 80 E2 AC C8 A0 E1 00 00 5C E1 40 D0 4D E2 01 60 A0 E1 02 40 A0 E1 03 70 A0 E1 39 00 00 0A B2 21 D6 E1 7F 3C A0 E3 82 28 A0 E1 FF 30 83 E2 A2 28 A0 E1 03 00 52 E1 41 00 00 0A 05 00 A0 E1 34 13 9F E5 85 FB FF EB 00 00 50 E3 4B 00 00 0A 05 00 A0 E1 FC F9 FF EB 00 00 50 E3 03 00 00 0A 06 00 A0 E1 F8 F9 FF EB 00 00 50 E3 48 00 00 1A 06 00 A0 E1 F4 F9 FF EB 00 80 50 E2 58 00 00 0A B2 11 D5 E1 7F 3C A0 E3 81 28 A0 E1 FF 30 83 E2 A2 28 A0 E1 03 00 52 E1 41 00 00 0A A1 07 A0 E1 B2 11 D6 E1 7F 3C A0 E3 81 28 A0 E1 FF 30 83 E2 A2 28 A0 E1 03 00 52 E1 41 00 00 0A A1 37 A0 E1 03 00 50 E1 00 30 A0 03 02 39 A0 13 B2 31 C4 01 B2 31 C4 11 00 30 A0 E3 00 20 A0 E3 B3 20 84 E1 02 30 83 E2 12 00 53 E3 FA FF FF 1A B2 31 D4 E1 03 30 E0 E1 02 39 03 E2 03 30 E0 E1 B2 31 C4 E1 40 D0 8D E2 F0 87 BD E8 00 30 A0 E3 01 00 00 EA 12 00 53 E3 C1 FF FF 0A B3 20 95 E1 00 00 52 E3 02 30 83 E2 F9 FF FF 0A 00 30 A0 E3 B3 20 95 E1 B3 20 84 E1 02 30 83 E2 14 00 53 E3 FA FF FF 1A EE FF FF EA 00 30 A0 E3 01 00 00 EA 12 00 53 E3 B9 FF FF 0A B3 20 96 E1 00 00 52 E3 02 30 83 E2 F9 FF FF 0A 00 30 A0 E3 B3 20 96 E1 B3 20 84 E1 02 30 83 E2 14 00 53 E3 FA FF FF 1A DF FF FF EA 06 00 A0 E1 F0 11 9F E5 34 FB FF EB 00 00 50 E3 AE FF FF 1A 04 00 A0 E1 90 10 A0 E3 9B FD FF EB D6 FF FF EA 00 30 A0 E3 B3 20 95 E1 00 00 52 E3 02 30 83 E2 4A 00 00 1A 12 00 53 E3 F9 FF FF 1A B5 FF FF EA 00 30 A0 E3 B3 20 96 E1 00 00 52 E3 02 30 83 E2 44 00 00 1A 12 00 53 E3 F9 FF FF 1A B5 FF FF EA 05 00 A0 E1 97 F9 FF EB 00 00 50 E3 05 00 00 0A 00 30 A0 E3 B8 30 84 E1 02 80 88 E2 14 00 58 E3 FA FF FF 1A BC FF FF EA 24 A0 8D E2 05 00 A0 E1 0A 10 A0 E1 08 50 8D E2 9C F9 FF EB 06 00 A0 E1 05 10 A0 E1 99 F9 FF EB BA 60 DD E1 00 00 56 E3 B6 92 DD E1 05 30 A0 01 14 10 85 02 1E 00 00 0A 09 30 A0 E1 00 00 53 E3 09 80 A0 E1 0A 30 A0 01 14 10 8A 02 04 00 00 0A 27 00 00 EA B4 20 D3 E1 00 00 52 E3 02 30 83 E2 20 00 00 1A 01 00 53 E1 F9 FF FF 1A B8 30 DD E1 B4 22 DD E1 03 00 52 E1 02 39 A0 13 00 30 A0 03 B2 31 C4 11 B2 31 C4 01 00 30 A0 E3 00 20 A0 E3 B3 20 84 E1 02 30 83 E2 12 00 53 E3 FA FF FF 1A 8E FF FF EA B4 20 D3 E1 00 00 52 E3 02 30 83 E2 29 00 00 1A 01 00 53 E1 F9 FF FF 1A 00 30 A0 E3 00 20 A0 E3 B3 20 84 E1 02 30 83 E2 14 00 53 E3 FA FF FF 1A 86 FF FF EA 00 00 A0 E3 6C FF FF EA 00 30 A0 E3 72 FF FF EA 0A 00 A0 E1 91 FB FF EB 09 80 60 E0 05 10 A0 E1 07 20 A0 E1 0A 00 A0 E1 E4 F9 FF EB FF 3D 86 E2 3F 30 83 E2 00 10 A0 E1 03 30 68 E0 05 00 A0 E1 40 C0 A0 E3 00 20 A0 E3 00 C0 8D E5 04 70 8D E5 D5 FB FF EB B4 22 DD E1 B8 30 DD E1 03 00 52 E1 00 20 E0 13 00 30 A0 03 B8 20 CD 11 05 00 A0 E1 04 10 A0 E1 07 20 A0 E1 B8 30 CD 01 6B FD FF EB 65 FF FF EA 05 00 A0 E1 74 FB FF EB B6 32 DD E1 00 60 60 E2 B2 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_39_17_0 {
	meta:
		name = "_ldcheck"
		size = 136
	strings:
		$1 = { 10 40 2D E9 18 00 90 E8 74 D0 4D E2 74 00 8D E2 18 00 20 E9 00 30 E0 E3 50 40 8D E2 0D 20 A0 E1 00 30 8D E5 04 10 A0 E1 90 30 A0 E3 04 30 8D E5 6D FF FF EB B2 26 DD E1 7F 3C A0 E3 82 28 A0 E1 FF 30 83 E2 A2 28 A0 E1 03 00 52 E1 00 00 A0 13 01 00 00 0A 74 D0 8D E2 10 80 BD E8 00 30 A0 E3 B3 20 94 E1 00 00 52 E3 02 30 83 E2 03 00 00 1A 12 00 53 E3 F9 FF FF 1A 02 00 A0 E3 F4 FF FF EA 01 00 A0 E3 F2 FF FF EA }
	condition:
		$1
}

rule file_39_18_0 {
	meta:
		name = "_strtold"
		size = 2844
		refs = "0020 strlen 05ec free 08a4 calloc"
	strings:
		$1 = { F0 4F 2D E9 00 30 E0 E3 1B DE 4D E2 04 31 8D E5 90 30 A0 E3 08 31 8D E5 14 10 8D E5 00 60 A0 E1 ?? ?? ?? ?? 02 40 80 E2 C8 00 54 E3 1A 02 00 CA 00 00 A0 E3 24 00 8D E5 3C 80 8D E2 00 30 D6 E5 20 00 53 E3 00 20 A0 13 06 00 A0 11 30 20 8D 15 07 00 00 1A 01 30 A0 E3 03 20 D6 E7 20 00 52 E3 03 00 86 E0 03 20 A0 E1 01 30 83 E2 F9 FF FF 0A 30 20 8D E5 00 00 54 E3 08 10 A0 D1 0E 00 00 DA 00 30 D0 E5 08 10 A0 E1 00 00 53 E3 01 30 C1 E4 00 30 A0 13 05 00 00 1A 07 00 00 EA 03 20 D0 E7 00 00 52 E3 03 20 C8 E7 01 10 81 E2 02 00 00 0A 01 30 83 E2 03 00 54 E1 F7 FF FF CA 00 30 A0 E3 00 30 C1 E5 08 C1 9D E5 90 20 A0 E3 1C C0 8D E5 08 21 8D E5 63 4F 8D E2 00 00 A0 E3 B3 00 84 E1 02 30 83 E2 1A 00 53 E3 FA FF FF 1A 17 5E 8D E2 00 10 A0 E3 16 30 84 E2 16 20 85 E2 08 10 8D E5 18 10 8D E5 28 10 8D E5 0C 10 8D E5 20 10 8D E5 2C 10 8D E5 10 10 8D E5 34 20 8D E5 38 30 8D E5 08 70 A0 E1 00 30 D7 E5 08 B0 A0 E1 30 80 43 E2 09 00 58 E3 03 10 A0 E1 77 00 00 8A 0C C0 9D E5 10 00 9D E5 00 20 8C E1 08 20 92 E1 0C 20 8D 05 10 20 8D 05 6A 00 00 0A 18 C0 9D E5 01 20 2C E2 02 00 10 E1 25 00 00 0A FF 20 08 E2 09 00 52 E3 07 20 A0 81 04 00 00 8A 07 20 A0 E1 01 10 F2 E5 30 00 41 E2 09 00 50 E3 FB FF FF 9A 7F 10 01 E2 45 00 51 E3 65 00 51 13 07 00 00 0A 0A 00 51 E3 00 00 51 13 04 00 00 0A 20 00 51 E3 0D 00 51 13 01 00 00 0A 2C 00 51 E3 E2 00 00 1A 01 10 52 E5 30 00 51 E3 06 00 00 1A 02 30 52 E5 7A 00 A0 E3 30 00 53 E3 01 00 42 E5 01 20 42 E2 F9 FF FF 0A 00 30 D7 E5 7A 00 53 E3 01 10 A0 03 10 10 8D 05 18 10 8D 05 42 00 00 0A 01 20 A0 E3 18 20 8D E5 01 CC 8D E2 B0 39 DC E1 00 00 53 E3 C0 00 00 1A 10 00 9D E5 00 00 50 E3 20 10 9D 15 04 00 A0 E1 01 10 81 12 20 10 8D 15 03 F9 FF EB 00 30 A0 E3 B3 20 94 E1 B3 20 85 E1 02 30 83 E2 18 00 53 E3 FA FF FF 1A 00 30 A0 E3 01 CC 8D E2 B8 38 CC E1 05 00 A0 E1 F8 F8 FF EB 05 00 A0 E1 F6 F8 FF EB 34 20 8D E2 0C 00 92 E8 02 10 A0 E1 03 00 A0 E1 00 C0 A0 E3 07 90 A0 E1 B2 A0 D0 E1 B2 70 D1 E1 07 70 8A E0 0C 70 87 E0 02 10 41 E2 27 C8 A0 E1 05 00 51 E1 B2 70 C0 E1 01 C0 0C E2 02 00 40 E2 F4 FF FF 1A 09 70 A0 E1 00 10 A0 E3 00 00 A0 E3 B1 00 85 E1 02 10 81 E2 1A 00 51 E3 FA FF FF 1A 01 1C 8D E2 B6 88 C1 E1 00 10 A0 E3 B2 C0 D3 E1 B2 00 D2 E1 00 00 8C E0 01 00 80 E0 02 20 42 E2 20 18 A0 E1 02 00 55 E1 B2 00 C3 E1 01 10 01 E2 02 30 43 E2 F4 FF FF 1A 0C 00 9D E5 01 00 80 E2 0C 00 8D E5 01 70 87 E2 00 30 D7 E5 30 80 43 E2 09 00 58 E3 03 10 A0 E1 87 FF FF 9A 7A 00 53 E3 03 F1 9F 97 87 00 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 10 20 9D E5 00 00 52 E3 28 30 9D E5 20 C0 9D 05 0C 00 9D E5 08 30 83 E1 01 C0 4C 02 01 00 80 E2 28 30 8D E5 20 C0 8D 05 0C 00 8D E5 01 70 87 E2 6F FF FF EA 0B 80 A0 E1 04 00 A0 E1 D0 10 A0 E3 CD FB FF EB 01 0C 8D E2 BE 58 D0 E1 7F 3C A0 E3 85 28 A0 E1 A2 28 A0 E1 FF 30 83 E2 03 00 52 E1 1C 10 9D E5 08 20 9D E5 08 11 8D E5 BC 28 C0 E1 CB 00 00 0A 08 30 9D E5 00 00 53 E3 02 39 A0 13 01 0C 8D E2 00 C0 A0 E3 B8 CA C0 E1 B8 3A C0 11 7F 3E A0 E3 0E 30 83 E2 03 00 55 E1 A2 00 00 9A 01 1C 8D E2 B8 2A D1 E1 7F 2C 82 E3 F0 20 82 E3 1B 3E 8D E2 B8 20 63 E1 00 20 A0 E3 02 30 83 E2 BA 2A C1 E1 B4 20 C3 E1 B2 20 C3 E1 24 30 9D E5 00 00 53 E3 08 00 A0 11 ?? ?? ?? ?? 14 C0 9D E5 00 00 5C E3 30 00 9D 15 00 80 68 10 08 70 87 10 07 60 86 10 00 60 8C 15 6A 1F 8D E2 03 00 91 E8 1B DE 8D E2 F0 8F BD E8 0B 80 A0 E1 00 A0 A0 E3 20 20 9D E5 0A A0 62 E0 00 00 5A E3 35 00 00 DA 01 CC 8D E2 B0 39 DC E1 00 00 53 E3 31 00 00 1A 17 5E 8D E2 16 90 84 E2 16 B0 85 E2 00 30 A0 E3 B3 00 94 E1 B3 00 85 E1 02 30 83 E2 18 00 53 E3 FA FF FF 1A 00 10 A0 E3 01 2C 8D E2 B8 18 C2 E1 05 00 A0 E1 EF F7 FF EB 05 00 A0 E1 ED F7 FF EB 09 20 A0 E1 0B 30 A0 E1 00 10 A0 E3 B2 C0 D3 E1 B2 00 D2 E1 00 00 8C E0 01 00 80 E0 02 20 42 E2 20 18 A0 E1 04 00 52 E1 B2 00 C3 E1 01 10 01 E2 02 30 43 E2 F4 FF FF 1A 05 00 A0 E1 DD F7 FF EB 01 CC 8D E2 B4 37 DC E1 00 00 53 E3 0D 00 00 1A 01 A0 4A E2 B3 00 95 E1 B3 00 84 E1 02 30 83 E2 18 00 53 E3 FA FF FF 1A 00 10 A0 E3 01 2C 8D E2 00 00 5A E3 B4 1A C2 E1 02 00 00 0A B0 39 D2 E1 00 00 53 E3 D0 FF FF 0A 04 00 A0 E1 AB F9 FF EB 90 00 50 E3 77 00 00 DA 00 30 A0 E3 00 C0 A0 E3 B3 C0 84 E1 02 30 83 E2 1A 00 53 E3 FA FF FF 1A 87 FF FF EA 0B 80 A0 E1 00 30 A0 E3 00 C0 A0 E3 B3 C0 84 E1 02 30 83 E2 1A 00 53 E3 FA FF FF 1A 02 39 E0 E3 01 0C 8D E2 BE 38 C0 E1 7C FF FF EA 01 30 F7 E5 2D 00 53 E3 01 30 F7 05 01 00 A0 13 00 00 E0 03 4D 1D A0 E3 2B 00 53 E3 0B 80 A0 E1 01 30 F7 05 31 10 81 E2 00 A0 A0 E3 00 00 00 EA 00 30 D7 E5 0A 21 8A E0 82 20 83 E0 30 30 43 E2 09 00 53 E3 9D 00 00 8A 30 A0 42 E2 01 00 5A E1 01 70 87 E2 F5 FF FF DA 01 00 70 E3 DD FF FF 1A 00 30 A0 E3 00 10 A0 E3 B3 10 84 E1 02 30 83 E2 1A 00 53 E3 FA FF FF 1A 5D FF FF EA 10 10 9D E5 00 00 51 E3 56 FF FF 1A 01 20 A0 E3 10 20 8D E5 01 70 87 E2 C2 FE FF EA 2C 30 9D E5 00 00 53 E3 A8 00 00 1A 01 C8 A0 E3 01 C0 4C E2 01 00 A0 E3 08 C0 8D E5 2C 00 8D E5 01 70 87 E2 B8 FE FF EA 2C 20 9D E5 00 00 52 E3 45 FF FF 1A 01 30 A0 E3 2C 30 8D E5 01 70 87 E2 B1 FE FF EA 00 00 55 E3 28 00 00 0A 04 00 A0 E1 05 10 A0 E3 F2 F8 FF EB 05 5A A0 E1 25 58 A0 E1 01 CC 8D E2 B0 39 DC E1 0F 20 03 E2 B8 3A DC E1 02 20 85 E1 03 20 82 E1 1B 3E 8D E2 B8 20 63 E1 B2 09 DC E1 B4 19 DC E1 02 30 83 E2 BA 0A CC E1 B2 10 C3 E1 B6 29 DC E1 B4 20 C3 E1 50 FF FF EA 01 10 A0 E3 04 00 A0 E1 ?? ?? ?? ?? 01 10 A0 E3 00 80 A0 E1 24 10 8D E5 E0 FD FF EA 04 30 A0 E1 14 10 84 E2 01 00 00 EA 01 00 53 E1 2E FF FF 0A B6 20 D3 E1 00 00 52 E3 02 30 83 E2 F9 FF FF 0A 6A 0F 8D E2 35 10 A0 E3 E9 FA FF EB 3C FF FF EA 04 00 A0 E1 04 10 A0 E3 C9 F8 FF EB D7 FF FF EA 01 39 60 E2 40 C0 A0 E3 28 10 9D E5 04 00 A0 E1 00 C0 8D E5 8E 30 83 E2 41 CF 8D E2 00 20 A0 E3 04 C0 8D E5 7A F9 FF EB 01 0C 8D E2 BE 08 D0 E1 00 00 5A E3 0C 00 8D E5 0A 10 A0 01 2D 00 00 0A 45 00 00 BA 01 10 A0 E3 55 2F 8D E2 18 10 8D E5 10 20 8D E5 B8 21 9F E5 00 30 A0 E3 17 5E 8D E2 B3 10 92 E1 B3 10 85 E1 02 30 83 E2 14 00 53 E3 FA FF FF 1A 9C B1 9F E5 01 90 A0 E3 02 00 00 EA 01 0A 59 E3 09 00 00 CA 14 B0 4B E2 0A 00 19 E1 89 90 A0 E1 F9 FF FF 0A 0B 00 A0 E1 05 10 A0 E1 05 20 A0 E1 41 3F 8D E2 31 FB FF EB F3 FF FF EA 05 00 A0 E1 10 10 9D E5 D6 F6 FF EB 18 20 9D E5 01 00 72 E3 2C 00 00 0A 01 0C 8D E2 B6 55 D0 E1 04 10 A0 E1 41 2F 8D E2 10 00 9D E5 F4 F7 FF EB FF 5D 45 E2 0C 20 9D E5 3E 50 45 E2 05 20 82 E0 0C 20 8D E5 00 10 A0 E1 0C C0 9D E5 0F 3B 4C E2 35 C0 A0 E3 08 C1 8D E5 40 C0 A0 E3 00 C0 8D E5 04 00 A0 E1 41 CF 8D E2 00 20 A0 E3 04 C0 8D E5 3B F9 FF EB CC FE FF EA 01 00 70 E3 04 00 00 0A 4D 3D A0 E3 04 30 83 E2 03 00 5A E1 3F FF FF CA F8 FE FF EA 4D 3D E0 E3 00 A0 6A E2 30 30 43 E2 03 00 5A E1 5B FF FF BA F2 FE FF EA 00 A0 6A E2 01 0A 5A E3 16 00 00 CA 00 30 E0 E3 55 CF 8D E2 18 30 8D E5 10 C0 8D E5 B5 FF FF EA 01 3C 8D E2 04 10 A0 E1 10 00 9D E5 41 2F 8D E2 B6 55 D3 E1 24 F7 FF EB FF 5D 65 E2 0C C0 9D E5 3F 50 85 E2 05 C0 8C E0 00 10 A0 E1 0C C0 8D E5 D1 FF FF EA 01 18 A0 E3 01 10 41 E2 0B 80 A0 E1 08 10 8D E5 A2 FE FF EA 55 0F 8D E2 10 00 8D E5 10 10 9D E5 44 00 9F E5 8F F6 FF EB 01 3C 8D E2 10 00 9D E5 04 10 A0 E1 41 2F 8D E2 B6 55 D3 E1 0D F7 FF EB 0C C0 9D E5 FF 3D 8C E2 3F 30 83 E2 03 50 65 E0 00 00 E0 E3 0C 50 8D E5 01 AA 4A E2 18 00 8D E5 8F FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_39_19_0 {
	meta:
		name = "_ldtoa_r"
		size = 5020
		refs = "0054 _Bfree 04d8 sprintf 0680 _Balloc 0698 strcpy"
	strings:
		$1 = { F0 4F 2D E9 40 C0 90 E5 71 DF 4D E2 00 E0 E0 E3 3C E0 8D E5 00 00 5C E3 90 E0 A0 E3 18 00 8D E5 40 E0 8D E5 20 30 8D E5 BC 11 8D E5 C0 21 8D E5 F0 41 9D E5 0A 00 00 0A 44 30 90 E5 04 30 8C E5 44 30 90 E5 01 20 A0 E3 12 33 A0 E1 0C 10 A0 E1 08 30 8C E5 ?? ?? ?? ?? 18 20 9D E5 00 30 A0 E3 40 30 82 E5 63 AF 8D E2 0A 10 A0 E1 3C 20 8D E2 6F 0F 8D E2 8E FB FF EB 01 3C 8D E2 BE 29 D3 E1 7F 3C A0 E3 82 18 A0 E1 FF 30 83 E2 A1 18 A0 E1 03 00 51 E1 12 02 00 0A 02 09 12 E3 01 30 A0 13 00 30 84 15 01 00 00 1A 00 30 A0 E3 00 30 84 E5 20 C0 9D E5 03 00 5C E3 02 02 00 0A 20 00 9D E5 00 00 50 E3 14 10 A0 03 24 10 8D 05 0C 02 00 1A 82 28 A0 E1 7F 3C A0 E3 FF 30 83 E2 A2 28 A0 E1 40 E0 9D E5 03 00 52 E1 28 E0 8D E5 E7 01 00 0A 90 30 A0 E3 40 30 8D E5 17 4E 8D E2 00 30 A0 E3 B3 00 9A E1 B3 00 84 E1 02 30 83 E2 14 00 53 E3 FA FF FF 1A 01 1C 8D E2 B2 38 D1 E1 02 09 13 E3 01 E8 A0 13 00 20 A0 03 01 E0 4E 12 D0 0F 9F E5 02 39 C3 13 01 CC 8D 12 14 20 8D 05 14 E0 8D 15 B2 38 CC 11 55 7F 8D E2 00 30 A0 E3 4B 9F 80 E2 B3 10 99 E1 B3 10 87 E1 02 30 83 E2 14 00 53 E3 FA FF FF 1A 01 2C 8D E2 B2 38 D2 E1 00 00 53 E3 51 01 00 1A B3 20 94 E1 00 00 52 E3 02 30 83 E2 55 01 00 1A 12 00 53 E3 F9 FF FF 1A 00 80 A0 E3 47 6F 8D E2 07 00 A0 E1 06 10 A0 E1 15 F6 FF EB 00 30 A0 E3 B3 00 96 E1 B3 00 87 E1 02 30 83 E2 18 00 53 E3 FA FF FF 1A 01 3C 8D E2 00 20 A0 E3 BC 26 C3 E1 04 00 A0 E1 06 10 A0 E1 09 F6 FF EB 00 30 A0 E3 B3 C0 96 E1 B3 C0 84 E1 02 30 83 E2 18 00 53 E3 FA FF FF 1A 00 E0 A0 E3 01 3C 8D E2 3C 60 8D E2 07 00 A0 E1 04 10 A0 E1 06 20 A0 E1 B8 E8 C3 E1 B1 94 A0 E3 92 F9 FF EB 49 9B A0 E1 71 CF 8D E2 B9 C0 9C E1 00 00 5C E3 1C C0 8D E5 8E 01 00 1A 16 E0 84 E2 4E 5F 8D E2 10 E0 8D E5 16 B0 85 E2 04 00 A0 E1 C8 1E 9F E5 60 F7 FF EB 00 00 50 E3 85 01 00 0A 04 00 A0 E1 33 F6 FF EB 00 30 A0 E3 B3 E0 94 E1 B3 E0 85 E1 02 30 83 E2 18 00 53 E3 FA FF FF 1A 00 10 A0 E3 01 2C 8D E2 B0 15 C2 E1 05 00 A0 E1 28 F6 FF EB 05 00 A0 E1 26 F6 FF EB 10 30 9D E5 0B 20 A0 E1 00 10 A0 E3 B2 C0 D3 E1 B2 00 D2 E1 00 00 8C E0 01 00 80 E0 02 20 42 E2 20 18 A0 E1 05 00 52 E1 B2 00 C3 E1 01 10 01 E2 02 30 43 E2 F4 FF FF 1A 07 00 A0 E1 04 10 A0 E1 06 20 A0 E1 62 F9 FF EB 71 CF 8D E2 B9 30 9C E1 00 00 53 E3 01 80 48 E2 D4 FF FF 0A 14 00 9D E5 20 10 9D E5 00 00 50 E3 2D 20 A0 13 20 20 A0 03 8C 20 CD 15 8C 20 CD 05 03 00 51 E3 89 01 00 0A 24 20 9D E5 0A 00 53 E3 10 20 8D E5 8C 01 00 0A 10 C0 9D E5 30 30 83 E2 00 00 5C E3 8D 30 CD E5 90 B0 8D B2 2E 30 A0 E3 8E 30 CD E5 01 B0 4B B2 38 00 00 BA 90 E0 8D E2 01 E0 4E E2 14 E0 8D E5 4E 5F 8D E2 16 20 85 E2 B1 94 A0 E3 16 30 84 E2 14 B0 9D E5 1C 20 8D E5 2C 80 8D E5 49 9B A0 E1 00 60 A0 E3 03 80 A0 E1 04 00 A0 E1 EA F5 FF EB 00 30 A0 E3 B3 00 94 E1 B3 00 85 E1 02 30 83 E2 18 00 53 E3 FA FF FF 1A 00 10 A0 E3 01 2C 8D E2 B0 15 C2 E1 05 00 A0 E1 DF F5 FF EB 05 00 A0 E1 DD F5 FF EB 1C 20 9D E5 08 30 A0 E1 00 10 A0 E3 B2 C0 D3 E1 B2 00 D2 E1 00 00 8C E0 01 00 80 E0 02 20 42 E2 20 18 A0 E1 05 00 52 E1 B2 00 C3 E1 01 10 01 E2 02 30 43 E2 F4 FF FF 1A 07 00 A0 E1 04 10 A0 E1 3C 20 8D E2 19 F9 FF EB 71 CF 8D E2 09 30 DC E7 14 E0 9D E5 30 30 83 E2 06 30 CE E7 10 00 9D E5 01 60 86 E2 06 00 50 E1 01 B0 8B E2 D4 FF FF AA 2C 80 9D E5 B1 34 A0 E3 43 3B A0 E1 71 1F 8D E2 B3 30 91 E1 04 00 53 E3 01 B0 4B E2 24 00 00 DA 05 00 53 E3 1E 02 00 0A 10 20 9D E5 00 00 52 E3 01 30 5B E5 01 20 4B E2 54 01 00 BA 7F 30 03 E2 2E 00 53 E3 13 00 00 0A 01 30 83 E2 39 00 53 E3 00 30 C2 E5 16 00 00 DA 02 30 A0 E1 30 00 A0 E3 01 00 43 E4 01 20 52 E5 7F 20 02 E2 05 00 00 EA 39 00 51 E3 01 10 43 E4 0D 00 00 DA 00 20 D3 E5 01 00 C3 E5 7F 20 02 E2 2E 00 52 E3 01 10 82 E2 03 20 A0 E1 F5 FF FF 1A 01 30 52 E5 01 30 83 E2 39 00 53 E3 01 30 42 E5 31 30 A0 C3 01 30 42 C5 01 80 88 C2 0B 00 A0 E1 34 1C 9F E5 08 20 A0 E1 ?? ?? ?? ?? 28 C0 9D E5 0A 00 A0 E1 40 C0 8D E5 4C 80 8D E5 2F F5 FF EB 00 30 50 E2 D4 00 00 1A 01 EC 8D E2 BE 19 DE E1 7F 2C A0 E3 81 18 A0 E1 FF 20 82 E2 A1 18 A0 E1 02 00 51 E1 C8 00 00 0A 8C 30 DD E5 4C 20 9D E5 EC 01 9D E5 01 20 82 E2 00 00 53 E3 00 20 80 E5 8C 30 8D 02 0E 00 00 0A 2E 00 53 E3 8C 30 8D 12 02 00 00 1A B0 00 00 EA 2E 00 52 E3 AF 00 00 0A 01 20 F3 E5 00 00 52 E3 FA FF FF 1A 8C 10 8D E2 01 00 53 E1 02 00 00 9A 01 20 73 E5 45 00 52 E3 FA FF FF 1A 00 20 A0 E3 00 20 C3 E5 8C 30 DD E5 2D 00 53 E3 20 00 53 13 8C 10 8D 12 04 00 00 1A 8C 10 8D E2 01 30 F1 E5 20 00 53 E3 2D 00 53 13 FB FF FF 0A 00 20 A0 E3 8C 00 8D E2 00 00 00 EA 02 30 D1 E7 00 00 53 E3 02 30 C0 E7 00 40 82 E0 01 20 82 E2 F9 FF FF 1A 20 20 9D E5 02 00 52 E3 01 00 A0 03 03 00 00 0A 4C 00 9D E5 24 30 9D E5 03 00 50 E1 03 00 A0 B1 01 30 54 E5 30 00 53 E3 01 30 44 E2 0E 00 00 1A 8C 20 8D E2 04 20 62 E0 02 00 50 E1 0A 00 00 AA 00 C0 A0 E3 02 00 00 EA 02 00 50 E1 01 30 43 E2 05 00 00 AA 01 10 53 E5 30 00 51 E3 01 20 42 E2 00 C0 C3 E5 03 40 A0 E1 F6 FF FF 0A 20 C0 9D E5 03 00 5C E3 89 00 00 0A E8 11 9D E5 09 00 81 E2 18 20 9D E5 00 10 A0 E3 17 00 50 E3 44 10 82 E5 07 00 00 9A 04 30 A0 E3 83 30 A0 E1 14 20 83 E2 00 00 52 E1 01 10 81 E2 FA FF FF 9A 18 30 9D E5 44 10 83 E5 18 00 9D E5 ?? ?? ?? ?? 18 C0 9D E5 8C 60 8D E2 40 00 8C E5 06 10 A0 E1 00 50 A0 E1 ?? ?? ?? ?? F4 01 9D E5 00 00 50 E3 04 30 66 10 03 30 85 10 00 30 80 15 05 00 A0 E1 71 DF 8D E2 F0 8F BD E8 7F 2C A0 E3 FF 20 82 E2 02 00 53 E1 AD 00 00 0A 01 CC 8D E2 F0 38 DC E1 00 00 53 E3 8D 00 00 AA 2C 0A 9F E5 04 10 A0 E1 36 F6 FF EB 00 00 50 E3 A6 FE FF 0A C4 00 00 BA 01 3C 8D E2 B2 88 D3 E1 00 00 58 E3 81 01 00 1A F0 38 D3 E1 00 00 53 E3 3C 50 8D A2 09 00 00 BA 05 30 A0 E1 F4 09 9F E5 04 10 A0 E1 04 20 A0 E1 0A F9 FF EB 01 CC 8D E2 F0 38 DC E1 00 00 53 E3 01 80 48 E2 F5 FF FF AA 47 6F 8D E2 00 30 A0 E3 B3 20 94 E1 B3 20 86 E1 02 30 83 E2 14 00 53 E3 FA FF FF 1A 00 30 A0 E3 B3 C0 99 E1 B3 C0 87 E1 02 30 83 E2 14 00 53 E3 FA FF FF 1A A0 59 9F E5 02 91 A0 E3 C9 99 A0 E1 46 BF 45 E2 14 00 00 EA 0E F6 FF EB 00 00 50 E3 06 10 A0 E1 06 20 A0 E1 3C 30 8D E2 0B 00 A0 E1 06 00 00 BA EB F8 FF EB 0B 00 A0 E1 07 10 A0 E1 07 20 A0 E1 3C 30 8D E2 E6 F8 FF EB 09 80 88 E0 58 E9 9F E5 A9 9F 89 E0 0E 00 55 E1 C9 90 A0 E1 08 00 00 0A 14 50 85 E2 14 B0 8B E2 06 10 A0 E1 2C 09 9F E5 F7 F5 FF EB 00 00 50 E3 06 10 A0 E1 05 00 A0 E1 E3 FF FF CA 07 00 A0 E1 10 19 9F E5 07 20 A0 E1 3C 30 8D E2 51 FA FF EB 61 FE FF EA 8C 30 8D E2 01 20 F3 E5 00 00 52 E3 01 20 43 E5 4E FF FF 0A 01 20 F3 E5 00 00 52 E3 01 20 43 E5 F7 FF FF 1A 49 FF FF EA 12 00 53 E3 36 FF FF 0A B3 20 9A E1 00 00 52 E3 02 30 83 E2 F9 FF FF 0A 27 3C A0 E3 EC 11 9D E5 0F 30 83 E2 00 30 81 E5 46 FF FF EA 1C 30 9D E5 9D FE FF EA 4C 30 9D E5 24 E0 9D E5 03 00 7E E1 4F 00 00 4A EC 11 9D E5 00 30 91 E5 E8 21 9D E5 03 00 82 E2 03 00 80 E0 6D FF FF EA 00 30 A0 E3 01 00 00 EA 12 00 53 E3 13 FE FF 0A B3 20 9A E1 00 00 52 E3 02 30 83 E2 F9 FF FF 0A 8C 00 8D E2 64 18 9F E5 27 8C A0 E3 ?? ?? ?? ?? 0F 80 88 E2 04 FF FF EA E8 E1 9D E5 24 E0 8D E5 24 C0 9D E5 2A 00 5C E3 2A C0 A0 A3 24 C0 8D E5 FA FD FF EA 00 30 A0 E3 B3 10 9A E1 00 00 51 E3 02 30 83 E2 EB FD FF 1A 12 00 53 E3 F9 FF FF 1A E4 FD FF EA E8 31 9D E5 01 30 43 E2 24 30 8D E5 EE FF FF EA 8C 00 8D E2 04 18 9F E5 27 8C A0 E3 ?? ?? ?? ?? 0F 80 88 E2 EB FE FF EA 24 C0 9D E5 0C C0 88 E0 2A 00 5C E3 2A C0 A0 A3 0A 00 53 E3 10 C0 8D E5 72 FE FF 1A 10 E0 9D E5 31 30 A0 E3 8D 30 CD E5 00 00 5E E3 2E 30 A0 E3 8E 30 CD E5 20 00 00 DA 30 30 A0 E3 01 E0 4E E2 90 00 8D E2 8F 30 CD E5 10 E0 8D E5 01 80 88 E2 14 00 8D E5 6F FE FF EA 14 30 9D E5 00 00 53 E3 0F 00 00 0A 8C 00 8D E2 8C 17 9F E5 27 8C A0 E3 ?? ?? ?? ?? 0F 80 88 E2 CC FE FF EA 31 30 A0 E3 01 30 4B E5 01 80 88 E2 C4 FE FF EA 00 30 A0 E3 71 4F 8D E2 38 31 64 E5 EC 01 9D E5 00 30 80 E5 AB FF FF EA 8C 00 8D E2 50 17 9F E5 27 8C A0 E3 ?? ?? ?? ?? 0F 80 88 E2 BC FE FF EA 90 B0 8D 12 01 80 88 E2 01 B0 4B 12 B4 FE FF 1A 90 10 8D E2 01 10 41 E2 14 10 8D E5 4E FE FF EA 00 30 A0 E3 4E 5F 8D E2 B3 E0 94 E1 B3 E0 85 E1 02 30 83 E2 14 00 53 E3 FA FF FF 1A 04 07 9F E5 01 1C 8D E2 01 39 A0 E3 10 00 8D E5 4F 2F A0 E3 E4 00 8D E2 8E 30 83 E2 02 20 82 E2 10 C0 A0 E3 00 80 A0 E3 16 E0 81 E2 16 00 80 E2 BA 34 C1 E1 08 10 8D E5 2C 20 8D E5 1C C0 8D E5 34 E0 8D E5 38 00 8D E5 30 80 8D E5 6A BF 8D E2 47 6F 8D E2 3C 30 8D E2 10 00 9D E5 05 10 A0 E1 07 20 A0 E1 B0 F9 FF EB 00 30 A0 E3 B3 10 97 E1 B3 10 8B E1 02 30 83 E2 14 00 53 E3 FA FF FF 1A 01 2C 8D E2 BA 1B D2 E1 81 C8 A0 E1 AC C8 A0 E1 FF CD 4C E2 3E C0 4C E2 00 00 5C E3 90 C0 6C C2 00 30 A0 C3 42 00 00 DA B3 E0 9B E1 B3 E0 86 E1 02 30 83 E2 14 00 53 E3 FA FF FF 1A 00 00 5C E3 14 00 00 DA 0F 00 5C E3 06 30 A0 D1 09 00 00 DA 10 C0 4C E2 2C 02 A0 E1 02 20 86 E2 80 20 82 E0 06 30 A0 E1 00 E0 A0 E3 B2 E0 C3 E0 02 00 53 E1 FB FF FF 1A 00 C2 4C E0 10 26 9F E5 8C C0 A0 E1 BC 00 92 E1 B0 20 D3 E1 02 20 00 E0 B0 20 C3 E1 02 09 11 E3 12 00 00 1A 00 30 A0 E3 01 00 00 EA 12 00 53 E3 17 00 00 0A B3 10 97 E1 B3 20 96 E1 02 00 51 E1 02 30 83 E2 F8 FF FF 0A 1C C0 9D E5 10 20 9D E5 A4 35 9F E5 AC C0 A0 E1 03 00 52 E1 1C C0 8D E5 1D 00 00 0A 14 20 82 E2 10 20 8D E5 BB FF FF EA 00 30 A0 E3 B3 10 9B E1 B3 20 96 E1 02 00 51 E1 02 30 83 E2 AF 00 00 1A 12 00 53 E3 F8 FF FF 1A E3 FF FF EA 00 30 A0 E3 B3 E0 97 E1 B3 E0 85 E1 02 30 83 E2 14 00 53 E3 FA FF FF 1A 30 00 9D E5 1C 10 9D E5 01 00 80 E0 30 00 8D E5 E1 FF FF EA 00 30 A0 E3 00 C0 A0 E3 B3 C0 86 E1 02 30 83 E2 14 00 53 E3 FA FF FF 1A CF FF FF EA 01 EC 8D E2 BA 24 DE E1 B2 38 DE E1 03 30 82 E0 01 39 43 E2 8E 30 43 E2 30 80 9D E5 BA 34 CE E1 00 30 A0 E3 B3 00 95 E1 B3 00 84 E1 02 30 83 E2 14 00 53 E3 FA FF FF 1A 00 30 A0 E3 B3 10 99 E1 B3 10 87 E1 02 30 83 E2 14 00 53 E3 FA FF FF 1A EC 94 9F E5 01 BA A0 E3 04 00 00 EA BC 24 9F E5 02 00 59 E1 AB B0 A0 E1 4C FD FF 0A 14 90 89 E2 05 10 A0 E1 A4 04 9F E5 D4 F4 FF EB 00 00 50 E3 05 10 A0 E1 09 00 A0 E1 44 FD FF CA CF F4 FF EB 00 00 50 E3 F0 FF FF CA 09 00 A0 E1 05 10 A0 E1 05 20 A0 E1 3C 30 8D E2 2B F9 FF EB 09 00 A0 E1 07 10 A0 E1 07 20 A0 E1 3C 30 8D E2 A7 F7 FF EB 0B 80 88 E0 E4 FF FF EA 04 00 A0 E1 07 10 A0 E1 3C 20 8D E2 6A F7 FF EB 07 00 A0 E1 30 14 9F E5 BA F4 FF EB 00 00 50 E3 D7 FD FF 1A 10 30 9D E5 00 00 53 E3 F7 FD FF BA 01 30 5B E5 2E 00 53 E3 02 10 5B 05 03 10 A0 11 01 00 11 E3 01 20 4B E2 F0 FD FF 0A D1 FD FF EA 47 6F 8D E2 04 00 A0 E1 06 10 A0 E1 36 F3 FF EB 4E 5F 8D E2 4F BF A0 E3 16 E0 86 E2 02 B0 8B E2 16 30 85 E2 10 E0 8D E5 1C B0 8D E5 00 80 A0 E3 03 B0 A0 E1 01 0C 8D E2 B4 33 D0 E1 07 30 13 E2 3E 00 00 1A B3 10 96 E1 B3 10 85 E1 02 30 83 E2 18 00 53 E3 FA FF FF 1A 00 20 A0 E3 01 3C 8D E2 B0 25 C3 E1 05 00 A0 E1 59 F3 FF EB 05 00 A0 E1 57 F3 FF EB 10 20 9D E5 0B 30 A0 E1 00 10 A0 E3 B2 C0 D3 E1 B2 00 D2 E1 00 00 8C E0 01 00 80 E0 02 20 42 E2 20 18 A0 E1 06 00 52 E1 B2 00 C3 E1 01 10 01 E2 02 30 43 E2 F4 FF FF 1A 01 CC 8D E2 BA 33 DC E1 BC 23 DC E1 03 30 83 E2 00 00 52 E3 BA 33 CC E1 08 00 00 0A 05 00 A0 E1 40 F3 FF EB 01 EC 8D E2 BA 33 DE E1 BC 23 DE E1 01 30 83 E2 00 00 52 E3 BA 33 CE E1 F6 FF FF 1A 01 0C 8D E2 B0 35 D0 E1 00 00 53 E3 10 00 00 1A 1C 20 9D E5 F0 C2 9F E5 B2 10 9C E1 BA 23 D0 E1 02 00 51 E1 0A 00 00 9A B3 E0 95 E1 B3 E0 86 E1 02 30 83 E2 18 00 53 E3 FA FF FF 1A 01 80 48 E2 00 00 A0 E3 01 1C 8D E2 2B 00 78 E3 B4 03 C1 E1 BC FF FF 1A 06 00 A0 E1 04 10 A0 E1 3C 20 8D E2 06 F7 FF EB 37 FE FF EA 2C 30 9D E5 98 C2 9F E5 B3 20 9C E1 7F 3C A0 E3 82 28 A0 E1 FF 30 83 E2 A2 28 A0 E1 03 00 52 E1 49 00 00 0A 01 EC 8D E2 BE 22 DE E1 7F 3C A0 E3 82 28 A0 E1 FF 30 83 E2 A2 28 A0 E1 03 00 52 E1 34 00 00 0A 64 02 9F E5 C0 F2 FF EB 00 00 50 E3 18 00 00 0A 06 00 A0 E1 BC F2 FF EB 00 00 50 E3 14 00 00 0A 38 32 9F E5 2C 10 9D E5 B1 20 93 E1 7F 3C A0 E3 82 18 A0 E1 FF 30 83 E2 A1 18 A0 E1 03 00 51 E1 9C 00 00 0A A2 27 A0 E1 01 CC 8D E2 BE 12 DC E1 7F 3C A0 E3 81 08 A0 E1 FF 30 83 E2 A0 08 A0 E1 03 00 50 E1 8B 00 00 0A A1 17 A0 E1 01 00 52 E1 76 00 00 0A F0 01 9F E5 A3 F2 FF EB 00 80 50 E2 2F 00 00 0A 00 30 A0 E3 B3 E0 99 E1 B3 E0 86 E1 02 30 83 E2 14 00 53 E3 FA FF FF 1A 01 0C 8D E2 BE 22 D0 E1 7F 3C A0 E3 82 18 A0 E1 FF 30 83 E2 A1 18 A0 E1 03 00 51 E1 29 00 00 0A 02 31 A0 E3 43 38 A0 E1 03 30 22 E0 01 1C 8D E2 BE 32 C1 E1 F0 FE FF EA 00 30 A0 E3 01 00 00 EA 12 00 53 E3 C6 FF FF 0A B3 20 96 E1 00 00 52 E3 02 30 83 E2 F9 FF FF 0A 00 30 A0 E3 02 30 83 E2 14 00 53 E3 FC FF FF 1A E3 FE FF EA 00 30 A0 E3 01 00 00 EA 12 00 53 E3 B1 FF FF 0A B3 20 99 E1 00 00 52 E3 02 30 83 E2 F9 FF FF 0A 00 30 A0 E3 B3 00 99 E1 B3 00 86 E1 02 30 83 E2 14 00 53 E3 FA FF FF 1A D4 FE FF EA 06 00 A0 E1 6F F2 FF EB 00 30 50 E2 0B 00 00 0A 02 80 88 E2 14 00 58 E3 }
	condition:
		$1
}

rule file_40_0_0 {
	meta:
		name = "__sprint_r"
		size = 48
		refs = "001c __sfvwrite_r"
	strings:
		$1 = { 08 30 92 E5 00 00 53 E3 10 40 2D E9 04 30 82 05 02 40 A0 E1 03 00 A0 01 10 80 BD 08 ?? ?? ?? ?? 00 30 A0 E3 04 30 84 E5 08 30 84 E5 10 80 BD E8 }
	condition:
		$1
}

rule file_40_1_0 {
	meta:
		name = "_vfiprintf_r"
		size = 4248
		refs = "0464 memchr 0dd4 _vfiprintf_r 0dec _fflush_r 0e1c __sinit 0fe0 strlen 1068 __swsetup_r"
	strings:
		$1 = { F0 4F 2D E9 51 DE 4D E2 00 60 50 E2 08 D0 4D E2 18 60 8D E5 01 90 A0 E1 02 60 A0 E1 03 80 A0 E1 02 00 00 0A 38 30 90 E5 00 00 53 E3 7A 03 00 0A BC C0 D9 E1 02 0A 1C E3 0C 30 A0 E1 05 00 00 1A 64 30 99 E5 02 CA 8C E3 02 3A C3 E3 BC C0 C9 E1 64 30 89 E5 0C 30 A0 E1 08 00 13 E3 FF 03 00 0A 10 20 99 E5 00 00 52 E3 FC 03 00 0A 1A 30 03 E2 0A 00 53 E3 3C 03 00 0A 4E 2E 8D E2 00 30 A0 E3 4A BE 8D E2 28 20 82 E2 2C 30 8D E5 08 B5 8D E5 10 35 8D E5 0C 35 8D E5 80 AF 9F E5 14 30 8D E5 30 20 8D E5 0B 40 A0 E1 00 30 D6 E5 00 00 53 E3 25 00 53 13 16 00 00 0A 06 50 A0 E1 01 30 F5 E5 25 00 53 E3 00 00 53 13 FB FF FF 1A 06 70 55 E0 05 60 A0 01 0E 00 00 0A 0C 35 9D E5 10 25 9D E5 01 30 83 E2 07 00 53 E3 07 20 82 E0 C0 00 84 E8 10 25 8D E5 0C 35 8D E5 08 40 84 D2 F2 02 00 CA 14 C0 9D E5 07 C0 8C E0 00 30 D5 E5 14 C0 8D E5 05 60 A0 E1 00 00 53 E3 87 02 00 0A 00 00 A0 E3 00 10 A0 E3 0C 00 8D E5 17 15 CD E5 01 01 8D E8 01 30 86 E2 00 50 E0 E3 2B C0 A0 E3 20 70 A0 E3 03 60 A0 E1 01 20 D6 E4 20 30 42 E2 58 00 53 E3 03 F1 9F 97 A7 01 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 30 9D E5 10 30 83 E3 00 30 8D E5 00 C0 9D E5 10 00 1C E3 00 03 00 0A 04 00 9D E5 00 30 90 E5 04 80 80 E2 00 10 53 E2 01 10 A0 13 01 20 A0 E3 00 C0 A0 E3 17 C5 CD E5 00 00 55 E3 00 00 9D A5 80 00 C0 A3 00 00 8D A5 00 00 55 E3 01 10 81 13 00 00 51 E3 F1 01 00 0A 01 00 52 E3 CF 02 00 0A 02 00 52 E3 BF 02 00 0A 30 10 9D E5 20 10 8D E5 07 20 03 E2 30 20 82 E2 A3 31 B0 E1 01 20 61 E5 FA FF FF 1A 00 30 9D E5 01 00 13 E3 20 10 8D E5 FC 02 00 0A 30 00 52 E3 38 03 00 0A 20 20 9D E5 30 30 A0 E3 01 30 62 E5 30 30 9D E5 03 30 62 E0 20 20 8D E5 10 30 8D E5 E4 01 00 EA 00 30 9D E5 10 30 83 E3 00 30 8D E5 00 C0 9D E5 10 20 1C E2 C8 02 00 0A 04 00 9D E5 00 30 90 E5 04 80 80 E2 00 10 53 E2 01 10 A0 13 00 20 A0 E3 CF FF FF EA 00 30 9D E5 10 30 83 E3 00 30 8D E5 00 C0 9D E5 10 00 1C E3 CE 02 00 0A 04 00 9D E5 00 30 90 E5 00 00 53 E3 04 80 80 E2 D3 02 00 BA 00 10 A0 03 01 10 A0 13 01 20 A0 E3 C2 FF FF EA 04 10 9D E5 30 20 A0 E3 00 30 91 E5 14 25 CD E5 78 20 A0 E3 15 25 CD E5 04 10 9D E8 18 0C 9F E5 02 20 82 E3 00 20 8D E5 00 10 53 E2 01 10 A0 13 04 80 8C E2 2C 00 8D E5 02 20 A0 E3 B0 FF FF EA 00 10 A0 E3 04 30 9D E5 17 15 CD E5 04 20 9D E5 00 30 93 E5 04 20 82 E2 00 00 53 E3 20 30 8D E5 04 20 8D E5 E6 02 00 0A 00 00 55 E3 DE 02 00 BA 20 00 9D E5 00 10 A0 E3 05 20 A0 E1 ?? ?? ?? ?? 00 00 50 E3 D4 02 00 0A 20 10 9D E5 00 00 61 E0 05 00 50 E1 10 00 8D E5 CF 02 00 CA 00 C0 A0 E3 1C C0 8D E5 A0 01 00 EA 00 20 9D E5 10 20 82 E3 00 20 8D E5 04 20 9D E5 06 30 A0 E1 04 20 8D E5 24 FF FF EA 04 C0 9D E5 00 30 9C E5 01 00 A0 E3 00 10 A0 E3 04 C0 8C E2 4E 2E 8D E2 08 00 8D E5 E0 34 CD E5 17 15 CD E5 04 C0 8D E5 10 00 8D E5 20 20 8D E5 00 10 A0 E3 1C 10 8D E5 00 30 9D E5 02 30 13 E2 08 C0 9D 15 00 00 9D E5 02 C0 8C 12 08 C0 8D 15 84 00 10 E2 28 30 8D E5 24 00 8D E5 C8 00 00 1A 0C 10 9D E5 08 20 9D E5 01 50 62 E0 00 00 55 E3 C3 00 00 DA 10 00 55 E3 B8 02 00 DA F0 0A 9F E5 05 8C 8D E2 04 10 A0 E1 10 25 9D E5 0C 35 9D E5 34 00 8D E5 10 70 A0 E3 08 80 88 E2 18 40 9D E5 02 00 00 EA 10 50 45 E2 10 00 55 E3 14 00 00 DA 01 30 83 E2 10 20 82 E2 07 00 53 E3 00 A0 81 E5 04 70 81 E5 10 25 8D E5 0C 35 8D E5 08 10 81 D2 F3 FF FF DA 04 00 A0 E1 09 10 A0 E1 08 20 A0 E1 8F FE FF EB 00 00 50 E3 70 01 00 1A 10 50 45 E2 10 00 55 E3 10 25 9D E5 0C 35 9D E5 0B 10 A0 E1 EA FF FF CA 01 40 A0 E1 01 30 83 E2 34 10 9D E5 05 20 82 E0 07 00 53 E3 22 00 84 E8 10 25 8D E5 0C 35 8D E5 08 40 84 D2 97 00 00 DA 05 2C 8D E2 18 00 9D E5 09 10 A0 E1 08 20 82 E2 78 FE FF EB 00 00 50 E3 59 01 00 1A 10 25 9D E5 0C 35 9D E5 0B 40 A0 E1 8C 00 00 EA 1C 3A 9F E5 2C 30 8D E5 00 10 9D E5 10 00 11 E3 02 00 00 1A 00 00 9D E5 40 00 10 E3 51 02 00 1A 04 C0 9D E5 00 30 9C E5 04 80 8C E2 00 00 9D E5 00 10 53 E2 01 10 A0 13 01 00 10 E1 30 10 A0 13 14 15 CD 15 00 10 9D 15 02 10 81 13 15 25 CD 15 00 10 8D 15 02 20 A0 E3 01 10 A0 13 21 FF FF EA 00 00 9D E5 10 00 10 E3 38 02 00 1A 00 30 9D E5 40 00 13 E3 35 02 00 0A 04 C0 9D E5 14 00 9D E5 00 30 9C E5 04 80 8C E2 B0 00 C3 E1 84 FE FF EA 05 00 9D E8 40 00 80 E3 00 00 8D E5 06 30 A0 E1 04 20 8D E5 A4 FE FF EA 06 00 9D E8 10 10 81 E3 00 10 8D E5 06 30 A0 E1 04 20 8D E5 9E FE FF EA 30 10 42 E2 00 00 A0 E3 06 30 A0 E1 01 20 D3 E4 00 01 80 E0 80 00 81 E0 30 10 42 E2 09 00 51 E3 F9 FF FF 9A 0C 00 8D E5 03 60 A0 E1 94 FE FF EA 00 30 9D E5 04 20 9D E5 80 30 83 E3 00 30 8D E5 04 20 8D E5 06 30 A0 E1 8B FE FF EA 06 30 A0 E1 01 20 D3 E4 2A 00 52 E3 57 02 00 0A 30 10 42 E2 09 00 51 E3 00 50 A0 83 EE FF FF 8A 02 60 86 E2 00 50 A0 E3 01 20 56 E5 05 51 85 E0 85 50 81 E0 30 10 42 E2 09 00 51 E3 06 30 A0 E1 01 60 86 E2 F7 FF FF 9A C5 5F 85 E1 03 60 A0 E1 78 FE FF EA 04 20 9D E5 00 10 9D E5 04 10 81 E3 00 10 8D E5 06 30 A0 E1 04 20 8D E5 6F FE FF EA 04 20 9D E5 17 C5 CD E5 06 30 A0 E1 04 20 8D E5 6A FE FF EA 04 10 9D E5 00 10 91 E5 04 30 9D E5 00 00 51 E3 0C 10 8D E5 04 20 83 E2 F0 FF FF AA 0C 00 9D E5 00 00 60 E2 0C 00 8D E5 E9 FF FF EA 05 00 9D E8 01 00 80 E3 00 00 8D E5 06 30 A0 E1 04 20 8D E5 59 FE FF EA 17 35 DD E5 00 00 53 E3 F3 01 00 1A 04 20 9D E5 17 75 CD E5 06 30 A0 E1 04 20 8D E5 51 FE FF EA 00 00 52 E3 CE 00 00 0A 01 10 A0 E3 E0 24 CD E5 4E 3E 8D E2 00 20 A0 E3 08 10 8D E5 17 25 CD E5 10 10 8D E5 20 30 8D E5 2D FF FF EA F8 07 9F E5 2C 00 8D E5 76 FF FF EA 10 25 9D E5 0C 35 9D E5 17 15 DD E5 00 00 51 E3 0B 00 00 0A 51 1E 8D E2 01 30 83 E2 07 10 81 E2 00 10 84 E5 01 20 82 E2 07 00 53 E3 01 10 A0 E3 04 10 84 E5 10 25 8D E5 0C 35 8D E5 08 40 84 D2 32 01 00 CA 28 C0 9D E5 00 00 5C E3 0B 00 00 0A 51 1E 8D E2 01 30 83 E2 04 10 81 E2 00 10 84 E5 02 20 82 E2 07 00 53 E3 02 10 A0 E3 04 10 84 E5 10 25 8D E5 0C 35 8D E5 08 40 84 D2 18 01 00 CA 24 00 9D E5 80 00 50 E3 B5 00 00 0A 1C 00 9D E5 10 10 9D E5 00 50 61 E0 00 00 55 E3 34 00 00 DA 10 00 55 E3 50 77 9F D5 1E 00 00 DA 04 10 A0 E1 44 77 9F E5 10 80 A0 E3 18 40 9D E5 03 00 00 EA 10 50 45 E2 10 00 55 E3 15 00 00 DA 10 25 9D E5 01 30 83 E2 10 20 82 E2 07 00 53 E3 80 01 81 E8 10 25 8D E5 0C 35 8D E5 08 10 81 D2 F3 FF FF DA 05 2C 8D E2 04 00 A0 E1 09 10 A0 E1 08 20 82 E2 A6 FD FF EB 00 00 50 E3 87 00 00 1A 10 50 45 E2 10 00 55 E3 10 25 9D E5 0C 35 9D E5 0B 10 A0 E1 E9 FF FF CA 01 40 A0 E1 01 30 83 E2 05 20 82 E0 07 00 53 E3 00 70 84 E5 04 50 84 E5 10 25 8D E5 0C 35 8D E5 08 40 84 D2 09 00 00 DA 05 2C 8D E2 18 00 9D E5 09 10 A0 E1 08 20 82 E2 8F FD FF EB 00 00 50 E3 70 00 00 1A 10 25 9D E5 0C 35 9D E5 0B 40 A0 E1 10 C0 9D E5 01 30 83 E2 20 00 9D E5 0C 20 82 E0 07 00 53 E3 01 10 84 E8 10 25 8D E5 0C 35 8D E5 08 40 84 D2 AD 00 00 CA 00 10 9D E5 04 00 11 E3 32 00 00 0A 0C 30 9D E5 08 C0 9D E5 03 50 6C E0 00 00 55 E3 C7 00 00 DA 10 00 55 E3 96 01 00 DA 24 16 9F E5 05 8C 8D E2 34 10 8D E5 0C 35 9D E5 04 10 A0 E1 10 70 A0 E3 08 80 88 E2 18 40 9D E5 03 00 00 EA 10 50 45 E2 10 00 55 E3 15 00 00 DA 10 25 9D E5 01 30 83 E2 10 20 82 E2 07 00 53 E3 00 A0 81 E5 04 70 81 E5 10 25 8D E5 0C 35 8D E5 08 10 81 D2 F2 FF FF DA 04 00 A0 E1 09 10 A0 E1 08 20 A0 E1 5C FD FF EB 00 00 50 E3 3D 00 00 1A 10 50 45 E2 10 00 55 E3 10 25 9D E5 0C 35 9D E5 0B 10 A0 E1 E9 FF FF CA 01 40 A0 E1 01 30 83 E2 34 C0 9D E5 05 20 82 E0 07 00 53 E3 00 C0 84 E5 04 50 84 E5 10 25 8D E5 0C 35 8D E5 92 00 00 CA 14 00 9D E5 08 10 8D E2 0A 00 91 E8 03 00 51 E1 01 00 80 A0 03 00 80 B0 00 00 52 E3 14 00 8D E5 78 00 00 1A 00 C0 A0 E3 0C C5 8D E5 04 80 9D E5 0B 40 A0 E1 72 FD FF EA 00 00 52 E3 26 00 00 1A 00 10 9D E5 01 00 11 E3 23 00 00 0A 30 30 A0 E3 4E 2E 8D E2 07 35 CD E5 27 20 82 E2 01 30 A0 E3 20 20 8D E5 10 30 8D E5 1C 50 8D E5 04 80 8D E5 17 35 DD E5 10 10 9D E5 1C 20 9D E5 02 00 51 E1 02 10 A0 B1 00 00 53 E3 08 10 8D E5 01 10 81 12 08 10 8D 15 69 FE FF EA 10 35 9D E5 00 00 53 E3 04 00 00 0A 05 2C 8D E2 18 00 9D E5 09 10 A0 E1 08 20 82 E2 1C FD FF EB BC 30 D9 E1 40 00 13 E3 01 00 00 0A 00 00 E0 E3 14 00 8D E5 14 00 9D E5 46 DF 8D E2 01 DB 8D E2 F0 8F BD E8 30 C0 9D E5 00 00 A0 E3 20 C0 8D E5 10 00 8D E5 DD FF FF EA 0C 10 9D E5 08 C0 9D E5 01 50 6C E0 00 00 55 E3 10 25 9D D5 43 FF FF DA 10 00 55 E3 74 74 9F D5 1E 00 00 DA 04 10 A0 E1 68 74 9F E5 10 80 A0 E3 18 40 9D E5 03 00 00 EA 10 50 45 E2 10 00 55 E3 15 00 00 DA 10 25 9D E5 01 30 83 E2 10 20 82 E2 07 00 53 E3 80 01 81 E8 10 25 8D E5 0C 35 8D E5 08 10 81 D2 F3 FF FF DA 05 2C 8D E2 04 00 A0 E1 09 10 A0 E1 08 20 82 E2 EF FC FF EB 00 00 50 E3 D0 FF FF 1A 10 50 45 E2 10 00 55 E3 10 25 9D E5 0C 35 9D E5 0B 10 A0 E1 E9 FF FF CA 01 40 A0 E1 01 30 83 E2 05 20 82 E0 07 00 53 E3 00 70 84 E5 04 50 84 E5 10 25 8D E5 0C 35 8D E5 08 40 84 D2 18 FF FF DA 05 2C 8D E2 18 00 9D E5 09 10 A0 E1 08 20 82 E2 D8 FC FF EB 00 00 50 E3 B9 FF FF 1A 10 25 9D E5 0C 35 9D E5 0B 40 A0 E1 0D FF FF EA 05 2C 8D E2 18 00 9D E5 09 10 A0 E1 08 20 82 E2 CD FC FF EB 00 00 50 E3 AE FF FF 1A 10 25 9D E5 0B 40 A0 E1 47 FF FF EA 05 2C 8D E2 18 00 9D E5 09 10 A0 E1 08 20 82 E2 C3 FC FF EB 00 00 50 E3 7F FF FF 0A A3 FF FF EA 05 2C 8D E2 18 00 9D E5 09 10 A0 E1 08 20 82 E2 BB FC FF EB 00 00 50 E3 9C FF FF 1A 0B 40 A0 E1 03 FD FF EA 05 2C 8D E2 18 00 9D E5 09 10 A0 E1 08 20 82 E2 B2 FC FF EB 00 00 50 E3 93 FF FF 1A 10 25 9D E5 63 FF FF EA 05 2C 8D E2 18 00 9D E5 09 10 A0 E1 08 20 82 E2 A9 FC FF EB 00 00 50 E3 8A FF FF 1A 10 25 9D E5 0C 35 9D E5 0B 40 A0 E1 DB FE FF EA 05 2C 8D E2 18 00 9D E5 09 10 A0 E1 08 20 82 E2 9E FC FF EB 00 00 50 E3 7F FF FF 1A 10 25 9D E5 0C 35 9D E5 0B 40 A0 E1 C1 FE FF EA FE 30 D9 E1 00 00 53 E3 BF FC FF BA 01 EB A0 E3 02 C0 CC E3 06 20 A0 E1 0E 60 8D E0 B4 C4 C6 E1 00 C0 A0 E3 50 C4 8D E5 43 4E 8D E2 BE C0 D9 E1 1C 70 99 E5 24 A0 99 E5 08 40 84 E2 38 50 8D E2 08 30 A0 E1 18 00 9D E5 04 10 A0 E1 B6 C4 C6 E1 54 74 8D E5 5C A4 8D E5 48 54 8D E5 4C E4 8D E5 38 54 8D E5 40 E4 8D E5 ?? ?? ?? ?? 00 00 50 E3 14 00 8D E5 06 00 00 BA 18 00 9D E5 04 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 14 00 9D E5 00 00 E0 13 14 00 8D E5 01 1B 8D E2 B4 34 D1 E1 40 00 13 E3 BC 30 D9 11 40 30 83 13 BC 30 C9 11 54 FF FF EA ?? ?? ?? ?? 82 FC FF EA 2C 00 8D E2 01 10 90 E8 20 C0 8D E5 0C 20 A0 E1 0F 10 03 E2 01 10 D0 E7 23 32 B0 E1 01 10 62 E5 FA FF FF 1A 30 00 9D E5 00 00 62 E0 20 20 8D E5 10 00 8D E5 2B FF FF EA 09 00 53 E3 30 10 9D 95 0A 00 00 9A 30 10 9D E5 BC C1 9F E5 9C 03 82 E0 A2 21 A0 E1 02 01 82 E0 80 00 43 E0 30 00 80 E2 09 00 52 E3 02 30 A0 E1 01 00 61 E5 F5 FF FF 8A 30 30 83 E2 01 20 41 E2 20 20 8D E5 01 30 41 E5 30 30 9D E5 03 30 62 E0 10 30 8D E5 15 FF FF EA 00 30 9D E5 40 10 13 E2 35 00 00 0A 04 C0 9D E5 B0 30 DC E1 04 80 8C E2 00 10 53 E2 01 10 A0 13 04 FD FF EA 00 10 9D E5 40 00 11 E3 25 00 00 0A 04 20 9D E5 B0 30 D2 E1 04 80 82 E2 00 10 53 E2 01 10 A0 13 01 20 A0 E3 FA FC FF EA 00 10 9D E5 40 00 11 E3 04 20 9D 15 04 C0 9D 05 F0 30 D2 11 00 30 9C 05 04 80 82 12 04 80 8C 02 00 00 53 E3 2B FD FF AA 2D 20 A0 E3 00 30 63 E2 17 25 CD E5 00 10 53 E2 01 10 A0 13 01 20 A0 E3 EB FC FF EA 30 C0 9D E5 0C C0 61 E0 10 C0 8D E5 ED FE FF EA 04 10 9D E5 14 20 9D E5 00 30 91 E5 04 80 81 E2 00 20 83 E5 4E FC FF EA 04 10 9D E5 B0 30 D1 E1 04 80 81 E2 AC FD FF EA 04 C0 9D E5 00 30 9C E5 04 80 8C E2 00 10 53 E2 01 10 A0 13 01 20 A0 E3 D4 FC FF EA 04 00 9D E5 00 30 90 E5 01 20 A0 E1 04 80 80 E2 00 10 53 E2 01 10 A0 13 CD FC FF EA 04 20 9D E5 06 30 A0 E1 04 20 8D E5 5E FC FF EA 00 00 A0 E3 10 50 8D E5 1C 00 8D E5 CF FE FF EA 00 20 A0 E3 20 00 9D E5 1C 20 8D E5 ?? ?? ?? ?? 10 00 8D E5 C9 FE FF EA 06 00 55 E3 06 50 A0 23 38 C0 9F E5 C5 3F C5 E1 10 50 8D E5 }
	condition:
		$1
}

rule file_41_0_0 {
	meta:
		name = "cnv"
		size = 32
		refs = "000c strtol"
	strings:
		$1 = { 04 E0 2D E5 00 10 A0 E3 0A 20 A0 E3 ?? ?? ?? ?? 01 00 70 E3 FF 00 A0 03 FF 00 00 12 04 F0 9D E4 }
	condition:
		$1
}

rule file_41_1_0 {
	meta:
		name = "__get_current_monetary_locale"
		size = 36
		altNames = "__get_current_messages_locale __get_current_numeric_locale __get_current_time_locale"
	strings:
		$1 = { 14 30 9F E5 04 00 93 E4 10 20 9F E5 00 00 50 E3 03 00 A0 11 02 00 A0 01 1E FF 2F E1 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_41_2_0 {
	meta:
		name = "__monetary_load_locale"
		size = 244
		refs = "0034 __part_load_locale 005c __fix_locale_grouping_str 00ec __mlocale_changed"
	strings:
		$1 = { 70 40 2D E9 DC 40 9F E5 DC 50 9F E5 01 60 A0 E3 00 60 85 E5 0C D0 4D E2 0F C0 A0 E3 04 E0 84 E2 40 20 94 E5 04 10 A0 E1 C0 30 9F E5 00 50 8D E9 00 C0 8D E5 ?? ?? ?? ?? 00 50 50 E2 02 00 00 1A 00 30 94 E5 00 00 53 E3 02 00 00 1A 05 00 A0 E1 0C D0 8D E2 70 80 BD E8 14 00 94 E5 ?? ?? ?? ?? 20 60 94 E5 14 00 84 E5 06 00 A0 E1 DB FF FF EB 00 00 C6 E5 24 60 94 E5 06 00 A0 E1 D7 FF FF EB 00 00 C6 E5 28 60 94 E5 06 00 A0 E1 D3 FF FF EB 00 00 C6 E5 2C 60 94 E5 06 00 A0 E1 CF FF FF EB 00 00 C6 E5 30 60 94 E5 06 00 A0 E1 CB FF FF EB 00 00 C6 E5 34 60 94 E5 06 00 A0 E1 C7 FF FF EB 00 00 C6 E5 38 60 94 E5 06 00 A0 E1 C3 FF FF EB 00 00 C6 E5 3C 40 94 E5 04 00 A0 E1 BF FF FF EB 00 00 C4 E5 D8 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_42_0_0 {
	meta:
		name = "_vasiprintf_r"
		size = 84
		refs = "0034 _svfiprintf_r"
	strings:
		$1 = { 30 40 2D E9 A2 CF A0 E3 68 D0 4D E2 00 40 A0 E3 01 50 A0 E1 BC C0 CD E1 0D 10 A0 E1 00 C0 E0 E3 00 40 8D E5 10 40 8D E5 08 40 8D E5 14 40 8D E5 BE C0 CD E1 ?? ?? ?? ?? 00 00 50 E3 00 30 9D A5 00 40 C3 A5 10 30 9D A5 00 30 85 A5 68 D0 8D E2 30 80 BD E8 }
	condition:
		$1
}

rule file_123_0_0 {
	meta:
		name = "_vasprintf_r"
		size = 84
		refs = "0034 _svfprintf_r"
	strings:
		$1 = { 30 40 2D E9 A2 CF A0 E3 68 D0 4D E2 00 40 A0 E3 01 50 A0 E1 BC C0 CD E1 0D 10 A0 E1 00 C0 E0 E3 00 40 8D E5 10 40 8D E5 08 40 8D E5 14 40 8D E5 BE C0 CD E1 ?? ?? ?? ?? 00 00 50 E3 00 30 9D A5 00 40 C3 A5 10 30 9D A5 00 30 85 A5 68 D0 8D E2 30 80 BD E8 }
	condition:
		$1
}

rule file_43_2_0 {
	meta:
		name = "std"
		size = 120
		refs = "003c memset 0068 __sclose 006c __sread 0070 __swrite 0074 __sseek"
	strings:
		$1 = { 00 30 A0 E3 BC 10 C0 E1 BE 20 C0 E1 00 30 80 E5 04 30 80 E5 08 30 80 E5 64 30 80 E5 10 30 80 E5 14 30 80 E5 18 30 80 E5 10 40 2D E9 03 10 A0 E1 00 40 A0 E1 08 20 A0 E3 5C 00 80 E2 ?? ?? ?? ?? 20 30 9F E5 2C 30 84 E5 1C 30 9F E5 20 30 84 E5 18 30 9F E5 24 30 84 E5 14 30 9F E5 1C 40 84 E5 28 30 84 E5 10 80 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_43_7_0 {
	meta:
		name = "__fp_unlock_all"
		size = 24
		refs = "000c _fwalk 0010 _impure_ptr 0014 __fp_unlock"
	strings:
		$1 = { 08 30 9F E5 08 10 9F E5 00 00 93 E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_43_8_0 {
	meta:
		name = "__fp_lock_all"
		size = 24
		refs = "000c _fwalk 0010 _impure_ptr 0014 __fp_lock"
	strings:
		$1 = { 08 30 9F E5 08 10 9F E5 00 00 93 E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_43_11_0 {
	meta:
		name = "__sinit"
		size = 124
		refs = "0078 _cleanup_r"
	strings:
		$1 = { 38 30 90 E5 00 00 53 E3 30 40 2D E9 00 40 A0 E1 30 80 BD 18 5C 10 9F E5 01 50 A0 E3 BB 2F 80 E2 3C 10 80 E5 03 10 A0 E3 E4 12 80 E5 E8 22 80 E5 38 50 80 E5 03 20 A0 E1 E0 32 80 E5 04 10 A0 E3 04 30 A0 E1 04 00 90 E5 CE FF FF EB 05 20 A0 E1 08 00 94 E5 04 30 A0 E1 09 10 A0 E3 C9 FF FF EB 0C 00 94 E5 04 30 A0 E1 12 10 A0 E3 02 20 A0 E3 30 40 BD E8 C3 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_43_12_0 {
	meta:
		name = "__sfmoreglue"
		size = 68
		refs = "0018 _malloc_r 0038 memset"
	strings:
		$1 = { 70 40 2D E9 81 60 81 E0 06 61 81 E0 86 61 A0 E1 01 50 A0 E1 0C 10 86 E2 ?? ?? ?? ?? 00 40 50 E2 05 00 00 0A 0C 00 84 E2 00 10 A0 E3 22 00 84 E8 08 00 84 E5 06 20 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 70 80 BD E8 }
	condition:
		$1
}

rule file_43_13_0 {
	meta:
		name = "__sfp"
		size = 240
		refs = "0088 memset 00bc __sinit 00cc __sfmoreglue 00ec _global_impure_ptr"
	strings:
		$1 = { E4 30 9F E5 70 40 2D E9 00 50 93 E5 38 30 95 E5 00 00 53 E3 00 60 A0 E1 26 00 00 0A 2E 5E 85 E2 04 30 95 E5 01 30 53 E2 08 40 95 E5 03 00 00 5A 1B 00 00 EA 01 30 53 E2 68 40 84 E2 18 00 00 4A FC 20 D4 E1 00 00 52 E3 F9 FF FF 1A 00 30 E0 E3 00 50 A0 E3 BE 30 C4 E1 01 30 A0 E3 BC 30 C4 E1 64 50 84 E5 00 50 84 E5 08 50 84 E5 04 50 84 E5 10 50 84 E5 14 50 84 E5 18 50 84 E5 5C 00 84 E2 05 10 A0 E1 08 20 A0 E3 ?? ?? ?? ?? 48 50 84 E5 30 50 84 E5 34 50 84 E5 44 50 84 E5 04 00 A0 E1 70 80 BD E8 00 00 95 E5 00 00 50 E3 04 00 00 0A 00 50 A0 E1 D9 FF FF EA 05 00 A0 E1 ?? ?? ?? ?? D5 FF FF EA 06 00 A0 E1 04 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 00 00 85 E5 F4 FF FF 1A 0C 30 A0 E3 00 30 86 E5 00 40 A0 E1 EB FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_45_0_0 {
	meta:
		name = "memmove"
		size = 300
	strings:
		$1 = { 01 00 50 E1 70 00 2D E9 02 C0 A0 E1 00 50 A0 E1 01 40 A0 E1 0D 00 00 9A 02 30 81 E0 03 00 50 E1 0A 00 00 2A 00 00 52 E3 06 00 00 0A 03 C0 62 E0 00 10 A0 E1 01 30 42 E2 03 20 DC E7 03 20 C1 E7 01 30 53 E2 FB FF FF 2A 70 00 BD E8 1E FF 2F E1 0F 00 52 E3 08 00 00 8A 00 00 5C E3 F9 FF FF 0A 00 30 A0 E3 03 20 D4 E7 03 20 C5 E7 01 30 83 E2 0C 00 53 E1 FA FF FF 1A F2 FF FF EA 00 30 81 E1 03 00 13 E3 F3 FF FF 1A 02 40 A0 E1 01 30 A0 E1 00 C0 A0 E1 00 50 93 E5 00 50 8C E5 04 50 93 E5 04 50 8C E5 08 50 93 E5 08 50 8C E5 10 40 44 E2 0C 50 93 E5 0F 00 54 E3 0C 50 8C E5 10 30 83 E2 10 C0 8C E2 F2 FF FF 8A 10 20 42 E2 22 52 A0 E1 05 62 42 E0 01 50 85 E2 05 52 A0 E1 03 00 56 E3 05 40 81 E0 06 C0 A0 E1 05 50 80 E0 D9 FF FF 9A 00 30 A0 E3 03 20 94 E7 03 20 85 E7 04 30 83 E2 06 20 63 E0 03 00 52 E3 F9 FF FF 8A 04 C0 46 E2 2C 21 A0 E1 01 30 82 E2 03 31 A0 E1 03 40 84 E0 02 C1 4C E0 03 50 85 E0 CA FF FF EA }
	condition:
		$1
}

rule file_47_0_0 {
	meta:
		name = "_fflush_r"
		size = 460
		refs = "00c8 _free_r 0164 __sinit"
	strings:
		$1 = { F0 40 2D E9 00 70 50 E2 01 40 A0 E1 02 00 00 0A 38 30 97 E5 00 00 53 E3 51 00 00 0A BC 30 D4 E1 03 28 A0 E1 42 28 A0 E1 08 00 12 E3 29 00 00 1A 04 20 94 E5 02 3B 83 E3 00 00 52 E3 BC 30 C4 E1 42 00 00 DA 28 C0 94 E5 00 00 5C E3 42 00 00 0A 01 2A 13 E2 50 50 94 15 4A 00 00 0A 04 00 13 E3 41 00 00 1A 07 00 A0 E1 1C 10 94 E5 05 20 A0 E1 00 30 A0 E3 0F E0 A0 E1 1C FF 2F E1 00 00 55 E1 2D 00 00 1A BC 30 D4 E1 02 3B C3 E3 00 10 A0 E3 03 38 A0 E1 23 38 A0 E1 04 10 84 E5 30 10 94 E5 01 0A 13 E3 10 20 94 E5 50 50 84 15 00 00 51 E3 00 20 84 E5 BC 30 C4 E1 27 00 00 0A 40 30 84 E2 03 00 51 E1 07 00 A0 11 ?? ?? ?? ?? 00 00 A0 E3 30 00 84 E5 F0 80 BD E8 10 60 94 E5 00 00 56 E3 1D 00 00 0A 00 50 94 E5 03 00 12 E3 14 30 94 05 05 50 66 E0 00 30 A0 13 00 00 55 E3 00 60 84 E5 08 30 84 E5 03 00 00 CA 13 00 00 EA 00 00 55 E3 11 00 00 DA 00 60 86 E0 05 30 A0 E1 06 20 A0 E1 07 00 A0 E1 1C 10 94 E5 0F E0 A0 E1 24 F0 94 E5 00 00 50 E3 05 50 60 E0 F3 FF FF CA BC 30 D4 E1 40 30 83 E3 BC 30 C4 E1 00 00 E0 E3 F0 80 BD E8 3C 20 94 E5 00 00 52 E3 B9 FF FF CA 00 00 A0 E3 F0 80 BD E8 ?? ?? ?? ?? AB FF FF EA 30 20 94 E5 04 30 94 E5 00 00 52 E3 05 50 63 E0 3C 30 94 15 05 50 63 10 B6 FF FF EA 07 00 A0 E1 1C 10 94 E5 01 30 A0 E3 0F E0 A0 E1 1C FF 2F E1 01 00 70 E3 00 50 A0 E1 BC 30 D4 11 28 C0 94 15 AA FF FF 1A 00 30 97 E5 1D 00 53 E3 E7 FF FF 0A BC 30 D4 E1 40 30 83 E3 BC 30 C4 E1 F0 80 BD E8 }
	condition:
		$1
}

rule file_47_1_0 {
	meta:
		name = "fflush"
		size = 48
		refs = "0010 _fflush_r 0020 _fwalk_reent 0024 _impure_ptr 0028 _global_impure_ptr"
	strings:
		$1 = { 00 10 50 E2 02 00 00 0A 14 30 9F E5 00 00 93 E5 ?? ?? ?? ?? 0C 30 9F E5 0C 10 9F E5 00 00 93 E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_0_0 {
	meta:
		name = "write_char"
		size = 52
		refs = "0024 _write_r 0030 _impure_ptr"
	strings:
		$1 = { 04 E0 2D E5 24 30 9F E5 04 D0 4D E2 04 20 8D E2 04 00 62 E5 02 10 A0 E3 0D 20 A0 E1 00 00 93 E5 01 30 A0 E3 ?? ?? ?? ?? 04 D0 8D E2 00 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_1_0 {
	meta:
		name = "write_string"
		size = 48
		refs = "0010 strlen 0028 _write_r 002c _impure_ptr"
	strings:
		$1 = { 24 30 9F E5 30 40 2D E9 00 50 93 E5 00 40 A0 E1 ?? ?? ?? ?? 04 20 A0 E1 00 30 A0 E1 02 10 A0 E3 05 00 A0 E1 30 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_2_0 {
	meta:
		name = "print_number"
		size = 124
		refs = "0038 __umodsi3 004c __udivsi3"
	strings:
		$1 = { F0 40 2D E9 01 10 71 E2 00 10 A0 33 A2 1F 11 E0 20 D0 4D E2 02 40 A0 E1 00 60 A0 E1 11 00 00 1A 00 30 A0 E3 1F 30 CD E5 48 70 9F E5 1F 50 8D E2 04 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 00 30 D7 E7 06 10 A0 E1 04 00 A0 E1 01 30 65 E5 ?? ?? ?? ?? 00 40 50 E2 F5 FF FF 1A 05 00 A0 E1 DB FF FF EB 20 D0 8D E2 F0 80 BD E8 2D 00 A0 E3 CA FF FF EB 00 40 64 E2 E9 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_4_0 {
	meta:
		name = "__dprintf"
		size = 656
		refs = "028c __unctrl"
	strings:
		$1 = { 0F 00 2D E9 F0 4F 2D E9 01 30 A0 E3 08 D0 4D E2 B6 30 CD E1 06 20 DD E5 68 32 9F E5 01 20 72 E2 00 20 A0 33 00 20 83 E5 30 30 8D E2 00 30 8D E5 2C 50 9D E5 50 A2 9F E5 00 00 D5 E5 00 00 50 E3 29 00 00 0A 25 00 50 E3 44 00 00 1A 01 C0 F5 E5 25 00 5C E3 41 00 00 0A 4E 00 5C E3 42 00 00 0A 63 30 4C E2 01 50 85 E2 15 00 53 E3 03 F1 9F 97 F0 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 30 9D E5 00 00 93 E5 04 30 83 E2 00 30 8D E5 86 FF FF EB 00 00 D5 E5 00 00 50 E3 D5 FF FF 1A 08 D0 8D E2 F0 4F BD E8 10 D0 8D E2 1E FF 2F E1 00 30 9D E5 10 00 A0 E3 00 20 93 E5 01 10 A0 E3 04 30 83 E2 00 30 8D E5 84 FF FF EB C6 FF FF EA 00 30 9D E5 64 10 5C E2 01 10 A0 13 04 20 93 E4 78 00 5C E3 10 00 A0 03 0A 00 A0 13 00 30 8D E5 7A FF FF EB BC FF FF EA 00 30 9D E5 00 20 D3 E5 04 30 83 E2 02 01 9A E7 00 30 8D E5 67 FF FF EB B5 FF FF EA 01 50 85 E2 57 FF FF EB B2 FF FF EA 00 30 9D E5 08 20 83 E2 00 20 8D E5 01 80 D5 E5 90 00 93 E8 01 50 85 E2 63 60 48 E2 01 40 54 E2 20 00 00 4A 15 00 56 E3 06 F1 9F 97 17 00 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 04 00 97 E4 3F FF FF EB 00 00 54 E3 20 00 A0 E3 DF FF FF 0A 2E FF FF EB 01 40 54 E2 DE FF FF 5A 01 50 85 E2 86 FF FF EA 07 00 A0 E1 01 10 A0 E3 5F FF FF EB 01 10 A0 E3 00 20 A0 E1 10 00 A0 E3 3C FF FF EB 04 70 87 E2 EE FF FF EA 64 90 58 E2 01 90 A0 13 07 00 A0 E1 78 00 58 E3 09 10 A0 E1 10 B0 A0 03 0A B0 A0 13 51 FF FF EB 09 10 A0 E1 00 20 A0 E1 0B 00 A0 E1 2E FF FF EB 04 70 87 E2 E0 FF FF EA 01 30 D7 E4 03 01 9A E7 1D FF FF EB DC FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_0_0 {
	meta:
		name = "wcstombs"
		size = 60
	strings:
		$1 = { 00 00 52 E3 02 00 A0 01 1E FF 2F 01 00 30 A0 E3 03 C1 D1 E7 00 00 5C E3 03 C0 C0 E7 04 00 00 0A 01 30 83 E2 03 00 52 E1 F8 FF FF 1A 02 00 A0 E1 1E FF 2F E1 03 00 A0 E1 1E FF 2F E1 }
	condition:
		$1
}

rule file_50_0_0 {
	meta:
		name = "hash_fd"
		size = 56
		refs = "0028 __errno"
	strings:
		$1 = { 00 00 50 E3 10 40 2D E9 00 40 E0 03 03 00 00 0A 1C 30 90 E5 14 41 93 E5 01 00 74 E3 01 00 00 0A 04 00 A0 E1 10 80 BD E8 ?? ?? ?? ?? 02 30 A0 E3 00 30 80 E5 F9 FF FF EA }
	condition:
		$1
}

rule file_50_1_0 {
	meta:
		name = "flush_meta"
		size = 1460
		refs = "050c lseek 052c write 057c __put_page 0590 __errno"
	strings:
		$1 = { F0 4F 2D E9 34 31 90 E5 00 00 53 E3 53 DF 4D E2 00 40 A0 E1 02 00 00 1A 00 00 A0 E3 53 DF 8D E2 F0 8F BD E8 61 3A A0 E3 56 3E 83 E2 01 30 83 E2 00 30 80 E5 02 30 A0 E3 04 30 80 E5 0C 10 A0 E3 68 05 9F E5 0F E0 A0 E1 0C F1 94 E5 40 00 84 E5 04 00 A0 E1 04 10 D0 E4 08 10 8D E5 01 30 D0 E5 14 30 8D E5 08 10 84 E2 01 50 D1 E5 20 50 8D E5 0C 20 84 E2 01 60 D2 E5 2C 60 8D E5 01 70 D4 E5 03 A0 D4 E5 02 80 D4 E5 34 70 8D E5 03 90 D0 E5 0C 90 8D E5 02 00 D0 E5 10 00 8D E5 03 C0 D1 E5 04 B0 D4 E5 18 C0 8D E5 02 10 D1 E5 1C 10 8D E5 03 E0 D2 E5 08 90 D4 E5 24 E0 8D E5 02 20 D2 E5 28 20 8D E5 48 30 8D E2 0C 00 D4 E5 04 70 83 E2 08 60 83 E2 30 00 8D E5 03 B0 C7 E5 03 90 C6 E5 48 A0 CD E5 01 80 C3 E5 34 80 9D E5 02 80 C3 E5 08 90 9D E5 03 90 C3 E5 0C A0 9D E5 04 A0 C3 E5 10 80 9D E5 01 80 C7 E5 14 90 9D E5 02 90 C7 E5 18 A0 9D E5 08 A0 C3 E5 1C 70 9D E5 01 70 C6 E5 20 80 9D E5 02 80 C6 E5 24 90 9D E5 0C 90 C3 E5 28 A0 9D E5 0C 50 83 E2 01 A0 C5 E5 2C 60 9D E5 02 60 C5 E5 30 80 9D E5 14 71 94 E5 34 70 8D E5 03 80 C5 E5 10 E0 84 E2 01 90 DE E5 10 90 8D E5 14 C0 84 E2 01 A0 DC E5 20 A0 8D E5 18 00 84 E2 01 50 D0 E5 30 50 8D E5 1C 10 84 E2 01 60 D1 E5 40 60 8D E5 03 70 DE E5 08 70 8D E5 02 E0 DE E5 0C E0 8D E5 10 80 D4 E5 14 80 8D E5 03 90 DC E5 18 90 8D E5 02 C0 DC E5 1C C0 8D E5 14 A0 D4 E5 24 A0 8D E5 03 C0 D0 E5 28 C0 8D E5 02 00 D0 E5 2C 00 8D E5 18 E0 D4 E5 38 E0 8D E5 03 00 D1 E5 3C 00 8D E5 02 10 D1 E5 14 90 9D E5 44 10 8D E5 10 80 83 E2 20 20 84 E2 03 A0 D2 E5 1C B0 D4 E5 03 90 C8 E5 24 90 9D E5 14 70 83 E2 03 90 C7 E5 38 90 9D E5 18 60 83 E2 1C E0 83 E2 03 90 C6 E5 03 B0 CE E5 08 90 9D E5 10 90 C3 E5 0C 90 9D E5 01 90 C8 E5 10 90 9D E5 02 90 C8 E5 18 80 9D E5 14 80 C3 E5 1C 90 9D E5 01 90 C7 E5 20 80 9D E5 02 80 C7 E5 28 90 9D E5 18 90 C3 E5 2C 70 9D E5 01 70 C6 E5 30 80 9D E5 02 80 C6 E5 3C 90 9D E5 1C 90 C3 E5 44 60 9D E5 01 60 CE E5 40 70 9D E5 02 70 CE E5 20 A0 C3 E5 01 80 D2 E5 0C 80 8D E5 24 C0 84 E2 01 90 DC E5 1C 90 8D E5 28 00 84 E2 01 A0 D0 E5 2C A0 8D E5 2C 10 84 E2 01 E0 D1 E5 3C E0 8D E5 02 20 D2 E5 08 20 8D E5 20 20 D4 E5 10 20 8D E5 03 60 DC E5 14 60 8D E5 02 C0 DC E5 18 C0 8D E5 24 70 D4 E5 20 70 8D E5 03 80 D0 E5 24 80 8D E5 02 00 D0 E5 28 00 8D E5 28 90 D4 E5 30 90 8D E5 03 A0 D1 E5 38 A0 8D E5 02 10 D1 E5 04 10 8D E5 30 50 84 E2 03 C0 D5 E5 2C B0 D4 E5 40 C0 8D E5 10 90 9D E5 02 E0 D5 E5 20 A0 83 E2 44 E0 8D E5 03 90 CA E5 20 90 9D E5 24 80 83 E2 03 90 C8 E5 30 90 9D E5 28 70 83 E2 2C 60 83 E2 03 90 C7 E5 03 B0 C6 E5 08 90 9D E5 01 90 CA E5 0C 90 9D E5 02 90 CA E5 14 A0 9D E5 24 A0 C3 E5 18 90 9D E5 01 90 C8 E5 1C A0 9D E5 02 A0 C8 E5 24 80 9D E5 28 80 C3 E5 28 90 9D E5 01 90 C7 E5 2C A0 9D E5 02 A0 C7 E5 38 70 9D E5 2C 70 C3 E5 04 80 9D E5 01 80 C6 E5 3C 90 9D E5 02 90 C6 E5 40 A0 9D E5 30 A0 C3 E5 44 60 9D E5 30 20 83 E2 01 60 C2 E5 01 50 D5 E5 08 50 8D E5 34 E0 84 E2 01 70 DE E5 18 70 8D E5 38 C0 84 E2 01 80 DC E5 24 80 8D E5 3C 00 84 E2 01 90 D0 E5 28 90 8D E5 40 10 84 E2 01 A0 D1 E5 2C A0 8D E5 30 50 D4 E5 0C 50 8D E5 03 60 DE E5 10 60 8D E5 02 E0 DE E5 14 E0 8D E5 34 70 D4 E5 1C 70 8D E5 03 80 DC E5 20 80 8D E5 02 C0 DC E5 0C 80 9D E5 30 C0 8D E5 03 50 D1 E5 02 B0 D1 E5 38 A0 D4 E5 02 60 D0 E5 3C 90 D4 E5 03 70 D0 E5 03 80 C2 E5 1C 80 9D E5 34 E0 83 E2 3C 00 83 E2 38 C0 83 E2 03 80 CE E5 03 A0 CC E5 03 90 C0 E5 08 90 9D E5 02 90 C2 E5 10 A0 9D E5 34 A0 C3 E5 14 20 9D E5 01 20 CE E5 18 80 9D E5 02 80 CE E5 20 90 9D E5 38 90 C3 E5 30 A0 9D E5 01 A0 CC E5 24 E0 9D E5 02 E0 CC E5 3C 70 C3 E5 01 60 C0 E5 28 20 9D E5 40 10 83 E2 02 20 C0 E5 40 50 C3 E5 01 B0 C1 E5 2C 50 9D E5 02 50 C1 E5 40 20 D4 E5 C4 00 84 E2 03 20 C1 E5 00 60 A0 E1 44 10 84 E2 00 50 A0 E1 03 20 A0 E1 03 C0 D1 E5 44 C0 C2 E5 02 C0 D1 E5 45 C0 C2 E5 01 E0 D1 E5 04 C0 D1 E4 46 E0 C2 E5 47 C0 C2 E5 01 E0 D0 E5 02 C0 D0 E4 05 00 51 E1 C4 E0 C3 E5 C5 C0 C3 E5 04 20 82 E2 02 30 83 E2 EF FF FF 1A 00 10 A0 E3 34 00 9D E5 01 20 A0 E1 ?? ?? ?? ?? 01 00 70 E3 01 00 00 1A 00 00 E0 E3 BE FE FF EA 34 00 9D E5 48 10 8D E2 41 2F A0 E3 ?? ?? ?? ?? 01 00 70 E3 F7 FF FF 0A 41 0F 50 E3 04 50 A0 01 80 70 84 02 01 80 A0 03 03 00 00 0A 0F 00 00 EA 07 00 55 E1 02 60 86 E2 AE FE FF 0A 38 11 95 E5 00 00 51 E3 04 50 85 E2 F8 FF FF 0A B0 20 D6 E1 04 00 A0 E1 00 30 A0 E3 00 80 8D E5 ?? ?? ?? ?? 00 00 50 E3 F1 FF FF 0A 00 00 E0 E3 A2 FE FF EA ?? ?? ?? ?? 4F 30 A0 E3 00 30 80 E5 ?? ?? ?? ?? 00 30 90 E5 00 00 E0 E3 2C 31 84 E5 9A FE FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_50_2_0 {
	meta:
		name = "hdestroy"
		size = 252
		refs = "0010 __buf_free 0044 free 00bc close 00d4 __errno"
	strings:
		$1 = { F0 40 2D E9 01 10 A0 E3 34 21 90 E5 00 40 A0 E1 ?? ?? ?? ?? 00 70 50 E2 31 00 00 1A D8 31 94 E5 00 00 53 E3 0E 00 00 0A 00 00 93 E5 04 00 00 EA 04 31 94 E5 D8 21 94 E5 01 30 43 E2 03 01 92 E7 04 31 84 E5 ?? ?? ?? ?? 08 31 94 E5 00 00 53 E3 01 30 43 E2 08 31 84 E5 F4 FF FF 1A D8 01 94 E5 ?? ?? ?? ?? 04 00 A0 E1 77 FE FF EB 00 00 50 E3 01 00 00 0A 00 00 57 E3 1C 00 00 0A B8 31 94 E5 00 00 53 E3 0A 00 00 DA 04 60 A0 E1 00 50 A0 E3 38 01 96 E5 00 00 50 E3 01 50 85 E2 01 00 00 0A ?? ?? ?? ?? B8 31 94 E5 05 00 53 E1 04 60 86 E2 F6 FF FF CA 14 01 94 E5 01 00 70 E3 ?? ?? ?? ?? 04 00 A0 E1 ?? ?? ?? ?? 00 00 57 E3 07 00 A0 01 F0 80 BD 08 ?? ?? ?? ?? 00 70 80 E5 00 00 E0 E3 F0 80 BD E8 ?? ?? ?? ?? 00 70 90 E5 CA FF FF EA ?? ?? ?? ?? 00 70 90 E5 DF FF FF EA }
	condition:
		$1
}

rule file_50_3_0 {
	meta:
		name = "alloc_segs"
		size = 160
		refs = "0014 calloc 0080 __errno"
	strings:
		$1 = { 70 40 2D E9 00 50 A0 E1 01 40 A0 E1 14 00 90 E5 04 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 D8 01 85 E5 16 00 00 0A 1C 00 95 E5 04 10 A0 E3 14 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 10 00 00 0A 00 00 54 E3 00 00 A0 D3 70 80 BD D8 04 61 95 E5 1C C0 95 E5 D8 11 95 E5 00 30 A0 E3 13 2C A0 E1 02 21 80 E0 03 21 81 E7 01 30 83 E2 04 00 53 E1 F9 FF FF 1A 03 30 86 E0 04 31 85 E5 00 00 A0 E3 70 80 BD E8 ?? ?? ?? ?? 00 40 90 E5 05 00 A0 E1 9C FF FF EB ?? ?? ?? ?? 00 40 80 E5 00 00 E0 E3 70 80 BD E8 }
	condition:
		$1
}

rule file_50_4_0 {
	meta:
		name = "hash_close"
		size = 44
		refs = "0020 free"
	strings:
		$1 = { 30 40 2D E9 00 40 50 E2 00 50 E0 03 04 00 00 0A 1C 00 94 E5 5E FD FF EB 00 50 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 05 00 A0 E1 30 80 BD E8 }
	condition:
		$1
}

rule file_50_5_0 {
	meta:
		name = "hash_delete"
		size = 96
		refs = "0034 __errno"
	strings:
		$1 = { 01 00 52 E3 10 40 2D E9 1C 40 90 E5 08 00 00 8A 10 31 94 E5 03 00 13 E3 0B 00 00 0A 01 20 A0 E1 04 00 A0 E1 03 10 A0 E3 00 30 A0 E3 10 40 BD E8 0E FF FF EA ?? ?? ?? ?? 16 30 A0 E3 00 30 80 E5 2C 31 84 E5 00 00 E0 E3 10 80 BD E8 ?? ?? ?? ?? 01 30 A0 E3 00 30 80 E5 2C 31 84 E5 F8 FF FF EA }
	condition:
		$1
}

rule file_50_6_0 {
	meta:
		name = "hash_get"
		size = 68
		refs = "002c __errno"
	strings:
		$1 = { 30 40 2D E9 00 40 53 E2 01 C0 A0 E1 02 30 A0 E1 1C 50 90 E5 04 00 00 1A 05 00 A0 E1 04 10 A0 E1 0C 20 A0 E1 30 40 BD E8 21 FF FF EA ?? ?? ?? ?? 16 30 A0 E3 00 30 80 E5 2C 31 85 E5 00 00 E0 E3 30 80 BD E8 }
	condition:
		$1
}

rule file_50_7_0 {
	meta:
		name = "hash_put"
		size = 116
		refs = "0050 __errno"
	strings:
		$1 = { 08 00 53 E3 00 00 53 13 30 40 2D E9 02 C0 A0 E1 01 40 A0 E1 1C 50 90 E5 0A 00 00 1A 10 21 95 E5 03 00 12 E3 0D 00 00 0A 08 00 53 E3 02 10 A0 03 01 10 A0 13 05 00 A0 E1 04 20 A0 E1 0C 30 A0 E1 30 40 BD E8 37 FF FF EA 16 40 A0 E3 2C 41 85 E5 ?? ?? ?? ?? 00 40 80 E5 00 00 E0 E3 30 80 BD E8 ?? ?? ?? ?? 01 30 A0 E3 00 30 80 E5 2C 31 85 E5 F8 FF FF EA }
	condition:
		$1
}

rule file_50_8_0 {
	meta:
		name = "hash_seq"
		size = 596
		refs = "00a8 __get_buf 0214 __errno 0244 __big_keydata"
	strings:
		$1 = { F0 45 2D E9 03 00 53 E3 00 00 53 13 04 D0 4D E2 01 70 A0 E1 02 80 A0 E1 1C 40 90 E5 01 00 00 0A 07 00 53 E3 7A 00 00 1A 24 21 94 E5 03 00 53 E3 00 30 A0 13 01 30 A0 03 A2 3F 93 E1 20 21 94 05 00 20 A0 13 01 30 A0 13 28 31 84 15 24 21 84 15 20 21 84 15 00 00 52 E3 00 30 A0 E3 10 30 92 15 20 00 00 0A 28 11 94 E5 81 00 83 E0 B2 00 D0 E1 00 00 50 E3 13 00 00 1A 01 50 A0 E3 05 00 00 EA 10 30 90 E5 B4 10 D3 E1 00 00 51 E3 28 51 84 E5 05 10 A0 E1 0B 00 00 1A 81 10 A0 E1 B1 10 93 E1 04 00 A0 E1 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 00 20 A0 E1 20 01 84 E5 F0 FF FF 1A 00 00 E0 E3 04 D0 8D E2 F0 85 BD E8 B0 10 D3 E1 00 00 51 E3 24 00 00 1A 24 21 94 E5 20 11 84 E5 01 20 82 E2 24 21 84 E5 01 20 A0 E1 24 51 94 E5 28 10 94 E5 01 00 55 E1 14 00 00 8A 01 60 A0 E3 09 00 00 EA 10 30 92 E5 B0 10 D3 E1 00 00 51 E3 20 21 84 E5 0C 00 00 1A 28 10 94 E5 01 50 85 E2 05 00 51 E1 28 61 84 E5 08 00 00 3A 00 20 A0 E3 02 30 A0 E1 05 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 20 50 E2 EE FF FF 1A DC FF FF EA 28 10 94 E5 01 00 55 E1 00 30 E0 C3 24 51 84 E5 01 00 A0 C3 24 31 84 C5 BF FF FF DA D5 FF FF EA 28 01 94 E5 00 08 A0 E1 20 08 A0 E1 01 C0 80 E2 8C C0 A0 E1 BC 50 93 E1 03 00 55 E3 0C A0 83 E0 27 00 00 9A 20 61 94 E5 80 20 A0 E1 10 50 96 E5 01 00 50 E3 B2 C0 93 E1 02 20 83 E0 80 30 83 80 0C C0 85 E0 B2 50 53 81 02 30 80 E2 03 38 A0 E1 23 38 A0 E1 00 C0 87 E5 0C 50 94 95 B0 C0 D2 E1 03 00 51 E1 B0 20 DA E1 10 60 96 E5 24 31 94 35 0C 00 62 E0 02 20 86 E0 05 C0 6C E0 04 C0 87 E5 00 20 88 E5 04 00 88 E5 01 30 83 32 00 00 A0 33 01 20 A0 33 28 21 84 35 24 31 84 35 20 01 84 35 28 31 84 25 00 00 A0 23 AA FF FF EA ?? ?? ?? ?? 16 30 A0 E3 00 30 80 E5 2C 31 84 E5 00 00 E0 E3 A4 FF FF EA 02 10 A0 E1 01 C0 A0 E3 04 00 A0 E1 07 20 A0 E1 08 30 A0 E1 00 C0 8D E5 ?? ?? ?? ?? 00 00 50 E3 9B FF FF 0A 99 FF FF EA }
	condition:
		$1
}

rule file_50_9_0 {
	meta:
		name = "hash_sync"
		size = 104
		refs = "002c __buf_free 0054 __errno"
	strings:
		$1 = { 00 00 51 E3 10 40 2D E9 11 00 00 1A 00 00 50 E3 0D 00 00 0A 1C 40 90 E5 34 01 94 E5 00 00 50 E3 10 80 BD 08 04 00 A0 E1 01 20 A0 E3 ?? ?? ?? ?? 00 00 50 E3 04 00 00 1A 04 00 A0 E1 DC FB FF EB 00 00 50 E3 30 01 84 05 10 80 BD 08 00 00 E0 E3 10 80 BD E8 ?? ?? ?? ?? 16 30 A0 E3 00 30 80 E5 00 00 E0 E3 10 80 BD E8 }
	condition:
		$1
}

rule file_50_10_0 {
	meta:
		name = "hash_access"
		size = 728
		refs = "0028 __call_hash 003c __get_buf 00d8 __find_bigpair 00f8 __find_last_page 01a0 memcmp 01c4 __addel 01fc __big_return 0244 __delpair 02d4 abort"
	strings:
		$1 = { F0 4F 2D E9 00 0C 92 E8 18 D0 4D E2 08 20 8D E5 0C 10 8D E5 0B 20 A0 E1 0A 10 A0 E1 00 90 A0 E1 10 30 8D E5 0C 40 90 E5 ?? ?? ?? ?? 00 20 A0 E3 00 10 A0 E1 02 30 A0 E1 09 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 04 00 8D E5 6E 00 00 0A 14 30 D0 E5 08 30 83 E3 14 30 C0 E5 04 20 9D E5 10 60 92 E5 B0 80 D6 E1 01 00 58 E3 02 50 A0 D1 30 00 00 DA 04 20 A0 E1 02 60 86 E2 04 50 9D E5 01 70 A0 E3 0A 40 A0 E1 08 00 00 EA B0 10 D6 E1 02 20 61 E0 0B 00 52 E1 3D 00 00 0A 02 70 87 E2 08 00 57 E1 03 20 A0 E1 04 60 86 E2 21 00 00 AA B2 30 D6 E1 03 00 53 E3 02 A0 86 E2 F2 FF FF 8A 00 00 53 E3 26 00 00 0A 07 20 A0 E1 09 00 A0 E1 05 10 A0 E1 04 30 A0 E1 00 B0 8D E5 ?? ?? ?? ?? 00 70 50 E2 4A 00 00 CA 02 00 77 E3 22 00 00 1A 14 10 8D E2 09 00 A0 E1 14 50 8D E5 ?? ?? ?? ?? 00 10 50 E2 4A 00 00 0A 09 00 A0 E1 14 20 9D E5 00 30 A0 E3 ?? ?? ?? ?? 00 50 50 E2 16 00 00 0A 10 60 95 E5 B2 80 D6 E0 01 70 A0 E3 08 00 57 E1 0C 20 99 E5 DD FF FF BA 0C 20 9D E5 01 30 42 E2 01 00 53 E3 1B 00 00 9A 04 20 9D E5 14 30 D2 E5 08 30 C3 E3 14 30 C2 E5 01 00 A0 E3 18 D0 8D E2 F0 8F BD E8 05 20 A0 E1 B0 10 D6 E1 09 00 A0 E1 ?? ?? ?? ?? 00 50 50 E2 E8 FF FF 1A 04 20 9D E5 14 30 D2 E5 08 30 C3 E3 14 30 C2 E5 00 00 E0 E3 F1 FF FF EA 10 30 95 E5 04 00 A0 E1 01 10 83 E0 0B 20 A0 E1 ?? ?? ?? ?? 00 00 50 E3 18 00 00 0A B0 30 DA E1 B8 FF FF EA 09 00 A0 E1 05 10 A0 E1 08 20 9D E5 10 30 9D E5 ?? ?? ?? ?? 00 00 50 E3 E9 FF FF 1A 04 20 9D E5 14 30 D2 E5 08 30 C3 E3 14 30 C2 E5 DC FF FF EA 00 C0 A0 E3 09 00 A0 E1 05 10 A0 E1 07 20 A0 E1 10 30 9D E5 00 C0 8D E5 ?? ?? ?? ?? 00 00 50 E3 11 00 00 0A 00 00 E0 E3 D1 FF FF EA 0C 30 9D E5 03 00 53 E3 03 F1 9F 97 2C 00 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 14 50 9D E5 BE FF FF EA 09 00 A0 E1 05 10 A0 E1 07 20 A0 E1 ?? ?? ?? ?? 00 00 50 E3 ED FF FF 1A 04 20 9D E5 14 30 D2 E5 08 30 C3 E3 14 30 C2 E5 00 00 A0 E3 BB FF FF EA 07 20 A0 E1 09 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 BD FF FF 1A 09 00 A0 E1 05 10 A0 E1 08 20 9D E5 10 30 9D E5 ?? ?? ?? ?? 00 00 50 E3 EC FF FF 0A B5 FF FF EA 10 20 95 E5 87 30 82 E0 B2 30 D3 E1 03 00 53 E3 CB FF FF 9A 87 70 A0 E1 B7 10 92 E1 01 10 63 E0 03 30 82 E0 10 20 9D E5 04 10 82 E5 00 30 82 E5 DE FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_50_11_0 {
	meta:
		name = "__call_hash"
		size = 52
	strings:
		$1 = { 10 40 2D E9 00 40 A0 E1 01 00 A0 E1 02 10 A0 E1 0F E0 A0 E1 0C F1 94 E5 2C 20 94 E5 28 30 94 E5 02 00 00 E0 03 00 50 E1 30 30 94 C5 03 00 00 C0 10 80 BD E8 }
	condition:
		$1
}

rule file_50_12_0 {
	meta:
		name = "__expand_table"
		size = 272
		refs = "0048 calloc 0078 __log2 00bc __split_page 00c8 malloc 00e0 memmove 00f0 memset 00f8 free"
	strings:
		$1 = { F0 47 2D E9 28 50 90 E5 1C 60 90 E5 01 50 85 E2 35 66 A0 E1 04 31 90 E5 03 00 56 E1 00 40 A0 E1 28 50 80 E5 30 70 90 E5 05 00 A0 B1 10 00 00 BA 14 90 94 E5 09 00 56 E1 D8 A1 94 B5 1F 00 00 AA 18 00 94 E5 04 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 06 01 8A E7 2B 00 00 0A 08 21 94 E5 04 31 94 E5 01 20 82 E2 01 30 83 E2 08 21 84 E5 04 31 84 E5 28 00 94 E5 01 00 80 E2 ?? ?? ?? ?? 20 30 94 E5 03 00 50 E1 11 30 83 C2 03 21 94 C7 11 30 80 C2 03 21 84 C7 2C 30 94 E5 20 00 84 C5 03 00 55 E1 03 20 85 81 2C 20 84 85 04 00 A0 E1 07 10 05 E0 05 20 A0 E1 30 30 84 85 F0 47 BD E8 ?? ?? ?? ?? 89 81 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 00 A0 50 E2 09 91 A0 E1 0B 00 00 0A D8 11 94 E5 09 20 A0 E1 ?? ?? ?? ?? 08 20 69 E0 00 10 A0 E3 09 00 8A E0 ?? ?? ?? ?? D8 01 94 E5 ?? ?? ?? ?? 14 80 84 E5 D8 A1 84 E5 CD FF FF EA 00 00 E0 E3 F0 87 BD E8 }
	condition:
		$1
}

rule file_50_13_0 {
	meta:
		name = "__hash_open"
		size = 2256
		refs = "002c calloc 0058 __errno 0088 open 00d0 read 04a4 close 04ac free 04e4 stat 0500 fstat 0570 memset 0604 __divsi3 0614 __log2 064c __ibitmap 074c __buf_init 077c malloc 08b0 __default_hash 08b4 hash_close 08b8 hash_delete 08bc hash_fd 08c0 hash_get 08c4 hash_put 08c8 hash_seq 08cc hash_sync"
	strings:
		$1 = { F0 4F 2D E9 01 60 A0 E1 03 10 01 E2 8C D0 4D E2 01 00 51 E3 00 00 8D E5 02 70 A0 E1 03 50 A0 E1 28 01 00 0A 01 00 A0 E3 77 1F A0 E3 ?? ?? ?? ?? 00 40 50 E2 8E 01 00 0A 00 30 9D E5 00 00 53 E3 00 30 E0 E3 14 31 84 E5 10 61 84 E5 01 00 00 0A 01 0B 16 E3 20 01 00 0A ?? ?? ?? ?? 00 30 90 E5 02 00 53 E3 84 01 00 0A 00 C0 9D E5 00 00 5C E3 28 01 00 0A 01 30 A0 E3 08 30 8D E5 07 20 A0 E1 00 00 9D E5 06 10 A0 E1 ?? ?? ?? ?? 01 00 70 E3 14 01 84 E5 F7 01 00 0A 02 0C 16 E3 16 01 00 1A 08 C0 9D E5 00 00 5C E3 1A 01 00 1A 00 00 55 E3 6C 01 00 0A 10 30 95 E5 00 00 53 E3 69 01 00 0A 0C 31 84 E5 04 10 A0 E1 41 2F A0 E3 14 01 94 E5 ?? ?? ?? ?? 00 30 94 E5 8C E0 8D E2 08 30 2E E5 87 30 DD E5 04 00 8D E5 00 30 C4 E5 86 30 DD E5 01 30 C4 E5 85 30 DD E5 02 30 C4 E5 84 30 DD E5 03 30 C4 E5 04 30 A0 E1 04 20 B3 E5 84 20 8D E5 87 20 DD E5 04 20 C4 E5 86 20 DD E5 01 20 C3 E5 85 20 DD E5 02 20 C3 E5 84 20 DD E5 03 20 C3 E5 04 30 A0 E1 08 20 B3 E5 84 20 8D E5 87 20 DD E5 08 20 C4 E5 86 20 DD E5 01 20 C3 E5 85 20 DD E5 02 20 C3 E5 84 20 DD E5 03 20 C3 E5 04 30 A0 E1 0C 20 B3 E5 84 20 8D E5 87 20 DD E5 0C 20 C4 E5 86 20 DD E5 01 20 C3 E5 85 20 DD E5 02 20 C3 E5 84 20 DD E5 03 20 C3 E5 04 30 A0 E1 10 20 B3 E5 84 20 8D E5 87 20 DD E5 10 20 C4 E5 86 20 DD E5 01 20 C3 E5 85 20 DD E5 02 20 C3 E5 84 20 DD E5 03 20 C3 E5 04 30 A0 E1 14 20 B3 E5 84 20 8D E5 87 20 DD E5 14 20 C4 E5 86 20 DD E5 01 20 C3 E5 85 20 DD E5 02 20 C3 E5 84 20 DD E5 03 20 C3 E5 04 30 A0 E1 18 20 B3 E5 84 20 8D E5 87 20 DD E5 18 20 C4 E5 86 20 DD E5 01 20 C3 E5 85 20 DD E5 02 20 C3 E5 84 20 DD E5 03 20 C3 E5 04 30 A0 E1 1C 20 B3 E5 84 20 8D E5 87 20 DD E5 1C 20 C4 E5 86 20 DD E5 01 20 C3 E5 85 20 DD E5 02 20 C3 E5 84 20 DD E5 03 20 C3 E5 04 30 A0 E1 20 20 B3 E5 84 20 8D E5 87 20 DD E5 20 20 C4 E5 86 20 DD E5 01 20 C3 E5 85 20 DD E5 02 20 C3 E5 84 20 DD E5 03 20 C3 E5 04 30 A0 E1 24 20 B3 E5 84 20 8D E5 87 20 DD E5 24 20 C4 E5 86 20 DD E5 01 20 C3 E5 85 20 DD E5 02 20 C3 E5 84 20 DD E5 03 20 C3 E5 04 30 A0 E1 28 20 B3 E5 84 20 8D E5 87 20 DD E5 28 20 C4 E5 86 20 DD E5 01 20 C3 E5 85 20 DD E5 02 20 C3 E5 84 20 DD E5 03 20 C3 E5 04 30 A0 E1 2C 20 B3 E5 84 20 8D E5 87 20 DD E5 2C 20 C4 E5 86 20 DD E5 01 20 C3 E5 85 20 DD E5 02 20 C3 E5 84 20 DD E5 03 20 C3 E5 04 30 A0 E1 30 20 B3 E5 84 20 8D E5 87 20 DD E5 30 20 C4 E5 86 20 DD E5 01 20 C3 E5 85 20 DD E5 02 20 C3 E5 84 20 DD E5 03 20 C3 E5 04 30 A0 E1 34 20 B3 E5 84 20 8D E5 87 20 DD E5 34 20 C4 E5 86 20 DD E5 01 20 C3 E5 85 20 DD E5 02 20 C3 E5 84 20 DD E5 03 20 C3 E5 04 30 A0 E1 38 20 B3 E5 84 20 8D E5 87 20 DD E5 38 20 C4 E5 86 20 DD E5 01 20 C3 E5 85 20 DD E5 02 20 C3 E5 84 20 DD E5 03 20 C3 E5 04 30 A0 E1 3C 20 B3 E5 84 20 8D E5 87 20 DD E5 3C 20 C4 E5 86 20 DD E5 01 20 C3 E5 85 20 DD E5 02 20 C3 E5 84 20 DD E5 03 20 C3 E5 04 30 A0 E1 40 20 B3 E5 84 20 8D E5 87 20 DD E5 40 20 C4 E5 86 20 DD E5 01 20 C3 E5 85 20 DD E5 02 20 C3 E5 84 20 DD E5 C4 00 84 E2 8A 60 8D E2 03 20 C3 E5 03 B0 8E E2 02 90 8E E2 01 A0 8E E2 01 80 86 E2 04 10 A0 E1 44 30 84 E2 00 20 A0 E1 00 70 A0 E1 44 C0 91 E5 84 C0 8D E5 00 C0 DB E5 00 C0 C3 E5 00 C0 D9 E5 01 C0 C3 E5 00 C0 DA E5 02 C0 C3 E5 00 C0 DE E5 03 C0 C3 E5 B2 C0 D0 E0 BA C8 CD E1 00 C0 D8 E5 00 C0 C2 E5 04 30 83 E2 00 C0 D6 E5 07 00 53 E1 01 C0 C2 E5 04 10 81 E2 02 20 82 E2 EA FF FF 1A 04 30 9D E5 01 00 73 E3 0D 01 00 0A 04 C0 9D E5 41 0F 5C E3 10 00 00 1A 61 3A A0 E3 56 3E 83 E2 00 20 94 E5 01 30 83 E2 03 00 52 E1 0A 00 00 1A 04 30 94 E5 01 30 43 E2 01 00 53 E3 06 00 00 8A 24 04 9F E5 0C 10 A0 E3 0F E0 A0 E1 0C F1 94 E5 40 30 94 E5 03 00 50 E1 8B 00 00 0A 4F 50 A0 E3 14 01 94 E5 ?? ?? ?? ?? 04 00 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 00 50 80 E5 00 50 A0 E3 05 00 A0 E1 8C D0 8D E2 F0 8F BD E8 ?? ?? ?? ?? 16 30 A0 E3 00 30 80 E5 00 50 A0 E3 F7 FF FF EA 00 00 9D E5 48 10 8D E2 ?? ?? ?? ?? 00 00 50 E3 66 00 00 1A 00 30 A0 E3 08 30 8D E5 DF FE FF EA 48 10 8D E2 ?? ?? ?? ?? 00 00 50 E3 E4 FE FF 1A 58 30 9D E5 00 00 53 E3 E1 FE FF 1A 90 33 9F E5 00 10 93 E5 4D 3E A0 E3 02 30 83 E2 08 30 84 E5 01 3A A0 E3 0C 30 84 E5 0C 30 A0 E3 10 30 84 E5 08 30 A0 E3 00 60 A0 E3 01 2C A0 E3 1C 30 84 E5 01 38 A0 E3 34 30 84 E5 14 20 84 E5 0C 11 84 E5 18 20 84 E5 06 10 A0 E1 80 20 A0 E3 38 60 84 E5 44 00 84 E2 ?? ?? ?? ?? 06 10 A0 E1 C4 00 84 E2 40 20 A0 E3 ?? ?? ?? ?? 00 30 9D E5 06 00 53 E1 AF 00 00 1A 00 00 55 E3 05 00 A0 01 18 00 00 0A 00 00 95 E5 00 00 50 E3 3D 00 00 1A 04 30 95 E5 00 00 53 E3 34 30 84 15 10 30 95 E5 08 20 95 E5 00 00 53 E3 0C 31 84 15 14 30 95 E5 00 00 52 E3 02 00 A0 11 01 00 A0 03 00 00 53 E3 07 00 00 0A 4D 1E A0 E3 43 2D A0 E3 02 10 81 E2 21 20 82 E2 01 00 53 E1 02 00 53 11 08 30 84 05 2F 00 00 1A 01 00 40 E2 34 10 94 E5 ?? ?? ?? ?? 01 00 80 E2 02 00 50 E3 02 00 A0 B3 ?? ?? ?? ?? 00 60 A0 E1 01 20 80 E2 11 00 80 E2 00 21 84 E7 12 30 86 E2 02 00 A0 E3 86 15 A0 E1 24 00 84 E5 03 21 84 E7 20 60 84 E5 01 10 81 E2 04 00 A0 E1 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 60 00 00 0A ?? ?? ?? ?? 00 40 A0 E3 00 50 90 E5 8F FF FF EA 40 32 9F E5 00 30 93 E5 92 FE FF EA 00 50 A0 E3 8F FF FF EA ?? ?? ?? ?? 00 30 A0 E3 00 30 80 E5 76 FE FF EA ?? ?? ?? ?? 00 30 90 E5 02 00 53 E3 94 FF FF 1A 6D FE FF EA ?? ?? ?? ?? 01 30 A0 E3 13 30 A0 E1 01 08 53 E3 10 00 84 E5 0C 30 84 E5 BA FF FF DA ?? ?? ?? ?? 16 30 A0 E3 00 30 80 E5 E2 FF FF EA 18 30 94 E5 28 00 94 E5 03 10 A0 E1 00 00 83 E0 ?? ?? ?? ?? 00 30 A0 E3 00 10 A0 E1 04 31 84 E5 04 00 A0 E1 1A FE FF EB 00 10 50 E2 DD FF FF 1A 20 30 94 E5 11 30 83 E2 03 21 94 E7 0C 00 84 E2 09 00 90 E8 80 21 82 E0 01 20 42 E2 03 30 83 E2 52 23 A0 E1 4E 0F 84 E2 B8 21 84 E5 02 21 A0 E1 ?? ?? ?? ?? 00 00 55 E3 02 00 00 0A 0C 10 95 E5 00 00 51 E3 22 00 00 1A 04 00 A0 E1 01 18 A0 E3 ?? ?? ?? ?? 00 30 9D E5 00 00 53 E3 10 31 94 15 A3 30 A0 11 01 30 03 12 08 C0 9D E5 34 31 84 E5 00 30 E0 E3 30 C1 84 E5 24 31 84 E5 24 00 A0 E3 ?? ?? ?? ?? 00 50 50 E2 41 00 00 0A 24 31 9F E5 04 30 85 E5 20 31 9F E5 08 30 85 E5 1C 31 9F E5 20 30 85 E5 18 31 9F E5 0C 30 85 E5 14 31 9F E5 10 30 85 E5 10 31 9F E5 14 30 85 E5 0C 31 9F E5 18 30 85 E5 01 30 A0 E3 1C 40 85 E5 00 30 85 E5 3A FF FF EA 04 00 A0 E1 ?? ?? ?? ?? DC FF FF EA 01 70 A0 E3 17 06 A0 E1 10 20 94 E5 7F 3F A0 E3 03 30 83 E2 33 32 A0 E1 10 27 A0 E1 07 30 83 E0 01 20 42 E2 01 00 40 E2 2C 20 84 E5 3C 30 84 E5 18 10 94 E5 30 00 84 E5 28 00 84 E5 ?? ?? ?? ?? 07 00 80 E0 ?? ?? ?? ?? 17 10 A0 E1 14 30 94 E5 03 00 51 E1 14 10 84 C5 04 00 A0 E1 C8 FD FF EB 00 00 50 E3 01 C0 A0 03 08 C0 8D 05 B8 FF FF 0A 81 FF FF EA 03 00 A0 E1 0C 10 8D E2 ?? ?? ?? ?? 06 00 50 E1 7C FF FF 1A 38 00 9D E5 0C 00 84 E5 ?? ?? ?? ?? 10 00 84 E5 45 FF FF EA ?? ?? ?? ?? 00 50 90 E5 08 FF FF EA ?? ?? ?? ?? 00 50 90 E5 03 FF FF EA ?? ?? ?? ?? 00 60 90 E5 04 00 A0 E1 70 FD FF EB ?? ?? ?? ?? 00 60 80 E5 03 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_52_0_0 {
	meta:
		name = "_wctomb_r"
		size = 1048
		refs = "0014 strlen 0028 strcmp 0404 __lc_ctype"
	strings:
		$1 = { F0 40 2D E9 F8 03 9F E5 01 40 A0 E1 02 50 A0 E1 03 60 A0 E1 ?? ?? ?? ?? 01 00 50 E3 16 00 00 9A DC 03 9F E5 DC 13 9F E5 ?? ?? ?? ?? 00 00 50 E3 17 00 00 1A 00 00 54 E3 45 00 00 0A 7F 00 55 E3 10 00 00 9A 80 30 45 E2 1E 0D 53 E3 24 00 00 2A 1F 3D 05 E2 23 33 A0 E1 3F 50 05 E2 03 3D E0 E1 85 5C E0 E1 23 3D E0 E1 A5 5C E0 E1 01 50 C4 E5 00 30 C4 E5 02 00 A0 E3 F0 80 BD E8 00 00 54 E3 33 00 00 0A FF 50 05 E2 00 50 C4 E5 01 00 A0 E3 F0 80 BD E8 68 03 9F E5 6C 13 9F E5 ?? ?? ?? ?? 00 00 50 E3 4B 00 00 1A 00 00 54 E3 28 00 00 0A 25 34 A0 E1 FF 30 13 E2 FF 50 05 E2 F1 FF FF 0A 20 10 83 E2 7F 20 83 E2 FF 10 01 E2 FF 20 02 E2 1E 00 52 E3 0F 00 51 83 C2 00 00 9A 00 00 E0 E3 F0 80 BD E8 02 3B 45 E2 3E 0B 53 E3 6C 00 00 3A 01 38 45 E2 1F 08 53 E3 17 00 00 2A 07 07 05 E2 20 09 A0 E1 3F 1A 05 E2 3F 2D 05 E2 00 0E E0 E1 04 30 A0 E1 20 0E E0 E1 21 16 A0 E1 22 23 A0 E1 3F 50 05 E2 01 00 C3 E4 81 1C E0 E1 82 2C E0 E1 85 5C E0 E1 A1 1C E0 E1 A2 2C E0 E1 A5 5C E0 E1 01 10 C4 E5 04 00 A0 E3 02 50 C3 E5 01 20 C3 E5 F0 80 BD E8 00 00 A0 E3 F0 80 BD E8 02 36 45 E2 3E 06 53 E3 62 00 00 2A 03 C4 05 E2 2C CC A0 E1 8C CE E0 E1 04 30 A0 E1 AC CE E0 E1 3F 07 05 E2 3F 1A 05 E2 3F 2D 05 E2 01 C0 C3 E4 20 09 A0 E1 21 16 A0 E1 22 23 A0 E1 3F 50 05 E2 80 0C E0 E1 81 1C E0 E1 82 2C E0 E1 85 5C E0 E1 A0 0C E0 E1 01 C0 83 E2 A1 1C E0 E1 A2 2C E0 E1 A5 5C E0 E1 01 00 C4 E5 01 10 C3 E5 05 00 A0 E3 02 50 CC E5 01 20 CC E5 F0 80 BD E8 24 02 9F E5 2C 12 9F E5 ?? ?? ?? ?? 00 00 50 E3 11 00 00 1A 00 00 54 E3 D7 FF FF 0A 25 34 A0 E1 FF 30 13 E2 FF 50 05 E2 A0 FF FF 0A 5F 20 83 E2 FF 20 02 E2 5D 00 52 E3 B1 FF FF 8A 5F 20 85 E2 FF 20 02 E2 5D 00 52 E3 AD FF FF 8A 01 50 C4 E5 00 30 C4 E5 02 00 80 E2 F0 80 BD E8 C8 01 9F E5 D4 11 9F E5 ?? ?? ?? ?? 00 00 50 E3 8C FF FF 1A 00 00 54 E3 01 00 80 02 F0 80 BD 08 25 34 A0 E1 FF 20 13 E2 FF 50 05 E2 48 00 00 1A 00 30 96 E5 00 00 53 E3 01 00 A0 03 09 00 00 0A 00 20 86 E5 04 30 A0 E1 1B 20 A0 E3 01 20 C3 E4 28 20 A0 E3 01 20 C4 E5 42 20 A0 E3 01 20 C3 E5 02 40 83 E2 04 00 A0 E3 00 50 C4 E5 F0 80 BD E8 36 3B 45 E2 02 0B 53 E3 8A FF FF 3A 0F 0A 05 E2 20 06 A0 E1 80 0D E0 E1 3F 1D 05 E2 A0 0D E0 E1 04 30 A0 E1 21 13 A0 E1 3F 20 05 E2 01 00 C3 E4 81 1C E0 E1 82 2C E0 E1 A1 1C E0 E1 A2 2C E0 E1 01 10 C4 E5 03 00 A0 E3 01 20 C3 E5 F0 80 BD E8 3F 33 85 E2 61 03 73 E3 76 FF FF 8A 01 21 05 E2 22 2F A0 E1 02 2F E0 E1 04 30 A0 E1 22 2F E0 E1 01 20 C3 E4 3F 64 05 E2 3F C7 05 E2 3F 0A 05 E2 3F 2D 05 E2 3F 10 05 E2 26 6C A0 E1 2C C9 A0 E1 20 06 A0 E1 22 23 A0 E1 01 70 83 E2 86 6C E0 E1 8C CC E0 E1 80 0C E0 E1 82 2C E0 E1 81 1C E0 E1 A0 0C E0 E1 01 50 87 E2 A6 6C E0 E1 AC CC E0 E1 A2 2C E0 E1 A1 1C E0 E1 01 60 C4 E5 01 C0 C3 E5 01 00 C7 E5 02 10 C5 E5 01 20 C5 E5 06 00 A0 E3 F0 80 BD E8 21 30 42 E2 5D 00 53 E3 51 FF FF 8A 21 30 45 E2 5D 00 53 E3 4E FF FF 8A 00 30 96 E5 00 00 53 E3 02 00 A0 13 0A 00 00 1A 01 10 A0 E3 00 10 86 E5 04 30 A0 E1 1A 10 81 E2 01 10 C3 E4 09 10 81 E2 01 10 C4 E5 1E 10 81 E2 01 10 C3 E5 02 40 83 E2 05 00 A0 E3 01 50 C4 E5 00 20 C4 E5 F0 80 BD E8 80 10 45 E2 FF 10 01 E2 40 20 45 E2 3E 00 52 E3 7C 00 51 83 88 FF FF 9A 35 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_53_0_0 {
	meta:
		name = "_wcstoul_r"
		size = 468
		refs = "0024 iswspace 0088 __umodsi3 0098 __udivsi3 00ac iswdigit 0120 iswalpha 0130 iswupper"
	strings:
		$1 = { F0 4F 2D E9 0C D0 4D E2 08 00 8D E5 01 40 A0 E1 02 50 A0 E1 03 A0 A0 E1 01 70 A0 E1 04 60 97 E4 06 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 FA FF FF 1A 2D 00 56 E3 5A 00 00 0A 2B 00 56 E3 04 60 97 04 00 B0 A0 E1 01 30 7A E2 00 30 A0 33 00 00 5A E3 10 00 5A 13 09 00 00 1A 30 00 56 E3 53 00 00 0A 00 00 53 E3 05 00 00 0A 30 00 56 E3 08 A0 A0 03 0A A0 A0 13 07 90 A0 03 05 90 A0 13 03 00 00 EA 00 00 E0 E3 0A 10 A0 E1 ?? ?? ?? ?? 00 90 A0 E1 0A 10 A0 E1 00 00 E0 E3 ?? ?? ?? ?? 00 80 A0 E3 04 00 8D E5 06 00 A0 E1 00 80 8D E5 ?? ?? ?? ?? 00 00 50 E3 30 60 46 12 17 00 00 0A 06 00 5A E1 21 00 00 DA 06 00 9D E8 02 00 51 E1 00 30 A0 93 01 30 A0 83 A8 3F 93 E1 29 00 00 1A 09 00 56 E1 00 30 A0 D3 01 30 A0 C3 02 00 51 E1 00 30 A0 13 00 00 53 E3 22 00 00 1A 9A 61 21 E0 04 60 97 E4 00 10 8D E5 01 80 A0 E3 06 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 30 60 46 12 E7 FF FF 1A 06 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 06 00 A0 E1 06 00 00 0A ?? ?? ?? ?? 00 00 50 E3 37 00 A0 13 57 00 A0 03 06 60 60 E0 06 00 5A E1 DD FF FF CA 01 00 78 E3 0E 00 00 0A 00 00 5B E3 00 20 9D 15 00 20 62 12 00 20 8D 15 00 00 55 E3 02 00 00 0A 00 00 58 E3 04 40 47 12 00 40 85 E5 00 00 9D E5 0C D0 8D E2 F0 8F BD E8 00 80 E0 E3 04 60 97 E4 DD FF FF EA 08 10 9D E5 22 30 A0 E3 00 30 81 E5 00 80 8D E5 EF FF FF EA 04 60 97 E4 01 B0 A0 E3 A4 FF FF EA 00 20 97 E5 78 00 52 E3 58 00 52 13 A7 FF FF 1A 04 60 97 E5 0F 90 A0 E3 08 70 87 E2 10 A0 A0 E3 AE FF FF EA }
	condition:
		$1
}

rule file_54_0_0 {
	meta:
		name = "__tzcalc_limits"
		size = 576
		refs = "000c __gettzinfo"
	strings:
		$1 = { F0 4F 2D E9 08 D0 4D E2 00 B0 A0 E1 ?? ?? ?? ?? 7B 3E A0 E3 01 30 83 E2 03 00 5B E1 00 00 A0 D3 69 00 00 DA 08 92 9F E5 7B 3E 4B E2 99 2B C8 E0 02 30 43 E2 45 10 83 E2 19 2D 4B E2 99 C1 C6 E0 01 20 42 E2 99 C2 C4 E0 CB CF A0 E1 C8 A3 6C E0 0A A1 8A E0 C1 9F A0 E1 83 51 83 E0 0A A1 8A E0 85 11 83 E0 C2 2F A0 E1 0A A2 5B E0 C6 92 49 E0 C8 82 6C E0 01 30 83 E2 C4 43 62 E0 43 91 89 E0 08 81 88 E0 01 11 81 E0 30 20 A0 03 00 20 A0 13 01 90 89 E0 08 81 88 E0 04 20 8D E5 04 B0 80 E5 04 90 89 E0 08 81 4B E0 00 40 A0 E1 03 B0 0B E2 00 70 A0 E3 08 30 D4 E5 4A 00 53 E3 48 00 00 0A 44 00 53 E3 57 00 00 0A 00 00 5B E3 40 00 00 0A 04 50 9D E5 0C 60 94 E5 58 31 9F E5 01 00 56 E3 00 C0 A0 D3 05 50 83 E0 09 10 A0 D1 00 C0 8D D5 0B 00 00 DA 09 10 A0 E1 00 20 A0 E3 01 30 A0 E3 02 C0 95 E7 01 30 83 E2 06 00 53 E1 0C 10 81 E0 04 20 82 E2 F9 FF FF 1A 01 30 43 E2 03 31 A0 E1 00 30 8D E5 10 31 9F E5 04 20 81 E2 93 C2 C6 E0 C2 CF A0 E1 02 60 86 E0 46 C1 6C E0 8C C1 6C E0 14 60 94 E5 02 20 6C E0 02 60 56 E0 10 20 94 E5 00 C0 9D E5 01 20 42 E2 07 60 86 42 0C 30 95 E7 82 21 62 E0 02 60 86 E0 03 00 56 E1 02 00 00 BA 07 60 46 E2 03 00 56 E1 FC FF FF AA 01 60 86 E0 06 11 86 E0 01 11 86 E0 20 20 94 E5 18 30 94 E5 01 12 86 E0 03 30 82 E0 81 60 86 E0 01 70 87 E2 86 63 83 E0 02 00 57 E3 1C 60 A4 E5 C0 FF FF 1A 1C 20 90 E5 38 30 90 E5 03 00 52 E1 00 30 A0 A3 01 30 A0 B3 00 30 80 E5 01 00 A0 E3 08 D0 8D E2 F0 8F BD E8 00 00 58 E3 30 50 A0 13 BC FF FF 1A BA FF FF EA 00 00 5B E3 14 30 94 E5 07 00 00 1A 00 00 58 E3 05 00 00 0A 3B 00 53 E3 00 20 A0 D3 01 20 A0 C3 03 60 89 E0 02 60 86 E0 DB FF FF EA 00 00 5A E3 00 20 A0 13 F6 FF FF 0A 03 60 89 E0 02 60 86 E0 D5 FF FF EA 14 60 94 E5 06 60 89 E0 D2 FF FF EA 1F 85 EB 51 ?? ?? ?? ?? 93 24 49 92 }
	condition:
		$1
}

rule file_54_1_0 {
	meta:
		name = "_mktm_r"
		size = 1380
		refs = "0010 __gettzinfo 01e4 __tz_lock 020c __tzcalc_limits 0370 __tz_unlock 050c __modsi3 0560 _daylight"
	strings:
		$1 = { F0 47 2D E9 02 70 A0 E1 00 50 A0 E1 01 40 A0 E1 ?? ?? ?? ?? 00 10 95 E5 28 35 9F E5 91 23 C3 E0 C1 2F A0 E1 01 30 83 E0 43 38 62 E0 03 21 83 E0 02 21 83 E0 02 22 83 E0 82 20 83 E0 82 23 51 E0 00 80 A0 E1 04 00 00 5A 15 2A 82 E2 06 2D 82 E2 00 00 52 E3 01 30 43 E2 FA FF FF BA 15 1A A0 E3 5F 1F 81 E2 03 10 81 E2 01 00 52 E1 04 00 00 DA 15 2A 42 E2 06 2D 42 E2 01 00 52 E1 01 30 83 E2 FA FF FF CA C0 04 9F E5 92 60 C0 E0 C2 1F A0 E1 02 00 80 E0 C0 05 61 E0 80 11 60 E0 81 12 80 E0 A8 94 9F E5 01 22 42 E0 92 19 C9 E0 A0 14 9F E5 04 C0 83 E2 9C 61 C1 E0 CC AF A0 E1 0C 10 81 E0 41 11 6A E0 02 90 89 E0 C2 6F A0 E1 81 11 61 E0 0C 10 61 E0 C9 62 66 E0 00 00 51 E3 06 A3 A0 E1 18 10 84 E5 06 C1 4A E0 07 10 81 B2 02 20 6C E0 18 10 84 B5 00 00 53 E3 00 20 84 E5 08 00 84 E5 04 60 84 E5 9C 00 00 BA 7B AE A0 E3 44 04 9F E5 44 C4 9F E5 02 A0 8A E2 01 00 00 EA 03 30 62 E0 01 A0 8A E2 03 00 1A E3 CA 2F A0 E1 06 00 00 1A 9C 6A C1 E0 C1 12 62 E0 01 11 81 E0 01 11 81 E0 01 01 5A E1 01 10 A0 13 06 00 00 1A 9C 6A C1 E0 C1 23 62 E0 02 21 82 E0 02 21 82 E0 02 02 5A E1 00 10 A0 13 01 10 A0 03 01 21 80 E0 60 20 92 E5 02 00 53 E1 E8 FF FF AA 76 2E 4A E2 0C 20 42 E2 14 20 84 E5 00 20 A0 E3 81 60 A0 E1 10 20 84 E5 1C 30 84 E5 01 60 86 E0 06 12 90 E7 01 00 53 E1 06 62 80 E0 06 00 00 BA 01 20 A0 E3 10 20 84 E5 03 30 61 E0 02 11 96 E7 03 00 51 E1 01 20 82 E2 F9 FF FF DA 01 30 83 E2 00 00 57 E3 0C 30 84 E5 00 30 A0 13 20 30 84 15 01 00 00 0A 04 00 A0 E1 F0 87 BD E8 ?? ?? ?? ?? 70 33 9F E5 00 30 93 E5 00 00 53 E3 20 70 84 05 18 00 00 0A 04 30 98 E5 0A 00 53 E1 05 00 00 0A 0A 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 00 30 E0 03 20 30 84 05 0F 00 00 0A 00 30 98 E5 00 00 53 E3 99 00 00 0A 00 30 95 E5 1C 20 98 E5 02 00 53 E1 06 00 00 BA 38 20 98 E5 02 00 53 E1 03 00 00 AA 01 30 A0 E3 20 30 84 E5 3C 20 98 E5 02 00 00 EA 00 30 A0 E3 20 30 84 E5 20 20 98 E5 E0 12 9F E5 92 31 C1 E0 C2 3F A0 E1 02 10 81 E0 C1 35 63 E0 03 10 A0 E1 83 31 63 E0 83 32 81 E0 C4 02 9F E5 03 32 42 E0 93 20 C0 E0 C3 2F A0 E1 03 00 80 E0 C0 22 62 E0 02 03 A0 E1 02 01 40 E0 00 E0 94 E5 03 30 60 E0 04 C0 94 E5 08 00 94 E5 0E 30 63 E0 0C 20 62 E0 00 10 61 E0 3B 00 53 E3 00 30 84 E5 04 20 84 E5 08 10 84 E5 44 00 00 CA 00 00 53 E3 01 20 42 B2 3C 30 83 B2 00 30 84 B5 04 20 84 B5 3B 00 52 E3 43 00 00 DA 04 30 94 E5 01 10 81 E2 3C 30 43 E2 17 00 51 E3 04 30 84 E5 08 10 84 E5 44 00 00 DA 18 30 94 E5 1C 20 94 E5 01 30 83 E2 06 00 53 E3 18 30 84 E5 01 20 82 E2 00 30 A0 C3 18 30 84 C5 1C 20 84 E5 08 20 84 E2 0C 00 92 E8 01 30 83 E2 18 20 42 E2 08 20 84 E5 0C 30 84 E5 10 10 94 E5 01 21 96 E7 02 00 53 E1 05 00 00 DA 01 10 81 E2 03 30 62 E0 0C 00 51 E3 0C 30 84 E5 10 10 84 E5 55 00 00 0A ?? ?? ?? ?? 04 00 A0 E1 F0 87 BD E8 7B AE A0 E3 D0 01 9F E5 D0 C1 9F E5 02 A0 8A E2 01 A0 4A E2 03 00 1A E3 CA 2F A0 E1 06 00 00 1A 9C 6A C1 E0 C1 12 62 E0 01 11 81 E0 01 11 81 E0 01 01 5A E1 01 10 A0 13 06 00 00 1A 9C 6A C1 E0 C1 23 62 E0 02 21 82 E0 02 21 82 E0 02 02 5A E1 00 10 A0 13 01 10 A0 03 01 21 80 E0 60 20 92 E5 02 30 93 E0 E9 FF FF 4A 63 FF FF EA 01 20 82 E2 3C 30 43 E2 3B 00 52 E3 00 30 84 E5 04 20 84 E5 BB FF FF CA 00 00 52 E3 04 30 94 B5 01 10 41 B2 3C 30 83 B2 04 30 84 B5 08 10 84 B5 17 00 51 E3 BA FF FF CA 00 00 51 E3 D1 FF FF AA 18 30 94 E5 01 30 43 E2 00 00 53 E3 1C 20 94 E5 18 30 84 E5 06 30 A0 B3 01 20 42 E2 18 30 84 B5 0C 30 94 E5 1C 20 84 E5 08 20 94 E5 01 30 43 E2 18 20 82 E2 00 00 53 E3 08 20 84 E5 0C 30 84 E5 C0 FF FF 1A 10 30 94 E5 01 30 43 E2 00 00 53 E3 10 30 84 E5 03 31 A0 A1 18 00 00 BA 03 30 96 E7 0C 30 84 E5 ?? ?? ?? ?? B7 FF FF EA 00 30 95 E5 1C 20 98 E5 02 00 53 E1 68 FF FF AA 38 20 98 E5 02 00 53 E1 00 30 A0 A3 01 30 A0 B3 01 00 53 E3 20 30 84 E5 67 FF FF 1A 3C 20 98 E5 66 FF FF EA 14 20 94 E5 00 30 A0 E3 01 20 82 E2 14 20 84 E5 1C 30 84 E5 10 30 84 E5 ?? ?? ?? ?? A2 FF FF EA 14 50 94 E5 01 50 45 E2 0B 30 A0 E3 03 00 15 E3 10 30 84 E5 14 50 84 E5 06 00 00 1A 05 00 A0 E1 64 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 5B 3F A0 13 02 30 83 12 06 00 00 1A 05 00 A0 E1 19 1E A0 E3 ?? ?? ?? ?? 01 30 70 E2 00 30 A0 33 5B 3F 83 E2 01 30 83 E2 1C 30 84 E5 2C 30 A0 E3 CE FF FF EA 07 45 2E C2 C5 B3 A2 91 89 88 88 88 93 24 49 92 ?? ?? ?? ?? 1F 85 EB 51 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_56_0_0 {
	meta:
		name = "strcasecmp"
		size = 160
		refs = "009c __ctype_ptr__"
	strings:
		$1 = { F0 00 2D E9 00 30 D0 E5 00 00 53 E3 1A 00 00 0A 84 20 9F E5 00 C0 92 E5 03 00 00 EA 01 30 F0 E5 00 00 53 E3 01 10 81 E2 15 00 00 0A 03 20 8C E0 01 20 D2 E5 01 70 12 E2 00 20 D1 E5 01 40 82 E2 04 40 DC E7 03 60 A0 01 20 60 83 12 01 00 14 E3 02 50 A0 01 20 50 82 12 05 00 56 E1 EE FF FF 0A 00 00 57 E3 20 30 83 12 01 00 14 E3 20 20 82 12 03 00 62 E0 F0 00 BD E8 1E FF 2F E1 18 20 9F E5 00 C0 92 E5 00 20 D1 E5 01 70 DC E5 01 40 82 E2 04 40 DC E7 01 70 07 E2 F0 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_0_0 {
	meta:
		name = "putwchar"
		size = 20
		refs = "000c fputwc 0010 _impure_ptr"
	strings:
		$1 = { 08 30 9F E5 00 30 93 E5 08 10 93 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_1_0 {
	meta:
		name = "_putwchar_r"
		size = 20
		refs = "000c _fputwc_r 0010 _impure_ptr"
	strings:
		$1 = { 08 30 9F E5 00 30 93 E5 08 20 93 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_59_0_0 {
	meta:
		name = "ldexpf"
		size = 120
		refs = "000c finitef 0020 __eqsf2 003c scalbnf 0064 __errno"
	strings:
		$1 = { 30 40 2D E9 01 50 A0 E1 00 40 A0 E1 ?? ?? ?? ?? 00 00 50 E3 04 00 00 0A 04 00 A0 E1 00 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 01 00 00 1A 04 00 A0 E1 30 80 BD E8 05 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 ?? ?? ?? ?? 00 00 50 E3 04 00 00 0A 04 00 A0 E1 00 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 F1 FF FF 1A ?? ?? ?? ?? 22 30 A0 E3 00 30 80 E5 04 00 A0 E1 30 80 BD E8 }
	condition:
		$1
}

rule file_60_0_0 {
	meta:
		name = "argz_add_sep"
		size = 132
		refs = "0030 argz_create_sep 0058 realloc 0078 memcpy"
	strings:
		$1 = { F0 40 2D E9 00 40 A0 E3 08 D0 4D E2 00 40 8D E5 01 50 A0 E1 00 60 A0 E1 03 10 A0 E1 02 00 A0 E1 0D 30 A0 E1 04 20 8D E2 04 40 8D E5 00 70 95 E5 ?? ?? ?? ?? 00 00 9D E5 04 00 50 E1 01 00 00 1A 08 D0 8D E2 F0 80 BD E8 00 10 95 E5 01 10 80 E0 00 10 85 E5 00 00 96 E5 ?? ?? ?? ?? 04 00 50 E1 00 00 86 E5 0C 00 A0 03 F4 FF FF 0A 07 00 80 E0 04 10 9D E5 00 20 9D E5 ?? ?? ?? ?? 04 00 A0 E1 EE FF FF EA }
	condition:
		$1
}

rule file_62_0_0 {
	meta:
		name = "argz_delete"
		size = 132
		refs = "0018 strlen 0038 memmove 004c realloc 0074 free"
	strings:
		$1 = { F0 40 2D E9 00 60 52 E2 00 50 A0 E1 01 40 A0 E1 15 00 00 0A 06 00 A0 E1 ?? ?? ?? ?? 00 30 94 E5 00 20 95 E5 01 70 80 E2 07 10 86 E0 03 20 82 E0 02 20 61 E0 06 00 A0 E1 ?? ?? ?? ?? 00 10 94 E5 01 10 67 E0 00 10 84 E5 00 00 95 E5 ?? ?? ?? ?? 00 00 50 E3 00 00 85 E5 0C 00 A0 03 F0 80 BD 08 00 40 94 E5 00 00 54 E3 01 00 00 0A 00 00 A0 E3 F0 80 BD E8 ?? ?? ?? ?? 00 40 85 E5 04 00 A0 E1 F0 80 BD E8 }
	condition:
		$1
}

rule file_63_0_0 {
	meta:
		name = "_remove_r"
		size = 20
		refs = "0004 _unlink_r"
	strings:
		$1 = { 04 E0 2D E5 ?? ?? ?? ?? 01 00 70 E3 00 00 A0 13 04 F0 9D E4 }
	condition:
		$1
}

rule file_64_0_0 {
	meta:
		name = "_malloc_r"
		size = 1844
		refs = "0044 __malloc_lock 0094 __malloc_unlock 03fc _sbrk_r 0708 _free_r"
	strings:
		$1 = { F0 4F 2D E9 0B 40 81 E2 16 00 54 E3 07 40 C4 83 00 30 A0 93 A4 3F A0 81 10 40 A0 93 01 00 54 E1 03 10 A0 21 01 10 83 33 00 00 51 E3 0C 30 A0 13 04 D0 4D E2 00 50 A0 E1 00 30 80 15 00 80 A0 13 15 00 00 1A ?? ?? ?? ?? 7E 0F 54 E3 15 00 00 2A D4 66 9F E5 A4 A1 A0 E1 8A 31 86 E0 0C 80 93 E5 03 00 58 E1 66 01 00 0A 04 10 98 E5 03 10 C1 E3 01 10 88 E0 04 00 91 E5 0C 20 98 E5 08 30 98 E5 01 00 80 E3 04 00 81 E5 08 30 82 E5 0C 20 83 E5 05 00 A0 E1 ?? ?? ?? ?? 08 80 88 E2 08 00 A0 E1 04 D0 8D E2 F0 8F BD E8 A4 A4 B0 E1 A4 A1 A0 01 8A 11 A0 01 60 00 00 1A 6C 66 9F E5 01 10 86 E0 0C 70 91 E5 07 00 51 E1 05 00 00 1A 0A 00 00 EA 00 00 53 E3 22 01 00 AA 0C 70 97 E5 07 00 51 E1 05 00 00 0A 04 20 97 E5 03 20 C2 E3 02 30 64 E0 0F 00 53 E3 F5 FF FF DA 01 A0 4A E2 01 A0 8A E2 24 76 9F E5 08 30 87 E2 08 80 93 E5 08 00 53 E1 9B 00 00 0A 04 10 98 E5 03 10 C1 E3 01 20 64 E0 0F 00 52 E3 24 01 00 CA 00 00 52 E3 0C 30 83 E5 08 30 83 E5 5C 00 00 AA 02 0C 51 E3 62 00 00 2A 04 00 97 E5 A1 11 A0 E1 41 21 A0 E1 01 C0 A0 E3 81 11 87 E0 1C 22 80 E1 08 00 91 E5 0C 10 88 E5 08 00 88 E5 01 C0 A0 E3 08 80 81 E5 4A 11 A0 E1 1C C1 A0 E1 02 00 5C E1 0C 80 80 E5 04 20 87 E5 85 00 00 8A 0C 00 12 E1 08 00 00 1A 8C C0 A0 E1 03 A0 CA E3 0C 00 12 E1 04 A0 8A E2 03 00 00 1A 8C C0 A0 E1 02 00 1C E1 04 A0 8A E2 FB FF FF 0A 8A 91 87 E0 09 E0 A0 E1 0A 80 A0 E1 0C 20 9E E5 02 00 5E E1 05 00 00 1A 08 01 00 EA 00 00 51 E3 11 01 00 AA 0C 20 92 E5 02 00 5E E1 03 01 00 0A 04 00 92 E5 03 00 C0 E3 00 10 64 E0 0F 00 51 E3 F5 FF FF DA 02 80 A0 E1 08 00 B8 E5 0C C0 92 E5 01 60 84 E3 01 E0 81 E3 04 40 82 E0 08 00 8C E5 0C C0 80 E5 04 60 82 E5 08 40 83 E5 0C 40 83 E5 01 10 84 E7 04 E0 84 E5 08 30 84 E5 05 00 A0 E1 0C 30 84 E5 ?? ?? ?? ?? 97 FF FF EA 04 00 5A E3 24 A3 A0 91 38 A0 8A 92 8A 11 A0 91 99 FF FF 9A 14 00 5A E3 5B A0 8A 92 8A 11 A0 91 95 FF FF 9A 54 00 5A E3 24 A6 A0 91 6E A0 8A 92 8A 11 A0 91 90 FF FF 9A 55 0F 5A E3 A4 A7 A0 91 77 A0 8A 92 8A 11 A0 91 8B FF FF 9A 55 3E A0 E3 04 30 83 E2 03 00 5A E1 24 A9 A0 91 7C A0 8A 92 3F 1E A0 83 7E A0 A0 83 8A 11 A0 91 82 FF FF EA 01 10 88 E0 04 30 91 E5 01 30 83 E3 04 30 81 E5 05 00 A0 E1 ?? ?? ?? ?? 08 80 88 E2 73 FF FF EA A1 24 A0 E1 04 00 52 E3 21 03 A0 91 38 00 80 92 80 C1 A0 91 15 00 00 9A 14 00 52 E3 5B 00 82 92 80 C1 A0 91 11 00 00 9A 54 00 52 E3 21 06 A0 91 6E 00 80 92 80 C1 A0 91 0C 00 00 9A 55 0F 52 E3 A1 07 A0 91 77 00 80 92 80 C1 A0 91 07 00 00 9A 55 0E A0 E3 04 00 80 E2 00 00 52 E1 21 09 A0 91 7C 00 80 92 3F CE A0 83 7E 00 A0 83 80 C1 A0 91 0C C0 86 E0 08 20 9C E5 0C 00 52 E1 DC 73 9F E5 03 00 00 1A DA 00 00 EA 08 20 92 E5 02 00 5C E1 03 00 00 0A 04 00 92 E5 03 00 C0 E3 00 00 51 E1 F8 FF FF 3A 0C 10 92 E5 0C 10 88 E5 08 20 88 E5 0C 80 82 E5 08 80 81 E5 4A 11 A0 E1 01 C0 A0 E3 1C C1 A0 E1 04 20 97 E5 02 00 5C E1 79 FF FF 9A 08 A0 97 E5 04 80 9A E5 03 80 C8 E3 08 00 54 E1 00 30 A0 93 01 30 A0 83 08 20 64 E0 0F 00 52 E3 01 30 83 D3 00 00 53 E3 0A 90 A0 01 71 00 00 0A 5C B3 9F E5 00 90 9B E5 08 34 96 E5 10 90 89 E2 01 00 73 E3 04 90 89 E0 FF 9E 89 12 0F 90 89 12 FF 9E C9 13 0F 90 C9 13 05 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 01 00 70 E3 00 30 A0 E1 A2 00 00 0A 08 10 8A E0 00 00 51 E1 9D 00 00 8A 04 20 9B E5 00 00 51 E1 02 20 89 E0 04 20 8B E5 AB 00 00 0A 08 C4 96 E5 01 00 7C E3 02 20 80 10 EC 22 9F 05 02 10 61 10 08 04 82 05 04 10 8B 15 07 60 10 E2 08 60 66 12 06 30 80 10 09 20 83 E0 02 2A A0 E1 01 6A A0 03 01 6A 86 12 22 2A A0 E1 06 60 62 E0 06 10 A0 E1 05 00 A0 E1 00 30 8D E5 ?? ?? ?? ?? 00 30 9D E5 01 00 70 E3 00 10 63 10 04 20 9B E5 06 10 81 10 00 60 A0 03 01 10 A0 03 01 10 81 13 02 20 86 E0 07 00 5A E1 03 90 A0 E1 04 10 83 E5 04 20 8B E5 08 30 87 E5 10 00 00 0A 0F 00 58 E3 01 30 A0 93 04 30 89 95 00 20 A0 93 19 00 00 9A 0C 10 48 E2 07 10 C1 E3 01 00 8A E0 05 C0 A0 E3 08 C0 80 E5 04 C0 80 E5 04 00 9A E5 01 00 00 E2 0F 00 51 E3 00 10 81 E1 04 10 8A E5 80 00 00 8A 2C 10 9B E5 01 00 52 E1 24 12 9F 85 2C 20 81 85 30 10 9B E5 01 00 52 E1 03 90 A0 91 03 90 A0 81 04 30 99 85 04 20 99 95 04 12 9F 85 03 20 C2 93 30 20 81 85 03 20 C3 83 02 00 54 E1 00 30 A0 93 01 30 A0 83 02 20 64 E0 0F 00 52 E3 01 30 83 D3 00 00 53 E3 0F 00 00 0A 05 00 A0 E1 ?? ?? ?? ?? 00 80 A0 E3 CD FE FF EA 02 20 87 E0 04 00 92 E5 0C 10 97 E5 08 30 97 E5 01 00 80 E3 04 00 82 E5 08 30 81 E5 0C 10 83 E5 05 00 A0 E1 ?? ?? ?? ?? 08 80 87 E2 C1 FE FF EA 04 30 89 E0 01 20 82 E3 01 40 84 E3 04 40 89 E5 05 00 A0 E1 04 20 83 E5 08 30 87 E5 ?? ?? ?? ?? 08 80 89 E2 B7 FE FF EA 01 00 84 E3 01 10 82 E3 04 40 88 E0 04 00 88 E5 0C 40 83 E5 08 40 83 E5 02 20 84 E7 0A 00 84 E9 0C 30 84 E5 05 00 A0 E1 ?? ?? ?? ?? 08 80 88 E2 AA FE FF EA 01 80 88 E2 03 00 18 E3 14 00 00 0A 08 E0 82 E2 ED FE FF EA 08 30 88 E2 0C 80 93 E5 08 00 53 E1 02 A0 8A 02 B9 FE FF 0A 92 FE FF EA 00 00 82 E0 02 80 A0 E1 04 10 90 E5 0C 20 92 E5 08 30 B8 E5 01 10 81 E3 04 10 80 E5 08 30 82 E5 0C 20 83 E5 05 00 A0 E1 ?? ?? ?? ?? 93 FE FF EA 01 A0 4A E2 03 00 1A E3 09 20 A0 E1 2F 00 00 0A 08 90 12 E4 02 00 59 E1 F8 FF FF 0A 04 20 97 E5 8C C0 A0 E1 02 00 5C E1 48 FF FF 8A 00 00 5C E3 46 FF FF 0A 0C 00 12 E1 07 00 00 0A 08 A0 A0 E1 C7 FE FF EA 07 00 5A E1 5F FF FF 0A 08 90 97 E5 04 20 99 E5 03 20 C2 E3 A2 FF FF EA 8C C0 A0 E1 02 00 1C E1 04 80 88 E2 FB FF FF 0A 08 A0 A0 E1 BB FE FF EA 04 C0 97 E5 40 01 A0 E1 01 10 A0 E3 11 10 8C E1 04 10 87 E5 02 10 A0 E1 25 FF FF EA 01 CA A0 E1 2C CA A0 E1 00 00 5C E3 4F FF FF 1A 08 10 89 E0 08 30 97 E5 01 10 81 E3 04 10 83 E5 7E FF FF EA 08 10 8A E2 05 00 A0 E1 ?? ?? ?? ?? 1C 30 9F E5 04 20 93 E5 08 30 97 E5 77 FF FF EA 04 20 97 E5 0C 20 C2 E1 04 20 87 E5 CF FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_65_0_0 {
	meta:
		name = "tdelete"
		size = 248
		refs = "00d8 free"
	strings:
		$1 = { F0 40 2D E9 00 40 51 E2 00 50 A0 E1 02 70 A0 E1 01 00 00 1A 00 00 A0 E3 F0 80 BD E8 00 60 94 E5 00 00 56 E3 06 30 A0 11 08 00 00 1A F8 FF FF EA 00 60 94 E5 04 30 96 B5 08 30 96 A5 04 40 86 B2 08 40 86 A2 00 00 53 E3 F1 FF FF 0A 00 30 94 E5 00 10 93 E5 05 00 A0 E1 0F E0 A0 E1 17 FF 2F E1 00 00 50 E3 F1 FF FF 1A 00 00 94 E5 04 50 90 E5 08 10 90 E5 00 00 55 E3 01 50 A0 01 15 00 00 0A 00 00 51 E3 13 00 00 0A 04 30 91 E5 00 00 53 E3 03 50 A0 11 02 00 00 1A 12 00 00 EA 03 50 A0 E1 02 10 A0 E1 04 30 95 E5 00 00 53 E3 05 20 A0 E1 F9 FF FF 1A 08 30 95 E5 04 30 81 E5 00 30 94 E5 04 30 93 E5 04 30 85 E5 00 30 94 E5 08 30 93 E5 08 30 85 E5 00 00 94 E5 ?? ?? ?? ?? 00 50 84 E5 06 00 A0 E1 F0 80 BD E8 04 50 81 E5 01 50 A0 E1 00 00 94 E5 F7 FF FF EA }
	condition:
		$1
}

rule file_66_0_0 {
	meta:
		name = "iswspace"
		size = 36
		refs = "0020 __ctype_ptr__"
	strings:
		$1 = { FF 00 50 E3 14 30 9F 95 00 30 93 95 00 00 83 90 01 00 D0 95 00 00 A0 83 08 00 00 92 1E FF 2F E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_67_0_0 {
	meta:
		name = "__adjust"
		size = 216
		refs = "0068 __exp10 007c __muldf3 00c8 __divdf3"
	strings:
		$1 = { 4D 0F 52 E3 30 40 2D E9 0C 00 00 DA 02 41 A0 E3 7F 24 A0 E3 22 10 A0 E3 00 00 53 E3 C4 45 A0 E1 0F 26 82 E2 00 10 80 E5 02 40 A0 01 03 50 A0 01 00 50 A0 13 04 00 A0 E1 05 10 A0 E1 30 80 BD E8 4D 0F 72 E3 12 00 00 BA 00 40 91 E5 00 00 53 E3 02 41 84 12 00 00 52 E3 04 50 91 E5 F4 FF FF 0A 12 00 00 BA 02 00 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 04 00 A0 E1 05 10 A0 E1 30 80 BD E8 00 40 A0 E3 22 30 A0 E3 04 50 A0 E1 00 30 80 E5 05 10 A0 E1 04 00 A0 E1 30 80 BD E8 00 00 62 E2 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 D6 FF FF EA }
	condition:
		$1
}

rule file_68_0_0 {
	meta:
		name = "_mblen_r"
		size = 44
	strings:
		$1 = { 00 00 51 E3 02 00 00 0A 00 30 D1 E5 00 00 53 E3 01 00 00 1A 00 00 A0 E3 1E FF 2F E1 00 00 52 E3 00 00 E0 03 01 00 A0 13 1E FF 2F E1 }
	condition:
		$1
}

rule file_71_0_0 {
	meta:
		name = "_fputs_r"
		size = 136
		refs = "0018 strlen 0070 __sfvwrite_r 0080 __sinit"
	strings:
		$1 = { 30 40 2D E9 00 40 A0 E1 14 D0 4D E2 01 00 A0 E1 02 50 A0 E1 0C 10 8D E5 ?? ?? ?? ?? 0C 30 8D E2 00 30 8D E5 00 00 54 E3 01 30 A0 E3 10 00 8D E5 04 30 8D E5 08 00 8D E5 02 00 00 0A 38 30 94 E5 00 00 53 E3 0C 00 00 0A BC 30 D5 E1 02 0A 13 E3 64 20 95 05 02 3A 83 03 02 2A C2 03 64 20 85 05 BC 30 C5 01 04 00 A0 E1 05 10 A0 E1 0D 20 A0 E1 ?? ?? ?? ?? 14 D0 8D E2 30 80 BD E8 04 00 A0 E1 ?? ?? ?? ?? EF FF FF EA }
	condition:
		$1
}

rule file_72_0_0 {
	meta:
		name = "_findenv_r"
		size = 220
		refs = "0014 __env_lock 006c strncmp 009c __env_unlock 00d8 environ"
	strings:
		$1 = { F0 47 2D E9 CC 70 9F E5 01 60 A0 E1 02 A0 A0 E1 00 80 A0 E1 ?? ?? ?? ?? 00 40 97 E5 00 00 54 E3 28 00 00 0A 00 30 D6 E5 3D 00 53 E3 00 00 53 13 06 50 A0 01 04 00 00 0A 06 50 A0 E1 01 30 F5 E5 3D 00 53 E3 00 00 53 13 FB FF FF 1A 3D 00 53 E3 10 00 00 0A 00 00 94 E5 00 00 50 E3 0D 00 00 0A 05 50 66 E0 06 10 A0 E1 05 20 A0 E1 ?? ?? ?? ?? 00 00 50 E3 04 00 00 1A 00 90 94 E5 05 30 D9 E7 3D 00 53 E3 05 90 89 E0 06 00 00 0A 04 00 B4 E5 00 00 50 E3 F2 FF FF 1A 08 00 A0 E1 ?? ?? ?? ?? 00 00 A0 E3 F0 87 BD E8 00 30 97 E5 04 40 63 E0 44 41 A0 E1 08 00 A0 E1 00 40 8A E5 ?? ?? ?? ?? 01 00 89 E2 F0 87 BD E8 08 00 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 F0 87 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_72_1_0 {
	meta:
		name = "_getenv_r"
		size = 24
		refs = "000c _findenv_r"
	strings:
		$1 = { 04 E0 2D E5 04 D0 4D E2 0D 20 A0 E1 ?? ?? ?? ?? 04 D0 8D E2 00 80 BD E8 }
	condition:
		$1
}

rule file_76_0_0 {
	meta:
		name = "__register_exitproc"
		size = 228
		refs = "00a4 malloc 00e0 _global_impure_ptr"
	strings:
		$1 = { D8 C0 9F E5 F0 40 2D E9 00 50 9C E5 48 C1 95 E5 00 00 5C E3 53 CF 85 02 00 40 A0 E1 04 00 9C E5 48 C1 85 05 1F 00 50 E3 0C D0 4D E2 18 00 00 CA 00 00 54 E3 06 00 00 1A 01 30 80 E2 04 30 8C E5 02 00 80 E2 00 11 8C E7 00 00 A0 E3 0C D0 8D E2 F0 80 BD E8 04 50 9C E5 01 60 A0 E3 16 65 A0 E1 88 71 9C E5 02 00 54 E3 06 40 87 E1 42 70 85 E2 07 31 8C E7 8C 31 9C 05 22 00 80 E2 06 60 83 01 00 21 8C E7 88 41 8C E5 8C 61 8C 05 05 00 A0 E1 E8 FF FF EA 19 0E A0 E3 08 10 8D E5 04 20 8D E5 00 30 8D E5 ?? ?? ?? ?? 00 C0 50 E2 08 10 9D E5 04 20 9D E5 00 30 9D E5 00 00 E0 03 E2 FF FF 0A 48 61 95 E5 00 00 A0 E3 00 60 8C E5 04 00 8C E5 48 C1 85 E5 88 01 8C E5 8C 01 8C E5 D3 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_77_0_0 {
	meta:
		name = "argz_insert"
		size = 244
		refs = "0070 strlen 0084 realloc 00ac memmove 00c0 memcpy 00f0 argz_add"
	strings:
		$1 = { 00 00 52 E3 F0 41 2D E9 03 70 A0 E1 00 40 A0 E1 01 50 A0 E1 33 00 00 0A 00 80 90 E5 08 00 52 E1 2C 00 00 3A 00 30 91 E5 03 30 88 E0 03 00 52 E1 28 00 00 2A 08 00 52 E1 0A 00 00 0A 01 30 52 E5 00 00 53 E3 01 30 42 E2 03 00 00 1A 23 00 00 EA 01 10 73 E5 00 00 51 E3 20 00 00 0A 03 00 58 E1 03 20 A0 E1 F9 FF FF 1A 00 80 A0 E3 07 00 A0 E1 ?? ?? ?? ?? 00 10 95 E5 01 60 80 E2 01 10 86 E0 00 00 94 E5 ?? ?? ?? ?? 00 00 50 E3 00 00 84 E5 0C 00 A0 03 F0 81 BD 08 00 20 95 E5 06 30 88 E0 08 10 80 E0 02 20 68 E0 03 00 80 E0 ?? ?? ?? ?? 00 00 94 E5 06 20 A0 E1 08 00 80 E0 07 10 A0 E1 ?? ?? ?? ?? 00 30 95 E5 06 60 83 E0 00 60 85 E5 00 00 A0 E3 F0 81 BD E8 16 00 A0 E3 F0 81 BD E8 02 80 68 E0 E0 FF FF EA 03 20 A0 E1 F0 41 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_78_0_0 {
	meta:
		name = "ctime_r"
		size = 36
		refs = "0010 localtime_r 0018 asctime_r"
	strings:
		$1 = { 10 40 2D E9 24 D0 4D E2 01 40 A0 E1 0D 10 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 24 D0 8D E2 10 80 BD E8 }
	condition:
		$1
}

rule file_79_0_0 {
	meta:
		name = "btowc"
		size = 108
		refs = "0020 memset 003c _mbtowc_r 0068 _impure_ptr"
	strings:
		$1 = { 30 40 2D E9 14 D0 4D E2 04 50 8D E2 00 40 A0 E1 00 10 A0 E3 08 20 A0 E3 05 00 A0 E1 13 40 CD E5 ?? ?? ?? ?? 3C 30 9F E5 0C 10 8D E2 00 00 93 E5 13 20 8D E2 01 30 A0 E3 00 50 8D E5 ?? ?? ?? ?? 01 00 74 E3 00 40 A0 13 01 40 A0 03 01 00 50 E3 01 40 84 13 00 00 54 E3 00 00 E0 13 0C 00 9D 05 14 D0 8D E2 30 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_80_0_0 {
	meta:
		name = "argz_stringify"
		size = 48
	strings:
		$1 = { 01 00 51 E3 1E FF 2F 91 01 10 51 E2 1E FF 2F 01 00 30 A0 E3 03 C0 D0 E7 00 00 5C E3 03 20 C0 07 01 30 83 E2 01 00 53 E1 F9 FF FF 3A 1E FF 2F E1 }
	condition:
		$1
}

rule file_81_0_0 {
	meta:
		name = "strerror"
		size = 1668
		refs = "050c _user_strerror"
	strings:
		$1 = { 01 30 40 E2 04 E0 2D E5 8D 00 53 E3 03 F1 9F 97 3D 01 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? CC 02 9F E5 04 F0 9D E4 C8 02 9F E5 04 F0 9D E4 C4 02 9F E5 04 F0 9D E4 C0 02 9F E5 04 F0 9D E4 BC 02 9F E5 04 F0 9D E4 B8 02 9F E5 04 F0 9D E4 B4 02 9F E5 04 F0 9D E4 B0 02 9F E5 04 F0 9D E4 AC 02 9F E5 04 F0 9D E4 A8 02 9F E5 04 F0 9D E4 A4 02 9F E5 04 F0 9D E4 A0 02 9F E5 04 F0 9D E4 9C 02 9F E5 04 F0 9D E4 98 02 9F E5 04 F0 9D E4 94 02 9F E5 04 F0 9D E4 90 02 9F E5 04 F0 9D E4 8C 02 9F E5 04 F0 9D E4 88 02 9F E5 04 F0 9D E4 84 02 9F E5 04 F0 9D E4 80 02 9F E5 04 F0 9D E4 7C 02 9F E5 04 F0 9D E4 78 02 9F E5 04 F0 9D E4 74 02 9F E5 04 F0 9D E4 70 02 9F E5 04 F0 9D E4 6C 02 9F E5 04 F0 9D E4 68 02 9F E5 04 F0 9D E4 64 02 9F E5 04 F0 9D E4 60 02 9F E5 04 F0 9D E4 5C 02 9F E5 04 F0 9D E4 58 02 9F E5 04 F0 9D E4 54 02 9F E5 04 F0 9D E4 50 02 9F E5 04 F0 9D E4 4C 02 9F E5 04 F0 9D E4 48 02 9F E5 04 F0 9D E4 44 02 9F E5 04 F0 9D E4 40 02 9F E5 04 F0 9D E4 3C 02 9F E5 04 F0 9D E4 38 02 9F E5 04 F0 9D E4 34 02 9F E5 04 F0 9D E4 30 02 9F E5 04 F0 9D E4 2C 02 9F E5 04 F0 9D E4 28 02 9F E5 04 F0 9D E4 24 02 9F E5 04 F0 9D E4 20 02 9F E5 04 F0 9D E4 1C 02 9F E5 04 F0 9D E4 18 02 9F E5 04 F0 9D E4 14 02 9F E5 04 F0 9D E4 10 02 9F E5 04 F0 9D E4 0C 02 9F E5 04 F0 9D E4 08 02 9F E5 04 F0 9D E4 04 02 9F E5 04 F0 9D E4 00 02 9F E5 04 F0 9D E4 FC 01 9F E5 04 F0 9D E4 F8 01 9F E5 04 F0 9D E4 F4 01 9F E5 04 F0 9D E4 F0 01 9F E5 04 F0 9D E4 EC 01 9F E5 04 F0 9D E4 E8 01 9F E5 04 F0 9D E4 E4 01 9F E5 04 F0 9D E4 E0 01 9F E5 04 F0 9D E4 DC 01 9F E5 04 F0 9D E4 D8 01 9F E5 04 F0 9D E4 D4 01 9F E5 04 F0 9D E4 D0 01 9F E5 04 F0 9D E4 CC 01 9F E5 04 F0 9D E4 C8 01 9F E5 04 F0 9D E4 C4 01 9F E5 04 F0 9D E4 C0 01 9F E5 04 F0 9D E4 BC 01 9F E5 04 F0 9D E4 B8 01 9F E5 04 F0 9D E4 B4 01 9F E5 04 F0 9D E4 B0 01 9F E5 04 F0 9D E4 AC 01 9F E5 04 F0 9D E4 A8 01 9F E5 04 F0 9D E4 A4 01 9F E5 04 F0 9D E4 A0 01 9F E5 04 F0 9D E4 9C 01 9F E5 04 F0 9D E4 98 01 9F E5 04 F0 9D E4 94 01 9F E5 04 F0 9D E4 90 01 9F E5 04 F0 9D E4 8C 01 9F E5 04 F0 9D E4 88 01 9F E5 04 F0 9D E4 84 01 9F E5 04 F0 9D E4 80 01 9F E5 04 F0 9D E4 7C 01 9F E5 04 F0 9D E4 78 01 9F E5 04 F0 9D E4 74 01 9F E5 04 F0 9D E4 70 01 9F E5 04 F0 9D E4 ?? ?? ?? ?? 68 31 9F E5 00 00 50 E3 03 00 A0 01 04 F0 9D E4 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_82_0_0 {
	meta:
		name = "_tmpfile_r"
		size = 164
		refs = "0014 _tmpnam_r 0038 _open_r 006c _fdopen_r 0084 _remove_r 0098 _close_r"
	strings:
		$1 = { F0 41 2D E9 00 40 A0 E1 01 DB 4D E2 0D 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 42 2B A0 E3 00 50 50 E2 02 2C 82 E2 02 20 82 E2 06 3D A0 E3 05 10 A0 E1 04 00 A0 E1 05 00 00 0A ?? ?? ?? ?? 00 70 50 E2 06 00 00 AA 00 30 94 E5 11 00 53 E3 EE FF FF 0A 00 60 A0 E3 06 00 A0 E1 01 DB 8D E2 F0 81 BD E8 04 00 A0 E1 07 10 A0 E1 30 20 9F E5 ?? ?? ?? ?? 00 60 50 E2 00 80 94 E5 04 00 00 0A 05 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 80 84 E5 F0 FF FF EA 07 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? F6 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_84_0_0 {
	meta:
		name = "asctime"
		size = 20
		refs = "000c asctime_r 0010 _impure_ptr"
	strings:
		$1 = { 08 30 9F E5 00 10 93 E5 60 10 81 E2 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_85_0_0 {
	meta:
		name = "_strtol_r"
		size = 420
		refs = "008c __umodsi3 009c __udivsi3 01a0 __ctype_ptr__"
	strings:
		$1 = { F0 4F 2D E9 01 50 A0 E1 90 11 9F E5 08 D0 4D E2 00 40 91 E5 04 00 8D E5 03 80 A0 E1 05 70 A0 E1 01 60 D7 E4 06 30 84 E0 01 B0 D3 E5 08 B0 1B E2 FA FF FF 1A 2D 00 56 E3 46 00 00 0A 2B 00 56 E3 01 60 D7 04 01 30 78 E2 00 30 A0 33 00 00 58 E3 10 00 58 13 06 00 00 1A 30 00 56 E3 47 00 00 0A 00 00 53 E3 02 00 00 0A 30 00 56 E3 08 80 A0 03 0A 80 A0 13 00 00 5B E3 02 91 A0 13 02 91 E0 03 08 10 A0 E1 09 00 A0 E1 00 20 8D E5 ?? ?? ?? ?? 08 10 A0 E1 00 A0 A0 E1 09 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E3 00 20 9D E5 01 C0 A0 E1 06 30 84 E0 01 30 D3 E5 04 00 13 E3 30 60 46 12 05 00 00 1A 03 00 13 E3 17 00 00 0A 01 00 13 E3 37 30 A0 13 57 30 A0 03 06 60 63 E0 06 00 58 E1 11 00 00 DA 00 00 5C E1 00 30 A0 93 01 30 A0 83 A1 3F 93 E1 09 00 00 1A 0A 00 56 E1 00 30 A0 D3 01 30 A0 C3 00 00 5C E1 00 30 A0 13 00 00 53 E3 98 6C 2C 00 01 10 A0 03 01 60 D7 04 E3 FF FF 0A 00 10 E0 E3 01 60 D7 E4 E0 FF FF EA 01 00 71 E3 0C 00 00 0A 00 00 5B E3 0C 00 A0 01 00 00 6C 12 00 00 52 E3 02 00 00 0A 00 00 51 E3 01 50 47 12 00 50 82 E5 08 D0 8D E2 F0 8F BD E8 01 60 D7 E4 01 B0 A0 E3 B7 FF FF EA 04 00 9D E5 00 00 5B E3 22 30 A0 E3 00 30 80 E5 02 01 A0 13 02 01 E0 03 EE FF FF EA 00 10 D7 E5 78 00 51 E3 58 00 51 13 B3 FF FF 1A 01 60 D7 E5 10 80 A0 E3 02 70 87 E2 B4 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_86_0_0 {
	meta:
		name = "error"
		size = 52
		refs = "0008 __errno"
	strings:
		$1 = { F0 40 2D E9 00 70 A0 E1 ?? ?? ?? ?? 00 60 A0 E3 00 40 A0 E1 13 50 A0 E3 05 00 A0 E1 06 10 A0 E1 56 34 12 EF 00 50 A0 E1 00 50 84 E5 07 00 A0 E1 F0 80 BD E8 }
	condition:
		$1
}

rule file_86_1_0 {
	meta:
		name = "remap_handle"
		size = 116
		refs = "0058 __sinit 006c _impure_ptr"
	strings:
		$1 = { 64 30 9F E5 00 30 93 E5 00 00 53 E3 10 40 2D E9 00 40 A0 E1 02 00 00 0A 38 20 93 E5 00 00 52 E3 0B 00 00 0A 00 00 54 E3 06 00 00 0A 01 00 54 E3 0A 00 00 0A 02 00 54 E3 30 30 9F 05 20 00 44 12 04 00 93 05 10 80 BD E8 20 30 9F E5 00 00 93 E5 10 80 BD E8 03 00 A0 E1 ?? ?? ?? ?? F0 FF FF EA 08 30 9F E5 08 00 93 E5 10 80 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_86_2_0 {
	meta:
		name = "initialise_monitor_handles"
		size = 172
	strings:
		$1 = { F0 47 2D E9 98 50 9F E5 0C D0 4D E2 03 60 A0 E3 00 A0 A0 E3 00 50 8D E5 01 80 A0 E3 08 60 8D E5 0D 70 A0 E1 04 A0 8D E5 08 00 A0 E1 07 10 A0 E1 56 34 12 EF 00 90 A0 E1 68 40 9F E5 04 30 A0 E3 00 50 8D E5 00 90 84 E5 08 60 8D E5 04 30 8D E5 08 00 A0 E1 07 10 A0 E1 56 34 12 EF 00 70 A0 E1 00 20 E0 E3 04 70 84 E5 08 70 84 E5 0C 40 84 E2 0A 20 84 E7 08 A0 8A E2 A0 00 5A E3 24 30 9F E5 FA FF FF 1A 00 10 93 E5 00 20 A0 E3 18 20 83 E5 0C 10 83 E5 14 70 83 E5 10 20 83 E5 0C D0 8D E2 F0 87 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_86_3_0 {
	meta:
		name = "_kill"
		size = 84
	strings:
		$1 = { 06 00 51 E3 30 40 2D E9 08 00 00 0A 02 48 A0 E3 26 40 84 E2 18 50 A0 E3 05 00 A0 E1 04 10 A0 E1 56 34 12 EF 00 40 A0 E1 04 00 A0 E1 30 80 BD E8 02 48 A0 E3 23 40 84 E2 18 50 A0 E3 05 00 A0 E1 04 10 A0 E1 56 34 12 EF 00 40 A0 E1 04 00 A0 E1 30 80 BD E8 }
	condition:
		$1
}

rule file_86_4_0 {
	meta:
		name = "_exit"
		size = 32
	strings:
		$1 = { 02 48 A0 E3 26 40 84 E2 18 50 A0 E3 05 00 A0 E1 04 10 A0 E1 56 34 12 EF 00 40 A0 E1 1E FF 2F E1 }
	condition:
		$1
}

rule file_86_8_0 {
	meta:
		name = "_gettimeofday"
		size = 68
	strings:
		$1 = { F0 40 2D E9 00 60 50 E2 01 40 A0 E1 06 00 00 0A 00 70 A0 E3 11 50 A0 E3 05 00 A0 E1 07 10 A0 E1 56 34 12 EF 00 50 A0 E1 A0 00 86 E8 00 00 54 E3 00 30 A0 13 04 30 84 15 00 30 84 15 00 00 A0 E3 F0 80 BD E8 }
	condition:
		$1
}

rule file_86_9_0 {
	meta:
		name = "_times"
		size = 60
	strings:
		$1 = { 70 40 2D E9 00 40 A0 E1 00 60 A0 E3 10 50 A0 E3 05 00 A0 E1 06 10 A0 E1 56 34 12 EF 00 50 A0 E1 06 00 54 E1 0C 60 84 15 00 50 84 15 04 60 84 15 08 60 84 15 05 00 A0 E1 70 80 BD E8 }
	condition:
		$1
}

rule file_86_10_0 {
	meta:
		name = "_rename"
		size = 108
		refs = "0010 strlen"
	strings:
		$1 = { 30 40 2D E9 10 D0 4D E2 01 40 A0 E1 00 00 8D E5 ?? ?? ?? ?? 04 00 8D E5 04 00 A0 E1 08 40 8D E5 ?? ?? ?? ?? 0F 40 A0 E3 0C 00 8D E5 0D 50 A0 E1 04 00 A0 E1 05 10 A0 E1 56 34 12 EF 00 40 A0 E1 01 00 74 E3 04 00 00 0A 00 00 54 E3 04 00 A0 01 00 00 E0 13 10 D0 8D E2 30 80 BD E8 04 00 A0 E1 D9 FF FF EB 00 40 A0 E1 F6 FF FF EA }
	condition:
		$1
}

rule file_86_11_0 {
	meta:
		name = "_system"
		size = 140
		refs = "0018 strlen"
	strings:
		$1 = { 30 40 2D E9 00 30 50 E2 08 D0 4D E2 01 00 A0 03 17 00 00 0A 00 30 8D E5 ?? ?? ?? ?? 12 40 A0 E3 04 00 8D E5 0D 50 A0 E1 04 00 A0 E1 05 10 A0 E1 56 34 12 EF 00 40 A0 E1 01 00 74 E3 0E 00 00 0A FF 00 54 E3 09 00 00 8A 00 00 54 E3 07 00 00 0A 04 00 A0 E1 80 00 B0 E1 40 34 A0 E1 FF 30 03 E2 03 00 00 0A 04 00 53 E1 F9 FF FF 1A 00 00 00 EA 04 00 A0 E1 08 D0 8D E2 30 80 BD E8 04 00 A0 E1 B6 FF FF EB 00 40 A0 E1 EC FF FF EA }
	condition:
		$1
}

rule file_86_12_0 {
	meta:
		name = "_unlink"
		size = 88
		refs = "000c strlen"
	strings:
		$1 = { 30 40 2D E9 08 D0 4D E2 00 00 8D E5 ?? ?? ?? ?? 0E 40 A0 E3 04 00 8D E5 0D 50 A0 E1 04 00 A0 E1 05 10 A0 E1 56 34 12 EF 00 40 A0 E1 01 00 74 E3 04 00 00 0A 00 00 54 E3 04 00 A0 01 00 00 E0 13 08 D0 8D E2 30 80 BD E8 04 00 A0 E1 A0 FF FF EB 00 40 A0 E1 F6 FF FF EA }
	condition:
		$1
}

rule file_86_13_0 {
	meta:
		name = "_swiopen"
		size = 208
		refs = "0074 strlen"
	strings:
		$1 = { F0 41 2D E9 C0 70 9F E5 00 30 A0 E1 0C D0 4D E2 00 40 A0 E3 0C 00 87 E2 84 21 90 E7 01 00 72 E3 84 61 A0 E1 05 00 00 0A 01 40 84 E2 14 00 54 E3 F8 FF FF 1A 00 00 E0 E3 0C D0 8D E2 F0 81 BD E8 21 58 A0 E1 01 50 05 E2 02 00 11 E3 02 50 85 13 02 0C 11 E3 04 50 85 13 01 0B 11 E3 04 50 85 13 08 00 11 E3 04 50 C5 13 03 00 A0 E1 08 50 85 13 00 30 8D E5 ?? ?? ?? ?? 04 50 8D E5 08 00 8D E5 0D 80 A0 E1 01 50 A0 E3 05 00 A0 E1 08 10 A0 E1 56 34 12 EF 00 50 A0 E1 00 00 55 E3 07 00 00 BA 84 41 87 E0 06 60 87 E0 04 40 84 E2 00 30 A0 E3 0C 30 84 E5 0C 50 86 E5 20 00 85 E2 DD FF FF EA 05 00 A0 E1 6C FF FF EB DA FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_86_14_0 {
	meta:
		name = "_open"
		size = 56
		refs = "000c _swiopen"
	strings:
		$1 = { 0E 00 2D E9 04 E0 2D E5 04 10 9D E5 ?? ?? ?? ?? 01 00 70 E3 00 30 A0 E1 03 00 00 0A 03 00 A0 E1 04 E0 9D E4 0C D0 8D E2 1E FF 2F E1 5E FF FF EB 00 30 A0 E1 F8 FF FF EA }
	condition:
		$1
}

rule file_86_15_0 {
	meta:
		name = "_sbrk"
		size = 84
		refs = "0034 __errno 0050 end"
	strings:
		$1 = { 44 20 9F E5 04 E0 2D E5 AC 30 92 E5 00 00 53 E3 38 30 9F 05 0D 10 A0 E1 00 00 83 E0 AC 30 82 05 01 00 50 E1 AC 00 82 95 01 00 00 8A 03 00 A0 E1 04 F0 9D E4 ?? ?? ?? ?? 0C 30 A0 E3 00 30 80 E5 00 30 E0 E3 03 00 A0 E1 04 F0 9D E4 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_86_16_0 {
	meta:
		name = "_isatty"
		size = 76
	strings:
		$1 = { 30 40 2D E9 04 D0 4D E2 DF FF FF EB 04 40 8D E2 04 00 24 E5 09 50 A0 E3 05 00 A0 E1 04 10 A0 E1 56 34 12 EF 00 40 A0 E1 01 00 74 E3 02 00 00 0A 04 00 A0 E1 04 D0 8D E2 30 80 BD E8 04 00 A0 E1 19 FF FF EB 00 40 A0 E1 F8 FF FF EA }
	condition:
		$1
}

rule file_86_17_0 {
	meta:
		name = "_swiclose"
		size = 116
	strings:
		$1 = { 30 40 2D E9 04 D0 4D E2 CC FF FF EB 58 10 9F E5 00 30 A0 E3 83 21 91 E7 02 00 50 E1 83 21 A0 E1 01 30 83 E2 0B 00 00 0A 14 00 53 E3 F8 FF FF 1A 04 40 8D E2 04 00 24 E5 02 50 A0 E3 05 00 A0 E1 04 10 A0 E1 56 34 12 EF 00 40 A0 E1 04 00 A0 E1 04 D0 8D E2 30 80 BD E8 10 30 9F E5 02 20 83 E0 00 30 E0 E3 0C 30 82 E5 F0 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_86_18_0 {
	meta:
		name = "_close"
		size = 24
		refs = "0004 _swiclose"
	strings:
		$1 = { 04 E0 2D E5 ?? ?? ?? ?? 01 00 70 E3 04 F0 9D 14 04 E0 9D E4 F4 FE FF EA }
	condition:
		$1
}

rule file_86_19_0 {
	meta:
		name = "_swiwrite"
		size = 60
	strings:
		$1 = { 30 40 2D E9 0C D0 4D E2 01 40 A0 E1 02 50 A0 E1 A7 FF FF EB 31 00 8D E8 0D 50 A0 E1 05 40 A0 E3 04 00 A0 E1 05 10 A0 E1 56 34 12 EF 00 40 A0 E1 04 00 A0 E1 0C D0 8D E2 30 80 BD E8 }
	condition:
		$1
}

rule file_86_20_0 {
	meta:
		name = "_write"
		size = 140
		refs = "0044 _swiwrite"
	strings:
		$1 = { F0 41 2D E9 7C 60 9F E5 02 50 A0 E1 01 70 A0 E1 00 80 A0 E1 00 40 A0 E3 96 FF FF EB 0C 20 86 E2 84 31 92 E7 03 00 50 E1 02 00 00 0A 01 40 84 E2 14 00 54 E3 F9 FF FF 1A 08 00 A0 E1 07 10 A0 E1 05 20 A0 E1 ?? ?? ?? ?? 01 00 70 E3 00 00 55 11 09 00 00 0A 14 00 54 E3 05 00 00 0A 84 41 86 E0 04 40 84 E2 0C 30 94 E5 03 30 85 E0 03 30 60 E0 0C 30 84 E5 05 00 60 E0 F0 81 BD E8 00 00 E0 E3 F0 41 BD E8 C3 FE FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_86_21_0 {
	meta:
		name = "_swilseek"
		size = 240
	strings:
		$1 = { F0 45 2D E9 E0 80 9F E5 08 D0 4D E2 02 50 A0 E1 01 60 A0 E1 00 A0 A0 E1 00 40 A0 E3 72 FF FF EB 0C 20 88 E2 84 31 92 E7 03 00 50 E1 02 00 00 0A 01 40 84 E2 14 00 54 E3 F9 FF FF 1A 01 00 55 E3 22 00 00 0A 02 00 55 E3 0D 70 A0 11 16 00 00 0A 0A 00 A0 E1 64 FF FF EB 0A 50 A0 E3 41 00 8D E8 05 00 A0 E1 07 10 A0 E1 56 34 12 EF 00 50 A0 E1 01 50 75 E2 00 50 A0 33 14 00 54 E3 00 30 A0 03 01 30 05 12 00 00 53 E3 84 41 88 10 10 60 84 15 02 00 00 1A 00 00 55 E3 00 00 00 1A 00 60 E0 E3 06 00 A0 E1 08 D0 8D E2 F0 85 BD E8 08 70 8D E2 08 00 27 E5 0C 50 A0 E3 05 00 A0 E1 07 10 A0 E1 56 34 12 EF 00 50 A0 E1 05 60 86 E0 DF FF FF EA 14 00 54 E3 F0 FF FF 0A 84 31 88 E0 10 30 93 E5 0D 70 A0 E1 03 60 86 E0 D8 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_86_22_0 {
	meta:
		name = "_lseek"
		size = 24
		refs = "0004 _swilseek"
	strings:
		$1 = { 04 E0 2D E5 ?? ?? ?? ?? 01 00 70 E3 04 F0 9D 14 04 E0 9D E4 80 FE FF EA }
	condition:
		$1
}

rule file_86_23_0 {
	meta:
		name = "_swiread"
		size = 60
	strings:
		$1 = { 30 40 2D E9 0C D0 4D E2 01 40 A0 E1 02 50 A0 E1 33 FF FF EB 31 00 8D E8 0D 50 A0 E1 06 40 A0 E3 04 00 A0 E1 05 10 A0 E1 56 34 12 EF 00 40 A0 E1 04 00 A0 E1 0C D0 8D E2 30 80 BD E8 }
	condition:
		$1
}

rule file_86_24_0 {
	meta:
		name = "_read"
		size = 136
		refs = "0044 _swiread"
	strings:
		$1 = { F0 41 2D E9 78 60 9F E5 02 50 A0 E1 01 70 A0 E1 00 80 A0 E1 00 40 A0 E3 22 FF FF EB 0C 20 86 E2 84 31 92 E7 03 00 50 E1 02 00 00 0A 01 40 84 E2 14 00 54 E3 F9 FF FF 1A 08 00 A0 E1 07 10 A0 E1 05 20 A0 E1 ?? ?? ?? ?? 00 00 50 E3 09 00 00 BA 14 00 54 E3 05 00 00 0A 84 41 86 E0 04 40 84 E2 0C 30 94 E5 03 30 85 E0 03 30 60 E0 0C 30 84 E5 05 00 60 E0 F0 81 BD E8 00 00 E0 E3 F0 41 BD E8 50 FE FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_86_25_0 {
	meta:
		name = "_stat"
		size = 76
		refs = "000c _open 0028 memset 0040 _swiclose"
	strings:
		$1 = { 30 40 2D E9 01 40 A0 E1 00 10 A0 E3 ?? ?? ?? ?? 00 50 50 E2 00 00 E0 B3 30 80 BD B8 04 00 A0 E1 00 10 A0 E3 3C 20 A0 E3 ?? ?? ?? ?? 01 3B A0 E3 2C 30 84 E5 81 3C A0 E3 04 30 84 E5 05 00 A0 E1 ?? ?? ?? ?? 00 00 A0 E3 30 80 BD E8 }
	condition:
		$1
}

rule file_86_26_0 {
	meta:
		name = "_fstat"
		size = 48
		refs = "0014 memset"
	strings:
		$1 = { 10 40 2D E9 01 00 A0 E1 01 40 A0 E1 3C 20 A0 E3 00 10 A0 E3 ?? ?? ?? ?? 01 3B A0 E3 2C 30 84 E5 02 3A A0 E3 04 30 84 E5 00 00 A0 E3 10 80 BD E8 }
	condition:
		$1
}

rule file_87_0_0 {
	meta:
		name = "strlcpy"
		size = 96
	strings:
		$1 = { 00 00 52 E3 01 30 A0 01 0B 00 00 0A 01 20 52 E2 01 30 A0 01 06 00 00 0A 01 30 A0 E1 01 C0 D3 E4 00 00 5C E3 01 C0 C0 E4 09 00 00 0A 01 20 52 E2 F9 FF FF 1A 00 20 A0 E3 00 20 C0 E5 01 20 D3 E4 00 00 52 E3 FC FF FF 1A 01 10 E0 E1 01 00 83 E0 1E FF 2F E1 00 00 52 E3 FA FF FF 1A F4 FF FF EA }
	condition:
		$1
}

rule file_88_0_0 {
	meta:
		name = "wcslcpy"
		size = 100
	strings:
		$1 = { 00 00 52 E3 01 30 A0 01 0B 00 00 0A 01 20 52 E2 01 30 A0 01 06 00 00 0A 01 30 A0 E1 04 C0 93 E4 00 00 5C E3 04 C0 80 E4 0A 00 00 0A 01 20 52 E2 F9 FF FF 1A 00 20 A0 E3 00 20 80 E5 04 20 93 E4 00 00 52 E3 FC FF FF 1A 03 30 61 E0 43 01 A0 E1 01 00 40 E2 1E FF 2F E1 00 00 52 E3 F9 FF FF 1A F3 FF FF EA }
	condition:
		$1
}

rule file_89_0_0 {
	meta:
		name = "clearerr"
		size = 60
		refs = "0024 __sinit 0038 _impure_ptr"
	strings:
		$1 = { 30 30 9F E5 00 30 93 E5 00 00 53 E3 10 40 2D E9 00 40 A0 E1 03 00 00 0A 38 20 93 E5 00 00 52 E3 03 00 A0 01 ?? ?? ?? ?? BC 30 D4 E1 60 30 C3 E3 BC 30 C4 E1 10 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_90_0_0 {
	meta:
		name = "abort"
		size = 16
		refs = "0004 raise 000c _exit"
	strings:
		$1 = { 06 00 A0 E3 ?? ?? ?? ?? 01 00 A0 E3 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_91_0_0 {
	meta:
		name = "wcsstr"
		size = 180
		refs = "0028 wcslen"
	strings:
		$1 = { 30 40 2D E9 00 30 91 E5 00 00 53 E3 04 D0 4D E2 00 40 A0 E1 02 00 00 1A 04 00 A0 E1 04 D0 8D E2 30 80 BD E8 00 10 8D E5 ?? ?? ?? ?? 00 10 9D E5 00 50 A0 E1 01 00 A0 E1 ?? ?? ?? ?? 00 00 55 E1 00 10 9D E5 01 00 00 2A 00 40 A0 E3 F1 FF FF EA 00 30 94 E5 00 00 53 E3 FA FF FF 0A 00 50 91 E5 00 00 55 E3 04 00 A0 11 EA FF FF 0A 00 30 90 E5 03 00 55 E1 01 30 A0 01 06 00 00 1A 04 20 93 E5 00 00 52 E3 E3 FF FF 0A 04 C0 B0 E5 0C 00 52 E1 04 30 83 E2 F8 FF FF 0A 04 40 84 E2 00 30 94 E5 00 00 53 E3 04 00 A0 E1 EF FF FF 1A 00 40 A0 E3 D8 FF FF EA }
	condition:
		$1
}

rule file_92_0_0 {
	meta:
		name = "__assert_func"
		size = 88
		refs = "0040 fiprintf 0044 abort 0048 _impure_ptr"
	strings:
		$1 = { 40 C0 9F E5 00 E0 9C E5 00 C0 52 E2 01 40 A0 E1 0C 10 9E E5 30 E0 9F 05 30 E0 9F 15 0C D0 4D E2 0E C0 A0 01 03 20 A0 E1 00 30 A0 E1 01 00 A0 E1 1C 10 9F E5 04 E0 8D E5 08 C0 8D E5 00 40 8D E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_93_0_0 {
	meta:
		name = "sprintf"
		size = 116
		refs = "0050 _svfprintf_r 0070 _impure_ptr"
	strings:
		$1 = { 0E 00 2D E9 30 40 2D E9 60 20 9F E5 6C D0 4D E2 7C C0 8D E2 02 E1 E0 E3 00 40 A0 E1 0C 30 A0 E1 14 E0 8D E5 08 E0 8D E5 00 00 92 E5 00 E0 E0 E3 78 20 9D E5 0D 10 A0 E1 82 5F A0 E3 10 40 8D E5 BC 50 CD E1 00 40 8D E5 BE E0 CD E1 68 C0 8D E5 ?? ?? ?? ?? 00 30 9D E5 00 20 A0 E3 00 20 C3 E5 6C D0 8D E2 30 40 BD E8 0C D0 8D E2 1E FF 2F E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_465_0_0 {
	meta:
		name = "siprintf"
		size = 116
		refs = "0050 _svfiprintf_r 0070 _impure_ptr"
	strings:
		$1 = { 0E 00 2D E9 30 40 2D E9 60 20 9F E5 6C D0 4D E2 7C C0 8D E2 02 E1 E0 E3 00 40 A0 E1 0C 30 A0 E1 14 E0 8D E5 08 E0 8D E5 00 00 92 E5 00 E0 E0 E3 78 20 9D E5 0D 10 A0 E1 82 5F A0 E3 10 40 8D E5 BC 50 CD E1 00 40 8D E5 BE E0 CD E1 68 C0 8D E5 ?? ?? ?? ?? 00 30 9D E5 00 20 A0 E3 00 20 C3 E5 6C D0 8D E2 30 40 BD E8 0C D0 8D E2 1E FF 2F E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_93_1_0 {
	meta:
		name = "_sprintf_r"
		size = 104
		refs = "0048 _svfprintf_r"
	strings:
		$1 = { 0C 00 2D E9 30 40 2D E9 6C D0 4D E2 7C C0 8D E2 02 E1 E0 E3 01 40 A0 E1 0C 30 A0 E1 78 20 9D E5 14 E0 8D E5 08 E0 8D E5 0D 10 A0 E1 00 E0 E0 E3 82 5F A0 E3 10 40 8D E5 BC 50 CD E1 00 40 8D E5 BE E0 CD E1 68 C0 8D E5 ?? ?? ?? ?? 00 30 9D E5 00 20 A0 E3 00 20 C3 E5 6C D0 8D E2 30 40 BD E8 08 D0 8D E2 1E FF 2F E1 }
	condition:
		$1
}

rule file_465_1_0 {
	meta:
		name = "_siprintf_r"
		size = 104
		refs = "0048 _svfiprintf_r"
	strings:
		$1 = { 0C 00 2D E9 30 40 2D E9 6C D0 4D E2 7C C0 8D E2 02 E1 E0 E3 01 40 A0 E1 0C 30 A0 E1 78 20 9D E5 14 E0 8D E5 08 E0 8D E5 0D 10 A0 E1 00 E0 E0 E3 82 5F A0 E3 10 40 8D E5 BC 50 CD E1 00 40 8D E5 BE E0 CD E1 68 C0 8D E5 ?? ?? ?? ?? 00 30 9D E5 00 20 A0 E3 00 20 C3 E5 6C D0 8D E2 30 40 BD E8 08 D0 8D E2 1E FF 2F E1 }
	condition:
		$1
}

rule file_94_0_0 {
	meta:
		name = "_toupper"
		size = 32
		refs = "001c __ctype_ptr__"
		altNames = "toupper"
	strings:
		$1 = { 14 30 9F E5 00 30 93 E5 00 30 83 E0 01 30 D3 E5 02 00 13 E3 20 00 40 12 1E FF 2F E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_96_0_0 {
	meta:
		name = "modf"
		size = 320
		refs = "00ac __subdf3"
	strings:
		$1 = { 40 3A A0 E1 83 3A A0 E1 A3 3A A0 E1 FF 3F 43 E2 03 30 43 E2 13 00 53 E3 F0 48 2D E9 01 C0 A0 E1 00 B0 A0 E1 00 40 A0 E1 01 50 A0 E1 00 60 A0 E1 01 70 A0 E1 0F 00 00 CA 00 00 53 E3 3B 00 00 BA 01 46 A0 E3 01 40 44 E2 54 33 A0 E1 00 50 03 E0 01 70 95 E1 1A 00 00 1A 02 31 00 E2 00 18 82 E8 07 40 A0 E1 03 B0 A0 E1 07 C0 A0 E1 0B 00 A0 E1 0C 10 A0 E1 F0 88 BD E8 33 00 53 E3 1B 00 00 CA 00 60 E0 E3 14 30 43 E2 36 33 A0 E1 01 60 13 E0 1E 00 00 0A 03 70 C1 E1 07 C0 A0 E1 00 B0 A0 E1 00 18 82 E8 07 30 A0 E1 00 20 A0 E1 ?? ?? ?? ?? 00 B0 A0 E1 01 C0 A0 E1 0B 00 A0 E1 0C 10 A0 E1 F0 88 BD E8 03 40 C0 E1 00 50 A0 E3 30 00 82 E8 05 30 A0 E1 04 20 A0 E1 ?? ?? ?? ?? 00 B0 A0 E1 01 C0 A0 E1 0B 00 A0 E1 0C 10 A0 E1 F0 88 BD E8 02 31 00 E2 00 40 A0 E3 00 18 82 E8 03 B0 A0 E1 04 C0 A0 E1 0B 00 A0 E1 0C 10 A0 E1 F0 88 BD E8 02 31 00 E2 00 18 82 E8 03 B0 A0 E1 06 C0 A0 E1 06 40 A0 E1 0B 00 A0 E1 0C 10 A0 E1 F0 88 BD E8 02 31 00 E2 00 40 A0 E3 18 00 82 E8 CA FF FF EA }
	condition:
		$1
}

rule file_97_0_0 {
	meta:
		name = "nan"
		size = 16
	strings:
		$1 = { 7F 04 A0 E3 3E 07 80 E2 00 10 A0 E3 1E FF 2F E1 }
	condition:
		$1
}

rule file_98_0_0 {
	meta:
		name = "__submore"
		size = 168
		refs = "0024 _realloc_r 0040 memcpy 0064 _malloc_r"
	strings:
		$1 = { F0 41 2D E9 01 40 A0 E1 30 10 91 E5 40 30 84 E2 03 00 51 E1 11 00 00 0A 34 50 94 E5 85 70 A0 E1 07 20 A0 E1 ?? ?? ?? ?? 00 60 50 E2 09 00 00 0A 05 80 86 E0 05 20 A0 E1 08 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 34 70 84 E5 00 80 84 E5 30 60 84 E5 00 00 A0 E3 F0 81 BD E8 00 00 E0 E3 F0 81 BD E8 01 1B A0 E3 ?? ?? ?? ?? 00 00 50 E3 F9 FF FF 0A 42 20 D4 E5 FF 3F 80 E2 01 30 83 E2 01 1B A0 E3 30 00 84 E5 34 10 84 E5 02 20 C3 E5 41 20 D4 E5 01 20 C3 E5 40 20 D4 E5 FD 23 C0 E5 00 30 84 E5 00 00 A0 E3 F0 81 BD E8 }
	condition:
		$1
}

rule file_98_1_0 {
	meta:
		name = "_ungetc_r"
		size = 448
		refs = "00c0 __sinit 0178 __submore 0194 _fflush_r"
	strings:
		$1 = { 01 00 71 E3 F0 40 2D E9 01 40 A0 E1 02 50 A0 E1 00 60 A0 E1 20 00 00 0A 00 00 50 E3 02 00 00 0A 38 30 90 E5 00 00 53 E3 24 00 00 0A BC 20 D5 E1 02 0A 12 E3 02 38 A0 E1 19 00 00 0A 23 38 A0 E1 20 30 C3 E3 03 38 A0 E1 23 38 A0 E1 04 00 13 E3 03 20 A0 E1 BC 30 C5 E1 3D 00 00 0A 30 30 95 E5 00 00 53 E3 FF 70 04 E2 1A 00 00 0A 04 20 95 E5 34 30 95 E5 03 00 52 E1 3C 00 00 AA 00 30 95 E5 01 20 43 E2 00 20 85 E5 01 70 43 E5 04 30 95 E5 01 30 83 E2 04 30 85 E5 07 40 A0 E1 04 00 A0 E1 F0 80 BD E8 64 30 95 E5 02 2A 82 E3 02 3A C3 E3 64 30 85 E5 BC 20 C5 E1 02 38 A0 E1 DE FF FF EA ?? ?? ?? ?? BC 20 D5 E1 02 0A 12 E3 02 38 A0 E1 D9 FF FF 1A F2 FF FF EA 10 30 95 E5 00 00 53 E3 00 20 95 05 06 00 00 0A 00 20 95 E5 02 00 53 E1 03 00 00 2A 01 40 52 E5 07 00 54 E1 01 30 42 E2 0E 00 00 0A 05 30 A0 E1 04 00 95 E5 42 70 E3 E5 40 10 85 E2 01 C0 A0 E3 38 20 85 E5 07 40 A0 E1 03 20 A0 E3 3C 00 85 E5 04 C0 85 E5 30 10 85 E5 34 20 85 E5 00 30 85 E5 04 00 A0 E1 F0 80 BD E8 04 20 95 E5 01 20 82 E2 04 20 85 E5 00 30 85 E5 D1 FF FF EA 10 00 13 E3 09 00 00 0A 08 00 13 E3 09 00 00 1A 04 30 83 E3 BC 30 C5 E1 BA FF FF EA 06 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 BD FF FF 0A 00 40 E0 E3 C3 FF FF EA 06 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 F8 FF FF 1A BC 30 D5 E1 08 30 C3 E3 03 38 A0 E1 23 38 A0 E1 18 00 85 E5 BC 30 C5 E1 08 00 85 E5 E8 FF FF EA }
	condition:
		$1
}

rule file_100_0_0 {
	meta:
		name = "time"
		size = 72
		refs = "001c _gettimeofday_r 0044 _impure_ptr"
	strings:
		$1 = { 10 40 2D E9 38 30 9F E5 08 D0 4D E2 00 40 A0 E1 0D 10 A0 E1 00 00 93 E5 00 20 A0 E3 ?? ?? ?? ?? 00 00 50 E3 00 00 E0 B3 03 00 00 BA 00 00 54 E3 00 00 9D 15 00 00 9D 05 00 00 84 15 08 D0 8D E2 10 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_101_0_0 {
	meta:
		name = "dprintf"
		size = 68
		refs = "002c _vdprintf_r 0040 _impure_ptr"
	strings:
		$1 = { 0E 00 2D E9 04 E0 2D E5 30 30 9F E5 04 D0 4D E2 00 30 93 E5 0C C0 8D E2 00 10 A0 E1 08 20 9D E5 03 00 A0 E1 0C 30 A0 E1 00 C0 8D E5 ?? ?? ?? ?? 04 D0 8D E2 04 E0 9D E4 0C D0 8D E2 1E FF 2F E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_102_0_0 {
	meta:
		name = "isgraph"
		size = 28
		refs = "0018 __ctype_ptr__"
	strings:
		$1 = { 10 30 9F E5 00 30 93 E5 00 30 83 E0 01 00 D3 E5 17 00 00 E2 1E FF 2F E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_102_1_0 {
	meta:
		name = "isprint"
		size = 28
		refs = "0018 __ctype_ptr__"
	strings:
		$1 = { 10 30 9F E5 00 30 93 E5 00 30 83 E0 01 00 D3 E5 97 00 00 E2 1E FF 2F E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_103_0_0 {
	meta:
		name = "getc_unlocked"
		size = 60
		refs = "0034 __srget_r 0038 _impure_ptr"
	strings:
		$1 = { 04 30 90 E5 01 30 43 E2 00 00 53 E3 04 30 80 E5 04 00 00 BA 00 30 90 E5 01 20 D3 E4 00 30 80 E5 02 00 A0 E1 1E FF 2F E1 08 30 9F E5 00 10 A0 E1 00 00 93 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_103_1_0 {
	meta:
		name = "_getc_unlocked_r"
		size = 40
		refs = "0024 __srget_r"
	strings:
		$1 = { 04 20 91 E5 01 20 42 E2 00 00 52 E3 04 20 81 E5 03 00 00 BA 00 20 91 E5 01 00 D2 E4 00 20 81 E5 1E FF 2F E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_104_0_0 {
	meta:
		name = "_raise_r"
		size = 144
		refs = "0078 _getpid_r 008c _kill_r"
	strings:
		$1 = { 1F 00 51 E3 16 30 A0 83 30 40 2D E9 00 30 80 85 00 50 A0 E1 01 40 A0 E1 00 00 E0 83 30 80 BD 88 DC 22 95 E5 00 00 52 E3 11 00 00 0A 01 31 92 E7 00 00 53 E3 0E 00 00 0A 01 00 53 E3 00 00 A0 03 30 80 BD 08 01 00 73 E3 16 30 A0 03 00 30 85 05 01 00 A0 03 30 80 BD 08 00 50 A0 E3 01 00 A0 E1 01 51 82 E7 0F E0 A0 E1 13 FF 2F E1 05 00 A0 E1 30 80 BD E8 05 00 A0 E1 ?? ?? ?? ?? 04 20 A0 E1 00 10 A0 E1 05 00 A0 E1 30 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_104_2_0 {
	meta:
		name = "_init_signal_r"
		size = 76
		refs = "0020 _malloc_r"
	strings:
		$1 = { 30 40 2D E9 DC 52 90 E5 00 00 55 E3 00 40 A0 E1 01 00 00 0A 00 00 A0 E3 30 80 BD E8 80 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 DC 02 84 E5 00 00 E0 03 30 80 BD 08 05 30 A0 E1 05 30 80 E7 04 50 85 E2 80 00 55 E3 FB FF FF 1A F1 FF FF EA }
	condition:
		$1
}

rule file_104_4_0 {
	meta:
		name = "__sigtramp_r"
		size = 144
		refs = "0078 _init_signal_r"
	strings:
		$1 = { 10 40 2D E9 1F 00 51 E3 04 D0 4D E2 00 40 A0 E1 15 00 00 8A DC 22 90 E5 00 00 52 E3 14 00 00 0A 01 31 92 E7 00 00 53 E3 01 21 82 E0 01 00 A0 03 0B 00 00 0A 01 00 73 E3 02 00 A0 03 08 00 00 0A 01 00 53 E3 03 00 A0 03 05 00 00 0A 00 40 A0 E3 01 00 A0 E1 00 40 82 E5 0F E0 A0 E1 13 FF 2F E1 04 00 A0 E1 04 D0 8D E2 10 80 BD E8 00 00 E0 E3 FB FF FF EA 00 10 8D E5 ?? ?? ?? ?? 00 00 50 E3 00 10 9D E5 F8 FF FF 1A DC 22 94 E5 E3 FF FF EA }
	condition:
		$1
}

rule file_104_6_0 {
	meta:
		name = "_signal_r"
		size = 100
		refs = "0044 _init_signal_r"
	strings:
		$1 = { 10 40 2D E9 1F 00 51 E3 16 30 A0 83 00 40 A0 E1 00 30 80 85 08 D0 4D E2 00 00 E0 83 04 00 00 8A DC 32 94 E5 00 00 53 E3 03 00 00 0A 01 01 93 E7 01 21 83 E7 08 D0 8D E2 10 80 BD E8 04 10 8D E5 00 20 8D E5 ?? ?? ?? ?? 00 00 50 E3 04 10 9D E5 00 20 9D E5 00 00 E0 13 F5 FF FF 1A DC 32 94 E5 F1 FF FF EA }
	condition:
		$1
}

rule file_105_0_0 {
	meta:
		name = "_rewind_r"
		size = 36
		refs = "0010 _fseek_r"
	strings:
		$1 = { 00 20 A0 E3 10 40 2D E9 02 30 A0 E1 01 40 A0 E1 ?? ?? ?? ?? BC 30 D4 E1 60 30 C3 E3 BC 30 C4 E1 10 80 BD E8 }
	condition:
		$1
}

rule file_106_0_0 {
	meta:
		name = "wcscspn"
		size = 104
	strings:
		$1 = { 00 30 90 E5 00 00 53 E3 30 00 2D E9 03 00 A0 01 12 00 00 0A 00 40 91 E5 00 50 A0 E1 00 00 54 E3 09 00 00 0A 04 00 53 E1 0A 00 00 0A 01 20 A0 E1 02 00 00 EA 0C 00 53 E1 04 20 82 E2 05 00 00 0A 04 C0 92 E5 00 00 5C E3 F9 FF FF 1A 04 30 B5 E5 00 00 53 E3 F0 FF FF 1A 05 00 60 E0 40 01 A0 E1 30 00 BD E8 1E FF 2F E1 }
	condition:
		$1
}

rule file_107_0_0 {
	meta:
		name = "_mrand48_r"
		size = 32
		refs = "000c __dorand48"
	strings:
		$1 = { 10 40 2D E9 AC 10 80 E2 00 40 A0 E1 ?? ?? ?? ?? BE 3A D4 E1 B0 0B D4 E1 00 08 83 E0 10 80 BD E8 }
	condition:
		$1
}

rule file_108_0_0 {
	meta:
		name = "argz_replace"
		size = 476
		refs = "0020 strlen 0068 _buf_findstr 00b8 malloc 011c memcpy 018c realloc 01c0 free"
	strings:
		$1 = { F0 4F 2D E9 00 90 A0 E1 18 D0 4D E2 02 00 A0 E1 02 40 A0 E1 04 30 8D E5 08 10 8D E5 3C 80 9D E5 ?? ?? ?? ?? 00 00 8D E5 04 00 9D E5 ?? ?? ?? ?? 00 20 99 E5 08 10 9D E5 14 20 8D E5 00 20 A0 E3 00 30 91 E5 00 20 88 E5 00 20 9D E5 00 B0 A0 E1 10 30 8D E5 00 A0 62 E0 03 70 A0 E1 14 60 8D E2 10 50 8D E2 07 00 00 EA ?? ?? ?? ?? 00 00 50 E3 00 30 98 15 01 30 83 12 00 30 88 15 10 30 9D 05 10 30 9D 15 0A 70 87 10 00 00 53 E3 04 00 A0 E1 06 10 A0 E1 05 20 A0 E1 F2 FF FF 1A 00 20 98 E5 00 00 52 E3 03 00 A0 01 01 00 00 1A 18 D0 8D E2 F0 8F BD E8 07 00 A0 E1 ?? ?? ?? ?? 08 10 9D E5 00 80 99 E5 00 30 91 E5 0C 00 8D E5 14 80 8D E5 10 30 8D E5 00 A0 A0 E1 14 60 8D E2 10 50 8D E2 00 00 53 E3 06 10 A0 E1 05 20 A0 E1 04 00 A0 E1 1B 00 00 0A ?? ?? ?? ?? 00 00 50 E3 10 30 9D 05 F6 FF FF 0A 14 20 9D E5 00 30 9D E5 02 20 68 E0 02 20 63 E0 08 10 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 14 30 9D E5 00 10 9D E5 03 80 68 E0 08 80 61 E0 08 A0 8A E0 0A 00 A0 E1 04 10 9D E5 0B 20 A0 E1 ?? ?? ?? ?? 10 30 9D E5 00 00 53 E3 14 80 9D E5 0B A0 8A E0 06 10 A0 E1 05 20 A0 E1 04 00 A0 E1 E3 FF FF 1A 08 10 9D E5 00 20 99 E5 00 30 91 E5 03 20 82 E0 08 10 A0 E1 02 20 68 E0 0A 00 A0 E1 ?? ?? ?? ?? 00 00 99 E5 07 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 00 00 89 E5 0C 00 A0 03 C2 FF FF 0A 07 20 A0 E1 0C 10 9D E5 ?? ?? ?? ?? 08 20 9D E5 00 00 57 E3 00 70 82 E5 03 00 00 0A 0C 00 9D E5 ?? ?? ?? ?? 00 00 A0 E3 B7 FF FF EA 00 00 99 E5 ?? ?? ?? ?? 00 70 89 E5 F7 FF FF EA }
	condition:
		$1
}

rule file_109_0_0 {
	meta:
		name = "setjmp"
		size = 20
	strings:
		$1 = { F0 7F A0 E8 00 00 A0 E3 01 00 1E E3 0E F0 A0 01 1E FF 2F E1 }
	condition:
		$1
}

rule file_109_1_0 {
	meta:
		name = "longjmp"
		size = 24
	strings:
		$1 = { F0 7F B0 E8 01 00 B0 E1 01 00 A0 03 01 00 1E E3 0E F0 A0 01 1E FF 2F E1 }
	condition:
		$1
}

rule file_110_0_0 {
	meta:
		name = "__aeabi_atexit"
		size = 16
		refs = "000c __cxa_atexit"
	strings:
		$1 = { 00 30 A0 E1 01 00 A0 E1 03 10 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_299_0_0 {
	meta:
		name = "bcopy"
		size = 16
		refs = "000c memmove"
	strings:
		$1 = { 00 30 A0 E1 01 00 A0 E1 03 10 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_112_0_0 {
	meta:
		name = "hsearch_r"
		size = 200
		refs = "0018 strlen 0064 strcmp 0094 malloc 00c4 __default_hash"
	strings:
		$1 = { F0 47 2D E9 20 60 9D E5 01 40 A0 E1 02 50 A0 E1 03 90 A0 E1 00 70 A0 E1 ?? ?? ?? ?? A0 30 9F E5 00 10 A0 E1 07 00 A0 E1 0F E0 A0 E1 00 F0 93 E5 04 80 96 E5 00 A0 96 E5 01 80 48 E2 08 80 00 E0 08 61 9A E7 00 00 56 E3 03 00 00 1A 0B 00 00 EA 00 60 96 E5 00 00 56 E3 08 00 00 0A 04 00 96 E5 07 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 F7 FF FF 1A 04 60 86 E2 00 60 89 E5 01 00 A0 E3 F0 87 BD E8 00 00 55 E3 00 50 89 05 05 00 A0 01 F0 87 BD 08 0C 00 A0 E3 ?? ?? ?? ?? 00 00 50 E3 08 31 9A 17 04 20 80 12 00 30 80 15 04 70 80 15 08 01 8A 17 08 40 80 15 00 00 89 05 00 20 89 15 01 00 A0 13 F0 87 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_112_1_0 {
	meta:
		name = "hdestroy_r"
		size = 36
		refs = "0014 free"
	strings:
		$1 = { 10 40 2D E9 00 40 A0 E1 00 00 90 E5 00 00 50 E3 10 80 BD 08 ?? ?? ?? ?? 00 30 A0 E3 00 30 84 E5 10 80 BD E8 }
	condition:
		$1
}

rule file_112_2_0 {
	meta:
		name = "hcreate_r"
		size = 204
		refs = "0014 __errno 0050 malloc"
	strings:
		$1 = { 00 30 91 E5 00 00 53 E3 30 40 2D E9 01 50 A0 E1 04 00 00 0A ?? ?? ?? ?? 16 30 A0 E3 00 30 80 E5 00 00 A0 E3 30 80 BD E8 0F 00 50 E3 40 30 A0 93 10 00 A0 93 03 00 00 9A 01 03 50 E3 01 32 A0 83 01 03 A0 83 16 00 00 9A 04 00 85 E5 03 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 00 40 A0 E1 00 00 85 E5 0A 00 00 0A 04 20 95 E5 00 00 52 E3 00 30 A0 13 03 10 A0 11 03 00 00 0A 03 11 84 E7 01 30 83 E2 02 00 53 E1 FB FF FF 3A 01 00 A0 E3 30 80 BD E8 ?? ?? ?? ?? 0C 30 A0 E3 00 30 80 E5 04 00 A0 E1 30 80 BD E8 01 20 40 E2 00 00 12 E1 04 00 00 0A A0 00 B0 E1 01 30 83 E2 FC FF FF 1A 01 00 A0 E3 10 03 A0 E1 00 31 A0 E1 DE FF FF EA }
	condition:
		$1
}

rule file_114_0_0 {
	meta:
		name = "strcspn"
		size = 100
	strings:
		$1 = { 30 00 2D E9 00 30 D0 E5 00 00 53 E3 03 00 A0 01 11 00 00 0A 00 40 D1 E5 00 50 A0 E1 00 00 54 E3 09 00 00 0A 04 00 53 E1 0A 00 00 0A 01 20 A0 E1 02 00 00 EA 0C 00 53 E1 01 20 82 E2 05 00 00 0A 01 C0 D2 E5 00 00 5C E3 F9 FF FF 1A 01 30 F5 E5 00 00 53 E3 F0 FF FF 1A 05 00 60 E0 30 00 BD E8 1E FF 2F E1 }
	condition:
		$1
}

rule file_115_0_0 {
	meta:
		name = "_wcstombs_r"
		size = 268
		refs = "004c _wctomb_r"
	strings:
		$1 = { F0 4F 2D E9 00 00 51 E3 0C D0 4D E2 00 10 8D E5 00 A0 A0 E1 02 70 A0 E1 03 B0 A0 E1 30 90 9D E5 2A 00 00 0A 00 00 53 E3 1C 00 00 0A 00 40 9D E5 03 80 A0 E1 00 60 A0 E3 04 50 8D E2 0A 00 A0 E1 05 10 A0 E1 06 20 97 E7 09 30 A0 E1 ?? ?? ?? ?? 01 00 70 E3 15 00 00 0A 08 00 50 E1 00 10 A0 31 08 10 A0 21 00 00 51 E3 06 00 00 DA 00 30 A0 E3 03 20 D5 E7 03 20 C4 E7 01 30 83 E2 03 00 51 E1 FA FF FF 1A 01 40 84 E0 06 30 97 E7 00 00 53 E3 08 00 00 0A 01 80 58 E0 04 60 86 E2 E6 FF FF 1A 0B 80 A0 E1 08 00 A0 E1 0C D0 8D E2 F0 8F BD E8 00 80 A0 E1 FA FF FF EA 00 30 9D E5 04 40 63 E0 00 00 58 E1 04 80 A0 31 01 80 44 22 F4 FF FF EA 00 20 92 E5 00 00 52 E3 02 80 A0 01 F0 FF FF 0A 00 80 9D E5 04 50 8D E2 0A 00 A0 E1 05 10 A0 E1 09 30 A0 E1 ?? ?? ?? ?? 04 20 B7 E5 00 00 52 E3 00 80 88 E0 F7 FF FF 1A E5 FF FF EA }
	condition:
		$1
}

rule file_118_0_0 {
	meta:
		name = "putc"
		size = 184
		refs = "0090 __swbuf_r 0098 __sinit 00b4 _impure_ptr"
	strings:
		$1 = { 70 40 2D E9 A8 50 9F E5 00 30 95 E5 00 00 53 E3 00 60 A0 E1 01 40 A0 E1 02 00 00 0A 38 20 93 E5 00 00 52 E3 1A 00 00 0A 08 30 94 E5 01 30 43 E2 00 00 53 E3 08 30 84 E5 05 00 00 BA 00 30 94 E5 00 60 C3 E5 00 30 94 E5 01 00 D3 E4 00 30 84 E5 70 80 BD E8 18 20 94 E5 02 00 53 E1 0F 00 00 BA 00 30 94 E5 00 60 C3 E5 00 30 94 E5 00 10 D3 E5 0A 00 51 E3 01 30 83 12 00 30 84 15 01 00 A0 11 70 80 BD 18 00 00 95 E5 04 20 A0 E1 70 40 BD E8 ?? ?? ?? ?? 03 00 A0 E1 ?? ?? ?? ?? E1 FF FF EA 00 00 95 E5 06 10 A0 E1 04 20 A0 E1 70 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_118_1_0 {
	meta:
		name = "_putc_r"
		size = 168
		refs = "0088 __swbuf_r 008c __sinit"
	strings:
		$1 = { 70 40 2D E9 00 40 50 E2 01 60 A0 E1 02 50 A0 E1 02 00 00 0A 38 30 94 E5 00 00 53 E3 1A 00 00 0A 08 30 95 E5 01 30 43 E2 00 00 53 E3 08 30 85 E5 05 00 00 BA 00 30 95 E5 00 60 C3 E5 00 30 95 E5 01 00 D3 E4 00 30 85 E5 70 80 BD E8 18 20 95 E5 02 00 53 E1 0E 00 00 BA 00 30 95 E5 00 60 C3 E5 00 30 95 E5 00 10 D3 E5 0A 00 51 E3 01 30 83 12 00 30 85 15 01 00 A0 11 70 80 BD 18 04 00 A0 E1 05 20 A0 E1 70 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? E2 FF FF EA 04 00 A0 E1 06 10 A0 E1 05 20 A0 E1 70 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_120_0_0 {
	meta:
		name = "iswxdigit"
		size = 44
	strings:
		$1 = { 61 20 40 E2 30 30 40 E2 09 00 53 E3 05 00 52 83 01 00 A0 93 1E FF 2F 91 41 00 40 E2 05 00 50 E3 00 00 A0 83 01 00 A0 93 1E FF 2F E1 }
	condition:
		$1
}

rule file_121_0_0 {
	meta:
		name = "iswdigit"
		size = 20
	strings:
		$1 = { 30 00 40 E2 09 00 50 E3 00 00 A0 83 01 00 A0 93 1E FF 2F E1 }
	condition:
		$1
}

rule file_122_0_0 {
	meta:
		name = "wctomb"
		size = 16
	strings:
		$1 = { 00 00 50 E3 00 10 C0 15 01 00 A0 13 1E FF 2F E1 }
	condition:
		$1
}

rule file_125_0_0 {
	meta:
		name = "strrchr"
		size = 68
		refs = "0028 strchr"
	strings:
		$1 = { 30 40 2D E9 00 40 51 E2 00 30 A0 E1 00 50 A0 13 02 00 00 1A 08 00 00 EA 00 50 A0 E1 01 30 80 E2 03 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 F8 FF FF 1A 05 00 A0 E1 30 80 BD E8 30 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_127_0_0 {
	meta:
		name = "__strtok_r"
		size = 180
	strings:
		$1 = { 00 00 50 E3 70 00 2D E9 25 00 00 0A 00 50 A0 E1 01 60 D5 E4 00 C0 A0 E3 0C 40 D1 E7 00 00 54 E3 06 00 00 0A 04 00 56 E1 01 C0 8C E2 F9 FF FF 1A 00 00 53 E3 17 00 00 0A 05 00 A0 E1 F2 FF FF EA 00 00 56 E3 00 60 82 05 06 00 A0 01 04 00 00 1A 0E 00 00 EA 00 00 5C E3 01 30 83 E2 03 00 00 1A 04 50 A0 E1 05 40 A0 E1 01 60 D4 E4 00 30 A0 E3 03 C0 D1 E7 0C 00 56 E1 F5 FF FF 1A 00 00 56 E3 06 40 A0 01 00 30 A0 13 00 30 C5 15 00 40 82 E5 70 00 BD E8 1E FF 2F E1 00 50 82 E5 00 30 C0 E5 FA FF FF EA 00 00 92 E5 00 00 50 E3 D6 FF FF 1A F6 FF FF EA }
	condition:
		$1
}

rule file_128_0_0 {
	meta:
		name = "memcpy"
		size = 240
	strings:
		$1 = { 0F 00 52 E3 30 00 2D E9 02 C0 A0 E1 00 50 A0 E1 01 40 A0 E1 02 00 00 9A 00 30 81 E1 03 00 13 E3 09 00 00 0A 00 00 5C E3 05 00 00 0A 00 30 A0 E3 03 20 D4 E7 03 20 C5 E7 01 30 83 E2 0C 00 53 E1 FA FF FF 1A 30 00 BD E8 1E FF 2F E1 02 50 A0 E1 01 C0 A0 E1 00 30 A0 E1 00 40 9C E5 00 40 83 E5 04 40 9C E5 04 40 83 E5 08 40 9C E5 08 40 83 E5 10 50 45 E2 0C 40 9C E5 0F 00 55 E3 0C 40 83 E5 10 C0 8C E2 10 30 83 E2 F2 FF FF 8A 10 20 42 E2 22 52 A0 E1 05 22 42 E0 01 50 85 E2 05 52 A0 E1 03 00 52 E3 05 40 81 E0 02 C0 A0 E1 05 50 80 E0 DB FF FF 9A 00 30 A0 E3 03 10 94 E7 03 10 85 E7 04 30 83 E2 02 10 63 E0 03 00 51 E3 F9 FF FF 8A 04 20 42 E2 22 11 A0 E1 01 30 81 E2 03 31 A0 E1 03 40 84 E0 01 C1 42 E0 03 50 85 E0 CC FF FF EA }
	condition:
		$1
}

rule file_130_1_0 {
	meta:
		name = "__time_load_locale"
		size = 60
		refs = "0028 __part_load_locale"
	strings:
		$1 = { 04 E0 2D E5 28 E0 9F E5 0C D0 4D E2 3A C0 A0 E3 EC 20 9E E5 0E 10 A0 E1 18 30 9F E5 04 E0 8E E2 00 50 8D E9 00 C0 8D E5 ?? ?? ?? ?? 0C D0 8D E2 00 80 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_131_0_0 {
	meta:
		name = "asiprintf"
		size = 124
		refs = "0050 _svfiprintf_r 0078 _impure_ptr"
	strings:
		$1 = { 0E 00 2D E9 30 40 2D E9 68 20 9F E5 6C D0 4D E2 7C C0 8D E2 A2 EF A0 E3 0C 30 A0 E1 00 40 A0 E3 00 50 A0 E1 BC E0 CD E1 00 00 92 E5 00 E0 E0 E3 0D 10 A0 E1 78 20 9D E5 00 40 8D E5 10 40 8D E5 08 40 8D E5 14 40 8D E5 BE E0 CD E1 68 C0 8D E5 ?? ?? ?? ?? 00 00 50 E3 00 30 9D A5 00 40 C3 A5 10 30 9D A5 00 30 85 A5 6C D0 8D E2 30 40 BD E8 0C D0 8D E2 1E FF 2F E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_202_0_0 {
	meta:
		name = "asprintf"
		size = 124
		refs = "0050 _svfprintf_r 0078 _impure_ptr"
	strings:
		$1 = { 0E 00 2D E9 30 40 2D E9 68 20 9F E5 6C D0 4D E2 7C C0 8D E2 A2 EF A0 E3 0C 30 A0 E1 00 40 A0 E3 00 50 A0 E1 BC E0 CD E1 00 00 92 E5 00 E0 E0 E3 0D 10 A0 E1 78 20 9D E5 00 40 8D E5 10 40 8D E5 08 40 8D E5 14 40 8D E5 BE E0 CD E1 68 C0 8D E5 ?? ?? ?? ?? 00 00 50 E3 00 30 9D A5 00 40 C3 A5 10 30 9D A5 00 30 85 A5 6C D0 8D E2 30 40 BD E8 0C D0 8D E2 1E FF 2F E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_131_1_0 {
	meta:
		name = "_asiprintf_r"
		size = 112
		refs = "0048 _svfiprintf_r"
	strings:
		$1 = { 0C 00 2D E9 30 40 2D E9 6C D0 4D E2 7C C0 8D E2 A2 EF A0 E3 0C 30 A0 E1 00 40 A0 E3 01 50 A0 E1 BC E0 CD E1 0D 10 A0 E1 00 E0 E0 E3 78 20 9D E5 00 40 8D E5 10 40 8D E5 08 40 8D E5 14 40 8D E5 BE E0 CD E1 68 C0 8D E5 ?? ?? ?? ?? 00 00 50 E3 00 30 9D A5 00 40 C3 A5 10 30 9D A5 00 30 85 A5 6C D0 8D E2 30 40 BD E8 08 D0 8D E2 1E FF 2F E1 }
	condition:
		$1
}

rule file_202_1_0 {
	meta:
		name = "_asprintf_r"
		size = 112
		refs = "0048 _svfprintf_r"
	strings:
		$1 = { 0C 00 2D E9 30 40 2D E9 6C D0 4D E2 7C C0 8D E2 A2 EF A0 E3 0C 30 A0 E1 00 40 A0 E3 01 50 A0 E1 BC E0 CD E1 0D 10 A0 E1 00 E0 E0 E3 78 20 9D E5 00 40 8D E5 10 40 8D E5 08 40 8D E5 14 40 8D E5 BE E0 CD E1 68 C0 8D E5 ?? ?? ?? ?? 00 00 50 E3 00 30 9D A5 00 40 C3 A5 10 30 9D A5 00 30 85 A5 6C D0 8D E2 30 40 BD E8 08 D0 8D E2 1E FF 2F E1 }
	condition:
		$1
}

rule file_132_0_0 {
	meta:
		name = "_wcstoll_r"
		size = 688
		refs = "0024 iswspace 00b4 __umoddi3 00c8 __udivdi3 00e0 iswdigit 0180 iswalpha 0190 iswupper"
	strings:
		$1 = { F0 4F 2D E9 1C D0 4D E2 0C 10 8D E5 18 00 8D E5 14 20 8D E5 03 A0 A0 E1 01 50 A0 E1 04 40 95 E4 04 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 FA FF FF 1A 2D 00 54 E3 7B 00 00 0A 2B 00 54 E3 04 40 95 04 10 00 8D E5 01 30 7A E2 00 30 A0 33 00 00 5A E3 10 00 5A 13 0A 00 00 1A 30 00 54 E3 7F 00 00 0A 00 00 53 E3 8D 00 00 0A 30 00 54 E3 86 00 00 0A 0A 00 A0 E3 00 10 A0 E3 03 00 8D E8 0A A0 A0 E3 02 00 00 EA 0A 00 A0 E1 C0 1F A0 E1 03 00 8D E8 10 20 9D E5 00 00 52 E3 00 60 E0 03 02 71 E0 03 00 60 A0 13 02 71 A0 13 0C 00 9D E8 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 07 10 A0 E1 00 90 A0 E1 0C 00 9D E8 06 00 A0 E1 ?? ?? ?? ?? 00 B0 A0 E1 04 00 A0 E1 08 90 8D E5 0A 90 A0 E1 01 A0 A0 E1 ?? ?? ?? ?? 00 00 50 E3 00 60 A0 E3 00 70 A0 E3 00 80 A0 E3 30 40 44 12 1F 00 00 0A 04 00 59 E1 29 00 00 DA 0A 00 58 E1 00 30 A0 E3 3D 00 00 8A 3A 00 00 0A A6 3F 83 E1 FF 30 13 E2 34 00 00 1A 08 00 9D E5 00 00 54 E1 00 20 A0 D3 01 20 A0 C3 0B 00 57 E1 35 00 00 0A 03 00 12 E1 2C 00 00 1A 04 10 9D E5 97 01 01 E0 00 00 9D E5 97 20 83 E0 90 18 21 E0 04 70 92 E0 03 30 81 E0 C4 8F A3 E0 04 40 95 E4 01 60 A0 E3 04 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 30 40 44 12 DF FF FF 1A 04 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 07 00 00 0A 04 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 37 00 A0 13 57 00 A0 03 04 40 60 E0 04 00 59 E1 D5 FF FF CA 01 00 76 E3 20 00 00 0A 10 30 9D E5 00 00 53 E3 16 00 00 1A 14 00 9D E5 00 00 50 E3 05 00 00 0A 00 00 56 E3 04 50 45 12 0C 50 8D 15 14 20 9D E5 0C 10 9D E5 00 10 82 E5 08 10 A0 E1 07 00 A0 E1 1C D0 8D E2 F0 8F BD E8 00 60 E0 E3 04 40 95 E4 D9 FF FF EA 0B 00 57 E1 C2 FF FF 9A 01 30 A0 E3 C0 FF FF EA 0A 00 58 E1 01 30 A0 03 C6 FF FF EA 00 70 77 E2 00 80 E8 E2 E5 FF FF EA 01 00 A0 E3 04 40 95 E4 10 00 8D E5 82 FF FF EA 10 10 9D E5 18 20 9D E5 00 00 51 E3 22 30 A0 E3 00 70 E0 03 02 81 E0 03 00 70 A0 13 02 81 A0 13 00 30 82 E5 D7 FF FF EA 00 20 95 E5 78 00 52 E3 58 00 52 13 7B FF FF 1A 10 10 A0 E3 00 20 A0 E3 04 40 95 E5 06 00 8D E8 08 50 85 E2 10 A0 A0 E3 80 FF FF EA 08 10 A0 E3 00 20 A0 E3 06 00 8D E8 08 A0 A0 E3 7B FF FF EA 0A 20 A0 E1 C2 3F A0 E1 0C 00 8D E8 77 FF FF EA }
	condition:
		$1
}

rule file_133_0_0 {
	meta:
		name = "mempcpy"
		size = 240
	strings:
		$1 = { 0F 00 52 E3 30 00 2D E9 00 30 A0 E1 01 40 A0 E1 02 C0 A0 E1 02 00 00 9A 03 50 81 E1 03 00 15 E3 0A 00 00 0A 00 00 5C E3 06 00 00 0A 00 20 A0 E3 02 10 D4 E7 02 10 C0 E7 01 20 82 E2 0C 00 52 E1 FA FF FF 1A 02 00 80 E0 30 00 BD E8 1E FF 2F E1 02 40 A0 E1 01 C0 A0 E1 00 50 9C E5 00 50 80 E5 04 50 9C E5 04 50 80 E5 08 50 9C E5 08 50 80 E5 10 40 44 E2 0C 50 9C E5 0F 00 54 E3 0C 50 80 E5 10 C0 8C E2 10 00 80 E2 F2 FF FF 8A 10 20 42 E2 22 02 A0 E1 00 52 42 E0 01 00 80 E2 00 02 A0 E1 03 00 55 E3 00 40 81 E0 05 C0 A0 E1 00 00 83 E0 DB FF FF 9A 00 10 A0 E3 01 20 94 E7 01 20 80 E7 04 10 81 E2 05 20 61 E0 03 00 52 E3 F9 FF FF 8A 04 C0 45 E2 2C 21 A0 E1 01 30 82 E2 03 31 A0 E1 03 40 84 E0 02 C1 4C E0 03 00 80 E0 CC FF FF EA }
	condition:
		$1
}

rule file_134_0_0 {
	meta:
		name = "fcseeker"
		size = 112
		refs = "001c __errno"
	strings:
		$1 = { F0 40 2D E9 04 D0 4D E2 04 40 8D E2 01 50 A0 E1 03 70 A0 E1 04 20 24 E5 00 60 A0 E1 ?? ?? ?? ?? 00 30 A0 E3 00 30 80 E5 0D 10 A0 E1 07 20 A0 E1 00 00 95 E5 0F E0 A0 E1 10 F0 95 E5 00 00 50 E3 02 00 00 BA 00 00 9D E5 04 D0 8D E2 F0 80 BD E8 ?? ?? ?? ?? 00 30 90 E5 00 00 53 E3 F8 FF FF 0A ?? ?? ?? ?? 00 30 90 E5 00 30 86 E5 F4 FF FF EA }
	condition:
		$1
}

rule file_134_2_0 {
	meta:
		name = "fccloser"
		size = 108
		refs = "0018 __errno 0040 _free_r"
	strings:
		$1 = { 70 40 2D E9 14 40 91 E5 00 00 54 E3 01 50 A0 E1 00 60 A0 E1 07 00 00 0A ?? ?? ?? ?? 00 30 A0 E3 00 30 80 E5 00 00 95 E5 0F E0 A0 E1 14 F0 95 E5 00 40 50 E2 04 00 00 BA 06 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 70 80 BD E8 ?? ?? ?? ?? 00 30 90 E5 00 00 53 E3 F6 FF FF 0A ?? ?? ?? ?? 00 30 90 E5 00 30 86 E5 F2 FF FF EA }
	condition:
		$1
}

rule file_134_3_0 {
	meta:
		name = "fcwriter"
		size = 140
		refs = "003c __errno"
	strings:
		$1 = { 04 C0 91 E5 F0 40 2D E9 BC E0 DC E1 01 0C 1E E3 01 40 A0 E1 02 60 A0 E1 03 50 A0 E1 00 70 A0 E1 05 00 00 0A 28 C0 9C E5 00 00 5C E3 00 20 A0 13 02 30 A0 13 0F E0 A0 11 1C FF 2F 11 ?? ?? ?? ?? 00 30 A0 E3 00 30 80 E5 06 10 A0 E1 00 00 94 E5 05 20 A0 E1 0F E0 A0 E1 0C F0 94 E5 00 40 50 E2 01 00 00 BA 04 00 A0 E1 F0 80 BD E8 ?? ?? ?? ?? 00 30 90 E5 00 00 53 E3 F9 FF FF 0A ?? ?? ?? ?? 00 30 90 E5 00 30 87 E5 F5 FF FF EA }
	condition:
		$1
}

rule file_134_4_0 {
	meta:
		name = "_fopencookie_r"
		size = 288
		refs = "002c __sflags 0058 __sfp 006c _malloc_r 00f8 __sfp_lock_acquire 0108 __sfp_lock_release 0110 fcseeker 0114 fcreader 0118 fccloser 011c fcwriter"
	strings:
		$1 = { 04 D0 4D E2 F0 4F 2D E9 08 D0 4D E2 01 40 A0 E1 02 10 A0 E1 04 20 8D E2 2C 30 8D E5 03 80 A0 E1 00 50 A0 E1 30 60 8D E2 C0 04 96 E8 ?? ?? ?? ?? 00 B0 50 E2 0B 90 A0 01 22 00 00 0A 14 00 1B E3 25 00 00 1A 18 00 1B E3 01 00 00 0A 00 00 56 E3 23 00 00 0A 05 00 A0 E1 ?? ?? ?? ?? 00 90 50 E2 18 00 00 0A 05 00 A0 E1 18 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 1E 00 00 0A 90 30 9F E5 00 00 57 E3 00 30 A0 03 88 20 9F E5 28 30 89 E5 84 30 9F E5 20 20 89 E5 80 20 9F E5 2C 30 89 E5 00 30 E0 E3 00 40 80 E5 14 A0 80 E5 BC B0 C9 E1 08 80 80 E5 0C 60 80 E5 24 20 89 E5 04 90 80 E5 1C 00 89 E5 10 70 80 E5 BE 30 C9 E1 09 00 A0 E1 08 D0 8D E2 F0 4F BD E8 04 D0 8D E2 1E FF 2F E1 00 00 58 E3 D7 FF FF 1A 16 30 A0 E3 00 30 85 E5 00 90 A0 E3 F4 FF FF EA 00 00 8D E5 ?? ?? ?? ?? 00 00 9D E5 BC 00 C9 E1 00 90 A0 E1 ?? ?? ?? ?? ED FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_134_5_0 {
	meta:
		name = "fopencookie"
		size = 92
		refs = "0044 _fopencookie_r 0058 _impure_ptr"
	strings:
		$1 = { 08 D0 4D E2 10 40 2D E9 0C D0 4D E2 14 C0 8D E2 0C 00 8C E8 01 30 A0 E1 38 10 9F E5 18 20 8D E2 00 E0 91 E5 00 C0 A0 E1 07 00 92 E8 0D 40 A0 E1 07 00 84 E8 03 20 A0 E1 0E 00 A0 E1 0C 10 A0 E1 14 30 9D E5 ?? ?? ?? ?? 0C D0 8D E2 10 40 BD E8 08 D0 8D E2 1E FF 2F E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_137_0_0 {
	meta:
		name = "swab"
		size = 92
	strings:
		$1 = { 01 00 52 E3 30 00 2D E9 01 30 A0 D3 0C 00 00 DA 00 C0 A0 E3 01 30 A0 E3 0C 40 D0 E7 03 50 D0 E7 0C 50 C1 E7 03 40 C1 E7 02 30 83 E2 03 00 52 E1 02 C0 8C E2 F7 FF FF CA 02 30 42 E2 01 30 C3 E3 03 30 83 E2 02 00 53 E1 03 30 81 00 00 20 A0 03 01 20 43 05 30 00 BD E8 1E FF 2F E1 }
	condition:
		$1
}

rule file_138_0_0 {
	meta:
		name = "iswalpha"
		size = 36
		refs = "0020 __ctype_ptr__"
	strings:
		$1 = { FF 00 50 E3 14 30 9F 95 00 30 93 95 00 00 83 90 01 00 D0 95 00 00 A0 83 03 00 00 92 1E FF 2F E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_139_0_0 {
	meta:
		name = "envz_strip"
		size = 184
		refs = "0020 strchr 0038 argz_next 0058 realloc 0068 strlen 009c memmove"
	strings:
		$1 = { F0 40 2D E9 00 70 A0 E3 00 60 A0 E1 01 50 A0 E1 07 40 A0 E1 00 10 91 E5 00 00 90 E5 04 00 00 EA ?? ?? ?? ?? 00 00 50 E3 0D 00 00 0A 00 10 95 E5 00 00 96 E5 04 20 A0 E1 ?? ?? ?? ?? 00 40 50 E2 3D 10 A0 E3 F5 FF FF 1A 00 00 57 E3 F0 80 BD 08 00 10 95 E5 00 00 96 E5 ?? ?? ?? ?? 00 00 86 E5 F0 80 BD E8 04 00 A0 E1 ?? ?? ?? ?? 00 10 95 E5 00 70 A0 E1 00 00 96 E5 07 20 84 E0 01 30 80 E0 02 00 53 E1 01 70 87 E2 06 00 00 0A 03 30 64 E0 07 10 84 E0 03 20 67 E0 04 00 A0 E1 ?? ?? ?? ?? 00 10 95 E5 00 00 96 E5 01 10 67 E0 00 10 85 E5 01 70 A0 E3 DE FF FF EA }
	condition:
		$1
}

rule file_141_0_0 {
	meta:
		name = "nl_langinfo"
		size = 1088
		refs = "0104 free 011c __get_current_time_locale 0128 __get_current_monetary_locale 013c localeconv 016c strlen 017c realloc 0198 strcpy 01a4 __get_current_messages_locale 01bc __get_current_numeric_locale 01f4 setlocale 0204 strchr 0220 strncmp 0260 strcat 02fc strcmp 03b4 strstr"
	strings:
		$1 = { 70 40 2D E9 00 40 A0 E1 39 00 50 E3 00 F1 9F 97 3E 00 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 04 00 96 E5 00 00 50 E3 ?? ?? ?? ?? 00 30 A0 E3 04 30 86 E5 EC 42 9F E5 04 00 A0 E1 70 80 BD E8 ?? ?? ?? ?? E0 40 90 E5 FA FF FF EA ?? ?? ?? ?? 04 40 90 E5 00 30 D4 E5 00 00 53 E3 F4 FF FF 0A ?? ?? ?? ?? 2A 60 D0 E5 ?? ?? ?? ?? 2C 50 D0 E5 06 00 55 E1 EE FF FF 1A FF 00 55 E3 A1 00 00 0A 00 00 55 E3 2D 50 A0 13 2B 50 A0 03 04 00 A0 E1 ?? ?? ?? ?? 90 62 9F E5 02 10 80 E2 04 00 96 E5 ?? ?? ?? ?? 00 30 50 E2 DC FF FF 0A 03 00 A0 E1 04 30 86 E5 04 10 A0 E1 01 50 C0 E4 ?? ?? ?? ?? 04 40 96 E5 DB FF FF EA ?? ?? ?? ?? 0C 40 90 E5 D8 FF FF EA ?? ?? ?? ?? 08 40 90 E5 D5 FF FF EA ?? ?? ?? ?? 00 40 90 E5 D2 FF FF EA ?? ?? ?? ?? 04 40 90 E5 CF FF FF EA ?? ?? ?? ?? 00 40 90 E5 CC FF FF EA ?? ?? ?? ?? 04 40 90 E5 C9 FF FF EA 02 00 A0 E3 00 10 A0 E3 ?? ?? ?? ?? 00 60 50 E2 C3 FF FF 0A 2E 10 A0 E3 ?? ?? ?? ?? 00 50 50 E2 5A 00 00 0A 01 40 85 E2 04 00 A0 E1 EC 11 9F E5 04 20 A0 E3 ?? ?? ?? ?? 00 00 50 E3 31 00 00 1A 04 00 A0 E1 ?? ?? ?? ?? CC 61 9F E5 00 10 A0 E1 00 00 96 E5 ?? ?? ?? ?? 00 30 50 E2 5E 00 00 0A BC 11 9F E5 00 30 86 E5 ?? ?? ?? ?? 05 10 85 E2 00 00 96 E5 ?? ?? ?? ?? 00 40 96 E5 A9 FF FF EA ?? ?? ?? ?? A0 40 90 E5 A6 FF FF EA ?? ?? ?? ?? 9C 40 90 E5 A3 FF FF EA ?? ?? ?? ?? 98 40 90 E5 A0 FF FF EA ?? ?? ?? ?? E4 40 90 E5 9D FF FF EA ?? ?? ?? ?? A4 40 90 E5 9A FF FF EA ?? ?? ?? ?? A8 40 90 E5 97 FF FF EA ?? ?? ?? ?? 18 40 84 E2 04 41 90 E7 93 FF FF EA ?? ?? ?? ?? 0A 40 84 E2 04 41 90 E7 8F FF FF EA ?? ?? ?? ?? 09 40 44 E2 04 41 90 E7 8B FF FF EA ?? ?? ?? ?? 21 40 44 E2 04 41 90 E7 87 FF FF EA 04 00 A0 E1 14 11 9F E5 ?? ?? ?? ?? 00 00 50 E3 15 00 00 1A 06 00 A0 E1 04 11 9F E5 05 20 A0 E3 ?? ?? ?? ?? 00 00 50 E3 F8 40 9F 05 7B FF FF 0A 06 00 A0 E1 F0 10 9F E5 05 20 A0 E3 ?? ?? ?? ?? 00 00 50 E3 E4 40 9F 05 74 FF FF 0A 06 00 A0 E1 DC 10 9F E5 05 20 A0 E3 ?? ?? ?? ?? D4 30 9F E5 00 00 50 E3 03 40 A0 01 6C FF FF EA 04 00 A0 E1 C4 10 9F E5 ?? ?? ?? ?? C0 30 9F E5 00 00 50 E3 03 40 A0 01 65 FF FF EA 06 00 A0 E1 B0 10 9F E5 ?? ?? ?? ?? 00 00 50 E3 01 00 00 1A 9C 40 9F E5 5E FF FF EA 06 00 A0 E1 98 10 9F E5 ?? ?? ?? ?? 00 00 50 E3 F8 FF FF 0A 06 00 A0 E1 78 10 9F E5 ?? ?? ?? ?? 00 00 50 E3 53 FF FF 0A 6C 40 9F E5 52 FF FF EA 00 00 96 E5 00 00 50 E3 ?? ?? ?? ?? 00 30 A0 E3 00 30 86 E5 20 40 9F E5 4B FF FF EA ?? ?? ?? ?? 08 10 90 E5 04 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 2E 50 A0 03 59 FF FF 0A 42 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_142_0_0 {
	meta:
		name = "_putchar_unlocked_r"
		size = 16
		refs = "000c putc_unlocked"
	strings:
		$1 = { 08 30 90 E5 01 00 A0 E1 03 10 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_143_0_0 {
	meta:
		name = "mblen"
		size = 44
	strings:
		$1 = { 00 00 50 E3 02 00 00 0A 00 30 D0 E5 00 00 53 E3 01 00 00 1A 00 00 A0 E3 1E FF 2F E1 00 00 51 E3 00 00 E0 03 01 00 A0 13 1E FF 2F E1 }
	condition:
		$1
}

rule file_144_0_0 {
	meta:
		name = "scalbnf"
		size = 296
		refs = "0038 __mulsf3 0094 __addsf3 00cc copysignf"
	strings:
		$1 = { 02 C1 D0 E3 10 40 2D E9 00 30 A0 E1 00 20 A0 E1 01 40 A0 E1 1B 00 00 0A 02 11 E0 E3 02 15 41 E2 01 00 5C E1 19 00 00 8A 02 05 5C E3 AC CB A0 21 0C 00 00 2A 13 13 A0 E3 ?? ?? ?? ?? C3 2C E0 E3 4F 20 42 E2 02 00 54 E1 00 30 A0 E1 1F 00 00 BA 02 C1 C0 E3 AC CB A0 E1 8C CB A0 E1 CC CB A0 E1 00 20 A0 E1 19 C0 4C E2 04 C0 8C E0 FE 00 5C E3 1C 00 00 CA 00 00 5C E3 7F 24 C2 C3 02 25 C2 C3 8C 3B 82 C1 06 00 00 DA 03 00 A0 E1 10 80 BD E8 00 10 A0 E1 ?? ?? ?? ?? 00 30 A0 E1 03 00 A0 E1 10 80 BD E8 16 00 7C E3 15 00 00 AA C3 2C A0 E3 50 20 82 E2 02 00 54 E1 0A 00 00 CA DA 06 A0 E3 09 09 80 E2 03 10 A0 E1 26 0E 80 E2 ?? ?? ?? ?? DA 16 A0 E3 09 19 81 E2 26 1E 81 E2 ?? ?? ?? ?? 00 30 A0 E1 E7 FF FF EA 03 10 A0 E1 30 00 9F E5 ?? ?? ?? ?? 28 10 9F E5 ?? ?? ?? ?? 00 30 A0 E1 E0 FF FF EA 7F 24 C2 E3 19 00 8C E2 02 25 C2 E3 80 0B 82 E1 33 14 A0 E3 ?? ?? ?? ?? 00 30 A0 E1 D8 FF FF EA CA F2 49 71 }
	condition:
		$1
}

rule file_145_0_0 {
	meta:
		name = "argz_next"
		size = 72
	strings:
		$1 = { 00 00 52 E3 0B 00 00 0A 00 30 D2 E5 00 00 53 E3 02 00 00 0A 01 30 F2 E5 00 00 53 E3 FC FF FF 1A 01 20 82 E2 01 00 80 E0 00 00 52 E1 00 20 A0 23 02 00 A0 E1 1E FF 2F E1 00 00 51 E3 00 20 A0 11 02 00 A0 E1 1E FF 2F E1 }
	condition:
		$1
}

rule file_146_0_0 {
	meta:
		name = "__ssrefill_r"
		size = 104
		refs = "001c _free_r"
	strings:
		$1 = { 10 40 2D E9 01 40 A0 E1 30 10 91 E5 00 00 51 E3 0B 00 00 0A 40 30 84 E2 03 00 51 E1 ?? ?? ?? ?? 3C 30 94 E5 00 00 A0 E3 00 00 53 E3 30 00 84 E5 04 30 84 E5 02 00 00 0A 38 30 94 E5 00 30 84 E5 10 80 BD E8 BC 20 D4 E1 10 30 94 E5 20 20 82 E3 00 30 84 E5 00 30 A0 E3 BC 20 C4 E1 04 30 84 E5 00 00 E0 E3 10 80 BD E8 }
	condition:
		$1
}

rule file_146_1_0 {
	meta:
		name = "_sungetc_r"
		size = 256
		refs = "00e8 __submore"
	strings:
		$1 = { 30 40 2D E9 01 00 71 E3 04 D0 4D E2 12 00 00 0A BC 30 D2 E1 30 C0 92 E5 20 30 C3 E3 00 00 5C E3 BC 30 C2 E1 FF 40 01 E2 0E 00 00 0A 04 10 92 E5 34 30 92 E5 03 00 51 E1 28 00 00 AA 00 30 92 E5 01 10 43 E2 00 10 82 E5 01 40 43 E5 04 30 92 E5 01 30 83 E2 04 30 82 E5 04 10 A0 E1 01 00 A0 E1 04 D0 8D E2 30 80 BD E8 10 30 92 E5 00 00 53 E3 00 00 92 05 06 00 00 0A 00 00 92 E5 00 00 53 E1 03 00 00 2A 01 10 50 E5 04 00 51 E1 01 30 40 E2 0D 00 00 0A 02 30 A0 E1 04 C0 92 E5 40 10 82 E2 42 40 E3 E5 01 50 A0 E3 30 10 82 E5 03 10 A0 E3 34 10 82 E5 04 50 82 E5 3C C0 82 E5 38 00 82 E5 00 30 82 E5 04 10 A0 E1 E3 FF FF EA 04 00 92 E5 01 00 80 E2 04 00 82 E5 00 30 82 E5 DE FF FF EA 02 10 A0 E1 00 20 8D E5 ?? ?? ?? ?? 00 00 50 E3 00 20 9D E5 00 10 E0 13 D7 FF FF 1A CE FF FF EA }
	condition:
		$1
}

rule file_146_2_0 {
	meta:
		name = "__ssvfscanf_r"
		size = 5144
		refs = "0714 memset 0730 _mbrtowc_r 0918 _strtol_r 0948 sprintf 0a24 __sccl 0f3c memcpy 0fd8 __ctype_ptr__ 0fe8 _strtoul_r 0fec __mb_cur_max 1184 _strtod_r 1244 iswspace 131c __isnand 133c __truncdfsf2 140c nanf"
	strings:
		$1 = { F0 4F 2D E9 01 40 A0 E1 BC 10 D1 E1 02 0A 11 E3 AA DF 4D E2 03 90 A0 E1 02 1A 81 03 64 30 94 05 BC 10 C4 01 19 1E 8D E2 00 80 A0 E1 02 3A C3 03 00 00 A0 E3 02 70 A0 E1 01 10 41 E2 3C 20 8D E2 64 30 84 05 18 00 8D E5 88 6F 9F E5 28 10 8D E5 20 00 8D E5 14 00 8D E5 04 20 8D E5 00 50 A0 E1 00 10 D7 E5 00 00 51 E3 A4 12 8D E5 1F 00 00 0A 00 20 96 E5 01 30 82 E0 01 30 D3 E5 08 30 13 E2 01 70 87 E2 1C 00 00 0A 04 20 94 E5 0C 00 00 EA 00 30 94 E5 00 10 96 E5 00 20 D3 E5 02 20 81 E0 01 20 D2 E5 08 00 12 E3 EC FF FF 0A 04 20 94 E5 01 30 83 E2 01 20 42 E2 00 30 84 E5 04 20 84 E5 01 50 85 E2 00 00 52 E3 F0 FF FF CA 08 00 A0 E1 04 10 A0 E1 6F FF FF EB 00 00 50 E3 EB FF FF 0A 00 10 D7 E5 00 00 51 E3 A4 12 8D E5 DF FF FF 1A 14 00 9D E5 AA DF 8D E2 F0 8F BD E8 25 00 51 E3 1B 00 00 0A 04 30 94 E5 00 00 53 E3 0B 00 00 DA 00 30 94 E5 01 20 57 E5 00 10 D3 E5 02 00 51 E1 F2 FF FF 1A 04 20 94 E5 01 30 83 E2 01 20 42 E2 04 20 84 E5 00 30 84 E5 01 50 85 E2 C7 FF FF EA 08 00 A0 E1 04 10 A0 E1 52 FF FF EB 00 00 50 E3 EE FF FF 0A 14 00 9D E5 00 00 50 E3 02 00 00 0A BC 30 D4 E1 40 00 13 E3 E1 FF FF 0A 00 00 E0 E3 DF FF FF EA 03 B0 A0 E1 0A 00 A0 E3 01 10 D7 E4 78 00 51 E3 01 F1 9F 97 78 00 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 01 20 82 E0 01 20 D2 E5 5C 0C 9F E5 0A 10 A0 E3 01 00 12 E3 18 00 8D E5 20 10 8D E5 01 B0 8B 13 03 A0 A0 E1 03 20 A0 E3 04 10 94 E5 00 00 51 E3 D0 02 00 DA 40 00 1B E3 00 10 94 05 03 C0 A0 01 12 00 00 0A 01 20 42 E2 03 00 52 E3 02 F1 9F 97 A4 00 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 08 00 A0 E1 04 10 A0 E1 0C 20 8D E5 08 C0 8D E5 AB FE FF EB 00 00 50 E3 0C 20 9D E5 08 C0 9D E5 56 FF FF 1A 00 10 94 E5 01 50 85 E2 00 30 D1 E5 00 00 96 E5 03 30 80 E0 01 30 D3 E5 08 00 13 E3 A6 01 00 0A 04 30 94 E5 01 30 43 E2 00 00 53 E3 01 10 81 C2 04 30 84 E5 00 10 84 C5 E7 FF FF DA 01 50 85 E2 F0 FF FF EA 01 20 43 E2 57 0F 52 E3 57 3F 43 82 00 C0 A0 E3 00 30 A0 93 57 AF A0 83 01 30 43 82 10 C0 8D E5 05 20 A0 E1 3C C0 8D E2 20 50 9D E5 1C 70 8D E5 24 90 8D E5 01 A0 8A 82 36 BD 8B E3 03 70 A0 E1 0C 90 A0 E1 00 30 94 E5 00 10 D3 E5 39 00 51 E3 8A 01 00 8A 38 00 51 E3 C3 01 00 3A 40 0B 9F E5 85 50 A0 E1 F5 50 90 E1 08 00 55 E3 89 01 00 DA 2E BD CB E3 01 10 C9 E4 04 10 94 E5 01 10 41 E2 00 00 51 E3 04 10 84 E5 01 10 83 C2 00 10 84 C5 7D 02 00 DA 01 A0 5A E2 E9 FF FF 1A 7D 01 00 EA 30 10 41 E2 90 13 23 E0 24 FF FF EA 00 00 53 E3 03 A0 A0 11 00 A0 E0 03 01 30 1B E2 2C 02 00 0A 10 B0 1B E2 00 00 99 05 A9 CF 8D 12 10 C0 8D 15 10 00 8D 05 1C B0 8D E5 04 90 89 02 00 B0 A0 E3 00 30 94 E5 00 20 96 E5 00 C0 D3 E5 0C 20 82 E0 01 20 D2 E5 A2 21 A0 E1 01 20 22 E2 00 00 5A E3 00 20 A0 03 01 20 02 12 00 00 52 E3 1B 03 00 1A 1C 10 9D E5 00 00 51 E3 C1 FE FF 1A 10 20 9D E5 00 10 82 E5 C6 02 00 EA 00 00 53 E3 03 A0 A0 11 00 A0 E0 03 10 00 1B E3 00 10 94 15 00 B0 A0 13 23 00 00 1A 00 B0 99 E5 00 20 94 E5 0B C0 A0 E1 00 20 D2 E5 AA 3F 8D E2 02 20 83 E0 0C 21 52 E5 00 00 52 E3 81 03 00 0A 04 20 94 E5 01 20 42 E2 04 20 84 E5 00 20 94 E5 01 10 D2 E4 01 A0 5A E2 01 10 CB E4 00 20 84 E5 78 03 00 0A 04 10 94 E5 00 00 51 E3 ED FF FF CA 08 00 A0 E1 04 10 A0 E1 08 C0 8D E5 2C FE FF EB 00 00 50 E3 08 C0 9D E5 27 02 00 1A 00 20 94 E5 E4 FF FF EA 08 00 A0 E1 04 10 A0 E1 24 FE FF EB 00 00 50 E3 2C 02 00 1A 00 10 94 E5 00 30 D1 E5 AA 2F 8D E2 03 30 82 E0 0C 31 53 E5 00 00 53 E3 01 10 81 E2 5B 03 00 0A 04 30 94 E5 01 B0 8B E2 01 30 43 E2 0B 00 5A E1 0A 00 84 E8 1E 02 00 0A 00 00 53 E3 F0 FF FF CA E9 FF FF EA 10 B0 8B E3 C8 FE FF EA 00 00 53 E3 03 A0 A0 11 01 A0 A0 03 01 30 1B E2 28 02 00 0A 10 B0 1B E2 00 C0 99 05 00 C0 A0 13 10 B0 8D E5 1C 70 8D E5 04 90 89 02 05 70 A0 E1 00 B0 A0 E3 0C 50 A0 E1 0E 00 00 EA 10 00 9D E5 00 00 50 E3 00 00 85 05 10 10 9D E5 00 00 51 E3 0B 70 87 E0 10 B0 9D 05 01 A0 4A E2 00 B0 A0 13 04 50 85 02 04 30 94 E5 00 00 53 E3 61 02 00 DA 00 00 5A E3 2F 03 00 0A 14 29 9F E5 00 30 92 E5 03 00 5B E1 9C FE FF 0A 00 30 94 E5 04 20 94 E5 01 C0 D3 E4 AA 0F 8D E2 00 30 84 E5 01 20 42 E2 0B 30 80 E0 04 20 84 E5 00 10 A0 E3 6C C2 43 E5 08 20 A0 E3 01 B0 8B E2 A7 0F 8D E2 ?? ?? ?? ?? A7 CF 8D E2 08 00 A0 E1 05 10 A0 E1 3C 20 8D E2 0B 30 A0 E1 00 C0 8D E5 ?? ?? ?? ?? 01 00 70 E3 85 FE FF 0A 00 00 50 E3 D3 FF FF 0A 02 00 70 E3 DB FF FF 0A D3 FF FF EA 01 20 43 E2 57 0F 52 E3 57 3F 43 82 00 30 A0 93 01 30 43 82 24 30 8D 95 24 30 8D 85 00 30 A0 E3 57 AF A0 83 3C C0 8D E2 1C 30 8D E5 30 30 8D E5 10 30 8D E5 2C 30 8D E5 34 70 8D E5 38 90 8D E5 01 A0 8A 82 1E BD 8B E3 03 20 A0 E1 03 70 A0 E1 0C 90 A0 E1 00 C0 94 E5 00 10 DC E5 4E 00 51 E3 07 01 00 0A DB 00 00 8A 39 00 51 E3 F0 00 00 8A 31 00 51 E3 63 01 00 2A 2E 00 51 E3 46 02 00 0A 37 02 00 8A 2B 00 51 E3 2C 02 00 0A 2D 00 51 E3 2A 02 00 0A 10 10 9D E5 01 20 42 E2 00 00 51 E3 01 BC CB 13 01 00 52 E3 09 C0 A0 E1 07 30 A0 E1 34 70 8D E2 80 02 97 E8 D7 02 00 9A 01 20 43 E2 06 00 52 E3 1D 00 00 8A 02 00 53 E3 C9 02 00 9A 00 00 A0 E3 34 B0 8D E5 03 A0 A0 E1 05 B0 A0 E1 24 00 8D E5 0C 50 A0 E1 08 00 00 EA 24 20 9D E5 08 00 A0 E1 02 10 D5 E7 04 20 A0 E1 08 30 8D E5 01 A0 4A E2 A9 FD FF EB 08 30 9D E5 FF A0 0A E2 24 C0 9D E5 03 00 5A E3 01 C0 4C E2 24 C0 8D E5 F1 FF FF 1A 03 30 43 E2 05 C0 A0 E1 FF 30 03 E2 0B 50 A0 E1 34 B0 9D E5 0C C0 63 E0 05 50 63 E0 01 0C 1B E3 12 00 00 0A 01 0B 1B E3 92 02 00 1A 01 10 7C E5 45 00 51 E3 65 00 51 13 01 50 45 E2 06 00 00 0A 08 00 A0 E1 04 20 A0 E1 08 C0 8D E5 8E FD FF EB 08 C0 9D E5 01 10 7C E5 01 50 45 E2 08 00 A0 E1 04 20 A0 E1 08 C0 8D E5 87 FD FF EB 08 C0 9D E5 10 20 1B E2 DC FD FF 1A 06 3C 0B E2 01 0B 53 E3 00 20 CC E5 18 02 00 0A 30 C0 9D E5 00 00 5C E3 1B 02 00 0A 1C 30 9D E5 08 00 A0 E1 01 10 83 E2 0A 30 A0 E3 ?? ?? ?? ?? 30 A0 9D E5 00 20 6A E0 1C C0 9D E5 28 00 9D E5 00 00 5C E1 3C 10 8D 22 15 1E 81 22 02 10 81 22 1C 10 8D 25 9C 16 9F E5 1C 00 9D E5 ?? ?? ?? ?? 09 02 00 EA 90 C6 9F E5 0A 00 A0 E3 03 A0 A0 E1 18 C0 8D E5 20 00 8D E5 03 20 A0 E3 8A FE FF EA 03 A0 A0 E1 02 20 A0 E3 87 FE FF EA 68 26 9F E5 10 C0 A0 E3 18 20 8D E5 22 BE 8B E3 03 A0 A0 E1 20 C0 8D E5 03 20 A0 E3 7F FE FF EA 48 16 9F E5 08 20 A0 E3 20 20 8D E5 03 A0 A0 E1 18 10 8D E5 03 20 A0 E3 78 FE FF EA 2C 26 9F E5 08 C0 A0 E3 18 20 8D E5 01 B0 8B E3 03 A0 A0 E1 20 C0 8D E5 03 20 A0 E3 70 FE FF EA 02 B0 8B E3 E7 FD FF EA 03 A0 A0 E1 04 20 A0 E3 6B FE FF EA 01 B0 8B E3 E8 A5 9F E5 0A C0 A0 E3 18 A0 8D E5 20 C0 8D E5 03 A0 A0 E1 03 20 A0 E3 63 FE FF EA 40 B0 8B E3 03 A0 A0 E1 00 20 A0 E3 5F FE FF EA 07 10 A0 E1 67 0F 8D E2 08 30 8D E5 ?? ?? ?? ?? 08 30 9D E5 40 B0 8B E3 00 70 A0 E1 03 A0 A0 E1 01 20 A0 E3 55 FE FF EA A0 05 9F E5 10 10 A0 E3 02 BC 8B E3 03 A0 A0 E1 18 00 8D E5 20 10 8D E5 03 20 A0 E3 4D FE FF EA 10 00 1B E3 7D FD FF 1A 04 00 1B E3 00 30 99 15 00 30 99 05 B0 50 C3 11 04 90 89 12 00 50 83 05 04 90 89 02 75 FD FF EA 01 B0 8B E3 BA FD FF EA 44 05 9F E5 00 10 A0 E3 18 00 8D E5 03 A0 A0 E1 20 10 8D E5 03 20 A0 E3 3A FE FF EA 04 B0 8B E3 B1 FD FF EA 0C 30 A0 E1 3D FE FF EA 58 00 51 E3 B3 00 00 0A AC 00 00 8A 41 00 41 E2 05 00 50 E3 A5 00 00 9A 01 0C 1B E3 09 C0 A0 E1 20 50 8D E5 1C 70 9D E5 02 50 A0 E1 24 90 9D E5 05 00 00 0A 04 10 9D E5 01 00 5C E1 F4 01 00 8A 04 20 9D E5 02 00 5C E1 79 FD FF 0A 10 20 1B E2 7C 01 00 0A 04 10 9D E5 10 20 9D E5 05 50 61 E0 02 50 85 E0 05 50 8C E0 4D FD FF EA 66 00 51 E3 81 00 00 0A 73 00 00 8A 59 00 51 E3 6D 00 00 0A 51 00 00 8A 54 00 51 E3 26 FF FF 1A 06 00 57 E3 24 FF FF 1A 01 70 87 E2 01 10 C9 E4 04 10 94 E5 01 10 41 E2 00 00 51 E3 01 C0 8C C2 01 50 85 E2 04 10 84 E5 00 C0 84 C5 3B 00 00 DA 01 A0 5A E2 08 FF FF 1A 17 FF FF EA 45 00 51 E3 42 00 00 0A 43 01 00 8A 41 00 51 E3 12 FF FF 1A 01 00 52 E3 10 FF FF 1A 01 20 82 E2 EA FF FF EA 30 00 51 E3 1D 00 00 0A 17 00 00 8A 2B 00 51 E3 01 00 00 0A 2D 00 51 E3 C3 FF FF 1A 80 00 1B E3 C1 FF FF 0A 80 B0 CB E3 36 FE FF EA 00 00 52 E3 05 00 00 1A 07 0C 0B E2 07 0C 50 E3 1E BD CB 03 01 20 82 02 02 00 00 1A D7 FF FF EA 02 00 52 E3 E8 FF FF 0A 01 00 57 E3 04 00 57 13 F6 FE FF 1A 01 70 87 E2 FF 70 07 E2 CF FF FF EA C4 C3 9F E5 85 50 A0 E1 F5 50 9C E1 2E BD CB E3 21 FE FF EA 02 0B 1B E3 1F FE FF 0A 00 00 55 E3 02 BC 8B 03 08 50 85 02 01 0B 1B E3 16 BD CB 13 19 FE FF 1A 10 00 9D E5 00 00 57 E3 01 00 80 E2 01 70 47 12 01 A0 8A 12 0E BD CB E3 10 00 8D E5 12 FE FF EA 08 00 A0 E1 04 10 A0 E1 0C 20 8D E5 87 FC FF EB 00 00 50 E3 0C 20 9D E5 BC FF FF 0A D6 FE FF EA 61 00 51 E3 C1 FF FF 0A 65 00 51 E3 D2 FE FF 1A 05 0C 0B E2 01 0B 50 E3 04 00 00 0A 10 30 9D E5 00 00 53 E2 01 00 A0 13 2B 05 10 E0 CA FE FF 0A 02 0C 1B E3 10 00 9D 05 2C 30 9D 05 00 00 63 00 30 00 8D 05 1E BD CB E3 00 00 A0 E3 1C 90 8D 05 06 BD 8B E3 10 00 8D E5 9B FF FF EA 74 00 51 E3 96 FF FF 0A 79 00 51 E3 BB FE FF 1A 07 00 57 E3 B9 FE FF 1A 01 70 87 E2 93 FF FF EA 6E 00 51 E3 B1 FF FF 0A F4 FF FF 8A 69 00 51 E3 B2 FE FF 1A 00 00 57 E3 09 00 00 1A 07 0C 0B E2 07 0C 50 E3 AD FE FF 1A 1E BD CB E3 01 70 87 E2 86 FF FF EA 02 00 57 E3 A8 FE FF 1A 01 70 87 E2 82 FF FF EA 03 00 57 E3 05 00 57 13 AC FF FF 0A A2 FE FF EA 02 00 87 E0 00 00 50 E3 9F FE FF 1A 06 BD CB E3 79 FF FF EA 0A 00 55 E3 57 FF FF DA 2E BD CB E3 CC FD FF EA 61 00 51 E3 53 FF FF 3A 66 00 51 E3 F7 FF FF 9A 78 00 51 E3 4F FF FF 1A 06 0C 0B E2 02 0C 50 E3 4C FF FF 1A 02 BC CB E3 05 BC 8B E3 10 50 A0 E3 BF FD FF EA 10 00 1B E3 03 B0 A0 11 00 10 94 15 23 00 00 1A 00 30 99 E5 00 20 94 E5 03 B0 A0 E1 00 20 D2 E5 00 10 96 E5 02 20 81 E0 01 20 D2 E5 08 00 12 E3 74 01 00 1A 04 20 94 E5 01 20 42 E2 04 20 84 E5 00 20 94 E5 01 10 D2 E4 01 A0 5A E2 01 10 CB E4 00 20 84 E5 6B 01 00 0A 04 10 94 E5 00 00 51 E3 ED FF FF CA 08 00 A0 E1 04 10 A0 E1 08 30 8D E5 1C FC FF EB 00 00 50 E3 08 30 9D E5 61 01 00 1A 00 20 94 E5 E4 FF FF EA 08 00 A0 E1 04 10 A0 E1 14 FC FF EB 00 00 50 E3 1C 00 00 1A 00 10 94 E5 00 30 D1 E5 00 20 96 E5 03 30 82 E0 01 30 D3 E5 08 00 13 E3 01 10 81 E2 14 00 00 1A 04 30 94 E5 01 B0 8B E2 01 30 43 E2 0B 00 5A E1 0A 00 84 E8 0E 00 00 0A 00 00 53 E3 F0 FF FF CA E9 FF FF EA 0B 30 A0 E1 03 00 5C E1 0C B0 A0 E1 AC FC FF 0A 0B B0 53 E0 91 FC FF 0A 00 20 A0 E3 00 20 C3 E5 14 A0 9D E5 01 A0 8A E2 14 A0 8D E5 04 90 89 E2 0B 50 85 E0 65 FC FF EA 08 00 A0 E1 04 10 A0 E1 0C 20 8D E5 EF FB FF EB 00 00 50 E3 0C 20 9D E5 7A FD FF 0A FA FE FF EA 08 00 A0 E1 04 10 A0 E1 0C 20 8D E5 08 30 8D E5 E6 FB FF EB 00 00 50 E3 0C 20 9D E5 08 30 9D E5 25 FD FF 0A 90 FC FF EA 10 B0 1B E2 2C 00 00 1A 00 C0 99 E5 0A B0 A0 E1 10 A0 8D E5 05 30 A0 E1 07 A0 A0 E1 0C 70 A0 E1 0E 00 00 EA 00 10 94 E5 08 30 8D E5 ?? ?? ?? ?? 00 20 94 E5 00 C0 A0 E3 05 20 82 E0 04 10 84 E8 08 00 A0 E1 04 10 A0 E1 CE FB FF EB 00 00 50 E3 0B B0 65 E0 08 30 9D E5 1B 01 00 1A 05 70 87 E0 04 50 94 E5 05 00 5B E1 07 00 A0 E1 05 20 A0 E1 EB FF FF 8A 0B 20 A0 E1 00 10 94 E5 03 50 A0 E1 0A 70 A0 E1 10 A0 9D E5 ?? ?? ?? ?? 04 20 94 E5 00 30 94 E5 02 20 6B E0 0B 30 83 E0 04 20 84 E5 00 30 84 E5 14 00 9D E5 01 00 80 E2 05 50 8A E0 04 90 89 E2 14 00 8D E5 24 FC FF EA 03 B0 A0 E1 05 C0 A0 E1 0F 00 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 20 94 E5 05 20 82 E0 00 20 84 E5 08 C0 8D E5 }
	condition:
		$1
}

rule file_147_1_0 {
	meta:
		name = "_svfprintf_r"
		size = 7652
		refs = "0018 _localeconv_r 05ec __isinfd 0608 __ltdf2 08dc memchr 0d70 __eqdf2 1038 __nedf2 16fc __isnand 17c8 _dtoa_r 197c _malloc_r 1ae8 strlen"
	strings:
		$1 = { F0 4F 2D E9 FC D0 4D E2 01 B0 A0 E1 03 90 A0 E1 02 70 A0 E1 2C 00 8D E5 ?? ?? ?? ?? BC 30 DB E1 00 00 90 E5 80 00 13 E3 5C 00 8D E5 02 00 00 0A 10 30 9B E5 00 00 53 E3 4D 06 00 0A A0 00 8D E2 00 30 A0 E3 00 20 A0 E3 60 C0 8D E2 00 40 A0 E3 28 00 80 E2 E3 10 8D E2 CC 20 8D E5 C8 C0 8D E5 D0 20 8D E5 30 30 8D E5 50 40 8D E5 4C 30 8D E5 58 30 8D E5 54 30 8D E5 24 30 8D E5 48 00 8D E5 10 10 8D E5 0C 60 A0 E1 00 30 D7 E5 00 00 53 E3 25 00 53 13 16 00 00 0A 07 80 A0 E1 01 30 F8 E5 25 00 53 E3 00 00 53 13 FB FF FF 1A 07 A0 58 E0 08 70 A0 01 0E 00 00 0A CC 40 8D E2 30 00 94 E8 01 40 84 E2 07 00 54 E3 0A 50 85 E0 80 04 86 E8 D0 50 8D E5 CC 40 8D E5 08 60 86 D2 70 00 00 CA 24 20 9D E5 0A 20 82 E0 00 30 D8 E5 24 20 8D E5 08 70 A0 E1 00 00 53 E3 71 00 00 0A 00 00 A0 E3 00 30 A0 E3 00 C0 A0 E3 18 90 8D E5 14 00 8D E5 20 30 8D E5 FB C0 CD E5 01 30 87 E2 00 40 E0 E3 2B 10 A0 E3 20 C0 A0 E3 03 70 A0 E1 01 20 D7 E4 20 30 42 E2 58 00 53 E3 03 F1 9F 97 F0 00 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 2C 00 9D E5 0B 10 A0 E1 C8 20 8D E2 F1 FE FF EB 00 00 50 E3 07 00 00 1A 60 60 8D E2 86 FF FF EA D0 30 9D E5 00 00 53 E3 2C 00 9D 15 0B 10 A0 11 C8 20 8D 12 E7 FE FF 1B BC 30 DB E1 24 00 9D E5 40 00 13 E3 00 00 E0 13 24 00 8D E5 24 00 9D E5 FC D0 8D E2 F0 8F BD E8 40 20 8D E5 14 20 9D E5 B0 1F 9F E5 10 00 12 E3 58 10 8D E5 3F 01 00 0A 18 C0 9D E5 00 30 9C E5 04 90 8C E2 14 C0 9D E5 00 10 53 E2 01 10 A0 13 01 00 1C E1 14 10 9D 15 40 00 9D 15 30 20 A0 13 02 10 81 13 F9 00 CD 15 F8 20 CD 15 14 10 8D 15 02 20 A0 E3 01 10 A0 13 00 C0 A0 E3 FB C0 CD E5 00 00 54 E3 14 00 9D A5 80 00 C0 A3 14 00 8D A5 00 00 54 E3 01 10 81 13 00 00 51 E3 C0 02 00 0A 01 00 52 E3 B7 03 00 0A 02 00 52 E3 A7 03 00 0A 48 10 9D E5 34 10 8D E5 07 20 03 E2 30 20 82 E2 A3 31 B0 E1 01 20 61 E5 FA FF FF 1A 14 30 9D E5 01 00 13 E3 34 10 8D E5 18 04 00 1A 48 C0 9D E5 0C C0 61 E0 28 C0 8D E5 28 10 9D E5 04 00 51 E1 04 10 A0 B1 1C 10 8D E5 44 40 8D E5 18 90 8D E5 FB 30 DD E5 00 00 53 E3 02 00 00 0A 1C 20 9D E5 01 20 82 E2 1C 20 8D E5 14 30 9D E5 02 30 13 E2 1C C0 9D 15 14 00 9D E5 02 C0 8C 12 1C C0 8D 15 84 00 10 E2 3C 30 8D E5 38 00 8D E5 8C 01 00 1A 20 10 9D E5 1C 20 9D E5 01 80 62 E0 00 00 58 E3 87 01 00 DA 10 00 58 E3 B3 05 00 DA CC 40 8D E2 30 00 94 E8 04 30 A0 E1 94 AE 9F E5 10 90 A0 E3 2C 40 9D E5 02 00 00 EA 10 80 48 E2 10 00 58 E3 14 00 00 DA 01 30 83 E2 07 00 53 E3 10 50 85 E2 00 A0 86 E5 04 90 86 E5 D0 50 8D E5 CC 30 8D E5 08 60 86 D2 F3 FF FF DA 04 00 A0 E1 0B 10 A0 E1 C8 20 8D E2 79 FE FF EB 00 00 50 E3 8F FF FF 1A 10 80 48 E2 10 00 58 E3 CC 30 8D E2 28 00 93 E8 60 60 8D E2 EA FF FF CA 03 40 A0 E1 01 40 84 E2 08 50 85 E0 07 00 54 E3 00 A0 86 E5 04 80 86 E5 D0 50 8D E5 CC 40 8D E5 08 60 86 D2 5E 01 00 DA 2C 00 9D E5 0B 10 A0 E1 C8 20 8D E2 63 FE FF EB 00 00 50 E3 79 FF FF 1A CC 40 8D E2 30 00 94 E8 60 60 8D E2 54 01 00 EA 00 00 52 E3 40 20 8D E5 6C FF FF 0A 40 30 9D E5 01 20 A0 E3 00 C0 A0 E3 A0 00 8D E2 1C 20 8D E5 A0 30 CD E5 FB C0 CD E5 28 20 8D E5 34 00 8D E5 00 10 A0 E3 44 10 8D E5 AC FF FF EA FB 30 DD E5 00 00 53 E3 BD 03 00 1A 18 20 9D E5 FB C0 CD E5 07 30 A0 E1 18 20 8D E5 F1 FE FF EA 14 20 9D E5 01 20 82 E3 14 20 8D E5 18 20 9D E5 07 30 A0 E1 18 20 8D E5 EA FE FF EA 14 00 9D E5 10 00 80 E3 14 00 8D E5 14 10 9D E5 10 00 11 E3 40 20 8D E5 1C 01 00 0A 18 20 9D E5 00 30 92 E5 00 00 53 E3 04 90 82 E2 21 01 00 BA 00 10 A0 03 01 10 A0 13 01 20 A0 E3 67 FF FF EA 14 10 9D E5 08 00 11 E3 40 20 8D E5 18 30 9D E5 A0 03 00 0A 20 01 93 E8 08 20 83 E2 18 20 8D E5 30 50 8D E5 50 80 8D E5 05 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 A0 50 E2 3E 04 00 0A 00 30 A0 E3 08 10 A0 E1 00 20 A0 E3 05 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 40 00 9D E5 2D 30 A0 B3 A0 2C 9F E5 A0 1C 9F E5 FB 30 DD A5 FB 30 CD B5 47 00 50 E3 02 10 A0 D1 34 10 8D E5 14 10 9D E5 03 C0 A0 E3 80 10 C1 E3 00 20 A0 E3 1C C0 8D E5 14 10 8D E5 28 C0 8D E5 44 20 8D E5 61 FF FF EA 14 00 8D E2 05 00 90 E8 08 00 80 E3 14 00 8D E5 07 30 A0 E1 18 20 8D E5 AC FE FF EA 14 30 9D E5 10 30 83 E3 14 30 8D E5 14 C0 9D E5 40 20 8D E5 10 20 1C E2 BC 00 00 0A 18 00 9D E5 00 30 90 E5 04 90 80 E2 00 10 53 E2 01 10 A0 13 00 20 A0 E3 29 FF FF EA 18 20 9D E5 14 00 9D E5 04 00 80 E3 14 00 8D E5 07 30 A0 E1 18 20 8D E5 97 FE FF EA 18 30 9D E5 00 30 93 E5 18 00 9D E5 00 00 53 E3 20 30 8D E5 04 20 80 E2 F5 FF FF AA 20 30 9D E5 00 30 63 E2 20 30 8D E5 EE FF FF EA 18 20 9D E5 FB 10 CD E5 07 30 A0 E1 18 20 8D E5 87 FE FF EA 14 30 9D E5 18 20 9D E5 80 30 83 E3 14 30 8D E5 18 20 8D E5 07 30 A0 E1 80 FE FF EA 30 00 42 E2 00 50 A0 E3 07 30 A0 E1 01 20 D3 E4 05 51 85 E0 85 50 80 E0 30 00 42 E2 09 00 50 E3 F9 FF FF 9A 20 50 8D E5 03 70 A0 E1 76 FE FF EA 07 30 A0 E1 01 20 D3 E4 2A 00 52 E3 84 05 00 0A 30 00 42 E2 09 00 50 E3 00 40 A0 83 F5 FF FF 8A 02 70 87 E2 00 40 A0 E3 01 20 57 E5 04 41 84 E0 84 40 80 E0 30 00 42 E2 09 00 50 E3 07 30 A0 E1 01 70 87 E2 F7 FF FF 9A C4 4F 84 E1 03 70 A0 E1 61 FE FF EA 14 20 9D E5 40 20 82 E3 14 20 8D E5 18 20 9D E5 07 30 A0 E1 18 20 8D E5 58 FE FF EA 14 00 9D E5 10 00 80 E3 14 00 8D E5 14 10 9D E5 10 00 11 E3 40 20 8D E5 51 00 00 0A 18 20 9D E5 00 30 92 E5 04 90 82 E2 00 10 53 E2 01 10 A0 13 01 20 A0 E3 D5 FE FF EA 40 20 8D E5 14 20 9D E5 BC 1A 9F E5 10 00 12 E3 58 10 8D E5 BF FE FF 1A 14 00 9D E5 40 00 10 E3 18 10 9D 15 18 20 9D 05 B0 30 D1 11 04 90 81 12 00 30 92 05 04 90 82 02 B9 FE FF EA 18 10 9D E5 78 20 A0 E3 14 C0 9D E5 00 30 91 E5 40 20 8D E5 F9 20 CD E5 18 00 9D E5 60 2A 9F E5 30 10 A0 E3 02 C0 8C E3 F8 10 CD E5 58 20 8D E5 14 C0 8D E5 00 10 53 E2 01 10 A0 13 04 90 80 E2 02 20 A0 E3 B4 FE FF EA 14 00 8D E2 05 00 90 E8 10 00 80 E3 14 00 8D E5 07 30 A0 E1 18 20 8D E5 22 FE FF EA 00 30 A0 E3 FB 30 CD E5 18 30 9D E5 18 C0 9D E5 00 30 93 E5 04 C0 8C E2 00 00 53 E3 40 20 8D E5 34 30 8D E5 18 C0 8D E5 98 04 00 0A 00 00 54 E3 84 04 00 BA 34 00 9D E5 00 10 A0 E3 04 20 A0 E1 ?? ?? ?? ?? 00 00 50 E3 B8 04 00 0A 34 20 9D E5 00 00 62 E0 04 00 50 E1 28 00 8D E5 0D 04 00 DA 28 40 8D E5 00 C0 A0 E3 C4 4F C4 E1 1C 40 8D E5 FB 30 DD E5 44 C0 8D E5 B1 FE FF EA 14 10 9D E5 10 00 11 E3 40 20 8D E5 AD FF FF 1A 14 30 9D E5 40 00 13 E3 E2 02 00 0A 18 C0 9D E5 B0 30 DC E1 04 90 8C E2 00 10 53 E2 01 10 A0 13 01 20 A0 E3 80 FE FF EA 14 C0 9D E5 10 00 1C E3 CB 02 00 0A 18 00 9D E5 24 10 9D E5 00 30 90 E5 04 90 80 E2 00 10 83 E5 C4 FD FF EA 14 C0 9D E5 40 20 8D E5 10 20 1C E2 42 FF FF 1A 14 30 9D E5 40 10 13 E2 B7 02 00 0A 18 C0 9D E5 B0 30 DC E1 04 90 8C E2 00 10 53 E2 01 10 A0 13 6A FE FF EA 14 30 9D E5 18 20 9D E5 10 30 83 E3 14 30 8D E5 18 20 8D E5 07 30 A0 E1 D8 FD FF EA 18 10 9D E5 00 30 91 E5 40 20 8D E5 A0 30 CD E5 01 20 A0 E3 00 30 A0 E3 04 10 81 E2 A0 C0 8D E2 1C 20 8D E5 FB 30 CD E5 18 10 8D E5 28 20 8D E5 34 C0 8D E5 CD FE FF EA 14 10 9D E5 10 00 11 E3 40 20 8D E5 E2 FE FF 1A 14 30 9D E5 40 00 13 E3 18 C0 9D 15 18 00 9D 05 F0 30 DC 11 00 30 90 05 04 90 8C 12 04 90 80 02 00 00 53 E3 DD FE FF AA 2D 20 A0 E3 00 30 63 E2 FB 20 CD E5 00 10 53 E2 01 10 A0 13 01 20 A0 E3 42 FE FF EA CC 40 8D E2 30 00 94 E8 FB 30 DD E5 00 00 53 E3 0A 00 00 0A 01 40 84 E2 FB 30 8D E2 00 30 86 E5 01 50 85 E2 07 00 54 E3 01 30 A0 E3 04 30 86 E5 D0 50 8D E5 CC 40 8D E5 08 60 86 D2 9E 01 00 CA 3C 30 9D E5 00 00 53 E3 0A 00 00 0A 01 40 84 E2 F8 30 8D E2 00 30 86 E5 02 50 85 E2 07 00 54 E3 02 30 A0 E3 04 30 86 E5 D0 50 8D E5 CC 40 8D E5 08 60 86 D2 9A 01 00 CA 38 C0 9D E5 80 00 5C E3 FC 00 00 0A 44 20 9D E5 28 30 9D E5 02 80 63 E0 00 00 58 E3 32 00 00 DA 10 00 58 E3 E0 A7 9F D5 1D 00 00 DA 04 30 A0 E1 D4 A7 9F E5 10 90 A0 E3 2C 40 9D E5 02 00 00 EA 10 80 48 E2 10 00 58 E3 14 00 00 DA 01 30 83 E2 07 00 53 E3 10 50 85 E2 00 A0 86 E5 04 90 86 E5 D0 50 8D E5 CC 30 8D E5 08 60 86 D2 F3 FF FF DA 04 00 A0 E1 0B 10 A0 E1 C8 20 8D E2 CC FC FF EB 00 00 50 E3 E2 FD FF 1A 10 80 48 E2 10 00 58 E3 CC 30 8D E2 28 00 93 E8 60 60 8D E2 EA FF FF CA 03 40 A0 E1 01 40 84 E2 08 50 85 E0 07 00 54 E3 00 A0 86 E5 04 80 86 E5 D0 50 8D E5 CC 40 8D E5 08 60 86 D2 08 00 00 DA 2C 00 9D E5 0B 10 A0 E1 C8 20 8D E2 B6 FC FF EB 00 00 50 E3 CC FD FF 1A CC 40 8D E2 30 00 94 E8 60 60 8D E2 14 C0 9D E5 01 0C 1C E3 64 00 00 1A 28 00 9D E5 01 40 84 E2 34 10 9D E5 00 50 85 E0 07 00 54 E3 00 10 86 E5 04 00 86 E5 D0 50 8D E5 CC 40 8D E5 51 00 00 CA 08 60 86 E2 14 30 9D E5 04 00 13 E3 36 00 00 0A 1C 00 8D E2 01 10 90 E8 0C 80 60 E0 00 00 58 E3 31 00 00 DA 10 00 58 E3 CC 40 9D D5 C4 A6 9F D5 1E 00 00 DA CC 40 9D E5 B8 A6 9F E5 04 30 A0 E1 10 90 A0 E3 2C 40 9D E5 02 00 00 EA 10 80 48 E2 10 00 58 E3 14 00 00 DA 01 30 83 E2 07 00 53 E3 10 50 85 E2 00 A0 86 E5 04 90 86 E5 D0 50 8D E5 CC 30 8D E5 08 60 86 D2 F3 FF FF DA 04 00 A0 E1 0B 10 A0 E1 C8 20 8D E2 81 FC FF EB 00 00 50 E3 97 FD FF 1A 10 80 48 E2 10 00 58 E3 CC 30 8D E2 28 00 93 E8 60 60 8D E2 EA FF FF CA 03 40 A0 E1 01 40 84 E2 05 50 88 E0 07 00 54 E3 00 A0 86 E5 04 80 86 E5 D0 50 8D E5 CC 40 8D E5 06 00 00 DA 2C 00 9D E5 0B 10 A0 E1 C8 20 8D E2 6C FC FF EB 00 00 50 E3 82 FD FF 1A D0 50 9D E5 24 10 9D E5 1C 20 8D E2 0C 00 92 E8 03 00 52 E1 02 10 81 A0 03 10 81 B0 00 00 55 E3 24 10 8D E5 AC 00 00 1A 00 C0 A0 E3 CC C0 8D E5 18 90 9D E5 60 60 8D E2 DE FC FF EA 03 40 A0 E1 01 40 84 E2 08 50 85 E0 07 00 54 E3 00 A0 86 E5 04 80 86 E5 D0 50 8D E5 CC 40 8D E5 AD FF FF DA 2C 00 9D E5 0B 10 A0 E1 C8 20 8D E2 4E FC FF EB 00 00 50 E3 64 FD FF 1A 60 60 8D E2 D0 50 9D E5 A5 FF FF EA 40 20 9D E5 65 00 52 E3 99 00 00 DA 30 00 9D E5 50 10 9D E5 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 F7 00 00 1A 4C 35 9F E5 01 40 84 E2 00 30 86 E5 07 00 54 E3 01 50 85 E2 01 30 A0 E3 04 30 86 E5 D0 50 8D E5 CC 40 8D E5 08 60 86 D2 0A 02 00 CA F4 30 9D E5 4C C0 9D E5 0C 00 53 E1 02 00 00 BA 14 00 9D E5 01 00 10 E3 89 FF FF 0A CC 40 9D E5 5C 10 9D E5 01 40 84 E2 07 00 54 E3 01 50 85 E2 01 30 A0 E3 0A 00 86 E8 D0 50 8D E5 CC 40 8D E5 08 60 86 D2 D7 02 00 CA 4C 20 9D E5 01 80 42 E2 00 00 58 E3 7A FF FF DA 10 00 58 E3 CC 40 9D D5 C4 A4 9F D5 BF FF FF DA CC 40 9D E5 B8 A4 9F E5 04 30 A0 E1 10 90 A0 E3 2C 40 9D E5 02 00 00 EA 10 80 48 E2 10 00 58 E3 B5 FF FF DA 01 30 83 E2 07 00 53 E3 10 50 85 E2 00 A0 86 E5 04 90 86 E5 D0 50 8D E5 CC 30 8D E5 08 60 86 D2 F3 FF FF DA 04 00 A0 E1 0B 10 A0 E1 C8 20 8D E2 04 FC FF EB 00 00 50 E3 1A FD FF 1A CC 30 8D E2 28 00 93 E8 60 60 8D E2 E9 FF FF EA 00 00 52 E3 0A 00 00 1A 14 10 9D E5 01 00 11 E3 07 00 00 0A 30 30 A0 E3 A0 20 8D E2 C7 30 CD E5 27 20 82 E2 01 30 A0 E3 34 20 8D E5 28 30 8D E5 43 FD FF EA 48 C0 9D E5 00 00 A0 E3 34 C0 8D E5 28 00 8D E5 3E FD FF EA 20 00 9D E5 1C 10 9D E5 00 80 61 E0 00 00 58 E3 FD FE FF DA 10 00 58 E3 EC A3 9F D5 1D 00 00 DA 04 30 A0 E1 E0 A3 9F E5 10 90 A0 E3 2C 40 9D E5 02 00 00 EA 10 80 48 E2 10 00 58 E3 14 00 00 DA 01 30 83 E2 07 00 53 E3 10 50 85 E2 00 A0 86 E5 04 90 86 E5 D0 50 8D E5 CC 30 8D E5 08 60 86 D2 F3 FF FF DA 04 00 A0 E1 0B 10 A0 E1 C8 20 8D E2 CF FB FF EB 00 00 50 E3 E5 FC FF 1A 10 80 48 E2 10 00 58 E3 CC 30 8D E2 28 00 93 E8 60 60 8D E2 EA FF FF CA 03 40 A0 E1 01 40 84 E2 08 50 85 E0 07 00 54 E3 00 A0 86 E5 04 80 86 E5 D0 50 8D E5 CC 40 8D E5 08 60 86 D2 D3 FE FF DA 2C 00 9D E5 0B 10 A0 E1 C8 20 8D E2 B9 FB FF EB 00 00 50 E3 CF FC FF 1A CC 40 8D E2 30 00 94 E8 60 60 8D E2 C9 FE FF EA 2C 00 9D E5 0B 10 A0 E1 C8 20 8D E2 AF FB FF EB 00 00 50 E3 4C FF FF 0A C4 FC FF EA 4C 20 9D E5 01 00 52 E3 E7 00 00 DA 01 40 84 E2 34 C0 9D E5 01 50 85 E2 07 00 54 E3 01 30 A0 E3 04 30 86 E5 00 C0 86 E5 D0 50 8D E5 CC 40 8D E5 08 60 86 D2 FC 00 00 CA }
	condition:
		$1
}

rule file_148_0_0 {
	meta:
		name = "_realloc_r"
		size = 1268
		refs = "0018 __malloc_lock 01dc __malloc_unlock 0220 _free_r 026c _malloc_r 03b0 memmove 04f0 __malloc_av_"
	strings:
		$1 = { F0 4F 2D E9 00 60 51 E2 04 D0 4D E2 00 70 A0 E1 CD 00 00 0A 00 20 8D E5 ?? ?? ?? ?? 00 20 9D E5 0B 40 82 E2 16 00 54 E3 07 40 C4 83 10 00 A0 93 00 30 A0 93 00 40 A0 91 A4 3F A0 81 04 00 A0 81 08 A0 46 E2 02 00 54 E1 01 30 83 33 00 00 53 E3 04 C0 9A E5 0C 30 A0 13 0C 10 A0 E1 00 30 87 15 00 50 A0 13 5E 00 00 1A 03 90 CC E3 00 00 59 E1 0A 30 A0 A1 09 50 A0 A1 08 A0 8A A2 4B 00 00 AA 68 B4 9F E5 08 E0 9B E5 09 10 8A E0 01 00 5E E1 B1 00 00 0A 04 50 91 E5 01 80 C5 E3 08 80 81 E0 04 80 98 E5 01 00 18 E3 5E 00 00 0A 03 10 A0 E1 01 00 1C E3 6A 00 00 1A 08 80 16 E5 0A 80 68 E0 04 50 98 E5 00 00 51 E3 03 50 C5 E3 61 00 00 0A 0E 00 51 E1 BD 00 00 0A 09 C0 85 E0 0C 50 83 E0 00 00 55 E1 0C 50 A0 B1 5B 00 00 BA 08 30 91 E5 0C 20 91 E5 08 30 82 E5 0C 20 83 E5 08 A0 A0 E1 0C 10 98 E5 08 30 BA E5 04 20 49 E2 24 00 52 E3 08 30 81 E5 0C 10 83 E5 A6 00 00 8A 13 00 52 E3 0A 10 A0 E1 17 00 00 9A 06 30 A0 E1 04 10 93 E4 08 10 88 E5 04 10 96 E5 1B 00 52 E3 0C 10 88 E5 04 60 83 E2 10 10 88 E2 0E 00 00 9A 04 30 93 E5 10 30 88 E5 04 10 96 E5 04 30 86 E2 24 00 52 E3 14 10 88 E5 04 60 83 E2 18 10 88 E2 05 00 00 1A 04 30 93 E5 18 30 88 E5 04 30 96 E5 1C 30 88 E5 08 60 86 E2 20 10 88 E2 06 20 A0 E1 04 00 92 E4 01 30 A0 E1 04 00 83 E4 04 00 96 E5 04 00 81 E5 04 20 92 E5 04 20 83 E5 04 10 98 E5 08 30 A0 E1 05 20 64 E0 0F 00 52 E3 0C 00 00 8A 01 10 01 E2 05 10 81 E1 04 10 83 E5 05 50 83 E0 04 30 95 E5 01 30 83 E3 04 30 85 E5 07 00 A0 E1 ?? ?? ?? ?? 0A 50 A0 E1 05 00 A0 E1 04 D0 8D E2 F0 8F BD E8 01 10 01 E2 04 10 81 E1 01 00 82 E3 04 40 83 E0 04 10 83 E5 04 00 84 E5 02 20 84 E0 04 30 92 E5 01 30 83 E3 04 30 82 E5 08 10 84 E2 07 00 A0 E1 ?? ?? ?? ?? EB FF FF EA 03 30 C5 E3 09 50 83 E0 00 00 55 E1 9D FF FF BA 08 30 91 E5 0C 20 91 E5 0C 10 A0 E1 08 30 82 E5 0C 20 83 E5 0A 30 A0 E1 08 A0 8A E2 D5 FF FF EA 09 50 85 E0 00 00 55 E1 A5 FF FF AA 02 10 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 00 50 50 E2 31 00 00 0A 04 10 9A E5 01 20 C1 E3 02 20 8A E0 08 30 45 E2 02 00 53 E1 8B 00 00 0A 04 20 49 E2 24 00 52 E3 43 00 00 8A 13 00 52 E3 06 10 A0 E1 05 30 A0 E1 19 00 00 9A 06 C0 A0 E1 04 30 9C E4 05 00 A0 E1 04 30 80 E4 04 30 96 E5 1B 00 52 E3 04 30 85 E5 04 10 8C E2 04 30 80 E2 0F 00 00 9A 04 C0 9C E5 04 C0 80 E5 04 C0 91 E5 24 00 52 E3 04 00 81 E2 04 20 83 E2 04 C0 83 E5 04 10 80 E2 04 30 82 E2 05 00 00 1A 04 00 90 E5 04 00 82 E5 04 20 91 E5 08 10 81 E2 04 20 83 E5 08 30 83 E2 01 00 A0 E1 04 C0 90 E4 03 20 A0 E1 04 C0 82 E4 04 10 91 E5 04 10 83 E5 04 30 90 E5 04 30 82 E5 06 10 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 07 00 A0 E1 ?? ?? ?? ?? A5 FF FF EA 02 10 A0 E1 04 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 04 30 9E E5 03 30 C3 E3 09 10 83 E0 10 50 84 E2 05 00 51 E1 0E 10 A0 B1 4D FF FF BA 01 20 64 E0 04 30 8A E0 01 20 82 E3 04 20 83 E5 04 20 9A E5 01 20 02 E2 02 40 84 E1 04 40 8A E5 07 00 A0 E1 08 30 8B E5 06 50 A0 E1 ?? ?? ?? ?? 8D FF FF EA 06 10 A0 E1 ?? ?? ?? ?? DE FF FF EA 06 10 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 08 30 A0 E1 04 10 98 E5 77 FF FF EA 09 50 85 E0 05 30 83 E0 10 10 84 E2 01 00 53 E1 9D FF FF BA 08 50 A0 E1 0C 00 98 E5 08 10 B5 E5 04 20 49 E2 24 00 52 E3 08 10 80 E5 0C 00 81 E5 34 00 00 8A 13 00 52 E3 05 00 A0 E1 17 00 00 9A 06 10 A0 E1 04 00 91 E4 08 00 88 E5 04 00 96 E5 1B 00 52 E3 0C 00 88 E5 04 60 81 E2 10 00 88 E2 0E 00 00 9A 04 10 91 E5 10 10 88 E5 04 10 96 E5 24 00 52 E3 04 20 86 E2 14 10 88 E5 18 00 88 E2 04 60 82 E2 05 00 00 1A 04 20 92 E5 18 20 88 E5 04 20 96 E5 1C 20 88 E5 08 60 86 E2 20 00 88 E2 06 10 A0 E1 04 C0 91 E4 00 20 A0 E1 04 C0 82 E4 04 C0 96 E5 04 C0 80 E5 04 10 91 E5 04 10 82 E5 03 30 64 E0 01 20 83 E3 04 30 88 E0 04 20 83 E5 04 20 98 E5 01 20 02 E2 02 40 84 E1 04 40 88 E5 07 00 A0 E1 08 30 8B E5 ?? ?? ?? ?? 48 FF FF EA 04 50 93 E5 03 50 C5 E3 0A 30 A0 E1 09 50 85 E0 08 A0 8A E2 35 FF FF EA 06 10 A0 E1 05 00 A0 E1 00 30 8D E5 ?? ?? ?? ?? 00 30 9D E5 E7 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_149_0_0 {
	meta:
		name = "_stat_r"
		size = 60
		refs = "001c _stat 0038 errno"
	strings:
		$1 = { 30 40 2D E9 2C 40 9F E5 00 30 A0 E3 00 50 A0 E1 01 00 A0 E1 02 10 A0 E1 00 30 84 E5 ?? ?? ?? ?? 01 00 70 E3 30 80 BD 18 00 30 94 E5 00 00 53 E3 00 30 85 15 30 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_293_0_0 {
	meta:
		name = "_fstat_r"
		size = 60
		refs = "001c _fstat 0038 errno"
	strings:
		$1 = { 30 40 2D E9 2C 40 9F E5 00 30 A0 E3 00 50 A0 E1 01 00 A0 E1 02 10 A0 E1 00 30 84 E5 ?? ?? ?? ?? 01 00 70 E3 30 80 BD 18 00 30 94 E5 00 00 53 E3 00 30 85 15 30 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_435_0_0 {
	meta:
		name = "_gettimeofday_r"
		size = 60
		refs = "001c _gettimeofday 0038 errno"
	strings:
		$1 = { 30 40 2D E9 2C 40 9F E5 00 30 A0 E3 00 50 A0 E1 01 00 A0 E1 02 10 A0 E1 00 30 84 E5 ?? ?? ?? ?? 01 00 70 E3 30 80 BD 18 00 30 94 E5 00 00 53 E3 00 30 85 15 30 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_275_1_0 {
	meta:
		name = "_kill_r"
		size = 60
		refs = "001c _kill 0038 errno"
	strings:
		$1 = { 30 40 2D E9 2C 40 9F E5 00 30 A0 E3 00 50 A0 E1 01 00 A0 E1 02 10 A0 E1 00 30 84 E5 ?? ?? ?? ?? 01 00 70 E3 30 80 BD 18 00 30 94 E5 00 00 53 E3 00 30 85 15 30 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_191_0_0 {
	meta:
		name = "_link_r"
		size = 60
		refs = "001c _link 0038 errno"
	strings:
		$1 = { 30 40 2D E9 2C 40 9F E5 00 30 A0 E3 00 50 A0 E1 01 00 A0 E1 02 10 A0 E1 00 30 84 E5 ?? ?? ?? ?? 01 00 70 E3 30 80 BD 18 00 30 94 E5 00 00 53 E3 00 30 85 15 30 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_150_0_0 {
	meta:
		name = "argz_count"
		size = 60
	strings:
		$1 = { 00 00 51 E3 00 C0 A0 E1 01 00 A0 01 1E FF 2F 01 00 20 A0 E3 02 00 A0 E1 02 30 A0 E1 02 20 DC E7 01 30 83 E2 00 00 52 E3 01 00 80 02 01 00 53 E1 03 20 A0 E1 F8 FF FF 1A 1E FF 2F E1 }
	condition:
		$1
}

rule file_152_0_0 {
	meta:
		name = "_fgetws_r"
		size = 372
		refs = "0064 memchr 008c _mbsrtowcs_r 00e4 __srefill_r 0148 mbsinit 0160 __errno"
	strings:
		$1 = { F0 4F 2D E9 03 40 A0 E1 BC 30 D3 E1 02 0A 13 E3 02 60 A0 E1 64 20 94 05 02 3A 83 03 02 2A 82 03 BC 30 C4 01 64 20 84 05 00 00 56 E3 08 D0 4D E2 00 70 A0 E1 01 B0 A0 E1 48 00 00 DA 04 20 94 E5 00 00 52 E3 2C 00 00 DA 04 A0 A0 E1 5C 30 9A E4 0B 50 A0 E1 04 90 8D E2 03 00 A0 E1 0A 10 A0 E3 04 30 8D E5 ?? ?? ?? ?? 00 00 50 E3 00 30 94 15 01 30 63 12 03 30 80 10 04 30 94 05 07 00 A0 E1 05 10 A0 E1 09 20 A0 E1 00 A0 8D E5 ?? ?? ?? ?? 01 00 70 E3 00 80 A0 E1 1C 00 00 0A 04 30 9D E5 00 00 53 E3 1D 00 00 0A 06 00 94 E8 02 20 81 E0 02 20 63 E0 04 20 84 E5 08 51 85 E0 04 10 15 E5 06 60 68 E0 0A 00 51 E3 01 00 56 13 00 30 84 E5 19 00 00 DA 00 00 52 E3 DE FF FF CA 07 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 12 00 00 1A 00 30 94 E5 04 20 94 E5 D6 FF FF EA 04 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 04 20 94 05 CD FF FF 0A 00 B0 A0 E3 0B 00 A0 E1 08 D0 8D E2 F0 8F BD E8 03 10 A0 E1 05 00 94 E8 ?? ?? ?? ?? 01 30 80 E2 04 30 8D E5 01 80 88 E2 DA FF FF EA 0B 00 55 E1 F2 FF FF 0A 0A 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 00 30 A0 13 00 30 85 15 ED FF FF 1A EB FF FF EA ?? ?? ?? ?? 16 30 A0 E3 00 30 80 E5 00 B0 A0 E3 E7 FF FF EA }
	condition:
		$1
}

rule file_152_1_0 {
	meta:
		name = "fgetws"
		size = 84
		refs = "0030 __sinit 004c _fgetws_r 0050 _impure_ptr"
	strings:
		$1 = { F0 40 2D E9 44 40 9F E5 00 C0 94 E5 00 00 5C E3 00 70 A0 E1 01 60 A0 E1 02 50 A0 E1 05 00 00 0A 38 30 9C E5 00 00 53 E3 02 00 00 1A 0C 00 A0 E1 ?? ?? ?? ?? 00 C0 94 E5 0C 00 A0 E1 07 10 A0 E1 06 20 A0 E1 05 30 A0 E1 F0 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_408_3_0 {
	meta:
		name = "vfiscanf"
		size = 84
		refs = "0030 __sinit 004c __svfiscanf_r 0050 _impure_ptr"
	strings:
		$1 = { F0 40 2D E9 44 40 9F E5 00 C0 94 E5 00 00 5C E3 00 70 A0 E1 01 60 A0 E1 02 50 A0 E1 05 00 00 0A 38 30 9C E5 00 00 53 E3 02 00 00 1A 0C 00 A0 E1 ?? ?? ?? ?? 00 C0 94 E5 0C 00 A0 E1 07 10 A0 E1 06 20 A0 E1 05 30 A0 E1 F0 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_314_3_0 {
	meta:
		name = "vfscanf"
		size = 84
		refs = "0030 __sinit 004c __svfscanf_r 0050 _impure_ptr"
	strings:
		$1 = { F0 40 2D E9 44 40 9F E5 00 C0 94 E5 00 00 5C E3 00 70 A0 E1 01 60 A0 E1 02 50 A0 E1 05 00 00 0A 38 30 9C E5 00 00 53 E3 02 00 00 1A 0C 00 A0 E1 ?? ?? ?? ?? 00 C0 94 E5 0C 00 A0 E1 07 10 A0 E1 06 20 A0 E1 05 30 A0 E1 F0 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_153_1_0 {
	meta:
		name = "__numeric_load_locale"
		size = 116
		refs = "0034 __part_load_locale 005c __fix_locale_grouping_str 006c __nlocale_changed"
	strings:
		$1 = { 70 40 2D E9 5C 40 9F E5 5C 50 9F E5 01 60 A0 E3 00 60 85 E5 0C D0 4D E2 03 C0 A0 E3 04 E0 84 E2 10 20 94 E5 04 10 A0 E1 40 30 9F E5 00 50 8D E9 00 C0 8D E5 ?? ?? ?? ?? 00 50 50 E2 02 00 00 1A 00 30 94 E5 00 00 53 E3 02 00 00 1A 05 00 A0 E1 0C D0 8D E2 70 80 BD E8 0C 00 94 E5 ?? ?? ?? ?? 0C 00 84 E5 F8 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_154_0_0 {
	meta:
		name = "_fread_r"
		size = 548
		refs = "00a4 memcpy 00f0 _free_r 0138 __srefill_r 0174 __udivsi3 01e0 __sinit"
	strings:
		$1 = { F0 4F 2D E9 92 03 19 E0 0C D0 4D E2 03 A0 A0 E1 02 B0 A0 E1 01 60 A0 E1 00 80 A0 E1 30 40 9D E5 09 A0 A0 01 54 00 00 0A 00 00 50 E3 02 00 00 0A 38 30 90 E5 00 00 53 E3 68 00 00 0A BC 20 D4 E1 02 0A 12 E3 05 00 00 1A 02 2A 82 E3 64 30 94 E5 BC 20 C4 E1 02 3A C3 E3 64 30 84 E5 BC 20 D4 E1 04 50 94 E5 00 00 55 E3 00 10 A0 B3 01 30 A0 B1 05 30 A0 A1 04 10 84 B5 03 50 A0 B1 02 00 12 E3 06 70 A0 E1 09 60 A0 01 40 00 00 0A 09 00 53 E1 09 30 A0 21 03 20 A0 E1 00 10 94 E5 06 00 A0 E1 00 30 8D E5 ?? ?? ?? ?? 00 30 9D E5 00 70 94 E5 04 20 94 E5 30 10 94 E5 03 70 87 E0 02 20 63 E0 03 00 59 E0 01 00 A0 13 00 00 51 E3 03 00 59 11 04 20 84 E5 00 70 84 E5 09 50 63 E0 4D 00 00 0A 40 20 84 E2 02 00 51 E1 03 00 00 0A 08 00 A0 E1 ?? ?? ?? ?? 00 70 94 E5 00 30 9D E5 00 20 A0 E3 30 20 84 E5 10 20 94 E5 04 20 8D E5 14 20 94 E5 03 60 86 E0 08 20 8D E5 01 00 00 EA 00 00 55 E3 15 00 00 0A 10 60 84 E5 14 50 84 E5 00 60 84 E5 08 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 04 20 9D E5 04 30 94 E5 10 20 84 E5 08 20 9D E5 03 60 86 E0 05 50 63 E0 00 00 50 E3 00 30 A0 E3 14 20 84 E5 00 70 84 E5 04 30 84 E5 EB FF FF 0A 09 00 65 E0 0B 10 A0 E1 ?? ?? ?? ?? 00 A0 A0 E1 0A 00 A0 E1 0C D0 8D E2 F0 8F BD E8 05 70 87 E0 04 50 94 E5 05 00 56 E1 05 20 A0 E1 07 00 A0 E1 14 00 00 9A 00 10 94 E5 ?? ?? ?? ?? 00 30 94 E5 05 30 83 E0 00 30 84 E5 08 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 06 60 65 E0 EE FF FF 0A 09 00 66 E0 0B 10 A0 E1 ?? ?? ?? ?? 00 A0 A0 E1 E6 FF FF EA ?? ?? ?? ?? BC 20 D4 E1 02 0A 12 E3 9B FF FF 1A 94 FF FF EA 06 20 A0 E1 00 10 94 E5 ?? ?? ?? ?? 04 20 94 E5 00 30 94 E5 06 30 83 E0 02 60 66 E0 48 00 84 E8 D8 FF FF EA 00 00 50 E3 B8 FF FF 1A D5 FF FF EA }
	condition:
		$1
}

rule file_155_0_0 {
	meta:
		name = "_wcsrtombs_r"
		size = 312
		refs = "0058 _wcrtomb_r"
	strings:
		$1 = { F0 4F 2D E9 00 00 51 E3 1C D0 4D E2 07 00 8D E9 03 A0 A0 E1 40 60 9D E5 42 00 00 0A 00 00 53 E3 00 90 92 E5 03 30 A0 01 2C 00 00 0A 00 70 A0 E3 08 50 9D E5 07 80 A0 E1 10 40 8D E2 00 C0 96 E5 00 C0 8D E5 04 00 9D E5 04 10 A0 E1 07 20 99 E7 06 30 A0 E1 04 B0 96 E5 ?? ?? ?? ?? 01 00 70 E3 21 00 00 0A 00 30 88 E0 0A 00 53 E1 17 00 00 8A 08 20 9D E5 00 00 52 E3 0C 00 00 0A 00 00 50 E3 06 00 00 DA 00 20 A0 E3 02 10 D4 E7 02 10 C5 E7 01 20 82 E2 02 00 50 E1 FA FF FF 1A 00 50 85 E0 0C C0 9D E5 00 20 9C E5 04 20 82 E2 00 20 8C E5 07 20 99 E7 00 00 52 E3 12 00 00 0A 0A 00 53 E1 04 70 87 E2 05 00 00 2A 03 80 A0 E1 DA FF FF EA 04 B0 86 E5 00 10 9D E5 00 10 86 E5 08 30 A0 E1 03 00 A0 E1 1C D0 8D E2 F0 8F BD E8 04 10 9D E5 8A 30 A0 E3 00 30 81 E5 00 30 A0 E3 00 30 86 E5 00 30 A0 E1 F5 FF FF EA 08 10 9D E5 00 00 51 E3 0C C0 9D 15 00 20 8C 15 00 20 A0 E3 00 20 86 E5 01 30 43 E2 ED FF FF EA 0C 20 9D E5 00 A0 E0 E3 00 90 92 E5 BC FF FF EA }
	condition:
		$1
}

rule file_156_0_0 {
	meta:
		name = "_rename_r"
		size = 60
		refs = "000c _link_r 0028 _unlink_r"
	strings:
		$1 = { 30 40 2D E9 00 50 A0 E1 01 40 A0 E1 ?? ?? ?? ?? 01 00 70 E3 01 00 00 1A 00 00 E0 E3 30 80 BD E8 05 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 01 00 70 E3 00 00 A0 13 30 80 BD 18 F6 FF FF EA }
	condition:
		$1
}

rule file_157_0_0 {
	meta:
		name = "modff"
		size = 112
		refs = "0050 __subsf3"
	strings:
		$1 = { C0 CB A0 E1 FF C0 0C E2 7F C0 4C E2 16 00 5C E3 10 40 2D E9 00 30 A0 E1 00 20 A0 E1 0F 00 00 CA 00 00 5C E3 02 21 00 B2 00 20 81 B5 09 00 00 BA 02 45 A0 E3 01 40 44 E2 54 CC A0 E1 02 00 1C E1 06 00 00 0A 0C C0 C2 E1 00 C0 81 E5 0C 10 A0 E1 ?? ?? ?? ?? 00 30 A0 E1 03 00 A0 E1 10 80 BD E8 00 30 81 E5 02 31 02 E2 03 00 A0 E1 10 80 BD E8 }
	condition:
		$1
}

rule file_158_0_0 {
	meta:
		name = "_tolower"
		size = 32
		refs = "001c __ctype_ptr__"
		altNames = "tolower"
	strings:
		$1 = { 14 30 9F E5 00 30 93 E5 00 30 83 E0 01 30 D3 E5 01 00 13 E3 20 00 80 12 1E FF 2F E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_159_0_0 {
	meta:
		name = "critical_factorization"
		size = 280
	strings:
		$1 = { 01 30 A0 E3 F0 07 2D E9 03 40 A0 E1 00 50 A0 E3 05 C0 84 E0 01 00 5C E1 00 70 E0 E3 04 60 80 E0 0F 00 00 2A 07 60 D6 E7 0C 80 D0 E7 06 00 58 E1 0C 30 67 30 01 40 A0 33 04 00 00 3A 29 00 00 0A 01 30 A0 E3 05 70 A0 E1 03 C0 85 E0 03 40 A0 E1 0C 50 A0 E1 05 C0 84 E0 01 00 5C E1 04 60 80 E0 EF FF FF 3A 01 A0 A0 E3 0A 40 A0 E1 00 50 A0 E3 05 C0 84 E0 0C 00 51 E1 00 30 82 E5 00 80 E0 E3 04 60 80 E0 0F 00 00 9A 08 60 D6 E7 0C 90 D0 E7 06 00 59 E1 0C A0 68 80 01 40 A0 83 04 00 00 8A 16 00 00 0A 01 A0 A0 E3 05 80 A0 E1 0A C0 85 E0 0A 40 A0 E1 0C 50 A0 E1 05 C0 84 E0 0C 00 51 E1 04 60 80 E0 EF FF FF 8A 01 80 88 E2 01 00 87 E2 00 00 58 E1 0A 30 A0 21 08 00 A0 21 00 30 82 E5 F0 07 BD E8 1E FF 2F E1 03 00 54 E1 05 C0 A0 11 01 40 A0 03 01 40 84 12 0C 50 A0 E1 D4 FF FF EA 0A 00 54 E1 05 C0 A0 11 01 40 A0 03 01 40 84 12 0C 50 A0 E1 E7 FF FF EA }
	condition:
		$1
}

rule file_159_1_0 {
	meta:
		name = "two_way_long_needle"
		size = 952
		refs = "0098 memcmp 00ec memchr"
	strings:
		$1 = { F0 4F 2D E9 41 DE 4D E2 08 D0 4D E2 04 20 8D E5 00 70 A0 E1 02 00 A0 E1 41 2E 8D E2 04 20 82 E2 01 B0 A0 E1 03 10 A0 E1 03 40 A0 E1 AD FF FF EB 18 20 8D E2 00 80 A0 E1 04 20 42 E2 00 30 A0 E3 03 40 82 E7 04 30 83 E2 01 0B 53 E3 FB FF FF 1A 00 00 54 E3 0B 00 00 0A 04 00 9D E5 01 20 44 E2 00 30 A0 E3 03 10 D0 E7 41 CE 8D E2 01 30 83 E2 08 C0 8C E2 01 11 8C E0 03 00 54 E1 04 24 01 E5 01 20 42 E2 F6 FF FF 8A 14 14 9D E5 04 00 9D E5 08 20 A0 E1 01 10 80 E0 ?? ?? ?? ?? 00 50 50 E2 6A 00 00 1A 01 10 48 E2 0B 00 A0 E1 04 30 9D E5 05 A0 A0 E1 04 B0 A0 E1 01 20 87 E0 01 60 44 E2 0B 40 8A E0 00 10 8D E5 08 20 8D E5 08 30 83 E0 01 C0 68 E2 04 20 60 E0 00 10 A0 E3 00 00 87 E0 0C 30 8D E5 10 C0 8D E5 04 90 9D E5 ?? ?? ?? ?? 00 00 50 E3 42 00 00 1A 00 00 54 E3 40 00 00 0A 04 30 87 E0 01 30 53 E5 41 1E 8D E2 08 10 81 E2 03 31 81 E0 04 34 13 E5 00 00 53 E3 42 00 00 1A 08 00 55 E1 05 30 A0 21 08 30 A0 31 06 00 53 E1 0E 00 00 2A 0A 20 83 E0 02 10 D7 E7 03 00 D9 E7 01 00 50 E1 02 20 87 E0 03 10 89 E0 04 00 00 0A 2F 00 00 EA 01 C0 F1 E5 01 00 F2 E5 00 00 5C E1 2B 00 00 1A 01 30 83 E2 06 00 53 E1 F8 FF FF 3A 08 00 55 E1 89 00 00 2A 00 30 9D E5 08 C0 9D E5 03 20 D9 E7 0A 30 DC E7 03 00 52 E1 00 30 9D E5 82 00 00 1A 08 10 8A E0 01 10 87 E0 0C 20 9D E5 07 00 00 EA 02 00 51 E5 02 C0 52 E5 00 00 5C E1 01 20 42 E2 01 10 41 E2 01 00 43 E2 02 00 00 1A 00 30 A0 E1 03 00 55 E1 F5 FF FF 3A 01 50 85 E2 03 00 55 E1 75 00 00 8A 14 54 9D E5 04 00 A0 E1 05 A0 8A E0 0B 50 65 E0 0B 40 8A E0 04 20 60 E0 00 10 A0 E3 00 00 87 E0 ?? ?? ?? ?? 00 00 50 E3 BC FF FF 0A 00 00 A0 E3 18 D0 8D E2 01 DB 8D E2 F0 8F BD E8 10 00 9D E5 0A A0 80 E0 03 A0 8A E0 00 50 A0 E3 04 00 A0 E1 EE FF FF EA 00 00 55 E3 03 00 00 0A 14 24 9D E5 02 00 53 E1 0B 30 62 30 00 50 A0 31 03 A0 8A E0 04 00 A0 E1 E5 FF FF EA 04 30 68 E0 08 00 53 E1 08 30 A0 31 01 30 83 E2 01 A0 48 E2 04 10 9D E5 01 20 68 E2 0A 00 87 E0 14 34 8D E5 08 20 8D E5 00 00 8D E5 00 60 A0 E3 0B 00 A0 E1 01 50 44 E2 08 90 81 E0 04 B0 A0 E1 0B 40 86 E0 04 20 60 E0 00 10 A0 E3 00 00 87 E0 ?? ?? ?? ?? 00 00 50 E3 D5 FF FF 1A 00 00 54 E3 D3 FF FF 0A 04 30 87 E0 01 30 53 E5 41 CE 8D E2 08 C0 8C E2 03 31 8C E0 04 34 13 E5 00 00 53 E3 29 00 00 1A 05 00 58 E1 0F 00 00 2A 08 10 86 E0 01 30 D7 E7 00 20 D9 E5 03 00 52 E1 01 10 87 E0 09 20 A0 01 08 30 A0 01 04 00 00 0A 21 00 00 EA 01 C0 F2 E5 01 00 F1 E5 00 00 5C E1 1E 00 00 1A 01 30 83 E2 05 00 53 E1 F8 FF FF 3A 01 00 7A E3 0A 30 A0 E1 11 00 00 0A 04 00 9D E5 00 C0 9D E5 0A 10 D0 E7 06 20 DC E7 02 00 51 E1 0D 00 00 1A 08 10 86 E0 01 10 87 E0 09 20 A0 E1 05 00 00 EA 02 C0 52 E5 02 00 51 E5 00 00 5C E1 01 20 42 E2 01 10 41 E2 03 00 00 1A 01 30 53 E2 F7 FF FF 2A 06 00 87 E0 A3 FF FF EA 14 34 9D E5 03 60 86 E0 04 00 A0 E1 C1 FF FF EA 08 30 A0 E1 08 10 9D E5 06 60 81 E0 03 60 86 E0 04 00 A0 E1 BB FF FF EA 08 30 A0 E1 01 50 85 E2 03 00 55 E1 89 FF FF 9A 0A 00 87 E0 93 FF FF EA }
	condition:
		$1
}

rule file_159_2_0 {
	meta:
		name = "strstr"
		size = 892
		refs = "0090 strchr 0100 memcmp 0148 memchr"
	strings:
		$1 = { F0 4F 2D E9 00 30 D0 E5 00 00 53 E3 10 D0 4D E2 00 A0 A0 E1 01 50 A0 E1 CE 00 00 0A 00 20 D1 E5 00 00 52 E3 12 00 00 0A 00 10 A0 E1 05 40 A0 E1 01 00 A0 E3 03 00 00 EA 00 20 D4 E5 00 00 52 E3 01 10 81 E2 0D 00 00 0A 02 00 53 E1 00 00 A0 13 01 00 00 02 01 30 D1 E5 00 00 53 E3 01 40 84 E2 F4 FF FF 1A 00 30 D4 E5 00 00 53 E3 03 00 00 0A 00 A0 A0 E3 0A 00 A0 E1 10 D0 8D E2 F0 8F BD E8 00 00 50 E3 FA FF FF 1A 01 00 8A E2 00 10 D5 E5 ?? ?? ?? ?? 04 40 65 E0 01 00 54 E3 00 00 50 13 00 70 A0 E1 00 A0 A0 01 F1 FF FF 0A 04 A0 8A E0 0A 00 50 E1 01 A0 A0 83 0A A0 60 90 1F 00 54 E3 05 00 00 9A 0A 10 A0 E1 05 20 A0 E1 04 30 A0 E1 DC FE FF EB 00 A0 A0 E1 E5 FF FF EA 04 10 A0 E1 0C 20 8D E2 05 00 A0 E1 90 FE FF EB 0C 10 9D E5 00 80 A0 E1 01 10 85 E0 05 00 A0 E1 08 20 A0 E1 ?? ?? ?? ?? 00 60 50 E2 45 00 00 1A 01 30 48 E2 03 10 87 E0 00 10 8D E5 08 20 85 E0 01 10 68 E2 04 20 8D E5 08 10 8D E5 0A 00 A0 E1 06 90 A0 E1 08 B0 A0 E1 03 A0 A0 E1 04 80 89 E0 08 20 60 E0 00 10 A0 E3 00 00 87 E0 ?? ?? ?? ?? 00 00 50 E3 C6 FF FF 1A 00 00 58 E3 C4 FF FF 0A 0B 00 56 E1 06 30 A0 21 0B 30 A0 31 03 00 54 E1 0E 00 00 9A 09 20 83 E0 02 10 D7 E7 03 00 D5 E7 01 00 50 E1 02 20 87 E0 03 10 85 E0 04 00 00 0A 62 00 00 EA 01 C0 F1 E5 01 00 F2 E5 00 00 5C E1 5E 00 00 1A 01 30 83 E2 03 00 54 E1 F8 FF FF 8A 06 00 5B E1 6B 00 00 9A 00 10 9D E5 0A 20 D5 E7 09 30 D1 E7 03 00 52 E1 0A 30 A0 E1 65 00 00 1A 0B 10 89 E0 01 10 87 E0 04 20 9D E5 07 00 00 EA 02 00 51 E5 02 C0 52 E5 00 00 5C E1 01 20 42 E2 01 10 41 E2 01 00 43 E2 02 00 00 1A 00 30 A0 E1 03 00 56 E1 F5 FF FF 3A 01 60 86 E2 03 00 56 E1 58 00 00 8A 0C 60 9D E5 08 00 A0 E1 06 90 89 E0 04 60 66 E0 C4 FF FF EA 04 30 68 E0 08 00 53 E1 08 30 A0 31 01 30 83 E2 01 20 68 E2 0C 30 8D E5 04 20 8D E5 00 50 8D E5 00 60 A0 E3 08 90 85 E0 01 B0 48 E2 0A 00 A0 E1 04 50 86 E0 05 20 60 E0 00 10 A0 E3 00 00 87 E0 ?? ?? ?? ?? 00 00 50 E3 7F FF FF 1A 00 00 55 E3 7D FF FF 0A 08 00 54 E1 10 00 00 9A 08 10 86 E0 01 30 D7 E7 00 20 D9 E5 03 00 52 E1 01 10 87 E0 08 30 A0 11 09 20 A0 01 08 30 A0 01 04 00 00 0A 22 00 00 EA 01 C0 F2 E5 01 00 F1 E5 00 00 5C E1 1E 00 00 1A 01 30 83 E2 03 00 54 E1 F8 FF FF 8A 01 00 7B E3 0B 30 A0 E1 26 00 00 0A 00 20 9D E5 06 A0 87 E0 0B 10 D2 E7 0B 20 DA E7 02 00 51 E1 17 00 00 1A 08 10 86 E0 01 10 87 E0 09 20 A0 E1 05 00 00 EA 02 C0 52 E5 02 00 51 E5 00 00 5C E1 01 20 42 E2 01 10 41 E2 0D 00 00 1A 01 30 53 E2 56 FF FF 3A F6 FF FF EA 08 20 9D E5 09 90 82 E0 03 90 89 E0 00 60 A0 E3 08 00 A0 E1 80 FF FF EA 04 10 9D E5 06 60 81 E0 03 60 86 E0 05 00 A0 E1 C2 FF FF EA 0C 30 9D E5 05 00 A0 E1 03 60 86 E0 BE FF FF EA 01 40 A0 E1 01 00 A0 E3 3F FF FF EA 0B 30 A0 E1 A5 FF FF EA 06 A0 87 E0 3F FF FF EA 09 A0 87 E0 3D FF FF EA }
	condition:
		$1
}

rule file_160_0_0 {
	meta:
		name = "isnan"
		size = 48
		altNames = "__isnand"
	strings:
		$1 = { 00 30 A0 E1 00 00 61 E2 01 00 80 E1 02 31 C3 E3 A0 0F 83 E1 7F 04 60 E2 0F 06 80 E2 04 40 2D E5 A0 0F A0 E1 01 40 A0 E1 10 00 BD E8 1E FF 2F E1 }
	condition:
		$1
}

rule file_162_0_0 {
	meta:
		name = "asctime_r"
		size = 112
		refs = "0058 sprintf"
	strings:
		$1 = { F0 41 2D E9 10 30 80 E2 08 50 93 E8 54 20 9F E5 E0 00 90 E9 01 40 A0 E1 8E 80 8E E0 18 10 82 E2 00 E0 90 E5 83 30 83 E0 76 CE 8C E2 14 D0 4D E2 03 30 81 E0 0C C0 8C E2 08 20 82 E0 04 00 A0 E1 24 10 9F E5 00 70 8D E5 04 60 8D E5 08 50 8D E5 0C E0 8D E5 10 C0 8D E5 ?? ?? ?? ?? 04 00 A0 E1 14 D0 8D E2 F0 81 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_163_0_0 {
	meta:
		name = "wcschr"
		size = 48
	strings:
		$1 = { 00 30 90 E5 01 00 53 E1 1E FF 2F 01 00 00 53 E3 04 00 00 0A 04 00 80 E2 00 30 90 E5 01 00 53 E1 F9 FF FF 1A 1E FF 2F E1 03 00 A0 E1 1E FF 2F E1 }
	condition:
		$1
}

rule file_168_0_0 {
	meta:
		name = "_fputwc_r"
		size = 372
		refs = "0100 _wcrtomb_r 0140 __swbuf_r 0170 __mb_cur_max"
	strings:
		$1 = { BC 30 D2 E1 02 0A 13 E3 F0 45 2D E9 02 40 A0 E1 64 20 92 05 02 3A 83 03 02 2A 82 03 BC 30 C4 01 64 20 84 05 44 31 9F E5 00 30 93 E5 00 00 51 E3 00 20 A0 D3 01 20 A0 C3 01 00 53 E3 00 20 A0 13 00 00 52 E3 04 D0 4D E2 00 70 A0 E1 01 60 A0 E1 26 00 00 0A FF 00 51 E3 24 00 00 CA 04 50 8D E2 04 10 65 E5 01 A0 A0 E3 00 80 A0 E3 08 00 00 EA 00 30 94 E5 08 20 D5 E7 00 20 C3 E5 00 30 94 E5 01 30 83 E2 00 30 84 E5 01 80 88 E2 0A 00 58 E1 21 00 00 2A 08 30 94 E5 01 30 43 E2 00 00 53 E3 08 30 84 E5 F1 FF FF AA 18 20 94 E5 02 00 53 E1 1F 00 00 BA 00 30 94 E5 08 20 D5 E7 00 20 C3 E5 00 30 94 E5 00 10 D3 E5 0A 00 51 E3 01 30 83 12 00 30 84 15 00 00 A0 13 1D 00 00 0A 00 00 50 E3 E8 FF FF 0A 00 00 E0 E3 04 D0 8D E2 F0 85 BD E8 07 00 A0 E1 0D 10 A0 E1 06 20 A0 E1 5C 30 84 E2 ?? ?? ?? ?? 01 00 70 E3 0D 50 A0 E1 00 A0 A0 E1 03 00 00 0A 00 00 50 E3 D2 FF FF 1A 06 00 A0 E1 F0 FF FF EA BC 30 D4 E1 40 30 83 E3 BC 30 C4 E1 EC FF FF EA 07 00 A0 E1 08 10 D5 E7 04 20 A0 E1 ?? ?? ?? ?? 01 00 70 E3 00 00 A0 13 01 00 A0 03 E1 FF FF EA 07 00 A0 E1 04 20 A0 E1 ?? ?? ?? ?? 01 00 70 E3 00 00 A0 13 01 00 A0 03 DA FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_168_1_0 {
	meta:
		name = "fputwc"
		size = 76
		refs = "002c __sinit 0044 _fputwc_r 0048 _impure_ptr"
	strings:
		$1 = { 70 40 2D E9 3C 40 9F E5 00 30 94 E5 00 00 53 E3 00 60 A0 E1 01 50 A0 E1 05 00 00 0A 38 20 93 E5 00 00 52 E3 02 00 00 1A 03 00 A0 E1 ?? ?? ?? ?? 00 30 94 E5 03 00 A0 E1 06 10 A0 E1 05 20 A0 E1 70 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_432_0_0 {
	meta:
		name = "fputc"
		size = 76
		refs = "002c __sinit 0044 _putc_r 0048 _impure_ptr"
	strings:
		$1 = { 70 40 2D E9 3C 40 9F E5 00 30 94 E5 00 00 53 E3 00 60 A0 E1 01 50 A0 E1 05 00 00 0A 38 20 93 E5 00 00 52 E3 02 00 00 1A 03 00 A0 E1 ?? ?? ?? ?? 00 30 94 E5 03 00 A0 E1 06 10 A0 E1 05 20 A0 E1 70 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_187_1_0 {
	meta:
		name = "fputws"
		size = 76
		refs = "002c __sinit 0044 _fputws_r 0048 _impure_ptr"
	strings:
		$1 = { 70 40 2D E9 3C 40 9F E5 00 30 94 E5 00 00 53 E3 00 60 A0 E1 01 50 A0 E1 05 00 00 0A 38 20 93 E5 00 00 52 E3 02 00 00 1A 03 00 A0 E1 ?? ?? ?? ?? 00 30 94 E5 03 00 A0 E1 06 10 A0 E1 05 20 A0 E1 70 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_383_1_0 {
	meta:
		name = "ungetwc"
		size = 76
		refs = "002c __sinit 0044 _ungetwc_r 0048 _impure_ptr"
	strings:
		$1 = { 70 40 2D E9 3C 40 9F E5 00 30 94 E5 00 00 53 E3 00 60 A0 E1 01 50 A0 E1 05 00 00 0A 38 20 93 E5 00 00 52 E3 02 00 00 1A 03 00 A0 E1 ?? ?? ?? ?? 00 30 94 E5 03 00 A0 E1 06 10 A0 E1 05 20 A0 E1 70 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_170_0_0 {
	meta:
		name = "_viprintf_r"
		size = 16
		refs = "000c _vfiprintf_r"
	strings:
		$1 = { 02 30 A0 E1 01 20 A0 E1 08 10 90 E5 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_423_0_0 {
	meta:
		name = "_vprintf_r"
		size = 16
		refs = "000c _vfprintf_r"
	strings:
		$1 = { 02 30 A0 E1 01 20 A0 E1 08 10 90 E5 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_170_1_0 {
	meta:
		name = "viprintf"
		size = 32
		refs = "0018 _vfiprintf_r 001c _impure_ptr"
	strings:
		$1 = { 14 30 9F E5 00 C0 93 E5 01 30 A0 E1 08 10 9C E5 00 20 A0 E1 0C 00 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_423_1_0 {
	meta:
		name = "vprintf"
		size = 32
		refs = "0018 _vfprintf_r 001c _impure_ptr"
	strings:
		$1 = { 14 30 9F E5 00 C0 93 E5 01 30 A0 E1 08 10 9C E5 00 20 A0 E1 0C 00 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_171_0_0 {
	meta:
		name = "__call_exitprocs"
		size = 328
		refs = "0088 free 0144 _global_impure_ptr"
	strings:
		$1 = { F0 4F 2D E9 38 31 9F E5 00 90 93 E5 08 D0 4D E2 01 60 A0 E1 52 1F 89 E2 04 00 8D E5 00 10 8D E5 01 B0 A0 E3 48 71 99 E5 00 00 57 E3 39 00 00 0A 00 A0 9D E5 04 20 97 E5 01 40 52 E2 09 00 00 4A 42 50 82 E2 05 51 87 E0 00 00 56 E3 13 00 00 0A 04 30 15 E5 06 00 53 E1 10 00 00 0A 01 40 54 E2 04 50 45 E2 F7 FF FF 5A 00 00 52 E3 00 20 97 15 31 00 00 1A 00 30 97 E5 00 00 53 E3 2E 00 00 0A 00 30 8A E5 07 00 A0 E1 ?? ?? ?? ?? 00 20 9A E5 00 00 52 E3 1F 00 00 0A 02 70 A0 E1 E4 FF FF EA 01 30 42 E2 04 00 53 E1 04 31 15 E5 00 10 A0 13 04 40 87 05 04 20 A0 01 04 11 05 15 00 00 53 E3 E5 FF FF 0A 1B 14 A0 E1 88 01 97 E5 00 00 11 E1 02 80 A0 E1 11 00 00 0A 8C 21 97 E5 02 00 11 E1 11 00 00 1A 04 00 9D E5 84 10 15 E5 0F E0 A0 E1 13 FF 2F E1 04 20 97 E5 08 00 52 E1 C8 FF FF 1A 00 30 9A E5 07 00 53 E1 D3 FF FF 0A 48 71 99 E5 00 00 57 E3 C5 FF FF 1A 08 D0 8D E2 F0 8F BD E8 0F E0 A0 E1 13 FF 2F E1 F1 FF FF EA 84 00 15 E5 0F E0 A0 E1 13 FF 2F E1 ED FF FF EA 07 A0 A0 E1 D2 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_172_0_0 {
	meta:
		name = "wcscat"
		size = 72
	strings:
		$1 = { 00 30 90 E5 00 00 53 E3 00 20 A0 01 03 00 00 0A 00 20 A0 E1 04 30 B2 E5 00 00 53 E3 FC FF FF 1A 00 30 91 E5 00 00 53 E3 03 00 00 0A 04 30 82 E4 04 30 B1 E5 00 00 53 E3 FB FF FF 1A 00 30 A0 E3 00 30 82 E5 1E FF 2F E1 }
	condition:
		$1
}

rule file_174_0_0 {
	meta:
		name = "access"
		size = 76
		refs = "0010 stat"
	strings:
		$1 = { 10 40 2D E9 3C D0 4D E2 01 40 A0 E1 0D 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 09 00 00 1A 04 30 9D E5 01 09 13 E3 03 00 00 1A 02 00 14 E3 01 00 00 0A 80 00 13 E3 02 00 00 0A 00 00 A0 E3 3C D0 8D E2 10 80 BD E8 00 00 E0 E3 FB FF FF EA }
	condition:
		$1
}

rule file_175_0_0 {
	meta:
		name = "_strtoull_r"
		size = 636
		refs = "00a8 __umoddi3 00bc __udivdi3 0278 __ctype_ptr__"
	strings:
		$1 = { F0 4F 2D E9 01 90 A0 E1 68 12 9F E5 20 D0 4D E2 00 60 91 E5 1C 00 8D E5 0C 20 8D E5 03 70 A0 E1 09 50 A0 E1 01 40 D5 E4 04 30 86 E0 01 30 D3 E5 08 30 13 E2 FA FF FF 1A 2D 00 54 E3 77 00 00 0A 2B 00 54 E3 01 40 D5 04 18 30 8D E5 01 30 77 E2 00 30 A0 33 00 00 57 E3 10 00 57 13 0B 00 00 1A 30 00 54 E3 71 00 00 0A 00 00 53 E3 07 00 00 0A 30 00 54 E3 79 00 00 0A 0A 20 A0 E3 00 30 A0 E3 05 80 A0 E3 0C 00 8D E9 0A 70 A0 E3 07 00 00 EA 07 10 A0 E1 C1 2F A0 E1 06 00 8D E9 00 00 E0 E3 00 10 E0 E3 0C 00 9D E9 ?? ?? ?? ?? 00 80 A0 E1 0C 00 9D E9 00 00 E0 E3 00 10 E0 E3 ?? ?? ?? ?? 00 A0 A0 E3 00 20 A0 E3 00 30 A0 E3 00 90 8D E5 10 20 8D E5 14 30 8D E5 00 90 A0 E3 0A 20 A0 E1 00 A0 A0 E3 04 30 86 E0 01 30 D3 E5 04 00 13 E3 30 40 44 12 05 00 00 1A 03 00 13 E3 28 00 00 0A 01 00 13 E3 37 30 A0 13 57 30 A0 03 04 40 63 E0 07 00 54 E1 22 00 00 AA 01 00 5A E1 00 30 A0 E3 1A 00 00 8A 17 00 00 0A A2 3F 83 E1 FF 30 13 E2 11 00 00 1A 08 00 54 E1 00 20 A0 D3 01 20 A0 C3 00 00 59 E1 13 00 00 0A 03 00 12 E1 0A 00 00 1A 08 C0 9D E5 99 0C 0C E0 04 B0 9D E5 99 2B 83 E0 9B CA 2C E0 04 90 92 E0 03 30 8C E0 C4 AF A3 E0 01 20 A0 E3 01 40 D5 E4 D9 FF FF EA 00 20 E0 E3 01 40 D5 E4 D6 FF FF EA 00 00 59 E1 E5 FF FF 9A 01 30 A0 E3 E3 FF FF EA 01 00 5A E1 01 30 A0 03 E8 FF FF EA 0A 40 A0 E1 02 A0 A0 E1 09 30 A0 E1 01 00 7A E3 03 20 A0 E1 00 90 9D E5 04 30 A0 E1 10 00 00 0A 18 B0 9D E5 00 00 5B E3 0A 00 00 1A 0C 10 9D E5 00 00 51 E3 03 00 00 0A 00 00 5A E3 0C B0 9D E5 01 90 45 12 00 90 8B E5 03 10 A0 E1 02 00 A0 E1 20 D0 8D E2 F0 8F BD E8 00 20 72 E2 00 30 E3 E2 F1 FF FF EA 1C 10 9D E5 22 30 A0 E3 00 30 81 E5 00 20 E0 E3 00 30 E0 E3 EB FF FF EA 01 10 A0 E3 01 40 D5 E4 18 10 8D E5 86 FF FF EA 00 20 D5 E5 78 00 52 E3 58 00 52 13 89 FF FF 1A 10 20 A0 E3 00 30 A0 E3 01 40 D5 E5 0F 80 A0 E3 02 50 85 E2 0C 00 8D E9 10 70 A0 E3 93 FF FF EA 08 10 A0 E3 00 20 A0 E3 07 80 A0 E3 06 00 8D E9 08 70 A0 E3 8D FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_177_0_0 {
	meta:
		name = "_gets_r"
		size = 144
		refs = "0060 __srget_r 008c _impure_ptr"
	strings:
		$1 = { F0 41 2D E9 01 70 A0 E1 00 80 A0 E1 01 40 A0 E1 74 60 9F E5 08 00 00 EA 00 30 91 E5 01 00 D3 E4 0A 00 50 E3 00 30 81 E5 0F 00 00 0A 01 00 70 E3 01 40 84 E2 10 00 00 0A 01 00 44 E5 00 30 96 E5 04 10 93 E5 04 30 91 E5 01 30 43 E2 00 00 53 E3 04 30 81 E5 04 50 A0 E1 EE FF FF AA 08 00 A0 E1 ?? ?? ?? ?? 0A 00 50 E3 EF FF FF 1A 00 30 A0 E3 00 30 C5 E5 07 00 A0 E1 F0 81 BD E8 05 00 57 E1 00 70 A0 03 F8 FF FF 1A F9 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_180_0_0 {
	meta:
		name = "_memalign_r"
		size = 340
		refs = "0060 _malloc_r 0074 __malloc_lock 0080 __umodsi3 00f0 _free_r 0110 __malloc_unlock"
	strings:
		$1 = { 08 00 51 E3 F0 45 2D E9 01 40 A0 E1 00 60 A0 E1 41 00 00 9A 0B 50 82 E2 0F 00 51 E3 10 40 A0 93 16 00 55 E3 07 50 C5 83 00 30 A0 93 A5 3F A0 81 10 50 A0 93 02 00 55 E1 03 20 A0 21 01 20 83 33 00 00 52 E3 0C 30 A0 13 00 30 80 15 00 00 A0 13 F0 85 BD 18 10 10 84 E2 05 10 81 E0 06 00 A0 E1 ?? ?? ?? ?? 00 80 50 E2 08 00 A0 01 F0 85 BD 08 06 00 A0 E1 ?? ?? ?? ?? 08 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 08 70 48 E2 19 00 00 0A 01 A0 44 E2 00 30 64 E2 0A A0 88 E0 03 A0 0A E0 08 A0 4A E2 0A 30 67 E0 04 20 97 E5 0F 00 53 E3 04 A0 8A D0 0A 30 67 D0 03 20 C2 E3 02 20 63 E0 01 10 82 E3 04 10 8A E5 02 20 8A E0 04 10 92 E5 01 10 81 E3 04 10 82 E5 04 20 97 E5 01 20 02 E2 02 30 83 E1 04 30 87 E5 08 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 0A 70 A0 E1 04 30 97 E5 03 30 C3 E3 03 30 65 E0 0F 00 53 E3 06 00 00 CA 06 00 A0 E1 ?? ?? ?? ?? 08 00 87 E2 F0 85 BD E8 02 10 A0 E1 F0 45 BD E8 ?? ?? ?? ?? 05 10 87 E0 01 30 83 E3 04 30 81 E5 04 30 97 E5 01 30 03 E2 03 50 85 E1 04 50 87 E5 08 10 81 E2 06 00 A0 E1 ?? ?? ?? ?? ED FF FF EA }
	condition:
		$1
}

rule file_181_0_0 {
	meta:
		name = "hash4"
		size = 260
	strings:
		$1 = { 00 00 51 E3 0E 00 00 0A 07 C0 01 E2 01 C0 4C E2 07 10 81 E2 00 30 A0 E1 A1 21 A0 E1 06 00 5C E3 0C F1 9F 97 2A 00 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 01 00 A0 E1 1E FF 2F E1 01 10 D3 E4 00 00 A0 E3 00 00 81 E0 80 02 80 E0 01 10 D3 E4 00 00 81 E0 80 02 80 E0 01 10 D3 E4 00 00 81 E0 80 02 80 E0 01 10 D3 E4 00 00 81 E0 80 02 80 E0 01 10 D3 E4 00 00 81 E0 80 02 80 E0 00 C0 D3 E5 01 20 52 E2 00 00 8C E0 01 30 83 12 80 02 80 10 1E FF 2F 01 01 10 D3 E4 00 00 81 E0 80 02 80 E0 01 10 D3 E4 00 00 81 E0 01 10 D3 E4 80 02 80 E0 00 00 81 E0 80 02 80 E0 E3 FF FF EA 00 00 A0 E3 F6 FF FF EA 00 00 A0 E3 F1 FF FF EA 00 00 A0 E3 E9 FF FF EA 00 00 A0 E3 E4 FF FF EA 00 00 A0 E3 DF FF FF EA 00 00 A0 E3 DA FF FF EA 00 00 A0 E3 D5 FF FF EA }
	condition:
		$1
}

rule file_182_0_0 {
	meta:
		name = "envz_add"
		size = 176
		refs = "0014 envz_remove 0024 strlen 0040 malloc 0058 memcpy 0084 argz_add 0090 free"
	strings:
		$1 = { F0 47 2D E9 03 60 A0 E1 00 A0 A0 E1 01 90 A0 E1 02 70 A0 E1 ?? ?? ?? ?? 00 00 56 E3 1E 00 00 0A 07 00 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 00 80 A0 E1 00 00 84 E0 02 00 80 E2 ?? ?? ?? ?? 00 50 50 E2 0C 40 A0 03 10 00 00 0A 04 20 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 3D 30 A0 E3 01 00 84 E2 04 30 C5 E7 06 10 A0 E1 01 20 88 E2 00 00 85 E0 ?? ?? ?? ?? 0A 00 A0 E1 09 10 A0 E1 05 20 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 F0 87 BD E8 0A 00 A0 E1 09 10 A0 E1 07 20 A0 E1 F0 47 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_183_0_0 {
	meta:
		name = "isblank"
		size = 20
	strings:
		$1 = { 20 00 50 E3 09 00 50 13 00 00 A0 13 01 00 A0 03 1E FF 2F E1 }
	condition:
		$1
}

rule file_185_0_0 {
	meta:
		name = "wcpncpy"
		size = 124
	strings:
		$1 = { 00 00 52 E3 04 40 2D E5 19 00 00 0A 00 30 91 E5 00 C0 A0 E1 00 00 53 E3 01 20 42 E2 04 30 8C E4 07 00 00 0A 00 00 52 E3 0C 00 A0 E1 10 00 00 0A 04 30 B1 E5 00 00 53 E3 04 30 8C E4 01 20 42 E2 F7 FF FF 1A 00 00 52 E3 00 30 A0 13 02 10 A0 11 03 40 A0 11 04 00 00 0A 01 10 51 E2 03 40 8C E7 04 30 83 E2 FB FF FF 1A 02 C1 8C E0 00 00 50 E3 0C 00 A0 01 10 00 BD E8 1E FF 2F E1 }
	condition:
		$1
}

rule file_186_0_0 {
	meta:
		name = "wcsncmp"
		size = 72
	strings:
		$1 = { 00 00 52 E3 04 40 2D E5 09 00 00 0A 00 30 A0 E3 03 C0 90 E7 03 40 91 E7 04 00 5C E1 07 00 00 1A 00 00 5C E3 02 00 00 0A 01 20 52 E2 04 30 83 E2 F6 FF FF 1A 00 00 A0 E3 10 00 BD E8 1E FF 2F E1 0C 00 64 E0 FB FF FF EA }
	condition:
		$1
}

rule file_187_0_0 {
	meta:
		name = "_fputws_r"
		size = 248
		refs = "0094 _wcsrtombs_r 00b8 __sfvwrite_r 00dc __swsetup_r"
	strings:
		$1 = { F0 45 2D E9 02 40 A0 E1 BC 20 D2 E1 41 DE 4D E2 02 0A 12 E3 0C D0 4D E2 04 10 8D E5 64 10 94 05 02 30 A0 E1 02 3A 82 03 02 2A 81 03 64 20 84 05 BC 30 C4 01 08 00 13 E3 00 60 A0 E1 24 00 00 0A 10 30 94 E5 00 00 53 E3 21 00 00 0A 41 3E 8D E2 04 30 83 E2 0C 70 8D E2 04 70 47 E2 08 34 8D E5 01 30 A0 E3 0C 50 8D E2 01 AB 8D E2 0C 34 8D E5 14 74 8D E5 08 50 45 E2 5C 80 84 E2 08 A0 8A E2 07 10 A0 E1 05 20 A0 E1 01 3B A0 E3 06 00 A0 E1 00 80 8D E5 ?? ?? ?? ?? 00 30 A0 E1 01 00 73 E3 04 10 A0 E1 06 00 A0 E1 0A 20 A0 E1 0D 00 00 0A 18 34 8D E5 10 34 8D E5 ?? ?? ?? ?? 00 00 50 E3 08 00 00 1A 04 00 9D E5 00 00 50 E3 EB FF FF 1A 05 00 00 EA 06 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 D8 FF FF 0A 00 00 E0 E3 1C D0 8D E2 01 DB 8D E2 F0 85 BD E8 }
	condition:
		$1
}

rule file_189_0_0 {
	meta:
		name = "_vasniprintf_r"
		size = 168
		refs = "006c _svfiprintf_r"
	strings:
		$1 = { 30 40 2D E9 00 50 92 E5 00 00 55 E3 00 00 51 13 68 D0 4D E2 02 40 A0 E1 00 C0 A0 03 01 C0 A0 13 06 00 00 0A 00 C0 55 E2 8B 30 A0 B3 00 30 80 B5 00 00 A0 B3 15 00 00 AA 68 D0 8D E2 30 80 BD E8 A2 2F A0 E3 BC 20 CD E1 00 C0 8D E5 10 C0 8D E5 03 20 A0 E1 14 C0 8D E5 74 30 9D E5 08 C0 8D E5 0D 10 A0 E1 00 C0 E0 E3 BE C0 CD E1 ?? ?? ?? ?? 00 00 50 E3 00 30 9D A5 00 20 A0 A3 00 00 84 A5 00 20 C3 A5 00 00 A0 B3 10 00 9D A5 E9 FF FF EA 06 2C A0 E3 08 20 82 E2 BC 20 CD E1 10 10 8D E5 00 10 8D E5 E9 FF FF EA }
	condition:
		$1
}

rule file_265_0_0 {
	meta:
		name = "_vasnprintf_r"
		size = 168
		refs = "006c _svfprintf_r"
	strings:
		$1 = { 30 40 2D E9 00 50 92 E5 00 00 55 E3 00 00 51 13 68 D0 4D E2 02 40 A0 E1 00 C0 A0 03 01 C0 A0 13 06 00 00 0A 00 C0 55 E2 8B 30 A0 B3 00 30 80 B5 00 00 A0 B3 15 00 00 AA 68 D0 8D E2 30 80 BD E8 A2 2F A0 E3 BC 20 CD E1 00 C0 8D E5 10 C0 8D E5 03 20 A0 E1 14 C0 8D E5 74 30 9D E5 08 C0 8D E5 0D 10 A0 E1 00 C0 E0 E3 BE C0 CD E1 ?? ?? ?? ?? 00 00 50 E3 00 30 9D A5 00 20 A0 A3 00 00 84 A5 00 20 C3 A5 00 00 A0 B3 10 00 9D A5 E9 FF FF EA 06 2C A0 E3 08 20 82 E2 BC 20 CD E1 10 10 8D E5 00 10 8D E5 E9 FF FF EA }
	condition:
		$1
}

rule file_190_0_0 {
	meta:
		name = "memccpy"
		size = 196
	strings:
		$1 = { 03 00 53 E3 70 00 2D E9 FF 40 02 E2 00 50 A0 E1 01 60 A0 E1 1B 00 00 9A 00 20 81 E1 03 00 12 E3 18 00 00 1A 04 54 84 E0 05 54 84 E0 00 20 91 E5 05 54 84 E0 05 00 00 EA 04 30 43 E2 03 00 53 E3 04 20 80 E4 04 10 81 E2 0C 00 00 9A 00 20 91 E5 02 60 25 E0 FF C4 86 E2 01 C8 4C E2 01 CC 4C E2 01 C0 4C E2 06 C0 CC E1 7F C4 CC E3 7F C8 CC E3 7F CC CC E3 7F C0 CC E3 00 00 5C E3 ED FF FF 0A 00 50 A0 E1 01 60 A0 E1 05 00 A0 E1 00 C0 A0 E3 00 00 53 E3 08 00 00 0A 0C 20 D6 E7 02 00 54 E1 0C 20 C5 E7 01 00 80 E2 01 C0 8C E2 01 30 43 E2 F6 FF FF 1A 70 00 BD E8 1E FF 2F E1 03 00 A0 E1 FB FF FF EA }
	condition:
		$1
}

rule file_192_0_0 {
	meta:
		name = "_fgetpos_r"
		size = 32
		refs = "0008 _ftell_r"
	strings:
		$1 = { 10 40 2D E9 02 40 A0 E1 ?? ?? ?? ?? 00 00 84 E5 01 00 70 E3 00 00 A0 13 01 00 A0 03 10 80 BD E8 }
	condition:
		$1
}

rule file_193_0_0 {
	meta:
		name = "_vdiprintf_r"
		size = 116
		refs = "002c _vasniprintf_r 004c _write_r 0064 _free_r"
	strings:
		$1 = { F0 40 2D E9 82 DF 4D E2 04 50 8D E2 00 30 8D E5 02 CC A0 E3 02 30 A0 E1 01 70 A0 E1 81 2F 8D E2 05 10 A0 E1 04 C2 8D E5 00 60 A0 E1 ?? ?? ?? ?? 00 40 50 E2 00 00 E0 03 0B 00 00 0A 07 10 A0 E1 06 00 A0 E1 04 20 A0 E1 04 32 9D E5 ?? ?? ?? ?? 05 00 54 E1 04 02 8D E5 03 00 00 0A 06 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 04 02 9D E5 82 DF 8D E2 F0 80 BD E8 }
	condition:
		$1
}

rule file_206_0_0 {
	meta:
		name = "_vdprintf_r"
		size = 116
		refs = "002c _vasnprintf_r 004c _write_r 0064 _free_r"
	strings:
		$1 = { F0 40 2D E9 82 DF 4D E2 04 50 8D E2 00 30 8D E5 02 CC A0 E3 02 30 A0 E1 01 70 A0 E1 81 2F 8D E2 05 10 A0 E1 04 C2 8D E5 00 60 A0 E1 ?? ?? ?? ?? 00 40 50 E2 00 00 E0 03 0B 00 00 0A 07 10 A0 E1 06 00 A0 E1 04 20 A0 E1 04 32 9D E5 ?? ?? ?? ?? 05 00 54 E1 04 02 8D E5 03 00 00 0A 06 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 04 02 9D E5 82 DF 8D E2 F0 80 BD E8 }
	condition:
		$1
}

rule file_194_0_0 {
	meta:
		name = "_buf_findstr"
		size = 200
	strings:
		$1 = { 00 30 92 E5 00 00 53 E3 F0 07 2D E9 03 C0 A0 01 00 A0 91 05 24 00 00 0A 00 C0 A0 E3 00 90 D0 E5 00 A0 91 E5 0C 70 A0 E1 03 00 00 EA 01 70 87 E2 03 00 57 E1 07 C0 A0 E1 19 00 00 2A 0C C0 DA E7 09 00 5C E1 F8 FF FF 1A 00 00 59 E3 1B 00 00 0A 07 C0 DA E7 09 00 5C E1 F3 FF FF 1A 07 50 8A E0 07 C0 A0 E1 00 80 67 E0 02 00 00 EA 01 60 F5 E5 06 00 54 E1 EC FF FF 1A 01 C0 8C E2 0C 40 D8 E7 00 00 54 E3 F8 FF FF 1A 03 30 6C E0 0C C0 8A E0 00 C0 81 E5 00 30 82 E5 01 00 A0 E3 F0 07 BD E8 1E FF 2F E1 00 00 A0 13 FB FF FF 1A 0C C0 8A E0 00 00 A0 E3 00 C0 81 E5 00 00 82 E5 F6 FF FF EA 07 C0 A0 E1 EF FF FF EA }
	condition:
		$1
}

rule file_195_0_0 {
	meta:
		name = "strpbrk"
		size = 120
	strings:
		$1 = { 04 40 2D E5 00 30 D0 E5 00 00 53 E3 03 00 A0 01 11 00 00 0A 00 40 D1 E5 00 00 54 E3 10 00 00 0A 03 00 54 E1 0A 00 00 0A 01 C0 A0 E1 01 00 00 EA 02 00 53 E1 06 00 00 0A 01 20 FC E5 00 00 52 E3 FA FF FF 1A 01 30 F0 E5 00 00 53 E3 F1 FF FF 1A 00 30 DC E5 00 00 53 E3 00 00 A0 03 10 00 BD E8 1E FF 2F E1 01 30 F0 E5 00 00 53 E3 01 C0 A0 E1 E8 FF FF 1A F5 FF FF EA }
	condition:
		$1
}

rule file_196_0_0 {
	meta:
		name = "collect_data"
		size = 348
		refs = "0048 __get_buf 006c free 0074 malloc 00dc memmove 0104 __errno"
	strings:
		$1 = { F0 4F 2D E9 10 40 91 E5 B4 C0 D4 E1 01 50 A0 E1 0C A0 90 E5 B2 10 D4 E1 03 00 5C E3 00 60 A0 E1 0A A0 61 E0 02 80 A0 E1 03 90 A0 E1 0C B0 95 E5 0A 00 00 0A B0 30 D4 E1 83 30 84 E0 B2 10 53 E1 05 20 A0 E1 00 30 A0 E3 ?? ?? ?? ?? 00 10 50 E2 24 00 00 1A 00 70 E0 E3 07 00 A0 E1 F0 8F BD E8 18 01 90 E5 00 00 50 E3 02 70 8A E0 ?? ?? ?? ?? 07 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 18 01 86 E5 F3 FF FF 0A 00 00 59 E3 09 00 00 0A B0 30 D4 E1 01 20 A0 E3 02 00 53 E3 28 21 86 E5 1D 00 00 1A 24 31 96 E5 02 30 83 E0 00 20 A0 E3 20 21 86 E5 24 31 86 E5 0C 30 95 E5 0B B8 A0 E1 2B 08 53 E1 0F 00 00 1A 18 01 96 E5 B2 30 D4 E1 10 10 95 E5 08 00 80 E0 03 10 81 E0 0A 20 A0 E1 ?? ?? ?? ?? 07 00 A0 E1 F0 8F BD E8 09 30 A0 E1 06 00 A0 E1 08 20 8A E0 C1 FF FF EB 00 70 50 E2 EC FF FF CA D3 FF FF EA ?? ?? ?? ?? 16 30 A0 E3 00 30 80 E5 00 70 E0 E3 CF FF FF EA 83 30 84 E0 B2 10 53 E1 06 00 A0 E1 05 20 A0 E1 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 20 01 86 E5 C5 FF FF 0A 10 30 90 E5 B0 30 D3 E1 00 00 53 E3 24 21 96 05 01 20 82 02 24 21 86 05 20 31 86 05 D5 FF FF EA }
	condition:
		$1
}

rule file_196_1_0 {
	meta:
		name = "collect_key"
		size = 288
		refs = "0058 __get_buf 007c free 0084 malloc 00ac __big_return 0104 memmove 010c __errno"
	strings:
		$1 = { F0 4F 2D E9 10 40 91 E5 01 50 A0 E1 B4 10 D4 E1 B2 C0 D4 E1 02 10 41 E2 0C A0 90 E5 01 18 A0 E1 0A A0 6C E0 01 08 51 E3 04 D0 4D E2 00 70 A0 E1 02 80 A0 E1 03 90 A0 E1 0C B0 95 E5 02 60 8A E0 0B 00 00 9A B0 30 D4 E1 83 30 84 E0 B2 10 53 E1 05 20 A0 E1 00 30 A0 E3 ?? ?? ?? ?? 00 10 50 E2 15 00 00 1A 00 60 E0 E3 06 00 A0 E1 04 D0 8D E2 F0 8F BD E8 1C 01 90 E5 00 00 50 E3 ?? ?? ?? ?? 06 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 1C 01 87 E5 F3 FF FF 0A 28 C0 9D E5 09 30 A0 E1 07 00 A0 E1 05 10 A0 E1 01 20 A0 E3 00 C0 8D E5 ?? ?? ?? ?? 00 00 50 E3 08 00 00 0A E9 FF FF EA 28 C0 9D E5 06 20 A0 E1 09 30 A0 E1 07 00 A0 E1 00 C0 8D E5 CA FF FF EB 00 60 50 E2 E1 FF FF DA 0C 30 95 E5 0B B8 A0 E1 2B 08 53 E1 07 00 00 1A 1C 01 97 E5 B2 30 D4 E1 10 10 95 E5 08 00 80 E0 03 10 81 E0 0A 20 A0 E1 ?? ?? ?? ?? D6 FF FF EA ?? ?? ?? ?? 16 30 A0 E3 00 30 80 E5 00 60 E0 E3 D1 FF FF EA }
	condition:
		$1
}

rule file_196_2_0 {
	meta:
		name = "__find_last_page"
		size = 148
		refs = "0068 __get_buf"
	strings:
		$1 = { F0 45 2D E9 00 40 91 E5 01 A0 A0 E1 00 80 A0 E1 10 10 94 E5 00 00 00 EA 10 10 94 E5 B4 C0 D1 E1 03 00 5C E3 B0 C0 D1 E1 8C 50 81 E0 04 20 A0 E1 08 00 A0 E1 00 30 A0 E3 8C 60 A0 E1 05 70 A0 E1 07 00 00 1A 02 00 5C E3 0B 00 00 0A B6 60 91 E1 03 00 56 E1 08 00 00 0A B2 60 D5 E1 03 00 56 E1 05 00 00 1A B2 10 55 E1 ?? ?? ?? ?? 00 40 50 E2 E8 FF FF 1A 00 00 A0 E3 F0 85 BD E8 02 00 5C E3 00 40 8A E5 B6 00 D1 81 F0 85 BD 88 00 00 A0 E3 F0 85 BD E8 }
	condition:
		$1
}

rule file_196_3_0 {
	meta:
		name = "__big_return"
		size = 520
		refs = "0054 __get_buf 01a0 memmove 01f4 __errno"
	strings:
		$1 = { 10 C0 91 E5 82 20 8C E0 B2 20 D2 E1 F0 47 2D E9 01 00 52 E3 01 40 A0 E1 00 50 A0 E1 03 60 A0 E1 20 70 9D E5 04 00 00 0A 0E 00 00 EA 10 C0 94 E5 B4 20 DC E1 01 00 52 E3 0A 00 00 1A B0 30 DC E1 83 C0 8C E0 04 20 A0 E1 B2 10 5C E1 05 00 A0 E1 00 30 A0 E3 ?? ?? ?? ?? 00 40 50 E2 F2 FF FF 1A 00 00 E0 E3 F0 87 BD E8 02 00 52 E3 50 00 00 0A B0 20 DC E1 82 30 8C E0 B2 30 D3 E1 00 00 53 E3 28 00 00 0A 82 30 A0 E1 B3 30 9C E1 B2 10 DC E1 00 00 57 E3 01 10 63 E0 03 30 8C E0 04 10 86 E5 00 30 86 E5 09 00 00 0A 02 00 52 E3 09 00 00 1A 24 31 95 E5 00 00 A0 E3 01 30 83 E2 01 20 A0 E3 28 21 85 E5 24 31 85 E5 20 01 85 E5 F0 87 BD E8 00 00 A0 E3 F0 87 BD E8 82 20 8C E0 B2 10 52 E1 05 00 A0 E1 04 20 A0 E1 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 20 01 85 E5 D8 FF FF 0A 10 30 90 E5 B0 00 D3 E1 01 30 A0 E3 00 00 50 E3 28 31 85 E5 EE FF FF 1A 24 31 95 E5 01 30 83 E2 24 31 85 E5 20 01 85 E5 F0 87 BD E8 82 10 8C E0 82 E0 A0 E1 B2 10 51 E1 05 00 A0 E1 04 20 A0 E1 BE 80 9C E1 B2 A0 DC E1 0C 90 94 E5 ?? ?? ?? ?? 00 10 50 E2 C2 FF FF 0A 0A A0 68 E0 0A A8 A0 E1 2A A8 A0 E1 09 98 A0 E1 29 98 A0 E1 0A 20 A0 E1 07 30 A0 E1 05 00 A0 E1 4A FF FF EB 01 00 70 E3 04 00 86 E5 B6 FF FF 0A 0C 30 94 E5 09 00 53 E1 18 00 00 1A 10 10 94 E5 0A 20 A0 E1 08 10 81 E0 18 01 95 E5 ?? ?? ?? ?? 18 31 95 E5 00 00 A0 E3 00 30 86 E5 F0 87 BD E8 B0 30 DC E1 83 C0 8C E0 B2 10 5C E1 04 20 A0 E1 05 00 A0 E1 00 30 A0 E3 ?? ?? ?? ?? 00 10 50 E2 A1 FF FF 0A 10 30 91 E5 00 20 A0 E3 B2 80 D3 E1 BC 90 D1 E1 01 40 A0 E1 02 A0 A0 E1 DD FF FF EA ?? ?? ?? ?? 16 30 A0 E3 00 30 80 E5 00 00 E0 E3 F0 87 BD E8 }
	condition:
		$1
}

rule file_196_4_0 {
	meta:
		name = "__big_keydata"
		size = 60
	strings:
		$1 = { 30 40 2D E9 04 D0 4D E2 10 C0 9D E5 02 40 A0 E1 00 20 A0 E3 00 50 A0 E1 00 C0 8D E5 AF FF FF EB 01 00 70 E3 1C 31 95 15 04 00 84 E5 00 30 84 15 00 00 A0 13 04 D0 8D E2 30 80 BD E8 }
	condition:
		$1
}

rule file_196_5_0 {
	meta:
		name = "__big_split"
		size = 456
		refs = "0034 __big_keydata 0058 __call_hash 0068 __find_last_page 0164 __get_buf 01b4 __add_ovflpage"
	strings:
		$1 = { F0 4F 2D E9 20 D0 4D E2 0C 30 8D E5 00 C0 A0 E3 03 50 A0 E1 01 80 A0 E1 02 70 A0 E1 03 10 A0 E1 18 20 8D E2 10 30 8D E2 00 C0 8D E5 00 60 A0 E1 4C 40 9D E5 ?? ?? ?? ?? 00 A0 50 E2 02 00 00 0A 00 00 E0 E3 20 D0 8D E2 F0 8F BD E8 18 10 8D E2 06 00 91 E8 06 00 A0 E1 ?? ?? ?? ?? 0C 10 8D E2 00 90 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 BC 00 C4 E1 08 00 84 05 35 00 00 1A 48 30 9D E5 03 90 59 E0 01 90 A0 13 00 00 59 E3 07 20 A0 11 08 20 A0 01 14 30 D2 E5 01 30 83 E3 14 30 C2 E5 10 30 92 E5 B0 C0 D3 E1 01 00 8C E2 00 A8 A0 E1 2A A8 A0 E1 01 10 8A E2 01 18 A0 E1 21 18 A0 E1 8C C0 83 E0 B4 B0 DC E1 81 C0 83 E0 08 C0 8D E5 81 C0 A0 E1 04 C0 8D E5 B4 C4 DD E1 8A A0 A0 E1 80 00 A0 E1 B0 00 93 E1 BA C0 83 E1 04 A0 9D E5 00 C0 A0 E3 BA C0 83 E1 B0 10 C3 E1 08 10 9D E5 B4 B0 C1 E1 B0 10 D3 E1 08 50 82 E5 81 30 83 E0 80 01 84 E8 04 00 40 E2 B2 00 C3 E1 0C 10 9D E5 14 30 D1 E5 01 30 83 E3 14 30 C1 E5 10 50 91 E5 B0 30 D5 E1 02 00 53 E3 0E 00 00 8A 00 00 59 E3 00 10 84 15 00 00 A0 13 04 10 84 05 09 00 A0 01 BB FF FF EA 00 10 A0 E1 0A 30 A0 E1 06 00 A0 E1 0C 20 9D E5 ?? ?? ?? ?? 00 00 50 E3 08 00 84 E5 C1 FF FF 1A B1 FF FF EA 83 00 85 E0 02 20 43 E2 B2 E0 D0 E1 02 28 A0 E1 22 28 A0 E1 82 C0 85 E0 04 E0 8E E2 B4 00 D0 E1 B8 70 D5 E1 B0 20 C5 E1 B2 E0 CC E1 B0 30 D5 E1 83 30 85 E0 B4 00 C3 E1 06 00 A0 E1 ?? ?? ?? ?? 00 10 50 E2 9F FF FF 0A B8 70 C5 E1 DC FF FF EA }
	condition:
		$1
}

rule file_196_6_0 {
	meta:
		name = "__find_bigpair"
		size = 288
		refs = "0068 __get_buf 00b0 memcmp"
	strings:
		$1 = { F0 4F 2D E9 10 50 91 E5 02 C0 A0 E1 00 70 A0 E1 82 20 A0 E1 B2 00 95 E1 0C 40 97 E5 04 D0 4D E2 04 40 60 E0 04 48 A0 E1 28 B0 9D E5 24 48 A0 E1 04 00 5B E1 01 60 A0 E1 0C A0 A0 E1 23 00 00 BA 8C 20 85 E0 B2 20 D2 E1 01 00 52 E3 03 80 A0 11 0B 90 A0 11 22 00 00 1A 03 80 A0 E1 0B 90 A0 E1 0F 00 00 EA B4 10 D5 E1 ?? ?? ?? ?? 00 60 50 E2 28 00 00 0A 10 50 96 E5 0C 40 97 E5 B2 00 D5 E1 04 40 60 E0 04 48 A0 E1 24 48 A0 E1 04 00 5B E1 12 00 00 BA B4 30 D5 E1 01 00 53 E3 01 A0 A0 E3 0E 00 00 1A 00 00 85 E0 08 10 A0 E1 04 20 A0 E1 ?? ?? ?? ?? 00 30 50 E2 8A 50 85 E0 06 20 A0 E1 09 90 64 E0 04 80 88 E0 07 00 A0 E1 E4 FF FF 0A 01 C0 E0 E3 0C 00 A0 E1 04 D0 8D E2 F0 8F BD E8 01 C0 A0 E3 04 00 59 E1 F8 FF FF 1A 8C 30 A0 E1 B3 00 95 E1 08 10 A0 E1 00 00 85 E0 09 20 A0 E1 00 C0 8D E5 ?? ?? ?? ?? 00 00 50 E3 00 C0 9D E5 EF FF FF 0A ED FF FF EA 02 C0 E0 E3 EC FF FF EA }
	condition:
		$1
}

rule file_196_7_0 {
	meta:
		name = "__big_delete"
		size = 388
		refs = "0054 __get_buf 0068 __free_ovflpage"
	strings:
		$1 = { 10 30 91 E5 B4 20 D3 E1 F0 41 2D E9 01 70 A0 E1 01 80 A0 E1 02 10 42 E2 01 18 A0 E1 00 50 A0 E3 01 08 51 E3 00 60 A0 E1 05 40 A0 E1 B0 20 D3 81 1C 00 00 9A 14 00 D8 E5 82 30 83 E0 B2 10 53 E1 01 30 80 E3 14 30 C8 E5 08 20 A0 E1 06 00 A0 E1 00 30 A0 E3 ?? ?? ?? ?? 00 00 54 E3 00 80 A0 E1 04 10 A0 11 06 00 A0 11 ?? ?? ?? ?? 00 00 58 E3 41 00 00 0A 10 30 98 E5 00 00 55 E3 B4 20 D3 01 02 00 00 0A B4 20 D3 E1 03 00 52 E3 11 00 00 0A 02 10 42 E2 01 18 A0 E1 01 08 51 E3 08 40 A0 E1 B0 20 D3 81 E2 FF FF 8A 03 00 52 E3 B0 20 D3 11 01 50 A0 13 DE FF FF 1A B0 20 D3 E1 82 10 83 E0 B2 10 D1 E1 00 00 51 E3 02 10 A0 E1 03 00 00 1A 01 50 A0 E3 D6 FF FF EA B0 10 D3 E1 08 40 A0 E1 02 00 51 E3 81 30 83 E0 B2 20 53 E1 08 00 98 C5 10 30 97 E5 00 20 A0 D3 B2 20 C3 C1 08 00 87 C5 00 20 A0 C3 02 00 41 E2 B4 20 C3 C1 08 20 87 D5 00 08 A0 E1 0C 20 96 E5 20 08 A0 E1 01 10 81 E2 80 C0 83 E0 81 10 42 E0 B0 00 C3 E1 B2 10 CC E1 B0 10 D3 E1 01 20 42 E2 81 30 83 E0 B4 20 C3 E1 14 30 D7 E5 01 30 83 E3 14 30 C7 E5 06 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 08 00 54 E1 04 10 A0 11 06 00 A0 11 ?? ?? ?? ?? 38 30 96 E5 01 30 43 E2 38 30 86 E5 00 00 A0 E3 F0 81 BD E8 00 00 E0 E3 F0 81 BD E8 }
	condition:
		$1
}

rule file_196_8_0 {
	meta:
		name = "__big_insert"
		size = 776
		refs = "0050 MIN 0080 memmove 00d4 __add_ovflpage"
	strings:
		$1 = { F0 4F 2D E9 10 40 91 E5 01 50 A0 E1 B0 10 D4 E1 81 10 84 E0 B2 70 D1 E1 04 90 92 E5 08 70 47 E2 08 D0 4D E2 07 78 A0 E1 00 00 59 E3 09 00 8D E8 27 78 A0 E1 00 A0 92 E5 00 B0 93 E5 04 60 93 E5 3C 00 00 0A 07 00 A0 E1 06 80 A0 E1 09 10 A0 E1 ?? ?? ?? ?? B0 30 D4 E1 83 30 84 E0 B4 70 D3 E1 00 08 A0 E1 20 68 A0 E1 07 70 66 E0 07 78 A0 E1 27 78 A0 E1 0A 10 A0 E1 06 20 A0 E1 07 00 84 E0 ?? ?? ?? ?? B0 C0 D4 E1 01 10 8C E2 01 30 81 E2 03 28 A0 E1 22 28 A0 E1 05 C0 8C E2 82 00 84 E0 8C C0 47 E0 81 10 A0 E1 B1 70 84 E1 B0 20 C4 E1 B2 C0 C0 E1 B0 20 D4 E1 82 20 84 E0 B4 70 C2 E1 83 30 A0 E1 01 20 A0 E3 05 10 A0 E1 B3 20 84 E1 00 00 9D E5 ?? ?? ?? ?? 00 50 50 E2 06 A0 8A E0 86 00 00 0A 06 90 59 E0 B0 70 D4 E1 3F 00 00 1A 87 30 84 E0 B2 00 D3 E1 00 00 50 E3 87 40 84 00 02 20 A0 03 08 60 A0 E1 B4 20 44 01 42 00 00 1A 14 30 D5 E5 01 30 83 E3 14 30 C5 E5 10 40 95 E5 B0 30 D4 E1 83 30 84 E0 B2 70 D3 E1 08 70 47 E2 07 78 A0 E1 27 78 A0 E1 00 00 56 E3 28 00 00 0A 04 A0 9D E5 06 10 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 07 00 56 E1 00 08 A0 E1 0B 10 A0 E1 20 78 A0 E1 4C 00 00 0A B0 30 D4 E1 83 30 84 E0 B4 80 D3 E1 08 80 67 E0 08 88 A0 E1 28 88 A0 E1 07 20 A0 E1 08 00 84 E0 ?? ?? ?? ?? B0 C0 D4 E1 01 20 8C E2 01 10 82 E2 01 38 A0 E1 23 38 A0 E1 05 C0 8C E2 83 00 84 E0 8C C0 48 E0 82 20 A0 E1 B2 80 84 E1 B0 30 C4 E1 B2 C0 C0 E1 B0 30 D4 E1 07 60 56 E0 83 30 84 E0 B4 80 C3 E1 38 00 00 1A 81 10 A0 E1 03 20 A0 E3 B1 20 84 E1 14 30 D5 E5 01 30 83 E3 14 30 C5 E5 06 00 A0 E1 08 D0 8D E2 F0 8F BD E8 14 30 D5 E5 01 30 83 E3 14 30 C5 E5 10 40 95 E5 B0 30 D4 E1 83 30 84 E0 B2 00 D3 E1 08 00 40 E2 00 08 A0 E1 20 08 A0 E1 8B FF FF EA 08 10 A0 E1 ?? ?? ?? ?? B0 30 D4 E1 83 30 84 E0 B4 A0 D3 E1 00 08 A0 E1 20 88 A0 E1 0A A0 68 E0 0A A8 A0 E1 87 30 A0 E1 2A A8 A0 E1 B3 A0 84 E1 0B 10 A0 E1 0A 00 84 E0 08 20 A0 E1 ?? ?? ?? ?? 87 70 84 E0 03 30 A0 E3 B4 30 47 E1 B0 30 D4 E1 01 30 83 E2 83 30 A0 E1 B3 20 94 E1 02 20 68 E0 B3 20 84 E1 B0 30 D4 E1 83 40 84 E0 B4 A0 C4 E1 08 B0 8B E0 06 60 68 E0 9D FF FF EA 04 30 9A E5 03 00 56 E1 01 70 47 02 07 78 A0 01 27 78 A0 01 AC FF FF EA 81 10 A0 E1 02 30 A0 E3 B1 30 84 E1 00 00 9D E5 05 10 A0 E1 ?? ?? ?? ?? 00 50 50 E2 0B 00 00 0A 14 30 D5 E5 01 30 83 E3 14 30 C5 E5 10 40 95 E5 B0 30 D4 E1 83 30 84 E0 B2 30 D3 E1 08 30 43 E2 03 38 A0 E1 07 B0 8B E0 23 78 A0 E1 90 FF FF EA 00 60 E0 E3 B6 FF FF EA }
	condition:
		$1
}

rule file_197_0_0 {
	meta:
		name = "__libc_fini_array"
		size = 64
		refs = "0034 _fini 0038 __fini_array_start 003c __fini_array_end"
	strings:
		$1 = { 70 40 2D E9 2C 50 9F E5 2C 60 9F E5 06 60 65 E0 46 61 B0 E1 05 00 00 0A 00 40 A0 E3 0F E0 A0 E1 04 F1 95 E7 01 40 84 E2 04 00 56 E1 FA FF FF 8A 70 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_197_1_0 {
	meta:
		name = "__libc_init_array"
		size = 116
		refs = "003c _init 0064 __preinit_array_start 0068 __preinit_array_end 006c __init_array_start 0070 __init_array_end"
	strings:
		$1 = { 70 40 2D E9 58 50 9F E5 58 60 9F E5 06 60 65 E0 46 61 B0 E1 05 00 00 0A 00 40 A0 E3 0F E0 A0 E1 04 F1 95 E7 01 40 84 E2 04 00 56 E1 FA FF FF 8A 34 50 9F E5 34 60 9F E5 06 60 65 E0 ?? ?? ?? ?? 46 61 B0 E1 70 80 BD 08 00 40 A0 E3 0F E0 A0 E1 04 F1 95 E7 01 40 84 E2 04 00 56 E1 FA FF FF 8A 70 80 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_198_0_0 {
	meta:
		name = "fcntl"
		size = 24
		refs = "0004 __errno"
	strings:
		$1 = { 04 E0 2D E5 ?? ?? ?? ?? 58 30 A0 E3 00 30 80 E5 00 00 E0 E3 04 F0 9D E4 }
	condition:
		$1
}

rule file_199_0_0 {
	meta:
		name = "wcwidth"
		size = 60
		refs = "0008 iswprint 001c iswcntrl"
	strings:
		$1 = { 10 40 2D E9 00 40 A0 E1 ?? ?? ?? ?? 00 00 50 E3 01 00 A0 13 10 80 BD 18 04 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 02 00 00 1A 00 00 54 E3 00 00 E0 13 10 80 BD 18 00 00 A0 E3 10 80 BD E8 }
	condition:
		$1
}

rule file_203_0_0 {
	meta:
		name = "iswctype"
		size = 120
		refs = "0040 iswxdigit 004c iswalnum 0050 iswalpha 0054 iswblank 0058 iswcntrl 005c iswdigit 0060 iswgraph 0064 iswlower 0068 iswprint 006c iswpunct 0070 iswspace 0074 iswupper"
	strings:
		$1 = { 01 10 41 E2 0B 00 51 E3 01 F1 9F 97 0C 00 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 A0 E3 1E FF 2F E1 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_204_0_0 {
	meta:
		name = "argz_create"
		size = 172
		refs = "0034 strlen 0058 malloc 0090 memcpy"
	strings:
		$1 = { F0 45 2D E9 00 50 90 E5 00 80 A0 E3 00 00 55 E3 00 60 A0 E1 02 70 A0 E1 01 A0 A0 E1 00 80 82 E5 00 50 81 05 05 00 A0 01 F0 85 BD 08 08 40 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 01 40 84 E2 04 51 96 E7 08 80 80 E0 01 80 88 E2 00 00 55 E3 00 80 87 E5 F6 FF FF 1A 08 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 00 70 A0 E1 00 00 8A E5 0C 00 A0 03 F0 85 BD 08 05 80 A0 E1 05 00 96 E7 ?? ?? ?? ?? 01 A0 80 E2 05 10 96 E7 07 00 A0 E1 01 80 88 E2 0A 20 A0 E1 ?? ?? ?? ?? 08 00 54 E1 0A 70 87 E0 04 50 85 E2 F3 FF FF CA 00 00 A0 E3 F0 85 BD E8 }
	condition:
		$1
}

rule file_205_0_0 {
	meta:
		name = "wcsncat"
		size = 108
	strings:
		$1 = { 00 30 90 E5 00 00 53 E3 04 40 2D E5 00 C0 A0 01 03 00 00 0A 00 C0 A0 E1 04 30 BC E5 00 00 53 E3 FC FF FF 1A 00 30 91 E5 00 00 52 E3 00 00 53 13 09 00 00 0A 04 30 8C E4 01 20 52 E2 04 30 B1 E5 00 40 A0 03 01 40 A0 13 00 00 53 E3 00 40 A0 03 01 40 04 12 00 00 54 E3 F5 FF FF 1A 00 30 A0 E3 00 30 8C E5 10 00 BD E8 1E FF 2F E1 }
	condition:
		$1
}

rule file_209_0_0 {
	meta:
		name = "wcsspn"
		size = 116
	strings:
		$1 = { 00 30 90 E5 00 00 53 E3 30 00 2D E9 03 00 A0 01 0F 00 00 0A 00 50 91 E5 00 00 55 E3 00 40 A0 11 11 00 00 0A 05 00 53 E1 01 20 A0 11 03 00 00 1A 09 00 00 EA 0C 00 53 E1 04 20 82 E2 06 00 00 0A 04 C0 92 E5 00 00 5C E3 F9 FF FF 1A 04 00 60 E0 40 01 A0 E1 30 00 BD E8 1E FF 2F E1 04 30 B4 E5 00 00 53 E3 EE FF FF 1A F7 FF FF EA 05 00 A0 E1 F7 FF FF EA }
	condition:
		$1
}

rule file_210_0_0 {
	meta:
		name = "_mbstowcs_r"
		size = 144
		refs = "0058 _mbtowc_r 008c __mb_cur_max"
	strings:
		$1 = { F0 4F 2D E9 00 90 53 E2 04 D0 4D E2 00 80 A0 E1 01 B0 A0 E1 28 A0 9D E5 16 00 00 0A 68 70 9F E5 02 50 A0 E1 01 40 A0 E1 09 60 A0 E1 04 00 00 EA 12 00 00 0A 01 60 56 E2 0E 00 00 0A 00 50 85 E0 04 40 84 E2 00 30 97 E5 04 10 A0 E1 05 20 A0 E1 08 00 A0 E1 00 A0 8D E5 ?? ?? ?? ?? 00 00 50 E3 F2 FF FF AA 00 30 A0 E3 00 30 8A E5 00 00 E0 E3 04 D0 8D E2 F0 8F BD E8 09 00 A0 E1 FB FF FF EA 04 00 6B E0 40 01 A0 E1 F8 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_211_0_0 {
	meta:
		name = "finite"
		size = 20
	strings:
		$1 = { 02 01 C0 E3 02 01 80 E2 01 06 80 E2 A0 0F A0 E1 1E FF 2F E1 }
	condition:
		$1
}

rule file_212_0_0 {
	meta:
		name = "_strndup_r"
		size = 128
		refs = "004c _malloc_r 0060 memcpy"
	strings:
		$1 = { 00 00 52 E3 70 40 2D E9 01 60 A0 E1 18 00 00 0A 00 30 D1 E5 00 00 53 E3 15 00 00 0A 01 20 42 E2 01 40 A0 E1 03 00 00 EA 00 30 D4 E5 00 00 53 E3 01 20 42 E2 02 00 00 0A 00 00 52 E3 01 40 84 E2 F8 FF FF 1A 04 40 66 E0 01 10 84 E2 ?? ?? ?? ?? 00 50 50 E2 04 00 00 0A 06 10 A0 E1 04 20 A0 E1 ?? ?? ?? ?? 00 30 A0 E3 04 30 C5 E7 05 00 A0 E1 70 80 BD E8 01 10 A0 E3 00 40 A0 E3 F2 FF FF EA }
	condition:
		$1
}

rule file_213_0_0 {
	meta:
		name = "isinff"
		size = 28
		altNames = "__isinff"
	strings:
		$1 = { 7F 34 A0 E3 02 35 83 E2 02 01 C0 E3 03 00 50 E1 00 00 A0 13 01 00 A0 03 1E FF 2F E1 }
	condition:
		$1
}

rule file_215_0_0 {
	meta:
		name = "wcscpy"
		size = 56
	strings:
		$1 = { 00 30 A0 E3 00 30 80 E5 00 30 91 E5 00 00 53 E3 00 20 A0 01 04 00 00 0A 00 20 A0 E1 04 30 82 E4 04 30 B1 E5 00 00 53 E3 FB FF FF 1A 00 30 A0 E3 00 30 82 E5 1E FF 2F E1 }
	condition:
		$1
}

rule file_216_0_0 {
	meta:
		name = "gcvt"
		size = 128
		refs = "0020 __ltdf2 0064 _gcvt 007c _impure_ptr"
	strings:
		$1 = { F0 40 2D E9 03 40 A0 E1 0C D0 4D E2 02 50 A0 E1 00 30 A0 E3 00 20 A0 E3 01 70 A0 E1 00 60 A0 E1 ?? ?? ?? ?? 00 00 50 E3 04 C0 A0 B1 2D 30 A0 B3 01 30 CC B4 40 30 9F E5 04 C0 A0 A1 00 00 93 E5 01 50 45 B2 00 C0 8D E5 67 C0 A0 E3 04 C0 8D E5 06 10 A0 E1 00 C0 A0 E3 07 20 A0 E1 05 30 A0 E1 08 C0 8D E5 ?? ?? ?? ?? 00 00 50 E3 04 00 A0 11 00 00 A0 03 0C D0 8D E2 F0 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_216_1_0 {
	meta:
		name = "gcvtf"
		size = 32
		refs = "000c __extendsfdf2 001c gcvt"
	strings:
		$1 = { 30 40 2D E9 02 40 A0 E1 01 50 A0 E1 ?? ?? ?? ?? 05 20 A0 E1 04 30 A0 E1 30 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_216_2_0 {
	meta:
		name = "ecvt"
		size = 36
		refs = "0018 ecvtbuf"
	strings:
		$1 = { 04 E0 2D E5 08 D0 4D E2 0C C0 9D E5 00 C0 8D E5 00 C0 A0 E3 04 C0 8D E5 ?? ?? ?? ?? 08 D0 8D E2 00 80 BD E8 }
	condition:
		$1
}

rule file_216_4_0 {
	meta:
		name = "fcvt"
		size = 36
		refs = "0018 fcvtbuf"
	strings:
		$1 = { 04 E0 2D E5 08 D0 4D E2 0C C0 9D E5 00 C0 8D E5 00 C0 A0 E3 04 C0 8D E5 ?? ?? ?? ?? 08 D0 8D E2 00 80 BD E8 }
	condition:
		$1
}

rule file_216_3_0 {
	meta:
		name = "ecvtf"
		size = 48
		refs = "0014 __extendsfdf2 0024 ecvt"
	strings:
		$1 = { 70 40 2D E9 02 50 A0 E1 04 D0 4D E2 01 60 A0 E1 03 40 A0 E1 ?? ?? ?? ?? 06 20 A0 E1 05 30 A0 E1 00 40 8D E5 ?? ?? ?? ?? 04 D0 8D E2 70 80 BD E8 }
	condition:
		$1
}

rule file_216_5_0 {
	meta:
		name = "fcvtf"
		size = 48
		refs = "0014 __extendsfdf2 0024 fcvt"
	strings:
		$1 = { 70 40 2D E9 02 50 A0 E1 04 D0 4D E2 01 60 A0 E1 03 40 A0 E1 ?? ?? ?? ?? 06 20 A0 E1 05 30 A0 E1 00 40 8D E5 ?? ?? ?? ?? 04 D0 8D E2 70 80 BD E8 }
	condition:
		$1
}

rule file_217_0_0 {
	meta:
		name = "__log2"
		size = 44
	strings:
		$1 = { 01 00 50 E3 00 20 A0 93 05 00 00 9A 00 20 A0 E3 01 30 A0 E3 83 30 A0 E1 03 00 50 E1 01 20 82 E2 FB FF FF 8A 02 00 A0 E1 1E FF 2F E1 }
	condition:
		$1
}

rule file_219_0_0 {
	meta:
		name = "iswgraph"
		size = 40
		refs = "0008 iswprint 0018 iswspace"
	strings:
		$1 = { 10 40 2D E9 00 40 A0 E1 ?? ?? ?? ?? 00 00 50 E3 10 80 BD 08 04 00 A0 E1 ?? ?? ?? ?? 01 00 70 E2 00 00 A0 33 10 80 BD E8 }
	condition:
		$1
}

rule file_223_0_0 {
	meta:
		name = "_fgetwc_r"
		size = 308
		refs = "0060 _mbrtowc_r 00b8 __srefill_r 0100 __errno 0130 __mb_cur_max"
	strings:
		$1 = { BC 30 D1 E1 F0 40 2D E9 02 0A 13 E3 64 20 91 05 02 3A 83 03 BC 30 C1 01 04 30 91 E5 02 2A 82 03 64 20 81 05 00 00 53 E3 08 D0 4D E2 01 40 A0 E1 00 50 A0 E1 1F 00 00 DA F0 20 9F E5 00 20 92 E5 01 00 52 E3 5C 70 84 12 04 60 8D 12 23 00 00 0A 00 20 94 E5 06 10 A0 E1 05 00 A0 E1 00 70 8D E5 ?? ?? ?? ?? 01 00 70 E3 21 00 00 0A 02 00 70 E3 27 00 00 0A 00 00 50 E3 07 00 00 0A 0C 00 94 E8 03 30 60 E0 04 30 84 E5 00 00 82 E0 00 00 84 E5 04 00 9D E5 08 D0 8D E2 F0 80 BD E8 00 30 94 E5 04 20 94 E5 01 30 83 E2 01 20 42 E2 04 20 84 E5 00 30 84 E5 F6 FF FF EA ?? ?? ?? ?? 00 00 50 E3 11 00 00 1A 64 20 9F E5 00 20 92 E5 01 00 52 E3 04 30 94 E5 5C 70 84 12 04 60 8D 12 DB FF FF 1A 00 20 94 E5 01 00 D2 E4 01 30 43 E2 0C 00 84 E8 E7 FF FF EA BC 30 D4 E1 40 30 83 E3 BC 30 C4 E1 ?? ?? ?? ?? 8A 30 A0 E3 00 30 80 E5 00 00 E0 E3 DF FF FF EA 05 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 F2 FF FF 1A 04 30 94 E5 C7 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_223_1_0 {
	meta:
		name = "fgetwc"
		size = 68
		refs = "0028 __sinit 003c _fgetwc_r 0040 _impure_ptr"
	strings:
		$1 = { 30 40 2D E9 34 40 9F E5 00 30 94 E5 00 00 53 E3 00 50 A0 E1 05 00 00 0A 38 20 93 E5 00 00 52 E3 02 00 00 1A 03 00 A0 E1 ?? ?? ?? ?? 00 30 94 E5 03 00 A0 E1 05 10 A0 E1 30 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_224_0_0 {
	meta:
		name = "_fopen_r"
		size = 224
		refs = "0018 __sflags 0038 __sfp 0058 _open_r 00b0 _fseek_r 00b8 __sfp_lock_acquire 00c4 __sfp_lock_release 00d0 __sread 00d4 __swrite 00d8 __sseek 00dc __sclose"
	strings:
		$1 = { F0 40 2D E9 04 D0 4D E2 01 70 A0 E1 02 10 A0 E1 0D 20 A0 E1 00 60 A0 E1 ?? ?? ?? ?? 00 50 50 E2 05 40 A0 01 02 00 00 1A 04 00 A0 E1 04 D0 8D E2 F0 80 BD E8 06 00 A0 E1 ?? ?? ?? ?? 00 40 50 E2 F8 FF FF 0A 6D 3F A0 E3 07 10 A0 E1 02 30 83 E2 06 00 A0 E1 00 20 9D E5 ?? ?? ?? ?? 00 00 50 E3 14 00 00 BA 64 30 9F E5 20 30 84 E5 60 30 9F E5 24 30 84 E5 5C 30 9F E5 05 58 A0 E1 25 58 A0 E1 28 30 84 E5 50 30 9F E5 01 0C 15 E3 BE 00 C4 E1 2C 30 84 E5 BC 50 C4 E1 1C 40 84 E5 E1 FF FF 0A 06 00 A0 E1 04 10 A0 E1 00 20 A0 E3 02 30 A0 E3 ?? ?? ?? ?? DB FF FF EA ?? ?? ?? ?? 00 30 A0 E3 BC 30 C4 E1 ?? ?? ?? ?? 00 40 A0 E3 D5 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_225_0_0 {
	meta:
		name = "strcmp"
		size = 216
	strings:
		$1 = { 00 30 81 E1 03 00 13 E3 1E 00 00 1A 00 20 90 E5 00 30 91 E5 03 00 52 E1 1A 00 00 1A FF 34 82 E2 01 38 43 E2 01 3C 43 E2 01 30 43 E2 02 30 C3 E1 7F 34 C3 E3 7F 38 C3 E3 7F 3C C3 E3 7F 30 C3 E3 00 00 53 E3 02 00 00 0A 20 00 00 EA 00 00 53 E3 1E 00 00 1A 04 20 B0 E5 FF 34 82 E2 01 38 43 E2 01 3C 43 E2 01 30 43 E2 02 30 C3 E1 7F 34 C3 E3 04 C0 B1 E5 7F 38 C3 E3 7F 3C C3 E3 0C 00 52 E1 7F 30 C3 E3 F0 FF FF 0A 00 30 D0 E5 00 00 53 E3 0B 00 00 0A 00 20 D1 E5 02 00 53 E1 04 00 00 0A 08 00 00 EA 00 20 D1 E5 02 00 53 E1 01 00 80 E2 04 00 00 1A 01 30 D0 E5 00 00 53 E3 01 10 81 E2 F7 FF FF 1A 00 20 D1 E5 03 00 62 E0 1E FF 2F E1 00 00 A0 E3 1E FF 2F E1 }
	condition:
		$1
}

rule file_226_0_0 {
	meta:
		name = "_srand48_r"
		size = 76
	strings:
		$1 = { 21 3C E0 E3 13 30 43 E2 33 CC A0 E3 66 2D E0 E3 B4 3B C0 E1 0B 30 A0 E3 04 40 2D E5 0E C0 8C E2 21 48 A0 E1 12 20 42 E2 B8 3B C0 E1 05 30 A0 E3 BC CA C0 E1 B0 4B C0 E1 B2 2B C0 E1 BE 1A C0 E1 B6 3B C0 E1 10 00 BD E8 1E FF 2F E1 }
	condition:
		$1
}

rule file_226_1_0 {
	meta:
		name = "srand48"
		size = 88
		refs = "0054 _impure_ptr"
	strings:
		$1 = { 4C 30 9F E5 21 2C E0 E3 00 30 93 E5 13 20 42 E2 04 40 2D E5 33 CC A0 E3 66 1D E0 E3 B4 2B C3 E1 0B 20 A0 E3 0E C0 8C E2 20 48 A0 E1 12 10 41 E2 B8 2B C3 E1 05 20 A0 E3 BC CA C3 E1 B0 4B C3 E1 B2 1B C3 E1 BE 0A C3 E1 B6 2B C3 E1 10 00 BD E8 1E FF 2F E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_227_0_0 {
	meta:
		name = "__ten_mul"
		size = 80
		refs = "001c __muldf3 002c __floatsidf 0040 __adddf3"
	strings:
		$1 = { 01 21 A0 E3 F0 40 2D E9 09 27 82 E2 00 40 A0 E1 01 50 A0 E1 00 30 A0 E3 03 00 90 E8 ?? ?? ?? ?? 00 60 A0 E1 05 00 A0 E1 01 70 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 03 00 84 E8 00 00 A0 E3 F0 80 BD E8 }
	condition:
		$1
}

rule file_228_0_0 {
	meta:
		name = "_perror_r"
		size = 96
		refs = "0020 strerror 002c fputs 003c fputc"
	strings:
		$1 = { 00 00 51 E3 10 40 2D E9 00 40 A0 E1 02 00 00 0A 00 30 D1 E5 00 00 53 E3 08 00 00 1A 00 00 94 E5 ?? ?? ?? ?? 00 00 50 E3 0C 10 94 15 ?? ?? ?? ?? 0C 10 94 E5 0A 00 A0 E3 10 40 BD E8 ?? ?? ?? ?? 01 00 A0 E1 0C 10 94 E5 ?? ?? ?? ?? 0C 10 94 E5 04 00 9F E5 ?? ?? ?? ?? EF FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_231_0_0 {
	meta:
		name = "__part_load_locale"
		size = 716
		refs = "0038 strcmp 009c strlen 00f0 strcpy 00fc strcat 012c open 0144 fstat 0180 realloc 01b8 read 01cc close 0204 strchr 0268 free 029c malloc 02c0 _PathLocale"
	strings:
		$1 = { F0 4F 2D E9 03 B0 A0 E1 11 DD 4D E2 00 30 A0 E3 04 D0 4D E2 00 A0 91 E5 00 50 50 E2 00 30 81 E5 01 40 A0 E1 02 90 A0 E1 68 84 9D E5 70 74 9D E5 8F 00 00 0A 78 12 9F E5 ?? ?? ?? ?? 00 00 50 E3 03 00 00 1A 00 00 A0 E3 44 D0 8D E2 01 DB 8D E2 F0 8F BD E8 05 00 A0 E1 58 12 9F E5 ?? ?? ?? ?? 00 00 50 E3 F6 FF FF 0A 00 00 59 E3 15 00 00 0A 05 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 10 00 00 1A 30 32 9F E5 00 60 93 E5 00 00 56 E3 08 00 00 DA 00 50 A0 E1 09 00 A0 E1 ?? ?? ?? ?? 01 00 80 E2 00 90 89 E0 05 91 87 E7 01 50 85 E2 05 00 56 E1 F7 FF FF CA 01 30 A0 E3 00 30 84 E5 00 00 A0 E3 DF FF FF EA 05 00 A0 E1 ?? ?? ?? ?? E8 31 9F E5 00 10 93 E5 00 00 51 E3 04 00 8D E5 63 00 00 0A 14 60 8D E2 0C 60 46 E2 06 00 A0 E1 ?? ?? ?? ?? C8 11 9F E5 06 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? B0 11 9F E5 06 00 A0 E1 ?? ?? ?? ?? 0B 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 06 00 A0 E1 00 10 A0 E3 ?? ?? ?? ?? 00 20 50 E2 00 20 8D E5 4D 00 00 BA 01 1B 8D E2 08 10 81 E2 ?? ?? ?? ?? 00 00 50 E3 46 00 00 1A 18 14 9D E5 00 00 51 E3 43 00 00 DA 04 30 9D E5 00 00 59 E3 01 B0 83 E2 01 10 8B E0 49 00 00 0A 50 31 9F E5 03 00 59 E1 46 00 00 0A 09 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 00 60 A0 11 45 00 00 0A 00 00 56 E3 34 00 00 0A 05 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 18 94 9D E5 0B 50 86 E0 00 00 9D E5 05 10 A0 E1 09 20 A0 E1 ?? ?? ?? ?? 18 34 9D E5 03 00 50 E1 26 00 00 1A 00 00 9D E5 ?? ?? ?? ?? 00 00 50 E3 22 00 00 1A 09 90 85 E0 01 30 59 E5 0A 00 53 E3 1E 00 00 1A 09 00 55 E1 00 A0 A0 21 09 00 00 2A 00 A0 A0 E1 00 B0 A0 E1 05 00 A0 E1 0A 10 A0 E3 ?? ?? ?? ?? 00 50 A0 E1 01 B0 C5 E4 05 00 59 E1 01 A0 8A E2 F7 FF FF 8A 98 30 9F E5 0A 00 58 E1 00 A0 83 E5 00 80 83 D5 13 00 00 CA 00 00 58 E3 9F FF FF DA 00 50 A0 E3 06 00 A0 E1 ?? ?? ?? ?? 01 00 80 E2 00 60 86 E0 05 61 87 E7 01 50 85 E2 05 00 58 E1 F7 FF FF CA 95 FF FF EA 00 A0 A0 E3 06 00 A0 E1 ?? ?? ?? ?? 00 00 9D E5 ?? ?? ?? ?? 00 A0 84 E5 00 00 E0 E3 71 FF FF EA 6C 24 9D E5 0A 00 52 E1 F4 FF FF CA 00 20 83 E5 02 80 A0 E1 E5 FF FF EA 01 00 A0 E1 ?? ?? ?? ?? 00 60 A0 E1 B9 FF FF EA 09 00 A0 E1 ?? ?? ?? ?? ED FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_232_0_0 {
	meta:
		name = "__sccl"
		size = 192
	strings:
		$1 = { 70 00 2D E9 01 30 A0 E1 01 20 D3 E4 5E 00 52 E3 01 20 D1 05 00 C0 A0 13 01 30 83 02 01 C0 A0 03 00 10 A0 E3 01 C0 C0 E7 01 10 81 E2 01 0C 51 E3 FB FF FF 1A 00 00 52 E3 01 30 43 02 01 40 2C 12 0A 00 00 0A 02 40 C0 E7 03 C0 A0 E1 0C 30 A0 E1 01 10 D3 E4 2D 00 51 E3 09 00 00 0A 5D 00 51 E3 02 00 00 0A 00 00 51 E3 03 00 00 1A 0C 30 A0 E1 03 00 A0 E1 70 00 BD E8 1E FF 2F E1 01 20 A0 E1 EF FF FF EA 01 50 DC E5 5D 00 55 E3 00 60 A0 13 01 60 A0 03 02 00 55 E1 01 60 86 B3 00 00 56 E3 F5 FF FF 1A 02 30 80 E0 01 20 82 E2 02 00 55 E1 01 40 E3 E5 FB FF FF CA 02 C0 8C E2 E2 FF FF EA }
	condition:
		$1
}

rule file_233_0_0 {
	meta:
		name = "memchr"
		size = 212
	strings:
		$1 = { 03 00 10 E3 04 40 2D E5 FF 10 01 E2 07 00 00 1A 0B 00 00 EA 00 30 D0 E5 01 00 53 E1 06 00 00 0A 01 00 80 E2 03 00 10 E3 01 20 42 E2 04 00 00 0A 00 00 52 E3 F6 FF FF 1A 00 00 A0 E3 10 00 BD E8 1E FF 2F E1 03 00 52 E3 0D 00 00 8A 00 00 52 E3 F8 FF FF 0A 00 30 D0 E5 01 00 53 E1 01 20 42 12 04 00 00 1A F4 FF FF EA 01 30 F0 E5 01 00 53 E1 01 20 42 E2 F0 FF FF 0A 00 00 52 E3 F9 FF FF 1A EC FF FF EA 01 44 81 E1 04 48 84 E1 00 C0 90 E5 0C C0 24 E0 FF 34 8C E2 01 38 43 E2 01 3C 43 E2 01 30 43 E2 0C 30 C3 E1 7F 34 C3 E3 7F 38 C3 E3 7F 3C C3 E3 7F 30 C3 E3 00 00 53 E3 E2 FF FF 1A 04 20 42 E2 03 00 52 E3 04 00 80 E2 EE FF FF 8A DD FF FF EA }
	condition:
		$1
}

rule file_234_0_0 {
	meta:
		name = "__swsetup_r"
		size = 328
		refs = "00a4 __sinit 00c0 __smakebuf_r 0100 _free_r 0144 _impure_ptr"
	strings:
		$1 = { 3C 31 9F E5 00 30 93 E5 00 00 53 E3 30 40 2D E9 00 50 A0 E1 01 40 A0 E1 02 00 00 0A 38 20 93 E5 00 00 52 E3 1D 00 00 0A BC 20 D4 E1 02 08 A0 E1 20 38 A0 E1 08 00 13 E3 02 10 A0 E1 10 20 94 15 22 00 00 0A 00 00 52 E3 17 00 00 0A 01 10 13 E2 06 00 00 1A 02 00 13 E3 14 10 94 05 00 00 52 E3 08 10 84 E5 08 00 00 0A 00 00 A0 E3 30 80 BD E8 14 30 94 E5 00 10 A0 E3 00 30 63 E2 00 00 52 E3 08 10 84 E5 18 30 84 E5 F6 FF FF 1A BC 30 D4 E1 80 00 13 E3 F3 FF FF 0A 00 00 E0 E3 30 80 BD E8 03 00 A0 E1 ?? ?? ?? ?? DE FF FF EA 0A 1D 03 E2 02 0C 51 E3 E4 FF FF 0A 05 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? BC 30 D4 E1 10 20 94 E5 DE FF FF EA 10 00 13 E3 EF FF FF 0A 04 00 13 E3 10 20 94 05 14 00 00 0A 30 10 94 E5 00 00 51 E3 08 00 00 0A 40 30 84 E2 03 00 51 E1 02 00 00 0A 05 00 A0 E1 ?? ?? ?? ?? BC 20 D4 E1 00 30 A0 E3 30 30 84 E5 02 08 A0 E1 20 18 A0 E1 24 10 C1 E3 01 18 A0 E1 10 20 94 E5 21 18 A0 E1 00 30 A0 E3 04 30 84 E5 BC 10 C4 E1 00 20 84 E5 08 30 81 E3 BC 30 C4 E1 BF FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_235_0_0 {
	meta:
		name = "stpncpy"
		size = 232
	strings:
		$1 = { 00 30 81 E1 03 00 13 E3 00 30 A0 13 01 30 A0 03 03 00 52 E3 00 30 A0 93 01 30 03 82 00 00 53 E3 1B 00 00 1A 00 00 52 E3 1E FF 2F 01 00 30 D1 E5 00 C0 A0 E1 00 00 53 E3 01 20 42 E2 01 30 CC E4 07 00 00 0A 00 00 52 E3 0C 00 A0 E1 24 00 00 0A 01 30 F1 E5 00 00 53 E3 01 30 CC E4 01 20 42 E2 F7 FF FF 1A 00 00 52 E3 00 30 A0 13 03 10 A0 11 04 00 00 0A 03 10 CC E7 01 30 83 E2 03 00 52 E1 FB FF FF 1A 02 C0 8C E0 00 00 50 E3 0C 00 A0 01 1E FF 2F E1 00 C0 91 E5 FF 34 8C E2 01 38 43 E2 01 3C 43 E2 01 30 43 E2 0C 30 C3 E1 7F 34 C3 E3 7F 38 C3 E3 7F 3C C3 E3 7F 30 C3 E3 00 00 53 E3 D7 FF FF 1A 04 20 42 E2 03 00 52 E3 04 C0 80 E4 04 10 81 E2 EE FF FF 8A 00 00 52 E3 D2 FF FF 1A 1E FF 2F E1 1E FF 2F E1 }
	condition:
		$1
}

rule file_236_0_0 {
	meta:
		name = "_wctype_r"
		size = 516
		refs = "0088 strcmp"
	strings:
		$1 = { 30 40 2D E9 00 30 D1 E5 61 30 43 E2 01 40 A0 E1 00 50 A0 E1 17 00 53 E3 03 F1 9F 97 1D 00 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 01 00 A0 E1 48 11 9F E5 ?? ?? ?? ?? 00 00 50 E3 03 00 A0 03 30 80 BD 08 16 30 A0 E3 00 30 85 E5 00 00 A0 E3 30 80 BD E8 01 00 A0 E1 24 11 9F E5 ?? ?? ?? ?? 00 00 50 E3 0C 00 A0 03 F5 FF FF 1A 30 80 BD E8 01 00 A0 E1 0C 11 9F E5 ?? ?? ?? ?? 00 00 50 E3 01 00 A0 03 30 80 BD 08 04 00 A0 E1 F8 10 9F E5 ?? ?? ?? ?? 00 00 50 E3 02 00 A0 03 E8 FF FF 1A 30 80 BD E8 01 00 A0 E1 E0 10 9F E5 ?? ?? ?? ?? 00 00 50 E3 04 00 A0 03 E1 FF FF 1A 30 80 BD E8 01 00 A0 E1 C8 10 9F E5 ?? ?? ?? ?? 00 00 50 E3 05 00 A0 03 DA FF FF 1A 30 80 BD E8 01 00 A0 E1 B0 10 9F E5 ?? ?? ?? ?? 00 00 50 E3 06 00 A0 03 D3 FF FF 1A 30 80 BD E8 01 00 A0 E1 98 10 9F E5 ?? ?? ?? ?? 00 00 50 E3 07 00 A0 03 CC FF FF 1A 30 80 BD E8 01 00 A0 E1 80 10 9F E5 ?? ?? ?? ?? 00 00 50 E3 08 00 A0 03 30 80 BD 08 04 00 A0 E1 6C 10 9F E5 ?? ?? ?? ?? 00 00 50 E3 09 00 A0 03 BF FF FF 1A 30 80 BD E8 01 00 A0 E1 54 10 9F E5 ?? ?? ?? ?? 00 00 50 E3 0A 00 A0 03 B8 FF FF 1A 30 80 BD E8 01 00 A0 E1 3C 10 9F E5 ?? ?? ?? ?? 00 00 50 E3 0B 00 A0 03 B1 FF FF 1A 30 80 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_238_0_0 {
	meta:
		name = "__isinfd"
		size = 48
		altNames = "isinf"
	strings:
		$1 = { 01 30 A0 E1 00 10 61 E2 02 21 C0 E3 03 10 81 E1 A1 3F 82 E1 7F 34 63 E2 0F 36 83 E2 00 00 63 E2 03 30 80 E1 C3 0F A0 E1 01 00 80 E2 1E FF 2F E1 }
	condition:
		$1
}

rule file_239_0_0 {
	meta:
		name = "fmemseeker"
		size = 204
	strings:
		$1 = { 01 00 53 E3 00 C0 A0 E1 27 00 00 0A 02 00 53 E3 0C 00 91 05 02 00 A0 11 00 00 82 00 00 00 50 E3 16 30 A0 B3 00 30 8C B5 00 00 E0 B3 1E FF 2F B1 10 30 91 E5 03 00 50 E1 1C 30 A0 83 00 30 8C 85 00 00 E0 83 1E FF 2F 81 15 30 D1 E5 00 00 53 E3 09 00 00 0A 08 20 81 E2 04 10 92 E8 0C 00 52 E1 05 00 00 2A 16 C0 D1 E5 04 30 91 E5 02 C0 C3 E7 00 30 A0 E3 16 30 C1 E5 15 30 D1 E5 00 00 53 E3 08 00 81 E5 1E FF 2F 01 0C 30 91 E5 03 00 50 E1 1E FF 2F 21 04 30 91 E5 00 20 D3 E7 16 20 C1 E5 00 20 A0 E3 00 20 C3 E7 1E FF 2F E1 08 00 91 E5 00 00 82 E0 00 00 50 E3 16 30 A0 B3 00 30 8C B5 00 00 E0 B3 D9 FF FF AA 1E FF 2F E1 }
	condition:
		$1
}

rule file_239_1_0 {
	meta:
		name = "fmemreader"
		size = 92
		refs = "0044 memcpy"
	strings:
		$1 = { 70 40 2D E9 01 40 A0 E1 0C C0 94 E5 08 10 91 E5 0C 00 51 E1 03 50 A0 E1 00 50 A0 83 0C 00 00 8A 0C C0 61 E0 0C 00 55 E1 05 60 A0 E1 04 30 94 E5 0C 50 A0 21 05 60 A0 21 01 10 83 E0 02 00 A0 E1 06 20 A0 E1 ?? ?? ?? ?? 08 30 94 E5 06 60 83 E0 08 60 84 E5 05 00 A0 E1 70 80 BD E8 }
	condition:
		$1
}

rule file_239_2_0 {
	meta:
		name = "fmemwriter"
		size = 296
		refs = "00a0 memcpy 00c8 memset"
	strings:
		$1 = { F0 41 2D E9 01 40 A0 E1 14 10 D1 E5 00 00 51 E3 00 60 A0 E1 02 50 A0 E1 03 70 A0 E1 22 00 00 0A 0C 20 94 E5 08 20 84 E5 02 30 A0 E1 10 C0 94 E5 15 00 D4 E5 07 10 82 E0 0C 80 60 E0 08 00 51 E1 0C 70 62 80 02 10 87 80 00 20 A0 93 00 20 A0 81 01 00 53 E1 1F 00 00 2A 01 30 62 E0 0C 00 53 E1 0C 10 84 E5 28 00 00 2A 04 10 94 E5 00 00 A0 E3 03 00 C1 E7 08 10 94 E5 16 00 C4 E5 01 10 87 E0 02 00 57 E1 08 10 84 E5 22 00 00 0A 04 00 94 E5 01 10 67 E0 01 00 80 E0 07 20 62 E0 05 10 A0 E1 ?? ?? ?? ?? 07 00 A0 E1 F0 81 BD E8 08 20 84 E2 0C 00 92 E8 03 00 52 E1 DB FF FF 9A 04 00 94 E5 02 20 63 E0 03 00 80 E0 ?? ?? ?? ?? 08 20 84 E2 0C 00 92 E8 D4 FF FF EA 00 00 50 E3 E7 FF FF 0A 00 00 57 E3 08 10 84 05 0A 00 00 0A 08 10 94 E9 01 10 62 E0 01 00 D3 E7 0C 10 87 E0 16 00 C4 E5 01 10 62 E0 00 00 A0 E3 01 00 C3 E7 08 10 94 E5 01 10 87 E0 D9 FF FF EA 1C 30 A0 E3 00 30 86 E5 00 70 E0 E3 DE FF FF EA }
	condition:
		$1
}

rule file_239_3_0 {
	meta:
		name = "fmemcloser"
		size = 20
		refs = "0008 _free_r"
	strings:
		$1 = { 04 E0 2D E5 00 10 91 E5 ?? ?? ?? ?? 00 00 A0 E3 04 F0 9D E4 }
	condition:
		$1
}

rule file_99_0_1 {
	meta:
		name = "__ieee754_gamma_r"
		size = 16
		refs = "0004 __ieee754_lgamma_r 000c __ieee754_exp"
	strings:
		$1 = { 04 E0 2D E5 ?? ?? ?? ?? 04 E0 9D E4 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_181_0_1 {
	meta:
		name = "__ieee754_gammaf_r"
		size = 16
		refs = "0004 __ieee754_lgammaf_r 000c __ieee754_expf"
	strings:
		$1 = { 04 E0 2D E5 ?? ?? ?? ?? 04 E0 9D E4 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_361_0_0 {
	meta:
		name = "ctime"
		size = 16
		refs = "0004 localtime 000c asctime"
	strings:
		$1 = { 04 E0 2D E5 ?? ?? ?? ?? 04 E0 9D E4 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_163_0_1 {
	meta:
		name = "fma"
		size = 20
		refs = "0004 __muldf3 000c __adddf3"
	strings:
		$1 = { 04 E0 2D E5 ?? ?? ?? ?? 0C 00 9D E9 ?? ?? ?? ?? 04 F0 9D E4 }
	condition:
		$1
}

rule file_239_4_0 {
	meta:
		name = "_fmemopen_r"
		size = 464
		refs = "0020 __sflags 0064 __sfp 0080 _malloc_r 00d0 abort 012c memchr 01ac __sfp_lock_acquire 01b8 __sfp_lock_release 01c0 fmemreader 01c4 fmemwriter 01c8 fmemseeker 01cc fmemcloser"
	strings:
		$1 = { F0 45 2D E9 04 D0 4D E2 01 70 A0 E1 02 A0 A0 E1 03 10 A0 E1 0D 20 A0 E1 03 80 A0 E1 00 60 A0 E1 ?? ?? ?? ?? 00 50 50 E2 05 40 A0 01 08 00 00 0A 00 00 5A E3 03 00 00 0A 00 00 57 E3 07 00 00 1A 01 0C 15 E3 05 00 00 1A 16 30 A0 E3 00 30 86 E5 00 40 A0 E3 04 00 A0 E1 04 D0 8D E2 F0 85 BD E8 06 00 A0 E1 ?? ?? ?? ?? 00 40 50 E2 F8 FF FF 0A 00 00 57 E3 18 10 A0 13 18 10 8A 02 06 00 A0 E1 ?? ?? ?? ?? 00 60 50 E2 47 00 00 0A A5 31 A0 E1 01 30 03 E2 00 10 A0 E3 00 00 57 E3 15 30 C6 E5 00 60 86 E5 10 A0 86 E5 16 10 C6 E5 2D 00 00 0A 04 70 86 E5 00 30 D8 E5 72 00 53 E3 04 00 00 0A 77 00 53 E3 22 00 00 0A 61 00 53 E3 14 00 00 0A ?? ?? ?? ?? 08 10 86 E5 0C A0 86 E5 14 10 C6 E5 D8 30 9F E5 14 20 15 E2 03 20 A0 11 D0 30 9F E5 18 10 15 E2 01 30 A0 01 24 30 84 E5 C4 30 9F E5 28 30 84 E5 C0 30 9F E5 2C 30 84 E5 00 30 E0 E3 1C 60 84 E5 20 20 84 E5 BC 50 C4 E1 BE 30 C4 E1 CB FF FF EA 07 00 A0 E1 0A 20 A0 E1 ?? ?? ?? ?? 00 00 50 E3 14 00 00 0A 04 30 96 E5 00 30 63 E0 0C 30 86 E5 08 30 86 E5 01 30 A0 E3 14 30 C6 E5 E2 FF FF EA 0C 10 86 E5 14 10 C6 E5 08 10 86 E5 00 10 C7 E5 DD FF FF EA 25 34 A0 E1 01 30 03 E2 18 20 86 E2 04 20 86 E5 00 70 C7 E5 08 70 86 E5 14 30 C6 E5 0C 70 86 E5 D4 FF FF EA 15 30 D6 E5 00 00 53 E3 08 A0 86 E5 0C A0 86 E5 04 30 96 15 0A A0 83 10 01 00 4A 15 E6 FF FF EA ?? ?? ?? ?? BC 60 C4 E1 06 40 A0 E1 ?? ?? ?? ?? A4 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_240_0_0 {
	meta:
		name = "_Bfree"
		size = 28
	strings:
		$1 = { 00 00 51 E3 4C 30 90 15 04 20 91 15 02 01 93 17 00 00 81 15 02 11 83 17 1E FF 2F E1 }
	condition:
		$1
}

rule file_240_1_0 {
	meta:
		name = "__hi0bits"
		size = 88
	strings:
		$1 = { 20 28 A0 E1 02 28 A0 E1 00 30 A0 E1 00 00 52 E3 03 38 A0 01 00 00 A0 13 10 00 A0 03 FF 04 13 E3 03 34 A0 01 08 00 80 02 0F 02 13 E3 03 32 A0 01 04 00 80 02 03 01 13 E3 03 31 A0 01 02 00 80 02 00 00 53 E3 1E FF 2F B1 01 01 13 E3 20 00 A0 03 01 00 80 12 1E FF 2F E1 }
	condition:
		$1
}

rule file_240_2_0 {
	meta:
		name = "__lo0bits"
		size = 148
	strings:
		$1 = { 00 30 90 E5 00 20 A0 E1 07 00 13 E2 0A 00 00 0A 01 00 13 E3 00 00 A0 13 1E FF 2F 11 02 00 13 E3 A3 30 A0 11 23 31 A0 01 00 30 82 15 01 00 A0 13 00 30 82 05 02 00 A0 03 1E FF 2F E1 03 18 A0 E1 21 18 A0 E1 00 00 51 E3 23 38 A0 01 10 00 A0 03 FF 00 13 E3 23 34 A0 01 08 00 80 02 0F 00 13 E3 23 32 A0 01 04 00 80 02 03 00 13 E3 23 31 A0 01 02 00 80 02 01 00 13 E3 03 00 00 1A A3 30 B0 E1 20 00 A0 03 1E FF 2F 01 01 00 80 E2 00 30 82 E5 1E FF 2F E1 }
	condition:
		$1
}

rule file_240_3_0 {
	meta:
		name = "__mcmp"
		size = 96
	strings:
		$1 = { 00 30 A0 E1 10 20 91 E5 10 00 90 E5 02 00 50 E0 04 40 2D E5 0C 00 00 1A 05 20 82 E2 02 21 A0 E1 02 10 81 E0 02 20 83 E0 14 30 83 E2 04 40 12 E5 04 C0 11 E5 0C 00 54 E1 04 20 42 E2 04 00 00 1A 02 00 53 E1 04 10 41 E2 F7 FF FF 3A 10 00 BD E8 1E FF 2F E1 01 00 A0 23 00 00 E0 33 FA FF FF EA }
	condition:
		$1
}

rule file_240_4_0 {
	meta:
		name = "__ulp"
		size = 96
	strings:
		$1 = { 02 01 C0 E3 20 0A A0 E1 00 0A A0 E1 0D 35 40 E2 00 00 53 E3 03 00 A0 C1 00 10 A0 C3 1E FF 2F C1 00 30 63 E2 43 3A A0 E1 13 00 53 E3 02 27 A0 D3 52 03 A0 D1 00 10 A0 D3 1E FF 2F D1 14 30 43 E2 1E 00 53 E3 1F 30 63 D2 01 20 A0 D3 12 33 A0 D1 01 30 A0 C3 00 00 A0 E3 03 10 A0 E1 1E FF 2F E1 }
	condition:
		$1
}

rule file_240_5_0 {
	meta:
		name = "__b2d"
		size = 208
		refs = "0024 __hi0bits"
	strings:
		$1 = { F0 40 2D E9 10 50 90 E5 05 50 85 E2 05 51 80 E0 04 40 15 E5 00 30 A0 E1 04 00 A0 E1 01 70 A0 E1 14 60 83 E2 ?? ?? ?? ?? 20 30 60 E2 0A 00 50 E3 04 50 45 E2 00 30 87 E5 0C 00 00 CA 05 00 56 E1 04 10 15 35 0B 30 60 E2 31 13 A0 31 34 C3 A0 E1 00 10 A0 23 15 00 80 E2 14 30 81 E1 FF 25 8C E3 03 26 82 E3 02 00 A0 E1 03 10 A0 E1 F0 80 BD E8 05 00 56 E1 00 10 A0 23 04 10 35 35 0B 00 50 E2 0C 00 00 0A 06 00 55 E1 04 50 15 85 14 40 A0 E1 20 C0 60 E2 35 5C A0 81 FF 45 84 E3 00 50 A0 93 03 46 84 E3 31 2C 84 E1 11 30 85 E1 02 00 A0 E1 03 10 A0 E1 F0 80 BD E8 FF 25 84 E3 03 26 82 E3 01 30 A0 E1 02 00 A0 E1 03 10 A0 E1 F0 80 BD E8 }
	condition:
		$1
}

rule file_240_6_0 {
	meta:
		name = "__ratio"
		size = 156
		refs = "0014 __b2d 0090 __divdf3"
	strings:
		$1 = { F0 4B 2D E9 08 D0 4D E2 01 60 A0 E1 04 10 8D E2 00 70 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 06 00 A0 E1 0D 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 10 00 97 E5 10 10 96 E5 04 C0 9D E5 00 00 61 E0 00 10 9D E5 0C 10 61 E0 80 12 81 E0 00 00 51 E3 03 90 A0 E1 02 90 A0 D1 04 60 A0 E1 01 1A 49 D0 01 6A 84 C0 02 B0 A0 E1 05 70 A0 E1 01 B0 A0 D1 06 40 A0 C1 05 50 A0 C1 02 80 A0 E1 03 30 A0 D1 0B 20 A0 D1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 08 D0 8D E2 F0 8B BD E8 }
	condition:
		$1
}

rule file_240_7_0 {
	meta:
		name = "_mprec_log10"
		size = 76
		refs = "0028 __muldf3"
	strings:
		$1 = { 17 00 50 E3 10 40 2D E9 00 40 A0 E1 FF 05 A0 C3 03 06 80 C2 00 10 A0 C3 06 00 00 DA 01 21 A0 E3 09 27 82 E2 00 30 A0 E3 ?? ?? ?? ?? 01 40 54 E2 F9 FF FF 1A 10 80 BD E8 08 30 9F E5 84 41 83 E0 03 00 94 E8 10 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_240_8_0 {
	meta:
		name = "__copybits"
		size = 124
	strings:
		$1 = { 10 30 92 E5 01 10 41 E2 05 30 83 E2 03 31 82 E0 C1 12 A0 E1 14 20 82 E2 01 10 81 E2 03 00 52 E1 04 40 2D E5 01 41 80 E0 0B 00 00 2A 00 C0 A0 E3 0C 10 92 E7 0C 10 80 E7 04 C0 8C E2 0C 10 82 E0 01 00 53 E1 F9 FF FF 8A 02 20 E0 E1 03 30 82 E0 03 30 C3 E3 04 30 83 E2 03 00 80 E0 00 00 54 E1 03 00 00 9A 00 30 A0 E3 04 30 80 E4 00 00 54 E1 FC FF FF 8A 10 00 BD E8 1E FF 2F E1 }
	condition:
		$1
}

rule file_240_9_0 {
	meta:
		name = "__any_on"
		size = 128
	strings:
		$1 = { 10 20 90 E5 C1 32 A0 E1 03 00 52 E1 02 30 A0 B1 00 00 00 BA 0F 00 00 CA 05 30 83 E2 03 31 80 E0 14 00 80 E2 03 00 50 E1 12 00 00 2A 04 20 13 E5 00 00 52 E3 04 30 43 E2 04 00 00 1A 03 00 50 E1 0C 00 00 2A 04 20 33 E5 00 00 52 E3 FA FF FF 0A 01 00 A0 E3 1E FF 2F E1 1F 10 11 E2 ED FF FF 0A 05 20 83 E2 02 21 90 E7 32 C1 A0 E1 1C 01 52 E1 F6 FF FF 1A E7 FF FF EA 00 00 A0 E3 1E FF 2F E1 }
	condition:
		$1
}

rule file_240_10_0 {
	meta:
		name = "_Balloc"
		size = 132
		refs = "0044 _calloc_r"
	strings:
		$1 = { 4C 30 90 E5 00 00 53 E3 70 40 2D E9 00 50 A0 E1 01 40 A0 E1 08 00 00 0A 04 01 93 E7 00 00 50 E3 0D 00 00 0A 00 20 90 E5 04 21 83 E7 00 30 A0 E3 0C 30 80 E5 10 30 80 E5 70 80 BD E8 04 10 A0 E3 10 20 A0 E3 ?? ?? ?? ?? 00 00 50 E3 4C 00 85 E5 00 30 A0 E1 EF FF FF 1A 70 80 BD E8 01 10 A0 E3 11 64 A0 E1 05 20 86 E2 05 00 A0 E1 02 21 A0 E1 ?? ?? ?? ?? 00 00 50 E3 70 80 BD 08 50 00 80 E9 E9 FF FF EA }
	condition:
		$1
}

rule file_240_11_0 {
	meta:
		name = "__d2b"
		size = 268
		refs = "001c _Balloc 0054 __lo0bits 00fc __hi0bits"
	strings:
		$1 = { F0 45 2D E9 01 40 A0 E1 08 D0 4D E2 01 10 A0 E3 02 50 A0 E1 03 70 A0 E1 24 60 9D E5 ?? ?? ?? ?? 02 21 C4 E3 FF 34 C4 E3 0F 36 C3 E3 22 AA B0 E1 00 30 8D E5 01 36 83 13 00 30 8D 15 00 00 55 E3 00 80 A0 E1 02 40 A0 E1 1D 00 00 0A 08 00 8D E2 04 50 20 E5 ?? ?? ?? ?? 00 00 50 E3 00 30 9D 15 04 20 9D 15 20 10 60 12 13 21 82 11 33 30 A0 11 04 30 9D 05 14 30 88 05 00 30 9D 05 14 20 88 15 00 30 8D 15 00 00 53 E3 02 40 A0 13 01 40 A0 03 00 00 5A E3 18 30 88 E5 10 40 88 E5 11 00 00 0A 43 AE 4A E2 03 A0 4A E2 00 A0 8A E0 35 00 60 E2 00 A0 87 E5 00 00 86 E5 08 00 A0 E1 08 D0 8D E2 F0 85 BD E8 0D 00 A0 E1 ?? ?? ?? ?? 00 30 9D E5 01 40 A0 E3 00 00 5A E3 14 30 88 E5 10 40 88 E5 20 00 80 E2 ED FF FF 1A 43 0E 40 E2 02 00 40 E2 04 30 84 E2 00 00 87 E5 03 01 98 E7 ?? ?? ?? ?? 84 02 60 E0 00 00 86 E5 EA FF FF EA }
	condition:
		$1
}

rule file_240_12_0 {
	meta:
		name = "__mdiff"
		size = 372
		refs = "0030 _Balloc"
	strings:
		$1 = { F0 47 2D E9 10 30 92 E5 10 70 91 E5 07 70 63 E0 00 00 57 E3 01 40 A0 E1 02 50 A0 E1 39 00 00 0A 00 70 A0 A3 14 60 81 A2 4B 00 00 BA 04 10 94 E5 ?? ?? ?? ?? 10 C0 94 E5 10 80 95 E5 05 30 8C E2 05 80 88 E2 0C 70 80 E5 08 81 85 E0 03 41 84 E0 14 50 85 E2 14 20 80 E2 00 10 A0 E3 04 90 95 E4 04 A0 96 E4 09 38 A0 E1 0A 78 A0 E1 27 78 A0 E1 23 38 A0 E1 07 30 63 E0 01 10 83 E0 29 98 A0 E1 01 78 A0 E1 2A A8 69 E0 41 18 8A E0 27 78 A0 E1 01 78 87 E1 05 00 58 E1 04 70 82 E4 41 18 A0 E1 ED FF FF 8A 04 00 56 E1 0C 00 00 2A 04 50 96 E4 05 38 A0 E1 23 38 A0 E1 03 10 81 E0 01 38 A0 E1 25 58 A0 E1 41 18 85 E0 23 38 A0 E1 01 38 83 E1 06 00 54 E1 04 30 82 E4 41 18 A0 E1 F2 FF FF 8A 04 30 12 E5 00 00 53 E3 04 00 00 1A 08 30 12 E5 00 00 53 E3 01 C0 4C E2 04 20 42 E2 FA FF FF 0A 10 C0 80 E5 F0 87 BD E8 05 30 83 E2 03 31 A0 E1 03 20 82 E0 14 60 81 E2 03 30 81 E0 04 C0 13 E5 04 10 12 E5 01 00 5C E1 04 30 43 E2 09 00 00 1A 03 00 56 E1 04 20 42 E2 F7 FF FF 3A 00 10 A0 E3 ?? ?? ?? ?? 01 30 A0 E3 10 30 80 E5 00 30 A0 E3 14 30 80 E5 F0 87 BD E8 B3 FF FF 2A 04 30 A0 E1 05 40 A0 E1 01 70 A0 E3 03 50 A0 E1 14 60 84 E2 AD FF FF EA }
	condition:
		$1
}

rule file_240_13_0 {
	meta:
		name = "__lshift"
		size = 272
		refs = "0044 _Balloc"
	strings:
		$1 = { F0 45 2D E9 10 50 91 E5 08 30 91 E5 01 50 85 E2 C2 62 A0 E1 06 50 85 E0 03 00 55 E1 01 40 A0 E1 02 70 A0 E1 00 80 A0 E1 04 10 91 E5 03 00 00 DA 83 30 A0 E1 03 00 55 E1 01 10 81 E2 FB FF FF CA 08 00 A0 E1 ?? ?? ?? ?? 00 00 56 E3 14 20 80 E2 07 00 00 DA 00 30 A0 E3 03 10 A0 E1 03 11 82 E7 01 30 83 E2 06 00 53 E1 FB FF FF 1A 05 30 83 E2 03 21 80 E0 10 C0 94 E5 1F 70 17 E2 05 C0 8C E2 0C C1 84 E0 14 30 84 E2 13 00 00 0A 20 60 67 E2 00 10 A0 E3 00 A0 93 E5 1A 17 81 E1 04 10 82 E4 04 10 93 E4 03 00 5C E1 31 16 A0 E1 F8 FF FF 8A 00 00 51 E3 00 10 82 E5 01 50 85 12 4C 30 98 E5 04 20 94 E5 02 11 93 E7 01 50 45 E2 00 10 84 E5 10 50 80 E5 02 41 83 E7 F0 85 BD E8 07 10 93 E7 07 10 82 E7 04 70 87 E2 07 10 83 E0 01 00 5C E1 F1 FF FF 9A 07 10 93 E7 07 10 82 E7 04 70 87 E2 07 10 83 E0 01 00 5C E1 F3 FF FF 8A EA FF FF EA }
	condition:
		$1
}

rule file_240_14_0 {
	meta:
		name = "__multiply"
		size = 496
		refs = "0048 _Balloc"
	strings:
		$1 = { F0 4F 2D E9 10 60 91 E5 10 80 92 E5 08 00 56 E1 08 30 A0 A1 01 30 A0 B1 01 50 A0 E1 02 50 A0 B1 06 80 A0 A1 02 90 A0 E1 03 60 A0 A1 03 90 A0 B1 08 30 95 E5 08 40 86 E0 04 10 95 E5 03 00 54 E1 14 D0 4D E2 01 10 81 C2 ?? ?? ?? ?? 05 30 84 E2 03 31 80 E0 08 00 8D E5 14 00 80 E2 03 00 50 E1 0C 30 8D E5 05 00 00 2A 0C 10 9D E5 00 30 A0 E1 00 20 A0 E3 04 20 83 E4 03 00 51 E1 FC FF FF 8A 05 60 86 E2 06 61 89 E0 05 80 88 E2 14 90 89 E2 08 81 85 E0 06 00 59 E1 14 50 85 E2 00 60 8D E5 04 50 8D E5 3E 00 00 2A 10 40 8D E5 00 A0 A0 E3 00 B0 A0 E1 0A 00 99 E7 00 C8 A0 E1 2C C8 A0 E1 00 00 5C E3 0A 70 8B E0 17 00 00 0A 04 00 9D E5 07 10 A0 E1 00 60 A0 E3 04 50 90 E4 00 40 91 E5 05 28 A0 E1 04 38 A0 E1 22 28 A0 E1 23 38 A0 E1 9C 32 23 E0 25 58 A0 E1 24 48 A0 E1 9C 45 25 E0 06 30 83 E0 03 28 A0 E1 23 58 85 E0 22 28 A0 E1 05 28 82 E1 00 00 58 E1 04 20 81 E4 25 68 A0 E1 EC FF FF 8A 00 60 81 E5 0A 00 99 E7 20 08 B0 E1 15 00 00 0A 0A 10 9B E7 04 30 9D E5 01 C0 A0 E1 00 20 A0 E3 B0 40 D3 E1 94 20 22 E0 01 18 A0 E1 2C 28 82 E0 21 18 A0 E1 02 18 81 E1 00 10 87 E5 04 C0 B7 E5 04 10 93 E4 0C 48 A0 E1 21 18 A0 E1 24 48 A0 E1 90 41 21 E0 03 00 58 E1 22 18 81 E0 21 28 A0 E1 EE FF FF 8A 00 10 87 E5 04 A0 8A E2 00 20 9D E5 0A 30 89 E0 03 00 52 E1 C4 FF FF 8A 10 40 9D E5 00 00 54 E3 0B 00 00 DA 0C 20 9D E5 04 30 12 E5 00 00 53 E3 07 00 00 1A 02 30 A0 E1 03 00 00 EA 08 20 13 E5 00 00 52 E3 04 30 43 E2 01 00 00 1A 01 40 54 E2 F9 FF FF 1A 08 30 9D E5 10 40 83 E5 03 00 A0 E1 14 D0 8D E2 F0 8F BD E8 }
	condition:
		$1
}

rule file_240_15_0 {
	meta:
		name = "__i2b"
		size = 32
		refs = "000c _Balloc"
	strings:
		$1 = { 10 40 2D E9 01 40 A0 E1 01 10 A0 E3 ?? ?? ?? ?? 01 20 A0 E3 10 20 80 E5 14 40 80 E5 10 80 BD E8 }
	condition:
		$1
}

rule file_240_16_0 {
	meta:
		name = "__multadd"
		size = 224
		refs = "00a0 _Balloc 00bc memcpy"
	strings:
		$1 = { F0 41 2D E9 01 50 A0 E1 10 40 95 E5 00 10 A0 E3 04 D0 4D E2 00 60 A0 E1 14 70 85 E2 01 C0 A0 E1 01 80 97 E7 08 08 A0 E1 20 08 A0 E1 90 32 23 E0 28 88 A0 E1 92 08 08 E0 03 08 A0 E1 20 08 A0 E1 23 38 88 E0 01 C0 8C E2 03 08 80 E0 0C 00 54 E1 01 00 87 E7 23 38 A0 E1 04 10 81 E2 EF FF FF CA 00 00 53 E3 06 00 00 0A 08 20 95 E5 02 00 54 E1 06 00 00 AA 01 20 84 E2 05 40 84 E2 04 31 85 E7 10 20 85 E5 05 00 A0 E1 04 D0 8D E2 F0 81 BD E8 04 10 95 E5 06 00 A0 E1 01 10 81 E2 00 30 8D E5 ?? ?? ?? ?? 10 20 95 E5 02 20 82 E2 0C 10 85 E2 00 70 A0 E1 02 21 A0 E1 0C 00 80 E2 ?? ?? ?? ?? 04 10 95 E5 4C 20 96 E5 01 01 92 E7 00 30 9D E5 00 00 85 E5 01 51 82 E7 07 50 A0 E1 E4 FF FF EA }
	condition:
		$1
}

rule file_240_17_0 {
	meta:
		name = "__pow5mult"
		size = 248
		refs = "0064 __multiply 00c4 __multadd 00dc __i2b"
	strings:
		$1 = { 03 30 12 E2 F0 41 2D E9 02 50 A0 E1 00 40 A0 E1 01 80 A0 E1 26 00 00 1A 45 51 B0 E1 1A 00 00 0A 48 70 94 E5 00 00 57 E3 28 00 00 0A 01 00 15 E3 08 00 00 1A C5 50 B0 E1 13 00 00 0A 00 60 97 E5 00 00 56 E3 06 00 A0 11 11 00 00 0A 00 70 A0 E1 01 00 15 E3 F6 FF FF 0A 08 10 A0 E1 07 20 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 00 58 E3 04 20 98 15 4C 30 94 15 02 11 93 17 00 10 88 15 02 81 83 17 C5 50 B0 E1 00 80 A0 E1 EB FF FF 1A 08 00 A0 E1 F0 81 BD E8 07 10 A0 E1 07 20 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 00 87 E5 00 60 80 E5 00 70 A0 E1 E6 FF FF EA 38 20 9F E5 03 31 82 E0 C4 20 93 E5 00 30 A0 E3 ?? ?? ?? ?? 00 80 A0 E1 D1 FF FF EA 27 1E A0 E3 01 10 81 E2 04 00 A0 E1 ?? ?? ?? ?? 00 30 A0 E3 48 00 84 E5 00 70 A0 E1 00 30 80 E5 CD FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_240_18_0 {
	meta:
		name = "__s2b"
		size = 228
		refs = "0050 _Balloc 0094 __multadd"
	strings:
		$1 = { F0 45 2D E9 08 C0 83 E2 03 60 A0 E1 CC 30 9F E5 9C E3 C3 E0 CC CF A0 E1 C3 30 6C E0 01 00 53 E3 01 80 A0 E1 00 50 A0 E1 02 70 A0 E1 00 10 A0 D3 05 00 00 DA 01 20 A0 E3 00 10 A0 E3 82 20 A0 E1 02 00 53 E1 01 10 81 E2 FB FF FF CA 05 00 A0 E1 ?? ?? ?? ?? 1C 30 9D E5 09 00 57 E3 14 30 80 E5 01 30 A0 E3 10 30 80 E5 0A 80 88 D2 09 70 A0 D3 0C 00 00 DA 09 A0 88 E2 09 40 A0 E3 04 30 D8 E7 00 10 A0 E1 30 30 43 E2 01 40 84 E2 05 00 A0 E1 0A 20 A0 E3 ?? ?? ?? ?? 04 00 57 E1 F6 FF FF CA 07 80 8A E0 08 80 48 E2 07 00 56 E1 F0 85 BD D8 00 40 A0 E3 04 30 D8 E7 00 10 A0 E1 30 30 43 E2 01 40 84 E2 05 00 A0 E1 0A 20 A0 E3 ?? ?? ?? ?? 07 30 84 E0 03 00 56 E1 F5 FF FF CA F0 85 BD E8 39 8E E3 38 }
	condition:
		$1
}

rule file_241_0_0 {
	meta:
		name = "putchar"
		size = 28
		refs = "0014 _putc_r 0018 _impure_ptr"
	strings:
		$1 = { 10 30 9F E5 00 30 93 E5 08 20 93 E5 00 10 A0 E1 03 00 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_242_0_0 {
	meta:
		name = "_scanf_r"
		size = 52
		refs = "0020 __svfscanf_r"
	strings:
		$1 = { 0E 00 2D E9 04 E0 2D E5 04 D0 4D E2 0C C0 8D E2 0C 30 A0 E1 04 10 90 E5 08 20 9D E5 00 C0 8D E5 ?? ?? ?? ?? 04 D0 8D E2 04 E0 9D E4 0C D0 8D E2 1E FF 2F E1 }
	condition:
		$1
}

rule file_448_0_0 {
	meta:
		name = "_iscanf_r"
		size = 52
		refs = "0020 __svfiscanf_r"
	strings:
		$1 = { 0E 00 2D E9 04 E0 2D E5 04 D0 4D E2 0C C0 8D E2 0C 30 A0 E1 04 10 90 E5 08 20 9D E5 00 C0 8D E5 ?? ?? ?? ?? 04 D0 8D E2 04 E0 9D E4 0C D0 8D E2 1E FF 2F E1 }
	condition:
		$1
}

rule file_242_1_0 {
	meta:
		name = "scanf"
		size = 64
		refs = "0028 __svfscanf_r 003c _impure_ptr"
	strings:
		$1 = { 0F 00 2D E9 04 E0 2D E5 2C 30 9F E5 04 D0 4D E2 00 00 93 E5 0C C0 8D E2 0C 30 A0 E1 04 10 90 E5 08 20 9D E5 00 C0 8D E5 ?? ?? ?? ?? 04 D0 8D E2 04 E0 9D E4 10 D0 8D E2 1E FF 2F E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_448_1_0 {
	meta:
		name = "iscanf"
		size = 64
		refs = "0028 __svfiscanf_r 003c _impure_ptr"
	strings:
		$1 = { 0F 00 2D E9 04 E0 2D E5 2C 30 9F E5 04 D0 4D E2 00 00 93 E5 0C C0 8D E2 0C 30 A0 E1 04 10 90 E5 08 20 9D E5 00 C0 8D E5 ?? ?? ?? ?? 04 D0 8D E2 04 E0 9D E4 10 D0 8D E2 1E FF 2F E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_243_0_0 {
	meta:
		name = "memcmp"
		size = 168
	strings:
		$1 = { 03 00 52 E3 30 00 2D E9 00 50 A0 E1 01 40 A0 E1 1F 00 00 9A 00 30 81 E1 03 00 13 E3 11 00 00 0A 00 C0 D5 E5 00 30 D4 E5 03 00 5C E1 05 00 A0 01 04 10 A0 01 01 20 42 02 05 00 00 0A 17 00 00 EA 01 C0 F0 E5 01 30 F1 E5 03 00 5C E1 01 20 42 E2 12 00 00 1A 00 00 52 E3 F8 FF FF 1A 00 00 A0 E3 30 00 BD E8 1E FF 2F E1 00 C0 90 E5 00 30 91 E5 03 00 5C E1 04 00 00 1A 04 20 42 E2 03 00 52 E3 04 00 80 E2 04 10 81 E2 F6 FF FF 8A 00 50 A0 E1 01 40 A0 E1 00 00 52 E3 E0 FF FF 1A EE FF FF EA 0C 00 63 E0 ED FF FF EA }
	condition:
		$1
}

rule file_244_0_0 {
	meta:
		name = "strchr"
		size = 412
	strings:
		$1 = { FF 10 11 E2 30 00 2D E9 04 00 00 0A 21 00 00 EA 00 30 D0 E5 00 00 53 E3 16 00 00 0A 01 00 80 E2 03 00 10 E3 F9 FF FF 1A 00 20 90 E5 00 00 00 EA 04 20 B0 E5 FF 34 82 E2 01 38 43 E2 01 3C 43 E2 01 30 43 E2 02 30 C3 E1 7F 34 C3 E3 7F 38 C3 E3 7F 3C C3 E3 7F 30 C3 E3 00 00 53 E3 F3 FF FF 0A 00 30 D0 E5 00 00 53 E3 02 00 00 0A 01 30 F0 E5 00 00 53 E3 FC FF FF 1A 30 00 BD E8 1E FF 2F E1 00 30 D0 E5 00 00 53 E3 41 00 00 0A 03 00 51 E1 F8 FF FF 0A 01 00 80 E2 03 00 10 E3 F7 FF FF 1A 00 20 90 E5 FF 34 82 E2 01 38 43 E2 01 3C 43 E2 01 30 43 E2 02 30 C3 E1 7F 34 C3 E3 7F 38 C3 E3 7F 3C C3 E3 7F 30 C3 E3 01 54 81 E1 00 00 53 E3 05 58 85 E1 24 00 00 1A 02 20 25 E0 FF 34 82 E2 01 38 43 E2 01 3C 43 E2 01 30 43 E2 02 30 C3 E1 7F 34 C3 E3 7F 38 C3 E3 7F 3C C3 E3 7F 30 C3 E3 00 00 53 E3 02 00 00 0A 17 00 00 EA 00 00 52 E3 15 00 00 1A 04 C0 B0 E5 FF 34 8C E2 0C 40 25 E0 01 38 43 E2 FF 24 84 E2 01 3C 43 E2 01 28 42 E2 01 30 43 E2 01 2C 42 E2 0C 30 C3 E1 01 20 42 E2 7F 34 C3 E3 04 20 C2 E1 7F 38 C3 E3 7F 24 C2 E3 7F 3C C3 E3 7F 28 C2 E3 7F 30 C3 E3 7F 2C C2 E3 00 00 53 E3 7F 20 C2 E3 E7 FF FF 0A 00 30 D0 E5 00 00 53 E3 03 00 00 1A 05 00 00 EA 01 30 F0 E5 00 00 53 E3 02 00 00 0A 03 00 51 E1 FA FF FF 1A B8 FF FF EA 00 00 A0 E3 B6 FF FF EA }
	condition:
		$1
}

rule file_246_0_0 {
	meta:
		name = "ferror"
		size = 60
		refs = "0024 __sinit 0038 _impure_ptr"
	strings:
		$1 = { 30 30 9F E5 00 30 93 E5 00 00 53 E3 10 40 2D E9 00 40 A0 E1 03 00 00 0A 38 20 93 E5 00 00 52 E3 03 00 A0 01 ?? ?? ?? ?? BC 00 D4 E1 20 03 A0 E1 01 00 00 E2 10 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_248_0_0 {
	meta:
		name = "__eprintf"
		size = 60
		refs = "0030 fiprintf 0034 abort 0038 _impure_ptr"
	strings:
		$1 = { 10 40 2D E9 2C C0 9F E5 00 C0 9C E5 0C C0 9C E5 02 E0 A0 E1 04 D0 4D E2 01 40 A0 E1 00 30 8D E5 00 10 A0 E1 04 20 A0 E1 0E 30 A0 E1 0C 00 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_249_0_0 {
	meta:
		name = "_unlink_r"
		size = 56
		refs = "0018 _unlink 0034 errno"
	strings:
		$1 = { 30 40 2D E9 28 40 9F E5 00 30 A0 E3 00 50 A0 E1 01 00 A0 E1 00 30 84 E5 ?? ?? ?? ?? 01 00 70 E3 30 80 BD 18 00 30 94 E5 00 00 53 E3 00 30 85 15 30 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_274_0_0 {
	meta:
		name = "_close_r"
		size = 56
		refs = "0018 _close 0034 errno"
	strings:
		$1 = { 30 40 2D E9 28 40 9F E5 00 30 A0 E3 00 50 A0 E1 01 00 A0 E1 00 30 84 E5 ?? ?? ?? ?? 01 00 70 E3 30 80 BD 18 00 30 94 E5 00 00 53 E3 00 30 85 15 30 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_433_0_0 {
	meta:
		name = "_isatty_r"
		size = 56
		refs = "0018 _isatty 0034 errno"
	strings:
		$1 = { 30 40 2D E9 28 40 9F E5 00 30 A0 E3 00 50 A0 E1 01 00 A0 E1 00 30 84 E5 ?? ?? ?? ?? 01 00 70 E3 30 80 BD 18 00 30 94 E5 00 00 53 E3 00 30 85 15 30 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_473_0_0 {
	meta:
		name = "_sbrk_r"
		size = 56
		refs = "0018 _sbrk 0034 errno"
	strings:
		$1 = { 30 40 2D E9 28 40 9F E5 00 30 A0 E3 00 50 A0 E1 01 00 A0 E1 00 30 84 E5 ?? ?? ?? ?? 01 00 70 E3 30 80 BD 18 00 30 94 E5 00 00 53 E3 00 30 85 15 30 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_312_0_0 {
	meta:
		name = "_wait_r"
		size = 56
		refs = "0018 _wait 0034 errno"
	strings:
		$1 = { 30 40 2D E9 28 40 9F E5 00 30 A0 E3 00 50 A0 E1 01 00 A0 E1 00 30 84 E5 ?? ?? ?? ?? 01 00 70 E3 30 80 BD 18 00 30 94 E5 00 00 53 E3 00 30 85 15 30 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_250_0_0 {
	meta:
		name = "fgetc"
		size = 104
		refs = "004c __sinit 0060 __srget_r 0064 _impure_ptr"
		altNames = "getc"
	strings:
		$1 = { 30 40 2D E9 58 50 9F E5 00 30 95 E5 00 00 53 E3 00 40 A0 E1 02 00 00 0A 38 20 93 E5 00 00 52 E3 08 00 00 0A 04 30 94 E5 01 30 43 E2 00 00 53 E3 04 30 84 E5 06 00 00 BA 00 30 94 E5 01 00 D3 E4 00 30 84 E5 30 80 BD E8 03 00 A0 E1 ?? ?? ?? ?? F3 FF FF EA 00 00 95 E5 04 10 A0 E1 30 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_250_1_0 {
	meta:
		name = "_fgetc_r"
		size = 88
		refs = "0040 __sinit 0054 __srget_r"
		altNames = "_getc_r"
	strings:
		$1 = { 30 40 2D E9 00 40 50 E2 01 50 A0 E1 02 00 00 0A 38 30 94 E5 00 00 53 E3 08 00 00 0A 04 30 95 E5 01 30 43 E2 00 00 53 E3 04 30 85 E5 05 00 00 BA 00 30 95 E5 01 00 D3 E4 00 30 85 E5 30 80 BD E8 ?? ?? ?? ?? F4 FF FF EA 04 00 A0 E1 05 10 A0 E1 30 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_252_0_0 {
	meta:
		name = "_mstats_r"
		size = 40
		refs = "0014 fiprintf 0020 _malloc_stats_r"
	strings:
		$1 = { 10 40 2D E9 01 20 A0 E1 00 40 A0 E1 10 10 9F E5 0C 00 90 E5 ?? ?? ?? ?? 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_252_4_0 {
	meta:
		name = "mallinfo"
		size = 32
		refs = "0010 _mallinfo_r 001c _impure_ptr"
	strings:
		$1 = { 14 30 9F E5 10 40 2D E9 00 10 93 E5 00 40 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 10 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_253_0_0 {
	meta:
		name = "tsearch"
		size = 124
		refs = "0058 malloc"
	strings:
		$1 = { 00 00 51 E3 F0 40 2D E9 00 40 A0 E1 02 60 A0 E1 01 50 A0 E1 01 00 A0 01 09 00 00 1A F0 80 BD E8 00 10 97 E5 0F E0 A0 E1 16 FF 2F E1 00 00 50 E3 0F 00 00 0A 00 50 95 B5 00 50 95 A5 04 50 85 B2 08 50 85 A2 00 70 95 E5 00 00 57 E3 04 00 A0 E1 F2 FF FF 1A 0C 00 A0 E3 ?? ?? ?? ?? 00 00 50 E3 00 00 85 15 00 40 80 15 04 70 80 15 08 70 80 15 F0 80 BD E8 00 00 95 E5 F0 80 BD E8 }
	condition:
		$1
}

rule file_255_0_0 {
	meta:
		name = "towupper"
		size = 40
		refs = "0024 __ctype_ptr__"
	strings:
		$1 = { FE 00 50 E3 1E FF 2F 81 14 30 9F E5 00 30 93 E5 00 30 83 E0 01 30 D3 E5 02 00 13 E3 20 00 40 12 1E FF 2F E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_256_0_0 {
	meta:
		name = "strncmp"
		size = 344
	strings:
		$1 = { 00 00 52 E3 04 40 2D E5 48 00 00 0A 00 30 81 E1 03 00 13 E3 2E 00 00 1A 03 00 52 E3 00 40 A0 E1 01 C0 A0 E1 44 00 00 9A 00 10 90 E5 00 30 9C E5 03 00 51 E1 40 00 00 1A 04 20 52 E2 3B 00 00 0A FF 34 81 E2 01 38 43 E2 01 3C 43 E2 01 30 43 E2 01 30 C3 E1 7F 34 C3 E3 7F 38 C3 E3 7F 3C C3 E3 7F 30 C3 E3 00 00 53 E3 11 00 00 0A 2F 00 00 EA 00 10 94 E5 FF 34 81 E2 01 38 43 E2 01 3C 43 E2 01 30 43 E2 01 30 C3 E1 7F 34 C3 E3 00 00 9C E5 7F 38 C3 E3 7F 3C C3 E3 00 00 51 E1 7F 30 C3 E3 25 00 00 1A 04 20 52 E2 20 00 00 0A 00 00 53 E3 1E 00 00 1A 03 00 52 E3 04 40 84 E2 04 C0 8C E2 EA FF FF 8A 00 00 52 E3 04 00 A0 E1 0C 10 A0 E1 1C 00 00 0A 00 30 D0 E5 00 C0 D1 E5 0C 00 53 E1 01 20 42 E2 0F 00 00 1A 00 00 52 E3 0F 00 00 0A 00 00 53 E3 06 00 00 1A 0C 00 00 EA 00 00 52 E3 0A 00 00 0A 00 00 53 E3 01 00 80 E2 01 10 81 E2 06 00 00 0A 01 30 D0 E5 01 C0 D1 E5 0C 00 53 E1 01 20 42 E2 F4 FF FF 0A 03 00 6C E0 00 00 00 EA 00 00 A0 E3 10 00 BD E8 1E FF 2F E1 04 00 A0 E1 0C 10 A0 E1 E2 FF FF EA 00 30 D4 E5 00 C0 DC E5 03 00 6C E0 F6 FF FF EA }
	condition:
		$1
}

rule file_257_3_0 {
	meta:
		name = "_setlocale_r"
		size = 96
		refs = "0020 strcmp"
	strings:
		$1 = { 70 40 2D E9 00 40 52 E2 00 50 A0 E1 01 60 A0 E1 40 00 9F 05 70 80 BD 08 04 00 A0 E1 34 10 9F E5 ?? ?? ?? ?? 00 00 50 E3 03 00 00 1A 34 40 85 E5 30 60 85 E5 1C 00 9F E5 70 80 BD E8 04 00 A0 E1 14 10 9F E5 ?? ?? ?? ?? 00 00 50 E3 00 00 A0 13 F5 FF FF 0A 70 80 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_258_0_0 {
	meta:
		name = "exit"
		size = 48
		refs = "0008 __call_exitprocs 0028 _exit 002c _global_impure_ptr"
	strings:
		$1 = { 00 10 A0 E3 00 40 A0 E1 ?? ?? ?? ?? 18 30 9F E5 00 00 93 E5 3C 30 90 E5 00 00 53 E3 0F E0 A0 11 13 FF 2F 11 04 00 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_259_0_0 {
	meta:
		name = "isnanf"
		size = 28
		altNames = "__isnanf"
	strings:
		$1 = { 7F 34 A0 E3 02 35 83 E2 02 01 C0 E3 03 00 50 E1 00 00 A0 D3 01 00 A0 C3 1E FF 2F E1 }
	condition:
		$1
}

rule file_263_0_0 {
	meta:
		name = "rshift"
		size = 228
	strings:
		$1 = { F0 01 2D E9 10 40 90 E5 C1 32 A0 E1 14 20 80 E2 04 00 53 E1 02 C0 A0 E1 1C 00 00 AA 05 40 84 E2 05 30 83 E2 1F 10 11 E2 04 41 80 E0 03 51 80 E0 1D 00 00 0A 03 61 90 E7 04 30 85 E2 03 00 54 E1 36 61 A0 E1 20 80 61 E2 0D 00 00 9A 00 C0 A0 E3 00 70 93 E5 17 68 86 E1 0C 60 82 E7 04 60 93 E4 03 00 54 E1 36 61 A0 E1 04 C0 8C E2 F7 FF FF 8A 04 C0 65 E0 05 C0 4C E2 03 C0 CC E3 18 C0 8C E2 0C C0 80 E0 00 00 56 E3 00 60 8C E5 04 C0 8C 12 0C 20 62 E0 42 21 A0 E1 00 00 52 E3 10 20 80 E5 14 20 80 05 F0 01 BD E8 1E FF 2F E1 05 00 54 E1 F6 FF FF 9A 01 30 95 E7 01 30 82 E7 04 10 81 E2 01 30 85 E0 03 00 54 E1 F9 FF FF 8A 05 C0 E0 E1 04 C0 8C E0 03 C0 CC E3 18 C0 8C E2 0C C0 80 E0 EA FF FF EA }
	condition:
		$1
}

rule file_263_1_0 {
	meta:
		name = "__hexdig_init"
		size = 132
		refs = "0078 __hexdig"
	strings:
		$1 = { 6C 00 9F E5 6C 30 9F E5 10 10 A0 E3 30 20 A0 E3 02 10 C3 E7 01 20 F0 E5 01 10 81 E2 00 00 52 E3 FF 10 01 E2 F9 FF FF 1A 4C 00 9F E5 1A 10 A0 E3 61 20 A0 E3 02 10 C3 E7 01 20 F0 E5 01 10 81 E2 00 00 52 E3 FF 10 01 E2 F9 FF FF 1A 2C 00 9F E5 1A 10 A0 E3 41 20 A0 E3 02 10 C3 E7 01 20 F0 E5 01 10 81 E2 00 00 52 E3 FF 10 01 E2 F9 FF FF 1A 1E FF 2F E1 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_263_2_0 {
	meta:
		name = "__gethex"
		size = 1720
		refs = "01b0 _Balloc 0234 __hi0bits 02a0 _Bfree 0324 __any_on 0398 __hexdig_init 0568 __lshift 069c memcpy 06b4 __hexdig"
	strings:
		$1 = { F0 4F 2D E9 A8 46 9F E5 30 C0 D4 E5 0C D0 4D E2 00 00 5C E3 00 00 8D E5 01 80 A0 E1 02 B0 A0 E1 04 30 8D E5 DB 00 00 0A 00 30 98 E5 02 20 D3 E5 30 00 52 E3 02 60 83 E2 00 00 A0 13 06 00 00 1A 03 30 83 E2 00 00 A0 E3 03 60 A0 E1 01 20 D3 E4 30 00 52 E3 01 00 80 E2 FA FF FF 0A 02 50 D4 E7 00 00 55 E3 93 00 00 0A 00 10 A0 E3 06 30 A0 E1 01 50 A0 E1 00 20 D6 E5 00 00 00 EA 01 20 F3 E5 02 C0 D4 E7 00 00 5C E3 FB FF FF 1A 2E 00 52 E3 00 00 55 03 8D 00 00 0A 03 70 A0 E1 00 00 55 E3 05 50 67 10 00 30 D7 05 00 30 D7 15 05 51 A0 11 50 00 53 E3 0B 00 00 0A 70 00 53 E3 09 00 00 0A 07 20 A0 E1 00 00 51 E3 00 20 88 E5 2E 00 00 0A 00 00 50 E3 06 40 A0 03 00 40 A0 13 04 00 A0 E1 0C D0 8D E2 F0 8F BD E8 01 30 D7 E5 2B 00 53 E3 01 20 87 E2 E0 00 00 0A 2D 00 53 E3 00 C0 A0 13 08 C0 8D 15 1C 01 00 0A 03 C0 D4 E7 00 00 5C E3 EA FF FF 0A 19 00 5C E3 E8 FF FF CA 01 A0 D2 E5 8C 35 9F E5 0A 30 D3 E7 00 00 53 E3 10 C0 4C E2 01 20 82 E2 0D 00 00 0A 19 00 53 E3 0B 00 00 CA 05 90 A0 E1 01 00 00 EA 19 00 53 E3 06 00 00 CA 01 A0 F2 E5 10 50 43 E2 0A 30 D4 E7 0C C1 8C E0 00 00 53 E3 8C C0 85 E0 F6 FF FF 1A 09 50 A0 E1 08 30 9D E5 00 00 53 E3 00 C0 6C 12 00 00 51 E3 0C 50 85 E0 00 20 88 E5 D0 FF FF 1A 01 30 47 E2 03 30 66 E0 07 00 53 E3 03 00 00 DA C3 30 A0 E1 07 00 53 E3 01 10 81 E2 FB FF FF CA 00 00 9D E5 ?? ?? ?? ?? 07 00 56 E1 14 A0 80 E2 00 80 A0 E1 0A C0 A0 21 00 00 A0 23 15 00 00 2A 00 00 A0 E3 0A C0 A0 E1 00 30 A0 E1 00 00 00 EA 01 30 A0 E1 01 20 57 E5 2E 00 52 E3 03 10 A0 01 09 00 00 0A 20 00 53 E3 04 00 8C 04 01 20 57 05 02 20 D4 E7 00 00 A0 03 00 30 A0 01 0F 20 02 E2 12 03 80 E1 04 10 83 12 04 10 A0 03 01 70 47 E2 07 00 56 E1 ED FF FF 3A 04 00 8C E4 0C C0 6A E0 4C 41 A0 E1 10 40 88 E5 ?? ?? ?? ?? 84 42 A0 E1 00 60 9B E5 04 40 60 E0 06 00 54 E1 8F 00 00 CA C1 00 00 BA 00 70 A0 E3 08 30 9B E5 03 00 55 E1 7E 00 00 CA 04 30 9B E5 03 00 55 E1 01 40 A0 A3 3A 00 00 AA 03 40 65 E0 04 00 56 E1 21 00 00 CA 0C 20 9B E5 02 00 52 E3 C5 00 00 0A 03 00 52 E3 EF 00 00 0A 01 00 52 E3 E2 00 00 0A 00 00 9D E5 08 10 A0 E1 ?? ?? ?? ?? 30 20 9D E5 00 30 A0 E3 00 30 82 E5 50 40 A0 E3 88 FF FF EA 2E 00 52 E3 8E 00 00 0A 00 30 D6 E5 06 70 A0 E1 01 10 A0 E3 77 FF FF EA 01 20 D3 E5 02 20 D4 E7 01 70 83 E2 00 00 52 E3 07 50 A0 01 6C FF FF 0A 07 30 A0 E1 01 20 F3 E5 02 20 D4 E7 00 00 52 E3 FB FF FF 1A 07 50 A0 E1 64 FF FF EA 00 00 57 E3 01 50 44 E2 01 70 A0 13 05 00 00 1A 00 00 55 E3 03 00 00 DA 08 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 70 A0 E1 C5 32 A0 E1 03 31 9A E7 1F 50 05 E2 01 20 A0 E3 12 35 13 E0 04 10 A0 E1 08 00 A0 E1 02 70 87 13 F2 FE FF EB 04 50 9B E5 06 60 64 E0 02 40 A0 E3 00 00 57 E3 07 00 00 0A 0C 30 9B E5 02 00 53 E3 A9 00 00 0A 03 00 53 E3 A2 00 00 0A 01 00 53 E3 07 00 00 0A 10 40 84 E3 30 10 9D E5 04 20 9D E5 00 80 81 E5 00 50 82 E5 50 FF FF EA ?? ?? ?? ?? 21 FF FF EA 02 00 17 E3 F5 FF FF 0A 00 30 9A E5 03 70 87 E1 01 00 17 E3 F1 FF FF 0A 10 70 98 E5 05 10 87 E2 01 11 88 E0 00 20 A0 E3 00 30 9A E5 01 00 73 E3 A4 00 00 1A 04 20 8A E4 0A 00 51 E1 F9 FF FF 8A 08 30 98 E5 03 00 57 E1 08 A0 A0 B1 07 30 A0 E1 9F 00 00 AA 01 20 83 E2 01 10 A0 E3 05 30 83 E2 03 11 8A E7 10 20 8A E5 0A 80 A0 E1 02 00 54 E3 6E 00 00 0A 10 30 98 E5 03 00 57 E1 07 00 00 BA 1F 60 16 E2 74 00 00 0A 04 70 87 E2 07 01 98 E7 ?? ?? ?? ?? 20 60 66 E2 06 00 50 E1 6E 00 00 AA 08 00 A0 E1 01 10 A0 E3 B3 FE FF EB 08 30 9B E5 01 50 85 E2 03 00 55 E1 67 00 00 DA 00 00 9D E5 08 10 A0 E1 ?? ?? ?? ?? 30 C0 9D E5 00 30 A0 E3 00 30 8C E5 A3 40 A0 E3 17 FF FF EA 00 30 A0 E3 08 30 8D E5 01 30 F2 E5 1E FF FF EA 04 40 66 E0 08 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 00 70 50 E2 10 00 00 0A 01 10 44 E2 C1 32 A0 E1 05 30 83 E2 03 31 98 E7 1F 20 01 E2 01 70 A0 E3 17 32 13 E0 08 00 00 0A 07 00 51 E1 05 00 00 DA 01 10 41 E2 08 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 02 70 87 12 00 00 00 1A 02 70 A0 E3 08 00 A0 E1 04 10 A0 E1 89 FE FF EB 04 50 85 E0 55 FF FF EA 01 30 D6 E5 AC 21 9F E5 03 50 D2 E7 00 00 55 E3 01 70 86 E2 01 10 A0 03 E5 FE FF 0A 30 00 53 E3 07 30 A0 11 00 20 D7 15 18 00 00 1A 07 30 A0 E1 01 20 F3 E5 30 00 52 E3 FC FF FF 0A 02 10 D4 E7 00 00 51 E3 11 00 00 1A 01 10 A0 E3 07 50 A0 E1 03 60 A0 E1 01 00 A0 E1 C9 FE FF EA 06 40 64 E0 08 10 A0 E1 00 00 9D E5 04 20 A0 E1 ?? ?? ?? ?? 05 50 64 E0 00 80 A0 E1 14 A0 80 E2 34 FF FF EA 01 C0 A0 E3 08 C0 8D E5 01 30 F2 E5 DE FE FF EA 07 50 A0 E1 03 60 A0 E1 00 10 A0 E3 01 00 A0 E3 B7 FE FF EA 34 10 9D E5 00 00 51 E3 3A FF FF 1A 04 C0 9D E5 30 10 9D E5 01 20 A0 E3 00 30 8C E5 00 20 8A E5 00 80 81 E5 10 20 88 E5 62 40 A0 E3 C2 FE FF EA 00 30 9B E5 01 30 43 E2 06 00 53 E1 1F 00 00 1A C6 32 A0 E1 05 30 83 E2 03 31 98 E7 1F 60 06 E2 01 20 A0 E3 12 36 13 E0 18 00 00 0A 21 40 A0 E3 5F FF FF EA 34 30 9D E5 00 00 53 E3 69 FF FF 1A 10 40 84 E3 5A FF FF EA 34 C0 9D E5 01 30 6C E2 F8 FF FF EA 06 00 54 E1 1A FF FF 1A 01 00 56 E3 DD FF FF DA 01 10 46 E2 08 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 04 30 9B 15 D7 FF FF 1A 11 FF FF EA 34 20 9D E5 00 00 52 E3 0E FF FF 0A D2 FF FF EA 22 40 A0 E3 46 FF FF EA 01 30 83 E2 00 30 8A E5 65 FF FF EA 04 10 98 E5 00 00 9D E5 01 10 81 E2 ?? ?? ?? ?? 10 20 98 E5 02 20 82 E2 00 A0 A0 E1 02 21 A0 E1 0C 10 88 E2 0C 00 80 E2 ?? ?? ?? ?? 00 00 9D E5 08 10 A0 E1 ?? ?? ?? ?? 10 30 9A E5 4F FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_264_0_0 {
	meta:
		name = "__sflags"
		size = 192
	strings:
		$1 = { 00 30 D1 E5 72 00 53 E3 30 00 2D E9 1F 00 00 0A 77 00 53 E3 19 00 00 0A 61 00 53 E3 16 30 A0 13 00 30 80 15 00 00 A0 13 01 00 00 0A 30 00 BD E8 1E FF 2F E1 82 4F A0 E3 01 C0 A0 E3 42 0F A0 E3 01 30 D1 E5 00 00 53 E3 09 00 00 0A 2B 00 53 E3 16 00 00 0A 02 50 D1 E5 2B 00 55 E3 13 00 00 0A 62 00 53 E3 0D 00 00 0A 02 30 D1 E5 62 00 53 E3 0A 00 00 0A 04 C0 8C E1 00 C0 82 E5 EA FF FF EA 06 4C A0 E3 01 C0 A0 E3 08 00 A0 E3 EB FF FF EA 00 40 A0 E3 04 C0 A0 E1 04 00 A0 E3 E7 FF FF EA 01 C8 8C E3 04 C0 8C E1 00 C0 82 E5 DE FF FF EA 1C 00 C0 E3 10 00 80 E3 02 C0 A0 E3 E7 FF FF EA }
	condition:
		$1
}

rule file_266_0_0 {
	meta:
		name = "ldexp"
		size = 156
		refs = "0010 finite 002c __eqdf2 0050 scalbn 0084 __errno"
	strings:
		$1 = { 70 40 2D E9 02 60 A0 E1 00 40 A0 E1 01 50 A0 E1 ?? ?? ?? ?? 00 00 50 E3 06 00 00 0A 04 00 A0 E1 05 10 A0 E1 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 02 00 00 1A 04 00 A0 E1 05 10 A0 E1 70 80 BD E8 06 20 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 ?? ?? ?? ?? 00 00 50 E3 06 00 00 0A 04 00 A0 E1 05 10 A0 E1 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 EC FF FF 1A ?? ?? ?? ?? 22 30 A0 E3 00 30 80 E5 05 10 A0 E1 04 00 A0 E1 70 80 BD E8 }
	condition:
		$1
}

rule file_267_0_0 {
	meta:
		name = "towlower"
		size = 40
		refs = "0024 __ctype_ptr__"
	strings:
		$1 = { FE 00 50 E3 1E FF 2F 81 14 30 9F E5 00 30 93 E5 00 30 83 E0 01 30 D3 E5 01 00 13 E3 20 00 80 12 1E FF 2F E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_268_0_0 {
	meta:
		name = "gmtime"
		size = 20
		refs = "000c gmtime_r 0010 _impure_ptr"
	strings:
		$1 = { 08 30 9F E5 00 10 93 E5 7C 10 81 E2 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_379_0_0 {
	meta:
		name = "localtime"
		size = 20
		refs = "000c localtime_r 0010 _impure_ptr"
	strings:
		$1 = { 08 30 9F E5 00 10 93 E5 7C 10 81 E2 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_269_0_0 {
	meta:
		name = "_putenv_r"
		size = 108
		refs = "0008 _strdup_r 0018 index 0038 _setenv_r 0048 _free_r"
	strings:
		$1 = { 70 40 2D E9 00 50 A0 E1 ?? ?? ?? ?? 00 40 50 E2 12 00 00 0A 3D 10 A0 E3 ?? ?? ?? ?? 00 20 50 E2 0B 00 00 0A 00 30 A0 E3 01 30 C2 E4 04 10 A0 E1 01 30 A0 E3 05 00 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 00 60 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 06 00 A0 E1 70 80 BD E8 05 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 01 60 A0 E3 06 00 A0 E1 70 80 BD E8 }
	condition:
		$1
}

rule file_270_0_0 {
	meta:
		name = "_ftell_r"
		size = 232
		refs = "00bc _fflush_r 00c8 __sinit"
	strings:
		$1 = { 30 40 2D E9 00 50 50 E2 01 40 A0 E1 02 00 00 0A 38 30 95 E5 00 00 53 E3 2A 00 00 0A 28 30 94 E5 00 00 53 E3 1D 30 A0 03 00 30 85 05 00 00 E0 03 30 80 BD 08 BC 30 D4 E1 08 00 13 E3 1C 00 00 1A 01 2A 13 E2 50 00 94 15 10 00 00 0A 04 00 13 E3 07 00 00 1A 08 00 13 E3 30 80 BD 08 00 30 94 E5 00 00 53 E3 10 20 94 15 03 30 62 10 03 00 80 10 30 80 BD E8 30 20 94 E5 04 30 94 E5 00 00 52 E3 00 00 63 E0 3C 30 94 15 00 00 63 10 30 80 BD E8 05 00 A0 E1 1C 10 94 E5 01 30 A0 E3 0F E0 A0 E1 28 F0 94 E5 01 00 70 E3 30 80 BD 08 BC 30 D4 E1 E5 FF FF EA 05 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? BC 30 D4 E1 DD FF FF EA ?? ?? ?? ?? 28 30 94 E5 00 00 53 E3 1D 30 A0 03 00 30 85 05 00 00 E0 03 D3 FF FF 1A 30 80 BD E8 }
	condition:
		$1
}

rule file_271_0_0 {
	meta:
		name = "__sfvwrite_r"
		size = 1188
		refs = "009c memmove 0214 __swsetup_r 02d4 _malloc_r 02e8 memcpy 0360 _fflush_r 0380 memchr 044c _realloc_r 0460 _free_r"
	strings:
		$1 = { F0 4F 2D E9 08 30 92 E5 08 D0 4D E2 00 00 53 E3 02 70 A0 E1 04 00 8D E5 01 40 A0 E1 4B 00 00 0A BC 30 D1 E1 08 00 13 E3 03 80 A0 E1 76 00 00 0A 10 20 91 E5 00 00 52 E3 73 00 00 0A 02 B0 18 E2 00 80 A0 13 00 50 97 E5 08 60 A0 11 2C 00 00 1A 01 80 18 E2 0B C0 A0 11 0B 80 A0 11 0B 60 A0 11 08 60 A0 01 40 00 00 1A 00 00 56 E3 1D 00 00 0A 02 0C 13 E3 08 A0 94 E5 6B 00 00 0A 0A 00 56 E1 0A 90 A0 E1 7E 00 00 2A 00 00 94 E5 06 A0 A0 E1 06 90 A0 E1 09 20 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 08 20 94 E5 00 30 94 E5 02 A0 6A E0 09 90 83 E0 08 A0 84 E5 00 90 84 E5 06 A0 A0 E1 06 90 A0 E1 08 30 97 E5 03 A0 6A E0 00 00 5A E3 06 60 69 E0 09 80 88 E0 08 A0 87 E5 1C 00 00 0A 00 00 56 E3 BC 30 D4 E1 E1 FF FF 1A 00 80 95 E5 04 60 95 E5 08 50 85 E2 DB FF FF EA 00 80 95 E5 04 60 95 E5 08 50 85 E2 00 00 56 E3 08 20 A0 E1 04 00 9D E5 F8 FF FF 0A 01 0B 56 E3 06 30 A0 31 01 3B A0 23 1C 10 94 E5 0F E0 A0 E1 24 F0 94 E5 00 00 50 E3 A7 00 00 DA 08 30 97 E5 03 30 60 E0 00 00 53 E3 00 80 88 E0 06 60 60 E0 08 30 87 E5 EC FF FF 1A 00 00 A0 E3 08 D0 8D E2 F0 8F BD E8 00 80 95 E5 04 60 95 E5 00 C0 A0 E3 08 50 85 E2 00 00 56 E3 F9 FF FF 0A 00 00 5C E3 7D 00 00 0A 14 30 94 E5 08 A0 94 E5 00 00 94 E5 10 20 94 E5 06 00 5B E1 0B 90 A0 31 06 90 A0 21 0A A0 83 E0 0A 00 59 E1 00 10 A0 D3 01 10 A0 C3 02 00 50 E1 00 10 A0 93 00 00 51 E3 79 00 00 1A 03 00 59 E1 57 00 00 BA 00 C0 8D E5 04 00 9D E5 1C 10 94 E5 08 20 A0 E1 0F E0 A0 E1 24 F0 94 E5 00 A0 50 E2 00 C0 9D E5 7B 00 00 DA 0A B0 5B E0 5A 00 00 0A 08 30 97 E5 03 30 6A E0 00 00 53 E3 0A 80 88 E0 06 60 6A E0 08 30 87 E5 D8 FF FF 1A D0 FF FF EA 04 00 9D E5 04 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 94 00 00 1A BC 30 D4 E1 03 80 A0 E1 83 FF FF EA 00 00 94 E5 10 30 94 E5 06 00 5A E1 00 20 A0 23 01 20 A0 33 03 00 50 E1 00 20 A0 93 00 00 52 E3 0A 90 A0 E1 70 00 00 1A 14 30 94 E5 03 00 56 E1 61 00 00 3A 04 00 9D E5 1C 10 94 E5 08 20 A0 E1 0F E0 A0 E1 24 F0 94 E5 00 A0 50 E2 55 00 00 DA 0A 90 A0 E1 8E FF FF EA 12 0D 13 E3 00 00 94 05 80 FF FF 0A 10 10 94 E5 00 90 94 E5 14 A0 94 E5 09 90 61 E0 8A A0 8A E0 AA AF 8A E0 01 00 89 E2 CA A0 A0 E1 06 00 80 E0 00 00 5A E1 0A 20 A0 E1 00 A0 A0 31 0A 20 A0 31 01 0B 13 E3 5E 00 00 0A 02 10 A0 E1 04 00 9D E5 ?? ?? ?? ?? 00 B0 50 E2 6C 00 00 0A 10 10 94 E5 09 20 A0 E1 ?? ?? ?? ?? BC 30 D4 E1 12 3D C3 E3 80 30 83 E3 BC 30 C4 E1 0A 30 69 E0 09 00 8B E0 14 A0 84 E5 08 30 84 E5 10 B0 84 E5 00 00 84 E5 06 A0 A0 E1 06 90 A0 E1 5C FF FF EA 09 20 A0 E1 08 10 A0 E1 00 C0 8D E5 ?? ?? ?? ?? 08 20 94 E5 00 30 94 E5 09 A0 A0 E1 02 20 69 E0 09 30 83 E0 0A B0 5B E0 08 20 84 E5 00 30 84 E5 00 C0 9D E5 A4 FF FF 1A 04 00 9D E5 04 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 19 00 00 1A 0B C0 A0 E1 9D FF FF EA 08 00 A0 E1 0A 10 A0 E3 06 20 A0 E1 ?? ?? ?? ?? 00 00 50 E3 01 B0 80 12 0B B0 68 10 01 C0 A0 13 01 B0 86 02 01 C0 A0 03 76 FF FF EA 08 10 A0 E1 0A 20 A0 E1 00 C0 8D E5 ?? ?? ?? ?? 00 30 94 E5 0A 30 83 E0 00 30 84 E5 04 00 9D E5 04 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 00 C0 9D E5 83 FF FF 0A BC 30 D4 E1 40 30 83 E3 BC 30 C4 E1 00 00 E0 E3 5A FF FF EA 06 20 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 08 20 94 E5 00 30 94 E5 02 20 66 E0 06 30 83 E0 08 20 84 E5 00 30 84 E5 06 A0 A0 E1 06 90 A0 E1 29 FF FF EA 08 10 A0 E1 0A 20 A0 E1 ?? ?? ?? ?? 00 30 94 E5 0A 30 83 E0 00 30 84 E5 04 00 9D E5 04 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 1E FF FF 0A E2 FF FF EA 04 00 9D E5 ?? ?? ?? ?? 00 B0 50 E2 A8 FF FF 1A 10 10 94 E5 04 00 9D E5 ?? ?? ?? ?? 04 10 9D E5 0C 30 A0 E3 00 30 81 E5 D7 FF FF EA BC 30 D4 E1 04 10 9D E5 40 30 83 E3 BC 30 C4 E1 09 30 A0 E3 00 30 81 E5 00 00 E0 E3 2F FF FF EA 04 20 9D E5 0C 30 A0 E3 00 30 82 E5 CB FF FF EA }
	condition:
		$1
}

rule file_272_0_0 {
	meta:
		name = "argz_add"
		size = 100
		refs = "0020 strlen 0038 realloc 0058 memcpy"
	strings:
		$1 = { F0 41 2D E9 00 60 52 E2 00 50 A0 E1 01 40 A0 E1 00 80 91 E5 06 00 A0 01 F0 81 BD 08 06 00 A0 E1 ?? ?? ?? ?? 00 10 94 E5 01 70 80 E2 01 10 87 E0 00 10 84 E5 00 00 95 E5 ?? ?? ?? ?? 00 00 50 E3 00 00 85 E5 0C 00 A0 03 F0 81 BD 08 08 00 80 E0 06 10 A0 E1 07 20 A0 E1 ?? ?? ?? ?? 00 00 A0 E3 F0 81 BD E8 }
	condition:
		$1
}

rule file_276_0_0 {
	meta:
		name = "isspace"
		size = 28
		refs = "0018 __ctype_ptr__"
	strings:
		$1 = { 10 30 9F E5 00 30 93 E5 00 30 83 E0 01 00 D3 E5 08 00 00 E2 1E FF 2F E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_277_0_0 {
	meta:
		name = "_lrand48_r"
		size = 36
		refs = "000c __dorand48"
	strings:
		$1 = { 10 40 2D E9 AC 10 80 E2 00 40 A0 E1 ?? ?? ?? ?? B0 3B D4 E1 BE 0A D4 E1 83 37 A0 E1 A0 00 83 E0 10 80 BD E8 }
	condition:
		$1
}

rule file_278_0_0 {
	meta:
		name = "wcsnlen"
		size = 68
	strings:
		$1 = { 00 30 90 E5 00 00 53 E3 0B 00 00 0A 00 00 51 E3 09 00 00 0A 00 30 A0 E1 01 00 00 EA 01 10 51 E2 02 00 00 0A 04 20 B3 E5 00 00 52 E3 FA FF FF 1A 03 00 60 E0 40 01 A0 E1 1E FF 2F E1 00 00 A0 E3 1E FF 2F E1 }
	condition:
		$1
}

rule file_279_0_0 {
	meta:
		name = "copysign"
		size = 28
	strings:
		$1 = { 02 21 02 E2 02 31 C0 E3 04 40 2D E5 03 00 82 E1 01 40 A0 E1 10 00 BD E8 1E FF 2F E1 }
	condition:
		$1
}

rule file_280_0_0 {
	meta:
		name = "l64a"
		size = 128
		refs = "0078 _impure_ptr"
	strings:
		$1 = { 70 30 9F E5 00 30 93 E5 00 20 50 E2 D4 00 83 E2 04 40 2D E5 00 30 A0 01 12 00 00 0A 58 C0 9F E5 3F 10 02 E2 01 10 DC E7 22 23 A0 E1 00 00 52 E3 D4 10 C3 E5 D9 40 83 E2 3F 10 02 E2 D5 30 83 E2 08 00 00 0A 01 10 DC E7 04 00 53 E1 00 10 C3 E5 06 00 00 0A 22 23 A0 E1 00 00 52 E3 01 30 83 E2 3F 10 02 E2 F6 FF FF 1A 00 20 A0 E3 00 20 C3 E5 10 00 BD E8 1E FF 2F E1 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_280_1_0 {
	meta:
		name = "_l64a_r"
		size = 120
	strings:
		$1 = { 30 00 2D E9 00 00 51 E3 D4 50 80 E2 05 20 A0 01 12 00 00 0A 58 C0 9F E5 3F 30 01 E2 03 30 DC E7 D4 30 C0 E5 21 33 A0 E1 00 00 53 E3 D9 40 80 E2 D5 20 80 E2 3F 10 03 E2 08 00 00 0A 01 10 DC E7 04 00 52 E1 00 10 C2 E5 06 00 00 0A 23 33 A0 E1 00 00 53 E3 01 20 82 E2 3F 10 03 E2 F6 FF FF 1A 00 30 A0 E3 00 30 C2 E5 05 00 A0 E1 30 00 BD E8 1E FF 2F E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_283_0_0 {
	meta:
		name = "isalnum"
		size = 28
		refs = "0018 __ctype_ptr__"
	strings:
		$1 = { 10 30 9F E5 00 30 93 E5 00 30 83 E0 01 00 D3 E5 07 00 00 E2 1E FF 2F E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_285_0_0 {
	meta:
		name = "_wcstoull_r"
		size = 724
		refs = "0040 iswspace 0088 __umoddi3 009c __udivdi3 00b4 iswdigit 0154 iswalpha 0164 iswupper"
	strings:
		$1 = { F0 4F 2D E9 03 A0 A0 E1 01 00 53 E3 00 30 A0 13 01 30 A0 03 1C D0 4D E2 AA 3F 93 E1 10 00 8D E5 0C 10 8D E5 14 20 8D E5 65 00 00 1A 24 00 5A E3 0C 50 9D D5 62 00 00 CA 04 40 95 E4 04 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 FA FF FF 1A 2D 00 54 E3 7A 00 00 0A 2B 00 54 E3 04 40 95 04 18 00 8D E5 01 30 7A E2 00 30 A0 33 00 00 5A E3 10 00 5A 13 5C 00 00 0A 0A 20 A0 E1 C2 3F A0 E1 00 00 E0 E3 00 10 E0 E3 0C 00 8D E8 ?? ?? ?? ?? 00 90 A0 E1 0C 00 9D E8 00 00 E0 E3 00 10 E0 E3 ?? ?? ?? ?? 00 B0 A0 E1 04 00 A0 E1 08 90 8D E5 0A 90 A0 E1 01 A0 A0 E1 ?? ?? ?? ?? 00 00 50 E3 00 60 A0 E3 00 70 A0 E3 00 80 A0 E3 30 40 44 12 1F 00 00 0A 04 00 59 E1 29 00 00 DA 0A 00 58 E1 00 30 A0 E3 51 00 00 8A 4E 00 00 0A A6 3F 83 E1 FF 30 13 E2 48 00 00 1A 08 00 9D E5 00 00 54 E1 00 20 A0 D3 01 20 A0 C3 0B 00 57 E1 49 00 00 0A 03 00 12 E1 40 00 00 1A 04 10 9D E5 97 01 01 E0 00 00 9D E5 97 20 83 E0 90 18 21 E0 04 70 92 E0 03 30 81 E0 C4 8F A3 E0 04 40 95 E4 01 60 A0 E3 04 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 30 40 44 12 DF FF FF 1A 04 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 07 00 00 0A 04 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 37 00 A0 13 57 00 A0 03 04 40 60 E0 04 00 59 E1 D5 FF FF CA 00 00 56 E3 31 00 00 BA 18 20 9D E5 00 00 52 E3 01 00 00 0A 00 70 77 E2 00 80 E8 E2 14 30 9D E5 00 00 53 E3 0B 00 00 0A 00 00 56 E3 04 50 45 12 0C 50 8D 15 14 10 9D E5 0C 00 9D E5 00 00 81 E5 04 00 00 EA 10 00 9D E5 16 30 A0 E3 00 30 80 E5 00 70 A0 E3 00 80 A0 E3 08 10 A0 E1 07 00 A0 E1 1C D0 8D E2 F0 8F BD E8 30 00 54 E3 23 00 00 0A 00 00 53 E3 2D 00 00 0A 30 00 54 E3 19 00 00 0A 0A 10 A0 E3 00 20 A0 E3 05 90 A0 E3 06 00 8D E8 0A A0 A0 E3 9D FF FF EA 00 60 E0 E3 04 40 95 E4 C5 FF FF EA 0B 00 57 E1 AE FF FF 9A 01 30 A0 E3 AC FF FF EA 0A 00 58 E1 01 30 A0 03 B2 FF FF EA 01 10 A0 E3 04 40 95 E4 18 10 8D E5 83 FF FF EA 10 10 9D E5 22 30 A0 E3 00 30 81 E5 00 70 E0 E3 00 80 E0 E3 CC FF FF EA 08 20 A0 E3 00 30 A0 E3 07 90 A0 E3 0C 00 8D E8 08 A0 A0 E3 83 FF FF EA 00 20 95 E5 78 00 52 E3 58 00 52 13 D7 FF FF 1A 10 20 A0 E3 00 30 A0 E3 04 40 95 E5 0F 90 A0 E3 08 50 85 E2 0C 00 8D E8 10 A0 A0 E3 77 FF FF EA 0A 00 A0 E1 C0 1F A0 E1 03 00 8D E8 0C 00 9D E8 00 00 E0 E3 00 10 E0 E3 ?? ?? ?? ?? 00 90 A0 E1 6E FF FF EA }
	condition:
		$1
}

rule file_286_0_0 {
	meta:
		name = "_strdup_r"
		size = 60
		refs = "0010 strlen 0020 _malloc_r 0030 memcpy"
	strings:
		$1 = { 70 40 2D E9 00 40 A0 E1 01 00 A0 E1 01 60 A0 E1 ?? ?? ?? ?? 01 50 80 E2 05 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 40 50 E2 06 10 A0 11 05 20 A0 11 ?? ?? ?? ?? 04 00 A0 E1 70 80 BD E8 }
	condition:
		$1
}

rule file_287_0_0 {
	meta:
		name = "stpcpy"
		size = 108
	strings:
		$1 = { 00 30 81 E1 03 00 13 E3 0E 00 00 1A 00 20 91 E5 01 00 00 EA 04 20 80 E4 04 20 B1 E5 FF 34 82 E2 01 38 43 E2 01 3C 43 E2 01 30 43 E2 02 30 C3 E1 7F 34 C3 E3 7F 38 C3 E3 7F 3C C3 E3 7F 30 C3 E3 00 00 53 E3 F2 FF FF 0A 00 30 A0 E3 03 20 D1 E7 00 00 52 E3 03 20 C0 E7 03 20 80 E0 01 30 83 E2 F9 FF FF 1A 02 00 A0 E1 1E FF 2F E1 }
	condition:
		$1
}

rule file_289_0_0 {
	meta:
		name = "_fwalk_reent"
		size = 132
		refs = "000c __sfp_lock_acquire 0078 __sfp_lock_release"
	strings:
		$1 = { F0 45 2D E9 00 70 A0 E1 01 A0 A0 E1 ?? ?? ?? ?? 2E 6E 97 E2 06 80 A0 01 16 00 00 0A 00 80 A0 E3 04 50 96 E5 01 50 55 E2 08 40 96 E5 01 00 00 5A 0D 00 00 EA 68 40 84 E2 FC 30 D4 E1 00 00 53 E3 07 00 00 0A FE 30 D4 E1 01 00 73 E3 04 10 A0 E1 07 00 A0 E1 02 00 00 0A 0F E0 A0 E1 1A FF 2F E1 00 80 88 E1 01 50 55 E2 F1 FF FF 5A 00 60 96 E5 00 00 56 E3 E9 FF FF 1A ?? ?? ?? ?? 08 00 A0 E1 F0 85 BD E8 }
	condition:
		$1
}

rule file_289_1_0 {
	meta:
		name = "_fwalk"
		size = 128
		refs = "000c __sfp_lock_acquire 0074 __sfp_lock_release"
	strings:
		$1 = { F0 41 2D E9 00 60 A0 E1 01 80 A0 E1 ?? ?? ?? ?? 2E 6E 96 E2 06 70 A0 01 15 00 00 0A 00 70 A0 E3 04 50 96 E5 01 50 55 E2 08 40 96 E5 01 00 00 5A 0C 00 00 EA 68 40 84 E2 FC 30 D4 E1 00 00 53 E3 06 00 00 0A FE 30 D4 E1 01 00 73 E3 04 00 A0 E1 02 00 00 0A 0F E0 A0 E1 18 FF 2F E1 00 70 87 E1 01 50 55 E2 F2 FF FF 5A 00 60 96 E5 00 00 56 E3 EA FF FF 1A ?? ?? ?? ?? 07 00 A0 E1 F0 81 BD E8 }
	condition:
		$1
}

rule file_290_0_0 {
	meta:
		name = "wcscmp"
		size = 48
	strings:
		$1 = { 00 30 A0 E3 03 20 90 E7 03 C0 91 E7 0C 00 52 E1 04 00 00 1A 00 00 52 E3 04 30 83 E2 F8 FF FF 1A 02 00 A0 E1 1E FF 2F E1 02 00 6C E0 1E FF 2F E1 }
	condition:
		$1
}

rule file_291_0_0 {
	meta:
		name = "__exp10"
		size = 92
		refs = "0018 __exp10 0024 __muldf3"
	strings:
		$1 = { 04 00 50 E3 04 E0 2D E5 0E 00 00 9A 01 00 10 E3 05 00 00 1A A0 00 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 04 F0 9D E4 01 00 40 E2 ?? ?? ?? ?? 01 21 A0 E3 09 27 82 E2 00 30 A0 E3 ?? ?? ?? ?? 04 F0 9D E4 08 30 9F E5 80 01 83 E0 03 00 90 E8 04 F0 9D E4 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_292_0_0 {
	meta:
		name = "lflush"
		size = 28
		refs = "0018 fflush"
	strings:
		$1 = { BC 30 D0 E1 09 30 03 E2 09 00 53 E3 01 00 00 0A 00 00 A0 E3 1E FF 2F E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_292_1_0 {
	meta:
		name = "__srefill_r"
		size = 428
		refs = "00fc _free_r 012c __sinit 0140 _fwalk 0150 __smakebuf_r 0178 _fflush_r 01a4 _global_impure_ptr 01a8 lflush"
	strings:
		$1 = { 30 40 2D E9 00 50 50 E2 01 40 A0 E1 02 00 00 0A 38 30 95 E5 00 00 53 E3 43 00 00 0A BC 30 D4 E1 02 0A 13 E3 05 00 00 1A 02 2A 83 E3 64 30 94 E5 BC 20 C4 E1 02 3A C3 E3 64 30 84 E5 BC 30 D4 E1 00 10 A0 E3 20 00 13 E3 04 10 84 E5 03 10 A0 E1 33 00 00 1A 04 00 13 E3 21 00 00 1A 10 00 13 E3 3C 00 00 0A 08 00 13 E3 40 00 00 1A 04 10 81 E3 BC 10 C4 E1 10 30 94 E5 00 00 53 E3 31 00 00 0A BC 30 D4 E1 03 00 13 E3 29 00 00 1A 10 20 94 E5 05 00 A0 E1 00 20 84 E5 1C 10 94 E5 14 30 94 E5 0F E0 A0 E1 20 F0 94 E5 00 00 50 E3 04 00 84 E5 00 00 A0 C3 30 80 BD C8 BC 30 D4 11 BC 30 D4 01 40 30 83 13 20 30 83 03 BC 30 C4 11 00 30 A0 13 BC 30 C4 01 00 00 E0 03 04 30 84 15 00 00 E0 13 30 80 BD E8 30 10 94 E5 00 00 51 E3 E0 FF FF 0A 40 30 84 E2 03 00 51 E1 05 00 A0 11 ?? ?? ?? ?? 3C 30 94 E5 00 00 A0 E3 00 00 53 E3 30 00 84 E5 04 30 84 E5 D6 FF FF 0A 38 30 94 E5 00 30 84 E5 30 80 BD E8 00 00 E0 E3 30 80 BD E8 ?? ?? ?? ?? B9 FF FF EA 68 30 9F E5 68 10 9F E5 00 00 93 E5 ?? ?? ?? ?? D0 FF FF EA 05 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? C9 FF FF EA 40 30 83 E3 09 20 A0 E3 00 20 85 E5 BC 30 C4 E1 00 00 E0 E3 30 80 BD E8 05 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 E7 FF FF 1A BC 10 D4 E1 08 10 C1 E3 01 18 A0 E1 21 18 A0 E1 18 00 84 E5 BC 10 C4 E1 08 00 84 E5 B1 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_295_0_0 {
	meta:
		name = "ffs"
		size = 36
	strings:
		$1 = { 00 20 50 E2 02 00 A0 01 1E FF 2F 01 00 00 A0 E3 52 30 A0 E1 01 00 13 E3 01 00 80 E2 FB FF FF 0A 1E FF 2F E1 }
	condition:
		$1
}

rule file_296_0_0 {
	meta:
		name = "strncpy"
		size = 232
	strings:
		$1 = { 00 30 81 E1 03 00 13 E3 00 30 A0 13 01 30 A0 03 03 00 52 E3 00 30 A0 93 01 30 03 82 00 00 53 E3 30 00 2D E9 00 40 A0 11 1C 00 00 1A 00 40 A0 E1 00 00 52 E3 17 00 00 0A 00 50 D1 E5 04 C0 A0 E1 00 00 55 E3 01 20 42 E2 01 50 CC E4 02 30 84 12 08 00 00 0A 00 00 52 E3 0E 00 00 0A 01 C0 F1 E5 00 00 5C E3 01 C0 43 E5 01 20 42 E2 03 C0 A0 E1 01 30 83 E2 F6 FF FF 1A 00 00 52 E3 00 30 A0 13 03 10 A0 11 03 00 00 0A 03 10 CC E7 01 30 83 E2 02 00 53 E1 FB FF FF 1A 30 00 BD E8 1E FF 2F E1 00 C0 91 E5 FF 34 8C E2 01 38 43 E2 01 3C 43 E2 01 30 43 E2 0C 30 C3 E1 7F 34 C3 E3 7F 38 C3 E3 7F 3C C3 E3 7F 30 C3 E3 00 00 53 E3 D7 FF FF 1A 04 20 42 E2 03 00 52 E3 04 C0 84 E4 04 10 81 E2 EE FF FF 8A D1 FF FF EA }
	condition:
		$1
}

rule file_301_0_0 {
	meta:
		name = "wcsncpy"
		size = 80
	strings:
		$1 = { 00 30 A0 E3 00 00 52 E3 00 30 80 E5 0D 00 00 0A 00 30 91 E5 00 00 53 E3 0A 00 00 0A 00 C0 A0 E1 02 00 00 EA 04 30 B1 E5 00 00 53 E3 02 00 00 0A 01 20 52 E2 04 30 8C E4 F9 FF FF 1A 00 30 A0 E3 00 30 8C E5 1E FF 2F E1 00 C0 A0 E1 FA FF FF EA }
	condition:
		$1
}

rule file_302_0_0 {
	meta:
		name = "memseeker"
		size = 204
	strings:
		$1 = { 01 00 53 E3 00 C0 A0 E1 27 00 00 0A 02 00 53 E3 10 00 91 05 02 00 A0 11 00 00 82 00 00 00 50 E3 16 30 A0 B3 00 30 8C B5 00 00 E0 B3 1E FF 2F B1 0C 20 81 E2 0C 00 92 E8 03 00 52 E1 05 00 00 3A 03 00 50 E1 0C 00 81 E5 0C 00 00 3A 08 20 91 E5 00 30 82 E5 1E FF 2F E1 04 30 91 E5 18 C0 D1 E5 00 30 93 E5 02 C0 C3 E7 00 30 A0 E3 18 30 C1 E5 10 30 91 E5 03 00 50 E1 0C 00 81 E5 F2 FF FF 2A 04 30 91 E5 00 20 93 E5 00 20 D2 E7 18 20 C1 E5 00 30 93 E5 00 20 A0 E3 00 20 C3 E7 0C 20 91 E5 08 30 91 E5 00 20 83 E5 1E FF 2F E1 0C 00 91 E5 00 00 82 E0 00 00 50 E3 16 30 A0 B3 00 30 8C B5 00 00 E0 B3 D9 FF FF AA 1E FF 2F E1 }
	condition:
		$1
}

rule file_302_1_0 {
	meta:
		name = "memwriter"
		size = 244
		refs = "0054 memcpy 00a8 memset 00d0 _realloc_r"
	strings:
		$1 = { 0C C0 91 E5 F0 41 2D E9 03 50 A0 E1 0C 80 95 E0 04 30 91 E5 02 70 A0 E1 1B 20 A0 43 01 40 A0 E1 00 60 93 E5 00 20 80 45 00 50 E0 43 18 00 00 4A 14 30 91 E5 03 00 58 E1 1D 00 00 2A 10 00 94 E5 0C 00 50 E1 14 00 00 3A 0C 00 86 E0 05 20 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 0C 30 94 E5 10 20 94 E5 03 30 85 E0 0C 30 84 E5 02 00 53 E1 03 20 D6 97 10 30 84 85 03 60 86 80 03 60 86 90 00 30 A0 E3 18 20 C4 95 00 30 C6 E5 0C 20 94 E5 08 30 94 E5 00 20 83 E5 05 00 A0 E1 F0 81 BD E8 0C 20 60 E0 00 10 A0 E3 00 00 86 E0 ?? ?? ?? ?? 0C C0 94 E5 E4 FF FF EA 83 30 83 E0 A3 30 A0 E1 01 80 88 E2 03 00 58 E1 03 80 A0 31 06 10 A0 E1 08 20 A0 E1 ?? ?? ?? ?? 00 60 50 E2 00 50 E0 03 EC FF FF 0A 04 30 94 E5 14 80 84 E5 00 60 83 E5 0C C0 94 E5 D1 FF FF EA }
	condition:
		$1
}

rule file_302_2_0 {
	meta:
		name = "memcloser"
		size = 68
		refs = "0020 _realloc_r 0038 _free_r"
	strings:
		$1 = { 08 30 91 E5 00 20 93 E5 04 30 91 E5 30 40 2D E9 01 20 82 E2 01 40 A0 E1 00 10 93 E5 00 50 A0 E1 ?? ?? ?? ?? 00 00 50 E3 04 30 94 15 00 10 94 E5 00 00 83 15 05 00 A0 E1 ?? ?? ?? ?? 00 00 A0 E3 30 80 BD E8 }
	condition:
		$1
}

rule file_302_3_0 {
	meta:
		name = "_open_memstream_r"
		size = 300
		refs = "0030 __sfp 0044 _malloc_r 00ec __sfp_lock_acquire 00f8 __sfp_lock_release 0114 _free_r 0120 memwriter 0124 memseeker 0128 memcloser"
	strings:
		$1 = { 00 00 51 E3 00 00 52 13 16 30 A0 03 F0 47 2D E9 00 30 80 05 02 50 A0 E1 01 60 A0 E1 00 80 A0 E1 00 40 A0 03 01 00 00 1A 04 00 A0 E1 F0 87 BD E8 ?? ?? ?? ?? 00 40 50 E2 FA FF FF 0A 08 00 A0 E1 1C 10 A0 E3 ?? ?? ?? ?? 00 70 50 E2 26 00 00 0A 00 30 95 E5 3F 00 53 E3 14 30 87 E5 40 30 A0 93 14 30 87 95 1C 00 00 8A 00 A0 A0 E3 00 A0 85 E5 08 00 A0 E1 14 10 97 E5 ?? ?? ?? ?? 0A 00 50 E1 00 90 A0 E1 00 00 86 E5 1C 00 00 0A 8C 30 9F E5 00 A0 C0 E5 18 A0 C7 E5 24 30 84 E5 80 30 9F E5 28 30 84 E5 7C 30 9F E5 2C 30 84 E5 00 30 E0 E3 BE 30 C4 E1 08 30 A0 E3 00 70 87 E5 04 60 87 E5 08 50 87 E5 20 A0 84 E5 1C 70 84 E5 10 A0 87 E5 BC 30 C4 E1 04 00 A0 E1 F0 87 BD E8 01 08 53 E3 01 38 A0 83 14 30 87 85 DE FF FF EA ?? ?? ?? ?? BC 70 C4 E1 07 40 A0 E1 ?? ?? ?? ?? C9 FF FF EA ?? ?? ?? ?? BC 90 C4 E1 ?? ?? ?? ?? 08 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 09 40 A0 E1 C1 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_303_0_0 {
	meta:
		name = "strncasecmp"
		size = 156
		refs = "0098 __ctype_ptr__"
	strings:
		$1 = { 00 00 52 E3 F0 05 2D E9 02 00 A0 01 1F 00 00 0A 80 30 9F E5 01 20 42 E2 00 60 93 E5 00 40 A0 E3 07 00 00 EA 00 00 52 E3 13 00 00 0A 00 00 53 E3 11 00 00 0A 00 00 5C E3 01 40 84 E2 0E 00 00 0A 01 20 42 E2 04 30 D0 E7 03 C0 86 E0 01 C0 DC E5 01 A0 1C E2 04 C0 D1 E7 0C 50 86 E0 01 50 D5 E5 03 70 A0 01 20 70 83 12 01 50 15 E2 0C 80 A0 01 20 80 8C 12 07 00 58 E1 E9 FF FF 0A 00 00 5A E3 20 30 83 12 00 00 55 E3 20 C0 8C 12 03 00 6C E0 F0 05 BD E8 1E FF 2F E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_305_0_0 {
	meta:
		name = "getsubopt"
		size = 364
		refs = "00fc strcmp 0168 suboptarg"
	strings:
		$1 = { 70 40 2D E9 5C 41 9F E5 00 30 A0 E3 00 00 50 E3 00 30 82 E5 00 30 84 E5 02 00 00 1A 00 50 E0 E3 05 00 A0 E1 70 80 BD E8 00 C0 90 E5 03 00 5C E1 F9 FF FF 0A 00 30 DC E5 00 00 53 E3 07 00 00 0A 2C 00 53 E3 20 00 53 13 01 00 00 0A 09 00 53 E3 06 00 00 1A 01 30 FC E5 00 00 53 E3 F7 FF FF 1A 00 50 E0 E3 00 C0 80 E5 05 00 A0 E1 70 80 BD E8 00 C0 84 E5 01 30 FC E5 00 00 53 E3 14 00 00 0A 2C 00 53 E3 05 00 00 0A 3D 00 53 E3 21 00 00 0A 20 00 53 E3 01 00 00 0A 09 00 53 E3 F4 FF FF 1A 00 30 A0 E3 00 30 CC E5 01 30 FC E5 00 00 53 E3 07 00 00 0A 2C 00 53 E3 20 00 53 13 01 00 00 0A 09 00 53 E3 02 00 00 1A 01 30 FC E5 00 00 53 E3 F7 FF FF 1A 00 C0 80 E5 00 30 91 E5 00 00 53 E3 CD FF FF 0A 01 60 A0 E1 00 50 A0 E3 00 00 00 EA 01 50 85 E2 03 10 A0 E1 00 00 94 E5 ?? ?? ?? ?? 00 00 50 E3 C5 FF FF 0A 04 30 B6 E5 00 00 53 E3 F6 FF FF 1A C0 FF FF EA 00 30 A0 E3 01 30 CC E4 00 C0 82 E5 00 30 DC E5 2C 00 53 E3 00 00 53 13 06 00 00 1A 08 00 00 EA 09 00 53 E3 D7 FF FF 0A 01 30 FC E5 2C 00 53 E3 00 00 53 13 02 00 00 0A 20 00 53 E3 F7 FF FF 1A D0 FF FF EA 00 00 53 E3 D1 FF FF 0A CD FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_306_0_0 {
	meta:
		name = "__srget_r"
		size = 84
		refs = "0024 __srefill_r 004c __sinit"
	strings:
		$1 = { 30 40 2D E9 00 50 50 E2 01 40 A0 E1 02 00 00 0A 38 30 95 E5 00 00 53 E3 0B 00 00 0A 05 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 04 30 94 05 01 30 43 02 04 30 84 05 00 30 94 05 01 00 D3 04 00 00 E0 13 00 30 84 05 30 80 BD E8 ?? ?? ?? ?? F1 FF FF EA }
	condition:
		$1
}

rule file_310_0_0 {
	meta:
		name = "_malloc_trim_r"
		size = 248
		refs = "0010 __malloc_lock 0048 _sbrk_r 0060 __malloc_unlock 00ec __malloc_av_ 00f0 __malloc_current_mallinfo 00f4 __malloc_sbrk_base"
	strings:
		$1 = { F0 40 2D E9 E0 50 9F E5 01 70 A0 E1 00 40 A0 E1 ?? ?? ?? ?? 08 30 95 E5 04 60 93 E5 03 60 C6 E3 FE 3E 86 E2 0F 30 83 E2 03 70 67 E0 27 76 A0 E1 01 70 47 E2 07 76 A0 E1 01 0A 57 E3 06 00 00 BA 04 00 A0 E1 00 10 A0 E3 ?? ?? ?? ?? 08 30 95 E5 06 30 83 E0 03 00 50 E1 03 00 00 0A 04 00 A0 E1 ?? ?? ?? ?? 00 00 A0 E3 F0 80 BD E8 04 00 A0 E1 00 10 67 E2 ?? ?? ?? ?? 01 00 70 E3 0B 00 00 0A 68 30 9F E5 00 20 93 E5 08 10 95 E5 06 60 67 E0 01 60 86 E3 02 70 67 E0 04 00 A0 E1 04 60 81 E5 00 70 83 E5 ?? ?? ?? ?? 01 00 A0 E3 F0 80 BD E8 04 00 A0 E1 00 10 A0 E3 ?? ?? ?? ?? 08 30 95 E5 00 20 63 E0 0F 00 52 E3 E3 FF FF DA 20 10 9F E5 00 10 91 E5 00 00 61 E0 10 10 9F E5 01 20 82 E3 00 00 81 E5 04 20 83 E5 DB FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_310_1_0 {
	meta:
		name = "_free_r"
		size = 628
		refs = "0010 __malloc_lock 0160 __malloc_unlock 0224 _malloc_trim_r 0264 __malloc_av_ 026c __malloc_trim_threshold 0270 __malloc_top_pad"
	strings:
		$1 = { F0 41 2D E9 00 50 51 E2 00 40 A0 E1 F0 81 BD 08 ?? ?? ?? ?? 08 20 45 E2 04 00 92 E5 40 C2 9F E5 01 30 C0 E3 03 10 82 E0 08 70 9C E5 04 60 91 E5 01 00 57 E1 03 60 C6 E3 65 00 00 0A 01 00 10 E2 04 60 81 E5 00 00 A0 13 45 00 00 0A 06 50 81 E0 04 50 95 E5 01 00 15 E3 0A 00 00 1A 00 00 50 E3 06 30 83 E0 08 50 91 15 03 00 00 1A 08 50 91 E5 F0 61 9F E5 06 00 55 E1 6B 00 00 0A 0C 10 91 E5 08 50 81 E5 0C 10 85 E5 01 10 83 E3 00 00 50 E3 04 10 82 E5 03 30 82 E7 2E 00 00 1A 02 0C 53 E3 3E 00 00 3A A3 14 A0 E1 04 00 51 E3 23 03 A0 91 38 00 80 92 80 51 A0 91 15 00 00 9A 14 00 51 E3 5B 00 81 92 80 51 A0 91 11 00 00 9A 54 00 51 E3 23 06 A0 91 6E 00 80 92 80 51 A0 91 0C 00 00 9A 55 0F 51 E3 A3 07 A0 91 77 00 80 92 80 51 A0 91 07 00 00 9A 55 0E A0 E3 04 00 80 E2 00 00 51 E1 23 09 A0 91 7C 00 80 92 3F 5E A0 83 7E 00 A0 83 80 51 A0 91 05 50 8C E0 08 10 95 E5 05 00 51 E1 03 00 00 1A 47 00 00 EA 08 10 91 E5 01 00 55 E1 03 00 00 0A 04 00 91 E5 03 00 C0 E3 00 00 53 E1 F8 FF FF 3A 0C 30 91 E5 0C 30 82 E5 08 10 82 E5 0C 20 81 E5 08 20 83 E5 04 00 A0 E1 F0 41 BD E8 ?? ?? ?? ?? 08 70 15 E5 02 20 67 E0 08 50 92 E5 08 80 8C E2 08 00 55 E1 07 30 83 E0 0C 70 92 15 08 50 87 15 0C 70 85 15 06 50 81 E0 04 50 95 E5 01 00 A0 03 01 00 15 E3 BA FF FF 1A AE FF FF EA 04 10 9C E5 A3 31 A0 E1 43 01 A0 E1 01 50 A0 E3 15 00 81 E1 83 31 8C E0 08 10 93 E5 0C 30 82 E5 08 10 82 E5 04 00 8C E5 0C 20 81 E5 08 20 83 E5 E0 FF FF EA 01 00 10 E3 03 30 86 E0 06 00 00 1A 08 10 15 E5 02 20 61 E0 08 00 82 E2 21 00 90 E8 08 00 85 E5 0C 50 80 E5 01 30 83 E0 68 10 9F E5 00 10 91 E5 01 00 53 E1 01 30 83 E3 08 20 8C E5 04 30 82 E5 CF FF FF 3A 50 30 9F E5 04 00 A0 E1 00 10 93 E5 ?? ?? ?? ?? CA FF FF EA 01 10 83 E3 0C 20 85 E5 08 20 85 E5 03 30 82 E7 22 00 82 E9 0C 50 82 E5 C3 FF FF EA 04 50 9C E5 40 01 A0 E1 01 30 A0 E3 13 30 85 E1 04 30 8C E5 01 30 A0 E1 B8 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_311_0_0 {
	meta:
		name = "envz_merge"
		size = 236
		refs = "002c argz_next 0048 strdup 0054 strchr 006c envz_entry 007c free 00c8 envz_add 00e0 argz_add"
	strings:
		$1 = { F0 4F 2D E9 24 60 9D E5 00 40 A0 E3 00 90 A0 E1 01 B0 A0 E1 02 70 A0 E1 03 80 A0 E1 04 50 A0 E1 05 20 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 50 50 E2 17 00 00 0A 00 00 54 E3 15 00 00 1A 00 00 56 E3 15 00 00 1A ?? ?? ?? ?? 3D 10 A0 E3 00 A0 A0 E1 ?? ?? ?? ?? 00 00 50 E3 00 60 C0 15 0A 20 A0 E1 00 00 99 E5 00 10 9B E5 ?? ?? ?? ?? 00 00 50 E3 16 00 00 0A 0A 00 A0 E1 ?? ?? ?? ?? 05 20 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 50 50 E2 E7 FF FF 1A 04 00 A0 E1 F0 8F BD E8 ?? ?? ?? ?? 3D 10 A0 E3 00 A0 A0 E1 ?? ?? ?? ?? 00 30 50 E2 04 30 A0 01 01 40 C3 14 0A 20 A0 E1 09 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 D2 FF FF EA 09 00 A0 E1 0B 10 A0 E1 05 20 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 E2 FF FF EA }
	condition:
		$1
}

rule file_312_1_0 {
	meta:
		name = "_fork_r"
		size = 52
		refs = "0014 _fork 0030 errno"
	strings:
		$1 = { 30 40 2D E9 24 40 9F E5 00 30 A0 E3 00 30 84 E5 00 50 A0 E1 ?? ?? ?? ?? 01 00 70 E3 30 80 BD 18 00 30 94 E5 00 00 53 E3 00 30 85 15 30 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_313_0_0 {
	meta:
		name = "__buf_init"
		size = 48
	strings:
		$1 = { 0C 20 80 E2 0C 00 92 E8 01 20 42 E2 01 20 82 E0 52 33 A0 E1 07 1D 80 E2 06 00 53 E3 06 30 A0 B3 C0 11 80 E5 BC 31 80 E5 C4 11 80 E5 1E FF 2F E1 }
	condition:
		$1
}

rule file_313_1_0 {
	meta:
		name = "__reclaim_buf"
		size = 72
	strings:
		$1 = { 00 30 91 E5 04 20 91 E5 04 20 83 E5 04 20 91 E5 00 30 82 E5 C0 31 90 E5 00 30 81 E5 04 30 93 E5 C0 21 90 E5 04 30 81 E5 04 10 82 E5 04 20 91 E5 00 30 A0 E3 00 10 82 E5 14 30 C1 E5 08 30 81 E5 0C 30 81 E5 1E FF 2F E1 }
	condition:
		$1
}

rule file_313_2_0 {
	meta:
		name = "__buf_free"
		size = 204
		refs = "0070 free 00b8 __put_page"
	strings:
		$1 = { F0 45 2D E9 C0 41 90 E5 00 00 54 E3 04 D0 4D E2 00 80 A0 E1 01 60 A0 E1 02 70 A0 E1 07 5D 80 12 00 A0 A0 13 1C 00 00 0A 04 00 55 E1 1A 00 00 0A 0C 20 94 E5 00 00 52 E3 02 00 00 1A 14 30 D4 E5 04 00 13 E3 04 00 00 0A 00 00 57 E3 02 00 00 0A 14 30 D4 E5 01 00 13 E3 12 00 00 1A 00 00 56 E3 00 40 94 05 EF FF FF 0A 10 00 94 E5 00 00 50 E3 ?? ?? ?? ?? 00 30 94 E5 04 20 94 E5 04 20 83 E5 04 20 94 E5 04 00 A0 E1 00 30 82 E5 ?? ?? ?? ?? C0 41 98 E5 04 00 55 E1 E4 FF FF 1A 00 00 A0 E3 04 D0 8D E2 F0 85 BD E8 10 10 94 E5 04 30 03 E2 08 00 A0 E1 00 A0 8D E5 ?? ?? ?? ?? 00 00 50 E3 E5 FF FF 0A 00 00 E0 E3 F4 FF FF EA }
	condition:
		$1
}

rule file_313_3_0 {
	meta:
		name = "__get_buf"
		size = 948
		refs = "0284 __put_page 02a4 malloc 0338 __get_page 03a8 free"
	strings:
		$1 = { F0 4F 2D E9 00 70 52 E2 14 D0 4D E2 00 40 A0 E1 01 60 A0 E1 1B 00 00 0A 08 50 97 E5 00 00 55 E3 02 00 00 0A 0C 20 95 E5 01 00 52 E1 00 50 A0 13 00 00 53 E3 00 80 A0 13 03 90 A0 01 02 80 A0 03 08 90 A0 11 00 00 55 E3 1F 00 00 0A 00 30 95 E5 04 20 95 E5 04 20 83 E5 C4 21 94 E5 04 10 95 E5 04 20 85 E5 C4 51 84 E5 04 20 95 E5 07 4D 84 E2 00 30 81 E5 00 40 85 E5 00 50 82 E5 05 00 A0 E1 14 D0 8D E2 F0 8F BD E8 1C 20 90 E5 31 22 A0 E1 18 B0 90 E5 D8 31 90 E5 01 B0 4B E2 02 C1 93 E7 0B B0 01 E0 0B 51 9C E7 02 90 15 E2 03 50 C5 E3 03 00 00 1A 30 31 90 E5 00 00 53 E3 09 80 A0 11 DF FF FF 1A 01 80 A0 E3 DD FF FF EA BC 31 94 E5 00 00 53 E3 C0 51 94 E5 6F 00 00 1A 14 E0 D5 E5 08 00 1E E3 6C 00 00 1A 00 30 95 E5 04 20 95 E5 04 20 83 E5 0C 20 95 E5 04 10 95 E5 00 00 52 E3 00 30 81 E5 0E 00 A0 11 04 30 0E 12 02 00 00 1A 04 30 1E E2 0E 00 A0 E1 6F 00 00 0A 10 10 95 E5 B0 A0 D1 E1 00 00 5A E3 8A A0 81 10 B2 A0 5A 11 01 00 1E E3 0C A0 8D E5 8E 00 00 1A 00 00 53 E3 14 00 00 0A 0C 30 95 E5 1C 20 94 E5 33 22 A0 E1 18 10 94 E5 D8 A1 94 E5 30 E1 94 E5 01 10 41 E2 02 21 9A E7 00 00 5E E3 03 30 01 E0 03 31 82 00 7D 00 00 0A 01 00 10 E3 03 31 82 10 03 00 00 1A 03 11 92 E7 02 00 11 E3 03 31 82 E0 76 00 00 0A 02 20 A0 E3 00 20 83 E5 08 A0 95 E5 00 00 5A E3 4D 00 00 0A 14 30 DA E5 00 20 A0 E3 04 10 13 E2 08 20 85 E5 48 00 00 1A 0C 00 9A E5 0C 20 9D E5 00 00 52 E1 44 00 00 1A 10 C0 8D E5 00 20 A0 E1 0B C0 A0 E1 08 B0 A0 E1 05 80 A0 E1 0C 50 9D E5 1C 00 00 EA 00 30 9A E5 04 20 9A E5 04 20 83 E5 04 20 9A E5 00 30 82 E5 C0 31 94 E5 00 30 8A E5 04 20 93 E5 C0 31 94 E5 04 20 8A E5 04 A0 83 E5 08 10 9A E5 04 30 9A E5 00 20 A0 E3 00 00 51 E3 00 A0 83 E5 0C 20 8A E5 14 20 CA E5 49 00 00 0A 14 30 D1 E5 00 E0 A0 E3 04 00 13 E3 08 E0 8A E5 44 00 00 1A 0C 20 91 E5 02 00 55 E1 05 20 A0 E1 40 00 00 1A 01 A0 A0 E1 10 10 9A E5 B0 00 D1 E1 00 00 50 E3 80 00 81 10 B2 50 50 11 01 00 13 E3 DB FF FF 0A 00 30 A0 E3 04 00 A0 E1 08 C0 8D E5 00 30 8D E5 ?? ?? ?? ?? 00 00 50 E3 08 C0 9D E5 D3 FF FF 0A 00 50 A0 E3 77 FF FF EA 18 00 A0 E3 08 C0 8D E5 ?? ?? ?? ?? 00 50 50 E2 72 FF FF 0A 0C 00 94 E5 ?? ?? ?? ?? 00 00 50 E3 00 A0 A0 E1 10 00 85 E5 08 C0 9D E5 35 00 00 0A BC 31 94 E5 00 00 53 E3 01 30 43 12 BC 31 84 15 00 00 57 E3 00 30 A0 E3 08 30 85 E5 04 30 A0 03 14 30 C5 15 14 30 C5 05 C4 31 94 E5 04 30 85 E5 C4 51 84 E5 04 30 95 E5 07 2D 84 E2 08 50 87 15 00 20 85 E5 0C 60 85 E5 00 50 83 E5 10 10 95 E5 01 30 77 E2 00 30 A0 33 00 E0 A0 E3 04 00 A0 E1 06 20 A0 E1 08 C0 8D E5 00 41 8D E8 ?? ?? ?? ?? 00 00 50 E3 08 C0 9D E5 D2 FF FF 1A 00 00 57 E3 09 90 85 01 0B 91 8C 07 48 FF FF EA 08 50 A0 E1 0B 80 A0 E1 0C B0 A0 E1 10 C0 9D E5 DB FF FF EA 00 20 A0 E3 00 20 83 E5 87 FF FF EA 00 E0 A0 E3 04 00 A0 E1 08 C0 8D E5 00 E0 8D E5 ?? ?? ?? ?? 00 00 50 E3 08 C0 9D E5 BE FF FF 1A 14 00 D5 E5 04 30 00 E2 65 FF FF EA 05 00 A0 E1 ?? ?? ?? ?? 0A 50 A0 E1 31 FF FF EA }
	condition:
		$1
}

rule file_314_0_0 {
	meta:
		name = "__svfscanf_r"
		size = 5000
		refs = "00d4 __srefill_r 0714 memset 0730 _mbrtowc_r 0854 _ungetc_r 0914 _strtod_r 0a20 __sccl 1004 __ctype_ptr__ 1008 _strtol_r 1010 _strtoul_r 1014 __mb_cur_max 1134 iswspace 1200 sprintf 1230 __isnand 1250 __truncdfsf2 131c _fread_r 137c nanf"
	strings:
		$1 = { F0 4F 2D E9 01 40 A0 E1 BC 10 D1 E1 02 0A 11 E3 AA DF 4D E2 03 90 A0 E1 02 1A 81 03 64 30 94 05 BC 10 C4 01 19 1E 8D E2 00 80 A0 E1 02 3A C3 03 00 00 A0 E3 02 70 A0 E1 01 10 41 E2 3C 20 8D E2 64 30 84 05 10 00 8D E5 B4 6F 9F E5 28 10 8D E5 24 00 8D E5 1C 00 8D E5 04 20 8D E5 00 50 A0 E1 00 10 D7 E5 00 00 51 E3 A4 12 8D E5 1F 00 00 0A 00 20 96 E5 01 30 82 E0 01 30 D3 E5 08 30 13 E2 01 70 87 E2 1C 00 00 0A 04 20 94 E5 0C 00 00 EA 00 30 94 E5 00 10 96 E5 00 20 D3 E5 02 20 81 E0 01 20 D2 E5 08 00 12 E3 EC FF FF 0A 04 20 94 E5 01 30 83 E2 01 20 42 E2 00 30 84 E5 04 20 84 E5 01 50 85 E2 00 00 52 E3 F0 FF FF CA 08 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 EB FF FF 0A 00 10 D7 E5 00 00 51 E3 A4 12 8D E5 DF FF FF 1A 10 00 9D E5 AA DF 8D E2 F0 8F BD E8 25 00 51 E3 1B 00 00 0A 04 30 94 E5 00 00 53 E3 0B 00 00 DA 00 30 94 E5 01 20 57 E5 00 10 D3 E5 02 00 51 E1 F2 FF FF 1A 04 20 94 E5 01 30 83 E2 01 20 42 E2 04 20 84 E5 00 30 84 E5 01 50 85 E2 C7 FF FF EA 08 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 EE FF FF 0A 10 00 9D E5 00 00 50 E3 02 00 00 0A BC 30 D4 E1 40 00 13 E3 E1 FF FF 0A 00 00 E0 E3 DF FF FF EA 03 B0 A0 E1 0A 00 A0 E3 01 10 D7 E4 78 00 51 E3 01 F1 9F 97 78 00 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 01 20 82 E0 01 20 D2 E5 88 0C 9F E5 0A 10 A0 E3 01 00 12 E3 24 00 8D E5 1C 10 8D E5 01 B0 8B 13 03 A0 A0 E1 03 20 A0 E3 04 10 94 E5 00 00 51 E3 CF 02 00 DA 40 00 1B E3 00 10 94 05 03 C0 A0 01 12 00 00 0A 01 20 42 E2 03 00 52 E3 02 F1 9F 97 A4 00 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 08 00 A0 E1 04 10 A0 E1 08 20 8D E5 0C C0 8D E5 ?? ?? ?? ?? 00 00 50 E3 08 20 8D E2 04 10 92 E8 56 FF FF 1A 00 10 94 E5 01 50 85 E2 00 30 D1 E5 00 00 96 E5 03 30 80 E0 01 30 D3 E5 08 00 13 E3 A5 01 00 0A 04 30 94 E5 01 30 43 E2 00 00 53 E3 01 10 81 C2 04 30 84 E5 00 10 84 C5 E7 FF FF DA 01 50 85 E2 F0 FF FF EA 01 20 43 E2 57 0F 52 E3 57 3F 43 82 00 C0 A0 E3 00 30 A0 93 57 AF A0 83 01 30 43 82 14 C0 8D E5 05 20 A0 E1 3C C0 8D E2 1C 50 9D E5 18 70 8D E5 20 90 8D E5 01 A0 8A 82 36 BD 8B E3 03 70 A0 E1 0C 90 A0 E1 00 30 94 E5 00 10 D3 E5 39 00 51 E3 89 01 00 8A 38 00 51 E3 C2 01 00 3A 6C 0B 9F E5 85 50 A0 E1 F5 50 90 E1 08 00 55 E3 88 01 00 DA 2E BD CB E3 01 10 C9 E4 04 10 94 E5 01 10 41 E2 00 00 51 E3 04 10 84 E5 01 10 83 C2 00 10 84 C5 7C 02 00 DA 01 A0 5A E2 E9 FF FF 1A 7C 01 00 EA 30 10 41 E2 90 13 23 E0 24 FF FF EA 00 00 53 E3 03 A0 A0 11 00 A0 E0 03 01 30 1B E2 2B 02 00 0A 10 B0 1B E2 00 30 99 05 A9 2F 8D 12 14 20 8D 15 14 30 8D 05 18 B0 8D E5 04 90 89 02 00 B0 A0 E3 00 30 94 E5 00 20 96 E5 00 C0 D3 E5 0C 20 82 E0 01 20 D2 E5 A2 21 A0 E1 01 20 22 E2 00 00 5A E3 00 20 A0 03 01 20 02 12 00 00 52 E3 D7 02 00 1A 18 10 9D E5 00 00 51 E3 C1 FE FF 1A 14 20 9D E5 00 10 82 E5 5D 03 00 EA 00 00 53 E3 03 A0 A0 11 00 A0 E0 03 10 00 1B E3 00 10 94 15 00 B0 A0 13 23 00 00 1A 00 B0 99 E5 00 20 94 E5 0B C0 A0 E1 00 20 D2 E5 AA 0F 8D E2 02 20 80 E0 0C 21 52 E5 00 00 52 E3 55 03 00 0A 04 20 94 E5 01 20 42 E2 04 20 84 E5 00 20 94 E5 01 10 D2 E4 01 A0 5A E2 01 10 CB E4 00 20 84 E5 4C 03 00 0A 04 10 94 E5 00 00 51 E3 ED FF FF CA 08 00 A0 E1 04 10 A0 E1 0C C0 8D E5 ?? ?? ?? ?? 00 00 50 E3 0C C0 9D E5 26 02 00 1A 00 20 94 E5 E4 FF FF EA 08 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 2B 02 00 1A 00 10 94 E5 00 30 D1 E5 AA CF 8D E2 03 30 8C E0 0C 31 53 E5 00 00 53 E3 01 10 81 E2 2F 03 00 0A 04 30 94 E5 01 B0 8B E2 01 30 43 E2 0B 00 5A E1 0A 00 84 E8 1D 02 00 0A 00 00 53 E3 F0 FF FF CA E9 FF FF EA 10 B0 8B E3 C8 FE FF EA 00 00 53 E3 03 A0 A0 11 01 A0 A0 03 01 30 1B E2 27 02 00 0A 10 B0 1B E2 00 C0 99 05 00 C0 A0 13 14 B0 8D E5 18 70 8D E5 04 90 89 02 05 70 A0 E1 00 B0 A0 E3 0C 50 A0 E1 0E 00 00 EA 14 00 9D E5 00 00 50 E3 00 00 85 05 14 10 9D E5 00 00 51 E3 0B 70 87 E0 14 B0 9D 05 01 A0 4A E2 00 B0 A0 13 04 50 85 02 04 30 94 E5 00 00 53 E3 2D 02 00 DA 00 00 5A E3 FD 02 00 0A 3C 29 9F E5 00 30 92 E5 03 00 5B E1 9C FE FF 0A 00 30 94 E5 04 20 94 E5 01 C0 D3 E4 AA 0F 8D E2 00 30 84 E5 01 20 42 E2 0B 30 80 E0 04 20 84 E5 00 10 A0 E3 6C C2 43 E5 08 20 A0 E3 01 B0 8B E2 A7 0F 8D E2 ?? ?? ?? ?? A7 CF 8D E2 08 00 A0 E1 05 10 A0 E1 3C 20 8D E2 0B 30 A0 E1 00 C0 8D E5 ?? ?? ?? ?? 01 00 70 E3 85 FE FF 0A 00 00 50 E3 D3 FF FF 0A 02 00 70 E3 DB FF FF 0A D3 FF FF EA 01 20 43 E2 57 0F 52 E3 57 3F 43 82 00 30 A0 93 01 30 43 82 20 30 8D 95 20 30 8D 85 00 30 A0 E3 57 AF A0 83 3C C0 8D E2 18 30 8D E5 30 30 8D E5 14 30 8D E5 2C 30 8D E5 34 70 8D E5 38 90 8D E5 01 A0 8A 82 1E BD 8B E3 03 20 A0 E1 03 70 A0 E1 0C 90 A0 E1 00 C0 94 E5 00 10 DC E5 4E 00 51 E3 06 01 00 0A DA 00 00 8A 39 00 51 E3 EF 00 00 8A 31 00 51 E3 62 01 00 2A 2E 00 51 E3 12 02 00 0A FD 01 00 8A 2B 00 51 E3 F2 01 00 0A 2D 00 51 E3 F0 01 00 0A 14 10 9D E5 01 20 42 E2 00 00 51 E3 01 BC CB 13 01 00 52 E3 09 C0 A0 E1 07 30 A0 E1 34 70 8D E2 80 02 97 E8 A5 02 00 9A 01 20 43 E2 06 00 52 E3 1D 00 00 8A 02 00 53 E3 97 02 00 9A 00 00 A0 E3 34 B0 8D E5 03 A0 A0 E1 05 B0 A0 E1 20 00 8D E5 0C 50 A0 E1 08 00 00 EA 20 20 9D E5 08 00 A0 E1 02 10 D5 E7 04 20 A0 E1 0C 30 8D E5 01 A0 4A E2 ?? ?? ?? ?? 0C 30 9D E5 FF A0 0A E2 20 C0 9D E5 03 00 5A E3 01 C0 4C E2 20 C0 8D E5 F1 FF FF 1A 03 30 43 E2 05 C0 A0 E1 FF 30 03 E2 0B 50 A0 E1 34 B0 9D E5 05 50 63 E0 0C C0 63 E0 01 0C 1B E3 12 00 00 0A 01 0B 1B E3 6E 02 00 1A 01 10 7C E5 45 00 51 E3 65 00 51 13 01 50 45 E2 06 00 00 0A 08 00 A0 E1 04 20 A0 E1 0C C0 8D E5 ?? ?? ?? ?? 0C C0 9D E5 01 10 7C E5 01 50 45 E2 08 00 A0 E1 04 20 A0 E1 0C C0 8D E5 ?? ?? ?? ?? 0C C0 9D E5 10 20 1B E2 DC FD FF 1A 06 3C 0B E2 01 0B 53 E3 00 20 CC E5 42 02 00 0A 30 C0 9D E5 00 00 5C E3 2D 02 00 1A 00 20 A0 E3 08 00 A0 E1 3C 10 8D E2 ?? ?? ?? ?? 01 00 1B E3 00 20 A0 E1 01 30 A0 E1 01 00 00 1A 02 B0 1B E2 3C 02 00 0A 00 10 99 E5 0C 00 81 E8 04 90 89 E2 10 20 9D E5 01 20 82 E2 10 20 8D E5 C4 FD FF EA BC C6 9F E5 0A 00 A0 E3 03 A0 A0 E1 24 C0 8D E5 1C 00 8D E5 03 20 A0 E3 8B FE FF EA 03 A0 A0 E1 02 20 A0 E3 88 FE FF EA 94 26 9F E5 10 C0 A0 E3 24 20 8D E5 22 BE 8B E3 03 A0 A0 E1 1C C0 8D E5 03 20 A0 E3 80 FE FF EA 74 16 9F E5 08 20 A0 E3 1C 20 8D E5 03 A0 A0 E1 24 10 8D E5 03 20 A0 E3 79 FE FF EA 58 26 9F E5 08 C0 A0 E3 24 20 8D E5 01 B0 8B E3 03 A0 A0 E1 1C C0 8D E5 03 20 A0 E3 71 FE FF EA 02 B0 8B E3 E8 FD FF EA 03 A0 A0 E1 04 20 A0 E3 6C FE FF EA 01 B0 8B E3 18 A6 9F E5 0A C0 A0 E3 24 A0 8D E5 1C C0 8D E5 03 A0 A0 E1 03 20 A0 E3 64 FE FF EA 40 B0 8B E3 03 A0 A0 E1 00 20 A0 E3 60 FE FF EA 07 10 A0 E1 67 0F 8D E2 0C 30 8D E5 ?? ?? ?? ?? 0C 30 9D E5 40 B0 8B E3 00 70 A0 E1 03 A0 A0 E1 01 20 A0 E3 56 FE FF EA CC 05 9F E5 10 10 A0 E3 02 BC 8B E3 03 A0 A0 E1 24 00 8D E5 1C 10 8D E5 03 20 A0 E3 4E FE FF EA 10 00 1B E3 7E FD FF 1A 04 00 1B E3 00 30 99 15 00 30 99 05 B0 50 C3 11 04 90 89 12 00 50 83 05 04 90 89 02 76 FD FF EA 01 B0 8B E3 BB FD FF EA 74 05 9F E5 00 10 A0 E3 24 00 8D E5 03 A0 A0 E1 1C 10 8D E5 03 20 A0 E3 3B FE FF EA 04 B0 8B E3 B2 FD FF EA 0C 30 A0 E1 3E FE FF EA 58 00 51 E3 B3 00 00 0A AC 00 00 8A 41 00 41 E2 05 00 50 E3 A5 00 00 9A 01 0C 1B E3 09 C0 A0 E1 1C 50 8D E5 18 70 9D E5 02 50 A0 E1 20 90 9D E5 05 00 00 0A 04 10 9D E5 01 00 5C E1 65 01 00 8A 04 20 9D E5 02 00 5C E1 7A FD FF 0A 10 20 1B E2 49 01 00 0A 04 10 9D E5 14 20 9D E5 05 50 61 E0 02 50 85 E0 05 50 8C E0 4E FD FF EA 66 00 51 E3 81 00 00 0A 73 00 00 8A 59 00 51 E3 6D 00 00 0A 51 00 00 8A 54 00 51 E3 27 FF FF 1A 06 00 57 E3 25 FF FF 1A 01 70 87 E2 01 10 C9 E4 04 10 94 E5 01 10 41 E2 00 00 51 E3 01 C0 8C C2 01 50 85 E2 04 10 84 E5 00 C0 84 C5 3B 00 00 DA 01 A0 5A E2 09 FF FF 1A 18 FF FF EA 45 00 51 E3 42 00 00 0A 0A 01 00 8A 41 00 51 E3 13 FF FF 1A 01 00 52 E3 11 FF FF 1A 01 20 82 E2 EA FF FF EA 30 00 51 E3 1D 00 00 0A 17 00 00 8A 2B 00 51 E3 01 00 00 0A 2D 00 51 E3 C3 FF FF 1A 80 00 1B E3 C1 FF FF 0A 80 B0 CB E3 37 FE FF EA 00 00 52 E3 05 00 00 1A 07 0C 0B E2 07 0C 50 E3 1E BD CB 03 01 20 82 02 02 00 00 1A D7 FF FF EA 02 00 52 E3 E8 FF FF 0A 01 00 57 E3 04 00 57 13 F7 FE FF 1A 01 70 87 E2 FF 70 07 E2 CF FF FF EA F4 C3 9F E5 85 50 A0 E1 F5 50 9C E1 2E BD CB E3 22 FE FF EA 02 0B 1B E3 20 FE FF 0A 00 00 55 E3 02 BC 8B 03 08 50 85 02 01 0B 1B E3 16 BD CB 13 1A FE FF 1A 14 00 9D E5 00 00 57 E3 01 00 80 E2 01 70 47 12 01 A0 8A 12 0E BD CB E3 14 00 8D E5 13 FE FF EA 08 00 A0 E1 04 10 A0 E1 08 20 8D E5 ?? ?? ?? ?? 00 00 50 E3 08 20 9D E5 BC FF FF 0A D7 FE FF EA 61 00 51 E3 C1 FF FF 0A 65 00 51 E3 D3 FE FF 1A 05 0C 0B E2 01 0B 50 E3 04 00 00 0A 14 30 9D E5 00 00 53 E2 01 00 A0 13 2B 05 10 E0 CB FE FF 0A 02 0C 1B E3 14 00 9D 05 2C 30 9D 05 00 00 63 00 30 00 8D 05 1E BD CB E3 00 00 A0 E3 18 90 8D 05 06 BD 8B E3 14 00 8D E5 9B FF FF EA 74 00 51 E3 96 FF FF 0A 79 00 51 E3 BC FE FF 1A 07 00 57 E3 BA FE FF 1A 01 70 87 E2 93 FF FF EA 6E 00 51 E3 B1 FF FF 0A F4 FF FF 8A 69 00 51 E3 B3 FE FF 1A 00 00 57 E3 09 00 00 1A 07 0C 0B E2 07 0C 50 E3 AE FE FF 1A 1E BD CB E3 01 70 87 E2 86 FF FF EA 02 00 57 E3 A9 FE FF 1A 01 70 87 E2 82 FF FF EA 03 00 57 E3 05 00 57 13 AC FF FF 0A A3 FE FF EA 02 00 87 E0 00 00 50 E3 A0 FE FF 1A 06 BD CB E3 79 FF FF EA 0A 00 55 E3 57 FF FF DA 2E BD CB E3 CD FD FF EA 61 00 51 E3 53 FF FF 3A 66 00 51 E3 F7 FF FF 9A 78 00 51 E3 4F FF FF 1A 06 0C 0B E2 02 0C 50 E3 4C FF FF 1A 02 BC CB E3 05 BC 8B E3 10 50 A0 E3 C0 FD FF EA 10 00 1B E3 03 B0 A0 11 00 10 94 15 23 00 00 1A 00 30 99 E5 00 20 94 E5 03 B0 A0 E1 00 20 D2 E5 00 10 96 E5 02 20 81 E0 01 20 D2 E5 08 00 12 E3 57 01 00 1A 04 20 94 E5 01 20 42 E2 04 20 84 E5 00 20 94 E5 01 10 D2 E4 01 A0 5A E2 01 10 CB E4 00 20 84 E5 4E 01 00 0A 04 10 94 E5 00 00 51 E3 ED FF FF CA 08 00 A0 E1 04 10 A0 E1 0C 30 8D E5 ?? ?? ?? ?? 00 00 50 E3 0C 30 9D E5 44 01 00 1A 00 20 94 E5 E4 FF FF EA 08 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 1C 00 00 1A 00 10 94 E5 00 30 D1 E5 00 20 96 E5 03 30 82 E0 01 30 D3 E5 08 00 13 E3 01 10 81 E2 14 00 00 1A 04 30 94 E5 01 B0 8B E2 01 30 43 E2 0A 00 5B E1 0A 00 84 E8 0E 00 00 0A 00 00 53 E3 F0 FF FF CA E9 FF FF EA 0B 30 A0 E1 03 00 5C E1 0C B0 A0 E1 AD FC FF 0A 0B B0 53 E0 92 FC FF 0A 00 20 A0 E3 00 20 C3 E5 10 10 9D E5 01 10 81 E2 10 10 8D E5 04 90 89 E2 0B 50 85 E0 66 FC FF EA 08 00 A0 E1 04 10 A0 E1 08 20 8D E5 ?? ?? ?? ?? 00 00 50 E3 08 20 9D E5 7B FD FF 0A FA FE FF EA 08 00 A0 E1 04 10 A0 E1 08 20 8D E5 0C 30 8D E5 ?? ?? ?? ?? 00 00 50 E3 08 20 8D E2 0C 00 92 E8 26 FD FF 0A 91 FC FF EA 10 00 1B E3 FC 00 00 0A 03 B0 A0 E1 05 C0 A0 E1 09 00 00 EA 00 20 94 E5 05 20 82 E0 00 20 84 E5 0C C0 8D E5 ?? ?? ?? ?? 00 00 50 E3 05 B0 8B E0 0C C0 9D E5 07 01 00 1A 0A A0 65 E0 04 50 94 E5 0A 00 55 E1 08 00 A0 E1 04 10 A0 E1 F0 FF FF BA 00 20 94 E5 05 30 A0 E1 0A 20 82 E0 0C 50 A0 E1 03 30 6A E0 0A B0 8B E0 0C 00 84 E8 0B 50 85 E0 37 FC FF EA 08 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 CC FD FF 0A 00 00 5B E3 07 50 A0 E1 18 70 9D E5 CA 00 00 0A 6A FC FF EA 80 00 1B E3 0C FE FF 0A 80 B0 CB E3 E5 FE FF EA 46 00 51 E3 5C FF FF 0A 49 00 51 E3 06 FE FF 1A 51 FF FF EA 30 00 51 E3 03 FE FF 1A 01 0C 1B E3 5D FF FF 0A 14 10 9D E5 20 00 9D E5 01 10 81 E2 00 00 50 E3 80 B0 CB E3 14 10 8D E5 01 00 40 12 20 00 8D 15 01 A0 8A 12 }
	condition:
		$1
}

rule file_314_2_0 {
	meta:
		name = "_vfscanf_r"
		size = 72
		refs = "0028 __sinit 0044 __svfscanf_r"
	strings:
		$1 = { 10 40 2D E9 00 40 50 E2 0C D0 4D E2 09 00 00 0A 38 C0 94 E5 00 00 5C E3 06 00 00 1A 08 10 8D E5 04 20 8D E5 00 30 8D E5 ?? ?? ?? ?? 00 30 9D E5 04 20 9D E5 08 10 9D E5 04 00 A0 E1 0C D0 8D E2 10 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_408_2_0 {
	meta:
		name = "_vfiscanf_r"
		size = 72
		refs = "0028 __sinit 0044 __svfiscanf_r"
	strings:
		$1 = { 10 40 2D E9 00 40 50 E2 0C D0 4D E2 09 00 00 0A 38 C0 94 E5 00 00 5C E3 06 00 00 1A 08 10 8D E5 04 20 8D E5 00 30 8D E5 ?? ?? ?? ?? 00 30 9D E5 04 20 9D E5 08 10 9D E5 04 00 A0 E1 0C D0 8D E2 10 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_315_2_0 {
	meta:
		name = "__ssvfiscanf_r"
		size = 3732
		refs = "0458 memset 0474 _mbrtowc_r 0664 __sccl 0704 memcpy 0b38 iswspace 0e80 __ctype_ptr__ 0e84 __mb_cur_max 0e88 _strtoul_r 0e8c _strtol_r"
	strings:
		$1 = { F0 4F 2D E9 01 40 A0 E1 BC 10 D1 E1 02 0A 11 E3 03 90 A0 E1 64 30 94 05 57 DF 4D E2 00 50 A0 E3 00 80 A0 E1 02 1A 81 03 02 3A C3 03 4A 0F 8D E2 BC 10 C4 01 64 30 84 05 40 6E 9F E5 1C 50 8D E5 18 50 8D E5 14 50 8D E5 04 00 8D E5 02 70 A0 E1 00 30 D7 E5 00 00 53 E3 58 31 8D E5 1E 00 00 0A 00 20 96 E5 03 10 82 E0 01 B0 D1 E5 08 B0 1B E2 01 70 87 E2 1B 00 00 0A 04 30 94 E5 0B 00 00 EA 00 20 94 E5 00 10 96 E5 00 30 D2 E5 03 30 81 E0 01 30 D3 E5 08 00 13 E3 EC FF FF 0A 04 30 94 E5 01 20 82 E2 01 30 43 E2 0C 00 84 E8 01 50 85 E2 00 00 53 E3 F1 FF FF CA 08 00 A0 E1 04 10 A0 E1 74 FF FF EB 00 00 50 E3 EC FF FF 0A 00 30 D7 E5 00 00 53 E3 58 31 8D E5 E0 FF FF 1A 14 00 9D E5 57 DF 8D E2 F0 8F BD E8 25 00 53 E3 1B 00 00 0A 04 30 94 E5 00 00 53 E3 0B 00 00 DA 00 30 94 E5 01 20 57 E5 00 10 D3 E5 02 00 51 E1 F2 FF FF 1A 04 20 94 E5 01 30 83 E2 01 20 42 E2 04 20 84 E5 00 30 84 E5 01 50 85 E2 C8 FF FF EA 08 00 A0 E1 04 10 A0 E1 57 FF FF EB 00 00 50 E3 EE FF FF 0A 14 00 9D E5 00 00 50 E3 02 00 00 0A BC 30 D4 E1 40 00 13 E3 E1 FF FF 0A 00 00 E0 E3 DF FF FF EA 0B 30 A0 E1 0A 00 A0 E3 01 10 D7 E4 78 00 51 E3 01 F1 9F 97 ED 00 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 A0 A0 E1 02 20 A0 E3 04 10 94 E5 00 00 51 E3 C5 00 00 DA 40 00 1B E3 00 C0 96 05 00 10 94 05 10 30 8D 05 4D 00 00 0A 02 00 52 E3 AF 01 00 0A 03 00 52 E3 50 01 00 0A 01 00 52 E3 13 01 00 0A 00 00 53 E3 03 A0 A0 11 01 A0 A0 03 01 30 1B E2 C9 00 00 0A 10 B0 1B E2 00 C0 99 05 00 C0 A0 13 10 B0 8D E5 20 70 8D E5 04 90 89 02 05 70 A0 E1 00 B0 A0 E3 0C 50 A0 E1 0E 00 00 EA 10 00 9D E5 00 00 50 E3 00 00 85 05 10 10 9D E5 00 00 51 E3 0B 70 87 E0 10 B0 9D 05 01 A0 4A E2 00 B0 A0 13 04 50 85 02 04 30 94 E5 00 00 53 E3 A8 00 00 DA 00 00 5A E3 33 02 00 0A 68 0A 9F E5 00 30 90 E5 03 00 5B E1 46 FF FF 0A 00 30 94 E5 04 20 94 E5 01 C0 D3 E4 57 1F 8D E2 00 30 84 E5 01 20 42 E2 0B 30 81 E0 04 20 84 E5 00 10 A0 E3 34 C0 43 E5 08 20 A0 E3 01 B0 8B E2 15 0E 8D E2 ?? ?? ?? ?? 15 CE 8D E2 08 00 A0 E1 05 10 A0 E1 4A 2F 8D E2 0B 30 A0 E1 00 C0 8D E5 ?? ?? ?? ?? 01 00 70 E3 2F FF FF 0A 00 00 50 E3 D3 FF FF 0A 02 00 70 E3 DB FF FF 0A D3 FF FF EA 08 00 A0 E1 04 10 A0 E1 0C 20 8D E5 7C FE FF EB 00 00 50 E3 0C 20 9D E5 23 FF FF 1A 00 C0 96 E5 00 10 94 E5 01 50 85 E2 00 30 D1 E5 03 30 8C E0 01 30 D3 E5 08 00 13 E3 6B 00 00 0A 04 30 94 E5 01 30 43 E2 00 00 53 E3 01 10 81 C2 04 30 84 E5 00 10 84 C5 E9 FF FF DA 01 50 85 E2 F1 FF FF EA 8C 09 9F E5 10 10 A0 E3 22 BE 8B E3 03 A0 A0 E1 1C 00 8D E5 18 10 8D E5 03 20 A0 E3 93 FF FF EA 6C 19 9F E5 0A 20 A0 E3 18 20 8D E5 03 A0 A0 E1 1C 10 8D E5 03 20 A0 E3 8C FF FF EA 01 20 82 E0 01 20 D2 E5 01 00 12 E3 48 29 9F E5 0A C0 A0 E3 1C 20 8D E5 01 B0 8B 13 03 A0 A0 E1 18 C0 8D E5 03 20 A0 E3 81 FF FF EA 30 10 41 E2 90 13 23 E0 FF FE FF EA 10 B0 8B E3 FD FE FF EA 10 29 9F E5 10 C0 A0 E3 1C 20 8D E5 02 BC 8B E3 03 A0 A0 E1 18 C0 8D E5 03 20 A0 E3 74 FF FF EA F0 08 9F E5 08 10 A0 E3 01 B0 8B E3 03 A0 A0 E1 1C 00 8D E5 18 10 8D E5 03 20 A0 E3 6C FF FF EA 02 B0 8B E3 EB FE FF EA 01 B0 8B E3 C8 18 9F E5 0A 20 A0 E3 18 20 8D E5 1C 10 8D E5 03 A0 A0 E1 03 20 A0 E3 62 FF FF EA A8 C8 9F E5 08 00 A0 E3 03 A0 A0 E1 1C C0 8D E5 18 00 8D E5 03 20 A0 E3 5B FF FF EA 10 00 1B E3 94 FE FF 1A 04 00 1B E3 00 30 99 15 00 30 99 05 B0 50 C3 11 04 90 89 12 00 50 83 05 04 90 89 02 8C FE FF EA 04 B0 8B E3 D0 FE FF EA 01 B0 8B E3 CE FE FF EA 58 A8 9F E5 00 C0 A0 E3 1C A0 8D E5 18 C0 8D E5 03 A0 A0 E1 03 20 A0 E3 46 FF FF EA 40 B0 8B E3 03 A0 A0 E1 00 20 A0 E3 42 FF FF EA 07 10 A0 E1 28 00 8D E2 08 30 8D E5 ?? ?? ?? ?? 08 30 9D E5 40 B0 8B E3 00 70 A0 E1 03 A0 A0 E1 01 20 A0 E3 38 FF FF EA 10 30 9D E5 3E FF FF EA 08 00 A0 E1 04 10 A0 E1 0C 20 8D E5 08 30 8D E5 FE FD FF EB 00 00 50 E3 0C 20 9D E5 08 30 9D E5 30 FF FF 0A A3 FE FF EA 08 00 A0 E1 04 10 A0 E1 F6 FD FF EB 00 00 50 E3 51 FF FF 0A 00 00 5B E3 07 50 A0 E1 20 70 9D E5 85 01 00 0A 99 FE FF EA 10 B0 1B E2 27 00 00 1A 00 C0 99 E5 0A B0 A0 E1 10 A0 8D E5 05 30 A0 E1 07 A0 A0 E1 0C 70 A0 E1 0E 00 00 EA 00 10 94 E5 08 30 8D E5 ?? ?? ?? ?? 00 20 94 E5 00 C0 A0 E3 05 20 82 E0 04 10 84 E8 08 00 A0 E1 04 10 A0 E1 DC FD FF EB 00 00 50 E3 0B B0 65 E0 08 30 9D E5 C7 01 00 1A 05 70 87 E0 04 50 94 E5 05 00 5B E1 07 00 A0 E1 05 20 A0 E1 EB FF FF 8A 0B 20 A0 E1 00 10 94 E5 03 50 A0 E1 0A 70 A0 E1 10 A0 9D E5 ?? ?? ?? ?? 04 20 94 E5 00 30 94 E5 02 20 6B E0 0B 30 83 E0 04 20 84 E5 00 30 84 E5 B9 01 00 EA 03 B0 A0 E1 05 C0 A0 E1 09 00 00 EA 00 20 94 E5 05 20 82 E0 00 20 84 E5 0C C0 8D E5 BD FD FF EB 00 00 50 E3 05 B0 8B E0 0C C0 9D E5 A4 01 00 1A 0A A0 65 E0 04 50 94 E5 0A 00 55 E1 08 00 A0 E1 04 10 A0 E1 F0 FF FF BA 00 20 94 E5 05 30 A0 E1 0A 20 82 E0 03 30 6A E0 0C 00 84 E8 0C 50 A0 E1 0A B0 8B E0 0B 50 85 E0 18 FE FF EA 00 00 53 E3 03 A0 A0 11 00 A0 E0 03 10 00 1B E3 00 10 94 15 00 B0 A0 13 23 00 00 1A 00 B0 99 E5 00 20 94 E5 0B C0 A0 E1 00 20 D2 E5 57 3F 8D E2 02 20 83 E0 34 21 52 E5 00 00 52 E3 82 01 00 0A 04 20 94 E5 01 20 42 E2 04 20 84 E5 00 20 94 E5 01 10 D2 E4 01 A0 5A E2 01 10 CB E4 00 20 84 E5 79 01 00 0A 04 10 94 E5 00 00 51 E3 ED FF FF CA 08 00 A0 E1 04 10 A0 E1 0C C0 8D E5 8A FD FF EB 00 00 50 E3 0C C0 9D E5 5E 01 00 1A 00 20 94 E5 E4 FF FF EA 08 00 A0 E1 04 10 A0 E1 82 FD FF EB 00 00 50 E3 D3 FF FF 1A 00 10 94 E5 00 30 D1 E5 57 2F 8D E2 03 30 82 E0 34 31 53 E5 00 00 53 E3 01 10 81 E2 5D 01 00 0A 04 30 94 E5 01 B0 8B E2 01 30 43 E2 0B 00 5A E1 0A 00 84 E8 C5 FF FF 0A 00 00 53 E3 F0 FF FF CA E9 FF FF EA 01 20 43 E2 26 00 52 E3 00 00 A0 E3 00 30 A0 93 27 30 43 82 4A CF 8D E2 05 20 A0 E1 10 00 8D E5 18 50 9D E5 20 70 8D E5 24 90 8D E5 27 A0 A0 83 36 BD 8B E3 03 70 A0 E1 0C 90 A0 E1 00 30 94 E5 00 10 D3 E5 39 00 51 E3 12 00 00 8A 38 00 51 E3 38 00 00 3A 5C 05 9F E5 85 50 A0 E1 F5 50 90 E1 08 00 55 E3 11 00 00 DA 2E BD CB E3 01 10 C9 E4 04 10 94 E5 01 10 41 E2 00 00 51 E3 04 10 84 E5 01 10 83 C2 00 10 84 C5 89 00 00 DA 01 A0 5A E2 E9 FF FF 1A 05 00 00 EA 58 00 51 E3 1E 00 00 0A 17 00 00 8A 41 00 41 E2 05 00 50 E3 2C 00 00 9A 01 0C 1B E3 09 C0 A0 E1 18 50 8D E5 20 70 9D E5 02 50 A0 E1 24 90 9D E5 05 00 00 0A 04 10 9D E5 01 00 5C E1 09 01 00 8A 04 20 9D E5 02 00 5C E1 C7 FD FF 0A 10 20 1B E2 ED 00 00 0A 04 10 9D E5 10 20 9D E5 05 50 61 E0 02 50 85 E0 05 50 8C E0 9C FD FF EA 61 00 51 E3 E8 FF FF 3A 66 00 51 E3 13 00 00 9A 78 00 51 E3 E4 FF FF 1A 06 0C 0B E2 02 0C 50 E3 E1 FF FF 1A 02 BC CB E3 05 BC 8B E3 10 50 A0 E3 CC FF FF EA 30 00 51 E3 A2 00 00 0A 9C 00 00 8A 2B 00 51 E3 01 00 00 0A 2D 00 51 E3 D6 FF FF 1A 80 00 1B E3 D4 FF FF 0A 80 B0 CB E3 C1 FF FF EA 0A 00 55 E3 D0 FF FF DA 2E BD CB E3 BD FF FF EA 00 00 53 E3 03 A0 A0 11 00 A0 E0 03 01 30 1B E2 52 00 00 0A 10 B0 1B E2 00 00 99 05 56 CF 8D 12 10 C0 8D 15 10 00 8D 05 20 B0 8D E5 04 90 89 02 00 B0 A0 E3 00 30 94 E5 00 20 96 E5 00 C0 D3 E5 0C 20 82 E0 01 20 D2 E5 A2 21 A0 E1 01 20 22 E2 00 00 5A E3 00 20 A0 03 01 20 02 12 00 00 52 E3 30 00 00 0A CC 13 9F E5 00 20 91 E5 02 00 5B E1 9F FD FF 0A 04 20 94 E5 01 20 42 E2 04 20 84 E5 01 30 83 E2 57 2F 8D E2 00 30 84 E5 0B 30 82 E0 34 C0 43 E5 00 10 A0 E3 08 20 A0 E3 01 B0 8B E2 15 0E 8D E2 ?? ?? ?? ?? 15 CE 8D E2 08 00 A0 E1 10 10 9D E5 4A 2F 8D E2 0B 30 A0 E1 00 C0 8D E5 ?? ?? ?? ?? 01 00 70 E3 89 FD FF 0A 00 00 50 E3 10 10 9D 05 00 00 81 05 03 00 00 0A 02 00 70 E3 7E 00 00 0A 10 20 9D E5 00 00 92 E5 ?? ?? ?? ?? 00 00 50 E3 70 00 00 0A 01 A0 4B E2 4A 3F 8D E2 0A A0 83 E0 02 00 00 EA 01 10 DA E5 01 B0 4B E2 E7 FC FF EB 00 00 5B E3 08 00 A0 E1 04 20 A0 E1 01 A0 4A E2 F7 FF FF 1A 20 10 9D E5 00 00 51 E3 33 FD FF 1A 10 20 9D E5 00 10 82 E5 5A 00 00 EA 08 00 A0 E1 04 10 A0 E1 0C 20 8D E5 BE FC FF EB 00 00 50 E3 0C 20 9D E5 6E FF FF 0A 76 FF FF EA 10 00 1B E3 03 B0 A0 11 00 10 94 15 00 30 96 15 24 00 00 1A 00 30 99 E5 00 20 94 E5 03 B0 A0 E1 00 20 D2 E5 00 10 96 E5 02 20 81 E0 01 20 D2 E5 08 00 12 E3 5C 00 00 1A 04 20 94 E5 01 20 42 E2 04 20 84 E5 00 20 94 E5 01 10 D2 E4 01 A0 5A E2 01 10 CB E4 00 20 84 E5 53 00 00 0A 04 10 94 E5 00 00 51 E3 ED FF FF CA 08 00 A0 E1 04 10 A0 E1 08 30 8D E5 9C FC FF EB 00 00 50 E3 08 30 9D E5 49 00 00 1A 00 20 94 E5 E4 FF FF EA 08 00 A0 E1 04 10 A0 E1 94 FC FF EB 00 00 50 E3 E5 FE FF 1A 00 30 96 E5 00 10 94 E5 00 20 D1 E5 02 20 83 E0 01 20 D2 E5 08 00 12 E3 01 10 81 E2 DD FE FF 1A 04 20 94 E5 01 B0 8B E2 01 20 42 E2 0B 00 5A E1 06 00 84 E8 D7 FE FF 0A 00 00 52 E3 F1 FF FF CA E9 FF FF EA F8 C1 9F E5 85 50 A0 E1 F5 50 9C E1 2E BD CB E3 27 FF FF EA 02 0B 1B E3 25 FF FF 0A 00 00 55 E3 02 BC 8B 03 08 50 85 02 01 0B 1B E3 16 BD CB 13 1F FF FF 1A 10 10 9D E5 00 00 57 E3 01 10 81 E2 01 70 47 12 01 A0 8A 12 0E BD CB E3 10 10 8D E5 18 FF FF EA 07 50 A0 E1 20 70 9D E5 10 20 9D E5 00 00 52 E3 D5 FC FF 1A 14 30 9D E5 01 30 83 E2 14 30 8D E5 D1 FC FF EA 20 C0 9D E5 00 00 5C E3 10 00 9D 05 04 00 80 02 0B 50 85 E0 10 00 8D 05 20 B0 9D 05 01 A0 4A E2 00 B0 A0 11 04 30 94 E5 00 00 53 E3 51 FF FF CA 08 00 A0 E1 04 10 A0 E1 54 FC FF EB 00 00 50 E3 4C FF FF 0A 00 00 5B E3 FA FC FF 1A 86 FF FF EA 05 50 63 E0 00 30 A0 E3 00 30 CB E5 14 A0 9D E5 01 A0 8A E2 05 50 8B E0 04 90 89 E2 14 A0 8D E5 B4 FC FF EA 00 20 CC E5 08 00 A0 E1 0C C0 8D E5 4A 1F 8D E2 18 30 8D E2 08 04 93 E8 0F E0 A0 E1 1A FF 2F E1 20 00 1B E3 0C C0 9D E5 04 00 00 1A 04 00 1B E3 00 30 99 15 04 90 89 12 B0 00 C3 11 02 00 00 1A 00 30 99 E5 00 00 83 E5 04 90 89 E2 14 00 9D E5 01 00 80 E2 14 00 8D E5 FA FE FF EA 01 10 7C E5 08 00 A0 E1 04 20 A0 E1 0C C0 8D E5 44 FC FF EB 0C C0 9D E5 EE FE FF EA 0B 30 A0 E1 03 00 5C E1 0C B0 A0 E1 CE FC FF 0A 0B B0 53 E0 B3 FC FF 0A 00 20 A0 E3 00 20 C3 E5 14 A0 9D E5 01 A0 8A E2 04 90 89 E2 14 A0 8D E5 0B 50 85 E0 88 FC FF EA 00 00 5B E3 6B FE FF 1A A8 FC FF EA 0B 30 A0 E1 0C B0 A0 E1 EF FF FF EA 00 00 5B E3 0C 50 A0 E1 64 FE FF 1A BA FC FF EA 0A 70 A0 E1 10 A0 9D E5 0B A0 5A E0 03 50 A0 E1 B5 FC FF 0A 14 00 9D E5 01 00 80 E2 05 50 8A E0 04 90 89 E2 14 00 8D E5 73 FC FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_316_0_0 {
	meta:
		name = "envz_entry"
		size = 192
		refs = "0038 _buf_findstr"
	strings:
		$1 = { F0 40 2D E9 01 30 A0 E1 08 D0 4D E2 02 60 A0 E1 04 50 8D E2 00 00 53 E3 00 70 A0 E1 04 00 8D E5 00 10 8D E5 0D 40 A0 E1 06 00 A0 E1 05 10 A0 E1 0D 20 A0 E1 08 00 00 0A ?? ?? ?? ?? 00 00 50 E3 09 00 00 1A 00 30 9D E5 00 00 53 E3 06 00 A0 E1 05 10 A0 E1 0D 20 A0 E1 F6 FF FF 1A 03 70 A0 E1 07 00 A0 E1 08 D0 8D E2 F0 80 BD E8 04 30 9D E5 00 00 53 E3 F2 FF FF 0A 00 20 D3 E5 3D 00 52 E3 00 00 52 13 EE FF FF 1A 01 20 43 E2 04 20 8D E5 01 30 53 E5 00 00 53 E3 06 00 00 0A 02 00 57 E1 EE FF FF 0A 01 20 42 E2 04 20 8D E5 00 30 D2 E5 00 00 53 E3 F8 FF FF 1A 01 70 82 E2 E7 FF FF EA }
	condition:
		$1
}

rule file_317_0_0 {
	meta:
		name = "mbtowc"
		size = 52
	strings:
		$1 = { 00 00 51 E3 01 00 A0 01 1E FF 2F 01 00 00 52 E3 00 00 E0 03 1E FF 2F 01 00 00 50 E3 00 30 D1 15 00 30 80 15 00 00 D1 E5 00 00 50 E2 01 00 A0 13 1E FF 2F E1 }
	condition:
		$1
}

rule file_318_0_0 {
	meta:
		name = "wctob"
		size = 100
		refs = "0018 memset 0030 _wctomb_r 0060 _impure_ptr"
	strings:
		$1 = { 30 40 2D E9 0C D0 4D E2 00 40 A0 E1 00 10 A0 E3 08 20 A0 E3 0D 00 A0 E1 ?? ?? ?? ?? 3C 20 9F E5 0D 30 A0 E1 00 00 92 E5 0B 10 8D E2 04 20 A0 E1 ?? ?? ?? ?? 01 00 74 E3 00 40 A0 13 01 40 A0 03 01 00 50 E3 01 40 84 13 00 00 54 E3 0D 50 A0 E1 00 00 E0 13 0B 00 DD 05 0C D0 8D E2 30 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_319_0_0 {
	meta:
		name = "strxfrm"
		size = 116
	strings:
		$1 = { 00 00 52 E3 00 30 A0 E1 02 00 A0 01 0F 00 00 0A 00 00 D1 E5 00 00 50 E3 00 00 C3 E5 01 00 A0 13 06 00 00 1A 1E FF 2F E1 00 C0 D1 E7 00 00 5C E3 00 C0 C3 E7 01 C0 80 E2 1E FF 2F 01 0C 00 A0 E1 00 00 52 E1 00 C0 81 E0 F6 FF FF 1A 0C 10 A0 E1 00 30 D1 E5 00 00 53 E3 1E FF 2F 01 01 10 60 E0 01 00 80 E2 00 30 D1 E7 00 00 53 E3 FB FF FF 1A 1E FF 2F E1 }
	condition:
		$1
}

rule file_320_0_0 {
	meta:
		name = "envz_get"
		size = 140
		refs = "0034 _buf_findstr"
	strings:
		$1 = { 70 40 2D E9 01 30 A0 E1 08 D0 4D E2 02 60 A0 E1 04 50 8D E2 00 00 53 E3 04 00 8D E5 00 10 8D E5 0D 40 A0 E1 06 00 A0 E1 05 10 A0 E1 0D 20 A0 E1 08 00 00 0A ?? ?? ?? ?? 00 00 50 E3 08 00 00 1A 00 30 9D E5 00 00 53 E3 06 00 A0 E1 05 10 A0 E1 0D 20 A0 E1 F6 FF FF 1A 00 00 A0 E3 08 D0 8D E2 70 80 BD E8 04 20 9D E5 00 30 D2 E5 3D 00 53 E3 03 00 00 0A 00 00 53 E3 F6 FF FF 0A 00 30 9D E5 EF FF FF EA 01 00 82 E2 F3 FF FF EA }
	condition:
		$1
}

rule file_321_0_0 {
	meta:
		name = "__cxa_atexit"
		size = 24
		refs = "0014 __register_exitproc"
	strings:
		$1 = { 01 C0 A0 E1 02 30 A0 E1 00 10 A0 E1 0C 20 A0 E1 02 00 A0 E3 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_323_0_0 {
	meta:
		name = "isascii"
		size = 16
	strings:
		$1 = { 7F 00 50 E3 00 00 A0 83 01 00 A0 93 1E FF 2F E1 }
	condition:
		$1
}

rule file_324_0_0 {
	meta:
		name = "putw"
		size = 56
		refs = "0020 fwrite"
	strings:
		$1 = { 04 E0 2D E5 04 D0 4D E2 04 20 8D E2 04 00 22 E5 01 30 A0 E1 0D 00 A0 E1 04 10 A0 E3 01 20 A0 E3 ?? ?? ?? ?? 01 00 50 E3 00 00 E0 13 00 00 A0 03 04 D0 8D E2 00 80 BD E8 }
	condition:
		$1
}

rule file_325_0_0 {
	meta:
		name = "setbuf"
		size = 20
		refs = "0010 setvbuf"
	strings:
		$1 = { 00 00 51 E3 02 20 A0 03 00 20 A0 13 01 3B A0 E3 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_326_0_0 {
	meta:
		name = "wcsrchr"
		size = 88
	strings:
		$1 = { 00 20 90 E5 00 00 52 E3 00 30 A0 E1 00 00 A0 01 05 00 00 0A 03 00 A0 E1 04 20 B0 E5 00 00 52 E3 FC FF FF 1A 00 00 53 E1 08 00 00 8A 00 00 51 E3 03 00 00 1A 1E FF 2F E1 00 20 90 E5 01 00 52 E1 1E FF 2F 01 04 00 40 E2 00 00 53 E1 F9 FF FF 9A 00 00 A0 E3 1E FF 2F E1 }
	condition:
		$1
}

rule file_327_0_0 {
	meta:
		name = "_fgets_r"
		size = 268
		refs = "0054 memchr 007c memcpy 00a0 __srefill_r 00c8 __sinit"
	strings:
		$1 = { 01 00 52 E3 F0 47 2D E9 02 60 A0 E1 01 90 A0 E1 03 50 A0 E1 00 A0 A0 E1 2C 00 00 DA 00 00 50 E3 02 00 00 0A 38 30 90 E5 00 00 53 E3 25 00 00 0A 01 60 46 E2 09 70 A0 E1 13 00 00 EA 00 80 95 E5 06 00 54 E1 06 40 A0 21 0A 10 A0 E3 04 20 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 00 30 50 E2 08 10 A0 E1 04 20 A0 E1 07 00 A0 E1 1B 00 00 1A 08 10 95 E8 0C C0 64 E0 04 30 83 E0 08 10 85 E8 ?? ?? ?? ?? 04 60 56 E0 04 70 87 E0 0A 00 00 0A 04 40 95 E5 00 00 54 E3 E8 FF FF 1A 05 10 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 04 40 95 05 E2 FF FF 0A 09 00 57 E1 05 00 00 0A 00 30 A0 E3 00 30 C7 E5 09 00 A0 E1 F0 87 BD E8 ?? ?? ?? ?? D7 FF FF EA 00 90 A0 E3 09 00 A0 E1 F0 87 BD E8 01 30 83 E2 04 20 95 E5 03 40 68 E0 02 20 64 E0 00 30 85 E5 04 20 85 E5 04 20 A0 E1 ?? ?? ?? ?? 00 30 A0 E3 04 30 C7 E7 09 00 A0 E1 F0 87 BD E8 }
	condition:
		$1
}

rule file_328_0_0 {
	meta:
		name = "snprintf"
		size = 160
		refs = "006c _svfprintf_r 009c _impure_ptr"
	strings:
		$1 = { 0C 00 2D E9 F0 40 2D E9 8C 30 9F E5 00 40 51 E2 00 50 93 E5 8B 30 A0 B3 00 C0 A0 E1 6C D0 4D E2 00 30 85 B5 00 00 E0 B3 17 00 00 BA 84 E0 8D E2 0E 30 A0 E1 04 60 A0 01 01 60 44 12 80 20 9D E5 10 C0 8D E5 00 C0 8D E5 05 00 A0 E1 00 C0 E0 E3 0D 10 A0 E1 82 7F A0 E3 14 60 8D E5 BC 70 CD E1 08 60 8D E5 BE C0 CD E1 68 E0 8D E5 ?? ?? ?? ?? 01 00 70 E3 8B 30 A0 B3 00 30 85 B5 00 00 54 E3 00 30 9D 15 00 20 A0 13 00 20 C3 15 6C D0 8D E2 F0 40 BD E8 08 D0 8D E2 1E FF 2F E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_479_0_0 {
	meta:
		name = "sniprintf"
		size = 160
		refs = "006c _svfiprintf_r 009c _impure_ptr"
	strings:
		$1 = { 0C 00 2D E9 F0 40 2D E9 8C 30 9F E5 00 40 51 E2 00 50 93 E5 8B 30 A0 B3 00 C0 A0 E1 6C D0 4D E2 00 30 85 B5 00 00 E0 B3 17 00 00 BA 84 E0 8D E2 0E 30 A0 E1 04 60 A0 01 01 60 44 12 80 20 9D E5 10 C0 8D E5 00 C0 8D E5 05 00 A0 E1 00 C0 E0 E3 0D 10 A0 E1 82 7F A0 E3 14 60 8D E5 BC 70 CD E1 08 60 8D E5 BE C0 CD E1 68 E0 8D E5 ?? ?? ?? ?? 01 00 70 E3 8B 30 A0 B3 00 30 85 B5 00 00 54 E3 00 30 9D 15 00 20 A0 13 00 20 C3 15 6C D0 8D E2 F0 40 BD E8 08 D0 8D E2 1E FF 2F E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_328_1_0 {
	meta:
		name = "_snprintf_r"
		size = 152
		refs = "0068 _svfprintf_r"
	strings:
		$1 = { 04 30 2D E5 F0 40 2D E9 00 40 52 E2 8B 30 A0 B3 00 50 A0 E1 00 30 80 B5 6C D0 4D E2 01 C0 A0 E1 00 00 E0 B3 17 00 00 BA 84 E0 8D E2 0E 30 A0 E1 04 60 A0 01 01 60 44 12 80 20 9D E5 10 C0 8D E5 00 C0 8D E5 05 00 A0 E1 00 C0 E0 E3 0D 10 A0 E1 82 7F A0 E3 14 60 8D E5 BC 70 CD E1 08 60 8D E5 BE C0 CD E1 68 E0 8D E5 ?? ?? ?? ?? 01 00 70 E3 8B 30 A0 B3 00 30 85 B5 00 00 54 E3 00 30 9D 15 00 20 A0 13 00 20 C3 15 6C D0 8D E2 F0 40 BD E8 04 D0 8D E2 1E FF 2F E1 }
	condition:
		$1
}

rule file_479_1_0 {
	meta:
		name = "_sniprintf_r"
		size = 152
		refs = "0068 _svfiprintf_r"
	strings:
		$1 = { 04 30 2D E5 F0 40 2D E9 00 40 52 E2 8B 30 A0 B3 00 50 A0 E1 00 30 80 B5 6C D0 4D E2 01 C0 A0 E1 00 00 E0 B3 17 00 00 BA 84 E0 8D E2 0E 30 A0 E1 04 60 A0 01 01 60 44 12 80 20 9D E5 10 C0 8D E5 00 C0 8D E5 05 00 A0 E1 00 C0 E0 E3 0D 10 A0 E1 82 7F A0 E3 14 60 8D E5 BC 70 CD E1 08 60 8D E5 BE C0 CD E1 68 E0 8D E5 ?? ?? ?? ?? 01 00 70 E3 8B 30 A0 B3 00 30 85 B5 00 00 54 E3 00 30 9D 15 00 20 A0 13 00 20 C3 15 6C D0 8D E2 F0 40 BD E8 04 D0 8D E2 1E FF 2F E1 }
	condition:
		$1
}

rule file_329_0_0 {
	meta:
		name = "frexp"
		size = 204
		refs = "0088 __muldf3"
	strings:
		$1 = { 02 31 E0 E3 F0 49 2D E9 01 36 43 E2 02 51 C0 E3 03 00 55 E1 00 30 A0 E3 00 30 82 E5 00 B0 A0 E1 01 C0 A0 E1 00 70 A0 E1 01 80 A0 E1 00 60 A0 E1 02 40 A0 E1 01 30 A0 E1 0C 00 00 CA 03 30 95 E1 0A 00 00 0A 01 06 55 E3 FF 3F E0 A3 01 30 43 A2 09 00 00 BA 7F 64 C6 E3 0F 66 C6 E3 25 5A 83 E0 FF 65 86 E3 02 26 86 E3 00 50 84 E5 02 B0 A0 E1 0B 00 A0 E1 0C 10 A0 E1 F0 89 BD E8 43 24 A0 E3 05 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 60 A0 E1 35 30 E0 E3 7F 64 C6 E3 00 30 84 E5 0F 66 C6 E3 43 3E E0 E3 03 30 43 E2 02 51 C0 E3 FF 65 86 E3 25 5A 83 E0 02 26 86 E3 01 C0 A0 E1 01 70 A0 E1 00 50 84 E5 02 B0 A0 E1 E8 FF FF EA }
	condition:
		$1
}

rule file_330_0_0 {
	meta:
		name = "rand_r"
		size = 136
	strings:
		$1 = { 00 20 90 E5 00 00 52 E3 00 10 A0 E1 03 00 00 1A 68 00 9F E5 00 30 A0 E1 00 30 81 E5 1E FF 2F E1 5C 30 9F E5 92 03 C3 E0 C2 0F A0 E1 02 30 83 E0 43 38 60 E0 03 02 63 E0 80 01 83 E0 80 02 80 E0 80 01 63 E0 00 01 83 E0 02 20 60 E0 02 01 82 E0 03 C1 83 E0 8C C0 83 E0 00 02 60 E0 80 22 82 E0 0C 02 83 E0 00 31 83 E0 82 21 62 E0 03 31 52 E0 06 31 43 42 02 01 C3 E3 00 30 81 E5 1E FF 2F E1 67 B7 E1 2A 5F 0B 4E 83 }
	condition:
		$1
}

rule file_331_0_0 {
	meta:
		name = "mbstowcs"
		size = 60
	strings:
		$1 = { 00 00 52 E3 02 00 A0 01 1E FF 2F 01 00 30 A0 E3 03 C0 D1 E7 00 00 5C E3 03 C1 80 E7 04 00 00 0A 01 30 83 E2 03 00 52 E1 F8 FF FF 1A 02 00 A0 E1 1E FF 2F E1 03 00 A0 E1 1E FF 2F E1 }
	condition:
		$1
}

rule file_332_0_0 {
	meta:
		name = "__swbuf_r"
		size = 316
		refs = "00c0 __swsetup_r 00dc __sinit 00ec _fflush_r"
	strings:
		$1 = { 70 40 2D E9 00 40 50 E2 01 50 A0 E1 02 60 A0 E1 02 00 00 0A 38 30 94 E5 00 00 53 E3 2E 00 00 0A BC 20 D6 E1 18 10 96 E5 08 00 12 E3 02 30 A0 E1 08 10 86 E5 1F 00 00 0A 10 10 96 E5 00 00 51 E3 1C 00 00 0A 02 0A 13 E3 64 30 96 05 02 3A C3 03 64 30 86 05 00 30 96 E5 02 2A 82 03 14 00 96 E5 BC 20 C6 01 03 20 61 E0 00 00 52 E1 01 20 82 B2 22 00 00 AA 08 10 96 E5 FF 50 05 E2 01 10 41 E2 08 10 86 E5 01 50 C3 E4 14 10 96 E5 02 00 51 E1 00 30 86 E5 12 00 00 0A BC 30 D6 E1 0A 00 55 E3 00 30 A0 13 01 30 03 02 00 00 53 E3 0C 00 00 1A 05 00 A0 E1 70 80 BD E8 04 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 14 00 00 1A BC 20 D6 E1 10 10 96 E5 02 30 A0 E1 D9 FF FF EA ?? ?? ?? ?? CE FF FF EA 04 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 ED FF FF 0A 00 50 E0 E3 EB FF FF EA 04 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 F8 FF FF 1A 00 30 96 E5 01 20 A0 E3 D4 FF FF EA BC 30 D6 E1 40 30 83 E3 BC 30 C6 E1 09 30 A0 E3 00 30 84 E5 00 50 E0 E3 DC FF FF EA }
	condition:
		$1
}

rule file_333_0_0 {
	meta:
		name = "bzero"
		size = 36
	strings:
		$1 = { 00 00 51 E3 1E FF 2F 01 00 30 A0 E3 03 20 A0 E1 03 20 C0 E7 01 30 83 E2 01 00 53 E1 FB FF FF 1A 1E FF 2F E1 }
	condition:
		$1
}

rule file_334_0_0 {
	meta:
		name = "strcat"
		size = 156
		refs = "0090 strcpy"
	strings:
		$1 = { 03 00 10 E3 10 40 2D E9 00 40 A0 E1 00 00 A0 11 18 00 00 1A 00 20 94 E5 FF 34 82 E2 01 38 43 E2 01 3C 43 E2 01 30 43 E2 02 30 C3 E1 7F 34 C3 E3 7F 38 C3 E3 7F 3C C3 E3 7F 30 C3 E3 00 00 53 E3 04 00 A0 E1 0B 00 00 1A 04 20 B0 E5 FF 34 82 E2 01 38 43 E2 01 3C 43 E2 01 30 43 E2 02 30 C3 E1 7F 34 C3 E3 7F 38 C3 E3 7F 3C C3 E3 7F 30 C3 E3 00 00 53 E3 F3 FF FF 0A 00 30 D0 E5 00 00 53 E3 02 00 00 0A 01 30 F0 E5 00 00 53 E3 FC FF FF 1A ?? ?? ?? ?? 04 00 A0 E1 10 80 BD E8 }
	condition:
		$1
}

rule file_335_0_0 {
	meta:
		name = "llabs"
		size = 48
	strings:
		$1 = { 04 40 2D E5 01 40 A0 E1 C4 1F A0 E1 01 20 A0 E1 01 30 20 E0 01 40 24 E0 01 30 53 E0 02 40 C4 E0 04 10 A0 E1 03 00 A0 E1 10 00 BD E8 1E FF 2F E1 }
	condition:
		$1
}

rule file_336_0_0 {
	meta:
		name = "wmemchr"
		size = 60
	strings:
		$1 = { 00 00 52 E3 0A 00 00 0A 00 30 90 E5 01 00 53 E1 00 30 A0 13 03 00 00 1A 1E FF 2F E1 04 C0 B0 E5 01 00 5C E1 1E FF 2F 01 01 30 83 E2 03 00 52 E1 F9 FF FF 8A 00 00 A0 E3 1E FF 2F E1 }
	condition:
		$1
}

rule file_337_0_0 {
	meta:
		name = "putc_unlocked"
		size = 112
		refs = "0068 __swbuf_r 006c _impure_ptr"
	strings:
		$1 = { 08 30 91 E5 01 30 43 E2 00 00 53 E3 01 20 A0 E1 08 30 81 E5 05 00 00 BA 00 30 91 E5 00 00 C3 E5 00 30 91 E5 01 00 D3 E4 00 30 81 E5 1E FF 2F E1 18 10 91 E5 01 00 53 E1 07 00 00 BA 00 30 92 E5 00 00 C3 E5 00 30 92 E5 00 00 D3 E5 0A 00 50 E3 01 30 83 12 00 30 82 15 1E FF 2F 11 08 30 9F E5 00 10 A0 E1 00 00 93 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_337_1_0 {
	meta:
		name = "_putc_unlocked_r"
		size = 116
		refs = "0070 __swbuf_r"
	strings:
		$1 = { 08 C0 92 E5 01 C0 4C E2 00 00 5C E3 30 00 2D E9 02 30 A0 E1 08 C0 82 E5 01 40 A0 E1 06 00 00 BA 00 20 92 E5 00 10 C2 E5 00 20 93 E5 01 00 D2 E4 00 20 83 E5 30 00 BD E8 1E FF 2F E1 18 50 92 E5 05 00 5C E1 08 00 00 BA 00 10 92 E5 00 40 C1 E5 00 C0 92 E5 00 10 DC E5 0A 00 51 E3 01 C0 8C 12 00 C0 82 15 01 00 A0 11 F1 FF FF 1A 30 00 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_338_0_0 {
	meta:
		name = "_fsetpos_r"
		size = 28
		refs = "000c _fseek_r"
	strings:
		$1 = { 04 E0 2D E5 00 20 92 E5 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E2 01 00 A0 13 04 F0 9D E4 }
	condition:
		$1
}

rule file_339_0_0 {
	meta:
		name = "_erand48_r"
		size = 120
		refs = "0008 __dorand48 0010 __floatunsidf 0018 ldexp 0064 __adddf3"
	strings:
		$1 = { F0 43 2D E9 01 40 A0 E1 ?? ?? ?? ?? B0 00 D4 E1 ?? ?? ?? ?? 2F 20 E0 E3 ?? ?? ?? ?? 00 80 A0 E1 B2 00 D4 E1 01 90 A0 E1 ?? ?? ?? ?? 1F 20 E0 E3 ?? ?? ?? ?? 00 60 A0 E1 B4 00 D4 E1 01 70 A0 E1 ?? ?? ?? ?? 0F 20 E0 E3 ?? ?? ?? ?? 06 20 A0 E1 00 40 A0 E1 01 50 A0 E1 07 30 A0 E1 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? F0 83 BD E8 }
	condition:
		$1
}

rule file_340_0_0 {
	meta:
		name = "_mbrtowc_r"
		size = 88
		refs = "001c _mbtowc_r"
	strings:
		$1 = { 30 40 2D E9 00 C0 52 E2 04 D0 4D E2 00 50 A0 E1 10 40 9D E5 08 00 00 0A 00 40 8D E5 ?? ?? ?? ?? 01 00 70 E3 00 30 A0 03 00 30 84 05 8A 30 A0 03 00 30 85 05 04 D0 8D E2 30 80 BD E8 0C 10 A0 E1 0C 20 9F E5 01 30 A0 E3 00 40 8D E5 ?? ?? ?? ?? F2 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_342_0_0 {
	meta:
		name = "setvbuf"
		size = 412
		refs = "0050 _fflush_r 00f4 __sinit 0114 _free_r 0128 malloc 0194 _impure_ptr 0198 _cleanup_r"
	strings:
		$1 = { F0 45 2D E9 88 51 9F E5 00 C0 95 E5 00 00 5C E3 00 40 A0 E1 01 60 A0 E1 02 70 A0 E1 03 80 A0 E1 02 00 00 0A 38 30 9C E5 00 00 53 E3 2C 00 00 0A 02 00 57 E3 00 A0 A0 93 01 A0 A0 83 A8 AF 9A E1 00 00 E0 13 F0 85 BD 18 00 00 95 E5 04 10 A0 E1 ?? ?? ?? ?? BC 30 D4 E1 80 00 13 E3 18 A0 84 E5 04 A0 84 E5 03 38 A0 E1 26 00 00 1A 23 38 A0 E1 83 30 C3 E3 03 38 A0 E1 23 38 A0 E1 02 00 57 E3 BC 30 C4 E1 00 00 A0 03 2B 00 00 0A 00 00 56 E3 33 00 00 0A 01 00 57 E3 BC 20 D4 01 01 20 82 03 BC 20 C4 01 00 30 68 02 18 30 84 05 BC 30 D4 E1 00 20 95 E5 DC 10 9F E5 08 00 13 E2 3C 10 82 E5 10 60 84 E5 00 60 84 E5 14 80 84 E5 F0 85 BD 08 03 00 13 E3 00 80 A0 13 08 80 84 E5 00 00 A0 E3 F0 85 BD E8 0C 00 A0 E1 02 00 57 E3 00 A0 A0 93 01 A0 A0 83 ?? ?? ?? ?? A8 AF 9A E1 00 00 E0 13 F0 85 BD 18 CF FF FF EA 84 30 9F E5 10 10 94 E5 00 00 93 E5 ?? ?? ?? ?? BC 30 D4 E1 03 38 A0 E1 D1 FF FF EA 01 0B A0 E3 ?? ?? ?? ?? 00 60 50 E2 15 00 00 1A BC 30 D4 E1 00 00 E0 E3 02 30 83 E3 43 20 84 E2 01 10 A0 E3 BC 30 C4 E1 00 30 A0 E3 14 10 84 E5 08 30 84 E5 10 20 84 E5 00 20 84 E5 F0 85 BD E8 00 00 58 E3 01 8B A0 03 08 00 A0 E1 ?? ?? ?? ?? 00 60 50 E2 E9 FF FF 0A BC 30 D4 E1 80 30 83 E3 BC 30 C4 E1 C1 FF FF EA 01 8B A0 E3 F9 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_343_0_0 {
	meta:
		name = "strncat"
		size = 200
	strings:
		$1 = { 03 00 10 E3 30 00 2D E9 00 C0 A0 11 18 00 00 1A 00 C0 90 E5 FF 34 8C E2 01 38 43 E2 01 3C 43 E2 01 30 43 E2 0C 30 C3 E1 7F 34 C3 E3 7F 38 C3 E3 7F 3C C3 E3 7F 30 C3 E3 00 00 53 E3 00 C0 A0 E1 0B 00 00 1A 04 40 BC E5 FF 34 84 E2 01 38 43 E2 01 3C 43 E2 01 30 43 E2 04 30 C3 E1 7F 34 C3 E3 7F 38 C3 E3 7F 3C C3 E3 7F 30 C3 E3 00 00 53 E3 F3 FF FF 0A 00 30 DC E5 00 00 53 E3 02 00 00 0A 01 30 FC E5 00 00 53 E3 FC FF FF 1A 0C 50 A0 E1 00 30 A0 E3 07 00 00 EA 03 40 D1 E7 00 00 54 E3 03 40 CC E7 05 00 00 0A 01 20 52 E2 01 20 C5 05 01 30 83 E2 01 50 85 E2 00 00 52 E3 F5 FF FF 1A 30 00 BD E8 1E FF 2F E1 }
	condition:
		$1
}

rule file_344_0_0 {
	meta:
		name = "difftime"
		size = 16
		refs = "0008 __floatsidf"
	strings:
		$1 = { 04 E0 2D E5 00 00 61 E0 ?? ?? ?? ?? 04 F0 9D E4 }
	condition:
		$1
}

rule file_345_0_0 {
	meta:
		name = "bsearch"
		size = 116
	strings:
		$1 = { F0 4F 2D E9 00 00 52 E3 00 00 53 13 03 40 A0 E1 00 80 A0 13 01 80 A0 03 00 A0 A0 E1 01 90 A0 E1 24 B0 9D E5 02 70 A0 11 04 00 00 1A 00 50 A0 E3 05 00 A0 E1 F0 8F BD E8 FC FF FF 0A 01 80 86 E2 08 00 57 E1 F8 FF FF 9A 08 60 87 E0 A6 60 A0 E1 94 96 25 E0 0A 00 A0 E1 05 10 A0 E1 0F E0 A0 E1 1B FF 2F E1 00 00 50 E3 06 70 A0 B1 F3 FF FF BA F0 FF FF EA }
	condition:
		$1
}

rule file_346_0_0 {
	meta:
		name = "__signgam"
		size = 20
		refs = "0010 _impure_ptr"
	strings:
		$1 = { 08 30 9F E5 00 00 93 E5 A0 00 80 E2 1E FF 2F E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_347_0_0 {
	meta:
		name = "on_exit"
		size = 20
		refs = "0010 __register_exitproc"
	strings:
		$1 = { 01 20 A0 E1 00 30 A0 E3 00 10 A0 E1 01 00 A0 E3 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_348_0_0 {
	meta:
		name = "permute"
		size = 196
	strings:
		$1 = { C1 30 A0 E1 00 00 53 E3 F0 00 2D E9 0B 00 00 DA 01 50 41 E2 00 C0 A0 E3 05 51 80 E0 0C 40 A0 E1 0C 60 90 E7 00 70 95 E5 01 40 84 E2 03 00 54 E1 0C 70 80 E7 04 60 05 E4 04 C0 8C E2 F7 FF FF 1A 01 10 82 E0 C1 60 A0 E1 00 00 56 E3 0B 00 00 DA 01 10 41 E2 00 30 A0 E3 01 11 80 E0 03 C0 A0 E1 03 40 90 E7 00 50 91 E5 01 C0 8C E2 06 00 5C E1 03 50 80 E7 04 40 01 E4 04 30 83 E2 F7 FF FF 1A C2 50 A0 E1 00 00 55 E3 0B 00 00 DA 01 10 42 E2 00 30 A0 E3 01 11 80 E0 03 20 A0 E1 03 C0 90 E7 00 40 91 E5 01 20 82 E2 05 00 52 E1 03 40 80 E7 04 C0 01 E4 04 30 83 E2 F7 FF FF 1A F0 00 BD E8 1E FF 2F E1 }
	condition:
		$1
}

rule file_348_1_0 {
	meta:
		name = "getopt_internal"
		size = 1828
		refs = "0060 strcmp 00f0 memcmp 0270 strchr 02f0 fprintf 04b4 getenv 064c strlen 0708 _impure_ptr"
	strings:
		$1 = { F0 4F 2D E9 00 00 50 E3 00 00 51 13 20 D0 4D E2 01 40 A0 E1 00 50 A0 E1 02 70 A0 E1 48 A0 9D E5 4C 60 9D E5 02 00 00 1A 00 00 E0 E3 20 D0 8D E2 F0 8F BD E8 00 00 53 E3 00 00 52 03 F9 FF FF 0A 04 20 96 E5 02 00 50 E1 F6 FF FF DA 02 01 91 E7 00 00 50 E3 F3 FF FF 0A A4 16 9F E5 08 30 8D E5 ?? ?? ?? ?? 00 00 50 E3 08 30 9D E5 17 01 00 0A 04 20 96 E5 00 00 52 E3 01 20 82 02 04 20 86 05 10 20 86 05 00 00 57 E3 07 01 00 0A 00 20 D7 E5 2D 00 52 E3 00 10 A0 13 01 10 A0 03 2D 00 52 E3 2B 00 52 13 00 01 00 1A 00 00 51 E3 01 10 A0 13 02 10 A0 03 10 10 8D E5 01 70 87 E2 10 20 96 E5 01 00 52 E3 AF 00 00 0A 00 10 A0 E3 0C 10 8D E5 14 10 8D E5 00 00 53 E3 0F 00 00 0A 04 20 96 E5 1C 16 9F E5 02 01 94 E7 02 20 A0 E3 08 30 8D E5 ?? ?? ?? ?? 00 00 50 E3 08 30 9D E5 F8 00 00 0A 00 00 5A E3 04 00 00 0A 04 20 96 E5 02 21 94 E7 00 20 D2 E5 2B 00 52 E3 F1 00 00 0A 00 20 E0 E3 01 10 A0 E3 02 80 A0 E1 00 A0 A0 E3 00 00 57 E3 00 10 A0 03 01 10 01 12 00 00 51 E3 01 70 A0 01 44 00 00 1A 01 00 52 E3 38 00 00 0A 02 00 52 E3 2C 00 00 0A 01 00 78 E3 21 00 00 0A 01 20 A0 E3 10 20 86 E5 00 50 A0 E3 00 50 86 E5 10 00 9D E5 00 00 50 E3 07 00 00 1A 0C 00 9D E5 01 00 52 E3 00 10 A0 13 01 10 A0 03 00 00 50 E3 00 10 A0 03 00 00 51 E3 64 00 00 1A 01 00 52 E3 04 20 96 05 01 20 82 02 05 50 82 00 04 50 86 05 01 00 78 E3 0C 00 96 05 9C FF FF 0A 44 10 9D E5 08 32 83 E0 08 20 93 E5 00 00 51 E3 00 80 81 15 00 00 52 E3 0C 30 93 15 00 00 A0 13 00 30 82 15 0C 00 93 05 91 FF FF EA 10 20 96 E5 04 10 96 E5 01 20 82 E2 10 20 86 E5 01 11 94 E7 02 10 D1 E7 00 00 51 E3 D7 FF FF 1A D4 FF FF EA 00 20 DA E5 3D 00 52 E3 01 20 FA 05 00 00 52 E3 00 A0 A0 03 01 20 A0 E3 00 A0 86 E5 10 20 86 E5 00 50 A0 E3 CE FF FF EA 00 20 DA E5 3D 00 52 E3 01 20 FA 05 00 00 52 E3 45 00 00 0A 01 20 A0 E3 00 A0 86 E5 10 20 86 E5 00 50 A0 E3 C4 FF FF EA 04 20 96 E5 02 11 94 E7 10 20 96 E5 07 00 A0 E1 02 10 D1 E7 08 30 8D E5 ?? ?? ?? ?? 00 70 50 E2 08 30 9D E5 0F 00 00 0A 01 20 D7 E5 3A 00 52 E3 00 20 A0 13 03 00 00 1A 02 20 D7 E5 3A 00 52 E3 02 20 A0 03 01 20 A0 13 04 00 96 E5 00 10 D7 E5 10 C0 96 E5 00 A1 94 E7 0C 10 86 E5 01 10 8C E2 01 A0 8A E0 A0 FF FF EA 08 30 96 E5 00 00 53 E3 09 00 00 0A 04 30 96 E5 30 24 9F E5 03 11 94 E7 00 20 92 E5 10 30 96 E5 0C 00 92 E5 03 30 D1 E7 00 20 94 E5 18 14 9F E5 ?? ?? ?? ?? 10 20 96 E5 04 30 96 E5 01 20 82 E2 03 11 94 E7 10 20 86 E5 02 20 D1 E7 00 00 52 E3 01 30 83 02 04 30 86 05 01 30 A0 03 10 30 86 05 3F 00 A0 E3 0C 00 86 E5 3F FF FF EA 14 10 9D E5 01 20 85 E2 01 01 84 E0 0C 10 9D E5 08 30 8D E5 FD FE FF EB 14 00 9D E5 01 20 80 E2 05 50 82 E0 04 50 86 E5 08 30 9D E5 93 FF FF EA 04 20 96 E5 01 20 82 E2 02 00 55 E1 A3 00 00 CA 08 10 96 E5 00 00 51 E3 8E 00 00 1A 3A 00 A0 E3 04 20 86 E5 0C 00 86 E5 28 FF FF EA 10 00 9D E5 01 00 50 E3 34 00 00 0A 02 00 50 E3 26 00 00 0A 04 80 96 E5 08 B1 84 E0 14 80 8D E5 0B 10 A0 E1 08 20 A0 E1 00 90 A0 E3 00 00 91 E5 00 00 50 E3 1A 00 00 0A 00 C0 D0 E5 2D 00 5C E3 08 00 00 0A 00 00 5A E3 01 00 00 0A 2B 00 5C E3 04 00 00 0A 01 20 82 E2 04 20 86 E5 01 90 89 E2 04 10 81 E2 F0 FF FF EA 0C 13 9F E5 08 30 8D E5 ?? ?? ?? ?? 00 00 50 E3 0C 90 8D E5 08 30 9D E5 31 FF FF 1A 0B 00 A0 E1 09 10 A0 E1 01 20 A0 E3 01 80 88 E2 C6 FE FF EB 04 80 86 E5 00 00 E0 E3 FF FE FF EA 04 80 86 E5 00 00 E0 E3 FC FE FF EA 04 20 96 E5 02 21 94 E7 00 00 52 E3 1F FF FF 0A 00 20 D2 E5 2D 00 52 E3 1C FF FF 0A 00 00 5A E3 F2 FE FF 0A 2B 00 52 E3 F0 FE FF 1A 17 FF FF EA 04 10 96 E5 01 21 94 E7 00 00 52 E3 13 FF FF 0A 00 00 D2 E5 2D 00 50 E3 10 FF FF 0A 00 00 5A E3 01 00 00 0A 2B 00 50 E3 0C FF FF 0A 01 10 81 E2 01 00 A0 E3 00 20 86 E5 04 10 86 E5 0C 00 86 E5 DF FE FF EA 5C 02 9F E5 08 30 8D E5 ?? ?? ?? ?? 00 00 50 E3 02 00 A0 13 00 00 A0 03 10 00 8D E5 08 30 9D E5 FA FE FF EA 04 30 96 E5 01 30 83 E2 04 30 86 E5 00 00 E0 E3 D1 FE FF EA 10 20 96 E5 01 00 52 E3 0A FF FF 1A 04 20 96 E5 08 12 9F E5 02 01 94 E7 02 20 A0 E3 08 30 8D E5 ?? ?? ?? ?? 04 10 96 E5 00 00 50 E3 10 20 96 15 01 01 94 E7 02 20 A0 03 08 30 9D E5 10 20 86 05 02 00 80 E0 3D 10 A0 E3 08 30 8D E5 ?? ?? ?? ?? 00 A0 50 E2 08 30 9D E5 40 00 00 0A 04 20 96 E5 02 C1 94 E7 10 20 96 E5 0A C0 6C E0 0C C0 62 E0 18 30 8D E5 1C A0 8D E5 03 90 A0 E1 05 A0 A0 E1 00 80 E0 E3 00 B0 A0 E3 0C 50 A0 E1 00 30 99 E5 00 10 53 E2 05 20 A0 E1 09 C0 A0 E1 24 00 00 0A 04 30 96 E5 10 00 96 E5 03 31 94 E7 00 00 83 E0 08 C0 8D E5 ?? ?? ?? ?? 00 00 50 E3 08 C0 9D E5 30 00 00 0A 01 B0 8B E2 10 90 89 E2 EE FF FF EA 4C 51 9F E5 00 10 95 E5 00 20 94 E5 0C 00 91 E5 48 11 9F E5 08 30 8D E5 ?? ?? ?? ?? 01 00 78 E3 08 30 9D E5 2C 00 00 0A 00 10 95 E5 08 22 93 E7 0C 00 91 E5 28 11 9F E5 ?? ?? ?? ?? 04 20 96 E5 01 20 82 E2 5E FF FF EA 02 01 94 E7 01 10 A0 E3 01 20 A0 E1 00 00 86 E5 10 10 86 E5 01 50 A0 E1 D4 FE FF EA 01 00 78 E3 0A 50 A0 E1 18 30 8D E2 08 04 93 E8 01 10 A0 03 08 20 A0 01 BD FE FF 0A 08 C2 83 E0 04 20 9C E5 A8 1F A0 E1 B9 FE FF EA 04 20 96 E5 02 01 94 E7 ?? ?? ?? ?? 04 20 96 E5 10 C0 96 E5 02 A1 94 E7 00 C0 6C E0 00 A0 8A E0 08 30 9D E5 B9 FF FF EA 00 00 9C E5 ?? ?? ?? ?? 05 00 50 E1 08 C0 9D E5 1B 00 00 0A 01 00 78 E3 09 00 00 1A 0B 80 A0 E1 C5 FF FF EA 00 30 95 E5 00 20 D7 E5 0C 00 93 E5 78 10 9F E5 ?? ?? ?? ?? 04 20 96 E5 01 20 82 E2 31 FF FF EA 08 20 96 E5 00 00 52 E3 18 30 9D E5 17 FF FF 0A 08 22 93 E7 00 30 99 E5 0C 00 8D E8 34 30 9F E5 00 20 93 E5 04 30 96 E5 0C 00 92 E5 03 31 94 E7 38 10 9F E5 00 20 94 E5 ?? ?? ?? ?? 0B FF FF EA 0A 50 A0 E1 18 30 8D E2 08 04 93 E8 0B 80 A0 E1 CC FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_348_2_0 {
	meta:
		name = "__getopt_long_only_r"
		size = 44
	strings:
		$1 = { 04 E0 2D E5 0C D0 4D E2 10 C0 9D E5 00 C0 8D E5 01 C0 A0 E3 04 C0 8D E5 14 C0 9D E5 08 C0 8D E5 2D FE FF EB 0C D0 8D E2 00 80 BD E8 }
	condition:
		$1
}

rule file_348_3_0 {
	meta:
		name = "__getopt_long_r"
		size = 44
	strings:
		$1 = { 04 E0 2D E5 0C D0 4D E2 10 C0 9D E5 00 C0 8D E5 00 C0 A0 E3 04 C0 8D E5 14 C0 9D E5 08 C0 8D E5 22 FE FF EB 0C D0 8D E2 00 80 BD E8 }
	condition:
		$1
}

rule file_348_4_0 {
	meta:
		name = "__getopt_r"
		size = 40
	strings:
		$1 = { 04 E0 2D E5 00 C0 A0 E3 0C D0 4D E2 08 30 8D E5 0C 30 A0 E1 00 C0 8D E5 04 C0 8D E5 18 FE FF EB 0C D0 8D E2 00 80 BD E8 }
	condition:
		$1
}

rule file_348_5_0 {
	meta:
		name = "getopt_long_only"
		size = 140
	strings:
		$1 = { F0 41 2D E9 78 50 9F E5 04 C0 95 E5 20 D0 4D E2 70 40 9F E5 18 C0 8D E5 38 C0 9D E5 00 70 94 E5 04 60 94 E5 00 E0 95 E5 08 80 94 E5 00 C0 8D E5 01 C0 A0 E3 04 C0 8D E5 0C C0 8D E2 0C 70 8D E5 10 60 8D E5 14 E0 8D E5 1C 80 8D E5 08 C0 8D E5 01 FE FF EB 18 30 9D E5 04 30 85 E5 1C 30 9D E5 08 30 84 E5 0C 30 9D E5 00 30 84 E5 10 30 9D E5 04 30 84 E5 14 30 9D E5 00 30 85 E5 20 D0 8D E2 F0 81 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_348_6_0 {
	meta:
		name = "getopt_long"
		size = 140
	strings:
		$1 = { F0 41 2D E9 78 50 9F E5 04 C0 95 E5 20 D0 4D E2 70 40 9F E5 18 C0 8D E5 38 C0 9D E5 00 70 94 E5 04 60 94 E5 00 E0 95 E5 08 80 94 E5 00 C0 8D E5 00 C0 A0 E3 04 C0 8D E5 0C C0 8D E2 0C 70 8D E5 10 60 8D E5 14 E0 8D E5 1C 80 8D E5 08 C0 8D E5 DE FD FF EB 18 30 9D E5 04 30 85 E5 1C 30 9D E5 08 30 84 E5 0C 30 9D E5 00 30 84 E5 10 30 9D E5 04 30 84 E5 14 30 9D E5 00 30 85 E5 20 D0 8D E2 F0 81 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_348_7_0 {
	meta:
		name = "getopt"
		size = 140
	strings:
		$1 = { F0 45 2D E9 78 50 9F E5 78 40 9F E5 00 E0 95 E5 20 D0 4D E2 00 C0 A0 E3 00 70 94 E5 04 60 94 E5 04 80 95 E5 08 A0 94 E5 0C 30 A0 E1 14 E0 8D E5 0C E0 8D E2 0C 70 8D E5 10 60 8D E5 18 80 8D E5 1C A0 8D E5 08 E0 8D E5 00 C0 8D E5 04 C0 8D E5 BB FD FF EB 18 30 9D E5 04 30 85 E5 1C 30 9D E5 08 30 84 E5 0C 30 9D E5 00 30 84 E5 10 30 9D E5 04 30 84 E5 14 30 9D E5 00 30 85 E5 20 D0 8D E2 F0 85 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_349_0_0 {
	meta:
		name = "isdigit"
		size = 28
		refs = "0018 __ctype_ptr__"
	strings:
		$1 = { 10 30 9F E5 00 30 93 E5 00 30 83 E0 01 00 D3 E5 04 00 00 E2 1E FF 2F E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_350_0_0 {
	meta:
		name = "__malloc_update_mallinfo"
		size = 140
		refs = "0084 __malloc_av_ 0088 __malloc_current_mallinfo"
	strings:
		$1 = { 30 00 2D E9 78 40 9F E5 04 C0 A0 E1 08 30 BC E5 04 50 93 E5 03 50 C5 E3 0F 00 55 E3 00 10 A0 D3 01 10 A0 C3 01 4B 84 E2 05 20 A0 E1 0C 30 9C E5 0C 00 53 E1 06 00 00 0A 04 00 93 E5 0C 30 93 E5 03 00 C0 E3 0C 00 53 E1 00 20 82 E0 01 10 81 E2 F8 FF FF 1A 08 C0 8C E2 04 00 5C E1 F2 FF FF 1A 20 30 9F E5 00 00 93 E5 00 00 62 E0 24 50 83 E5 04 10 83 E5 1C 00 83 E5 20 20 83 E5 30 00 BD E8 1E FF 2F E1 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_350_1_0 {
	meta:
		name = "_mallinfo_r"
		size = 84
		refs = "0014 __malloc_lock 0018 __malloc_update_mallinfo 0040 __malloc_unlock 0050 __malloc_current_mallinfo"
	strings:
		$1 = { 30 40 2D E9 00 40 A0 E1 28 D0 4D E2 01 00 A0 E1 01 50 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 2C E0 9F E5 0F 00 BE E8 04 C0 A0 E1 0F 00 AC E8 0F 00 BE E8 0F 00 AC E8 03 00 9E E8 03 00 8C E8 05 00 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 28 D0 8D E2 30 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_351_0_0 {
	meta:
		name = "quorem"
		size = 480
		refs = "0030 __udivsi3 0120 __mcmp"
	strings:
		$1 = { F0 4F 2D E9 10 30 90 E5 10 60 91 E5 03 00 56 E1 00 A0 A0 E1 01 90 A0 E1 00 00 A0 C3 F0 8F BD C8 04 80 86 E2 08 11 91 E7 08 01 9A E7 01 10 81 E2 ?? ?? ?? ?? 00 70 50 E2 01 60 46 E2 08 81 89 E0 14 50 89 E2 14 40 8A E2 32 00 00 0A 00 30 A0 E3 03 10 A0 E1 03 20 A0 E1 03 00 95 E7 00 C8 A0 E1 20 E8 A0 E1 2C C8 A0 E1 9C 17 21 E0 97 0E 0E E0 03 B0 94 E7 0B 08 A0 E1 21 E8 8E E0 20 08 A0 E1 01 18 A0 E1 00 00 82 E0 21 18 A0 E1 0E 28 A0 E1 00 10 61 E0 22 28 A0 E1 2B 08 62 E0 01 28 A0 E1 41 08 80 E0 22 28 A0 E1 00 28 82 E1 03 20 84 E7 04 30 83 E2 03 20 85 E0 02 00 58 E1 2E 18 A0 E1 40 28 A0 E1 E3 FF FF 2A 05 30 86 E2 03 21 9A E7 00 00 52 E3 0F 00 00 1A 03 21 8A E0 04 30 42 E2 03 00 54 E1 0A 00 00 2A 04 20 12 E5 00 00 52 E3 03 00 00 0A 06 00 00 EA 00 20 93 E5 00 00 52 E3 03 00 00 1A 04 30 43 E2 03 00 54 E1 01 60 46 E2 F8 FF FF 3A 10 60 8A E5 09 10 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 2A 00 00 BA 00 30 A0 E3 01 70 87 E2 03 00 A0 E1 03 90 95 E7 03 C0 94 E7 09 28 A0 E1 0C 18 A0 E1 22 28 A0 E1 21 18 A0 E1 01 10 62 E0 00 00 81 E0 29 18 A0 E1 00 28 A0 E1 2C 18 61 E0 40 18 81 E0 22 28 A0 E1 01 28 82 E1 03 20 84 E7 04 30 83 E2 03 20 85 E0 02 00 58 E1 41 08 A0 E1 EB FF FF 2A 05 30 86 E2 03 21 9A E7 00 00 52 E3 0F 00 00 1A 03 21 8A E0 04 30 42 E2 03 00 54 E1 0A 00 00 2A 04 20 12 E5 00 00 52 E3 03 00 00 0A 06 00 00 EA 00 20 93 E5 00 00 52 E3 03 00 00 1A 04 30 43 E2 03 00 54 E1 01 60 46 E2 F8 FF FF 3A 10 60 8A E5 07 00 A0 E1 F0 8F BD E8 }
	condition:
		$1
}

rule file_351_1_0 {
	meta:
		name = "_dtoa_r"
		size = 5604
		refs = "0044 _Bfree 00a0 __nedf2 0138 __d2b 0188 __floatunsidf 01a8 __subdf3 01b4 __muldf3 01c0 __adddf3 01d0 __floatsidf 01fc __fixdfsi 0214 __ltdf2 0358 .LC2 0368 __mprec_bigtens 036c __mprec_tens 039c _Balloc 0438 __divdf3 058c __gtdf2 0980 __eqdf2 0a54 __pow5mult 0a68 __multiply 0a9c __i2b 0b28 __lshift 0b90 __multadd 0ba0 __mcmp 0d2c __gedf2 0f64 __mdiff 124c __hi0bits 1530 memcpy"
	strings:
		$1 = { F0 4F 2D E9 40 C0 90 E5 70 D0 4D E2 00 00 5C E3 00 40 A0 E1 03 60 A0 E1 9C 70 9D E5 01 80 A0 E1 02 90 A0 E1 09 00 00 0A 44 30 90 E5 04 30 8C E5 44 30 90 E5 01 20 A0 E3 12 33 A0 E1 0C 10 A0 E1 08 30 8C E5 ?? ?? ?? ?? 00 30 A0 E3 40 30 84 E5 00 50 58 E2 02 51 C5 B3 01 30 A0 B3 00 30 A0 A3 00 30 87 B5 00 30 87 A5 02 31 C5 E3 23 3A A0 E1 7F 24 A0 E3 0F 26 82 E2 03 3A A0 E1 05 80 A0 B1 02 00 53 E1 14 00 00 0A 08 00 A0 E1 09 10 A0 E1 00 20 A0 E3 00 30 A0 E3 08 80 8D E5 0C 90 8D E5 ?? ?? ?? ?? 00 00 50 E3 1C 00 00 1A A0 10 9D E5 98 20 9D E5 00 00 51 E3 01 30 A0 E3 94 02 9F 15 00 30 82 E5 A0 30 9D 15 8C 02 9F 05 00 00 83 15 01 00 40 12 70 D0 8D E2 F0 8F BD E8 27 3C A0 E3 98 10 9D E5 0F 30 83 E2 00 00 59 E3 00 30 81 E5 80 00 00 0A 64 02 9F E5 A0 20 9D E5 00 00 52 E3 F3 FF FF 0A 03 30 D0 E5 A0 C0 9D E5 00 00 53 E3 03 30 80 E2 08 30 80 12 00 30 8C E5 EC FF FF EA 68 30 8D E2 6C C0 8D E2 04 00 A0 E1 08 20 8D E2 06 00 92 E8 00 C0 8D E5 ?? ?? ?? ?? 25 3A A0 E1 83 3A A0 E1 A3 3A A0 E1 00 00 53 E3 00 A0 A0 E1 6E 00 00 1A 68 30 8D E2 08 08 93 E8 03 30 8B E0 43 3E 83 E2 02 30 83 E2 20 00 53 E3 20 20 43 C2 39 22 A0 C1 40 00 63 C2 20 00 63 D2 15 00 82 C1 19 00 A0 D1 43 5E 43 E2 ?? ?? ?? ?? 01 E0 A0 E3 50 E0 8D E5 03 50 45 E2 1F 06 40 E2 FF 25 A0 E3 0E 27 82 E2 00 30 A0 E3 ?? ?? ?? ?? 63 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 62 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 10 00 8D E5 14 10 8D E5 05 00 A0 E1 ?? ?? ?? ?? 5D 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 10 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 10 00 8D E5 14 10 8D E5 ?? ?? ?? ?? 00 20 A0 E3 00 70 A0 E1 00 30 A0 E3 10 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 00 50 E3 06 00 00 AA 07 00 A0 E1 ?? ?? ?? ?? 10 30 8D E2 0C 00 93 E8 ?? ?? ?? ?? 00 00 50 E3 01 70 47 12 16 00 57 E3 01 10 A0 83 4C 10 8D 85 0B 00 00 8A 18 31 9F E5 87 31 83 E0 0C 00 93 E8 08 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 00 50 E3 00 20 A0 A3 00 30 A0 B3 4C 20 8D A5 4C 30 8D B5 01 70 47 B2 01 B0 4B E2 05 50 5B E0 00 C0 A0 53 00 50 65 42 00 E0 A0 43 20 50 8D 55 28 C0 8D 55 28 50 8D 45 20 E0 8D 45 00 00 57 E3 61 02 00 BA 20 10 9D E5 00 20 A0 E3 07 10 81 E0 20 10 8D E5 48 70 8D E5 40 20 8D E5 09 00 56 E3 29 00 00 8A 05 00 56 E3 04 60 46 C2 02 30 46 E2 01 50 A0 D3 00 50 A0 C3 03 00 53 E3 03 F1 9F 97 CB 02 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FF 54 C5 E3 0F 56 C5 E3 00 00 55 E3 58 00 9F 05 7A FF FF 0A 78 FF FF EA 08 10 8D E2 03 00 91 E8 FF 24 C0 E3 0F 26 C2 E3 FF 05 82 E3 FF 5F 43 E2 00 C0 A0 E3 03 50 45 E2 03 06 80 E3 6C B0 9D E5 50 C0 8D E5 96 FF FF EA A7 87 D2 3F 61 43 6F 63 28 8A C6 3F B3 C8 60 8B 13 44 D3 3F FB 79 9F 50 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 60 A0 E3 00 20 E0 E3 01 30 A0 E3 3C 20 8D E5 44 30 8D E5 10 20 8D E5 94 60 8D E5 06 50 A0 E1 00 10 A0 E3 44 10 84 E5 04 00 A0 E1 ?? ?? ?? ?? 00 00 55 E3 24 00 8D E5 40 00 84 E5 F0 00 00 0A 00 00 57 E3 35 03 00 DA 54 30 1F E5 0F 20 07 E2 82 31 83 E0 47 52 A0 E1 06 00 93 E8 10 00 15 E3 2C 10 8D E5 30 20 8D E5 1C 02 00 1A 08 30 8D E2 0C 00 93 E8 34 20 8D E5 38 30 8D E5 02 B0 A0 E3 00 00 55 E3 0B 00 00 0A 98 80 1F E5 2C 10 8D E2 03 00 91 E8 01 00 15 E3 0C 00 98 18 01 B0 8B 12 ?? ?? ?? ?? C5 50 B0 E1 08 80 88 E2 F8 FF FF 1A 2C 00 8D E5 30 10 8D E5 34 10 8D E2 03 00 91 E8 2C 30 8D E2 0C 00 93 E8 ?? ?? ?? ?? 34 00 8D E5 38 10 8D E5 4C 20 9D E5 00 00 52 E3 A0 00 00 0A FF 25 A0 E3 00 30 A0 E3 34 10 8D E2 03 00 91 E8 03 26 82 E2 ?? ?? ?? ?? 10 C0 9D E5 00 00 50 E3 00 30 A0 E3 01 30 A0 B3 00 00 5C E3 00 30 A0 D3 01 30 03 C2 00 00 53 E3 91 00 00 0A 3C E0 9D E5 00 00 5E E3 B4 00 00 DA 01 21 A0 E3 09 27 82 E2 00 30 A0 E3 34 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 34 00 8D E5 38 10 8D E5 01 00 8B E2 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 34 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 01 21 A0 E3 00 30 A0 E3 07 27 82 E2 ?? ?? ?? ?? 01 30 47 E2 0D E5 40 E2 2C 30 8D E5 3C 90 9D E5 01 C0 A0 E1 0E B0 A0 E1 44 20 9D E5 00 00 52 E3 EA 02 00 0A A4 31 1F E5 FF 05 A0 E3 89 31 83 E0 0C 00 13 E9 02 06 80 E2 00 10 A0 E3 04 C0 8D E5 ?? ?? ?? ?? 04 C0 9D E5 0B 20 A0 E1 0C 30 A0 E1 ?? ?? ?? ?? 54 00 8D E5 58 10 8D E5 34 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 80 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 34 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 24 50 9D E5 30 30 88 E2 34 00 8D E5 38 10 8D E5 01 30 C5 E4 54 10 8D E2 03 00 91 E8 34 30 8D E2 0C 00 93 E8 ?? ?? ?? ?? 00 00 50 E3 96 01 00 CA FF 05 A0 E3 34 30 8D E2 0C 00 93 E8 03 06 80 E2 00 10 A0 E3 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 54 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 00 50 E3 18 03 00 CA 01 00 59 E3 65 00 00 DA 5C A0 8D E5 64 60 8D E5 34 B0 8D E2 00 0C 9B E8 05 60 A0 E1 34 40 8D E5 01 80 A0 E3 60 70 8D E5 54 50 8D E2 30 00 95 E8 07 00 00 EA ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 02 03 00 BA 09 00 58 E1 9B 03 00 AA 01 21 A0 E3 04 00 A0 E1 05 10 A0 E1 09 27 82 E2 00 30 A0 E3 ?? ?? ?? ?? 01 21 A0 E3 09 27 82 E2 00 30 A0 E3 00 40 A0 E1 01 50 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 01 B0 A0 E1 00 A0 A0 E1 ?? ?? ?? ?? 00 70 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 24 30 9D E5 30 70 87 E2 08 70 C3 E7 04 20 A0 E1 05 30 A0 E1 01 B0 A0 E1 00 A0 A0 E1 ?? ?? ?? ?? 00 00 50 E3 FF 05 A0 E3 0A 20 A0 E1 0B 30 A0 E1 01 80 88 E2 03 06 80 E2 00 10 A0 E3 01 60 86 E2 CE FF FF AA 06 50 A0 E1 5C A0 9D E5 34 40 9D E5 47 01 00 EA 0B 00 A0 E1 ?? ?? ?? ?? 34 30 8D E2 0C 00 93 E8 ?? ?? ?? ?? 01 21 A0 E3 00 30 A0 E3 07 27 82 E2 ?? ?? ?? ?? 10 30 9D E5 0D 55 40 E2 00 00 53 E3 01 C0 A0 E1 05 B0 A0 E1 5C 02 00 1A 01 21 A0 E3 05 27 82 E2 00 30 A0 E3 34 10 8D E2 03 00 91 E8 04 C0 8D E5 ?? ?? ?? ?? 04 C0 9D E5 05 20 A0 E1 0C 30 A0 E1 00 80 A0 E1 01 90 A0 E1 ?? ?? ?? ?? 00 00 50 E3 04 C0 9D E5 D2 01 00 CA 02 21 85 E2 0C 30 A0 E1 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 72 01 00 BA 08 90 8D E2 00 03 99 E8 68 30 9D E5 0E 00 57 E3 00 B0 A0 C3 01 B0 A0 D3 00 00 53 E3 00 B0 A0 B3 00 00 5B E3 91 00 00 0A 94 C0 9D E5 10 E0 9D E5 AC 3F A0 E1 00 00 5E E3 00 30 A0 C3 01 30 03 D2 00 00 53 E3 4C 34 1F E5 87 31 83 E0 06 00 93 E8 08 10 8D E5 0C 20 8D E5 4D 01 00 1A 02 30 A0 E1 08 00 A0 E1 01 20 A0 E1 09 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 09 60 A0 E1 00 90 A0 E1 ?? ?? ?? ?? 08 30 8D E2 0C 00 93 E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 08 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 10 20 9D E5 24 50 9D E5 30 30 89 E2 01 00 52 E3 18 00 8D E5 1C 10 8D E5 01 30 C5 E4 40 00 00 0A 01 21 A0 E3 09 27 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 20 A0 E3 00 30 A0 E3 18 00 8D E5 1C 10 8D E5 ?? ?? ?? ?? 00 00 50 E3 8E 01 00 0A 24 C0 9D E5 20 A0 8D E5 3C 40 8D E5 02 60 8C E2 01 80 A0 E3 08 B0 8D E2 00 0C 9B E8 28 70 8D E5 18 50 8D E2 30 00 95 E8 08 00 00 EA ?? ?? ?? ?? 00 20 A0 E3 00 30 A0 E3 00 40 A0 E1 01 50 A0 E1 ?? ?? ?? ?? 00 00 50 E3 01 60 86 E2 76 01 00 0A 0A 20 A0 E1 0B 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 00 90 A0 E1 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 10 C0 9D E5 01 80 88 E2 01 21 A0 E3 08 00 5C E1 30 C0 89 E2 00 40 A0 E1 01 50 A0 E1 09 27 82 E2 00 30 A0 E3 01 C0 46 E5 06 70 A0 E1 DA FF FF 1A 18 40 8D E5 1C 50 8D E5 20 A0 9D E5 28 70 9D E5 3C 40 9D E5 06 50 A0 E1 18 10 8D E2 03 00 91 E8 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 01 C0 A0 E1 00 B0 A0 E1 0C 30 A0 E1 08 10 8D E2 03 00 91 E8 0B 20 A0 E1 04 C0 8D E5 ?? ?? ?? ?? 00 00 50 E3 04 C0 9D E5 08 00 00 BA 08 10 8D E2 03 00 91 E8 0B 20 A0 E1 0C 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 41 01 00 1A 01 00 19 E3 3F 01 00 0A 24 10 9D E5 00 00 00 EA 03 50 A0 E1 01 20 55 E5 39 00 52 E3 01 30 45 E2 B4 02 00 1A 01 00 53 E1 F8 FF FF 1A 24 E0 9D E5 30 30 A0 E3 00 30 CE E5 24 30 9D E5 01 70 87 E2 31 20 A0 E3 00 20 C3 E5 2C 70 8D E5 85 00 00 EA 44 E0 9D E5 00 00 5E E3 A4 00 00 1A 40 B0 9D E5 28 50 9D E5 2C E0 8D E5 20 30 9D E5 00 00 53 E3 00 00 55 C3 08 00 00 DA 20 C0 9D E5 28 E0 9D E5 05 00 53 E1 05 30 A0 A1 0C C0 63 E0 0E E0 63 E0 20 C0 8D E5 28 E0 8D E5 05 50 63 E0 40 10 9D E5 00 00 51 E3 17 00 00 DA 44 20 9D E5 00 00 52 E3 60 02 00 0A 00 00 5B E3 0F 00 00 DA 2C 10 9D E5 0B 20 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 2C 00 8D E5 0A 20 A0 E1 2C 10 9D E5 04 00 A0 E1 ?? ?? ?? ?? 0A 10 A0 E1 00 30 A0 E1 04 00 A0 E1 04 30 8D E5 ?? ?? ?? ?? 04 30 9D E5 03 A0 A0 E1 40 30 9D E5 0B 20 53 E0 6B 02 00 1A 04 00 A0 E1 01 10 A0 E3 ?? ?? ?? ?? 48 C0 9D E5 00 00 5C E3 08 00 8D E5 04 00 00 DA 00 10 A0 E1 0C 20 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 08 00 8D E5 01 00 56 E3 DA 00 00 DA 00 B0 A0 E3 48 20 9D E5 00 00 52 E3 01 30 A0 03 D6 01 00 1A 20 E0 9D E5 0E 30 83 E0 1F 30 13 E2 1C 30 A0 03 ED 00 00 1A 20 C0 9D E5 28 E0 9D E5 03 C0 8C E0 03 E0 8E E0 20 C0 8D E5 28 E0 8D E5 03 50 85 E0 28 10 9D E5 00 00 51 E3 04 00 00 DA 0A 10 A0 E1 28 20 9D E5 04 00 A0 E1 ?? ?? ?? ?? 00 A0 A0 E1 20 20 9D E5 00 00 52 E3 03 00 00 DA 08 10 9D E5 04 00 A0 E1 ?? ?? ?? ?? 08 00 8D E5 4C 30 9D E5 00 00 53 E3 BF 01 00 1A 10 20 9D E5 00 00 52 E3 00 30 A0 C3 01 30 A0 D3 02 00 56 E3 00 30 A0 D3 00 00 53 E3 D8 00 00 0A 00 00 52 E3 70 00 00 1A 02 30 A0 E1 08 10 9D E5 05 20 A0 E3 04 00 A0 E1 ?? ?? ?? ?? 08 00 8D E5 08 10 9D E5 0A 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 65 00 00 DA 24 50 9D E5 31 30 A0 E3 01 30 C5 E4 2C B0 9D E5 01 70 87 E2 00 80 A0 E3 08 10 9D E5 04 00 A0 E1 ?? ?? ?? ?? 00 00 5B E3 AE 00 00 0A 0B 00 58 E1 00 00 58 13 1A 01 00 1A 0B 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 2C 70 8D E5 04 00 A0 E1 0A 10 A0 E1 ?? ?? ?? ?? A0 20 9D E5 00 00 52 E3 00 20 A0 E3 2C 10 9D E5 00 20 C5 E5 01 30 81 E2 98 C0 9D E5 A0 10 9D 15 00 30 8C E5 00 50 81 15 24 00 9D E5 28 FD FF EA 28 30 9D E5 00 C0 67 E2 03 30 67 E0 00 E0 A0 E3 28 30 8D E5 40 C0 8D E5 48 E0 8D E5 9B FD FF EA F0 38 1F E5 08 10 8D E2 03 00 91 E8 20 30 83 E2 0C 00 93 E8 ?? ?? ?? ?? 0F 50 05 E2 03 B0 A0 E3 34 00 8D E5 38 10 8D E5 DC FD FF EA 01 00 56 E3 F4 01 00 DA 10 20 9D E5 40 C0 9D E5 01 30 42 E2 03 00 5C E1 40 E0 9D B5 48 10 9D B5 03 30 6E B0 10 20 9D E5 03 E0 8E B0 03 10 81 B0 0C B0 63 A0 40 E0 8D B5 48 10 8D B5 00 00 52 E3 28 30 9D B5 10 C0 9D B5 28 50 9D A5 03 50 6C B0 02 30 A0 A1 00 30 A0 B3 20 E0 9D E5 28 20 9D E5 03 E0 8E E0 03 20 82 E0 04 00 A0 E1 01 10 A0 E3 20 E0 8D E5 28 20 8D E5 ?? ?? ?? ?? 2C 00 8D E5 3C FF FF EA 10 30 9D E5 00 00 53 E3 0A 00 00 1A 01 21 A0 E3 05 27 82 E2 00 30 A0 E3 08 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 58 00 00 BA 00 30 A0 E3 08 30 8D E5 2C 30 8D E5 94 C0 9D E5 2C B0 9D E5 0C 70 E0 E1 24 50 9D E5 00 80 A0 E3 99 FF FF EA 01 E0 A0 E3 44 E0 8D E5 94 10 9D E5 00 00 51 E3 53 01 00 DA 94 E0 9D E5 3C E0 8D E5 10 E0 8D E5 0E 00 A0 E1 17 00 50 E3 00 10 A0 E3 44 10 84 E5 01 20 A0 83 04 30 A0 83 08 02 00 9A 83 30 A0 E1 14 10 83 E2 00 00 51 E1 02 10 A0 E1 01 20 82 E2 F9 FF FF 9A 10 30 9D E5 44 10 84 E5 0E 00 53 E3 00 50 A0 83 01 50 05 92 73 FD FF EA 00 30 A0 E3 44 30 8D E5 94 C0 9D E5 0C C0 87 E0 01 00 8C E2 00 00 50 E3 3C C0 8D E5 10 00 8D C5 E4 FF FF CA 0E 00 50 E3 00 50 A0 83 01 50 05 92 10 00 8D E5 63 FD FF EA 00 30 A0 E3 44 30 8D E5 D5 FF FF EA 01 C0 A0 E3 44 C0 8D E5 ED FF FF EA 00 10 E0 E3 00 50 A0 E3 01 20 A0 E3 3C 10 8D E5 44 20 8D E5 10 10 8D E5 94 50 8D E5 55 FD FF EA 00 00 59 E3 22 FF FF 1A FF 34 C8 E3 0F 36 C3 E3 00 00 53 E3 1E FF FF 1A 02 31 C8 E3 23 3A A0 E1 03 3A A0 E1 00 00 53 E3 19 FF FF 0A 28 E0 9D E5 20 10 9D E5 01 E0 8E E2 01 10 81 E2 28 E0 8D E5 20 10 8D E5 01 B0 A0 E3 12 FF FF EA 07 50 A0 E1 20 A0 9D E5 28 70 9D E5 3C 40 9D E5 2C 70 8D E5 55 FF FF EA 00 E0 A0 E3 08 E0 8D E5 2C E0 8D E5 3F FF FF EA 20 30 63 E2 04 00 53 E3 C5 01 00 DA 20 10 9D E5 28 20 9D E5 04 30 43 E2 03 10 81 E0 03 20 82 E0 20 10 8D E5 28 20 8D E5 03 50 85 E0 0C FF FF EA 44 10 9D E5 00 00 51 E3 FB 00 00 0A 00 00 55 E3 04 00 00 DA 2C 10 9D E5 05 20 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 2C 00 8D E5 00 00 5B E3 2C B0 9D 05 7C 01 00 1A 24 50 9D E5 01 C0 09 E2 01 30 A0 E3 3C C0 8D E5 2C 80 9D E5 40 70 8D E5 20 60 8D E5 28 50 8D E5 03 50 A0 E1 08 10 9D E5 0A 00 A0 E1 B7 FB FF EB 30 00 80 E2 18 00 8D E5 08 10 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 08 10 9D E5 00 60 A0 E1 0B 20 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 0C 30 90 E5 00 00 53 E3 00 70 A0 E1 01 90 A0 13 2F 00 00 0A 07 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 20 E0 9D E5 0E E0 99 E1 02 00 00 1A 3C 10 9D E5 00 00 51 E3 79 01 00 0A 00 00 56 E3 3E 01 00 BA 20 C0 9D E5 0C C0 96 E1 02 00 00 1A 3C E0 9D E5 00 00 5E E3 38 01 00 0A 00 00 59 E3 63 01 00 CA 28 30 9D E5 18 20 9D E5 10 10 9D E5 01 20 C3 E4 01 00 55 E1 28 30 8D E5 59 01 00 0A 0A 10 A0 E1 04 00 A0 E1 0A 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 0B 00 58 E1 00 A0 A0 E1 }
	condition:
		$1
}

rule file_352_0_0 {
	meta:
		name = "_fdopen_r"
		size = 128
		refs = "0018 __sflags 0034 __sfp 0070 __sread 0074 __swrite 0078 __sseek 007c __sclose"
	strings:
		$1 = { 70 40 2D E9 04 D0 4D E2 01 50 A0 E1 02 10 A0 E1 0D 20 A0 E1 00 40 A0 E1 ?? ?? ?? ?? 00 60 50 E2 06 00 A0 01 01 00 00 1A 04 D0 8D E2 70 80 BD E8 04 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 F9 FF FF 0A 28 30 9F E5 20 30 80 E5 24 30 9F E5 24 30 80 E5 20 30 9F E5 28 30 80 E5 1C 30 9F E5 BC 60 C0 E1 BE 50 C0 E1 2C 30 80 E5 1C 00 80 E5 ED FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_353_0_0 {
	meta:
		name = "validate_structure"
		size = 796
		refs = "01f8 div"
	strings:
		$1 = { F0 40 2D E9 00 10 90 E5 3B 00 51 E3 08 D0 4D E2 00 40 A0 E1 04 10 90 95 A2 00 00 8A 3B 00 51 E3 08 10 94 95 90 00 00 8A 17 00 51 E3 7F 00 00 8A 10 10 94 E5 0B 00 51 E3 14 30 94 D5 6B 00 00 CA 03 00 13 E3 32 00 00 1A C4 02 9F E5 90 23 CC E0 C3 2F A0 E1 CC 22 62 E0 02 21 82 E0 02 21 82 E0 02 01 53 E1 21 00 00 0A 0C 30 94 E5 00 00 53 E3 1D C0 A0 E3 2A 00 00 CA 01 10 51 E2 90 52 9F E5 90 02 9F E5 0A 00 00 3A 01 00 51 E3 0C 20 A0 01 01 00 00 0A 0C 20 A0 E1 01 C1 90 E7 0C 30 83 E0 00 00 53 E3 4D 00 00 CA 01 10 51 E2 02 C0 A0 E1 F4 FF FF 2A 14 10 94 E5 01 20 41 E2 03 00 12 E3 14 20 84 E5 8F 00 00 1A 95 C2 C6 E0 C2 CF A0 E1 C6 C2 6C E0 0C C1 8C E0 0C C1 8C E0 0C 01 52 E1 7F 00 00 0A 1D 20 A0 E3 0B 10 A0 E3 E9 FF FF EA 76 3E 83 E2 0C 30 83 E2 93 C0 C0 E0 C3 2F A0 E1 C0 23 62 E0 02 21 82 E0 02 21 82 E0 02 02 53 E1 D4 FF FF 0A 0C 30 94 E5 00 00 53 E3 1C C0 A0 E3 D4 FF FF DA EC 01 9F E5 E4 61 9F E5 00 50 A0 E3 01 00 51 E3 0C 20 A0 01 01 21 90 17 03 00 52 E1 28 00 00 AA 01 00 51 E3 01 21 90 17 10 10 94 E5 0C 20 A0 01 01 10 81 E2 03 30 62 E0 0C 00 51 E3 0C 30 84 E5 10 10 84 E5 F0 FF FF 1A 14 10 94 E5 01 20 81 E2 03 00 12 E3 14 20 84 E5 10 50 84 E5 13 00 00 1A 96 C2 C7 E0 C2 CF A0 E1 C7 C2 6C E0 0C C1 8C E0 0C C1 8C E0 0C 01 52 E1 08 00 00 1A 76 1E 81 E2 0D 10 81 E2 96 21 CC E0 C1 2F A0 E1 CC 23 62 E0 02 21 82 E0 02 21 82 E0 02 02 51 E1 03 00 00 1A 1D C0 A0 E3 00 10 A0 E3 01 21 90 E7 D9 FF FF EA 1C C0 A0 E3 00 10 A0 E3 FA FF FF EA 0C 30 84 E5 10 10 84 E5 08 D0 8D E2 F0 80 BD E8 0D 00 A0 E1 0C 20 A0 E3 ?? ?? ?? ?? 04 20 9D E5 00 30 9D E5 14 00 94 E5 00 00 52 E3 03 30 80 E0 02 10 A0 E1 14 30 84 E5 0C 10 82 B2 01 30 43 B2 10 20 84 E5 14 30 84 B5 10 10 84 B5 83 FF FF EA 18 20 A0 E3 0D 00 A0 E1 ?? ?? ?? ?? 04 20 9D E5 00 30 9D E5 0C 10 94 E5 00 00 52 E3 03 30 81 E0 0C 30 84 E5 08 20 84 E5 01 30 43 B2 18 20 82 B2 08 20 84 B5 0C 30 84 B5 70 FF FF EA 3C 20 A0 E3 0D 00 A0 E1 ?? ?? ?? ?? 04 20 9D E5 00 30 9D E5 08 10 94 E5 00 00 52 E3 03 10 81 E0 08 10 84 E5 04 20 84 E5 01 10 41 B2 3C 20 82 B2 04 20 84 B5 08 10 84 B5 5F FF FF EA 3C 20 A0 E3 0D 00 A0 E1 ?? ?? ?? ?? 04 20 9D E5 00 30 9D E5 04 10 94 E5 00 00 52 E3 03 10 81 E0 04 10 84 E5 00 20 84 E5 01 10 41 B2 3C 20 82 B2 00 20 84 B5 04 10 84 B5 4D FF FF EA 76 1E 81 E2 0B 10 81 E2 95 21 CC E0 C1 2F A0 E1 CC 23 62 E0 02 21 82 E0 02 21 82 E0 02 02 51 E1 76 FF FF 0A 1C 20 A0 E3 0B 10 A0 E3 60 FF FF EA 1F 85 EB 51 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_353_1_0 {
	meta:
		name = "mktime"
		size = 968
		refs = "0008 __gettzinfo 0190 __tzcalc_limits 03c4 _daylight"
	strings:
		$1 = { F0 4F 2D E9 00 40 A0 E1 ?? ?? ?? ?? 00 50 A0 E1 04 00 A0 E1 32 FF FF EB 10 30 94 E5 94 13 9F E5 0C 20 94 E5 03 11 81 E0 30 10 91 E5 01 00 53 E3 01 20 42 E2 01 20 82 E0 00 B0 94 E5 08 70 94 E5 04 80 94 E5 14 10 94 D5 02 00 00 DA 14 10 94 E5 03 00 11 E3 58 00 00 0A 27 0C 81 E2 4E 3C A0 E3 10 00 80 E2 20 30 83 E2 03 00 50 E1 1C 20 84 E5 00 00 E0 83 F0 8F BD 88 46 00 51 E3 58 00 00 DA 34 A3 9F E5 46 30 A0 E3 14 00 00 EA 9A 93 C6 E0 C6 C2 6C E0 0C C1 8C E0 76 0E 83 E2 0C C1 8C E0 0C 00 80 E2 0C 01 53 E1 C0 9F A0 E1 05 00 00 1A 9A 60 CC E0 CC 93 69 E0 09 91 89 E0 09 91 89 E0 09 02 50 E1 08 00 00 1A 5B 0F A0 E3 01 30 83 E2 02 00 80 E2 01 00 53 E1 00 20 82 E0 08 00 00 0A 03 00 13 E3 C3 CF A0 E1 E7 FF FF 0A 5B 0F A0 E3 01 30 83 E2 01 00 80 E2 01 00 53 E1 00 20 82 E0 F6 FF FF 1A B4 32 9F E5 04 00 82 E2 90 63 C3 E0 C0 CF A0 E1 00 30 83 E0 43 31 6C E0 83 31 63 E0 00 30 63 E0 00 00 53 E3 18 30 84 E5 07 30 83 B2 18 30 84 B5 08 33 A0 E1 08 81 43 E0 80 32 9F E5 02 01 82 E0 87 C1 67 E0 00 01 82 E0 8C 72 87 E0 00 30 93 E5 20 A0 94 E5 07 72 88 E0 00 02 82 E0 0B B0 87 E0 80 20 82 E0 01 00 5A E3 01 A0 A0 A3 00 00 53 E3 82 B3 8B E0 07 00 00 0A 76 0E 81 E2 04 30 95 E5 0C 00 80 E2 00 00 53 E1 46 00 00 0A ?? ?? ?? ?? 00 00 50 E3 43 00 00 1A 0A 60 A0 E1 01 00 56 E3 3C 00 95 05 20 00 95 15 00 00 8B 00 00 00 8B 10 20 60 84 E5 F0 8F BD E8 F8 01 9F E5 90 31 CC E0 C1 3F A0 E1 CC 32 63 E0 03 31 83 E0 03 31 83 E0 03 01 51 E1 58 00 00 0A 01 20 82 E2 9C FF FF EA C6 FF FF 0A 45 00 51 E3 66 00 00 0A C4 A1 9F E5 45 30 A0 E3 14 00 00 EA 9A 93 C6 E0 C6 C2 6C E0 0C C1 8C E0 76 0E 83 E2 0C C1 8C E0 0C 00 80 E2 0C 01 53 E1 C0 9F A0 E1 05 00 00 1A 9A 60 CC E0 CC 93 69 E0 09 91 89 E0 09 91 89 E0 09 02 50 E1 08 00 00 1A 5B 0F A0 E3 01 30 43 E2 02 00 80 E2 01 00 53 E1 02 20 60 E0 08 00 00 0A 03 00 13 E3 C3 CF A0 E1 E7 FF FF 0A 5B 0F A0 E3 01 30 43 E2 01 00 80 E2 01 00 53 E1 02 20 60 E0 F6 FF FF 1A 03 00 11 E3 43 00 00 1A 38 01 9F E5 90 91 CC E0 C1 3F A0 E1 CC 32 63 E0 03 31 83 E0 03 31 83 E0 03 01 51 E1 32 00 00 0A 5B 3F A0 E3 02 30 83 E2 02 20 63 E0 95 FF FF EA 38 60 95 E5 3C 30 95 E5 20 20 95 E5 06 10 63 E0 06 60 62 E0 01 00 5B E1 00 10 A0 A3 01 10 A0 B3 06 00 5B E1 00 10 A0 B3 00 00 51 E3 1C 10 95 E5 AE FF FF 1A 00 00 95 E5 00 00 50 E3 01 10 63 E0 2A 00 00 0A 06 00 5B E1 00 60 A0 A3 01 60 A0 B3 01 00 5B E1 00 60 A0 B3 00 00 5A E3 A4 FF FF BA 0A A0 26 E0 01 00 5A E3 A1 FF FF 1A 02 30 63 E0 00 00 56 E3 00 20 94 E5 00 30 63 02 03 20 82 E0 00 20 84 E5 04 00 A0 E1 03 B0 8B E0 69 FE FF EB 97 FF FF EA 76 3E 81 E2 0C 30 83 E2 93 60 C0 E0 C3 CF A0 E1 C0 03 6C E0 00 01 80 E0 00 01 80 E0 00 02 53 E1 01 20 82 02 3B FF FF EA 76 3E 81 E2 0C 30 83 E2 93 C0 C0 E0 C3 CF A0 E1 C0 03 6C E0 00 01 80 E0 00 01 80 E0 00 02 53 E1 C3 FF FF 0A 5B 3F A0 E3 01 30 83 E2 02 20 63 E0 59 FF FF EA 01 00 5B E1 00 10 A0 B3 01 10 A0 A3 06 00 5B E1 01 60 A0 A1 01 60 81 B3 D2 FF FF EA ?? ?? ?? ?? 1F 85 EB 51 93 24 49 92 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_354_1_0 {
	meta:
		name = "two_way_long_needle"
		size = 872
		refs = "009c memcmp"
	strings:
		$1 = { F0 4F 2D E9 41 DE 4D E2 0C D0 4D E2 02 40 A0 E1 00 80 A0 E1 02 00 A0 E1 41 2E 8D E2 08 20 82 E2 01 A0 A0 E1 03 10 A0 E1 03 60 A0 E1 AD FF FF EB 1C 20 8D E2 00 70 A0 E1 04 20 42 E2 00 30 A0 E3 03 60 82 E7 04 30 83 E2 01 0B 53 E3 FB FF FF 1A 00 00 56 E3 00 50 E0 03 0B 00 00 0A 01 50 46 E2 05 20 A0 E1 00 30 A0 E3 03 10 D4 E7 41 0E 8D E2 01 30 83 E2 0C 00 80 E2 01 11 80 E0 03 00 56 E1 04 24 01 E5 01 20 42 E2 F6 FF FF 8A 18 14 9D E5 04 00 A0 E1 01 10 84 E0 07 20 A0 E1 ?? ?? ?? ?? 00 00 50 E3 5C 00 00 1A 18 14 9D E5 01 C0 47 E2 0A A0 66 E0 04 10 8D E5 06 60 61 E0 0C 20 88 E0 07 30 84 E0 01 10 67 E2 00 A0 8D E5 0C 20 8D E5 10 30 8D E5 14 10 8D E5 08 60 8D E5 05 B0 88 E0 00 60 A0 E1 00 30 DB E7 41 2E 8D E2 0C 20 82 E2 03 31 82 E0 04 34 13 E5 00 00 53 E3 3E 00 00 1A 07 00 56 E1 06 30 A0 21 07 30 A0 31 05 00 53 E1 10 00 00 2A 00 20 83 E0 02 10 D8 E7 03 A0 D4 E7 01 00 5A E1 02 20 88 E0 03 10 84 E0 2D 00 00 1A 06 90 A0 E1 03 00 00 EA 01 A0 F1 E5 01 60 F2 E5 06 00 5A E1 27 00 00 1A 01 30 83 E2 05 00 53 E1 F8 FF FF 3A 09 60 A0 E1 07 00 56 E1 7D 00 00 2A 0C 10 9D E5 0C 20 D4 E7 00 30 D1 E7 03 00 52 E1 0C 30 A0 E1 77 00 00 1A 07 10 80 E0 01 10 88 E0 10 20 9D E5 07 90 A0 E1 07 00 00 EA 02 70 51 E5 02 A0 52 E5 07 00 5A E1 01 20 42 E2 01 10 41 E2 01 70 43 E2 02 00 00 1A 07 30 A0 E1 03 00 56 E1 F5 FF FF 3A 09 70 A0 E1 01 60 86 E2 03 00 56 E1 56 00 00 8A 44 00 9D E9 02 00 80 E0 00 30 9D E5 00 00 53 E1 C2 FF FF 2A 00 00 A0 E3 1C D0 8D E2 01 DB 8D E2 F0 8F BD E8 14 10 9D E5 00 00 81 E0 03 00 80 E0 00 60 A0 E3 F3 FF FF EA 00 00 56 E3 03 00 00 0A 04 10 9D E5 01 00 53 E1 08 30 9D 35 00 60 A0 33 03 00 80 E0 EB FF FF EA 06 30 67 E0 07 00 53 E1 07 30 A0 31 01 C0 47 E2 01 30 83 E2 0C 10 88 E0 01 20 67 E2 0A 60 66 E0 08 30 8D E5 18 34 8D E5 04 10 8D E5 0C 20 8D E5 00 60 8D E5 00 00 A0 E3 05 B0 88 E0 07 60 84 E0 04 90 A0 E1 00 30 DB E7 41 4E 8D E2 0C 40 84 E2 03 31 84 E0 04 34 13 E5 00 00 53 E3 2D 00 00 1A 05 00 57 E1 11 00 00 2A 07 10 80 E0 01 30 D8 E7 00 20 D6 E5 03 00 52 E1 01 10 88 E0 06 20 A0 01 07 30 A0 01 00 A0 A0 01 04 00 00 0A 2C 00 00 EA 01 40 F2 E5 01 00 F1 E5 00 00 54 E1 1A 00 00 1A 01 30 83 E2 05 00 53 E1 F8 FF FF 3A 0A 00 A0 E1 01 00 7C E3 0C 30 A0 E1 11 00 00 0A 04 40 9D E5 0C 10 D9 E7 00 20 D4 E7 02 00 51 E1 17 00 00 1A 07 10 80 E0 01 10 88 E0 06 20 A0 E1 07 A0 A0 E1 05 00 00 EA 02 70 52 E5 02 40 51 E5 04 00 57 E1 01 20 42 E2 01 10 41 E2 0B 00 00 1A 01 30 53 E2 F7 FF FF 2A 00 00 88 E0 AC FF FF EA 0A 00 A0 E1 0C 20 9D E5 00 00 82 E0 03 00 80 E0 00 10 9D E5 01 00 50 E1 C6 FF FF 9A A3 FF FF EA 0A 70 A0 E1 08 20 9D E5 02 00 80 E0 F7 FF FF EA 07 30 A0 E1 95 FF FF EA 07 30 A0 E1 F0 FF FF EA }
	condition:
		$1
}

rule file_354_2_0 {
	meta:
		name = "memmem"
		size = 744
		refs = "0040 memchr 00a4 memcmp"
	strings:
		$1 = { F0 4F 2D E9 00 50 53 E2 00 40 A0 E1 18 D0 4D E2 01 60 A0 E1 02 70 A0 E1 00 00 A0 01 01 00 00 1A 18 D0 8D E2 F0 8F BD E8 01 00 55 E1 0F 00 00 8A 1F 00 55 E3 0F 00 00 8A 00 10 D2 E5 06 20 A0 E1 ?? ?? ?? ?? 01 00 55 E3 00 00 50 13 00 80 A0 E1 00 A0 A0 13 01 A0 A0 03 00 00 A0 01 EF FF FF 0A 04 40 68 E0 06 60 84 E0 06 00 55 E1 03 00 00 9A 00 00 A0 E3 E9 FF FF EA 06 FF FF EB E7 FF FF EA 05 10 A0 E1 14 20 8D E2 07 00 A0 E1 BB FE FF EB 14 10 9D E5 00 40 A0 E1 01 10 87 E0 07 00 A0 E1 04 20 A0 E1 ?? ?? ?? ?? 00 00 50 E3 3F 00 00 0A 05 30 64 E0 04 00 53 E1 04 30 A0 31 01 30 83 E2 04 30 8D E5 14 30 8D E5 01 30 64 E2 06 60 65 E0 08 30 8D E5 00 60 8D E5 04 90 87 E0 01 60 44 E2 04 00 55 E1 10 00 00 9A 04 30 8A E0 03 20 D8 E7 00 10 D9 E5 02 00 51 E1 09 20 A0 01 03 10 88 E0 04 30 A0 11 04 30 A0 01 04 00 00 0A 23 00 00 EA 01 C0 F2 E5 01 00 F1 E5 00 00 5C E1 1F 00 00 1A 01 30 83 E2 03 00 55 E1 F8 FF FF 8A 01 00 76 E3 06 30 A0 E1 66 00 00 0A 0A B0 88 E0 06 10 D7 E7 06 20 DB E7 02 00 51 E1 0D 00 00 1A 04 10 8A E0 01 10 88 E0 09 20 A0 E1 05 00 00 EA 02 C0 52 E5 02 00 51 E5 00 00 5C E1 01 20 42 E2 01 10 41 E2 03 00 00 1A 01 30 53 E2 F7 FF FF 2A 0B 00 A0 E1 A6 FF FF EA 04 30 9D E5 03 A0 8A E0 00 20 9D E5 0A 00 52 E1 D1 FF FF 2A 00 00 A0 E3 9F FF FF EA 08 10 9D E5 0A A0 81 E0 03 A0 8A E0 F6 FF FF EA 14 B0 9D E5 01 C0 44 E2 05 10 6B E0 00 10 8D E5 0C 20 88 E0 04 30 87 E0 01 10 64 E2 06 60 65 E0 0C 00 8D E9 10 10 8D E5 0C 60 8D E5 00 60 A0 E1 04 00 56 E1 06 30 A0 21 04 30 A0 31 03 00 55 E1 10 00 00 9A 00 20 83 E0 02 10 D8 E7 03 A0 D7 E7 01 00 5A E1 02 20 88 E0 03 10 87 E0 29 00 00 1A 06 90 A0 E1 03 00 00 EA 01 A0 F1 E5 01 60 F2 E5 06 00 5A E1 23 00 00 1A 01 30 83 E2 03 00 55 E1 F8 FF FF 8A 09 60 A0 E1 06 00 54 E1 22 00 00 9A 04 10 9D E5 0C 20 D7 E7 00 30 D1 E7 03 00 52 E1 0C 30 A0 E1 1C 00 00 1A 04 10 80 E0 01 10 88 E0 08 20 9D E5 07 00 00 EA 02 A0 51 E5 02 90 52 E5 0A 00 59 E1 01 20 42 E2 01 10 41 E2 01 A0 43 E2 02 00 00 1A 0A 30 A0 E1 03 00 56 E1 F5 FF FF 3A 01 60 86 E2 03 00 56 E1 10 00 00 8A 00 60 9D E5 0B 00 80 E0 0C 20 9D E5 00 00 52 E1 CB FF FF 2A 00 00 A0 E3 59 FF FF EA 10 20 9D E5 00 00 82 E0 03 00 80 E0 00 60 A0 E3 F5 FF FF EA 04 30 A0 E1 EE FF FF EA 0A B0 88 E0 0B 00 A0 E1 4F FF FF EA 00 00 88 E0 4D FF FF EA }
	condition:
		$1
}

rule file_358_0_0 {
	meta:
		name = "tfind"
		size = 88
	strings:
		$1 = { 70 40 2D E9 00 40 51 E2 00 50 A0 E1 02 60 A0 E1 05 00 00 1A 00 00 A0 E3 70 80 BD E8 00 40 94 B5 00 40 94 A5 04 40 84 B2 08 40 84 A2 00 30 94 E5 00 00 53 E3 05 00 A0 E1 F5 FF FF 0A 00 10 93 E5 0F E0 A0 E1 16 FF 2F E1 00 00 50 E3 F2 FF FF 1A 00 00 94 E5 70 80 BD E8 }
	condition:
		$1
}

rule file_360_0_0 {
	meta:
		name = "_viscanf_r"
		size = 16
		refs = "000c __svfiscanf_r"
	strings:
		$1 = { 02 30 A0 E1 01 20 A0 E1 04 10 90 E5 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_417_0_0 {
	meta:
		name = "_vscanf_r"
		size = 16
		refs = "000c __svfscanf_r"
	strings:
		$1 = { 02 30 A0 E1 01 20 A0 E1 04 10 90 E5 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_360_1_0 {
	meta:
		name = "viscanf"
		size = 32
		refs = "0018 __svfiscanf_r 001c _impure_ptr"
	strings:
		$1 = { 14 30 9F E5 00 C0 93 E5 01 30 A0 E1 04 10 9C E5 00 20 A0 E1 0C 00 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_417_1_0 {
	meta:
		name = "vscanf"
		size = 32
		refs = "0018 __svfscanf_r 001c _impure_ptr"
	strings:
		$1 = { 14 30 9F E5 00 C0 93 E5 01 30 A0 E1 04 10 9C E5 00 20 A0 E1 0C 00 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_362_0_0 {
	meta:
		name = "_fwide_r"
		size = 128
		refs = "0078 __sinit"
	strings:
		$1 = { 00 30 50 E2 30 40 2D E9 01 40 A0 E1 02 50 A0 E1 02 00 00 0A 38 30 93 E5 00 00 53 E3 15 00 00 0A 00 00 55 E3 BC 00 D4 01 0B 00 00 0A BC 00 D4 E1 02 0A 10 E3 0A 00 00 1A 00 00 55 E3 64 30 94 C5 64 30 94 D5 02 0A 80 E3 02 3A 83 C3 02 3A C3 D3 BC 00 C4 E1 64 30 84 C5 64 30 84 D5 02 0A 10 E2 30 80 BD 08 64 30 94 E5 02 0A 13 E3 01 00 A0 13 00 00 E0 03 30 80 BD E8 ?? ?? ?? ?? E7 FF FF EA }
	condition:
		$1
}

rule file_363_0_0 {
	meta:
		name = "trecurse"
		size = 64
		refs = "003c free"
	strings:
		$1 = { 30 40 2D E9 00 40 A0 E1 04 00 90 E5 00 00 50 E3 01 50 A0 E1 F9 FF FF 1B 08 00 94 E5 00 00 50 E3 05 10 A0 11 F5 FF FF 1B 00 00 94 E5 0F E0 A0 E1 15 FF 2F E1 04 00 A0 E1 30 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_364_0_0 {
	meta:
		name = "fetch_bitmap"
		size = 132
		refs = "002c malloc 0064 __get_page 0078 free"
	strings:
		$1 = { 30 40 2D E9 B8 31 90 E5 01 00 53 E1 0C D0 4D E2 00 40 A0 E1 02 00 00 CA 00 00 A0 E3 0C D0 8D E2 30 80 BD E8 0C 00 90 E5 08 10 8D E5 ?? ?? ?? ?? 08 10 9D E5 00 00 50 E3 4E 50 81 E2 05 01 84 E7 F4 FF FF 0A 81 10 84 E0 B4 2C D1 E1 01 C0 A0 E3 00 10 A0 E1 00 30 A0 E3 04 00 A0 E1 04 C0 8D E5 00 C0 8D E5 ?? ?? ?? ?? 00 00 50 E3 05 01 94 07 E9 FF FF 0A 05 01 94 E7 ?? ?? ?? ?? 00 00 A0 E3 E5 FF FF EA }
	condition:
		$1
}

rule file_364_1_0 {
	meta:
		name = "putpair"
		size = 152
		refs = "0034 memmove"
	strings:
		$1 = { F0 41 2D E9 B0 70 D0 E1 87 30 80 E0 B4 60 D3 E1 04 30 91 E5 06 60 63 E0 06 68 A0 E1 26 68 A0 E1 00 40 A0 E1 02 80 A0 E1 00 10 91 E5 03 20 A0 E1 06 00 80 E0 ?? ?? ?? ?? 01 70 87 E2 04 20 98 E5 07 78 A0 E1 06 50 62 E0 27 78 A0 E1 87 30 A0 E1 05 58 A0 E1 01 70 87 E2 25 58 A0 E1 07 78 A0 E1 27 78 A0 E1 B3 60 84 E1 00 10 98 E5 05 00 84 E0 ?? ?? ?? ?? 03 10 87 E2 87 30 84 E0 81 10 45 E0 87 00 A0 E1 B0 50 84 E1 B0 70 C4 E1 B2 10 C3 E1 B4 50 C3 E1 F0 81 BD E8 }
	condition:
		$1
}

rule file_364_2_0 {
	meta:
		name = "__ibitmap"
		size = 152
		refs = "0018 malloc 004c memset"
	strings:
		$1 = { F0 47 2D E9 00 40 A0 E1 0C 00 90 E5 01 90 A0 E1 02 50 A0 E1 03 80 A0 E1 ?? ?? ?? ?? 00 60 50 E2 01 00 A0 03 F0 87 BD 08 01 A0 45 E2 B8 31 94 E5 CA A2 A0 E1 01 70 8A E2 07 71 A0 E1 01 30 83 E2 B8 31 84 E5 07 20 A0 E1 00 10 A0 E3 ?? ?? ?? ?? 0C 20 94 E5 07 00 86 E0 02 20 67 E0 FF 10 A0 E3 ?? ?? ?? ?? 1F 50 05 E2 00 30 E0 E3 13 55 A0 E1 0A 51 86 E7 00 30 96 E5 4E 20 88 E2 01 30 83 E3 88 80 84 E0 02 61 84 E7 B4 9C C8 E1 00 30 86 E5 00 00 A0 E3 F0 87 BD E8 }
	condition:
		$1
}

rule file_364_3_0 {
	meta:
		name = "__put_page"
		size = 548
		refs = "00d0 __log2 0104 lseek 0194 sigprocmask 019c mkstemp 01ac unlink 01f0 write 020c __errno"
	strings:
		$1 = { F0 4F 2D E9 14 51 90 E5 02 60 A0 E1 0C 20 90 E5 14 D0 4D E2 01 00 75 E3 00 40 A0 E1 01 70 A0 E1 03 80 A0 E1 38 A0 9D E5 00 20 8D E5 53 00 00 0A 4D 3E A0 E3 08 20 94 E5 02 30 83 E2 03 00 52 E1 19 00 00 0A 00 00 5A E3 3A 00 00 0A 0C E0 94 E5 4E E1 A0 E1 00 00 5E E3 13 00 00 DA 0C C0 8D E2 03 B0 8C E2 02 90 8C E2 01 A0 8C E2 07 30 A0 E1 00 20 A0 E3 00 10 93 E5 0C 10 8D E5 00 10 D9 E5 00 00 DB E5 01 10 C3 E5 00 10 DA E5 02 10 C3 E5 01 20 82 E2 00 10 DC E5 0E 00 52 E1 00 00 C3 E5 03 10 C3 E5 04 30 83 E2 F1 FF FF 1A 00 00 58 E3 19 00 00 1A A6 35 A0 E1 01 A0 A0 E3 1A A3 A0 E1 01 00 5A E3 3C 90 94 E5 03 00 00 0A 0A 00 A0 E1 ?? ?? ?? ?? 10 00 80 E2 00 81 94 E7 01 10 49 E2 0A 10 81 E0 86 6A A0 E1 08 10 81 E0 A6 6A A0 E1 06 10 81 E0 10 30 94 E5 05 00 A0 E1 11 13 A0 E1 00 20 A0 E3 ?? ?? ?? ?? 01 00 70 E3 34 00 00 1A 00 00 E0 E3 14 D0 8D E2 F0 8F BD E8 00 00 56 E3 3C 80 94 E5 06 10 A0 01 28 00 00 1A 08 60 86 E0 01 10 86 E0 EE FF FF EA B0 E0 D7 E1 12 00 8D E2 02 E0 8E E2 01 C0 80 E2 07 30 A0 E1 B0 20 D3 E1 B2 21 CD E1 01 A0 8A E2 00 10 DC E5 00 20 D0 E5 0A 00 5E E1 00 10 C3 E5 01 20 C3 E5 02 30 83 E2 F5 FF FF AA 00 00 58 E3 CD FF FF 0A E6 FF FF EA 14 10 8D E2 0C 50 21 E5 04 50 8D E2 05 20 A0 E1 01 00 A0 E3 ?? ?? ?? ?? 80 00 9F E5 ?? ?? ?? ?? 01 00 70 E3 14 01 84 E5 70 00 9F 15 ?? ?? ?? ?? 00 00 A0 E3 05 10 A0 E1 00 20 A0 E1 ?? ?? ?? ?? 14 51 94 E5 01 00 75 E3 98 FF FF 1A CF FF FF EA 01 00 86 E2 ?? ?? ?? ?? 10 00 80 E2 00 11 94 E7 D1 FF FF EA 05 00 A0 E1 07 10 A0 E1 00 20 9D E5 ?? ?? ?? ?? 01 00 70 E3 C4 FF FF 0A 00 30 9D E5 00 00 53 E1 00 00 A0 03 C1 FF FF 0A ?? ?? ?? ?? 4F 30 A0 E3 00 30 80 E5 00 00 E0 E3 BC FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_364_4_0 {
	meta:
		name = "__get_page"
		size = 580
		refs = "007c lseek 009c read 0170 __log2 0230 __errno"
	strings:
		$1 = { F0 47 2D E9 0C D0 4D E2 00 50 A0 E1 14 61 90 E5 2C 00 9D E5 01 00 76 E3 00 00 50 13 01 40 A0 E1 30 80 9D E5 0C 70 95 E5 07 00 00 1A 06 30 47 E2 B4 70 C1 E1 B2 30 C1 E1 00 10 A0 E3 B0 10 C4 E1 00 00 A0 E3 0C D0 8D E2 F0 87 BD E8 00 00 53 E3 3E 00 00 0A 00 00 52 E3 3C A0 95 E5 02 10 A0 01 4D 00 00 1A 0A 20 82 E0 01 10 82 E0 10 30 95 E5 06 00 A0 E1 11 13 A0 E1 00 20 A0 E3 ?? ?? ?? ?? 01 00 70 E3 01 00 00 1A 00 00 E0 E3 EC FF FF EA 06 00 A0 E1 04 10 A0 E1 07 20 A0 E1 ?? ?? ?? ?? 01 00 70 E3 F7 FF FF 0A 00 00 50 E3 B0 00 C4 01 01 00 00 0A 00 00 57 E1 5C 00 00 1A 00 00 58 E3 02 00 00 1A B0 30 D4 E1 00 00 53 E3 50 00 00 0A 4D 3E A0 E3 08 20 95 E5 02 30 83 E2 03 00 52 E1 18 00 00 0A 00 00 58 E3 32 00 00 0A 0C C0 95 E5 4C C1 A0 E1 00 00 5C E3 12 00 00 DA 04 20 8D E2 03 70 82 E2 02 60 82 E2 01 50 82 E2 00 30 A0 E3 00 10 94 E5 04 10 8D E5 00 10 D6 E5 00 00 D7 E5 01 10 C4 E5 00 10 D5 E5 02 10 C4 E5 01 30 83 E2 00 10 D2 E5 0C 00 53 E1 00 00 C4 E5 03 10 C4 E5 04 40 84 E2 F1 FF FF 1A 00 00 A0 E3 BC FF FF EA A2 15 A0 E1 01 A0 A0 E3 1A A1 A0 E1 01 00 5A E3 3C 90 95 E5 05 00 00 0A 0A 00 A0 E1 00 20 8D E5 ?? ?? ?? ?? 10 00 80 E2 00 31 95 E7 00 20 9D E5 01 90 49 E2 0A A0 89 E0 82 2A A0 E1 03 10 8A E0 A2 2A A0 E1 02 10 81 E0 B3 FF FF EA 01 00 82 E2 00 20 8D E5 ?? ?? ?? ?? 10 00 80 E2 00 11 95 E7 00 20 9D E5 AA FF FF EA B0 30 D4 E1 0C 20 8D E2 B2 30 62 E1 0A 30 DD E5 0B 10 DD E5 01 30 C4 E5 00 10 C4 E5 B0 C0 D4 E1 01 00 82 E2 02 C0 8C E2 01 30 A0 E3 B2 10 D4 E1 BA 10 CD E1 00 10 D0 E5 02 10 C4 E5 01 30 83 E2 00 10 D2 E5 03 00 5C E1 03 10 C4 E5 02 40 84 E2 F5 FF FF AA 00 00 A0 E3 8B FF FF EA 0C 30 95 E5 06 20 43 E2 B4 30 C4 E1 B2 20 C4 E1 B0 80 C4 E1 08 00 A0 E1 84 FF FF EA ?? ?? ?? ?? 4F 30 A0 E3 00 30 80 E5 00 00 E0 E3 7F FF FF EA }
	condition:
		$1
}

rule file_364_5_0 {
	meta:
		name = "__free_ovflpage"
		size = 188
		refs = "00ac __reclaim_buf"
	strings:
		$1 = { 0C 30 91 E5 03 38 A0 E1 70 40 2D E9 A3 5D B0 E1 23 38 A0 E1 10 50 85 12 83 3A A0 E1 05 51 90 17 01 60 A0 E1 A3 3A A0 E1 10 10 90 E5 01 30 43 E2 05 50 83 E0 03 10 81 E2 55 11 A0 E1 24 20 90 E5 0C 30 90 E5 02 00 55 E1 4E 20 81 E2 24 50 80 B5 00 40 A0 E1 02 01 90 E7 83 31 A0 E1 01 30 43 E2 00 00 50 E3 03 50 05 E0 10 00 00 0A 00 00 55 E3 C5 2F A0 E1 1F 30 85 E2 A2 2D A0 E1 05 30 A0 A1 C3 32 A0 E1 02 50 85 E0 03 11 90 E7 1F 50 05 E2 05 20 62 E0 01 C0 A0 E3 1C 22 C1 E1 06 10 A0 E1 03 21 80 E7 04 00 A0 E1 70 40 BD E8 ?? ?? ?? ?? 04 00 A0 E1 B0 FF FF EB EB FF FF EA }
	condition:
		$1
}

rule file_364_6_0 {
	meta:
		name = "__add_ovflpage"
		size = 1080
		refs = "0334 __get_buf 03b4 __ibitmap 0410 write"
	strings:
		$1 = { F0 4F 2D E9 34 30 90 E5 10 20 91 E5 08 D0 4D E2 01 08 53 E3 00 40 A0 E1 01 50 A0 E1 04 20 8D E5 B0 00 00 0A 14 30 D5 E5 01 30 83 E3 14 30 C5 E5 20 60 94 E5 11 B0 86 E2 0B 21 94 E7 10 A0 94 E5 24 80 94 E5 03 A0 8A E2 01 30 42 E2 58 8A A0 E1 53 AA A0 E1 0C 10 94 E5 81 11 A0 E1 01 10 41 E2 08 00 5A E1 03 10 01 E0 00 10 8D E5 00 00 A0 B3 21 00 00 BA 4E 90 88 E2 09 91 84 E0 08 70 A0 E1 00 00 99 E5 00 00 50 E3 9D 00 00 0A 07 00 5A E1 0C C0 94 15 8C C1 A0 11 00 C0 9D 05 01 C0 4C 12 07 00 58 E1 00 10 A0 13 01 30 A0 11 82 00 00 0A 03 00 5C E1 0B 00 00 BA 01 21 90 E7 01 00 72 E3 3E 00 00 1A 01 10 81 E2 01 11 80 E0 02 00 00 EA 04 20 91 E4 01 00 72 E3 38 00 00 1A 20 30 83 E2 0C 00 53 E1 F9 FF FF DA 01 70 87 E2 07 00 5A E1 04 90 89 E2 E1 FF FF AA 0B 21 94 E7 0B 31 94 E7 01 30 83 E2 00 00 56 E3 0B 31 84 E7 24 20 84 E5 10 20 86 12 02 81 94 17 06 80 A0 01 03 80 68 E0 02 0B 58 E3 06 70 A0 B1 09 00 00 BA 01 70 86 E2 1F 00 57 E3 B2 00 00 CA 12 60 86 E2 06 31 84 E7 0B 31 94 E7 01 30 43 E2 0B 31 84 E7 20 70 84 E5 01 80 A0 E3 0C 30 94 E5 00 C0 9D E5 83 31 A0 E1 01 30 43 E2 03 00 5C E1 8B 00 00 0A 00 20 9D E5 01 30 92 E2 C3 1F A0 E1 20 20 82 42 03 20 A0 51 A1 1D A0 E1 C2 22 A0 E1 01 30 83 E0 1F 30 03 E2 02 C1 90 E7 03 10 61 E0 01 30 A0 E3 13 31 8C E1 02 31 80 E7 08 68 A0 E1 26 68 A0 E1 07 30 A0 E1 83 65 86 E0 06 68 A0 E1 26 68 A0 E1 39 00 00 EA 00 10 A0 E3 01 C0 A0 E3 03 00 00 EA 01 10 81 E2 20 00 51 E3 02 00 00 0A 8C C0 A0 E1 02 00 1C E1 F9 FF FF 1A 03 10 81 E0 00 00 51 E3 C1 2F A0 E1 1F 30 81 E2 A2 2D A0 E1 01 30 A0 A1 C3 32 A0 E1 02 80 81 E0 03 C1 90 E7 1F 80 08 E2 08 20 62 E0 01 80 A0 E3 18 22 8C E1 03 21 80 E7 0C 30 94 E5 83 31 A0 E1 97 03 03 E0 24 20 94 E5 08 30 83 E0 01 30 83 E0 02 00 53 E1 01 20 43 A2 24 20 84 A5 00 00 56 E3 34 00 00 DA 44 20 94 E5 03 00 52 E1 31 00 00 AA 04 00 A0 E1 00 C0 A0 E3 04 00 00 EA 48 10 90 E5 01 00 53 E1 04 00 80 E2 03 00 00 DA 02 C0 A0 E1 01 20 8C E2 02 00 56 E1 F7 FF FF CA 11 C0 8C E2 0C 11 94 E7 03 30 61 E0 7F 1E A0 E3 0E 10 81 E2 01 00 53 E1 04 00 00 CA 82 65 83 E0 06 68 A0 E1 26 68 A0 E1 00 00 56 E3 1C 00 00 1A 00 00 A0 E3 08 D0 8D E2 F0 8F BD E8 0C 30 94 E5 24 20 94 E5 83 31 A0 E1 01 30 43 E2 02 30 03 E0 00 00 53 E3 1F 10 83 E2 03 10 A0 A1 C1 12 A0 E1 1F 30 C3 E3 71 FF FF EA B0 30 D2 E1 A3 30 A0 E1 03 00 53 E3 34 30 80 E5 04 30 A0 D3 34 30 80 D5 47 FF FF EA 04 00 A0 E1 07 10 A0 E1 EB FE FF EB 00 00 50 E3 5C FF FF 1A E4 FF FF EA 00 20 A0 E3 D9 FF FF EA 04 00 A0 E1 06 10 A0 E1 05 20 A0 E1 01 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 08 00 85 E5 DA FF FF 0A 14 30 D0 E5 01 30 83 E3 14 30 C0 E5 04 40 9D E5 B0 30 D4 E1 02 20 83 E2 82 10 A0 E1 B1 50 94 E1 83 C0 84 E0 B8 50 CC E1 B0 C0 D4 E1 8C C0 84 E0 B2 40 DC E1 04 50 9D E5 04 40 44 E2 83 C0 85 E0 B6 40 CC E1 B2 60 CC E1 00 C0 A0 E3 B1 C0 85 E1 B0 20 C5 E1 C5 FF FF EA 01 30 8A E2 1F 00 53 E3 16 00 00 CA 04 00 A0 E1 87 15 88 E0 01 20 A0 E3 ?? ?? ?? ?? 00 60 50 E2 BB FF FF 1A 11 20 87 E2 02 11 94 E7 01 80 88 E2 01 10 81 E2 02 0B 58 E3 02 11 84 E7 71 FF FF 1A 01 30 87 E2 1F 00 53 E3 0C 00 00 CA 12 70 87 E2 07 11 84 E7 02 11 94 E7 01 10 41 E2 02 11 84 E7 20 30 84 E5 6A FF FF EA 02 00 A0 E3 24 10 9F E5 31 20 A0 E3 ?? ?? ?? ?? 00 00 A0 E3 A5 FF FF EA 02 00 A0 E3 0C 10 9F E5 31 20 A0 E3 ?? ?? ?? ?? 06 00 A0 E1 9F FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_364_7_0 {
	meta:
		name = "__addel"
		size = 636
		refs = "006c __get_buf 0110 __divsi3 0130 __expand_table 0144 __big_insert 0190 memmove 0214 __add_ovflpage"
	strings:
		$1 = { F0 4F 2D E9 01 40 A0 E1 08 D0 4D E2 00 50 A0 E1 02 90 A0 E1 03 60 A0 E1 10 70 91 E5 16 00 00 EA 81 80 A0 E1 B8 30 97 E1 03 00 53 E3 73 00 00 8A 01 B0 81 E2 04 20 99 E5 04 30 96 E5 8B B0 A0 E1 BB A0 97 E1 03 30 82 E0 04 30 83 E2 03 00 5A E1 0B B0 87 E0 40 00 00 8A 81 70 87 E0 04 20 A0 E1 B2 10 57 E1 05 00 A0 E1 00 30 A0 E3 ?? ?? ?? ?? 00 40 50 E2 35 00 00 0A 10 70 94 E5 B0 10 D7 E1 00 00 51 E3 0A 00 00 0A B4 30 D7 E1 03 00 53 E3 E2 FF FF 8A 01 00 00 1A 02 00 51 E3 5A 00 00 0A 81 80 A0 E1 B8 30 97 E1 00 00 53 E3 DF FF FF 0A E8 FF FF EA B4 30 D7 E1 03 00 53 E3 52 00 00 9A 02 10 A0 E3 04 30 96 E5 04 20 99 E5 03 20 82 E0 B1 30 97 E1 08 20 82 E2 03 00 52 E1 4A 00 00 8A 07 00 A0 E1 09 10 A0 E1 06 20 A0 E1 9D FF FF EB 14 30 D4 E5 01 30 83 E3 14 30 C4 E5 38 00 95 E5 28 10 95 E5 01 00 80 E2 38 00 85 E5 01 10 81 E2 ?? ?? ?? ?? 34 30 95 E5 03 00 50 E1 00 00 A0 D3 0B 00 00 DA 05 00 A0 E1 08 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 09 20 A0 E1 06 30 A0 E1 05 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 43 00 00 0A 00 00 E0 E3 08 D0 8D E2 F0 8F BD E8 02 50 81 E2 85 30 A0 E1 B3 40 97 E1 01 10 41 E2 04 40 62 E0 81 10 A0 E1 04 48 A0 E1 B1 C0 97 E1 24 48 A0 E1 B1 40 87 E1 04 00 87 E0 00 10 99 E5 08 10 8D E8 ?? ?? ?? ?? 04 20 96 E5 04 40 62 E0 04 48 A0 E1 24 48 A0 E1 B8 40 87 E1 04 00 87 E0 00 10 96 E5 ?? ?? ?? ?? 08 10 9D E8 00 00 A0 E3 04 20 96 E5 B0 50 C7 E1 04 10 99 E5 B0 C0 CB E1 B3 00 87 E1 00 20 62 E2 B0 30 D7 E1 02 20 61 E0 04 20 42 E2 83 30 87 E0 02 A0 8A E0 B2 A0 C3 E1 B0 30 D7 E1 83 70 87 E0 B4 40 C7 E1 00 00 A0 E3 D4 FF FF EA 01 10 81 E2 81 10 A0 E1 AD FF FF EA 04 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 40 50 E2 CB FF FF 0A 10 00 94 E5 B4 30 D0 E1 03 00 53 E3 C0 FF FF 9A B0 30 D0 E1 04 10 99 E5 04 20 96 E5 83 30 80 E0 02 20 81 E0 B2 30 D3 E1 08 20 82 E2 03 00 52 E1 B7 FF FF 8A 09 10 A0 E1 06 20 A0 E1 41 FF FF EB 14 30 D4 E5 01 30 83 E3 14 30 C4 E5 38 30 95 E5 01 30 83 E2 38 30 85 E5 A9 FF FF EA }
	condition:
		$1
}

rule file_364_8_0 {
	meta:
		name = "__split_page"
		size = 1540
		refs = "0020 __get_buf 0154 __call_hash 01d0 memmove 041c __add_ovflpage 04b8 __free_ovflpage 058c __big_split"
	strings:
		$1 = { F0 4F 2D E9 02 50 A0 E1 00 20 A0 E3 60 D0 4D E2 02 30 A0 E1 00 90 A0 E1 01 B0 A0 E1 0C 40 90 E5 ?? ?? ?? ?? 00 00 50 E3 18 00 8D E5 02 00 00 1A 00 00 E0 E3 60 D0 8D E2 F0 8F BD E8 00 20 A0 E3 05 10 A0 E1 09 00 A0 E1 02 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 28 00 8D E5 F4 FF FF 0A 18 00 9D E5 14 30 D0 E5 09 30 83 E3 14 30 C0 E5 28 10 9D E5 14 30 D1 E5 09 30 83 E3 14 30 C1 E5 10 50 90 E5 B0 30 D5 E1 10 20 91 E5 01 00 53 E3 04 48 A0 E1 24 48 A0 E1 00 C0 A0 D3 2C 40 8D E5 24 20 8D E5 03 10 A0 E1 20 C0 8D D5 55 00 00 DA B4 30 D5 E1 03 00 53 E3 00 00 A0 93 04 A0 85 E2 20 00 8D 95 6F 00 00 9A 2C 70 9D E5 01 60 A0 E3 00 20 A0 E3 14 90 8D E5 08 80 85 E2 10 60 8D E5 06 40 A0 E1 20 20 8D E5 07 90 A0 E1 1C B0 8D E5 0F 00 00 EA 23 38 B0 E1 2E 00 00 1A B0 90 DA E1 09 70 A0 E1 10 10 9D E5 02 10 81 E2 10 10 8D E5 B0 30 D5 E1 02 40 84 E2 04 00 53 E1 08 A0 A0 E1 37 00 00 DA B4 30 D8 E0 03 00 53 E3 04 60 A0 E1 4B 00 00 9A 86 60 A0 E1 B6 C0 95 E1 07 30 6C E0 0C C0 85 E0 0C 10 A0 E1 03 20 A0 E1 14 00 9D E5 58 C0 8D E5 5C 30 8D E5 ?? ?? ?? ?? 1C C0 9D E5 09 30 67 E0 0C 00 50 E1 03 38 A0 E1 06 B0 85 E0 DF FF FF 0A B0 C0 DA E1 B6 30 95 E1 50 20 8D E2 03 30 6C E0 24 00 9D E5 0C C0 85 E0 58 10 8D E2 54 30 8D E5 50 C0 8D E5 D4 FE FF EB 20 20 9D E5 02 30 82 E2 03 38 A0 E1 23 38 A0 E1 B0 70 DA E1 20 30 8D E5 D5 FF FF EA B0 10 DA E1 03 30 81 E0 03 98 A0 E1 29 98 A0 E1 07 20 61 E0 09 00 85 E0 01 10 85 E0 ?? ?? ?? ?? B0 30 DA E1 B0 20 DB E1 10 00 9D E5 09 30 63 E0 02 10 83 E0 80 20 A0 E1 80 30 85 E0 B2 10 85 E1 B2 90 C3 E1 B0 70 DA E1 BF FF FF EA 2C 90 8D E5 20 C0 9D E5 03 30 6C E0 03 38 A0 E1 2C 00 9D E5 23 38 A0 E1 03 10 83 E2 83 20 85 E0 81 10 40 E0 B0 30 C5 E1 B2 10 C2 E1 B0 30 D5 E1 83 50 85 E0 B4 00 C5 E1 18 10 9D E5 14 30 D1 E5 08 30 C3 E3 14 30 C1 E5 28 20 9D E5 14 30 D2 E5 08 30 C3 E3 14 30 C2 E5 00 00 A0 E3 74 FF FF EA 18 10 9D E5 28 20 9D E5 10 50 91 E5 10 20 92 E5 2C 90 8D E5 1C B0 9D E5 14 90 9D E5 24 20 8D E5 B0 10 D5 E1 18 30 9D E5 01 60 41 E2 00 C0 A0 E3 06 68 A0 E1 24 40 8D E2 10 04 94 E8 14 30 8D E5 10 50 8D E5 1C 30 8D E5 24 C0 8D E5 26 68 A0 E1 01 00 56 E1 7A 00 00 2A B4 30 D5 E1 01 30 43 E2 03 38 A0 E1 02 08 53 E3 A6 00 00 9A 86 30 85 E0 B2 70 D3 E1 00 00 57 E3 BC 30 D9 11 78 00 00 0A 01 00 51 E3 6C 00 00 9A B4 70 D5 E1 03 00 57 E3 69 00 00 9A 01 00 A0 E3 00 60 A0 E1 1F 00 00 EA B4 30 D4 E1 03 00 53 E3 41 00 00 9A B0 30 D4 E1 44 20 9D E5 4C 10 9D E5 83 30 84 E0 02 20 81 E0 B2 30 D3 E1 08 20 82 E2 03 00 52 E1 38 00 00 8A 04 00 A0 E1 48 10 8D E2 40 20 8D E2 6A FE FF EB 14 30 DA E5 01 30 83 E3 14 30 CA E5 02 60 86 E2 06 68 A0 E1 B0 10 D5 E1 26 68 A0 E1 06 00 51 E1 D2 FF FF 9A 86 30 85 E0 B2 20 D3 E1 03 00 52 E3 06 00 A0 E1 CD FF FF 9A 07 30 A0 E1 02 70 A0 E1 80 00 A0 E1 B0 E0 95 E1 03 30 6E E0 0E C0 85 E0 0C 10 A0 E1 0E E0 67 E0 03 20 A0 E1 07 80 85 E0 09 00 A0 E1 40 80 8D E5 44 E0 8D E5 48 C0 8D E5 4C 30 8D E5 ?? ?? ?? ?? 00 00 5B E1 CF FF FF 1A 10 00 9D E5 B4 30 D0 E1 03 00 53 E3 1B 00 00 9A B0 30 D0 E1 44 20 9D E5 4C 10 9D E5 83 30 80 E0 02 20 81 E0 B2 30 D3 E1 08 20 82 E2 03 00 52 E1 12 00 00 8A 48 10 8D E2 40 20 8D E2 3A FE FF EB 14 20 9D E5 14 30 D2 E5 01 30 83 E3 14 30 C2 E5 CD FF FF EA 0A 10 A0 E1 09 00 A0 E1 ?? ?? ?? ?? 00 A0 50 E2 12 00 00 0A 10 40 9A E5 48 10 8D E2 04 00 A0 E1 40 20 8D E2 2B FE FF EB BF FF FF EA 14 10 9D E5 09 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 14 00 8D E5 06 00 00 0A 10 10 90 E5 10 10 8D E5 10 00 9D E5 48 10 8D E2 40 20 8D E2 1E FE FF EB E2 FF FF EA 00 00 E0 E3 18 C0 9D E5 14 30 DC E5 08 30 C3 E3 14 30 CC E5 28 10 9D E5 14 30 D1 E5 08 30 C3 E3 14 30 C1 E5 E5 FE FF EA 01 60 A0 E3 82 FF FF EA 24 30 9D E5 00 00 53 E3 4D 00 00 0A 09 00 A0 E1 03 10 A0 E1 ?? ?? ?? ?? 00 00 A0 E3 EC FF FF EA 20 C0 9D E5 02 30 41 E2 03 30 6C E0 03 38 A0 E1 23 38 A0 E1 2C 00 9D E5 03 20 83 E2 82 20 40 E0 86 60 A0 E1 83 00 85 E0 B6 10 95 E1 B0 30 C5 E1 B2 20 C0 E1 B0 30 D5 E1 2C 20 9D E5 83 30 85 E0 B4 20 C3 E1 09 00 A0 E1 1C 20 9D E5 07 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 1C 00 8D E5 D3 FF FF 0A 24 30 9D E5 00 00 53 E3 10 50 90 E5 BC 30 D9 E1 2D 00 00 0A 24 10 9D E5 09 00 A0 E1 0C 30 8D E5 ?? ?? ?? ?? 0C 30 9D E5 1C C0 9D E5 2C 30 8D E5 B0 10 D5 E1 BC 30 D9 E1 20 70 8D E5 24 C0 8D E5 5D FF FF EA 1C 00 9D E5 0C C0 90 E5 00 30 A0 E1 00 C0 8D E5 14 10 9D E5 30 C0 8D E2 0A 20 A0 E1 09 00 A0 E1 00 18 8D E9 ?? ?? ?? ?? 00 00 50 E3 B6 FF FF 1A 34 00 9D E5 00 00 50 E3 14 00 8D E5 B2 FF FF 0A 30 A0 9D E5 00 00 5A E3 10 30 90 E5 AE FF FF 0A 38 10 9D E5 00 00 51 E3 1C 10 8D E5 10 40 9A E5 06 00 00 0A 10 50 91 E5 1C 20 9D E5 10 30 8D E5 B0 10 D5 E1 BC 30 D9 E1 24 20 8D E5 3D FF FF EA 00 00 A0 E3 A1 FF FF EA 20 70 8D E5 B0 10 D5 E1 2C 30 8D E5 24 00 8D E5 36 FF FF EA }
	condition:
		$1
}

rule file_364_9_0 {
	meta:
		name = "__delpair"
		size = 320
		refs = "0074 memmove 013c __big_delete"
	strings:
		$1 = { F0 4F 2D E9 10 40 91 E5 01 B0 82 E2 8B B0 A0 E1 BB 30 94 E1 03 00 53 E3 02 70 A0 E1 01 80 A0 E1 00 A0 A0 E1 B0 50 D4 E1 0B B0 84 E0 41 00 00 9A 01 00 52 E3 82 20 84 10 B2 60 52 11 BC 60 D0 01 01 90 45 E2 06 60 63 E0 06 68 A0 E1 07 00 59 E1 26 68 A0 E1 05 30 A0 01 21 00 00 0A 85 20 84 E0 B4 20 D2 E1 02 00 84 E0 00 10 A0 E1 03 20 62 E0 06 00 80 E0 ?? ?? ?? ?? 02 20 87 E2 02 00 55 E1 16 00 00 BA 03 30 87 E2 83 30 84 E0 87 70 84 E0 82 10 84 E0 B0 00 D3 E1 00 00 50 E3 B0 00 D1 11 B0 00 D1 01 00 00 86 10 B0 00 C7 11 B0 00 C7 01 B0 00 D3 11 B0 00 D3 01 00 00 86 10 02 20 82 E2 B0 00 CB 01 B0 00 CB 11 02 00 55 E1 04 30 83 E2 04 10 81 E2 04 70 87 E2 04 B0 8B E2 EC FF FF AA B0 30 D4 E1 83 30 84 E0 B4 20 D3 E1 85 30 A0 E1 02 20 86 E0 B3 20 84 E1 85 30 84 E0 B2 20 D3 E1 38 30 9A E5 04 20 82 E2 02 60 86 E0 89 90 A0 E1 02 50 45 E2 01 30 43 E2 B9 60 84 E1 38 30 8A E5 B0 50 C4 E1 14 30 D8 E5 01 30 83 E3 14 30 C8 E5 00 00 A0 E3 F0 8F BD E8 F0 4F BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_365_0_0 {
	meta:
		name = "_wctrans_r"
		size = 80
		refs = "0014 strcmp"
	strings:
		$1 = { 30 40 2D E9 01 40 A0 E1 00 50 A0 E1 34 10 9F E5 04 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 01 00 A0 03 30 80 BD 08 04 00 A0 E1 1C 10 9F E5 ?? ?? ?? ?? 00 00 50 E3 16 30 A0 13 02 00 A0 03 00 30 85 15 00 00 A0 13 30 80 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_367_0_0 {
	meta:
		name = "wmemset"
		size = 32
	strings:
		$1 = { 00 00 52 E3 1E FF 2F 01 00 30 A0 E3 03 11 80 E7 01 30 83 E2 03 00 52 E1 FB FF FF 8A 1E FF 2F E1 }
	condition:
		$1
}

rule file_369_0_0 {
	meta:
		name = "frexpf"
		size = 136
		refs = "006c __mulsf3"
	strings:
		$1 = { 30 40 2D E9 02 21 E0 E3 02 41 D0 E3 00 50 A0 13 01 50 A0 03 02 25 42 E2 02 00 54 E1 05 20 A0 D1 01 20 85 C3 00 00 52 E3 00 20 A0 E3 00 C0 A0 E1 00 30 A0 E1 01 50 A0 E1 00 20 81 E5 07 00 00 1A 02 05 54 E3 7D 20 E0 A3 06 00 00 BA A4 4B 82 E0 7F 34 C3 E3 02 35 C3 E3 00 40 85 E5 3F C4 83 E3 0C 00 A0 E1 30 80 BD E8 13 13 A0 E3 ?? ?? ?? ?? 18 20 E0 E3 00 20 85 E5 00 30 A0 E1 02 41 C0 E3 96 20 E0 E3 F0 FF FF EA }
	condition:
		$1
}

rule file_372_0_0 {
	meta:
		name = "iswpunct"
		size = 36
		refs = "0020 __ctype_ptr__"
	strings:
		$1 = { FF 00 50 E3 14 30 9F 95 00 30 93 95 00 00 83 90 01 00 D0 95 00 00 A0 83 10 00 00 92 1E FF 2F E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_373_0_0 {
	meta:
		name = "iswcntrl"
		size = 36
		refs = "0020 __ctype_ptr__"
	strings:
		$1 = { FF 00 50 E3 14 30 9F 95 00 30 93 95 00 00 83 90 01 00 D0 95 00 00 A0 83 20 00 00 92 1E FF 2F E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_374_0_0 {
	meta:
		name = "_towctrans_r"
		size = 48
		refs = "0024 towlower 002c towupper"
	strings:
		$1 = { 01 00 52 E3 05 00 00 0A 02 00 52 E3 05 00 00 0A 16 30 A0 E3 00 30 80 E5 01 00 A0 E1 1E FF 2F E1 01 00 A0 E1 ?? ?? ?? ?? 01 00 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_375_0_0 {
	meta:
		name = "asniprintf"
		size = 204
		refs = "008c _svfiprintf_r 00c8 _impure_ptr"
	strings:
		$1 = { 0C 00 2D E9 10 40 2D E9 00 30 91 E5 B4 20 9F E5 00 00 53 E3 00 00 50 13 6C D0 4D E2 01 40 A0 E1 00 C0 A0 03 01 C0 A0 13 00 20 92 E5 08 00 00 0A 00 C0 53 E2 8B 30 A0 B3 00 30 82 B5 00 00 A0 B3 1A 00 00 AA 6C D0 8D E2 10 40 BD E8 08 D0 8D E2 1E FF 2F E1 A2 3F A0 E3 BC 30 CD E1 00 C0 8D E5 10 C0 8D E5 78 E0 8D E2 0E 30 A0 E1 02 00 A0 E1 14 C0 8D E5 74 20 9D E5 08 C0 8D E5 0D 10 A0 E1 00 C0 E0 E3 BE C0 CD E1 68 E0 8D E5 ?? ?? ?? ?? 00 00 50 E3 00 30 9D A5 00 20 A0 A3 00 00 84 A5 00 20 C3 A5 00 00 A0 B3 10 00 9D A5 E4 FF FF EA 06 3C A0 E3 08 30 83 E2 BC 30 CD E1 10 00 8D E5 00 00 8D E5 E6 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_458_0_0 {
	meta:
		name = "asnprintf"
		size = 204
		refs = "008c _svfprintf_r 00c8 _impure_ptr"
	strings:
		$1 = { 0C 00 2D E9 10 40 2D E9 00 30 91 E5 B4 20 9F E5 00 00 53 E3 00 00 50 13 6C D0 4D E2 01 40 A0 E1 00 C0 A0 03 01 C0 A0 13 00 20 92 E5 08 00 00 0A 00 C0 53 E2 8B 30 A0 B3 00 30 82 B5 00 00 A0 B3 1A 00 00 AA 6C D0 8D E2 10 40 BD E8 08 D0 8D E2 1E FF 2F E1 A2 3F A0 E3 BC 30 CD E1 00 C0 8D E5 10 C0 8D E5 78 E0 8D E2 0E 30 A0 E1 02 00 A0 E1 14 C0 8D E5 74 20 9D E5 08 C0 8D E5 0D 10 A0 E1 00 C0 E0 E3 BE C0 CD E1 68 E0 8D E5 ?? ?? ?? ?? 00 00 50 E3 00 30 9D A5 00 20 A0 A3 00 00 84 A5 00 20 C3 A5 00 00 A0 B3 10 00 9D A5 E4 FF FF EA 06 3C A0 E3 08 30 83 E2 BC 30 CD E1 10 00 8D E5 00 00 8D E5 E6 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_375_1_0 {
	meta:
		name = "_asniprintf_r"
		size = 188
		refs = "0080 _svfiprintf_r"
	strings:
		$1 = { 04 30 2D E5 10 40 2D E9 00 30 92 E5 00 00 53 E3 00 00 51 13 6C D0 4D E2 02 40 A0 E1 00 C0 A0 03 01 C0 A0 13 08 00 00 0A 00 C0 53 E2 8B 30 A0 B3 00 30 80 B5 00 00 A0 B3 19 00 00 AA 6C D0 8D E2 10 40 BD E8 04 D0 8D E2 1E FF 2F E1 A2 3F A0 E3 BC 30 CD E1 00 C0 8D E5 10 C0 8D E5 78 E0 8D E2 74 20 9D E5 0E 30 A0 E1 14 C0 8D E5 08 C0 8D E5 0D 10 A0 E1 00 C0 E0 E3 BE C0 CD E1 68 E0 8D E5 ?? ?? ?? ?? 00 00 50 E3 00 30 9D A5 00 20 A0 A3 00 00 84 A5 00 20 C3 A5 00 00 A0 B3 10 00 9D A5 E5 FF FF EA 06 3C A0 E3 08 30 83 E2 BC 30 CD E1 10 10 8D E5 00 10 8D E5 E7 FF FF EA }
	condition:
		$1
}

rule file_458_1_0 {
	meta:
		name = "_asnprintf_r"
		size = 188
		refs = "0080 _svfprintf_r"
	strings:
		$1 = { 04 30 2D E5 10 40 2D E9 00 30 92 E5 00 00 53 E3 00 00 51 13 6C D0 4D E2 02 40 A0 E1 00 C0 A0 03 01 C0 A0 13 08 00 00 0A 00 C0 53 E2 8B 30 A0 B3 00 30 80 B5 00 00 A0 B3 19 00 00 AA 6C D0 8D E2 10 40 BD E8 04 D0 8D E2 1E FF 2F E1 A2 3F A0 E3 BC 30 CD E1 00 C0 8D E5 10 C0 8D E5 78 E0 8D E2 74 20 9D E5 0E 30 A0 E1 14 C0 8D E5 08 C0 8D E5 0D 10 A0 E1 00 C0 E0 E3 BE C0 CD E1 68 E0 8D E5 ?? ?? ?? ?? 00 00 50 E3 00 30 9D A5 00 20 A0 A3 00 00 84 A5 00 20 C3 A5 00 00 A0 B3 10 00 9D A5 E5 FF FF EA 06 3C A0 E3 08 30 83 E2 BC 30 CD E1 10 10 8D E5 00 10 8D E5 E7 FF FF EA }
	condition:
		$1
}

rule file_376_0_0 {
	meta:
		name = "getw"
		size = 48
		refs = "0018 fread"
	strings:
		$1 = { 04 E0 2D E5 04 D0 4D E2 00 30 A0 E1 04 10 A0 E3 0D 00 A0 E1 01 20 A0 E3 ?? ?? ?? ?? 01 00 50 E3 00 00 E0 13 00 00 9D 05 04 D0 8D E2 00 80 BD E8 }
	condition:
		$1
}

rule file_377_0_0 {
	meta:
		name = "_strtoll_r"
		size = 664
		refs = "00c8 __umoddi3 00e0 __udivdi3 0294 __ctype_ptr__"
	strings:
		$1 = { F0 4F 2D E9 01 90 A0 E1 84 12 9F E5 1C D0 4D E2 00 60 91 E5 18 00 8D E5 14 20 8D E5 03 70 A0 E1 09 50 A0 E1 01 40 D5 E4 04 30 86 E0 01 30 D3 E5 08 30 13 E2 FA FF FF 1A 2D 00 54 E3 74 00 00 0A 2B 00 54 E3 01 40 D5 04 10 30 8D E5 01 30 77 E2 00 30 A0 33 00 00 57 E3 10 00 57 13 0B 00 00 1A 30 00 54 E3 78 00 00 0A 00 00 53 E3 07 00 00 0A 30 00 54 E3 80 00 00 0A 0A 20 A0 E3 00 30 A0 E3 08 20 8D E5 0C 30 8D E5 0A 70 A0 E3 03 00 00 EA 07 10 A0 E1 C1 2F A0 E1 08 10 8D E5 0C 20 8D E5 10 20 9D E5 00 00 52 E3 02 B1 E0 03 02 B1 A0 13 00 A0 E0 03 00 A0 A0 13 0B 10 A0 E1 08 30 8D E2 0C 00 93 E8 0A 00 A0 E1 ?? ?? ?? ?? 0B 10 A0 E1 08 30 8D E2 0C 00 93 E8 00 80 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 00 90 8D E5 00 20 A0 E3 00 B0 A0 E3 00 C0 A0 E3 04 30 86 E0 01 30 D3 E5 04 00 13 E3 30 40 44 12 05 00 00 1A 03 00 13 E3 2C 00 00 0A 01 00 13 E3 37 30 A0 13 57 30 A0 03 04 40 63 E0 04 00 57 E1 26 00 00 DA 01 00 5C E1 00 30 A0 E3 1E 00 00 8A 1B 00 00 0A A2 3F 83 E1 FF 30 13 E2 15 00 00 1A 08 00 54 E1 00 20 A0 D3 01 20 A0 C3 00 00 5B E1 0B A0 A0 E1 16 00 00 0A 03 00 12 E1 0D 00 00 1A 0C A0 9D E5 9B 0A 0A E0 04 A0 8D E5 08 A0 9D E5 9B 2A 83 E0 0A 90 A0 E1 04 A0 9D E5 99 AC 2C E0 04 B0 92 E0 03 30 8C E0 C4 CF A3 E0 01 20 A0 E3 01 40 D5 E4 D5 FF FF EA 00 20 E0 E3 01 40 D5 E4 D2 FF FF EA 00 00 5B E1 E1 FF FF 9A 01 30 A0 E3 DF FF FF EA 01 00 5C E1 01 30 A0 03 E5 FF FF EA 01 00 72 E3 00 90 9D E5 14 00 00 0A 10 10 9D E5 00 00 51 E3 0A 00 00 1A 14 30 9D E5 00 00 53 E3 03 00 00 0A 00 00 52 E3 14 A0 9D E5 01 90 45 12 00 90 8A E5 0C 10 A0 E1 0B 00 A0 E1 1C D0 8D E2 F0 8F BD E8 00 B0 7B E2 00 C0 EC E2 F1 FF FF EA 01 10 A0 E3 01 40 D5 E4 10 10 8D E5 89 FF FF EA 10 10 9D E5 18 A0 9D E5 00 00 51 E3 22 30 A0 E3 00 B0 E0 03 02 C1 E0 03 00 B0 A0 13 02 C1 A0 13 00 30 8A E5 E3 FF FF EA 00 20 D5 E5 78 00 52 E3 58 00 52 13 82 FF FF 1A 10 20 A0 E3 00 30 A0 E3 01 40 D5 E5 10 70 A0 E3 02 50 85 E2 08 20 8D E5 0C 30 8D E5 88 FF FF EA 08 10 A0 E3 00 20 A0 E3 08 10 8D E5 0C 20 8D E5 08 70 A0 E3 82 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_378_0_0 {
	meta:
		name = "getenv"
		size = 40
		refs = "0018 _findenv_r 0024 _impure_ptr"
	strings:
		$1 = { 04 E0 2D E5 18 30 9F E5 04 D0 4D E2 00 10 A0 E1 0D 20 A0 E1 00 00 93 E5 ?? ?? ?? ?? 04 D0 8D E2 00 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_380_0_0 {
	meta:
		name = "strtok"
		size = 24
		refs = "0010 __strtok_r 0014 _impure_ptr"
	strings:
		$1 = { 0C 30 9F E5 00 20 93 E5 01 30 A0 E3 5C 20 82 E2 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_383_0_0 {
	meta:
		name = "_ungetwc_r"
		size = 164
		refs = "0044 _wcrtomb_r 0070 _ungetc_r"
	strings:
		$1 = { BC 30 D2 E1 F0 41 2D E9 02 0A 13 E3 02 40 A0 E1 64 20 92 05 02 3A 83 03 02 2A 82 03 BC 30 C4 01 64 20 84 05 01 00 71 E3 04 D0 4D E2 00 60 A0 E1 01 50 A0 E1 12 00 00 0A 0D 10 A0 E1 05 20 A0 E1 5C 30 84 E2 ?? ?? ?? ?? 01 00 70 E3 0D 70 A0 E1 00 80 A0 E1 00 70 8D 10 0C 00 00 0A 00 00 58 E3 06 00 A0 E1 04 20 A0 E1 05 00 00 0A 01 10 77 E5 ?? ?? ?? ?? 01 00 70 E3 01 80 48 E2 F6 FF FF 1A 00 50 A0 E1 05 00 A0 E1 04 D0 8D E2 F0 81 BD E8 BC 30 D4 E1 40 30 83 E3 BC 30 C4 E1 00 50 A0 E1 F7 FF FF EA }
	condition:
		$1
}

rule file_384_0_0 {
	meta:
		name = "critical_factorization"
		size = 384
		refs = "017c __ctype_ptr__"
	strings:
		$1 = { F0 0F 2D E9 70 31 9F E5 01 B0 A0 E3 04 D0 4D E2 0B 50 A0 E1 00 60 A0 E3 00 20 8D E5 00 20 93 E5 06 30 85 E0 01 00 53 E1 00 70 E0 E3 19 00 00 2A 03 40 D0 E7 04 C0 82 E0 01 C0 DC E5 01 00 1C E3 05 C0 80 E0 07 C0 DC E7 0C 80 82 E0 01 80 D8 E5 20 40 84 12 01 00 18 E3 20 C0 8C 12 FF 40 04 E2 FF C0 0C E2 0C 00 54 E1 03 B0 67 30 01 50 A0 33 04 00 00 3A 34 00 00 0A 01 B0 A0 E3 06 70 A0 E1 0B 30 86 E0 0B 50 A0 E1 03 60 A0 E1 06 30 85 E0 01 00 53 E1 E5 FF FF 3A 00 30 9D E5 01 90 A0 E3 09 50 A0 E1 00 60 A0 E3 00 B0 83 E5 06 30 85 E0 03 00 51 E1 00 80 E0 E3 19 00 00 9A 03 40 D0 E7 04 C0 82 E0 01 C0 DC E5 01 00 1C E3 05 C0 80 E0 08 C0 DC E7 0C A0 82 E0 01 A0 DA E5 20 40 84 12 01 00 1A E3 20 C0 8C 12 FF 40 04 E2 FF C0 0C E2 0C 00 54 E1 03 90 68 80 01 50 A0 83 04 00 00 8A 17 00 00 0A 01 90 A0 E3 06 80 A0 E1 09 30 86 E0 09 50 A0 E1 03 60 A0 E1 06 30 85 E0 03 00 51 E1 E5 FF FF 8A 01 80 88 E2 01 00 87 E2 00 00 58 E1 00 30 9D E5 09 B0 A0 21 08 00 A0 21 00 B0 83 E5 04 D0 8D E2 F0 0F BD E8 1E FF 2F E1 0B 00 55 E1 06 30 A0 11 01 50 A0 03 01 50 85 12 03 60 A0 E1 C9 FF FF EA 09 00 55 E1 06 30 A0 11 01 50 A0 03 01 50 85 12 03 60 A0 E1 E6 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_384_1_0 {
	meta:
		name = "two_way_long_needle"
		size = 1204
		refs = "00b4 strncasecmp 0104 memchr 04b0 __ctype_ptr__"
	strings:
		$1 = { F0 4F 2D E9 41 DE 4D E2 0C D0 4D E2 08 20 8D E5 00 B0 A0 E1 02 00 A0 E1 41 2E 8D E2 08 20 82 E2 01 80 A0 E1 03 10 A0 E1 03 40 A0 E1 93 FF FF EB 1C 20 8D E2 00 70 A0 E1 04 20 42 E2 00 30 A0 E3 03 40 82 E7 04 30 83 E2 01 0B 53 E3 FB FF FF 1A 00 00 54 E3 11 00 00 0A 50 34 9F E5 08 E0 9D E5 00 C0 93 E5 01 10 44 E2 00 30 A0 E3 03 20 DE E7 02 00 8C E0 01 00 D0 E5 01 00 10 E3 41 0E 8D E2 20 20 82 12 01 30 83 E2 0C 00 80 E2 02 21 80 E0 03 00 54 E1 04 14 02 E5 01 10 41 E2 F2 FF FF 8A 08 20 9D E5 18 14 9D E5 02 00 A0 E1 01 10 82 E0 07 20 A0 E1 ?? ?? ?? ?? 00 50 50 E2 8A 00 00 1A 01 30 47 E2 04 40 8D E5 08 10 9D E5 0C 30 8D E5 04 30 9D E5 07 10 81 E0 01 20 67 E2 00 70 8D E5 05 70 A0 E1 08 00 A0 E1 01 60 44 E2 03 40 87 E0 10 10 8D E5 14 20 8D E5 00 10 A0 E3 04 20 60 E0 00 00 8B E0 ?? ?? ?? ?? 00 00 50 E3 5C 00 00 1A 00 00 54 E3 5A 00 00 0A 90 03 9F E5 04 30 8B E0 01 20 53 E5 00 30 90 E5 02 10 83 E0 01 10 D1 E5 01 00 11 E3 41 1E 8D E2 20 20 82 12 0C 10 81 E2 02 21 81 E0 04 24 12 E5 00 00 52 E3 56 00 00 1A 00 00 9D E5 00 00 55 E1 05 00 A0 21 06 00 50 E1 17 00 00 2A 08 10 9D E5 07 80 80 E0 08 80 8B E0 00 C0 81 E0 04 00 00 EA 01 00 80 E2 06 00 50 E1 01 C0 8C E2 01 80 88 E2 0D 00 00 2A 00 10 DC E5 01 20 83 E0 01 20 D2 E5 01 00 12 E3 00 20 D8 E5 02 A0 83 E0 01 A0 DA E5 20 10 81 12 01 00 1A E3 20 20 82 12 02 00 51 E1 EE FF FF 0A 06 00 50 E1 43 00 00 3A 00 20 9D E5 02 00 55 E1 02 00 A0 21 1B 00 00 2A 00 00 9D E5 00 80 87 E0 08 80 8B E0 0C 00 8D E2 01 10 90 E8 00 90 9D E5 07 A0 A0 E1 05 00 00 EA 00 00 55 E1 01 C0 4C E2 01 80 48 E2 23 00 00 2A 00 90 A0 E1 01 00 40 E2 01 10 5C E5 01 20 83 E0 01 20 D2 E5 01 00 12 E3 01 20 58 E5 02 70 83 E0 01 70 D7 E5 20 10 81 12 01 00 17 E3 20 20 82 12 02 00 51 E1 ED FF FF 0A 0A 70 A0 E1 09 00 A0 E1 01 50 85 E2 00 00 55 E1 14 00 00 8A 18 54 9D E5 04 10 9D E5 05 70 87 E0 04 00 A0 E1 01 50 65 E0 04 30 9D E5 03 40 87 E0 04 20 60 E0 00 10 A0 E3 00 00 8B E0 ?? ?? ?? ?? 00 00 50 E3 A2 FF FF 0A 00 00 A0 E3 1C D0 8D E2 01 DB 8D E2 F0 8F BD E8 01 50 85 E2 00 00 55 E1 0A 70 A0 E1 EA FF FF 9A 07 00 8B E0 F6 FF FF EA 00 00 55 E3 04 00 00 0A 18 34 9D E5 03 00 52 E1 04 00 9D 35 00 50 A0 33 00 20 63 30 02 70 87 E0 04 00 A0 E1 E3 FF FF EA 14 20 9D E5 07 70 82 E0 00 70 87 E0 00 50 A0 E3 04 00 A0 E1 DD FF FF EA 04 30 67 E0 07 00 53 E1 07 30 A0 31 08 00 9D E5 01 30 83 E2 01 10 47 E2 01 20 67 E2 18 34 8D E5 00 10 8D E5 08 20 8D E5 04 40 8D E5 07 A0 80 E0 00 90 A0 E3 01 50 44 E2 08 00 A0 E1 04 10 9D E5 01 40 89 E0 04 20 60 E0 00 10 A0 E3 00 00 8B E0 ?? ?? ?? ?? 00 00 50 E3 CE FF FF 1A 00 00 54 E3 CC FF FF 0A 58 01 9F E5 04 30 8B E0 01 20 53 E5 00 30 90 E5 02 10 83 E0 01 10 D1 E5 01 00 11 E3 41 1E 8D E2 20 20 82 12 0C 10 81 E2 02 21 81 E0 04 24 12 E5 00 00 52 E3 41 00 00 1A 05 00 57 E1 19 00 00 2A 07 60 89 E0 06 60 8B E0 0A C0 A0 E1 07 00 A0 E1 04 80 A0 E1 04 00 00 EA 01 00 80 E2 05 00 50 E1 01 C0 8C E2 01 60 86 E2 2D 00 00 2A 00 10 DC E5 01 20 83 E0 01 20 D2 E5 01 00 12 E3 00 20 D6 E5 02 40 83 E0 01 40 D4 E5 20 10 81 12 01 00 14 E3 20 20 82 12 02 00 51 E1 EE FF FF 0A 05 00 50 E1 08 40 A0 E1 28 00 00 3A 00 20 9D E5 01 00 72 E3 02 00 A0 E1 1F 00 00 0A 07 60 89 E0 06 60 8B E0 0A C0 A0 E1 04 80 A0 E1 03 00 00 EA 01 00 70 E3 01 C0 4C E2 01 60 46 E2 16 00 00 0A 01 10 5C E5 01 20 83 E0 01 20 D2 E5 01 00 12 E3 01 20 56 E5 02 40 83 E0 01 40 D4 E5 20 10 81 12 01 00 14 E3 20 20 82 12 02 00 51 E1 01 00 40 E2 EE FF FF 0A 18 34 9D E5 08 40 A0 E1 03 90 89 E0 04 00 A0 E1 AC FF FF EA 00 20 9D E5 01 00 72 E3 08 40 A0 E1 02 00 A0 E1 DF FF FF 1A 09 00 8B E0 7D FF FF EA 02 90 89 E0 04 00 A0 E1 A2 FF FF EA 08 30 9D E5 09 90 83 E0 00 90 89 E0 04 00 A0 E1 9D FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_384_2_0 {
	meta:
		name = "strcasestr"
		size = 1092
		refs = "0108 strncasecmp 0154 memchr 0440 __ctype_ptr__"
	strings:
		$1 = { F0 4F 2D E9 00 30 D0 E5 00 00 53 E3 1C D0 4D E2 00 60 A0 E1 01 B0 A0 E1 FF 00 00 0A 00 20 D1 E5 00 00 52 E3 1C 00 00 0A 10 14 9F E5 0B 40 A0 E1 00 C0 91 E5 01 50 A0 E3 03 00 00 EA 00 20 D4 E5 00 00 52 E3 01 00 80 E2 16 00 00 0A 03 70 8C E0 03 10 A0 E1 01 70 D7 E5 02 30 8C E0 01 30 D3 E5 01 00 17 E3 20 10 81 12 01 00 13 E3 01 30 D0 E5 20 20 82 12 02 00 51 E1 00 50 A0 13 01 50 05 02 00 00 53 E3 01 40 84 E2 EB FF FF 1A 00 30 D4 E5 00 00 53 E3 03 00 00 0A 00 60 A0 E3 06 00 A0 E1 1C D0 8D E2 F0 8F BD E8 00 00 55 E3 FA FF FF 1A 04 40 6B E0 01 20 86 E2 1F 00 54 E3 04 20 8D E5 01 80 44 E2 06 00 00 9A 04 00 9D E5 08 10 A0 E1 0B 20 A0 E1 04 30 A0 E1 9B FE FF EB 00 60 A0 E1 ED FF FF EA 04 10 A0 E1 18 20 8D E2 0B 00 A0 E1 35 FE FF EB 18 10 9D E5 00 70 A0 E1 01 10 8B E0 0B 00 A0 E1 07 20 A0 E1 ?? ?? ?? ?? 00 00 50 E3 65 00 00 1A 01 20 47 E2 0C 20 8D E5 07 20 8B E0 10 20 8D E5 01 20 67 E2 14 20 8D E5 00 60 8D E5 08 B0 8D E5 08 00 A0 E1 05 60 A0 E1 07 B0 A0 E1 04 30 9D E5 04 70 86 E0 07 20 60 E0 00 10 A0 E3 00 00 83 E0 ?? ?? ?? ?? 00 00 50 E3 CD FF FF 1A 00 00 57 E3 CB FF FF 0A 0B 00 55 E1 05 10 A0 21 0B 10 A0 31 01 00 54 E1 1A 00 00 9A 00 30 9D E5 06 C0 81 E0 0C C0 83 E0 B0 22 9F E5 08 30 9D E5 00 80 92 E5 01 00 83 E0 04 00 00 EA 01 10 81 E2 01 00 54 E1 01 00 80 E2 01 C0 8C E2 0D 00 00 9A 00 20 D0 E5 02 30 88 E0 01 30 D3 E5 01 00 13 E3 01 30 DC E5 03 A0 88 E0 01 A0 DA E5 20 20 82 12 01 00 1A E3 20 30 83 12 03 00 52 E1 EE FF FF 0A 01 00 54 E1 2A 00 00 8A 05 00 5B E1 0B 10 A0 91 1D 00 00 9A 00 20 9D E5 40 32 9F E5 0B C0 86 E0 0C C0 82 E0 0C 10 9D E5 00 80 93 E5 10 00 9D E5 0B 90 A0 E1 07 A0 A0 E1 05 00 00 EA 01 00 55 E1 01 00 40 E2 01 C0 4C E2 17 00 00 2A 01 90 A0 E1 01 10 41 E2 01 20 50 E5 02 30 88 E0 01 30 D3 E5 01 00 13 E3 00 30 DC E5 03 70 88 E0 01 70 D7 E5 20 20 82 12 01 00 17 E3 20 30 83 12 03 00 52 E1 ED FF FF 0A 0A 70 A0 E1 09 10 A0 E1 01 50 85 E2 01 00 55 E1 6E 00 00 8A 18 50 9D E5 07 00 A0 E1 05 60 86 E0 04 50 65 E0 AC FF FF EA 0A 70 A0 E1 F5 FF FF EA 14 30 9D E5 06 60 83 E0 01 60 86 E0 00 50 A0 E3 07 00 A0 E1 A4 FF FF EA 04 30 67 E0 07 00 53 E1 07 30 A0 31 01 30 83 E2 18 30 8D E5 01 20 67 E2 01 30 47 E2 08 20 8D E5 00 30 8D E5 07 B0 8B E0 08 00 A0 E1 06 90 A0 E1 04 30 9D E5 04 60 85 E0 06 20 60 E0 00 10 A0 E3 00 00 83 E0 ?? ?? ?? ?? 00 00 50 E3 66 FF FF 1A 00 00 56 E3 64 FF FF 0A 07 00 54 E1 1B 00 00 9A 2C 21 9F E5 07 C0 85 E0 0C C0 89 E0 00 80 92 E5 0B 00 A0 E1 07 10 A0 E1 06 A0 A0 E1 04 00 00 EA 01 10 81 E2 01 00 54 E1 01 00 80 E2 01 C0 8C E2 2F 00 00 9A 00 20 D0 E5 02 30 88 E0 01 30 D3 E5 01 00 13 E3 01 30 DC E5 03 60 88 E0 01 60 D6 E5 20 20 82 12 01 00 16 E3 20 30 83 12 03 00 52 E1 EE FF FF 0A 01 00 54 E1 0A 60 A0 E1 22 00 00 8A 00 20 9D E5 01 00 72 E3 02 10 A0 E1 26 00 00 0A AC 30 9F E5 07 C0 85 E0 0C C0 89 E0 00 80 93 E5 0B 00 A0 E1 06 A0 A0 E1 03 00 00 EA 01 00 71 E3 01 00 40 E2 01 C0 4C E2 1B 00 00 0A 01 20 50 E5 02 30 88 E0 01 30 D3 E5 01 00 13 E3 00 30 DC E5 03 60 88 E0 01 60 D6 E5 20 20 82 12 01 00 16 E3 20 30 83 12 03 00 52 E1 01 10 41 E2 EE FF FF 0A 18 30 9D E5 0A 60 A0 E1 03 50 85 E0 06 00 A0 E1 B6 FF FF EA 0A 60 A0 E1 DC FF FF EA 08 30 9D E5 05 50 83 E0 01 50 85 E0 06 00 A0 E1 AF FF FF EA 01 40 A0 E1 01 50 A0 E3 18 FF FF EA 04 20 9D E5 05 60 82 E0 19 FF FF EA 04 20 9D E5 06 60 82 E0 16 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_385_0_0 {
	meta:
		name = "srand"
		size = 28
		refs = "0018 _impure_ptr"
	strings:
		$1 = { 10 30 9F E5 00 30 93 E5 00 20 A0 E3 A8 20 83 E5 A4 00 83 E5 1E FF 2F E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_385_1_0 {
	meta:
		name = "rand"
		size = 92
		refs = "0050 _impure_ptr"
	strings:
		$1 = { 70 00 2D E9 44 30 9F E5 00 20 93 E5 40 C0 9F E5 A4 00 92 E5 90 0C 0C E0 A8 40 92 E5 34 30 9F E5 93 50 86 E0 94 C3 23 E0 06 10 83 E0 01 30 A0 E3 05 30 93 E0 00 40 A0 E3 01 40 A4 E0 A4 30 82 E5 A8 40 82 E5 02 01 C4 E3 70 00 BD E8 1E FF 2F E1 ?? ?? ?? ?? 2D F4 51 58 2D 7F 95 4C }
	condition:
		$1
}

rule file_386_0_0 {
	meta:
		name = "copysignf"
		size = 16
	strings:
		$1 = { 02 11 01 E2 02 01 C0 E3 00 00 81 E1 1E FF 2F E1 }
	condition:
		$1
}

rule file_387_0_0 {
	meta:
		name = "mbsinit"
		size = 28
	strings:
		$1 = { 00 00 50 E3 01 00 A0 03 1E FF 2F 01 00 00 90 E5 01 00 70 E2 00 00 A0 33 1E FF 2F E1 }
	condition:
		$1
}

rule file_389_0_0 {
	meta:
		name = "strlwr"
		size = 64
		refs = "003c __ctype_ptr__"
	strings:
		$1 = { 00 30 D0 E5 00 00 53 E3 1E FF 2F 01 28 C0 9F E5 00 20 A0 E1 00 10 9C E5 03 10 81 E0 01 10 D1 E5 01 00 11 E3 20 30 83 12 00 30 C2 15 01 30 F2 E5 00 00 53 E3 F6 FF FF 1A 1E FF 2F E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_390_0_0 {
	meta:
		name = "_fwrite_r"
		size = 164
		refs = "0070 __sfvwrite_r 0088 __udivsi3 009c __sinit"
	strings:
		$1 = { F0 41 2D E9 92 03 06 E0 14 D0 4D E2 03 50 A0 E1 0C 30 8D E2 00 30 8D E5 00 70 50 E2 01 30 A0 E3 02 40 A0 E1 0C 10 8D E5 04 30 8D E5 10 60 8D E5 08 60 8D E5 2C 80 9D E5 02 00 00 0A 38 30 97 E5 00 00 53 E3 14 00 00 0A BC 30 D8 E1 02 0A 13 E3 64 20 98 05 02 3A 83 03 02 2A C2 03 64 20 88 05 BC 30 C8 01 07 00 A0 E1 08 10 A0 E1 0D 20 A0 E1 ?? ?? ?? ?? 00 00 50 E3 04 00 00 0A 08 00 9D E5 04 10 A0 E1 06 00 60 E0 ?? ?? ?? ?? 00 50 A0 E1 05 00 A0 E1 14 D0 8D E2 F0 81 BD E8 ?? ?? ?? ?? E8 FF FF EA }
	condition:
		$1
}

rule file_391_0_0 {
	meta:
		name = "__smakebuf_r"
		size = 352
		refs = "0030 _fstat_r 0094 _malloc_r 00d0 _isatty_r 0158 _cleanup_r 015c __sseek"
	strings:
		$1 = { F0 40 2D E9 BC 30 D1 E1 02 00 13 E3 3C D0 4D E2 01 40 A0 E1 03 20 A0 E1 00 50 A0 E1 32 00 00 1A FE 10 D1 E1 00 00 51 E3 11 00 00 BA 0D 20 A0 E1 ?? ?? ?? ?? 00 00 50 E3 0B 00 00 BA 04 30 9D E5 0F 3A 03 E2 02 0A 53 E3 00 70 A0 13 01 70 A0 03 02 09 53 E3 2A 00 00 0A BC 30 D4 E1 02 3B 83 E3 BC 30 C4 E1 01 6B A0 E3 07 00 00 EA BC 30 D4 E1 03 20 A0 E1 02 3B 83 E3 80 00 12 E3 BC 30 C4 E1 01 6B A0 03 40 60 A0 13 00 70 A0 E3 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 22 00 00 0A BC 30 D4 E1 AC 20 9F E5 80 30 83 E3 00 00 57 E3 3C 20 85 E5 BC 30 C4 E1 10 00 84 E5 14 60 84 E5 00 00 84 E5 06 00 00 0A 05 00 A0 E1 FE 10 D4 E1 ?? ?? ?? ?? 00 00 50 E3 BC 30 D4 11 01 30 83 13 BC 30 C4 11 3C D0 8D E2 F0 80 BD E8 43 30 81 E2 01 20 A0 E3 14 20 81 E5 10 30 81 E5 00 30 81 E5 F7 FF FF EA 28 20 94 E5 4C 30 9F E5 03 00 52 E1 D0 FF FF 1A BC 30 D4 E1 01 6B A0 E3 01 3B 83 E3 BC 30 C4 E1 4C 60 84 E5 D7 FF FF EA BC 30 D4 E1 02 0C 13 E3 EA FF FF 1A 43 20 84 E2 02 30 83 E3 01 10 A0 E3 14 10 84 E5 BC 30 C4 E1 10 20 84 E5 00 20 84 E5 E2 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_392_1_0 {
	meta:
		name = "__messages_load_locale"
		size = 84
		refs = "003c __part_load_locale"
	strings:
		$1 = { 30 40 2D E9 3C C0 9F E5 0C D0 4D E2 38 E0 9F E5 04 50 A0 E3 04 40 8C E2 00 50 8D E5 14 20 9C E5 02 50 A0 E3 0C 10 A0 E1 20 30 9F E5 10 E0 8C E5 04 50 8D E5 08 40 8D E5 0C E0 8C E5 ?? ?? ?? ?? 0C D0 8D E2 30 80 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_394_0_0 {
	meta:
		name = "strsep"
		size = 16
		refs = "000c __strtok_r"
	strings:
		$1 = { 00 20 A0 E1 00 00 90 E5 00 30 A0 E3 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_395_0_0 {
	meta:
		name = "_freopen_r"
		size = 532
		refs = "0018 __sfp_lock_acquire 003c __sflags 0078 _open_r 00c4 _free_r 0108 memset 0140 __sfp_lock_release 01c0 __sinit 01d0 _fflush_r 01e0 _fclose_r 0204 __sread 0208 __swrite 020c __sseek 0210 __sclose"
	strings:
		$1 = { F0 45 2D E9 00 50 A0 E1 04 D0 4D E2 01 60 A0 E1 02 70 A0 E1 03 40 A0 E1 ?? ?? ?? ?? 00 00 55 E3 02 00 00 0A 38 30 95 E5 00 00 53 E3 62 00 00 0A 07 10 A0 E1 05 00 A0 E1 0D 20 A0 E1 ?? ?? ?? ?? 00 70 50 E2 63 00 00 0A BC 30 D4 E1 00 00 53 E3 20 30 A0 03 BC 30 C4 01 3C 00 00 1A 00 00 56 E3 46 00 00 0A 6D 3F A0 E3 02 30 83 E2 06 10 A0 E1 05 00 A0 E1 00 20 9D E5 ?? ?? ?? ?? BC 30 D4 E1 80 00 13 E3 00 80 A0 E1 00 A0 95 E5 46 00 00 1A 30 10 94 E5 00 30 A0 E3 00 00 51 E3 18 30 84 E5 08 30 84 E5 04 30 84 E5 00 30 84 E5 10 30 84 E5 14 30 84 E5 05 00 00 0A 40 30 84 E2 03 00 51 E1 05 00 A0 11 ?? ?? ?? ?? 00 30 A0 E3 30 30 84 E5 44 10 94 E5 00 60 A0 E3 00 00 51 E3 34 60 84 E5 02 00 00 0A 05 00 A0 E1 ?? ?? ?? ?? 44 60 84 E5 00 60 A0 E3 48 60 84 E5 64 60 84 E5 5C 00 84 E2 06 10 A0 E1 08 20 A0 E3 ?? ?? ?? ?? 06 00 58 E1 36 00 00 BA E8 30 9F E5 20 30 84 E5 E4 30 9F E5 24 30 84 E5 E0 30 9F E5 28 30 84 E5 DC 30 9F E5 BC 70 C4 E1 BE 80 C4 E1 2C 30 84 E5 1C 40 84 E5 ?? ?? ?? ?? 04 00 A0 E1 04 D0 8D E2 F0 85 BD E8 08 00 13 E3 1B 00 00 1A 2C 30 94 E5 00 00 56 E3 00 00 53 13 BC FF FF 0A 05 00 A0 E1 1C 10 94 E5 0F E0 A0 E1 13 FF 2F E1 00 00 56 E3 B8 FF FF 1A 2C 30 94 E5 00 00 53 E3 05 00 A0 11 1C 10 94 15 0F E0 A0 11 13 FF 2F 11 BC 30 D4 E1 80 00 13 E3 09 A0 A0 E3 00 80 E0 E3 B8 FF FF 0A 05 00 A0 E1 10 10 94 E5 ?? ?? ?? ?? B4 FF FF EA 05 00 A0 E1 ?? ?? ?? ?? 99 FF FF EA 05 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? DF FF FF EA 04 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 07 40 A0 E1 ?? ?? ?? ?? D4 FF FF EA BC 60 C4 E1 00 A0 85 E5 06 40 A0 E1 ?? ?? ?? ?? CF FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_396_0_0 {
	meta:
		name = "wcslen"
		size = 44
	strings:
		$1 = { 00 30 90 E5 00 00 53 E3 03 00 A0 01 1E FF 2F 01 00 30 A0 E1 04 20 B3 E5 00 00 52 E3 FC FF FF 1A 03 00 60 E0 40 01 A0 E1 1E FF 2F E1 }
	condition:
		$1
}

rule file_397_0_0 {
	meta:
		name = "_nrand48_r"
		size = 32
		refs = "0008 __dorand48"
	strings:
		$1 = { 10 40 2D E9 01 40 A0 E1 ?? ?? ?? ?? B4 30 D4 E1 B2 00 D4 E1 83 37 A0 E1 A0 00 83 E0 10 80 BD E8 }
	condition:
		$1
}

rule file_398_0_0 {
	meta:
		name = "_lcong48_r"
		size = 60
	strings:
		$1 = { B0 30 D1 E1 BC 3A C0 E1 B2 30 D1 E1 BE 3A C0 E1 B4 30 D1 E1 B0 3B C0 E1 B6 30 D1 E1 B2 3B C0 E1 B8 30 D1 E1 B4 3B C0 E1 BA 30 D1 E1 B6 3B C0 E1 BC 10 D1 E1 B8 1B C0 E1 1E FF 2F E1 }
	condition:
		$1
}

rule file_398_1_0 {
	meta:
		name = "lcong48"
		size = 72
		refs = "0044 _impure_ptr"
	strings:
		$1 = { 3C 30 9F E5 B0 20 D0 E1 00 30 93 E5 BC 2A C3 E1 B2 20 D0 E1 BE 2A C3 E1 B4 20 D0 E1 B0 2B C3 E1 B6 20 D0 E1 B2 2B C3 E1 B8 20 D0 E1 B4 2B C3 E1 BA 20 D0 E1 B6 2B C3 E1 BC 00 D0 E1 B8 0B C3 E1 1E FF 2F E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_399_0_0 {
	meta:
		name = "mbrlen"
		size = 24
		refs = "0014 mbrtowc"
	strings:
		$1 = { 01 C0 A0 E1 02 30 A0 E1 00 10 A0 E1 0C 20 A0 E1 00 00 A0 E3 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_405_0_0 {
	meta:
		name = "strlcat"
		size = 164
		refs = "0098 strlen"
	strings:
		$1 = { 00 00 52 E3 30 40 2D E9 20 00 00 0A 00 40 D0 E5 00 00 54 E3 00 30 A0 01 0C 00 00 0A 01 C0 42 E2 00 30 A0 E1 03 00 00 EA 00 40 D3 E5 00 00 54 E3 01 C0 4C E2 02 00 00 0A 00 00 5C E3 01 30 83 E2 F8 FF FF 1A 03 40 60 E0 04 20 52 E0 10 00 00 0A 00 C0 D1 E5 00 00 5C E3 0C 00 A0 01 07 00 00 0A 01 50 A0 E1 01 00 52 E3 01 C0 C3 14 01 C0 F5 E5 01 20 42 12 00 00 5C E3 F9 FF FF 1A 05 00 61 E0 00 20 A0 E3 00 20 C3 E5 04 00 80 E0 30 80 BD E8 02 40 A0 E1 01 00 A0 E1 ?? ?? ?? ?? 04 00 80 E0 30 80 BD E8 }
	condition:
		$1
}

rule file_406_0_0 {
	meta:
		name = "_wcstol_r"
		size = 468
		refs = "0024 iswspace 0088 __umodsi3 0098 __udivsi3 00ac iswdigit 0120 iswalpha 0130 iswupper"
	strings:
		$1 = { F0 4F 2D E9 0C D0 4D E2 08 00 8D E5 01 40 A0 E1 02 50 A0 E1 03 A0 A0 E1 01 70 A0 E1 04 60 97 E4 06 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 FA FF FF 1A 2D 00 56 E3 54 00 00 0A 2B 00 56 E3 04 60 97 04 00 B0 A0 E1 01 30 7A E2 00 30 A0 33 00 00 5A E3 10 00 5A 13 06 00 00 1A 30 00 56 E3 54 00 00 0A 00 00 53 E3 02 00 00 0A 30 00 56 E3 08 A0 A0 03 0A A0 A0 13 00 00 5B E3 02 81 A0 13 02 81 E0 03 08 00 A0 E1 0A 10 A0 E1 ?? ?? ?? ?? 0A 10 A0 E1 00 90 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 00 80 A0 E3 04 00 8D E5 06 00 A0 E1 00 80 8D E5 ?? ?? ?? ?? 00 00 50 E3 30 60 46 12 17 00 00 0A 06 00 5A E1 21 00 00 DA 06 00 9D E8 02 00 51 E1 00 30 A0 93 01 30 A0 83 A8 3F 93 E1 28 00 00 1A 09 00 56 E1 00 30 A0 D3 01 30 A0 C3 02 00 51 E1 00 30 A0 13 00 00 53 E3 21 00 00 1A 9A 61 21 E0 04 60 97 E4 00 10 8D E5 01 80 A0 E3 06 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 30 60 46 12 E7 FF FF 1A 06 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 06 00 A0 E1 06 00 00 0A ?? ?? ?? ?? 00 00 50 E3 37 00 A0 13 57 00 A0 03 06 60 60 E0 06 00 5A E1 DD FF FF CA 01 00 78 E3 10 00 00 0A 00 00 5B E3 00 20 9D 15 00 00 9D 05 00 00 62 12 00 00 55 E3 02 00 00 0A 00 00 58 E3 04 40 47 12 00 40 85 E5 0C D0 8D E2 F0 8F BD E8 00 80 E0 E3 04 60 97 E4 DE FF FF EA 04 60 97 E4 01 B0 A0 E3 AA FF FF EA 08 10 9D E5 00 00 5B E3 22 30 A0 E3 00 30 81 E5 02 01 A0 13 02 01 E0 03 EB FF FF EA 00 20 97 E5 78 00 52 E3 58 00 52 13 A6 FF FF 1A 04 60 97 E5 10 A0 A0 E3 08 70 87 E2 A7 FF FF EA }
	condition:
		$1
}

rule file_407_0_0 {
	meta:
		name = "worker"
		size = 148
		refs = "002c _close_r 0048 _sprintf_r 0068 _open_r"
	strings:
		$1 = { F0 45 2D E9 0C D0 4D E2 28 A0 9D E5 2C 50 9D E5 00 40 A0 E1 01 60 A0 E1 02 70 A0 E1 03 80 A0 E1 02 00 00 EA 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 C0 95 E5 06 10 A0 E1 07 30 A0 E1 4C 20 9F E5 04 00 A0 E1 00 15 8D E8 ?? ?? ?? ?? 00 30 95 E5 00 20 A0 E3 01 30 83 E2 00 30 85 E5 06 10 A0 E1 02 30 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 01 00 70 E3 EB FF FF 1A 00 30 94 E5 58 00 53 E3 00 00 A0 03 00 00 C6 05 01 00 A0 13 0C D0 8D E2 F0 85 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_407_1_0 {
	meta:
		name = "_tempnam_r"
		size = 180
		refs = "0024 strlen 0040 _malloc_r 005c _getpid_r 0094 getenv"
	strings:
		$1 = { F0 40 2D E9 00 00 52 E3 98 60 9F E5 02 60 A0 11 00 70 51 E2 08 D0 4D E2 00 40 A0 E1 1B 00 00 0A 07 00 A0 E1 ?? ?? ?? ?? 00 50 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 00 10 85 E0 13 10 81 E2 04 00 A0 E1 ?? ?? ?? ?? 00 50 50 E2 02 00 00 1A 05 00 A0 E1 08 D0 8D E2 F0 80 BD E8 04 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 00 C0 24 E0 07 20 A0 E1 04 00 A0 E1 06 30 A0 E1 10 40 84 E2 00 C0 8D E5 04 40 8D E5 B9 FF FF EB 00 00 50 E3 00 50 A0 03 EE FF FF EA 14 00 9F E5 ?? ?? ?? ?? 00 00 50 E3 0C 70 9F E5 00 70 A0 11 DD FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_407_3_0 {
	meta:
		name = "_tmpnam_r"
		size = 96
		refs = "0014 _getpid_r"
	strings:
		$1 = { 30 40 2D E9 00 50 51 E2 08 D0 4D E2 14 50 80 02 00 40 A0 E1 ?? ?? ?? ?? 38 30 9F E5 00 00 8D E5 10 C0 84 E2 05 10 A0 E1 04 00 A0 E1 28 20 9F E5 04 C0 8D E5 98 FF FF EB 00 00 50 E3 10 30 94 15 00 50 A0 01 01 30 83 12 10 30 84 15 05 00 A0 E1 08 D0 8D E2 30 80 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_408_0_0 {
	meta:
		name = "__svfiscanf_r"
		size = 3584
		refs = "00c4 __srefill_r 0458 memset 0474 _mbrtowc_r 0664 __sccl 0a98 iswspace 0abc _ungetc_r 0dc8 _fread_r 0dec __ctype_ptr__ 0df0 __mb_cur_max 0df4 _strtoul_r 0df8 _strtol_r"
	strings:
		$1 = { F0 4F 2D E9 01 40 A0 E1 BC 10 D1 E1 02 0A 11 E3 03 90 A0 E1 64 30 94 05 57 DF 4D E2 02 1A 81 03 00 80 A0 E1 02 3A C3 03 00 00 A0 E3 BC 10 C4 01 4A 1F 8D E2 64 30 84 05 10 00 8D E5 A8 6D 9F E5 14 00 8D E5 1C 00 8D E5 04 10 8D E5 02 70 A0 E1 00 50 A0 E1 00 30 D7 E5 00 00 53 E3 1E 00 00 0A 00 20 96 E5 58 31 8D E5 03 10 82 E0 01 B0 D1 E5 08 B0 1B E2 01 70 87 E2 1A 00 00 0A 04 30 94 E5 0B 00 00 EA 00 20 94 E5 00 10 96 E5 00 30 D2 E5 03 30 81 E0 01 30 D3 E5 08 00 13 E3 EC FF FF 0A 04 30 94 E5 01 20 82 E2 01 30 43 E2 0C 00 84 E8 01 50 85 E2 00 00 53 E3 F1 FF FF CA 08 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 EC FF FF 0A 00 30 D7 E5 00 00 53 E3 E0 FF FF 1A 14 00 9D E5 57 DF 8D E2 F0 8F BD E8 25 00 53 E3 1B 00 00 0A 04 30 94 E5 00 00 53 E3 0B 00 00 DA 00 30 94 E5 01 20 57 E5 00 10 D3 E5 02 00 51 E1 F2 FF FF 1A 04 20 94 E5 01 30 83 E2 01 20 42 E2 04 20 84 E5 00 30 84 E5 01 50 85 E2 C9 FF FF EA 08 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 EE FF FF 0A 14 00 9D E5 00 00 50 E3 02 00 00 0A BC 30 D4 E1 40 00 13 E3 E1 FF FF 0A 00 00 E0 E3 DF FF FF EA 0B 30 A0 E1 0A 00 A0 E3 01 10 D7 E4 78 00 51 E3 01 F1 9F 97 ED 00 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 A0 A0 E1 02 20 A0 E3 04 10 94 E5 00 00 51 E3 C5 00 00 DA 40 00 1B E3 00 C0 96 05 00 10 94 05 18 30 8D 05 4D 00 00 0A 02 00 52 E3 87 01 00 0A 03 00 52 E3 28 01 00 0A 01 00 52 E3 EB 00 00 0A 00 00 53 E3 03 A0 A0 11 01 A0 A0 03 01 30 1B E2 C9 00 00 0A 10 B0 1B E2 00 C0 99 05 00 C0 A0 13 18 B0 8D E5 20 70 8D E5 04 90 89 02 05 70 A0 E1 00 B0 A0 E3 0C 50 A0 E1 0E 00 00 EA 18 00 9D E5 00 00 50 E3 00 00 85 05 18 10 9D E5 00 00 51 E3 0B 70 87 E0 18 B0 9D 05 01 A0 4A E2 00 B0 A0 13 04 50 85 02 04 30 94 E5 00 00 53 E3 A8 00 00 DA 00 00 5A E3 0B 02 00 0A D4 29 9F E5 00 30 92 E5 03 00 5B E1 46 FF FF 0A 00 30 94 E5 04 20 94 E5 01 C0 D3 E4 57 0F 8D E2 00 30 84 E5 01 20 42 E2 0B 30 80 E0 04 20 84 E5 00 10 A0 E3 34 C0 43 E5 08 20 A0 E3 01 B0 8B E2 15 0E 8D E2 ?? ?? ?? ?? 15 CE 8D E2 08 00 A0 E1 05 10 A0 E1 4A 2F 8D E2 0B 30 A0 E1 00 C0 8D E5 ?? ?? ?? ?? 01 00 70 E3 2F FF FF 0A 00 00 50 E3 D3 FF FF 0A 02 00 70 E3 DB FF FF 0A D3 FF FF EA 08 00 A0 E1 04 10 A0 E1 08 20 8D E5 ?? ?? ?? ?? 00 00 50 E3 08 20 9D E5 23 FF FF 1A 00 C0 96 E5 00 10 94 E5 01 50 85 E2 00 30 D1 E5 03 30 8C E0 01 30 D3 E5 08 00 13 E3 6B 00 00 0A 04 30 94 E5 01 30 43 E2 00 00 53 E3 01 10 81 C2 04 30 84 E5 00 10 84 C5 E9 FF FF DA 01 50 85 E2 F1 FF FF EA F8 C8 9F E5 10 20 A0 E3 10 20 8D E5 22 BE 8B E3 03 A0 A0 E1 03 20 A0 E3 1C C0 8D E5 93 FF FF EA D8 C8 9F E5 0A 20 A0 E3 10 20 8D E5 03 A0 A0 E1 03 20 A0 E3 1C C0 8D E5 8C FF FF EA 01 20 82 E0 01 20 D2 E5 B8 08 9F E5 01 00 12 E3 0A 10 A0 E3 01 B0 8B 13 1C 00 8D E5 03 A0 A0 E1 10 10 8D E5 03 20 A0 E3 81 FF FF EA 30 10 41 E2 90 13 23 E0 FF FE FF EA 10 B0 8B E3 FD FE FF EA 7C 18 9F E5 10 00 A0 E3 02 BC 8B E3 03 A0 A0 E1 10 00 8D E5 03 20 A0 E3 1C 10 8D E5 74 FF FF EA 5C C8 9F E5 08 20 A0 E3 10 20 8D E5 01 B0 8B E3 03 A0 A0 E1 03 20 A0 E3 1C C0 8D E5 6C FF FF EA 02 B0 8B E3 EB FE FF EA 01 B0 8B E3 34 28 9F E5 0A C0 A0 E3 1C 20 8D E5 03 A0 A0 E1 10 C0 8D E5 03 20 A0 E3 62 FF FF EA 14 18 9F E5 08 00 A0 E3 03 A0 A0 E1 10 00 8D E5 03 20 A0 E3 1C 10 8D E5 5B FF FF EA 10 00 1B E3 95 FE FF 1A 04 00 1B E3 00 30 99 15 00 30 99 05 B0 50 C3 11 04 90 89 12 00 50 83 05 04 90 89 02 8D FE FF EA 04 B0 8B E3 D0 FE FF EA 01 B0 8B E3 CE FE FF EA C4 07 9F E5 00 10 A0 E3 1C 00 8D E5 03 A0 A0 E1 10 10 8D E5 03 20 A0 E3 46 FF FF EA 40 B0 8B E3 03 A0 A0 E1 00 20 A0 E3 42 FF FF EA 07 10 A0 E1 28 00 8D E2 0C 30 8D E5 ?? ?? ?? ?? 0C 30 9D E5 40 B0 8B E3 00 70 A0 E1 03 A0 A0 E1 01 20 A0 E3 38 FF FF EA 18 30 9D E5 3E FF FF EA 08 00 A0 E1 04 10 A0 E1 08 20 8D E5 0C 30 8D E5 ?? ?? ?? ?? 00 00 50 E3 08 20 8D E2 0C 00 92 E8 30 FF FF 0A A3 FE FF EA 08 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 51 FF FF 0A 00 00 5B E3 07 50 A0 E1 20 70 9D E5 5D 01 00 0A 99 FE FF EA 10 00 1B E3 B4 01 00 0A 03 B0 A0 E1 05 C0 A0 E1 09 00 00 EA 00 20 94 E5 05 20 82 E0 00 20 84 E5 0C C0 8D E5 ?? ?? ?? ?? 00 00 50 E3 05 B0 8B E0 0C C0 9D E5 A4 01 00 1A 0A A0 65 E0 04 50 94 E5 0A 00 55 E1 08 00 A0 E1 04 10 A0 E1 F0 FF FF BA 00 20 94 E5 05 30 A0 E1 0A 20 82 E0 03 30 6A E0 0C 00 84 E8 0C 50 A0 E1 0A B0 8B E0 0B 50 85 E0 41 FE FF EA 00 00 53 E3 03 A0 A0 11 00 A0 E0 03 10 00 1B E3 00 10 94 15 00 B0 A0 13 23 00 00 1A 00 B0 99 E5 00 20 94 E5 0B C0 A0 E1 00 20 D2 E5 57 0F 8D E2 02 20 80 E0 34 21 52 E5 00 00 52 E3 82 01 00 0A 04 20 94 E5 01 20 42 E2 04 20 84 E5 00 20 94 E5 01 10 D2 E4 01 A0 5A E2 01 10 CB E4 00 20 84 E5 79 01 00 0A 04 10 94 E5 00 00 51 E3 ED FF FF CA 08 00 A0 E1 04 10 A0 E1 0C C0 8D E5 ?? ?? ?? ?? 00 00 50 E3 0C C0 9D E5 5E 01 00 1A 00 20 94 E5 E4 FF FF EA 08 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 D3 FF FF 1A 00 10 94 E5 00 30 D1 E5 57 CF 8D E2 03 30 8C E0 34 31 53 E5 00 00 53 E3 01 10 81 E2 5D 01 00 0A 04 30 94 E5 01 B0 8B E2 01 30 43 E2 0B 00 5A E1 0A 00 84 E8 C5 FF FF 0A 00 00 53 E3 F0 FF FF CA E9 FF FF EA 01 20 43 E2 26 00 52 E3 00 00 A0 E3 00 30 A0 93 27 30 43 82 4A CF 8D E2 05 20 A0 E1 18 00 8D E5 10 50 9D E5 20 70 8D E5 24 90 8D E5 27 A0 A0 83 36 BD 8B E3 03 70 A0 E1 0C 90 A0 E1 00 30 94 E5 00 10 D3 E5 39 00 51 E3 12 00 00 8A 38 00 51 E3 38 00 00 3A 68 05 9F E5 85 50 A0 E1 F5 50 90 E1 08 00 55 E3 11 00 00 DA 2E BD CB E3 01 10 C9 E4 04 10 94 E5 01 10 41 E2 00 00 51 E3 04 10 84 E5 01 10 83 C2 00 10 84 C5 89 00 00 DA 01 A0 5A E2 E9 FF FF 1A 05 00 00 EA 58 00 51 E3 1E 00 00 0A 17 00 00 8A 41 00 41 E2 05 00 50 E3 2C 00 00 9A 01 0C 1B E3 09 C0 A0 E1 10 50 8D E5 20 70 9D E5 02 50 A0 E1 24 90 9D E5 05 00 00 0A 04 10 9D E5 01 00 5C E1 09 01 00 8A 04 20 9D E5 02 00 5C E1 EF FD FF 0A 10 20 1B E2 D9 00 00 0A 04 10 9D E5 18 20 9D E5 05 50 61 E0 02 50 85 E0 05 50 8C E0 C5 FD FF EA 61 00 51 E3 E8 FF FF 3A 66 00 51 E3 13 00 00 9A 78 00 51 E3 E4 FF FF 1A 06 0C 0B E2 02 0C 50 E3 E1 FF FF 1A 02 BC CB E3 05 BC 8B E3 10 50 A0 E3 CC FF FF EA 30 00 51 E3 A2 00 00 0A 9C 00 00 8A 2B 00 51 E3 01 00 00 0A 2D 00 51 E3 D6 FF FF 1A 80 00 1B E3 D4 FF FF 0A 80 B0 CB E3 C1 FF FF EA 0A 00 55 E3 D0 FF FF DA 2E BD CB E3 BD FF FF EA 00 00 53 E3 03 A0 A0 11 00 A0 E0 03 01 30 1B E2 52 00 00 0A 10 B0 1B E2 00 30 99 05 56 2F 8D 12 18 20 8D 15 18 30 8D 05 20 B0 8D E5 04 90 89 02 00 B0 A0 E3 00 30 94 E5 00 20 96 E5 00 C0 D3 E5 0C 20 82 E0 01 20 D2 E5 A2 21 A0 E1 01 20 22 E2 00 00 5A E3 00 20 A0 03 01 20 02 12 00 00 52 E3 30 00 00 0A D8 03 9F E5 00 20 90 E5 02 00 5B E1 C7 FD FF 0A 04 20 94 E5 01 30 83 E2 57 1F 8D E2 00 30 84 E5 01 20 42 E2 0B 30 81 E0 04 20 84 E5 00 10 A0 E3 34 C0 43 E5 08 20 A0 E3 01 B0 8B E2 15 0E 8D E2 ?? ?? ?? ?? 15 CE 8D E2 08 00 A0 E1 18 10 9D E5 4A 2F 8D E2 0B 30 A0 E1 00 C0 8D E5 ?? ?? ?? ?? 01 00 70 E3 B1 FD FF 0A 00 00 50 E3 18 10 9D 05 00 00 81 05 03 00 00 0A 02 00 70 E3 9E 00 00 0A 18 20 9D E5 00 00 92 E5 ?? ?? ?? ?? 00 00 50 E3 90 00 00 0A 01 A0 4B E2 4A 3F 8D E2 0A A0 83 E0 02 00 00 EA 01 10 DA E5 01 B0 4B E2 ?? ?? ?? ?? 00 00 5B E3 08 00 A0 E1 04 20 A0 E1 01 A0 4A E2 F7 FF FF 1A 20 10 9D E5 00 00 51 E3 5C FD FF 1A 18 20 9D E5 00 10 82 E5 5A 00 00 EA 08 00 A0 E1 04 10 A0 E1 08 20 8D E5 ?? ?? ?? ?? 00 00 50 E3 08 20 9D E5 6E FF FF 0A 76 FF FF EA 10 00 1B E3 03 B0 A0 11 00 10 94 15 00 30 96 15 24 00 00 1A 00 30 99 E5 00 20 94 E5 03 B0 A0 E1 00 20 D2 E5 00 10 96 E5 02 20 81 E0 01 20 D2 E5 08 00 12 E3 48 00 00 1A 04 20 94 E5 01 20 42 E2 04 20 84 E5 00 20 94 E5 01 10 D2 E4 01 A0 5A E2 01 10 CB E4 00 20 84 E5 3F 00 00 0A 04 10 94 E5 00 00 51 E3 ED FF FF CA 08 00 A0 E1 04 10 A0 E1 0C 30 8D E5 ?? ?? ?? ?? 00 00 50 E3 0C 30 9D E5 35 00 00 1A 00 20 94 E5 E4 FF FF EA 08 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 E5 FE FF 1A 00 30 96 E5 00 10 94 E5 00 20 D1 E5 02 20 83 E0 01 20 D2 E5 08 00 12 E3 01 10 81 E2 DD FE FF 1A 04 20 94 E5 01 B0 8B E2 01 20 42 E2 0B 00 5A E1 06 00 84 E8 D7 FE FF 0A 00 00 52 E3 F1 FF FF CA E9 FF FF EA 04 C2 9F E5 85 50 A0 E1 F5 50 9C E1 2E BD CB E3 27 FF FF EA 02 0B 1B E3 25 FF FF 0A 00 00 55 E3 02 BC 8B 03 08 50 85 02 01 0B 1B E3 16 BD CB 13 1F FF FF 1A 18 10 9D E5 00 00 57 E3 01 10 81 E2 01 70 47 12 01 A0 8A 12 0E BD CB E3 18 10 8D E5 18 FF FF EA 07 50 A0 E1 20 70 9D E5 18 20 9D E5 00 00 52 E3 FE FC FF 1A 14 30 9D E5 01 30 83 E2 14 30 8D E5 FA FC FF EA 05 50 63 E0 00 30 A0 E3 00 30 CB E5 14 A0 9D E5 01 A0 8A E2 05 50 8B E0 04 90 89 E2 14 A0 8D E5 F1 FC FF EA 00 20 CC E5 08 00 A0 E1 0C C0 8D E5 4A 1F 8D E2 10 30 9D E5 1C A0 9D E5 0F E0 A0 E1 1A FF 2F E1 20 00 1B E3 0C C0 9D E5 04 00 00 1A 04 00 1B E3 00 30 99 15 04 90 89 12 B0 00 C3 11 02 00 00 1A 00 30 99 E5 00 00 83 E5 04 90 89 E2 14 00 9D E5 01 00 80 E2 14 00 8D E5 0E FF FF EA 20 C0 9D E5 00 00 5C E3 18 00 9D 05 04 00 80 02 0B 50 85 E0 18 00 8D 05 20 B0 9D 05 01 A0 4A E2 00 B0 A0 11 04 30 94 E5 00 00 53 E3 31 FF FF CA 08 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 2C FF FF 0A 00 00 5B E3 02 FD FF 1A 66 FF FF EA 01 10 7C E5 08 00 A0 E1 04 20 A0 E1 0C C0 8D E5 ?? ?? ?? ?? 0C C0 9D E5 EE FE FF EA 0B 30 A0 E1 03 00 5C E1 0C B0 A0 E1 F6 FC FF 0A 0B B0 53 E0 DB FC FF 0A 00 20 A0 E3 00 20 C3 E5 14 10 9D E5 01 10 81 E2 04 90 89 E2 14 10 8D E5 0B 50 85 E0 B1 FC FF EA 00 00 5B E3 6B FE FF 1A D0 FC FF EA 0B 30 A0 E1 0C B0 A0 E1 EF FF FF EA 00 00 5B E3 0C 50 A0 E1 64 FE FF 1A E2 FC FF EA 00 10 99 E5 0A 30 A0 E1 08 00 A0 E1 01 20 A0 E3 00 40 8D E5 ?? ?? ?? ?? 00 00 50 E3 DA FC FF 0A 14 A0 9D E5 01 A0 8A E2 05 50 80 E0 04 90 89 E2 14 A0 8D E5 99 FC FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_410_0_0 {
	meta:
		name = "argz_append"
		size = 88
		refs = "002c realloc 004c memcpy"
	strings:
		$1 = { F0 40 2D E9 00 40 53 E2 00 50 A0 E1 02 60 A0 E1 04 00 A0 01 F0 80 BD 08 00 70 91 E5 07 30 84 E0 00 30 81 E5 00 00 95 E5 03 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 00 00 85 E5 0C 00 A0 03 F0 80 BD 08 07 00 80 E0 06 10 A0 E1 04 20 A0 E1 ?? ?? ?? ?? 00 00 A0 E3 F0 80 BD E8 }
	condition:
		$1
}

rule file_411_0_0 {
	meta:
		name = "strupr"
		size = 64
		refs = "003c __ctype_ptr__"
	strings:
		$1 = { 00 30 D0 E5 00 00 53 E3 1E FF 2F 01 28 C0 9F E5 00 20 A0 E1 00 10 9C E5 03 10 81 E0 01 10 D1 E5 02 00 11 E3 20 30 43 12 00 30 C2 15 01 30 F2 E5 00 00 53 E3 F6 FF FF 1A 1E FF 2F E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_414_1_0 {
	meta:
		name = "__sseek"
		size = 52
		refs = "000c _lseek_r"
	strings:
		$1 = { 10 40 2D E9 01 40 A0 E1 FE 10 D1 E1 ?? ?? ?? ?? 01 00 70 E3 BC 30 D4 01 BC 30 D4 11 01 3A C3 03 01 3A 83 13 BC 30 C4 01 BC 30 C4 11 50 00 84 15 10 80 BD E8 }
	condition:
		$1
}

rule file_414_2_0 {
	meta:
		name = "__swrite"
		size = 84
		refs = "002c _lseek_r 0050 _write_r"
	strings:
		$1 = { F0 40 2D E9 01 40 A0 E1 BC 10 D1 E1 01 0C 11 E3 02 60 A0 E1 03 50 A0 E1 00 70 A0 E1 04 00 00 0A FE 10 D4 E1 00 20 A0 E3 02 30 A0 E3 ?? ?? ?? ?? BC 10 D4 E1 01 1A C1 E3 BC 10 C4 E1 FE 10 D4 E1 07 00 A0 E1 06 20 A0 E1 05 30 A0 E1 F0 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_414_3_0 {
	meta:
		name = "__sread"
		size = 48
		refs = "000c _read_r"
	strings:
		$1 = { 10 40 2D E9 01 40 A0 E1 FE 10 D1 E1 ?? ?? ?? ?? 00 00 50 E3 50 30 94 A5 BC 30 D4 B1 00 30 83 A0 01 3A C3 B3 50 30 84 A5 BC 30 C4 B1 10 80 BD E8 }
	condition:
		$1
}

rule file_416_0_0 {
	meta:
		name = "ispunct"
		size = 28
		refs = "0018 __ctype_ptr__"
	strings:
		$1 = { 10 30 9F E5 00 30 93 E5 00 30 83 E0 01 00 D3 E5 10 00 00 E2 1E FF 2F E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_418_0_0 {
	meta:
		name = "wcpcpy"
		size = 36
	strings:
		$1 = { 00 30 A0 E1 00 20 A0 E3 02 00 91 E7 00 00 50 E3 02 00 83 E7 02 00 83 E0 04 20 82 E2 F9 FF FF 1A 1E FF 2F E1 }
	condition:
		$1
}

rule file_419_0_0 {
	meta:
		name = "__dtoa"
		size = 80
		refs = "0040 _dtoa_r 004c _impure_ptr"
	strings:
		$1 = { 04 E0 2D E5 40 C0 9F E5 10 D0 4D E2 00 E0 9C E5 02 C0 A0 E1 00 30 8D E5 0C 30 A0 E1 14 C0 9D E5 04 C0 8D E5 18 C0 9D E5 08 C0 8D E5 1C C0 9D E5 01 20 A0 E1 00 10 A0 E1 0E 00 A0 E1 0C C0 8D E5 ?? ?? ?? ?? 10 D0 8D E2 00 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_420_0_0 {
	meta:
		name = "_seed48_r"
		size = 112
	strings:
		$1 = { 04 40 2D E5 60 30 9F E5 BC 2A D0 E1 B0 20 C3 E1 BE 4A D0 E1 B2 40 C3 E1 B0 2B D0 E1 B4 20 C3 E1 B0 40 D1 E1 BC 4A C0 E1 B2 40 D1 E1 BE 4A C0 E1 21 2C E0 E3 B4 10 D1 E1 13 20 42 E2 66 CD E0 E3 B4 2B C0 E1 12 C0 4C E2 0B 20 A0 E3 05 40 A0 E3 B0 1B C0 E1 B2 CB C0 E1 B8 2B C0 E1 B6 4B C0 E1 03 00 A0 E1 10 00 BD E8 1E FF 2F E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_420_1_0 {
	meta:
		name = "seed48"
		size = 124
		refs = "0074 _impure_ptr"
	strings:
		$1 = { 04 40 2D E5 68 30 9F E5 00 30 93 E5 64 20 9F E5 BC 1A D3 E1 B0 10 C2 E1 BE 4A D3 E1 B2 40 C2 E1 B0 1B D3 E1 B4 10 C2 E1 B0 40 D0 E1 BC 4A C3 E1 B2 40 D0 E1 BE 4A C3 E1 21 1C E0 E3 B4 00 D0 E1 13 10 41 E2 66 CD E0 E3 12 C0 4C E2 B4 1B C3 E1 05 40 A0 E3 0B 10 A0 E3 B0 0B C3 E1 B2 CB C3 E1 B8 1B C3 E1 B6 4B C3 E1 02 00 A0 E1 10 00 BD E8 1E FF 2F E1 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_421_0_0 {
	meta:
		name = "_wcrtomb_r"
		size = 72
		refs = "0018 _wctomb_r"
	strings:
		$1 = { 30 40 2D E9 00 C0 51 E2 0C D0 4D E2 00 40 A0 E1 03 50 A0 E1 07 00 00 0A ?? ?? ?? ?? 01 00 70 E3 00 30 A0 03 00 30 85 05 8A 30 A0 03 00 30 84 05 0C D0 8D E2 30 80 BD E8 0C 20 A0 E1 0D 10 A0 E1 ?? ?? ?? ?? F4 FF FF EA }
	condition:
		$1
}

rule file_422_1_0 {
	meta:
		name = "_vfprintf_r"
		size = 8012
		refs = "001c _localeconv_r 03bc _vfprintf_r 03d4 _fflush_r 0408 __sinit 0720 __isinfd 073c __ltdf2 0930 memchr 0eb8 __eqdf2 1190 __nedf2 1858 __isnand 192c _dtoa_r 1c24 strlen 1c70 __swsetup_r"
	strings:
		$1 = { F0 4F 2D E9 55 DE 4D E2 0C D0 4D E2 01 B0 A0 E1 02 70 A0 E1 03 90 A0 E1 20 00 8D E5 ?? ?? ?? ?? 20 10 9D E5 00 00 90 E5 00 00 51 E3 5C 00 8D E5 02 00 00 0A 38 30 91 E5 00 00 53 E3 F0 00 00 0A BC 20 DB E1 02 0A 12 E3 02 30 A0 E1 05 00 00 1A 64 30 9B E5 02 2A 82 E3 02 3A C3 E3 BC 20 CB E1 64 30 8B E5 02 30 A0 E1 08 00 13 E3 FD 06 00 0A 10 10 9B E5 00 00 51 E3 FA 06 00 0A 1A 30 03 E2 0A 00 53 E3 B2 00 00 0A 05 CC 8D E2 13 6D 8D E2 08 C0 8C E2 46 0E 8D E2 00 30 A0 E3 00 20 A0 E3 00 40 A0 E3 08 60 86 E2 28 C0 8C E2 07 00 80 E2 34 25 8D E5 30 65 8D E5 38 25 8D E5 30 30 8D E5 50 40 8D E5 4C 30 8D E5 58 30 8D E5 54 30 8D E5 28 30 8D E5 48 C0 8D E5 10 00 8D E5 00 30 D7 E5 00 00 53 E3 25 00 53 13 17 00 00 0A 07 80 A0 E1 01 30 F8 E5 25 00 53 E3 00 00 53 13 FB FF FF 1A 07 A0 58 E0 08 70 A0 01 0F 00 00 0A 34 45 9D E5 38 55 9D E5 01 40 84 E2 0A 50 85 E0 07 00 54 E3 00 70 86 E5 38 55 8D E5 04 A0 86 E5 34 45 8D E5 70 00 00 CA 28 10 9D E5 0A 10 81 E0 00 30 D8 E5 28 10 8D E5 08 60 86 E2 08 70 A0 E1 00 00 53 E3 70 00 00 0A 00 20 A0 E3 01 30 87 E2 00 70 A0 E3 24 20 8D E5 5B 75 CD E5 18 90 8D E5 14 20 8D E5 00 40 E0 E3 2B 10 A0 E3 20 C0 A0 E3 03 70 A0 E1 01 20 D7 E4 20 30 42 E2 58 00 53 E3 03 F1 9F 97 18 01 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 20 00 9D E5 0B 10 A0 E1 53 2E 8D E2 31 FF FF EB 00 00 50 E3 07 00 00 1A 13 6D 8D E2 86 FF FF EA 38 35 9D E5 00 00 53 E3 20 00 9D 15 0B 10 A0 11 53 2E 8D 12 27 FF FF 1B BC 30 DB E1 40 00 13 E3 01 00 00 0A 00 10 E0 E3 28 10 8D E5 28 00 9D E5 57 DF 8D E2 01 DB 8D E2 F0 8F BD E8 FE 30 DB E1 00 00 53 E3 49 FF FF BA 01 5B A0 E3 02 E0 C2 E3 07 20 A0 E1 05 70 8D E0 BC E6 C7 E1 00 E0 A0 E3 78 E4 8D E5 BE E0 DB E1 1C 60 9B E5 24 80 9B E5 6C C0 8D E2 46 4E 8D E2 0C C0 4C E2 09 30 A0 E1 20 00 9D E5 04 10 A0 E1 BE E6 C7 E1 7C 64 8D E5 84 84 8D E5 70 C4 8D E5 74 54 8D E5 60 C4 8D E5 68 54 8D E5 ?? ?? ?? ?? 00 00 50 E3 28 00 8D E5 06 00 00 BA 20 00 9D E5 04 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 28 00 9D E5 00 00 E0 13 28 00 8D E5 01 1B 8D E2 BC 36 D1 E1 40 00 13 E3 BC 30 DB 11 40 30 83 13 BC 30 CB 11 CF FF FF EA 01 00 A0 E1 ?? ?? ?? ?? 0B FF FF EA 40 20 8D E5 14 20 9D E5 80 1F 9F E5 10 00 12 E3 58 10 8D E5 9A 01 00 0A 18 C0 9D E5 00 30 9C E5 04 90 8C E2 14 C0 9D E5 00 10 53 E2 01 10 A0 13 01 00 1C E1 14 10 9D 15 40 00 9D 15 30 20 A0 13 02 10 81 13 59 05 CD 15 58 25 CD 15 14 10 8D 15 02 20 A0 E3 01 10 A0 13 00 C0 A0 E3 5B C5 CD E5 00 00 54 E3 14 00 9D A5 80 00 C0 A3 14 00 8D A5 00 00 54 E3 01 10 81 13 00 00 51 E3 CD 02 00 0A 01 00 52 E3 CD 03 00 0A 02 00 52 E3 B1 03 00 0A 48 10 9D E5 34 10 8D E5 07 20 03 E2 30 20 82 E2 A3 31 B0 E1 01 20 61 E5 FA FF FF 1A 14 30 9D E5 01 00 13 E3 34 10 8D E5 23 04 00 1A 48 C0 9D E5 0C C0 61 E0 2C C0 8D E5 2C 10 9D E5 04 00 51 E1 04 10 A0 B1 1C 10 8D E5 44 40 8D E5 18 90 8D E5 5B 35 DD E5 00 00 53 E3 02 00 00 0A 1C 20 9D E5 01 20 82 E2 1C 20 8D E5 14 30 9D E5 02 30 13 E2 1C C0 9D 15 14 00 9D E5 02 C0 8C 12 1C C0 8D 15 84 00 10 E2 3C 30 8D E5 38 00 8D E5 7D 01 00 1A 24 10 9D E5 1C 20 9D E5 01 80 62 E0 00 00 58 E3 78 01 00 DA 10 00 58 E3 BD 05 00 DA 34 45 9D E5 38 55 9D E5 04 30 A0 E1 64 AE 9F E5 10 90 A0 E3 20 40 9D E5 03 00 00 EA 10 80 48 E2 10 00 58 E3 08 60 86 E2 14 00 00 DA 01 30 83 E2 10 50 85 E2 07 00 53 E3 00 A0 86 E5 04 90 86 E5 38 55 8D E5 34 35 8D E5 F3 FF FF DA 04 00 A0 E1 0B 10 A0 E1 53 2E 8D E2 89 FE FF EB 00 00 50 E3 5F FF FF 1A 10 80 48 E2 13 6D 8D E2 10 00 58 E3 38 55 9D E5 34 35 9D E5 08 60 86 E2 EA FF FF CA 03 40 A0 E1 01 40 84 E2 08 50 85 E0 07 00 54 E3 00 A0 86 E5 04 80 86 E5 38 55 8D E5 34 45 8D E5 83 02 00 CA 08 60 86 E2 4D 01 00 EA 00 00 52 E3 40 20 8D E5 44 FF FF 0A 40 30 9D E5 05 0C 8D E2 01 20 A0 E3 00 C0 A0 E3 08 00 80 E2 1C 20 8D E5 08 35 CD E5 5B C5 CD E5 2C 20 8D E5 34 00 8D E5 00 20 A0 E3 44 20 8D E5 B3 FF FF EA 5B 35 DD E5 00 00 53 E3 D6 03 00 1A 18 20 9D E5 5B C5 CD E5 07 30 A0 E1 18 20 8D E5 C8 FE FF EA 14 00 8D E2 05 00 90 E8 01 00 80 E3 14 00 8D E5 07 30 A0 E1 18 20 8D E5 C1 FE FF EA 18 20 9D E5 00 20 92 E5 18 30 9D E5 00 00 52 E3 24 20 8D E5 04 20 83 E2 09 05 00 BA 07 30 A0 E1 18 20 8D E5 B7 FE FF EA 18 20 9D E5 5B 15 CD E5 07 30 A0 E1 18 20 8D E5 B2 FE FF EA 14 30 9D E5 10 30 83 E3 14 30 8D E5 14 C0 9D E5 10 00 1C E3 40 20 8D E5 0D 01 00 0A 18 00 9D E5 00 30 90 E5 04 90 80 E2 00 00 53 E3 A8 03 00 BA 00 10 A0 03 01 10 A0 13 01 20 A0 E3 5F FF FF EA 14 E0 9D E5 08 00 1E E3 40 20 8D E5 18 30 9D E5 AA 03 00 0A 20 01 93 E8 08 00 83 E2 18 00 8D E5 30 50 8D E5 50 80 8D E5 05 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 A0 50 E2 48 04 00 0A 00 30 A0 E3 08 10 A0 E1 00 20 A0 E3 05 00 A0 E1 ?? ?? ?? ?? 03 20 A0 E3 00 00 50 E3 40 C0 9D E5 2D 30 A0 B3 1C 20 8D E5 48 2C 9F E5 48 1C 9F E5 14 00 9D E5 5B 35 DD A5 5B 35 CD B5 47 00 5C E3 02 10 A0 D1 34 10 8D E5 80 00 C0 E3 03 10 A0 E3 00 20 A0 E3 14 00 8D E5 2C 10 8D E5 44 20 8D E5 58 FF FF EA 14 20 9D E5 08 20 82 E3 14 20 8D E5 18 20 9D E5 07 30 A0 E1 18 20 8D E5 73 FE FF EA 14 30 9D E5 10 30 83 E3 14 30 8D E5 14 C0 9D E5 40 20 8D E5 10 20 1C E2 27 00 00 0A 18 00 9D E5 00 30 90 E5 04 90 80 E2 00 10 53 E2 01 10 A0 13 00 20 A0 E3 20 FF FF EA 18 20 9D E5 14 30 9D E5 04 30 83 E3 14 30 8D E5 07 30 A0 E1 A5 FF FF EA 14 30 9D E5 18 20 9D E5 40 30 83 E3 14 30 8D E5 18 20 8D E5 07 30 A0 E1 58 FE FF EA 14 00 8D E2 05 00 90 E8 10 00 80 E3 14 00 8D E5 07 30 A0 E1 18 20 8D E5 51 FE FF EA 14 C0 9D E5 10 00 1C E3 69 03 00 0A 18 00 9D E5 28 10 9D E5 00 30 90 E5 04 90 80 E2 00 10 83 E5 20 FE FF EA 14 C0 9D E5 40 20 8D E5 10 20 1C E2 D7 FF FF 1A 14 30 9D E5 40 10 13 E2 69 03 00 0A 18 C0 9D E5 B0 30 DC E1 04 90 8C E2 00 10 53 E2 01 10 A0 13 F6 FE FF EA 18 10 9D E5 78 20 A0 E3 14 C0 9D E5 00 30 91 E5 40 20 8D E5 59 25 CD E5 18 00 9D E5 F0 2A 9F E5 30 10 A0 E3 02 C0 8C E3 58 15 CD E5 58 20 8D E5 14 C0 8D E5 00 10 53 E2 01 10 A0 13 04 90 80 E2 02 20 A0 E3 E4 FE FF EA 14 20 9D E5 10 20 82 E3 14 20 8D E5 18 20 9D E5 07 30 A0 E1 18 20 8D E5 22 FE FF EA 00 30 A0 E3 5B 35 CD E5 18 30 9D E5 18 C0 9D E5 00 30 93 E5 04 C0 8C E2 00 00 53 E3 40 20 8D E5 34 30 8D E5 18 C0 8D E5 DA 04 00 0A 00 00 54 E3 BE 04 00 BA 34 00 9D E5 00 10 A0 E3 04 20 A0 E1 ?? ?? ?? ?? 00 00 50 E3 FA 04 00 0A 34 20 9D E5 00 00 62 E0 04 00 50 E1 2C 00 8D E5 52 04 00 DA 2C 40 8D E5 00 C0 A0 E3 C4 4F C4 E1 1C 40 8D E5 5B 35 DD E5 44 C0 8D E5 E1 FE FF EA 14 10 9D E5 10 00 11 E3 40 20 8D E5 35 00 00 0A 18 20 9D E5 00 30 92 E5 04 90 82 E2 00 10 53 E2 01 10 A0 13 01 20 A0 E3 B3 FE FF EA 14 00 8D E2 05 00 90 E8 80 00 80 E3 14 00 8D E5 07 30 A0 E1 18 20 8D E5 F1 FD FF EA 07 30 A0 E1 01 20 D3 E4 2A 00 52 E3 46 05 00 0A 30 00 42 E2 09 00 50 E3 00 40 A0 83 0A 00 00 8A 02 70 87 E2 00 40 A0 E3 01 20 57 E5 04 41 84 E0 84 40 80 E0 30 00 42 E2 09 00 50 E3 07 30 A0 E1 01 70 87 E2 F7 FF FF 9A C4 4F 84 E1 03 70 A0 E1 DE FD FF EA 30 00 42 E2 00 50 A0 E3 07 30 A0 E1 01 20 D3 E4 05 51 85 E0 85 50 80 E0 30 00 42 E2 09 00 50 E3 F9 FF FF 9A 24 50 8D E5 03 70 A0 E1 D2 FD FF EA 14 00 9D E5 10 00 80 E3 14 00 8D E5 14 10 9D E5 10 00 11 E3 40 20 8D E5 C9 FF FF 1A 14 30 9D E5 40 00 13 E3 DA 02 00 0A 18 C0 9D E5 B0 30 DC E1 04 90 8C E2 00 10 53 E2 01 10 A0 13 01 20 A0 E3 7A FE FF EA 40 20 8D E5 14 20 9D E5 20 C9 9F E5 10 00 12 E3 58 C0 8D E5 64 FE FF 1A 14 00 9D E5 40 00 10 E3 18 10 9D 15 18 20 9D 05 B0 30 D1 11 04 90 81 12 00 30 92 05 04 90 82 02 5E FE FF EA 18 C0 9D E5 40 20 8D E5 00 30 9C E5 05 2C 8D E2 01 00 A0 E3 00 10 A0 E3 04 C0 8C E2 08 20 82 E2 1C 00 8D E5 08 35 CD E5 5B 15 CD E5 18 C0 8D E5 2C 00 8D E5 34 20 8D E5 CD FE FF EA 14 C0 9D E5 10 00 1C E3 40 20 8D E5 F1 FE FF 1A 14 10 9D E5 40 00 11 E3 18 20 9D 15 18 C0 9D 05 F0 30 D2 11 04 90 82 12 00 30 9C 05 04 90 8C 02 EB FE FF EA 38 55 9D E5 34 45 9D E5 5B 35 DD E5 00 00 53 E3 0B 00 00 0A 55 3E 8D E2 01 40 84 E2 0B 30 83 E2 01 50 85 E2 00 30 86 E5 07 00 54 E3 01 30 A0 E3 04 30 86 E5 38 55 8D E5 34 45 8D E5 9A 00 00 CA 08 60 86 E2 3C 30 9D E5 00 00 53 E3 0B 00 00 0A 55 3E 8D E2 01 40 84 E2 08 30 83 E2 02 50 85 E2 00 30 86 E5 07 00 54 E3 02 30 A0 E3 04 30 86 E5 38 55 8D E5 34 45 8D E5 95 00 00 CA 08 60 86 E2 38 C0 9D E5 80 00 5C E3 22 01 00 0A 44 20 9D E5 2C 30 9D E5 02 80 63 E0 00 00 58 E3 2A 00 00 DA 10 00 58 E3 E4 A7 9F D5 1E 00 00 DA 04 30 A0 E1 D8 A7 9F E5 10 90 A0 E3 20 40 9D E5 03 00 00 EA 10 80 48 E2 10 00 58 E3 08 60 86 E2 14 00 00 DA 01 30 83 E2 10 50 85 E2 07 00 53 E3 00 A0 86 E5 04 90 86 E5 38 55 8D E5 34 35 8D E5 F3 FF FF DA 04 00 A0 E1 0B 10 A0 E1 53 2E 8D E2 E9 FC FF EB 00 00 50 E3 BF FD FF 1A 10 80 48 E2 13 6D 8D E2 10 00 58 E3 38 55 9D E5 34 35 9D E5 08 60 86 E2 EA FF FF CA 03 40 A0 E1 01 40 84 E2 08 50 85 E0 07 00 54 E3 00 A0 86 E5 04 80 86 E5 38 55 8D E5 34 45 8D E5 7F 00 00 CA 08 60 86 E2 14 C0 9D E5 01 0C 1C E3 86 00 00 1A 2C 00 9D E5 01 40 84 E2 34 10 9D E5 00 50 85 E0 07 00 54 E3 00 10 86 E5 04 00 86 E5 38 55 8D E5 34 45 8D E5 67 00 00 CA 08 60 86 E2 14 00 9D E5 04 00 10 E3 37 00 00 0A 24 10 9D E5 1C 20 9D E5 01 80 62 E0 00 00 58 E3 32 00 00 DA 10 00 58 E3 34 45 9D D5 E8 A6 9F D5 1F 00 00 DA 34 45 9D E5 DC A6 9F E5 04 30 A0 E1 10 90 A0 E3 20 40 9D E5 03 00 00 EA 10 80 48 E2 10 00 58 E3 08 60 86 E2 14 00 00 DA 01 30 83 E2 10 50 85 E2 07 00 53 E3 00 A0 86 E5 04 90 86 E5 38 55 8D E5 34 35 8D E5 F3 FF FF DA 04 00 A0 E1 0B 10 A0 E1 53 2E 8D E2 A6 FC FF EB 00 00 50 E3 7C FD FF 1A 10 80 48 E2 13 6D 8D E2 10 00 58 E3 38 55 9D E5 34 35 9D E5 08 60 86 E2 EA FF FF CA 03 40 A0 E1 01 40 84 E2 05 50 88 E0 07 00 54 E3 00 A0 86 E5 04 80 86 E5 38 55 8D E5 34 45 8D E5 06 00 00 DA 20 00 9D E5 0B 10 A0 E1 53 2E 8D E2 90 FC FF EB 00 00 50 E3 66 FD FF 1A 38 55 9D E5 28 30 9D E5 1C 60 9D E5 24 C0 9D E5 0C 00 56 E1 06 30 83 A0 0C 30 83 B0 00 00 55 E3 28 30 8D E5 D1 00 00 1A 00 00 A0 E3 13 6D 8D E2 34 05 8D E5 18 90 9D E5 08 60 86 E2 C1 FC FF EA 20 00 9D E5 0B 10 A0 E1 53 2E 8D E2 7A FC FF EB 00 00 50 E3 50 FD FF 1A 38 55 9D E5 34 45 9D E5 13 6D 8D E2 5A FF FF EA 20 00 9D E5 0B 10 A0 E1 53 2E 8D E2 70 FC FF EB 00 00 50 E3 46 FD FF 1A 38 55 9D E5 34 45 9D E5 13 6D 8D E2 5F FF FF EA 03 40 A0 E1 01 40 84 E2 08 50 85 E0 07 00 54 E3 00 A0 86 E5 04 80 86 E5 38 55 8D E5 34 45 8D E5 97 FF FF DA 20 00 9D E5 0B 10 A0 E1 53 2E 8D E2 5D FC FF EB 00 00 50 E3 33 FD FF 1A 13 6D 8D E2 08 60 86 E2 38 55 9D E5 8E FF FF EA 20 00 9D E5 0B 10 A0 E1 53 2E 8D E2 53 FC FF EB 00 00 50 E3 29 FD FF 1A 13 6D 8D E2 38 55 9D E5 34 45 9D E5 08 60 86 E2 75 FF FF EA 40 20 9D E5 65 00 52 E3 9D 00 00 DA 30 00 9D E5 50 10 9D E5 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 F4 00 00 1A E8 34 9F E5 01 40 84 E2 01 50 85 E2 00 30 86 E5 07 00 54 E3 01 30 A0 E3 04 30 86 E5 38 55 8D E5 34 45 8D E5 10 02 00 CA 54 35 9D E5 4C C0 9D E5 0C 00 53 E1 08 60 86 E2 02 00 00 BA 14 00 9D E5 01 00 10 E3 67 FF FF 0A 34 45 9D E5 5C 10 9D E5 01 40 84 E2 01 50 85 E2 01 30 A0 E3 07 00 54 E3 0A 00 86 E8 38 55 8D E5 34 45 8D E5 31 03 00 CA 4C 20 9D E5 01 80 42 E2 00 00 58 E3 08 60 86 E2 58 FF FF DA 10 00 58 E3 34 45 9D D5 60 A4 9F D5 B3 FF FF DA 34 45 9D E5 54 A4 9F E5 04 30 A0 E1 10 90 A0 E3 20 40 9D E5 03 00 00 EA 10 80 48 E2 10 00 58 E3 08 60 86 E2 A8 FF FF DA 01 30 83 E2 10 50 85 E2 07 00 53 E3 00 A0 86 E5 04 90 86 E5 38 55 8D E5 34 35 8D E5 F3 FF FF DA 04 00 A0 E1 0B 10 A0 E1 53 2E 8D E2 07 FC FF EB 00 00 50 E3 DD FC FF 1A 38 55 9D E5 34 35 9D E5 13 6D 8D E2 E9 FF FF EA 00 00 52 E3 16 00 00 1A 14 10 9D E5 01 00 11 E3 13 00 00 0A 05 2C 8D E2 30 30 A0 E3 08 20 82 E2 2F 35 CD E5 27 20 82 E2 01 30 A0 E3 34 20 8D E5 2C 30 8D E5 35 FD FF EA }
	condition:
		$1
}

rule file_424_0_0 {
	meta:
		name = "_strtoul_r"
		size = 412
		refs = "008c __umodsi3 009c __udivsi3 0198 __ctype_ptr__"
	strings:
		$1 = { F0 4F 2D E9 01 50 A0 E1 88 11 9F E5 04 D0 4D E2 00 40 91 E5 00 00 8D E5 02 60 A0 E1 03 A0 A0 E1 05 80 A0 E1 01 70 D8 E4 07 30 84 E0 01 B0 D3 E5 08 B0 1B E2 FA FF FF 1A 2D 00 57 E3 49 00 00 0A 2B 00 57 E3 01 70 D8 04 01 30 7A E2 00 30 A0 33 00 00 5A E3 10 00 5A 13 09 00 00 1A 30 00 57 E3 43 00 00 0A 00 00 53 E3 05 00 00 0A 30 00 57 E3 08 A0 A0 03 0A A0 A0 13 07 90 A0 03 05 90 A0 13 03 00 00 EA 00 00 E0 E3 0A 10 A0 E1 ?? ?? ?? ?? 00 90 A0 E1 0A 10 A0 E1 00 00 E0 E3 ?? ?? ?? ?? 00 20 A0 E3 02 10 A0 E1 07 30 84 E0 01 30 D3 E5 04 00 13 E3 30 70 47 12 05 00 00 1A 03 00 13 E3 17 00 00 0A 01 00 13 E3 37 30 A0 13 57 30 A0 03 07 70 63 E0 0A 00 57 E1 11 00 00 AA 00 00 51 E1 00 30 A0 93 01 30 A0 83 A2 3F 93 E1 09 00 00 1A 09 00 57 E1 00 30 A0 D3 01 30 A0 C3 00 00 51 E1 00 30 A0 13 00 00 53 E3 9A 71 21 00 01 20 A0 03 01 70 D8 04 E3 FF FF 0A 00 20 E0 E3 01 70 D8 E4 E0 FF FF EA 01 00 72 E3 09 00 00 0A 00 00 5B E3 00 10 61 12 00 00 56 E3 02 00 00 0A 00 00 52 E3 01 50 48 12 00 50 86 E5 01 00 A0 E1 04 D0 8D E2 F0 8F BD E8 00 10 9D E5 22 30 A0 E3 00 30 81 E5 02 10 A0 E1 F2 FF FF EA 01 70 D8 E4 01 B0 A0 E3 B4 FF FF EA 00 20 D8 E5 78 00 52 E3 58 00 52 13 B7 FF FF 1A 01 70 D8 E5 0F 90 A0 E3 02 80 88 E2 10 A0 A0 E3 BE FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_425_0_0 {
	meta:
		name = "ldiv"
		size = 108
		refs = "0018 __divsi3 0028 __modsi3"
		altNames = "div"
	strings:
		$1 = { F0 40 2D E9 01 40 A0 E1 00 50 A0 E1 02 10 A0 E1 04 00 A0 E1 02 60 A0 E1 ?? ?? ?? ?? 06 10 A0 E1 00 70 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 00 54 E3 06 00 00 BA 00 00 50 E3 00 00 66 B0 01 70 87 B2 04 00 85 E5 00 70 85 E5 05 00 A0 E1 F0 80 BD E8 00 00 50 E3 06 00 80 C0 01 70 47 C2 04 00 85 E5 00 70 85 E5 05 00 A0 E1 F0 80 BD E8 }
	condition:
		$1
}

rule file_426_0_0 {
	meta:
		name = "_wrapup_reent"
		size = 112
		refs = "006c _impure_ptr"
	strings:
		$1 = { F0 40 2D E9 00 70 50 E2 5C 30 9F 05 00 70 93 05 48 61 97 E5 00 00 56 E3 0C 00 00 0A 04 50 96 E5 01 40 55 E2 06 00 00 4A 02 50 85 E2 05 51 86 E0 04 30 35 E5 0F E0 A0 E1 13 FF 2F E1 01 40 54 E2 FA FF FF 5A 00 60 96 E5 00 00 56 E3 F2 FF FF 1A 3C 30 97 E5 00 00 53 E3 F0 80 BD 08 07 00 A0 E1 0F E0 A0 E1 13 FF 2F E1 F0 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_426_1_0 {
	meta:
		name = "cleanup_glue"
		size = 40
		refs = "0014 cleanup_glue 0024 _free_r"
	strings:
		$1 = { 30 40 2D E9 01 40 A0 E1 00 10 91 E5 00 00 51 E3 00 50 A0 E1 ?? ?? ?? ?? 05 00 A0 E1 04 10 A0 E1 30 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_426_2_0 {
	meta:
		name = "_reclaim_reent"
		size = 236
		refs = "003c _free_r 00e4 cleanup_glue 00e8 _impure_ptr"
	strings:
		$1 = { E0 30 9F E5 00 30 93 E5 03 00 50 E1 70 40 2D E9 00 50 A0 E1 70 80 BD 08 4C 30 90 E5 00 00 53 E3 0F 00 00 0A 00 60 A0 E3 06 10 93 E7 00 00 51 E3 05 00 00 0A 00 40 91 E5 05 00 A0 E1 ?? ?? ?? ?? 00 10 54 E2 FA FF FF 1A 4C 30 95 E5 04 60 86 E2 3C 00 56 E3 F3 FF FF 1A 03 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 40 10 95 E5 00 00 51 E3 05 00 A0 11 ?? ?? ?? ?? 48 11 95 E5 00 00 51 E3 09 00 00 0A 53 6F 85 E2 06 00 51 E1 01 00 00 1A 05 00 00 EA 04 10 A0 E1 00 40 91 E5 05 00 A0 E1 ?? ?? ?? ?? 04 00 56 E1 F9 FF FF 1A 54 10 95 E5 00 00 51 E3 05 00 A0 11 ?? ?? ?? ?? 38 30 95 E5 00 00 53 E3 70 80 BD 08 05 00 A0 E1 0F E0 A0 E1 3C F0 95 E5 E0 12 95 E5 00 00 51 E3 70 80 BD 08 05 00 A0 E1 70 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_427_0_0 {
	meta:
		name = "wcswidth"
		size = 104
		refs = "0054 wcwidth"
	strings:
		$1 = { 00 00 50 E3 00 00 51 13 F0 40 2D E9 01 40 A0 E1 00 50 A0 E1 00 70 A0 13 01 70 A0 03 00 60 A0 03 01 00 00 1A 06 00 A0 E1 F0 80 BD E8 07 60 A0 E1 06 00 00 EA 07 30 95 E7 00 00 53 E3 00 60 86 E0 F7 FF FF 0A 01 40 54 E2 04 70 87 E2 F4 FF FF 0A 07 00 95 E7 ?? ?? ?? ?? 00 00 50 E3 F4 FF FF AA 00 60 E0 E3 EE FF FF EA }
	condition:
		$1
}

rule file_428_0_0 {
	meta:
		name = "isxdigit"
		size = 28
		refs = "0018 __ctype_ptr__"
	strings:
		$1 = { 10 30 9F E5 00 30 93 E5 00 30 83 E0 01 00 D3 E5 44 00 00 E2 1E FF 2F E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_429_0_0 {
	meta:
		name = "finitef"
		size = 28
	strings:
		$1 = { 02 31 E0 E3 03 00 00 E0 02 35 43 E2 03 00 50 E1 00 00 A0 C3 01 00 A0 D3 1E FF 2F E1 }
	condition:
		$1
}

rule file_430_0_0 {
	meta:
		name = "__fix_locale_grouping_str"
		size = 248
		refs = "00f0 __ctype_ptr__"
	strings:
		$1 = { 00 00 50 E3 70 00 2D E9 2F 00 00 0A 00 30 D0 E5 00 00 53 E3 2C 00 00 0A D0 50 9F E5 00 C0 A0 E1 00 10 A0 E1 00 60 E0 E3 18 00 00 EA 00 20 95 E5 03 40 82 E0 01 40 D4 E5 04 00 14 E3 22 00 00 0A 01 40 D1 E5 04 20 82 E0 01 20 D2 E5 30 30 43 E2 04 00 12 E3 FF 30 03 E2 03 31 83 10 83 30 84 10 30 30 43 12 FF 30 03 12 01 20 81 E2 01 20 A0 01 00 00 53 E3 00 30 CC E5 18 00 00 0A 01 C0 8C E2 01 30 D2 E5 00 00 53 E3 01 10 82 E2 11 00 00 0A 3B 00 53 E3 01 20 A0 01 F8 FF FF 0A 2D 00 53 E3 E1 FF FF 1A 01 20 D1 E5 31 00 52 E3 01 60 CC 04 01 20 81 E2 F1 FF FF 0A 00 20 95 E5 03 40 82 E0 01 40 D4 E5 04 00 14 E3 DC FF FF 1A 20 00 9F E5 70 00 BD E8 1E FF 2F E1 00 30 CC E5 FB FF FF EA 0C 30 9F E5 00 00 5C E1 03 00 A0 01 F7 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_431_0_0 {
	meta:
		name = "a64l"
		size = 156
	strings:
		$1 = { 00 10 50 E2 01 00 A0 01 1E FF 2F 01 01 30 A0 E1 00 20 A0 E3 00 00 D3 E5 01 20 82 E2 00 00 50 E3 01 30 83 12 06 00 52 E3 F9 FF FF 1A 03 00 51 E1 00 00 A0 23 1E FF 2F 21 00 00 A0 E3 01 20 53 E5 5A 00 52 E3 0E 00 00 8A 41 00 52 E3 35 20 42 22 06 00 00 2A 2F 00 52 E3 01 20 A0 03 03 00 00 0A 0B 00 00 3A 39 00 52 E3 09 00 00 8A 2E 20 42 E2 01 30 43 E2 03 00 51 E1 00 03 82 E0 EE FF FF 3A 1E FF 2F E1 61 C0 42 E2 19 00 5C E3 1B 20 42 92 F6 FF FF 9A 00 20 A0 E3 F4 FF FF EA }
	condition:
		$1
}

rule file_432_1_0 {
	meta:
		name = "_fputc_r"
		size = 64
		refs = "0024 __sinit 003c _putc_r"
	strings:
		$1 = { 10 40 2D E9 00 40 50 E2 08 D0 4D E2 07 00 00 0A 38 30 94 E5 00 00 53 E3 04 00 00 1A 04 10 8D E5 00 20 8D E5 ?? ?? ?? ?? 00 20 9D E5 04 10 9D E5 04 00 A0 E1 08 D0 8D E2 10 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_436_0_0 {
	meta:
		name = "_system_r"
		size = 32
		refs = "000c __errno"
	strings:
		$1 = { 00 00 51 E2 04 E0 2D E5 04 F0 9D 04 ?? ?? ?? ?? 58 30 A0 E3 00 30 80 E5 00 00 E0 E3 04 F0 9D E4 }
	condition:
		$1
}

rule file_437_0_0 {
	meta:
		name = "qsort"
		size = 2328
		refs = "01c4 __udivsi3 04a0 qsort"
	strings:
		$1 = { F0 4F 2D E9 00 70 A0 E1 1C D0 4D E2 08 10 8D E5 03 00 17 E3 22 11 A0 E1 02 50 A0 E1 03 60 A0 E1 0C 10 8D E5 00 40 62 E2 69 00 00 1A 03 00 15 E3 67 00 00 1A 08 20 9D E5 04 B0 55 E2 01 B0 A0 13 06 00 52 E3 66 00 00 9A 08 20 9D E5 A2 90 A0 E1 95 79 29 E0 07 00 52 E3 09 80 A0 01 06 A0 A0 03 13 00 00 0A 08 30 9D E5 01 A0 43 E2 95 7A 21 E0 28 00 53 E3 00 10 8D E5 09 80 A0 91 04 70 8D 95 36 01 00 8A 04 00 9D E5 08 10 A0 E1 0F E0 A0 E1 16 FF 2F E1 00 00 50 E3 1A 01 00 BA 08 00 A0 E1 00 10 9D E5 0F E0 A0 E1 16 FF 2F E1 00 00 50 E3 22 01 00 DA 00 00 5B E3 E5 00 00 1A 00 30 97 E5 00 20 98 E5 00 20 87 E5 00 30 88 E5 95 7A 2A E0 05 30 87 E0 00 10 A0 E3 10 30 8D E5 0A 00 8D E8 0A 80 A0 E1 03 90 A0 E1 08 00 59 E1 75 00 00 9A 00 30 9D E5 00 00 53 E3 B7 01 00 0A 04 30 9D E5 09 20 63 E0 03 10 67 E0 08 30 9D E5 95 73 23 E0 02 00 51 E1 02 10 A0 A1 00 00 51 E3 04 20 8D E5 00 30 8D E5 0A 00 00 DA 02 00 5B E3 09 20 61 E0 00 30 A0 03 49 01 00 1A 03 00 D7 E7 03 C0 D2 E7 03 C0 C7 E7 03 00 C2 E7 01 30 83 E2 03 00 51 E1 F8 FF FF 1A 00 20 9D E5 02 10 6A E0 0A 80 68 E0 01 10 65 E0 08 00 51 E1 08 10 A0 21 00 00 51 E3 0A 00 00 DA 02 00 5B E3 02 20 61 E0 00 30 A0 03 D5 00 00 1A 03 00 D9 E7 03 C0 D2 E7 03 C0 C9 E7 03 00 C2 E7 01 30 83 E2 01 00 53 E1 F8 FF FF 1A 04 30 9D E5 03 00 55 E1 B5 00 00 3A 08 00 55 E1 42 00 00 2A 00 20 9D E5 08 00 A0 E1 05 10 A0 E1 02 70 68 E0 ?? ?? ?? ?? 03 00 17 E3 08 00 8D E5 95 FF FF 0A 08 20 9D E5 06 00 52 E3 02 B0 A0 E3 98 FF FF 8A 95 72 22 E0 05 30 87 E0 02 00 53 E1 08 20 8D E5 31 00 00 2A 03 80 A0 E1 05 30 83 E0 00 30 8D E5 00 90 65 E2 08 00 57 E1 09 40 88 30 04 A0 A0 31 0B 00 00 3A 21 00 00 EA 04 30 69 E0 00 20 93 E5 00 10 9A E5 00 10 83 E5 00 20 8A E5 09 A0 8A E0 0A 30 69 E0 03 00 57 E1 18 00 00 2A 04 80 A0 E1 09 40 84 E0 04 00 A0 E1 08 10 A0 E1 0F E0 A0 E1 16 FF 2F E1 00 00 50 E3 10 00 00 DA 00 00 5B E3 EC FF FF 0A 01 00 5B E3 00 30 A0 13 9D 01 00 0A 03 20 D8 E7 03 10 D4 E7 03 10 C8 E7 03 20 C4 E7 01 30 83 E2 05 20 63 E0 00 00 52 E3 F7 FF FF CA 09 A0 8A E0 0A 30 69 E0 03 00 57 E1 E6 FF FF 3A 00 80 9D E5 08 10 9D E5 05 30 88 E0 00 30 8D E5 03 30 65 E0 03 00 51 E1 D1 FF FF 8A 1C D0 8D E2 F0 8F BD E8 09 00 A0 E1 07 10 A0 E1 0F E0 A0 E1 16 FF 2F E1 00 00 50 E3 0A 00 00 CA 40 00 00 EA 00 30 98 E5 00 20 9A E5 00 20 88 E5 00 30 8A E5 01 10 A0 E3 00 10 8D E5 04 A0 8A E0 04 80 88 E0 08 00 59 E1 78 FF FF 8A 08 00 A0 E1 07 10 A0 E1 0F E0 A0 E1 16 FF 2F E1 00 00 50 E3 0D 00 00 BA F5 FF FF 1A 00 00 5B E3 EC FF FF 0A 01 00 5B E3 15 00 00 0A 00 30 D8 E7 00 20 DA E7 00 20 C8 E7 00 30 CA E7 01 00 80 E2 05 30 60 E0 00 00 53 E3 F7 FF FF CA E5 FF FF EA 08 00 59 E1 62 FF FF 8A 00 00 5B E3 12 00 00 1A 00 30 99 E5 00 20 98 E5 00 20 89 E5 00 30 88 E5 01 20 A0 E3 05 90 89 E0 04 80 88 E0 00 20 8D E5 55 FF FF EA 0C 30 9D E5 00 20 98 E7 00 10 9A E7 01 30 43 E2 00 00 53 E3 00 10 88 E7 00 20 8A E7 04 00 80 E2 F7 FF FF CA CE FF FF EA 01 00 5B E3 00 30 A0 13 18 00 00 0A 03 20 D9 E7 03 10 D8 E7 03 10 C9 E7 03 20 C8 E7 01 30 83 E2 05 20 63 E0 00 00 52 E3 F7 FF FF CA E4 FF FF EA 0C 00 00 1A 00 00 5B E3 2C 00 00 1A 04 20 9D E5 04 10 9D E5 00 30 92 E5 00 20 99 E5 00 20 81 E5 00 30 89 E5 04 20 9D E5 01 30 A0 E3 05 20 82 E0 04 20 8D E5 00 30 8D E5 05 90 89 E0 2F FF FF EA 0C 20 9D E5 00 30 A0 E3 03 10 99 E7 03 00 98 E7 01 20 42 E2 00 00 52 E3 03 00 89 E7 03 10 88 E7 04 30 83 E2 F7 FF FF CA C9 FF FF EA 01 00 5B E3 00 30 A0 13 8A 00 00 0A 03 20 D7 E7 03 10 D8 E7 03 10 C7 E7 03 20 C8 E7 01 30 83 E2 05 20 63 E0 00 00 52 E3 F7 FF FF CA 11 FF FF EA 05 10 A0 E1 03 00 A0 E1 ?? ?? ?? ?? 05 20 A0 E1 00 10 A0 E1 06 30 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 40 FF FF EA 01 00 5B E3 00 30 A0 11 04 20 9D 15 A7 00 00 0A 03 10 D2 E7 03 00 D9 E7 03 00 C2 E7 03 10 C9 E7 01 30 83 E2 05 10 63 E0 00 00 51 E3 F7 FF FF CA CB FF FF EA 21 11 A0 E1 00 30 A0 E3 03 00 99 E7 03 C0 92 E7 01 10 41 E2 00 00 51 E3 03 C0 89 E7 03 00 82 E7 04 30 83 E2 F7 FF FF CA 25 FF FF EA 08 00 A0 E1 00 10 9D E5 0F E0 A0 E1 16 FF 2F E1 00 00 50 E3 E4 FE FF BA 04 00 9D E5 00 10 9D E5 0F E0 A0 E1 16 FF 2F E1 00 00 50 E3 07 00 00 BA 04 80 9D E5 DC FE FF EA 04 00 9D E5 00 10 9D E5 0F E0 A0 E1 16 FF 2F E1 00 00 50 E3 F7 FF FF BA 00 80 9D E5 D4 FE FF EA 08 20 9D E5 A2 31 A0 E1 95 03 03 E0 03 80 87 E0 10 30 8D E5 08 10 A0 E1 07 00 A0 E1 0F E0 A0 E1 16 FF 2F E1 10 30 9D E5 83 30 A0 E1 03 10 87 E0 00 00 50 E3 18 30 8D E5 04 10 8D E5 61 00 00 BA 08 00 A0 E1 04 10 9D E5 0F E0 A0 E1 16 FF 2F E1 00 00 50 E3 81 00 00 DA 04 80 8D E5 10 20 9D E5 00 20 62 E2 02 80 89 E0 14 20 8D E5 08 00 A0 E1 09 10 A0 E1 0F E0 A0 E1 16 FF 2F E1 10 30 9D E5 00 00 50 E3 03 30 89 E0 10 30 8D E5 40 00 00 BA 09 00 A0 E1 10 10 9D E5 0F E0 A0 E1 16 FF 2F E1 00 00 50 E3 66 00 00 DA 09 80 A0 E1 00 10 9D E5 18 20 9D E5 01 10 62 E0 10 10 8D E5 00 30 9D E5 14 10 9D E5 01 90 83 E0 10 00 9D E5 09 10 A0 E1 0F E0 A0 E1 16 FF 2F E1 00 00 50 E3 1D 00 00 BA 09 00 A0 E1 00 10 9D E5 0F E0 A0 E1 16 FF 2F E1 00 00 50 E3 4B 00 00 DA 00 90 8D E5 88 FE FF EA 21 11 A0 E1 00 30 A0 E3 03 00 97 E7 03 C0 92 E7 01 10 41 E2 00 00 51 E3 03 C0 87 E7 03 00 82 E7 04 30 83 E2 F7 FF FF CA B1 FE FF EA 0C 20 9D E5 00 30 A0 E3 03 10 97 E7 03 00 98 E7 01 20 42 E2 00 00 52 E3 03 00 87 E7 03 10 88 E7 04 30 83 E2 F7 FF FF CA 84 FE FF EA 09 00 A0 E1 00 10 9D E5 0F E0 A0 E1 16 FF 2F E1 00 00 50 E3 E1 FF FF BA 10 00 9D E5 00 10 9D E5 0F E0 A0 E1 16 FF 2F E1 00 00 50 E3 66 FE FF BA 10 20 9D E5 00 20 8D E5 63 FE FF EA 09 00 A0 E1 03 10 A0 E1 0F E0 A0 E1 16 FF 2F E1 00 00 50 E3 BE FF FF BA 08 00 A0 E1 10 10 9D E5 0F E0 A0 E1 16 FF 2F E1 00 00 50 E3 10 80 9D B5 B8 FF FF EA 08 00 A0 E1 0F E0 A0 E1 16 FF 2F E1 00 00 50 E3 9E FF FF BA 07 00 A0 E1 04 10 9D E5 0F E0 A0 E1 16 FF 2F E1 00 00 50 E3 04 70 8D A5 98 FF FF EA 0C 20 9D E5 04 C0 9D E5 00 30 A0 E1 03 10 9C E7 03 00 99 E7 01 20 42 E2 00 00 52 E3 03 00 8C E7 03 10 89 E7 04 30 83 E2 F7 FF FF CA 20 FF FF EA 10 00 9D E5 00 10 9D E5 0F E0 A0 E1 16 FF 2F E1 00 00 50 E3 38 FE FF AA D0 FF FF EA 08 00 A0 E1 10 10 9D E5 0F E0 A0 E1 16 FF 2F E1 00 00 50 E3 10 80 9D A5 92 FF FF EA 07 00 A0 E1 04 10 9D E5 0F E0 A0 E1 16 FF 2F E1 00 00 50 E3 04 70 8D B5 77 FF FF EA 08 10 9D E5 95 71 21 E0 10 20 9D E5 01 00 52 E1 08 10 8D E5 B2 FE FF 2A 05 30 82 E0 00 30 8D E5 02 80 A0 E1 00 90 65 E2 08 00 57 E1 09 40 88 30 04 A0 A0 31 0B 00 00 3A 21 00 00 EA 04 30 69 E0 00 20 93 E5 00 10 9A E5 00 10 83 E5 00 20 8A E5 09 A0 8A E0 0A 30 69 E0 03 00 57 E1 18 00 00 2A 04 80 A0 E1 09 40 84 E0 04 00 A0 E1 08 10 A0 E1 0F E0 A0 E1 16 FF 2F E1 00 00 50 E3 10 00 00 DA 00 00 5B E3 EC FF FF 0A 01 00 5B E3 00 30 A0 13 13 00 00 0A 03 20 D8 E7 03 10 D4 E7 03 10 C8 E7 03 20 C4 E7 01 30 83 E2 05 20 63 E0 00 00 52 E3 F7 FF FF CA 09 A0 8A E0 0A 30 69 E0 03 00 57 E1 E6 FF FF 3A 00 80 9D E5 08 20 9D E5 05 10 88 E0 01 30 65 E0 03 00 52 E1 00 10 8D E5 D1 FF FF 8A 7F FE FF EA 0C 20 9D E5 00 30 A0 E3 03 10 98 E7 03 00 94 E7 01 20 42 E2 00 00 52 E3 03 00 88 E7 03 10 84 E7 04 30 83 E2 F7 FF FF CA CF FF FF EA 0C 20 9D E5 00 30 A0 E3 03 10 98 E7 03 00 94 E7 01 20 42 E2 00 00 52 E3 03 00 88 E7 03 10 84 E7 04 30 83 E2 F7 FF FF CA 45 FE FF EA }
	condition:
		$1
}

rule file_439_0_0 {
	meta:
		name = "_mallopt_r"
		size = 160
		refs = "0014 __malloc_lock 0040 __malloc_unlock 0098 __malloc_trim_threshold 009c __malloc_top_pad"
	strings:
		$1 = { 70 40 2D E9 01 40 A0 E1 04 40 84 E2 02 60 A0 E1 00 50 A0 E1 ?? ?? ?? ?? 03 00 54 E3 04 F1 9F 97 18 00 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 5C 30 9F E5 05 00 A0 E1 00 60 83 E5 ?? ?? ?? ?? 01 00 A0 E3 70 80 BD E8 48 30 9F E5 05 00 A0 E1 00 60 83 E5 ?? ?? ?? ?? 01 00 A0 E3 70 80 BD E8 05 00 A0 E1 ?? ?? ?? ?? 01 00 A0 E3 70 80 BD E8 05 00 A0 E1 ?? ?? ?? ?? 01 00 76 E2 00 00 A0 33 70 80 BD E8 05 00 A0 E1 ?? ?? ?? ?? 00 00 A0 E3 70 80 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_440_0_0 {
	meta:
		name = "iswprint"
		size = 36
		refs = "0020 __ctype_ptr__"
	strings:
		$1 = { FF 00 50 E3 14 30 9F 95 00 30 93 95 00 00 83 90 01 00 D0 95 00 00 A0 83 97 00 00 92 1E FF 2F E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_441_0_0 {
	meta:
		name = "open"
		size = 68
		refs = "002c _open_r 0040 _impure_ptr"
	strings:
		$1 = { 0E 00 2D E9 04 E0 2D E5 30 30 9F E5 00 30 93 E5 04 D0 4D E2 00 10 A0 E1 10 C0 8D E2 03 00 A0 E1 08 20 8D E2 0C 00 92 E8 00 C0 8D E5 ?? ?? ?? ?? 04 D0 8D E2 04 E0 9D E4 0C D0 8D E2 1E FF 2F E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_442_0_0 {
	meta:
		name = "iswblank"
		size = 20
		refs = "0010 isblank"
	strings:
		$1 = { FF 00 50 E3 01 00 00 9A 00 00 A0 E3 1E FF 2F E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_443_0_0 {
	meta:
		name = "_fseek_r"
		size = 1164
		refs = "00c4 _fstat_r 01b4 _free_r 01dc __srefill_r 0214 memset 023c _fflush_r 02a4 __sinit 0458 __smakebuf_r 0488 __sseek"
	strings:
		$1 = { F0 4F 2D E9 00 50 50 E2 3C D0 4D E2 01 40 A0 E1 02 90 A0 E1 03 60 A0 E1 02 00 00 0A 38 30 95 E5 00 00 53 E3 9E 00 00 0A BC 30 D4 E1 42 3F 03 E2 42 0F 53 E3 9F 00 00 0A 28 70 94 E5 00 00 57 E3 1D 30 A0 03 00 30 85 05 00 00 E0 03 72 00 00 0A 01 00 56 E3 76 00 00 0A 02 00 56 E3 01 00 00 0A 00 00 56 E3 6E 00 00 1A 00 B0 A0 E3 10 30 94 E5 0B A0 A0 E1 00 00 53 E3 F4 00 00 0A BC 00 D4 E1 7E 3E C0 E3 05 30 C3 E3 03 3A A0 E1 23 3A A0 E1 00 00 53 E3 00 20 A0 E1 AF 00 00 1A 01 0B 10 E3 13 00 00 1A DC 33 9F E5 03 00 57 E1 BB 00 00 1A FE 10 D4 E1 00 00 51 E3 B8 00 00 BA 05 00 A0 E1 0D 20 A0 E1 ?? ?? ?? ?? 00 00 50 E3 B2 00 00 1A 04 30 9D E5 0F 3A 03 E2 02 09 53 E3 AE 00 00 1A BC 30 D4 E1 01 2B A0 E3 01 3B 83 E3 4C 20 84 E5 BC 30 C4 E1 00 00 56 E3 09 80 A0 01 9D 00 00 1A 00 00 5B E3 5F 00 00 1A BC 30 D4 E1 01 0A 13 E3 50 00 94 15 88 00 00 0A 30 10 94 E5 04 20 94 E5 00 00 51 E3 00 A0 62 E0 A4 00 00 0A 3C C0 94 E5 0A A0 6C E0 38 30 94 E5 10 00 94 E5 0A A0 82 E0 03 30 60 E0 03 C0 8C E0 0A A0 63 E0 0A 00 58 E1 02 00 00 BA 0C 30 8A E0 03 00 58 E1 59 00 00 3A 4C A0 94 E5 00 A0 6A E2 0A A0 08 E0 05 00 A0 E1 1C 10 94 E5 0A 20 A0 E1 00 30 A0 E3 0F E0 A0 E1 17 FF 2F E1 01 00 70 E3 73 00 00 0A 30 10 94 E5 10 30 94 E5 00 20 A0 E3 00 00 51 E3 04 20 84 E5 00 30 84 E5 05 00 00 0A 40 30 84 E2 03 00 51 E1 05 00 A0 11 ?? ?? ?? ?? 00 30 A0 E3 30 30 84 E5 BC 30 D4 E1 0A 80 58 E0 20 30 C3 E3 BC 30 C4 E1 0C 00 00 0A 05 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 5C 00 00 1A 04 30 94 E5 03 00 58 E1 59 00 00 8A 00 A0 94 E5 03 30 68 E0 08 80 8A E0 00 80 84 E5 04 30 84 E5 5C 00 84 E2 00 10 A0 E3 08 20 A0 E3 ?? ?? ?? ?? 00 00 A0 E3 3C D0 8D E2 F0 8F BD E8 16 30 A0 E3 00 30 85 E5 00 00 E0 E3 F9 FF FF EA 05 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? BC 30 D4 E1 01 2A 13 E2 50 A0 94 15 83 00 00 0A 04 00 13 E3 30 00 00 1A 08 00 13 E3 34 00 00 0A 00 20 94 E5 00 00 52 E3 31 00 00 0A 10 30 94 E5 02 20 63 E0 02 A0 8A E0 0A 90 89 E0 01 B0 A0 E3 00 60 A0 E3 7A FF FF EA 30 10 94 E5 00 00 51 E3 04 20 94 05 49 00 00 0A 04 20 94 E5 3C C0 94 E5 A3 FF FF EA ?? ?? ?? ?? BC 30 D4 E1 42 3F 03 E2 42 0F 53 E3 5F FF FF 1A 05 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 5B FF FF EA 08 A0 6A E0 0C C0 6A E0 00 00 51 E3 0A A0 80 E0 00 14 84 E8 05 00 00 0A 40 30 84 E2 03 00 51 E1 05 00 A0 11 ?? ?? ?? ?? 00 30 A0 E3 30 30 84 E5 BC 30 D4 E1 20 30 C3 E3 BC 30 C4 E1 5C 00 84 E2 00 10 A0 E3 08 20 A0 E3 ?? ?? ?? ?? 00 00 A0 E3 BF FF FF EA 30 20 94 E5 04 30 94 E5 00 00 52 E3 0A A0 63 E0 3C 30 94 15 0A A0 63 10 10 30 94 E5 CE FF FF EA 0B 20 A0 E1 05 00 A0 E1 1C 10 94 E5 01 30 A0 E3 0F E0 A0 E1 17 FF 2F E1 01 00 70 E3 6E FF FF 1A 05 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 19 00 00 0A 00 00 E0 E3 A8 FF FF EA 05 00 A0 E1 FE 10 D4 E1 0D 20 A0 E1 ?? ?? ?? ?? 00 00 50 E3 F2 FF FF 1A 10 80 9D E5 08 80 89 E0 58 FF FF EA BC 00 D4 E1 02 0B 80 E3 BC 00 C4 E1 04 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 EC FF FF 1A 05 00 00 EA 00 30 94 E5 10 00 94 E5 03 30 60 E0 03 C0 82 E0 0A A0 63 E0 5C FF FF EA 09 20 A0 E1 06 30 A0 E1 05 00 A0 E1 1C 10 94 E5 0F E0 A0 E1 17 FF 2F E1 01 00 70 E3 DD FF FF 0A 30 10 94 E5 00 00 51 E3 05 00 00 0A 40 30 84 E2 03 00 51 E1 05 00 A0 11 ?? ?? ?? ?? 00 30 A0 E3 30 30 84 E5 BC 30 D4 E1 10 20 94 E5 00 50 A0 E3 82 3E C3 E3 00 20 84 E5 BC 30 C4 E1 04 50 84 E5 5C 00 84 E2 05 10 A0 E1 08 20 A0 E3 ?? ?? ?? ?? 05 00 A0 E1 72 FF FF EA 05 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 06 FF FF EA 06 30 A0 E1 05 00 A0 E1 1C 10 94 E5 0F E0 A0 E1 17 FF 2F E1 01 00 70 E3 00 A0 A0 E1 BB FF FF 0A BC 30 D4 E1 71 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_444_0_0 {
	meta:
		name = "isupper"
		size = 28
		refs = "0018 __ctype_ptr__"
	strings:
		$1 = { 10 30 9F E5 00 30 93 E5 00 30 83 E0 01 00 D3 E5 01 00 00 E2 1E FF 2F E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_445_0_0 {
	meta:
		name = "getwchar"
		size = 20
		refs = "000c fgetwc 0010 _impure_ptr"
	strings:
		$1 = { 08 30 9F E5 00 30 93 E5 04 00 93 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_445_1_0 {
	meta:
		name = "_getwchar_r"
		size = 20
		refs = "000c _fgetwc_r 0010 _impure_ptr"
	strings:
		$1 = { 08 30 9F E5 00 30 93 E5 04 10 93 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_446_0_0 {
	meta:
		name = "_puts_r"
		size = 156
		refs = "0014 strlen 007c __sfvwrite_r 0094 _impure_ptr"
	strings:
		$1 = { 30 40 2D E9 00 50 A0 E1 1C D0 4D E2 01 00 A0 E1 01 40 A0 E1 ?? ?? ?? ?? 74 20 9F E5 00 20 92 E5 08 20 92 E5 BC 10 D2 E1 02 0A 11 E3 00 30 A0 E1 64 00 92 05 01 C0 83 E2 04 30 8D E5 54 30 9F E5 02 1A 81 03 02 0A C0 03 64 00 82 05 BC 10 C2 01 18 C0 8D E5 08 30 8D E5 02 C0 A0 E3 01 30 A0 E3 08 10 95 E5 05 00 A0 E1 10 20 8D E2 10 D0 8D E5 14 C0 8D E5 00 40 8D E5 0C 30 8D E5 ?? ?? ?? ?? 00 00 50 E3 00 00 E0 13 0A 00 A0 03 1C D0 8D E2 30 80 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_449_0_0 {
	meta:
		name = "strcpy"
		size = 148
	strings:
		$1 = { 00 30 81 E1 03 00 13 E3 00 C0 A0 11 19 00 00 1A 00 20 91 E5 FF 34 82 E2 01 38 43 E2 01 3C 43 E2 01 30 43 E2 02 30 C3 E1 7F 34 C3 E3 7F 38 C3 E3 7F 3C C3 E3 7F 30 C3 E3 00 00 53 E3 00 C0 A0 E1 0C 00 00 1A 04 20 8C E4 04 20 B1 E5 FF 34 82 E2 01 38 43 E2 01 3C 43 E2 01 30 43 E2 02 30 C3 E1 7F 34 C3 E3 7F 38 C3 E3 7F 3C C3 E3 7F 30 C3 E3 00 00 53 E3 F2 FF FF 0A 00 30 A0 E3 03 20 D1 E7 00 00 52 E3 03 20 CC E7 01 30 83 E2 FA FF FF 1A 1E FF 2F E1 }
	condition:
		$1
}

rule file_450_0_0 {
	meta:
		name = "isalpha"
		size = 28
		refs = "0018 __ctype_ptr__"
	strings:
		$1 = { 10 30 9F E5 00 30 93 E5 00 30 83 E0 01 00 D3 E5 03 00 00 E2 1E FF 2F E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_452_0_0 {
	meta:
		name = "first_day"
		size = 24
	strings:
		$1 = { 7B 3E A0 E3 02 30 83 E2 03 00 50 E1 01 00 A0 C3 04 00 A0 D3 1E FF 2F E1 }
	condition:
		$1
}

rule file_452_1_0 {
	meta:
		name = "match_string"
		size = 124
		refs = "0038 strlen 004c strncasecmp"
	strings:
		$1 = { 00 30 91 E5 00 00 53 E3 F0 41 2D E9 01 80 A0 E1 00 70 A0 E1 15 00 00 0A 04 40 81 E2 00 50 A0 E3 03 00 00 EA 04 30 94 E4 00 00 53 E3 01 50 85 E2 0E 00 00 0A 03 00 A0 E1 ?? ?? ?? ?? 00 60 A0 E1 00 10 98 E5 00 00 97 E5 06 20 A0 E1 ?? ?? ?? ?? 00 00 50 E3 04 80 A0 E1 F1 FF FF 1A 00 30 97 E5 06 60 83 E0 00 60 87 E5 05 00 A0 E1 F0 81 BD E8 00 50 E0 E3 05 00 A0 E1 F0 81 BD E8 }
	condition:
		$1
}

rule file_452_2_0 {
	meta:
		name = "strptime"
		size = 2280
		refs = "02f0 strtol 0328 strptime 08ac __modsi3 08b4 __ctype_ptr__"
	strings:
		$1 = { F0 4F 2D E9 18 D0 4D E2 10 00 8D E5 00 30 D1 E5 00 00 53 E3 02 60 A0 E1 18 00 00 0A 90 58 9F E5 90 98 9F E5 14 70 8D E2 00 A0 A0 E3 10 80 8D E2 0C B0 A0 E3 00 00 95 E5 03 20 80 E0 01 20 D2 E5 08 00 12 E3 10 00 00 0A 10 30 9D E5 01 00 00 EA 01 30 83 E2 10 30 8D E5 00 20 D3 E5 02 20 80 E0 01 20 D2 E5 08 00 12 E3 F8 FF FF 1A 01 40 A0 E1 01 30 D4 E5 00 00 53 E3 01 10 84 E2 EC FF FF 1A 10 00 9D E5 18 D0 8D E2 F0 8F BD E8 25 00 53 E3 8B 00 00 1A 01 20 D1 E5 00 00 52 E3 01 40 81 E2 87 00 00 0A 45 00 52 E3 4F 00 52 13 01 20 F4 05 79 00 52 E3 02 F1 9F 97 EE 01 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 01 40 44 E2 10 30 9D E5 00 20 D3 E5 25 00 52 E3 45 00 00 1A 01 30 83 E2 10 30 8D E5 6A FF FF EA 10 20 9D E5 00 00 D2 E5 03 00 50 E1 3E 00 00 1A 01 20 82 E2 10 20 8D E5 01 40 A0 E1 62 FF FF EA 0A 20 A0 E3 10 00 9D E5 07 10 A0 E1 ?? ?? ?? ?? 10 20 8D E2 0C 00 92 E8 02 00 53 E1 32 00 00 0A 45 00 50 E3 64 00 80 D2 14 00 86 D5 14 00 86 C5 10 30 8D E5 54 FF FF EA 10 00 9D E5 94 15 9F E5 06 20 A0 E1 ?? ?? ?? ?? 00 00 50 E3 26 00 00 0A 10 00 8D E5 14 00 8D E5 4B FF FF EA 0A 20 A0 E3 10 00 9D E5 07 10 A0 E1 ?? ?? ?? ?? 10 20 8D E2 0C 00 92 E8 02 00 53 E1 1B 00 00 0A 18 00 86 E5 10 30 8D E5 40 FF FF EA 0A 20 A0 E3 10 00 9D E5 07 10 A0 E1 ?? ?? ?? ?? 10 20 8D E2 0C 00 92 E8 02 00 53 E1 10 00 00 0A 01 00 40 E2 18 00 86 E5 10 30 8D E5 34 FF FF EA 10 30 9D E5 00 20 D3 E5 09 00 52 E3 08 00 00 1A 01 30 83 E2 10 30 8D E5 2D FF FF EA 10 00 9D E5 FC 14 9F E5 06 20 A0 E1 ?? ?? ?? ?? 00 00 50 E3 D8 FF FF 1A 00 00 A0 E3 2A FF FF EA 08 00 A0 E1 E0 14 9F E5 E7 FE FF EB 00 00 50 E3 F8 FF FF BA 08 30 96 E5 00 00 53 E3 0C 30 83 12 08 30 86 15 1B FF FF 1A 01 00 50 E3 08 B0 86 05 18 FF FF EA 10 30 9D E5 00 20 D3 E5 0A 00 52 E3 EC FF FF 1A 01 30 83 E2 A5 FF FF EA 0A 20 A0 E3 10 00 9D E5 07 10 A0 E1 ?? ?? ?? ?? 10 20 8D E2 0C 00 92 E8 02 00 53 E1 E2 FF FF 0A 01 00 40 E2 10 00 86 E5 10 30 8D E5 06 FF FF EA 0A 20 A0 E3 10 00 9D E5 07 10 A0 E1 ?? ?? ?? ?? 10 20 8D E2 0C 00 92 E8 02 00 53 E1 D6 FF FF 0A 01 00 40 E2 1C 00 86 E5 10 30 8D E5 FA FE FF EA 0A 20 A0 E3 10 00 9D E5 07 10 A0 E1 ?? ?? ?? ?? 10 20 8D E2 0C 00 92 E8 02 00 53 E1 CA FF FF 0A 0C 00 86 E5 10 30 8D E5 EF FE FF EA 10 00 9D E5 0C 14 9F E5 06 20 A0 E1 ?? ?? ?? ?? 00 00 50 E3 9A FF FF 1A 00 00 A0 E3 EC FE FF EA 08 00 A0 E1 F0 13 9F E5 A9 FE FF EB 00 00 50 E3 BA FF FF BA 10 00 86 E5 E0 FE FF EA 08 00 A0 E1 D8 13 9F E5 A2 FE FF EB 00 00 50 E3 B3 FF FF BA 18 00 86 E5 D9 FE FF EA 07 10 A0 E1 10 00 9D E5 0A 20 A0 E3 ?? ?? ?? ?? 10 10 8D E2 0A 00 91 E8 01 00 53 E1 A9 FF FF 0A 76 2E 40 E2 0C 20 42 E2 14 20 86 E5 10 30 8D E5 CC FE FF EA 0A 20 A0 E3 10 00 9D E5 07 10 A0 E1 ?? ?? ?? ?? 10 30 9D E5 14 20 9D E5 03 00 52 E1 00 C0 A0 E1 9B FF FF 0A 14 00 96 E5 76 0E 80 E2 0C 00 80 E2 08 C0 8D E5 7D FE FF EB 18 30 96 E5 06 30 83 E2 99 23 C1 E0 06 00 80 E2 04 10 8D E5 99 20 C1 E0 0C 10 8D E5 04 10 9D E5 03 20 81 E0 C3 1F A0 E1 42 11 61 E0 0C 20 9D E5 00 10 8D E5 00 20 82 E0 C0 1F A0 E1 42 21 61 E0 00 10 9D E5 81 11 61 E0 03 30 61 E0 04 30 8D E5 02 10 9D E9 82 21 62 E0 8C C1 6C E0 00 20 62 E0 01 30 8C E0 03 30 62 E0 00 00 53 E3 0C 20 8D E5 1C 30 86 E5 AD 00 00 BA 14 30 9D E5 10 30 8D E5 9D FE FF EA 07 10 A0 E1 0A 20 A0 E3 10 00 9D E5 ?? ?? ?? ?? 10 20 9D E5 14 10 9D E5 02 00 51 E1 00 30 A0 E1 6C FF FF 0A 14 00 96 E5 76 0E 80 E2 0C 00 80 E2 08 30 8D E5 4E FE FF EB 06 00 80 E2 99 20 C1 E0 08 30 9D E5 00 10 81 E0 C0 2F A0 E1 41 21 62 E0 01 30 43 E2 18 10 96 E5 82 21 62 E0 00 20 62 E0 83 31 63 E0 03 00 52 E3 01 30 83 E0 07 00 A0 D3 00 00 A0 C3 03 30 62 E0 00 30 83 E0 00 00 53 E3 1C 30 86 E5 18 20 86 B5 1C A0 86 B5 D8 FF FF EA 07 10 A0 E1 0A 20 A0 E3 10 00 9D E5 ?? ?? ?? ?? 10 20 9D E5 14 10 9D E5 02 00 51 E1 00 30 A0 E1 48 FF FF 0A 14 00 96 E5 76 0E 80 E2 0C 00 80 E2 08 30 8D E5 2A FE FF EB 08 30 9D E5 18 20 96 E5 83 31 63 E0 02 30 83 E0 03 30 60 E0 00 00 53 E3 1C 30 86 E5 C2 FF FF AA 18 00 86 E5 1C A0 86 E5 BF FF FF EA 10 00 9D E5 DC 11 9F E5 06 20 A0 E1 ?? ?? ?? ?? 00 00 50 E3 0B FF FF 1A 00 00 A0 E3 5D FE FF EA 0A 20 A0 E3 10 00 9D E5 07 10 A0 E1 ?? ?? ?? ?? 10 20 8D E2 0C 00 92 E8 02 00 53 E1 28 FF FF 0A 00 00 86 E5 10 30 8D E5 4D FE FF EA 10 00 9D E5 94 11 9F E5 06 20 A0 E1 ?? ?? ?? ?? 00 00 50 E3 F8 FE FF 1A 00 00 A0 E3 4A FE FF EA 0A 20 A0 E3 10 00 9D E5 07 10 A0 E1 ?? ?? ?? ?? 10 20 8D E2 0C 00 92 E8 02 00 53 E1 15 FF FF 0A 04 00 86 E5 10 30 8D E5 3A FE FF EA 0A 20 A0 E3 10 00 9D E5 07 10 A0 E1 ?? ?? ?? ?? 10 20 8D E2 0C 00 92 E8 02 00 53 E1 0A FF FF 0A 0C 00 50 E3 0A 00 A0 01 08 00 86 E5 10 30 8D E5 2D FE FF EA 0A 20 A0 E3 10 00 9D E5 07 10 A0 E1 ?? ?? ?? ?? 10 20 8D E2 0C 00 92 E8 02 00 53 E1 F4 FF FF 1A 00 00 A0 E3 28 FE FF EA 10 00 9D E5 F0 10 9F E5 06 20 A0 E1 ?? ?? ?? ?? 00 00 50 E3 CE FE FF 1A 00 00 A0 E3 20 FE FF EA 0A 20 A0 E3 10 00 9D E5 07 10 A0 E1 ?? ?? ?? ?? 10 20 8D E2 0C 00 92 E8 02 00 53 E1 EB FE FF 0A 00 01 80 E0 00 01 80 E0 00 21 A0 E1 76 2E 42 E2 0C 20 42 E2 14 20 86 E5 10 30 8D E5 0B FE FF EA 08 00 A0 E1 94 10 9F E5 CD FD FF EB 00 00 50 E3 DE FE FF BA 10 00 86 E5 04 FE FF EA 08 00 A0 E1 7C 10 9F E5 C6 FD FF EB 00 00 50 E3 D7 FE FF BA 18 00 86 E5 FD FD FF EA 10 30 9D E5 00 10 D3 E5 25 00 51 E3 8B FE FF 0A 01 30 83 E2 10 30 8D E5 00 10 D3 E5 02 00 51 E1 CC FE FF 1A 01 30 83 E2 85 FE FF EA 01 00 82 E2 07 10 A0 E3 ?? ?? ?? ?? 8A FF FF EA ?? ?? ?? ?? 93 24 49 92 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_453_0_0 {
	meta:
		name = "_gettemp"
		size = 464
		refs = "0014 _getpid_r 00d0 _open_r 0160 _stat_r 01cc __ctype_ptr__"
	strings:
		$1 = { F0 47 2D E9 01 40 A0 E1 3C D0 4D E2 02 80 A0 E1 00 70 A0 E1 ?? ?? ?? ?? 00 30 D4 E5 00 00 53 E3 04 60 A0 01 03 00 00 0A 04 60 A0 E1 01 30 F6 E5 00 00 53 E3 FC FF FF 1A 01 30 56 E5 58 00 53 E3 01 50 46 E2 15 00 00 1A 78 C1 9F E5 00 00 00 EA 03 50 A0 E1 9C 30 82 E0 A2 21 A0 E1 02 31 82 E0 83 00 40 E0 30 00 80 E2 05 30 A0 E1 01 00 43 E4 01 10 55 E5 58 00 51 E3 02 00 A0 E1 F3 FF FF 0A 05 60 A0 E1 03 50 A0 E1 05 00 54 E1 05 00 00 2A 00 30 D5 E5 2F 00 53 E3 38 00 00 0A 01 50 45 E2 05 00 54 E1 F9 FF FF 3A 00 00 58 E3 18 A1 9F E5 0D 90 A0 E1 61 50 A0 E3 25 00 00 0A 0A 2C A0 E3 02 20 82 E2 07 00 A0 E1 04 10 A0 E1 06 3D A0 E3 ?? ?? ?? ?? 00 00 50 E3 00 00 88 E5 37 00 00 AA 00 30 97 E5 11 00 53 E3 0C 00 00 1A 00 30 D6 E5 00 00 53 E3 09 00 00 0A 7A 00 53 E3 06 20 A0 01 02 00 00 0A 08 00 00 EA 7A 00 53 E3 07 00 00 1A 00 50 C2 E5 01 30 F2 E5 00 00 53 E3 F9 FF FF 1A 00 00 A0 E3 3C D0 8D E2 F0 87 BD E8 06 20 A0 E1 00 10 9A E5 03 10 81 E0 01 10 D1 E5 04 00 11 E3 01 30 83 02 00 50 C2 15 00 30 C2 05 00 00 58 E3 D9 FF FF 1A 07 00 A0 E1 04 10 A0 E1 0D 20 A0 E1 ?? ?? ?? ?? 00 00 50 E3 DF FF FF 0A 00 00 97 E5 02 00 50 E3 00 00 A0 13 01 00 A0 03 E8 FF FF EA 00 30 A0 E3 00 30 C5 E5 07 00 A0 E1 04 10 A0 E1 0D 20 A0 E1 ?? ?? ?? ?? 00 00 50 E3 DF FF FF 1A 04 00 9D E5 01 09 10 E2 14 30 A0 03 2F 30 A0 13 00 30 87 05 00 30 C5 15 BA FF FF 1A D8 FF FF EA 01 00 A0 E3 D6 FF FF EA CD CC CC CC ?? ?? ?? ?? }
	condition:
		$1
}

rule file_453_1_0 {
	meta:
		name = "mktemp"
		size = 48
		refs = "002c _impure_ptr"
	strings:
		$1 = { 24 30 9F E5 10 40 2D E9 00 40 A0 E1 04 10 A0 E1 00 00 93 E5 00 20 A0 E3 84 FF FF EB 00 00 50 E3 04 00 A0 11 00 00 A0 03 10 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_453_2_0 {
	meta:
		name = "mkstemp"
		size = 52
		refs = "0030 _impure_ptr"
	strings:
		$1 = { 04 E0 2D E5 24 30 9F E5 04 D0 4D E2 00 10 A0 E1 0D 20 A0 E1 00 00 93 E5 78 FF FF EB 00 00 50 E3 00 00 E0 03 00 00 9D 15 04 D0 8D E2 00 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_453_3_0 {
	meta:
		name = "_mktemp_r"
		size = 32
	strings:
		$1 = { 10 40 2D E9 00 20 A0 E3 01 40 A0 E1 6E FF FF EB 00 00 50 E3 04 00 A0 11 00 00 A0 03 10 80 BD E8 }
	condition:
		$1
}

rule file_453_4_0 {
	meta:
		name = "_mkstemp_r"
		size = 36
	strings:
		$1 = { 04 E0 2D E5 04 D0 4D E2 0D 20 A0 E1 66 FF FF EB 00 00 50 E3 00 00 E0 03 00 00 9D 15 04 D0 8D E2 00 80 BD E8 }
	condition:
		$1
}

rule file_454_0_0 {
	meta:
		name = "setbuffer"
		size = 20
		refs = "0010 setvbuf"
	strings:
		$1 = { 00 00 51 E3 02 30 A0 E1 02 20 A0 03 00 20 A0 13 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_455_0_0 {
	meta:
		name = "wcspbrk"
		size = 100
	strings:
		$1 = { 00 30 90 E5 00 00 53 E3 30 00 2D E9 11 00 00 0A 00 50 91 E5 00 40 A0 E1 00 00 55 E3 04 00 A0 E1 09 00 00 0A 03 00 55 E1 0B 00 00 0A 01 20 A0 E1 02 00 00 EA 0C 00 53 E1 04 20 82 E2 06 00 00 0A 04 C0 92 E5 00 00 5C E3 F9 FF FF 1A 04 30 B4 E5 00 00 53 E3 EF FF FF 1A 00 00 A0 E3 30 00 BD E8 1E FF 2F E1 }
	condition:
		$1
}

rule file_456_0_0 {
	meta:
		name = "_calloc_r"
		size = 156
		refs = "0008 _malloc_r 0090 memset"
	strings:
		$1 = { 10 40 2D E9 92 01 01 E0 ?? ?? ?? ?? 00 40 50 E2 1B 00 00 0A 04 20 14 E5 03 20 C2 E3 04 20 42 E2 24 00 52 E3 18 00 00 8A 13 00 52 E3 04 30 A0 E1 0E 00 00 9A 00 10 A0 E3 04 00 A0 E1 04 10 80 E4 1B 00 52 E3 04 10 84 E5 04 30 80 E2 07 00 00 9A 24 00 52 E3 04 20 83 E2 04 10 80 E5 04 10 83 E5 04 30 82 E2 04 10 82 05 04 10 83 05 08 30 83 02 00 10 A0 E3 03 20 A0 E1 04 10 82 E4 04 10 83 E5 04 10 82 E5 04 00 A0 E1 10 80 BD E8 00 10 A0 E3 ?? ?? ?? ?? 04 00 A0 E1 10 80 BD E8 }
	condition:
		$1
}

rule file_457_0_0 {
	meta:
		name = "_malloc_stats_r"
		size = 160
		refs = "0010 __malloc_lock 0014 __malloc_update_mallinfo 004c __malloc_unlock 0060 fiprintf 008c __malloc_current_mallinfo 0090 __malloc_max_total_mem"
	strings:
		$1 = { F0 40 2D E9 80 50 9F E5 28 D0 4D E2 00 40 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 05 E0 A0 E1 0F 00 BE E8 0D C0 A0 E1 0F 00 AC E8 0F 00 BE E8 0F 00 AC E8 03 00 9E E8 54 30 9F E5 03 00 8C E8 04 00 A0 E1 00 70 93 E5 00 60 95 E5 1C 50 9D E5 ?? ?? ?? ?? 0C 40 94 E5 07 20 A0 E1 34 10 9F E5 04 00 A0 E1 ?? ?? ?? ?? 06 20 A0 E1 04 00 A0 E1 24 10 9F E5 ?? ?? ?? ?? 20 10 9F E5 04 00 A0 E1 05 20 A0 E1 28 D0 8D E2 F0 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_460_0_0 {
	meta:
		name = "__dorand48"
		size = 84
	strings:
		$1 = { F0 00 2D E9 B2 C0 D1 E1 B4 4B D0 E1 94 0C 05 E0 B0 30 D1 E1 B2 2B D0 E1 B4 60 D1 E1 93 04 04 E0 92 56 25 E0 B8 7B D0 E1 B6 6B D0 E1 92 73 20 E0 9C 42 22 E0 96 53 23 E0 20 28 82 E0 22 38 83 E0 B4 30 C1 E1 B0 00 C1 E1 B2 20 C1 E1 F0 00 BD E8 1E FF 2F E1 }
	condition:
		$1
}

rule file_461_0_0 {
	meta:
		name = "clock"
		size = 72
		refs = "0014 _times_r 0044 _impure_ptr"
	strings:
		$1 = { 04 E0 2D E5 38 30 9F E5 10 D0 4D E2 00 00 93 E5 0D 10 A0 E1 ?? ?? ?? ?? 01 00 70 E3 06 00 00 0A 00 30 9D E5 04 00 9D E5 03 00 80 E0 08 30 9D E5 03 00 80 E0 0C 30 9D E5 03 00 80 E0 10 D0 8D E2 00 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_462_0_0 {
	meta:
		name = "_reallocf_r"
		size = 60
		refs = "000c _realloc_r 0030 _free_r"
	strings:
		$1 = { 70 40 2D E9 01 40 A0 E1 00 50 A0 E1 ?? ?? ?? ?? 01 30 70 E2 00 30 A0 33 00 00 54 E3 00 30 A0 03 00 00 53 E3 00 60 A0 E1 05 00 A0 11 04 10 A0 11 ?? ?? ?? ?? 06 00 A0 E1 70 80 BD E8 }
	condition:
		$1
}

rule file_464_0_0 {
	meta:
		name = "trecurse"
		size = 160
	strings:
		$1 = { 04 30 90 E5 00 00 53 E3 70 40 2D E9 00 40 A0 E1 01 50 A0 E1 02 60 A0 E1 19 00 00 0A 04 00 A0 E1 00 10 A0 E3 06 20 A0 E1 0F E0 A0 E1 15 FF 2F E1 04 00 94 E5 00 00 50 E3 05 10 A0 11 01 20 86 12 EE FF FF 1B 04 00 A0 E1 01 10 A0 E3 06 20 A0 E1 0F E0 A0 E1 15 FF 2F E1 08 00 94 E5 00 00 50 E3 05 10 A0 11 01 20 86 12 E4 FF FF 1B 04 00 A0 E1 06 20 A0 E1 02 10 A0 E3 0F E0 A0 E1 15 FF 2F E1 70 80 BD E8 08 30 90 E5 00 00 53 E3 E2 FF FF 1A 03 10 A0 E3 0F E0 A0 E1 15 FF 2F E1 70 80 BD E8 }
	condition:
		$1
}

rule file_464_1_0 {
	meta:
		name = "twalk"
		size = 20
	strings:
		$1 = { 00 00 51 E3 00 00 50 13 1E FF 2F 01 00 20 A0 E3 D2 FF FF EA }
	condition:
		$1
}

rule file_466_0_0 {
	meta:
		name = "_unsetenv_r"
		size = 168
		refs = "0028 strchr 0038 __env_lock 0070 _findenv_r 0080 __env_unlock 0090 __errno 00a4 environ"
	strings:
		$1 = { F0 41 2D E9 00 40 51 E2 04 D0 4D E2 00 50 A0 E1 1E 00 00 0A 00 30 D4 E5 00 00 53 E3 1B 00 00 0A 04 00 A0 E1 3D 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 16 00 00 1A 05 00 A0 E1 ?? ?? ?? ?? 0D 60 A0 E1 5C 70 9F E5 06 00 00 EA 00 30 97 E5 00 20 9D E5 02 31 83 E0 04 20 B3 E5 00 00 52 E3 04 20 03 E5 FB FF FF 1A 05 00 A0 E1 04 10 A0 E1 0D 20 A0 E1 ?? ?? ?? ?? 00 80 50 E2 F2 FF FF 1A 05 00 A0 E1 ?? ?? ?? ?? 08 00 A0 E1 04 D0 8D E2 F0 81 BD E8 ?? ?? ?? ?? 16 30 A0 E3 00 30 80 E5 00 00 E0 E3 F8 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_466_1_0 {
	meta:
		name = "_setenv_r"
		size = 648
		refs = "0020 strchr 0030 __env_lock 0038 strlen 004c _findenv_r 00b4 _malloc_r 012c __env_unlock 0144 strncmp 017c strcmp 0188 tzset 01a8 __errno 0204 _realloc_r 025c bcopy 0278 environ"
	strings:
		$1 = { F0 4F 2D E9 01 50 A0 E1 04 D0 4D E2 00 60 A0 E1 3D 10 A0 E3 05 00 A0 E1 02 40 A0 E1 03 A0 A0 E1 ?? ?? ?? ?? 00 90 50 E2 5E 00 00 1A 06 00 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 00 80 A0 E1 0D 20 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 00 70 50 E2 58 00 00 0A 00 00 5A E3 4C 00 00 0A ?? ?? ?? ?? 00 00 58 E1 3A 00 00 9A 04 A2 9F E5 00 B0 9D E5 00 90 9A E5 0B B1 A0 E1 00 30 D5 E5 3D 00 53 E3 00 00 53 13 05 20 A0 01 04 00 00 0A 05 20 A0 E1 01 30 F2 E5 3D 00 53 E3 00 00 53 13 FB FF FF 1A 02 30 65 E2 08 80 83 E0 08 10 82 E0 06 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 0B 00 89 E7 68 00 00 0A 00 20 9A E5 00 10 9D E5 00 30 D5 E5 01 21 92 E7 00 00 53 E3 00 30 C2 E5 09 00 00 0A 3D 00 53 E3 03 00 00 1A 06 00 00 EA 3D 00 53 E3 01 50 85 E2 03 00 00 0A 01 30 D5 E5 00 00 53 E3 01 30 E2 E5 F8 FF FF 1A 3D 30 A0 E3 00 30 C2 E5 00 30 A0 E3 03 10 D4 E7 00 00 51 E3 01 10 E2 E5 01 30 83 E2 FA FF FF 1A 06 00 A0 E1 ?? ?? ?? ?? 00 30 9A E5 00 20 9D E5 3C 11 9F E5 02 01 93 E7 03 20 A0 E3 ?? ?? ?? ?? 00 A0 50 E2 0D 00 00 0A 00 00 A0 E3 11 00 00 EA 09 30 D4 E7 00 00 53 E3 09 30 C7 E7 01 90 89 E2 FA FF FF 1A 06 00 A0 E1 ?? ?? ?? ?? 05 00 A0 E1 00 11 9F E5 ?? ?? ?? ?? 00 A0 50 E2 F1 FF FF 1A ?? ?? ?? ?? 0A 00 A0 E1 02 00 00 EA 06 00 A0 E1 ?? ?? ?? ?? 0A 00 A0 E1 04 D0 8D E2 F0 8F BD E8 ?? ?? ?? ?? 16 30 A0 E3 00 30 80 E5 00 00 E0 E3 F8 FF FF EA B4 A0 9F E5 00 10 9A E5 00 30 91 E5 00 00 53 E3 03 70 A0 01 08 20 A0 03 05 00 00 0A 01 70 87 E2 07 31 91 E7 00 00 53 E3 FB FF FF 1A 02 20 87 E2 02 21 A0 E1 8C 30 9F E5 00 00 93 E5 00 00 50 E3 0B 00 00 0A 06 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 00 90 A0 E1 00 00 8A E5 07 B1 A0 11 12 00 00 0A 01 30 87 E2 00 20 A0 E3 03 21 89 E7 00 70 8D E5 92 FF FF EA 02 10 A0 E1 01 20 A0 E3 06 00 A0 E1 00 20 83 E5 ?? ?? ?? ?? 00 90 50 E2 06 00 00 0A 07 B1 A0 E1 00 00 9A E5 09 10 A0 E1 0B 20 A0 E1 ?? ?? ?? ?? 00 90 8A E5 EC FF FF EA 06 00 A0 E1 ?? ?? ?? ?? 00 00 E0 E3 C9 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_469_0_0 {
	meta:
		name = "__getdelim"
		size = 296
		refs = "0048 realloc 0098 getc_unlocked 0108 __sinit 0110 __errno 0124 _impure_ptr"
	strings:
		$1 = { 00 00 50 E3 00 00 53 13 F0 4F 2D E9 03 40 A0 E1 00 60 A0 E1 01 50 A0 E1 02 80 A0 E1 3B 00 00 0A 00 00 51 E3 39 00 00 0A 00 A0 90 E5 00 00 5A E3 02 00 00 0A 00 30 91 E5 03 00 53 E3 09 00 00 8A 0A 00 A0 E1 80 10 A0 E3 ?? ?? ?? ?? 00 A0 50 E2 01 00 00 1A 00 00 E0 E3 F0 8F BD E8 80 30 A0 E3 00 30 85 E5 00 A0 86 E5 B4 30 9F E5 00 00 93 E5 00 00 50 E3 02 00 00 0A 38 30 90 E5 00 00 53 E3 20 00 00 0A 00 B0 95 E5 0A 70 A0 E1 01 B0 5B E2 04 00 A0 E1 0C 00 00 0A ?? ?? ?? ?? 01 00 70 E3 02 00 00 0A 08 00 50 E1 01 00 C7 E4 F6 FF FF 1A 0A 30 A0 E1 03 00 57 E1 E5 FF FF 0A 00 20 A0 E3 00 20 C7 E5 07 00 63 E0 F0 8F BD E8 00 90 95 E5 89 90 A0 E1 0A 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 00 30 A0 E1 F1 FF FF 0A 07 70 6A E0 09 B0 67 E0 00 00 86 E5 00 90 85 E5 00 A0 A0 E1 07 70 80 E0 E0 FF FF EA ?? ?? ?? ?? DC FF FF EA ?? ?? ?? ?? 16 30 A0 E3 00 30 80 E5 00 00 E0 E3 F0 8F BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_470_0_0 {
	meta:
		name = "_mbtowc_r"
		size = 80
	strings:
		$1 = { 00 00 51 E3 04 D0 4D E2 0D 10 A0 01 01 30 73 E2 00 30 A0 33 00 00 52 E3 00 30 A0 03 00 00 53 E3 01 00 E0 13 07 00 00 1A 00 00 52 E3 02 00 A0 01 04 00 00 0A 00 30 D2 E5 00 30 81 E5 00 00 D2 E5 00 00 50 E2 01 00 A0 13 04 D0 8D E2 1E FF 2F E1 }
	condition:
		$1
}

rule file_471_0_0 {
	meta:
		name = "memset"
		size = 248
	strings:
		$1 = { 03 00 10 E3 30 00 2D E9 00 30 A0 E1 0A 00 00 0A 00 00 52 E3 01 20 42 12 FF C0 01 12 03 00 00 1A 32 00 00 EA 00 00 52 E3 30 00 00 0A 01 20 42 E2 01 C0 C3 E4 03 00 13 E3 F9 FF FF 1A 03 00 52 E3 22 00 00 9A FF 40 01 E2 0F 00 52 E3 04 44 84 E1 03 50 A0 E1 04 48 84 E1 02 50 A0 81 03 C0 A0 81 0E 00 00 9A 10 50 45 E2 0F 00 55 E3 00 40 8C E5 04 40 8C E5 08 40 8C E5 0C 40 8C E5 10 C0 8C E2 F7 FF FF 8A 10 C0 42 E2 0F 20 0C E2 0F 50 CC E3 10 50 85 E2 03 00 52 E3 05 50 83 E0 0A 00 00 9A 00 30 A0 E3 03 40 85 E7 04 30 83 E2 02 C0 63 E0 03 00 5C E3 FA FF FF 8A 04 20 42 E2 03 30 C2 E3 04 30 83 E2 03 50 85 E0 03 20 02 E2 05 30 A0 E1 00 00 52 E3 05 00 00 0A FF 10 01 E2 00 C0 A0 E3 0C 10 C3 E7 01 C0 8C E2 0C 00 52 E1 FB FF FF 1A 30 00 BD E8 1E FF 2F E1 }
	condition:
		$1
}

rule file_474_0_0 {
	meta:
		name = "setlinebuf"
		size = 16
		refs = "000c setvbuf"
	strings:
		$1 = { 00 10 A0 E3 01 20 A0 E3 01 30 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_476_0_0 {
	meta:
		name = "_jrand48_r"
		size = 28
		refs = "0008 __dorand48"
	strings:
		$1 = { 10 40 2D E9 01 40 A0 E1 ?? ?? ?? ?? B2 30 D4 E1 B4 00 D4 E1 00 08 83 E0 10 80 BD E8 }
	condition:
		$1
}

rule file_477_0_0 {
	meta:
		name = "feof"
		size = 60
		refs = "0024 __sinit 0038 _impure_ptr"
	strings:
		$1 = { 30 30 9F E5 00 30 93 E5 00 00 53 E3 10 40 2D E9 00 40 A0 E1 03 00 00 0A 38 20 93 E5 00 00 52 E3 03 00 A0 01 ?? ?? ?? ?? BC 00 D4 E1 A0 02 A0 E1 01 00 00 E2 10 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_478_0_0 {
	meta:
		name = "_malloc_usable_size_r"
		size = 68
	strings:
		$1 = { 00 00 51 E3 0C 00 00 0A 08 10 41 E2 04 00 91 E5 02 00 10 E3 03 00 C0 13 08 00 40 12 1E FF 2F 11 01 30 C0 E3 03 10 81 E0 04 30 91 E5 01 00 13 E3 03 00 C0 13 04 00 40 12 1E FF 2F 11 00 00 A0 E3 1E FF 2F E1 }
	condition:
		$1
}

rule file_480_0_0 {
	meta:
		name = "islower"
		size = 28
		refs = "0018 __ctype_ptr__"
	strings:
		$1 = { 10 30 9F E5 00 30 93 E5 00 30 83 E0 01 00 D3 E5 02 00 00 E2 1E FF 2F E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_0_0_1 {
	meta:
		name = "infinity"
		size = 16
	strings:
		$1 = { 7F 04 A0 E3 0F 06 80 E2 00 10 A0 E3 1E FF 2F E1 }
	condition:
		$1
}

rule file_2_0_1 {
	meta:
		name = "erfcf"
		size = 1696
		refs = "006c __mulsf3 0080 __subsf3 00c0 __addsf3 012c __divsf3 0164 __floatunsisf 0198 fabsf 0310 __ieee754_expf"
	strings:
		$1 = { 02 31 E0 E3 F0 47 2D E9 02 35 43 E2 02 41 C0 E3 03 00 54 E1 00 50 A0 E1 00 60 A0 E1 4E 00 00 CA 03 31 E0 E3 2A 37 43 E2 03 00 54 E1 0B 00 00 DA 03 31 E0 E3 06 36 43 E2 03 00 54 E1 DB 00 00 DA BE 34 E0 E3 02 36 43 E2 03 00 54 E1 51 00 00 DA 00 00 50 E3 18 01 00 DA 00 00 A0 E3 F0 87 BD E8 8E 05 54 E3 47 00 00 BA 00 10 A0 E1 ?? ?? ?? ?? 7C 15 9F E5 00 40 A0 E1 ?? ?? ?? ?? 74 15 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 68 15 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 53 11 E0 E3 56 17 41 E2 65 1B 41 E2 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 3E 14 A0 E3 DD 1B 81 E2 75 1F 81 E2 ?? ?? ?? ?? 34 15 9F E5 00 70 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 28 15 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 1C 15 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 10 15 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? C7 11 E0 E3 4D 17 41 E2 11 1B 41 E2 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 07 00 A0 E1 ?? ?? ?? ?? FA 05 55 E3 00 10 A0 E1 90 00 00 AA 05 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 FE 05 A0 E3 ?? ?? ?? ?? F0 87 BD E8 A0 0F A0 E1 80 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 00 40 A0 E1 FE 05 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? F0 87 BD E8 00 10 A0 E1 FE 05 A0 E3 ?? ?? ?? ?? F0 87 BD E8 ?? ?? ?? ?? 00 10 A0 E1 00 70 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 FE 05 A0 E3 ?? ?? ?? ?? DB 39 A0 E3 6D 3D 83 E2 B1 31 83 E2 03 00 54 E1 00 50 A0 E1 BD 00 00 DA BF 34 E0 E3 01 35 43 E2 A6 2F A0 E1 03 00 54 E1 00 30 A0 D3 01 30 02 C2 00 00 53 E3 B3 00 00 1A 1C 14 9F E5 ?? ?? ?? ?? 23 1C A0 E3 2D 11 81 E2 12 15 81 E2 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 51 13 A0 E3 7D 19 81 E2 91 1D 81 E2 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? E8 13 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? DC 13 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? B3 18 E0 E3 62 1C 41 E2 AF 11 41 E2 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? B8 13 9F E5 ?? ?? ?? ?? B4 13 9F E5 00 A0 A0 E1 05 00 A0 E1 ?? ?? ?? ?? A8 13 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 9C 13 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? BA 14 E0 E3 2E 17 41 E2 91 1F 41 E2 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 5D 1D A0 E3 65 11 81 E2 13 15 81 E2 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 60 13 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 54 13 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? FF 4E C7 E3 0F 40 C4 E3 04 10 A0 E1 00 80 A0 E1 02 01 84 E2 ?? ?? ?? ?? 3F 14 A0 E3 01 16 81 E2 ?? ?? ?? ?? ?? ?? ?? ?? 07 10 A0 E1 00 50 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 00 90 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 09 00 A0 E1 ?? ?? ?? ?? 08 10 A0 E1 00 40 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 00 56 E3 99 00 00 DA 07 10 A0 E1 ?? ?? ?? ?? F0 87 BD E8 05 00 A0 E1 ?? ?? ?? ?? 3F 14 A0 E3 00 40 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 3F 04 A0 E3 ?? ?? ?? ?? F0 87 BD E8 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 70 12 9F E5 00 40 A0 E1 ?? ?? ?? ?? 68 12 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 5C 12 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 50 12 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 44 12 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 38 12 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 2C 12 9F E5 ?? ?? ?? ?? 28 12 9F E5 00 50 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 1C 12 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 10 12 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 9B 17 E0 E3 E5 1C 41 E2 63 11 41 E2 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? EC 11 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? E0 11 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 00 00 56 E3 48 00 00 BA 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 AF 01 E0 E3 1E 06 40 E2 56 0B 40 E2 ?? ?? ?? ?? F0 87 BD E8 01 01 A0 E3 F0 87 BD E8 98 11 9F E5 ?? ?? ?? ?? 94 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 88 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 7C 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 70 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 89 11 A0 E3 4A 17 81 E2 0F 1A 81 E2 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 4C 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 40 11 9F E5 ?? ?? ?? ?? 3C 11 9F E5 00 A0 A0 E1 05 00 A0 E1 ?? ?? ?? ?? D2 18 A0 E3 FD 1D 81 E2 F1 11 81 E2 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 18 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 0C 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 00 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? F4 10 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? E8 10 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? DC 10 9F E5 46 FF FF EA 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? CC 10 9F E5 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? F0 87 BD E8 07 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 01 01 A0 E3 ?? ?? ?? ?? F0 87 BD E8 B1 56 C7 B7 89 14 BD 3B 8F 52 E9 3C 1A E2 84 B6 49 EE 0A 39 16 81 A6 3B 63 2A 85 3D 75 C2 F1 C3 EA A2 20 43 4B 10 8E 41 92 A0 21 3C 12 87 B3 C1 A7 43 ED 43 CE 90 1F 45 71 E5 A2 43 59 B4 F2 41 C0 F9 0D BB B3 51 11 3D C2 1C E3 3D 54 FE A2 3E 08 92 BE 3E 05 68 D4 3E C6 CD 1A 3B A3 5A 44 3C 13 6E 5F 3C 07 33 01 3E 85 57 0A 3F 31 F3 D9 3D 7E 07 1D C1 2B 93 A2 42 E7 9A 38 43 8C 65 22 43 57 80 79 42 B7 A0 31 3F 93 A0 21 3C 97 7F 77 BD 1F 45 D9 42 0B 81 D6 43 C9 58 21 44 6F 48 D9 43 63 A8 09 43 CE 35 9D 41 0B 56 58 3F }
	condition:
		$1
}

rule file_2_1_1 {
	meta:
		name = "erff"
		size = 1668
		refs = "0078 __mulsf3 009c __addsf3 00b8 __floatsisf 00c8 __divsf3 00f4 __subsf3 01bc fabsf 0314 __ieee754_expf"
	strings:
		$1 = { 02 31 E0 E3 F0 47 2D E9 02 35 43 E2 02 41 C0 E3 03 00 54 E1 00 50 A0 E1 00 60 A0 E1 22 00 00 CA 03 31 E0 E3 2A 37 43 E2 03 00 54 E1 0C 00 00 DA 03 31 E0 E3 06 36 43 E2 03 00 54 E1 DA 00 00 DA BF 34 E0 E3 01 35 43 E2 03 00 54 E1 5A 00 00 DA 00 00 50 E3 BF 04 A0 B3 02 05 80 B2 FE 05 A0 A3 F0 87 BD E8 C6 05 54 E3 1B 00 00 AA 7F 03 74 E3 C6 00 00 CA 41 14 A0 E3 ?? ?? ?? ?? 1F 17 E0 E3 8A 1C 41 E2 00 40 A0 E1 AF 11 41 E2 05 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 3E 14 A0 E3 ?? ?? ?? ?? F0 87 BD E8 A0 6F A0 E1 86 00 A0 E1 01 00 60 E2 ?? ?? ?? ?? 05 10 A0 E1 00 40 A0 E1 FE 05 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? F0 87 BD E8 00 10 A0 E1 ?? ?? ?? ?? E8 14 9F E5 00 40 A0 E1 ?? ?? ?? ?? E0 14 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? D4 14 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 53 11 E0 E3 56 17 41 E2 65 1B 41 E2 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 3E 14 A0 E3 DD 1B 81 E2 75 1F 81 E2 ?? ?? ?? ?? A0 14 9F E5 00 60 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 94 14 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 88 14 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 7C 14 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? C7 11 E0 E3 4D 17 41 E2 11 1B 41 E2 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? F0 87 BD E8 ?? ?? ?? ?? 00 10 A0 E1 00 70 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 FE 05 A0 E3 ?? ?? ?? ?? DB 39 A0 E3 6D 3D 83 E2 B5 31 83 E2 03 00 54 E1 00 50 A0 E1 AE 00 00 DA F8 13 9F E5 ?? ?? ?? ?? 23 1C A0 E3 2D 11 81 E2 12 15 81 E2 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 51 13 A0 E3 7D 19 81 E2 91 1D 81 E2 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? C4 13 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? B8 13 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? B3 18 E0 E3 62 1C 41 E2 AF 11 41 E2 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 94 13 9F E5 ?? ?? ?? ?? 90 13 9F E5 00 A0 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 84 13 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 78 13 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? BA 14 E0 E3 2E 17 41 E2 91 1F 41 E2 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 5D 1D A0 E3 65 11 81 E2 13 15 81 E2 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 3C 13 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 30 13 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? FF 4E C7 E3 0F 40 C4 E3 04 10 A0 E1 00 80 A0 E1 02 01 84 E2 ?? ?? ?? ?? 3F 14 A0 E3 01 16 81 E2 ?? ?? ?? ?? ?? ?? ?? ?? 07 10 A0 E1 00 50 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 00 90 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 09 00 A0 E1 ?? ?? ?? ?? 08 10 A0 E1 00 40 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 00 56 E3 91 00 00 BA 07 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 FE 05 A0 E3 ?? ?? ?? ?? F0 87 BD E8 3E 14 A0 E3 DD 1B 81 E2 75 1F 81 E2 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? F0 87 BD E8 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 54 12 9F E5 00 40 A0 E1 ?? ?? ?? ?? 4C 12 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 40 12 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 34 12 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 28 12 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 1C 12 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 10 12 9F E5 ?? ?? ?? ?? 0C 12 9F E5 00 50 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 12 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? F4 11 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 9B 17 E0 E3 E5 1C 41 E2 63 11 41 E2 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? D0 11 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? C4 11 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 00 00 56 E3 43 00 00 BA 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 9C 11 9F E5 ?? ?? ?? ?? F0 87 BD E8 94 11 9F E5 ?? ?? ?? ?? 90 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 84 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 78 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 6C 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 89 11 A0 E3 4A 17 81 E2 0F 1A 81 E2 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 48 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 3C 11 9F E5 ?? ?? ?? ?? 38 11 9F E5 00 A0 A0 E1 05 00 A0 E1 ?? ?? ?? ?? D2 18 A0 E3 FD 1D 81 E2 F1 11 81 E2 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 14 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 08 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? FC 10 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? F0 10 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? E4 10 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? D8 10 9F E5 4D FF FF EA 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 C4 00 9F E5 ?? ?? ?? ?? F0 87 BD E8 07 10 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? F0 87 BD E8 B1 56 C7 B7 89 14 BD 3B 8F 52 E9 3C 1A E2 84 B6 49 EE 0A 39 16 81 A6 3B 63 2A 85 3D 75 C2 F1 C3 EA A2 20 43 4B 10 8E 41 92 A0 21 3C 12 87 B3 C1 A7 43 ED 43 CE 90 1F 45 71 E5 A2 43 59 B4 F2 41 C0 F9 0D BB B3 51 11 3D C2 1C E3 3D 54 FE A2 3E 08 92 BE 3E 05 68 D4 3E C6 CD 1A 3B A3 5A 44 3C 13 6E 5F 3C 07 33 01 3E 85 57 0A 3F 31 F3 D9 3D 0B 56 58 3F 7E 07 1D C1 2B 93 A2 42 E7 9A 38 43 8C 65 22 43 57 80 79 42 B7 A0 31 3F 93 A0 21 3C 97 7F 77 BD 1F 45 D9 42 0B 81 D6 43 C9 58 21 44 6F 48 D9 43 63 A8 09 43 CE 35 9D 41 0B 56 58 BF }
	condition:
		$1
}

rule file_3_0_1 {
	meta:
		name = "__kernel_cos"
		size = 828
		refs = "002c __fixdfsi 0054 __muldf3 0074 __adddf3 008c __subdf3"
	strings:
		$1 = { F0 4D 2D E9 02 61 C0 E3 F9 05 56 E3 18 D0 4D E2 00 70 A0 E1 01 80 A0 E1 00 40 A0 E1 01 50 A0 E1 02 A0 A0 E1 03 B0 A0 E1 53 00 00 AA ?? ?? ?? ?? 00 00 50 E3 FF 05 A0 03 03 06 80 02 00 10 A0 03 4B 00 00 0A 07 20 A0 E1 08 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? AB 3F 8F E2 0C 00 93 E8 00 40 A0 E1 01 50 A0 E1 ?? ?? ?? ?? 2A 3E 8F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 29 3E 8F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 0A 3D 8F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 27 3E 8F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 26 3E 8F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 08 00 8D E5 0C 10 8D E5 FF 25 A0 E3 04 00 A0 E1 05 10 A0 E1 02 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 08 30 8D E2 0C 00 93 E8 03 00 8D E8 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 0A 20 A0 E1 00 40 A0 E1 01 50 A0 E1 0B 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 03 00 9D E8 ?? ?? ?? ?? 00 20 A0 E1 FF 05 A0 E3 01 30 A0 E1 03 06 80 E2 00 10 A0 E3 ?? ?? ?? ?? 18 D0 8D E2 F0 8D BD E8 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 5F 3F 8F E2 0C 00 93 E8 00 40 A0 E1 01 50 A0 E1 ?? ?? ?? ?? 17 3E 8F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 16 3E 8F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 15 3E 8F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 05 3D 8F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 13 3E 8F E2 0C 00 93 E8 ?? ?? ?? ?? 05 30 A0 E1 04 20 A0 E1 ?? ?? ?? ?? B3 39 E0 E3 33 3D 43 E2 37 31 43 E2 03 00 56 E1 08 00 8D E5 0C 10 8D E5 AE FF FF DA FF 35 A0 E3 29 38 83 E2 03 00 56 E1 2E 00 00 DA FF 25 A0 E3 12 28 82 E2 00 30 A0 E3 0C 00 8D E8 FF 05 A0 E3 0C 00 9D E8 03 06 80 E2 00 10 A0 E3 ?? ?? ?? ?? FF 25 A0 E3 10 00 8D E5 14 10 8D E5 02 26 82 E2 04 00 A0 E1 05 10 A0 E1 00 30 A0 E3 ?? ?? ?? ?? 0C 00 9D E8 ?? ?? ?? ?? 08 30 8D E2 0C 00 93 E8 03 00 8D E8 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 0A 20 A0 E1 00 40 A0 E1 01 50 A0 E1 0B 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 03 00 9D E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 10 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 9D FF FF EA 02 26 46 E2 00 30 A0 E3 0C 00 8D E8 D0 FF FF EA E9 FA A8 BD D4 38 88 BE 9E EE 21 3E C4 B1 B4 BD 4F 7E 92 3E AD 52 9C 80 A0 01 FA 3E 90 15 CB 19 6C C1 56 3F 77 51 C1 16 55 55 A5 3F 4C 55 55 55 }
	condition:
		$1
}

rule file_4_0_1 {
	meta:
		name = "fmodf"
		size = 308
		refs = "0010 __ieee754_fmodf 002c isnanf 005c __eqsf2 0080 __extendsfdf2 00c0 __divdf3 00d4 __errno 00f4 __truncdfsf2 010c matherr 012c __fdlib_version"
	strings:
		$1 = { F0 41 2D E9 24 D0 4D E2 00 70 A0 E1 01 60 A0 E1 ?? ?? ?? ?? 10 51 9F E5 00 30 95 E5 01 00 73 E3 00 40 A0 E1 03 00 00 0A 06 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 02 00 00 0A 04 00 A0 E1 24 D0 8D E2 F0 81 BD E8 07 00 A0 E1 ?? ?? ?? ?? 00 80 50 E2 F8 FF FF 1A 06 00 A0 E1 00 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 F3 FF FF 1A 01 30 A0 E3 00 30 8D E5 B8 30 9F E5 07 00 A0 E1 04 30 8D E5 20 80 8D E5 ?? ?? ?? ?? 00 70 A0 E1 01 80 A0 E1 06 00 A0 E1 08 70 8D E5 0C 80 8D E5 ?? ?? ?? ?? 00 40 95 E5 00 00 54 E3 10 00 8D E5 14 10 8D E5 13 00 00 0A 00 00 A0 E3 00 10 A0 E3 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 02 00 54 E3 18 00 8D E5 1C 10 8D E5 0C 00 00 1A ?? ?? ?? ?? 21 30 A0 E3 00 30 80 E5 20 30 9D E5 00 00 53 E3 0B 00 00 1A 18 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 40 A0 E1 CD FF FF EA 18 70 8D E5 1C 80 8D E5 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 F1 FF FF 1A ED FF FF EA ?? ?? ?? ?? 20 30 9D E5 00 30 80 E5 EF FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_5_0_1 {
	meta:
		name = "ilogb"
		size = 172
	strings:
		$1 = { 02 01 C0 E3 01 06 50 E3 04 40 2D E5 01 40 A0 E1 08 00 00 BA 02 31 E0 E3 01 36 43 E2 03 00 50 E1 40 0A A0 D1 FF 0F 40 D2 02 01 E0 C3 03 00 40 D2 10 00 BD E8 1E FF 2F E1 04 10 90 E1 04 30 A0 E1 06 01 A0 03 F9 FF FF 0A 00 00 50 E3 0A 00 00 1A 00 00 54 E3 41 0E E0 D3 02 00 40 D2 F3 FF FF DA 41 0E E0 E3 02 00 40 E2 83 30 A0 E1 00 00 53 E3 01 00 40 E2 FB FF FF CA EC FF FF EA 80 35 A0 E1 00 00 53 E3 FF 0F E0 D3 01 00 40 D2 E7 FF FF DA FF 0F E0 E3 01 00 40 E2 83 30 A0 E1 00 00 53 E3 01 00 40 E2 FB FF FF CA E0 FF FF EA }
	condition:
		$1
}

rule file_6_0_1 {
	meta:
		name = "__ieee754_rem_pio2"
		size = 1568
		refs = "0054 __subdf3 00e8 __fixdfsi 00ec __floatsidf 0120 __muldf3 0178 __eqdf2 01d8 __kernel_rem_pio2 02a0 fabs 02c4 __adddf3"
	strings:
		$1 = { F0 4F 2D E9 5B 39 E0 E3 1E 3C 43 E2 13 31 43 E2 02 61 C0 E3 03 00 56 E1 30 D0 4D E2 00 70 A0 E1 01 80 A0 E1 00 50 A0 E1 02 40 A0 E1 75 00 00 DA B6 3B A0 E3 5E 3F 83 E2 0D 31 83 E2 03 00 56 E1 1B 00 00 CA 00 00 50 E3 22 01 00 DA D5 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 6D 3A E0 E3 0E 3C 43 E2 13 31 43 E2 03 00 56 E1 00 70 A0 E1 01 80 A0 E1 75 00 00 0A CD 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 03 00 84 E8 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 31 3E 8F E2 0C 00 93 E8 ?? ?? ?? ?? 01 70 A0 E3 08 00 84 E5 0C 10 84 E5 5A 00 00 EA DC 32 9F E5 03 00 56 E1 77 00 00 DA 02 31 E0 E3 01 36 43 E2 03 00 56 E1 56 00 00 CA 46 8A A0 E1 41 8E 48 E2 06 80 48 E2 08 AA 46 E0 0A 00 A0 E1 01 B0 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 00 60 A0 E1 01 70 A0 E1 00 20 A0 E1 01 30 A0 E1 0A 00 A0 E1 0B 10 A0 E1 18 60 8D E5 1C 70 8D E5 ?? ?? ?? ?? 41 24 A0 E3 07 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 A0 A0 E1 01 B0 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 00 60 A0 E1 01 70 A0 E1 00 20 A0 E1 01 30 A0 E1 0A 00 A0 E1 0B 10 A0 E1 20 60 8D E5 24 70 8D E5 ?? ?? ?? ?? 41 24 A0 E3 07 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 20 A0 E3 00 30 A0 E3 28 00 8D E5 2C 10 8D E5 ?? ?? ?? ?? 18 A0 8D E2 08 60 8A E2 00 00 50 E3 03 70 A0 E3 08 60 46 E2 08 00 00 1A 08 10 86 E2 03 00 91 E8 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 01 70 47 E2 08 60 46 E2 F6 FF FF 0A 02 C0 A0 E3 00 C0 8D E5 D4 C1 9F E5 07 30 A0 E1 0A 00 A0 E1 08 20 A0 E1 04 10 A0 E1 04 C0 8D E5 ?? ?? ?? ?? 00 00 55 E3 00 70 A0 E1 0D 00 00 AA 00 30 94 E5 08 20 94 E5 02 31 83 E2 02 21 82 E2 08 20 84 E5 00 30 84 E5 00 70 67 E2 05 00 00 EA 00 20 A0 E3 00 30 A0 E3 08 20 84 E5 0C 30 84 E5 80 01 84 E8 00 70 A0 E3 07 00 A0 E1 30 D0 8D E2 F0 8F BD E8 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 00 70 A0 E3 03 00 84 E8 08 00 84 E5 0C 10 84 E5 F4 FF FF EA 59 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 16 3E 8F E2 0C 00 93 E8 00 50 A0 E1 01 60 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 03 00 84 E8 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 4D 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 01 70 A0 E3 08 00 84 E5 0C 10 84 E5 DF FF FF EA ?? ?? ?? ?? DC 30 8F E2 0C 00 93 E8 00 80 A0 E1 01 90 A0 E1 ?? ?? ?? ?? FF 25 A0 E3 02 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? ?? ?? ?? ?? 00 70 A0 E1 ?? ?? ?? ?? B4 30 8F E2 0C 00 93 E8 08 00 8D E5 0C 10 8D E5 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? AC 30 8F E2 0C 00 93 E8 00 80 A0 E1 01 90 A0 E1 08 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 1F 00 57 E3 00 A0 A0 E1 01 B0 A0 E1 29 00 00 CA 70 30 9F E5 01 20 47 E2 02 31 93 E7 06 00 53 E1 24 00 00 0A 0A 20 A0 E1 0B 30 A0 E1 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 0C 00 84 E8 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? 00 00 55 E3 08 00 84 E5 0C 10 84 E5 A6 FF FF AA 97 FF FF EA 30 5F E4 3F 83 C8 C9 6D FB 21 F9 BF 00 00 40 54 FB 21 39 41 ?? ?? ?? ?? ?? ?? ?? ?? 8A 19 A3 3B FB 21 F9 3F 00 00 40 54 61 B4 D0 3D 31 63 62 1A 61 B4 D0 3D 00 00 60 1A 8A 19 A3 3B 73 70 03 2E 9A 83 7B 39 C1 49 20 25 0A 20 A0 E1 0B 30 A0 E1 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 01 30 A0 E1 20 1A A0 E1 81 1A A0 E1 46 6A A0 E1 A1 1A A0 E1 06 10 61 E0 00 20 A0 E1 10 00 51 E3 0C 00 84 E8 D3 FF FF DA 5C 30 4F E2 0C 00 93 E8 08 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 A0 A0 E1 01 B0 A0 E1 0A 20 A0 E1 0B 30 A0 E1 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 10 00 8D E5 14 10 8D E5 10 30 8D E2 0C 00 93 E8 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? AC 30 4F E2 0C 00 93 E8 00 80 A0 E1 01 90 A0 E1 08 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? 00 A0 A0 E1 01 B0 A0 E1 0A 20 A0 E1 0B 30 A0 E1 10 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 01 30 A0 E1 20 1A A0 E1 81 1A A0 E1 A1 1A A0 E1 06 60 61 E0 00 20 A0 E1 31 00 56 E3 0C 00 84 E8 31 00 00 CA 10 90 8D E2 00 03 99 E8 A0 FF FF EA 4E 3F 4F E2 0C 00 93 E8 ?? ?? ?? ?? 6D 3A E0 E3 0E 3C 43 E2 13 31 43 E2 03 00 56 E1 00 70 A0 E1 01 80 A0 E1 0F 00 00 0A 56 3F 4F E2 0C 00 93 E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 03 00 84 E8 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 5F 3F 4F E2 0C 00 93 E8 ?? ?? ?? ?? 00 70 E0 E3 08 00 84 E5 0C 10 84 E5 37 FF FF EA 19 3E 4F E2 0C 00 93 E8 ?? ?? ?? ?? 65 3F 4F E2 0C 00 93 E8 00 50 A0 E1 01 60 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 03 00 84 E8 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 07 3D 4F E2 0C 00 93 E8 ?? ?? ?? ?? 00 70 E0 E3 08 00 84 E5 0C 10 84 E5 22 FF FF EA F8 21 1F E5 2E 34 A0 E3 08 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 A0 A0 E1 01 B0 A0 E1 0A 20 A0 E1 0B 30 A0 E1 10 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 80 A0 E1 01 90 A0 E1 08 20 A0 E1 09 30 A0 E1 10 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? 8B 3F 4F E2 0C 00 93 E8 00 A0 A0 E1 01 B0 A0 E1 08 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? 00 A0 A0 E1 01 B0 A0 E1 46 FF FF EA }
	condition:
		$1
}

rule file_9_0_1 {
	meta:
		name = "yn"
		size = 432
		refs = "0014 __ieee754_yn 0038 __isnand 0054 __ledf2 0070 __gtdf2 0094 __floatsidf 00c8 matherr 00e0 __errno 01a8 __fdlib_version"
	strings:
		$1 = { F0 47 2D E9 24 D0 4D E2 00 A0 A0 E1 01 40 A0 E1 02 50 A0 E1 ?? ?? ?? ?? 88 61 9F E5 00 30 96 E5 01 00 73 E3 00 70 A0 E1 01 80 A0 E1 30 00 00 0A 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 90 50 E2 2B 00 00 1A 04 00 A0 E1 05 10 A0 E1 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 28 00 00 DA 04 00 A0 E1 05 10 A0 E1 13 3E 8F E2 0C 00 93 E8 ?? ?? ?? ?? 00 00 50 E3 1D 00 00 DA 05 30 A0 E3 00 30 8D E5 20 31 9F E5 0A 00 A0 E1 04 30 8D E5 20 90 8D E5 ?? ?? ?? ?? 00 30 96 E5 10 40 8D E5 14 50 8D E5 02 00 53 E3 00 40 A0 E3 00 30 A0 E3 18 30 8D E5 1C 40 8D E5 08 00 8D E5 0C 10 8D E5 32 00 00 0A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 2E 00 00 0A 20 30 9D E5 00 00 53 E3 02 00 00 0A ?? ?? ?? ?? 20 30 9D E5 00 30 80 E5 18 80 8D E2 80 01 98 E8 07 00 A0 E1 08 10 A0 E1 24 D0 8D E2 F0 87 BD E8 01 30 A0 E3 00 30 8D E5 98 30 9F E5 0A 00 A0 E1 04 30 8D E5 20 90 8D E5 ?? ?? ?? ?? 00 30 96 E5 00 00 53 E3 10 40 8D E5 14 50 8D E5 08 00 8D E5 0C 10 8D E5 0C 00 00 1A 0E 33 E0 E3 01 36 43 E2 0E 42 A0 E3 18 30 8D E5 1C 40 8D E5 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 DC FF FF 1A ?? ?? ?? ?? 21 30 A0 E3 00 30 80 E5 D8 FF FF EA 02 00 53 E3 02 31 A0 E3 C3 35 A0 E1 00 40 A0 E3 18 30 8D E5 1C 40 8D E5 F4 FF FF 0A EF FF FF EA ?? ?? ?? ?? 22 30 A0 E3 00 30 80 E5 CC FF FF EA FB 21 49 43 18 2D 44 54 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_1_1 {
	meta:
		name = "jn"
		size = 276
		refs = "0014 __ieee754_jn 0038 __isnand 005c fabs 0068 __gtdf2 008c __floatsidf 00c0 matherr 00e4 __errno 010c __fdlib_version"
	strings:
		$1 = { F0 47 2D E9 24 D0 4D E2 00 A0 A0 E1 01 70 A0 E1 02 80 A0 E1 ?? ?? ?? ?? EC 60 9F E5 00 30 96 E5 01 00 73 E3 00 40 A0 E1 01 50 A0 E1 04 00 00 0A 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 90 50 E2 03 00 00 0A 04 00 A0 E1 05 10 A0 E1 24 D0 8D E2 F0 87 BD E8 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 9C 30 8F E2 0C 00 93 E8 ?? ?? ?? ?? 00 00 50 E3 F3 FF FF DA 05 30 A0 E3 00 30 8D E5 8C 30 9F E5 0A 00 A0 E1 04 30 8D E5 20 90 8D E5 ?? ?? ?? ?? 00 30 96 E5 00 40 A0 E3 02 00 53 E3 00 30 A0 E3 10 70 8D E5 14 80 8D E5 18 30 8D E5 1C 40 8D E5 08 00 8D E5 0C 10 8D E5 09 00 00 0A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 05 00 00 0A 20 30 9D E5 00 00 53 E3 06 00 00 1A 18 50 8D E2 30 00 95 E8 D7 FF FF EA ?? ?? ?? ?? 22 30 A0 E3 00 30 80 E5 F5 FF FF EA ?? ?? ?? ?? 20 30 9D E5 00 30 80 E5 F4 FF FF EA FB 21 49 43 18 2D 44 54 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_0_1 {
	meta:
		name = "__ieee754_powf"
		size = 2544
		refs = "007c fabsf 00fc nanf 012c __divsf3 01b0 __ieee754_sqrtf 01fc __mulsf3 0224 __subsf3 02b8 __addsf3 051c __floatsisf 07e0 __gtsf2 0884 __gesf2 0994 scalbnf"
	strings:
		$1 = { F0 4F 2D E9 02 A1 D1 E3 1C D0 4D E2 01 40 A0 E1 01 50 A0 E1 00 90 A0 E1 30 00 00 0A 7F 64 A0 E3 02 65 86 E2 02 71 C0 E3 06 00 57 E1 06 00 5A D1 00 80 A0 E1 00 60 A0 D3 01 60 A0 C3 25 00 00 CA 00 00 50 E3 42 00 00 BA 7F 34 A0 E3 02 35 83 E2 03 00 5A E1 29 00 00 0A FE 05 5A E3 2D 00 00 0A 01 01 55 E3 67 00 00 0A 3F 04 55 E3 01 00 00 1A 00 00 58 E3 4A 00 00 AA 09 00 A0 E1 ?? ?? ?? ?? 7F 34 A0 E3 02 35 83 E2 03 00 57 E1 00 00 57 13 00 10 A0 E1 27 00 00 0A FE 05 57 E3 25 00 00 0A A8 8F A0 E1 01 80 48 E2 08 10 96 E1 5A 00 00 0A 4D 04 5A E3 5F 00 00 DA FE 35 A0 E3 09 30 43 E2 03 00 57 E1 44 00 00 CA 00 00 55 E3 48 00 00 BA 00 40 A0 E3 02 00 00 EA FE 05 57 E3 03 00 00 1A FE 45 A0 E3 04 00 A0 E1 1C D0 8D E2 F0 8F BD E8 A8 08 9F E5 1C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? FE 05 57 E3 F5 FF FF 0A 21 00 00 DA 00 00 55 E3 F3 FF FF AA ED FF FF EA 00 00 55 E3 09 40 A0 A1 EF FF FF AA 09 10 A0 E1 FE 05 A0 E3 ?? ?? ?? ?? 00 40 A0 E1 EA FF FF EA 00 00 55 E3 01 00 A0 A1 22 00 00 BA 00 00 58 E3 19 00 00 BA 00 40 A0 E1 E3 FF FF EA 2D 33 E0 E3 02 35 43 E2 03 00 5A E1 02 60 A0 C3 B7 FF FF CA FE 05 5A E3 06 00 00 BA CA 3B A0 E1 96 30 63 E2 5A 23 A0 E1 12 03 5A E1 01 20 02 02 02 60 62 02 B2 FF FF 0A 00 60 A0 E3 B0 FF FF EA 00 00 55 E3 02 41 84 B2 00 40 A0 A3 CF FF FF EA 09 00 A0 E1 1C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? FE 75 47 E2 07 70 96 E1 17 00 00 0A 01 00 56 E3 02 41 80 02 00 40 A0 11 C4 FF FF EA FE 05 A0 E3 ?? ?? ?? ?? D9 FF FF EA FE 35 A0 E3 07 30 83 E2 03 00 57 E1 B3 01 00 DA 00 00 55 E3 B6 FF FF DA A8 07 9F E5 00 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 B6 FF FF EA 09 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 B1 FF FF EA 09 00 A0 E1 00 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 AA FF FF EA 02 05 57 E3 7E 10 E0 A3 04 00 00 AA 4B 14 A0 E3 02 15 81 E2 ?? ?? ?? ?? 96 10 E0 E3 00 70 A0 E1 73 39 A0 E3 FF 24 C7 E3 47 3E 83 E2 02 25 C2 E3 01 30 83 E2 C7 7B 81 E0 03 00 52 E1 18 70 8D E5 FE 75 82 E3 44 01 00 CA 01 37 A0 E3 00 10 A0 E3 10 30 8D E5 14 10 8D E5 10 C7 9F E5 14 10 9D E5 01 11 9C E7 07 00 A0 E1 00 C0 8D E5 0C 10 8D E5 ?? ?? ?? ?? 07 10 A0 E1 00 B0 A0 E1 0C 00 9D E5 ?? ?? ?? ?? 00 10 A0 E1 FE 05 A0 E3 ?? ?? ?? ?? 00 20 A0 E1 02 10 A0 E1 0B 00 A0 E1 08 20 8D E5 ?? ?? ?? ?? 10 10 9D E5 C7 30 A0 E1 07 90 A0 E1 02 32 83 E3 FF 7E C0 E3 0F 70 C7 E3 01 30 83 E0 00 A0 A0 E1 03 10 A0 E1 07 00 A0 E1 04 30 8D E5 ?? ?? ?? ?? 00 10 A0 E1 0B 00 A0 E1 ?? ?? ?? ?? 04 30 9D E5 00 B0 A0 E1 0C 10 9D E5 03 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 09 00 A0 E1 ?? ?? ?? ?? 07 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 0B 00 A0 E1 ?? ?? ?? ?? 08 20 9D E5 02 10 A0 E1 ?? ?? ?? ?? 0A 10 A0 E1 00 B0 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 00 90 A0 E1 ?? ?? ?? ?? 30 16 9F E5 00 30 A0 E1 09 00 A0 E1 04 30 8D E5 ?? ?? ?? ?? 20 16 9F E5 ?? ?? ?? ?? 09 10 A0 E1 ?? ?? ?? ?? 14 16 9F E5 ?? ?? ?? ?? 09 10 A0 E1 ?? ?? ?? ?? 08 16 9F E5 ?? ?? ?? ?? 09 10 A0 E1 ?? ?? ?? ?? FC 15 9F E5 ?? ?? ?? ?? 09 10 A0 E1 ?? ?? ?? ?? F0 15 9F E5 ?? ?? ?? ?? 04 30 9D E5 00 10 A0 E1 03 00 A0 E1 ?? ?? ?? ?? 07 10 A0 E1 00 90 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 0B 10 A0 E1 ?? ?? ?? ?? 09 10 A0 E1 ?? ?? ?? ?? 07 10 A0 E1 10 00 8D E5 07 00 A0 E1 ?? ?? ?? ?? 01 11 A0 E3 01 15 81 E2 04 00 8D E5 ?? ?? ?? ?? 10 10 9D E5 ?? ?? ?? ?? FF 9E C0 E3 0F 90 C9 E3 09 10 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 09 10 A0 E1 00 70 A0 E1 0B 00 A0 E1 ?? ?? ?? ?? 01 11 A0 E3 00 B0 A0 E1 01 15 81 E2 09 00 A0 E1 ?? ?? ?? ?? 04 30 9D E5 03 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 10 00 9D E5 ?? ?? ?? ?? 0A 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 0B 00 A0 E1 ?? ?? ?? ?? 00 90 A0 E1 09 10 A0 E1 07 00 A0 E1 ?? ?? ?? ?? FD 15 A0 E3 FF AE C0 E3 0F A0 CA E3 36 18 81 E2 0E 1B 81 E2 0A 00 A0 E1 ?? ?? ?? ?? DA 15 A0 E3 77 19 81 E2 10 00 8D E5 3A 1E 81 E2 0A 00 A0 E1 ?? ?? ?? ?? 07 10 A0 E1 00 B0 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 09 00 A0 E1 ?? ?? ?? ?? 00 C0 9D E5 14 30 9D E5 C8 14 9F E5 03 71 8C E0 ?? ?? ?? ?? 00 10 A0 E1 0B 00 A0 E1 ?? ?? ?? ?? 08 10 97 E5 ?? ?? ?? ?? 00 A0 A0 E1 18 00 9D E5 ?? ?? ?? ?? 10 90 97 E5 00 B0 A0 E1 0A 10 A0 E1 10 00 9D E5 ?? ?? ?? ?? 09 10 A0 E1 ?? ?? ?? ?? 0B 10 A0 E1 ?? ?? ?? ?? FF 7E C0 E3 0F 70 C7 E3 0B 10 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 09 10 A0 E1 ?? ?? ?? ?? 10 10 9D E5 ?? ?? ?? ?? 00 10 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 01 60 46 E2 FF 5E C5 E3 08 60 96 E1 0F 50 C5 E3 BF 64 A0 03 00 A0 A0 E1 05 10 A0 E1 04 00 A0 E1 FE 65 A0 13 02 65 86 02 ?? ?? ?? ?? 07 10 A0 E1 ?? ?? ?? ?? 0A 10 A0 E1 00 80 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 00 80 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 00 50 A0 E1 00 10 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 00 90 A0 E1 00 40 A0 E1 05 A0 A0 E1 02 71 C0 E3 99 00 00 DA 43 04 57 E3 79 00 00 CA 6C 00 00 0A 3F 04 57 E3 00 90 A0 D3 09 70 A0 D1 7B 00 00 CA 0A 10 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 3F 14 A0 E3 FF 4E C0 E3 0F 40 C4 E3 C5 19 81 E2 04 00 A0 E1 32 1C 81 E2 ?? ?? ?? ?? 0A 10 A0 E1 00 50 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 64 13 9F E5 ?? ?? ?? ?? 60 13 9F E5 00 80 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 00 80 A0 E1 08 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 00 40 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 00 80 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 10 13 9F E5 00 50 A0 E1 ?? ?? ?? ?? 08 13 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? FC 12 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? F0 12 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? E4 12 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 50 A0 E1 05 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 01 11 A0 E3 00 A0 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 08 10 A0 E1 00 50 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 08 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 FE 05 A0 E3 ?? ?? ?? ?? 09 10 80 E0 C1 3B A0 E1 00 00 53 E3 82 00 00 DA 06 00 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 53 FE FF EA 5D 38 A0 E3 B3 3C 83 E2 D6 30 83 E2 03 00 52 E1 70 00 00 CA 09 37 A0 E3 01 10 A0 E3 10 30 8D E5 14 10 8D E5 B4 FE FF EA 20 12 9F E5 08 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 00 A0 A0 E1 09 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 06 00 00 DA B0 11 9F E5 06 00 A0 E1 ?? ?? ?? ?? A4 11 9F E5 ?? ?? ?? ?? 00 40 A0 E1 36 FE FF EA C7 3B A0 E1 7F 30 43 E2 02 25 A0 E3 01 30 83 E2 52 33 84 E0 02 11 C3 E3 FF 24 C3 E3 C1 1B A0 E1 7F 10 41 E2 02 25 C2 E3 17 00 61 E2 02 25 82 E3 52 70 A0 E1 02 25 A0 E3 01 20 42 E2 00 00 54 E3 52 11 C3 E1 05 00 A0 E1 00 70 67 B2 ?? ?? ?? ?? 87 9B A0 E1 00 A0 A0 E1 6C FF FF EA 43 34 A0 E3 16 38 83 E2 03 00 57 E1 06 00 00 CA 63 FF FF 1A 05 10 A0 E1 ?? ?? ?? ?? 08 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 DD FF FF BA DA 16 A0 E3 09 19 81 E2 26 1E 81 E2 06 00 A0 E1 ?? ?? ?? ?? DA 16 A0 E3 09 19 81 E2 26 1E 81 E2 ?? ?? ?? ?? 00 40 A0 E1 09 FE FF EA FE 15 A0 E3 ?? ?? ?? ?? FE 15 A0 E3 E2 19 81 E2 2A 1C 81 E2 00 70 A0 E1 ?? ?? ?? ?? 08 11 9F E5 00 90 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 07 10 A0 E1 00 A0 A0 E1 07 00 A0 E1 ?? ?? ?? ?? BE 14 A0 E3 00 B0 A0 E1 02 15 81 E2 07 00 A0 E1 ?? ?? ?? ?? A4 10 9F E5 ?? ?? ?? ?? 07 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 3F 04 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 0B 00 A0 E1 ?? ?? ?? ?? B0 10 9F E5 ?? ?? ?? ?? 00 10 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 00 A0 A0 E1 0A 10 A0 E1 09 00 A0 E1 ?? ?? ?? ?? FF 7E C0 E3 0F 70 C7 E3 09 10 A0 E1 07 00 A0 E1 FD FE FF EA 18 30 9D E5 01 30 83 E2 18 30 8D E5 01 17 A0 E3 00 30 A0 E3 02 75 47 E2 10 10 8D E5 14 30 8D E5 3F FE FF EA 07 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 78 FF FF EA ?? ?? ?? ?? CA F2 49 71 ?? ?? ?? ?? 42 F1 53 3E 55 32 6C 3E 05 A3 8B 3E AB AA AA 3E B7 6D DB 3E 9A 99 19 3F 4F 38 76 3F 18 72 31 3F 8C BE BF 35 4C BB 31 33 0E EA DD 35 55 B3 8A 38 61 0B 36 3B AB AA 2A 3E 3C AA 38 33 70 A5 EC 36 3B AA B8 BF }
	condition:
		$1
}

rule file_11_0_1 {
	meta:
		name = "__ieee754_sqrtf"
		size = 272
		refs = "00dc __mulsf3 00e8 __addsf3 00fc __subsf3 0104 __divsf3"
	strings:
		$1 = { 02 21 E0 E3 02 25 42 E2 02 11 C0 E3 02 00 51 E1 30 40 2D E9 00 30 A0 E1 00 40 A0 E1 2D 00 00 8A 00 00 51 E3 29 00 00 0A 00 00 50 E3 31 00 00 BA 02 05 51 E3 C0 5B A0 E1 08 00 00 2A 02 25 10 E2 00 20 A0 13 03 00 00 1A 83 30 A0 E1 02 05 13 E3 01 20 82 E2 FB FF FF 0A 01 50 85 E2 05 50 62 E0 FF 34 C3 E3 7F 50 45 E2 02 35 C3 E3 02 35 83 E3 01 00 15 E3 00 10 A0 E3 83 30 A0 11 83 30 A0 E1 01 40 A0 E1 01 C0 A0 E1 01 24 A0 E3 02 00 8C E0 03 00 50 E1 01 10 81 E2 03 30 60 D0 02 40 84 D0 02 C0 80 D0 19 00 51 E3 83 30 A0 E1 A2 20 A0 E1 F5 FF FF 1A 00 00 53 E3 01 30 04 12 04 40 83 10 C5 30 A0 E1 83 3B A0 E1 3F 34 83 E2 C4 40 83 E0 04 00 A0 E1 30 80 BD E8 00 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 04 00 A0 E1 30 80 BD E8 00 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 EF FF FF EA }
	condition:
		$1
}

rule file_12_0_1 {
	meta:
		name = "tanh"
		size = 432
		refs = "0040 __divdf3 0050 __adddf3 00b0 fabs 00c0 expm1 0124 __subdf3 0154 __muldf3"
	strings:
		$1 = { 02 31 E0 E3 01 36 43 E2 02 21 C0 E3 03 00 52 E1 70 40 2D E9 00 50 A0 E1 01 60 A0 E1 00 40 A0 E1 10 00 00 DA 00 00 50 E3 34 00 00 BA 00 20 A0 E1 FF 05 A0 E3 01 30 A0 E1 03 06 80 E2 00 10 A0 E3 ?? ?? ?? ?? FF 25 A0 E3 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 30 A0 E1 01 20 A0 E1 03 00 A0 E1 02 10 A0 E1 70 80 BD E8 BF 34 E0 E3 CA 38 43 E2 03 00 52 E1 FF 35 A0 C3 03 36 83 C2 00 20 A0 C3 04 00 00 DA 00 00 54 E3 02 31 83 B2 03 00 A0 E1 02 10 A0 E1 70 80 BD E8 F2 05 52 E3 26 00 00 BA 03 31 E0 E3 01 36 43 E2 03 00 52 E1 2C 00 00 DA ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 01 21 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 03 01 A0 E3 00 10 A0 E3 ?? ?? ?? ?? FF 25 A0 E3 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 30 A0 E1 01 20 A0 E1 E0 FF FF EA 00 20 A0 E1 FF 05 A0 E3 01 30 A0 E1 03 06 80 E2 00 10 A0 E3 ?? ?? ?? ?? FF 25 A0 E3 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 30 A0 E1 01 20 A0 E1 03 00 A0 E1 02 10 A0 E1 70 80 BD E8 FF 25 A0 E3 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 00 30 A0 E1 01 20 A0 E1 BD FF FF EA ?? ?? ?? ?? 03 21 A0 E3 00 30 A0 E3 ?? ?? ?? ?? ?? ?? ?? ?? 01 21 A0 E3 00 30 A0 E3 00 60 A0 E1 01 50 A0 E1 ?? ?? ?? ?? 02 61 86 E2 00 20 A0 E1 01 30 A0 E1 06 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 30 A0 E1 01 20 A0 E1 B4 FF FF EA }
	condition:
		$1
}

rule file_13_0_1 {
	meta:
		name = "__ieee754_acosf"
		size = 1012
		refs = "0038 __mulsf3 004c __addsf3 005c __subsf3 00f8 __divsf3 0184 __ieee754_sqrtf"
	strings:
		$1 = { 02 31 C0 E3 FE 05 53 E3 F0 40 2D E9 00 40 A0 E1 4D 00 00 0A 47 00 00 CA 3F 04 53 E3 50 00 00 AA 23 04 53 E3 DB 09 E0 D3 03 0A 40 D2 93 01 40 D2 F0 80 BD D8 04 10 A0 E1 ?? ?? ?? ?? 8C 13 9F E5 00 50 A0 E1 ?? ?? ?? ?? 84 13 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 78 13 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 6C 13 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 60 13 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 54 13 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 48 13 9F E5 00 60 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 3C 13 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 55 1B A0 E3 CB 1F 81 E2 05 11 81 E2 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 67 19 A0 E3 11 1C 81 E2 E5 11 81 E2 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 DC 02 9F E5 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 DB 09 E0 E3 03 0A 40 E2 97 01 40 E2 ?? ?? ?? ?? F0 80 BD E8 00 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 ?? ?? ?? ?? F0 80 BD E8 00 00 50 E3 49 08 A0 D3 FD 0E 80 D2 2D 01 80 D2 00 00 A0 C3 F0 80 BD E8 00 00 50 E3 52 00 00 BA 00 10 A0 E1 FE 05 A0 E3 ?? ?? ?? ?? 3F 14 A0 E3 ?? ?? ?? ?? 00 40 A0 E1 ?? ?? ?? ?? 40 12 9F E5 00 60 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 34 12 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 28 12 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 1C 12 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 10 12 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 04 12 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? F8 11 9F E5 00 50 A0 E1 04 00 A0 E1 ?? ?? ?? ?? EC 11 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 55 1B A0 E3 CB 1F 81 E2 05 11 81 E2 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 67 19 A0 E3 11 1C 81 E2 E5 11 81 E2 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? FF 5E C6 E3 0F 50 C5 E3 00 70 A0 E1 05 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 00 40 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 ?? ?? ?? ?? F0 80 BD E8 FE 15 A0 E3 ?? ?? ?? ?? 3F 14 A0 E3 ?? ?? ?? ?? 00 40 A0 E1 ?? ?? ?? ?? F8 10 9F E5 00 50 A0 E1 04 00 A0 E1 ?? ?? ?? ?? EC 10 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? E0 10 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? D4 10 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? C8 10 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? BC 10 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? B0 10 9F E5 00 60 A0 E1 04 00 A0 E1 ?? ?? ?? ?? A4 10 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 55 1B A0 E3 CB 1F 81 E2 05 11 81 E2 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 67 19 A0 E3 11 1C 81 E2 E5 11 81 E2 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 48 10 9F E5 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 03 11 A0 E3 ?? ?? ?? ?? 49 18 A0 E3 FD 1E 81 E2 29 11 81 E2 ?? ?? ?? ?? F0 80 BD E8 08 EF 11 38 04 7F 4F 3A 46 11 24 3D A8 0A 4E 3E 90 B0 A6 3E AB AA 2A 3E 2E C6 9D 3D 61 33 30 3F 68 21 A2 33 }
	condition:
		$1
}

rule file_14_0_1 {
	meta:
		name = "__ieee754_atanh"
		size = 460
		refs = "0054 __adddf3 0060 __gtdf2 0098 __muldf3 00b8 __subdf3 00cc __divdf3 0140 log1p"
	strings:
		$1 = { F0 4D 2D E9 01 70 A0 E1 00 10 61 E2 07 20 81 E1 02 61 C0 E3 FF 35 A0 E3 A2 2F 86 E1 03 36 83 E2 03 00 52 E1 00 A0 A0 E1 00 40 A0 E1 4F 00 00 8A 03 00 56 E1 59 00 00 0A C1 34 E0 E3 0D 36 43 E2 03 00 56 E1 25 00 00 CA 5D 3F 8F E2 0C 00 93 E8 07 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 3D 00 00 CA 06 50 A0 E1 07 60 A0 E1 05 20 A0 E1 06 30 A0 E1 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 00 A0 A0 E1 01 B0 A0 E1 ?? ?? ?? ?? 00 70 A0 E1 FF 05 A0 E3 01 80 A0 E1 05 20 A0 E1 06 30 A0 E1 03 06 80 E2 00 10 A0 E3 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? 17 00 00 EA 03 11 E0 E3 02 16 41 E2 01 00 56 E1 06 20 A0 E1 06 50 A0 E1 07 60 A0 E1 DD FF FF DA 07 30 A0 E1 07 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 70 A0 E1 FF 05 A0 E3 01 80 A0 E1 05 20 A0 E1 06 30 A0 E1 03 06 80 E2 00 10 A0 E3 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? FF 25 A0 E3 02 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 00 54 E3 01 70 A0 E1 00 A0 A0 A1 02 A1 80 B2 0A 00 A0 E1 07 10 A0 E1 F0 8D BD E8 07 30 A0 E1 00 20 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 00 A0 A0 E1 01 70 A0 E1 0A 00 A0 E1 07 10 A0 E1 F0 8D BD E8 07 10 A0 E1 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 A0 A0 E1 01 70 A0 E1 0A 00 A0 E1 07 10 A0 E1 F0 8D BD E8 3C E4 37 7E 9C 75 00 88 }
	condition:
		$1
}

rule file_15_0_1 {
	meta:
		name = "tanhf"
		size = 248
		refs = "0030 __divsf3 0038 __addsf3 0070 fabsf 007c expm1f 00b0 __subsf3 00c4 __mulsf3"
	strings:
		$1 = { 02 31 E0 E3 02 35 43 E2 02 21 C0 E3 03 00 52 E1 30 40 2D E9 00 50 A0 E1 00 40 A0 E1 07 00 00 DA 00 00 50 E3 1D 00 00 BA 00 10 A0 E1 FE 05 A0 E3 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 30 80 BD E8 BE 34 E0 E3 05 36 43 E2 03 00 52 E1 FE 05 A0 C3 02 00 00 DA 00 00 54 E3 02 01 80 B2 30 80 BD E8 77 03 72 E3 13 00 00 DA FE 05 52 E3 16 00 00 BA ?? ?? ?? ?? 00 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 01 11 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 03 01 A0 E3 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? EC FF FF EA 00 10 A0 E1 FE 05 A0 E3 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 30 80 BD E8 FE 15 A0 E3 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 30 80 BD E8 ?? ?? ?? ?? 03 11 A0 E3 ?? ?? ?? ?? ?? ?? ?? ?? 01 11 A0 E3 02 51 80 E2 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? D6 FF FF EA }
	condition:
		$1
}

rule file_16_0_1 {
	meta:
		name = "powf"
		size = 1308
		refs = "0010 __ieee754_powf 002c isnanf 005c __eqsf2 0080 __extendsfdf2 00c8 __truncdfsf2 0168 matherr 0180 __errno 0194 finitef 0260 __ltsf2 0368 __divdf3 0478 __mulsf3 0488 rint 049c __nedf2 0514 __fdlib_version"
	strings:
		$1 = { F0 45 2D E9 24 D0 4D E2 00 70 A0 E1 01 60 A0 E1 ?? ?? ?? ?? F8 44 9F E5 00 30 94 E5 01 00 73 E3 00 50 A0 E1 03 00 00 0A 06 00 A0 E1 ?? ?? ?? ?? 00 80 50 E2 02 00 00 0A 05 00 A0 E1 24 D0 8D E2 F0 85 BD E8 07 00 A0 E1 ?? ?? ?? ?? 00 A0 50 E2 1F 00 00 0A 06 00 A0 E1 00 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 F3 FF FF 1A 01 30 A0 E3 00 30 8D E5 A0 34 9F E5 07 00 A0 E1 04 30 8D E5 20 80 8D E5 ?? ?? ?? ?? 08 00 8D E5 0C 10 8D E5 06 00 A0 E1 ?? ?? ?? ?? 00 30 94 E5 01 00 73 E3 02 00 53 13 FF 35 A0 E3 03 36 83 E2 00 40 A0 E3 10 00 8D E5 14 10 8D E5 18 30 8D E5 1C 40 8D E5 28 00 00 1A 18 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 50 A0 E1 D8 FF FF EA 07 00 A0 E1 00 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 29 00 00 1A 06 00 A0 E1 00 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 52 00 00 1A 01 30 A0 E3 00 30 8D E5 0C 34 9F E5 07 00 A0 E1 04 30 8D E5 20 A0 8D E5 ?? ?? ?? ?? 08 00 8D E5 0C 10 8D E5 06 00 A0 E1 ?? ?? ?? ?? 00 30 94 E5 00 40 A0 E3 00 00 53 E3 00 30 A0 E3 18 30 8D E5 1C 40 8D E5 10 00 8D E5 14 10 8D E5 05 00 00 0A FF 35 A0 E3 03 36 83 E2 00 40 A0 E3 18 30 8D E5 1C 40 8D E5 D6 FF FF EA 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 58 00 00 0A 20 30 9D E5 00 00 53 E3 CF FF FF 0A ?? ?? ?? ?? 20 30 9D E5 00 30 80 E5 CB FF FF EA 05 00 A0 E1 ?? ?? ?? ?? 00 80 50 E2 51 00 00 0A 05 00 A0 E1 00 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 A0 FF FF 1A 07 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 9C FF FF 0A 06 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 98 FF FF 0A 04 30 A0 E3 00 30 8D E5 34 33 9F E5 07 00 A0 E1 04 30 8D E5 00 30 A0 E3 20 30 8D E5 ?? ?? ?? ?? 08 00 8D E5 0C 10 8D E5 06 00 A0 E1 ?? ?? ?? ?? 00 30 94 E5 00 40 A0 E3 02 00 53 E3 00 30 A0 E3 18 30 8D E5 1C 40 8D E5 10 00 8D E5 14 10 8D E5 5E 00 00 0A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 5A 00 00 0A 20 30 9D E5 00 00 53 E3 9E FF FF 0A CD FF FF EA 06 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 77 FF FF 0A 06 00 A0 E1 00 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 72 FF FF AA 01 30 A0 E3 00 30 8D E5 9C 32 9F E5 07 00 A0 E1 04 30 8D E5 20 A0 8D E5 ?? ?? ?? ?? 08 00 8D E5 0C 10 8D E5 06 00 A0 E1 ?? ?? ?? ?? 00 30 94 E5 00 00 53 E3 10 00 8D E5 14 10 8D E5 38 00 00 0A 02 00 53 E3 02 31 A0 E3 C3 35 A0 E1 00 40 A0 E3 18 30 8D E5 1C 40 8D E5 2C 00 00 1A ?? ?? ?? ?? 21 30 A0 E3 00 30 80 E5 D7 FF FF EA ?? ?? ?? ?? 21 30 A0 E3 00 30 80 E5 A2 FF FF EA 07 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 A9 FF FF 0A 06 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 A5 FF FF 0A 05 00 A0 E1 ?? ?? ?? ?? 00 30 50 E2 26 00 00 0A 01 30 A0 E3 00 30 8D E5 F0 31 9F E5 07 00 A0 E1 04 30 8D E5 20 80 8D E5 ?? ?? ?? ?? 08 00 8D E5 0C 10 8D E5 06 00 A0 E1 ?? ?? ?? ?? 00 40 94 E5 00 00 54 E3 10 00 8D E5 14 10 8D E5 0D 00 00 0A 00 00 A0 E3 00 10 A0 E3 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 02 00 54 E3 18 00 8D E5 1C 10 8D E5 D2 FF FF 0A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 AA FF FF 1A CD FF FF EA 00 30 A0 E3 00 40 A0 E3 18 30 8D E5 1C 40 8D E5 F5 FF FF EA ?? ?? ?? ?? 22 30 A0 E3 00 30 80 E5 A0 FF FF EA 03 20 A0 E3 00 20 8D E5 54 21 9F E5 07 00 A0 E1 04 20 8D E5 20 30 8D E5 ?? ?? ?? ?? 08 00 8D E5 0C 10 8D E5 06 00 A0 E1 ?? ?? ?? ?? 00 50 94 E5 00 00 55 E3 10 00 8D E5 14 10 8D E5 11 00 00 1A 2E 23 E0 E3 01 26 42 E2 0E 32 A0 E3 07 00 A0 E1 00 10 A0 E3 18 20 8D E5 1C 30 8D E5 ?? ?? ?? ?? 00 00 50 E3 14 00 00 BA 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 51 FF FF 1A ?? ?? ?? ?? 22 30 A0 E3 00 30 80 E5 4D FF FF EA 7F 24 A0 E3 0F 26 82 E2 00 30 A0 E3 07 00 A0 E1 00 10 A0 E3 18 20 8D E5 1C 30 8D E5 ?? ?? ?? ?? 00 00 50 E3 17 00 00 BA 02 00 55 E3 EB FF FF 1A EE FF FF EA 06 00 A0 E1 3F 14 A0 E3 ?? ?? ?? ?? ?? ?? ?? ?? 00 50 A0 E1 01 60 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 18 00 00 0A 0E 23 E0 E3 01 26 42 E2 0E 32 A0 E3 18 20 8D E5 1C 30 8D E5 00 50 94 E5 E7 FF FF EA 06 00 A0 E1 3F 14 A0 E3 ?? ?? ?? ?? ?? ?? ?? ?? 00 50 A0 E1 01 60 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 02 21 A0 13 C2 25 A0 11 00 30 A0 13 18 20 8D 15 1C 30 8D 15 00 50 94 E5 D3 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_0_1 {
	meta:
		name = "__ieee754_sinhf"
		size = 416
		refs = "0044 __addsf3 004c __gtsf2 005c fabsf 0060 expm1f 0080 __mulsf3 009c __divsf3 00a8 __subsf3 010c __ieee754_expf"
	strings:
		$1 = { 02 31 E0 E3 F0 40 2D E9 02 35 43 E2 02 61 C0 E3 03 00 56 E1 00 40 A0 E1 33 00 00 CA BE 34 E0 E3 00 00 50 E3 05 36 43 E2 BF 54 A0 B3 3F 54 A0 A3 03 00 56 E1 21 00 00 CA C6 05 56 E3 3C 00 00 AA 4C 11 9F E5 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 00 00 50 E3 17 00 00 CA 04 00 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 00 40 A0 E1 04 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 00 60 A0 E1 04 00 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 00 70 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 04 00 A0 E1 F0 80 BD E8 D0 30 9F E5 03 00 56 E1 2B 00 00 DA C8 30 9F E5 03 00 56 E1 09 00 00 DA B4 10 9F E5 ?? ?? ?? ?? 00 40 A0 E1 04 00 A0 E1 F0 80 BD E8 00 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 04 00 A0 E1 F0 80 BD E8 ?? ?? ?? ?? 3F 14 A0 E3 ?? ?? ?? ?? ?? ?? ?? ?? 00 40 A0 E1 04 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 E0 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? FE 05 56 E3 00 40 A0 E1 C7 FF FF BA FE 15 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 04 00 A0 E1 F0 80 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 C8 FF FF EA C2 BD F0 7C 17 72 B1 42 FC D4 B2 42 }
	condition:
		$1
}

rule file_18_0_1 {
	meta:
		name = "atan"
		size = 1204
		refs = "00ac __muldf3 00e0 __adddf3 017c __subdf3 0288 __gtdf2 0298 fabs 030c __divdf3"
	strings:
		$1 = { F0 4D 2D E9 BB 34 E0 E3 0F 36 43 E2 02 71 C0 E3 03 00 57 E1 04 D0 4D E2 00 40 A0 E1 00 60 A0 E1 01 50 A0 E1 13 00 00 DA 7F 34 A0 E3 0F 36 83 E2 03 00 57 E1 82 00 00 CA 00 20 A0 13 01 20 A0 03 00 00 51 E3 00 30 A0 03 01 30 02 12 00 00 53 E3 7B 00 00 1A 6D 4A E0 E3 0E 4C 44 E2 04 30 A0 E1 11 31 43 E2 00 00 50 E3 13 41 44 E2 38 54 9F E5 03 40 A0 D1 79 00 00 EA 03 31 E0 E3 09 37 43 E2 03 00 57 E1 83 00 00 CA C1 34 E0 E3 0E 36 43 E2 03 00 57 E1 75 00 00 DA 00 A0 E0 E3 04 20 A0 E1 05 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 00 B0 A0 E1 00 10 8D E5 ?? ?? ?? ?? 0E 3D 8F E2 0C 00 93 E8 00 70 A0 E1 01 80 A0 E1 ?? ?? ?? ?? DD 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? D9 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? D5 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? D1 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? CD 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 00 C0 9D E5 0B 20 A0 E1 0C 30 A0 E1 ?? ?? ?? ?? 32 3E 8F E2 0C 00 93 E8 01 C0 A0 E1 00 B0 A0 E1 08 10 A0 E1 07 00 A0 E1 00 C0 8D E5 ?? ?? ?? ?? C2 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? BE 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? BA 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? B6 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? 01 00 7A E3 00 20 A0 E1 01 30 A0 E1 00 C0 9D E5 4D 00 00 0A 0C 10 A0 E1 BC C2 9F E5 0B 00 A0 E1 8A A1 8C E0 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 20 30 8A E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 03 00 9A E8 ?? ?? ?? ?? 00 00 56 E3 01 50 A0 E1 00 40 A0 A1 02 41 80 B2 06 00 00 EA 04 20 A0 E1 04 00 A0 E1 05 30 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 04 00 A0 E1 05 10 A0 E1 04 D0 8D E2 F0 8D BD E8 8B 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? FF 25 A0 E3 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 80 FF FF DA F1 FF FF EA ?? ?? ?? ?? 03 31 E0 E3 0D 38 43 E2 03 00 57 E1 00 40 A0 E1 01 50 A0 E1 28 00 00 CA 03 31 E0 E3 1A 38 43 E2 03 00 57 E1 4C 00 00 CA 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? FF 25 A0 E3 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 01 21 A0 E3 00 70 A0 E1 01 80 A0 E1 04 00 A0 E1 05 10 A0 E1 00 30 A0 E3 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 A0 A0 E3 00 40 A0 E1 01 50 A0 E1 5E FF FF EA 0C 10 A0 E1 0B 00 A0 E1 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 C1 FF FF EA BF 34 E0 E3 3F 37 43 E2 02 39 43 E2 03 00 57 E1 18 00 00 CA FF 25 A0 E3 0E 27 82 E2 00 30 A0 E3 ?? ?? ?? ?? FF 25 A0 E3 00 70 A0 E1 01 80 A0 E1 04 00 A0 E1 05 10 A0 E1 0E 27 82 E2 00 30 A0 E3 ?? ?? ?? ?? FF 25 A0 E3 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 02 A0 A0 E3 00 40 A0 E1 01 50 A0 E1 32 FF FF EA 00 20 A0 E1 BF 04 A0 E3 01 30 A0 E1 0F 06 80 E2 00 10 A0 E3 ?? ?? ?? ?? 03 A0 A0 E3 00 40 A0 E1 01 50 A0 E1 28 FF FF EA FF 25 A0 E3 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? FF 25 A0 E3 00 70 A0 E1 01 80 A0 E1 04 00 A0 E1 05 10 A0 E1 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 01 A0 A0 E3 00 40 A0 E1 01 50 A0 E1 13 FF FF EA 3A AD 90 3F 11 DA 22 E3 4B 7B A9 3F EB 0D 76 24 66 0D B1 3F 51 3D D0 A0 CD 45 B7 3F 6E 20 4C C5 24 49 C2 3F FF 83 00 92 55 55 D5 3F 0D 55 55 55 44 B4 A2 BF 2F 6C 6A 2C 2D DE AD 3F 9A FD DE 52 F2 B0 B3 3F 6D 9A 74 AF C6 71 BC 3F 71 16 23 FE 99 99 C9 3F C4 EB 98 99 3C E4 37 7E 9C 75 00 88 18 2D 44 54 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_19_0_1 {
	meta:
		name = "exp2"
		size = 20
		refs = "0010 pow"
	strings:
		$1 = { 00 20 A0 E1 01 30 A0 E1 01 01 A0 E3 00 10 A0 E3 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_0_1 {
	meta:
		name = "pzerof"
		size = 324
		refs = "0048 __mulsf3 0054 __divsf3 0068 __addsf3"
		altNames = "ponef"
	strings:
		$1 = { 02 21 C0 E3 41 04 52 E3 70 40 2D E9 45 00 00 AA F7 38 A0 E3 71 3D 83 E2 5D 31 83 E2 03 00 52 E1 3D 00 00 CA DB 39 A0 E3 6D 3D 83 E2 9D 31 83 E2 03 00 52 E1 F8 60 9F D5 F8 60 9F C5 14 50 86 D2 14 50 86 C2 00 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 FE 05 A0 E3 ?? ?? ?? ?? 14 10 95 E5 00 40 A0 E1 ?? ?? ?? ?? 10 10 95 E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 0C 10 95 E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 08 10 95 E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 04 10 95 E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 00 10 95 E5 ?? ?? ?? ?? 10 10 96 E5 00 50 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 0C 10 96 E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 08 10 96 E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 04 10 96 E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 00 10 96 E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 70 80 BD E8 18 60 9F E5 14 50 86 E2 C6 FF FF EA 10 60 9F E5 14 50 86 E2 C3 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_1_1 {
	meta:
		name = "qzerof"
		size = 356
		refs = "0050 __mulsf3 005c __divsf3 0070 __addsf3 012c __subsf3"
	strings:
		$1 = { 02 21 C0 E3 41 04 52 E3 F0 40 2D E9 00 70 A0 E1 4C 00 00 AA F7 38 A0 E3 71 3D 83 E2 5D 31 83 E2 03 00 52 E1 44 00 00 CA DB 39 A0 E3 6D 3D 83 E2 9D 31 83 E2 03 00 52 E1 14 51 9F D5 14 51 9F C5 18 60 85 D2 18 60 85 C2 07 10 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 FE 05 A0 E3 ?? ?? ?? ?? 14 10 96 E5 00 40 A0 E1 ?? ?? ?? ?? 10 10 96 E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 0C 10 96 E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 08 10 96 E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 04 10 96 E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 00 10 96 E5 ?? ?? ?? ?? 14 10 95 E5 00 60 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 10 10 95 E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 0C 10 95 E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 08 10 95 E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 04 10 95 E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 00 10 95 E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 3E 14 A0 E3 ?? ?? ?? ?? 07 10 A0 E1 ?? ?? ?? ?? F0 80 BD E8 18 50 9F E5 18 60 85 E2 BF FF FF EA 10 50 9F E5 18 60 85 E2 BC FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_2_1 {
	meta:
		name = "__ieee754_j0f"
		size = 720
		refs = "001c __mulsf3 0028 __divsf3 0030 fabsf 004c __addsf3 0054 __gtsf2 00c0 __subsf3 01bc sinf 01c8 cosf 0214 __ieee754_sqrtf 027c __ltsf2"
	strings:
		$1 = { 02 31 E0 E3 F0 45 2D E9 02 35 43 E2 02 41 C0 E3 03 00 54 E1 00 10 A0 E1 04 00 00 DA ?? ?? ?? ?? 00 10 A0 E1 FE 05 A0 E3 ?? ?? ?? ?? F0 85 BD E8 ?? ?? ?? ?? 07 01 74 E3 00 60 A0 E1 5E 00 00 CA 39 04 54 E3 12 00 00 AA 60 12 9F E5 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 00 00 50 E3 0C 00 00 DA 32 04 54 E3 FE 05 A0 B3 F0 85 BD B8 BE 14 A0 E3 06 00 A0 E1 02 15 81 E2 ?? ?? ?? ?? 00 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? F0 85 BD E8 06 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 0C 12 9F E5 00 50 A0 E1 ?? ?? ?? ?? 04 12 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? F8 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? F2 15 A0 E3 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? DC 11 9F E5 00 80 A0 E1 05 00 A0 E1 ?? ?? ?? ?? D0 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? C4 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 62 1D E0 E3 EF 11 41 E2 0E 15 41 E2 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? FE 05 54 E3 00 70 A0 E1 16 00 00 BA 06 00 A0 E1 3F 14 A0 E3 ?? ?? ?? ?? 07 10 A0 E1 00 40 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 00 50 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 00 60 A0 E1 FE 05 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? F0 85 BD E8 00 10 A0 E1 08 00 A0 E1 ?? ?? ?? ?? FA 15 A0 E3 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? F0 85 BD E8 ?? ?? ?? ?? 00 50 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 00 70 A0 E1 07 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 07 10 A0 E1 00 80 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 7F 04 54 E3 00 A0 A0 E1 17 00 00 BA 06 00 A0 E1 D5 FE FF EB 00 50 A0 E1 06 00 A0 E1 23 FF FF EB 00 70 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 00 40 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 07 10 A0 E1 00 50 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 80 10 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? F0 85 BD E8 06 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 07 10 A0 E1 02 41 80 E2 05 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 04 00 00 AA 04 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 A0 A0 E1 D6 FF FF EA 04 00 A0 E1 0A 10 A0 E1 ?? ?? ?? ?? 00 80 A0 E1 D1 FF FF EA CA F2 49 71 3C AF 9E B1 88 8E F5 35 2E 35 47 39 E8 45 A0 30 A6 DA 09 35 97 36 F5 38 BB 6E 10 3F }
	condition:
		$1
}

rule file_20_3_1 {
	meta:
		name = "__ieee754_y0f"
		size = 728
		refs = "0040 __mulsf3 005c __addsf3 0074 __subsf3 0118 __divsf3 0124 __ieee754_j0f 0130 __ieee754_logf 01b4 sinf 01c0 cosf 020c __ieee754_sqrtf 0284 __ltsf2"
	strings:
		$1 = { 02 31 E0 E3 F0 45 2D E9 02 35 43 E2 02 51 C0 E3 03 00 55 E1 00 40 A0 E1 55 00 00 CA 00 00 55 E3 4E 00 00 0A 00 00 50 E3 88 00 00 BA 07 01 75 E3 5F 00 00 CA 32 04 55 E3 55 00 00 DA 00 10 A0 E1 ?? ?? ?? ?? 6C 12 9F E5 00 50 A0 E1 ?? ?? ?? ?? AE 1F A0 E3 23 12 81 E2 AA 17 81 E2 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 2B 1D E0 E3 F2 13 41 E2 06 15 41 E2 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 34 12 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 28 12 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 1C 12 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 10 12 9F E5 ?? ?? ?? ?? BF 15 A0 E3 CA 19 81 E2 00 60 A0 E1 C2 10 81 E2 05 00 A0 E1 ?? ?? ?? ?? D2 15 A0 E3 B2 1A 81 E2 5B 1F 81 E2 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? DC 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? D0 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 00 50 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 60 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? DD 18 E0 E3 67 1E 41 E2 33 11 41 E2 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? F0 85 BD E8 BF 04 A0 E3 00 10 A0 E3 02 05 80 E2 ?? ?? ?? ?? F0 85 BD E8 00 10 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 FE 05 A0 E3 ?? ?? ?? ?? F0 85 BD E8 ?? ?? ?? ?? DD 18 E0 E3 67 1E 41 E2 33 11 41 E2 ?? ?? ?? ?? 18 11 9F E5 ?? ?? ?? ?? F0 85 BD E8 ?? ?? ?? ?? 00 60 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 70 A0 E1 07 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 07 10 A0 E1 00 A0 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 7F 04 55 E3 00 80 A0 E1 1B 00 00 BA 04 00 A0 E1 23 FE FF EB 00 50 A0 E1 04 00 A0 E1 71 FE FF EB 00 60 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 00 40 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 06 10 A0 E1 00 50 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 90 10 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? F0 85 BD E8 00 00 A0 E3 00 10 A0 E1 ?? ?? ?? ?? F0 85 BD E8 04 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 07 10 A0 E1 02 51 80 E2 06 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 04 00 00 AA 05 00 A0 E1 0A 10 A0 E1 ?? ?? ?? ?? 00 80 A0 E1 D2 FF FF EA 05 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 A0 A0 E1 CD FF FF EA EB 21 2F AE 69 2A B6 39 46 67 62 3C 0D E8 34 3E B5 26 97 3D E0 65 9F 38 85 93 50 3C BB 6E 10 3F }
	condition:
		$1
}

rule file_21_0_1 {
	meta:
		name = "y1"
		size = 412
		refs = "0010 __ieee754_y1 0034 __isnand 0050 __ledf2 006c __gtdf2 00bc matherr 00d4 __errno 0194 __fdlib_version"
	strings:
		$1 = { F0 45 2D E9 24 D0 4D E2 00 40 A0 E1 01 50 A0 E1 ?? ?? ?? ?? 78 61 9F E5 00 30 96 E5 01 00 73 E3 00 70 A0 E1 01 80 A0 E1 2E 00 00 0A 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 A0 50 E2 29 00 00 1A 04 00 A0 E1 05 10 A0 E1 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 26 00 00 DA 04 00 A0 E1 05 10 A0 E1 12 3E 8F E2 0C 00 93 E8 ?? ?? ?? ?? 00 00 50 E3 1B 00 00 DA 00 30 96 E5 02 00 53 E3 05 30 A0 E3 00 30 8D E5 08 31 9F E5 00 20 A0 E3 04 30 8D E5 00 30 A0 E3 20 A0 8D E5 08 40 8D E5 0C 50 8D E5 18 20 8D E5 1C 30 8D E5 10 40 8D E5 14 50 8D E5 30 00 00 0A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 2C 00 00 0A 20 30 9D E5 00 00 53 E3 02 00 00 0A ?? ?? ?? ?? 20 30 9D E5 00 30 80 E5 18 80 8D E2 80 01 98 E8 07 00 A0 E1 08 10 A0 E1 24 D0 8D E2 F0 85 BD E8 01 20 A0 E3 00 30 96 E5 00 20 8D E5 8C 20 9F E5 00 00 53 E3 04 20 8D E5 20 A0 8D E5 08 40 8D E5 0C 50 8D E5 10 40 8D E5 14 50 8D E5 0C 00 00 1A 0E 33 E0 E3 01 36 43 E2 0E 42 A0 E3 18 30 8D E5 1C 40 8D E5 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 DE FF FF 1A ?? ?? ?? ?? 21 30 A0 E3 00 30 80 E5 DA FF FF EA 02 00 53 E3 02 31 A0 E3 C3 35 A0 E1 00 40 A0 E3 18 30 8D E5 1C 40 8D E5 F4 FF FF 0A EF FF FF EA ?? ?? ?? ?? 22 30 A0 E3 00 30 80 E5 CE FF FF EA FB 21 49 43 18 2D 44 54 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_182_0_1 {
	meta:
		name = "y0"
		size = 412
		refs = "0010 __ieee754_y0 0034 __isnand 0050 __ledf2 006c __gtdf2 00bc matherr 00d4 __errno 0194 __fdlib_version"
	strings:
		$1 = { F0 45 2D E9 24 D0 4D E2 00 40 A0 E1 01 50 A0 E1 ?? ?? ?? ?? 78 61 9F E5 00 30 96 E5 01 00 73 E3 00 70 A0 E1 01 80 A0 E1 2E 00 00 0A 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 A0 50 E2 29 00 00 1A 04 00 A0 E1 05 10 A0 E1 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 26 00 00 DA 04 00 A0 E1 05 10 A0 E1 12 3E 8F E2 0C 00 93 E8 ?? ?? ?? ?? 00 00 50 E3 1B 00 00 DA 00 30 96 E5 02 00 53 E3 05 30 A0 E3 00 30 8D E5 08 31 9F E5 00 20 A0 E3 04 30 8D E5 00 30 A0 E3 20 A0 8D E5 08 40 8D E5 0C 50 8D E5 18 20 8D E5 1C 30 8D E5 10 40 8D E5 14 50 8D E5 30 00 00 0A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 2C 00 00 0A 20 30 9D E5 00 00 53 E3 02 00 00 0A ?? ?? ?? ?? 20 30 9D E5 00 30 80 E5 18 80 8D E2 80 01 98 E8 07 00 A0 E1 08 10 A0 E1 24 D0 8D E2 F0 85 BD E8 01 20 A0 E3 00 30 96 E5 00 20 8D E5 8C 20 9F E5 00 00 53 E3 04 20 8D E5 20 A0 8D E5 08 40 8D E5 0C 50 8D E5 10 40 8D E5 14 50 8D E5 0C 00 00 1A 0E 33 E0 E3 01 36 43 E2 0E 42 A0 E3 18 30 8D E5 1C 40 8D E5 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 DE FF FF 1A ?? ?? ?? ?? 21 30 A0 E3 00 30 80 E5 DA FF FF EA 02 00 53 E3 02 31 A0 E3 C3 35 A0 E1 00 40 A0 E3 18 30 8D E5 1C 40 8D E5 F4 FF FF 0A EF FF FF EA ?? ?? ?? ?? 22 30 A0 E3 00 30 80 E5 CE FF FF EA FB 21 49 43 18 2D 44 54 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_21_1_1 {
	meta:
		name = "j1"
		size = 264
		refs = "0010 __ieee754_j1 0034 __isnand 0058 fabs 0064 __gtdf2 00b4 matherr 00d8 __errno 0100 __fdlib_version"
	strings:
		$1 = { F0 45 2D E9 24 D0 4D E2 00 40 A0 E1 01 50 A0 E1 ?? ?? ?? ?? E4 60 9F E5 00 30 96 E5 01 00 73 E3 00 70 A0 E1 01 80 A0 E1 04 00 00 0A 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 A0 50 E2 03 00 00 0A 07 00 A0 E1 08 10 A0 E1 24 D0 8D E2 F0 85 BD E8 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 94 30 8F E2 0C 00 93 E8 ?? ?? ?? ?? 00 00 50 E3 F3 FF FF DA 00 30 96 E5 02 00 53 E3 05 30 A0 E3 00 30 8D E5 7C 30 9F E5 00 20 A0 E3 04 30 8D E5 00 30 A0 E3 20 A0 8D E5 08 40 8D E5 0C 50 8D E5 18 20 8D E5 1C 30 8D E5 10 40 8D E5 14 50 8D E5 09 00 00 0A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 05 00 00 0A 20 30 9D E5 00 00 53 E3 06 00 00 1A 18 80 8D E2 80 01 98 E8 D9 FF FF EA ?? ?? ?? ?? 22 30 A0 E3 00 30 80 E5 F5 FF FF EA ?? ?? ?? ?? 20 30 9D E5 00 30 80 E5 F4 FF FF EA FB 21 49 43 18 2D 44 54 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_182_1_1 {
	meta:
		name = "j0"
		size = 264
		refs = "0010 __ieee754_j0 0034 __isnand 0058 fabs 0064 __gtdf2 00b4 matherr 00d8 __errno 0100 __fdlib_version"
	strings:
		$1 = { F0 45 2D E9 24 D0 4D E2 00 40 A0 E1 01 50 A0 E1 ?? ?? ?? ?? E4 60 9F E5 00 30 96 E5 01 00 73 E3 00 70 A0 E1 01 80 A0 E1 04 00 00 0A 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 A0 50 E2 03 00 00 0A 07 00 A0 E1 08 10 A0 E1 24 D0 8D E2 F0 85 BD E8 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 94 30 8F E2 0C 00 93 E8 ?? ?? ?? ?? 00 00 50 E3 F3 FF FF DA 00 30 96 E5 02 00 53 E3 05 30 A0 E3 00 30 8D E5 7C 30 9F E5 00 20 A0 E3 04 30 8D E5 00 30 A0 E3 20 A0 8D E5 08 40 8D E5 0C 50 8D E5 18 20 8D E5 1C 30 8D E5 10 40 8D E5 14 50 8D E5 09 00 00 0A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 05 00 00 0A 20 30 9D E5 00 00 53 E3 06 00 00 1A 18 80 8D E2 80 01 98 E8 D9 FF FF EA ?? ?? ?? ?? 22 30 A0 E3 00 30 80 E5 F5 FF FF EA ?? ?? ?? ?? 20 30 9D E5 00 30 80 E5 F4 FF FF EA FB 21 49 43 18 2D 44 54 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_22_0_1 {
	meta:
		name = "atanh"
		size = 360
		refs = "0010 __ieee754_atanh 0034 __isnand 0058 fabs 006c __gedf2 0088 __gtdf2 00c8 __divdf3 00e4 matherr 0140 __errno 0160 __fdlib_version"
	strings:
		$1 = { F0 45 2D E9 2C D0 4D E2 00 40 A0 E1 01 50 A0 E1 ?? ?? ?? ?? 44 61 9F E5 00 30 96 E5 01 00 73 E3 00 70 A0 E1 01 80 A0 E1 04 00 00 0A 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 A0 50 E2 03 00 00 0A 07 00 A0 E1 08 10 A0 E1 2C D0 8D E2 F0 85 BD E8 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? FF 25 A0 E3 03 26 82 E2 00 30 A0 E3 03 00 8D E8 ?? ?? ?? ?? 00 00 50 E3 F1 FF FF BA FF 25 A0 E3 03 00 9D E8 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 1C 00 00 DA 01 C0 A0 E3 08 C0 8D E5 C0 C0 9F E5 10 40 8D E5 14 50 8D E5 18 40 8D E5 1C 50 8D E5 00 00 A0 E3 00 10 A0 E3 0C C0 8D E5 28 A0 8D E5 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 00 30 96 E5 02 00 53 E3 20 00 8D E5 24 10 8D E5 17 00 00 0A 08 00 8D E2 ?? ?? ?? ?? 00 00 50 E3 13 00 00 0A 28 30 9D E5 00 00 53 E3 14 00 00 1A 20 80 8D E2 80 01 98 E8 CD FF FF EA 02 C0 A0 E3 08 C0 8D E5 4C C0 9F E5 04 00 A0 E1 05 10 A0 E1 00 20 A0 E3 00 30 A0 E3 0C C0 8D E5 28 A0 8D E5 18 40 8D E5 1C 50 8D E5 10 40 8D E5 14 50 8D E5 E1 FF FF EA ?? ?? ?? ?? 21 30 A0 E3 00 30 80 E5 E7 FF FF EA ?? ?? ?? ?? 28 30 9D E5 00 30 80 E5 E6 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_24_0_1 {
	meta:
		name = "ceilf"
		size = 200
		refs = "0040 __addsf3 0048 __gtsf2"
	strings:
		$1 = { 70 40 2D E9 02 51 C0 E3 A5 4B A0 E1 7F 40 44 E2 16 00 54 E3 00 10 A0 E1 00 60 A0 E1 13 00 00 CA 00 00 54 E3 19 00 00 BA 02 55 A0 E3 01 50 45 E2 55 54 A0 E1 00 00 15 E1 0A 00 00 0A 80 10 9F E5 ?? ?? ?? ?? 00 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 03 00 00 DA 00 00 56 E3 02 35 A0 C3 53 64 86 C0 05 60 C6 E1 06 10 A0 E1 01 00 A0 E1 70 80 BD E8 02 31 E0 E3 02 35 43 E2 03 00 55 E1 F9 FF FF 9A ?? ?? ?? ?? 00 10 A0 E1 01 00 A0 E1 70 80 BD E8 2C 10 9F E5 ?? ?? ?? ?? 00 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 EE FF FF DA 00 00 56 E3 02 61 A0 B3 EB FF FF BA 00 00 55 E3 FE 65 A0 13 06 10 A0 E1 E8 FF FF EA CA F2 49 71 }
	condition:
		$1
}

rule file_25_0_1 {
	meta:
		name = "fmaf"
		size = 24
		refs = "0008 __mulsf3 0010 __addsf3"
	strings:
		$1 = { 10 40 2D E9 02 40 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 10 80 BD E8 }
	condition:
		$1
}

rule file_26_0_1 {
	meta:
		name = "__ieee754_acoshf"
		size = 276
		refs = "0034 __addsf3 0054 __subsf3 0070 __mulsf3 0080 __ieee754_sqrtf 0090 log1pf 00a0 __divsf3 00fc __ieee754_logf"
	strings:
		$1 = { FE 05 50 E3 70 40 2D E9 00 40 A0 E1 20 00 00 BA B2 24 E0 E3 02 25 42 E2 02 00 50 E1 06 00 00 DA 02 21 E0 E3 02 25 42 E2 02 00 50 E1 33 00 00 DA 00 10 A0 E1 ?? ?? ?? ?? 70 80 BD E8 FE 05 50 E3 00 00 A0 03 70 80 BD 08 01 01 54 E3 15 00 00 CA FE 15 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 00 40 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 00 50 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 70 40 BD E8 ?? ?? ?? ?? 00 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 ?? ?? ?? ?? 70 80 BD E8 04 10 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? ?? ?? ?? ?? 04 10 A0 E1 00 60 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 00 50 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 BF 04 A0 E3 02 05 80 E2 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 70 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? 04 10 9F E5 ?? ?? ?? ?? 70 80 BD E8 18 72 31 3F }
	condition:
		$1
}

rule file_27_0_1 {
	meta:
		name = "lrint"
		size = 320
		refs = "0058 __adddf3 006c __subdf3 0134 __fixdfsi"
	strings:
		$1 = { 02 31 C0 E3 23 3A A0 E1 70 48 2D E9 03 3A A0 E1 43 3A A0 E1 FF 3F 43 E2 03 30 43 E2 13 00 53 E3 08 D0 4D E2 00 B0 A0 E1 01 50 A0 E1 A0 4F A0 E1 1E 00 00 CA 01 00 73 E3 3B 00 00 BA F8 30 9F E5 84 31 83 E0 60 00 93 E8 00 20 A0 E1 01 30 A0 E1 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 03 00 8D E8 06 30 A0 E1 05 20 A0 E1 03 00 9D E8 ?? ?? ?? ?? 02 31 C0 E3 00 00 53 E3 2B 00 00 0A 23 3A A0 E1 03 3A A0 E1 43 3A A0 E1 FF 04 C0 E3 0F 06 C0 E3 41 3E 63 E2 01 06 80 E3 03 30 83 E2 50 03 A0 E1 00 00 54 E3 00 00 60 12 08 D0 8D E2 70 88 BD E8 1E 00 53 E3 1E 00 00 CA 7C 30 9F E5 84 31 83 E0 60 00 93 E8 00 20 A0 E1 01 30 A0 E1 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 03 00 8D E8 05 20 A0 E1 06 30 A0 E1 03 00 9D E8 ?? ?? ?? ?? 02 31 C0 E3 23 3A A0 E1 03 3A A0 E1 43 3A A0 E1 FF 3F 43 E2 03 30 43 E2 01 60 A0 E1 34 10 63 E2 36 11 A0 E1 00 50 A0 E1 FF 24 C5 E3 0F 26 C2 E3 01 06 82 E3 14 30 43 E2 10 03 81 E1 DC FF FF EA 00 00 A0 E3 DC FF FF EA ?? ?? ?? ?? DA FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_28_0_1 {
	meta:
		name = "hypot"
		size = 296
		refs = "0018 __ieee754_hypot 0034 finite 00c4 __errno 0100 matherr 0120 __fdlib_version"
	strings:
		$1 = { F0 4F 2D E9 24 D0 4D E2 03 80 A0 E1 00 50 A0 E1 01 60 A0 E1 02 70 A0 E1 ?? ?? ?? ?? FC 40 9F E5 00 30 94 E5 01 00 73 E3 00 A0 A0 E1 01 B0 A0 E1 02 00 00 0A ?? ?? ?? ?? 00 90 50 E2 03 00 00 0A 0A 00 A0 E1 0B 10 A0 E1 24 D0 8D E2 F0 8F BD E8 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 F6 FF FF 0A 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 F1 FF FF 0A 03 20 A0 E3 00 30 94 E5 00 20 8D E5 98 20 9F E5 00 00 53 E3 04 20 8D E5 20 90 8D E5 08 50 8D E5 0C 60 8D E5 10 70 8D E5 14 80 8D E5 0F 00 00 0A 02 00 53 E3 7F 34 A0 E3 0F 36 83 E2 00 40 A0 E3 18 30 8D E5 1C 40 8D E5 0D 00 00 1A ?? ?? ?? ?? 22 30 A0 E3 00 30 80 E5 20 30 9D E5 00 00 53 E3 0C 00 00 1A 18 B0 8D E2 00 0C 9B E8 D5 FF FF EA 2E 33 E0 E3 01 36 43 E2 0E 42 A0 E3 18 30 8D E5 1C 40 8D E5 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 F0 FF FF 1A EC FF FF EA ?? ?? ?? ?? 20 30 9D E5 00 30 80 E5 EE FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_29_0_1 {
	meta:
		name = "__ieee754_fmod"
		size = 896
		refs = "025c __muldf3 0268 __divdf3"
	strings:
		$1 = { F0 4B 2D E9 03 C0 A0 E1 03 50 A0 E1 02 31 C2 E3 02 40 A0 E1 02 B0 A0 E1 0C 20 93 E1 02 21 E0 E3 00 60 A0 13 01 60 A0 03 02 70 00 E0 01 26 42 E2 02 00 57 E1 06 20 A0 D1 01 20 86 C3 00 00 52 E3 00 80 A0 E1 01 90 A0 E1 01 20 A0 E1 02 61 00 E2 7F 00 00 1A 00 B0 6C E2 0C B0 8B E1 7F 84 A0 E3 AB BF 83 E1 0F 86 88 E2 08 00 5B E1 78 00 00 8A 03 00 57 E1 07 00 00 CA 00 40 A0 A3 01 40 A0 B3 0C 00 51 E1 01 40 84 33 00 00 54 E3 F0 8B BD 18 0C 00 51 E1 B3 00 00 0A 01 06 57 E3 47 BA A0 A1 FF BF 4B A2 03 B0 4B A2 0C 00 00 AA 00 00 57 E3 8B 00 00 1A 00 00 52 E3 41 BE E0 D3 02 10 A0 E1 02 B0 4B D2 05 00 00 DA 41 BE E0 E3 02 B0 4B E2 81 10 A0 E1 00 00 51 E3 01 B0 4B E2 FB FF FF CA 01 06 53 E3 43 5A A0 A1 FF 5F 45 A2 03 50 45 A2 0C 00 00 AA 00 00 53 E3 6D 00 00 1A 00 00 5C E3 41 5E E0 D3 0C 10 A0 E1 02 50 45 D2 05 00 00 DA 41 5E E0 E3 02 50 45 E2 81 10 A0 E1 00 00 51 E3 01 50 45 E2 FB FF FF CA FF 1F E0 E3 01 10 41 E2 01 00 5B E1 FF 04 C7 A3 0F 06 C0 A3 01 06 80 A3 0A 00 00 AA BF 13 6B E2 FF 17 81 E2 FF 1B 81 E2 1F 00 51 E3 17 71 A0 D1 20 00 61 D2 32 00 87 D1 12 21 A0 D1 20 10 41 C2 12 01 A0 C1 00 20 A0 C3 FF 1F E0 E3 01 10 41 E2 01 00 55 E1 FF 34 C3 A3 0F 36 C3 A3 01 36 83 A3 38 00 00 BA 0B B0 65 E0 00 00 5B E3 02 40 6C E0 10 00 00 0A 00 10 63 E0 0C 00 52 E1 01 10 41 32 00 00 51 E3 A2 1F A0 B1 80 00 81 B0 82 20 A0 B1 04 00 00 BA 04 20 91 E1 36 00 00 0A A4 0F A0 E1 81 00 80 E0 84 20 A0 E1 01 B0 4B E2 00 00 5B E3 02 40 6C E0 EE FF FF 1A 00 30 63 E0 02 00 5C E1 01 30 43 82 00 00 53 E3 02 20 6C A0 03 00 A0 A1 02 30 90 E1 27 00 00 0A 01 16 A0 E3 01 10 41 E2 01 00 50 E1 05 00 00 CA A2 3F A0 E1 80 00 83 E0 01 00 50 E1 82 20 A0 E1 01 50 45 E2 F9 FF FF DA FF 3F E0 E3 01 30 43 E2 03 00 55 E1 36 00 00 BA 01 06 40 E2 FF 5F 85 E2 06 60 80 E1 03 50 85 E2 05 0A 86 E1 02 10 A0 E1 F0 8B BD E8 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? F0 8B BD E8 BF 13 65 E2 FF 17 81 E2 FF 1B 81 E2 1F 00 51 E3 13 31 A0 D1 20 40 61 D2 20 30 41 C2 3C 34 83 D1 1C 33 A0 C1 1C C1 A0 D1 00 C0 A0 C3 BA FF FF EA D4 30 9F E5 A6 6F A0 E1 86 61 83 E0 03 00 96 E8 F0 8B BD E8 83 15 A0 E1 00 00 51 E3 FF 5F E0 D3 01 50 45 D2 97 FF FF DA FF 5F E0 E3 01 50 45 E2 81 10 A0 E1 00 00 51 E3 01 50 45 E2 FB FF FF CA 90 FF FF EA 87 15 A0 E1 00 00 51 E3 FF BF E0 D3 01 B0 4B D2 79 FF FF DA FF BF E0 E3 01 B0 4B E2 81 10 A0 E1 00 00 51 E3 01 B0 4B E2 FB FF FF CA 72 FF FF EA BF 53 65 E2 FF 57 85 E2 FF 5B 85 E2 14 00 55 E3 0A 00 00 DA 1F 00 55 E3 20 30 65 D2 10 03 A0 D1 20 50 45 C2 32 55 80 D1 50 55 A0 C1 06 30 A0 D1 06 30 A0 C1 06 00 83 E1 05 10 A0 E1 F0 8B BD E8 20 10 65 E2 10 11 A0 E1 50 35 A0 E1 32 55 81 E1 F7 FF FF EA 0C 30 9F E5 A6 6F A0 E1 86 31 83 E0 03 00 93 E8 F0 8B BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_0_1 {
	meta:
		name = "__ieee754_remainderf"
		size = 364
		refs = "0060 fabsf 0084 __addsf3 0090 __ltsf2 00a4 __subsf3 00bc __lesf2 00ec __mulsf3 00f4 __divsf3 0110 __gtsf2 0130 __gesf2 0160 __ieee754_fmodf"
	strings:
		$1 = { F0 41 2D E9 02 31 E0 E3 02 61 D1 E3 00 20 A0 13 01 20 A0 03 02 35 43 E2 02 71 C0 E3 03 00 57 E1 02 30 A0 D1 01 30 82 C3 00 00 53 E3 01 50 A0 E1 00 40 A0 E1 00 80 A0 E1 29 00 00 1A 7F 34 A0 E3 02 35 83 E2 03 00 56 E1 25 00 00 CA 7F 04 56 E3 3E 00 00 BA 06 00 57 E1 38 00 00 0A 04 00 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 01 04 56 E3 00 50 A0 E1 1F 00 00 AA 04 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 0E 00 00 AA 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 00 40 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 03 00 00 CA 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 02 81 08 E2 04 00 28 E0 F0 81 BD E8 05 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 ?? ?? ?? ?? F0 81 BD E8 3F 14 A0 E3 ?? ?? ?? ?? 00 60 A0 E1 06 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 EE FF FF DA 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 06 10 A0 E1 00 40 A0 E1 ?? ?? ?? ?? 00 00 50 E3 E6 FF FF BA E1 FF FF EA 04 00 A0 E1 00 10 A0 E3 ?? ?? ?? ?? F0 81 BD E8 01 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 B9 FF FF EA }
	condition:
		$1
}

rule file_31_0_1 {
	meta:
		name = "pzero"
		size = 452
		refs = "0054 __muldf3 006c __divdf3 008c __adddf3"
		altNames = "pone"
	strings:
		$1 = { BF 34 E0 E3 02 21 C0 E3 0E 36 43 E2 03 00 52 E1 F0 41 2D E9 63 00 00 CA 12 38 A0 E3 BA 3D 83 E2 29 31 83 E2 03 00 52 E1 5B 00 00 CA 6D 3A A0 E3 B6 3E 83 E2 31 31 83 E2 03 00 52 E1 70 61 9F D5 70 61 9F C5 28 70 86 D2 28 70 86 C2 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 FF 05 A0 E3 01 30 A0 E1 03 06 80 E2 00 10 A0 E3 ?? ?? ?? ?? 28 30 87 E2 0C 00 93 E8 00 40 A0 E1 01 50 A0 E1 ?? ?? ?? ?? 20 30 87 E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 18 30 87 E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 10 30 87 E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 08 30 87 E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 0C 00 97 E8 ?? ?? ?? ?? 20 30 86 E2 0C 00 93 E8 00 70 A0 E1 01 80 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 18 30 86 E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 10 30 86 E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 08 30 86 E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 0C 00 96 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? FF 25 A0 E3 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? FF 25 A0 E3 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? F0 81 BD E8 18 60 9F E5 28 70 86 E2 A8 FF FF EA 10 60 9F E5 28 70 86 E2 A5 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_31_1_1 {
	meta:
		name = "qzero"
		size = 500
		refs = "0064 __muldf3 007c __divdf3 009c __adddf3 01b8 __subdf3"
	strings:
		$1 = { BF 34 E0 E3 02 21 C0 E3 0E 36 43 E2 03 00 52 E1 F0 4F 2D E9 00 80 A0 E1 01 90 A0 E1 6D 00 00 CA 12 38 A0 E3 BA 3D 83 E2 29 31 83 E2 03 00 52 E1 65 00 00 CA 6D 3A A0 E3 B6 3E 83 E2 31 31 83 E2 03 00 52 E1 98 61 9F D5 98 61 9F C5 30 70 86 D2 30 70 86 C2 08 20 A0 E1 09 30 A0 E1 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 FF 05 A0 E3 01 30 A0 E1 03 06 80 E2 00 10 A0 E3 ?? ?? ?? ?? 28 30 87 E2 0C 00 93 E8 00 40 A0 E1 01 50 A0 E1 ?? ?? ?? ?? 20 30 87 E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 18 30 87 E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 10 30 87 E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 08 30 87 E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 0C 00 97 E8 ?? ?? ?? ?? 28 30 86 E2 0C 00 93 E8 00 A0 A0 E1 01 B0 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 20 30 86 E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 18 30 86 E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 10 30 86 E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 08 30 86 E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 0C 00 96 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? FF 25 A0 E3 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? FF 25 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? F0 8F BD E8 18 60 9F E5 30 70 86 E2 9E FF FF EA 10 60 9F E5 30 70 86 E2 9B FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_31_2_1 {
	meta:
		name = "__ieee754_j0"
		size = 1188
		refs = "0034 __muldf3 004c __divdf3 0058 fabs 0084 __adddf3 0094 __gtdf2 0128 __subdf3 02c0 sin 02d4 cos 0310 __ieee754_sqrt 0378 __ltdf2"
	strings:
		$1 = { F0 4F 2D E9 02 31 E0 E3 03 40 00 E0 01 36 43 E2 03 00 54 E1 18 D0 4D E2 00 50 A0 E1 01 60 A0 E1 00 70 A0 E1 01 80 A0 E1 0A 00 00 DA 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 FF 05 A0 E3 01 30 A0 E1 03 06 80 E2 00 10 A0 E3 ?? ?? ?? ?? 18 D0 8D E2 F0 8F BD E8 ?? ?? ?? ?? 07 01 74 E3 00 70 A0 E1 01 80 A0 E1 94 00 00 CA 03 31 E0 E3 0E 36 43 E2 03 00 54 E1 18 00 00 CA EF 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? FF 25 A0 E3 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 0F 00 00 DA F9 05 54 E3 FF 05 A0 B3 03 06 80 B2 00 10 A0 B3 E6 FF FF BA BF 24 A0 E3 0D 26 82 E2 00 30 A0 E3 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 07 00 A0 E1 08 10 A0 E1 71 00 00 EA 07 20 A0 E1 08 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? D3 3F 8F E2 0C 00 93 E8 00 50 A0 E1 01 60 A0 E1 ?? ?? ?? ?? 0D 3D 8F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 33 3E 8F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 03 21 E0 E3 07 26 42 E2 02 30 E0 E3 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? C1 3F 8F E2 0C 00 93 E8 00 A0 A0 E1 01 B0 A0 E1 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 2F 3E 8F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 2E 3E 8F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 2D 3E 8F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? FF 25 A0 E3 00 30 A0 E3 03 26 82 E2 ?? ?? ?? ?? 03 31 E0 E3 01 36 43 E2 03 00 54 E1 03 00 8D E8 27 00 00 DA FF 25 A0 E3 07 00 A0 E1 08 10 A0 E1 02 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 0C 00 9D E8 08 00 8D E5 0C 10 8D E5 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? FF 25 A0 E3 00 40 A0 E1 01 50 A0 E1 03 26 82 E2 08 10 8D E2 03 00 91 E8 00 30 A0 E3 ?? ?? ?? ?? 00 70 A0 E1 FF 05 A0 E3 08 30 8D E2 0C 00 93 E8 01 80 A0 E1 03 06 80 E2 00 10 A0 E3 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 74 FF FF EA 00 20 A0 E1 01 30 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? FF 25 A0 E3 01 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? FF 25 A0 E3 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 63 FF FF EA ?? ?? ?? ?? 00 A0 A0 E1 01 B0 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 50 A0 E1 01 60 A0 E1 06 30 A0 E1 0A 00 A0 E1 0B 10 A0 E1 05 20 A0 E1 ?? ?? ?? ?? 02 31 E0 E3 02 36 43 E2 03 00 54 E1 03 00 8D E8 0C 00 00 DA 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 03 00 9D E8 56 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 44 FF FF EA 07 20 A0 E1 08 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 05 20 A0 E1 08 10 8D E5 06 30 A0 E1 02 91 80 E2 0B 10 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 40 00 00 AA 05 20 A0 E1 06 30 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 10 00 8D E5 14 10 8D E5 10 30 8D E2 0C 00 93 E8 09 00 A0 E1 08 10 9D E5 ?? ?? ?? ?? 03 00 8D E8 12 03 54 E3 D1 FF FF CA 07 00 A0 E1 08 10 A0 E1 1E FE FF EB 00 A0 A0 E1 01 B0 A0 E1 07 00 A0 E1 08 10 A0 E1 8A FE FF EB 08 00 8D E5 0C 10 8D E5 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 00 40 A0 E1 01 50 A0 E1 03 00 9D E8 ?? ?? ?? ?? 08 30 8D E2 0C 00 93 E8 00 70 A0 E1 01 80 A0 E1 10 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? B7 FF FF EA 3C E4 37 7E 9C 75 00 88 E7 D5 33 BE CE 3F D6 73 D1 B1 BE 3E 19 39 50 0C A5 E6 28 3F E9 C6 1A B6 BC 08 14 3E 8F 5D 74 F4 54 3B A1 3E A9 D5 84 CE D2 A6 1E 3F F4 DB 57 DD E8 FC 8F 3F A4 C2 C8 82 D7 0D E2 3F 6D 9B 42 50 09 00 A0 E1 08 10 9D E5 0C 00 9D E8 ?? ?? ?? ?? 10 00 8D E5 14 10 8D E5 C4 FF FF EA }
	condition:
		$1
}

rule file_31_3_1 {
	meta:
		name = "__ieee754_y0"
		size = 1132
		refs = "0058 __muldf3 0078 __adddf3 0090 __subdf3 0178 __divdf3 018c __ieee754_j0 01a0 __ieee754_log 0250 sin 0264 cos 02a0 __ieee754_sqrt 0320 __ltdf2"
	strings:
		$1 = { F0 4F 2D E9 02 31 E0 E3 01 36 43 E2 02 61 C0 E3 03 00 56 E1 0C D0 4D E2 00 40 A0 E1 01 50 A0 E1 00 70 A0 E1 01 80 A0 E1 01 30 A0 E1 72 00 00 CA 03 30 96 E1 68 00 00 0A 00 00 50 E3 A2 00 00 BA 07 01 76 E3 81 00 00 CA F9 05 56 E3 77 00 00 DA 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 3A 3E 8F E2 0C 00 93 E8 00 60 A0 E1 01 70 A0 E1 ?? ?? ?? ?? E5 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? E1 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? DD 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? D9 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? D5 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? D1 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 0D 3D 8F E2 0C 00 93 E8 00 80 A0 E1 01 90 A0 E1 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? CB 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? C7 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? C3 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? FF 25 A0 E3 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 00 60 A0 E1 01 70 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 80 A0 E1 01 90 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? A7 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 05 00 00 EA BF 04 A0 E3 0F 06 80 E2 00 10 A0 E3 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 0C D0 8D E2 F0 8F BD E8 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 FF 05 A0 E3 01 30 A0 E1 03 06 80 E2 00 10 A0 E3 ?? ?? ?? ?? F0 FF FF EA ?? ?? ?? ?? 22 3E 8F E2 0C 00 93 E8 ?? ?? ?? ?? 7B 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? E8 FF FF EA ?? ?? ?? ?? 00 A0 A0 E1 01 B0 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 80 A0 E1 01 90 A0 E1 09 30 A0 E1 0A 00 A0 E1 0B 10 A0 E1 08 20 A0 E1 ?? ?? ?? ?? 02 31 E0 E3 02 36 43 E2 03 00 56 E1 03 00 8D E8 12 00 00 DA 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 03 00 9D E8 6B 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? C9 FF FF EA 00 00 A0 E3 00 10 A0 E3 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? C3 FF FF EA 04 20 A0 E1 05 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 08 20 A0 E1 08 10 8D E5 09 30 A0 E1 02 71 80 E2 0B 10 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 27 00 00 AA 07 00 A0 E1 08 10 9D E5 0C 00 9D E8 ?? ?? ?? ?? 00 A0 A0 E1 01 B0 A0 E1 12 03 56 E3 D2 FF FF CA 04 00 A0 E1 05 10 A0 E1 12 FD FF EB 00 60 A0 E1 01 70 A0 E1 04 00 A0 E1 05 10 A0 E1 7E FD FF EB 00 80 A0 E1 01 90 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 00 40 A0 E1 01 50 A0 E1 03 00 9D E8 ?? ?? ?? ?? 08 20 A0 E1 00 60 A0 E1 01 70 A0 E1 09 30 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? B8 FF FF EA 08 20 A0 E1 09 30 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 00 A0 A0 E1 01 B0 A0 E1 07 00 A0 E1 08 10 9D E5 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? 03 00 8D E8 CF FF FF EA 3D E4 C5 BD C8 B3 3F 69 57 00 55 3E D4 AB 4E 3B A7 FE CF 3E AD 5C D2 73 4D C5 36 3F 6B 9B B2 20 E8 4C 8C 3F 97 FA 6C B1 01 9D C6 3F FC E3 E9 9D D6 E4 B2 3F 1F D0 CB 99 18 50 FE 3D EF D9 D6 3B 2D 64 91 3E FD 02 F2 7F BB EC 13 3F C1 C6 78 F5 70 12 8A 3F 1A C7 C9 91 30 5F E4 3F 83 C8 C9 6D D7 0D E2 3F 6D 9B 42 50 }
	condition:
		$1
}

rule file_32_0_1 {
	meta:
		name = "fabs"
		size = 24
		altNames = "fabsl"
	strings:
		$1 = { 02 31 C0 E3 04 40 2D E5 03 00 A0 E1 01 40 A0 E1 10 00 BD E8 1E FF 2F E1 }
	condition:
		$1
}

rule file_33_0_1 {
	meta:
		name = "remquo"
		size = 88
		refs = "0024 __divdf3 002c fabs 0030 lrint 0054 remainder"
	strings:
		$1 = { A2 CF A0 E1 F0 43 2D E9 A0 0F 5C E1 02 80 A0 E1 03 90 A0 E1 00 60 E0 13 01 60 A0 03 00 40 A0 E1 01 50 A0 E1 ?? ?? ?? ?? 1C 70 9D E5 ?? ?? ?? ?? ?? ?? ?? ?? 7F 00 00 E2 90 06 06 E0 05 10 A0 E1 04 00 A0 E1 08 20 A0 E1 09 30 A0 E1 00 60 87 E5 F0 43 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_0_1 {
	meta:
		name = "pow10"
		size = 24
		refs = "0014 pow"
		altNames = "exp10"
	strings:
		$1 = { 00 20 A0 E1 01 01 A0 E3 01 30 A0 E1 09 07 80 E2 00 10 A0 E3 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_0_1 {
	meta:
		name = "log10"
		size = 408
		refs = "0010 __ieee754_log10 0034 __isnand 0050 __ledf2 00a8 __eqdf2 00c8 matherr 014c nan 015c __errno 018c __fdlib_version"
	strings:
		$1 = { F0 45 2D E9 24 D0 4D E2 00 40 A0 E1 01 50 A0 E1 ?? ?? ?? ?? 70 61 9F E5 00 30 96 E5 01 00 73 E3 00 70 A0 E1 01 80 A0 E1 2E 00 00 0A 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 A0 50 E2 29 00 00 1A 04 00 A0 E1 05 10 A0 E1 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 22 00 00 CA 00 60 96 E5 28 31 9F E5 00 00 56 E3 04 30 8D E5 20 A0 8D E5 08 40 8D E5 0C 50 8D E5 10 40 8D E5 14 50 8D E5 1C 00 00 0A 02 21 A0 E3 C2 25 A0 E1 00 30 A0 E3 18 20 8D E5 1C 30 8D E5 04 00 A0 E1 05 10 A0 E1 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 1C 00 00 1A 02 30 A0 E3 02 00 56 E3 00 30 8D E5 29 00 00 0A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 25 00 00 0A 20 30 9D E5 00 00 53 E3 1E 00 00 1A 18 80 8D E2 80 01 98 E8 07 00 A0 E1 08 10 A0 E1 24 D0 8D E2 F0 85 BD E8 0E 23 E0 E3 01 26 42 E2 0E 32 A0 E3 18 20 8D E5 1C 30 8D E5 04 00 A0 E1 05 10 A0 E1 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 E2 FF FF 0A 01 30 A0 E3 02 00 56 E3 00 30 8D E5 10 00 00 0A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 0C 00 00 0A 44 00 9F E5 ?? ?? ?? ?? 18 00 8D E5 1C 10 8D E5 DD FF FF EA ?? ?? ?? ?? 20 30 9D E5 00 30 80 E5 DC FF FF EA ?? ?? ?? ?? 22 30 A0 E3 00 30 80 E5 D5 FF FF EA ?? ?? ?? ?? 21 30 A0 E3 00 30 80 E5 EE FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_81_0_1 {
	meta:
		name = "log"
		size = 408
		refs = "0010 __ieee754_log 0034 __isnand 0050 __gtdf2 00a8 __eqdf2 00c8 matherr 014c nan 015c __errno 018c __fdlib_version"
	strings:
		$1 = { F0 45 2D E9 24 D0 4D E2 00 40 A0 E1 01 50 A0 E1 ?? ?? ?? ?? 70 61 9F E5 00 30 96 E5 01 00 73 E3 00 70 A0 E1 01 80 A0 E1 2E 00 00 0A 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 A0 50 E2 29 00 00 1A 04 00 A0 E1 05 10 A0 E1 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 22 00 00 CA 00 60 96 E5 28 31 9F E5 00 00 56 E3 04 30 8D E5 20 A0 8D E5 08 40 8D E5 0C 50 8D E5 10 40 8D E5 14 50 8D E5 1C 00 00 0A 02 21 A0 E3 C2 25 A0 E1 00 30 A0 E3 18 20 8D E5 1C 30 8D E5 04 00 A0 E1 05 10 A0 E1 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 1C 00 00 1A 02 30 A0 E3 02 00 56 E3 00 30 8D E5 29 00 00 0A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 25 00 00 0A 20 30 9D E5 00 00 53 E3 1E 00 00 1A 18 80 8D E2 80 01 98 E8 07 00 A0 E1 08 10 A0 E1 24 D0 8D E2 F0 85 BD E8 0E 23 E0 E3 01 26 42 E2 0E 32 A0 E3 18 20 8D E5 1C 30 8D E5 04 00 A0 E1 05 10 A0 E1 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 E2 FF FF 0A 01 30 A0 E3 02 00 56 E3 00 30 8D E5 10 00 00 0A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 0C 00 00 0A 44 00 9F E5 ?? ?? ?? ?? 18 00 8D E5 1C 10 8D E5 DD FF FF EA ?? ?? ?? ?? 20 30 9D E5 00 30 80 E5 DC FF FF EA ?? ?? ?? ?? 22 30 A0 E3 00 30 80 E5 D5 FF FF EA ?? ?? ?? ?? 21 30 A0 E3 00 30 80 E5 EE FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_37_0_1 {
	meta:
		name = "ynf"
		size = 420
		refs = "0010 __ieee754_ynf 002c isnanf 0040 __lesf2 0054 __gtsf2 0078 __floatsidf 0088 __extendsfdf2 00b4 matherr 00cc __errno 00e0 __truncdfsf2 0198 __fdlib_version"
	strings:
		$1 = { F0 41 2D E9 24 D0 4D E2 00 70 A0 E1 01 40 A0 E1 ?? ?? ?? ?? 7C 61 9F E5 00 30 96 E5 01 00 73 E3 00 50 A0 E1 2F 00 00 0A 04 00 A0 E1 ?? ?? ?? ?? 00 80 50 E2 2B 00 00 1A 04 00 A0 E1 00 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 29 00 00 DA 04 00 A0 E1 44 11 9F E5 ?? ?? ?? ?? 00 00 50 E3 21 00 00 DA 05 30 A0 E3 00 30 8D E5 30 31 9F E5 07 00 A0 E1 04 30 8D E5 20 80 8D E5 ?? ?? ?? ?? 08 00 8D E5 0C 10 8D E5 04 00 A0 E1 ?? ?? ?? ?? 00 30 96 E5 00 40 A0 E3 02 00 53 E3 00 30 A0 E3 18 30 8D E5 1C 40 8D E5 10 00 8D E5 14 10 8D E5 35 00 00 0A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 31 00 00 0A 20 30 9D E5 00 00 53 E3 02 00 00 0A ?? ?? ?? ?? 20 30 9D E5 00 30 80 E5 18 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 50 A0 E1 05 00 A0 E1 24 D0 8D E2 F0 81 BD E8 01 30 A0 E3 00 30 8D E5 9C 30 9F E5 07 00 A0 E1 04 30 8D E5 20 80 8D E5 ?? ?? ?? ?? 08 00 8D E5 0C 10 8D E5 04 00 A0 E1 ?? ?? ?? ?? 00 30 96 E5 00 00 53 E3 10 00 8D E5 14 10 8D E5 0C 00 00 1A 0E 33 E0 E3 01 36 43 E2 0E 42 A0 E3 18 30 8D E5 1C 40 8D E5 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 D9 FF FF 1A ?? ?? ?? ?? 21 30 A0 E3 00 30 80 E5 D5 FF FF EA 02 00 53 E3 02 31 A0 E3 C3 35 A0 E1 00 40 A0 E3 18 30 8D E5 1C 40 8D E5 F4 FF FF 0A EF FF FF EA ?? ?? ?? ?? 22 30 A0 E3 00 30 80 E5 C9 FF FF EA ?? ?? ?? ?? DB 0F 49 5A ?? ?? ?? ?? }
	condition:
		$1
}

rule file_37_1_1 {
	meta:
		name = "jnf"
		size = 264
		refs = "0010 __ieee754_jnf 002c isnanf 0048 fabsf 0050 __gtsf2 0074 __floatsidf 0084 __extendsfdf2 00b0 matherr 00d0 __truncdfsf2 00dc __errno 00fc __fdlib_version"
	strings:
		$1 = { F0 41 2D E9 24 D0 4D E2 00 70 A0 E1 01 60 A0 E1 ?? ?? ?? ?? E0 50 9F E5 00 30 95 E5 01 00 73 E3 00 40 A0 E1 03 00 00 0A 06 00 A0 E1 ?? ?? ?? ?? 00 80 50 E2 02 00 00 0A 04 00 A0 E1 24 D0 8D E2 F0 81 BD E8 06 00 A0 E1 ?? ?? ?? ?? AC 10 9F E5 ?? ?? ?? ?? 00 00 50 E3 F6 FF FF DA 05 30 A0 E3 00 30 8D E5 98 30 9F E5 07 00 A0 E1 04 30 8D E5 20 80 8D E5 ?? ?? ?? ?? 08 00 8D E5 0C 10 8D E5 06 00 A0 E1 ?? ?? ?? ?? 00 30 95 E5 00 40 A0 E3 02 00 53 E3 00 30 A0 E3 18 30 8D E5 1C 40 8D E5 10 00 8D E5 14 10 8D E5 0B 00 00 0A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 07 00 00 0A 20 30 9D E5 00 00 53 E3 08 00 00 1A 18 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 40 A0 E1 D6 FF FF EA ?? ?? ?? ?? 22 30 A0 E3 00 30 80 E5 F3 FF FF EA ?? ?? ?? ?? 20 30 9D E5 00 30 80 E5 F2 FF FF EA ?? ?? ?? ?? DB 0F 49 5A ?? ?? ?? ?? }
	condition:
		$1
}

rule file_38_0_1 {
	meta:
		name = "gammaf_r"
		size = 372
		refs = "000c __ieee754_gammaf_r 0024 finitef 005c __extendsfdf2 0094 floorf 009c __eqsf2 00b0 __lesf2 00d4 matherr 00f4 __truncdfsf2 0118 __errno 016c __fdlib_version"
	strings:
		$1 = { F0 40 2D E9 24 D0 4D E2 00 50 A0 E1 ?? ?? ?? ?? 54 41 9F E5 00 30 94 E5 01 00 73 E3 00 60 A0 E1 02 00 00 0A ?? ?? ?? ?? 00 70 50 E2 02 00 00 0A 06 00 A0 E1 24 D0 8D E2 F0 80 BD E8 05 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 F8 FF FF 0A 1C 31 9F E5 05 00 A0 E1 04 30 8D E5 20 70 8D E5 ?? ?? ?? ?? 00 30 94 E5 00 00 53 E3 08 00 8D E5 0C 10 8D E5 10 00 8D E5 14 10 8D E5 20 00 00 1A 2E 23 E0 E3 01 26 42 E2 0E 32 A0 E3 18 20 8D E5 1C 30 8D E5 05 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 04 00 00 1A 05 00 A0 E1 00 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 1A 00 00 DA 00 30 94 E5 02 00 53 E3 03 30 A0 E3 00 30 8D E5 11 00 00 0A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 0D 00 00 0A 20 30 9D E5 00 00 53 E3 1B 00 00 1A 18 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 60 A0 E1 CB FF FF EA 7F 24 A0 E3 0F 26 82 E2 00 30 A0 E3 18 20 8D E5 1C 30 8D E5 DD FF FF EA ?? ?? ?? ?? 22 30 A0 E3 00 30 80 E5 ED FF FF EA 00 30 94 E5 02 00 53 E3 02 30 A0 E3 00 30 8D E5 03 00 00 0A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 E4 FF FF 1A ?? ?? ?? ?? 21 30 A0 E3 00 30 80 E5 E0 FF FF EA ?? ?? ?? ?? 20 30 9D E5 00 30 80 E5 DF FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_116_0_1 {
	meta:
		name = "lgammaf_r"
		size = 372
		refs = "000c __ieee754_lgammaf_r 0024 finitef 005c __extendsfdf2 0094 floorf 009c __eqsf2 00b0 __lesf2 00d4 matherr 00f4 __truncdfsf2 0118 __errno 016c __fdlib_version"
	strings:
		$1 = { F0 40 2D E9 24 D0 4D E2 00 50 A0 E1 ?? ?? ?? ?? 54 41 9F E5 00 30 94 E5 01 00 73 E3 00 60 A0 E1 02 00 00 0A ?? ?? ?? ?? 00 70 50 E2 02 00 00 0A 06 00 A0 E1 24 D0 8D E2 F0 80 BD E8 05 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 F8 FF FF 0A 1C 31 9F E5 05 00 A0 E1 04 30 8D E5 20 70 8D E5 ?? ?? ?? ?? 00 30 94 E5 00 00 53 E3 08 00 8D E5 0C 10 8D E5 10 00 8D E5 14 10 8D E5 20 00 00 1A 2E 23 E0 E3 01 26 42 E2 0E 32 A0 E3 18 20 8D E5 1C 30 8D E5 05 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 04 00 00 1A 05 00 A0 E1 00 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 1A 00 00 DA 00 30 94 E5 02 00 53 E3 03 30 A0 E3 00 30 8D E5 11 00 00 0A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 0D 00 00 0A 20 30 9D E5 00 00 53 E3 1B 00 00 1A 18 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 60 A0 E1 CB FF FF EA 7F 24 A0 E3 0F 26 82 E2 00 30 A0 E3 18 20 8D E5 1C 30 8D E5 DD FF FF EA ?? ?? ?? ?? 22 30 A0 E3 00 30 80 E5 ED FF FF EA 00 30 94 E5 02 00 53 E3 02 30 A0 E3 00 30 8D E5 03 00 00 0A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 E4 FF FF 1A ?? ?? ?? ?? 21 30 A0 E3 00 30 80 E5 E0 FF FF EA ?? ?? ?? ?? 20 30 9D E5 00 30 80 E5 DF FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_39_0_1 {
	meta:
		name = "pow"
		size = 1344
		refs = "0018 __ieee754_pow 003c __isnand 0080 __eqdf2 0178 matherr 0190 __errno 01a8 finite 0280 __ltdf2 0440 __divdf3 04a8 __muldf3 04b4 rint 04c0 __nedf2 0538 __fdlib_version"
	strings:
		$1 = { F0 4F 2D E9 28 D0 4D E2 03 80 A0 E1 00 A0 A0 E1 01 B0 A0 E1 02 70 A0 E1 ?? ?? ?? ?? 14 65 9F E5 00 30 96 E5 01 00 73 E3 00 40 A0 E1 01 50 A0 E1 04 00 00 0A 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 90 50 E2 03 00 00 0A 04 00 A0 E1 05 10 A0 E1 28 D0 8D E2 F0 8F BD E8 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 00 00 8D E5 1B 00 00 0A 07 00 A0 E1 08 10 A0 E1 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 EE FF FF 1A 00 30 96 E5 01 20 A0 E3 01 00 73 E3 02 00 53 13 04 20 8D E5 FF 35 A0 E3 90 24 9F E5 03 36 83 E2 00 40 A0 E3 08 20 8D E5 24 90 8D E5 0C A0 8D E5 10 B0 8D E5 14 70 8D E5 18 80 8D E5 1C 30 8D E5 20 40 8D E5 27 00 00 1A 1C 50 8D E2 30 00 95 E8 D9 FF FF EA 0A 00 A0 E1 0B 10 A0 E1 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 28 00 00 1A 07 00 A0 E1 08 10 A0 E1 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 50 00 00 1A 00 30 96 E5 00 00 53 E3 01 30 A0 E3 04 30 8D E5 0C 34 9F E5 00 20 9D E5 08 30 8D E5 00 40 A0 E3 00 30 A0 E3 24 20 8D E5 0C A0 8D E5 10 B0 8D E5 14 70 8D E5 18 80 8D E5 1C 30 8D E5 20 40 8D E5 05 00 00 0A FF 35 A0 E3 03 36 83 E2 00 40 A0 E3 1C 30 8D E5 20 40 8D E5 D7 FF FF EA 04 00 8D E2 ?? ?? ?? ?? 00 00 50 E3 5A 00 00 0A 24 30 9D E5 00 00 53 E3 D0 FF FF 0A ?? ?? ?? ?? 24 30 9D E5 00 30 80 E5 CC FF FF EA 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 90 50 E2 52 00 00 0A 04 00 A0 E1 05 10 A0 E1 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 9D FF FF 1A 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 98 FF FF 0A 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 93 FF FF 0A 00 30 96 E5 02 00 53 E3 04 30 A0 E3 04 30 8D E5 2C 33 9F E5 08 30 8D E5 00 30 A0 E3 24 30 8D E5 00 20 A0 E3 00 30 A0 E3 0C A0 8D E5 10 B0 8D E5 14 70 8D E5 18 80 8D E5 1C 20 8D E5 20 30 8D E5 58 00 00 0A 04 00 8D E2 ?? ?? ?? ?? 00 00 50 E3 54 00 00 0A 24 30 9D E5 00 00 53 E3 9E FF FF 0A CC FF FF EA 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 75 FF FF 0A 07 00 A0 E1 08 10 A0 E1 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 6E FF FF AA 01 20 A0 E3 00 30 96 E5 04 20 8D E5 00 40 9D E5 98 22 9F E5 00 00 53 E3 08 20 8D E5 24 40 8D E5 0C A0 8D E5 10 B0 8D E5 14 70 8D E5 18 80 8D E5 2F 00 00 1A 00 20 A0 E3 00 30 A0 E3 1C 20 8D E5 20 30 8D E5 04 00 8D E2 ?? ?? ?? ?? 00 00 50 E3 DA FF FF 1A ?? ?? ?? ?? 21 30 A0 E3 00 30 80 E5 D6 FF FF EA ?? ?? ?? ?? 21 30 A0 E3 00 30 80 E5 A0 FF FF EA 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 A7 FF FF 0A 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 A2 FF FF 0A 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 1C 00 00 0A 01 30 A0 E3 00 40 96 E5 04 30 8D E5 EC 31 9F E5 00 00 54 E3 08 30 8D E5 24 90 8D E5 0C A0 8D E5 10 B0 8D E5 14 70 8D E5 18 80 8D E5 30 00 00 1A 00 30 A0 E3 00 40 A0 E3 1C 30 8D E5 20 40 8D E5 D3 FF FF EA 02 00 53 E3 02 31 A0 E3 C3 35 A0 E1 00 40 A0 E3 1C 30 8D E5 20 40 8D E5 D0 FF FF 0A CB FF FF EA ?? ?? ?? ?? 22 30 A0 E3 00 30 80 E5 A6 FF FF EA 03 30 A0 E3 00 40 96 E5 04 30 8D E5 78 31 9F E5 00 00 54 E3 08 30 8D E5 24 00 8D E5 0C A0 8D E5 10 B0 8D E5 14 70 8D E5 18 80 8D E5 1D 00 00 1A 2E 43 E0 E3 0A 00 A0 E1 0B 10 A0 E1 00 20 A0 E3 00 30 A0 E3 01 46 44 E2 0E 52 A0 E3 1C 40 8D E5 20 50 8D E5 ?? ?? ?? ?? 00 00 50 E3 20 00 00 BA 04 00 8D E2 ?? ?? ?? ?? 00 00 50 E3 58 FF FF 1A ?? ?? ?? ?? 22 30 A0 E3 00 30 80 E5 54 FF FF EA 00 00 A0 E3 00 10 A0 E3 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 02 00 54 E3 1C 00 8D E5 20 10 8D E5 A2 FF FF 0A 9D FF FF EA 0A 00 A0 E1 7F A4 A0 E3 0B 10 A0 E1 00 20 A0 E3 00 30 A0 E3 0F A6 8A E2 00 B0 A0 E3 1C A0 8D E5 20 B0 8D E5 ?? ?? ?? ?? 00 00 50 E3 17 00 00 BA 02 00 54 E3 DF FF FF 1A E2 FF FF EA FF 25 A0 E3 02 26 82 E2 00 30 A0 E3 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 18 00 00 0A 0E 33 E0 E3 0E 42 A0 E3 01 36 43 E2 1C 30 8D E5 20 40 8D E5 00 40 96 E5 E7 FF FF EA FF 25 A0 E3 02 26 82 E2 00 30 A0 E3 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 02 31 A0 13 C3 35 A0 11 00 40 A0 13 1C 30 8D 15 20 40 8D 15 00 40 96 E5 D3 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_42_0_1 {
	meta:
		name = "expf"
		size = 384
		refs = "000c __ieee754_expf 0028 finitef 003c __gtsf2 0058 __ltsf2 0080 __extendsfdf2 00b4 matherr 00cc __errno 00e0 __truncdfsf2 0174 __fdlib_version"
	strings:
		$1 = { 70 40 2D E9 24 D0 4D E2 00 40 A0 E1 ?? ?? ?? ?? 5C 61 9F E5 00 30 96 E5 01 00 73 E3 00 50 A0 E1 30 00 00 0A 04 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 2C 00 00 0A 04 00 A0 E1 38 11 9F E5 ?? ?? ?? ?? 00 00 50 E3 2A 00 00 CA 39 1D E0 E3 A3 12 41 E2 04 00 A0 E1 D3 16 41 E2 ?? ?? ?? ?? 00 00 50 E3 20 00 00 AA 04 30 A0 E3 00 30 8D E5 08 31 9F E5 04 00 A0 E1 04 30 8D E5 00 30 A0 E3 20 30 8D E5 ?? ?? ?? ?? 00 30 96 E5 00 40 A0 E3 02 00 53 E3 00 30 A0 E3 08 00 8D E5 0C 10 8D E5 18 30 8D E5 1C 40 8D E5 10 00 8D E5 14 10 8D E5 2C 00 00 0A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 28 00 00 0A 20 30 9D E5 00 00 53 E3 02 00 00 0A ?? ?? ?? ?? 20 30 9D E5 00 30 80 E5 18 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 50 A0 E1 05 00 A0 E1 24 D0 8D E2 70 80 BD E8 03 30 A0 E3 00 30 8D E5 78 30 9F E5 04 00 A0 E1 04 30 8D E5 00 30 A0 E3 20 30 8D E5 ?? ?? ?? ?? 00 30 96 E5 00 00 53 E3 08 00 8D E5 0C 10 8D E5 10 00 8D E5 14 10 8D E5 05 00 00 1A 2E 33 E0 E3 01 36 43 E2 0E 42 A0 E3 18 30 8D E5 1C 40 8D E5 D9 FF FF EA 02 00 53 E3 7F 34 A0 E3 0F 36 83 E2 00 40 A0 E3 18 30 8D E5 1C 40 8D E5 D2 FF FF 1A ?? ?? ?? ?? 22 30 A0 E3 00 30 80 E5 D2 FF FF EA ?? ?? ?? ?? 80 71 B1 42 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_43_0_1 {
	meta:
		name = "expm1f"
		size = 1088
		refs = "0060 __addsf3 0068 __ltsf2 0088 __mulsf3 0094 __fixsfsi 009c __floatsisf 00d8 __subsf3 01c4 __divsf3"
	strings:
		$1 = { 0C 24 9F E5 02 31 C0 E3 02 00 53 E1 F0 45 2D E9 00 40 A0 E1 02 51 00 E2 8B 00 00 9A 7F 24 A0 E3 02 25 82 E2 02 00 53 E1 97 00 00 8A B0 00 00 0A E0 23 9F E5 01 10 75 E2 00 10 A0 33 02 00 53 E1 00 10 A0 93 00 00 51 E3 94 00 00 1A 00 00 55 E3 BF 00 00 0A DA 16 A0 E3 09 19 81 E2 26 1E 81 E2 ?? ?? ?? ?? 00 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 A1 00 00 BA 00 00 55 E3 BF 54 A0 13 B4 00 00 0A 94 13 9F E5 04 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 00 60 A0 E1 ?? ?? ?? ?? BF 14 A0 E3 C5 19 81 E2 C6 1D 81 E2 00 50 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 5C 13 9F E5 00 70 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 50 A0 E1 05 10 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 04 10 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 00 A0 A0 E1 3F 14 A0 E3 04 00 A0 E1 ?? ?? ?? ?? 00 70 A0 E1 07 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 08 13 9F E5 00 50 A0 E1 ?? ?? ?? ?? 00 13 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? F4 12 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 0D 1C A0 E3 4E 13 81 E2 2D 16 81 E2 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? D0 12 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 07 10 A0 E1 00 80 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 01 01 A0 E3 01 05 80 E2 ?? ?? ?? ?? 00 70 A0 E1 07 10 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 07 10 A0 E1 00 80 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 01 01 A0 E3 03 05 80 E2 ?? ?? ?? ?? 00 10 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 00 00 56 E3 00 10 A0 E1 59 00 00 0A 0A 10 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 0A 10 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 01 00 76 E3 00 50 A0 E1 66 00 00 0A 01 00 56 E3 28 00 00 0A 01 30 86 E2 39 00 53 E3 57 00 00 8A 16 00 56 E3 68 00 00 CA 01 34 A0 E3 53 36 A0 E1 04 10 A0 E1 FE 45 63 E2 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 86 4B 80 E0 12 00 00 EA E0 21 9F E5 02 00 53 E1 2B 00 00 8A 33 04 53 E3 00 60 A0 23 A4 FF FF 2A CC 11 9F E5 ?? ?? ?? ?? 00 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 04 00 A0 E1 F0 85 BD E8 00 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 04 00 A0 E1 F0 85 BD E8 90 01 9F E5 00 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 F8 FF FF EA BE 14 A0 E3 04 00 A0 E1 02 15 81 E2 ?? ?? ?? ?? 00 00 50 E3 48 00 00 AA 04 00 A0 E1 3F 14 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 03 11 A0 E3 ?? ?? ?? ?? 00 40 A0 E1 E8 FF FF EA 00 00 55 E3 E6 FF FF 0A BF 44 A0 E3 02 45 84 E2 E3 FF FF EA D3 28 82 E2 A3 2C 82 E2 79 20 82 E2 02 00 53 E1 55 FF FF 8A 00 00 55 E3 0D 00 00 1A 3F 14 A0 E3 C5 19 81 E2 C6 1D 81 E2 ?? ?? ?? ?? 01 60 A0 E3 00 70 A0 E1 DC 50 9F E5 62 FF FF EA 04 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 C6 FF FF EA 3F 54 A0 E3 48 FF FF EA 3F 14 A0 E3 C5 19 81 E2 C6 1D 81 E2 ?? ?? ?? ?? 00 60 E0 E3 00 70 A0 E1 C0 50 9F E5 54 FF FF EA 04 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 FE 05 A0 E3 ?? ?? ?? ?? FE 15 A0 E3 86 0B 80 E0 ?? ?? ?? ?? 00 40 A0 E1 BC FF FF EA 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 3F 14 A0 E3 ?? ?? ?? ?? 3F 14 A0 E3 ?? ?? ?? ?? 00 40 A0 E1 B3 FF FF EA 7F 10 66 E2 81 1B A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 86 4B 80 E0 A9 FF FF EA 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 00 40 A0 E1 A0 FF FF EA 43 B8 95 41 17 72 B1 42 3B AA B8 3F D1 F7 17 37 BB ED 57 B4 54 7E 86 36 CD 70 A6 38 89 88 08 3D 18 72 B1 3E CA F2 49 71 D1 F7 17 B7 }
	condition:
		$1
}

rule file_44_0_1 {
	meta:
		name = "fdim"
		size = 104
		refs = "0014 __fpclassifyd 003c __gtdf2 0060 __subdf3"
	strings:
		$1 = { F0 40 2D E9 01 70 A0 E1 00 60 A0 E1 02 40 A0 E1 03 50 A0 E1 ?? ?? ?? ?? 01 00 50 E3 7F 04 A0 93 0F 06 80 92 00 10 A0 93 F0 80 BD 98 07 10 A0 E1 06 00 A0 E1 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 00 00 A0 D3 00 10 A0 D3 F0 80 BD D8 06 00 A0 E1 07 10 A0 E1 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? F0 80 BD E8 }
	condition:
		$1
}

rule file_45_0_1 {
	meta:
		name = "rint"
		size = 420
		refs = "008c __adddf3 00a0 __subdf3"
	strings:
		$1 = { 40 3A A0 E1 F0 41 2D E9 83 3A A0 E1 A3 3A A0 E1 FF 3F 43 E2 03 30 43 E2 13 00 53 E3 08 D0 4D E2 00 50 A0 E1 01 60 A0 E1 00 70 A0 E1 01 80 A0 E1 01 C0 A0 E1 A0 4F A0 E1 1F 00 00 CA 00 00 53 E3 32 00 00 BA 01 26 A0 E3 01 20 42 E2 52 23 A0 E1 00 10 02 E0 06 10 91 E1 13 00 00 0A A2 20 A0 E1 00 10 02 E0 06 10 91 E1 01 C0 A0 01 45 00 00 1A 28 31 9F E5 84 41 83 E0 30 00 94 E8 0C 30 A0 E1 07 20 A0 E1 05 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 03 00 8D E8 05 30 A0 E1 04 20 A0 E1 03 00 9D E8 ?? ?? ?? ?? 00 50 A0 E1 01 60 A0 E1 05 00 A0 E1 06 10 A0 E1 08 D0 8D E2 F0 81 BD E8 33 00 53 E3 07 00 00 DA 01 0B 53 E3 F7 FF FF 1A 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 00 50 A0 E1 01 60 A0 E1 F1 FF FF EA 14 30 43 E2 00 20 E0 E3 32 23 A0 E1 01 00 12 E1 EC FF FF 0A A2 20 A0 E1 01 00 12 E1 02 20 C1 11 01 C1 A0 13 5C C3 82 11 D7 FF FF EA 02 31 C0 E3 01 30 93 E1 E3 FF FF 0A FF 34 C0 E3 0F 36 C3 E3 01 C0 83 E1 00 30 6C E2 0C C0 83 E1 A0 38 A0 E1 64 00 9F E5 2C C6 A0 E1 84 01 80 E0 60 00 90 E8 02 C7 0C E2 83 38 A0 E1 03 10 8C E1 01 20 A0 E1 08 30 A0 E1 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 03 00 8D E8 06 30 A0 E1 05 20 A0 E1 03 00 9D E8 ?? ?? ?? ?? 02 31 C0 E3 01 60 A0 E1 84 5F 83 E1 C8 FF FF EA 13 00 53 E3 02 20 C0 11 02 78 A0 13 01 C1 A0 03 57 73 82 11 B3 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_46_0_1 {
	meta:
		name = "scalblnf"
		size = 308
		refs = "0034 __mulsf3 00a4 __addsf3 00f0 copysignf"
	strings:
		$1 = { 02 31 C0 E3 A3 3B A0 E1 83 3B A0 E1 C3 3B B0 E1 10 40 2D E9 00 20 A0 E1 00 C0 A0 E1 01 40 A0 E1 1C 00 00 1A 02 C1 C0 E3 00 00 5C E3 17 00 00 0A 13 13 A0 E3 ?? ?? ?? ?? 02 31 C0 E3 A3 3B A0 E1 83 3B A0 E1 C3 3B A0 E1 00 20 A0 E1 00 C0 A0 E1 19 30 43 E2 C3 1C A0 E3 04 30 83 E0 50 10 81 E2 01 00 54 E1 FE 00 53 D3 28 00 00 CA C3 1C E0 E3 4F 10 41 E2 01 00 54 E1 18 00 00 BA 00 00 53 E3 7F 24 CC C3 02 25 C2 C3 83 2B 82 C1 08 00 00 DA 02 00 A0 E1 10 80 BD E8 FF 00 53 E3 EC FF FF 1A 00 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 02 00 A0 E1 10 80 BD E8 18 00 73 E3 08 00 00 BA 7F C4 CC E3 19 30 83 E2 02 C5 CC E3 83 0B 8C E1 33 14 A0 E3 ?? ?? ?? ?? 00 20 A0 E1 02 00 A0 E1 10 80 BD E8 DA 06 A0 E3 09 09 80 E2 02 10 A0 E1 26 0E 80 E2 ?? ?? ?? ?? DA 16 A0 E3 09 19 81 E2 26 1E 81 E2 ?? ?? ?? ?? 00 20 A0 E1 02 00 A0 E1 10 80 BD E8 02 10 A0 E1 14 00 9F E5 ?? ?? ?? ?? 0C 10 9F E5 ?? ?? ?? ?? 00 20 A0 E1 02 00 A0 E1 10 80 BD E8 CA F2 49 71 }
	condition:
		$1
}

rule file_47_0_1 {
	meta:
		name = "lroundf"
		size = 136
		refs = "0068 __fixsfsi"
	strings:
		$1 = { 02 31 C0 E3 A3 3B A0 E1 83 3B A0 E1 A3 3B A0 E1 00 00 50 E3 7F 20 43 E2 00 10 E0 B3 01 10 A0 A3 1E 00 52 E3 04 E0 2D E5 0E 00 00 CA 00 00 52 E3 10 00 00 BA FF C4 C0 E3 16 00 52 E3 02 C5 CC E3 02 C5 8C E3 01 35 A0 D3 53 C2 8C D0 96 30 43 C2 17 20 62 D2 1C C3 A0 C1 3C C2 A0 D1 9C 01 01 E0 01 00 A0 E1 04 F0 9D E4 ?? ?? ?? ?? 00 10 A0 E1 01 00 A0 E1 04 F0 9D E4 01 00 72 E3 00 10 A0 13 01 00 A0 E1 04 F0 9D E4 }
	condition:
		$1
}

rule file_48_0_1 {
	meta:
		name = "fmod"
		size = 308
		refs = "0018 __ieee754_fmod 003c __isnand 007c __eqdf2 00c8 __divdf3 00dc __errno 010c matherr 012c __fdlib_version"
	strings:
		$1 = { F0 4F 2D E9 24 D0 4D E2 03 80 A0 E1 00 A0 A0 E1 01 B0 A0 E1 02 70 A0 E1 ?? ?? ?? ?? 08 61 9F E5 00 30 96 E5 01 00 73 E3 00 40 A0 E1 01 50 A0 E1 04 00 00 0A 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 03 00 00 0A 04 00 A0 E1 05 10 A0 E1 24 D0 8D E2 F0 8F BD E8 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 00 90 50 E2 F6 FF FF 1A 07 00 A0 E1 08 10 A0 E1 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 EF FF FF 1A 01 30 A0 E3 00 40 96 E5 00 30 8D E5 94 30 9F E5 00 00 54 E3 04 30 8D E5 10 70 8D E5 14 80 8D E5 20 90 8D E5 08 A0 8D E5 0C B0 8D E5 11 00 00 0A 00 00 A0 E3 00 10 A0 E3 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 02 00 54 E3 18 00 8D E5 1C 10 8D E5 0A 00 00 1A ?? ?? ?? ?? 21 30 A0 E3 00 30 80 E5 20 30 9D E5 00 00 53 E3 09 00 00 1A 18 50 8D E2 30 00 95 E8 D1 FF FF EA 18 A0 8D E5 1C B0 8D E5 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 F3 FF FF 1A EF FF FF EA ?? ?? ?? ?? 20 30 9D E5 00 30 80 E5 F1 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_50_0_1 {
	meta:
		name = "coshf"
		size = 284
		refs = "000c __ieee754_coshf 0028 isnanf 0044 fabsf 004c __gtsf2 0070 __extendsfdf2 00a8 matherr 00c8 __truncdfsf2 00f0 __errno 0110 __fdlib_version"
	strings:
		$1 = { F0 40 2D E9 24 D0 4D E2 00 60 A0 E1 ?? ?? ?? ?? F8 50 9F E5 00 30 95 E5 01 00 73 E3 00 40 A0 E1 03 00 00 0A 06 00 A0 E1 ?? ?? ?? ?? 00 70 50 E2 02 00 00 0A 04 00 A0 E1 24 D0 8D E2 F0 80 BD E8 06 00 A0 E1 ?? ?? ?? ?? C4 10 9F E5 ?? ?? ?? ?? 00 00 50 E3 F6 FF FF DA 03 30 A0 E3 00 30 8D E5 B0 30 9F E5 06 00 A0 E1 04 30 8D E5 20 70 8D E5 ?? ?? ?? ?? 00 30 95 E5 00 00 53 E3 08 00 8D E5 0C 10 8D E5 10 00 8D E5 14 10 8D E5 10 00 00 1A 2E 33 E0 E3 01 36 43 E2 0E 42 A0 E3 18 30 8D E5 1C 40 8D E5 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 0E 00 00 0A 20 30 9D E5 00 00 53 E3 0F 00 00 1A 18 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 40 A0 E1 D7 FF FF EA 02 00 53 E3 7F 34 A0 E3 0F 36 83 E2 00 40 A0 E3 18 30 8D E5 1C 40 8D E5 EC FF FF 1A ?? ?? ?? ?? 22 30 A0 E3 00 30 80 E5 EC FF FF EA ?? ?? ?? ?? 20 30 9D E5 00 30 80 E5 EB FF FF EA ?? ?? ?? ?? FC D4 B2 42 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_51_0_1 {
	meta:
		name = "gamma_r"
		size = 388
		refs = "0010 __ieee754_gamma_r 002c finite 00a0 floor 00ac __eqdf2 00c8 __ledf2 00ec matherr 0128 __errno 017c __fdlib_version"
	strings:
		$1 = { F0 45 2D E9 24 D0 4D E2 00 50 A0 E1 01 60 A0 E1 ?? ?? ?? ?? 60 41 9F E5 00 30 94 E5 01 00 73 E3 00 70 A0 E1 01 80 A0 E1 02 00 00 0A ?? ?? ?? ?? 00 A0 50 E2 03 00 00 0A 07 00 A0 E1 08 10 A0 E1 24 D0 8D E2 F0 85 BD E8 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 F6 FF FF 0A 00 30 94 E5 00 00 53 E3 14 31 9F E5 20 A0 8D E5 04 30 8D E5 10 50 8D E5 14 60 8D E5 08 50 8D E5 0C 60 8D E5 22 00 00 1A 2E 23 E0 E3 01 26 42 E2 0E 32 A0 E3 18 20 8D E5 1C 30 8D E5 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 06 00 00 1A 05 00 A0 E1 06 10 A0 E1 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 18 00 00 DA 00 30 94 E5 02 00 53 E3 03 30 A0 E3 00 30 8D E5 0F 00 00 0A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 0B 00 00 0A 20 30 9D E5 00 00 53 E3 19 00 00 1A 18 80 8D E2 80 01 98 E8 C9 FF FF EA 7F 24 A0 E3 0F 26 82 E2 00 30 A0 E3 18 20 8D E5 1C 30 8D E5 DB FF FF EA ?? ?? ?? ?? 22 30 A0 E3 00 30 80 E5 EF FF FF EA 00 30 94 E5 02 00 53 E3 02 30 A0 E3 00 30 8D E5 03 00 00 0A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 E6 FF FF 1A ?? ?? ?? ?? 21 30 A0 E3 00 30 80 E5 E2 FF FF EA ?? ?? ?? ?? 20 30 9D E5 00 30 80 E5 E1 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_175_0_1 {
	meta:
		name = "lgamma_r"
		size = 388
		refs = "0010 __ieee754_lgamma_r 002c finite 00a0 floor 00ac __eqdf2 00c8 __ledf2 00ec matherr 0128 __errno 017c __fdlib_version"
	strings:
		$1 = { F0 45 2D E9 24 D0 4D E2 00 50 A0 E1 01 60 A0 E1 ?? ?? ?? ?? 60 41 9F E5 00 30 94 E5 01 00 73 E3 00 70 A0 E1 01 80 A0 E1 02 00 00 0A ?? ?? ?? ?? 00 A0 50 E2 03 00 00 0A 07 00 A0 E1 08 10 A0 E1 24 D0 8D E2 F0 85 BD E8 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 F6 FF FF 0A 00 30 94 E5 00 00 53 E3 14 31 9F E5 20 A0 8D E5 04 30 8D E5 10 50 8D E5 14 60 8D E5 08 50 8D E5 0C 60 8D E5 22 00 00 1A 2E 23 E0 E3 01 26 42 E2 0E 32 A0 E3 18 20 8D E5 1C 30 8D E5 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 06 00 00 1A 05 00 A0 E1 06 10 A0 E1 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 18 00 00 DA 00 30 94 E5 02 00 53 E3 03 30 A0 E3 00 30 8D E5 0F 00 00 0A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 0B 00 00 0A 20 30 9D E5 00 00 53 E3 19 00 00 1A 18 80 8D E2 80 01 98 E8 C9 FF FF EA 7F 24 A0 E3 0F 26 82 E2 00 30 A0 E3 18 20 8D E5 1C 30 8D E5 DB FF FF EA ?? ?? ?? ?? 22 30 A0 E3 00 30 80 E5 EF FF FF EA 00 30 94 E5 02 00 53 E3 02 30 A0 E3 00 30 8D E5 03 00 00 0A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 E6 FF FF 1A ?? ?? ?? ?? 21 30 A0 E3 00 30 80 E5 E2 FF FF EA ?? ?? ?? ?? 20 30 9D E5 00 30 80 E5 E1 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_52_0_1 {
	meta:
		name = "significandf"
		size = 36
		refs = "0008 ilogbf 0010 __floatsisf 0020 __ieee754_scalbf"
	strings:
		$1 = { 10 40 2D E9 00 40 A0 E1 ?? ?? ?? ?? 00 00 60 E2 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_78_56_2 {
	meta:
		name = "_ZNSolsEf"
		size = 36
		refs = "000c __extendsfdf2 0020 _ZNSo9_M_insertIdEERSoT_"
	strings:
		$1 = { 10 40 2D E9 00 40 A0 E1 01 00 A0 E1 ?? ?? ?? ?? 01 20 A0 E1 00 10 A0 E1 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_53_0_1 {
	meta:
		name = "lround"
		size = 212
		refs = "0090 __fixdfsi"
	strings:
		$1 = { 00 20 A0 E1 00 00 52 E3 02 31 C2 E3 23 3A A0 E1 03 3A A0 E1 23 3A A0 E1 FF 3F 43 E2 03 30 43 E2 FF 24 C2 E3 10 48 2D E9 0F 26 C2 E3 00 40 E0 B3 01 40 A0 A3 13 00 53 E3 00 B0 A0 E1 01 C0 A0 E1 01 26 82 E3 08 00 00 CA 00 00 53 E3 1C 00 00 BA 02 C7 A0 E3 5C 23 82 E0 14 30 63 E2 32 23 A0 E1 92 04 04 E0 04 00 A0 E1 10 88 BD E8 1E 00 53 E3 06 00 00 8A 33 00 53 E3 08 00 00 DA 34 10 43 E2 1C C1 A0 E1 14 30 43 E2 12 23 8C E1 F3 FF FF EA ?? ?? ?? ?? 00 40 A0 E1 04 00 A0 E1 10 88 BD E8 14 10 43 E2 02 01 A0 E3 30 01 8C E0 34 30 63 E2 00 00 5C E1 30 03 A0 E1 01 20 82 82 12 21 80 E1 E6 FF FF EA 01 00 73 E3 00 40 A0 13 04 00 A0 E1 10 88 BD E8 }
	condition:
		$1
}

rule file_54_0_1 {
	meta:
		name = "__ieee754_log10f"
		size = 256
		refs = "0048 __floatsisf 0060 __ieee754_logf 0078 __mulsf3 00ac __addsf3 00c8 __divsf3 00e4 __subsf3"
	strings:
		$1 = { 02 31 C0 E3 00 00 53 E3 70 40 2D E9 00 10 A0 E1 00 50 A0 E1 29 00 00 0A 00 00 50 E3 30 00 00 BA 02 31 E0 E3 02 35 43 E2 03 00 50 E1 30 00 00 CA 02 05 50 E3 7E 00 E0 A3 24 00 00 BA C5 0B 80 E0 A0 6F A0 E1 00 00 86 E0 ?? ?? ?? ?? FF 54 C5 E3 00 40 A0 E1 02 55 C5 E3 7F 00 66 E2 80 0B 85 E1 ?? ?? ?? ?? FA 15 A0 E3 1A 18 81 E2 00 60 A0 E1 82 1D 81 E2 04 00 A0 E1 ?? ?? ?? ?? 78 10 9F E5 00 50 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 9B 11 E0 E3 12 16 41 E2 00 40 A0 E1 69 1B 41 E2 06 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 70 80 BD E8 00 10 A0 E3 33 03 A0 E3 ?? ?? ?? ?? 70 80 BD E8 13 13 A0 E3 ?? ?? ?? ?? 00 50 A0 E1 97 00 E0 E3 D5 FF FF EA ?? ?? ?? ?? 00 10 A0 E3 ?? ?? ?? ?? 70 80 BD E8 ?? ?? ?? ?? 70 80 BD E8 DB 27 54 35 }
	condition:
		$1
}

rule file_56_0_1 {
	meta:
		name = "fminf"
		size = 80
		refs = "000c __fpclassifyf 0038 __ltsf2"
	strings:
		$1 = { 30 40 2D E9 01 40 A0 E1 00 50 A0 E1 ?? ?? ?? ?? 00 00 50 E3 01 00 00 1A 04 00 A0 E1 30 80 BD E8 04 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 04 00 00 0A 05 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 F4 FF FF AA 05 40 A0 E1 04 00 A0 E1 30 80 BD E8 }
	condition:
		$1
}

rule file_57_0_1 {
	meta:
		name = "logbf"
		size = 92
		refs = "0034 __floatsisf 003c __mulsf3 0044 fabsf 0054 __divsf3"
	strings:
		$1 = { 02 21 D0 E3 04 E0 2D E5 00 10 A0 E1 0C 00 00 0A 02 31 E0 E3 02 35 43 E2 03 00 52 E1 06 00 00 CA C2 2B B0 E1 C2 04 A0 03 3F 07 80 02 04 F0 9D 04 7F 00 42 E2 ?? ?? ?? ?? 04 F0 9D E4 ?? ?? ?? ?? 04 F0 9D E4 ?? ?? ?? ?? 00 10 A0 E1 BF 04 A0 E3 02 05 80 E2 ?? ?? ?? ?? 04 F0 9D E4 }
	condition:
		$1
}

rule file_58_0_1 {
	meta:
		name = "__ieee754_log10"
		size = 400
		refs = "0044 __muldf3 007c __adddf3 0098 __floatsidf 00bc __ieee754_log 0154 __divdf3 0164 __subdf3"
	strings:
		$1 = { 01 06 50 E3 F0 47 2D E9 01 20 A0 E1 00 60 A0 E1 01 70 A0 E1 01 40 A0 E1 00 80 A0 E1 00 20 A0 A3 0D 00 00 AA 02 C1 C0 E3 02 C0 9C E1 43 00 00 0A 00 00 50 E3 48 00 00 BA 43 24 A0 E3 05 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 35 20 E0 E3 00 60 A0 E1 01 70 A0 E1 00 80 A0 E1 01 90 A0 E1 02 31 E0 E3 01 36 43 E2 03 00 58 E1 05 00 00 DA 06 00 A0 E1 07 10 A0 E1 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? F0 87 BD E8 FF 3F 42 E2 03 30 43 E2 48 3A 83 E0 A3 AF A0 E1 03 00 8A E0 ?? ?? ?? ?? FF 84 C8 E3 FF AF 6A E2 03 A0 8A E2 0F 86 C8 E3 00 40 A0 E1 01 50 A0 E1 0A 0A 88 E1 07 10 A0 E1 ?? ?? ?? ?? B0 30 8F E2 0C 00 93 E8 00 60 A0 E1 01 70 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 9C 30 8F E2 0C 00 93 E8 00 80 A0 E1 01 90 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 88 30 8F E2 0C 00 93 E8 00 40 A0 E1 01 50 A0 E1 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? F0 87 BD E8 C3 04 A0 E3 00 20 A0 E3 00 30 A0 E3 05 06 80 E2 00 10 A0 E3 ?? ?? ?? ?? F0 87 BD E8 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? F0 87 BD E8 13 44 D3 3F 00 60 9F 50 F3 FE 59 3D 36 2B F1 11 7B CB DB 3F 0E E5 26 15 }
	condition:
		$1
}

rule file_59_0_1 {
	meta:
		name = "erfc"
		size = 2600
		refs = "0094 __muldf3 00b4 __subdf3 00fc __adddf3 019c __divdf3 01f4 __floatunsidf 0368 fabs 054c __ieee754_exp"
	strings:
		$1 = { F0 4F 2D E9 02 31 E0 E3 01 36 43 E2 02 41 C0 E3 03 00 54 E1 18 D0 4D E2 00 50 A0 E1 01 60 A0 E1 00 80 A0 E1 01 90 A0 E1 00 70 A0 E1 6E 00 00 CA 03 31 E0 E3 15 38 43 E2 03 00 54 E1 0E 00 00 DA 03 31 E0 E3 03 37 43 E2 03 00 54 E1 80 01 00 DA BF 34 E0 E3 31 37 43 E2 03 00 54 E1 C1 00 00 DA 00 00 50 E3 00 00 A0 C3 00 10 A0 C3 6E 00 00 CA 01 01 A0 E3 00 10 A0 E3 6B 00 00 EA C3 34 E0 E3 09 36 43 E2 03 00 54 E1 69 00 00 DA 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 1B 3E 8F E2 0C 00 93 E8 00 80 A0 E1 01 90 A0 E1 ?? ?? ?? ?? 69 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? 65 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? 61 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? 5D 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 17 3E 8F E2 0C 00 93 E8 00 A0 A0 E1 01 B0 A0 E1 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 57 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? 53 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? 4F 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? 4B 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? FF 25 A0 E3 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 01 30 A0 E1 00 20 A0 E1 0B 10 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 03 31 E0 E3 03 36 43 E2 03 00 55 E1 11 01 00 CA 00 20 A0 E1 01 30 A0 E1 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 FF 05 A0 E3 01 30 A0 E1 03 06 80 E2 00 10 A0 E3 ?? ?? ?? ?? 0F 00 00 EA A0 0F A0 E1 80 00 A0 E1 ?? ?? ?? ?? 00 70 A0 E1 FF 05 A0 E3 01 80 A0 E1 05 20 A0 E1 06 30 A0 E1 03 06 80 E2 00 10 A0 E3 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 18 D0 8D E2 F0 8F BD E8 00 20 A0 E1 FF 05 A0 E3 01 30 A0 E1 03 06 80 E2 00 10 A0 E3 ?? ?? ?? ?? F6 FF FF EA D6 EA F8 BE AC 16 00 12 91 A2 77 3F E4 68 66 23 51 2A 9D 3F 4F 19 D7 DB 7D CD D4 3F 13 B9 1C 69 BA 6E C0 3F 68 DB 14 82 43 9C D0 BE 20 61 A2 42 C9 5D 21 3F 10 1A 1C 22 22 D0 74 3F 0F 6B D3 C4 4C A5 B0 3F BA CE 36 55 79 77 D9 3F 09 DC DA CD 4E 38 7E C0 3F 38 DC 9B 61 04 90 40 92 59 2E 6A 88 EC 83 40 28 F2 75 13 5D 14 64 40 98 ED C5 43 09 C2 31 40 5A 99 5F 55 BA 93 E9 3F DE 85 C2 70 12 34 84 3F 4A 6F E8 39 E2 70 36 C0 62 2D 71 42 74 A8 7D 40 63 E7 9F E7 19 F2 A3 40 E6 3B DF CE B7 FF A8 40 6A 24 8C 68 EB 02 98 40 18 51 9D 18 AE 5C 74 40 0A 9F 1B 22 8B 56 3E 40 90 51 1D 26 38 BF 61 BF 3F 07 96 0A 36 2A A2 3F EB 95 97 59 98 63 BC 3F EC 28 3E 3D CA 5F D4 3F E4 20 51 80 40 D2 D7 3F F1 C3 B8 FB 00 8D DA 3F 4D B3 92 AD B8 59 63 3F 38 75 F7 BE 54 8B 88 3F 1D 15 35 57 C2 ED 8B 3F 1C DD 51 6B 60 26 C0 3F 1F 35 63 E7 5C 63 B2 3F A7 E9 9F D9 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 00 A0 A0 E1 01 B0 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 FF 05 A0 E3 01 30 A0 E1 03 06 80 E2 00 10 A0 E3 ?? ?? ?? ?? 6D 3A A0 E3 B6 3E 83 E2 31 31 83 E2 03 00 54 E1 00 50 A0 E1 01 60 A0 E1 0A 01 00 DA BF 34 E0 E3 3A 37 43 E2 A8 7F A0 E1 03 00 54 E1 00 30 A0 D3 01 30 07 C2 00 00 53 E3 26 FF FF 1A 4F 3F 4F E2 0C 00 93 E8 ?? ?? ?? ?? 05 3D 4F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 15 3E 4F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 16 3E 4F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 17 3E 4F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 06 3D 4F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 19 3E 4F E2 0C 00 93 E8 ?? ?? ?? ?? 65 3F 4F E2 0C 00 93 E8 08 00 8D E5 0C 10 8D E5 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 6A 3F 4F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 6E 3F 4F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 72 3F 4F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 76 3F 4F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 7A 3F 4F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 7E 3F 4F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? FF 25 A0 E3 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 50 A0 E3 03 00 8D E8 05 30 A0 E1 0A 20 A0 E1 05 10 A0 E1 02 01 8A E2 ?? ?? ?? ?? FF 25 A0 E3 22 28 82 E2 00 30 A0 E3 ?? ?? ?? ?? ?? ?? ?? ?? 0A 20 A0 E1 10 00 8D E5 14 10 8D E5 0B 30 A0 E1 05 10 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 05 30 A0 E1 00 60 A0 E1 01 70 A0 E1 0A 20 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 0C 00 9D E8 00 40 A0 E1 01 50 A0 E1 08 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 10 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 00 58 E3 E2 00 00 DA 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? 0C FF FF EA 00 20 A0 E1 01 30 A0 E1 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? FF 25 A0 E3 00 70 A0 E1 01 80 A0 E1 05 00 A0 E1 06 10 A0 E1 02 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 FF 05 A0 E3 01 30 A0 E1 02 06 80 E2 00 10 A0 E3 ?? ?? ?? ?? F5 FE FF EA ?? ?? ?? ?? FF 25 A0 E3 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 36 3E 4F E2 0C 00 93 E8 00 40 A0 E1 01 50 A0 E1 ?? ?? ?? ?? DB 3F 4F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? DF 3F 4F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? E3 3F 4F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? E7 3F 4F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? EB 3F 4F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? EF 3F 4F E2 0C 00 93 E8 ?? ?? ?? ?? 0F 3D 4F E2 0C 00 93 E8 00 80 A0 E1 01 90 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? F5 3F 4F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? F9 3F 4F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? FD 3F 4F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 8B 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 87 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? FF 25 A0 E3 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 00 57 E3 00 20 A0 E1 01 30 A0 E1 62 00 00 BA 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 0F 07 E0 E3 2B 0C 40 E2 01 30 A0 E1 17 01 40 E2 02 11 A0 E3 ?? ?? ?? ?? 92 FE FF EA 07 3D 8F E2 0C 00 93 E8 ?? ?? ?? ?? 6F 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 6B 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 67 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 63 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 5F 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 5B 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 57 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 56 3F 8F E2 0C 00 93 E8 08 00 8D E5 0C 10 8D E5 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 51 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 4D 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 49 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 45 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 41 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? F4 30 8F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? E4 30 8F E2 0C 00 93 E8 EF FE FF EA 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 53 29 E0 E3 35 2C 42 E2 FB 21 42 E2 06 32 A0 E3 ?? ?? ?? ?? FF 25 A0 E3 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 2D FE FF EA 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 01 01 A0 E3 00 10 A0 E3 ?? ?? ?? ?? 24 FE FF EA F0 4A E1 3F 33 6F EB 92 66 3E BB 3F 23 E3 EE 18 EF A0 23 C0 5C C2 9A C6 65 52 54 40 F2 D2 E4 57 5C 13 67 40 B2 AB CC EB B1 4C 64 40 66 22 28 84 0A 30 4F 40 8D A3 CB E4 04 1E 25 40 26 E7 B0 41 16 34 E6 3F 60 73 BA E4 12 34 84 3F 35 64 0D 60 F2 EF AE BF 62 9A 74 EE EF 47 1A 40 93 4A 48 8E A3 28 5B 40 2C AE 48 EE 21 D0 7A 40 14 03 70 57 19 2B 84 40 68 28 EC 21 0D 29 7B 40 71 1A 8A D5 0C 35 61 40 21 E7 6A 52 B9 A6 33 40 87 76 70 BD }
	condition:
		$1
}

rule file_59_1_1 {
	meta:
		name = "erf"
		size = 2552
		refs = "00a4 __muldf3 00d4 __adddf3 00f4 __floatsidf 0114 __divdf3 015c __subdf3 03a4 fabs 0568 __ieee754_exp"
	strings:
		$1 = { F0 4F 2D E9 02 31 E0 E3 01 36 43 E2 02 41 C0 E3 03 00 54 E1 18 D0 4D E2 00 50 A0 E1 01 60 A0 E1 00 80 A0 E1 01 90 A0 E1 00 70 A0 E1 2D 00 00 CA 03 31 E0 E3 15 38 43 E2 03 00 54 E1 0F 00 00 DA 03 31 E0 E3 03 37 43 E2 03 00 54 E1 7D 01 00 DA BF 34 E0 E3 3A 37 43 E2 03 00 54 E1 D0 00 00 DA 00 00 50 E3 BF 04 A0 B3 FF 05 A0 A3 0F 06 80 B2 00 10 A0 B3 03 06 80 A2 00 10 A0 A3 2A 00 00 EA C1 34 E0 E3 0D 36 43 E2 03 00 54 E1 28 00 00 CA 02 05 54 E3 64 01 00 AA 01 21 A0 E3 02 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 6F 3F 8F E2 0C 00 93 E8 00 70 A0 E1 01 80 A0 E1 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? FF 25 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 10 00 00 EA A0 7F A0 E1 87 00 A0 E1 01 00 60 E2 ?? ?? ?? ?? 00 70 A0 E1 FF 05 A0 E3 01 80 A0 E1 05 20 A0 E1 06 30 A0 E1 03 06 80 E2 00 10 A0 E3 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 18 D0 8D E2 F0 8F BD E8 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 4B 3F 8F E2 0C 00 93 E8 00 70 A0 E1 01 80 A0 E1 ?? ?? ?? ?? 12 3E 8F E2 0C 00 93 E8 ?? ?? ?? ?? 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? 11 3E 8F E2 0C 00 93 E8 ?? ?? ?? ?? 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? 01 3C 8F E2 0C 00 93 E8 ?? ?? ?? ?? 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? F0 30 8F E2 0C 00 93 E8 ?? ?? ?? ?? EC 30 8F E2 0C 00 93 E8 00 A0 A0 E1 01 B0 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? D8 30 8F E2 0C 00 93 E8 ?? ?? ?? ?? 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? C8 30 8F E2 0C 00 93 E8 ?? ?? ?? ?? 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? B8 30 8F E2 0C 00 93 E8 ?? ?? ?? ?? 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? A8 30 8F E2 0C 00 93 E8 ?? ?? ?? ?? 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? FF 25 A0 E3 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? AF FF FF EA BA 6E F0 3F 69 DB 14 82 D6 EA F8 BE AC 16 00 12 91 A2 77 3F E4 68 66 23 51 2A 9D 3F 4F 19 D7 DB 7D CD D4 3F 13 B9 1C 69 BA 6E C0 3F 68 DB 14 82 43 9C D0 BE 20 61 A2 42 C9 5D 21 3F 10 1A 1C 22 22 D0 74 3F 0F 6B D3 C4 4C A5 B0 3F BA CE 36 55 79 77 D9 3F 09 DC DA CD 4E 38 7E C0 3F 38 DC 9B 61 04 90 40 92 59 2E 6A 88 EC 83 40 28 F2 75 13 5D 14 64 40 98 ED C5 43 09 C2 31 40 5A 99 5F 55 BA 93 E9 3F DE 85 C2 70 12 34 84 3F 4A 6F E8 39 E2 70 36 C0 62 2D 71 42 74 A8 7D 40 63 E7 9F E7 19 F2 A3 40 E6 3B DF CE B7 FF A8 40 6A 24 8C 68 EB 02 98 40 18 51 9D 18 AE 5C 74 40 0A 9F 1B 22 8B 56 3E 40 90 51 1D 26 BA 6E C0 3F 69 DB 14 82 38 BF 61 BF 3F 07 96 0A 36 2A A2 3F EB 95 97 59 98 63 BC 3F EC 28 3E 3D CA 5F D4 3F E4 20 51 80 40 D2 D7 3F F1 C3 B8 FB 00 8D DA 3F 4D B3 92 AD B8 59 63 3F 38 75 F7 BE 54 8B 88 3F 1D 15 35 57 C2 ED 8B 3F 1C DD 51 6B 60 26 C0 3F 1F 35 63 E7 5C 63 B2 3F A7 E9 9F D9 F0 4A E1 3F 33 6F EB 92 66 3E BB 3F 23 E3 EE 18 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 00 A0 A0 E1 01 B0 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 FF 05 A0 E3 01 30 A0 E1 03 06 80 E2 00 10 A0 E3 ?? ?? ?? ?? 6D 3A A0 E3 B6 3E 83 E2 35 31 83 E2 03 00 54 E1 00 50 A0 E1 01 60 A0 E1 F6 00 00 DA 4D 3F 4F E2 0C 00 93 E8 ?? ?? ?? ?? 4E 3F 4F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 52 3F 4F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 56 3F 4F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 5A 3F 4F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 5E 3F 4F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 62 3F 4F E2 0C 00 93 E8 ?? ?? ?? ?? 63 3F 4F E2 0C 00 93 E8 08 00 8D E5 0C 10 8D E5 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 1A 3E 4F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 1B 3E 4F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 07 3D 4F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 1D 3E 4F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 1E 3E 4F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 1F 3E 4F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? FF 25 A0 E3 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 50 A0 E3 03 00 8D E8 05 30 A0 E1 0A 20 A0 E1 05 10 A0 E1 02 01 8A E2 ?? ?? ?? ?? FF 25 A0 E3 22 28 82 E2 00 30 A0 E3 ?? ?? ?? ?? ?? ?? ?? ?? 0A 20 A0 E1 10 00 8D E5 14 10 8D E5 0B 30 A0 E1 05 10 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 05 30 A0 E1 00 60 A0 E1 01 70 A0 E1 0A 20 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 0C 00 9D E8 00 40 A0 E1 01 50 A0 E1 08 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 10 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 00 58 E3 D4 00 00 BA 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 FF 05 A0 E3 01 30 A0 E1 03 06 80 E2 00 10 A0 E3 ?? ?? ?? ?? BF FE FF EA 03 3C 4F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? B8 FE FF EA ?? ?? ?? ?? FF 25 A0 E3 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? CA 3F 4F E2 0C 00 93 E8 00 40 A0 E1 01 50 A0 E1 ?? ?? ?? ?? CD 3F 4F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? D1 3F 4F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? D5 3F 4F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? D9 3F 4F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? DD 3F 4F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? E1 3F 4F E2 0C 00 93 E8 ?? ?? ?? ?? E2 3F 4F E2 0C 00 93 E8 00 80 A0 E1 01 90 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? E7 3F 4F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? EB 3F 4F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? EF 3F 4F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? F3 3F 4F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? F7 3F 4F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? FF 25 A0 E3 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 00 57 E3 00 20 A0 E1 01 30 A0 E1 60 00 00 BA 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 53 29 E0 E3 35 2C 42 E2 FB 21 42 E2 06 32 A0 E3 ?? ?? ?? ?? 57 FE FF EA 69 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 1A 3E 8F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 19 3E 8F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 06 3D 8F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 17 3E 8F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 16 3E 8F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 15 3E 8F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 05 3D 8F E2 0C 00 93 E8 ?? ?? ?? ?? 4F 3F 8F E2 0C 00 93 E8 08 00 8D E5 0C 10 8D E5 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 4A 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 46 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 42 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? F8 30 8F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? E8 30 8F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? D8 30 8F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? C8 30 8F E2 0C 00 93 E8 FB FE FF EA 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 53 09 E0 E3 35 0C 40 E2 01 30 A0 E1 F9 01 40 E2 06 12 A0 E3 ?? ?? ?? ?? F4 FD FF EA 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? FF 25 A0 E3 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? EC FD FF EA EF A0 23 C0 5C C2 9A C6 65 52 54 40 F2 D2 E4 57 5C 13 67 40 B2 AB CC EB B1 4C 64 40 66 22 28 84 0A 30 4F 40 8D A3 CB E4 04 1E 25 40 26 E7 B0 41 16 34 E6 3F 60 73 BA E4 12 34 84 3F 35 64 0D 60 F2 EF AE BF 62 9A 74 EE EF 47 1A 40 93 4A 48 8E A3 28 5B 40 2C AE 48 EE 21 D0 7A 40 14 03 70 57 19 2B 84 40 68 28 EC 21 0D 29 7B 40 71 1A 8A D5 0C 35 61 40 21 E7 6A 52 B9 A6 33 40 87 76 70 BD }
	condition:
		$1
}

rule file_60_0_1 {
	meta:
		name = "asinh"
		size = 512
		refs = "003c __adddf3 004c __gtdf2 0068 __muldf3 007c fabs 00a0 __ieee754_sqrt 00c4 __divdf3 00dc log1p 01b0 __ieee754_log"
	strings:
		$1 = { 02 31 E0 E3 01 36 43 E2 02 21 C0 E3 03 00 52 E1 F0 4D 2D E9 00 40 A0 E1 00 60 A0 E1 01 50 A0 E1 64 00 00 CA C1 34 E0 E3 0D 36 43 E2 03 00 52 E1 32 00 00 CA 6D 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? FF 25 A0 E3 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 26 00 00 CA 04 20 A0 E1 05 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 70 A0 E1 01 80 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? FF 25 A0 E3 03 26 82 E2 00 30 A0 E3 00 40 A0 E1 01 50 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? FF 25 A0 E3 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 56 E3 00 40 A0 C1 01 50 A0 C1 02 41 80 D2 01 50 A0 D1 04 00 A0 E1 05 10 A0 E1 F0 8D BD E8 41 34 A0 E3 0B 36 83 E2 03 00 52 E1 31 00 00 CA 01 01 52 E3 CF FF FF DA ?? ?? ?? ?? 04 20 A0 E1 00 70 A0 E1 01 80 A0 E1 05 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? FF 25 A0 E3 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? ?? ?? ?? ?? 07 20 A0 E1 00 40 A0 E1 01 50 A0 E1 08 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 04 20 A0 E1 00 A0 A0 E1 01 B0 A0 E1 05 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 FF 05 A0 E3 01 30 A0 E1 03 06 80 E2 00 10 A0 E3 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? C9 FF FF EA 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 04 00 A0 E1 05 10 A0 E1 F0 8D BD E8 ?? ?? ?? ?? ?? ?? ?? ?? 10 30 8F E2 0C 00 93 E8 ?? ?? ?? ?? BB FF FF EA 3C E4 37 7E 9C 75 00 88 42 2E E6 3F EF 39 FA FE }
	condition:
		$1
}

rule file_61_0_1 {
	meta:
		name = "sincosf"
		size = 40
		refs = "0010 sinf 001c cosf"
	strings:
		$1 = { 70 40 2D E9 01 40 A0 E1 02 50 A0 E1 00 60 A0 E1 ?? ?? ?? ?? 00 00 84 E5 06 00 A0 E1 ?? ?? ?? ?? 00 00 85 E5 70 80 BD E8 }
	condition:
		$1
}

rule file_62_0_1 {
	meta:
		name = "atanf"
		size = 776
		refs = "0078 __mulsf3 00a0 __addsf3 0100 __subsf3 01b0 __gtsf2 01c0 fabsf 0210 __divsf3"
	strings:
		$1 = { AF 34 E0 E3 F0 41 2D E9 02 35 43 E2 02 51 C0 E3 03 00 55 E1 00 40 A0 E1 00 60 A0 E1 0C 00 00 DA 7F 34 A0 E3 02 35 83 E2 03 00 55 E1 57 00 00 CA 00 00 50 E3 DB 49 E0 D3 DB 49 E0 C3 03 4A 44 D2 03 4A 44 C2 91 41 44 D2 93 41 44 C2 04 00 A0 E1 F0 81 BD E8 C1 34 E0 E3 02 36 43 E2 03 00 55 E1 56 00 00 CA 31 04 55 E3 4D 00 00 BA 00 70 E0 E3 04 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 00 80 A0 E1 ?? ?? ?? ?? 48 12 9F E5 00 50 A0 E1 ?? ?? ?? ?? 96 1D E0 E3 9B 11 41 E2 AD 17 41 E2 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 28 12 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 1C 12 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 10 12 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 04 12 9F E5 ?? ?? ?? ?? 08 10 A0 E1 ?? ?? ?? ?? F8 11 9F E5 00 80 A0 E1 05 00 A0 E1 ?? ?? ?? ?? EC 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? E0 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? D4 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? C8 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 01 00 77 E3 00 10 A0 E1 35 00 00 0A B0 51 9F E5 08 00 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 07 31 85 E0 10 10 93 E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 07 01 95 E7 ?? ?? ?? ?? 00 00 56 E3 00 40 A0 A1 02 41 80 B2 04 00 A0 E1 F0 81 BD E8 00 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 04 00 A0 E1 F0 81 BD E8 58 11 9F E5 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 00 00 50 E3 AB FF FF DA A2 FF FF EA ?? ?? ?? ?? 03 31 E0 E3 1A 37 43 E2 03 00 55 E1 00 40 A0 E1 1A 00 00 CA 03 31 E0 E3 0D 36 43 E2 03 00 55 E1 2F 00 00 CA 00 10 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 01 11 A0 E3 00 50 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 70 A0 E3 00 40 A0 E1 93 FF FF EA 08 00 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 81 FF FF EA BF 34 E0 E3 39 37 43 E2 03 00 55 E1 0D 00 00 CA FF 15 A0 E3 ?? ?? ?? ?? FF 15 A0 E3 00 50 A0 E1 04 00 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 02 70 A0 E3 00 40 A0 E1 78 FF FF EA 00 10 A0 E1 BF 04 A0 E3 02 05 80 E2 ?? ?? ?? ?? 03 70 A0 E3 00 40 A0 E1 71 FF FF EA FE 15 A0 E3 ?? ?? ?? ?? FE 15 A0 E3 00 50 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 01 70 A0 E3 00 40 A0 E1 65 FF FF EA D7 69 85 3C 35 6B 88 3D 6E 2E BA 3D 25 49 12 3E AB AA AA 3E 21 A2 15 BD 6B F1 6E 3D 95 87 9D 3D 38 8E E3 3D CD CC 4C 3E ?? ?? ?? ?? CA F2 49 71 }
	condition:
		$1
}

rule file_64_0_1 {
	meta:
		name = "cosh"
		size = 296
		refs = "0010 __ieee754_cosh 0034 __isnand 0058 fabs 0064 __gtdf2 00b8 matherr 00f8 __errno 0120 __fdlib_version"
	strings:
		$1 = { F0 45 2D E9 24 D0 4D E2 00 40 A0 E1 01 50 A0 E1 ?? ?? ?? ?? 04 61 9F E5 00 30 96 E5 01 00 73 E3 00 70 A0 E1 01 80 A0 E1 04 00 00 0A 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 A0 50 E2 03 00 00 0A 07 00 A0 E1 08 10 A0 E1 24 D0 8D E2 F0 85 BD E8 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? B4 30 8F E2 0C 00 93 E8 ?? ?? ?? ?? 00 00 50 E3 F3 FF FF DA 03 20 A0 E3 00 30 96 E5 00 20 8D E5 A0 20 9F E5 00 00 53 E3 04 20 8D E5 20 A0 8D E5 08 40 8D E5 0C 50 8D E5 10 40 8D E5 14 50 8D E5 0E 00 00 1A 2E 33 E0 E3 01 36 43 E2 0E 42 A0 E3 18 30 8D E5 1C 40 8D E5 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 0C 00 00 0A 20 30 9D E5 00 00 53 E3 0D 00 00 1A 18 80 8D E2 80 01 98 E8 D8 FF FF EA 02 00 53 E3 7F 34 A0 E3 0F 36 83 E2 00 40 A0 E3 18 30 8D E5 1C 40 8D E5 EE FF FF 1A ?? ?? ?? ?? 22 30 A0 E3 00 30 80 E5 EE FF FF EA ?? ?? ?? ?? 20 30 9D E5 00 30 80 E5 ED FF FF EA CE 33 86 40 7D F8 B9 8F ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_65_0_1 {
	meta:
		name = "__ieee754_atanhf"
		size = 284
		refs = "0028 __addsf3 0030 __gtsf2 0050 __mulsf3 0060 __subsf3 006c __divsf3 0078 log1pf"
	strings:
		$1 = { F0 40 2D E9 02 51 C0 E3 FE 05 55 E3 00 40 A0 E1 00 60 A0 E1 1F 00 00 CA 39 00 00 0A C6 05 55 E3 23 00 00 AA EC 10 9F E5 ?? ?? ?? ?? 00 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 14 00 00 CA 05 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 00 40 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 00 70 A0 E1 FE 05 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 3F 14 A0 E3 ?? ?? ?? ?? 00 00 56 E3 00 40 A0 A1 02 41 80 B2 04 00 A0 E1 F0 80 BD E8 00 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 04 00 A0 E1 F0 80 BD E8 3F 04 55 E3 DF FF FF BA 05 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 00 40 A0 E1 FE 05 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 3F 14 A0 E3 ?? ?? ?? ?? 00 00 56 E3 00 40 A0 A1 02 41 80 B2 04 00 A0 E1 F0 80 BD E8 00 10 A0 E3 ?? ?? ?? ?? 00 40 A0 E1 04 00 A0 E1 F0 80 BD E8 CA F2 49 71 }
	condition:
		$1
}

rule file_67_0_1 {
	meta:
		name = "acoshf"
		size = 260
		refs = "000c __ieee754_acoshf 0028 isnanf 003c __ltsf2 0060 __extendsfdf2 008c __divdf3 00a8 matherr 00c8 __truncdfsf2 00dc __errno 00fc __fdlib_version"
	strings:
		$1 = { 70 48 2D E9 24 D0 4D E2 00 50 A0 E1 ?? ?? ?? ?? E4 40 9F E5 00 30 94 E5 01 00 73 E3 00 B0 A0 E1 2A 00 00 0A 05 00 A0 E1 ?? ?? ?? ?? 00 60 50 E2 26 00 00 1A 05 00 A0 E1 FE 15 A0 E3 ?? ?? ?? ?? 00 00 50 E3 21 00 00 AA 01 30 A0 E3 00 30 8D E5 A8 30 9F E5 05 00 A0 E1 04 30 8D E5 20 60 8D E5 ?? ?? ?? ?? 01 C0 A0 E1 00 B0 A0 E1 00 10 A0 E3 00 00 A0 E3 01 30 A0 E1 00 20 A0 E1 08 B0 8D E5 0C C0 8D E5 10 B0 8D E5 14 C0 8D E5 ?? ?? ?? ?? 00 30 94 E5 02 00 53 E3 18 00 8D E5 1C 10 8D E5 0D 00 00 0A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 09 00 00 0A 20 30 9D E5 00 00 53 E3 0A 00 00 1A 18 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 B0 A0 E1 0B 00 A0 E1 24 D0 8D E2 70 88 BD E8 ?? ?? ?? ?? 21 30 A0 E3 00 30 80 E5 F1 FF FF EA ?? ?? ?? ?? 20 30 9D E5 00 30 80 E5 F0 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_68_0_1 {
	meta:
		name = "gammaf"
		size = 472
		refs = "0018 __ieee754_gammaf_r 0030 finitef 005c floorf 0064 __eqsf2 0078 __lesf2 009c __extendsfdf2 00d4 matherr 00f4 __truncdfsf2 0180 __errno 01cc _impure_ptr 01d0 __fdlib_version"
	strings:
		$1 = { 70 40 2D E9 C0 31 9F E5 00 10 93 E5 24 D0 4D E2 A0 10 81 E2 00 50 A0 E1 ?? ?? ?? ?? AC 41 9F E5 00 30 94 E5 01 00 73 E3 00 60 A0 E1 02 00 00 0A ?? ?? ?? ?? 00 00 50 E3 02 00 00 0A 06 00 A0 E1 24 D0 8D E2 70 80 BD E8 05 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 F8 FF FF 0A 05 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 00 60 50 E2 23 00 00 1A 05 00 A0 E1 00 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 1E 00 00 CA 02 30 A0 E3 00 30 8D E5 40 31 9F E5 05 00 A0 E1 04 30 8D E5 20 60 8D E5 ?? ?? ?? ?? 00 30 94 E5 00 00 53 E3 08 00 8D E5 0C 10 8D E5 10 00 8D E5 14 10 8D E5 38 00 00 1A 2E 33 E0 E3 01 36 43 E2 0E 42 A0 E3 18 30 8D E5 1C 40 8D E5 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 36 00 00 0A 20 30 9D E5 00 00 53 E3 28 00 00 1A 18 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 60 A0 E1 CE FF FF EA 03 30 A0 E3 00 30 8D E5 C4 30 9F E5 05 00 A0 E1 04 30 8D E5 00 30 A0 E3 20 30 8D E5 ?? ?? ?? ?? 00 30 94 E5 00 00 53 E3 08 00 8D E5 0C 10 8D E5 10 00 8D E5 14 10 8D E5 09 00 00 1A 2E 33 E0 E3 01 36 43 E2 0E 42 A0 E3 18 30 8D E5 1C 40 8D E5 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 DF FF FF 1A 06 00 00 EA 02 00 53 E3 7F 34 A0 E3 0F 36 83 E2 00 40 A0 E3 18 30 8D E5 1C 40 8D E5 F3 FF FF 1A ?? ?? ?? ?? 22 30 A0 E3 00 30 80 E5 D3 FF FF EA ?? ?? ?? ?? 20 30 9D E5 00 30 80 E5 D2 FF FF EA 02 00 53 E3 7F 34 A0 E3 0F 36 83 E2 00 40 A0 E3 18 30 8D E5 1C 40 8D E5 C4 FF FF 1A ?? ?? ?? ?? 21 30 A0 E3 00 30 80 E5 C4 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_71_0_1 {
	meta:
		name = "scalbln"
		size = 428
		refs = "0048 __muldf3 00d8 __adddf3 0100 copysign"
	strings:
		$1 = { F0 48 2D E9 02 51 C0 E3 25 5A A0 E1 05 5A A0 E1 45 5A B0 E1 00 B0 A0 E1 01 C0 A0 E1 00 60 A0 E1 01 70 A0 E1 00 30 A0 E1 02 40 A0 E1 23 00 00 1A 02 31 C0 E3 01 30 93 E1 1D 00 00 0A 43 24 A0 E3 00 30 A0 E3 05 26 82 E2 ?? ?? ?? ?? 02 51 C0 E3 25 5A A0 E1 05 5A A0 E1 45 5A A0 E1 00 B0 A0 E1 01 C0 A0 E1 00 30 A0 E1 36 50 45 E2 7F 1E A0 E3 C3 2C A0 E3 04 50 85 E0 0E 10 81 E2 50 20 82 E2 02 00 54 E1 01 00 55 D1 36 00 00 CA C3 2C E0 E3 4F 20 42 E2 02 00 54 E1 14 00 00 BA 00 00 55 E3 1F 00 00 DA 7F 34 C3 E3 0F 36 C3 E3 05 3A 83 E1 03 B0 A0 E1 0B 00 A0 E1 0C 10 A0 E1 F0 88 BD E8 7F 2E A0 E3 0F 20 82 E2 02 00 55 E1 E6 FF FF 1A 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 00 B0 A0 E1 01 C0 A0 E1 0B 00 A0 E1 0C 10 A0 E1 F0 88 BD E8 0C 30 A0 E1 0B 20 A0 E1 9C 10 8F E2 03 00 91 E8 ?? ?? ?? ?? 90 30 8F E2 0C 00 93 E8 ?? ?? ?? ?? 00 B0 A0 E1 01 C0 A0 E1 0B 00 A0 E1 0C 10 A0 E1 F0 88 BD E8 35 00 75 E3 F0 FF FF BA 7F 34 C3 E3 36 50 85 E2 0F 36 C3 E3 05 3A 83 E1 F2 25 A0 E3 03 00 A0 E1 0C 10 A0 E1 01 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 B0 A0 E1 01 C0 A0 E1 0B 00 A0 E1 0C 10 A0 E1 F0 88 BD E8 0C 30 A0 E1 0B 20 A0 E1 2C 10 8F E2 03 00 91 E8 ?? ?? ?? ?? 20 30 8F E2 0C 00 93 E8 ?? ?? ?? ?? 00 B0 A0 E1 01 C0 A0 E1 0B 00 A0 E1 0C 10 A0 E1 F0 88 BD E8 1F 6E A5 01 59 F3 F8 C2 3C E4 37 7E 9C 75 00 88 }
	condition:
		$1
}

rule file_72_0_1 {
	meta:
		name = "lgammaf"
		size = 388
		refs = "0018 __ieee754_lgammaf_r 0030 finitef 0068 __extendsfdf2 00a0 floorf 00a8 __eqsf2 00bc __lesf2 00e0 matherr 0100 __truncdfsf2 0124 __errno 0178 _impure_ptr 017c __fdlib_version"
	strings:
		$1 = { F0 40 2D E9 6C 31 9F E5 00 10 93 E5 24 D0 4D E2 A0 10 81 E2 00 50 A0 E1 ?? ?? ?? ?? 58 41 9F E5 00 30 94 E5 01 00 73 E3 00 60 A0 E1 02 00 00 0A ?? ?? ?? ?? 00 70 50 E2 02 00 00 0A 06 00 A0 E1 24 D0 8D E2 F0 80 BD E8 05 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 F8 FF FF 0A 20 31 9F E5 05 00 A0 E1 04 30 8D E5 20 70 8D E5 ?? ?? ?? ?? 00 30 94 E5 00 00 53 E3 08 00 8D E5 0C 10 8D E5 10 00 8D E5 14 10 8D E5 20 00 00 1A 2E 23 E0 E3 01 26 42 E2 0E 32 A0 E3 18 20 8D E5 1C 30 8D E5 05 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 04 00 00 1A 05 00 A0 E1 00 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 1A 00 00 DA 00 30 94 E5 02 00 53 E3 03 30 A0 E3 00 30 8D E5 11 00 00 0A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 0D 00 00 0A 20 30 9D E5 00 00 53 E3 1B 00 00 1A 18 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 60 A0 E1 CB FF FF EA 7F 24 A0 E3 0F 26 82 E2 00 30 A0 E3 18 20 8D E5 1C 30 8D E5 DD FF FF EA ?? ?? ?? ?? 22 30 A0 E3 00 30 80 E5 ED FF FF EA 00 30 94 E5 02 00 53 E3 02 30 A0 E3 00 30 8D E5 03 00 00 0A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 E4 FF FF 1A ?? ?? ?? ?? 21 30 A0 E3 00 30 80 E5 E0 FF FF EA ?? ?? ?? ?? 20 30 9D E5 00 30 80 E5 DF FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_73_0_1 {
	meta:
		name = "scalb"
		size = 476
		refs = "0018 __ieee754_scalb 0034 finite 0050 __eqdf2 006c __nedf2 009c __errno 00b4 __isnand 00e4 __gtdf2 0188 copysign 01a4 matherr 01d4 __fdlib_version"
	strings:
		$1 = { F0 4D 2D E9 24 D0 4D E2 03 B0 A0 E1 00 70 A0 E1 01 80 A0 E1 02 A0 A0 E1 ?? ?? ?? ?? B0 61 9F E5 00 30 96 E5 01 00 73 E3 00 40 A0 E1 01 50 A0 E1 15 00 00 0A ?? ?? ?? ?? 00 00 50 E3 1A 00 00 0A 04 00 A0 E1 05 10 A0 E1 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 06 00 00 1A 07 00 A0 E1 08 10 A0 E1 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 35 00 00 1A 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 03 00 00 0A 04 00 A0 E1 05 10 A0 E1 24 D0 8D E2 F0 8D BD E8 ?? ?? ?? ?? 22 30 A0 E3 00 30 80 E5 F7 FF FF EA 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 DF FF FF 1A 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 DA FF FF 0A 00 30 A0 E3 00 20 A0 E3 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 20 96 E5 00 00 50 E3 02 31 A0 D3 7F 34 A0 C3 C3 35 A0 D1 00 40 A0 D3 0F 36 83 C2 00 40 A0 C3 02 00 52 E3 03 20 A0 E3 00 20 8D E5 BC 20 9F E5 04 20 8D E5 00 20 A0 E3 20 20 8D E5 08 70 8D E5 0C 80 8D E5 10 A0 8D E5 14 B0 8D E5 18 30 8D E5 1C 40 8D E5 17 00 00 1A ?? ?? ?? ?? 22 30 A0 E3 00 30 80 E5 17 00 00 EA 04 C0 A0 E3 00 C0 8D E5 78 C0 9F E5 08 30 A0 E1 04 C0 8D E5 07 20 A0 E1 00 C0 A0 E3 00 00 A0 E3 00 10 A0 E3 20 C0 8D E5 10 A0 8D E5 14 B0 8D E5 08 70 8D E5 0C 80 8D E5 ?? ?? ?? ?? 00 30 96 E5 02 00 53 E3 18 00 8D E5 1C 10 8D E5 E7 FF FF 0A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 E3 FF FF 0A 20 30 9D E5 00 00 53 E3 02 00 00 0A ?? ?? ?? ?? 20 30 9D E5 00 30 80 E5 18 50 8D E2 30 00 95 E8 AD FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_74_0_1 {
	meta:
		name = "sinh"
		size = 340
		refs = "0010 __ieee754_sinh 002c finite 009c __gtdf2 00c8 matherr 012c __errno 014c __fdlib_version"
	strings:
		$1 = { F0 45 2D E9 24 D0 4D E2 00 70 A0 E1 01 80 A0 E1 ?? ?? ?? ?? 30 61 9F E5 00 30 96 E5 01 00 73 E3 00 40 A0 E1 01 50 A0 E1 02 00 00 0A ?? ?? ?? ?? 00 A0 50 E2 03 00 00 0A 04 00 A0 E1 05 10 A0 E1 24 D0 8D E2 F0 85 BD E8 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 F6 FF FF 0A 03 30 A0 E3 00 40 96 E5 00 30 8D E5 E0 30 9F E5 00 00 54 E3 04 30 8D E5 20 A0 8D E5 10 70 8D E5 14 80 8D E5 08 70 8D E5 0C 80 8D E5 17 00 00 1A 00 30 A0 E3 07 00 A0 E1 08 10 A0 E1 00 20 A0 E3 ?? ?? ?? ?? 00 00 50 E3 0E 33 E0 D3 2E 33 E0 C3 01 36 43 D2 0E 42 A0 D3 01 36 43 C2 0E 42 A0 C3 18 30 8D E5 1C 40 8D E5 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 15 00 00 0A 20 30 9D E5 00 00 53 E3 16 00 00 1A 18 50 8D E2 30 00 95 E8 D2 FF FF EA 00 20 A0 E3 00 30 A0 E3 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 02 21 A0 D3 7F 24 A0 C3 C2 25 A0 D1 00 30 A0 D3 0F 26 82 C2 00 30 A0 C3 02 00 54 E3 18 20 8D E5 1C 30 8D E5 E5 FF FF 1A ?? ?? ?? ?? 22 30 A0 E3 00 30 80 E5 E5 FF FF EA ?? ?? ?? ?? 20 30 9D E5 00 30 80 E5 E4 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_75_0_1 {
	meta:
		name = "__ieee754_hypot"
		size = 940
		refs = "00b4 __muldf3 00f8 __subdf3 0110 __gtdf2 0174 __adddf3 01cc __ieee754_sqrt"
	strings:
		$1 = { F0 4F 2D E9 02 51 C0 E3 02 41 C2 E3 04 00 55 E1 02 60 A0 E1 05 60 A0 B1 04 50 A0 B1 06 40 A0 B1 03 C0 A0 A1 01 C0 A0 B1 03 10 A0 B1 05 30 64 E0 0F 05 53 E3 1C D0 4D E2 05 00 A0 E1 04 B0 A0 E1 01 80 A0 E1 05 70 A0 E1 04 A0 A0 E1 0C 60 A0 E1 84 00 00 CA 5F 34 A0 E3 03 36 83 E2 03 00 55 E1 00 90 A0 D3 6A 00 00 CA DF 34 E0 E3 05 36 43 E2 03 00 54 E1 1B 00 00 CA 01 06 54 E3 C4 00 00 AA 06 30 A0 E1 03 30 94 E1 5D 00 00 0A 00 30 A0 E3 03 C0 A0 E1 7F 34 A0 E3 0D E6 83 E2 0E 20 A0 E1 0C 30 A0 E1 06 10 A0 E1 04 00 A0 E1 0E B0 A0 E1 00 C0 8D E5 ?? ?? ?? ?? 00 C0 9D E5 00 A0 A0 E1 01 60 A0 E1 07 00 A0 E1 08 10 A0 E1 0B 20 A0 E1 0C 30 A0 E1 ?? ?? ?? ?? FF 9F 49 E2 02 90 49 E2 00 70 A0 E1 01 80 A0 E1 0A 20 A0 E1 06 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 0A 20 A0 E1 01 C0 A0 E1 06 30 A0 E1 00 C0 8D E5 00 B0 A0 E1 ?? ?? ?? ?? 00 00 50 E3 00 C0 9D E5 57 00 00 DA 05 30 A0 E1 00 40 A0 E3 04 50 A0 E1 03 40 A0 E1 03 20 A0 E1 04 00 A0 E1 05 30 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 0A 20 A0 E1 03 00 8D E9 06 30 A0 E1 02 01 8A E2 06 10 A0 E1 ?? ?? ?? ?? 04 20 A0 E1 0C 00 8D E5 10 10 8D E5 05 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 04 20 A0 E1 00 A0 A0 E1 01 B0 A0 E1 07 00 A0 E1 08 10 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 0C 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 03 00 9D E9 ?? ?? ?? ?? ?? ?? ?? ?? 00 70 A0 E1 01 80 A0 E1 00 00 59 E3 08 00 00 0A 09 9A A0 E1 FF 25 89 E2 07 00 A0 E1 08 10 A0 E1 00 30 A0 E3 03 26 82 E2 ?? ?? ?? ?? 00 70 A0 E1 01 80 A0 E1 07 00 A0 E1 08 10 A0 E1 1C D0 8D E2 F0 8F BD E8 02 31 E0 E3 01 36 43 E2 03 00 55 E1 54 00 00 DA FF 54 C5 E3 0F 56 C5 E3 01 50 95 E1 04 00 00 0A 04 20 A0 E1 0C 30 A0 E1 ?? ?? ?? ?? 00 70 A0 E1 01 80 A0 E1 7F 34 A0 E3 0F 36 83 E2 03 30 24 E0 06 30 83 E1 00 00 53 E3 06 80 A0 01 04 70 A0 01 E6 FF FF EA 04 20 A0 E1 0C 30 A0 E1 ?? ?? ?? ?? 00 70 A0 E1 01 80 A0 E1 E0 FF FF EA 00 30 A0 E3 04 20 A0 E1 01 06 85 E2 03 10 A0 E1 03 50 A0 E1 00 40 A0 E1 0C 00 8D E9 00 C0 8D E5 ?? ?? ?? ?? 00 C0 9D E5 0C 00 8D E5 10 10 8D E5 0C 30 A0 E1 0C 10 A0 E1 0B 20 A0 E1 02 01 8B E2 ?? ?? ?? ?? 0C 00 9D E9 14 00 8D E5 18 10 8D E5 0A 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 07 20 A0 E1 01 C0 A0 E1 08 30 A0 E1 00 B0 A0 E1 08 10 A0 E1 07 00 A0 E1 00 C0 8D E5 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 0A 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 00 C0 9D E5 00 20 A0 E1 01 30 A0 E1 0B 00 A0 E1 0C 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 14 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 0C 10 8D E2 03 00 91 E8 ?? ?? ?? ?? ?? ?? ?? ?? 00 70 A0 E1 01 80 A0 E1 97 FF FF EA 96 45 44 E2 96 55 45 E2 0C 60 A0 E1 05 70 A0 E1 04 A0 A0 E1 96 9F A0 E3 34 FF FF EA 96 45 84 E2 96 55 85 E2 96 9F 49 E2 05 70 A0 E1 04 A0 A0 E1 4E FF FF EA }
	condition:
		$1
}

rule file_76_0_1 {
	meta:
		name = "cbrt"
		size = 564
		refs = "0070 __muldf3 007c __divdf3 0094 __adddf3 0140 __subdf3"
	strings:
		$1 = { F0 4D 2D E9 02 C1 E0 E3 0C 40 00 E0 01 C6 4C E2 0C 00 54 E1 08 D0 4D E2 00 20 A0 E1 01 30 A0 E1 01 70 A0 E1 02 61 00 E2 62 00 00 CA 01 C0 94 E1 5C 00 00 0A 01 06 54 E3 03 80 A0 E1 04 70 A0 E1 60 00 00 BA E0 31 9F E5 94 23 C3 E0 2B 44 83 E2 06 46 44 E2 87 4C 44 E2 00 50 A0 E3 6D 40 44 E2 04 20 A0 E1 05 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 17 3E 8F E2 0C 00 93 E8 ?? ?? ?? ?? 5B 3F 8F E2 0C 00 93 E8 00 A0 A0 E1 01 B0 A0 E1 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 03 00 8D E8 55 1F 8F E2 03 00 91 E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 03 00 9D E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 4E 1F 8F E2 03 00 91 E8 ?? ?? ?? ?? 4D 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 00 50 A0 E3 01 40 80 E2 04 20 A0 E1 05 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 00 70 A0 E1 01 80 A0 E1 ?? ?? ?? ?? 04 20 A0 E1 00 A0 A0 E1 01 B0 A0 E1 05 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 01 30 A0 E1 00 20 86 E1 02 00 A0 E1 03 10 A0 E1 08 D0 8D E2 F0 8D BD E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 F7 FF FF EA 43 04 A0 E3 04 20 A0 E1 00 10 A0 E3 05 06 80 E2 ?? ?? ?? ?? 4C 30 9F E5 01 50 A0 E1 00 10 A0 E1 91 03 83 E0 A3 30 A0 E1 2A 44 83 E2 02 45 44 E2 87 4C 44 E2 6D 40 44 E2 96 FF FF EA 15 5F E1 3F F1 15 5F F1 EA A0 F6 3F 0F EA A0 0E DE 91 E6 BF 34 C8 32 25 DB B6 F9 3F 6E DB B6 6D 6D DB D6 3F B7 6D DB B6 56 55 55 55 AB AA AA AA }
	condition:
		$1
}

rule file_78_0_1 {
	meta:
		name = "ceil"
		size = 396
		refs = "0064 __adddf3 0070 __gtdf2"
	strings:
		$1 = { F0 47 2D E9 40 4A A0 E1 84 4A A0 E1 A4 4A A0 E1 FF 4F 44 E2 03 40 44 E2 13 00 54 E3 00 20 A0 E1 01 30 A0 E1 00 50 A0 E1 01 60 A0 E1 00 70 A0 E1 00 A0 A0 E1 01 80 A0 E1 15 00 00 CA 00 00 54 E3 34 00 00 BA 01 C6 A0 E3 01 C0 4C E2 5C 94 A0 E1 00 70 09 E0 01 70 97 E1 0A 00 00 0A 12 3E 8F E2 0C 00 93 E8 ?? ?? ?? ?? 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 38 00 00 CA 06 70 A0 E1 05 20 A0 E1 07 30 A0 E1 02 00 A0 E1 03 10 A0 E1 F0 87 BD E8 33 00 54 E3 05 00 00 DA 01 0B 54 E3 F8 FF FF 1A ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 F4 FF FF EA 14 C0 44 E2 00 70 E0 E3 37 7C A0 E1 01 00 17 E1 EF FF FF 0A B4 30 8F E2 0C 00 93 E8 ?? ?? ?? ?? 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 E4 FF FF DA 00 00 55 E3 22 00 00 DA 14 00 54 E3 1F 00 00 0A 01 30 A0 E3 34 40 64 E2 13 44 86 E0 04 00 56 E1 03 A0 85 80 07 70 C4 E1 0A 50 A0 E1 D9 FF FF EA 64 30 8F E2 0C 00 93 E8 ?? ?? ?? ?? 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 D0 FF FF DA 00 00 55 E3 00 70 A0 B3 02 51 A0 B3 CD FF FF BA 07 70 96 E1 FF 55 A0 13 03 56 85 12 00 70 A0 13 07 50 A0 01 C7 FF FF EA 00 00 55 E3 01 36 A0 C3 53 A4 85 C0 00 70 A0 E3 09 50 CA E1 C1 FF FF EA 01 A0 85 E2 06 40 A0 E1 E1 FF FF EA 3C E4 37 7E 9C 75 00 88 }
	condition:
		$1
}

rule file_79_0_1 {
	meta:
		name = "hypotf"
		size = 296
		refs = "0010 __ieee754_hypotf 0028 finitef 0078 __extendsfdf2 00bc __errno 00dc __truncdfsf2 0100 matherr 0120 __fdlib_version"
	strings:
		$1 = { F0 41 2D E9 24 D0 4D E2 00 50 A0 E1 01 60 A0 E1 ?? ?? ?? ?? 04 41 9F E5 00 30 94 E5 01 00 73 E3 00 70 A0 E1 02 00 00 0A ?? ?? ?? ?? 00 80 50 E2 02 00 00 0A 07 00 A0 E1 24 D0 8D E2 F0 81 BD E8 05 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 F8 FF FF 0A 06 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 F4 FF FF 0A 03 30 A0 E3 00 30 8D E5 B4 30 9F E5 05 00 A0 E1 04 30 8D E5 20 80 8D E5 ?? ?? ?? ?? 08 00 8D E5 0C 10 8D E5 06 00 A0 E1 ?? ?? ?? ?? 00 30 94 E5 00 00 53 E3 10 00 8D E5 14 10 8D E5 11 00 00 0A 02 00 53 E3 7F 34 A0 E3 0F 36 83 E2 00 40 A0 E3 18 30 8D E5 1C 40 8D E5 0F 00 00 1A ?? ?? ?? ?? 22 30 A0 E3 00 30 80 E5 20 30 9D E5 00 00 53 E3 0E 00 00 1A 18 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 70 A0 E1 D2 FF FF EA 2E 33 E0 E3 01 36 43 E2 0E 42 A0 E3 18 30 8D E5 1C 40 8D E5 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 EE FF FF 1A EA FF FF EA ?? ?? ?? ?? 20 30 9D E5 00 30 80 E5 EC FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_80_0_1 {
	meta:
		name = "fmin"
		size = 112
		refs = "0014 __fpclassifyd 0050 __ltdf2"
	strings:
		$1 = { F0 40 2D E9 00 60 A0 E1 01 70 A0 E1 02 40 A0 E1 03 50 A0 E1 ?? ?? ?? ?? 00 00 50 E3 02 00 00 1A 04 00 A0 E1 05 10 A0 E1 F0 80 BD E8 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 06 00 00 0A 06 00 A0 E1 07 10 A0 E1 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 F0 FF FF AA 06 40 A0 E1 07 50 A0 E1 04 00 A0 E1 05 10 A0 E1 F0 80 BD E8 }
	condition:
		$1
}

rule file_82_0_1 {
	meta:
		name = "lgamma"
		size = 404
		refs = "001c __ieee754_lgamma_r 0038 finite 00ac floor 00b8 __eqdf2 00d4 __ledf2 00f8 matherr 0134 __errno 0188 _impure_ptr 018c __fdlib_version"
	strings:
		$1 = { F0 45 2D E9 7C 31 9F E5 00 20 93 E5 24 D0 4D E2 A0 20 82 E2 00 50 A0 E1 01 60 A0 E1 ?? ?? ?? ?? 64 41 9F E5 00 30 94 E5 01 00 73 E3 00 70 A0 E1 01 80 A0 E1 02 00 00 0A ?? ?? ?? ?? 00 A0 50 E2 03 00 00 0A 07 00 A0 E1 08 10 A0 E1 24 D0 8D E2 F0 85 BD E8 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 F6 FF FF 0A 00 30 94 E5 00 00 53 E3 18 31 9F E5 20 A0 8D E5 04 30 8D E5 08 50 8D E5 0C 60 8D E5 10 50 8D E5 14 60 8D E5 22 00 00 1A 2E 23 E0 E3 01 26 42 E2 0E 32 A0 E3 18 20 8D E5 1C 30 8D E5 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 06 00 00 1A 05 00 A0 E1 06 10 A0 E1 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 18 00 00 DA 00 30 94 E5 02 00 53 E3 03 30 A0 E3 00 30 8D E5 0F 00 00 0A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 0B 00 00 0A 20 30 9D E5 00 00 53 E3 19 00 00 1A 18 80 8D E2 80 01 98 E8 C9 FF FF EA 7F 24 A0 E3 0F 26 82 E2 00 30 A0 E3 18 20 8D E5 1C 30 8D E5 DB FF FF EA ?? ?? ?? ?? 22 30 A0 E3 00 30 80 E5 EF FF FF EA 00 30 94 E5 02 00 53 E3 02 30 A0 E3 00 30 8D E5 03 00 00 0A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 E6 FF FF 1A ?? ?? ?? ?? 21 30 A0 E3 00 30 80 E5 E2 FF FF EA ?? ?? ?? ?? 20 30 9D E5 00 30 80 E5 E1 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_83_0_1 {
	meta:
		name = "__ieee754_ynf"
		size = 344
		refs = "0060 __ieee754_y0f 006c __ieee754_y1f 008c __floatsisf 0094 __divsf3 009c __mulsf3 00a4 __subsf3 00f0 __addsf3"
	strings:
		$1 = { 7F 34 A0 E3 02 35 83 E2 02 21 C1 E3 03 00 52 E1 F0 45 2D E9 01 60 A0 E1 00 70 A0 E1 32 00 00 CA 00 00 52 E3 29 00 00 0A 00 00 51 E3 3B 00 00 BA 00 00 50 E3 34 00 00 BA 01 A0 A0 13 2F 00 00 0A 01 00 57 E3 3A 00 00 0A 7F 34 A0 E3 02 35 83 E2 03 00 52 E1 00 40 A0 03 21 00 00 0A 06 00 A0 E1 ?? ?? ?? ?? 00 80 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 02 05 70 E3 00 40 A0 E1 10 00 00 0A 01 50 A0 E3 00 00 00 EA 00 40 A0 E1 85 00 A0 E1 ?? ?? ?? ?? 06 10 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 08 10 A0 E1 ?? ?? ?? ?? 01 50 85 E2 02 05 70 E3 05 00 57 11 04 80 A0 E1 F1 FF FF CA 00 40 A0 E1 00 00 5A E3 02 41 84 D2 04 00 A0 E1 F0 85 BD E8 BF 04 A0 E3 02 05 80 E2 00 10 A0 E3 ?? ?? ?? ?? 00 40 A0 E1 04 00 A0 E1 F0 85 BD E8 01 00 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 04 00 A0 E1 F0 85 BD E8 01 00 A0 E1 F0 45 BD E8 ?? ?? ?? ?? 00 70 60 E2 01 A0 07 E2 8A A0 A0 E1 01 A0 6A E2 C7 FF FF EA 00 00 A0 E3 00 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 EB FF FF EA 06 00 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 E2 FF FF EA }
	condition:
		$1
}

rule file_83_1_1 {
	meta:
		name = "__ieee754_jnf"
		size = 980
		refs = "004c fabsf 0080 __addsf3 008c __floatsisf 009c __gesf2 00c0 __mulsf3 0118 __ieee754_j0f 0128 __ieee754_j1f 013c __divsf3 0174 __subsf3 0180 __ltsf2 022c __ieee754_logf 02b0 __gtsf2"
	strings:
		$1 = { F0 4F 2D E9 7F 34 A0 E3 02 35 83 E2 02 71 C1 E3 03 00 57 E1 08 D0 4D E2 01 20 A0 E1 01 60 A0 E1 00 40 A0 E1 14 00 00 CA 00 00 50 E3 02 21 81 B2 00 40 60 B2 02 61 81 B2 00 00 00 BA 32 00 00 0A 01 00 54 E3 34 00 00 0A 02 00 A0 E1 ?? ?? ?? ?? 7F 34 A0 E3 02 35 83 E2 00 00 57 E3 03 00 57 11 00 50 A0 E1 07 00 00 1A 00 00 A0 E3 A6 4F 14 E0 02 01 80 12 08 D0 8D E2 F0 8F BD E8 01 00 A0 E1 ?? ?? ?? ?? FA FF FF EA 04 00 A0 E1 ?? ?? ?? ?? 04 00 8D E5 04 10 9D E5 05 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 98 00 00 AA C2 05 57 E3 1E 00 00 AA 21 00 54 E3 EB FF FF CA 05 00 A0 E1 3F 14 A0 E3 ?? ?? ?? ?? FE 75 A0 E3 00 A0 A0 E1 00 80 A0 E1 02 50 A0 E3 05 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 0A 10 A0 E1 00 70 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 01 50 85 E2 04 00 55 E1 00 80 A0 E1 F2 FF FF DA 7C 00 00 EA 02 00 A0 E1 08 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 02 00 A0 E1 08 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 84 B0 A0 E1 0B 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 00 90 A0 E1 01 01 A0 E3 ?? ?? ?? ?? 00 00 8D E5 00 10 9D E5 09 00 A0 E1 ?? ?? ?? ?? 00 A0 A0 E1 0A 10 A0 E1 09 00 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 4C 12 9F E5 00 70 A0 E1 ?? ?? ?? ?? 00 00 50 E3 01 80 A0 A3 0F 00 00 AA 01 80 A0 E3 0A 00 A0 E1 00 10 9D E5 ?? ?? ?? ?? 07 10 A0 E1 00 A0 A0 E1 ?? ?? ?? ?? 09 10 A0 E1 ?? ?? ?? ?? 10 12 9F E5 07 90 A0 E1 00 70 A0 E1 ?? ?? ?? ?? 00 00 50 E3 01 80 88 E2 F0 FF FF BA 04 80 88 E0 88 80 A0 E1 08 00 5B E1 00 A0 A0 C3 0D 00 00 CA 00 A0 A0 E3 08 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 0A 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 FE 05 A0 E3 ?? ?? ?? ?? 02 80 48 E2 08 00 5B E1 00 A0 A0 E1 F2 FF FF DA 00 10 9D E5 04 00 9D E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 10 A0 E1 04 00 9D E5 ?? ?? ?? ?? 8C 11 9F E5 ?? ?? ?? ?? 00 00 50 E3 46 00 00 BA 01 00 44 E2 80 00 A0 E1 00 A0 8D E5 ?? ?? ?? ?? FE B5 A0 E3 04 90 A0 E1 00 80 A0 E1 00 00 00 EA 07 B0 A0 E1 08 10 A0 E1 0B 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 00 10 9D E5 ?? ?? ?? ?? 01 11 A0 E3 00 70 A0 E1 08 00 A0 E1 ?? ?? ?? ?? BE 1F A0 E3 15 12 81 E2 00 80 A0 E1 15 18 81 E2 07 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 00 B0 8D D5 08 00 00 DA 07 10 A0 E1 0B 00 A0 E1 ?? ?? ?? ?? 07 10 A0 E1 00 00 8D E5 0A 00 A0 E1 ?? ?? ?? ?? FE 75 A0 E3 00 A0 A0 E1 01 90 49 E2 01 00 59 E3 DE FF FF 1A 05 00 A0 E1 ?? ?? ?? ?? 0A 10 A0 E1 ?? ?? ?? ?? 07 10 A0 E1 ?? ?? ?? ?? 57 FF FF EA 05 00 A0 E1 ?? ?? ?? ?? 00 A0 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 01 70 A0 E3 00 80 A0 E1 00 00 00 EA 03 80 A0 E1 87 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 08 10 A0 E1 ?? ?? ?? ?? 0A 10 A0 E1 ?? ?? ?? ?? 01 70 87 E2 04 00 57 E1 00 30 A0 E1 08 A0 A0 E1 F1 FF FF BA 40 FF FF EA 01 00 44 E2 80 00 A0 E1 00 A0 8D E5 ?? ?? ?? ?? FE 75 A0 E3 04 90 A0 E1 00 80 A0 E1 08 10 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 00 10 9D E5 ?? ?? ?? ?? 01 11 A0 E3 00 B0 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 01 90 49 E2 01 00 59 E3 00 70 8D E5 00 80 A0 E1 0B 70 A0 E1 EE FF FF 1A C8 FF FF EA 28 6B 6E 4E 80 71 B1 42 }
	condition:
		$1
}

rule file_85_0_1 {
	meta:
		name = "nextafterf"
		size = 240
		refs = "002c __eqsf2 0080 __mulsf3 0088 __nesf2 00a0 __addsf3"
	strings:
		$1 = { 7F 34 A0 E3 F0 40 2D E9 02 35 83 E2 02 71 C0 E3 02 21 C1 E3 03 00 57 E1 03 00 52 D1 00 40 A0 E1 00 50 A0 E1 01 60 A0 E1 1C 00 00 CA ?? ?? ?? ?? 00 00 50 E3 15 00 00 0A 00 00 57 E3 1B 00 00 0A 00 00 54 E3 24 00 00 BA 06 00 54 E1 25 00 00 CA 01 50 85 E2 02 31 C5 E3 A3 3B A0 E1 7F 24 A0 E3 02 25 82 E2 83 3B A0 E1 02 00 53 E1 09 00 00 0A 02 05 53 E3 04 00 00 AA 04 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 05 40 A0 E1 04 00 A0 E1 F0 80 BD E8 04 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 04 00 A0 E1 F0 80 BD E8 02 41 06 E2 01 40 84 E3 04 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 00 50 A0 E1 ?? ?? ?? ?? 00 00 50 E3 05 40 A0 01 EC FF FF EA 06 00 54 E1 00 00 56 D3 D9 FF FF BA 01 50 45 E2 D8 FF FF EA }
	condition:
		$1
}

rule file_86_0_1 {
	meta:
		name = "asinhf"
		size = 332
		refs = "002c __addsf3 0034 __gtsf2 0048 __mulsf3 0054 fabsf 0068 __ieee754_sqrtf 007c __divsf3 008c log1pf 0114 __ieee754_logf"
	strings:
		$1 = { 02 31 E0 E3 02 35 43 E2 02 21 C0 E3 03 00 52 E1 F0 40 2D E9 00 40 A0 E1 00 50 A0 E1 3E 00 00 CA C6 05 52 E3 1E 00 00 AA 14 11 9F E5 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 00 00 50 E3 16 00 00 CA 04 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 60 A0 E1 04 00 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 00 40 A0 E1 06 00 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 55 E3 00 40 A0 C1 02 41 80 D2 04 00 A0 E1 F0 80 BD E8 4D 34 A0 E3 02 35 83 E2 03 00 52 E1 1E 00 00 CA 01 01 52 E3 E0 FF FF DA ?? ?? ?? ?? 04 10 A0 E1 00 60 A0 E1 04 00 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? ?? ?? ?? ?? 06 10 A0 E1 00 70 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 07 10 A0 E1 00 40 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 FE 05 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? DC FF FF EA 00 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 04 00 A0 E1 F0 80 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? 08 10 9F E5 ?? ?? ?? ?? D2 FF FF EA CA F2 49 71 18 72 31 3F }
	condition:
		$1
}

rule file_87_0_1 {
	meta:
		name = "ilogbf"
		size = 88
	strings:
		$1 = { 02 01 D0 E3 06 01 A0 03 1E FF 2F 01 02 05 50 E3 06 00 00 BA 02 31 E0 E3 02 35 43 E2 03 00 50 E1 C0 0B A0 D1 02 01 E0 C3 7F 00 40 D2 1E FF 2F E1 00 34 A0 E1 00 00 53 E3 7D 00 E0 D3 1E FF 2F D1 7D 00 E0 E3 83 30 A0 E1 00 00 53 E3 01 00 40 E2 FB FF FF CA 1E FF 2F E1 }
	condition:
		$1
}

rule file_89_0_1 {
	meta:
		name = "cos"
		size = 288
		refs = "004c __subdf3 006c __ieee754_rem_pio2 0098 __kernel_cos 00ec __kernel_sin"
	strings:
		$1 = { F0 48 2D E9 5B 39 E0 E3 1E 3C 43 E2 02 C1 C0 E3 13 31 43 E2 03 00 5C E1 14 D0 4D E2 00 40 A0 E1 01 50 A0 E1 00 60 A0 E1 00 B0 A0 E1 00 70 A0 E1 1C 00 00 DA 02 31 E0 E3 01 36 43 E2 03 00 5C E1 08 00 00 DA 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 00 30 A0 E1 01 20 A0 E1 03 00 A0 E1 02 10 A0 E1 14 D0 8D E2 F0 88 BD E8 04 20 8D E2 ?? ?? ?? ?? 03 C0 00 E2 01 00 5C E3 17 00 00 0A 02 00 5C E3 0E 00 00 0A 00 00 5C E3 1B 00 00 1A 0C 30 8D E2 0C 00 93 E8 03 00 9D E9 ?? ?? ?? ?? 00 30 A0 E1 01 20 A0 E1 EB FF FF EA 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 30 A0 E1 01 20 A0 E1 E5 FF FF EA 0C 30 8D E2 0C 00 93 E8 03 00 9D E9 ?? ?? ?? ?? 02 31 80 E2 01 20 A0 E1 DE FF FF EA 0C 30 8D E2 0C 00 93 E8 03 00 9D E9 00 C0 8D E5 ?? ?? ?? ?? 02 31 80 E2 01 20 A0 E1 D6 FF FF EA 0C 30 8D E2 0C 00 93 E8 01 C0 A0 E3 03 00 9D E9 00 C0 8D E5 ?? ?? ?? ?? 00 30 A0 E1 01 20 A0 E1 CD FF FF EA }
	condition:
		$1
}

rule file_90_0_1 {
	meta:
		name = "tan"
		size = 156
		refs = "004c __subdf3 005c __ieee754_rem_pio2 007c __kernel_tan"
	strings:
		$1 = { F0 48 2D E9 5B 39 E0 E3 1E 3C 43 E2 02 C1 C0 E3 13 31 43 E2 03 00 5C E1 14 D0 4D E2 00 40 A0 E1 01 50 A0 E1 00 60 A0 E1 00 B0 A0 E1 00 70 A0 E1 13 00 00 DA 02 31 E0 E3 01 36 43 E2 03 00 5C E1 04 00 00 DA 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 14 D0 8D E2 F0 88 BD E8 04 20 8D E2 ?? ?? ?? ?? 01 C0 00 E2 8C C0 A0 E1 01 C0 6C E2 03 00 9D E9 0C 30 8D E2 0C 00 93 E8 00 C0 8D E5 ?? ?? ?? ?? F2 FF FF EA 01 C0 A0 E3 00 20 A0 E3 00 30 A0 E3 00 C0 8D E5 ?? ?? ?? ?? EC FF FF EA }
	condition:
		$1
}

rule file_91_0_1 {
	meta:
		name = "roundf"
		size = 128
		refs = "005c __addsf3"
	strings:
		$1 = { 02 31 C0 E3 A3 3B A0 E1 83 3B A0 E1 A3 3B A0 E1 7F 30 43 E2 16 00 53 E3 04 E0 2D E5 00 10 A0 E1 00 20 A0 E1 0A 00 00 CA 00 00 53 E3 0E 00 00 BA 02 05 A0 E3 01 00 40 E2 50 03 A0 E1 01 00 10 E1 01 15 A0 13 51 13 82 10 00 10 C1 11 01 00 A0 E1 04 F0 9D E4 80 00 53 E3 FB FF FF 1A ?? ?? ?? ?? 00 10 A0 E1 01 00 A0 E1 04 F0 9D E4 02 11 00 E2 01 00 73 E3 FE 15 81 03 01 00 A0 E1 04 F0 9D E4 }
	condition:
		$1
}

rule file_92_0_1 {
	meta:
		name = "__ieee754_yn"
		size = 856
		refs = "00ac sin 00c0 cos 00d4 __subdf3 00e8 __ieee754_sqrt 0104 __muldf3 0110 __divdf3 016c __adddf3 018c __ieee754_y0 01e4 __ieee754_y1 021c __floatsidf"
	strings:
		$1 = { F0 4F 2D E9 00 40 62 E2 01 80 A0 E1 02 40 84 E1 02 11 C1 E3 7F 34 A0 E3 A4 4F 81 E1 0F 36 83 E2 03 00 54 E1 14 D0 4D E2 02 90 A0 E1 00 60 A0 E1 49 00 00 8A 02 20 91 E1 3B 00 00 0A 00 00 58 E3 58 00 00 BA 00 00 50 E3 50 00 00 BA 01 30 A0 13 08 30 8D 15 48 00 00 0A 01 00 56 E3 AE 00 00 0A 7F 34 A0 E3 0F 36 83 E2 03 00 51 E1 00 40 A0 03 04 50 A0 01 34 00 00 0A AD 34 E0 E3 03 36 43 E2 03 00 51 E1 4F 00 00 DA 03 60 06 E2 02 00 56 E3 98 00 00 0A 03 00 56 E3 86 00 00 0A 01 00 56 E3 74 00 00 0A 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 60 A0 E1 01 70 A0 E1 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 97 3F 8F E2 0C 00 93 E8 00 40 A0 E1 01 50 A0 E1 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 08 30 9D E5 00 00 53 E3 02 41 84 D2 07 00 00 EA BF 04 A0 E3 0F 06 80 E2 00 10 A0 E3 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 04 00 A0 E1 05 10 A0 E1 14 D0 8D E2 F0 8F BD E8 08 00 A0 E1 09 10 A0 E1 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 F3 FF FF EA 08 00 A0 E1 09 10 A0 E1 14 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 00 60 60 E2 01 30 06 E2 83 30 A0 E1 01 30 63 E2 08 30 8D E5 AB FF FF EA 00 00 A0 E3 00 10 A0 E3 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 E0 FF FF EA 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 00 B0 A0 E1 01 A0 A0 E1 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 01 06 70 E3 00 40 A0 E1 01 50 A0 E1 C8 FF FF 0A 00 03 8D E8 01 70 A0 E3 06 90 A0 E1 00 80 A0 E1 01 60 A0 E1 01 00 00 EA 00 80 A0 E1 01 60 A0 E1 87 00 A0 E1 ?? ?? ?? ?? 0C 00 9D E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 0B 20 A0 E1 0A 30 A0 E1 ?? ?? ?? ?? 01 30 A0 E1 00 20 A0 E1 0C 20 8D E5 10 30 8D E5 0C 30 9D E5 01 70 87 E2 01 06 73 E3 09 00 57 11 00 40 A0 E1 01 50 A0 E1 08 B0 A0 E1 06 A0 A0 E1 E6 FF FF BA A8 FF FF EA 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 00 50 A0 E1 01 40 A0 E1 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 02 01 85 E2 04 10 A0 E1 ?? ?? ?? ?? 00 60 A0 E1 01 70 A0 E1 89 FF FF EA 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 60 A0 E1 01 70 A0 E1 79 FF FF EA 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 69 FF FF EA 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 08 00 9D E5 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 7E FF FF EA D7 0D E2 3F 6D 9B 42 50 }
	condition:
		$1
}

rule file_92_1_1 {
	meta:
		name = "__ieee754_jn"
		size = 1984
		refs = "0064 fabs 00d0 __adddf3 00dc __floatsidf 00f8 __gedf2 0138 cos 014c sin 0174 __ieee754_sqrt 0190 __muldf3 019c __divdf3 01b8 __ieee754_j0 0274 __ieee754_j1 02fc __subdf3 0310 __ltdf2 045c __ieee754_log 06f0 __gtdf2"
	strings:
		$1 = { F0 4F 2D E9 00 C0 62 E2 02 C0 8C E1 02 61 C1 E3 7F 34 A0 E3 AC CF 86 E1 0F 36 83 E2 03 00 5C E1 2C D0 4D E2 01 50 A0 E1 02 70 A0 E1 00 40 A0 E1 1F 00 00 8A 00 00 50 E3 00 40 60 B2 02 11 81 B2 02 51 85 B2 00 00 00 BA 55 00 00 0A 01 00 54 E3 82 00 00 0A 01 00 A0 E1 01 80 A0 E1 02 10 A0 E1 02 90 A0 E1 ?? ?? ?? ?? 07 70 96 E1 02 31 E0 E3 00 20 A0 13 01 20 A0 03 01 36 43 E2 03 00 56 E1 02 30 A0 D1 01 30 82 C3 00 00 53 E3 00 A0 A0 E1 01 B0 A0 E1 0F 00 00 0A 00 00 A0 E3 00 10 A0 E1 A5 4F 14 E0 02 01 80 12 01 40 A0 E1 2C D0 8D E2 F0 8F BD E8 01 30 A0 E1 01 50 A0 E1 02 60 A0 E1 01 00 A0 E1 02 10 A0 E1 03 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? F3 FF FF EA 04 00 A0 E1 ?? ?? ?? ?? 0C 00 8D E5 10 10 8D E5 0C 30 8D E2 0C 00 93 E8 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 2D 00 00 BA AD 34 E0 E3 03 36 43 E2 03 00 56 E1 20 01 00 DA 03 30 04 E2 02 00 53 E3 0D 01 00 0A 03 00 53 E3 95 01 00 0A 01 00 53 E3 83 01 00 0A 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 00 60 A0 E1 01 70 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 00 80 A0 E1 01 90 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? F8 30 8F E2 0C 00 93 E8 00 60 A0 E1 01 70 A0 E1 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? BE FF FF EA 01 00 A0 E1 02 40 A0 E1 02 10 A0 E1 2C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? C1 34 E0 E3 0F 36 43 E2 03 00 56 E1 2F 00 00 CA 21 00 54 E3 B0 FF FF CA FF 25 A0 E3 0A 00 A0 E1 0B 10 A0 E1 02 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 03 00 8D E9 FF 75 A0 E3 00 A0 A0 E1 01 B0 A0 E1 03 76 87 E2 00 80 A0 E3 02 60 A0 E3 06 00 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 0C 00 9D E9 00 70 A0 E1 01 80 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 01 60 86 E2 04 00 56 E1 00 A0 A0 E1 01 B0 A0 E1 ED FF FF DA 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? 8F FF FF EA 01 00 A0 E1 02 40 A0 E1 02 10 A0 E1 2C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? D7 0D E2 3F 6D 9B 42 50 65 CD CD 41 42 2E 86 40 EF 39 FA FE 84 90 A0 E1 09 00 A0 E1 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? 0A 20 A0 E1 14 00 8D E5 18 10 8D E5 0B 30 A0 E1 01 01 A0 E3 00 10 A0 E3 ?? ?? ?? ?? 03 00 8D E9 0C 00 9D E9 14 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 1C 00 8D E5 20 10 8D E5 1C 30 8D E2 0C 00 93 E8 14 10 8D E2 03 00 91 E8 ?? ?? ?? ?? FF 25 A0 E3 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 88 20 1F E5 00 30 A0 E3 00 70 A0 E1 01 80 A0 E1 ?? ?? ?? ?? 00 00 50 E3 01 60 A0 A3 26 00 00 AA 14 30 8D E2 0C 00 93 E8 24 50 8D E5 28 90 8D E5 04 90 A0 E1 1C 50 8D E2 30 00 95 E8 14 A0 8D E5 18 B0 8D E5 01 60 A0 E3 02 A0 A0 E1 03 B0 A0 E1 0C 00 9D E9 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 07 20 A0 E1 08 30 A0 E1 00 40 A0 E1 01 50 A0 E1 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? 08 21 1F E5 00 30 A0 E3 07 A0 A0 E1 08 B0 A0 E1 00 70 A0 E1 01 80 A0 E1 ?? ?? ?? ?? 00 00 50 E3 01 60 86 E2 E9 FF FF BA 09 40 A0 E1 14 B0 8D E2 00 0C 9B E8 24 50 8D E2 20 02 95 E8 04 60 86 E0 86 60 A0 E1 06 00 59 E1 F5 00 00 CA 00 20 A0 E3 00 30 A0 E3 14 20 8D E5 18 30 8D E5 05 80 A0 E1 04 70 A0 E1 03 50 A0 E1 02 40 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 FF 05 A0 E3 01 30 A0 E1 03 06 80 E2 00 10 A0 E3 ?? ?? ?? ?? 02 60 46 E2 06 00 59 E1 00 40 A0 E1 01 50 A0 E1 EC FF FF DA 14 40 8D E5 18 50 8D E5 08 50 A0 E1 07 40 A0 E1 0C 00 9D E9 0C 10 8D E2 03 00 91 E8 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 0C 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 7E 3F 4F E2 0C 00 93 E8 ?? ?? ?? ?? 00 00 50 E3 69 00 00 AA 14 30 8D E2 0C 00 93 E8 01 00 44 E2 80 00 A0 E1 0C 00 8D E9 ?? ?? ?? ?? FF 75 A0 E3 1C 50 8D E5 0C A0 8D E5 10 B0 8D E5 04 60 A0 E1 03 76 87 E2 00 80 A0 E3 00 A0 A0 E1 01 B0 A0 E1 04 90 A0 E1 0A 20 A0 E1 0B 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 0C 30 8D E2 0C 00 93 E8 ?? ?? ?? ?? 0C 00 9D E9 ?? ?? ?? ?? 01 21 A0 E3 00 40 A0 E1 01 50 A0 E1 0A 00 A0 E1 0B 10 A0 E1 00 30 A0 E3 ?? ?? ?? ?? 01 60 46 E2 01 00 56 E3 80 01 8D E9 00 A0 A0 E1 01 B0 A0 E1 04 70 A0 E1 05 80 A0 E1 E6 FF FF 1A 0C B0 8D E2 00 0C 9B E8 0A 00 A0 E1 0B 10 A0 E1 1C 50 9D E5 ?? ?? ?? ?? 14 30 8D E2 0C 00 93 E8 09 40 A0 E1 ?? ?? ?? ?? 3D FF FF EA 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 00 70 A0 E1 01 60 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 02 01 87 E2 06 10 A0 E1 ?? ?? ?? ?? 00 80 A0 E1 01 90 A0 E1 F4 FE FF EA 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 01 30 A0 E1 00 90 A0 E1 0B 10 A0 E1 0A 00 A0 E1 00 30 8D E5 ?? ?? ?? ?? 00 30 9D E5 04 50 8D E5 01 60 A0 E3 04 50 A0 E1 00 70 A0 E1 01 80 A0 E1 03 40 A0 E1 01 00 00 EA 00 70 A0 E1 01 80 A0 E1 86 00 A0 E1 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? 01 60 86 E2 09 20 A0 E1 04 30 A0 E1 ?? ?? ?? ?? 05 00 56 E1 07 90 A0 E1 08 40 A0 E1 ED FF FF BA 05 40 A0 E1 04 50 9D E5 9B FE FF EA 01 00 44 E2 14 30 8D E2 0C 00 93 E8 80 00 A0 E1 0C 00 8D E9 ?? ?? ?? ?? FF 75 A0 E3 03 76 87 E2 00 80 A0 E3 0C A0 8D E5 10 B0 8D E5 04 60 A0 E1 1C 50 8D E5 04 90 A0 E1 07 A0 A0 E1 08 B0 A0 E1 00 40 A0 E1 01 50 A0 E1 05 00 00 EA 00 0C 8D E9 01 60 46 E2 01 00 56 E3 A7 FF FF 0A 07 A0 A0 E1 08 B0 A0 E1 04 20 A0 E1 05 30 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 0C 30 8D E2 0C 00 93 E8 ?? ?? ?? ?? 0C 00 9D E9 ?? ?? ?? ?? 01 21 A0 E3 00 70 A0 E1 01 80 A0 E1 04 00 A0 E1 05 10 A0 E1 00 30 A0 E3 ?? ?? ?? ?? D8 30 8F E2 0C 00 93 E8 00 40 A0 E1 01 50 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 DF FF FF DA 07 20 A0 E1 08 30 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 07 20 A0 E1 03 00 8D E9 08 30 A0 E1 14 10 8D E2 03 00 91 E8 ?? ?? ?? ?? FF 75 A0 E3 03 76 87 E2 00 80 A0 E3 14 00 8D E5 18 10 8D E5 CF FF FF EA 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 00 60 A0 E1 01 70 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 00 80 A0 E1 01 90 A0 E1 7A FE FF EA 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 00 60 A0 E1 01 70 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? EE FF FF EA 00 20 A0 E3 00 30 A0 E3 14 20 8D E5 18 30 8D E5 23 FF FF EA AD 49 B2 54 7D C3 94 25 }
	condition:
		$1
}

rule file_93_0_1 {
	meta:
		name = "acosh"
		size = 264
		refs = "0010 __ieee754_acosh 0034 __isnand 0054 __ltdf2 0094 __divdf3 00b0 matherr 00e0 __errno 0100 __fdlib_version"
	strings:
		$1 = { F0 45 2D E9 24 D0 4D E2 00 40 A0 E1 01 50 A0 E1 ?? ?? ?? ?? E4 60 9F E5 00 30 96 E5 01 00 73 E3 00 70 A0 E1 01 80 A0 E1 28 00 00 0A 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 A0 50 E2 23 00 00 1A FF 25 A0 E3 04 00 A0 E1 05 10 A0 E1 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 1B 00 00 AA 01 C0 A0 E3 00 00 A0 E3 00 10 A0 E3 00 C0 8D E5 8C C0 9F E5 01 30 A0 E1 00 20 A0 E1 04 C0 8D E5 20 A0 8D E5 08 40 8D E5 0C 50 8D E5 10 40 8D E5 14 50 8D E5 ?? ?? ?? ?? 00 30 96 E5 02 00 53 E3 18 00 8D E5 1C 10 8D E5 0C 00 00 0A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 08 00 00 0A 20 30 9D E5 00 00 53 E3 09 00 00 1A 18 80 8D E2 80 01 98 E8 07 00 A0 E1 08 10 A0 E1 24 D0 8D E2 F0 85 BD E8 ?? ?? ?? ?? 21 30 A0 E3 00 30 80 E5 F2 FF FF EA ?? ?? ?? ?? 20 30 9D E5 00 30 80 E5 F1 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_94_0_1 {
	meta:
		name = "__fpclassifyd"
		size = 140
	strings:
		$1 = { 04 40 2D E5 01 40 A0 E1 00 10 94 E1 00 30 A0 E1 1A 00 00 0A 01 00 74 E2 00 00 A0 33 02 01 53 E3 00 00 54 03 15 00 00 0A 7F 14 83 E2 02 21 E0 E3 02 26 42 E2 0F 16 81 E2 01 C6 43 E2 02 00 5C E1 02 00 51 81 7F 24 A0 E3 0F 26 82 E2 04 00 A0 93 0B 00 00 9A 02 11 83 E2 01 06 53 E3 01 06 51 23 03 00 A0 33 06 00 00 3A 01 06 73 E3 02 00 53 11 00 30 A0 13 01 30 A0 03 03 00 00 E0 00 00 00 EA 02 00 A0 E3 10 00 BD E8 1E FF 2F E1 }
	condition:
		$1
}

rule file_95_0_1 {
	meta:
		name = "__ieee754_fmodf"
		size = 428
		refs = "0188 __mulsf3 0190 __divsf3"
	strings:
		$1 = { 30 40 2D E9 02 21 E0 E3 02 51 D1 E3 02 41 00 E2 00 C0 A0 13 01 C0 A0 03 00 30 24 E0 02 25 42 E2 02 00 53 E1 0C 20 A0 D1 01 20 8C C3 00 00 52 E3 54 00 00 1A 7F 24 A0 E3 02 25 82 E2 02 00 55 E1 50 00 00 CA 05 00 53 E1 30 80 BD B8 51 00 00 0A 02 05 53 E3 C3 2B A0 A1 7F 20 42 A2 08 00 00 AA 03 14 A0 E1 00 00 51 E3 7D 20 E0 D3 04 00 00 DA 7D 20 E0 E3 81 10 A0 E1 00 00 51 E3 01 20 42 E2 FB FF FF CA 02 05 55 E3 C5 CB A0 A1 7F C0 4C A2 06 00 00 AA 05 14 B0 E1 7D C0 E0 43 03 00 00 4A 7D C0 E0 E3 81 10 B0 E1 01 C0 4C E2 FC FF FF 5A 7E 00 72 E3 FF 04 62 B2 FF 08 80 B2 FF 0C 80 B2 FF 34 C3 A3 82 00 80 B2 02 35 C3 A3 13 30 A0 B1 02 35 83 A3 7E 00 7C E3 FF 04 6C B2 FF 08 80 B2 FF 0C 80 B2 82 00 80 B2 15 00 A0 B1 FF 04 C5 A3 02 05 C0 A3 02 20 6C E0 02 05 80 A3 00 00 52 E3 03 10 60 E0 08 00 00 0A 00 00 51 E3 83 30 A0 B1 01 00 00 BA 1F 00 00 0A 81 30 A0 E1 01 20 42 E2 00 00 52 E3 03 10 60 E0 F6 FF FF 1A 00 00 53 E0 00 30 A0 51 00 00 53 E3 16 00 00 0A 02 25 A0 E3 01 20 42 E2 02 00 53 E1 03 00 00 CA 83 30 A0 E1 02 00 53 E1 01 C0 4C E2 FB FF FF DA 7E 00 7C E3 FF 04 6C B2 FF 08 80 B2 FF 0C 80 B2 02 35 43 A2 04 40 83 A1 7F 00 8C A2 82 00 80 B2 80 0B 84 A1 53 00 84 B1 30 80 BD E8 ?? ?? ?? ?? 00 10 A0 E1 ?? ?? ?? ?? 30 80 BD E8 08 30 9F E5 A4 4F A0 E1 04 01 93 E7 30 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_96_0_1 {
	meta:
		name = "__ieee754_cosh"
		size = 604
		refs = "00a8 __muldf3 00e0 fabs 00e4 expm1 00fc __adddf3 0150 __divdf3 018c __ieee754_exp"
	strings:
		$1 = { 02 31 E0 E3 F0 41 2D E9 03 40 00 E0 01 36 43 E2 03 00 54 E1 00 50 A0 E1 01 60 A0 E1 00 70 A0 E1 01 80 A0 E1 25 00 00 CA A7 39 E0 E3 46 3D 43 E2 F7 31 43 E2 03 00 54 E1 28 00 00 DA BF 34 E0 E3 CA 38 43 E2 03 00 54 E1 60 00 00 DA 86 38 A0 E3 B9 3D 83 E2 05 31 83 E2 03 00 54 E1 73 00 00 DA 86 38 A0 E3 CF 3D 83 E2 35 31 83 E2 03 00 54 E1 3E 00 00 DA 86 28 A0 E3 27 32 E0 E3 CF 2D 82 E2 46 38 43 E2 39 21 82 E2 1E 3D 43 E2 03 00 51 E1 02 00 54 91 35 00 00 0A 6D 1F 8F E2 03 00 91 E8 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 00 50 A0 E1 01 60 A0 E1 05 00 A0 E1 06 10 A0 E1 F0 81 BD E8 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 00 50 A0 E1 01 60 A0 E1 05 00 A0 E1 06 10 A0 E1 F0 81 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? FF 25 A0 E3 03 26 82 E2 00 30 A0 E3 00 70 A0 E1 01 80 A0 E1 ?? ?? ?? ?? F2 05 54 E3 00 50 A0 E1 01 60 A0 E1 F0 FF FF BA 07 20 A0 E1 08 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 00 70 A0 E1 01 80 A0 E1 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? FF 25 A0 E3 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 50 A0 E1 01 60 A0 E1 D8 FF FF EA 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? FF 25 A0 E3 02 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? ?? ?? ?? ?? FF 25 A0 E3 02 26 82 E2 00 30 A0 E3 00 40 A0 E1 01 50 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 50 A0 E1 01 60 A0 E1 05 00 A0 E1 06 10 A0 E1 F0 81 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? FF 25 A0 E3 02 26 82 E2 00 30 A0 E3 00 70 A0 E1 01 80 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 FF 05 A0 E3 01 50 A0 E1 07 20 A0 E1 08 30 A0 E1 02 06 80 E2 00 10 A0 E3 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 50 A0 E1 01 60 A0 E1 A8 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? FF 25 A0 E3 02 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 50 A0 E1 01 60 A0 E1 9F FF FF EA 3C E4 37 7E 9C 75 00 88 }
	condition:
		$1
}

rule file_97_0_1 {
	meta:
		name = "atanhf"
		size = 340
		refs = "000c __ieee754_atanhf 0028 isnanf 0044 fabsf 0050 __gesf2 0064 __gtsf2 0088 __extendsfdf2 00b4 __divdf3 00d0 matherr 00f0 __truncdfsf2 012c __errno 014c __fdlib_version"
	strings:
		$1 = { F0 48 2D E9 24 D0 4D E2 00 50 A0 E1 ?? ?? ?? ?? 34 41 9F E5 00 30 94 E5 01 00 73 E3 00 B0 A0 E1 03 00 00 0A 05 00 A0 E1 ?? ?? ?? ?? 00 60 50 E2 02 00 00 0A 0B 00 A0 E1 24 D0 8D E2 F0 88 BD E8 05 00 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 00 70 A0 E1 ?? ?? ?? ?? 00 00 50 E3 F5 FF FF BA 07 00 A0 E1 FE 15 A0 E3 ?? ?? ?? ?? 00 00 50 E3 22 00 00 DA 01 30 A0 E3 00 30 8D E5 D0 30 9F E5 05 00 A0 E1 04 30 8D E5 20 60 8D E5 ?? ?? ?? ?? 00 B0 A0 E1 01 C0 A0 E1 00 00 A0 E3 00 10 A0 E3 00 20 A0 E1 01 30 A0 E1 08 B0 8D E5 0C C0 8D E5 10 B0 8D E5 14 C0 8D E5 ?? ?? ?? ?? 00 30 94 E5 02 00 53 E3 18 00 8D E5 1C 10 8D E5 17 00 00 0A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 13 00 00 0A 20 30 9D E5 00 00 53 E3 14 00 00 1A 18 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 B0 A0 E1 CD FF FF EA 02 30 A0 E3 00 30 8D E5 44 30 9F E5 05 00 A0 E1 04 30 8D E5 20 60 8D E5 ?? ?? ?? ?? 00 20 A0 E3 00 B0 A0 E1 01 C0 A0 E1 00 30 A0 E3 DD FF FF EA ?? ?? ?? ?? 21 30 A0 E3 00 30 80 E5 E7 FF FF EA ?? ?? ?? ?? 20 30 9D E5 00 30 80 E5 E6 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_98_0_1 {
	meta:
		name = "sqrtf"
		size = 276
		refs = "000c __ieee754_sqrtf 0028 isnanf 003c __ltsf2 0060 __extendsfdf2 0090 __divdf3 00a4 __errno 00c4 __truncdfsf2 00ec matherr 010c __fdlib_version"
	strings:
		$1 = { F0 40 2D E9 24 D0 4D E2 00 60 A0 E1 ?? ?? ?? ?? F4 50 9F E5 00 30 95 E5 01 00 73 E3 00 40 A0 E1 29 00 00 0A 06 00 A0 E1 ?? ?? ?? ?? 00 70 50 E2 25 00 00 1A 06 00 A0 E1 00 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 20 00 00 AA 01 30 A0 E3 00 30 8D E5 B8 30 9F E5 06 00 A0 E1 04 30 8D E5 20 70 8D E5 ?? ?? ?? ?? 00 40 95 E5 00 00 54 E3 08 00 8D E5 0C 10 8D E5 10 00 8D E5 14 10 8D E5 15 00 00 0A 00 00 A0 E3 00 10 A0 E3 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 02 00 54 E3 18 00 8D E5 1C 10 8D E5 10 00 00 1A ?? ?? ?? ?? 21 30 A0 E3 00 30 80 E5 20 30 9D E5 00 00 53 E3 0F 00 00 1A 18 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 40 A0 E1 04 00 A0 E1 24 D0 8D E2 F0 80 BD E8 00 30 A0 E3 00 40 A0 E3 18 30 8D E5 1C 40 8D E5 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 ED FF FF 1A E9 FF FF EA ?? ?? ?? ?? 20 30 9D E5 00 30 80 E5 EB FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_102_0_1 {
	meta:
		name = "tanf"
		size = 116
		refs = "0034 __subsf3 0044 __ieee754_rem_pio2f 005c __kernel_tanf"
	strings:
		$1 = { 04 E0 2D E5 97 31 E0 E3 B6 38 43 E2 02 21 C0 E3 0F 3A 43 E2 03 00 52 E1 08 D0 4D E2 00 10 A0 E1 0F 00 00 DA 02 31 E0 E3 02 35 43 E2 03 00 52 E1 02 00 00 DA ?? ?? ?? ?? 08 D0 8D E2 00 80 BD E8 0D 10 A0 E1 ?? ?? ?? ?? 01 20 00 E2 82 20 A0 E1 01 20 62 E2 00 00 9D E5 04 10 9D E5 ?? ?? ?? ?? F4 FF FF EA 00 10 A0 E3 01 20 A0 E3 ?? ?? ?? ?? F0 FF FF EA }
	condition:
		$1
}

rule file_104_0_1 {
	meta:
		name = "remainder"
		size = 268
		refs = "0014 __ieee754_remainder 0038 __isnand 0054 __eqdf2 0098 __divdf3 00b4 matherr 00e4 __errno 0104 __fdlib_version"
	strings:
		$1 = { F0 45 2D E9 2C D0 4D E2 03 60 A0 E1 03 00 8D E8 02 50 A0 E1 ?? ?? ?? ?? E4 40 9F E5 00 30 94 E5 01 00 73 E3 00 70 A0 E1 01 80 A0 E1 28 00 00 0A 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 00 A0 50 E2 23 00 00 1A 05 00 A0 E1 06 10 A0 E1 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 1C 00 00 1A 01 C0 A0 E3 00 00 A0 E3 00 10 A0 E3 08 C0 8D E5 80 01 9D E8 8C C0 9F E5 01 30 A0 E1 00 20 A0 E1 0C C0 8D E5 28 A0 8D E5 10 70 8D E5 14 80 8D E5 18 50 8D E5 1C 60 8D E5 ?? ?? ?? ?? 00 30 94 E5 02 00 53 E3 20 00 8D E5 24 10 8D E5 0C 00 00 0A 08 00 8D E2 ?? ?? ?? ?? 00 00 50 E3 08 00 00 0A 28 30 9D E5 00 00 53 E3 09 00 00 1A 20 80 8D E2 80 01 98 E8 07 00 A0 E1 08 10 A0 E1 2C D0 8D E2 F0 85 BD E8 ?? ?? ?? ?? 21 30 A0 E3 00 30 80 E5 F2 FF FF EA ?? ?? ?? ?? 28 30 9D E5 00 30 80 E5 F1 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_105_0_1 {
	meta:
		name = "__fpclassifyf"
		size = 104
	strings:
		$1 = { 00 00 50 E3 02 01 50 13 02 00 A0 03 1E FF 2F 01 7F 34 80 E2 02 35 83 E2 02 25 40 E2 7F 04 52 E3 7F 04 53 23 7F 34 A0 E3 02 35 83 E2 04 00 A0 33 1E FF 2F 31 02 25 A0 E3 06 C1 40 E2 01 10 40 E2 02 20 42 E2 02 00 51 E1 02 00 5C 81 03 00 A0 93 1E FF 2F 91 02 05 70 E3 03 00 50 11 00 00 A0 13 01 00 A0 03 1E FF 2F E1 }
	condition:
		$1
}

rule file_106_0_1 {
	meta:
		name = "__ieee754_exp"
		size = 1100
		refs = "00a4 __adddf3 00b4 __gtdf2 0108 __ltdf2 0124 __muldf3 013c __fixdfsi 0144 __floatsidf 016c __subdf3 0294 __divdf3"
	strings:
		$1 = { F0 4D 2D E9 86 C8 A0 E3 B9 CD 8C E2 05 C1 8C E2 02 31 C0 E3 0C 00 53 E1 08 D0 4D E2 00 40 A0 E1 01 50 A0 E1 A0 7F A0 E1 11 00 00 9A 02 C1 E0 E3 01 C6 4C E2 0C 00 53 E1 29 00 00 9A FF 24 C0 E3 0F 26 C2 E3 01 20 92 E1 00 A0 A0 E1 01 B0 A0 E1 D8 00 00 1A 00 00 57 E3 01 00 00 0A 00 40 A0 E3 00 50 A0 E3 04 00 A0 E1 05 10 A0 E1 08 D0 8D E2 F0 8D BD E8 A7 29 E0 E3 46 2D 42 E2 F7 21 42 E2 02 00 53 E1 9E 00 00 8A C1 24 E0 E3 0D 26 42 E2 02 00 53 E1 00 60 A0 83 42 00 00 8A D3 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? FF 25 A0 E3 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 39 00 00 DA FF 25 A0 E3 04 00 A0 E1 05 10 A0 E1 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 DF FF FF EA C3 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 00 00 50 E3 B5 00 00 CA 04 00 A0 E1 05 10 A0 E1 BE 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 00 00 50 E3 D1 FF FF BA BB 3F 8F E2 0C 00 93 E8 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 18 33 9F E5 87 71 83 E0 20 30 87 E2 0C 00 93 E8 ?? ?? ?? ?? ?? ?? ?? ?? 00 60 A0 E1 ?? ?? ?? ?? 0B 3D 8F E2 0C 00 93 E8 00 70 A0 E1 01 80 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 2A 3E 8F E2 0C 00 93 E8 03 00 8D E8 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 A0 A0 E1 01 B0 A0 E1 03 00 9D E8 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 04 20 A0 E1 05 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 97 3F 8F E2 0C 00 93 E8 00 70 A0 E1 01 80 A0 E1 ?? ?? ?? ?? 25 3E 8F E2 0C 00 93 E8 ?? ?? ?? ?? 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? 09 3D 8F E2 0C 00 93 E8 ?? ?? ?? ?? 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? 23 3E 8F E2 0C 00 93 E8 ?? ?? ?? ?? 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? 22 3E 8F E2 0C 00 93 E8 ?? ?? ?? ?? 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 00 56 E3 00 70 A0 E1 01 80 A0 E1 3B 00 00 0A 04 00 A0 E1 05 10 A0 E1 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? 07 20 A0 E1 00 40 A0 E1 01 50 A0 E1 08 30 A0 E1 01 01 A0 E3 00 10 A0 E3 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 0C 00 9D E8 ?? ?? ?? ?? 00 20 A0 E1 FF 05 A0 E3 01 30 A0 E1 03 06 80 E2 00 10 A0 E3 ?? ?? ?? ?? FF 3F E0 E3 03 00 56 E1 01 50 A0 A1 06 4A 80 A0 60 FF FF AA FA 6F 86 E2 06 3A 80 E0 03 00 A0 E1 17 26 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 57 FF FF EA F5 2A E0 E3 35 2D 42 E2 3B 21 42 E2 02 00 53 E1 7E FF FF 8A 28 41 9F E5 87 41 84 E0 0C 00 94 E8 ?? ?? ?? ?? 00 60 67 E2 06 60 67 E0 03 00 8D E8 10 B0 84 E2 00 0C 9B E8 01 60 86 E2 92 FF FF EA 04 00 A0 E1 05 10 A0 E1 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? 01 21 A0 E3 00 A0 A0 E1 01 B0 A0 E1 00 30 A0 E3 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 FF 05 A0 E3 01 30 A0 E1 03 06 80 E2 00 10 A0 E3 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 2A FF FF EA 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 24 FF FF EA 18 10 8F E2 03 00 91 E8 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 1C FF FF EA 3C E4 37 7E 9C 75 00 88 42 2E 86 40 EF 39 FA FE 10 49 87 C0 51 30 2D D5 47 15 F7 3F FE 82 2B 65 42 2E E6 3F 00 00 E0 FE EF 39 EA 3D 76 3C 79 35 69 37 66 3E D0 A4 BE 72 41 BD BB 3E F1 6B D2 C5 6A 56 11 3F 2C DE 25 AF 6C C1 66 3F 93 BD BE 16 55 55 C5 3F 3E 55 55 55 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_108_0_1 {
	meta:
		name = "sqrt"
		size = 292
		refs = "0010 __ieee754_sqrt 0034 __isnand 005c __ltdf2 00ac __divdf3 00c0 __errno 00fc matherr 011c __fdlib_version"
	strings:
		$1 = { F0 4D 2D E9 28 D0 4D E2 00 40 A0 E1 01 50 A0 E1 ?? ?? ?? ?? 00 61 9F E5 00 30 96 E5 01 00 73 E3 00 70 A0 E1 01 80 A0 E1 2C 00 00 0A 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 A0 50 E2 27 00 00 1A 00 C0 A0 E3 00 B0 A0 E3 0C 30 A0 E1 04 00 A0 E1 05 10 A0 E1 0B 20 A0 E1 00 C0 8D E5 ?? ?? ?? ?? 00 00 50 E3 00 C0 9D E5 1C 00 00 AA 01 30 A0 E3 00 60 96 E5 04 30 8D E5 A0 30 9F E5 00 00 56 E3 08 30 8D E5 24 A0 8D E5 0C 40 8D E5 10 50 8D E5 14 40 8D E5 18 50 8D E5 14 00 00 0A 0B 00 A0 E1 0C 10 A0 E1 0B 20 A0 E1 0C 30 A0 E1 ?? ?? ?? ?? 02 00 56 E3 1C 00 8D E5 20 10 8D E5 0D 00 00 1A ?? ?? ?? ?? 21 30 A0 E3 00 30 80 E5 24 30 9D E5 00 00 53 E3 0C 00 00 1A 1C 80 8D E2 80 01 98 E8 07 00 A0 E1 08 10 A0 E1 28 D0 8D E2 F0 8D BD E8 1C B0 8D E5 20 C0 8D E5 04 00 8D E2 ?? ?? ?? ?? 00 00 50 E3 F0 FF FF 1A EC FF FF EA ?? ?? ?? ?? 24 30 9D E5 00 30 80 E5 EE FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_109_0_1 {
	meta:
		name = "sinhf"
		size = 324
		refs = "000c __ieee754_sinhf 0024 finitef 0064 __extendsfdf2 008c __gtsf2 00b8 matherr 00d8 __truncdfsf2 011c __errno 013c __fdlib_version"
	strings:
		$1 = { F0 40 2D E9 24 D0 4D E2 00 50 A0 E1 ?? ?? ?? ?? 24 41 9F E5 00 30 94 E5 01 00 73 E3 00 60 A0 E1 02 00 00 0A ?? ?? ?? ?? 00 70 50 E2 02 00 00 0A 06 00 A0 E1 24 D0 8D E2 F0 80 BD E8 05 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 F8 FF FF 0A 03 30 A0 E3 00 30 8D E5 E4 30 9F E5 05 00 A0 E1 04 30 8D E5 20 70 8D E5 ?? ?? ?? ?? 00 40 94 E5 00 00 54 E3 08 00 8D E5 0C 10 8D E5 10 00 8D E5 14 10 8D E5 17 00 00 1A 05 00 A0 E1 00 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 0E 33 E0 D3 2E 33 E0 C3 01 36 43 D2 0E 42 A0 D3 01 36 43 C2 0E 42 A0 C3 18 30 8D E5 1C 40 8D E5 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 15 00 00 0A 20 30 9D E5 00 00 53 E3 16 00 00 1A 18 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 60 A0 E1 D2 FF FF EA 05 00 A0 E1 00 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 02 21 A0 D3 7F 24 A0 C3 C2 25 A0 D1 00 30 A0 D3 0F 26 82 C2 00 30 A0 C3 02 00 54 E3 18 20 8D E5 1C 30 8D E5 E5 FF FF 1A ?? ?? ?? ?? 22 30 A0 E3 00 30 80 E5 E5 FF FF EA ?? ?? ?? ?? 20 30 9D E5 00 30 80 E5 E4 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_110_1_1 {
	meta:
		name = "qonef"
		size = 288
		refs = "002c __mulsf3 0038 __divsf3 004c __addsf3"
	strings:
		$1 = { BF 34 E0 E3 02 21 C0 E3 0E 36 43 E2 03 00 52 E1 F0 40 2D E9 FC 50 9F D5 FC 50 9F C5 00 10 A0 E1 18 60 85 D2 18 60 85 C2 00 70 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 FE 05 A0 E3 ?? ?? ?? ?? 14 10 96 E5 00 40 A0 E1 ?? ?? ?? ?? 10 10 96 E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 0C 10 96 E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 08 10 96 E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 04 10 96 E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 00 10 96 E5 ?? ?? ?? ?? 14 10 95 E5 00 60 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 10 10 95 E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 0C 10 95 E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 08 10 95 E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 04 10 95 E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 00 10 95 E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? FB 15 A0 E3 ?? ?? ?? ?? 07 10 A0 E1 ?? ?? ?? ?? F0 80 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_110_2_1 {
	meta:
		name = "__ieee754_j1f"
		size = 620
		refs = "0028 __divsf3 0030 fabsf 0050 __addsf3 0058 __gtsf2 006c __mulsf3 0090 __subsf3 014c sinf 0158 cosf 01a4 __ieee754_sqrtf"
	strings:
		$1 = { 02 31 E0 E3 F0 47 2D E9 02 35 43 E2 02 51 C0 E3 03 00 55 E1 00 40 A0 E1 00 60 A0 E1 03 00 00 DA 00 10 A0 E1 FE 05 A0 E3 ?? ?? ?? ?? F0 87 BD E8 ?? ?? ?? ?? 07 01 75 E3 00 70 A0 E1 42 00 00 CA 32 04 55 E3 0A 00 00 AA F8 11 9F E5 04 00 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 00 00 50 E3 03 00 00 DA 04 00 A0 E1 3F 14 A0 E3 ?? ?? ?? ?? F0 87 BD E8 04 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? C4 11 9F E5 00 50 A0 E1 ?? ?? ?? ?? BC 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? B0 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? F6 15 A0 E3 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 8C 11 9F E5 00 60 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 80 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? CA 14 E0 E3 62 18 41 E2 3D 10 41 E2 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 5C 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 50 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 3F 14 A0 E3 00 50 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? F0 87 BD E8 ?? ?? ?? ?? 00 80 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 04 10 A0 E1 02 01 88 E2 ?? ?? ?? ?? 04 10 A0 E1 00 A0 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 7F 04 55 E3 00 90 A0 E1 19 00 00 BA 07 00 A0 E1 02 FF FF EB 00 50 A0 E1 07 00 A0 E1 50 FF FF EB 00 80 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 00 40 A0 E1 09 00 A0 E1 ?? ?? ?? ?? 08 10 A0 E1 00 50 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 8C 10 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 00 00 56 E3 02 01 80 B2 F0 87 BD E8 07 10 A0 E1 07 00 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 04 10 A0 E1 00 50 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 04 00 00 DA 05 00 A0 E1 0A 10 A0 E1 ?? ?? ?? ?? 00 90 A0 E1 D4 FF FF EA 05 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 00 A0 A0 E1 CF FF FF EA CA F2 49 71 D2 57 55 33 36 2E 86 37 FD 6C B8 3A 7E 56 59 2D 46 64 AD 31 B6 FA 42 39 59 E8 9C 3C BB 6E 10 3F }
	condition:
		$1
}

rule file_110_3_1 {
	meta:
		name = "__ieee754_y1f"
		size = 776
		refs = "004c __divsf3 006c __mulsf3 0074 __addsf3 00c0 __subsf3 0160 __ieee754_j1f 016c __ieee754_logf 01bc sinf 01c8 cosf 01ec __ieee754_sqrtf 0240 __gtsf2"
	strings:
		$1 = { 02 31 E0 E3 F0 45 2D E9 02 35 43 E2 02 51 C0 E3 03 00 55 E1 00 40 A0 E1 12 00 00 CA 00 00 55 E3 0B 00 00 0A 00 00 50 E3 77 00 00 BA 07 01 75 E3 61 00 00 CA 92 05 55 E3 12 00 00 CA 00 10 A0 E1 DD 08 E0 E3 67 0E 40 E2 31 01 40 E2 ?? ?? ?? ?? F0 85 BD E8 BF 04 A0 E3 00 10 A0 E3 02 05 80 E2 ?? ?? ?? ?? F0 85 BD E8 00 10 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 FE 05 A0 E3 ?? ?? ?? ?? F0 85 BD E8 00 10 A0 E1 ?? ?? ?? ?? 3B 12 A0 E3 F1 17 81 E2 16 1A 81 E2 00 50 A0 E1 ?? ?? ?? ?? 3C 12 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? C5 14 E0 E3 55 1A 41 E2 D5 10 41 E2 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 18 12 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 0C 12 9F E5 ?? ?? ?? ?? 08 12 9F E5 00 60 A0 E1 05 00 A0 E1 ?? ?? ?? ?? FC 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? D6 15 A0 E3 36 18 81 E2 B5 1F 81 E2 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? D8 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? CC 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 00 50 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 60 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 00 60 A0 E1 BF 04 A0 E3 04 10 A0 E1 02 05 80 E2 ?? ?? ?? ?? 00 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? DD 18 E0 E3 67 1E 41 E2 33 11 41 E2 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? F0 85 BD E8 ?? ?? ?? ?? 00 70 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 60 A0 E1 06 10 A0 E1 02 01 87 E2 ?? ?? ?? ?? 7F 04 55 E3 00 80 A0 E1 0C 00 00 BA 04 00 A0 E1 ?? ?? ?? ?? 0C 11 9F E5 00 40 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? F0 85 BD E8 00 00 A0 E3 00 10 A0 E1 ?? ?? ?? ?? F0 85 BD E8 04 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 06 10 A0 E1 00 A0 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 1D 00 00 DA 0A 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 70 A0 E1 12 03 55 E3 E0 FF FF CA 04 00 A0 E1 30 FE FF EB 00 50 A0 E1 04 00 A0 E1 7E FE FF EB 00 60 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 00 40 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 06 10 A0 E1 00 50 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 4C 10 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? F0 85 BD E8 07 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 00 70 A0 E1 07 10 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 00 80 A0 E1 DC FF FF EA 1C 58 C5 37 3C 9E 4E 3D 31 C3 48 3E CF 81 92 2D EB F8 D5 31 4B 64 54 39 6A 28 A3 3C BB 6E 10 3F }
	condition:
		$1
}

rule file_111_0_1 {
	meta:
		name = "__ieee754_acos"
		size = 1560
		refs = "007c __subdf3 008c __muldf3 0098 __ieee754_sqrt 00c4 __adddf3 01b8 __divdf3"
	strings:
		$1 = { 03 31 E0 E3 01 36 43 E2 02 21 C0 E3 03 00 52 E1 F0 4F 2D E9 00 40 A0 E1 01 50 A0 E1 0B 00 00 DA 03 21 82 E2 01 26 82 E2 01 20 92 E1 00 60 A0 E1 01 70 A0 E1 93 00 00 1A 00 00 50 E3 00 00 A0 C3 00 10 A0 C3 AE 1F 8F D2 03 00 91 D8 F0 8F BD E8 03 31 E0 E3 02 36 43 E2 03 00 52 E1 82 00 00 DA 00 00 50 E3 05 01 00 BA 00 20 A0 E1 FF 05 A0 E3 01 30 A0 E1 03 06 80 E2 00 10 A0 E3 ?? ?? ?? ?? FF 25 A0 E3 02 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 ?? ?? ?? ?? 82 3F 8F E2 0C 00 93 E8 00 80 A0 E1 01 90 A0 E1 00 60 A0 E1 05 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 1F 3E 8F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 1E 3E 8F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 1D 3E 8F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 07 3D 8F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 1B 3E 8F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 1A 3E 8F E2 0C 00 93 E8 00 A0 A0 E1 01 B0 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 63 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 5F 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 5B 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? FF 25 A0 E3 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 00 70 A0 E3 00 A0 A0 E1 01 B0 A0 E1 08 20 A0 E1 07 30 A0 E1 08 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 08 20 A0 E1 00 40 A0 E1 01 50 A0 E1 07 30 A0 E1 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 08 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? F0 8F BD E8 F1 35 A0 E3 02 36 83 E2 03 00 52 E1 23 00 00 CA 20 10 8F E2 03 00 91 E8 F0 8F BD E8 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? F0 8F BD E8 FB 21 F9 3F 18 2D 44 54 E1 3D 02 3F 09 F7 FD 0D E0 EF 49 3F 88 B2 01 75 28 82 A4 3F 3B 8F 68 B5 55 C1 C9 3F 55 44 88 0E 12 D6 D4 3F 7D 6F EB 03 55 55 C5 3F 55 55 55 55 C5 B8 B3 3F 82 92 2E B1 6C 06 E6 3F 59 01 8D 1B E5 2A 00 40 C8 8A 59 9C 27 3A 03 40 4B 2D 8A 1C 26 A6 91 3C 07 5C 14 33 FB 21 09 40 18 2D 44 54 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 74 30 4F E2 0C 00 93 E8 00 60 A0 E1 01 70 A0 E1 ?? ?? ?? ?? 80 30 4F E2 0C 00 93 E8 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? 90 30 4F E2 0C 00 93 E8 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? A0 30 4F E2 0C 00 93 E8 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? B0 30 4F E2 0C 00 93 E8 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? C0 30 4F E2 0C 00 93 E8 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? D0 30 4F E2 0C 00 93 E8 00 80 A0 E1 01 90 A0 E1 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? E4 30 4F E2 0C 00 93 E8 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? F4 30 4F E2 0C 00 93 E8 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? 41 3F 4F E2 0C 00 93 E8 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? FF 25 A0 E3 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 55 1F 4F E2 03 00 91 E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 75 1F 4F E2 03 00 91 E8 ?? ?? ?? ?? F0 8F BD E8 FF 25 A0 E3 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? FF 25 A0 E3 02 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 ?? ?? ?? ?? 82 3F 4F E2 0C 00 93 E8 00 60 A0 E1 01 70 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 87 3F 4F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 8B 3F 4F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 8F 3F 4F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 93 3F 4F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 97 3F 4F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 9B 3F 4F E2 0C 00 93 E8 00 80 A0 E1 01 90 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 0A 3D 4F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 29 3E 4F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 2A 3E 4F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? FF 25 A0 E3 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? BA 3F 4F E2 0C 00 93 E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 03 21 A0 E3 00 30 A0 E3 ?? ?? ?? ?? C3 3F 4F E2 0C 00 93 E8 ?? ?? ?? ?? F0 8F BD E8 }
	condition:
		$1
}

rule file_113_0_1 {
	meta:
		name = "__ieee754_rem_pio2f"
		size = 1204
		refs = "0050 __subsf3 00d0 __fixsfsi 00d4 __floatsisf 00f4 __mulsf3 012c __eqsf2 0184 __kernel_rem_pio2f 0238 fabsf 024c __addsf3"
	strings:
		$1 = { F0 4F 2D E9 9F 31 E0 E3 B6 38 43 E2 0F 3A 43 E2 02 61 C0 E3 03 00 56 E1 14 D0 4D E2 00 50 A0 E1 01 40 A0 E1 62 00 00 DA 5B 39 A0 E3 BE 3E 83 E2 0D 31 83 E2 03 00 56 E1 17 00 00 CA 00 00 50 E3 EC 00 00 DA FF 15 A0 E3 09 18 81 E2 3E 1D 81 E2 ?? ?? ?? ?? DB 39 E0 E3 03 3A 43 E2 3E 51 C5 E3 BF 31 43 E2 03 00 55 E1 00 60 A0 E1 5D 00 00 0A 28 14 9F E5 ?? ?? ?? ?? 00 10 A0 E1 00 00 84 E5 06 00 A0 E1 ?? ?? ?? ?? 10 14 9F E5 ?? ?? ?? ?? 01 70 A0 E3 04 00 84 E5 49 00 00 EA 43 34 A0 E3 49 38 83 E2 3E 3D 83 E2 03 00 56 E1 61 00 00 DA 02 31 E0 E3 02 35 43 E2 03 00 56 E1 43 00 00 CA C6 8B A0 E1 86 80 48 E2 88 6B 46 E0 06 00 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 00 30 A0 E1 00 10 A0 E1 06 00 A0 E1 08 30 8D E5 ?? ?? ?? ?? 43 14 A0 E3 02 15 81 E2 ?? ?? ?? ?? 00 60 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 00 30 A0 E1 00 10 A0 E1 06 00 A0 E1 0C 30 8D E5 ?? ?? ?? ?? 43 14 A0 E3 02 15 81 E2 ?? ?? ?? ?? 00 10 A0 E3 10 00 8D E5 ?? ?? ?? ?? 08 A0 8D E2 04 70 8A E2 00 00 50 E3 03 60 A0 E3 04 70 47 E2 06 00 00 1A 04 00 97 E5 00 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 01 60 46 E2 04 70 47 E2 F8 FF FF 0A 02 C0 A0 E3 00 C0 8D E5 30 C3 9F E5 0A 00 A0 E1 08 20 A0 E1 06 30 A0 E1 04 10 A0 E1 04 C0 8D E5 ?? ?? ?? ?? 00 00 55 E3 00 70 A0 E1 0B 00 00 AA 00 30 94 E5 04 20 94 E5 02 31 83 E2 02 21 82 E2 04 20 84 E5 00 30 84 E5 00 70 67 E2 03 00 00 EA 00 30 A0 E3 04 30 81 E5 00 00 84 E5 00 70 A0 E3 07 00 A0 E1 14 D0 8D E2 F0 8F BD E8 00 10 A0 E1 ?? ?? ?? ?? 00 70 A0 E3 00 00 84 E5 04 00 84 E5 F6 FF FF EA 37 14 A0 E3 D5 19 81 E2 01 1B 81 E2 ?? ?? ?? ?? BA 15 A0 E3 5A 1A 81 E2 C2 1F 81 E2 00 50 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 00 00 84 E5 05 00 A0 E1 ?? ?? ?? ?? BA 15 A0 E3 5A 1A 81 E2 C2 1F 81 E2 ?? ?? ?? ?? 01 70 A0 E3 04 00 84 E5 E2 FF FF EA ?? ?? ?? ?? 64 12 9F E5 00 80 A0 E1 ?? ?? ?? ?? 3F 14 A0 E3 ?? ?? ?? ?? ?? ?? ?? ?? 00 70 A0 E1 ?? ?? ?? ?? BF 14 A0 E3 C9 18 81 E2 3E 1D 81 E2 00 90 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 1C 12 9F E5 00 80 A0 E1 09 00 A0 E1 ?? ?? ?? ?? 1F 00 57 E3 00 A0 A0 E1 12 00 00 CA 0C 32 9F E5 01 20 47 E2 02 31 93 E7 FF 20 C6 E3 03 00 52 E1 0C 00 00 0A 0A 10 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 00 00 84 E5 00 10 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 0A 10 A0 E1 ?? ?? ?? ?? 00 00 55 E3 04 00 84 E5 B8 FF FF AA AB FF FF EA 0A 10 A0 E1 08 00 A0 E1 ?? ?? ?? ?? A0 3B A0 E1 C6 6B A0 E1 FF 30 03 E2 06 30 63 E0 08 00 53 E3 00 10 A0 E1 00 00 84 E5 EC FF FF DA 37 14 A0 E3 D5 19 81 E2 01 1B 81 E2 09 00 A0 E1 ?? ?? ?? ?? 00 A0 A0 E1 0A 10 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 00 B0 A0 E1 0B 10 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 0A 10 A0 E1 ?? ?? ?? ?? BA 15 A0 E3 5A 1A 81 E2 00 80 A0 E1 C2 1F 81 E2 09 00 A0 E1 ?? ?? ?? ?? 08 10 A0 E1 ?? ?? ?? ?? 00 A0 A0 E1 0A 10 A0 E1 0B 00 A0 E1 ?? ?? ?? ?? A0 3B A0 E1 FF 30 03 E2 06 60 63 E0 19 00 56 E3 00 10 A0 E1 00 00 84 E5 0B 80 A0 D1 C9 FF FF DA BA 15 A0 E3 5A 1A 81 E2 03 1C 81 E2 09 00 A0 E1 ?? ?? ?? ?? 00 60 A0 E1 06 10 A0 E1 0B 00 A0 E1 ?? ?? ?? ?? 00 80 A0 E1 08 10 A0 E1 0B 00 A0 E1 ?? ?? ?? ?? 06 10 A0 E1 ?? ?? ?? ?? D0 10 9F E5 00 60 A0 E1 09 00 A0 E1 ?? ?? ?? ?? 06 10 A0 E1 ?? ?? ?? ?? 00 A0 A0 E1 AD FF FF EA FF 15 A0 E3 09 18 81 E2 3E 1D 81 E2 ?? ?? ?? ?? DB 39 E0 E3 03 3A 43 E2 3E 51 C5 E3 BF 31 43 E2 03 00 55 E1 00 60 A0 E1 0A 00 00 0A 74 10 9F E5 ?? ?? ?? ?? 00 10 A0 E1 00 00 84 E5 06 00 A0 E1 ?? ?? ?? ?? 5C 10 9F E5 ?? ?? ?? ?? 00 70 E0 E3 04 00 84 E5 5C FF FF EA 37 14 A0 E3 D5 19 81 E2 01 1B 81 E2 ?? ?? ?? ?? BA 15 A0 E3 5A 1A 81 E2 C2 1F 81 E2 00 50 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 00 00 84 E5 05 00 A0 E1 ?? ?? ?? ?? BA 15 A0 E3 5A 1A 81 E2 C2 1F 81 E2 ?? ?? ?? ?? 00 70 E0 E3 04 00 84 E5 48 FF FF EA 43 44 35 37 ?? ?? ?? ?? 84 F9 22 3F ?? ?? ?? ?? 32 31 8D 24 }
	condition:
		$1
}

rule file_115_0_1 {
	meta:
		name = "__kernel_rem_pio2"
		size = 2996
		refs = "0030 __divsi3 0098 __floatsidf 0108 __muldf3 011c __adddf3 01c0 __fixdfsi 0228 scalbn 0240 floor 028c __subdf3 03ac __eqdf2 05e4 __gedf2"
	strings:
		$1 = { F0 4F 2D E9 99 DF 4D E2 02 40 A0 E1 20 30 8D E5 00 80 A0 E1 90 3B 9F E5 03 00 42 E2 88 22 9D E5 02 31 93 E7 18 10 8D E5 18 10 A0 E3 1C 30 8D E5 ?? ?? ?? ?? 20 30 9D E5 C0 0F C0 E1 01 30 43 E2 0C 30 8D E5 18 20 A0 E3 00 30 E0 E1 92 43 23 E0 28 00 8D E5 1C 50 9D E5 0C 00 9D E5 00 70 95 E0 14 30 8D E5 10 00 00 4A 28 10 9D E5 8C 22 9D E5 01 40 60 E0 07 70 84 E0 5D 6F 8D E2 04 51 82 E0 00 00 00 EA 01 40 84 E2 00 00 54 E3 00 00 A0 B3 00 10 A0 B3 00 00 95 A5 ?? ?? ?? ?? 07 00 54 E1 03 00 A6 E8 04 50 85 E2 F5 FF FF 1A 1C 30 9D E5 00 00 53 E3 24 00 00 BA 20 50 9D E5 20 00 9D E5 05 50 83 E0 0C 90 9D E5 00 50 8D E5 34 B0 8D E2 80 A1 A0 E1 0C 20 9D E5 00 00 52 E3 00 60 A0 B3 00 70 A0 B3 13 00 00 BA 5D 3F 8D E2 89 51 83 E0 00 40 A0 E3 00 60 A0 E3 00 70 A0 E3 04 30 88 E0 03 00 93 E8 0C 00 95 E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 08 40 84 E2 0A 00 54 E1 00 60 A0 E1 01 70 A0 E1 08 50 45 E2 F0 FF FF 1A 00 10 9D E5 01 90 89 E2 01 00 59 E1 C0 00 AB E8 E1 FF FF 1A 1C 50 9D E5 99 0F 8D E2 01 30 45 E2 03 31 80 E0 85 1F 8D E2 50 30 43 E2 05 11 81 E0 30 30 8D E5 00 50 8D E5 2C 10 8D E5 00 20 9D E5 00 30 9D E5 82 21 A0 E1 99 5F 8D E2 00 00 53 E3 02 30 85 E0 04 20 8D E5 23 7E 43 E2 C0 00 97 E8 1F 00 00 DA 34 90 8D E2 02 50 89 E0 00 40 A0 E3 F9 25 A0 E3 03 26 82 E2 00 30 A0 E3 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? C1 24 A0 E3 07 26 82 E2 00 30 A0 E3 00 A0 A0 E1 01 B0 A0 E1 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 85 1F 8D E2 04 00 81 E7 0C 00 35 E9 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 09 00 55 E1 00 60 A0 E1 01 70 A0 E1 04 40 84 E2 E2 FF FF 1A 06 00 A0 E1 14 20 9D E5 07 10 A0 E1 ?? ?? ?? ?? FF 25 A0 E3 00 30 A0 E3 00 40 A0 E1 01 50 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 03 21 A0 E3 02 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 01 50 A0 E1 00 40 A0 E1 ?? ?? ?? ?? 00 A0 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 14 20 9D E5 00 00 52 E3 00 50 A0 E1 01 60 A0 E1 BC 00 00 DA 00 30 9D E5 99 0F 8D E2 01 10 43 E2 01 11 80 E0 50 00 11 E5 18 20 62 E2 50 32 A0 E1 13 22 40 E0 14 00 9D E5 17 70 60 E2 52 77 A0 E1 50 20 01 E5 03 A0 8A E0 00 00 57 E3 2E 00 00 DA 00 30 9D E5 00 00 53 E3 01 A0 8A E2 00 40 A0 D3 18 00 00 DA 00 00 9D E5 00 30 A0 E3 00 11 A0 E1 03 40 A0 E1 06 00 00 EA 00 00 52 E3 01 24 62 12 03 20 80 17 04 30 83 E2 01 40 A0 13 01 00 53 E1 0C 00 00 0A 85 0F 8D E2 00 00 54 E3 03 20 90 E7 F4 FF FF 0A FF 28 62 E2 FF 2C 82 E2 FF 20 82 E2 85 0F 8D E2 03 20 80 E7 04 30 83 E2 01 00 53 E1 01 40 A0 E3 F2 FF FF 1A 14 10 9D E5 00 00 51 E3 0B 00 00 DA 01 00 51 E3 91 00 00 0A 02 00 51 E3 07 00 00 1A 00 10 9D E5 99 3F 8D E2 01 20 41 E2 02 21 83 E0 50 30 12 E5 FF 34 C3 E3 03 35 C3 E3 50 30 02 E5 02 00 57 E3 67 00 00 0A 05 00 A0 E1 06 10 A0 E1 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 B3 01 00 1A 00 50 9D E5 1C 10 9D E5 01 00 45 E2 00 00 51 E1 09 00 00 CA 85 2F 8D E2 2C C0 9D E5 05 31 82 E0 00 20 A0 E3 04 10 33 E5 0C 00 53 E1 01 20 82 E1 FB FF FF 1A 00 00 52 E3 81 00 00 1A 30 50 9D E5 00 30 95 E5 00 00 53 E3 01 20 A0 13 06 00 00 1A 2C 30 9D E5 01 20 A0 E3 08 10 13 E5 00 00 51 E3 01 20 82 E2 04 30 43 E2 FA FF FF 0A 00 00 9D E5 00 20 82 E0 02 00 50 E1 24 20 8D E5 3D 00 00 AA 28 10 9D E5 01 20 81 E2 8C 12 9D E5 20 50 9D E5 00 20 82 E0 02 21 81 E0 05 30 80 E0 04 00 9D E5 04 20 8D E5 5D 2F 8D E2 83 21 82 E0 03 90 A0 E1 24 30 9D E5 05 30 83 E0 34 B0 8D E2 00 20 8D E5 10 30 8D E5 00 B0 8B E0 85 A1 A0 E1 04 50 9D E5 00 00 95 E5 ?? ?? ?? ?? 0C 20 9D E5 00 30 9D E5 00 00 52 E3 03 00 83 E8 00 60 A0 B3 00 70 A0 B3 13 00 00 BA 5D 0F 8D E2 89 51 80 E0 00 40 A0 E3 00 60 A0 E3 00 70 A0 E3 04 30 88 E0 03 00 93 E8 0C 00 95 E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 08 40 84 E2 0A 00 54 E1 00 60 A0 E1 01 70 A0 E1 08 50 45 E2 F0 FF FF 1A 04 20 9D E5 00 30 9D E5 10 10 9D E5 01 90 89 E2 04 20 82 E2 08 30 83 E2 01 00 59 E1 08 60 8B E5 0C 70 8B E5 04 20 8D E5 00 30 8D E5 08 B0 8B E2 D4 FF FF 1A 24 50 9D E5 00 50 8D E5 0D FF FF EA FF 05 A0 E3 05 20 A0 E1 06 30 A0 E1 03 06 80 E2 00 10 A0 E3 ?? ?? ?? ?? 00 00 54 E3 00 50 A0 E1 01 60 A0 E1 8D FF FF 0A FF 05 A0 E3 14 20 9D E5 03 06 80 E2 00 10 A0 E3 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 00 50 A0 E1 01 60 A0 E1 80 FF FF EA 0E 00 00 1A 00 20 9D E5 99 1F 8D E2 02 31 81 E0 54 70 13 E5 C7 7B A0 E1 48 FF FF EA 00 30 9D E5 99 0F 8D E2 01 20 43 E2 02 21 80 E0 50 30 12 E5 FF 34 C3 E3 02 35 C3 E3 50 30 02 E5 6E FF FF EA FF 25 A0 E3 02 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 00 70 A0 B3 02 70 A0 A3 39 FF FF AA 67 FF FF EA 00 31 A0 E1 99 5F 8D E2 03 20 85 E0 14 10 9D E5 50 20 12 E5 18 10 41 E2 00 00 52 E3 0C 70 8D E5 10 A0 8D E5 14 10 8D E5 00 00 8D 15 0B 00 00 1A 85 2F 8D E2 03 30 82 E0 00 00 8D E5 14 20 9D E5 00 10 A0 E1 04 00 33 E5 00 00 50 E3 01 10 41 E2 18 20 42 E2 FA FF FF 0A 14 20 8D E5 00 10 8D E5 FF 05 A0 E3 14 20 9D E5 03 06 80 E2 00 10 A0 E3 ?? ?? ?? ?? 00 30 9D E5 00 00 53 E3 00 60 A0 E1 01 70 A0 E1 40 00 00 BA 85 5F 8D E2 34 40 8D E2 03 51 85 E0 83 41 84 E0 2C 80 8D E2 04 00 15 E4 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? F9 25 A0 E3 03 00 84 E8 03 26 82 E2 06 00 A0 E1 07 10 A0 E1 00 30 A0 E3 ?? ?? ?? ?? 08 40 44 E2 08 00 54 E1 00 60 A0 E1 01 70 A0 E1 EE FF FF 1A 00 90 9D E5 04 90 8D E5 1C 90 9D E5 00 80 A0 E3 34 70 8D E2 00 00 59 E3 E0 00 00 BA 00 00 58 E3 DE 00 00 BA 04 10 9D E5 A4 64 9F E5 81 51 87 E0 00 A0 A0 E3 00 B0 A0 E3 00 40 A0 E3 03 00 00 EA 08 00 54 E1 08 60 86 E2 08 50 85 E2 0C 00 00 CA 0C 00 95 E8 03 00 96 E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 01 40 84 E2 04 00 59 E1 00 A0 A0 E1 01 B0 A0 E1 EE FF FF AA 04 50 9D E5 99 0F 8D E2 01 50 45 E2 88 31 80 E0 01 00 75 E3 04 50 8D E5 90 A1 03 E5 8C B1 03 E5 01 80 88 E2 D9 FF FF 1A 88 22 9D E5 03 00 52 E3 02 F1 9F 97 15 00 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 30 A0 E3 03 20 A0 E1 0C 50 9D E5 00 00 55 E3 EE 00 00 0A D4 40 9D E5 DC 00 9D E5 D8 C0 9D E5 E0 10 9D E5 18 50 9D E5 02 41 84 E2 02 01 80 E2 02 31 83 E2 14 20 85 E5 10 10 85 E8 08 00 85 E5 0C 10 85 E5 10 30 85 E5 10 10 9D E5 07 00 01 E2 99 DF 8D E2 F0 8F BD E8 00 30 9D E5 00 00 53 E3 E6 FF FF DA 00 10 9D E5 99 2F 8D E2 81 81 A0 E1 08 30 82 E0 19 1E 43 E2 03 00 91 E8 D4 60 8D E2 03 00 8D E9 08 40 86 E0 04 50 A0 E1 0C 00 9D E9 03 00 15 E9 ?? ?? ?? ?? 00 A0 A0 E1 01 B0 A0 E1 0A 20 A0 E1 03 00 15 E9 0B 30 A0 E1 ?? ?? ?? ?? 0C 00 9D E9 ?? ?? ?? ?? 03 00 85 E8 00 0C 25 E9 06 00 55 E1 00 0C 8D E9 EF FF FF 1A 00 10 9D E5 01 00 51 E3 C9 FF FF DA 99 2F 8D E2 08 80 82 E0 01 50 41 E2 19 BE 48 E2 00 0C 9B E8 85 51 86 E0 0C 00 95 E8 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 00 70 A0 E1 01 80 A0 E1 07 20 A0 E1 03 00 95 E8 08 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 80 01 85 E8 08 00 85 E5 0C 10 85 E5 08 50 45 E2 06 00 55 E1 07 A0 A0 E1 08 B0 A0 E1 E8 FF FF 1A 00 30 A0 E3 08 50 85 E2 03 20 A0 E1 03 00 A0 E1 02 10 A0 E1 0C 00 94 E8 ?? ?? ?? ?? 08 40 44 E2 05 00 54 E1 00 30 A0 E1 01 20 A0 E1 F6 FF FF 1A A1 FF FF EA 00 50 9D E5 00 00 55 E3 00 30 A0 B3 03 10 A0 B1 0C 00 00 BA 00 50 9D E5 00 30 A0 E3 D4 40 8D E2 85 41 84 E0 03 10 A0 E1 CC 50 8D E2 03 00 A0 E1 0C 00 94 E8 08 40 44 E2 ?? ?? ?? ?? 05 00 54 E1 FA FF FF 1A 00 30 A0 E1 0C 00 9D E5 00 00 50 E3 03 20 A0 01 02 21 83 12 01 70 A0 E1 18 10 9D E5 02 60 A0 E1 C0 00 81 E8 03 20 A0 E1 D4 10 8D E2 03 00 91 E8 07 30 A0 E1 ?? ?? ?? ?? 00 20 9D E5 00 00 52 E3 01 20 A0 E1 0C 00 00 DA 00 30 9D E5 D4 40 8D E2 83 51 84 E0 02 10 A0 E1 02 70 A0 E1 08 30 84 E2 0C 00 93 E8 00 60 A0 E1 ?? ?? ?? ?? 08 40 84 E2 05 00 54 E1 01 20 A0 E1 F5 FF FF 1A 0C 50 9D E5 00 00 55 E3 02 01 80 12 00 30 A0 E1 18 00 9D E5 02 40 A0 E1 08 30 80 E5 0C 40 80 E5 78 FF FF EA 00 00 9D E5 00 00 50 E3 00 30 A0 B3 03 20 A0 B1 0E 00 00 BA 00 10 9D E5 00 30 A0 E3 D4 40 8D E2 81 41 84 E0 CC 50 8D E2 03 20 A0 E1 03 00 A0 E1 02 10 A0 E1 0C 00 94 E8 ?? ?? ?? ?? 08 40 44 E2 05 00 54 E1 00 30 A0 E1 01 20 A0 E1 F6 FF FF 1A 0C 50 9D E5 00 00 55 E3 02 10 A0 E1 02 31 83 12 18 20 9D E5 03 00 A0 E1 03 00 82 E8 5C FF FF EA 00 A0 A0 E3 00 B0 A0 E3 35 FF FF EA 14 30 9D E5 05 00 A0 E1 00 20 63 E2 06 10 A0 E1 0C 70 8D E5 10 A0 8D E5 ?? ?? ?? ?? 41 24 A0 E3 07 26 82 E2 00 30 A0 E3 00 40 A0 E1 01 50 A0 E1 ?? ?? ?? ?? 00 00 50 E3 24 00 00 BA F9 25 A0 E3 03 26 82 E2 00 30 A0 E3 05 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? C1 24 A0 E3 07 26 82 E2 00 30 A0 E3 00 60 A0 E1 01 70 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 00 10 9D E5 99 5F 8D E2 01 31 85 E0 50 00 03 E5 07 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 00 20 9D E5 99 5F 8D E2 01 20 82 E2 02 31 85 E0 50 00 03 E5 14 00 9D E5 18 00 80 E2 00 20 8D E5 14 00 8D E5 C0 FE FF EA 05 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 20 9D E5 99 1F 8D E2 02 31 81 E0 50 00 03 E5 B8 FE FF EA D4 60 8D E2 60 00 96 E8 03 00 A0 E1 02 10 A0 E1 DC 40 8D E2 18 00 94 E8 18 20 9D E5 10 00 82 E5 14 10 82 E5 60 00 82 E8 08 30 82 E5 0C 40 82 E5 10 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_118_0_1 {
	meta:
		name = "__ieee754_pow"
		size = 4108
		refs = "013c fabs 01cc __muldf3 01e8 nan 02c0 __subdf3 02cc __divdf3 042c __adddf3 07cc __floatsidf 0998 __gtdf2 0cd0 __ieee754_sqrt 0d18 __gedf2 0ff4 scalbn"
	strings:
		$1 = { F0 4F 2D E9 40 D0 4D E2 08 00 8D E5 0C 10 8D E5 08 C0 8D E2 00 18 9C E8 02 61 C2 E3 00 80 A0 E1 03 00 A0 E1 02 40 A0 E1 03 50 A0 E1 02 70 A0 E1 0C 30 A0 E1 0B 20 A0 E1 00 C0 96 E1 01 A0 A0 E1 02 B0 A0 E1 03 90 A0 E1 09 00 00 0A 7F 14 A0 E3 0F 16 81 E2 02 C1 C2 E3 01 00 5C E1 08 20 8D E5 0A 00 00 DA 03 C1 8C E2 01 C6 8C E2 09 C0 9C E1 59 00 00 1A FF 45 A0 E3 03 46 84 E2 00 50 A0 E3 04 00 A0 E1 05 10 A0 E1 40 D0 8D E2 F0 8F BD E8 00 20 A0 13 01 20 A0 03 00 00 53 E3 00 30 A0 03 01 30 02 12 00 00 53 E3 ED FF FF 1A 01 00 56 E1 EB FF FF CA 00 10 A0 13 01 10 A0 03 01 30 A0 E1 00 00 50 E3 00 30 A0 03 01 30 03 12 00 00 53 E3 20 10 8D E5 E2 FF FF 1A 00 00 5B E3 42 00 00 BA 00 30 A0 E3 10 30 8D E5 00 00 50 E3 0E 00 00 1A 20 00 9D E5 00 00 50 E3 53 00 00 1A FF 35 A0 E3 03 36 83 E2 03 00 56 E1 78 00 00 0A 01 01 57 E3 08 00 A0 01 0A 10 A0 01 29 00 00 0A FF 35 A0 E3 02 36 83 E2 03 00 57 E1 E1 02 00 0A 08 00 A0 E1 0A 10 A0 E1 04 20 8D E5 00 C0 8D E5 ?? ?? ?? ?? 00 00 59 E3 04 20 9D E5 00 C0 9D E5 07 00 00 1A 00 00 5C E3 01 20 82 03 00 00 52 E3 47 00 00 1A FF 35 A0 E3 03 36 83 E2 03 00 5C E1 43 00 00 0A AB 9F A0 E1 10 20 9D E5 01 90 49 E2 09 20 92 E1 55 00 00 0A 41 34 A0 E3 0E 36 83 E2 03 00 56 E1 75 00 00 DA 43 34 A0 E3 0F 36 83 E2 03 00 56 E1 09 03 00 DA 03 31 E0 E3 01 36 43 E2 03 00 5C E1 C7 02 00 DA 00 00 57 E3 2D 00 00 DA 16 1E 8F E2 03 00 91 E8 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 A8 FF FF EA 48 01 9F E5 40 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 2F 33 E0 E3 03 35 43 E2 03 00 56 E1 02 30 A0 C3 10 30 8D C5 B8 FF FF CA 03 31 E0 E3 01 36 43 E2 03 00 56 E1 B2 FF FF DA 46 3A A0 E1 FF 3F 43 E2 03 30 43 E2 14 00 53 E3 55 03 00 DA 34 30 63 E2 30 13 A0 E1 11 03 50 E1 01 30 01 02 02 30 63 02 18 10 8D E5 10 30 8D 05 A5 FF FF 1A A6 FF FF EA 03 31 8C E2 01 36 83 E2 09 30 93 E1 85 FF FF 0A 03 31 E0 E3 01 36 43 E2 03 00 5C E1 D3 02 00 DA 00 00 57 E3 82 FF FF AA 00 40 A0 E3 04 50 A0 E1 7F FF FF EA 00 00 57 E3 00 40 A0 A1 01 50 A0 A1 25 03 00 BA 08 B0 9D E5 00 00 5B E3 78 FF FF AA 03 C1 8C E2 10 00 9D E5 01 C6 8C E2 0C 00 90 E1 40 03 00 1A 04 20 A0 E1 04 00 A0 E1 05 30 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 68 FF FF EA 08 00 A0 E1 0A 10 A0 E1 08 20 A0 E1 0A 30 A0 E1 F3 FF FF EA 00 00 57 E3 08 40 A0 A1 0A 50 A0 A1 5F FF FF AA FF 05 A0 E3 08 20 A0 E1 0A 30 A0 E1 03 06 80 E2 00 10 A0 E3 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 56 FF FF EA 3C E4 37 7E 9C 75 00 88 ?? ?? ?? ?? ?? ?? ?? ?? 28 7E CA 3F EF 4E 45 4A 4A 86 CD 3F 65 DB C9 93 60 74 D1 3F 01 41 1D A9 55 55 D5 3F 4D 26 8F 51 B6 6D DB 3F FF AB 6F DB 33 33 E3 3F 03 33 33 33 E0 2F 3E BE F5 01 5B 14 01 06 5C E3 FF 2F E0 A3 02 20 42 A2 07 00 00 AA 43 24 A0 E3 01 25 82 E2 00 30 A0 E3 ?? ?? ?? ?? 43 2E E0 E3 00 60 A0 E1 00 C0 A0 E1 03 20 42 E2 FF 34 CC E3 E6 EB A0 E3 0F 36 C3 E3 8E E0 8E E2 FF 75 83 E3 0E 00 53 E1 4C CA 82 E0 03 76 87 E3 08 00 00 DA BB 2A A0 E3 67 2E 82 E2 09 20 82 E2 02 00 53 E1 03 87 A0 D3 01 60 A0 D3 03 00 00 DA 01 C0 8C E2 01 76 47 E2 02 87 A0 E3 00 60 A0 E3 01 30 A0 E1 C8 10 1F E5 07 20 A0 E1 86 61 81 E0 28 20 8D E5 2C 30 8D E5 07 00 A0 E1 03 10 A0 E1 0C 00 96 E8 00 C0 8D E5 ?? ?? ?? ?? 0C 00 96 E8 18 00 8D E5 1C 10 8D E5 28 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 20 A0 E1 FF 05 A0 E3 01 30 A0 E1 03 06 80 E2 00 10 A0 E3 ?? ?? ?? ?? 30 00 8D E5 34 10 8D E5 30 30 8D E2 0C 00 93 E8 18 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 20 00 8D E5 24 10 8D E5 20 30 8D E2 0C 00 93 E8 00 B0 A0 E3 08 20 8D E5 0C 30 8D E5 0C B0 8D E5 08 B0 8D E2 00 0C 9B E8 C7 10 A0 E1 02 12 81 E3 08 20 81 E0 00 30 A0 E3 0A 00 A0 E1 0B 10 A0 E1 02 70 A0 E1 03 80 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 18 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 0C 00 96 E8 18 00 8D E5 1C 10 8D E5 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 28 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 18 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 30 30 8D E2 0C 00 93 E8 ?? ?? ?? ?? 28 00 8D E5 2C 10 8D E5 20 10 8D E2 03 00 91 E8 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 00 70 A0 E1 01 80 A0 E1 ?? ?? ?? ?? 8A 3F 4F E2 0C 00 93 E8 18 00 8D E5 1C 10 8D E5 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 8F 3F 4F E2 0C 00 93 E8 ?? ?? ?? ?? 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? 93 3F 4F E2 0C 00 93 E8 ?? ?? ?? ?? 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? 97 3F 4F E2 0C 00 93 E8 ?? ?? ?? ?? 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? 9B 3F 4F E2 0C 00 93 E8 ?? ?? ?? ?? 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? 9F 3F 4F E2 0C 00 93 E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 18 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 20 30 8D E2 0C 00 93 E8 00 70 A0 E1 01 80 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 28 30 8D E2 0C 00 93 E8 ?? ?? ?? ?? 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? 0A 20 A0 E1 18 00 8D E5 1C 10 8D E5 0B 30 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 01 21 A0 E3 02 27 82 E2 00 30 A0 E3 38 00 8D E5 3C 10 8D E5 ?? ?? ?? ?? 18 30 8D E2 0C 00 93 E8 ?? ?? ?? ?? 0C E0 9D E5 00 70 A0 E1 0E 30 A0 E1 07 20 A0 E1 0A 00 A0 E1 0B 10 A0 E1 0E 80 A0 E1 ?? ?? ?? ?? 07 20 A0 E1 08 30 A0 E1 30 00 8D E5 34 10 8D E5 28 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 01 21 A0 E3 00 A0 A0 E1 01 B0 A0 E1 07 00 A0 E1 08 10 A0 E1 02 27 82 E2 00 30 A0 E3 ?? ?? ?? ?? 38 30 8D E2 0C 00 93 E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 18 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 20 30 8D E2 0C 00 93 E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 00 A0 A0 E1 01 B0 A0 E1 0A 20 A0 E1 0B 30 A0 E1 30 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 70 A0 E1 0C 00 9D E5 11 28 E0 E3 00 80 A0 E1 E3 2D 42 E2 DB 21 42 E2 0E 32 A0 E3 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? FA 3F 4F E2 0C 00 93 E8 28 00 8D E5 2C 10 8D E5 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 30 30 8D E2 0C 00 93 E8 20 00 8D E5 24 10 8D E5 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? FD 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 20 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 10 30 86 E2 0C 00 93 E8 ?? ?? ?? ?? 00 C0 9D E5 18 00 8D E5 1C 10 8D E5 0C 00 A0 E1 ?? ?? ?? ?? 01 B0 A0 E1 20 20 86 E2 06 00 92 E8 00 A0 A0 E1 20 10 8D E5 24 20 8D E5 18 30 8D E2 0C 00 93 E8 28 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 20 30 8D E2 0C 00 93 E8 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? 0C 20 9D E5 02 70 A0 E1 0B 30 A0 E1 0A 20 A0 E1 07 10 A0 E1 00 60 A0 E1 ?? ?? ?? ?? 20 30 8D E2 0C 00 93 E8 ?? ?? ?? ?? 28 30 8D E2 0C 00 93 E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 18 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 A0 A0 E1 01 B0 A0 E1 10 C0 9D E5 01 30 4C E2 09 30 93 E1 4B 01 00 0A FF 05 A0 E3 03 06 80 E2 00 10 A0 E3 10 00 8D E5 14 10 8D E5 00 90 A0 E3 04 20 A0 E1 04 00 A0 E1 05 10 A0 E1 09 30 A0 E1 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? 0A 20 A0 E1 08 00 8D E5 0C 10 8D E5 0B 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 08 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 00 A0 A0 E1 01 B0 A0 E1 04 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 04 20 A0 E1 05 30 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 08 20 8D E5 0C 30 8D E5 08 30 9D E5 BF 24 E0 E3 07 26 42 E2 02 00 53 E1 00 70 A0 E1 01 80 A0 E1 0C 20 9D E5 03 60 A0 E1 E5 00 00 DA BF 34 83 E2 07 36 83 E2 02 30 93 E1 7E 01 00 1A 8D 3F 8F E2 0C 00 93 E8 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 04 20 A0 E1 08 00 8D E5 0C 10 8D E5 05 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 08 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 00 50 E3 02 71 C6 D3 6A 01 00 CA FF 35 A0 E3 02 36 83 E2 03 00 57 E1 00 30 A0 D3 08 30 8D D5 03 C0 A0 D1 D7 00 00 CA 04 20 A0 E1 05 30 A0 E1 0A 00 A0 E1 0B 10 A0 E1 00 C0 8D E5 ?? ?? ?? ?? 67 29 E0 E3 00 70 A0 E3 46 2D 42 E2 07 10 A0 E1 F3 21 42 E2 00 30 A0 E3 00 60 A0 E1 ?? ?? ?? ?? 04 20 A0 E1 00 80 A0 E1 01 90 A0 E1 05 30 A0 E1 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 5A 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 59 3F 8F E2 0C 00 93 E8 00 40 A0 E1 01 50 A0 E1 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 60 A0 E1 01 70 A0 E1 06 20 A0 E1 07 30 A0 E1 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 08 20 A0 E1 09 30 A0 E1 00 40 A0 E1 01 50 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 04 20 A0 E1 00 80 A0 E1 01 90 A0 E1 04 00 A0 E1 05 30 A0 E1 05 10 A0 E1 ?? ?? ?? ?? DC 30 8F E2 0C 00 93 E8 00 60 A0 E1 01 70 A0 E1 ?? ?? ?? ?? D0 30 8F E2 0C 00 93 E8 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? C0 30 8F E2 0C 00 93 E8 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? B0 30 8F E2 0C 00 93 E8 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? A0 30 8F E2 0C 00 93 E8 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 60 A0 E1 01 70 A0 E1 06 20 A0 E1 07 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 01 21 A0 E3 01 B0 A0 E1 00 A0 A0 E1 07 10 A0 E1 06 00 A0 E1 00 30 A0 E3 ?? ?? ?? ?? 1C 00 00 EA 09 C7 EE 3F FD 03 3A DC 47 15 97 3C FE 82 2B 65 42 2E E6 3F EF 39 FA FE 61 5C 20 BE 39 6C A8 0C 69 37 66 3E D0 A4 BE 72 41 BD BB 3E F1 6B D2 C5 6A 56 11 3F 2C DE 25 AF 6C C1 66 3F 93 BD BE 16 55 55 C5 3F 3E 55 55 55 FF CB 90 40 0B AE 54 3E 44 DF 5D F8 55 55 D5 3F 55 55 55 55 47 15 F7 BF FE 82 2B 65 3C E4 37 7E 9C 75 00 88 1F 6E A5 01 59 F3 F8 C2 00 20 A0 E1 01 30 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 08 20 A0 E1 00 60 A0 E1 01 70 A0 E1 04 00 A0 E1 09 30 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 FF 05 A0 E3 01 30 A0 E1 03 06 80 E2 00 10 A0 E3 ?? ?? ?? ?? 08 B0 9D E5 00 30 8B E0 43 2A A0 E1 00 00 52 E3 00 40 A0 E1 03 40 A0 C1 00 C0 9D E5 04 20 A0 C1 01 30 A0 C1 D4 00 00 DA 10 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 F2 FC FF EA 08 10 9D E5 00 00 51 E3 1A FD FF BA 08 00 A0 E1 0A 10 A0 E1 40 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 00 00 57 E3 65 FD FF AA 36 FD FF EA 14 C1 1F E5 02 71 C3 E3 0C 00 57 E1 2D FF FF DA FD 35 83 E2 2F 38 83 E2 0D 3B 83 E2 02 30 93 E1 AF 00 00 1A 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 A7 00 00 AA 47 3A A0 E1 FF 3F 43 E2 02 30 43 E2 01 16 A0 E3 51 13 86 E0 02 31 C1 E3 43 3A A0 E1 FF 3F 43 E2 01 06 A0 E3 03 30 43 E2 01 00 40 E2 50 73 C1 E1 FF 14 C1 E3 0F 16 C1 E3 01 16 81 E3 14 30 63 E2 51 C3 A0 E1 00 00 56 E3 00 C0 6C B2 00 80 A0 E3 0C EA A0 E1 04 00 A0 E1 05 10 A0 E1 07 20 A0 E1 08 30 A0 E1 00 C0 8D E5 08 E0 8D E5 ?? ?? ?? ?? 00 C0 9D E5 00 40 A0 E1 01 50 A0 E1 07 FF FF EA BF 14 A0 E3 0F 16 81 E2 00 20 A0 E3 10 10 8D E5 14 20 8D E5 B2 FE FF EA 00 00 57 E3 2B FD FF AA 02 41 84 E2 AC FC FF EA 07 31 E0 E3 01 36 43 E2 03 00 5C E1 BD FF FF DA FF 35 A0 E3 03 36 83 E2 03 00 5C E1 F1 FC FF CA FF 25 A0 E3 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 8E 2A E0 E3 AB 2E 42 E2 23 21 42 E2 06 32 A0 E3 00 60 A0 E1 01 70 A0 E1 ?? ?? ?? ?? 92 3F 4F E2 0C 00 93 E8 08 00 8D E5 0C 10 8D E5 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 06 20 A0 E1 20 00 8D E5 24 10 8D E5 07 30 A0 E1 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? BF 24 A0 E3 00 A0 A0 E1 01 B0 A0 E1 06 00 A0 E1 07 10 A0 E1 0D 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? A6 3F 4F E2 0C 00 93 E8 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 FF 05 A0 E3 01 30 A0 E1 02 06 80 E2 00 10 A0 E3 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? B5 3F 4F E2 0C 00 93 E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 20 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 A0 A0 E1 01 B0 A0 E1 0A 20 A0 E1 0B 30 A0 E1 08 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 70 A0 E3 08 30 8D E2 0C 00 93 E8 07 10 A0 E1 00 60 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 00 A0 A0 E1 01 B0 A0 E1 4E FE FF EA 00 20 A0 E1 FF 05 A0 E3 01 30 A0 E1 03 06 80 E2 00 10 A0 E3 00 C0 8D E5 ?? ?? ?? ?? 00 C0 9D E5 00 40 A0 E1 01 50 A0 E1 CE FC FF EA DB 3F 4F E2 0C 00 93 E8 10 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 0E 3D 4F E2 0C 00 93 E8 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 3F FC FF EA 00 00 50 E3 00 30 A0 13 10 30 8D 15 66 FC FF 1A 14 00 63 E2 56 30 A0 E1 13 00 56 E1 01 30 03 02 02 30 63 02 10 30 8D 05 00 00 A0 13 10 00 8D 15 4E FC FF EA 10 10 9D E5 01 00 51 E3 2F FC FF 1A 7F FF FF EA F5 3F 4F E2 0C 00 93 E8 10 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 24 30 8F E2 0C 00 93 E8 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 23 FC FF EA 0C 20 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 }
	condition:
		$1
}

rule file_119_0_1 {
	meta:
		name = "truncf"
		size = 60
	strings:
		$1 = { 02 31 C0 E3 A3 3B A0 E1 83 3B A0 E1 C3 3B A0 E1 7F 30 43 E2 16 00 53 E3 00 20 A0 E1 1E FF 2F C1 00 00 53 E3 02 15 A0 A3 01 10 41 A2 51 33 C2 A1 02 01 00 E2 00 00 83 A1 1E FF 2F E1 }
	condition:
		$1
}

rule file_120_0_1 {
	meta:
		name = "rintf"
		size = 256
		refs = "0070 __addsf3 0080 __subsf3"
	strings:
		$1 = { 30 40 2D E9 02 31 C0 E3 A3 CB A0 E1 7F C0 4C E2 16 00 5C E3 04 D0 4D E2 00 10 A0 E1 1C 00 00 CA 00 00 53 E3 17 00 00 0A 00 00 5C E3 00 30 A0 E1 A0 4F A0 E1 1D 00 00 BA 02 25 A0 E3 01 20 42 E2 52 2C A0 E1 00 00 12 E1 0E 00 00 0A A2 20 A0 E1 00 00 12 E1 02 20 C0 11 01 36 A0 13 53 3C 82 11 94 20 9F E5 04 41 92 E7 03 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 00 8D E5 04 10 A0 E1 00 00 9D E5 ?? ?? ?? ?? 00 10 A0 E1 01 00 A0 E1 04 D0 8D E2 30 80 BD E8 02 21 E0 E3 02 25 42 E2 02 00 53 E1 F8 FF FF 9A ?? ?? ?? ?? 00 10 A0 E1 F5 FF FF EA FF 34 C0 E3 02 35 C3 E3 00 10 63 E2 38 30 9F E5 20 2A A0 E1 04 51 93 E7 A1 14 A0 E1 02 2A A0 E1 01 15 01 E2 02 10 81 E1 05 00 A0 E1 ?? ?? ?? ?? 00 00 8D E5 05 10 A0 E1 00 00 9D E5 ?? ?? ?? ?? 02 11 C0 E3 84 1F 81 E1 E2 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_121_0_1 {
	meta:
		name = "exp10f"
		size = 16
		refs = "000c powf"
		altNames = "pow10f"
	strings:
		$1 = { 00 10 A0 E1 41 04 A0 E3 02 06 80 E2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_123_0_1 {
	meta:
		name = "__ieee754_remainder"
		size = 516
		refs = "0060 __adddf3 0074 __ieee754_fmod 00a0 __muldf3 00d0 __divdf3 00e4 fabs 012c __ltdf2 0148 __subdf3 0170 __ledf2 01ac __gtdf2 01d8 __gedf2"
	strings:
		$1 = { F0 4F 2D E9 02 41 C2 E3 08 D0 4D E2 03 C0 94 E1 0C 00 8D E8 00 50 A0 E1 01 60 A0 E1 03 70 A0 E1 00 80 A0 E1 01 90 A0 E1 01 B0 A0 E1 24 00 00 0A 02 11 E0 E3 01 16 41 E2 02 A1 C0 E3 01 00 5A E1 1C 00 00 CA 01 00 54 E1 16 00 00 CA 02 11 E0 E3 02 16 41 E2 01 00 54 E1 08 00 00 CA 03 00 9D E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 00 50 A0 E1 01 60 A0 E1 0B 70 67 E0 0A A0 64 E0 07 70 9A E1 12 00 00 1A 05 00 A0 E1 06 10 A0 E1 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 0A 00 00 EA 02 31 84 E2 01 36 83 E2 07 30 93 E1 F1 FF FF 0A 0C 00 9D E8 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 08 D0 8D E2 F0 8F BD E8 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 00 50 A0 E1 01 60 A0 E1 03 00 9D E8 ?? ?? ?? ?? 02 06 54 E3 00 A0 A0 E1 01 B0 A0 E1 20 00 00 AA 05 20 A0 E1 06 30 A0 E1 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 10 00 00 AA 05 00 A0 E1 06 10 A0 E1 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 00 50 A0 E1 01 60 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 19 00 00 DA 02 81 08 E2 06 10 A0 E1 05 00 28 E0 D1 FF FF EA FF 25 A0 E3 02 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 03 00 8D E8 0C 00 9D E8 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 F0 FF FF DA 05 00 A0 E1 06 10 A0 E1 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? 0C 00 9D E8 00 50 A0 E1 01 60 A0 E1 ?? ?? ?? ?? 00 00 50 E3 E5 FF FF BA 05 00 A0 E1 06 10 A0 E1 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? 00 50 A0 E1 01 60 A0 E1 DD FF FF EA }
	condition:
		$1
}

rule file_124_0_1 {
	meta:
		name = "__ieee754_lgammaf_r"
		size = 2772
		refs = "0084 __subsf3 0098 __mulsf3 00c0 __addsf3 01d0 __divsf3 01fc __ieee754_logf 0230 __fixsfsi 0238 __floatsisf 0394 floorf 03a0 __nesf2 04c8 __kernel_cosf 04dc __eqsf2 04f4 fabsf 051c __ltsf2 055c __kernel_sinf"
	strings:
		$1 = { 02 31 E0 E3 F0 45 2D E9 02 35 43 E2 02 41 C0 E3 03 00 54 E1 01 30 A0 E3 00 50 A0 E1 00 60 A0 E1 01 70 A0 E1 00 30 81 E5 6C 00 00 CA 00 00 54 E3 64 00 00 0A 72 05 54 E3 6D 00 00 BA 00 00 50 E3 5E 00 00 BA FE 05 54 E3 01 01 54 13 00 40 A0 03 53 00 00 0A 07 01 74 E3 71 00 00 CA B4 39 9F E5 03 00 54 E1 EB 01 00 DA 89 39 E0 E3 67 3D 43 E2 A3 31 43 E2 03 00 54 E1 84 01 00 DA 05 10 A0 E1 01 01 A0 E3 ?? ?? ?? ?? 00 70 A0 E3 00 50 A0 E1 05 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? BF 14 A0 E3 00 40 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 68 19 9F E5 00 A0 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 5C 19 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 50 19 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? DF 1A E0 E3 36 1D 41 E2 71 13 41 E2 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? F6 15 A0 E3 9F 1A 81 E2 01 10 81 E2 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 14 19 9F E5 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 04 19 9F E5 00 50 A0 E1 04 00 A0 E1 ?? ?? ?? ?? F8 18 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? EC 18 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? E0 18 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? D4 18 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? C8 18 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 07 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 00 00 56 E3 0A 00 00 AA 04 10 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 05 00 00 EA 4B 04 54 E3 6E 00 00 BA FE 05 A0 E3 00 10 A0 E3 ?? ?? ?? ?? 00 40 A0 E1 04 00 A0 E1 F0 85 BD E8 00 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 04 00 A0 E1 F0 85 BD E8 00 00 50 E3 03 00 00 BA ?? ?? ?? ?? 02 41 80 E2 04 00 A0 E1 F0 85 BD E8 00 30 E0 E3 02 01 80 E2 00 30 81 E5 ?? ?? ?? ?? 02 41 80 E2 EC FF FF EA 41 04 54 E3 DD 00 00 AA 05 00 A0 E1 ?? ?? ?? ?? 00 70 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 3F 14 A0 E3 00 50 A0 E1 ?? ?? ?? ?? C7 14 E0 E3 FA 18 41 E2 00 40 A0 E1 98 10 41 E2 05 00 A0 E1 ?? ?? ?? ?? D0 17 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? F3 15 A0 E3 69 19 81 E2 E4 10 81 E2 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? AC 17 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? A0 17 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 94 17 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 5C 17 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 78 17 9F E5 00 A0 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 6C 17 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 60 17 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? F6 1E A0 E3 E3 12 81 E2 E3 16 81 E2 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 3C 17 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 30 17 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 03 70 47 E2 00 40 A0 E1 04 00 57 E3 07 F1 9F 97 8C FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FA 05 54 E3 35 01 00 BA 02 81 80 E2 08 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 8A 01 00 1A 08 00 A0 E1 4B 14 A0 E3 ?? ?? ?? ?? 01 A0 00 E2 0A 00 A0 E1 ?? ?? ?? ?? 00 80 A0 E1 0A 01 A0 E1 06 00 50 E3 00 F1 9F 97 6E 00 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 01 11 A0 E3 05 00 A0 E1 03 15 81 E2 ?? ?? ?? ?? 00 70 A0 E1 01 11 A0 E3 0A 16 81 E2 05 00 A0 E1 ?? ?? ?? ?? 07 10 A0 E1 ?? ?? ?? ?? 00 70 A0 E1 01 11 A0 E3 02 15 81 E2 05 00 A0 E1 ?? ?? ?? ?? 07 10 A0 E1 ?? ?? ?? ?? 00 70 A0 E1 01 11 A0 E3 01 15 81 E2 05 00 A0 E1 ?? ?? ?? ?? 07 10 A0 E1 ?? ?? ?? ?? 00 70 A0 E1 01 11 A0 E3 05 00 A0 E1 ?? ?? ?? ?? 07 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 46 FF FF EA FE 75 A0 E3 E4 FF FF EA FE 75 A0 E3 E9 FF FF EA FE 75 A0 E3 EE FF FF EA FE 75 A0 E3 D7 FF FF EA FF 15 A0 E3 08 00 A0 E1 ?? ?? ?? ?? 49 18 A0 E3 FD 1E 81 E2 2D 11 81 E2 ?? ?? ?? ?? 00 10 A0 E3 ?? ?? ?? ?? 02 01 80 E2 02 A1 80 E2 0A 00 A0 E1 00 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 37 FF FF 0A 0A 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 00 10 A0 E1 49 08 A0 E3 FD 0E 80 E2 2D 01 80 E2 ?? ?? ?? ?? ?? ?? ?? ?? 00 10 A0 E3 00 80 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 00 30 97 A5 00 30 E0 B3 00 30 87 E5 02 51 85 E2 C2 FE FF EA 08 10 A0 E1 FE 05 A0 E3 ?? ?? ?? ?? 49 18 A0 E3 FD 1E 81 E2 2D 11 81 E2 ?? ?? ?? ?? 00 10 A0 E3 00 20 A0 E3 ?? ?? ?? ?? DA FF FF EA 08 10 A0 E1 3F 04 A0 E3 ?? ?? ?? ?? 49 18 A0 E3 FD 1E 81 E2 2D 11 81 E2 ?? ?? ?? ?? 00 10 A0 E3 ?? ?? ?? ?? D0 FF FF EA 08 00 A0 E1 EB FF FF EA 08 00 A0 E1 01 11 A0 E3 ?? ?? ?? ?? E7 FF FF EA A3 34 E0 E3 02 35 43 E2 03 00 54 E1 A3 00 00 CA 05 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 00 A0 A0 E1 FE 05 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 00 70 A0 E1 ?? ?? ?? ?? 3F 14 A0 E3 00 40 A0 E1 05 00 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 00 50 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 5C 14 9F E5 00 50 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 50 14 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 44 14 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? CF 1E A0 E3 D3 12 81 E2 A5 16 81 E2 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 20 14 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 14 14 9F E5 ?? ?? ?? ?? 07 10 A0 E1 ?? ?? ?? ?? C1 14 E0 E3 A6 19 41 E2 E2 10 41 E2 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 C4 FE FF EA E4 33 9F E5 03 00 54 E1 7A 00 00 DA 11 17 E0 E3 E9 1C 41 E2 05 00 A0 E1 F3 11 41 E2 ?? ?? ?? ?? 00 70 A0 E3 00 50 A0 E1 05 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 00 A0 A0 E1 ?? ?? ?? ?? A8 13 9F E5 00 40 A0 E1 ?? ?? ?? ?? A0 13 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 94 13 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 88 13 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 7C 13 9F E5 ?? ?? ?? ?? 00 10 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 16 1C E0 E3 23 11 41 E2 00 A0 A0 E1 65 16 41 E2 04 00 A0 E1 ?? ?? ?? ?? 3A 14 A0 E3 D3 1A 81 E2 85 10 81 E2 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 3C 13 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 30 13 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 24 13 9F E5 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 14 13 9F E5 00 50 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 08 13 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 71 13 E0 E3 8E 18 41 E2 22 1B 41 E2 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? E4 12 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? D8 12 9F E5 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 BC 02 9F E5 ?? ?? ?? ?? 00 10 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? AC 12 9F E5 ?? ?? ?? ?? 07 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 62 FE FF EA 05 00 A0 E1 ?? ?? ?? ?? 90 32 9F E5 03 00 54 E1 02 71 80 E2 61 00 00 DA 05 10 A0 E1 FE 05 A0 E3 ?? ?? ?? ?? 00 50 A0 E1 12 FE FF EA 05 00 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 4F FE FF EA 49 18 A0 E3 FD 1E 81 E2 2D 11 81 E2 ?? ?? ?? ?? 00 10 A0 E3 00 20 A0 E3 ?? ?? ?? ?? 00 A0 A0 E1 12 FF FF EA 05 00 A0 E1 FE 15 A0 E3 ?? ?? ?? ?? 00 70 A0 E3 00 50 A0 E1 BF 14 A0 E3 05 00 A0 E1 ?? ?? ?? ?? 0C 12 9F E5 00 40 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 12 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? F4 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 45 18 E0 E3 C5 1C 41 E2 63 11 41 E2 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 3F 14 A0 E3 22 18 81 E2 F4 10 81 E2 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 18 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? A8 11 9F E5 00 A0 A0 E1 05 00 A0 E1 ?? ?? ?? ?? C2 14 E0 E3 AA 19 41 E2 D5 1E 41 E2 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 83 11 E0 E3 BB 18 41 E2 01 1A 41 E2 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 83 1A A0 E3 92 1E 81 E2 35 11 81 E2 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 1D 18 A0 E3 BA 1D 81 E2 F9 11 81 E2 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 07 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 FA FD FF EA 0C 31 9F E5 03 00 54 E1 B5 FF FF DA 05 00 A0 E1 00 11 9F E5 ?? ?? ?? ?? 00 50 A0 E1 37 FF FF EA 3F 14 A0 E3 08 00 A0 E1 ?? ?? ?? ?? 00 80 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 ?? ?? ?? ?? 01 11 A0 E3 02 15 81 E2 00 80 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 6C FE FF EA 66 66 66 3F A2 83 D3 37 67 97 67 39 A1 54 9C 3A 3F 23 9E 3D 75 2C 3C 38 45 84 E2 38 34 B6 05 3A C6 6E 3D 3B 15 99 A8 3C 66 1A A5 3E B4 35 F1 3A E6 DC 15 3E 7A CC A6 3E 5A 24 5C 3E BD D7 F5 36 D6 EE 4B 3A 54 BF 98 3C C5 D0 38 3F 3B 2D B2 3F E8 C4 D5 BA D2 3D 5B 3A 5C 06 1C 3A 61 0B 36 3B AB AA AA 3D 1F A6 9D 3F 6B 7B A5 39 76 F4 B7 3A 07 E7 C7 3B 47 4D 06 3D 5E B9 F7 3E 99 16 14 3B FE FC 28 3C 15 5A 84 3D 27 F9 A3 B9 67 F8 66 3A 3D 37 93 3C 3C 21 17 3E 52 1C E6 31 CD CD F8 3D 1F 4A 3B 3F 5E 3C 5B 3C 78 75 6A 3E B2 4B 7A 3F DB D5 52 3B 07 33 6D 3E 0C 5B EC 3E }
	condition:
		$1
}

rule file_125_0_1 {
	meta:
		name = "trunc"
		size = 204
		refs = "0084 __adddf3"
	strings:
		$1 = { 02 31 C0 E3 23 3A A0 E1 03 3A A0 E1 43 3A A0 E1 FF 3F 43 E2 03 30 43 E2 13 00 53 E3 70 48 2D E9 01 C0 A0 E1 00 B0 A0 E1 00 40 A0 E1 01 50 A0 E1 01 60 A0 E1 0C 00 00 CA 00 00 53 E3 02 01 00 E2 1B 00 00 BA 01 16 A0 E3 01 10 41 E2 51 33 CB E1 00 30 83 E1 03 B0 A0 E1 00 30 A0 E3 03 C0 A0 E1 0B 00 A0 E1 0C 10 A0 E1 70 88 BD E8 33 00 53 E3 07 00 00 DA 01 0B 53 E3 F8 FF FF 1A 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 00 B0 A0 E1 01 C0 A0 E1 F2 FF FF EA 14 30 43 E2 00 20 E0 E3 32 23 C1 E1 00 B0 A0 E1 02 C0 A0 E1 0B 00 A0 E1 0C 10 A0 E1 70 88 BD E8 00 20 A0 E3 00 B0 A0 E1 02 C0 A0 E1 0B 00 A0 E1 0C 10 A0 E1 70 88 BD E8 }
	condition:
		$1
}

rule file_126_0_1 {
	meta:
		name = "__ieee754_scalb"
		size = 368
		refs = "0014 __isnand 0030 __muldf3 0054 finite 0070 __gtdf2 008c __divdf3 009c rint 00a8 __nedf2 00f0 __ltdf2 0104 __fixdfsi 0118 scalbn 012c __subdf3"
	strings:
		$1 = { F0 40 2D E9 02 50 A0 E1 03 40 A0 E1 00 60 A0 E1 01 70 A0 E1 ?? ?? ?? ?? 00 00 50 E3 05 00 00 0A 05 20 A0 E1 04 30 A0 E1 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? F0 80 BD E8 05 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 F4 FF FF 1A 05 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 0C 00 00 1A 05 00 A0 E1 04 10 A0 E1 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 E8 FF FF CA 02 21 85 E2 04 30 A0 E1 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? F0 80 BD E8 05 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 05 20 A0 E1 04 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 19 00 00 1A 01 21 A0 E3 EF 28 82 E2 05 00 A0 E1 04 10 A0 E1 BD 2C 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 1F 00 00 CA 03 21 A0 E3 EF 28 82 E2 05 00 A0 E1 04 10 A0 E1 BD 2C 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 10 00 00 BA 04 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 07 10 A0 E1 00 20 A0 E1 06 00 A0 E1 F0 40 BD E8 ?? ?? ?? ?? 05 20 A0 E1 04 30 A0 E1 05 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? F0 80 BD E8 FD 2C E0 E3 06 00 A0 E1 07 10 A0 E1 E7 20 42 E2 F0 40 BD E8 ?? ?? ?? ?? FD 2C A0 E3 06 00 A0 E1 07 10 A0 E1 E8 20 82 E2 F0 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_127_0_1 {
	meta:
		name = "asinf"
		size = 260
		refs = "000c __ieee754_asinf 0028 isnanf 0044 fabsf 004c __gtsf2 0070 __extendsfdf2 0090 nan 00ac matherr 00cc __truncdfsf2 00d8 __errno 00f8 __fdlib_version"
	strings:
		$1 = { F0 40 2D E9 24 D0 4D E2 00 60 A0 E1 ?? ?? ?? ?? E0 50 9F E5 00 30 95 E5 01 00 73 E3 00 40 A0 E1 03 00 00 0A 06 00 A0 E1 ?? ?? ?? ?? 00 70 50 E2 02 00 00 0A 04 00 A0 E1 24 D0 8D E2 F0 80 BD E8 06 00 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 00 00 50 E3 F6 FF FF DA 01 30 A0 E3 00 30 8D E5 94 30 9F E5 06 00 A0 E1 04 30 8D E5 20 70 8D E5 ?? ?? ?? ?? 00 30 A0 E1 01 40 A0 E1 7C 00 9F E5 08 30 8D E5 0C 40 8D E5 10 30 8D E5 14 40 8D E5 ?? ?? ?? ?? 00 30 95 E5 02 00 53 E3 18 00 8D E5 1C 10 8D E5 0B 00 00 0A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 07 00 00 0A 20 30 9D E5 00 00 53 E3 08 00 00 1A 18 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 40 A0 E1 D6 FF FF EA ?? ?? ?? ?? 21 30 A0 E3 00 30 80 E5 F3 FF FF EA ?? ?? ?? ?? 20 30 9D E5 00 30 80 E5 F2 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_132_0_1 {
	meta:
		name = "acosf"
		size = 260
		refs = "000c __ieee754_acosf 0028 isnanf 0044 fabsf 004c __gtsf2 0070 __extendsfdf2 0090 nan 00ac matherr 00cc __truncdfsf2 00d8 __errno 00f8 __fdlib_version"
	strings:
		$1 = { F0 40 2D E9 24 D0 4D E2 00 60 A0 E1 ?? ?? ?? ?? E0 50 9F E5 00 30 95 E5 01 00 73 E3 00 40 A0 E1 03 00 00 0A 06 00 A0 E1 ?? ?? ?? ?? 00 70 50 E2 02 00 00 0A 04 00 A0 E1 24 D0 8D E2 F0 80 BD E8 06 00 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 00 00 50 E3 F6 FF FF DA 01 30 A0 E3 00 30 8D E5 94 30 9F E5 06 00 A0 E1 04 30 8D E5 20 70 8D E5 ?? ?? ?? ?? 00 30 A0 E1 01 40 A0 E1 7C 00 9F E5 08 30 8D E5 0C 40 8D E5 10 30 8D E5 14 40 8D E5 ?? ?? ?? ?? 00 30 95 E5 02 00 53 E3 18 00 8D E5 1C 10 8D E5 0B 00 00 0A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 07 00 00 0A 20 30 9D E5 00 00 53 E3 08 00 00 1A 18 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 40 A0 E1 D6 FF FF EA ?? ?? ?? ?? 21 30 A0 E3 00 30 80 E5 F3 FF FF EA ?? ?? ?? ?? 20 30 9D E5 00 30 80 E5 F2 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_128_0_1 {
	meta:
		name = "cabs"
		size = 32
		refs = "001c hypot"
	strings:
		$1 = { 10 D0 4D E2 0D C0 A0 E1 0F 00 8C E8 03 00 9D E8 08 30 8D E2 0C 00 93 E8 10 D0 8D E2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_129_0_1 {
	meta:
		name = "__kernel_tanf"
		size = 868
		refs = "0024 __fixsfsi 0050 __divsf3 0084 __subsf3 00a0 __addsf3 00b4 __mulsf3 0298 __floatsisf 0314 fabsf"
	strings:
		$1 = { F0 4F 2D E9 02 51 C0 E3 C6 05 55 E3 04 D0 4D E2 00 40 A0 E1 00 70 A0 E1 01 60 A0 E1 02 B0 A0 E1 0D 00 00 AA ?? ?? ?? ?? 00 00 50 E3 1E 00 00 1A 01 30 8B E2 05 30 93 E1 B4 00 00 0A 01 00 5B E3 90 00 00 0A BF 04 A0 E3 04 10 A0 E1 02 05 80 E2 ?? ?? ?? ?? 00 40 A0 E1 8A 00 00 EA C8 32 9F E5 03 00 55 E1 10 00 00 DA 00 00 50 E3 02 41 80 B2 97 01 E0 E3 B6 08 40 E2 02 61 81 B2 0F 0A 40 E2 04 10 A0 E1 ?? ?? ?? ?? 06 10 A0 E1 00 40 A0 E1 98 02 9F E5 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 60 A0 E3 00 40 A0 E1 04 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 00 A0 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 00 80 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 58 12 9F E5 00 90 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 4C 12 9F E5 ?? ?? ?? ?? 08 10 A0 E1 ?? ?? ?? ?? 40 12 9F E5 ?? ?? ?? ?? 08 10 A0 E1 ?? ?? ?? ?? 34 12 9F E5 ?? ?? ?? ?? 08 10 A0 E1 ?? ?? ?? ?? 28 12 9F E5 ?? ?? ?? ?? 08 10 A0 E1 ?? ?? ?? ?? 1C 12 9F E5 ?? ?? ?? ?? 18 12 9F E5 00 30 A0 E1 08 00 A0 E1 00 30 8D E5 ?? ?? ?? ?? E2 15 A0 E3 57 19 81 E2 7A 10 81 E2 ?? ?? ?? ?? 08 10 A0 E1 ?? ?? ?? ?? F0 11 9F E5 ?? ?? ?? ?? 08 10 A0 E1 ?? ?? ?? ?? E4 11 9F E5 ?? ?? ?? ?? 08 10 A0 E1 ?? ?? ?? ?? D8 11 9F E5 ?? ?? ?? ?? 08 10 A0 E1 ?? ?? ?? ?? CC 11 9F E5 ?? ?? ?? ?? 0A 10 A0 E1 ?? ?? ?? ?? 00 30 9D E5 00 10 A0 E1 03 00 A0 E1 ?? ?? ?? ?? 09 10 A0 E1 ?? ?? ?? ?? 06 10 A0 E1 ?? ?? ?? ?? 0A 10 A0 E1 ?? ?? ?? ?? 06 10 A0 E1 ?? ?? ?? ?? 90 11 9F E5 00 60 A0 E1 09 00 A0 E1 ?? ?? ?? ?? 06 10 A0 E1 ?? ?? ?? ?? 00 80 A0 E1 08 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 34 31 9F E5 03 00 55 E1 00 60 A0 E1 24 00 00 CA 01 00 5B E3 00 40 A0 01 1E 00 00 0A 00 10 A0 E1 FF 6E C0 E3 BF 04 A0 E3 02 05 80 E2 ?? ?? ?? ?? 0F 60 C6 E3 04 10 A0 E1 00 50 A0 E1 FF 4E C0 E3 06 00 A0 E1 ?? ?? ?? ?? 0F 40 C4 E3 00 10 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 00 70 A0 E1 06 00 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 04 00 A0 E1 04 D0 8D E2 F0 8F BD E8 0B 00 A0 E1 ?? ?? ?? ?? 06 10 A0 E1 00 50 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 00 A0 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 08 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 03 11 A0 E3 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 47 7F A0 E1 00 40 A0 E1 02 00 07 E2 01 00 60 E2 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 DD FF FF EA 04 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 FE 05 A0 E3 ?? ?? ?? ?? 00 40 A0 E1 D6 FF FF EA 3F A1 2C 3F 68 21 22 33 5F AE 9B B7 45 F4 A3 38 C8 26 1A 3A 16 69 6B 3B A4 27 B3 3C 89 88 08 3E 84 53 D9 37 B9 37 81 39 48 DE BE 3A 1F 37 11 3C D1 0D 5D 3D AB AA AA 3E }
	condition:
		$1
}

rule file_131_0_1 {
	meta:
		name = "__kernel_sin"
		size = 532
		refs = "002c __fixdfsi 0048 __muldf3 0084 __subdf3 009c __adddf3"
	strings:
		$1 = { F0 4F 2D E9 02 C1 C0 E3 F9 05 5C E3 10 D0 4D E2 00 40 A0 E1 01 50 A0 E1 00 60 A0 E1 01 70 A0 E1 02 A0 A0 E1 03 B0 A0 E1 02 00 00 AA ?? ?? ?? ?? 00 00 50 E3 53 00 00 0A 04 20 A0 E1 05 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 00 60 A0 E1 01 70 A0 E1 ?? ?? ?? ?? 5F 3F 8F E2 0C 00 93 E8 00 80 A0 E1 01 90 A0 E1 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 5A 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? 56 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? 52 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? 4E 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 34 30 9D E5 00 00 53 E3 03 00 8D E8 2D 00 00 0A FF 25 A0 E3 02 26 82 E2 00 30 A0 E3 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 0C 00 9D E8 08 00 8D E5 0C 10 8D E5 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 08 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? C8 30 8F E2 0C 00 93 E8 00 60 A0 E1 01 70 A0 E1 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 04 00 A0 E1 05 10 A0 E1 10 D0 8D E2 F0 8F BD E8 00 20 A0 E1 01 30 A0 E1 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 58 30 8F E2 0C 00 93 E8 ?? ?? ?? ?? 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 E8 FF FF EA 3A D9 E5 3D 7C D5 CF 5A E6 E5 5A 3E EB 9C 2B 8A E3 1D C7 3E 7D FE B1 57 A0 01 2A 3F D5 61 C1 19 11 11 81 3F A6 F8 10 11 55 55 C5 3F 49 55 55 55 }
	condition:
		$1
}

rule file_133_0_1 {
	meta:
		name = "sincos"
		size = 48
		refs = "0014 sin 0024 cos"
	strings:
		$1 = { F0 40 2D E9 02 40 A0 E1 03 50 A0 E1 00 60 A0 E1 01 70 A0 E1 ?? ?? ?? ?? 03 00 84 E8 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 03 00 85 E8 F0 80 BD E8 }
	condition:
		$1
}

rule file_134_1_1 {
	meta:
		name = "qone"
		size = 504
		refs = "0064 __muldf3 007c __divdf3 009c __adddf3"
	strings:
		$1 = { BF 34 E0 E3 02 21 C0 E3 0E 36 43 E2 03 00 52 E1 F0 4F 2D E9 00 80 A0 E1 01 90 A0 E1 6E 00 00 CA 12 38 A0 E3 BA 3D 83 E2 29 31 83 E2 03 00 52 E1 66 00 00 CA 6D 3A A0 E3 B6 3E 83 E2 31 31 83 E2 03 00 52 E1 9C 61 9F D5 9C 61 9F C5 30 70 86 D2 30 70 86 C2 08 20 A0 E1 09 30 A0 E1 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 FF 05 A0 E3 01 30 A0 E1 03 06 80 E2 00 10 A0 E3 ?? ?? ?? ?? 28 30 87 E2 0C 00 93 E8 00 40 A0 E1 01 50 A0 E1 ?? ?? ?? ?? 20 30 87 E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 18 30 87 E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 10 30 87 E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 08 30 87 E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 0C 00 97 E8 ?? ?? ?? ?? 28 30 86 E2 0C 00 93 E8 00 A0 A0 E1 01 B0 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 20 30 86 E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 18 30 86 E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 10 30 86 E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 08 30 86 E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 0C 00 96 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? FF 25 A0 E3 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? FF 25 A0 E3 06 27 82 E2 00 30 A0 E3 ?? ?? ?? ?? 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? F0 8F BD E8 18 60 9F E5 30 70 86 E2 9D FF FF EA 10 60 9F E5 30 70 86 E2 9A FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_134_2_1 {
	meta:
		name = "__ieee754_j1"
		size = 1040
		refs = "0040 __divdf3 0050 fabs 007c __adddf3 008c __gtdf2 00ac __muldf3 00e4 __subdf3 0204 sin 0218 cos 0254 __ieee754_sqrt"
	strings:
		$1 = { F0 4F 2D E9 02 31 E0 E3 01 36 43 E2 02 61 C0 E3 03 00 56 E1 18 D0 4D E2 00 40 A0 E1 01 50 A0 E1 00 70 A0 E1 01 80 A0 E1 08 00 00 DA 00 20 A0 E1 FF 05 A0 E3 01 30 A0 E1 03 06 80 E2 00 10 A0 E3 ?? ?? ?? ?? 01 40 A0 E1 18 D0 8D E2 F0 8F BD E8 ?? ?? ?? ?? 07 01 76 E3 00 80 A0 E1 01 90 A0 E1 67 00 00 CA F9 05 56 E3 11 00 00 AA D3 3F 8F E2 0C 00 93 E8 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? FF 25 A0 E3 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 06 00 00 DA FF 25 A0 E3 04 00 A0 E1 05 10 A0 E1 02 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? E3 FF FF EA 04 20 A0 E1 05 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? BE 3F 8F E2 0C 00 93 E8 00 60 A0 E1 01 70 A0 E1 ?? ?? ?? ?? BB 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? B7 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? FE 25 A0 E3 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? A9 3F 8F E2 0C 00 93 E8 00 80 A0 E1 01 90 A0 E1 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 29 3E 8F E2 0C 00 93 E8 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? 0A 3D 8F E2 0C 00 93 E8 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? 27 3E 8F E2 0C 00 93 E8 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? 26 3E 8F E2 0C 00 93 E8 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? FF 25 A0 E3 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? FF 25 A0 E3 00 60 A0 E1 01 70 A0 E1 04 00 A0 E1 05 10 A0 E1 02 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? 8F FF FF EA ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 00 A0 A0 E1 01 B0 A0 E1 0B 30 A0 E1 04 00 A0 E1 05 10 A0 E1 0A 20 A0 E1 ?? ?? ?? ?? 02 31 E0 E3 02 36 43 E2 03 00 56 E1 03 00 8D E8 0E 00 00 DA 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 6A 3F 8F E2 0C 00 93 E8 00 40 A0 E1 01 50 A0 E1 03 00 9D E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 00 00 57 E3 02 01 80 B2 6E FF FF EA 08 20 A0 E1 09 30 A0 E1 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 0A 20 A0 E1 10 00 8D E5 14 10 8D E5 0B 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 34 00 00 DA 0A 20 A0 E1 0B 30 A0 E1 02 01 84 E2 05 10 A0 E1 ?? ?? ?? ?? 08 00 8D E5 0C 10 8D E5 08 30 8D E2 0C 00 93 E8 10 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 03 00 8D E8 12 03 56 E3 CF FF FF CA 08 00 A0 E1 09 10 A0 E1 4A FE FF EB 00 40 A0 E1 01 50 A0 E1 08 00 A0 E1 09 10 A0 E1 B6 FE FF EB 00 A0 A0 E1 01 B0 A0 E1 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 04 20 A0 E1 00 80 A0 E1 01 90 A0 E1 05 30 A0 E1 03 00 9D E8 ?? ?? ?? ?? 0A 20 A0 E1 00 40 A0 E1 01 50 A0 E1 0B 30 A0 E1 08 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 78 30 8F E2 0C 00 93 E8 ?? ?? ?? ?? 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? B5 FF FF EA 10 10 8D E2 03 00 91 E8 0C 00 9D E8 ?? ?? ?? ?? 08 00 8D E5 0C 10 8D E5 D0 FF FF EA 3C E4 37 7E 9C 75 00 88 FA AA 6A 3E D9 0B CA 46 C6 C5 F0 3E 68 96 16 BA 9F 0D 57 3F 61 2C 47 98 CF 2A AB 3D D8 7E B9 CF 88 AC 35 3E 2C FF 7D C9 F8 BF B3 3E 98 84 3F 33 56 5F 28 3F 64 F6 CD B9 0B 9D 93 3F 53 7E 63 12 D7 0D E2 3F 6D 9B 42 50 }
	condition:
		$1
}

rule file_134_3_1 {
	meta:
		name = "__ieee754_y1"
		size = 1172
		refs = "0068 __divdf3 0098 __muldf3 00a4 __adddf3 0104 __subdf3 01f4 __ieee754_j1 0208 __ieee754_log 0278 sin 028c cos 02c8 __ieee754_sqrt 0348 __gtdf2"
	strings:
		$1 = { F0 4F 2D E9 02 31 E0 E3 01 36 43 E2 02 61 C0 E3 03 00 56 E1 10 D0 4D E2 00 40 A0 E1 01 50 A0 E1 00 70 A0 E1 01 80 A0 E1 01 30 A0 E1 17 00 00 CA 03 30 96 E1 0D 00 00 0A 00 00 50 E3 AC 00 00 BA 07 01 76 E3 8B 00 00 CA F2 35 A0 E3 01 36 83 E2 03 00 56 E1 1A 00 00 CA 00 20 A0 E1 01 30 A0 E1 E3 1F 8F E2 03 00 91 E8 ?? ?? ?? ?? 05 00 00 EA BF 04 A0 E3 0F 06 80 E2 00 10 A0 E3 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 10 D0 8D E2 F0 8F BD E8 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 FF 05 A0 E3 01 30 A0 E1 03 06 80 E2 00 10 A0 E3 ?? ?? ?? ?? F0 FF FF EA 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? C9 3F 8F E2 0C 00 93 E8 00 60 A0 E1 01 70 A0 E1 ?? ?? ?? ?? C6 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? C2 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? BE 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? BA 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? B9 3F 8F E2 0C 00 93 E8 00 80 A0 E1 01 90 A0 E1 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 2D 3E 8F E2 0C 00 93 E8 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? 0B 3D 8F E2 0C 00 93 E8 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? 2B 3E 8F E2 0C 00 93 E8 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? 2A 3E 8F E2 0C 00 93 E8 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? FF 25 A0 E3 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 00 80 A0 E1 01 90 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 60 A0 E1 01 70 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 00 60 A0 E1 BF 04 A0 E3 01 70 A0 E1 04 20 A0 E1 05 30 A0 E1 0F 06 80 E2 00 10 A0 E3 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 1F 3E 8F E2 0C 00 93 E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 83 FF FF EA ?? ?? ?? ?? 00 70 A0 E1 01 80 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 A0 A0 E1 01 B0 A0 E1 0B 30 A0 E1 02 01 87 E2 08 10 A0 E1 0A 20 A0 E1 ?? ?? ?? ?? 02 31 E0 E3 02 36 43 E2 03 00 56 E1 03 00 8D E8 12 00 00 DA 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 03 00 9D E8 5D 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 64 FF FF EA 00 00 A0 E3 00 10 A0 E3 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 5E FF FF EA 04 20 A0 E1 05 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 0A 20 A0 E1 08 00 8D E5 0C 10 8D E5 0B 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 41 00 00 DA 08 10 8D E2 03 00 91 E8 0C 00 9D E8 ?? ?? ?? ?? 00 A0 A0 E1 01 B0 A0 E1 12 03 56 E3 D2 FF FF CA 04 00 A0 E1 05 10 A0 E1 2C FD FF EB 00 60 A0 E1 01 70 A0 E1 04 00 A0 E1 05 10 A0 E1 98 FD FF EB 00 80 A0 E1 01 90 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 00 40 A0 E1 01 50 A0 E1 03 00 9D E8 ?? ?? ?? ?? 08 20 A0 E1 00 60 A0 E1 01 70 A0 E1 09 30 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? B8 FF FF EA 30 5F E4 BF 83 C8 C9 6D 00 AC 78 BE B8 05 91 56 03 AB F8 3E 8E B8 A6 8F E5 55 5F 3F 0F F5 44 48 C7 D3 A9 3F D1 2C 29 76 66 18 C9 3F 8A BC 3C 14 39 50 B2 3D 2A 77 CA DA 1D BF 3A 3E 86 9A A6 5B 5A C0 B6 3E A6 8C 4E 89 89 8C 2A 3F 64 77 25 6C 0D 65 94 3F F0 A9 4D 3F 30 5F E4 3F 83 C8 C9 6D D7 0D E2 3F 6D 9B 42 50 0A 20 A0 E1 0B 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 A0 A0 E1 01 B0 A0 E1 0A 20 A0 E1 08 10 8D E2 03 00 91 E8 0B 30 A0 E1 ?? ?? ?? ?? 03 00 8D E8 B5 FF FF EA }
	condition:
		$1
}

rule file_136_0_1 {
	meta:
		name = "cbrtf"
		size = 304
		refs = "0058 __mulsf3 0060 __divsf3 0078 __addsf3"
	strings:
		$1 = { F0 40 2D E9 02 31 E0 E3 02 51 00 E2 00 40 25 E0 02 35 43 E2 03 00 54 E1 00 10 A0 E1 30 00 00 CA 00 00 54 E3 2C 00 00 0A 02 05 54 E3 04 60 A0 E1 2F 00 00 BA E8 30 9F E5 94 23 C3 E0 C4 4F 43 E0 A9 45 84 E2 11 48 84 E2 67 4D 84 E2 32 40 84 E2 04 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 06 10 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 3F 14 A0 E3 AF 1A 81 E2 8B 1E 81 E2 ?? ?? ?? ?? FE 15 A0 E3 35 18 81 E2 75 1E 81 E2 00 70 A0 E1 ?? ?? ?? ?? 00 60 A0 E1 CB 08 E0 E3 71 0C 40 E2 07 10 A0 E1 39 01 40 E2 ?? ?? ?? ?? 00 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 C9 09 E0 E3 92 0E 40 E2 13 01 40 E2 ?? ?? ?? ?? 58 10 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 00 10 85 E1 01 00 A0 E1 F0 80 BD E8 ?? ?? ?? ?? 00 10 A0 E1 01 00 A0 E1 F0 80 BD E8 4B 14 A0 E3 04 00 A0 E1 02 15 81 E2 ?? ?? ?? ?? 20 40 9F E5 90 24 84 E0 A4 40 A0 E1 99 45 84 E2 11 48 84 E2 67 4D 84 E2 32 40 84 E2 CA FF FF EA 56 55 55 55 6E DB B6 3E AB AA AA AA }
	condition:
		$1
}

rule file_137_0_1 {
	meta:
		name = "__ieee754_lgamma_r"
		size = 4292
		refs = "00b8 __subdf3 00dc __muldf3 0124 __adddf3 0294 __divdf3 02e0 __ieee754_log 0364 floor 0380 __nedf2 03c8 __kernel_sin 03e4 __eqdf2 0404 fabs 0438 __ltdf2 0544 __fixdfsi 054c __floatsidf 0d10 __kernel_cos"
	strings:
		$1 = { F0 4F 2D E9 02 31 E0 E3 01 36 43 E2 02 41 C0 E3 03 00 54 E1 01 30 A0 E3 00 30 82 E5 18 D0 4D E2 00 50 A0 E1 01 60 A0 E1 00 70 A0 E1 02 80 A0 E1 01 30 A0 E1 9D 00 00 CA 03 30 94 E1 01 A0 A0 E1 8E 00 00 0A 31 33 E0 E3 07 36 43 E2 03 00 54 E1 9E 00 00 DA 00 00 50 E3 84 00 00 BA 03 31 84 E2 01 36 83 E2 0A 30 93 E1 A0 00 00 0A 03 31 84 E2 0A 30 93 E1 9D 00 00 0A 07 01 74 E3 2A 01 00 CA 13 38 E0 E3 33 3C 43 E2 CF 31 43 E2 03 00 54 E1 D7 02 00 DA 11 39 E0 E3 B3 3E 43 E2 37 31 43 E2 03 00 54 E1 48 02 00 DA 05 20 A0 E1 06 30 A0 E1 01 01 A0 E3 00 10 A0 E3 ?? ?? ?? ?? 00 80 A0 E3 08 90 A0 E1 00 A0 A0 E1 01 B0 A0 E1 0A 20 A0 E1 0B 30 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? BF 24 A0 E3 00 40 A0 E1 01 50 A0 E1 0A 00 A0 E1 0B 10 A0 E1 0E 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? D3 3F 8F E2 0C 00 93 E8 10 00 8D E5 14 10 8D E5 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? CE 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? CA 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? C6 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? C2 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 36 3E 8F E2 0C 00 93 E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? B6 3F 8F E2 0C 00 93 E8 00 A0 A0 E1 01 B0 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? B1 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? AD 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? A9 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? A5 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? A1 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 10 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 21 00 00 EA 2F 93 E0 E3 0D 96 49 E2 09 00 54 E1 2F 00 00 DA FF 05 A0 E3 03 06 80 E2 00 10 A0 E3 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 04 00 A0 E1 05 10 A0 E1 18 D0 8D E2 F0 8F BD E8 05 20 A0 E1 05 00 A0 E1 06 30 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 F3 FF FF EA 00 00 50 E3 11 00 00 BA 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 02 41 80 E2 01 50 A0 E1 EB FF FF EA 00 40 A0 E3 04 50 A0 E1 00 00 57 E3 E7 FF FF AA 04 20 A0 E1 05 30 A0 E1 08 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 DF FF FF EA 00 30 E0 E3 02 01 85 E2 06 10 A0 E1 00 30 82 E5 ?? ?? ?? ?? 02 41 80 E2 01 50 A0 E1 D7 FF FF EA 03 31 E0 E3 02 B1 C5 E3 03 36 43 E2 03 00 5B E1 90 01 00 DA 02 31 85 E2 03 00 A0 E1 06 10 A0 E1 08 30 8D E5 ?? ?? ?? ?? 10 00 8D E5 14 10 8D E5 10 30 8D E2 0C 00 93 E8 08 00 9D E5 06 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 C7 02 00 1A 2F 33 E0 E3 03 35 43 E2 03 00 5B E1 00 B0 A0 C3 00 C0 A0 C3 33 02 00 DA 0B 00 A0 E1 0C 10 A0 E1 F8 30 8F E2 0C 00 93 E8 ?? ?? ?? ?? 00 C0 A0 E3 00 20 A0 E3 00 30 A0 E3 00 C0 8D E5 ?? ?? ?? ?? 02 91 80 E2 01 B0 A0 E1 09 00 A0 E1 0B 10 A0 E1 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 A3 FF FF 0A 09 20 A0 E1 0B 30 A0 E1 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 94 10 8F E2 03 00 91 E8 ?? ?? ?? ?? ?? ?? ?? ?? 00 30 A0 E3 08 00 8D E5 0C 10 8D E5 00 20 A0 E3 09 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 00 30 98 A5 00 30 E0 B3 00 30 88 E5 02 51 85 E2 01 FF FF EA 74 70 FA 3E 52 FA 8C 42 EC F2 2C 3F 4D E5 10 ED 94 8A 53 3F 5D 3F 6F 11 4F 40 7E 3F E8 EF 8F B6 00 3E B1 3F A7 62 55 1A 8E 85 07 3F 37 58 A4 90 88 50 1C 3F 07 FB 7D 98 C6 B6 40 3F 00 9C B9 89 D8 AD 67 3F 6B 92 B7 CC 22 13 95 3F 7B 54 92 AC 4C A3 D4 3F AD 0F A6 C4 FB 21 09 40 18 2D 44 54 EC BF 00 3F 45 E9 17 DD B6 26 5E 3F 39 F2 68 73 1C 48 9B 3F 61 99 93 7E 9C BB C2 3F F7 F2 E5 BE 8F D9 D4 3F 59 9F 13 4F 8B 84 CB 3F 78 08 E2 36 67 C4 B3 3F C8 B0 7D E3 F7 BA DE 3E 40 81 B3 A5 DA 7D 49 3F 5B A9 41 CA EA 17 93 3F 75 D4 2E 74 ED 01 C6 3F 27 DF FB CC 18 1A E7 3F DC DC D3 93 A7 45 F6 3F 74 AB C4 62 9D B8 5A BF E4 43 9E 0B BA 67 4B 3F D1 D5 DA 4C BF 34 E0 E3 0E 36 43 E2 03 00 54 E1 C4 00 00 CA 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 00 A0 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? FF 25 A0 E3 02 26 82 E2 00 30 A0 E3 00 80 A0 E1 01 90 A0 E1 ?? ?? ?? ?? D0 30 4F E2 0C 00 93 E8 01 C0 A0 E1 00 B0 A0 E1 09 10 A0 E1 08 00 A0 E1 04 C0 8D E5 ?? ?? ?? ?? E8 30 4F E2 0C 00 93 E8 ?? ?? ?? ?? 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? F8 30 4F E2 0C 00 93 E8 ?? ?? ?? ?? 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? 42 3F 4F E2 0C 00 93 E8 ?? ?? ?? ?? 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? 46 3F 4F E2 0C 00 93 E8 ?? ?? ?? ?? 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? 4A 3F 4F E2 0C 00 93 E8 ?? ?? ?? ?? 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? 4E 3F 4F E2 0C 00 93 E8 ?? ?? ?? ?? 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? 52 3F 4F E2 0C 00 93 E8 00 40 A0 E1 01 50 A0 E1 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 57 3F 4F E2 0C 00 93 E8 ?? ?? ?? ?? 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? 5B 3F 4F E2 0C 00 93 E8 ?? ?? ?? ?? 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? 5F 3F 4F E2 0C 00 93 E8 ?? ?? ?? ?? 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? 63 3F 4F E2 0C 00 93 E8 ?? ?? ?? ?? 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? 67 3F 4F E2 0C 00 93 E8 ?? ?? ?? ?? 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? FF 25 A0 E3 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 04 C0 9D E5 00 20 A0 E1 01 30 A0 E1 0B 00 A0 E1 0C 10 A0 E1 ?? ?? ?? ?? 03 A0 4A E2 00 40 A0 E1 01 50 A0 E1 04 00 5A E3 0A F1 9F 97 F8 FE FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 01 21 A0 E3 08 00 A0 E1 09 10 A0 E1 06 27 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 A0 A0 E1 01 B0 A0 E1 01 21 A0 E3 05 27 82 E2 00 30 A0 E3 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? 00 A0 A0 E1 01 B0 A0 E1 01 21 A0 E3 01 26 82 E2 00 30 A0 E3 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? 00 A0 A0 E1 01 B0 A0 E1 01 21 A0 E3 02 27 82 E2 00 30 A0 E3 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? 00 A0 A0 E1 01 B0 A0 E1 01 21 A0 E3 00 30 A0 E3 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 B9 FE FF EA FF A5 A0 E3 03 A6 8A E2 00 B0 A0 E3 C9 FF FF EA FF A5 A0 E3 03 A6 8A E2 00 B0 A0 E3 D0 FF FF EA FF A5 A0 E3 03 A6 8A E2 00 B0 A0 E3 D7 FF FF EA FF A5 A0 E3 03 A6 8A E2 00 B0 A0 E3 DE FF FF EA 2F 33 E0 E3 07 36 43 E2 03 00 54 E1 F7 00 00 CA 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 10 00 8D E5 14 10 8D E5 FF 05 A0 E3 05 20 A0 E1 06 30 A0 E1 03 06 80 E2 00 10 A0 E3 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 00 A0 A0 E1 01 B0 A0 E1 ?? ?? ?? ?? FF 25 A0 E3 00 80 A0 E1 01 90 A0 E1 05 00 A0 E1 06 10 A0 E1 02 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? FF 25 A0 E3 00 40 A0 E1 01 50 A0 E1 03 26 82 E2 10 10 8D E2 03 00 91 E8 00 30 A0 E3 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 3E 3E 4F E2 0C 00 93 E8 00 40 A0 E1 01 50 A0 E1 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? FD 3F 4F E2 0C 00 93 E8 ?? ?? ?? ?? 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? FB 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? F7 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? F3 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? EF 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? EB 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 95 FF FF EA E9 3F 8F E2 0C 00 93 E8 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 00 C0 A0 E3 00 20 A0 E3 00 30 A0 E3 00 C0 8D E5 ?? ?? ?? ?? 00 90 A0 E1 01 B0 A0 E1 81 FE FF EA 31 39 E0 E3 B3 3E 43 E2 33 31 43 E2 03 00 54 E1 4D 01 00 DA 05 00 A0 E1 06 10 A0 E1 D7 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 00 80 A0 E3 08 90 A0 E1 00 A0 A0 E1 01 B0 A0 E1 0A 20 A0 E1 0B 30 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 10 00 8D E5 14 10 8D E5 ?? ?? ?? ?? 32 3E 8F E2 0C 00 93 E8 00 40 A0 E1 01 50 A0 E1 ?? ?? ?? ?? C5 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? C1 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? BD 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? B9 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 10 10 8D E2 03 00 91 E8 ?? ?? ?? ?? B3 3F 8F E2 0C 00 93 E8 10 00 8D E5 14 10 8D E5 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? AE 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? AA 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? A6 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? A2 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 27 3E 8F E2 0C 00 93 E8 00 A0 A0 E1 01 B0 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 97 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 93 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 8F 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 8B 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 02 1C 8F E2 03 00 91 E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 10 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 7A 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 98 FD FF EA 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 62 39 E0 E3 5A 3D 43 E2 F3 31 43 E2 03 00 54 E1 02 81 80 E2 01 90 A0 E1 1C 01 00 DA FF 05 A0 E3 05 20 A0 E1 06 30 A0 E1 03 06 80 E2 00 10 A0 E3 ?? ?? ?? ?? 00 A0 A0 E1 01 B0 A0 E1 22 FD FF EA 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? FF 25 A0 E3 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 A0 FD FF EA 09 00 5B E1 07 00 00 CA 43 24 A0 E3 08 00 9D E5 06 10 A0 E1 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 10 00 8D E5 14 10 8D E5 10 30 8D E2 0C 00 93 E8 01 90 03 E2 09 00 A0 E1 ?? ?? ?? ?? 00 B0 A0 E1 01 C0 A0 E1 09 01 A0 E1 06 00 50 E3 00 F1 9F 97 72 00 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FF 25 A0 E3 0C 10 A0 E1 0E 27 82 E2 00 30 A0 E3 0B 00 A0 E1 ?? ?? ?? ?? 40 30 8F E2 0C 00 93 E8 ?? ?? ?? ?? 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 02 01 80 E2 AB FD FF EA CB 80 43 3F 41 E7 0F 8C 9F 01 4A 3F B6 38 CF 98 6C C1 66 3F 5C 2E B0 16 55 55 B5 3F 3B 55 55 55 E3 CF DA 3F 69 7D C9 90 FB 21 09 40 18 2D 44 54 D8 62 F7 3F 3F BE 56 63 6D AF 34 3F F7 BB 0E 6C 8E FE 56 3F F1 1A 2D BF E0 FC 78 3F 44 E3 70 E3 A8 C9 A0 3F 13 B7 35 DF 2B F7 DE 3F A2 38 EE C8 3E FD 35 3F F4 D3 C2 E8 10 A6 41 3F EC E0 73 9C D3 82 62 3F 15 C9 15 2E 9F 1F 85 3F 6A EC 91 BA 42 8B B0 3F 9B 41 D5 94 24 7F 34 BF 38 8C C3 EC 0C DF 4C 3F E9 A8 61 EF FF 2E 6E 3F D7 14 E9 B3 E7 66 92 3F EC F9 0A 97 27 E4 C2 3F 09 C5 C6 8D CA C7 50 BC 1F 97 8A A4 B9 19 BF 3F 42 8A C3 BC FB 21 09 40 18 2D 44 54 8B 67 8B 3F 09 AB 2B BF AE 4E CD 3F 24 09 01 F6 76 49 EF 3F 50 84 EA 44 5C 47 F7 3F 6F BD 19 D1 1E 40 E4 3F FF 5D 00 8B 67 C4 B3 3F C8 B0 7D E3 BB 5A 6A 3F 61 CF D0 57 55 AE BA 3F 88 7C 53 D6 FB 9D E8 3F AF 50 50 E4 25 07 01 40 F5 18 2B A4 D7 A5 03 40 9C 61 BD C2 61 8B DD 3F FC F8 5A 8D FF 05 A0 E3 0B 20 A0 E1 0C 30 A0 E1 03 06 80 E2 00 10 A0 E3 ?? ?? ?? ?? 52 FD FF EA FF 05 A0 E3 0C 30 A0 E1 0B 20 A0 E1 02 06 80 E2 00 10 A0 E3 ?? ?? ?? ?? A4 30 4F E2 0C 00 93 E8 ?? ?? ?? ?? 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 4D FD FF EA 0B 00 A0 E1 0C 10 A0 E1 01 21 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 3F FD FF EA FF 25 A0 E3 02 26 82 E2 00 30 A0 E3 08 00 9D E5 06 10 A0 E1 ?? ?? ?? ?? 00 B0 A0 E1 04 10 8D E5 ?? ?? ?? ?? 04 C0 9D E5 00 20 A0 E1 01 30 A0 E1 0B 00 A0 E1 0C 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 01 21 A0 E3 01 26 82 E2 00 30 A0 E3 00 B0 A0 E1 04 10 8D E5 ?? ?? ?? ?? ?? ?? ?? ?? 04 C0 9D E5 68 FF FF EA FF 25 A0 E3 05 00 A0 E1 06 10 A0 E1 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 80 A0 E3 00 50 A0 E1 01 60 A0 E1 08 90 A0 E1 BF 24 A0 E3 05 00 A0 E1 06 10 A0 E1 0E 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 5F 3F 4F E2 0C 00 93 E8 10 00 8D E5 14 10 8D E5 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 19 3E 4F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 1A 3E 4F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 1B 3E 4F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 07 3D 4F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 1D 3E 4F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 1E 3E 4F E2 0C 00 93 E8 00 A0 A0 E1 01 B0 A0 E1 05 00 A0 E1 }
	condition:
		$1
}

rule file_138_0_1 {
	meta:
		name = "logf"
		size = 384
		refs = "000c __ieee754_logf 0028 isnanf 003c __gtsf2 0058 __extendsfdf2 0094 __eqsf2 00b4 matherr 00d4 __truncdfsf2 0134 nan 0144 __errno 0174 __fdlib_version"
	strings:
		$1 = { F0 40 2D E9 24 D0 4D E2 00 40 A0 E1 ?? ?? ?? ?? 5C 61 9F E5 00 30 96 E5 01 00 73 E3 00 50 A0 E1 2D 00 00 0A 04 00 A0 E1 ?? ?? ?? ?? 00 70 50 E2 29 00 00 1A 04 00 A0 E1 00 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 24 00 00 CA 28 31 9F E5 04 00 A0 E1 04 30 8D E5 20 70 8D E5 ?? ?? ?? ?? 00 50 96 E5 00 00 55 E3 08 00 8D E5 0C 10 8D E5 10 00 8D E5 14 10 8D E5 1B 00 00 0A 02 21 A0 E3 C2 25 A0 E1 00 30 A0 E3 04 00 A0 E1 00 10 A0 E3 18 20 8D E5 1C 30 8D E5 ?? ?? ?? ?? 00 00 50 E3 1B 00 00 1A 02 30 A0 E3 02 00 55 E3 00 30 8D E5 28 00 00 0A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 24 00 00 0A 20 30 9D E5 00 00 53 E3 1D 00 00 1A 18 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 50 A0 E1 05 00 A0 E1 24 D0 8D E2 F0 80 BD E8 0E 23 E0 E3 01 26 42 E2 0E 32 A0 E3 04 00 A0 E1 00 10 A0 E3 18 20 8D E5 1C 30 8D E5 ?? ?? ?? ?? 00 00 50 E3 E3 FF FF 0A 01 30 A0 E3 02 00 55 E3 00 30 8D E5 10 00 00 0A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 0C 00 00 0A 44 00 9F E5 ?? ?? ?? ?? 18 00 8D E5 1C 10 8D E5 DE FF FF EA ?? ?? ?? ?? 20 30 9D E5 00 30 80 E5 DD FF FF EA ?? ?? ?? ?? 22 30 A0 E3 00 30 80 E5 D6 FF FF EA ?? ?? ?? ?? 21 30 A0 E3 00 30 80 E5 EE FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_140_0_1 {
	meta:
		name = "log10f"
		size = 384
		refs = "000c __ieee754_log10f 0028 isnanf 003c __lesf2 0058 __extendsfdf2 0094 __eqsf2 00b4 matherr 00d4 __truncdfsf2 0134 nan 0144 __errno 0174 __fdlib_version"
	strings:
		$1 = { F0 40 2D E9 24 D0 4D E2 00 40 A0 E1 ?? ?? ?? ?? 5C 61 9F E5 00 30 96 E5 01 00 73 E3 00 50 A0 E1 2D 00 00 0A 04 00 A0 E1 ?? ?? ?? ?? 00 70 50 E2 29 00 00 1A 04 00 A0 E1 00 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 24 00 00 CA 28 31 9F E5 04 00 A0 E1 04 30 8D E5 20 70 8D E5 ?? ?? ?? ?? 00 50 96 E5 00 00 55 E3 08 00 8D E5 0C 10 8D E5 10 00 8D E5 14 10 8D E5 1B 00 00 0A 02 21 A0 E3 C2 25 A0 E1 00 30 A0 E3 04 00 A0 E1 00 10 A0 E3 18 20 8D E5 1C 30 8D E5 ?? ?? ?? ?? 00 00 50 E3 1B 00 00 1A 02 30 A0 E3 02 00 55 E3 00 30 8D E5 28 00 00 0A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 24 00 00 0A 20 30 9D E5 00 00 53 E3 1D 00 00 1A 18 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 50 A0 E1 05 00 A0 E1 24 D0 8D E2 F0 80 BD E8 0E 23 E0 E3 01 26 42 E2 0E 32 A0 E3 04 00 A0 E1 00 10 A0 E3 18 20 8D E5 1C 30 8D E5 ?? ?? ?? ?? 00 00 50 E3 E3 FF FF 0A 01 30 A0 E3 02 00 55 E3 00 30 8D E5 10 00 00 0A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 0C 00 00 0A 44 00 9F E5 ?? ?? ?? ?? 18 00 8D E5 1C 10 8D E5 DE FF FF EA ?? ?? ?? ?? 20 30 9D E5 00 30 80 E5 DD FF FF EA ?? ?? ?? ?? 22 30 A0 E3 00 30 80 E5 D6 FF FF EA ?? ?? ?? ?? 21 30 A0 E3 00 30 80 E5 EE FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_139_0_1 {
	meta:
		name = "round"
		size = 236
		refs = "0094 __adddf3"
	strings:
		$1 = { 02 31 C0 E3 23 3A A0 E1 03 3A A0 E1 43 3A A0 E1 FF 3F 43 E2 03 30 43 E2 13 00 53 E3 F0 40 2D E9 00 C0 A0 E1 00 40 A0 E1 01 50 A0 E1 00 60 A0 E1 01 70 A0 E1 10 00 00 CA 00 00 53 E3 24 00 00 BA 01 16 A0 E3 01 10 41 E2 51 13 A0 E1 00 00 01 E0 05 00 90 E1 05 00 00 0A 02 27 A0 E3 52 C3 84 E0 00 30 A0 E3 01 C0 CC E1 0C 40 A0 E1 03 50 A0 E1 04 00 A0 E1 05 10 A0 E1 F0 80 BD E8 33 00 53 E3 07 00 00 DA 01 0B 53 E3 F8 FF FF 1A 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 F2 FF FF EA 14 10 43 E2 00 00 E0 E3 30 11 A0 E1 05 00 11 E1 ED FF FF 0A 01 00 A0 E3 33 30 63 E2 10 33 85 E0 03 00 55 E1 00 C0 84 80 01 30 C3 E1 E4 FF FF EA 01 00 73 E3 02 C1 00 E2 FF C5 8C 03 03 C6 8C 03 00 30 A0 E3 DE FF FF EA }
	condition:
		$1
}

rule file_141_0_1 {
	meta:
		name = "fdimf"
		size = 72
		refs = "000c __fpclassifyf 0028 __gtsf2 0040 __subsf3"
	strings:
		$1 = { 30 40 2D E9 01 40 A0 E1 00 50 A0 E1 ?? ?? ?? ?? 01 00 50 E3 7F 04 A0 93 02 05 80 92 30 80 BD 98 05 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 00 00 A0 D3 30 80 BD D8 05 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 30 80 BD E8 }
	condition:
		$1
}

rule file_142_0_1 {
	meta:
		name = "__ieee754_atan2"
		size = 736
		refs = "0108 __subdf3 0130 __adddf3 0184 atan 023c __divdf3 0240 fabs"
	strings:
		$1 = { F0 4F 2D E9 02 40 A0 E1 00 50 63 E2 0C D0 4D E2 0C 00 8D E8 03 50 85 E1 03 20 A0 E1 02 61 C4 E3 7F 34 A0 E3 A5 5F 86 E1 0F 36 83 E2 03 00 55 E1 00 B0 A0 E1 01 C0 A0 E1 00 80 A0 E1 01 90 A0 E1 00 70 A0 E1 01 50 A0 E1 35 00 00 8A 00 A0 61 E2 08 A0 8D E5 08 70 9D E5 02 A1 C0 E3 01 70 87 E1 A7 7F 8A E1 03 00 57 E1 08 70 8D E5 2C 00 00 8A 03 31 84 E2 01 36 83 E2 02 30 93 E1 3E 00 00 0A 44 3F A0 E1 05 50 9A E1 02 50 03 E2 A0 5F 85 E1 2D 00 00 0A 02 20 96 E1 32 00 00 0A 7F 34 A0 E3 0F 36 83 E2 03 00 56 E1 3F 00 00 0A 7F 34 A0 E3 0F 36 83 E2 03 00 5A E1 2A 00 00 0A 0A 60 66 E0 46 6A A0 E1 3C 00 56 E3 34 00 00 CA 3C 00 76 E3 00 60 A0 A3 01 60 A0 B3 A4 6F 16 E0 00 00 A0 13 00 10 A0 13 51 00 00 0A 01 00 55 E3 4B 00 00 0A 02 00 55 E3 3E 00 00 0A 00 00 55 E3 05 00 00 0A 19 3E 8F E2 0C 00 93 E8 ?? ?? ?? ?? 63 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 00 B0 A0 E1 01 C0 A0 E1 05 00 00 EA 0B 00 A0 E1 0C 10 A0 E1 0C 00 9D E8 ?? ?? ?? ?? 00 B0 A0 E1 01 C0 A0 E1 0B 00 A0 E1 0C 10 A0 E1 0C D0 8D E2 F0 8F BD E8 03 00 55 E3 05 F1 9F 97 CE FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 58 E3 1D 00 00 BA 13 CE 8F E2 00 18 9C E8 EF FF FF EA 0C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 12 CE 8F E2 00 18 9C E8 E9 FF FF EA 41 CF 8F E2 00 18 9C E8 E6 FF FF EA 01 1C 8F E2 03 00 91 E8 CE FF FF EA 06 00 5A E1 25 00 00 0A 03 00 55 E3 05 F1 9F 97 BA FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 02 B1 A0 E3 00 C0 A0 E3 D7 FF FF EA 00 B0 A0 E3 00 C0 A0 E3 D4 FF FF EA C8 C0 8F E2 00 18 9C E8 D1 FF FF EA 9C 30 8F E2 0C 00 93 E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 90 10 8F E2 03 00 91 E8 ?? ?? ?? ?? 00 B0 A0 E1 01 C0 A0 E1 C6 FF FF EA 02 41 80 E2 01 C0 A0 E1 04 B0 A0 E1 C2 FF FF EA 0C 00 9D E8 0C 10 A0 E1 0B 00 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? A6 FF FF EA 03 00 55 E3 05 F1 9F 97 C3 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 50 C0 8F E2 00 18 9C E8 B1 FF FF EA 4C C0 8F E2 00 18 9C E8 AE FF FF EA 48 C0 8F E2 00 18 9C E8 AB FF FF EA 44 C0 8F E2 00 18 9C E8 A8 FF FF EA 26 A6 A1 3C 07 5C 14 33 FB 21 09 40 18 2D 44 54 FB 21 F9 3F 18 2D 44 54 FB 21 09 C0 18 2D 44 54 FB 21 F9 BF 18 2D 44 54 7C D9 02 C0 D2 21 33 7F 7C D9 02 40 D2 21 33 7F FB 21 E9 BF 18 2D 44 54 FB 21 E9 3F 18 2D 44 54 }
	condition:
		$1
}

rule file_143_0_1 {
	meta:
		name = "__kernel_cosf"
		size = 544
		refs = "0018 __fixsfsi 0030 __mulsf3 004c __addsf3 0064 __subsf3"
	strings:
		$1 = { F0 45 2D E9 02 61 C0 E3 32 04 56 E3 00 50 A0 E1 01 70 A0 E1 39 00 00 AA ?? ?? ?? ?? 00 00 50 E3 FE 05 A0 03 F0 85 BD 08 05 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? D4 11 9F E5 00 40 A0 E1 ?? ?? ?? ?? 27 11 E0 E3 EF 16 41 E2 8B 1C 41 E2 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 36 1D E0 E3 F2 13 41 E2 DB 17 41 E2 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 0D 1C A0 E3 4D 13 81 E2 3D 16 81 E2 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 84 11 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 78 11 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 00 80 A0 E1 04 00 A0 E1 3F 14 A0 E3 ?? ?? ?? ?? 08 10 A0 E1 00 60 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 07 10 A0 E1 00 40 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 FE 05 A0 E3 ?? ?? ?? ?? F0 85 BD E8 00 10 A0 E1 ?? ?? ?? ?? 00 11 9F E5 00 40 A0 E1 ?? ?? ?? ?? 27 11 E0 E3 EF 16 41 E2 8B 1C 41 E2 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 36 1D E0 E3 F2 13 41 E2 DB 17 41 E2 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 0D 1C A0 E3 4D 13 81 E2 3D 16 81 E2 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? B0 10 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? A4 10 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 98 30 9F E5 03 00 56 E1 00 80 A0 E1 C7 FF FF DA FD 35 A0 E3 02 37 83 E2 03 00 56 E1 FA 65 A0 C3 01 66 86 C2 FF 64 86 D2 06 10 A0 E1 FE 05 A0 E3 ?? ?? ?? ?? 3F 14 A0 E3 00 A0 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 06 10 A0 E1 ?? ?? ?? ?? 08 10 A0 E1 00 60 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 07 10 A0 E1 00 40 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? F0 85 BD E8 4E D7 47 AD 61 0B B6 3A AB AA 2A 3D 99 99 99 3E }
	condition:
		$1
}

rule file_144_0_1 {
	meta:
		name = "cosf"
		size = 188
		refs = "0034 __subsf3 0044 __ieee754_rem_pio2f 006c __kernel_cosf 009c __kernel_sinf"
	strings:
		$1 = { 04 E0 2D E5 9F 31 E0 E3 B6 38 43 E2 02 21 C0 E3 0F 3A 43 E2 03 00 52 E1 08 D0 4D E2 00 10 A0 E1 13 00 00 DA 02 31 E0 E3 02 35 43 E2 03 00 52 E1 02 00 00 DA ?? ?? ?? ?? 08 D0 8D E2 00 80 BD E8 0D 10 A0 E1 ?? ?? ?? ?? 03 20 00 E2 01 00 52 E3 0F 00 00 0A 02 00 52 E3 08 00 00 0A 00 00 52 E3 10 00 00 1A 00 00 9D E5 04 10 9D E5 ?? ?? ?? ?? F0 FF FF EA 00 10 A0 E3 ?? ?? ?? ?? ED FF FF EA 00 00 9D E5 04 10 9D E5 ?? ?? ?? ?? 02 01 80 E2 E8 FF FF EA 00 00 9D E5 04 10 9D E5 ?? ?? ?? ?? 02 01 80 E2 E3 FF FF EA 00 00 9D E5 04 10 9D E5 01 20 A0 E3 ?? ?? ?? ?? DE FF FF EA }
	condition:
		$1
}

rule file_145_0_1 {
	meta:
		name = "__kernel_rem_pio2f"
		size = 2296
		refs = "0090 __floatsisf 00f0 __mulsf3 00fc __addsf3 0180 __fixsfsi 01d0 scalbnf 01e0 floorf 0210 __subsf3 0308 __eqsf2 04c4 __gesf2"
	strings:
		$1 = { F0 4F 2D E9 17 DE 4D E2 1C 30 8D E5 94 E1 9D E5 D8 38 9F E5 0E 31 93 E7 03 C0 52 E2 14 30 8D E5 1C 30 9D E5 04 C0 82 42 01 30 43 E2 CC C1 A0 E1 CC CF CC E1 04 30 8D E5 24 C0 8D E5 0C 30 E0 E1 04 E0 9D E5 14 C0 9D E5 83 31 82 E0 0E A0 9C E0 10 30 8D E5 00 70 A0 E1 18 10 8D E5 11 00 00 4A 24 00 9D E5 98 11 9D E5 00 40 6E E0 0A A0 84 E0 04 61 81 E0 00 50 A0 E3 D0 80 8D E2 00 00 00 EA 01 40 84 E2 00 00 54 E3 00 00 A0 B3 00 00 96 A5 ?? ?? ?? ?? 0A 00 54 E1 05 00 88 E7 04 60 86 E2 04 50 85 E2 F5 FF FF 1A 14 20 9D E5 00 00 52 E3 1C 00 00 BA 1C 30 9D E5 04 A0 9D E5 03 B0 82 E0 00 90 A0 E3 03 81 A0 E1 04 E0 9D E5 00 00 5E E3 00 50 A0 B3 0D 00 00 BA D0 00 8D E2 0A 61 80 E0 00 40 A0 E3 00 50 A0 E3 04 00 97 E7 04 10 16 E4 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 04 40 84 E2 08 00 54 E1 00 50 A0 E1 F5 FF FF 1A 01 A0 8A E2 30 C0 8D E2 0B 00 5A E1 09 50 8C E7 04 90 89 E2 E7 FF FF 1A 14 10 9D E5 17 2E 8D E2 01 30 41 E2 03 31 82 E0 50 30 43 E2 2C 30 8D E5 12 3E 8D E2 01 31 83 E0 28 30 8D E5 01 B0 A0 E1 0B 91 A0 E1 17 CE 8D E2 09 30 8C E0 00 00 5B E3 40 41 13 E5 17 00 00 DA 30 A0 8D E2 09 60 8A E0 00 50 A0 E3 EE 15 A0 E3 04 00 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 87 14 A0 E3 C1 10 A0 E1 00 80 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 12 EE 8D E2 05 00 8E E7 04 10 36 E5 08 00 A0 E1 ?? ?? ?? ?? 0A 00 56 E1 00 40 A0 E1 04 50 85 E2 EA FF FF 1A 04 00 A0 E1 10 10 9D E5 ?? ?? ?? ?? 3E 14 A0 E3 00 40 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? C1 14 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 ?? ?? ?? ?? 00 80 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 10 10 9D E5 00 00 51 E3 00 50 A0 E1 99 00 00 DA 17 2E 8D E2 01 10 4B E2 01 11 82 E0 10 30 9D E5 50 00 11 E5 08 20 63 E2 50 32 A0 E1 13 22 40 E0 10 C0 9D E5 07 60 6C E2 52 66 A0 E1 50 20 01 E5 03 80 88 E0 00 00 56 E3 27 00 00 DA 00 00 5B E3 01 80 88 E2 00 40 A0 D3 14 00 00 DA 00 30 A0 E3 03 40 A0 E1 06 00 00 EA 00 00 52 E3 01 2C 62 12 03 20 80 17 04 30 83 E2 01 40 A0 13 09 00 53 E1 0A 00 00 0A 12 0E 8D E2 00 00 54 E3 03 20 90 E7 F4 FF FF 0A FF 20 62 E2 12 1E 8D E2 03 20 81 E7 04 30 83 E2 09 00 53 E1 01 40 A0 E3 F4 FF FF 1A 10 20 9D E5 00 00 52 E3 09 00 00 DA 01 00 52 E3 72 00 00 0A 02 00 52 E3 05 00 00 1A 01 30 4B E2 17 EE 8D E2 03 31 8E E0 50 20 13 E5 3F 20 02 E2 50 20 03 E5 02 00 56 E3 54 00 00 0A 05 00 A0 E1 00 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 44 01 00 1A 14 10 9D E5 01 00 4B E2 00 00 51 E1 09 00 00 CA 12 2E 8D E2 28 C0 9D E5 09 30 82 E0 00 20 A0 E3 04 10 33 E5 0C 00 53 E1 01 20 82 E1 FB FF FF 1A 00 00 52 E3 63 00 00 1A 2C C0 9D E5 00 30 9C E5 00 00 53 E3 01 20 A0 13 06 00 00 1A 28 30 9D E5 01 20 A0 E3 08 10 13 E5 00 00 51 E3 01 20 82 E2 04 30 43 E2 FA FF FF 0A 0B 20 82 E0 02 00 5B E1 20 20 8D E5 2F 00 00 AA 24 E0 9D E5 1C 00 9D E5 01 20 8E E2 00 30 8B E0 0B B0 82 E0 30 20 8D E2 09 90 82 E0 D0 10 8D E2 00 90 8D E5 03 A0 A0 E1 03 91 81 E0 20 30 9D E5 98 21 9D E5 00 30 83 E0 0C 10 8D E5 08 30 8D E5 0B B1 82 E0 00 81 A0 E1 00 00 9B E5 ?? ?? ?? ?? 04 C0 9D E5 00 00 5C E3 00 00 89 E5 00 50 A0 B3 0D 00 00 BA 0C E0 9D E5 00 50 A0 E3 0A 61 8E E0 00 40 A0 E3 04 00 97 E7 04 10 16 E4 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 04 40 84 E2 08 00 54 E1 00 50 A0 E1 F5 FF FF 1A 00 10 9D E5 08 00 9D E5 01 A0 8A E2 04 50 A1 E5 00 00 5A E1 00 10 8D E5 04 B0 8B E2 04 90 89 E2 E1 FF FF 1A 20 B0 9D E5 3E FF FF EA 05 10 A0 E1 FE 05 A0 E3 ?? ?? ?? ?? 00 00 54 E3 00 50 A0 E1 A4 FF FF 0A 10 10 9D E5 FE 05 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 50 A0 E1 9C FF FF EA 0B 00 00 1A 17 EE 8D E2 0B 31 8E E0 54 60 13 E5 46 64 A0 E1 6C FF FF EA 01 30 4B E2 17 CE 8D E2 03 31 8C E0 50 20 13 E5 7F 20 02 E2 50 20 03 E5 8D FF FF EA 3F 14 A0 E3 ?? ?? ?? ?? 00 00 50 E3 00 60 A0 B3 02 60 A0 A3 61 FF FF AA 88 FF FF EA 00 31 A0 E1 17 CE 8D E2 03 20 8C E0 10 E0 9D E5 50 20 12 E5 08 E0 4E E2 00 00 52 E3 40 01 8D E8 10 E0 8D E5 00 B0 A0 11 09 00 00 1A 12 1E 8D E2 10 20 9D E5 03 30 81 E0 00 B0 A0 E1 04 10 33 E5 00 00 51 E3 01 B0 4B E2 08 20 42 E2 FA FF FF 0A 10 20 8D E5 10 10 9D E5 FE 05 A0 E3 ?? ?? ?? ?? 00 00 5B E3 00 50 A0 E1 33 00 00 BA 0B 31 A0 E1 30 60 8D E2 12 4E 8D E2 03 60 86 E0 03 40 84 E0 47 7F 8D E2 04 00 14 E4 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? EE 15 A0 E3 04 00 06 E4 05 00 A0 E1 ?? ?? ?? ?? 07 00 54 E1 00 50 A0 E1 F4 FF FF 1A 0B A0 A0 E1 08 B0 8D E5 58 83 9F E5 14 B0 9D E5 00 70 A0 E3 30 90 8D E2 00 00 5B E3 9C 00 00 BA 00 00 57 E3 0A 51 89 A0 00 60 A0 A3 00 40 A0 A3 03 00 00 AA 96 00 00 EA 07 00 54 E1 04 50 85 E2 09 00 00 CA 04 01 98 E7 00 10 95 E5 ?? ?? ?? ?? 00 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 01 40 84 E2 04 00 5B E1 00 60 A0 E1 F2 FF FF AA 01 A0 4A E2 17 2E 8D E2 07 31 82 E0 01 00 7A E3 F0 60 03 E5 01 70 87 E2 E3 FF FF 1A 08 B0 9D E5 94 31 9D E5 03 00 53 E3 03 F1 9F 97 10 00 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 A0 E3 00 10 9D E5 00 00 51 E3 A2 00 00 0A 80 20 8D E2 0C 00 92 E8 18 10 9D E5 02 21 82 E2 02 31 83 E2 02 01 80 E2 08 00 81 E5 00 20 81 E5 04 30 81 E5 04 20 9D E5 07 00 02 E2 17 DE 8D E2 F0 8F BD E8 00 00 5B E3 EC FF FF DA 0B 91 A0 E1 17 CE 8D E2 09 30 8C E0 80 60 8D E2 09 50 86 E0 F0 70 13 E5 05 40 A0 E1 04 A0 14 E5 07 10 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 00 80 A0 E1 08 10 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 07 10 A0 E1 ?? ?? ?? ?? 00 00 84 E5 04 80 24 E5 06 00 54 E1 08 70 A0 E1 F0 FF FF 1A 01 00 5B E3 D4 FF FF DA 17 EE 8D E2 09 90 8E E0 01 40 4B E2 F0 70 19 E5 04 41 86 E0 00 A0 94 E5 07 00 A0 E1 0A 10 A0 E1 ?? ?? ?? ?? 00 80 A0 E1 08 10 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 04 00 84 E5 04 80 04 E4 06 00 54 E1 08 70 A0 E1 EF FF FF 1A 00 00 A0 E3 04 40 84 E2 04 10 15 E4 ?? ?? ?? ?? 04 00 55 E1 FB FF FF 1A B9 FF FF EA 00 00 5B E3 00 00 A0 B3 07 00 00 BA 80 40 8D E2 00 00 A0 E3 0B 41 84 E0 7C 50 8D E2 04 10 14 E4 ?? ?? ?? ?? 05 00 54 E1 FB FF FF 1A 00 20 9D E5 18 C0 9D E5 00 00 52 E3 00 30 A0 01 02 31 80 12 00 30 8C E5 00 10 A0 E1 80 00 9D E5 ?? ?? ?? ?? 00 00 5B E3 05 00 00 DA 80 40 8D E2 0B B1 84 E0 04 10 B4 E5 ?? ?? ?? ?? 0B 00 54 E1 FB FF FF 1A 00 10 9D E5 18 20 9D E5 00 00 51 E3 02 01 80 12 04 00 82 E5 A3 FF FF EA 00 00 5B E3 00 00 A0 B3 07 00 00 BA 80 30 8D E2 00 00 A0 E3 0B B1 83 E0 7C 40 8D E2 04 10 1B E4 ?? ?? ?? ?? 04 00 5B E1 FB FF FF 1A 00 C0 9D E5 18 10 9D E5 00 00 5C E3 02 01 80 12 00 00 81 E5 92 FF FF EA 00 60 A0 E3 73 FF FF EA 10 20 9D E5 05 00 A0 E1 00 10 62 E2 40 01 8D E8 ?? ?? ?? ?? 43 14 A0 E3 02 15 81 E2 00 40 A0 E1 ?? ?? ?? ?? 00 00 50 E3 19 00 00 BA EE 15 A0 E3 04 00 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 87 14 A0 E3 C1 10 A0 E1 00 50 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 17 2E 8D E2 09 90 82 E0 50 00 09 E5 05 00 A0 E1 ?? ?? ?? ?? 10 E0 9D E5 01 B0 8B E2 17 CE 8D E2 0B 31 8C E0 08 E0 8E E2 50 00 03 E5 10 E0 8D E5 1C FF FF EA 04 00 A0 E1 ?? ?? ?? ?? 17 1E 8D E2 09 90 81 E0 50 00 09 E5 16 FF FF EA 80 20 9D E5 84 30 9D E5 18 C0 9D E5 08 00 8C E5 00 20 8C E5 04 30 8C E5 5E FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_146_0_1 {
	meta:
		name = "fmax"
		size = 112
		refs = "0014 __fpclassifyd 0050 __gtdf2"
	strings:
		$1 = { F0 40 2D E9 00 60 A0 E1 01 70 A0 E1 02 40 A0 E1 03 50 A0 E1 ?? ?? ?? ?? 00 00 50 E3 02 00 00 1A 04 00 A0 E1 05 10 A0 E1 F0 80 BD E8 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 06 00 00 0A 06 00 A0 E1 07 10 A0 E1 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 F0 FF FF DA 06 40 A0 E1 07 50 A0 E1 04 00 A0 E1 05 10 A0 E1 F0 80 BD E8 }
	condition:
		$1
}

rule file_147_0_1 {
	meta:
		name = "__ieee754_expf"
		size = 704
		refs = "006c __mulsf3 007c __addsf3 0080 __fixsfsi 0088 __floatsisf 00a8 __subsf3 0164 __divsf3 0204 __gtsf2"
	strings:
		$1 = { 7F 34 A0 E3 02 35 83 E2 02 11 C0 E3 03 00 51 E1 F0 41 2D E9 00 40 A0 E1 63 00 00 8A A0 5F A0 E1 66 00 00 0A 64 32 9F E5 03 00 50 E1 68 00 00 CA 39 3D E0 E3 AB 32 43 E2 D3 36 43 E2 03 00 51 E1 00 30 A0 93 01 30 05 82 00 00 53 E3 5D 00 00 1A 3C 22 9F E5 02 00 51 E1 63 00 00 9A 34 32 9F E5 03 00 51 E1 7F 00 00 9A 2C 12 9F E5 ?? ?? ?? ?? 28 32 9F E5 05 51 83 E0 10 10 95 E5 ?? ?? ?? ?? ?? ?? ?? ?? 00 60 A0 E1 ?? ?? ?? ?? 3F 14 A0 E3 C5 19 81 E2 C6 1D 81 E2 00 50 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? F0 11 9F E5 00 70 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 80 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 04 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? C4 11 9F E5 00 50 A0 E1 ?? ?? ?? ?? BC 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? B0 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? A4 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 98 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 00 56 E3 00 50 A0 E1 38 00 00 0A 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 00 40 A0 E1 01 01 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 07 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 FE 05 A0 E3 ?? ?? ?? ?? 7D 00 76 E3 86 4B 80 A0 08 00 00 AA 64 60 86 E2 86 0B 80 E0 36 15 A0 E3 ?? ?? ?? ?? 00 40 A0 E1 02 00 00 EA 00 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 04 00 A0 E1 F0 81 BD E8 00 00 55 E3 FB FF FF 0A 00 40 A0 E3 04 00 A0 E1 F0 81 BD E8 E0 00 9F E5 00 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 04 00 A0 E1 F0 81 BD E8 C6 05 51 E3 03 60 A0 21 B5 FF FF 2A BC 10 9F E5 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 00 00 50 E3 AF FF FF DA 04 00 A0 E1 FE 15 A0 E3 ?? ?? ?? ?? 00 40 A0 E1 E4 FF FF EA 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 01 11 A0 E3 00 60 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 FE 05 A0 E3 ?? ?? ?? ?? 00 40 A0 E1 D3 FF FF EA 30 40 9F E5 05 11 94 E7 ?? ?? ?? ?? 00 60 65 E2 05 41 84 E0 06 50 65 E0 00 70 A0 E1 08 80 94 E5 01 60 85 E2 8B FF FF EA 17 72 B1 42 18 72 B1 3E 91 15 85 3F 3B AA B8 3F ?? ?? ?? ?? D1 F7 17 37 4C BB 31 33 0E EA DD 35 55 B3 8A 38 61 0B 36 3B AB AA 2A 3E CA F2 49 71 }
	condition:
		$1
}

rule file_148_0_1 {
	meta:
		name = "__ieee754_asinf"
		size = 960
		refs = "0030 __addsf3 0038 __gtsf2 0048 fabsf 0054 __subsf3 005c __mulsf3 011c __ieee754_sqrtf 0144 __divsf3"
	strings:
		$1 = { F0 47 2D E9 02 51 C0 E3 FE 05 55 E3 00 40 A0 E1 00 60 A0 E1 94 00 00 0A 79 00 00 CA 3F 04 55 E3 07 00 00 AA 32 04 55 E3 9D 00 00 AA 5C 13 9F E5 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 00 00 50 E3 74 00 00 CA 04 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 FE 05 A0 E3 ?? ?? ?? ?? 3F 14 A0 E3 ?? ?? ?? ?? 2C 13 9F E5 00 40 A0 E1 ?? ?? ?? ?? 24 13 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 18 13 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 0C 13 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 00 13 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? F4 12 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? E8 12 9F E5 00 A0 A0 E1 04 00 A0 E1 ?? ?? ?? ?? DC 12 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 55 1B A0 E3 CB 1F 81 E2 05 11 81 E2 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 67 19 A0 E3 11 1C 81 E2 E5 11 81 E2 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 00 80 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 8C 32 9F E5 03 00 55 E1 00 70 A0 E1 3B 00 00 CA 00 10 A0 E1 ?? ?? ?? ?? 08 10 A0 E1 00 90 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 09 00 A0 E1 ?? ?? ?? ?? FF 5E C7 E3 0F 50 C5 E3 00 80 A0 E1 05 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 00 40 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 03 11 A0 E3 ?? ?? ?? ?? 14 12 9F E5 ?? ?? ?? ?? 00 10 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 03 11 A0 E3 00 40 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 93 11 E0 E3 B6 18 41 E2 0F 1A 41 E2 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 93 01 E0 E3 B6 08 40 E2 0F 0A 40 E2 ?? ?? ?? ?? 00 00 56 E3 00 40 A0 C1 02 41 80 D2 04 00 A0 E1 F0 87 BD E8 00 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 04 00 A0 E1 F0 87 BD E8 08 10 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 ?? ?? ?? ?? 64 11 9F E5 ?? ?? ?? ?? 00 10 A0 E1 DB 09 E0 E3 03 0A 40 E2 93 01 40 E2 ?? ?? ?? ?? E0 FF FF EA DB 19 E0 E3 03 1A 41 E2 93 11 41 E2 ?? ?? ?? ?? 38 11 9F E5 00 50 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 04 00 A0 E1 F0 87 BD E8 00 10 A0 E1 ?? ?? ?? ?? E0 10 9F E5 00 50 A0 E1 ?? ?? ?? ?? D8 10 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? CC 10 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? C0 10 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? B4 10 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? A8 10 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 9C 10 9F E5 00 60 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 90 10 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 55 1B A0 E3 CB 1F 81 E2 05 11 81 E2 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 67 19 A0 E3 11 1C 81 E2 E5 11 81 E2 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 04 00 A0 E1 F0 87 BD E8 CA F2 49 71 08 EF 11 38 04 7F 4F 3A 46 11 24 3D A8 0A 4E 3E 90 B0 A6 3E AB AA 2A 3E 2E C6 9D 3D 61 33 30 3F 99 99 79 3F 2E BD 3B 33 2E BD 3B B3 }
	condition:
		$1
}

rule file_149_0_1 {
	meta:
		name = "__ieee754_scalbf"
		size = 276
		refs = "000c isnanf 0020 __mulsf3 003c finitef 0050 __gtsf2 0064 __divsf3 0070 rintf 0078 __nesf2 00b0 __ltsf2 00c0 __fixsfsi 00d0 scalbnf 00dc __subsf3"
	strings:
		$1 = { 30 40 2D E9 01 40 A0 E1 00 50 A0 E1 ?? ?? ?? ?? 00 00 50 E3 03 00 00 0A 05 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 30 80 BD E8 04 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 F7 FF FF 1A 04 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 08 00 00 1A 04 00 A0 E1 00 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 EE FF FF CA 02 11 84 E2 05 00 A0 E1 ?? ?? ?? ?? 30 80 BD E8 04 00 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 13 00 00 1A 47 14 A0 E3 7D 18 81 E2 04 00 A0 E1 3A 1B 81 E2 ?? ?? ?? ?? 00 00 50 E3 17 00 00 CA C7 14 A0 E3 7D 18 81 E2 04 00 A0 E1 3A 1B 81 E2 ?? ?? ?? ?? 00 00 50 E3 0B 00 00 BA 04 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 30 40 BD E8 ?? ?? ?? ?? 04 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 ?? ?? ?? ?? 30 80 BD E8 FD 1C E0 E3 05 00 A0 E1 E7 10 41 E2 30 40 BD E8 ?? ?? ?? ?? FD 1C A0 E3 05 00 A0 E1 E8 10 81 E2 30 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_150_0_1 {
	meta:
		name = "tgamma"
		size = 256
		refs = "0014 __ieee754_gamma_r 0040 finite 0078 floor 0084 __eqdf2 00a0 __ledf2 00c4 __kernel_standard 00fc __fdlib_version"
	strings:
		$1 = { F0 40 2D E9 08 D0 4D E2 04 20 8D E2 00 40 A0 E1 01 50 A0 E1 ?? ?? ?? ?? 04 30 9D E5 00 00 53 E3 D4 30 9F E5 00 30 93 E5 00 60 A0 E1 02 61 80 B2 01 00 73 E3 01 70 A0 E1 03 00 00 0A 06 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 03 00 00 0A 06 00 A0 E1 07 10 A0 E1 08 D0 8D E2 F0 80 BD E8 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 F6 FF FF 0A 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 06 00 00 1A 04 00 A0 E1 05 10 A0 E1 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 09 00 00 DA 28 C0 A0 E3 04 00 A0 E1 05 10 A0 E1 04 20 A0 E1 05 30 A0 E1 00 C0 8D E5 ?? ?? ?? ?? 00 60 A0 E1 01 70 A0 E1 DD FF FF EA 29 C0 A0 E3 04 00 A0 E1 05 10 A0 E1 04 20 A0 E1 05 30 A0 E1 00 C0 8D E5 ?? ?? ?? ?? 00 60 A0 E1 01 70 A0 E1 D3 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_151_0_1 {
	meta:
		name = "exp"
		size = 396
		refs = "0010 __ieee754_exp 0034 finite 0050 __gtdf2 006c __ltdf2 00c0 matherr 00d8 __errno 0184 __fdlib_version"
	strings:
		$1 = { F0 41 2D E9 24 D0 4D E2 00 40 A0 E1 01 50 A0 E1 ?? ?? ?? ?? 68 61 9F E5 00 30 96 E5 01 00 73 E3 00 70 A0 E1 01 80 A0 E1 2F 00 00 0A 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 2A 00 00 0A 04 00 A0 E1 05 10 A0 E1 49 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 00 00 50 E3 27 00 00 CA 04 00 A0 E1 05 10 A0 E1 11 3E 8F E2 0C 00 93 E8 ?? ?? ?? ?? 00 00 50 E3 1C 00 00 AA 00 30 96 E5 02 00 53 E3 04 30 A0 E3 00 30 8D E5 F8 30 9F E5 04 30 8D E5 00 30 A0 E3 20 30 8D E5 00 20 A0 E3 00 30 A0 E3 08 40 8D E5 0C 50 8D E5 18 20 8D E5 1C 30 8D E5 10 40 8D E5 14 50 8D E5 29 00 00 0A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 25 00 00 0A 20 30 9D E5 00 00 53 E3 02 00 00 0A ?? ?? ?? ?? 20 30 9D E5 00 30 80 E5 18 80 8D E2 80 01 98 E8 07 00 A0 E1 08 10 A0 E1 24 D0 8D E2 F0 81 BD E8 03 20 A0 E3 00 30 96 E5 00 20 8D E5 78 20 9F E5 00 00 53 E3 04 20 8D E5 00 20 A0 E3 20 20 8D E5 08 40 8D E5 0C 50 8D E5 10 40 8D E5 14 50 8D E5 05 00 00 1A 2E 33 E0 E3 01 36 43 E2 0E 42 A0 E3 18 30 8D E5 1C 40 8D E5 DC FF FF EA 02 00 53 E3 7F 34 A0 E3 0F 36 83 E2 00 40 A0 E3 18 30 8D E5 1C 40 8D E5 D5 FF FF 1A ?? ?? ?? ?? 22 30 A0 E3 00 30 80 E5 D5 FF FF EA 42 2E 86 40 EF 39 FA FE 10 49 87 C0 51 30 2D D5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_153_0_1 {
	meta:
		name = "y0f"
		size = 400
		refs = "000c __ieee754_y0f 0028 isnanf 003c __lesf2 0050 __gtsf2 0074 __extendsfdf2 00a8 matherr 00c0 __errno 00d4 __truncdfsf2 0184 __fdlib_version"
	strings:
		$1 = { F0 40 2D E9 24 D0 4D E2 00 40 A0 E1 ?? ?? ?? ?? 6C 61 9F E5 00 30 96 E5 01 00 73 E3 00 50 A0 E1 2D 00 00 0A 04 00 A0 E1 ?? ?? ?? ?? 00 70 50 E2 29 00 00 1A 04 00 A0 E1 00 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 27 00 00 DA 04 00 A0 E1 34 11 9F E5 ?? ?? ?? ?? 00 00 50 E3 1F 00 00 DA 05 30 A0 E3 00 30 8D E5 20 31 9F E5 04 00 A0 E1 04 30 8D E5 20 70 8D E5 ?? ?? ?? ?? 00 30 96 E5 00 40 A0 E3 02 00 53 E3 00 30 A0 E3 08 00 8D E5 0C 10 8D E5 18 30 8D E5 1C 40 8D E5 10 00 8D E5 14 10 8D E5 33 00 00 0A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 2F 00 00 0A 20 30 9D E5 00 00 53 E3 02 00 00 0A ?? ?? ?? ?? 20 30 9D E5 00 30 80 E5 18 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 50 A0 E1 05 00 A0 E1 24 D0 8D E2 F0 80 BD E8 01 30 A0 E3 00 30 8D E5 94 30 9F E5 04 00 A0 E1 04 30 8D E5 20 70 8D E5 ?? ?? ?? ?? 00 30 96 E5 00 00 53 E3 08 00 8D E5 0C 10 8D E5 10 00 8D E5 14 10 8D E5 0C 00 00 1A 0E 33 E0 E3 01 36 43 E2 0E 42 A0 E3 18 30 8D E5 1C 40 8D E5 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 DB FF FF 1A ?? ?? ?? ?? 21 30 A0 E3 00 30 80 E5 D7 FF FF EA 02 00 53 E3 02 31 A0 E3 C3 35 A0 E1 00 40 A0 E3 18 30 8D E5 1C 40 8D E5 F4 FF FF 0A EF FF FF EA ?? ?? ?? ?? 22 30 A0 E3 00 30 80 E5 CB FF FF EA ?? ?? ?? ?? DB 0F 49 5A ?? ?? ?? ?? }
	condition:
		$1
}

rule file_190_0_1 {
	meta:
		name = "y1f"
		size = 400
		refs = "000c __ieee754_y1f 0028 isnanf 003c __lesf2 0050 __gtsf2 0074 __extendsfdf2 00a8 matherr 00c0 __errno 00d4 __truncdfsf2 0184 __fdlib_version"
	strings:
		$1 = { F0 40 2D E9 24 D0 4D E2 00 40 A0 E1 ?? ?? ?? ?? 6C 61 9F E5 00 30 96 E5 01 00 73 E3 00 50 A0 E1 2D 00 00 0A 04 00 A0 E1 ?? ?? ?? ?? 00 70 50 E2 29 00 00 1A 04 00 A0 E1 00 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 27 00 00 DA 04 00 A0 E1 34 11 9F E5 ?? ?? ?? ?? 00 00 50 E3 1F 00 00 DA 05 30 A0 E3 00 30 8D E5 20 31 9F E5 04 00 A0 E1 04 30 8D E5 20 70 8D E5 ?? ?? ?? ?? 00 30 96 E5 00 40 A0 E3 02 00 53 E3 00 30 A0 E3 08 00 8D E5 0C 10 8D E5 18 30 8D E5 1C 40 8D E5 10 00 8D E5 14 10 8D E5 33 00 00 0A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 2F 00 00 0A 20 30 9D E5 00 00 53 E3 02 00 00 0A ?? ?? ?? ?? 20 30 9D E5 00 30 80 E5 18 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 50 A0 E1 05 00 A0 E1 24 D0 8D E2 F0 80 BD E8 01 30 A0 E3 00 30 8D E5 94 30 9F E5 04 00 A0 E1 04 30 8D E5 20 70 8D E5 ?? ?? ?? ?? 00 30 96 E5 00 00 53 E3 08 00 8D E5 0C 10 8D E5 10 00 8D E5 14 10 8D E5 0C 00 00 1A 0E 33 E0 E3 01 36 43 E2 0E 42 A0 E3 18 30 8D E5 1C 40 8D E5 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 DB FF FF 1A ?? ?? ?? ?? 21 30 A0 E3 00 30 80 E5 D7 FF FF EA 02 00 53 E3 02 31 A0 E3 C3 35 A0 E1 00 40 A0 E3 18 30 8D E5 1C 40 8D E5 F4 FF FF 0A EF FF FF EA ?? ?? ?? ?? 22 30 A0 E3 00 30 80 E5 CB FF FF EA ?? ?? ?? ?? DB 0F 49 5A ?? ?? ?? ?? }
	condition:
		$1
}

rule file_153_1_1 {
	meta:
		name = "j0f"
		size = 252
		refs = "000c __ieee754_j0f 0028 isnanf 0044 fabsf 004c __gtsf2 0070 __extendsfdf2 00a4 matherr 00c4 __truncdfsf2 00d0 __errno 00f0 __fdlib_version"
	strings:
		$1 = { F0 40 2D E9 24 D0 4D E2 00 60 A0 E1 ?? ?? ?? ?? D8 50 9F E5 00 30 95 E5 01 00 73 E3 00 40 A0 E1 03 00 00 0A 06 00 A0 E1 ?? ?? ?? ?? 00 70 50 E2 02 00 00 0A 04 00 A0 E1 24 D0 8D E2 F0 80 BD E8 06 00 A0 E1 ?? ?? ?? ?? A4 10 9F E5 ?? ?? ?? ?? 00 00 50 E3 F6 FF FF DA 05 30 A0 E3 00 30 8D E5 90 30 9F E5 06 00 A0 E1 04 30 8D E5 20 70 8D E5 ?? ?? ?? ?? 00 30 95 E5 00 40 A0 E3 02 00 53 E3 00 30 A0 E3 08 00 8D E5 0C 10 8D E5 18 30 8D E5 1C 40 8D E5 10 00 8D E5 14 10 8D E5 0B 00 00 0A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 07 00 00 0A 20 30 9D E5 00 00 53 E3 08 00 00 1A 18 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 40 A0 E1 D8 FF FF EA ?? ?? ?? ?? 22 30 A0 E3 00 30 80 E5 F3 FF FF EA ?? ?? ?? ?? 20 30 9D E5 00 30 80 E5 F2 FF FF EA ?? ?? ?? ?? DB 0F 49 5A ?? ?? ?? ?? }
	condition:
		$1
}

rule file_190_1_1 {
	meta:
		name = "j1f"
		size = 252
		refs = "000c __ieee754_j1f 0028 isnanf 0044 fabsf 004c __gtsf2 0070 __extendsfdf2 00a4 matherr 00c4 __truncdfsf2 00d0 __errno 00f0 __fdlib_version"
	strings:
		$1 = { F0 40 2D E9 24 D0 4D E2 00 60 A0 E1 ?? ?? ?? ?? D8 50 9F E5 00 30 95 E5 01 00 73 E3 00 40 A0 E1 03 00 00 0A 06 00 A0 E1 ?? ?? ?? ?? 00 70 50 E2 02 00 00 0A 04 00 A0 E1 24 D0 8D E2 F0 80 BD E8 06 00 A0 E1 ?? ?? ?? ?? A4 10 9F E5 ?? ?? ?? ?? 00 00 50 E3 F6 FF FF DA 05 30 A0 E3 00 30 8D E5 90 30 9F E5 06 00 A0 E1 04 30 8D E5 20 70 8D E5 ?? ?? ?? ?? 00 30 95 E5 00 40 A0 E3 02 00 53 E3 00 30 A0 E3 08 00 8D E5 0C 10 8D E5 18 30 8D E5 1C 40 8D E5 10 00 8D E5 14 10 8D E5 0B 00 00 0A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 07 00 00 0A 20 30 9D E5 00 00 53 E3 08 00 00 1A 18 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 40 A0 E1 D8 FF FF EA ?? ?? ?? ?? 22 30 A0 E3 00 30 80 E5 F3 FF FF EA ?? ?? ?? ?? 20 30 9D E5 00 30 80 E5 F2 FF FF EA ?? ?? ?? ?? DB 0F 49 5A ?? ?? ?? ?? }
	condition:
		$1
}

rule file_156_0_1 {
	meta:
		name = "sin"
		size = 300
		refs = "004c __subdf3 006c __ieee754_rem_pio2 00a0 __kernel_sin 0100 __kernel_cos"
	strings:
		$1 = { F0 48 2D E9 5B 39 E0 E3 1E 3C 43 E2 02 C1 C0 E3 13 31 43 E2 03 00 5C E1 14 D0 4D E2 00 40 A0 E1 01 50 A0 E1 00 60 A0 E1 00 B0 A0 E1 00 70 A0 E1 1E 00 00 DA 02 31 E0 E3 01 36 43 E2 03 00 5C E1 08 00 00 DA 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 00 30 A0 E1 01 20 A0 E1 03 00 A0 E1 02 10 A0 E1 14 D0 8D E2 F0 88 BD E8 04 20 8D E2 ?? ?? ?? ?? 03 00 00 E2 01 00 50 E3 1D 00 00 0A 02 00 50 E3 12 00 00 0A 00 00 50 E3 20 00 00 1A 0C 30 8D E2 0C 00 93 E8 01 C0 A0 E3 03 00 9D E9 00 C0 8D E5 ?? ?? ?? ?? 00 30 A0 E1 01 20 A0 E1 E9 FF FF EA 00 20 A0 E3 00 30 A0 E3 00 C0 A0 E3 00 C0 8D E5 ?? ?? ?? ?? 00 30 A0 E1 01 20 A0 E1 E1 FF FF EA 0C 30 8D E2 0C 00 93 E8 01 C0 A0 E3 03 00 9D E9 00 C0 8D E5 ?? ?? ?? ?? 02 31 80 E2 01 20 A0 E1 D8 FF FF EA 0C 30 8D E2 0C 00 93 E8 03 00 9D E9 ?? ?? ?? ?? 00 30 A0 E1 01 20 A0 E1 D1 FF FF EA 0C 30 8D E2 0C 00 93 E8 03 00 9D E9 ?? ?? ?? ?? 02 31 80 E2 01 20 A0 E1 CA FF FF EA }
	condition:
		$1
}

rule file_157_0_1 {
	meta:
		name = "__ieee754_log"
		size = 1468
		refs = "0044 __muldf3 00b4 __subdf3 00dc __eqdf2 00fc __floatsidf 0140 __adddf3 0180 __divdf3"
	strings:
		$1 = { F0 4D 2D E9 01 06 50 E3 01 60 A0 E1 01 40 A0 E1 18 D0 4D E2 00 50 A0 E1 00 E0 A0 E1 00 10 A0 A3 0D 00 00 AA 02 C1 C0 E3 06 C0 9C E1 B8 00 00 0A 00 00 50 E3 36 01 00 BA 43 24 A0 E3 05 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 01 60 A0 E1 01 40 A0 E1 00 50 A0 E1 00 E0 A0 E1 35 10 E0 E3 02 31 E0 E3 01 36 43 E2 03 00 5E E1 36 00 00 CA FF 44 CE E3 0F 46 C4 E3 95 CA 84 E2 F6 CE 8C E2 04 C0 8C E2 FF 25 A0 E3 01 C6 0C E2 03 26 82 E2 02 20 2C E0 FF 3F 41 E2 03 30 43 E2 04 00 82 E1 FF 25 A0 E3 06 10 A0 E1 03 26 82 E2 4E 6A 83 E0 00 30 A0 E3 2C 6A 86 E0 ?? ?? ?? ?? 02 30 84 E2 FF 34 C3 E3 0F 36 C3 E3 02 00 53 E3 00 70 A0 E1 01 80 A0 E1 23 00 00 CA 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 91 00 00 1A 00 00 56 E3 00 00 A0 03 00 10 A0 03 18 00 00 0A 06 00 A0 E1 ?? ?? ?? ?? 36 3E 8F E2 0C 00 93 E8 00 60 A0 E1 01 70 A0 E1 ?? ?? ?? ?? D1 3F 8F E2 0C 00 93 E8 00 40 A0 E1 01 50 A0 E1 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 04 00 00 EA 05 00 A0 E1 06 10 A0 E1 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 18 D0 8D E2 F0 8D BD E8 01 21 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 08 00 8D E5 0C 10 8D E5 06 00 A0 E1 ?? ?? ?? ?? 10 00 8D E5 14 10 8D E5 08 10 8D E2 03 00 91 E8 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 03 00 8D E8 ?? ?? ?? ?? 96 3F 8F E2 0C 00 93 E8 00 A0 A0 E1 01 B0 A0 E1 ?? ?? ?? ?? 93 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? 8F 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? 8B 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 0C 00 9D E8 ?? ?? ?? ?? 22 3E 8F E2 0C 00 93 E8 03 00 8D E8 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 21 3E 8F E2 0C 00 93 E8 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? 02 3C 8F E2 0C 00 93 E8 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 03 00 9D E8 ?? ?? ?? ?? 61 5A 44 E2 6B 4A 64 E2 47 5E 45 E2 85 4E 84 E2 0A 50 45 E2 01 40 84 E2 05 40 84 E1 00 00 54 E3 00 A0 A0 E1 01 B0 A0 E1 43 00 00 DA FF 25 A0 E3 02 26 82 E2 00 30 A0 E3 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? 00 00 56 E3 00 40 A0 E1 01 50 A0 E1 69 00 00 1A 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? 08 30 8D E2 0C 00 93 E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 91 FF FF EA C3 04 A0 E3 00 20 A0 E3 00 30 A0 E3 05 06 80 E2 00 10 A0 E3 ?? ?? ?? ?? 8A FF FF EA 07 20 A0 E1 08 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 43 3F 8F E2 0C 00 93 E8 00 40 A0 E1 01 50 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? FF 25 A0 E3 02 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 00 56 E3 00 40 A0 E1 01 50 A0 E1 66 00 00 1A 07 00 A0 E1 08 10 A0 E1 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 6B FF FF EA 00 00 56 E3 78 00 00 0A AC 30 8F E2 0C 00 93 E8 10 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 0A 20 A0 E1 03 00 8D E8 0B 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 08 30 8D E2 0C 00 93 E8 ?? ?? ?? ?? 7C 30 8F E2 0C 00 93 E8 00 40 A0 E1 01 50 A0 E1 10 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 34 00 00 EA 12 F1 C2 3F 44 52 3E DF 64 46 C7 3F DE 03 CB 96 24 49 D2 3F 59 93 22 94 55 55 E5 3F 93 55 55 55 09 9A C3 3F 9F C6 78 D0 C5 71 CC 3F AF 78 8E 1D 99 99 D9 3F 04 FA 97 99 55 55 D5 BF 55 55 55 55 EF 39 EA 3D 76 3C 79 35 42 2E E6 3F 00 00 E0 FE EF 39 EA BD 76 3C 79 35 18 30 4F E2 0C 00 93 E8 10 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 0A 20 A0 E1 03 00 8D E8 0B 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 08 30 8D E2 0C 00 93 E8 ?? ?? ?? ?? 58 30 4F E2 0C 00 93 E8 00 A0 A0 E1 01 B0 A0 E1 10 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 03 00 9D E8 ?? ?? ?? ?? 11 FF FF EA 06 30 A0 E1 00 20 A0 E1 ?? ?? ?? ?? 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 0A FF FF EA 06 00 A0 E1 ?? ?? ?? ?? D8 30 4F E2 0C 00 93 E8 00 A0 A0 E1 01 B0 A0 E1 ?? ?? ?? ?? E4 30 4F E2 0C 00 93 E8 08 00 8D E5 0C 10 8D E5 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 08 10 8D E2 03 00 91 E8 ?? ?? ?? ?? F0 FE FF EA 00 20 A0 E1 01 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 08 30 8D E2 0C 00 93 E8 ?? ?? ?? ?? 4F FF FF EA }
	condition:
		$1
}

rule file_158_0_1 {
	meta:
		name = "floor"
		size = 408
		refs = "0064 __adddf3 0070 __gtdf2"
	strings:
		$1 = { F0 47 2D E9 40 4A A0 E1 84 4A A0 E1 A4 4A A0 E1 FF 4F 44 E2 03 40 44 E2 13 00 54 E3 00 20 A0 E1 01 30 A0 E1 00 50 A0 E1 01 60 A0 E1 00 70 A0 E1 00 A0 A0 E1 01 80 A0 E1 15 00 00 CA 00 00 54 E3 2E 00 00 BA 01 C6 A0 E3 01 C0 4C E2 5C 94 A0 E1 00 70 09 E0 01 70 97 E1 0A 00 00 0A 4B 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 34 00 00 CA 06 70 A0 E1 05 20 A0 E1 07 30 A0 E1 02 00 A0 E1 03 10 A0 E1 F0 87 BD E8 33 00 54 E3 05 00 00 DA 01 0B 54 E3 F8 FF FF 1A ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 F4 FF FF EA 14 C0 44 E2 00 70 E0 E3 37 7C A0 E1 01 00 17 E1 EF FF FF 0A C0 30 8F E2 0C 00 93 E8 ?? ?? ?? ?? 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 E4 FF FF DA 00 00 55 E3 1D 00 00 BA 06 30 A0 E1 07 70 C3 E1 0A 50 A0 E1 DF FF FF EA 88 30 8F E2 0C 00 93 E8 ?? ?? ?? ?? 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 D6 FF FF DA 00 00 55 E3 00 70 A0 A3 07 50 A0 A1 D3 FF FF AA 02 71 C7 E3 06 70 87 E1 BF A4 A0 E3 00 00 57 E3 0F A6 8A E2 0A 50 A0 11 00 70 A0 13 CB FF FF EA 00 00 55 E3 01 36 A0 B3 53 A4 85 B0 00 70 A0 E3 09 50 CA E1 C5 FF FF EA 14 00 54 E3 05 00 00 0A 34 40 64 E2 01 30 A0 E3 13 34 86 E0 03 00 56 E1 01 A0 85 82 DA FF FF EA 01 A0 85 E2 D7 FF FF EA 3C E4 37 7E 9C 75 00 88 }
	condition:
		$1
}

rule file_159_0_1 {
	meta:
		name = "remainderf"
		size = 264
		refs = "0010 __ieee754_remainderf 002c isnanf 0040 __eqsf2 0064 __extendsfdf2 0090 __divdf3 00ac matherr 00cc __truncdfsf2 00e0 __errno 0100 __fdlib_version"
	strings:
		$1 = { F0 41 2D E9 24 D0 4D E2 00 70 A0 E1 01 60 A0 E1 ?? ?? ?? ?? E4 40 9F E5 00 30 94 E5 01 00 73 E3 00 50 A0 E1 2A 00 00 0A 06 00 A0 E1 ?? ?? ?? ?? 00 80 50 E2 26 00 00 1A 06 00 A0 E1 00 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 21 00 00 1A 01 30 A0 E3 00 30 8D E5 A8 30 9F E5 07 00 A0 E1 04 30 8D E5 20 80 8D E5 ?? ?? ?? ?? 08 00 8D E5 0C 10 8D E5 06 00 A0 E1 ?? ?? ?? ?? 10 00 8D E5 14 10 8D E5 00 00 A0 E3 00 10 A0 E3 01 30 A0 E1 00 20 A0 E1 ?? ?? ?? ?? 00 30 94 E5 02 00 53 E3 18 00 8D E5 1C 10 8D E5 0D 00 00 0A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 09 00 00 0A 20 30 9D E5 00 00 53 E3 0A 00 00 1A 18 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 50 A0 E1 05 00 A0 E1 24 D0 8D E2 F0 81 BD E8 ?? ?? ?? ?? 21 30 A0 E3 00 30 80 E5 F1 FF FF EA ?? ?? ?? ?? 20 30 9D E5 00 30 80 E5 F0 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_162_0_1 {
	meta:
		name = "asin"
		size = 264
		refs = "0010 __ieee754_asin 0034 __isnand 0058 fabs 0068 __gtdf2 009c nan 00b8 matherr 00dc __errno 00fc __fdlib_version"
	strings:
		$1 = { F0 45 2D E9 24 D0 4D E2 00 70 A0 E1 01 80 A0 E1 ?? ?? ?? ?? E0 60 9F E5 00 30 96 E5 01 00 73 E3 00 40 A0 E1 01 50 A0 E1 04 00 00 0A 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 A0 50 E2 03 00 00 0A 04 00 A0 E1 05 10 A0 E1 24 D0 8D E2 F0 85 BD E8 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? FF 25 A0 E3 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 F2 FF FF DA 01 30 A0 E3 00 30 8D E5 7C 30 9F E5 7C 00 9F E5 04 30 8D E5 20 A0 8D E5 08 70 8D E5 0C 80 8D E5 10 70 8D E5 14 80 8D E5 ?? ?? ?? ?? 00 30 96 E5 02 00 53 E3 18 00 8D E5 1C 10 8D E5 09 00 00 0A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 05 00 00 0A 20 30 9D E5 00 00 53 E3 06 00 00 1A 18 50 8D E2 30 00 95 E8 D8 FF FF EA ?? ?? ?? ?? 21 30 A0 E3 00 30 80 E5 F5 FF FF EA ?? ?? ?? ?? 20 30 9D E5 00 30 80 E5 F4 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_166_0_1 {
	meta:
		name = "acos"
		size = 264
		refs = "0010 __ieee754_acos 0034 __isnand 0058 fabs 0068 __gtdf2 009c nan 00b8 matherr 00dc __errno 00fc __fdlib_version"
	strings:
		$1 = { F0 45 2D E9 24 D0 4D E2 00 70 A0 E1 01 80 A0 E1 ?? ?? ?? ?? E0 60 9F E5 00 30 96 E5 01 00 73 E3 00 40 A0 E1 01 50 A0 E1 04 00 00 0A 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 A0 50 E2 03 00 00 0A 04 00 A0 E1 05 10 A0 E1 24 D0 8D E2 F0 85 BD E8 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? FF 25 A0 E3 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 F2 FF FF DA 01 30 A0 E3 00 30 8D E5 7C 30 9F E5 7C 00 9F E5 04 30 8D E5 20 A0 8D E5 08 70 8D E5 0C 80 8D E5 10 70 8D E5 14 80 8D E5 ?? ?? ?? ?? 00 30 96 E5 02 00 53 E3 18 00 8D E5 1C 10 8D E5 09 00 00 0A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 05 00 00 0A 20 30 9D E5 00 00 53 E3 06 00 00 1A 18 50 8D E2 30 00 95 E8 D8 FF FF EA ?? ?? ?? ?? 21 30 A0 E3 00 30 80 E5 F5 FF FF EA ?? ?? ?? ?? 20 30 9D E5 00 30 80 E5 F4 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_164_0_1 {
	meta:
		name = "log1pf"
		size = 1136
		refs = "0044 __eqsf2 0058 __divsf3 00a8 __subsf3 00b4 __mulsf3 00fc __floatsisf 012c __addsf3 0178 __gtsf2"
	strings:
		$1 = { 02 31 E0 E3 02 35 43 E2 03 00 50 E1 F0 47 2D E9 00 40 A0 E1 00 50 A0 E1 49 00 00 CA A7 31 E0 E3 4A 37 43 E2 FB 3B 43 E2 03 00 50 E1 0C 00 00 CA 02 31 C0 E3 FE 05 53 E3 46 00 00 BA BF 14 A0 E3 02 15 81 E2 ?? ?? ?? ?? 00 00 50 E3 D1 00 00 1A 33 03 A0 E3 00 10 A0 E3 ?? ?? ?? ?? 00 40 A0 E1 3A 00 00 EA 5A 04 50 E3 C0 6B A0 A1 00 80 A0 A3 7F 60 46 A2 57 00 00 BA 35 38 A0 E3 FF 44 C5 E3 4F 3E 83 E2 02 45 C4 E3 06 30 83 E2 03 00 54 E1 02 35 64 C2 3F 04 84 C3 FE 05 84 D3 FE 15 A0 E3 43 41 A0 C1 01 60 86 C2 ?? ?? ?? ?? 3F 14 A0 E3 00 50 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 00 54 E3 00 A0 A0 E1 05 40 A0 E1 00 70 A0 E1 58 00 00 1A 05 00 A0 E1 00 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 9B 00 00 1A 00 00 56 E3 00 40 A0 03 15 00 00 0A 06 00 A0 E1 ?? ?? ?? ?? 3F 14 A0 E3 C5 19 81 E2 C6 1D 81 E2 00 50 A0 E1 ?? ?? ?? ?? 30 13 9F E5 00 40 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 02 00 00 EA 00 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 04 00 A0 E1 F0 87 BD E8 31 04 53 E3 15 00 00 AA 13 13 A0 E3 92 05 53 E3 00 50 A0 A3 01 50 A0 B3 ?? ?? ?? ?? 00 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 00 30 A0 E3 01 30 A0 C3 03 00 15 E1 EF FF FF 1A 04 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? BF 14 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 E5 FF FF EA 41 54 80 E2 41 34 A0 E3 6A 38 83 E2 6A 58 85 E2 9E 3E 83 E2 9E 5E 85 E2 03 00 55 E1 11 00 00 8A 04 00 A0 E1 FE 15 A0 E3 ?? ?? ?? ?? C0 6B A0 E1 7F 60 46 E2 00 00 56 E3 00 70 A0 E1 00 50 A0 E1 8D 00 00 DA 04 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 FE 05 A0 E3 ?? ?? ?? ?? 07 10 A0 E1 ?? ?? ?? ?? 00 80 A0 E1 95 FF FF EA 3F 14 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 60 A0 E3 00 70 A0 E1 01 11 A0 E3 04 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 00 A0 A0 E1 ?? ?? ?? ?? E8 11 9F E5 00 50 A0 E1 ?? ?? ?? ?? E0 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? D4 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? C8 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? BC 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? B0 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? A4 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 00 00 56 E3 00 50 A0 E1 36 00 00 0A 06 00 A0 E1 ?? ?? ?? ?? 3F 14 A0 E3 C5 19 81 E2 C6 1D 81 E2 00 90 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 00 60 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 0A 10 A0 E1 ?? ?? ?? ?? 38 11 9F E5 00 50 A0 E1 09 00 A0 E1 ?? ?? ?? ?? 08 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 04 00 A0 E1 F0 87 BD E8 08 11 9F E5 05 00 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 0A 10 A0 E1 ?? ?? ?? ?? 00 00 56 E3 00 40 A0 E1 18 00 00 1A 04 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 6D FF FF EA 04 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 66 FF FF EA 00 10 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 0A 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 59 FF FF EA 06 00 A0 E1 ?? ?? ?? ?? 3F 14 A0 E3 C5 19 81 E2 C6 1D 81 E2 00 70 A0 E1 ?? ?? ?? ?? 40 10 9F E5 00 60 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 C2 FF FF EA FE 15 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 70 FF FF EA D1 F7 17 37 97 88 17 3E 4F D0 1C 3E 25 33 3A 3E 29 8E 63 3E 25 49 92 3E CD CC CC 3E AB AA 2A 3F AB AA 2A BF }
	condition:
		$1
}

rule file_165_0_1 {
	meta:
		name = "expm1"
		size = 1672
		refs = "00b4 __muldf3 00f0 __adddf3 0108 __subdf3 01d4 __divdf3 0298 __gtdf2 02c8 __ltdf2 0300 __fixdfsi 0308 __floatsidf"
	strings:
		$1 = { F0 4D 2D E9 D8 C4 9F E5 02 31 C0 E3 0C 00 53 E1 10 D0 4D E2 00 40 A0 E1 01 50 A0 E1 02 61 00 E2 14 00 00 9A 86 C8 A0 E3 B9 CD 8C E2 05 C1 8C E2 0C 00 53 E1 9A 00 00 9A 02 C1 E0 E3 01 C6 4C E2 0C 00 53 E1 91 00 00 9A FF 24 C0 E3 0F 26 C2 E3 01 20 92 E1 00 70 A0 E1 01 80 A0 E1 83 01 00 1A 00 00 56 E3 D8 00 00 0A BF 44 A0 E3 0F 46 84 E2 00 50 A0 E3 D4 00 00 EA A7 29 E0 E3 46 2D 42 E2 F7 21 42 E2 02 00 53 E1 D9 00 00 8A C3 24 E0 E3 07 26 42 E2 02 00 53 E1 00 60 A0 83 F6 00 00 9A FF 25 A0 E3 02 26 82 E2 00 30 A0 E3 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 A0 A0 E1 01 B0 A0 E1 0A 20 A0 E1 0B 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? EE 3F 8F E2 0C 00 93 E8 00 70 A0 E1 01 80 A0 E1 ?? ?? ?? ?? EB 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? E7 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? E3 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? DF 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? FF 25 A0 E3 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 03 00 8D E8 ?? ?? ?? ?? 00 20 A0 E1 01 01 A0 E3 01 30 A0 E1 02 07 80 E2 00 10 A0 E3 ?? ?? ?? ?? 00 A0 A0 E1 01 B0 A0 E1 0A 20 A0 E1 03 00 9D E8 0B 30 A0 E1 ?? ?? ?? ?? 0A 20 A0 E1 03 00 8D E8 0B 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 01 A0 E3 01 30 A0 E1 06 07 80 E2 00 10 A0 E3 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 03 00 9D E8 ?? ?? ?? ?? 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? 00 00 56 E3 00 20 A0 E1 01 30 A0 E1 68 00 00 0A 08 30 8D E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 08 30 8D E2 0C 00 93 E8 ?? ?? ?? ?? 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? 01 00 76 E3 00 70 A0 E1 01 80 A0 E1 D4 00 00 0A 01 00 56 E3 B9 00 00 0A 01 30 86 E2 39 00 53 E3 7A 00 00 8A 13 00 56 E3 DD 00 00 CA 02 36 A0 E3 53 36 A0 E1 04 20 A0 E1 FF 75 63 E2 05 30 A0 E1 ?? ?? ?? ?? 00 80 A0 E3 03 76 87 E2 00 20 A0 E1 01 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 01 50 A0 E1 06 4A 80 E0 4E 00 00 EA 89 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 00 00 50 E3 DB 00 00 CA 00 00 56 E3 4D 00 00 0A 21 3E 8F E2 0C 00 93 E8 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 64 FF FF BA BF 64 A0 E3 0E 66 86 E2 00 70 A0 E3 79 3F 8F E2 0C 00 93 E8 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 00 60 A0 E1 ?? ?? ?? ?? 07 3D 8F E2 0C 00 93 E8 00 A0 A0 E1 01 B0 A0 E1 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 6A 3F 8F E2 0C 00 93 E8 00 70 A0 E1 01 80 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 00 A0 A0 E1 01 B0 A0 E1 0A 20 A0 E1 0B 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 04 20 A0 E1 05 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? 08 00 8D E5 0C 10 8D E5 41 FF FF EA 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 04 00 A0 E1 05 10 A0 E1 10 D0 8D E2 F0 8D BD E8 00 00 56 E3 BB FF FF 1A FF 65 A0 E3 02 66 86 E2 00 70 A0 E3 BA FF FF EA F5 2A E0 E3 35 2D 42 E2 3B 21 42 E2 02 00 53 E1 F4 FF FF 8A 00 00 56 E3 3B 00 00 1A D0 30 8F E2 0C 00 93 E8 ?? ?? ?? ?? 01 60 A0 E3 B4 B0 8F E2 00 0C 9B E8 00 70 A0 E1 01 80 A0 E1 C6 FF FF EA 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 FF 05 A0 E3 01 30 A0 E1 03 06 80 E2 00 10 A0 E3 ?? ?? ?? ?? FF 25 A0 E3 06 3A 80 E0 03 00 A0 E1 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 D3 FF FF EA 74 30 8F E2 0C 00 93 E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 C5 FF FF EA B7 FD 8A BE 2D C3 09 6E CA CF D0 3E 39 52 E6 86 19 CE 14 3F B7 DB AA 9E A0 01 5A 3F 85 55 FE 19 11 11 A1 3F F4 10 11 11 42 2E 86 40 EF 39 FA FE 1F 6E A5 01 59 F3 F8 C2 47 15 F7 3F FE 82 2B 65 42 2E E6 BF 00 00 E0 FE EF 39 EA 3D 76 3C 79 35 79 68 43 40 42 2E E6 3F 00 00 E0 FE EF 39 EA BD 76 3C 79 35 3C E4 37 7E 9C 75 00 88 20 30 4F E2 0C 00 93 E8 ?? ?? ?? ?? 00 60 E0 E3 28 B0 4F E2 00 0C 9B E8 00 70 A0 E1 01 80 A0 E1 8A FF FF EA BF 24 A0 E3 04 00 A0 E1 05 10 A0 E1 0D 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 3B 00 00 AA FF 25 A0 E3 04 00 A0 E1 05 10 A0 E1 02 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 03 21 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 90 FF FF EA 04 00 A0 E1 05 10 A0 E1 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? FF 25 A0 E3 02 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? FF 25 A0 E3 02 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 80 FF FF EA FF 3F 66 E2 03 30 83 E2 03 7A A0 E1 00 80 A0 E3 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? FF 25 A0 E3 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 01 50 A0 E1 06 4A 80 E0 6D FF FF EA 49 1F 4F E2 03 00 91 E8 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 65 FF FF EA 04 00 A0 E1 05 10 A0 E1 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? FF 25 A0 E3 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 56 FF FF EA 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 50 FF FF EA }
	condition:
		$1
}

rule file_168_0_1 {
	meta:
		name = "__ieee754_hypotf"
		size = 572
		refs = "0070 __mulsf3 0098 __subsf3 00a4 __gtsf2 00fc __addsf3 0134 __ieee754_sqrtf"
	strings:
		$1 = { F0 47 2D E9 02 41 C0 E3 02 51 C1 E3 05 00 54 E1 04 30 A0 B1 05 40 A0 B1 03 50 A0 B1 04 30 65 E0 0F 04 53 E3 04 00 A0 E1 05 60 A0 E1 55 00 00 CA 16 33 A0 E3 02 35 83 E2 03 00 54 E1 04 70 A0 D1 00 80 A0 D3 41 00 00 CA 9A 05 55 E3 0F 00 00 AA 00 00 55 E3 07 00 A0 01 F0 87 BD 08 02 05 55 E3 6F 00 00 AA 7E 14 A0 E3 06 00 A0 E1 02 15 81 E2 ?? ?? ?? ?? 7E 14 A0 E3 00 60 A0 E1 02 15 81 E2 07 00 A0 E1 ?? ?? ?? ?? 7E 80 48 E2 00 70 A0 E1 06 10 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 06 10 A0 E1 00 A0 A0 E1 ?? ?? ?? ?? 00 00 50 E3 38 00 00 CA FF 5E C5 E3 02 45 84 E2 0F 50 C5 E3 04 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 0A 10 A0 E1 00 90 A0 E1 02 01 8A E2 ?? ?? ?? ?? 05 10 A0 E1 00 A0 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 07 10 A0 E1 00 50 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 06 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 09 00 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 58 E3 F0 87 BD 08 88 1B A0 E1 FE 15 81 E2 ?? ?? ?? ?? F0 87 BD E8 02 31 E0 E3 02 35 43 E2 03 00 54 E1 2A 00 00 DA 7F 34 A0 E3 02 35 83 E2 03 00 54 E1 05 10 A0 11 ?? ?? ?? ?? 7F 34 A0 E3 02 35 83 E2 03 00 55 E1 06 00 A0 01 F0 87 BD E8 05 10 A0 E1 ?? ?? ?? ?? F0 87 BD E8 FF 4E C4 E3 0F 40 C4 E3 04 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 06 10 A0 E1 00 50 A0 E1 02 01 86 E2 ?? ?? ?? ?? 04 10 A0 E1 00 60 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 00 A0 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 58 E3 CD FF FF 1A F0 87 BD E8 DE 44 84 E2 DE 54 85 E2 04 70 A0 E1 05 60 A0 E1 44 80 A0 E3 88 FF FF EA 22 44 84 E2 22 54 85 E2 44 80 48 E2 04 70 A0 E1 05 60 A0 E1 94 FF FF EA }
	condition:
		$1
}

rule file_169_0_1 {
	meta:
		name = "scalbf"
		size = 472
		refs = "0010 __ieee754_scalbf 0028 finitef 003c __eqsf2 0050 __nesf2 0078 __errno 008c isnanf 00b0 __gtsf2 00ec __extendsfdf2 017c copysign 0198 matherr 01c4 __truncdfsf2 01d0 __fdlib_version"
	strings:
		$1 = { F0 43 2D E9 24 D0 4D E2 00 60 A0 E1 01 70 A0 E1 ?? ?? ?? ?? B4 41 9F E5 00 30 94 E5 01 00 73 E3 00 50 A0 E1 10 00 00 0A ?? ?? ?? ?? 00 00 50 E3 14 00 00 0A 05 00 A0 E1 00 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 04 00 00 1A 06 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 33 00 00 1A 07 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 02 00 00 0A 05 00 A0 E1 24 D0 8D E2 F0 83 BD E8 ?? ?? ?? ?? 22 30 A0 E3 00 30 80 E5 F8 FF FF EA 05 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 E6 FF FF 1A 06 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 E2 FF FF 0A 00 10 A0 E3 06 00 A0 E1 ?? ?? ?? ?? 03 30 A0 E3 00 30 8D E5 10 31 9F E5 00 00 50 E3 02 81 A0 D3 7F 84 A0 C3 04 30 8D E5 06 00 A0 E1 00 30 A0 E3 C8 85 A0 D1 00 90 A0 D3 0F 86 88 C2 00 90 A0 C3 20 30 8D E5 ?? ?? ?? ?? 08 00 8D E5 0C 10 8D E5 07 00 A0 E1 ?? ?? ?? ?? 00 30 94 E5 02 00 53 E3 18 80 8D E5 1C 90 8D E5 10 00 8D E5 14 10 8D E5 1D 00 00 1A ?? ?? ?? ?? 22 30 A0 E3 00 30 80 E5 1D 00 00 EA 04 30 A0 E3 00 30 8D E5 98 30 9F E5 06 00 A0 E1 04 30 8D E5 00 30 A0 E3 20 30 8D E5 ?? ?? ?? ?? 00 50 A0 E1 01 60 A0 E1 07 00 A0 E1 08 50 8D E5 0C 60 8D E5 ?? ?? ?? ?? 06 30 A0 E1 10 00 8D E5 14 10 8D E5 05 20 A0 E1 00 00 A0 E3 00 10 A0 E3 ?? ?? ?? ?? 00 30 94 E5 02 00 53 E3 18 00 8D E5 1C 10 8D E5 E1 FF FF 0A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 DD FF FF 0A 20 30 9D E5 00 00 53 E3 02 00 00 0A ?? ?? ?? ?? 20 30 9D E5 00 30 80 E5 18 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 50 A0 E1 A6 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_173_0_1 {
	meta:
		name = "__ieee754_sinh"
		size = 660
		refs = "0064 __adddf3 0074 __gtdf2 0088 fabs 008c expm1 00c4 __muldf3 00f8 __divdf3 010c __subdf3 01dc __ieee754_exp"
	strings:
		$1 = { 02 31 E0 E3 F0 4F 2D E9 01 36 43 E2 02 81 C0 E3 03 00 58 E1 00 60 A0 E1 01 70 A0 E1 5F 00 00 CA 00 00 50 E3 BF 34 E0 E3 BF 44 A0 B3 FF 45 A0 A3 CA 38 43 E2 0E 46 84 B2 00 50 A0 B3 02 46 84 A2 00 50 A0 A3 03 00 58 E1 38 00 00 CA C1 34 E0 E3 0D 36 43 E2 03 00 58 E1 71 00 00 CA 8A 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? FF 25 A0 E3 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 28 00 00 CA 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 00 60 A0 E1 01 70 A0 E1 06 20 A0 E1 07 30 A0 E1 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 06 20 A0 E1 00 A0 A0 E1 01 B0 A0 E1 07 30 A0 E1 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? FF 25 A0 E3 00 80 A0 E1 01 90 A0 E1 03 26 82 E2 00 30 A0 E3 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 00 60 A0 E1 01 70 A0 E1 06 00 A0 E1 07 10 A0 E1 F0 8F BD E8 86 38 A0 E3 B9 3D 83 E2 05 31 83 E2 03 00 58 E1 4E 00 00 DA 86 38 A0 E3 CF 3D 83 E2 35 31 83 E2 03 00 58 E1 19 00 00 DA 86 28 A0 E3 27 32 E0 E3 CF 2D 82 E2 46 38 43 E2 39 21 82 E2 1E 3D 43 E2 03 00 51 E1 02 00 58 91 10 00 00 0A 07 10 A0 E1 41 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 00 60 A0 E1 01 70 A0 E1 06 00 A0 E1 07 10 A0 E1 F0 8F BD E8 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 00 60 A0 E1 01 70 A0 E1 06 00 A0 E1 07 10 A0 E1 F0 8F BD E8 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? FF 25 A0 E3 02 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? ?? ?? ?? ?? 00 60 A0 E1 01 70 A0 E1 06 20 A0 E1 07 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 00 60 A0 E1 01 70 A0 E1 06 00 A0 E1 07 10 A0 E1 F0 8F BD E8 ?? ?? ?? ?? ?? ?? ?? ?? 03 31 E0 E3 01 36 43 E2 03 00 58 E1 00 60 A0 E1 01 70 A0 E1 94 FF FF DA FF 25 A0 E3 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? A3 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? A0 FF FF EA 1F 7B AC 7F 33 74 AC 3C }
	condition:
		$1
}

rule file_174_0_1 {
	meta:
		name = "__ieee754_atan2f"
		size = 476
		refs = "00b0 __divsf3 00b4 fabsf 00b8 atanf 00dc __addsf3 00ec __subsf3"
	strings:
		$1 = { 7F 34 A0 E3 F0 40 2D E9 02 35 83 E2 02 61 C1 E3 02 41 C0 E3 03 00 54 E1 03 00 56 D1 00 20 A0 E1 00 50 A0 E1 3C 00 00 CA FE 05 51 E3 42 00 00 0A 41 7F A0 E1 02 70 07 E2 00 00 54 E3 A0 7F 87 E1 07 00 00 1A 02 00 57 E3 37 00 00 0A 03 00 57 E3 2F 00 00 1A 49 28 A0 E3 FD 2E 82 E2 2F 21 82 E2 2B 00 00 EA 00 00 56 E3 22 00 00 0A 03 00 56 E1 3C 00 00 0A 03 00 54 E1 1E 00 00 0A 04 40 66 E0 C4 4B A0 E1 3C 00 54 E3 DB 09 E0 C3 03 0A 40 C2 93 01 40 C2 08 00 00 CA 3C 00 74 E3 00 40 A0 A3 01 40 A0 B3 A1 4F 14 E0 00 00 A0 13 02 00 00 1A ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 01 00 57 E3 02 21 80 02 12 00 00 0A 02 00 57 E3 1C 00 00 0A 00 00 57 E3 05 00 00 0A F8 10 9F E5 ?? ?? ?? ?? 49 18 A0 E3 FD 1E 81 E2 2D 11 81 E2 ?? ?? ?? ?? 00 20 A0 E1 06 00 00 EA 00 00 55 E3 DB 29 E0 A3 DB 29 E0 B3 03 2A 42 A2 03 2A 42 B2 93 21 42 A2 91 21 42 B2 02 00 A0 E1 F0 80 BD E8 ?? ?? ?? ?? 00 20 A0 E1 02 00 A0 E1 F0 80 BD E8 49 28 A0 E3 FD 2E 82 E2 2D 21 82 E2 F5 FF FF EA F0 40 BD E8 ?? ?? ?? ?? 8C 10 9F E5 ?? ?? ?? ?? 00 10 A0 E1 49 08 A0 E3 FD 0E 80 E2 2D 01 80 E2 ?? ?? ?? ?? 00 20 A0 E1 EA FF FF EA 06 00 54 E1 07 00 00 0A 02 00 57 E3 EC FF FF 0A 03 00 57 E3 B4 FF FF 0A 01 00 57 E3 02 21 A0 03 00 20 A0 13 E0 FF FF EA 02 00 57 E3 5B 29 A0 03 BE 2E 82 02 11 21 82 02 DB FF FF 0A 03 00 57 E3 5B 29 A0 03 BE 2E 82 02 13 21 82 02 D6 FF FF 0A 01 00 57 E3 91 21 E0 03 93 21 E0 13 B6 28 42 02 B6 28 42 12 0F 2A 42 02 0F 2A 42 12 CE FF FF EA 2E BD BB 33 }
	condition:
		$1
}

rule file_176_0_1 {
	meta:
		name = "tgammaf"
		size = 224
		refs = "0010 __ieee754_gammaf_r 0038 finitef 0064 floorf 006c __eqsf2 0080 __lesf2 0090 __extendsfdf2 00a4 __kernel_standard 00a8 __truncdfsf2 00dc __fdlib_version"
	strings:
		$1 = { 30 40 2D E9 08 D0 4D E2 04 10 8D E2 00 40 A0 E1 ?? ?? ?? ?? 04 30 9D E5 00 00 53 E3 B8 30 9F E5 00 30 93 E5 00 50 A0 E1 02 51 80 B2 01 00 73 E3 03 00 00 0A 05 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 02 00 00 0A 05 00 A0 E1 08 D0 8D E2 30 80 BD E8 04 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 F8 FF FF 0A 04 00 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 04 00 00 1A 04 00 A0 E1 00 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 09 00 00 DA 04 00 A0 E1 ?? ?? ?? ?? 8C C0 A0 E3 00 20 A0 E1 01 30 A0 E1 00 C0 8D E5 ?? ?? ?? ?? ?? ?? ?? ?? 00 50 A0 E1 E3 FF FF EA 04 00 A0 E1 ?? ?? ?? ?? 8D C0 A0 E3 00 20 A0 E1 01 30 A0 E1 00 C0 8D E5 ?? ?? ?? ?? ?? ?? ?? ?? 00 50 A0 E1 D9 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_177_0_1 {
	meta:
		name = "nextafter"
		size = 464
		refs = "0070 __eqdf2 00f0 __muldf3 00fc __nedf2 011c __adddf3"
	strings:
		$1 = { F0 4F 2D E9 01 50 A0 E1 02 11 E0 E3 01 16 41 E2 02 71 C0 E3 01 00 57 E1 00 40 A0 E1 00 60 A0 E1 02 A0 A0 E1 03 B0 A0 E1 05 80 A0 E1 03 90 A0 E1 03 00 00 DA 02 11 87 E2 01 16 81 E2 05 10 91 E1 33 00 00 1A 02 11 E0 E3 01 16 41 E2 02 01 CA E3 01 00 50 E1 03 00 00 DA 02 01 80 E2 01 06 80 E2 09 00 90 E1 2A 00 00 1A 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 22 00 00 0A 08 70 97 E1 2B 00 00 0A 00 00 56 E3 43 00 00 BA 0A 00 56 E1 06 00 00 CA 00 30 A0 13 01 30 A0 03 09 00 58 E1 00 90 A0 93 01 90 03 82 00 00 59 E3 44 00 00 0A 00 00 58 E3 01 60 46 02 01 80 48 E2 02 31 C6 E3 23 3A A0 E1 7F 24 A0 E3 0F 26 82 E2 03 3A A0 E1 02 00 53 E1 28 00 00 0A 01 06 53 E3 07 00 00 AA 04 20 A0 E1 05 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 06 40 A0 E1 08 50 A0 E1 04 00 A0 E1 05 10 A0 E1 F0 8F BD E8 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 04 00 A0 E1 05 10 A0 E1 F0 8F BD E8 02 41 0A E2 01 50 A0 E3 04 20 A0 E1 05 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 01 70 A0 E1 00 60 A0 E1 ?? ?? ?? ?? 00 00 50 E3 06 40 A0 01 07 50 A0 01 04 00 A0 E1 05 10 A0 E1 F0 8F BD E8 04 00 A0 E1 05 10 A0 E1 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 DA FF FF EA 0A 00 56 E1 00 00 5A D3 C1 FF FF AA 0A 00 56 E1 00 A0 A0 13 01 A0 A0 03 09 00 58 E1 00 A0 A0 93 00 00 5A E3 BA FF FF 1A 01 80 98 E2 01 60 86 02 BA FF FF EA }
	condition:
		$1
}

rule file_179_0_1 {
	meta:
		name = "__ieee754_logf"
		size = 984
		refs = "0068 __subsf3 0088 __addsf3 0094 __divsf3 00a0 __floatsisf 00b0 __mulsf3 01bc __eqsf2"
	strings:
		$1 = { 02 31 C0 E3 00 00 53 E3 F0 47 2D E9 00 10 A0 E1 00 20 A0 E1 63 00 00 0A 00 00 50 E3 80 00 00 BA 02 31 E0 E3 02 35 43 E2 03 00 50 E1 75 00 00 CA 02 05 50 E3 7E 70 E0 A3 74 00 00 BA FF 44 C2 E3 02 45 C4 E3 4A 38 84 E2 FB 3C 83 E2 20 30 83 E2 02 35 03 E2 FE 05 23 E2 C2 7B 87 E0 04 00 80 E1 FE 15 A0 E3 A3 7B 87 E0 ?? ?? ?? ?? 0F 30 84 E2 FF 34 C3 E3 02 35 C3 E3 0F 00 53 E3 00 50 A0 E1 4C 00 00 DA 01 11 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 80 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 08 10 A0 E1 00 90 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 00 A0 A0 E1 ?? ?? ?? ?? E8 12 9F E5 00 60 A0 E1 ?? ?? ?? ?? E0 12 9F E5 ?? ?? ?? ?? 06 10 A0 E1 ?? ?? ?? ?? D4 12 9F E5 ?? ?? ?? ?? 06 10 A0 E1 ?? ?? ?? ?? C8 12 9F E5 ?? ?? ?? ?? 0A 10 A0 E1 ?? ?? ?? ?? BC 12 9F E5 00 A0 A0 E1 06 00 A0 E1 ?? ?? ?? ?? B0 12 9F E5 ?? ?? ?? ?? 06 10 A0 E1 ?? ?? ?? ?? A4 12 9F E5 ?? ?? ?? ?? 06 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? C2 69 44 E2 8F 6D 46 E2 D7 49 64 E2 10 60 46 E2 A2 4F 84 E2 06 40 84 E1 00 00 54 E3 00 A0 A0 E1 71 00 00 DA 3F 14 A0 E3 05 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 00 00 57 E3 00 40 A0 E1 40 00 00 1A 0A 10 A0 E1 ?? ?? ?? ?? 08 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? F0 87 BD E8 00 10 A0 E3 33 03 A0 E3 ?? ?? ?? ?? F0 87 BD E8 00 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 1A 00 00 1A 00 00 57 E3 00 00 A0 03 F0 87 BD 08 07 00 A0 E1 ?? ?? ?? ?? 3F 14 A0 E3 C5 19 81 E2 C6 1D 81 E2 00 50 A0 E1 ?? ?? ?? ?? D4 11 9F E5 00 40 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? F0 87 BD E8 13 13 A0 E3 ?? ?? ?? ?? 97 70 E0 E3 00 20 A0 E1 85 FF FF EA ?? ?? ?? ?? 00 10 A0 E3 ?? ?? ?? ?? F0 87 BD E8 05 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 88 11 9F E5 00 40 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 3F 14 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 00 57 E3 00 40 A0 E1 1E 00 00 1A 05 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? F0 87 BD E8 3F 14 A0 E3 C5 19 81 E2 C6 1D 81 E2 09 00 A0 E1 ?? ?? ?? ?? 0A 10 A0 E1 00 60 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 08 10 A0 E1 ?? ?? ?? ?? 18 11 9F E5 00 70 A0 E1 09 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? F0 87 BD E8 07 00 A0 E1 ?? ?? ?? ?? 3F 14 A0 E3 C5 19 81 E2 C6 1D 81 E2 00 70 A0 E1 ?? ?? ?? ?? C4 10 9F E5 00 60 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? EB FF FF EA 00 00 57 E3 17 00 00 0A 3F 14 A0 E3 C5 19 81 E2 09 00 A0 E1 C6 1D 81 E2 ?? ?? ?? ?? 0A 10 A0 E1 00 40 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 08 10 A0 E1 ?? ?? ?? ?? 74 10 9F E5 00 60 A0 E1 09 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? F0 87 BD E8 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 08 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? F0 87 BD E8 97 88 17 3E 25 33 3A 3E 25 49 92 3E AB AA 2A 3F 4F D0 1C 3E 29 8E 63 3E CD CC CC 3E D1 F7 17 37 AB AA AA BE D1 F7 17 B7 }
	condition:
		$1
}

rule file_180_0_1 {
	meta:
		name = "remquof"
		size = 72
		refs = "0020 __divsf3 0024 fabsf 0028 lrintf 0044 remainderf"
	strings:
		$1 = { A1 3F A0 E1 F0 40 2D E9 A0 0F 53 E1 01 40 A0 E1 02 60 A0 E1 00 70 E0 13 01 70 A0 03 00 50 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 7F 00 00 E2 90 07 07 E0 04 10 A0 E1 05 00 A0 E1 00 70 86 E5 F0 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_183_0_1 {
	meta:
		name = "sinf"
		size = 196
		refs = "0034 __subsf3 0044 __ieee754_rem_pio2f 0070 __kernel_sinf 00a8 __kernel_cosf"
	strings:
		$1 = { 04 E0 2D E5 9F 31 E0 E3 B6 38 43 E2 02 21 C0 E3 0F 3A 43 E2 03 00 52 E1 08 D0 4D E2 00 10 A0 E1 14 00 00 DA 02 31 E0 E3 02 35 43 E2 03 00 52 E1 02 00 00 DA ?? ?? ?? ?? 08 D0 8D E2 00 80 BD E8 0D 10 A0 E1 ?? ?? ?? ?? 03 00 00 E2 01 00 50 E3 12 00 00 0A 02 00 50 E3 0A 00 00 0A 00 00 50 E3 12 00 00 1A 00 00 9D E5 04 10 9D E5 01 20 A0 E3 ?? ?? ?? ?? EF FF FF EA 00 10 A0 E3 00 20 A0 E3 ?? ?? ?? ?? EB FF FF EA 00 00 9D E5 04 10 9D E5 01 20 A0 E3 ?? ?? ?? ?? 02 01 80 E2 E5 FF FF EA 00 00 9D E5 04 10 9D E5 ?? ?? ?? ?? E1 FF FF EA 00 00 9D E5 04 10 9D E5 ?? ?? ?? ?? 02 01 80 E2 DC FF FF EA }
	condition:
		$1
}

rule file_184_0_1 {
	meta:
		name = "__kernel_standard"
		size = 7036
		refs = "02b8 matherr 02d0 __errno 0644 copysign 06a0 __gtdf2 086c __divdf3 11b8 __fdlib_version 1330 __ltdf2 16f8 __muldf3 1704 rint 1710 __nedf2"
	strings:
		$1 = { 70 48 2D E9 24 D0 4D E2 38 C0 9D E5 02 40 A0 E1 03 50 A0 E1 00 20 A0 E3 01 30 4C E2 20 20 8D E5 08 00 8D E5 0C 10 8D E5 10 40 8D E5 14 50 8D E5 8D 00 53 E3 03 F1 9F 97 A7 00 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 3C 3F 9F E5 3C 2F 9F E5 00 30 93 E5 38 1F 9F E5 63 00 5C E3 02 C0 A0 C1 01 C0 A0 D1 02 20 A0 E3 00 00 53 E3 04 10 8D E8 AE 04 00 1A 2E 33 E0 E3 01 36 43 E2 0E 42 A0 E3 18 30 8D E5 1C 40 8D E5 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 20 30 9D 15 14 06 00 0A 00 00 53 E3 02 00 00 0A ?? ?? ?? ?? 20 30 9D E5 00 30 80 E5 18 10 8D E2 03 00 91 E8 24 D0 8D E2 70 88 BD E8 C4 3E 9F E5 64 2F 9F E5 00 30 93 E5 60 4F 9F E5 63 00 5C E3 04 C0 A0 D1 02 C0 A0 C1 01 00 73 E3 02 00 53 13 01 30 A0 E3 08 10 8D E8 18 00 8D E5 1C 10 8D E5 99 05 00 1A FF 35 A0 E3 03 36 83 E2 00 40 A0 E3 18 30 8D E5 1C 40 8D E5 E7 FF FF EA 74 3E 9F E5 74 2E 9F E5 00 30 93 E5 70 1E 9F E5 63 00 5C E3 02 C0 A0 C1 01 C0 A0 D1 03 20 A0 E3 00 00 53 E3 04 10 8D E8 88 04 00 1A 2E 33 E0 E3 01 36 43 E2 0E 42 A0 E3 18 30 8D E5 1C 40 8D E5 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 20 30 9D 15 CD FF FF 1A ?? ?? ?? ?? 22 30 A0 E3 00 30 80 E5 20 30 9D E5 C8 FF FF EA 0C 3E 9F E5 A4 2E 9F E5 00 30 93 E5 A0 1E 9F E5 63 00 5C E3 01 C0 A0 D1 02 C0 A0 C1 02 00 53 E3 05 30 A0 E3 00 30 8D E5 00 40 A0 E3 00 30 A0 E3 04 C0 8D E5 18 30 8D E5 1C 40 8D E5 B9 05 00 0A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 20 30 9D 15 B3 FF FF 1A ?? ?? ?? ?? 22 30 A0 E3 00 30 80 E5 20 30 9D E5 AE FF FF EA A4 3D 9F E5 AC 2D 9F E5 00 30 93 E5 A8 1D 9F E5 63 00 5C E3 01 C0 A0 D1 02 C0 A0 C1 02 00 53 E3 05 30 A0 E3 00 30 8D E5 00 40 A0 E3 00 30 A0 E3 04 C0 8D E5 18 30 8D E5 1C 40 8D E5 95 05 00 0A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 20 30 9D 15 99 FF FF 1A ?? ?? ?? ?? 22 30 A0 E3 00 30 80 E5 20 30 9D E5 94 FF FF EA 3C 3D 9F E5 4C 2D 9F E5 00 30 93 E5 48 1D 9F E5 63 00 5C E3 01 C0 A0 D1 02 C0 A0 C1 02 00 53 E3 05 30 A0 E3 00 30 8D E5 00 40 A0 E3 00 30 A0 E3 04 C0 8D E5 18 30 8D E5 1C 40 8D E5 8F 05 00 0A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 20 30 9D 15 7F FF FF 1A ?? ?? ?? ?? 22 30 A0 E3 00 30 80 E5 20 30 9D E5 7A FF FF EA D4 3C 9F E5 EC 2C 9F E5 00 30 93 E5 E8 1C 9F E5 63 00 5C E3 01 C0 A0 D1 02 C0 A0 C1 02 00 53 E3 05 30 A0 E3 00 30 8D E5 00 40 A0 E3 00 30 A0 E3 04 C0 8D E5 18 30 8D E5 1C 40 8D E5 66 05 00 0A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 20 30 9D 15 65 FF FF 1A ?? ?? ?? ?? 22 30 A0 E3 00 30 80 E5 20 30 9D E5 60 FF FF EA 6C 3C 9F E5 8C 2C 9F E5 00 30 93 E5 88 1C 9F E5 63 00 5C E3 01 C0 A0 D1 02 C0 A0 C1 02 00 53 E3 05 30 A0 E3 00 30 8D E5 00 40 A0 E3 00 30 A0 E3 04 C0 8D E5 18 30 8D E5 1C 40 8D E5 56 05 00 0A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 20 30 9D 15 4B FF FF 1A ?? ?? ?? ?? 22 30 A0 E3 00 30 80 E5 20 30 9D E5 46 FF FF EA 04 3C 9F E5 AC 2C 9F E5 00 30 93 E5 A8 1C 9F E5 63 00 5C E3 01 C0 A0 D1 02 C0 A0 C1 02 00 53 E3 05 30 A0 E3 00 30 8D E5 00 40 A0 E3 00 30 A0 E3 04 C0 8D E5 18 30 8D E5 1C 40 8D E5 46 05 00 0A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 20 30 9D 15 31 FF FF 1A ?? ?? ?? ?? 22 30 A0 E3 00 30 80 E5 20 30 9D E5 2C FF FF EA C8 3B 9F E5 C8 2B 9F E5 63 00 5C E3 02 C0 A0 D1 03 C0 A0 C1 00 20 A0 E1 01 30 A0 E1 04 E0 A0 E3 00 00 A0 E3 00 10 A0 E3 00 E0 8D E5 04 C0 8D E5 ?? ?? ?? ?? 68 3B 9F E5 00 30 93 E5 02 00 53 E3 18 00 8D E5 1C 10 8D E5 D9 04 00 0A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 20 30 9D 15 14 FF FF 1A ?? ?? ?? ?? 22 30 A0 E3 00 30 80 E5 20 30 9D E5 0F FF FF EA 54 EB 9F E5 00 20 A0 E3 63 00 5C E3 00 30 A0 E3 48 4B 9F E5 0E 40 A0 C1 ?? ?? ?? ?? 0C 3B 9F E5 00 00 50 E3 00 30 93 E5 02 11 A0 D3 7F 14 A0 C3 C1 15 A0 D1 00 20 A0 D3 0F 16 81 C2 00 20 A0 C3 02 00 53 E3 03 30 A0 E3 18 00 8D E8 18 10 8D E5 1C 20 8D E5 D7 04 00 0A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 20 30 9D 15 F4 FE FF 1A ?? ?? ?? ?? 22 30 A0 E3 00 30 80 E5 20 30 9D E5 EF FE FF EA A8 3A 9F E5 64 2B 9F E5 00 30 93 E5 60 1B 9F E5 63 00 5C E3 02 C0 A0 C1 01 C0 A0 D1 02 20 A0 E3 00 00 53 E3 04 10 8D E8 2E 04 00 1A 0E 33 E0 E3 01 36 43 E2 0E 42 A0 E3 18 30 8D E5 1C 40 8D E5 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 20 30 9D 15 DA FE FF 1A ?? ?? ?? ?? 21 30 A0 E3 00 30 80 E5 20 30 9D E5 D5 FE FF EA 40 3A 9F E5 E4 2A 9F E5 00 40 93 E5 D8 3A 9F E5 63 00 5C E3 03 C0 A0 C1 02 C0 A0 D1 01 30 A0 E3 00 00 54 E3 08 10 8D E8 93 03 00 1A 00 30 A0 E3 00 40 A0 E3 18 30 8D E5 1C 40 8D E5 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 20 30 9D 15 C1 FE FF 1A ?? ?? ?? ?? 21 30 A0 E3 00 30 80 E5 20 30 9D E5 BC FE FF EA DC 39 9F E5 84 2A 9F E5 00 30 93 E5 80 1A 9F E5 63 00 5C E3 02 C0 A0 C1 01 C0 A0 D1 01 20 A0 E3 00 00 53 E3 04 10 8D E8 D7 03 00 1A 0E 33 E0 E3 01 36 43 E2 0E 42 A0 E3 18 30 8D E5 1C 40 8D E5 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 20 30 9D 15 A7 FE FF 1A ?? ?? ?? ?? 21 30 A0 E3 00 30 80 E5 20 30 9D E5 A2 FE FF EA A8 39 9F E5 A8 29 9F E5 63 00 5C E3 00 00 A0 E3 00 10 A0 E3 02 C0 A0 D1 03 C0 A0 C1 01 E0 A0 E3 01 30 A0 E1 00 20 A0 E1 00 E0 8D E5 04 C0 8D E5 ?? ?? ?? ?? 40 39 9F E5 00 30 93 E5 02 00 53 E3 18 00 8D E5 1C 10 8D E5 81 04 00 0A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 20 30 9D 15 8A FE FF 1A ?? ?? ?? ?? 21 30 A0 E3 00 30 80 E5 20 30 9D E5 85 FE FF EA 00 39 9F E5 98 29 9F E5 00 30 93 E5 94 19 9F E5 63 00 5C E3 02 C0 A0 C1 01 C0 A0 D1 01 20 A0 E3 00 00 53 E3 04 10 8D E8 F4 03 00 1A 0E 33 E0 E3 01 36 43 E2 0E 42 A0 E3 18 30 8D E5 1C 40 8D E5 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 20 30 9D 15 70 FE FF 1A ?? ?? ?? ?? 21 30 A0 E3 00 30 80 E5 20 30 9D E5 6B FE FF EA 98 38 9F E5 38 29 9F E5 00 30 93 E5 34 19 9F E5 63 00 5C E3 01 C0 A0 D1 02 C0 A0 C1 00 00 53 E3 01 30 A0 E3 00 30 8D E5 00 40 A0 E3 00 30 A0 E3 04 C0 8D E5 18 30 8D E5 1C 40 8D E5 72 FE FF 1A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 20 30 9D 15 56 FE FF 1A ?? ?? ?? ?? 21 30 A0 E3 00 30 80 E5 20 30 9D E5 51 FE FF EA 30 38 9F E5 68 28 9F E5 00 30 93 E5 64 18 9F E5 63 00 5C E3 02 C0 A0 C1 01 C0 A0 D1 03 20 A0 E3 00 00 53 E3 04 10 8D E8 C5 02 00 1A 2E 33 E0 E3 01 36 43 E2 0E 42 A0 E3 18 30 8D E5 1C 40 8D E5 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 20 30 9D 15 3C FE FF 1A ?? ?? ?? ?? 22 30 A0 E3 00 30 80 E5 20 30 9D E5 37 FE FF EA C8 37 9F E5 08 28 9F E5 00 30 93 E5 04 E8 9F E5 63 00 5C E3 0E C0 A0 D1 02 C0 A0 C1 02 00 53 E3 01 30 A0 E3 08 40 8D E5 0C 50 8D E5 00 30 8D E5 00 40 A0 E3 00 30 A0 E3 10 00 8D E5 14 10 8D E5 04 C0 8D E5 18 30 8D E5 1C 40 8D E5 F2 03 00 0A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 20 30 9D 15 1E FE FF 1A ?? ?? ?? ?? 21 30 A0 E3 00 30 80 E5 20 30 9D E5 19 FE FF EA 50 37 9F E5 98 27 9F E5 00 30 93 E5 94 17 9F E5 63 00 5C E3 01 C0 A0 D1 02 C0 A0 C1 02 00 53 E3 01 30 A0 E3 00 30 8D E5 00 40 A0 E3 00 30 A0 E3 04 C0 8D E5 18 30 8D E5 1C 40 8D E5 C4 03 00 0A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 20 30 9D 15 04 FE FF 1A ?? ?? ?? ?? 21 30 A0 E3 00 30 80 E5 20 30 9D E5 FF FD FF EA 3C 37 9F E5 3C 27 9F E5 63 00 5C E3 00 00 A0 E3 00 10 A0 E3 02 C0 A0 D1 03 C0 A0 C1 01 E0 A0 E3 01 30 A0 E1 00 20 A0 E1 00 E0 8D E5 04 C0 8D E5 ?? ?? ?? ?? B4 36 9F E5 00 30 93 E5 02 00 53 E3 18 00 8D E5 1C 10 8D E5 D4 03 00 0A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 20 30 9D 15 E7 FD FF 1A ?? ?? ?? ?? 21 30 A0 E3 00 30 80 E5 20 30 9D E5 E2 FD FF EA 74 36 9F E5 CC 26 9F E5 00 30 93 E5 C8 16 9F E5 63 00 5C E3 02 C0 A0 C1 01 C0 A0 D1 03 20 A0 E3 00 00 53 E3 04 10 8D E8 39 03 00 1A 2E 33 E0 E3 01 36 43 E2 0E 42 A0 E3 18 30 8D E5 1C 40 8D E5 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 20 30 9D 15 CD FD FF 1A ?? ?? ?? ?? 22 30 A0 E3 00 30 80 E5 20 30 9D E5 C8 FD FF EA 0C 36 9F E5 AC 26 9F E5 00 30 93 E5 A8 16 9F E5 63 00 5C E3 01 C0 A0 D1 02 C0 A0 C1 02 00 53 E3 04 30 A0 E3 00 30 8D E5 00 40 A0 E3 00 30 A0 E3 04 C0 8D E5 18 30 8D E5 1C 40 8D E5 8C 03 00 0A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 20 30 9D 15 B3 FD FF 1A ?? ?? ?? ?? 22 30 A0 E3 00 30 80 E5 20 30 9D E5 AE FD FF EA A4 35 9F E5 04 26 9F E5 00 30 93 E5 00 16 9F E5 63 00 5C E3 02 C0 A0 C1 01 C0 A0 D1 03 20 A0 E3 00 00 53 E3 04 10 8D E8 D5 02 00 1A 2E 33 E0 E3 01 36 43 E2 0E 42 A0 E3 18 30 8D E5 1C 40 8D E5 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 20 30 9D 15 99 FD FF 1A ?? ?? ?? ?? 22 30 A0 E3 00 30 80 E5 20 30 9D E5 94 FD FF EA 3C 35 9F E5 A4 25 9F E5 00 40 93 E5 A0 35 9F E5 63 00 5C E3 03 C0 A0 C1 02 C0 A0 D1 01 30 A0 E3 00 00 54 E3 08 10 8D E8 78 02 00 1A 00 30 A0 E3 00 40 A0 E3 18 30 8D E5 1C 40 8D E5 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 20 30 9D 15 80 FD FF 1A ?? ?? ?? ?? 21 30 A0 E3 00 30 80 E5 20 30 9D E5 7B FD FF EA D8 34 9F E5 F8 24 9F E5 00 30 93 E5 F4 14 9F E5 63 00 5C E3 02 C0 A0 C1 01 C0 A0 D1 01 20 A0 E3 00 00 53 E3 04 10 8D E8 02 03 00 1A 0E 33 E0 E3 01 36 43 E2 0E 42 A0 E3 18 30 8D E5 1C 40 8D E5 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 20 30 9D 15 66 FD FF 1A ?? ?? ?? ?? 21 30 A0 E3 00 30 80 E5 20 30 9D E5 61 FD FF EA 70 34 9F E5 E0 24 9F E5 00 30 93 E5 DC 14 9F E5 63 00 5C E3 02 C0 A0 C1 01 C0 A0 D1 02 20 A0 E3 00 00 53 E3 04 10 8D E8 13 02 00 1A 0E 33 E0 E3 01 36 43 E2 0E 42 A0 E3 18 30 8D E5 1C 40 8D E5 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 20 30 9D 15 4C FD FF 1A ?? ?? ?? ?? 21 30 A0 E3 00 30 80 E5 20 30 9D E5 47 FD FF EA 08 34 9F E5 80 24 9F E5 00 30 93 E5 7C 14 9F E5 63 00 5C E3 01 C0 A0 D1 02 C0 A0 C1 02 00 53 E3 01 30 A0 E3 00 30 8D E5 00 40 A0 E3 00 30 A0 E3 04 C0 8D E5 18 30 8D E5 1C 40 8D E5 FC 02 00 0A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 20 30 9D 15 32 FD FF 1A ?? ?? ?? ?? 21 30 A0 E3 00 30 80 E5 20 30 9D E5 2D FD FF EA F4 33 9F E5 F4 23 9F E5 63 00 5C E3 02 C0 A0 D1 03 C0 A0 C1 02 E0 A0 E3 00 30 A0 E3 00 20 A0 E3 00 E0 8D E5 04 C0 8D E5 ?? ?? ?? ?? 74 33 9F E5 00 30 93 E5 02 00 53 E3 18 00 8D E5 1C 10 8D E5 FF 02 00 0A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 20 30 9D 15 17 FD FF 1A ?? ?? ?? ?? 21 30 A0 E3 00 30 80 E5 20 30 9D E5 12 FD FF EA 34 33 9F E5 8C 23 9F E5 00 30 93 E5 88 13 9F E5 63 00 5C E3 02 C0 A0 C1 01 C0 A0 D1 02 20 A0 E3 00 00 53 E3 04 10 8D E8 5D 02 00 1A 2E 33 E0 E3 01 36 43 E2 0E 42 A0 E3 18 30 8D E5 1C 40 8D E5 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 20 30 9D 15 FD FC FF 1A ?? ?? ?? ?? 21 30 A0 E3 00 30 80 E5 20 30 9D E5 F8 FC FF EA CC 32 9F E5 6C 23 9F E5 00 30 93 E5 68 13 9F E5 63 00 5C E3 02 C0 A0 C1 01 C0 A0 D1 01 20 A0 E3 00 00 53 E3 04 10 8D E8 C4 01 00 1A 00 30 A0 E3 00 40 A0 E3 18 30 8D E5 1C 40 8D E5 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 20 30 9D 15 E4 FC FF 1A ?? ?? ?? ?? 21 30 A0 E3 00 30 80 E5 20 30 9D E5 DF FC FF EA 68 32 9F E5 C8 22 9F E5 00 30 93 E5 C4 12 9F E5 63 00 5C E3 01 C0 A0 D1 02 C0 A0 C1 02 00 53 E3 04 30 A0 E3 00 30 8D E5 00 40 A0 E3 00 30 A0 E3 04 C0 8D E5 18 30 8D E5 1C 40 8D E5 99 02 00 0A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 20 30 9D 15 CA FC FF 1A ?? ?? ?? ?? 22 30 A0 E3 00 30 80 E5 20 30 9D E5 C5 FC FF EA 00 32 9F E5 80 22 9F E5 00 40 93 E5 7C 32 9F E5 63 00 5C E3 03 C0 A0 C1 02 C0 A0 D1 01 30 A0 E3 00 00 54 E3 08 10 8D E8 51 01 00 1A 18 00 8D E5 1C 10 8D E5 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 20 30 9D 15 B3 FC FF 1A ?? ?? ?? ?? 21 30 A0 E3 }
	condition:
		$1
}

rule file_186_0_1 {
	meta:
		name = "__ieee754_coshf"
		size = 336
		refs = "0058 __mulsf3 0068 fabsf 006c expm1f 0078 __addsf3 00ac __divsf3 00c4 __ieee754_expf"
	strings:
		$1 = { 02 31 E0 E3 70 40 2D E9 03 40 00 E0 02 35 43 E2 03 00 54 E1 00 10 A0 E1 0E 00 00 CA 1C 31 9F E5 03 00 54 E1 0F 00 00 DA BE 34 E0 E3 05 36 43 E2 03 00 54 E1 21 00 00 DA 04 31 9F E5 03 00 54 E1 2C 00 00 DA FC 30 9F E5 03 00 54 E1 2F 00 00 DA F4 00 9F E5 00 10 A0 E1 ?? ?? ?? ?? 00 50 A0 E1 05 00 A0 E1 70 80 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? FE 15 A0 E3 00 60 A0 E1 ?? ?? ?? ?? 77 03 74 E3 00 50 A0 E1 F5 FF FF DA 06 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 00 40 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 00 50 A0 E1 E7 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? 3F 14 A0 E3 00 50 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 00 40 A0 E1 3F 04 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 50 A0 E1 D9 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? 3F 14 A0 E3 ?? ?? ?? ?? 00 50 A0 E1 D3 FF FF EA ?? ?? ?? ?? 3F 14 A0 E3 ?? ?? ?? ?? ?? ?? ?? ?? 3F 14 A0 E3 00 40 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 50 A0 E1 C7 FF FF EA 17 72 B1 3E 17 72 B1 42 FC D4 B2 42 CA F2 49 71 }
	condition:
		$1
}

rule file_187_0_1 {
	meta:
		name = "lrintf"
		size = 192
		refs = "006c __addsf3 007c __subsf3 0094 __fixsfsi"
	strings:
		$1 = { 02 31 C0 E3 30 40 2D E9 A3 3B A0 E1 83 3B A0 E1 A3 3B A0 E1 7F 20 43 E2 1E 00 52 E3 04 D0 4D E2 00 10 A0 E1 1A 00 00 CA 01 00 72 E3 16 00 00 BA 16 00 52 E3 A0 4F A0 E1 08 00 00 DA FF C4 C0 E3 02 C5 CC E3 02 C5 8C E3 96 30 43 E2 1C 03 A0 E1 00 00 54 E3 00 00 60 12 04 D0 8D E2 30 80 BD E8 54 30 9F E5 04 51 93 E7 05 00 A0 E1 ?? ?? ?? ?? 00 00 8D E5 00 00 9D E5 05 10 A0 E1 ?? ?? ?? ?? 02 31 C0 E3 00 00 53 E3 03 00 00 1A 00 00 A0 E3 F0 FF FF EA ?? ?? ?? ?? EE FF FF EA A0 3B A0 E1 FF 04 C0 E3 02 05 C0 E3 FF 30 03 E2 02 05 80 E3 96 30 63 E2 30 03 A0 E1 E4 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_188_0_1 {
	meta:
		name = "logb"
		size = 140
		refs = "0040 __floatsidf 0050 __muldf3 0058 fabs 0070 __divdf3"
	strings:
		$1 = { 02 31 C0 E3 01 20 A0 E1 02 20 93 E1 30 48 2D E9 00 40 A0 E1 01 50 A0 E1 00 B0 A0 E1 0D 00 00 0A 02 C1 E0 E3 01 C6 4C E2 0C 00 53 E1 05 00 00 CA 43 3A B0 E1 0F 00 00 0A FF 0F 43 E2 03 00 40 E2 ?? ?? ?? ?? 30 88 BD E8 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 30 88 BD E8 ?? ?? ?? ?? 00 20 A0 E1 BF 04 A0 E3 01 30 A0 E1 0F 06 80 E2 00 10 A0 E3 ?? ?? ?? ?? 30 88 BD E8 03 01 A0 E3 8F 08 80 E2 0F 0A 80 E2 00 10 A0 E3 30 88 BD E8 }
	condition:
		$1
}

rule file_189_0_1 {
	meta:
		name = "__ieee754_sqrt"
		size = 584
		refs = "01f8 __muldf3 020c __adddf3 022c __subdf3 0238 __divdf3"
	strings:
		$1 = { 02 21 C0 E3 22 2A A0 E1 7F C4 A0 E3 02 2A A0 E1 0F C6 8C E2 0C 00 52 E1 F0 45 2D E9 00 30 A0 E1 00 40 A0 E1 01 50 A0 E1 00 60 A0 E1 01 70 A0 E1 01 20 A0 E1 6D 00 00 0A 00 00 50 E3 53 00 00 DA 40 6A B0 E1 5B 00 00 0A FF 5F 46 E2 03 50 45 E2 FF 34 C3 E3 01 00 15 E3 0F 36 C3 E3 A2 1F A0 11 01 36 83 E3 82 20 A0 11 83 30 81 10 00 C0 A0 E3 A2 1F A0 E1 83 30 81 E0 82 20 A0 E1 0C 70 A0 E1 0C 00 A0 E1 02 16 A0 E3 01 40 80 E0 03 00 54 E1 01 C0 8C E2 A2 6F A0 E1 03 30 64 D0 01 70 87 D0 01 00 84 D0 16 00 5C E3 83 30 86 E0 82 20 A0 E1 A1 10 A0 E1 F3 FF FF 1A 00 40 A0 E3 04 A0 A0 E1 04 60 A0 E1 02 11 A0 E3 03 00 50 E1 06 C0 81 E0 03 00 00 BA 02 00 5C E1 00 00 53 91 00 80 A0 11 08 00 00 1A 00 00 5C E3 01 60 8C E0 0E 00 00 BA 00 80 A0 E1 02 00 5C E1 03 30 60 E0 01 30 43 82 02 20 6C E0 01 A0 8A E0 01 40 84 E2 A2 0F A0 E1 20 00 54 E3 83 30 80 E0 82 20 A0 E1 A1 10 A0 E1 05 00 00 0A 08 00 A0 E1 E6 FF FF EA 00 00 56 E3 01 80 80 A2 EE FF FF AA EC FF FF EA 02 30 93 E1 0B 00 00 1A AA A0 A0 E1 C5 30 A0 E1 03 3A A0 E1 01 00 17 E3 FF 35 83 E2 02 A1 8A 13 02 36 83 E2 C7 40 83 E0 0A 50 A0 E1 04 00 A0 E1 05 10 A0 E1 F0 85 BD E8 01 00 7A E3 01 70 87 02 00 A0 A0 03 F0 FF FF 0A 01 30 0A E2 0A A0 83 E0 EC FF FF EA 02 C1 C0 E3 01 C0 9C E1 F2 FF FF 0A 00 00 50 E3 1F 00 00 1A A2 35 A0 E1 00 00 53 E3 15 60 46 E2 82 2A A0 E1 FA FF FF 0A 01 16 13 E2 20 00 A0 13 00 10 A0 13 04 00 00 1A 83 30 A0 E1 01 06 13 E3 01 10 81 E2 FB FF FF 0A 20 00 61 E2 01 60 86 E2 32 30 83 E1 06 60 61 E0 12 21 A0 E1 95 FF FF EA 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 04 00 A0 E1 05 10 A0 E1 F0 85 BD E8 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 C7 FF FF EA }
	condition:
		$1
}

rule file_191_0_1 {
	meta:
		name = "gamma"
		size = 404
		refs = "001c __ieee754_gamma_r 0038 finite 00ac floor 00b8 __eqdf2 00d4 __ledf2 00f8 matherr 0134 __errno 0188 _impure_ptr 018c __fdlib_version"
	strings:
		$1 = { F0 45 2D E9 7C 31 9F E5 00 20 93 E5 24 D0 4D E2 A0 20 82 E2 00 50 A0 E1 01 60 A0 E1 ?? ?? ?? ?? 64 41 9F E5 00 30 94 E5 01 00 73 E3 00 70 A0 E1 01 80 A0 E1 02 00 00 0A ?? ?? ?? ?? 00 A0 50 E2 03 00 00 0A 07 00 A0 E1 08 10 A0 E1 24 D0 8D E2 F0 85 BD E8 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 F6 FF FF 0A 00 30 94 E5 00 00 53 E3 18 31 9F E5 20 A0 8D E5 04 30 8D E5 10 50 8D E5 14 60 8D E5 08 50 8D E5 0C 60 8D E5 22 00 00 1A 2E 23 E0 E3 01 26 42 E2 0E 32 A0 E3 18 20 8D E5 1C 30 8D E5 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 06 00 00 1A 05 00 A0 E1 06 10 A0 E1 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 18 00 00 DA 00 30 94 E5 02 00 53 E3 03 30 A0 E3 00 30 8D E5 0F 00 00 0A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 0B 00 00 0A 20 30 9D E5 00 00 53 E3 19 00 00 1A 18 80 8D E2 80 01 98 E8 C9 FF FF EA 7F 24 A0 E3 0F 26 82 E2 00 30 A0 E3 18 20 8D E5 1C 30 8D E5 DB FF FF EA ?? ?? ?? ?? 22 30 A0 E3 00 30 80 E5 EF FF FF EA 00 30 94 E5 02 00 53 E3 02 30 A0 E3 00 30 8D E5 03 00 00 0A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 E6 FF FF 1A ?? ?? ?? ?? 21 30 A0 E3 00 30 80 E5 E2 FF FF EA ?? ?? ?? ?? 20 30 9D E5 00 30 80 E5 E1 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_192_0_1 {
	meta:
		name = "fmaxf"
		size = 80
		refs = "000c __fpclassifyf 0038 __gtsf2"
	strings:
		$1 = { 30 40 2D E9 01 40 A0 E1 00 50 A0 E1 ?? ?? ?? ?? 00 00 50 E3 01 00 00 1A 04 00 A0 E1 30 80 BD E8 04 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 04 00 00 0A 05 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 F4 FF FF DA 05 40 A0 E1 04 00 A0 E1 30 80 BD E8 }
	condition:
		$1
}

rule file_193_0_1 {
	meta:
		name = "log1p"
		size = 1748
		refs = "004c __eqdf2 006c __divdf3 00b0 __adddf3 00dc __subdf3 0158 __muldf3 01bc __floatsidf 0474 __gtdf2"
	strings:
		$1 = { F0 4D 2D E9 95 39 E0 E3 F6 3D 43 E2 1B 31 43 E2 03 00 50 E1 20 D0 4D E2 00 70 A0 E1 01 80 A0 E1 00 40 A0 E1 01 50 A0 E1 13 00 00 CA 03 31 E0 E3 01 36 43 E2 02 41 C0 E3 03 00 54 E1 71 00 00 DA BF 24 A0 E3 0F 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 F5 00 00 1A C3 04 A0 E3 05 06 80 E2 00 10 A0 E3 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 70 A0 E1 01 80 A0 E1 E8 00 00 EA 02 31 E0 E3 01 36 43 E2 03 00 50 E1 DF 00 00 CA 2F 33 E0 E3 03 35 43 E2 03 00 50 E1 19 01 00 CA FF 25 A0 E3 07 00 A0 E1 08 10 A0 E1 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 40 4A A0 E1 FF 4F 44 E2 03 40 44 E2 00 00 54 E3 00 A0 A0 E1 01 B0 A0 E1 00 50 A0 E1 75 01 00 DA 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 FF 05 A0 E3 01 30 A0 E1 03 06 80 E2 00 10 A0 E3 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? 08 00 8D E5 0C 10 8D E5 FF 74 C5 E3 6A 3A A0 E3 0F 76 C7 E3 9D 30 83 E2 03 00 57 E1 EF 00 00 CA FF A5 87 E3 03 A6 8A E3 0A 00 A0 E1 0B 10 A0 E1 FF 25 A0 E3 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? FF 25 A0 E3 02 26 82 E2 00 30 A0 E3 00 50 A0 E1 01 60 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 00 00 57 E3 00 A0 A0 E1 01 B0 A0 E1 05 70 A0 E1 06 80 A0 E1 00 0C 8D E8 35 00 00 1A 05 00 A0 E1 06 10 A0 E1 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 F4 00 00 1A 00 00 54 E3 00 70 A0 03 00 80 A0 03 99 00 00 0A 04 00 A0 E1 ?? ?? ?? ?? E9 3F 8F E2 0C 00 93 E8 00 40 A0 E1 01 50 A0 E1 ?? ?? ?? ?? E6 3F 8F E2 0C 00 93 E8 00 70 A0 E1 01 80 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 08 10 8D E2 03 00 91 E8 ?? ?? ?? ?? AE 00 00 EA C1 34 E0 E3 0E 36 43 E2 03 00 54 E1 90 00 00 DA 01 21 80 E2 01 31 A0 E3 B5 39 83 E2 B5 29 82 E2 4F 3F 83 E2 4F 2F 82 E2 03 00 52 E1 98 FF FF 9A FF 25 A0 E3 02 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 03 00 8D E8 00 40 A0 E3 01 21 A0 E3 00 30 A0 E3 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 00 A0 A0 E1 01 B0 A0 E1 ?? ?? ?? ?? A1 3F 8F E2 0C 00 93 E8 00 50 A0 E1 01 60 A0 E1 ?? ?? ?? ?? 9E 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 9A 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 96 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 92 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 8E 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 8A 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 00 00 54 E3 00 50 A0 E1 01 60 A0 E1 A1 00 00 0A 04 00 A0 E1 ?? ?? ?? ?? 82 3F 8F E2 0C 00 93 E8 10 00 8D E5 14 10 8D E5 ?? ?? ?? ?? 05 20 A0 E1 18 00 8D E5 1C 10 8D E5 06 30 A0 E1 03 00 9D E8 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? 76 3F 8F E2 0C 00 93 E8 00 40 A0 E1 01 50 A0 E1 10 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 08 30 8D E2 0C 00 93 E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 03 00 9D E8 ?? ?? ?? ?? 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 18 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 70 A0 E1 01 80 A0 E1 04 00 00 EA 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 00 70 A0 E1 01 80 A0 E1 07 00 A0 E1 08 10 A0 E1 20 D0 8D E2 F0 8D BD E8 07 20 A0 E1 08 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 00 70 A0 E1 01 80 A0 E1 F0 FF FF EA 43 24 A0 E3 05 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? C3 34 E0 E3 00 00 50 E3 00 20 A0 E3 07 36 43 E2 01 20 A0 C3 03 00 54 E1 00 40 A0 C3 01 40 02 D2 00 00 54 E3 DF FF FF 1A 07 20 A0 E1 08 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? BF 24 A0 E3 0E 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 70 A0 E1 01 80 A0 E1 CE FF FF EA FF A5 87 E3 02 A6 8A E3 01 76 67 E2 01 40 84 E2 0A 00 A0 E1 0B 10 A0 E1 47 71 A0 E1 0B FF FF EA 40 4A A0 E1 FF 4F 44 E2 00 20 A0 E3 00 30 A0 E3 00 50 A0 E1 03 40 44 E2 01 B0 A0 E1 08 20 8D E5 0C 30 8D E5 F7 FE FF EA 12 F1 C2 3F 44 52 3E DF 09 9A C3 3F 9F C6 78 D0 64 46 C7 3F DE 03 CB 96 C5 71 CC 3F AF 78 8E 1D 24 49 D2 3F 59 93 22 94 99 99 D9 3F 04 FA 97 99 55 55 E5 3F 93 55 55 55 55 55 E5 BF 55 55 55 55 42 2E E6 3F 00 00 E0 FE EF 39 EA 3D 76 3C 79 35 20 30 4F E2 0C 00 93 E8 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? FF 25 A0 E3 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? 00 00 54 E3 00 70 A0 E1 01 80 A0 E1 1A 00 00 1A 07 20 A0 E1 08 30 A0 E1 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 00 70 A0 E1 01 80 A0 E1 90 FF FF EA 00 20 A0 E1 01 30 A0 E1 03 00 9D E8 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 03 00 9D E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 70 A0 E1 01 80 A0 E1 7D FF FF EA 04 00 A0 E1 ?? ?? ?? ?? CC 30 4F E2 0C 00 93 E8 00 A0 A0 E1 01 B0 A0 E1 ?? ?? ?? ?? D8 30 4F E2 0C 00 93 E8 03 00 8D E8 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 08 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 03 00 9D E8 ?? ?? ?? ?? 00 70 A0 E1 01 80 A0 E1 5C FF FF EA FF 25 A0 E3 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 88 FE FF EA }
	condition:
		$1
}

rule file_194_0_1 {
	meta:
		name = "__ieee754_asin"
		size = 1448
		refs = "0044 __subdf3 0050 __divdf3 008c __adddf3 009c __gtdf2 00b0 fabs 00d8 __muldf3 01e8 __ieee754_sqrt"
	strings:
		$1 = { F0 4F 2D E9 03 31 E0 E3 01 36 43 E2 02 41 C0 E3 03 00 54 E1 18 D0 4D E2 00 50 A0 E1 00 70 A0 E1 01 80 A0 E1 10 00 00 DA 03 41 84 E2 01 46 84 E2 01 30 A0 E1 03 30 94 E1 BC 00 00 0A 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 00 50 A0 E1 01 80 A0 E1 05 00 A0 E1 08 10 A0 E1 18 D0 8D E2 F0 8F BD E8 03 31 E0 E3 02 36 43 E2 03 00 54 E1 0A 00 00 CA F9 05 54 E3 F3 00 00 AA D6 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? FF 25 A0 E3 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 EC FF FF CA 05 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 FF 05 A0 E3 01 30 A0 E1 03 06 80 E2 00 10 A0 E3 ?? ?? ?? ?? FF 25 A0 E3 02 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 32 3E 8F E2 0C 00 93 E8 00 50 A0 E1 01 60 A0 E1 ?? ?? ?? ?? C5 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? C1 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? BD 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? B9 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? B5 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? B1 3F 8F E2 0C 00 93 E8 03 00 8D E8 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? AD 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? A9 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? A5 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? FF 25 A0 E3 00 30 A0 E3 03 26 82 E2 ?? ?? ?? ?? 08 00 8D E5 0C 10 8D E5 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 43 39 E0 E3 33 3D 43 E2 37 31 43 E2 03 00 54 E1 00 80 A0 E1 01 90 A0 E1 5B 00 00 CA 00 20 A0 E1 01 30 A0 E1 00 A0 A0 E1 ?? ?? ?? ?? 08 30 8D E2 0C 00 93 E8 10 00 8D E5 14 10 8D E5 03 00 9D E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 10 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 B0 A0 E3 03 00 8D E8 08 20 A0 E1 08 00 A0 E1 0B 30 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 08 20 A0 E1 00 40 A0 E1 01 50 A0 E1 08 00 A0 E1 0B 30 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 03 21 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 4D 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 03 00 9D E8 ?? ?? ?? ?? 03 21 A0 E3 00 40 A0 E1 01 50 A0 E1 08 00 A0 E1 00 30 A0 E3 0B 10 A0 E1 ?? ?? ?? ?? 41 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 DC 10 8F E2 03 00 91 E8 ?? ?? ?? ?? 01 80 A0 E1 00 00 57 E3 00 50 A0 C1 02 51 80 D2 4A FF FF EA C4 30 8F E2 0C 00 93 E8 ?? ?? ?? ?? A8 30 8F E2 0C 00 93 E8 00 60 A0 E1 01 70 A0 E1 05 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 00 50 A0 E1 01 80 A0 E1 38 FF FF EA 08 30 8D E2 0C 00 93 E8 03 00 9D E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 28 30 8F E2 0C 00 93 E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 24 10 8F E2 03 00 91 E8 ?? ?? ?? ?? 01 80 A0 E1 CE FF FF EA 3C E4 37 7E 9C 75 00 88 26 A6 91 3C 07 5C 14 33 FB 21 E9 3F 18 2D 44 54 FB 21 F9 3F 18 2D 44 54 E1 3D 02 3F 09 F7 FD 0D E0 EF 49 3F 88 B2 01 75 28 82 A4 3F 3B 8F 68 B5 55 C1 C9 3F 55 44 88 0E 12 D6 D4 3F 7D 6F EB 03 55 55 C5 3F 55 55 55 55 C5 B8 B3 3F 82 92 2E B1 6C 06 E6 3F 59 01 8D 1B E5 2A 00 40 C8 8A 59 9C 27 3A 03 40 4B 2D 8A 1C 05 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? 64 30 4F E2 0C 00 93 E8 00 A0 A0 E1 01 B0 A0 E1 ?? ?? ?? ?? 70 30 4F E2 0C 00 93 E8 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? 80 30 4F E2 0C 00 93 E8 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? 90 30 4F E2 0C 00 93 E8 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? A0 30 4F E2 0C 00 93 E8 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? B0 30 4F E2 0C 00 93 E8 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? C0 30 4F E2 0C 00 93 E8 00 60 A0 E1 01 70 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? D4 30 4F E2 0C 00 93 E8 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? E4 30 4F E2 0C 00 93 E8 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? F4 30 4F E2 0C 00 93 E8 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? FF 25 A0 E3 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 05 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 05 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 50 A0 E1 01 80 A0 E1 AC FE FF EA }
	condition:
		$1
}

rule file_195_0_1 {
	meta:
		name = "significand"
		size = 48
		refs = "000c ilogb 0014 __floatsidf 002c __ieee754_scalb"
	strings:
		$1 = { 30 40 2D E9 01 50 A0 E1 00 40 A0 E1 ?? ?? ?? ?? 00 00 60 E2 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 30 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_196_0_1 {
	meta:
		name = "__kernel_sinf"
		size = 336
		refs = "001c __fixsfsi 0030 __mulsf3 0054 __subsf3 0064 __addsf3"
	strings:
		$1 = { 02 31 C0 E3 32 04 53 E3 F0 45 2D E9 00 40 A0 E1 01 50 A0 E1 02 80 A0 E1 02 00 00 AA ?? ?? ?? ?? 00 00 50 E3 35 00 00 0A 04 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 00 60 A0 E1 ?? ?? ?? ?? F4 10 9F E5 00 70 A0 E1 06 00 A0 E1 ?? ?? ?? ?? E8 10 9F E5 ?? ?? ?? ?? 06 10 A0 E1 ?? ?? ?? ?? DC 10 9F E5 ?? ?? ?? ?? 06 10 A0 E1 ?? ?? ?? ?? 0D 1C A0 E3 4E 13 81 E2 15 16 81 E2 ?? ?? ?? ?? 06 10 A0 E1 ?? ?? ?? ?? B8 10 9F E5 ?? ?? ?? ?? 00 00 58 E3 00 A0 A0 E1 1A 00 00 0A 05 00 A0 E1 3F 14 A0 E3 ?? ?? ?? ?? 0A 10 A0 E1 00 80 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 06 10 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 70 10 9F E5 00 50 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 04 00 A0 E1 F0 85 BD E8 00 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 30 10 9F E5 ?? ?? ?? ?? 07 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 04 00 A0 E1 F0 85 BD E8 D3 C9 2E 2F 34 2F D7 32 1B EF 38 36 89 88 08 3C AB AA 2A 3E }
	condition:
		$1
}

rule file_197_0_1 {
	meta:
		name = "__kernel_tan"
		size = 1328
		refs = "0034 __fixdfsi 0074 __divdf3 00b4 __subdf3 00e4 __adddf3 0108 __muldf3 044c __floatsidf 0508 fabs"
	strings:
		$1 = { F0 4F 2D E9 00 40 A0 E1 00 B0 A0 E1 C1 04 E0 E3 0D 06 40 E2 02 A1 C4 E3 00 00 5A E1 18 D0 4D E2 01 50 A0 E1 02 80 A0 E1 03 90 A0 E1 14 00 00 CA 04 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 2D 00 00 1A 3C 20 9D E5 05 A0 8A E1 01 30 82 E2 03 30 9A E1 2A 01 00 0A 3C 30 9D E5 01 00 53 E3 D7 00 00 0A BF 04 A0 E3 04 20 A0 E1 05 30 A0 E1 0F 06 80 E2 00 10 A0 E3 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 CE 00 00 EA 69 39 E0 E3 AF 3D 43 E2 63 31 43 E2 03 00 5A E1 17 00 00 DA 00 00 54 E3 02 41 84 B2 02 81 82 B2 01 30 A0 E1 04 20 A0 E1 C7 1F 8F E2 03 00 91 E8 ?? ?? ?? ?? 08 20 A0 E1 00 40 A0 E1 01 50 A0 E1 09 30 A0 E1 C2 1F 8F E2 03 00 91 E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 80 A0 E3 00 40 A0 E1 01 50 A0 E1 08 90 A0 E1 04 20 A0 E1 05 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 03 00 8D E8 ?? ?? ?? ?? 04 20 A0 E1 00 60 A0 E1 01 70 A0 E1 05 30 A0 E1 03 00 9D E8 ?? ?? ?? ?? A9 3F 8F E2 0C 00 93 E8 08 00 8D E5 0C 10 8D E5 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 29 3E 8F E2 0C 00 93 E8 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? 0A 3D 8F E2 0C 00 93 E8 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? 27 3E 8F E2 0C 00 93 E8 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? 26 3E 8F E2 0C 00 93 E8 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? 25 3E 8F E2 0C 00 93 E8 ?? ?? ?? ?? 93 3F 8F E2 0C 00 93 E8 10 00 8D E5 14 10 8D E5 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 8E 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? 8A 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? 86 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? 82 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? 7E 3F 8F E2 0C 00 93 E8 ?? ?? ?? ?? 0C 00 9D E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 10 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 08 30 8D E2 0C 00 93 E8 ?? ?? ?? ?? 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? 0C 00 9D E8 ?? ?? ?? ?? 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? 6B 3F 8F E2 0C 00 93 E8 00 60 A0 E1 01 70 A0 E1 08 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? 03 00 8D E8 0C 00 9D E8 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 69 39 E0 E3 AF 3D 43 E2 63 31 43 E2 03 00 5A E1 00 60 A0 E1 01 80 A0 E1 58 00 00 CA 3C 20 9D E5 01 00 52 E3 00 40 A0 01 01 50 A0 01 31 00 00 0A 00 60 A0 E1 00 20 A0 E1 BF 04 A0 E3 01 30 A0 E1 0F 06 80 E2 00 10 A0 E3 ?? ?? ?? ?? 00 70 A0 E3 00 A0 A0 E1 04 20 A0 E1 05 30 A0 E1 01 B0 A0 E1 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 03 00 9D E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 0A 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 07 90 A0 E1 06 80 A0 E1 01 70 A0 E1 00 60 A0 E1 08 20 A0 E1 09 30 A0 E1 0A 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? FF 25 A0 E3 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? 0A 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 04 00 A0 E1 05 10 A0 E1 18 D0 8D E2 F0 8F BD E8 FB 21 E9 3F 18 2D 44 54 26 A6 81 3C 07 5C 14 33 CB 75 F3 BE 73 53 60 DB 88 7E 14 3F A6 92 37 A0 D8 44 43 3F 01 65 F2 F2 22 6D 6D 3F 28 03 56 C9 F4 64 96 3F 37 D6 06 84 11 11 C1 3F 7A FE 10 11 70 2A FB 3E D4 7A BF 74 0F B8 12 3F E9 A7 F0 32 F7 26 30 3F 68 10 8D 1A C8 DB 57 3F 15 83 E0 FE E3 26 82 3F 93 84 6E E9 BA A1 AB 3F FE 41 B3 1B 55 55 D5 3F 63 55 55 55 3C 00 9D E5 ?? ?? ?? ?? 06 20 A0 E1 00 90 A0 E1 01 A0 A0 E1 08 30 A0 E1 06 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 09 20 A0 E1 08 00 8D E5 0C 10 8D E5 0A 30 A0 E1 06 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 08 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 0C 00 9D E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 03 21 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 09 20 A0 E1 0A 30 A0 E1 ?? ?? ?? ?? 4B BF A0 E1 00 40 A0 E1 02 00 0B E2 01 50 A0 E1 01 00 60 E2 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 AF FF FF EA 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 FF 05 A0 E3 01 30 A0 E1 03 06 80 E2 00 10 A0 E3 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 A3 FF FF EA }
	condition:
		$1
}

rule file_198_0_1 {
	meta:
		name = "__ieee754_acosh"
		size = 420
		refs = "004c __adddf3 0080 __subdf3 00b0 __muldf3 00c8 __ieee754_sqrt 00dc log1p 00f4 __divdf3 00fc __ieee754_log"
	strings:
		$1 = { 03 31 E0 E3 01 36 43 E2 03 00 50 E1 F0 43 2D E9 00 40 A0 E1 01 50 A0 E1 00 60 A0 E1 01 70 A0 E1 2E 00 00 DA BE 34 E0 E3 05 36 43 E2 03 00 50 E1 07 00 00 DA 02 31 E0 E3 01 36 43 E2 03 00 50 E1 2D 00 00 DA 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? F0 83 BD E8 03 31 80 E2 01 36 83 E2 01 30 93 E1 00 00 A0 03 00 10 A0 03 F0 83 BD 08 01 01 54 E3 26 00 00 CA FF 25 A0 E3 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 00 40 A0 E1 01 50 A0 E1 ?? ?? ?? ?? 04 20 A0 E1 00 60 A0 E1 01 70 A0 E1 05 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? F0 43 BD E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? F0 83 BD E8 ?? ?? ?? ?? 94 30 8F E2 0C 00 93 E8 ?? ?? ?? ?? F0 83 BD E8 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? FF 25 A0 E3 03 26 82 E2 00 30 A0 E3 ?? ?? ?? ?? ?? ?? ?? ?? 04 20 A0 E1 00 60 A0 E1 01 70 A0 E1 05 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 04 20 A0 E1 00 80 A0 E1 01 90 A0 E1 05 30 A0 E1 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 BF 04 A0 E3 01 30 A0 E1 0F 06 80 E2 00 10 A0 E3 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? F0 43 BD E8 ?? ?? ?? ?? 42 2E E6 3F EF 39 FA FE }
	condition:
		$1
}

rule file_200_0_1 {
	meta:
		name = "floorf"
		size = 208
		refs = "0040 __addsf3 0048 __gtsf2"
	strings:
		$1 = { 70 40 2D E9 02 51 C0 E3 A5 4B A0 E1 7F 40 44 E2 16 00 54 E3 00 10 A0 E1 00 60 A0 E1 13 00 00 CA 00 00 54 E3 19 00 00 BA 02 55 A0 E3 01 50 45 E2 55 54 A0 E1 00 00 15 E1 0A 00 00 0A 88 10 9F E5 ?? ?? ?? ?? 00 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 03 00 00 DA 00 00 56 E3 02 35 A0 B3 53 64 86 B0 05 60 C6 E1 06 10 A0 E1 01 00 A0 E1 70 80 BD E8 02 31 E0 E3 02 35 43 E2 03 00 55 E1 F9 FF FF 9A ?? ?? ?? ?? 00 10 A0 E1 01 00 A0 E1 70 80 BD E8 34 10 9F E5 ?? ?? ?? ?? 00 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 EE FF FF DA 00 00 56 E3 00 60 A0 A3 EB FF FF AA BF 34 A0 E3 02 35 83 E2 00 00 55 E3 03 60 A0 11 06 10 A0 E1 E6 FF FF EA CA F2 49 71 }
	condition:
		$1
}

rule file_0_0_2 {
	meta:
		name = "__cxa_current_exception_type"
		size = 64
		refs = "0004 __cxa_get_globals"
	strings:
		$1 = { 10 40 2D E9 ?? ?? ?? ?? 00 00 90 E5 00 00 50 E3 10 80 BD 08 2C 20 80 E2 06 00 92 E8 01 30 A0 E3 00 40 A0 E3 01 30 03 E0 02 40 04 E0 04 20 93 E1 04 00 90 15 40 00 40 12 00 00 90 E5 10 80 BD E8 }
	condition:
		$1
}

rule file_1_0_2 {
	meta:
		name = "__cxa_pure_virtual"
		size = 28
		refs = "0010 write 0014 _ZSt9terminatev"
	strings:
		$1 = { 04 E0 2D E5 0C 10 9F E5 1B 20 A0 E3 02 00 A0 E3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_0_2 {
	meta:
		name = "_ZNSt10money_base20_S_construct_patternEccc"
		size = 20
		refs = "0010 _ZNSt10money_base18_S_default_patternE"
	strings:
		$1 = { 08 30 9F E5 00 30 93 E5 00 30 80 E5 1E FF 2F E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_1_2 {
	meta:
		name = "_ZNSt10moneypunctIcLb0EED1Ev"
		size = 204
		refs = "0038 _Unwind_SjLj_Register 007c _ZNSt6locale5facetD2Ev 0084 _Unwind_SjLj_Unregister 00b8 _Unwind_SjLj_Resume 00bc __gxx_personality_sj0 00c8 _ZTVSt10moneypunctIcLb0EE"
		altNames = "_ZNSt10moneypunctIcLb0EED2Ev"
	strings:
		$1 = { 00 48 2D E9 B0 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 A4 30 9F E5 1C 30 0B E5 A0 30 9F E5 04 20 4B E2 3C 00 0B E5 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 3C 30 1B E5 08 00 93 E5 3C 20 1B E5 78 30 9F E5 00 00 50 E3 00 30 82 E5 05 00 00 0A 00 30 90 E5 01 20 A0 E3 04 30 93 E5 34 20 0B E5 0F E0 A0 E1 13 FF 2F E1 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 A0 E3 34 30 0B E5 30 30 1B E5 3C 00 1B E5 3C 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_3_2 {
	meta:
		name = "_ZNSt10moneypunctIcLb1EED1Ev"
		size = 204
		refs = "0038 _Unwind_SjLj_Register 007c _ZNSt6locale5facetD2Ev 0084 _Unwind_SjLj_Unregister 00b8 _Unwind_SjLj_Resume 00bc __gxx_personality_sj0 00c8 _ZTVSt10moneypunctIcLb1EE"
	strings:
		$1 = { 00 48 2D E9 B0 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 A4 30 9F E5 1C 30 0B E5 A0 30 9F E5 04 20 4B E2 3C 00 0B E5 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 3C 30 1B E5 08 00 93 E5 3C 20 1B E5 78 30 9F E5 00 00 50 E3 00 30 82 E5 05 00 00 0A 00 30 90 E5 01 20 A0 E3 04 30 93 E5 34 20 0B E5 0F E0 A0 E1 13 FF 2F E1 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 A0 E3 34 30 0B E5 30 30 1B E5 3C 00 1B E5 3C 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_4_2 {
	meta:
		name = "_ZNSt10moneypunctIcLb1EED2Ev"
		size = 204
		refs = "0038 _Unwind_SjLj_Register 007c _ZNSt6locale5facetD2Ev 0084 _Unwind_SjLj_Unregister 00b8 _Unwind_SjLj_Resume 00bc __gxx_personality_sj0 00c8 _ZTVSt10moneypunctIcLb1EE"
	strings:
		$1 = { 00 48 2D E9 B0 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 A4 30 9F E5 1C 30 0B E5 A0 30 9F E5 04 20 4B E2 3C 00 0B E5 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 3C 30 1B E5 08 00 93 E5 3C 20 1B E5 78 30 9F E5 00 00 50 E3 00 30 82 E5 05 00 00 0A 00 30 90 E5 01 20 A0 E3 04 30 93 E5 34 20 0B E5 0F E0 A0 E1 13 FF 2F E1 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 A0 E3 34 30 0B E5 30 30 1B E5 3C 00 1B E5 3C 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_54_0_2 {
	meta:
		name = "_ZNSt8numpunctIcED1Ev"
		size = 204
		refs = "0038 _Unwind_SjLj_Register 007c _ZNSt6locale5facetD2Ev 0084 _Unwind_SjLj_Unregister 00b8 _Unwind_SjLj_Resume 00bc __gxx_personality_sj0 00c8 _ZTVSt8numpunctIcE"
	strings:
		$1 = { 00 48 2D E9 B0 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 A4 30 9F E5 1C 30 0B E5 A0 30 9F E5 04 20 4B E2 3C 00 0B E5 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 3C 30 1B E5 08 00 93 E5 3C 20 1B E5 78 30 9F