private rule architecture {
	meta:
		bits = 32
		endianness = "little"
		architecture = "x86"
	condition:
		true
}

rule file_0_0_0 {
	meta:
		name = "__wcsupr_l"
		size = 26
		refs = "000e __wcsupr_s_l"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 6A FF 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 08 5D C3 }
	condition:
		$1
}

rule file_864_0_0 {
	meta:
		name = "__strlwr_l"
		size = 26
		refs = "000e __strlwr_s_l"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 6A FF 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 08 5D C3 }
	condition:
		$1
}

rule file_903_0_0 {
	meta:
		name = "__strupr_l"
		size = 26
		refs = "000e __strupr_s_l"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 6A FF 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 08 5D C3 }
	condition:
		$1
}

rule file_149_0_0 {
	meta:
		name = "__wcslwr_l"
		size = 26
		refs = "000e __wcslwr_s_l"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 6A FF 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 08 5D C3 }
	condition:
		$1
}

rule file_0_1_0 {
	meta:
		name = "__wcsupr"
		size = 214
		refs = "0008 ___locale_changed 0026 ??_C@_1BK@HMILBCB@?$AAw?$AAs?$AAr?$AAc?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 002f ??_C@_1BC@IGMFNIEP@?$AAw?$AAc?$AAs?$AAu?$AAp?$AAr?$AA?4?$AAc?$AA?$AA@ 0036 __CrtDbgReportW 004a __errno 005e ??_C@_1BA@LGEDHIDA@?$AA_?$AAw?$AAc?$AAs?$AAu?$AAp?$AAr?$AA?$AA@ 0068 __invalid_parameter 00c8 __wcsupr_s_l"
	strings:
		$1 = { 55 8B EC 83 EC 08 83 3D ?? ?? ?? ?? 00 0F 85 AC 00 00 00 33 C0 83 7D 08 00 0F 95 C0 89 45 F8 83 7D F8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 40 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F8 00 75 2A E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 40 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 5F 8B 55 08 89 55 FC EB 09 8B 45 FC 83 C0 02 89 45 FC 8B 4D FC 0F B7 11 85 D2 74 2A 8B 45 FC 0F B7 08 83 F9 61 7C 1D 8B 55 FC 0F B7 02 83 F8 7A 7F 12 8B 4D FC 0F B7 11 81 C2 E0 FF 00 00 8B 45 FC 66 89 10 EB C3 8B 45 08 EB 15 EB 13 6A 00 6A FF 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_0_2_0 {
	meta:
		name = "__wcsupr_s_l"
		size = 61
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0016 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0024 ?_wcsupr_s_l_stat@@YAHPA_WIPAUlocaleinfo_struct@@@Z 0032 ??1_LocaleUpdate@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 83 EC 14 8B 45 10 50 8D 4D F0 E8 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 89 45 EC 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 EC 8B E5 5D C3 }
	condition:
		$1
}

rule file_864_5_0 {
	meta:
		name = "__strlwr_s_l"
		size = 61
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0016 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0024 ?_strlwr_s_l_stat@@YAHPADIPAUlocaleinfo_struct@@@Z 0032 ??1_LocaleUpdate@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 83 EC 14 8B 45 10 50 8D 4D F0 E8 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 89 45 EC 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 EC 8B E5 5D C3 }
	condition:
		$1
}

rule file_903_2_0 {
	meta:
		name = "__strupr_s_l"
		size = 61
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0016 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0024 ?_strupr_s_l_stat@@YAHPADIPAUlocaleinfo_struct@@@Z 0032 ??1_LocaleUpdate@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 83 EC 14 8B 45 10 50 8D 4D F0 E8 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 89 45 EC 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 EC 8B E5 5D C3 }
	condition:
		$1
}

rule file_149_2_0 {
	meta:
		name = "__wcslwr_s_l"
		size = 61
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0016 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0024 ?_wcslwr_s_l_stat@@YAHPA_WIPAUlocaleinfo_struct@@@Z 0032 ??1_LocaleUpdate@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 83 EC 14 8B 45 10 50 8D 4D F0 E8 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 89 45 EC 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 EC 8B E5 5D C3 }
	condition:
		$1
}

rule file_0_3_0 {
	meta:
		name = "??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z"
		size = 215
		refs = "0019 __getptd 0047 ___ptlocinfo 0058 ___globallocalestatus 005f ___updatetlocinfo 0070 ___ptmbcinfo 0088 ___updatetmbcinfo"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C6 40 0C 00 83 7D 08 00 0F 85 A6 00 00 00 E8 ?? ?? ?? ?? 8B 4D FC 89 41 08 8B 55 FC 8B 42 08 8B 4D FC 8B 50 6C 89 11 8B 45 FC 8B 48 08 8B 55 FC 8B 41 68 89 42 04 8B 4D FC 8B 11 3B 15 ?? ?? ?? ?? 74 1B 8B 45 FC 8B 48 08 8B 51 70 23 15 ?? ?? ?? ?? 75 0A E8 ?? ?? ?? ?? 8B 4D FC 89 01 8B 55 FC 8B 42 04 3B 05 ?? ?? ?? ?? 74 1C 8B 4D FC 8B 51 08 8B 42 70 23 05 ?? ?? ?? ?? 75 0B E8 ?? ?? ?? ?? 8B 4D FC 89 41 04 8B 55 FC 8B 42 08 8B 48 70 83 E1 02 75 1C 8B 55 FC 8B 42 08 8B 48 70 83 C9 02 8B 55 FC 8B 42 08 89 48 70 8B 4D FC C6 41 0C 01 EB 10 8B 55 08 8B 02 8B 4A 04 8B 55 FC 89 02 89 4A 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_0_4_0 {
	meta:
		name = "??1_LocaleUpdate@@QAE@XZ"
		size = 43
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 0F B6 48 0C 85 C9 74 15 8B 55 FC 8B 42 08 8B 48 70 83 E1 FD 8B 55 FC 8B 42 08 89 48 70 8B E5 5D C3 }
	condition:
		$1
}

rule file_0_6_0 {
	meta:
		name = "?_wcsupr_s_l_stat@@YAHPA_WIPAUlocaleinfo_struct@@@Z"
		size = 1066
		refs = "0020 ??_C@_1BK@HMILBCB@?$AAw?$AAs?$AAr?$AAc?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0029 ??_C@_1BC@IGMFNIEP@?$AAw?$AAc?$AAs?$AAu?$AAp?$AAr?$AA?4?$AAc?$AA?$AA@ 0030 __CrtDbgReportW 0044 __errno 0058 ??_C@_1CC@GAIHKOIP@?$AA_?$AAw?$AAc?$AAs?$AAu?$AAp?$AAr?$AA_?$AAs?$AA_?$AAl?$AA_?$AAs?$AAt?$AAa?$AAt?$AA?$AA@ 0062 __invalid_parameter 007c _wcsnlen 00b7 ___crtDebugFillThreshold 00e4 _memset 00ec ??_C@_1DM@FHLMIEG@?$AAS?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AAi?$AAs?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAn?$AAu?$AAl?$AAl?$AA?5?$AAt?$AAe?$AAr?$AAm?$AAi?$AAn?$AAa?$AAt?$AAe?$AAd?$AA?$AA@ 0115 ??_C@_1FA@MJKDNFFB@?$AA?$CI?$AAL?$AA?$CC?$AAS?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AAi?$AAs?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAn?$AAu?$AAl?$AAl?$AA?5?$AAt?$AAe?$AAr?$AAm?$AAi?$AAn?$AAa?$AAt?$AAe?$AAd@ 0245 ___crtLCMapStringW 02d2 ??_C@_1CI@HCPHDDLE@?$AAB?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AAi?$AAs?$AA?5?$AAt?$AAo?$AAo?$AA?5?$AAs?$AAm?$AAa?$AAl?$AAl?$AA?$AA@ 02fb ??_C@_1DM@MADKGDLO@?$AA?$CI?$AAL?$AA?$CC?$AAB?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AAi?$AAs?$AA?5?$AAt?$AAo?$AAo?$AA?5?$AAs?$AAm?$AAa?$AAl?$AAl?$AA?$CC?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA0?$AA?$CJ?$AA?$AA@ 037b _malloc 0384 __MarkAllocaS 03f9 _wcscpy_s 041c __freea"
	strings:
		$1 = { 55 8B EC 83 EC 38 C7 45 F4 00 00 00 00 33 C0 83 7D 08 00 0F 95 C0 89 45 E8 83 7D E8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 73 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E8 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 73 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 B3 03 00 00 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 EC 8B 4D EC 3B 4D 0C 0F 82 D6 00 00 00 8B 55 08 66 C7 02 00 00 83 7D 0C FF 74 4B 81 7D 0C FF FF FF 7F 74 42 83 7D 0C 01 76 3C 8B 45 0C 83 E8 01 39 05 ?? ?? ?? ?? 73 0B 8B 0D ?? ?? ?? ?? 89 4D DC EB 09 8B 55 0C 83 EA 01 89 55 DC 8B 45 DC D1 E0 50 68 FD 00 00 00 8B 4D 08 83 C1 02 51 E8 ?? ?? ?? ?? 83 C4 0C BA ?? ?? ?? ?? 85 D2 74 0D 33 C0 74 09 C7 45 D8 01 00 00 00 EB 07 C7 45 D8 00 00 00 00 8B 4D D8 89 4D E4 83 7D E4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 78 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E4 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 78 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 BE 02 00 00 83 7D 0C FF 74 5D 81 7D 0C FF FF FF 7F 74 54 8B 45 EC 83 C0 01 3B 45 0C 73 49 8B 4D EC 83 C1 01 8B 55 0C 2B D1 39 15 ?? ?? ?? ?? 73 0A A1 ?? ?? ?? ?? 89 45 D4 EB 0E 8B 4D EC 83 C1 01 8B 55 0C 2B D1 89 55 D4 8B 45 D4 D1 E0 50 68 FD 00 00 00 8B 4D EC 8B 55 08 8D 44 4A 02 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D 10 8B 11 83 7A 14 00 75 49 8B 45 08 89 45 FC EB 09 8B 4D FC 83 C1 02 89 4D FC 8B 55 FC 0F B7 02 85 C0 74 27 8B 4D FC 0F B7 11 83 FA 61 7C 1A 8B 45 FC 0F B7 08 83 F9 7A 7F 0F 8B 55 FC 0F B7 02 83 E8 20 8B 4D FC 66 89 01 EB C6 33 C0 E9 07 02 00 00 8B 55 10 8B 02 8B 48 04 51 6A 00 6A 00 6A FF 8B 55 08 52 68 00 02 00 00 8B 45 10 8B 08 8B 51 14 52 8B 45 10 50 E8 ?? ?? ?? ?? 83 C4 20 89 45 F8 83 7D F8 00 75 17 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 E8 ?? ?? ?? ?? 8B 00 E9 BA 01 00 00 8B 4D 0C 3B 4D F8 0F 83 DC 00 00 00 8B 55 08 66 C7 02 00 00 83 7D 0C FF 74 4B 81 7D 0C FF FF FF 7F 74 42 83 7D 0C 01 76 3C 8B 45 0C 83 E8 01 39 05 ?? ?? ?? ?? 73 0B 8B 0D ?? ?? ?? ?? 89 4D D0 EB 09 8B 55 0C 83 EA 01 89 55 D0 8B 45 D0 D1 E0 50 68 FD 00 00 00 8B 4D 08 83 C1 02 51 E8 ?? ?? ?? ?? 83 C4 0C BA ?? ?? ?? ?? 85 D2 74 0D 33 C0 74 09 C7 45 CC 01 00 00 00 EB 07 C7 45 CC 00 00 00 00 8B 4D CC 89 4D E0 83 7D E0 00 75 21 68 ?? ?? ?? ?? 6A 00 68 98 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 33 E8 ?? ?? ?? ?? C7 00 22 00 00 00 6A 00 68 98 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 22 00 00 00 E9 D2 00 00 00 83 7D F8 00 7E 36 33 C0 75 32 B8 E0 FF FF FF 33 D2 F7 75 F8 83 F8 02 72 23 68 DD DD 00 00 8B 4D F8 8D 54 09 08 52 E8 ?? ?? ?? ?? 83 C4 04 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 C8 EB 07 C7 45 C8 00 00 00 00 8B 45 C8 89 45 F0 83 7D F0 00 75 14 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E8 ?? ?? ?? ?? 8B 00 EB 6F 8B 4D 10 8B 11 8B 42 04 50 8B 4D F8 51 8B 55 F0 52 6A FF 8B 45 08 50 68 00 02 00 00 8B 4D 10 8B 11 8B 42 14 50 8B 4D 10 51 E8 ?? ?? ?? ?? 83 C4 20 85 C0 74 19 8B 55 F0 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F4 EB 12 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 C7 45 F4 2A 00 00 00 8B 55 F0 52 E8 ?? ?? ?? ?? 83 C4 04 8B 45 F4 8B E5 5D C3 }
	condition:
		$1
}

rule file_0_7_0 {
	meta:
		name = "__MarkAllocaS"
		size = 31
	strings:
		$1 = { 55 8B EC 83 7D 08 00 74 11 8B 45 08 8B 4D 0C 89 08 8B 55 08 83 C2 08 89 55 08 8B 45 08 5D C3 }
	condition:
		$1
}

rule file_0_8_0 {
	meta:
		name = "__freea"
		size = 52
		refs = "0029 _free"
	strings:
		$1 = { 55 8B EC 51 83 7D 08 00 74 26 8B 45 08 83 E8 08 89 45 08 8B 4D 08 8B 11 89 55 FC 81 7D FC DD DD 00 00 75 0C 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_0_9_0 {
	meta:
		name = "__wcsupr_s"
		size = 23
		refs = "000e __wcsupr_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_803_0_0 {
	meta:
		name = "__aligned_malloc_base"
		size = 23
		refs = "000e __aligned_offset_malloc_base"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_277_4_0 {
	meta:
		name = "__atodbl"
		size = 23
		refs = "000e __atodbl_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_277_8_0 {
	meta:
		name = "__atoflt"
		size = 23
		refs = "000e __atoflt_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_277_6_0 {
	meta:
		name = "__atoldbl"
		size = 23
		refs = "000e __atoldbl_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_627_0_0 {
	meta:
		name = "__execvp"
		size = 23
		refs = "000e __execvpe"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_407_1_0 {
	meta:
		name = "__getws_s"
		size = 23
		refs = "000e __getws_helper"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_878_4_0 {
	meta:
		name = "__ismbslead"
		size = 23
		refs = "000e __ismbslead_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_404_4_0 {
	meta:
		name = "__ismbstrail"
		size = 23
		refs = "000e __ismbstrail_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_181_4_0 {
	meta:
		name = "__mbsbtype"
		size = 23
		refs = "000e __mbsbtype_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_392_4_0 {
	meta:
		name = "__mbschr"
		size = 23
		refs = "000e __mbschr_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_34_4_0 {
	meta:
		name = "__mbscmp"
		size = 23
		refs = "000e __mbscmp_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_708_4_0 {
	meta:
		name = "__mbscoll"
		size = 23
		refs = "000e __mbscoll_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_139_4_0 {
	meta:
		name = "__mbscspn"
		size = 23
		refs = "000e __mbscspn_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_197_4_0 {
	meta:
		name = "__mbsdec"
		size = 23
		refs = "000e __mbsdec_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_484_4_0 {
	meta:
		name = "__mbsicmp"
		size = 23
		refs = "000e __mbsicmp_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_14_4_0 {
	meta:
		name = "__mbsicoll"
		size = 23
		refs = "000e __mbsicoll_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_910_4_0 {
	meta:
		name = "__mbslwr_s"
		size = 23
		refs = "000e __mbslwr_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_817_4_0 {
	meta:
		name = "__mbsnbcnt"
		size = 23
		refs = "000e __mbsnbcnt_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_829_4_0 {
	meta:
		name = "__mbsnccnt"
		size = 23
		refs = "000e __mbsnccnt_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_293_1_0 {
	meta:
		name = "__mbsninc"
		size = 23
		refs = "000e __mbsninc_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_308_4_0 {
	meta:
		name = "__mbsnlen"
		size = 23
		refs = "000e __mbsnlen_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_40_4_0 {
	meta:
		name = "__mbspbrk"
		size = 23
		refs = "000e __mbspbrk_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_675_4_0 {
	meta:
		name = "__mbsrchr"
		size = 23
		refs = "000e __mbsrchr_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_693_4_0 {
	meta:
		name = "__mbsset"
		size = 23
		refs = "000e __mbsset_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_792_4_0 {
	meta:
		name = "__mbsspn"
		size = 23
		refs = "000e __mbsspn_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_98_4_0 {
	meta:
		name = "__mbsspnp"
		size = 23
		refs = "000e __mbsspnp_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_299_4_0 {
	meta:
		name = "__mbsstr"
		size = 23
		refs = "000e __mbsstr_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_56_1_0 {
	meta:
		name = "__mbstok"
		size = 23
		refs = "000e __mbstok_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_875_4_0 {
	meta:
		name = "__mbstrnlen"
		size = 23
		refs = "000e __mbstrnlen_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_252_4_0 {
	meta:
		name = "__mbsupr_s"
		size = 23
		refs = "000e __mbsupr_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_864_9_0 {
	meta:
		name = "__strlwr_s"
		size = 23
		refs = "000e __strlwr_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_903_9_0 {
	meta:
		name = "__strupr_s"
		size = 23
		refs = "000e __strupr_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_149_9_0 {
	meta:
		name = "__wcslwr_s"
		size = 23
		refs = "000e __wcslwr_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_372_0_0 {
	meta:
		name = "__wexecvp"
		size = 23
		refs = "000e __wexecvpe"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_813_1_0 {
	meta:
		name = "_gets_s"
		size = 23
		refs = "000e __gets_helper"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_11_4_0 {
	meta:
		name = "_strcoll"
		size = 23
		refs = "000e __strcoll_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_377_4_0 {
	meta:
		name = "_strtod"
		size = 23
		refs = "000e __strtod_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_128_4_0 {
	meta:
		name = "_wcstod"
		size = 23
		refs = "000e __wcstod_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_1_0_0 {
	meta:
		name = "__mbsnbset_l"
		size = 478
		refs = "0014 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 001c ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0036 __strnset 0044 ??1_LocaleUpdate@@QAE@XZ 0079 ??_C@_1DK@PDIHELBP@?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 0082 ??_C@_1BG@NKMOODJ@?$AAm?$AAb?$AAs?$AAn?$AAb?$AAs?$AAe?$AAt?$AA?4?$AAc?$AA?$AA@ 0089 __CrtDbgReportW 009d __errno 00b1 ??_C@_1BI@CEPLNFIK@?$AA_?$AAm?$AAb?$AAs?$AAn?$AAb?$AAs?$AAe?$AAt?$AA_?$AAl?$AA?$AA@ 00bb __invalid_parameter 0107 ??_C@_1FG@HBOFIKMC@?$AA?$CI?$AA?$CC?$AAi?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAM?$AAB?$AAC?$AAS?$AA?5?$AAp?$AAa?$AAi?$AAr?$AA?5?$AAp?$AAa?$AAs?$AAs?$AAe?$AAd?$AA?5?$AAt?$AAo?$AA?5?$AAm?$AAb@"
	strings:
		$1 = { 55 8B EC 83 EC 2C 8B 45 08 89 45 F8 8B 4D 14 51 8D 4D E8 E8 ?? ?? ?? ?? 8D 4D E8 E8 ?? ?? ?? ?? 8B 50 04 83 7A 08 00 75 27 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 89 45 E0 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 E0 E9 8A 01 00 00 83 7D 08 00 75 0F 83 7D 10 00 74 09 C7 45 D4 00 00 00 00 EB 07 C7 45 D4 01 00 00 00 8B 45 D4 89 45 E4 83 7D E4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 4F 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E4 00 75 3D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 4F 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 DC 00 00 00 00 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 DC E9 01 01 00 00 8B 55 0C C1 EA 08 88 55 FF 0F B6 45 FF 85 C0 0F 84 AE 00 00 00 8B 4D 0C 81 E1 FF 00 00 00 88 4D FE 0F B6 55 FE 85 D2 75 37 33 C0 75 1E 68 ?? ?? ?? ?? 6A 00 6A 5E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC E8 ?? ?? ?? ?? C7 00 16 00 00 00 C6 45 FF 20 8A 55 FF 88 55 FE 8B 45 10 8B 4D 10 83 E9 01 89 4D 10 85 C0 74 51 8B 55 08 0F B6 02 85 C0 74 47 8B 4D 10 8B 55 10 83 EA 01 89 55 10 85 C9 74 0B 8B 45 08 0F B6 48 01 85 C9 75 08 8B 55 08 C6 02 20 EB 24 8B 45 08 8A 4D FF 88 08 8B 55 08 83 C2 01 89 55 08 8B 45 08 8A 4D FE 88 08 8B 55 08 83 C2 01 89 55 08 EB 9F EB 2D 8B 45 10 8B 4D 10 83 E9 01 89 4D 10 85 C0 74 1D 8B 55 08 0F B6 02 85 C0 74 13 8B 4D 08 8A 55 0C 88 11 8B 45 08 83 C0 01 89 45 08 EB D3 8B 4D F8 89 4D D8 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 D8 8B E5 5D C3 }
	condition:
		$1
}

rule file_1_4_0 {
	meta:
		name = "__mbsnbset"
		size = 27
		refs = "0012 __mbsnbset_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_69_1_1 {
	meta:
		name = "__Stoll"
		size = 27
		refs = "0012 __Stollx"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_56_1_1 {
	meta:
		name = "__Stoul"
		size = 27
		refs = "0012 __Stoulx"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_26_1_1 {
	meta:
		name = "__Stoull"
		size = 27
		refs = "0012 __Stoullx"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_803_2_0 {
	meta:
		name = "__aligned_realloc_base"
		size = 27
		refs = "0012 __aligned_offset_realloc_base"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_107_9_0 {
	meta:
		name = "__fassign"
		size = 27
		refs = "0012 __fassign_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_522_0_0 {
	meta:
		name = "__mbscat_s"
		size = 27
		refs = "0012 __mbscat_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_518_0_0 {
	meta:
		name = "__mbscpy_s"
		size = 27
		refs = "0012 __mbscpy_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_108_4_0 {
	meta:
		name = "__mbsnbcat"
		size = 27
		refs = "0012 __mbsnbcat_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_857_4_0 {
	meta:
		name = "__mbsnbcmp"
		size = 27
		refs = "0012 __mbsnbcmp_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_820_4_0 {
	meta:
		name = "__mbsnbcoll"
		size = 27
		refs = "0012 __mbsnbcoll_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_343_4_0 {
	meta:
		name = "__mbsnbcpy"
		size = 27
		refs = "0012 __mbsnbcpy_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_779_4_0 {
	meta:
		name = "__mbsnbicmp"
		size = 27
		refs = "0012 __mbsnbicmp_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_159_4_0 {
	meta:
		name = "__mbsnbicoll"
		size = 27
		refs = "0012 __mbsnbicoll_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_725_4_0 {
	meta:
		name = "__mbsncat"
		size = 27
		refs = "0012 __mbsncat_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_176_4_0 {
	meta:
		name = "__mbsncmp"
		size = 27
		refs = "0012 __mbsncmp_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_68_4_0 {
	meta:
		name = "__mbsncoll"
		size = 27
		refs = "0012 __mbsncoll_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_761_4_0 {
	meta:
		name = "__mbsncpy"
		size = 27
		refs = "0012 __mbsncpy_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_514_4_0 {
	meta:
		name = "__mbsnicmp"
		size = 27
		refs = "0012 __mbsnicmp_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_466_4_0 {
	meta:
		name = "__mbsnicoll"
		size = 27
		refs = "0012 __mbsnicoll_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_570_4_0 {
	meta:
		name = "__mbsnset"
		size = 27
		refs = "0012 __mbsnset_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_842_0_0 {
	meta:
		name = "__mbsset_s"
		size = 27
		refs = "0012 __mbsset_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_927_4_0 {
	meta:
		name = "__mbstok_s"
		size = 27
		refs = "0012 __mbstok_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_682_0_0 {
	meta:
		name = "__spawnvp"
		size = 27
		refs = "0012 __spawnvpe"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_744_0_0 {
	meta:
		name = "__wspawnvp"
		size = 27
		refs = "0012 __wspawnvpe"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_146_4_0 {
	meta:
		name = "_mbtowc"
		size = 27
		refs = "0012 __mbtowc_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_80_4_0 {
	meta:
		name = "_strxfrm"
		size = 27
		refs = "0012 __strxfrm_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_436_6_0 {
	meta:
		name = "_wcstombs"
		size = 27
		refs = "0012 __wcstombs_l_helper"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_332_4_0 {
	meta:
		name = "_wcsxfrm"
		size = 27
		refs = "0012 __wcsxfrm_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_2_0_0 {
	meta:
		name = "_wcsnlen"
		size = 58
	strings:
		$1 = { 55 8B EC 51 C7 45 FC 00 00 00 00 EB 12 8B 45 FC 83 C0 01 89 45 FC 8B 4D 08 83 C1 02 89 4D 08 8B 55 FC 3B 55 0C 73 0C 8B 45 08 0F B7 08 85 C9 74 02 EB DA 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_0_0 {
	meta:
		name = "___crtCompareStringA"
		size = 81
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0032 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0038 ?__crtCompareStringA_stat@@YAHPAUlocaleinfo_struct@@KKPBDH1HH@Z 0046 ??1_LocaleUpdate@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 83 EC 14 8B 45 08 50 8D 4D F0 E8 ?? ?? ?? ?? 8B 4D 24 51 8B 55 20 52 8B 45 1C 50 8B 4D 18 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8D 4D F0 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 20 89 45 EC 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 EC 8B E5 5D C3 }
	condition:
		$1
}

rule file_900_0_0 {
	meta:
		name = "___crtCompareStringW"
		size = 81
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0032 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0038 ?__crtCompareStringW_stat@@YAHPAUlocaleinfo_struct@@KKPB_WH1HH@Z 0046 ??1_LocaleUpdate@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 83 EC 14 8B 45 08 50 8D 4D F0 E8 ?? ?? ?? ?? 8B 4D 24 51 8B 55 20 52 8B 45 1C 50 8B 4D 18 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8D 4D F0 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 20 89 45 EC 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 EC 8B E5 5D C3 }
	condition:
		$1
}

rule file_325_0_0 {
	meta:
		name = "___crtGetStringTypeA"
		size = 81
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0032 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0038 ?__crtGetStringTypeA_stat@@YAHPAUlocaleinfo_struct@@KPBDHPAGHHH@Z 0046 ??1_LocaleUpdate@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 83 EC 14 8B 45 08 50 8D 4D F0 E8 ?? ?? ?? ?? 8B 4D 24 51 8B 55 20 52 8B 45 1C 50 8B 4D 18 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8D 4D F0 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 20 89 45 EC 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 EC 8B E5 5D C3 }
	condition:
		$1
}

rule file_828_0_0 {
	meta:
		name = "___crtLCMapStringW"
		size = 81
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0032 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0038 ?__crtLCMapStringW_stat@@YAHPAUlocaleinfo_struct@@KKPB_WHPA_WHH@Z 0046 ??1_LocaleUpdate@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 83 EC 14 8B 45 08 50 8D 4D F0 E8 ?? ?? ?? ?? 8B 4D 24 51 8B 55 20 52 8B 45 1C 50 8B 4D 18 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8D 4D F0 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 20 89 45 EC 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 EC 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_4_0 {
	meta:
		name = "?__crtCompareStringA_stat@@YAHPAUlocaleinfo_struct@@KKPBDH1HH@Z"
		size = 1282
		refs = "0007 ___security_cookie 0012 ?f_use@?1??__crtCompareStringA_stat@@YAHPAUlocaleinfo_struct@@KKPBDH1HH@Z@4HA 001c ??_C@_13NOLLCAOD@?$AA?$AA?$AA?$AA@ 002d __imp__CompareStringW@24 0043 __imp__GetLastError@0 0065 ?strncnt@@YAHPBDH@Z 00f1 ___ansicp 0125 ___convertcp 0168 __free_dbg 019c __imp__CompareStringA@24 023e __imp__GetCPInfo@8 0266 ??_C@_1HK@ELDMAMK@?$AAc?$AAc?$AAh?$AAC?$AAo?$AAu?$AAn?$AAt?$AA1?$AA?$DN?$AA?$DN?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAc?$AAc?$AAh?$AAC?$AAo?$AAu?$AAn?$AAt?$AA2?$AA?$DN?$AA?$DN?$AA1?$AA?5?$AA?$HM?$AA?$HM?$AA?5@ 0272 ??_C@_1BA@DGECELNE@?$AAa?$AA_?$AAc?$AAm?$AAp?$AA?4?$AAc?$AA?$AA@ 0279 __CrtDbgReportW 0380 __imp__MultiByteToWideChar@24 03bb _malloc 03c4 __MarkAllocaS 04d8 __freea 04fa @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 48 A1 ?? ?? ?? ?? 33 C5 89 45 D4 83 3D ?? ?? ?? ?? 00 75 3D 6A 01 68 ?? ?? ?? ?? 6A 01 68 ?? ?? ?? ?? 6A 00 6A 00 FF 15 ?? ?? ?? ?? 85 C0 74 0C C7 05 ?? ?? ?? ?? 01 00 00 00 EB 15 FF 15 ?? ?? ?? ?? 83 F8 78 75 0A C7 05 ?? ?? ?? ?? 02 00 00 00 83 7D 18 00 7E 15 8B 45 18 50 8B 4D 14 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 18 EB 0D 83 7D 18 FF 7D 07 33 C0 E9 76 04 00 00 83 7D 20 00 7E 15 8B 55 20 52 8B 45 1C 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 20 EB 0D 83 7D 20 FF 7D 07 33 C0 E9 4E 04 00 00 83 3D ?? ?? ?? ?? 02 74 0D 83 3D ?? ?? ?? ?? 00 0F 85 11 01 00 00 C7 45 F8 00 00 00 00 C7 45 F0 00 00 00 00 83 7D 0C 00 75 0B 8B 4D 08 8B 11 8B 42 14 89 45 0C 83 7D 24 00 75 0B 8B 4D 08 8B 11 8B 42 04 89 45 24 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 83 7D FC FF 75 07 33 C0 E9 EC 03 00 00 8B 55 FC 3B 55 24 74 72 6A 00 6A 00 8D 45 18 50 8B 4D 14 51 8B 55 FC 52 8B 45 24 50 E8 ?? ?? ?? ?? 83 C4 18 89 45 F8 83 7D F8 00 75 07 33 C0 E9 B8 03 00 00 6A 00 6A 00 8D 4D 20 51 8B 55 1C 52 8B 45 FC 50 8B 4D 24 51 E8 ?? ?? ?? ?? 83 C4 18 89 45 F0 83 7D F0 00 75 15 6A 02 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 08 33 C0 E9 7E 03 00 00 8B 45 F8 89 45 14 8B 4D F0 89 4D 1C 8B 55 20 52 8B 45 1C 50 8B 4D 18 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 FF 15 ?? ?? ?? ?? 89 45 F4 83 7D F8 00 74 1C 6A 02 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 45 F0 50 E8 ?? ?? ?? ?? 83 C4 08 8B 45 F4 E9 27 03 00 00 83 3D ?? ?? ?? ?? 01 0F 85 18 03 00 00 C7 45 E4 00 00 00 00 83 7D 24 00 75 0B 8B 4D 08 8B 11 8B 42 04 89 45 24 83 7D 18 00 74 0A 83 7D 20 00 0F 85 6A 01 00 00 8B 4D 18 3B 4D 20 75 0A B8 02 00 00 00 E9 E0 02 00 00 83 7D 20 01 7E 0A B8 01 00 00 00 E9 D0 02 00 00 83 7D 18 01 7E 0A B8 03 00 00 00 E9 C0 02 00 00 8D 55 C0 52 8B 45 24 50 FF 15 ?? ?? ?? ?? 85 C0 75 07 33 C0 E9 A7 02 00 00 83 7D 18 00 75 06 83 7D 20 01 74 2D 83 7D 18 01 75 06 83 7D 20 00 74 21 68 ?? ?? ?? ?? 6A 00 68 EA 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D 18 00 7E 6D 83 7D C0 02 73 0A B8 03 00 00 00 E9 58 02 00 00 8D 55 C6 89 55 D8 EB 09 8B 45 D8 83 C0 02 89 45 D8 8B 4D D8 0F B6 11 85 D2 74 38 8B 45 D8 0F B6 48 01 85 C9 74 2D 8B 55 14 0F B6 02 8B 4D D8 0F B6 11 3B C2 7C 1B 8B 45 14 0F B6 08 8B 55 D8 0F B6 42 01 3B C8 7F 0A B8 02 00 00 00 E9 07 02 00 00 EB B5 B8 03 00 00 00 E9 FB 01 00 00 83 7D 20 00 7E 6D 83 7D C0 02 73 0A B8 01 00 00 00 E9 E5 01 00 00 8D 4D C6 89 4D D8 EB 09 8B 55 D8 83 C2 02 89 55 D8 8B 45 D8 0F B6 08 85 C9 74 38 8B 55 D8 0F B6 42 01 85 C0 74 2D 8B 4D 1C 0F B6 11 8B 45 D8 0F B6 08 3B D1 7C 1B 8B 55 1C 0F B6 02 8B 4D D8 0F B6 51 01 3B C2 7F 0A B8 02 00 00 00 E9 94 01 00 00 EB B5 B8 01 00 00 00 E9 88 01 00 00 6A 00 6A 00 8B 45 18 50 8B 4D 14 51 6A 09 8B 55 24 52 FF 15 ?? ?? ?? ?? 89 45 E8 83 7D E8 00 75 07 33 C0 E9 60 01 00 00 83 7D E8 00 7E 36 33 C0 75 32 B8 E0 FF FF FF 33 D2 F7 75 E8 83 F8 02 72 23 68 DD DD 00 00 8B 4D E8 8D 54 09 08 52 E8 ?? ?? ?? ?? 83 C4 04 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 BC EB 07 C7 45 BC 00 00 00 00 8B 45 BC 89 45 E0 83 7D E0 00 75 07 33 C0 E9 0A 01 00 00 8B 4D E8 51 8B 55 E0 52 8B 45 18 50 8B 4D 14 51 6A 01 8B 55 24 52 FF 15 ?? ?? ?? ?? 85 C0 75 0A E9 D0 00 00 00 E9 CB 00 00 00 6A 00 6A 00 8B 45 20 50 8B 4D 1C 51 6A 09 8B 55 24 52 FF 15 ?? ?? ?? ?? 89 45 DC 83 7D DC 00 75 0A E9 A5 00 00 00 E9 A0 00 00 00 83 7D DC 00 7E 36 33 C0 75 32 B8 E0 FF FF FF 33 D2 F7 75 DC 83 F8 02 72 23 68 DD DD 00 00 8B 4D DC 8D 54 09 08 52 E8 ?? ?? ?? ?? 83 C4 04 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 B8 EB 07 C7 45 B8 00 00 00 00 8B 45 B8 89 45 EC 83 7D EC 00 75 04 EB 4F EB 4D 8B 4D DC 51 8B 55 EC 52 8B 45 20 50 8B 4D 1C 51 6A 01 8B 55 24 52 FF 15 ?? ?? ?? ?? 85 C0 74 21 8B 45 DC 50 8B 4D EC 51 8B 55 E8 52 8B 45 E0 50 8B 4D 10 51 8B 55 0C 52 FF 15 ?? ?? ?? ?? 89 45 E4 8B 45 EC 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D E0 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 E4 EB 04 EB 02 33 C0 8B 4D D4 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_6_0 {
	meta:
		name = "__freea"
		size = 100
		refs = "0029 _free 0040 ??_C@_1FE@KNPCCODH@?$AA?$CI?$AA?$CC?$AAC?$AAo?$AAr?$AAr?$AAu?$AAp?$AAt?$AAe?$AAd?$AA?5?$AAp?$AAo?$AAi?$AAn?$AAt?$AAe?$AAr?$AA?5?$AAp?$AAa?$AAs?$AAs?$AAe?$AAd?$AA?5?$AAt?$AAo?$AA?5?$AA_?$AAf@ 004c ??_C@_1GC@BCDEFAEE@?$AAF?$AA?3?$AA?2?$AAR?$AAT?$AAM?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAS?$AAE?$AAL?$AAF?$AA_?$AAX?$AA8?$AA6?$AA?2@ 0053 __CrtDbgReportW"
	strings:
		$1 = { 55 8B EC 51 83 7D 08 00 74 56 8B 45 08 83 E8 08 89 45 08 8B 4D 08 8B 11 89 55 FC 81 7D FC DD DD 00 00 75 0E 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 EB 2E 81 7D FC CC CC 00 00 74 25 33 C9 75 21 68 ?? ?? ?? ?? 6A 00 68 02 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_7_0 {
	meta:
		name = "?strncnt@@YAHPBDH@Z"
		size = 68
		altNames = "___strncnt"
	strings:
		$1 = { 55 8B EC 83 EC 08 8B 45 0C 89 45 F8 8B 4D 08 89 4D FC 8B 55 F8 8B 45 F8 83 E8 01 89 45 F8 85 D2 74 15 8B 4D FC 0F BE 11 85 D2 74 0B 8B 45 FC 83 C0 01 89 45 FC EB DB 8B 45 0C 2B 45 F8 83 E8 01 8B E5 5D C3 }
	condition:
		$1
}

rule file_4_0_0 {
	meta:
		name = "_sscanf"
		size = 41
		refs = "0019 __input_l 001e _vscan_fn"
	strings:
		$1 = { 55 8B EC 51 8D 45 10 89 45 FC 8B 4D FC 51 6A 00 8B 55 0C 52 8B 45 08 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_126_1_0 {
	meta:
		name = "_fscanf"
		size = 41
		refs = "0019 __input_l 001e _vfscanf"
	strings:
		$1 = { 55 8B EC 51 8D 45 10 89 45 FC 8B 4D FC 51 6A 00 8B 55 0C 52 8B 45 08 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_126_3_0 {
	meta:
		name = "_fscanf_s"
		size = 41
		refs = "0019 __input_s_l 001e _vfscanf"
	strings:
		$1 = { 55 8B EC 51 8D 45 10 89 45 FC 8B 4D FC 51 6A 00 8B 55 0C 52 8B 45 08 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_712_1_0 {
	meta:
		name = "_fwscanf"
		size = 41
		refs = "0019 __winput_l 001e _vfwscanf"
	strings:
		$1 = { 55 8B EC 51 8D 45 10 89 45 FC 8B 4D FC 51 6A 00 8B 55 0C 52 8B 45 08 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_712_3_0 {
	meta:
		name = "_fwscanf_s"
		size = 41
		refs = "0019 __winput_s_l 001e _vfwscanf"
	strings:
		$1 = { 55 8B EC 51 8D 45 10 89 45 FC 8B 4D FC 51 6A 00 8B 55 0C 52 8B 45 08 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_4_3_0 {
	meta:
		name = "_sscanf_s"
		size = 41
		refs = "0019 __input_s_l 001e _vscan_fn"
	strings:
		$1 = { 55 8B EC 51 8D 45 10 89 45 FC 8B 4D FC 51 6A 00 8B 55 0C 52 8B 45 08 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_97_0_0 {
	meta:
		name = "_swscanf"
		size = 41
		refs = "0019 __winput_l 001e _vscan_fn"
	strings:
		$1 = { 55 8B EC 51 8D 45 10 89 45 FC 8B 4D FC 51 6A 00 8B 55 0C 52 8B 45 08 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_97_3_0 {
	meta:
		name = "_swscanf_s"
		size = 41
		refs = "0019 __winput_s_l 001e _vscan_fn"
	strings:
		$1 = { 55 8B EC 51 8D 45 10 89 45 FC 8B 4D FC 51 6A 00 8B 55 0C 52 8B 45 08 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_4_1_0 {
	meta:
		name = "_vscan_fn"
		size = 313
		refs = "0011 _strlen 002e ??_C@_1CC@OLIJCKA@?$AA?$CI?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0037 ??_C@_1BC@MDHAFFLC@?$AAs?$AAs?$AAc?$AAa?$AAn?$AAf?$AA?4?$AAc?$AA?$AA@ 003e __CrtDbgReportW 0052 __errno 0066 ??_C@_1BC@KMGJCMNP@?$AAv?$AAs?$AAc?$AAa?$AAn?$AA_?$AAf?$AAn?$AA?$AA@ 0070 __invalid_parameter 0092 ??_C@_1CC@MGIEJOME@?$AA?$CI?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@"
	strings:
		$1 = { 55 8B EC 83 EC 34 8D 45 D4 89 45 F4 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 33 D2 83 7D 0C 00 0F 95 C2 89 55 D0 83 7D D0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 32 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D0 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 32 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 B6 00 00 00 33 C9 83 7D 10 00 0F 95 C1 89 4D CC 83 7D CC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 33 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D CC 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 33 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 55 8B 45 F4 C7 40 0C 49 00 00 00 8B 4D F4 8B 55 0C 89 51 08 8B 45 F4 8B 4D 0C 89 08 81 7D FC FF FF FF 7F 76 0C 8B 55 F4 C7 42 04 FF FF FF 7F EB 09 8B 45 F4 8B 4D FC 89 48 04 8B 55 18 52 8B 45 14 50 8B 4D 10 51 8B 55 F4 52 FF 55 08 83 C4 10 89 45 F8 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_4_2_0 {
	meta:
		name = "__sscanf_l"
		size = 43
		refs = "001b __input_l 0020 _vscan_fn"
	strings:
		$1 = { 55 8B EC 51 8D 45 14 89 45 FC 8B 4D FC 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_126_2_0 {
	meta:
		name = "__fscanf_l"
		size = 43
		refs = "001b __input_l 0020 _vfscanf"
	strings:
		$1 = { 55 8B EC 51 8D 45 14 89 45 FC 8B 4D FC 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_126_4_0 {
	meta:
		name = "__fscanf_s_l"
		size = 43
		refs = "001b __input_s_l 0020 _vfscanf"
	strings:
		$1 = { 55 8B EC 51 8D 45 14 89 45 FC 8B 4D FC 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_712_2_0 {
	meta:
		name = "__fwscanf_l"
		size = 43
		refs = "001b __winput_l 0020 _vfwscanf"
	strings:
		$1 = { 55 8B EC 51 8D 45 14 89 45 FC 8B 4D FC 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_712_4_0 {
	meta:
		name = "__fwscanf_s_l"
		size = 43
		refs = "001b __winput_s_l 0020 _vfwscanf"
	strings:
		$1 = { 55 8B EC 51 8D 45 14 89 45 FC 8B 4D FC 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_4_4_0 {
	meta:
		name = "__sscanf_s_l"
		size = 43
		refs = "001b __input_s_l 0020 _vscan_fn"
	strings:
		$1 = { 55 8B EC 51 8D 45 14 89 45 FC 8B 4D FC 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_97_2_0 {
	meta:
		name = "__swscanf_l"
		size = 43
		refs = "001b __winput_l 0020 _vscan_fn"
	strings:
		$1 = { 55 8B EC 51 8D 45 14 89 45 FC 8B 4D FC 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_97_4_0 {
	meta:
		name = "__swscanf_s_l"
		size = 43
		refs = "001b __winput_s_l 0020 _vscan_fn"
	strings:
		$1 = { 55 8B EC 51 8D 45 14 89 45 FC 8B 4D FC 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_6_0_0 {
	meta:
		name = "__wcwild"
		size = 388
		refs = "0007 ___wargv 0010 _argend 0020 _arghead 004e ??_C@_15EAECJAPL@?$AA?$CK?$AA?$DP?$AA?$AA@ 0059 _wcspbrk 0074 _wmatch 0090 _wadd 00d6 ??_C@_0CP@HKELLBJO@f?3?2rtm?2vctools?2crt_bld?2self_x86?2@ 00e6 __calloc_dbg 010b ___argc 0175 __free_dbg"
	strings:
		$1 = { 55 8B EC 83 EC 14 A1 ?? ?? ?? ?? 89 45 F8 C7 05 ?? ?? ?? ?? 00 00 00 00 8B 0D ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 89 55 F8 EB 09 8B 45 F8 83 C0 04 89 45 F8 8B 4D F8 83 39 00 74 65 8B 55 F8 8B 02 83 C0 02 8B 4D F8 89 01 68 ?? ?? ?? ?? 8B 55 F8 8B 02 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 F0 83 7D F0 00 74 20 8B 4D F0 51 8B 55 F8 8B 02 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 08 83 C8 FF E9 F9 00 00 00 EB 1A 8B 4D F8 8B 11 52 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 08 83 C8 FF E9 DD 00 00 00 EB 8A C7 45 FC 00 00 00 00 A1 ?? ?? ?? ?? 89 45 EC EB 12 8B 4D EC 8B 51 04 89 55 EC 8B 45 FC 83 C0 01 89 45 FC 83 7D EC 00 74 02 EB E6 68 B8 00 00 00 68 ?? ?? ?? ?? 6A 02 8B 4D FC 83 C1 01 51 6A 04 E8 ?? ?? ?? ?? 83 C4 14 89 45 F4 83 7D F4 00 75 08 83 C8 FF E9 82 00 00 00 8B 55 F4 89 15 ?? ?? ?? ?? 8B 45 FC A3 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 89 4D EC EB 09 8B 55 EC 8B 42 04 89 45 EC 83 7D EC 00 74 15 8B 4D F4 8B 55 EC 8B 02 89 01 8B 4D F4 83 C1 04 89 4D F4 EB DC 8B 55 F4 C7 02 00 00 00 00 A1 ?? ?? ?? ?? 89 45 EC EB 09 8B 0D ?? ?? ?? ?? 89 4D EC 83 7D EC 00 74 1E 8B 15 ?? ?? ?? ?? 8B 42 04 A3 ?? ?? ?? ?? 6A 02 8B 4D EC 51 E8 ?? ?? ?? ?? 83 C4 08 EB D3 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_6_1_0 {
	meta:
		name = "_wmatch"
		size = 761
		refs = "0071 _wadd 00b1 _wfind 00c7 _argend 00cf ??_C@_13JOFGPIOO@?$AA?4?$AA?$AA@ 00d8 _wcscmp 00e8 ??_C@_15DDHGOCBH@?$AA?4?$AA?4?$AA?$AA@ 0132 _wcslen 0145 ??_C@_0CP@HKELLBJO@f?3?2rtm?2vctools?2crt_bld?2self_x86?2@ 0152 __calloc_dbg 0172 ??_C@_1FO@DNIAPCDK@?$AAf?$AA?3?$AA?2?$AAr?$AAt?$AAm?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2@ 0177 ??_C@_1O@HBNGKAGH@?$AAw?$AAm?$AAa?$AAt?$AAc?$AAh?$AA?$AA@ 017c ??_C@_1DK@DJDMNJA@?$AAw?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAa?$AAr?$AAg?$AA?0?$AA?5?$AAa?$AAr?$AAg?$AA_?$AAs?$AAi?$AAz?$AAe?$AA?0?$AA?5?$AAn?$AAe?$AAw?$AA?$CJ?$AA?$AA@ 018d _wcscpy_s 0196 __invoke_watson_if_error 0224 ??_C@_1EM@IFHBLJKG@?$AAw?$AAc?$AAs?$AAn?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAa?$AAl?$AAl?$AA?0?$AA?5?$AAa?$AAl?$AAl?$AA_?$AAs?$AAi?$AAz?$AAe?$AA?0?$AA?5?$AAa?$AAr?$AAg?$AA?0?$AA?5?$AAl?$AAe@ 0239 _wcsncpy_s 025b ??_C@_1FO@JICCNOGN@?$AAw?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAa?$AAl?$AAl?$AA?5?$AA?$CL?$AA?5?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA?0?$AA?5?$AAa?$AAl?$AAl?$AA_?$AAs?$AAi?$AAz?$AAe?$AA?5@ 02d2 _arghead 02de _wsort"
	strings:
		$1 = { 55 8B EC 83 EC 20 C7 45 F8 00 00 00 00 C7 45 F4 00 00 00 00 83 7D 0C 00 75 08 83 C8 FF E9 D3 02 00 00 8B 45 0C 3B 45 08 74 2C 8B 4D 0C 0F B7 11 83 FA 5C 74 21 8B 45 0C 0F B7 08 83 F9 2F 74 16 8B 55 0C 0F B7 02 83 F8 3A 74 0B 8B 4D 0C 83 E9 02 89 4D 0C EB CC 8B 55 0C 0F B7 02 83 F8 3A 75 1C 8B 4D 08 83 C1 02 39 4D 0C 74 11 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 E9 78 02 00 00 8B 45 0C 0F B7 08 83 F9 5C 74 16 8B 55 0C 0F B7 02 83 F8 2F 74 0B 8B 4D 0C 0F B7 11 83 FA 3A 75 0E 8B 45 0C 2B 45 08 D1 F8 83 C0 01 89 45 F8 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 EC 83 7D EC 00 0F 84 24 02 00 00 8B 15 ?? ?? ?? ?? 89 55 FC 68 ?? ?? ?? ?? 8B 45 EC 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 0F 84 BC 01 00 00 68 ?? ?? ?? ?? 8B 4D EC 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 0F 84 A3 01 00 00 8B 55 0C 0F B7 02 83 F8 5C 0F 84 AB 00 00 00 8B 4D 0C 0F B7 11 83 FA 3A 0F 84 9C 00 00 00 8B 45 0C 0F B7 08 83 F9 2F 0F 84 8D 00 00 00 8B 55 EC 52 E8 ?? ?? ?? ?? 83 C4 04 83 C0 01 89 45 E8 68 14 01 00 00 68 ?? ?? ?? ?? 6A 02 6A 02 8B 45 E8 50 E8 ?? ?? ?? ?? 83 C4 14 89 45 08 83 7D 08 00 75 08 83 C8 FF E9 8B 01 00 00 6A 00 68 18 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 4D EC 51 8B 55 E8 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 08 83 C8 FF E9 40 01 00 00 E9 E0 00 00 00 8B 55 EC 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D F8 8D 54 01 01 89 55 E4 83 7D F8 00 7C 34 81 7D E4 FF FF FF 7F 73 2B 8B 45 E4 3B 45 F8 72 23 68 29 01 00 00 68 ?? ?? ?? ?? 6A 02 6A 02 8B 4D E4 51 E8 ?? ?? ?? ?? 83 C4 14 89 45 F0 83 7D F0 00 75 08 83 C8 FF E9 E3 00 00 00 6A 00 68 2D 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 55 F8 52 8B 45 08 50 8B 4D E4 51 8B 55 F0 52 E8 ?? ?? ?? ?? 83 C4 10 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 2E 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 45 EC 50 8B 4D E4 2B 4D F8 51 8B 55 F8 8B 45 F0 8D 0C 50 51 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 55 F0 52 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 05 83 C8 FF EB 5B 8B 45 F4 83 C0 01 89 45 F4 6A 00 E8 ?? ?? ?? ?? 83 C4 04 89 45 EC 83 7D EC 00 0F 85 14 FE FF FF 83 7D F4 00 74 29 83 7D FC 00 74 0B 8B 4D FC 8B 51 04 89 55 E0 EB 08 A1 ?? ?? ?? ?? 89 45 E0 8B 4D E0 51 E8 ?? ?? ?? ?? 83 C4 04 33 C0 EB 0C 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_6_2_0 {
	meta:
		name = "__invoke_watson_if_error"
		size = 41
		refs = "0020 __invoke_watson"
	strings:
		$1 = { 55 8B EC 83 7D 08 00 75 02 EB 1C 8B 45 1C 50 8B 4D 18 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_6_3_0 {
	meta:
		name = "_wadd"
		size = 103
		refs = "000a ??_C@_0CP@HKELLBJO@f?3?2rtm?2vctools?2crt_bld?2self_x86?2@ 0013 __malloc_dbg 003c _arghead 0044 _argend"
	strings:
		$1 = { 55 8B EC 51 68 5B 01 00 00 68 ?? ?? ?? ?? 6A 02 6A 08 E8 ?? ?? ?? ?? 83 C4 10 89 45 FC 83 7D FC 00 75 05 83 C8 FF EB 3B 8B 45 FC 8B 4D 08 89 08 8B 55 FC C7 42 04 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 0D A1 ?? ?? ?? ?? 8B 4D FC 89 48 04 EB 09 8B 55 FC 89 15 ?? ?? ?? ?? 8B 45 FC A3 ?? ?? ?? ?? 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_555_3_0 {
	meta:
		name = "_add"
		size = 103
		refs = "000a ??_C@_06PACCDJCA@wild?4c?$AA@ 0013 __malloc_dbg 003c _arghead 0044 _argend"
	strings:
		$1 = { 55 8B EC 51 68 5B 01 00 00 68 ?? ?? ?? ?? 6A 02 6A 08 E8 ?? ?? ?? ?? 83 C4 10 89 45 FC 83 7D FC 00 75 05 83 C8 FF EB 3B 8B 45 FC 8B 4D 08 89 08 8B 55 FC C7 42 04 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 0D A1 ?? ?? ?? ?? 8B 4D FC 89 48 04 EB 09 8B 55 FC 89 15 ?? ?? ?? ?? 8B 45 FC A3 ?? ?? ?? ?? 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_6_4_0 {
	meta:
		name = "_wsort"
		size = 107
		refs = "0028 __wcsicmp"
	strings:
		$1 = { 55 8B EC 83 EC 08 83 7D 08 00 74 5B 8B 45 08 8B 48 04 89 4D F8 83 7D F8 00 74 4C 8B 55 08 8B 02 50 8B 4D F8 8B 11 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 7D 1A 8B 45 08 8B 08 89 4D FC 8B 55 08 8B 45 F8 8B 08 89 0A 8B 55 F8 8B 45 FC 89 02 8B 4D F8 8B 51 04 89 55 F8 83 7D F8 00 75 BF 8B 45 08 8B 48 04 89 4D 08 EB A5 8B E5 5D C3 }
	condition:
		$1
}

rule file_555_4_0 {
	meta:
		name = "_sort"
		size = 107
		refs = "0028 __mbsicmp"
	strings:
		$1 = { 55 8B EC 83 EC 08 83 7D 08 00 74 5B 8B 45 08 8B 48 04 89 4D F8 83 7D F8 00 74 4C 8B 55 08 8B 02 50 8B 4D F8 8B 11 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 7D 1A 8B 45 08 8B 08 89 4D FC 8B 55 08 8B 45 F8 8B 08 89 0A 8B 55 F8 8B 45 FC 89 02 8B 4D F8 8B 51 04 89 55 F8 83 7D F8 00 75 BF 8B 45 08 8B 48 04 89 4D 08 EB A5 8B E5 5D C3 }
	condition:
		$1
}

rule file_6_5_0 {
	meta:
		name = "_wfind"
		size = 201
		refs = "000c ?findbuf@?1??wfind@@9@9 0019 ??_C@_0CP@HKELLBJO@f?3?2rtm?2vctools?2crt_bld?2self_x86?2@ 0025 __malloc_dbg 0043 ?_WildFindHandle@?1??wfind@@9@9 0052 __imp__FindClose@4 006d __imp__FindFirstFileW@8 0094 __imp__FindNextFileW@8"
	strings:
		$1 = { 55 8B EC 51 83 7D 08 00 74 7B 83 3D ?? ?? ?? ?? 00 75 2E 68 B6 01 00 00 68 ?? ?? ?? ?? 6A 02 68 54 03 00 00 E8 ?? ?? ?? ?? 83 C4 10 A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 75 07 33 C0 E9 84 00 00 00 83 3D ?? ?? ?? ?? 00 74 16 A1 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 00 00 00 00 8B 0D ?? ?? ?? ?? 51 8B 55 08 52 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? FF 75 04 33 C0 EB 42 EB 32 A1 ?? ?? ?? ?? 50 8B 0D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 85 C0 75 1B 8B 15 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 00 00 00 00 33 C0 EB 0E A1 ?? ?? ?? ?? 83 C0 2C 89 45 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_7_0_0 {
	meta:
		name = "__CallSettingFrame@12"
		size = 76
		refs = "001f __NLG_Notify1"
	strings:
		$1 = { 55 8B EC 83 EC 04 53 51 8B 45 0C 83 C0 0C 89 45 FC 8B 45 08 55 FF 75 10 8B 4D 10 8B 6D FC E8 ?? ?? ?? ?? 56 57 FF D0 5F 5E 8B DD 5D 8B 4D 10 55 8B EB 81 F9 00 01 00 00 75 05 B9 02 00 00 00 51 E8 ?? ?? ?? ?? 5D 59 5B C9 C2 0C 00 }
	condition:
		$1
}

rule file_9_0_0 {
	meta:
		name = "__wstrdate_s"
		size = 514
		refs = "002f ??_C@_1EM@GNJBJFJJ@?$AA?$CI?$AA?5?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAC?$AAh?$AAa?$AAr?$AAs?$AA?5@ 0038 ??_C@_1GE@IAEHHPF@?$AAf?$AA?3?$AA?2?$AAr?$AAt?$AAm?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2@ 003f __CrtDbgReportW 0053 __errno 0067 ??_C@_1BI@FHHDKDGF@?$AA_?$AAw?$AAs?$AAt?$AAr?$AAd?$AAa?$AAt?$AAe?$AA_?$AAs?$AA?$AA@ 0071 __invalid_parameter 00a7 ___crtDebugFillThreshold 00d4 _memset 00ea ??_C@_1CG@GLMCLJFL@?$AA?$CI?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAC?$AAh?$AAa?$AAr?$AAs?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA9?$AA?$CJ?$AA?$AA@ 0143 __imp__GetLocalTime@4"
	strings:
		$1 = { 55 8B EC 83 EC 2C 83 7D 08 00 74 0F 83 7D 0C 00 76 09 C7 45 D8 01 00 00 00 EB 07 C7 45 D8 00 00 00 00 8B 45 D8 89 45 E0 83 7D E0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 32 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 32 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 7C 01 00 00 8B 55 08 66 C7 02 00 00 83 7D 0C FF 74 4B 81 7D 0C FF FF FF 7F 74 42 83 7D 0C 01 76 3C 8B 45 0C 83 E8 01 39 05 ?? ?? ?? ?? 73 0B 8B 0D ?? ?? ?? ?? 89 4D D4 EB 09 8B 55 0C 83 EA 01 89 55 D4 8B 45 D4 D1 E0 50 68 FD 00 00 00 8B 4D 08 83 C1 02 51 E8 ?? ?? ?? ?? 83 C4 0C 83 7D 0C 09 1B D2 83 C2 01 89 55 DC 75 1E 68 ?? ?? ?? ?? 6A 00 6A 34 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D DC 00 75 30 E8 ?? ?? ?? ?? C7 00 22 00 00 00 6A 00 6A 34 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 22 00 00 00 E9 C1 00 00 00 8D 4D E8 51 FF 15 ?? ?? ?? ?? 0F B7 55 EA 89 55 F8 0F B7 45 EE 89 45 FC 0F B7 45 E8 99 B9 64 00 00 00 F7 F9 89 55 E4 8B 55 08 66 C7 42 0A 2F 00 8B 45 08 66 C7 40 04 2F 00 8B 4D 08 66 C7 41 10 00 00 8B 45 F8 99 B9 0A 00 00 00 F7 F9 83 C0 30 8B 55 08 66 89 02 8B 45 F8 99 B9 0A 00 00 00 F7 F9 83 C2 30 8B 45 08 66 89 50 02 8B 45 FC 99 B9 0A 00 00 00 F7 F9 83 C0 30 8B 55 08 66 89 42 06 8B 45 FC 99 B9 0A 00 00 00 F7 F9 83 C2 30 8B 45 08 66 89 50 08 8B 45 E4 99 B9 0A 00 00 00 F7 F9 83 C0 30 8B 55 08 66 89 42 0C 8B 45 E4 99 B9 0A 00 00 00 F7 F9 83 C2 30 8B 45 08 66 89 50 0E 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_9_1_0 {
	meta:
		name = "__wstrdate"
		size = 38
		refs = "000b __wstrdate_s"
	strings:
		$1 = { 55 8B EC 51 6A 09 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 04 33 C0 EB 03 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_801_1_0 {
	meta:
		name = "__strdate"
		size = 38
		refs = "000b __strdate_s"
	strings:
		$1 = { 55 8B EC 51 6A 09 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 04 33 C0 EB 03 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_639_1_0 {
	meta:
		name = "__strtime"
		size = 38
		refs = "000b __strtime_s"
	strings:
		$1 = { 55 8B EC 51 6A 09 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 04 33 C0 EB 03 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_794_1_0 {
	meta:
		name = "__wstrtime"
		size = 38
		refs = "000b __wstrtime_s"
	strings:
		$1 = { 55 8B EC 51 6A 09 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 04 33 C0 EB 03 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_10_0_0 {
	meta:
		name = "___libm_sse2_sincosf"
		size = 517
		refs = "0023 _PI32INV 002f _SHIFTER 003f _P_1 004b _P_2 0064 _SC_4 006a _Ctable 007f _P_3 00a0 _SC_2 00f2 _SC_3 00fe _SC_1 0186 _ONE 0194 _ALL_ONES 01a5 _TWO_POW_55 01b5 _TWO_POW_M55 01da _cos 01ee _sin"
	strings:
		$1 = { F3 0F 5A C0 66 0F C5 C0 03 66 25 FF 7F 66 2D 30 30 66 3D C5 10 0F 87 53 01 00 00 66 0F 14 C0 66 0F 28 0D ?? ?? ?? ?? 66 0F 59 C8 66 0F 28 15 ?? ?? ?? ?? F2 0F 2D D1 66 0F 58 CA 66 0F 28 1D ?? ?? ?? ?? 66 0F 5C CA 66 0F 28 15 ?? ?? ?? ?? 66 0F 59 D9 81 C2 00 76 1C 00 66 0F 28 E0 83 E2 3F 66 0F 28 2D ?? ?? ?? ?? 8D 05 ?? ?? ?? ?? C1 E2 06 03 C2 66 0F 59 D1 66 0F 5C C3 66 0F 59 0D ?? ?? ?? ?? 66 0F 5C E3 66 0F 28 78 10 66 0F 28 DC 66 0F 5C E2 66 0F 59 E8 66 0F 5C C2 66 0F 28 35 ?? ?? ?? ?? 66 0F 59 FC 66 0F 5C DC 66 0F 59 E8 66 0F 59 C0 66 0F 5C DA 66 0F 28 10 66 0F 5C CB 66 0F 28 58 30 66 0F 58 D3 66 0F 5C FA 66 0F 59 CF 66 0F 28 78 10 66 0F 59 D4 66 0F 59 F0 66 0F 59 DC 66 0F 59 D0 66 0F 59 F8 66 0F 59 C0 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 20 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 E8 66 0F 28 C3 66 0F 58 58 10 66 0F 58 F5 F2 0F 10 EE 66 0F 15 F6 66 0F 14 ED 66 0F 59 F7 66 0F 59 D5 66 0F 28 FC 66 0F 58 E3 66 0F 28 68 10 66 0F 5C EB 66 0F 5C DC 66 0F 58 48 20 66 0F 58 E8 66 0F 58 DF 66 0F 58 CD 66 0F 58 CB 66 0F 58 CA 66 0F 58 CE 66 0F 58 CC F2 0F 10 C1 66 0F 15 C9 F2 0F 5A C0 F2 0F 5A C9 C3 7F 52 F2 0F 10 C8 66 0F C5 C0 03 66 0D 00 80 66 0F C4 C8 03 F2 0F 58 0D ?? ?? ?? ?? 66 3D 10 80 7D 11 F2 0F 59 05 ?? ?? ?? ?? F2 0F 5A C0 F2 0F 5A C9 C3 F2 0F 10 1D ?? ?? ?? ?? F2 0F 59 D8 F2 0F 5C C3 F2 0F 59 05 ?? ?? ?? ?? F2 0F 5A C0 F2 0F 5A C9 C3 8B C4 83 EC 20 83 E4 F0 89 44 24 08 66 0F D6 44 24 10 66 0F D6 04 24 E8 ?? ?? ?? ?? D9 5C 24 18 F3 0F 7E 44 24 10 66 0F D6 04 24 E8 ?? ?? ?? ?? D9 1C 24 66 0F 6E 04 24 66 0F 6E 4C 24 18 8B 64 24 08 C3 }
	condition:
		$1
}

rule file_11_0_0 {
	meta:
		name = "__strcoll_l"
		size = 422
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0025 ??_C@_1CC@ICKKAGJA@?$AA_?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA1?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 002e ??_C@_1BE@PIJHJDJO@?$AAs?$AAt?$AAr?$AAc?$AAo?$AAl?$AAl?$AA?4?$AAc?$AA?$AA@ 0035 __CrtDbgReportW 0049 __errno 005d ??_C@_1BG@HIFFAGAH@?$AA_?$AAs?$AAt?$AAr?$AAc?$AAo?$AAl?$AAl?$AA_?$AAl?$AA?$AA@ 0067 __invalid_parameter 0079 ??1_LocaleUpdate@@QAE@XZ 0098 ??_C@_1CC@CNADELFK@?$AA_?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA2?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 00fc ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0111 _strcmp 015f ___crtCompareStringA"
	strings:
		$1 = { 55 8B EC 83 EC 30 8B 45 10 50 8D 4D EC E8 ?? ?? ?? ?? 33 C9 83 7D 08 00 0F 95 C1 89 4D E8 83 7D E8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 39 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E8 00 75 3D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 39 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 E0 FF FF FF 7F 8D 4D EC E8 ?? ?? ?? ?? 8B 45 E0 E9 1D 01 00 00 33 C0 83 7D 0C 00 0F 95 C0 89 45 E4 83 7D E4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3A 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E4 00 75 3D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 3A 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 DC FF FF FF 7F 8D 4D EC E8 ?? ?? ?? ?? 8B 45 DC E9 AA 00 00 00 8D 4D EC E8 ?? ?? ?? ?? 8B 10 83 7A 10 00 75 20 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 D8 8D 4D EC E8 ?? ?? ?? ?? 8B 45 D8 EB 7A 8D 4D EC E8 ?? ?? ?? ?? 8B 10 8B 42 08 50 6A FF 8B 4D 0C 51 6A FF 8B 55 08 52 68 00 10 00 00 8D 4D EC E8 ?? ?? ?? ?? 8B 00 8B 48 10 51 8D 4D EC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 20 89 45 FC 83 7D FC 00 75 1F E8 ?? ?? ?? ?? C7 00 16 00 00 00 C7 45 D4 FF FF FF 7F 8D 4D EC E8 ?? ?? ?? ?? 8B 45 D4 EB 14 8B 55 FC 83 EA 02 89 55 D0 8D 4D EC E8 ?? ?? ?? ?? 8B 45 D0 8B E5 5D C3 }
	condition:
		$1
}

rule file_12_0_0 {
	meta:
		name = "__itoa"
		size = 60
		refs = "001e _xtoa@16"
	strings:
		$1 = { 55 8B EC 83 7D 10 0A 75 1B 83 7D 08 00 7D 15 6A 01 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? EB 13 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 8B 45 0C 5D C3 }
	condition:
		$1
}

rule file_130_0_0 {
	meta:
		name = "__itow"
		size = 60
		refs = "001e _xtow@16"
	strings:
		$1 = { 55 8B EC 83 7D 10 0A 75 1B 83 7D 08 00 7D 15 6A 01 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? EB 13 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 8B 45 0C 5D C3 }
	condition:
		$1
}

rule file_12_1_0 {
	meta:
		name = "_xtoa@16"
		size = 196
	strings:
		$1 = { 55 8B EC 83 EC 10 8B 45 0C 89 45 FC 83 7D 14 00 74 17 8B 4D FC C6 01 2D 8B 55 FC 83 C2 01 89 55 FC 8B 45 08 F7 D8 89 45 08 8B 4D FC 89 4D F0 8B 45 08 33 D2 F7 75 10 89 55 F8 8B 45 08 33 D2 F7 75 10 89 45 08 83 7D F8 09 76 16 8B 55 F8 83 C2 57 8B 45 FC 88 10 8B 4D FC 83 C1 01 89 4D FC EB 14 8B 55 F8 83 C2 30 8B 45 FC 88 10 8B 4D FC 83 C1 01 89 4D FC 83 7D 08 00 77 B4 8B 55 FC C6 02 00 8B 45 FC 83 E8 01 89 45 FC 8B 4D FC 8A 11 88 55 F7 8B 45 FC 8B 4D F0 8A 11 88 10 8B 45 F0 8A 4D F7 88 08 8B 55 FC 83 EA 01 89 55 FC 8B 45 F0 83 C0 01 89 45 F0 8B 4D F0 3B 4D FC 72 CC 8B E5 5D C2 10 00 }
	condition:
		$1
}

rule file_12_2_0 {
	meta:
		name = "__ltoa"
		size = 60
		refs = "0031 _xtoa@16"
	strings:
		$1 = { 55 8B EC 51 83 7D 10 0A 75 0F 83 7D 08 00 7D 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 45 FC 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 8B 45 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_130_2_0 {
	meta:
		name = "__ltow"
		size = 60
		refs = "0031 _xtow@16"
	strings:
		$1 = { 55 8B EC 51 83 7D 10 0A 75 0F 83 7D 08 00 7D 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 45 FC 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 8B 45 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_12_3_0 {
	meta:
		name = "__ultoa"
		size = 27
		refs = "0012 _xtoa@16"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 8B 45 0C 5D C3 }
	condition:
		$1
}

rule file_130_3_0 {
	meta:
		name = "__ultow"
		size = 27
		refs = "0012 _xtow@16"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 8B 45 0C 5D C3 }
	condition:
		$1
}

rule file_12_4_0 {
	meta:
		name = "__i64toa"
		size = 70
		refs = "003b @x64toa@20"
	strings:
		$1 = { 55 8B EC 51 83 7D 14 0A 75 17 83 7D 0C 00 7F 11 7C 06 83 7D 08 00 73 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 45 FC 50 8B 4D 0C 51 8B 55 08 52 8B 55 14 8B 4D 10 E8 ?? ?? ?? ?? 8B 45 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_130_4_0 {
	meta:
		name = "__i64tow"
		size = 70
		refs = "003b @x64tow@20"
	strings:
		$1 = { 55 8B EC 51 83 7D 14 0A 75 17 83 7D 0C 00 7F 11 7C 06 83 7D 08 00 73 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 45 FC 50 8B 4D 0C 51 8B 55 08 52 8B 55 14 8B 4D 10 E8 ?? ?? ?? ?? 8B 45 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_12_5_0 {
	meta:
		name = "@x64toa@20"
		size = 248
		refs = "0050 __aullrem 0067 __aulldiv"
	strings:
		$1 = { 55 8B EC 83 EC 18 89 55 E8 89 4D EC 8B 45 EC 89 45 FC 83 7D 10 00 74 22 8B 4D FC C6 01 2D 8B 55 FC 83 C2 01 89 55 FC 8B 45 08 F7 D8 8B 4D 0C 83 D1 00 F7 D9 89 45 08 89 4D 0C 8B 55 FC 89 55 F0 8B 45 E8 33 C9 51 50 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 89 45 F8 8B 4D E8 33 D2 52 51 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 89 45 08 89 55 0C 83 7D F8 09 76 16 8B 55 F8 83 C2 57 8B 45 FC 88 10 8B 4D FC 83 C1 01 89 4D FC EB 14 8B 55 F8 83 C2 30 8B 45 FC 88 10 8B 4D FC 83 C1 01 89 4D FC 83 7D 0C 00 77 99 72 06 83 7D 08 00 77 91 8B 55 FC C6 02 00 8B 45 FC 83 E8 01 89 45 FC 8B 4D FC 8A 11 88 55 F7 8B 45 FC 8B 4D F0 8A 11 88 10 8B 45 F0 8A 4D F7 88 08 8B 55 FC 83 EA 01 89 55 FC 8B 45 F0 83 C0 01 89 45 F0 8B 4D F0 3B 4D FC 72 CC 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_12_6_0 {
	meta:
		name = "__ui64toa"
		size = 29
		refs = "0014 @x64toa@20"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 8B 55 14 8B 4D 10 E8 ?? ?? ?? ?? 8B 45 10 5D C3 }
	condition:
		$1
}

rule file_130_6_0 {
	meta:
		name = "__ui64tow"
		size = 29
		refs = "0014 @x64tow@20"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 8B 55 14 8B 4D 10 E8 ?? ?? ?? ?? 8B 45 10 5D C3 }
	condition:
		$1
}

rule file_13_0_0 {
	meta:
		name = "__spawnl"
		size = 424
		refs = "0019 ??_C@_1CC@MODLNCFO@?$AAp?$AAa?$AAt?$AAh?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0022 ??_C@_1BC@HJDDHBDJ@?$AAs?$AAp?$AAa?$AAw?$AAn?$AAl?$AA?4?$AAc?$AA?$AA@ 0029 __CrtDbgReportW 003d __errno 0051 ??_C@_1BA@DMANNNMI@?$AA_?$AAs?$AAp?$AAa?$AAw?$AAn?$AAl?$AA?$AA@ 005b __invalid_parameter 007c ??_C@_1CM@PKENOFGE@?$AA?$CK?$AAp?$AAa?$AAt?$AAh?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 00e0 ??_C@_1CA@MOAFCHEI@?$AAa?$AAr?$AAg?$AAl?$AAi?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0140 ??_C@_1CK@PKCLGCC@?$AA?$CK?$AAa?$AAr?$AAg?$AAl?$AAi?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 019d __spawnve"
	strings:
		$1 = { 55 8B EC 83 EC 10 33 C0 83 7D 0C 00 0F 95 C0 89 45 FC 83 7D FC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 37 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D FC 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 37 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 3A 01 00 00 8B 55 0C 0F BE 02 F7 D8 1B C0 F7 D8 89 45 F8 75 1E 68 ?? ?? ?? ?? 6A 00 6A 38 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F8 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 38 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 D7 00 00 00 33 D2 83 7D 10 00 0F 95 C2 89 55 F4 83 7D F4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 39 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F4 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 39 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 76 8B 4D 10 0F BE 11 F7 DA 1B D2 F7 DA 89 55 F0 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3A 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 3A 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 16 6A 00 8D 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_14_0_0 {
	meta:
		name = "__mbsicoll_l"
		size = 429
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0025 ??_C@_1BG@MODEICJK@?$AAs?$AA1?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 002e ??_C@_1BG@DHADFGBD@?$AAm?$AAb?$AAs?$AAi?$AAc?$AAo?$AAl?$AAl?$AA?4?$AAc?$AA?$AA@ 0035 __CrtDbgReportW 0049 __errno 005d ??_C@_1BI@BOFEGNKA@?$AA_?$AAm?$AAb?$AAs?$AAi?$AAc?$AAo?$AAl?$AAl?$AA_?$AAl?$AA?$AA@ 0067 __invalid_parameter 0079 ??1_LocaleUpdate@@QAE@XZ 0098 ??_C@_1BG@GBJNMPFA@?$AAs?$AA2?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 00fc ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0116 __stricoll_l 0166 ___crtCompareStringA"
	strings:
		$1 = { 55 8B EC 83 EC 30 8B 45 10 50 8D 4D EC E8 ?? ?? ?? ?? 33 C9 83 7D 08 00 0F 95 C1 89 4D E8 83 7D E8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 36 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E8 00 75 3D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 36 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 E0 FF FF FF 7F 8D 4D EC E8 ?? ?? ?? ?? 8B 45 E0 E9 24 01 00 00 33 C0 83 7D 0C 00 0F 95 C0 89 45 E4 83 7D E4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 37 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E4 00 75 3D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 37 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 DC FF FF FF 7F 8D 4D EC E8 ?? ?? ?? ?? 8B 45 DC E9 B1 00 00 00 8D 4D EC E8 ?? ?? ?? ?? 8B 50 04 83 7A 08 00 75 24 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 89 45 D8 8D 4D EC E8 ?? ?? ?? ?? 8B 45 D8 EB 7C 8D 4D EC E8 ?? ?? ?? ?? 8B 40 04 8B 48 04 51 6A FF 8B 55 0C 52 6A FF 8B 45 08 50 68 01 10 00 00 8D 4D EC E8 ?? ?? ?? ?? 8B 48 04 8B 51 0C 52 8D 4D EC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 20 89 45 FC 83 7D FC 00 75 1F E8 ?? ?? ?? ?? C7 00 16 00 00 00 C7 45 D4 FF FF FF 7F 8D 4D EC E8 ?? ?? ?? ?? 8B 45 D4 EB 14 8B 45 FC 83 E8 02 89 45 D0 8D 4D EC E8 ?? ?? ?? ?? 8B 45 D0 8B E5 5D C3 }
	condition:
		$1
}

rule file_15_0_0 {
	meta:
		name = "__EH_prolog"
		size = 31
	strings:
		$1 = { 6A FF 50 64 A1 00 00 00 00 50 8B 44 24 0C 64 89 25 00 00 00 00 89 6C 24 0C 8D 6C 24 0C 50 C3 }
	condition:
		$1
}

rule file_16_0_0 {
	meta:
		name = "__wcsnicmp_l"
		size = 553
		refs = "002a ??_C@_1BM@CBACDFHA@?$AAf?$AAi?$AAr?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0033 ??_C@_1BG@ICJCOIKB@?$AAw?$AAc?$AAs?$AAn?$AAi?$AAc?$AAm?$AAp?$AA?4?$AAc?$AA?$AA@ 003a __CrtDbgReportW 004e __errno 0062 ??_C@_1BI@KLMFNDBC@?$AA_?$AAw?$AAc?$AAs?$AAn?$AAi?$AAc?$AAm?$AAp?$AA_?$AAl?$AA?$AA@ 006c __invalid_parameter 0090 ??_C@_1BK@LKBOPAFJ@?$AAl?$AAa?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 00eb ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 00f3 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 01b5 __towlower_l 021e ??1_LocaleUpdate@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 83 EC 2C C7 45 F4 00 00 00 00 83 7D 10 00 0F 84 0B 02 00 00 33 C0 83 7D 08 00 0F 95 C0 89 45 E0 83 7D E0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3D 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 3D 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF FF 7F E9 A8 01 00 00 33 D2 83 7D 0C 00 0F 95 C2 89 55 DC 83 7D DC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D DC 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 3E 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF FF 7F E9 42 01 00 00 8B 4D 14 51 8D 4D E4 E8 ?? ?? ?? ?? 8D 4D E4 E8 ?? ?? ?? ?? 8B 10 83 7A 14 00 0F 85 A1 00 00 00 8B 45 08 0F B7 08 83 F9 41 7C 19 8B 55 08 0F B7 02 83 F8 5A 7F 0E 8B 4D 08 0F B7 11 83 C2 20 89 55 D8 EB 09 8B 45 08 0F B7 08 89 4D D8 66 8B 55 D8 66 89 55 FC 8B 45 0C 0F B7 08 83 F9 41 7C 19 8B 55 0C 0F B7 02 83 F8 5A 7F 0E 8B 4D 0C 0F B7 11 83 C2 20 89 55 D4 EB 09 8B 45 0C 0F B7 08 89 4D D4 66 8B 55 D4 66 89 55 F8 8B 45 08 83 C0 02 89 45 08 8B 4D 0C 83 C1 02 89 4D 0C 8B 55 10 83 EA 01 89 55 10 74 18 0F B7 45 FC 85 C0 74 10 0F B7 4D FC 0F B7 55 F8 3B CA 0F 84 61 FF FF FF EB 69 8D 4D E4 E8 ?? ?? ?? ?? 50 8B 45 08 66 8B 08 51 E8 ?? ?? ?? ?? 83 C4 08 66 89 45 FC 8D 4D E4 E8 ?? ?? ?? ?? 50 8B 55 0C 66 8B 02 50 E8 ?? ?? ?? ?? 83 C4 08 66 89 45 F8 8B 4D 08 83 C1 02 89 4D 08 8B 55 0C 83 C2 02 89 55 0C 8B 45 10 83 E8 01 89 45 10 74 14 0F B7 4D FC 85 C9 74 0C 0F B7 55 FC 0F B7 45 F8 3B D0 74 97 0F B7 4D FC 0F B7 55 F8 2B CA 89 4D F4 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 F4 8B E5 5D C3 }
	condition:
		$1
}

rule file_16_4_0 {
	meta:
		name = "__wcsnicmp"
		size = 445
		refs = "0008 ___locale_changed 0037 ??_C@_1BM@CBACDFHA@?$AAf?$AAi?$AAr?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0040 ??_C@_1BG@ICJCOIKB@?$AAw?$AAc?$AAs?$AAn?$AAi?$AAc?$AAm?$AAp?$AA?4?$AAc?$AA?$AA@ 0047 __CrtDbgReportW 005b __errno 006f ??_C@_1BE@JKOKKFEL@?$AA_?$AAw?$AAc?$AAs?$AAn?$AAi?$AAc?$AAm?$AAp?$AA?$AA@ 0079 __invalid_parameter 009d ??_C@_1BK@LKBOPAFJ@?$AAl?$AAa?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 01b2 __wcsnicmp_l"
	strings:
		$1 = { 55 8B EC 83 EC 1C 83 3D ?? ?? ?? ?? 00 0F 85 90 01 00 00 C7 45 F4 00 00 00 00 83 7D 10 00 0F 84 78 01 00 00 33 C0 83 7D 08 00 0F 95 C0 89 45 F0 83 7D F0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 6D 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 6D 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF FF 7F E9 2F 01 00 00 33 D2 83 7D 0C 00 0F 95 C2 89 55 EC 83 7D EC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 6E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D EC 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 6E 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF FF 7F E9 C9 00 00 00 8B 4D 08 0F B7 11 83 FA 41 7C 19 8B 45 08 0F B7 08 83 F9 5A 7F 0E 8B 55 08 0F B7 02 83 C0 20 89 45 E8 EB 09 8B 4D 08 0F B7 11 89 55 E8 66 8B 45 E8 66 89 45 FC 8B 4D 0C 0F B7 11 83 FA 41 7C 19 8B 45 0C 0F B7 08 83 F9 5A 7F 0E 8B 55 0C 0F B7 02 83 C0 20 89 45 E4 EB 09 8B 4D 0C 0F B7 11 89 55 E4 66 8B 45 E4 66 89 45 F8 8B 4D 08 83 C1 02 89 4D 08 8B 55 0C 83 C2 02 89 55 0C 8B 45 10 83 E8 01 89 45 10 74 18 0F B7 4D FC 85 C9 74 10 0F B7 55 FC 0F B7 45 F8 3B D0 0F 84 61 FF FF FF 0F B7 4D FC 0F B7 55 F8 2B CA 89 4D F4 8B 45 F4 EB 18 EB 16 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_18_0_0 {
	meta:
		name = "__mbsrev_l"
		size = 489
		refs = "001b ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0032 ??_C@_1BO@JIBAMMGI@?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 003b ??_C@_1BC@CFNOHNJA@?$AAm?$AAb?$AAs?$AAr?$AAe?$AAv?$AA?4?$AAc?$AA?$AA@ 0042 __CrtDbgReportW 0056 __errno 006a ??_C@_1BE@HMKMJMHA@?$AA_?$AAm?$AAb?$AAs?$AAr?$AAe?$AAv?$AA_?$AAl?$AA?$AA@ 0074 __invalid_parameter 0086 ??1_LocaleUpdate@@QAE@XZ 0096 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 00a8 __strrev 013b ??_C@_1FE@OKOAGNBP@?$AA?$CI?$AA?$CC?$AAB?$AAa?$AAd?$AA?5?$AAM?$AAB?$AAC?$AAS?$AA?5?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AAp?$AAa?$AAs?$AAs?$AAe?$AAd?$AA?5?$AAi?$AAn?$AAt?$AAo?$AA?5?$AA_?$AAm@ 0161 ??_C@_1BK@NHCDBJID@?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?$DO?$AAs?$AAt?$AAa?$AAr?$AAt?$AA?$AA@"
	strings:
		$1 = { 55 8B EC 83 EC 2C 56 8B 45 08 89 45 F8 8B 4D 08 89 4D FC 8B 55 0C 52 8D 4D E4 E8 ?? ?? ?? ?? 33 C0 83 7D 08 00 0F 95 C0 89 45 E0 83 7D E0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 37 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 3D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 37 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 DC 00 00 00 00 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 DC E9 52 01 00 00 8D 4D E4 E8 ?? ?? ?? ?? 8B 50 04 83 7A 08 00 75 1F 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 D8 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 D8 E9 22 01 00 00 8B 4D 08 0F B6 11 85 D2 0F 84 C4 00 00 00 8B 45 08 0F B6 30 8D 4D E4 E8 ?? ?? ?? ?? 8B 48 04 0F B6 54 31 1D 83 E2 04 8B 45 08 83 C0 01 89 45 08 85 D2 0F 84 95 00 00 00 8B 4D 08 0F B6 11 85 D2 74 27 8B 45 08 8A 08 88 4D F7 8B 55 08 8B 45 08 8A 48 FF 88 0A 8B 55 08 8A 45 F7 88 42 FF 8B 4D 08 83 C1 01 89 4D 08 EB 64 E8 ?? ?? ?? ?? C7 00 16 00 00 00 33 D2 75 1E 68 ?? ?? ?? ?? 6A 00 6A 52 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 8B 4D 08 3B 4D F8 77 1E 68 ?? ?? ?? ?? 6A 00 6A 55 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 8B 45 08 83 E8 01 89 45 08 8B 4D 08 C6 01 00 EB 05 E9 2E FF FF FF 8B 55 08 83 EA 01 89 55 08 8B 45 FC 3B 45 08 73 2E 8B 4D FC 8A 11 88 55 F7 8B 45 FC 8B 4D 08 8A 11 88 10 8B 45 FC 83 C0 01 89 45 FC 8B 4D 08 8A 55 F7 88 11 8B 45 08 83 E8 01 89 45 08 EB CA 8B 4D F8 89 4D D4 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 D4 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_18_4_0 {
	meta:
		name = "__mbsrev"
		size = 19
		refs = "000a __mbsrev_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_107_5_0 {
	meta:
		name = "__cropzeros"
		size = 19
		refs = "000a __cropzeros_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_107_0_0 {
	meta:
		name = "__forcdecpt"
		size = 19
		refs = "000a __forcdecpt_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_475_24_0 {
	meta:
		name = "__ismbbkana"
		size = 19
		refs = "000a __ismbbkana_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_581_4_0 {
	meta:
		name = "__ismbcalnum"
		size = 19
		refs = "000a __ismbcalnum_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_62_4_0 {
	meta:
		name = "__ismbcalpha"
		size = 19
		refs = "000a __ismbcalpha_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_102_4_0 {
	meta:
		name = "__ismbcdigit"
		size = 19
		refs = "000a __ismbcdigit_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_926_4_0 {
	meta:
		name = "__ismbcgraph"
		size = 19
		refs = "000a __ismbcgraph_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_749_4_0 {
	meta:
		name = "__ismbchira"
		size = 19
		refs = "000a __ismbchira_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_749_6_0 {
	meta:
		name = "__ismbckata"
		size = 19
		refs = "000a __ismbckata_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_44_4_0 {
	meta:
		name = "__ismbcl0"
		size = 19
		refs = "000a __ismbcl0_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_44_6_0 {
	meta:
		name = "__ismbcl1"
		size = 19
		refs = "000a __ismbcl1_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_44_8_0 {
	meta:
		name = "__ismbcl2"
		size = 19
		refs = "000a __ismbcl2_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_395_4_0 {
	meta:
		name = "__ismbclegal"
		size = 19
		refs = "000a __ismbclegal_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_924_4_0 {
	meta:
		name = "__ismbclower"
		size = 19
		refs = "000a __ismbclower_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_303_4_0 {
	meta:
		name = "__ismbcprint"
		size = 19
		refs = "000a __ismbcprint_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_39_4_0 {
	meta:
		name = "__ismbcpunct"
		size = 19
		refs = "000a __ismbcpunct_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_326_4_0 {
	meta:
		name = "__ismbcspace"
		size = 19
		refs = "000a __ismbcspace_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_749_8_0 {
	meta:
		name = "__ismbcsymbol"
		size = 19
		refs = "000a __ismbcsymbol_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_593_4_0 {
	meta:
		name = "__ismbcupper"
		size = 19
		refs = "000a __ismbcupper_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_123_4_0 {
	meta:
		name = "__mbbtombc"
		size = 19
		refs = "000a __mbbtombc_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_84_4_0 {
	meta:
		name = "__mbcjistojms"
		size = 19
		refs = "000a __mbcjistojms_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_84_6_0 {
	meta:
		name = "__mbcjmstojis"
		size = 19
		refs = "000a __mbcjmstojis_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_60_1_0 {
	meta:
		name = "__mbctohira"
		size = 19
		refs = "000a __mbctohira_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_880_1_0 {
	meta:
		name = "__mbctokata"
		size = 19
		refs = "000a __mbctokata_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_420_4_0 {
	meta:
		name = "__mbctolower"
		size = 19
		refs = "000a __mbctolower_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_123_6_0 {
	meta:
		name = "__mbctombb"
		size = 19
		refs = "000a __mbctombb_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_32_4_0 {
	meta:
		name = "__mbctoupper"
		size = 19
		refs = "000a __mbctoupper_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_758_4_0 {
	meta:
		name = "__mbslen"
		size = 19
		refs = "000a __mbslen_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_264_4_0 {
	meta:
		name = "__mbsnextc"
		size = 19
		refs = "000a __mbsnextc_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_275_1_0 {
	meta:
		name = "__mkgmtime32"
		size = 19
		refs = "000a __make__time32_t"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_141_1_0 {
	meta:
		name = "__mkgmtime64"
		size = 19
		refs = "000a __make__time64_t"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_523_4_0 {
	meta:
		name = "__wtof"
		size = 19
		refs = "000a __wtof_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_823_4_0 {
	meta:
		name = "_atof"
		size = 19
		refs = "000a __atof_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_216_4_0 {
	meta:
		name = "_isleadbyte"
		size = 19
		refs = "000a __isleadbyte_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_19_0_0 {
	meta:
		name = "__mbscpy_s_l"
		size = 1232
		refs = "002f ??_C@_1FC@NCPEPIBI@?$AA?$CI?$AA?$CI?$AA_?$AAD?$AAs?$AAt?$AA?$CJ?$AA?$CJ?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?$CI?$AA_?$AAS?$AAi?$AAz?$AAe?$AAI?$AAn?$AAB?$AAy?$AAt@ 0038 ??_C@_1GK@EHLJOGJA@?$AAF?$AA?3?$AA?2?$AAR?$AAT?$AAM?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAS?$AAE?$AAL?$AAF?$AA_?$AAX?$AA8?$AA6?$AA?2@ 003f __CrtDbgReportW 0053 __errno 0067 ??_C@_1BI@DFEOJMJL@?$AA_?$AAm?$AAb?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA_?$AAl?$AA?$AA@ 0071 __invalid_parameter 00af ___crtDebugFillThreshold 00da _memset 00f4 ??_C@_1CG@OFBJMIGJ@?$AA?$CI?$AA?$CI?$AA?$CI?$AA_?$AAS?$AAr?$AAc?$AA?$CJ?$AA?$CJ?$AA?$CJ?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 014f ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0157 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0171 _strcpy_s 017f ??1_LocaleUpdate@@QAE@XZ 0210 __ismbblead_l 02b9 ??_C@_1CI@HCPHDDLE@?$AAB?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AAi?$AAs?$AA?5?$AAt?$AAo?$AAo?$AA?5?$AAs?$AAm?$AAa?$AAl?$AAl?$AA?$AA@ 02e2 ??_C@_1DM@MADKGDLO@?$AA?$CI?$AAL?$AA?$CC?$AAB?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AAi?$AAs?$AA?5?$AAt?$AAo?$AAo?$AA?5?$AAs?$AAm?$AAa?$AAl?$AAl?$AA?$CC?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA0?$AA?$CJ?$AA?$AA@"
	strings:
		$1 = { 55 8B EC 83 EC 6C 83 7D 08 00 74 0F 83 7D 0C 00 76 09 C7 45 A8 01 00 00 00 EB 07 C7 45 A8 00 00 00 00 8B 45 A8 89 45 E0 83 7D E0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 18 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 18 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 4A 04 00 00 83 7D 10 00 0F 85 BB 00 00 00 8B 55 08 C6 02 00 83 7D 0C FF 74 49 81 7D 0C FF FF FF 7F 74 40 83 7D 0C 01 76 3A 8B 45 0C 83 E8 01 39 05 ?? ?? ?? ?? 73 0B 8B 0D ?? ?? ?? ?? 89 4D A4 EB 09 8B 55 0C 83 EA 01 89 55 A4 8B 45 A4 50 68 FD 00 00 00 8B 4D 08 83 C1 01 51 E8 ?? ?? ?? ?? 83 C4 0C 33 D2 83 7D 10 00 0F 95 C2 89 55 DC 83 7D DC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 19 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D DC 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 19 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 85 03 00 00 8B 4D 14 51 8D 4D EC E8 ?? ?? ?? ?? 8D 4D EC E8 ?? ?? ?? ?? 8B 50 04 83 7A 08 00 75 27 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 89 45 BC 8D 4D EC E8 ?? ?? ?? ?? 8B 45 BC E9 41 03 00 00 8B 45 08 89 45 FC 8B 4D 0C 89 4D E8 8B 55 FC 8B 45 10 8A 08 88 0A 8B 55 FC 0F B6 02 8B 4D FC 83 C1 01 89 4D FC 8B 55 10 83 C2 01 89 55 10 85 C0 74 0D 8B 45 E8 83 E8 01 89 45 E8 74 02 EB CD 83 7D E8 00 0F 85 6E 01 00 00 8B 4D 10 0F B6 11 85 D2 0F 85 81 00 00 00 8B 45 08 89 45 D4 8B 4D FC 83 E9 01 89 4D D8 8B 55 D8 89 55 D0 8B 45 D0 3B 45 D4 72 27 8D 4D EC E8 ?? ?? ?? ?? 50 8B 4D D0 0F B6 11 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 0B 8B 45 D0 83 E8 01 89 45 D0 EB D1 8B 4D D8 2B 4D D0 83 E1 01 F7 D9 1B C9 F7 D9 89 4D E4 74 29 8B 55 FC C6 42 FF 00 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 C7 45 B8 2A 00 00 00 8D 4D EC E8 ?? ?? ?? ?? 8B 45 B8 E9 69 02 00 00 8B 45 08 C6 00 00 83 7D 0C FF 74 49 81 7D 0C FF FF FF 7F 74 40 83 7D 0C 01 76 3A 8B 4D 0C 83 E9 01 39 0D ?? ?? ?? ?? 73 0B 8B 15 ?? ?? ?? ?? 89 55 A0 EB 09 8B 45 0C 83 E8 01 89 45 A0 8B 4D A0 51 68 FD 00 00 00 8B 55 08 83 C2 01 52 E8 ?? ?? ?? ?? 83 C4 0C B8 ?? ?? ?? ?? 85 C0 74 0D 33 C9 74 09 C7 45 9C 01 00 00 00 EB 07 C7 45 9C 00 00 00 00 8B 55 9C 89 55 CC 83 7D CC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3A 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D CC 00 75 3D E8 ?? ?? ?? ?? C7 00 22 00 00 00 6A 00 6A 3A 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 B4 22 00 00 00 8D 4D EC E8 ?? ?? ?? ?? 8B 45 B4 E9 8A 01 00 00 8B 4D 08 89 4D C4 8B 55 FC 83 EA 02 89 55 C8 8B 45 C8 89 45 C0 8B 4D C0 3B 4D C4 72 27 8D 4D EC E8 ?? ?? ?? ?? 50 8B 55 C0 0F B6 02 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 0B 8B 4D C0 83 E9 01 89 4D C0 EB D1 8B 55 C8 2B 55 C0 83 E2 01 F7 DA 1B D2 F7 DA 89 55 E4 0F 84 AE 00 00 00 8B 45 FC 83 E8 02 3B 45 08 0F 82 9F 00 00 00 8B 4D FC C6 41 FE 00 8B 55 E8 83 C2 01 89 55 E8 83 7D 0C FF 74 67 81 7D 0C FF FF FF 7F 74 5E 8B 45 0C 2B 45 E8 83 C0 01 3B 45 0C 73 50 8B 4D 0C 2B 4D E8 83 C1 01 8B 55 0C 2B D1 39 15 ?? ?? ?? ?? 73 0A A1 ?? ?? ?? ?? 89 45 98 EB 11 8B 4D 0C 2B 4D E8 83 C1 01 8B 55 0C 2B D1 89 55 98 8B 45 98 50 68 FD 00 00 00 8B 4D 0C 2B 4D E8 8B 55 08 8D 44 0A 01 50 E8 ?? ?? ?? ?? 83 C4 0C E8 ?? ?? ?? ?? C7 00 2A 00 00 00 C7 45 B0 2A 00 00 00 8D 4D EC E8 ?? ?? ?? ?? 8B 45 B0 E9 80 00 00 00 83 7D 0C FF 74 68 81 7D 0C FF FF FF 7F 74 5F 8B 4D 0C 2B 4D E8 83 C1 01 3B 4D 0C 73 51 8B 55 0C 2B 55 E8 83 C2 01 8B 45 0C 2B C2 39 05 ?? ?? ?? ?? 73 0B 8B 0D ?? ?? ?? ?? 89 4D 94 EB 11 8B 55 0C 2B 55 E8 83 C2 01 8B 45 0C 2B C2 89 45 94 8B 4D 94 51 68 FD 00 00 00 8B 55 0C 2B 55 E8 8B 45 08 8D 4C 10 01 51 E8 ?? ?? ?? ?? 83 C4 0C C7 45 AC 00 00 00 00 8D 4D EC E8 ?? ?? ?? ?? 8B 45 AC 8B E5 5D C3 }
	condition:
		$1
}

rule file_20_0_0 {
	meta:
		name = "_fgetws"
		size = 568
		refs = "0006 __sehtable$_fgetws 000b __except_handler4 001d ___security_cookie 0065 ??_C@_1EK@KICPAPCG@?$AA?$CI?$AA?5?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CJ?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AA?$CI?$AA?5?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DN?$AA?$DN@ 006e ??_C@_1GA@BLLPJGHH@?$AAf?$AA?3?$AA?2?$AAr?$AAt?$AAm?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2@ 0075 __CrtDbgReportW 0089 __errno 009d ??_C@_1O@HGOIKFHF@?$AAf?$AAg?$AAe?$AAt?$AAw?$AAs?$AA?$AA@ 00a7 __invalid_parameter 00c8 ??_C@_1BO@CLMMCNLO@?$AA?$CI?$AA?5?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CJ?$AA?$AA@ 012b ??_C@_1CA@EHPEFHFN@?$AA?$CI?$AA?5?$AAs?$AAt?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CJ?$AA?$AA@ 0193 __lock_file 01b7 __fgetwc_nolock 021b __unlock_file"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 D8 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 8B 45 08 89 45 DC 8B 4D 08 89 4D E0 83 7D 08 00 75 0F 83 7D 0C 00 74 09 C7 45 C8 00 00 00 00 EB 07 C7 45 C8 01 00 00 00 8B 55 C8 89 55 D4 83 7D D4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 37 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D4 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 37 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 71 01 00 00 33 C9 83 7D 0C 00 0F 9D C1 89 4D D0 83 7D D0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 38 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D0 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 38 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 0E 01 00 00 33 C0 83 7D 10 00 0F 95 C0 89 45 CC 83 7D CC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 39 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D CC 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 39 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 AB 00 00 00 83 7D 0C 00 75 07 33 C0 E9 9E 00 00 00 8B 55 10 89 55 E4 8B 45 E4 50 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 83 7D E0 00 74 61 8B 4D 0C 83 E9 01 89 4D 0C 74 4E 8B 55 E4 52 E8 ?? ?? ?? ?? 83 C4 04 0F B7 C0 89 45 D8 81 7D D8 FF FF 00 00 75 13 8B 4D DC 3B 4D 08 75 09 C7 45 E0 00 00 00 00 EB 2A EB 20 8B 55 DC 66 8B 45 D8 66 89 02 0F B7 4D D8 8B 55 DC 83 C2 02 89 55 DC 83 F9 0A 75 02 EB 02 EB A7 8B 45 DC 66 C7 00 00 00 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0D 8B 4D E4 51 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 E0 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_21_0_0 {
	meta:
		name = "?_set_new_mode@@YAHH@Z"
		size = 149
		refs = "002f ??_C@_1CK@CFODHCOD@?$AAn?$AAh?$AAm?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AAn?$AAh?$AAm?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA1?$AA?$AA@ 0038 ??_C@_1BK@IPDKOILI@?$AAn?$AAe?$AAw?$AA_?$AAm?$AAo?$AAd?$AAe?$AA?4?$AAc?$AAp?$AAp?$AA?$AA@ 003f __CrtDbgReportW 0053 __errno 0067 ??_C@_1BM@PDPAKJNF@?$AA_?$AAs?$AAe?$AAt?$AA_?$AAn?$AAe?$AAw?$AA_?$AAm?$AAo?$AAd?$AAe?$AA?$AA@ 0071 __invalid_parameter 007f __newmode"
	strings:
		$1 = { 55 8B EC 83 EC 0C 83 7D 08 00 74 0F 83 7D 08 01 74 09 C7 45 F4 00 00 00 00 EB 07 C7 45 F4 01 00 00 00 8B 45 F4 89 45 F8 83 7D F8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 17 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F8 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 17 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 14 8B 15 ?? ?? ?? ?? 89 55 FC 8B 45 08 A3 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_23_1_0 {
	meta:
		name = "___initstdio"
		size = 330
		refs = "0006 __nstream 0032 ??_C@_07PNHPCIEC@_file?4c?$AA@ 0041 __calloc_dbg 0049 ___piob 00b4 __iob 00f0 ___pioinfo"
	strings:
		$1 = { 55 8B EC 51 83 3D ?? ?? ?? ?? 00 75 0C C7 05 ?? ?? ?? ?? 00 02 00 00 EB 13 83 3D ?? ?? ?? ?? 14 7D 0A C7 05 ?? ?? ?? ?? 14 00 00 00 68 85 00 00 00 68 ?? ?? ?? ?? 6A 02 6A 04 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 14 A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 75 3F C7 05 ?? ?? ?? ?? 14 00 00 00 68 88 00 00 00 68 ?? ?? ?? ?? 6A 02 6A 04 8B 0D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 14 A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 75 0A B8 1A 00 00 00 E9 B1 00 00 00 C7 45 FC 00 00 00 00 EB 09 8B 55 FC 83 C2 01 89 55 FC 83 7D FC 14 7D 19 8B 45 FC C1 E0 05 05 ?? ?? ?? ?? 8B 4D FC 8B 15 ?? ?? ?? ?? 89 04 8A EB D8 C7 45 FC 00 00 00 00 EB 09 8B 45 FC 83 C0 01 89 45 FC 83 7D FC 03 7D 66 8B 4D FC C1 F9 05 8B 55 FC 83 E2 1F 6B D2 28 8B 04 8D ?? ?? ?? ?? 83 3C 02 FF 74 38 8B 4D FC C1 F9 05 8B 55 FC 83 E2 1F 6B D2 28 8B 04 8D ?? ?? ?? ?? 83 3C 02 FE 74 1C 8B 4D FC C1 F9 05 8B 55 FC 83 E2 1F 6B D2 28 8B 04 8D ?? ?? ?? ?? 83 3C 02 00 75 10 8B 4D FC C1 E1 05 C7 81 ?? ?? ?? ?? FE FF FF FF EB 8B 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_23_2_0 {
	meta:
		name = "___endstdio"
		size = 43
		refs = "0004 __flushall 000b __exitflag 0014 __fcloseall 001c ___piob 0022 __free_dbg"
	strings:
		$1 = { 55 8B EC E8 ?? ?? ?? ?? 0F BE 05 ?? ?? ?? ?? 85 C0 74 05 E8 ?? ?? ?? ?? 6A 02 8B 0D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_23_3_0 {
	meta:
		name = "__lock_file"
		size = 61
		refs = "0006 __iob 0025 __lock 0037 __imp__EnterCriticalSection@4"
	strings:
		$1 = { 55 8B EC 81 7D 08 ?? ?? ?? ?? 72 22 81 7D 08 ?? ?? ?? ?? 77 19 8B 45 08 2D ?? ?? ?? ?? C1 F8 05 83 C0 10 50 E8 ?? ?? ?? ?? 83 C4 04 EB 0D 8B 4D 08 83 C1 20 51 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_23_5_0 {
	meta:
		name = "__unlock_file"
		size = 61
		refs = "0006 __iob 0025 __unlock 0037 __imp__LeaveCriticalSection@4"
	strings:
		$1 = { 55 8B EC 81 7D 08 ?? ?? ?? ?? 72 22 81 7D 08 ?? ?? ?? ?? 77 19 8B 45 08 2D ?? ?? ?? ?? C1 F8 05 83 C0 10 50 E8 ?? ?? ?? ?? 83 C4 04 EB 0D 8B 4D 08 83 C1 20 51 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_23_4_0 {
	meta:
		name = "__lock_file2"
		size = 41
		refs = "0011 __lock 0023 __imp__EnterCriticalSection@4"
	strings:
		$1 = { 55 8B EC 83 7D 08 14 7D 11 8B 45 08 83 C0 10 50 E8 ?? ?? ?? ?? 83 C4 04 EB 0D 8B 4D 0C 83 C1 20 51 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_23_6_0 {
	meta:
		name = "__unlock_file2"
		size = 41
		refs = "0011 __unlock 0023 __imp__LeaveCriticalSection@4"
	strings:
		$1 = { 55 8B EC 83 7D 08 14 7D 11 8B 45 08 83 C0 10 50 E8 ?? ?? ?? ?? 83 C4 04 EB 0D 8B 4D 0C 83 C1 20 51 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_24_0_0 {
	meta:
		name = "___libm_sse2_cosf"
		size = 343
		refs = "001b _PI_32_RECIP 0027 _BIT_31 003b _SHIFTER 0066 _P_1 0072 _P_2 0078 _Ctable 009e _C_1 00a6 _S_1 00b6 _C_2 00be _S_2 00ca _ONE 0141 _cos"
	strings:
		$1 = { 66 0F C5 C0 01 66 25 FF 7F 66 2D 80 00 66 3D 7F 45 0F 87 E9 00 00 00 F2 0F 10 0D ?? ?? ?? ?? F3 0F 59 C8 66 0F 28 1D ?? ?? ?? ?? F3 0F 2D D1 66 0F 54 D8 F3 0F 5A C0 F3 0F 58 0D ?? ?? ?? ?? F3 0F 5C 0D ?? ?? ?? ?? 66 0F 28 E3 66 0F 73 F3 20 66 0F 73 F4 1D 66 0F 57 DC 81 C2 10 76 1C 00 83 E2 3F F2 0F 10 15 ?? ?? ?? ?? 66 0F 57 D3 66 0F 57 1D ?? ?? ?? ?? 8D 05 ?? ?? ?? ?? C1 E2 04 03 C2 66 0F 73 F1 1D F2 0F 59 D1 F2 0F 59 D9 F2 0F 5C C2 F2 0F 58 D8 F2 0F 59 C0 F2 0F 10 25 ?? ?? ?? ?? F2 0F 10 2D ?? ?? ?? ?? F2 0F 59 E0 F2 0F 59 E8 F2 0F 10 35 ?? ?? ?? ?? F2 0F 10 3D ?? ?? ?? ?? F2 0F 59 C0 F2 0F 58 25 ?? ?? ?? ?? F2 0F 59 F0 F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 F8 F2 0F 58 E6 F2 0F 58 EF F2 0F 10 10 F2 0F 59 58 08 F2 0F 59 D4 F2 0F 59 DD F2 0F 58 D3 F2 0F 5A C2 C3 7F 19 F3 0F 5A C0 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 C0 F2 0F 5C C8 F2 0F 5A C1 C3 66 0F 7E C0 25 00 00 80 7F 3D 00 00 80 7F 74 27 8B C4 83 EC 20 83 E4 F0 89 44 24 08 F3 0F 5A C0 66 0F D6 04 24 E8 ?? ?? ?? ?? D9 1C 24 F3 0F 10 04 24 8B 64 24 08 C3 F3 0F 5C C0 C3 }
	condition:
		$1
}

rule file_25_1_0 {
	meta:
		name = "_rand_s"
		size = 538
		refs = "0008 _g_pfnRtlGenRandom 000e __decode_pointer 002b ??_C@_1CK@GFDNDKK@?$AA_?$AAR?$AAa?$AAn?$AAd?$AAo?$AAm?$AAV?$AAa?$AAl?$AAu?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0034 ??_C@_1BC@NBJGCJKM@?$AAr?$AAa?$AAn?$AAd?$AA_?$AAs?$AA?4?$AAc?$AA?$AA@ 003b __CrtDbgReportW 004f __errno 0063 ??_C@_1O@IJGPPOGF@?$AAr?$AAa?$AAn?$AAd?$AA_?$AAs?$AA?$AA@ 006d __invalid_parameter 0092 ??_C@_0N@JJPEKNFO@ADVAPI32?4DLL?$AA@ 0098 __imp__LoadLibraryA@4 00c6 ??_C@_1GA@EBEDGGGB@?$AA?$CI?$AA?$CC?$AAr?$AAa?$AAn?$AAd?$AA_?$AAs?$AA?5?$AAi?$AAs?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAa?$AAv?$AAa?$AAi?$AAl?$AAa?$AAb?$AAl?$AAe?$AA?5?$AAo?$AAn?$AA?5?$AAt?$AAh?$AAi@ 011a ??_C@_0BC@JEAENNKH@SystemFunction036?$AA@ 0124 __imp__GetProcAddress@8 017b __imp__GetLastError@0 0181 __get_errno_from_oserr 01c2 __encode_pointer 01cd __encoded_null 01df __imp__InterlockedExchange@8 01ee __imp__FreeLibrary@4"
	strings:
		$1 = { 55 8B EC 83 EC 24 56 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 33 C9 83 7D 08 00 0F 95 C1 89 4D F8 83 7D F8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 44 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F8 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 44 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 97 01 00 00 8B 45 08 C7 00 00 00 00 00 83 7D FC 00 0F 85 61 01 00 00 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 89 45 EC 83 7D EC 00 75 74 33 C9 74 09 C7 45 E0 01 00 00 00 EB 07 C7 45 E0 00 00 00 00 8B 55 E0 89 55 E8 83 7D E8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 50 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E8 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 50 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 FC 00 00 00 68 ?? ?? ?? ?? 8B 4D EC 51 FF 15 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 0F 85 88 00 00 00 33 D2 74 09 C7 45 DC 01 00 00 00 EB 07 C7 45 DC 00 00 00 00 8B 45 DC 89 45 E4 83 7D E4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 56 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E4 00 75 44 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 8B F0 E8 ?? ?? ?? ?? 89 30 6A 00 6A 56 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 EB 58 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 F4 E8 ?? ?? ?? ?? 89 45 F0 8B 45 F4 50 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 3B 45 F0 74 0A 8B 4D EC 51 FF 15 ?? ?? ?? ?? 6A 04 8B 55 08 52 FF 55 FC 85 C0 75 14 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E8 ?? ?? ?? ?? 8B 00 EB 02 33 C0 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_26_0_0 {
	meta:
		name = "??_V@YAXPAX@Z"
		size = 17
		refs = "0008 ??3@YAXPAX@Z"
		altNames = "??3@YAXPAXABUnothrow_t@std@@@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_14_177_1 {
	meta:
		name = "??3facet@locale@std@@SAXPAX@Z"
		size = 17
		refs = "0008 ??$_DebugHeapDelete@Vfacet@locale@std@@@std@@YAXPAVfacet@locale@0@@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_45_181_1 {
	meta:
		name = "??3facet@locale@std@@SAXPAXABU_DebugHeapTag_t@2@PADH@Z"
		size = 17
		refs = "0008 ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_55_0_1 {
	meta:
		name = "??_U@YAPAXI@Z"
		size = 17
		refs = "0008 ??2@YAPAXI@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_1159_0_4 {
	meta:
		name = "??_V@YAXPAXABUnothrow_t@std@@@Z"
		size = 17
		refs = "0008 ??_V@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_25_56_1 {
	meta:
		name = "?length@?$char_traits@D@std@@SAIPBD@Z"
		size = 17
		refs = "0008 _strlen"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_47_1505_1 {
	meta:
		name = "?length@?$char_traits@G@std@@SAIPBG@Z"
		size = 17
		refs = "0008 _wcslen"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_47_1445_1 {
	meta:
		name = "?length@?$char_traits@_W@std@@SAIPB_W@Z"
		size = 17
		refs = "0008 _wcslen"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_5_0_1 {
	meta:
		name = "__LDtest"
		size = 17
		refs = "0008 __Dtest"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_311_10_0 {
	meta:
		name = "___free_locale"
		size = 17
		refs = "0008 __free_locale"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_417_59_0 {
	meta:
		name = "__aligned_free"
		size = 17
		refs = "0008 __aligned_free_dbg"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_278_2_0 {
	meta:
		name = "__ftime32"
		size = 17
		refs = "0008 __ftime32_s"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_110_2_0 {
	meta:
		name = "__ftime64"
		size = 17
		refs = "0008 __ftime64_s"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_862_8_0 {
	meta:
		name = "__inc"
		size = 17
		refs = "0008 __fgetwc_nolock"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_86_1_0 {
	meta:
		name = "__unlink"
		size = 17
		refs = "0008 _remove"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_209_2_0 {
	meta:
		name = "__wtoi"
		size = 17
		refs = "0008 __wtol"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_881_1_0 {
	meta:
		name = "__wunlink"
		size = 17
		refs = "0008 __wremove"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_482_2_0 {
	meta:
		name = "_atoi"
		size = 17
		refs = "0008 _atol"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_382_1_0 {
	meta:
		name = "_clearerr"
		size = 17
		refs = "0008 _clearerr_s"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_554_2_0 {
	meta:
		name = "_getwc"
		size = 17
		refs = "0008 _fgetwc"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_876_1_0 {
	meta:
		name = "_putchar"
		size = 17
		refs = "0008 __fputchar"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_28_0_0 {
	meta:
		name = "___wcsncnt"
		size = 68
		altNames = "?wcsncnt@@YAHPB_WH@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 8B 45 0C 89 45 F8 8B 4D 08 89 4D FC 8B 55 F8 8B 45 F8 83 E8 01 89 45 F8 85 D2 74 15 8B 4D FC 0F B7 11 85 D2 74 0B 8B 45 FC 83 C0 02 89 45 FC EB DB 8B 45 0C 2B 45 F8 83 E8 01 8B E5 5D C3 }
	condition:
		$1
}

rule file_29_0_0 {
	meta:
		name = "__mbsnset_s_l"
		size = 1411
		refs = "0056 ??_C@_1FC@NCPEPIBI@?$AA?$CI?$AA?$CI?$AA_?$AAD?$AAs?$AAt?$AA?$CJ?$AA?$CJ?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?$CI?$AA_?$AAS?$AAi?$AAz?$AAe?$AAI?$AAn?$AAB?$AAy?$AAt@ 005f ??_C@_1GM@BFCLCNFB@?$AAF?$AA?3?$AA?2?$AAR?$AAT?$AAM?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAS?$AAE?$AAL?$AAF?$AA_?$AAX?$AA8?$AA6?$AA?2@ 0066 __CrtDbgReportW 007a __errno 008e ??_C@_1BK@JMCNLJKB@?$AA_?$AAm?$AAb?$AAs?$AAn?$AAs?$AAe?$AAt?$AA_?$AAs?$AA_?$AAl?$AA?$AA@ 0098 __invalid_parameter 00b1 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 00b9 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 00d7 __strnset_s 00e5 ??1_LocaleUpdate@@QAE@XZ 0131 __ismbblead_l 0185 ___crtDebugFillThreshold 01b0 _memset 01da __CrtGetCheckCount 01eb ??_C@_1CI@HCPHDDLE@?$AAB?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AAi?$AAs?$AA?5?$AAt?$AAo?$AAo?$AA?5?$AAs?$AAm?$AAa?$AAl?$AAl?$AA?$AA@ 043f ??_C@_1DM@FHLMIEG@?$AAS?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AAi?$AAs?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAn?$AAu?$AAl?$AAl?$AA?5?$AAt?$AAe?$AAr?$AAm?$AAi?$AAn?$AAa?$AAt?$AAe?$AAd?$AA?$AA@ 0468 ??_C@_1FA@MJKDNFFB@?$AA?$CI?$AAL?$AA?$CC?$AAS?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AAi?$AAs?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAn?$AAu?$AAl?$AAl?$AA?5?$AAt?$AAe?$AAr?$AAm?$AAi?$AAn?$AAa?$AAt?$AAe?$AAd@"
	strings:
		$1 = { 55 8B EC 83 EC 64 C7 45 DC 00 00 00 00 C7 45 F4 00 00 00 00 83 7D 14 00 75 13 83 7D 08 00 75 0D 83 7D 0C 00 75 07 33 C0 E9 52 05 00 00 83 7D 08 00 74 0F 83 7D 0C 00 76 09 C7 45 B8 01 00 00 00 EB 07 C7 45 B8 00 00 00 00 8B 45 B8 89 45 D4 83 7D D4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 1E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D4 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 1E 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 D6 04 00 00 8B 55 18 52 8D 4D E0 E8 ?? ?? ?? ?? 8D 4D E0 E8 ?? ?? ?? ?? 8B 40 04 83 78 08 00 75 2B 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 CC 8D 4D E0 E8 ?? ?? ?? ?? 8B 45 CC E9 8E 04 00 00 8B 55 08 89 55 F8 8B 45 0C 89 45 D8 8B 4D 10 C1 E9 08 88 4D FF 8B 55 10 81 E2 FF 00 00 00 88 55 F3 0F B6 45 FF 85 C0 74 22 0F B6 4D F3 85 C9 74 40 8D 4D E0 E8 ?? ?? ?? ?? 50 0F B6 55 FF 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 26 0F B6 45 FF 85 C0 0F 85 91 00 00 00 8D 4D E0 E8 ?? ?? ?? ?? 50 0F B6 4D F3 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 77 8B 55 08 C6 02 00 83 7D 0C FF 74 49 81 7D 0C FF FF FF 7F 74 40 83 7D 0C 01 76 3A 8B 45 0C 83 E8 01 39 05 ?? ?? ?? ?? 73 0B 8B 0D ?? ?? ?? ?? 89 4D B4 EB 09 8B 55 0C 83 EA 01 89 55 B4 8B 45 B4 50 68 FD 00 00 00 8B 4D 08 83 C1 01 51 E8 ?? ?? ?? ?? 83 C4 0C E8 ?? ?? ?? ?? C7 00 2A 00 00 00 C7 45 C8 2A 00 00 00 8D 4D E0 E8 ?? ?? ?? ?? 8B 45 C8 E9 A6 03 00 00 E8 ?? ?? ?? ?? 85 C0 74 26 8B 55 14 3B 55 0C 72 1E 68 ?? ?? ?? ?? 6A 00 6A 35 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 0F B6 4D FF 85 C9 0F 84 EC 00 00 00 8B 55 F8 0F B6 02 85 C0 0F 84 DC 00 00 00 83 7D 14 00 0F 86 D2 00 00 00 8B 4D D8 83 E9 01 89 4D D8 0F 84 C3 00 00 00 8B 55 F8 0F B6 42 01 85 C0 75 1B 8B 4D F8 C6 01 00 8B 55 D8 83 C2 01 89 55 D8 C7 45 DC 01 00 00 00 E9 9D 00 00 00 83 7D F4 00 74 09 C7 45 B0 00 00 00 00 EB 1B 8D 4D E0 E8 ?? ?? ?? ?? 50 8B 45 F8 0F B6 08 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 B0 8B 55 B0 89 55 F4 8B 45 F8 8A 4D FF 88 08 8B 55 F8 83 C2 01 89 55 F8 8B 45 D8 83 E8 01 89 45 D8 75 02 EB 4F 83 7D F4 00 74 09 C7 45 AC 00 00 00 00 EB 1B 8D 4D E0 E8 ?? ?? ?? ?? 50 8B 4D F8 0F B6 11 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 AC 8B 45 AC 89 45 F4 8B 4D F8 8A 55 F3 88 11 8B 45 F8 83 C0 01 89 45 F8 8B 4D 14 83 E9 01 89 4D 14 E9 16 FF FF FF EB 67 8B 55 F8 0F B6 02 85 C0 74 5D 83 7D 14 00 76 57 8B 4D D8 83 E9 01 89 4D D8 74 4C 83 7D F4 00 74 09 C7 45 A8 00 00 00 00 EB 1B 8D 4D E0 E8 ?? ?? ?? ?? 50 8B 55 F8 0F B6 02 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 A8 8B 4D A8 89 4D F4 8B 55 F8 8A 45 F3 88 02 8B 4D F8 83 C1 01 89 4D F8 8B 55 14 83 EA 01 89 55 14 EB 99 83 7D 14 00 75 4D 83 7D F4 00 74 47 8B 45 F8 0F B6 08 85 C9 74 3D 8B 55 D8 83 EA 01 89 55 D8 74 32 C7 45 DC 01 00 00 00 8B 45 F8 0F B6 48 01 85 C9 75 11 8B 55 F8 C6 02 00 8B 45 D8 83 C0 01 89 45 D8 EB 0F 8B 4D F8 C6 01 20 8B 55 F8 83 C2 01 89 55 F8 83 7D 14 00 75 20 8B 45 F8 0F B6 08 85 C9 74 16 8B 55 D8 83 EA 01 89 55 D8 74 0B 8B 45 F8 83 C0 01 89 45 F8 EB E0 83 7D D8 00 0F 85 E4 00 00 00 8B 4D 08 C6 01 00 83 7D 0C FF 74 48 81 7D 0C FF FF FF 7F 74 3F 83 7D 0C 01 76 39 8B 55 0C 83 EA 01 39 15 ?? ?? ?? ?? 73 0A A1 ?? ?? ?? ?? 89 45 A4 EB 09 8B 4D 0C 83 E9 01 89 4D A4 8B 55 A4 52 68 FD 00 00 00 8B 45 08 83 C0 01 50 E8 ?? ?? ?? ?? 83 C4 0C B9 ?? ?? ?? ?? 85 C9 74 0D 33 D2 74 09 C7 45 A0 01 00 00 00 EB 07 C7 45 A0 00 00 00 00 8B 45 A0 89 45 D0 83 7D D0 00 75 21 68 ?? ?? ?? ?? 6A 00 68 81 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D0 00 75 40 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 81 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 C4 16 00 00 00 8D 4D E0 E8 ?? ?? ?? ?? 8B 45 C4 E9 B1 00 00 00 83 7D 0C FF 74 68 81 7D 0C FF FF FF 7F 74 5F 8B 55 0C 2B 55 D8 83 C2 01 3B 55 0C 73 51 8B 45 0C 2B 45 D8 83 C0 01 8B 4D 0C 2B C8 39 0D ?? ?? ?? ?? 73 0B 8B 15 ?? ?? ?? ?? 89 55 9C EB 11 8B 45 0C 2B 45 D8 83 C0 01 8B 4D 0C 2B C8 89 4D 9C 8B 55 9C 52 68 FD 00 00 00 8B 45 0C 2B 45 D8 8B 4D 08 8D 54 01 01 52 E8 ?? ?? ?? ?? 83 C4 0C 83 7D DC 00 74 21 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 C7 45 C0 2A 00 00 00 8D 4D E0 E8 ?? ?? ?? ?? 8B 45 C0 EB 1E EB 14 C7 45 BC 00 00 00 00 8D 4D E0 E8 ?? ?? ?? ?? 8B 45 BC EB 08 8D 4D E0 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_30_0_0 {
	meta:
		name = "__execlp"
		size = 418
		refs = "0019 ??_C@_1CC@JBMDNKJP@?$AAf?$AAi?$AAl?$AAe?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0022 ??_C@_1BC@BDKMKDCK@?$AAe?$AAx?$AAe?$AAc?$AAl?$AAp?$AA?4?$AAc?$AA?$AA@ 0029 __CrtDbgReportW 003d __errno 0051 ??_C@_1BA@CGMAKGL@?$AA_?$AAe?$AAx?$AAe?$AAc?$AAl?$AAp?$AA?$AA@ 005b __invalid_parameter 007c ??_C@_1CM@DMCMCPME@?$AA?$CK?$AAf?$AAi?$AAl?$AAe?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 00e0 ??_C@_1CA@MOAFCHEI@?$AAa?$AAr?$AAg?$AAl?$AAi?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0140 ??_C@_1CK@PKCLGCC@?$AA?$CK?$AAa?$AAr?$AAg?$AAl?$AAi?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 0197 __execvp"
	strings:
		$1 = { 55 8B EC 83 EC 10 33 C0 83 7D 08 00 0F 95 C0 89 45 FC 83 7D FC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 32 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D FC 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 32 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 34 01 00 00 8B 55 08 0F BE 02 F7 D8 1B C0 F7 D8 89 45 F8 75 1E 68 ?? ?? ?? ?? 6A 00 6A 33 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F8 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 33 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 D1 00 00 00 33 D2 83 7D 0C 00 0F 95 C2 89 55 F4 83 7D F4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 34 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F4 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 34 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 70 8B 4D 0C 0F BE 11 F7 DA 1B D2 F7 DA 89 55 F0 75 1E 68 ?? ?? ?? ?? 6A 00 6A 35 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 35 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 10 8D 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_31_0_0 {
	meta:
		name = "_fread_s"
		size = 519
		refs = "0006 __sehtable$_fread_s 000b __except_handler4 001d ___security_cookie 005d ??_C@_1CC@CGFEEBMC@?$AA?$CI?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0066 ??_C@_1BA@LMNFMBJN@?$AAf?$AAr?$AAe?$AAa?$AAd?$AA?4?$AAc?$AA?$AA@ 006d __CrtDbgReportW 0081 __errno 0095 ??_C@_1BA@CMLCEIGG@?$AAf?$AAr?$AAe?$AAa?$AAd?$AA_?$AAs?$AA?$AA@ 009f __invalid_parameter 00d8 _memset 00f2 ??_C@_1CC@FADMNIL@?$AA?$CI?$AAs?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0158 ??_C@_1EE@KGELKDPM@?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AA?$CI?$AAS?$AAI?$AAZ?$AAE?$AA_?$AAM?$AAA?$AAX?$AA?5?$AA?1?$AA?5?$AAe?$AAl?$AAe?$AAm?$AAe?$AAn?$AAt?$AAS?$AAi?$AAz?$AAe@ 01aa __lock_file 01cd __fread_nolock_s 01ea __unlock_file"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 E8 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 C7 45 E4 00 00 00 00 83 7D 10 00 74 06 83 7D 14 00 75 07 33 C0 E9 AB 01 00 00 33 C0 83 7D 08 00 0F 95 C0 89 45 E0 83 7D E0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 5D 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 5D 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 48 01 00 00 83 7D 18 00 74 11 83 C8 FF 33 D2 F7 75 10 39 45 14 0F 86 E1 00 00 00 83 7D 0C FF 74 15 8B 55 0C 52 68 FD 00 00 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 33 C9 83 7D 18 00 0F 95 C1 89 4D DC 83 7D DC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 65 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D DC 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 65 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 B3 00 00 00 83 C8 FF 33 D2 F7 75 10 3B 45 14 1B C0 83 C0 01 89 45 D8 75 1E 68 ?? ?? ?? ?? 6A 00 6A 66 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D8 00 75 2A E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 66 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 50 8B 55 18 52 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 45 18 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 14 89 45 E4 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0D 8B 55 18 52 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 E4 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_31_1_0 {
	meta:
		name = "__fread_nolock_s"
		size = 1077
		refs = "0090 ??_C@_1LG@DCNDJCHK@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAc?$AAo?$AAn?$AAs?$AAi?$AAs?$AAt?$AAe?$AAn?$AAt?$AA?5?$AAS?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?5?$AAC?$AAo?$AAu?$AAn?$AAt?$AA?4?$AA?5?$AAF?$AAl?$AAu@ 009c ??_C@_1BA@LMNFMBJN@?$AAf?$AAr?$AAe?$AAa?$AAd?$AA?4?$AAc?$AA?$AA@ 00a3 __CrtDbgReportW 0111 _memset 0139 ??_C@_1DA@DKEFLDMG@?$AA?$CI?$AA?$CC?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AAt?$AAo?$AAo?$AA?5?$AAs?$AAm?$AAa?$AAl?$AAl?$AA?$CC?$AA?0?$AA?5?$AA0?$AA?$CJ?$AA?$AA@ 0160 __errno 0177 ??_C@_1CA@IDPOGFL@?$AA_?$AAf?$AAr?$AAe?$AAa?$AAd?$AA_?$AAn?$AAo?$AAl?$AAo?$AAc?$AAk?$AA_?$AAs?$AA?$AA@ 0181 __invalid_parameter 01a2 _memcpy_s 02c0 __fileno 02c9 __read 0344 __filbuf"
	strings:
		$1 = { 55 8B EC 83 EC 40 8B 45 08 89 45 E4 8B 4D 0C 89 4D F0 83 7D 10 00 74 06 83 7D 14 00 75 07 33 C0 E9 0C 04 00 00 8B 55 10 0F AF 55 14 89 55 F4 8B 45 F4 89 45 FC 8B 4D 18 8B 51 0C 81 E2 0C 01 00 00 74 0B 8B 45 18 8B 48 18 89 4D F8 EB 07 C7 45 F8 00 10 00 00 83 7D FC 00 0F 84 CF 03 00 00 8B 55 18 8B 42 0C 25 0C 01 00 00 0F 84 75 01 00 00 8B 4D 18 83 79 04 00 0F 84 68 01 00 00 8B 55 18 83 7A 04 00 7D 49 8B 45 18 83 78 04 00 7D 21 68 ?? ?? ?? ?? 6A 00 68 A8 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 8B 55 18 8B 42 0C 83 C8 20 8B 4D 18 89 41 0C 8B 45 F4 2B 45 FC 33 D2 F7 75 10 E9 62 03 00 00 8B 55 18 8B 45 FC 3B 42 04 73 08 8B 4D FC 89 4D D0 EB 09 8B 55 18 8B 42 04 89 45 D0 8B 4D D0 89 4D E8 8B 55 E8 3B 55 F0 0F 86 92 00 00 00 83 7D 0C FF 74 15 8B 45 0C 50 68 FD 00 00 00 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 33 D2 74 09 C7 45 CC 01 00 00 00 EB 07 C7 45 CC 00 00 00 00 8B 45 CC 89 45 DC 83 7D DC 00 75 21 68 ?? ?? ?? ?? 6A 00 68 B5 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D DC 00 75 30 E8 ?? ?? ?? ?? C7 00 22 00 00 00 6A 00 68 B5 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 A2 02 00 00 8B 55 E8 52 8B 45 18 8B 08 51 8B 55 F0 52 8B 45 E4 50 E8 ?? ?? ?? ?? 83 C4 10 8B 4D FC 2B 4D E8 89 4D FC 8B 55 18 8B 42 04 2B 45 E8 8B 4D 18 89 41 04 8B 55 18 8B 02 03 45 E8 8B 4D 18 89 01 8B 55 E4 03 55 E8 89 55 E4 8B 45 F0 2B 45 E8 89 45 F0 E9 44 02 00 00 8B 4D FC 3B 4D F8 0F 82 4E 01 00 00 83 7D F8 00 74 12 8B 45 FC 33 D2 F7 75 F8 8B 45 FC 2B C2 89 45 C8 EB 06 8B 4D FC 89 4D C8 8B 55 C8 89 55 E8 8B 45 E8 3B 45 F0 0F 86 92 00 00 00 83 7D 0C FF 74 15 8B 4D 0C 51 68 FD 00 00 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 33 C0 74 09 C7 45 C4 01 00 00 00 EB 07 C7 45 C4 00 00 00 00 8B 4D C4 89 4D D8 83 7D D8 00 75 21 68 ?? ?? ?? ?? 6A 00 68 D0 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D8 00 75 30 E8 ?? ?? ?? ?? C7 00 22 00 00 00 6A 00 68 D0 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 7E 01 00 00 8B 45 E8 50 8B 4D E4 51 8B 55 18 52 E8 ?? ?? ?? ?? 83 C4 04 50 E8 ?? ?? ?? ?? 83 C4 0C 89 45 EC 83 7D EC 00 75 21 8B 45 18 8B 48 0C 83 C9 10 8B 55 18 89 4A 0C 8B 45 F4 2B 45 FC 33 D2 F7 75 10 E9 39 01 00 00 EB 25 83 7D EC FF 75 1F 8B 45 18 8B 48 0C 83 C9 20 8B 55 18 89 4A 0C 8B 45 F4 2B 45 FC 33 D2 F7 75 10 E9 12 01 00 00 8B 45 FC 2B 45 EC 89 45 FC 8B 4D E4 03 4D EC 89 4D E4 8B 55 F0 2B 55 EC 89 55 F0 E9 EA 00 00 00 8B 45 18 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 E0 83 7D E0 FF 75 10 8B 45 F4 2B 45 FC 33 D2 F7 75 10 E9 CD 00 00 00 83 7D F0 00 0F 85 8F 00 00 00 83 7D 0C FF 74 15 8B 4D 0C 51 68 FD 00 00 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 33 C0 74 09 C7 45 C0 01 00 00 00 EB 07 C7 45 C0 00 00 00 00 8B 4D C0 89 4D D4 83 7D D4 00 75 21 68 ?? ?? ?? ?? 6A 00 68 F4 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D4 00 75 2D E8 ?? ?? ?? ?? C7 00 22 00 00 00 6A 00 68 F4 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 34 8B 45 E4 8A 4D E0 88 08 8B 55 E4 83 C2 01 89 55 E4 8B 45 FC 83 E8 01 89 45 FC 8B 4D F0 83 E9 01 89 4D F0 8B 55 18 8B 42 18 89 45 F8 E9 27 FC FF FF 8B 45 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_31_2_0 {
	meta:
		name = "_fread"
		size = 31
		refs = "0016 _fread_s"
	strings:
		$1 = { 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 6A FF 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_31_3_0 {
	meta:
		name = "__fread_nolock"
		size = 31
		refs = "0016 __fread_nolock_s"
	strings:
		$1 = { 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 6A FF 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_32_0_0 {
	meta:
		name = "__mbctoupper_l"
		size = 323
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 003e ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 005d ??1_LocaleUpdate@@QAE@XZ 00a4 ___crtLCMapStringA"
	strings:
		$1 = { 55 8B EC 83 EC 2C 8B 45 0C 50 8D 4D E8 E8 ?? ?? ?? ?? 81 7D 08 FF 00 00 00 0F 86 CC 00 00 00 8B 4D 08 C1 E9 08 81 E1 FF 00 00 00 88 4D F8 8B 55 08 81 E2 FF 00 00 00 88 55 F9 8D 4D E8 E8 ?? ?? ?? ?? 8B 40 04 0F B6 4D F8 0F B6 54 08 1D 83 E2 04 75 16 8B 45 08 89 45 E4 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 E4 E9 D6 00 00 00 6A 01 8D 4D E8 E8 ?? ?? ?? ?? 8B 48 04 8B 51 04 52 6A 02 8D 45 FC 50 6A 02 8D 4D F8 51 68 00 02 00 00 8D 4D E8 E8 ?? ?? ?? ?? 8B 50 04 8B 42 0C 50 8D 4D E8 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 24 85 C0 75 13 8B 4D 08 89 4D E0 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 E0 EB 7D 0F B6 55 FD 89 55 08 0F B6 45 FC C1 E0 08 03 45 08 89 45 08 8B 4D 08 89 4D DC 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 DC EB 56 EB 4C 8D 4D E8 E8 ?? ?? ?? ?? 8B 50 04 8B 45 08 0F B6 4C 02 1D 83 E1 20 74 1B 8D 4D E8 E8 ?? ?? ?? ?? 8B 50 04 8B 45 08 0F B6 8C 02 1D 01 00 00 89 4D D4 EB 06 8B 55 08 89 55 D4 8B 45 D4 89 45 D8 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 D8 EB 08 8D 4D E8 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_33_0_0 {
	meta:
		name = "__snscanf"
		size = 45
		refs = "001d __input_l 0022 _vscan_fn"
	strings:
		$1 = { 55 8B EC 51 8D 45 14 89 45 FC 8B 4D FC 51 6A 00 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 18 8B E5 5D C3 }
	condition:
		$1
}

rule file_33_3_0 {
	meta:
		name = "__snscanf_s"
		size = 45
		refs = "001d __input_s_l 0022 _vscan_fn"
	strings:
		$1 = { 55 8B EC 51 8D 45 14 89 45 FC 8B 4D FC 51 6A 00 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 18 8B E5 5D C3 }
	condition:
		$1
}

rule file_662_0_0 {
	meta:
		name = "__snwscanf"
		size = 45
		refs = "001d __winput_l 0022 _vscan_fn"
	strings:
		$1 = { 55 8B EC 51 8D 45 14 89 45 FC 8B 4D FC 51 6A 00 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 18 8B E5 5D C3 }
	condition:
		$1
}

rule file_662_3_0 {
	meta:
		name = "__snwscanf_s"
		size = 45
		refs = "001d __winput_s_l 0022 _vscan_fn"
	strings:
		$1 = { 55 8B EC 51 8D 45 14 89 45 FC 8B 4D FC 51 6A 00 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 18 8B E5 5D C3 }
	condition:
		$1
}

rule file_33_1_0 {
	meta:
		name = "_vscan_fn"
		size = 298
		refs = "001f ??_C@_1CC@OLIJCKA@?$AA?$CI?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0028 ??_C@_1GC@FPFJMOBM@?$AAf?$AA?3?$AA?2?$AAr?$AAt?$AAm?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2@ 002f __CrtDbgReportW 0043 __errno 0057 ??_C@_1BC@KMGJCMNP@?$AAv?$AAs?$AAc?$AAa?$AAn?$AA_?$AAf?$AAn?$AA?$AA@ 0061 __invalid_parameter 0083 ??_C@_1CC@MGIEJOME@?$AA?$CI?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@"
	strings:
		$1 = { 55 8B EC 83 EC 30 8D 45 D8 89 45 F8 33 C9 83 7D 0C 00 0F 95 C1 89 4D D4 83 7D D4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 32 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D4 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 32 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 B6 00 00 00 33 C0 83 7D 14 00 0F 95 C0 89 45 D0 83 7D D0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 33 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D0 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 33 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 55 8B 55 F8 C7 42 0C 49 00 00 00 8B 45 F8 8B 4D 0C 89 48 08 8B 55 F8 8B 45 0C 89 02 81 7D 10 FF FF FF 7F 76 0C 8B 4D F8 C7 41 04 FF FF FF 7F EB 09 8B 55 F8 8B 45 10 89 42 04 8B 4D 1C 51 8B 55 18 52 8B 45 14 50 8B 4D F8 51 FF 55 08 83 C4 10 89 45 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_33_2_0 {
	meta:
		name = "__snscanf_l"
		size = 47
		refs = "001f __input_l 0024 _vscan_fn"
	strings:
		$1 = { 55 8B EC 51 8D 45 18 89 45 FC 8B 4D FC 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 18 8B E5 5D C3 }
	condition:
		$1
}

rule file_33_4_0 {
	meta:
		name = "__snscanf_s_l"
		size = 47
		refs = "001f __input_s_l 0024 _vscan_fn"
	strings:
		$1 = { 55 8B EC 51 8D 45 18 89 45 FC 8B 4D FC 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 18 8B E5 5D C3 }
	condition:
		$1
}

rule file_662_2_0 {
	meta:
		name = "__snwscanf_l"
		size = 47
		refs = "001f __winput_l 0024 _vscan_fn"
	strings:
		$1 = { 55 8B EC 51 8D 45 18 89 45 FC 8B 4D FC 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 18 8B E5 5D C3 }
	condition:
		$1
}

rule file_662_4_0 {
	meta:
		name = "__snwscanf_s_l"
		size = 47
		refs = "001f __winput_s_l 0024 _vscan_fn"
	strings:
		$1 = { 55 8B EC 51 8D 45 18 89 45 FC 8B 4D FC 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 18 8B E5 5D C3 }
	condition:
		$1
}

rule file_34_0_0 {
	meta:
		name = "__mbscmp_l"
		size = 590
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0025 ??_C@_1BG@MODEICJK@?$AAs?$AA1?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 002e ??_C@_1BC@GHNLJFHA@?$AAm?$AAb?$AAs?$AAc?$AAm?$AAp?$AA?4?$AAc?$AA?$AA@ 0035 __CrtDbgReportW 0049 __errno 005d ??_C@_1BE@DOKJHEJA@?$AA_?$AAm?$AAb?$AAs?$AAc?$AAm?$AAp?$AA_?$AAl?$AA?$AA@ 0067 __invalid_parameter 0079 ??1_LocaleUpdate@@QAE@XZ 0098 ??_C@_1BG@GBJNMPFA@?$AAs?$AA2?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 00fc ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0112 _strcmp"
	strings:
		$1 = { 55 8B EC 83 EC 3C 8B 45 10 50 8D 4D E8 E8 ?? ?? ?? ?? 33 C9 83 7D 08 00 0F 95 C1 89 4D E4 83 7D E4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 37 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E4 00 75 3D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 37 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 DC FF FF FF 7F 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 DC E9 C5 01 00 00 33 C0 83 7D 0C 00 0F 95 C0 89 45 E0 83 7D E0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 38 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 3D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 38 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 D8 FF FF FF 7F 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 D8 E9 52 01 00 00 8D 4D E8 E8 ?? ?? ?? ?? 8B 50 04 83 7A 08 00 75 23 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 D4 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 D4 E9 1E 01 00 00 8B 55 08 66 0F B6 02 66 89 45 FC 8B 4D 08 83 C1 01 89 4D 08 8D 4D E8 E8 ?? ?? ?? ?? 8B 50 04 0F B6 45 FC 0F B6 4C 02 1D 83 E1 04 74 36 8B 55 08 0F B6 02 85 C0 75 09 C7 45 C8 00 00 00 00 EB 1B 0F B7 4D FC C1 E1 08 8B 55 08 0F B6 02 0B C8 89 4D C8 8B 4D 08 83 C1 01 89 4D 08 66 8B 55 C8 66 89 55 FC 8B 45 0C 66 0F B6 08 66 89 4D F8 8B 55 0C 83 C2 01 89 55 0C 8D 4D E8 E8 ?? ?? ?? ?? 8B 40 04 0F B6 4D F8 0F B6 54 08 1D 83 E2 04 74 36 8B 45 0C 0F B6 08 85 C9 75 09 C7 45 C4 00 00 00 00 EB 1B 0F B7 55 F8 C1 E2 08 8B 45 0C 0F B6 08 0B D1 89 55 C4 8B 55 0C 83 C2 01 89 55 0C 66 8B 45 C4 66 89 45 F8 0F B7 4D FC 0F B7 55 F8 3B CA 74 23 0F B7 45 FC 0F B7 4D F8 33 D2 3B C1 0F 9F C2 8D 54 12 FF 89 55 D0 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 D0 EB 29 0F B7 45 FC 85 C0 75 14 C7 45 CC 00 00 00 00 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 CC EB 0D E9 EA FE FF FF 8D 4D E8 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_35_0_0 {
	meta:
		name = "__frnd"
		size = 21
	strings:
		$1 = { 55 8B EC 83 EC 08 DD 45 08 D9 FC DD 5D F8 DD 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_36_0_0 {
	meta:
		name = "_btowc"
		size = 104
		refs = "0043 ?_mbrtowc_s_l@@YAHPAHPA_WPBDI0PAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 14 83 7D 08 FF 75 08 66 0D FF FF EB 52 EB 50 8A 45 08 88 45 F7 C7 45 FC 00 00 00 00 66 C7 45 F8 00 00 C7 45 F0 FF FF FF FF 6A 00 8D 4D FC 51 6A 01 8D 55 F7 52 8D 45 F8 50 8D 4D F0 51 E8 ?? ?? ?? ?? 83 C4 18 83 7D F0 00 7D 09 C7 45 EC FF FF 00 00 EB 07 0F B7 55 F8 89 55 EC 66 8B 45 EC 8B E5 5D C3 }
	condition:
		$1
}

rule file_36_1_0 {
	meta:
		name = "?_mbrtowc_s_l@@YAHPAHPA_WPBDI0PAUlocaleinfo_struct@@@Z"
		size = 1097
		refs = "0006 __ehhandler$?_mbrtowc_s_l@@YAHPAHPA_WPBDI0PAUlocaleinfo_struct@@@Z 0015 ___security_cookie 002c ??_C@_1BM@GKBOADAN@?$AAp?$AAm?$AAb?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0035 ??_C@_1BE@CEGHGNFO@?$AAm?$AAb?$AAr?$AAt?$AAo?$AAw?$AAc?$AA?4?$AAc?$AA?$AA@ 003c __CrtDbgReportW 00a1 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 00b0 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 00d3 ??_C@_1NC@EINCOKCO@?$AA_?$AAl?$AAo?$AAc?$AA_?$AAu?$AAp?$AAd?$AAa?$AAt?$AAe?$AA?4?$AAG?$AAe?$AAt?$AAL?$AAo?$AAc?$AAa?$AAl?$AAe?$AAT?$AA?$CI?$AA?$CJ?$AA?9?$AA?$DO?$AAl?$AAo?$AAc?$AAi?$AAn?$AAf@ 0134 ??1_LocaleUpdate@@QAE@XZ 0190 __imp__MultiByteToWideChar@24 01a2 __errno 0242 __isleadbyte_l"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 30 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 83 7D 18 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3F 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D 0C 00 74 08 8B 4D 0C 66 C7 01 00 00 83 7D 10 00 74 06 83 7D 14 00 75 16 83 7D 08 00 74 09 8B 55 08 C7 02 00 00 00 00 33 C0 E9 C1 03 00 00 8B 45 10 0F BE 08 85 C9 75 16 83 7D 08 00 74 09 8B 55 08 C7 02 00 00 00 00 33 C0 E9 A1 03 00 00 8B 45 1C 50 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8D 4D E4 E8 ?? ?? ?? ?? 8B 08 83 B9 AC 00 00 00 01 74 31 8D 4D E4 E8 ?? ?? ?? ?? 8B 10 83 BA AC 00 00 00 02 74 1E 68 ?? ?? ?? ?? 6A 00 6A 52 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 8D 4D E4 E8 ?? ?? ?? ?? 8B 08 83 79 14 00 75 40 83 7D 0C 00 74 0D 8B 55 10 66 0F B6 02 8B 4D 0C 66 89 01 83 7D 08 00 74 09 8B 55 08 C7 02 01 00 00 00 C7 45 E0 00 00 00 00 C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 E0 E9 FA 02 00 00 8B 45 18 83 38 00 0F 84 E5 00 00 00 8B 4D 18 8B 55 10 8A 02 88 41 01 8D 4D E4 E8 ?? ?? ?? ?? 8B 08 83 B9 AC 00 00 00 01 7E 2E 33 D2 83 7D 0C 00 0F 95 C2 52 8B 45 0C 50 6A 02 8B 4D 18 51 6A 09 8D 4D E4 E8 ?? ?? ?? ?? 8B 10 8B 42 04 50 FF 15 ?? ?? ?? ?? 85 C0 75 52 8B 4D 18 C7 01 00 00 00 00 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 83 7D 0C 00 74 08 8B 55 0C 66 C7 02 00 00 83 7D 08 00 74 09 8B 45 08 C7 00 FF FF FF FF E8 ?? ?? ?? ?? 8B 08 89 4D DC C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 DC E9 50 02 00 00 8B 55 18 C7 02 00 00 00 00 83 7D 08 00 74 15 8D 4D E4 E8 ?? ?? ?? ?? 8B 00 8B 4D 08 8B 90 AC 00 00 00 89 11 C7 45 D8 00 00 00 00 C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 D8 E9 0E 02 00 00 E9 FA 01 00 00 8D 4D E4 E8 ?? ?? ?? ?? 50 8B 45 10 0F B6 08 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 0F 84 3C 01 00 00 8D 4D E4 E8 ?? ?? ?? ?? 8B 10 8B 45 14 3B 82 AC 00 00 00 73 3C 8B 4D 18 8B 55 10 8A 02 88 01 83 7D 08 00 74 09 8B 4D 08 C7 01 FE FF FF FF C7 45 D4 00 00 00 00 C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 D4 E9 9D 01 00 00 E9 AD 00 00 00 8D 4D E4 E8 ?? ?? ?? ?? 8B 10 83 BA AC 00 00 00 01 7E 3D 33 C0 83 7D 0C 00 0F 95 C0 50 8B 4D 0C 51 8D 4D E4 E8 ?? ?? ?? ?? 8B 10 8B 82 AC 00 00 00 50 8B 4D 10 51 6A 09 8D 4D E4 E8 ?? ?? ?? ?? 8B 10 8B 42 04 50 FF 15 ?? ?? ?? ?? 85 C0 75 5D 8B 4D 10 0F BE 51 01 85 D2 75 52 8B 45 18 C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 83 7D 0C 00 74 08 8B 4D 0C 66 C7 01 00 00 83 7D 08 00 74 09 8B 55 08 C7 02 FF FF FF FF E8 ?? ?? ?? ?? 8B 00 89 45 D0 C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 D0 E9 EB 00 00 00 83 7D 08 00 74 15 8D 4D E4 E8 ?? ?? ?? ?? 8B 08 8B 55 08 8B 81 AC 00 00 00 89 02 C7 45 CC 00 00 00 00 C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 CC E9 B2 00 00 00 E9 9E 00 00 00 33 C9 83 7D 0C 00 0F 95 C1 51 8B 55 0C 52 6A 01 8B 45 10 50 6A 09 8D 4D E4 E8 ?? ?? ?? ?? 8B 08 8B 51 04 52 FF 15 ?? ?? ?? ?? 85 C0 75 46 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 83 7D 0C 00 74 08 8B 45 0C 66 C7 00 00 00 83 7D 08 00 74 09 8B 4D 08 C7 01 FF FF FF FF E8 ?? ?? ?? ?? 8B 10 89 55 C8 C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 C8 EB 39 83 7D 08 00 74 09 8B 45 08 C7 00 01 00 00 00 C7 45 C4 00 00 00 00 C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 C4 EB 0F C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_36_3_0 {
	meta:
		name = "__ehhandler$?_mbrtowc_s_l@@YAHPAHPA_WPBDI0PAUlocaleinfo_struct@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_mbrtowc_s_l@@YAHPAHPA_WPBDI0PAUlocaleinfo_struct@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A CC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_414_1 {
	meta:
		name = "__ehhandler$?_Init@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Init@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A CC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_47_1356_1 {
	meta:
		name = "__ehhandler$?_Init@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Init@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A CC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_47_1141_1 {
	meta:
		name = "__ehhandler$?_Init@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Init@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A CC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_36_7_0 {
	meta:
		name = "_mbrlen"
		size = 69
		refs = "001e ?mbst@?1??mbrlen@@9@4HA 0037 ?_mbrtowc_s_l@@YAHPAHPA_WPBDI0PAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 C7 45 FC FF FF FF FF 83 7D 10 00 74 08 8B 45 10 89 45 F8 EB 07 C7 45 F8 ?? ?? ?? ?? 6A 00 8B 4D F8 51 8B 55 0C 52 8B 45 08 50 6A 00 8D 4D FC 51 E8 ?? ?? ?? ?? 83 C4 18 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_36_8_0 {
	meta:
		name = "_mbrtowc"
		size = 127
		refs = "0024 ?mbst@?1??mbrtowc@@9@4HA 003f ?_mbrtowc_s_l@@YAHPAHPA_WPBDI0PAUlocaleinfo_struct@@@Z 0066 ??_C@_00CNPNBAHC@?$AA@"
	strings:
		$1 = { 55 8B EC 83 EC 0C C7 45 FC FF FF FF FF 83 7D 0C 00 74 35 83 7D 14 00 74 08 8B 45 14 89 45 F8 EB 07 C7 45 F8 ?? ?? ?? ?? 6A 00 8B 4D F8 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 8D 55 FC 52 E8 ?? ?? ?? ?? 83 C4 18 EB 30 83 7D 14 00 74 08 8B 45 14 89 45 F4 EB 07 C7 45 F4 ?? ?? ?? ?? 6A 00 8B 4D F4 51 6A 01 68 ?? ?? ?? ?? 6A 00 8D 55 FC 52 E8 ?? ?? ?? ?? 83 C4 18 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_36_9_0 {
	meta:
		name = "__mbsrtowcs_helper"
		size = 427
		refs = "0019 ??_C@_1BG@IHKPJEA@?$AAp?$AAs?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0025 ??_C@_1BE@CEGHGNFO@?$AAm?$AAb?$AAr?$AAt?$AAo?$AAw?$AAc?$AA?4?$AAc?$AA?$AA@ 002c __CrtDbgReportW 0040 __errno 0057 ??_C@_1CE@GMDJEGCL@?$AA_?$AAm?$AAb?$AAs?$AAr?$AAt?$AAo?$AAw?$AAc?$AAs?$AA_?$AAh?$AAe?$AAl?$AAp?$AAe?$AAr?$AA?$AA@ 0061 __invalid_parameter 008c ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0099 ?mbst@?5??_mbsrtowcs_helper@@9@4HA 00bb ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 00d6 ?_mbrtowc_s_l@@YAHPAHPA_WPBDI0PAUlocaleinfo_struct@@@Z 00ee ??1_LocaleUpdate@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 83 EC 30 33 C0 83 7D 0C 00 0F 95 C0 89 45 E0 83 7D E0 00 75 21 68 ?? ?? ?? ?? 6A 00 68 20 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 31 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 20 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 37 01 00 00 8B 55 0C 8B 02 89 45 F8 C7 45 FC 00 00 00 00 C7 45 F4 00 00 00 00 6A 00 8D 4D E4 E8 ?? ?? ?? ?? 83 7D 14 00 75 07 C7 45 14 ?? ?? ?? ?? 83 7D 08 00 75 77 EB 12 8B 4D F4 83 C1 01 89 4D F4 8B 55 F8 03 55 FC 89 55 F8 8D 4D E4 E8 ?? ?? ?? ?? 50 8B 45 14 50 68 FF FF FF 7F 8B 4D F8 51 8D 55 DC 52 8D 45 FC 50 E8 ?? ?? ?? ?? 83 C4 18 83 7D FC 00 7D 19 C7 45 D8 FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 D8 E9 AD 00 00 00 EB 1C 83 7D FC 00 75 16 8B 4D F4 89 4D D4 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 D4 E9 8F 00 00 00 EB 8B EB 24 8B 55 F4 83 C2 01 89 55 F4 8B 45 F8 03 45 FC 89 45 F8 8B 4D 08 83 C1 02 89 4D 08 8B 55 10 83 EA 01 89 55 10 83 7D 10 00 76 48 8D 4D E4 E8 ?? ?? ?? ?? 50 8B 45 14 50 68 FF FF FF 7F 8B 4D F8 51 8B 55 08 52 8D 45 FC 50 E8 ?? ?? ?? ?? 83 C4 18 83 7D FC 00 7D 0B C7 45 F4 FF FF FF FF EB 13 EB 0F 83 7D FC 00 75 09 C7 45 F8 00 00 00 00 EB 02 EB 8E 8B 4D 0C 8B 55 F8 89 11 8B 45 F4 89 45 D0 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 D0 8B E5 5D C3 }
	condition:
		$1
}

rule file_36_10_0 {
	meta:
		name = "_mbsrtowcs"
		size = 29
		refs = "0014 __mbsrtowcs_helper"
	strings:
		$1 = { 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_89_242_1 {
	meta:
		name = "??$copy_s@U?$char_traits@D@std@@@_Traits_helper@std@@YAPADPADIPBDIU_Secure_char_traits_tag@1@@Z"
		size = 29
		refs = "0014 ?_Copy_s@?$char_traits@D@std@@SAPADPADIPBDI@Z"
	strings:
		$1 = { 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_14_264_1 {
	meta:
		name = "??$copy_s@U?$char_traits@G@std@@@_Traits_helper@std@@YAPAGPAGIPBGIU_Secure_char_traits_tag@1@@Z"
		size = 29
		refs = "0014 ?_Copy_s@?$char_traits@G@std@@SAPAGPAGIPBGI@Z"
	strings:
		$1 = { 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_3_264_1 {
	meta:
		name = "??$copy_s@U?$char_traits@_W@std@@@_Traits_helper@std@@YAPA_WPA_WIPB_WIU_Secure_char_traits_tag@1@@Z"
		size = 29
		refs = "0014 ?_Copy_s@?$char_traits@_W@std@@SAPA_WPA_WIPB_WI@Z"
	strings:
		$1 = { 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_89_244_1 {
	meta:
		name = "??$move_s@U?$char_traits@D@std@@@_Traits_helper@std@@YAPADPADIPBDIU_Secure_char_traits_tag@1@@Z"
		size = 29
		refs = "0014 ?_Move_s@?$char_traits@D@std@@SAPADPADIPBDI@Z"
	strings:
		$1 = { 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_47_1808_1 {
	meta:
		name = "??$move_s@U?$char_traits@G@std@@@_Traits_helper@std@@YAPAGPAGIPBGIU_Secure_char_traits_tag@1@@Z"
		size = 29
		refs = "0014 ?_Move_s@?$char_traits@G@std@@SAPAGPAGIPBGI@Z"
	strings:
		$1 = { 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_47_1805_1 {
	meta:
		name = "??$move_s@U?$char_traits@_W@std@@@_Traits_helper@std@@YAPA_WPA_WIPB_WIU_Secure_char_traits_tag@1@@Z"
		size = 29
		refs = "0014 ?_Move_s@?$char_traits@_W@std@@SAPA_WPA_WIPB_WI@Z"
	strings:
		$1 = { 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_71_175_1 {
	meta:
		name = "??2facet@locale@std@@SAPAXIABU_DebugHeapTag_t@2@PADH@Z"
		size = 29
		refs = "0014 ??2@YAPAXIABU_DebugHeapTag_t@std@@PADH@Z"
	strings:
		$1 = { 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_51_6_1 {
	meta:
		name = "??_U@YAPAXIABU_DebugHeapTag_t@std@@PADH@Z"
		size = 29
		refs = "0014 ??2@YAPAXIABU_DebugHeapTag_t@std@@PADH@Z"
	strings:
		$1 = { 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_51_8_1 {
	meta:
		name = "??_V@YAXPAXABU_DebugHeapTag_t@std@@PADH@Z"
		size = 29
		refs = "0014 ??3@YAXPAXABU_DebugHeapTag_t@std@@PADH@Z"
	strings:
		$1 = { 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_30_1_1 {
	meta:
		name = "__Stoldx"
		size = 29
		refs = "0014 __Stodx"
	strings:
		$1 = { 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_756_2_0 {
	meta:
		name = "___vswprintf_l"
		size = 29
		refs = "0014 __vswprintf_l"
	strings:
		$1 = { 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_636_4_0 {
	meta:
		name = "__mbstowcs_l"
		size = 29
		refs = "0014 __mbstowcs_l_helper"
	strings:
		$1 = { 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_436_5_0 {
	meta:
		name = "__wcstombs_l"
		size = 29
		refs = "0014 __wcstombs_l_helper"
	strings:
		$1 = { 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_816_9_0 {
	meta:
		name = "_wcsrtombs"
		size = 29
		refs = "0014 __wcsrtombs_helper"
	strings:
		$1 = { 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_36_11_0 {
	meta:
		name = "_mbsrtowcs_s"
		size = 786
		refs = "004a ??_C@_1IM@JFPALMP@?$AA?$CI?$AAd?$AAs?$AAt?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAW?$AAo?$AAr?$AAd?$AAs?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0@ 0056 ??_C@_1BE@CEGHGNFO@?$AAm?$AAb?$AAr?$AAt?$AAo?$AAw?$AAc?$AA?4?$AAc?$AA?$AA@ 005d __CrtDbgReportW 0071 __errno 0088 ??_C@_1BI@GDNNFHAB@?$AAm?$AAb?$AAs?$AAr?$AAt?$AAo?$AAw?$AAc?$AAs?$AA_?$AAs?$AA?$AA@ 0092 __invalid_parameter 00ce ___crtDebugFillThreshold 00fb _memset 0115 ??_C@_1BG@IHKPJEA@?$AAp?$AAs?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0195 __mbsrtowcs_helper 0299 ??_C@_1CO@EPBLOHBA@?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAW?$AAo?$AAr?$AAd?$AAs?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAr?$AAe?$AAt?$AAs?$AAi?$AAz?$AAe?$AA?$AA@"
	strings:
		$1 = { 55 8B EC 83 EC 24 83 7D 08 00 74 09 8B 45 08 C7 00 FF FF FF FF 83 7D 0C 00 75 06 83 7D 10 00 74 15 83 7D 0C 00 74 06 83 7D 10 00 77 09 C7 45 EC 00 00 00 00 EB 07 C7 45 EC 01 00 00 00 8B 4D EC 89 4D F8 83 7D F8 00 75 21 68 ?? ?? ?? ?? 6A 00 68 89 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F8 00 75 33 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 89 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 6B 02 00 00 83 7D 0C 00 74 59 8B 45 0C 66 C7 00 00 00 83 7D 10 FF 74 4B 81 7D 10 FF FF FF 7F 74 42 83 7D 10 01 76 3C 8B 4D 10 83 E9 01 39 0D ?? ?? ?? ?? 73 0B 8B 15 ?? ?? ?? ?? 89 55 E8 EB 09 8B 45 10 83 E8 01 89 45 E8 8B 4D E8 D1 E1 51 68 FD 00 00 00 8B 55 0C 83 C2 02 52 E8 ?? ?? ?? ?? 83 C4 0C 33 C0 83 7D 14 00 0F 95 C0 89 45 F4 83 7D F4 00 75 21 68 ?? ?? ?? ?? 6A 00 68 8E 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F4 00 75 33 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 8E 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 A0 01 00 00 8B 55 18 3B 55 10 76 08 8B 45 10 89 45 E4 EB 06 8B 4D 18 89 4D E4 8B 55 1C 52 8B 45 E4 50 8B 4D 14 51 8B 55 0C 52 E8 ?? ?? ?? ?? 83 C4 10 89 45 FC 83 7D FC FF 75 6B 83 7D 0C 00 74 59 8B 45 0C 66 C7 00 00 00 83 7D 10 FF 74 4B 81 7D 10 FF FF FF 7F 74 42 83 7D 10 01 76 3C 8B 4D 10 83 E9 01 39 0D ?? ?? ?? ?? 73 0B 8B 15 ?? ?? ?? ?? 89 55 E0 EB 09 8B 45 10 83 E8 01 89 45 E0 8B 4D E0 D1 E1 51 68 FD 00 00 00 8B 55 0C 83 C2 02 52 E8 ?? ?? ?? ?? 83 C4 0C E8 ?? ?? ?? ?? 8B 00 E9 FE 00 00 00 8B 45 FC 83 C0 01 89 45 FC 83 7D 0C 00 0F 84 DB 00 00 00 8B 4D FC 3B 4D 10 0F 86 C2 00 00 00 8B 55 0C 66 C7 02 00 00 83 7D 10 FF 74 4B 81 7D 10 FF FF FF 7F 74 42 83 7D 10 01 76 3C 8B 45 10 83 E8 01 39 05 ?? ?? ?? ?? 73 0B 8B 0D ?? ?? ?? ?? 89 4D DC EB 09 8B 55 10 83 EA 01 89 55 DC 8B 45 DC D1 E0 50 68 FD 00 00 00 8B 4D 0C 83 C1 02 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 10 39 55 FC 1B C0 83 C0 01 89 45 F0 75 21 68 ?? ?? ?? ?? 6A 00 68 A6 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 30 E8 ?? ?? ?? ?? C7 00 22 00 00 00 6A 00 68 A6 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 22 00 00 00 EB 1F EB 0D 8B 55 FC 8B 45 0C 66 C7 44 50 FE 00 00 83 7D 08 00 74 08 8B 4D 08 8B 55 FC 89 11 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_37_0_0 {
	meta:
		name = "_exp"
		size = 60
		refs = "0002 ___use_sse2_mathfcns 0037 __exp_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 6E 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 41 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_37_1_0 {
	meta:
		name = "__CIexp"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIexp_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 3C 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 0F E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_38_0_0 {
	meta:
		name = "__stat64"
		size = 1506
		refs = "000a ___security_cookie 002d ??_C@_1BO@PCMLKEJK@?$AA?$CI?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0036 ??_C@_1BC@PGJMMBIB@?$AAs?$AAt?$AAa?$AAt?$AA6?$AA4?$AA?4?$AAc?$AA?$AA@ 003d __CrtDbgReportW 0054 ___doserrno 005f __errno 0073 ??_C@_1BA@FPOAEMID@?$AA_?$AAs?$AAt?$AAa?$AAt?$AA6?$AA4?$AA?$AA@ 007d __invalid_parameter 00a5 ??_C@_1BM@KFJLMBPG@?$AA?$CI?$AAb?$AAu?$AAf?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0105 ??_C@_02EAOCEIGI@?$DP?$CK?$AA@ 010e __mbspbrk 017e __mbctolower 0191 __getdrive 01a8 __imp__FindFirstFileA@8 01ca ??_C@_03LLEJOLGL@?4?1?2?$AA@ 01f6 __fullpath_helper 0214 _strlen 0228 _IsRootUNCName 023c __imp__GetDriveTypeA@4 0256 _free 02ca ___loctotime64_t 0329 __imp__FileTimeToLocalFileTime@8 0341 __imp__FileTimeToSystemTime@8 034b __imp__GetLastError@0 0351 __dosmaperr 0361 __imp__FindClose@4 055e ___dtoxmode 0584 __allmul 05da @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC 80 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 33 C0 83 7D 08 00 0F 95 C0 89 85 A0 FD FF FF 83 BD A0 FD FF FF 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 69 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD A0 FD FF FF 00 75 39 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 69 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 47 05 00 00 33 D2 83 7D 0C 00 0F 95 C2 89 95 9C FD FF FF 83 BD 9C FD FF FF 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 6A 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 9C FD FF FF 00 75 39 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 6A 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 CF 04 00 00 68 ?? ?? ?? ?? 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 1E E8 ?? ?? ?? ?? C7 00 02 00 00 00 E8 ?? ?? ?? ?? C7 00 02 00 00 00 83 C8 FF E9 9C 04 00 00 8B 55 08 0F BE 42 01 83 F8 3A 75 4D 8B 4D 08 0F BE 11 85 D2 74 29 8B 45 08 0F BE 48 02 85 C9 75 1E E8 ?? ?? ?? ?? C7 00 02 00 00 00 E8 ?? ?? ?? ?? C7 00 02 00 00 00 83 C8 FF E9 5D 04 00 00 8B 55 08 0F BE 02 50 E8 ?? ?? ?? ?? 83 C4 04 83 E8 60 89 85 A8 FD FF FF EB 0B E8 ?? ?? ?? ?? 89 85 A8 FD FF FF 8D 8D B0 FD FF FF 51 8B 55 08 52 FF 15 ?? ?? ?? ?? 89 85 AC FD FF FF 83 BD AC FD FF FF FF 0F 85 44 01 00 00 C7 85 98 FD FF FF 00 00 00 00 68 ?? ?? ?? ?? 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 67 8D 8D 98 FD FF FF 51 68 04 01 00 00 8B 55 08 52 8D 85 F0 FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 10 89 85 A4 FD FF FF 83 BD A4 FD FF FF 00 74 39 8B 8D A4 FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 83 F8 03 74 13 8B 95 A4 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 12 8B 85 A4 FD FF FF 50 FF 15 ?? ?? ?? ?? 83 F8 01 77 36 83 BD 98 FD FF FF 00 74 0F 8B 8D 98 FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? C7 00 02 00 00 00 E8 ?? ?? ?? ?? C7 00 02 00 00 00 83 C8 FF E9 58 03 00 00 83 BD 98 FD FF FF 00 74 0F 8B 95 98 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 C7 85 B0 FD FF FF 10 00 00 00 C7 85 CC FD FF FF 00 00 00 00 C7 85 D0 FD FF FF 00 00 00 00 C6 85 DC FD FF FF 00 6A FF 6A 00 6A 00 6A 00 6A 01 6A 01 68 BC 07 00 00 E8 ?? ?? ?? ?? 83 C4 1C 8B 4D 0C 89 41 28 89 51 2C 8B 55 0C 8B 45 0C 8B 48 28 89 4A 20 8B 40 2C 89 42 24 8B 4D 0C 8B 55 0C 8B 42 28 89 41 30 8B 52 2C 89 51 34 E9 4F 02 00 00 83 BD C4 FD FF FF 00 75 0D 83 BD C8 FD FF FF 00 0F 84 99 00 00 00 8D 85 90 FD FF FF 50 8D 8D C4 FD FF FF 51 FF 15 ?? ?? ?? ?? 85 C0 74 18 8D 95 80 FD FF FF 52 8D 85 90 FD FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 75 24 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 8B 8D AC FD FF FF 51 FF 15 ?? ?? ?? ?? 83 C8 FF E9 66 02 00 00 6A FF 0F B7 95 8C FD FF FF 52 0F B7 85 8A FD FF FF 50 0F B7 8D 88 FD FF FF 51 0F B7 95 86 FD FF FF 52 0F B7 85 82 FD FF FF 50 0F B7 8D 80 FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 1C 8B 4D 0C 89 41 28 89 51 2C EB 11 8B 55 0C C7 42 28 00 00 00 00 C7 42 2C 00 00 00 00 83 BD BC FD FF FF 00 75 0D 83 BD C0 FD FF FF 00 0F 84 99 00 00 00 8D 85 90 FD FF FF 50 8D 8D BC FD FF FF 51 FF 15 ?? ?? ?? ?? 85 C0 74 18 8D 95 80 FD FF FF 52 8D 85 90 FD FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 75 24 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 8B 8D AC FD FF FF 51 FF 15 ?? ?? ?? ?? 83 C8 FF E9 A6 01 00 00 6A FF 0F B7 95 8C FD FF FF 52 0F B7 85 8A FD FF FF 50 0F B7 8D 88 FD FF FF 51 0F B7 95 86 FD FF FF 52 0F B7 85 82 FD FF FF 50 0F B7 8D 80 FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 1C 8B 4D 0C 89 41 20 89 51 24 EB 12 8B 55 0C 8B 45 0C 8B 48 28 89 4A 20 8B 40 2C 89 42 24 83 BD B4 FD FF FF 00 75 0D 83 BD B8 FD FF FF 00 0F 84 99 00 00 00 8D 8D 90 FD FF FF 51 8D 95 B4 FD FF FF 52 FF 15 ?? ?? ?? ?? 85 C0 74 18 8D 85 80 FD FF FF 50 8D 8D 90 FD FF FF 51 FF 15 ?? ?? ?? ?? 85 C0 75 24 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 8B 95 AC FD FF FF 52 FF 15 ?? ?? ?? ?? 83 C8 FF E9 E5 00 00 00 6A FF 0F B7 85 8C FD FF FF 50 0F B7 8D 8A FD FF FF 51 0F B7 95 88 FD FF FF 52 0F B7 85 86 FD FF FF 50 0F B7 8D 82 FD FF FF 51 0F B7 95 80 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 1C 8B 4D 0C 89 41 30 89 51 34 EB 12 8B 55 0C 8B 45 0C 8B 48 28 89 4A 30 8B 40 2C 89 42 34 8B 8D AC FD FF FF 51 FF 15 ?? ?? ?? ?? 8B 55 08 52 8B 85 B0 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4D 0C 66 89 41 06 8B 55 0C 66 C7 42 08 01 00 8B 85 CC FD FF FF 33 C9 6A 01 6A 00 51 50 E8 ?? ?? ?? ?? 8B 8D D0 FD FF FF 33 F6 03 C1 13 D6 8B 4D 0C 89 41 18 89 51 1C 8B 55 0C 66 C7 42 04 00 00 8B 45 0C 66 C7 40 0C 00 00 8B 4D 0C 66 C7 41 0A 00 00 8B 95 A8 FD FF FF 83 EA 01 8B 45 0C 89 10 8B 4D 0C 8B 55 0C 8B 02 89 41 10 33 C0 5E 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_38_1_0 {
	meta:
		name = "_IsRootUNCName"
		size = 265
		refs = "0009 _strlen"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 83 F8 05 0F 82 EA 00 00 00 8B 4D 08 0F BE 11 83 FA 5C 74 0F 8B 45 08 0F BE 08 83 F9 2F 0F 85 D0 00 00 00 8B 55 08 0F BE 42 01 83 F8 5C 74 10 8B 4D 08 0F BE 51 01 83 FA 2F 0F 85 B4 00 00 00 8B 45 08 0F BE 48 02 83 F9 5C 0F 84 A4 00 00 00 8B 55 08 0F BE 42 02 83 F8 2F 0F 84 94 00 00 00 8B 4D 08 83 C1 02 89 4D FC 8B 55 FC 83 C2 01 89 55 FC 8B 45 FC 0F BE 08 85 C9 74 1A 8B 55 FC 0F BE 02 83 F8 5C 74 0B 8B 4D FC 0F BE 11 83 FA 2F 75 02 EB 02 EB D3 8B 45 FC 0F BE 08 85 C9 74 54 8B 55 FC 0F BE 42 01 85 C0 74 49 8B 4D FC 83 C1 01 89 4D FC 8B 55 FC 0F BE 02 85 C0 74 1A 8B 4D FC 0F BE 11 83 FA 5C 74 0B 8B 45 FC 0F BE 08 83 F9 2F 75 02 EB 02 EB D3 8B 55 FC 0F BE 02 85 C0 74 0B 8B 4D FC 0F BE 51 01 85 D2 75 07 B8 01 00 00 00 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_38_2_0 {
	meta:
		name = "__fullpath_helper"
		size = 82
		refs = "0011 __fullpath 0027 __errno"
	strings:
		$1 = { 55 8B EC 51 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 89 45 FC 83 7D FC 00 74 05 8B 45 FC EB 28 E8 ?? ?? ?? ?? 83 38 22 74 04 33 C0 EB 1A 6A 00 8B 45 0C 50 6A 00 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D 14 89 01 8B 55 14 8B 02 8B E5 5D C3 }
	condition:
		$1
}

rule file_365_2_0 {
	meta:
		name = "__wfullpath_helper"
		size = 82
		refs = "0011 __wfullpath 0027 __errno"
	strings:
		$1 = { 55 8B EC 51 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 89 45 FC 83 7D FC 00 74 05 8B 45 FC EB 28 E8 ?? ?? ?? ?? 83 38 22 74 04 33 C0 EB 1A 6A 00 8B 45 0C 50 6A 00 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D 14 89 01 8B 55 14 8B 02 8B E5 5D C3 }
	condition:
		$1
}

rule file_39_0_0 {
	meta:
		name = "__ismbcpunct_l"
		size = 352
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0049 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0061 ??1_LocaleUpdate@@QAE@XZ 00a3 ___crtGetStringTypeA"
	strings:
		$1 = { 55 8B EC 83 EC 30 8B 45 0C 50 8D 4D F0 E8 ?? ?? ?? ?? 81 7D 08 FF 00 00 00 0F 86 DC 00 00 00 66 C7 45 EC 00 00 33 C9 66 89 4D EE 8B 55 08 C1 EA 08 81 E2 FF 00 00 00 88 55 E8 8B 45 08 25 FF 00 00 00 88 45 E9 8D 4D F0 E8 ?? ?? ?? ?? 8B 48 04 83 79 08 00 75 17 C7 45 E4 00 00 00 00 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 E4 E9 EF 00 00 00 6A 01 8D 4D F0 E8 ?? ?? ?? ?? 8B 50 04 8B 42 0C 50 8D 4D F0 E8 ?? ?? ?? ?? 8B 48 04 8B 51 04 52 8D 45 EC 50 6A 02 8D 4D E8 51 6A 01 8D 4D F0 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 20 85 C0 75 17 C7 45 E0 00 00 00 00 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 E0 E9 97 00 00 00 0F B7 55 EE 85 D2 75 12 0F B7 45 EC 83 E0 10 74 09 C7 45 D4 01 00 00 00 EB 07 C7 45 D4 00 00 00 00 8B 4D D4 89 4D DC 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 DC EB 63 EB 59 8D 4D F0 E8 ?? ?? ?? ?? 8B 10 0F B6 45 08 8B 8A C8 00 00 00 0F B7 14 41 83 E2 10 75 22 8D 4D F0 E8 ?? ?? ?? ?? 8B 40 04 0F B6 4D 08 0F B6 54 08 1D 83 E2 02 75 09 C7 45 D0 00 00 00 00 EB 07 C7 45 D0 01 00 00 00 8B 45 D0 89 45 D8 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 D8 EB 08 8D 4D F0 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_40_0_0 {
	meta:
		name = "__mbspbrk_l"
		size = 559
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0016 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 002c _strpbrk 003a ??1_LocaleUpdate@@QAE@XZ 0059 ??_C@_1BO@JIBAMMGI@?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0062 ??_C@_1GE@KOOCIDDE@?$AAf?$AA?3?$AA?2?$AAr?$AAt?$AAm?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2@ 0069 __CrtDbgReportW 007d __errno 0091 ??_C@_1BG@LIACDHFC@?$AA_?$AAm?$AAb?$AAs?$AAp?$AAb?$AAr?$AAk?$AA_?$AAl?$AA?$AA@ 009b __invalid_parameter 00cc ??_C@_1CA@KMNJPEDI@?$AAc?$AAh?$AAa?$AAr?$AAs?$AAe?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@"
	strings:
		$1 = { 55 8B EC 83 EC 30 8B 45 10 50 8D 4D E8 E8 ?? ?? ?? ?? 8D 4D E8 E8 ?? ?? ?? ?? 8B 48 04 83 79 08 00 75 23 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 DC 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 DC E9 E5 01 00 00 33 C9 83 7D 08 00 0F 95 C1 89 4D E4 83 7D E4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 5B 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E4 00 75 3D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 5B 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 D8 00 00 00 00 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 D8 E9 72 01 00 00 33 C0 83 7D 0C 00 0F 95 C0 89 45 E0 83 7D E0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 5C 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 3D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 5C 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 D4 00 00 00 00 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 D4 E9 FF 00 00 00 8B 55 08 89 55 F8 EB 09 8B 45 F8 83 C0 01 89 45 F8 8B 4D F8 0F B6 11 85 D2 0F 84 C5 00 00 00 8B 45 0C 89 45 FC EB 09 8B 4D FC 83 C1 01 89 4D FC 8B 55 FC 0F B6 02 85 C0 74 69 8D 4D E8 E8 ?? ?? ?? ?? 8B 48 04 8B 55 FC 0F B6 02 0F B6 4C 01 1D 83 E1 04 74 3A 8B 55 FC 0F B6 02 8B 4D F8 0F B6 11 3B C2 75 12 8B 45 FC 0F B6 48 01 8B 55 F8 0F B6 42 01 3B C8 74 0B 8B 4D FC 0F B6 51 01 85 D2 75 02 EB 1F 8B 45 FC 83 C0 01 89 45 FC EB 12 8B 4D FC 0F B6 11 8B 45 F8 0F B6 08 3B D1 75 02 EB 02 EB 84 8B 55 FC 0F B6 02 85 C0 74 02 EB 35 8D 4D E8 E8 ?? ?? ?? ?? 8B 48 04 8B 55 F8 0F B6 02 0F B6 4C 01 1D 83 E1 04 74 15 8B 55 F8 83 C2 01 89 55 F8 8B 45 F8 0F B6 08 85 C9 75 02 EB 05 E9 24 FF FF FF 8B 55 F8 0F B6 02 F7 D8 1B C0 23 45 F8 89 45 D0 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 D0 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_0_0 {
	meta:
		name = "_abs"
		size = 33
		altNames = "_labs"
	strings:
		$1 = { 55 8B EC 51 83 7D 08 00 7C 08 8B 45 08 89 45 FC EB 08 8B 4D 08 F7 D9 89 4D FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_1_0 {
	meta:
		name = "__abs64"
		size = 63
	strings:
		$1 = { 55 8B EC 83 EC 08 83 7D 0C 00 7C 16 7F 06 83 7D 08 00 72 0E 8B 45 08 89 45 F8 8B 4D 0C 89 4D FC EB 13 8B 55 08 F7 DA 8B 45 0C 83 D0 00 F7 D8 89 55 F8 89 45 FC 8B 45 F8 8B 55 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_42_0_0 {
	meta:
		name = "_bsearch_s"
		size = 556
		refs = "0045 ??_C@_1DC@HAGCIKOA@?$AAb?$AAa?$AAs?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AAn?$AAu?$AAm?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 004e ??_C@_1GE@NGAHPFDI@?$AAf?$AA?3?$AA?2?$AAr?$AAt?$AAm?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2@ 0055 __CrtDbgReportW 0069 __errno 007d ??_C@_1BE@BBDJDLEB@?$AAb?$AAs?$AAe?$AAa?$AAr?$AAc?$AAh?$AA_?$AAs?$AA?$AA@ 0087 __invalid_parameter 00a4 ??_C@_1BE@NJBEBBME@?$AAw?$AAi?$AAd?$AAt?$AAh?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 0107 ??_C@_1CA@OIBGFNKD@?$AAc?$AAo?$AAm?$AAp?$AAa?$AAr?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@"
	strings:
		$1 = { 55 8B EC 83 EC 2C 8B 45 0C 89 45 F8 8B 4D 10 83 E9 01 0F AF 4D 14 03 4D 0C 89 4D F0 83 7D 0C 00 75 0F 83 7D 10 00 74 09 C7 45 DC 00 00 00 00 EB 07 C7 45 DC 01 00 00 00 8B 55 DC 89 55 E8 83 7D E8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 54 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E8 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 54 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 93 01 00 00 33 C9 3B 4D 14 1B D2 F7 DA 89 55 E4 75 1E 68 ?? ?? ?? ?? 6A 00 6A 55 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E4 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 55 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 34 01 00 00 33 C9 83 7D 18 00 0F 95 C1 89 4D E0 83 7D E0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 56 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 56 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 D1 00 00 00 8B 45 F8 3B 45 F0 0F 87 C3 00 00 00 8B 4D 10 D1 E9 89 4D F4 0F 84 89 00 00 00 8B 55 10 83 E2 01 74 08 8B 45 F4 89 45 D8 EB 09 8B 4D F4 83 E9 01 89 4D D8 8B 55 D8 0F AF 55 14 03 55 F8 89 55 FC 8B 45 FC 50 8B 4D 08 51 8B 55 1C 52 FF 55 18 83 C4 0C 89 45 EC 83 7D EC 00 75 07 8B 45 FC EB 71 EB 3F 83 7D EC 00 7D 2A 8B 45 FC 2B 45 14 89 45 F0 8B 4D 10 83 E1 01 74 08 8B 55 F4 89 55 D4 EB 09 8B 45 F4 83 E8 01 89 45 D4 8B 4D D4 89 4D 10 EB 0F 8B 55 FC 03 55 14 89 55 F8 8B 45 F4 89 45 10 EB 27 83 7D 10 00 74 1F 8B 4D F8 51 8B 55 08 52 8B 45 1C 50 FF 55 18 83 C4 0C F7 D8 1B C0 F7 D0 23 45 F8 EB 0B EB 02 EB 05 E9 31 FF FF FF 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_43_0_0 {
	meta:
		name = "_strpbrk"
		size = 64
	strings:
		$1 = { 55 8B EC 56 33 C0 50 50 50 50 50 50 50 50 8B 55 0C 8D 49 00 8A 02 0A C0 74 09 83 C2 01 0F AB 04 24 EB F1 8B 75 08 8B FF 8A 06 0A C0 74 0C 83 C6 01 0F A3 04 24 73 F1 8D 46 FF 83 C4 20 5E C9 C3 }
	condition:
		$1
}

rule file_44_0_0 {
	meta:
		name = "__ismbcl0_l"
		size = 147
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0016 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0088 ??1_LocaleUpdate@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 83 EC 18 8B 45 0C 50 8D 4D F0 E8 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? 8B 48 04 81 79 04 A4 03 00 00 75 51 8D 4D F0 E8 ?? ?? ?? ?? 8B 50 04 8B 45 08 C1 E8 08 0F B6 C8 0F B6 54 0A 1D 83 E2 04 74 33 8D 4D F0 E8 ?? ?? ?? ?? 8B 40 04 8B 4D 08 81 E1 FF 00 00 00 0F B6 D1 0F B6 44 10 1D 83 E0 08 74 12 81 7D 08 9F 88 00 00 73 09 C7 45 E8 01 00 00 00 EB 07 C7 45 E8 00 00 00 00 8B 4D E8 89 4D EC 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 EC 8B E5 5D C3 }
	condition:
		$1
}

rule file_44_5_0 {
	meta:
		name = "__ismbcl1_l"
		size = 156
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0016 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0091 ??1_LocaleUpdate@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 83 EC 18 8B 45 0C 50 8D 4D F0 E8 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? 8B 48 04 81 79 04 A4 03 00 00 75 5A 8D 4D F0 E8 ?? ?? ?? ?? 8B 50 04 8B 45 08 C1 E8 08 0F B6 C8 0F B6 54 0A 1D 83 E2 04 74 3C 8D 4D F0 E8 ?? ?? ?? ?? 8B 40 04 8B 4D 08 81 E1 FF 00 00 00 0F B6 D1 0F B6 44 10 1D 83 E0 08 74 1B 81 7D 08 9F 88 00 00 72 12 81 7D 08 72 98 00 00 77 09 C7 45 E8 01 00 00 00 EB 07 C7 45 E8 00 00 00 00 8B 4D E8 89 4D EC 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 EC 8B E5 5D C3 }
	condition:
		$1
}

rule file_44_7_0 {
	meta:
		name = "__ismbcl2_l"
		size = 156
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0016 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0091 ??1_LocaleUpdate@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 83 EC 18 8B 45 0C 50 8D 4D F0 E8 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? 8B 48 04 81 79 04 A4 03 00 00 75 5A 8D 4D F0 E8 ?? ?? ?? ?? 8B 50 04 8B 45 08 C1 E8 08 0F B6 C8 0F B6 54 0A 1D 83 E2 04 74 3C 8D 4D F0 E8 ?? ?? ?? ?? 8B 40 04 8B 4D 08 81 E1 FF 00 00 00 0F B6 D1 0F B6 44 10 1D 83 E0 08 74 1B 81 7D 08 9F 98 00 00 72 12 81 7D 08 A4 EA 00 00 77 09 C7 45 E8 01 00 00 00 EB 07 C7 45 E8 00 00 00 00 8B 4D E8 89 4D EC 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 EC 8B E5 5D C3 }
	condition:
		$1
}

rule file_46_0_0 {
	meta:
		name = "__strtoi64"
		size = 69
		refs = "0005 ___locale_changed 001b ___initiallocalestructinfo 0020 ?strtoxq@@YA_KPAUlocaleinfo_struct@@PBDPAPBDHH@Z"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? 00 75 1F 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 EB 1A EB 18 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 6A 00 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_653_0_0 {
	meta:
		name = "__wcstoi64"
		size = 69
		refs = "0005 ___locale_changed 001b ___initiallocalestructinfo 0020 ?wcstoxq@@YA_KPAUlocaleinfo_struct@@PB_WPAPB_WHH@Z"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? 00 75 1F 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 EB 1A EB 18 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 6A 00 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_541_0_0 {
	meta:
		name = "_strtol"
		size = 69
		refs = "0005 ___locale_changed 001b ___initiallocalestructinfo 0020 ?strtoxl@@YAKPAUlocaleinfo_struct@@PBDPAPBDHH@Z"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? 00 75 1F 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 EB 1A EB 18 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 6A 00 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_256_0_0 {
	meta:
		name = "_wcstol"
		size = 69
		refs = "0005 ___locale_changed 001b ___initiallocalestructinfo 0020 ?wcstoxl@@YAKPAUlocaleinfo_struct@@PB_WPAPB_WHH@Z"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? 00 75 1F 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 EB 1A EB 18 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 6A 00 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_46_1_0 {
	meta:
		name = "?strtoxq@@YA_KPAUlocaleinfo_struct@@PBDPAPBDHH@Z"
		size = 1305
		refs = "0006 __ehhandler$?strtoxq@@YA_KPAUlocaleinfo_struct@@PBDPAPBDHH@Z 0017 ___security_cookie 002f ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 005b ??_C@_1BK@LAOAACLJ@?$AAn?$AAp?$AAt?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0064 ??_C@_1BC@MIDDLJDN@?$AAs?$AAt?$AAr?$AAt?$AAo?$AAq?$AA?4?$AAc?$AA?$AA@ 006b __CrtDbgReportW 007f __errno 0093 ??_C@_1BA@BMMDEPNE@?$AAs?$AAt?$AAr?$AAt?$AAo?$AAx?$AAq?$AA?$AA@ 009d __invalid_parameter 00bd ??1_LocaleUpdate@@QAE@XZ 00fb ??_C@_1FE@CEHLKAHD@?$AAi?$AAb?$AAa?$AAs?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AA?$CI?$AA2?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAi?$AAb?$AAa?$AAs?$AAe?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAi?$AAb?$AAa@ 0195 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 01c1 __isctype_l 01de __chvalidator_l 02c8 __aulldiv 0396 __aullrem 03c7 __allmul"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 6C 56 57 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 8B 45 08 50 8D 4D D0 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 83 7D 10 00 74 08 8B 4D 10 8B 55 0C 89 11 33 C0 83 7D 0C 00 0F 95 C0 89 45 C0 83 7D C0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 5E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D C0 00 75 4E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 5E 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 B4 00 00 00 00 C7 45 B8 00 00 00 00 C7 45 FC FF FF FF FF 8D 4D D0 E8 ?? ?? ?? ?? 8B 45 B4 8B 55 B8 E9 3C 04 00 00 83 7D 14 00 74 15 83 7D 14 02 7C 06 83 7D 14 24 7E 09 C7 45 A0 00 00 00 00 EB 07 C7 45 A0 01 00 00 00 8B 55 A0 89 55 BC 83 7D BC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 5F 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D BC 00 75 4E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 5F 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 AC 00 00 00 00 C7 45 B0 00 00 00 00 C7 45 FC FF FF FF FF 8D 4D D0 E8 ?? ?? ?? ?? 8B 45 AC 8B 55 B0 E9 9C 03 00 00 8B 4D 0C 89 4D F0 C7 45 C4 00 00 00 00 C7 45 C8 00 00 00 00 8B 55 F0 8A 02 88 45 E3 8B 4D F0 83 C1 01 89 4D F0 8D 4D D0 E8 ?? ?? ?? ?? 85 C0 74 30 8D 4D D0 E8 ?? ?? ?? ?? 8B 10 83 BA AC 00 00 00 01 7E 1D 8D 4D D0 E8 ?? ?? ?? ?? 50 6A 08 0F B6 45 E3 50 E8 ?? ?? ?? ?? 83 C4 0C 89 45 9C EB 1B 6A 08 0F B6 4D E3 51 8D 4D D0 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 0C 89 45 9C 83 7D 9C 00 74 13 8B 55 F0 8A 02 88 45 E3 8B 4D F0 83 C1 01 89 4D F0 EB 90 0F BE 55 E3 83 FA 2D 75 1C 8B 45 18 83 C8 02 89 45 18 8B 4D F0 8A 11 88 55 E3 8B 45 F0 83 C0 01 89 45 F0 EB 1A 0F BE 4D E3 83 F9 2B 75 11 8B 55 F0 8A 02 88 45 E3 8B 4D F0 83 C1 01 89 4D F0 83 7D 14 00 75 38 0F BE 55 E3 83 FA 30 74 09 C7 45 14 0A 00 00 00 EB 26 8B 45 F0 0F BE 08 83 F9 78 74 0B 8B 55 F0 0F BE 02 83 F8 58 75 09 C7 45 14 10 00 00 00 EB 07 C7 45 14 08 00 00 00 83 7D 14 10 75 39 0F BE 4D E3 83 F9 30 75 30 8B 55 F0 0F BE 02 83 F8 78 74 0B 8B 4D F0 0F BE 11 83 FA 58 75 1A 8B 45 F0 83 C0 01 89 45 F0 8B 4D F0 8A 11 88 55 E3 8B 45 F0 83 C0 01 89 45 F0 8B 45 14 99 52 50 6A FF 6A FF E8 ?? ?? ?? ?? 89 45 E4 89 55 E8 6A 04 0F B6 4D E3 51 8D 4D D0 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0C 0F BE 55 E3 83 EA 30 89 55 EC EB 54 68 03 01 00 00 0F B6 45 E3 50 8D 4D D0 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 30 0F BE 4D E3 83 F9 61 7C 15 0F BE 55 E3 83 FA 7A 7F 0C 0F BE 45 E3 83 E8 20 89 45 98 EB 07 0F BE 4D E3 89 4D 98 8B 55 98 83 EA 37 89 55 EC EB 05 E9 B5 00 00 00 8B 45 EC 3B 45 14 72 05 E9 A8 00 00 00 8B 4D 18 83 C9 08 89 4D 18 8B 55 C8 3B 55 E8 72 4C 77 08 8B 45 C4 3B 45 E4 72 42 8B 4D C4 3B 4D E4 75 5E 8B 55 C8 3B 55 E8 75 56 8B 75 EC 33 FF 8B 45 14 99 52 50 6A FF 6A FF E8 ?? ?? ?? ?? 89 75 90 89 7D 94 89 45 88 89 55 8C 8B 45 94 3B 45 8C 77 2E 72 08 8B 4D 90 3B 4D 88 77 24 8B 45 14 99 52 50 8B 55 C8 52 8B 45 C4 50 E8 ?? ?? ?? ?? 8B 4D EC 33 F6 03 C1 13 D6 89 45 C4 89 55 C8 EB 11 8B 55 18 83 CA 04 89 55 18 83 7D 10 00 75 02 EB 16 8B 45 F0 8A 08 88 4D E3 8B 55 F0 83 C2 01 89 55 F0 E9 CF FE FF FF 8B 45 F0 83 E8 01 89 45 F0 8B 4D 18 83 E1 08 75 1F 83 7D 10 00 74 06 8B 55 0C 89 55 F0 C7 45 C4 00 00 00 00 C7 45 C8 00 00 00 00 E9 8B 00 00 00 8B 45 18 83 E0 04 75 3A 8B 4D 18 83 E1 01 75 7B 8B 55 18 83 E2 02 74 11 81 7D C8 00 00 00 80 77 21 72 06 83 7D C4 00 77 19 8B 45 18 83 E0 02 75 5A 81 7D C8 FF FF FF 7F 72 51 77 06 83 7D C4 FF 76 49 E8 ?? ?? ?? ?? C7 00 22 00 00 00 8B 4D 18 83 E1 01 74 10 C7 45 C4 FF FF FF FF C7 45 C8 FF FF FF FF EB 26 8B 55 18 83 E2 02 74 10 C7 45 C4 00 00 00 00 C7 45 C8 00 00 00 80 EB 0E C7 45 C4 FF FF FF FF C7 45 C8 FF FF FF 7F 83 7D 10 00 74 08 8B 45 10 8B 4D F0 89 08 8B 55 18 83 E2 02 74 13 8B 45 C4 F7 D8 8B 4D C8 83 D1 00 F7 D9 89 45 C4 89 4D C8 8B 55 C4 89 55 A4 8B 45 C8 89 45 A8 C7 45 FC FF FF FF FF 8D 4D D0 E8 ?? ?? ?? ?? 8B 45 A4 8B 55 A8 8B 4D F4 64 89 0D 00 00 00 00 59 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_46_3_0 {
	meta:
		name = "__ehhandler$?strtoxq@@YA_KPAUlocaleinfo_struct@@PBDPAPBDHH@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?strtoxq@@YA_KPAUlocaleinfo_struct@@PBDPAPBDHH@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A 88 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_46_7_0 {
	meta:
		name = "__strtoi64_l"
		size = 31
		refs = "0016 ?strtoxq@@YA_KPAUlocaleinfo_struct@@PBDPAPBDHH@Z"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 8B 45 14 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_541_7_0 {
	meta:
		name = "__strtol_l"
		size = 31
		refs = "0016 ?strtoxl@@YAKPAUlocaleinfo_struct@@PBDPAPBDHH@Z"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 8B 45 14 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_653_7_0 {
	meta:
		name = "__wcstoi64_l"
		size = 31
		refs = "0016 ?wcstoxq@@YA_KPAUlocaleinfo_struct@@PB_WPAPB_WHH@Z"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 8B 45 14 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_256_7_0 {
	meta:
		name = "__wcstol_l"
		size = 31
		refs = "0016 ?wcstoxl@@YAKPAUlocaleinfo_struct@@PB_WPAPB_WHH@Z"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 8B 45 14 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_46_8_0 {
	meta:
		name = "__strtoui64"
		size = 69
		refs = "0005 ___locale_changed 001b ___initiallocalestructinfo 0020 ?strtoxq@@YA_KPAUlocaleinfo_struct@@PBDPAPBDHH@Z"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? 00 75 1F 6A 01 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 EB 1A EB 18 6A 01 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 6A 00 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_653_8_0 {
	meta:
		name = "__wcstoui64"
		size = 69
		refs = "0005 ___locale_changed 001b ___initiallocalestructinfo 0020 ?wcstoxq@@YA_KPAUlocaleinfo_struct@@PB_WPAPB_WHH@Z"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? 00 75 1F 6A 01 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 EB 1A EB 18 6A 01 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 6A 00 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_541_8_0 {
	meta:
		name = "_strtoul"
		size = 69
		refs = "0005 ___locale_changed 001b ___initiallocalestructinfo 0020 ?strtoxl@@YAKPAUlocaleinfo_struct@@PBDPAPBDHH@Z"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? 00 75 1F 6A 01 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 EB 1A EB 18 6A 01 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 6A 00 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_256_8_0 {
	meta:
		name = "_wcstoul"
		size = 69
		refs = "0005 ___locale_changed 001b ___initiallocalestructinfo 0020 ?wcstoxl@@YAKPAUlocaleinfo_struct@@PB_WPAPB_WHH@Z"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? 00 75 1F 6A 01 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 EB 1A EB 18 6A 01 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 6A 00 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_46_9_0 {
	meta:
		name = "__strtoui64_l"
		size = 31
		refs = "0016 ?strtoxq@@YA_KPAUlocaleinfo_struct@@PBDPAPBDHH@Z"
	strings:
		$1 = { 55 8B EC 6A 01 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 8B 45 14 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_541_9_0 {
	meta:
		name = "__strtoul_l"
		size = 31
		refs = "0016 ?strtoxl@@YAKPAUlocaleinfo_struct@@PBDPAPBDHH@Z"
	strings:
		$1 = { 55 8B EC 6A 01 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 8B 45 14 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_653_9_0 {
	meta:
		name = "__wcstoui64_l"
		size = 31
		refs = "0016 ?wcstoxq@@YA_KPAUlocaleinfo_struct@@PB_WPAPB_WHH@Z"
	strings:
		$1 = { 55 8B EC 6A 01 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 8B 45 14 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_256_9_0 {
	meta:
		name = "__wcstoul_l"
		size = 31
		refs = "0016 ?wcstoxl@@YAKPAUlocaleinfo_struct@@PB_WPAPB_WHH@Z"
	strings:
		$1 = { 55 8B EC 6A 01 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 8B 45 14 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_47_0_0 {
	meta:
		name = "__wfullpath"
		size = 31
		refs = "0016 __wfullpath_dbg"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 01 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_376_5_0 {
	meta:
		name = "__dupenv_s"
		size = 31
		refs = "0016 __dupenv_s_dbg"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 01 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_576_0_0 {
	meta:
		name = "__fullpath"
		size = 31
		refs = "0016 __fullpath_dbg"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 01 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_465_4_0 {
	meta:
		name = "__getdcwd_nolock"
		size = 31
		refs = "0016 __getdcwd_lk_dbg"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 01 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_456_5_0 {
	meta:
		name = "__wdupenv_s"
		size = 31
		refs = "0016 __wdupenv_s_dbg"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 01 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_565_4_0 {
	meta:
		name = "__wgetdcwd_nolock"
		size = 31
		refs = "0016 __wgetdcwd_lk_dbg"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 01 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_47_1_0 {
	meta:
		name = "__wfullpath_dbg"
		size = 432
		refs = "001f __wgetcwd 0041 __imp__GetFullPathNameW@16 0050 __imp__GetLastError@0 0056 __dosmaperr 008a __errno 00ae __calloc_dbg 00e1 ??_C@_1BK@NOHKJANJ@?$AA?$CI?$AAm?$AAa?$AAx?$AAl?$AAe?$AAn?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$CJ?$AA?$AA@ 00ed ??_C@_1GG@LGODIJGP@?$AAf?$AA?3?$AA?2?$AAr?$AAt?$AAm?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2@ 00f4 __CrtDbgReportW 011f ??_C@_1BO@ECCJIFJJ@?$AA_?$AAw?$AAf?$AAu?$AAl?$AAl?$AAp?$AAa?$AAt?$AAh?$AA_?$AAd?$AAb?$AAg?$AA?$AA@ 0129 __invalid_parameter 0166 _free"
	strings:
		$1 = { 55 8B EC 83 EC 14 83 7D 0C 00 74 0A 8B 45 0C 0F B7 08 85 C9 75 15 8B 55 10 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 E9 81 01 00 00 83 7D 08 00 0F 85 9D 00 00 00 6A 00 6A 00 6A 00 8B 4D 0C 51 FF 15 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 75 16 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 33 C0 E9 48 01 00 00 8B 55 10 3B 55 FC 76 08 8B 45 10 89 45 EC EB 06 8B 4D FC 89 4D EC 8B 55 EC 89 55 10 81 7D 10 FF FF FF 7F 76 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 33 C0 E9 11 01 00 00 8B 45 1C 50 8B 4D 18 51 8B 55 14 52 6A 02 8B 45 10 50 E8 ?? ?? ?? ?? 83 C4 14 89 45 F4 83 7D F4 00 75 12 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 33 C0 E9 DC 00 00 00 EB 68 33 C9 3B 4D 10 1B D2 F7 DA 89 55 F0 75 21 68 ?? ?? ?? ?? 6A 00 68 84 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 84 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 78 8B 4D 08 89 4D F4 8D 55 F8 52 8B 45 F4 50 8B 4D 10 51 8B 55 0C 52 FF 15 ?? ?? ?? ?? 89 45 FC 8B 45 FC 3B 45 10 72 23 83 7D 08 00 75 0C 8B 4D F4 51 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? C7 00 22 00 00 00 33 C0 EB 30 EB 2B 83 7D FC 00 75 25 83 7D 08 00 75 0C 8B 55 F4 52 E8 ?? ?? ?? ?? 83 C4 04 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 33 C0 EB 03 8B 45 F4 8B E5 5D C3 }
	condition:
		$1
}

rule file_48_0_0 {
	meta:
		name = "__execlpe"
		size = 453
		refs = "0019 ??_C@_1CC@JBMDNKJP@?$AAf?$AAi?$AAl?$AAe?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0022 ??_C@_1BE@MOBGLCDC@?$AAe?$AAx?$AAe?$AAc?$AAl?$AAp?$AAe?$AA?4?$AAc?$AA?$AA@ 0029 __CrtDbgReportW 003d __errno 0051 ??_C@_1BC@GKCEFOCP@?$AA_?$AAe?$AAx?$AAe?$AAc?$AAl?$AAp?$AAe?$AA?$AA@ 005b __invalid_parameter 007c ??_C@_1CM@DMCMCPME@?$AA?$CK?$AAf?$AAi?$AAl?$AAe?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 00e0 ??_C@_1CA@MOAFCHEI@?$AAa?$AAr?$AAg?$AAl?$AAi?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0143 ??_C@_1CK@PKCLGCC@?$AA?$CK?$AAa?$AAr?$AAg?$AAl?$AAi?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 01ba __execvpe"
	strings:
		$1 = { 55 8B EC 83 EC 14 33 C0 83 7D 08 00 0F 95 C0 89 45 F8 83 7D F8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 33 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F8 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 33 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 57 01 00 00 8B 55 08 0F BE 02 F7 D8 1B C0 F7 D8 89 45 F4 75 1E 68 ?? ?? ?? ?? 6A 00 6A 34 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F4 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 34 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 F4 00 00 00 33 D2 83 7D 0C 00 0F 95 C2 89 55 F0 83 7D F0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 35 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 35 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 90 00 00 00 8B 4D 0C 0F BE 11 F7 DA 1B D2 F7 DA 89 55 EC 75 1E 68 ?? ?? ?? ?? 6A 00 6A 36 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D EC 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 36 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 30 8D 4D 0C 89 4D FC 8B 55 FC 8B 02 8B 4D FC 83 C1 04 89 4D FC 85 C0 74 02 EB EC 8B 55 FC 8B 02 50 8D 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_49_0_0 {
	meta:
		name = "__get_sse2_info"
		size = 111
		refs = "0059 _has_osfxsr_set"
	strings:
		$1 = { 55 8B EC 83 EC 18 53 C7 45 FC 00 00 00 00 C7 45 F4 00 00 00 00 C7 45 F8 00 00 00 00 53 9C 58 8B C8 35 00 00 20 00 50 9D 9C 5A 2B D1 74 1F 51 9D 33 C0 0F A2 89 45 F4 89 5D E8 89 55 EC 89 4D F0 B8 01 00 00 00 0F A2 89 55 FC 89 45 F8 5B 8B 45 FC 25 00 00 00 04 74 10 E8 ?? ?? ?? ?? 85 C0 74 07 B8 01 00 00 00 EB 02 33 C0 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_49_1_0 {
	meta:
		name = "_has_osfxsr_set"
		size = 171
		refs = "0006 __sehtable$_has_osfxsr_set 000b __except_handler4 001d ___security_cookie"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 EC 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 89 65 E8 C7 45 E4 00 00 00 00 C7 45 FC 00 00 00 00 66 0F 28 C1 C7 45 E4 01 00 00 00 C7 45 FC FE FF FF FF EB 41 8B 45 EC 8B 08 8B 11 89 55 E0 81 7D E0 05 00 00 C0 74 12 81 7D E0 1D 00 00 C0 74 09 C7 45 DC 00 00 00 00 EB 07 C7 45 DC 01 00 00 00 8B 45 DC C3 8B 65 E8 C7 45 E4 00 00 00 00 C7 45 FC FE FF FF FF 8B 45 E4 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_49_2_0 {
	meta:
		name = "___sse2_available_init"
		size = 17
		refs = "0004 __get_sse2_info 0009 ___sse2_available"
	strings:
		$1 = { 55 8B EC E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 33 C0 5D C3 }
	condition:
		$1
}

rule file_50_0_0 {
	meta:
		name = "__EH_prolog3"
		size = 51
		refs = "0018 ___security_cookie"
	strings:
		$1 = { 50 64 FF 35 00 00 00 00 8D 44 24 0C 2B 64 24 0C 53 56 57 89 28 8B E8 A1 ?? ?? ?? ?? 33 C5 50 FF 75 FC C7 45 FC FF FF FF FF 8D 45 F4 64 A3 00 00 00 00 C3 }
	condition:
		$1
}

rule file_50_1_0 {
	meta:
		name = "__EH_prolog3_catch"
		size = 54
		refs = "0018 ___security_cookie"
	strings:
		$1 = { 50 64 FF 35 00 00 00 00 8D 44 24 0C 2B 64 24 0C 53 56 57 89 28 8B E8 A1 ?? ?? ?? ?? 33 C5 50 89 65 F0 FF 75 FC C7 45 FC FF FF FF FF 8D 45 F4 64 A3 00 00 00 00 C3 }
	condition:
		$1
}

rule file_50_2_0 {
	meta:
		name = "__EH_prolog3_GS"
		size = 54
		refs = "0018 ___security_cookie"
	strings:
		$1 = { 50 64 FF 35 00 00 00 00 8D 44 24 0C 2B 64 24 0C 53 56 57 89 28 8B E8 A1 ?? ?? ?? ?? 33 C5 50 89 45 F0 FF 75 FC C7 45 FC FF FF FF FF 8D 45 F4 64 A3 00 00 00 00 C3 }
	condition:
		$1
}

rule file_50_3_0 {
	meta:
		name = "__EH_prolog3_catch_GS"
		size = 57
		refs = "0018 ___security_cookie"
	strings:
		$1 = { 50 64 FF 35 00 00 00 00 8D 44 24 0C 2B 64 24 0C 53 56 57 89 28 8B E8 A1 ?? ?? ?? ?? 33 C5 50 89 45 EC 89 65 F0 FF 75 FC C7 45 FC FF FF FF FF 8D 45 F4 64 A3 00 00 00 00 C3 }
	condition:
		$1
}

rule file_50_4_0 {
	meta:
		name = "__EH_epilog3"
		size = 20
	strings:
		$1 = { 8B 4D F4 64 89 0D 00 00 00 00 59 5F 5F 5E 5B 8B E5 5D 51 C3 }
	condition:
		$1
}

rule file_51_0_0 {
	meta:
		name = "__wspawnlp"
		size = 422
		refs = "0019 ??_C@_1CC@JBMDNKJP@?$AAf?$AAi?$AAl?$AAe?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0022 ??_C@_1GE@KECGFCAK@?$AAf?$AA?3?$AA?2?$AAr?$AAt?$AAm?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2@ 0029 __CrtDbgReportW 003d __errno 0051 ??_C@_1BE@BLAGFGFA@?$AA_?$AAw?$AAs?$AAp?$AAa?$AAw?$AAn?$AAl?$AAp?$AA?$AA@ 005b __invalid_parameter 007c ??_C@_1CM@DMCMCPME@?$AA?$CK?$AAf?$AAi?$AAl?$AAe?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 00e0 ??_C@_1CA@MOAFCHEI@?$AAa?$AAr?$AAg?$AAl?$AAi?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0140 ??_C@_1CK@PKCLGCC@?$AA?$CK?$AAa?$AAr?$AAg?$AAl?$AAi?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 019b __wspawnvp"
	strings:
		$1 = { 55 8B EC 83 EC 10 33 C0 83 7D 0C 00 0F 95 C0 89 45 FC 83 7D FC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 39 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D FC 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 39 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 38 01 00 00 8B 55 0C 0F B7 02 F7 D8 1B C0 F7 D8 89 45 F8 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3A 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F8 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 3A 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 D5 00 00 00 33 D2 83 7D 10 00 0F 95 C2 89 55 F4 83 7D F4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3B 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F4 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 3B 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 74 8B 4D 10 0F B7 11 F7 DA 1B D2 F7 DA 89 55 F0 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3C 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 3C 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 14 8D 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_52_0_0 {
	meta:
		name = "__woutput_s_l"
		size = 4556
		refs = "000a ___security_cookie 004f ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0073 ??_C@_1CC@FADMNIL@?$AA?$CI?$AAs?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 007f ??_C@_1GC@ELIAPJJM@?$AAf?$AA?3?$AA?2?$AAr?$AAt?$AAm?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2@ 0086 __CrtDbgReportW 009d __errno 00b4 ??_C@_1BK@ONMFGLDB@?$AA_?$AAw?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAs?$AA_?$AAl?$AA?$AA@ 00be __invalid_parameter 00d3 ??1_LocaleUpdate@@QAE@XZ 00fb ??_C@_1CC@MGIEJOME@?$AA?$CI?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 01e7 ___lookuptable_s 0248 ??_C@_1CM@IEGCDOKE@?$AA?$CI?$AAs?$AAt?$AAa?$AAt?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAS?$AAT?$AA_?$AAI?$AAN?$AAV?$AAA?$AAL?$AAI?$AAD?$AA?$CJ?$AA?$AA@ 02d9 $LN160 02f8 _write_char 0365 $LN156 036c $LN161 03be _get_int_arg 047b $LN157 0482 $LN162 05b8 $LN158 05bf $LN163 0616 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 063b __mbtowc_l 069b ___nullstring 06a7 _strlen 07b3 __isleadbyte_l 07e7 ___wnullstring 085b __get_printf_count_output 0897 ??_C@_1EK@PNGFDECN@?$AA?$CI?$AA?$CC?$AA?8?$AAn?$AA?8?$AA?5?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AAs?$AAp?$AAe?$AAc?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?5?$AAd?$AAi?$AAs?$AAa?$AAb?$AAl?$AAe?$AAd?$AA?$CC@ 09b9 ??_C@_0DB@FNNAMKJO@f?3?2rtm?2vctools?2crt_bld?2self_x86?2@ 09c9 __malloc_dbg 0a3c __cfltcvt_tab 0a42 __decode_pointer 0b7d _get_int64_arg 0d4f __aullrem 0d71 __aulldiv 0e82 _write_multi_char 0e9d _write_string 0fe3 __free_dbg 1034 ??_C@_1FK@LNCFKALM@?$AA?$CI?$AA?$CI?$AAs?$AAt?$AAa?$AAt?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAS?$AAT?$AA_?$AAN?$AAO?$AAR?$AAM?$AAA?$AAL?$AA?$CJ?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AA?$CI?$AAs?$AAt?$AAa?$AAt?$AAe?$AA?5@ 10c0 @__security_check_cookie@4 10c8 $NORMAL_STATE$26268 10cc $LN132 10d0 $LN131 10d4 $LN123 10d8 $LN119 10dc $LN118 10e0 $LN114 10e4 $LN98 10e8 $LN126 10ec $LN125 10f0 $LN127 10f4 $LN128 10f8 $LN124 10fc $LN129 1114 $LN108 1118 $LN100 111c $LN111 1120 $LN99 1124 $LN112 1158 $LN65 115c $LN95 1160 $LN83 1164 $LN47 1168 $LN89 116c $LN64 1170 $LN93 1174 $LN52 1178 $LN70 117c $LN42 1180 $LN48 1184 $LN81 1188 $LN50 118c $LN45 1190 $LN96"
	strings:
		$1 = { 55 8B EC 81 EC F4 04 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 B8 C7 85 A0 FB FF FF 00 00 00 00 C7 45 F0 00 00 00 00 C7 45 E8 00 00 00 00 C7 45 D0 00 00 00 00 C7 45 E4 00 00 00 00 C7 45 D8 00 00 00 00 C7 45 F4 00 00 00 00 8B 45 10 50 8D 4D C0 E8 ?? ?? ?? ?? C7 45 E0 00 00 00 00 33 C9 83 7D 08 00 0F 95 C1 89 8D 9C FB FF FF 83 BD 9C FB FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 07 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 9C FB FF FF 00 75 46 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 07 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 40 FB FF FF FF FF FF FF 8D 4D C0 E8 ?? ?? ?? ?? 8B 85 40 FB FF FF E9 D8 0F 00 00 33 C0 83 7D 0C 00 0F 95 C0 89 85 98 FB FF FF 83 BD 98 FB FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 0C 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 98 FB FF FF 00 75 46 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 0C 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 3C FB FF FF FF FF FF FF 8D 4D C0 E8 ?? ?? ?? ?? 8B 85 3C FB FF FF E9 50 0F 00 00 C7 85 B4 FB FF FF 00 00 00 00 C7 45 DC 00 00 00 00 C7 85 A4 FB FF FF 00 00 00 00 C7 45 E0 00 00 00 00 C7 45 BC 00 00 00 00 8B 55 0C 66 8B 02 66 89 85 AC FB FF FF 0F B7 8D AC FB FF FF 8B 55 0C 83 C2 02 89 55 0C 85 C9 0F 84 3E 0E 00 00 83 BD B4 FB FF FF 00 0F 8C 31 0E 00 00 0F B7 85 AC FB FF FF 83 F8 20 7C 25 0F B7 8D AC FB FF FF 83 F9 78 7F 19 0F B7 95 AC FB FF FF 0F B6 82 ?? ?? ?? ?? 83 E0 0F 89 85 28 FB FF FF EB 0A C7 85 28 FB FF FF 00 00 00 00 8B 8D 28 FB FF FF 89 8D B0 FB FF FF 8B 95 B0 FB FF FF 6B D2 09 8B 85 A4 FB FF FF 0F B6 8C 02 ?? ?? ?? ?? C1 F9 04 89 8D A4 FB FF FF 33 D2 83 BD A4 FB FF FF 08 0F 95 C2 89 95 94 FB FF FF 83 BD 94 FB FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 63 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 94 FB FF FF 00 75 46 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 63 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 38 FB FF FF FF FF FF FF 8D 4D C0 E8 ?? ?? ?? ?? 8B 85 38 FB FF FF E9 03 0E 00 00 8B 8D A4 FB FF FF 89 8D 24 FB FF FF 83 BD 24 FB FF FF 07 0F 87 21 0D 00 00 8B 95 24 FB FF FF FF 24 95 ?? ?? ?? ?? C7 45 F4 01 00 00 00 8D 85 B4 FB FF FF 50 8B 4D 08 51 66 8B 95 AC FB FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C E9 ED 0C 00 00 C7 45 D4 00 00 00 00 8B 45 D4 89 45 D8 8B 4D D8 89 4D E8 8B 55 E8 89 55 E4 C7 45 F0 00 00 00 00 C7 45 D0 FF FF FF FF C7 45 F4 00 00 00 00 E9 BA 0C 00 00 0F B7 85 AC FB FF FF 89 85 20 FB FF FF 8B 8D 20 FB FF FF 83 E9 20 89 8D 20 FB FF FF 83 BD 20 FB FF FF 10 77 4C 8B 95 20 FB FF FF 0F B6 82 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 8B 4D F0 83 C9 04 89 4D F0 EB 2D 8B 55 F0 83 CA 01 89 55 F0 EB 22 8B 45 F0 83 C8 02 89 45 F0 EB 17 8B 4D F0 81 C9 80 00 00 00 89 4D F0 EB 09 8B 55 F0 83 CA 08 89 55 F0 E9 44 0C 00 00 0F B7 85 AC FB FF FF 83 F8 2A 75 28 8D 4D 14 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 E8 83 7D E8 00 7D 11 8B 55 F0 83 CA 04 89 55 F0 8B 45 E8 F7 D8 89 45 E8 EB 14 8B 4D E8 6B C9 0A 0F B7 95 AC FB FF FF 8D 44 11 D0 89 45 E8 E9 F7 0B 00 00 C7 45 D0 00 00 00 00 E9 EB 0B 00 00 0F B7 8D AC FB FF FF 83 F9 2A 75 1E 8D 55 14 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 D0 83 7D D0 00 7D 07 C7 45 D0 FF FF FF FF EB 14 8B 45 D0 6B C0 0A 0F B7 8D AC FB FF FF 8D 54 08 D0 89 55 D0 E9 A8 0B 00 00 0F B7 85 AC FB FF FF 89 85 1C FB FF FF 8B 8D 1C FB FF FF 83 E9 49 89 8D 1C FB FF FF 83 BD 1C FB FF FF 2E 0F 87 0F 01 00 00 8B 95 1C FB FF FF 0F B6 82 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 8B 4D 0C 0F B7 11 83 FA 6C 75 17 8B 45 0C 83 C0 02 89 45 0C 8B 4D F0 81 C9 00 10 00 00 89 4D F0 EB 09 8B 55 F0 83 CA 10 89 55 F0 E9 CB 00 00 00 8B 45 0C 0F B7 08 83 F9 36 75 26 8B 55 0C 0F B7 42 02 83 F8 34 75 1A 8B 4D 0C 83 C1 04 89 4D 0C 8B 55 F0 81 CA 00 80 00 00 89 55 F0 E9 81 00 00 00 8B 45 0C 0F B7 08 83 F9 33 75 23 8B 55 0C 0F B7 42 02 83 F8 32 75 17 8B 4D 0C 83 C1 04 89 4D 0C 8B 55 F0 81 E2 FF 7F FF FF 89 55 F0 EB 53 8B 45 0C 0F B7 08 83 F9 64 74 37 8B 55 0C 0F B7 02 83 F8 69 74 2C 8B 4D 0C 0F B7 11 83 FA 6F 74 21 8B 45 0C 0F B7 08 83 F9 75 74 16 8B 55 0C 0F B7 02 83 F8 78 74 0B 8B 4D 0C 0F B7 11 83 FA 58 75 02 EB 0F C7 85 A4 FB FF FF 00 00 00 00 E9 75 FD FF FF EB 17 8B 45 F0 83 C8 20 89 45 F0 EB 0C 8B 4D F0 81 C9 00 08 00 00 89 4D F0 E9 6B 0A 00 00 0F B7 95 AC FB FF FF 89 95 18 FB FF FF 8B 85 18 FB FF FF 83 E8 41 89 85 18 FB FF FF 83 BD 18 FB FF FF 37 0F 87 4F 08 00 00 8B 8D 18 FB FF FF 0F B6 91 ?? ?? ?? ?? FF 24 95 ?? ?? ?? ?? 8B 45 F0 25 30 08 00 00 75 09 8B 4D F0 83 C9 20 89 4D F0 C7 45 F4 01 00 00 00 8D 55 14 52 E8 ?? ?? ?? ?? 83 C4 04 66 89 85 A8 FB FF FF 8B 45 F0 83 E0 20 74 57 0F B7 8D A8 FB FF FF 81 E1 FF 00 00 00 88 8D 90 FB FF FF C6 85 91 FB FF FF 00 8D 4D C0 E8 ?? ?? ?? ?? 50 8D 4D C0 E8 ?? ?? ?? ?? 8B 10 8B 82 AC 00 00 00 50 8D 8D 90 FB FF FF 51 8D 95 B8 FB FF FF 52 E8 ?? ?? ?? ?? 83 C4 10 85 C0 7D 07 C7 45 D8 01 00 00 00 EB 0E 66 8B 85 A8 FB FF FF 66 89 85 B8 FB FF FF 8D 8D B8 FB FF FF 89 4D FC C7 45 DC 01 00 00 00 E9 8C 07 00 00 8D 55 14 52 E8 ?? ?? ?? ?? 83 C4 04 89 85 8C FB FF FF 83 BD 8C FB FF FF 00 74 0C 8B 85 8C FB FF FF 83 78 04 00 75 1A 8B 0D ?? ?? ?? ?? 89 4D FC 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 DC EB 4F 8B 45 F0 25 00 08 00 00 74 26 8B 8D 8C FB FF FF 8B 51 04 89 55 FC 8B 85 8C FB FF FF 0F BF 00 99 2B C2 D1 F8 89 45 DC C7 45 F4 01 00 00 00 EB 1F C7 45 F4 00 00 00 00 8B 8D 8C FB FF FF 8B 51 04 89 55 FC 8B 85 8C FB FF FF 0F BF 08 89 4D DC E9 F7 06 00 00 8B 55 F0 81 E2 30 08 00 00 75 09 8B 45 F0 83 C8 20 89 45 F0 83 7D D0 FF 75 0C C7 85 14 FB FF FF FF FF FF 7F EB 09 8B 4D D0 89 8D 14 FB FF FF 8B 95 14 FB FF FF 89 95 84 FB FF FF 8D 45 14 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 8B 4D F0 83 E1 20 0F 84 83 00 00 00 83 7D FC 00 75 09 8B 15 ?? ?? ?? ?? 89 55 FC 8B 45 FC 89 85 88 FB FF FF C7 45 DC 00 00 00 00 EB 09 8B 4D DC 83 C1 01 89 4D DC 8B 55 DC 3B 95 84 FB FF FF 7D 4C 8B 85 88 FB FF FF 0F BE 08 85 C9 74 3F 8D 4D C0 E8 ?? ?? ?? ?? 50 8B 95 88 FB FF FF 0F B6 02 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 0F 8B 8D 88 FB FF FF 83 C1 01 89 8D 88 FB FF FF 8B 95 88 FB FF FF 83 C2 01 89 95 88 FB FF FF EB A0 EB 63 83 7D FC 00 75 08 A1 ?? ?? ?? ?? 89 45 FC C7 45 F4 01 00 00 00 8B 4D FC 89 8D 80 FB FF FF 8B 95 84 FB FF FF 8B 85 84 FB FF FF 83 E8 01 89 85 84 FB FF FF 85 D2 74 1E 8B 8D 80 FB FF FF 0F B7 11 85 D2 74 11 8B 85 80 FB FF FF 83 C0 02 89 85 80 FB FF FF EB C9 8B 8D 80 FB FF FF 2B 4D FC D1 F9 89 4D DC E9 B6 05 00 00 8D 55 14 52 E8 ?? ?? ?? ?? 83 C4 04 89 85 7C FB FF FF E8 ?? ?? ?? ?? 85 C0 0F 85 A4 00 00 00 33 C0 74 0C C7 85 10 FB FF FF 01 00 00 00 EB 0A C7 85 10 FB FF FF 00 00 00 00 8B 8D 10 FB FF FF 89 8D 78 FB FF FF 83 BD 78 FB FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 98 06 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 78 FB FF FF 00 75 46 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 98 06 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 34 FB FF FF FF FF FF FF 8D 4D C0 E8 ?? ?? ?? ?? 8B 85 34 FB FF FF E9 B4 07 00 00 E9 F3 04 00 00 8B 45 F0 83 E0 20 74 12 8B 8D 7C FB FF FF 66 8B 95 B4 FB FF FF 66 89 11 EB 0E 8B 85 7C FB FF FF 8B 8D B4 FB FF FF 89 08 C7 45 D8 01 00 00 00 E9 BF 04 00 00 C7 45 D4 01 00 00 00 0F B7 95 AC FB FF FF 83 C2 20 66 89 95 AC FB FF FF 8B 45 F0 83 C8 40 89 45 F0 8D 8D B8 FB FF FF 89 4D FC C7 45 BC 00 02 00 00 83 7D D0 00 7D 09 C7 45 D0 06 00 00 00 EB 2B 83 7D D0 00 75 15 0F B7 95 AC FB FF FF 83 FA 67 75 09 C7 45 D0 01 00 00 00 EB 10 81 7D D0 00 02 00 00 7E 07 C7 45 D0 00 02 00 00 81 7D D0 A3 00 00 00 7E 41 68 DD 06 00 00 68 ?? ?? ?? ?? 6A 02 8B 45 D0 05 5D 01 00 00 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 E0 83 7D E0 00 74 14 8B 4D E0 89 4D FC 8B 55 D0 81 C2 5D 01 00 00 89 55 BC EB 07 C7 45 D0 A3 00 00 00 8B 45 14 83 C0 08 89 45 14 8B 4D 14 8B 51 F8 8B 41 FC 89 95 70 FB FF FF 89 85 74 FB FF FF 8D 4D C0 E8 ?? ?? ?? ?? 50 8B 4D D4 51 8B 55 D0 52 0F BE 85 AC FB FF FF 50 8B 4D BC 51 8B 55 FC 52 8D 85 70 FB FF FF 50 8B 0D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 04 FF D0 83 C4 1C 8B 55 F0 81 E2 80 00 00 00 74 27 83 7D D0 00 75 21 8D 4D C0 E8 ?? ?? ?? ?? 50 8B 45 FC 50 8B 0D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 04 FF D0 83 C4 08 0F B7 95 AC FB FF FF 83 FA 67 75 2B 8B 45 F0 25 80 00 00 00 75 21 8D 4D C0 E8 ?? ?? ?? ?? 50 8B 4D FC 51 8B 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 04 FF D0 83 C4 08 8B 45 FC 0F BE 08 83 F9 2D 75 15 8B 55 F0 81 CA 00 01 00 00 89 55 F0 8B 45 FC 83 C0 01 89 45 FC 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 DC E9 13 03 00 00 8B 55 F0 83 CA 40 89 55 F0 C7 45 F8 0A 00 00 00 EB 70 C7 45 F8 0A 00 00 00 EB 67 C7 45 D0 08 00 00 00 C7 85 A0 FB FF FF 07 00 00 00 EB 0A C7 85 A0 FB FF FF 27 00 00 00 C7 45 F8 10 00 00 00 8B 45 F0 25 80 00 00 00 74 1A 66 C7 45 EC 30 00 8B 8D A0 FB FF FF 83 C1 51 66 89 4D EE C7 45 E4 02 00 00 00 EB 1D C7 45 F8 08 00 00 00 8B 55 F0 81 E2 80 00 00 00 74 0B 8B 45 F0 0D 00 02 00 00 89 45 F0 8B 4D F0 81 E1 00 80 00 00 74 1D 8D 55 14 52 E8 ?? ?? ?? ?? 83 C4 04 89 85 60 FB FF FF 89 95 64 FB FF FF E9 B0 00 00 00 8B 45 F0 25 00 10 00 00 74 1D 8D 4D 14 51 E8 ?? ?? ?? ?? 83 C4 04 89 85 60 FB FF FF 89 95 64 FB FF FF E9 89 00 00 00 8B 55 F0 83 E2 20 74 44 8B 45 F0 83 E0 40 74 1E 8D 4D 14 51 E8 ?? ?? ?? ?? 83 C4 04 0F BF C0 99 89 85 60 FB FF FF 89 95 64 FB FF FF EB 1C 8D 55 14 52 E8 ?? ?? ?? ?? 83 C4 04 0F B7 C0 99 89 85 60 FB FF FF 89 95 64 FB FF FF EB 3D 8B 45 F0 83 E0 40 74 1B 8D 4D 14 51 E8 ?? ?? ?? ?? 83 C4 04 99 89 85 60 FB FF FF 89 95 64 FB FF FF EB 1A 8D 55 14 52 E8 ?? ?? ?? ?? 83 C4 04 33 C9 89 85 60 FB FF FF 89 8D 64 FB FF FF 8B 55 F0 83 E2 40 74 41 83 BD 64 FB FF FF 00 7F 38 7C 09 83 BD 60 FB FF FF 00 73 2D 8B 85 60 FB FF FF F7 D8 8B 8D 64 FB FF FF 83 D1 00 F7 D9 89 85 58 FB FF FF 89 8D 5C FB FF FF 8B 55 F0 81 CA 00 01 00 00 89 55 F0 EB 18 8B 85 60 FB FF FF 89 85 58 FB FF FF 8B 8D 64 FB FF FF 89 8D 5C FB FF FF 8B 55 F0 81 E2 00 80 00 00 75 25 8B 45 F0 25 00 10 00 00 75 1B 8B 8D 58 FB FF FF 8B 95 5C FB FF FF 83 E2 00 89 8D 58 FB FF FF 89 95 5C FB FF FF 83 7D D0 00 7D 09 C7 45 D0 01 00 00 00 EB 19 8B 45 F0 83 E0 F7 89 45 F0 81 7D D0 00 02 00 00 7E 07 C7 45 D0 00 02 00 00 8B 8D 58 FB FF FF 0B 8D 5C FB FF FF 75 07 C7 45 E4 00 00 00 00 8D 95 B7 FD FF FF 89 55 FC 8B 45 D0 8B 4D D0 83 E9 01 89 4D D0 85 C0 7F 0E 8B 95 58 FB FF FF 0B 95 5C FB FF FF 74 7B 8B 45 F8 99 52 50 8B 85 5C FB FF FF 50 8B 8D 58 FB FF FF 51 E8 ?? ?? ?? ?? 83 C0 30 89 85 6C FB FF FF 8B 45 F8 99 52 50 8B 95 5C FB FF FF 52 8B 85 58 FB FF FF 50 E8 ?? ?? ?? ?? 89 85 58 FB FF FF 89 95 5C FB FF FF 83 BD 6C FB FF FF 39 7E 12 8B 8D 6C FB FF FF 03 8D A0 FB FF FF 89 8D 6C FB FF FF 8B 55 FC 8A 85 6C FB FF FF 88 02 8B 4D FC 83 E9 01 89 4D FC E9 67 FF FF FF 8D 95 B7 FD FF FF 2B 55 FC 89 55 DC 8B 45 FC 83 C0 01 89 45 FC 8B 4D F0 81 E1 00 02 00 00 74 29 83 7D DC 00 74 0B 8B 55 FC 0F BE 02 83 F8 30 74 18 8B 4D FC 83 E9 01 89 4D FC 8B 55 FC C6 02 30 8B 45 DC 83 C0 01 89 45 DC 83 7D D8 00 0F 85 CE 01 00 00 8B 4D F0 83 E1 40 74 46 8B 55 F0 81 E2 00 01 00 00 74 0F 66 C7 45 EC 2D 00 C7 45 E4 01 00 00 00 EB 2C 8B 45 F0 83 E0 01 74 0F 66 C7 45 EC 2B 00 C7 45 E4 01 00 00 00 EB 15 8B 4D F0 83 E1 02 74 0D 66 C7 45 EC 20 00 C7 45 E4 01 00 00 00 8B 55 E8 2B 55 DC 2B 55 E4 89 95 54 FB FF FF 8B 45 F0 83 E0 0C 75 1C 8D 8D B4 FB FF FF 51 8B 55 08 52 8B 85 54 FB FF FF 50 6A 20 E8 ?? ?? ?? ?? 83 C4 10 8D 8D B4 FB FF FF 51 8B 55 08 52 8B 45 E4 50 8D 4D EC 51 E8 ?? ?? ?? ?? 83 C4 10 8B 55 F0 83 E2 08 74 24 8B 45 F0 83 E0 04 75 1C 8D 8D B4 FB FF FF 51 8B 55 08 52 8B 85 54 FB FF FF 50 6A 30 E8 ?? ?? ?? ?? 83 C4 10 83 7D F4 00 0F 85 B4 00 00 00 83 7D DC 00 0F 8E AA 00 00 00 8B 4D FC 89 8D 50 FB FF FF 8B 55 DC 89 95 4C FB FF FF 8B 85 4C FB FF FF 8B 8D 4C FB FF FF 83 E9 01 89 8D 4C FB FF FF 85 C0 7E 7D 8D 4D C0 E8 ?? ?? ?? ?? 50 8D 4D C0 E8 ?? ?? ?? ?? 8B 10 8B 82 AC 00 00 00 50 8B 8D 50 FB FF FF 51 8D 95 A8 FB FF FF 52 E8 ?? ?? ?? ?? 83 C4 10 89 85 48 FB FF FF 83 BD 48 FB FF FF 00 7F 0C C7 85 B4 FB FF FF FF FF FF FF EB 32 8D 85 B4 FB FF FF 50 8B 4D 08 51 66 8B 95 A8 FB FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 85 50 FB FF FF 03 85 48 FB FF FF 89 85 50 FB FF FF E9 6A FF FF FF EB 1B 8D 8D B4 FB FF FF 51 8B 55 08 52 8B 45 DC 50 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 10 83 BD B4 FB FF FF 00 7C 24 8B 55 F0 83 E2 04 74 1C 8D 85 B4 FB FF FF 50 8B 4D 08 51 8B 95 54 FB FF FF 52 6A 20 E8 ?? ?? ?? ?? 83 C4 10 83 7D E0 00 74 15 6A 02 8B 45 E0 50 E8 ?? ?? ?? ?? 83 C4 08 C7 45 E0 00 00 00 00 E9 9D F1 FF FF 83 BD A4 FB FF FF 00 74 15 83 }
	condition:
		$1
}

rule file_52_4_0 {
	meta:
		name = "_write_char"
		size = 92
		refs = "0030 __fputwc_nolock"
	strings:
		$1 = { 55 8B EC 8B 45 0C 8B 48 0C 83 E1 40 74 18 8B 55 0C 83 7A 08 00 75 0F 8B 45 10 8B 08 83 C1 01 8B 55 10 89 0A EB 34 8B 45 0C 50 66 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 0F B7 D0 81 FA FF FF 00 00 75 0B 8B 45 10 C7 00 FF FF FF FF EB 0D 8B 4D 10 8B 11 83 C2 01 8B 45 10 89 10 5D C3 }
	condition:
		$1
}

rule file_52_5_0 {
	meta:
		name = "_write_multi_char"
		size = 54
		refs = "0021 _write_char"
	strings:
		$1 = { 55 8B EC 8B 45 0C 8B 4D 0C 83 E9 01 89 4D 0C 85 C0 7E 21 8B 55 14 52 8B 45 10 50 66 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 14 83 3A FF 75 02 EB 02 EB CF 5D C3 }
	condition:
		$1
}

rule file_52_6_0 {
	meta:
		name = "_write_string"
		size = 141
		refs = "004f _write_char 0068 __errno"
	strings:
		$1 = { 55 8B EC 51 8B 45 10 8B 48 0C 83 E1 40 74 18 8B 55 10 83 7A 08 00 75 0F 8B 45 14 8B 08 03 4D 0C 8B 55 14 89 0A EB 62 8B 45 0C 8B 4D 0C 83 E9 01 89 4D 0C 85 C0 7E 52 8B 55 08 66 8B 02 66 89 45 FE 8B 4D 14 51 8B 55 10 52 66 8B 45 FE 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D 08 83 C1 02 89 4D 08 8B 55 14 83 3A FF 75 20 E8 ?? ?? ?? ?? 83 38 2A 75 14 8B 45 14 50 8B 4D 10 51 6A 3F E8 ?? ?? ?? ?? 83 C4 0C EB 02 EB 02 EB 9E 8B E5 5D C3 }
	condition:
		$1
}

rule file_52_7_0 {
	meta:
		name = "_get_int_arg"
		size = 26
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 08 83 C1 04 8B 55 08 89 0A 8B 45 08 8B 08 8B 41 FC 5D C3 }
	condition:
		$1
}

rule file_52_8_0 {
	meta:
		name = "_get_int64_arg"
		size = 29
		altNames = "_get_crtdouble_arg"
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 08 83 C1 08 8B 55 08 89 0A 8B 45 08 8B 08 8B 41 F8 8B 51 FC 5D C3 }
	condition:
		$1
}

rule file_54_0_0 {
	meta:
		name = "__strset"
		size = 33
	strings:
		$1 = { 55 8B EC 57 8B 7D 08 8B D7 33 C0 83 C9 FF F2 AE 83 C1 02 F7 D9 8A 45 0C 8B FA F3 AA 8B C2 5F C9 C3 }
	condition:
		$1
}

rule file_55_1_0 {
	meta:
		name = "__CrtSetReportMode"
		size = 308
		refs = "002f ??_C@_1FA@IFFFOLDJ@?$AAn?$AAR?$AAp?$AAt?$AAT?$AAy?$AAp?$AAe?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAn?$AAR?$AAp?$AAt?$AAT?$AAy?$AAp?$AAe?$AA?5?$AA?$DM?$AA?5?$AA_?$AAC?$AAR?$AAT@ 0038 ??_C@_1BE@FLKCNJCI@?$AAd?$AAb?$AAg?$AAr?$AAp?$AAt?$AAt?$AA?4?$AAc?$AA?$AA@ 003f __CrtDbgReportW 004c __CrtDbgBreak 0057 __errno 006b ??_C@_1CE@FIHIECNJ@?$AA_?$AAC?$AAr?$AAt?$AAS?$AAe?$AAt?$AAR?$AAe?$AAp?$AAo?$AAr?$AAt?$AAM?$AAo?$AAd?$AAe?$AA?$AA@ 0075 __invalid_parameter 00af ??_C@_1NK@LOFHIHFC@?$AAf?$AAM?$AAo?$AAd?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA_?$AAC?$AAR?$AAT?$AAD?$AAB?$AAG?$AA_?$AAR?$AAE?$AAP?$AAO?$AAR?$AAT?$AA_?$AAM?$AAO?$AAD?$AAE?$AA?5?$AA?$HM?$AA?$HM?$AA?5@ 010d __CrtDbgMode"
	strings:
		$1 = { 55 8B EC 83 EC 14 83 7D 08 00 7C 0F 83 7D 08 03 7D 09 C7 45 F0 01 00 00 00 EB 07 C7 45 F0 00 00 00 00 8B 45 F0 89 45 F8 83 7D F8 00 75 22 68 ?? ?? ?? ?? 6A 00 6A 74 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 05 E8 ?? ?? ?? ?? 83 7D F8 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 74 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 AC 00 00 00 83 7D 0C FF 74 11 8B 55 0C 83 E2 F8 74 09 C7 45 EC 00 00 00 00 EB 07 C7 45 EC 01 00 00 00 8B 45 EC 89 45 F4 83 7D F4 00 75 22 68 ?? ?? ?? ?? 6A 00 6A 79 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 05 E8 ?? ?? ?? ?? 83 7D F4 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 79 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 2F 83 7D 0C FF 75 0C 8B 55 08 8B 04 95 ?? ?? ?? ?? EB 1D 8B 45 08 8B 0C 85 ?? ?? ?? ?? 89 4D FC 8B 55 08 8B 45 0C 89 04 95 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_55_2_0 {
	meta:
		name = "__CrtSetReportFile"
		size = 240
		refs = "002f ??_C@_1FA@IFFFOLDJ@?$AAn?$AAR?$AAp?$AAt?$AAT?$AAy?$AAp?$AAe?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAn?$AAR?$AAp?$AAt?$AAT?$AAy?$AAp?$AAe?$AA?5?$AA?$DM?$AA?5?$AA_?$AAC?$AAR?$AAT@ 003b ??_C@_1BE@FLKCNJCI@?$AAd?$AAb?$AAg?$AAr?$AAp?$AAt?$AAt?$AA?4?$AAc?$AA?$AA@ 0042 __CrtDbgReportW 004f __CrtDbgBreak 005a __errno 0071 ??_C@_1CE@IKKEDCME@?$AA_?$AAC?$AAr?$AAt?$AAS?$AAe?$AAt?$AAR?$AAe?$AAp?$AAo?$AAr?$AAt?$AAF?$AAi?$AAl?$AAe?$AA?$AA@ 007b __invalid_parameter 0095 __CrtDbgFile 00b2 __imp__GetStdHandle@4"
	strings:
		$1 = { 55 8B EC 83 EC 0C 83 7D 08 00 7C 0F 83 7D 08 03 7D 09 C7 45 F4 01 00 00 00 EB 07 C7 45 F4 00 00 00 00 8B 45 F4 89 45 F8 83 7D F8 00 75 25 68 ?? ?? ?? ?? 6A 00 68 9E 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 05 E8 ?? ?? ?? ?? 83 7D F8 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 9E 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 FE FF FF FF EB 63 83 7D 0C FA 75 0C 8B 55 08 8B 04 95 ?? ?? ?? ?? EB 51 8B 45 08 8B 0C 85 ?? ?? ?? ?? 89 4D FC 83 7D 0C FC 75 14 6A F5 FF 15 ?? ?? ?? ?? 8B 55 08 89 04 95 ?? ?? ?? ?? EB 27 83 7D 0C FB 75 14 6A F4 FF 15 ?? ?? ?? ?? 8B 4D 08 89 04 8D ?? ?? ?? ?? EB 0D 8B 55 08 8B 45 0C 89 04 95 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_55_3_0 {
	meta:
		name = "__CrtSetReportHook"
		size = 28
		refs = "0005 __pfnReportHook"
	strings:
		$1 = { 55 8B EC 51 A1 ?? ?? ?? ?? 89 45 FC 8B 4D 08 89 0D ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_417_23_0 {
	meta:
		name = "__CrtSetAllocHook"
		size = 28
		refs = "0005 __pfnAllocHook"
	strings:
		$1 = { 55 8B EC 51 A1 ?? ?? ?? ?? 89 45 FC 8B 4D 08 89 0D ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_417_21_0 {
	meta:
		name = "__CrtSetBreakAlloc"
		size = 28
		refs = "0005 __crtBreakAlloc"
	strings:
		$1 = { 55 8B EC 51 A1 ?? ?? ?? ?? 89 45 FC 8B 4D 08 89 0D ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_417_61_0 {
	meta:
		name = "__CrtSetDebugFillThreshold"
		size = 28
		refs = "0005 ___crtDebugFillThreshold"
	strings:
		$1 = { 55 8B EC 51 A1 ?? ?? ?? ?? 89 45 FC 8B 4D 08 89 0D ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_417_34_0 {
	meta:
		name = "__CrtSetDumpClient"
		size = 28
		refs = "0005 ?_pfnDumpClient@@3P6AXPAXI@ZA"
	strings:
		$1 = { 55 8B EC 51 A1 ?? ?? ?? ?? 89 45 FC 8B 4D 08 89 0D ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_334_3_0 {
	meta:
		name = "___setfflag"
		size = 28
		refs = "0005 ___fastflag"
	strings:
		$1 = { 55 8B EC 51 A1 ?? ?? ?? ?? 89 45 FC 8B 4D 08 89 0D ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_722_0_0 {
	meta:
		name = "__set_malloc_crt_max_wait"
		size = 28
		refs = "0005 __maxwait"
	strings:
		$1 = { 55 8B EC 51 A1 ?? ?? ?? ?? 89 45 FC 8B 4D 08 89 0D ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_55_5_0 {
	meta:
		name = "__VCrtDbgReportA"
		size = 2059
		refs = "0006 __sehtable$__VCrtDbgReportA 000b __except_handler4 001f __chkstk 0024 ___security_cookie 0067 _memset 00de __lock 00f7 __crtAssertBusy 00fd __imp__InterlockedIncrement@4 0111 ??_C@_1BE@FLKCNJCI@?$AAd?$AAb?$AAg?$AAr?$AAp?$AAt?$AAt?$AA?4?$AAc?$AA?$AA@ 0116 ??_C@_1CA@KHJHLKA@?$AA_?$AAV?$AAC?$AAr?$AAt?$AAD?$AAb?$AAg?$AAR?$AAe?$AAp?$AAo?$AAr?$AAt?$AAA?$AA?$AA@ 011b ??_C@_1FA@JPHJBHEM@?$AA_?$AAi?$AAt?$AAo?$AAa?$AA_?$AAs?$AA?$CI?$AAn?$AAL?$AAi?$AAn?$AAe?$AA?0?$AA?5?$AAs?$AAz?$AAL?$AAi?$AAn?$AAe?$AAM?$AAe?$AAs?$AAs?$AAa?$AAg?$AAe?$AA?0?$AA?5?$AA4?$AA0@ 0132 __itoa_s 013b __invoke_watson_if_error 0143 ??_C@_0CG@BNGLOCEO@Second?5Chance?5Assertion?5Failed?3?5@ 0149 __imp__OutputDebugStringA@4 0164 ??_C@_0P@DFJNDPOP@?$DMfile?5unknown?$DO?$AA@ 0176 ??_C@_07BHGABMGB@?0?5Line?5?$AA@ 018e ??_C@_01EEMJAFIK@?6?$AA@ 0199 __CrtDbgBreak 01c1 __errno 01f2 __vsnprintf_s 021a ??_C@_1BI@KALLJECN@?$AA?$CI?$AA?$CK?$AA_?$AAe?$AAr?$AAr?$AAn?$AAo?$AA?$CI?$AA?$CJ?$AA?$CJ?$AA?$AA@ 022b __invoke_watson_if_oneof 025a ??_C@_1JI@GAALPGBM@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAs?$AAz?$AAU?$AAs?$AAe?$AAr?$AAM?$AAe?$AAs?$AAs?$AAa?$AAg?$AAe?$AA?0?$AA?5?$AA4?$AA0?$AA9?$AA6?$AA?0?$AA?5?$AA?$CC?$AA_@ 025f ??_C@_0CL@EACFGMNB@_CrtDbgReport?3?5String?5too?5long?5o@ 0270 _strcpy_s 0292 ??_C@_0BD@CAENFOHP@Assertion?5failed?3?5?$AA@ 029e ??_C@_0BC@LAIDCHCH@Assertion?5failed?$CB?$AA@ 02b4 ??_C@_1KK@GIGAEDMO@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAs?$AAz?$AAL?$AAi?$AAn?$AAe?$AAM?$AAe?$AAs?$AAs?$AAa?$AAg?$AAe?$AA?0?$AA?5?$AA4?$AA0?$AA9?$AA6?$AA?0?$AA?5?$AAs?$AAz@ 02ee ??_C@_1FK@NPGBPOFO@?$AAs?$AAt?$AAr?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AAs?$AAz?$AAL?$AAi?$AAn?$AAe?$AAM?$AAe?$AAs?$AAs?$AAa?$AAg?$AAe?$AA?0?$AA?5?$AA4?$AA0?$AA9?$AA6?$AA?0?$AA?5?$AAs?$AAz@ 0306 _strcat_s 0322 __CrtDbgMode 033d ??_C@_1EI@CACDLAFK@?$AAs?$AAt?$AAr?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AAs?$AAz?$AAL?$AAi?$AAn?$AAe?$AAM?$AAe?$AAs?$AAs?$AAa?$AAg?$AAe?$AA?0?$AA?5?$AA4?$AA0?$AA9?$AA6?$AA?0?$AA?5?$AA?$CC?$AA?2@ 0342 ??_C@_01LIIJDEN@?$AN?$AA@ 0375 ??_C@_1EI@LDHJEDO@?$AAs?$AAt?$AAr?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AAs?$AAz?$AAL?$AAi?$AAn?$AAe?$AAM?$AAe?$AAs?$AAs?$AAa?$AAg?$AAe?$AA?0?$AA?5?$AA4?$AA0?$AA9?$AA6?$AA?0?$AA?5?$AA?$CC?$AA?2@ 03d7 ??_C@_0M@IPILFDFN@?$CFs?$CI?$CFd?$CJ?5?3?5?$CFs?$AA@ 03ed __snprintf_s 0455 ??_C@_1JG@CPKCIOEE@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAs?$AAz?$AAO?$AAu?$AAt?$AAM?$AAe?$AAs?$AAs?$AAa?$AAg?$AAe?$AA?0?$AA?5?$AA4?$AA0?$AA9?$AA6?$AA?0?$AA?5?$AA?$CC?$AA_?$AAC@ 048f ??_C@_1FI@IBIOIHEG@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAs?$AAz?$AAO?$AAu?$AAt?$AAM?$AAe?$AAs?$AAs?$AAa?$AAg?$AAe?$AA?0?$AA?5?$AA4?$AA0?$AA9?$AA6?$AA?0?$AA?5?$AAs?$AAz?$AAL@ 04e8 _mbstowcs_s 0507 ??_C@_1IM@OOKIFKOH@?$AAe?$AA?5?$AA?$DN?$AA?5?$AAm?$AAb?$AAs?$AAt?$AAo?$AAw?$AAc?$AAs?$AA_?$AAs?$AA?$CI?$AA?$CG?$AAr?$AAe?$AAt?$AA?0?$AA?5?$AAs?$AAz?$AAO?$AAu?$AAt?$AAM?$AAe?$AAs?$AAs?$AAa?$AAg@ 0539 ??_C@_1MC@IGEECMDB@?$AAw?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAs?$AAz?$AAO?$AAu?$AAt?$AAM?$AAe?$AAs?$AAs?$AAa?$AAg?$AAe?$AA2?$AA?0?$AA?5?$AA4?$AA0?$AA9?$AA6?$AA?0?$AA?5?$AAL?$AA?$CC@ 053e ??_C@_1HO@PJOFIKFE@?$AA_?$AAC?$AAr?$AAt?$AAD?$AAb?$AAg?$AAR?$AAe?$AAp?$AAo?$AAr?$AAt?$AA?3?$AA?5?$AAS?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AAt?$AAo?$AAo?$AA?5?$AAl?$AAo?$AAn?$AAg?$AA?5?$AAo@ 054f _wcscpy_s 0561 __pReportHookList 056a __pReportHookListW 067d __pfnReportHook 06e5 __CrtDbgFile 06fd _strlen 0719 __imp__WriteFile@20 07b2 ___crtMessageWindowA 07da __imp__InterlockedDecrement@4 07e1 __unlock 0803 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 08 B8 50 50 00 00 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 31 45 F8 33 C5 89 45 E4 53 56 57 50 8D 45 F0 64 A3 00 00 00 00 C7 85 DC DF FF FF 00 00 00 00 C7 85 D4 CF FF FF 00 00 00 00 C6 85 D0 BF FF FF 00 68 FF 0F 00 00 6A 00 8D 85 D1 BF FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C C6 85 D8 CF FF FF 00 68 FF 0F 00 00 6A 00 8D 8D D9 CF FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 66 C7 85 E0 DF FF FF 00 00 68 FE 1F 00 00 6A 00 8D 95 E2 DF FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C C6 85 D0 AF FF FF 00 68 FF 0F 00 00 6A 00 8D 85 D1 AF FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 83 7D 08 00 7C 06 83 7D 08 03 7C 08 83 C8 FF E9 14 07 00 00 6A 0F E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 83 7D 08 02 0F 85 B6 00 00 00 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 0F 8E A3 00 00 00 6A 00 68 1E 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 0A 68 00 10 00 00 8D 8D D0 BF FF FF 51 8B 55 10 52 E8 ?? ?? ?? ?? 83 C4 10 50 E8 ?? ?? ?? ?? 83 C4 18 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 83 7D 0C 00 74 0B 8B 45 0C 89 85 9C AF FF FF EB 0A C7 85 9C AF FF FF ?? ?? ?? ?? 8B 8D 9C AF FF FF 51 FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8D 95 D0 BF FF FF 52 FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 85 DC DF FF FF FF FF FF FF E9 13 06 00 00 83 7D 18 00 0F 84 CA 00 00 00 C7 85 CC AF FF FF 00 00 00 00 E8 ?? ?? ?? ?? 8B 00 89 85 C8 AF FF FF E8 ?? ?? ?? ?? C7 00 00 00 00 00 8B 4D 1C 51 8B 55 18 52 68 EB 0F 00 00 68 00 10 00 00 8D 85 D0 AF FF FF 50 E8 ?? ?? ?? ?? 83 C4 14 89 85 CC AF FF FF 83 BD CC AF FF FF 00 7D 2A 6A 00 68 32 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 22 6A 16 E8 ?? ?? ?? ?? 8B 08 51 E8 ?? ?? ?? ?? 83 C4 20 E8 ?? ?? ?? ?? 8B 95 C8 AF FF FF 89 10 83 BD CC AF FF FF 00 7D 38 6A 00 68 35 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 00 10 00 00 8D 85 D0 AF FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 83 7D 08 02 75 56 83 7D 18 00 74 0C C7 85 98 AF FF FF ?? ?? ?? ?? EB 0A C7 85 98 AF FF FF ?? ?? ?? ?? 6A 00 68 3A 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 8D 98 AF FF FF 51 68 00 10 00 00 8D 95 D0 BF FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 3C 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 85 D0 AF FF FF 50 68 00 10 00 00 8D 8D D0 BF FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 83 7D 08 02 75 7F 8B 55 08 8B 04 95 ?? ?? ?? ?? 83 E0 01 74 38 6A 00 68 41 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 00 10 00 00 8D 8D D0 BF FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 42 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 00 10 00 00 8D 95 D0 BF FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 83 7D 0C 00 0F 84 D8 00 00 00 C7 85 C4 AF FF FF 00 00 00 00 E8 ?? ?? ?? ?? 8B 00 89 85 C0 AF FF FF E8 ?? ?? ?? ?? C7 00 00 00 00 00 8D 8D D0 BF FF FF 51 8B 55 10 52 8B 45 0C 50 68 ?? ?? ?? ?? 68 FF 0F 00 00 68 00 10 00 00 8D 8D D8 CF FF FF 51 E8 ?? ?? ?? ?? 83 C4 1C 89 85 C4 AF FF FF 83 BD C4 AF FF FF 00 7D 2A 6A 00 68 49 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 22 6A 16 E8 ?? ?? ?? ?? 8B 10 52 E8 ?? ?? ?? ?? 83 C4 20 E8 ?? ?? ?? ?? 8B 8D C0 AF FF FF 89 08 83 BD C4 AF FF FF 00 7D 38 6A 00 68 4C 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 00 10 00 00 8D 95 D8 CF FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 EB 3A 6A 00 68 50 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 85 D0 BF FF FF 50 68 00 10 00 00 8D 8D D8 CF FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 C7 85 BC AF FF FF 00 00 00 00 C7 85 B8 AF FF FF 00 00 00 00 6A FF 8D 95 D8 CF FF FF 52 68 00 10 00 00 8D 85 E0 DF FF FF 50 8D 8D BC AF FF FF 51 E8 ?? ?? ?? ?? 83 C4 14 89 85 B8 AF FF FF 6A 00 68 55 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 22 6A 16 8B 95 B8 AF FF FF 52 E8 ?? ?? ?? ?? 83 C4 20 83 BD B8 AF FF FF 00 74 38 6A 00 68 57 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 00 10 00 00 8D 85 E0 DF FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 83 3D ?? ?? ?? ?? 00 75 0D 83 3D ?? ?? ?? ?? 00 0F 84 F9 00 00 00 C7 85 B0 AF FF FF 00 00 00 00 C7 85 B4 AF FF FF 00 00 00 00 8B 0D ?? ?? ?? ?? 89 8D B0 AF FF FF EB 0F 8B 95 B0 AF FF FF 8B 42 04 89 85 B0 AF FF FF 83 BD B0 AF FF FF 00 74 48 C7 85 AC AF FF FF 00 00 00 00 8D 8D AC AF FF FF 51 8D 95 D8 CF FF FF 52 8B 45 08 50 8B 8D B0 AF FF FF 8B 51 0C FF D2 83 C4 0C 85 C0 74 18 C7 85 D4 CF FF FF 01 00 00 00 8B 85 AC AF FF FF 89 85 DC DF FF FF EB 02 EB A0 83 BD D4 CF FF FF 00 75 6E 8B 0D ?? ?? ?? ?? 89 8D B4 AF FF FF EB 0F 8B 95 B4 AF FF FF 8B 42 04 89 85 B4 AF FF FF 83 BD B4 AF FF FF 00 74 48 C7 85 A8 AF FF FF 00 00 00 00 8D 8D A8 AF FF FF 51 8D 95 E0 DF FF FF 52 8B 45 08 50 8B 8D B4 AF FF FF 8B 51 0C FF D2 83 C4 0C 85 C0 74 18 C7 85 D4 CF FF FF 01 00 00 00 8B 85 A8 AF FF FF 89 85 DC DF FF FF EB 02 EB A0 83 BD D4 CF FF FF 00 0F 85 44 01 00 00 83 3D ?? ?? ?? ?? 00 74 3F C7 85 A4 AF FF FF 00 00 00 00 8D 8D A4 AF FF FF 51 8D 95 D8 CF FF FF 52 8B 45 08 50 FF 15 ?? ?? ?? ?? 83 C4 0C 85 C0 74 16 C7 85 D4 CF FF FF 01 00 00 00 8B 8D A4 AF FF FF 89 8D DC DF FF FF 83 BD D4 CF FF FF 00 0F 85 EF 00 00 00 8B 55 08 8B 04 95 ?? ?? ?? ?? 83 E0 01 74 3E 8B 4D 08 83 3C 8D ?? ?? ?? ?? FF 74 31 6A 00 8D 95 A0 AF FF FF 52 8D 85 D8 CF FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 50 8D 8D D8 CF FF FF 51 8B 55 08 8B 04 95 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 8B 4D 08 8B 14 8D ?? ?? ?? ?? 83 E2 02 74 0D 8D 85 D8 CF FF FF 50 FF 15 ?? ?? ?? ?? 8B 4D 08 8B 14 8D ?? ?? ?? ?? 83 E2 04 74 77 C6 85 D0 BF FF FF 00 83 7D 10 00 74 39 6A 00 68 9F 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 0A 68 00 10 00 00 8D 85 D0 BF FF FF 50 8B 4D 10 51 E8 ?? ?? ?? ?? 83 C4 10 50 E8 ?? ?? ?? ?? 83 C4 18 8D 95 D0 AF FF FF 52 8B 45 14 50 8B 4D 10 F7 D9 1B C9 8D 95 D0 BF FF FF 23 CA 51 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 14 89 85 DC DF FF FF C7 45 FC FE FF FF FF E8 02 00 00 00 EB 1C 83 7D 08 02 75 0B 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 6A 0F E8 ?? ?? ?? ?? 83 C4 04 C3 8B 85 DC DF FF FF 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B 4D E4 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_55_7_0 {
	meta:
		name = "__invoke_watson_if_oneof"
		size = 63
		refs = "0033 __invoke_watson"
	strings:
		$1 = { 55 8B EC 83 7D 08 00 74 10 8B 45 08 3B 45 0C 74 0D 8B 4D 08 3B 4D 10 74 05 8B 45 08 EB 1F 8B 55 24 52 8B 45 20 50 8B 4D 1C 51 8B 55 18 52 8B 45 14 50 E8 ?? ?? ?? ?? 83 C4 14 8B 45 08 5D C3 }
	condition:
		$1
}

rule file_55_8_0 {
	meta:
		name = "__VCrtDbgReportW"
		size = 2313
		refs = "0006 __sehtable$__VCrtDbgReportW 000b __except_handler4 001f __chkstk 0024 ___security_cookie 0069 _memset 00e2 __lock 00fb __crtAssertBusy 0101 __imp__InterlockedIncrement@4 0115 ??_C@_1BE@FLKCNJCI@?$AAd?$AAb?$AAg?$AAr?$AAp?$AAt?$AAt?$AA?4?$AAc?$AA?$AA@ 011a ??_C@_1CA@HPALHDOD@?$AA_?$AAV?$AAC?$AAr?$AAt?$AAD?$AAb?$AAg?$AAR?$AAe?$AAp?$AAo?$AAr?$AAt?$AAW?$AA?$AA@ 011f ??_C@_1FA@CNLLOMHI@?$AA_?$AAi?$AAt?$AAo?$AAw?$AA_?$AAs?$AA?$CI?$AAn?$AAL?$AAi?$AAn?$AAe?$AA?0?$AA?5?$AAs?$AAz?$AAL?$AAi?$AAn?$AAe?$AAM?$AAe?$AAs?$AAs?$AAa?$AAg?$AAe?$AA?0?$AA?5?$AA4?$AA0@ 0136 __itow_s 013f __invoke_watson_if_error 0147 ??_C@_1EM@MJFLEDMB@?$AAS?$AAe?$AAc?$AAo?$AAn?$AAd?$AA?5?$AAC?$AAh?$AAa?$AAn?$AAc?$AAe?$AA?5?$AAA?$AAs?$AAs?$AAe?$AAr?$AAt?$AAi?$AAo?$AAn?$AA?5?$AAF?$AAa?$AAi?$AAl?$AAe?$AAd?$AA?3?$AA?5@ 014d __imp__OutputDebugStringW@4 0168 ??_C@_1BO@OCHMLCAG@?$AA?$DM?$AAf?$AAi?$AAl?$AAe?$AA?5?$AAu?$AAn?$AAk?$AAn?$AAo?$AAw?$AAn?$AA?$DO?$AA?$AA@ 017a ??_C@_1BA@ELMMDCFC@?$AA?0?$AA?5?$AAL?$AAi?$AAn?$AAe?$AA?5?$AA?$AA@ 0192 ??_C@_13LBAGMAIH@?$AA?6?$AA?$AA@ 019d __CrtDbgBreak 01b1 __errno 01e2 __vsnwprintf_s 020a ??_C@_1BI@KALLJECN@?$AA?$CI?$AA?$CK?$AA_?$AAe?$AAr?$AAr?$AAn?$AAo?$AA?$CI?$AA?$CJ?$AA?$CJ?$AA?$AA@ 021b __invoke_watson_if_oneof 024a ??_C@_1JK@KHFABAEO@?$AAw?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAs?$AAz?$AAU?$AAs?$AAe?$AAr?$AAM?$AAe?$AAs?$AAs?$AAa?$AAg?$AAe?$AA?0?$AA?5?$AA4?$AA0?$AA9?$AA6?$AA?0?$AA?5?$AAL?$AA?$CC@ 024f ??_C@_1FG@BBOLDHGF@?$AA_?$AAC?$AAr?$AAt?$AAD?$AAb?$AAg?$AAR?$AAe?$AAp?$AAo?$AAr?$AAt?$AA?3?$AA?5?$AAS?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AAt?$AAo?$AAo?$AA?5?$AAl?$AAo?$AAn?$AAg?$AA?5?$AAo@ 0260 _wcscpy_s 0282 ??_C@_1CG@FFFGGODN@?$AAA?$AAs?$AAs?$AAe?$AAr?$AAt?$AAi?$AAo?$AAn?$AA?5?$AAf?$AAa?$AAi?$AAl?$AAe?$AAd?$AA?3?$AA?5?$AA?$AA@ 028e ??_C@_1CE@OJBNHDMO@?$AAA?$AAs?$AAs?$AAe?$AAr?$AAt?$AAi?$AAo?$AAn?$AA?5?$AAf?$AAa?$AAi?$AAl?$AAe?$AAd?$AA?$CB?$AA?$AA@ 02a4 ??_C@_1KO@DGAHENCH@?$AAw?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAs?$AAz?$AAL?$AAi?$AAn?$AAe?$AAM?$AAe?$AAs?$AAs?$AAa?$AAg?$AAe?$AA?0?$AA?5?$AA4?$AA0?$AA9?$AA6?$AA?0?$AA?5?$AAs?$AAz@ 02de ??_C@_1FK@HPADHBBD@?$AAw?$AAc?$AAs?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AAs?$AAz?$AAL?$AAi?$AAn?$AAe?$AAM?$AAe?$AAs?$AAs?$AAa?$AAg?$AAe?$AA?0?$AA?5?$AA4?$AA0?$AA9?$AA6?$AA?0?$AA?5?$AAs?$AAz@ 02f6 _wcscat_s 0312 __CrtDbgMode 032d ??_C@_1EK@NMDFGHMF@?$AAw?$AAc?$AAs?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AAs?$AAz?$AAL?$AAi?$AAn?$AAe?$AAM?$AAe?$AAs?$AAs?$AAa?$AAg?$AAe?$AA?0?$AA?5?$AA4?$AA0?$AA9?$AA6?$AA?0?$AA?5?$AAL?$AA?$CC@ 0332 ??_C@_13CMNBPIDO@?$AA?$AN?$AA?$AA@ 0365 ??_C@_1EK@PHCBEDKB@?$AAw?$AAc?$AAs?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AAs?$AAz?$AAL?$AAi?$AAn?$AAe?$AAM?$AAe?$AAs?$AAs?$AAa?$AAg?$AAe?$AA?0?$AA?5?$AA4?$AA0?$AA9?$AA6?$AA?0?$AA?5?$AAL?$AA?$CC@ 03c7 ??_C@_1BI@JIDBEPIG@?$AA?$CF?$AAs?$AA?$CI?$AA?$CF?$AAd?$AA?$CJ?$AA?5?$AA?3?$AA?5?$AA?$CF?$AAs?$AA?$AA@ 03dd __snwprintf_s 0445 ??_C@_1JI@EACPGHID@?$AAw?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAs?$AAz?$AAO?$AAu?$AAt?$AAM?$AAe?$AAs?$AAs?$AAa?$AAg?$AAe?$AA?0?$AA?5?$AA4?$AA0?$AA9?$AA6?$AA?0?$AA?5?$AAL?$AA?$CC?$AA_@ 047f ??_C@_1FI@DBAIJPJE@?$AAw?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAs?$AAz?$AAO?$AAu?$AAt?$AAM?$AAe?$AAs?$AAs?$AAa?$AAg?$AAe?$AA?0?$AA?5?$AA4?$AA0?$AA9?$AA6?$AA?0?$AA?5?$AAs?$AAz?$AAL@ 04c3 ??_C@_1JC@EOAPFDLN@?$AAw?$AAc?$AAs?$AAt?$AAo?$AAm?$AAb?$AAs?$AA_?$AAs?$AA?$CI?$AA?$CI?$AA?$CI?$AAv?$AAo?$AAi?$AAd?$AA?5?$AA?$CK?$AA?$CJ?$AA0?$AA?$CJ?$AA?0?$AA?5?$AAs?$AAz?$AAO?$AAu?$AAt?$AAM?$AAe?$AAs@ 04e3 _wcstombs_s 0514 ??_C@_1MA@LBAMNNOB@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAs?$AAz?$AAO?$AAu?$AAt?$AAM?$AAe?$AAs?$AAs?$AAa?$AAg?$AAe?$AA2?$AA?0?$AA?5?$AA4?$AA0?$AA9?$AA6?$AA?0?$AA?5?$AA?$CC?$AA_@ 0519 ??_C@_0DP@GNPEPHJD@_CrtDbgReport?3?5String?5too?5long?5o@ 052a _strcpy_s 053c __pReportHookList 0545 __pReportHookListW 0658 __pfnReportHook 06c4 __CrtDbgFile 06dc __imp__GetFileType@4 0702 _wcslen 071e __imp__WriteConsoleW@20 072d __imp__GetLastError@0 0757 ??_C@_1IE@CPGKIAGP@?$AAw?$AAc?$AAs?$AAt?$AAo?$AAm?$AAb?$AAs?$AA_?$AAs?$AA?$CI?$AA?$CG?$AAr?$AAe?$AAt?$AA?0?$AA?5?$AAs?$AAz?$AAa?$AAO?$AAu?$AAt?$AAM?$AAe?$AAs?$AAs?$AAa?$AAg?$AAe?$AA?0?$AA?5@ 07d3 __imp__WriteFile@20 08b0 ___crtMessageWindowW 08d8 __imp__InterlockedDecrement@4 08df __unlock 0901 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 08 B8 5C 80 00 00 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 31 45 F8 33 C5 89 45 E4 53 56 57 50 8D 45 F0 64 A3 00 00 00 00 C7 85 DC EF FF FF 00 00 00 00 C7 85 D4 CF FF FF 00 00 00 00 66 C7 85 D0 AF FF FF 00 00 68 FE 1F 00 00 6A 00 8D 85 D2 AF FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 66 C7 85 D8 CF FF FF 00 00 68 FE 1F 00 00 6A 00 8D 8D DA CF FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C C6 85 E0 EF FF FF 00 68 FF 0F 00 00 6A 00 8D 95 E1 EF FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 66 C7 85 D0 8F FF FF 00 00 68 FE 1F 00 00 6A 00 8D 85 D2 8F FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 83 7D 08 00 7C 06 83 7D 08 03 7C 08 83 C8 FF E9 0E 08 00 00 6A 0F E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 83 7D 08 02 0F 85 AC 00 00 00 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 0F 8E 99 00 00 00 6A 00 68 F3 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 0A 68 00 10 00 00 8D 8D D0 AF FF FF 51 8B 55 10 52 E8 ?? ?? ?? ?? 83 C4 10 50 E8 ?? ?? ?? ?? 83 C4 18 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 83 7D 0C 00 74 0B 8B 45 0C 89 85 94 7F FF FF EB 0A C7 85 94 7F FF FF ?? ?? ?? ?? 8B 8D 94 7F FF FF 51 FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8D 95 D0 AF FF FF 52 FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 17 07 00 00 83 7D 18 00 0F 84 C0 00 00 00 E8 ?? ?? ?? ?? 8B 00 89 85 C8 8F FF FF E8 ?? ?? ?? ?? C7 00 00 00 00 00 8B 4D 1C 51 8B 55 18 52 68 EB 0F 00 00 68 00 10 00 00 8D 85 D0 8F FF FF 50 E8 ?? ?? ?? ?? 83 C4 14 89 85 CC 8F FF FF 83 BD CC 8F FF FF 00 7D 2A 6A 00 68 08 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 22 6A 16 E8 ?? ?? ?? ?? 8B 08 51 E8 ?? ?? ?? ?? 83 C4 20 E8 ?? ?? ?? ?? 8B 95 C8 8F FF FF 89 10 83 BD CC 8F FF FF 00 7D 38 6A 00 68 0B 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 00 10 00 00 8D 85 D0 8F FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 83 7D 08 02 75 56 83 7D 18 00 74 0C C7 85 90 7F FF FF ?? ?? ?? ?? EB 0A C7 85 90 7F FF FF ?? ?? ?? ?? 6A 00 68 10 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 8D 90 7F FF FF 51 68 00 10 00 00 8D 95 D0 AF FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 12 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 85 D0 8F FF FF 50 68 00 10 00 00 8D 8D D0 AF FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 83 7D 08 02 75 7F 8B 55 08 8B 04 95 ?? ?? ?? ?? 83 E0 01 74 38 6A 00 68 17 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 00 10 00 00 8D 8D D0 AF FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 19 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 00 10 00 00 8D 95 D0 AF FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 83 7D 0C 00 0F 84 D8 00 00 00 C7 85 C4 8F FF FF 00 00 00 00 E8 ?? ?? ?? ?? 8B 00 89 85 C0 8F FF FF E8 ?? ?? ?? ?? C7 00 00 00 00 00 8D 8D D0 AF FF FF 51 8B 55 10 52 8B 45 0C 50 68 ?? ?? ?? ?? 68 00 10 00 00 68 00 10 00 00 8D 8D D8 CF FF FF 51 E8 ?? ?? ?? ?? 83 C4 1C 89 85 C4 8F FF FF 83 BD C4 8F FF FF 00 7D 2A 6A 00 68 21 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 22 6A 16 E8 ?? ?? ?? ?? 8B 10 52 E8 ?? ?? ?? ?? 83 C4 20 E8 ?? ?? ?? ?? 8B 8D C0 8F FF FF 89 08 83 BD C4 8F FF FF 00 7D 38 6A 00 68 23 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 00 10 00 00 8D 95 D8 CF FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 EB 3A 6A 00 68 27 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 85 D0 AF FF FF 50 68 00 10 00 00 8D 8D D8 CF FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 C7 85 BC 8F FF FF 00 00 00 00 6A 00 68 2D 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 22 6A 16 6A FF 8D 95 D8 CF FF FF 52 68 00 10 00 00 8D 85 E0 EF FF FF 50 6A 00 E8 ?? ?? ?? ?? 83 C4 14 50 E8 ?? ?? ?? ?? 83 C4 20 89 85 BC 8F FF FF 83 BD BC 8F FF FF 00 74 38 6A 00 68 2F 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 00 10 00 00 8D 8D E0 EF FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 83 3D ?? ?? ?? ?? 00 75 0D 83 3D ?? ?? ?? ?? 00 0F 84 F9 00 00 00 C7 85 B4 8F FF FF 00 00 00 00 C7 85 B8 8F FF FF 00 00 00 00 8B 15 ?? ?? ?? ?? 89 95 B4 8F FF FF EB 0F 8B 85 B4 8F FF FF 8B 48 04 89 8D B4 8F FF FF 83 BD B4 8F FF FF 00 74 48 C7 85 B0 8F FF FF 00 00 00 00 8D 95 B0 8F FF FF 52 8D 85 E0 EF FF FF 50 8B 4D 08 51 8B 95 B4 8F FF FF 8B 42 0C FF D0 83 C4 0C 85 C0 74 18 8B 8D B0 8F FF FF 89 8D DC EF FF FF C7 85 D4 CF FF FF 01 00 00 00 EB 02 EB A0 83 BD D4 CF FF FF 00 75 6E 8B 15 ?? ?? ?? ?? 89 95 B8 8F FF FF EB 0F 8B 85 B8 8F FF FF 8B 48 04 89 8D B8 8F FF FF 83 BD B8 8F FF FF 00 74 48 C7 85 AC 8F FF FF 00 00 00 00 8D 95 AC 8F FF FF 52 8D 85 D8 CF FF FF 50 8B 4D 08 51 8B 95 B8 8F FF FF 8B 42 0C FF D0 83 C4 0C 85 C0 74 18 8B 8D AC 8F FF FF 89 8D DC EF FF FF C7 85 D4 CF FF FF 01 00 00 00 EB 02 EB A0 83 BD D4 CF FF FF 00 0F 85 67 02 00 00 83 3D ?? ?? ?? ?? 00 74 3F C7 85 A8 8F FF FF 00 00 00 00 8D 95 A8 8F FF FF 52 8D 85 E0 EF FF FF 50 8B 4D 08 51 FF 15 ?? ?? ?? ?? 83 C4 0C 85 C0 74 16 8B 95 A8 8F FF FF 89 95 DC EF FF FF C7 85 D4 CF FF FF 01 00 00 00 83 BD D4 CF FF FF 00 0F 85 12 02 00 00 8B 45 08 8B 0C 85 ?? ?? ?? ?? 83 E1 01 0F 84 5B 01 00 00 8B 55 08 83 3C 95 ?? ?? ?? ?? FF 0F 84 4A 01 00 00 8B 45 08 8B 0C 85 ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 89 85 8C 7F FF FF 83 BD 8C 7F FF FF 02 74 02 EB 4A 6A 00 8D 95 A4 8F FF FF 52 8D 85 D8 CF FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 50 8D 8D D8 CF FF FF 51 8B 55 08 8B 04 95 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 74 05 E9 EE 00 00 00 FF 15 ?? ?? ?? ?? 83 F8 06 74 05 E9 DE 00 00 00 C7 85 9C 7F FF FF 00 00 00 00 6A 00 68 78 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 22 6A 16 6A FF 8D 8D D8 CF FF FF 51 68 00 10 00 00 8D 95 A0 7F FF FF 52 8D 85 9C 7F FF FF 50 E8 ?? ?? ?? ?? 83 C4 14 50 E8 ?? ?? ?? ?? 83 C4 20 89 85 98 7F FF FF 83 BD 98 7F FF FF 00 74 3E 83 BD 98 7F FF FF 50 74 35 6A 00 8D 8D A4 8F FF FF 51 8D 95 D8 CF FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 D1 E0 50 8D 85 D8 CF FF FF 50 8B 4D 08 8B 14 8D ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? EB 40 83 BD 9C 7F FF FF 00 76 0F 8B 85 9C 7F FF FF 83 E8 01 89 85 9C 7F FF FF 6A 00 8D 8D A4 8F FF FF 51 8B 95 9C 7F FF FF 52 8D 85 A0 7F FF FF 50 8B 4D 08 8B 14 8D ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 8B 45 08 8B 0C 85 ?? ?? ?? ?? 83 E1 02 74 0D 8D 95 D8 CF FF FF 52 FF 15 ?? ?? ?? ?? 8B 45 08 8B 0C 85 ?? ?? ?? ?? 83 E1 04 74 79 66 C7 85 D0 AF FF FF 00 00 83 7D 10 00 74 39 6A 00 68 96 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 0A 68 00 10 00 00 8D 95 D0 AF FF FF 52 8B 45 10 50 E8 ?? ?? ?? ?? 83 C4 10 50 E8 ?? ?? ?? ?? 83 C4 18 8D 8D D0 8F FF FF 51 8B 55 14 52 8B 45 10 F7 D8 1B C0 8D 8D D0 AF FF FF 23 C1 50 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 89 85 DC EF FF FF C7 45 FC FE FF FF FF E8 02 00 00 00 EB 1C 83 7D 08 02 75 0B 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 6A 0F E8 ?? ?? ?? ?? 83 C4 04 C3 8B 85 DC EF FF FF 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B 4D E4 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_56_0_0 {
	meta:
		name = "__mbstok_l"
		size = 43
		refs = "0005 __getptd 0020 __mbstok_s_l"
	strings:
		$1 = { 55 8B EC 51 E8 ?? ?? ?? ?? 89 45 FC 8B 45 10 50 8B 4D FC 83 C1 20 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_57_0_0 {
	meta:
		name = "__write"
		size = 543
		refs = "0006 __sehtable$__write 000b __except_handler4 001d ___security_cookie 0037 ___doserrno 0042 __errno 005f __nhandle 0082 ??_C@_1FO@LPCLHKGE@?$AA?$CI?$AAf?$AAh?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AAu?$AAn?$AAs?$AAi?$AAg?$AAn?$AAe?$AAd?$AA?$CJ?$AAf?$AAh?$AA?5?$AA?$DM?$AA?5?$AA?$CI?$AAu?$AAn?$AAs?$AAi@ 008b ??_C@_1BA@PMLNGJCB@?$AAw?$AAr?$AAi?$AAt?$AAe?$AA?4?$AAc?$AA?$AA@ 0092 __CrtDbgReportW 00c5 ??_C@_1O@KOFKDHPL@?$AA_?$AAw?$AAr?$AAi?$AAt?$AAe?$AA?$AA@ 00cf __invalid_parameter 00f0 ___pioinfo 0108 ??_C@_1CM@OKGMMMDH@?$AA?$CI?$AA_?$AAo?$AAs?$AAf?$AAi?$AAl?$AAe?$AA?$CI?$AAf?$AAh?$AA?$CJ?$AA?5?$AA?$CG?$AA?5?$AAF?$AAO?$AAP?$AAE?$AAN?$AA?$CJ?$AA?$AA@ 0169 ___lock_fhandle 01a4 __write_nolock 01d2 ??_C@_1JE@ECKHFIFP@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAf?$AAi?$AAl?$AAe?$AA?5?$AAd?$AAe?$AAs?$AAc?$AAr?$AAi?$AAp?$AAt?$AAo?$AAr?$AA?4?$AA?5?$AAF?$AAi?$AAl?$AAe?$AA?5@ 0202 __unlock_fhandle"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 E8 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 83 7D 08 FE 75 1E E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 C8 FF E9 B9 01 00 00 83 7D 08 00 7C 14 8B 45 08 3B 05 ?? ?? ?? ?? 73 09 C7 45 D8 01 00 00 00 EB 07 C7 45 D8 00 00 00 00 8B 4D D8 89 4D E0 83 7D E0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 47 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 39 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 6A 00 6A 47 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 2F 01 00 00 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F 6B C9 28 8B 14 85 ?? ?? ?? ?? 0F BE 44 0A 04 83 E0 01 F7 D8 1B C0 F7 D8 89 45 DC 75 1E 68 ?? ?? ?? ?? 6A 00 6A 48 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D DC 00 75 39 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 6A 00 6A 48 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 A9 00 00 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F 6B C9 28 8B 14 85 ?? ?? ?? ?? 0F BE 44 0A 04 83 E0 01 74 19 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 89 45 E4 EB 3F E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? C7 00 00 00 00 00 C7 45 E4 FF FF FF FF 33 C9 75 1E 68 ?? ?? ?? ?? 6A 00 6A 53 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0D 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 E4 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_57_1_0 {
	meta:
		name = "__write_nolock"
		size = 2582
		refs = "000a ___security_cookie 004e ??_C@_1BM@KFJLMBPG@?$AA?$CI?$AAb?$AAu?$AAf?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0057 ??_C@_1BA@PMLNGJCB@?$AAw?$AAr?$AAi?$AAt?$AAe?$AA?4?$AAc?$AA?$AA@ 005e __CrtDbgReportW 0072 ___doserrno 007d __errno 0091 ??_C@_1BM@NCANHCIP@?$AA_?$AAw?$AAr?$AAi?$AAt?$AAe?$AA_?$AAn?$AAo?$AAl?$AAo?$AAc?$AAk?$AA?$AA@ 009b __invalid_parameter 00bc ___pioinfo 00f0 ??_C@_1CC@EEOLPHGO@?$AA?$CI?$AA?$CI?$AAc?$AAn?$AAt?$AA?5?$AA?$CG?$AA?5?$AA1?$AA?$CJ?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$CJ?$AA?$AA@ 0177 __lseeki64_nolock 0183 __isatty 01b2 __getptd 01eb __imp__GetConsoleMode@8 0210 __imp__GetConsoleCP@0 025f _isleadbyte 0275 _mbtowc 0327 __imp__WideCharToMultiByte@32 0365 __imp__WriteFile@20 0387 __imp__GetLastError@0 0422 __putwch_nolock 09a6 __dosmaperr 0a0e @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC A0 0C 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 BC C7 45 E8 00 00 00 00 C7 45 E4 00 00 00 00 C7 45 FC 00 00 00 00 8B 45 FC 89 45 EC 83 7D 10 00 75 07 33 C0 E9 CD 09 00 00 33 C9 83 7D 0C 00 0F 95 C1 89 4D E0 83 7D E0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 73 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 39 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 73 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 5E 09 00 00 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F 6B C9 28 8B 14 85 ?? ?? ?? ?? 8A 44 0A 24 D0 E0 D0 F8 88 45 FB 0F BE 4D FB 83 F9 02 74 09 0F BE 55 FB 83 FA 01 75 6F 8B 45 10 83 E0 01 F7 D8 1B C0 83 C0 01 89 45 DC 75 1E 68 ?? ?? ?? ?? 6A 00 6A 7B 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D DC 00 75 39 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 7B 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 BC 08 00 00 8B 55 08 C1 FA 05 8B 45 08 83 E0 1F 6B C0 28 8B 0C 95 ?? ?? ?? ?? 0F BE 54 01 04 83 E2 20 74 12 6A 02 6A 00 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 64 8B 55 08 C1 FA 05 8B 45 08 83 E0 1F 6B C0 28 8B 0C 95 ?? ?? ?? ?? 0F BE 54 01 04 81 E2 80 00 00 00 74 41 E8 ?? ?? ?? ?? 89 45 D4 8B 45 D4 8B 48 6C 33 D2 83 79 14 00 0F 94 C2 89 55 E4 8D 45 D8 50 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F 6B D2 28 8B 04 8D ?? ?? ?? ?? 8B 0C 10 51 FF 15 ?? ?? ?? ?? 89 45 E8 83 7D E8 00 0F 84 A2 02 00 00 83 7D E4 00 74 0C 0F BE 55 FB 85 D2 0F 84 90 02 00 00 FF 15 ?? ?? ?? ?? 89 45 C4 C7 45 C8 00 00 00 00 C7 45 CC 00 00 00 00 8B 45 0C 89 45 D0 8B 4D D0 2B 4D 0C 3B 4D 10 0F 83 5F 02 00 00 0F BE 55 FB 85 D2 0F 85 89 00 00 00 8B 45 D0 0F BE 08 33 D2 83 F9 0A 0F 94 C2 89 55 B0 8B 45 D0 0F BE 08 51 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 1E 6A 01 8B 55 D0 52 8D 45 C0 50 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 FF 75 05 E9 13 02 00 00 EB 3C 8B 4D D0 2B 4D 0C 8B 55 10 2B D1 83 FA 01 76 27 6A 02 8B 45 D0 50 8D 4D C0 51 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 FF 75 05 E9 E5 01 00 00 8B 55 D0 83 C2 01 89 55 D0 EB 05 E9 D5 01 00 00 8B 45 D0 83 C0 01 89 45 D0 EB 34 0F BE 4D FB 83 F9 01 74 09 0F BE 55 FB 83 FA 02 75 22 8B 45 D0 66 8B 08 66 89 4D C0 0F B7 55 C0 33 C0 83 FA 0A 0F 94 C0 89 45 B0 8B 4D D0 83 C1 02 89 4D D0 0F BE 55 FB 85 D2 0F 85 FB 00 00 00 6A 00 6A 00 6A 05 8D 45 B4 50 6A 01 8D 4D C0 51 6A 00 8B 55 C4 52 FF 15 ?? ?? ?? ?? 89 45 C8 83 7D C8 00 75 07 E9 60 01 00 00 EB 58 6A 00 8D 45 CC 50 8B 4D C8 51 8D 55 B4 52 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F 6B C9 28 8B 14 85 ?? ?? ?? ?? 8B 04 0A 50 FF 15 ?? ?? ?? ?? 85 C0 74 18 8B 4D FC 03 4D CC 89 4D FC 8B 55 CC 3B 55 C8 7D 05 E9 16 01 00 00 EB 0E FF 15 ?? ?? ?? ?? 89 45 F4 E9 06 01 00 00 83 7D B0 00 74 6C C7 45 C8 01 00 00 00 C6 45 B4 0D 6A 00 8D 45 CC 50 8B 4D C8 51 8D 55 B4 52 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F 6B C9 28 8B 14 85 ?? ?? ?? ?? 8B 04 0A 50 FF 15 ?? ?? ?? ?? 85 C0 74 21 8B 4D CC 3B 4D C8 7D 05 E9 B6 00 00 00 8B 55 EC 83 C2 01 89 55 EC 8B 45 FC 83 C0 01 89 45 FC EB 0E FF 15 ?? ?? ?? ?? 89 45 F4 E9 94 00 00 00 E9 8A 00 00 00 0F BE 4D FB 83 F9 01 74 09 0F BE 55 FB 83 FA 02 75 78 66 8B 45 C0 50 E8 ?? ?? ?? ?? 83 C4 04 0F B7 C8 0F B7 55 C0 3B CA 75 0B 8B 45 FC 83 C0 01 89 45 FC EB 0B FF 15 ?? ?? ?? ?? 89 45 F4 EB 4F 83 7D B0 00 74 44 C7 45 C8 01 00 00 00 66 C7 45 C0 0D 00 66 8B 4D C0 51 E8 ?? ?? ?? ?? 83 C4 04 0F B7 D0 0F B7 45 C0 3B D0 75 14 8B 4D FC 83 C1 01 89 4D FC 8B 55 EC 83 C2 01 89 55 EC EB 0B FF 15 ?? ?? ?? ?? 89 45 F4 EB 05 E9 92 FD FF FF E9 D6 04 00 00 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F 6B C9 28 8B 14 85 ?? ?? ?? ?? 0F BE 44 0A 04 25 80 00 00 00 0F 84 66 04 00 00 C7 45 F4 00 00 00 00 0F BE 4D FB 85 C9 0F 85 40 01 00 00 C7 85 A4 FB FF FF 00 00 00 00 C7 85 A0 FB FF FF 00 00 00 00 8B 55 0C 89 95 A4 FB FF FF 8B 85 A4 FB FF FF 2B 45 0C 3B 45 10 0F 83 0C 01 00 00 8D 8D A8 FB FF FF 89 8D A0 FB FF FF 8B 95 A0 FB FF FF 8D 85 A8 FB FF FF 2B D0 81 FA 00 04 00 00 73 7A 8B 8D A4 FB FF FF 2B 4D 0C 3B 4D 10 73 6C 8B 95 A4 FB FF FF 8A 02 88 85 9F FB FF FF 8B 8D A4 FB FF FF 83 C1 01 89 8D A4 FB FF FF 0F BE 95 9F FB FF FF 83 FA 0A 75 21 8B 45 EC 83 C0 01 89 45 EC 8B 8D A0 FB FF FF C6 01 0D 8B 95 A0 FB FF FF 83 C2 01 89 95 A0 FB FF FF 8B 85 A0 FB FF FF 8A 8D 9F FB FF FF 88 08 8B 95 A0 FB FF FF 83 C2 01 89 95 A0 FB FF FF E9 70 FF FF FF 6A 00 8D 45 F0 50 8B 8D A0 FB FF FF 8D 95 A8 FB FF FF 2B CA 51 8D 85 A8 FB FF FF 50 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F 6B D2 28 8B 04 8D ?? ?? ?? ?? 8B 0C 10 51 FF 15 ?? ?? ?? ?? 85 C0 74 20 8B 55 FC 03 55 F0 89 55 FC 8B 85 A0 FB FF FF 8D 8D A8 FB FF FF 2B C1 39 45 F0 7D 02 EB 12 EB 0B FF 15 ?? ?? ?? ?? 89 45 F4 EB 05 E9 E2 FE FF FF E9 11 03 00 00 0F BE 55 FB 83 FA 02 0F 85 3F 01 00 00 8B 45 0C 89 85 84 F7 FF FF C7 85 8C F7 FF FF 00 00 00 00 8B 8D 84 F7 FF FF 2B 4D 0C 3B 4D 10 0F 83 15 01 00 00 8D 95 90 F7 FF FF 89 95 8C F7 FF FF 8B 85 8C F7 FF FF 8D 8D 90 F7 FF FF 2B C1 3D FF 03 00 00 0F 83 80 00 00 00 8B 95 84 F7 FF FF 2B 55 0C 3B 55 10 73 72 8B 85 84 F7 FF FF 66 8B 08 66 89 8D 88 F7 FF FF 8B 95 84 F7 FF FF 83 C2 02 89 95 84 F7 FF FF 0F B7 85 88 F7 FF FF 83 F8 0A 75 23 8B 4D EC 83 C1 02 89 4D EC 8B 95 8C F7 FF FF 66 C7 02 0D 00 8B 85 8C F7 FF FF 83 C0 02 89 85 8C F7 FF FF 8B 8D 8C F7 FF FF 66 8B 95 88 F7 FF FF 66 89 11 8B 85 8C F7 FF FF 83 C0 02 89 85 8C F7 FF FF E9 67 FF FF FF 6A 00 8D 4D F0 51 8B 95 8C F7 FF FF 8D 85 90 F7 FF FF 2B D0 52 8D 8D 90 F7 FF FF 51 8B 55 08 C1 FA 05 8B 45 08 83 E0 1F 6B C0 28 8B 0C 95 ?? ?? ?? ?? 8B 14 01 52 FF 15 ?? ?? ?? ?? 85 C0 74 20 8B 45 FC 03 45 F0 89 45 FC 8B 8D 8C F7 FF FF 8D 95 90 F7 FF FF 2B CA 39 4D F0 7D 02 EB 12 EB 0B FF 15 ?? ?? ?? ?? 89 45 F4 EB 05 E9 D9 FE FF FF E9 C5 01 00 00 8B 45 0C 89 85 1C F6 FF FF C7 85 24 F6 FF FF 00 00 00 00 8B 4D 0C 89 8D 1C F6 FF FF 8B 95 1C F6 FF FF 2B 55 0C 3B 55 10 0F 83 97 01 00 00 C7 85 64 F3 FF FF 00 00 00 00 8D 85 28 F6 FF FF 89 85 24 F6 FF FF 8B 8D 24 F6 FF FF 8D 95 28 F6 FF FF 2B CA 81 F9 52 01 00 00 73 77 8B 85 1C F6 FF FF 2B 45 0C 3B 45 10 73 69 8B 8D 1C F6 FF FF 66 8B 11 66 89 95 20 F6 FF FF 8B 85 1C F6 FF FF 83 C0 02 89 85 1C F6 FF FF 0F B7 8D 20 F6 FF FF 83 F9 0A 75 1A 8B 95 24 F6 FF FF 66 C7 02 0D 00 8B 85 24 F6 FF FF 83 C0 02 89 85 24 F6 FF FF 8B 8D 24 F6 FF FF 66 8B 95 20 F6 FF FF 66 89 11 8B 85 24 F6 FF FF 83 C0 02 89 85 24 F6 FF FF E9 73 FF FF FF 6A 00 6A 00 68 AB 02 00 00 8D 8D 68 F3 FF FF 51 8B 85 24 F6 FF FF 8D 95 28 F6 FF FF 2B C2 99 2B C2 D1 F8 50 8D 85 28 F6 FF FF 50 6A 00 68 E9 FD 00 00 FF 15 ?? ?? ?? ?? 89 85 64 F3 FF FF 83 BD 64 F3 FF FF 00 75 13 FF 15 ?? ?? ?? ?? 89 45 F4 E9 9F 00 00 00 E9 95 00 00 00 C7 85 60 F3 FF FF 00 00 00 00 6A 00 8D 4D F0 51 8B 95 64 F3 FF FF 2B 95 60 F3 FF FF 52 8B 85 60 F3 FF FF 8D 8C 05 68 F3 FF FF 51 8B 55 08 C1 FA 05 8B 45 08 83 E0 1F 6B C0 28 8B 0C 95 ?? ?? ?? ?? 8B 14 01 52 FF 15 ?? ?? ?? ?? 85 C0 74 11 8B 85 60 F3 FF FF 03 45 F0 89 85 60 F3 FF FF EB 0B FF 15 ?? ?? ?? ?? 89 45 F4 EB 0E 8B 8D 64 F3 FF FF 3B 8D 60 F3 FF FF 7F 91 8B 95 64 F3 FF FF 3B 95 60 F3 FF FF 7E 02 EB 11 8B 85 1C F6 FF FF 2B 45 0C 89 45 FC E9 57 FE FF FF EB 4A 6A 00 8D 4D F0 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F 6B D2 28 8B 04 8D ?? ?? ?? ?? 8B 0C 10 51 FF 15 ?? ?? ?? ?? 85 C0 74 0F C7 45 F4 00 00 00 00 8B 55 F0 89 55 FC EB 09 FF 15 ?? ?? ?? ?? 89 45 F4 83 7D FC 00 0F 85 84 00 00 00 83 7D F4 00 74 30 83 7D F4 05 75 17 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 8B 4D F4 89 08 EB 0C 8B 55 F4 52 E8 ?? ?? ?? ?? 83 C4 04 83 C8 FF EB 56 EB 4C 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F 6B C9 28 8B 14 85 ?? ?? ?? ?? 0F BE 44 0A 04 83 E0 40 74 11 8B 4D 0C 0F BE 11 83 FA 1A 75 06 33 C0 EB 25 EB 1B E8 ?? ?? ?? ?? C7 00 1C 00 00 00 E8 ?? ?? ?? ?? C7 00 00 00 00 00 83 C8 FF EB 08 EB 06 8B 45 FC 2B 45 EC 8B 4D BC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_59_0_0 {
	meta:
		name = "__wcsset_s"
		size = 522
		refs = "002f ??_C@_1FC@PFMLEHKI@?$AA?$CI?$AA?$CI?$AA_?$AAD?$AAs?$AAt?$AA?$CJ?$AA?$CJ?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?$CI?$AA_?$AAS?$AAi?$AAz?$AAe?$AAI?$AAn?$AAW?$AAo?$AAr@ 0038 ??_C@_1GK@PNCPIHGH@?$AAF?$AA?3?$AA?2?$AAR?$AAT?$AAM?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAS?$AAE?$AAL?$AAF?$AA_?$AAX?$AA8?$AA6?$AA?2@ 003f __CrtDbgReportW 0053 __errno 0067 ??_C@_1BE@DPBIJIKN@?$AA_?$AAw?$AAc?$AAs?$AAs?$AAe?$AAt?$AA_?$AAs?$AA?$AA@ 0071 __invalid_parameter 00e7 ___crtDebugFillThreshold 0113 _memset 011b ??_C@_1DM@FHLMIEG@?$AAS?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AAi?$AAs?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAn?$AAu?$AAl?$AAl?$AA?5?$AAt?$AAe?$AAr?$AAm?$AAi?$AAn?$AAa?$AAt?$AAe?$AAd?$AA?$AA@ 0144 ??_C@_1FA@MJKDNFFB@?$AA?$CI?$AAL?$AA?$CC?$AAS?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AAi?$AAs?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAn?$AAu?$AAl?$AAl?$AA?5?$AAt?$AAe?$AAr?$AAm?$AAi?$AAn?$AAa?$AAt?$AAe?$AAd@"
	strings:
		$1 = { 55 8B EC 83 EC 20 83 7D 08 00 74 0F 83 7D 0C 00 76 09 C7 45 EC 01 00 00 00 EB 07 C7 45 EC 00 00 00 00 8B 45 EC 89 45 F4 83 7D F4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 12 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F4 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 12 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 84 01 00 00 8B 55 08 89 55 FC 8B 45 0C 89 45 F8 8B 4D FC 0F B7 11 85 D2 74 20 8B 45 F8 83 E8 01 89 45 F8 74 15 8B 4D FC 66 8B 55 10 66 89 11 8B 45 FC 83 C0 02 89 45 FC EB D6 83 7D F8 00 0F 85 D2 00 00 00 8B 4D 08 66 C7 01 00 00 83 7D 0C FF 74 4A 81 7D 0C FF FF FF 7F 74 41 83 7D 0C 01 76 3B 8B 55 0C 83 EA 01 39 15 ?? ?? ?? ?? 73 0A A1 ?? ?? ?? ?? 89 45 E8 EB 09 8B 4D 0C 83 E9 01 89 4D E8 8B 55 E8 D1 E2 52 68 FD 00 00 00 8B 45 08 83 C0 02 50 E8 ?? ?? ?? ?? 83 C4 0C B9 ?? ?? ?? ?? 85 C9 74 0D 33 D2 74 09 C7 45 E4 01 00 00 00 EB 07 C7 45 E4 00 00 00 00 8B 45 E4 89 45 F0 83 7D F0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 1E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 1E 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 EB 72 83 7D 0C FF 74 6A 81 7D 0C FF FF FF 7F 74 61 8B 55 0C 2B 55 F8 83 C2 01 3B 55 0C 73 53 8B 45 0C 2B 45 F8 83 C0 01 8B 4D 0C 2B C8 39 0D ?? ?? ?? ?? 73 0B 8B 15 ?? ?? ?? ?? 89 55 E0 EB 11 8B 45 0C 2B 45 F8 83 C0 01 8B 4D 0C 2B C8 89 4D E0 8B 55 E0 D1 E2 52 68 FD 00 00 00 8B 45 0C 2B 45 F8 8B 4D 08 8D 54 41 02 52 E8 ?? ?? ?? ?? 83 C4 0C 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_60_0_0 {
	meta:
		name = "__mbctohira_l"
		size = 71
		refs = "000c __ismbckata_l"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 2B 81 7D 08 93 83 00 00 77 22 81 7D 08 7F 83 00 00 73 0E 8B 55 08 81 EA A1 00 00 00 89 55 08 EB 0B 8B 45 08 2D A2 00 00 00 89 45 08 8B 45 08 5D C3 }
	condition:
		$1
}

rule file_61_0_0 {
	meta:
		name = "__rt_probe_read4@4"
		size = 147
		refs = "0006 __sehtable$__rt_probe_read4@4 000b __except_handler4 001d ___security_cookie"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 EC 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 89 65 E8 C7 45 FC 00 00 00 00 8B 45 08 8B 08 89 4D DC C7 45 E4 01 00 00 00 C7 45 FC FE FF FF FF EB 2A 8B 55 EC 8B 02 8B 08 89 4D E0 8B 55 E0 33 C0 81 FA 05 00 00 C0 0F 94 C0 C3 8B 65 E8 C7 45 E4 00 00 00 00 C7 45 FC FE FF FF FF 8B 45 E4 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_62_0_0 {
	meta:
		name = "__ismbcalpha_l"
		size = 357
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0049 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0061 ??1_LocaleUpdate@@QAE@XZ 00a3 ___crtGetStringTypeA"
	strings:
		$1 = { 55 8B EC 83 EC 30 8B 45 0C 50 8D 4D F0 E8 ?? ?? ?? ?? 81 7D 08 FF 00 00 00 0F 86 DE 00 00 00 66 C7 45 EC 00 00 33 C9 66 89 4D EE 8B 55 08 C1 EA 08 81 E2 FF 00 00 00 88 55 E8 8B 45 08 25 FF 00 00 00 88 45 E9 8D 4D F0 E8 ?? ?? ?? ?? 8B 48 04 83 79 08 00 75 17 C7 45 E4 00 00 00 00 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 E4 E9 F4 00 00 00 6A 01 8D 4D F0 E8 ?? ?? ?? ?? 8B 50 04 8B 42 0C 50 8D 4D F0 E8 ?? ?? ?? ?? 8B 48 04 8B 51 04 52 8D 45 EC 50 6A 02 8D 4D E8 51 6A 01 8D 4D F0 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 20 85 C0 75 17 C7 45 E0 00 00 00 00 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 E0 E9 9C 00 00 00 0F B7 55 EE 85 D2 75 14 0F B7 45 EC 25 03 01 00 00 74 09 C7 45 D4 01 00 00 00 EB 07 C7 45 D4 00 00 00 00 8B 4D D4 89 4D DC 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 DC EB 66 EB 5C 8D 4D F0 E8 ?? ?? ?? ?? 8B 10 0F B6 45 08 8B 8A C8 00 00 00 0F B7 14 41 81 E2 03 01 00 00 75 22 8D 4D F0 E8 ?? ?? ?? ?? 8B 40 04 0F B6 4D 08 0F B6 54 08 1D 83 E2 01 75 09 C7 45 D0 00 00 00 00 EB 07 C7 45 D0 01 00 00 00 8B 45 D0 89 45 D8 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 D8 EB 08 8D 4D F0 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_63_0_0 {
	meta:
		name = "_div"
		size = 66
		altNames = "_ldiv"
	strings:
		$1 = { 55 8B EC 83 EC 08 8B 45 08 99 F7 7D 0C 89 45 F8 8B 45 08 99 F7 7D 0C 89 55 FC 83 7D 08 00 7D 18 83 7D FC 00 7E 12 8B 45 F8 83 C0 01 89 45 F8 8B 4D FC 2B 4D 0C 89 4D FC 8B 45 F8 8B 55 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_65_0_0 {
	meta:
		name = "_ldexp"
		size = 696
		refs = "0011 __ctrlfp 0039 __sptype 0089 __handle_qnan2 009e __real@3ff0000000000000 00bf __except2 00fe __decomp 0169 __d_inf 0171 __copysign 01bb __set_exp 0207 __real@0000000000000000"
	strings:
		$1 = { 55 8B EC 83 EC 24 68 FF FF 00 00 68 3F 13 00 00 E8 ?? ?? ?? ?? 83 C4 08 89 45 F8 0F B7 45 0E 25 F0 7F 00 00 3D F0 7F 00 00 0F 85 9C 00 00 00 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 89 45 DC 83 7D DC 00 7E 4C 83 7D DC 02 7E 08 83 7D DC 03 74 1B EB 3E 68 FF FF 00 00 8B 4D F8 51 E8 ?? ?? ?? ?? 83 C4 08 DD 45 08 E9 44 02 00 00 8B 55 F8 52 DB 45 10 83 EC 08 DD 1C 24 83 EC 08 DD 45 08 DD 1C 24 6A 19 E8 ?? ?? ?? ?? 83 C4 18 E9 1F 02 00 00 8B 45 F8 50 DD 45 08 DC 05 ?? ?? ?? ?? 83 EC 08 DD 1C 24 DB 45 10 83 EC 08 DD 1C 24 83 EC 08 DD 45 08 DD 1C 24 6A 19 6A 08 E8 ?? ?? ?? ?? 83 C4 24 E9 E9 01 00 00 D9 EE DC 5D 08 DF E0 F6 C4 44 7A 19 68 FF FF 00 00 8B 4D F8 51 E8 ?? ?? ?? ?? 83 C4 08 DD 45 08 E9 C4 01 00 00 8D 55 FC 52 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 0C DD 5D E8 83 7D 10 00 7D 21 B8 00 00 00 80 2B 45 10 39 45 FC 7D 09 C7 45 F4 00 00 00 80 EB 09 8B 4D FC 03 4D 10 89 4D F4 EB 1F BA FF FF FF 7F 2B 55 10 39 55 FC 7E 09 C7 45 F4 FF FF FF 7F EB 09 8B 45 FC 03 45 10 89 45 F4 81 7D F4 00 0A 00 00 7E 47 8B 4D F8 51 83 EC 08 DD 45 E8 DD 1C 24 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DD 1C 24 DB 45 10 83 EC 08 DD 1C 24 83 EC 08 DD 45 08 DD 1C 24 6A 19 6A 11 E8 ?? ?? ?? ?? 83 C4 24 E9 16 01 00 00 81 7D F4 00 04 00 00 7E 4E 8B 55 F4 81 EA 00 06 00 00 52 83 EC 08 DD 45 E8 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 0C DD 5D E0 8B 45 F8 50 83 EC 08 DD 45 E0 DD 1C 24 DB 45 10 83 EC 08 DD 1C 24 83 EC 08 DD 45 08 DD 1C 24 6A 19 6A 11 E8 ?? ?? ?? ?? 83 C4 24 E9 BF 00 00 00 81 7D F4 03 F6 FF FF 7D 36 8B 4D F8 51 DD 45 E8 DC 0D ?? ?? ?? ?? 83 EC 08 DD 1C 24 DB 45 10 83 EC 08 DD 1C 24 83 EC 08 DD 45 08 DD 1C 24 6A 19 6A 12 E8 ?? ?? ?? ?? 83 C4 24 E9 80 00 00 00 81 7D F4 03 FC FF FF 7D 4B 8B 55 F4 81 C2 00 06 00 00 52 83 EC 08 DD 45 E8 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 0C DD 5D E0 8B 45 F8 50 83 EC 08 DD 45 E0 DD 1C 24 DB 45 10 83 EC 08 DD 1C 24 83 EC 08 DD 45 08 DD 1C 24 6A 19 6A 12 E8 ?? ?? ?? ?? 83 C4 24 EB 2C 8B 4D F4 51 83 EC 08 DD 45 E8 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 0C DD 5D E0 68 FF FF 00 00 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 08 DD 45 E0 8B E5 5D C3 }
	condition:
		$1
}

rule file_66_0_0 {
	meta:
		name = "__wfindfirst64i32"
		size = 693
		refs = "000a ___security_cookie 002c ??_C@_1BM@BDKGMOHE@?$AA?$CI?$AAp?$AAf?$AAd?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0035 ??_C@_1GE@CIBOLPCA@?$AAf?$AA?3?$AA?2?$AAr?$AAt?$AAm?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2@ 003c __CrtDbgReportW 0053 __errno 0067 ??_C@_1CC@PDEPDLOI@?$AA_?$AAw?$AAf?$AAi?$AAn?$AAd?$AAf?$AAi?$AAr?$AAs?$AAt?$AA6?$AA4?$AAi?$AA3?$AA2?$AA?$AA@ 0071 __invalid_parameter 0094 ??_C@_1FK@EIHIEBPI@?$AA?$CI?$AAs?$AAi?$AAz?$AAe?$AAo?$AAf?$AA?$CI?$AAp?$AAf?$AAd?$AA?9?$AA?$DO?$AAn?$AAa?$AAm?$AAe?$AA?$CJ?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAs?$AAi?$AAz?$AAe?$AAo?$AAf?$AA?$CI?$AAw?$AAf?$AAd@ 0101 ??_C@_1CC@GOBCANBH@?$AA?$CI?$AAs?$AAz?$AAW?$AAi?$AAl?$AAd?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0162 __imp__FindFirstFileW@8 0171 __imp__GetLastError@0 01a8 $LN15 01af $LN16 0203 ___time64_t_from_ft 025e ??_C@_1JO@CLIBFCJI@?$AAw?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAp?$AAf?$AAd?$AA?9?$AA?$DO?$AAn?$AAa?$AAm?$AAe?$AA?0?$AA?5?$AA?$CI?$AAs?$AAi?$AAz?$AAe?$AAo?$AAf?$AA?$CI?$AAp?$AAf?$AAd?$AA?9@ 0276 _wcscpy_s 027f __invoke_watson_if_error 028f @__security_check_cookie@4 0298 $LN3 029c $LN2 02a0 $LN1"
	strings:
		$1 = { 55 8B EC 81 EC 6C 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 F8 33 C0 83 7D 0C 00 0F 95 C0 89 85 A0 FD FF FF 83 BD A0 FD FF FF 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 4F 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD A0 FD FF FF 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 4F 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 09 02 00 00 C7 85 9C FD FF FF 01 00 00 00 83 BD 9C FD FF FF 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 54 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 9C FD FF FF 00 75 2E E8 ?? ?? ?? ?? C7 00 0C 00 00 00 6A 00 6A 54 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 A1 01 00 00 33 C0 83 7D 08 00 0F 95 C0 89 85 98 FD FF FF 83 BD 98 FD FF FF 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 55 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 98 FD FF FF 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 55 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 34 01 00 00 8D 95 A8 FD FF FF 52 8B 45 08 50 FF 15 ?? ?? ?? ?? 89 45 FC 83 7D FC FF 75 71 FF 15 ?? ?? ?? ?? 89 85 A4 FD FF FF 8B 8D A4 FD FF FF 89 8D 94 FD FF FF 8B 95 94 FD FF FF 83 EA 02 89 95 94 FD FF FF 83 BD 94 FD FF FF 10 77 2E 8B 85 94 FD FF FF 0F B6 88 ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 00 02 00 00 00 EB 18 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB 0B E8 ?? ?? ?? ?? C7 00 16 00 00 00 83 C8 FF E9 A9 00 00 00 8B 95 A8 FD FF FF 81 EA 80 00 00 00 F7 DA 1B D2 23 95 A8 FD FF FF 8B 45 0C 89 10 8D 8D AC FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 89 41 08 89 51 0C 8D 95 B4 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 89 41 10 89 51 14 8D 95 BC FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 89 41 18 89 51 1C 8B 55 0C 8B 85 C8 FD FF FF 89 42 20 6A 00 6A 77 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 8D D4 FD FF FF 51 68 04 01 00 00 8B 55 0C 83 C2 24 52 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 45 FC 8B 4D F8 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 02 02 02 02 01 02 02 02 02 02 02 02 02 02 00 }
	condition:
		$1
}

rule file_66_2_0 {
	meta:
		name = "__wfindnext64i32"
		size = 709
		refs = "000a ___security_cookie 002c ??_C@_1FA@DAHAMGDA@?$AA?$CI?$AA?$CI?$AAH?$AAA?$AAN?$AAD?$AAL?$AAE?$AA?$CJ?$AAh?$AAF?$AAi?$AAl?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAI?$AAN?$AAV?$AAA?$AAL?$AAI?$AAD?$AA_?$AAH?$AAA?$AAN?$AAD?$AAL?$AAE@ 0038 ??_C@_1GE@CIBOLPCA@?$AAf?$AA?3?$AA?2?$AAr?$AAt?$AAm?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2@ 003f __CrtDbgReportW 0056 __errno 006d ??_C@_1CA@NINPBEB@?$AA_?$AAw?$AAf?$AAi?$AAn?$AAd?$AAn?$AAe?$AAx?$AAt?$AA6?$AA4?$AAi?$AA3?$AA2?$AA?$AA@ 0077 __invalid_parameter 009f ??_C@_1BM@BDKGMOHE@?$AA?$CI?$AAp?$AAf?$AAd?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 010d ??_C@_1FK@EIHIEBPI@?$AA?$CI?$AAs?$AAi?$AAz?$AAe?$AAo?$AAf?$AA?$CI?$AAp?$AAf?$AAd?$AA?9?$AA?$DO?$AAn?$AAa?$AAm?$AAe?$AA?$CJ?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAs?$AAi?$AAz?$AAe?$AAo?$AAf?$AA?$CI?$AAw?$AAf?$AAd@ 0174 __imp__FindNextFileW@8 017e __imp__GetLastError@0 01b5 $LN15 01bc $LN16 0210 ___time64_t_from_ft 026e ??_C@_1JO@CLIBFCJI@?$AAw?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAp?$AAf?$AAd?$AA?9?$AA?$DO?$AAn?$AAa?$AAm?$AAe?$AA?0?$AA?5?$AA?$CI?$AAs?$AAi?$AAz?$AAe?$AAo?$AAf?$AA?$CI?$AAp?$AAf?$AAd?$AA?9@ 0286 _wcscpy_s 028f __invoke_watson_if_error 029e @__security_check_cookie@4 02a8 $LN3 02ac $LN2 02b0 $LN1"
	strings:
		$1 = { 55 8B EC 81 EC 6C 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 33 C0 83 7D 08 FF 0F 95 C0 89 85 A0 FD FF FF 83 BD A0 FD FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 A1 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD A0 FD FF FF 00 75 31 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 A1 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 12 02 00 00 33 D2 83 7D 0C 00 0F 95 C2 89 95 9C FD FF FF 83 BD 9C FD FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 A2 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 9C FD FF FF 00 75 31 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 A2 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 9F 01 00 00 C7 85 98 FD FF FF 01 00 00 00 83 BD 98 FD FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 A3 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 98 FD FF FF 00 75 31 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 6A 00 68 A3 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 31 01 00 00 8D 95 A8 FD FF FF 52 8B 45 08 50 FF 15 ?? ?? ?? ?? 85 C0 75 71 FF 15 ?? ?? ?? ?? 89 85 A4 FD FF FF 8B 8D A4 FD FF FF 89 8D 94 FD FF FF 8B 95 94 FD FF FF 83 EA 02 89 95 94 FD FF FF 83 BD 94 FD FF FF 10 77 2E 8B 85 94 FD FF FF 0F B6 88 ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 00 02 00 00 00 EB 18 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB 0B E8 ?? ?? ?? ?? C7 00 16 00 00 00 83 C8 FF E9 AB 00 00 00 8B 95 A8 FD FF FF 81 EA 80 00 00 00 F7 DA 1B D2 23 95 A8 FD FF FF 8B 45 0C 89 10 8D 8D AC FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 89 41 08 89 51 0C 8D 95 B4 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 89 41 10 89 51 14 8D 95 BC FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 89 41 18 89 51 1C 8B 55 0C 8B 85 C8 FD FF FF 89 42 20 6A 00 68 C5 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 8D D4 FD FF FF 51 68 04 01 00 00 8B 55 0C 83 C2 24 52 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 33 C0 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 8B FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 02 02 02 02 01 02 02 02 02 02 02 02 02 02 00 }
	condition:
		$1
}

rule file_67_0_0 {
	meta:
		name = "__CIatan_pentium4"
		size = 748
		refs = "002a _mabs 0032 _in 0046 _in1 0050 _in0 006e _p01 007a _p23 0086 _p45 0092 _p60 00be _in2 00dc _d01 00e8 _d23 00f4 _d45 0100 _d67 010c _d89 0118 _d1011 0124 _d1213 0130 _d1400 0164 _in3 016e _cnst8 0176 _cntshf 0197 __atan_table 01ab _one 01c6 _onen 0254 _zero 0263 _minval 026b libm_small 029f _mexp 02bd _pi_2d 02df ___libm_error_support"
	strings:
		$1 = { 55 8B EC 83 EC 08 83 E4 F0 DD 1C 24 F3 0F 7E 3C 24 E8 08 00 00 00 C9 C3 F3 0F 7E 7C 24 04 66 0F 14 FF 66 0F 28 D7 66 0F 54 15 ?? ?? ?? ?? 66 0F 2F 15 ?? ?? ?? ?? 0F 8A 86 02 00 00 0F 83 55 02 00 00 66 0F 2F 15 ?? ?? ?? ?? 73 6E 66 0F 2F 15 ?? ?? ?? ?? 0F 82 F6 01 00 00 66 0F 28 CA 66 0F 59 CA 66 0F 28 D9 66 0F 59 D9 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? F2 0F 59 E9 66 0F 28 DD 66 0F C6 DB 01 F2 0F 58 EB F2 0F 59 EF F2 0F 5C FD 66 0F D6 7C 24 04 DD 44 24 04 C3 66 0F 2F 15 ?? ?? ?? ?? 0F 83 90 00 00 00 66 0F 28 CA 66 0F 59 CA 66 0F 28 D9 66 0F 59 D9 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? F2 0F 59 E9 66 0F 28 DD 66 0F C6 DB 01 F2 0F 58 EB F2 0F 59 EF F2 0F 5C FD 66 0F D6 7C 24 04 DD 44 24 04 C3 F3 0F 7E F7 66 0F 57 F2 66 0F 2F 15 ?? ?? ?? ?? 73 4F F3 0F 7E 05 ?? ?? ?? ?? F3 0F 7E 2D ?? ?? ?? ?? F3 0F 7E DA F2 0F 58 D8 66 0F 73 D3 2C 66 0F FA DD 66 0F 7E D8 8D 04 40 F3 0F 7E 2C C5 ?? ?? ?? ?? F3 0F 7E DA F2 0F 5C D5 F2 0F 59 DD F2 0F 58 1D ?? ?? ?? ?? F2 0F 5E D3 66 0F 14 D2 EB 19 B8 00 03 00 00 F3 0F 7E C2 F3 0F 7E 15 ?? ?? ?? ?? F2 0F 5E D0 66 0F 14 D2 F3 0F 7E 04 C5 ?? ?? ?? ?? F3 0F 7E 24 C5 ?? ?? ?? ?? 66 0F 28 CA 66 0F 59 CA 66 0F 28 D9 66 0F 59 D9 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? F2 0F 59 E9 66 0F 28 DD 66 0F C6 DB 01 F2 0F 58 EB F2 0F 59 EA F2 0F 5C EC F2 0F 5C EA F2 0F 5C C5 66 0F 56 C6 66 0F D6 44 24 04 DD 44 24 04 C3 66 0F 2F 15 ?? ?? ?? ?? 75 05 DD 44 24 04 C3 66 0F 2F 15 ?? ?? ?? ?? 73 1D DD 05 ?? ?? ?? ?? DC 0D ?? ?? ?? ?? 83 EC 08 DD 1C 24 DD 04 24 83 C4 08 DC 44 24 04 C3 DD 05 ?? ?? ?? ?? DC 0D ?? ?? ?? ?? DC 44 24 04 C3 F3 0F 7E C2 F3 0F 7E 1D ?? ?? ?? ?? 66 0F 54 C3 66 0F 2E C3 7A 15 8B 44 24 08 C1 E8 1F DD 05 ?? ?? ?? ?? DC 04 C5 ?? ?? ?? ?? C3 BA EB 03 00 00 83 EC 10 89 54 24 0C 8B D4 83 C2 14 89 54 24 08 89 54 24 04 89 14 24 E8 ?? ?? ?? ?? 83 C4 10 DD 44 24 04 C3 90 }
	condition:
		$1
}

rule file_68_0_0 {
	meta:
		name = "__mbsncoll_l"
		size = 640
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0023 ??1_LocaleUpdate@@QAE@XZ 0042 ??_C@_1BG@MODEICJK@?$AAs?$AA1?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 004b ??_C@_1BG@MKPKKOGG@?$AAm?$AAb?$AAs?$AAn?$AAc?$AAo?$AAl?$AAl?$AA?4?$AAc?$AA?$AA@ 0052 __CrtDbgReportW 0066 __errno 007a ??_C@_1BI@ODKNJFNF@?$AA_?$AAm?$AAb?$AAs?$AAn?$AAc?$AAo?$AAl?$AAl?$AA_?$AAl?$AA?$AA@ 0084 __invalid_parameter 00b5 ??_C@_1BG@GBJNMPFA@?$AAs?$AA2?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0128 ??_C@_1BK@CMPKHPEC@?$AAn?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAI?$AAN?$AAT?$AA_?$AAM?$AAA?$AAX?$AA?$AA@ 018c ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 01aa __strncoll_l 01d6 __mbsnbcnt_l 0239 ___crtCompareStringA"
	strings:
		$1 = { 55 8B EC 83 EC 44 8B 45 14 50 8D 4D E4 E8 ?? ?? ?? ?? 83 7D 10 00 75 17 C7 45 D4 00 00 00 00 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 D4 E9 4D 02 00 00 33 C9 83 7D 08 00 0F 95 C1 89 4D E0 83 7D E0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 3D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 3E 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 D0 FF FF FF 7F 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 D0 E9 DA 01 00 00 33 C0 83 7D 0C 00 0F 95 C0 89 45 DC 83 7D DC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3F 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D DC 00 75 3D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 3F 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 CC FF FF FF 7F 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 CC E9 67 01 00 00 BA FF FF FF 7F 3B 55 10 1B C0 83 C0 01 89 45 D8 75 1E 68 ?? ?? ?? ?? 6A 00 6A 40 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D8 00 75 3D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 40 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 C8 FF FF FF 7F 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 C8 E9 F4 00 00 00 8D 4D E4 E8 ?? ?? ?? ?? 8B 50 04 83 7A 08 00 75 2B 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 C4 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 C4 E9 B8 00 00 00 8D 4D E4 E8 ?? ?? ?? ?? 50 8B 4D 10 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 89 45 FC 8D 4D E4 E8 ?? ?? ?? ?? 50 8B 45 10 50 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F4 8D 4D E4 E8 ?? ?? ?? ?? 8B 50 04 8B 42 04 50 8B 4D F4 51 8B 55 0C 52 8B 45 FC 50 8B 4D 08 51 68 00 10 00 00 8D 4D E4 E8 ?? ?? ?? ?? 8B 50 04 8B 42 0C 50 8D 4D E4 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 20 89 45 F8 83 7D F8 00 75 1F E8 ?? ?? ?? ?? C7 00 16 00 00 00 C7 45 C0 FF FF FF 7F 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 C0 EB 14 8B 4D F8 83 E9 02 89 4D BC 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 BC 8B E5 5D C3 }
	condition:
		$1
}

rule file_70_0_0 {
	meta:
		name = "__calloc_impl"
		size = 450
		refs = "0006 __sehtable$__calloc_impl 000b __except_handler4 001d ___security_cookie 004e ??_C@_1DK@JIJJGNG@?$AA?$CI?$AA_?$AAH?$AAE?$AAA?$AAP?$AA_?$AAM?$AAA?$AAX?$AAR?$AAE?$AAQ?$AA?5?$AA?1?$AA?5?$AAn?$AAu?$AAm?$AA?$CJ?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AAs?$AAi?$AAz?$AAe?$AA?$AA@ 0057 ??_C@_1BC@ODENMCBF@?$AAc?$AAa?$AAl?$AAl?$AAo?$AAc?$AA?4?$AAc?$AA?$AA@ 005e __CrtDbgReportW 0072 __errno 0086 ??_C@_1BK@HEKKHFBL@?$AA_?$AAc?$AAa?$AAl?$AAl?$AAo?$AAc?$AA_?$AAi?$AAm?$AAp?$AAl?$AA?$AA@ 0090 __invalid_parameter 00ce ___active_heap 00ec ___sbh_threshold 00f5 __lock 0108 ___sbh_alloc_block 0123 __unlock 013c _memset 0151 __crtheap 0158 __imp__HeapAlloc@12 0167 __newmode 018d __callnewh"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 EC 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 83 7D 08 00 76 68 B8 E0 FF FF FF 33 D2 F7 75 08 3B 45 0C 1B C0 83 C0 01 89 45 DC 75 1E 68 ?? ?? ?? ?? 6A 00 6A 1E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D DC 00 75 2D E8 ?? ?? ?? ?? C7 00 0C 00 00 00 6A 00 6A 1E 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 12 01 00 00 8B 55 0C 0F AF 55 08 89 55 0C 8B 45 0C 89 45 E0 83 7D 0C 00 75 07 C7 45 0C 01 00 00 00 C7 45 E4 00 00 00 00 83 7D 0C E0 0F 87 93 00 00 00 83 3D ?? ?? ?? ?? 03 75 6E 83 7D 0C E0 77 0C 8B 4D 0C 83 C1 0F 83 E1 F0 89 4D 0C 8B 55 E0 3B 15 ?? ?? ?? ?? 77 51 6A 04 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 45 E0 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 E4 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0B 6A 04 E8 ?? ?? ?? ?? 83 C4 04 C3 83 7D E4 00 74 12 8B 4D E0 51 6A 00 8B 55 E4 52 E8 ?? ?? ?? ?? 83 C4 0C 83 7D E4 00 75 16 8B 45 0C 50 6A 08 8B 0D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 89 45 E4 83 7D E4 00 75 09 83 3D ?? ?? ?? ?? 00 75 1A 83 7D E4 00 75 0F 83 7D 10 00 74 09 8B 55 10 C7 02 0C 00 00 00 8B 45 E4 EB 28 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 13 83 7D 10 00 74 09 8B 4D 10 C7 01 0C 00 00 00 33 C0 EB 05 E9 0B FF FF FF 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_70_1_0 {
	meta:
		name = "__calloc_base"
		size = 74
		refs = "001a __calloc_impl 0031 __errno"
	strings:
		$1 = { 55 8B EC 83 EC 08 C7 45 FC 00 00 00 00 8D 45 FC 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F8 83 7D F8 00 75 19 83 7D FC 00 74 13 E8 ?? ?? ?? ?? 85 C0 74 0A E8 ?? ?? ?? ?? 8B 4D FC 89 08 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_71_0_0 {
	meta:
		name = "__aullshr"
		size = 31
	strings:
		$1 = { 80 F9 40 73 15 80 F9 20 73 06 0F AD D0 D3 EA C3 8B C2 33 D2 80 E1 1F D3 E8 C3 33 C0 33 D2 C3 }
	condition:
		$1
}

rule file_72_0_0 {
	meta:
		name = "__wexecl"
		size = 420
		refs = "0019 ??_C@_1CC@JBMDNKJP@?$AAf?$AAi?$AAl?$AAe?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0022 ??_C@_1GA@GCLIBDAJ@?$AAf?$AA?3?$AA?2?$AAr?$AAt?$AAm?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2@ 0029 __CrtDbgReportW 003d __errno 0051 ??_C@_1BA@OIKBEHJF@?$AA_?$AAw?$AAe?$AAx?$AAe?$AAc?$AAl?$AA?$AA@ 005b __invalid_parameter 007c ??_C@_1CM@DMCMCPME@?$AA?$CK?$AAf?$AAi?$AAl?$AAe?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 00e0 ??_C@_1CA@MOAFCHEI@?$AAa?$AAr?$AAg?$AAl?$AAi?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0140 ??_C@_1CK@PKCLGCC@?$AA?$CK?$AAa?$AAr?$AAg?$AAl?$AAi?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 0199 __wexecve"
	strings:
		$1 = { 55 8B EC 83 EC 10 33 C0 83 7D 08 00 0F 95 C0 89 45 FC 83 7D FC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 30 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D FC 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 30 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 36 01 00 00 8B 55 08 0F B7 02 F7 D8 1B C0 F7 D8 89 45 F8 75 1E 68 ?? ?? ?? ?? 6A 00 6A 31 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F8 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 31 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 D3 00 00 00 33 D2 83 7D 0C 00 0F 95 C2 89 55 F4 83 7D F4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 32 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F4 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 32 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 72 8B 4D 0C 0F B7 11 F7 DA 1B D2 F7 DA 89 55 F0 75 1E 68 ?? ?? ?? ?? 6A 00 6A 33 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 33 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 12 6A 00 8D 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_73_0_0 {
	meta:
		name = "__wexecv"
		size = 524
		refs = "0019 ??_C@_1CC@JBMDNKJP@?$AAf?$AAi?$AAl?$AAe?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0022 ??_C@_1GA@IPMDDOOK@?$AAf?$AA?3?$AA?2?$AAr?$AAt?$AAm?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2@ 0029 __CrtDbgReportW 003d __errno 0051 ??_C@_1BA@NHAFPAGO@?$AA_?$AAw?$AAe?$AAx?$AAe?$AAc?$AAv?$AA?$AA@ 005b __invalid_parameter 007c ??_C@_1CM@DMCMCPME@?$AA?$CK?$AAf?$AAi?$AAl?$AAe?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 00e0 ??_C@_1CE@IOFFAHL@?$AAa?$AAr?$AAg?$AAv?$AAe?$AAc?$AAt?$AAo?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0146 ??_C@_1CG@DNLPJOJF@?$AA?$CK?$AAa?$AAr?$AAg?$AAv?$AAe?$AAc?$AAt?$AAo?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 01a8 ??_C@_1DA@EPHHLJFN@?$AA?$CK?$AA?$CK?$AAa?$AAr?$AAg?$AAv?$AAe?$AAc?$AAt?$AAo?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 0201 __wexecve"
	strings:
		$1 = { 55 8B EC 83 EC 14 33 C0 83 7D 08 00 0F 95 C0 89 45 FC 83 7D FC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 2B 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D FC 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 2B 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 9E 01 00 00 8B 55 08 0F B7 02 F7 D8 1B C0 F7 D8 89 45 F8 75 1E 68 ?? ?? ?? ?? 6A 00 6A 2C 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F8 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 2C 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 3B 01 00 00 33 D2 83 7D 0C 00 0F 95 C2 89 55 F4 83 7D F4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 2D 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F4 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 2D 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 D7 00 00 00 8B 4D 0C 33 D2 83 39 00 0F 95 C2 89 55 F0 83 7D F0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 2E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 2E 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 74 8B 4D 0C 8B 11 0F B7 02 F7 D8 1B C0 F7 D8 89 45 EC 75 1E 68 ?? ?? ?? ?? 6A 00 6A 2F 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D EC 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 2F 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 12 6A 00 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_76_0_0 {
	meta:
		name = "_vfwprintf_helper"
		size = 374
		refs = "0006 __sehtable$_vfwprintf_helper 000b __except_handler4 001d ___security_cookie 0043 ??_C@_1BM@JMKHIAHP@?$AA?$CI?$AAs?$AAt?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 004c ??_C@_1BG@NPPNBJFE@?$AAv?$AAf?$AAw?$AAp?$AAr?$AAi?$AAn?$AAt?$AA?4?$AAc?$AA?$AA@ 0053 __CrtDbgReportW 0067 __errno 007b ??_C@_1CC@MONNFDCM@?$AAv?$AAf?$AAw?$AAp?$AAr?$AAi?$AAn?$AAt?$AAf?$AA_?$AAh?$AAe?$AAl?$AAp?$AAe?$AAr?$AA?$AA@ 0085 __invalid_parameter 00a7 ??_C@_1CC@MGIEJOME@?$AA?$CI?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0100 __lock_file 0113 __stbuf 013f __ftbuf 0159 __unlock_file"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 E4 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 33 C0 83 7D 0C 00 0F 95 C0 89 45 D8 83 7D D8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3A 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D8 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 3A 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 D0 00 00 00 33 D2 83 7D 10 00 0F 95 C2 89 55 D4 83 7D D4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3B 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D4 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 3B 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 6F 8B 4D 0C 89 4D E4 8B 55 E4 52 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 45 E4 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 DC 8B 4D 18 51 8B 55 14 52 8B 45 10 50 8B 4D E4 51 FF 55 08 83 C4 10 89 45 E0 8B 55 E4 52 8B 45 DC 50 E8 ?? ?? ?? ?? 83 C4 08 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0D 8B 4D E4 51 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 E0 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_76_1_0 {
	meta:
		name = "__vfwprintf_l"
		size = 34
		refs = "0014 __woutput_l 0019 _vfwprintf_helper"
	strings:
		$1 = { 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_647_1_0 {
	meta:
		name = "__vfprintf_l"
		size = 34
		refs = "0014 __output_l 0019 _vfprintf_helper"
	strings:
		$1 = { 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_647_3_0 {
	meta:
		name = "__vfprintf_p_l"
		size = 34
		refs = "0014 __output_p_l 0019 _vfprintf_helper"
	strings:
		$1 = { 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_647_2_0 {
	meta:
		name = "__vfprintf_s_l"
		size = 34
		refs = "0014 __output_s_l 0019 _vfprintf_helper"
	strings:
		$1 = { 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_76_3_0 {
	meta:
		name = "__vfwprintf_p_l"
		size = 34
		refs = "0014 __woutput_p_l 0019 _vfwprintf_helper"
	strings:
		$1 = { 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_76_2_0 {
	meta:
		name = "__vfwprintf_s_l"
		size = 34
		refs = "0014 __woutput_s_l 0019 _vfwprintf_helper"
	strings:
		$1 = { 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_76_4_0 {
	meta:
		name = "_vfwprintf"
		size = 32
		refs = "0012 __woutput_l 0017 _vfwprintf_helper"
	strings:
		$1 = { 55 8B EC 8B 45 10 50 6A 00 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_647_6_0 {
	meta:
		name = "__vfprintf_p"
		size = 32
		refs = "0012 __output_p_l 0017 _vfprintf_helper"
	strings:
		$1 = { 55 8B EC 8B 45 10 50 6A 00 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_76_6_0 {
	meta:
		name = "__vfwprintf_p"
		size = 32
		refs = "0012 __woutput_p_l 0017 _vfwprintf_helper"
	strings:
		$1 = { 55 8B EC 8B 45 10 50 6A 00 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_647_4_0 {
	meta:
		name = "_vfprintf"
		size = 32
		refs = "0012 __output_l 0017 _vfprintf_helper"
	strings:
		$1 = { 55 8B EC 8B 45 10 50 6A 00 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_647_5_0 {
	meta:
		name = "_vfprintf_s"
		size = 32
		refs = "0012 __output_s_l 0017 _vfprintf_helper"
	strings:
		$1 = { 55 8B EC 8B 45 10 50 6A 00 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_76_5_0 {
	meta:
		name = "_vfwprintf_s"
		size = 32
		refs = "0012 __woutput_s_l 0017 _vfwprintf_helper"
	strings:
		$1 = { 55 8B EC 8B 45 10 50 6A 00 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_77_0_0 {
	meta:
		name = "__validate_param_reuseA"
		size = 619
	strings:
		$1 = { 55 8B EC 83 EC 1C C7 45 FC 00 00 00 00 C7 45 F8 00 00 00 00 8B 45 08 0F BE 48 08 83 F9 70 74 09 0F BE 55 10 83 FA 70 75 17 8B 45 08 0F BE 48 08 0F BE 55 10 33 C0 3B CA 0F 94 C0 E9 27 02 00 00 8B 45 08 0F BE 48 08 83 F9 73 74 15 8B 55 08 0F BE 42 08 83 F8 53 74 09 C7 45 F4 00 00 00 00 EB 07 C7 45 F4 01 00 00 00 8B 4D F4 89 4D FC 0F BE 55 10 83 FA 73 74 12 0F BE 45 10 83 F8 53 74 09 C7 45 F0 00 00 00 00 EB 07 C7 45 F0 01 00 00 00 8B 4D F0 89 4D F8 83 7D FC 00 75 06 83 7D F8 00 74 45 8B 55 FC 3B 55 F8 75 2E 8B 45 08 8B 48 0C 81 E1 10 08 00 00 F7 D9 1B C9 F7 D9 8B 55 14 81 E2 10 08 00 00 F7 DA 1B D2 F7 DA 3B CA 75 09 C7 45 EC 01 00 00 00 EB 07 C7 45 EC 00 00 00 00 8B 45 EC E9 80 01 00 00 8B 45 08 0F BE 48 08 83 F9 64 74 76 8B 55 08 0F BE 42 08 83 F8 69 74 6A 8B 4D 08 0F BE 51 08 83 FA 6F 74 5E 8B 45 08 0F BE 48 08 83 F9 75 74 52 8B 55 08 0F BE 42 08 83 F8 78 74 46 8B 4D 08 0F BE 51 08 83 FA 58 74 3A 0F BE 45 10 83 F8 64 74 31 0F BE 4D 10 83 F9 69 74 28 0F BE 55 10 83 FA 6F 74 1F 0F BE 45 10 83 F8 75 74 16 0F BE 4D 10 83 F9 78 74 0D 0F BE 55 10 83 FA 58 0F 85 F1 00 00 00 8B 45 08 0F BE 48 08 83 F9 64 74 45 8B 55 08 0F BE 42 08 83 F8 69 74 39 8B 4D 08 0F BE 51 08 83 FA 6F 74 2D 8B 45 08 0F BE 48 08 83 F9 75 74 21 8B 55 08 0F BE 42 08 83 F8 78 74 15 8B 4D 08 0F BE 51 08 83 FA 58 74 09 C7 45 E8 00 00 00 00 EB 07 C7 45 E8 01 00 00 00 0F BE 45 10 83 F8 64 74 36 0F BE 4D 10 83 F9 69 74 2D 0F BE 55 10 83 FA 6F 74 24 0F BE 45 10 83 F8 75 74 1B 0F BE 4D 10 83 F9 78 74 12 0F BE 55 10 83 FA 58 74 09 C7 45 E4 00 00 00 00 EB 07 C7 45 E4 01 00 00 00 8B 45 E8 3B 45 E4 74 04 33 C0 EB 54 8B 4D 08 8B 51 0C 81 E2 00 00 01 00 F7 DA 1B D2 F7 DA 8B 45 14 25 00 00 01 00 F7 D8 1B C0 F7 D8 3B D0 75 1F 8B 4D 08 8B 51 0C 83 E2 20 F7 DA 1B D2 F7 DA 8B 45 14 83 E0 20 F7 D8 1B C0 F7 D8 3B D0 74 04 33 C0 EB 0D 8B 4D 08 8B 11 33 C0 3B 55 0C 0F 94 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_77_1_0 {
	meta:
		name = "__output_p_l"
		size = 14952
		refs = "000a ___security_cookie 0068 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 00e9 ??_C@_1CC@FADMNIL@?$AA?$CI?$AAs?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 00f5 ??_C@_1GC@ELIAPJJM@?$AAf?$AA?3?$AA?2?$AAr?$AAt?$AAm?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2@ 00fc __CrtDbgReportW 0113 __errno 012a ??_C@_1BI@KANOLAMF@?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAp?$AA_?$AAl?$AA?$AA@ 0134 __invalid_parameter 014c ??1_LocaleUpdate@@QAE@XZ 017e __fileno 01ca ___pioinfo 01dc ___badioinfo 02a4 ??_C@_1BAE@CBLKKPB@?$AA?$CI?$AA?5?$AA?$CI?$AA_?$AAS?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?9?$AA?$DO?$AA_?$AAf?$AAl?$AAa?$AAg?$AA?5?$AA?$CG?$AA?5?$AA_?$AAI?$AAO?$AAS?$AAT?$AAR?$AAG?$AA?$CJ?$AA?5?$AA?$HM?$AA?$HM?$AA?5@ 032f ??_C@_1CC@MGIEJOME@?$AA?$CI?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 04bc ___lookuptable_s 0534 _strtol 0565 _memset 0612 ??_C@_1JC@PFJNKEIO@?$AA?$CI?$AA?$CI?$AAt?$AAy?$AAp?$AAe?$AA_?$AAp?$AAo?$AAs?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?$CK?$AAe?$AAn?$AAd?$AA_?$AAp?$AAo?$AAs?$AA?5?$AA?$DN?$AA?$DN@ 06d9 ??_C@_1CM@IEGCDOKE@?$AA?$CI?$AAs?$AAt?$AAa?$AAt?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAS?$AAT?$AA_?$AAI?$AAN?$AAV?$AAA?$AAL?$AAI?$AAD?$AA?$CJ?$AA?$AA@ 076d $LN387 07ab ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 07b9 __isleadbyte_l 07db _write_char 080c ??_C@_1CC@IFFHEMNF@?$AA?$CI?$AAc?$AAh?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$CJ?$AA?$AA@ 091c $LN383 0923 $LN388 09a0 _get_int_arg 0a35 ??_C@_1JE@NMBHOLFI@?$AA?$CI?$AA?$CI?$AAw?$AAi?$AAd?$AAt?$AAh?$AA_?$AAp?$AAo?$AAs?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?$CK?$AAe?$AAn?$AAd?$AA_?$AAp?$AAo?$AAs?$AA?5?$AA?$DN@ 0b55 __validate_param_reuseA 0b6b ??_C@_1II@PIPIMLPF@?$AA_?$AAt?$AAv?$AAa?$AAl?$AAi?$AAd?$AAa?$AAt?$AAe?$AA_?$AAp?$AAa?$AAr?$AAa?$AAm?$AA_?$AAr?$AAe?$AAu?$AAs?$AAe?$AA?$CI?$AA?$CG?$AAp?$AAo?$AAs?$AA_?$AAv?$AAa?$AAl?$AAu@ 0d18 ??_C@_1JG@JBJBOCFB@?$AA?$CI?$AA?$CI?$AAp?$AAr?$AAe?$AAc?$AAi?$AAs?$AA_?$AAp?$AAo?$AAs?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?$CK?$AAe?$AAn?$AAd?$AA_?$AAp?$AAo?$AAs?$AA?5@ 0e4e ??_C@_1IK@EIEPDKHJ@?$AA_?$AAt?$AAv?$AAa?$AAl?$AAi?$AAd?$AAa?$AAt?$AAe?$AA_?$AAp?$AAa?$AAr?$AAa?$AAm?$AA_?$AAr?$AAe?$AAu?$AAs?$AAe?$AA?$CI?$AA?$CG?$AAp?$AAo?$AAs?$AA_?$AAv?$AAa?$AAl?$AAu@ 0f58 $LN384 0f5f $LN389 10ca $LN385 10d1 $LN390 111e _get_short_arg 116f ??_C@_1EM@BNPHBBIA@?$AA?$CI?$AA?$CI?$AAt?$AAy?$AAp?$AAe?$AA_?$AAp?$AAo?$AAs?$AA?$DO?$AA?$DN?$AA0?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AAt?$AAy?$AAp?$AAe?$AA_?$AAp?$AAo?$AAs?$AA?$DM?$AA_?$AAA?$AAR?$AAG@ 127e ??_C@_1IK@MHEDJAMK@?$AA_?$AAt?$AAv?$AAa?$AAl?$AAi?$AAd?$AAa?$AAt?$AAe?$AA_?$AAp?$AAa?$AAr?$AAa?$AAm?$AA_?$AAr?$AAe?$AAu?$AAs?$AAe?$AA?$CI?$AA?$CG?$AAp?$AAo?$AAs?$AA_?$AAv?$AAa?$AAl?$AAu@ 133f _wctomb_s 14d2 ??_C@_1IG@FDCPLALG@?$AA_?$AAt?$AAv?$AAa?$AAl?$AAi?$AAd?$AAa?$AAt?$AAe?$AA_?$AAp?$AAa?$AAr?$AAa?$AAm?$AA_?$AAr?$AAe?$AAu?$AAs?$AAe?$AA?$CI?$AA?$CG?$AAp?$AAo?$AAs?$AA_?$AAv?$AAa?$AAl?$AAu@ 170b ??_C@_1IG@HJIMKDHC@?$AA_?$AAt?$AAv?$AAa?$AAl?$AAi?$AAd?$AAa?$AAt?$AAe?$AA_?$AAp?$AAa?$AAr?$AAa?$AAm?$AA_?$AAr?$AAe?$AAu?$AAs?$AAe?$AA?$CI?$AA?$CG?$AAp?$AAo?$AAs?$AA_?$AAv?$AAa?$AAl?$AAu@ 17c6 ___nullstring 17d8 _strlen 1ac5 ___wnullstring 1db3 __get_printf_count_output 1def ??_C@_1EK@PNGFDECN@?$AA?$CI?$AA?$CC?$AA?8?$AAn?$AA?8?$AA?5?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AAs?$AAp?$AAe?$AAc?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?5?$AAd?$AAi?$AAs?$AAa?$AAb?$AAl?$AAe?$AAd?$AA?$CC@ 2023 ??_C@_1IM@DNGHAPLB@?$AA_?$AAt?$AAv?$AAa?$AAl?$AAi?$AAd?$AAa?$AAt?$AAe?$AA_?$AAp?$AAa?$AAr?$AAa?$AAm?$AA_?$AAr?$AAe?$AAu?$AAs?$AAe?$AA?$CI?$AA?$CG?$AAp?$AAo?$AAs?$AA_?$AAv?$AAa?$AAl?$AAu@ 210e ??_C@_0DB@FNNAMKJO@f?3?2rtm?2vctools?2crt_bld?2self_x86?2@ 2122 __malloc_dbg 2247 ??_C@_1DG@GOHGNKHE@?$AAp?$AAa?$AAs?$AAs?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAF?$AAO?$AAR?$AAM?$AAA?$AAT?$AA_?$AAO?$AAU?$AAT?$AAP?$AAU?$AAT?$AA_?$AAP?$AAA?$AAS?$AAS?$AA?$AA@ 22dd __cfltcvt_tab 22e3 __decode_pointer 2484 _get_int64_arg 25e9 ??_C@_1IK@NBGDDCBN@?$AA_?$AAt?$AAv?$AAa?$AAl?$AAi?$AAd?$AAa?$AAt?$AAe?$AA_?$AAp?$AAa?$AAr?$AAa?$AAm?$AA_?$AAr?$AAe?$AAu?$AAs?$AAe?$AA?$CI?$AA?$CG?$AAp?$AAo?$AAs?$AA_?$AAv?$AAa?$AAl?$AAu@ 281d ??_C@_1JC@OACKELNN@?$AA_?$AAt?$AAv?$AAa?$AAl?$AAi?$AAd?$AAa?$AAt?$AAe?$AA_?$AAp?$AAa?$AAr?$AAa?$AAm?$AA_?$AAr?$AAe?$AAu?$AAs?$AAe?$AA?$CI?$AA?$CG?$AAp?$AAo?$AAs?$AA_?$AAv?$AAa?$AAl?$AAu@ 32d3 __aullrem 32f8 __aulldiv 3474 _write_multi_char 3495 _write_string 3616 __free_dbg 366a ??_C@_1FK@LNCFKALM@?$AA?$CI?$AA?$CI?$AAs?$AAt?$AAa?$AAt?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAS?$AAT?$AA_?$AAN?$AAO?$AAR?$AAM?$AAA?$AAL?$AA?$CJ?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AA?$CI?$AAs?$AAt?$AAa?$AAt?$AAe?$AA?5@ 375e $LN391 3852 _get_crtdouble_arg 389a ??_C@_1FK@BCPANIEK@?$AA?$CI?$AA?$CC?$AAM?$AAi?$AAs?$AAs?$AAi?$AAn?$AAg?$AA?5?$AAp?$AAo?$AAs?$AAi?$AAt?$AAi?$AAo?$AAn?$AA?5?$AAi?$AAn?$AA?5?$AAt?$AAh?$AAe?$AA?5?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt@ 393a @__security_check_cookie@4 3944 $LN265 3948 $LN259 394c $LN258 3950 $LN250 3954 $LN238 3958 $LN237 395c $LN225 3960 $LN209 3964 $LN253 3968 $LN252 396c $LN254 3970 $LN255 3974 $LN251 3978 $LN256 3990 $LN219 3994 $LN211 3998 $LN222 399c $LN210 39a0 $LN223 39d4 $LN138 39d8 $LN206 39dc $LN170 39e0 $LN112 39e4 $LN184 39e8 $LN137 39ec $LN204 39f0 $LN117 39f4 $LN151 39f8 $LN107 39fc $LN113 3a00 $LN168 3a04 $LN115 3a08 $LN110 3a0c $LN207 3a48 $LN9 3a4c $LN8 3a50 $LN7 3a54 $LN6 3a58 $LN5 3a5c $LN4 3a60 $LN2 3a64 $LN3"
	strings:
		$1 = { 55 8B EC 81 EC 1C 0B 00 00 A1 ?? ?? ?? ?? 33 C5 89 85 58 F9 FF FF 56 C7 85 3C F7 FF FF 00 00 00 00 C7 85 A4 F9 FF FF 00 00 00 00 C7 85 98 F9 FF FF 00 00 00 00 C7 85 70 F9 FF FF 00 00 00 00 C7 85 90 F9 FF FF 00 00 00 00 C7 85 78 F9 FF FF 00 00 00 00 C7 85 A8 F9 FF FF 00 00 00 00 8B 45 10 50 8D 8D 60 F9 FF FF E8 ?? ?? ?? ?? C7 85 94 F9 FF FF 00 00 00 00 C7 85 80 F9 FF FF 00 00 00 00 C7 85 48 F7 FF FF 00 00 00 00 C7 85 AC F9 FF FF 00 00 00 00 C7 85 84 F9 FF FF FF FF FF FF C7 85 A0 F9 FF FF FF FF FF FF C7 85 B0 F9 FF FF FF FF FF FF C7 85 7C F9 FF FF FF FF FF FF C7 85 B4 F9 FF FF FF FF FF FF C7 85 8C F9 FF FF 00 00 00 00 33 C9 83 7D 08 00 0F 95 C1 89 8D 38 F7 FF FF 83 BD 38 F7 FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 07 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 38 F7 FF FF 00 75 49 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 07 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 08 F6 FF FF FF FF FF FF 8D 8D 60 F9 FF FF E8 ?? ?? ?? ?? 8B 85 08 F6 FF FF E9 D5 37 00 00 8B 45 08 89 85 34 F7 FF FF 8B 8D 34 F7 FF FF 8B 51 0C 83 E2 40 0F 85 0E 01 00 00 8B 85 34 F7 FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 83 F8 FF 74 4C 8B 8D 34 F7 FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 83 F8 FE 74 38 8B 95 34 F7 FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 8B F0 C1 FE 05 8B 85 34 F7 FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 83 E0 1F 6B C0 28 03 04 B5 ?? ?? ?? ?? 89 85 64 F5 FF FF EB 0A C7 85 64 F5 FF FF ?? ?? ?? ?? 8B 8D 64 F5 FF FF 8A 51 24 D0 E2 D0 FA 0F BE C2 85 C0 0F 85 80 00 00 00 8B 8D 34 F7 FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 83 F8 FF 74 4C 8B 95 34 F7 FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 83 F8 FE 74 38 8B 85 34 F7 FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 8B F0 C1 FE 05 8B 8D 34 F7 FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 83 E0 1F 6B C0 28 03 04 B5 ?? ?? ?? ?? 89 85 60 F5 FF FF EB 0A C7 85 60 F5 FF FF ?? ?? ?? ?? 8B 95 60 F5 FF FF 8A 42 24 C0 E0 00 C0 F8 07 0F BE C8 85 C9 74 0C C7 85 5C F5 FF FF 00 00 00 00 EB 0A C7 85 5C F5 FF FF 01 00 00 00 8B 95 5C F5 FF FF 89 95 30 F7 FF FF 83 BD 30 F7 FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 09 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 30 F7 FF FF 00 75 49 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 09 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 04 F6 FF FF FF FF FF FF 8D 8D 60 F9 FF FF E8 ?? ?? ?? ?? 8B 85 04 F6 FF FF E9 1A 36 00 00 33 C9 83 7D 0C 00 0F 95 C1 89 8D 2C F7 FF FF 83 BD 2C F7 FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 0C 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 2C F7 FF FF 00 75 49 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 0C 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 00 F6 FF FF FF FF FF FF 8D 8D 60 F9 FF FF E8 ?? ?? ?? ?? 8B 85 00 F6 FF FF E9 8F 35 00 00 C7 85 54 F7 FF FF 00 00 00 00 8B 45 0C 89 85 94 F9 FF FF C7 85 48 F7 FF FF 00 00 00 00 EB 0F 8B 8D 48 F7 FF FF 83 C1 01 89 8D 48 F7 FF FF 83 BD 48 F7 FF FF 02 0F 8D 37 35 00 00 83 BD 48 F7 FF FF 01 75 0E 83 BD B4 F9 FF FF 00 75 05 E9 20 35 00 00 C7 85 88 F9 FF FF 00 00 00 00 C7 85 40 F7 FF FF 00 00 00 00 C7 85 8C F9 FF FF 00 00 00 00 C7 85 5C F9 FF FF 00 00 00 00 C7 85 84 F9 FF FF FF FF FF FF C7 85 98 F9 FF FF 00 00 00 00 C7 85 70 F9 FF FF 00 00 00 00 8B 95 94 F9 FF FF 89 55 0C C7 85 A0 F9 FF FF FF FF FF FF C7 85 B0 F9 FF FF FF FF FF FF C7 85 7C F9 FF FF FF FF FF FF C7 85 B4 F9 FF FF FF FF FF FF 8B 45 0C 8A 08 88 8D 4F F7 FF FF 0F BE 95 4F F7 FF FF 8B 45 0C 83 C0 01 89 45 0C 85 D2 0F 84 9F 31 00 00 83 BD 54 F7 FF FF 00 0F 8C 92 31 00 00 0F BE 8D 4F F7 FF FF 83 F9 20 7C 25 0F BE 95 4F F7 FF FF 83 FA 78 7F 19 0F BE 85 4F F7 FF FF 0F B6 88 ?? ?? ?? ?? 83 E1 0F 89 8D 58 F5 FF FF EB 0A C7 85 58 F5 FF FF 00 00 00 00 8B 95 58 F5 FF FF 89 95 50 F7 FF FF 8B 85 50 F7 FF FF 6B C0 09 8B 8D 40 F7 FF FF 0F B6 94 08 ?? ?? ?? ?? C1 FA 04 89 95 40 F7 FF FF 83 BD 40 F7 FF FF 01 0F 85 AF 01 00 00 8B 45 0C 0F BE 08 83 F9 25 0F 84 A0 01 00 00 83 BD B4 F9 FF FF FF 75 5C 6A 0A 8D 95 80 F9 FF FF 52 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 7E 39 8B 8D 80 F9 FF FF 0F BE 11 83 FA 24 75 2B 83 BD 48 F7 FF FF 00 75 16 68 40 06 00 00 6A 00 8D 85 C0 F9 FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C C7 85 B4 F9 FF FF 01 00 00 00 EB 0A C7 85 B4 F9 FF FF 00 00 00 00 83 BD B4 F9 FF FF 01 0F 85 29 01 00 00 6A 0A 8D 8D 80 F9 FF FF 51 8B 55 0C 52 E8 ?? ?? ?? ?? 83 C4 0C 83 E8 01 89 85 A0 F9 FF FF 8B 85 80 F9 FF FF 83 C0 01 89 45 0C 83 BD 48 F7 FF FF 00 0F 85 F2 00 00 00 83 BD A0 F9 FF FF 00 7C 23 8B 8D 80 F9 FF FF 0F BE 11 83 FA 24 75 15 83 BD A0 F9 FF FF 64 7D 0C C7 85 54 F5 FF FF 01 00 00 00 EB 0A C7 85 54 F5 FF FF 00 00 00 00 8B 85 54 F5 FF FF 89 85 28 F7 FF FF 83 BD 28 F7 FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 55 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 28 F7 FF FF 00 75 49 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 55 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 FC F5 FF FF FF FF FF FF 8D 8D 60 F9 FF FF E8 ?? ?? ?? ?? 8B 85 FC F5 FF FF E9 AC 32 00 00 8B 95 A0 F9 FF FF 3B 95 84 F9 FF FF 7E 0E 8B 85 A0 F9 FF FF 89 85 50 F5 FF FF EB 0C 8B 8D 84 F9 FF FF 89 8D 50 F5 FF FF 8B 95 50 F5 FF FF 89 95 84 F9 FF FF E9 8E 00 00 00 33 C0 83 BD 40 F7 FF FF 08 0F 95 C0 89 85 24 F7 FF FF 83 BD 24 F7 FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 60 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 24 F7 FF FF 00 75 49 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 60 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 F8 F5 FF FF FF FF FF FF 8D 8D 60 F9 FF FF E8 ?? ?? ?? ?? 8B 85 F8 F5 FF FF E9 E5 31 00 00 8B 95 40 F7 FF FF 89 95 4C F5 FF FF 83 BD 4C F5 FF FF 07 0F 87 C3 2E 00 00 8B 85 4C F5 FF FF FF 24 85 ?? ?? ?? ?? 83 BD 48 F7 FF FF 00 75 09 83 BD B4 F9 FF FF 01 74 12 83 BD 48 F7 FF FF 01 75 0E 83 BD B4 F9 FF FF FF 75 05 E9 8D 2E 00 00 C7 85 A8 F9 FF FF 00 00 00 00 8D 8D 60 F9 FF FF E8 ?? ?? ?? ?? 50 0F B6 8D 4F F7 FF FF 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 0F 84 B6 00 00 00 8D 95 54 F7 FF FF 52 8B 45 08 50 8A 8D 4F F7 FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 0C 8A 02 88 85 4F F7 FF FF 8B 4D 0C 83 C1 01 89 4D 0C 0F BE 95 4F F7 FF FF F7 DA 1B D2 F7 DA 89 95 20 F7 FF FF 75 21 68 ?? ?? ?? ?? 6A 00 68 89 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 20 F7 FF FF 00 75 49 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 89 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 F4 F5 FF FF FF FF FF FF 8D 8D 60 F9 FF FF E8 ?? ?? ?? ?? 8B 85 F4 F5 FF FF E9 B2 30 00 00 8D 8D 54 F7 FF FF 51 8B 55 08 52 8A 85 4F F7 FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C E9 8A 2D 00 00 C7 85 74 F9 FF FF 00 00 00 00 8B 8D 74 F9 FF FF 89 8D 78 F9 FF FF 8B 95 78 F9 FF FF 89 95 98 F9 FF FF 8B 85 98 F9 FF FF 89 85 90 F9 FF FF C7 85 A4 F9 FF FF 00 00 00 00 C7 85 70 F9 FF FF FF FF FF FF C7 85 A8 F9 FF FF 00 00 00 00 E9 39 2D 00 00 0F BE 8D 4F F7 FF FF 89 8D 48 F5 FF FF 8B 95 48 F5 FF FF 83 EA 20 89 95 48 F5 FF FF 83 BD 48 F5 FF FF 10 77 6A 8B 85 48 F5 FF FF 0F B6 88 ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? 8B 95 A4 F9 FF FF 83 CA 04 89 95 A4 F9 FF FF EB 45 8B 85 A4 F9 FF FF 83 C8 01 89 85 A4 F9 FF FF EB 34 8B 8D A4 F9 FF FF 83 C9 02 89 8D A4 F9 FF FF EB 23 8B 95 A4 F9 FF FF 81 CA 80 00 00 00 89 95 A4 F9 FF FF EB 0F 8B 85 A4 F9 FF FF 83 C8 08 89 85 A4 F9 FF FF E9 A5 2C 00 00 0F BE 8D 4F F7 FF FF 83 F9 2A 0F 85 A5 02 00 00 83 BD B4 F9 FF FF 00 75 17 8D 55 14 52 E8 ?? ?? ?? ?? 83 C4 04 89 85 98 F9 FF FF E9 5D 02 00 00 6A 0A 8D 85 80 F9 FF FF 50 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 0C 83 E8 01 89 85 B0 F9 FF FF 8B 95 80 F9 FF FF 83 C2 01 89 55 0C 83 BD 48 F7 FF FF 00 0F 85 FB 01 00 00 83 BD B0 F9 FF FF 00 7C 23 8B 85 80 F9 FF FF 0F BE 08 83 F9 24 75 15 83 BD A0 F9 FF FF 64 7D 0C C7 85 44 F5 FF FF 01 00 00 00 EB 0A C7 85 44 F5 FF FF 00 00 00 00 8B 95 44 F5 FF FF 89 95 1C F7 FF FF 83 BD 1C F7 FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 BE 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 1C F7 FF FF 00 75 49 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 BE 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 F0 F5 FF FF FF FF FF FF 8D 8D 60 F9 FF FF E8 ?? ?? ?? ?? 8B 85 F0 F5 FF FF E9 89 2E 00 00 8B 8D B0 F9 FF FF 3B 8D 84 F9 FF FF 7E 0E 8B 95 B0 F9 FF FF 89 95 40 F5 FF FF EB 0C 8B 85 84 F9 FF FF 89 85 40 F5 FF FF 8B 8D 40 F5 FF FF 89 8D 84 F9 FF FF 8B 95 B0 F9 FF FF C1 E2 04 83 BC 15 C0 F9 FF FF 00 75 45 8B 85 B0 F9 FF FF C1 E0 04 C7 84 05 C0 F9 FF FF 01 00 00 00 8B 8D B0 F9 FF FF C1 E1 04 8A 95 4F F7 FF FF 88 94 0D C8 F9 FF FF 8B 85 B0 F9 FF FF C1 E0 04 8B 8D A4 F9 FF FF 89 8C 05 CC F9 FF FF E9 AA 00 00 00 8B 95 A4 F9 FF FF 52 8A 85 4F F7 FF FF 50 6A 01 8B 8D B0 F9 FF FF C1 E1 04 8D 94 0D C0 F9 FF FF 52 E8 ?? ?? ?? ?? 83 C4 10 F7 D8 1B C0 F7 D8 89 85 18 F7 FF FF 75 21 68 ?? ?? ?? ?? 6A 00 68 C3 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 18 F7 FF FF 00 75 49 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 C3 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 EC F5 FF FF FF FF FF FF 8D 8D 60 F9 FF FF E8 ?? ?? ?? ?? 8B 85 EC F5 FF FF E9 53 2D 00 00 E9 45 2A 00 00 EB 2B 8B 8D B0 F9 FF FF C1 E1 04 8B 94 0D C4 F9 FF FF 89 95 14 F7 FF FF 8D 85 14 F7 FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 98 F9 FF FF 83 BD 98 F9 FF FF 00 7D 1D 8B 8D A4 F9 FF FF 83 C9 04 89 8D A4 F9 FF FF 8B 95 98 F9 FF FF F7 DA 89 95 98 F9 FF FF EB 1A 8B 85 98 F9 FF FF 6B C0 0A 0F BE 8D 4F F7 FF FF 8D 54 08 D0 89 95 98 F9 FF FF E9 D1 29 00 00 C7 85 70 F9 FF FF 00 00 00 00 E9 C2 29 00 00 0F BE 85 4F F7 FF FF 83 F8 2A 0F 85 92 02 00 00 83 BD B4 F9 FF FF 00 75 17 8D 4D 14 51 E8 ?? ?? ?? ?? 83 C4 04 89 85 70 F9 FF FF E9 5D 02 00 00 6A 0A 8D 95 80 F9 FF FF 52 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 0C 83 E8 01 89 85 7C F9 FF FF 8B 8D 80 F9 FF FF 83 C1 01 89 4D 0C 83 BD 48 F7 FF FF 00 0F 85 FB 01 00 00 83 BD 7C F9 FF FF 00 7C 23 8B 95 80 F9 FF FF 0F BE 02 83 F8 24 75 15 83 BD A0 F9 FF FF 64 7D 0C C7 85 3C F5 FF FF 01 00 00 00 EB 0A C7 85 3C F5 FF FF 00 00 00 00 8B 8D 3C F5 FF FF 89 8D 10 F7 FF FF 83 BD 10 F7 FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 F3 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 10 F7 FF FF 00 75 49 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 F3 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 E8 F5 FF FF FF FF FF FF 8D 8D 60 F9 FF FF E8 ?? ?? ?? ?? 8B 85 E8 F5 FF FF E9 A6 2B 00 00 8B 85 7C F9 FF FF 3B 85 84 F9 FF FF 7E 0E 8B 8D 7C F9 FF FF 89 8D 38 F5 FF FF EB 0C 8B 95 84 F9 FF FF 89 95 38 F5 FF FF 8B 85 38 F5 FF FF 89 85 84 F9 FF FF 8B 8D 7C F9 FF FF C1 E1 04 83 BC 0D C0 F9 FF FF 00 75 45 8B 95 7C F9 FF FF C1 E2 04 C7 84 15 C0 F9 FF FF 01 00 00 00 8B 85 7C F9 FF FF C1 E0 04 8A 8D 4F F7 FF FF 88 8C 05 C8 F9 FF FF 8B 95 7C F9 FF FF C1 E2 04 8B 85 A4 F9 FF FF 89 84 15 CC F9 FF FF E9 AA 00 00 00 8B 8D A4 F9 FF FF 51 8A 95 4F F7 FF FF 52 6A 01 8B 85 7C F9 FF FF C1 E0 04 8D 8C 05 C0 F9 FF FF 51 E8 ?? ?? ?? ?? 83 C4 10 F7 D8 1B C0 F7 D8 89 85 0C F7 FF FF 75 21 68 ?? ?? ?? ?? 6A 00 68 F8 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 0C F7 FF FF 00 75 49 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 F8 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 E4 F5 FF FF FF FF FF FF 8D 8D 60 F9 FF FF E8 ?? ?? ?? ?? 8B 85 E4 F5 FF FF E9 70 2A 00 00 E9 62 27 00 00 EB 2B 8B 85 7C F9 FF FF C1 E0 04 8B 8C 05 C4 F9 FF FF 89 8D 08 F7 FF FF 8D 95 08 F7 FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 89 85 70 F9 FF FF 83 BD 70 F9 FF FF 00 7D 0A C7 85 70 F9 FF FF FF FF FF FF EB 1A 8B 85 70 F9 FF FF 6B C0 0A 0F BE 8D 4F F7 FF FF 8D 54 08 D0 89 95 70 F9 FF FF E9 01 27 00 00 0F BE 85 4F F7 FF FF 89 85 34 F5 FF FF 8B 8D 34 F5 FF FF 83 E9 49 89 8D 34 F5 FF FF 83 BD 34 F5 FF FF 2E 0F 87 44 01 00 00 8B 95 34 F5 FF FF 0F B6 82 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 8B 4D 0C 0F BE 11 83 FA 6C 75 1D 8B 45 0C 83 C0 01 89 45 0C 8B 8D A4 F9 FF FF 81 C9 00 10 00 00 89 8D A4 F9 FF FF EB 0F 8B 95 A4 F9 FF FF 83 CA 10 89 95 A4 F9 FF FF E9 F4 00 00 00 8B 45 0C 0F BE 08 83 F9 36 75 2C 8B 55 0C 0F BE 42 01 83 F8 34 75 20 8B 4D 0C 83 C1 02 89 4D 0C 8B 95 A4 F9 FF FF 81 CA 00 80 00 00 89 95 A4 F9 FF FF E9 98 00 00 00 8B 45 0C 0F BE 08 83 F9 33 75 29 8B 55 0C 0F BE 42 01 83 F8 32 75 1D 8B 4D 0C 83 C1 02 89 4D 0C 8B 95 A4 F9 FF FF 81 E2 FF 7F }
	condition:
		$1
}

rule file_77_5_0 {
	meta:
		name = "_write_char"
		size = 155
		refs = "006f __flsbuf"
	strings:
		$1 = { 55 8B EC 51 8B 45 0C 8B 48 0C 83 E1 40 74 18 8B 55 0C 83 7A 08 00 75 0F 8B 45 10 8B 08 83 C1 01 8B 55 10 89 0A EB 70 8B 45 0C 8B 48 04 83 E9 01 8B 55 0C 89 4A 04 8B 45 0C 83 78 04 00 7C 26 8B 4D 0C 8B 11 8A 45 08 88 02 0F BE 4D 08 81 E1 FF 00 00 00 89 4D FC 8B 55 0C 8B 02 83 C0 01 8B 4D 0C 89 01 EB 14 8B 55 0C 52 0F BE 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC FF 75 0B 8B 4D 10 C7 01 FF FF FF FF EB 0D 8B 55 10 8B 02 83 C0 01 8B 4D 10 89 01 8B E5 5D C3 }
	condition:
		$1
}

rule file_77_6_0 {
	meta:
		name = "_write_multi_char"
		size = 53
		refs = "0020 _write_char"
	strings:
		$1 = { 55 8B EC 8B 45 0C 8B 4D 0C 83 E9 01 89 4D 0C 85 C0 7E 20 8B 55 14 52 8B 45 10 50 8A 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 14 83 3A FF 75 02 EB 02 EB D0 5D C3 }
	condition:
		$1
}

rule file_77_7_0 {
	meta:
		name = "_write_string"
		size = 138
		refs = "004c _write_char 0065 __errno"
	strings:
		$1 = { 55 8B EC 51 8B 45 10 8B 48 0C 83 E1 40 74 18 8B 55 10 83 7A 08 00 75 0F 8B 45 14 8B 08 03 4D 0C 8B 55 14 89 0A EB 5F 8B 45 0C 8B 4D 0C 83 E9 01 89 4D 0C 85 C0 7E 4F 8B 55 08 8A 02 88 45 FF 8B 4D 14 51 8B 55 10 52 8A 45 FF 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D 08 83 C1 01 89 4D 08 8B 55 14 83 3A FF 75 20 E8 ?? ?? ?? ?? 83 38 2A 75 14 8B 45 14 50 8B 4D 10 51 6A 3F E8 ?? ?? ?? ?? 83 C4 0C EB 02 EB 02 EB A1 8B E5 5D C3 }
	condition:
		$1
}

rule file_77_10_0 {
	meta:
		name = "_get_short_arg"
		size = 27
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 08 83 C1 04 8B 55 08 89 0A 8B 45 08 8B 08 66 8B 41 FC 5D C3 }
	condition:
		$1
}

rule file_78_0_0 {
	meta:
		name = "__waccess"
		size = 34
		refs = "000d __waccess_s"
	strings:
		$1 = { 55 8B EC 51 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 8B 45 FC F7 D8 1B C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_822_0_0 {
	meta:
		name = "__access"
		size = 34
		refs = "000d __access_s"
	strings:
		$1 = { 55 8B EC 51 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 8B 45 FC F7 D8 1B C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_78_1_0 {
	meta:
		name = "__waccess_s"
		size = 339
		refs = "0019 ??_C@_1BO@DPAOGEII@?$AA?$CI?$AAp?$AAa?$AAt?$AAh?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0022 ??_C@_1GC@HHAEMJHB@?$AAf?$AA?3?$AA?2?$AAr?$AAt?$AAm?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2@ 0029 __CrtDbgReportW 003d ___doserrno 0048 __errno 005c ??_C@_1BG@CFNNCJOE@?$AA_?$AAw?$AAa?$AAc?$AAc?$AAe?$AAs?$AAs?$AA_?$AAs?$AA?$AA@ 0066 __invalid_parameter 008a ??_C@_1CM@DCGCAFIP@?$AA?$CI?$AA?$CI?$AAa?$AAm?$AAo?$AAd?$AAe?$AA?5?$AA?$CG?$AA?5?$AA?$CI?$AA?$HO?$AA6?$AA?$CJ?$AA?$CJ?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$CJ?$AA?$AA@ 00eb __imp__GetFileAttributesW@4 00fa __imp__GetLastError@0 0100 __dosmaperr"
	strings:
		$1 = { 55 8B EC 83 EC 0C 33 C0 83 7D 08 00 0F 95 C0 89 45 F8 83 7D F8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 50 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F8 00 75 3B E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 50 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 D8 00 00 00 8B 55 0C 83 E2 F9 F7 DA 1B D2 83 C2 01 89 55 F4 75 1E 68 ?? ?? ?? ?? 6A 00 6A 51 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F4 00 75 38 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 51 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 EB 6A 8B 4D 08 51 FF 15 ?? ?? ?? ?? 89 45 FC 83 7D FC FF 75 18 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 8B 00 EB 3F 8B 55 FC 83 E2 10 74 04 33 C0 EB 33 8B 45 FC 83 E0 01 74 29 8B 4D 0C 83 E1 02 74 21 E8 ?? ?? ?? ?? C7 00 05 00 00 00 E8 ?? ?? ?? ?? C7 00 0D 00 00 00 E8 ?? ?? ?? ?? 8B 00 EB 04 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_822_1_0 {
	meta:
		name = "__access_s"
		size = 339
		refs = "0019 ??_C@_1BO@DPAOGEII@?$AA?$CI?$AAp?$AAa?$AAt?$AAh?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0022 ??_C@_1BC@OLCNFCNP@?$AAa?$AAc?$AAc?$AAe?$AAs?$AAs?$AA?4?$AAc?$AA?$AA@ 0029 __CrtDbgReportW 003d ___doserrno 0048 __errno 005c ??_C@_1BE@LKCFPEPG@?$AA_?$AAa?$AAc?$AAc?$AAe?$AAs?$AAs?$AA_?$AAs?$AA?$AA@ 0066 __invalid_parameter 008a ??_C@_1CM@DCGCAFIP@?$AA?$CI?$AA?$CI?$AAa?$AAm?$AAo?$AAd?$AAe?$AA?5?$AA?$CG?$AA?5?$AA?$CI?$AA?$HO?$AA6?$AA?$CJ?$AA?$CJ?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$CJ?$AA?$AA@ 00eb __imp__GetFileAttributesA@4 00fa __imp__GetLastError@0 0100 __dosmaperr"
	strings:
		$1 = { 55 8B EC 83 EC 0C 33 C0 83 7D 08 00 0F 95 C0 89 45 F8 83 7D F8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 50 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F8 00 75 3B E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 50 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 D8 00 00 00 8B 55 0C 83 E2 F9 F7 DA 1B D2 83 C2 01 89 55 F4 75 1E 68 ?? ?? ?? ?? 6A 00 6A 51 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F4 00 75 38 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 51 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 EB 6A 8B 4D 08 51 FF 15 ?? ?? ?? ?? 89 45 FC 83 7D FC FF 75 18 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 8B 00 EB 3F 8B 55 FC 83 E2 10 74 04 33 C0 EB 33 8B 45 FC 83 E0 01 74 29 8B 4D 0C 83 E1 02 74 21 E8 ?? ?? ?? ?? C7 00 05 00 00 00 E8 ?? ?? ?? ?? C7 00 0D 00 00 00 E8 ?? ?? ?? ?? 8B 00 EB 04 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_79_0_0 {
	meta:
		name = "__mbsncat_s"
		size = 31
		refs = "0016 __mbsncat_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_803_3_0 {
	meta:
		name = "__aligned_recalloc_base"
		size = 31
		refs = "0016 __aligned_offset_recalloc_base"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_107_19_0 {
	meta:
		name = "__cftof"
		size = 31
		refs = "0016 __cftof_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_352_0_0 {
	meta:
		name = "__mbccpy_s"
		size = 31
		refs = "0016 __mbccpy_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_814_0_0 {
	meta:
		name = "__mbsnbcat_s"
		size = 31
		refs = "0016 __mbsnbcat_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_763_0_0 {
	meta:
		name = "__mbsnbcpy_s"
		size = 31
		refs = "0016 __mbsnbcpy_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_99_0_0 {
	meta:
		name = "__mbsnbset_s"
		size = 31
		refs = "0016 __mbsnbset_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_375_0_0 {
	meta:
		name = "__mbsncpy_s"
		size = 31
		refs = "0016 __mbsncpy_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_245_0_0 {
	meta:
		name = "__mbsnset_s"
		size = 31
		refs = "0016 __mbsnset_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_292_8_0 {
	meta:
		name = "_wcsftime"
		size = 31
		refs = "0016 __wcsftime_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_80_0_0 {
	meta:
		name = "__strxfrm_l"
		size = 731
		refs = "0015 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 002c ??_C@_1CE@EOIGACOB@?$AA_?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAI?$AAN?$AAT?$AA_?$AAM?$AAA?$AAX?$AA?$AA@ 0035 ??_C@_1BE@LJHJBPEL@?$AAs?$AAt?$AAr?$AAx?$AAf?$AAr?$AAm?$AA?4?$AAc?$AA?$AA@ 003c __CrtDbgReportW 0050 __errno 0064 ??_C@_1BG@DJLLIKNC@?$AA_?$AAs?$AAt?$AAr?$AAx?$AAf?$AAr?$AAm?$AA_?$AAl?$AA?$AA@ 006e __invalid_parameter 0080 ??1_LocaleUpdate@@QAE@XZ 00b5 ??_C@_1EA@PGFEPEBM@?$AA_?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA1?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AA_?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 0128 ??_C@_1CC@CNADELFK@?$AA_?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA2?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 019e ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 01c7 _strncpy 01d3 _strlen 0224 ___crtLCMapStringA"
	strings:
		$1 = { 55 8B EC 83 EC 3C C7 45 F8 FF FF FF 7F 8B 45 14 50 8D 4D E8 E8 ?? ?? ?? ?? B9 FF FF FF 7F 3B 4D 10 1B D2 83 C2 01 89 55 E4 75 1E 68 ?? ?? ?? ?? 6A 00 6A 4B 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E4 00 75 3D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 4B 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 D8 FF FF FF 7F 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 D8 E9 4B 02 00 00 83 7D 08 00 75 0F 83 7D 10 00 74 09 C7 45 C4 00 00 00 00 EB 07 C7 45 C4 01 00 00 00 8B 4D C4 89 4D E0 83 7D E0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 4C 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 3D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 4C 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 D4 FF FF FF 7F 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 D4 E9 C2 01 00 00 33 C0 83 7D 0C 00 0F 95 C0 89 45 DC 83 7D DC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 4D 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D DC 00 75 3D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 4D 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 D0 FF FF FF 7F 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 D0 E9 4F 01 00 00 83 7D 08 00 74 0C 83 7D 10 00 76 06 8B 55 08 C6 02 00 8D 4D E8 E8 ?? ?? ?? ?? 8B 00 83 78 10 00 75 43 8D 4D E8 E8 ?? ?? ?? ?? 8B 08 83 79 08 00 75 33 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 0C 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 CC 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 CC E9 EA 00 00 00 6A 01 8D 4D E8 E8 ?? ?? ?? ?? 8B 00 8B 48 08 51 6A 00 6A 00 6A FF 8B 55 0C 52 68 00 04 00 00 8D 4D E8 E8 ?? ?? ?? ?? 8B 00 8B 48 10 51 8D 4D E8 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 24 89 45 FC 83 7D FC 00 75 10 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 E9 82 00 00 00 8B 55 FC 89 55 F8 8B 45 F8 3B 45 10 76 13 8B 4D 08 C6 01 00 E8 ?? ?? ?? ?? C7 00 22 00 00 00 EB 61 6A 01 8D 4D E8 E8 ?? ?? ?? ?? 8B 10 8B 42 08 50 8B 4D 10 51 8B 55 08 52 6A FF 8B 45 0C 50 68 00 04 00 00 8D 4D E8 E8 ?? ?? ?? ?? 8B 08 8B 51 10 52 8D 4D E8 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 24 85 C0 75 12 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 C7 45 F8 FF FF FF 7F 8B 45 F8 83 E8 01 89 45 F8 8B 4D F8 89 4D C8 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 C8 8B E5 5D C3 }
	condition:
		$1
}

rule file_84_0_0 {
	meta:
		name = "__mbcjistojms_l"
		size = 247
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0016 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0030 ??1_LocaleUpdate@@QAE@XZ 006f __errno"
	strings:
		$1 = { 55 8B EC 83 EC 24 8B 45 0C 50 8D 4D E8 E8 ?? ?? ?? ?? 8D 4D E8 E8 ?? ?? ?? ?? 8B 48 04 81 79 04 A4 03 00 00 74 16 8B 55 08 89 55 E4 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 E4 E9 B7 00 00 00 8B 45 08 C1 E8 08 25 FF 00 00 00 89 45 FC 8B 4D 08 81 E1 FF 00 00 00 89 4D F8 83 7D FC 21 72 12 83 7D FC 7E 77 0C 83 7D F8 21 72 06 83 7D F8 7E 76 1F E8 ?? ?? ?? ?? C7 00 2A 00 00 00 C7 45 E0 00 00 00 00 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 E0 EB 66 8B 55 FC 83 E2 01 74 1C 83 7D F8 5F 77 0B 8B 45 F8 83 C0 1F 89 45 F8 EB 09 8B 4D F8 83 C1 20 89 4D F8 EB 09 8B 55 F8 83 C2 7E 89 55 F8 8B 45 FC 83 E8 21 D1 E8 05 81 00 00 00 89 45 FC 81 7D FC 9F 00 00 00 76 09 8B 4D FC 83 C1 40 89 4D FC 8B 55 FC C1 E2 08 0B 55 F8 89 55 DC 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 DC 8B E5 5D C3 }
	condition:
		$1
}

rule file_84_5_0 {
	meta:
		name = "__mbcjmstojis_l"
		size = 372
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0016 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0030 ??1_LocaleUpdate@@QAE@XZ 0089 __errno"
	strings:
		$1 = { 55 8B EC 83 EC 28 8B 45 0C 50 8D 4D E8 E8 ?? ?? ?? ?? 8D 4D E8 E8 ?? ?? ?? ?? 8B 48 04 81 79 04 A4 03 00 00 74 16 8B 55 08 89 55 E4 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 E4 E9 34 01 00 00 8B 45 08 C1 E8 08 25 FF 00 00 00 89 45 FC 8B 4D 08 81 E1 FF 00 00 00 89 4D F8 8D 4D E8 E8 ?? ?? ?? ?? 8B 50 04 0F B6 45 FC 0F B6 4C 02 1D 83 E1 04 74 19 8D 4D E8 E8 ?? ?? ?? ?? 8B 50 04 0F B6 45 F8 0F B6 4C 02 1D 83 E1 08 75 22 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 C7 45 E0 00 00 00 00 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 E0 E9 C6 00 00 00 81 7D FC A0 00 00 00 1B D2 83 E2 C0 81 C2 C1 00 00 00 8B 45 FC 2B C2 89 45 FC 81 7D F8 9F 00 00 00 72 1D 8B 4D FC C1 E1 09 81 C1 00 22 00 00 89 4D 08 8B 55 F8 83 EA 7E 0B 55 08 89 55 08 EB 28 8B 45 FC C1 E0 09 05 00 21 00 00 89 45 08 B9 7E 00 00 00 3B 4D F8 1B D2 F7 DA 83 C2 1F 8B 45 F8 2B C2 0B 45 08 89 45 08 81 7D 08 7E 7E 00 00 77 25 81 7D 08 21 21 00 00 72 1C 8B 4D 08 81 E1 FF 00 00 00 83 F9 7E 77 0E 8B 55 08 81 E2 FF 00 00 00 83 FA 21 73 1F E8 ?? ?? ?? ?? C7 00 2A 00 00 00 C7 45 DC 00 00 00 00 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 DC EB 11 8B 45 08 89 45 D8 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 D8 8B E5 5D C3 }
	condition:
		$1
}

rule file_86_0_0 {
	meta:
		name = "_remove"
		size = 65
		refs = "000a __imp__DeleteFileA@4 0014 __imp__GetLastError@0 002f __dosmaperr"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 50 FF 15 ?? ?? ?? ?? 85 C0 75 0B FF 15 ?? ?? ?? ?? 89 45 FC EB 07 C7 45 FC 00 00 00 00 83 7D FC 00 74 11 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 83 C8 FF EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_547_0_0 {
	meta:
		name = "__rmdir"
		size = 65
		refs = "000a __imp__RemoveDirectoryA@4 0014 __imp__GetLastError@0 002f __dosmaperr"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 50 FF 15 ?? ?? ?? ?? 85 C0 75 0B FF 15 ?? ?? ?? ?? 89 45 FC EB 07 C7 45 FC 00 00 00 00 83 7D FC 00 74 11 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 83 C8 FF EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_881_0_0 {
	meta:
		name = "__wremove"
		size = 65
		refs = "000a __imp__DeleteFileW@4 0014 __imp__GetLastError@0 002f __dosmaperr"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 50 FF 15 ?? ?? ?? ?? 85 C0 75 0B FF 15 ?? ?? ?? ?? 89 45 FC EB 07 C7 45 FC 00 00 00 00 83 7D FC 00 74 11 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 83 C8 FF EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_274_0_0 {
	meta:
		name = "__wrmdir"
		size = 65
		refs = "000a __imp__RemoveDirectoryW@4 0014 __imp__GetLastError@0 002f __dosmaperr"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 50 FF 15 ?? ?? ?? ?? 85 C0 75 0B FF 15 ?? ?? ?? ?? 89 45 FC EB 07 C7 45 FC 00 00 00 00 83 7D FC 00 74 11 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 83 C8 FF EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_88_0_0 {
	meta:
		name = "__getch"
		size = 119
		refs = "0006 __sehtable$__getch 000b __except_handler4 001d ___security_cookie 0033 __lock 0042 __getch_nolock 005a __unlock"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 F4 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 6A 03 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 E8 ?? ?? ?? ?? 89 45 E4 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0B 6A 03 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 E4 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_88_1_0 {
	meta:
		name = "__getche"
		size = 119
		refs = "0006 __sehtable$__getche 000b __except_handler4 001d ___security_cookie 0033 __lock 0042 __getche_nolock 005a __unlock"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 F4 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 6A 03 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 E8 ?? ?? ?? ?? 89 45 E4 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0B 6A 03 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 E4 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_88_4_0 {
	meta:
		name = "__kbhit"
		size = 119
		refs = "0006 __sehtable$__kbhit 000b __except_handler4 001d ___security_cookie 0033 __lock 0042 __kbhit_nolock 005a __unlock"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 F4 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 6A 03 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 E8 ?? ?? ?? ?? 89 45 E4 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0B 6A 03 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 E4 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_88_2_0 {
	meta:
		name = "__getch_nolock"
		size = 261
		refs = "000f _chbuf 003a __coninpfh 0042 ___initconin 0063 __imp__GetConsoleMode@8 0072 __imp__SetConsoleMode@8 0089 __imp__ReadConsoleInputA@16 00c3 __getextendedkeycode"
	strings:
		$1 = { 55 8B EC 83 EC 24 C7 45 E4 00 00 00 00 83 3D ?? ?? ?? ?? FF 74 22 A1 ?? ?? ?? ?? 25 FF 00 00 00 0F B6 C8 89 4D E4 C7 05 ?? ?? ?? ?? FF FF FF FF 8B 45 E4 E9 C9 00 00 00 83 3D ?? ?? ?? ?? FE 75 05 E8 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? FF 75 08 83 C8 FF E9 AA 00 00 00 8D 55 E0 52 A1 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 6A 00 8B 0D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 8D 55 DC 52 6A 01 8D 45 EC 50 8B 0D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 85 C0 74 06 83 7D DC 00 75 09 C7 45 E4 FF FF FF FF EB 4D 0F B7 55 EC 83 FA 01 75 42 83 7D F0 00 74 3C 0F B6 45 FA 89 45 E4 83 7D E4 00 74 02 EB 2F 8D 4D F0 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 E8 83 7D E8 00 74 18 8B 55 E8 0F B6 02 89 45 E4 8B 4D E8 0F B6 51 01 89 15 ?? ?? ?? ?? EB 02 EB 89 8B 45 E0 50 8B 0D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 8B 45 E4 8B E5 5D C3 }
	condition:
		$1
}

rule file_88_3_0 {
	meta:
		name = "__getche_nolock"
		size = 87
		refs = "0006 _chbuf 002d __getch_nolock 003f __putch_nolock"
	strings:
		$1 = { 55 8B EC 51 83 3D ?? ?? ?? ?? FF 74 1F A1 ?? ?? ?? ?? 25 FF 00 00 00 0F B6 C8 89 4D FC C7 05 ?? ?? ?? ?? FF FF FF FF 8B 45 FC EB 27 E8 ?? ?? ?? ?? 89 45 FC 83 7D FC FF 74 16 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 83 F8 FF 74 05 8B 45 FC EB 03 83 C8 FF 8B E5 5D C3 }
	condition:
		$1
}

rule file_88_5_0 {
	meta:
		name = "__kbhit_nolock"
		size = 337
		refs = "0016 _chbuf 0029 __coninpfh 0031 ___initconin 004b __imp__GetNumberOfConsoleInputEvents@8 0089 _malloc 0092 __MarkAllocaS 00cd __imp__PeekConsoleInputA@16 012a __getextendedkeycode 0143 __freea"
	strings:
		$1 = { 55 8B EC 83 EC 18 C7 45 F0 00 00 00 00 C7 45 F8 00 00 00 00 83 3D ?? ?? ?? ?? FF 74 0A B8 01 00 00 00 E9 26 01 00 00 83 3D ?? ?? ?? ?? FE 75 05 E8 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? FF 74 1B 8D 45 FC 50 8B 0D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 85 C0 74 06 83 7D FC 00 75 07 33 C0 E9 ED 00 00 00 83 7D FC 00 76 38 33 D2 75 34 B8 E0 FF FF FF 33 D2 F7 75 FC 83 F8 14 72 25 68 DD DD 00 00 8B 45 FC 6B C0 14 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 04 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 E8 EB 07 C7 45 E8 00 00 00 00 8B 4D E8 89 4D F8 83 7D F8 00 75 07 33 C0 E9 95 00 00 00 8D 55 F4 52 8B 45 FC 50 8B 4D F8 51 8B 15 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 85 C0 74 69 83 7D F4 00 74 63 8B 45 F4 3B 45 FC 77 5B 8B 4D F8 89 4D EC EB 12 8B 55 F4 83 EA 01 89 55 F4 8B 45 EC 83 C0 14 89 45 EC 83 7D F4 00 76 3B 8B 4D EC 0F B7 11 83 FA 01 75 2E 8B 45 EC 83 78 04 00 74 25 8B 4D EC 0F BE 51 0E 85 D2 75 13 8B 45 EC 83 C0 04 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 07 C7 45 F0 01 00 00 00 EB AD 8B 4D F8 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 F0 8B E5 5D C3 }
	condition:
		$1
}

rule file_88_8_0 {
	meta:
		name = "__ungetch"
		size = 126
		refs = "0006 __sehtable$__ungetch 000b __except_handler4 001d ___security_cookie 0033 __lock 0046 __ungetch_nolock 0061 __unlock"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 F4 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 6A 03 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 E4 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0B 6A 03 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 E4 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_172_0_0 {
	meta:
		name = "__putch"
		size = 126
		refs = "0006 __sehtable$__putch 000b __except_handler4 001d ___security_cookie 0033 __lock 0046 __putch_nolock 0061 __unlock"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 F4 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 6A 03 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 E4 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0B 6A 03 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 E4 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_88_9_0 {
	meta:
		name = "__ungetch_nolock"
		size = 43
		refs = "000b _chbuf"
	strings:
		$1 = { 55 8B EC 83 7D 08 FF 74 09 83 3D ?? ?? ?? ?? FF 74 05 83 C8 FF EB 12 8B 45 08 25 FF 00 00 00 A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_88_10_0 {
	meta:
		name = "__getextendedkeycode"
		size = 332
		refs = "0046 _EnhancedKeys 00cc _NormalKeys"
	strings:
		$1 = { 55 8B EC 83 EC 0C 8B 45 08 8B 48 0C 89 4D F4 8B 55 F4 81 E2 00 01 00 00 0F 84 9C 00 00 00 C7 45 F8 00 00 00 00 C7 45 FC 00 00 00 00 EB 09 8B 45 FC 83 C0 01 89 45 FC 83 7D FC 0C 73 78 8B 4D FC 6B C9 0A 0F B7 91 ?? ?? ?? ?? 8B 45 08 0F B7 48 08 3B D1 75 5B 8B 55 F4 83 E2 03 74 10 8B 45 FC 6B C0 0A 05 ?? ?? ?? ?? 89 45 F8 EB 41 8B 4D F4 83 E1 0C 74 11 8B 55 FC 6B D2 0A 81 C2 ?? ?? ?? ?? 89 55 F8 EB 28 8B 45 F4 83 E0 10 74 11 8B 4D FC 6B C9 0A 81 C1 ?? ?? ?? ?? 89 4D F8 EB 0F 8B 55 FC 6B D2 0A 81 C2 ?? ?? ?? ?? 89 55 F8 EB 05 E9 79 FF FF FF E9 8B 00 00 00 8B 45 F4 83 E0 03 74 13 8B 4D 08 0F B7 51 08 8D 04 D5 ?? ?? ?? ?? 89 45 F8 EB 47 8B 4D F4 83 E1 0C 74 13 8B 55 08 0F B7 42 08 8D 0C C5 ?? ?? ?? ?? 89 4D F8 EB 2C 8B 55 F4 83 E2 10 74 13 8B 45 08 0F B7 48 08 8D 14 CD ?? ?? ?? ?? 89 55 F8 EB 11 8B 45 08 0F B7 48 08 8D 14 CD ?? ?? ?? ?? 89 55 F8 8B 45 F8 0F B6 08 85 C9 74 0D 8B 55 F8 0F B6 02 3D E0 00 00 00 75 0B 8B 4D F8 0F B6 51 01 85 D2 75 07 C7 45 F8 00 00 00 00 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_89_0_0 {
	meta:
		name = "__swab"
		size = 391
		refs = "0021 ??_C@_1BE@KCHEPNFJ@?$AAs?$AAr?$AAc?$AA?$CB?$AA?$DN?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 002a ??_C@_1O@FAEGIMPO@?$AAs?$AAw?$AAa?$AAb?$AA?4?$AAc?$AA?$AA@ 0031 __CrtDbgReportW 0045 __errno 0059 ??_C@_1M@CDKJLJII@?$AA_?$AAs?$AAw?$AAa?$AAb?$AA?$AA@ 0063 __invalid_parameter 0082 ??_C@_1BG@ILJBLDMK@?$AAd?$AAe?$AAs?$AAt?$AA?$CB?$AA?$DN?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 00e3 ??_C@_1BE@KABAHFFM@?$AAn?$AAb?$AAy?$AAt?$AAe?$AAs?$AA?$DO?$AA?$DN?$AA0?$AA?$AA@"
	strings:
		$1 = { 55 8B EC 83 EC 10 C6 45 FE 00 C6 45 FF 00 33 C0 83 7D 08 00 0F 95 C0 89 45 F8 83 7D F8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 2E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F8 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 2E 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 E9 14 01 00 00 33 D2 83 7D 0C 00 0F 95 C2 89 55 F4 83 7D F4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 2F 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F4 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 2F 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 E9 B3 00 00 00 33 C9 83 7D 10 00 0F 9D C1 89 4D F0 83 7D F0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 30 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 28 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 30 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 EB 55 83 7D 10 01 7E 4F 8B 45 08 8A 08 88 4D FE 8B 55 08 83 C2 01 89 55 08 8B 45 08 8A 08 88 4D FF 8B 55 08 83 C2 01 89 55 08 8B 45 0C 8A 4D FF 88 08 8B 55 0C 83 C2 01 89 55 0C 8B 45 0C 8A 4D FE 88 08 8B 55 0C 83 C2 01 89 55 0C 8B 45 10 83 E8 02 89 45 10 EB AB 8B E5 5D C3 }
	condition:
		$1
}

rule file_90_0_0 {
	meta:
		name = "__snprintf"
		size = 415
		refs = "001f ??_C@_1CC@MGIEJOME@?$AA?$CI?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0028 ??_C@_1GE@EIENEIDK@?$AAf?$AA?3?$AA?2?$AAr?$AAt?$AAm?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2@ 002f __CrtDbgReportW 0043 __errno 0057 ??_C@_1BE@CHNFPLHD@?$AA_?$AAs?$AAn?$AAp?$AAr?$AAi?$AAn?$AAt?$AAf?$AA?$AA@ 0061 __invalid_parameter 0099 ??_C@_1EC@FABAOFFO@?$AA?$CI?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$CJ?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AA?$CI?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ@ 0138 __output_l 018e __flsbuf"
	strings:
		$1 = { 55 8B EC 83 EC 3C 8D 45 D4 89 45 F4 33 C9 83 7D 10 00 0F 95 C1 89 4D D0 83 7D D0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 69 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D0 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 69 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 2B 01 00 00 83 7D 0C 00 74 0F 83 7D 08 00 75 09 C7 45 C8 00 00 00 00 EB 07 C7 45 C8 01 00 00 00 8B 45 C8 89 45 CC 83 7D CC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 6C 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D CC 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 6C 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 B1 00 00 00 8D 55 14 89 55 FC 81 7D 0C FF FF FF 7F 76 0C 8B 45 F4 C7 40 04 FF FF FF 7F EB 09 8B 4D F4 8B 55 0C 89 51 04 8B 45 F4 C7 40 0C 42 00 00 00 8B 4D F4 8B 55 08 89 51 08 8B 45 F4 8B 4D 08 89 08 8B 55 FC 52 6A 00 8B 45 10 50 8B 4D F4 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 F8 83 7D 08 00 75 05 8B 45 F8 EB 4E 8B 55 F4 8B 42 04 83 E8 01 8B 4D F4 89 41 04 8B 55 F4 83 7A 04 00 7C 22 8B 45 F4 8B 08 C6 01 00 33 D2 81 E2 FF 00 00 00 89 55 C4 8B 45 F4 8B 08 83 C1 01 8B 55 F4 89 0A EB 11 8B 45 F4 50 6A 00 E8 ?? ?? ?? ?? 83 C4 08 89 45 C4 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_90_1_0 {
	meta:
		name = "__snprintf_l"
		size = 42
		refs = "001f __vsnprintf_l"
	strings:
		$1 = { 55 8B EC 51 8D 45 18 89 45 FC 8B 4D FC 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_164_1_0 {
	meta:
		name = "__snprintf_c_l"
		size = 42
		refs = "001f __vsnprintf_c_l"
	strings:
		$1 = { 55 8B EC 51 8D 45 18 89 45 FC 8B 4D FC 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_867_1_0 {
	meta:
		name = "__snwprintf_l"
		size = 42
		refs = "001f __vsnwprintf_l"
	strings:
		$1 = { 55 8B EC 51 8D 45 18 89 45 FC 8B 4D FC 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_642_7_0 {
	meta:
		name = "__sprintf_p_l"
		size = 42
		refs = "001f __vsprintf_p_l"
	strings:
		$1 = { 55 8B EC 51 8D 45 18 89 45 FC 8B 4D FC 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_642_3_0 {
	meta:
		name = "__sprintf_s_l"
		size = 42
		refs = "001f __vsprintf_s_l"
	strings:
		$1 = { 55 8B EC 51 8D 45 18 89 45 FC 8B 4D FC 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_366_1_0 {
	meta:
		name = "__swprintf_c_l"
		size = 42
		refs = "001f __vswprintf_c_l"
	strings:
		$1 = { 55 8B EC 51 8D 45 18 89 45 FC 8B 4D FC 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_713_7_0 {
	meta:
		name = "__swprintf_p_l"
		size = 42
		refs = "001f __vswprintf_p_l"
	strings:
		$1 = { 55 8B EC 51 8D 45 18 89 45 FC 8B 4D FC 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_713_5_0 {
	meta:
		name = "__swprintf_s_l"
		size = 42
		refs = "001f __vswprintf_s_l"
	strings:
		$1 = { 55 8B EC 51 8D 45 18 89 45 FC 8B 4D FC 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_91_0_0 {
	meta:
		name = "__vsprintf_l"
		size = 368
		refs = "001f ??_C@_1CC@MGIEJOME@?$AA?$CI?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0028 ??_C@_1BG@CBDPIEBA@?$AAv?$AAs?$AAp?$AAr?$AAi?$AAn?$AAt?$AAf?$AA?4?$AAc?$AA?$AA@ 002f __CrtDbgReportW 0043 __errno 0057 ??_C@_1BI@IGILPKD@?$AA_?$AAv?$AAs?$AAp?$AAr?$AAi?$AAn?$AAt?$AAf?$AA_?$AAl?$AA?$AA@ 0061 __invalid_parameter 0083 ??_C@_1CC@OLIJCKA@?$AA?$CI?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 010a __output_l 015f __flsbuf"
	strings:
		$1 = { 55 8B EC 83 EC 34 8D 45 D8 89 45 F8 33 C9 83 7D 0C 00 0F 95 C1 89 4D D4 83 7D D4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 70 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D4 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 70 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 FC 00 00 00 33 C0 83 7D 08 00 0F 95 C0 89 45 D0 83 7D D0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 75 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D0 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 75 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 98 00 00 00 8B 55 F8 C7 42 04 FF FF FF 7F 8B 45 F8 C7 40 0C 42 00 00 00 8B 4D F8 8B 55 08 89 51 08 8B 45 F8 8B 4D 08 89 08 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 10 89 45 FC 83 7D 08 00 75 05 8B 45 FC EB 4D 8B 45 F8 8B 48 04 83 E9 01 8B 55 F8 89 4A 04 8B 45 F8 83 78 04 00 7C 21 8B 4D F8 8B 11 C6 02 00 33 C0 25 FF 00 00 00 89 45 CC 8B 4D F8 8B 11 83 C2 01 8B 45 F8 89 10 EB 11 8B 4D F8 51 6A 00 E8 ?? ?? ?? ?? 83 C4 08 89 45 CC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_91_1_0 {
	meta:
		name = "_vsprintf"
		size = 27
		refs = "0012 __vsprintf_l"
	strings:
		$1 = { 55 8B EC 8B 45 10 50 6A 00 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_756_1_0 {
	meta:
		name = "__vswprintf"
		size = 27
		refs = "0012 __vswprintf_l"
	strings:
		$1 = { 55 8B EC 8B 45 10 50 6A 00 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_91_2_0 {
	meta:
		name = "__vscprintf_helper"
		size = 186
		refs = "001f ??_C@_1CC@MGIEJOME@?$AA?$CI?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 002b ??_C@_1BG@CBDPIEBA@?$AAv?$AAs?$AAp?$AAr?$AAi?$AAn?$AAt?$AAf?$AA?4?$AAc?$AA?$AA@ 0032 __CrtDbgReportW 0046 __errno 005d ??_C@_1CE@HMKDJHB@?$AA_?$AAv?$AAs?$AAc?$AAp?$AAr?$AAi?$AAn?$AAt?$AAf?$AA_?$AAh?$AAe?$AAl?$AAp?$AAe?$AAr?$AA?$AA@ 0067 __invalid_parameter"
	strings:
		$1 = { 55 8B EC 83 EC 2C 8D 45 D8 89 45 F8 33 C9 83 7D 0C 00 0F 95 C1 89 4D D4 83 7D D4 00 75 21 68 ?? ?? ?? ?? 6A 00 68 8F 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D4 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 8F 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 43 8B 45 F8 C7 40 04 FF FF FF 7F 8B 4D F8 C7 41 0C 42 00 00 00 8B 55 F8 C7 42 08 00 00 00 00 8B 45 F8 C7 00 00 00 00 00 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D F8 51 FF 55 08 83 C4 10 89 45 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_91_3_0 {
	meta:
		name = "__vscprintf"
		size = 28
		refs = "000e __output_l 0013 __vscprintf_helper"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 6A 00 8B 4D 08 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_428_6_0 {
	meta:
		name = "__vprintf_p"
		size = 28
		refs = "000e __output_p_l 0013 _vprintf_helper"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 6A 00 8B 4D 08 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_91_5_0 {
	meta:
		name = "__vscprintf_p"
		size = 28
		refs = "000e __output_p_l 0013 __vscprintf_helper"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 6A 00 8B 4D 08 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_756_4_0 {
	meta:
		name = "__vscwprintf"
		size = 28
		refs = "000e __woutput_l 0013 __vscwprintf_helper"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 6A 00 8B 4D 08 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_756_6_0 {
	meta:
		name = "__vscwprintf_p"
		size = 28
		refs = "000e __woutput_p_l 0013 __vscwprintf_helper"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 6A 00 8B 4D 08 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_241_6_0 {
	meta:
		name = "__vwprintf_p"
		size = 28
		refs = "000e __woutput_p_l 0013 _vwprintf_helper"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 6A 00 8B 4D 08 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_428_4_0 {
	meta:
		name = "_vprintf"
		size = 28
		refs = "000e __output_l 0013 _vprintf_helper"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 6A 00 8B 4D 08 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_428_5_0 {
	meta:
		name = "_vprintf_s"
		size = 28
		refs = "000e __output_s_l 0013 _vprintf_helper"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 6A 00 8B 4D 08 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_241_4_0 {
	meta:
		name = "_vwprintf"
		size = 28
		refs = "000e __woutput_l 0013 _vwprintf_helper"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 6A 00 8B 4D 08 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_241_5_0 {
	meta:
		name = "_vwprintf_s"
		size = 28
		refs = "000e __woutput_s_l 0013 _vwprintf_helper"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 6A 00 8B 4D 08 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_91_4_0 {
	meta:
		name = "__vscprintf_l"
		size = 30
		refs = "0010 __output_l 0015 __vscprintf_helper"
	strings:
		$1 = { 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_428_1_0 {
	meta:
		name = "__vprintf_l"
		size = 30
		refs = "0010 __output_l 0015 _vprintf_helper"
	strings:
		$1 = { 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_428_3_0 {
	meta:
		name = "__vprintf_p_l"
		size = 30
		refs = "0010 __output_p_l 0015 _vprintf_helper"
	strings:
		$1 = { 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_428_2_0 {
	meta:
		name = "__vprintf_s_l"
		size = 30
		refs = "0010 __output_s_l 0015 _vprintf_helper"
	strings:
		$1 = { 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_91_6_0 {
	meta:
		name = "__vscprintf_p_l"
		size = 30
		refs = "0010 __output_p_l 0015 __vscprintf_helper"
	strings:
		$1 = { 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_756_5_0 {
	meta:
		name = "__vscwprintf_l"
		size = 30
		refs = "0010 __woutput_l 0015 __vscwprintf_helper"
	strings:
		$1 = { 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_756_7_0 {
	meta:
		name = "__vscwprintf_p_l"
		size = 30
		refs = "0010 __woutput_p_l 0015 __vscwprintf_helper"
	strings:
		$1 = { 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_241_1_0 {
	meta:
		name = "__vwprintf_l"
		size = 30
		refs = "0010 __woutput_l 0015 _vwprintf_helper"
	strings:
		$1 = { 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_241_3_0 {
	meta:
		name = "__vwprintf_p_l"
		size = 30
		refs = "0010 __woutput_p_l 0015 _vwprintf_helper"
	strings:
		$1 = { 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_241_2_0 {
	meta:
		name = "__vwprintf_s_l"
		size = 30
		refs = "0010 __woutput_s_l 0015 _vwprintf_helper"
	strings:
		$1 = { 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_93_0_0 {
	meta:
		name = "__strset_s"
		size = 514
		refs = "002f ??_C@_1FC@NCPEPIBI@?$AA?$CI?$AA?$CI?$AA_?$AAD?$AAs?$AAt?$AA?$CJ?$AA?$CJ?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?$CI?$AA_?$AAS?$AAi?$AAz?$AAe?$AAI?$AAn?$AAB?$AAy?$AAt@ 0038 ??_C@_1GK@PNCPIHGH@?$AAF?$AA?3?$AA?2?$AAR?$AAT?$AAM?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAS?$AAE?$AAL?$AAF?$AA_?$AAX?$AA8?$AA6?$AA?2@ 003f __CrtDbgReportW 0053 __errno 0067 ??_C@_1BE@LCGBGIDG@?$AA_?$AAs?$AAt?$AAr?$AAs?$AAe?$AAt?$AA_?$AAs?$AA?$AA@ 0071 __invalid_parameter 00e3 ___crtDebugFillThreshold 010d _memset 0115 ??_C@_1DM@FHLMIEG@?$AAS?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AAi?$AAs?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAn?$AAu?$AAl?$AAl?$AA?5?$AAt?$AAe?$AAr?$AAm?$AAi?$AAn?$AAa?$AAt?$AAe?$AAd?$AA?$AA@ 013e ??_C@_1FA@MJKDNFFB@?$AA?$CI?$AAL?$AA?$CC?$AAS?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AAi?$AAs?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAn?$AAu?$AAl?$AAl?$AA?5?$AAt?$AAe?$AAr?$AAm?$AAi?$AAn?$AAa?$AAt?$AAe?$AAd@"
	strings:
		$1 = { 55 8B EC 83 EC 20 83 7D 08 00 74 0F 83 7D 0C 00 76 09 C7 45 EC 01 00 00 00 EB 07 C7 45 EC 00 00 00 00 8B 45 EC 89 45 F4 83 7D F4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 12 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F4 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 12 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 7C 01 00 00 8B 55 08 89 55 FC 8B 45 0C 89 45 F8 8B 4D FC 0F BE 11 85 D2 74 1E 8B 45 F8 83 E8 01 89 45 F8 74 13 8B 4D FC 8A 55 10 88 11 8B 45 FC 83 C0 01 89 45 FC EB D8 83 7D F8 00 0F 85 CE 00 00 00 8B 4D 08 C6 01 00 83 7D 0C FF 74 48 81 7D 0C FF FF FF 7F 74 3F 83 7D 0C 01 76 39 8B 55 0C 83 EA 01 39 15 ?? ?? ?? ?? 73 0A A1 ?? ?? ?? ?? 89 45 E8 EB 09 8B 4D 0C 83 E9 01 89 4D E8 8B 55 E8 52 68 FD 00 00 00 8B 45 08 83 C0 01 50 E8 ?? ?? ?? ?? 83 C4 0C B9 ?? ?? ?? ?? 85 C9 74 0D 33 D2 74 09 C7 45 E4 01 00 00 00 EB 07 C7 45 E4 00 00 00 00 8B 45 E4 89 45 F0 83 7D F0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 1E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 1E 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 EB 70 83 7D 0C FF 74 68 81 7D 0C FF FF FF 7F 74 5F 8B 55 0C 2B 55 F8 83 C2 01 3B 55 0C 73 51 8B 45 0C 2B 45 F8 83 C0 01 8B 4D 0C 2B C8 39 0D ?? ?? ?? ?? 73 0B 8B 15 ?? ?? ?? ?? 89 55 E0 EB 11 8B 45 0C 2B 45 F8 83 C0 01 8B 4D 0C 2B C8 89 4D E0 8B 55 E0 52 68 FD 00 00 00 8B 45 0C 2B 45 F8 8B 4D 08 8D 54 01 01 52 E8 ?? ?? ?? ?? 83 C4 0C 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_94_0_0 {
	meta:
		name = "__spawnlpe"
		size = 457
		refs = "0019 ??_C@_1CC@JBMDNKJP@?$AAf?$AAi?$AAl?$AAe?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0022 ??_C@_1BG@HACFJKDD@?$AAs?$AAp?$AAa?$AAw?$AAn?$AAl?$AAp?$AAe?$AA?4?$AAc?$AA?$AA@ 0029 __CrtDbgReportW 003d __errno 0051 ??_C@_1BE@KLLDGILA@?$AA_?$AAs?$AAp?$AAa?$AAw?$AAn?$AAl?$AAp?$AAe?$AA?$AA@ 005b __invalid_parameter 007c ??_C@_1CM@DMCMCPME@?$AA?$CK?$AAf?$AAi?$AAl?$AAe?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 00e0 ??_C@_1CA@MOAFCHEI@?$AAa?$AAr?$AAg?$AAl?$AAi?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0143 ??_C@_1CK@PKCLGCC@?$AA?$CK?$AAa?$AAr?$AAg?$AAl?$AAi?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 01be __spawnvpe"
	strings:
		$1 = { 55 8B EC 83 EC 14 33 C0 83 7D 0C 00 0F 95 C0 89 45 F8 83 7D F8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3B 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F8 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 3B 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 5B 01 00 00 8B 55 0C 0F BE 02 F7 D8 1B C0 F7 D8 89 45 F4 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3C 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F4 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 3C 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 F8 00 00 00 33 D2 83 7D 10 00 0F 95 C2 89 55 F0 83 7D F0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3D 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 3D 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 94 00 00 00 8B 4D 10 0F BE 11 F7 DA 1B D2 F7 DA 89 55 EC 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D EC 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 3E 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 34 8D 4D 10 89 4D FC 8B 55 FC 8B 02 8B 4D FC 83 C1 04 89 4D FC 85 C0 74 02 EB EC 8B 55 FC 8B 02 50 8D 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_95_0_0 {
	meta:
		name = "__tmpnam_helper"
		size = 641
		refs = "0006 __sehtable$__tmpnam_helper 000b __except_handler4 001d ___security_cookie 0046 __errno 0052 __mtinitlocknum 0075 __lock 008c _tmpnam_buf 009c _tmpnam_s_buf 00b6 _init_namebuf 00cc _genfname 00e3 __access_s 0121 ??_C@_1CI@CAFJHDOH@?$AAp?$AAf?$AAn?$AAa?$AAm?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAt?$AAm?$AAp?$AAn?$AAa?$AAm?$AA_?$AAb?$AAu?$AAf?$AA?$AA@ 012d ??_C@_1BE@DMACIEDN@?$AAt?$AAm?$AAp?$AAf?$AAi?$AAl?$AAe?$AA?4?$AAc?$AA?$AA@ 0134 __CrtDbgReportW 0142 __getptd_noexit 016a ??_C@_09JAPKMLG@tmpfile?4c?$AA@ 0173 __malloc_dbg 019f ??_C@_1BO@EICGGLEE@?$AA_?$AAt?$AAm?$AAp?$AAn?$AAa?$AAm?$AA_?$AAh?$AAe?$AAl?$AAp?$AAe?$AAr?$AA?$AA@ 01a4 ??_C@_1FA@MNFBMNIG@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAs?$AA?0?$AA?5?$AA?$CI?$AAs?$AAi?$AAz?$AAe?$AAo?$AAf?$AA?$CI?$AA?$CC?$AA?2?$AA?2?$AA?$CC?$AA?$CJ?$AA?5?$AA?$CL?$AA?5?$AA1?$AA2?$AA?$CJ?$AA?0@ 01b3 _strcpy_s 01bc __invoke_watson_if_error 01db _strlen 020e ??_C@_1CO@KPBLKOAA@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAs?$AA?0?$AA?5?$AAs?$AAz?$AA?0?$AA?5?$AAp?$AAf?$AAn?$AAa?$AAm?$AA?$CJ?$AA?$AA@ 0240 __unlock"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 E4 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 C7 45 D4 00 00 00 00 C7 45 DC 00 00 00 00 C7 45 E4 00 00 00 00 E8 ?? ?? ?? ?? 8B 00 89 45 E0 6A 02 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 15 8B 4D 18 C7 01 00 00 00 00 E8 ?? ?? ?? ?? 8B 00 E9 FD 01 00 00 6A 02 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 83 7D 10 00 75 10 C7 45 D4 ?? ?? ?? ?? C7 45 DC 0E 00 00 00 EB 0E C7 45 D4 ?? ?? ?? ?? C7 45 DC 12 00 00 00 8B 55 D4 0F BE 02 85 C0 75 0E 8B 4D 10 51 E8 ?? ?? ?? ?? 83 C4 04 EB 1D 8B 55 14 52 8B 45 DC 50 8B 4D D4 51 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 05 E9 53 01 00 00 6A 00 8B 55 D4 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 1F 8B 45 14 50 8B 4D DC 51 8B 55 D4 52 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 05 E9 24 01 00 00 EB CF 83 7D 08 00 0F 85 B9 00 00 00 81 7D D4 ?? ?? ?? ?? 74 21 68 ?? ?? ?? ?? 6A 00 68 A4 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 89 45 D8 83 7D D8 00 75 0C C7 45 E4 0C 00 00 00 E9 D4 00 00 00 8B 4D D8 83 79 2C 00 75 25 68 B6 00 00 00 68 ?? ?? ?? ?? 6A 02 6A 0E E8 ?? ?? ?? ?? 83 C4 10 8B 55 D8 89 42 2C 8B 45 D8 83 78 2C 00 74 3C 8B 4D D8 8B 51 2C 89 55 08 6A 00 68 B9 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 45 D4 50 6A 0E 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 EB 09 C7 45 E4 0C 00 00 00 EB 61 EB 5F 83 7D 10 00 74 26 8B 55 D4 52 E8 ?? ?? ?? ?? 83 C4 04 3B 45 0C 72 15 C7 45 E4 22 00 00 00 83 7D 0C 00 74 06 8B 45 08 C6 00 00 EB 33 6A 00 68 CF 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 4D D4 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0B 6A 02 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 4D 18 8B 55 08 89 11 83 7D E4 00 74 0C E8 ?? ?? ?? ?? 8B 4D E4 89 08 EB 0A E8 ?? ?? ?? ?? 8B 55 E0 89 10 8B 45 E4 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_95_2_0 {
	meta:
		name = "_tmpnam_s"
		size = 142
		refs = "0019 ??_C@_1BI@GCJIFEEF@?$AA?$CI?$AAs?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0025 ??_C@_1BE@DMACIEDN@?$AAt?$AAm?$AAp?$AAf?$AAi?$AAl?$AAe?$AA?4?$AAc?$AA?$AA@ 002c __CrtDbgReportW 0040 __errno 0057 ??_C@_1BC@LALKNPAF@?$AAt?$AAm?$AAp?$AAn?$AAa?$AAm?$AA_?$AAs?$AA?$AA@ 0061 __invalid_parameter 0083 __tmpnam_helper"
	strings:
		$1 = { 55 8B EC 83 EC 08 33 C0 83 7D 08 00 0F 95 C0 89 45 F8 83 7D F8 00 75 21 68 ?? ?? ?? ?? 6A 00 68 ED 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F8 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 ED 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 EB 1B 8D 55 FC 52 68 FF FF FF 7F 6A 02 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_852_2_0 {
	meta:
		name = "__wtmpnam_s"
		size = 142
		refs = "0019 ??_C@_1BI@GCJIFEEF@?$AA?$CI?$AAs?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0025 ??_C@_1GE@GLFLMDLP@?$AAf?$AA?3?$AA?2?$AAr?$AAt?$AAm?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2@ 002c __CrtDbgReportW 0040 __errno 0057 ??_C@_1BG@OOCNCNMF@?$AA_?$AAw?$AAt?$AAm?$AAp?$AAn?$AAa?$AAm?$AA_?$AAs?$AA?$AA@ 0061 __invalid_parameter 0083 __wtmpnam_helper"
	strings:
		$1 = { 55 8B EC 83 EC 08 33 C0 83 7D 08 00 0F 95 C0 89 45 F8 83 7D F8 00 75 21 68 ?? ?? ?? ?? 6A 00 68 ED 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F8 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 ED 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 EB 1B 8D 55 FC 52 68 FF FF FF 7F 6A 02 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_95_3_0 {
	meta:
		name = "_tmpnam"
		size = 43
		refs = "001d __tmpnam_helper"
	strings:
		$1 = { 55 8B EC 51 C7 45 FC 00 00 00 00 8D 45 FC 50 68 FF 7F 00 00 6A 00 6A FF 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 14 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_852_3_0 {
	meta:
		name = "__wtmpnam"
		size = 43
		refs = "001d __wtmpnam_helper"
	strings:
		$1 = { 55 8B EC 51 C7 45 FC 00 00 00 00 8D 45 FC 50 68 FF 7F 00 00 6A 00 6A FF 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 14 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_95_4_0 {
	meta:
		name = "__tmpfile_helper"
		size = 706
		refs = "0006 __sehtable$__tmpfile_helper 000b __except_handler4 001d ___security_cookie 0051 ??_C@_1CA@INCEPBJN@?$AA?$CI?$AAp?$AAF?$AAi?$AAl?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 005d ??_C@_1BE@DMACIEDN@?$AAt?$AAm?$AAp?$AAf?$AAi?$AAl?$AAe?$AA?4?$AAc?$AA?$AA@ 0064 __CrtDbgReportW 0078 __errno 008f ??_C@_1CA@NBKCIJOJ@?$AA_?$AAt?$AAm?$AAp?$AAf?$AAi?$AAl?$AAe?$AA_?$AAh?$AAe?$AAl?$AAp?$AAe?$AAr?$AA?$AA@ 0099 __invalid_parameter 00b6 __mtinitlocknum 00d0 __lock 00e1 _tmpfile_buf 00ec _init_namebuf 0102 _genfname 0113 __getstream 0160 __sopen_s 01ad ??_C@_09JAPKMLG@tmpfile?4c?$AA@ 01bb _strlen 01c7 __calloc_dbg 01e2 __close 0200 ??_C@_1IM@DDAMIECE@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AA?5?$AAs?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?9?$AA?$DO?$AA_?$AAt?$AAm?$AAp?$AAf?$AAn?$AAa?$AAm?$AAe?$AA?0?$AA?5?$AAs?$AAt?$AAr@ 0222 _strcpy_s 022b __invoke_watson_if_error 0251 __commode 028b __unlock_file 0295 __unlock"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 E0 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 C7 45 DC 00 00 00 00 C7 45 E4 00 00 00 00 33 C0 83 7D 08 00 0F 95 C0 89 45 D0 83 7D D0 00 75 21 68 ?? ?? ?? ?? 6A 00 68 1A 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D0 00 75 33 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 1A 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 06 02 00 00 8B 55 08 C7 02 00 00 00 00 6A 02 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 0C E8 ?? ?? ?? ?? 8B 00 E9 E3 01 00 00 6A 02 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 0F BE 05 ?? ?? ?? ?? 85 C0 75 0C 6A 01 E8 ?? ?? ?? ?? 83 C4 04 EB 1D 68 FF FF FF 7F 6A 12 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 05 E9 60 01 00 00 E8 ?? ?? ?? ?? 89 45 E0 83 7D E0 00 75 0C C7 45 DC 18 00 00 00 E9 46 01 00 00 C7 45 E4 01 00 00 00 E8 ?? ?? ?? ?? 8B 08 89 4D D4 E8 ?? ?? ?? ?? C7 00 00 00 00 00 68 80 01 00 00 8B 55 0C 52 68 42 85 00 00 68 ?? ?? ?? ?? 8D 45 D8 50 E8 ?? ?? ?? ?? 83 C4 14 83 F8 11 75 1C 68 FF FF FF 7F 6A 12 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 02 EB 02 EB C0 E8 ?? ?? ?? ?? 83 38 00 75 0A E8 ?? ?? ?? ?? 8B 4D D4 89 08 83 7D D8 FF 75 05 E9 CB 00 00 00 68 62 01 00 00 68 ?? ?? ?? ?? 6A 02 6A 01 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 83 C0 01 50 E8 ?? ?? ?? ?? 83 C4 14 8B 55 E0 89 42 1C 8B 45 E0 83 78 1C 00 75 11 8B 4D D8 51 E8 ?? ?? ?? ?? 83 C4 04 E9 84 00 00 00 6A 00 68 6C 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 83 C0 01 50 8B 55 E0 8B 42 1C 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 4D E0 C7 41 04 00 00 00 00 8B 55 E0 C7 02 00 00 00 00 8B 45 E0 C7 40 08 00 00 00 00 8B 0D ?? ?? ?? ?? 81 C9 80 00 00 00 8B 55 E0 89 4A 0C 8B 45 E0 8B 4D D8 89 48 10 8B 55 08 8B 45 E0 89 02 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 1D 83 7D E4 00 74 0C 8B 4D E0 51 E8 ?? ?? ?? ?? 83 C4 04 6A 02 E8 ?? ?? ?? ?? 83 C4 04 C3 83 7D DC 00 74 0A E8 ?? ?? ?? ?? 8B 55 DC 89 10 8B 45 DC 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_95_5_0 {
	meta:
		name = "_tmpfile"
		size = 32
		refs = "0012 __tmpfile_helper"
	strings:
		$1 = { 55 8B EC 51 C7 45 FC 00 00 00 00 6A 40 8D 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_95_6_0 {
	meta:
		name = "_tmpfile_s"
		size = 19
		refs = "000a __tmpfile_helper"
	strings:
		$1 = { 55 8B EC 6A 10 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_95_7_0 {
	meta:
		name = "_init_namebuf"
		size = 342
		refs = "002a _tmpnam_buf 003a _tmpfile_buf 004a _tmpnam_s_buf 005d ??_C@_1BE@DMACIEDN@?$AAt?$AAm?$AAp?$AAf?$AAi?$AAl?$AAe?$AA?4?$AAc?$AA?$AA@ 0062 ??_C@_1BK@ECJIJICK@?$AAi?$AAn?$AAi?$AAt?$AA_?$AAn?$AAa?$AAm?$AAe?$AAb?$AAu?$AAf?$AA?$AA@ 0067 ??_C@_1DA@GKNEHDAK@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAp?$AA?0?$AA?5?$AAs?$AAi?$AAz?$AAe?$AA?0?$AA?5?$AA?$CC?$AA?2?$AA?2?$AA?$CC?$AA?$CJ?$AA?$AA@ 006c ??_C@_01KICIPPFI@?2?$AA@ 0079 _strcpy_s 0082 __invoke_watson_if_error 00f1 ??_C@_1HE@EBAJPMNF@?$AA_?$AAu?$AAl?$AAt?$AAo?$AAa?$AA_?$AAs?$AA?$CI?$AA?$CI?$AAu?$AAn?$AAs?$AAi?$AAg?$AAn?$AAe?$AAd?$AA?5?$AAl?$AAo?$AAn?$AAg?$AA?$CJ?$AA_?$AAg?$AAe?$AAt?$AAp?$AAi?$AAd?$AA?$CI@ 0108 __getpid 010e __ultoa_s 0130 ??_C@_1CO@JBPAAAAM@?$AAs?$AAt?$AAr?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AAp?$AA?0?$AA?5?$AAs?$AAi?$AAz?$AAe?$AA?0?$AA?5?$AA?$CC?$AA?4?$AA?$CC?$AA?$CJ?$AA?$AA@ 0135 ??_C@_01LFCBOECM@?4?$AA@ 0142 _strcat_s"
	strings:
		$1 = { 55 8B EC 83 EC 10 C7 45 F8 00 00 00 00 8B 45 08 89 45 F0 83 7D F0 00 74 0E 83 7D F0 01 74 18 83 7D F0 02 74 22 EB 2E C7 45 FC ?? ?? ?? ?? C7 45 F8 0E 00 00 00 EB 1E C7 45 FC ?? ?? ?? ?? C7 45 F8 12 00 00 00 EB 0E C7 45 FC ?? ?? ?? ?? C7 45 F8 12 00 00 00 6A 00 68 F4 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 4D F8 51 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 45 FC 83 C0 01 89 45 F4 8B 4D F4 0F BE 51 FF 83 FA 5C 74 1B 8B 45 F4 0F BE 48 FF 83 F9 2F 74 0F 8B 55 F4 C6 02 5C 8B 45 F4 83 C0 01 89 45 F4 83 7D 08 01 75 11 8B 4D F4 C6 01 74 8B 55 F4 83 C2 01 89 55 F4 EB 0F 8B 45 F4 C6 00 73 8B 4D F4 83 C1 01 89 4D F4 6A 00 68 09 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 20 8B 55 F4 2B 55 FC 8B 45 F8 2B C2 50 8B 4D F4 51 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 10 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 0A 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 55 F8 52 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B E5 5D C3 }
	condition:
		$1
}

rule file_95_8_0 {
	meta:
		name = "_genfname"
		size = 203
		refs = "0007 ___security_cookie 0017 __mbsrchr 0033 _strtoul 0055 ??_C@_1BE@DMACIEDN@?$AAt?$AAm?$AAp?$AAf?$AAi?$AAl?$AAe?$AA?4?$AAc?$AA?$AA@ 005a ??_C@_1BC@DGMNDOAF@?$AAg?$AAe?$AAn?$AAf?$AAn?$AAa?$AAm?$AAe?$AA?$AA@ 005f ??_C@_1HK@MCAKBGBI@?$AA_?$AAu?$AAl?$AAt?$AAo?$AAa?$AA_?$AAs?$AA?$CI?$AAe?$AAx?$AAt?$AAn?$AAu?$AAm?$AA?0?$AA?5?$AAp?$AAe?$AAx?$AAt?$AA?0?$AA?5?$AA?$CI?$AAs?$AAi?$AAz?$AAe?$AAo?$AAf?$AA?$CI?$AAp@ 0070 __ultoa_s 0079 __invoke_watson_if_error 0092 ??_C@_1FG@LAMIAEHO@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAp?$AA?0?$AA?5?$AAf?$AAn?$AAa?$AAm?$AAe?$AAS?$AAi?$AAz?$AAe?$AA?5?$AA?9?$AA?5?$AA?$CI?$AAp?$AA?5?$AA?9?$AA?5?$AAf?$AAn?$AAa@ 00ab _strcpy_s 00c3 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 14 A1 ?? ?? ?? ?? 33 C5 89 45 F8 6A 2E 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 8B 4D FC 83 C1 01 89 4D FC 6A 20 6A 00 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 0C 83 C0 01 89 45 EC 8B 45 EC 3B 45 10 72 05 83 C8 FF EB 70 6A 00 68 2E 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 20 6A 08 8D 4D F0 51 8B 55 EC 52 E8 ?? ?? ?? ?? 83 C4 10 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 2F 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8B 4D FC 2B 4D 08 8B 55 0C 2B D1 52 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 33 C0 8B 4D F8 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_96_0_0 {
	meta:
		name = "__mktemp_s"
		size = 1282
		refs = "0043 ??_C@_1FA@JNABFIEA@?$AA?$CI?$AAt?$AAe?$AAm?$AAp?$AAl?$AAa?$AAt?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAC?$AAh?$AAa@ 004c ??_C@_1BC@DAFAJEIO@?$AAm?$AAk?$AAt?$AAe?$AAm?$AAp?$AA?4?$AAc?$AA?$AA@ 0053 __CrtDbgReportW 0067 __errno 007b ??_C@_1BE@GBFIDCKH@?$AA_?$AAm?$AAk?$AAt?$AAe?$AAm?$AAp?$AA_?$AAs?$AA?$AA@ 0085 __invalid_parameter 009f _strnlen 00d8 ___crtDebugFillThreshold 0103 _memset 010b ??_C@_1DM@FHLMIEG@?$AAS?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AAi?$AAs?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAn?$AAu?$AAl?$AAl?$AA?5?$AAt?$AAe?$AAr?$AAm?$AAi?$AAn?$AAa?$AAt?$AAe?$AAd?$AA?$AA@ 0134 ??_C@_1FA@MJKDNFFB@?$AA?$CI?$AAL?$AA?$CC?$AAS?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AAi?$AAs?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAn?$AAu?$AAl?$AAl?$AA?5?$AAt?$AAe?$AAr?$AAm?$AAi?$AAn?$AAa?$AAt?$AAe?$AAd@ 01ea ___threadid 0281 ??_C@_1EE@JEDJDFK@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAc?$AAo?$AAr?$AAr?$AAe?$AAc?$AAt?$AA?5?$AAI?$AAn?$AAp?$AAu?$AAt?$AA?5?$AAf?$AAo?$AAr?$AA?5?$AAm?$AAk?$AAt?$AAe?$AAm?$AAp?$AA?$CC?$AA?0?$AA?5?$AA0@ 02f5 __ismbstrail 0449 __access_s"
	strings:
		$1 = { 55 8B EC 83 EC 48 8B 45 08 89 45 F4 C7 45 FC 61 00 00 00 C7 45 F8 00 00 00 00 83 7D 08 00 74 0F 83 7D 0C 00 76 09 C7 45 D8 01 00 00 00 EB 07 C7 45 D8 00 00 00 00 8B 4D D8 89 4D E8 83 7D E8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3A 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E8 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 3A 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 68 04 00 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 F8 8B 55 F8 3B 55 0C 0F 82 D2 00 00 00 8B 45 08 C6 00 00 83 7D 0C FF 74 49 81 7D 0C FF FF FF 7F 74 40 83 7D 0C 01 76 3A 8B 4D 0C 83 E9 01 39 0D ?? ?? ?? ?? 73 0B 8B 15 ?? ?? ?? ?? 89 55 D4 EB 09 8B 45 0C 83 E8 01 89 45 D4 8B 4D D4 51 68 FD 00 00 00 8B 55 08 83 C2 01 52 E8 ?? ?? ?? ?? 83 C4 0C B8 ?? ?? ?? ?? 85 C0 74 0D 33 C9 74 09 C7 45 D0 01 00 00 00 EB 07 C7 45 D0 00 00 00 00 8B 55 D0 89 55 E4 83 7D E4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3F 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E4 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 3F 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 77 03 00 00 83 7D 0C FF 74 5C 81 7D 0C FF FF FF 7F 74 53 8B 4D F8 83 C1 01 3B 4D 0C 73 48 8B 55 F8 83 C2 01 8B 45 0C 2B C2 39 05 ?? ?? ?? ?? 73 0B 8B 0D ?? ?? ?? ?? 89 4D CC EB 0E 8B 55 F8 83 C2 01 8B 45 0C 2B C2 89 45 CC 8B 4D CC 51 68 FD 00 00 00 8B 55 F8 8B 45 08 8D 4C 10 01 51 E8 ?? ?? ?? ?? 83 C4 0C E8 ?? ?? ?? ?? 89 45 EC 8B 55 F4 03 55 F8 89 55 F4 83 7D F8 06 72 0C 8B 45 0C 3B 45 F8 0F 87 C8 00 00 00 8B 4D 08 C6 01 00 83 7D 0C FF 74 48 81 7D 0C FF FF FF 7F 74 3F 83 7D 0C 01 76 39 8B 55 0C 83 EA 01 39 15 ?? ?? ?? ?? 73 0A A1 ?? ?? ?? ?? 89 45 C8 EB 09 8B 4D 0C 83 E9 01 89 4D C8 8B 55 C8 52 68 FD 00 00 00 8B 45 08 83 C0 01 50 E8 ?? ?? ?? ?? 83 C4 0C 33 C9 74 09 C7 45 C4 01 00 00 00 EB 07 C7 45 C4 00 00 00 00 8B 55 C4 89 55 E0 83 7D E0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 57 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 57 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 2A 02 00 00 C7 45 F8 00 00 00 00 8B 4D F4 83 E9 01 89 4D F4 8B 55 F4 3B 55 08 72 53 8B 45 F4 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 3F 8B 55 F4 0F BE 02 83 F8 58 75 34 83 7D F8 05 73 2E 8B 4D F8 83 C1 01 89 4D F8 8B 45 EC 33 D2 B9 0A 00 00 00 F7 F1 83 C2 30 8B 45 F4 88 10 8B 45 EC 33 D2 B9 0A 00 00 00 F7 F1 89 45 EC EB 9C 8B 55 F4 0F BE 02 83 F8 58 75 0A 83 7D F8 05 0F 83 C8 00 00 00 8B 4D 08 C6 01 00 83 7D 0C FF 74 48 81 7D 0C FF FF FF 7F 74 3F 83 7D 0C 01 76 39 8B 55 0C 83 EA 01 39 15 ?? ?? ?? ?? 73 0A A1 ?? ?? ?? ?? 89 45 C0 EB 09 8B 4D 0C 83 E9 01 89 4D C0 8B 55 C0 52 68 FD 00 00 00 8B 45 08 83 C0 01 50 E8 ?? ?? ?? ?? 83 C4 0C 33 C9 74 09 C7 45 BC 01 00 00 00 EB 07 C7 45 BC 00 00 00 00 8B 55 BC 89 55 DC 83 7D DC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 6D 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D DC 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 6D 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 E2 00 00 00 8B 4D F4 8A 55 FC 88 11 8B 45 FC 83 C0 01 89 45 FC E8 ?? ?? ?? ?? 8B 08 89 4D F0 E8 ?? ?? ?? ?? C7 00 00 00 00 00 6A 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 0E E8 ?? ?? ?? ?? 83 38 0D 0F 85 90 00 00 00 83 7D FC 7B 75 69 8B 45 08 C6 00 00 83 7D 0C FF 74 49 81 7D 0C FF FF FF 7F 74 40 83 7D 0C 01 76 3A 8B 4D 0C 83 E9 01 39 0D ?? ?? ?? ?? 73 0B 8B 15 ?? ?? ?? ?? 89 55 B8 EB 09 8B 45 0C 83 E8 01 89 45 B8 8B 4D B8 51 68 FD 00 00 00 8B 55 08 83 C2 01 52 E8 ?? ?? ?? ?? 83 C4 0C E8 ?? ?? ?? ?? C7 00 11 00 00 00 E8 ?? ?? ?? ?? 8B 00 EB 2D 8B 45 F4 8A 4D FC 88 08 8B 55 FC 83 C2 01 89 55 FC E8 ?? ?? ?? ?? C7 00 00 00 00 00 E9 50 FF FF FF E8 ?? ?? ?? ?? 8B 4D F0 89 08 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_96_1_0 {
	meta:
		name = "__mktemp"
		size = 155
		refs = "0019 ??_C@_1CG@KGJJGDAD@?$AA?$CI?$AAt?$AAe?$AAm?$AAp?$AAl?$AAa?$AAt?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0025 ??_C@_1BC@DAFAJEIO@?$AAm?$AAk?$AAt?$AAe?$AAm?$AAp?$AA?4?$AAc?$AA?$AA@ 002c __CrtDbgReportW 0040 __errno 0057 ??_C@_1BA@IPOMBLKF@?$AA_?$AAm?$AAk?$AAt?$AAe?$AAm?$AAp?$AA?$AA@ 0061 __invalid_parameter 0071 _strlen 0081 __mktemp_s"
	strings:
		$1 = { 55 8B EC 83 EC 08 33 C0 83 7D 08 00 0F 95 C0 89 45 F8 83 7D F8 00 75 21 68 ?? ?? ?? ?? 6A 00 68 A3 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F8 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 A3 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 2B 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 83 C0 01 50 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 8B 45 FC F7 D8 1B C0 F7 D0 23 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_254_1_0 {
	meta:
		name = "__wmktemp"
		size = 155
		refs = "0019 ??_C@_1CG@KGJJGDAD@?$AA?$CI?$AAt?$AAe?$AAm?$AAp?$AAl?$AAa?$AAt?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0025 ??_C@_1GC@KMHJAPCA@?$AAf?$AA?3?$AA?2?$AAr?$AAt?$AAm?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2@ 002c __CrtDbgReportW 0040 __errno 0057 ??_C@_1BC@CDBPDJP@?$AA_?$AAw?$AAm?$AAk?$AAt?$AAe?$AAm?$AAp?$AA?$AA@ 0061 __invalid_parameter 0071 _wcslen 0081 __wmktemp_s"
	strings:
		$1 = { 55 8B EC 83 EC 08 33 C0 83 7D 08 00 0F 95 C0 89 45 F8 83 7D F8 00 75 21 68 ?? ?? ?? ?? 6A 00 68 A3 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F8 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 A3 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 2B 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 83 C0 01 50 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 8B 45 FC F7 D8 1B C0 F7 D0 23 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_97_1_0 {
	meta:
		name = "_vscan_fn"
		size = 315
		refs = "0011 _wcslen 002e ??_C@_1CC@OLIJCKA@?$AA?$CI?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0037 ??_C@_1GC@FPFJMOBM@?$AAf?$AA?3?$AA?2?$AAr?$AAt?$AAm?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2@ 003e __CrtDbgReportW 0052 __errno 0066 ??_C@_1BC@KMGJCMNP@?$AAv?$AAs?$AAc?$AAa?$AAn?$AA_?$AAf?$AAn?$AA?$AA@ 0070 __invalid_parameter 0092 ??_C@_1CC@MGIEJOME@?$AA?$CI?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@"
	strings:
		$1 = { 55 8B EC 83 EC 34 8D 45 D4 89 45 F4 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 33 D2 83 7D 0C 00 0F 95 C2 89 55 D0 83 7D D0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 32 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D0 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 32 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 B8 00 00 00 33 C9 83 7D 10 00 0F 95 C1 89 4D CC 83 7D CC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 33 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D CC 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 33 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 57 8B 45 F4 C7 40 0C 49 00 00 00 8B 4D F4 8B 55 0C 89 51 08 8B 45 F4 8B 4D 0C 89 08 81 7D FC FF FF FF 3F 76 0C 8B 55 F4 C7 42 04 FF FF FF 7F EB 0B 8B 45 FC D1 E0 8B 4D F4 89 41 04 8B 55 18 52 8B 45 14 50 8B 4D 10 51 8B 55 F4 52 FF 55 08 83 C4 10 89 45 F8 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_98_0_0 {
	meta:
		name = "__mbsspnp_l"
		size = 596
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0016 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 002c _strspn 005f ??1_LocaleUpdate@@QAE@XZ 007e ??_C@_1BO@JIBAMMGI@?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0087 ??_C@_1GC@EMILMKGD@?$AAf?$AA?3?$AA?2?$AAr?$AAt?$AAm?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2@ 008e __CrtDbgReportW 00a2 __errno 00b6 ??_C@_1BG@DIADCNPB@?$AA_?$AAm?$AAb?$AAs?$AAs?$AAp?$AAn?$AAp?$AA_?$AAl?$AA?$AA@ 00c0 __invalid_parameter 00f1 ??_C@_1CA@KMNJPEDI@?$AAc?$AAh?$AAa?$AAr?$AAs?$AAe?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@"
	strings:
		$1 = { 55 8B EC 83 EC 38 8B 45 10 50 8D 4D E8 E8 ?? ?? ?? ?? 8D 4D E8 E8 ?? ?? ?? ?? 8B 48 04 83 79 08 00 75 48 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 E4 8B 4D 08 03 4D E4 0F B6 11 85 D2 74 0B 8B 45 08 03 45 E4 89 45 C8 EB 07 C7 45 C8 00 00 00 00 8B 4D C8 89 4D D8 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 D8 E9 E5 01 00 00 33 D2 83 7D 08 00 0F 95 C2 89 55 E0 83 7D E0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 55 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 3D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 55 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 D4 00 00 00 00 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 D4 E9 72 01 00 00 33 C9 83 7D 0C 00 0F 95 C1 89 4D DC 83 7D DC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 56 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D DC 00 75 3D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 56 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 D0 00 00 00 00 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 D0 E9 FF 00 00 00 8B 45 08 89 45 F8 EB 09 8B 4D F8 83 C1 01 89 4D F8 8B 55 F8 0F B6 02 85 C0 0F 84 C5 00 00 00 8B 4D 0C 89 4D FC EB 09 8B 55 FC 83 C2 01 89 55 FC 8B 45 FC 0F B6 08 85 C9 74 69 8D 4D E8 E8 ?? ?? ?? ?? 8B 50 04 8B 45 FC 0F B6 08 0F B6 54 0A 1D 83 E2 04 74 3A 8B 45 FC 0F B6 08 8B 55 F8 0F B6 02 3B C8 75 12 8B 4D FC 0F B6 51 01 8B 45 F8 0F B6 48 01 3B D1 74 0B 8B 55 FC 0F B6 42 01 85 C0 75 02 EB 1F 8B 4D FC 83 C1 01 89 4D FC EB 12 8B 55 FC 0F B6 02 8B 4D F8 0F B6 11 3B C2 75 02 EB 02 EB 84 8B 45 FC 0F B6 08 85 C9 75 02 EB 35 8D 4D E8 E8 ?? ?? ?? ?? 8B 50 04 8B 45 F8 0F B6 08 0F B6 54 0A 1D 83 E2 04 74 15 8B 45 F8 83 C0 01 89 45 F8 8B 4D F8 0F B6 11 85 D2 75 02 EB 05 E9 24 FF FF FF 8B 45 F8 0F B6 08 F7 D9 1B C9 23 4D F8 89 4D CC 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 CC 8B E5 5D C3 }
	condition:
		$1
}

rule file_101_0_0 {
	meta:
		name = "__wfdopen"
		size = 1337
		refs = "0006 __sehtable$__wfdopen 000b __except_handler4 001d ___security_cookie 0043 ??_C@_1BK@HGLMNMEC@?$AAm?$AAo?$AAd?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 004c ??_C@_1GC@BIJDOFPE@?$AAf?$AA?3?$AA?2?$AAr?$AAt?$AAm?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2@ 0053 __CrtDbgReportW 0067 __errno 007b ??_C@_1BC@IIBNLAJC@?$AA_?$AAw?$AAf?$AAd?$AAo?$AAp?$AAe?$AAn?$AA?$AA@ 0085 __invalid_parameter 00b6 __nhandle 00d9 ??_C@_1HC@KFLBHHBC@?$AA?$CI?$AAf?$AAi?$AAl?$AAe?$AAd?$AAe?$AAs?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AAu?$AAn?$AAs?$AAi?$AAg?$AAn?$AAe?$AAd?$AA?$CJ?$AAf?$AAi?$AAl?$AAe?$AAd@ 013b ___pioinfo 0153 ??_C@_1DG@LNNHNFHJ@?$AA?$CI?$AA_?$AAo?$AAs?$AAf?$AAi?$AAl?$AAe?$AA?$CI?$AAf?$AAi?$AAl?$AAe?$AAd?$AAe?$AAs?$AA?$CJ?$AA?5?$AA?$CG?$AA?5?$AAF?$AAO?$AAP?$AAE?$AAN?$AA?$CJ?$AA?$AA@ 0209 ??_C@_1DK@PKMJBLLN@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAf?$AAi?$AAl?$AAe?$AA?5?$AAo?$AAp?$AAe?$AAn?$AA?5?$AAm?$AAo?$AAd?$AAe?$AA?$CC?$AA?0?$AA0?$AA?$CJ?$AA?$AA@ 0272 __commode 02bc $LN56 02c3 $LN58 0405 ??_C@_1CI@KEDPFCAL@?$AA?$CI?$AA?$CK?$AAm?$AAo?$AAd?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$CJ?$AA?$AA@ 0459 __getstream 047d __cflush 04ae __unlock_file 04cc $LN20 04d0 $LN19 04d4 $LN16 04d8 $LN13 04dc $LN10 04e0 $LN7"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 B8 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 33 C0 83 7D 0C 00 0F 95 C0 89 45 D0 83 7D D0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 33 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D0 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 33 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 26 04 00 00 83 7D 08 FE 75 12 E8 ?? ?? ?? ?? C7 00 09 00 00 00 33 C0 E9 0E 04 00 00 83 7D 08 00 7C 14 8B 55 08 3B 15 ?? ?? ?? ?? 73 09 C7 45 B8 01 00 00 00 EB 07 C7 45 B8 00 00 00 00 8B 45 B8 89 45 CC 83 7D CC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 37 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D CC 00 75 2D E8 ?? ?? ?? ?? C7 00 09 00 00 00 6A 00 6A 37 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 90 03 00 00 8B 55 08 C1 FA 05 8B 45 08 83 E0 1F 6B C0 28 8B 0C 95 ?? ?? ?? ?? 0F BE 54 01 04 83 E2 01 F7 DA 1B D2 F7 DA 89 55 C8 75 1E 68 ?? ?? ?? ?? 6A 00 6A 38 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D C8 00 75 2D E8 ?? ?? ?? ?? C7 00 09 00 00 00 6A 00 6A 38 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 16 03 00 00 8B 4D 0C 0F B7 11 83 FA 20 75 0B 8B 45 0C 83 C0 02 89 45 0C EB EA 8B 4D 0C 0F B7 11 89 55 B4 83 7D B4 61 74 17 83 7D B4 72 74 08 83 7D B4 77 74 0B EB 12 C7 45 E0 01 00 00 00 EB 7A C7 45 E0 02 00 00 00 EB 71 33 C0 74 09 C7 45 B0 01 00 00 00 EB 07 C7 45 B0 00 00 00 00 8B 4D B0 89 4D C4 83 7D C4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 4B 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D C4 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 4B 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 60 02 00 00 C7 45 D8 01 00 00 00 C7 45 DC 00 00 00 00 8B 45 DC 89 45 D4 8B 4D E0 0B 0D ?? ?? ?? ?? 89 4D E0 8B 55 0C 83 C2 02 89 55 0C 8B 45 0C 0F B7 08 85 C9 0F 84 4C 01 00 00 83 7D D8 00 0F 84 42 01 00 00 8B 55 0C 0F B7 02 89 45 AC 8B 4D AC 83 E9 20 89 4D AC 83 7D AC 54 0F 87 AA 00 00 00 8B 55 AC 0F B6 82 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? E9 0B 01 00 00 8B 4D E0 81 E1 80 00 00 00 74 09 C7 45 D8 00 00 00 00 EB 15 8B 55 E0 81 CA 80 00 00 00 89 55 E0 8B 45 E0 83 E0 FC 89 45 E0 E9 DD 00 00 00 83 7D D4 00 74 09 C7 45 D8 00 00 00 00 EB 07 C7 45 D4 01 00 00 00 E9 C2 00 00 00 83 7D DC 00 74 09 C7 45 D8 00 00 00 00 EB 13 C7 45 DC 01 00 00 00 8B 4D E0 81 C9 00 40 00 00 89 4D E0 E9 9B 00 00 00 83 7D DC 00 74 09 C7 45 D8 00 00 00 00 EB 13 C7 45 DC 01 00 00 00 8B 55 E0 81 E2 FF BF FF FF 89 55 E0 EB 77 33 C0 74 09 C7 45 A8 01 00 00 00 EB 07 C7 45 A8 00 00 00 00 8B 4D A8 89 4D C0 83 7D C0 00 75 21 68 ?? ?? ?? ?? 6A 00 68 86 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D C0 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 86 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 E2 00 00 00 E9 9D FE FF FF 8B 45 0C 0F B7 08 83 F9 20 75 0B 8B 55 0C 83 C2 02 89 55 0C EB EA 8B 45 0C 0F B7 08 F7 D9 1B C9 83 C1 01 89 4D BC 75 21 68 ?? ?? ?? ?? 6A 00 68 8F 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D BC 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 8F 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 61 E8 ?? ?? ?? ?? 89 45 E4 83 7D E4 00 75 0F E8 ?? ?? ?? ?? C7 00 18 00 00 00 33 C0 EB 44 C7 45 FC 00 00 00 00 A1 ?? ?? ?? ?? 83 C0 01 A3 ?? ?? ?? ?? 8B 4D E4 8B 55 E0 89 51 0C 8B 45 E4 8B 4D 08 89 48 10 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0D 8B 55 E4 52 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 E4 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 05 05 05 05 05 05 05 05 05 05 01 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 02 03 05 05 05 05 05 05 05 05 05 05 04 05 05 05 05 05 02 }
	condition:
		$1
}

rule file_102_0_0 {
	meta:
		name = "__ismbcdigit_l"
		size = 367
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0049 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0061 ??1_LocaleUpdate@@QAE@XZ 00a3 ___crtGetStringTypeA 012a __isctype_l 0146 __chvalidator_l"
	strings:
		$1 = { 55 8B EC 83 EC 30 8B 45 0C 50 8D 4D F0 E8 ?? ?? ?? ?? 81 7D 08 FF 00 00 00 0F 86 DC 00 00 00 66 C7 45 EC 00 00 33 C9 66 89 4D EE 8B 55 08 C1 EA 08 81 E2 FF 00 00 00 88 55 E8 8B 45 08 25 FF 00 00 00 88 45 E9 8D 4D F0 E8 ?? ?? ?? ?? 8B 48 04 83 79 08 00 75 17 C7 45 E4 00 00 00 00 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 E4 E9 FE 00 00 00 6A 01 8D 4D F0 E8 ?? ?? ?? ?? 8B 50 04 8B 42 0C 50 8D 4D F0 E8 ?? ?? ?? ?? 8B 48 04 8B 51 04 52 8D 45 EC 50 6A 02 8D 4D E8 51 6A 01 8D 4D F0 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 20 85 C0 75 17 C7 45 E0 00 00 00 00 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 E0 E9 A6 00 00 00 0F B7 55 EE 85 D2 75 12 0F B7 45 EC 83 E0 04 74 09 C7 45 D4 01 00 00 00 EB 07 C7 45 D4 00 00 00 00 8B 4D D4 89 4D DC 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 DC EB 72 EB 68 8D 4D F0 E8 ?? ?? ?? ?? 85 C0 74 2F 8D 4D F0 E8 ?? ?? ?? ?? 8B 10 83 BA AC 00 00 00 01 7E 1C 8D 4D F0 E8 ?? ?? ?? ?? 50 6A 04 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 89 45 D0 EB 1A 6A 04 8B 4D 08 51 8D 4D F0 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 0C 89 45 D0 8B 55 D0 89 55 D8 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 D8 EB 08 8D 4D F0 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_103_0_0 {
	meta:
		name = "_memchr"
		size = 173
	strings:
		$1 = { 8B 44 24 0C 53 85 C0 74 52 8B 54 24 08 33 DB 8A 5C 24 0C F7 C2 03 00 00 00 74 16 8A 0A 83 C2 01 32 CB 74 72 83 E8 01 74 32 F7 C2 03 00 00 00 75 EA 83 E8 04 72 12 57 8B FB C1 E3 08 03 DF 8B FB C1 E3 10 03 DF EB 1B 5F 83 C0 04 74 0E 8A 0A 83 C2 01 32 CB 74 40 83 E8 01 75 F2 5B C3 83 E8 04 72 E5 8B 0A 33 CB BF FF FE FE 7E 03 F9 83 F1 FF 33 CF 83 C2 04 81 E1 00 01 01 81 74 E0 8B 4A FC 32 CB 74 23 32 EB 74 19 C1 E9 10 32 CB 74 0C 32 EB 74 02 EB C8 5F 8D 42 FF 5B C3 8D 42 FE 5F 5B C3 8D 42 FD 5F 5B C3 8D 42 FC 5F 5B C3 }
	condition:
		$1
}

rule file_104_0_0 {
	meta:
		name = "___init_time"
		size = 238
		refs = "0010 ??_C@_0L@IOJADHBB@inittime?4c?$AA@ 001e __calloc_dbg 0041 __get_lc_time 0051 ___free_lc_time 005f __free_dbg 007f ___lc_time_c 00a4 __imp__InterlockedDecrement@4 00bf ??_C@_1EE@FDHCFDHN@?$AAp?$AAl?$AAo?$AAc?$AAi?$AA?9?$AA?$DO?$AAl?$AAc?$AA_?$AAt?$AAi?$AAm?$AAe?$AA_?$AAc?$AAu?$AAr?$AAr?$AA?9?$AA?$DO?$AAr?$AAe?$AAf?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DO?$AA?5@ 00c8 ??_C@_1BG@HHBAFOPB@?$AAi?$AAn?$AAi?$AAt?$AAt?$AAi?$AAm?$AAe?$AA?4?$AAc?$AA?$AA@ 00cf __CrtDbgReportW"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 83 78 20 00 74 6F 6A 40 68 ?? ?? ?? ?? 6A 02 68 B8 00 00 00 6A 01 E8 ?? ?? ?? ?? 83 C4 14 89 45 FC 83 7D FC 00 75 0A B8 01 00 00 00 E9 B2 00 00 00 8B 4D 08 51 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 21 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 6A 02 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 B8 01 00 00 00 EB 7D 8B 55 FC C7 82 B4 00 00 00 01 00 00 00 EB 07 C7 45 FC ?? ?? ?? ?? 8B 45 08 81 B8 D4 00 00 00 ?? ?? ?? ?? 74 4A 8B 4D 08 8B 91 D4 00 00 00 81 C2 B4 00 00 00 52 FF 15 ?? ?? ?? ?? 85 C0 75 30 8B 45 08 8B 88 D4 00 00 00 83 B9 B4 00 00 00 00 7F 1E 68 ?? ?? ?? ?? 6A 00 6A 50 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 8B 45 08 8B 4D FC 89 88 D4 00 00 00 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_104_1_0 {
	meta:
		name = "__get_lc_time"
		size = 1570
		refs = "0050 ___getlocaleinfo"
	strings:
		$1 = { 55 8B EC 83 EC 14 C7 45 EC 00 00 00 00 8B 45 0C 0F B7 48 42 89 4D F0 8B 55 0C 0F B7 42 44 89 45 FC 83 7D 08 00 75 08 83 C8 FF E9 EF 05 00 00 8B 4D 0C 89 4D F4 C7 45 F8 00 00 00 00 8B 55 08 83 C2 04 52 6A 31 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 08 52 6A 32 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 0C 52 6A 33 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 10 52 6A 34 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 14 52 6A 35 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 18 52 6A 36 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 52 6A 37 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 20 52 6A 2A 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 24 52 6A 2B 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 28 52 6A 2C 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 2C 52 6A 2D 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 30 52 6A 2E 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 34 52 6A 2F 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 1C 52 6A 30 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 38 52 6A 44 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 3C 52 6A 45 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 40 52 6A 46 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 44 52 6A 47 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 48 52 6A 48 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 4C 52 6A 49 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 50 52 6A 4A 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 54 52 6A 4B 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 58 52 6A 4C 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 5C 52 6A 4D 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 60 52 6A 4E 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 64 52 6A 4F 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 68 52 6A 38 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 6C 52 6A 39 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 70 52 6A 3A 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 74 52 6A 3B 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 78 52 6A 3C 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 7C 52 6A 3D 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 81 C2 80 00 00 00 52 6A 3E 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 81 C2 84 00 00 00 52 6A 3F 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 81 C2 88 00 00 00 52 6A 40 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 81 C2 8C 00 00 00 52 6A 41 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 81 C2 90 00 00 00 52 6A 42 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 81 C2 94 00 00 00 52 6A 43 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 81 C2 98 00 00 00 52 6A 28 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 81 C2 9C 00 00 00 52 6A 29 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 81 C2 A0 00 00 00 52 6A 1F 8B 45 FC 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 81 C2 A4 00 00 00 52 6A 20 8B 45 FC 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 81 C2 A8 00 00 00 52 68 03 10 00 00 8B 45 FC 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 81 C2 B0 00 00 00 52 68 09 10 00 00 8B 45 FC 50 6A 00 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 8B 45 FC 89 82 AC 00 00 00 8B 45 EC 8B E5 5D C3 }
	condition:
		$1
}

rule file_104_2_0 {
	meta:
		name = "___free_lc_time"
		size = 779
		refs = "0018 __free_dbg"
	strings:
		$1 = { 55 8B EC 83 7D 08 00 75 05 E9 FB 02 00 00 6A 02 8B 45 08 8B 48 04 51 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 55 08 8B 42 08 50 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 4D 08 8B 51 0C 52 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 45 08 8B 48 10 51 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 55 08 8B 42 14 50 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 4D 08 8B 51 18 52 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 45 08 8B 08 51 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 55 08 8B 42 20 50 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 4D 08 8B 51 24 52 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 45 08 8B 48 28 51 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 55 08 8B 42 2C 50 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 4D 08 8B 51 30 52 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 45 08 8B 48 34 51 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 55 08 8B 42 1C 50 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 4D 08 8B 51 38 52 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 45 08 8B 48 3C 51 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 55 08 8B 42 40 50 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 4D 08 8B 51 44 52 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 45 08 8B 48 48 51 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 55 08 8B 42 4C 50 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 4D 08 8B 51 50 52 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 45 08 8B 48 54 51 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 55 08 8B 42 58 50 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 4D 08 8B 51 5C 52 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 45 08 8B 48 60 51 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 55 08 8B 42 64 50 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 4D 08 8B 51 68 52 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 45 08 8B 48 6C 51 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 55 08 8B 42 70 50 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 4D 08 8B 51 74 52 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 45 08 8B 48 78 51 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 55 08 8B 42 7C 50 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 4D 08 8B 91 80 00 00 00 52 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 45 08 8B 88 84 00 00 00 51 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 55 08 8B 82 88 00 00 00 50 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 4D 08 8B 91 8C 00 00 00 52 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 45 08 8B 88 90 00 00 00 51 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 55 08 8B 82 94 00 00 00 50 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 4D 08 8B 91 98 00 00 00 52 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 45 08 8B 88 9C 00 00 00 51 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 55 08 8B 82 A0 00 00 00 50 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 4D 08 8B 91 A4 00 00 00 52 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 45 08 8B 88 A8 00 00 00 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_106_0_0 {
	meta:
		name = "__assert"
		size = 2767
		refs = "000a ___security_cookie 0018 __set_error_mode 0034 ___app_type 003c ___iob_func 005a _setvbuf 006e __assertstring 007c _fprintf 008d _fflush 00a1 ??_C@_1BC@IOLPDCAK@?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AA?4?$AAc?$AA?$AA@ 00a6 ??_C@_1BA@DADDCNOK@?$AA_?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AA?$AA@ 00ab ??_C@_1GK@MEIIIEKC@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AA?5?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA6?$AA0?$AA?5?$AA?$CK?$AA?5?$AA9?$AA?$CJ?$AA?0?$AA?5?$AA?$CC@ 00b0 ??_C@_0BC@LAIDCHCH@Assertion?5failed?$CB?$AA@ 00c1 _strcpy_s 00ca __invoke_watson_if_error 00e3 ??_C@_1FI@LABOHEIE@?$AAs?$AAt?$AAr?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AA?5?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA6?$AA0?$AA?5?$AA?$CK?$AA?5?$AA9?$AA?$CJ?$AA?0?$AA?5?$AAd@ 00e9 _dblnewline 00fb _strcat_s 011d ??_C@_1FK@JLNGAFHA@?$AAs?$AAt?$AAr?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AA?5?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA6?$AA0?$AA?5?$AA?$CK?$AA?5?$AA9?$AA?$CJ?$AA?0?$AA?5?$AA?$CC@ 0122 ??_C@_09KLGCKDOD@Program?3?5?$AA@ 015a __imp__GetModuleFileNameA@12 0174 ??_C@_1GO@MKBPHEIL@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AA?5?$AAp?$AAr?$AAo?$AAg?$AAn?$AAa?$AAm?$AAe?$AA?0?$AA?5?$AA2?$AA6?$AA0?$AA?5?$AA?$CL?$AA?5?$AA1?$AA?0?$AA?5?$AA?$CC?$AA?$DM?$AAp@ 0179 ??_C@_0BH@DNAGHKFM@?$DMprogram?5name?5unknown?$DO?$AA@ 01ae _strlen 01ee ??_C@_1HO@DGLFHLNC@?$AA_?$AAm?$AAb?$AAs?$AAn?$AAb?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AA?5?$AAp?$AAc?$AAh?$AA?0?$AA?5?$AA?$CI?$AA2?$AA6?$AA0?$AA?5?$AA?$CL?$AA?5?$AA1?$AA?$CJ?$AA?5?$AA?9?$AA?5?$AA?$CI?$AAp@ 01f5 _dotdotdot 0218 __mbsnbcpy_s 023a ??_C@_1EK@HNKCAGGP@?$AAs?$AAt?$AAr?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AA?5?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA6?$AA0?$AA?5?$AA?$CK?$AA?5?$AA9?$AA?$CJ?$AA?0?$AA?5?$AAp@ 0274 ??_C@_1FC@HGJOLIGH@?$AAs?$AAt?$AAr?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AA?5?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA6?$AA0?$AA?5?$AA?$CK?$AA?5?$AA9?$AA?$CJ?$AA?0?$AA?5?$AAn@ 027a _newline 02ae ??_C@_1FE@JHHKPPGM@?$AAs?$AAt?$AAr?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AA?5?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA6?$AA0?$AA?5?$AA?$CK?$AA?5?$AA9?$AA?$CJ?$AA?0?$AA?5?$AA?$CC@ 02b3 ??_C@_06IGPBOHMJ@File?3?5?$AA@ 03ca ??_C@_1GK@LELDAJFN@?$AA_?$AAm?$AAb?$AAs?$AAn?$AAb?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AA?5?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA6?$AA0?$AA?5?$AA?$CK?$AA?5?$AA9?$AA?$CJ@ 03f2 __mbsnbcat_s 0414 ??_C@_1FG@BIHAHDLM@?$AAs?$AAt?$AAr?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AA?5?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA6?$AA0?$AA?5?$AA?$CK?$AA?5?$AA9?$AA?$CJ?$AA?0?$AA?5?$AAd@ 044e ??_C@_1FO@ILLBEHNB@?$AAs?$AAt?$AAr?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AA?5?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA6?$AA0?$AA?5?$AA?$CK?$AA?5?$AA9?$AA?$CJ?$AA?0?$AA?5?$AAp@ 05a1 ??_C@_1HC@NNJOOJHD@?$AA_?$AAm?$AAb?$AAs?$AAn?$AAb?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AA?5?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA6?$AA0?$AA?5?$AA?$CK?$AA?5?$AA9?$AA?$CJ@ 0630 ??_C@_1HK@LJCIAEID@?$AA_?$AAm?$AAb?$AAs?$AAn?$AAb?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AA?5?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA6?$AA0?$AA?5?$AA?$CK?$AA?5?$AA9?$AA?$CJ@ 06c3 ??_C@_1IC@IABENIAD@?$AAs?$AAt?$AAr?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AA?5?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA6?$AA0?$AA?5?$AA?$CK?$AA?5?$AA9?$AA?$CJ?$AA?0?$AA?5?$AAp@ 072c ??_C@_1FE@BELKICLD@?$AAs?$AAt?$AAr?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AA?5?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA6?$AA0?$AA?5?$AA?$CK?$AA?5?$AA9?$AA?$CJ?$AA?0?$AA?5?$AAf@ 079d ??_C@_1FE@EHMPHKDB@?$AAs?$AAt?$AAr?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AA?5?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA6?$AA0?$AA?5?$AA?$CK?$AA?5?$AA9?$AA?$CJ?$AA?0?$AA?5?$AA?$CC@ 07a2 ??_C@_06FIEBOLOH@Line?3?5?$AA@ 07d5 ??_C@_1KG@MJEHKFDP@?$AA_?$AAi?$AAt?$AAo?$AAa?$AA_?$AAs?$AA?$CI?$AA?5?$AAl?$AAi?$AAn?$AAe?$AAn?$AAo?$AA?0?$AA?5?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AAb?$AAu?$AAf?$AA?5?$AA?$CL?$AA?5?$AAs?$AAt?$AAr@ 080e __itoa_s 086a ??_C@_1GA@GHECLIPG@?$AAs?$AAt?$AAr?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AA?5?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA6?$AA0?$AA?5?$AA?$CK?$AA?5?$AA9?$AA?$CJ?$AA?0?$AA?5?$AA?$CC@ 086f ??_C@_0N@MEECIJGN@Expression?3?5?$AA@ 08d2 ??_C@_1CHK@HNOMNMBD@?$AA_?$AAm?$AAb?$AAs?$AAn?$AAb?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AA?5?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA6?$AA0?$AA?5?$AA?$CK?$AA?5?$AA9?$AA?$CJ@ 0961 ??_C@_1EM@ENNCDANH@?$AAs?$AAt?$AAr?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AA?5?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA6?$AA0?$AA?5?$AA?$CK?$AA?5?$AA9?$AA?$CJ?$AA?0?$AA?5?$AAe@ 09d2 ??_C@_1BCK@FOGOPFPO@?$AAs?$AAt?$AAr?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA6?$AA0?$AA?5?$AA?$CK?$AA?5?$AA9?$AA?$CJ?$AA?0?$AA?5?$AA?$CC?$AAF@ 09d7 ??_C@_0HA@OJHAGA@For?5information?5on?5how?5your?5prog@ 0a0a ??_C@_1FG@FPMGDMJC@?$AAs?$AAt?$AAr?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA6?$AA0?$AA?5?$AA?$CK?$AA?5?$AA9?$AA?$CJ?$AA?0?$AA?5?$AAd?$AAb@ 0a44 ??_C@_1LM@PPELICOO@?$AAs?$AAt?$AAr?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA6?$AA0?$AA?5?$AA?$CK?$AA?5?$AA9?$AA?$CJ?$AA?0?$AA?5?$AA?$CC?$AA?$CI@ 0a49 ??_C@_0DN@EBBNMLME@?$CIPress?5Retry?5to?5debug?5the?5applic@ 0a70 ??_C@_0CF@GOGNBNAK@Microsoft?5Visual?5C?$CL?$CL?5Runtime?5Lib@ 0a7c ___crtMessageBoxA 0a95 _raise 0a9f __exit 0abb _abort 0ac7 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC 48 03 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 57 6A 03 E8 ?? ?? ?? ?? 83 C4 04 83 F8 01 74 17 6A 03 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 67 83 3D ?? ?? ?? ?? 01 75 5E E8 ?? ?? ?? ?? 8B 40 4C 25 0C 01 00 00 75 17 6A 00 6A 04 6A 00 E8 ?? ?? ?? ?? 83 C0 40 50 E8 ?? ?? ?? ?? 83 C4 10 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C0 40 50 E8 ?? ?? ?? ?? 83 C4 14 E8 ?? ?? ?? ?? 83 C0 40 50 E8 ?? ?? ?? ?? 83 C4 04 E9 21 0A 00 00 6A 00 68 EA 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 1C 02 00 00 8D 8D D8 FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 EB 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 52 68 1C 02 00 00 8D 85 D8 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 F0 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 1C 02 00 00 8D 8D D8 FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 C6 85 CC FD FF FF 00 68 04 01 00 00 8D 95 C8 FC FF FF 52 6A 00 FF 15 ?? ?? ?? ?? 85 C0 75 38 6A 00 68 F4 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 05 01 00 00 8D 85 C8 FC FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8D 8D C8 FC FF FF 89 8D D4 FD FF FF 8D 95 C8 FC FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 83 C0 0B 83 F8 3C 76 6B 8D 85 C8 FC FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 8B 8D D4 FD FF FF 8D 54 01 CF 89 95 D4 FD FF FF 6A 00 68 FC 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 03 A1 ?? ?? ?? ?? 50 8B 8D D4 FD FF FF 8D 95 C8 FC FF FF 2B CA B8 05 01 00 00 2B C1 50 8B 8D D4 FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 10 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 FF 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 95 D4 FD FF FF 52 68 1C 02 00 00 8D 85 D8 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 00 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 51 68 1C 02 00 00 8D 95 D8 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 05 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 1C 02 00 00 8D 85 D8 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 04 83 C0 08 83 F8 3C 0F 86 2E 04 00 00 8B 55 0C 89 95 D4 FD FF FF C7 85 B8 FC FF FF 34 00 00 00 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 BC FC FF FF C7 85 C0 FC FF FF 01 00 00 00 EB 0F 8B 8D C0 FC FF FF 83 C1 01 89 8D C0 FC FF FF 8B 95 BC FC FF FF 2B 95 C0 FC FF FF 8B 85 D4 FD FF FF 0F BE 0C 10 83 F9 5C 74 2B 8B 95 BC FC FF FF 2B 95 C0 FC FF FF 8B 85 D4 FD FF FF 0F BE 0C 10 83 F9 2F 74 10 8B 95 C0 FC FF FF 3B 95 BC FC FF FF 73 02 EB AB 8B 85 B8 FC FF FF 33 D2 B9 03 00 00 00 F7 F1 8B 95 B8 FC FF FF 2B D0 8B 85 BC FC FF FF 2B 85 C0 FC FF FF 3B D0 0F 83 EA 00 00 00 8B 85 B8 FC FF FF 33 D2 B9 03 00 00 00 F7 F1 3B 85 C0 FC FF FF 0F 86 CF 00 00 00 6A 00 68 1A 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 95 B8 FC FF FF 83 EA 03 2B 95 C0 FC FF FF 52 8B 85 D4 FD FF FF 50 68 1C 02 00 00 8D 8D D8 FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 10 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 1B 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 52 68 1C 02 00 00 8D 85 D8 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 1C 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 8D D4 FD FF FF 03 8D BC FC FF FF 2B 8D C0 FC FF FF 51 68 1C 02 00 00 8D 95 D8 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 E9 91 02 00 00 8B 85 B8 FC FF FF 33 D2 B9 03 00 00 00 F7 F1 8B 95 B8 FC FF FF 2B D0 8B 85 BC FC FF FF 2B 85 C0 FC FF FF 3B D0 0F 86 DD 00 00 00 8B 8D C0 FC FF FF D1 E9 89 8D C0 FC FF FF 6A 00 68 24 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 95 B8 FC FF FF 83 EA 03 2B 95 C0 FC FF FF 52 8B 85 D4 FD FF FF 50 68 1C 02 00 00 8D 8D D8 FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 10 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 25 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 52 68 1C 02 00 00 8D 85 D8 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 26 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 8D D4 FD FF FF 03 8D BC FC FF FF 2B 8D C0 FC FF FF 51 68 1C 02 00 00 8D 95 D8 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 E9 89 01 00 00 6A 00 68 2D 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 85 B8 FC FF FF 33 D2 B9 03 00 00 00 F7 F1 8B 95 B8 FC FF FF 2B D0 83 EA 03 52 8B 85 D4 FD FF FF 50 68 1C 02 00 00 8D 8D D8 FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 10 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 2E 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 52 68 1C 02 00 00 8D 85 D8 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 2F 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 85 B8 FC FF FF 33 D2 B9 06 00 00 00 F7 F1 83 E8 01 50 8B 95 D4 FD FF FF 03 95 BC FC FF FF 2B 95 C0 FC FF FF 52 68 1C 02 00 00 8D 85 D8 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 10 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 30 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 51 68 1C 02 00 00 8D 95 D8 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 31 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 8D D4 FD FF FF 03 8D BC FC FF FF 8B 85 B8 FC FF FF 33 D2 BE 03 00 00 00 F7 F6 8B F0 8B 85 B8 FC FF FF 33 D2 BF 06 00 00 00 F7 F7 2B F0 83 EE 02 2B CE 51 68 1C 02 00 00 8D 95 D8 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 EB 37 6A 00 68 37 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 45 0C 50 68 1C 02 00 00 8D 8D D8 FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 39 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 52 68 1C 02 00 00 8D 85 D8 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 3E 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 1C 02 00 00 8D 8D D8 FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 3F 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 0A 8D 95 D8 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 B9 1C 02 00 00 2B C8 51 8D 95 D8 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 8D 84 05 D8 FD FF FF 50 8B 4D 10 51 E8 ?? ?? ?? ?? 83 C4 10 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 40 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 52 68 1C 02 00 00 8D 85 D8 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 45 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 1C 02 00 00 8D 8D D8 FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8D 95 D8 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 8B F0 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 8D 8C 06 B0 00 00 00 81 F9 1C 02 00 00 0F 86 8F 00 00 00 6A 00 68 55 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 95 D8 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 05 B3 00 00 00 B9 1C 02 00 00 2B C8 51 8B 55 08 52 68 1C 02 00 00 8D 85 D8 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 10 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 56 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 51 68 1C 02 00 00 8D 95 D8 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 EB 37 6A 00 68 59 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 45 08 50 68 1C 02 00 00 8D 8D D8 FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 5B 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 52 68 1C 02 00 00 8D 85 D8 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 61 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 1C 02 00 00 8D 8D D8 FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 62 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 52 68 1C 02 00 00 8D 85 D8 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 67 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 1C 02 00 00 8D 8D D8 FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 68 12 20 01 00 68 ?? ?? ?? ?? 8D 95 D8 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 89 85 C4 FC FF FF 83 BD C4 FC FF FF 03 75 11 6A 16 E8 ?? ?? ?? ?? 83 C4 04 6A 03 E8 ?? ?? ?? ?? 83 BD C4 FC FF FF 04 75 03 CC EB 10 83 BD C4 FC FF FF 05 75 02 EB 05 E8 ?? ?? ?? ?? 5F 5E 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_107_1_0 {
	meta:
		name = "__forcdecpt_l"
		size = 190
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 001a _tolower 0037 _isdigit 006b ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 00b6 ??1_LocaleUpdate@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 83 EC 14 8B 45 0C 50 8D 4D EC E8 ?? ?? ?? ?? 8B 4D 08 0F BE 11 52 E8 ?? ?? ?? ?? 83 C4 04 83 F8 65 74 1C 8B 45 08 83 C0 01 89 45 08 8B 4D 08 0F B6 11 52 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 E4 8B 45 08 0F BE 08 51 E8 ?? ?? ?? ?? 83 C4 04 83 F8 78 75 09 8B 55 08 83 C2 02 89 55 08 8B 45 08 8A 08 88 4D FF 8D 4D EC E8 ?? ?? ?? ?? 8B 10 8B 82 BC 00 00 00 8B 08 8B 55 08 8A 01 88 02 8B 4D 08 83 C1 01 89 4D 08 8B 55 08 8A 02 88 45 FE 8B 4D 08 8A 55 FF 88 11 8A 45 FE 88 45 FF 8B 4D 08 0F BE 11 8B 45 08 83 C0 01 89 45 08 85 D2 75 D7 8D 4D EC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_107_6_0 {
	meta:
		name = "__cropzeros_l"
		size = 267
		refs = "000f ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0027 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0102 ??1_LocaleUpdate@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 83 EC 14 56 8B 45 0C 50 8D 4D EC E8 ?? ?? ?? ?? 8B 4D 08 0F BE 11 85 D2 74 2A 8B 45 08 0F BE 30 8D 4D EC E8 ?? ?? ?? ?? 8B 08 8B 91 BC 00 00 00 8B 02 0F BE 08 3B F1 74 0B 8B 55 08 83 C2 01 89 55 08 EB CC 8B 45 08 0F BE 08 8B 55 08 83 C2 01 89 55 08 85 C9 0F 84 A0 00 00 00 8B 45 08 0F BE 08 85 C9 74 21 8B 55 08 0F BE 02 83 F8 65 74 16 8B 4D 08 0F BE 11 83 FA 45 74 0B 8B 45 08 83 C0 01 89 45 08 EB D5 8B 4D 08 89 4D FC 8B 55 08 83 EA 01 89 55 08 8B 45 08 0F BE 08 83 F9 30 75 0B 8B 55 08 83 EA 01 89 55 08 EB EA 8B 45 08 0F BE 30 8D 4D EC E8 ?? ?? ?? ?? 8B 08 8B 91 BC 00 00 00 8B 02 0F BE 08 3B F1 75 09 8B 55 08 83 EA 01 89 55 08 8B 45 08 83 C0 01 89 45 08 8B 4D 08 8B 55 FC 8A 02 88 01 8B 4D 08 0F BE 11 8B 45 FC 83 C0 01 89 45 FC 85 D2 74 02 EB D8 8D 4D EC E8 ?? ?? ?? ?? 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_107_7_0 {
	meta:
		name = "__positive"
		size = 41
	strings:
		$1 = { 55 8B EC 51 8B 45 08 D9 EE DC 18 DF E0 F6 C4 41 7A 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_107_8_0 {
	meta:
		name = "__fassign_l"
		size = 80
		refs = "0019 __atodbl_l 003d __atoflt_l"
	strings:
		$1 = { 55 8B EC 83 EC 0C 83 7D 08 00 74 24 8B 45 14 50 8B 4D 10 51 8D 55 F8 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 0C 8B 4D F8 89 08 8B 55 FC 89 50 04 EB 1C 8B 45 14 50 8B 4D 10 51 8D 55 F4 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 0C 8B 4D F4 89 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_107_10_0 {
	meta:
		name = "__cftoe_l"
		size = 442
		refs = "0007 ___security_cookie 0038 __fltout2 0052 ??_C@_1BI@ICGGMGLK@?$AAb?$AAu?$AAf?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 005e ??_C@_1M@BMJONBHG@?$AAc?$AAv?$AAt?$AA?4?$AAc?$AA?$AA@ 0065 __CrtDbgReportW 0079 __errno 0090 ??_C@_1BC@INKAPMHI@?$AA_?$AAc?$AAf?$AAt?$AAo?$AAe?$AA_?$AAl?$AA?$AA@ 009a __invalid_parameter 00ba ??_C@_1CA@CBMNPEO@?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAB?$AAy?$AAt?$AAe?$AAs?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 0169 __fptostr 019f __cftoe2_l 01b2 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 44 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 89 45 DC 8D 4D CC 89 4D E0 C7 45 C8 00 00 00 00 6A 16 8D 55 E4 52 8D 45 CC 50 8B 4D DC 8B 51 04 52 8B 01 50 E8 ?? ?? ?? ?? 83 C4 14 33 C9 83 7D 0C 00 0F 95 C1 89 4D C4 83 7D C4 00 75 21 68 ?? ?? ?? ?? 6A 00 68 D5 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D C4 00 75 33 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 D5 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 01 01 00 00 33 C0 3B 45 10 1B C9 F7 D9 89 4D C0 75 21 68 ?? ?? ?? ?? 6A 00 68 D6 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D C0 00 75 33 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 D6 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 99 00 00 00 83 7D 10 FF 75 08 8B 45 10 89 45 BC EB 1E 8B 4D E0 33 D2 83 39 2D 0F 94 C2 8B 45 10 2B C2 33 C9 83 7D 14 00 0F 9F C1 2B C1 89 45 BC 8B 55 E0 52 8B 45 14 83 C0 01 50 8B 4D BC 51 8B 55 E0 33 C0 83 3A 2D 0F 94 C0 03 45 0C 33 C9 83 7D 14 00 0F 9F C1 03 C1 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 C8 83 7D C8 00 74 0B 8B 55 0C C6 02 00 8B 45 C8 EB 28 8B 45 1C 50 6A 00 8B 4D E0 51 8B 55 18 52 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 E8 ?? ?? ?? ?? 83 C4 1C 89 45 C8 8B 45 C8 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_107_11_0 {
	meta:
		name = "__cftoe2_l"
		size = 904
		refs = "0015 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 002c ??_C@_1BI@ICGGMGLK@?$AAb?$AAu?$AAf?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0038 ??_C@_1M@BMJONBHG@?$AAc?$AAv?$AAt?$AA?4?$AAc?$AA?$AA@ 003f __CrtDbgReportW 0053 __errno 006a ??_C@_1BE@OLBNEILL@?$AA_?$AAc?$AAf?$AAt?$AAo?$AAe?$AA2?$AA_?$AAl?$AA?$AA@ 0074 __invalid_parameter 0086 ??1_LocaleUpdate@@QAE@XZ 00a1 ??_C@_1CA@CBMNPEO@?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAB?$AAy?$AAt?$AAe?$AAs?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 0126 ??_C@_1HE@NACBNDPP@?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAB?$AAy?$AAt?$AAe?$AAs?$AA?5?$AA?$DO?$AA?5?$AA?$CI?$AAs?$AAi?$AAz?$AAe?$AA_?$AAt?$AA?$CJ?$AA?$CI?$AA3?$AA?5?$AA?$CL?$AA?5?$AA?$CI?$AAn?$AAd?$AAe?$AAc@ 01b4 __shift 01f6 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 024f ??_C@_1LE@EOIFGNCJ@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAp?$AA?0?$AA?5?$AA?$CI?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAB?$AAy?$AAt?$AAe?$AAs?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA?$CI?$AAs?$AAi?$AAz@ 0254 ??_C@_05KLBDPFGC@e?$CL000?$AA@ 0261 _strcpy_s 026a __invoke_watson_if_error 0349 __outputformat 036b _memmove"
	strings:
		$1 = { 55 8B EC 83 EC 40 C7 45 E0 00 00 00 00 8B 45 20 50 8D 4D E4 E8 ?? ?? ?? ?? 33 C9 83 7D 08 00 0F 95 C1 89 4D DC 83 7D DC 00 75 21 68 ?? ?? ?? ?? 6A 00 68 4C 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D DC 00 75 40 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 4C 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 D0 16 00 00 00 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 D0 E9 F2 02 00 00 33 C0 3B 45 0C 1B C9 F7 D9 89 4D D8 75 21 68 ?? ?? ?? ?? 6A 00 68 4D 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D8 00 75 40 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 4D 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 CC 16 00 00 00 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 CC E9 7D 02 00 00 33 C0 83 7D 10 00 0F 9E C0 83 E8 01 23 45 10 83 C0 09 3B 45 0C 1B C9 F7 D9 89 4D D4 75 21 68 ?? ?? ?? ?? 6A 00 68 55 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D4 00 75 40 E8 ?? ?? ?? ?? C7 00 22 00 00 00 6A 00 68 55 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 C8 22 00 00 00 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 C8 E9 F8 01 00 00 0F BE 45 1C 85 C0 74 27 8B 4D 18 33 D2 83 39 2D 0F 94 C2 03 55 08 89 55 FC 33 C0 83 7D 10 00 0F 9F C0 50 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 8B 55 08 89 55 FC 8B 45 18 83 38 2D 75 0F 8B 4D FC C6 01 2D 8B 55 FC 83 C2 01 89 55 FC 83 7D 10 00 7E 2D 8B 45 FC 8B 4D FC 8A 51 01 88 10 8B 45 FC 83 C0 01 89 45 FC 8D 4D E4 E8 ?? ?? ?? ?? 8B 08 8B 91 BC 00 00 00 8B 02 8B 4D FC 8A 10 88 11 8B 45 FC 03 45 10 0F BE 4D 1C F7 D9 1B C9 83 C1 01 03 C1 89 45 FC 83 7D 0C FF 75 08 8B 55 0C 89 55 C0 EB 0E 8B 45 FC 2B 45 08 8B 4D 0C 2B C8 89 4D C0 6A 00 68 8A 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 55 C0 52 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 4D FC 83 C1 02 89 4D F4 83 7D 14 00 74 06 8B 55 FC C6 02 45 8B 45 FC 83 C0 01 89 45 FC 8B 4D 18 8B 51 0C 0F BE 02 83 F8 30 0F 84 A6 00 00 00 8B 4D 18 8B 51 04 83 EA 01 89 55 F8 79 0E 8B 45 F8 F7 D8 89 45 F8 8B 4D FC C6 01 2D 8B 55 FC 83 C2 01 89 55 FC 83 7D F8 64 7C 29 8B 45 F8 99 B9 64 00 00 00 F7 F9 0F BE D0 8B 45 FC 0F BE 08 03 CA 8B 55 FC 88 0A 8B 45 F8 99 B9 64 00 00 00 F7 F9 89 55 F8 8B 55 FC 83 C2 01 89 55 FC 83 7D F8 0A 7C 29 8B 45 F8 99 B9 0A 00 00 00 F7 F9 0F BE D0 8B 45 FC 0F BE 08 03 CA 8B 55 FC 88 0A 8B 45 F8 99 B9 0A 00 00 00 F7 F9 89 55 F8 8B 55 FC 83 C2 01 89 55 FC 0F BE 45 F8 8B 4D FC 0F BE 11 03 D0 8B 45 FC 88 10 8B 0D ?? ?? ?? ?? 83 E1 01 74 20 8B 55 F4 0F BE 02 83 F8 30 75 15 6A 03 8B 4D F4 83 C1 01 51 8B 55 F4 52 E8 ?? ?? ?? ?? 83 C4 0C C7 45 C4 00 00 00 00 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 C4 8B E5 5D C3 }
	condition:
		$1
}

rule file_107_13_0 {
	meta:
		name = "__cftoe"
		size = 35
		refs = "001a __cftoe_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 18 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_460_12_0 {
	meta:
		name = "__Strftime"
		size = 35
		refs = "001a __Strftime_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 18 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_107_16_0 {
	meta:
		name = "__cftoa"
		size = 35
		refs = "001a __cftoa_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 18 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_107_21_0 {
	meta:
		name = "__cftog"
		size = 35
		refs = "001a __cftog_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 18 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_636_7_0 {
	meta:
		name = "_mbstowcs_s"
		size = 35
		refs = "001a __mbstowcs_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 18 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_436_8_0 {
	meta:
		name = "_wcstombs_s"
		size = 35
		refs = "001a __wcstombs_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 18 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_107_14_0 {
	meta:
		name = "__cftoa_l"
		size = 1990
		refs = "0069 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 008d ??_C@_1BI@ICGGMGLK@?$AAb?$AAu?$AAf?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0099 ??_C@_1M@BMJONBHG@?$AAc?$AAv?$AAt?$AA?4?$AAc?$AA?$AA@ 00a0 __CrtDbgReportW 00b4 __errno 00cb ??_C@_1BC@JOKPCIC@?$AA_?$AAc?$AAf?$AAt?$AAo?$AAa?$AA_?$AAl?$AA?$AA@ 00d5 __invalid_parameter 00e7 ??1_LocaleUpdate@@QAE@XZ 0102 ??_C@_1CA@CBMNPEO@?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAB?$AAy?$AAt?$AAe?$AAs?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 0181 ??_C@_1FC@IKIMAMJB@?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAB?$AAy?$AAt?$AAe?$AAs?$AA?5?$AA?$DO?$AA?5?$AA?$CI?$AAs?$AAi?$AAz?$AAe?$AA_?$AAt?$AA?$CJ?$AA?$CI?$AA1?$AA?5?$AA?$CL?$AA?5?$AA4?$AA?5?$AA?$CL?$AA?5?$AAn@ 01f2 __aullshr 0248 __cftoe 02c0 ?strrchr@@YAPADPADH@Z 0439 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0490 __allshl 06bf __alldiv 06e7 __allrem"
	strings:
		$1 = { 55 8B EC 81 EC 9C 00 00 00 8B 45 08 89 45 F4 C7 45 D0 FF 03 00 00 C7 45 D4 00 00 00 00 C7 45 E8 00 00 00 00 C7 45 EC 00 00 00 00 66 C7 45 DC 30 00 C7 45 B4 00 00 00 00 C7 45 FC 00 00 00 00 66 C7 45 F8 00 00 C7 45 B8 00 00 00 00 C7 45 E0 00 00 00 00 C7 45 E4 00 00 00 00 C7 45 BC 00 00 00 00 8B 4D 1C 51 8D 4D C0 E8 ?? ?? ?? ?? 83 7D 14 00 7D 07 C7 45 14 00 00 00 00 33 D2 83 7D 0C 00 0F 95 C2 89 55 B0 83 7D B0 00 75 21 68 ?? ?? ?? ?? 6A 00 68 26 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D B0 00 75 40 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 26 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 A4 16 00 00 00 8D 4D C0 E8 ?? ?? ?? ?? 8B 45 A4 E9 CF 06 00 00 33 C9 3B 4D 10 1B D2 F7 DA 89 55 AC 75 21 68 ?? ?? ?? ?? 6A 00 68 27 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D AC 00 75 40 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 27 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 A0 16 00 00 00 8D 4D C0 E8 ?? ?? ?? ?? 8B 45 A0 E9 5A 06 00 00 8B 4D 0C C6 01 00 8B 55 14 83 C2 0B 3B 55 10 1B C0 F7 D8 89 45 A8 75 21 68 ?? ?? ?? ?? 6A 00 68 2F 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D A8 00 75 40 E8 ?? ?? ?? ?? C7 00 22 00 00 00 6A 00 68 2F 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 9C 22 00 00 00 8D 4D C0 E8 ?? ?? ?? ?? 8B 45 9C E9 DB 05 00 00 8B 55 F4 8B 02 8B 52 04 B1 34 E8 ?? ?? ?? ?? 25 FF 07 00 00 83 E2 00 89 45 88 89 55 8C 81 7D 88 FF 07 00 00 0F 85 F4 00 00 00 83 7D 8C 00 0F 85 EA 00 00 00 83 7D 10 FF 75 08 8B 45 10 89 45 84 EB 09 8B 4D 10 83 E9 02 89 4D 84 6A 00 8B 55 14 52 8B 45 84 50 8B 4D 0C 83 C1 02 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 14 89 45 BC 83 7D BC 00 74 1C 8B 45 0C C6 00 00 8B 4D BC 89 4D 98 8D 4D C0 E8 ?? ?? ?? ?? 8B 45 98 E9 4E 05 00 00 8B 55 0C 0F BE 42 02 83 F8 2D 75 0F 8B 4D 0C C6 01 2D 8B 55 0C 83 C2 01 89 55 0C 8B 45 0C C6 00 30 8B 4D 0C 83 C1 01 89 4D 0C 8B 55 18 F7 DA 1A D2 80 E2 E0 80 C2 78 8B 45 0C 88 10 8B 4D 0C 83 C1 01 89 4D 0C 6A 65 8B 55 0C 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 1F 8B 45 18 F7 D8 1A C0 24 E0 04 70 8B 4D FC 88 01 8B 55 FC 83 C2 03 89 55 FC 8B 45 FC C6 00 00 8B 4D BC 89 4D 94 8D 4D C0 E8 ?? ?? ?? ?? 8B 45 94 E9 BD 04 00 00 8B 55 F4 8B 02 8B 52 04 B1 3F E8 ?? ?? ?? ?? 83 E0 01 83 E2 00 89 85 7C FF FF FF 89 55 80 8B 85 7C FF FF FF 0B 45 80 74 0F 8B 4D 0C C6 01 2D 8B 55 0C 83 C2 01 89 55 0C 8B 45 0C C6 00 30 8B 4D 0C 83 C1 01 89 4D 0C 8B 55 18 F7 DA 1A D2 80 E2 E0 80 C2 78 8B 45 0C 88 10 8B 4D 0C 83 C1 01 89 4D 0C 8B 55 18 F7 DA 1A D2 80 E2 E0 80 C2 61 0F BE C2 83 E8 3A 89 45 B8 8B 4D F4 8B 01 8B 51 04 B1 34 E8 ?? ?? ?? ?? 25 FF 07 00 00 83 E2 00 89 85 74 FF FF FF 89 95 78 FF FF FF 8B 95 74 FF FF FF 0B 95 78 FF FF FF 75 5B 8B 45 0C C6 00 30 8B 4D 0C 83 C1 01 89 4D 0C 8B 55 F4 8B 02 8B 4A 04 81 E1 FF FF 0F 00 89 85 6C FF FF FF 89 8D 70 FF FF FF 8B 95 6C FF FF FF 0B 95 70 FF FF FF 75 10 C7 45 D0 00 00 00 00 C7 45 D4 00 00 00 00 EB 12 8B 45 D0 83 E8 01 8B 4D D4 83 D9 00 89 45 D0 89 4D D4 EB 0F 8B 55 0C C6 02 31 8B 45 0C 83 C0 01 89 45 0C 8B 4D 0C 89 4D B4 8B 55 0C 83 C2 01 89 55 0C 83 7D 14 00 75 08 8B 45 B4 C6 00 00 EB 19 8D 4D C0 E8 ?? ?? ?? ?? 8B 08 8B 91 BC 00 00 00 8B 02 8B 4D B4 8A 10 88 11 8B 45 F4 8B 08 8B 50 04 81 E2 FF FF 0F 00 89 8D 64 FF FF FF 89 95 68 FF FF FF 77 0D 83 BD 64 FF FF FF 00 0F 86 70 01 00 00 C7 45 E8 0F 00 00 00 C7 45 EC 00 00 00 00 0F BF 4D DC 8B 45 E8 8B 55 EC E8 ?? ?? ?? ?? 89 45 E8 89 55 EC 0F BF 45 DC 85 C0 0F 8C 83 00 00 00 83 7D 14 00 7E 7D 8B 4D F4 8B 01 8B 51 04 81 E2 FF FF 0F 00 23 45 E8 23 55 EC 0F BF 4D DC E8 ?? ?? ?? ?? 66 89 45 F8 0F B7 55 F8 83 C2 30 66 89 55 F8 0F B7 45 F8 83 F8 39 7E 0B 0F B7 4D F8 03 4D B8 66 89 4D F8 8B 55 0C 8A 45 F8 88 02 8B 4D 0C 83 C1 01 89 4D 0C 8B 45 E8 8B 55 EC B1 04 E8 ?? ?? ?? ?? 89 45 E8 89 55 EC 0F BF 55 DC 83 EA 04 66 89 55 DC 8B 45 14 83 E8 01 89 45 14 E9 71 FF FF FF 0F BF 4D DC 85 C9 0F 8C B2 00 00 00 8B 55 F4 8B 02 8B 52 04 81 E2 FF FF 0F 00 23 45 E8 23 55 EC 0F BF 4D DC E8 ?? ?? ?? ?? 66 89 45 F8 0F B7 45 F8 83 F8 08 0F 8E 84 00 00 00 8B 4D 0C 89 4D FC 8B 55 FC 83 EA 01 89 55 FC 8B 45 FC 0F BE 08 83 F9 66 74 0B 8B 55 FC 0F BE 02 83 F8 46 75 11 8B 4D FC C6 01 30 8B 55 FC 83 EA 01 89 55 FC EB D9 8B 45 FC 3B 45 B4 74 2F 8B 4D FC 0F BE 11 83 FA 39 75 14 8B 45 FC 0F BE 08 8B 55 B8 8D 44 11 01 8B 4D FC 88 01 EB 0E 8B 55 FC 0F BE 02 83 C0 01 8B 4D FC 88 01 EB 17 8B 55 FC 83 EA 01 89 55 FC 8B 45 FC 0F BE 08 83 C1 01 8B 55 FC 88 0A EB 09 8B 45 14 83 E8 01 89 45 14 83 7D 14 00 7E 11 8B 4D 0C C6 01 30 8B 55 0C 83 C2 01 89 55 0C EB E0 8B 45 B4 0F BE 08 85 C9 75 06 8B 55 B4 89 55 0C 8B 45 18 F7 D8 1A C0 24 E0 04 70 8B 4D 0C 88 01 8B 55 0C 83 C2 01 89 55 0C 8B 4D F4 8B 01 8B 51 04 B1 34 E8 ?? ?? ?? ?? 25 FF 07 00 00 83 E2 00 2B 45 D0 1B 55 D4 89 45 E0 89 55 E4 78 19 7F 06 83 7D E0 00 72 11 8B 55 0C C6 02 2B 8B 45 0C 83 C0 01 89 45 0C EB 22 8B 4D 0C C6 01 2D 8B 55 0C 83 C2 01 89 55 0C 8B 45 E0 F7 D8 8B 4D E4 83 D1 00 F7 D9 89 45 E0 89 4D E4 8B 55 0C 89 55 B4 8B 45 B4 C6 00 30 83 7D E4 00 7C 4D 7F 09 81 7D E0 E8 03 00 00 72 42 6A 00 68 E8 03 00 00 8B 4D E4 51 8B 55 E0 52 E8 ?? ?? ?? ?? 0F BE C0 83 C0 30 8B 4D 0C 88 01 8B 55 0C 83 C2 01 89 55 0C 6A 00 68 E8 03 00 00 8B 45 E4 50 8B 4D E0 51 E8 ?? ?? ?? ?? 89 45 E0 89 55 E4 8B 55 0C 3B 55 B4 75 0E 83 7D E4 00 7C 44 7F 06 83 7D E0 64 72 3C 6A 00 6A 64 8B 45 E4 50 8B 4D E0 51 E8 ?? ?? ?? ?? 0F BE D0 83 C2 30 8B 45 0C 88 10 8B 4D 0C 83 C1 01 89 4D 0C 6A 00 6A 64 8B 55 E4 52 8B 45 E0 50 E8 ?? ?? ?? ?? 89 45 E0 89 55 E4 8B 4D 0C 3B 4D B4 75 0E 83 7D E4 00 7C 44 7F 06 83 7D E0 0A 72 3C 6A 00 6A 0A 8B 55 E4 52 8B 45 E0 50 E8 ?? ?? ?? ?? 0F BE C8 83 C1 30 8B 55 0C 88 0A 8B 45 0C 83 C0 01 89 45 0C 6A 00 6A 0A 8B 4D E4 51 8B 55 E0 52 E8 ?? ?? ?? ?? 89 45 E0 89 55 E4 0F BE 45 E0 83 C0 30 8B 4D 0C 88 01 8B 55 0C 83 C2 01 89 55 0C 8B 45 0C C6 00 00 C7 45 90 00 00 00 00 8D 4D C0 E8 ?? ?? ?? ?? 8B 45 90 8B E5 5D C3 }
	condition:
		$1
}

rule file_107_15_0 {
	meta:
		name = "?strrchr@@YAPADPADH@Z"
		size = 21
		refs = "000c _strrchr"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_608_0_0 {
	meta:
		name = "??_U@YAPAXIABUnothrow_t@std@@@Z"
		size = 21
		refs = "000c ??2@YAPAXIABUnothrow_t@std@@@Z"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_52_0_1 {
	meta:
		name = "__LDscale"
		size = 21
		refs = "000c __Dscale"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_84_0_1 {
	meta:
		name = "__LDunscale"
		size = 21
		refs = "000c __Dunscale"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_311_13_0 {
	meta:
		name = "___create_locale"
		size = 21
		refs = "000c __create_locale"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_482_3_0 {
	meta:
		name = "__atoi_l"
		size = 21
		refs = "000c __atol_l"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_209_3_0 {
	meta:
		name = "__wtoi_l"
		size = 21
		refs = "000c __wtol_l"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_107_17_0 {
	meta:
		name = "__cftof_l"
		size = 419
		refs = "0007 ___security_cookie 0038 __fltout2 0052 ??_C@_1BI@ICGGMGLK@?$AAb?$AAu?$AAf?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 005e ??_C@_1M@BMJONBHG@?$AAc?$AAv?$AAt?$AA?4?$AAc?$AA?$AA@ 0065 __CrtDbgReportW 0079 __errno 0090 ??_C@_1BC@DCPPLJL@?$AA_?$AAc?$AAf?$AAt?$AAo?$AAf?$AA_?$AAl?$AA?$AA@ 009a __invalid_parameter 00ba ??_C@_1CA@CBMNPEO@?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAB?$AAy?$AAt?$AAe?$AAs?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 0156 __fptostr 0188 __cftof2_l 019b @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 44 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 89 45 DC 8D 4D CC 89 4D E0 C7 45 C8 00 00 00 00 6A 16 8D 55 E4 52 8D 45 CC 50 8B 4D DC 8B 51 04 52 8B 01 50 E8 ?? ?? ?? ?? 83 C4 14 33 C9 83 7D 0C 00 0F 95 C1 89 4D C4 83 7D C4 00 75 21 68 ?? ?? ?? ?? 6A 00 68 89 03 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D C4 00 75 33 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 89 03 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 EA 00 00 00 33 C0 3B 45 10 1B C9 F7 D9 89 4D C0 75 21 68 ?? ?? ?? ?? 6A 00 68 8A 03 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D C0 00 75 33 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 8A 03 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 82 00 00 00 83 7D 10 FF 75 08 8B 45 10 89 45 BC EB 13 8B 4D E0 33 D2 83 39 2D 0F 94 C2 8B 45 10 2B C2 89 45 BC 8B 4D E0 51 8B 55 E0 8B 45 14 03 42 04 50 8B 4D BC 51 8B 55 E0 33 C0 83 3A 2D 0F 94 C0 03 45 0C 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 C8 83 7D C8 00 74 0B 8B 4D 0C C6 01 00 8B 45 C8 EB 24 8B 55 18 52 6A 00 8B 45 E0 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 18 89 45 C8 8B 45 C8 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_107_18_0 {
	meta:
		name = "__cftof2_l"
		size = 594
		refs = "001a ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0031 ??_C@_1BI@ICGGMGLK@?$AAb?$AAu?$AAf?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 003d ??_C@_1M@BMJONBHG@?$AAc?$AAv?$AAt?$AA?4?$AAc?$AA?$AA@ 0044 __CrtDbgReportW 0058 __errno 006f ??_C@_1BE@CKPDLI@?$AA_?$AAc?$AAf?$AAt?$AAo?$AAf?$AA2?$AA_?$AAl?$AA?$AA@ 0079 __invalid_parameter 008b ??1_LocaleUpdate@@QAE@XZ 00a6 ??_C@_1CA@CBMNPEO@?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAB?$AAy?$AAt?$AAe?$AAs?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 0178 __shift 01b8 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0235 _memset"
	strings:
		$1 = { 55 8B EC 83 EC 34 8B 45 14 8B 48 04 83 E9 01 89 4D F8 8B 55 1C 52 8D 4D E8 E8 ?? ?? ?? ?? 33 C0 83 7D 08 00 0F 95 C0 89 45 E4 83 7D E4 00 75 21 68 ?? ?? ?? ?? 6A 00 68 06 03 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E4 00 75 40 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 06 03 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 D8 16 00 00 00 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 D8 E9 B7 01 00 00 33 D2 3B 55 0C 1B C0 F7 D8 89 45 E0 75 21 68 ?? ?? ?? ?? 6A 00 68 07 03 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 40 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 07 03 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 D4 16 00 00 00 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 D4 E9 42 01 00 00 0F BE 55 18 85 D2 74 37 8B 45 14 33 C9 83 38 2D 0F 94 C1 03 4D 08 89 4D FC 8B 55 F8 3B 55 10 75 1E 8B 45 FC 03 45 F8 89 45 DC 8B 4D DC C6 01 30 8B 55 DC 83 C2 01 89 55 DC 8B 45 DC C6 00 00 8B 4D 08 89 4D FC 8B 55 14 83 3A 2D 75 0F 8B 45 FC C6 00 2D 8B 4D FC 83 C1 01 89 4D FC 8B 55 14 83 7A 04 00 7F 1F 6A 01 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4D FC C6 01 30 8B 55 FC 83 C2 01 89 55 FC EB 0C 8B 45 14 8B 4D FC 03 48 04 89 4D FC 83 7D 10 00 0F 8E 96 00 00 00 6A 01 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 08 8D 4D E8 E8 ?? ?? ?? ?? 8B 00 8B 88 BC 00 00 00 8B 11 8B 45 FC 8A 0A 88 08 8B 55 FC 83 C2 01 89 55 FC 8B 45 14 83 78 04 00 7D 5D 0F BE 4D 18 85 C9 74 0D 8B 55 14 8B 42 04 F7 D8 89 45 10 EB 26 8B 4D 14 8B 51 04 F7 DA 39 55 10 7D 08 8B 45 10 89 45 CC EB 0B 8B 4D 14 8B 51 04 F7 DA 89 55 CC 8B 45 CC 89 45 10 8B 4D 10 51 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 08 8B 45 10 50 6A 30 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 0C C7 45 D0 00 00 00 00 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 D0 8B E5 5D C3 }
	condition:
		$1
}

rule file_107_20_0 {
	meta:
		name = "__cftog_l"
		size = 550
		refs = "0007 ___security_cookie 003c __fltout2 0056 ??_C@_1BI@ICGGMGLK@?$AAb?$AAu?$AAf?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0062 ??_C@_1M@BMJONBHG@?$AAc?$AAv?$AAt?$AA?4?$AAc?$AA?$AA@ 0069 __CrtDbgReportW 007d __errno 0094 ??_C@_1BC@MPIFPLAF@?$AA_?$AAc?$AAf?$AAt?$AAo?$AAg?$AA_?$AAl?$AA?$AA@ 009e __invalid_parameter 00be ??_C@_1CA@CBMNPEO@?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAB?$AAy?$AAt?$AAe?$AAs?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 0166 __fptostr 01cb __cftoe2_l 0211 __cftof2_l 021e @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 50 A1 ?? ?? ?? ?? 33 C5 89 45 F8 C7 45 C0 00 00 00 00 8B 45 08 89 45 C4 C6 45 BF 00 8D 4D C8 89 4D D8 6A 16 8D 55 E0 52 8D 45 C8 50 8B 4D C4 8B 51 04 52 8B 01 50 E8 ?? ?? ?? ?? 83 C4 14 33 C9 83 7D 0C 00 0F 95 C1 89 4D B8 83 7D B8 00 75 21 68 ?? ?? ?? ?? 6A 00 68 E3 03 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D B8 00 75 33 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 E3 03 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 69 01 00 00 33 C0 3B 45 10 1B C9 F7 D9 89 4D B4 75 21 68 ?? ?? ?? ?? 6A 00 68 E4 03 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D B4 00 75 33 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 E4 03 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 01 01 00 00 8B 45 D8 8B 48 04 83 E9 01 89 4D DC 8B 55 D8 33 C0 83 3A 2D 0F 94 C0 03 45 0C 89 45 FC 83 7D 10 FF 75 08 8B 4D 10 89 4D B0 EB 13 8B 55 D8 33 C0 83 3A 2D 0F 94 C0 8B 4D 10 2B C8 89 4D B0 8B 55 D8 52 8B 45 14 50 8B 4D B0 51 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 10 89 45 C0 83 7D C0 00 74 0E 8B 45 0C C6 00 00 8B 45 C0 E9 94 00 00 00 8B 4D D8 8B 51 04 83 EA 01 39 55 DC 0F 9C C0 88 45 BF 8B 4D D8 8B 51 04 83 EA 01 89 55 DC 83 7D DC FC 7C 08 8B 45 DC 3B 45 14 7C 26 8B 4D 1C 51 6A 01 8B 55 D8 52 8B 45 18 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 1C EB 44 EB 42 0F BE 4D BF 85 C9 74 1C 8B 55 FC 0F BE 02 8B 4D FC 83 C1 01 89 4D FC 85 C0 74 02 EB EB 8B 55 FC C6 42 FE 00 8B 45 1C 50 6A 01 8B 4D D8 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 18 8B 4D F8 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_107_22_0 {
	meta:
		name = "__cfltcvt_l"
		size = 190
		refs = "0030 __cftoe_l 0057 __cftof_l 0088 __cftoa_l 00ad __cftog_l"
	strings:
		$1 = { 55 8B EC 51 C7 45 FC 00 00 00 00 83 7D 14 65 74 06 83 7D 14 45 75 25 8B 45 20 50 8B 4D 1C 51 8B 55 18 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 18 89 45 FC EB 7B 83 7D 14 66 75 21 8B 45 20 50 8B 4D 18 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 14 89 45 FC EB 54 83 7D 14 61 74 06 83 7D 14 41 75 25 8B 55 20 52 8B 45 1C 50 8B 4D 18 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 18 89 45 FC EB 23 8B 55 20 52 8B 45 1C 50 8B 4D 18 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 18 89 45 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_107_23_0 {
	meta:
		name = "__cfltcvt"
		size = 39
		refs = "001e __cfltcvt_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 1C 50 8B 4D 18 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 1C 5D C3 }
	condition:
		$1
}

rule file_796_5_0 {
	meta:
		name = "__raise_exc"
		size = 39
		refs = "001e __raise_exc_ex"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 1C 50 8B 4D 18 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 1C 5D C3 }
	condition:
		$1
}

rule file_107_24_0 {
	meta:
		name = "__shift"
		size = 46
		refs = "000e _strlen 0025 _memmove"
	strings:
		$1 = { 55 8B EC 83 7D 0C 00 74 23 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 83 C0 01 50 8B 4D 08 51 8B 55 08 03 55 0C 52 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_108_0_0 {
	meta:
		name = "__mbsnbcat_l"
		size = 648
		refs = "0027 ??_C@_1BI@GKKCBDMD@?$AAd?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0030 ??_C@_1BG@IFPKDLP@?$AAm?$AAb?$AAs?$AAn?$AAb?$AAc?$AAa?$AAt?$AA?4?$AAc?$AA?$AA@ 0037 __CrtDbgReportW 004b __errno 005f ??_C@_1BI@CBAIJIAM@?$AA_?$AAm?$AAb?$AAs?$AAn?$AAb?$AAc?$AAa?$AAt?$AA_?$AAl?$AA?$AA@ 0069 __invalid_parameter 008a ??_C@_1BI@DCHLDCPP@?$AAs?$AAr?$AAc?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 00e2 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 00ea ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0104 _strncat 0112 ??1_LocaleUpdate@@QAE@XZ 0162 __mbsbtype_l"
	strings:
		$1 = { 55 8B EC 83 EC 24 83 7D 10 00 75 08 8B 45 08 E9 70 02 00 00 33 C0 83 7D 08 00 0F 95 C0 89 45 E8 83 7D E8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 39 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E8 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 39 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 0D 02 00 00 33 D2 83 7D 0C 00 0F 95 C2 89 55 E4 83 7D E4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3A 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E4 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 3A 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 AA 01 00 00 8B 4D 14 51 8D 4D EC E8 ?? ?? ?? ?? 8D 4D EC E8 ?? ?? ?? ?? 8B 50 04 83 7A 08 00 75 27 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 89 45 E0 8D 4D EC E8 ?? ?? ?? ?? 8B 45 E0 E9 66 01 00 00 8B 45 08 89 45 FC 8B 4D 08 0F B6 11 8B 45 08 83 C0 01 89 45 08 85 D2 74 02 EB EB 8B 4D 08 83 E9 01 89 4D 08 8B 55 08 3B 55 FC 74 2D 8D 4D EC E8 ?? ?? ?? ?? 50 8B 45 08 2B 45 FC 83 E8 01 50 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 01 75 09 8B 55 08 83 EA 01 89 55 08 8B 45 10 8B 4D 10 83 E9 01 89 4D 10 85 C0 0F 84 AD 00 00 00 8D 4D EC E8 ?? ?? ?? ?? 8B 50 04 8B 45 0C 0F B6 08 0F B6 54 0A 1D 83 E2 04 74 65 8B 45 08 8B 4D 0C 8A 11 88 10 8B 45 08 83 C0 01 89 45 08 8B 4D 0C 83 C1 01 89 4D 0C 83 7D 10 00 75 09 8B 55 08 C6 42 FF 00 EB 67 8B 45 10 83 E8 01 89 45 10 8B 4D 08 8B 55 0C 8A 02 88 01 8B 4D 08 0F B6 11 8B 45 08 83 C0 01 89 45 08 8B 4D 0C 83 C1 01 89 4D 0C 85 D2 75 09 8B 55 08 C6 42 FE 00 EB 2F EB 28 8B 45 08 8B 4D 0C 8A 11 88 10 8B 45 08 0F B6 08 8B 55 08 83 C2 01 89 55 08 8B 45 0C 83 C0 01 89 45 0C 85 C9 75 02 EB 05 E9 3F FF FF FF 8B 4D 08 3B 4D FC 74 2D 8D 4D EC E8 ?? ?? ?? ?? 50 8B 55 08 2B 55 FC 83 EA 01 52 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 01 75 09 8B 4D 08 C6 41 FF 00 EB 06 8B 55 08 C6 02 00 8B 45 FC 89 45 DC 8D 4D EC E8 ?? ?? ?? ?? 8B 45 DC 8B E5 5D C3 }
	condition:
		$1
}

rule file_109_0_0 {
	meta:
		name = "__chvalidator"
		size = 66
		refs = "0011 ??_C@_1DC@BPLPALML@?$AA?$CI?$AAu?$AAn?$AAs?$AAi?$AAg?$AAn?$AAe?$AAd?$AA?$CJ?$AA?$CI?$AAc?$AA?5?$AA?$CL?$AA?5?$AA1?$AA?$CJ?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AA2?$AA5?$AA6?$AA?$AA@ 001a ??_C@_1BE@CEKCJJBD@?$AAi?$AAs?$AAc?$AAt?$AAy?$AAp?$AAe?$AA?4?$AAc?$AA?$AA@ 0021 __CrtDbgReportW 0039 __chvalidator_l"
	strings:
		$1 = { 55 8B EC 8B 45 08 83 C0 01 3D 00 01 00 00 76 1E 68 ?? ?? ?? ?? 6A 00 6A 38 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 8B 55 0C 52 8B 45 08 50 6A 00 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_109_1_0 {
	meta:
		name = "__chvalidator_l"
		size = 172
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0021 ??_C@_1DC@BPLPALML@?$AA?$CI?$AAu?$AAn?$AAs?$AAi?$AAg?$AAn?$AAe?$AAd?$AA?$CJ?$AA?$CI?$AAc?$AA?5?$AA?$CL?$AA?5?$AA1?$AA?$CJ?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AA2?$AA5?$AA6?$AA?$AA@ 002a ??_C@_1BE@CEKCJJBD@?$AAi?$AAs?$AAc?$AAt?$AAy?$AAp?$AAe?$AA?4?$AAc?$AA?$AA@ 0031 __CrtDbgReportW 0051 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 006e ??1_LocaleUpdate@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 83 EC 18 8B 45 08 50 8D 4D F0 E8 ?? ?? ?? ?? 8B 4D 0C 83 C1 01 81 F9 00 01 00 00 76 1E 68 ?? ?? ?? ?? 6A 00 6A 44 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D 0C FF 7C 35 81 7D 0C FF 00 00 00 7F 2C 8D 4D F0 E8 ?? ?? ?? ?? 8B 00 8B 88 C8 00 00 00 8B 55 0C 0F B7 04 51 23 45 10 89 45 EC 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 EC EB 31 EB 27 8D 4D F0 E8 ?? ?? ?? ?? 8B 08 8B 91 C8 00 00 00 0F B7 42 FE 23 45 10 89 45 E8 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 E8 EB 08 8D 4D F0 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_109_5_0 {
	meta:
		name = "__isctype_l"
		size = 272
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0025 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0042 ??1_LocaleUpdate@@QAE@XZ 0065 __isleadbyte_l 00d8 ___crtGetStringTypeA"
	strings:
		$1 = { 55 8B EC 83 EC 28 8B 45 10 50 8D 4D E8 E8 ?? ?? ?? ?? 83 7D 08 FF 7C 36 81 7D 08 FF 00 00 00 7F 2D 8D 4D E8 E8 ?? ?? ?? ?? 8B 08 8B 91 C8 00 00 00 8B 45 08 0F B7 0C 42 23 4D 0C 89 4D E0 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 E0 E9 BE 00 00 00 8D 4D E8 E8 ?? ?? ?? ?? 50 8B 55 08 C1 FA 08 81 E2 FF 00 00 00 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 21 8B 45 08 C1 F8 08 25 FF 00 00 00 88 45 E4 8A 4D 08 88 4D E5 C6 45 E6 00 C7 45 F8 02 00 00 00 EB 11 8A 55 08 88 55 E4 C6 45 E5 00 C7 45 F8 01 00 00 00 6A 01 8D 4D E8 E8 ?? ?? ?? ?? 8B 00 8B 48 14 51 8D 4D E8 E8 ?? ?? ?? ?? 8B 10 8B 42 04 50 8D 4D FC 51 8B 55 F8 52 8D 45 E4 50 6A 01 8D 4D E8 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 20 85 C0 75 14 C7 45 DC 00 00 00 00 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 DC EB 15 0F B7 4D FC 23 4D 0C 89 4D D8 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 D8 8B E5 5D C3 }
	condition:
		$1
}

rule file_109_6_0 {
	meta:
		name = "__isctype"
		size = 52
		refs = "0005 ___locale_changed 0011 ___initiallocinfo 002b __isctype_l"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? 00 75 14 8B 45 08 8B 0D ?? ?? ?? ?? 0F B7 04 41 23 45 0C EB 14 EB 12 6A 00 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_110_0_0 {
	meta:
		name = "__ftime64_s"
		size = 510
		refs = "000a ___security_cookie 0033 ??_C@_1BO@BCOPJGHK@?$AA?$CI?$AA?5?$AAt?$AAp?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CJ?$AA?$AA@ 003c ??_C@_1BE@IGHOLOJE@?$AAf?$AAt?$AAi?$AAm?$AAe?$AA6?$AA4?$AA?4?$AAc?$AA?$AA@ 0043 __CrtDbgReportW 005a __errno 006e ??_C@_1BG@OMGGMME@?$AA_?$AAf?$AAt?$AAi?$AAm?$AAe?$AA6?$AA4?$AA_?$AAs?$AA?$AA@ 0078 __invalid_parameter 008a ___tzset 009d ??_C@_1DC@CMKCHHFC@?$AA_?$AAg?$AAe?$AAt?$AA_?$AAt?$AAi?$AAm?$AAe?$AAz?$AAo?$AAn?$AAe?$AA?$CI?$AA?$CG?$AAt?$AAi?$AAm?$AAe?$AAz?$AAo?$AAn?$AAe?$AA?$CJ?$AA?$AA@ 00a6 __get_timezone 00af __invoke_watson_if_error 00d1 __imp__GetSystemTimeAsFileTime@4 00eb __aulldiv 0103 _elapsed_minutes_cache 0120 __imp__GetTimeZoneInformation@4 014c _dstflag_cache 01b6 __aullrem 01f6 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC D0 00 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 F8 C7 45 FC 00 00 00 00 33 C0 83 7D 08 00 0F 95 C0 89 85 30 FF FF FF 83 BD 30 FF FF FF 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 4E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 30 FF FF FF 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 4E 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 67 01 00 00 E8 ?? ?? ?? ?? 6A 00 6A 52 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 50 E8 ?? ?? ?? ?? 83 C4 18 8B 45 FC 99 B9 3C 00 00 00 F7 F9 8B 55 08 66 89 42 0A 8D 85 40 FF FF FF 50 FF 15 ?? ?? ?? ?? 6A 00 68 00 46 C3 23 8B 8D 44 FF FF FF 51 8B 95 40 FF FF FF 52 E8 ?? ?? ?? ?? 89 85 38 FF FF FF 89 95 3C FF FF FF 8B 85 38 FF FF FF 3B 05 ?? ?? ?? ?? 75 0E 8B 8D 3C FF FF FF 3B 0D ?? ?? ?? ?? 74 6D 8D 95 48 FF FF FF 52 FF 15 ?? ?? ?? ?? 89 85 34 FF FF FF 83 BD 34 FF FF FF FF 74 2F 83 BD 34 FF FF FF 02 75 1A 0F B7 45 E2 85 C0 74 12 83 7D F0 00 74 0C C7 05 ?? ?? ?? ?? 01 00 00 00 EB 0A C7 05 ?? ?? ?? ?? 00 00 00 00 EB 0A C7 05 ?? ?? ?? ?? FF FF FF FF 8B 8D 38 FF FF FF 89 0D ?? ?? ?? ?? 8B 95 3C FF FF FF 89 15 ?? ?? ?? ?? 8B 45 08 66 8B 0D ?? ?? ?? ?? 66 89 48 0C 6A 00 68 10 27 00 00 8B 95 44 FF FF FF 52 8B 85 40 FF FF FF 50 E8 ?? ?? ?? ?? 6A 00 68 E8 03 00 00 52 50 E8 ?? ?? ?? ?? 8B 4D 08 66 89 41 08 8B 95 40 FF FF FF 81 EA 00 80 3E D5 8B 85 44 FF FF FF 1D DE B1 9D 01 6A 00 68 80 96 98 00 50 52 E8 ?? ?? ?? ?? 8B 4D 08 89 01 89 51 04 33 C0 8B 4D F8 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_113_0_0 {
	meta:
		name = "__set_output_format"
		size = 126
		refs = "0007 __outputformat 0021 ??_C@_1EM@EGEEBJLG@?$AA?$CI?$AAo?$AAp?$AAt?$AAi?$AAo?$AAn?$AAs?$AA?5?$AA?$CG?$AA?5?$AA?$HO?$AA_?$AAT?$AAW?$AAO?$AA_?$AAD?$AAI?$AAG?$AAI?$AAT?$AA_?$AAE?$AAX?$AAP?$AAO?$AAN?$AAE?$AAN?$AAT?$AA?$CJ@ 002a ??_C@_1BO@GAIJFBKM@?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?4?$AAc?$AA?$AA@ 0031 __CrtDbgReportW 0045 __errno 0059 ??_C@_1CG@EBJECAJM@?$AA_?$AAs?$AAe?$AAt?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?$AA@ 0063 __invalid_parameter"
	strings:
		$1 = { 55 8B EC 83 EC 08 A1 ?? ?? ?? ?? 89 45 FC 8B 4D 08 83 E1 FE F7 D9 1B C9 83 C1 01 89 4D F8 75 1E 68 ?? ?? ?? ?? 6A 00 6A 2A 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F8 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 2A 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 8B 45 FC EB 0B 8B 45 08 A3 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_114_0_0 {
	meta:
		name = "__mbsnbcpy_s_l"
		size = 1651
		refs = "0052 ??_C@_1FC@NCPEPIBI@?$AA?$CI?$AA?$CI?$AA_?$AAD?$AAs?$AAt?$AA?$CJ?$AA?$CJ?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?$CI?$AA_?$AAS?$AAi?$AAz?$AAe?$AAI?$AAn?$AAB?$AAy?$AAt@ 005b ??_C@_1GM@DGPOPJNC@?$AAF?$AA?3?$AA?2?$AAR?$AAT?$AAM?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAS?$AAE?$AAL?$AAF?$AA_?$AAX?$AA8?$AA6?$AA?2@ 0062 __CrtDbgReportW 0076 __errno 008a ??_C@_1BM@HBMHMBEM@?$AA_?$AAm?$AAb?$AAs?$AAn?$AAb?$AAc?$AAp?$AAy?$AA_?$AAs?$AA_?$AAl?$AA?$AA@ 0094 __invalid_parameter 00ce ___crtDebugFillThreshold 00f9 _memset 0179 ??_C@_1CG@OFBJMIGJ@?$AA?$CI?$AA?$CI?$AA?$CI?$AA_?$AAS?$AAr?$AAc?$AA?$CJ?$AA?$CJ?$AA?$CJ?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 01d4 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 01dc ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 01fa _strncpy_s 0208 ??1_LocaleUpdate@@QAE@XZ 025f __CrtGetCheckCount 0270 ??_C@_1CI@HCPHDDLE@?$AAB?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AAi?$AAs?$AA?5?$AAt?$AAo?$AAo?$AA?5?$AAs?$AAm?$AAa?$AAl?$AAl?$AA?$AA@ 0333 __ismbblead_l 04e2 ??_C@_1DM@MADKGDLO@?$AA?$CI?$AAL?$AA?$CC?$AAB?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AAi?$AAs?$AA?5?$AAt?$AAo?$AAo?$AA?5?$AAs?$AAm?$AAa?$AAl?$AAl?$AA?$CC?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA0?$AA?$CJ?$AA?$AA@"
	strings:
		$1 = { 55 8B EC 81 EC 84 00 00 00 C7 45 E8 00 00 00 00 83 7D 14 00 75 13 83 7D 08 00 75 0D 83 7D 0C 00 75 07 33 C0 E9 46 06 00 00 83 7D 08 00 74 0F 83 7D 0C 00 76 09 C7 45 90 01 00 00 00 EB 07 C7 45 90 00 00 00 00 8B 45 90 89 45 DC 83 7D DC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 23 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D DC 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 CA 05 00 00 83 7D 14 00 75 5C 8B 55 08 C6 02 00 83 7D 0C FF 74 49 81 7D 0C FF FF FF 7F 74 40 83 7D 0C 01 76 3A 8B 45 0C 83 E8 01 39 05 ?? ?? ?? ?? 73 0B 8B 0D ?? ?? ?? ?? 89 4D 8C EB 09 8B 55 0C 83 EA 01 89 55 8C 8B 45 8C 50 68 FD 00 00 00 8B 4D 08 83 C1 01 51 E8 ?? ?? ?? ?? 83 C4 0C 33 C0 E9 68 05 00 00 83 7D 10 00 0F 85 BB 00 00 00 8B 55 08 C6 02 00 83 7D 0C FF 74 49 81 7D 0C FF FF FF 7F 74 40 83 7D 0C 01 76 3A 8B 45 0C 83 E8 01 39 05 ?? ?? ?? ?? 73 0B 8B 0D ?? ?? ?? ?? 89 4D 88 EB 09 8B 55 0C 83 EA 01 89 55 88 8B 45 88 50 68 FD 00 00 00 8B 4D 08 83 C1 01 51 E8 ?? ?? ?? ?? 83 C4 0C 33 D2 83 7D 10 00 0F 95 C2 89 55 D8 83 7D D8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 2A 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D8 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 2A 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 A3 04 00 00 8B 4D 18 51 8D 4D EC E8 ?? ?? ?? ?? 8D 4D EC E8 ?? ?? ?? ?? 8B 50 04 83 7A 08 00 75 2B 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 AC 8D 4D EC E8 ?? ?? ?? ?? 8B 45 AC E9 5B 04 00 00 8B 4D 08 89 4D FC 8B 55 0C 89 55 E4 83 7D 14 FF 75 38 8B 45 FC 8B 4D 10 8A 11 88 10 8B 45 FC 0F B6 08 8B 55 FC 83 C2 01 89 55 FC 8B 45 10 83 C0 01 89 45 10 85 C9 74 0D 8B 4D E4 83 E9 01 89 4D E4 74 02 EB CD E9 82 00 00 00 E8 ?? ?? ?? ?? 85 C0 74 26 8B 55 14 3B 55 0C 72 1E 68 ?? ?? ?? ?? 6A 00 6A 44 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 8B 4D FC 8B 55 10 8A 02 88 01 8B 4D FC 0F B6 11 8B 45 FC 83 C0 01 89 45 FC 8B 4D 10 83 C1 01 89 4D 10 85 D2 74 18 8B 55 E4 83 EA 01 89 55 E4 74 0D 8B 45 14 83 E8 01 89 45 14 74 02 EB C2 83 7D 14 00 75 0F 8B 4D FC C6 01 00 8B 55 FC 83 C2 01 89 55 FC 83 7D E4 00 0F 85 5E 02 00 00 8B 45 10 0F B6 08 85 C9 74 0A 83 7D 14 01 0F 85 88 00 00 00 C7 45 E0 00 00 00 00 8B 55 08 89 55 D0 8B 45 FC 83 E8 01 89 45 D4 8B 4D D4 89 4D CC 8B 55 CC 3B 55 D0 72 27 8D 4D EC E8 ?? ?? ?? ?? 50 8B 45 CC 0F B6 08 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 0B 8B 55 CC 83 EA 01 89 55 CC EB D1 8B 45 D4 2B 45 CC 83 E0 01 F7 D8 1B C0 F7 D8 89 45 E0 74 29 8B 4D FC C6 41 FF 00 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 C7 45 A8 2A 00 00 00 8D 4D EC E8 ?? ?? ?? ?? 8B 45 A8 E9 E9 02 00 00 83 7D 14 FF 0F 85 D3 00 00 00 83 7D E8 00 74 0B E8 ?? ?? ?? ?? C7 00 2A 00 00 00 83 7D 0C 01 0F 86 97 00 00 00 C7 45 E0 00 00 00 00 8B 55 08 89 55 C4 8B 45 0C 8B 4D 08 8D 54 01 FE 89 55 C8 8B 45 C8 89 45 C0 8B 4D C0 3B 4D C4 72 27 8D 4D EC E8 ?? ?? ?? ?? 50 8B 55 C0 0F B6 02 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 0B 8B 4D C0 83 E9 01 89 4D C0 EB D1 8B 55 C8 2B 55 C0 83 E2 01 F7 DA 1B D2 F7 DA 89 55 E0 74 34 8B 45 08 03 45 0C C6 40 FE 00 83 3D ?? ?? ?? ?? 00 76 0A 8B 4D 08 03 4D 0C C6 41 FF FD C7 45 A4 50 00 00 00 8D 4D EC E8 ?? ?? ?? ?? 8B 45 A4 E9 2D 02 00 00 8B 55 08 03 55 0C C6 42 FF 00 C7 45 A0 50 00 00 00 8D 4D EC E8 ?? ?? ?? ?? 8B 45 A0 E9 0C 02 00 00 8B 45 08 C6 00 00 83 7D 0C FF 74 49 81 7D 0C FF FF FF 7F 74 40 83 7D 0C 01 76 3A 8B 4D 0C 83 E9 01 39 0D ?? ?? ?? ?? 73 0B 8B 15 ?? ?? ?? ?? 89 55 84 EB 09 8B 45 0C 83 E8 01 89 45 84 8B 4D 84 51 68 FD 00 00 00 8B 55 08 83 C2 01 52 E8 ?? ?? ?? ?? 83 C4 0C B8 ?? ?? ?? ?? 85 C0 74 0D 33 C9 74 09 C7 45 80 01 00 00 00 EB 07 C7 45 80 00 00 00 00 8B 55 80 89 55 BC 83 7D BC 00 75 21 68 ?? ?? ?? ?? 6A 00 68 B6 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D BC 00 75 40 E8 ?? ?? ?? ?? C7 00 22 00 00 00 6A 00 68 B6 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 9C 22 00 00 00 8D 4D EC E8 ?? ?? ?? ?? 8B 45 9C E9 27 01 00 00 8B 4D FC 2B 4D 08 83 F9 02 7C 6F 8B 55 08 89 55 B4 8B 45 FC 83 E8 02 89 45 B8 8B 4D B8 89 4D B0 8B 55 B0 3B 55 B4 72 27 8D 4D EC E8 ?? ?? ?? ?? 50 8B 45 B0 0F B6 08 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 0B 8B 55 B0 83 EA 01 89 55 B0 EB D1 8B 45 B8 2B 45 B0 83 E0 01 F7 D8 1B C0 F7 D8 89 45 E0 74 17 8B 4D FC C6 41 FE 00 8B 55 E4 83 C2 01 89 55 E4 C7 45 E8 01 00 00 00 83 7D 0C FF 74 70 81 7D 0C FF FF FF 7F 74 67 8B 45 0C 2B 45 E4 83 C0 01 3B 45 0C 73 59 8B 4D 0C 2B 4D E4 83 C1 01 8B 55 0C 2B D1 39 15 ?? ?? ?? ?? 73 0D A1 ?? ?? ?? ?? 89 85 7C FF FF FF EB 14 8B 4D 0C 2B 4D E4 83 C1 01 8B 55 0C 2B D1 89 95 7C FF FF FF 8B 85 7C FF FF FF 50 68 FD 00 00 00 8B 4D 0C 2B 4D E4 8B 55 08 8D 44 0A 01 50 E8 ?? ?? ?? ?? 83 C4 0C 83 7D E8 00 74 1F E8 ?? ?? ?? ?? C7 00 2A 00 00 00 C7 45 98 2A 00 00 00 8D 4D EC E8 ?? ?? ?? ?? 8B 45 98 EB 12 C7 45 94 00 00 00 00 8D 4D EC E8 ?? ?? ?? ?? 8B 45 94 8B E5 5D C3 }
	condition:
		$1
}

rule file_116_0_0 {
	meta:
		name = "__itoa_s"
		size = 84
		refs = "002a _xtoa_s@20"
	strings:
		$1 = { 55 8B EC 51 C7 45 FC 00 00 00 00 83 7D 14 0A 75 22 83 7D 08 00 7D 1C 6A 01 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 89 45 FC EB 1A 6A 00 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 89 45 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_224_0_0 {
	meta:
		name = "__itow_s"
		size = 84
		refs = "002a _xtow_s@20"
	strings:
		$1 = { 55 8B EC 51 C7 45 FC 00 00 00 00 83 7D 14 0A 75 22 83 7D 08 00 7D 1C 6A 01 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 89 45 FC EB 1A 6A 00 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 89 45 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_116_1_0 {
	meta:
		name = "_xtoa_s@20"
		size = 864
		refs = "0019 ??_C@_1BI@ICGGMGLK@?$AAb?$AAu?$AAf?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0022 ??_C@_1FO@FKHEBPLJ@?$AAf?$AA?3?$AA?2?$AAr?$AAt?$AAm?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2@ 0029 __CrtDbgReportW 003d __errno 0051 ??_C@_1O@GIMBNLEI@?$AAx?$AAt?$AAo?$AAa?$AA_?$AAs?$AA?$AA@ 005b __invalid_parameter 007b ??_C@_1CC@JNJFIMGE@?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAT?$AAC?$AAh?$AAa?$AAr?$AAs?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 00f1 ___crtDebugFillThreshold 011c _memset 013c ??_C@_1FA@MKGGAGEI@?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAT?$AAC?$AAh?$AAa?$AAr?$AAs?$AA?5?$AA?$DO?$AA?5?$AA?$CI?$AAs?$AAi?$AAz?$AAe?$AA_?$AAt?$AA?$CJ?$AA?$CI?$AAi?$AAs?$AA_?$AAn?$AAe?$AAg?$AA?5?$AA?$DP@ 01b8 ??_C@_1DE@PCJGDBBD@?$AA2?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAr?$AAa?$AAd?$AAi?$AAx?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAr?$AAa?$AAd?$AAi?$AAx?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AA3?$AA6?$AA?$AA@ 02bf ??_C@_1CM@HABGDNLJ@?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA?5?$AA?$DM?$AA?5?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAT?$AAC?$AAh?$AAa?$AAr?$AAs?$AA?$AA@"
	strings:
		$1 = { 55 8B EC 83 EC 30 33 C0 83 7D 0C 00 0F 95 C0 89 45 E8 83 7D E8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 66 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E8 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 66 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 EE 02 00 00 33 D2 3B 55 10 1B C0 F7 D8 89 45 E4 75 1E 68 ?? ?? ?? ?? 6A 00 6A 67 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E4 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 67 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 8C 02 00 00 8B 55 0C C6 02 00 83 7D 10 FF 74 49 81 7D 10 FF FF FF 7F 74 40 83 7D 10 01 76 3A 8B 45 10 83 E8 01 39 05 ?? ?? ?? ?? 73 0B 8B 0D ?? ?? ?? ?? 89 4D D4 EB 09 8B 55 10 83 EA 01 89 55 D4 8B 45 D4 50 68 FD 00 00 00 8B 4D 0C 83 C1 01 51 E8 ?? ?? ?? ?? 83 C4 0C 33 D2 83 7D 18 00 0F 95 C2 83 C2 01 3B 55 10 1B C0 F7 D8 89 45 E0 75 1E 68 ?? ?? ?? ?? 6A 00 6A 69 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 30 E8 ?? ?? ?? ?? C7 00 22 00 00 00 6A 00 6A 69 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 22 00 00 00 E9 CB 01 00 00 83 7D 14 02 72 0F 83 7D 14 24 77 09 C7 45 D0 01 00 00 00 EB 07 C7 45 D0 00 00 00 00 8B 55 D0 89 55 DC 83 7D DC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 6A 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D DC 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 6A 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 4F 01 00 00 C7 45 F8 00 00 00 00 8B 4D 0C 89 4D FC 83 7D 18 00 74 20 8B 55 FC C6 02 2D 8B 45 FC 83 C0 01 89 45 FC 8B 4D F8 83 C1 01 89 4D F8 8B 55 08 F7 DA 89 55 08 8B 45 FC 89 45 EC 8B 45 08 33 D2 F7 75 14 89 55 F4 8B 45 08 33 D2 F7 75 14 89 45 08 83 7D F4 09 76 16 8B 4D F4 83 C1 57 8B 55 FC 88 0A 8B 45 FC 83 C0 01 89 45 FC EB 14 8B 4D F4 83 C1 30 8B 55 FC 88 0A 8B 45 FC 83 C0 01 89 45 FC 8B 4D F8 83 C1 01 89 4D F8 83 7D 08 00 76 08 8B 55 F8 3B 55 10 72 A3 8B 45 F8 3B 45 10 72 6C 8B 4D 0C C6 01 00 8B 55 F8 3B 55 10 1B C0 F7 D8 89 45 D8 75 21 68 ?? ?? ?? ?? 6A 00 68 8E 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D8 00 75 30 E8 ?? ?? ?? ?? C7 00 22 00 00 00 6A 00 68 8E 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 22 00 00 00 EB 45 8B 55 FC C6 02 00 8B 45 FC 83 E8 01 89 45 FC 8B 4D FC 8A 11 88 55 F3 8B 45 FC 8B 4D EC 8A 11 88 10 8B 45 EC 8A 4D F3 88 08 8B 55 FC 83 EA 01 89 55 FC 8B 45 EC 83 C0 01 89 45 EC 8B 4D EC 3B 4D FC 72 CC 33 C0 8B E5 5D C2 14 00 }
	condition:
		$1
}

rule file_116_2_0 {
	meta:
		name = "__ltoa_s"
		size = 61
		refs = "0035 _xtoa_s@20"
	strings:
		$1 = { 55 8B EC 51 83 7D 14 0A 75 0F 83 7D 08 00 7D 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 45 FC 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_224_2_0 {
	meta:
		name = "__ltow_s"
		size = 61
		refs = "0035 _xtow_s@20"
	strings:
		$1 = { 55 8B EC 51 83 7D 14 0A 75 0F 83 7D 08 00 7D 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 45 FC 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_116_3_0 {
	meta:
		name = "__ultoa_s"
		size = 28
		refs = "0016 _xtoa_s@20"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_224_3_0 {
	meta:
		name = "__ultow_s"
		size = 28
		refs = "0016 _xtow_s@20"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_116_4_0 {
	meta:
		name = "__i64toa_s"
		size = 71
		refs = "003f @x64toa_s@24"
	strings:
		$1 = { 55 8B EC 51 83 7D 18 0A 75 17 83 7D 0C 00 7F 11 7C 06 83 7D 08 00 73 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 45 FC 50 8B 4D 18 51 8B 55 0C 52 8B 45 08 50 8B 55 14 8B 4D 10 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_224_4_0 {
	meta:
		name = "__i64tow_s"
		size = 71
		refs = "003f @x64tow_s@24"
	strings:
		$1 = { 55 8B EC 51 83 7D 18 0A 75 17 83 7D 0C 00 7F 11 7C 06 83 7D 08 00 73 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 45 FC 50 8B 4D 18 51 8B 55 0C 52 8B 45 08 50 8B 55 14 8B 4D 10 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_116_5_0 {
	meta:
		name = "@x64toa_s@24"
		size = 938
		refs = "001f ??_C@_1BI@ICGGMGLK@?$AAb?$AAu?$AAf?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 002b ??_C@_1FO@FKHEBPLJ@?$AAf?$AA?3?$AA?2?$AAr?$AAt?$AAm?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2@ 0032 __CrtDbgReportW 0046 __errno 005d ??_C@_1BC@MJJNBNFN@?$AAx?$AA6?$AA4?$AAt?$AAo?$AAa?$AA_?$AAs?$AA?$AA@ 0067 __invalid_parameter 0087 ??_C@_1CC@JNJFIMGE@?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAT?$AAC?$AAh?$AAa?$AAr?$AAs?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 0103 ___crtDebugFillThreshold 012e _memset 014e ??_C@_1FA@MKGGAGEI@?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAT?$AAC?$AAh?$AAa?$AAr?$AAs?$AA?5?$AA?$DO?$AA?5?$AA?$CI?$AAs?$AAi?$AAz?$AAe?$AA_?$AAt?$AA?$CJ?$AA?$CI?$AAi?$AAs?$AA_?$AAn?$AAe?$AAg?$AA?5?$AA?$DP@ 01d0 ??_C@_1DE@PCJGDBBD@?$AA2?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAr?$AAa?$AAd?$AAi?$AAx?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAr?$AAa?$AAd?$AAi?$AAx?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AA3?$AA6?$AA?$AA@ 027d __aullrem 0294 __aulldiv 0309 ??_C@_1CM@HABGDNLJ@?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA?5?$AA?$DM?$AA?5?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAT?$AAC?$AAh?$AAa?$AAr?$AAs?$AA?$AA@"
	strings:
		$1 = { 55 8B EC 83 EC 38 89 55 D0 89 4D D4 33 C0 83 7D D4 00 0F 95 C0 89 45 E8 83 7D E8 00 75 21 68 ?? ?? ?? ?? 6A 00 68 3E 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E8 00 75 33 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 3E 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 2C 03 00 00 33 D2 3B 55 D0 1B C0 F7 D8 89 45 E4 75 21 68 ?? ?? ?? ?? 6A 00 68 3F 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E4 00 75 33 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 3F 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 C4 02 00 00 8B 55 D4 C6 02 00 83 7D D0 FF 74 49 81 7D D0 FF FF FF 7F 74 40 83 7D D0 01 76 3A 8B 45 D0 83 E8 01 39 05 ?? ?? ?? ?? 73 0B 8B 0D ?? ?? ?? ?? 89 4D CC EB 09 8B 55 D0 83 EA 01 89 55 CC 8B 45 CC 50 68 FD 00 00 00 8B 4D D4 83 C1 01 51 E8 ?? ?? ?? ?? 83 C4 0C 33 D2 83 7D 14 00 0F 95 C2 83 C2 01 3B 55 D0 1B C0 F7 D8 89 45 E0 75 21 68 ?? ?? ?? ?? 6A 00 68 41 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 33 E8 ?? ?? ?? ?? C7 00 22 00 00 00 6A 00 68 41 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 22 00 00 00 E9 FD 01 00 00 83 7D 10 02 72 0F 83 7D 10 24 77 09 C7 45 C8 01 00 00 00 EB 07 C7 45 C8 00 00 00 00 8B 55 C8 89 55 DC 83 7D DC 00 75 21 68 ?? ?? ?? ?? 6A 00 68 42 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D DC 00 75 33 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 42 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 7B 01 00 00 C7 45 F8 00 00 00 00 8B 4D D4 89 4D FC 83 7D 14 00 74 2B 8B 55 FC C6 02 2D 8B 45 FC 83 C0 01 89 45 FC 8B 4D F8 83 C1 01 89 4D F8 8B 55 08 F7 DA 8B 45 0C 83 D0 00 F7 D8 89 55 08 89 45 0C 8B 4D FC 89 4D EC 8B 55 10 33 C0 50 52 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 89 45 F4 8B 45 10 33 C9 51 50 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 89 45 08 89 55 0C 83 7D F4 09 76 16 8B 4D F4 83 C1 57 8B 55 FC 88 0A 8B 45 FC 83 C0 01 89 45 FC EB 14 8B 4D F4 83 C1 30 8B 55 FC 88 0A 8B 45 FC 83 C0 01 89 45 FC 8B 4D F8 83 C1 01 89 4D F8 83 7D 0C 00 77 06 83 7D 08 00 76 08 8B 55 F8 3B 55 D0 72 82 8B 45 F8 3B 45 D0 72 6C 8B 4D D4 C6 01 00 8B 55 F8 3B 55 D0 1B C0 F7 D8 89 45 D8 75 21 68 ?? ?? ?? ?? 6A 00 68 66 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D8 00 75 30 E8 ?? ?? ?? ?? C7 00 22 00 00 00 6A 00 68 66 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 22 00 00 00 EB 45 8B 55 FC C6 02 00 8B 45 FC 83 E8 01 89 45 FC 8B 4D FC 8A 11 88 55 F3 8B 45 FC 8B 4D EC 8A 11 88 10 8B 45 EC 8A 4D F3 88 08 8B 55 FC 83 EA 01 89 55 FC 8B 45 EC 83 C0 01 89 45 EC 8B 4D EC 3B 4D FC 72 CC 33 C0 8B E5 5D C2 10 00 }
	condition:
		$1
}

rule file_116_6_0 {
	meta:
		name = "__ui64toa_s"
		size = 30
		refs = "0018 @x64toa_s@24"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 18 50 8B 4D 0C 51 8B 55 08 52 8B 55 14 8B 4D 10 E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_224_6_0 {
	meta:
		name = "__ui64tow_s"
		size = 30
		refs = "0018 @x64tow_s@24"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 18 50 8B 4D 0C 51 8B 55 08 52 8B 55 14 8B 4D 10 E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_119_0_0 {
	meta:
		name = "__eof"
		size = 657
		refs = "0006 __sehtable$__eof 000b __except_handler4 001d ___security_cookie 0037 ___doserrno 0042 __errno 005f __nhandle 0082 ??_C@_1HC@KFLBHHBC@?$AA?$CI?$AAf?$AAi?$AAl?$AAe?$AAd?$AAe?$AAs?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AAu?$AAn?$AAs?$AAi?$AAg?$AAn?$AAe?$AAd?$AA?$CJ?$AAf?$AAi?$AAl?$AAe?$AAd@ 008b ??_C@_1M@BGIGOIOC@?$AAe?$AAo?$AAf?$AA?4?$AAc?$AA?$AA@ 0092 __CrtDbgReportW 00c5 ??_C@_19CLIOPBMD@?$AA_?$AAe?$AAo?$AAf?$AA?$AA@ 00cf __invalid_parameter 00f0 ___pioinfo 0108 ??_C@_1DG@LNNHNFHJ@?$AA?$CI?$AA_?$AAo?$AAs?$AAf?$AAi?$AAl?$AAe?$AA?$CI?$AAf?$AAi?$AAl?$AAe?$AAd?$AAe?$AAs?$AA?$CJ?$AA?5?$AA?$CG?$AA?5?$AAF?$AAO?$AAP?$AAE?$AAN?$AA?$CJ?$AA?$AA@ 0169 ___lock_fhandle 01a6 __lseeki64_nolock 0244 ??_C@_1JE@ECKHFIFP@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAf?$AAi?$AAl?$AAe?$AA?5?$AAd?$AAe?$AAs?$AAc?$AAr?$AAi?$AAp?$AAt?$AAo?$AAr?$AA?4?$AA?5?$AAF?$AAi?$AAl?$AAe?$AA?5@ 0274 __unlock_fhandle"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 D4 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 83 7D 08 FE 75 1E E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 C8 FF E9 2B 02 00 00 83 7D 08 00 7C 14 8B 45 08 3B 05 ?? ?? ?? ?? 73 09 C7 45 C4 01 00 00 00 EB 07 C7 45 C4 00 00 00 00 8B 4D C4 89 4D CC 83 7D CC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 31 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D CC 00 75 39 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 6A 00 6A 31 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 A1 01 00 00 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F 6B C9 28 8B 14 85 ?? ?? ?? ?? 0F BE 44 0A 04 83 E0 01 F7 D8 1B C0 F7 D8 89 45 C8 75 1E 68 ?? ?? ?? ?? 6A 00 6A 32 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D C8 00 75 39 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 6A 00 6A 32 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 1B 01 00 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F 6B C9 28 8B 14 85 ?? ?? ?? ?? 0F BE 44 0A 04 83 E0 01 0F 84 87 00 00 00 6A 01 6A 00 6A 00 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 E0 89 55 E4 8B 55 E0 23 55 E4 83 FA FF 74 23 6A 02 6A 00 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 D0 89 55 D4 8B 4D D0 23 4D D4 83 F9 FF 75 09 C7 45 DC FF FF FF FF EB 36 8B 55 E0 3B 55 D0 75 11 8B 45 E4 3B 45 D4 75 09 C7 45 DC 01 00 00 00 EB 1D 6A 00 8B 4D E4 51 8B 55 E0 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 C7 45 DC 00 00 00 00 EB 3F E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? C7 00 00 00 00 00 C7 45 DC FF FF FF FF 33 C9 75 1E 68 ?? ?? ?? ?? 6A 00 6A 4D 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0D 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 DC 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_120_0_0 {
	meta:
		name = "__wexecle"
		size = 453
		refs = "001f ??_C@_1CC@JBMDNKJP@?$AAf?$AAi?$AAl?$AAe?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0028 ??_C@_1GC@LLNOAHML@?$AAf?$AA?3?$AA?2?$AAr?$AAt?$AAm?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2@ 002f __CrtDbgReportW 0043 __errno 0057 ??_C@_1BC@OIHGEFPM@?$AA_?$AAw?$AAe?$AAx?$AAe?$AAc?$AAl?$AAe?$AA?$AA@ 0061 __invalid_parameter 0082 ??_C@_1CM@DMCMCPME@?$AA?$CK?$AAf?$AAi?$AAl?$AAe?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 00e6 ??_C@_1CA@MOAFCHEI@?$AAa?$AAr?$AAg?$AAl?$AAi?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0149 ??_C@_1CK@PKCLGCC@?$AA?$CK?$AAa?$AAr?$AAg?$AAl?$AAi?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 01ba __wexecve"
	strings:
		$1 = { 55 8B EC 83 EC 14 8D 45 0C 89 45 FC 33 C9 83 7D 08 00 0F 95 C1 89 4D F8 83 7D F8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 34 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F8 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 34 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 51 01 00 00 8B 45 08 0F B7 08 F7 D9 1B C9 F7 D9 89 4D F4 75 1E 68 ?? ?? ?? ?? 6A 00 6A 35 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F4 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 35 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 EE 00 00 00 33 C0 83 7D 0C 00 0F 95 C0 89 45 F0 83 7D F0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 36 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 36 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 8A 00 00 00 8B 55 0C 0F B7 02 F7 D8 1B C0 F7 D8 89 45 EC 75 1E 68 ?? ?? ?? ?? 6A 00 6A 37 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D EC 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 37 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 2A 8B 55 FC 8B 02 8B 4D FC 83 C1 04 89 4D FC 85 C0 74 02 EB EC 8B 55 FC 8B 02 50 8D 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_121_0_0 {
	meta:
		name = "__ftol"
		size = 39
	strings:
		$1 = { 55 8B EC 83 C4 F4 9B D9 7D FE 9B 66 8B 45 FE 80 CC 0C 66 89 45 FC D9 6D FC DF 7D F4 D9 6D FE 8B 45 F4 8B 55 F8 C9 C3 }
	condition:
		$1
}

rule file_122_0_0 {
	meta:
		name = "__except_handler2"
		size = 174
		refs = "0057 __global_unwind2 0064 __local_unwind2"
	strings:
		$1 = { 55 8B EC 83 EC 08 53 56 57 55 FC 8B 5D 0C 8B 45 08 F7 40 04 06 00 00 00 75 77 89 45 F8 8B 45 10 89 45 FC 8D 45 F8 89 43 14 8B 73 0C 8B 7B 08 83 FE FF 74 56 8D 0C 76 83 7C 8F 04 00 74 3A 56 55 8B 6B 10 FF 54 8F 04 5D 5E 8B 5D 0C 0B C0 74 28 78 31 8B 7B 08 53 E8 ?? ?? ?? ?? 83 C4 04 8B 6B 10 56 53 E8 ?? ?? ?? ?? 83 C4 08 8D 0C 76 8B 04 8F 89 43 0C FF 54 8F 08 8B 7B 08 8D 0C 76 8B 34 8F EB AC B8 00 00 00 00 EB 1C B8 01 00 00 00 EB 15 55 8B 6B 10 6A FF 53 E8 ?? ?? ?? ?? 83 C4 08 5D B8 01 00 00 00 5D 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_123_0_0 {
	meta:
		name = "__mbbtombc_l"
		size = 237
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0016 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0030 ??1_LocaleUpdate@@QAE@XZ 004f _mbbtable 00ae _mbctable"
	strings:
		$1 = { 55 8B EC 83 EC 24 8B 45 0C 50 8D 4D EC E8 ?? ?? ?? ?? 8D 4D EC E8 ?? ?? ?? ?? 8B 48 04 81 79 04 A4 03 00 00 74 16 8B 55 08 89 55 E8 8D 4D EC E8 ?? ?? ?? ?? 8B 45 E8 E9 AD 00 00 00 83 7D 08 20 72 24 83 7D 08 7E 77 1E 8B 45 08 0F B7 0C 45 ?? ?? ?? ?? 89 4D E4 8D 4D EC E8 ?? ?? ?? ?? 8B 45 E4 E9 83 00 00 00 81 7D 08 DC 00 00 00 75 14 C7 45 E0 8F 83 00 00 8D 4D EC E8 ?? ?? ?? ?? 8B 45 E0 EB 66 81 7D 08 A1 00 00 00 72 4C 81 7D 08 DF 00 00 00 77 43 C7 45 FC 00 00 00 00 EB 09 8B 55 FC 83 C2 01 89 55 FC 8B 45 FC 0F B6 0C 85 ?? ?? ?? ?? 85 C9 74 22 8B 55 FC 0F B6 04 95 ?? ?? ?? ?? 39 45 08 75 10 8B 4D FC 0F B7 14 8D ?? ?? ?? ?? 89 55 08 EB 02 EB C6 8B 45 08 89 45 DC 8D 4D EC E8 ?? ?? ?? ?? 8B 45 DC 8B E5 5D C3 }
	condition:
		$1
}

rule file_123_5_0 {
	meta:
		name = "__mbctombb_l"
		size = 333
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0016 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0030 ??1_LocaleUpdate@@QAE@XZ 005b _mbbtable 00a5 _mbctable"
	strings:
		$1 = { 55 8B EC 83 EC 2C 8B 45 0C 50 8D 4D E8 E8 ?? ?? ?? ?? 8D 4D E8 E8 ?? ?? ?? ?? 8B 48 04 81 79 04 A4 03 00 00 74 16 8B 55 08 89 55 E4 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 E4 E9 0D 01 00 00 C7 45 FC 00 00 00 00 EB 09 8B 45 FC 83 C0 01 89 45 FC 83 7D FC 5E 7F 2B 8B 4D FC 0F B7 14 4D ?? ?? ?? ?? 39 55 08 75 19 8B 45 FC 83 C0 20 89 45 E0 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 E0 E9 CC 00 00 00 EB C6 81 7D 08 96 83 00 00 0F 87 AC 00 00 00 C7 45 FC 00 00 00 00 EB 09 8B 4D FC 83 C1 01 89 4D FC 8B 55 FC 0F B6 04 95 ?? ?? ?? ?? 85 C0 0F 84 87 00 00 00 8B 4D FC 0F B7 14 8D ?? ?? ?? ?? 8B 45 08 2B C2 89 45 F8 75 1D 8B 4D FC 0F B6 14 8D ?? ?? ?? ?? 89 55 DC 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 DC EB 68 EB 50 8B 45 08 25 00 FF 00 00 8B 4D FC 0F B7 14 8D ?? ?? ?? ?? 81 E2 00 FF 00 00 3B C2 75 33 83 7D F8 00 7E 2D 8B 45 FC 0F BE 0C 85 ?? ?? ?? ?? 8B 55 F8 2B D1 79 1B 8B 45 FC 0F B6 0C 85 ?? ?? ?? ?? 89 4D D8 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 D8 EB 16 E9 5D FF FF FF 8B 55 08 89 55 D4 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 D4 8B E5 5D C3 }
	condition:
		$1
}

rule file_124_0_0 {
	meta:
		name = "__towupper_l"
		size = 338
		refs = "0022 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 002a ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0067 ??1_LocaleUpdate@@QAE@XZ 0091 __iswctype_l 0119 ___crtLCMapStringW"
	strings:
		$1 = { 55 8B EC 83 EC 24 0F B7 45 08 3D FF FF 00 00 75 09 66 8B 45 08 E9 34 01 00 00 8B 4D 0C 51 8D 4D F0 E8 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? 8B 10 83 7A 14 00 75 3E 0F B7 45 08 83 F8 61 7C 15 0F B7 4D 08 83 F9 7A 7F 0C 0F B7 55 08 83 EA 20 89 55 DC EB 07 0F B7 45 08 89 45 DC 66 8B 4D DC 66 89 4D EA 8D 4D F0 E8 ?? ?? ?? ?? 66 8B 45 EA E9 DA 00 00 00 0F B7 55 08 81 FA 00 01 00 00 7D 62 8D 4D F0 E8 ?? ?? ?? ?? 50 6A 02 66 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 1B 66 8B 4D 08 66 89 4D E8 8D 4D F0 E8 ?? ?? ?? ?? 66 8B 45 E8 E9 99 00 00 00 EB 2B 8D 4D F0 E8 ?? ?? ?? ?? 8B 10 0F B7 45 08 8B 8A D0 00 00 00 66 0F B6 14 01 66 89 55 E6 8D 4D F0 E8 ?? ?? ?? ?? 66 8B 45 E6 EB 6C 8D 4D F0 E8 ?? ?? ?? ?? 8B 00 8B 48 04 51 6A 01 8D 55 EC 52 6A 01 8D 45 08 50 68 00 02 00 00 8D 4D F0 E8 ?? ?? ?? ?? 8B 08 8B 51 14 52 8D 4D F0 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 20 85 C0 75 16 66 8B 45 08 66 89 45 E4 8D 4D F0 E8 ?? ?? ?? ?? 66 8B 45 E4 EB 14 66 8B 4D EC 66 89 4D E2 8D 4D F0 E8 ?? ?? ?? ?? 66 8B 45 E2 8B E5 5D C3 }
	condition:
		$1
}

rule file_124_4_0 {
	meta:
		name = "_towupper"
		size = 20
		refs = "000b __towupper_l"
	strings:
		$1 = { 55 8B EC 6A 00 66 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_656_4_0 {
	meta:
		name = "_towlower"
		size = 20
		refs = "000b __towlower_l"
	strings:
		$1 = { 55 8B EC 6A 00 66 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_126_0_0 {
	meta:
		name = "_vfscanf"
		size = 695
		refs = "0006 __sehtable$_vfscanf 000b __except_handler4 001d ___security_cookie 004a ??_C@_1CC@FADMNIL@?$AA?$CI?$AAs?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0053 ??_C@_1BC@JCJGIEN@?$AAf?$AAs?$AAc?$AAa?$AAn?$AAf?$AA?4?$AAc?$AA?$AA@ 005a __CrtDbgReportW 006e __errno 0082 ??_C@_1BA@LCFKCAGP@?$AAv?$AAf?$AAs?$AAc?$AAa?$AAn?$AAf?$AA?$AA@ 008c __invalid_parameter 00ae ??_C@_1CC@MGIEJOME@?$AA?$CI?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0104 __lock_file 012c __fileno 016f ___pioinfo 017b ___badioinfo 0218 ??_C@_1BAE@CBLKKPB@?$AA?$CI?$AA?5?$AA?$CI?$AA_?$AAS?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?9?$AA?$DO?$AA_?$AAf?$AAl?$AAa?$AAg?$AA?5?$AA?$CG?$AA?5?$AA_?$AAI?$AAO?$AAS?$AAT?$AAR?$AAG?$AA?$CJ?$AA?5?$AA?$HM?$AA?$HM?$AA?5@ 029a __unlock_file"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 D8 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 C7 45 E4 00 00 00 00 33 C0 83 7D 0C 00 0F 95 C0 89 45 E0 83 7D E0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 34 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 34 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 0A 02 00 00 33 D2 83 7D 10 00 0F 95 C2 89 55 DC 83 7D DC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 35 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D DC 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 35 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 A6 01 00 00 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 55 0C 89 55 D8 8B 45 D8 8B 48 0C 83 E1 40 0F 85 DD 00 00 00 8B 55 D8 52 E8 ?? ?? ?? ?? 83 C4 04 83 F8 FF 74 40 8B 45 D8 50 E8 ?? ?? ?? ?? 83 C4 04 83 F8 FE 74 2F 8B 4D D8 51 E8 ?? ?? ?? ?? 83 C4 04 8B F0 C1 FE 05 8B 55 D8 52 E8 ?? ?? ?? ?? 83 C4 04 83 E0 1F 6B C0 28 03 04 B5 ?? ?? ?? ?? 89 45 D0 EB 07 C7 45 D0 ?? ?? ?? ?? 8B 45 D0 8A 48 24 D0 E1 D0 F9 0F BE D1 85 D2 75 6B 8B 45 D8 50 E8 ?? ?? ?? ?? 83 C4 04 83 F8 FF 74 40 8B 4D D8 51 E8 ?? ?? ?? ?? 83 C4 04 83 F8 FE 74 2F 8B 55 D8 52 E8 ?? ?? ?? ?? 83 C4 04 8B F0 C1 FE 05 8B 45 D8 50 E8 ?? ?? ?? ?? 83 C4 04 83 E0 1F 6B C0 28 03 04 B5 ?? ?? ?? ?? 89 45 CC EB 07 C7 45 CC ?? ?? ?? ?? 8B 4D CC 8A 51 24 C0 E2 00 C0 FA 07 0F BE C2 85 C0 74 09 C7 45 C8 00 00 00 00 EB 07 C7 45 C8 01 00 00 00 8B 4D C8 89 4D D4 83 7D D4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 39 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D4 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 39 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 E4 FF FF FF FF 83 7D E4 00 75 19 8B 45 18 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 FF 55 08 83 C4 10 89 45 E4 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0D 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 E4 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_128_0_0 {
	meta:
		name = "__wcstod_l"
		size = 431
		refs = "0014 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0039 ??_C@_1BK@LAOAACLJ@?$AAn?$AAp?$AAt?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0042 ??_C@_1BC@HBBBHGOJ@?$AAw?$AAc?$AAs?$AAt?$AAo?$AAd?$AA?4?$AAc?$AA?$AA@ 0049 __CrtDbgReportW 005d __errno 0071 ??_C@_1BE@CIGDJHAJ@?$AA_?$AAw?$AAc?$AAs?$AAt?$AAo?$AAd?$AA_?$AAl?$AA?$AA@ 007b __invalid_parameter 008b ??1_LocaleUpdate@@QAE@XZ 009b ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 00aa __iswctype_l 00d2 _wcslen 00e3 __wfltin2 0144 __HUGE"
	strings:
		$1 = { 55 8B EC 83 EC 58 8B 45 08 89 45 F8 8B 4D 10 51 8D 4D DC E8 ?? ?? ?? ?? 83 7D 0C 00 74 08 8B 55 0C 8B 45 08 89 02 33 C9 83 7D 08 00 0F 95 C1 89 4D BC 83 7D BC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 48 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D BC 00 75 3B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 48 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 D9 EE DD 5D B0 8D 4D DC E8 ?? ?? ?? ?? DD 45 B0 E9 14 01 00 00 8D 4D DC E8 ?? ?? ?? ?? 50 6A 08 8B 45 F8 66 8B 08 51 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0B 8B 55 F8 83 C2 02 89 55 F8 EB D7 8D 4D DC E8 ?? ?? ?? ?? 50 6A 00 6A 00 8B 45 F8 50 E8 ?? ?? ?? ?? 83 C4 04 50 8B 4D F8 51 8D 55 C0 52 E8 ?? ?? ?? ?? 83 C4 18 89 45 EC 83 7D 0C 00 74 11 8B 45 EC 8B 48 04 8B 55 F8 8D 04 4A 8B 4D 0C 89 01 8B 55 EC 8B 02 89 45 FC 8B 4D FC 81 E1 40 02 00 00 74 15 D9 EE DD 5D F0 83 7D 0C 00 74 08 8B 55 0C 8B 45 08 89 02 EB 6E 8B 4D FC 81 E1 81 00 00 00 74 2E 8B 55 F8 0F B7 02 83 F8 2D 75 0D DD 05 ?? ?? ?? ?? D9 E0 DD 5D F0 EB 09 DD 05 ?? ?? ?? ?? DD 5D F0 E8 ?? ?? ?? ?? C7 00 22 00 00 00 EB 35 8B 4D FC 81 E1 00 01 00 00 74 21 8B 55 EC D9 EE DC 5A 10 DF E0 F6 C4 44 7A 12 D9 EE DD 5D F0 E8 ?? ?? ?? ?? C7 00 22 00 00 00 EB 09 8B 45 EC DD 40 10 DD 5D F0 DD 45 F0 DD 5D A8 8D 4D DC E8 ?? ?? ?? ?? DD 45 A8 8B E5 5D C3 }
	condition:
		$1
}

rule file_129_0_0 {
	meta:
		name = "__wincmdln"
		size = 193
		refs = "000f ___mbctype_initialized 0017 ___initmbctable 001d __acmdln 0027 ??_C@_00CNPNBAHC@?$AA@ 0075 __ismbblead"
	strings:
		$1 = { 55 8B EC 83 EC 0C C7 45 F8 00 00 00 00 83 3D ?? ?? ?? ?? 00 75 05 E8 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 75 09 C7 45 F4 ?? ?? ?? ?? EB 08 A1 ?? ?? ?? ?? 89 45 F4 8B 4D F4 89 4D FC 8B 55 FC 0F B6 02 83 F8 20 7F 10 8B 4D FC 0F B6 11 85 D2 74 4A 83 7D F8 00 74 44 8B 45 FC 0F B6 08 83 F9 22 75 0C 33 D2 83 7D F8 00 0F 94 C2 89 55 F8 8B 45 FC 0F B6 08 51 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 0F 83 7D FC 00 74 09 8B 55 FC 83 C2 01 89 55 FC 8B 45 FC 83 C0 01 89 45 FC EB A1 8B 4D FC 0F B6 11 85 D2 74 16 8B 45 FC 0F B6 08 83 F9 20 7F 0B 8B 55 FC 83 C2 01 89 55 FC EB E0 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_130_1_0 {
	meta:
		name = "_xtow@16"
		size = 208
	strings:
		$1 = { 55 8B EC 83 EC 10 8B 45 0C 89 45 FC 83 7D 14 00 74 19 8B 4D FC 66 C7 01 2D 00 8B 55 FC 83 C2 02 89 55 FC 8B 45 08 F7 D8 89 45 08 8B 4D FC 89 4D F0 8B 45 08 33 D2 F7 75 10 89 55 F8 8B 45 08 33 D2 F7 75 10 89 45 08 83 7D F8 09 76 17 8B 55 F8 83 C2 57 8B 45 FC 66 89 10 8B 4D FC 83 C1 02 89 4D FC EB 15 8B 55 F8 83 C2 30 8B 45 FC 66 89 10 8B 4D FC 83 C1 02 89 4D FC 83 7D 08 00 77 B2 8B 55 FC 66 C7 02 00 00 8B 45 FC 83 E8 02 89 45 FC 8B 4D FC 66 8B 11 66 89 55 F4 8B 45 FC 8B 4D F0 66 8B 11 66 89 10 8B 45 F0 66 8B 4D F4 66 89 08 8B 55 FC 83 EA 02 89 55 FC 8B 45 F0 83 C0 02 89 45 F0 8B 4D F0 3B 4D FC 72 C6 8B E5 5D C2 10 00 }
	condition:
		$1
}

rule file_130_5_0 {
	meta:
		name = "@x64tow@20"
		size = 260
		refs = "0052 __aullrem 0069 __aulldiv"
	strings:
		$1 = { 55 8B EC 83 EC 18 89 55 E8 89 4D EC 8B 45 EC 89 45 FC 83 7D 10 00 74 24 8B 4D FC 66 C7 01 2D 00 8B 55 FC 83 C2 02 89 55 FC 8B 45 08 F7 D8 8B 4D 0C 83 D1 00 F7 D9 89 45 08 89 4D 0C 8B 55 FC 89 55 F0 8B 45 E8 33 C9 51 50 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 89 45 F8 8B 4D E8 33 D2 52 51 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 89 45 08 89 55 0C 83 7D F8 09 76 17 8B 55 F8 83 C2 57 8B 45 FC 66 89 10 8B 4D FC 83 C1 02 89 4D FC EB 15 8B 55 F8 83 C2 30 8B 45 FC 66 89 10 8B 4D FC 83 C1 02 89 4D FC 83 7D 0C 00 77 97 72 06 83 7D 08 00 77 8F 8B 55 FC 66 C7 02 00 00 8B 45 FC 83 E8 02 89 45 FC 8B 4D FC 66 8B 11 66 89 55 F4 8B 45 FC 8B 4D F0 66 8B 11 66 89 10 8B 45 F0 66 8B 4D F4 66 89 08 8B 55 FC 83 EA 02 89 55 FC 8B 45 F0 83 C0 02 89 45 F0 8B 4D F0 3B 4D FC 72 C6 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_131_0_0 {
	meta:
		name = "__wcreat"
		size = 71
		refs = "0021 __wsopen_s"
	strings:
		$1 = { 55 8B EC 83 EC 0C C7 45 FC FF FF FF FF 8B 45 0C 50 6A 40 68 02 03 00 00 8B 4D 08 51 8D 55 FC 52 E8 ?? ?? ?? ?? 83 C4 14 89 45 F8 83 7D F8 00 75 08 8B 45 FC 89 45 F4 EB 07 C7 45 F4 FF FF FF FF 8B 45 F4 8B E5 5D C3 }
	condition:
		$1
}

rule file_890_0_0 {
	meta:
		name = "__creat"
		size = 71
		refs = "0021 __sopen_s"
	strings:
		$1 = { 55 8B EC 83 EC 0C C7 45 FC FF FF FF FF 8B 45 0C 50 6A 40 68 02 03 00 00 8B 4D 08 51 8D 55 FC 52 E8 ?? ?? ?? ?? 83 C4 14 89 45 F8 83 7D F8 00 75 08 8B 45 FC 89 45 F4 EB 07 C7 45 F4 FF FF FF FF 8B 45 F4 8B E5 5D C3 }
	condition:
		$1
}

rule file_132_0_0 {
	meta:
		name = "__cputs"
		size = 296
		refs = "0006 __sehtable$__cputs 000b __except_handler4 001d ___security_cookie 004a ??_C@_1CC@OLIJCKA@?$AA?$CI?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0053 ??_C@_1BA@JMADEHEE@?$AAc?$AAp?$AAu?$AAt?$AAs?$AA?4?$AAc?$AA?$AA@ 005a __CrtDbgReportW 006e ___doserrno 0079 __errno 008d ??_C@_1O@PLNHBNGC@?$AA_?$AAc?$AAp?$AAu?$AAt?$AAs?$AA?$AA@ 0097 __invalid_parameter 00a6 __lock 00b6 __confh 00be ___initconout 00da __putch_nolock 010b __unlock"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 EC 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 C7 45 E4 00 00 00 00 33 C0 83 7D 08 00 0F 95 C0 89 45 E0 83 7D E0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 31 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 36 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 31 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 73 6A 03 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 83 3D ?? ?? ?? ?? FE 75 05 E8 ?? ?? ?? ?? 8B 55 08 0F BE 02 85 C0 74 2E 8B 4D 08 0F BE 11 89 55 DC 8B 45 DC 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 08 83 C1 01 89 4D 08 83 F8 FF 75 09 C7 45 E4 FF FF FF FF EB 02 EB C8 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0B 6A 03 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 E4 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_133_0_0 {
	meta:
		name = "_fprintf"
		size = 738
		refs = "0006 __sehtable$_fprintf 000b __except_handler4 001d ___security_cookie 004a ??_C@_1BM@JMKHIAHP@?$AA?$CI?$AAs?$AAt?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0053 ??_C@_1BE@NEFIHEIC@?$AAf?$AAp?$AAr?$AAi?$AAn?$AAt?$AAf?$AA?4?$AAc?$AA?$AA@ 005a __CrtDbgReportW 006e __errno 0082 ??_C@_1BA@DNOHIGNM@?$AAf?$AAp?$AAr?$AAi?$AAn?$AAt?$AAf?$AA?$AA@ 008c __invalid_parameter 00ae ??_C@_1CC@MGIEJOME@?$AA?$CI?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0110 __lock_file 0138 __fileno 017b ___pioinfo 0187 ___badioinfo 0224 ??_C@_1BAE@CBLKKPB@?$AA?$CI?$AA?5?$AA?$CI?$AA_?$AAS?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?9?$AA?$DO?$AA_?$AAf?$AAl?$AAa?$AAg?$AA?5?$AA?$CG?$AA?5?$AA_?$AAI?$AAO?$AAS?$AAT?$AAR?$AAG?$AA?$CJ?$AA?5?$AA?$HM?$AA?$HM?$AA?5@ 027f __stbuf 0298 __output_l 02ab __ftbuf 02c5 __unlock_file"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 CC 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 C7 45 DC 00 00 00 00 33 C0 83 7D 08 00 0F 95 C0 89 45 D4 83 7D D4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 37 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D4 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 37 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 35 02 00 00 33 D2 83 7D 0C 00 0F 95 C2 89 55 D0 83 7D D0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 38 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D0 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 38 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 D1 01 00 00 8D 4D 10 89 4D E4 8B 55 08 89 55 E0 8B 45 E0 50 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 4D E0 89 4D CC 8B 55 CC 8B 42 0C 83 E0 40 0F 85 DD 00 00 00 8B 4D CC 51 E8 ?? ?? ?? ?? 83 C4 04 83 F8 FF 74 40 8B 55 CC 52 E8 ?? ?? ?? ?? 83 C4 04 83 F8 FE 74 2F 8B 45 CC 50 E8 ?? ?? ?? ?? 83 C4 04 8B F0 C1 FE 05 8B 4D CC 51 E8 ?? ?? ?? ?? 83 C4 04 83 E0 1F 6B C0 28 03 04 B5 ?? ?? ?? ?? 89 45 C4 EB 07 C7 45 C4 ?? ?? ?? ?? 8B 55 C4 8A 42 24 D0 E0 D0 F8 0F BE C8 85 C9 75 6B 8B 55 CC 52 E8 ?? ?? ?? ?? 83 C4 04 83 F8 FF 74 40 8B 45 CC 50 E8 ?? ?? ?? ?? 83 C4 04 83 F8 FE 74 2F 8B 4D CC 51 E8 ?? ?? ?? ?? 83 C4 04 8B F0 C1 FE 05 8B 55 CC 52 E8 ?? ?? ?? ?? 83 C4 04 83 E0 1F 6B C0 28 03 04 B5 ?? ?? ?? ?? 89 45 C0 EB 07 C7 45 C0 ?? ?? ?? ?? 8B 45 C0 8A 48 24 C0 E1 00 C0 F9 07 0F BE D1 85 D2 74 09 C7 45 BC 00 00 00 00 EB 07 C7 45 BC 01 00 00 00 8B 45 BC 89 45 C8 83 7D C8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 42 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D C8 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 42 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 DC FF FF FF FF 83 7D DC 00 75 38 8B 55 E0 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 D8 8B 45 E4 50 6A 00 8B 4D 0C 51 8B 55 E0 52 E8 ?? ?? ?? ?? 83 C4 10 89 45 DC 8B 45 E0 50 8B 4D D8 51 E8 ?? ?? ?? ?? 83 C4 08 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0D 8B 55 E0 52 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 DC 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_133_1_0 {
	meta:
		name = "__fprintf_l"
		size = 38
		refs = "001b __vfprintf_l"
	strings:
		$1 = { 55 8B EC 51 8D 45 14 89 45 FC 8B 4D FC 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_713_1_0 {
	meta:
		name = "___swprintf_l"
		size = 38
		refs = "001b ___vswprintf_l"
	strings:
		$1 = { 55 8B EC 51 8D 45 14 89 45 FC 8B 4D FC 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_133_4_0 {
	meta:
		name = "__fprintf_p_l"
		size = 38
		refs = "001b __vfprintf_p_l"
	strings:
		$1 = { 55 8B EC 51 8D 45 14 89 45 FC 8B 4D FC 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_133_2_0 {
	meta:
		name = "__fprintf_s_l"
		size = 38
		refs = "001b __vfprintf_s_l"
	strings:
		$1 = { 55 8B EC 51 8D 45 14 89 45 FC 8B 4D FC 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_851_1_0 {
	meta:
		name = "__fwprintf_l"
		size = 38
		refs = "001b __vfwprintf_l"
	strings:
		$1 = { 55 8B EC 51 8D 45 14 89 45 FC 8B 4D FC 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_851_4_0 {
	meta:
		name = "__fwprintf_p_l"
		size = 38
		refs = "001b __vfwprintf_p_l"
	strings:
		$1 = { 55 8B EC 51 8D 45 14 89 45 FC 8B 4D FC 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_851_2_0 {
	meta:
		name = "__fwprintf_s_l"
		size = 38
		refs = "001b __vfwprintf_s_l"
	strings:
		$1 = { 55 8B EC 51 8D 45 14 89 45 FC 8B 4D FC 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_642_1_0 {
	meta:
		name = "__sprintf_l"
		size = 38
		refs = "001b __vsprintf_l"
	strings:
		$1 = { 55 8B EC 51 8D 45 14 89 45 FC 8B 4D FC 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_133_3_0 {
	meta:
		name = "_fprintf_s"
		size = 36
		refs = "0019 __vfprintf_s_l"
	strings:
		$1 = { 55 8B EC 51 8D 45 10 89 45 FC 8B 4D FC 51 6A 00 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_133_5_0 {
	meta:
		name = "__fprintf_p"
		size = 36
		refs = "0019 __vfprintf_p_l"
	strings:
		$1 = { 55 8B EC 51 8D 45 10 89 45 FC 8B 4D FC 51 6A 00 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_851_5_0 {
	meta:
		name = "__fwprintf_p"
		size = 36
		refs = "0019 __vfwprintf_p_l"
	strings:
		$1 = { 55 8B EC 51 8D 45 10 89 45 FC 8B 4D FC 51 6A 00 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_851_3_0 {
	meta:
		name = "_fwprintf_s"
		size = 36
		refs = "0019 __vfwprintf_s_l"
	strings:
		$1 = { 55 8B EC 51 8D 45 10 89 45 FC 8B 4D FC 51 6A 00 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_134_0_0 {
	meta:
		name = "__execle"
		size = 453
		refs = "001f ??_C@_1CC@JBMDNKJP@?$AAf?$AAi?$AAl?$AAe?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0028 ??_C@_1BC@CHPHJMGF@?$AAe?$AAx?$AAe?$AAc?$AAl?$AAe?$AA?4?$AAc?$AA?$AA@ 002f __CrtDbgReportW 0043 __errno 0057 ??_C@_1BA@GFKLKNMG@?$AA_?$AAe?$AAx?$AAe?$AAc?$AAl?$AAe?$AA?$AA@ 0061 __invalid_parameter 0082 ??_C@_1CM@DMCMCPME@?$AA?$CK?$AAf?$AAi?$AAl?$AAe?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 00e6 ??_C@_1CA@MOAFCHEI@?$AAa?$AAr?$AAg?$AAl?$AAi?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0149 ??_C@_1CK@PKCLGCC@?$AA?$CK?$AAa?$AAr?$AAg?$AAl?$AAi?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 01ba __execve"
	strings:
		$1 = { 55 8B EC 83 EC 14 8D 45 0C 89 45 FC 33 C9 83 7D 08 00 0F 95 C1 89 4D F8 83 7D F8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 34 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F8 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 34 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 51 01 00 00 8B 45 08 0F BE 08 F7 D9 1B C9 F7 D9 89 4D F4 75 1E 68 ?? ?? ?? ?? 6A 00 6A 35 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F4 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 35 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 EE 00 00 00 33 C0 83 7D 0C 00 0F 95 C0 89 45 F0 83 7D F0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 36 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 36 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 8A 00 00 00 8B 55 0C 0F BE 02 F7 D8 1B C0 F7 D8 89 45 EC 75 1E 68 ?? ?? ?? ?? 6A 00 6A 37 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D EC 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 37 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 2A 8B 55 FC 8B 02 8B 4D FC 83 C1 04 89 4D FC 85 C0 74 02 EB EC 8B 55 FC 8B 02 50 8D 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_136_0_0 {
	meta:
		name = "_fputc"
		size = 657
		refs = "0006 __sehtable$_fputc 000b __except_handler4 001d ___security_cookie 004a ??_C@_1BM@JMKHIAHP@?$AA?$CI?$AAs?$AAt?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0053 ??_C@_1BA@JKOBKLHJ@?$AAf?$AAp?$AAu?$AAt?$AAc?$AA?4?$AAc?$AA?$AA@ 005a __CrtDbgReportW 006e __errno 0082 ??_C@_1M@OIJMPNCO@?$AAf?$AAp?$AAu?$AAt?$AAc?$AA?$AA@ 008c __invalid_parameter 00a0 __lock_file 00c8 __fileno 010b ___pioinfo 0117 ___badioinfo 01b4 ??_C@_1BAE@CBLKKPB@?$AA?$CI?$AA?5?$AA?$CI?$AA_?$AAS?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?9?$AA?$DO?$AA_?$AAf?$AAl?$AAa?$AAg?$AA?5?$AA?$CG?$AA?5?$AA_?$AAI?$AAO?$AAS?$AAT?$AAR?$AAG?$AA?$CJ?$AA?5?$AA?$HM?$AA?$HM?$AA?5@ 0251 __flsbuf 0274 __unlock_file"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 D8 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 C7 45 E4 00 00 00 00 33 C0 83 7D 0C 00 0F 95 C0 89 45 E0 83 7D E0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 2C 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 2C 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 E4 01 00 00 8B 55 0C 52 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 45 0C 89 45 DC 8B 4D DC 8B 51 0C 83 E2 40 0F 85 DD 00 00 00 8B 45 DC 50 E8 ?? ?? ?? ?? 83 C4 04 83 F8 FF 74 40 8B 4D DC 51 E8 ?? ?? ?? ?? 83 C4 04 83 F8 FE 74 2F 8B 55 DC 52 E8 ?? ?? ?? ?? 83 C4 04 8B F0 C1 FE 05 8B 45 DC 50 E8 ?? ?? ?? ?? 83 C4 04 83 E0 1F 6B C0 28 03 04 B5 ?? ?? ?? ?? 89 45 D4 EB 07 C7 45 D4 ?? ?? ?? ?? 8B 4D D4 8A 51 24 D0 E2 D0 FA 0F BE C2 85 C0 75 6B 8B 4D DC 51 E8 ?? ?? ?? ?? 83 C4 04 83 F8 FF 74 40 8B 55 DC 52 E8 ?? ?? ?? ?? 83 C4 04 83 F8 FE 74 2F 8B 45 DC 50 E8 ?? ?? ?? ?? 83 C4 04 8B F0 C1 FE 05 8B 4D DC 51 E8 ?? ?? ?? ?? 83 C4 04 83 E0 1F 6B C0 28 03 04 B5 ?? ?? ?? ?? 89 45 D0 EB 07 C7 45 D0 ?? ?? ?? ?? 8B 55 D0 8A 42 24 C0 E0 00 C0 F8 07 0F BE C8 85 C9 74 09 C7 45 CC 00 00 00 00 EB 07 C7 45 CC 01 00 00 00 8B 55 CC 89 55 D8 83 7D D8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 31 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D8 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 31 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 E4 FF FF FF FF 83 7D E4 00 75 57 8B 4D 0C 8B 51 04 83 EA 01 8B 45 0C 89 50 04 8B 4D 0C 83 79 04 00 7C 26 8B 55 0C 8B 02 8A 4D 08 88 08 0F BE 55 08 81 E2 FF 00 00 00 89 55 C8 8B 45 0C 8B 08 83 C1 01 8B 55 0C 89 0A EB 13 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 C8 8B 55 C8 89 55 E4 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0D 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 E4 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_136_1_0 {
	meta:
		name = "_putc"
		size = 657
		refs = "0006 __sehtable$_putc 000b __except_handler4 001d ___security_cookie 004a ??_C@_1BM@JMKHIAHP@?$AA?$CI?$AAs?$AAt?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0053 ??_C@_1BA@JKOBKLHJ@?$AAf?$AAp?$AAu?$AAt?$AAc?$AA?4?$AAc?$AA?$AA@ 005a __CrtDbgReportW 006e __errno 0082 ??_C@_19LHKMJKNP@?$AAp?$AAu?$AAt?$AAc?$AA?$AA@ 008c __invalid_parameter 00a0 __lock_file 00c8 __fileno 010b ___pioinfo 0117 ___badioinfo 01b4 ??_C@_1BAE@CBLKKPB@?$AA?$CI?$AA?5?$AA?$CI?$AA_?$AAS?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?9?$AA?$DO?$AA_?$AAf?$AAl?$AAa?$AAg?$AA?5?$AA?$CG?$AA?5?$AA_?$AAI?$AAO?$AAS?$AAT?$AAR?$AAG?$AA?$CJ?$AA?5?$AA?$HM?$AA?$HM?$AA?5@ 0251 __flsbuf 0274 __unlock_file"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 D8 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 C7 45 E4 00 00 00 00 33 C0 83 7D 0C 00 0F 95 C0 89 45 E0 83 7D E0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 48 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 48 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 E4 01 00 00 8B 55 0C 52 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 45 0C 89 45 DC 8B 4D DC 8B 51 0C 83 E2 40 0F 85 DD 00 00 00 8B 45 DC 50 E8 ?? ?? ?? ?? 83 C4 04 83 F8 FF 74 40 8B 4D DC 51 E8 ?? ?? ?? ?? 83 C4 04 83 F8 FE 74 2F 8B 55 DC 52 E8 ?? ?? ?? ?? 83 C4 04 8B F0 C1 FE 05 8B 45 DC 50 E8 ?? ?? ?? ?? 83 C4 04 83 E0 1F 6B C0 28 03 04 B5 ?? ?? ?? ?? 89 45 D4 EB 07 C7 45 D4 ?? ?? ?? ?? 8B 4D D4 8A 51 24 D0 E2 D0 FA 0F BE C2 85 C0 75 6B 8B 4D DC 51 E8 ?? ?? ?? ?? 83 C4 04 83 F8 FF 74 40 8B 55 DC 52 E8 ?? ?? ?? ?? 83 C4 04 83 F8 FE 74 2F 8B 45 DC 50 E8 ?? ?? ?? ?? 83 C4 04 8B F0 C1 FE 05 8B 4D DC 51 E8 ?? ?? ?? ?? 83 C4 04 83 E0 1F 6B C0 28 03 04 B5 ?? ?? ?? ?? 89 45 D0 EB 07 C7 45 D0 ?? ?? ?? ?? 8B 55 D0 8A 42 24 C0 E0 00 C0 F8 07 0F BE C8 85 C9 74 09 C7 45 CC 00 00 00 00 EB 07 C7 45 CC 01 00 00 00 8B 55 CC 89 55 D8 83 7D D8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 4D 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D8 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 4D 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 E4 FF FF FF FF 83 7D E4 00 75 57 8B 4D 0C 8B 51 04 83 EA 01 8B 45 0C 89 50 04 8B 4D 0C 83 79 04 00 7C 26 8B 55 0C 8B 02 8A 4D 08 88 08 0F BE 55 08 81 E2 FF 00 00 00 89 55 C8 8B 45 0C 8B 08 83 C1 01 8B 55 0C 89 0A EB 13 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 C8 8B 55 C8 89 55 E4 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0D 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 E4 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_137_0_0 {
	meta:
		name = "__filelengthi64"
		size = 652
		refs = "0006 __sehtable$__filelengthi64 000b __except_handler4 001d ___security_cookie 0037 ___doserrno 0042 __errno 0062 __nhandle 0085 ??_C@_1HC@KFLBHHBC@?$AA?$CI?$AAf?$AAi?$AAl?$AAe?$AAd?$AAe?$AAs?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AAu?$AAn?$AAs?$AAi?$AAg?$AAn?$AAe?$AAd?$AA?$CJ?$AAf?$AAi?$AAl?$AAe?$AAd@ 008e ??_C@_1BE@GBMFPHBC@?$AAf?$AAl?$AAe?$AAn?$AAi?$AA6?$AA4?$AA?4?$AAc?$AA?$AA@ 0095 __CrtDbgReportW 00c8 ??_C@_1BO@FPPOBOJI@?$AA_?$AAf?$AAi?$AAl?$AAe?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AAi?$AA6?$AA4?$AA?$AA@ 00d2 __invalid_parameter 00f6 ___pioinfo 010e ??_C@_1DG@LNNHNFHJ@?$AA?$CI?$AA_?$AAo?$AAs?$AAf?$AAi?$AAl?$AAe?$AA?$CI?$AAf?$AAi?$AAl?$AAe?$AAd?$AAe?$AAs?$AA?$CJ?$AA?5?$AA?$CG?$AA?5?$AAF?$AAO?$AAP?$AAE?$AAN?$AA?$CJ?$AA?$AA@ 0172 ___lock_fhandle 01ab __lseeki64_nolock 023c ??_C@_1JE@ECKHFIFP@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAf?$AAi?$AAl?$AAe?$AA?5?$AAd?$AAe?$AAs?$AAc?$AAr?$AAi?$AAp?$AAt?$AAo?$AAr?$AA?4?$AA?5?$AAF?$AAi?$AAl?$AAe?$AA?5@ 026c __unlock_fhandle"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 DC 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 83 7D 08 FE 75 21 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 C8 FF 83 CA FF E9 23 02 00 00 83 7D 08 00 7C 14 8B 45 08 3B 05 ?? ?? ?? ?? 73 09 C7 45 CC 01 00 00 00 EB 07 C7 45 CC 00 00 00 00 8B 4D CC 89 4D D4 83 7D D4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 2E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D4 00 75 3C E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 6A 00 6A 2E 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF 83 CA FF E9 96 01 00 00 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F 6B C9 28 8B 14 85 ?? ?? ?? ?? 0F BE 44 0A 04 83 E0 01 F7 D8 1B C0 F7 D8 89 45 D0 75 1E 68 ?? ?? ?? ?? 6A 00 6A 2F 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D0 00 75 3C E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 6A 00 6A 2F 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF 83 CA FF E9 0D 01 00 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F 6B C9 28 8B 14 85 ?? ?? ?? ?? 0F BE 44 0A 04 83 E0 01 74 73 6A 01 6A 00 6A 00 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 E0 89 55 E4 8B 55 E0 23 55 E4 83 FA FF 75 10 C7 45 D8 FF FF FF FF C7 45 DC FF FF FF FF EB 3E 6A 02 6A 00 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 D8 89 55 DC 8B 4D E0 3B 4D D8 75 08 8B 55 E4 3B 55 DC 74 16 6A 00 8B 45 E4 50 8B 4D E0 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 EB 46 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? C7 00 00 00 00 00 C7 45 D8 FF FF FF FF C7 45 DC FF FF FF FF 33 C0 75 1E 68 ?? ?? ?? ?? 6A 00 6A 44 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0D 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 D8 8B 55 DC 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_138_0_0 {
	meta:
		name = "_setbuf"
		size = 90
		refs = "000a ??_C@_1BO@KIJENGPH@?$AAs?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0013 ??_C@_1BC@NNGJDMIL@?$AAs?$AAe?$AAt?$AAb?$AAu?$AAf?$AA?4?$AAc?$AA?$AA@ 001a __CrtDbgReportW 0038 _setvbuf"
	strings:
		$1 = { 55 8B EC 83 7D 08 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 2F 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D 0C 00 75 14 6A 00 6A 04 6A 00 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 10 EB 17 68 00 02 00 00 6A 00 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_139_0_0 {
	meta:
		name = "__mbscspn_l"
		size = 552
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0016 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 002c _strcspn 003a ??1_LocaleUpdate@@QAE@XZ 0059 ??_C@_1BO@JIBAMMGI@?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0062 ??_C@_1BE@PJLLMELG@?$AAm?$AAb?$AAs?$AAc?$AAs?$AAp?$AAn?$AA?4?$AAc?$AA?$AA@ 0069 __CrtDbgReportW 007d __errno 0091 ??_C@_1BG@HJHJFBCP@?$AA_?$AAm?$AAb?$AAs?$AAc?$AAs?$AAp?$AAn?$AA_?$AAl?$AA?$AA@ 009b __invalid_parameter 00cc ??_C@_1CA@KMNJPEDI@?$AAc?$AAh?$AAa?$AAr?$AAs?$AAe?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@"
	strings:
		$1 = { 55 8B EC 83 EC 30 8B 45 10 50 8D 4D E8 E8 ?? ?? ?? ?? 8D 4D E8 E8 ?? ?? ?? ?? 8B 48 04 83 79 08 00 75 23 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 DC 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 DC E9 DE 01 00 00 33 C9 83 7D 08 00 0F 95 C1 89 4D E4 83 7D E4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 58 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E4 00 75 3D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 58 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 D8 00 00 00 00 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 D8 E9 6B 01 00 00 33 C0 83 7D 0C 00 0F 95 C0 89 45 E0 83 7D E0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 59 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 3D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 59 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 D4 00 00 00 00 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 D4 E9 F8 00 00 00 8B 55 08 89 55 F8 EB 09 8B 45 F8 83 C0 01 89 45 F8 8B 4D F8 0F B6 11 85 D2 0F 84 C5 00 00 00 8B 45 0C 89 45 FC EB 09 8B 4D FC 83 C1 01 89 4D FC 8B 55 FC 0F B6 02 85 C0 74 69 8D 4D E8 E8 ?? ?? ?? ?? 8B 48 04 8B 55 FC 0F B6 02 0F B6 4C 01 1D 83 E1 04 74 3A 8B 55 FC 0F B6 02 8B 4D F8 0F B6 11 3B C2 75 12 8B 45 FC 0F B6 48 01 8B 55 F8 0F B6 42 01 3B C8 74 0B 8B 4D FC 0F B6 51 01 85 D2 75 02 EB 1F 8B 45 FC 83 C0 01 89 45 FC EB 12 8B 4D FC 0F B6 11 8B 45 F8 0F B6 08 3B D1 75 02 EB 02 EB 84 8B 55 FC 0F B6 02 85 C0 74 02 EB 35 8D 4D E8 E8 ?? ?? ?? ?? 8B 48 04 8B 55 F8 0F B6 02 0F B6 4C 01 1D 83 E1 04 74 15 8B 55 F8 83 C2 01 89 55 F8 8B 45 F8 0F B6 08 85 C9 75 02 EB 05 E9 24 FF FF FF 8B 55 F8 2B 55 08 89 55 D0 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 D0 8B E5 5D C3 }
	condition:
		$1
}

rule file_140_0_0 {
	meta:
		name = "__CIlog_pentium4"
		size = 624
		refs = "0039 emask 0041 One 0049 Magic 0051 hi_mask 006f B_Tbl 0077 T_Tbl 00d9 coeff 0105 LOG_2 0111 place_L 0168 Zero 01b7 Infs 01e2 Two52 0233 ___libm_error_support"
	strings:
		$1 = { 55 8B EC 83 EC 08 83 E4 F0 DD 1C 24 F3 0F 7E 04 24 E8 08 00 00 00 C9 C3 66 0F 12 44 24 04 BA 00 00 00 00 66 0F 28 E8 66 0F 14 C0 66 0F 73 D5 34 66 0F C5 CD 00 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F 28 25 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 54 C1 66 0F 56 C3 66 0F 58 E0 66 0F C5 C4 00 25 F0 07 00 00 66 0F 28 A0 ?? ?? ?? ?? 66 0F 28 B8 ?? ?? ?? ?? 66 0F 54 F0 66 0F 5C C6 66 0F 59 F4 66 0F 5C F3 F2 0F 58 FE 66 0F 59 C4 66 0F 28 E0 66 0F 58 C6 81 E1 FF 0F 00 00 83 E9 01 81 F9 FD 07 00 00 0F 87 AE 00 00 00 81 E9 FE 03 00 00 03 CA F2 0F 2A F1 66 0F 14 F6 C1 E1 0A 03 C1 B9 10 00 00 00 BA 00 00 00 00 83 F8 00 0F 44 D1 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 D8 66 0F 28 15 ?? ?? ?? ?? 66 0F 59 C8 66 0F 59 DB 66 0F 58 CA 66 0F 28 15 ?? ?? ?? ?? F2 0F 59 DB 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 F5 66 0F 28 AA ?? ?? ?? ?? 66 0F 54 E5 66 0F 58 FE 66 0F 58 FC 66 0F 59 C8 F2 0F 59 D8 66 0F 58 CA 66 0F 28 F7 66 0F 15 F6 66 0F 59 CB 83 EC 10 66 0F 28 C1 66 0F 15 C9 F2 0F 58 C1 F2 0F 58 C6 F2 0F 58 C7 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 66 0F 12 44 24 04 66 0F 28 0D ?? ?? ?? ?? F2 0F C2 C8 00 66 0F C5 C1 00 83 F8 00 77 48 83 F9 FF 74 5E 81 F9 FE 07 00 00 77 6C 66 0F 12 44 24 04 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 54 C1 66 0F 56 C2 F2 0F C2 D0 00 66 0F C5 C2 00 83 F8 00 74 07 DD 05 ?? ?? ?? ?? C3 BA E8 03 00 00 EB 4F 66 0F 12 15 ?? ?? ?? ?? F2 0F 5E D0 66 0F 12 0D ?? ?? ?? ?? BA 02 00 00 00 EB 34 66 0F 12 0D ?? ?? ?? ?? F2 0F 59 C1 BA CC FF FF FF E9 2F FE FF FF 83 C1 01 81 E1 FF 07 00 00 81 F9 FF 07 00 00 73 3A 66 0F 57 C9 F2 0F 5E C9 BA 03 00 00 00 83 EC 1C 66 0F 13 4C 24 10 89 54 24 0C 8B D4 83 C2 10 89 54 24 08 83 C2 10 89 54 24 04 89 14 24 E8 ?? ?? ?? ?? DD 44 24 10 83 C4 1C C3 66 0F 12 54 24 04 66 0F 12 44 24 04 66 0F 7E D0 66 0F 73 D2 20 66 0F 7E D1 81 E1 FF FF 0F 00 0B C1 83 F8 00 74 A0 BA E8 03 00 00 EB A6 8D 64 24 00 }
	condition:
		$1
}

rule file_141_0_0 {
	meta:
		name = "__mktime64"
		size = 19
		refs = "000a __make__time64_t"
	strings:
		$1 = { 55 8B EC 6A 01 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_417_16_0 {
	meta:
		name = "__free_nolock"
		size = 19
		refs = "000a __free_dbg_nolock"
	strings:
		$1 = { 55 8B EC 6A 01 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_275_0_0 {
	meta:
		name = "__mktime32"
		size = 19
		refs = "000a __make__time32_t"
	strings:
		$1 = { 55 8B EC 6A 01 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_417_19_0 {
	meta:
		name = "__msize"
		size = 19
		refs = "000a __msize_dbg"
	strings:
		$1 = { 55 8B EC 6A 01 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_417_15_0 {
	meta:
		name = "_free"
		size = 19
		refs = "000a __free_dbg"
	strings:
		$1 = { 55 8B EC 6A 01 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_141_2_0 {
	meta:
		name = "__make__time64_t"
		size = 1106
		refs = "002a ??_C@_1BO@LELPCFEI@?$AA?$CI?$AA?5?$AAt?$AAb?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CJ?$AA?$AA@ 0036 ??_C@_1BG@CHMIPCJA@?$AAm?$AAk?$AAt?$AAi?$AAm?$AAe?$AA6?$AA4?$AA?4?$AAc?$AA?$AA@ 003d __CrtDbgReportW 0051 __errno 0068 ??_C@_1CA@JJKIFLJO@?$AA_?$AAm?$AAa?$AAk?$AAe?$AA_?$AA_?$AAt?$AAi?$AAm?$AAe?$AA6?$AA4?$AA_?$AAt?$AA?$AA@ 0072 __invalid_parameter 014f __days 0167 __allrem 01f3 __allmul 020e __alldiv 034b ___tzset 0361 ??_C@_1CO@IMMOMMCB@?$AA_?$AAg?$AAe?$AAt?$AA_?$AAd?$AAs?$AAt?$AAb?$AAi?$AAa?$AAs?$AA?$CI?$AA?$CG?$AAd?$AAs?$AAt?$AAb?$AAi?$AAa?$AAs?$AA?$CJ?$AA?$AA@ 036a __get_dstbias 0373 __invoke_watson_if_error 038c ??_C@_1DC@CMKCHHFC@?$AA_?$AAg?$AAe?$AAt?$AA_?$AAt?$AAi?$AAm?$AAe?$AAz?$AAo?$AAn?$AAe?$AA?$CI?$AA?$CG?$AAt?$AAi?$AAm?$AAe?$AAz?$AAo?$AAn?$AAe?$AA?$CJ?$AA?$AA@ 0395 __get_timezone 03c0 __localtime64_s 0418 __gmtime64_s"
	strings:
		$1 = { 55 8B EC 83 EC 74 53 56 57 C7 45 FC 00 00 00 00 C7 45 BC 00 00 00 00 33 C0 83 7D 08 00 0F 95 C0 89 45 AC 83 7D AC 00 75 21 68 ?? ?? ?? ?? 6A 00 68 81 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D AC 00 75 34 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 81 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF 83 CA FF E9 C7 03 00 00 8B 55 08 8B 42 14 99 89 45 B0 89 55 B4 83 7D B4 00 7C 19 7F 06 83 7D B0 45 72 11 83 7D B4 00 7C 10 7F 09 81 7D B0 4D 04 00 00 76 05 E9 85 03 00 00 8B 45 08 83 78 10 00 7C 09 8B 4D 08 83 79 10 0B 7E 7F 8B 55 08 8B 42 10 99 B9 0C 00 00 00 F7 F9 99 03 45 B0 8B 4D B4 13 CA 89 45 B0 89 4D B4 8B 55 08 8B 42 10 99 B9 0C 00 00 00 F7 F9 8B 45 08 89 50 10 8B 4D 08 83 79 10 00 7D 21 8B 55 08 8B 42 10 83 C0 0C 8B 4D 08 89 41 10 8B 55 B0 83 EA 01 8B 45 B4 83 D8 00 89 55 B0 89 45 B4 83 7D B4 00 7C 19 7F 06 83 7D B0 45 72 11 83 7D B4 00 7C 10 7F 09 81 7D B0 4D 04 00 00 76 05 E9 F4 02 00 00 8B 4D 08 8B 51 10 8B 04 95 ?? ?? ?? ?? 99 89 45 C0 89 55 C4 6A 00 6A 04 8B 45 B4 50 8B 4D B0 51 E8 ?? ?? ?? ?? 89 45 A4 89 55 A8 8B 55 A4 0B 55 A8 75 1F 6A 00 6A 64 8B 45 B4 50 8B 4D B0 51 E8 ?? ?? ?? ?? 89 45 9C 89 55 A0 8B 55 9C 0B 55 A0 75 2A 8B 45 B0 05 6C 07 00 00 8B 4D B4 83 D1 00 6A 00 68 90 01 00 00 51 50 E8 ?? ?? ?? ?? 89 45 94 89 55 98 8B 55 94 0B 55 98 75 1B 8B 45 08 83 78 10 01 7E 12 8B 4D C0 83 C1 01 8B 55 C4 83 D2 00 89 4D C0 89 55 C4 8B 45 B0 83 E8 46 8B 4D B4 83 D9 00 6A 00 68 6D 01 00 00 51 50 E8 ?? ?? ?? ?? 8B F0 8B FA 8B 55 B0 83 EA 01 8B 45 B4 83 D8 00 6A 00 6A 04 50 52 E8 ?? ?? ?? ?? 8B D8 8B C2 8B 4D B0 83 E9 01 8B 55 B4 83 DA 00 6A 00 6A 64 52 51 89 45 90 E8 ?? ?? ?? ?? 2B D8 8B 45 90 1B C2 8B 4D B0 81 C1 2B 01 00 00 8B 55 B4 83 D2 00 6A 00 68 90 01 00 00 52 51 89 45 8C E8 ?? ?? ?? ?? 03 D8 8B 45 8C 13 C2 83 EB 11 83 D8 00 03 F3 13 F8 89 75 F0 89 7D F4 8B 45 F0 03 45 C0 8B 4D F4 13 4D C4 89 45 F0 89 4D F4 8B 55 08 8B 42 0C 99 89 45 C0 89 55 C4 8B 45 F0 03 45 C0 8B 4D F4 13 4D C4 89 45 B0 89 4D B4 6A 00 6A 18 8B 55 B4 52 8B 45 B0 50 E8 ?? ?? ?? ?? 89 45 C0 89 55 C4 8B 4D 08 8B 41 08 99 89 45 F0 89 55 F4 8B 55 C0 03 55 F0 8B 45 C4 13 45 F4 89 55 B0 89 45 B4 6A 00 6A 3C 8B 4D B4 51 8B 55 B0 52 E8 ?? ?? ?? ?? 89 45 C0 89 55 C4 8B 45 08 8B 40 04 99 89 45 F0 89 55 F4 8B 4D C0 03 4D F0 8B 55 C4 13 55 F4 89 4D B0 89 55 B4 6A 00 6A 3C 8B 45 B4 50 8B 4D B0 51 E8 ?? ?? ?? ?? 89 45 C0 89 55 C4 8B 55 08 8B 02 99 89 45 F0 89 55 F4 8B 45 C0 03 45 F0 8B 4D C4 13 4D F4 89 45 B0 89 4D B4 83 7D 0C 00 0F 84 C5 00 00 00 E8 ?? ?? ?? ?? 6A 00 68 E6 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 E7 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 BC 50 E8 ?? ?? ?? ?? 83 C4 04 50 E8 ?? ?? ?? ?? 83 C4 18 8B 45 BC 99 03 45 B0 8B 4D B4 13 CA 89 45 B0 89 4D B4 8D 55 B0 52 8D 45 CC 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 02 EB 6D 8B 4D 08 83 79 20 00 7F 0F 8B 55 08 83 7A 20 00 7D 2E 83 7D EC 00 7E 28 8B 45 FC 99 03 45 B0 8B 4D B4 13 CA 89 45 B0 89 4D B4 8D 55 B0 52 8D 45 CC 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 02 EB 2D EB 16 8D 4D B0 51 8D 55 CC 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 02 EB 15 B9 09 00 00 00 8D 75 CC 8B 7D 08 F3 A5 8B 45 B0 8B 55 B4 EB 11 E8 ?? ?? ?? ?? C7 00 16 00 00 00 83 C8 FF 83 CA FF 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_142_0_0 {
	meta:
		name = "__mtinitlocks"
		size = 138
		refs = "002b __locktable 003a _lclcritsects 0062 ___crtInitCritSecAndSpinCount"
	strings:
		$1 = { 55 8B EC 83 EC 08 C7 45 FC 00 00 00 00 C7 45 F8 00 00 00 00 EB 09 8B 45 F8 83 C0 01 89 45 F8 83 7D F8 24 7D 5C 8B 4D F8 83 3C CD ?? ?? ?? ?? 01 75 4D 8B 55 FC 6B D2 18 81 C2 ?? ?? ?? ?? 8B 45 F8 89 14 C5 ?? ?? ?? ?? 8B 4D FC 83 C1 01 89 4D FC 68 A0 0F 00 00 8B 55 F8 8B 04 D5 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 12 8B 4D F8 C7 04 CD ?? ?? ?? ?? 00 00 00 00 33 C0 EB 07 EB 95 B8 01 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_142_1_0 {
	meta:
		name = "__mtdeletelocks"
		size = 188
		refs = "0024 __locktable 004b __imp__DeleteCriticalSection@4 0056 __free_dbg"
	strings:
		$1 = { 55 8B EC 83 EC 0C C7 45 FC 00 00 00 00 EB 09 8B 45 FC 83 C0 01 89 45 FC 83 7D FC 24 7D 4F 8B 4D FC 83 3C CD ?? ?? ?? ?? 00 74 40 8B 55 FC 83 3C D5 ?? ?? ?? ?? 01 74 33 8B 45 FC 8B 0C C5 ?? ?? ?? ?? 89 4D F8 8B 55 F8 52 FF 15 ?? ?? ?? ?? 6A 02 8B 45 F8 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4D FC C7 04 CD ?? ?? ?? ?? 00 00 00 00 EB A2 C7 45 FC 00 00 00 00 EB 09 8B 55 FC 83 C2 01 89 55 FC 83 7D FC 24 7D 33 8B 45 FC 83 3C C5 ?? ?? ?? ?? 00 74 24 8B 4D FC 83 3C CD ?? ?? ?? ?? 01 75 17 8B 55 FC 8B 04 D5 ?? ?? ?? ?? 89 45 F4 8B 4D F4 51 FF 15 ?? ?? ?? ?? EB BE 8B E5 5D C3 }
	condition:
		$1
}

rule file_142_2_0 {
	meta:
		name = "__mtinitlocknum"
		size = 324
		refs = "0006 __sehtable$__mtinitlocknum 000b __except_handler4 001d ___security_cookie 0039 __crtheap 0041 __FF_MSGBANNER 0048 __NMSG_WRITE 0055 ___crtExitProcess 0062 __locktable 0079 ??_C@_07CKDBCAPD@mlock?4c?$AA@ 0082 __malloc_dbg 0093 __errno 00a7 __lock 00cc ___crtInitCritSecAndSpinCount 00de __free_dbg 0127 __unlock"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 F0 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 C7 45 E0 01 00 00 00 83 3D ?? ?? ?? ?? 00 75 1C E8 ?? ?? ?? ?? 6A 1E E8 ?? ?? ?? ?? 83 C4 04 68 FF 00 00 00 E8 ?? ?? ?? ?? 83 C4 04 8B 45 08 83 3C C5 ?? ?? ?? ?? 00 74 0A B8 01 00 00 00 E9 BF 00 00 00 68 17 01 00 00 68 ?? ?? ?? ?? 6A 02 6A 18 E8 ?? ?? ?? ?? 83 C4 10 89 45 E4 83 7D E4 00 75 12 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 33 C0 E9 8E 00 00 00 6A 0A E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 4D 08 83 3C CD ?? ?? ?? ?? 00 75 46 68 A0 0F 00 00 8B 55 E4 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 22 6A 02 8B 45 E4 50 E8 ?? ?? ?? ?? 83 C4 08 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 C7 45 E0 00 00 00 00 EB 0D 8B 4D 08 8B 55 E4 89 14 CD ?? ?? ?? ?? EB 0E 6A 02 8B 45 E4 50 E8 ?? ?? ?? ?? 83 C4 08 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0B 6A 0A E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 E0 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_142_3_0 {
	meta:
		name = "__lock"
		size = 61
		refs = "0009 __locktable 0015 __mtinitlocknum 0023 __amsg_exit 0037 __imp__EnterCriticalSection@4"
	strings:
		$1 = { 55 8B EC 8B 45 08 83 3C C5 ?? ?? ?? ?? 00 75 1A 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 0A 6A 11 E8 ?? ?? ?? ?? 83 C4 04 8B 55 08 8B 04 D5 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_142_4_0 {
	meta:
		name = "__unlock"
		size = 22
		refs = "0009 __locktable 0010 __imp__LeaveCriticalSection@4"
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 0C C5 ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_142_5_0 {
	meta:
		name = "__lockerr_exit"
		size = 30
		refs = "000b __imp__FatalAppExitA@8 0015 ___crtExitProcess"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 6A 00 FF 15 ?? ?? ?? ?? 68 FF 00 00 00 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_144_0_0 {
	meta:
		name = "_memmove"
		size = 869
		refs = "002a ___sse2_available 0043 __VEC_memcpy 005f TrailUpVec 0078 LeadUpVec 0087 UnwindUpVec 008c LeadUp1 0090 LeadUp2 0094 LeadUp3 0108 UnwindUp0 010c UnwindUp1 0110 UnwindUp2 0114 UnwindUp3 0118 UnwindUp4 011c UnwindUp5 0120 UnwindUp6 0124 UnwindUp7 0174 TrailUp0 0178 TrailUp1 017c TrailUp2 0180 TrailUp3 01e6 TrailDownVec 01f1 UnwindDownVec 020c LeadDownVec 0218 LeadDown1 021c LeadDown2 0220 LeadDown3 02a4 UnwindDown7 02a8 UnwindDown6 02ac UnwindDown5 02b0 UnwindDown4 02b4 UnwindDown3 02b8 UnwindDown2 02bc UnwindDown1 02c0 UnwindDown0 0310 TrailDown0 0314 TrailDown1 0318 TrailDown2 031c TrailDown3"
		altNames = "_memcpy"
	strings:
		$1 = { 55 8B EC 57 56 8B 75 0C 8B 4D 10 8B 7D 08 8B C1 8B D1 03 C6 3B FE 76 08 3B F8 0F 82 A4 01 00 00 81 F9 00 01 00 00 72 1F 83 3D ?? ?? ?? ?? 00 74 16 57 56 83 E7 0F 83 E6 0F 3B FE 5E 5F 75 08 5E 5F 5D E9 ?? ?? ?? ?? F7 C7 03 00 00 00 75 15 C1 E9 02 83 E2 03 83 F9 08 72 2A F3 A5 FF 24 95 ?? ?? ?? ?? 90 8B C7 BA 03 00 00 00 83 E9 04 72 0C 83 E0 03 03 C8 FF 24 85 ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? 90 FF 24 8D ?? ?? ?? ?? 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 23 D1 8A 06 88 07 8A 46 01 88 47 01 8A 46 02 C1 E9 02 88 47 02 83 C6 03 83 C7 03 83 F9 08 72 CC F3 A5 FF 24 95 ?? ?? ?? ?? 8D 49 00 23 D1 8A 06 88 07 8A 46 01 C1 E9 02 88 47 01 83 C6 02 83 C7 02 83 F9 08 72 A6 F3 A5 FF 24 95 ?? ?? ?? ?? 90 23 D1 8A 06 88 07 83 C6 01 C1 E9 02 83 C7 01 83 F9 08 72 88 F3 A5 FF 24 95 ?? ?? ?? ?? 8D 49 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 8B 44 8E E4 89 44 8F E4 8B 44 8E E8 89 44 8F E8 8B 44 8E EC 89 44 8F EC 8B 44 8E F0 89 44 8F F0 8B 44 8E F4 89 44 8F F4 8B 44 8E F8 89 44 8F F8 8B 44 8E FC 89 44 8F FC 8D 04 8D 00 00 00 00 03 F0 03 F8 FF 24 95 ?? ?? ?? ?? 8B FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 8B 45 08 5E 5F C9 C3 90 8A 06 88 07 8B 45 08 5E 5F C9 C3 90 8A 06 88 07 8A 46 01 88 47 01 8B 45 08 5E 5F C9 C3 8D 49 00 8A 06 88 07 8A 46 01 88 47 01 8A 46 02 88 47 02 8B 45 08 5E 5F C9 C3 90 8D 74 31 FC 8D 7C 39 FC F7 C7 03 00 00 00 75 24 C1 E9 02 83 E2 03 83 F9 08 72 0D FD F3 A5 FC FF 24 95 ?? ?? ?? ?? 8B FF F7 D9 FF 24 8D ?? ?? ?? ?? 8D 49 00 8B C7 BA 03 00 00 00 83 F9 04 72 0C 83 E0 03 2B C8 FF 24 85 ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 8A 46 03 23 D1 88 47 03 83 EE 01 C1 E9 02 83 EF 01 83 F9 08 72 B2 FD F3 A5 FC FF 24 95 ?? ?? ?? ?? 8D 49 00 8A 46 03 23 D1 88 47 03 8A 46 02 C1 E9 02 88 47 02 83 EE 02 83 EF 02 83 F9 08 72 88 FD F3 A5 FC FF 24 95 ?? ?? ?? ?? 90 8A 46 03 23 D1 88 47 03 8A 46 02 88 47 02 8A 46 01 C1 E9 02 88 47 01 83 EE 03 83 EF 03 83 F9 08 0F 82 56 FF FF FF FD F3 A5 FC FF 24 95 ?? ?? ?? ?? 8D 49 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 8B 44 8E 1C 89 44 8F 1C 8B 44 8E 18 89 44 8F 18 8B 44 8E 14 89 44 8F 14 8B 44 8E 10 89 44 8F 10 8B 44 8E 0C 89 44 8F 0C 8B 44 8E 08 89 44 8F 08 8B 44 8E 04 89 44 8F 04 8D 04 8D 00 00 00 00 03 F0 03 F8 FF 24 95 ?? ?? ?? ?? 8B FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 8B 45 08 5E 5F C9 C3 90 8A 46 03 88 47 03 8B 45 08 5E 5F C9 C3 8D 49 00 8A 46 03 88 47 03 8A 46 02 88 47 02 8B 45 08 5E 5F C9 C3 90 8A 46 03 88 47 03 8A 46 02 88 47 02 8A 46 01 88 47 01 8B 45 08 5E 5F C9 C3 }
	condition:
		$1
}

rule file_145_0_0 {
	meta:
		name = "__winput_l"
		size = 5985
		refs = "000a ___security_cookie 006b ??_C@_1CC@MGIEJOME@?$AA?$CI?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0077 ??_C@_1GA@EKLPPGMG@?$AAf?$AA?3?$AA?2?$AAr?$AAt?$AAm?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2@ 007e __CrtDbgReportW 0095 __errno 00ac ??_C@_1BE@ECKJHKGH@?$AA_?$AAw?$AAi?$AAn?$AAp?$AAu?$AAt?$AA_?$AAl?$AA?$AA@ 00b6 __invalid_parameter 00de ??_C@_1CC@FADMNIL@?$AA?$CI?$AAs?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0143 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0176 _iswctype 0197 __whiteout 01a0 __un_inc 0270 _isdigit 02d0 $LN240 02d7 $LN242 0516 __inc 057f $LN241 0586 $LN243 0628 ??_C@_0DA@ONFNIG@f?3?2rtm?2vctools?2crt_bld?2self_x86?2@ 0634 __malloc_dbg 065c _memset 08cb ??_C@_1FA@OAMCKJNL@?$AAw?$AAc?$AAt?$AAo?$AAm?$AAb?$AA_?$AAs?$AA?$CI?$AA?$CG?$AAt?$AAe?$AAm?$AAp?$AA?0?$AA?5?$AA?$CI?$AAc?$AAh?$AAa?$AAr?$AA?5?$AA?$CK?$AA?$CJ?$AAp?$AAo?$AAi?$AAn?$AAt?$AAe?$AAr?$AA?0@ 08e9 _wctomb_s 08f2 __invoke_watson_if_oneof 0b72 _isxdigit 0b8c __allshl 0ba5 __hextodec 103c ___check_float_string 107a ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 109b __INTRN_LOCALE_CONV 10aa __mbtowc_l 146a ??_C@_1IE@NKBCJFAM@?$AAw?$AAc?$AAs?$AAt?$AAo?$AAm?$AAb?$AAs?$AA_?$AAs?$AA?5?$AA?$CI?$AA0?$AA?0?$AA?5?$AAc?$AAf?$AAl?$AAo?$AAa?$AAt?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?0?$AA?5?$AAc?$AAf?$AAs@ 1491 _wcstombs_s 14c2 __cfltcvt_tab 14c8 __decode_pointer 14de __free_dbg 166d ??1_LocaleUpdate@@QAE@XZ 16a8 @__security_check_cookie@4 16b0 $LN200 16b4 $LN217 16b8 $LN215 16bc $LN205 16c0 $LN216 16c4 $LN204 16c8 $LN201 16cc $DEFAULT_LABEL$26385 1720 $LN182 1724 $LN113 1728 $LN56 172c $LN132 1730 $LN58 1734 $LN114 1738 $LN178 173c $LN131 1740 $LN175 1744 $LN16"
	strings:
		$1 = { 55 8B EC 81 EC 80 03 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 A0 8D 85 E0 FC FF FF 89 45 A4 C7 45 EC 00 00 00 00 C7 85 C4 FC FF FF 5E 01 00 00 C7 45 D8 00 00 00 00 C7 45 BC 00 00 00 00 C7 45 C8 00 00 00 00 C7 45 B0 00 00 00 00 66 C7 85 AC FC FF FF 00 00 33 C9 83 7D 0C 00 0F 95 C1 89 8D A4 FC FF FF 83 BD A4 FC FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 BD 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD A4 FC FF FF 00 75 31 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 BD 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 DD 15 00 00 33 C0 83 7D 08 00 0F 95 C0 89 85 A0 FC FF FF 83 BD A0 FC FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 C0 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD A0 FC FF FF 00 75 31 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 C0 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 6A 15 00 00 8B 55 10 52 8D 8D B4 FC FF FF E8 ?? ?? ?? ?? C6 85 DF FC FF FF 00 0F BE 85 DF FC FF FF 89 45 F0 8B 4D F0 89 4D F4 8B 55 0C 0F B7 02 85 C0 0F 84 91 14 00 00 6A 08 8B 4D 0C 66 8B 11 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 4E 8B 45 F0 83 E8 01 89 45 F0 8B 4D 08 51 8B 55 08 52 8D 45 F0 50 E8 ?? ?? ?? ?? 83 C4 08 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4D 0C 83 C1 02 89 4D 0C 8B 55 0C 66 8B 02 66 89 45 B8 6A 08 66 8B 4D B8 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 DA EB 8F 8B 55 0C 0F B7 02 83 F8 25 0F 85 9E 13 00 00 C7 85 A8 FC FF FF 00 00 00 00 66 C7 45 AC 00 00 C7 85 D4 FC FF FF 00 00 00 00 8B 8D D4 FC FF FF 89 8D D8 FC FF FF 8B 95 D8 FC FF FF 89 55 B4 C6 45 FA 00 8A 45 FA 88 45 FB 8A 4D FB 88 4D E7 8A 55 E7 88 55 DE 8A 45 DE 88 45 D7 C6 85 B3 FC FF FF 00 C6 45 DF 01 C7 45 D0 00 00 00 00 0F BE 4D DE 85 C9 0F 85 1D 02 00 00 8B 55 0C 83 C2 02 89 55 0C 8B 45 0C 0F B7 08 89 4D C4 0F B7 55 C4 81 E2 00 FF 00 00 75 3D 0F B7 45 C4 25 FF 00 00 00 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 27 8B 8D D8 FC FF FF 83 C1 01 89 8D D8 FC FF FF 8B 55 B4 8B 45 B4 8D 0C 90 8B 55 C4 8D 44 4A D0 89 45 B4 E9 BD 01 00 00 8B 4D C4 89 8D 88 FC FF FF 8B 95 88 FC FF FF 83 EA 2A 89 95 88 FC FF FF 83 BD 88 FC FF FF 4D 0F 87 8F 01 00 00 8B 85 88 FC FF FF 0F B6 88 ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? E9 7F 01 00 00 8A 55 DF 80 EA 01 88 55 DF 8A 85 B3 FC FF FF 2C 01 88 85 B3 FC FF FF E9 63 01 00 00 8B 4D 0C 0F B7 51 02 83 FA 36 75 3C 8B 45 0C 0F B7 48 04 83 F9 34 75 30 8B 55 0C 83 C2 04 89 55 0C 8B 45 D0 83 C0 01 89 45 D0 C7 85 C8 FC FF FF 00 00 00 00 C7 85 CC FC FF FF 00 00 00 00 E9 20 01 00 00 E9 8A 00 00 00 8B 4D 0C 0F B7 51 02 83 FA 33 75 1C 8B 45 0C 0F B7 48 04 83 F9 32 75 10 8B 55 0C 83 C2 04 89 55 0C E9 F5 00 00 00 EB 62 8B 45 0C 0F B7 48 02 83 F9 64 74 30 8B 55 0C 0F B7 42 02 83 F8 69 74 24 8B 4D 0C 0F B7 51 02 83 FA 6F 74 18 8B 45 0C 0F B7 48 02 83 F9 78 74 0C 8B 55 0C 0F B7 42 02 83 F8 58 75 26 33 C9 74 1D 8B 55 D0 83 C2 01 89 55 D0 C7 85 C8 FC FF FF 00 00 00 00 C7 85 CC FC FF FF 00 00 00 00 E9 91 00 00 00 33 C0 74 1D 8B 4D D0 83 C1 01 89 4D D0 C7 85 C8 FC FF FF 00 00 00 00 C7 85 CC FC FF FF 00 00 00 00 EB 65 8A 55 DF 80 C2 01 88 55 DF EB 63 8B 45 0C 0F B7 48 02 83 F9 6C 75 2A 8B 55 0C 83 C2 02 89 55 0C 8B 45 D0 83 C0 01 89 45 D0 C7 85 C8 FC FF FF 00 00 00 00 C7 85 CC FC FF FF 00 00 00 00 EB 2F EB 09 8A 4D DF 80 C1 01 88 4D DF 8A 95 B3 FC FF FF 80 C2 01 88 95 B3 FC FF FF EB 13 8A 45 E7 04 01 88 45 E7 EB 09 8A 4D DE 80 C1 01 88 4D DE E9 D7 FD FF FF 0F BE 55 E7 85 D2 75 1A 8B 45 14 89 45 E0 8B 4D 14 83 C1 04 89 4D 14 8B 55 14 8B 42 FC 89 45 B0 EB 07 C7 45 B0 00 00 00 00 C6 45 DE 00 0F BE 8D B3 FC FF FF 85 C9 75 35 8B 55 0C 0F B7 02 83 F8 53 74 0B 8B 4D 0C 0F B7 11 83 FA 43 75 10 8A 85 B3 FC FF FF 2C 01 88 85 B3 FC FF FF EB 0F 8A 8D B3 FC FF FF 80 C1 01 88 8D B3 FC FF FF 8B 55 0C 0F B7 02 83 C8 20 89 45 C4 83 7D C4 6E 74 41 83 7D C4 63 74 1F 83 7D C4 7B 74 19 8B 4D 08 51 8D 55 F0 52 E8 ?? ?? ?? ?? 83 C4 08 66 89 85 AC FC FF FF EB 1C 8B 45 F0 83 C0 01 89 45 F0 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 66 89 85 AC FC FF FF 83 7D C4 6E 74 14 0F B7 95 AC FC FF FF 81 FA FF FF 00 00 75 05 E9 BF 10 00 00 83 BD D8 FC FF FF 00 74 0A 83 7D B4 00 0F 84 FE 0F 00 00 8B 45 C4 89 85 84 FC FF FF 8B 8D 84 FC FF FF 83 E9 63 89 8D 84 FC FF FF 83 BD 84 FC FF FF 18 0F 87 78 0F 00 00 8B 95 84 FC FF FF 0F B6 82 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 83 BD D8 FC FF FF 00 75 18 8B 8D D8 FC FF FF 83 C1 01 89 8D D8 FC FF FF 8B 55 B4 83 C2 01 89 55 B4 0F BE 85 B3 FC FF FF 85 C0 7E 09 8A 4D D7 80 C1 01 88 4D D7 E9 EA 01 00 00 0F BE 95 B3 FC FF FF 85 D2 7E 08 8A 45 D7 04 01 88 45 D7 E9 D2 01 00 00 0F BE 8D B3 FC FF FF 85 C9 7E 09 8A 55 D7 80 C2 01 88 55 D7 8B 45 0C 83 C0 02 89 45 0C 8B 4D 0C 89 4D CC 8B 55 CC 0F B7 02 83 F8 5E 75 12 8B 4D CC 83 C1 02 89 4D CC 8A 55 FA 80 EA 01 88 55 FA 83 7D BC 00 75 2E 68 BA 02 00 00 68 ?? ?? ?? ?? 6A 02 68 00 20 00 00 E8 ?? ?? ?? ?? 83 C4 10 89 45 BC 83 7D BC 00 75 05 E9 B4 0F 00 00 C7 45 C8 01 00 00 00 68 00 20 00 00 6A 00 8B 45 BC 50 E8 ?? ?? ?? ?? 83 C4 0C 83 7D C4 7B 75 21 8B 4D CC 0F B7 11 83 FA 5D 75 16 66 C7 45 AC 5D 00 8B 45 CC 83 C0 02 89 45 CC 8B 4D BC C6 41 0B 20 8B 55 CC 0F B7 02 83 F8 5D 0F 84 FA 00 00 00 8B 4D CC 66 8B 11 66 89 55 A8 8B 45 CC 83 C0 02 89 45 CC 0F B7 4D A8 83 F9 2D 75 13 0F B7 55 AC 85 D2 74 0B 8B 45 CC 0F B7 08 83 F9 5D 75 38 66 8B 55 A8 66 89 55 AC 0F B7 45 AC C1 F8 03 0F B7 4D A8 83 E1 07 BA 01 00 00 00 D3 E2 8B 4D BC 0F BE 04 01 0B C2 0F B7 4D AC C1 F9 03 8B 55 BC 88 04 0A E9 8E 00 00 00 8B 45 CC 66 8B 08 66 89 4D A8 8B 55 CC 83 C2 02 89 55 CC 0F B7 45 AC 0F B7 4D A8 3B C1 7D 0A 66 8B 55 A8 66 89 55 E8 EB 10 66 8B 45 AC 66 89 45 E8 66 8B 4D A8 66 89 4D AC 66 8B 55 AC 66 89 55 A8 EB 0C 66 8B 45 A8 66 05 01 00 66 89 45 A8 0F B7 4D A8 0F B7 55 E8 3B CA 7F 2D 0F B7 45 A8 C1 F8 03 0F B7 4D A8 83 E1 07 BA 01 00 00 00 D3 E2 8B 4D BC 0F BE 04 01 0B C2 0F B7 4D A8 C1 F9 03 8B 55 BC 88 04 0A EB BB 66 C7 45 AC 00 00 E9 F7 FE FF FF 8B 45 CC 0F B7 08 85 C9 75 05 E9 5B 0E 00 00 83 7D C4 7B 75 06 8B 55 CC 89 55 0C 8B 45 B0 89 45 C0 8B 4D F0 83 E9 01 89 4D F0 8B 55 08 52 66 8B 85 AC FC FF FF 50 E8 ?? ?? ?? ?? 83 C4 08 83 BD D8 FC FF FF 00 74 14 8B 4D B4 8B 55 B4 83 EA 01 89 55 B4 85 C9 0F 84 4C 01 00 00 8B 45 F0 83 C0 01 89 45 F0 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 66 89 85 AC FC FF FF 0F B7 95 AC FC FF FF 81 FA FF FF 00 00 0F 84 F9 00 00 00 83 7D C4 63 74 64 83 7D C4 73 75 24 0F B7 85 AC FC FF FF 83 F8 09 7C 0C 0F B7 8D AC FC FF FF 83 F9 0D 7E 0C 0F B7 95 AC FC FF FF 83 FA 20 75 3A 83 7D C4 7B 0F 85 BF 00 00 00 0F B7 85 AC FC FF FF C1 F8 03 8B 4D BC 0F BE 14 01 0F BE 45 FA 33 D0 0F B7 8D AC FC FF FF 83 E1 07 B8 01 00 00 00 D3 E0 23 D0 0F 84 8F 00 00 00 0F BE 4D E7 85 C9 75 7C 0F BE 55 D7 85 D2 74 18 8B 45 B0 66 8B 8D AC FC FF FF 66 89 08 8B 55 B0 83 C2 02 89 55 B0 EB 5A C7 85 9C FC FF FF 00 00 00 00 6A 00 68 52 03 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 22 6A 16 66 8B 85 AC FC FF FF 50 6A 05 8B 4D B0 51 8D 95 9C FC FF FF 52 E8 ?? ?? ?? ?? 83 C4 10 50 E8 ?? ?? ?? ?? 83 C4 20 85 C0 75 0C 8B 45 B0 03 85 9C FC FF FF 89 45 B0 EB 09 8B 4D C0 83 C1 02 89 4D C0 EB 1F 8B 55 F0 83 EA 01 89 55 F0 8B 45 08 50 66 8B 8D AC FC FF FF 51 E8 ?? ?? ?? ?? 83 C4 08 EB 05 E9 97 FE FF FF 8B 55 C0 3B 55 B0 74 31 0F BE 45 E7 85 C0 75 27 8B 4D F4 83 C1 01 89 4D F4 83 7D C4 63 74 18 0F BE 55 D7 85 D2 74 0A 8B 45 B0 66 C7 00 00 00 EB 06 8B 4D B0 C6 01 00 EB 05 E9 85 0C 00 00 E9 C2 0B 00 00 C7 45 C4 64 00 00 00 0F B7 95 AC FC FF FF 83 FA 2D 75 0C 8A 45 FB 04 01 88 45 FB EB 0E EB 46 0F B7 8D AC FC FF FF 83 F9 2B 75 3A 8B 55 B4 83 EA 01 89 55 B4 75 13 83 BD D8 FC FF FF 00 74 0A 8A 45 DE 04 01 88 45 DE EB 1C 8B 4D F0 83 C1 01 89 4D F0 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 66 89 85 AC FC FF FF 0F B7 85 AC FC FF FF 83 F8 30 0F 85 DB 00 00 00 8B 4D F0 83 C1 01 89 4D F0 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 66 89 85 AC FC FF FF 0F B7 85 AC FC FF FF 83 F8 78 74 0C 0F B7 8D AC FC FF FF 83 F9 58 75 46 8B 55 F0 83 C2 01 89 55 F0 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 66 89 85 AC FC FF FF 83 BD D8 FC FF FF 00 74 18 8B 4D B4 83 E9 02 89 4D B4 83 7D B4 01 7D 09 8A 55 DE 80 C2 01 88 55 DE C7 45 C4 78 00 00 00 EB 61 8B 85 D4 FC FF FF 83 C0 01 89 85 D4 FC FF FF 83 7D C4 78 74 26 83 BD D8 FC FF FF 00 74 14 8B 4D B4 83 E9 01 89 4D B4 75 09 8A 55 DE 80 C2 01 88 55 DE C7 45 C4 6F 00 00 00 EB 26 8B 45 F0 83 E8 01 89 45 F0 8B 4D 08 51 66 8B 95 AC FC FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 66 C7 85 AC FC FF FF 30 00 EB 64 C6 45 DF 01 0F B7 85 AC FC FF FF 83 F8 2D 75 0D 8A 4D FB 80 C1 01 88 4D FB EB 0E EB 47 0F B7 95 AC FC FF FF 83 FA 2B 75 3B 8B 45 B4 83 E8 01 89 45 B4 75 14 83 BD D8 FC FF FF 00 74 0B 8A 4D DE 80 C1 01 88 4D DE EB 1C 8B 55 F0 83 C2 01 89 55 F0 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 66 89 85 AC FC FF FF 83 7D D0 00 0F 84 F2 01 00 00 0F BE 4D DE 85 C9 0F 85 BA 01 00 00 83 7D C4 78 74 06 83 7D C4 70 75 6E 0F B7 95 AC FC FF FF 81 E2 00 FF 00 00 75 51 0F B7 85 AC FC FF FF 25 FF 00 00 00 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 38 8B 85 C8 FC FF FF 8B 95 CC FC FF FF B1 04 E8 ?? ?? ?? ?? 89 85 C8 FC FF FF 89 95 CC FC FF FF 66 8B 8D AC FC FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 66 89 85 AC FC FF FF EB 09 8A 55 DE 80 C2 01 88 55 DE E9 A6 00 00 00 0F B7 85 AC FC FF FF 25 00 FF 00 00 0F 85 8B 00 00 00 0F B7 8D AC FC FF FF 81 E1 FF 00 00 00 51 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 71 83 7D C4 6F 75 37 0F B7 95 AC FC FF FF 83 FA 38 7D 21 8B 85 C8 FC FF FF 8B 95 CC FC FF FF B1 03 E8 ?? ?? ?? ?? 89 85 C8 FC FF FF 89 95 CC FC FF FF EB 08 8A 45 DE 04 01 88 45 DE EB 32 8B 85 C8 FC FF FF 8B 95 CC FC FF FF B1 02 E8 ?? ?? ?? ?? 03 85 C8 FC FF FF 13 95 CC FC FF FF B1 01 E8 ?? ?? ?? ?? 89 85 C8 FC FF FF 89 95 CC FC FF FF EB 09 8A 4D DE 80 C1 01 88 4D DE 0F BE 55 DE 85 D2 75 70 8B 85 D4 FC FF FF 83 C0 01 89 85 D4 FC FF FF 0F B7 85 AC FC FF FF 83 E8 30 99 03 85 C8 FC FF FF 8B 8D CC FC FF FF 13 CA 89 85 C8 FC FF FF 89 8D CC FC FF FF 83 BD D8 FC FF FF 00 74 15 8B 55 B4 83 EA 01 89 55 B4 75 0A 8A 45 DE 04 01 88 45 DE EB 1C 8B 4D F0 83 C1 01 89 4D F0 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 66 89 85 AC FC FF FF EB 1D 8B 45 F0 83 E8 01 89 45 F0 8B 4D 08 51 66 8B 95 AC FC FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 E9 3A FE FF FF 0F BE 45 FB 85 C0 74 1F 8B 8D C8 FC FF FF F7 D9 8B 95 CC FC FF FF 83 D2 00 F7 DA 89 8D C8 FC FF FF 89 95 CC FC FF FF E9 8E 01 00 00 0F BE 45 DE 85 C0 0F 85 6C 01 00 00 83 7D C4 78 74 06 83 7D C4 70 75 5C 0F B7 8D AC FC FF FF 81 E1 00 FF 00 00 75 42 0F B7 95 AC FC FF FF 81 E2 FF 00 00 00 52 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 28 8B 85 A8 FC FF FF C1 E0 04 89 85 A8 FC FF FF 66 8B 8D AC FC FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 66 89 85 AC FC FF FF EB 09 8A 55 DE 80 C2 01 88 55 DE EB 78 0F B7 85 AC FC FF FF 25 00 FF 00 00 75 61 0F B7 8D AC FC FF FF 81 E1 FF 00 00 00 51 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 47 83 7D C4 6F 75 28 0F B7 95 AC FC FF FF 83 FA 38 7D 11 8B 85 A8 FC FF FF C1 E0 03 89 85 A8 FC FF FF EB 09 8A 4D DE 80 C1 01 88 4D DE EB 17 8B 95 A8 FC FF FF 8B 85 A8 FC FF FF 8D 0C 90 D1 E1 89 8D A8 FC FF FF EB 09 8A 55 DE 80 C2 01 88 55 DE 0F BE 45 DE 85 C0 75 62 8B 8D D4 FC FF FF 83 C1 01 89 8D D4 FC FF FF 0F B7 95 AC FC FF FF 8B 85 A8 FC FF FF 8D 4C 10 D0 89 8D A8 FC FF FF 83 BD D8 FC FF FF 00 74 15 8B 55 B4 83 EA 01 89 55 B4 75 0A 8A 45 DE 04 01 88 45 DE EB 1C 8B 4D F0 83 C1 01 89 4D F0 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 66 89 85 AC FC FF FF EB 1D 8B 45 F0 83 E8 01 89 45 F0 8B 4D 08 51 66 8B 95 AC FC FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 E9 88 FE FF FF 0F BE 45 FB 85 C0 74 0E 8B 8D A8 FC FF FF F7 D9 89 8D A8 FC FF FF 83 7D C4 46 75 0A C7 85 D4 FC FF FF 00 00 00 00 83 BD D4 FC FF FF 00 74 51 0F BE 55 E7 85 D2 75 47 8B 45 F4 83 C0 01 89 45 F4 83 7D D0 00 74 16 8B 4D B0 8B 95 C8 FC FF FF 89 11 8B 85 CC FC FF FF 89 41 04 EB 22 0F BE 4D DF 85 C9 74 0D 8B 55 B0 8B 85 A8 FC FF FF 89 02 EB 0D 8B 4D B0 66 8B 95 A8 FC FF FF 66 89 11 EB 05 E9 D1 06 00 00 E9 0E 06 00 00 8B 45 F0 89 85 A8 FC FF FF 0F BE 4D E7 85 C9 75 02 EB A3 E9 F6 05 00 00 C7 45 EC 00 00 00 00 0F B7 95 AC FC FF FF 83 FA 2D 75 19 8B 45 EC 8B 4D A4 66 C7 04 41 2D 00 8B 55 EC 83 C2 01 89 55 EC EB 0E EB 31 0F B7 85 AC FC FF FF 83 F8 2B 75 25 8B 4D B4 83 E9 01 89 4D B4 8B 55 F0 83 C2 01 89 55 F0 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 66 89 85 AC FC FF FF 83 BD D8 FC FF FF 00 75 07 C7 45 B4 FF FF FF FF 0F B7 8D AC FC FF FF 81 E1 00 FF 00 00 0F 85 A4 00 00 00 0F B7 95 AC FC FF FF 81 E2 FF 00 00 00 52 E8 ?? ?? ?? ?? 83 C4 04 85 C0 0F 84 86 00 00 00 8B 45 B4 8B 4D B4 83 E9 01 89 4D B4 85 C0 74 76 8B 95 D4 FC FF FF 83 C2 01 }
	condition:
		$1
}

rule file_145_5_0 {
	meta:
		name = "___check_float_string"
		size = 241
		refs = "000f ??_C@_1DO@MBOKMJPK@?$AAn?$AAF?$AAl?$AAo?$AAa?$AAt?$AAS?$AAt?$AAr?$AAU?$AAs?$AAe?$AAd?$AA?$DM?$AA?$DN?$AA?$CI?$AA?$CK?$AAp?$AAn?$AAF?$AAl?$AAo?$AAa?$AAt?$AAS?$AAt?$AAr?$AAS?$AAz?$AA?$CJ?$AA?$AA@ 001b ??_C@_1GA@EKLPPGMG@?$AAf?$AA?3?$AA?2?$AAr?$AAt?$AAm?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2@ 0022 __CrtDbgReportW 004d ??_C@_0DA@ONFNIG@f?3?2rtm?2vctools?2crt_bld?2self_x86?2@ 005c __calloc_dbg 0090 _memcpy 00c0 __recalloc_dbg"
	strings:
		$1 = { 55 8B EC 51 8B 45 0C 8B 4D 08 3B 08 76 21 68 ?? ?? ?? ?? 6A 00 68 B6 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 8B 45 0C 8B 4D 08 3B 08 0F 85 AB 00 00 00 8B 55 10 8B 02 3B 45 14 75 5E 68 BB 00 00 00 68 ?? ?? ?? ?? 6A 02 6A 04 8B 4D 0C 8B 11 52 E8 ?? ?? ?? ?? 83 C4 14 8B 4D 10 89 01 8B 55 10 83 3A 00 75 04 33 C0 EB 79 8B 45 18 C7 00 01 00 00 00 8B 4D 0C 8B 11 D1 E2 52 8B 45 14 50 8B 4D 10 8B 11 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 0C 8B 08 D1 E1 8B 55 0C 89 0A EB 43 68 C5 00 00 00 68 ?? ?? ?? ?? 6A 02 6A 04 8B 45 0C 8B 08 51 8B 55 10 8B 02 50 E8 ?? ?? ?? ?? 83 C4 18 89 45 FC 83 7D FC 00 75 04 33 C0 EB 19 8B 4D 10 8B 55 FC 89 11 8B 45 0C 8B 08 D1 E1 8B 55 0C 89 0A B8 01 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_145_6_0 {
	meta:
		name = "__INTRN_LOCALE_CONV"
		size = 21
		refs = "0007 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ"
	strings:
		$1 = { 55 8B EC 8B 4D 08 E8 ?? ?? ?? ?? 8B 00 8B 80 BC 00 00 00 5D C3 }
	condition:
		$1
}

rule file_145_7_0 {
	meta:
		name = "__hextodec"
		size = 68
		refs = "001b _isdigit"
	strings:
		$1 = { 55 8B EC 51 0F B7 45 08 25 00 FF 00 00 75 20 0F B7 4D 08 81 E1 FF 00 00 00 51 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 09 0F B7 55 08 89 55 FC EB 0D 0F B7 45 08 83 E0 DF 83 E8 07 89 45 FC 66 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_145_9_0 {
	meta:
		name = "__un_inc"
		size = 33
		refs = "0018 __ungetwc_nolock"
	strings:
		$1 = { 55 8B EC 0F B7 45 08 3D FF FF 00 00 74 11 8B 4D 0C 51 66 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_145_10_0 {
	meta:
		name = "__whiteout"
		size = 74
		refs = "0016 __inc 0037 _iswctype"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 8B 08 83 C1 01 8B 55 08 89 0A 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 04 66 89 45 FC 0F B7 4D FC 81 F9 FF FF 00 00 75 02 EB 13 6A 08 66 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 C2 66 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_146_0_0 {
	meta:
		name = "__mbtowc_l"
		size = 536
		refs = "0040 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0048 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 006b ??_C@_1NC@EINCOKCO@?$AA_?$AAl?$AAo?$AAc?$AA_?$AAu?$AAp?$AAd?$AAa?$AAt?$AAe?$AA?4?$AAG?$AAe?$AAt?$AAL?$AAo?$AAc?$AAa?$AAl?$AAe?$AAT?$AA?$CI?$AA?$CJ?$AA?9?$AA?$DO?$AAl?$AAo?$AAc?$AAi?$AAn?$AAf@ 0074 ??_C@_1BC@MFKEFFNI@?$AAm?$AAb?$AAt?$AAo?$AAw?$AAc?$AA?4?$AAc?$AA?$AA@ 007b __CrtDbgReportW 00b6 ??1_LocaleUpdate@@QAE@XZ 00d3 __isleadbyte_l 013f __imp__MultiByteToWideChar@24 0168 __errno"
	strings:
		$1 = { 55 8B EC 83 EC 24 83 7D 0C 00 74 06 83 7D 10 00 75 07 33 C0 E9 FB 01 00 00 8B 45 0C 0F BE 08 85 C9 75 15 83 7D 08 00 74 08 8B 55 08 66 C7 02 00 00 33 C0 E9 DC 01 00 00 8B 45 14 50 8D 4D F0 E8 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? 8B 08 83 B9 AC 00 00 00 01 74 31 8D 4D F0 E8 ?? ?? ?? ?? 8B 10 83 BA AC 00 00 00 02 74 1E 68 ?? ?? ?? ?? 6A 00 6A 47 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 8D 4D F0 E8 ?? ?? ?? ?? 8B 08 83 79 14 00 75 2A 83 7D 08 00 74 0D 8B 55 0C 66 0F B6 02 8B 4D 08 66 89 01 C7 45 EC 01 00 00 00 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 EC E9 52 01 00 00 8D 4D F0 E8 ?? ?? ?? ?? 50 8B 55 0C 0F B6 02 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 0F 84 C9 00 00 00 8D 4D F0 E8 ?? ?? ?? ?? 8B 08 83 B9 AC 00 00 00 01 7E 52 8D 4D F0 E8 ?? ?? ?? ?? 8B 10 8B 45 10 3B 82 AC 00 00 00 7C 3D 33 C9 83 7D 08 00 0F 95 C1 51 8B 55 08 52 8D 4D F0 E8 ?? ?? ?? ?? 8B 00 8B 88 AC 00 00 00 51 8B 55 0C 52 6A 09 8D 4D F0 E8 ?? ?? ?? ?? 8B 00 8B 48 04 51 FF 15 ?? ?? ?? ?? 85 C0 75 42 8D 4D F0 E8 ?? ?? ?? ?? 8B 10 8B 45 10 3B 82 AC 00 00 00 72 0B 8B 4D 0C 0F BE 51 01 85 D2 75 22 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 C7 45 E8 FF FF FF FF 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 E8 E9 8B 00 00 00 8D 4D F0 E8 ?? ?? ?? ?? 8B 00 8B 88 AC 00 00 00 89 4D E4 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 E4 EB 6B EB 61 33 D2 83 7D 08 00 0F 95 C2 52 8B 45 08 50 6A 01 8B 4D 0C 51 6A 09 8D 4D F0 E8 ?? ?? ?? ?? 8B 10 8B 42 04 50 FF 15 ?? ?? ?? ?? 85 C0 75 1F E8 ?? ?? ?? ?? C7 00 2A 00 00 00 C7 45 E0 FF FF FF FF 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 E0 EB 1C C7 45 DC 01 00 00 00 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 DC EB 08 8D 4D F0 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_148_0_0 {
	meta:
		name = "__set_exp"
		size = 52
	strings:
		$1 = { 55 8B EC 83 EC 10 DD 45 08 DD 5D F0 8B 45 10 05 FE 03 00 00 89 45 FC 0F B7 4D 0E 81 E1 0F 80 00 00 8B 55 FC C1 E2 04 0B CA 66 89 4D F6 DD 45 F0 8B E5 5D C3 }
	condition:
		$1
}

rule file_148_1_0 {
	meta:
		name = "__get_exp"
		size = 42
	strings:
		$1 = { 55 8B EC 51 0F B7 45 0E 25 F0 7F 00 00 C1 F8 04 66 89 45 FC 0F BF 4D FC 81 E9 FE 03 00 00 66 89 4D FC 0F BF 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_148_2_0 {
	meta:
		name = "__add_exp"
		size = 48
		refs = "0027 __set_exp"
	strings:
		$1 = { 55 8B EC 0F B7 45 0E 25 F0 7F 00 00 C1 F8 04 0F BF C8 8B 55 10 8D 84 11 02 FC FF FF 50 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_148_3_0 {
	meta:
		name = "__set_bexp"
		size = 40
	strings:
		$1 = { 55 8B EC 83 EC 08 DD 45 08 DD 5D F8 0F B7 45 0E 25 0F 80 00 00 8B 4D 10 C1 E1 04 0B C1 66 89 45 FE DD 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_148_4_0 {
	meta:
		name = "__sptype"
		size = 113
	strings:
		$1 = { 55 8B EC 81 7D 0C 00 00 F0 7F 75 0D 83 7D 08 00 75 07 B8 01 00 00 00 EB 56 81 7D 0C 00 00 F0 FF 75 0D 83 7D 08 00 75 07 B8 02 00 00 00 EB 40 0F B7 45 0E 25 F8 7F 00 00 3D F8 7F 00 00 75 07 B8 03 00 00 00 EB 29 0F B7 4D 0E 81 E1 F8 7F 00 00 81 F9 F0 7F 00 00 75 15 8B 55 0C C1 E2 0D 75 06 83 7D 08 00 74 07 B8 04 00 00 00 EB 02 33 C0 5D C3 }
	condition:
		$1
}

rule file_148_5_0 {
	meta:
		name = "__decomp"
		size = 283
		refs = "00d2 __set_exp"
	strings:
		$1 = { 55 8B EC 83 EC 18 D9 EE DC 5D 08 DF E0 F6 C4 44 7A 11 D9 EE DD 5D F0 C7 45 FC 00 00 00 00 E9 E9 00 00 00 0F B7 45 0E 25 F0 7F 00 00 0F 85 AC 00 00 00 8B 4D 0C C1 E1 0C 75 0A 83 7D 08 00 0F 84 9A 00 00 00 C7 45 FC 03 FC FF FF D9 EE DC 5D 08 DF E0 F6 C4 41 75 09 C7 45 E8 01 00 00 00 EB 07 C7 45 E8 00 00 00 00 8B 55 E8 89 55 EC 0F B7 45 0E 83 E0 10 75 2F 8B 4D 0C D1 E1 89 4D 0C 8B 55 08 81 E2 00 00 00 80 74 09 8B 45 0C 83 C8 01 89 45 0C 8B 4D 08 D1 E1 89 4D 08 8B 55 FC 83 EA 01 89 55 FC EB C8 0F B7 45 0E 25 EF FF 00 00 66 89 45 0E 83 7D EC 00 74 0E 0F B7 4D 0E 81 C9 00 80 00 00 66 89 4D 0E 6A 00 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 0C DD 5D F0 EB 2E 6A 00 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 0C DD 5D F0 0F B7 55 0E 81 E2 F0 7F 00 00 C1 FA 04 0F BF C2 2D FE 03 00 00 89 45 FC 8B 4D 10 8B 55 FC 89 11 DD 45 F0 8B E5 5D C3 }
	condition:
		$1
}

rule file_149_1_0 {
	meta:
		name = "__wcslwr"
		size = 211
		refs = "0008 ___locale_changed 0026 ??_C@_1BK@HMILBCB@?$AAw?$AAs?$AAr?$AAc?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 002f ??_C@_1BC@PFKIBEFL@?$AAw?$AAc?$AAs?$AAl?$AAw?$AAr?$AA?4?$AAc?$AA?$AA@ 0036 __CrtDbgReportW 004a __errno 005e ??_C@_1BA@MILCGCII@?$AA_?$AAw?$AAc?$AAs?$AAl?$AAw?$AAr?$AA?$AA@ 0068 __invalid_parameter 00c0 __wcslwr_s_l"
	strings:
		$1 = { 55 8B EC 83 EC 08 83 3D ?? ?? ?? ?? 00 0F 85 A4 00 00 00 33 C0 83 7D 08 00 0F 95 C0 89 45 F8 83 7D F8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 40 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F8 00 75 2A E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 40 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 5C 8B 55 08 89 55 FC EB 09 8B 45 FC 83 C0 02 89 45 FC 8B 4D FC 0F B7 11 85 D2 74 27 8B 45 FC 0F B7 08 83 F9 41 7C 1A 8B 55 FC 0F B7 02 83 F8 5A 7F 0F 8B 4D FC 0F B7 11 83 C2 20 8B 45 FC 66 89 10 EB C6 EB 15 6A 00 6A FF 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 08 EB 03 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_149_6_0 {
	meta:
		name = "?_wcslwr_s_l_stat@@YAHPA_WIPAUlocaleinfo_struct@@@Z"
		size = 1066
		refs = "0020 ??_C@_1BK@HMILBCB@?$AAw?$AAs?$AAr?$AAc?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0029 ??_C@_1BC@PFKIBEFL@?$AAw?$AAc?$AAs?$AAl?$AAw?$AAr?$AA?4?$AAc?$AA?$AA@ 0030 __CrtDbgReportW 0044 __errno 0058 ??_C@_1CC@EJPJEJKL@?$AA_?$AAw?$AAc?$AAs?$AAl?$AAw?$AAr?$AA_?$AAs?$AA_?$AAl?$AA_?$AAs?$AAt?$AAa?$AAt?$AA?$AA@ 0062 __invalid_parameter 007c _wcsnlen 00b7 ___crtDebugFillThreshold 00e4 _memset 00ec ??_C@_1DM@FHLMIEG@?$AAS?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AAi?$AAs?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAn?$AAu?$AAl?$AAl?$AA?5?$AAt?$AAe?$AAr?$AAm?$AAi?$AAn?$AAa?$AAt?$AAe?$AAd?$AA?$AA@ 0115 ??_C@_1FA@MJKDNFFB@?$AA?$CI?$AAL?$AA?$CC?$AAS?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AAi?$AAs?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAn?$AAu?$AAl?$AAl?$AA?5?$AAt?$AAe?$AAr?$AAm?$AAi?$AAn?$AAa?$AAt?$AAe?$AAd@ 0245 ___crtLCMapStringW 02d2 ??_C@_1CI@HCPHDDLE@?$AAB?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AAi?$AAs?$AA?5?$AAt?$AAo?$AAo?$AA?5?$AAs?$AAm?$AAa?$AAl?$AAl?$AA?$AA@ 02fb ??_C@_1DM@MADKGDLO@?$AA?$CI?$AAL?$AA?$CC?$AAB?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AAi?$AAs?$AA?5?$AAt?$AAo?$AAo?$AA?5?$AAs?$AAm?$AAa?$AAl?$AAl?$AA?$CC?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA0?$AA?$CJ?$AA?$AA@ 037b _malloc 0384 __MarkAllocaS 03f9 _wcscpy_s 041c __freea"
	strings:
		$1 = { 55 8B EC 83 EC 38 C7 45 F4 00 00 00 00 33 C0 83 7D 08 00 0F 95 C0 89 45 E8 83 7D E8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 71 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E8 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 71 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 B3 03 00 00 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 EC 8B 4D EC 3B 4D 0C 0F 82 D6 00 00 00 8B 55 08 66 C7 02 00 00 83 7D 0C FF 74 4B 81 7D 0C FF FF FF 7F 74 42 83 7D 0C 01 76 3C 8B 45 0C 83 E8 01 39 05 ?? ?? ?? ?? 73 0B 8B 0D ?? ?? ?? ?? 89 4D DC EB 09 8B 55 0C 83 EA 01 89 55 DC 8B 45 DC D1 E0 50 68 FD 00 00 00 8B 4D 08 83 C1 02 51 E8 ?? ?? ?? ?? 83 C4 0C BA ?? ?? ?? ?? 85 D2 74 0D 33 C0 74 09 C7 45 D8 01 00 00 00 EB 07 C7 45 D8 00 00 00 00 8B 4D D8 89 4D E4 83 7D E4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 76 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E4 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 76 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 BE 02 00 00 83 7D 0C FF 74 5D 81 7D 0C FF FF FF 7F 74 54 8B 45 EC 83 C0 01 3B 45 0C 73 49 8B 4D EC 83 C1 01 8B 55 0C 2B D1 39 15 ?? ?? ?? ?? 73 0A A1 ?? ?? ?? ?? 89 45 D4 EB 0E 8B 4D EC 83 C1 01 8B 55 0C 2B D1 89 55 D4 8B 45 D4 D1 E0 50 68 FD 00 00 00 8B 4D EC 8B 55 08 8D 44 4A 02 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D 10 8B 11 83 7A 14 00 75 49 8B 45 08 89 45 FC EB 09 8B 4D FC 83 C1 02 89 4D FC 8B 55 FC 0F B7 02 85 C0 74 27 8B 4D FC 0F B7 11 83 FA 41 7C 1A 8B 45 FC 0F B7 08 83 F9 5A 7F 0F 8B 55 FC 0F B7 02 83 C0 20 8B 4D FC 66 89 01 EB C6 33 C0 E9 07 02 00 00 8B 55 10 8B 02 8B 48 04 51 6A 00 6A 00 6A FF 8B 55 08 52 68 00 01 00 00 8B 45 10 8B 08 8B 51 14 52 8B 45 10 50 E8 ?? ?? ?? ?? 83 C4 20 89 45 F8 83 7D F8 00 75 17 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 E8 ?? ?? ?? ?? 8B 00 E9 BA 01 00 00 8B 4D 0C 3B 4D F8 0F 83 DC 00 00 00 8B 55 08 66 C7 02 00 00 83 7D 0C FF 74 4B 81 7D 0C FF FF FF 7F 74 42 83 7D 0C 01 76 3C 8B 45 0C 83 E8 01 39 05 ?? ?? ?? ?? 73 0B 8B 0D ?? ?? ?? ?? 89 4D D0 EB 09 8B 55 0C 83 EA 01 89 55 D0 8B 45 D0 D1 E0 50 68 FD 00 00 00 8B 4D 08 83 C1 02 51 E8 ?? ?? ?? ?? 83 C4 0C BA ?? ?? ?? ?? 85 D2 74 0D 33 C0 74 09 C7 45 CC 01 00 00 00 EB 07 C7 45 CC 00 00 00 00 8B 4D CC 89 4D E0 83 7D E0 00 75 21 68 ?? ?? ?? ?? 6A 00 68 9A 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 33 E8 ?? ?? ?? ?? C7 00 22 00 00 00 6A 00 68 9A 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 22 00 00 00 E9 D2 00 00 00 83 7D F8 00 7E 36 33 C0 75 32 B8 E0 FF FF FF 33 D2 F7 75 F8 83 F8 02 72 23 68 DD DD 00 00 8B 4D F8 8D 54 09 08 52 E8 ?? ?? ?? ?? 83 C4 04 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 C8 EB 07 C7 45 C8 00 00 00 00 8B 45 C8 89 45 F0 83 7D F0 00 75 14 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E8 ?? ?? ?? ?? 8B 00 EB 6F 8B 4D 10 8B 11 8B 42 04 50 8B 4D F8 51 8B 55 F0 52 6A FF 8B 45 08 50 68 00 01 00 00 8B 4D 10 8B 11 8B 42 14 50 8B 4D 10 51 E8 ?? ?? ?? ?? 83 C4 20 85 C0 74 19 8B 55 F0 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F4 EB 12 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 C7 45 F4 2A 00 00 00 8B 55 F0 52 E8 ?? ?? ?? ?? 83 C4 04 8B 45 F4 8B E5 5D C3 }
	condition:
		$1
}

rule file_150_0_0 {
	meta:
		name = "__getdiskfree"
		size = 351
		refs = "001a ??_C@_1BM@OEMNMLPL@?$AA?$CI?$AAp?$AAd?$AAf?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0023 ??_C@_1BG@NIALMNFL@?$AAd?$AAr?$AAi?$AAv?$AAf?$AAr?$AAe?$AAe?$AA?4?$AAc?$AA?$AA@ 002a __CrtDbgReportW 003e __errno 0052 ??_C@_1BK@HDMOFHIE@?$AA_?$AAg?$AAe?$AAt?$AAd?$AAi?$AAs?$AAk?$AAf?$AAr?$AAe?$AAe?$AA?$AA@ 005c __invalid_parameter 0080 ??_C@_1CC@HLCKLIG@?$AA?$CI?$AA?5?$AAu?$AAD?$AAr?$AAi?$AAv?$AAe?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AA2?$AA6?$AA?5?$AA?$CJ?$AA?$AA@ 00dc _memset 012d __imp__GetDiskFreeSpaceA@20 0137 __imp__GetLastError@0 0143 __get_errno_from_oserr"
	strings:
		$1 = { 55 8B EC 83 EC 14 56 33 C0 83 7D 0C 00 0F 95 C0 89 45 F4 83 7D F4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 2D 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F4 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 2D 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 57 00 00 00 E9 ED 00 00 00 BA 1A 00 00 00 3B 55 08 1B C0 83 C0 01 89 45 F0 75 1E 68 ?? ?? ?? ?? 6A 00 6A 2E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 2E 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 57 00 00 00 E9 87 00 00 00 6A 10 6A 00 8B 55 0C 52 E8 ?? ?? ?? ?? 83 C4 0C 83 7D 08 00 75 09 C7 45 F8 00 00 00 00 EB 1C 8D 45 FC 89 45 F8 0F BE 4D 08 83 C1 40 88 4D FC C6 45 FD 3A C6 45 FE 5C C6 45 FF 00 8B 55 0C 52 8B 45 0C 83 C0 04 50 8B 4D 0C 83 C1 0C 51 8B 55 0C 83 C2 08 52 8B 45 F8 50 FF 15 ?? ?? ?? ?? 85 C0 75 23 FF 15 ?? ?? ?? ?? 89 45 EC 8B 4D EC 51 E8 ?? ?? ?? ?? 83 C4 04 8B F0 E8 ?? ?? ?? ?? 89 30 8B 45 EC EB 02 33 C0 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_151_0_0 {
	meta:
		name = "?_JumpToContinuation@@YGXPAXPAUEHRegistrationNode@@@Z"
		size = 50
	strings:
		$1 = { 55 8B EC 51 53 8B 45 0C 83 C0 0C 89 45 FC 64 8B 1D 00 00 00 00 8B 03 64 A3 00 00 00 00 8B 45 08 8B 5D 0C 8B 6D FC 8B 63 FC FF E0 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_151_4_0 {
	meta:
		name = "?_UnwindNestedFrames@@YGXPAUEHRegistrationNode@@PAUEHExceptionRecord@@@Z"
		size = 88
		refs = "0016 $ReturnPoint$23582 0029 _RtlUnwind@16"
	strings:
		$1 = { 55 8B EC 83 EC 08 53 56 57 64 8B 35 00 00 00 00 89 75 FC C7 45 F8 ?? ?? ?? ?? 6A 00 8B 45 0C 50 8B 4D F8 51 8B 55 08 52 E8 ?? ?? ?? ?? 8B 45 0C 8B 48 04 83 E1 FD 8B 55 0C 89 4A 04 64 8B 3D 00 00 00 00 8B 5D FC 89 3B 64 89 1D 00 00 00 00 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_151_5_0 {
	meta:
		name = "___CxxFrameHandler"
		size = 60
		refs = "0028 ___InternalCxxFrameHandler"
		altNames = "___CxxFrameHandler2 ___CxxFrameHandler3"
	strings:
		$1 = { 55 8B EC 83 EC 08 53 56 57 FC 89 45 F8 6A 00 6A 00 6A 00 8B 45 F8 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 20 89 45 FC 5F 5E 5B 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_151_8_0 {
	meta:
		name = "___CxxLongjmpUnwind@4"
		size = 38
		refs = "001b ___FrameUnwindToState"
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 48 1C 51 8B 55 08 8B 42 28 50 6A 00 8B 4D 08 8B 51 18 52 E8 ?? ?? ?? ?? 83 C4 10 5D C2 04 00 }
	condition:
		$1
}

rule file_151_9_0 {
	meta:
		name = "?_CallCatchBlock2@@YAPAXPAUEHRegistrationNode@@PBU_s_FuncInfo@@PAXHK@Z"
		size = 108
		refs = "0010 ?CatchGuardHandler@@YA?AW4_EXCEPTION_DISPOSITION@@PAUEHExceptionRecord@@PAUCatchGuardRN@@PAX2@Z 0015 ___security_cookie 0055 __CallSettingFrame@12"
	strings:
		$1 = { 55 8B EC 83 EC 1C C7 45 E8 00 00 00 00 C7 45 EC ?? ?? ?? ?? A1 ?? ?? ?? ?? 8D 4D E8 33 C1 89 45 F0 8B 55 0C 89 55 F4 8B 45 08 89 45 F8 8B 4D 14 83 C1 01 89 4D FC 64 A1 00 00 00 00 89 45 E8 8D 45 E8 64 A3 00 00 00 00 8B 55 18 52 8B 45 08 50 8B 4D 10 51 E8 ?? ?? ?? ?? 89 45 E4 8B 45 E8 64 A3 00 00 00 00 8B 45 E4 8B E5 5D C3 }
	condition:
		$1
}

rule file_151_10_0 {
	meta:
		name = "?CatchGuardHandler@@YA?AW4_EXCEPTION_DISPOSITION@@PAUEHExceptionRecord@@PAUCatchGuardRN@@PAX2@Z"
		size = 74
		refs = "000f @__security_check_cookie@4 0039 ___InternalCxxFrameHandler"
	strings:
		$1 = { 55 8B EC 51 FC 8B 45 0C 8B 48 08 33 4D 0C E8 ?? ?? ?? ?? 6A 00 8B 4D 0C 51 8B 55 0C 8B 42 14 50 8B 4D 0C 8B 51 0C 52 6A 00 8B 45 10 50 8B 4D 0C 8B 51 10 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 20 89 45 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_151_11_0 {
	meta:
		name = "?_CallSETranslator@@YAHPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAX2PBU_s_FuncInfo@@H1@Z"
		size = 234
		refs = "0011 $ExceptionContinuation$23700 002e ?TranslatorGuardHandler@@YA?AW4_EXCEPTION_DISPOSITION@@PAUEHExceptionRecord@@PAUTranslatorGuardRN@@PAX2@Z 0033 ___security_cookie 0098 __getptd"
	strings:
		$1 = { 55 8B EC 83 EC 38 53 81 7D 08 23 01 00 00 75 14 B8 ?? ?? ?? ?? 8B 4D 0C 89 01 B8 01 00 00 00 E9 C1 00 00 00 C7 45 D8 00 00 00 00 C7 45 DC ?? ?? ?? ?? A1 ?? ?? ?? ?? 8D 4D D8 33 C1 89 45 E0 8B 55 18 89 55 E4 8B 45 0C 89 45 E8 8B 4D 1C 89 4D EC 8B 55 20 89 55 F0 C7 45 F4 00 00 00 00 C7 45 F8 00 00 00 00 C7 45 FC 00 00 00 00 89 65 F4 89 6D F8 64 A1 00 00 00 00 89 45 D8 8D 45 D8 64 A3 00 00 00 00 C7 45 C8 01 00 00 00 8B 45 08 89 45 CC 8B 4D 10 89 4D D0 E8 ?? ?? ?? ?? 8B 90 80 00 00 00 89 55 D4 8D 45 CC 50 8B 4D 08 8B 11 52 FF 55 D4 83 C4 08 C7 45 C8 00 00 00 00 83 7D FC 00 74 17 64 8B 1D 00 00 00 00 8B 03 8B 5D D8 89 03 64 89 1D 00 00 00 00 EB 09 8B 45 D8 64 A3 00 00 00 00 8B 45 C8 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_151_12_0 {
	meta:
		name = "?TranslatorGuardHandler@@YA?AW4_EXCEPTION_DISPOSITION@@PAUEHExceptionRecord@@PAUTranslatorGuardRN@@PAX2@Z"
		size = 171
		refs = "0010 @__security_check_cookie@4 005b ___InternalCxxFrameHandler 0074 ?_UnwindNestedFrames@@YGXPAUEHRegistrationNode@@PAUEHExceptionRecord@@@Z 008c ?_CallSETranslator@@YAHPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAX2PBU_s_FuncInfo@@H1@Z"
	strings:
		$1 = { 55 8B EC 51 53 FC 8B 45 0C 8B 48 08 33 4D 0C E8 ?? ?? ?? ?? 8B 4D 08 8B 51 04 83 E2 66 74 13 8B 45 0C C7 40 24 01 00 00 00 B8 01 00 00 00 EB 76 EB 74 6A 01 8B 4D 0C 8B 51 18 52 8B 45 0C 8B 48 14 51 8B 55 0C 8B 42 0C 50 6A 00 8B 4D 10 51 8B 55 0C 8B 42 10 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 20 8B 55 0C 83 7A 24 00 75 0D 8B 45 08 50 8B 4D 0C 51 E8 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 6A 00 8D 55 FC 52 68 23 01 00 00 E8 ?? ?? ?? ?? 83 C4 1C 8B 45 FC 8B 5D 0C 8B 63 1C 8B 6B 20 FF E0 B8 01 00 00 00 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_151_13_0 {
	meta:
		name = "?_GetRangeOfTrysToCheck@@YAPBU_s_TryBlockMapEntry@@PBU_s_FuncInfo@@HHPAI1@Z"
		size = 133
		refs = "0026 ?_inconsistency@@YAXXZ"
	strings:
		$1 = { 55 8B EC 51 83 7D 0C 00 8B 45 08 8B 48 10 53 56 8B 70 0C 57 89 4D FC 8B FE 8B DE 7C 3D 8D 49 00 83 FE FF 75 05 E8 ?? ?? ?? ?? 8B 45 FC 8B 4D 10 83 EE 01 8D 14 B6 39 4C 90 04 8D 04 90 7D 05 3B 48 08 7E 05 83 FE FF 75 08 83 6D 0C 01 8B FB 8B DE 83 7D 0C 00 7D C9 8B 45 08 8B 4D 14 8B 55 18 83 C6 01 89 31 89 3A 3B 78 0C 77 04 3B F7 76 05 E8 ?? ?? ?? ?? 8B 4D FC 5F 8D 04 B6 5E 8D 04 81 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_151_14_0 {
	meta:
		name = "__CreateFrameInfo"
		size = 42
		refs = "000d __getptd"
	strings:
		$1 = { 55 8B EC 8B 45 0C 56 8B 75 08 89 06 E8 ?? ?? ?? ?? 8B 88 98 00 00 00 89 4E 04 E8 ?? ?? ?? ?? 89 B0 98 00 00 00 8B C6 5E 5D C3 }
	condition:
		$1
}

rule file_151_15_0 {
	meta:
		name = "__IsExceptionObjectToBeDestroyed"
		size = 43
		refs = "0004 __getptd"
	strings:
		$1 = { 55 8B EC E8 ?? ?? ?? ?? 8B 80 98 00 00 00 85 C0 74 0E 8B 4D 08 39 08 74 0E 8B 40 04 85 C0 75 F5 B8 01 00 00 00 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_151_16_0 {
	meta:
		name = "__FindAndUnlinkFrame"
		size = 85
		refs = "0005 __getptd 0048 ?_inconsistency@@YAXXZ"
	strings:
		$1 = { 55 8B EC 56 E8 ?? ?? ?? ?? 8B 75 08 3B B0 98 00 00 00 75 11 E8 ?? ?? ?? ?? 8B 4E 04 89 88 98 00 00 00 5E 5D C3 E8 ?? ?? ?? ?? 8B 80 98 00 00 00 83 78 04 00 74 0F 8B 48 04 3B F1 74 0F 8B C1 83 78 04 00 75 F1 5E 5D E9 ?? ?? ?? ?? 8B 56 04 89 50 04 5E 5D C3 }
	condition:
		$1
}

rule file_152_0_0 {
	meta:
		name = "__CIexp_pentium4"
		size = 704
		refs = "0026 cv 002e Shifter 00ab Tbl_addr 00cf mmask 00db bias 0146 emask 0205 ___libm_error_support 0239 XMAX 024c XMIN 0278 INF 027f ZERO 02a8 ONE_val"
	strings:
		$1 = { 55 8B EC 83 EC 08 83 E4 F0 DD 1C 24 F3 0F 7E 04 24 E8 08 00 00 00 C9 C3 66 0F 12 44 24 04 66 0F 14 C0 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F C5 C0 03 25 FF 7F 00 00 BA 8F 40 00 00 2B D0 2D 90 3C 00 00 0B D0 81 FA 00 00 00 80 0F 83 28 02 00 00 66 0F 59 C8 66 0F 58 CE 66 0F 28 F9 66 0F 5C CE 66 0F 59 D1 66 0F 28 25 ?? ?? ?? ?? 66 0F 59 D9 66 0F 28 2D ?? ?? ?? ?? 66 0F 5C C2 66 0F 7E F8 8B C8 83 E1 3F C1 E1 04 C1 F8 06 8B D0 66 0F 5C C3 66 0F 28 91 ?? ?? ?? ?? 66 0F 59 E0 66 0F 28 C8 66 0F 59 C0 66 0F 58 EC F2 0F 59 C0 F2 0F 58 CA 66 0F 15 D2 66 0F 6F 35 ?? ?? ?? ?? 66 0F DB FE 66 0F 6F 35 ?? ?? ?? ?? 66 0F D4 FE 66 0F 73 F7 2E 66 0F 59 C5 F2 0F 58 C8 66 0F 56 D7 66 0F 15 C0 F2 0F 58 C1 81 C2 7E 03 00 00 81 FA 7C 07 00 00 77 19 F2 0F 59 C2 83 EC 10 F2 0F 58 C2 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 83 EC 12 9B D9 7C 24 10 66 8B 54 24 10 66 81 CA 00 03 66 89 14 24 D9 2C 24 8B D0 D1 F8 2B D0 66 0F 6F 35 ?? ?? ?? ?? 66 0F DF F2 05 FF 03 00 00 66 0F 6E D8 66 0F 73 F3 34 66 0F 56 F3 81 C2 FF 03 00 00 66 0F 6E E2 66 0F 73 F4 34 66 0F 13 04 24 DD 04 24 66 0F 13 74 24 08 DD 44 24 08 DC C9 DE C1 66 0F 13 24 24 DD 04 24 DE C9 DD 1C 24 66 0F 12 04 24 D9 6C 24 10 83 C4 12 66 0F C5 C8 03 81 E1 F0 7F 00 00 81 F9 F0 7F 00 00 73 27 83 F9 00 74 29 EB 5A 81 F9 00 00 00 80 72 18 81 F9 2B 23 86 C0 72 4A 77 15 8B 54 24 04 81 FA EF 39 FA FE 72 3C EB 07 BA 0E 00 00 00 EB 05 BA 0F 00 00 00 83 EC 1C 66 0F 13 44 24 10 89 54 24 0C 8B D4 83 C2 10 89 54 24 08 83 C2 10 89 54 24 04 89 14 24 E8 ?? ?? ?? ?? 66 0F 12 44 24 10 83 C4 1C 83 EC 10 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 3D 00 00 F0 7F 73 31 8B 44 24 08 3D 00 00 00 80 73 13 66 0F 12 05 ?? ?? ?? ?? F2 0F 59 C0 BA 0E 00 00 00 EB 9C 66 0F 12 05 ?? ?? ?? ?? F2 0F 59 C0 BA 0F 00 00 00 EB 89 8B 54 24 04 3D 00 00 F0 7F 77 1E 83 FA 00 75 19 8B 44 24 08 3D 00 00 F0 7F 75 07 DD 05 ?? ?? ?? ?? C3 DD 05 ?? ?? ?? ?? C3 BA EA 03 00 00 E9 56 FF FF FF 8B 44 24 08 25 FF FF FF 7F 3D 00 00 90 40 73 85 66 0F 12 44 24 04 F2 0F 58 05 ?? ?? ?? ?? 83 EC 10 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 8D 49 00 }
	condition:
		$1
}

rule file_153_0_0 {
	meta:
		name = "__close"
		size = 524
		refs = "0006 __sehtable$__close 000b __except_handler4 001d ___security_cookie 0037 ___doserrno 0042 __errno 005f __nhandle 0082 ??_C@_1FO@LPCLHKGE@?$AA?$CI?$AAf?$AAh?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AAu?$AAn?$AAs?$AAi?$AAg?$AAn?$AAe?$AAd?$AA?$CJ?$AAf?$AAh?$AA?5?$AA?$DM?$AA?5?$AA?$CI?$AAu?$AAn?$AAs?$AAi@ 008b ??_C@_1BA@GOGDMMEN@?$AAc?$AAl?$AAo?$AAs?$AAe?$AA?4?$AAc?$AA?$AA@ 0092 __CrtDbgReportW 00c5 ??_C@_1O@EDEJGJBM@?$AA_?$AAc?$AAl?$AAo?$AAs?$AAe?$AA?$AA@ 00cf __invalid_parameter 00f0 ___pioinfo 0108 ??_C@_1CM@OKGMMMDH@?$AA?$CI?$AA_?$AAo?$AAs?$AAf?$AAi?$AAl?$AAe?$AA?$CI?$AAf?$AAh?$AA?$CJ?$AA?5?$AA?$CG?$AA?5?$AAF?$AAO?$AAP?$AAE?$AAN?$AA?$CJ?$AA?$AA@ 0169 ___lock_fhandle 019c __close_nolock 01bf ??_C@_1JE@ECKHFIFP@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAf?$AAi?$AAl?$AAe?$AA?5?$AAd?$AAe?$AAs?$AAc?$AAr?$AAi?$AAp?$AAt?$AAo?$AAr?$AA?4?$AA?5?$AAF?$AAi?$AAl?$AAe?$AA?5@ 01ef __unlock_fhandle"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 E8 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 83 7D 08 FE 75 1E E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 C8 FF E9 A6 01 00 00 83 7D 08 00 7C 14 8B 45 08 3B 05 ?? ?? ?? ?? 73 09 C7 45 D8 01 00 00 00 EB 07 C7 45 D8 00 00 00 00 8B 4D D8 89 4D E0 83 7D E0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 2F 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 39 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 6A 00 6A 2F 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 1C 01 00 00 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F 6B C9 28 8B 14 85 ?? ?? ?? ?? 0F BE 44 0A 04 83 E0 01 F7 D8 1B C0 F7 D8 89 45 DC 75 1E 68 ?? ?? ?? ?? 6A 00 6A 30 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D DC 00 75 39 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 6A 00 6A 30 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 96 00 00 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F 6B C9 28 8B 14 85 ?? ?? ?? ?? 0F BE 44 0A 04 83 E0 01 74 11 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 E4 EB 34 E8 ?? ?? ?? ?? C7 00 09 00 00 00 C7 45 E4 FF FF FF FF 33 D2 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3A 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0D 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 E4 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_153_1_0 {
	meta:
		name = "__close_nolock"
		size = 199
		refs = "000a __get_osfhandle 001e ___pioinfo 0068 __imp__CloseHandle@4 007b __imp__GetLastError@0 0087 __free_osfhnd 00b4 __dosmaperr"
	strings:
		$1 = { 55 8B EC 51 56 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 83 F8 FF 74 5A 83 7D 08 01 75 0F 8B 0D ?? ?? ?? ?? 0F BE 51 54 83 E2 01 75 14 83 7D 08 02 75 28 A1 ?? ?? ?? ?? 0F BE 48 2C 83 E1 01 74 1A 6A 01 E8 ?? ?? ?? ?? 83 C4 04 8B F0 6A 02 E8 ?? ?? ?? ?? 83 C4 04 3B F0 74 17 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 50 FF 15 ?? ?? ?? ?? 85 C0 74 09 C7 45 FC 00 00 00 00 EB 09 FF 15 ?? ?? ?? ?? 89 45 FC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F 6B D2 28 8B 04 8D ?? ?? ?? ?? C6 44 10 04 00 83 7D FC 00 74 11 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 83 C8 FF EB 02 33 C0 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_154_0_0 {
	meta:
		name = "__wchartodigit"
		size = 800
	strings:
		$1 = { 55 8B EC 0F B7 45 08 83 F8 30 7D 08 83 C8 FF E9 0A 03 00 00 0F B7 4D 08 83 F9 3A 7D 0C 0F B7 45 08 83 E8 30 E9 F5 02 00 00 0F B7 55 08 81 FA 10 FF 00 00 0F 8D CB 02 00 00 0F B7 45 08 3D 60 06 00 00 7D 08 83 C8 FF E9 D2 02 00 00 0F B7 4D 08 81 F9 6A 06 00 00 7D 0E 0F B7 45 08 2D 60 06 00 00 E9 B8 02 00 00 0F B7 55 08 81 FA F0 06 00 00 7D 08 83 C8 FF E9 A4 02 00 00 0F B7 45 08 3D FA 06 00 00 7D 0E 0F B7 45 08 2D F0 06 00 00 E9 8B 02 00 00 0F B7 4D 08 81 F9 66 09 00 00 7D 08 83 C8 FF E9 77 02 00 00 0F B7 55 08 81 FA 70 09 00 00 7D 0E 0F B7 45 08 2D 66 09 00 00 E9 5D 02 00 00 0F B7 45 08 3D E6 09 00 00 7D 08 83 C8 FF E9 4A 02 00 00 0F B7 4D 08 81 F9 F0 09 00 00 7D 0E 0F B7 45 08 2D E6 09 00 00 E9 30 02 00 00 0F B7 55 08 81 FA 66 0A 00 00 7D 08 83 C8 FF E9 1C 02 00 00 0F B7 45 08 3D 70 0A 00 00 7D 0E 0F B7 45 08 2D 66 0A 00 00 E9 03 02 00 00 0F B7 4D 08 81 F9 E6 0A 00 00 7D 08 83 C8 FF E9 EF 01 00 00 0F B7 55 08 81 FA F0 0A 00 00 7D 0E 0F B7 45 08 2D E6 0A 00 00 E9 D5 01 00 00 0F B7 45 08 3D 66 0B 00 00 7D 08 83 C8 FF E9 C2 01 00 00 0F B7 4D 08 81 F9 70 0B 00 00 7D 0E 0F B7 45 08 2D 66 0B 00 00 E9 A8 01 00 00 0F B7 55 08 81 FA 66 0C 00 00 7D 08 83 C8 FF E9 94 01 00 00 0F B7 45 08 3D 70 0C 00 00 7D 0E 0F B7 45 08 2D 66 0C 00 00 E9 7B 01 00 00 0F B7 4D 08 81 F9 E6 0C 00 00 7D 08 83 C8 FF E9 67 01 00 00 0F B7 55 08 81 FA F0 0C 00 00 7D 0E 0F B7 45 08 2D E6 0C 00 00 E9 4D 01 00 00 0F B7 45 08 3D 66 0D 00 00 7D 08 83 C8 FF E9 3A 01 00 00 0F B7 4D 08 81 F9 70 0D 00 00 7D 0E 0F B7 45 08 2D 66 0D 00 00 E9 20 01 00 00 0F B7 55 08 81 FA 50 0E 00 00 7D 08 83 C8 FF E9 0C 01 00 00 0F B7 45 08 3D 5A 0E 00 00 7D 0E 0F B7 45 08 2D 50 0E 00 00 E9 F3 00 00 00 0F B7 4D 08 81 F9 D0 0E 00 00 7D 08 83 C8 FF E9 DF 00 00 00 0F B7 55 08 81 FA DA 0E 00 00 7D 0E 0F B7 45 08 2D D0 0E 00 00 E9 C5 00 00 00 0F B7 45 08 3D 20 0F 00 00 7D 08 83 C8 FF E9 B2 00 00 00 0F B7 4D 08 81 F9 2A 0F 00 00 7D 0E 0F B7 45 08 2D 20 0F 00 00 E9 98 00 00 00 0F B7 55 08 81 FA 40 10 00 00 7D 08 83 C8 FF E9 84 00 00 00 0F B7 45 08 3D 4A 10 00 00 7D 0B 0F B7 45 08 2D 40 10 00 00 EB 6E 0F B7 4D 08 81 F9 E0 17 00 00 7D 05 83 C8 FF EB 5D 0F B7 55 08 81 FA EA 17 00 00 7D 0B 0F B7 45 08 2D E0 17 00 00 EB 46 0F B7 45 08 3D 10 18 00 00 7D 05 83 C8 FF EB 36 0F B7 4D 08 81 F9 1A 18 00 00 7D 0B 0F B7 45 08 2D 10 18 00 00 EB 1F 83 C8 FF EB 1A 0F B7 55 08 81 FA 1A FF 00 00 7D 0B 0F B7 45 08 2D 10 FF 00 00 EB 03 83 C8 FF 5D C3 }
	condition:
		$1
}

rule file_155_0_0 {
	meta:
		name = "__wspawnlpe"
		size = 457
		refs = "0019 ??_C@_1CC@JBMDNKJP@?$AAf?$AAi?$AAl?$AAe?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0022 ??_C@_1GG@JBCIODJA@?$AAf?$AA?3?$AA?2?$AAr?$AAt?$AAm?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2@ 0029 __CrtDbgReportW 003d __errno 0051 ??_C@_1BG@DEELLFKC@?$AA_?$AAw?$AAs?$AAp?$AAa?$AAw?$AAn?$AAl?$AAp?$AAe?$AA?$AA@ 005b __invalid_parameter 007c ??_C@_1CM@DMCMCPME@?$AA?$CK?$AAf?$AAi?$AAl?$AAe?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 00e0 ??_C@_1CA@MOAFCHEI@?$AAa?$AAr?$AAg?$AAl?$AAi?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0143 ??_C@_1CK@PKCLGCC@?$AA?$CK?$AAa?$AAr?$AAg?$AAl?$AAi?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 01be __wspawnvpe"
	strings:
		$1 = { 55 8B EC 83 EC 14 33 C0 83 7D 0C 00 0F 95 C0 89 45 F8 83 7D F8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3B 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F8 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 3B 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 5B 01 00 00 8B 55 0C 0F B7 02 F7 D8 1B C0 F7 D8 89 45 F4 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3C 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F4 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 3C 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 F8 00 00 00 33 D2 83 7D 10 00 0F 95 C2 89 55 F0 83 7D F0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3D 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 3D 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 94 00 00 00 8B 4D 10 0F B7 11 F7 DA 1B D2 F7 DA 89 55 EC 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D EC 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 3E 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 34 8D 4D 10 89 4D FC 8B 55 FC 8B 02 8B 4D FC 83 C1 04 89 4D FC 85 C0 74 02 EB EC 8B 55 FC 8B 02 50 8D 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_156_0_0 {
	meta:
		name = "_acos"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __acos_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_726_0_0 {
	meta:
		name = "_asin"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __asin_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_430_0_0 {
	meta:
		name = "_atan"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __atan_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_445_0_0 {
	meta:
		name = "_cos"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __cos_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_654_0_0 {
	meta:
		name = "_log"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __log_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_687_0_0 {
	meta:
		name = "_log10"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __log10_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_363_0_0 {
	meta:
		name = "_sin"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __sin_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_328_0_0 {
	meta:
		name = "_tan"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __tan_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_156_1_0 {
	meta:
		name = "__CIacos"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIacos_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_726_1_0 {
	meta:
		name = "__CIasin"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIasin_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_430_1_0 {
	meta:
		name = "__CIatan"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIatan_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_445_1_0 {
	meta:
		name = "__CIcos"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIcos_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_654_1_0 {
	meta:
		name = "__CIlog"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIlog_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_687_1_0 {
	meta:
		name = "__CIlog10"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIlog10_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_595_1_0 {
	meta:
		name = "__CIpow"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIpow_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_363_1_0 {
	meta:
		name = "__CIsin"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIsin_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_328_1_0 {
	meta:
		name = "__CItan"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CItan_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_156_2_0 {
	meta:
		name = "__CIacos_default"
		size = 203
		refs = "0007 __checkTOS_withFB 0019 __fload_withFB 002d __load_CW 004a ___fastflag 0051 __fast_exit 005c _NAME_ 0061 __math_exit 008b __convertTOStoQNaN 00a3 __indefinite 00c5 __startOneArgErrorHandling"
	strings:
		$1 = { 83 EC 0C DD 14 24 E8 ?? ?? ?? ?? E8 0D 00 00 00 83 C4 0C C3 8D 54 24 04 E8 ?? ?? ?? ?? 52 9B D9 3C 24 74 6D 66 81 3C 24 7F 02 74 05 E8 ?? ?? ?? ?? 3D 00 00 F0 3F 73 2D D9 E8 D8 C1 D9 E8 D8 E2 DE C9 D9 FA D9 C9 D9 F3 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 0D 00 00 00 8D 0D ?? ?? ?? ?? E9 ?? ?? ?? ?? 77 38 8B 44 24 0C 8B C8 25 FF FF 0F 00 0B 44 24 08 75 27 81 E1 00 00 00 80 DD D8 74 04 D9 EB EB C2 D9 EE EB BE E8 ?? ?? ?? ?? EB 1B A9 FF FF 0F 00 75 F2 83 7C 24 08 00 75 EB DD D8 DB 2D ?? ?? ?? ?? B8 01 00 00 00 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 0D 00 00 00 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule file_157_0_0 {
	meta:
		name = "___libm_setusermatherr"
		size = 50
		refs = "000b __pmatherr_set 001a __encode_pointer 0022 __pmatherr"
	strings:
		$1 = { 55 8B EC 83 7D 08 00 75 0C C7 05 ?? ?? ?? ?? 00 00 00 00 EB 1B 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 A3 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 01 00 00 00 5D C3 }
	condition:
		$1
}

rule file_157_1_0 {
	meta:
		name = "___libm_error_support"
		size = 2864
		refs = "0007 ___security_cookie 00d2 __pmatherr_set 00da __pmatherr 00e0 __decode_pointer 00ef __matherr 0131 $LN63 0138 $LN64 0157 $LN65 0165 ??_C@_03MGHMBJCF@log?$AA@ 0190 __errno 01fd ??_C@_05HGHHAHAP@log10?$AA@ 0295 ??_C@_03KHJOGHMM@exp?$AA@ 031e ??_C@_03JGHBODFD@pow?$AA@ 0474 __real@3ff0000000000000 04c5 ??_C@_04FIHNOPOL@asin?$AA@ 0511 ??_C@_04PDIFKINK@acos?$AA@ 055d ??_C@_05EOHGHCHD@exp10?$AA@ 06bd ??_C@_04MLLJIGOK@atan?$AA@ 0719 ??_C@_04GFPJNGEK@ceil?$AA@ 0775 ??_C@_05PBJFFIGL@floor?$AA@ 081d ??_C@_04EHEDPDJG@modf?$AA@ 0911 ??_C@_03BLEJJJBH@sin?$AA@ 096a ??_C@_03LALBNOCG@cos?$AA@ 09c0 ??_C@_03IIINPABG@tan?$AA@ 0a10 @__security_check_cookie@4 0a18 $LN55 0a1c $LN53 0a20 $LN51 0a24 $LN49 0a28 $LN47 0a2c $LN45 0a30 $LN42 0a34 $LN40 0a38 $LN43 0a3c $LN38 0a40 $LN36 0a44 $LN34 0a48 $LN30 0a4c $LN32 0a50 $LN28 0a54 $LN56 0b00 $LN24 0b04 $LN22 0b08 $LN20 0b0c $LN18 0b10 $LN16 0b14 $LN14 0b18 $LN12 0b1c $LN10 0b20 $LN8 0b24 $LN6 0b28 $LN4 0b2c $LN2"
	strings:
		$1 = { 55 8B EC 83 EC 60 A1 ?? ?? ?? ?? 33 C5 89 45 FC C6 45 DC 00 C6 45 DD 00 C6 45 DE 00 C6 45 DF 00 C6 45 E0 00 C6 45 E1 00 C6 45 E2 F0 C6 45 E3 7F C6 45 E4 FF C6 45 E5 FF C6 45 E6 FF C6 45 E7 FF C6 45 E8 FF C6 45 E9 FF C6 45 EA EF C6 45 EB 7F C6 45 EC 00 C6 45 ED 00 C6 45 EE 00 C6 45 EF 00 C6 45 F0 00 C6 45 F1 00 C6 45 F2 00 C6 45 F3 00 C6 45 A8 00 C6 45 A9 00 C6 45 AA 00 C6 45 AB 00 C6 45 AC 00 C6 45 AD 00 C6 45 AE F0 C6 45 AF FF C6 45 F4 FF C6 45 F5 FF C6 45 F6 FF C6 45 F7 FF C6 45 F8 FF C6 45 F9 FF C6 45 FA EF C6 45 FB FF C6 45 D0 00 C6 45 D1 00 C6 45 D2 00 C6 45 D3 00 C6 45 D4 00 C6 45 D5 00 C6 45 D6 00 C6 45 D7 80 83 3D ?? ?? ?? ?? 00 74 13 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 A4 EB 07 C7 45 A4 ?? ?? ?? ?? 8B 4D A4 89 4D D8 8B 55 14 89 55 A0 81 7D A0 E8 03 00 00 7F 34 81 7D A0 E8 03 00 00 0F 84 8A 04 00 00 8B 45 A0 83 E8 02 89 45 A0 81 7D A0 A4 00 00 00 0F 87 DF 08 00 00 8B 4D A0 0F B6 91 ?? ?? ?? ?? FF 24 95 ?? ?? ?? ?? 8B 45 A0 2D E9 03 00 00 89 45 A0 83 7D A0 0B 0F 87 B9 08 00 00 8B 4D A0 FF 24 8D ?? ?? ?? ?? C7 45 B0 02 00 00 00 C7 45 B4 ?? ?? ?? ?? 8B 55 08 DD 02 DD 5D B8 8B 45 0C DD 00 DD 5D C0 8B 4D 10 DD 01 DD 5D C8 8D 55 B0 52 FF 55 D8 83 C4 04 85 C0 75 0B E8 ?? ?? ?? ?? C7 00 22 00 00 00 8B 45 10 DD 45 C8 DD 18 E9 63 08 00 00 C7 45 B0 01 00 00 00 C7 45 B4 ?? ?? ?? ?? 8B 4D 08 DD 01 DD 5D B8 8B 55 0C DD 02 DD 5D C0 8B 45 10 DD 00 DD 5D C8 8D 4D B0 51 FF 55 D8 83 C4 04 85 C0 75 0B E8 ?? ?? ?? ?? C7 00 21 00 00 00 8B 55 10 DD 45 C8 DD 1A E9 17 08 00 00 C7 45 B0 02 00 00 00 C7 45 B4 ?? ?? ?? ?? 8B 45 08 DD 00 DD 5D B8 8B 4D 0C DD 01 DD 5D C0 8B 55 10 DD 02 DD 5D C8 8D 45 B0 50 FF 55 D8 83 C4 04 85 C0 75 0B E8 ?? ?? ?? ?? C7 00 22 00 00 00 8B 4D 10 DD 45 C8 DD 19 E9 CB 07 00 00 C7 45 B0 01 00 00 00 C7 45 B4 ?? ?? ?? ?? 8B 55 08 DD 02 DD 5D B8 8B 45 0C DD 00 DD 5D C0 8B 4D 10 DD 01 DD 5D C8 8D 55 B0 52 FF 55 D8 83 C4 04 85 C0 75 0B E8 ?? ?? ?? ?? C7 00 21 00 00 00 8B 45 10 DD 45 C8 DD 18 E9 7F 07 00 00 C7 45 B0 03 00 00 00 C7 45 B4 ?? ?? ?? ?? 8B 4D 08 DD 01 DD 5D B8 8B 55 0C DD 02 DD 5D C0 8B 45 10 DD 00 DD 5D C8 8D 4D B0 51 FF 55 D8 83 C4 04 85 C0 75 0B E8 ?? ?? ?? ?? C7 00 22 00 00 00 8B 55 10 DD 45 C8 DD 1A E9 33 07 00 00 C7 45 B0 04 00 00 00 C7 45 B4 ?? ?? ?? ?? 8B 45 08 DD 00 DD 5D B8 8B 4D 0C DD 01 DD 5D C0 8B 55 10 DD 02 DD 5D C8 8D 45 B0 50 FF 55 D8 83 C4 04 8B 4D 10 DD 45 C8 DD 19 E9 F6 06 00 00 C7 45 B0 01 00 00 00 C7 45 B4 ?? ?? ?? ?? 8B 55 10 D9 E8 DD 1A E9 DC 06 00 00 C7 45 B0 03 00 00 00 C7 45 B4 ?? ?? ?? ?? 8B 45 08 DD 00 DD 5D B8 8B 4D 0C DD 01 DD 5D C0 8B 55 10 DD 02 DD 5D C8 8D 45 B0 50 FF 55 D8 83 C4 04 85 C0 75 0B E8 ?? ?? ?? ?? C7 00 22 00 00 00 8B 4D 10 DD 45 C8 DD 19 E9 90 06 00 00 C7 45 B0 04 00 00 00 C7 45 B4 ?? ?? ?? ?? 8B 55 08 DD 02 DD 5D B8 8B 45 0C DD 00 DD 5D C0 8B 4D 10 DD 01 DD 5D C8 8D 55 B0 52 FF 55 D8 83 C4 04 8B 45 10 DD 45 C8 DD 18 E9 53 06 00 00 C7 45 B0 02 00 00 00 C7 45 B4 ?? ?? ?? ?? 8B 4D 08 DD 01 DD 5D B8 8B 55 0C DD 02 DD 5D C0 8B 45 10 DD 00 DD 5D C8 8D 4D B0 51 FF 55 D8 83 C4 04 85 C0 75 0B E8 ?? ?? ?? ?? C7 00 22 00 00 00 8B 55 10 DD 45 C8 DD 1A E9 07 06 00 00 C7 45 B0 01 00 00 00 C7 45 B4 ?? ?? ?? ?? 8B 45 08 DD 00 DD 5D B8 8B 4D 0C DD 01 DD 5D C0 8B 55 10 DD 02 DD 5D C8 8D 45 B0 50 FF 55 D8 83 C4 04 85 C0 75 0B E8 ?? ?? ?? ?? C7 00 21 00 00 00 8B 4D 10 DD 45 C8 DD 19 E9 BB 05 00 00 C7 45 B0 01 00 00 00 C7 45 B4 ?? ?? ?? ?? 8B 55 08 DD 02 DD 5D B8 8B 45 0C DD 00 DD 5D B8 8B 4D 08 DD 01 DC 0D ?? ?? ?? ?? 8B 55 10 DD 1A 8B 45 08 DD 00 DD 5D B8 8B 4D 0C DD 01 DD 5D C0 8B 55 10 DD 02 DD 5D C8 8D 45 B0 50 FF 55 D8 83 C4 04 85 C0 75 0B E8 ?? ?? ?? ?? C7 00 21 00 00 00 8B 4D 10 DD 45 C8 DD 19 E9 4F 05 00 00 C7 45 B0 01 00 00 00 C7 45 B4 ?? ?? ?? ?? 8B 55 08 DD 02 DD 5D B8 8B 45 0C DD 00 DD 5D C0 8B 4D 10 DD 01 DD 5D C8 8D 55 B0 52 FF 55 D8 83 C4 04 85 C0 75 0B E8 ?? ?? ?? ?? C7 00 21 00 00 00 8B 45 10 DD 45 C8 DD 18 E9 03 05 00 00 C7 45 B0 01 00 00 00 C7 45 B4 ?? ?? ?? ?? 8B 4D 08 DD 01 DD 5D B8 8B 55 0C DD 02 DD 5D C0 8B 45 10 DD 00 DD 5D C8 8D 4D B0 51 FF 55 D8 83 C4 04 85 C0 75 0B E8 ?? ?? ?? ?? C7 00 21 00 00 00 8B 55 10 DD 45 C8 DD 1A E9 B7 04 00 00 C7 45 B0 03 00 00 00 C7 45 B4 ?? ?? ?? ?? 8B 45 08 DD 00 DD 5D B8 8B 4D 0C DD 01 DD 5D C0 8B 55 10 DD 02 DD 5D C8 8D 45 B0 50 FF 55 D8 83 C4 04 85 C0 75 0B E8 ?? ?? ?? ?? C7 00 22 00 00 00 8B 4D 10 DD 45 C8 DD 19 E9 6B 04 00 00 C7 45 B0 01 00 00 00 C7 45 B4 ?? ?? ?? ?? 8B 55 08 DD 02 DC 0D ?? ?? ?? ?? 8B 45 10 DD 18 8B 4D 08 DD 01 DD 5D B8 8B 55 0C DD 02 DD 5D C0 8B 45 10 DD 00 DD 5D C8 8D 4D B0 51 FF 55 D8 83 C4 04 85 C0 75 0B E8 ?? ?? ?? ?? C7 00 21 00 00 00 8B 55 10 DD 45 C8 DD 1A E9 0F 04 00 00 C7 45 B0 01 00 00 00 C7 45 B4 ?? ?? ?? ?? 8B 45 08 DD 00 DC 0D ?? ?? ?? ?? 8B 4D 10 DD 19 8B 55 08 DD 02 DD 5D B8 8B 45 0C DD 00 DD 5D C0 8B 4D 10 DD 01 DD 5D C8 8D 55 B0 52 FF 55 D8 83 C4 04 85 C0 75 0B E8 ?? ?? ?? ?? C7 00 21 00 00 00 8B 45 10 DD 45 C8 DD 18 E9 B3 03 00 00 C7 45 B0 01 00 00 00 C7 45 B4 ?? ?? ?? ?? 8B 4D 08 DD 01 DC 0D ?? ?? ?? ?? 8B 55 10 DD 1A 8B 45 08 DD 00 DD 5D B8 8B 4D 0C DD 01 DD 5D C0 8B 55 10 DD 02 DD 5D C8 8D 45 B0 50 FF 55 D8 83 C4 04 85 C0 75 0B E8 ?? ?? ?? ?? C7 00 21 00 00 00 8B 4D 10 DD 45 C8 DD 19 E9 57 03 00 00 C7 45 B0 01 00 00 00 C7 45 B4 ?? ?? ?? ?? 8B 55 08 DD 02 DC 0D ?? ?? ?? ?? 8B 45 10 DD 18 8B 4D 08 DD 01 DD 5D B8 8B 55 0C DD 02 DD 5D C0 8B 45 10 DD 00 DD 5D C8 8D 4D B0 51 FF 55 D8 83 C4 04 85 C0 75 0B E8 ?? ?? ?? ?? C7 00 21 00 00 00 8B 55 10 DD 45 C8 DD 1A E9 FB 02 00 00 C7 45 B0 01 00 00 00 C7 45 B4 ?? ?? ?? ?? 8B 45 08 DD 00 DC 0D ?? ?? ?? ?? 8B 4D 10 DD 19 8B 55 08 DD 02 DD 5D B8 8B 45 0C DD 00 DD 5D C0 8B 4D 10 DD 01 DD 5D C8 8D 55 B0 52 FF 55 D8 83 C4 04 85 C0 75 0B E8 ?? ?? ?? ?? C7 00 21 00 00 00 8B 45 10 DD 45 C8 DD 18 E9 9F 02 00 00 C7 45 B0 01 00 00 00 C7 45 B4 ?? ?? ?? ?? 8B 4D 08 DD 01 DC 0D ?? ?? ?? ?? 8B 55 10 DD 1A 8B 45 08 DD 00 DD 5D B8 8B 4D 0C DD 01 DD 5D C0 8B 55 10 DD 02 DD 5D C8 8D 45 B0 50 FF 55 D8 83 C4 04 85 C0 75 0B E8 ?? ?? ?? ?? C7 00 21 00 00 00 8B 4D 10 DD 45 C8 DD 19 E9 43 02 00 00 C7 45 B0 01 00 00 00 C7 45 B4 ?? ?? ?? ?? 8B 55 08 DD 02 DD 5D B8 8B 45 0C DD 00 DD 5D C0 8B 4D 10 DD 01 DD 5D C8 8D 55 B0 52 FF 55 D8 83 C4 04 85 C0 75 0B E8 ?? ?? ?? ?? C7 00 21 00 00 00 8B 45 10 DD 45 C8 DD 18 E9 F7 01 00 00 C7 45 B0 01 00 00 00 C7 45 B4 ?? ?? ?? ?? 8B 4D 08 DD 01 DC 0D ?? ?? ?? ?? 8B 55 10 DD 1A 8B 45 08 DD 00 DD 5D B8 8B 4D 0C DD 01 DD 5D C0 8B 55 10 DD 02 DD 5D C8 8D 45 B0 50 FF 55 D8 83 C4 04 85 C0 75 0B E8 ?? ?? ?? ?? C7 00 21 00 00 00 8B 4D 10 DD 45 C8 DD 19 E9 9B 01 00 00 C7 45 B0 01 00 00 00 C7 45 B4 ?? ?? ?? ?? 8B 55 08 DD 02 DD 5D B8 8B 45 0C DD 00 DD 5D C0 8B 4D 10 DD 01 DD 5D C8 8D 55 B0 52 FF 55 D8 83 C4 04 85 C0 75 0B E8 ?? ?? ?? ?? C7 00 21 00 00 00 8B 45 10 DD 45 C8 DD 18 E9 4F 01 00 00 C7 45 B0 01 00 00 00 C7 45 B4 ?? ?? ?? ?? 8B 4D 08 DD 01 DD 5D B8 8B 55 0C DD 02 DD 5D C0 8B 45 10 DD 00 DD 5D C8 8D 4D B0 51 FF 55 D8 83 C4 04 85 C0 75 0B E8 ?? ?? ?? ?? C7 00 21 00 00 00 8B 55 10 DD 45 C8 DD 1A E9 03 01 00 00 C7 45 B0 01 00 00 00 C7 45 B4 ?? ?? ?? ?? 8B 45 08 DD 00 DC 4D EC 8B 4D 10 DD 19 8B 55 08 DD 02 DD 5D B8 8B 45 0C DD 00 DD 5D C0 8B 4D 10 DD 01 DD 5D C8 8D 55 B0 52 FF 55 D8 83 C4 04 85 C0 75 0B E8 ?? ?? ?? ?? C7 00 21 00 00 00 8B 45 10 DD 45 C8 DD 18 E9 AA 00 00 00 C7 45 B0 01 00 00 00 C7 45 B4 ?? ?? ?? ?? 8B 4D 08 DD 01 DC 4D EC 8B 55 10 DD 1A 8B 45 08 DD 00 DD 5D B8 8B 4D 0C DD 01 DD 5D C0 8B 55 10 DD 02 DD 5D C8 8D 45 B0 50 FF 55 D8 83 C4 04 85 C0 75 0B E8 ?? ?? ?? ?? C7 00 21 00 00 00 8B 4D 10 DD 45 C8 DD 19 EB 54 C7 45 B0 01 00 00 00 C7 45 B4 ?? ?? ?? ?? 8B 55 08 DD 02 DC 4D EC 8B 45 10 DD 18 8B 4D 08 DD 01 DD 5D B8 8B 55 0C DD 02 DD 5D C0 8B 45 10 DD 00 DD 5D C8 8D 4D B0 51 FF 55 D8 83 C4 04 85 C0 75 0B E8 ?? ?? ?? ?? C7 00 21 00 00 00 8B 55 10 DD 45 C8 DD 1A 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 01 0F 0F 0F 0F 02 03 0F 0F 0F 0F 04 05 0F 0F 0F 0F 0F 0F 0F 0F 06 07 08 09 0A 0B 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0C 0F 0F 0D 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0F 0E 8D 49 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_158_0_0 {
	meta:
		name = "__CIsin_pentium4"
		size = 456
		refs = "0039 PI32INV 0045 SHIFTER 0055 P_1 0061 P_2 007e SC_4 0084 Ctable 0099 P_3 00be SC_2 0103 SC_3 010f SC_1 018a ALL_ONES 01a0 TWO_POW_55 01b0 TWO_POW_M55 01c3 __sin_default"
	strings:
		$1 = { 55 8B EC 83 EC 08 83 E4 F0 DD 1C 24 F3 0F 7E 04 24 E8 08 00 00 00 C9 C3 66 0F 12 44 24 04 66 0F C5 C0 03 66 25 FF 7F 66 2D 30 30 66 3D C5 10 0F 87 42 01 00 00 66 0F 12 0D ?? ?? ?? ?? F2 0F 59 C8 66 0F 12 15 ?? ?? ?? ?? F2 0F 2D D1 F2 0F 58 CA 66 0F 12 1D ?? ?? ?? ?? F2 0F 5C CA 66 0F 28 15 ?? ?? ?? ?? F2 0F 59 D9 66 0F 14 C9 81 C2 00 76 1C 00 F2 0F 10 E0 83 E2 3F 66 0F 28 2D ?? ?? ?? ?? 8D 05 ?? ?? ?? ?? C1 E2 05 03 C2 66 0F 59 D1 F2 0F 5C C3 F2 0F 59 0D ?? ?? ?? ?? F2 0F 5C E3 66 0F 12 78 08 66 0F 14 C0 F2 0F 10 DC F2 0F 5C E2 66 0F 59 E8 66 0F 5C C2 66 0F 28 35 ?? ?? ?? ?? F2 0F 59 FC F2 0F 5C DC 66 0F 59 E8 66 0F 59 C0 F2 0F 5C DA 66 0F 28 10 F2 0F 5C CB 66 0F 12 58 18 F2 0F 58 D3 F2 0F 5C FA F2 0F 59 D4 66 0F 59 F0 F2 0F 59 DC 66 0F 59 D0 66 0F 59 C0 66 0F 58 2D ?? ?? ?? ?? F2 0F 59 20 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 E8 F2 0F 10 C3 F2 0F 58 58 08 66 0F 59 CF F2 0F 10 FC F2 0F 58 E3 66 0F 58 F5 66 0F 12 68 08 F2 0F 5C EB F2 0F 5C DC F2 0F 58 48 10 66 0F 59 F2 F2 0F 58 E8 F2 0F 58 DF F2 0F 58 CD F2 0F 58 CB F2 0F 58 CE 66 0F 15 F6 F2 0F 58 CE 83 EC 10 F2 0F 58 E1 66 0F 13 64 24 04 DD 44 24 04 83 C4 10 C3 7F 49 83 EC 10 66 C1 E8 04 66 3D FD 0C 75 16 F2 0F 59 05 ?? ?? ?? ?? 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 66 0F 12 1D ?? ?? ?? ?? F2 0F 59 D8 F2 0F 5C D8 F2 0F 59 1D ?? ?? ?? ?? 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_159_0_0 {
	meta:
		name = "__mbsnbicoll_l"
		size = 570
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0023 ??1_LocaleUpdate@@QAE@XZ 0042 ??_C@_1BG@MODEICJK@?$AAs?$AA1?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 004b ??_C@_1BG@MHEMLGJO@?$AAm?$AAb?$AAs?$AAn?$AAb?$AAi?$AAc?$AAo?$AA?4?$AAc?$AA?$AA@ 0052 __CrtDbgReportW 0066 __errno 007a ??_C@_1BM@FKNNDAHH@?$AA_?$AAm?$AAb?$AAs?$AAn?$AAb?$AAi?$AAc?$AAo?$AAl?$AAl?$AA_?$AAl?$AA?$AA@ 0084 __invalid_parameter 00b5 ??_C@_1BG@GBJNMPFA@?$AAs?$AA2?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0128 ??_C@_1BK@CMPKHPEC@?$AAn?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAI?$AAN?$AAT?$AA_?$AAM?$AAA?$AAX?$AA?$AA@ 018c ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 01aa __strnicoll_l 01fe ___crtCompareStringA"
	strings:
		$1 = { 55 8B EC 83 EC 3C 8B 45 14 50 8D 4D EC E8 ?? ?? ?? ?? 83 7D 10 00 75 17 C7 45 DC 00 00 00 00 8D 4D EC E8 ?? ?? ?? ?? 8B 45 DC E9 07 02 00 00 33 C9 83 7D 08 00 0F 95 C1 89 4D E8 83 7D E8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3D 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E8 00 75 3D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 3D 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 D8 FF FF FF 7F 8D 4D EC E8 ?? ?? ?? ?? 8B 45 D8 E9 94 01 00 00 33 C0 83 7D 0C 00 0F 95 C0 89 45 E4 83 7D E4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E4 00 75 3D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 3E 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 D4 FF FF FF 7F 8D 4D EC E8 ?? ?? ?? ?? 8B 45 D4 E9 21 01 00 00 BA FF FF FF 7F 3B 55 10 1B C0 83 C0 01 89 45 E0 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3F 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 3D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 3F 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 D0 FF FF FF 7F 8D 4D EC E8 ?? ?? ?? ?? 8B 45 D0 E9 AE 00 00 00 8D 4D EC E8 ?? ?? ?? ?? 8B 50 04 83 7A 08 00 75 28 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 CC 8D 4D EC E8 ?? ?? ?? ?? 8B 45 CC EB 75 8D 4D EC E8 ?? ?? ?? ?? 8B 48 04 8B 51 04 52 8B 45 10 50 8B 4D 0C 51 8B 55 10 52 8B 45 08 50 68 01 10 00 00 8D 4D EC E8 ?? ?? ?? ?? 8B 48 04 8B 51 0C 52 8D 4D EC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 20 89 45 FC 83 7D FC 00 75 14 C7 45 C8 FF FF FF 7F 8D 4D EC E8 ?? ?? ?? ?? 8B 45 C8 EB 14 8B 45 FC 83 E8 02 89 45 C4 8D 4D EC E8 ?? ?? ?? ?? 8B 45 C4 8B E5 5D C3 }
	condition:
		$1
}

rule file_161_0_0 {
	meta:
		name = "??2@YAPAXI@Z"
		size = 126
		refs = "000b _malloc 0020 __callnewh 002d ?$S1@?5???2@YAPAXI@Z@4IA 0044 ?nomem@?5???2@YAPAXI@Z@4Vbad_alloc@std@@B 0049 ??0bad_alloc@std@@QAE@XZ 004e ??__Fnomem@?5???2@YAPAXI@Z@YAXXZ 0053 _atexit 0063 ??0bad_alloc@std@@QAE@ABV01@@Z 0068 __TI2?AVbad_alloc@std@@ 0071 __CxxThrowException@8"
	strings:
		$1 = { 55 8B EC 83 EC 10 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 83 7D FC 00 75 5C 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 4A 8B 15 ?? ?? ?? ?? 83 E2 01 75 24 A1 ?? ?? ?? ?? 83 C8 01 A3 ?? ?? ?? ?? B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 68 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 4D F0 51 E8 ?? ?? ?? ?? EB 8F 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_161_1_0 {
	meta:
		name = "??0bad_alloc@std@@QAE@XZ"
		size = 38
		refs = "000a __bad_alloc_Message 0012 ??0exception@std@@QAE@ABQBDH@Z 001b ??_7bad_alloc@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 6A 01 68 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC C7 00 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_161_2_0 {
	meta:
		name = "??1bad_alloc@std@@UAE@XZ"
		size = 28
		refs = "000c ??_7bad_alloc@std@@6B@ 0014 ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_89_250_1 {
	meta:
		name = "??1?$basic_ios@DU?$char_traits@D@std@@@std@@UAE@XZ"
		size = 28
		refs = "000c ??_7?$basic_ios@DU?$char_traits@D@std@@@std@@6B@ 0014 ??1ios_base@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_4_274_1 {
	meta:
		name = "??1?$basic_ios@GU?$char_traits@G@std@@@std@@UAE@XZ"
		size = 28
		refs = "000c ??_7?$basic_ios@GU?$char_traits@G@std@@@std@@6B@ 0014 ??1ios_base@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_274_1 {
	meta:
		name = "??1?$basic_ios@_WU?$char_traits@_W@std@@@std@@UAE@XZ"
		size = 28
		refs = "000c ??_7?$basic_ios@_WU?$char_traits@_W@std@@@std@@6B@ 0014 ??1ios_base@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_45_236_1 {
	meta:
		name = "??1?$codecvt@DDH@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$codecvt@DDH@std@@6B@ 0014 ??1codecvt_base@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_33_225_1 {
	meta:
		name = "??1?$codecvt@GDH@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$codecvt@GDH@std@@6B@ 0014 ??1codecvt_base@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_70_225_1 {
	meta:
		name = "??1?$codecvt@_WDH@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$codecvt@_WDH@std@@6B@ 0014 ??1codecvt_base@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_1_193_1 {
	meta:
		name = "??1?$collate@D@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$collate@D@std@@6B@ 0014 ??1facet@locale@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_47_841_1 {
	meta:
		name = "??1?$collate@G@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$collate@G@std@@6B@ 0014 ??1facet@locale@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_47_804_1 {
	meta:
		name = "??1?$collate@_W@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$collate@_W@std@@6B@ 0014 ??1facet@locale@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_1_196_1 {
	meta:
		name = "??1?$messages@D@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$messages@D@std@@6B@ 0014 ??1messages_base@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_47_844_1 {
	meta:
		name = "??1?$messages@G@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$messages@G@std@@6B@ 0014 ??1messages_base@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_47_807_1 {
	meta:
		name = "??1?$messages@_W@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$messages@_W@std@@6B@ 0014 ??1messages_base@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_1_198_1 {
	meta:
		name = "??1?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@ 0014 ??1facet@locale@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_47_846_1 {
	meta:
		name = "??1?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@ 0014 ??1facet@locale@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_47_809_1 {
	meta:
		name = "??1?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@ 0014 ??1facet@locale@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_1_202_1 {
	meta:
		name = "??1?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@ 0014 ??1facet@locale@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_47_848_1 {
	meta:
		name = "??1?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@ 0014 ??1facet@locale@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_47_811_1 {
	meta:
		name = "??1?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@ 0014 ??1facet@locale@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_1_214_1 {
	meta:
		name = "??1?$moneypunct@D$00@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$moneypunct@D$00@std@@6B@ 0014 ??1?$_Mpunct@D@std@@MAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_1_206_1 {
	meta:
		name = "??1?$moneypunct@D$0A@@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$moneypunct@D$0A@@std@@6B@ 0014 ??1?$_Mpunct@D@std@@MAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_47_856_1 {
	meta:
		name = "??1?$moneypunct@G$00@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$moneypunct@G$00@std@@6B@ 0014 ??1?$_Mpunct@G@std@@MAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_47_850_1 {
	meta:
		name = "??1?$moneypunct@G$0A@@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$moneypunct@G$0A@@std@@6B@ 0014 ??1?$_Mpunct@G@std@@MAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_47_821_1 {
	meta:
		name = "??1?$moneypunct@_W$00@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$moneypunct@_W$00@std@@6B@ 0014 ??1?$_Mpunct@_W@std@@MAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_47_813_1 {
	meta:
		name = "??1?$moneypunct@_W$0A@@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$moneypunct@_W$0A@@std@@6B@ 0014 ??1?$_Mpunct@_W@std@@MAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_60_295_1 {
	meta:
		name = "??1?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@ 0014 ??1facet@locale@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_47_828_1 {
	meta:
		name = "??1?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@ 0014 ??1facet@locale@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_47_793_1 {
	meta:
		name = "??1?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@ 0014 ??1facet@locale@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_60_299_1 {
	meta:
		name = "??1?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@ 0014 ??1facet@locale@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_47_832_1 {
	meta:
		name = "??1?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@ 0014 ??1facet@locale@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_47_797_1 {
	meta:
		name = "??1?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@ 0014 ??1facet@locale@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_789_19_0 {
	meta:
		name = "??1__non_rtti_object@std@@UAE@XZ"
		size = 28
		refs = "000c ??_7__non_rtti_object@std@@6B@ 0014 ??1bad_typeid@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_789_11_0 {
	meta:
		name = "??1bad_cast@std@@UAE@XZ"
		size = 28
		refs = "000c ??_7bad_cast@std@@6B@ 0014 ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_698_3_0 {
	meta:
		name = "??1bad_exception@std@@UAE@XZ"
		size = 28
		refs = "000c ??_7bad_exception@std@@6B@ 0014 ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_789_15_0 {
	meta:
		name = "??1bad_typeid@std@@UAE@XZ"
		size = 28
		refs = "000c ??_7bad_typeid@std@@6B@ 0014 ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_33_210_1 {
	meta:
		name = "??1codecvt_base@std@@UAE@XZ"
		size = 28
		refs = "000c ??_7codecvt_base@std@@6B@ 0014 ??1facet@locale@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_1_551_1 {
	meta:
		name = "??1ctype_base@std@@UAE@XZ"
		size = 28
		refs = "000c ??_7ctype_base@std@@6B@ 0014 ??1facet@locale@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_54_35_1 {
	meta:
		name = "??1failure@ios_base@std@@UAE@XZ"
		size = 28
		refs = "000c ??_7failure@ios_base@std@@6B@ 0014 ??1runtime_error@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_25_27_1 {
	meta:
		name = "??1invalid_argument@std@@UAE@XZ"
		size = 28
		refs = "000c ??_7invalid_argument@std@@6B@ 0014 ??1logic_error@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_25_10_1 {
	meta:
		name = "??1length_error@std@@UAE@XZ"
		size = 28
		refs = "000c ??_7length_error@std@@6B@ 0014 ??1logic_error@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_1_54_1 {
	meta:
		name = "??1messages_base@std@@UAE@XZ"
		size = 28
		refs = "000c ??_7messages_base@std@@6B@ 0014 ??1facet@locale@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_1_210_1 {
	meta:
		name = "??1money_base@std@@UAE@XZ"
		size = 28
		refs = "000c ??_7money_base@std@@6B@ 0014 ??1facet@locale@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_25_20_1 {
	meta:
		name = "??1out_of_range@std@@UAE@XZ"
		size = 28
		refs = "000c ??_7out_of_range@std@@6B@ 0014 ??1logic_error@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_1_124_1 {
	meta:
		name = "??1time_base@std@@UAE@XZ"
		size = 28
		refs = "000c ??_7time_base@std@@6B@ 0014 ??1facet@locale@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_161_3_0 {
	meta:
		name = "??_Gbad_alloc@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1bad_alloc@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1_212_1 {
	meta:
		name = "??_G?$_Mpunct@D@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$_Mpunct@D@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_47_854_1 {
	meta:
		name = "??_G?$_Mpunct@G@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$_Mpunct@G@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_47_819_1 {
	meta:
		name = "??_G?$_Mpunct@_W@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$_Mpunct@_W@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_83_73_1 {
	meta:
		name = "??_G?$basic_filebuf@DU?$char_traits@D@std@@@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$basic_filebuf@DU?$char_traits@D@std@@@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_14_75_1 {
	meta:
		name = "??_G?$basic_filebuf@GU?$char_traits@G@std@@@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$basic_filebuf@GU?$char_traits@G@std@@@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_71_75_1 {
	meta:
		name = "??_G?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_74_256_1 {
	meta:
		name = "??_G?$basic_ios@DU?$char_traits@D@std@@@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$basic_ios@DU?$char_traits@D@std@@@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_12_280_1 {
	meta:
		name = "??_G?$basic_ios@GU?$char_traits@G@std@@@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$basic_ios@GU?$char_traits@G@std@@@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_41_277_1 {
	meta:
		name = "??_G?$basic_ios@_WU?$char_traits@_W@std@@@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$basic_ios@_WU?$char_traits@_W@std@@@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_83_72_1 {
	meta:
		name = "??_G?$basic_streambuf@DU?$char_traits@D@std@@@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$basic_streambuf@DU?$char_traits@D@std@@@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_12_74_1 {
	meta:
		name = "??_G?$basic_streambuf@GU?$char_traits@G@std@@@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$basic_streambuf@GU?$char_traits@G@std@@@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_41_74_1 {
	meta:
		name = "??_G?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_45_235_1 {
	meta:
		name = "??_G?$codecvt@DDH@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$codecvt@DDH@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_33_224_1 {
	meta:
		name = "??_G?$codecvt@GDH@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$codecvt@GDH@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_41_224_1 {
	meta:
		name = "??_G?$codecvt@_WDH@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$codecvt@_WDH@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1_192_1 {
	meta:
		name = "??_G?$collate@D@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$collate@D@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_47_840_1 {
	meta:
		name = "??_G?$collate@G@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$collate@G@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_47_803_1 {
	meta:
		name = "??_G?$collate@_W@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$collate@_W@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_45_306_1 {
	meta:
		name = "??_G?$ctype@D@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$ctype@D@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_33_336_1 {
	meta:
		name = "??_G?$ctype@G@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$ctype@G@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_70_336_1 {
	meta:
		name = "??_G?$ctype@_W@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$ctype@_W@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1_195_1 {
	meta:
		name = "??_G?$messages@D@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$messages@D@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_47_843_1 {
	meta:
		name = "??_G?$messages@G@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$messages@G@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_47_806_1 {
	meta:
		name = "??_G?$messages@_W@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$messages@_W@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1_197_1 {
	meta:
		name = "??_G?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_47_845_1 {
	meta:
		name = "??_G?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_47_808_1 {
	meta:
		name = "??_G?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1_201_1 {
	meta:
		name = "??_G?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_47_847_1 {
	meta:
		name = "??_G?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_47_810_1 {
	meta:
		name = "??_G?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1_213_1 {
	meta:
		name = "??_G?$moneypunct@D$00@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$moneypunct@D$00@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1_205_1 {
	meta:
		name = "??_G?$moneypunct@D$0A@@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$moneypunct@D$0A@@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_47_855_1 {
	meta:
		name = "??_G?$moneypunct@G$00@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$moneypunct@G$00@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_47_849_1 {
	meta:
		name = "??_G?$moneypunct@G$0A@@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$moneypunct@G$0A@@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_47_820_1 {
	meta:
		name = "??_G?$moneypunct@_W$00@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$moneypunct@_W$00@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_47_812_1 {
	meta:
		name = "??_G?$moneypunct@_W$0A@@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$moneypunct@_W$0A@@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_60_294_1 {
	meta:
		name = "??_G?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_47_827_1 {
	meta:
		name = "??_G?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_47_792_1 {
	meta:
		name = "??_G?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_60_298_1 {
	meta:
		name = "??_G?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_47_831_1 {
	meta:
		name = "??_G?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_47_796_1 {
	meta:
		name = "??_G?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_60_303_1 {
	meta:
		name = "??_G?$numpunct@D@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$numpunct@D@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_47_836_1 {
	meta:
		name = "??_G?$numpunct@G@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$numpunct@G@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_47_799_1 {
	meta:
		name = "??_G?$numpunct@_W@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$numpunct@_W@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1_215_1 {
	meta:
		name = "??_G?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_47_857_1 {
	meta:
		name = "??_G?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_47_822_1 {
	meta:
		name = "??_G?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1_220_1 {
	meta:
		name = "??_G?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_47_862_1 {
	meta:
		name = "??_G?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_47_783_1 {
	meta:
		name = "??_G?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_82_125_1 {
	meta:
		name = "??_G_Fac_node@std@@QAEPAXI@Z"
		size = 44
		refs = "000b ??1_Fac_node@std@@QAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_82_28_1 {
	meta:
		name = "??_G_Locimp@locale@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1_Locimp@locale@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_789_17_0 {
	meta:
		name = "??_G__non_rtti_object@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1__non_rtti_object@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_789_9_0 {
	meta:
		name = "??_Gbad_cast@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1bad_cast@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_698_4_0 {
	meta:
		name = "??_Gbad_exception@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1bad_exception@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_789_13_0 {
	meta:
		name = "??_Gbad_typeid@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1bad_typeid@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_60_282_1 {
	meta:
		name = "??_Gcodecvt_base@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1codecvt_base@std@@UAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1_552_1 {
	meta:
		name = "??_Gctype_base@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1ctype_base@std@@UAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_789_1_0 {
	meta:
		name = "??_Gexception@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1exception@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_60_33_1 {
	meta:
		name = "??_Gfacet@locale@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1facet@locale@std@@UAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_4_291_1 {
	meta:
		name = "??_Gfailure@ios_base@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1failure@ios_base@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_25_28_1 {
	meta:
		name = "??_Ginvalid_argument@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1invalid_argument@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_71_276_1 {
	meta:
		name = "??_Gios_base@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1ios_base@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_25_11_1 {
	meta:
		name = "??_Glength_error@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1length_error@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_70_247_1 {
	meta:
		name = "??_Glocale@std@@QAEPAXI@Z"
		size = 44
		refs = "000b ??1locale@std@@QAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_25_8_1 {
	meta:
		name = "??_Glogic_error@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1logic_error@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_47_384_1 {
	meta:
		name = "??_Gmessages_base@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1messages_base@std@@UAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_47_818_1 {
	meta:
		name = "??_Gmoney_base@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1money_base@std@@UAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_25_21_1 {
	meta:
		name = "??_Gout_of_range@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1out_of_range@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_70_195_1 {
	meta:
		name = "??_Gruntime_error@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1runtime_error@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1_125_1 {
	meta:
		name = "??_Gtime_base@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1time_base@std@@UAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_385_2_0 {
	meta:
		name = "??_Gtype_info@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1type_info@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_161_5_0 {
	meta:
		name = "??0bad_alloc@std@@QAE@ABV01@@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABV01@@Z 0018 ??_7bad_alloc@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_789_18_0 {
	meta:
		name = "??0__non_rtti_object@std@@QAE@ABV01@@Z"
		size = 37
		refs = "000f ??0bad_typeid@std@@QAE@ABV01@@Z 0018 ??_7__non_rtti_object@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_789_16_0 {
	meta:
		name = "??0__non_rtti_object@std@@QAE@PBD@Z"
		size = 37
		refs = "000f ??0bad_typeid@std@@QAE@PBD@Z 0018 ??_7__non_rtti_object@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_789_10_0 {
	meta:
		name = "??0bad_cast@std@@QAE@ABV01@@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABV01@@Z 0018 ??_7bad_cast@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_698_5_0 {
	meta:
		name = "??0bad_exception@std@@QAE@ABV01@@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABV01@@Z 0018 ??_7bad_exception@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_789_14_0 {
	meta:
		name = "??0bad_typeid@std@@QAE@ABV01@@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABV01@@Z 0018 ??_7bad_typeid@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_33_206_1 {
	meta:
		name = "??0codecvt_base@std@@QAE@I@Z"
		size = 37
		refs = "000f ??0facet@locale@std@@IAE@I@Z 0018 ??_7codecvt_base@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_70_314_1 {
	meta:
		name = "??0ctype_base@std@@QAE@I@Z"
		size = 37
		refs = "000f ??0facet@locale@std@@IAE@I@Z 0018 ??_7ctype_base@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_89_268_1 {
	meta:
		name = "??0failure@ios_base@std@@QAE@ABV012@@Z"
		size = 37
		refs = "000f ??0runtime_error@std@@QAE@ABV01@@Z 0018 ??_7failure@ios_base@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_12_289_1 {
	meta:
		name = "??0failure@ios_base@std@@QAE@ABV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@@Z"
		size = 37
		refs = "000f ??0runtime_error@std@@QAE@ABV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@1@@Z 0018 ??_7failure@ios_base@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_25_29_1 {
	meta:
		name = "??0invalid_argument@std@@QAE@ABV01@@Z"
		size = 37
		refs = "000f ??0logic_error@std@@QAE@ABV01@@Z 0018 ??_7invalid_argument@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_25_26_1 {
	meta:
		name = "??0invalid_argument@std@@QAE@ABV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@1@@Z"
		size = 37
		refs = "000f ??0logic_error@std@@QAE@ABV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@1@@Z 0018 ??_7invalid_argument@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_25_15_1 {
	meta:
		name = "??0length_error@std@@QAE@ABV01@@Z"
		size = 37
		refs = "000f ??0logic_error@std@@QAE@ABV01@@Z 0018 ??_7length_error@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_25_3_1 {
	meta:
		name = "??0length_error@std@@QAE@ABV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@1@@Z"
		size = 37
		refs = "000f ??0logic_error@std@@QAE@ABV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@1@@Z 0018 ??_7length_error@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1_53_1 {
	meta:
		name = "??0messages_base@std@@QAE@I@Z"
		size = 37
		refs = "000f ??0facet@locale@std@@IAE@I@Z 0018 ??_7messages_base@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_47_1119_1 {
	meta:
		name = "??0money_base@std@@QAE@I@Z"
		size = 37
		refs = "000f ??0facet@locale@std@@IAE@I@Z 0018 ??_7money_base@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_25_22_1 {
	meta:
		name = "??0out_of_range@std@@QAE@ABV01@@Z"
		size = 37
		refs = "000f ??0logic_error@std@@QAE@ABV01@@Z 0018 ??_7out_of_range@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_25_19_1 {
	meta:
		name = "??0out_of_range@std@@QAE@ABV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@1@@Z"
		size = 37
		refs = "000f ??0logic_error@std@@QAE@ABV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@1@@Z 0018 ??_7out_of_range@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_47_449_1 {
	meta:
		name = "??0time_base@std@@QAE@I@Z"
		size = 37
		refs = "000f ??0facet@locale@std@@IAE@I@Z 0018 ??_7time_base@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_162_0_0 {
	meta:
		name = "__stricmp_l"
		size = 420
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0025 ??_C@_1BI@GKKCBDMD@?$AAd?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 002e ??_C@_1BE@OLHMELNO@?$AAs?$AAt?$AAr?$AAi?$AAc?$AAm?$AAp?$AA?4?$AAc?$AA?$AA@ 0035 __CrtDbgReportW 0049 __errno 005d ??_C@_1BG@GLLONOEH@?$AA_?$AAs?$AAt?$AAr?$AAi?$AAc?$AAm?$AAp?$AA_?$AAl?$AA?$AA@ 0067 __invalid_parameter 0079 ??1_LocaleUpdate@@QAE@XZ 0098 ??_C@_1BI@DCHLDCPP@?$AAs?$AAr?$AAc?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 00fc ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0111 ___ascii_stricmp 0141 __tolower_l"
	strings:
		$1 = { 55 8B EC 83 EC 38 8B 45 10 50 8D 4D E8 E8 ?? ?? ?? ?? 33 C9 83 7D 08 00 0F 95 C1 89 4D E4 83 7D E4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 34 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E4 00 75 3D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 34 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 DC FF FF FF 7F 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 DC E9 1B 01 00 00 33 C0 83 7D 0C 00 0F 95 C0 89 45 E0 83 7D E0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 35 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 3D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 35 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 D8 FF FF FF 7F 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 D8 E9 A8 00 00 00 8D 4D E8 E8 ?? ?? ?? ?? 8B 10 83 7A 14 00 75 22 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 D4 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 D4 EB 78 EB 62 8B 55 08 0F B6 02 89 45 CC 8D 4D E8 E8 ?? ?? ?? ?? 50 8B 4D CC 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 8B 55 08 83 C2 01 89 55 08 8B 45 0C 0F B6 08 89 4D C8 8D 4D E8 E8 ?? ?? ?? ?? 50 8B 55 C8 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 F8 8B 45 0C 83 C0 01 89 45 0C 83 7D FC 00 74 08 8B 4D FC 3B 4D F8 74 9E 8B 55 FC 2B 55 F8 89 55 D0 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 D0 8B E5 5D C3 }
	condition:
		$1
}

rule file_162_4_0 {
	meta:
		name = "___ascii_stricmp"
		size = 112
	strings:
		$1 = { 55 8B EC 83 EC 08 8B 45 08 0F B6 08 89 4D FC 8B 55 FC 8B 45 08 83 C0 01 89 45 08 83 FA 41 7C 0F 83 7D FC 5A 7F 09 8B 4D FC 83 C1 20 89 4D FC 8B 55 0C 0F B6 02 89 45 F8 8B 4D F8 8B 55 0C 83 C2 01 89 55 0C 83 F9 41 7C 0F 83 7D F8 5A 7F 09 8B 45 F8 83 C0 20 89 45 F8 83 7D FC 00 74 08 8B 4D FC 3B 4D F8 74 A0 8B 45 FC 2B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_162_5_0 {
	meta:
		name = "__stricmp"
		size = 262
		refs = "0008 ___locale_changed 0026 ??_C@_1BI@GKKCBDMD@?$AAd?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 002f ??_C@_1BE@OLHMELNO@?$AAs?$AAt?$AAr?$AAi?$AAc?$AAm?$AAp?$AA?4?$AAc?$AA?$AA@ 0036 __CrtDbgReportW 004a __errno 005e ??_C@_1BC@JLGKKIIG@?$AA_?$AAs?$AAt?$AAr?$AAi?$AAc?$AAm?$AAp?$AA?$AA@ 0068 __invalid_parameter 008c ??_C@_1BI@DCHLDCPP@?$AAs?$AAr?$AAc?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 00e5 ___ascii_stricmp 00fb __stricmp_l"
	strings:
		$1 = { 55 8B EC 83 EC 08 83 3D ?? ?? ?? ?? 00 0F 85 DD 00 00 00 33 C0 83 7D 08 00 0F 95 C0 89 45 FC 83 7D FC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 62 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D FC 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 62 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF FF 7F E9 89 00 00 00 33 D2 83 7D 0C 00 0F 95 C2 89 55 F8 83 7D F8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 63 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F8 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 63 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF FF 7F EB 26 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 EB 14 EB 12 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_164_0_0 {
	meta:
		name = "__snprintf_c"
		size = 438
		refs = "001f ??_C@_1CC@MGIEJOME@?$AA?$CI?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0028 ??_C@_1GE@EIENEIDK@?$AAf?$AA?3?$AA?2?$AAr?$AAt?$AAm?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2@ 002f __CrtDbgReportW 0043 __errno 0057 ??_C@_1BI@ENBFPFLN@?$AA_?$AAs?$AAn?$AAp?$AAr?$AAi?$AAn?$AAt?$AAf?$AA_?$AAc?$AA?$AA@ 0061 __invalid_parameter 0099 ??_C@_1EC@FABAOFFO@?$AA?$CI?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$CJ?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AA?$CI?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ@ 0138 __output_l 0194 __flsbuf"
	strings:
		$1 = { 55 8B EC 83 EC 3C 8D 45 D4 89 45 F4 33 C9 83 7D 10 00 0F 95 C1 89 4D D0 83 7D D0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 69 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D0 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 69 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 42 01 00 00 83 7D 0C 00 74 0F 83 7D 08 00 75 09 C7 45 C8 00 00 00 00 EB 07 C7 45 C8 01 00 00 00 8B 45 C8 89 45 CC 83 7D CC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 6C 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D CC 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 6C 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 C8 00 00 00 8D 55 14 89 55 FC 81 7D 0C FF FF FF 7F 76 0C 8B 45 F4 C7 40 04 FF FF FF 7F EB 09 8B 4D F4 8B 55 0C 89 51 04 8B 45 F4 C7 40 0C 42 00 00 00 8B 4D F4 8B 55 08 89 51 08 8B 45 F4 8B 4D 08 89 08 8B 55 FC 52 6A 00 8B 45 10 50 8B 4D F4 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 F8 83 7D 08 00 75 05 8B 45 F8 EB 65 83 7D F8 00 7C 56 8B 55 F4 8B 42 04 83 E8 01 8B 4D F4 89 41 04 8B 55 F4 83 7A 04 00 7C 22 8B 45 F4 8B 08 C6 01 00 33 D2 81 E2 FF 00 00 00 89 55 C4 8B 45 F4 8B 08 83 C1 01 8B 55 F4 89 0A EB 11 8B 45 F4 50 6A 00 E8 ?? ?? ?? ?? 83 C4 08 89 45 C4 83 7D C4 FF 74 05 8B 45 F8 EB 09 8B 4D 08 C6 01 00 83 C8 FF 8B E5 5D C3 }
	condition:
		$1
}

rule file_168_0_0 {
	meta:
		name = "__powhlp"
		size = 420
		refs = "004f __d_inf 00ba __d_ind 012e __d_inttype 017e __d_mzero"
	strings:
		$1 = { 55 8B EC 83 EC 2C C7 45 FC 00 00 00 00 D9 EE DC 5D 08 DF E0 F6 C4 41 75 0A DD 45 08 D9 E0 DD 5D E4 EB 06 DD 45 08 DD 5D E4 DD 45 E4 DD 5D F0 81 7D 14 00 00 F0 7F 75 40 83 7D 10 00 75 3A D9 E8 DC 5D F0 DF E0 F6 C4 05 7A 0D 8B 45 18 DD 05 ?? ?? ?? ?? DD 18 EB 1C D9 E8 DC 5D F0 DF E0 F6 C4 41 75 09 8B 4D 18 D9 EE DD 19 EB 07 8B 55 18 D9 E8 DD 1A E9 25 01 00 00 81 7D 14 00 00 F0 FF 75 4B 83 7D 10 00 75 45 D9 E8 DC 5D F0 DF E0 F6 C4 05 7A 09 8B 45 18 D9 EE DD 18 EB 2B D9 E8 DC 5D F0 DF E0 F6 C4 41 75 0D 8B 4D 18 DD 05 ?? ?? ?? ?? DD 19 EB 12 8B 55 18 DD 05 ?? ?? ?? ?? DD 1A C7 45 FC 01 00 00 00 E9 D1 00 00 00 81 7D 0C 00 00 F0 7F 75 40 83 7D 08 00 75 3A D9 EE DC 5D 10 DF E0 F6 C4 05 7A 0D 8B 45 18 DD 05 ?? ?? ?? ?? DD 18 EB 1C D9 EE DC 5D 10 DF E0 F6 C4 41 75 09 8B 4D 18 D9 EE DD 19 EB 07 8B 55 18 D9 E8 DD 1A E9 88 00 00 00 81 7D 0C 00 00 F0 FF 75 7F 83 7D 08 00 75 79 83 EC 08 DD 45 10 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 89 45 EC D9 EE DC 5D 10 DF E0 F6 C4 05 7A 26 83 7D EC 01 75 0D DD 05 ?? ?? ?? ?? D9 E0 DD 5D DC EB 09 DD 05 ?? ?? ?? ?? DD 5D DC 8B 45 18 DD 45 DC DD 18 EB 33 D9 EE DC 5D 10 DF E0 F6 C4 41 75 20 83 7D EC 01 75 0B DD 05 ?? ?? ?? ?? DD 5D D4 EB 05 D9 EE DD 5D D4 8B 4D 18 DD 45 D4 DD 19 EB 07 8B 55 18 D9 E8 DD 1A 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_168_1_0 {
	meta:
		name = "__d_inttype"
		size = 130
		refs = "0010 __fpclass 002c __frnd 0048 __real@4000000000000000"
	strings:
		$1 = { 55 8B EC 83 EC 08 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 25 90 00 00 00 74 04 33 C0 EB 5C 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DD 5D F8 DD 45 08 DC 5D F8 DF E0 F6 C4 44 7A 39 DD 45 08 DC 35 ?? ?? ?? ?? 83 EC 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DD 45 08 DC 35 ?? ?? ?? ?? DA E9 DF E0 F6 C4 44 7A 09 B8 02 00 00 00 EB 0B EB 07 B8 01 00 00 00 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_169_0_0 {
	meta:
		name = "_wcscpy_s"
		size = 734
		refs = "002f ??_C@_1FC@PFMLEHKI@?$AA?$CI?$AA?$CI?$AA_?$AAD?$AAs?$AAt?$AA?$CJ?$AA?$CJ?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?$CI?$AA_?$AAS?$AAi?$AAz?$AAe?$AAI?$AAn?$AAW?$AAo?$AAr@ 0038 ??_C@_1GK@NOPKFDOE@?$AAF?$AA?3?$AA?2?$AAR?$AAT?$AAM?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAS?$AAE?$AAL?$AAF?$AA_?$AAX?$AA8?$AA6?$AA?2@ 003f __CrtDbgReportW 0053 __errno 0067 ??_C@_1BC@KIONAFPO@?$AAw?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$AA@ 0071 __invalid_parameter 00b1 ___crtDebugFillThreshold 00de _memset 00f8 ??_C@_1CG@OFBJMIGJ@?$AA?$CI?$AA?$CI?$AA?$CI?$AA_?$AAS?$AAr?$AAc?$AA?$CJ?$AA?$CJ?$AA?$CJ?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 01f0 ??_C@_1CI@HCPHDDLE@?$AAB?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AAi?$AAs?$AA?5?$AAt?$AAo?$AAo?$AA?5?$AAs?$AAm?$AAa?$AAl?$AAl?$AA?$AA@ 0219 ??_C@_1DM@MADKGDLO@?$AA?$CI?$AAL?$AA?$CC?$AAB?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AAi?$AAs?$AA?5?$AAt?$AAo?$AAo?$AA?5?$AAs?$AAm?$AAa?$AAl?$AAl?$AA?$CC?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA0?$AA?$CJ?$AA?$AA@"
	strings:
		$1 = { 55 8B EC 83 EC 28 83 7D 08 00 74 0F 83 7D 0C 00 76 09 C7 45 E8 01 00 00 00 EB 07 C7 45 E8 00 00 00 00 8B 45 E8 89 45 F4 83 7D F4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 12 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F4 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 12 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 58 02 00 00 83 7D 10 00 0F 85 BF 00 00 00 8B 55 08 66 C7 02 00 00 83 7D 0C FF 74 4B 81 7D 0C FF FF FF 7F 74 42 83 7D 0C 01 76 3C 8B 45 0C 83 E8 01 39 05 ?? ?? ?? ?? 73 0B 8B 0D ?? ?? ?? ?? 89 4D E4 EB 09 8B 55 0C 83 EA 01 89 55 E4 8B 45 E4 D1 E0 50 68 FD 00 00 00 8B 4D 08 83 C1 02 51 E8 ?? ?? ?? ?? 83 C4 0C 33 D2 83 7D 10 00 0F 95 C2 89 55 F0 83 7D F0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 13 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 13 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 8F 01 00 00 8B 4D 08 89 4D FC 8B 55 0C 89 55 F8 8B 45 FC 8B 4D 10 66 8B 11 66 89 10 8B 45 FC 0F B7 08 8B 55 FC 83 C2 02 89 55 FC 8B 45 10 83 C0 02 89 45 10 85 C9 74 0D 8B 4D F8 83 E9 01 89 4D F8 74 02 EB CB 83 7D F8 00 0F 85 D3 00 00 00 8B 55 08 66 C7 02 00 00 83 7D 0C FF 74 4B 81 7D 0C FF FF FF 7F 74 42 83 7D 0C 01 76 3C 8B 45 0C 83 E8 01 39 05 ?? ?? ?? ?? 73 0B 8B 0D ?? ?? ?? ?? 89 4D E0 EB 09 8B 55 0C 83 EA 01 89 55 E0 8B 45 E0 D1 E0 50 68 FD 00 00 00 8B 4D 08 83 C1 02 51 E8 ?? ?? ?? ?? 83 C4 0C BA ?? ?? ?? ?? 85 D2 74 0D 33 C0 74 09 C7 45 DC 01 00 00 00 EB 07 C7 45 DC 00 00 00 00 8B 4D DC 89 4D EC 83 7D EC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 1E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D EC 00 75 2D E8 ?? ?? ?? ?? C7 00 22 00 00 00 6A 00 6A 1E 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 22 00 00 00 EB 71 83 7D 0C FF 74 69 81 7D 0C FF FF FF 7F 74 60 8B 45 0C 2B 45 F8 83 C0 01 3B 45 0C 73 52 8B 4D 0C 2B 4D F8 83 C1 01 8B 55 0C 2B D1 39 15 ?? ?? ?? ?? 73 0A A1 ?? ?? ?? ?? 89 45 D8 EB 11 8B 4D 0C 2B 4D F8 83 C1 01 8B 55 0C 2B D1 89 55 D8 8B 45 D8 D1 E0 50 68 FD 00 00 00 8B 4D 0C 2B 4D F8 8B 55 08 8D 44 4A 02 50 E8 ?? ?? ?? ?? 83 C4 0C 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_170_0_0 {
	meta:
		name = "__ms_p5_test_fdiv"
		size = 74
		refs = "0008 __real@4147ffff80000000 0011 __real@4150017ec0000000"
	strings:
		$1 = { 55 8B EC 83 EC 1C DD 05 ?? ?? ?? ?? DD 5D F8 DD 05 ?? ?? ?? ?? DD 5D F0 DD 45 F0 DC 75 F8 DC 4D F8 DC 6D F0 DD 5D E8 D9 E8 DC 5D E8 DF E0 F6 C4 05 7A 09 C7 45 E4 01 00 00 00 EB 07 C7 45 E4 00 00 00 00 8B 45 E4 8B E5 5D C3 }
	condition:
		$1
}

rule file_170_1_0 {
	meta:
		name = "__ms_p5_mp_test_fdiv"
		size = 68
		refs = "0007 ??_C@_08CPNIBGIE@KERNEL32?$AA@ 000d __imp__GetModuleHandleA@4 001b ??_C@_0BK@NHEOCAHP@IsProcessorFeaturePresent?$AA@ 0025 __imp__GetProcAddress@8 003c __ms_p5_test_fdiv"
	strings:
		$1 = { 55 8B EC 83 EC 08 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 89 45 F8 83 7D F8 00 74 21 68 ?? ?? ?? ?? 8B 45 F8 50 FF 15 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 74 09 6A 00 FF 55 FC EB 07 EB 05 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_172_1_0 {
	meta:
		name = "__putch_nolock"
		size = 231
		refs = "0007 __getptd 0039 _isleadbyte 0045 ??_C@_1DG@NCPKEAM@?$AAi?$AAs?$AAl?$AAe?$AAa?$AAd?$AAb?$AAy?$AAt?$AAe?$AA?$CI?$AAc?$AAh?$AA_?$AAb?$AAu?$AAf?$AA?$FL?$AA0?$AA?$FN?$AA?$CJ?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 004e ??_C@_1BA@KIEJFIMG@?$AAp?$AAu?$AAt?$AAc?$AAh?$AA?4?$AAc?$AA?$AA@ 0055 __CrtDbgReportW 00af _mbtowc 00c1 __putwch_nolock"
	strings:
		$1 = { 55 8B EC 83 EC 14 E8 ?? ?? ?? ?? 89 45 F4 8B 45 F4 83 C0 4C 89 45 F8 8B 4D F4 83 C1 52 89 4D FC 8A 55 08 88 55 F3 8B 45 FC 0F B7 08 83 F9 01 75 3C 8B 55 F8 0F B6 02 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 1E 68 ?? ?? ?? ?? 6A 00 6A 66 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 8B 55 F8 8A 45 F3 88 42 01 EB 08 8B 4D F8 8A 55 F3 88 11 8B 45 FC 0F B7 08 85 C9 75 1D 8B 55 F8 0F B6 02 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 0A 8B 4D FC 66 C7 01 01 00 EB 43 8B 55 FC 0F B7 02 83 C0 01 50 8B 4D F8 51 8D 55 EC 52 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 FF 74 18 66 8B 45 EC 50 E8 ?? ?? ?? ?? 83 C4 04 0F B7 C8 81 F9 FF FF 00 00 75 04 C6 45 F3 FF 8B 55 FC 66 C7 02 00 00 0F B6 45 F3 8B E5 5D C3 }
	condition:
		$1
}

rule file_173_0_0 {
	meta:
		name = "__tell"
		size = 21
		refs = "000c __lseek"
	strings:
		$1 = { 55 8B EC 6A 01 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_174_0_0 {
	meta:
		name = "__wsetenvp"
		size = 399
		refs = "000e __wenvptr 0046 _wcslen 005c ??_C@_0DC@HKMPGGLA@f?3?2rtm?2vctools?2crt_bld?2self_x86?2@ 006c __calloc_dbg 007b __wenviron 0103 __free_dbg 0121 ??_C@_1GE@GCIHLBPK@?$AAf?$AA?3?$AA?2?$AAr?$AAt?$AAm?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2@ 0126 ??_C@_1BE@OMLKOOJF@?$AA_?$AAw?$AAs?$AAe?$AAt?$AAe?$AAn?$AAv?$AAp?$AA?$AA@ 012b ??_C@_1DE@IJEMLPNE@?$AAw?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AA?$CK?$AAe?$AAn?$AAv?$AA?0?$AA?5?$AAc?$AAc?$AAh?$AAa?$AAr?$AAs?$AA?0?$AA?5?$AAp?$AA?$CJ?$AA?$AA@ 013e _wcscpy_s 0147 __invoke_watson_if_error 0181 ___env_initialized"
	strings:
		$1 = { 55 8B EC 83 EC 10 C7 45 F8 00 00 00 00 A1 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 75 08 83 C8 FF E9 68 01 00 00 8B 4D FC 0F B7 11 85 D2 74 2C 8B 45 FC 0F B7 08 83 F9 3D 74 09 8B 55 F8 83 C2 01 89 55 F8 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D FC 8D 54 41 02 89 55 FC EB CA 6A 75 68 ?? ?? ?? ?? 6A 02 6A 04 8B 45 F8 83 C0 01 50 E8 ?? ?? ?? ?? 83 C4 14 89 45 F4 8B 4D F4 89 0D ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 75 08 83 C8 FF E9 FB 00 00 00 8B 15 ?? ?? ?? ?? 89 55 FC EB 0C 8B 45 F0 8B 4D FC 8D 14 41 89 55 FC 8B 45 FC 0F B7 08 85 C9 0F 84 A7 00 00 00 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 83 C0 01 89 45 F0 8B 45 FC 0F B7 08 83 F9 3D 0F 84 81 00 00 00 6A 7E 68 ?? ?? ?? ?? 6A 02 6A 02 8B 55 F0 52 E8 ?? ?? ?? ?? 83 C4 14 8B 4D F4 89 01 8B 55 F4 83 3A 00 75 1F 6A 02 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 08 C7 05 ?? ?? ?? ?? 00 00 00 00 83 C8 FF EB 72 6A 00 68 85 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 4D FC 51 8B 55 F0 52 8B 45 F4 8B 08 51 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 55 F4 83 C2 04 89 55 F4 E9 3F FF FF FF 6A 02 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 08 C7 05 ?? ?? ?? ?? 00 00 00 00 8B 4D F4 C7 01 00 00 00 00 C7 05 ?? ?? ?? ?? 01 00 00 00 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_175_0_0 {
	meta:
		name = "__lrotl"
		size = 43
		altNames = "__rotl"
	strings:
		$1 = { 55 8B EC 8B 45 0C 83 E0 1F 89 45 0C B9 20 00 00 00 2B 4D 0C 8B 55 08 D3 EA 8B 45 08 8B 4D 0C D3 E0 0B D0 89 55 08 8B 45 08 5D C3 }
	condition:
		$1
}

rule file_175_2_0 {
	meta:
		name = "__rotl64"
		size = 71
		refs = "001d __aullshr 002f __allshl"
	strings:
		$1 = { 55 8B EC 56 57 8B 45 10 83 E0 3F 89 45 10 B9 40 00 00 00 2B 4D 10 8B 45 08 8B 55 0C E8 ?? ?? ?? ?? 8B F0 8B FA 8B 45 08 8B 55 0C 8B 4D 10 E8 ?? ?? ?? ?? 0B F0 0B FA 89 75 08 89 7D 0C 8B 45 08 8B 55 0C 5F 5E 5D C3 }
	condition:
		$1
}

rule file_203_2_0 {
	meta:
		name = "__rotr64"
		size = 71
		refs = "001d __allshl 002f __aullshr"
	strings:
		$1 = { 55 8B EC 56 57 8B 45 10 83 E0 3F 89 45 10 B9 40 00 00 00 2B 4D 10 8B 45 08 8B 55 0C E8 ?? ?? ?? ?? 8B F0 8B FA 8B 45 08 8B 55 0C 8B 4D 10 E8 ?? ?? ?? ?? 0B F0 0B FA 89 75 08 89 7D 0C 8B 45 08 8B 55 0C 5F 5E 5D C3 }
	condition:
		$1
}

rule file_176_0_0 {
	meta:
		name = "__mbsncmp_l"
		size = 653
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0023 ??1_LocaleUpdate@@QAE@XZ 0033 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 004d _strncmp 007a ??_C@_1BG@MODEICJK@?$AAs?$AA1?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0083 ??_C@_1BE@PJDIHAFA@?$AAm?$AAb?$AAs?$AAn?$AAc?$AAm?$AAp?$AA?4?$AAc?$AA?$AA@ 008a __CrtDbgReportW 009e __errno 00b2 ??_C@_1BG@HJPKOFMJ@?$AA_?$AAm?$AAb?$AAs?$AAn?$AAc?$AAm?$AAp?$AA_?$AAl?$AA?$AA@ 00bc __invalid_parameter 00ed ??_C@_1BG@GBJNMPFA@?$AAs?$AA2?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@"
	strings:
		$1 = { 55 8B EC 83 EC 44 8B 45 14 50 8D 4D E8 E8 ?? ?? ?? ?? 83 7D 10 00 75 17 C7 45 DC 00 00 00 00 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 DC E9 5A 02 00 00 8D 4D E8 E8 ?? ?? ?? ?? 8B 48 04 83 79 08 00 75 27 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 89 45 D8 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 D8 E9 22 02 00 00 33 D2 83 7D 08 00 0F 95 C2 89 55 E4 83 7D E4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E4 00 75 3D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 3E 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 D4 FF FF FF 7F 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 D4 E9 AF 01 00 00 33 C9 83 7D 0C 00 0F 95 C1 89 4D E0 83 7D E0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3F 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 3D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 3F 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 D0 FF FF FF 7F 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 D0 E9 3C 01 00 00 8B 45 10 8B 4D 10 83 E9 01 89 4D 10 85 C0 0F 84 16 01 00 00 8B 55 08 66 0F B6 02 66 89 45 FC 8B 4D 08 83 C1 01 89 4D 08 8D 4D E8 E8 ?? ?? ?? ?? 8B 50 04 0F B6 45 FC 0F B6 4C 02 1D 83 E1 04 74 36 8B 55 08 0F B6 02 85 C0 75 09 C7 45 C0 00 00 00 00 EB 1B 0F B7 4D FC C1 E1 08 8B 55 08 0F B6 02 0B C8 89 4D C0 8B 4D 08 83 C1 01 89 4D 08 66 8B 55 C0 66 89 55 FC 8B 45 0C 66 0F B6 08 66 89 4D F8 8B 55 0C 83 C2 01 89 55 0C 8D 4D E8 E8 ?? ?? ?? ?? 8B 40 04 0F B6 4D F8 0F B6 54 08 1D 83 E2 04 74 36 8B 45 0C 0F B6 08 85 C9 75 09 C7 45 BC 00 00 00 00 EB 1B 0F B7 55 F8 C1 E2 08 8B 45 0C 0F B6 08 0B D1 89 55 BC 8B 55 0C 83 C2 01 89 55 0C 66 8B 45 BC 66 89 45 F8 0F B7 4D FC 0F B7 55 F8 3B CA 74 23 0F B7 45 FC 0F B7 4D F8 33 D2 3B C1 0F 9F C2 8D 54 12 FF 89 55 CC 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 CC EB 33 0F B7 45 FC 85 C0 75 14 C7 45 C8 00 00 00 00 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 C8 EB 17 E9 D6 FE FF FF C7 45 C4 00 00 00 00 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 C4 8B E5 5D C3 }
	condition:
		$1
}

rule file_178_0_0 {
	meta:
		name = "_wcstok_s"
		size = 553
		refs = "0019 ??_C@_1CG@NGEOKDE@?$AA?$CI?$AA_?$AAC?$AAo?$AAn?$AAt?$AAe?$AAx?$AAt?$AA?$CJ?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0022 ??_C@_1GK@GGCDLNNP@?$AAF?$AA?3?$AA?2?$AAR?$AAT?$AAM?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAS?$AAE?$AAL?$AAF?$AA_?$AAX?$AA8?$AA6?$AA?2@ 0029 __CrtDbgReportW 003d __errno 0051 ??_C@_1BC@DIFGONLO@?$AAw?$AAc?$AAs?$AAt?$AAo?$AAk?$AA_?$AAs?$AA?$AA@ 005b __invalid_parameter 007c ??_C@_1CG@CBDCOOGB@?$AA?$CI?$AA_?$AAC?$AAo?$AAn?$AAt?$AAr?$AAo?$AAl?$AA?$CJ?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 00f7 ??_C@_1GK@OCGBCEPL@?$AA?$CI?$AA_?$AAS?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA?$CI?$AA?$CI?$AAv?$AAo?$AAi?$AAd?$AA?5?$AA?$CK?$AA?$CJ?$AA0?$AA?$CJ?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AA?$CK?$AA_?$AAC?$AAo?$AAn@"
	strings:
		$1 = { 55 8B EC 83 EC 18 33 C0 83 7D 10 00 0F 95 C0 89 45 F4 83 7D F4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 12 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F4 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 12 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 BC 01 00 00 33 D2 83 7D 0C 00 0F 95 C2 89 55 F0 83 7D F0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 13 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 13 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 59 01 00 00 83 7D 08 00 75 11 8B 4D 10 83 39 00 75 09 C7 45 E8 00 00 00 00 EB 07 C7 45 E8 01 00 00 00 8B 55 E8 89 55 EC 83 7D EC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 14 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D EC 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 14 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 DE 00 00 00 83 7D 08 00 75 08 8B 4D 10 8B 11 89 55 08 EB 09 8B 45 08 83 C0 02 89 45 08 8B 4D 08 0F B7 11 85 D2 74 3B 8B 45 0C 89 45 F8 EB 09 8B 4D F8 83 C1 02 89 4D F8 8B 55 F8 0F B7 02 85 C0 74 12 8B 4D F8 0F B7 11 8B 45 08 0F B7 08 3B D1 74 02 EB DB 8B 55 F8 0F B7 02 85 C0 75 02 EB 02 EB B2 8B 4D 08 89 4D FC EB 09 8B 55 08 83 C2 02 89 55 08 8B 45 08 0F B7 08 85 C9 74 4C 8B 55 0C 89 55 F8 EB 09 8B 45 F8 83 C0 02 89 45 F8 8B 4D F8 0F B7 11 85 D2 74 12 8B 45 F8 0F B7 08 8B 55 08 0F B7 02 3B C8 74 02 EB DB 8B 4D F8 0F B7 11 85 D2 74 13 8B 45 08 66 C7 00 00 00 8B 4D 08 83 C1 02 89 4D 08 EB 02 EB A1 8B 55 10 8B 45 08 89 02 8B 4D FC 3B 4D 08 75 06 33 C0 EB 05 EB 03 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_179_0_0 {
	meta:
		name = "__CIasin_pentium4"
		size = 1408
		refs = "0022 ABSVALMASK 002a ONEMASK 0036 TMASK 0094 T_table 00a1 Tbl_addr 00cd cv 0165 HALFMASK2 01c1 PI_BY_2 0279 cv2 02fe HALFMASK 04d4 ___libm_error_support"
	strings:
		$1 = { 55 8B EC 83 EC 08 83 E4 F0 DD 1C 24 F3 0F 7E 04 24 E8 08 00 00 00 C9 C3 66 0F 12 44 24 04 66 0F 12 25 ?? ?? ?? ?? 66 0F 12 1D ?? ?? ?? ?? 66 0F 57 ED 66 0F 12 15 ?? ?? ?? ?? F2 0F 10 C8 66 0F 73 D0 2C 66 0F 7E C2 F2 0F 10 F9 B9 00 20 00 00 66 0F C4 E9 02 F2 0F 10 C1 B8 FF FF 07 00 23 C2 2D 00 FB 03 00 3D BB 03 00 00 0F 83 CE 00 00 00 F2 0F 59 C9 81 E2 FF FF 00 00 F2 0F 5C D9 F2 0F 51 DB 66 0F 54 D7 83 E2 FC 81 EA 00 FB 00 00 66 0F 12 0C 55 ?? ?? ?? ?? 66 0F 56 D5 66 0F 28 24 95 ?? ?? ?? ?? F2 0F 10 F7 F2 0F 58 FA F2 0F 5C C2 F2 0F 59 C7 F2 0F 59 F1 F2 0F 59 DA F2 0F 10 CE F2 0F 58 F3 F2 0F 5E C6 66 0F 12 3D ?? ?? ?? ?? 66 0F 12 2D ?? ?? ?? ?? F2 0F 5C CB 66 0F 73 D2 3F F2 0F 10 D9 66 0F 73 F2 3F F2 0F 59 C9 66 0F 70 D2 44 66 0F 12 35 ?? ?? ?? ?? F2 0F 59 D9 F2 0F 59 F9 83 EC 10 66 0F 57 E2 F2 0F 59 EB F2 0F 59 D9 F2 0F 58 F7 F2 0F 59 F3 F2 0F 58 EC 66 0F 70 E4 EE F2 0F 58 F5 F2 0F 58 C6 F2 0F 58 C4 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 2D BB 03 00 00 83 F8 43 0F 83 19 01 00 00 F2 0F 59 C9 F2 0F 5C D9 F2 0F 51 DB 66 0F D7 C7 66 0F 73 F0 01 66 0F 54 3D ?? ?? ?? ?? 66 0F 73 D0 01 F2 0F 10 C8 66 0F 12 25 ?? ?? ?? ?? F2 0F 10 F7 F2 0F 5C CF F2 0F 59 FF F2 0F 58 C6 F2 0F 5C E7 F2 0F 59 C1 F2 0F 10 FB 66 0F 54 D3 66 0F 73 F3 02 66 0F C5 D3 03 66 0F 56 D5 81 EA C0 FE 00 00 03 D2 F2 0F 59 3C 95 ?? ?? ?? ?? F2 0F 59 F2 66 0F 28 1D ?? ?? ?? ?? F2 0F 59 CA F2 0F 59 D2 F2 0F 5C F7 F2 0F 58 F1 F2 0F 5C E2 F2 0F 58 FF 66 0F 12 2D ?? ?? ?? ?? F2 0F 5C E0 F2 0F 58 FE 66 0F 12 05 ?? ?? ?? ?? F2 0F 5E E7 66 0F 12 15 ?? ?? ?? ?? 66 0F 5C 1C D5 ?? ?? ?? ?? F2 0F 10 CE F2 0F 59 F6 25 80 00 00 00 C1 E0 08 F2 0F 59 C6 F2 0F 59 CE 83 EC 10 F2 0F 59 E9 F2 0F 59 CE F2 0F 58 C2 66 0F EF F6 F2 0F 59 C1 F2 0F 58 EB 66 0F C4 F0 03 F2 0F 58 C5 66 0F 70 DB EE F2 0F 5C C4 F2 0F 58 C3 66 0F 56 C6 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 05 BB 3B 00 00 3D 00 38 00 00 73 6A 66 0F 14 FF 66 0F 28 35 ?? ?? ?? ?? 66 0F 14 CF 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 25 ?? ?? ?? ?? 66 0F 59 FF 83 EC 10 66 0F 59 CF 66 0F 59 F7 66 0F 59 FF F2 0F 10 D9 F2 0F 59 C9 66 0F 58 F2 66 0F 59 E7 F2 0F 59 CB 66 0F 58 F4 66 0F 59 CE 66 0F 70 D1 EE F2 0F 58 CA F2 0F 58 C1 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 2D FE 3B 00 00 83 F8 02 0F 83 4F 01 00 00 F2 0F 59 C9 F2 0F 5C D9 F2 0F 51 DB 66 0F C5 C7 03 66 0F 54 3D ?? ?? ?? ?? 66 0F 70 EB 44 66 0F 54 1D ?? ?? ?? ?? F2 0F 10 CF 66 0F 12 25 ?? ?? ?? ?? F2 0F 10 F7 F2 0F 5C C7 F2 0F 59 FF F2 0F 58 C9 F2 0F 59 C8 F2 0F 5C E7 F2 0F 10 F3 F2 0F 59 DB F2 0F 59 C0 F2 0F 5C E1 F2 0F 5C F5 F2 0F 58 ED F2 0F 5C E3 66 0F 28 15 ?? ?? ?? ?? 66 0F 70 DD EE F2 0F 5C E0 F2 0F 58 EE 66 0F 70 FB EE F2 0F 58 DB F2 0F 59 EE F2 0F 58 E5 66 0F 70 F7 EE F2 0F 5E E3 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 2D ?? ?? ?? ?? 66 0F 28 05 ?? ?? ?? ?? 66 0F 59 FF F2 0F 10 DE 66 0F 59 D7 66 0F 59 F7 25 00 80 00 00 F2 0F 59 CF 66 0F 59 FF 66 0F 58 EA 66 0F 28 D6 F2 0F 59 F6 66 0F 59 F8 66 0F 28 05 ?? ?? ?? ?? F2 0F 59 D6 66 0F 58 FD 66 0F 70 E9 EE F2 0F 59 F2 83 EC 10 66 0F 59 FA F2 0F 58 CD 66 0F 57 ED 66 0F 70 D7 EE F2 0F 59 CE 66 0F 70 F0 EE F2 0F 58 FA F2 0F 10 D3 66 0F C4 E8 03 F2 0F 5C DE F2 0F 58 C1 F2 0F 58 F3 F2 0F 58 FC F2 0F 5C D6 F2 0F 5C C7 F2 0F 5C C2 F2 0F 5C C3 66 0F 56 C5 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 05 FE FE 03 00 3D 00 FF 03 00 0F 82 F7 00 00 00 66 0F 7E C1 66 0F 73 D0 20 66 0F 7E C2 81 E2 FF FF FF 7F B8 00 00 F0 3F 2B C2 0B C1 83 F8 00 0F 84 85 00 00 00 66 0F 12 54 24 04 66 0F 7E D2 66 0F 73 D2 20 66 0F 7E D1 81 E1 FF FF FF 7F 83 EA 01 81 D9 00 00 F0 7F 83 F9 00 0F 8D 8F 00 00 00 66 0F 57 C9 66 0F 57 C0 BA F0 7F 00 00 66 0F C4 CA 03 F2 0F 59 C1 BA 3D 00 00 00 83 EC 1C 66 0F 13 44 24 10 89 54 24 0C 8B D4 83 C2 10 89 54 24 08 83 C2 10 89 54 24 04 89 14 24 E8 ?? ?? ?? ?? 66 0F 12 44 24 10 83 C4 1C 83 EC 10 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 66 0F 12 0D ?? ?? ?? ?? 66 0F 12 15 ?? ?? ?? ?? 66 0F 12 05 ?? ?? ?? ?? F2 0F 58 C2 66 0F 55 CF 66 0F 56 C1 83 EC 10 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 66 0F 12 44 24 04 66 0F 57 F6 F2 0F 58 C6 BA F1 03 00 00 E9 74 FF FF FF 66 0F 12 44 24 04 66 0F 57 F6 83 EC 10 F2 0F 10 F8 66 0F C5 D0 03 81 E2 F0 7F 00 00 83 EA 10 81 FA E0 7F 00 00 72 0C F2 0F 58 F0 66 0F 56 C6 F2 0F 59 F8 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 }
	condition:
		$1
}

rule file_180_0_0 {
	meta:
		name = "__strncoll_l"
		size = 519
		refs = "0026 ??_C@_1CC@ICKKAGJA@?$AA_?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA1?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 002f ??_C@_1BG@CDAIBILG@?$AAs?$AAt?$AAr?$AAn?$AAc?$AAo?$AAl?$AAl?$AA?4?$AAc?$AA?$AA@ 0036 __CrtDbgReportW 004a __errno 005e ??_C@_1BI@KFPCDAF@?$AA_?$AAs?$AAt?$AAr?$AAn?$AAc?$AAo?$AAl?$AAl?$AA_?$AAl?$AA?$AA@ 0068 __invalid_parameter 008c ??_C@_1CC@CNADELFK@?$AA_?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA2?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 00f2 ??_C@_1CC@JLPHKJPH@?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAI?$AAN?$AAT?$AA_?$AAM?$AAA?$AAX?$AA?$AA@ 014d ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0155 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 016e _strncmp 017c ??1_LocaleUpdate@@QAE@XZ 01c0 ___crtCompareStringA"
	strings:
		$1 = { 55 8B EC 83 EC 2C 83 7D 10 00 75 07 33 C0 E9 F0 01 00 00 33 C0 83 7D 08 00 0F 95 C0 89 45 E8 83 7D E8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3C 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E8 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 3C 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF FF 7F E9 8A 01 00 00 33 D2 83 7D 0C 00 0F 95 C2 89 55 E4 83 7D E4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3D 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E4 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 3D 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF FF 7F E9 24 01 00 00 B9 FF FF FF 7F 3B 4D 10 1B D2 83 C2 01 89 55 E0 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 3E 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF FF 7F E9 BE 00 00 00 8B 4D 14 51 8D 4D EC E8 ?? ?? ?? ?? 8D 4D EC E8 ?? ?? ?? ?? 8B 10 83 7A 10 00 75 24 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 89 45 DC 8D 4D EC E8 ?? ?? ?? ?? 8B 45 DC EB 7E 8D 4D EC E8 ?? ?? ?? ?? 8B 00 8B 48 08 51 8B 55 10 52 8B 45 0C 50 8B 4D 10 51 8B 55 08 52 68 00 10 00 00 8D 4D EC E8 ?? ?? ?? ?? 8B 00 8B 48 10 51 8D 4D EC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 20 89 45 FC 83 7D FC 00 75 1F E8 ?? ?? ?? ?? C7 00 16 00 00 00 C7 45 D8 FF FF FF 7F 8D 4D EC E8 ?? ?? ?? ?? 8B 45 D8 EB 14 8B 55 FC 83 EA 02 89 55 D4 8D 4D EC E8 ?? ?? ?? ?? 8B 45 D4 8B E5 5D C3 }
	condition:
		$1
}

rule file_180_4_0 {
	meta:
		name = "__strncoll"
		size = 372
		refs = "0008 ___locale_changed 0026 ??_C@_1CC@ICKKAGJA@?$AA_?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA1?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 002f ??_C@_1BG@CDAIBILG@?$AAs?$AAt?$AAr?$AAn?$AAc?$AAo?$AAl?$AAl?$AA?4?$AAc?$AA?$AA@ 0036 __CrtDbgReportW 004a __errno 005e ??_C@_1BE@IGINOLNE@?$AA_?$AAs?$AAt?$AAr?$AAn?$AAc?$AAo?$AAl?$AAl?$AA?$AA@ 0068 __invalid_parameter 008c ??_C@_1CC@CNADELFK@?$AA_?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA2?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 00f2 ??_C@_1CC@JLPHKJPH@?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAI?$AAN?$AAT?$AA_?$AAM?$AAA?$AAX?$AA?$AA@ 014f _strncmp 0169 __strncoll_l"
	strings:
		$1 = { 55 8B EC 83 EC 0C 83 3D ?? ?? ?? ?? 00 0F 85 47 01 00 00 33 C0 83 7D 08 00 0F 95 C0 89 45 FC 83 7D FC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 61 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D FC 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 61 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF FF 7F E9 F7 00 00 00 33 D2 83 7D 0C 00 0F 95 C2 89 55 F8 83 7D F8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 62 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F8 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 62 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF FF 7F E9 91 00 00 00 B9 FF FF FF 7F 3B 4D 10 1B D2 83 C2 01 89 55 F4 75 1E 68 ?? ?? ?? ?? 6A 00 6A 63 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F4 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 63 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF FF 7F EB 2E 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C EB 18 EB 16 6A 00 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_181_0_0 {
	meta:
		name = "__mbsbtype_l"
		size = 416
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0025 ??_C@_1BO@JIBAMMGI@?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 002e ??_C@_1BG@KPFPNJFD@?$AAm?$AAb?$AAs?$AAb?$AAt?$AAy?$AAp?$AAe?$AA?4?$AAc?$AA?$AA@ 0035 __CrtDbgReportW 0049 __errno 005d ??_C@_1BI@IGAIOCOA@?$AA_?$AAm?$AAb?$AAs?$AAb?$AAt?$AAy?$AAp?$AAe?$AA_?$AAl?$AA?$AA@ 0067 __invalid_parameter 0079 ??1_LocaleUpdate@@QAE@XZ 0089 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 00ed ??_C@_1CA@MCAHMKMK@?$AA?$CK?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA?8?$AA?2?$AA0?$AA?8?$AA?$AA@ 0164 __mbbtype_l"
	strings:
		$1 = { 55 8B EC 83 EC 34 8B 45 10 50 8D 4D EC E8 ?? ?? ?? ?? 33 C9 83 7D 08 00 0F 95 C1 89 4D E8 83 7D E8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 40 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E8 00 75 3D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 40 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 E0 FF FF FF FF 8D 4D EC E8 ?? ?? ?? ?? 8B 45 E0 E9 17 01 00 00 8D 4D EC E8 ?? ?? ?? ?? 8B 40 04 83 78 08 00 75 17 C7 45 DC 00 00 00 00 8D 4D EC E8 ?? ?? ?? ?? 8B 45 DC E9 EF 00 00 00 C7 45 FC FF FF FF FF 83 7D 0C 00 75 21 8B 4D 08 0F B6 11 85 D2 75 17 C7 45 D8 FF FF FF FF 8D 4D EC E8 ?? ?? ?? ?? 8B 45 D8 E9 C1 00 00 00 8B 45 08 0F B6 08 F7 D9 1B C9 F7 D9 89 4D E4 75 1E 68 ?? ?? ?? ?? 6A 00 6A 50 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E4 00 75 3A E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 50 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 D4 FF FF FF FF 8D 4D EC E8 ?? ?? ?? ?? 8B 45 D4 EB 52 8B 45 08 8A 08 88 4D CF 8D 4D EC E8 ?? ?? ?? ?? 50 8B 55 FC 52 8A 45 CF 50 E8 ?? ?? ?? ?? 83 C4 0C 89 45 FC 8B 4D 08 83 C1 01 89 4D 08 8B 55 0C 8B 45 0C 83 E8 01 89 45 0C 85 D2 0F 85 29 FF FF FF 8B 4D FC 89 4D D0 8D 4D EC E8 ?? ?? ?? ?? 8B 45 D0 8B E5 5D C3 }
	condition:
		$1
}

rule file_183_0_0 {
	meta:
		name = "__woutput_l"
		size = 4244
		refs = "000a ___security_cookie 004f ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0073 ??_C@_1CC@FADMNIL@?$AA?$CI?$AAs?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 007f ??_C@_1GC@ELIAPJJM@?$AAf?$AA?3?$AA?2?$AAr?$AAt?$AAm?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2@ 0086 __CrtDbgReportW 009d __errno 00b4 ??_C@_1BG@BBCDFOMA@?$AA_?$AAw?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAl?$AA?$AA@ 00be __invalid_parameter 00d3 ??1_LocaleUpdate@@QAE@XZ 00fb ??_C@_1CC@MGIEJOME@?$AA?$CI?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 01e7 ___lookuptable 024b $LN154 026a _write_char 02d7 $LN150 02de $LN155 0330 _get_int_arg 03ed $LN151 03f4 $LN156 0528 $LN152 052f $LN157 0587 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 05ac __mbtowc_l 060c ___nullstring 0618 _strlen 0723 __isleadbyte_l 0758 ___wnullstring 07cc __get_printf_count_output 0808 ??_C@_1EK@PNGFDECN@?$AA?$CI?$AA?$CC?$AA?8?$AAn?$AA?8?$AA?5?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AAs?$AAp?$AAe?$AAc?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?5?$AAd?$AAi?$AAs?$AAa?$AAb?$AAl?$AAe?$AAd?$AA?$CC@ 092a ??_C@_0DB@FNNAMKJO@f?3?2rtm?2vctools?2crt_bld?2self_x86?2@ 093b __malloc_dbg 09ad __cfltcvt_tab 09b3 __decode_pointer 0aed _get_int64_arg 0cc0 __aullrem 0ce2 __aulldiv 0df3 _write_multi_char 0e0e _write_string 0f54 __free_dbg 0f87 @__security_check_cookie@4 0f90 $NORMAL_STATE$26262 0f94 $LN131 0f98 $LN130 0f9c $LN122 0fa0 $LN118 0fa4 $LN117 0fa8 $LN113 0fac $LN97 0fb0 $LN125 0fb4 $LN124 0fb8 $LN126 0fbc $LN127 0fc0 $LN123 0fc4 $LN128 0fdc $LN107 0fe0 $LN99 0fe4 $LN110 0fe8 $LN98 0fec $LN111 1020 $LN64 1024 $LN94 1028 $LN82 102c $LN46 1030 $LN88 1034 $LN63 1038 $LN92 103c $LN51 1040 $LN69 1044 $LN41 1048 $LN47 104c $LN80 1050 $LN49 1054 $LN44 1058 $LN95"
	strings:
		$1 = { 55 8B EC 81 EC E4 04 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 B8 C7 85 A0 FB FF FF 00 00 00 00 C7 45 F0 00 00 00 00 C7 45 E8 00 00 00 00 C7 45 D0 00 00 00 00 C7 45 E4 00 00 00 00 C7 45 D8 00 00 00 00 C7 45 F4 00 00 00 00 8B 45 10 50 8D 4D C0 E8 ?? ?? ?? ?? C7 45 E0 00 00 00 00 33 C9 83 7D 08 00 0F 95 C1 89 8D 9C FB FF FF 83 BD 9C FB FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 07 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 9C FB FF FF 00 75 46 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 07 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 44 FB FF FF FF FF FF FF 8D 4D C0 E8 ?? ?? ?? ?? 8B 85 44 FB FF FF E9 9F 0E 00 00 33 C0 83 7D 0C 00 0F 95 C0 89 85 98 FB FF FF 83 BD 98 FB FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 0C 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 98 FB FF FF 00 75 46 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 0C 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 40 FB FF FF FF FF FF FF 8D 4D C0 E8 ?? ?? ?? ?? 8B 85 40 FB FF FF E9 17 0E 00 00 C7 85 B4 FB FF FF 00 00 00 00 C7 45 DC 00 00 00 00 C7 85 A4 FB FF FF 00 00 00 00 C7 45 E0 00 00 00 00 C7 45 BC 00 00 00 00 8B 55 0C 66 8B 02 66 89 85 AC FB FF FF 0F B7 8D AC FB FF FF 8B 55 0C 83 C2 02 89 55 0C 85 C9 0F 84 AF 0D 00 00 83 BD B4 FB FF FF 00 0F 8C A2 0D 00 00 0F B7 85 AC FB FF FF 83 F8 20 7C 25 0F B7 8D AC FB FF FF 83 F9 78 7F 19 0F B7 95 AC FB FF FF 0F BE 82 ?? ?? ?? ?? 83 E0 0F 89 85 34 FB FF FF EB 0A C7 85 34 FB FF FF 00 00 00 00 8B 8D 34 FB FF FF 89 8D B0 FB FF FF 8B 95 B0 FB FF FF 8B 85 A4 FB FF FF 0F BE 8C D0 ?? ?? ?? ?? C1 F9 04 89 8D A4 FB FF FF 8B 95 A4 FB FF FF 89 95 30 FB FF FF 83 BD 30 FB FF FF 07 0F 87 20 0D 00 00 8B 85 30 FB FF FF FF 24 85 ?? ?? ?? ?? C7 45 F4 01 00 00 00 8D 8D B4 FB FF FF 51 8B 55 08 52 66 8B 85 AC FB FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C E9 EC 0C 00 00 C7 45 D4 00 00 00 00 8B 4D D4 89 4D D8 8B 55 D8 89 55 E8 8B 45 E8 89 45 E4 C7 45 F0 00 00 00 00 C7 45 D0 FF FF FF FF C7 45 F4 00 00 00 00 E9 B9 0C 00 00 0F B7 8D AC FB FF FF 89 8D 2C FB FF FF 8B 95 2C FB FF FF 83 EA 20 89 95 2C FB FF FF 83 BD 2C FB FF FF 10 77 4C 8B 85 2C FB FF FF 0F B6 88 ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? 8B 55 F0 83 CA 04 89 55 F0 EB 2D 8B 45 F0 83 C8 01 89 45 F0 EB 22 8B 4D F0 83 C9 02 89 4D F0 EB 17 8B 55 F0 81 CA 80 00 00 00 89 55 F0 EB 09 8B 45 F0 83 C8 08 89 45 F0 E9 43 0C 00 00 0F B7 8D AC FB FF FF 83 F9 2A 75 28 8D 55 14 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 E8 83 7D E8 00 7D 11 8B 45 F0 83 C8 04 89 45 F0 8B 4D E8 F7 D9 89 4D E8 EB 14 8B 55 E8 6B D2 0A 0F B7 85 AC FB FF FF 8D 4C 02 D0 89 4D E8 E9 F6 0B 00 00 C7 45 D0 00 00 00 00 E9 EA 0B 00 00 0F B7 95 AC FB FF FF 83 FA 2A 75 1E 8D 45 14 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 D0 83 7D D0 00 7D 07 C7 45 D0 FF FF FF FF EB 14 8B 4D D0 6B C9 0A 0F B7 95 AC FB FF FF 8D 44 11 D0 89 45 D0 E9 A7 0B 00 00 0F B7 8D AC FB FF FF 89 8D 28 FB FF FF 8B 95 28 FB FF FF 83 EA 49 89 95 28 FB FF FF 83 BD 28 FB FF FF 2E 0F 87 0D 01 00 00 8B 85 28 FB FF FF 0F B6 88 ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? 8B 55 0C 0F B7 02 83 F8 6C 75 17 8B 4D 0C 83 C1 02 89 4D 0C 8B 55 F0 81 CA 00 10 00 00 89 55 F0 EB 09 8B 45 F0 83 C8 10 89 45 F0 E9 C9 00 00 00 8B 4D 0C 0F B7 11 83 FA 36 75 25 8B 45 0C 0F B7 48 02 83 F9 34 75 19 8B 55 0C 83 C2 04 89 55 0C 8B 45 F0 0D 00 80 00 00 89 45 F0 E9 80 00 00 00 8B 4D 0C 0F B7 11 83 FA 33 75 22 8B 45 0C 0F B7 48 02 83 F9 32 75 16 8B 55 0C 83 C2 04 89 55 0C 8B 45 F0 25 FF 7F FF FF 89 45 F0 EB 53 8B 4D 0C 0F B7 11 83 FA 64 74 37 8B 45 0C 0F B7 08 83 F9 69 74 2C 8B 55 0C 0F B7 02 83 F8 6F 74 21 8B 4D 0C 0F B7 11 83 FA 75 74 16 8B 45 0C 0F B7 08 83 F9 78 74 0B 8B 55 0C 0F B7 02 83 F8 58 75 02 EB 0F C7 85 A4 FB FF FF 00 00 00 00 E9 77 FD FF FF EB 17 8B 4D F0 83 C9 20 89 4D F0 EB 0C 8B 55 F0 81 CA 00 08 00 00 89 55 F0 E9 6C 0A 00 00 0F B7 85 AC FB FF FF 89 85 24 FB FF FF 8B 8D 24 FB FF FF 83 E9 41 89 8D 24 FB FF FF 83 BD 24 FB FF FF 37 0F 87 50 08 00 00 8B 95 24 FB FF FF 0F B6 82 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 8B 4D F0 81 E1 30 08 00 00 75 09 8B 55 F0 83 CA 20 89 55 F0 C7 45 F4 01 00 00 00 8D 45 14 50 E8 ?? ?? ?? ?? 83 C4 04 66 89 85 A8 FB FF FF 8B 4D F0 83 E1 20 74 57 0F B7 95 A8 FB FF FF 81 E2 FF 00 00 00 88 95 94 FB FF FF C6 85 95 FB FF FF 00 8D 4D C0 E8 ?? ?? ?? ?? 50 8D 4D C0 E8 ?? ?? ?? ?? 8B 00 8B 88 AC 00 00 00 51 8D 95 94 FB FF FF 52 8D 85 B8 FB FF FF 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 7D 07 C7 45 D8 01 00 00 00 EB 0E 66 8B 8D A8 FB FF FF 66 89 8D B8 FB FF FF 8D 95 B8 FB FF FF 89 55 FC C7 45 DC 01 00 00 00 E9 8C 07 00 00 8D 45 14 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 90 FB FF FF 83 BD 90 FB FF FF 00 74 0C 8B 8D 90 FB FF FF 83 79 04 00 75 1A 8B 15 ?? ?? ?? ?? 89 55 FC 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 DC EB 50 8B 4D F0 81 E1 00 08 00 00 74 26 8B 95 90 FB FF FF 8B 42 04 89 45 FC 8B 8D 90 FB FF FF 0F BF 01 99 2B C2 D1 F8 89 45 DC C7 45 F4 01 00 00 00 EB 1F C7 45 F4 00 00 00 00 8B 95 90 FB FF FF 8B 42 04 89 45 FC 8B 8D 90 FB FF FF 0F BF 11 89 55 DC E9 F6 06 00 00 8B 45 F0 25 30 08 00 00 75 09 8B 4D F0 83 C9 20 89 4D F0 83 7D D0 FF 75 0C C7 85 20 FB FF FF FF FF FF 7F EB 09 8B 55 D0 89 95 20 FB FF FF 8B 85 20 FB FF FF 89 85 88 FB FF FF 8D 4D 14 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 8B 55 F0 83 E2 20 0F 84 82 00 00 00 83 7D FC 00 75 08 A1 ?? ?? ?? ?? 89 45 FC 8B 4D FC 89 8D 8C FB FF FF C7 45 DC 00 00 00 00 EB 09 8B 55 DC 83 C2 01 89 55 DC 8B 45 DC 3B 85 88 FB FF FF 7D 4C 8B 8D 8C FB FF FF 0F BE 11 85 D2 74 3F 8D 4D C0 E8 ?? ?? ?? ?? 50 8B 85 8C FB FF FF 0F B6 08 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 0F 8B 95 8C FB FF FF 83 C2 01 89 95 8C FB FF FF 8B 85 8C FB FF FF 83 C0 01 89 85 8C FB FF FF EB A0 EB 64 83 7D FC 00 75 09 8B 0D ?? ?? ?? ?? 89 4D FC C7 45 F4 01 00 00 00 8B 55 FC 89 95 84 FB FF FF 8B 85 88 FB FF FF 8B 8D 88 FB FF FF 83 E9 01 89 8D 88 FB FF FF 85 C0 74 1E 8B 95 84 FB FF FF 0F B7 02 85 C0 74 11 8B 8D 84 FB FF FF 83 C1 02 89 8D 84 FB FF FF EB C9 8B 95 84 FB FF FF 2B 55 FC D1 FA 89 55 DC E9 B6 05 00 00 8D 45 14 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 80 FB FF FF E8 ?? ?? ?? ?? 85 C0 0F 85 A4 00 00 00 33 C9 74 0C C7 85 1C FB FF FF 01 00 00 00 EB 0A C7 85 1C FB FF FF 00 00 00 00 8B 95 1C FB FF FF 89 95 7C FB FF FF 83 BD 7C FB FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 98 06 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 7C FB FF FF 00 75 46 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 98 06 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 3C FB FF FF FF FF FF FF 8D 4D C0 E8 ?? ?? ?? ?? 8B 85 3C FB FF FF E9 0A 07 00 00 E9 F3 04 00 00 8B 4D F0 83 E1 20 74 12 8B 95 80 FB FF FF 66 8B 85 B4 FB FF FF 66 89 02 EB 0E 8B 8D 80 FB FF FF 8B 95 B4 FB FF FF 89 11 C7 45 D8 01 00 00 00 E9 BF 04 00 00 C7 45 D4 01 00 00 00 0F B7 85 AC FB FF FF 83 C0 20 66 89 85 AC FB FF FF 8B 4D F0 83 C9 40 89 4D F0 8D 95 B8 FB FF FF 89 55 FC C7 45 BC 00 02 00 00 83 7D D0 00 7D 09 C7 45 D0 06 00 00 00 EB 2B 83 7D D0 00 75 15 0F B7 85 AC FB FF FF 83 F8 67 75 09 C7 45 D0 01 00 00 00 EB 10 81 7D D0 00 02 00 00 7E 07 C7 45 D0 00 02 00 00 81 7D D0 A3 00 00 00 7E 41 68 DD 06 00 00 68 ?? ?? ?? ?? 6A 02 8B 4D D0 81 C1 5D 01 00 00 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 E0 83 7D E0 00 74 13 8B 55 E0 89 55 FC 8B 45 D0 05 5D 01 00 00 89 45 BC EB 07 C7 45 D0 A3 00 00 00 8B 4D 14 83 C1 08 89 4D 14 8B 55 14 8B 42 F8 8B 4A FC 89 85 70 FB FF FF 89 8D 74 FB FF FF 8D 4D C0 E8 ?? ?? ?? ?? 50 8B 55 D4 52 8B 45 D0 50 0F BE 8D AC FB FF FF 51 8B 55 BC 52 8B 45 FC 50 8D 8D 70 FB FF FF 51 8B 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 04 FF D0 83 C4 1C 8B 45 F0 25 80 00 00 00 74 27 83 7D D0 00 75 21 8D 4D C0 E8 ?? ?? ?? ?? 50 8B 4D FC 51 8B 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 04 FF D0 83 C4 08 0F B7 85 AC FB FF FF 83 F8 67 75 2B 8B 4D F0 81 E1 80 00 00 00 75 20 8D 4D C0 E8 ?? ?? ?? ?? 50 8B 55 FC 52 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 FF D0 83 C4 08 8B 4D FC 0F BE 11 83 FA 2D 75 14 8B 45 F0 0D 00 01 00 00 89 45 F0 8B 4D FC 83 C1 01 89 4D FC 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 DC E9 15 03 00 00 8B 45 F0 83 C8 40 89 45 F0 C7 45 F8 0A 00 00 00 EB 71 C7 45 F8 0A 00 00 00 EB 68 C7 45 D0 08 00 00 00 C7 85 A0 FB FF FF 07 00 00 00 EB 0A C7 85 A0 FB FF FF 27 00 00 00 C7 45 F8 10 00 00 00 8B 4D F0 81 E1 80 00 00 00 74 1A 66 C7 45 EC 30 00 8B 95 A0 FB FF FF 83 C2 51 66 89 55 EE C7 45 E4 02 00 00 00 EB 1D C7 45 F8 08 00 00 00 8B 45 F0 25 80 00 00 00 74 0C 8B 4D F0 81 C9 00 02 00 00 89 4D F0 8B 55 F0 81 E2 00 80 00 00 74 1D 8D 45 14 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 60 FB FF FF 89 95 64 FB FF FF E9 B1 00 00 00 8B 4D F0 81 E1 00 10 00 00 74 1D 8D 55 14 52 E8 ?? ?? ?? ?? 83 C4 04 89 85 60 FB FF FF 89 95 64 FB FF FF E9 89 00 00 00 8B 45 F0 83 E0 20 74 44 8B 4D F0 83 E1 40 74 1E 8D 55 14 52 E8 ?? ?? ?? ?? 83 C4 04 0F BF C0 99 89 85 60 FB FF FF 89 95 64 FB FF FF EB 1C 8D 45 14 50 E8 ?? ?? ?? ?? 83 C4 04 0F B7 C0 99 89 85 60 FB FF FF 89 95 64 FB FF FF EB 3D 8B 4D F0 83 E1 40 74 1B 8D 55 14 52 E8 ?? ?? ?? ?? 83 C4 04 99 89 85 60 FB FF FF 89 95 64 FB FF FF EB 1A 8D 45 14 50 E8 ?? ?? ?? ?? 83 C4 04 33 C9 89 85 60 FB FF FF 89 8D 64 FB FF FF 8B 55 F0 83 E2 40 74 41 83 BD 64 FB FF FF 00 7F 38 7C 09 83 BD 60 FB FF FF 00 73 2D 8B 85 60 FB FF FF F7 D8 8B 8D 64 FB FF FF 83 D1 00 F7 D9 89 85 58 FB FF FF 89 8D 5C FB FF FF 8B 55 F0 81 CA 00 01 00 00 89 55 F0 EB 18 8B 85 60 FB FF FF 89 85 58 FB FF FF 8B 8D 64 FB FF FF 89 8D 5C FB FF FF 8B 55 F0 81 E2 00 80 00 00 75 25 8B 45 F0 25 00 10 00 00 75 1B 8B 8D 58 FB FF FF 8B 95 5C FB FF FF 83 E2 00 89 8D 58 FB FF FF 89 95 5C FB FF FF 83 7D D0 00 7D 09 C7 45 D0 01 00 00 00 EB 19 8B 45 F0 83 E0 F7 89 45 F0 81 7D D0 00 02 00 00 7E 07 C7 45 D0 00 02 00 00 8B 8D 58 FB FF FF 0B 8D 5C FB FF FF 75 07 C7 45 E4 00 00 00 00 8D 95 B7 FD FF FF 89 55 FC 8B 45 D0 8B 4D D0 83 E9 01 89 4D D0 85 C0 7F 0E 8B 95 58 FB FF FF 0B 95 5C FB FF FF 74 7B 8B 45 F8 99 52 50 8B 85 5C FB FF FF 50 8B 8D 58 FB FF FF 51 E8 ?? ?? ?? ?? 83 C0 30 89 85 6C FB FF FF 8B 45 F8 99 52 50 8B 95 5C FB FF FF 52 8B 85 58 FB FF FF 50 E8 ?? ?? ?? ?? 89 85 58 FB FF FF 89 95 5C FB FF FF 83 BD 6C FB FF FF 39 7E 12 8B 8D 6C FB FF FF 03 8D A0 FB FF FF 89 8D 6C FB FF FF 8B 55 FC 8A 85 6C FB FF FF 88 02 8B 4D FC 83 E9 01 89 4D FC E9 67 FF FF FF 8D 95 B7 FD FF FF 2B 55 FC 89 55 DC 8B 45 FC 83 C0 01 89 45 FC 8B 4D F0 81 E1 00 02 00 00 74 29 83 7D DC 00 74 0B 8B 55 FC 0F BE 02 83 F8 30 74 18 8B 4D FC 83 E9 01 89 4D FC 8B 55 FC C6 02 30 8B 45 DC 83 C0 01 89 45 DC 83 7D D8 00 0F 85 CE 01 00 00 8B 4D F0 83 E1 40 74 46 8B 55 F0 81 E2 00 01 00 00 74 0F 66 C7 45 EC 2D 00 C7 45 E4 01 00 00 00 EB 2C 8B 45 F0 83 E0 01 74 0F 66 C7 45 EC 2B 00 C7 45 E4 01 00 00 00 EB 15 8B 4D F0 83 E1 02 74 0D 66 C7 45 EC 20 00 C7 45 E4 01 00 00 00 8B 55 E8 2B 55 DC 2B 55 E4 89 95 54 FB FF FF 8B 45 F0 83 E0 0C 75 1C 8D 8D B4 FB FF FF 51 8B 55 08 52 8B 85 54 FB FF FF 50 6A 20 E8 ?? ?? ?? ?? 83 C4 10 8D 8D B4 FB FF FF 51 8B 55 08 52 8B 45 E4 50 8D 4D EC 51 E8 ?? ?? ?? ?? 83 C4 10 8B 55 F0 83 E2 08 74 24 8B 45 F0 83 E0 04 75 1C 8D 8D B4 FB FF FF 51 8B 55 08 52 8B 85 54 FB FF FF 50 6A 30 E8 ?? ?? ?? ?? 83 C4 10 83 7D F4 00 0F 85 B4 00 00 00 83 7D DC 00 0F 8E AA 00 00 00 8B 4D FC 89 8D 50 FB FF FF 8B 55 DC 89 95 4C FB FF FF 8B 85 4C FB FF FF 8B 8D 4C FB FF FF 83 E9 01 89 8D 4C FB FF FF 85 C0 7E 7D 8D 4D C0 E8 ?? ?? ?? ?? 50 8D 4D C0 E8 ?? ?? ?? ?? 8B 10 8B 82 AC 00 00 00 50 8B 8D 50 FB FF FF 51 8D 95 A8 FB FF FF 52 E8 ?? ?? ?? ?? 83 C4 10 89 85 48 FB FF FF 83 BD 48 FB FF FF 00 7F 0C C7 85 B4 FB FF FF FF FF FF FF EB 32 8D 85 B4 FB FF FF 50 8B 4D 08 51 66 8B 95 A8 FB FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 85 50 FB FF FF 03 85 48 FB FF FF 89 85 50 FB FF FF E9 6A FF FF FF EB 1B 8D 8D B4 FB FF FF 51 8B 55 08 52 8B 45 DC 50 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 10 83 BD B4 FB FF FF 00 7C 24 8B 55 F0 83 E2 04 74 1C 8D 85 B4 FB FF FF 50 8B 4D 08 51 8B 95 54 FB FF FF 52 6A 20 E8 ?? ?? ?? ?? 83 C4 10 83 7D E0 00 74 15 6A 02 8B 45 E0 50 E8 ?? ?? ?? ?? 83 C4 08 C7 45 E0 00 00 00 00 E9 2C F2 FF FF 8B 8D B4 FB FF FF 89 8D 38 FB FF FF 8D 4D C0 E8 ?? ?? ?? ?? 8B 85 38 FB FF FF 8B 4D B8 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 05 05 01 05 05 05 05 05 05 05 02 05 03 05 05 04 8D 49 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 }
	condition:
		$1
}

rule file_184_0_0 {
	meta:
		name = "__output_s_l"
		size = 5176
		refs = "000a ___security_cookie 0050 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0074 ??_C@_1CC@FADMNIL@?$AA?$CI?$AAs?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0080 ??_C@_1GC@ELIAPJJM@?$AAf?$AA?3?$AA?2?$AAr?$AAt?$AAm?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2@ 0087 __CrtDbgReportW 009e __errno 00b5 ??_C@_1BI@COFBLHCG@?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAs?$AA_?$AAl?$AA?$AA@ 00bf __invalid_parameter 00d4 ??1_LocaleUpdate@@QAE@XZ 0106 __fileno 0152 ___pioinfo 0164 ___badioinfo 022c ??_C@_1BAE@CBLKKPB@?$AA?$CI?$AA?5?$AA?$CI?$AA_?$AAS?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?9?$AA?$DO?$AA_?$AAf?$AAl?$AAa?$AAg?$AA?5?$AA?$CG?$AA?5?$AA_?$AAI?$AAO?$AAS?$AAT?$AAR?$AAG?$AA?$CJ?$AA?5?$AA?$HM?$AA?$HM?$AA?5@ 02b4 ??_C@_1CC@MGIEJOME@?$AA?$CI?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 039e ___lookuptable_s 03ff ??_C@_1CM@IEGCDOKE@?$AA?$CI?$AAs?$AAt?$AAa?$AAt?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAS?$AAT?$AA_?$AAI?$AAN?$AAV?$AAA?$AAL?$AAI?$AAD?$AA?$CJ?$AA?$AA@ 0490 $LN171 049f ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 04ad __isleadbyte_l 04cf _write_char 0500 ??_C@_1CC@IFFHEMNF@?$AA?$CI?$AAc?$AAh?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$CJ?$AA?$AA@ 05ef $LN167 05f6 $LN172 0648 _get_int_arg 0705 $LN168 070c $LN173 0840 $LN169 0847 $LN174 087b _get_short_arg 08a2 _wctomb_s 091e ___nullstring 092a _strlen 09e9 ___wnullstring 0aba __get_printf_count_output 0af6 ??_C@_1EK@PNGFDECN@?$AA?$CI?$AA?$CC?$AA?8?$AAn?$AA?8?$AA?5?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AAs?$AAp?$AAe?$AAc?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?5?$AAd?$AAi?$AAs?$AAa?$AAb?$AAl?$AAe?$AAd?$AA?$CC@ 0c17 ??_C@_0DB@FNNAMKJO@f?3?2rtm?2vctools?2crt_bld?2self_x86?2@ 0c28 __malloc_dbg 0c9a __cfltcvt_tab 0ca0 __decode_pointer 0dd7 _get_int64_arg 0fa7 __aullrem 0fc9 __aulldiv 10d1 _write_multi_char 10ec _write_string 124c __free_dbg 129d ??_C@_1FK@LNCFKALM@?$AA?$CI?$AA?$CI?$AAs?$AAt?$AAa?$AAt?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAS?$AAT?$AA_?$AAN?$AAO?$AAR?$AAM?$AAA?$AAL?$AA?$CJ?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AA?$CI?$AAs?$AAt?$AAa?$AAt?$AAe?$AA?5@ 132a @__security_check_cookie@4 1334 $NORMAL_STATE$25769 1338 $LN131 133c $LN130 1340 $LN122 1344 $LN118 1348 $LN117 134c $LN113 1350 $LN97 1354 $LN125 1358 $LN124 135c $LN126 1360 $LN127 1364 $LN123 1368 $LN128 1380 $LN107 1384 $LN99 1388 $LN110 138c $LN98 1390 $LN111 13c4 $LN66 13c8 $LN94 13cc $LN82 13d0 $LN48 13d4 $LN88 13d8 $LN65 13dc $LN92 13e0 $LN53 13e4 $LN71 13e8 $LN43 13ec $LN49 13f0 $LN80 13f4 $LN51 13f8 $LN46 13fc $LN95"
	strings:
		$1 = { 55 8B EC 81 EC 28 03 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 B8 56 C7 85 A0 FD FF FF 00 00 00 00 C7 45 F0 00 00 00 00 C7 45 E8 00 00 00 00 C7 45 D0 00 00 00 00 C7 45 E4 00 00 00 00 C7 45 D8 00 00 00 00 C7 45 F4 00 00 00 00 8B 45 10 50 8D 4D C0 E8 ?? ?? ?? ?? C7 45 E0 00 00 00 00 33 C9 83 7D 08 00 0F 95 C1 89 8D 9C FD FF FF 83 BD 9C FD FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 07 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 9C FD FF FF 00 75 46 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 07 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 24 FD FF FF FF FF FF FF 8D 4D C0 E8 ?? ?? ?? ?? 8B 85 24 FD FF FF E9 40 12 00 00 8B 45 08 89 85 98 FD FF FF 8B 8D 98 FD FF FF 8B 51 0C 83 E2 40 0F 85 0E 01 00 00 8B 85 98 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 83 F8 FF 74 4C 8B 8D 98 FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 83 F8 FE 74 38 8B 95 98 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 8B F0 C1 FE 05 8B 85 98 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 83 E0 1F 6B C0 28 03 04 B5 ?? ?? ?? ?? 89 85 04 FD FF FF EB 0A C7 85 04 FD FF FF ?? ?? ?? ?? 8B 8D 04 FD FF FF 8A 51 24 D0 E2 D0 FA 0F BE C2 85 C0 0F 85 80 00 00 00 8B 8D 98 FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 83 F8 FF 74 4C 8B 95 98 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 83 F8 FE 74 38 8B 85 98 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 8B F0 C1 FE 05 8B 8D 98 FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 83 E0 1F 6B C0 28 03 04 B5 ?? ?? ?? ?? 89 85 00 FD FF FF EB 0A C7 85 00 FD FF FF ?? ?? ?? ?? 8B 95 00 FD FF FF 8A 42 24 C0 E0 00 C0 F8 07 0F BE C8 85 C9 74 0C C7 85 FC FC FF FF 00 00 00 00 EB 0A C7 85 FC FC FF FF 01 00 00 00 8B 95 FC FC FF FF 89 95 94 FD FF FF 83 BD 94 FD FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 09 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 94 FD FF FF 00 75 46 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 09 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 20 FD FF FF FF FF FF FF 8D 4D C0 E8 ?? ?? ?? ?? 8B 85 20 FD FF FF E9 88 10 00 00 33 C9 83 7D 0C 00 0F 95 C1 89 8D 90 FD FF FF 83 BD 90 FD FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 0C 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 90 FD FF FF 00 75 46 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 0C 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 1C FD FF FF FF FF FF FF 8D 4D C0 E8 ?? ?? ?? ?? 8B 85 1C FD FF FF E9 00 10 00 00 C7 85 B4 FD FF FF 00 00 00 00 C7 45 DC 00 00 00 00 C7 85 A4 FD FF FF 00 00 00 00 C7 45 E0 00 00 00 00 C7 45 BC 00 00 00 00 8B 45 0C 8A 08 88 8D AF FD FF FF 0F BE 95 AF FD FF FF 8B 45 0C 83 C0 01 89 45 0C 85 D2 0F 84 F0 0E 00 00 83 BD B4 FD FF FF 00 0F 8C E3 0E 00 00 0F BE 8D AF FD FF FF 83 F9 20 7C 25 0F BE 95 AF FD FF FF 83 FA 78 7F 19 0F BE 85 AF FD FF FF 0F B6 88 ?? ?? ?? ?? 83 E1 0F 89 8D F8 FC FF FF EB 0A C7 85 F8 FC FF FF 00 00 00 00 8B 95 F8 FC FF FF 89 95 B0 FD FF FF 8B 85 B0 FD FF FF 6B C0 09 8B 8D A4 FD FF FF 0F B6 94 08 ?? ?? ?? ?? C1 FA 04 89 95 A4 FD FF FF 33 C0 83 BD A4 FD FF FF 08 0F 95 C0 89 85 8C FD FF FF 83 BD 8C FD FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 63 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 8C FD FF FF 00 75 46 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 63 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 18 FD FF FF FF FF FF FF 8D 4D C0 E8 ?? ?? ?? ?? 8B 85 18 FD FF FF E9 B5 0E 00 00 8B 95 A4 FD FF FF 89 95 F4 FC FF FF 83 BD F4 FC FF FF 07 0F 87 D3 0D 00 00 8B 85 F4 FC FF FF FF 24 85 ?? ?? ?? ?? C7 45 F4 00 00 00 00 8D 4D C0 E8 ?? ?? ?? ?? 50 0F B6 8D AF FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 0F 84 B3 00 00 00 8D 95 B4 FD FF FF 52 8B 45 08 50 8A 8D AF FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 0C 8A 02 88 85 AF FD FF FF 8B 4D 0C 83 C1 01 89 4D 0C 0F BE 95 AF FD FF FF F7 DA 1B D2 F7 DA 89 95 88 FD FF FF 75 21 68 ?? ?? ?? ?? 6A 00 68 89 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 88 FD FF FF 00 75 46 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 89 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 14 FD FF FF FF FF FF FF 8D 4D C0 E8 ?? ?? ?? ?? 8B 85 14 FD FF FF E9 B4 0D 00 00 8D 8D B4 FD FF FF 51 8B 55 08 52 8A 85 AF FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C E9 CC 0C 00 00 C7 45 D4 00 00 00 00 8B 4D D4 89 4D D8 8B 55 D8 89 55 E8 8B 45 E8 89 45 E4 C7 45 F0 00 00 00 00 C7 45 D0 FF FF FF FF C7 45 F4 00 00 00 00 E9 99 0C 00 00 0F BE 8D AF FD FF FF 89 8D F0 FC FF FF 8B 95 F0 FC FF FF 83 EA 20 89 95 F0 FC FF FF 83 BD F0 FC FF FF 10 77 4C 8B 85 F0 FC FF FF 0F B6 88 ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? 8B 55 F0 83 CA 04 89 55 F0 EB 2D 8B 45 F0 83 C8 01 89 45 F0 EB 22 8B 4D F0 83 C9 02 89 4D F0 EB 17 8B 55 F0 81 CA 80 00 00 00 89 55 F0 EB 09 8B 45 F0 83 C8 08 89 45 F0 E9 23 0C 00 00 0F BE 8D AF FD FF FF 83 F9 2A 75 28 8D 55 14 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 E8 83 7D E8 00 7D 11 8B 45 F0 83 C8 04 89 45 F0 8B 4D E8 F7 D9 89 4D E8 EB 14 8B 55 E8 6B D2 0A 0F BE 85 AF FD FF FF 8D 4C 02 D0 89 4D E8 E9 D6 0B 00 00 C7 45 D0 00 00 00 00 E9 CA 0B 00 00 0F BE 95 AF FD FF FF 83 FA 2A 75 1E 8D 45 14 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 D0 83 7D D0 00 7D 07 C7 45 D0 FF FF FF FF EB 14 8B 4D D0 6B C9 0A 0F BE 95 AF FD FF FF 8D 44 11 D0 89 45 D0 E9 87 0B 00 00 0F BE 8D AF FD FF FF 89 8D EC FC FF FF 8B 95 EC FC FF FF 83 EA 49 89 95 EC FC FF FF 83 BD EC FC FF FF 2E 0F 87 0D 01 00 00 8B 85 EC FC FF FF 0F B6 88 ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? 8B 55 0C 0F BE 02 83 F8 6C 75 17 8B 4D 0C 83 C1 01 89 4D 0C 8B 55 F0 81 CA 00 10 00 00 89 55 F0 EB 09 8B 45 F0 83 C8 10 89 45 F0 E9 C9 00 00 00 8B 4D 0C 0F BE 11 83 FA 36 75 25 8B 45 0C 0F BE 48 01 83 F9 34 75 19 8B 55 0C 83 C2 02 89 55 0C 8B 45 F0 0D 00 80 00 00 89 45 F0 E9 80 00 00 00 8B 4D 0C 0F BE 11 83 FA 33 75 22 8B 45 0C 0F BE 48 01 83 F9 32 75 16 8B 55 0C 83 C2 02 89 55 0C 8B 45 F0 25 FF 7F FF FF 89 45 F0 EB 53 8B 4D 0C 0F BE 11 83 FA 64 74 37 8B 45 0C 0F BE 08 83 F9 69 74 2C 8B 55 0C 0F BE 02 83 F8 6F 74 21 8B 4D 0C 0F BE 11 83 FA 75 74 16 8B 45 0C 0F BE 08 83 F9 78 74 0B 8B 55 0C 0F BE 02 83 F8 58 75 02 EB 0F C7 85 A4 FD FF FF 00 00 00 00 E9 A4 FC FF FF EB 17 8B 4D F0 83 C9 20 89 4D F0 EB 0C 8B 55 F0 81 CA 00 08 00 00 89 55 F0 E9 4C 0A 00 00 0F BE 85 AF FD FF FF 89 85 E8 FC FF FF 8B 8D E8 FC FF FF 83 E9 41 89 8D E8 FC FF FF 83 BD E8 FC FF FF 37 0F 87 1C 08 00 00 8B 95 E8 FC FF FF 0F B6 82 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 8B 4D F0 81 E1 30 08 00 00 75 0C 8B 55 F0 81 CA 00 08 00 00 89 55 F0 8B 45 F0 25 10 08 00 00 74 55 C7 85 84 FD FF FF 00 00 00 00 8D 4D 14 51 E8 ?? ?? ?? ?? 83 C4 04 66 89 85 A8 FD FF FF 66 8B 95 A8 FD FF FF 52 68 00 02 00 00 8D 85 B8 FD FF FF 50 8D 4D DC 51 E8 ?? ?? ?? ?? 83 C4 10 89 85 84 FD FF FF 83 BD 84 FD FF FF 00 74 07 C7 45 D8 01 00 00 00 EB 26 8D 55 14 52 E8 ?? ?? ?? ?? 83 C4 04 66 89 85 80 FD FF FF 8A 85 80 FD FF FF 88 85 B8 FD FF FF C7 45 DC 01 00 00 00 8D 8D B8 FD FF FF 89 4D FC E9 5E 07 00 00 8D 55 14 52 E8 ?? ?? ?? ?? 83 C4 04 89 85 7C FD FF FF 83 BD 7C FD FF FF 00 74 0C 8B 85 7C FD FF FF 83 78 04 00 75 1A 8B 0D ?? ?? ?? ?? 89 4D FC 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 DC EB 4F 8B 45 F0 25 00 08 00 00 74 26 8B 8D 7C FD FF FF 8B 51 04 89 55 FC 8B 85 7C FD FF FF 0F BF 00 99 2B C2 D1 F8 89 45 DC C7 45 F4 01 00 00 00 EB 1F C7 45 F4 00 00 00 00 8B 8D 7C FD FF FF 8B 51 04 89 55 FC 8B 85 7C FD FF FF 0F BF 08 89 4D DC E9 C9 06 00 00 8B 55 F0 81 E2 30 08 00 00 75 0B 8B 45 F0 0D 00 08 00 00 89 45 F0 83 7D D0 FF 75 0C C7 85 E4 FC FF FF FF FF FF 7F EB 09 8B 4D D0 89 8D E4 FC FF FF 8B 95 E4 FC FF FF 89 95 74 FD FF FF 8D 45 14 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 8B 4D F0 81 E1 10 08 00 00 74 66 83 7D FC 00 75 09 8B 15 ?? ?? ?? ?? 89 55 FC C7 45 F4 01 00 00 00 8B 45 FC 89 85 70 FD FF FF 8B 8D 74 FD FF FF 8B 95 74 FD FF FF 83 EA 01 89 95 74 FD FF FF 85 C9 74 1E 8B 85 70 FD FF FF 0F B7 08 85 C9 74 11 8B 95 70 FD FF FF 83 C2 02 89 95 70 FD FF FF EB C9 8B 85 70 FD FF FF 2B 45 FC D1 F8 89 45 DC EB 5B 83 7D FC 00 75 09 8B 0D ?? ?? ?? ?? 89 4D FC 8B 55 FC 89 95 78 FD FF FF 8B 85 74 FD FF FF 8B 8D 74 FD FF FF 83 E9 01 89 8D 74 FD FF FF 85 C0 74 1E 8B 95 78 FD FF FF 0F BE 02 85 C0 74 11 8B 8D 78 FD FF FF 83 C1 01 89 8D 78 FD FF FF EB C9 8B 95 78 FD FF FF 2B 55 FC 89 55 DC E9 AC 05 00 00 8D 45 14 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 6C FD FF FF E8 ?? ?? ?? ?? 85 C0 0F 85 A4 00 00 00 33 C9 74 0C C7 85 E0 FC FF FF 01 00 00 00 EB 0A C7 85 E0 FC FF FF 00 00 00 00 8B 95 E0 FC FF FF 89 95 68 FD FF FF 83 BD 68 FD FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 98 06 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 68 FD FF FF 00 75 46 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 98 06 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 10 FD FF FF FF FF FF FF 8D 4D C0 E8 ?? ?? ?? ?? 8B 85 10 FD FF FF E9 BE 07 00 00 E9 E9 04 00 00 8B 4D F0 83 E1 20 74 12 8B 95 6C FD FF FF 66 8B 85 B4 FD FF FF 66 89 02 EB 0E 8B 8D 6C FD FF FF 8B 95 B4 FD FF FF 89 11 C7 45 D8 01 00 00 00 E9 B5 04 00 00 C7 45 D4 01 00 00 00 0F BE 85 AF FD FF FF 83 C0 20 88 85 AF FD FF FF 8B 4D F0 83 C9 40 89 4D F0 8D 95 B8 FD FF FF 89 55 FC C7 45 BC 00 02 00 00 83 7D D0 00 7D 09 C7 45 D0 06 00 00 00 EB 2B 83 7D D0 00 75 15 0F BE 85 AF FD FF FF 83 F8 67 75 09 C7 45 D0 01 00 00 00 EB 10 81 7D D0 00 02 00 00 7E 07 C7 45 D0 00 02 00 00 81 7D D0 A3 00 00 00 7E 41 68 DD 06 00 00 68 ?? ?? ?? ?? 6A 02 8B 4D D0 81 C1 5D 01 00 00 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 E0 83 7D E0 00 74 13 8B 55 E0 89 55 FC 8B 45 D0 05 5D 01 00 00 89 45 BC EB 07 C7 45 D0 A3 00 00 00 8B 4D 14 83 C1 08 89 4D 14 8B 55 14 8B 42 F8 8B 4A FC 89 85 60 FD FF FF 89 8D 64 FD FF FF 8D 4D C0 E8 ?? ?? ?? ?? 50 8B 55 D4 52 8B 45 D0 50 0F BE 8D AF FD FF FF 51 8B 55 BC 52 8B 45 FC 50 8D 8D 60 FD FF FF 51 8B 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 04 FF D0 83 C4 1C 8B 45 F0 25 80 00 00 00 74 27 83 7D D0 00 75 21 8D 4D C0 E8 ?? ?? ?? ?? 50 8B 4D FC 51 8B 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 04 FF D0 83 C4 08 0F BE 85 AF FD FF FF 83 F8 67 75 2B 8B 4D F0 81 E1 80 00 00 00 75 20 8D 4D C0 E8 ?? ?? ?? ?? 50 8B 55 FC 52 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 FF D0 83 C4 08 8B 4D FC 0F BE 11 83 FA 2D 75 14 8B 45 F0 0D 00 01 00 00 89 45 F0 8B 4D FC 83 C1 01 89 4D FC 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 DC E9 0C 03 00 00 8B 45 F0 83 C8 40 89 45 F0 C7 45 F8 0A 00 00 00 EB 6E C7 45 F8 0A 00 00 00 EB 65 C7 45 D0 08 00 00 00 C7 85 A0 FD FF FF 07 00 00 00 EB 0A C7 85 A0 FD FF FF 27 00 00 00 C7 45 F8 10 00 00 00 8B 4D F0 81 E1 80 00 00 00 74 17 C6 45 EC 30 8B 95 A0 FD FF FF 83 C2 51 88 55 ED C7 45 E4 02 00 00 00 EB 1D C7 45 F8 08 00 00 00 8B 45 F0 25 80 00 00 00 74 0C 8B 4D F0 81 C9 00 02 00 00 89 4D F0 8B 55 F0 81 E2 00 80 00 00 74 1D 8D 45 14 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 50 FD FF FF 89 95 54 FD FF FF E9 B1 00 00 00 8B 4D F0 81 E1 00 10 00 00 74 1D 8D 55 14 52 E8 ?? ?? ?? ?? 83 C4 04 89 85 50 FD FF FF 89 95 54 FD FF FF E9 89 00 00 00 8B 45 F0 83 E0 20 74 44 8B 4D F0 83 E1 40 74 1E 8D 55 14 52 E8 ?? ?? ?? ?? 83 C4 04 0F BF C0 99 89 85 50 FD FF FF 89 95 54 FD FF FF EB 1C 8D 45 14 50 E8 ?? ?? ?? ?? 83 C4 04 0F B7 C0 99 89 85 50 FD FF FF 89 95 54 FD FF FF EB 3D 8B 4D F0 83 E1 40 74 1B 8D 55 14 52 E8 ?? ?? ?? ?? 83 C4 04 99 89 85 50 FD FF FF 89 95 54 FD FF FF EB 1A 8D 45 14 50 E8 ?? ?? ?? ?? 83 C4 04 33 C9 89 85 50 FD FF FF 89 8D 54 FD FF FF 8B 55 F0 83 E2 40 74 41 83 BD 54 FD FF FF 00 7F 38 7C 09 83 BD 50 FD FF FF 00 73 2D 8B 85 50 FD FF FF F7 D8 8B 8D 54 FD FF FF 83 D1 00 F7 D9 89 85 48 FD FF FF 89 8D 4C FD FF FF 8B 55 F0 81 CA 00 01 00 00 89 55 F0 EB 18 8B 85 50 FD FF FF 89 85 48 FD FF FF 8B 8D 54 FD FF FF 89 8D 4C FD FF FF 8B 55 F0 81 E2 00 80 00 00 75 25 8B 45 F0 25 00 10 00 00 75 1B 8B 8D 48 FD FF FF 8B 95 4C FD FF FF 83 E2 00 89 8D 48 FD FF FF 89 95 4C FD FF FF 83 7D D0 00 7D 09 C7 45 D0 01 00 00 00 EB 19 8B 45 F0 83 E0 F7 89 45 F0 81 7D D0 00 02 00 00 7E 07 C7 45 D0 00 02 00 00 8B 8D 48 FD FF FF 0B 8D 4C FD FF FF 75 07 C7 45 E4 00 00 00 00 8D 55 B7 89 55 FC 8B 45 D0 8B 4D D0 83 E9 01 89 4D D0 85 C0 7F 0E 8B 95 48 FD FF FF 0B 95 4C FD FF FF 74 7B 8B 45 F8 99 52 50 8B 85 4C FD FF FF 50 8B 8D 48 FD FF FF 51 E8 ?? ?? ?? ?? 83 C0 30 89 85 5C FD FF FF 8B 45 F8 99 52 50 8B 95 4C FD FF FF 52 8B 85 48 FD FF FF 50 E8 ?? ?? ?? ?? 89 85 48 FD FF FF 89 95 4C FD FF FF 83 BD 5C FD FF FF 39 7E 12 8B 8D 5C FD FF FF 03 8D A0 FD FF FF 89 8D 5C FD FF FF 8B 55 FC 8A 85 5C FD FF FF 88 02 8B }
	condition:
		$1
}

rule file_185_0_0 {
	meta:
		name = "__chkstk"
		size = 43
	strings:
		$1 = { 51 8D 4C 24 04 2B C8 1B C0 F7 D0 23 C8 8B C4 25 00 F0 FF FF 3B C8 72 0A 8B C1 59 94 8B 00 89 04 24 C3 2D 00 10 00 00 85 00 EB E9 }
	condition:
		$1
}

rule file_186_0_0 {
	meta:
		name = "___crtGetLocaleInfoW"
		size = 73
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 002a ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0030 ?__crtGetLocaleInfoW_stat@@YAHPAUlocaleinfo_struct@@KKPA_WHH@Z 003e ??1_LocaleUpdate@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 83 EC 14 8B 45 08 50 8D 4D F0 E8 ?? ?? ?? ?? 8B 4D 1C 51 8B 55 18 52 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8D 4D F0 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 18 89 45 EC 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 EC 8B E5 5D C3 }
	condition:
		$1
}

rule file_847_0_0 {
	meta:
		name = "___crtGetLocaleInfoA"
		size = 73
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 002a ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0030 ?__crtGetLocaleInfoA_stat@@YAHPAUlocaleinfo_struct@@KKPADHH@Z 003e ??1_LocaleUpdate@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 83 EC 14 8B 45 08 50 8D 4D F0 E8 ?? ?? ?? ?? 8B 4D 1C 51 8B 55 18 52 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8D 4D F0 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 18 89 45 EC 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 EC 8B E5 5D C3 }
	condition:
		$1
}

rule file_186_4_0 {
	meta:
		name = "?__crtGetLocaleInfoW_stat@@YAHPAUlocaleinfo_struct@@KKPA_WHH@Z"
		size = 381
		refs = "0008 ?f_use@?1??__crtGetLocaleInfoW_stat@@YAHPAUlocaleinfo_struct@@KKPA_WHH@Z@4HA 0019 __imp__GetLocaleInfoW@16 002f __imp__GetLastError@0 00a2 __imp__GetLocaleInfoA@16 00dc _malloc 00e5 __MarkAllocaS 013e __imp__MultiByteToWideChar@24 0169 __freea"
	strings:
		$1 = { 55 8B EC 83 EC 10 83 3D ?? ?? ?? ?? 00 75 33 6A 00 6A 00 6A 01 6A 00 FF 15 ?? ?? ?? ?? 85 C0 74 0C C7 05 ?? ?? ?? ?? 01 00 00 00 EB 15 FF 15 ?? ?? ?? ?? 83 F8 78 75 0A C7 05 ?? ?? ?? ?? 02 00 00 00 83 3D ?? ?? ?? ?? 01 75 1B 8B 45 18 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 FF 15 ?? ?? ?? ?? E9 13 01 00 00 83 3D ?? ?? ?? ?? 02 74 0D 83 3D ?? ?? ?? ?? 00 0F 85 FB 00 00 00 C7 45 FC 00 00 00 00 83 7D 1C 00 75 0B 8B 4D 08 8B 11 8B 42 04 89 45 1C 6A 00 6A 00 8B 4D 10 51 8B 55 0C 52 FF 15 ?? ?? ?? ?? 89 45 F8 83 7D F8 00 75 07 33 C0 E9 C3 00 00 00 83 7D F8 00 7E 35 33 C0 75 31 B8 E0 FF FF FF 33 D2 F7 75 F8 83 F8 01 72 22 68 DD DD 00 00 8B 4D F8 83 C1 08 51 E8 ?? ?? ?? ?? 83 C4 04 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 F0 EB 07 C7 45 F0 00 00 00 00 8B 55 F0 89 55 F4 83 7D F4 00 75 04 33 C0 EB 71 8B 45 F8 50 8B 4D F4 51 8B 55 10 52 8B 45 0C 50 FF 15 ?? ?? ?? ?? 85 C0 75 04 EB 40 EB 3E 83 7D 18 00 75 1B 6A 00 6A 00 6A FF 8B 4D F4 51 6A 01 8B 55 1C 52 FF 15 ?? ?? ?? ?? 89 45 FC EB 1D 8B 45 18 50 8B 4D 14 51 6A FF 8B 55 F4 52 6A 01 8B 45 1C 50 FF 15 ?? ?? ?? ?? 89 45 FC 8B 4D F4 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC EB 04 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_187_0_0 {
	meta:
		name = "__VEC_memcpy"
		size = 227
		refs = "004e _fastcopy_I 00b0 __VEC_memcpy"
	strings:
		$1 = { 55 8B EC 83 EC 1C 89 7D F4 89 75 F8 89 5D FC 8B 5D 0C 8B C3 99 8B C8 8B 45 08 33 CA 2B CA 83 E1 0F 33 CA 2B CA 99 8B F8 33 FA 2B FA 83 E7 0F 33 FA 2B FA 8B D1 0B D7 75 4A 8B 75 10 8B CE 83 E1 7F 89 4D E8 3B F1 74 13 2B F1 56 53 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 08 8B 4D E8 85 C9 74 77 8B 5D 10 8B 55 0C 03 D3 2B D1 89 55 EC 03 D8 2B D9 89 5D F0 8B 75 EC 8B 7D F0 8B 4D E8 F3 A4 8B 45 08 EB 53 3B CF 75 35 F7 D9 83 C1 10 89 4D E4 8B 75 0C 8B 7D 08 8B 4D E4 F3 A4 8B 4D 08 03 4D E4 8B 55 0C 03 55 E4 8B 45 10 2B 45 E4 50 52 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 08 EB 1A 8B 75 0C 8B 7D 08 8B 4D 10 8B D1 C1 E9 02 F3 A5 8B CA 83 E1 03 F3 A4 8B 45 08 8B 5D FC 8B 75 F8 8B 7D F4 8B E5 5D C3 }
	condition:
		$1
}

rule file_187_1_0 {
	meta:
		name = "_fastcopy_I"
		size = 135
	strings:
		$1 = { 55 8B EC 83 EC 08 89 7D FC 89 75 F8 8B 75 0C 8B 7D 08 8B 4D 10 C1 E9 07 EB 06 8D 9B 00 00 00 00 66 0F 6F 06 66 0F 6F 4E 10 66 0F 6F 56 20 66 0F 6F 5E 30 66 0F 7F 07 66 0F 7F 4F 10 66 0F 7F 57 20 66 0F 7F 5F 30 66 0F 6F 66 40 66 0F 6F 6E 50 66 0F 6F 76 60 66 0F 6F 7E 70 66 0F 7F 67 40 66 0F 7F 6F 50 66 0F 7F 77 60 66 0F 7F 7F 70 8D B6 80 00 00 00 8D BF 80 00 00 00 49 75 A3 8B 75 F8 8B 7D FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_189_0_0 {
	meta:
		name = "__chdir"
		size = 514
		refs = "000a ___security_cookie 0049 ??_C@_1BO@DPAOGEII@?$AA?$CI?$AAp?$AAa?$AAt?$AAh?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0052 ??_C@_1BA@EAKPMOEL@?$AAc?$AAh?$AAd?$AAi?$AAr?$AA?4?$AAc?$AA?$AA@ 0059 __CrtDbgReportW 0070 ___doserrno 007b __errno 008f ??_C@_1O@HIELJLOL@?$AA_?$AAc?$AAh?$AAd?$AAi?$AAr?$AA?$AA@ 0099 __invalid_parameter 00ae __imp__SetCurrentDirectoryA@4 00c5 __imp__GetCurrentDirectoryA@8 00de ??_C@_07MGJCOGKF@chdir?4c?$AA@ 00f1 __calloc_dbg 0185 __mbctoupper 01ad __imp__SetEnvironmentVariableA@8 01ca __imp__GetLastError@0 01d0 __dosmaperr 01e7 __free_dbg 01fa @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC 24 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 F8 8D 85 F0 FE FF FF 89 45 FC C7 85 E0 FE FF FF 00 00 00 00 C7 85 EC FE FF FF FF FF FF FF 33 C9 83 7D 08 00 0F 95 C1 89 8D DC FE FF FF 83 BD DC FE FF FF 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 31 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD DC FE FF FF 00 75 39 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 31 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 4C 01 00 00 8B 45 08 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 05 01 00 00 8B 4D FC 51 68 05 01 00 00 FF 15 ?? ?? ?? ?? 89 85 E4 FE FF FF 81 BD E4 FE FF FF 04 01 00 00 7E 5F 6A 4B 68 ?? ?? ?? ?? 6A 02 6A 01 8B 95 E4 FE FF FF 83 C2 01 52 E8 ?? ?? ?? ?? 83 C4 14 89 45 FC 83 7D FC 00 75 0C C7 85 E4 FE FF FF 00 00 00 00 EB 0A C7 85 E0 FE FF FF 01 00 00 00 83 BD E4 FE FF FF 00 74 1A 8B 45 FC 50 8B 8D E4 FE FF FF 83 C1 01 51 FF 15 ?? ?? ?? ?? 89 85 E4 FE FF FF 83 BD E4 FE FF FF 00 74 7C 8B 55 FC 0F BE 02 83 F8 5C 74 0B 8B 4D FC 0F BE 11 83 FA 2F 75 1D 8B 45 FC 0F BE 08 8B 55 FC 0F BE 42 01 3B C8 75 0C C7 85 EC FE FF FF 00 00 00 00 EB 49 C6 85 E8 FE FF FF 3D 8B 4D FC 0F B6 11 52 E8 ?? ?? ?? ?? 83 C4 04 88 85 E9 FE FF FF C6 85 EA FE FF FF 3A C6 85 EB FE FF FF 00 8B 45 FC 50 8D 8D E8 FE FF FF 51 FF 15 ?? ?? ?? ?? 85 C0 74 0A C7 85 EC FE FF FF 00 00 00 00 83 BD EC FE FF FF 00 74 0F FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 83 BD E0 FE FF FF 00 74 0E 6A 02 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 08 8B 85 EC FE FF FF 8B 4D F8 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_191_0_0 {
	meta:
		name = "??3@YAXPAX@Z"
		size = 229
		refs = "0006 __sehtable$??3@YAXPAX@Z 000b __except_handler4 001d ___security_cookie 003e __lock 008a ??_C@_1EO@LHDAJOCM@?$AA_?$AAB?$AAL?$AAO?$AAC?$AAK?$AA_?$AAT?$AAY?$AAP?$AAE?$AA_?$AAI?$AAS?$AA_?$AAV?$AAA?$AAL?$AAI?$AAD?$AA?$CI?$AAp?$AAH?$AAe?$AAa?$AAd?$AA?9?$AA?$DO?$AAn?$AAB?$AAl?$AAo@ 0093 ??_C@_1BG@NDCBABF@?$AAd?$AAb?$AAg?$AAd?$AAe?$AAl?$AA?4?$AAc?$AAp?$AAp?$AA?$AA@ 009a __CrtDbgReportW 00b3 __free_dbg 00cb __unlock"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 F4 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 83 7D 08 00 75 05 E9 98 00 00 00 6A 04 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 45 08 83 E8 20 89 45 E4 8B 4D E4 8B 51 14 81 E2 FF FF 00 00 83 FA 04 74 41 8B 45 E4 83 78 14 01 74 38 8B 4D E4 8B 51 14 81 E2 FF FF 00 00 83 FA 02 74 27 8B 45 E4 83 78 14 03 74 1E 68 ?? ?? ?? ?? 6A 00 6A 34 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 8B 55 E4 8B 42 14 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0B 6A 04 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_193_0_0 {
	meta:
		name = "__strerror"
		size = 372
		refs = "000e __getptd_noexit 002e ??_C@_09KILHPNOL@_strerr?4c?$AA@ 003c __calloc_dbg 007d ??_C@_1BE@MCDODKMH@?$AA_?$AAs?$AAt?$AAr?$AAe?$AAr?$AAr?$AA?4?$AAc?$AA?$AA@ 0082 ??_C@_1BE@OOJPNDPE@?$AA_?$AAs?$AAt?$AAr?$AAe?$AAr?$AAr?$AAo?$AAr?$AA?$AA@ 0087 ??_C@_1GO@GJHBPGME@?$AA_?$AAm?$AAb?$AAs?$AAn?$AAb?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AA?5?$AAb?$AAl?$AAd?$AAm?$AAs?$AAg?$AA?0?$AA?5?$AA?$CI?$AA9?$AA4?$AA?$CL?$AA3?$AA8?$AA?$CL?$AA2?$AA?$CJ?$AA?0?$AA?5@ 009e __mbsnbcat_s 00a7 __invoke_watson_if_error 00bd ??_C@_1EG@OCAEMKFG@?$AAs?$AAt?$AAr?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AA?5?$AAb?$AAl?$AAd?$AAm?$AAs?$AAg?$AA?0?$AA?5?$AA?$CI?$AA9?$AA4?$AA?$CL?$AA3?$AA8?$AA?$CL?$AA2?$AA?$CJ?$AA?0?$AA?5?$AA?$CC?$AA?3?$AA?5@ 00c2 ??_C@_02LMMGGCAJ@?3?5?$AA@ 00d0 _strcat_s 00e1 __errno 00e9 __get_sys_err_msg 0102 ??_C@_1JE@FBKBDMHH@?$AAs?$AAt?$AAr?$AAn?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AAb?$AAl?$AAd?$AAm?$AAs?$AAg?$AA?0?$AA?5?$AA?$CI?$AA9?$AA4?$AA?$CL?$AA3?$AA8?$AA?$CL?$AA2?$AA?$CJ?$AA?0?$AA?5?$AAs?$AAy?$AAs@ 010b _strlen 012b _strncat_s 014a ??_C@_1EG@COKGOLO@?$AAs?$AAt?$AAr?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AA?5?$AAb?$AAl?$AAd?$AAm?$AAs?$AAg?$AA?0?$AA?5?$AA?$CI?$AA9?$AA4?$AA?$CL?$AA3?$AA8?$AA?$CL?$AA2?$AA?$CJ?$AA?0?$AA?5?$AA?$CC?$AA?2?$AAn@ 014f ??_C@_01EEMJAFIK@?6?$AA@"
	strings:
		$1 = { 55 8B EC 83 EC 0C C7 45 F4 00 00 00 00 E8 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 75 07 33 C0 E9 4E 01 00 00 8B 45 FC 83 78 24 00 75 2E 6A 4E 68 ?? ?? ?? ?? 6A 02 6A 01 68 86 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 8B 4D FC 89 41 24 8B 55 FC 83 7A 24 00 75 07 33 C0 E9 17 01 00 00 8B 45 FC 8B 48 24 89 4D F8 8B 55 F8 C6 02 00 83 7D 08 00 74 72 8B 45 08 0F BE 08 85 C9 74 68 6A 00 6A 59 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 82 00 00 00 8B 55 08 52 68 86 00 00 00 8B 45 F8 50 E8 ?? ?? ?? ?? 83 C4 10 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 6A 5A 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 86 00 00 00 8B 4D F8 51 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 E8 ?? ?? ?? ?? 8B 10 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 F4 6A 00 6A 63 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 45 F8 50 E8 ?? ?? ?? ?? 83 C4 04 B9 86 00 00 00 2B C8 83 E9 02 51 8B 55 F4 52 68 86 00 00 00 8B 45 F8 50 E8 ?? ?? ?? ?? 83 C4 10 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 6A 66 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 86 00 00 00 8B 4D F8 51 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_193_2_0 {
	meta:
		name = "__get_sys_err_msg"
		size = 55
		refs = "000b ___sys_nerr 0029 ___sys_errlist"
	strings:
		$1 = { 55 8B EC 51 83 7D 08 00 7C 14 E8 ?? ?? ?? ?? 8B 4D 08 3B 08 7D 08 8B 55 08 89 55 FC EB 0A E8 ?? ?? ?? ?? 8B 00 89 45 FC E8 ?? ?? ?? ?? 8B 4D FC 8B 04 88 8B E5 5D C3 }
	condition:
		$1
}

rule file_193_3_0 {
	meta:
		name = "__strerror_s"
		size = 430
		refs = "0020 ??_C@_1BO@PNINNIGK@?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 002c ??_C@_1BE@MCDODKMH@?$AA_?$AAs?$AAt?$AAr?$AAe?$AAr?$AAr?$AA?4?$AAc?$AA?$AA@ 0033 __CrtDbgReportW 0047 __errno 005e ??_C@_1BI@LDPCOGGD@?$AA_?$AAs?$AAt?$AAr?$AAe?$AAr?$AAr?$AAo?$AAr?$AA_?$AAs?$AA?$AA@ 0068 __invalid_parameter 0088 ??_C@_1CC@JNJFIMGE@?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAT?$AAC?$AAh?$AAa?$AAr?$AAs?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 0100 _strlen 0123 ??_C@_1FA@PEGHDKDC@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?0?$AA?5?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAT?$AAC?$AAh?$AAa?$AAr?$AAs?$AA?0?$AA?5?$AAm@ 0134 _strcpy_s 013d __invoke_watson_if_error 0156 ??_C@_1EK@OEBMBFPG@?$AAs?$AAt?$AAr?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?0?$AA?5?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAT?$AAC?$AAh?$AAa?$AAr?$AAs?$AA?0?$AA?5?$AA?$CC@ 015b ??_C@_02LMMGGCAJ@?3?5?$AA@ 0168 _strcat_s 01a3 _strerror_s"
	strings:
		$1 = { 55 8B EC 83 EC 0C C7 45 FC 00 00 00 00 33 C0 83 7D 08 00 0F 95 C0 89 45 F8 83 7D F8 00 75 21 68 ?? ?? ?? ?? 6A 00 68 90 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F8 00 75 33 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 90 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 31 01 00 00 33 D2 3B 55 0C 1B C0 F7 D8 89 45 F4 75 21 68 ?? ?? ?? ?? 6A 00 68 91 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F4 00 75 33 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 91 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 C9 00 00 00 8B 55 08 C6 02 00 83 7D 10 00 0F 84 87 00 00 00 8B 45 10 0F BE 08 85 C9 74 7D 8B 55 10 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 83 E9 07 3B C1 73 67 6A 00 68 98 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 99 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 E8 ?? ?? ?? ?? 8B 08 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 2B C8 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 03 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_194_0_0 {
	meta:
		name = "___ansicp"
		size = 86
		refs = "0007 ___security_cookie 0025 __imp__GetLocaleInfoA@16 003b _atol 004e @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 10 A1 ?? ?? ?? ?? 33 C5 89 45 F8 C6 45 F6 00 6A 06 8D 45 F0 50 68 04 10 00 00 8B 4D 08 51 FF 15 ?? ?? ?? ?? 85 C0 75 09 C7 45 FC FF FF FF FF EB 0F 8D 55 F0 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 8B 45 FC 8B 4D F8 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_194_1_0 {
	meta:
		name = "___convertcp"
		size = 576
		refs = "0007 ___security_cookie 0043 __imp__GetCPInfo@8 0089 _strlen 00b0 __imp__MultiByteToWideChar@24 00e5 _malloc 00ee __MarkAllocaS 0121 _memset 016e __imp__WideCharToMultiByte@32 01b2 ??_C@_0L@KBNGFDKM@convrtcp?4c?$AA@ 01bf __calloc_dbg 01ff __free_dbg 0228 __freea 0238 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 30 A1 ?? ?? ?? ?? 33 C5 89 45 E8 C7 45 F8 00 00 00 00 8B 45 14 8B 08 89 4D FC C7 45 F4 00 00 00 00 8B 55 08 3B 55 0C 0F 84 FD 01 00 00 C7 45 EC 00 00 00 00 8D 45 D4 50 8B 4D 08 51 FF 15 ?? ?? ?? ?? 85 C0 74 25 83 7D D4 01 75 1F 8D 55 D4 52 8B 45 0C 50 FF 15 ?? ?? ?? ?? 85 C0 74 0D 83 7D D4 01 75 07 C7 45 F4 01 00 00 00 83 7D F4 00 74 20 83 7D FC FF 74 08 8B 4D FC 89 4D F0 EB 12 8B 55 10 52 E8 ?? ?? ?? ?? 83 C4 04 83 C0 01 89 45 F0 83 7D F4 00 75 28 6A 00 6A 00 8B 45 FC 50 8B 4D 10 51 6A 01 8B 55 08 52 FF 15 ?? ?? ?? ?? 89 45 F0 83 7D F0 00 75 07 33 C0 E9 6E 01 00 00 33 C0 75 32 83 7D F0 00 7E 2C 81 7D F0 F0 FF FF 7F 77 23 68 DD DD 00 00 8B 4D F0 8D 54 09 08 52 E8 ?? ?? ?? ?? 83 C4 04 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 D0 EB 07 C7 45 D0 00 00 00 00 8B 45 D0 89 45 EC 83 7D EC 00 75 07 33 C0 E9 1E 01 00 00 8B 4D F0 D1 E1 51 6A 00 8B 55 EC 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 F0 50 8B 4D EC 51 8B 55 FC 52 8B 45 10 50 6A 01 8B 4D 08 51 FF 15 ?? ?? ?? ?? 85 C0 0F 84 D1 00 00 00 83 7D 18 00 74 2F 6A 00 6A 00 8B 55 1C 52 8B 45 18 50 8B 4D F0 51 8B 55 EC 52 6A 00 8B 45 0C 50 FF 15 ?? ?? ?? ?? 85 C0 74 06 8B 4D 18 89 4D F8 E9 9C 00 00 00 83 7D F4 00 75 25 6A 00 6A 00 6A 00 6A 00 8B 55 F0 52 8B 45 EC 50 6A 00 8B 4D 0C 51 FF 15 ?? ?? ?? ?? 89 45 F0 83 7D F0 00 74 71 68 97 00 00 00 68 ?? ?? ?? ?? 6A 02 8B 55 F0 52 6A 01 E8 ?? ?? ?? ?? 83 C4 14 89 45 F8 83 7D F8 00 74 4E 6A 00 6A 00 8B 45 F0 50 8B 4D F8 51 8B 55 F0 52 8B 45 EC 50 6A 00 8B 4D 0C 51 FF 15 ?? ?? ?? ?? 89 45 F0 83 7D F0 00 75 17 6A 02 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 08 C7 45 F8 00 00 00 00 EB 0E 83 7D FC FF 74 08 8B 45 14 8B 4D F0 89 08 83 7D EC 00 74 0C 8B 55 EC 52 E8 ?? ?? ?? ?? 83 C4 04 8B 45 F8 8B 4D E8 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_195_0_0 {
	meta:
		name = "__time32"
		size = 72
		refs = "000c __imp__GetSystemTimeAsFileTime@4 002c __aulldiv"
	strings:
		$1 = { 55 8B EC 83 EC 0C 8D 45 F8 50 FF 15 ?? ?? ?? ?? 8B 4D F8 81 E9 00 80 3E D5 8B 55 FC 81 DA DE B1 9D 01 6A 00 68 80 96 98 00 52 51 E8 ?? ?? ?? ?? 89 45 F4 83 7D 08 00 74 08 8B 45 08 8B 4D F4 89 08 8B 45 F4 8B E5 5D C3 }
	condition:
		$1
}

rule file_196_0_0 {
	meta:
		name = "__wchmod"
		size = 227
		refs = "0019 ??_C@_1BO@DPAOGEII@?$AA?$CI?$AAp?$AAa?$AAt?$AAh?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0022 ??_C@_1GA@JIEOMLEE@?$AAf?$AA?3?$AA?2?$AAr?$AAt?$AAm?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2@ 0029 __CrtDbgReportW 003d ___doserrno 0048 __errno 005c ??_C@_1BA@EBKBJALM@?$AA_?$AAw?$AAc?$AAh?$AAm?$AAo?$AAd?$AA?$AA@ 0066 __invalid_parameter 0078 __imp__GetFileAttributesW@4 0087 __imp__GetLastError@0 008d __dosmaperr 00c1 __imp__SetFileAttributesW@8"
	strings:
		$1 = { 55 8B EC 83 EC 08 33 C0 83 7D 08 00 0F 95 C0 89 45 F8 83 7D F8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 2E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F8 00 75 36 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 2E 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 6D 8B 55 08 52 FF 15 ?? ?? ?? ?? 89 45 FC 83 7D FC FF 75 14 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 83 C8 FF EB 46 8B 45 0C 25 80 00 00 00 74 0B 8B 4D FC 83 E1 FE 89 4D FC EB 09 8B 55 FC 83 CA 01 89 55 FC 8B 45 FC 50 8B 4D 08 51 FF 15 ?? ?? ?? ?? 85 C0 75 14 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 83 C8 FF EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_704_0_0 {
	meta:
		name = "__chmod"
		size = 227
		refs = "0019 ??_C@_1BO@DPAOGEII@?$AA?$CI?$AAp?$AAa?$AAt?$AAh?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0022 ??_C@_1BA@GKMMLMDB@?$AAc?$AAh?$AAm?$AAo?$AAd?$AA?4?$AAc?$AA?$AA@ 0029 __CrtDbgReportW 003d ___doserrno 0048 __errno 005c ??_C@_1O@MECPGLJO@?$AA_?$AAc?$AAh?$AAm?$AAo?$AAd?$AA?$AA@ 0066 __invalid_parameter 0078 __imp__GetFileAttributesA@4 0087 __imp__GetLastError@0 008d __dosmaperr 00c1 __imp__SetFileAttributesA@8"
	strings:
		$1 = { 55 8B EC 83 EC 08 33 C0 83 7D 08 00 0F 95 C0 89 45 F8 83 7D F8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 2E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F8 00 75 36 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 2E 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 6D 8B 55 08 52 FF 15 ?? ?? ?? ?? 89 45 FC 83 7D FC FF 75 14 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 83 C8 FF EB 46 8B 45 0C 25 80 00 00 00 74 0B 8B 4D FC 83 E1 FE 89 4D FC EB 09 8B 55 FC 83 CA 01 89 55 FC 8B 45 FC 50 8B 4D 08 51 FF 15 ?? ?? ?? ?? 85 C0 75 14 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 83 C8 FF EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_197_0_0 {
	meta:
		name = "__mbsdec_l"
		size = 366
		refs = "0019 ??_C@_1BO@JIBAMMGI@?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0022 ??_C@_1BC@PCKAAKMD@?$AAm?$AAb?$AAs?$AAd?$AAe?$AAc?$AA?4?$AAc?$AA?$AA@ 0029 __CrtDbgReportW 003d __errno 0051 ??_C@_1BE@KLNCOLCD@?$AA_?$AAm?$AAb?$AAs?$AAd?$AAe?$AAc?$AA_?$AAl?$AA?$AA@ 005b __invalid_parameter 007c ??_C@_1CA@HPEMMJMJ@?$AAc?$AAu?$AAr?$AAr?$AAe?$AAn?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 00e3 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 00eb ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 010b ??1_LocaleUpdate@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 83 EC 24 33 C0 83 7D 08 00 0F 95 C0 89 45 E8 83 7D E8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 34 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E8 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 34 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 01 01 00 00 33 D2 83 7D 0C 00 0F 95 C2 89 55 E4 83 7D E4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 35 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E4 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 35 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 9E 00 00 00 8B 4D 08 3B 4D 0C 72 07 33 C0 E9 8F 00 00 00 8B 55 10 52 8D 4D EC E8 ?? ?? ?? ?? 8D 4D EC E8 ?? ?? ?? ?? 8B 40 04 83 78 08 00 75 1C 8B 4D 0C 83 E9 01 89 4D 0C 8B 55 0C 89 55 E0 8D 4D EC E8 ?? ?? ?? ?? 8B 45 E0 EB 56 8B 45 0C 83 E8 01 89 45 FC 8B 4D FC 83 E9 01 89 4D FC 8B 55 08 3B 55 FC 77 1D 8D 4D EC E8 ?? ?? ?? ?? 8B 40 04 8B 4D FC 0F B6 11 0F B6 44 10 1D 83 E0 04 74 02 EB D2 8B 4D 0C 83 E9 01 8B 55 0C 2B 55 FC 83 E2 01 2B CA 89 4D DC 8D 4D EC E8 ?? ?? ?? ?? 8B 45 DC 8B E5 5D C3 }
	condition:
		$1
}

rule file_198_0_0 {
	meta:
		name = "__strrev"
		size = 53
	strings:
		$1 = { 55 8B EC 57 56 8B 7D 08 8B D7 8B F7 33 C0 83 C9 FF F2 AE 83 F9 FE 74 17 83 EF 02 3B F7 73 10 8A 26 8A 07 88 06 88 27 83 C6 01 83 EF 01 EB EC 8B C2 5E 5F C9 C3 }
	condition:
		$1
}

rule file_200_0_0 {
	meta:
		name = "__wspawnl"
		size = 424
		refs = "0019 ??_C@_1CC@MODLNCFO@?$AAp?$AAa?$AAt?$AAh?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0022 ??_C@_1GC@OFBKOKJH@?$AAf?$AA?3?$AA?2?$AAr?$AAt?$AAm?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2@ 0029 __CrtDbgReportW 003d __errno 0051 ??_C@_1BC@LBNADFPC@?$AA_?$AAw?$AAs?$AAp?$AAa?$AAw?$AAn?$AAl?$AA?$AA@ 005b __invalid_parameter 007c ??_C@_1CM@PKENOFGE@?$AA?$CK?$AAp?$AAa?$AAt?$AAh?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 00e0 ??_C@_1CA@MOAFCHEI@?$AAa?$AAr?$AAg?$AAl?$AAi?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0140 ??_C@_1CK@PKCLGCC@?$AA?$CK?$AAa?$AAr?$AAg?$AAl?$AAi?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 019d __wspawnve"
	strings:
		$1 = { 55 8B EC 83 EC 10 33 C0 83 7D 0C 00 0F 95 C0 89 45 FC 83 7D FC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 37 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D FC 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 37 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 3A 01 00 00 8B 55 0C 0F B7 02 F7 D8 1B C0 F7 D8 89 45 F8 75 1E 68 ?? ?? ?? ?? 6A 00 6A 38 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F8 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 38 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 D7 00 00 00 33 D2 83 7D 10 00 0F 95 C2 89 55 F4 83 7D F4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 39 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F4 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 39 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 76 8B 4D 10 0F B7 11 F7 DA 1B D2 F7 DA 89 55 F0 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3A 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 3A 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 16 6A 00 8D 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_201_0_0 {
	meta:
		name = "__wsetargv"
		size = 276
		refs = "0010 ?_pgmname@?1??_wsetargv@@9@9 0024 __imp__GetModuleFileNameW@12 002e __set_wpgmptr 0037 __wcmdln 0073 _wparse_cmdline 00b0 ??_C@_0DC@ICHPGBKN@f?3?2rtm?2vctools?2crt_bld?2self_x86?2@ 00c3 __malloc_dbg 0101 ___argc 010a ___wargv"
	strings:
		$1 = { 55 8B EC 83 EC 14 C7 45 FC 00 00 00 00 66 C7 05 ?? ?? ?? ?? 00 00 68 04 01 00 00 68 ?? ?? ?? ?? 6A 00 FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 83 3D ?? ?? ?? ?? 00 74 17 A1 ?? ?? ?? ?? 0F B7 08 85 C9 74 0B 8B 15 ?? ?? ?? ?? 89 55 EC EB 07 C7 45 EC ?? ?? ?? ?? 8B 45 EC 89 45 F4 8D 4D F0 51 8D 55 F8 52 6A 00 6A 00 8B 45 F4 50 E8 ?? ?? ?? ?? 83 C4 14 81 7D F8 FF FF FF 3F 73 09 81 7D F0 FF FF FF 7F 72 05 83 C8 FF EB 7F 8B 4D F0 D1 E1 8B 55 F8 8D 04 91 8B 4D F0 D1 E1 3B C1 73 05 83 C8 FF EB 66 68 8C 00 00 00 68 ?? ?? ?? ?? 6A 02 8B 55 F0 D1 E2 8B 45 F8 8D 0C 82 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 FC 83 7D FC 00 75 05 83 C8 FF EB 38 8D 55 F0 52 8D 45 F8 50 8B 4D F8 8B 55 FC 8D 04 8A 50 8B 4D FC 51 8B 55 F4 52 E8 ?? ?? ?? ?? 83 C4 14 8B 45 F8 83 E8 01 A3 ?? ?? ?? ?? 8B 4D FC 89 0D ?? ?? ?? ?? 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_201_2_0 {
	meta:
		name = "_wparse_cmdline"
		size = 698
	strings:
		$1 = { 55 8B EC 83 EC 14 8B 45 18 C7 00 00 00 00 00 8B 4D 14 C7 01 01 00 00 00 8B 55 08 89 55 FC 83 7D 0C 00 74 11 8B 45 0C 8B 4D 10 89 08 8B 55 0C 83 C2 04 89 55 0C C7 45 F8 00 00 00 00 8B 45 FC 0F B7 08 83 F9 22 75 21 33 D2 83 7D F8 00 0F 94 C2 89 55 F8 8B 45 FC 66 8B 08 66 89 4D F0 8B 55 FC 83 C2 02 89 55 FC EB 3B 8B 45 18 8B 08 83 C1 01 8B 55 18 89 0A 83 7D 10 00 74 15 8B 45 10 8B 4D FC 66 8B 11 66 89 10 8B 45 10 83 C0 02 89 45 10 8B 4D FC 66 8B 11 66 89 55 F0 8B 45 FC 83 C0 02 89 45 FC 0F B7 4D F0 85 C9 74 1C 83 7D F8 00 75 8B 0F B7 55 F0 83 FA 20 74 0D 0F B7 45 F0 83 F8 09 0F 85 75 FF FF FF 0F B7 4D F0 85 C9 75 0B 8B 55 FC 83 EA 02 89 55 FC EB 0F 83 7D 10 00 74 09 8B 45 10 66 C7 40 FE 00 00 C7 45 F8 00 00 00 00 8B 4D FC 0F B7 11 85 D2 74 21 8B 45 FC 0F B7 08 83 F9 20 74 0B 8B 55 FC 0F B7 02 83 F8 09 75 0B 8B 4D FC 83 C1 02 89 4D FC EB DF 8B 55 FC 0F B7 02 85 C0 75 05 E9 67 01 00 00 83 7D 0C 00 74 11 8B 4D 0C 8B 55 10 89 11 8B 45 0C 83 C0 04 89 45 0C 8B 4D 14 8B 11 83 C2 01 8B 45 14 89 10 C7 45 F4 01 00 00 00 C7 45 EC 00 00 00 00 8B 4D FC 0F B7 11 83 FA 5C 75 14 8B 45 FC 83 C0 02 89 45 FC 8B 4D EC 83 C1 01 89 4D EC EB E1 8B 55 FC 0F B7 02 83 F8 22 75 48 8B 45 EC 33 D2 B9 02 00 00 00 F7 F1 85 D2 75 30 83 7D F8 00 74 17 8B 55 FC 0F B7 42 02 83 F8 22 75 0B 8B 4D FC 83 C1 02 89 4D FC EB 13 C7 45 F4 00 00 00 00 33 D2 83 7D F8 00 0F 94 C2 89 55 F8 8B 45 EC D1 E8 89 45 EC 8B 4D EC 8B 55 EC 83 EA 01 89 55 EC 85 C9 74 26 83 7D 10 00 74 11 8B 45 10 66 C7 00 5C 00 8B 4D 10 83 C1 02 89 4D 10 8B 55 18 8B 02 83 C0 01 8B 4D 18 89 01 EB CA 8B 55 FC 0F B7 02 85 C0 74 1C 83 7D F8 00 75 18 8B 4D FC 0F B7 11 83 FA 20 74 0B 8B 45 FC 0F B7 08 83 F9 09 75 02 EB 3C 83 7D F4 00 74 28 83 7D 10 00 74 15 8B 55 10 8B 45 FC 66 8B 08 66 89 0A 8B 55 10 83 C2 02 89 55 10 8B 45 18 8B 08 83 C1 01 8B 55 18 89 0A 8B 45 FC 83 C0 02 89 45 FC E9 E6 FE FF FF 83 7D 10 00 74 11 8B 4D 10 66 C7 01 00 00 8B 55 10 83 C2 02 89 55 10 8B 45 18 8B 08 83 C1 01 8B 55 18 89 0A E9 5F FE FF FF 83 7D 0C 00 74 12 8B 45 0C C7 00 00 00 00 00 8B 4D 0C 83 C1 04 89 4D 0C 8B 55 14 8B 02 83 C0 01 8B 4D 14 89 01 8B E5 5D C3 }
	condition:
		$1
}

rule file_202_0_0 {
	meta:
		name = "___loctotime32_t"
		size = 1293
		refs = "0058 ??_C@_1IM@MJJNIFPM@?$AA?$CI?$AA?5?$AA?$CI?$AA?5?$AA?$CI?$AA?5?$AAy?$AAr?$AA?5?$AA?9?$AA?5?$AA1?$AA9?$AA0?$AA0?$AA?5?$AA?$CJ?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA_?$AAB?$AAA?$AAS?$AAE?$AA_?$AAY?$AAE?$AAA?$AAR?$AA?5@ 0061 ??_C@_1BG@JLFHOLGH@?$AAd?$AAt?$AAo?$AAx?$AAt?$AAi?$AAm?$AAe?$AA?4?$AAc?$AA?$AA@ 0068 __CrtDbgReportW 007c __errno 0090 ??_C@_1CA@DCOBNMOJ@?$AA_?$AA_?$AAl?$AAo?$AAc?$AAt?$AAo?$AAt?$AAi?$AAm?$AAe?$AA3?$AA2?$AA_?$AAt?$AA?$AA@ 009a __invalid_parameter 00de ??_C@_1EA@GACPLBON@?$AA?$CI?$AA?5?$AA?$CI?$AA?5?$AAm?$AAo?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA1?$AA?5?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?5?$AAm?$AAo?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AA1?$AA2?$AA?5?$AA?$CJ?$AA?5?$AA?$CJ?$AA?$AA@ 0158 ??_C@_1EA@FOIKONLM@?$AA?$CI?$AA?5?$AA?$CI?$AA?5?$AAh?$AAr?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?5?$AAh?$AAr?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AA2?$AA3?$AA?5?$AA?$CJ?$AA?5?$AA?$CJ?$AA?$AA@ 01d2 ??_C@_1EA@KCLJGOAL@?$AA?$CI?$AA?5?$AA?$CI?$AA?5?$AAm?$AAn?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?5?$AAm?$AAn?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AA5?$AA9?$AA?5?$AA?$CJ?$AA?5?$AA?$CJ?$AA?$AA@ 024c ??_C@_1EA@PBNKINBN@?$AA?$CI?$AA?5?$AA?$CI?$AA?5?$AAs?$AAc?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?5?$AAs?$AAc?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AA5?$AA9?$AA?5?$AA?$CJ?$AA?5?$AA?$CJ?$AA?$AA@ 02ac __days 031c ??_C@_1NE@HCOJPFBB@?$AA?$CI?$AA?5?$AA?$CI?$AA?5?$AAd?$AAy?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA1?$AA?5?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?5?$AA?$CI?$AA?5?$AA?$CI?$AA_?$AAd?$AAa?$AAy?$AAs?$AA?$FL?$AAm?$AAo?$AA?$FN?$AA?5@ 0424 ___tzset 043a ??_C@_1DC@MEHEMOPB@?$AA_?$AAg?$AAe?$AAt?$AA_?$AAd?$AAa?$AAy?$AAl?$AAi?$AAg?$AAh?$AAt?$AA?$CI?$AA?$CG?$AAd?$AAa?$AAy?$AAl?$AAi?$AAg?$AAh?$AAt?$AA?$CJ?$AA?$AA@ 0443 __get_daylight 044c __invoke_watson_if_error 0465 ??_C@_1CO@IMMOMMCB@?$AA_?$AAg?$AAe?$AAt?$AA_?$AAd?$AAs?$AAt?$AAb?$AAi?$AAa?$AAs?$AA?$CI?$AA?$CG?$AAd?$AAs?$AAt?$AAb?$AAi?$AAa?$AAs?$AA?$CJ?$AA?$AA@ 046e __get_dstbias 0490 ??_C@_1DC@CMKCHHFC@?$AA_?$AAg?$AAe?$AAt?$AA_?$AAt?$AAi?$AAm?$AAe?$AAz?$AAo?$AAn?$AAe?$AA?$CI?$AA?$CG?$AAt?$AAi?$AAm?$AAe?$AAz?$AAo?$AAn?$AAe?$AA?$CJ?$AA?$AA@ 0499 __get_timezone 04f0 __isindst"
	strings:
		$1 = { 55 8B EC 83 EC 68 56 57 C7 45 F4 00 00 00 00 C7 45 FC 00 00 00 00 C7 45 F8 00 00 00 00 8B 45 08 2D 6C 07 00 00 83 F8 46 7C 1A 8B 4D 08 81 E9 6C 07 00 00 81 F9 8A 00 00 00 7F 09 C7 45 AC 01 00 00 00 EB 07 C7 45 AC 00 00 00 00 8B 55 AC 89 55 C4 83 7D C4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 41 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D C4 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 41 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 5E 04 00 00 8B 4D 08 81 E9 6C 07 00 00 89 4D 08 83 7D 0C 01 7C 0F 83 7D 0C 0C 7F 09 C7 45 A8 01 00 00 00 EB 07 C7 45 A8 00 00 00 00 8B 55 A8 89 55 C0 83 7D C0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 48 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D C0 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 48 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 D8 03 00 00 83 7D 14 00 7C 0F 83 7D 14 17 7F 09 C7 45 A4 01 00 00 00 EB 07 C7 45 A4 00 00 00 00 8B 4D A4 89 4D BC 83 7D BC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 4D 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D BC 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 4D 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 5E 03 00 00 83 7D 18 00 7C 0F 83 7D 18 3B 7F 09 C7 45 A0 01 00 00 00 EB 07 C7 45 A0 00 00 00 00 8B 45 A0 89 45 B8 83 7D B8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 52 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D B8 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 52 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 E4 02 00 00 83 7D 1C 00 7C 0F 83 7D 1C 3B 7F 09 C7 45 9C 01 00 00 00 EB 07 C7 45 9C 00 00 00 00 8B 55 9C 89 55 B4 83 7D B4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 57 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D B4 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 57 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 6A 02 00 00 83 7D 10 01 7C 65 8B 4D 0C 8B 55 0C 8B 04 8D ?? ?? ?? ?? 2B 04 95 ?? ?? ?? ?? 3B 45 10 7D 43 8B 4D 08 81 E1 03 00 00 80 79 05 49 83 C9 FC 41 85 C9 75 0F 8B 45 08 99 B9 64 00 00 00 F7 F9 85 D2 75 14 8B 45 08 05 6C 07 00 00 99 B9 90 01 00 00 F7 F9 85 D2 75 15 83 7D 0C 02 75 0F 83 7D 10 1D 7F 09 C7 45 98 01 00 00 00 EB 07 C7 45 98 00 00 00 00 8B 55 98 89 55 B0 83 7D B0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 61 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D B0 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 61 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 9A 01 00 00 8B 4D 0C 8B 55 10 03 14 8D ?? ?? ?? ?? 89 55 F0 8B 45 08 25 03 00 00 80 79 05 48 83 C8 FC 40 85 C0 75 0F 8B 45 08 99 B9 64 00 00 00 F7 F9 85 D2 75 14 8B 45 08 05 6C 07 00 00 99 B9 90 01 00 00 F7 F9 85 D2 75 0F 83 7D 0C 02 7E 09 8B 55 F0 83 C2 01 89 55 F0 8B 4D 08 83 E9 46 69 C9 6D 01 00 00 8B 45 08 83 E8 01 99 83 E2 03 03 C2 8B F0 C1 FE 02 8B 45 08 83 E8 01 99 BF 64 00 00 00 F7 FF 2B F0 8B 45 08 05 2B 01 00 00 99 BF 90 01 00 00 F7 FF 03 F0 03 4D F0 8D 54 0E EF 6B D2 18 03 55 14 89 55 C8 8B 45 C8 6B C0 3C 03 45 18 6B C0 3C 03 45 1C 89 45 C8 E8 ?? ?? ?? ?? 6A 00 68 88 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 04 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 89 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 8A 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F8 50 E8 ?? ?? ?? ?? 83 C4 04 50 E8 ?? ?? ?? ?? 83 C4 18 8B 4D C8 03 4D F8 89 4D C8 8B 55 F0 89 55 E8 8B 45 08 89 45 E0 8B 4D 0C 83 E9 01 89 4D DC 8B 55 14 89 55 D4 8B 45 18 89 45 D0 8B 4D 1C 89 4D CC 83 7D 20 01 74 1C 83 7D 20 FF 75 1F 83 7D F4 00 74 19 8D 55 CC 52 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 09 8B 45 C8 03 45 FC 89 45 C8 8B 45 C8 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_203_0_0 {
	meta:
		name = "__lrotr"
		size = 43
		altNames = "__rotr"
	strings:
		$1 = { 55 8B EC 8B 45 0C 83 E0 1F 89 45 0C B9 20 00 00 00 2B 4D 0C 8B 55 08 D3 E2 8B 45 08 8B 4D 0C D3 E8 0B D0 89 55 08 8B 45 08 5D C3 }
	condition:
		$1
}

rule file_205_0_0 {
	meta:
		name = "_qsort"
		size = 1253
		refs = "0041 ??_C@_1DC@HAGCIKOA@?$AAb?$AAa?$AAs?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AAn?$AAu?$AAm?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 004a ??_C@_1BA@GABBAFKB@?$AAq?$AAs?$AAo?$AAr?$AAt?$AA?4?$AAc?$AA?$AA@ 0051 __CrtDbgReportW 0068 __errno 007c ??_C@_1M@INMHODIG@?$AAq?$AAs?$AAo?$AAr?$AAt?$AA?$AA@ 0086 __invalid_parameter 00a4 ??_C@_1BE@NJBEBBME@?$AAw?$AAi?$AAd?$AAt?$AAh?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 010e ??_C@_1BK@HJGMBFLF@?$AAc?$AAo?$AAm?$AAp?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 01c1 _shortsort 01fe _swap"
	strings:
		$1 = { 55 8B EC 81 EC 20 01 00 00 83 7D 08 00 75 12 83 7D 0C 00 74 0C C7 85 E0 FE FF FF 00 00 00 00 EB 0A C7 85 E0 FE FF FF 01 00 00 00 8B 85 E0 FE FF FF 89 85 EC FE FF FF 83 BD EC FE FF FF 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 6E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD EC FE FF FF 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 6E 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 E9 4F 04 00 00 33 D2 3B 55 10 1B C0 F7 D8 89 85 E8 FE FF FF 75 1E 68 ?? ?? ?? ?? 6A 00 6A 6F 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD E8 FE FF FF 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 6F 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 E9 EC 03 00 00 33 D2 83 7D 14 00 0F 95 C2 89 95 E4 FE FF FF 83 BD E4 FE FF FF 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 70 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD E4 FE FF FF 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 70 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 E9 82 03 00 00 83 7D 0C 02 73 05 E9 77 03 00 00 C7 85 78 FF FF FF 00 00 00 00 8B 4D 08 89 4D F8 8B 55 0C 83 EA 01 0F AF 55 10 03 55 08 89 95 F4 FE FF FF 8B 85 F4 FE FF FF 2B 45 F8 33 D2 F7 75 10 83 C0 01 89 85 74 FF FF FF 83 BD 74 FF FF FF 08 77 20 8B 45 14 50 8B 4D 10 51 8B 95 F4 FE FF FF 52 8B 45 F8 50 E8 ?? ?? ?? ?? 83 C4 10 E9 DE 02 00 00 8B 8D 74 FF FF FF D1 E9 0F AF 4D 10 03 4D F8 89 4D FC 8B 55 FC 52 8B 45 F8 50 FF 55 14 83 C4 08 85 C0 7E 14 8B 4D 10 51 8B 55 FC 52 8B 45 F8 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 8D F4 FE FF FF 51 8B 55 F8 52 FF 55 14 83 C4 08 85 C0 7E 17 8B 45 10 50 8B 8D F4 FE FF FF 51 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 85 F4 FE FF FF 50 8B 4D FC 51 FF 55 14 83 C4 08 85 C0 7E 17 8B 55 10 52 8B 85 F4 FE FF FF 50 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 F8 89 95 7C FF FF FF 8B 85 F4 FE FF FF 89 85 F0 FE FF FF 8B 4D FC 3B 8D 7C FF FF FF 76 2F 8B 95 7C FF FF FF 03 55 10 89 95 7C FF FF FF 8B 85 7C FF FF FF 3B 45 FC 73 15 8B 4D FC 51 8B 95 7C FF FF FF 52 FF 55 14 83 C4 08 85 C0 7E D1 8B 45 FC 3B 85 7C FF FF FF 77 32 8B 8D 7C FF FF FF 03 4D 10 89 8D 7C FF FF FF 8B 95 7C FF FF FF 3B 95 F4 FE FF FF 77 15 8B 45 FC 50 8B 8D 7C FF FF FF 51 FF 55 14 83 C4 08 85 C0 7E CE 8B 95 F0 FE FF FF 2B 55 10 89 95 F0 FE FF FF 8B 85 F0 FE FF FF 3B 45 FC 76 15 8B 4D FC 51 8B 95 F0 FE FF FF 52 FF 55 14 83 C4 08 85 C0 7F D1 8B 85 F0 FE FF FF 3B 85 7C FF FF FF 73 02 EB 33 8B 4D 10 51 8B 95 F0 FE FF FF 52 8B 85 7C FF FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D FC 3B 8D F0 FE FF FF 75 09 8B 95 7C FF FF FF 89 55 FC E9 17 FF FF FF 8B 85 F0 FE FF FF 03 45 10 89 85 F0 FE FF FF 8B 4D FC 3B 8D F0 FE FF FF 73 2F 8B 95 F0 FE FF FF 2B 55 10 89 95 F0 FE FF FF 8B 85 F0 FE FF FF 3B 45 FC 76 15 8B 4D FC 51 8B 95 F0 FE FF FF 52 FF 55 14 83 C4 08 85 C0 74 D1 8B 45 FC 3B 85 F0 FE FF FF 72 2F 8B 8D F0 FE FF FF 2B 4D 10 89 8D F0 FE FF FF 8B 95 F0 FE FF FF 3B 55 F8 76 15 8B 45 FC 50 8B 8D F0 FE FF FF 51 FF 55 14 83 C4 08 85 C0 74 D1 8B 95 F0 FE FF FF 2B 55 F8 8B 85 F4 FE FF FF 2B 85 7C FF FF FF 3B D0 7C 58 8B 4D F8 3B 8D F0 FE FF FF 73 2F 8B 95 78 FF FF FF 8B 45 F8 89 84 95 F8 FE FF FF 8B 8D 78 FF FF FF 8B 95 F0 FE FF FF 89 54 8D 80 8B 85 78 FF FF FF 83 C0 01 89 85 78 FF FF FF 8B 8D 7C FF FF FF 3B 8D F4 FE FF FF 73 0E 8B 95 7C FF FF FF 89 55 F8 E9 40 FD FF FF EB 5C 8B 85 7C FF FF FF 3B 85 F4 FE FF FF 73 32 8B 8D 78 FF FF FF 8B 95 7C FF FF FF 89 94 8D F8 FE FF FF 8B 85 78 FF FF FF 8B 8D F4 FE FF FF 89 4C 85 80 8B 95 78 FF FF FF 83 C2 01 89 95 78 FF FF FF 8B 45 F8 3B 85 F0 FE FF FF 73 11 8B 8D F0 FE FF FF 89 8D F4 FE FF FF E9 E2 FC FF FF 8B 95 78 FF FF FF 83 EA 01 89 95 78 FF FF FF 78 25 8B 85 78 FF FF FF 8B 8C 85 F8 FE FF FF 89 4D F8 8B 95 78 FF FF FF 8B 44 95 80 89 85 F4 FE FF FF E9 AC FC FF FF 8B E5 5D C3 }
	condition:
		$1
}

rule file_205_1_0 {
	meta:
		name = "_shortsort"
		size = 109
		refs = "0057 _swap"
	strings:
		$1 = { 55 8B EC 83 EC 08 8B 45 0C 3B 45 08 76 5B 8B 4D 08 89 4D F8 8B 55 08 03 55 10 89 55 FC EB 09 8B 45 FC 03 45 10 89 45 FC 8B 4D FC 3B 4D 0C 77 1A 8B 55 F8 52 8B 45 FC 50 FF 55 14 83 C4 08 85 C0 7E 06 8B 4D FC 89 4D F8 EB D5 8B 55 10 52 8B 45 0C 50 8B 4D F8 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 0C 2B 55 10 89 55 0C EB 9D 8B E5 5D C3 }
	condition:
		$1
}

rule file_205_2_0 {
	meta:
		name = "_swap"
		size = 78
		altNames = "_swap_c"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 3B 45 0C 74 3E 8B 4D 10 8B 55 10 83 EA 01 89 55 10 85 C9 74 2E 8B 45 08 8A 08 88 4D FF 8B 55 08 8B 45 0C 8A 08 88 0A 8B 55 08 83 C2 01 89 55 08 8B 45 0C 8A 4D FF 88 08 8B 55 0C 83 C2 01 89 55 0C EB C2 8B E5 5D C3 }
	condition:
		$1
}

rule file_206_0_0 {
	meta:
		name = "__fileno"
		size = 111
		refs = "0017 ??_C@_1CC@FADMNIL@?$AA?$CI?$AAs?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0020 ??_C@_1BC@FBGAHIFN@?$AAf?$AAi?$AAl?$AAe?$AAn?$AAo?$AA?4?$AAc?$AA?$AA@ 0027 __CrtDbgReportW 003b __errno 004f ??_C@_1BA@JGHIEKKM@?$AA_?$AAf?$AAi?$AAl?$AAe?$AAn?$AAo?$AA?$AA@ 0059 __invalid_parameter"
	strings:
		$1 = { 55 8B EC 51 33 C0 83 7D 08 00 0F 95 C0 89 45 FC 83 7D FC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 29 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D FC 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 29 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 06 8B 55 08 8B 42 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_208_0_0 {
	meta:
		name = "??_U@YAPAXI@Z"
		size = 26
		refs = "0009 ??2@YAPAXI@Z"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_209_0_0 {
	meta:
		name = "__wtol"
		size = 21
		refs = "000c _wcstol"
	strings:
		$1 = { 55 8B EC 6A 0A 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_482_4_0 {
	meta:
		name = "__atoi64"
		size = 21
		refs = "000c __strtoi64"
	strings:
		$1 = { 55 8B EC 6A 0A 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_209_4_0 {
	meta:
		name = "__wtoi64"
		size = 21
		refs = "000c __wcstoi64"
	strings:
		$1 = { 55 8B EC 6A 0A 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_482_0_0 {
	meta:
		name = "_atol"
		size = 21
		refs = "000c _strtol"
	strings:
		$1 = { 55 8B EC 6A 0A 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_209_1_0 {
	meta:
		name = "__wtol_l"
		size = 25
		refs = "0010 __wcstol_l"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 6A 0A 6A 00 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_482_5_0 {
	meta:
		name = "__atoi64_l"
		size = 25
		refs = "0010 __strtoi64_l"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 6A 0A 6A 00 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_482_1_0 {
	meta:
		name = "__atol_l"
		size = 25
		refs = "0010 __strtol_l"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 6A 0A 6A 00 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_209_5_0 {
	meta:
		name = "__wtoi64_l"
		size = 25
		refs = "0010 __wcstoi64_l"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 6A 0A 6A 00 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_210_0_0 {
	meta:
		name = "__wctomb_s_l"
		size = 765
		refs = "004a ??_C@_1CO@HFMIILNF@?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAB?$AAy?$AAt?$AAe?$AAs?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAI?$AAN?$AAT?$AA_?$AAM?$AAA?$AAX?$AA?$AA@ 0053 ??_C@_1BC@KLMMEMGB@?$AAw?$AAc?$AAt?$AAo?$AAm?$AAb?$AA?4?$AAc?$AA?$AA@ 005a __CrtDbgReportW 006e __errno 0082 ??_C@_1BI@IEADNOHF@?$AA_?$AAw?$AAc?$AAt?$AAo?$AAm?$AAb?$AA_?$AAs?$AA_?$AAl?$AA?$AA@ 008c __invalid_parameter 00a5 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 00ad ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 00e0 _memset 0100 ??1_LocaleUpdate@@QAE@XZ 0121 ??_C@_1CA@CBMNPEO@?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAB?$AAy?$AAt?$AAe?$AAs?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 01e1 __imp__WideCharToMultiByte@32 0204 __imp__GetLastError@0 0250 ??_C@_1DA@HPBFKMEB@?$AA?$CI?$AA?$CC?$AAB?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AAt?$AAo?$AAo?$AA?5?$AAs?$AAm?$AAa?$AAl?$AAl?$AA?$CC?$AA?0?$AA?5?$AA0?$AA?$CJ?$AA?$AA@"
	strings:
		$1 = { 55 8B EC 83 EC 40 83 7D 0C 00 75 1C 83 7D 10 00 76 16 83 7D 08 00 74 09 8B 45 08 C7 00 00 00 00 00 33 C0 E9 D1 02 00 00 83 7D 08 00 74 09 8B 4D 08 C7 01 FF FF FF FF BA FF FF FF 7F 3B 55 10 1B C0 83 C0 01 89 45 EC 75 1E 68 ?? ?? ?? ?? 6A 00 6A 4A 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D EC 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 4A 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 5C 02 00 00 8B 55 18 52 8D 4D F0 E8 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? 8B 00 83 78 14 00 0F 85 F7 00 00 00 0F B7 4D 14 81 F9 FF 00 00 00 7E 43 83 7D 0C 00 74 18 83 7D 10 00 76 12 8B 55 10 52 6A 00 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 0C E8 ?? ?? ?? ?? C7 00 2A 00 00 00 E8 ?? ?? ?? ?? 8B 08 89 4D D8 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 D8 E9 ED 01 00 00 83 7D 0C 00 74 77 33 D2 3B 55 10 1B C0 F7 D8 89 45 E8 75 1E 68 ?? ?? ?? ?? 6A 00 6A 5D 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E8 00 75 3D E8 ?? ?? ?? ?? C7 00 22 00 00 00 6A 00 6A 5D 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 D4 22 00 00 00 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 D4 E9 78 01 00 00 8B 55 0C 8A 45 14 88 02 83 7D 08 00 74 09 8B 4D 08 C7 01 01 00 00 00 C7 45 D0 00 00 00 00 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 D0 E9 4A 01 00 00 E9 3D 01 00 00 C7 45 E4 00 00 00 00 8D 55 E4 52 6A 00 8B 45 10 50 8B 4D 0C 51 6A 01 8D 55 14 52 6A 00 8D 4D F0 E8 ?? ?? ?? ?? 8B 00 8B 48 04 51 FF 15 ?? ?? ?? ?? 89 45 E0 83 7D E0 00 74 0A 83 7D E4 00 0F 84 D7 00 00 00 83 7D E0 00 0F 85 AB 00 00 00 FF 15 ?? ?? ?? ?? 83 F8 7A 0F 85 9C 00 00 00 83 7D 0C 00 74 18 83 7D 10 00 76 12 8B 55 10 52 6A 00 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 0C 33 C9 74 09 C7 45 C0 01 00 00 00 EB 07 C7 45 C0 00 00 00 00 8B 55 C0 89 55 DC 83 7D DC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 7B 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D DC 00 75 3A E8 ?? ?? ?? ?? C7 00 22 00 00 00 6A 00 6A 7B 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 CC 22 00 00 00 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 CC EB 4C E8 ?? ?? ?? ?? C7 00 2A 00 00 00 E8 ?? ?? ?? ?? 8B 08 89 4D C8 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 C8 EB 2A 83 7D 08 00 74 08 8B 55 08 8B 45 E0 89 02 C7 45 C4 00 00 00 00 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 C4 EB 08 8D 4D F0 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_210_4_0 {
	meta:
		name = "_wctomb_s"
		size = 32
		refs = "0017 __wctomb_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 66 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_210_5_0 {
	meta:
		name = "__wctomb_l"
		size = 117
		refs = "0015 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 001d ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0041 __wctomb_s_l 006a ??1_LocaleUpdate@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 83 EC 20 C7 45 FC FF FF FF FF 8B 45 10 50 8D 4D EC E8 ?? ?? ?? ?? 8D 4D EC E8 ?? ?? ?? ?? 50 66 8B 4D 0C 51 8D 4D EC E8 ?? ?? ?? ?? 8B 10 8B 82 AC 00 00 00 50 8B 4D 08 51 8D 55 FC 52 E8 ?? ?? ?? ?? 83 C4 14 89 45 E8 83 7D E8 00 75 08 8B 45 FC 89 45 E0 EB 07 C7 45 E0 FF FF FF FF 8B 4D E0 89 4D E4 8D 4D EC E8 ?? ?? ?? ?? 8B 45 E4 8B E5 5D C3 }
	condition:
		$1
}

rule file_210_6_0 {
	meta:
		name = "_wctomb"
		size = 73
		refs = "0015 ____mb_cur_max_func 0023 __wctomb_s_l"
	strings:
		$1 = { 55 8B EC 83 EC 0C C7 45 FC FF FF FF FF 6A 00 66 8B 45 0C 50 E8 ?? ?? ?? ?? 50 8B 4D 08 51 8D 55 FC 52 E8 ?? ?? ?? ?? 83 C4 14 89 45 F8 83 7D F8 00 75 08 8B 45 FC 89 45 F4 EB 07 C7 45 F4 FF FF FF FF 8B 45 F4 8B E5 5D C3 }
	condition:
		$1
}

rule file_211_0_0 {
	meta:
		name = "__mbsinc_l"
		size = 68
		refs = "0016 __ismbblead_l"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 0F B6 08 89 4D FC 8B 55 0C 52 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4D 08 83 C1 01 89 4D 08 85 C0 74 13 8B 55 08 0F B6 02 85 C0 74 09 8B 4D 08 83 C1 01 89 4D 08 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_211_1_0 {
	meta:
		name = "__mbsinc"
		size = 162
		refs = "0019 ??_C@_1CA@HPEMMJMJ@?$AAc?$AAu?$AAr?$AAr?$AAe?$AAn?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0022 ??_C@_1BC@JEOPPANK@?$AAm?$AAb?$AAs?$AAi?$AAn?$AAc?$AA?4?$AAc?$AA?$AA@ 0029 __CrtDbgReportW 003d __errno 0051 ??_C@_1BA@GDAOKFNN@?$AA_?$AAm?$AAb?$AAs?$AAi?$AAn?$AAc?$AA?$AA@ 005b __invalid_parameter 0074 __ismbblead"
	strings:
		$1 = { 55 8B EC 83 EC 08 33 C0 83 7D 08 00 0F 95 C0 89 45 FC 83 7D FC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3F 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D FC 00 75 2A E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 3F 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 38 8B 55 08 0F B6 02 89 45 F8 8B 4D F8 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 08 83 C2 01 89 55 08 85 C0 74 13 8B 45 08 0F B6 08 85 C9 74 09 8B 55 08 83 C2 01 89 55 08 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_212_0_0 {
	meta:
		name = "__cinit"
		size = 155
		refs = "0006 __FPinit 0013 __IsNonwritableInCurrentImage 002c __initp_misc_cfltcvt_tab 0031 ___xi_z 0036 ___xi_a 003b __initterm_e 0051 __RTC_Terminate 0056 _atexit 005e ___xc_z 0063 ___xc_a 0068 __initterm 0071 ___dyn_tls_init_callback"
	strings:
		$1 = { 55 8B EC 51 83 3D ?? ?? ?? ?? 00 74 1E 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 0D 8B 45 08 50 FF 15 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 05 8B 45 FC EB 47 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 08 83 3D ?? ?? ?? ?? 00 74 1D 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 0C 6A 00 6A 02 6A 00 FF 15 ?? ?? ?? ?? 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_212_1_0 {
	meta:
		name = "_exit"
		size = 21
		refs = "000c _doexit"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_212_2_0 {
	meta:
		name = "__exit"
		size = 21
		refs = "000c _doexit"
	strings:
		$1 = { 55 8B EC 6A 00 6A 01 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_212_3_0 {
	meta:
		name = "__cexit"
		size = 19
		refs = "000a _doexit"
	strings:
		$1 = { 55 8B EC 6A 01 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_212_4_0 {
	meta:
		name = "__c_exit"
		size = 19
		refs = "000a _doexit"
	strings:
		$1 = { 55 8B EC 6A 01 6A 01 6A 00 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_212_5_0 {
	meta:
		name = "__amsg_exit"
		size = 54
		refs = "0005 __FF_MSGBANNER 000e __NMSG_WRITE 0017 __aexit_rtn 001d __decode_pointer"
	strings:
		$1 = { 55 8B EC 51 E8 ?? ?? ?? ?? 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 8B 0D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 68 FF 00 00 00 FF 55 FC 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_212_6_0 {
	meta:
		name = "___freeCrtMemory"
		size = 321
		refs = "0005 __wenviron 002e __free_dbg 0053 __environ 00a3 ___wargv 00b4 ___argv 00c5 ___onexitbegin 00cb __decode_pointer 00f0 __encoded_null 00fa ___ptmbcinfo 0101 __imp__InterlockedDecrement@4 010f ___initialmbcinfo 0139 __imp__InterlockedIncrement@4"
	strings:
		$1 = { 55 8B EC 51 A1 ?? ?? ?? ?? 89 45 FC EB 09 8B 4D FC 83 C1 04 89 4D FC 83 7D FC 00 74 1A 8B 55 FC 83 3A 00 74 12 6A 02 8B 45 FC 8B 08 51 E8 ?? ?? ?? ?? 83 C4 08 EB D7 6A 02 8B 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 08 C7 05 ?? ?? ?? ?? 00 00 00 00 A1 ?? ?? ?? ?? 89 45 FC EB 09 8B 4D FC 83 C1 04 89 4D FC 83 7D FC 00 74 1A 8B 55 FC 83 3A 00 74 12 6A 02 8B 45 FC 8B 08 51 E8 ?? ?? ?? ?? 83 C4 08 EB D7 6A 02 8B 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 08 C7 05 ?? ?? ?? ?? 00 00 00 00 6A 02 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 0D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 04 50 E8 ?? ?? ?? ?? 83 C4 08 C7 05 ?? ?? ?? ?? 00 00 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 75 27 81 3D ?? ?? ?? ?? ?? ?? ?? ?? 74 1B 6A 02 8B 0D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 08 C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_212_7_0 {
	meta:
		name = "_doexit"
		size = 332
		refs = "0006 __sehtable$_doexit 000b __except_handler4 001d ___security_cookie 0031 __lockexit 003e __C_Exit_Done 004b __C_Termination_Done 0057 __exitflag 0063 ___onexitbegin 0069 __decode_pointer 0075 ___onexitend 00ae ___xp_z 00b3 ___xp_a 00b8 __initterm 00c0 ___xt_z 00c5 ___xt_a 00d3 ?fExit@?1??doexit@@9@9 00dd __CrtSetDbgFlag 00f4 ___freeCrtMemory 00f9 __CrtDumpMemoryLeaks 0112 __unlockexit 0133 ___crtExitProcess"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 F0 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 83 3D ?? ?? ?? ?? 01 0F 84 B4 00 00 00 C7 05 ?? ?? ?? ?? 01 00 00 00 8A 45 10 A2 ?? ?? ?? ?? 83 7D 0C 00 75 5E 8B 0D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 E4 8B 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 E0 83 7D E4 00 74 22 8B 45 E0 83 E8 04 89 45 E0 8B 4D E0 3B 4D E4 72 11 8B 55 E0 83 3A 00 74 07 8B 45 E0 8B 08 FF D1 EB DE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 08 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 08 83 3D ?? ?? ?? ?? 00 75 23 6A FF E8 ?? ?? ?? ?? 83 C4 04 83 E0 20 74 14 C7 05 ?? ?? ?? ?? 01 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0C 83 7D 10 00 74 05 E8 ?? ?? ?? ?? C3 83 7D 10 00 74 02 EB 1B C7 05 ?? ?? ?? ?? 01 00 00 00 E8 ?? ?? ?? ?? 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_212_8_0 {
	meta:
		name = "___crtCorExitProcess"
		size = 61
		refs = "0007 ??_C@_0M@MBOPBNBK@mscoree?4dll?$AA@ 000d __imp__GetModuleHandleA@4 001b ??_C@_0P@MIGLKIOC@CorExitProcess?$AA@ 0025 __imp__GetProcAddress@8"
	strings:
		$1 = { 55 8B EC 83 EC 08 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 74 1F 68 ?? ?? ?? ?? 8B 45 FC 50 FF 15 ?? ?? ?? ?? 89 45 F8 83 7D F8 00 74 07 8B 4D 08 51 FF 55 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_212_9_0 {
	meta:
		name = "___crtExitProcess"
		size = 27
		refs = "0008 ___crtCorExitProcess 0015 __imp__ExitProcess@4"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 08 51 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_212_12_0 {
	meta:
		name = "__init_pointers"
		size = 130
		refs = "0005 __encoded_null 0011 __initp_heap_handler 001d __initp_misc_initcrit 0029 __initp_misc_invarg 0035 __initp_misc_purevirt 0041 __initp_misc_rand_s 004d __initp_misc_winsig 0059 __initp_misc_winxfltr 0065 __initp_eh_hooks 006d __exit 0072 __encode_pointer 007a __aexit_rtn"
	strings:
		$1 = { 55 8B EC 51 E8 ?? ?? ?? ?? 89 45 FC 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 A3 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_212_13_0 {
	meta:
		name = "__initterm"
		size = 39
	strings:
		$1 = { 55 8B EC 8B 45 08 3B 45 0C 73 1A 8B 4D 08 83 39 00 74 07 8B 55 08 8B 02 FF D0 8B 4D 08 83 C1 04 89 4D 08 EB DE 5D C3 }
	condition:
		$1
}

rule file_212_14_0 {
	meta:
		name = "__initterm_e"
		size = 61
	strings:
		$1 = { 55 8B EC 51 C7 45 FC 00 00 00 00 8B 45 08 3B 45 0C 73 23 83 7D FC 00 75 1D 8B 4D 08 83 39 00 74 0A 8B 55 08 8B 02 FF D0 89 45 FC 8B 4D 08 83 C1 04 89 4D 08 EB D5 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_212_15_0 {
	meta:
		name = "__get_osplatform"
		size = 236
		refs = "0019 ??_C@_1BO@LKEBEKJP@?$AAp?$AAV?$AAa?$AAl?$AAu?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0025 ??_C@_1BE@DFOEAGLM@?$AAc?$AAr?$AAt?$AA0?$AAd?$AAa?$AAt?$AA?4?$AAc?$AA?$AA@ 002c __CrtDbgReportW 0040 __errno 0057 ??_C@_1CA@HBJLODAG@?$AA_?$AAg?$AAe?$AAt?$AA_?$AAo?$AAs?$AAp?$AAl?$AAa?$AAt?$AAf?$AAo?$AAr?$AAm?$AA?$AA@ 0061 __invalid_parameter 0073 __osplatform 0085 ??_C@_1BO@PCPNBEJP@?$AA_?$AAo?$AAs?$AAp?$AAl?$AAa?$AAt?$AAf?$AAo?$AAr?$AAm?$AA?$CB?$AA?$DN?$AA0?$AA?$AA@"
	strings:
		$1 = { 55 8B EC 83 EC 08 33 C0 83 7D 08 00 0F 95 C0 89 45 FC 83 7D FC 00 75 21 68 ?? ?? ?? ?? 6A 00 68 A3 03 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D FC 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 A3 03 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 EB 79 33 D2 83 3D ?? ?? ?? ?? 00 0F 95 C2 89 55 F8 83 7D F8 00 75 21 68 ?? ?? ?? ?? 6A 00 68 A6 03 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F8 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 A6 03 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 EB 0D 8B 4D 08 8B 15 ?? ?? ?? ?? 89 11 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_212_16_0 {
	meta:
		name = "__get_osver"
		size = 236
		refs = "0019 ??_C@_1BO@LKEBEKJP@?$AAp?$AAV?$AAa?$AAl?$AAu?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0025 ??_C@_1BE@DFOEAGLM@?$AAc?$AAr?$AAt?$AA0?$AAd?$AAa?$AAt?$AA?4?$AAc?$AA?$AA@ 002c __CrtDbgReportW 0040 __errno 0057 ??_C@_1BG@OLMEODBO@?$AA_?$AAg?$AAe?$AAt?$AA_?$AAo?$AAs?$AAv?$AAe?$AAr?$AA?$AA@ 0061 __invalid_parameter 0073 __osplatform 0085 ??_C@_1BO@PCPNBEJP@?$AA_?$AAo?$AAs?$AAp?$AAl?$AAa?$AAt?$AAf?$AAo?$AAr?$AAm?$AA?$CB?$AA?$DN?$AA0?$AA?$AA@ 00e0 __osver"
	strings:
		$1 = { 55 8B EC 83 EC 08 33 C0 83 7D 08 00 0F 95 C0 89 45 FC 83 7D FC 00 75 21 68 ?? ?? ?? ?? 6A 00 68 C0 03 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D FC 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 C0 03 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 EB 79 33 D2 83 3D ?? ?? ?? ?? 00 0F 95 C2 89 55 F8 83 7D F8 00 75 21 68 ?? ?? ?? ?? 6A 00 68 C3 03 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F8 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 C3 03 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 EB 0D 8B 4D 08 8B 15 ?? ?? ?? ?? 89 11 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_212_17_0 {
	meta:
		name = "__get_winver"
		size = 236
		refs = "0019 ??_C@_1BO@LKEBEKJP@?$AAp?$AAV?$AAa?$AAl?$AAu?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0025 ??_C@_1BE@DFOEAGLM@?$AAc?$AAr?$AAt?$AA0?$AAd?$AAa?$AAt?$AA?4?$AAc?$AA?$AA@ 002c __CrtDbgReportW 0040 __errno 0057 ??_C@_1BI@EHCOONPO@?$AA_?$AAg?$AAe?$AAt?$AA_?$AAw?$AAi?$AAn?$AAv?$AAe?$AAr?$AA?$AA@ 0061 __invalid_parameter 0073 __osplatform 0085 ??_C@_1BO@PCPNBEJP@?$AA_?$AAo?$AAs?$AAp?$AAl?$AAa?$AAt?$AAf?$AAo?$AAr?$AAm?$AA?$CB?$AA?$DN?$AA0?$AA?$AA@ 00e0 __winver"
	strings:
		$1 = { 55 8B EC 83 EC 08 33 C0 83 7D 08 00 0F 95 C0 89 45 FC 83 7D FC 00 75 21 68 ?? ?? ?? ?? 6A 00 68 DD 03 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D FC 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 DD 03 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 EB 79 33 D2 83 3D ?? ?? ?? ?? 00 0F 95 C2 89 55 F8 83 7D F8 00 75 21 68 ?? ?? ?? ?? 6A 00 68 E0 03 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F8 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 E0 03 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 EB 0D 8B 4D 08 8B 15 ?? ?? ?? ?? 89 11 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_212_18_0 {
	meta:
		name = "__get_winmajor"
		size = 236
		refs = "0019 ??_C@_1BO@LKEBEKJP@?$AAp?$AAV?$AAa?$AAl?$AAu?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0025 ??_C@_1BE@DFOEAGLM@?$AAc?$AAr?$AAt?$AA0?$AAd?$AAa?$AAt?$AA?4?$AAc?$AA?$AA@ 002c __CrtDbgReportW 0040 __errno 0057 ??_C@_1BM@MHJHOJPG@?$AA_?$AAg?$AAe?$AAt?$AA_?$AAw?$AAi?$AAn?$AAm?$AAa?$AAj?$AAo?$AAr?$AA?$AA@ 0061 __invalid_parameter 0073 __osplatform 0085 ??_C@_1BO@PCPNBEJP@?$AA_?$AAo?$AAs?$AAp?$AAl?$AAa?$AAt?$AAf?$AAo?$AAr?$AAm?$AA?$CB?$AA?$DN?$AA0?$AA?$AA@ 00e0 __winmajor"
	strings:
		$1 = { 55 8B EC 83 EC 08 33 C0 83 7D 08 00 0F 95 C0 89 45 FC 83 7D FC 00 75 21 68 ?? ?? ?? ?? 6A 00 68 FA 03 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D FC 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 FA 03 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 EB 79 33 D2 83 3D ?? ?? ?? ?? 00 0F 95 C2 89 55 F8 83 7D F8 00 75 21 68 ?? ?? ?? ?? 6A 00 68 FD 03 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F8 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 FD 03 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 EB 0D 8B 4D 08 8B 15 ?? ?? ?? ?? 89 11 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_212_19_0 {
	meta:
		name = "__get_winminor"
		size = 236
		refs = "0019 ??_C@_1BO@LKEBEKJP@?$AAp?$AAV?$AAa?$AAl?$AAu?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0025 ??_C@_1BE@DFOEAGLM@?$AAc?$AAr?$AAt?$AA0?$AAd?$AAa?$AAt?$AA?4?$AAc?$AA?$AA@ 002c __CrtDbgReportW 0040 __errno 0057 ??_C@_1BM@FAAKKHPI@?$AA_?$AAg?$AAe?$AAt?$AA_?$AAw?$AAi?$AAn?$AAm?$AAi?$AAn?$AAo?$AAr?$AA?$AA@ 0061 __invalid_parameter 0073 __osplatform 0085 ??_C@_1BO@PCPNBEJP@?$AA_?$AAo?$AAs?$AAp?$AAl?$AAa?$AAt?$AAf?$AAo?$AAr?$AAm?$AA?$CB?$AA?$DN?$AA0?$AA?$AA@ 00e0 __winminor"
	strings:
		$1 = { 55 8B EC 83 EC 08 33 C0 83 7D 08 00 0F 95 C0 89 45 FC 83 7D FC 00 75 21 68 ?? ?? ?? ?? 6A 00 68 17 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D FC 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 17 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 EB 79 33 D2 83 3D ?? ?? ?? ?? 00 0F 95 C2 89 55 F8 83 7D F8 00 75 21 68 ?? ?? ?? ?? 6A 00 68 1A 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F8 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 1A 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 EB 0D 8B 4D 08 8B 15 ?? ?? ?? ?? 89 11 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_212_20_0 {
	meta:
		name = "__get_wpgmptr"
		size = 236
		refs = "0019 ??_C@_1BO@LKEBEKJP@?$AAp?$AAV?$AAa?$AAl?$AAu?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0025 ??_C@_1BE@DFOEAGLM@?$AAc?$AAr?$AAt?$AA0?$AAd?$AAa?$AAt?$AA?4?$AAc?$AA?$AA@ 002c __CrtDbgReportW 0040 __errno 0057 ??_C@_1BK@PNLDCCDP@?$AA_?$AAg?$AAe?$AAt?$AA_?$AAw?$AAp?$AAg?$AAm?$AAp?$AAt?$AAr?$AA?$AA@ 0061 __invalid_parameter 0073 __wpgmptr 0085 ??_C@_1CC@CDIPMFPD@?$AA_?$AAw?$AAp?$AAg?$AAm?$AAp?$AAt?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@"
	strings:
		$1 = { 55 8B EC 83 EC 08 33 C0 83 7D 08 00 0F 95 C0 89 45 FC 83 7D FC 00 75 21 68 ?? ?? ?? ?? 6A 00 68 34 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D FC 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 34 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 EB 79 33 D2 83 3D ?? ?? ?? ?? 00 0F 95 C2 89 55 F8 83 7D F8 00 75 21 68 ?? ?? ?? ?? 6A 00 68 38 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F8 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 38 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 EB 0D 8B 4D 08 8B 15 ?? ?? ?? ?? 89 11 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_212_21_0 {
	meta:
		name = "__get_pgmptr"
		size = 236
		refs = "0019 ??_C@_1BO@LKEBEKJP@?$AAp?$AAV?$AAa?$AAl?$AAu?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0025 ??_C@_1BE@DFOEAGLM@?$AAc?$AAr?$AAt?$AA0?$AAd?$AAa?$AAt?$AA?4?$AAc?$AA?$AA@ 002c __CrtDbgReportW 0040 __errno 0057 ??_C@_1BI@COAAPHJK@?$AA_?$AAg?$AAe?$AAt?$AA_?$AAp?$AAg?$AAm?$AAp?$AAt?$AAr?$AA?$AA@ 0061 __invalid_parameter 0073 __pgmptr 0085 ??_C@_1CA@BBNAFCKO@?$AA_?$AAp?$AAg?$AAm?$AAp?$AAt?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@"
	strings:
		$1 = { 55 8B EC 83 EC 08 33 C0 83 7D 08 00 0F 95 C0 89 45 FC 83 7D FC 00 75 21 68 ?? ?? ?? ?? 6A 00 68 52 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D FC 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 52 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 EB 79 33 D2 83 3D ?? ?? ?? ?? 00 0F 95 C2 89 55 F8 83 7D F8 00 75 21 68 ?? ?? ?? ?? 6A 00 68 56 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F8 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 56 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 EB 0D 8B 4D 08 8B 15 ?? ?? ?? ?? 89 11 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_213_0_0 {
	meta:
		name = "__87except"
		size = 432
		refs = "001d ___security_cookie 0052 $LN19 00af __handle_exc 011f __raise_exc 0132 __ctrlfp 014d __matherr_flag 0159 __matherr 0176 __set_errno_from_matherr 0183 @__security_check_cookie@4 0190 $LN14 0194 $LN11 0198 $LN13 019c $LN12 01a4 $LN8 01a8 $LN9 01ac $LN10"
	strings:
		$1 = { 53 8B DC 83 EC 08 83 E4 F0 83 C4 04 55 8B 6B 04 89 6C 24 04 8B EC 81 EC A0 00 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 43 10 0F B7 08 89 4D F8 8D 55 F8 89 55 F4 8B 43 0C 8B 08 89 4D F0 8B 55 F0 83 EA 01 89 55 F0 83 7D F0 07 77 40 8B 45 F0 FF 24 85 ?? ?? ?? ?? C7 45 EC 08 00 00 00 EB 34 C7 45 EC 11 00 00 00 EB 2B C7 45 EC 12 00 00 00 EB 22 C7 45 EC 04 00 00 00 EB 19 C7 45 EC 10 00 00 00 EB 10 8B 4B 0C C7 01 01 00 00 00 C7 45 EC 00 00 00 00 83 7D EC 00 0F 84 89 00 00 00 8B 55 F4 8B 02 50 8B 4B 0C 83 C1 18 51 8B 55 EC 52 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6C 8B 43 08 89 45 E8 83 7D E8 10 74 0E 83 7D E8 16 74 08 83 7D E8 1D 74 02 EB 20 8B 4D B0 83 C9 01 89 4D B0 8B 55 B0 83 E2 E1 83 CA 02 89 55 B0 8B 43 0C DD 40 10 DD 5D A0 EB 09 8B 4D B0 83 E1 FE 89 4D B0 8B 53 0C 83 C2 18 52 8B 43 0C 83 C0 08 50 8B 4B 08 51 8B 55 EC 52 8B 45 F4 50 8D 8D 70 FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 18 68 FF FF 00 00 8B 55 F4 8B 02 50 E8 ?? ?? ?? ?? 83 C4 08 C7 85 6C FF FF FF 00 00 00 00 8B 4B 0C 83 39 08 74 1B 83 3D ?? ?? ?? ?? 00 75 12 8B 53 0C 52 E8 ?? ?? ?? ?? 83 C4 04 89 85 6C FF FF FF 83 BD 6C FF FF FF 00 75 0E 8B 43 0C 8B 08 51 E8 ?? ?? ?? ?? 83 C4 04 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D 8B E3 5B C3 8B FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_214_0_0 {
	meta:
		name = "__fstat32"
		size = 1552
		refs = "0006 __sehtable$__fstat32 000b __except_handler4 001d ___security_cookie 004a ??_C@_1BM@KFJLMBPG@?$AA?$CI?$AAb?$AAu?$AAf?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0053 ??_C@_1BA@MKNMLAFD@?$AAf?$AAs?$AAt?$AAa?$AAt?$AA?4?$AAc?$AA?$AA@ 005a __CrtDbgReportW 006e ___doserrno 0079 __errno 008d ??_C@_1BC@OPNEMFNJ@?$AA_?$AAf?$AAs?$AAt?$AAa?$AAt?$AA3?$AA2?$AA?$AA@ 0097 __invalid_parameter 00af _memset 00e5 __nhandle 0111 ??_C@_1GO@IHCMJFJC@?$AA?$CI?$AAf?$AAi?$AAl?$AAd?$AAe?$AAs?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AAu?$AAn?$AAs?$AAi?$AAg?$AAn?$AAe?$AAd?$AA?$CJ?$AAf?$AAi?$AAl?$AAd?$AAe?$AAs@ 017f ___pioinfo 0197 ??_C@_1DE@GMHIHBND@?$AA?$CI?$AA_?$AAo?$AAs?$AAf?$AAi?$AAl?$AAe?$AA?$CI?$AAf?$AAi?$AAl?$AAd?$AAe?$AAs?$AA?$CJ?$AA?5?$AA?$CG?$AA?5?$AAF?$AAO?$AAP?$AAE?$AAN?$AA?$CJ?$AA?$AA@ 01f8 ___lock_fhandle 023d ??_C@_1JE@ECKHFIFP@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAf?$AAi?$AAl?$AAe?$AA?5?$AAd?$AAe?$AAs?$AAc?$AAr?$AAi?$AAp?$AAt?$AAo?$AAr?$AA?4?$AA?5?$AAF?$AAi?$AAl?$AAe?$AA?5@ 027b __imp__GetFileType@4 0348 __imp__PeekNamedPipe@24 0392 __imp__GetLastError@0 0398 __dosmaperr 03f8 __imp__GetFileInformationByHandle@8 0463 __imp__FileTimeToLocalFileTime@8 0475 __imp__FileTimeToSystemTime@8 04aa ___loctotime32_t 05f3 __unlock_fhandle"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 8C 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 C7 45 D8 00 00 00 00 33 C0 83 7D 0C 00 0F 95 C0 89 45 90 83 7D 90 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 4E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D 90 00 75 39 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 4E 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 58 05 00 00 6A 24 6A 00 8B 55 0C 52 E8 ?? ?? ?? ?? 83 C4 0C 83 7D 08 FE 75 1E E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 C8 FF E9 24 05 00 00 83 7D 08 00 7C 17 8B 45 08 3B 05 ?? ?? ?? ?? 73 0C C7 85 7C FF FF FF 01 00 00 00 EB 0A C7 85 7C FF FF FF 00 00 00 00 8B 8D 7C FF FF FF 89 4D 8C 83 7D 8C 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 52 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D 8C 00 75 39 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 6A 00 6A 52 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 91 04 00 00 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F 6B C9 28 8B 14 85 ?? ?? ?? ?? 0F BE 44 0A 04 83 E0 01 F7 D8 1B C0 F7 D8 89 45 88 75 1E 68 ?? ?? ?? ?? 6A 00 6A 53 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D 88 00 75 39 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 6A 00 6A 53 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 0B 04 00 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F 6B C9 28 8B 14 85 ?? ?? ?? ?? 0F BE 44 0A 04 83 E0 01 75 39 E8 ?? ?? ?? ?? C7 00 09 00 00 00 C7 45 D8 FF FF FF FF 33 C9 75 1E 68 ?? ?? ?? ?? 6A 00 6A 5B 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC E9 81 03 00 00 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F 6B C9 28 8B 14 85 ?? ?? ?? ?? 8B 04 0A 50 FF 15 ?? ?? ?? ?? 25 FF 7F FF FF 89 45 DC 83 7D DC 01 0F 84 1A 01 00 00 83 7D DC 02 74 0A 83 7D DC 03 0F 85 D0 00 00 00 83 7D DC 02 75 0B 8B 4D 0C 66 C7 41 06 00 20 EB 09 8B 55 0C 66 C7 42 06 00 10 8B 45 0C 8B 4D 08 89 08 8B 55 0C 8B 45 08 89 42 10 8B 4D 0C 66 C7 41 08 01 00 8B 55 0C 66 C7 42 04 00 00 8B 45 0C 66 C7 40 0C 00 00 8B 4D 0C 66 C7 41 0A 00 00 8B 55 0C C7 42 20 00 00 00 00 8B 45 0C C7 40 1C 00 00 00 00 8B 4D 0C C7 41 18 00 00 00 00 83 7D DC 02 75 0C 8B 55 0C C7 42 14 00 00 00 00 EB 4A 6A 00 8D 45 80 50 6A 00 6A 00 6A 00 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F 6B D2 28 8B 04 8D ?? ?? ?? ?? 8B 0C 10 51 FF 15 ?? ?? ?? ?? 89 45 84 83 7D 84 00 74 0B 8B 55 0C 8B 45 80 89 42 14 EB 0A 8B 4D 0C C7 41 14 00 00 00 00 E9 71 02 00 00 EB 3A 83 7D DC 00 75 19 E8 ?? ?? ?? ?? C7 00 09 00 00 00 C7 45 D8 FF FF FF FF E9 52 02 00 00 EB 1B FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 C7 45 D8 FF FF FF FF E9 35 02 00 00 8B 55 0C 66 C7 42 06 00 00 8B 45 0C 66 C7 40 0C 00 00 8B 4D 0C 66 C7 41 0A 00 00 8B 55 0C 66 C7 42 04 00 00 8B 45 0C 66 C7 40 08 01 00 8D 4D A4 51 8B 55 08 C1 FA 05 8B 45 08 83 E0 1F 6B C0 28 8B 0C 95 ?? ?? ?? ?? 8B 14 01 52 FF 15 ?? ?? ?? ?? 85 C0 75 1B FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 C7 45 D8 FF FF FF FF E9 C5 01 00 00 8B 45 A4 83 E0 01 74 16 8B 4D 0C 0F B7 51 06 81 CA 24 01 00 00 8B 45 0C 66 89 50 06 EB 14 8B 4D 0C 0F B7 51 06 81 CA B6 01 00 00 8B 45 0C 66 89 50 06 83 7D B8 00 75 06 83 7D BC 00 74 60 8D 4D E0 51 8D 55 B8 52 FF 15 ?? ?? ?? ?? 85 C0 74 12 8D 45 94 50 8D 4D E0 51 FF 15 ?? ?? ?? ?? 85 C0 75 0C C7 45 D8 FF FF FF FF E9 57 01 00 00 6A FF 0F B7 55 A0 52 0F B7 45 9E 50 0F B7 4D 9C 51 0F B7 55 9A 52 0F B7 45 96 50 0F B7 4D 94 51 E8 ?? ?? ?? ?? 83 C4 1C 8B 55 0C 89 42 1C EB 0A 8B 45 0C C7 40 1C 00 00 00 00 83 7D B0 00 75 06 83 7D B4 00 74 60 8D 4D E0 51 8D 55 B0 52 FF 15 ?? ?? ?? ?? 85 C0 74 12 8D 45 94 50 8D 4D E0 51 FF 15 ?? ?? ?? ?? 85 C0 75 0C C7 45 D8 FF FF FF FF E9 E1 00 00 00 6A FF 0F B7 55 A0 52 0F B7 45 9E 50 0F B7 4D 9C 51 0F B7 55 9A 52 0F B7 45 96 50 0F B7 4D 94 51 E8 ?? ?? ?? ?? 83 C4 1C 8B 55 0C 89 42 18 EB 0C 8B 45 0C 8B 4D 0C 8B 51 1C 89 50 18 83 7D A8 00 75 06 83 7D AC 00 74 5D 8D 45 E0 50 8D 4D A8 51 FF 15 ?? ?? ?? ?? 85 C0 74 12 8D 55 94 52 8D 45 E0 50 FF 15 ?? ?? ?? ?? 85 C0 75 09 C7 45 D8 FF FF FF FF EB 6C 6A FF 0F B7 4D A0 51 0F B7 55 9E 52 0F B7 45 9C 50 0F B7 4D 9A 51 0F B7 55 96 52 0F B7 45 94 50 E8 ?? ?? ?? ?? 83 C4 1C 8B 4D 0C 89 41 20 EB 0C 8B 55 0C 8B 45 0C 8B 48 1C 89 4A 20 8B 55 0C 8B 45 C8 89 42 14 8B 4D 0C 0F B7 51 06 81 CA 00 80 00 00 8B 45 0C 66 89 50 06 8B 4D 0C C7 01 00 00 00 00 8B 55 0C C7 42 10 00 00 00 00 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0D 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 D8 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_215_1_0 {
	meta:
		name = "___CppXcptFilter"
		size = 36
		refs = "0015 __XcptFilter"
	strings:
		$1 = { 55 8B EC 81 7D 08 63 73 6D E0 75 14 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 EB 04 EB 02 33 C0 5D C3 }
	condition:
		$1
}

rule file_215_2_0 {
	meta:
		name = "__XcptFilter"
		size = 467
		refs = "0007 __getptd_noexit 001a __imp__UnhandledExceptionFilter@4 002f _xcptlookup 00af __First_FPE_Indx 00c8 __Num_FPE"
	strings:
		$1 = { 55 8B EC 83 EC 18 E8 ?? ?? ?? ?? 89 45 F8 83 7D F8 00 75 0F 8B 45 0C 50 FF 15 ?? ?? ?? ?? E9 AC 01 00 00 8B 4D F8 8B 51 5C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 75 09 C7 45 EC 00 00 00 00 EB 09 8B 4D FC 8B 51 08 89 55 EC 83 7D EC 00 75 0F 8B 45 0C 50 FF 15 ?? ?? ?? ?? E9 69 01 00 00 83 7D EC 05 75 14 8B 4D FC C7 41 08 00 00 00 00 B8 01 00 00 00 E9 4F 01 00 00 83 7D EC 01 75 08 83 C8 FF E9 41 01 00 00 8B 55 F8 8B 42 60 89 45 F4 8B 4D F8 8B 55 0C 89 51 60 8B 45 FC 83 78 04 08 0F 85 FF 00 00 00 8B 0D ?? ?? ?? ?? 89 4D F0 EB 09 8B 55 F0 83 C2 01 89 55 F0 A1 ?? ?? ?? ?? 03 05 ?? ?? ?? ?? 39 45 F0 7D 16 8B 4D F0 6B C9 0C 8B 55 F8 8B 42 5C C7 44 08 08 00 00 00 00 EB D1 8B 4D F8 8B 51 64 89 55 E8 8B 45 FC 81 38 8E 00 00 C0 75 0F 8B 4D F8 C7 41 64 83 00 00 00 E9 88 00 00 00 8B 55 FC 81 3A 90 00 00 C0 75 0C 8B 45 F8 C7 40 64 81 00 00 00 EB 71 8B 4D FC 81 39 91 00 00 C0 75 0C 8B 55 F8 C7 42 64 84 00 00 00 EB 5A 8B 45 FC 81 38 93 00 00 C0 75 0C 8B 4D F8 C7 41 64 85 00 00 00 EB 43 8B 55 FC 81 3A 8D 00 00 C0 75 0C 8B 45 F8 C7 40 64 82 00 00 00 EB 2C 8B 4D FC 81 39 8F 00 00 C0 75 0C 8B 55 F8 C7 42 64 86 00 00 00 EB 15 8B 45 FC 81 38 92 00 00 C0 75 0A 8B 4D F8 C7 41 64 8A 00 00 00 8B 55 F8 8B 42 64 50 6A 08 FF 55 EC 83 C4 08 8B 4D F8 8B 55 E8 89 51 64 EB 17 8B 45 FC C7 40 08 00 00 00 00 8B 4D FC 8B 51 04 52 FF 55 EC 83 C4 04 8B 45 F8 8B 4D F4 89 48 60 83 C8 FF 8B E5 5D C3 }
	condition:
		$1
}

rule file_215_3_0 {
	meta:
		name = "_xcptlookup"
		size = 86
		refs = "001f __XcptActTabCount"
	strings:
		$1 = { 55 8B EC 51 8B 45 0C 89 45 FC 8B 4D FC 8B 11 3B 55 08 74 1C 8B 45 FC 83 C0 0C 89 45 FC 8B 0D ?? ?? ?? ?? 6B C9 0C 03 4D 0C 39 4D FC 73 02 EB DA 8B 15 ?? ?? ?? ?? 6B D2 0C 03 55 0C 39 55 FC 73 0A 8B 45 FC 8B 08 3B 4D 08 74 04 33 C0 EB 03 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_216_0_0 {
	meta:
		name = "__isleadbyte_l"
		size = 66
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0016 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0037 ??1_LocaleUpdate@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 83 EC 14 8B 45 0C 50 8D 4D F0 E8 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? 8B 08 0F B6 55 08 8B 81 C8 00 00 00 0F B7 0C 50 81 E1 00 80 00 00 89 4D EC 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 EC 8B E5 5D C3 }
	condition:
		$1
}

rule file_216_5_0 {
	meta:
		name = "__iswalpha_l"
		size = 27
		refs = "0012 __iswctype_l"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 68 03 01 00 00 66 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_216_6_0 {
	meta:
		name = "_iswalpha"
		size = 23
		refs = "000e _iswctype"
	strings:
		$1 = { 55 8B EC 68 03 01 00 00 66 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_216_7_0 {
	meta:
		name = "__iswupper_l"
		size = 24
		refs = "000f __iswctype_l"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 6A 01 66 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_216_8_0 {
	meta:
		name = "_iswupper"
		size = 20
		refs = "000b _iswctype"
	strings:
		$1 = { 55 8B EC 6A 01 66 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_216_9_0 {
	meta:
		name = "__iswlower_l"
		size = 24
		refs = "000f __iswctype_l"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 6A 02 66 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_216_10_0 {
	meta:
		name = "_iswlower"
		size = 20
		refs = "000b _iswctype"
	strings:
		$1 = { 55 8B EC 6A 02 66 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_216_11_0 {
	meta:
		name = "__iswdigit_l"
		size = 24
		refs = "000f __iswctype_l"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 6A 04 66 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_216_12_0 {
	meta:
		name = "_iswdigit"
		size = 20
		refs = "000b _iswctype"
	strings:
		$1 = { 55 8B EC 6A 04 66 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_216_13_0 {
	meta:
		name = "__iswxdigit_l"
		size = 27
		refs = "0012 __iswctype_l"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 68 80 00 00 00 66 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_216_14_0 {
	meta:
		name = "_iswxdigit"
		size = 23
		refs = "000e _iswctype"
	strings:
		$1 = { 55 8B EC 68 80 00 00 00 66 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_216_15_0 {
	meta:
		name = "__iswspace_l"
		size = 24
		refs = "000f __iswctype_l"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 6A 08 66 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_216_16_0 {
	meta:
		name = "_iswspace"
		size = 20
		refs = "000b _iswctype"
	strings:
		$1 = { 55 8B EC 6A 08 66 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_216_17_0 {
	meta:
		name = "__iswpunct_l"
		size = 24
		refs = "000f __iswctype_l"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 6A 10 66 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_216_18_0 {
	meta:
		name = "_iswpunct"
		size = 20
		refs = "000b _iswctype"
	strings:
		$1 = { 55 8B EC 6A 10 66 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_216_19_0 {
	meta:
		name = "__iswalnum_l"
		size = 27
		refs = "0012 __iswctype_l"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 68 07 01 00 00 66 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_216_20_0 {
	meta:
		name = "_iswalnum"
		size = 23
		refs = "000e _iswctype"
	strings:
		$1 = { 55 8B EC 68 07 01 00 00 66 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_216_21_0 {
	meta:
		name = "__iswprint_l"
		size = 27
		refs = "0012 __iswctype_l"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 68 57 01 00 00 66 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_216_22_0 {
	meta:
		name = "_iswprint"
		size = 23
		refs = "000e _iswctype"
	strings:
		$1 = { 55 8B EC 68 57 01 00 00 66 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_216_23_0 {
	meta:
		name = "__iswgraph_l"
		size = 27
		refs = "0012 __iswctype_l"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 68 17 01 00 00 66 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_216_24_0 {
	meta:
		name = "_iswgraph"
		size = 23
		refs = "000e _iswctype"
	strings:
		$1 = { 55 8B EC 68 17 01 00 00 66 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_216_25_0 {
	meta:
		name = "__iswcntrl_l"
		size = 24
		refs = "000f __iswctype_l"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 6A 20 66 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_216_26_0 {
	meta:
		name = "_iswcntrl"
		size = 20
		refs = "000b _iswctype"
	strings:
		$1 = { 55 8B EC 6A 20 66 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_216_27_0 {
	meta:
		name = "_iswascii"
		size = 18
	strings:
		$1 = { 55 8B EC 0F B7 45 08 3D 80 00 00 00 1B C0 F7 D8 5D C3 }
	condition:
		$1
}

rule file_216_28_0 {
	meta:
		name = "__iswcsym_l"
		size = 62
		refs = "0013 __iswctype_l"
	strings:
		$1 = { 55 8B EC 51 8B 45 0C 50 68 07 01 00 00 66 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 12 0F B7 55 08 83 FA 5F 74 09 C7 45 FC 00 00 00 00 EB 07 C7 45 FC 01 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_216_29_0 {
	meta:
		name = "___iswcsym"
		size = 58
		refs = "000f _iswctype"
	strings:
		$1 = { 55 8B EC 51 68 07 01 00 00 66 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 12 0F B7 4D 08 83 F9 5F 74 09 C7 45 FC 00 00 00 00 EB 07 C7 45 FC 01 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_216_30_0 {
	meta:
		name = "__iswcsymf_l"
		size = 62
		refs = "0013 __iswctype_l"
	strings:
		$1 = { 55 8B EC 51 8B 45 0C 50 68 03 01 00 00 66 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 12 0F B7 55 08 83 FA 5F 74 09 C7 45 FC 00 00 00 00 EB 07 C7 45 FC 01 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_216_31_0 {
	meta:
		name = "___iswcsymf"
		size = 58
		refs = "000f _iswctype"
	strings:
		$1 = { 55 8B EC 51 68 03 01 00 00 66 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 12 0F B7 4D 08 83 F9 5F 74 09 C7 45 FC 00 00 00 00 EB 07 C7 45 FC 01 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_218_0_0 {
	meta:
		name = "___ascii_memicmp"
		size = 89
	strings:
		$1 = { 55 8B EC 57 56 53 8B 4D 10 0B C9 74 45 8B 75 08 8B 7D 0C B7 41 B3 5A B6 20 8D 49 00 8A 26 83 C6 01 8A 07 83 C7 01 3A E0 74 18 3A E7 72 06 3A E3 77 02 02 E6 3A C7 72 06 3A C3 77 02 02 C6 3A E0 75 07 83 E9 01 75 D5 EB 09 B9 FF FF FF FF 72 02 F7 D9 8B C1 5B 5E 5F C9 C3 }
	condition:
		$1
}

rule file_219_0_0 {
	meta:
		name = "_perror"
		size = 250
		refs = "0006 __sehtable$_perror 000b __except_handler4 001d ___security_cookie 003c ___lock_fhandle 005f _strlen 0070 __write_nolock 007a ??_C@_02LMMGGCAJ@?3?5?$AA@ 008b __errno 0093 __get_sys_err_msg 00bd ??_C@_01EEMJAFIK@?6?$AA@ 00e0 __unlock_fhandle"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 F4 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 C7 45 E4 02 00 00 00 8B 45 E4 50 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 83 7D 08 00 74 3A 8B 4D 08 0F BE 11 85 D2 74 30 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 50 8B 4D 08 51 8B 55 E4 52 E8 ?? ?? ?? ?? 83 C4 0C 6A 02 68 ?? ?? ?? ?? 8B 45 E4 50 E8 ?? ?? ?? ?? 83 C4 0C E8 ?? ?? ?? ?? 8B 08 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 08 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 50 8B 45 08 50 8B 4D E4 51 E8 ?? ?? ?? ?? 83 C4 0C 6A 01 68 ?? ?? ?? ?? 8B 55 E4 52 E8 ?? ?? ?? ?? 83 C4 0C C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0D 8B 45 E4 50 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_222_0_0 {
	meta:
		name = "__flsbuf"
		size = 698
		refs = "000d ??_C@_1BI@MFCLPIBM@?$AAs?$AAt?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0016 ??_C@_1BE@GOOJIKLI@?$AA_?$AAf?$AAl?$AAs?$AAb?$AAu?$AAf?$AA?4?$AAc?$AA?$AA@ 001d __CrtDbgReportW 0035 __fileno 004e __errno 0134 ___iob_func 0152 __isatty 0162 __getbuf 0189 ??_C@_1HO@MLMGPAFH@?$AA?$CI?$AA?$CC?$AAi?$AAn?$AAc?$AAo?$AAn?$AAs?$AAi?$AAs?$AAt?$AAe?$AAn?$AAt?$AA?5?$AAI?$AAO?$AAB?$AA?5?$AAf?$AAi?$AAe?$AAl?$AAd?$AAs?$AA?$CC?$AA?0?$AA?5?$AAs?$AAt?$AAr?$AAe@ 01ea __write 0214 ___pioinfo 0220 ___badioinfo 023b __lseeki64"
	strings:
		$1 = { 55 8B EC 83 EC 1C 83 7D 0C 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 64 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 8B 4D 0C 89 4D F8 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 F0 8B 45 F8 8B 48 0C 81 E1 82 00 00 00 75 24 E8 ?? ?? ?? ?? C7 00 09 00 00 00 8B 55 F8 8B 42 0C 83 C8 20 8B 4D F8 89 41 0C 83 C8 FF E9 47 02 00 00 EB 2D 8B 55 F8 8B 42 0C 83 E0 40 74 22 E8 ?? ?? ?? ?? C7 00 22 00 00 00 8B 4D F8 8B 51 0C 83 CA 20 8B 45 F8 89 50 0C 83 C8 FF E9 18 02 00 00 8B 4D F8 8B 51 0C 83 E2 01 74 48 8B 45 F8 C7 40 04 00 00 00 00 8B 4D F8 8B 51 0C 83 E2 10 74 1C 8B 45 F8 8B 4D F8 8B 51 08 89 10 8B 45 F8 8B 48 0C 83 E1 FE 8B 55 F8 89 4A 0C EB 17 8B 45 F8 8B 48 0C 83 C9 20 8B 55 F8 89 4A 0C 83 C8 FF E9 C5 01 00 00 8B 45 F8 8B 48 0C 83 C9 02 8B 55 F8 89 4A 0C 8B 45 F8 8B 48 0C 83 E1 EF 8B 55 F8 89 4A 0C 8B 45 F8 C7 40 04 00 00 00 00 C7 45 FC 00 00 00 00 8B 4D FC 89 4D F4 8B 55 F8 8B 42 0C 25 0C 01 00 00 75 36 E8 ?? ?? ?? ?? 83 C0 20 39 45 F8 74 0D E8 ?? ?? ?? ?? 83 C0 40 39 45 F8 75 10 8B 4D F0 51 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 0C 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 04 8B 45 F8 8B 48 0C 81 E1 08 01 00 00 0F 84 F9 00 00 00 8B 55 F8 8B 45 F8 8B 0A 2B 48 08 79 21 68 ?? ?? ?? ?? 6A 00 68 A0 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 8B 45 F8 8B 4D F8 8B 10 2B 51 08 89 55 FC 8B 45 F8 8B 48 08 83 C1 01 8B 55 F8 89 0A 8B 45 F8 8B 48 18 83 E9 01 8B 55 F8 89 4A 04 83 7D FC 00 7E 1C 8B 45 FC 50 8B 4D F8 8B 51 08 52 8B 45 F0 50 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F4 EB 71 83 7D F0 FF 74 21 83 7D F0 FE 74 1B 8B 4D F0 C1 F9 05 8B 55 F0 83 E2 1F 6B D2 28 03 14 8D ?? ?? ?? ?? 89 55 EC EB 07 C7 45 EC ?? ?? ?? ?? 8B 45 EC 0F BE 48 04 83 E1 20 74 37 6A 02 6A 00 6A 00 8B 55 F0 52 E8 ?? ?? ?? ?? 83 C4 10 89 45 E4 89 55 E8 8B 45 E4 23 45 E8 83 F8 FF 75 14 8B 4D F8 8B 51 0C 83 CA 20 8B 45 F8 89 50 0C 83 C8 FF EB 4F 8B 4D F8 8B 51 08 8A 45 08 88 02 EB 1E C7 45 FC 01 00 00 00 8B 4D FC 51 8D 55 08 52 8B 45 F0 50 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F4 8B 4D F4 3B 4D FC 74 14 8B 55 F8 8B 42 0C 83 C8 20 8B 4D F8 89 41 0C 83 C8 FF EB 08 8B 45 08 25 FF 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_223_0_0 {
	meta:
		name = "__wsplitpath_s"
		size = 1623
		refs = "0138 _wcsncpy_s 0175 ___crtDebugFillThreshold 01a2 _memset 056d ??_C@_1CI@MLPLHPBP@?$AA?$CI?$AA?$CI?$AA?$CI?$AA_?$AAP?$AAa?$AAt?$AAh?$AA?$CJ?$AA?$CJ?$AA?$CJ?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0579 ??_C@_1HC@CGNIDCEI@?$AAF?$AA?3?$AA?2?$AAR?$AAT?$AAM?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAS?$AAE?$AAL?$AAF?$AA_?$AAX?$AA8?$AA6?$AA?2@ 0580 __CrtDbgReportW 0594 __errno 05ab ??_C@_1BM@OEAFIBCF@?$AA_?$AAw?$AAs?$AAp?$AAl?$AAi?$AAt?$AAp?$AAa?$AAt?$AAh?$AA_?$AAs?$AA?$AA@ 05b5 __invalid_parameter 05ed ??_C@_1DE@MLEJGPLF@?$AA?$CI?$AAL?$AA?$CC?$AAI?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAp?$AAa?$AAr?$AAa?$AAm?$AAe?$AAt?$AAe?$AAr?$AA?$CC?$AA?0?$AA?5?$AA0?$AA?$CJ?$AA?$AA@"
	strings:
		$1 = { 55 8B EC 83 EC 44 C7 45 F4 00 00 00 00 C7 45 F8 00 00 00 00 C7 45 E8 00 00 00 00 83 7D 08 00 75 05 E9 9D 03 00 00 83 7D 0C 00 75 06 83 7D 10 00 75 0C 83 7D 0C 00 74 0B 83 7D 10 00 75 05 E9 80 03 00 00 83 7D 14 00 75 06 83 7D 18 00 75 0C 83 7D 14 00 74 0B 83 7D 18 00 75 05 E9 63 03 00 00 83 7D 1C 00 75 06 83 7D 20 00 75 0C 83 7D 1C 00 74 0B 83 7D 20 00 75 05 E9 46 03 00 00 83 7D 24 00 75 06 83 7D 28 00 75 0C 83 7D 24 00 74 0B 83 7D 28 00 75 05 E9 29 03 00 00 8B 45 08 0F B7 08 83 F9 5C 75 2D 8B 55 08 0F B7 42 02 83 F8 5C 75 21 8B 4D 08 0F B7 51 04 83 FA 3F 75 15 8B 45 08 0F B7 48 06 83 F9 5C 75 09 8B 55 08 83 C2 08 89 55 08 83 7D F4 00 0F 85 CD 00 00 00 C7 45 E4 01 00 00 00 8B 45 08 89 45 EC 83 7D E4 00 76 1E 8B 4D EC 0F B7 11 85 D2 74 14 8B 45 E4 83 E8 01 89 45 E4 8B 4D EC 83 C1 02 89 4D EC EB DC 8B 55 EC 0F B7 02 83 F8 3A 75 32 83 7D 0C 00 74 21 83 7D 10 03 73 05 E9 A1 02 00 00 6A 02 8B 4D 08 51 8B 55 10 52 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 10 8B 4D EC 83 C1 02 89 4D 08 EB 5F 83 7D 0C 00 74 59 8B 55 0C 66 C7 02 00 00 83 7D 10 FF 74 4B 81 7D 10 FF FF FF 7F 74 42 83 7D 10 01 76 3C 8B 45 10 83 E8 01 39 05 ?? ?? ?? ?? 73 0B 8B 0D ?? ?? ?? ?? 89 4D D8 EB 09 8B 55 10 83 EA 01 89 55 D8 8B 45 D8 D1 E0 50 68 FD 00 00 00 8B 4D 0C 83 C1 02 51 E8 ?? ?? ?? ?? 83 C4 0C C7 45 F0 00 00 00 00 C7 45 FC 00 00 00 00 8B 55 08 89 55 EC EB 09 8B 45 EC 83 C0 02 89 45 EC 8B 4D EC 0F B7 11 85 D2 74 34 8B 45 EC 0F B7 08 83 F9 2F 74 0B 8B 55 EC 0F B7 02 83 F8 5C 75 0B 8B 4D EC 83 C1 02 89 4D F0 EB 11 8B 55 EC 0F B7 02 83 F8 2E 75 06 8B 4D EC 89 4D FC EB B9 83 7D F0 00 74 3E 83 7D 14 00 74 30 8B 55 F0 2B 55 08 D1 FA 89 55 F8 8B 45 18 3B 45 F8 77 05 E9 A0 01 00 00 8B 4D F8 51 8B 55 08 52 8B 45 18 50 8B 4D 14 51 E8 ?? ?? ?? ?? 83 C4 10 8B 55 F0 89 55 08 EB 5F 83 7D 14 00 74 59 8B 45 14 66 C7 00 00 00 83 7D 18 FF 74 4B 81 7D 18 FF FF FF 7F 74 42 83 7D 18 01 76 3C 8B 4D 18 83 E9 01 39 0D ?? ?? ?? ?? 73 0B 8B 15 ?? ?? ?? ?? 89 55 D4 EB 09 8B 45 18 83 E8 01 89 45 D4 8B 4D D4 D1 E1 51 68 FD 00 00 00 8B 55 14 83 C2 02 52 E8 ?? ?? ?? ?? 83 C4 0C 83 7D FC 00 74 79 8B 45 FC 3B 45 08 72 71 83 7D 1C 00 74 30 8B 4D FC 2B 4D 08 D1 F9 89 4D F8 8B 55 20 3B 55 F8 77 05 E9 F5 00 00 00 8B 45 F8 50 8B 4D 08 51 8B 55 20 52 8B 45 1C 50 E8 ?? ?? ?? ?? 83 C4 10 83 7D 24 00 74 30 8B 4D EC 2B 4D FC D1 F9 89 4D F8 8B 55 28 3B 55 F8 77 05 E9 BF 00 00 00 8B 45 F8 50 8B 4D FC 51 8B 55 28 52 8B 45 24 50 E8 ?? ?? ?? ?? 83 C4 10 E9 94 00 00 00 83 7D 1C 00 74 30 8B 4D EC 2B 4D 08 D1 F9 89 4D F8 8B 55 20 3B 55 F8 77 05 E9 84 00 00 00 8B 45 F8 50 8B 4D 08 51 8B 55 20 52 8B 45 1C 50 E8 ?? ?? ?? ?? 83 C4 10 83 7D 24 00 74 58 8B 4D 24 66 C7 01 00 00 83 7D 28 FF 74 4A 81 7D 28 FF FF FF 7F 74 41 83 7D 28 01 76 3B 8B 55 28 83 EA 01 39 15 ?? ?? ?? ?? 73 0A A1 ?? ?? ?? ?? 89 45 D0 EB 09 8B 4D 28 83 E9 01 89 4D D0 8B 55 D0 D1 E2 52 68 FD 00 00 00 8B 45 24 83 C0 02 50 E8 ?? ?? ?? ?? 83 C4 0C 33 C0 E9 90 02 00 00 C7 45 E8 01 00 00 00 83 7D 0C 00 74 5E 83 7D 10 00 76 58 8B 4D 0C 66 C7 01 00 00 83 7D 10 FF 74 4A 81 7D 10 FF FF FF 7F 74 41 83 7D 10 01 76 3B 8B 55 10 83 EA 01 39 15 ?? ?? ?? ?? 73 0A A1 ?? ?? ?? ?? 89 45 CC EB 09 8B 4D 10 83 E9 01 89 4D CC 8B 55 CC D1 E2 52 68 FD 00 00 00 8B 45 0C 83 C0 02 50 E8 ?? ?? ?? ?? 83 C4 0C 83 7D 14 00 74 5E 83 7D 18 00 76 58 8B 4D 14 66 C7 01 00 00 83 7D 18 FF 74 4A 81 7D 18 FF FF FF 7F 74 41 83 7D 18 01 76 3B 8B 55 18 83 EA 01 39 15 ?? ?? ?? ?? 73 0A A1 ?? ?? ?? ?? 89 45 C8 EB 09 8B 4D 18 83 E9 01 89 4D C8 8B 55 C8 D1 E2 52 68 FD 00 00 00 8B 45 14 83 C0 02 50 E8 ?? ?? ?? ?? 83 C4 0C 83 7D 1C 00 74 5E 83 7D 20 00 76 58 8B 4D 1C 66 C7 01 00 00 83 7D 20 FF 74 4A 81 7D 20 FF FF FF 7F 74 41 83 7D 20 01 76 3B 8B 55 20 83 EA 01 39 15 ?? ?? ?? ?? 73 0A A1 ?? ?? ?? ?? 89 45 C4 EB 09 8B 4D 20 83 E9 01 89 4D C4 8B 55 C4 D1 E2 52 68 FD 00 00 00 8B 45 1C 83 C0 02 50 E8 ?? ?? ?? ?? 83 C4 0C 83 7D 24 00 74 5E 83 7D 28 00 76 58 8B 4D 24 66 C7 01 00 00 83 7D 28 FF 74 4A 81 7D 28 FF FF FF 7F 74 41 83 7D 28 01 76 3B 8B 55 28 83 EA 01 39 15 ?? ?? ?? ?? 73 0A A1 ?? ?? ?? ?? 89 45 C0 EB 09 8B 4D 28 83 E9 01 89 4D C0 8B 55 C0 D1 E2 52 68 FD 00 00 00 8B 45 24 83 C0 02 50 E8 ?? ?? ?? ?? 83 C4 0C 33 C9 83 7D 08 00 0F 95 C1 89 4D E0 83 7D E0 00 75 21 68 ?? ?? ?? ?? 6A 00 68 DB 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 33 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 DB 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 8D 00 00 00 83 7D E8 00 74 77 33 C0 74 09 C7 45 BC 01 00 00 00 EB 07 C7 45 BC 00 00 00 00 8B 4D BC 89 4D DC 83 7D DC 00 75 21 68 ?? ?? ?? ?? 6A 00 68 DE 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D DC 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 DE 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 EB 10 E8 ?? ?? ?? ?? C7 00 22 00 00 00 B8 22 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_224_1_0 {
	meta:
		name = "_xtow_s@20"
		size = 882
		refs = "0019 ??_C@_1BI@ICGGMGLK@?$AAb?$AAu?$AAf?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0022 ??_C@_1FO@FKHEBPLJ@?$AAf?$AA?3?$AA?2?$AAr?$AAt?$AAm?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2@ 0029 __CrtDbgReportW 003d __errno 0051 ??_C@_1O@NCBFODOE@?$AAx?$AAt?$AAo?$AAw?$AA_?$AAs?$AA?$AA@ 005b __invalid_parameter 007b ??_C@_1CC@JNJFIMGE@?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAT?$AAC?$AAh?$AAa?$AAr?$AAs?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 00f3 ___crtDebugFillThreshold 0120 _memset 0140 ??_C@_1FA@MKGGAGEI@?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAT?$AAC?$AAh?$AAa?$AAr?$AAs?$AA?5?$AA?$DO?$AA?5?$AA?$CI?$AAs?$AAi?$AAz?$AAe?$AA_?$AAt?$AA?$CJ?$AA?$CI?$AAi?$AAs?$AA_?$AAn?$AAe?$AAg?$AA?5?$AA?$DP@ 01bc ??_C@_1DE@PCJGDBBD@?$AA2?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAr?$AAa?$AAd?$AAi?$AAx?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAr?$AAa?$AAd?$AAi?$AAx?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AA3?$AA6?$AA?$AA@ 02c9 ??_C@_1CM@HABGDNLJ@?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA?5?$AA?$DM?$AA?5?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAT?$AAC?$AAh?$AAa?$AAr?$AAs?$AA?$AA@"
	strings:
		$1 = { 55 8B EC 83 EC 30 33 C0 83 7D 0C 00 0F 95 C0 89 45 E8 83 7D E8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 66 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E8 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 66 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 00 03 00 00 33 D2 3B 55 10 1B C0 F7 D8 89 45 E4 75 1E 68 ?? ?? ?? ?? 6A 00 6A 67 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E4 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 67 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 9E 02 00 00 8B 55 0C 66 C7 02 00 00 83 7D 10 FF 74 4B 81 7D 10 FF FF FF 7F 74 42 83 7D 10 01 76 3C 8B 45 10 83 E8 01 39 05 ?? ?? ?? ?? 73 0B 8B 0D ?? ?? ?? ?? 89 4D D4 EB 09 8B 55 10 83 EA 01 89 55 D4 8B 45 D4 D1 E0 50 68 FD 00 00 00 8B 4D 0C 83 C1 02 51 E8 ?? ?? ?? ?? 83 C4 0C 33 D2 83 7D 18 00 0F 95 C2 83 C2 01 3B 55 10 1B C0 F7 D8 89 45 E0 75 1E 68 ?? ?? ?? ?? 6A 00 6A 69 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 30 E8 ?? ?? ?? ?? C7 00 22 00 00 00 6A 00 6A 69 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 22 00 00 00 E9 D9 01 00 00 83 7D 14 02 72 0F 83 7D 14 24 77 09 C7 45 D0 01 00 00 00 EB 07 C7 45 D0 00 00 00 00 8B 55 D0 89 55 DC 83 7D DC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 6A 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D DC 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 6A 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 5D 01 00 00 C7 45 F8 00 00 00 00 8B 4D 0C 89 4D FC 83 7D 18 00 74 22 8B 55 FC 66 C7 02 2D 00 8B 45 FC 83 C0 02 89 45 FC 8B 4D F8 83 C1 01 89 4D F8 8B 55 08 F7 DA 89 55 08 8B 45 FC 89 45 EC 8B 45 08 33 D2 F7 75 14 89 55 F4 8B 45 08 33 D2 F7 75 14 89 45 08 83 7D F4 09 76 17 8B 4D F4 83 C1 57 8B 55 FC 66 89 0A 8B 45 FC 83 C0 02 89 45 FC EB 15 8B 4D F4 83 C1 30 8B 55 FC 66 89 0A 8B 45 FC 83 C0 02 89 45 FC 8B 4D F8 83 C1 01 89 4D F8 83 7D 08 00 76 08 8B 55 F8 3B 55 10 72 A1 8B 45 F8 3B 45 10 72 6E 8B 4D 0C 66 C7 01 00 00 8B 55 F8 3B 55 10 1B C0 F7 D8 89 45 D8 75 21 68 ?? ?? ?? ?? 6A 00 68 8E 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D8 00 75 30 E8 ?? ?? ?? ?? C7 00 22 00 00 00 6A 00 68 8E 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 22 00 00 00 EB 4D 8B 55 FC 66 C7 02 00 00 8B 45 FC 83 E8 02 89 45 FC 8B 4D FC 66 8B 11 66 89 55 F0 8B 45 FC 8B 4D EC 66 8B 11 66 89 10 8B 45 EC 66 8B 4D F0 66 89 08 8B 55 FC 83 EA 02 89 55 FC 8B 45 EC 83 C0 02 89 45 EC 8B 4D EC 3B 4D FC 72 C6 33 C0 8B E5 5D C2 14 00 }
	condition:
		$1
}

rule file_224_5_0 {
	meta:
		name = "@x64tow_s@24"
		size = 956
		refs = "001f ??_C@_1BI@ICGGMGLK@?$AAb?$AAu?$AAf?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 002b ??_C@_1FO@FKHEBPLJ@?$AAf?$AA?3?$AA?2?$AAr?$AAt?$AAm?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2@ 0032 __CrtDbgReportW 0046 __errno 005d ??_C@_1BC@HDEJCFPB@?$AAx?$AA6?$AA4?$AAt?$AAo?$AAw?$AA_?$AAs?$AA?$AA@ 0067 __invalid_parameter 0087 ??_C@_1CC@JNJFIMGE@?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAT?$AAC?$AAh?$AAa?$AAr?$AAs?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 0105 ___crtDebugFillThreshold 0132 _memset 0152 ??_C@_1FA@MKGGAGEI@?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAT?$AAC?$AAh?$AAa?$AAr?$AAs?$AA?5?$AA?$DO?$AA?5?$AA?$CI?$AAs?$AAi?$AAz?$AAe?$AA_?$AAt?$AA?$CJ?$AA?$CI?$AAi?$AAs?$AA_?$AAn?$AAe?$AAg?$AA?5?$AA?$DP@ 01d4 ??_C@_1DE@PCJGDBBD@?$AA2?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAr?$AAa?$AAd?$AAi?$AAx?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAr?$AAa?$AAd?$AAi?$AAx?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AA3?$AA6?$AA?$AA@ 0283 __aullrem 029a __aulldiv 0313 ??_C@_1CM@HABGDNLJ@?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA?5?$AA?$DM?$AA?5?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAT?$AAC?$AAh?$AAa?$AAr?$AAs?$AA?$AA@"
	strings:
		$1 = { 55 8B EC 83 EC 38 89 55 D0 89 4D D4 33 C0 83 7D D4 00 0F 95 C0 89 45 E8 83 7D E8 00 75 21 68 ?? ?? ?? ?? 6A 00 68 3E 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E8 00 75 33 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 3E 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 3E 03 00 00 33 D2 3B 55 D0 1B C0 F7 D8 89 45 E4 75 21 68 ?? ?? ?? ?? 6A 00 68 3F 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E4 00 75 33 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 3F 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 D6 02 00 00 8B 55 D4 66 C7 02 00 00 83 7D D0 FF 74 4B 81 7D D0 FF FF FF 7F 74 42 83 7D D0 01 76 3C 8B 45 D0 83 E8 01 39 05 ?? ?? ?? ?? 73 0B 8B 0D ?? ?? ?? ?? 89 4D CC EB 09 8B 55 D0 83 EA 01 89 55 CC 8B 45 CC D1 E0 50 68 FD 00 00 00 8B 4D D4 83 C1 02 51 E8 ?? ?? ?? ?? 83 C4 0C 33 D2 83 7D 14 00 0F 95 C2 83 C2 01 3B 55 D0 1B C0 F7 D8 89 45 E0 75 21 68 ?? ?? ?? ?? 6A 00 68 41 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 33 E8 ?? ?? ?? ?? C7 00 22 00 00 00 6A 00 68 41 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 22 00 00 00 E9 0B 02 00 00 83 7D 10 02 72 0F 83 7D 10 24 77 09 C7 45 C8 01 00 00 00 EB 07 C7 45 C8 00 00 00 00 8B 55 C8 89 55 DC 83 7D DC 00 75 21 68 ?? ?? ?? ?? 6A 00 68 42 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D DC 00 75 33 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 42 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 89 01 00 00 C7 45 F8 00 00 00 00 8B 4D D4 89 4D FC 83 7D 14 00 74 2D 8B 55 FC 66 C7 02 2D 00 8B 45 FC 83 C0 02 89 45 FC 8B 4D F8 83 C1 01 89 4D F8 8B 55 08 F7 DA 8B 45 0C 83 D0 00 F7 D8 89 55 08 89 45 0C 8B 4D FC 89 4D EC 8B 55 10 33 C0 50 52 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 89 45 F4 8B 45 10 33 C9 51 50 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 89 45 08 89 55 0C 83 7D F4 09 76 17 8B 4D F4 83 C1 57 8B 55 FC 66 89 0A 8B 45 FC 83 C0 02 89 45 FC EB 15 8B 4D F4 83 C1 30 8B 55 FC 66 89 0A 8B 45 FC 83 C0 02 89 45 FC 8B 4D F8 83 C1 01 89 4D F8 83 7D 0C 00 77 06 83 7D 08 00 76 08 8B 55 F8 3B 55 D0 72 80 8B 45 F8 3B 45 D0 72 6E 8B 4D D4 66 C7 01 00 00 8B 55 F8 3B 55 D0 1B C0 F7 D8 89 45 D8 75 21 68 ?? ?? ?? ?? 6A 00 68 66 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D8 00 75 30 E8 ?? ?? ?? ?? C7 00 22 00 00 00 6A 00 68 66 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 22 00 00 00 EB 4D 8B 55 FC 66 C7 02 00 00 8B 45 FC 83 E8 02 89 45 FC 8B 4D FC 66 8B 11 66 89 55 F0 8B 45 FC 8B 4D EC 66 8B 11 66 89 10 8B 45 EC 66 8B 4D F0 66 89 08 8B 55 FC 83 EA 02 89 55 FC 8B 45 EC 83 C0 02 89 45 EC 8B 4D EC 3B 4D FC 72 C6 33 C0 8B E5 5D C2 10 00 }
	condition:
		$1
}

rule file_225_0_0 {
	meta:
		name = "_memcmp"
		size = 440
		refs = "0028 $LN22 0035 _cmpBYTE 0196 _unaligned_memcmp 01a4 $LN1 01a8 $LN2 01ac $LN3 01b0 $LN4 01b4 $LN5"
	strings:
		$1 = { 55 8B EC 83 EC 28 8B 45 0C 89 45 F8 8B 4D 08 89 4D FC 8B 55 10 89 55 F0 83 7D F0 04 0F 87 67 01 00 00 8B 45 F0 FF 24 85 ?? ?? ?? ?? 8B 4D F8 51 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 F4 83 7D F4 00 74 08 8B 45 F4 89 45 EC EB 73 8B 4D F8 83 C1 01 51 8B 55 FC 83 C2 01 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 F4 83 7D F4 00 74 08 8B 45 F4 89 45 E8 EB 46 8B 4D F8 83 C1 02 51 8B 55 FC 83 C2 02 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 F4 83 7D F4 00 74 08 8B 45 F4 89 45 E4 EB 19 8B 4D F8 83 C1 03 51 8B 55 FC 83 C2 03 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 E4 8B 45 E4 89 45 E8 8B 4D E8 89 4D EC 8B 45 EC E9 D5 00 00 00 8B 55 F8 52 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 F4 83 7D F4 00 74 08 8B 4D F4 89 4D E0 EB 46 8B 55 F8 83 C2 01 52 8B 45 FC 83 C0 01 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 F4 83 7D F4 00 74 08 8B 4D F4 89 4D DC EB 19 8B 55 F8 83 C2 02 52 8B 45 FC 83 C0 02 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 DC 8B 4D DC 89 4D E0 8B 45 E0 EB 69 8B 55 F8 52 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 F4 83 7D F4 00 74 08 8B 4D F4 89 4D D8 EB 19 8B 55 F8 83 C2 01 52 8B 45 FC 83 C0 01 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 D8 8B 45 D8 EB 2A 8B 4D F8 51 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 08 EB 18 33 C0 EB 14 8B 45 10 50 8B 4D F8 51 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 8D 49 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_225_1_0 {
	meta:
		name = "_cmpBYTE"
		size = 45
		refs = "0022 _cmpResult"
	strings:
		$1 = { 55 8B EC 83 EC 08 8B 45 0C 89 45 F8 8B 4D 08 89 4D FC 8B 55 FC 0F B6 02 8B 4D F8 0F B6 11 2B C2 50 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_225_2_0 {
	meta:
		name = "_cmpResult"
		size = 30
	strings:
		$1 = { 55 8B EC 83 7D 08 00 74 10 33 C0 83 7D 08 00 0F 9F C0 8D 44 00 FF 89 45 08 8B 45 08 5D C3 }
	condition:
		$1
}

rule file_225_3_0 {
	meta:
		name = "_unaligned_memcmp"
		size = 1796
		refs = "0019 _cmpDWORD 018a $LN79 03c6 _cmpBYTE 04f2 _cmpWORD 0684 $LN46 0688 $LN31 068c $LN16 0690 $LN1 0694 $LN48 0698 $LN33 069c $LN18 06a0 $LN3 06a4 $LN50 06a8 $LN35 06ac $LN20 06b0 $LN5 06b4 $LN52 06b8 $LN37 06bc $LN22 06c0 $LN7 06c4 $LN54 06c8 $LN39 06cc $LN24 06d0 $LN9 06d4 $LN56 06d8 $LN41 06dc $LN26 06e0 $LN11 06e4 $LN58 06e8 $LN43 06ec $LN28 06f0 $LN13 06f4 $LN60 06f8 $LN45 06fc $LN30 0700 $LN15"
	strings:
		$1 = { 55 8B EC 83 EC 10 83 7D 10 20 0F 82 52 01 00 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 4F 06 00 00 8B 55 0C 83 C2 04 52 8B 45 08 83 C0 04 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 28 06 00 00 8B 4D 0C 83 C1 08 51 8B 55 08 83 C2 08 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 01 06 00 00 8B 45 0C 83 C0 0C 50 8B 4D 08 83 C1 0C 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 DA 05 00 00 8B 55 0C 83 C2 10 52 8B 45 08 83 C0 10 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 B3 05 00 00 8B 4D 0C 83 C1 14 51 8B 55 08 83 C2 14 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 8C 05 00 00 8B 45 0C 83 C0 18 50 8B 4D 08 83 C1 18 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 65 05 00 00 8B 55 0C 83 C2 1C 52 8B 45 08 83 C0 1C 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 3E 05 00 00 8B 4D 08 83 C1 20 89 4D 08 8B 55 0C 83 C2 20 89 55 0C 8B 45 10 83 E8 20 89 45 10 E9 A4 FE FF FF 8B 4D 08 03 4D 10 89 4D 08 8B 55 0C 03 55 10 89 55 0C 8B 45 10 89 45 F8 83 7D F8 1F 0F 87 FA 04 00 00 8B 4D F8 FF 24 8D ?? ?? ?? ?? 8B 55 0C 83 EA 1C 52 8B 45 08 83 E8 1C 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 CB 04 00 00 8B 4D 0C 83 E9 18 51 8B 55 08 83 EA 18 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 A4 04 00 00 8B 45 0C 83 E8 14 50 8B 4D 08 83 E9 14 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 7D 04 00 00 8B 55 0C 83 EA 10 52 8B 45 08 83 E8 10 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 56 04 00 00 8B 4D 0C 83 E9 0C 51 8B 55 08 83 EA 0C 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 2F 04 00 00 8B 45 0C 83 E8 08 50 8B 4D 08 83 E9 08 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 08 04 00 00 8B 55 0C 83 EA 04 52 8B 45 08 83 E8 04 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 E1 03 00 00 33 C0 E9 DA 03 00 00 8B 4D 0C 83 E9 1D 51 8B 55 08 83 EA 1D 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 B3 03 00 00 8B 45 0C 83 E8 19 50 8B 4D 08 83 E9 19 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 8C 03 00 00 8B 55 0C 83 EA 15 52 8B 45 08 83 E8 15 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 65 03 00 00 8B 4D 0C 83 E9 11 51 8B 55 08 83 EA 11 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 3E 03 00 00 8B 45 0C 83 E8 0D 50 8B 4D 08 83 E9 0D 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 17 03 00 00 8B 55 0C 83 EA 09 52 8B 45 08 83 E8 09 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 F0 02 00 00 8B 4D 0C 83 E9 05 51 8B 55 08 83 EA 05 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 C9 02 00 00 8B 45 0C 83 E8 01 50 8B 4D 08 83 E9 01 51 E8 ?? ?? ?? ?? 83 C4 08 E9 AE 02 00 00 8B 55 0C 83 EA 1E 52 8B 45 08 83 E8 1E 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 87 02 00 00 8B 4D 0C 83 E9 1A 51 8B 55 08 83 EA 1A 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 60 02 00 00 8B 45 0C 83 E8 16 50 8B 4D 08 83 E9 16 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 39 02 00 00 8B 55 0C 83 EA 12 52 8B 45 08 83 E8 12 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 12 02 00 00 8B 4D 0C 83 E9 0E 51 8B 55 08 83 EA 0E 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 EB 01 00 00 8B 45 0C 83 E8 0A 50 8B 4D 08 83 E9 0A 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 C4 01 00 00 8B 55 0C 83 EA 06 52 8B 45 08 83 E8 06 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 9D 01 00 00 8B 4D 0C 83 E9 02 51 8B 55 08 83 EA 02 52 E8 ?? ?? ?? ?? 83 C4 08 E9 82 01 00 00 8B 45 0C 83 E8 1F 50 8B 4D 08 83 E9 1F 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 5B 01 00 00 8B 55 0C 83 EA 1B 52 8B 45 08 83 E8 1B 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 34 01 00 00 8B 4D 0C 83 E9 17 51 8B 55 08 83 EA 17 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 0D 01 00 00 8B 45 0C 83 E8 13 50 8B 4D 08 83 E9 13 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 E6 00 00 00 8B 55 0C 83 EA 0F 52 8B 45 08 83 E8 0F 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 BF 00 00 00 8B 4D 0C 83 E9 0B 51 8B 55 08 83 EA 0B 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 98 00 00 00 8B 45 0C 83 E8 07 50 8B 4D 08 83 E9 07 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 05 8B 45 FC EB 74 8B 55 0C 83 EA 03 52 8B 45 08 83 E8 03 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 4D FC 89 4D F4 EB 46 8B 55 0C 83 EA 02 52 8B 45 08 83 E8 02 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 4D FC 89 4D F0 EB 19 8B 55 0C 83 EA 01 52 8B 45 08 83 E8 01 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 F0 8B 4D F0 89 4D F4 8B 45 F4 EB 02 33 C0 8B E5 5D C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_225_4_0 {
	meta:
		name = "_cmpWORD"
		size = 115
		refs = "0037 _cmpBYTE"
	strings:
		$1 = { 55 8B EC 83 EC 18 8B 45 0C 89 45 F8 8B 4D 08 89 4D FC 8B 55 FC 0F B7 02 8B 4D F8 0F B7 11 3B C2 74 4B 8B 45 0C 89 45 F0 8B 4D 08 89 4D F4 8B 55 F0 52 8B 45 F4 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 EC 83 7D EC 00 74 08 8B 4D EC 89 4D E8 EB 19 8B 55 F0 83 C2 01 52 8B 45 F4 83 C0 01 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 E8 8B 45 E8 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_225_5_0 {
	meta:
		name = "_cmpDWORD"
		size = 205
		refs = "0037 _cmpBYTE"
	strings:
		$1 = { 55 8B EC 83 EC 20 8B 45 0C 89 45 FC 8B 4D 08 89 4D F8 8B 55 F8 8B 45 FC 8B 0A 3B 08 0F 84 A5 00 00 00 8B 55 0C 89 55 F0 8B 45 08 89 45 F4 8B 4D F0 51 8B 55 F4 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 EC 83 7D EC 00 74 08 8B 45 EC 89 45 E8 EB 73 8B 4D F0 83 C1 01 51 8B 55 F4 83 C2 01 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 EC 83 7D EC 00 74 08 8B 45 EC 89 45 E4 EB 46 8B 4D F0 83 C1 02 51 8B 55 F4 83 C2 02 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 EC 83 7D EC 00 74 08 8B 45 EC 89 45 E0 EB 19 8B 4D F0 83 C1 03 51 8B 55 F4 83 C2 03 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 E0 8B 45 E0 89 45 E4 8B 4D E4 89 4D E8 8B 45 E8 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_226_0_0 {
	meta:
		name = "__validate_param_reuseW"
		size = 615
	strings:
		$1 = { 55 8B EC 83 EC 1C C7 45 FC 00 00 00 00 C7 45 F8 00 00 00 00 8B 45 08 0F B7 48 08 83 F9 70 74 09 0F B7 55 10 83 FA 70 75 17 8B 45 08 0F B7 48 08 0F B7 55 10 33 C0 3B CA 0F 94 C0 E9 23 02 00 00 8B 45 08 0F B7 48 08 83 F9 73 74 15 8B 55 08 0F B7 42 08 83 F8 53 74 09 C7 45 F4 00 00 00 00 EB 07 C7 45 F4 01 00 00 00 8B 4D F4 89 4D FC 0F B7 55 10 83 FA 73 74 12 0F B7 45 10 83 F8 53 74 09 C7 45 F0 00 00 00 00 EB 07 C7 45 F0 01 00 00 00 8B 4D F0 89 4D F8 83 7D FC 00 75 06 83 7D F8 00 74 41 8B 55 FC 3B 55 F8 75 2A 8B 45 08 8B 48 0C 83 E1 20 F7 D9 1B C9 83 C1 01 8B 55 14 83 E2 20 F7 DA 1B D2 83 C2 01 3B CA 75 09 C7 45 EC 01 00 00 00 EB 07 C7 45 EC 00 00 00 00 8B 45 EC E9 80 01 00 00 8B 45 08 0F B7 48 08 83 F9 64 74 76 8B 55 08 0F B7 42 08 83 F8 69 74 6A 8B 4D 08 0F B7 51 08 83 FA 6F 74 5E 8B 45 08 0F B7 48 08 83 F9 75 74 52 8B 55 08 0F B7 42 08 83 F8 78 74 46 8B 4D 08 0F B7 51 08 83 FA 58 74 3A 0F B7 45 10 83 F8 64 74 31 0F B7 4D 10 83 F9 69 74 28 0F B7 55 10 83 FA 6F 74 1F 0F B7 45 10 83 F8 75 74 16 0F B7 4D 10 83 F9 78 74 0D 0F B7 55 10 83 FA 58 0F 85 F1 00 00 00 8B 45 08 0F B7 48 08 83 F9 64 74 45 8B 55 08 0F B7 42 08 83 F8 69 74 39 8B 4D 08 0F B7 51 08 83 FA 6F 74 2D 8B 45 08 0F B7 48 08 83 F9 75 74 21 8B 55 08 0F B7 42 08 83 F8 78 74 15 8B 4D 08 0F B7 51 08 83 FA 58 74 09 C7 45 E8 00 00 00 00 EB 07 C7 45 E8 01 00 00 00 0F B7 45 10 83 F8 64 74 36 0F B7 4D 10 83 F9 69 74 2D 0F B7 55 10 83 FA 6F 74 24 0F B7 45 10 83 F8 75 74 1B 0F B7 4D 10 83 F9 78 74 12 0F B7 55 10 83 FA 58 74 09 C7 45 E4 00 00 00 00 EB 07 C7 45 E4 01 00 00 00 8B 45 E8 3B 45 E4 74 04 33 C0 EB 54 8B 4D 08 8B 51 0C 81 E2 00 00 01 00 F7 DA 1B D2 F7 DA 8B 45 14 25 00 00 01 00 F7 D8 1B C0 F7 D8 3B D0 75 1F 8B 4D 08 8B 51 0C 83 E2 20 F7 DA 1B D2 F7 DA 8B 45 14 83 E0 20 F7 D8 1B C0 F7 D8 3B D0 74 04 33 C0 EB 0D 8B 4D 08 8B 11 33 C0 3B 55 0C 0F 94 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_226_1_0 {
	meta:
		name = "__woutput_p_l"
		size = 13824
		refs = "000a ___security_cookie 0067 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 00e8 ??_C@_1CC@FADMNIL@?$AA?$CI?$AAs?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 00f4 ??_C@_1GC@ELIAPJJM@?$AAf?$AA?3?$AA?2?$AAr?$AAt?$AAm?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2@ 00fb __CrtDbgReportW 0112 __errno 0129 ??_C@_1BK@GDEKGMNC@?$AA_?$AAw?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAp?$AA_?$AAl?$AA?$AA@ 0133 __invalid_parameter 014b ??1_LocaleUpdate@@QAE@XZ 0173 ??_C@_1CC@MGIEJOME@?$AA?$CI?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0302 ___lookuptable_s 037a _wcstol 03ab _memset 0458 ??_C@_1JC@PFJNKEIO@?$AA?$CI?$AA?$CI?$AAt?$AAy?$AAp?$AAe?$AA_?$AAp?$AAo?$AAs?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?$CK?$AAe?$AAn?$AAd?$AA_?$AAp?$AAo?$AAs?$AA?5?$AA?$DN?$AA?$DN@ 051f ??_C@_1CM@IEGCDOKE@?$AA?$CI?$AAs?$AAt?$AAa?$AAt?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAS?$AAT?$AA_?$AAI?$AAN?$AAV?$AAA?$AAL?$AAI?$AAD?$AA?$CJ?$AA?$AA@ 05b3 $LN363 05fe _write_char 0689 $LN359 0690 $LN364 070d _get_int_arg 07a2 ??_C@_1JE@NMBHOLFI@?$AA?$CI?$AA?$CI?$AAw?$AAi?$AAd?$AAt?$AAh?$AA_?$AAp?$AAo?$AAs?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?$CK?$AAe?$AAn?$AAd?$AA_?$AAp?$AAo?$AAs?$AA?5?$AA?$DN@ 08c5 __validate_param_reuseW 08db ??_C@_1II@PIPIMLPF@?$AA_?$AAt?$AAv?$AAa?$AAl?$AAi?$AAd?$AAa?$AAt?$AAe?$AA_?$AAp?$AAa?$AAr?$AAa?$AAm?$AA_?$AAr?$AAe?$AAu?$AAs?$AAe?$AA?$CI?$AA?$CG?$AAp?$AAo?$AAs?$AA_?$AAv?$AAa?$AAl?$AAu@ 0a88 ??_C@_1JG@JBJBOCFB@?$AA?$CI?$AA?$CI?$AAp?$AAr?$AAe?$AAc?$AAi?$AAs?$AA_?$AAp?$AAo?$AAs?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?$CK?$AAe?$AAn?$AAd?$AA_?$AAp?$AAo?$AAs?$AA?5@ 0bc1 ??_C@_1IK@EIEPDKHJ@?$AA_?$AAt?$AAv?$AAa?$AAl?$AAi?$AAd?$AAa?$AAt?$AAe?$AA_?$AAp?$AAa?$AAr?$AAa?$AAm?$AA_?$AAr?$AAe?$AAu?$AAs?$AAe?$AA?$CI?$AA?$CG?$AAp?$AAo?$AAs?$AA_?$AAv?$AAa?$AAl?$AAu@ 0ccb $LN360 0cd2 $LN365 0e3d $LN361 0e44 $LN366 0ecd ??_C@_1EM@BNPHBBIA@?$AA?$CI?$AA?$CI?$AAt?$AAy?$AAp?$AAe?$AA_?$AAp?$AAo?$AAs?$AA?$DO?$AA?$DN?$AA0?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AAt?$AAy?$AAp?$AAe?$AA_?$AAp?$AAo?$AAs?$AA?$DM?$AA_?$AAA?$AAR?$AAG@ 0fdf ??_C@_1IG@FDCPLALG@?$AA_?$AAt?$AAv?$AAa?$AAl?$AAi?$AAd?$AAa?$AAt?$AAe?$AA_?$AAp?$AAa?$AAr?$AAa?$AAm?$AA_?$AAr?$AAe?$AAu?$AAs?$AAe?$AA?$CI?$AA?$CG?$AAp?$AAo?$AAs?$AA_?$AAv?$AAa?$AAl?$AAu@ 10b0 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 10d8 __mbtowc_l 1288 ??_C@_1IG@HJIMKDHC@?$AA_?$AAt?$AAv?$AAa?$AAl?$AAi?$AAd?$AAa?$AAt?$AAe?$AA_?$AAp?$AAa?$AAr?$AAa?$AAm?$AA_?$AAr?$AAe?$AAu?$AAs?$AAe?$AA?$CI?$AA?$CG?$AAp?$AAo?$AAs?$AA_?$AAv?$AAa?$AAl?$AAu@ 1342 ___nullstring 1354 _strlen 16a8 __isleadbyte_l 16df ___wnullstring 1964 __get_printf_count_output 19a0 ??_C@_1EK@PNGFDECN@?$AA?$CI?$AA?$CC?$AA?8?$AAn?$AA?8?$AA?5?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AAs?$AAp?$AAe?$AAc?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?5?$AAd?$AAi?$AAs?$AAa?$AAb?$AAl?$AAe?$AAd?$AA?$CC@ 1bd8 ??_C@_1IM@DNGHAPLB@?$AA_?$AAt?$AAv?$AAa?$AAl?$AAi?$AAd?$AAa?$AAt?$AAe?$AA_?$AAp?$AAa?$AAr?$AAa?$AAm?$AA_?$AAr?$AAe?$AAu?$AAs?$AAe?$AA?$CI?$AA?$CG?$AAp?$AAo?$AAs?$AA_?$AAv?$AAa?$AAl?$AAu@ 1cc3 ??_C@_0DB@FNNAMKJO@f?3?2rtm?2vctools?2crt_bld?2self_x86?2@ 1cd7 __malloc_dbg 1dfd ??_C@_1DG@GOHGNKHE@?$AAp?$AAa?$AAs?$AAs?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAF?$AAO?$AAR?$AAM?$AAA?$AAT?$AA_?$AAO?$AAU?$AAT?$AAP?$AAU?$AAT?$AA_?$AAP?$AAA?$AAS?$AAS?$AA?$AA@ 1e92 __cfltcvt_tab 1e98 __decode_pointer 203e _get_int64_arg 21a6 ??_C@_1IK@NBGDDCBN@?$AA_?$AAt?$AAv?$AAa?$AAl?$AAi?$AAd?$AAa?$AAt?$AAe?$AA_?$AAp?$AAa?$AAr?$AAa?$AAm?$AA_?$AAr?$AAe?$AAu?$AAs?$AAe?$AA?$CI?$AA?$CG?$AAp?$AAo?$AAs?$AA_?$AAv?$AAa?$AAl?$AAu@ 23dc ??_C@_1JC@OACKELNN@?$AA_?$AAt?$AAv?$AAa?$AAl?$AAi?$AAd?$AAa?$AAt?$AAe?$AA_?$AAp?$AAa?$AAr?$AAa?$AAm?$AA_?$AAr?$AAe?$AAu?$AAs?$AAe?$AA?$CI?$AA?$CG?$AAp?$AAo?$AAs?$AA_?$AAv?$AAa?$AAl?$AAu@ 2e9e __aullrem 2ec3 __aulldiv 3045 _write_multi_char 3066 _write_string 31d7 __free_dbg 322b ??_C@_1FK@LNCFKALM@?$AA?$CI?$AA?$CI?$AAs?$AAt?$AAa?$AAt?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAS?$AAT?$AA_?$AAN?$AAO?$AAR?$AAM?$AAA?$AAL?$AA?$CJ?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AA?$CI?$AAs?$AAt?$AAa?$AAt?$AAe?$AA?5@ 331f $LN367 33ef _get_crtdouble_arg 3437 ??_C@_1FK@BCPANIEK@?$AA?$CI?$AA?$CC?$AAM?$AAi?$AAs?$AAs?$AAi?$AAn?$AAg?$AA?5?$AAp?$AAo?$AAs?$AAi?$AAt?$AAi?$AAo?$AAn?$AA?5?$AAi?$AAn?$AA?5?$AAt?$AAh?$AAe?$AA?5?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt@ 34d6 @__security_check_cookie@4 34e0 $LN255 34e4 $LN251 34e8 $LN250 34ec $LN242 34f0 $LN230 34f4 $LN229 34f8 $LN217 34fc $LN201 3500 $LN245 3504 $LN244 3508 $LN246 350c $LN247 3510 $LN243 3514 $LN248 352c $LN211 3530 $LN203 3534 $LN214 3538 $LN202 353c $LN215 3570 $LN136 3574 $LN198 3578 $LN170 357c $LN110 3580 $LN184 3584 $LN135 3588 $LN196 358c $LN115 3590 $LN149 3594 $LN105 3598 $LN111 359c $LN168 35a0 $LN113 35a4 $LN108 35a8 $LN199 35e4 $LN8 35e8 $LN7 35ec $LN6 35f0 $LN5 35f4 $LN4 35f8 $LN2 35fc $LN3"
	strings:
		$1 = { 55 8B EC 81 EC D0 0C 00 00 A1 ?? ?? ?? ?? 33 C5 89 85 58 F9 FF FF C7 85 3C F5 FF FF 00 00 00 00 C7 85 A4 F9 FF FF 00 00 00 00 C7 85 98 F9 FF FF 00 00 00 00 C7 85 70 F9 FF FF 00 00 00 00 C7 85 90 F9 FF FF 00 00 00 00 C7 85 78 F9 FF FF 00 00 00 00 C7 85 A8 F9 FF FF 00 00 00 00 8B 45 10 50 8D 8D 60 F9 FF FF E8 ?? ?? ?? ?? C7 85 94 F9 FF FF 00 00 00 00 C7 85 80 F9 FF FF 00 00 00 00 C7 85 48 F5 FF FF 00 00 00 00 C7 85 AC F9 FF FF 00 00 00 00 C7 85 84 F9 FF FF FF FF FF FF C7 85 A0 F9 FF FF FF FF FF FF C7 85 B0 F9 FF FF FF FF FF FF C7 85 7C F9 FF FF FF FF FF FF C7 85 B4 F9 FF FF FF FF FF FF C7 85 8C F9 FF FF 00 00 00 00 33 C9 83 7D 08 00 0F 95 C1 89 8D 38 F5 FF FF 83 BD 38 F5 FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 07 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 38 F5 FF FF 00 75 49 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 07 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 34 F4 FF FF FF FF FF FF 8D 8D 60 F9 FF FF E8 ?? ?? ?? ?? 8B 85 34 F4 FF FF E9 73 33 00 00 33 C0 83 7D 0C 00 0F 95 C0 89 85 34 F5 FF FF 83 BD 34 F5 FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 0C 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 34 F5 FF FF 00 75 49 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 0C 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 30 F4 FF FF FF FF FF FF 8D 8D 60 F9 FF FF E8 ?? ?? ?? ?? 8B 85 30 F4 FF FF E9 E8 32 00 00 C7 85 54 F5 FF FF 00 00 00 00 8B 55 0C 89 95 94 F9 FF FF C7 85 48 F5 FF FF 00 00 00 00 EB 0F 8B 85 48 F5 FF FF 83 C0 01 89 85 48 F5 FF FF 83 BD 48 F5 FF FF 02 0F 8D 90 32 00 00 83 BD 48 F5 FF FF 01 75 0E 83 BD B4 F9 FF FF 00 75 05 E9 79 32 00 00 C7 85 88 F9 FF FF 00 00 00 00 C7 85 40 F5 FF FF 00 00 00 00 C7 85 8C F9 FF FF 00 00 00 00 C7 85 5C F9 FF FF 00 00 00 00 C7 85 84 F9 FF FF FF FF FF FF C7 85 98 F9 FF FF 00 00 00 00 C7 85 70 F9 FF FF 00 00 00 00 8B 8D 94 F9 FF FF 89 4D 0C C7 85 A0 F9 FF FF FF FF FF FF C7 85 B0 F9 FF FF FF FF FF FF C7 85 7C F9 FF FF FF FF FF FF C7 85 B4 F9 FF FF FF FF FF FF 8B 55 0C 66 8B 02 66 89 85 4C F5 FF FF 0F B7 8D 4C F5 FF FF 8B 55 0C 83 C2 02 89 55 0C 85 C9 0F 84 1A 2F 00 00 83 BD 54 F5 FF FF 00 0F 8C 0D 2F 00 00 0F B7 85 4C F5 FF FF 83 F8 20 7C 25 0F B7 8D 4C F5 FF FF 83 F9 78 7F 19 0F B7 95 4C F5 FF FF 0F B6 82 ?? ?? ?? ?? 83 E0 0F 89 85 9C F3 FF FF EB 0A C7 85 9C F3 FF FF 00 00 00 00 8B 8D 9C F3 FF FF 89 8D 50 F5 FF FF 8B 95 50 F5 FF FF 6B D2 09 8B 85 40 F5 FF FF 0F B6 8C 02 ?? ?? ?? ?? C1 F9 04 89 8D 40 F5 FF FF 83 BD 40 F5 FF FF 01 0F 85 AF 01 00 00 8B 55 0C 0F B7 02 83 F8 25 0F 84 A0 01 00 00 83 BD B4 F9 FF FF FF 75 5C 6A 0A 8D 8D 80 F9 FF FF 51 8B 55 0C 52 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 7E 39 8B 85 80 F9 FF FF 0F B7 08 83 F9 24 75 2B 83 BD 48 F5 FF FF 00 75 16 68 40 06 00 00 6A 00 8D 95 C0 F9 FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C C7 85 B4 F9 FF FF 01 00 00 00 EB 0A C7 85 B4 F9 FF FF 00 00 00 00 83 BD B4 F9 FF FF 01 0F 85 29 01 00 00 6A 0A 8D 85 80 F9 FF FF 50 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 0C 83 E8 01 89 85 A0 F9 FF FF 8B 95 80 F9 FF FF 83 C2 02 89 55 0C 83 BD 48 F5 FF FF 00 0F 85 F2 00 00 00 83 BD A0 F9 FF FF 00 7C 23 8B 85 80 F9 FF FF 0F B7 08 83 F9 24 75 15 83 BD A0 F9 FF FF 64 7D 0C C7 85 98 F3 FF FF 01 00 00 00 EB 0A C7 85 98 F3 FF FF 00 00 00 00 8B 95 98 F3 FF FF 89 95 30 F5 FF FF 83 BD 30 F5 FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 55 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 30 F5 FF FF 00 75 49 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 55 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 2C F4 FF FF FF FF FF FF 8D 8D 60 F9 FF FF E8 ?? ?? ?? ?? 8B 85 2C F4 FF FF E9 03 30 00 00 8B 8D A0 F9 FF FF 3B 8D 84 F9 FF FF 7E 0E 8B 95 A0 F9 FF FF 89 95 94 F3 FF FF EB 0C 8B 85 84 F9 FF FF 89 85 94 F3 FF FF 8B 8D 94 F3 FF FF 89 8D 84 F9 FF FF E9 8E 00 00 00 33 D2 83 BD 40 F5 FF FF 08 0F 95 C2 89 95 2C F5 FF FF 83 BD 2C F5 FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 60 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 2C F5 FF FF 00 75 49 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 60 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 28 F4 FF FF FF FF FF FF 8D 8D 60 F9 FF FF E8 ?? ?? ?? ?? 8B 85 28 F4 FF FF E9 3C 2F 00 00 8B 8D 40 F5 FF FF 89 8D 90 F3 FF FF 83 BD 90 F3 FF FF 07 0F 87 3E 2C 00 00 8B 95 90 F3 FF FF FF 24 95 ?? ?? ?? ?? 83 BD 48 F5 FF FF 00 75 09 83 BD B4 F9 FF FF 01 74 12 83 BD 48 F5 FF FF 01 75 0E 83 BD B4 F9 FF FF FF 75 05 E9 08 2C 00 00 C7 85 A8 F9 FF FF 01 00 00 00 8D 85 54 F5 FF FF 50 8B 4D 08 51 66 8B 95 4C F5 FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C E9 DE 2B 00 00 C7 85 74 F9 FF FF 00 00 00 00 8B 85 74 F9 FF FF 89 85 78 F9 FF FF 8B 8D 78 F9 FF FF 89 8D 98 F9 FF FF 8B 95 98 F9 FF FF 89 95 90 F9 FF FF C7 85 A4 F9 FF FF 00 00 00 00 C7 85 70 F9 FF FF FF FF FF FF C7 85 A8 F9 FF FF 00 00 00 00 E9 8D 2B 00 00 0F B7 85 4C F5 FF FF 89 85 8C F3 FF FF 8B 8D 8C F3 FF FF 83 E9 20 89 8D 8C F3 FF FF 83 BD 8C F3 FF FF 10 77 6A 8B 95 8C F3 FF FF 0F B6 82 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 8B 8D A4 F9 FF FF 83 C9 04 89 8D A4 F9 FF FF EB 45 8B 95 A4 F9 FF FF 83 CA 01 89 95 A4 F9 FF FF EB 34 8B 85 A4 F9 FF FF 83 C8 02 89 85 A4 F9 FF FF EB 23 8B 8D A4 F9 FF FF 81 C9 80 00 00 00 89 8D A4 F9 FF FF EB 0F 8B 95 A4 F9 FF FF 83 CA 08 89 95 A4 F9 FF FF E9 F9 2A 00 00 0F B7 85 4C F5 FF FF 83 F8 2A 0F 85 A8 02 00 00 83 BD B4 F9 FF FF 00 75 17 8D 4D 14 51 E8 ?? ?? ?? ?? 83 C4 04 89 85 98 F9 FF FF E9 60 02 00 00 6A 0A 8D 95 80 F9 FF FF 52 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 0C 83 E8 01 89 85 B0 F9 FF FF 8B 8D 80 F9 FF FF 83 C1 02 89 4D 0C 83 BD 48 F5 FF FF 00 0F 85 FE 01 00 00 83 BD B0 F9 FF FF 00 7C 23 8B 95 80 F9 FF FF 0F B7 02 83 F8 24 75 15 83 BD A0 F9 FF FF 64 7D 0C C7 85 88 F3 FF FF 01 00 00 00 EB 0A C7 85 88 F3 FF FF 00 00 00 00 8B 8D 88 F3 FF FF 89 8D 28 F5 FF FF 83 BD 28 F5 FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 BE 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 28 F5 FF FF 00 75 49 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 BE 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 24 F4 FF FF FF FF FF FF 8D 8D 60 F9 FF FF E8 ?? ?? ?? ?? 8B 85 24 F4 FF FF E9 B9 2C 00 00 8B 85 B0 F9 FF FF 3B 85 84 F9 FF FF 7E 0E 8B 8D B0 F9 FF FF 89 8D 84 F3 FF FF EB 0C 8B 95 84 F9 FF FF 89 95 84 F3 FF FF 8B 85 84 F3 FF FF 89 85 84 F9 FF FF 8B 8D B0 F9 FF FF C1 E1 04 83 BC 0D C0 F9 FF FF 00 75 47 8B 95 B0 F9 FF FF C1 E2 04 C7 84 15 C0 F9 FF FF 01 00 00 00 8B 85 B0 F9 FF FF C1 E0 04 66 8B 8D 4C F5 FF FF 66 89 8C 05 C8 F9 FF FF 8B 95 B0 F9 FF FF C1 E2 04 8B 85 A4 F9 FF FF 89 84 15 CC F9 FF FF E9 AB 00 00 00 8B 8D A4 F9 FF FF 51 66 8B 95 4C F5 FF FF 52 6A 01 8B 85 B0 F9 FF FF C1 E0 04 8D 8C 05 C0 F9 FF FF 51 E8 ?? ?? ?? ?? 83 C4 10 F7 D8 1B C0 F7 D8 89 85 24 F5 FF FF 75 21 68 ?? ?? ?? ?? 6A 00 68 C3 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 24 F5 FF FF 00 75 49 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 C3 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 20 F4 FF FF FF FF FF FF 8D 8D 60 F9 FF FF E8 ?? ?? ?? ?? 8B 85 20 F4 FF FF E9 80 2B 00 00 E9 96 28 00 00 EB 2B 8B 85 B0 F9 FF FF C1 E0 04 8B 8C 05 C4 F9 FF FF 89 8D 20 F5 FF FF 8D 95 20 F5 FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 89 85 98 F9 FF FF 83 BD 98 F9 FF FF 00 7D 1D 8B 85 A4 F9 FF FF 83 C8 04 89 85 A4 F9 FF FF 8B 8D 98 F9 FF FF F7 D9 89 8D 98 F9 FF FF EB 1A 8B 95 98 F9 FF FF 6B D2 0A 0F B7 85 4C F5 FF FF 8D 4C 02 D0 89 8D 98 F9 FF FF E9 22 28 00 00 C7 85 70 F9 FF FF 00 00 00 00 E9 13 28 00 00 0F B7 95 4C F5 FF FF 83 FA 2A 0F 85 95 02 00 00 83 BD B4 F9 FF FF 00 75 17 8D 45 14 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 70 F9 FF FF E9 60 02 00 00 6A 0A 8D 8D 80 F9 FF FF 51 8B 55 0C 52 E8 ?? ?? ?? ?? 83 C4 0C 83 E8 01 89 85 7C F9 FF FF 8B 85 80 F9 FF FF 83 C0 02 89 45 0C 83 BD 48 F5 FF FF 00 0F 85 FE 01 00 00 83 BD 7C F9 FF FF 00 7C 23 8B 8D 80 F9 FF FF 0F B7 11 83 FA 24 75 15 83 BD A0 F9 FF FF 64 7D 0C C7 85 80 F3 FF FF 01 00 00 00 EB 0A C7 85 80 F3 FF FF 00 00 00 00 8B 85 80 F3 FF FF 89 85 1C F5 FF FF 83 BD 1C F5 FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 F3 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 1C F5 FF FF 00 75 49 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 F3 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 1C F4 FF FF FF FF FF FF 8D 8D 60 F9 FF FF E8 ?? ?? ?? ?? 8B 85 1C F4 FF FF E9 D3 29 00 00 8B 95 7C F9 FF FF 3B 95 84 F9 FF FF 7E 0E 8B 85 7C F9 FF FF 89 85 7C F3 FF FF EB 0C 8B 8D 84 F9 FF FF 89 8D 7C F3 FF FF 8B 95 7C F3 FF FF 89 95 84 F9 FF FF 8B 85 7C F9 FF FF C1 E0 04 83 BC 05 C0 F9 FF FF 00 75 47 8B 8D 7C F9 FF FF C1 E1 04 C7 84 0D C0 F9 FF FF 01 00 00 00 8B 95 7C F9 FF FF C1 E2 04 66 8B 85 4C F5 FF FF 66 89 84 15 C8 F9 FF FF 8B 8D 7C F9 FF FF C1 E1 04 8B 95 A4 F9 FF FF 89 94 0D CC F9 FF FF E9 AB 00 00 00 8B 85 A4 F9 FF FF 50 66 8B 8D 4C F5 FF FF 51 6A 01 8B 95 7C F9 FF FF C1 E2 04 8D 84 15 C0 F9 FF FF 50 E8 ?? ?? ?? ?? 83 C4 10 F7 D8 1B C0 F7 D8 89 85 18 F5 FF FF 75 21 68 ?? ?? ?? ?? 6A 00 68 F8 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 18 F5 FF FF 00 75 49 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 F8 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 18 F4 FF FF FF FF FF FF 8D 8D 60 F9 FF FF E8 ?? ?? ?? ?? 8B 85 18 F4 FF FF E9 9A 28 00 00 E9 B0 25 00 00 EB 2B 8B 95 7C F9 FF FF C1 E2 04 8B 84 15 C4 F9 FF FF 89 85 14 F5 FF FF 8D 8D 14 F5 FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 89 85 70 F9 FF FF 83 BD 70 F9 FF FF 00 7D 0A C7 85 70 F9 FF FF FF FF FF FF EB 1A 8B 95 70 F9 FF FF 6B D2 0A 0F B7 85 4C F5 FF FF 8D 4C 02 D0 89 8D 70 F9 FF FF E9 4F 25 00 00 0F B7 95 4C F5 FF FF 89 95 78 F3 FF FF 8B 85 78 F3 FF FF 83 E8 49 89 85 78 F3 FF FF 83 BD 78 F3 FF FF 2E 0F 87 44 01 00 00 8B 8D 78 F3 FF FF 0F B6 91 ?? ?? ?? ?? FF 24 95 ?? ?? ?? ?? 8B 45 0C 0F B7 08 83 F9 6C 75 1C 8B 55 0C 83 C2 02 89 55 0C 8B 85 A4 F9 FF FF 0D 00 10 00 00 89 85 A4 F9 FF FF EB 0F 8B 8D A4 F9 FF FF 83 C9 10 89 8D A4 F9 FF FF E9 F5 00 00 00 8B 55 0C 0F B7 02 83 F8 36 75 2C 8B 4D 0C 0F B7 51 02 83 FA 34 75 20 8B 45 0C 83 C0 04 89 45 0C 8B 8D A4 F9 FF FF 81 C9 00 80 00 00 89 8D A4 F9 FF FF E9 99 00 00 00 8B 55 0C 0F B7 02 83 F8 33 75 29 8B 4D 0C 0F B7 51 02 83 FA 32 75 1D 8B 45 0C 83 C0 04 89 45 0C 8B 8D A4 F9 FF FF 81 E1 FF 7F FF FF 89 8D A4 F9 FF FF EB 65 8B 55 0C 0F B7 02 83 F8 64 74 37 8B 4D 0C 0F B7 11 83 FA 69 74 2C 8B 45 0C 0F B7 08 83 F9 6F 74 21 8B 55 0C 0F B7 02 83 F8 75 74 16 8B 4D 0C 0F B7 11 83 FA 78 74 0B 8B 45 0C 0F B7 08 83 F9 58 75 14 8B 95 A4 F9 FF FF 81 CA 00 00 01 00 89 95 A4 F9 FF FF EB 0F C7 85 40 F5 FF FF 00 00 00 00 E9 FF F7 FF FF EB 23 8B 85 A4 F9 FF FF 83 C8 20 89 85 A4 F9 FF FF EB 12 8B 8D A4 F9 FF FF 81 C9 00 08 00 00 89 8D A4 F9 FF FF E9 DD 23 00 00 0F B7 95 4C F5 FF FF 89 95 74 F3 FF FF 8B 85 74 F3 FF FF 83 E8 41 89 85 74 F3 FF FF 83 BD 74 F3 FF FF 37 0F 87 49 21 00 00 8B 8D 74 F3 FF FF 0F B6 91 ?? ?? ?? ?? FF 24 95 ?? ?? ?? ?? 8B 85 A4 F9 FF FF 25 30 08 00 00 75 0F 8B 8D A4 F9 FF FF 83 C9 20 89 8D A4 F9 FF FF C7 85 A8 F9 FF FF 01 00 00 00 83 BD B4 F9 FF FF 00 75 18 8D 55 14 52 E8 ?? ?? ?? ?? 83 C4 04 66 89 85 44 F5 FF FF E9 F5 01 00 00 83 BD A0 F9 FF FF 00 7C 15 83 BD A0 F9 FF FF 64 7D 0C C7 85 70 F3 FF FF 01 00 00 00 EB 0A C7 85 70 F3 FF FF 00 00 00 00 8B 85 70 F3 FF FF 89 85 10 F5 FF FF 83 BD 10 F5 FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 78 05 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 10 F5 FF FF 00 75 49 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 78 05 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 14 F4 FF FF FF FF FF FF 8D 8D 60 F9 FF FF E8 ?? ?? ?? ?? 8B 85 14 F4 FF FF E9 8E 25 00 00 83 BD 48 F5 FF FF 00 0F 85 0C 01 00 00 8B 95 A0 F9 FF FF C1 E2 04 83 BC 15 C0 F9 FF FF 00 75 47 8B 85 A0 F9 FF FF C1 E0 04 C7 84 05 C0 F9 FF FF 01 00 00 00 8B 8D A0 F9 FF FF C1 E1 04 66 8B 95 4C F5 FF FF 66 89 94 0D C8 F9 FF FF 8B 85 A0 F9 FF FF C1 E0 04 8B 8D A4 F9 FF FF 89 8C 05 CC F9 FF FF E9 AB 00 00 00 8B 95 A4 F9 FF FF 52 66 8B 85 4C F5 FF FF 50 6A 01 8B 8D A0 F9 FF FF C1 E1 04 8D 94 0D C0 F9 FF FF 52 E8 ?? ?? ?? ?? 83 C4 10 F7 D8 1B C0 F7 D8 89 85 0C F5 FF FF 75 21 68 ?? ?? ?? ?? 6A 00 68 7C 05 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 }
	condition:
		$1
}

rule file_227_0_0 {
	meta:
		name = "_strcspn"
		size = 70
	strings:
		$1 = { 55 8B EC 56 33 C0 50 50 50 50 50 50 50 50 8B 55 0C 8D 49 00 8A 02 0A C0 74 09 83 C2 01 0F AB 04 24 EB F1 8B 75 08 83 C9 FF 8D 49 00 83 C1 01 8A 06 0A C0 74 09 83 C6 01 0F A3 04 24 73 EE 8B C1 83 C4 20 5E C9 C3 }
	condition:
		$1
}

rule file_228_0_0 {
	meta:
		name = "__wwincmdln"
		size = 145
		refs = "000f __wcmdln 0019 ??_C@_11LOCGONAA@?$AA?$AA@"
	strings:
		$1 = { 55 8B EC 83 EC 0C C7 45 F8 00 00 00 00 83 3D ?? ?? ?? ?? 00 75 09 C7 45 F4 ?? ?? ?? ?? EB 08 A1 ?? ?? ?? ?? 89 45 F4 8B 4D F4 89 4D FC 8B 55 FC 0F B7 02 83 F8 20 7F 10 8B 4D FC 0F B7 11 85 D2 74 28 83 7D F8 00 74 22 8B 45 FC 0F B7 08 83 F9 22 75 0C 33 D2 83 7D F8 00 0F 94 C2 89 55 F8 8B 45 FC 83 C0 02 89 45 FC EB C3 8B 4D FC 0F B7 11 85 D2 74 16 8B 45 FC 0F B7 08 83 F9 20 7F 0B 8B 55 FC 83 C2 02 89 55 FC EB E0 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_229_0_0 {
	meta:
		name = "?_ValidateRead@@YAHPBXI@Z"
		size = 31
		altNames = "?_ValidateExecute@@YAHP6GHXZ@Z ?_ValidateWrite@@YAHPAXI@Z"
	strings:
		$1 = { 55 8B EC 51 C7 45 FC 01 00 00 00 83 7D 08 00 75 07 C7 45 FC 00 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_230_0_0 {
	meta:
		name = "__vswprintf_helper"
		size = 557
		refs = "001f ??_C@_1CC@MGIEJOME@?$AA?$CI?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 002b ??_C@_1GG@PFLMBLMN@?$AAf?$AA?3?$AA?2?$AAr?$AAt?$AAm?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2@ 0032 __CrtDbgReportW 0046 __errno 005d ??_C@_1CE@IGKFIJFD@?$AA_?$AAv?$AAs?$AAw?$AAp?$AAr?$AAi?$AAn?$AAt?$AAf?$AA_?$AAh?$AAe?$AAl?$AAp?$AAe?$AAr?$AA?$AA@ 0067 __invalid_parameter 009f ??_C@_1EC@FABAOFFO@?$AA?$CI?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$CJ?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AA?$CI?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ@ 01a3 __flsbuf"
	strings:
		$1 = { 55 8B EC 83 EC 3C 8D 45 D8 89 45 F8 33 C9 83 7D 14 00 0F 95 C1 89 4D D4 83 7D D4 00 75 21 68 ?? ?? ?? ?? 6A 00 68 82 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D4 00 75 31 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 82 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 B3 01 00 00 83 7D 10 00 74 0F 83 7D 0C 00 75 09 C7 45 CC 00 00 00 00 EB 07 C7 45 CC 01 00 00 00 8B 45 CC 89 45 D0 83 7D D0 00 75 21 68 ?? ?? ?? ?? 6A 00 68 85 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D0 00 75 31 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 85 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 33 01 00 00 8B 55 F8 C7 42 0C 42 00 00 00 8B 45 F8 8B 4D 0C 89 48 08 8B 55 F8 8B 45 0C 89 02 81 7D 10 FF FF FF 3F 76 0C 8B 4D F8 C7 41 04 FF FF FF 7F EB 0B 8B 55 10 D1 E2 8B 45 F8 89 50 04 8B 4D 1C 51 8B 55 18 52 8B 45 14 50 8B 4D F8 51 FF 55 08 83 C4 10 89 45 FC 83 7D 0C 00 75 08 8B 45 FC E9 D1 00 00 00 83 7D FC 00 0F 8C A7 00 00 00 8B 55 F8 8B 42 04 83 E8 01 8B 4D F8 89 41 04 8B 55 F8 83 7A 04 00 7C 22 8B 45 F8 8B 08 C6 01 00 33 D2 81 E2 FF 00 00 00 89 55 C8 8B 45 F8 8B 08 83 C1 01 8B 55 F8 89 0A EB 11 8B 45 F8 50 6A 00 E8 ?? ?? ?? ?? 83 C4 08 89 45 C8 83 7D C8 FF 74 56 8B 4D F8 8B 51 04 83 EA 01 8B 45 F8 89 50 04 8B 4D F8 83 79 04 00 7C 22 8B 55 F8 8B 02 C6 00 00 33 C9 81 E1 FF 00 00 00 89 4D C4 8B 55 F8 8B 02 83 C0 01 8B 4D F8 89 01 EB 11 8B 55 F8 52 6A 00 E8 ?? ?? ?? ?? 83 C4 08 89 45 C4 83 7D C4 FF 74 05 8B 45 FC EB 20 8B 45 10 8B 4D 0C 66 C7 44 41 FE 00 00 8B 55 F8 83 7A 04 00 7D 07 B8 FE FF FF FF EB 03 83 C8 FF 8B E5 5D C3 }
	condition:
		$1
}

rule file_230_1_0 {
	meta:
		name = "__vswprintf_c"
		size = 68
		refs = "0019 __woutput_l 001e __vswprintf_helper"
	strings:
		$1 = { 55 8B EC 83 EC 08 8B 45 14 50 6A 00 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 18 89 45 FC 83 7D FC 00 7D 09 C7 45 F8 FF FF FF FF EB 06 8B 4D FC 89 4D F8 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_894_1_0 {
	meta:
		name = "__vsnprintf_c"
		size = 68
		refs = "0019 __output_l 001e __vsnprintf_helper"
	strings:
		$1 = { 55 8B EC 83 EC 08 8B 45 14 50 6A 00 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 18 89 45 FC 83 7D FC 00 7D 09 C7 45 F8 FF FF FF FF EB 06 8B 4D FC 89 4D F8 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_894_7_0 {
	meta:
		name = "__vsprintf_p"
		size = 68
		refs = "0019 __output_p_l 001e __vsnprintf_helper"
	strings:
		$1 = { 55 8B EC 83 EC 08 8B 45 14 50 6A 00 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 18 89 45 FC 83 7D FC 00 7D 09 C7 45 F8 FF FF FF FF EB 06 8B 4D FC 89 4D F8 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_230_7_0 {
	meta:
		name = "__vswprintf_p"
		size = 68
		refs = "0019 __woutput_p_l 001e __vswprintf_helper"
	strings:
		$1 = { 55 8B EC 83 EC 08 8B 45 14 50 6A 00 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 18 89 45 FC 83 7D FC 00 7D 09 C7 45 F8 FF FF FF FF EB 06 8B 4D FC 89 4D F8 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_230_2_0 {
	meta:
		name = "__vswprintf_c_l"
		size = 70
		refs = "001b __woutput_l 0020 __vswprintf_helper"
	strings:
		$1 = { 55 8B EC 83 EC 08 8B 45 18 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 18 89 45 FC 83 7D FC 00 7D 09 C7 45 F8 FF FF FF FF EB 06 8B 55 FC 89 55 F8 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_894_2_0 {
	meta:
		name = "__vsnprintf_c_l"
		size = 70
		refs = "001b __output_l 0020 __vsnprintf_helper"
	strings:
		$1 = { 55 8B EC 83 EC 08 8B 45 18 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 18 89 45 FC 83 7D FC 00 7D 09 C7 45 F8 FF FF FF FF EB 06 8B 55 FC 89 55 F8 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_894_8_0 {
	meta:
		name = "__vsprintf_p_l"
		size = 70
		refs = "001b __output_p_l 0020 __vsnprintf_helper"
	strings:
		$1 = { 55 8B EC 83 EC 08 8B 45 18 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 18 89 45 FC 83 7D FC 00 7D 09 C7 45 F8 FF FF FF FF EB 06 8B 55 FC 89 55 F8 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_230_8_0 {
	meta:
		name = "__vswprintf_p_l"
		size = 70
		refs = "001b __woutput_p_l 0020 __vswprintf_helper"
	strings:
		$1 = { 55 8B EC 83 EC 08 8B 45 18 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 18 89 45 FC 83 7D FC 00 7D 09 C7 45 F8 FF FF FF FF EB 06 8B 55 FC 89 55 F8 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_230_3_0 {
	meta:
		name = "__vswprintf_s_l"
		size = 613
		refs = "0020 ??_C@_1BO@MLMCMBKN@?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 002c ??_C@_1GG@PFLMBLMN@?$AAf?$AA?3?$AA?2?$AAr?$AAt?$AAm?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2@ 0033 __CrtDbgReportW 0047 __errno 005e ??_C@_1BO@OALHJLCI@?$AA_?$AAv?$AAs?$AAw?$AAp?$AAr?$AAi?$AAn?$AAt?$AAf?$AA_?$AAs?$AA_?$AAl?$AA?$AA@ 0068 __invalid_parameter 00a0 ??_C@_1EE@MPCHJFGP@?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAW?$AAo?$AAr?$AAd?$AAs?$AA?5?$AA?$DO?$AA?5@ 010c __woutput_s_l 0111 __vswprintf_helper 0146 ___crtDebugFillThreshold 0173 _memset 01a1 ??_C@_1DA@HPBFKMEB@?$AA?$CI?$AA?$CC?$AAB?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AAt?$AAo?$AAo?$AA?5?$AAs?$AAm?$AAa?$AAl?$AAl?$AA?$CC?$AA?0?$AA?5?$AA0?$AA?$CJ?$AA?$AA@"
	strings:
		$1 = { 55 8B EC 83 EC 20 C7 45 FC FF FF FF FF 33 C0 83 7D 10 00 0F 95 C0 89 45 F8 83 7D F8 00 75 21 68 ?? ?? ?? ?? 6A 00 68 0D 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F8 00 75 31 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 0D 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 EA 01 00 00 83 7D 08 00 74 0F 83 7D 0C 00 76 09 C7 45 EC 01 00 00 00 EB 07 C7 45 EC 00 00 00 00 8B 55 EC 89 55 F4 83 7D F4 00 75 21 68 ?? ?? ?? ?? 6A 00 68 0E 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F4 00 75 31 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 0E 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 6A 01 00 00 8B 4D 18 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 18 89 45 FC 83 7D FC 00 7D 59 8B 45 08 66 C7 00 00 00 83 7D 0C FF 74 4B 81 7D 0C FF FF FF 7F 74 42 83 7D 0C 01 76 3C 8B 4D 0C 83 E9 01 39 0D ?? ?? ?? ?? 73 0B 8B 15 ?? ?? ?? ?? 89 55 E8 EB 09 8B 45 0C 83 E8 01 89 45 E8 8B 4D E8 D1 E1 51 68 FD 00 00 00 8B 55 08 83 C2 02 52 E8 ?? ?? ?? ?? 83 C4 0C 83 7D FC FE 75 75 33 C0 74 09 C7 45 E4 01 00 00 00 EB 07 C7 45 E4 00 00 00 00 8B 4D E4 89 4D F0 83 7D F0 00 75 21 68 ?? ?? ?? ?? 6A 00 68 18 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 2E E8 ?? ?? ?? ?? C7 00 22 00 00 00 6A 00 68 18 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 6C 83 7D FC 00 7C 63 83 7D 0C FF 74 5D 81 7D 0C FF FF FF 7F 74 54 8B 45 FC 83 C0 01 3B 45 0C 73 49 8B 4D FC 83 C1 01 8B 55 0C 2B D1 39 15 ?? ?? ?? ?? 73 0A A1 ?? ?? ?? ?? 89 45 E0 EB 0E 8B 4D FC 83 C1 01 8B 55 0C 2B D1 89 55 E0 8B 45 E0 D1 E0 50 68 FD 00 00 00 8B 4D FC 8B 55 08 8D 44 4A 02 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_230_4_0 {
	meta:
		name = "_vswprintf_s"
		size = 31
		refs = "0016 __vswprintf_s_l"
	strings:
		$1 = { 55 8B EC 8B 45 14 50 6A 00 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_604_3_0 {
	meta:
		name = "?vswprintf@@YAHPAGIPBGPAD@Z"
		size = 31
		refs = "0016 ?_vswprintf_l@@YAHPA_WIPB_WPAUlocaleinfo_struct@@PAD@Z"
	strings:
		$1 = { 55 8B EC 8B 45 14 50 6A 00 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_604_1_0 {
	meta:
		name = "?vswprintf@@YAHPA_WIPB_WPAD@Z"
		size = 31
		refs = "0016 ?_vswprintf_l@@YAHPA_WIPB_WPAUlocaleinfo_struct@@PAD@Z"
	strings:
		$1 = { 55 8B EC 8B 45 14 50 6A 00 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_836_1_0 {
	meta:
		name = "__vsnprintf"
		size = 31
		refs = "0016 __vsnprintf_l"
	strings:
		$1 = { 55 8B EC 8B 45 14 50 6A 00 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_845_1_0 {
	meta:
		name = "__vsnwprintf"
		size = 31
		refs = "0016 __vsnwprintf_l"
	strings:
		$1 = { 55 8B EC 8B 45 14 50 6A 00 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_894_4_0 {
	meta:
		name = "_vsprintf_s"
		size = 31
		refs = "0016 __vsprintf_s_l"
	strings:
		$1 = { 55 8B EC 8B 45 14 50 6A 00 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_230_5_0 {
	meta:
		name = "__vsnwprintf_s_l"
		size = 937
		refs = "0027 ??_C@_1BO@MLMCMBKN@?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0033 ??_C@_1GG@PFLMBLMN@?$AAf?$AA?3?$AA?2?$AAr?$AAt?$AAm?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2@ 003a __CrtDbgReportW 004e __errno 0065 ??_C@_1CA@BKFKMJFF@?$AA_?$AAv?$AAs?$AAn?$AAw?$AAp?$AAr?$AAi?$AAn?$AAt?$AAf?$AA_?$AAs?$AA_?$AAl?$AA?$AA@ 006f __invalid_parameter 00c0 ??_C@_1EE@MPCHJFGP@?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAW?$AAo?$AAr?$AAd?$AAs?$AA?5?$AA?$DO?$AA?5@ 0145 __woutput_s_l 014a __vswprintf_helper 0185 ___crtDebugFillThreshold 01bb _memset 02cd ??_C@_1DA@HPBFKMEB@?$AA?$CI?$AA?$CC?$AAB?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AAt?$AAo?$AAo?$AA?5?$AAs?$AAm?$AAa?$AAl?$AAl?$AA?$CC?$AA?0?$AA?5?$AA0?$AA?$CJ?$AA?$AA@"
	strings:
		$1 = { 55 8B EC 83 EC 2C C7 45 FC FF FF FF FF C7 45 F8 00 00 00 00 33 C0 83 7D 14 00 0F 95 C0 89 45 F4 83 7D F4 00 75 21 68 ?? ?? ?? ?? 6A 00 68 39 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F4 00 75 31 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 39 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 27 03 00 00 83 7D 10 00 75 13 83 7D 08 00 75 0D 83 7D 0C 00 75 07 33 C0 E9 0E 03 00 00 83 7D 08 00 74 0F 83 7D 0C 00 76 09 C7 45 E8 01 00 00 00 EB 07 C7 45 E8 00 00 00 00 8B 55 E8 89 55 F0 83 7D F0 00 75 21 68 ?? ?? ?? ?? 6A 00 68 3F 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 31 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 3F 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 8E 02 00 00 8B 4D 0C 3B 4D 10 0F 86 BD 00 00 00 E8 ?? ?? ?? ?? 8B 10 89 55 F8 8B 45 1C 50 8B 4D 18 51 8B 55 14 52 8B 45 10 83 C0 01 50 8B 4D 08 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 18 89 45 FC 83 7D FC FE 0F 85 80 00 00 00 83 7D 0C FF 74 5E 81 7D 0C FF FF FF 7F 74 55 8B 55 10 83 C2 01 3B 55 0C 73 4A 8B 45 10 83 C0 01 8B 4D 0C 2B C8 39 0D ?? ?? ?? ?? 73 0B 8B 15 ?? ?? ?? ?? 89 55 E4 EB 0E 8B 45 10 83 C0 01 8B 4D 0C 2B C8 89 4D E4 8B 55 E4 D1 E2 52 68 FD 00 00 00 8B 45 10 8B 4D 08 8D 54 41 02 52 E8 ?? ?? ?? ?? 83 C4 0C E8 ?? ?? ?? ?? 83 38 22 75 0A E8 ?? ?? ?? ?? 8B 4D F8 89 08 83 C8 FF E9 C7 01 00 00 EB 63 E8 ?? ?? ?? ?? 8B 10 89 55 F8 8B 45 1C 50 8B 4D 18 51 8B 55 14 52 8B 45 0C 50 8B 4D 08 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 18 89 45 FC 8B 55 0C 8B 45 08 66 C7 44 50 FE 00 00 83 7D FC FE 75 22 83 7D 10 FF 75 1C E8 ?? ?? ?? ?? 83 38 22 75 0A E8 ?? ?? ?? ?? 8B 4D F8 89 08 83 C8 FF E9 62 01 00 00 83 7D FC 00 0F 8D DC 00 00 00 8B 55 08 66 C7 02 00 00 83 7D 0C FF 74 4B 81 7D 0C FF FF FF 7F 74 42 83 7D 0C 01 76 3C 8B 45 0C 83 E8 01 39 05 ?? ?? ?? ?? 73 0B 8B 0D ?? ?? ?? ?? 89 4D E0 EB 09 8B 55 0C 83 EA 01 89 55 E0 8B 45 E0 D1 E0 50 68 FD 00 00 00 8B 4D 08 83 C1 02 51 E8 ?? ?? ?? ?? 83 C4 0C 83 7D FC FE 75 78 33 D2 74 09 C7 45 DC 01 00 00 00 EB 07 C7 45 DC 00 00 00 00 8B 45 DC 89 45 EC 83 7D EC 00 75 21 68 ?? ?? ?? ?? 6A 00 68 66 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D EC 00 75 31 E8 ?? ?? ?? ?? C7 00 22 00 00 00 6A 00 68 66 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 81 00 00 00 83 C8 FF EB 7C 83 7D 0C FF 74 5E 81 7D 0C FF FF FF 7F 74 55 8B 55 FC 83 C2 01 3B 55 0C 73 4A 8B 45 FC 83 C0 01 8B 4D 0C 2B C8 39 0D ?? ?? ?? ?? 73 0B 8B 15 ?? ?? ?? ?? 89 55 D8 EB 0E 8B 45 FC 83 C0 01 8B 4D 0C 2B C8 89 4D D8 8B 55 D8 D1 E2 52 68 FD 00 00 00 8B 45 FC 8B 4D 08 8D 54 41 02 52 E8 ?? ?? ?? ?? 83 C4 0C 83 7D FC 00 7D 09 C7 45 D4 FF FF FF FF EB 06 8B 45 FC 89 45 D4 8B 45 D4 8B E5 5D C3 }
	condition:
		$1
}

rule file_230_6_0 {
	meta:
		name = "__vsnwprintf_s"
		size = 35
		refs = "001a __vsnwprintf_s_l"
	strings:
		$1 = { 55 8B EC 8B 45 18 50 6A 00 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_460_10_0 {
	meta:
		name = "__strftime_l"
		size = 35
		refs = "001a __Strftime_l"
	strings:
		$1 = { 55 8B EC 8B 45 18 50 6A 00 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_894_6_0 {
	meta:
		name = "__vsnprintf_s"
		size = 35
		refs = "001a __vsnprintf_s_l"
	strings:
		$1 = { 55 8B EC 8B 45 18 50 6A 00 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_231_0_0 {
	meta:
		name = "_fgetc"
		size = 647
		refs = "0006 __sehtable$_fgetc 000b __except_handler4 001d ___security_cookie 004a ??_C@_1CC@FADMNIL@?$AA?$CI?$AAs?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0053 ??_C@_1BA@JFIGNACJ@?$AAf?$AAg?$AAe?$AAt?$AAc?$AA?4?$AAc?$AA?$AA@ 005a __CrtDbgReportW 006e __errno 0082 ??_C@_1M@FBFFFGJE@?$AAf?$AAg?$AAe?$AAt?$AAc?$AA?$AA@ 008c __invalid_parameter 00a0 __lock_file 00c8 __fileno 010b ___pioinfo 0117 ___badioinfo 01b4 ??_C@_1BAE@CBLKKPB@?$AA?$CI?$AA?5?$AA?$CI?$AA_?$AAS?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?9?$AA?$DO?$AA_?$AAf?$AAl?$AAa?$AAg?$AA?5?$AA?$CG?$AA?5?$AA_?$AAI?$AAO?$AAS?$AAT?$AAR?$AAG?$AA?$CJ?$AA?5?$AA?$HM?$AA?$HM?$AA?5@ 0247 __filbuf 026a __unlock_file"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 D8 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 C7 45 E4 00 00 00 00 33 C0 83 7D 08 00 0F 95 C0 89 45 E0 83 7D E0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 29 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 29 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 DA 01 00 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 45 08 89 45 DC 8B 4D DC 8B 51 0C 83 E2 40 0F 85 DD 00 00 00 8B 45 DC 50 E8 ?? ?? ?? ?? 83 C4 04 83 F8 FF 74 40 8B 4D DC 51 E8 ?? ?? ?? ?? 83 C4 04 83 F8 FE 74 2F 8B 55 DC 52 E8 ?? ?? ?? ?? 83 C4 04 8B F0 C1 FE 05 8B 45 DC 50 E8 ?? ?? ?? ?? 83 C4 04 83 E0 1F 6B C0 28 03 04 B5 ?? ?? ?? ?? 89 45 D4 EB 07 C7 45 D4 ?? ?? ?? ?? 8B 4D D4 8A 51 24 D0 E2 D0 FA 0F BE C2 85 C0 75 6B 8B 4D DC 51 E8 ?? ?? ?? ?? 83 C4 04 83 F8 FF 74 40 8B 55 DC 52 E8 ?? ?? ?? ?? 83 C4 04 83 F8 FE 74 2F 8B 45 DC 50 E8 ?? ?? ?? ?? 83 C4 04 8B F0 C1 FE 05 8B 4D DC 51 E8 ?? ?? ?? ?? 83 C4 04 83 E0 1F 6B C0 28 03 04 B5 ?? ?? ?? ?? 89 45 D0 EB 07 C7 45 D0 ?? ?? ?? ?? 8B 55 D0 8A 42 24 C0 E0 00 C0 F8 07 0F BE C8 85 C9 74 09 C7 45 CC 00 00 00 00 EB 07 C7 45 CC 01 00 00 00 8B 55 CC 89 55 D8 83 7D D8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 2D 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D8 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 2D 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 E4 FF FF FF FF 83 7D E4 00 75 4D 8B 4D 08 8B 51 04 83 EA 01 8B 45 08 89 50 04 8B 4D 08 83 79 04 00 7C 20 8B 55 08 8B 02 0F BE 08 81 E1 FF 00 00 00 89 4D C8 8B 55 08 8B 02 83 C0 01 8B 4D 08 89 01 EB 0F 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 C8 8B 45 C8 89 45 E4 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0D 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 E4 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_231_1_0 {
	meta:
		name = "_getc"
		size = 647
		refs = "0006 __sehtable$_getc 000b __except_handler4 001d ___security_cookie 004a ??_C@_1CC@FADMNIL@?$AA?$CI?$AAs?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0053 ??_C@_1BA@JFIGNACJ@?$AAf?$AAg?$AAe?$AAt?$AAc?$AA?4?$AAc?$AA?$AA@ 005a __CrtDbgReportW 006e __errno 0082 ??_C@_19OGFDBGF@?$AAg?$AAe?$AAt?$AAc?$AA?$AA@ 008c __invalid_parameter 00a0 __lock_file 00c8 __fileno 010b ___pioinfo 0117 ___badioinfo 01b4 ??_C@_1BAE@CBLKKPB@?$AA?$CI?$AA?5?$AA?$CI?$AA_?$AAS?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?9?$AA?$DO?$AA_?$AAf?$AAl?$AAa?$AAg?$AA?5?$AA?$CG?$AA?5?$AA_?$AAI?$AAO?$AAS?$AAT?$AAR?$AAG?$AA?$CJ?$AA?5?$AA?$HM?$AA?$HM?$AA?5@ 0247 __filbuf 026a __unlock_file"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 D8 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 C7 45 E4 00 00 00 00 33 C0 83 7D 08 00 0F 95 C0 89 45 E0 83 7D E0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 44 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 44 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 DA 01 00 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 45 08 89 45 DC 8B 4D DC 8B 51 0C 83 E2 40 0F 85 DD 00 00 00 8B 45 DC 50 E8 ?? ?? ?? ?? 83 C4 04 83 F8 FF 74 40 8B 4D DC 51 E8 ?? ?? ?? ?? 83 C4 04 83 F8 FE 74 2F 8B 55 DC 52 E8 ?? ?? ?? ?? 83 C4 04 8B F0 C1 FE 05 8B 45 DC 50 E8 ?? ?? ?? ?? 83 C4 04 83 E0 1F 6B C0 28 03 04 B5 ?? ?? ?? ?? 89 45 D4 EB 07 C7 45 D4 ?? ?? ?? ?? 8B 4D D4 8A 51 24 D0 E2 D0 FA 0F BE C2 85 C0 75 6B 8B 4D DC 51 E8 ?? ?? ?? ?? 83 C4 04 83 F8 FF 74 40 8B 55 DC 52 E8 ?? ?? ?? ?? 83 C4 04 83 F8 FE 74 2F 8B 45 DC 50 E8 ?? ?? ?? ?? 83 C4 04 8B F0 C1 FE 05 8B 4D DC 51 E8 ?? ?? ?? ?? 83 C4 04 83 E0 1F 6B C0 28 03 04 B5 ?? ?? ?? ?? 89 45 D0 EB 07 C7 45 D0 ?? ?? ?? ?? 8B 55 D0 8A 42 24 C0 E0 00 C0 F8 07 0F BE C8 85 C9 74 09 C7 45 CC 00 00 00 00 EB 07 C7 45 CC 01 00 00 00 8B 55 CC 89 55 D8 83 7D D8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 49 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D8 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 49 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 E4 FF FF FF FF 83 7D E4 00 75 4D 8B 4D 08 8B 51 04 83 EA 01 8B 45 08 89 50 04 8B 4D 08 83 79 04 00 7C 20 8B 55 08 8B 02 0F BE 08 81 E1 FF 00 00 00 89 4D C8 8B 55 08 8B 02 83 C0 01 8B 4D 08 89 01 EB 0F 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 C8 8B 45 C8 89 45 E4 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0D 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 E4 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_231_2_0 {
	meta:
		name = "__getc_nolock"
		size = 81
		refs = "0040 __filbuf"
		altNames = "__inc"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 8B 48 04 83 E9 01 8B 55 08 89 4A 04 8B 45 08 83 78 04 00 7C 1F 8B 4D 08 8B 11 0F BE 02 25 FF 00 00 00 89 45 FC 8B 4D 08 8B 11 83 C2 01 8B 45 08 89 10 EB 0F 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_232_0_0 {
	meta:
		name = "__freea"
		size = 43
		refs = "0022 _free"
	strings:
		$1 = { 55 8B EC 83 7D 08 00 74 20 8B 45 08 83 E8 08 89 45 08 8B 4D 08 81 39 DD DD 00 00 75 0C 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_233_1_0 {
	meta:
		name = "___tmainCRTStartup"
		size = 681
		refs = "0006 __sehtable$___tmainCRTStartup 000b __except_handler4 001d ___security_cookie 0066 __imp__GetProcessHeap@0 006d __imp__HeapAlloc@12 007d _fast_error_exit 009d __imp__GetVersionExA@4 00b4 __imp__HeapFree@12 0121 __set_osplatform 012d __set_winver 0139 __set_winmajor 0145 __set_winminor 0151 __set_osver 0159 _check_managed_app 0163 __heap_init 0179 __mtinit 018e __CrtSetCheckCount 0196 __RTC_Initialize 01a2 __ioinit 01ad __amsg_exit 01b5 ___crtGetCommandLineW 01ba __wcmdln 01bf ___crtGetEnvironmentStringsW 01c4 __wenvptr 01c9 __wsetargv 01dc __wsetenvp 01f1 __cinit 020f __wenviron 0215 ___winitenv 0221 ___wargv 0228 ___argc 022e _wmain 0243 _exit 0248 __cexit 0268 __XcptFilter 0284 __exit 0289 __c_exit"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 D0 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 89 65 E8 C7 45 D8 00 00 00 00 C7 45 C4 00 00 00 00 C7 45 E4 00 00 00 00 C7 45 D0 00 00 00 00 C7 45 CC 00 00 00 00 C7 45 C8 00 00 00 00 68 94 00 00 00 6A 00 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 89 45 D4 83 7D D4 00 75 14 6A 12 E8 ?? ?? ?? ?? 83 C4 04 B8 FF 00 00 00 E9 09 02 00 00 8B 45 D4 C7 00 94 00 00 00 8B 4D D4 51 FF 15 ?? ?? ?? ?? 85 C0 75 1D 8B 55 D4 52 6A 00 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? B8 FF 00 00 00 E9 D5 01 00 00 8B 45 D4 8B 48 10 89 4D D8 8B 55 D4 8B 42 04 89 45 E4 8B 4D D4 8B 51 08 89 55 D0 8B 45 D4 8B 48 0C 81 E1 FF 7F 00 00 89 4D CC 8B 55 D4 52 6A 00 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 83 7D D8 02 74 0B 8B 45 CC 0D 00 80 00 00 89 45 CC 8B 4D E4 C1 E1 08 03 4D D0 89 4D C4 8B 55 D8 52 E8 ?? ?? ?? ?? 83 C4 04 8B 45 C4 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D E4 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 D0 52 E8 ?? ?? ?? ?? 83 C4 04 8B 45 CC 50 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 89 45 DC 6A 01 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 0A 6A 1C E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 85 C0 75 0A 6A 10 E8 ?? ?? ?? ?? 83 C4 04 6A 01 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 E8 ?? ?? ?? ?? 85 C0 7D 0A 6A 1B E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 7D 0A 6A 08 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 85 C0 7D 0A 6A 09 E8 ?? ?? ?? ?? 83 C4 04 6A 01 E8 ?? ?? ?? ?? 83 C4 04 89 45 E0 83 7D E0 00 74 0C 8B 4D E0 51 E8 ?? ?? ?? ?? 83 C4 04 8B 15 ?? ?? ?? ?? 89 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? 50 8B 0D ?? ?? ?? ?? 51 8B 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 0C 89 45 C8 83 7D DC 00 75 09 8B 45 C8 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 45 FC FE FF FF FF EB 3F 8B 4D EC 8B 11 8B 02 89 45 C0 8B 4D EC 51 8B 55 C0 52 E8 ?? ?? ?? ?? 83 C4 08 C3 8B 65 E8 8B 45 C0 89 45 C8 83 7D DC 00 75 09 8B 4D C8 51 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 45 FC FE FF FF FF 8B 45 C8 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_233_7_0 {
	meta:
		name = "_fast_error_exit"
		size = 44
		refs = "0005 ___error_mode 000d __FF_MSGBANNER 0016 __NMSG_WRITE 0023 ___crtExitProcess"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? 02 74 05 E8 ?? ?? ?? ?? 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 68 FF 00 00 00 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_233_8_0 {
	meta:
		name = "_check_managed_app"
		size = 114
		refs = "0009 ___ImageBase"
	strings:
		$1 = { 55 8B EC 83 EC 08 C7 45 FC ?? ?? ?? ?? 83 7D FC 00 74 0E 8B 45 FC 0F B7 08 81 F9 4D 5A 00 00 74 04 33 C0 EB 49 8B 55 FC 8B 45 FC 03 42 3C 89 45 F8 8B 4D F8 81 39 50 45 00 00 74 04 33 C0 EB 2E 8B 55 F8 0F B7 42 18 3D 0B 01 00 00 74 04 33 C0 EB 1C 8B 4D F8 83 79 74 0E 77 04 33 C0 EB 0F 8B 55 F8 33 C0 83 BA E8 00 00 00 00 0F 95 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_234_0_0 {
	meta:
		name = "_strncmp"
		size = 367
	strings:
		$1 = { 55 8B EC 51 C7 45 FC 00 00 00 00 83 7D 10 00 75 07 33 C0 E9 53 01 00 00 83 7D 10 04 0F 82 F6 00 00 00 EB 09 8B 45 FC 83 C0 04 89 45 FC 8B 4D 10 83 E9 04 39 4D FC 0F 83 DC 00 00 00 8B 55 08 83 C2 04 89 55 08 8B 45 0C 83 C0 04 89 45 0C 8B 4D 08 0F BE 51 FC 85 D2 74 12 8B 45 08 0F BE 48 FC 8B 55 0C 0F BE 42 FC 3B C8 74 15 8B 4D 08 0F B6 41 FC 8B 55 0C 0F B6 4A FC 2B C1 E9 EB 00 00 00 8B 55 08 0F BE 42 FD 85 C0 74 12 8B 4D 08 0F BE 51 FD 8B 45 0C 0F BE 48 FD 3B D1 74 15 8B 55 08 0F B6 42 FD 8B 4D 0C 0F B6 51 FD 2B C2 E9 B9 00 00 00 8B 45 08 0F BE 48 FE 85 C9 74 12 8B 55 08 0F BE 42 FE 8B 4D 0C 0F BE 51 FE 3B C2 74 15 8B 45 08 0F B6 40 FE 8B 4D 0C 0F B6 51 FE 2B C2 E9 87 00 00 00 8B 45 08 0F BE 48 FF 85 C9 74 12 8B 55 08 0F BE 42 FF 8B 4D 0C 0F BE 51 FF 3B C2 74 12 8B 45 08 0F B6 40 FF 8B 4D 0C 0F B6 51 FF 2B C2 EB 58 E9 0C FF FF FF EB 09 8B 45 FC 83 C0 01 89 45 FC 8B 4D FC 3B 4D 10 73 3E 8B 55 08 0F BE 02 85 C0 74 10 8B 4D 08 0F BE 11 8B 45 0C 0F BE 08 3B D1 74 10 8B 55 08 0F B6 02 8B 4D 0C 0F B6 11 2B C2 EB 16 8B 45 08 83 C0 01 89 45 08 8B 4D 0C 83 C1 01 89 4D 0C EB B1 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_236_0_0 {
	meta:
		name = "__wspawnvpe"
		size = 1135
		refs = "0028 ??_C@_1CC@JBMDNKJP@?$AAf?$AAi?$AAl?$AAe?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0031 ??_C@_1GG@HHAHOGAN@?$AAf?$AA?3?$AA?2?$AAr?$AAt?$AAm?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2@ 0038 __CrtDbgReportW 004c __errno 0060 ??_C@_1BG@NJDAJIEB@?$AA_?$AAw?$AAs?$AAp?$AAa?$AAw?$AAn?$AAv?$AAp?$AAe?$AA?$AA@ 006a __invalid_parameter 008b ??_C@_1CM@DMCMCPME@?$AA?$CK?$AAf?$AAi?$AAl?$AAe?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 00ef ??_C@_1BK@DKFDJEHE@?$AAa?$AAr?$AAg?$AAv?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0155 ??_C@_1BM@CNLEOMNN@?$AA?$CK?$AAa?$AAr?$AAg?$AAv?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 01ba ??_C@_1CG@JGBGIIEL@?$AA?$CK?$AA?$CK?$AAa?$AAr?$AAg?$AAv?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 0231 __wspawnve 0256 _wcschr 0270 ??_C@_1OG@HLCCAAKI@?$AA_?$AAw?$AAd?$AAu?$AAp?$AAe?$AAn?$AAv?$AA_?$AAs?$AA_?$AAd?$AAb?$AAg?$AA?$CI?$AA?$CG?$AAe?$AAn?$AAv?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA?$CI?$AAv?$AAo?$AAi?$AAd?$AA?5?$AA?$CK@ 027b ??_C@_0DD@MMHOFGEC@f?3?2rtm?2vctools?2crt_bld?2self_x86?2@ 0282 ??_C@_19IJOJOJIB@?$AAP?$AAA?$AAT?$AAH?$AA?$AA@ 028d __wdupenv_s_dbg 0296 __invoke_watson_if_oneof 02b8 __calloc_dbg 02e1 __wgetpath 0308 _wcslen 0341 ??_C@_1DE@CIMJAAKO@?$AAw?$AAc?$AAs?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA2?$AA6?$AA0?$AA?0?$AA?5?$AAL?$AA?$CC?$AA?2?$AA?2?$AA?$CC?$AA?$CJ?$AA?$AA@ 0346 ??_C@_13FPGAJAPJ@?$AA?2?$AA?$AA@ 0354 _wcscat_s 035d __invoke_watson_if_error 039a ??_C@_1DK@JGMPLNHE@?$AAw?$AAc?$AAs?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA2?$AA6?$AA0?$AA?0?$AA?5?$AAf?$AAi?$AAl?$AAe?$AAn?$AAa?$AAm?$AAe?$AA?$CJ?$AA?$AA@ 044c __free_dbg"
	strings:
		$1 = { 55 8B EC 83 EC 2C 56 C7 45 E8 00 00 00 00 C7 45 F4 00 00 00 00 33 C0 83 7D 0C 00 0F 95 C0 89 45 E4 83 7D E4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 50 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E4 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 50 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 F1 03 00 00 8B 55 0C 0F B7 02 F7 D8 1B C0 F7 D8 89 45 E0 75 1E 68 ?? ?? ?? ?? 6A 00 6A 51 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 51 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 8E 03 00 00 33 D2 83 7D 10 00 0F 95 C2 89 55 DC 83 7D DC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 52 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D DC 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 52 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 2A 03 00 00 8B 4D 10 33 D2 83 39 00 0F 95 C2 89 55 D8 83 7D D8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 53 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D8 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 53 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 C4 02 00 00 8B 4D 10 8B 11 0F B7 02 F7 D8 1B C0 F7 D8 89 45 D4 75 1E 68 ?? ?? ?? ?? 6A 00 6A 54 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D4 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 54 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 5F 02 00 00 E8 ?? ?? ?? ?? 8B 10 89 55 F0 E8 ?? ?? ?? ?? C7 00 00 00 00 00 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 F8 83 7D F8 FF 0F 85 83 00 00 00 E8 ?? ?? ?? ?? 83 38 02 75 79 6A 2F 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 67 6A 00 6A 65 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 16 6A 16 6A 65 68 ?? ?? ?? ?? 6A 02 68 ?? ?? ?? ?? 6A 00 8D 55 E8 52 E8 ?? ?? ?? ?? 83 C4 18 50 E8 ?? ?? ?? ?? 83 C4 20 85 C0 75 27 83 7D E8 00 74 21 6A 69 68 ?? ?? ?? ?? 6A 02 6A 02 68 04 01 00 00 E8 ?? ?? ?? ?? 83 C4 14 89 45 F4 83 7D F4 00 75 05 E9 5E 01 00 00 8B 45 E8 89 45 FC 68 03 01 00 00 8B 4D F4 51 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 0C 89 45 FC 83 7D FC 00 0F 84 36 01 00 00 8B 45 F4 0F B7 08 85 C9 0F 84 28 01 00 00 8B 55 F4 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D F4 8D 54 41 FE 89 55 EC 8B 45 EC 0F B7 08 83 F9 5C 74 40 8B 55 EC 0F B7 02 83 F8 2F 74 35 6A 00 68 8D 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 04 01 00 00 8B 4D F4 51 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 55 F4 52 E8 ?? ?? ?? ?? 83 C4 04 8B F0 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 04 03 F0 81 FE 04 01 00 00 73 36 6A 00 68 94 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 4D 0C 51 68 04 01 00 00 8B 55 F4 52 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 EB 02 EB 6B E8 ?? ?? ?? ?? C7 00 00 00 00 00 8B 45 14 50 8B 4D 10 51 8B 55 F4 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 F8 83 7D F8 FF 75 38 E8 ?? ?? ?? ?? 83 38 02 74 30 8B 4D F4 0F B7 11 83 FA 5C 74 0B 8B 45 F4 0F B7 08 83 F9 2F 75 18 8B 55 F4 0F B7 42 02 83 F8 5C 74 0E 8B 4D F4 0F B7 51 02 83 FA 2F 74 02 EB 05 E9 A8 FE FF FF E8 ?? ?? ?? ?? 83 38 00 75 0A E8 ?? ?? ?? ?? 8B 4D F0 89 08 83 7D F4 00 74 0E 6A 02 8B 55 F4 52 E8 ?? ?? ?? ?? 83 C4 08 83 7D E8 00 74 0E 6A 02 8B 45 E8 50 E8 ?? ?? ?? ?? 83 C4 08 8B 45 F8 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_237_0_0 {
	meta:
		name = "__EH_prolog3_align"
		size = 98
		refs = "003f ___security_cookie"
	strings:
		$1 = { 51 8B 4C 24 0C 89 5C 24 0C 8D 5C 24 0C 50 8D 44 24 08 F7 D9 23 C1 8D 60 F8 8B 43 F0 89 04 24 8B 43 F8 50 8B 43 FC 8B 4B F4 89 6C 24 0C 8D 6C 24 0C C7 44 24 08 FF FF FF FF 53 2B E0 56 57 A1 ?? ?? ?? ?? 33 C5 50 8B 43 04 89 45 04 FF 75 F4 64 A1 00 00 00 00 89 45 F4 8D 45 F4 64 A3 00 00 00 00 C3 }
	condition:
		$1
}

rule file_237_1_0 {
	meta:
		name = "__EH_prolog3_catch_align"
		size = 102
		refs = "0040 ___security_cookie"
	strings:
		$1 = { 51 8B 4C 24 0C 89 5C 24 0C 8D 5C 24 0C 50 8D 44 24 08 F7 D9 23 C1 8D 60 F8 8B 43 F0 89 04 24 8B 43 F8 50 8B 43 FC 8B 4B F4 89 6C 24 0C 8D 6C 24 0C C7 44 24 08 FF FF FF FF 51 53 2B E0 56 57 A1 ?? ?? ?? ?? 33 C5 50 89 65 F0 8B 43 04 89 45 04 FF 75 F4 64 A1 00 00 00 00 89 45 F4 8D 45 F4 64 A3 00 00 00 00 C3 }
	condition:
		$1
}

rule file_237_2_0 {
	meta:
		name = "__EH_prolog3_GS_align"
		size = 109
		refs = "0041 ___security_cookie"
	strings:
		$1 = { 51 8B 4C 24 0C 89 5C 24 0C 8D 5C 24 0C 50 8D 44 24 08 F7 D9 23 C1 8D 60 F8 8B 43 F0 89 04 24 8B 43 F8 50 8B 43 F4 50 8B 43 FC 89 6C 24 10 8D 6C 24 10 C7 44 24 0C FF FF FF FF 23 CC 2B E0 56 57 A1 ?? ?? ?? ?? 33 C5 50 89 41 FC 8B 4D F0 89 5D F0 8B 43 04 89 45 04 FF 75 F4 64 A1 00 00 00 00 89 45 F4 8D 45 F4 64 A3 00 00 00 00 C3 }
	condition:
		$1
}

rule file_237_3_0 {
	meta:
		name = "__EH_prolog3_catch_GS_align"
		size = 110
		refs = "0042 ___security_cookie"
	strings:
		$1 = { 51 8B 4C 24 0C 89 5C 24 0C 8D 5C 24 0C 50 8D 44 24 08 F7 D9 23 C1 8D 60 F8 8B 43 F0 89 04 24 8B 43 F8 50 8B 43 F4 50 8B 43 FC 89 6C 24 10 8D 6C 24 10 C7 44 24 0C FF FF FF FF 53 23 CC 2B E0 56 57 A1 ?? ?? ?? ?? 33 C5 50 89 41 FC 8B 4D F0 89 65 F0 8B 43 04 89 45 04 FF 75 F4 64 A1 00 00 00 00 89 45 F4 8D 45 F4 64 A3 00 00 00 00 C3 }
	condition:
		$1
}

rule file_237_4_0 {
	meta:
		name = "__EH_epilog3_align"
		size = 22
	strings:
		$1 = { 8B 4D F4 64 89 0D 00 00 00 00 59 5F 5F 5E 8B E5 5D 8B E3 5B 51 C3 }
	condition:
		$1
}

rule file_238_0_0 {
	meta:
		name = "?_open@@YAHPBDHH@Z"
		size = 65
		refs = "001b __sopen_helper"
	strings:
		$1 = { 55 8B EC 83 EC 0C 6A 00 8D 45 FC 50 8B 4D 10 51 6A 40 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 18 89 45 F8 83 7D F8 00 74 09 C7 45 F4 FF FF FF FF EB 06 8B 4D FC 89 4D F4 8B 45 F4 8B E5 5D C3 }
	condition:
		$1
}

rule file_238_2_0 {
	meta:
		name = "?_wopen@@YAHPB_WHH@Z"
		size = 65
		refs = "001b __wsopen_helper"
	strings:
		$1 = { 55 8B EC 83 EC 0C 6A 00 8D 45 FC 50 8B 4D 10 51 6A 40 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 18 89 45 F8 83 7D F8 00 74 09 C7 45 F4 FF FF FF FF EB 06 8B 4D FC 89 4D F4 8B 45 F4 8B E5 5D C3 }
	condition:
		$1
}

rule file_238_1_0 {
	meta:
		name = "?_sopen@@YAHPBDHHH@Z"
		size = 67
		refs = "001d __sopen_helper"
	strings:
		$1 = { 55 8B EC 83 EC 0C 6A 00 8D 45 FC 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 18 89 45 F8 83 7D F8 00 74 09 C7 45 F4 FF FF FF FF EB 06 8B 55 FC 89 55 F4 8B 45 F4 8B E5 5D C3 }
	condition:
		$1
}

rule file_238_3_0 {
	meta:
		name = "?_wsopen@@YAHPB_WHHH@Z"
		size = 67
		refs = "001d __wsopen_helper"
	strings:
		$1 = { 55 8B EC 83 EC 0C 6A 00 8D 45 FC 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 18 89 45 F8 83 7D F8 00 74 09 C7 45 F4 FF FF FF FF EB 06 8B 55 FC 89 55 F4 8B 45 F4 8B E5 5D C3 }
	condition:
		$1
}

rule file_241_0_0 {
	meta:
		name = "_vwprintf_helper"
		size = 279
		refs = "0006 __sehtable$_vwprintf_helper 000b __except_handler4 001d ___security_cookie 0031 ___iob_func 004e ??_C@_1CC@MGIEJOME@?$AA?$CI?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0057 ??_C@_1BG@GPNCGPEJ@?$AAv?$AAw?$AAp?$AAr?$AAi?$AAn?$AAt?$AAf?$AA?4?$AAc?$AA?$AA@ 005e __CrtDbgReportW 0072 __errno 0086 ??_C@_1CA@KIPAKOJP@?$AAv?$AAw?$AAp?$AAr?$AAi?$AAn?$AAt?$AAf?$AA_?$AAh?$AAe?$AAl?$AAp?$AAe?$AAr?$AA?$AA@ 0090 __invalid_parameter 00a1 __lock_file 00b4 __stbuf 00e0 __ftbuf 00fa __unlock_file"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 E8 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 E8 ?? ?? ?? ?? 83 C0 20 89 45 E4 33 C0 83 7D 0C 00 0F 95 C0 89 45 D8 83 7D D8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 36 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D8 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 36 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 69 8B 55 E4 52 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 45 E4 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 DC 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D E4 51 FF 55 08 83 C4 10 89 45 E0 8B 55 E4 52 8B 45 DC 50 E8 ?? ?? ?? ?? 83 C4 08 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0D 8B 4D E4 51 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 E0 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_242_0_0 {
	meta:
		name = "_asctime_s"
		size = 1799
		refs = "0035 ??_C@_1FE@OLMHKOHB@?$AA?$CI?$AA?5?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?5?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAC?$AAh@ 003e ??_C@_1BE@GHDBKIAF@?$AAa?$AAs?$AAc?$AAt?$AAi?$AAm?$AAe?$AA?4?$AAc?$AA?$AA@ 0045 __CrtDbgReportW 0059 __errno 006d ??_C@_1BE@PHFGCBPO@?$AAa?$AAs?$AAc?$AAt?$AAi?$AAm?$AAe?$AA_?$AAs?$AA?$AA@ 0077 __invalid_parameter 00ab ___crtDebugFillThreshold 00d6 _memset 00ec ??_C@_1DO@KHFIKBMC@?$AA?$CI?$AA?5?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAC?$AAh?$AAa?$AAr?$AAs?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA_?$AAA?$AAS?$AAC?$AAB?$AAU?$AAF?$AAS?$AAI?$AAZ?$AAE?$AA?5?$AA?$CJ?$AA?$AA@ 0152 ??_C@_1BO@LELPCFEI@?$AA?$CI?$AA?5?$AAt?$AAb?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CJ?$AA?$AA@ 01bb ??_C@_1CK@OLADCBAN@?$AA?$CI?$AA?5?$AAt?$AAb?$AA?9?$AA?$DO?$AAt?$AAm?$AA_?$AAy?$AAe?$AAa?$AAr?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CJ?$AA?$AA@ 023d ??_C@_1GA@EELGCBPJ@?$AA?$CI?$AA?5?$AA?$CI?$AA?5?$AAt?$AAb?$AA?9?$AA?$DO?$AAt?$AAm?$AA_?$AAm?$AAo?$AAn?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?5?$AAt?$AAb?$AA?9?$AA?$DO?$AAt@ 02bf ??_C@_1GE@DHFMDLMH@?$AA?$CI?$AA?5?$AA?$CI?$AA?5?$AAt?$AAb?$AA?9?$AA?$DO?$AAt?$AAm?$AA_?$AAh?$AAo?$AAu?$AAr?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?5?$AAt?$AAb?$AA?9?$AA?$DO@ 0341 ??_C@_1GA@DGBBOAFH@?$AA?$CI?$AA?5?$AA?$CI?$AA?5?$AAt?$AAb?$AA?9?$AA?$DO?$AAt?$AAm?$AA_?$AAm?$AAi?$AAn?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?5?$AAt?$AAb?$AA?9?$AA?$DO?$AAt@ 03c1 ??_C@_1GA@ECKOAPBB@?$AA?$CI?$AA?5?$AA?$CI?$AA?5?$AAt?$AAb?$AA?9?$AA?$DO?$AAt?$AAm?$AA_?$AAs?$AAe?$AAc?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?5?$AAt?$AAb?$AA?9?$AA?$DO?$AAt@ 0430 __days 04bd ??_C@_1BIG@LPOPKOEL@?$AA?$CI?$AA?5?$AA?$CI?$AA?5?$AAt?$AAb?$AA?9?$AA?$DO?$AAt?$AAm?$AA_?$AAm?$AAd?$AAa?$AAy?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA1?$AA?5?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?5?$AA?$CI?$AA?5?$AA?$CI?$AA?5@ 0545 ??_C@_1GC@LDILJKOA@?$AA?$CI?$AA?5?$AA?$CI?$AA?5?$AAt?$AAb?$AA?9?$AA?$DO?$AAt?$AAm?$AA_?$AAw?$AAd?$AAa?$AAy?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?5?$AAt?$AAb?$AA?9?$AA?$DO@ 05e2 ___dnames 05f3 ___mnames 0626 _store_dt"
	strings:
		$1 = { 55 8B EC 83 EC 58 8B 45 08 89 45 F8 83 7D 08 00 74 0F 83 7D 0C 00 76 09 C7 45 C4 01 00 00 00 EB 07 C7 45 C4 00 00 00 00 8B 4D C4 89 4D EC 83 7D EC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 4F 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D EC 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 4F 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 7B 06 00 00 8B 45 08 C6 00 00 83 7D 0C FF 74 49 81 7D 0C FF FF FF 7F 74 40 83 7D 0C 01 76 3A 8B 4D 0C 83 E9 01 39 0D ?? ?? ?? ?? 73 0B 8B 15 ?? ?? ?? ?? 89 55 C0 EB 09 8B 45 0C 83 E8 01 89 45 C0 8B 4D C0 51 68 FD 00 00 00 8B 55 08 83 C2 01 52 E8 ?? ?? ?? ?? 83 C4 0C 83 7D 0C 1A 1B C0 83 C0 01 89 45 E8 75 1E 68 ?? ?? ?? ?? 6A 00 6A 56 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E8 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 56 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 C4 05 00 00 33 D2 83 7D 10 00 0F 95 C2 89 55 E4 83 7D E4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 5A 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E4 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 5A 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 5E 05 00 00 8B 4D 10 33 D2 83 79 14 00 0F 9D C2 89 55 E0 83 7D E0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 5E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 5E 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 F5 04 00 00 8B 4D 10 83 79 10 00 7C 12 8B 55 10 83 7A 10 0B 7F 09 C7 45 BC 01 00 00 00 EB 07 C7 45 BC 00 00 00 00 8B 45 BC 89 45 DC 83 7D DC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 63 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D DC 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 63 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 73 04 00 00 8B 55 10 83 7A 08 00 7C 12 8B 45 10 83 78 08 17 7F 09 C7 45 B8 01 00 00 00 EB 07 C7 45 B8 00 00 00 00 8B 4D B8 89 4D D8 83 7D D8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 68 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D8 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 68 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 F1 03 00 00 8B 45 10 83 78 04 00 7C 12 8B 4D 10 83 79 04 3B 7F 09 C7 45 B4 01 00 00 00 EB 07 C7 45 B4 00 00 00 00 8B 55 B4 89 55 D4 83 7D D4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 6C 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D4 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 6C 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 6F 03 00 00 8B 4D 10 83 39 00 7C 11 8B 55 10 83 3A 3B 7F 09 C7 45 B0 01 00 00 00 EB 07 C7 45 B0 00 00 00 00 8B 45 B0 89 45 D0 83 7D D0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 70 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D0 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 70 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 EF 02 00 00 8B 55 10 83 7A 0C 01 0F 8C 88 00 00 00 8B 45 10 8B 48 10 8B 55 10 8B 42 10 8B 0C 8D ?? ?? ?? ?? 2B 0C 85 ?? ?? ?? ?? 8B 55 10 3B 4A 0C 7D 5D 8B 45 10 8B 48 14 81 C1 6C 07 00 00 81 E1 03 00 00 80 79 05 49 83 C9 FC 41 85 C9 75 17 8B 55 10 8B 42 14 05 6C 07 00 00 99 B9 64 00 00 00 F7 F9 85 D2 75 17 8B 55 10 8B 42 14 05 6C 07 00 00 99 B9 90 01 00 00 F7 F9 85 D2 75 1B 8B 55 10 83 7A 10 01 75 12 8B 45 10 83 78 0C 1D 7F 09 C7 45 AC 01 00 00 00 EB 07 C7 45 AC 00 00 00 00 8B 4D AC 89 4D CC 83 7D CC 00 75 21 68 ?? ?? ?? ?? 6A 00 68 82 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D CC 00 75 33 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 82 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 ED 01 00 00 8B 45 10 83 78 18 00 7C 12 8B 4D 10 83 79 18 06 7F 09 C7 45 A8 01 00 00 00 EB 07 C7 45 A8 00 00 00 00 8B 55 A8 89 55 C8 83 7D C8 00 75 21 68 ?? ?? ?? ?? 6A 00 68 87 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D C8 00 75 33 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 87 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 65 01 00 00 8B 4D 10 8B 51 18 6B D2 03 89 55 FC 8B 45 10 8B 48 10 6B C9 03 89 4D F0 C7 45 F4 00 00 00 00 EB 12 8B 55 F4 83 C2 01 89 55 F4 8B 45 F8 83 C0 01 89 45 F8 83 7D F4 03 7D 25 8B 4D FC 03 4D F4 8B 55 F8 8A 81 ?? ?? ?? ?? 88 02 8B 4D F0 03 4D F4 8B 55 F8 8A 81 ?? ?? ?? ?? 88 42 04 EB C3 8B 4D F8 C6 01 20 8B 55 F8 83 C2 04 89 55 F8 8B 45 F8 C6 00 20 8B 4D F8 83 C1 01 89 4D F8 8B 55 10 8B 42 0C 50 8B 4D F8 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 F8 8B 55 F8 C6 02 20 8B 45 F8 83 C0 01 89 45 F8 8B 4D 10 8B 51 08 52 8B 45 F8 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 F8 8B 4D F8 C6 01 3A 8B 55 F8 83 C2 01 89 55 F8 8B 45 10 8B 48 04 51 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 F8 8B 45 F8 C6 00 3A 8B 4D F8 83 C1 01 89 4D F8 8B 55 10 8B 02 50 8B 4D F8 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 F8 8B 55 F8 C6 02 20 8B 45 F8 83 C0 01 89 45 F8 8B 4D 10 8B 41 14 99 B9 64 00 00 00 F7 F9 83 C0 13 50 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 F8 8B 45 10 8B 40 14 99 B9 64 00 00 00 F7 F9 52 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 F8 8B 45 F8 C6 00 0A 8B 4D F8 83 C1 01 89 4D F8 8B 55 F8 C6 02 00 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_242_1_0 {
	meta:
		name = "_store_dt"
		size = 64
	strings:
		$1 = { 55 8B EC 8B 45 0C 99 B9 0A 00 00 00 F7 F9 83 C0 30 8B 55 08 88 02 8B 45 08 83 C0 01 89 45 08 8B 45 0C 99 B9 0A 00 00 00 F7 F9 83 C2 30 8B 45 08 88 10 8B 4D 08 83 C1 01 89 4D 08 8B 45 08 5D C3 }
	condition:
		$1
}

rule file_242_2_0 {
	meta:
		name = "_asctime"
		size = 135
		refs = "0009 _buf 0015 __getptd_noexit 0031 ??_C@_09JDJPONGG@asctime?4c?$AA@ 003c __calloc_dbg 006c _asctime_s"
	strings:
		$1 = { 55 8B EC 83 EC 10 C7 45 FC ?? ?? ?? ?? C7 45 F0 00 00 00 00 E8 ?? ?? ?? ?? 89 45 F4 83 7D F4 00 74 39 8B 45 F4 83 78 3C 00 75 27 68 CD 00 00 00 68 ?? ?? ?? ?? 6A 02 6A 01 6A 1A E8 ?? ?? ?? ?? 83 C4 14 8B 4D F4 89 41 3C 8B 55 F4 83 7A 3C 00 74 09 8B 45 F4 8B 48 3C 89 4D FC 8B 55 FC 89 55 F8 8B 45 08 50 6A 1A 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F0 83 7D F0 00 74 04 33 C0 EB 03 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_243_0_0 {
	meta:
		name = "_wcscat"
		size = 80
	strings:
		$1 = { 55 8B EC 51 8B 45 08 89 45 FC 8B 4D FC 0F B7 11 85 D2 74 0B 8B 45 FC 83 C0 02 89 45 FC EB EB 8B 4D FC 8B 55 0C 66 8B 02 66 89 01 8B 4D FC 0F B7 11 8B 45 FC 83 C0 02 89 45 FC 8B 4D 0C 83 C1 02 89 4D 0C 85 D2 74 02 EB D6 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_243_1_0 {
	meta:
		name = "_wcscpy"
		size = 59
	strings:
		$1 = { 55 8B EC 51 8B 45 08 89 45 FC 8B 4D FC 8B 55 0C 66 8B 02 66 89 01 8B 4D FC 0F B7 11 8B 45 FC 83 C0 02 89 45 FC 8B 4D 0C 83 C1 02 89 4D 0C 85 D2 74 02 EB D6 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_244_0_0 {
	meta:
		name = "__CIsqrt"
		size = 186
		refs = "0007 __checkTOS_withFB 0019 __fload_withFB 0031 __load_CW 0040 ___fastflag 0047 __fast_exit 0052 _NAME_ 0057 __math_exit 0073 __convertTOStoQNaN 0092 __indefinite 00b4 __startOneArgErrorHandling"
	strings:
		$1 = { 83 EC 0C DD 14 24 E8 ?? ?? ?? ?? E8 0D 00 00 00 83 C4 0C C3 8D 54 24 04 E8 ?? ?? ?? ?? 52 9B D9 3C 24 8B 44 24 0C 74 51 66 81 3C 24 7F 02 74 05 E8 ?? ?? ?? ?? A9 00 00 00 80 75 1F D9 FA 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 05 00 00 00 8D 0D ?? ?? ?? ?? E9 ?? ?? ?? ?? A9 00 00 F0 7F 75 2C A9 FF FF 0F 00 75 25 83 7C 24 08 00 75 1E EB CC E8 ?? ?? ?? ?? EB 22 A9 FF FF 0F 00 75 F2 83 7C 24 08 00 75 EB 25 00 00 00 80 74 B0 DD D8 DB 2D ?? ?? ?? ?? B8 01 00 00 00 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 05 00 00 00 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule file_246_0_0 {
	meta:
		name = "_XMMI2_FP_Emulation"
		size = 12164
		refs = "001d ___security_cookie 00a2 $LN337 00a9 $LN344 00e3 _isdenormald 0151 $LN345 01d4 $LN346 020e __control87 023d $LN347 02b0 __statusfp 02e2 _Fill_FPIEEE_RECORD 0335 _isnand 039e _quietd 05db _MIN_DOUBLE_NORMALA 05e4 _memcpy 05ee _MAX_DOUBLE_NORMALA 0601 _POSINFDEA 0614 _NEGINFDEA 062a _TWO_TO_1536A 0640 _TWO_TO_M1536A 093d $LN348 0a8a _ZERODA 0aa1 _NZERODA 0d57 $LN338 0d5e $LN349 0d6b _issnand 0ea6 $LN339 0ead $LN350 103f $LN340 1046 $LN351 10a4 $LN341 10ab $LN352 1106 $LN342 110d $LN353 15ec $LN354 17d5 _isdenormalf 189f $LN355 1b45 $LN343 1b4c $LN356 1bd1 $LN357 1e73 $LN358 208f $LN359 21a4 _isinfd 21b8 _iszerod 229a _MIN_SINGLE_NORMALA 22c9 _MAX_SINGLE_NORMALA 24d0 __real@0000000000000000 24dd _ZEROFA 24fe _NZEROFA 27af $LN360 2b98 $LN361 2e03 @__security_check_cookie@4 2e10 $LN332 2e14 $LN21 2e18 $LN55 2e1c $LN257 2e20 $LN206 2e24 $LN138 2e28 $LN112 2e2c $LN97 2e30 $LN175 2e34 $LN164 2e58 $LN326 2e60 $LN325 2e68 $LN324 2e70 $LN323 2e78 $LN319 2e7c $LN318 2e80 $LN317 2e84 $LN316 2e88 $LN312 2e8c $LN311 2e90 $LN310 2e94 $LN309 2e98 $LN283 2e9c $LN282 2ea0 $LN281 2ea4 $LN280 2ea8 $LN251 2eac $LN246 2eb8 $LN236 2ebc $LN235 2ec8 $LN223 2ecc $LN224 2ed8 $LN216 2edc $LN217 2ee8 $LN210 2eec $LN209 2ef8 $LN172 2efc $LN171 2f00 $LN170 2f04 $LN169 2f08 $LN151 2f0c $LN150 2f10 $LN149 2f14 $LN148 2f18 $LN133 2f1c $LN132 2f20 $LN131 2f34 $LN125 2f38 $LN124 2f3c $LN123 2f40 $LN122 2f44 $LN107 2f48 $LN106 2f4c $LN105 2f50 $LN104 2f54 $LN92 2f58 $LN91 2f5c $LN90 2f60 $LN89 2f64 $LN49 2f6c $LN48 2f74 $LN16 2f78 $LN15 2f7c $LN14 2f80 $LN13"
	strings:
		$1 = { 53 8B DC 83 EC 08 83 E4 F8 83 C4 04 55 8B 6B 04 89 6C 24 04 8B EC 81 EC 30 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC DB E3 C7 45 F8 00 00 00 00 C7 45 F4 00 00 00 00 8B 43 08 8B 48 20 8B 53 08 8B 42 10 83 E0 03 8B 09 83 E1 FC 0B C8 8B 53 08 8B 42 20 89 08 8B 4B 08 8B 51 20 8B 43 08 8B 48 14 83 E1 07 C1 E1 02 8B 12 83 E2 E3 0B D1 8B 43 08 8B 48 20 89 11 8B 53 08 8B 42 20 8B 08 C1 E9 05 81 E1 FF 0F 00 00 89 4D F0 8B 55 F0 83 EA 46 89 55 F0 83 7D F0 1E 0F 87 61 2D 00 00 8B 45 F0 0F B6 88 ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? 8B 53 08 8B 42 20 8B 48 10 8B 50 14 89 4D E8 89 55 EC 8B 43 08 8B 48 20 8B 51 30 8B 41 34 89 55 E0 89 45 E4 8B 4B 08 83 79 0C 00 74 4E 8B 55 EC 52 8B 45 E8 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 13 8B 4D EC 81 E1 00 00 00 80 89 4D EC C7 45 E8 00 00 00 00 8B 55 E4 52 8B 45 E0 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 13 8B 4D E4 81 E1 00 00 00 80 89 4D E4 C7 45 E0 00 00 00 00 8B 53 08 8B 42 20 8B 08 C1 E9 05 81 E1 FF 0F 00 00 89 4D DC 8B 55 DC 83 EA 46 89 55 DC 83 7D DC 07 77 74 8B 45 DC FF 24 85 ?? ?? ?? ?? 8B 4B 08 8B 51 20 8B 02 25 1F 00 FE FF 83 C8 20 8B 4B 08 8B 51 20 89 02 EB 50 8B 43 08 8B 48 20 8B 11 81 E2 1F 00 FE FF 83 CA 40 8B 43 08 8B 48 20 89 11 EB 35 8B 53 08 8B 42 20 8B 08 81 E1 1F 00 FE FF 83 C9 60 8B 53 08 8B 42 20 89 08 EB 1A 8B 4B 08 8B 51 20 8B 02 25 1F 00 FE FF 0D 80 00 00 00 8B 4B 08 8B 51 20 89 02 8B 43 08 8B 48 10 89 4D D8 83 7D D8 03 77 2C 8B 55 D8 FF 24 95 ?? ?? ?? ?? C7 45 D4 00 00 00 00 EB 19 C7 45 D4 00 01 00 00 EB 10 C7 45 D4 00 02 00 00 EB 07 C7 45 D4 00 03 00 00 68 1F 03 0B 00 8B 45 D4 0D 00 00 01 00 0D 1F 00 08 00 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4B 08 8B 51 20 8B 02 C1 E8 05 25 FF 0F 00 00 89 45 D0 8B 4D D0 83 E9 01 89 4D D0 83 7D D0 03 77 78 8B 55 D0 FF 24 95 ?? ?? ?? ?? DB E2 DD 45 E8 DD 45 E0 DE C1 DD 5D C8 DB E2 DD 45 E8 DD 45 E0 DE C1 DB 7D BC EB 52 DB E2 DD 45 E8 DD 45 E0 DE E9 DD 5D C8 DB E2 DD 45 E8 DD 45 E0 DE E9 DB 7D BC EB 36 DB E2 DD 45 E8 DD 45 E0 DE C9 DD 5D C8 DB E2 DD 45 E8 DD 45 E0 DE C9 DB 7D BC EB 1A DB E2 DD 45 E8 DD 45 E0 DE F9 DD 5D C8 DB E2 DD 45 E8 DD 45 E0 DE F9 DB 7D BC E8 ?? ?? ?? ?? 89 45 B8 8B 45 B8 83 E0 08 74 0C 8B 4D B8 81 E1 FF FF F7 FF 89 4D B8 8B 53 08 8B 02 83 E0 01 75 57 8B 4D B8 83 E1 10 74 4F 8B 53 08 52 E8 ?? ?? ?? ?? 83 C4 04 8B 43 08 8B 48 20 8B 51 0C 83 CA 10 8B 43 08 8B 48 20 89 51 0C 8B 53 08 8B 42 04 83 C8 01 8B 4B 08 89 41 04 8B 53 08 8B 42 20 8B 48 04 83 C9 10 8B 53 08 8B 42 20 89 48 04 B8 01 00 00 00 E9 D1 2A 00 00 8B 4D EC 51 8B 55 E8 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 18 8B 45 E4 50 8B 4D E0 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 0F 84 02 01 00 00 8B 53 08 8B 42 20 8B 48 60 83 C9 01 8B 53 08 8B 42 20 89 48 60 8B 4D EC 51 8B 55 E8 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 2F 8B 45 E4 50 8B 4D E0 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 1B 8B 55 EC 52 8B 45 E8 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4B 08 8B 51 20 DD 5A 50 EB 0C 8B 43 08 8B 48 20 DD 45 C8 DD 59 50 8B 53 08 8B 42 20 8B 48 0C 83 E1 FD 8B 53 08 8B 42 20 89 48 0C 8B 4B 08 8B 51 20 8B 42 0C 83 E0 FB 8B 4B 08 8B 51 20 89 42 0C 8B 43 08 8B 48 20 8B 51 0C 83 E2 FE 8B 43 08 8B 48 20 89 51 0C 8B 53 08 8B 42 20 8B 48 0C 83 E1 F7 8B 53 08 8B 42 20 89 48 0C 8B 4D B8 83 E1 10 74 26 8B 53 08 8B 42 20 8B 48 0C 83 C9 10 8B 53 08 8B 42 20 89 48 0C 8B 4B 08 8B 51 04 83 CA 01 8B 43 08 89 50 04 EB 15 8B 4B 08 8B 51 20 8B 42 0C 83 E0 EF 8B 4B 08 8B 51 20 89 42 0C 33 C0 E9 A3 29 00 00 8B 43 08 8B 08 83 E1 02 75 30 8B 55 B8 81 E2 00 00 08 00 74 25 8B 43 08 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4B 08 8B 51 04 83 CA 02 8B 43 08 89 50 04 B8 01 00 00 00 E9 69 29 00 00 8B 4B 08 8B 11 83 E2 04 75 57 8B 45 B8 83 E0 08 74 4F 8B 4B 08 51 E8 ?? ?? ?? ?? 83 C4 04 8B 53 08 8B 42 20 8B 48 0C 83 C9 08 8B 53 08 8B 42 20 89 48 0C 8B 4B 08 8B 51 04 83 CA 04 8B 43 08 89 50 04 8B 4B 08 8B 51 20 8B 42 04 83 C8 08 8B 4B 08 8B 51 20 89 42 04 B8 01 00 00 00 E9 08 29 00 00 DD 45 C8 DD 5D B0 8B 45 B0 89 45 A8 8B 4D B4 89 4D AC 8B 55 AC 52 8B 45 A8 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 0F 84 A0 00 00 00 8B 4B 08 8B 51 20 8B 42 60 83 C8 01 8B 4B 08 8B 51 20 89 42 60 8B 43 08 8B 48 20 DD 45 B0 DD 59 50 8B 53 08 8B 42 20 8B 48 0C 83 E1 FD 8B 53 08 8B 42 20 89 48 0C 8B 4B 08 8B 51 20 8B 42 0C 83 E0 FB 8B 4B 08 8B 51 20 89 42 0C 8B 43 08 8B 48 20 8B 51 0C 83 E2 FE 8B 43 08 8B 48 20 89 51 0C 8B 53 08 8B 42 20 8B 48 0C 83 E1 F7 8B 53 08 8B 42 20 89 48 0C 8B 4B 08 8B 51 20 8B 42 0C 83 C8 10 8B 4B 08 8B 51 20 89 42 0C 8B 43 08 8B 48 04 83 C9 01 8B 53 08 89 4A 04 33 C0 E9 3E 28 00 00 8B 45 B8 25 00 00 08 00 74 0F 8B 4B 08 8B 51 04 83 CA 02 8B 43 08 89 50 04 6A 0A 68 ?? ?? ?? ?? 8D 4D 9C 51 E8 ?? ?? ?? ?? 83 C4 0C 6A 0A 68 ?? ?? ?? ?? 8D 55 90 52 E8 ?? ?? ?? ?? 83 C4 0C 6A 0A 68 ?? ?? ?? ?? 8D 45 84 50 E8 ?? ?? ?? ?? 83 C4 0C 6A 0A 68 ?? ?? ?? ?? 8D 8D 78 FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 6A 0A 68 ?? ?? ?? ?? 8D 95 6C FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 6A 0A 68 ?? ?? ?? ?? 8D 85 60 FF FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C DB 6D BC DB 6D 9C D9 E0 DE D9 9B DD BD 5C FF FF FF D9 EE DB 6D BC DE D9 9B DD BD 58 FF FF FF DB 6D BC D9 EE DE D9 9B DD BD 54 FF FF FF DB 6D 9C DB 6D BC DE D9 9B DD BD 50 FF FF FF 0F B7 8D 5C FF FF FF 81 E1 00 45 00 00 81 F9 00 01 00 00 75 15 0F B7 95 58 FF FF FF 81 E2 00 45 00 00 81 FA 00 01 00 00 74 28 0F B7 85 54 FF FF FF 25 00 45 00 00 3D 00 01 00 00 75 1C 0F B7 8D 50 FF FF FF 81 E1 00 45 00 00 81 F9 00 01 00 00 75 07 C7 45 F8 01 00 00 00 DB 6D BC DB AD 78 FF FF FF DE D9 9B DD BD 5C FF FF FF DB 6D 90 D9 E0 DB 6D BC DE D9 9B DD BD 58 FF FF FF DB 6D BC DB 6D 90 DE D9 9B DD BD 54 FF FF FF DB 6D 84 DB 6D BC DE D9 9B DD BD 50 FF FF FF 0F B7 95 5C FF FF FF 81 E2 00 45 00 00 81 FA 00 01 00 00 75 13 0F B7 85 58 FF FF FF 25 00 45 00 00 3D 00 01 00 00 74 2A 0F B7 8D 54 FF FF FF 81 E1 00 45 00 00 81 F9 00 01 00 00 75 1C 0F B7 95 50 FF FF FF 81 E2 00 45 00 00 81 FA 00 01 00 00 75 07 C7 45 F4 01 00 00 00 8B 43 08 8B 08 83 E1 10 0F 85 B4 00 00 00 83 7D F8 00 0F 84 AA 00 00 00 DB 6D BC DB AD 6C FF FF FF DE C9 DD 5D C8 8B 53 08 52 E8 ?? ?? ?? ?? 83 C4 04 8B 43 08 8B 48 20 8B 51 0C 83 CA 02 8B 43 08 8B 48 20 89 51 0C 8B 53 08 8B 42 04 83 C8 10 8B 4B 08 89 41 04 8B 53 08 8B 42 20 8B 48 04 83 C9 02 8B 53 08 8B 42 20 89 48 04 8B 4B 08 8B 51 20 8B 42 60 83 C8 01 8B 4B 08 8B 51 20 89 42 60 8B 43 08 8B 48 20 DD 45 C8 DD 59 50 8B 55 B8 83 E2 01 74 24 8B 43 08 8B 48 20 8B 51 0C 83 CA 01 8B 43 08 8B 48 20 89 51 0C 8B 53 08 8B 42 04 83 C8 20 8B 4B 08 89 41 04 B8 01 00 00 00 E9 B9 25 00 00 8B 53 08 8B 02 83 E0 08 0F 85 B4 00 00 00 83 7D F4 00 0F 84 AA 00 00 00 DB 6D BC DB AD 60 FF FF FF DE C9 DD 5D C8 8B 4B 08 51 E8 ?? ?? ?? ?? 83 C4 04 8B 53 08 8B 42 20 8B 48 0C 83 C9 04 8B 53 08 8B 42 20 89 48 0C 8B 4B 08 8B 51 04 83 CA 08 8B 43 08 89 50 04 8B 4B 08 8B 51 20 8B 42 04 83 C8 04 8B 4B 08 8B 51 20 89 42 04 8B 43 08 8B 48 20 8B 51 60 83 CA 01 8B 43 08 8B 48 20 89 51 60 8B 53 08 8B 42 20 DD 45 C8 DD 58 50 8B 4D B8 83 E1 01 74 24 8B 53 08 8B 42 20 8B 48 0C 83 C9 01 8B 53 08 8B 42 20 89 48 0C 8B 4B 08 8B 51 04 83 CA 20 8B 43 08 89 50 04 B8 01 00 00 00 E9 F7 24 00 00 8B 4B 08 8B 51 20 8B 02 C1 E8 05 25 FF 0F 00 00 89 85 4C FF FF FF 8B 8D 4C FF FF FF 83 E9 01 89 8D 4C FF FF FF 83 BD 4C FF FF FF 03 77 3F 8B 95 4C FF FF FF FF 24 95 ?? ?? ?? ?? DD 45 E8 DD 45 E0 DE C1 DD 5D B0 EB 25 DD 45 E8 DD 45 E0 DE E9 DD 5D B0 EB 18 DD 45 E8 DD 45 E0 DE C9 DD 5D B0 EB 0B DD 45 E8 DD 45 E0 DE F9 DD 5D B0 E8 ?? ?? ?? ?? 89 45 B8 8B 45 B8 83 E0 01 74 0F 83 7D F8 00 74 09 8B 4D B8 83 C9 02 89 4D B8 8B 53 08 8B 02 83 E0 20 0F 85 1E 01 00 00 8B 4D B8 83 E1 01 75 17 8B 53 08 83 7A 08 00 0F 84 09 01 00 00 83 7D F8 00 0F 84 FF 00 00 00 8B 43 08 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4B 08 8B 51 20 8B 42 0C 83 C8 01 8B 4B 08 8B 51 20 89 42 0C 8B 43 08 8B 48 04 83 C9 20 8B 53 08 89 4A 04 8B 43 08 8B 48 20 8B 51 04 83 CA 01 8B 43 08 8B 48 20 89 51 04 8B 53 08 8B 42 20 8B 48 60 83 C9 01 8B 53 08 8B 42 20 89 48 60 83 7D F8 00 74 24 8B 4B 08 8B 51 20 8B 42 0C 83 C8 02 8B 4B 08 8B 51 20 89 42 0C 8B 43 08 8B 48 04 83 C9 10 8B 53 08 89 4A 04 83 7D F4 00 74 24 8B 43 08 8B 48 20 8B 51 0C 83 CA 04 8B 43 08 8B 48 20 89 51 0C 8B 53 08 8B 42 04 83 C8 08 8B 4B 08 89 41 04 8B 53 08 83 7A 08 00 74 32 83 7D F8 00 74 2C D9 EE DC 5D B0 DF E0 F6 C4 05 7A 0B DD 05 ?? ?? ?? ?? DD 5D B0 EB 15 D9 EE DC 5D B0 DF E0 F6 C4 41 75 09 DD 05 ?? ?? ?? ?? DD 5D B0 8B 43 08 8B 48 20 DD 45 B0 DD 59 50 B8 01 00 00 00 E9 3F 23 00 00 8B 53 08 8B 42 20 8B 48 60 83 C9 01 8B 53 08 8B 42 20 89 48 60 8B 4D B8 83 E1 02 74 26 8B 53 08 8B 42 20 8B 48 0C 83 C9 02 8B 53 08 8B 42 20 89 48 0C 8B 4B 08 8B 51 04 83 CA 10 8B 43 08 89 50 04 EB 15 8B 4B 08 8B 51 20 8B 42 0C 83 E0 FD 8B 4B 08 8B 51 20 89 42 0C 8B 45 B8 83 E0 04 74 26 8B 4B 08 8B 51 20 8B 42 0C 83 C8 04 8B 4B 08 8B 51 20 89 42 0C 8B 43 08 8B 48 04 83 C9 08 8B 53 08 89 4A 04 EB 15 8B 43 08 8B 48 20 8B 51 0C 83 E2 FB 8B 43 08 8B 48 20 89 51 0C 8B 55 B8 83 E2 01 74 26 8B 43 08 8B 48 20 8B 51 0C 83 CA 01 8B 43 08 8B 48 20 89 51 0C 8B 53 08 8B 42 04 83 C8 20 8B 4B 08 89 41 04 EB 15 8B 53 08 8B 42 20 8B 48 0C 83 E1 FE 8B 53 08 8B 42 20 89 48 0C 8B 4B 08 83 79 08 00 74 7A 83 7D F8 00 74 74 D9 EE DC 5D B0 DF E0 F6 C4 05 7A 0B DD 05 ?? ?? ?? ?? DD 5D B0 EB 15 D9 EE DC 5D B0 DF E0 F6 C4 41 75 09 DD 05 ?? ?? ?? ?? DD 5D B0 8B 53 08 8B 42 20 8B 48 0C 83 C9 01 8B 53 08 8B 42 20 89 48 0C 8B 4B 08 8B 51 04 83 CA 20 8B 43 08 89 50 04 8B 4B 08 8B 51 20 8B 42 0C 83 C8 02 8B 4B 08 8B 51 20 89 42 0C 8B 43 08 8B 48 04 83 C9 10 8B 53 08 89 4A 04 8B 43 08 8B 48 20 DD 45 B0 DD 59 50 8B 55 B8 83 E2 08 74 26 8B 43 08 8B 48 20 8B 51 0C 83 CA 08 8B 43 08 8B 48 20 89 51 0C 8B 53 08 8B 42 04 83 C8 04 8B 4B 08 89 41 04 EB 15 8B 53 08 8B 42 20 8B 48 0C 83 E1 F7 8B 53 08 8B 42 20 89 48 0C 8B 4B 08 8B 51 20 8B 42 0C 83 E0 EF 8B 4B 08 8B 51 20 89 42 0C 33 C0 E9 73 21 00 00 E9 6E 21 00 00 8B 43 08 8B 48 20 8B 51 10 8B 41 14 89 55 E8 89 45 EC 8B 4B 08 8B 51 20 8B 42 30 8B 4A 34 89 45 E0 89 4D E4 8B 53 08 83 7A 0C 00 74 4E 8B 45 EC 50 8B 4D E8 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 13 8B 55 EC 81 E2 00 00 00 80 89 55 EC C7 45 E8 00 00 00 00 8B 45 E4 50 8B 4D E0 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 13 8B 55 E4 81 E2 00 00 00 80 89 55 E4 C7 45 E0 00 00 00 00 8B 43 08 8B 48 18 83 E1 07 89 8D 48 FF FF FF 8B 53 08 8B 42 20 8B 08 81 E1 1F 00 FE FF 81 C9 E0 00 00 00 8B 53 08 8B 42 20 89 08 8B 8D 48 FF FF FF 89 8D 44 FF FF FF 83 BD 44 FF FF FF 07 0F 87 AC 00 00 00 8B 95 44 FF FF FF 0F B6 82 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 8B 4D EC 51 8B 55 E8 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 14 8B 45 E4 50 8B 4D E0 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 0C C7 85 40 FF FF FF 01 00 00 00 EB 0A C7 85 40 FF FF FF 00 00 00 00 E8 ?? ?? ?? ?? 89 45 B8 8B 55 B8 83 E2 10 74 0A C7 85 40 FF FF FF 01 00 00 00 EB 3E 8B 45 EC 50 8B 4D E8 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 14 8B 55 E4 52 8B 45 E0 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 0C C7 85 40 FF FF FF 01 00 00 00 EB 0A C7 85 40 FF FF FF 00 00 00 00 83 BD 40 FF FF FF 00 74 59 8B 4B 08 8B 11 83 E2 01 75 4F 8B 43 08 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4B 08 8B 51 20 8B 42 0C 83 C8 10 8B 4B 08 8B 51 20 89 42 0C 8B 43 08 8B 48 04 83 C9 01 8B 53 08 89 4A 04 8B 43 08 8B 48 20 8B 51 04 83 CA 10 8B 43 08 8B 48 20 89 51 04 B8 01 00 00 00 E9 A1 1F 00 00 8B 55 EC 52 8B 45 E8 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 18 8B 4D E4 51 8B 55 E0 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 0F 84 16 01 00 00 8B 85 48 FF FF FF 89 85 3C FF FF FF 83 BD 3C FF FF FF 07 77 3E 8B 8D 3C FF FF FF 0F B6 91 ?? ?? ?? ?? FF 24 95 ?? ?? ?? ?? C7 85 30 FF FF FF 00 00 00 00 C7 85 34 FF FF FF 00 00 00 00 EB 14 C7 85 30 FF FF FF FF FF FF FF C7 85 34 FF FF FF FF FF FF FF 8B 43 08 8B 48 20 8B 51 60 83 CA 01 8B 43 08 8B 48 20 89 51 60 8B 53 08 8B 42 20 DD 85 30 FF FF FF DD 58 50 8B 4B 08 8B 51 20 8B 42 0C 83 E0 FE 8B 4B 08 8B 51 20 89 42 0C 8B 43 08 8B 48 20 8B 51 0C 83 E2 FD 8B 43 08 8B 48 20 89 51 0C 8B 53 08 8B 42 20 8B 48 0C 83 E1 FB 8B 53 08 8B 42 20 89 48 0C 8B 4B 08 8B 51 20 8B 42 0C 83 E0 F7 8B 4B 08 8B 51 20 89 42 0C 83 BD 40 FF FF FF 00 74 26 8B 43 08 8B 48 20 8B 51 0C 83 CA 10 8B 43 08 8B 48 20 89 51 0C 8B 53 08 8B 42 04 83 C8 01 8B 4B 08 89 41 04 EB 15 8B 53 08 8B 42 20 8B 48 0C 83 E1 EF 8B 53 08 8B 42 20 89 48 0C 33 C0 E9 5F 1E 00 00 8B 4D EC 51 8B 55 E8 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 14 8B 45 E4 50 8B 4D E0 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 1B C7 85 2C FF FF FF 01 00 00 00 8B 53 08 8B 42 04 83 C8 02 8B 4B 08 89 41 04 EB 0A C7 85 2C FF FF FF 00 00 00 00 83 BD 2C FF FF FF 00 74 20 8B 53 08 8B 02 83 E0 02 75 16 8B 4B }
	condition:
		$1
}

rule file_246_1_0 {
	meta:
		name = "_iszerod"
		size = 32
	strings:
		$1 = { 55 8B EC 8B 45 0C 25 FF FF FF 7F 75 0F 83 7D 08 00 75 09 B8 01 00 00 00 EB 04 EB 02 33 C0 5D C3 }
	condition:
		$1
}

rule file_246_2_0 {
	meta:
		name = "_isinfd"
		size = 37
	strings:
		$1 = { 55 8B EC 8B 45 0C 25 FF FF FF 7F 3D 00 00 F8 7F 75 0F 83 7D 08 00 75 09 B8 01 00 00 00 EB 04 EB 02 33 C0 5D C3 }
	condition:
		$1
}

rule file_246_3_0 {
	meta:
		name = "_issnand"
		size = 48
	strings:
		$1 = { 55 8B EC 8B 45 0C 25 00 00 F8 7F 3D 00 00 F0 7F 75 1A 8B 4D 0C 81 E1 FF FF 07 00 75 06 83 7D 08 00 74 09 B8 01 00 00 00 EB 04 EB 02 33 C0 5D C3 }
	condition:
		$1
}

rule file_246_4_0 {
	meta:
		name = "_isnand"
		size = 48
	strings:
		$1 = { 55 8B EC 8B 45 0C 25 00 00 F0 7F 3D 00 00 F0 7F 75 1A 8B 4D 0C 81 E1 FF FF 0F 00 75 06 83 7D 08 00 74 09 B8 01 00 00 00 EB 04 EB 02 33 C0 5D C3 }
	condition:
		$1
}

rule file_246_5_0 {
	meta:
		name = "_quietd"
		size = 58
	strings:
		$1 = { 53 8B DC 83 EC 08 83 E4 F8 83 C4 04 55 8B 6B 04 89 6C 24 04 8B EC 83 EC 08 8B 43 0C 0D 00 00 08 00 89 43 0C 8B 4B 08 89 4D F8 8B 53 0C 89 55 FC DD 45 F8 8B E5 5D 8B E3 5B C3 }
	condition:
		$1
}

rule file_246_6_0 {
	meta:
		name = "_isdenormald"
		size = 43
	strings:
		$1 = { 55 8B EC 8B 45 0C 25 00 00 F0 7F 75 1A 8B 4D 0C 81 E1 FF FF 0F 00 75 06 83 7D 08 00 74 09 B8 01 00 00 00 EB 04 EB 02 33 C0 5D C3 }
	condition:
		$1
}

rule file_246_7_0 {
	meta:
		name = "_isdenormalf"
		size = 37
	strings:
		$1 = { 55 8B EC 8B 45 08 25 00 00 80 7F 75 14 8B 4D 08 81 E1 FF FF 7F 00 74 09 B8 01 00 00 00 EB 04 EB 02 33 C0 5D C3 }
	condition:
		$1
}

rule file_246_8_0 {
	meta:
		name = "_Fill_FPIEEE_RECORD"
		size = 494
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 48 20 8B 55 08 8B 42 10 83 E0 03 8B 09 83 E1 FC 0B C8 8B 55 08 8B 42 20 89 08 8B 4D 08 8B 51 20 8B 45 08 8B 48 14 83 E1 07 C1 E1 02 8B 12 83 E2 E3 0B D1 8B 45 08 8B 48 20 89 11 8B 55 08 8B 02 83 E0 20 F7 D8 1B C0 83 C0 01 8B 4D 08 8B 51 20 83 E0 01 8B 4A 08 83 E1 FE 0B C8 8B 55 08 8B 42 20 89 48 08 8B 4D 08 8B 11 83 E2 10 F7 DA 1B D2 83 C2 01 8B 45 08 8B 48 20 83 E2 01 D1 E2 8B 41 08 83 E0 FD 0B C2 8B 4D 08 8B 51 20 89 42 08 8B 45 08 8B 08 83 E1 08 F7 D9 1B C9 83 C1 01 8B 55 08 8B 42 20 83 E1 01 C1 E1 02 8B 50 08 83 E2 FB 0B D1 8B 45 08 8B 48 20 89 51 08 8B 55 08 8B 02 83 E0 04 F7 D8 1B C0 83 C0 01 8B 4D 08 8B 51 20 83 E0 01 C1 E0 03 8B 4A 08 83 E1 F7 0B C8 8B 55 08 8B 42 20 89 48 08 8B 4D 08 8B 11 83 E2 01 F7 DA 1B D2 83 C2 01 8B 45 08 8B 48 20 83 E2 01 C1 E2 04 8B 41 08 83 E0 EF 0B C2 8B 4D 08 8B 51 20 89 42 08 8B 45 08 8B 48 20 8B 51 0C 83 E2 FE 8B 45 08 8B 48 20 89 51 0C 8B 55 08 8B 42 20 8B 48 0C 83 E1 FD 8B 55 08 8B 42 20 89 48 0C 8B 4D 08 8B 51 20 8B 42 0C 83 E0 FB 8B 4D 08 8B 51 20 89 42 0C 8B 45 08 8B 48 20 8B 51 0C 83 E2 F7 8B 45 08 8B 48 20 89 51 0C 8B 55 08 8B 42 20 8B 48 0C 83 E1 EF 8B 55 08 8B 42 20 89 48 0C 8B 4D 08 8B 51 20 8B 42 04 83 E0 FE 8B 4D 08 8B 51 20 89 42 04 8B 45 08 8B 48 20 8B 51 04 83 E2 FD 8B 45 08 8B 48 20 89 51 04 8B 55 08 8B 42 20 8B 48 04 83 E1 FB 8B 55 08 8B 42 20 89 48 04 8B 4D 08 8B 51 20 8B 42 04 83 E0 F7 8B 4D 08 8B 51 20 89 42 04 8B 45 08 8B 48 20 8B 51 04 83 E2 EF 8B 45 08 8B 48 20 89 51 04 5D C3 }
	condition:
		$1
}

rule file_248_0_0 {
	meta:
		name = "__strdup"
		size = 23
		refs = "000e __strdup_dbg"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 01 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_417_4_0 {
	meta:
		name = "__heap_alloc"
		size = 23
		refs = "000e __heap_alloc_dbg"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 01 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_381_0_0 {
	meta:
		name = "__wcsdup"
		size = 23
		refs = "000e __wcsdup_dbg"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 01 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_248_1_0 {
	meta:
		name = "__strdup_dbg"
		size = 133
		refs = "001c _strlen 003a __malloc_dbg 004f ??_C@_1BC@DIANEFHO@?$AAs?$AAt?$AAr?$AAd?$AAu?$AAp?$AA?4?$AAc?$AA?$AA@ 0054 ??_C@_1BI@CBNECNIC@?$AA_?$AAs?$AAt?$AAr?$AAd?$AAu?$AAp?$AA_?$AAd?$AAb?$AAg?$AA?$AA@ 0059 ??_C@_1DO@MOGEFOMO@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAm?$AAe?$AAm?$AAo?$AAr?$AAy?$AA?0?$AA?5?$AAs?$AAi?$AAz?$AAe?$AA?0?$AA?5?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?$CJ?$AA?$AA@ 006a _strcpy_s 0073 __invoke_watson_if_error"
	strings:
		$1 = { 55 8B EC 83 EC 08 C7 45 FC 00 00 00 00 83 7D 08 00 75 04 33 C0 EB 6A 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 83 C0 01 89 45 FC 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 F8 83 7D F8 00 74 35 6A 00 6A 50 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 55 08 52 8B 45 FC 50 8B 4D F8 51 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 45 F8 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_249_0_0 {
	meta:
		name = "___clean_type_info_names"
		size = 18
		refs = "0004 ?__type_info_root_node@@3U__type_info_node@@A 0009 ___clean_type_info_names_internal"
	strings:
		$1 = { 55 8B EC 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_10_14_1 {
	meta:
		name = "??__Einit_atexit@@YAXXZ"
		size = 18
		refs = "0004 ??__Finit_atexit@@YAXXZ 0009 _atexit"
	strings:
		$1 = { 55 8B EC 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_24_7_1 {
	meta:
		name = "?_Lockit_ctor@_Lockit@std@@CAXPAV12@@Z"
		size = 18
		refs = "0004 _mtx 0009 __Mtxlock"
	strings:
		$1 = { 55 8B EC 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_250_0_0 {
	meta:
		name = "?set_terminate@@YAP6AXXZP6AXXZ@Z"
		size = 62
		refs = "0016 ?_ValidateExecute@@YAHP6GHXZ@Z 0022 __getptd"
	strings:
		$1 = { 55 8B EC 51 C7 45 FC 00 00 00 00 83 7D 08 00 74 10 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 16 E8 ?? ?? ?? ?? 8B 48 78 89 4D FC E8 ?? ?? ?? ?? 8B 55 08 89 50 78 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_250_2_0 {
	meta:
		name = "?set_unexpected@@YAP6AXXZP6AXXZ@Z"
		size = 62
		refs = "0016 ?_ValidateExecute@@YAHP6GHXZ@Z 0022 __getptd"
	strings:
		$1 = { 55 8B EC 51 C7 45 FC 00 00 00 00 83 7D 08 00 74 10 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 16 E8 ?? ?? ?? ?? 8B 48 7C 89 4D FC E8 ?? ?? ?? ?? 8B 55 08 89 50 7C 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_250_4_0 {
	meta:
		name = "?_set_se_translator@@YAP6AXIPAU_EXCEPTION_POINTERS@@@ZP6AXI0@Z@Z"
		size = 68
		refs = "0016 ?_ValidateExecute@@YAHP6GHXZ@Z 0022 __getptd"
	strings:
		$1 = { 55 8B EC 51 C7 45 FC 00 00 00 00 83 7D 08 00 74 10 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 1C E8 ?? ?? ?? ?? 8B 88 80 00 00 00 89 4D FC E8 ?? ?? ?? ?? 8B 55 08 89 90 80 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_250_5_0 {
	meta:
		name = "?__set_inconsistency@@YAP6AXXZP6AXXZ@Z"
		size = 75
		refs = "0016 ?_ValidateExecute@@YAHP6GHXZ@Z 0023 ?__pInconsistency@@3P6AXXZA 0029 __decode_pointer 0038 __encode_pointer"
	strings:
		$1 = { 55 8B EC 51 C7 45 FC 00 00 00 00 83 7D 08 00 74 10 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 23 8B 0D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 A3 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_250_6_0 {
	meta:
		name = "?set_terminate@@YAP6AXXZH@Z"
		size = 25
		refs = "000c ?set_terminate@@YAP6AXXZP6AXXZ@Z"
	strings:
		$1 = { 55 8B EC 83 7D 08 00 75 0C 6A 00 E8 ?? ?? ?? ?? 83 C4 04 EB 02 33 C0 5D C3 }
	condition:
		$1
}

rule file_250_8_0 {
	meta:
		name = "?_set_se_translator@@YAP6AXIPAU_EXCEPTION_POINTERS@@@ZH@Z"
		size = 25
		refs = "000c ?_set_se_translator@@YAP6AXIPAU_EXCEPTION_POINTERS@@@ZP6AXI0@Z@Z"
	strings:
		$1 = { 55 8B EC 83 7D 08 00 75 0C 6A 00 E8 ?? ?? ?? ?? 83 C4 04 EB 02 33 C0 5D C3 }
	condition:
		$1
}

rule file_250_7_0 {
	meta:
		name = "?set_unexpected@@YAP6AXXZH@Z"
		size = 25
		refs = "000c ?set_unexpected@@YAP6AXXZP6AXXZ@Z"
	strings:
		$1 = { 55 8B EC 83 7D 08 00 75 0C 6A 00 E8 ?? ?? ?? ?? 83 C4 04 EB 02 33 C0 5D C3 }
	condition:
		$1
}

rule file_251_0_0 {
	meta:
		name = "__wchdir"
		size = 525
		refs = "000a ___security_cookie 0049 ??_C@_1BO@DPAOGEII@?$AA?$CI?$AAp?$AAa?$AAt?$AAh?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0052 ??_C@_1GA@LCCNLJDO@?$AAf?$AA?3?$AA?2?$AAr?$AAt?$AAm?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2@ 0059 __CrtDbgReportW 0070 ___doserrno 007b __errno 008f ??_C@_1BA@PNMFGAMJ@?$AA_?$AAw?$AAc?$AAh?$AAd?$AAi?$AAr?$AA?$AA@ 0099 __invalid_parameter 00ae __imp__SetCurrentDirectoryW@4 00c5 __imp__GetCurrentDirectoryW@8 00de ??_C@_0DA@OKMBBBKG@f?3?2rtm?2vctools?2crt_bld?2self_x86?2@ 00f1 __calloc_dbg 018b _towupper 01b8 __imp__SetEnvironmentVariableW@8 01d5 __imp__GetLastError@0 01db __dosmaperr 01f2 __free_dbg 0205 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC 30 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 F8 8D 85 E8 FD FF FF 89 45 FC C7 85 D4 FD FF FF 00 00 00 00 C7 85 E4 FD FF FF FF FF FF FF 33 C9 83 7D 08 00 0F 95 C1 89 8D D0 FD FF FF 83 BD D0 FD FF FF 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 31 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD D0 FD FF FF 00 75 39 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 31 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 57 01 00 00 8B 45 08 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 10 01 00 00 8B 4D FC 51 68 05 01 00 00 FF 15 ?? ?? ?? ?? 89 85 D8 FD FF FF 81 BD D8 FD FF FF 04 01 00 00 7E 5F 6A 4B 68 ?? ?? ?? ?? 6A 02 6A 02 8B 95 D8 FD FF FF 83 C2 01 52 E8 ?? ?? ?? ?? 83 C4 14 89 45 FC 83 7D FC 00 75 0C C7 85 D8 FD FF FF 00 00 00 00 EB 0A C7 85 D4 FD FF FF 01 00 00 00 83 BD D8 FD FF FF 00 74 1A 8B 45 FC 50 8B 8D D8 FD FF FF 83 C1 01 51 FF 15 ?? ?? ?? ?? 89 85 D8 FD FF FF 83 BD D8 FD FF FF 00 0F 84 83 00 00 00 8B 55 FC 0F B7 02 83 F8 5C 74 0B 8B 4D FC 0F B7 11 83 FA 2F 75 1D 8B 45 FC 0F B7 08 8B 55 FC 0F B7 42 02 3B C8 75 0C C7 85 E4 FD FF FF 00 00 00 00 EB 50 66 C7 85 DC FD FF FF 3D 00 8B 4D FC 66 8B 11 52 E8 ?? ?? ?? ?? 83 C4 04 66 89 85 DE FD FF FF 66 C7 85 E0 FD FF FF 3A 00 66 C7 85 E2 FD FF FF 00 00 8B 45 FC 50 8D 8D DC FD FF FF 51 FF 15 ?? ?? ?? ?? 85 C0 74 0A C7 85 E4 FD FF FF 00 00 00 00 83 BD E4 FD FF FF 00 74 0F FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 83 BD D4 FD FF FF 00 74 0E 6A 02 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 08 8B 85 E4 FD FF FF 8B 4D F8 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_252_0_0 {
	meta:
		name = "__mbsupr_s_l"
		size = 935
		refs = "003b ??_C@_1JI@LJBHPGOE@?$AA?$CI?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAB?$AAy?$AAt?$AAe?$AAs?$AA?5?$AA?$DO@ 0044 ??_C@_1BC@BEILNAEJ@?$AAm?$AAb?$AAs?$AAu?$AAp?$AAr?$AA?4?$AAc?$AA?$AA@ 004b __CrtDbgReportW 005f __errno 0073 ??_C@_1BI@PBGKGPOP@?$AA_?$AAm?$AAb?$AAs?$AAu?$AAp?$AAr?$AA_?$AAs?$AA_?$AAl?$AA?$AA@ 007d __invalid_parameter 00a4 _strnlen 00dd ___crtDebugFillThreshold 0108 _memset 0110 ??_C@_1DM@FHLMIEG@?$AAS?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AAi?$AAs?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAn?$AAu?$AAl?$AAl?$AA?5?$AAt?$AAe?$AAr?$AAm?$AAi?$AAn?$AAa?$AAt?$AAe?$AAd?$AA?$AA@ 0139 ??_C@_1FA@MJKDNFFB@?$AA?$CI?$AAL?$AA?$CC?$AAS?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AAi?$AAs?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAn?$AAu?$AAl?$AAl?$AA?5?$AAt?$AAe?$AAr?$AAm?$AAi?$AAn?$AAa?$AAt?$AAe?$AAd@ 01f5 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0222 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0278 ___crtLCMapStringA 02f6 ??1_LocaleUpdate@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 83 EC 4C 83 7D 08 00 74 06 83 7D 0C 00 77 15 83 7D 08 00 75 06 83 7D 0C 00 74 09 C7 45 C8 00 00 00 00 EB 07 C7 45 C8 01 00 00 00 8B 45 C8 89 45 E0 83 7D E0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 37 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 37 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 15 03 00 00 83 7D 08 00 75 07 33 C0 E9 08 03 00 00 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 E4 8B 4D E4 3B 4D 0C 0F 82 D2 00 00 00 8B 55 08 C6 02 00 83 7D 0C FF 74 49 81 7D 0C FF FF FF 7F 74 40 83 7D 0C 01 76 3A 8B 45 0C 83 E8 01 39 05 ?? ?? ?? ?? 73 0B 8B 0D ?? ?? ?? ?? 89 4D C4 EB 09 8B 55 0C 83 EA 01 89 55 C4 8B 45 C4 50 68 FD 00 00 00 8B 4D 08 83 C1 01 51 E8 ?? ?? ?? ?? 83 C4 0C BA ?? ?? ?? ?? 85 D2 74 0D 33 C0 74 09 C7 45 C0 01 00 00 00 EB 07 C7 45 C0 00 00 00 00 8B 4D C0 89 4D DC 83 7D DC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 43 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D DC 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 43 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 17 02 00 00 83 7D 0C FF 74 5B 81 7D 0C FF FF FF 7F 74 52 8B 45 E4 83 C0 01 3B 45 0C 73 47 8B 4D E4 83 C1 01 8B 55 0C 2B D1 39 15 ?? ?? ?? ?? 73 0A A1 ?? ?? ?? ?? 89 45 BC EB 0E 8B 4D E4 83 C1 01 8B 55 0C 2B D1 89 55 BC 8B 45 BC 50 68 FD 00 00 00 8B 4D E4 8B 55 08 8D 44 0A 01 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D 10 51 8D 4D E8 E8 ?? ?? ?? ?? 8B 55 08 89 55 F8 8B 45 08 89 45 FC EB 09 8B 4D F8 83 C1 01 89 4D F8 8B 55 F8 0F B6 02 85 C0 0F 84 6D 01 00 00 8D 4D E8 E8 ?? ?? ?? ?? 8B 48 04 8B 55 F8 0F B6 02 0F B6 4C 01 1D 83 E1 04 0F 84 F8 00 00 00 6A 01 8D 4D E8 E8 ?? ?? ?? ?? 8B 50 04 8B 42 04 50 6A 02 8D 4D D4 51 6A 02 8B 55 F8 52 68 00 02 00 00 8D 4D E8 E8 ?? ?? ?? ?? 8B 40 04 8B 48 0C 51 8D 4D E8 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 24 89 45 D8 83 7D D8 00 75 7A E8 ?? ?? ?? ?? C7 00 2A 00 00 00 8B 55 08 C6 02 00 83 7D 0C FF 74 49 81 7D 0C FF FF FF 7F 74 40 83 7D 0C 01 76 3A 8B 45 0C 83 E8 01 39 05 ?? ?? ?? ?? 73 0B 8B 0D ?? ?? ?? ?? 89 4D B8 EB 09 8B 55 0C 83 EA 01 89 55 B8 8B 45 B8 50 68 FD 00 00 00 8B 4D 08 83 C1 01 51 E8 ?? ?? ?? ?? 83 C4 0C E8 ?? ?? ?? ?? 8B 10 89 55 D0 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 D0 E9 A1 00 00 00 8B 45 FC 8A 4D D4 88 08 8B 55 FC 83 C2 01 89 55 FC 8B 45 F8 83 C0 01 89 45 F8 83 7D D8 01 7E 11 8B 4D FC 8A 55 D5 88 11 8B 45 FC 83 C0 01 89 45 FC EB 51 8D 4D E8 E8 ?? ?? ?? ?? 8B 48 04 8B 55 F8 0F B6 02 0F B6 4C 01 1D 83 E1 20 74 1D 8D 4D E8 E8 ?? ?? ?? ?? 8B 50 04 8B 45 F8 0F B6 08 8A 94 0A 1D 01 00 00 88 55 B7 EB 08 8B 45 F8 8A 08 88 4D B7 8B 55 FC 8A 45 B7 88 02 8B 4D FC 83 C1 01 89 4D FC E9 7C FE FF FF 8B 55 FC C6 02 00 C7 45 CC 00 00 00 00 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 CC 8B E5 5D C3 }
	condition:
		$1
}

rule file_252_5_0 {
	meta:
		name = "__mbsupr_l"
		size = 38
		refs = "0014 __mbsupr_s_l"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 8B 4D 08 F7 D9 1B C9 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C F7 D8 1B C0 F7 D0 23 45 08 5D C3 }
	condition:
		$1
}

rule file_910_5_0 {
	meta:
		name = "__mbslwr_l"
		size = 38
		refs = "0014 __mbslwr_s_l"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 8B 4D 08 F7 D9 1B C9 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C F7 D8 1B C0 F7 D0 23 45 08 5D C3 }
	condition:
		$1
}

rule file_252_6_0 {
	meta:
		name = "__mbsupr"
		size = 36
		refs = "0012 __mbsupr_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 F7 D8 1B C0 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C F7 D8 1B C0 F7 D0 23 45 08 5D C3 }
	condition:
		$1
}

rule file_910_6_0 {
	meta:
		name = "__mbslwr"
		size = 36
		refs = "0012 __mbslwr_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 F7 D8 1B C0 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C F7 D8 1B C0 F7 D0 23 45 08 5D C3 }
	condition:
		$1
}

rule file_253_1_0 {
	meta:
		name = "___tmainCRTStartup"
		size = 827
		refs = "0006 __sehtable$___tmainCRTStartup 000b __except_handler4 0020 ___security_cookie 0076 __imp__GetStartupInfoW@4 00b8 __imp__GetProcessHeap@0 00bf __imp__HeapAlloc@12 00cf _fast_error_exit 00ef __imp__GetVersionExA@4 0106 __imp__HeapFree@12 0180 __set_osplatform 018f __set_winver 019b __set_winmajor 01a7 __set_winminor 01b6 __set_osver 01be _check_managed_app 01c8 __heap_init 01de __mtinit 01f3 __CrtSetCheckCount 01fb __RTC_Initialize 0207 __ioinit 0212 __amsg_exit 021a ___crtGetCommandLineW 021f __wcmdln 0224 ___crtGetEnvironmentStringsW 0229 __wenvptr 022e __wsetargv 0241 __wsetenvp 0256 __cinit 0273 __wwincmdln 02a6 ___ImageBase 02ab _wWinMain@16 02c3 _exit 02c8 __cexit 02ee __XcptFilter 0313 __exit 0318 __c_exit"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 81 C4 78 FF FF FF 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 89 65 E8 C7 45 88 00 00 00 00 C7 85 74 FF FF FF 00 00 00 00 C7 45 E4 00 00 00 00 C7 45 80 00 00 00 00 C7 85 7C FF FF FF 00 00 00 00 C7 85 78 FF FF FF 00 00 00 00 C7 45 FC 00 00 00 00 8D 45 98 50 FF 15 ?? ?? ?? ?? C7 45 FC FE FF FF FF EB 2C B8 01 00 00 00 C3 8B 65 E8 C7 85 6C FF FF FF FF 00 00 00 C7 45 FC FE FF FF FF 8B 85 6C FF FF FF E9 81 02 00 00 C7 45 FC FE FF FF FF 68 94 00 00 00 6A 00 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 89 45 84 83 7D 84 00 75 14 6A 12 E8 ?? ?? ?? ?? 83 C4 04 B8 FF 00 00 00 E9 49 02 00 00 8B 4D 84 C7 01 94 00 00 00 8B 55 84 52 FF 15 ?? ?? ?? ?? 85 C0 75 1D 8B 45 84 50 6A 00 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? B8 FF 00 00 00 E9 15 02 00 00 8B 4D 84 8B 51 10 89 55 88 8B 45 84 8B 48 04 89 4D E4 8B 55 84 8B 42 08 89 45 80 8B 4D 84 8B 51 0C 81 E2 FF 7F 00 00 89 95 7C FF FF FF 8B 45 84 50 6A 00 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 83 7D 88 02 74 12 8B 8D 7C FF FF FF 81 C9 00 80 00 00 89 8D 7C FF FF FF 8B 55 E4 C1 E2 08 03 55 80 89 95 74 FF FF FF 8B 45 88 50 E8 ?? ?? ?? ?? 83 C4 04 8B 8D 74 FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 E4 52 E8 ?? ?? ?? ?? 83 C4 04 8B 45 80 50 E8 ?? ?? ?? ?? 83 C4 04 8B 8D 7C FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 89 45 8C 6A 01 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 0A 6A 1C E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 85 C0 75 0A 6A 10 E8 ?? ?? ?? ?? 83 C4 04 6A 01 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? C7 45 FC 01 00 00 00 E8 ?? ?? ?? ?? 85 C0 7D 0A 6A 1B E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 7D 0A 6A 08 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 85 C0 7D 0A 6A 09 E8 ?? ?? ?? ?? 83 C4 04 6A 01 E8 ?? ?? ?? ?? 83 C4 04 89 45 94 83 7D 94 00 74 0C 8B 55 94 52 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 89 45 90 8B 45 C4 83 E0 01 74 0C 0F B7 4D C8 89 8D 68 FF FF FF EB 0A C7 85 68 FF FF FF 0A 00 00 00 8B 95 68 FF FF FF 52 8B 45 90 50 6A 00 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 85 78 FF FF FF 83 7D 8C 00 75 0C 8B 8D 78 FF FF FF 51 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 45 FC FE FF FF FF EB 4E 8B 55 EC 8B 02 8B 08 89 8D 70 FF FF FF 8B 55 EC 52 8B 85 70 FF FF FF 50 E8 ?? ?? ?? ?? 83 C4 08 C3 8B 65 E8 8B 8D 70 FF FF FF 89 8D 78 FF FF FF 83 7D 8C 00 75 0C 8B 95 78 FF FF FF 52 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 45 FC FE FF FF FF 8B 85 78 FF FF FF 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_253_7_0 {
	meta:
		name = "_fast_error_exit"
		size = 44
		refs = "0005 ___error_mode 000d __FF_MSGBANNER 0016 __NMSG_WRITE 0023 ___crtExitProcess"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? 01 75 05 E8 ?? ?? ?? ?? 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 68 FF 00 00 00 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_254_0_0 {
	meta:
		name = "__wmktemp_s"
		size = 1289
		refs = "0043 ??_C@_1FA@JNABFIEA@?$AA?$CI?$AAt?$AAe?$AAm?$AAp?$AAl?$AAa?$AAt?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAC?$AAh?$AAa@ 004c ??_C@_1GC@KMHJAPCA@?$AAf?$AA?3?$AA?2?$AAr?$AAt?$AAm?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2@ 0053 __CrtDbgReportW 0067 __errno 007b ??_C@_1BG@POKAOPLF@?$AA_?$AAw?$AAm?$AAk?$AAt?$AAe?$AAm?$AAp?$AA_?$AAs?$AA?$AA@ 0085 __invalid_parameter 009f _wcsnlen 00da ___crtDebugFillThreshold 0107 _memset 010f ??_C@_1DM@FHLMIEG@?$AAS?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AAi?$AAs?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAn?$AAu?$AAl?$AAl?$AA?5?$AAt?$AAe?$AAr?$AAm?$AAi?$AAn?$AAa?$AAt?$AAe?$AAd?$AA?$AA@ 0138 ??_C@_1FA@MJKDNFFB@?$AA?$CI?$AAL?$AA?$CC?$AAS?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AAi?$AAs?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAn?$AAu?$AAl?$AAl?$AA?5?$AAt?$AAe?$AAr?$AAm?$AAi?$AAn?$AAa?$AAt?$AAe?$AAd@ 01f0 ___threadid 028f ??_C@_1EE@JEDJDFK@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAc?$AAo?$AAr?$AAr?$AAe?$AAc?$AAt?$AA?5?$AAI?$AAn?$AAp?$AAu?$AAt?$AA?5?$AAf?$AAo?$AAr?$AA?5?$AAm?$AAk?$AAt?$AAe?$AAm?$AAp?$AA?$CC?$AA?0?$AA?5?$AA0@ 044a __waccess_s"
	strings:
		$1 = { 55 8B EC 83 EC 48 8B 45 08 89 45 F4 C7 45 FC 61 00 00 00 C7 45 F8 00 00 00 00 83 7D 08 00 74 0F 83 7D 0C 00 76 09 C7 45 D8 01 00 00 00 EB 07 C7 45 D8 00 00 00 00 8B 4D D8 89 4D E8 83 7D E8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3A 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E8 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 3A 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 6F 04 00 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 F8 8B 55 F8 3B 55 0C 0F 82 D6 00 00 00 8B 45 08 66 C7 00 00 00 83 7D 0C FF 74 4B 81 7D 0C FF FF FF 7F 74 42 83 7D 0C 01 76 3C 8B 4D 0C 83 E9 01 39 0D ?? ?? ?? ?? 73 0B 8B 15 ?? ?? ?? ?? 89 55 D4 EB 09 8B 45 0C 83 E8 01 89 45 D4 8B 4D D4 D1 E1 51 68 FD 00 00 00 8B 55 08 83 C2 02 52 E8 ?? ?? ?? ?? 83 C4 0C B8 ?? ?? ?? ?? 85 C0 74 0D 33 C9 74 09 C7 45 D0 01 00 00 00 EB 07 C7 45 D0 00 00 00 00 8B 55 D0 89 55 E4 83 7D E4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3F 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E4 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 3F 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 7A 03 00 00 83 7D 0C FF 74 5E 81 7D 0C FF FF FF 7F 74 55 8B 4D F8 83 C1 01 3B 4D 0C 73 4A 8B 55 F8 83 C2 01 8B 45 0C 2B C2 39 05 ?? ?? ?? ?? 73 0B 8B 0D ?? ?? ?? ?? 89 4D CC EB 0E 8B 55 F8 83 C2 01 8B 45 0C 2B C2 89 45 CC 8B 4D CC D1 E1 51 68 FD 00 00 00 8B 55 F8 8B 45 08 8D 4C 50 02 51 E8 ?? ?? ?? ?? 83 C4 0C E8 ?? ?? ?? ?? 89 45 EC 8B 55 F8 8B 45 F4 8D 0C 50 89 4D F4 83 7D F8 06 72 0C 8B 55 0C 3B 55 F8 0F 87 CD 00 00 00 8B 45 08 66 C7 00 00 00 83 7D 0C FF 74 4B 81 7D 0C FF FF FF 7F 74 42 83 7D 0C 01 76 3C 8B 4D 0C 83 E9 01 39 0D ?? ?? ?? ?? 73 0B 8B 15 ?? ?? ?? ?? 89 55 C8 EB 09 8B 45 0C 83 E8 01 89 45 C8 8B 4D C8 D1 E1 51 68 FD 00 00 00 8B 55 08 83 C2 02 52 E8 ?? ?? ?? ?? 83 C4 0C 33 C0 74 09 C7 45 C4 01 00 00 00 EB 07 C7 45 C4 00 00 00 00 8B 4D C4 89 4D E0 83 7D E0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 57 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 57 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 23 02 00 00 C7 45 F8 00 00 00 00 8B 45 F4 83 E8 02 89 45 F4 8B 4D F4 3B 4D 08 72 40 8B 55 F4 0F B7 02 83 F8 58 75 35 83 7D F8 05 73 2F 8B 4D F8 83 C1 01 89 4D F8 8B 45 EC 33 D2 B9 0A 00 00 00 F7 F1 83 C2 30 8B 45 F4 66 89 10 8B 45 EC 33 D2 B9 0A 00 00 00 F7 F1 89 45 EC EB AF 8B 55 F4 0F B7 02 83 F8 58 75 0A 83 7D F8 05 0F 83 CC 00 00 00 8B 4D 08 66 C7 01 00 00 83 7D 0C FF 74 4A 81 7D 0C FF FF FF 7F 74 41 83 7D 0C 01 76 3B 8B 55 0C 83 EA 01 39 15 ?? ?? ?? ?? 73 0A A1 ?? ?? ?? ?? 89 45 C0 EB 09 8B 4D 0C 83 E9 01 89 4D C0 8B 55 C0 D1 E2 52 68 FD 00 00 00 8B 45 08 83 C0 02 50 E8 ?? ?? ?? ?? 83 C4 0C 33 C9 74 09 C7 45 BC 01 00 00 00 EB 07 C7 45 BC 00 00 00 00 8B 55 BC 89 55 DC 83 7D DC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 6D 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D DC 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 6D 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 EA 00 00 00 8B 4D F4 66 8B 55 FC 66 89 11 8B 45 FC 83 C0 01 89 45 FC E8 ?? ?? ?? ?? 8B 08 89 4D F0 E8 ?? ?? ?? ?? C7 00 00 00 00 00 6A 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 0E E8 ?? ?? ?? ?? 83 38 0D 0F 85 96 00 00 00 83 7D FC 7B 75 6D 8B 45 08 66 C7 00 00 00 83 7D 0C FF 74 4B 81 7D 0C FF FF FF 7F 74 42 83 7D 0C 01 76 3C 8B 4D 0C 83 E9 01 39 0D ?? ?? ?? ?? 73 0B 8B 15 ?? ?? ?? ?? 89 55 B8 EB 09 8B 45 0C 83 E8 01 89 45 B8 8B 4D B8 D1 E1 51 68 FD 00 00 00 8B 55 08 83 C2 02 52 E8 ?? ?? ?? ?? 83 C4 0C E8 ?? ?? ?? ?? C7 00 11 00 00 00 E8 ?? ?? ?? ?? 8B 00 EB 2F 8B 45 F4 66 8B 4D FC 66 89 08 8B 55 FC 83 C2 01 89 55 FC E8 ?? ?? ?? ?? C7 00 00 00 00 00 E9 4A FF FF FF E8 ?? ?? ?? ?? 8B 4D F0 89 08 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_255_0_0 {
	meta:
		name = "__statusfp2"
		size = 52
		refs = "0014 __abstract_sw 0027 ___statusfp_sse2"
	strings:
		$1 = { 55 8B EC 51 83 7D 08 00 74 16 9B DD 7D FC 66 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 08 89 01 83 7D 0C 00 74 0A E8 ?? ?? ?? ?? 8B 55 0C 89 02 8B E5 5D C3 }
	condition:
		$1
}

rule file_255_1_0 {
	meta:
		name = "__statusfp"
		size = 63
		refs = "0010 __abstract_sw 001c ___sse2_available 002c ___abstract_sw_sse2"
	strings:
		$1 = { 55 8B EC 83 EC 0C 9B DD 7D F8 66 8B 45 F8 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 83 3D ?? ?? ?? ?? 00 74 15 0F AE 5D F4 8B 4D F4 51 E8 ?? ?? ?? ?? 83 C4 04 0B 45 FC EB 03 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_255_2_0 {
	meta:
		name = "__clearfp"
		size = 63
		refs = "000c ___sse2_available 0019 __abstract_sw 0023 ___clearfp_sse2"
	strings:
		$1 = { 55 8B EC 51 56 DD 7D FC DB E2 83 3D ?? ?? ?? ?? 00 74 1A 66 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 8B F0 E8 ?? ?? ?? ?? 0B C6 EB 0F EB 0D 66 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_255_3_0 {
	meta:
		name = "___control87_2"
		size = 162
		refs = "0016 __abstract_cw 0040 __hw_cw 0072 ___sse2_available 0082 ___control87_sse2"
	strings:
		$1 = { 55 8B EC 83 EC 10 83 7D 10 00 74 5E 9B D9 7D FC 66 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 F4 8B 4D 08 23 4D 0C 8B 55 0C F7 D2 23 55 F4 0B CA 89 4D F0 8B 45 F0 3B 45 F4 74 27 8B 4D F0 51 E8 ?? ?? ?? ?? 83 C4 04 66 89 45 F8 D9 6D F8 9B D9 7D F8 66 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 F0 8B 45 10 8B 4D F0 89 08 83 7D 14 00 74 29 83 3D ?? ?? ?? ?? 00 74 17 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4D 14 89 01 EB 09 8B 55 14 C7 02 00 00 00 00 B8 01 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_255_4_0 {
	meta:
		name = "__controlfp"
		size = 26
		refs = "0011 __control87"
	strings:
		$1 = { 55 8B EC 8B 45 0C 25 FF FF F7 FF 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_255_5_0 {
	meta:
		name = "__control87"
		size = 174
		refs = "0010 __abstract_cw 003a __hw_cw 005e ___sse2_available 006e ___control87_sse2 007d ?commonFlags@?1??_control87@@9@9"
	strings:
		$1 = { 55 8B EC 83 EC 14 9B D9 7D FC 66 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 F0 8B 4D 08 23 4D 0C 8B 55 0C F7 D2 23 55 F0 0B CA 89 4D EC 8B 45 EC 3B 45 F0 74 27 8B 4D EC 51 E8 ?? ?? ?? ?? 83 C4 04 66 89 45 F8 D9 6D F8 9B D9 7D F8 66 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 EC 83 3D ?? ?? ?? ?? 00 74 42 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 F4 8B 55 F4 23 15 ?? ?? ?? ?? 8B 45 EC 23 05 ?? ?? ?? ?? 3B D0 74 0F 8B 45 EC 0B 45 F4 0D 00 00 00 80 EB 0F EB 08 8B 45 F4 0B 45 EC EB 05 EB 03 8B 45 EC 8B E5 5D C3 }
	condition:
		$1
}

rule file_255_6_0 {
	meta:
		name = "__set_controlfp"
		size = 136
		refs = "002b ___sse2_available 0055 ??_C@_1BM@PNOCKIGC@?$AAi?$AA3?$AA8?$AA6?$AA?2?$AAi?$AAe?$AAe?$AAe?$AA8?$AA7?$AA?4?$AAc?$AA?$AA@ 005a ??_C@_1BO@OFDNCLL@?$AA_?$AAs?$AAe?$AAt?$AA_?$AAc?$AAo?$AAn?$AAt?$AAr?$AAo?$AAl?$AAf?$AAp?$AA?$AA@ 005f ??_C@_1GO@OKJGOMCB@?$AA_?$AAc?$AAo?$AAn?$AAt?$AAr?$AAo?$AAl?$AAf?$AAp?$AA_?$AAs?$AA?$CI?$AA?$CI?$AA?$CI?$AAv?$AAo?$AAi?$AAd?$AA?5?$AA?$CK?$AA?$CJ?$AA0?$AA?$CJ?$AA?0?$AA?5?$AAn?$AAe?$AAw?$AAc?$AAt?$AAr@ 0074 __controlfp_s 007d __invoke_watson_if_error"
	strings:
		$1 = { 55 8B EC 83 EC 08 81 7D 08 1F 00 09 00 75 3E 83 7D 0C FF 75 38 9B D9 7D F8 0F BF 45 F8 25 3D 1F 00 00 3D 3D 02 00 00 75 24 83 3D ?? ?? ?? ?? 00 74 19 0F AE 5D FC 8B 4D FC 81 E1 C0 FE 00 00 81 F9 80 1E 00 00 75 02 EB 3B EB 02 EB 37 6A 00 68 5B 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 55 0C 81 E2 FF FF F7 FF 52 8B 45 08 50 6A 00 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B E5 5D C3 }
	condition:
		$1
}

rule file_255_8_0 {
	meta:
		name = "__fpreset"
		size = 85
		refs = "0007 ___pxcptinfoptrs 0013 __setdefaultprecision 0018 ___fpreset_sse2"
	strings:
		$1 = { 55 8B EC 83 EC 08 E8 ?? ?? ?? ?? 8B 00 89 45 FC DB E3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 7D FC 00 74 2F 8B 4D FC 8B 51 04 8B 02 25 08 00 01 00 74 20 8B 4D FC 8B 51 04 83 C2 1C 89 55 F8 8B 45 F8 C7 40 04 00 00 00 00 8B 4D F8 C7 41 08 FF FF 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_255_9_0 {
	meta:
		name = "__abstract_cw"
		size = 328
	strings:
		$1 = { 55 8B EC 83 EC 0C C7 45 FC 00 00 00 00 0F B7 45 08 83 E0 01 74 09 8B 4D FC 83 C9 10 89 4D FC 0F B7 55 08 83 E2 04 74 09 8B 45 FC 83 C8 08 89 45 FC 0F B7 4D 08 83 E1 08 74 09 8B 55 FC 83 CA 04 89 55 FC 0F B7 45 08 83 E0 10 74 09 8B 4D FC 83 C9 02 89 4D FC 0F B7 55 08 83 E2 20 74 09 8B 45 FC 83 C8 01 89 45 FC 0F B7 4D 08 83 E1 02 74 0C 8B 55 FC 81 CA 00 00 08 00 89 55 FC 0F B7 45 08 25 00 0C 00 00 89 45 F8 81 7D F8 00 08 00 00 7F 1A 81 7D F8 00 08 00 00 74 24 83 7D F8 00 74 16 81 7D F8 00 04 00 00 74 23 EB 3A 81 7D F8 00 0C 00 00 74 25 EB 2F 8B 4D FC 89 4D FC EB 27 8B 55 FC 81 CA 00 02 00 00 89 55 FC EB 19 8B 45 FC 0D 00 01 00 00 89 45 FC EB 0C 8B 4D FC 81 C9 00 03 00 00 89 4D FC 0F B7 55 08 81 E2 00 03 00 00 89 55 F4 74 2A 81 7D F4 00 02 00 00 74 13 81 7D F4 00 03 00 00 74 02 EB 22 8B 45 FC 89 45 FC EB 1A 8B 4D FC 81 C9 00 00 01 00 89 4D FC EB 0C 8B 55 FC 81 CA 00 00 02 00 89 55 FC 0F B7 45 08 25 00 10 00 00 74 0C 8B 4D FC 81 C9 00 00 04 00 89 4D FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_255_10_0 {
	meta:
		name = "__hw_cw"
		size = 346
	strings:
		$1 = { 55 8B EC 83 EC 0C 66 C7 45 FC 00 00 8B 45 08 83 E0 10 74 0B 0F B7 4D FC 83 C9 01 66 89 4D FC 8B 55 08 83 E2 08 74 0B 0F B7 45 FC 83 C8 04 66 89 45 FC 8B 4D 08 83 E1 04 74 0B 0F B7 55 FC 83 CA 08 66 89 55 FC 8B 45 08 83 E0 02 74 0B 0F B7 4D FC 83 C9 10 66 89 4D FC 8B 55 08 83 E2 01 74 0B 0F B7 45 FC 83 C8 20 66 89 45 FC 8B 4D 08 81 E1 00 00 08 00 74 0B 0F B7 55 FC 83 CA 02 66 89 55 FC 8B 45 08 25 00 03 00 00 89 45 F8 81 7D F8 00 02 00 00 77 1A 81 7D F8 00 02 00 00 74 26 83 7D F8 00 74 16 81 7D F8 00 01 00 00 74 27 EB 42 81 7D F8 00 03 00 00 74 2B EB 37 66 8B 4D FC 66 89 4D FC EB 2D 0F B7 55 FC 81 CA 00 08 00 00 66 89 55 FC EB 1D 0F B7 45 FC 0D 00 04 00 00 66 89 45 FC EB 0E 0F B7 4D FC 81 C9 00 0C 00 00 66 89 4D FC 8B 55 08 81 E2 00 00 03 00 89 55 F4 74 14 81 7D F4 00 00 01 00 74 1A 81 7D F4 00 00 02 00 74 21 EB 27 0F B7 45 FC 0D 00 03 00 00 66 89 45 FC EB 18 0F B7 4D FC 81 C9 00 02 00 00 66 89 4D FC EB 08 66 8B 55 FC 66 89 55 FC 8B 45 08 25 00 00 04 00 74 0E 0F B7 4D FC 81 C9 00 10 00 00 66 89 4D FC 66 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_255_11_0 {
	meta:
		name = "__abstract_sw"
		size = 137
	strings:
		$1 = { 55 8B EC 51 C7 45 FC 00 00 00 00 0F B7 45 08 83 E0 3F 74 6E 0F B7 4D 08 83 E1 01 74 09 8B 55 FC 83 CA 10 89 55 FC 0F B7 45 08 83 E0 04 74 09 8B 4D FC 83 C9 08 89 4D FC 0F B7 55 08 83 E2 08 74 09 8B 45 FC 83 C8 04 89 45 FC 0F B7 4D 08 83 E1 10 74 09 8B 55 FC 83 CA 02 89 55 FC 0F B7 45 08 83 E0 20 74 09 8B 4D FC 83 C9 01 89 4D FC 0F B7 55 08 83 E2 02 74 0B 8B 45 FC 0D 00 00 08 00 89 45 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_255_12_0 {
	meta:
		name = "___statusfp_sse2"
		size = 28
		refs = "0005 ___get_fpsr_sse2 0011 ___abstract_sw_sse2"
	strings:
		$1 = { 55 8B EC 51 E8 ?? ?? ?? ?? 89 45 FC 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_255_13_0 {
	meta:
		name = "___clearfp_sse2"
		size = 32
		refs = "0015 ___abstract_sw_sse2"
	strings:
		$1 = { 55 8B EC 51 0F AE 5D FC 83 65 FC C0 0F AE 55 FC 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_255_14_0 {
	meta:
		name = "___control87_sse2"
		size = 115
		refs = "001a ___abstract_cw_sse2 0049 ___hw_cw_sse2 0058 ___set_fpsr_sse2"
	strings:
		$1 = { 55 8B EC 83 EC 10 8B 45 0C 25 1F 03 08 03 89 45 0C 0F AE 5D FC 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 F4 8B 55 08 23 55 0C 8B 45 0C F7 D0 23 45 F4 0B D0 89 55 F0 8B 4D F0 3B 4D F4 75 05 8B 45 F4 EB 2B 8B 55 F0 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 F8 8B 45 F8 50 E8 ?? ?? ?? ?? 83 C4 04 0F AE 5D F8 8B 4D F8 51 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_255_15_0 {
	meta:
		name = "___abstract_cw_sse2"
		size = 322
	strings:
		$1 = { 55 8B EC 83 EC 0C C7 45 FC 00 00 00 00 8B 45 08 25 80 00 00 00 74 09 8B 4D FC 83 C9 10 89 4D FC 8B 55 08 81 E2 00 02 00 00 74 09 8B 45 FC 83 C8 08 89 45 FC 8B 4D 08 81 E1 00 04 00 00 74 09 8B 55 FC 83 CA 04 89 55 FC 8B 45 08 25 00 08 00 00 74 09 8B 4D FC 83 C9 02 89 4D FC 8B 55 08 81 E2 00 10 00 00 74 09 8B 45 FC 83 C8 01 89 45 FC 8B 4D 08 81 E1 00 01 00 00 74 0C 8B 55 FC 81 CA 00 00 08 00 89 55 FC 8B 45 08 25 00 60 00 00 89 45 F8 81 7D F8 00 40 00 00 77 1A 81 7D F8 00 40 00 00 74 24 83 7D F8 00 74 16 81 7D F8 00 20 00 00 74 23 EB 3A 81 7D F8 00 60 00 00 74 25 EB 2F 8B 4D FC 89 4D FC EB 27 8B 55 FC 81 CA 00 02 00 00 89 55 FC EB 19 8B 45 FC 0D 00 01 00 00 89 45 FC EB 0C 8B 4D FC 81 C9 00 03 00 00 89 4D FC 8B 55 08 81 E2 40 80 00 00 89 55 F4 83 7D F4 40 74 21 81 7D F4 00 80 00 00 74 26 81 7D F4 40 80 00 00 74 02 EB 27 8B 45 FC 0D 00 00 00 01 89 45 FC EB 1A 8B 4D FC 81 C9 00 00 00 02 89 4D FC EB 0C 8B 55 FC 81 CA 00 00 00 03 89 55 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_255_16_0 {
	meta:
		name = "___hw_cw_sse2"
		size = 322
	strings:
		$1 = { 55 8B EC 83 EC 0C C7 45 FC 00 00 00 00 8B 45 08 83 E0 10 74 0C 8B 4D FC 81 C9 80 00 00 00 89 4D FC 8B 55 08 83 E2 08 74 0B 8B 45 FC 0D 00 02 00 00 89 45 FC 8B 4D 08 83 E1 04 74 0C 8B 55 FC 81 CA 00 04 00 00 89 55 FC 8B 45 08 83 E0 02 74 0C 8B 4D FC 81 C9 00 08 00 00 89 4D FC 8B 55 08 83 E2 01 74 0B 8B 45 FC 0D 00 10 00 00 89 45 FC 8B 4D 08 81 E1 00 00 08 00 74 0C 8B 55 FC 81 CA 00 01 00 00 89 55 FC 8B 45 08 25 00 03 00 00 89 45 F8 81 7D F8 00 02 00 00 77 1A 81 7D F8 00 02 00 00 74 24 83 7D F8 00 74 16 81 7D F8 00 01 00 00 74 23 EB 3A 81 7D F8 00 03 00 00 74 25 EB 2F 8B 4D FC 89 4D FC EB 27 8B 55 FC 81 CA 00 40 00 00 89 55 FC EB 19 8B 45 FC 0D 00 20 00 00 89 45 FC EB 0C 8B 4D FC 81 C9 00 60 00 00 89 4D FC 8B 55 08 81 E2 00 00 00 03 89 55 F4 81 7D F4 00 00 00 01 74 14 81 7D F4 00 00 00 02 74 18 81 7D F4 00 00 00 03 74 1A EB 24 8B 45 FC 0D 40 80 00 00 89 45 FC EB 17 8B 4D FC 83 C9 40 89 4D FC EB 0C 8B 55 FC 81 CA 00 80 00 00 89 55 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_255_17_0 {
	meta:
		name = "___abstract_sw_sse2"
		size = 130
	strings:
		$1 = { 55 8B EC 51 C7 45 FC 00 00 00 00 8B 45 08 83 E0 3F 74 68 8B 4D 08 83 E1 01 74 09 8B 55 FC 83 CA 10 89 55 FC 8B 45 08 83 E0 04 74 09 8B 4D FC 83 C9 08 89 4D FC 8B 55 08 83 E2 08 74 09 8B 45 FC 83 C8 04 89 45 FC 8B 4D 08 83 E1 10 74 09 8B 55 FC 83 CA 02 89 55 FC 8B 45 08 83 E0 20 74 09 8B 4D FC 83 C9 01 89 4D FC 8B 55 08 83 E2 02 74 0B 8B 45 FC 0D 00 00 08 00 89 45 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_255_18_0 {
	meta:
		name = "___fpreset_sse2"
		size = 27
		refs = "0010 ___set_fpsr_sse2"
	strings:
		$1 = { 55 8B EC 51 C7 45 FC 80 1F 00 00 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_256_1_0 {
	meta:
		name = "?wcstoxl@@YAKPAUlocaleinfo_struct@@PB_WPAPB_WHH@Z"
		size = 1067
		refs = "0006 __ehhandler$?wcstoxl@@YAKPAUlocaleinfo_struct@@PB_WPAPB_WHH@Z 0015 ___security_cookie 002d ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0059 ??_C@_1BK@LAOAACLJ@?$AAn?$AAp?$AAt?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0062 ??_C@_1BC@KCPEGNFM@?$AAw?$AAc?$AAs?$AAt?$AAo?$AAl?$AA?4?$AAc?$AA?$AA@ 0069 __CrtDbgReportW 007d __errno 0091 ??_C@_1BA@PCFLFGNC@?$AAw?$AAc?$AAs?$AAt?$AAo?$AAx?$AAl?$AA?$AA@ 009b __invalid_parameter 00b4 ??1_LocaleUpdate@@QAE@XZ 00ef ??_C@_1FE@CEHLKAHD@?$AAi?$AAb?$AAa?$AAs?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AA?$CI?$AA2?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAi?$AAb?$AAa?$AAs?$AAe?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAi?$AAb?$AAa@ 017a ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0187 __iswctype_l 01f6 __wchartodigit"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 40 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 8B 45 08 50 8D 4D D4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 83 7D 10 00 74 08 8B 4D 10 8B 55 0C 89 11 33 C0 83 7D 0C 00 0F 95 C0 89 45 CC 83 7D CC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 61 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D CC 00 75 44 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 61 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 C4 00 00 00 00 C7 45 FC FF FF FF FF 8D 4D D4 E8 ?? ?? ?? ?? 8B 45 C4 E9 5C 03 00 00 83 7D 14 00 74 15 83 7D 14 02 7C 06 83 7D 14 24 7E 09 C7 45 B8 00 00 00 00 EB 07 C7 45 B8 01 00 00 00 8B 55 B8 89 55 C8 83 7D C8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 62 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D C8 00 75 44 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 62 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 C0 00 00 00 00 C7 45 FC FF FF FF FF 8D 4D D4 E8 ?? ?? ?? ?? 8B 45 C0 E9 C6 02 00 00 8B 4D 0C 89 4D F0 C7 45 D0 00 00 00 00 8B 55 F0 66 8B 02 66 89 45 E4 8B 4D F0 83 C1 02 89 4D F0 8D 4D D4 E8 ?? ?? ?? ?? 50 6A 08 66 8B 55 E4 52 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 15 8B 45 F0 66 8B 08 66 89 4D E4 8B 55 F0 83 C2 02 89 55 F0 EB CF 0F B7 45 E4 83 F8 2D 75 1E 8B 4D 18 83 C9 02 89 4D 18 8B 55 F0 66 8B 02 66 89 45 E4 8B 4D F0 83 C1 02 89 4D F0 EB 1C 0F B7 55 E4 83 FA 2B 75 13 8B 45 F0 66 8B 08 66 89 4D E4 8B 55 F0 83 C2 02 89 55 F0 83 7D 14 00 75 40 66 8B 45 E4 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 09 C7 45 14 0A 00 00 00 EB 26 8B 4D F0 0F B7 11 83 FA 78 74 0B 8B 45 F0 0F B7 08 83 F9 58 75 09 C7 45 14 10 00 00 00 EB 07 C7 45 14 08 00 00 00 83 7D 14 10 75 43 66 8B 55 E4 52 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 32 8B 45 F0 0F B7 08 83 F9 78 74 0B 8B 55 F0 0F B7 02 83 F8 58 75 1C 8B 4D F0 83 C1 02 89 4D F0 8B 55 F0 66 8B 02 66 89 45 E4 8B 4D F0 83 C1 02 89 4D F0 83 C8 FF 33 D2 F7 75 14 89 45 E8 66 8B 55 E4 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 EC 83 7D EC FF 74 02 EB 56 0F B7 45 E4 83 F8 41 7C 09 0F B7 4D E4 83 F9 5A 7E 12 0F B7 55 E4 83 FA 61 7C 39 0F B7 45 E4 83 F8 7A 7F 30 0F B7 4D E4 83 F9 61 7C 15 0F B7 55 E4 83 FA 7A 7F 0C 0F B7 45 E4 83 E8 20 89 45 B4 EB 07 0F B7 4D E4 89 4D B4 8B 55 B4 83 EA 37 89 55 EC EB 02 EB 68 8B 45 EC 3B 45 14 72 02 EB 5E 8B 4D 18 83 C9 08 89 4D 18 8B 55 D0 3B 55 E8 72 15 8B 45 D0 3B 45 E8 75 1C 83 C8 FF 33 D2 F7 75 14 39 55 EC 77 0F 8B 4D D0 0F AF 4D 14 03 4D EC 89 4D D0 EB 11 8B 55 18 83 CA 04 89 55 18 83 7D 10 00 75 02 EB 18 8B 45 F0 66 8B 08 66 89 4D E4 8B 55 F0 83 C2 02 89 55 F0 E9 2A FF FF FF 8B 45 F0 83 E8 02 89 45 F0 8B 4D 18 83 E1 08 75 15 83 7D 10 00 74 06 8B 55 0C 89 55 F0 C7 45 D0 00 00 00 00 EB 66 8B 45 18 83 E0 04 75 2A 8B 4D 18 83 E1 01 75 56 8B 55 18 83 E2 02 74 09 81 7D D0 00 00 00 80 77 11 8B 45 18 83 E0 02 75 3D 81 7D D0 FF FF FF 7F 76 34 E8 ?? ?? ?? ?? C7 00 22 00 00 00 8B 4D 18 83 E1 01 74 09 C7 45 D0 FF FF FF FF EB 18 8B 55 18 83 E2 02 74 09 C7 45 D0 00 00 00 80 EB 07 C7 45 D0 FF FF FF 7F 83 7D 10 00 74 08 8B 45 10 8B 4D F0 89 08 8B 55 18 83 E2 02 74 08 8B 45 D0 F7 D8 89 45 D0 8B 4D D0 89 4D BC C7 45 FC FF FF FF FF 8D 4D D4 E8 ?? ?? ?? ?? 8B 45 BC 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_256_3_0 {
	meta:
		name = "__ehhandler$?wcstoxl@@YAKPAUlocaleinfo_struct@@PB_WPAPB_WHH@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?wcstoxl@@YAKPAUlocaleinfo_struct@@PB_WPAPB_WHH@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A BC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_492_1 {
	meta:
		name = "__ehhandler$?_Init@?$_Mpunct@D@std@@IAEXABV_Locinfo@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Init@?$_Mpunct@D@std@@IAEXABV_Locinfo@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A BC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_47_1537_1 {
	meta:
		name = "__ehhandler$?_Init@?$_Mpunct@G@std@@IAEXABV_Locinfo@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Init@?$_Mpunct@G@std@@IAEXABV_Locinfo@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A BC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_47_1478_1 {
	meta:
		name = "__ehhandler$?_Init@?$_Mpunct@_W@std@@IAEXABV_Locinfo@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Init@?$_Mpunct@_W@std@@IAEXABV_Locinfo@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A BC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_257_0_0 {
	meta:
		name = "__heapused"
		size = 18
		refs = "0004 __errno"
	strings:
		$1 = { 55 8B EC E8 ?? ?? ?? ?? C7 00 28 00 00 00 33 C0 5D C3 }
	condition:
		$1
}

rule file_258_0_0 {
	meta:
		name = "___libm_sse2_log10f"
		size = 377
		refs = "0004 _dword_mask 000c _SIGMASK 0018 _EXPMASK 0039 _cv 0077 _B_table 00a8 _T_Tbl 00cc _L102 010e _pow2_64 0152 _SNAN 015f _One 016b _NEG_INF"
	strings:
		$1 = { F3 0F 10 25 ?? ?? ?? ?? 66 0F 12 0D ?? ?? ?? ?? 66 0F DB C4 66 0F 12 1D ?? ?? ?? ?? 66 0F 6F F8 66 0F C5 C0 01 0F 28 E0 66 0F 73 F0 1D 66 0F 54 C8 66 0F 56 CB 66 0F 12 2D ?? ?? ?? ?? 66 0F 12 35 ?? ?? ?? ?? 66 0F 12 15 ?? ?? ?? ?? 8B D0 B9 7F 7F 00 00 2B CA 81 EA 80 00 00 00 0B D1 81 FA 00 80 00 00 0F 83 87 00 00 00 B9 3F 3F 00 00 66 0F 6E C1 66 0F 12 1D ?? ?? ?? ?? 83 E0 7F 83 C0 01 25 FE 00 00 00 03 C0 03 C0 66 0F 12 B8 ?? ?? ?? ?? 66 0F 73 D4 10 66 0F FA E0 66 0F 72 E4 07 F3 0F E6 E4 66 0F 12 80 ?? ?? ?? ?? F2 0F 59 CF F2 0F 5C CB F2 0F 10 F9 F2 0F 59 E9 F2 0F 10 D9 F2 0F 59 C9 F2 0F 58 EE F2 0F 59 25 ?? ?? ?? ?? F2 0F 59 F9 F2 0F 59 D1 F2 0F 58 D3 F2 0F 59 FD F2 0F 58 C4 F2 0F 58 D7 F2 0F 58 C2 66 0F 5A C0 C3 66 0F 7E FA 81 FA 00 00 00 80 73 37 81 FA 00 00 80 7F 73 6B 83 FA 00 74 51 F3 0F 59 25 ?? ?? ?? ?? 66 0F 12 0D ?? ?? ?? ?? 66 0F C5 C4 01 0F 5A C4 66 0F 54 C8 66 0F 56 CB B9 3F 5F 00 00 E9 3B FF FF FF 81 FA 00 00 00 80 74 1F 81 E2 FF FF FF 7F 81 FA 01 00 80 7F 73 26 F3 0F 10 C7 F3 0F 10 0D ?? ?? ?? ?? F3 0F 58 C1 C3 F3 0F 10 0D ?? ?? ?? ?? F3 0F 5E CF F3 0F 10 05 ?? ?? ?? ?? C3 F3 0F 10 C7 F3 0F 58 C0 C3 }
	condition:
		$1
}

rule file_259_0_0 {
	meta:
		name = "_longjmp"
		size = 177
		refs = "0038 __except_list 0044 _lj_return 004a _RtlUnwind@16 005a __rt_probe_read4@4 007e __local_unwind2 008b __NLG_Notify"
	strings:
		$1 = { 55 8B EC 83 EC 50 8B 5C 24 58 C7 45 B0 26 00 00 80 C7 45 B4 00 00 00 00 C7 45 B8 00 00 00 00 C7 45 BC 00 00 00 00 C7 45 C0 00 00 00 00 8D 45 B0 8B 2B 8B 73 18 64 3B 35 ?? ?? ?? ?? 74 12 53 56 6A 00 50 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 5E 5B 83 FE 00 74 30 8D 43 20 50 E8 ?? ?? ?? ?? 0B C0 74 16 8B 43 20 3D 30 32 43 56 75 0C 8B 43 24 0B C0 74 12 53 FF D0 EB 0D 8B 43 1C 50 56 E8 ?? ?? ?? ?? 83 C4 08 6A 00 8B 43 14 E8 ?? ?? ?? ?? 8B D3 8B 5A 04 8B 7A 08 8B 72 0C 8B 44 24 5C 83 F8 01 83 D0 00 8B 62 10 83 C4 04 FF 62 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_260_0_0 {
	meta:
		name = "_strncpy_s"
		size = 1001
		refs = "0048 ??_C@_1FC@NCPEPIBI@?$AA?$CI?$AA?$CI?$AA_?$AAD?$AAs?$AAt?$AA?$CJ?$AA?$CJ?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?$CI?$AA_?$AAS?$AAi?$AAz?$AAe?$AAI?$AAn?$AAB?$AAy?$AAt@ 0051 ??_C@_1GM@MGKGJLGA@?$AAF?$AA?3?$AA?2?$AAR?$AAT?$AAM?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAS?$AAE?$AAL?$AAF?$AA_?$AAX?$AA8?$AA6?$AA?2@ 0058 __CrtDbgReportW 006c __errno 0080 ??_C@_1BE@NDMJHJJG@?$AAs?$AAt?$AAr?$AAn?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$AA@ 008a __invalid_parameter 00c4 ___crtDebugFillThreshold 00ef _memset 016f ??_C@_1CG@OFBJMIGJ@?$AA?$CI?$AA?$CI?$AA?$CI?$AA_?$AAS?$AAr?$AAc?$AA?$CJ?$AA?$CJ?$AA?$CJ?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 020a __CrtGetCheckCount 021b ??_C@_1CI@HCPHDDLE@?$AAB?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AAi?$AAs?$AA?5?$AAt?$AAo?$AAo?$AA?5?$AAs?$AAm?$AAa?$AAl?$AAl?$AA?$AA@ 0325 ??_C@_1DM@MADKGDLO@?$AA?$CI?$AAL?$AA?$CC?$AAB?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AAi?$AAs?$AA?5?$AAt?$AAo?$AAo?$AA?5?$AAs?$AAm?$AAa?$AAl?$AAl?$AA?$CC?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA0?$AA?$CJ?$AA?$AA@"
	strings:
		$1 = { 55 8B EC 83 EC 2C 83 7D 14 00 75 13 83 7D 08 00 75 0D 83 7D 0C 00 75 07 33 C0 E9 C6 03 00 00 83 7D 08 00 74 0F 83 7D 0C 00 76 09 C7 45 E8 01 00 00 00 EB 07 C7 45 E8 00 00 00 00 8B 45 E8 89 45 F4 83 7D F4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 18 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F4 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 18 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 4A 03 00 00 83 7D 14 00 75 5C 8B 55 08 C6 02 00 83 7D 0C FF 74 49 81 7D 0C FF FF FF 7F 74 40 83 7D 0C 01 76 3A 8B 45 0C 83 E8 01 39 05 ?? ?? ?? ?? 73 0B 8B 0D ?? ?? ?? ?? 89 4D E4 EB 09 8B 55 0C 83 EA 01 89 55 E4 8B 45 E4 50 68 FD 00 00 00 8B 4D 08 83 C1 01 51 E8 ?? ?? ?? ?? 83 C4 0C 33 C0 E9 E8 02 00 00 83 7D 10 00 0F 85 BB 00 00 00 8B 55 08 C6 02 00 83 7D 0C FF 74 49 81 7D 0C FF FF FF 7F 74 40 83 7D 0C 01 76 3A 8B 45 0C 83 E8 01 39 05 ?? ?? ?? ?? 73 0B 8B 0D ?? ?? ?? ?? 89 4D E0 EB 09 8B 55 0C 83 EA 01 89 55 E0 8B 45 E0 50 68 FD 00 00 00 8B 4D 08 83 C1 01 51 E8 ?? ?? ?? ?? 83 C4 0C 33 D2 83 7D 10 00 0F 95 C2 89 55 F0 83 7D F0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 1F 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 1F 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 23 02 00 00 8B 4D 08 89 4D FC 8B 55 0C 89 55 F8 83 7D 14 FF 75 35 8B 45 FC 8B 4D 10 8A 11 88 10 8B 45 FC 0F BE 08 8B 55 FC 83 C2 01 89 55 FC 8B 45 10 83 C0 01 89 45 10 85 C9 74 0D 8B 4D F8 83 E9 01 89 4D F8 74 02 EB CD EB 79 E8 ?? ?? ?? ?? 85 C0 74 26 8B 55 14 3B 55 0C 72 1E 68 ?? ?? ?? ?? 6A 00 6A 2B 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 8B 4D FC 8B 55 10 8A 02 88 01 8B 4D FC 0F BE 11 8B 45 FC 83 C0 01 89 45 FC 8B 4D 10 83 C1 01 89 4D 10 85 D2 74 18 8B 55 F8 83 EA 01 89 55 F8 74 0D 8B 45 14 83 E8 01 89 45 14 74 02 EB C2 83 7D 14 00 75 06 8B 4D FC C6 01 00 83 7D F8 00 0F 85 E9 00 00 00 83 7D 14 FF 75 14 8B 55 08 03 55 0C C6 42 FF 00 B8 50 00 00 00 E9 3F 01 00 00 8B 45 08 C6 00 00 83 7D 0C FF 74 49 81 7D 0C FF FF FF 7F 74 40 83 7D 0C 01 76 3A 8B 4D 0C 83 E9 01 39 0D ?? ?? ?? ?? 73 0B 8B 15 ?? ?? ?? ?? 89 55 DC EB 09 8B 45 0C 83 E8 01 89 45 DC 8B 4D DC 51 68 FD 00 00 00 8B 55 08 83 C2 01 52 E8 ?? ?? ?? ?? 83 C4 0C B8 ?? ?? ?? ?? 85 C0 74 0D 33 C9 74 09 C7 45 D8 01 00 00 00 EB 07 C7 45 D8 00 00 00 00 8B 55 D8 89 55 EC 83 7D EC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D EC 00 75 2D E8 ?? ?? ?? ?? C7 00 22 00 00 00 6A 00 6A 3E 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 22 00 00 00 EB 70 83 7D 0C FF 74 68 81 7D 0C FF FF FF 7F 74 5F 8B 4D 0C 2B 4D F8 83 C1 01 3B 4D 0C 73 51 8B 55 0C 2B 55 F8 83 C2 01 8B 45 0C 2B C2 39 05 ?? ?? ?? ?? 73 0B 8B 0D ?? ?? ?? ?? 89 4D D4 EB 11 8B 55 0C 2B 55 F8 83 C2 01 8B 45 0C 2B C2 89 45 D4 8B 4D D4 51 68 FD 00 00 00 8B 55 0C 2B 55 F8 8B 45 08 8D 4C 10 01 51 E8 ?? ?? ?? ?? 83 C4 0C 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_262_0_0 {
	meta:
		name = "__ValidateEH3RN"
		size = 1325
		refs = "0006 __sehtable$__ValidateEH3RN 000b __except_handler4 001d ___security_cookie 0131 _nValidPages 0141 _rgValidPages 0170 __ValidateImageBase 0188 _ValidateScopeTableHandlers 01a2 __FindPESection 0201 _lModifying 030e __imp__VirtualQuery@12 0334 _fVersionCached 033d _osvi 034c __imp__GetVersionExA@4"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 98 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 89 65 E8 8B 45 08 8B 48 08 89 4D D0 8B 55 D0 83 E2 03 74 07 33 C0 E9 D0 04 00 00 64 A1 18 00 00 00 89 45 CC 8B 4D CC 8B 55 D0 3B 51 08 72 12 8B 45 CC 8B 4D D0 3B 48 04 73 07 33 C0 E9 AA 04 00 00 8B 55 08 8B 42 0C 89 45 BC 83 7D BC FF 75 0A B8 01 00 00 00 E9 91 04 00 00 C7 45 DC 00 00 00 00 C7 45 C4 00 00 00 00 EB 09 8B 4D C4 83 C1 01 89 4D C4 8B 55 C4 3B 55 BC 77 3D 8B 45 C4 6B C0 0C 8B 4D D0 8B 14 01 89 55 90 83 7D 90 FF 74 0F 8B 45 90 3B 45 C4 72 07 33 C0 E9 4C 04 00 00 8B 4D C4 6B C9 0C 8B 55 D0 83 7C 0A 04 00 74 07 C7 45 DC 01 00 00 00 EB B2 83 7D DC 00 74 20 8B 45 08 8B 4D CC 8B 50 F8 3B 51 08 72 0B 8B 45 08 8B 48 F8 3B 4D 08 72 07 33 C0 E9 0D 04 00 00 8B 55 D0 81 E2 00 F0 FF FF 89 55 B4 C7 45 B8 00 00 00 00 EB 09 8B 45 B8 83 C0 01 89 45 B8 8B 4D B8 3B 0D ?? ?? ?? ?? 0F 8D C7 01 00 00 8B 55 B8 8B 04 D5 ?? ?? ?? ?? 8B 0C D5 ?? ?? ?? ?? 89 45 D4 89 4D D8 8B 55 D4 3B 55 B4 0F 85 9F 01 00 00 8B 45 D8 89 45 C0 C7 45 FC 00 00 00 00 8B 4D C0 51 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 32 8B 55 BC 52 8B 45 D0 50 8B 4D C0 51 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 1A 8B 55 08 8B 42 04 2B 45 C0 50 8B 4D C0 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 0C C7 45 FC FE FF FF FF E9 49 01 00 00 C7 45 FC FE FF FF FF EB 2F 8B 55 EC 8B 02 8B 08 89 4D 8C 8B 55 8C 33 C0 81 FA 05 00 00 C0 0F 94 C0 C3 8B 65 E8 C7 45 FC FE FF FF FF E9 18 01 00 00 C7 45 FC FE FF FF FF 83 7D B8 00 0F 8E F8 00 00 00 B8 01 00 00 00 B9 ?? ?? ?? ?? 87 01 85 C0 0F 85 E4 00 00 00 8B 55 B8 8B 04 D5 ?? ?? ?? ?? 3B 45 B4 74 70 8B 0D ?? ?? ?? ?? 83 E9 01 89 4D B8 EB 09 8B 55 B8 83 EA 01 89 55 B8 83 7D B8 00 7C 2A 8B 45 B8 8B 0C C5 ?? ?? ?? ?? 3B 4D B4 75 19 8B 55 B8 8B 04 D5 ?? ?? ?? ?? 8B 0C D5 ?? ?? ?? ?? 89 45 D4 89 4D D8 EB 02 EB C7 83 7D B8 00 7D 23 83 3D ?? ?? ?? ?? 10 7D 0F 8B 15 ?? ?? ?? ?? 83 C2 01 89 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? 83 E8 01 89 45 B8 83 7D B8 00 7E 56 C7 45 C8 00 00 00 00 EB 09 8B 4D C8 83 C1 01 89 4D C8 8B 55 C8 3B 55 B8 7F 3C 8B 45 C8 8B 0C C5 ?? ?? ?? ?? 8B 14 C5 ?? ?? ?? ?? 89 4D E0 89 55 E4 8B 45 C8 8B 4D D4 89 0C C5 ?? ?? ?? ?? 8B 55 D8 89 14 C5 ?? ?? ?? ?? 8B 45 E0 89 45 D4 8B 4D E4 89 4D D8 EB B3 33 D2 B8 ?? ?? ?? ?? 87 10 B8 01 00 00 00 E9 1E 02 00 00 E9 21 FE FF FF 6A 1C 8D 4D 94 51 8B 55 D0 52 FF 15 ?? ?? ?? ?? 85 C0 75 0A B8 01 00 00 00 E9 FB 01 00 00 81 7D AC 00 00 00 01 74 59 81 7D AC 00 00 02 00 75 48 83 3D ?? ?? ?? ?? 00 75 23 C7 05 ?? ?? ?? ?? 94 00 00 00 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 74 0A C7 05 ?? ?? ?? ?? 01 00 00 00 83 3D ?? ?? ?? ?? 00 74 11 83 3D ?? ?? ?? ?? 01 74 08 83 C8 FF E9 A3 01 00 00 EB 08 83 C8 FF E9 99 01 00 00 8B 45 98 89 45 C0 8B 4D C0 51 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 08 83 C8 FF E9 7B 01 00 00 8B 55 A8 81 E2 CC 00 00 00 74 30 8B 45 D0 2B 45 C0 50 8B 4D C0 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 B0 83 7D B0 00 74 0D 8B 55 B0 8B 42 24 25 00 00 00 80 74 07 33 C0 E9 40 01 00 00 8B 4D BC 51 8B 55 D0 52 8B 45 C0 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 07 33 C0 E9 21 01 00 00 8B 4D 08 8B 51 04 2B 55 C0 52 8B 45 C0 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 07 33 C0 E9 00 01 00 00 B9 01 00 00 00 BA ?? ?? ?? ?? 87 0A 85 C9 0F 85 E7 00 00 00 A1 ?? ?? ?? ?? 89 45 B8 EB 09 8B 4D B8 83 E9 01 89 4D B8 83 7D B8 00 7E 13 8B 55 B8 8B 04 D5 ?? ?? ?? ?? 3B 45 B4 75 02 EB 02 EB DE 83 7D B8 00 0F 85 9B 00 00 00 83 3D ?? ?? ?? ?? 0F 7E 09 C7 45 88 0F 00 00 00 EB 09 8B 0D ?? ?? ?? ?? 89 4D 88 8B 55 88 89 55 B8 8B 45 B4 89 45 D4 8B 4D 98 89 4D D8 C7 45 C8 00 00 00 00 EB 09 8B 55 C8 83 C2 01 89 55 C8 8B 45 C8 3B 45 B8 7F 3C 8B 4D C8 8B 14 CD ?? ?? ?? ?? 8B 04 CD ?? ?? ?? ?? 89 55 E0 89 45 E4 8B 4D C8 8B 55 D4 89 14 CD ?? ?? ?? ?? 8B 45 D8 89 04 CD ?? ?? ?? ?? 8B 4D E0 89 4D D4 8B 55 E4 89 55 D8 EB B3 83 3D ?? ?? ?? ?? 10 7D 0D A1 ?? ?? ?? ?? 83 C0 01 A3 ?? ?? ?? ?? EB 0D 8B 4D B8 8B 55 98 89 14 CD ?? ?? ?? ?? 33 C0 B9 ?? ?? ?? ?? 87 01 B8 01 00 00 00 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_262_1_0 {
	meta:
		name = "_ValidateScopeTableHandlers"
		size = 325
		refs = "0087 __FindPESection"
	strings:
		$1 = { 55 8B EC 83 EC 1C C7 45 F4 00 00 00 00 C7 45 F8 FF FF FF FF 8B 45 10 89 45 FC EB 0F 8B 4D FC 6B C9 0C 8B 55 0C 8B 04 0A 89 45 FC 83 7D FC FF 0F 84 07 01 00 00 8B 4D FC 6B C9 0C 8B 55 0C 8B 44 0A 08 89 45 F0 8B 4D F0 2B 4D 08 81 E1 00 F0 FF FF 89 4D EC 8B 55 EC 3B 55 F8 74 5D 83 7D F4 00 74 1C 8B 45 F4 8B 4D EC 3B 48 0C 72 11 8B 55 F4 8B 42 0C 8B 4D F4 03 41 08 39 45 EC 72 35 8B 55 EC 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 F4 83 7D F4 00 75 07 33 C0 E9 A3 00 00 00 8B 4D F4 8B 51 24 81 E2 00 00 00 20 75 07 33 C0 E9 8E 00 00 00 8B 45 EC 89 45 F8 8B 4D FC 6B C9 0C 8B 55 0C 8B 44 0A 04 89 45 E8 83 7D E8 00 74 68 8B 4D E8 2B 4D 08 81 E1 00 F0 FF FF 89 4D E4 8B 55 E4 3B 55 F8 74 51 8B 45 F4 8B 4D E4 3B 48 0C 72 11 8B 55 F4 8B 42 0C 8B 4D F4 03 41 08 39 45 E4 72 2F 8B 55 E4 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 F4 83 7D F4 00 75 04 33 C0 EB 22 8B 4D F4 8B 51 24 81 E2 00 00 00 20 75 04 33 C0 EB 10 8B 45 E4 89 45 F8 E9 E0 FE FF FF B8 01 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_263_0_0 {
	meta:
		name = "__CIlog10_pentium4"
		size = 656
		refs = "0039 emask 0041 CC 0049 One 0051 Magic 0059 hi_mask 0077 CB_Tbl 007f T_Tbl 00e1 coeff 010d LOG10_2 0119 place_L 0180 Zero 01cf Infs 01fa Two52 024b ___libm_error_support"
	strings:
		$1 = { 55 8B EC 83 EC 08 83 E4 F0 DD 1C 24 F3 0F 7E 04 24 E8 08 00 00 00 C9 C3 66 0F 12 44 24 04 BA 00 00 00 00 66 0F 28 E8 66 0F 14 C0 66 0F 73 D5 34 66 0F C5 CD 00 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F 28 25 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 54 C1 66 0F 56 C3 66 0F 58 E0 66 0F C5 C4 00 25 F0 07 00 00 66 0F 28 A0 ?? ?? ?? ?? 66 0F 28 B8 ?? ?? ?? ?? 66 0F 54 F0 66 0F 5C C6 66 0F 59 F4 66 0F 5C F2 F2 0F 58 FE 66 0F 59 C4 66 0F 28 E0 66 0F 58 C6 81 E1 FF 0F 00 00 83 E9 01 81 F9 FD 07 00 00 0F 87 BE 00 00 00 81 E9 FE 03 00 00 03 CA F2 0F 2A F1 66 0F 14 F6 C1 E1 0A 03 C1 B9 10 00 00 00 BA 00 00 00 00 83 F8 00 0F 44 D1 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 D8 66 0F 28 15 ?? ?? ?? ?? 66 0F 59 C8 66 0F 59 DB 66 0F 58 CA 66 0F 28 15 ?? ?? ?? ?? F2 0F 59 DB 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 F5 66 0F 28 AA ?? ?? ?? ?? 66 0F 54 E5 66 0F 58 FE 66 0F 58 FC 66 0F 59 C8 F2 0F 59 D8 66 0F 58 CA 66 0F 28 15 ?? ?? ?? ?? 66 0F 59 D0 66 0F 28 F7 66 0F 15 F6 66 0F 59 CB 83 EC 10 66 0F 28 C1 66 0F 58 CA 66 0F 15 C0 F2 0F 58 C1 F2 0F 58 C6 F2 0F 58 C7 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 66 0F 12 44 24 04 66 0F 28 0D ?? ?? ?? ?? F2 0F C2 C8 00 66 0F C5 C1 00 83 F8 00 77 48 83 F9 FF 74 5E 81 F9 FE 07 00 00 77 6C 66 0F 12 44 24 04 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 54 C1 66 0F 56 C2 F2 0F C2 D0 00 66 0F C5 C2 00 83 F8 00 74 07 DD 05 ?? ?? ?? ?? C3 BA E9 03 00 00 EB 4F 66 0F 12 15 ?? ?? ?? ?? F2 0F 5E D0 66 0F 12 0D ?? ?? ?? ?? BA 08 00 00 00 EB 34 66 0F 12 0D ?? ?? ?? ?? F2 0F 59 C1 BA CC FF FF FF E9 17 FE FF FF 83 C1 01 81 E1 FF 07 00 00 81 F9 FF 07 00 00 73 3A 66 0F 57 C9 F2 0F 5E C9 BA 09 00 00 00 83 EC 1C 66 0F 13 4C 24 10 89 54 24 0C 8B D4 83 C2 10 89 54 24 08 83 C2 10 89 54 24 04 89 14 24 E8 ?? ?? ?? ?? DD 44 24 10 83 C4 1C C3 66 0F 12 54 24 04 66 0F 12 44 24 04 66 0F 7E D0 66 0F 73 D2 20 66 0F 7E D1 81 E1 FF FF 0F 00 0B C1 83 F8 00 74 A0 BA E9 03 00 00 EB A6 8D A4 24 00 00 00 00 05 00 00 00 00 }
	condition:
		$1
}

rule file_264_0_0 {
	meta:
		name = "__mbsnextc_l"
		size = 229
		refs = "0015 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 002c ??_C@_1BE@EEKACIGI@?$AAs?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0035 ??_C@_1BG@KHOBDCBD@?$AAm?$AAb?$AAs?$AAn?$AAe?$AAx?$AAt?$AAc?$AA?4?$AAc?$AA?$AA@ 003c __CrtDbgReportW 0050 __errno 0064 ??_C@_1BI@IOLGAJKA@?$AA_?$AAm?$AAb?$AAs?$AAn?$AAe?$AAx?$AAt?$AAc?$AA_?$AAl?$AA?$AA@ 006e __invalid_parameter 0080 ??1_LocaleUpdate@@QAE@XZ 008d ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ"
	strings:
		$1 = { 55 8B EC 83 EC 20 C7 45 FC 00 00 00 00 8B 45 0C 50 8D 4D EC E8 ?? ?? ?? ?? 33 C9 83 7D 08 00 0F 95 C1 89 4D E8 83 7D E8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 32 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E8 00 75 3A E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 32 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 E4 00 00 00 00 8D 4D EC E8 ?? ?? ?? ?? 8B 45 E4 EB 58 8D 4D EC E8 ?? ?? ?? ?? 8B 40 04 8B 4D 08 0F B6 11 0F B6 44 10 1D 83 E0 04 74 20 8B 4D 08 0F B6 51 01 85 D2 74 15 8B 45 08 0F B6 08 C1 E1 08 89 4D FC 8B 55 08 83 C2 01 89 55 08 8B 45 08 0F B6 08 03 4D FC 89 4D FC 8B 55 FC 89 55 E0 8D 4D EC E8 ?? ?? ?? ?? 8B 45 E0 8B E5 5D C3 }
	condition:
		$1
}

rule file_265_0_0 {
	meta:
		name = "__fdopen"
		size = 1337
		refs = "0006 __sehtable$__fdopen 000b __except_handler4 001d ___security_cookie 0043 ??_C@_1BK@HGLMNMEC@?$AAm?$AAo?$AAd?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 004c ??_C@_1BC@IELKHOFK@?$AAf?$AAd?$AAo?$AAp?$AAe?$AAn?$AA?4?$AAc?$AA?$AA@ 0053 __CrtDbgReportW 0067 __errno 007b ??_C@_1BA@FMAFIKI@?$AA_?$AAf?$AAd?$AAo?$AAp?$AAe?$AAn?$AA?$AA@ 0085 __invalid_parameter 00b6 __nhandle 00d9 ??_C@_1HC@KFLBHHBC@?$AA?$CI?$AAf?$AAi?$AAl?$AAe?$AAd?$AAe?$AAs?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AAu?$AAn?$AAs?$AAi?$AAg?$AAn?$AAe?$AAd?$AA?$CJ?$AAf?$AAi?$AAl?$AAe?$AAd@ 013b ___pioinfo 0153 ??_C@_1DG@LNNHNFHJ@?$AA?$CI?$AA_?$AAo?$AAs?$AAf?$AAi?$AAl?$AAe?$AA?$CI?$AAf?$AAi?$AAl?$AAe?$AAd?$AAe?$AAs?$AA?$CJ?$AA?5?$AA?$CG?$AA?5?$AAF?$AAO?$AAP?$AAE?$AAN?$AA?$CJ?$AA?$AA@ 0208 ??_C@_1DK@PKMJBLLN@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAf?$AAi?$AAl?$AAe?$AA?5?$AAo?$AAp?$AAe?$AAn?$AA?5?$AAm?$AAo?$AAd?$AAe?$AA?$CC?$AA?0?$AA0?$AA?$CJ?$AA?$AA@ 0271 __commode 02bb $LN56 02c2 $LN58 0404 ??_C@_1CI@KEDPFCAL@?$AA?$CI?$AA?$CK?$AAm?$AAo?$AAd?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$CJ?$AA?$AA@ 0458 __getstream 047c __cflush 04ad __unlock_file 04cc $LN20 04d0 $LN19 04d4 $LN16 04d8 $LN13 04dc $LN10 04e0 $LN7"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 B8 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 33 C0 83 7D 0C 00 0F 95 C0 89 45 D0 83 7D D0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 33 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D0 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 33 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 25 04 00 00 83 7D 08 FE 75 12 E8 ?? ?? ?? ?? C7 00 09 00 00 00 33 C0 E9 0D 04 00 00 83 7D 08 00 7C 14 8B 55 08 3B 15 ?? ?? ?? ?? 73 09 C7 45 B8 01 00 00 00 EB 07 C7 45 B8 00 00 00 00 8B 45 B8 89 45 CC 83 7D CC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 37 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D CC 00 75 2D E8 ?? ?? ?? ?? C7 00 09 00 00 00 6A 00 6A 37 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 8F 03 00 00 8B 55 08 C1 FA 05 8B 45 08 83 E0 1F 6B C0 28 8B 0C 95 ?? ?? ?? ?? 0F BE 54 01 04 83 E2 01 F7 DA 1B D2 F7 DA 89 55 C8 75 1E 68 ?? ?? ?? ?? 6A 00 6A 38 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D C8 00 75 2D E8 ?? ?? ?? ?? C7 00 09 00 00 00 6A 00 6A 38 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 15 03 00 00 8B 4D 0C 0F BE 11 83 FA 20 75 0B 8B 45 0C 83 C0 01 89 45 0C EB EA 8B 4D 0C 8A 11 88 55 B4 80 7D B4 61 74 17 80 7D B4 72 74 08 80 7D B4 77 74 0B EB 12 C7 45 E0 01 00 00 00 EB 7A C7 45 E0 02 00 00 00 EB 71 33 C0 74 09 C7 45 B0 01 00 00 00 EB 07 C7 45 B0 00 00 00 00 8B 4D B0 89 4D C4 83 7D C4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 4B 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D C4 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 4B 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 60 02 00 00 C7 45 D8 01 00 00 00 C7 45 DC 00 00 00 00 8B 45 DC 89 45 D4 8B 4D E0 0B 0D ?? ?? ?? ?? 89 4D E0 8B 55 0C 83 C2 01 89 55 0C 8B 45 0C 0F BE 08 85 C9 0F 84 4C 01 00 00 83 7D D8 00 0F 84 42 01 00 00 8B 55 0C 0F BE 02 89 45 AC 8B 4D AC 83 E9 20 89 4D AC 83 7D AC 54 0F 87 AA 00 00 00 8B 55 AC 0F B6 82 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? E9 0B 01 00 00 8B 4D E0 81 E1 80 00 00 00 74 09 C7 45 D8 00 00 00 00 EB 15 8B 55 E0 81 CA 80 00 00 00 89 55 E0 8B 45 E0 83 E0 FC 89 45 E0 E9 DD 00 00 00 83 7D D4 00 74 09 C7 45 D8 00 00 00 00 EB 07 C7 45 D4 01 00 00 00 E9 C2 00 00 00 83 7D DC 00 74 09 C7 45 D8 00 00 00 00 EB 13 C7 45 DC 01 00 00 00 8B 4D E0 81 C9 00 40 00 00 89 4D E0 E9 9B 00 00 00 83 7D DC 00 74 09 C7 45 D8 00 00 00 00 EB 13 C7 45 DC 01 00 00 00 8B 55 E0 81 E2 FF BF FF FF 89 55 E0 EB 77 33 C0 74 09 C7 45 A8 01 00 00 00 EB 07 C7 45 A8 00 00 00 00 8B 4D A8 89 4D C0 83 7D C0 00 75 21 68 ?? ?? ?? ?? 6A 00 68 86 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D C0 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 86 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 E2 00 00 00 E9 9D FE FF FF 8B 45 0C 0F BE 08 83 F9 20 75 0B 8B 55 0C 83 C2 01 89 55 0C EB EA 8B 45 0C 0F BE 08 F7 D9 1B C9 83 C1 01 89 4D BC 75 21 68 ?? ?? ?? ?? 6A 00 68 8F 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D BC 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 8F 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 61 E8 ?? ?? ?? ?? 89 45 E4 83 7D E4 00 75 0F E8 ?? ?? ?? ?? C7 00 18 00 00 00 33 C0 EB 44 C7 45 FC 00 00 00 00 A1 ?? ?? ?? ?? 83 C0 01 A3 ?? ?? ?? ?? 8B 4D E4 8B 55 E0 89 51 0C 8B 45 E4 8B 4D 08 89 48 10 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0D 8B 55 E4 52 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 E4 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 8B FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 05 05 05 05 05 05 05 05 05 05 01 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 02 03 05 05 05 05 05 05 05 05 05 05 04 05 05 05 05 05 02 }
	condition:
		$1
}

rule file_267_1_0 {
	meta:
		name = "__toupper_l"
		size = 466
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0023 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 004e __isctype_l 006a __chvalidator_l 0098 ??1_LocaleUpdate@@QAE@XZ 00e6 __isleadbyte_l 0114 __errno 016a ___crtLCMapStringA"
	strings:
		$1 = { 55 8B EC 83 EC 34 8B 45 0C 50 8D 4D E4 E8 ?? ?? ?? ?? 81 7D 08 00 01 00 00 0F 83 9D 00 00 00 8D 4D E4 E8 ?? ?? ?? ?? 85 C0 74 2F 8D 4D E4 E8 ?? ?? ?? ?? 8B 08 83 B9 AC 00 00 00 01 7E 1C 8D 4D E4 E8 ?? ?? ?? ?? 50 6A 02 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 89 45 CC EB 1A 6A 02 8B 45 08 50 8D 4D E4 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 0C 89 45 CC 83 7D CC 00 74 2C 8D 4D E4 E8 ?? ?? ?? ?? 8B 08 8B 91 D0 00 00 00 8B 45 08 0F B6 0C 02 89 4D E0 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 E0 E9 2A 01 00 00 EB 16 8B 55 08 89 55 DC 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 DC E9 12 01 00 00 8D 4D E4 E8 ?? ?? ?? ?? 8B 00 83 B8 AC 00 00 00 01 7E 44 8D 4D E4 E8 ?? ?? ?? ?? 50 8B 4D 08 C1 F9 08 81 E1 FF 00 00 00 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 22 8B 55 08 C1 FA 08 81 E2 FF 00 00 00 88 55 F8 8A 45 08 88 45 F9 C6 45 FA 00 C7 45 F4 02 00 00 00 EB 1C E8 ?? ?? ?? ?? C7 00 2A 00 00 00 8A 4D 08 88 4D F8 C6 45 F9 00 C7 45 F4 01 00 00 00 6A 01 8D 4D E4 E8 ?? ?? ?? ?? 8B 10 8B 42 04 50 6A 03 8D 4D FC 51 8B 55 F4 52 8D 45 F8 50 68 00 02 00 00 8D 4D E4 E8 ?? ?? ?? ?? 8B 08 8B 51 14 52 8D 4D E4 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 24 89 45 F4 83 7D F4 00 75 13 8B 45 08 89 45 D8 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 D8 EB 41 83 7D F4 01 75 16 0F B6 4D FC 89 4D D4 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 D4 EB 27 EB 1D 0F B6 55 FD 0F B6 45 FC C1 E0 08 0B D0 89 55 D0 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 D0 EB 08 8D 4D E4 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_267_5_0 {
	meta:
		name = "_toupper"
		size = 67
		refs = "0006 ___locale_changed 0038 __toupper_l"
	strings:
		$1 = { 55 8B EC 51 83 3D ?? ?? ?? ?? 00 75 24 83 7D 08 61 7C 11 83 7D 08 7A 7F 0B 8B 45 08 83 E8 20 89 45 FC EB 06 8B 4D 08 89 4D FC 8B 45 FC EB 10 EB 0E 6A 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_268_0_0 {
	meta:
		name = "__wspawnve"
		size = 1251
		refs = "0026 ??_C@_1BK@EILABNJE@?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0032 ??_C@_1GE@KAPBHMGE@?$AAf?$AA?3?$AA?2?$AAr?$AAt?$AAm?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2@ 0039 __CrtDbgReportW 004d __errno 0064 ??_C@_1BE@NOIMNAAA@?$AA_?$AAw?$AAs?$AAp?$AAa?$AAw?$AAn?$AAv?$AAe?$AA?$AA@ 006e __invalid_parameter 008f ??_C@_1CE@CONABGGG@?$AA?$CK?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 00f9 ??_C@_1BK@DKFDJEHE@?$AAa?$AAr?$AAg?$AAv?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0165 ??_C@_1BM@CNLEOMNN@?$AA?$CK?$AAa?$AAr?$AAg?$AAv?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 01d0 ??_C@_1CG@JGBGIIEL@?$AA?$CK?$AA?$CK?$AAa?$AAr?$AAg?$AAv?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 022e _wcsrchr 0264 _wcschr 027d _wcslen 0290 ??_C@_0DC@PIEFBDJC@f?3?2rtm?2vctools?2crt_bld?2self_x86?2@ 029d __calloc_dbg 02c7 ??_C@_1FE@EDEBHNHE@?$AAw?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAp?$AAa?$AAt?$AAh?$AAn?$AAa?$AAm?$AAe?$AA?0?$AA?5?$AAp?$AAa?$AAt?$AAh?$AAn?$AAa?$AAm?$AAe?$AA_?$AAs?$AAi?$AAz?$AAe@ 02cc ??_C@_15PCEAIKAA@?$AA?4?$AA?2?$AA?$AA@ 02d9 _wcscpy_s 02e2 __invoke_watson_if_error 02fb ??_C@_1FA@KFCDCBOG@?$AAw?$AAc?$AAs?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AAp?$AAa?$AAt?$AAh?$AAn?$AAa?$AAm?$AAe?$AA?0?$AA?5?$AAp?$AAa?$AAt?$AAh?$AAn?$AAa?$AAm?$AAe?$AA_?$AAs?$AAi?$AAz?$AAe@ 030c _wcscat_s 0360 __waccess_s 037c _wcomexecmd 03da ??_C@_1DI@MLPIPGLK@?$AAw?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAp?$AA?0?$AA?5?$AAs?$AAi?$AAz?$AAe?$AA?0?$AA?5?$AAp?$AAa?$AAt?$AAh?$AAn?$AAa?$AAm?$AAe?$AA?$CJ?$AA?$AA@ 0448 ??_C@_1GA@NDGMJEBK@?$AAw?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAe?$AAx?$AAt?$AA?0?$AA?5?$AAs?$AAi?$AAz?$AAe?$AA?5?$AA?9?$AA?5?$AA?$CI?$AAe?$AAx?$AAt?$AA?5?$AA?9?$AA?5?$AAp?$AA?$CJ?$AA?0?$AA?5@ 0452 _ext_strings 04bf __free_dbg"
	strings:
		$1 = { 55 8B EC 83 EC 38 8B 45 0C 89 45 F0 C7 45 E4 00 00 00 00 33 C9 83 7D 0C 00 0F 95 C1 89 4D E0 83 7D E0 00 75 21 68 ?? ?? ?? ?? 6A 00 68 DC 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 31 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 DC 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 62 04 00 00 8B 45 0C 0F B7 08 F7 D9 1B C9 F7 D9 89 4D DC 75 21 68 ?? ?? ?? ?? 6A 00 68 DD 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D DC 00 75 31 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 DD 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 F9 03 00 00 33 C0 83 7D 10 00 0F 95 C0 89 45 D8 83 7D D8 00 75 21 68 ?? ?? ?? ?? 6A 00 68 DE 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D8 00 75 31 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 DE 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 8F 03 00 00 8B 55 10 33 C0 83 3A 00 0F 95 C0 89 45 D4 83 7D D4 00 75 21 68 ?? ?? ?? ?? 6A 00 68 DF 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D4 00 75 31 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 DF 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 23 03 00 00 8B 55 10 8B 02 0F B7 08 F7 D9 1B C9 F7 D9 89 4D D0 75 21 68 ?? ?? ?? ?? 6A 00 68 E0 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D0 00 75 31 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 E0 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 B8 02 00 00 6A 5C 8B 45 F0 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 6A 2F 8B 4D F0 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 EC 83 7D EC 00 0F 85 D4 00 00 00 83 7D FC 00 0F 85 C8 00 00 00 6A 3A 8B 55 F0 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 0F 85 AD 00 00 00 8B 45 F0 50 E8 ?? ?? ?? ?? 83 C4 04 83 C0 03 89 45 CC 68 F3 00 00 00 68 ?? ?? ?? ?? 6A 02 6A 02 8B 4D CC 51 E8 ?? ?? ?? ?? 83 C4 14 89 45 F0 83 7D F0 00 75 08 83 C8 FF E9 2A 02 00 00 6A 00 68 F6 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 55 CC 52 8B 45 F0 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 F7 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 4D 0C 51 8B 55 CC 52 8B 45 F0 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 4D F0 83 C1 04 89 4D FC EB 14 83 7D FC 00 74 08 8B 55 EC 3B 55 FC 76 06 8B 45 EC 89 45 FC C7 45 F8 FF FF FF FF 6A 2E 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 E8 83 7D E8 00 74 32 6A 00 8B 55 F0 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 1B 8B 45 14 50 8B 4D 10 51 8B 55 F0 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 F8 E9 3B 01 00 00 8B 4D F0 51 E8 ?? ?? ?? ?? 83 C4 04 83 C0 05 89 45 C8 68 25 01 00 00 68 ?? ?? ?? ?? 6A 02 6A 02 8B 55 C8 52 E8 ?? ?? ?? ?? 83 C4 14 89 45 FC 83 7D FC 00 75 08 83 C8 FF E9 17 01 00 00 6A 00 68 28 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 45 F0 50 8B 4D C8 51 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 45 F0 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D FC 8D 14 41 89 55 E8 E8 ?? ?? ?? ?? 8B 00 89 45 E4 C7 45 F4 03 00 00 00 EB 09 8B 4D F4 83 E9 01 89 4D F4 83 7D F4 00 0F 8C 82 00 00 00 6A 00 68 2D 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 55 F4 8B 04 95 ?? ?? ?? ?? 50 8B 4D E8 2B 4D FC D1 F9 8B 55 C8 2B D1 52 8B 45 E8 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 27 E8 ?? ?? ?? ?? 8B 55 E4 89 10 8B 45 14 50 8B 4D 10 51 8B 55 FC 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 F8 EB 05 E9 6B FF FF FF 6A 02 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 8B 55 F0 3B 55 0C 74 0E 6A 02 8B 45 F0 50 E8 ?? ?? ?? ?? 83 C4 08 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_268_2_0 {
	meta:
		name = "_wcomexecmd"
		size = 303
		refs = "0019 ??_C@_1BK@EILABNJE@?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0022 ??_C@_1GE@KAPBHMGE@?$AAf?$AA?3?$AA?2?$AAr?$AAt?$AAm?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2@ 0029 __CrtDbgReportW 003d __errno 0051 ??_C@_1BG@DLIHJHNJ@?$AAw?$AAc?$AAo?$AAm?$AAe?$AAx?$AAe?$AAc?$AAm?$AAd?$AA?$AA@ 005b __invalid_parameter 007d ??_C@_1BK@DKFDJEHE@?$AAa?$AAr?$AAg?$AAv?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 00e0 __wcenvarg 0102 __wdospawn 0113 __free_dbg"
	strings:
		$1 = { 55 8B EC 83 EC 14 33 C0 83 7D 0C 00 0F 95 C0 89 45 F0 83 7D F0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 70 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 70 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 C1 00 00 00 33 D2 83 7D 10 00 0F 95 C2 89 55 EC 83 7D EC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 71 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D EC 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 71 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 60 8B 4D 0C 51 8D 55 F8 52 8D 45 F4 50 8B 4D 14 51 8B 55 10 52 E8 ?? ?? ?? ?? 83 C4 14 83 F8 FF 75 05 83 C8 FF EB 3A 8B 45 F8 50 8B 4D F4 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 FC 6A 02 8B 4D F4 51 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_616_2_0 {
	meta:
		name = "_comexecmd"
		size = 303
		refs = "0019 ??_C@_1BK@EILABNJE@?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0022 ??_C@_1BE@PHKIDLOG@?$AAs?$AAp?$AAa?$AAw?$AAn?$AAv?$AAe?$AA?4?$AAc?$AA?$AA@ 0029 __CrtDbgReportW 003d __errno 0051 ??_C@_1BE@BCIEHILB@?$AAc?$AAo?$AAm?$AAe?$AAx?$AAe?$AAc?$AAm?$AAd?$AA?$AA@ 005b __invalid_parameter 007d ??_C@_1BK@DKFDJEHE@?$AAa?$AAr?$AAg?$AAv?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 00e0 __cenvarg 0102 __dospawn 0113 __free_dbg"
	strings:
		$1 = { 55 8B EC 83 EC 14 33 C0 83 7D 0C 00 0F 95 C0 89 45 F0 83 7D F0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 70 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 70 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 C1 00 00 00 33 D2 83 7D 10 00 0F 95 C2 89 55 EC 83 7D EC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 71 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D EC 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 71 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 60 8B 4D 0C 51 8D 55 F8 52 8D 45 F4 50 8B 4D 14 51 8B 55 10 52 E8 ?? ?? ?? ?? 83 C4 14 83 F8 FF 75 05 83 C8 FF EB 3A 8B 45 F8 50 8B 4D F4 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 FC 6A 02 8B 4D F4 51 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_269_0_0 {
	meta:
		name = "___libm_sse2_atan2"
		size = 1302
		refs = "013d _a2 0145 _b2 0155 _P_TBL 015e _SGN_TBL 0176 _ATAN_TBL 0223 _P_TBL2 023c _SELECT_B 02d2 _SGNMASK 02da _pi_table 02f2 _pi2_table 032b _POW55 0338 _INVEXPMASK 0344 _EXPMASK 043a _pi4_table"
	strings:
		$1 = { 83 EC 14 66 0F C5 C0 03 25 F0 7F 00 00 66 0F 13 44 24 04 2D 70 38 00 00 3D 00 0F 00 00 66 0F 13 4C 24 0C 0F 87 D2 02 00 00 66 0F C5 C1 03 25 F0 7F 00 00 2D 70 38 00 00 3D 00 0F 00 00 0F 87 B8 02 00 00 66 0F 14 C1 66 0F 57 ED 66 0F 57 DB B8 00 08 00 00 66 0F C4 E8 03 66 0F FD E9 66 0F 73 D5 1D F3 0F 53 DD 66 0F 57 E4 B9 00 38 00 00 66 0F C4 E1 03 66 0F 73 F3 1D 66 0F FD DC F2 0F 59 D8 66 0F 57 D2 66 0F 57 F6 66 0F 57 FF B8 00 80 00 00 66 0F C4 F0 02 B9 FF 7F 00 00 66 0F C4 F9 03 66 0F FE DE 66 0F 54 DF F2 0F 10 EB 66 0F C5 C3 03 B9 40 40 00 00 66 0F C4 D1 03 F2 0F 5D DA 66 0F 50 D0 66 0F 73 F0 01 66 0F 73 D0 01 F2 0F C2 EA 02 66 0F 73 F1 01 66 0F 73 D1 01 F2 0F 10 F1 F2 0F 10 F9 F2 0F 10 D0 B9 00 00 00 00 66 0F C4 F1 00 F2 0F 5C FE F2 0F 10 E0 F2 0F 59 F3 F2 0F 59 E3 F2 0F 59 FB 66 0F 54 C5 F2 0F 5C C6 66 0F 54 CD F2 0F 58 E1 F2 0F 5C C7 25 F0 7F 00 00 2D 9E 3F 00 00 3D 61 04 00 00 0F 87 AE 00 00 00 F2 0F 5E C4 66 0F C5 CB 03 66 0F 12 15 ?? ?? ?? ?? 66 0F 12 1D ?? ?? ?? ?? 66 0F C5 C5 00 03 D2 66 0F 28 34 D5 ?? ?? ?? ?? 66 0F 28 0C D5 ?? ?? ?? ?? 81 E9 9E 3F 00 00 F7 D0 83 E0 01 03 C8 03 C9 66 0F 28 2C CD ?? ?? ?? ?? 66 0F 57 E9 66 0F 58 EE F2 0F 10 F5 66 0F 15 ED 83 C4 14 66 0F 57 C8 F2 0F 10 E1 F2 0F 59 C0 F2 0F 59 D0 F2 0F 58 D8 F2 0F 58 CE F2 0F 5C F1 F2 0F 58 F4 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D8 F2 0F 59 E0 F2 0F 58 F5 F2 0F 59 D4 F2 0F 58 1D ?? ?? ?? ?? F2 0F 59 D3 F2 0F 58 D6 F2 0F 58 CA 66 0F 28 C1 C3 05 AE 03 00 00 3D AE 03 00 00 0F 87 A3 00 00 00 66 0F 57 E4 B9 F0 3F 00 00 66 0F C4 E1 03 F2 0F 5E E1 83 C4 14 03 D2 66 0F 28 34 D5 ?? ?? ?? ?? 66 0F 14 DB 66 0F 57 C6 66 0F 57 D6 66 0F 57 DE 66 0F 28 3C D5 ?? ?? ?? ?? 66 0F 12 0D ?? ?? ?? ?? 66 0F 12 2D ?? ?? ?? ?? 66 0F 54 1C D5 ?? ?? ?? ?? F2 0F 59 D4 F2 0F 59 C4 F2 0F 10 F2 F2 0F 59 D2 F2 0F 59 CA F2 0F 58 EA F2 0F 59 F2 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 EA F2 0F 58 F8 66 0F 58 FB F2 0F 59 CE F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 E9 F2 0F 58 EF 66 0F 15 FF F2 0F 58 EF 66 0F 28 C5 C3 66 0F 12 4C 24 0C 66 0F 12 44 24 04 66 0F C5 C1 03 25 F0 7F 00 00 66 0F C5 C8 03 81 E1 F0 7F 00 00 3B C8 7F 2D 66 0F C5 C9 03 81 F9 FF 7F 00 00 7F 08 83 C4 14 F2 0F 5E C1 C3 83 C4 14 66 0F 54 05 ?? ?? ?? ?? 66 0F 12 15 ?? ?? ?? ?? 66 0F 57 C2 C3 83 C4 14 66 0F 54 05 ?? ?? ?? ?? 66 0F 12 15 ?? ?? ?? ?? 66 0F 57 C2 C3 66 0F C5 C8 03 81 E1 F0 7F 00 00 66 0F C5 C1 03 25 F0 7F 00 00 81 F9 F0 7F 00 00 0F 84 A5 00 00 00 3D F0 7F 00 00 0F 84 52 01 00 00 66 0F 12 1D ?? ?? ?? ?? BA 00 04 00 00 66 0F 12 25 ?? ?? ?? ?? 66 0F 57 F6 66 0F 12 3D ?? ?? ?? ?? 83 F9 00 74 35 83 F8 00 74 50 03 D1 2B D0 81 FA 00 08 00 00 0F 87 2F FF FF FF 81 C2 F0 3B 00 00 66 0F C4 F2 03 66 0F 54 C4 66 0F 54 CC 66 0F 56 C6 66 0F 56 CF E9 C1 FC FF FF 81 EA 70 03 00 00 F2 0F 59 C3 66 0F C5 C8 03 81 E1 F0 7F 00 00 83 F9 00 0F 84 2A 01 00 00 EB AB 81 C2 70 03 00 00 F2 0F 59 CB 66 0F C5 C1 03 25 F0 7F 00 00 83 F8 00 0F 84 34 01 00 00 EB 91 66 0F 7E C2 F2 0F 10 D0 66 0F 73 D2 20 66 0F 7E D1 81 E1 FF FF 0F 00 0B CA 83 F9 00 75 26 66 0F 73 D0 3F 66 0F 73 F0 3F 3D F0 7F 00 00 73 19 66 0F 28 2D ?? ?? ?? ?? 66 0F 70 E5 EE F2 0F 58 EC 66 0F 56 C5 83 C4 14 C3 66 0F 7E C8 F2 0F 10 D1 66 0F 73 D2 20 66 0F 7E D1 BA 00 00 00 80 23 D1 81 E1 FF FF 0F 00 0B C8 83 F9 00 75 1E 83 FA 00 75 21 83 C4 14 66 0F 28 2D ?? ?? ?? ?? 66 0F 70 E5 EE F2 0F 58 EC 66 0F 56 C5 C3 83 C4 14 F2 0F 10 C1 C3 83 C4 14 66 0F 28 2D ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 58 EE 66 0F 70 F5 EE 66 0F 58 EE 66 0F 56 C5 C3 66 0F 7E C8 F2 0F 10 D1 66 0F 73 D2 20 66 0F 7E D1 BA 00 00 00 80 23 D1 81 E1 FF FF 0F 00 0B C8 83 F9 00 75 AE 66 0F 73 D0 3F 66 0F 73 F0 3F 83 FA 00 75 04 83 C4 14 C3 83 C4 14 66 0F 28 2D ?? ?? ?? ?? 66 0F 70 E5 EE F2 0F 58 EC 66 0F 56 C5 C3 66 0F C5 D1 03 81 E2 00 80 00 00 83 FA 00 74 15 66 0F 28 2D ?? ?? ?? ?? 66 0F 70 E5 EE F2 0F 58 EC 66 0F 56 C5 83 C4 14 C3 83 C4 14 66 0F 28 2D ?? ?? ?? ?? 66 0F 73 D0 3F 66 0F 73 F0 3F 66 0F 70 E5 EE F2 0F 58 EC 66 0F 56 C5 C3 }
	condition:
		$1
}

rule file_270_0_0 {
	meta:
		name = "_wcschr"
		size = 61
	strings:
		$1 = { 55 8B EC 8B 45 08 0F B7 08 85 C9 74 19 8B 55 08 0F B7 02 0F B7 4D 0C 3B C1 74 0B 8B 55 08 83 C2 02 89 55 08 EB DD 8B 45 08 0F B7 08 0F B7 55 0C 3B CA 75 05 8B 45 08 EB 02 33 C0 5D C3 }
	condition:
		$1
}

rule file_272_0_0 {
	meta:
		name = "__openfile"
		size = 1785
		refs = "0007 __commode 002a ??_C@_1CC@JBMDNKJP@?$AAf?$AAi?$AAl?$AAe?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0033 ??_C@_1BA@ENGOOAMJ@?$AA_?$AAo?$AAp?$AAe?$AAn?$AA?4?$AAc?$AA?$AA@ 003a __CrtDbgReportW 004e ??_C@_1BK@HGLMNMEC@?$AAm?$AAo?$AAd?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0072 ??_C@_1BI@MFCLPIBM@?$AAs?$AAt?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 011e ??_C@_1DK@PKMJBLLN@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAf?$AAi?$AAl?$AAe?$AA?5?$AAo?$AAp?$AAe?$AAn?$AA?5?$AAm?$AAo?$AAd?$AAe?$AA?$CC?$AA?0?$AA0?$AA?$CJ?$AA?$AA@ 0142 __errno 0156 ??_C@_1BE@DONHJJKE@?$AA_?$AAo?$AAp?$AAe?$AAn?$AAf?$AAi?$AAl?$AAe?$AA?$AA@ 0160 __invalid_parameter 01b8 $LN80 01bf $LN81 03ea ?ccsField@?P@??_openfile@@9@9 03ef __mbsnbcmp 047b ?utf8encoding@?P@??_openfile@@9@9 0484 __mbsicmp 04a9 ?utf16encoding@?P@??_openfile@@9@9 04d7 ?unicodeencoding@?P@??_openfile@@9@9 05a1 ??_C@_1CI@KEDPFCAL@?$AA?$CI?$AA?$CK?$AAm?$AAo?$AAd?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$CJ?$AA?$AA@ 060a __sopen_s 061b __cflush 0670 $LN48 0674 $LN47 0678 $LN19 067c $LN23 0680 $LN20 0684 $LN29 0688 $LN32 068c $LN26 0690 $LN44 0694 $LN38 0698 $LN35 069c $LN41 06a0 $LN18"
	strings:
		$1 = { 55 8B EC 83 EC 4C A1 ?? ?? ?? ?? 89 45 EC C7 45 E4 00 00 00 00 C7 45 E8 00 00 00 00 C7 45 F0 00 00 00 00 83 7D 08 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 44 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D 0C 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 45 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D 14 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 46 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 8B 4D 0C 0F BE 11 83 FA 20 75 0B 8B 45 0C 83 C0 01 89 45 0C EB EA 8B 4D 0C 8A 11 88 55 C8 80 7D C8 61 74 38 80 7D C8 72 74 08 80 7D C8 77 74 17 EB 3C C7 45 F4 00 00 00 00 8B 45 EC 83 C8 01 89 45 EC E9 98 00 00 00 C7 45 F4 01 03 00 00 8B 4D EC 83 C9 02 89 4D EC E9 83 00 00 00 C7 45 F4 09 01 00 00 8B 55 EC 83 CA 02 89 55 EC EB 71 33 C0 74 09 C7 45 C4 01 00 00 00 EB 07 C7 45 C4 00 00 00 00 8B 4D C4 89 4D DC 83 7D DC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 62 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D DC 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 62 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 FC 04 00 00 C7 45 E0 01 00 00 00 8B 45 0C 83 C0 01 89 45 0C 8B 4D 0C 0F BE 11 85 D2 0F 84 37 02 00 00 83 7D E0 00 0F 84 2D 02 00 00 8B 45 0C 0F BE 08 89 4D C0 8B 55 C0 83 EA 20 89 55 C0 83 7D C0 54 0F 87 95 01 00 00 8B 45 C0 0F B6 88 ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? E9 F6 01 00 00 8B 55 F4 83 E2 02 74 09 C7 45 E0 00 00 00 00 EB 27 8B 45 F4 83 C8 02 89 45 F4 8B 4D F4 83 E1 FE 89 4D F4 8B 55 EC 81 CA 80 00 00 00 89 55 EC 8B 45 EC 83 E0 FC 89 45 EC E9 B9 01 00 00 8B 4D F4 81 E1 00 C0 00 00 74 09 C7 45 E0 00 00 00 00 EB 0C 8B 55 F4 81 CA 00 80 00 00 89 55 F4 E9 94 01 00 00 8B 45 F4 25 00 C0 00 00 74 09 C7 45 E0 00 00 00 00 EB 0C 8B 4D F4 81 C9 00 40 00 00 89 4D F4 E9 70 01 00 00 83 7D E4 00 74 09 C7 45 E0 00 00 00 00 EB 13 C7 45 E4 01 00 00 00 8B 55 EC 81 CA 00 40 00 00 89 55 EC E9 49 01 00 00 83 7D E4 00 74 09 C7 45 E0 00 00 00 00 EB 12 C7 45 E4 01 00 00 00 8B 45 EC 25 FF BF FF FF 89 45 EC E9 23 01 00 00 83 7D E8 00 74 09 C7 45 E0 00 00 00 00 EB 10 C7 45 E8 01 00 00 00 8B 4D F4 83 C9 20 89 4D F4 E9 FF 00 00 00 83 7D E8 00 74 09 C7 45 E0 00 00 00 00 EB 10 C7 45 E8 01 00 00 00 8B 55 F4 83 CA 10 89 55 F4 E9 DB 00 00 00 8B 45 F4 25 00 10 00 00 74 09 C7 45 E0 00 00 00 00 EB 0C 8B 4D F4 81 C9 00 10 00 00 89 4D F4 E9 B7 00 00 00 8B 55 F4 83 E2 40 74 09 C7 45 E0 00 00 00 00 EB 09 8B 45 F4 83 C8 40 89 45 F4 E9 98 00 00 00 8B 4D F4 81 C9 80 00 00 00 89 4D F4 E9 87 00 00 00 C7 45 F0 01 00 00 00 C7 45 E0 00 00 00 00 EB 77 33 D2 74 09 C7 45 BC 01 00 00 00 EB 07 C7 45 BC 00 00 00 00 8B 45 BC 89 45 D8 83 7D D8 00 75 21 68 ?? ?? ?? ?? 6A 00 68 C9 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D8 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 C9 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 AC 02 00 00 E9 B2 FD FF FF 83 7D F0 00 0F 84 AB 01 00 00 8B 55 0C 0F BE 02 83 F8 20 75 0B 8B 4D 0C 83 C1 01 89 4D 0C EB EA 6A 04 8B 55 0C 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 77 33 C0 74 09 C7 45 B8 01 00 00 00 EB 07 C7 45 B8 00 00 00 00 8B 4D B8 89 4D D4 83 7D D4 00 75 21 68 ?? ?? ?? ?? 6A 00 68 DD 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D4 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 DD 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 F9 01 00 00 8B 45 0C 83 C0 04 89 45 0C 68 ?? ?? ?? ?? 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 19 8B 55 0C 83 C2 05 89 55 0C 8B 45 F4 0D 00 00 04 00 89 45 F4 E9 D0 00 00 00 68 ?? ?? ?? ?? 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 19 8B 55 0C 83 C2 08 89 55 0C 8B 45 F4 0D 00 00 02 00 89 45 F4 E9 A2 00 00 00 68 ?? ?? ?? ?? 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 16 8B 55 0C 83 C2 07 89 55 0C 8B 45 F4 0D 00 00 01 00 89 45 F4 EB 77 33 C9 74 09 C7 45 B4 01 00 00 00 EB 07 C7 45 B4 00 00 00 00 8B 55 B4 89 55 D0 83 7D D0 00 75 21 68 ?? ?? ?? ?? 6A 00 68 EE 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D0 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 EE 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 F2 00 00 00 8B 4D 0C 0F BE 11 83 FA 20 75 0B 8B 45 0C 83 C0 01 89 45 0C EB EA 8B 4D 0C 0F BE 11 F7 DA 1B D2 83 C2 01 89 55 CC 75 21 68 ?? ?? ?? ?? 6A 00 68 F8 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D CC 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 F8 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 76 68 80 01 00 00 8B 4D 10 51 8B 55 F4 52 8B 45 08 50 8D 4D FC 51 E8 ?? ?? ?? ?? 83 C4 14 85 C0 74 04 33 C0 EB 51 8B 15 ?? ?? ?? ?? 83 C2 01 89 15 ?? ?? ?? ?? 8B 45 14 89 45 F8 8B 4D F8 8B 55 EC 89 51 0C 8B 45 F8 C7 40 04 00 00 00 00 8B 4D F8 C7 01 00 00 00 00 8B 55 F8 C7 42 08 00 00 00 00 8B 45 F8 C7 40 1C 00 00 00 00 8B 4D F8 8B 55 FC 89 51 10 8B 45 F8 8B E5 5D C3 8B FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 01 02 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 03 0C 0C 0C 0C 0C 0C 0C 0C 0C 04 0C 0C 0C 05 06 07 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 08 09 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 0A 0C 0C 0C 0C 0C 0B }
	condition:
		$1
}

rule file_273_0_0 {
	meta:
		name = "___init_numeric"
		size = 719
		refs = "003c ??_C@_09MECGNAGI@initnum?4c?$AA@ 0047 __calloc_dbg 0080 __malloc_dbg 0097 __free_dbg 0124 ___getlocaleinfo 017a ___free_lconv_num 01ad _fix_grouping 01c1 ___lconv_c 0226 __imp__InterlockedDecrement@4 023b ??_C@_1DM@IFKAINNE@?$AAp?$AAl?$AAo?$AAc?$AAi?$AA?9?$AA?$DO?$AAl?$AAc?$AAo?$AAn?$AAv?$AA_?$AAn?$AAu?$AAm?$AA_?$AAr?$AAe?$AAf?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 0247 ??_C@_1BE@EAFFGEEO@?$AAi?$AAn?$AAi?$AAt?$AAn?$AAu?$AAm?$AA?4?$AAc?$AA?$AA@ 024e __CrtDbgReportW"
	strings:
		$1 = { 55 8B EC 83 EC 1C 56 57 C7 45 E8 00 00 00 00 C7 45 F8 00 00 00 00 8B 45 08 89 45 F0 C7 45 F4 00 00 00 00 8B 4D 08 83 79 1C 00 75 0D 8B 55 08 83 7A 18 00 0F 84 C0 01 00 00 6A 65 68 ?? ?? ?? ?? 6A 02 6A 30 6A 01 E8 ?? ?? ?? ?? 83 C4 14 89 45 E4 83 7D E4 00 75 0A B8 01 00 00 00 E9 68 02 00 00 8B 45 08 8B B0 BC 00 00 00 B9 0C 00 00 00 8B 7D E4 F3 A5 6A 71 68 ?? ?? ?? ?? 6A 02 6A 04 E8 ?? ?? ?? ?? 83 C4 10 89 45 EC 83 7D EC 00 75 18 6A 02 8B 4D E4 51 E8 ?? ?? ?? ?? 83 C4 08 B8 01 00 00 00 E9 21 02 00 00 8B 55 EC C7 02 00 00 00 00 8B 45 08 83 78 1C 00 0F 84 F8 00 00 00 6A 7D 68 ?? ?? ?? ?? 6A 02 6A 04 E8 ?? ?? ?? ?? 83 C4 10 89 45 F8 83 7D F8 00 75 26 6A 02 8B 4D E4 51 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 55 EC 52 E8 ?? ?? ?? ?? 83 C4 08 B8 01 00 00 00 E9 C9 01 00 00 8B 45 F8 C7 00 00 00 00 00 8B 4D 08 0F B7 51 3E 89 55 FC 8B 45 E4 50 6A 0E 8B 4D FC 51 6A 01 8D 55 F0 52 E8 ?? ?? ?? ?? 83 C4 14 0B 45 E8 89 45 E8 8B 45 E4 83 C0 04 50 6A 0F 8B 4D FC 51 6A 01 8D 55 F0 52 E8 ?? ?? ?? ?? 83 C4 14 0B 45 E8 89 45 E8 8B 45 E4 83 C0 08 50 6A 10 8B 4D FC 51 6A 01 8D 55 F0 52 E8 ?? ?? ?? ?? 83 C4 14 0B 45 E8 89 45 E8 74 30 8B 45 E4 50 E8 ?? ?? ?? ?? 83 C4 04 6A 02 8B 4D E4 51 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 55 EC 52 E8 ?? ?? ?? ?? 83 C4 08 83 C8 FF E9 24 01 00 00 8B 45 E4 8B 48 08 51 E8 ?? ?? ?? ?? 83 C4 04 EB 29 C7 45 F8 00 00 00 00 8B 55 E4 A1 ?? ?? ?? ?? 89 02 8B 4D E4 8B 15 ?? ?? ?? ?? 89 51 04 8B 45 E4 8B 0D ?? ?? ?? ?? 89 48 08 8B 55 EC C7 02 01 00 00 00 83 7D F8 00 74 09 8B 45 F8 C7 00 01 00 00 00 EB 15 C7 45 F8 00 00 00 00 C7 45 EC 00 00 00 00 C7 45 E4 ?? ?? ?? ?? 8B 4D 08 83 B9 B4 00 00 00 00 74 41 8B 55 08 8B 82 B4 00 00 00 50 FF 15 ?? ?? ?? ?? 85 C0 75 2D 8B 4D 08 83 B9 B4 00 00 00 00 77 21 68 ?? ?? ?? ?? 6A 00 68 BC 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 8B 45 08 83 B8 B0 00 00 00 00 74 3C 8B 4D 08 8B 91 B0 00 00 00 52 FF 15 ?? ?? ?? ?? 85 C0 75 28 6A 02 8B 45 08 8B 88 B0 00 00 00 51 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 55 08 8B 82 BC 00 00 00 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4D 08 8B 55 F8 89 91 B4 00 00 00 8B 45 08 8B 4D EC 89 88 B0 00 00 00 8B 55 08 8B 45 E4 89 82 BC 00 00 00 33 C0 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_273_1_0 {
	meta:
		name = "_fix_grouping"
		size = 125
	strings:
		$1 = { 55 8B EC 51 8B 45 08 0F BE 08 85 C9 74 6B 8B 55 08 0F BE 02 83 F8 30 7C 24 8B 4D 08 0F BE 11 83 FA 39 7F 19 8B 45 08 0F BE 08 83 E9 30 8B 55 08 88 0A 8B 45 08 83 C0 01 89 45 08 EB 3A 8B 4D 08 0F BE 11 83 FA 3B 75 26 8B 45 08 89 45 FC 8B 4D FC 8B 55 FC 8A 42 01 88 01 8B 4D FC 83 C1 01 89 4D FC 8B 55 FC 0F BE 02 85 C0 75 E2 EB 09 8B 4D 08 83 C1 01 89 4D 08 EB 8B 8B E5 5D C3 }
	condition:
		$1
}

rule file_273_2_0 {
	meta:
		name = "___free_lconv_num"
		size = 104
		refs = "0012 ___lconv_c 0021 __free_dbg"
	strings:
		$1 = { 55 8B EC 83 7D 08 00 75 02 EB 5B 8B 45 08 8B 08 3B 0D ?? ?? ?? ?? 74 10 6A 02 8B 55 08 8B 02 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4D 08 8B 51 04 3B 15 ?? ?? ?? ?? 74 11 6A 02 8B 45 08 8B 48 04 51 E8 ?? ?? ?? ?? 83 C4 08 8B 55 08 8B 42 08 3B 05 ?? ?? ?? ?? 74 11 6A 02 8B 4D 08 8B 51 08 52 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_275_2_0 {
	meta:
		name = "__make__time32_t"
		size = 990
		refs = "0029 ??_C@_1BO@LELPCFEI@?$AA?$CI?$AA?5?$AAt?$AAb?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CJ?$AA?$AA@ 0035 ??_C@_1BC@BABOGEA@?$AAm?$AAk?$AAt?$AAi?$AAm?$AAe?$AA?4?$AAc?$AA?$AA@ 003c __CrtDbgReportW 0050 __errno 0067 ??_C@_1CA@LJOOJJFN@?$AA_?$AAm?$AAa?$AAk?$AAe?$AA_?$AA_?$AAt?$AAi?$AAm?$AAe?$AA3?$AA2?$AA_?$AAt?$AA?$AA@ 0071 __invalid_parameter 0115 __days 02f0 ___tzset 0306 ??_C@_1CO@IMMOMMCB@?$AA_?$AAg?$AAe?$AAt?$AA_?$AAd?$AAs?$AAt?$AAb?$AAi?$AAa?$AAs?$AA?$CI?$AA?$CG?$AAd?$AAs?$AAt?$AAb?$AAi?$AAa?$AAs?$AA?$CJ?$AA?$AA@ 030f __get_dstbias 0318 __invoke_watson_if_error 0331 ??_C@_1DC@CMKCHHFC@?$AA_?$AAg?$AAe?$AAt?$AA_?$AAt?$AAi?$AAm?$AAe?$AAz?$AAo?$AAn?$AAe?$AA?$CI?$AA?$CG?$AAt?$AAi?$AAm?$AAe?$AAz?$AAo?$AAn?$AAe?$AA?$CJ?$AA?$AA@ 033a __get_timezone 035c __localtime32_s 03ab __gmtime32_s"
	strings:
		$1 = { 55 8B EC 83 EC 48 56 57 C7 45 FC 00 00 00 00 C7 45 CC 00 00 00 00 33 C0 83 7D 08 00 0F 95 C0 89 45 C4 83 7D C4 00 75 21 68 ?? ?? ?? ?? 6A 00 68 8A 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D C4 00 75 31 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 8A 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 58 03 00 00 8B 55 08 8B 42 14 89 45 C8 83 7D C8 45 7C 09 81 7D C8 8B 00 00 00 7E 05 E9 2D 03 00 00 8B 4D 08 83 79 10 00 7C 09 8B 55 08 83 7A 10 0B 7E 5D 8B 45 08 8B 40 10 99 B9 0C 00 00 00 F7 F9 03 45 C8 89 45 C8 8B 55 08 8B 42 10 99 B9 0C 00 00 00 F7 F9 8B 45 08 89 50 10 8B 4D 08 83 79 10 00 7D 18 8B 55 08 8B 42 10 83 C0 0C 8B 4D 08 89 41 10 8B 55 C8 83 EA 01 89 55 C8 83 7D C8 45 7C 09 81 7D C8 8B 00 00 00 7E 05 E9 BE 02 00 00 8B 45 08 8B 48 10 8B 14 8D ?? ?? ?? ?? 89 55 D0 8B 45 C8 83 E0 03 75 12 8B 4D 08 83 79 10 01 7E 09 8B 55 D0 83 C2 01 89 55 D0 8B 45 C8 83 E8 46 69 C0 6D 01 00 00 8B 4D C8 83 E9 01 C1 F9 02 8D 54 08 EF 89 55 F8 8B 45 F8 03 45 D0 89 45 F8 8B 4D 08 8B 51 0C 89 55 D0 8B 45 F8 03 45 D0 89 45 C8 83 7D F8 00 7C 0C 83 7D D0 00 7C 06 83 7D C8 00 7C 12 83 7D F8 00 7D 11 83 7D D0 00 7D 0B 83 7D C8 00 7C 05 E9 34 02 00 00 8B 4D C8 6B C9 18 89 4D D0 83 7D C8 00 74 14 8B 45 D0 99 F7 7D C8 33 D2 83 F8 18 0F 95 C2 89 55 C0 EB 07 C7 45 C0 00 00 00 00 83 7D C0 00 74 05 E9 FF 01 00 00 8B 45 08 8B 48 08 89 4D F8 8B 55 D0 03 55 F8 89 55 C8 83 7D D0 00 7C 0C 83 7D F8 00 7C 06 83 7D C8 00 7C 12 83 7D D0 00 7D 11 83 7D F8 00 7D 0B 83 7D C8 00 7C 05 E9 C4 01 00 00 8B 45 C8 6B C0 3C 89 45 D0 83 7D C8 00 74 14 8B 45 D0 99 F7 7D C8 33 C9 83 F8 3C 0F 95 C1 89 4D BC EB 07 C7 45 BC 00 00 00 00 83 7D BC 00 74 05 E9 8F 01 00 00 8B 55 08 8B 42 04 89 45 F8 8B 4D D0 03 4D F8 89 4D C8 83 7D D0 00 7C 0C 83 7D F8 00 7C 06 83 7D C8 00 7C 12 83 7D D0 00 7D 11 83 7D F8 00 7D 0B 83 7D C8 00 7C 05 E9 54 01 00 00 8B 55 C8 6B D2 3C 89 55 D0 83 7D C8 00 74 14 8B 45 D0 99 F7 7D C8 33 C9 83 F8 3C 0F 95 C1 89 4D B8 EB 07 C7 45 B8 00 00 00 00 83 7D B8 00 74 05 E9 1F 01 00 00 8B 55 08 8B 02 89 45 F8 8B 4D D0 03 4D F8 89 4D C8 83 7D D0 00 7C 0C 83 7D F8 00 7C 06 83 7D C8 00 7C 12 83 7D D0 00 7D 11 83 7D F8 00 7D 0B 83 7D C8 00 7C 05 E9 E5 00 00 00 83 7D 0C 00 0F 84 B3 00 00 00 E8 ?? ?? ?? ?? 6A 00 68 01 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 02 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 CC 50 E8 ?? ?? ?? ?? 83 C4 04 50 E8 ?? ?? ?? ?? 83 C4 18 8B 4D C8 03 4D CC 89 4D C8 8D 55 C8 52 8D 45 D4 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 02 EB 61 8B 4D 08 83 79 20 00 7F 0F 8B 55 08 83 7A 20 00 7D 25 83 7D F4 00 7E 1F 8B 45 C8 03 45 FC 89 45 C8 8D 4D C8 51 8D 55 D4 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 02 EB 2A EB 16 8D 45 C8 50 8D 4D D4 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 02 EB 12 B9 09 00 00 00 8D 75 D4 8B 7D 08 F3 A5 8B 45 C8 EB 0E E8 ?? ?? ?? ?? C7 00 16 00 00 00 83 C8 FF 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_276_0_0 {
	meta:
		name = "__wfsopen"
		size = 521
		refs = "0006 __sehtable$__wfsopen 000b __except_handler4 001d ___security_cookie 0051 ??_C@_1BO@CLGIAEOJ@?$AA?$CI?$AAf?$AAi?$AAl?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 005a ??_C@_1GA@JDIPNMIB@?$AAf?$AA?3?$AA?2?$AAr?$AAt?$AAm?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2@ 0061 __CrtDbgReportW 0075 __errno 0089 ??_C@_1BC@PAJNLEOB@?$AA_?$AAw?$AAf?$AAs?$AAo?$AAp?$AAe?$AAn?$AA?$AA@ 0093 __invalid_parameter 00b4 ??_C@_1BO@MJMKAKCJ@?$AA?$CI?$AAm?$AAo?$AAd?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0116 ??_C@_1CI@HBNALCBB@?$AA?$CI?$AA?$CK?$AAm?$AAo?$AAd?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$CJ?$AA?$AA@ 0167 __getstream 01b2 __local_unwind4 01cf __wopenfile 01ec __unlock_file"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 E0 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 C7 45 E4 00 00 00 00 C7 45 E0 00 00 00 00 33 C0 83 7D 08 00 0F 95 C0 89 45 DC 83 7D DC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 36 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D DC 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 36 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 56 01 00 00 33 D2 83 7D 0C 00 0F 95 C2 89 55 D8 83 7D D8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 37 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D8 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 37 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 F3 00 00 00 8B 4D 0C 0F B7 11 F7 DA 1B D2 F7 DA 89 55 D4 75 1E 68 ?? ?? ?? ?? 6A 00 6A 38 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D4 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 38 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 91 00 00 00 E8 ?? ?? ?? ?? 89 45 E4 83 7D E4 00 75 0F E8 ?? ?? ?? ?? C7 00 18 00 00 00 33 C0 EB 74 C7 45 FC 00 00 00 00 8B 4D 08 0F B7 11 85 D2 75 2A E8 ?? ?? ?? ?? C7 00 16 00 00 00 C7 45 D0 00 00 00 00 6A FE 8D 45 F0 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 45 D0 EB 39 8B 4D E4 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 E0 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0D 8B 55 E4 52 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 E0 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_276_1_0 {
	meta:
		name = "__wfopen"
		size = 23
		refs = "000e __wfsopen"
	strings:
		$1 = { 55 8B EC 6A 40 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_568_1_0 {
	meta:
		name = "_fopen"
		size = 23
		refs = "000e __fsopen"
	strings:
		$1 = { 55 8B EC 6A 40 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_276_2_0 {
	meta:
		name = "__wfopen_s"
		size = 158
		refs = "0017 ??_C@_1CA@LLJLFCDN@?$AA?$CI?$AAp?$AAf?$AAi?$AAl?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0023 ??_C@_1GA@JDIPNMIB@?$AAf?$AA?3?$AA?2?$AAr?$AAt?$AAm?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2@ 002a __CrtDbgReportW 003e __errno 0055 ??_C@_1BE@JDODBHOJ@?$AA_?$AAw?$AAf?$AAo?$AAp?$AAe?$AAn?$AA_?$AAs?$AA?$AA@ 005f __invalid_parameter 007b __wfsopen"
	strings:
		$1 = { 55 8B EC 51 33 C0 83 7D 08 00 0F 95 C0 89 45 FC 83 7D FC 00 75 21 68 ?? ?? ?? ?? 6A 00 68 9E 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D FC 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 9E 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 EB 2D 68 80 00 00 00 8B 55 10 52 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D 08 89 01 8B 55 08 83 3A 00 74 04 33 C0 EB 07 E8 ?? ?? ?? ?? 8B 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_568_2_0 {
	meta:
		name = "_fopen_s"
		size = 158
		refs = "0017 ??_C@_1CA@LLJLFCDN@?$AA?$CI?$AAp?$AAf?$AAi?$AAl?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0023 ??_C@_1BA@GBANKLPE@?$AAf?$AAo?$AAp?$AAe?$AAn?$AA?4?$AAc?$AA?$AA@ 002a __CrtDbgReportW 003e __errno 0055 ??_C@_1BA@PBGKCCAP@?$AAf?$AAo?$AAp?$AAe?$AAn?$AA_?$AAs?$AA?$AA@ 005f __invalid_parameter 007b __fsopen"
	strings:
		$1 = { 55 8B EC 51 33 C0 83 7D 08 00 0F 95 C0 89 45 FC 83 7D FC 00 75 21 68 ?? ?? ?? ?? 6A 00 68 9E 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D FC 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 9E 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 EB 2D 68 80 00 00 00 8B 55 10 52 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D 08 89 01 8B 55 08 83 3A 00 74 04 33 C0 EB 07 E8 ?? ?? ?? ?? 8B 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_277_0_0 {
	meta:
		name = "__atodbl_l"
		size = 255
		refs = "0007 ___security_cookie 0026 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 002e ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0048 ___strgtold12_l 005b __ld12tod 007e ??1_LocaleUpdate@@QAE@XZ 00f7 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 40 A1 ?? ?? ?? ?? 33 C5 89 45 F0 C7 45 F8 00 00 00 00 C7 45 FC 00 00 00 00 8B 45 10 50 8D 4D D4 E8 ?? ?? ?? ?? 8D 4D D4 E8 ?? ?? ?? ?? 50 6A 00 6A 00 6A 00 6A 00 8B 4D 0C 51 8D 55 F4 52 8D 45 E4 50 E8 ?? ?? ?? ?? 83 C4 20 89 45 F8 8B 4D 08 51 8D 55 E4 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 8B 45 F8 83 E0 03 75 38 83 7D FC 01 75 16 C7 45 D0 03 00 00 00 8D 4D D4 E8 ?? ?? ?? ?? 8B 45 D0 EB 6A EB 1A 83 7D FC 02 75 14 C7 45 CC 04 00 00 00 8D 4D D4 E8 ?? ?? ?? ?? 8B 45 CC EB 4E EB 3A 8B 4D F8 83 E1 01 74 16 C7 45 C8 04 00 00 00 8D 4D D4 E8 ?? ?? ?? ?? 8B 45 C8 EB 30 EB 1C 8B 55 F8 83 E2 02 74 14 C7 45 C4 03 00 00 00 8D 4D D4 E8 ?? ?? ?? ?? 8B 45 C4 EB 12 C7 45 C0 00 00 00 00 8D 4D D4 E8 ?? ?? ?? ?? 8B 45 C0 8B 4D F0 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_277_7_0 {
	meta:
		name = "__atoflt_l"
		size = 255
		refs = "0007 ___security_cookie 0026 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 002e ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0048 ___strgtold12_l 005b __ld12tof 007e ??1_LocaleUpdate@@QAE@XZ 00f7 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 40 A1 ?? ?? ?? ?? 33 C5 89 45 F0 C7 45 F8 00 00 00 00 C7 45 FC 00 00 00 00 8B 45 10 50 8D 4D D4 E8 ?? ?? ?? ?? 8D 4D D4 E8 ?? ?? ?? ?? 50 6A 00 6A 00 6A 00 6A 00 8B 4D 0C 51 8D 55 F4 52 8D 45 E4 50 E8 ?? ?? ?? ?? 83 C4 20 89 45 F8 8B 4D 08 51 8D 55 E4 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 8B 45 F8 83 E0 03 75 38 83 7D FC 01 75 16 C7 45 D0 03 00 00 00 8D 4D D4 E8 ?? ?? ?? ?? 8B 45 D0 EB 6A EB 1A 83 7D FC 02 75 14 C7 45 CC 04 00 00 00 8D 4D D4 E8 ?? ?? ?? ?? 8B 45 CC EB 4E EB 3A 8B 4D F8 83 E1 01 74 16 C7 45 C8 04 00 00 00 8D 4D D4 E8 ?? ?? ?? ?? 8B 45 C8 EB 30 EB 1C 8B 55 F8 83 E2 02 74 14 C7 45 C4 03 00 00 00 8D 4D D4 E8 ?? ?? ?? ?? 8B 45 C4 EB 12 C7 45 C0 00 00 00 00 8D 4D D4 E8 ?? ?? ?? ?? 8B 45 C0 8B 4D F0 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_277_5_0 {
	meta:
		name = "__atoldbl_l"
		size = 255
		refs = "0007 ___security_cookie 0026 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 002e ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0048 ___strgtold12_l 005b __ld12told 007e ??1_LocaleUpdate@@QAE@XZ 00f7 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 40 A1 ?? ?? ?? ?? 33 C5 89 45 F0 C7 45 F8 00 00 00 00 C7 45 FC 00 00 00 00 8B 45 10 50 8D 4D D4 E8 ?? ?? ?? ?? 8D 4D D4 E8 ?? ?? ?? ?? 50 6A 00 6A 00 6A 00 6A 01 8B 4D 0C 51 8D 55 F4 52 8D 45 E4 50 E8 ?? ?? ?? ?? 83 C4 20 89 45 F8 8B 4D 08 51 8D 55 E4 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 8B 45 F8 83 E0 03 75 38 83 7D FC 01 75 16 C7 45 D0 03 00 00 00 8D 4D D4 E8 ?? ?? ?? ?? 8B 45 D0 EB 6A EB 1A 83 7D FC 02 75 14 C7 45 CC 04 00 00 00 8D 4D D4 E8 ?? ?? ?? ?? 8B 45 CC EB 4E EB 3A 8B 4D F8 83 E1 01 74 16 C7 45 C8 04 00 00 00 8D 4D D4 E8 ?? ?? ?? ?? 8B 45 C8 EB 30 EB 1C 8B 55 F8 83 E2 02 74 14 C7 45 C4 03 00 00 00 8D 4D D4 E8 ?? ?? ?? ?? 8B 45 C4 EB 12 C7 45 C0 00 00 00 00 8D 4D D4 E8 ?? ?? ?? ?? 8B 45 C0 8B 4D F0 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_278_0_0 {
	meta:
		name = "__ftime32_s"
		size = 474
		refs = "000a ___security_cookie 0033 ??_C@_1BO@BCOPJGHK@?$AA?$CI?$AA?5?$AAt?$AAp?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CJ?$AA?$AA@ 003c ??_C@_1BA@JHILCHLK@?$AAf?$AAt?$AAi?$AAm?$AAe?$AA?4?$AAc?$AA?$AA@ 0043 __CrtDbgReportW 005a __errno 006e ??_C@_1BG@COIAKOAH@?$AA_?$AAf?$AAt?$AAi?$AAm?$AAe?$AA3?$AA2?$AA_?$AAs?$AA?$AA@ 0078 __invalid_parameter 008a ___tzset 009d ??_C@_1DC@CMKCHHFC@?$AA_?$AAg?$AAe?$AAt?$AA_?$AAt?$AAi?$AAm?$AAe?$AAz?$AAo?$AAn?$AAe?$AA?$CI?$AA?$CG?$AAt?$AAi?$AAm?$AAe?$AAz?$AAo?$AAn?$AAe?$AA?$CJ?$AA?$AA@ 00a6 __get_timezone 00af __invoke_watson_if_error 00d1 __imp__GetSystemTimeAsFileTime@4 00eb __aulldiv 00fd _elapsed_minutes_cache 010c __imp__GetTimeZoneInformation@4 0138 _dstflag_cache 0195 __aullrem 01d2 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC CC 00 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 F8 C7 45 FC 00 00 00 00 33 C0 83 7D 08 00 0F 95 C0 89 85 34 FF FF FF 83 BD 34 FF FF FF 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 4E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 34 FF FF FF 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 4E 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 43 01 00 00 E8 ?? ?? ?? ?? 6A 00 6A 52 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 50 E8 ?? ?? ?? ?? 83 C4 18 8B 45 FC 99 B9 3C 00 00 00 F7 F9 8B 55 08 66 89 42 06 8D 85 40 FF FF FF 50 FF 15 ?? ?? ?? ?? 6A 00 68 00 46 C3 23 8B 8D 44 FF FF FF 51 8B 95 40 FF FF FF 52 E8 ?? ?? ?? ?? 89 85 3C FF FF FF 8B 85 3C FF FF FF 3B 05 ?? ?? ?? ?? 74 60 8D 8D 48 FF FF FF 51 FF 15 ?? ?? ?? ?? 89 85 38 FF FF FF 83 BD 38 FF FF FF FF 74 2F 83 BD 38 FF FF FF 02 75 1A 0F B7 55 E2 85 D2 74 12 83 7D F0 00 74 0C C7 05 ?? ?? ?? ?? 01 00 00 00 EB 0A C7 05 ?? ?? ?? ?? 00 00 00 00 EB 0A C7 05 ?? ?? ?? ?? FF FF FF FF 8B 85 3C FF FF FF A3 ?? ?? ?? ?? 8B 4D 08 66 8B 15 ?? ?? ?? ?? 66 89 51 08 6A 00 68 10 27 00 00 8B 85 44 FF FF FF 50 8B 8D 40 FF FF FF 51 E8 ?? ?? ?? ?? 6A 00 68 E8 03 00 00 52 50 E8 ?? ?? ?? ?? 8B 55 08 66 89 42 04 8B 85 40 FF FF FF 2D 00 80 3E D5 8B 8D 44 FF FF FF 81 D9 DE B1 9D 01 6A 00 68 80 96 98 00 51 50 E8 ?? ?? ?? ?? 8B 55 08 89 02 33 C0 8B 4D F8 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_279_0_0 {
	meta:
		name = "___setargv"
		size = 294
		refs = "000f ___mbctype_initialized 0017 ___initmbctable 001d ?_pgmname@?1??__setargv@@9@9 0030 __imp__GetModuleFileNameA@12 003a __set_pgmptr 0043 __acmdln 007f _parse_cmdline 00b6 ??_C@_0DC@ICHPGBKN@f?3?2rtm?2vctools?2crt_bld?2self_x86?2@ 00c7 __malloc_dbg 0106 ___argc 010e ___argv 0113 __cwild"
	strings:
		$1 = { 55 8B EC 83 EC 14 C7 45 FC 00 00 00 00 83 3D ?? ?? ?? ?? 00 75 05 E8 ?? ?? ?? ?? C6 05 ?? ?? ?? ?? 00 68 04 01 00 00 68 ?? ?? ?? ?? 6A 00 FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 83 3D ?? ?? ?? ?? 00 74 17 A1 ?? ?? ?? ?? 0F BE 08 85 C9 74 0B 8B 15 ?? ?? ?? ?? 89 55 EC EB 07 C7 45 EC ?? ?? ?? ?? 8B 45 EC 89 45 F4 8D 4D F0 51 8D 55 F8 52 6A 00 6A 00 8B 45 F4 50 E8 ?? ?? ?? ?? 83 C4 14 81 7D F8 FF FF FF 3F 73 06 83 7D F0 FF 72 08 83 C8 FF E9 85 00 00 00 8B 4D F8 8B 55 F0 8D 04 8A 3B 45 F0 73 05 83 C8 FF EB 72 68 8C 00 00 00 68 ?? ?? ?? ?? 6A 02 8B 4D F8 8B 55 F0 8D 04 8A 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 FC 83 7D FC 00 75 05 83 C8 FF EB 46 8D 4D F0 51 8D 55 F8 52 8B 45 F8 8B 4D FC 8D 14 81 52 8B 45 FC 50 8B 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 8B 55 F8 83 EA 01 89 15 ?? ?? ?? ?? 8B 45 FC A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 05 83 C8 FF EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_279_2_0 {
	meta:
		name = "_parse_cmdline"
		size = 938
		refs = "00c9 __ismbblead"
	strings:
		$1 = { 55 8B EC 83 EC 14 8B 45 18 C7 00 00 00 00 00 8B 4D 14 C7 01 01 00 00 00 8B 55 08 89 55 FC 83 7D 0C 00 74 11 8B 45 0C 8B 4D 10 89 08 8B 55 0C 83 C2 04 89 55 0C 83 7D 10 00 74 13 8B 45 10 8B 4D FC 8A 11 88 10 8B 45 10 83 C0 01 89 45 10 8B 4D 18 8B 11 83 C2 01 8B 45 18 89 10 C7 45 F8 00 00 00 00 8B 4D FC 0F BE 11 83 FA 22 75 1F 33 C0 83 7D F8 00 0F 94 C0 89 45 F8 8B 4D FC 8A 11 88 55 F3 8B 45 FC 83 C0 01 89 45 FC EB 77 8B 4D 18 8B 11 83 C2 01 8B 45 18 89 10 83 7D 10 00 74 13 8B 4D 10 8B 55 FC 8A 02 88 01 8B 4D 10 83 C1 01 89 4D 10 8B 55 FC 8A 02 88 45 F3 8B 4D FC 83 C1 01 89 4D FC 0F B6 55 F3 52 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 2F 8B 45 18 8B 08 83 C1 01 8B 55 18 89 0A 83 7D 10 00 74 13 8B 45 10 8B 4D FC 8A 11 88 10 8B 45 10 83 C0 01 89 45 10 8B 4D FC 83 C1 01 89 4D FC 0F B6 55 F3 85 D2 74 20 83 7D F8 00 0F 85 4D FF FF FF 0F B6 45 F3 83 F8 20 74 0D 0F B6 4D F3 83 F9 09 0F 85 37 FF FF FF 0F B6 55 F3 85 D2 75 0B 8B 45 FC 83 E8 01 89 45 FC EB 0D 83 7D 10 00 74 07 8B 4D 10 C6 41 FF 00 C7 45 F8 00 00 00 00 8B 55 FC 0F BE 02 85 C0 74 21 8B 4D FC 0F BE 11 83 FA 20 74 0B 8B 45 FC 0F BE 08 83 F9 09 75 0B 8B 55 FC 83 C2 01 89 55 FC EB DF 8B 45 FC 0F BE 08 85 C9 75 05 E9 F5 01 00 00 83 7D 0C 00 74 11 8B 55 0C 8B 45 10 89 02 8B 4D 0C 83 C1 04 89 4D 0C 8B 55 14 8B 02 83 C0 01 8B 4D 14 89 01 83 7D 10 00 74 13 8B 55 10 8B 45 FC 8A 08 88 0A 8B 55 10 83 C2 01 89 55 10 8B 45 18 8B 08 83 C1 01 8B 55 18 89 0A C7 45 F4 01 00 00 00 C7 45 EC 00 00 00 00 8B 45 FC 0F BE 08 83 F9 5C 75 14 8B 55 FC 83 C2 01 89 55 FC 8B 45 EC 83 C0 01 89 45 EC EB E1 8B 4D FC 0F BE 11 83 FA 22 75 48 8B 45 EC 33 D2 B9 02 00 00 00 F7 F1 85 D2 75 30 83 7D F8 00 74 17 8B 55 FC 0F BE 42 01 83 F8 22 75 0B 8B 4D FC 83 C1 01 89 4D FC EB 13 C7 45 F4 00 00 00 00 33 D2 83 7D F8 00 0F 94 C2 89 55 F8 8B 45 EC D1 E8 89 45 EC 8B 4D EC 8B 55 EC 83 EA 01 89 55 EC 85 C9 74 24 83 7D 10 00 74 0F 8B 45 10 C6 00 5C 8B 4D 10 83 C1 01 89 4D 10 8B 55 18 8B 02 83 C0 01 8B 4D 18 89 01 EB CC 8B 55 FC 0F BE 02 85 C0 74 1C 83 7D F8 00 75 1B 8B 4D FC 0F BE 11 83 FA 20 74 0B 8B 45 FC 0F BE 08 83 F9 09 75 05 E9 A5 00 00 00 83 7D F4 00 0F 84 8D 00 00 00 83 7D 10 00 74 51 8B 55 FC 0F BE 02 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 29 8B 4D 10 8B 55 FC 8A 02 88 01 8B 4D 10 83 C1 01 89 4D 10 8B 55 FC 83 C2 01 89 55 FC 8B 45 18 8B 08 83 C1 01 8B 55 18 89 0A 8B 45 10 8B 4D FC 8A 11 88 10 8B 45 10 83 C0 01 89 45 10 EB 29 8B 4D FC 0F BE 11 52 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 16 8B 45 FC 83 C0 01 89 45 FC 8B 4D 18 8B 11 83 C2 01 8B 45 18 89 10 8B 4D 18 8B 11 83 C2 01 8B 45 18 89 10 8B 4D FC 83 C1 01 89 4D FC E9 7C FE FF FF 83 7D 10 00 74 0F 8B 55 10 C6 02 00 8B 45 10 83 C0 01 89 45 10 8B 4D 18 8B 11 83 C2 01 8B 45 18 89 10 E9 D1 FD FF FF 83 7D 0C 00 74 12 8B 4D 0C C7 01 00 00 00 00 8B 55 0C 83 C2 04 89 55 0C 8B 45 14 8B 08 83 C1 01 8B 55 14 89 0A 8B E5 5D C3 }
	condition:
		$1
}

rule file_280_0_0 {
	meta:
		name = "_fclose"
		size = 257
		refs = "0006 __sehtable$_fclose 000b __except_handler4 001d ___security_cookie 004a ??_C@_1CC@FADMNIL@?$AA?$CI?$AAs?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0053 ??_C@_1BC@MHEDMIA@?$AAf?$AAc?$AAl?$AAo?$AAs?$AAe?$AA?4?$AAc?$AA?$AA@ 005a __CrtDbgReportW 006e __errno 0082 ??_C@_1O@EGMJNCOI@?$AAf?$AAc?$AAl?$AAo?$AAs?$AAe?$AA?$AA@ 008c __invalid_parameter 00b4 __lock_file 00c7 __fclose_nolock 00e4 __unlock_file"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 F0 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 C7 45 E4 FF FF FF FF 33 C0 83 7D 08 00 0F 95 C0 89 45 E0 83 7D E0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 2F 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 2F 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 57 8B 55 08 8B 42 0C 83 E0 40 74 0C 8B 4D 08 C7 41 0C 00 00 00 00 EB 3D 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 E4 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0D 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 E4 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_280_1_0 {
	meta:
		name = "__fclose_nolock"
		size = 247
		refs = "0020 ??_C@_1BM@JMKHIAHP@?$AA?$CI?$AAs?$AAt?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0029 ??_C@_1BC@MHEDMIA@?$AAf?$AAc?$AAl?$AAo?$AAs?$AAe?$AA?4?$AAc?$AA?$AA@ 0030 __CrtDbgReportW 0044 __errno 0058 ??_C@_1BO@JINCABEC@?$AA_?$AAf?$AAc?$AAl?$AAo?$AAs?$AAe?$AA_?$AAn?$AAo?$AAl?$AAo?$AAc?$AAk?$AA?$AA@ 0062 __invalid_parameter 008a __flush 0099 __freebuf 00a5 __fileno 00ae __close 00d5 __free_dbg"
	strings:
		$1 = { 55 8B EC 83 EC 0C C7 45 F8 FF FF FF FF 33 C0 83 7D 08 00 0F 95 C0 89 45 F4 83 7D F4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 5A 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F4 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 5A 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 82 00 00 00 8B 55 08 89 55 FC 8B 45 FC 8B 48 0C 81 E1 83 00 00 00 74 61 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 F8 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 7D 09 C7 45 F8 FF FF FF FF EB 24 8B 55 FC 83 7A 1C 00 74 1B 6A 02 8B 45 FC 8B 48 1C 51 E8 ?? ?? ?? ?? 83 C4 08 8B 55 FC C7 42 1C 00 00 00 00 8B 45 FC C7 40 0C 00 00 00 00 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_282_0_0 {
	meta:
		name = "__mbclen_l"
		size = 61
		refs = "0010 __ismbblead_l"
	strings:
		$1 = { 55 8B EC 51 8B 45 0C 50 8B 4D 08 0F B6 11 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 14 8B 45 08 0F B6 48 01 85 C9 74 09 C7 45 FC 02 00 00 00 EB 07 C7 45 FC 01 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_282_1_0 {
	meta:
		name = "__mbclen"
		size = 57
		refs = "000c __ismbblead"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 0F B6 08 51 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 14 8B 55 08 0F B6 42 01 85 C0 74 09 C7 45 FC 02 00 00 00 EB 07 C7 45 FC 01 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_283_0_0 {
	meta:
		name = "__spawnv"
		size = 528
		refs = "0019 ??_C@_1CC@MODLNCFO@?$AAp?$AAa?$AAt?$AAh?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0022 ??_C@_1BC@JEEIFMNK@?$AAs?$AAp?$AAa?$AAw?$AAn?$AAv?$AA?4?$AAc?$AA?$AA@ 0029 __CrtDbgReportW 003d __errno 0051 ??_C@_1BA@DKJGKDD@?$AA_?$AAs?$AAp?$AAa?$AAw?$AAn?$AAv?$AA?$AA@ 005b __invalid_parameter 007c ??_C@_1CM@PKENOFGE@?$AA?$CK?$AAp?$AAa?$AAt?$AAh?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 00e0 ??_C@_1BK@DKFDJEHE@?$AAa?$AAr?$AAg?$AAv?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0146 ??_C@_1BM@CNLEOMNN@?$AA?$CK?$AAa?$AAr?$AAg?$AAv?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 01a8 ??_C@_1CG@JGBGIIEL@?$AA?$CK?$AA?$CK?$AAa?$AAr?$AAg?$AAv?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 0205 __spawnve"
	strings:
		$1 = { 55 8B EC 83 EC 14 33 C0 83 7D 0C 00 0F 95 C0 89 45 FC 83 7D FC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 32 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D FC 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 32 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 A2 01 00 00 8B 55 0C 0F BE 02 F7 D8 1B C0 F7 D8 89 45 F8 75 1E 68 ?? ?? ?? ?? 6A 00 6A 33 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F8 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 33 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 3F 01 00 00 33 D2 83 7D 10 00 0F 95 C2 89 55 F4 83 7D F4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 34 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F4 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 34 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 DB 00 00 00 8B 4D 10 33 D2 83 39 00 0F 95 C2 89 55 F0 83 7D F0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 35 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 35 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 78 8B 4D 10 8B 11 0F BE 02 F7 D8 1B C0 F7 D8 89 45 EC 75 1E 68 ?? ?? ?? ?? 6A 00 6A 36 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D EC 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 36 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 16 6A 00 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_284_0_0 {
	meta:
		name = "___libm_sse2_expf"
		size = 343
		refs = "0015 _log2e 0044 _c1 0060 _Tl 007f _Tm 0094 _Th 0137 _INF 0140 _ZERO 0152 _ONE"
	strings:
		$1 = { F3 0F 10 C8 F3 0F 10 E0 B8 3B AA B8 46 66 0F 6E F8 66 0F 12 1D ?? ?? ?? ?? 66 0F 7E C1 0F 5A C9 81 E1 FF FF FF 7F 81 E9 00 00 80 31 81 F9 00 00 00 12 0F 83 92 00 00 00 F3 0F 59 C7 F3 0F 2D C0 66 0F 12 35 ?? ?? ?? ?? 66 0F 6E D0 8B C8 C1 E0 03 8B D1 F2 0F 59 D9 D1 F9 83 E0 78 F2 0F 59 B0 ?? ?? ?? ?? 66 0F 12 80 ?? ?? ?? ?? 81 E1 F8 00 00 00 8B C2 C1 FA 06 F3 0F E6 D2 66 0F 12 B9 ?? ?? ?? ?? C1 F8 0E 81 E2 F8 00 00 00 66 0F 6E E8 F2 0F 59 BA ?? ?? ?? ?? F2 0F 5C DA 66 0F 73 F5 34 66 0F 7E E1 8B C1 81 E1 FF FF FF 7F F2 0F 59 F3 81 F9 4F AC AE 42 77 4F 66 0F FE FD F2 0F 58 C6 F2 0F 59 C7 66 0F 5A C0 C3 81 C1 00 00 80 31 81 F9 00 00 80 31 76 76 81 F9 00 00 80 7F 73 40 66 0F 7E E2 81 FA 00 00 00 80 73 0E BA FF FF 7F 7F 66 0F 6E C2 F3 0F 59 C0 C3 BA 00 00 80 00 66 0F 6E C2 F3 0F 59 C0 C3 3D 18 72 B1 42 72 AA 66 0F FE FD F2 0F 58 F0 F2 0F 59 F7 F2 0F 5A C6 C3 81 F9 00 00 80 7F 75 1D 66 0F 7E E0 3D 00 00 80 7F 75 09 F3 0F 10 05 ?? ?? ?? ?? C3 F3 0F 10 05 ?? ?? ?? ?? C3 F3 0F 10 C4 F3 0F 58 C0 C3 F3 0F 10 05 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_285_0_0 {
	meta:
		name = "__wfltin2"
		size = 218
		refs = "0007 ___security_cookie 0030 ___wstrgtold12_l 0067 __ld12tod 00d2 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 2C A1 ?? ?? ?? ?? 33 C5 89 45 E8 C7 45 D8 00 00 00 00 8B 45 1C 50 6A 00 6A 00 6A 00 6A 00 8B 4D 0C 51 8D 55 EC 52 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 20 89 45 FC 8B 4D FC 83 E1 04 74 1C 8B 55 D8 81 CA 00 02 00 00 89 55 D8 C7 45 F0 00 00 00 00 C7 45 F4 00 00 00 00 EB 46 8D 45 F0 50 8D 4D DC 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 D4 8B 55 FC 83 E2 02 75 06 83 7D D4 01 75 0B 8B 45 D8 0D 80 00 00 00 89 45 D8 8B 4D FC 83 E1 01 75 06 83 7D D4 02 75 0C 8B 55 D8 81 CA 00 01 00 00 89 55 D8 8B 45 08 8B 4D D8 89 08 8B 55 EC 2B 55 0C D1 FA 8B 45 08 89 50 04 8B 4D 08 8B 55 F0 89 51 10 8B 45 F4 89 41 14 8B 45 08 8B 4D E8 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_288_0_0 {
	meta:
		name = "_wcsncmp"
		size = 86
	strings:
		$1 = { 55 8B EC 83 7D 10 00 75 04 33 C0 EB 47 8B 45 10 83 E8 01 89 45 10 74 2E 8B 4D 08 0F B7 11 85 D2 74 24 8B 45 08 0F B7 08 8B 55 0C 0F B7 02 3B C8 75 14 8B 4D 08 83 C1 02 89 4D 08 8B 55 0C 83 C2 02 89 55 0C EB C7 8B 45 08 0F B7 00 8B 4D 0C 0F B7 11 2B C2 5D C3 }
	condition:
		$1
}

rule file_289_0_0 {
	meta:
		name = "___crtGetCommandLineW"
		size = 248
		refs = "0008 ?f_use@?1??__crtGetCommandLineW@@9@9 0011 __imp__GetCommandLineW@0 0027 __imp__GetLastError@0 006f __imp__GetCommandLineA@0 0086 __imp__MultiByteToWideChar@24 009a ??_C@_08BKLJOFJ@aw_com?4c?$AA@ 00a7 __calloc_dbg 00e5 __free_dbg"
	strings:
		$1 = { 55 8B EC 83 EC 0C 83 3D ?? ?? ?? ?? 00 75 34 FF 15 ?? ?? ?? ?? 85 C0 74 0C C7 05 ?? ?? ?? ?? 01 00 00 00 EB 1E FF 15 ?? ?? ?? ?? 83 F8 78 75 0C C7 05 ?? ?? ?? ?? 02 00 00 00 EB 07 33 C0 E9 B1 00 00 00 83 3D ?? ?? ?? ?? 01 75 0B FF 15 ?? ?? ?? ?? E9 9D 00 00 00 83 3D ?? ?? ?? ?? 02 74 0D 83 3D ?? ?? ?? ?? 00 0F 85 85 00 00 00 FF 15 ?? ?? ?? ?? 89 45 F4 6A 00 6A 00 6A FF 8B 45 F4 50 6A 01 6A 00 FF 15 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 75 04 33 C0 EB 5D 6A 5E 68 ?? ?? ?? ?? 6A 02 6A 02 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 14 89 45 F8 83 7D F8 00 75 04 33 C0 EB 39 8B 55 FC 52 8B 45 F8 50 6A FF 8B 4D F4 51 6A 01 6A 00 FF 15 ?? ?? ?? ?? 85 C0 74 07 8B 45 F8 EB 18 EB 12 6A 02 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 08 33 C0 EB 04 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_291_0_0 {
	meta:
		name = "_strcpy"
		size = 16
	strings:
		$1 = { 57 8B 7C 24 08 EB 6E 8D A4 24 00 00 00 00 8B FF }
	condition:
		$1
}

rule file_291_1_0 {
	meta:
		name = "_strcat"
		size = 232
	strings:
		$1 = { 8B 4C 24 04 57 F7 C1 03 00 00 00 74 13 8A 01 83 C1 01 84 C0 74 3D F7 C1 03 00 00 00 75 EF 8B FF 8B 01 BA FF FE FE 7E 03 D0 83 F0 FF 33 C2 83 C1 04 A9 00 01 01 81 74 E8 8B 41 FC 84 C0 74 23 84 E4 74 1A A9 00 00 FF 00 74 0E A9 00 00 00 FF 74 02 EB CD 8D 79 FF EB 0D 8D 79 FE EB 08 8D 79 FD EB 03 8D 79 FC 8B 4C 24 0C F7 C1 03 00 00 00 74 1D 8A 11 83 C1 01 84 D2 74 66 88 17 83 C7 01 F7 C1 03 00 00 00 75 EA EB 05 89 17 83 C7 04 BA FF FE FE 7E 8B 01 03 D0 83 F0 FF 33 C2 8B 11 83 C1 04 A9 00 01 01 81 74 E1 84 D2 74 34 84 F6 74 27 F7 C2 00 00 FF 00 74 12 F7 C2 00 00 00 FF 74 02 EB C7 89 17 8B 44 24 08 5F C3 66 89 17 8B 44 24 08 C6 47 02 00 5F C3 66 89 17 8B 44 24 08 5F C3 88 17 8B 44 24 08 5F C3 }
	condition:
		$1
}

rule file_292_0_0 {
	meta:
		name = "__wcsftime_l"
		size = 69
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0016 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 002c ?_wcsftime_l_stat@@YAIPA_WIPB_WPBUtm@@PAUlocaleinfo_struct@@@Z 003a ??1_LocaleUpdate@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 83 EC 14 8B 45 18 50 8D 4D F0 E8 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 14 89 45 EC 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 EC 8B E5 5D C3 }
	condition:
		$1
}

rule file_292_4_0 {
	meta:
		name = "?_wcsftime_l_stat@@YAIPA_WIPB_WPBUtm@@PAUlocaleinfo_struct@@@Z"
		size = 811
		refs = "0035 ??_C@_1CI@MPAHGLBB@?$AA?$CI?$AA?5?$AAw?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CJ?$AA?$AA@ 003e ??_C@_1BG@POKFOMPH@?$AAw?$AAc?$AAs?$AAf?$AAt?$AAi?$AAm?$AAe?$AA?4?$AAc?$AA?$AA@ 0045 __CrtDbgReportW 0059 __errno 006d ??_C@_1CC@GIGDCKGO@?$AA_?$AAw?$AAc?$AAs?$AAf?$AAt?$AAi?$AAm?$AAe?$AA_?$AAl?$AA_?$AAs?$AAt?$AAa?$AAt?$AA?$AA@ 0077 __invalid_parameter 0098 ??_C@_1CC@IHEJKGMG@?$AA?$CI?$AA?5?$AAm?$AAa?$AAx?$AAs?$AAi?$AAz?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CJ?$AA?$AA@ 0109 ??_C@_1CI@MHCAEBKF@?$AA?$CI?$AA?5?$AAw?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CJ?$AA?$AA@ 015e _wcslen 018c _malloc 0195 __MarkAllocaS 021d ??_C@_1II@PPBCDDBB@?$AA_?$AAw?$AAc?$AAs?$AAt?$AAo?$AAm?$AAb?$AAs?$AA_?$AAs?$AA_?$AAl?$AA?$CI?$AA0?$AA?0?$AA?5?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?0?$AA?5?$AAf?$AAl?$AAe?$AAn?$AA?5?$AA?$CK?$AA?5@ 0242 __wcstombs_s_l 024b __invoke_watson_if_oneof 0279 __Strftime_l 0293 ??_C@_1JC@MHLGNKIL@?$AA_?$AAm?$AAb?$AAs?$AAt?$AAo?$AAw?$AAc?$AAs?$AA_?$AAs?$AA_?$AAl?$AA?$CI?$AA?$CG?$AAr?$AAe?$AAt?$AAv?$AAa?$AAl?$AA?0?$AA?5?$AAw?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?0?$AA?5@ 02b2 __mbstowcs_s_l 0303 __freea"
	strings:
		$1 = { 55 8B EC 83 EC 24 C7 45 FC 00 00 00 00 C7 45 F8 00 00 00 00 C7 45 F4 00 00 00 00 C7 45 F0 00 00 00 00 33 C0 83 7D 08 00 0F 95 C0 89 45 EC 83 7D EC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 47 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D EC 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 47 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 A2 02 00 00 33 D2 83 7D 0C 00 0F 95 C2 89 55 E8 83 7D E8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 48 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E8 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 48 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 3F 02 00 00 83 7D 0C 00 76 08 8B 4D 08 66 C7 01 00 00 33 D2 83 7D 10 00 0F 95 C2 89 55 E4 83 7D E4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 4E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E4 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 4E 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 CE 01 00 00 8B 4D 10 51 E8 ?? ?? ?? ?? 83 C4 04 83 C0 01 89 45 F0 33 D2 75 32 83 7D 0C 00 76 2C 81 7D 0C F0 FF FF 7F 77 23 68 DD DD 00 00 8B 45 0C 8D 4C 00 08 51 E8 ?? ?? ?? ?? 83 C4 04 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 E0 EB 07 C7 45 E0 00 00 00 00 8B 55 E0 89 55 F4 83 7D F4 00 75 07 33 C0 E9 6C 01 00 00 33 C0 75 32 83 7D F0 00 76 2C 81 7D F0 F0 FF FF 7F 77 23 68 DD DD 00 00 8B 4D F0 8D 54 09 08 52 E8 ?? ?? ?? ?? 83 C4 04 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 DC EB 07 C7 45 DC 00 00 00 00 8B 45 DC 89 45 F8 83 7D F8 00 75 0A E9 EF 00 00 00 E9 EA 00 00 00 6A 00 6A 5E 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 22 6A 16 8B 4D 18 51 8B 55 F0 8D 44 12 FF 50 8B 4D 10 51 8B 55 F0 D1 E2 52 8B 45 F8 50 6A 00 E8 ?? ?? ?? ?? 83 C4 18 50 E8 ?? ?? ?? ?? 83 C4 20 85 C0 74 0A E9 9D 00 00 00 E9 98 00 00 00 8B 4D 18 51 6A 00 8B 55 14 52 8B 45 F8 50 8B 4D 0C D1 E1 51 8B 55 F4 52 E8 ?? ?? ?? ?? 83 C4 18 85 C0 74 6D 6A 00 6A 65 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 22 6A 16 8B 45 18 50 6A FF 8B 4D F4 51 8B 55 0C 52 8B 45 08 50 8D 4D FC 51 E8 ?? ?? ?? ?? 83 C4 18 50 E8 ?? ?? ?? ?? 83 C4 20 85 C0 74 1A 8B 55 FC 3B 55 0C 72 0B E8 ?? ?? ?? ?? C7 00 22 00 00 00 C7 45 FC 00 00 00 00 83 7D FC 00 76 09 8B 45 FC 83 E8 01 89 45 FC EB 07 C7 45 FC 00 00 00 00 83 7D F8 00 74 0C 8B 4D F8 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 F4 52 E8 ?? ?? ?? ?? 83 C4 04 83 7D FC 00 75 08 8B 45 08 66 C7 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_293_0_0 {
	meta:
		name = "__mbsninc_l"
		size = 38
		refs = "001a __mbsnbcnt_l"
	strings:
		$1 = { 55 8B EC 83 7D 08 00 75 04 33 C0 EB 17 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 03 45 08 5D C3 }
	condition:
		$1
}

rule file_294_0_0 {
	meta:
		name = "__wfindfirst32i64"
		size = 713
		refs = "000a ___security_cookie 002d ??_C@_1BM@BDKGMOHE@?$AA?$CI?$AAp?$AAf?$AAd?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0036 ??_C@_1GG@MENEDOIE@?$AAf?$AA?3?$AA?2?$AAr?$AAt?$AAm?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2@ 003d __CrtDbgReportW 0054 __errno 0068 ??_C@_1CC@BDFEPCNA@?$AA_?$AAw?$AAf?$AAi?$AAn?$AAd?$AAf?$AAi?$AAr?$AAs?$AAt?$AA3?$AA2?$AAi?$AA6?$AA4?$AA?$AA@ 0072 __invalid_parameter 0095 ??_C@_1FK@EIHIEBPI@?$AA?$CI?$AAs?$AAi?$AAz?$AAe?$AAo?$AAf?$AA?$CI?$AAp?$AAf?$AAd?$AA?9?$AA?$DO?$AAn?$AAa?$AAm?$AAe?$AA?$CJ?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAs?$AAi?$AAz?$AAe?$AAo?$AAf?$AA?$CI?$AAw?$AAf?$AAd@ 0102 ??_C@_1CC@GOBCANBH@?$AA?$CI?$AAs?$AAz?$AAW?$AAi?$AAl?$AAd?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0163 __imp__FindFirstFileW@8 0172 __imp__GetLastError@0 01a9 $LN15 01b0 $LN16 0204 ___timet_from_ft 024a __allmul 0272 ??_C@_1JO@CLIBFCJI@?$AAw?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAp?$AAf?$AAd?$AA?9?$AA?$DO?$AAn?$AAa?$AAm?$AAe?$AA?0?$AA?5?$AA?$CI?$AAs?$AAi?$AAz?$AAe?$AAo?$AAf?$AA?$CI?$AAp?$AAf?$AAd?$AA?9@ 028a _wcscpy_s 0293 __invoke_watson_if_error 02a4 @__security_check_cookie@4 02ac $LN3 02b0 $LN2 02b4 $LN1"
	strings:
		$1 = { 55 8B EC 81 EC 6C 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 F8 56 33 C0 83 7D 0C 00 0F 95 C0 89 85 A0 FD FF FF 83 BD A0 FD FF FF 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 49 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD A0 FD FF FF 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 49 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 1C 02 00 00 C7 85 9C FD FF FF 01 00 00 00 83 BD 9C FD FF FF 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 4E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 9C FD FF FF 00 75 2E E8 ?? ?? ?? ?? C7 00 0C 00 00 00 6A 00 6A 4E 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 B4 01 00 00 33 C0 83 7D 08 00 0F 95 C0 89 85 98 FD FF FF 83 BD 98 FD FF FF 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 4F 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 98 FD FF FF 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 4F 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 47 01 00 00 8D 95 A8 FD FF FF 52 8B 45 08 50 FF 15 ?? ?? ?? ?? 89 45 FC 83 7D FC FF 75 71 FF 15 ?? ?? ?? ?? 89 85 A4 FD FF FF 8B 8D A4 FD FF FF 89 8D 94 FD FF FF 8B 95 94 FD FF FF 83 EA 02 89 95 94 FD FF FF 83 BD 94 FD FF FF 10 77 2E 8B 85 94 FD FF FF 0F B6 88 ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 00 02 00 00 00 EB 18 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB 0B E8 ?? ?? ?? ?? C7 00 16 00 00 00 83 C8 FF E9 BC 00 00 00 8B 95 A8 FD FF FF 81 EA 80 00 00 00 F7 DA 1B D2 23 95 A8 FD FF FF 8B 45 0C 89 10 8D 8D AC FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 0C 89 42 04 8D 85 B4 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 89 41 08 8D 95 BC FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 89 41 0C 8B 95 C4 FD FF FF 33 C0 6A 01 6A 00 50 52 E8 ?? ?? ?? ?? 8B 8D C8 FD FF FF 33 F6 03 C1 13 D6 8B 4D 0C 89 41 10 89 51 14 6A 00 6A 72 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 95 D4 FD FF FF 52 68 04 01 00 00 8B 45 0C 83 C0 18 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 45 FC 5E 8B 4D F8 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 02 02 02 02 01 02 02 02 02 02 02 02 02 02 00 }
	condition:
		$1
}

rule file_294_2_0 {
	meta:
		name = "__wfindnext32i64"
		size = 729
		refs = "000a ___security_cookie 002d ??_C@_1FA@DAHAMGDA@?$AA?$CI?$AA?$CI?$AAH?$AAA?$AAN?$AAD?$AAL?$AAE?$AA?$CJ?$AAh?$AAF?$AAi?$AAl?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAI?$AAN?$AAV?$AAA?$AAL?$AAI?$AAD?$AA_?$AAH?$AAA?$AAN?$AAD?$AAL?$AAE@ 0039 ??_C@_1GG@MENEDOIE@?$AAf?$AA?3?$AA?2?$AAr?$AAt?$AAm?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2@ 0040 __CrtDbgReportW 0057 __errno 006e ??_C@_1CA@ONJGDIHJ@?$AA_?$AAw?$AAf?$AAi?$AAn?$AAd?$AAn?$AAe?$AAx?$AAt?$AA3?$AA2?$AAi?$AA6?$AA4?$AA?$AA@ 0078 __invalid_parameter 00a0 ??_C@_1BM@BDKGMOHE@?$AA?$CI?$AAp?$AAf?$AAd?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 010e ??_C@_1FK@EIHIEBPI@?$AA?$CI?$AAs?$AAi?$AAz?$AAe?$AAo?$AAf?$AA?$CI?$AAp?$AAf?$AAd?$AA?9?$AA?$DO?$AAn?$AAa?$AAm?$AAe?$AA?$CJ?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAs?$AAi?$AAz?$AAe?$AAo?$AAf?$AA?$CI?$AAw?$AAf?$AAd@ 0175 __imp__FindNextFileW@8 017f __imp__GetLastError@0 01b6 $LN15 01bd $LN16 0211 ___timet_from_ft 0257 __allmul 0282 ??_C@_1JO@CLIBFCJI@?$AAw?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAp?$AAf?$AAd?$AA?9?$AA?$DO?$AAn?$AAa?$AAm?$AAe?$AA?0?$AA?5?$AA?$CI?$AAs?$AAi?$AAz?$AAe?$AAo?$AAf?$AA?$CI?$AAp?$AAf?$AAd?$AA?9@ 029a _wcscpy_s 02a3 __invoke_watson_if_error 02b3 @__security_check_cookie@4 02bc $LN3 02c0 $LN2 02c4 $LN1"
	strings:
		$1 = { 55 8B EC 81 EC 6C 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 33 C0 83 7D 08 FF 0F 95 C0 89 85 A0 FD FF FF 83 BD A0 FD FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 9C 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD A0 FD FF FF 00 75 31 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 9C 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 25 02 00 00 33 D2 83 7D 0C 00 0F 95 C2 89 95 9C FD FF FF 83 BD 9C FD FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 9D 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 9C FD FF FF 00 75 31 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 9D 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 B2 01 00 00 C7 85 98 FD FF FF 01 00 00 00 83 BD 98 FD FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 9E 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 98 FD FF FF 00 75 31 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 6A 00 68 9E 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 44 01 00 00 8D 95 A8 FD FF FF 52 8B 45 08 50 FF 15 ?? ?? ?? ?? 85 C0 75 71 FF 15 ?? ?? ?? ?? 89 85 A4 FD FF FF 8B 8D A4 FD FF FF 89 8D 94 FD FF FF 8B 95 94 FD FF FF 83 EA 02 89 95 94 FD FF FF 83 BD 94 FD FF FF 10 77 2E 8B 85 94 FD FF FF 0F B6 88 ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 00 02 00 00 00 EB 18 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB 0B E8 ?? ?? ?? ?? C7 00 16 00 00 00 83 C8 FF E9 BE 00 00 00 8B 95 A8 FD FF FF 81 EA 80 00 00 00 F7 DA 1B D2 23 95 A8 FD FF FF 8B 45 0C 89 10 8D 8D AC FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 0C 89 42 04 8D 85 B4 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 89 41 08 8D 95 BC FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 89 41 0C 8B 95 C4 FD FF FF 33 C0 6A 01 6A 00 50 52 E8 ?? ?? ?? ?? 8B 8D C8 FD FF FF 33 F6 03 C1 13 D6 8B 4D 0C 89 41 10 89 51 14 6A 00 68 C1 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 95 D4 FD FF FF 52 68 04 01 00 00 8B 45 0C 83 C0 18 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 33 C0 5E 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 02 02 02 02 01 02 02 02 02 02 02 02 02 02 00 }
	condition:
		$1
}

rule file_295_0_0 {
	meta:
		name = "__strnicoll_l"
		size = 583
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0023 ??1_LocaleUpdate@@QAE@XZ 0042 ??_C@_1CC@ICKKAGJA@?$AA_?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA1?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 004b ??_C@_1BG@BPACDEKP@?$AAs?$AAt?$AAr?$AAn?$AAi?$AAc?$AAo?$AAl?$AA?4?$AAc?$AA?$AA@ 0052 __CrtDbgReportW 0066 __errno 007a ??_C@_1BK@IOJEBPLP@?$AA_?$AAs?$AAt?$AAr?$AAn?$AAi?$AAc?$AAo?$AAl?$AAl?$AA_?$AAl?$AA?$AA@ 0084 __invalid_parameter 00b5 ??_C@_1CC@CNADELFK@?$AA_?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA2?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0128 ??_C@_1CC@JLPHKJPH@?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAI?$AAN?$AAT?$AA_?$AAM?$AAA?$AAX?$AA?$AA@ 018c ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 01ae __strnicmp_l 0200 ___crtCompareStringA"
	strings:
		$1 = { 55 8B EC 83 EC 3C 8B 45 14 50 8D 4D EC E8 ?? ?? ?? ?? 83 7D 10 00 75 17 C7 45 DC 00 00 00 00 8D 4D EC E8 ?? ?? ?? ?? 8B 45 DC E9 14 02 00 00 33 C9 83 7D 08 00 0F 95 C1 89 4D E8 83 7D E8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3F 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E8 00 75 3D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 3F 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 D8 FF FF FF 7F 8D 4D EC E8 ?? ?? ?? ?? 8B 45 D8 E9 A1 01 00 00 33 C0 83 7D 0C 00 0F 95 C0 89 45 E4 83 7D E4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 40 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E4 00 75 3D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 40 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 D4 FF FF FF 7F 8D 4D EC E8 ?? ?? ?? ?? 8B 45 D4 E9 2E 01 00 00 BA FF FF FF 7F 3B 55 10 1B C0 83 C0 01 89 45 E0 75 1E 68 ?? ?? ?? ?? 6A 00 6A 41 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 3D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 41 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 D0 FF FF FF 7F 8D 4D EC E8 ?? ?? ?? ?? 8B 45 D0 E9 BB 00 00 00 8D 4D EC E8 ?? ?? ?? ?? 8B 10 83 7A 10 00 75 2D 8D 4D EC E8 ?? ?? ?? ?? 50 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 89 45 CC 8D 4D EC E8 ?? ?? ?? ?? 8B 45 CC EB 7E 8D 4D EC E8 ?? ?? ?? ?? 8B 00 8B 48 08 51 8B 55 10 52 8B 45 0C 50 8B 4D 10 51 8B 55 08 52 68 01 10 00 00 8D 4D EC E8 ?? ?? ?? ?? 8B 00 8B 48 10 51 8D 4D EC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 20 89 45 FC 83 7D FC 00 75 1F E8 ?? ?? ?? ?? C7 00 16 00 00 00 C7 45 C8 FF FF FF 7F 8D 4D EC E8 ?? ?? ?? ?? 8B 45 C8 EB 14 8B 55 FC 83 EA 02 89 55 C4 8D 4D EC E8 ?? ?? ?? ?? 8B 45 C4 8B E5 5D C3 }
	condition:
		$1
}

rule file_295_4_0 {
	meta:
		name = "__strnicoll"
		size = 60
		refs = "0005 ___locale_changed 0019 __strnicmp 0033 __strnicoll_l"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? 00 75 18 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C EB 18 EB 16 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_297_0_0 {
	meta:
		name = "?_RTC_GetSrcLine@@YAHPAEPA_WKPAH1K@Z"
		size = 706
		refs = "0027 __imp__VirtualQuery@12 0044 __imp__GetModuleFileNameW@12 00a4 ?PDBOK@?BM@??_RTC_GetSrcLine@@YAHPAEPA_WKPAH1K@Z@4_NA 00ad _mspdb 00b5 ?GetPdbDll@@YAPAUHINSTANCE__@@XZ 00d1 ??_C@_0BB@KCIACLNC@PDBOpenValidate5?$AA@ 00d8 __imp__GetProcAddress@8 0129 ??_C@_01KDCPPGHE@r?$AA@ 01f8 __imp__GetProcessHeap@0 01ff __imp__HeapAlloc@12 028d __imp__HeapFree@12"
	strings:
		$1 = { 55 8B EC 8B 45 14 8B 4D 0C 83 EC 44 56 8B 75 08 6A 1C 8D 55 BC 52 83 EE 01 C7 00 00 00 00 00 56 66 C7 01 00 00 FF 15 ?? ?? ?? ?? 85 C0 75 07 33 C0 5E 8B E5 5D C3 8B 45 1C 8B 4D 18 8B 55 C0 50 51 52 FF 15 ?? ?? ?? ?? 85 C0 74 E3 8B 55 C0 66 81 3A 4D 5A 75 D9 8B 42 3C 85 C0 7E D2 03 C2 81 38 50 45 00 00 75 C8 0F B7 48 06 53 57 0F B7 78 14 8D 44 07 18 2B F2 33 FF 33 DB 85 C9 76 1C 83 C0 0C 8B 10 3B F2 72 09 8B FE 2B FA 3B 70 FC 72 0A 83 C3 01 83 C0 28 3B D9 72 E7 3B D9 74 5D 83 C3 01 80 3D ?? ?? ?? ?? 00 75 20 83 3D ?? ?? ?? ?? 00 75 48 E8 ?? ?? ?? ?? 85 C0 A3 ?? ?? ?? ?? 74 3A C6 05 ?? ?? ?? ?? 01 EB 05 A1 ?? ?? ?? ?? 68 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 33 F6 3B C6 74 1A 8D 4D F0 51 8B 4D 18 56 56 8D 55 D8 52 56 56 56 51 FF D0 83 C4 20 85 C0 75 09 5F 5B 33 C0 5E 8B E5 5D C3 8B 4D F0 8B 11 8B 02 89 75 E4 FF D0 3D B5 A5 31 01 0F 85 92 01 00 00 8B 4D F0 8B 11 8B 52 1C 8D 45 E8 50 68 ?? ?? ?? ?? 56 FF D2 85 C0 0F 84 76 01 00 00 8B 4D E8 8B 01 8B 40 20 56 56 56 8D 55 F4 52 57 53 FF D0 85 C0 0F 84 51 01 00 00 8B 4D F4 89 75 FC 8B 11 8B 52 68 8D 45 FC 50 FF D2 84 C0 0F 84 2E 01 00 00 8B 4D FC 3B CE 0F 84 23 01 00 00 8B 01 8B 50 08 FF D2 85 C0 0F 84 FB 00 00 00 8B 4D FC 8B 01 8B 40 0C 6A 00 8D 55 F8 52 8D 55 E0 52 8D 55 08 52 8D 55 EC 52 6A 00 FF D0 84 C0 0F 84 E5 00 00 00 0F B7 4D 08 3B CB 75 10 8B 45 EC 3B C7 77 09 8B 55 E0 03 C2 3B F8 72 13 8B 4D FC 8B 01 8B 50 08 FF D2 85 C0 75 B4 E9 AA 00 00 00 8B 45 F8 85 C0 0F 84 AF 00 00 00 3D FF FF FF 1F 0F 83 A4 00 00 00 03 C0 03 C0 03 C0 50 6A 00 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 8B F0 85 F6 0F 84 84 00 00 00 8B 4D FC 8B 11 8B 52 0C 56 8D 45 F8 50 6A 00 6A 00 6A 00 8D 45 DC 50 FF D2 84 C0 74 57 2B 7D EC 3B 3E 72 50 8B 4D F8 B8 01 00 00 00 3B C8 76 0F 8D 49 00 3B 3C C6 72 07 83 C0 01 3B C1 72 F4 8B 44 C6 FC 8B 4D 14 6A 00 25 FF FF FF 00 89 01 8B 4D F4 8B 11 8B 52 70 6A 00 6A 00 8D 45 10 50 8B 45 0C 50 8B 45 DC 50 FF D2 84 C0 74 07 C7 45 E4 01 00 00 00 56 6A 00 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 8B 4D FC 8B 01 8B 10 FF D2 8B 4D F4 8B 01 8B 50 40 FF D2 8B 4D E8 8B 01 8B 50 38 FF D2 8B 4D F0 8B 01 8B 50 28 FF D2 8B 45 E4 5F 5B 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_297_1_0 {
	meta:
		name = "?GetPdbDll@@YAPAUHINSTANCE__@@XZ"
		size = 444
		refs = "000a ___security_cookie 0015 ?alreadyTried@?1??GetPdbDll@@YAPAUHINSTANCE__@@XZ@4HA 0024 @__security_check_cookie@4 002d _mspdbName 0034 __imp__LoadLibraryA@4 004e ??_C@_0N@JJPEKNFO@ADVAPI32?4DLL?$AA@ 006c __imp__GetProcAddress@8 0071 ??_C@_0O@DCOGKJGG@RegOpenKeyExA?$AA@ 0094 ??_C@_0BB@HHEIPGME@RegQueryValueExA?$AA@ 00a2 ??_C@_0M@HLOHPNFA@RegCloseKey?$AA@ 00bb ??_C@_0CN@EAEOKKOC@SOFTWARE?2Microsoft?2VisualStudio?2@ 00e6 ??_C@_0BF@BMIHBHCA@EnvironmentDirectory?$AA@ 0105 __imp__FreeLibrary@4"
	strings:
		$1 = { 55 8B EC 81 EC 18 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 83 3D ?? ?? ?? ?? 00 74 10 33 C0 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 A1 ?? ?? ?? ?? 56 8B 35 ?? ?? ?? ?? 50 C7 05 ?? ?? ?? ?? 01 00 00 00 FF D6 85 C0 0F 85 60 01 00 00 68 ?? ?? ?? ?? FF D6 8B F0 85 F6 75 0F 5E 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 53 8B 1D ?? ?? ?? ?? 68 ?? ?? ?? ?? 56 FF D3 85 C0 89 85 EC FE FF FF 75 10 5B 5E 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 57 68 ?? ?? ?? ?? 56 FF D3 8B F8 85 FF 74 68 68 ?? ?? ?? ?? 56 FF D3 8B D8 85 DB 74 5A 8D 8D F0 FE FF FF 51 6A 01 6A 00 68 ?? ?? ?? ?? 68 02 00 00 80 FF 95 EC FE FF FF 85 C0 75 34 8B 8D F0 FE FF FF 8D 95 F4 FE FF FF 52 50 8D 85 E8 FE FF FF 50 6A 00 68 ?? ?? ?? ?? 51 FF D7 85 C0 75 11 8B 95 F4 FE FF FF 83 C2 0D 81 FA 04 01 00 00 72 1A 56 FF 15 ?? ?? ?? ?? 5F 5B 33 C0 5E 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 8D 85 F4 FE FF FF 50 8B 85 F0 FE FF FF 8D 8D F8 FE FF FF 51 8D 95 E8 FE FF FF 52 6A 00 68 ?? ?? ?? ?? 50 FF D7 8B 8D F0 FE FF FF 51 8B F8 FF D3 56 FF 15 ?? ?? ?? ?? 85 FF 75 B2 8B 8D F4 FE FF FF B0 5C 38 84 0D F6 FE FF FF 74 09 88 84 0D F7 FE FF FF EB 09 83 E9 01 89 8D F4 FE FF FF 8B 35 ?? ?? ?? ?? 33 C0 8D 8C 0D F8 FE FF FF 8D A4 24 00 00 00 00 8A 14 06 88 14 01 83 C0 01 83 F8 0B 7E F2 8D 85 F8 FE FF FF 50 FF 15 ?? ?? ?? ?? 5F 5B 8B 4D FC 33 CD 5E E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_298_0_0 {
	meta:
		name = "__sse2_mathfcns_init"
		size = 27
		refs = "0005 ___use_sse2_mathfcns 000e __get_sse2_info"
	strings:
		$1 = { 55 8B EC C7 05 ?? ?? ?? ?? 00 00 00 00 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 33 C0 5D C3 }
	condition:
		$1
}

rule file_298_1_0 {
	meta:
		name = "__set_SSE2_enable"
		size = 28
		refs = "000c ___sse2_available 0011 ___use_sse2_mathfcns"
	strings:
		$1 = { 55 8B EC 8B 45 08 F7 D8 1B C0 23 05 ?? ?? ?? ?? A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_299_0_0 {
	meta:
		name = "__mbsstr_l"
		size = 581
		refs = "000f ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0017 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 002d _strstr 003b ??1_LocaleUpdate@@QAE@XZ 005a ??_C@_1BK@KMBNCAPN@?$AAs?$AAt?$AAr?$AA2?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0063 ??_C@_1BC@PCFNNFND@?$AAm?$AAb?$AAs?$AAs?$AAt?$AAr?$AA?4?$AAc?$AA?$AA@ 006a __CrtDbgReportW 007e __errno 0092 ??_C@_1BE@KLCPDEDD@?$AA_?$AAm?$AAb?$AAs?$AAs?$AAt?$AAr?$AA_?$AAl?$AA?$AA@ 009c __invalid_parameter 00ed ??_C@_1BK@DLEGNDH@?$AAs?$AAt?$AAr?$AA1?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0158 _strlen"
	strings:
		$1 = { 55 8B EC 83 EC 40 56 8B 45 10 50 8D 4D E4 E8 ?? ?? ?? ?? 8D 4D E4 E8 ?? ?? ?? ?? 8B 48 04 83 79 08 00 75 23 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 D4 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 D4 E9 F9 01 00 00 33 C9 83 7D 0C 00 0F 95 C1 89 4D DC 83 7D DC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 38 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D DC 00 75 3D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 38 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 D0 00 00 00 00 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 D0 E9 86 01 00 00 8B 45 0C 0F B6 08 85 C9 75 16 8B 55 08 89 55 CC 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 CC E9 66 01 00 00 33 C0 83 7D 08 00 0F 95 C0 89 45 D8 83 7D D8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3B 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D8 00 75 3D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 3B 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 C8 00 00 00 00 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 C8 E9 F3 00 00 00 8B 55 08 89 55 FC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 8B F0 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 04 2B F0 03 75 08 89 75 E0 8B 55 FC 0F B6 02 85 C0 0F 84 AB 00 00 00 8B 4D FC 3B 4D E0 0F 87 9F 00 00 00 8B 55 FC 89 55 F4 8B 45 0C 89 45 F8 8B 4D F4 0F B6 11 85 D2 74 2E 8B 45 F8 0F B6 08 85 C9 74 24 8B 55 F4 0F B6 02 8B 4D F8 0F B6 11 3B C2 75 14 8B 45 F4 83 C0 01 89 45 F4 8B 4D F8 83 C1 01 89 4D F8 EB C8 8B 55 F8 0F B6 02 85 C0 75 13 8B 4D FC 89 4D C4 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 C4 EB 50 8B 55 FC 0F B6 32 8D 4D E4 E8 ?? ?? ?? ?? 8B 40 04 0F B6 4C 30 1D 83 E1 04 8B 55 FC 83 C2 01 89 55 FC 85 C9 74 13 8B 45 FC 0F B6 08 85 C9 74 09 8B 55 FC 83 C2 01 89 55 FC E9 47 FF FF FF C7 45 C0 00 00 00 00 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 C0 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_300_0_0 {
	meta:
		name = "__mbsnbcat_s_l"
		size = 2014
		refs = "005b ??_C@_1FC@NCPEPIBI@?$AA?$CI?$AA?$CI?$AA_?$AAD?$AAs?$AAt?$AA?$CJ?$AA?$CJ?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?$CI?$AA_?$AAS?$AAi?$AAz?$AAe?$AAI?$AAn?$AAB?$AAy?$AAt@ 0064 ??_C@_1GM@POEFFBHC@?$AAF?$AA?3?$AA?2?$AAR?$AAT?$AAM?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAS?$AAE?$AAL?$AAF?$AA_?$AAX?$AA8?$AA6?$AA?2@ 006b __CrtDbgReportW 007f __errno 0093 ??_C@_1BM@BENFBNLI@?$AA_?$AAm?$AAb?$AAs?$AAn?$AAb?$AAc?$AAa?$AAt?$AA_?$AAs?$AA_?$AAl?$AA?$AA@ 009d __invalid_parameter 00e5 ___crtDebugFillThreshold 0119 _memset 0133 ??_C@_1CG@OFBJMIGJ@?$AA?$CI?$AA?$CI?$AA?$CI?$AA_?$AAS?$AAr?$AAc?$AA?$CJ?$AA?$CJ?$AA?$CJ?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 018e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0196 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 01b4 _strncat_s 01c2 ??1_LocaleUpdate@@QAE@XZ 0266 ??_C@_1DM@FHLMIEG@?$AAS?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AAi?$AAs?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAn?$AAu?$AAl?$AAl?$AA?5?$AAt?$AAe?$AAr?$AAm?$AAi?$AAn?$AAa?$AAt?$AAe?$AAd?$AA?$AA@ 0298 ??_C@_1FA@MJKDNFFB@?$AA?$CI?$AAL?$AA?$CC?$AAS?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AAi?$AAs?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAn?$AAu?$AAl?$AAl?$AA?5?$AAt?$AAe?$AAr?$AAm?$AAi?$AAn?$AAa?$AAt?$AAe?$AAd@ 0335 __ismbblead_l 03bd __CrtGetCheckCount 03ce ??_C@_1CI@HCPHDDLE@?$AAB?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AAi?$AAs?$AA?5?$AAt?$AAo?$AAo?$AA?5?$AAs?$AAm?$AAa?$AAl?$AAl?$AA?$AA@ 064f ??_C@_1DM@MADKGDLO@?$AA?$CI?$AAL?$AA?$CC?$AAB?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AAi?$AAs?$AA?5?$AAt?$AAo?$AAo?$AA?5?$AAs?$AAm?$AAa?$AAl?$AAl?$AA?$CC?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA0?$AA?$CJ?$AA?$AA@"
	strings:
		$1 = { 55 8B EC 81 EC 9C 00 00 00 C7 45 E8 00 00 00 00 83 7D 14 00 75 13 83 7D 08 00 75 0D 83 7D 0C 00 75 07 33 C0 E9 B1 07 00 00 83 7D 08 00 74 12 83 7D 0C 00 76 0C C7 85 7C FF FF FF 01 00 00 00 EB 0A C7 85 7C FF FF FF 00 00 00 00 8B 85 7C FF FF FF 89 45 DC 83 7D DC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 20 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D DC 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 20 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 2C 07 00 00 83 7D 14 00 0F 84 CE 00 00 00 83 7D 10 00 0F 85 C4 00 00 00 8B 55 08 C6 02 00 83 7D 0C FF 74 52 81 7D 0C FF FF FF 7F 74 49 83 7D 0C 01 76 43 8B 45 0C 83 E8 01 39 05 ?? ?? ?? ?? 73 0E 8B 0D ?? ?? ?? ?? 89 8D 78 FF FF FF EB 0C 8B 55 0C 83 EA 01 89 95 78 FF FF FF 8B 85 78 FF FF FF 50 68 FD 00 00 00 8B 4D 08 83 C1 01 51 E8 ?? ?? ?? ?? 83 C4 0C 33 D2 83 7D 10 00 0F 95 C2 89 55 D8 83 7D D8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 23 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D8 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 54 06 00 00 8B 4D 18 51 8D 4D EC E8 ?? ?? ?? ?? 8D 4D EC E8 ?? ?? ?? ?? 8B 50 04 83 7A 08 00 75 2B 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 9C 8D 4D EC E8 ?? ?? ?? ?? 8B 45 9C E9 0C 06 00 00 8B 4D 08 89 4D FC 8B 55 0C 89 55 E4 83 7D E4 00 76 1E 8B 45 FC 0F B6 08 85 C9 74 14 8B 55 FC 83 C2 01 89 55 FC 8B 45 E4 83 E8 01 89 45 E4 EB DC 83 7D E4 00 0F 85 F0 00 00 00 8B 4D 08 C6 01 00 83 7D 0C FF 74 51 81 7D 0C FF FF FF 7F 74 48 83 7D 0C 01 76 42 8B 55 0C 83 EA 01 39 15 ?? ?? ?? ?? 73 0D A1 ?? ?? ?? ?? 89 85 74 FF FF FF EB 0C 8B 4D 0C 83 E9 01 89 8D 74 FF FF FF 8B 95 74 FF FF FF 52 68 FD 00 00 00 8B 45 08 83 C0 01 50 E8 ?? ?? ?? ?? 83 C4 0C B9 ?? ?? ?? ?? 85 C9 74 10 33 D2 74 0C C7 85 70 FF FF FF 01 00 00 00 EB 0A C7 85 70 FF FF FF 00 00 00 00 8B 85 70 FF FF FF 89 45 D4 83 7D D4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 40 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D4 00 75 3D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 40 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 98 16 00 00 00 8D 4D EC E8 ?? ?? ?? ?? 8B 45 98 E9 E2 04 00 00 8B 55 E4 3B 55 0C 73 7E C7 45 E0 00 00 00 00 8B 45 08 89 45 CC 8B 4D FC 83 E9 01 89 4D D0 8B 55 D0 89 55 C8 8B 45 C8 3B 45 CC 72 27 8D 4D EC E8 ?? ?? ?? ?? 50 8B 4D C8 0F B6 11 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 0B 8B 45 C8 83 E8 01 89 45 C8 EB D1 8B 4D D0 2B 4D C8 83 E1 01 F7 D9 1B C9 F7 D9 89 4D E0 74 1F 8B 55 FC 83 EA 01 89 55 FC 8B 45 FC C6 00 00 8B 4D E4 83 C1 01 89 4D E4 C7 45 E8 01 00 00 00 83 7D 14 FF 75 38 8B 55 FC 8B 45 10 8A 08 88 0A 8B 55 FC 0F B6 02 8B 4D FC 83 C1 01 89 4D FC 8B 55 10 83 C2 01 89 55 10 85 C0 74 0D 8B 45 E4 83 E8 01 89 45 E4 74 02 EB CD E9 86 00 00 00 E8 ?? ?? ?? ?? 85 C0 74 26 8B 4D 14 3B 4D E4 72 1E 68 ?? ?? ?? ?? 6A 00 6A 5D 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D 14 00 76 3C 8B 45 FC 8B 4D 10 8A 11 88 10 8B 45 FC 0F B6 08 8B 55 FC 83 C2 01 89 55 FC 8B 45 10 83 C0 01 89 45 10 85 C9 74 16 8B 4D E4 83 E9 01 89 4D E4 74 0B 8B 55 14 83 EA 01 89 55 14 EB BE 83 7D 14 00 75 0F 8B 45 FC C6 00 00 8B 4D FC 83 C1 01 89 4D FC 83 7D E4 00 0F 85 69 02 00 00 8B 55 10 0F B6 02 85 C0 74 0A 83 7D 14 01 0F 85 81 00 00 00 8B 4D 08 89 4D C0 8B 55 FC 83 EA 01 89 55 C4 8B 45 C4 89 45 BC 8B 4D BC 3B 4D C0 72 27 8D 4D EC E8 ?? ?? ?? ?? 50 8B 55 BC 0F B6 02 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 0B 8B 4D BC 83 E9 01 89 4D BC EB D1 8B 55 C4 2B 55 BC 83 E2 01 F7 DA 1B D2 F7 DA 89 55 E0 74 29 8B 45 FC C6 40 FF 00 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 C7 45 94 2A 00 00 00 8D 4D EC E8 ?? ?? ?? ?? 8B 45 94 E9 F9 02 00 00 83 7D 14 FF 0F 85 D3 00 00 00 83 7D E8 00 74 0B E8 ?? ?? ?? ?? C7 00 2A 00 00 00 83 7D 0C 01 0F 86 97 00 00 00 C7 45 E0 00 00 00 00 8B 4D 08 89 4D B4 8B 55 0C 8B 45 08 8D 4C 10 FE 89 4D B8 8B 55 B8 89 55 B0 8B 45 B0 3B 45 B4 72 27 8D 4D EC E8 ?? ?? ?? ?? 50 8B 4D B0 0F B6 11 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 0B 8B 45 B0 83 E8 01 89 45 B0 EB D1 8B 4D B8 2B 4D B0 83 E1 01 F7 D9 1B C9 F7 D9 89 4D E0 74 34 8B 55 08 03 55 0C C6 42 FE 00 83 3D ?? ?? ?? ?? 00 76 0A 8B 45 08 03 45 0C C6 40 FF FD C7 45 90 50 00 00 00 8D 4D EC E8 ?? ?? ?? ?? 8B 45 90 E9 3D 02 00 00 8B 4D 08 03 4D 0C C6 41 FF 00 C7 45 8C 50 00 00 00 8D 4D EC E8 ?? ?? ?? ?? 8B 45 8C E9 1C 02 00 00 8B 55 08 C6 02 00 83 7D 0C FF 74 52 81 7D 0C FF FF FF 7F 74 49 83 7D 0C 01 76 43 8B 45 0C 83 E8 01 39 05 ?? ?? ?? ?? 73 0E 8B 0D ?? ?? ?? ?? 89 8D 6C FF FF FF EB 0C 8B 55 0C 83 EA 01 89 95 6C FF FF FF 8B 85 6C FF FF FF 50 68 FD 00 00 00 8B 4D 08 83 C1 01 51 E8 ?? ?? ?? ?? 83 C4 0C BA ?? ?? ?? ?? 85 D2 74 10 33 C0 74 0C C7 85 68 FF FF FF 01 00 00 00 EB 0A C7 85 68 FF FF FF 00 00 00 00 8B 8D 68 FF FF FF 89 4D AC 83 7D AC 00 75 21 68 ?? ?? ?? ?? 6A 00 68 BC 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D AC 00 75 40 E8 ?? ?? ?? ?? C7 00 22 00 00 00 6A 00 68 BC 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 88 22 00 00 00 8D 4D EC E8 ?? ?? ?? ?? 8B 45 88 E9 25 01 00 00 8B 45 E4 3B 45 0C 73 6F 8B 4D 08 89 4D A4 8B 55 FC 83 EA 02 89 55 A8 8B 45 A8 89 45 A0 8B 4D A0 3B 4D A4 72 27 8D 4D EC E8 ?? ?? ?? ?? 50 8B 55 A0 0F B6 02 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 0B 8B 4D A0 83 E9 01 89 4D A0 EB D1 8B 55 A8 2B 55 A0 83 E2 01 F7 DA 1B D2 F7 DA 89 55 E0 74 17 8B 45 FC C6 40 FE 00 8B 4D E4 83 C1 01 89 4D E4 C7 45 E8 01 00 00 00 83 7D 0C FF 74 71 81 7D 0C FF FF FF 7F 74 68 8B 55 0C 2B 55 E4 83 C2 01 3B 55 0C 73 5A 8B 45 0C 2B 45 E4 83 C0 01 8B 4D 0C 2B C8 39 0D ?? ?? ?? ?? 73 0E 8B 15 ?? ?? ?? ?? 89 95 64 FF FF FF EB 14 8B 45 0C 2B 45 E4 83 C0 01 8B 4D 0C 2B C8 89 8D 64 FF FF FF 8B 95 64 FF FF FF 52 68 FD 00 00 00 8B 45 0C 2B 45 E4 8B 4D 08 8D 54 01 01 52 E8 ?? ?? ?? ?? 83 C4 0C 83 7D E8 00 74 1F E8 ?? ?? ?? ?? C7 00 2A 00 00 00 C7 45 84 2A 00 00 00 8D 4D EC E8 ?? ?? ?? ?? 8B 45 84 EB 12 C7 45 80 00 00 00 00 8D 4D EC E8 ?? ?? ?? ?? 8B 45 80 8B E5 5D C3 }
	condition:
		$1
}

rule file_302_0_0 {
	meta:
		name = "___security_init_cookie"
		size = 282
		refs = "0016 ___security_cookie 0036 ___security_cookie_complement 005f __except_handler4 0066 ??_C@_0OH@IHEJDJAH@Microsoft?5Visual?5C?$CL?$CL?5Runtime?5Lib@ 006e __imp__FatalAppExitA@8 0086 __imp__GetSystemTimeAsFileTime@4 009b __imp__GetCurrentProcessId@0 00a7 __imp__GetCurrentThreadId@0 00b3 __imp__GetTickCount@0 00c3 __imp__QueryPerformanceCounter@4"
	strings:
		$1 = { 55 8B EC 83 EC 18 C7 45 F8 00 00 00 00 C7 45 FC 00 00 00 00 81 3D ?? ?? ?? ?? 4E E6 40 BB 74 1F A1 ?? ?? ?? ?? 25 00 00 FF FF 74 13 8B 0D ?? ?? ?? ?? F7 D1 89 0D ?? ?? ?? ?? E9 D7 00 00 00 64 8B 15 00 00 00 00 89 55 F0 EB 08 8B 45 F0 8B 08 89 4D F0 83 7D F0 FF 74 27 8B 55 F0 81 7A 04 ?? ?? ?? ?? 75 0D 68 ?? ?? ?? ?? 6A 00 FF 15 ?? ?? ?? ?? 8B 45 F0 8B 4D F0 3B 08 72 02 EB 02 EB CB 8D 55 F8 52 FF 15 ?? ?? ?? ?? 8B 45 F8 89 45 F4 8B 4D F4 33 4D FC 89 4D F4 FF 15 ?? ?? ?? ?? 33 45 F4 89 45 F4 FF 15 ?? ?? ?? ?? 33 45 F4 89 45 F4 FF 15 ?? ?? ?? ?? 33 45 F4 89 45 F4 8D 55 E8 52 FF 15 ?? ?? ?? ?? 8B 45 F4 33 45 E8 89 45 F4 8B 4D F4 33 4D EC 89 4D F4 81 7D F4 4E E6 40 BB 75 09 C7 45 F4 4F E6 40 BB EB 17 8B 55 F4 81 E2 00 00 FF FF 75 0C 8B 45 F4 C1 E0 10 0B 45 F4 89 45 F4 8B 4D F4 89 0D ?? ?? ?? ?? 8B 55 F4 F7 D2 89 15 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_303_0_0 {
	meta:
		name = "__ismbcprint_l"
		size = 355
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0049 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0061 ??1_LocaleUpdate@@QAE@XZ 00a3 ___crtGetStringTypeA"
	strings:
		$1 = { 55 8B EC 83 EC 30 8B 45 0C 50 8D 4D F0 E8 ?? ?? ?? ?? 81 7D 08 FF 00 00 00 0F 86 DC 00 00 00 66 C7 45 EC 00 00 33 C9 66 89 4D EE 8B 55 08 C1 EA 08 81 E2 FF 00 00 00 88 55 E8 8B 45 08 25 FF 00 00 00 88 45 E9 8D 4D F0 E8 ?? ?? ?? ?? 8B 48 04 83 79 08 00 75 17 C7 45 E4 00 00 00 00 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 E4 E9 F2 00 00 00 6A 01 8D 4D F0 E8 ?? ?? ?? ?? 8B 50 04 8B 42 0C 50 8D 4D F0 E8 ?? ?? ?? ?? 8B 48 04 8B 51 04 52 8D 45 EC 50 6A 02 8D 4D E8 51 6A 01 8D 4D F0 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 20 85 C0 75 17 C7 45 E0 00 00 00 00 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 E0 E9 9A 00 00 00 0F B7 55 EE 85 D2 75 12 0F B7 45 EC 83 E0 20 75 09 C7 45 D4 01 00 00 00 EB 07 C7 45 D4 00 00 00 00 8B 4D D4 89 4D DC 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 DC EB 66 EB 5C 8D 4D F0 E8 ?? ?? ?? ?? 8B 10 0F B6 45 08 8B 8A C8 00 00 00 0F B7 14 41 81 E2 57 01 00 00 75 22 8D 4D F0 E8 ?? ?? ?? ?? 8B 40 04 0F B6 4D 08 0F B6 54 08 1D 83 E2 03 75 09 C7 45 D0 00 00 00 00 EB 07 C7 45 D0 01 00 00 00 8B 45 D0 89 45 D8 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 D8 EB 08 8D 4D F0 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_304_0_0 {
	meta:
		name = "___libm_sse2_sinf"
		size = 335
		refs = "001b _PI_32_RECIP 0027 _BIT_31 003b _SHIFTER 0066 _P_1 0072 _P_2 0078 _Ctable 009e _C_1 00a6 _S_1 00b6 _C_2 00be _S_2 00ca _ONE 010a _ONE_M230 0139 _sin"
	strings:
		$1 = { 66 0F C5 C0 01 66 25 FF 7F 66 2D 80 00 66 3D 7F 45 0F 87 E9 00 00 00 F2 0F 10 0D ?? ?? ?? ?? F3 0F 59 C8 66 0F 28 1D ?? ?? ?? ?? F3 0F 2D D1 66 0F 54 D8 F3 0F 5A C0 F3 0F 58 0D ?? ?? ?? ?? F3 0F 5C 0D ?? ?? ?? ?? 66 0F 28 E3 66 0F 73 F3 20 66 0F 73 F4 1D 66 0F 57 DC 81 C2 00 76 1C 00 83 E2 3F F2 0F 10 15 ?? ?? ?? ?? 66 0F 57 D3 66 0F 57 1D ?? ?? ?? ?? 8D 05 ?? ?? ?? ?? C1 E2 04 03 C2 66 0F 73 F1 1D F2 0F 59 D1 F2 0F 59 D9 F2 0F 5C C2 F2 0F 58 D8 F2 0F 59 C0 F2 0F 10 25 ?? ?? ?? ?? F2 0F 10 2D ?? ?? ?? ?? F2 0F 59 E0 F2 0F 59 E8 F2 0F 10 35 ?? ?? ?? ?? F2 0F 10 3D ?? ?? ?? ?? F2 0F 59 C0 F2 0F 58 25 ?? ?? ?? ?? F2 0F 59 F0 F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 F8 F2 0F 58 E6 F2 0F 58 EF F2 0F 10 10 F2 0F 59 58 08 F2 0F 59 D4 F2 0F 59 DD F2 0F 58 D3 F2 0F 5A C2 C3 7F 11 F3 0F 5A C0 F2 0F 59 05 ?? ?? ?? ?? F2 0F 5A C0 C3 66 0F 7E C0 25 00 00 80 7F 3D 00 00 80 7F 74 27 8B C4 83 EC 20 83 E4 F0 89 44 24 08 F3 0F 5A C0 66 0F D6 04 24 E8 ?? ?? ?? ?? D9 1C 24 F3 0F 10 04 24 8B 64 24 08 C3 F3 0F 5C C0 C3 }
	condition:
		$1
}

rule file_305_0_0 {
	meta:
		name = "??2@YAPAXIHPBDH@Z"
		size = 40
		refs = "0017 __nh_malloc_dbg"
	strings:
		$1 = { 55 8B EC 51 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 6A 01 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 89 45 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_305_1_0 {
	meta:
		name = "??_U@YAPAXIHPBDH@Z"
		size = 38
		refs = "0015 ??2@YAPAXIHPBDH@Z"
	strings:
		$1 = { 55 8B EC 51 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_306_0_0 {
	meta:
		name = "__ftelli64"
		size = 172
		refs = "0006 __sehtable$__ftelli64 000b __except_handler4 001d ___security_cookie 0037 ??_C@_1BO@KIJENGPH@?$AAs?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0040 ??_C@_1BG@BIAHDJMM@?$AAf?$AAt?$AAe?$AAl?$AAl?$AAi?$AA6?$