private rule architecture {
	meta:
		bits = 64
		endianness = "little"
		architecture = "x64"
	condition:
		true
}

rule file_2_0_0 {
	meta:
		name = "__vdecl_fmod2"
		size = 61
		refs = "0011 fmod"
	strings:
		$1 = { 48 83 EC 48 F3 0F 7F 44 24 20 F3 0F 7F 4C 24 30 E8 ?? ?? ?? ?? 66 0F D6 44 24 20 F3 0F 7E 44 24 28 F3 0F 7E 4C 24 38 E8 ?? ?? ?? ?? 66 0F D6 44 24 28 F3 0F 6F 44 24 20 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_4_0_0 {
	meta:
		name = "__avx_sinf8"
		size = 2784
		refs = "0080 __common_ssin_data 0213 __common_ssin_cout_rare 0248 __common_ssin_reduction_data"
	strings:
		$1 = { 56 41 56 41 57 48 81 EC C0 02 00 00 33 F6 C5 7C 11 BC 24 A0 02 00 00 C5 7C 11 B4 24 60 02 00 00 C5 7C 11 AC 24 20 02 00 00 C5 7C 11 A4 24 40 02 00 00 C5 7C 11 9C 24 C0 01 00 00 C5 7C 11 94 24 E0 01 00 00 C5 7C 11 8C 24 A0 01 00 00 C5 7C 11 84 24 80 02 00 00 C5 FC 11 BC 24 80 01 00 00 C5 FC 11 B4 24 00 02 00 00 C5 C1 EF FF 4C 89 AC 24 D8 00 00 00 4C 8D AC 24 1F 01 00 00 C5 FC 10 35 ?? ?? ?? ?? 49 83 E5 C0 C5 FC 54 D6 C5 EC C2 0D ?? ?? ?? ?? 1E C4 E3 7D 19 CB 01 C5 F1 6B E3 C5 D9 63 EF C5 F9 D7 C5 84 C0 0F 85 6A 01 00 00 C5 7C 10 05 ?? ?? ?? ?? C5 EC 59 1D ?? ?? ?? ?? C4 C1 64 58 E0 C5 CC 55 C8 C5 D1 72 F4 1F C4 41 5C 5C E8 C5 14 59 0D ?? ?? ?? ?? C5 14 59 15 ?? ?? ?? ?? C5 14 59 25 ?? ?? ?? ?? C5 14 59 3D ?? ?? ?? ?? C4 C1 6C 5C D1 C4 41 6C 5C DA C4 41 24 5C F4 C4 C1 0C 5C D7 C5 6C 59 D2 C4 E3 7D 19 E6 01 C5 AC 59 25 ?? ?? ?? ?? C5 C1 72 F6 1F C4 E3 55 18 DF 01 C5 DC 58 2D ?? ?? ?? ?? C4 C1 54 59 F2 C5 CC 58 3D ?? ?? ?? ?? C4 41 44 59 C2 C5 3C 58 0D ?? ?? ?? ?? C4 41 34 59 DA C5 6C 57 EB C4 41 24 59 E5 C4 41 1C 58 F5 C5 8C 57 C9 40 84 F6 75 73 C5 FC 10 B4 24 00 02 00 00 C5 FC 10 BC 24 80 01 00 00 C5 7C 10 84 24 80 02 00 00 C5 7C 10 8C 24 A0 01 00 00 C5 7C 10 94 24 E0 01 00 00 C5 7C 10 9C 24 C0 01 00 00 C5 7C 10 A4 24 40 02 00 00 C5 7C 10 AC 24 20 02 00 00 C5 7C 10 B4 24 60 02 00 00 C5 7C 10 BC 24 A0 02 00 00 4C 8B AC 24 D8 00 00 00 C5 FC 28 C1 48 81 C4 C0 02 00 00 41 5F 41 5E 5E C3 C4 C1 7C 11 45 00 C4 C1 7C 11 4D 40 85 F6 0F 84 79 FF FF FF 45 33 F6 44 0F A3 F6 72 14 41 FF C6 41 83 FE 20 7C F1 C4 C1 7C 10 4D 40 E9 5C FF FF FF C5 F8 77 4B 8D 4C B5 00 4B 8D 54 B5 40 E8 ?? ?? ?? ?? EB D8 C5 7C 10 15 ?? ?? ?? ?? BA 00 00 80 7F C4 C1 7C 11 45 00 C5 79 6E C2 C4 41 79 70 E8 00 C5 AC 54 F2 BA FF 00 00 00 C4 C1 4C C2 CA 00 48 8D 05 ?? ?? ?? ?? C5 91 DB E0 C4 C3 7D 19 C7 01 C5 89 72 D4 17 C4 41 11 DB CF C4 C1 19 72 F6 01 C4 C1 21 72 D1 17 C4 C1 19 FE EE C4 C1 49 72 F3 01 C4 41 49 FE D3 C4 C1 31 72 F2 02 C4 41 79 7E CE C5 F8 11 44 24 20 C5 78 11 7C 24 30 C4 43 79 16 CF 01 C4 63 79 16 CE 02 C4 E3 7D 19 CB 01 C5 F1 6B D3 C5 F1 72 F5 02 C5 E9 63 FF C5 F9 D7 CF C4 C1 79 7E C8 C4 41 79 6E 24 06 C4 41 79 6E 34 07 89 8C 24 D0 00 00 00 C4 63 79 16 C9 03 C4 C3 79 16 CA 02 C4 C3 79 16 CB 03 C4 C3 79 16 C9 01 C5 F9 6E 2C 06 C5 F9 6E 34 01 C4 C1 79 6E 3C 02 C4 41 79 6E 04 03 C4 41 19 6C DE C5 51 6C D6 C5 F9 6E 6C 06 04 C5 F9 6E 74 01 04 C4 41 41 6C E8 C4 41 20 C6 C2 88 C4 41 79 6E 64 06 04 C4 41 79 6E 74 07 04 C5 51 6C D6 C4 C1 79 6E 6C 07 08 41 BF FF FF 7F 00 C4 C1 79 6E 1C 00 C4 C1 79 6E 14 01 C4 41 19 6C DE C4 41 79 6E 74 06 08 41 BE 00 00 80 00 C5 E1 6C E2 C4 C1 79 6E 4C 00 04 C4 C1 79 6E 5C 01 04 C4 C1 79 6E 54 02 04 C4 C1 79 6E 7C 03 04 C4 41 58 C6 ED 88 C5 F1 6C E3 C5 69 6C CF C4 C1 79 6E 7C 03 08 41 BB FF FF 00 00 C4 C1 79 6E 4C 00 08 41 B8 00 00 40 47 C4 C1 79 6E 5C 01 08 41 B9 00 00 80 3F C4 C1 79 6E 54 02 08 41 BA 00 00 00 80 C4 C1 58 C6 E1 88 C5 71 6C CB C5 69 6C E7 C4 C1 79 6E FF C4 C1 30 C6 CC 88 C4 41 79 6E CE C5 79 70 E7 00 41 BF 00 00 80 28 C5 89 6C DD C5 99 DB C0 C4 C1 79 70 E9 00 C4 41 19 DB FF C4 41 20 C6 D2 88 C5 79 FE F5 C5 F9 6E 74 06 08 C4 C1 79 6E C3 C5 79 6E 5C 01 08 48 8D 05 ?? ?? ?? ?? 41 BE FF FF 03 00 C4 C1 49 6C D3 C5 81 FE F5 C5 79 70 F8 00 C5 A1 72 D4 10 C4 C1 11 DB FF C4 41 09 DB CF C5 78 11 44 24 50 C4 41 39 DB E7 C5 E0 C6 DA 88 C4 C1 39 72 D2 10 C4 C1 29 DB C7 C5 E9 72 D1 10 C4 C1 29 72 D6 10 C4 41 49 DB F7 C5 FA 7F 7C 24 60 C4 C1 59 DB EF C4 E2 31 40 FF C4 C1 71 DB CF C5 FA 7F BC 24 B0 00 00 00 C5 D9 72 D3 10 C4 E2 29 40 FA C4 C1 61 DB DF C4 E2 31 40 D2 41 BB 00 00 00 34 C5 78 11 6C 24 40 C5 91 72 D6 10 C4 C2 09 40 F4 C5 E9 72 D2 10 C5 7A 7F 64 24 70 C5 C1 FE FA C5 7A 7F 84 24 90 00 00 00 B9 7A 77 95 B7 C5 FA 7F 84 24 A0 00 00 00 BE FF FF FF 7F C5 FA 7F B4 24 C0 00 00 00 C4 42 09 40 E0 C4 E2 31 40 F5 C4 62 09 40 C0 C4 E2 29 40 C1 C4 C1 39 DB D7 C5 F1 72 D0 10 C4 C1 49 DB C7 C5 F9 FE C7 C5 C9 72 D6 10 C5 F1 FE F8 C4 C1 39 72 D0 10 C4 E2 11 40 C3 C4 E2 11 40 DC C5 F9 72 D0 10 C4 E2 09 40 E4 C5 F1 72 D4 10 C5 E1 FE D9 C5 F1 72 D7 10 C5 7A 7F 9C 24 80 00 00 00 C5 E9 FE D3 C4 42 31 40 DB C5 F9 FE E2 C4 E2 29 40 ED C4 C1 21 DB C7 C5 D1 FE DE C4 C1 19 DB D7 C5 F9 FE C3 C5 E1 72 D4 10 C5 F1 FE F0 C4 C1 21 72 D3 10 C4 E2 11 40 8C 24 A0 00 00 00 C5 D1 72 D6 10 C4 C1 71 FE C0 C4 C1 19 72 D4 10 C5 E9 FE C8 C4 C1 41 DB FF C4 E2 29 40 94 24 80 00 00 00 C5 61 FE C1 C5 FA 6F 9C 24 B0 00 00 00 C4 C1 69 FE C3 C4 C1 61 DB CF C4 C1 69 72 D0 10 C5 F1 FE C8 C4 C1 39 72 F0 10 C4 62 11 40 9C 24 90 00 00 00 C5 D1 FE E9 C5 FA 6F 8C 24 C0 00 00 00 C4 41 21 FE DC C4 C1 71 DB C7 C5 99 72 D5 10 C4 C1 79 FE C3 C5 F1 72 D1 10 C5 78 10 5C 24 40 C5 E9 FE D0 C4 C1 79 72 D3 10 C4 C1 51 DB EF C4 62 29 40 54 24 60 C4 41 79 6E D9 C4 62 31 40 C8 C5 F9 72 D3 10 C4 41 31 DB CF C5 29 FE D0 C4 C1 31 FE DA C5 F9 72 D2 10 C5 19 FE CB C4 C1 69 DB D7 C5 F8 10 5C 24 50 C4 C1 19 72 F1 10 C5 B1 72 D3 10 C5 19 FE D5 C4 62 11 40 6C 24 70 41 B9 DB 0F C9 40 C4 42 09 40 F1 C5 11 FE E9 C4 C1 09 DB DF C4 41 59 DB FF C4 41 61 FE CD C4 C1 79 6E E2 C4 C1 79 FE C1 C5 89 72 F6 10 C5 F9 70 F4 00 C5 99 72 F0 10 C5 C9 DB 6C 24 20 C5 09 FE CF C4 C1 79 70 FB 00 C5 99 FE C2 C5 49 DB 74 24 30 C4 C1 71 72 D2 09 C5 D1 EF DF C4 41 79 6E E0 C4 41 39 FE FF C5 B9 72 D0 09 C5 89 EF E7 C5 F1 EB D3 C4 C1 79 70 F4 00 C5 39 EB EC C4 41 79 6E E7 41 BA FF 01 00 00 41 B8 00 10 C9 40 41 BF 00 00 80 35 C4 C3 6D 18 CD 01 C5 F9 6E D2 C4 63 4D 18 DE 01 BA 00 F0 FF FF C5 A4 58 E1 C5 79 70 C2 00 C4 C1 5C 5C DB C5 74 5C EB C4 C1 79 70 CC 00 C4 41 79 6E E6 C5 D1 EF D1 C5 89 EF D9 C4 C1 79 70 CC 00 C4 C1 71 DB F1 C4 C1 71 DB CF C5 A1 72 F6 05 C5 99 72 F1 05 C5 21 EB DA C5 99 EB F3 C4 C1 31 72 D1 12 C4 C1 01 72 D7 12 C4 E3 6D 18 DB 01 C4 C1 79 6E D2 C4 E3 25 18 CE 01 C5 79 6E D9 C5 F9 70 F2 00 C4 C1 79 6E D1 C5 74 5C E3 C4 C1 79 6E CB C4 41 49 DB D2 C5 C9 DB C0 C5 F9 70 D9 00 C4 C1 29 72 F2 0E C5 D1 EF EB C4 41 29 EB D1 C5 A9 EB CD C5 A9 72 F0 0E C5 09 EF F3 C4 41 29 EB D7 C4 C1 29 EB C6 C4 E3 75 18 D8 01 C4 43 55 18 F6 01 C4 C1 79 6E E8 C4 41 64 5C D6 C5 F9 70 F5 00 C4 41 14 58 CA C4 C1 14 5C C1 C5 79 70 EA 00 C5 AC 58 C8 C5 79 6E D2 C4 C1 79 70 C2 00 C4 41 74 58 FC C4 41 79 70 E3 00 C4 E3 7D 18 C8 01 C5 B4 54 E9 C5 34 5C CD C4 43 15 18 ED 01 C4 E3 4D 18 D6 01 C4 C1 79 6E F7 C4 C3 1D 18 DC 01 C4 41 6C 59 D1 C5 E4 59 CD C4 41 14 59 F7 C4 C1 64 59 D9 C5 EC 59 C5 C5 F9 6E D6 C5 F9 70 EA 00 C5 79 70 CE 00 C5 2C 58 F9 C5 0C 58 D3 C4 C1 04 58 DA C5 FC 58 CB C5 FC 5C C1 C5 7C 58 D3 C4 C1 7C 10 45 00 8B B4 24 D0 00 00 00 C4 E3 7D 19 E7 01 C4 C1 59 DB E0 C5 E9 72 F4 04 C4 C1 41 DB F8 C4 C1 79 7E D7 C4 C3 79 16 D6 01 C4 C3 79 16 D3 02 C4 C3 79 16 D2 03 C4 41 79 6E 04 07 C4 C1 79 6E 14 06 C4 43 35 18 E9 01 C5 B1 72 F7 04 C4 41 79 7E C9 C4 C1 79 6E 24 02 C4 43 79 16 C8 01 C4 63 79 16 C9 02 C4 63 79 16 CA 03 C4 41 79 6E 4C 02 04 C4 63 55 18 DD 01 C4 41 7C 54 E3 C4 C1 1C C2 DD 1E C4 41 1C C2 F5 12 C5 B9 6C EA C4 41 79 6E 04 03 C5 B9 6C F4 C4 41 79 6E 44 03 04 C5 0C 54 F8 C5 E4 54 C9 C5 D0 C6 FE 88 C4 41 79 6E 1C 01 C4 41 79 6E 24 00 C5 79 6E 2C 01 C5 79 6E 34 02 C4 C1 79 6E 6C 07 04 C4 C1 79 6E 74 06 04 C5 84 56 C9 C4 41 21 6C FC C4 C1 11 6C D6 C5 51 6C DE C4 41 39 6C E1 C5 80 C6 E2 88 C4 41 20 C6 EC 88 C4 41 64 54 D2 C5 F4 59 D9 C4 E3 45 18 D4 01 C4 C1 79 6E 64 01 04 48 8D 05 ?? ?? ?? ?? C4 41 79 6E 5C 00 04 C5 79 6E 64 01 04 C5 79 6E 74 02 04 C4 41 59 6C FB C4 41 19 6C C6 C4 41 00 C6 C0 88 C4 43 15 18 C8 01 C4 41 79 6E 6C 07 0C C4 41 79 6E 44 06 0C C4 C1 79 6E 74 03 0C C4 C1 79 6E 6C 02 0C C4 C1 11 6C E0 C4 41 79 6E 64 01 0C C4 41 79 6E 6C 00 0C C5 79 6E 74 01 0C C5 79 6E 7C 02 0C C5 C9 6C FD C4 41 19 6C C5 C4 C1 09 6C F7 C5 58 C6 DF 88 C5 B8 C6 EE 88 C5 6C 59 F9 C4 E3 25 18 FD 01 C5 74 59 E7 C4 41 34 58 EC C4 C1 34 5C E5 C4 41 04 58 C5 C4 C1 5C 58 EC C4 41 14 5C F0 C4 41 79 6E 6C 02 08 C5 E4 59 25 ?? ?? ?? ?? C4 C1 0C 58 F7 C5 5C 58 1D ?? ?? ?? ?? C5 EC 58 E7 C5 CC 58 F5 C4 C1 79 6E 7C 07 08 C5 24 59 E3 C5 E4 59 15 ?? ?? ?? ?? C4 41 79 6E 5C 06 08 C4 41 41 6C F3 C4 C1 79 6E 7C 01 08 C4 41 79 6E 5C 00 08 C5 9C 59 E9 C4 C1 74 59 C9 C4 41 79 6E 64 03 08 C4 41 19 6C FD C5 EC 58 15 ?? ?? ?? ?? C4 41 41 6C EB C5 F9 6E 7C 01 08 C5 DC 5C C9 C5 79 6E 64 02 08 C5 EC 59 DB C5 2C 59 D1 C4 C1 08 C6 D7 88 C4 41 41 6C F4 C4 41 10 C6 FE 88 C4 C1 64 59 D9 C5 D4 59 E9 C5 D4 58 F6 C4 C3 6D 18 D7 01 C5 2C 58 D2 C4 C1 64 58 E2 C5 DC 58 FE C5 BC 58 CF E9 89 F6 FF FF 66 66 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_6_2_0 {
	meta:
		name = "__scrt_initialize_default_local_stdio_options"
		size = 69
		refs = "0005 __local_stdio_printf_options 0023 __local_stdio_scanf_options"
	strings:
		$1 = { 48 83 EC 38 E8 ?? ?? ?? ?? 48 89 44 24 20 48 8B 44 24 20 48 8B 00 48 83 C8 04 48 8B 4C 24 20 48 89 01 E8 ?? ?? ?? ?? 48 89 44 24 28 48 8B 44 24 28 48 8B 00 48 83 C8 02 48 8B 4C 24 28 48 89 01 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_9_0_0 {
	meta:
		name = "__avx_cosf8"
		size = 2768
		refs = "007f __common_scos_data 020d __common_scos_cout_rare 0242 __common_scos_reduction_data"
	strings:
		$1 = { 53 56 41 56 48 81 EC C0 02 00 00 33 DB C5 7C 11 BC 24 E0 01 00 00 C5 7C 11 B4 24 A0 02 00 00 C5 7C 11 AC 24 80 01 00 00 C5 7C 11 A4 24 A0 01 00 00 C5 7C 11 9C 24 C0 01 00 00 C5 7C 11 94 24 40 02 00 00 C5 7C 11 8C 24 20 02 00 00 C5 7C 11 84 24 80 02 00 00 C5 FC 11 BC 24 60 02 00 00 C5 FC 11 B4 24 00 02 00 00 C5 C9 EF F6 4C 89 AC 24 D8 00 00 00 4C 8D AC 24 1F 01 00 00 C5 FC 54 2D ?? ?? ?? ?? 49 83 E5 C0 C5 D4 C2 0D ?? ?? ?? ?? 1E C4 E3 7D 19 CA 01 C5 F1 6B DA C5 E1 63 E6 C5 F9 D7 C4 84 C0 0F 85 69 01 00 00 C5 FC 58 0D ?? ?? ?? ?? C5 FC 10 3D ?? ?? ?? ?? C5 F4 59 15 ?? ?? ?? ?? C5 EC 58 DF C5 D9 72 F3 1F C5 64 5C C7 C5 3C 5C 35 ?? ?? ?? ?? C5 0C 59 0D ?? ?? ?? ?? C5 0C 59 1D ?? ?? ?? ?? C5 0C 59 2D ?? ?? ?? ?? C4 41 7C 5C D1 C4 41 2C 5C E3 C4 E3 7D 19 DD 01 C5 8C 59 1D ?? ?? ?? ?? C5 C9 72 F5 1F C4 41 1C 5C FD C5 84 5C FB C5 44 59 D7 C5 AC 59 15 ?? ?? ?? ?? C4 E3 5D 18 CE 01 C5 EC 58 25 ?? ?? ?? ?? C4 C1 5C 59 EA C5 D4 58 35 ?? ?? ?? ?? C4 41 4C 59 C2 C5 3C 58 0D ?? ?? ?? ?? C4 41 34 59 DA C5 44 57 E9 C4 41 24 59 E5 C4 C1 1C 58 CD 84 DB 75 72 C5 FC 10 B4 24 00 02 00 00 C5 FC 10 BC 24 60 02 00 00 C5 7C 10 84 24 80 02 00 00 C5 7C 10 8C 24 20 02 00 00 C5 7C 10 94 24 40 02 00 00 C5 7C 10 9C 24 C0 01 00 00 C5 7C 10 A4 24 A0 01 00 00 C5 7C 10 AC 24 80 01 00 00 C5 7C 10 B4 24 A0 02 00 00 C5 7C 10 BC 24 E0 01 00 00 4C 8B AC 24 D8 00 00 00 C5 FC 28 C1 48 81 C4 C0 02 00 00 41 5E 5E 5B C3 C4 C1 7C 11 45 00 C4 C1 7C 11 4D 40 85 DB 0F 84 7A FF FF FF 33 F6 0F A3 F3 72 12 FF C6 83 FE 20 7C F4 C4 C1 7C 10 4D 40 E9 61 FF FF FF C5 F8 77 49 8D 4C B5 00 49 8D 54 B5 40 E8 ?? ?? ?? ?? EB DA C5 7C 10 1D ?? ?? ?? ?? BA 00 00 80 7F C4 C1 7C 11 45 00 C5 79 6E EA C4 C1 79 70 D5 00 C5 24 54 CD BA FF 00 00 00 C4 41 34 C2 D3 00 48 8D 05 ?? ?? ?? ?? C4 63 7D 19 D7 01 C5 29 6B C7 C5 B9 63 E6 C5 F9 D7 CC 89 8C 24 D0 00 00 00 C5 E9 DB F0 C4 C3 7D 19 C7 01 C5 D1 72 D6 17 C4 C1 69 DB DF C5 89 72 F5 01 C5 B1 72 D3 17 C5 89 FE CD C4 C1 19 72 F1 01 C5 A9 72 F1 02 C4 41 19 FE D9 C4 C1 61 72 F3 02 C4 C1 79 7E DB C5 79 7E D6 C5 F8 11 44 24 20 C5 78 11 7C 24 30 C4 C3 79 16 DE 01 C4 E3 79 16 DB 02 C4 E3 79 16 D9 03 C4 43 79 16 D0 01 C4 43 79 16 D1 02 C4 43 79 16 D2 03 C4 41 79 6E 34 03 C4 C1 79 6E 2C 06 C5 F9 6E 0C 03 C5 79 6E 24 01 C5 F9 6E 3C 06 C4 41 79 6E 04 00 C4 C1 79 6E 24 01 C4 41 79 6E 2C 02 C5 09 6C CD C4 41 71 6C DC C4 41 79 6E 74 03 04 C4 C1 79 6E 6C 06 04 C5 F9 6E 4C 03 04 C5 79 6E 64 01 04 C4 C1 41 6C F0 C4 C1 59 6C D5 C4 41 30 C6 C3 88 C5 79 6E 54 06 04 C4 C1 79 6E 7C 00 04 C5 09 6C CD C4 41 71 6C DC C5 48 C6 EA 88 C4 C1 79 6E 64 01 04 C4 C1 79 6E 74 02 04 C5 A9 6C D7 C4 41 30 C6 D3 88 C4 41 79 6E 4C 06 08 41 BE FF FF 7F 00 C5 D9 6C DE C4 41 79 6E 64 03 08 41 BB 00 00 80 00 C5 E8 C6 E3 88 C5 F9 6E 7C 06 08 BE 00 00 40 47 C4 C1 79 6E 74 00 08 41 B8 00 00 80 3F C4 C1 79 6E 54 01 08 41 B9 00 00 00 80 C4 C1 79 6E 5C 02 08 41 BA FF FF 00 00 C5 41 6C F6 C5 E9 6C EB C5 88 C6 CD 88 C4 41 79 6E F6 C4 C1 19 6C F1 C4 C1 79 6E EB C4 41 79 70 E6 00 41 BB FF FF 03 00 C5 79 6E 5C 03 08 C5 99 DB C0 C5 F9 6E 7C 01 08 48 8D 05 ?? ?? ?? ?? C4 41 19 DB FF C5 79 70 CD 00 41 BE 00 00 80 28 C5 A1 6C D7 C4 41 79 FE F1 C4 C1 79 6E C2 C5 A1 72 D4 10 C5 C8 C6 DA 88 C4 C1 01 FE F1 C5 79 70 F8 00 C5 E9 72 D1 10 C4 C1 11 DB FF C4 41 09 DB CF C5 78 11 44 24 50 C4 41 39 DB E7 C4 C1 39 72 D2 10 C4 C1 29 DB C7 C4 C1 29 72 D6 10 C4 41 49 DB F7 C5 FA 7F 7C 24 60 C4 C1 59 DB EF C4 E2 31 40 FF C4 C1 71 DB CF C5 FA 7F BC 24 B0 00 00 00 C5 D9 72 D3 10 C4 E2 29 40 FA C4 C1 61 DB DF C4 E2 31 40 D2 41 BA 00 00 00 34 C5 78 11 6C 24 40 C5 91 72 D6 10 C4 C2 09 40 F4 C5 E9 72 D2 10 C5 7A 7F 64 24 70 C5 C1 FE FA C5 7A 7F 84 24 90 00 00 00 B9 7A 77 95 B7 C5 FA 7F 84 24 A0 00 00 00 BB FF FF FF 7F C5 FA 7F B4 24 C0 00 00 00 C4 42 09 40 E0 C4 E2 31 40 F5 C4 62 09 40 C0 C4 E2 29 40 C1 C5 F1 72 D0 10 C4 C1 49 DB C7 C5 F9 FE C7 C5 C9 72 D6 10 C5 F1 FE F8 C4 C1 39 DB CF C4 E2 11 40 C3 C4 C1 39 72 D0 10 C4 E2 11 40 DC C5 F9 72 D0 10 C4 E2 09 40 E4 C5 D9 72 D4 10 C5 E1 FE D4 C5 7A 7F 9C 24 80 00 00 00 C5 F1 FE DA C4 42 31 40 DB C5 F9 FE E3 C4 E2 29 40 ED C4 C1 21 DB C7 C5 D1 FE CE C5 E9 72 D7 10 C5 F9 FE C1 C4 C1 19 DB EF C5 E9 FE F0 C5 E1 72 D4 10 C4 E2 11 40 94 24 A0 00 00 00 C4 C1 21 72 D3 10 C4 C1 69 FE C0 C4 C1 19 72 D4 10 C5 51 FE C0 C5 F9 72 D6 10 C4 E2 29 40 94 24 80 00 00 00 C4 41 61 FE C0 C5 FA 6F 9C 24 B0 00 00 00 C4 41 69 FE DB C4 C1 61 DB CF C4 C1 41 DB FF C4 C1 71 FE D3 C5 C9 72 F6 10 C5 FA 6F 8C 24 C0 00 00 00 C5 F9 FE EA C4 62 11 40 9C 24 90 00 00 00 C4 C1 71 DB C7 C4 41 21 FE DC C4 C1 69 72 D0 10 C4 C1 79 FE C3 C5 99 72 D5 10 C5 E9 FE D0 C4 C1 51 DB EF C5 F8 10 44 24 40 C4 C1 39 72 F0 10 C5 A1 72 D0 10 C4 42 31 40 CB C4 62 29 40 54 24 60 C4 C1 31 DB C7 C5 B1 72 D3 10 C4 41 29 FE D9 C5 B1 72 D2 10 C4 C1 79 FE C3 C4 C1 69 DB D7 C5 19 FE D0 C4 41 79 6E E0 C5 F8 10 44 24 50 C4 C1 61 72 F2 10 C5 A1 72 D0 10 C5 F9 72 D1 10 C4 62 11 40 6C 24 70 C5 61 FE D5 C4 42 09 40 F3 C5 11 FE E8 C4 41 09 DB DF C4 41 59 DB FF C4 C1 21 FE DD C4 C1 79 6E E1 C5 31 FE CB C4 C1 21 72 D2 09 C5 F9 70 CC 00 C4 C1 09 72 F1 10 C5 F1 DB 6C 24 20 C5 89 FE C2 C4 C1 79 70 E4 00 C5 49 FE CF C5 71 DB 74 24 30 C5 D1 EF FC C5 F9 6E DE C5 91 72 D0 09 C5 89 EF F4 C4 41 39 FE FF C5 F9 70 CB 00 C5 21 EB C7 C5 91 EB D6 C4 C1 79 6E F6 41 B9 FF 01 00 00 41 B8 DB 0F C9 40 C5 F9 70 DE 00 BE 00 10 C9 40 C5 89 EF F3 41 BE 00 00 80 35 C4 63 3D 18 DA 01 C5 D1 EF D3 C4 63 75 18 E1 01 C4 C1 79 6E CB C4 C1 1C 58 E3 C5 79 6E C2 C4 41 79 70 C0 00 C4 C1 5C 5C FC BA 00 F0 FF FF C5 24 5C EF C5 79 70 D9 00 C4 41 21 DB E1 C4 41 21 DB DF C4 C1 61 72 F4 05 C4 C1 21 72 F3 05 C5 61 EB E2 C5 A1 EB DE C4 C1 31 72 D1 12 C4 C1 01 72 D7 12 C4 E3 1D 18 CB 01 C4 41 79 6E E1 C4 63 6D 18 DE 01 C4 C1 79 6E F2 C4 C1 74 5C DB C4 C1 79 70 CC 00 C5 79 6E E2 C4 41 71 DB D2 C5 F1 DB C0 C5 F9 70 D6 00 C4 C1 21 72 F2 0E C5 D1 EF EA C4 41 21 EB C9 C5 31 EB DD C5 B1 72 F0 0E C5 09 EF F2 C4 41 31 EB CF C4 C1 31 EB C6 C5 79 6E FE C4 C1 79 70 CF 00 C4 63 25 18 D0 01 C4 43 55 18 F6 01 C4 41 2C 5C CE C4 41 79 6E D0 C4 41 79 70 F4 00 C4 C1 14 58 D1 C5 94 5C C2 C4 41 79 70 EA 00 C5 34 58 D8 C5 A4 58 F3 C5 F9 6E D9 C5 F9 70 EB 00 C4 43 0D 18 CE 01 C4 41 6C 54 D9 C4 C1 6C 5C D3 C4 C3 15 18 C5 01 C4 63 75 18 F9 01 C4 63 55 18 ED 01 C4 C1 79 6E EE C4 41 04 59 D3 C5 04 59 CA C4 41 14 59 DB C5 FC 59 F6 C5 94 59 C2 C5 F9 6E D3 C5 F9 70 DA 00 C4 41 34 58 CB C5 4C 58 D8 C5 F9 70 F5 00 C4 C1 7C 10 45 00 C4 C1 34 58 CB C5 2C 58 D9 C4 41 2C 5C D3 C5 2C 58 C9 8B 9C 24 D0 00 00 00 C4 63 65 18 E3 01 C4 41 7C 54 EC C4 63 4D 18 F6 01 C4 C1 14 C2 CE 1E C4 41 14 C2 FE 12 C5 04 54 D0 C4 41 74 54 DB C4 41 2C 56 DB C4 41 74 54 D1 C4 41 24 59 CB C4 E3 7D 19 E7 01 C4 C1 59 DB E0 C5 F1 72 F4 04 C4 C1 41 DB F8 C4 C1 79 7E CE C5 D1 72 F7 04 C4 C1 79 7E E8 C4 C3 79 16 CB 01 C4 C3 79 16 CA 02 C4 C3 79 16 C9 03 C4 E3 79 16 EE 01 C4 E3 79 16 E9 02 C4 E3 79 16 EA 03 C4 41 79 6E 04 06 C4 C1 79 6E 3C 03 C5 B9 6C D7 C4 C1 79 6E 0C 02 C4 41 79 6E 04 01 C4 C1 71 6C D8 C4 C1 79 6E 34 00 C5 79 6E 24 06 C5 E8 C6 E3 88 C4 41 49 6C FC C5 79 6E 2C 01 C5 79 6E 34 02 C4 C1 79 6E 54 06 04 C4 C1 79 6E 5C 03 04 C4 C1 79 6E 6C 02 04 C4 C1 79 6E 74 01 04 C4 C1 11 6C FE C5 69 6C C3 C5 51 6C E6 C5 80 C6 CF 88 C4 41 38 C6 EC 88 C4 E3 5D 18 F9 01 C4 C1 79 6E 4C 00 04 48 8D 05 ?? ?? ?? ?? C5 79 6E 44 06 04 C5 79 6E 64 01 04 C5 79 6E 74 02 04 C4 41 71 6C F8 C4 C1 19 6C E6 C5 80 C6 E4 88 C4 E3 15 18 F4 01 C4 41 79 6E 6C 06 08 C4 C1 79 6E 64 03 08 C4 C1 79 6E 54 02 08 C4 C1 79 6E 4C 01 08 C5 91 6C EC C4 41 79 6E 64 00 08 C5 79 6E 6C 06 08 C5 79 6E 74 01 08 C5 79 6E 7C 02 08 C5 E9 6C D9 C4 C1 19 6C E5 C4 C1 09 6C D7 C5 50 C6 C3 88 C5 D8 C6 CA 88 C4 C1 79 6E 5C 06 0C C4 41 79 6E 64 03 0C C4 41 79 6E 6C 02 0C C4 41 79 6E 74 01 0C C4 41 61 6C FC C5 F9 6E 5C 06 0C C5 79 6E 64 02 0C C4 C1 11 6C E6 C5 80 C6 D4 88 C4 E3 3D 18 E9 01 C4 C1 79 6E 4C 00 0C C5 79 6E 44 01 0C C5 71 6C EB C4 41 39 6C F4 C4 41 10 C6 FE 88 C4 41 44 59 EB C4 C3 6D 18 DF 01 C5 A4 59 CB C5 C4 58 DB C5 B4 59 3D ?? ?? ?? ?? C5 4C 58 C1 C5 C4 58 3D ?? ?? ?? ?? C4 C1 4C 5C D0 C4 C1 14 58 E0 C5 6C 58 F9 C5 3C 5C E4 C5 B4 59 0D ?? ?? ?? ?? C4 41 1C 58 F5 C5 74 58 05 ?? ?? ?? ?? C4 C1 0C 58 D7 C4 41 3C 59 E1 C4 41 44 59 C9 C4 C1 1C 59 CB C5 24 59 DE C5 B4 59 F6 C4 C1 64 5C DB C5 2C 59 D3 C5 F4 59 CB C5 AC 58 ED C5 F4 58 D2 C5 CC 58 FD C5 44 58 C2 C4 C1 5C 58 C8 E9 97 F6 FF FF 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_12_0_0 {
	meta:
		name = "__common_satan_cout_rare"
		size = 1584
		refs = "004f _vmlsAtanHATab"
	strings:
		$1 = { 48 83 EC 78 44 0F B7 49 02 41 81 E1 80 7F 00 00 41 C1 E9 07 44 0F 29 7C 24 50 41 81 F9 FF 00 00 00 0F 29 7C 24 60 0F 84 B1 05 00 00 F3 0F 10 09 F3 0F 5A C1 F2 0F 11 44 24 70 80 64 24 77 7F F2 0F 10 44 24 70 8A 41 03 C0 E8 07 66 0F 2F 05 ?? ?? ?? ?? 4C 8B 44 24 70 0F 82 5B 04 00 00 F2 0F 10 0D ?? ?? ?? ?? 66 0F 2F C8 0F 86 14 04 00 00 4C 89 44 24 30 44 0F 28 F8 44 8B 44 24 34 45 8B C8 41 81 E0 00 00 08 00 41 81 E1 00 00 F0 FF 41 81 C8 00 00 04 00 4C 8D 1D ?? ?? ?? ?? 45 0B C8 C7 44 24 30 00 00 00 00 44 89 4C 24 34 F2 0F 10 0D ?? ?? ?? ?? 0F 28 E1 F2 44 0F 5C 7C 24 30 C0 E0 07 F2 41 0F 59 E7 F2 0F 11 64 24 38 F2 0F 10 54 24 38 44 0F B7 54 24 76 F2 41 0F 5C D7 F2 0F 11 54 24 40 41 81 E2 F0 7F 00 00 F2 0F 10 5C 24 38 F2 0F 10 6C 24 40 41 C1 EA 04 F2 0F 5C DD F2 0F 11 5C 24 38 0F 28 E8 F2 0F 10 7C 24 38 F2 0F 59 2D ?? ?? ?? ?? F2 44 0F 5C FF F2 44 0F 11 7C 24 40 F2 0F 10 5C 24 38 F2 0F 10 64 24 40 F2 0F 11 6C 24 38 F2 0F 10 7C 24 38 8B 4C 24 74 41 C1 E2 14 81 E1 FF FF 0F 00 44 0B D1 F2 0F 5C 7C 24 70 F2 0F 11 7C 24 40 41 81 C2 00 00 40 C0 F2 0F 10 6C 24 38 F2 0F 10 54 24 40 41 C1 FA 12 F2 0F 5C EA F2 0F 11 6C 24 38 41 83 E2 FE F2 0F 10 7C 24 38 4D 63 D2 F2 0F 5C C7 F2 0F 11 44 24 40 F2 44 0F 10 7C 24 38 F2 0F 10 44 24 30 F2 0F 10 54 24 40 F2 44 0F 59 F8 F2 0F 59 D0 41 0F 28 EF F2 0F 58 EA F2 0F 11 6C 24 38 F2 0F 10 7C 24 38 F2 44 0F 5C FF F2 41 0F 58 D7 F2 0F 11 54 24 40 F2 0F 10 15 ?? ?? ?? ?? F2 0F 10 44 24 38 0F 28 FA F2 0F 10 6C 24 40 F2 0F 58 F8 F2 0F 11 7C 24 38 0F 28 FA F2 44 0F 10 7C 24 38 F2 41 0F 5C FF F2 0F 11 7C 24 40 F2 0F 10 7C 24 38 F2 44 0F 10 7C 24 40 F2 41 0F 58 FF F2 0F 11 7C 24 48 0F 28 FA F2 44 0F 10 7C 24 40 F2 41 0F 58 C7 F2 0F 11 44 24 40 F2 0F 10 44 24 48 F2 0F 5C F8 F2 0F 11 7C 24 48 F2 0F 10 7C 24 40 F2 44 0F 10 7C 24 48 F2 41 0F 58 FF F2 0F 11 7C 24 48 F2 44 0F 10 7C 24 38 F2 0F 10 44 24 48 F2 0F 58 C5 41 0F 28 EF F2 0F 59 E9 F2 0F 11 6C 24 38 F2 0F 10 7C 24 38 F2 41 0F 5C FF F2 0F 11 7C 24 40 F2 0F 10 7C 24 38 F2 0F 10 6C 24 40 F2 0F 5C FD F2 0F 11 7C 24 38 F2 0F 10 6C 24 38 F2 44 0F 5C FD F2 44 0F 11 7C 24 40 F2 0F 10 7C 24 38 F2 0F 10 6C 24 40 F2 0F 58 E8 0F 28 C2 F2 0F 5E C7 F2 0F 59 C8 F2 0F 11 4C 24 40 F2 0F 10 4C 24 40 F2 0F 5C C8 F2 0F 11 4C 24 48 F2 0F 10 44 24 40 F2 44 0F 10 7C 24 48 F2 41 0F 5C C7 F2 0F 11 44 24 48 F2 0F 10 4C 24 48 F2 0F 59 F9 F2 0F 5C D7 F2 0F 10 7C 24 48 F2 0F 59 EF F2 0F 11 6C 24 40 F2 0F 10 6C 24 40 F2 0F 5C D5 F2 0F 11 54 24 40 F2 44 0F 10 7C 24 40 F2 0F 10 7C 24 48 F2 0F 10 54 24 40 F2 0F 10 6C 24 48 F2 44 0F 58 3D ?? ?? ?? ?? F2 44 0F 59 FA F2 44 0F 59 FD 0F 28 EF F2 0F 59 FC F2 0F 59 EB F2 41 0F 59 DF 41 0F 28 C7 F2 0F 59 C4 F2 44 0F 10 3D ?? ?? ?? ?? F2 0F 58 C7 F2 43 0F 10 14 D3 F2 0F 58 C3 F2 0F 11 44 24 38 0F 28 DD F2 0F 10 7C 24 38 0F 28 C2 F2 0F 58 DF F2 0F 11 5C 24 38 F2 0F 10 64 24 38 F2 0F 5C EC F2 0F 58 EF F2 0F 11 6C 24 40 F2 0F 10 5C 24 38 0F 28 EB F2 0F 58 C3 F2 0F 59 EB F2 44 0F 59 FD F2 0F 10 7C 24 40 F2 0F 11 44 24 38 F2 0F 10 4C 24 38 F2 44 0F 58 3D ?? ?? ?? ?? F2 0F 5C D1 F2 44 0F 59 FD F2 0F 58 D3 F2 44 0F 58 3D ?? ?? ?? ?? F2 44 0F 59 FD F2 0F 11 54 24 40 F2 0F 10 44 24 38 F2 0F 10 64 24 40 F2 44 0F 58 3D ?? ?? ?? ?? F2 44 0F 59 FD F2 44 0F 58 3D ?? ?? ?? ?? F2 44 0F 59 FD F2 44 0F 58 3D ?? ?? ?? ?? F2 44 0F 59 FD F2 44 0F 58 3D ?? ?? ?? ?? F2 44 0F 59 FD F2 41 0F 59 DF F2 0F 58 DF F2 43 0F 58 5C D3 08 F2 0F 58 DC F2 0F 58 C3 F2 0F 11 44 24 28 8A 4C 24 2F 80 E1 7F 0A C8 88 4C 24 2F F2 0F 5A 5C 24 28 F3 0F 11 1A E9 47 01 00 00 F2 0F 10 05 ?? ?? ?? ?? C0 E0 07 F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 44 24 28 8A 4C 24 2F 80 E1 7F 0A C8 88 4C 24 2F F2 0F 5A 4C 24 28 F3 0F 11 0A E9 12 01 00 00 66 0F 2F 05 ?? ?? ?? ?? 0F 82 85 00 00 00 0F 28 C8 F2 0F 59 C8 C0 E0 07 F2 0F 10 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 59 D0 F2 0F 58 D0 F2 0F 11 54 24 28 8A 4C 24 2F 80 E1 7F 0A C8 88 4C 24 2F F2 0F 5A 44 24 28 F3 0F 11 02 EB 7F 45 85 C9 74 40 F2 0F 10 0D ?? ?? ?? ?? C0 E0 07 F2 0F 58 C8 F2 0F 11 4C 24 38 F2 0F 10 44 24 38 F2 0F 59 44 24 70 F2 0F 11 44 24 28 8A 4C 24 2F 80 E1 7F 0A C8 88 4C 24 2F F2 0F 5A 54 24 28 F3 0F 11 12 EB 3A F3 0F 59 C9 C0 E0 07 F3 0F 11 4C 24 20 F3 0F 10 44 24 20 F3 0F 5A C0 F2 0F 58 44 24 70 F2 0F 11 44 24 28 8A 4C 24 2F 80 E1 7F 0A C8 88 4C 24 2F F2 0F 5A 4C 24 28 F3 0F 11 0A 0F 28 7C 24 60 33 C0 44 0F 28 7C 24 50 48 83 C4 78 C3 F7 01 FF FF 7F 00 75 38 F2 0F 10 05 ?? ?? ?? ?? 8A 41 03 24 80 F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 44 24 28 44 8A 44 24 2F 41 80 E0 7F 44 0A C0 44 88 44 24 2F F2 0F 5A 4C 24 28 F3 0F 11 0A EB AE F3 0F 10 01 F3 0F 58 C0 F3 0F 11 02 EB A0 0F 1F 44 00 00 }
	condition:
		$1
}

rule file_18_0_0 {
	meta:
		name = "??$__crt_fast_decode_pointer@PEAP6AXXZ@@YAPEAP6AXXZQEAP6AXXZ@Z"
		size = 59
		refs = "000e __security_cookie 0032 ?__crt_rotate_pointer_value@@YA_K_KH@Z"
		altNames = "??$__crt_fast_decode_pointer@P6AHPEAU_RTL_CONDITION_VARIABLE@@PEAU_RTL_CRITICAL_SECTION@@K@Z@@YAP6AHPEAU_RTL_CONDITION_VARIABLE@@PEAU_RTL_CRITICAL_SECTION@@K@ZQ6AH01K@Z@Z ??$__crt_fast_decode_pointer@P6AXPEAU_RTL_CONDITION_VARIABLE@@@Z@@YAP6AXPEAU_RTL_CONDITION_VARIABLE@@@ZQ6AX0@Z@Z ??$__crt_fast_decode_pointer@P6AXXZ@@YAP6AXXZQ6AXXZ@Z ??$__crt_fast_decode_pointer@PEAX@@YAPEAXQEAX@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 33 D2 48 8B 05 ?? ?? ?? ?? B9 40 00 00 00 48 F7 F1 48 8B C2 48 8B 0D ?? ?? ?? ?? 48 8B 54 24 30 48 33 D1 48 8B CA 8B D0 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_18_1_0 {
	meta:
		name = "??$__crt_fast_encode_pointer@PEAP6AXXZ@@YAPEAP6AXXZQEAP6AXXZ@Z"
		size = 64
		refs = "000e __security_cookie 0030 ?__crt_rotate_pointer_value@@YA_K_KH@Z"
		altNames = "??$__crt_fast_encode_pointer@P6AHPEAU_RTL_CONDITION_VARIABLE@@PEAU_RTL_CRITICAL_SECTION@@K@Z@@YAP6AHPEAU_RTL_CONDITION_VARIABLE@@PEAU_RTL_CRITICAL_SECTION@@K@ZQ6AH01K@Z@Z ??$__crt_fast_encode_pointer@P6AXPEAU_RTL_CONDITION_VARIABLE@@@Z@@YAP6AXPEAU_RTL_CONDITION_VARIABLE@@@ZQ6AX0@Z@Z ??$__crt_fast_encode_pointer@P6AXXZ@@YAP6AXXZQ6AXXZ@Z ??$__crt_fast_encode_pointer@PEAX@@YAPEAXQEAX@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 33 D2 48 8B 05 ?? ?? ?? ?? B9 40 00 00 00 48 F7 F1 48 8B C2 B9 40 00 00 00 48 2B C8 48 8B C1 8B D0 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 33 05 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_18_2_0 {
	meta:
		name = "?__crt_rotate_pointer_value@@YA_K_KH@Z"
		size = 25
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 8B 44 24 10 0F B6 C8 48 8B 44 24 08 48 D3 C8 C3 }
	condition:
		$1
}

rule file_18_3_0 {
	meta:
		name = "?configure_argv@__scrt_narrow_argv_policy@@SAHXZ"
		size = 21
		refs = "0005 _get_startup_argv_mode 000c _configure_narrow_argv"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_133_6_0 {
	meta:
		name = "?configure_argv@__scrt_wide_argv_policy@@SAHXZ"
		size = 21
		refs = "0005 _get_startup_argv_mode 000c _configure_wide_argv"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_18_4_0 {
	meta:
		name = "?find_pe_section@@YAPEAU_IMAGE_SECTION_HEADER@@QEAE_K@Z"
		size = 198
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 48 89 44 24 10 48 8B 44 24 10 48 63 40 3C 48 8B 4C 24 10 48 03 C8 48 8B C1 48 89 44 24 20 48 8B 44 24 20 48 89 44 24 08 48 8B 44 24 08 0F B7 40 14 48 8B 4C 24 08 48 8D 44 01 18 48 89 44 24 18 48 8B 44 24 08 0F B7 40 06 48 6B C0 28 48 8B 4C 24 18 48 03 C8 48 8B C1 48 89 44 24 28 48 8B 44 24 18 48 89 04 24 EB 0C 48 8B 04 24 48 83 C0 28 48 89 04 24 48 8B 44 24 28 48 39 04 24 74 2D 48 8B 04 24 8B 40 0C 48 39 44 24 48 72 1D 48 8B 04 24 8B 40 0C 48 8B 0C 24 03 41 08 8B C0 48 39 44 24 48 73 06 48 8B 04 24 EB 04 EB BC 33 C0 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_18_5_0 {
	meta:
		name = "?is_potentially_valid_image_base@@YA_NQEAX@Z"
		size = 138
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 83 7C 24 30 00 75 04 32 C0 EB 70 48 8B 44 24 30 48 89 04 24 48 8B 04 24 0F B7 00 3D 4D 5A 00 00 74 04 32 C0 EB 55 48 8B 04 24 48 63 40 3C 48 8B 0C 24 48 03 C8 48 8B C1 48 89 44 24 10 48 8B 44 24 10 48 89 44 24 08 48 8B 44 24 08 81 38 50 45 00 00 74 04 32 C0 EB 23 48 8B 44 24 08 48 83 C0 18 48 89 44 24 18 48 8B 44 24 18 0F B7 00 3D 0B 02 00 00 74 04 32 C0 EB 02 B0 01 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_18_7_0 {
	meta:
		name = "__scrt_acquire_startup_lock"
		size = 98
		refs = "0005 __scrt_is_ucrt_dll_in_use 0012 NtCurrentTeb 002c __scrt_native_startup_lock"
	strings:
		$1 = { 48 83 EC 48 E8 ?? ?? ?? ?? 85 C0 75 04 32 C0 EB 4C E8 ?? ?? ?? ?? 48 8B 40 08 48 89 44 24 28 48 8B 44 24 28 48 89 44 24 30 48 8D 0D ?? ?? ?? ?? 33 C0 48 8B 54 24 30 F0 48 0F B1 11 48 89 44 24 20 48 83 7C 24 20 00 74 12 48 8B 44 24 20 48 39 44 24 28 75 04 B0 01 EB 04 EB C4 32 C0 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_18_8_0 {
	meta:
		name = "__scrt_dllmain_after_initialize_c"
		size = 45
		refs = "0005 __scrt_is_ucrt_dll_in_use 000e __isa_available_init 0015 ?configure_argv@__scrt_narrow_argv_policy@@SAHXZ 0022 _initialize_narrow_environment"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 85 C0 74 07 E8 ?? ?? ?? ?? EB 12 E8 ?? ?? ?? ?? 85 C0 74 04 32 C0 EB 07 E8 ?? ?? ?? ?? B0 01 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_18_9_0 {
	meta:
		name = "__scrt_dllmain_before_initialize_c"
		size = 29
		refs = "0007 __scrt_initialize_onexit_tables"
	strings:
		$1 = { 48 83 EC 28 33 C9 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 04 32 C0 EB 02 B0 01 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_18_10_0 {
	meta:
		name = "__scrt_dllmain_crt_thread_attach"
		size = 48
		refs = "0005 __vcrt_thread_attach 0015 __acrt_thread_attach 0021 __vcrt_thread_detach"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 04 32 C0 EB 17 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 09 E8 ?? ?? ?? ?? 32 C0 EB 02 B0 01 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_18_11_0 {
	meta:
		name = "__scrt_dllmain_crt_thread_detach"
		size = 21
		refs = "0005 __acrt_thread_detach 000a __vcrt_thread_detach"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? B0 01 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_18_12_0 {
	meta:
		name = "__scrt_dllmain_exception_filter"
		size = 94
		refs = "0018 __scrt_is_ucrt_dll_in_use 0037 _guard_check_icall 0055 _seh_filter_dll"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 89 54 24 10 48 89 4C 24 08 48 83 EC 38 E8 ?? ?? ?? ?? 85 C0 75 2B 83 7C 24 48 01 75 24 48 8B 44 24 58 48 89 44 24 20 48 8B 4C 24 20 E8 ?? ?? ?? ?? 4C 8B 44 24 50 33 D2 48 8B 4C 24 40 FF 54 24 20 48 8B 54 24 68 8B 4C 24 60 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_18_13_0 {
	meta:
		name = "__scrt_dllmain_uninitialize_c"
		size = 46
		refs = "0005 __scrt_is_ucrt_dll_in_use 0010 ?module_local_atexit_table@@3U_onexit_table_t@@A 0015 _execute_onexit_table 001c _is_c_termination_complete 0025 _cexit"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 85 C0 74 0E 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 0E E8 ?? ?? ?? ?? 85 C0 75 05 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_18_14_0 {
	meta:
		name = "__scrt_dllmain_uninitialize_critical"
		size = 21
		refs = "0007 __acrt_uninitialize_critical 000c __vcrt_uninitialize_critical"
	strings:
		$1 = { 48 83 EC 28 33 C9 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_18_15_0 {
	meta:
		name = "__scrt_initialize_crt"
		size = 73
		refs = "0011 ?is_initialized_as_dll@@3_NA 0017 __isa_available_init 001c __vcrt_initialize 002c __acrt_initialize 003a __vcrt_uninitialize"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 83 7C 24 30 00 75 07 C6 05 ?? ?? ?? ?? 01 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 04 32 C0 EB 19 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 0B 33 C9 E8 ?? ?? ?? ?? 32 C0 EB 02 B0 01 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_18_16_0 {
	meta:
		name = "__scrt_initialize_onexit_tables"
		size = 253
		refs = "0024 __scrt_fastfail 0029 __scrt_is_ucrt_dll_in_use 003e ?module_local_atexit_table@@3U_onexit_table_t@@A 0043 _initialize_onexit_table 0055 ?module_local_at_quick_exit_table@@3U_onexit_table_t@@A 007d ??$__crt_fast_encode_pointer@PEAP6AXXZ@@YAPEAP6AXXZQEAP6AXXZ@Z"
	strings:
		$1 = { 89 4C 24 08 56 57 48 83 EC 68 83 BC 24 80 00 00 00 00 74 14 83 BC 24 80 00 00 00 01 74 0A B9 05 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 44 83 BC 24 80 00 00 00 00 75 3A 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 07 32 C0 E9 A4 00 00 00 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 07 32 C0 E9 8D 00 00 00 B0 01 E9 86 00 00 00 E9 81 00 00 00 48 C7 C1 FF FF FF FF E8 ?? ?? ?? ?? 48 89 44 24 20 48 8B 44 24 20 48 89 44 24 28 48 8B 44 24 20 48 89 44 24 30 48 8B 44 24 20 48 89 44 24 38 48 8D 05 ?? ?? ?? ?? 48 8D 4C 24 28 48 8B F8 48 8B F1 B9 18 00 00 00 F3 A4 48 8B 44 24 20 48 89 44 24 40 48 8B 44 24 20 48 89 44 24 48 48 8B 44 24 20 48 89 44 24 50 48 8D 05 ?? ?? ?? ?? 48 8D 4C 24 40 48 8B F8 48 8B F1 B9 18 00 00 00 F3 A4 B0 01 48 83 C4 68 5F 5E C3 }
	condition:
		$1
}

rule file_18_17_0 {
	meta:
		name = "__scrt_is_nonwritable_in_current_image"
		size = 139
		refs = "0016 __ImageBase 0025 ?is_potentially_valid_image_base@@YA_NQEAX@Z 0054 ?find_pe_section@@YAPEAU_IMAGE_SECTION_HEADER@@QEAE_K@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 58 48 8B 44 24 60 48 89 44 24 38 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8B 4C 24 28 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 04 32 C0 EB 52 48 8B 44 24 28 48 8B 4C 24 38 48 2B C8 48 8B C1 48 89 44 24 40 48 8B 54 24 40 48 8B 4C 24 28 E8 ?? ?? ?? ?? 48 89 44 24 30 48 83 7C 24 30 00 75 04 32 C0 EB 1D 48 8B 44 24 30 8B 40 24 25 00 00 00 80 85 C0 74 04 32 C0 EB 08 B0 01 EB 04 32 C0 EB 00 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_18_18_0 {
	meta:
		name = "__scrt_is_nonwritable_in_current_image$filt$0"
		size = 61
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 89 4D 48 48 8B 45 48 48 8B 00 8B 00 89 45 24 8B 45 24 3D 05 00 00 C0 75 09 C7 45 20 01 00 00 00 EB 07 C7 45 20 00 00 00 00 8B 45 20 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_18_19_0 {
	meta:
		name = "__scrt_release_startup_lock"
		size = 47
		refs = "0009 __scrt_is_ucrt_dll_in_use 0023 __scrt_native_startup_lock"
	strings:
		$1 = { 88 4C 24 08 48 83 EC 28 E8 ?? ?? ?? ?? 85 C0 75 02 EB 17 0F B6 44 24 30 85 C0 74 02 EB 0C 33 C0 48 8D 0D ?? ?? ?? ?? 48 87 01 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_18_20_0 {
	meta:
		name = "__scrt_uninitialize_crt"
		size = 63
		refs = "000f ?is_initialized_as_dll@@3_NA 002a __acrt_uninitialize 0034 __vcrt_uninitialize"
	strings:
		$1 = { 88 54 24 10 88 4C 24 08 48 83 EC 28 0F B6 05 ?? ?? ?? ?? 85 C0 74 0D 0F B6 44 24 38 85 C0 74 04 B0 01 EB 16 0F B6 4C 24 30 E8 ?? ?? ?? ?? 0F B6 4C 24 30 E8 ?? ?? ?? ?? B0 01 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_18_21_0 {
	meta:
		name = "_onexit"
		size = 130
		refs = "000c ?module_local_atexit_table@@3U_onexit_table_t@@A 0011 ??$__crt_fast_decode_pointer@PEAP6AXXZ@@YAPEAP6AXXZQEAP6AXXZ@Z 0028 _crt_atexit 005b _register_onexit_function"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 48 48 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 44 24 30 48 83 7C 24 30 FF 75 2C 48 8B 4C 24 50 E8 ?? ?? ?? ?? 85 C0 75 0C 48 8B 44 24 50 48 89 44 24 20 EB 09 48 C7 44 24 20 00 00 00 00 48 8B 44 24 20 EB 31 EB 2F 48 8B 54 24 50 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 0C 48 8B 44 24 50 48 89 44 24 28 EB 09 48 C7 44 24 28 00 00 00 00 48 8B 44 24 28 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_18_22_0 {
	meta:
		name = "at_quick_exit"
		size = 80
		refs = "000c ?module_local_at_quick_exit_table@@3U_onexit_table_t@@A 0011 ??$__crt_fast_decode_pointer@PEAP6AXXZ@@YAPEAP6AXXZQEAP6AXXZ@Z 0028 _crt_at_quick_exit 0047 _register_onexit_function"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 44 24 20 48 83 7C 24 20 FF 75 0E 48 8B 4C 24 40 E8 ?? ?? ?? ?? EB 1D EB 1B 48 8B 44 24 40 48 89 44 24 28 48 8B 54 24 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_18_23_0 {
	meta:
		name = "atexit"
		size = 51
		refs = "000f _onexit"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 85 C0 74 0A C7 44 24 20 00 00 00 00 EB 08 C7 44 24 20 FF FF FF FF 8B 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_19_0_0 {
	meta:
		name = "??2@YAPEAX_K@Z"
		size = 80
		refs = "000f malloc 002d _callnewh 003e ?__scrt_throw_std_bad_array_new_length@@YAXXZ 0045 ?__scrt_throw_std_bad_alloc@@YAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 89 44 24 20 48 83 7C 24 20 00 74 07 48 8B 44 24 20 EB 24 48 8B 4C 24 40 E8 ?? ?? ?? ?? 85 C0 75 14 48 83 7C 24 40 FF 75 07 E8 ?? ?? ?? ?? EB 05 E8 ?? ?? ?? ?? EB BE 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_21_0_0 {
	meta:
		name = "__sse2_powf4"
		size = 1200
		refs = "0010 __common_spow_data 00dd _2il0floatpacket_128 04a1 __common_spow_cout_rare"
	strings:
		$1 = { 48 81 EC A8 01 00 00 0F 28 D0 0F 12 D0 48 8D 15 ?? ?? ?? ?? 44 0F 29 9C 24 90 01 00 00 0F 28 D9 0F 29 BC 24 70 01 00 00 0F 5A F8 44 0F 5A DA 0F 5A D1 44 0F 29 BC 24 00 01 00 00 44 0F 29 B4 24 10 01 00 00 44 0F 29 AC 24 20 01 00 00 44 0F 29 A4 24 30 01 00 00 44 0F 29 94 24 40 01 00 00 44 0F 29 8C 24 50 01 00 00 44 0F 29 84 24 60 01 00 00 0F 29 B4 24 80 01 00 00 4C 89 AC 24 A0 01 00 00 4C 8D 6C 24 6F 44 0F 28 2D ?? ?? ?? ?? 49 83 E5 C0 45 0F 28 FD 45 0F 54 EB 0F 28 25 ?? ?? ?? ?? 44 0F 54 FF 44 0F 56 FC 44 0F 56 EC 66 41 0F 5A EF 66 45 0F 5A CD 0F 16 ED 66 0F 73 D7 14 45 0F 16 C9 66 41 0F 73 D3 14 44 0F 53 C5 45 0F 53 D1 41 0F 5A E0 41 0F 5A EA 44 0F 28 25 ?? ?? ?? ?? 66 41 0F 58 E4 66 41 0F 58 EC 66 41 0F 5C E4 66 41 0F 5C EC 66 44 0F 59 FC 66 44 0F 59 ED 44 0F 28 CC 44 0F 28 D5 66 41 0F 73 D1 28 66 41 0F 73 D2 28 66 41 0F 70 F1 02 41 0F C6 FB DD 44 0F 28 1D ?? ?? ?? ?? 66 0F 7E F1 0F 28 35 ?? ?? ?? ?? 0F 12 D9 66 45 0F 5C FB 66 45 0F 5C EB F3 44 0F E6 E7 0F 5A DB 66 45 0F 7E D0 66 44 0F 7E C8 66 45 0F 70 DA 02 44 0F 28 D6 66 0F 70 FF EE 66 44 0F C2 D4 01 66 0F C2 F5 01 F3 0F E6 FF 66 45 0F 7E D9 44 0F 28 1D ?? ?? ?? ?? 0F 28 25 ?? ?? ?? ?? 45 0F 54 D3 41 0F 54 F3 44 0F 56 D4 0F 56 F4 45 0F 28 DF 66 45 0F 5C E2 66 0F 5C FE 66 45 0F 59 DF 0F 28 2D ?? ?? ?? ?? 41 0F 28 F5 66 44 0F 59 E5 66 0F 59 FD 66 41 0F 59 F5 0F 28 2D ?? ?? ?? ?? 0F 28 E5 66 41 0F 59 E7 66 41 0F 59 ED 44 0F 28 15 ?? ?? ?? ?? 66 41 0F 58 E2 66 41 0F 58 EA 66 41 0F 59 E3 66 0F 59 EE 66 44 0F 58 FC 66 44 0F 58 ED 48 63 C0 4D 63 C0 48 63 C9 4D 63 C9 F2 44 0F 10 84 10 80 A1 BF FF F2 45 0F 10 8C 10 80 A1 BF FF 66 44 0F 16 84 11 80 A1 BF FF 66 45 0F 16 8C 11 80 A1 BF FF 66 45 0F 58 F8 66 45 0F 58 E9 66 45 0F 58 FC 66 44 0F 58 EF 66 44 0F 59 FA 66 44 0F 59 EB 44 0F 28 0D ?? ?? ?? ?? 45 0F 28 D1 66 45 0F 59 D7 66 45 0F 59 CD 0F 28 15 ?? ?? ?? ?? 45 0F 28 C2 41 0F 28 F9 66 44 0F 5C C2 66 0F 5C FA 0F 28 1D ?? ?? ?? ?? 66 44 0F 58 C3 66 0F 58 FB 45 0F 28 E0 44 0F 28 DF 0F 29 44 24 20 66 0F FA 05 ?? ?? ?? ?? 66 44 0F 5C E3 66 44 0F 5C DB 66 45 0F 5C D4 66 45 0F 5C CB 66 44 0F 6F 35 ?? ?? ?? ?? 66 0F 6F D0 45 0F C6 FD DD 66 44 0F DB F1 66 44 0F 6F 2D ?? ?? ?? ?? 66 41 0F 66 D5 66 41 0F 76 C5 66 0F EB D0 66 45 0F 6F EE 66 0F 6F 05 ?? ?? ?? ?? 66 44 0F 66 E8 66 44 0F 76 F0 66 44 0F DB 3D ?? ?? ?? ?? 66 45 0F EB EE 66 44 0F 66 3D ?? ?? ?? ?? 66 41 0F EB D5 0F 28 05 ?? ?? ?? ?? 66 41 0F EB D7 45 0F 28 F8 66 41 0F 73 D0 0B 44 0F 54 F8 0F 54 C7 66 45 0F 7E FA 66 0F 73 D7 0B 66 0F 7E C1 66 41 0F 73 F0 34 44 0F 28 35 ?? ?? ?? ?? 66 0F 73 F7 34 66 45 0F C5 DF 04 66 44 0F C5 C0 04 66 45 0F 59 D6 66 45 0F 59 CE 0F 50 C2 41 C1 E2 03 C1 E1 03 41 C1 E3 03 41 C1 E0 03 85 C0 F3 41 0F 7E 94 12 00 36 00 00 F3 0F 7E 9C 11 00 36 00 00 66 41 0F 16 94 13 00 36 00 00 66 41 0F 16 9C 10 00 36 00 00 66 44 0F 59 D2 66 44 0F 59 CB 66 44 0F 58 D2 66 44 0F 58 CB 66 45 0F D4 D0 66 44 0F D4 CF 66 41 0F 5A C2 66 41 0F 5A E1 0F 16 C4 75 68 0F 28 B4 24 80 01 00 00 0F 28 BC 24 70 01 00 00 44 0F 28 84 24 60 01 00 00 44 0F 28 8C 24 50 01 00 00 44 0F 28 94 24 40 01 00 00 44 0F 28 9C 24 90 01 00 00 44 0F 28 A4 24 30 01 00 00 44 0F 28 AC 24 20 01 00 00 44 0F 28 B4 24 10 01 00 00 44 0F 28 BC 24 00 01 00 00 4C 8B AC 24 A0 01 00 00 48 81 C4 A8 01 00 00 C3 0F 28 54 24 20 41 0F 29 55 00 41 0F 29 4D 40 41 0F 29 85 80 00 00 00 0F 84 7B FF FF FF 33 D2 48 89 5C 24 28 8B DA 48 89 74 24 20 8B F0 8B CB 41 B8 01 00 00 00 41 D3 E0 41 85 F0 75 1E FF C3 83 FB 20 7C E9 48 8B 5C 24 28 48 8B 74 24 20 41 0F 28 85 80 00 00 00 E9 3D FF FF FF 49 8D 4C 9D 00 49 8D 54 9D 40 4D 8D 84 9D 80 00 00 00 E8 ?? ?? ?? ?? EB C9 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_22_0_0 {
	meta:
		name = "__common_sexp_cout_rare"
		size = 608
		refs = "002a _2il0floatpacket_46 003f _2il0floatpacket_47 004d _2il0floatpacket_49 0065 _2il0floatpacket_50 0095 _2il0floatpacket_51 00a7 _2il0floatpacket_52 00af _2il0floatpacket_54 00bf _2il0floatpacket_53 00cb _2il0floatpacket_55 00db _2il0floatpacket_56 00e2 _2il0floatpacket_58 00ee _2il0floatpacket_57 017f _2il0floatpacket_61 01d5 _2il0floatpacket_60 01ee _2il0floatpacket_59 0210 _2il0floatpacket_48"
	strings:
		$1 = { 48 83 EC 38 33 C0 44 0F B7 41 02 41 81 E0 80 7F 00 00 41 81 F8 80 7F 00 00 0F 84 0F 02 00 00 F3 0F 10 01 45 33 C0 F3 0F 10 0D ?? ?? ?? ?? 44 89 44 24 2C 0F 2F C8 0F 82 D0 01 00 00 0F 2F 05 ?? ?? ?? ?? 0F 82 A1 01 00 00 F3 0F 10 0D ?? ?? ?? ?? F3 0F 59 C8 F3 0F 11 4C 24 20 F3 0F 10 54 24 20 F3 0F 10 1D ?? ?? ?? ?? F3 0F 58 D3 F3 0F 11 54 24 24 0F 28 D0 F3 0F 10 64 24 24 44 8B 44 24 24 F3 0F 5C E3 F3 0F 11 64 24 20 F3 0F 10 6C 24 20 F3 0F 59 2D ?? ?? ?? ?? F3 0F 10 4C 24 20 F3 0F 5C D5 F3 0F 59 0D ?? ?? ?? ?? F3 0F 10 25 ?? ?? ?? ?? F3 0F 5C D1 F3 0F 59 E2 F3 0F 10 1D ?? ?? ?? ?? 41 C1 E0 10 F3 0F 58 25 ?? ?? ?? ?? F3 0F 59 E2 41 C1 F8 10 F3 0F 58 25 ?? ?? ?? ?? 0F 2F 05 ?? ?? ?? ?? F3 0F 59 E2 F3 0F 58 25 ?? ?? ?? ?? F3 0F 59 E2 F3 0F 58 E3 F3 0F 59 E2 F3 0F 58 E3 F3 0F 11 64 24 28 0F 82 88 00 00 00 41 8D 48 7F 81 F9 FE 00 00 00 77 2A 0F B6 C9 C1 E1 07 66 89 4C 24 2E F3 0F 10 44 24 28 F3 0F 59 44 24 2C F3 0F 11 44 24 28 44 8B 44 24 28 44 89 02 48 83 C4 38 C3 41 83 C0 7E 45 0F B6 C0 0F B7 4C 24 2E 41 C1 E0 07 81 E1 7F 80 FF FF 41 0B C8 F3 0F 10 44 24 28 66 89 4C 24 2E F3 0F 59 44 24 2C F3 0F 11 44 24 28 F3 0F 10 4C 24 28 F3 0F 59 0D ?? ?? ?? ?? F3 0F 11 4C 24 28 44 8B 4C 24 28 44 89 0A 48 83 C4 38 C3 41 83 C0 BB 45 0F B6 C0 0F B7 44 24 2E 41 C1 E0 07 25 7F 80 FF FF 41 0B C0 F3 0F 10 44 24 28 66 89 44 24 2E B8 04 00 00 00 F3 0F 59 44 24 2C F3 0F 11 44 24 28 F3 0F 10 4C 24 28 F3 0F 59 0D ?? ?? ?? ?? F3 0F 11 4C 24 28 8B 4C 24 28 89 0A 48 83 C4 38 C3 F3 0F 10 05 ?? ?? ?? ?? F3 0F 59 C0 F3 0F 11 44 24 28 8B 44 24 28 89 02 B8 04 00 00 00 48 83 C4 38 C3 F3 0F 10 05 ?? ?? ?? ?? F3 0F 59 C0 F3 0F 11 44 24 28 8B 44 24 28 89 02 B8 03 00 00 00 48 83 C4 38 C3 44 8A 41 03 41 80 E0 80 41 80 F8 80 74 11 F3 0F 10 01 F3 0F 59 C0 F3 0F 11 02 48 83 C4 38 C3 F7 01 FF FF 7F 00 75 E7 33 C9 89 0A 48 83 C4 38 C3 66 90 }
	condition:
		$1
}

rule file_23_0_0 {
	meta:
		name = "__vdecl_floor2"
		size = 18
		refs = "0002 __isa_available 0009 __sse4_floor2 000e __sse2_floor2"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 02 0F 8D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_333_0_0 {
	meta:
		name = "__vdecl_ceil2"
		size = 18
		refs = "0002 __isa_available 0009 __sse4_ceil2 000e __sse2_ceil2"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 02 0F 8D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_150_0_0 {
	meta:
		name = "__vdecl_ceilf4"
		size = 18
		refs = "0002 __isa_available 0009 __sse4_ceilf4 000e __sse2_ceilf4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 02 0F 8D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_288_0_0 {
	meta:
		name = "__vdecl_exp2"
		size = 18
		refs = "0002 __isa_available 0009 __sse4_exp2 000e __sse2_exp2"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 02 0F 8D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_163_0_0 {
	meta:
		name = "__vdecl_expf4"
		size = 18
		refs = "0002 __isa_available 0009 __sse4_expf4 000e __sse2_expf4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 02 0F 8D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_253_0_0 {
	meta:
		name = "__vdecl_floorf4"
		size = 18
		refs = "0002 __isa_available 0009 __sse4_floorf4 000e __sse2_floorf4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 02 0F 8D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_24_0_0 {
	meta:
		name = "__static_scalar_sin"
		size = 1264
		refs = "000c __spec_table"
	strings:
		$1 = { 53 56 57 41 54 48 83 EC 58 48 8D 05 ?? ?? ?? ?? F2 0F 11 84 24 80 00 00 00 48 89 44 24 40 0F 29 74 24 30 0F 29 7C 24 20 F2 0F 10 84 24 80 00 00 00 4C 8B 64 24 40 66 0F C5 C0 03 25 F0 7F 00 00 3D F0 7F 00 00 0F 84 81 04 00 00 8B C8 81 E9 60 3F 00 00 C1 E9 07 81 E1 FC FF 00 00 4D 8D 9C 24 E0 00 00 00 49 03 CB 66 48 0F 7E C0 44 8B 51 14 44 8B 41 18 8B D0 48 C1 E8 15 0D 00 00 00 80 C1 E8 0B 45 8B CA 4C 0F AF D2 4C 0F AF C8 4C 0F AF C0 8B 71 10 8B 79 0C 45 8B DA 49 C1 EA 20 4D 03 CA 4D 03 D8 45 8B C3 49 C1 EB 20 4D 03 CB 44 8B D6 48 0F AF F2 4C 0F AF D0 44 8B DF 48 0F AF FA 8B DE 48 C1 EE 20 4C 03 CB 41 8B D9 49 C1 E9 20 4C 03 D6 4D 03 D1 48 C1 E3 20 4C 0B C3 4C 0F AF D8 44 8B 49 08 8B 71 04 8B DF 48 C1 EF 20 4C 03 D3 41 8B DA 49 C1 EA 20 4C 03 DF 4D 03 DA 49 8B F9 4C 0F AF CA 48 0F AF F8 45 8B D1 49 C1 E9 20 4D 03 DA 45 8B D3 49 C1 EB 20 49 03 F9 49 03 FB 4C 8B CE 48 0F AF F2 4C 0F AF C8 49 C1 E2 20 4C 0B D3 8B 01 44 8B DE 48 C1 EE 20 49 03 FB 44 8B DF 48 C1 EF 20 4C 03 CE 4C 03 CF 48 0F AF D0 66 0F C5 D8 03 49 8D BC 24 E0 00 00 00 48 2B CF 03 C9 03 C9 03 C9 83 C1 13 BE 00 80 00 00 23 F3 C1 EB 04 81 E3 FF 07 00 00 81 EB FF 03 00 00 2B CB 4C 03 CA 8B D1 83 C2 20 83 F9 01 0F 8C 89 02 00 00 F7 D9 83 C1 1D 41 D3 E1 41 8B F9 41 81 E1 FF FF FF 1F 41 F7 C1 00 00 00 10 0F 85 93 02 00 00 41 D3 E9 BB 00 00 00 00 49 C1 E1 20 4D 0B CB 49 83 F9 00 0F 84 F4 01 00 00 4D 0F BD D9 B9 1D 00 00 00 41 2B CB 0F 8E 1C 02 00 00 49 D3 E1 49 8B C2 49 D3 E2 03 D1 F7 D9 83 C1 40 48 D3 E8 49 D3 E8 4C 0B C8 4D 0B D0 F2 49 0F 2A C1 49 D1 EA F2 49 0F 2A DA 66 0F 57 E4 C1 E2 04 F7 DA 81 C2 F0 3F 00 00 0B D6 33 D3 66 0F C4 E2 03 F3 41 0F 7E 94 24 D0 00 00 00 F3 41 0F 7E B4 24 D8 00 00 00 66 0F 57 ED 81 EA F0 03 00 00 66 0F C4 EA 03 F2 0F 59 C4 C1 E6 10 C1 FE 1F F2 0F 59 DD F3 0F 7E C8 F2 0F 59 C2 C1 EF 1D F2 0F 58 CB F2 0F 59 DA 03 FE 33 FE F2 0F 59 F1 8B C7 F2 0F 58 F3 F3 0F 7E D0 F2 0F 58 C6 F2 0F 5C D0 F2 0F 58 F2 F3 41 0F 7E 4C 24 70 F2 0F 59 C8 F3 41 0F 7E 94 24 80 00 00 00 F2 0F 2D D1 F2 0F 58 CA F3 41 0F 7E 5C 24 50 F2 0F 5C CA 66 41 0F 28 54 24 40 F2 0F 59 D9 66 0F 14 C9 C1 E0 03 81 C2 00 76 1C 00 F3 0F 7E E0 03 D0 83 E2 3F 66 41 0F 28 6C 24 30 49 8D 84 24 90 01 00 00 C1 E2 05 48 03 C2 66 0F 59 D1 F2 0F 5C C3 F2 41 0F 59 4C 24 60 F2 0F 5C E3 F3 0F 7E 78 08 66 0F 14 C0 F3 0F 7E DC F2 0F 5C E2 66 0F 59 E8 66 0F 5C C2 F2 0F 59 FC F2 0F 5C DC 66 0F 59 E8 66 0F 59 C0 F2 0F 5C DA 66 0F 28 10 F2 0F 5C CB F3 0F 7E 58 18 F2 0F 58 D3 F2 0F 5C FA F2 0F 5C CE 66 41 0F 28 74 24 10 F2 0F 59 D4 66 0F 59 F0 F2 0F 59 DC 66 0F 59 D0 66 0F 59 C0 66 41 0F 58 6C 24 20 F2 0F 59 20 66 41 0F 58 34 24 66 0F 59 E8 F3 0F 7E C3 F2 0F 58 58 08 66 0F 59 CF F3 0F 7E FC F2 0F 58 E3 66 0F 58 F5 F3 0F 7E 68 08 F2 0F 5C EB F2 0F 5C DC F2 0F 58 48 10 66 0F 59 F2 F2 0F 58 E8 F2 0F 58 DF F2 0F 58 CD F2 0F 58 CB F2 0F 58 CE 66 0F 15 F6 F3 0F 7E C4 F2 0F 58 CE F2 0F 58 C1 E9 13 01 00 00 83 C2 40 4D 8B CA 4D 8B D0 49 C7 C0 00 00 00 00 49 83 F9 00 0F 85 F2 FD FF FF 83 C2 40 4D 8B CA 4D 8B D0 49 83 F9 00 0F 85 DF FD FF FF 66 0F 57 C0 66 0F 57 F6 E9 87 FE FF FF 0F 84 FA FD FF FF F7 D9 49 D3 EA 49 8B C1 49 D3 E9 2B D1 F7 D9 83 C1 40 48 D3 E0 4C 0B D0 E9 DD FD FF FF F7 D9 49 C1 E1 20 4D 0B CB 49 D3 E1 49 8B F9 41 F7 C1 00 00 00 80 75 56 41 D3 E9 BB 00 00 00 00 48 C1 EF 03 E9 7C FD FF FF 41 D3 E9 BB 00 00 00 20 D3 EB 49 C1 E1 20 4D 0B CB 48 C1 E3 20 81 C7 00 00 00 20 48 C7 C1 00 00 00 00 49 C7 C3 00 00 00 00 49 2B C8 4D 1B DA 49 1B D9 4C 8B C1 4D 8B D3 4C 8B CB BB 00 80 00 00 E9 37 FD FF FF 41 D3 E9 48 BB 00 00 00 00 01 00 00 00 48 D3 EB 48 C7 C1 00 00 00 00 49 C7 C3 00 00 00 00 49 2B C8 4D 1B DA 49 1B D9 4C 8B C1 4D 8B D3 4C 8B CB BB 00 80 00 00 48 C1 EF 03 81 C7 00 00 00 20 E9 F3 FC FF FF F2 0F 5C C0 F2 0F 11 44 24 48 0F 28 74 24 30 0F 28 7C 24 20 F2 0F 10 44 24 48 48 83 C4 58 41 5C 5F 5E 5B C3 }
	condition:
		$1
}

rule file_24_1_0 {
	meta:
		name = "__sse2_sin2"
		size = 1216
		refs = "001f MMDPI1 002b MMDINVPI 0033 MMIABSMASK 003b MMDPI2 0043 MMDPI3 004b MMDRSHIFT 005f MMDHUGE 0073 MMDPI4 00a8 MMDA8 00b0 MMDA7 00cc MMDA6 00d4 MMDA5 00e4 MMDA4 00ec MMDA3 00fc MMDA2 0104 MMDA1 014f flAllOnes 015d MMISIGNMASK 0177 TWO_POW_30 01f8 THE_PI02_INV 020d MMI_ONE 0215 MSK_LOW_BIT 021d RS 0231 PI02C_0 023d PI02C_1 024d PI02C_2 027e PI02C_3 02aa PI02C_4"
	strings:
		$1 = { 48 81 EC D8 00 00 00 0F 29 BC 24 C0 00 00 00 0F 29 B4 24 B0 00 00 00 66 0F 28 F8 66 0F 28 25 ?? ?? ?? ?? 66 0F 28 D0 66 0F 59 05 ?? ?? ?? ?? 66 0F 54 3D ?? ?? ?? ?? 66 0F 28 2D ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 58 05 ?? ?? ?? ?? 66 0F 28 D8 66 0F 5C 05 ?? ?? ?? ?? 66 0F 66 3D ?? ?? ?? ?? 66 0F 50 C7 0B C0 0F 85 C9 00 00 00 66 0F 28 3D ?? ?? ?? ?? 66 0F 59 E0 66 0F 59 E8 66 0F 59 F0 66 0F 59 F8 66 0F 73 F3 3F 66 0F 5C D4 66 0F 5C D5 66 0F 5C D6 66 0F 28 CA 66 0F 59 D2 66 0F 5C CF 66 0F 28 05 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 E2 66 0F 59 E4 66 0F 59 D1 66 0F 59 C4 66 0F 59 F4 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 C4 66 0F 59 F4 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 C4 66 0F 59 F4 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 C4 66 0F 59 F2 66 0F 59 C1 66 0F 58 F1 66 0F 58 C6 66 0F 57 C3 0F 28 B4 24 B0 00 00 00 0F 28 BC 24 C0 00 00 00 48 81 C4 D8 00 00 00 C3 C7 44 24 20 00 00 00 00 66 0F 70 FF F5 66 0F 29 7C 24 30 66 0F 57 3D ?? ?? ?? ?? 66 0F 29 7C 24 40 66 0F 28 3D ?? ?? ?? ?? 66 0F 54 FA 66 0F 29 54 24 50 66 0F 54 15 ?? ?? ?? ?? 66 0F 28 0D ?? ?? ?? ?? 66 0F 66 CA 66 0F 50 D1 66 0F 29 7C 24 60 66 0F 29 54 24 70 83 F2 03 0F 85 E0 01 00 00 83 F8 03 74 57 66 0F 28 54 24 50 66 0F 28 3D ?? ?? ?? ?? 66 0F 59 E0 66 0F 59 E8 66 0F 59 F0 66 0F 59 F8 66 0F 73 F3 3F 66 0F 5C D4 66 0F 5C D5 66 0F 5C D6 66 0F 54 5C 24 40 66 0F 5C D7 66 0F 54 54 24 40 66 0F 29 9C 24 80 00 00 00 66 0F 29 94 24 90 00 00 00 66 0F 28 54 24 70 66 0F 28 1D ?? ?? ?? ?? 66 0F 59 DA 66 0F E6 DB 66 0F 70 DB 10 66 0F FE 1D ?? ?? ?? ?? 66 0F DB 1D ?? ?? ?? ?? 66 0F 28 05 ?? ?? ?? ?? 66 0F 56 C3 66 0F 5C 05 ?? ?? ?? ?? 66 0F 28 0D ?? ?? ?? ?? 66 0F 59 C8 66 0F 28 25 ?? ?? ?? ?? 66 0F 59 E0 66 0F 5C D1 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 E8 66 0F 28 CA 66 0F 5C D4 66 0F 5C CA 66 0F 28 F2 66 0F 5C CC 66 0F 5C D5 66 0F 73 F3 3E 66 0F 5C F2 66 0F 28 FA 66 0F 28 25 ?? ?? ?? ?? 66 0F 5C F5 66 0F 58 CE 66 0F 58 D1 66 0F 59 E0 66 0F 5C FA 66 0F 28 EA 66 0F 5C D4 66 0F 58 CF 66 0F 5C EA 66 0F 59 05 ?? ?? ?? ?? 66 0F 5C EC 66 0F 58 CD 66 0F 5C C8 66 0F DB 1D ?? ?? ?? ?? 66 0F 58 D1 66 0F 57 5C 24 60 83 F8 03 74 1E 66 0F 54 54 24 30 66 0F 56 94 24 90 00 00 00 66 0F 54 5C 24 30 66 0F 56 9C 24 80 00 00 00 66 0F 28 CA 66 0F 59 D2 66 0F 28 05 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 E2 66 0F 59 E4 66 0F 59 D1 66 0F 59 C4 66 0F 59 F4 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 C4 66 0F 59 F4 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 C4 66 0F 59 F4 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 C4 66 0F 59 F2 66 0F 59 C1 66 0F 58 F1 66 0F 58 C6 66 0F 57 C3 E9 EA 00 00 00 89 44 24 20 83 F8 03 0F 84 C0 00 00 00 66 0F 28 54 24 50 66 0F 28 3D ?? ?? ?? ?? 66 0F 59 E0 66 0F 59 E8 66 0F 59 F0 66 0F 59 F8 66 0F 73 F3 3F 66 0F 5C D4 66 0F 5C D5 66 0F 5C D6 66 0F 28 CA 66 0F 59 D2 66 0F 5C CF 66 0F 28 05 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 E2 66 0F 59 E4 66 0F 59 D1 66 0F 59 C4 66 0F 59 F4 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 C4 66 0F 59 F4 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 C4 66 0F 59 F4 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 C4 66 0F 59 F2 66 0F 59 C1 66 0F 58 F1 66 0F 58 C6 66 0F 57 C3 66 0F 29 84 24 A0 00 00 00 8B 44 24 20 A8 01 75 4B D1 F8 A8 01 75 27 D1 F8 89 44 24 20 66 0F 28 84 24 A0 00 00 00 0F 28 B4 24 B0 00 00 00 0F 28 BC 24 C0 00 00 00 48 81 C4 D8 00 00 00 C3 F2 0F 10 44 24 58 89 44 24 20 E8 87 F6 FF FF F2 0F 11 84 24 A8 00 00 00 8B 44 24 20 EB BB F2 0F 10 44 24 50 E8 6D F6 FF FF F2 0F 11 84 24 A0 00 00 00 8B 44 24 20 EB 9B 66 66 66 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_25_0_0 {
	meta:
		name = "__avx_atanf8"
		size = 208
		refs = "000e __common_satan_data"
	strings:
		$1 = { 48 83 EC 48 C5 7C 11 7C 24 20 C5 FC 10 2D ?? ?? ?? ?? C5 FC 10 15 ?? ?? ?? ?? C5 7C 54 3D ?? ?? ?? ?? C5 FC 54 CD C5 84 C2 C2 12 C4 C1 6C 5F DF C4 C1 6C 5D D7 C5 EC 5E D3 C5 FC 55 25 ?? ?? ?? ?? C5 FC 55 DD C5 DC 57 E1 C5 E4 57 C9 C5 F4 57 DA C5 E4 59 D3 C5 EC 59 CA C5 F4 59 2D ?? ?? ?? ?? C5 74 59 3D ?? ?? ?? ?? C5 D4 58 05 ?? ?? ?? ?? C5 84 58 2D ?? ?? ?? ?? C5 7C 59 F9 C5 D4 59 E9 C5 04 58 3D ?? ?? ?? ?? C5 D4 58 05 ?? ?? ?? ?? C5 84 59 E9 C5 FC 59 C9 C5 D4 58 2D ?? ?? ?? ?? C5 F4 58 0D ?? ?? ?? ?? C5 D4 59 EA C5 D4 58 C1 C5 FC 59 D2 C5 6C 58 3D ?? ?? ?? ?? C5 84 59 DB C5 7C 10 7C 24 20 C5 E4 58 C4 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_28_0_0 {
	meta:
		name = "??_N@YAXPEAX_K1P6AX0@Z2@Z"
		size = 166
		refs = "0051 _guard_check_icall 009d ?__ArrayUnwind@@YAXPEAX_K1P6AX0@Z@Z"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 48 C7 44 24 28 00 00 00 00 C6 44 24 20 00 EB 0D 48 8B 44 24 28 48 FF C0 48 89 44 24 28 48 8B 44 24 60 48 39 44 24 28 74 39 48 8B 44 24 68 48 89 44 24 30 48 8B 4C 24 30 E8 ?? ?? ?? ?? BA 01 00 00 00 48 8B 4C 24 50 FF 54 24 30 48 8B 44 24 58 48 8B 4C 24 50 48 03 C8 48 8B C1 48 89 44 24 50 EB AE C6 44 24 20 01 0F B6 44 24 20 85 C0 75 19 4C 8B 4C 24 70 4C 8B 44 24 28 48 8B 54 24 58 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_28_1_0 {
	meta:
		name = "?fin$0@?0???_N@YAXPEAX_K1P6AX0@Z2@Z@4HA"
		size = 46
		refs = "0022 ?__ArrayUnwind@@YAXPEAX_K1P6AX0@Z@Z"
		altNames = "?fin$0@?0???_L@YAXPEAX_K1P6AX0@Z2@Z@4HA"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 0F B6 45 20 85 C0 75 16 4C 8B 4D 70 4C 8B 45 28 48 8B 55 58 48 8B 4D 50 E8 ?? ?? ?? ?? 90 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_28_2_0 {
	meta:
		name = "??_N@YAXPEAX_KHP6AX0@Z2@Z"
		size = 67
		refs = "003a ??_N@YAXPEAX_K1P6AX0@Z2@Z"
	strings:
		$1 = { 4C 89 4C 24 20 44 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 63 44 24 50 48 8B 4C 24 60 48 89 4C 24 20 4C 8B 4C 24 58 4C 8B C0 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_87_2_0 {
	meta:
		name = "??_L@YAXPEAX_KHP6AX0@Z2@Z"
		size = 67
		refs = "003a ??_L@YAXPEAX_K1P6AX0@Z2@Z"
	strings:
		$1 = { 4C 89 4C 24 20 44 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 63 44 24 50 48 8B 4C 24 60 48 89 4C 24 20 4C 8B 4C 24 58 4C 8B C0 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_29_0_0 {
	meta:
		name = "__common_stan_cout_rare"
		size = 112
	strings:
		$1 = { 48 83 EC 28 33 C0 44 8B 01 44 0F B7 49 02 44 89 44 24 20 41 81 E1 80 7F 00 00 41 C1 E8 18 41 83 E0 7F F3 0F 10 09 41 81 F9 80 7F 00 00 44 88 44 24 23 74 05 48 83 C4 28 C3 81 7C 24 20 00 00 80 7F 75 16 B8 01 00 00 00 66 0F EF C0 F3 0F 59 C8 F3 0F 11 0A 48 83 C4 28 C3 F3 0F 59 C9 F3 0F 11 0A 48 83 C4 28 C3 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_32_0_0 {
	meta:
		name = "__sse2_asinf4"
		size = 432
		refs = "0036 __common_sasin_data 01a1 __common_sasin_cout_rare"
	strings:
		$1 = { 48 81 EC F8 00 00 00 44 0F 29 BC 24 E0 00 00 00 44 0F 29 A4 24 D0 00 00 00 44 0F 29 94 24 C0 00 00 00 44 0F 28 D0 4C 89 AC 24 F0 00 00 00 4C 8D 6C 24 6F 0F 28 2D ?? ?? ?? ?? 49 83 E5 C0 44 0F 28 FD 41 0F 55 EA 45 0F 54 FA 44 0F 28 25 ?? ?? ?? ?? 41 0F 28 D7 41 0F 59 D4 41 0F 28 DC 0F 28 0D ?? ?? ?? ?? 41 0F 28 E7 41 0F C2 CF 02 41 0F 59 E7 0F 5C DA 0F 50 D1 41 0F 28 D7 0F 28 05 ?? ?? ?? ?? 41 0F C2 D4 05 0F 5D E3 44 0F 52 E3 0F 59 C4 0F 58 DB 41 0F 28 CC 85 D2 41 0F 59 CC 0F 58 05 ?? ?? ?? ?? 44 0F 59 E3 0F 59 D9 0F 28 0D ?? ?? ?? ?? 0F 5C 1D ?? ?? ?? ?? 0F 59 CB 41 0F 59 DC 0F 58 0D ?? ?? ?? ?? 0F 59 CB 0F 28 DC 0F 59 DC 41 0F 5C CC 0F 59 C3 44 0F 28 25 ?? ?? ?? ?? 0F 54 CA 44 0F 59 E4 44 0F 58 25 ?? ?? ?? ?? 41 0F 58 C4 0F 59 C4 0F 58 05 ?? ?? ?? ?? 0F 59 C4 0F 28 E2 41 0F 55 E7 0F 56 E1 0F 59 C4 44 0F 28 3D ?? ?? ?? ?? 0F 58 C4 44 0F 54 FA 41 0F 58 C7 66 0F EF C5 75 2B 44 0F 28 94 24 C0 00 00 00 44 0F 28 A4 24 D0 00 00 00 44 0F 28 BC 24 E0 00 00 00 4C 8B AC 24 F0 00 00 00 48 81 C4 F8 00 00 00 C3 45 0F 29 55 00 41 0F 29 45 40 74 C9 33 C0 48 89 5C 24 28 8B D8 48 89 74 24 20 8B F2 8B CB 41 B8 01 00 00 00 41 D3 E0 41 85 F0 75 18 FF C3 83 FB 20 7C E9 48 8B 5C 24 28 48 8B 74 24 20 41 0F 28 45 40 EB 91 49 8D 4C 9D 00 49 8D 54 9D 40 E8 ?? ?? ?? ?? EB D7 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_33_0_0 {
	meta:
		name = "__avx_tanh4"
		size = 832
		refs = "000a __common_dtanh_data 0334 __common_dtanh_cout_rare"
	strings:
		$1 = { 48 81 EC 18 02 00 00 48 8D 15 ?? ?? ?? ?? C5 7C 11 BC 24 D0 00 00 00 C5 7C 11 B4 24 F0 01 00 00 C5 7C 11 AC 24 D0 01 00 00 C4 41 09 EF F6 C5 7C 11 A4 24 B0 01 00 00 C5 7C 11 9C 24 90 01 00 00 C5 7C 11 94 24 70 01 00 00 C5 7C 11 8C 24 50 01 00 00 C5 7C 11 84 24 30 01 00 00 C5 FC 11 BC 24 10 01 00 00 C5 FC 11 B4 24 F0 00 00 00 4C 89 AC 24 10 02 00 00 4C 8D 6C 24 6F 49 83 E5 C0 C4 C1 7D 11 45 20 C5 78 10 15 ?? ?? ?? ?? C5 F8 10 1D ?? ?? ?? ?? C5 FD 54 0D ?? ?? ?? ?? C5 7D 54 0D ?? ?? ?? ?? C4 E3 7D 19 C5 01 C5 F8 C6 E5 DD C5 59 DB 2D ?? ?? ?? ?? C5 91 FA 05 ?? ?? ?? ?? C4 41 61 66 C5 C4 41 79 66 FE C4 C1 79 66 E2 C4 C1 79 DB EF C4 43 51 4A D2 40 C5 91 66 15 ?? ?? ?? ?? C4 C1 61 72 D2 0A C4 41 69 EB E0 C5 F9 7E D9 C4 41 78 50 C4 C4 E3 79 16 D8 01 48 63 C9 48 63 C0 C4 C3 79 16 D9 02 C4 C3 79 16 DA 03 4D 63 C9 4D 63 D2 C5 F9 10 14 11 C5 79 10 1C 10 C5 79 10 64 10 10 C5 F9 10 44 10 20 C5 79 10 44 11 10 C5 79 10 7C 11 20 C5 F9 10 5C 11 30 C4 C3 6D 18 34 11 01 C4 43 25 18 14 12 01 C5 F9 10 54 10 30 C4 41 4D 15 D2 C5 F9 10 74 11 40 C4 43 3D 18 6C 11 10 01 C4 C3 05 18 6C 11 20 01 C4 43 65 18 5C 11 30 01 C4 43 1D 18 74 12 10 01 C4 C3 7D 18 64 12 20 01 C4 C3 6D 18 7C 12 30 01 C5 79 10 44 10 40 C4 41 15 14 E6 C4 41 15 15 EE C5 55 14 F4 C5 55 15 FC C5 A5 14 C7 C5 A5 15 EF C5 79 10 5C 11 50 C5 F9 10 7C 10 50 C4 C3 3D 18 54 12 40 01 C4 43 25 18 44 11 50 01 C4 C3 4D 18 5C 11 40 01 C5 E5 14 E2 C5 E5 15 DA C5 F9 10 74 11 60 C4 43 45 18 5C 12 50 01 C4 C1 3D 14 D3 C4 41 3D 15 DB C5 79 10 44 10 60 C4 C3 4D 18 74 11 60 01 C4 43 3D 18 44 12 60 01 C4 C1 4D 14 F8 C5 75 58 C7 C4 C1 25 59 C8 C5 F5 58 CA C4 C1 75 59 D0 C5 ED 58 DB C4 C1 65 59 F0 C5 CD 58 E4 C4 C1 5D 59 F8 C5 C5 58 ED C4 41 55 59 D8 C5 A5 58 C0 C4 C1 7D 59 C0 C4 41 7D 58 FF C4 C1 05 59 C0 C4 41 7D 58 F6 C4 C1 0D 59 C0 C4 41 7D 58 ED C4 C1 15 59 C0 C4 41 7D 58 E4 C4 41 1D 59 C0 C4 41 3D 58 D2 C4 C1 2D 56 C1 45 85 C0 75 6A C5 FC 10 B4 24 F0 00 00 00 C5 FC 10 BC 24 10 01 00 00 C5 7C 10 84 24 30 01 00 00 C5 7C 10 8C 24 50 01 00 00 C5 7C 10 94 24 70 01 00 00 C5 7C 10 9C 24 90 01 00 00 C5 7C 10 A4 24 B0 01 00 00 C5 7C 10 AC 24 D0 01 00 00 C5 7C 10 B4 24 F0 01 00 00 C5 7C 10 BC 24 D0 00 00 00 4C 8B AC 24 10 02 00 00 48 81 C4 18 02 00 00 C3 C4 C1 7D 10 4D 20 C4 C1 7D 11 45 40 C4 C1 7D 11 4D 00 74 82 33 C0 48 89 5C 24 28 8B D8 48 89 74 24 20 41 8B F0 0F A3 DE 72 1C FF C3 83 FB 20 7C F4 48 8B 5C 24 28 48 8B 74 24 20 C4 C1 7D 10 45 40 E9 50 FF FF FF C5 F8 77 49 8D 4C DD 00 49 8D 54 DD 40 E8 ?? ?? ?? ?? EB D0 66 0F 1F 44 00 00 }
	condition:
		$1
}

rule file_34_0_0 {
	meta:
		name = "__security_init_cookie"
		size = 274
		refs = "001a __security_cookie 002d __security_cookie_complement 003d __imp_GetSystemTimeAsFileTime 004d __imp_GetCurrentThreadId 0065 __imp_GetCurrentProcessId 0082 __imp_QueryPerformanceCounter"
	strings:
		$1 = { 48 83 EC 48 48 C7 44 24 28 00 00 00 00 48 B8 32 A2 DF 2D 99 2B 00 00 48 39 05 ?? ?? ?? ?? 74 16 48 8B 05 ?? ?? ?? ?? 48 F7 D0 48 89 05 ?? ?? ?? ?? E9 D7 00 00 00 48 8D 4C 24 28 FF 15 ?? ?? ?? ?? 48 8B 44 24 28 48 89 44 24 20 FF 15 ?? ?? ?? ?? 8B C0 48 8B 4C 24 20 48 33 C8 48 8B C1 48 89 44 24 20 FF 15 ?? ?? ?? ?? 8B C0 48 8B 4C 24 20 48 33 C8 48 8B C1 48 89 44 24 20 48 8D 4C 24 30 FF 15 ?? ?? ?? ?? 8B 44 24 30 48 C1 E0 20 48 33 44 24 30 48 8B 4C 24 20 48 33 C8 48 8B C1 48 89 44 24 20 48 8D 44 24 20 48 8B 4C 24 20 48 33 C8 48 8B C1 48 89 44 24 20 48 B8 FF FF FF FF FF FF 00 00 48 8B 4C 24 20 48 23 C8 48 8B C1 48 89 44 24 20 48 B8 32 A2 DF 2D 99 2B 00 00 48 39 44 24 20 75 0F 48 B8 33 A2 DF 2D 99 2B 00 00 48 89 44 24 20 48 8B 44 24 20 48 89 05 ?? ?? ?? ?? 48 8B 44 24 20 48 F7 D0 48 89 05 ?? ?? ?? ?? 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_35_0_0 {
	meta:
		name = "_RTC_Initialize"
		size = 77
		refs = "000d __rtc_iaa 0014 __rtc_izz 002e _guard_check_icall"
	strings:
		$1 = { 48 89 5C 24 10 56 48 83 EC 20 48 8D 1D ?? ?? ?? ?? 48 8D 35 ?? ?? ?? ?? 48 3B DE 73 25 48 89 7C 24 30 48 8B 3B 48 85 FF 74 0A 48 8B CF E8 ?? ?? ?? ?? FF D7 48 83 C3 08 48 3B DE 72 E5 48 8B 7C 24 30 48 8B 5C 24 38 48 83 C4 20 5E C3 }
	condition:
		$1
}

rule file_35_1_0 {
	meta:
		name = "_RTC_Terminate"
		size = 77
		refs = "000d __rtc_taa 0014 __rtc_tzz 002e _guard_check_icall"
	strings:
		$1 = { 48 89 5C 24 10 56 48 83 EC 20 48 8D 1D ?? ?? ?? ?? 48 8D 35 ?? ?? ?? ?? 48 3B DE 73 25 48 89 7C 24 30 48 8B 3B 48 85 FF 74 0A 48 8B CF E8 ?? ?? ?? ?? FF D7 48 83 C3 08 48 3B DE 72 E5 48 8B 7C 24 30 48 8B 5C 24 38 48 83 C4 20 5E C3 }
	condition:
		$1
}

rule file_42_0_0 {
	meta:
		name = "__sse4_ceilf4"
		size = 16
	strings:
		$1 = { 66 0F 3A 08 C0 02 C3 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_45_0_0 {
	meta:
		name = "__common_datan_cout_rare"
		size = 1568
		refs = "0051 _vmldAtanHATab"
	strings:
		$1 = { 48 83 EC 78 44 0F B7 41 06 41 81 E0 F0 7F 00 00 41 C1 E8 04 44 0F 29 5C 24 50 41 81 F8 FF 07 00 00 0F 29 74 24 60 0F 84 9B 05 00 00 4C 8B 09 4C 89 4C 24 48 49 C1 E9 38 8A 41 07 41 83 E1 7F 44 88 4C 24 4F F2 0F 10 44 24 48 C0 E8 07 66 0F 2F 05 ?? ?? ?? ?? 4C 8B 4C 24 48 0F 82 45 04 00 00 F2 0F 10 0D ?? ?? ?? ?? 66 0F 2F C8 0F 86 00 04 00 00 4C 89 4C 24 20 44 0F 28 D8 44 8B 4C 24 24 45 8B D1 41 81 E1 00 00 08 00 41 81 E2 00 00 F0 FF 41 81 C9 00 00 04 00 4C 8D 1D ?? ?? ?? ?? 45 0B D1 C7 44 24 20 00 00 00 00 44 89 54 24 24 F2 0F 10 0D ?? ?? ?? ?? 0F 28 E1 F2 44 0F 5C 5C 24 20 C0 E0 07 F2 41 0F 59 E3 8B 49 04 F2 0F 11 64 24 28 81 E1 FF FF 0F 00 F2 0F 10 54 24 28 41 C1 E0 14 F2 41 0F 5C D3 F2 0F 11 54 24 30 44 0B C1 F2 0F 10 5C 24 28 41 81 C0 00 00 40 C0 F2 0F 10 6C 24 30 41 C1 F8 12 F2 0F 5C DD F2 0F 11 5C 24 28 0F 28 E8 F2 0F 10 74 24 28 41 83 E0 FE F2 0F 59 2D ?? ?? ?? ?? F2 44 0F 5C DE F2 44 0F 11 5C 24 30 F2 0F 10 5C 24 28 F2 0F 10 64 24 30 F2 0F 11 6C 24 28 F2 0F 10 74 24 28 4D 63 C0 F2 0F 5C 74 24 48 F2 0F 11 74 24 30 F2 0F 10 6C 24 28 F2 0F 10 54 24 30 F2 0F 5C EA F2 0F 11 6C 24 28 F2 0F 10 74 24 28 F2 0F 5C C6 F2 0F 11 44 24 30 F2 44 0F 10 5C 24 28 F2 0F 10 44 24 20 F2 0F 10 54 24 30 F2 44 0F 59 D8 F2 0F 59 D0 41 0F 28 EB F2 0F 58 EA F2 0F 11 6C 24 28 F2 0F 10 74 24 28 F2 44 0F 5C DE F2 41 0F 58 D3 F2 0F 11 54 24 30 F2 0F 10 15 ?? ?? ?? ?? F2 0F 10 44 24 28 0F 28 F2 F2 0F 10 6C 24 30 F2 0F 58 F0 F2 0F 11 74 24 28 0F 28 F2 F2 44 0F 10 5C 24 28 F2 41 0F 5C F3 F2 0F 11 74 24 30 F2 0F 10 74 24 28 F2 44 0F 10 5C 24 30 F2 41 0F 58 F3 F2 0F 11 74 24 38 0F 28 F2 F2 44 0F 10 5C 24 30 F2 41 0F 58 C3 F2 0F 11 44 24 30 F2 0F 10 44 24 38 F2 0F 5C F0 F2 0F 11 74 24 38 F2 0F 10 74 24 30 F2 44 0F 10 5C 24 38 F2 41 0F 58 F3 F2 0F 11 74 24 38 F2 44 0F 10 5C 24 28 F2 0F 10 44 24 38 F2 0F 58 C5 41 0F 28 EB F2 0F 59 E9 F2 0F 11 6C 24 28 F2 0F 10 74 24 28 F2 41 0F 5C F3 F2 0F 11 74 24 30 F2 0F 10 74 24 28 F2 0F 10 6C 24 30 F2 0F 5C F5 F2 0F 11 74 24 28 F2 0F 10 6C 24 28 F2 44 0F 5C DD F2 44 0F 11 5C 24 30 F2 0F 10 74 24 28 F2 0F 10 6C 24 30 F2 0F 58 E8 0F 28 C2 F2 0F 5E C6 F2 0F 59 C8 F2 0F 11 4C 24 30 F2 0F 10 4C 24 30 F2 0F 5C C8 F2 0F 11 4C 24 38 F2 0F 10 44 24 30 F2 44 0F 10 5C 24 38 F2 41 0F 5C C3 F2 0F 11 44 24 38 F2 0F 10 4C 24 38 F2 0F 59 F1 F2 0F 5C D6 F2 0F 10 74 24 38 F2 0F 59 EE F2 0F 11 6C 24 30 F2 0F 10 6C 24 30 F2 0F 5C D5 F2 0F 11 54 24 30 F2 44 0F 10 5C 24 30 F2 0F 10 74 24 38 F2 0F 10 54 24 30 F2 0F 10 6C 24 38 F2 44 0F 58 1D ?? ?? ?? ?? F2 44 0F 59 DA F2 44 0F 59 DD 0F 28 EE F2 0F 59 F4 F2 0F 59 EB F2 41 0F 59 DB 41 0F 28 C3 F2 0F 59 C4 F2 44 0F 10 1D ?? ?? ?? ?? F2 0F 58 C6 F2 43 0F 10 14 C3 F2 0F 58 C3 F2 0F 11 44 24 28 0F 28 DD F2 0F 10 74 24 28 0F 28 C2 F2 0F 58 DE F2 0F 11 5C 24 28 F2 0F 10 64 24 28 F2 0F 5C EC F2 0F 58 EE F2 0F 11 6C 24 30 F2 0F 10 5C 24 28 0F 28 EB F2 0F 58 C3 F2 0F 59 EB F2 44 0F 59 DD F2 0F 10 74 24 30 F2 0F 11 44 24 28 F2 0F 10 4C 24 28 F2 44 0F 58 1D ?? ?? ?? ?? F2 0F 5C D1 F2 44 0F 59 DD F2 0F 58 D3 F2 44 0F 58 1D ?? ?? ?? ?? F2 44 0F 59 DD F2 0F 11 54 24 30 F2 0F 10 44 24 28 F2 0F 10 64 24 30 F2 44 0F 58 1D ?? ?? ?? ?? F2 44 0F 59 DD F2 44 0F 58 1D ?? ?? ?? ?? F2 44 0F 59 DD F2 44 0F 58 1D ?? ?? ?? ?? F2 44 0F 59 DD F2 44 0F 58 1D ?? ?? ?? ?? F2 44 0F 59 DD F2 41 0F 59 DB F2 0F 58 DE F2 43 0F 58 5C C3 08 F2 0F 58 DC F2 0F 58 C3 F2 0F 11 44 24 40 8A 4C 24 47 80 E1 7F 0A C8 88 4C 24 47 48 8B 44 24 40 48 89 02 E9 43 01 00 00 F2 0F 10 05 ?? ?? ?? ?? C0 E0 07 F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 44 24 40 8A 4C 24 47 80 E1 7F 0A C8 88 4C 24 47 48 8B 44 24 40 48 89 02 E9 10 01 00 00 66 0F 2F 05 ?? ?? ?? ?? 0F 82 83 00 00 00 0F 28 C8 F2 0F 59 C8 C0 E0 07 F2 0F 10 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 59 D0 F2 0F 58 D0 F2 0F 11 54 24 40 8A 4C 24 47 80 E1 7F 0A C8 88 4C 24 47 48 8B 44 24 40 48 89 02 EB 7F 0F B7 4C 24 4E F7 C1 F0 7F 00 00 74 3E F2 0F 10 0D ?? ?? ?? ?? C0 E0 07 F2 0F 58 C8 F2 0F 11 4C 24 28 F2 0F 10 44 24 28 F2 0F 59 44 24 48 F2 0F 11 44 24 40 8A 4C 24 47 80 E1 7F 0A C8 88 4C 24 47 48 8B 44 24 40 48 89 02 EB 34 F2 0F 59 C0 C0 E0 07 F2 0F 11 44 24 28 F2 0F 10 44 24 28 F2 0F 58 44 24 48 F2 0F 11 44 24 40 8A 4C 24 47 80 E1 7F 0A C8 88 4C 24 47 48 8B 44 24 40 48 89 02 0F 28 74 24 60 33 C0 44 0F 28 5C 24 50 48 83 C4 78 C3 F7 41 04 FF FF 0F 00 75 37 83 39 00 75 32 F2 0F 10 05 ?? ?? ?? ?? 8A 49 07 80 E1 80 F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 44 24 40 8A 44 24 47 24 7F 0A C1 88 44 24 47 4C 8B 44 24 40 4C 89 02 EB AE F2 0F 10 01 F2 0F 58 C0 F2 0F 11 02 EB A0 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_47_0_0 {
	meta:
		name = "??_V@YAXPEAX_K@Z"
		size = 29
		refs = "0014 ??_V@YAXPEAX@Z"
		altNames = "??_V@YAXPEAXAEBUnothrow_t@std@@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_380_0_0 {
	meta:
		name = "??3@YAXPEAXAEBUnothrow_t@std@@@Z"
		size = 29
		refs = "0014 ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_225_0_0 {
	meta:
		name = "??3@YAXPEAX_K@Z"
		size = 29
		refs = "0014 ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_55_0_0 {
	meta:
		name = "__avx_tanhf8"
		size = 768
		refs = "000f __common_stanh_data 02ec __common_stanh_cout_rare"
	strings:
		$1 = { 57 41 56 41 57 48 81 EC 10 02 00 00 4C 8D 1D ?? ?? ?? ?? C5 7C 11 BC 24 E0 01 00 00 C5 7C 11 B4 24 40 01 00 00 C5 7C 11 A4 24 C0 01 00 00 C5 7C 11 9C 24 A0 01 00 00 C5 7C 11 94 24 80 01 00 00 C5 7C 11 8C 24 60 01 00 00 4C 89 AC 24 00 02 00 00 4C 8D AC 24 DF 00 00 00 C5 7C 54 0D ?? ?? ?? ?? 49 83 E5 C0 C5 7C 54 15 ?? ?? ?? ?? C5 F8 10 25 ?? ?? ?? ?? C5 F8 10 0D ?? ?? ?? ?? C5 78 10 25 ?? ?? ?? ?? C5 78 10 3D ?? ?? ?? ?? C5 79 DB DC C4 E3 7D 19 C5 01 C5 A1 66 D1 C5 D1 DB EC C5 D1 66 D9 C5 D9 EF E4 C5 E9 6B CB C4 C1 21 FA D4 C5 71 63 F4 C4 C1 69 66 DF C4 C1 79 D7 FE C4 41 51 FA F4 C5 69 66 E4 C5 89 66 E4 C4 C1 69 DB EC C5 09 DB DC C4 C1 09 66 CF C4 43 51 4A E7 30 C4 43 21 4A FF 10 C4 C1 09 72 D4 0E C4 C1 19 72 D7 0E C4 41 79 7E F7 C5 79 7E E1 C4 43 79 16 F2 01 C4 63 79 16 E2 01 4D 63 FF 4D 63 D2 C4 43 79 16 F1 02 C4 43 79 16 F0 03 48 63 C9 C4 63 79 16 E0 02 48 63 D2 C4 43 79 16 E6 03 4D 63 C9 4D 63 C0 48 63 C0 4D 63 F6 C4 01 79 10 3C 1F C4 81 79 10 2C 1A C4 A1 79 10 1C 19 C4 21 79 10 1C 1A C4 83 05 18 24 19 01 C4 83 55 18 14 18 01 C5 5D 14 F2 C5 DD 15 E2 C4 81 79 10 54 1F 10 C4 A3 65 18 0C 18 01 C4 81 79 10 5C 1A 10 C4 03 25 18 3C 1E 01 C4 41 75 14 E7 C4 C1 75 15 EF C4 21 79 10 7C 19 10 C4 83 65 18 4C 18 10 01 C4 A1 79 10 5C 1A 10 C4 03 6D 18 5C 19 10 01 C5 A5 14 D1 C5 A5 15 C9 C4 23 05 18 7C 18 10 01 C4 03 65 18 5C 1E 10 01 C4 C1 05 14 DB C4 41 05 15 DB C4 41 7C 5A F9 C4 43 7D 19 C9 01 C4 C1 75 59 CF C4 41 7C 5A C9 C5 F5 58 D2 C4 C1 25 59 C9 C4 C1 6D 59 D7 C5 F5 58 DB C5 ED 58 CC C4 C1 65 59 E1 C5 DD 58 D5 C4 C1 75 59 EF C4 41 6D 59 D9 C4 41 55 58 F6 C4 41 25 58 FC C4 41 7D 5A E6 C4 C1 7D 5A CF C4 E3 1D 18 D1 01 C4 C1 6C 56 CA 40 84 FF 75 4F C5 7C 10 8C 24 60 01 00 00 C5 7C 10 94 24 80 01 00 00 C5 7C 10 9C 24 A0 01 00 00 C5 7C 10 A4 24 C0 01 00 00 C5 7C 10 B4 24 40 01 00 00 C5 7C 10 BC 24 E0 01 00 00 4C 8B AC 24 00 02 00 00 C5 FC 28 C1 48 81 C4 10 02 00 00 41 5F 41 5E 5F C3 C4 C1 7C 11 45 00 C4 C1 7C 11 4D 40 85 FF 74 A1 C5 FC 11 B4 24 80 00 00 00 45 33 F6 C5 FC 11 7C 24 60 C5 7C 11 44 24 40 C5 7C 11 6C 24 20 44 0F A3 F7 72 2F 41 FF C6 41 83 FE 20 7C F1 C5 FC 10 B4 24 80 00 00 00 C5 FC 10 7C 24 60 C5 7C 10 44 24 40 C5 7C 10 6C 24 20 C4 C1 7C 10 4D 40 E9 4E FF FF FF C5 F8 77 4B 8D 4C B5 00 4B 8D 54 B5 40 E8 ?? ?? ?? ?? EB BD 66 66 66 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_56_0_0 {
	meta:
		name = "??0bad_alloc@std@@AEAA@QEBD@Z"
		size = 60
		refs = "001f ??0exception@std@@QEAA@QEBDH@Z 002b ??_7bad_alloc@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 41 B8 01 00 00 00 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_56_1_0 {
	meta:
		name = "??0bad_alloc@std@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7bad_alloc@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_25_1_4 {
	meta:
		name = "??0__non_rtti_object@std@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0bad_typeid@std@@QEAA@AEBV01@@Z 0025 ??_7__non_rtti_object@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_56_3_0 {
	meta:
		name = "??0bad_array_new_length@std@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0bad_alloc@std@@QEAA@AEBV01@@Z 0025 ??_7bad_array_new_length@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_88_95_2 {
	meta:
		name = "??0bad_cast@std@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7bad_cast@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_60_45_3 {
	meta:
		name = "??0bad_exception@std@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7bad_exception@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_88_2_1 {
	meta:
		name = "??0bad_function_call@std@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7bad_function_call@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_25_5_4 {
	meta:
		name = "??0bad_typeid@std@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7bad_typeid@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_90_76_1 {
	meta:
		name = "??0codecvt_base@std@@QEAA@_K@Z"
		size = 54
		refs = "0019 ??0facet@locale@std@@IEAA@_K@Z 0025 ??_7codecvt_base@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_50_98_2 {
	meta:
		name = "??0ctype_base@std@@QEAA@_K@Z"
		size = 54
		refs = "0019 ??0facet@locale@std@@IEAA@_K@Z 0025 ??_7ctype_base@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_4_86_1 {
	meta:
		name = "??0failure@ios_base@std@@QEAA@AEBV012@@Z"
		size = 54
		refs = "0019 ??0system_error@std@@QEAA@AEBV01@@Z 0025 ??_7failure@ios_base@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_13_8_3 {
	meta:
		name = "??0invalid_argument@std@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0logic_error@std@@QEAA@AEBV01@@Z 0025 ??_7invalid_argument@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_8_9_2 {
	meta:
		name = "??0invalid_argument@std@@QEAA@PEBD@Z"
		size = 54
		refs = "0019 ??0logic_error@std@@QEAA@PEBD@Z 0025 ??_7invalid_argument@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_8_10_2 {
	meta:
		name = "??0length_error@std@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0logic_error@std@@QEAA@AEBV01@@Z 0025 ??_7length_error@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_8_11_2 {
	meta:
		name = "??0length_error@std@@QEAA@PEBD@Z"
		size = 54
		refs = "0019 ??0logic_error@std@@QEAA@PEBD@Z 0025 ??_7length_error@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_101_5_1 {
	meta:
		name = "??0logic_error@std@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7logic_error@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_34_6_3 {
	meta:
		name = "??0logic_error@std@@QEAA@PEBD@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@QEBD@Z 0025 ??_7logic_error@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_10_362_2 {
	meta:
		name = "??0messages_base@std@@QEAA@_K@Z"
		size = 54
		refs = "0019 ??0facet@locale@std@@IEAA@_K@Z 0025 ??_7messages_base@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_89_161_2 {
	meta:
		name = "??0money_base@std@@QEAA@_K@Z"
		size = 54
		refs = "0019 ??0facet@locale@std@@IEAA@_K@Z 0025 ??_7money_base@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_13_14_3 {
	meta:
		name = "??0out_of_range@std@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0logic_error@std@@QEAA@AEBV01@@Z 0025 ??_7out_of_range@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_13_15_3 {
	meta:
		name = "??0out_of_range@std@@QEAA@PEBD@Z"
		size = 54
		refs = "0019 ??0logic_error@std@@QEAA@PEBD@Z 0025 ??_7out_of_range@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_88_16_1 {
	meta:
		name = "??0overflow_error@std@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0runtime_error@std@@QEAA@AEBV01@@Z 0025 ??_7overflow_error@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_8_17_2 {
	meta:
		name = "??0overflow_error@std@@QEAA@PEBD@Z"
		size = 54
		refs = "0019 ??0runtime_error@std@@QEAA@PEBD@Z 0025 ??_7overflow_error@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_24_132_3 {
	meta:
		name = "??0runtime_error@std@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7runtime_error@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_88_114_2 {
	meta:
		name = "??0runtime_error@std@@QEAA@PEBD@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@QEBD@Z 0025 ??_7runtime_error@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_86_115_2 {
	meta:
		name = "??0system_error@std@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0_System_error@std@@QEAA@AEBV01@@Z 0025 ??_7system_error@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_119_307_1 {
	meta:
		name = "??0time_base@std@@QEAA@_K@Z"
		size = 54
		refs = "0019 ??0facet@locale@std@@IEAA@_K@Z 0025 ??_7time_base@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_56_2_0 {
	meta:
		name = "??0bad_alloc@std@@QEAA@XZ"
		size = 57
		refs = "0012 ??_C@_0P@GHFPNOJB@bad?5allocation?$AA@ 001c ??0exception@std@@QEAA@QEBDH@Z 0028 ??_7bad_alloc@std@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 41 B8 01 00 00 00 48 8D 15 ?? ?? ?? ?? 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_29_116_3 {
	meta:
		name = "??0bad_cast@std@@QEAA@XZ"
		size = 57
		refs = "0012 ??_C@_08EPJLHIJG@bad?5cast?$AA@ 001c ??0exception@std@@QEAA@QEBDH@Z 0028 ??_7bad_cast@std@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 41 B8 01 00 00 00 48 8D 15 ?? ?? ?? ?? 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_5_2_4 {
	meta:
		name = "??0bad_exception@std@@QEAA@XZ"
		size = 57
		refs = "0012 ??_C@_0O@DPKOEFFH@bad?5exception?$AA@ 001c ??0exception@std@@QEAA@QEBDH@Z 0028 ??_7bad_exception@std@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 41 B8 01 00 00 00 48 8D 15 ?? ?? ?? ?? 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_56_4_0 {
	meta:
		name = "??0bad_array_new_length@std@@QEAA@XZ"
		size = 51
		refs = "000c ??_C@_0BF@KINCDENJ@bad?5array?5new?5length?$AA@ 0016 ??0bad_alloc@std@@AEAA@QEBD@Z 0022 ??_7bad_array_new_length@std@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8D 15 ?? ?? ?? ?? 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_56_5_0 {
	meta:
		name = "??0exception@std@@QEAA@AEBV01@@Z"
		size = 88
		refs = "0017 ??_7exception@std@@6B@ 0049 __std_exception_copy"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 57 48 83 EC 20 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C0 08 48 8B F8 33 C0 B9 10 00 00 00 F3 AA 48 8B 44 24 30 48 83 C0 08 48 8B 4C 24 38 48 83 C1 08 48 8B D0 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_56_6_0 {
	meta:
		name = "??0exception@std@@QEAA@QEBDH@Z"
		size = 73
		refs = "0018 ??_7exception@std@@6B@"
	strings:
		$1 = { 44 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 57 48 8B 44 24 10 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 10 48 83 C0 08 48 8B F8 33 C0 B9 10 00 00 00 F3 AA 48 8B 44 24 10 48 8B 4C 24 18 48 89 48 08 48 8B 44 24 10 5F C3 }
	condition:
		$1
}

rule file_56_7_0 {
	meta:
		name = "??1bad_alloc@std@@UEAA@XZ"
		size = 24
		refs = "000f ??1exception@std@@UEAA@XZ"
		altNames = "??1bad_cast@std@@UEAA@XZ ??1bad_exception@std@@UEAA@XZ ??1bad_function_call@std@@UEAA@XZ ??1bad_typeid@std@@UEAA@XZ ??1logic_error@std@@UEAA@XZ ??1runtime_error@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_59_2_2 {
	meta:
		name = "??1?$_Func_class@X$$V@std@@QEAA@XZ"
		size = 24
		refs = "000f ?_Tidy@?$_Func_class@X$$V@std@@IEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_96_121_2 {
	meta:
		name = "??1?$_Iterator012@Urandom_access_iterator_tag@std@@D_JPEBDAEBDU_Iterator_base12@2@@std@@QEAA@XZ"
		size = 24
		refs = "000f ??1_Iterator_base12@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_10_370_2 {
	meta:
		name = "??1?$_Iterator012@Urandom_access_iterator_tag@std@@G_JPEBGAEBGU_Iterator_base12@2@@std@@QEAA@XZ"
		size = 24
		refs = "000f ??1_Iterator_base12@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_103_417_3 {
	meta:
		name = "??1?$_Iterator012@Urandom_access_iterator_tag@std@@_W_JPEB_WAEB_WU_Iterator_base12@2@@std@@QEAA@XZ"
		size = 24
		refs = "000f ??1_Iterator_base12@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_93_49_2 {
	meta:
		name = "??1?$_Ref_count_obj@V__ExceptionPtr@@@std@@UEAA@XZ"
		size = 24
		refs = "000f ??1_Ref_count_base@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_93_50_2 {
	meta:
		name = "??1?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@UEAA@XZ"
		size = 24
		refs = "000f ??1_Ref_count_base@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_105_123_2 {
	meta:
		name = "??1?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ??1?$_Iterator012@Urandom_access_iterator_tag@std@@D_JPEBDAEBDU_Iterator_base12@2@@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_10_377_2 {
	meta:
		name = "??1?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ??1?$_Iterator012@Urandom_access_iterator_tag@std@@G_JPEBGAEBGU_Iterator_base12@2@@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_20_49_3 {
	meta:
		name = "??1?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ??1?$_Iterator012@Urandom_access_iterator_tag@std@@_W_JPEB_WAEB_WU_Iterator_base12@2@@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_8_143_3 {
	meta:
		name = "??1?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ??1?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_10_379_2 {
	meta:
		name = "??1?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ??1?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_10_380_2 {
	meta:
		name = "??1?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ??1?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_18_9_4 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QEAA@XZ"
		size = 24
		refs = "000f ?release@?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_26_2_4 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@DU__crt_public_free_policy@@@@QEAA@XZ"
		size = 24
		refs = "000f ?release@?$__crt_unique_heap_ptr@DU__crt_public_free_policy@@@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_78_3_7 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@UTlsDtorNode@@U__crt_internal_free_policy@@@@QEAA@XZ"
		size = 24
		refs = "000f ?release@?$__crt_unique_heap_ptr@UTlsDtorNode@@U__crt_internal_free_policy@@@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_27_3_4 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@U__vcrt_ptd@@U__crt_internal_free_policy@@@@QEAA@XZ"
		size = 24
		refs = "000f ?release@?$__crt_unique_heap_ptr@U__vcrt_ptd@@U__crt_internal_free_policy@@@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_18_10_4 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@XU__crt_internal_free_policy@@@@QEAA@XZ"
		size = 24
		refs = "000f ?release@?$__crt_unique_heap_ptr@XU__crt_internal_free_policy@@@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_113_3_1 {
	meta:
		name = "??1?$function@$$A6AXXZ@std@@QEAA@XZ"
		size = 24
		refs = "000f ??1?$_Func_class@X$$V@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_107_157_3 {
	meta:
		name = "??1_Generic_error_category@std@@UEAA@XZ"
		size = 24
		refs = "000f ??1error_category@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_66_158_3 {
	meta:
		name = "??1_Iostream_error_category@std@@UEAA@XZ"
		size = 24
		refs = "000f ??1_Generic_error_category@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_90_116_1 {
	meta:
		name = "??1_System_error@std@@UEAA@XZ"
		size = 24
		refs = "000f ??1runtime_error@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_85_75_1 {
	meta:
		name = "??1_System_error_category@std@@UEAA@XZ"
		size = 24
		refs = "000f ??1error_category@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_25_8_4 {
	meta:
		name = "??1__non_rtti_object@std@@UEAA@XZ"
		size = 24
		refs = "000f ??1bad_typeid@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_56_8_0 {
	meta:
		name = "??1bad_array_new_length@std@@UEAA@XZ"
		size = 24
		refs = "000f ??1bad_alloc@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_101_8_1 {
	meta:
		name = "??1exception_ptr@std@@QEAA@XZ"
		size = 24
		refs = "000f ?__ExceptionPtrDestroy@@YAXPEAX@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_86_148_2 {
	meta:
		name = "??1failure@ios_base@std@@UEAA@XZ"
		size = 24
		refs = "000f ??1system_error@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_101_9_1 {
	meta:
		name = "??1future_error@std@@UEAA@XZ"
		size = 24
		refs = "000f ??1logic_error@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_88_25_1 {
	meta:
		name = "??1invalid_argument@std@@UEAA@XZ"
		size = 24
		refs = "000f ??1logic_error@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_8_26_2 {
	meta:
		name = "??1length_error@std@@UEAA@XZ"
		size = 24
		refs = "000f ??1logic_error@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_89_195_2 {
	meta:
		name = "??1messages_base@std@@UEAA@XZ"
		size = 24
		refs = "000f ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_119_363_1 {
	meta:
		name = "??1money_base@std@@UEAA@XZ"
		size = 24
		refs = "000f ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_88_28_1 {
	meta:
		name = "??1out_of_range@std@@UEAA@XZ"
		size = 24
		refs = "000f ??1logic_error@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_13_29_3 {
	meta:
		name = "??1overflow_error@std@@UEAA@XZ"
		size = 24
		refs = "000f ??1runtime_error@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_8_30_2 {
	meta:
		name = "??1regex_error@std@@UEAA@XZ"
		size = 24
		refs = "000f ??1runtime_error@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_105_69_1 {
	meta:
		name = "??1system_error@std@@UEAA@XZ"
		size = 24
		refs = "000f ??1_System_error@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_116_176_3 {
	meta:
		name = "??3_Crt_new_delete@std@@SAXPEAX@Z"
		size = 24
		refs = "000f free"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_18_13_4 {
	meta:
		name = "??B?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QEBA_NXZ"
		size = 24
		refs = "000f ?is_valid@?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QEBA_NXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_26_3_4 {
	meta:
		name = "??B?$__crt_unique_heap_ptr@DU__crt_public_free_policy@@@@QEBA_NXZ"
		size = 24
		refs = "000f ?is_valid@?$__crt_unique_heap_ptr@DU__crt_public_free_policy@@@@QEBA_NXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_27_5_4 {
	meta:
		name = "??B?$__crt_unique_heap_ptr@U__vcrt_ptd@@U__crt_internal_free_policy@@@@QEBA_NXZ"
		size = 24
		refs = "000f ?is_valid@?$__crt_unique_heap_ptr@U__vcrt_ptd@@U__crt_internal_free_policy@@@@QEBA_NXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_18_14_4 {
	meta:
		name = "??B?$__crt_unique_heap_ptr@XU__crt_internal_free_policy@@@@QEBA_NXZ"
		size = 24
		refs = "000f ?is_valid@?$__crt_unique_heap_ptr@XU__crt_internal_free_policy@@@@QEBA_NXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_93_62_2 {
	meta:
		name = "??C?$shared_ptr@V__ExceptionPtr@@@std@@QEBAPEAV__ExceptionPtr@@XZ"
		size = 24
		refs = "000f ?_Get@?$_Ptr_base@V__ExceptionPtr@@@std@@QEBAPEAV__ExceptionPtr@@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_38_232_3 {
	meta:
		name = "??D?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEBAAEADXZ"
		size = 24
		refs = "000f ??D?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEBAAEBDXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_119_394_1 {
	meta:
		name = "??D?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QEBAAEAGXZ"
		size = 24
		refs = "000f ??D?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QEBAAEBGXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_119_395_1 {
	meta:
		name = "??D?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QEBAAEA_WXZ"
		size = 24
		refs = "000f ??D?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QEBAAEB_WXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_504_0_7 {
	meta:
		name = "??_U@YAPEAX_K@Z"
		size = 24
		refs = "000f ??2@YAPEAX_K@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_47_0_7 {
	meta:
		name = "??_V@YAXPEAX@Z"
		size = 24
		refs = "000f ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_99_171_1 {
	meta:
		name = "?_Bx@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAAAEAT_Bxty@?$_String_val@U?$_Simple_types@D@std@@@2@XZ"
		size = 24
		refs = "000f ?_Get_data@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAAAEAV?$_String_val@U?$_Simple_types@D@std@@@2@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_119_494_1 {
	meta:
		name = "?_Bx@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QEAAAEAT_Bxty@?$_String_val@U?$_Simple_types@G@std@@@2@XZ"
		size = 24
		refs = "000f ?_Get_data@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QEAAAEAV?$_String_val@U?$_Simple_types@G@std@@@2@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_41_37_1 {
	meta:
		name = "?_Bx@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QEAAAEAT_Bxty@?$_String_val@U?$_Simple_types@_W@std@@@2@XZ"
		size = 24
		refs = "000f ?_Get_data@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QEAAAEAV?$_String_val@U?$_Simple_types@_W@std@@@2@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_107_278_3 {
	meta:
		name = "?_Myproxy@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAAAEAPEAU_Container_proxy@2@XZ"
		size = 24
		refs = "000f ?_Get_data@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAAAEAV?$_String_val@U?$_Simple_types@D@std@@@2@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_103_971_3 {
	meta:
		name = "?_Myproxy@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QEAAAEAPEAU_Container_proxy@2@XZ"
		size = 24
		refs = "000f ?_Get_data@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QEAAAEAV?$_String_val@U?$_Simple_types@G@std@@@2@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_99_62_2 {
	meta:
		name = "?_Myproxy@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QEAAAEAPEAU_Container_proxy@2@XZ"
		size = 24
		refs = "000f ?_Get_data@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QEAAAEAV?$_String_val@U?$_Simple_types@_W@std@@@2@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_23_15_2 {
	meta:
		name = "?_RethrowException@exception_ptr@std@@QEBAXXZ"
		size = 24
		refs = "000f ?__ExceptionPtrRethrow@@YAXPEBX@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_108_130_1 {
	meta:
		name = "?get@?$shared_ptr@V__ExceptionPtr@@@std@@QEBAPEAV__ExceptionPtr@@XZ"
		size = 24
		refs = "000f ?_Get@?$_Ptr_base@V__ExceptionPtr@@@std@@QEBAPEAV__ExceptionPtr@@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_40_359_2 {
	meta:
		name = "?max_size@?$allocator_traits@V?$allocator@D@std@@@std@@SA_KAEBV?$allocator@D@2@@Z"
		size = 24
		refs = "000f ?max_size@?$allocator@D@std@@QEBA_KXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_10_1343_2 {
	meta:
		name = "?max_size@?$allocator_traits@V?$allocator@G@std@@@std@@SA_KAEBV?$allocator@G@2@@Z"
		size = 24
		refs = "000f ?max_size@?$allocator@G@std@@QEBA_KXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_20_145_3 {
	meta:
		name = "?max_size@?$allocator_traits@V?$allocator@_W@std@@@std@@SA_KAEBV?$allocator@_W@2@@Z"
		size = 24
		refs = "000f ?max_size@?$allocator@_W@std@@QEBA_KXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_91_334_1 {
	meta:
		name = "?pointer_to@?$pointer_traits@PEAD@std@@SAPEADAEAD@Z"
		size = 24
		refs = "000f ??$addressof@D@std@@YAPEADAEAD@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_119_1222_1 {
	meta:
		name = "?pointer_to@?$pointer_traits@PEAG@std@@SAPEAGAEAG@Z"
		size = 24
		refs = "000f ??$addressof@G@std@@YAPEAGAEAG@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_94_167_2 {
	meta:
		name = "?pointer_to@?$pointer_traits@PEAU_Container_proxy@std@@@std@@SAPEAU_Container_proxy@2@AEAU32@@Z"
		size = 24
		refs = "000f ??$addressof@U_Container_proxy@std@@@std@@YAPEAU_Container_proxy@0@AEAU10@@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_103_1411_3 {
	meta:
		name = "?pointer_to@?$pointer_traits@PEA_W@std@@SAPEA_WAEA_W@Z"
		size = 24
		refs = "000f ??$addressof@_W@std@@YAPEA_WAEA_W@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_31_0_2 {
	meta:
		name = "_LDtest"
		size = 24
		refs = "000f _Dtest"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_79_39_3 {
	meta:
		name = "_Mtx_getconcrtcs"
		size = 24
		refs = "000f ?_get_cs@_Mtx_internal_imp_t@@QEAAPEAVstl_critical_section_interface@details@Concurrency@@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_56_9_0 {
	meta:
		name = "??1exception@std@@UEAA@XZ"
		size = 46
		refs = "0011 ??_7exception@std@@6B@ 0025 __std_exception_destroy"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C0 08 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_56_10_0 {
	meta:
		name = "??_Gbad_alloc@std@@UEAAPEAXI@Z"
		size = 59
		refs = "0013 ??1bad_alloc@std@@UEAA@XZ 002d ??3@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0F BA 18 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_25_12_4 {
	meta:
		name = "??_G__non_rtti_object@std@@UEAAPEAXI@Z"
		size = 59
		refs = "0013 ??1__non_rtti_object@std@@UEAA@XZ 002d ??3@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0F BA 18 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_211_11_7 {
	meta:
		name = "??_Gbad_array_new_length@std@@UEAAPEAXI@Z"
		size = 59
		refs = "0013 ??1bad_array_new_length@std@@UEAA@XZ 002d ??3@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0F BA 18 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_82_175_2 {
	meta:
		name = "??_Gbad_cast@std@@UEAAPEAXI@Z"
		size = 59
		refs = "0013 ??1bad_cast@std@@UEAA@XZ 002d ??3@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0F BA 18 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_5_8_4 {
	meta:
		name = "??_Gbad_exception@std@@UEAAPEAXI@Z"
		size = 59
		refs = "0013 ??1bad_exception@std@@UEAA@XZ 002d ??3@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0F BA 18 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_13_33_3 {
	meta:
		name = "??_Gbad_function_call@std@@UEAAPEAXI@Z"
		size = 59
		refs = "0013 ??1bad_function_call@std@@UEAA@XZ 002d ??3@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0F BA 18 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_25_14_4 {
	meta:
		name = "??_Gbad_typeid@std@@UEAAPEAXI@Z"
		size = 59
		refs = "0013 ??1bad_typeid@std@@UEAA@XZ 002d ??3@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0F BA 18 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_36_108_3 {
	meta:
		name = "??_Gexception@std@@UEAAPEAXI@Z"
		size = 59
		refs = "0013 ??1exception@std@@UEAA@XZ 002d ??3@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0F BA 18 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_8_35_2 {
	meta:
		name = "??_Ginvalid_argument@std@@UEAAPEAXI@Z"
		size = 59
		refs = "0013 ??1invalid_argument@std@@UEAA@XZ 002d ??3@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0F BA 18 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_13_36_3 {
	meta:
		name = "??_Glength_error@std@@UEAAPEAXI@Z"
		size = 59
		refs = "0013 ??1length_error@std@@UEAA@XZ 002d ??3@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0F BA 18 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_88_37_1 {
	meta:
		name = "??_Glogic_error@std@@UEAAPEAXI@Z"
		size = 59
		refs = "0013 ??1logic_error@std@@UEAA@XZ 002d ??3@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0F BA 18 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_8_38_2 {
	meta:
		name = "??_Gout_of_range@std@@UEAAPEAXI@Z"
		size = 59
		refs = "0013 ??1out_of_range@std@@UEAA@XZ 002d ??3@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0F BA 18 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_8_39_2 {
	meta:
		name = "??_Goverflow_error@std@@UEAAPEAXI@Z"
		size = 59
		refs = "0013 ??1overflow_error@std@@UEAA@XZ 002d ??3@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0F BA 18 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_38_266_3 {
	meta:
		name = "??_Gruntime_error@std@@UEAAPEAXI@Z"
		size = 59
		refs = "0013 ??1runtime_error@std@@UEAA@XZ 002d ??3@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0F BA 18 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_214_1_0 {
	meta:
		name = "??_Gtype_info@@UEAAPEAXI@Z"
		size = 59
		refs = "0013 ??1type_info@@UEAA@XZ 002d ??3@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0F BA 18 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_56_13_0 {
	meta:
		name = "?__scrt_throw_std_bad_alloc@@YAXXZ"
		size = 36
		refs = "000a ??0bad_alloc@std@@QEAA@XZ 0011 _TI2?AVbad_alloc@std@@ 001b _CxxThrowException"
		altNames = "?_Xbad_alloc@std@@YAXXZ"
	strings:
		$1 = { 48 83 EC 48 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_88_44_1 {
	meta:
		name = "?_Xbad_function_call@std@@YAXXZ"
		size = 36
		refs = "000a ??0bad_function_call@std@@QEAA@XZ 0011 _TI2?AVbad_function_call@std@@ 001b _CxxThrowException"
	strings:
		$1 = { 48 83 EC 48 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_56_14_0 {
	meta:
		name = "?__scrt_throw_std_bad_array_new_length@@YAXXZ"
		size = 36
		refs = "000a ??0bad_array_new_length@std@@QEAA@XZ 0011 _TI3?AVbad_array_new_length@std@@ 001b _CxxThrowException"
	strings:
		$1 = { 48 83 EC 48 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_56_15_0 {
	meta:
		name = "?what@exception@std@@UEBAPEBDXZ"
		size = 56
		refs = "0027 ??_C@_0BC@EOODALEL@Unknown?5exception?$AA@"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 18 48 8B 44 24 20 48 83 78 08 00 74 0F 48 8B 44 24 20 48 8B 40 08 48 89 04 24 EB 0B 48 8D 05 ?? ?? ?? ?? 48 89 04 24 48 8B 04 24 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_1_0_4 {
	meta:
		name = "?get_unexpected_or_default@@YAP6AXXZQEBU__vcrt_ptd@@@Z"
		size = 56
		refs = "0027 terminate"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 18 48 8B 44 24 20 48 83 78 08 00 74 0F 48 8B 44 24 20 48 8B 40 08 48 89 04 24 EB 0B 48 8D 05 ?? ?? ?? ?? 48 89 04 24 48 8B 04 24 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_57_0_0 {
	meta:
		name = "__vdecl_fmod4"
		size = 107
		refs = "0011 fmod"
	strings:
		$1 = { 48 83 EC 68 C5 FE 7F 44 24 20 C5 FE 7F 4C 24 40 E8 ?? ?? ?? ?? 66 0F D6 44 24 20 F3 0F 7E 44 24 28 F3 0F 7E 4C 24 48 E8 ?? ?? ?? ?? 66 0F D6 44 24 28 F3 0F 7E 44 24 30 F3 0F 7E 4C 24 50 E8 ?? ?? ?? ?? 66 0F D6 44 24 30 F3 0F 7E 44 24 38 F3 0F 7E 4C 24 58 E8 ?? ?? ?? ?? 66 0F D6 44 24 38 C5 FE 6F 44 24 20 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_59_0_0 {
	meta:
		name = "__avx_ceil4"
		size = 16
	strings:
		$1 = { C4 E3 7D 09 C0 02 C3 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_61_0_0 {
	meta:
		name = "__sse2_ceilf4"
		size = 96
		refs = "0015 s_dw7f800000_1933_0_1 0029 s_dw4affffff_1933_0_1 0049 s_dwbf800000_1933_0_1"
	strings:
		$1 = { 66 0F 6F C8 F3 0F 5B D0 66 0F 72 E1 1F 66 0F 6F D8 66 0F DB 05 ?? ?? ?? ?? 0F 5B D2 66 0F 6F E9 66 0F 72 F1 1F 66 0F 66 05 ?? ?? ?? ?? 66 0F EB D1 66 0F 6F E3 66 0F DB D8 66 0F DF C2 66 0F EB C3 66 0F 76 E0 66 0F DF 25 ?? ?? ?? ?? 66 0F DF EC 0F 5C C5 C3 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_63_0_0 {
	meta:
		name = "__sse2_floorf4"
		size = 80
		refs = "0006 _2il0floatpacket_4 0010 _2il0floatpacket_5 0037 _2il0floatpacket_6"
	strings:
		$1 = { 0F 28 E0 0F 28 0D ?? ?? ?? ?? 0F 28 E8 0F 28 1D ?? ?? ?? ?? 0F 54 E1 0F 55 C8 0F 28 D3 0F C2 D1 01 0F 58 CB 0F 54 C2 0F 5C CB 0F 56 CC 0F 28 DA 0F C2 E9 01 0F 54 2D ?? ?? ?? ?? 0F 5C CD 0F 55 D9 0F 56 C3 C3 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_64_0_0 {
	meta:
		name = "__avx_asin4"
		size = 656
		refs = "0048 __common_dasin_data 0287 __common_dasin_cout_rare"
	strings:
		$1 = { 48 81 EC 18 02 00 00 C5 7C 11 BC 24 F0 01 00 00 C5 7C 11 94 24 90 01 00 00 C5 7C 11 8C 24 B0 01 00 00 C5 7C 11 84 24 70 01 00 00 C5 FC 11 B4 24 D0 01 00 00 4C 89 AC 24 10 02 00 00 4C 8D AC 24 0F 01 00 00 C5 FD 10 2D ?? ?? ?? ?? 49 83 E5 C0 C5 7D 10 0D ?? ?? ?? ?? C5 55 54 D0 C4 41 2D 59 F9 C5 AD C2 25 ?? ?? ?? ?? 1D C4 41 35 5C FF C4 41 2D C2 C9 15 C4 C1 7D 5A DF C5 55 55 C0 C4 C1 2D 59 EA C4 C1 55 5D EF C4 41 05 58 FF C4 E3 7D 19 E1 01 C5 D8 C6 D1 DD C5 F8 52 E3 C5 F8 50 D2 C5 FC 5A F4 C5 CD 59 CE C5 85 59 F6 C5 85 59 D1 C5 ED 5C 25 ?? ?? ?? ?? C5 DD 59 1D ?? ?? ?? ?? C5 4D 59 FC C5 E5 58 0D ?? ?? ?? ?? C5 F5 59 D4 C5 D5 59 0D ?? ?? ?? ?? C5 ED 58 1D ?? ?? ?? ?? C5 F5 58 0D ?? ?? ?? ?? C5 D5 59 15 ?? ?? ?? ?? C5 E5 59 E4 C5 ED 58 15 ?? ?? ?? ?? C5 DD 58 25 ?? ?? ?? ?? C4 41 5D 59 FF C5 D5 59 25 ?? ?? ?? ?? C5 05 5C FE C5 D5 59 35 ?? ?? ?? ?? C5 CD 58 1D ?? ?? ?? ?? C5 DD 58 35 ?? ?? ?? ?? C5 D5 59 E5 C5 E5 59 DC C5 E5 58 DE C5 F5 59 F4 C5 CD 58 CA C5 DD 59 D4 C5 D5 59 35 ?? ?? ?? ?? C5 E5 59 D2 C5 CD 58 35 ?? ?? ?? ?? C5 ED 58 C9 C5 F5 59 DC C5 D5 59 0D ?? ?? ?? ?? C5 E5 58 D6 C5 F5 58 1D ?? ?? ?? ?? C5 ED 59 E4 C5 DD 58 CB C5 F5 59 ED C4 C3 2D 4B CF 90 C5 55 59 D1 C5 AD 58 D1 C5 35 54 0D ?? ?? ?? ?? C4 C1 6D 58 C9 C4 C1 75 57 C8 85 D2 75 41 C5 FC 10 B4 24 D0 01 00 00 C5 7C 10 84 24 70 01 00 00 C5 7C 10 8C 24 B0 01 00 00 C5 7C 10 94 24 90 01 00 00 C5 7C 10 BC 24 F0 01 00 00 4C 8B AC 24 10 02 00 00 C5 FD 28 C1 48 81 C4 18 02 00 00 C3 C4 C1 7D 11 45 00 C4 C1 7D 11 4D 40 74 B1 33 C0 C5 FC 11 BC 24 A0 00 00 00 C5 7C 11 9C 24 80 00 00 00 C5 7C 11 64 24 60 C5 7C 11 6C 24 40 C5 7C 11 74 24 20 48 89 9C 24 C8 00 00 00 8B D8 48 89 B4 24 C0 00 00 00 8B F2 0F A3 DE 72 46 FF C3 83 FB 20 7C F4 C5 FC 10 BC 24 A0 00 00 00 C5 7C 10 9C 24 80 00 00 00 C5 7C 10 64 24 60 C5 7C 10 6C 24 40 C5 7C 10 74 24 20 C4 C1 7D 10 4D 40 48 8B 9C 24 C8 00 00 00 48 8B B4 24 C0 00 00 00 E9 2C FF FF FF C5 F8 77 49 8D 4C DD 00 49 8D 54 DD 40 E8 ?? ?? ?? ?? EB A6 0F 1F 00 }
	condition:
		$1
}

rule file_67_0_0 {
	meta:
		name = "?dllmain_crt_dispatch@@YAHQEAUHINSTANCE__@@KQEAX@Z"
		size = 135
		refs = "0043 ?dllmain_crt_process_attach@@YAHQEAUHINSTANCE__@@QEAX@Z 0063 ?dllmain_crt_process_detach@@YAH_N@Z 006a __scrt_dllmain_crt_thread_attach 0074 __scrt_dllmain_crt_thread_detach"
	strings:
		$1 = { 4C 89 44 24 18 89 54 24 10 48 89 4C 24 08 48 83 EC 38 8B 44 24 48 89 44 24 24 83 7C 24 24 00 74 28 83 7C 24 24 01 74 10 83 7C 24 24 02 74 3A 83 7C 24 24 03 74 3D EB 45 48 8B 54 24 50 48 8B 4C 24 40 E8 ?? ?? ?? ?? EB 39 48 83 7C 24 50 00 74 07 C6 44 24 20 01 EB 05 C6 44 24 20 00 0F B6 4C 24 20 E8 ?? ?? ?? ?? EB 19 E8 ?? ?? ?? ?? 0F B6 C0 EB 0F E8 ?? ?? ?? ?? 0F B6 C0 EB 05 B8 01 00 00 00 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_67_1_0 {
	meta:
		name = "?dllmain_crt_process_attach@@YAHQEAUHINSTANCE__@@QEAX@Z"
		size = 331
		refs = "0011 __scrt_initialize_crt 0024 __scrt_acquire_startup_lock 0033 __scrt_current_native_startup_state 0040 __scrt_fastfail 004f __scrt_dllmain_before_initialize_c 005d _RTC_Initialize 0064 _RTC_Terminate 0069 atexit 006e ?__scrt_initialize_type_info@@YAXXZ 0075 ?__scrt_uninitialize_type_info@@YAXXZ 007f __scrt_initialize_default_local_stdio_options 0086 __xi_z 008d __xi_a 0092 _initterm_e 009d __scrt_dllmain_after_initialize_c 00ad __xc_z 00b4 __xc_a 00b9 _initterm 00d2 __scrt_release_startup_lock 00e4 __scrt_get_dyn_tls_init_callback 00fe __scrt_is_nonwritable_in_current_image 011c _guard_check_icall 0135 ?__proc_attached@@3HA"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 33 C9 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 07 33 C0 E9 23 01 00 00 E8 ?? ?? ?? ?? 88 44 24 20 C6 44 24 21 01 83 3D ?? ?? ?? ?? 00 74 0A B9 07 00 00 00 E8 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 01 00 00 00 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 02 EB 70 E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 02 EB 30 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 02 EB 22 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 02 00 00 00 C6 44 24 21 00 0F B6 4C 24 20 E8 ?? ?? ?? ?? 0F B6 44 24 21 85 C0 74 04 33 C0 EB 63 E8 ?? ?? ?? ?? 48 89 44 24 28 48 8B 44 24 28 48 83 38 00 74 3B 48 8B 4C 24 28 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 2A 48 8B 44 24 28 48 8B 00 48 89 44 24 30 48 8B 4C 24 30 E8 ?? ?? ?? ?? 4C 8B 44 24 58 BA 02 00 00 00 48 8B 4C 24 50 FF 54 24 30 8B 05 ?? ?? ?? ?? FF C0 89 05 ?? ?? ?? ?? B8 01 00 00 00 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_67_2_0 {
	meta:
		name = "?fin$0@?0??dllmain_crt_process_attach@@YAHQEAUHINSTANCE__@@QEAX@Z@4HA"
		size = 26
		refs = "000e __scrt_release_startup_lock"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 0F B6 4D 20 E8 ?? ?? ?? ?? 90 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_67_3_0 {
	meta:
		name = "?dllmain_crt_process_detach@@YAH_N@Z"
		size = 126
		refs = "000a ?__proc_attached@@3HA 0024 __scrt_acquire_startup_lock 002e __scrt_current_native_startup_state 003b __scrt_fastfail 0040 __scrt_dllmain_uninitialize_c 004f __scrt_dllmain_uninitialize_critical 0059 __scrt_release_startup_lock 0065 __scrt_uninitialize_crt"
	strings:
		$1 = { 88 4C 24 08 48 83 EC 38 83 3D ?? ?? ?? ?? 00 7F 04 33 C0 EB 64 8B 05 ?? ?? ?? ?? FF C8 89 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? 88 44 24 20 83 3D ?? ?? ?? ?? 02 74 0A B9 07 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 00 00 00 00 E8 ?? ?? ?? ?? 0F B6 4C 24 20 E8 ?? ?? ?? ?? 33 D2 0F B6 4C 24 40 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 04 33 C0 EB 05 B8 01 00 00 00 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_67_4_0 {
	meta:
		name = "?fin$0@?0??dllmain_crt_process_detach@@YAH_N@Z@4HA"
		size = 32
		refs = "000a __scrt_dllmain_uninitialize_critical 0014 __scrt_release_startup_lock"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA E8 ?? ?? ?? ?? 90 0F B6 4D 20 E8 ?? ?? ?? ?? 90 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_67_5_0 {
	meta:
		name = "?dllmain_dispatch@@YAHQEAUHINSTANCE__@@KQEAX@Z"
		size = 309
		refs = "001b ?__proc_attached@@3HA 004e ?dllmain_raw@@YAHQEAUHINSTANCE__@@KQEAX@Z 0071 ?dllmain_crt_dispatch@@YAHQEAUHINSTANCE__@@KQEAX@Z 0094 DllMain"
	strings:
		$1 = { 4C 89 44 24 18 89 54 24 10 48 89 4C 24 08 48 83 EC 48 83 7C 24 58 00 75 10 83 3D ?? ?? ?? ?? 00 7F 07 33 C0 E9 07 01 00 00 C7 44 24 30 01 00 00 00 83 7C 24 58 01 74 07 83 7C 24 58 02 75 46 4C 8B 44 24 60 8B 54 24 58 48 8B 4C 24 50 E8 ?? ?? ?? ?? 89 44 24 30 83 7C 24 30 00 75 05 E9 C0 00 00 00 4C 8B 44 24 60 8B 54 24 58 48 8B 4C 24 50 E8 ?? ?? ?? ?? 89 44 24 30 83 7C 24 30 00 75 05 E9 9D 00 00 00 4C 8B 44 24 60 8B 54 24 58 48 8B 4C 24 50 E8 ?? ?? ?? ?? 89 44 24 30 83 7C 24 58 01 75 3A 83 7C 24 30 00 75 33 4C 8B 44 24 60 33 D2 48 8B 4C 24 50 E8 ?? ?? ?? ?? 4C 8B 44 24 60 33 D2 48 8B 4C 24 50 E8 ?? ?? ?? ?? 4C 8B 44 24 60 33 D2 48 8B 4C 24 50 E8 ?? ?? ?? ?? 83 7C 24 58 00 74 07 83 7C 24 58 03 75 37 4C 8B 44 24 60 8B 54 24 58 48 8B 4C 24 50 E8 ?? ?? ?? ?? 89 44 24 30 83 7C 24 30 00 75 02 EB 17 4C 8B 44 24 60 8B 54 24 58 48 8B 4C 24 50 E8 ?? ?? ?? ?? 89 44 24 30 EB 08 C7 44 24 30 00 00 00 00 8B 44 24 30 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_67_6_0 {
	meta:
		name = "?filt$0@?0??dllmain_dispatch@@YAHQEAUHINSTANCE__@@KQEAX@Z@4HA"
		size = 72
		refs = "002c ?dllmain_crt_dispatch@@YAHQEAUHINSTANCE__@@KQEAX@Z 003c __scrt_dllmain_exception_filter"
	strings:
		$1 = { 40 55 48 83 EC 30 48 8B EA 48 89 4D 38 48 8B 45 38 48 8B 00 8B 00 89 45 34 48 8B 45 38 8B 4D 34 48 89 44 24 28 89 4C 24 20 4C 8D 0D ?? ?? ?? ?? 4C 8B 45 60 8B 55 58 48 8B 4D 50 E8 ?? ?? ?? ?? 90 48 83 C4 30 5D C3 CC }
	condition:
		$1
}

rule file_67_7_0 {
	meta:
		name = "?dllmain_raw@@YAHQEAUHINSTANCE__@@KQEAX@Z"
		size = 80
		refs = "0015 _pRawDllMain 0035 _guard_check_icall"
	strings:
		$1 = { 4C 89 44 24 18 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 83 3D ?? ?? ?? ?? 00 75 07 B8 01 00 00 00 EB 28 48 8B 05 ?? ?? ?? ?? 48 89 44 24 20 48 8B 4C 24 20 E8 ?? ?? ?? ?? 4C 8B 44 24 50 8B 54 24 48 48 8B 4C 24 40 FF 54 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_67_8_0 {
	meta:
		name = "_CRT_INIT"
		size = 42
		refs = "0021 ?dllmain_crt_dispatch@@YAHQEAUHINSTANCE__@@KQEAX@Z"
	strings:
		$1 = { 4C 89 44 24 18 89 54 24 10 48 89 4C 24 08 48 83 EC 28 4C 8B 44 24 40 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_67_9_0 {
	meta:
		name = "_DllMainCRTStartup"
		size = 54
		refs = "001a __security_init_cookie 002d ?dllmain_dispatch@@YAHQEAUHINSTANCE__@@KQEAX@Z"
	strings:
		$1 = { 4C 89 44 24 18 89 54 24 10 48 89 4C 24 08 48 83 EC 28 83 7C 24 38 01 75 05 E8 ?? ?? ?? ?? 4C 8B 44 24 40 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_69_0_0 {
	meta:
		name = "__avx_pow4"
		size = 1216
		refs = "000a __common_dpow_data 04b2 __common_dpow_cout_rare"
	strings:
		$1 = { 48 81 EC 58 02 00 00 48 8D 15 ?? ?? ?? ?? C5 7C 11 BC 24 B0 01 00 00 C5 7C 11 B4 24 90 01 00 00 C5 7C 11 AC 24 70 01 00 00 C5 7C 11 A4 24 50 01 00 00 C5 7C 11 9C 24 30 01 00 00 C5 7C 11 94 24 10 01 00 00 C5 7C 11 8C 24 D0 01 00 00 C5 7C 11 84 24 30 02 00 00 C5 FC 11 BC 24 10 02 00 00 C5 FC 11 B4 24 F0 01 00 00 4C 89 AC 24 50 02 00 00 4C 8D 6C 24 6F C5 78 10 3D ?? ?? ?? ?? 49 83 E5 C0 C5 F8 10 1D ?? ?? ?? ?? C4 E3 7D 19 C5 01 C5 F8 C6 ED DD C5 50 54 15 ?? ?? ?? ?? C5 29 FE 25 ?? ?? ?? ?? C4 C1 21 72 D4 0A C4 C1 41 72 F3 03 C4 C1 49 72 F3 04 C5 F9 7E F8 C4 C1 79 7E F2 48 63 C0 C4 E3 79 16 F9 01 48 63 C9 C4 C3 79 16 F3 01 C5 7B 10 0C 10 4D 63 D2 4D 63 DB C5 31 16 34 11 C4 E3 79 16 F0 02 C4 E3 79 16 F1 03 C4 C3 79 16 F8 02 48 63 C0 48 63 C9 4D 63 C0 C4 C3 79 16 F9 03 4D 63 C9 C4 41 79 10 9C 12 40 20 00 00 C4 41 79 10 8C 13 40 20 00 00 C5 7D 54 2D ?? ?? ?? ?? C5 15 56 05 ?? ?? ?? ?? C4 41 7B 10 2C 10 C4 41 11 16 14 11 C4 E3 25 18 B4 10 40 20 00 00 01 C4 E3 35 18 BC 11 40 20 00 00 01 C5 4D 14 DF C5 4D 15 CF C5 D1 FA 35 ?? ?? ?? ?? C5 91 72 E6 14 C5 D1 FE 2D ?? ?? ?? ?? C4 43 0D 18 E2 01 C5 11 FE 35 ?? ?? ?? ?? C4 41 79 70 D6 50 C4 C1 79 70 FE FA C4 E3 2D 18 F7 01 C5 4D 54 2D ?? ?? ?? ?? C5 FD 10 35 ?? ?? ?? ?? C4 C1 3D 59 FC C5 15 5C 15 ?? ?? ?? ?? C5 3D 54 F6 C4 41 3D 5C EE C5 45 58 05 ?? ?? ?? ?? C4 41 2D 58 DB C4 41 0D 59 F4 C4 41 15 59 E4 C4 41 25 58 D0 C5 8D 5C FF C5 1D 58 E7 C4 C1 25 5C FA C4 41 2D 58 EC C4 C1 45 58 F8 C4 41 2D 5C DD C4 41 25 58 F4 C5 0D 58 D7 C4 41 3D 58 F4 C4 C1 2D 58 F9 C5 0D 59 05 ?? ?? ?? ?? C5 3D 58 15 ?? ?? ?? ?? C4 41 2D 59 DE C5 25 58 25 ?? ?? ?? ?? C4 41 1D 59 C6 C5 3D 58 0D ?? ?? ?? ?? C4 41 35 59 D6 C5 2D 58 1D ?? ?? ?? ?? C4 41 25 59 E6 C5 1D 58 05 ?? ?? ?? ?? C4 41 3D 59 F6 C5 8D 58 FF C5 15 58 D7 C4 41 2D 5C ED C4 C1 45 5C FD C5 2D 54 EE C4 41 2D 5C E5 C5 75 54 DE C4 C1 25 59 F5 C4 41 75 5C D3 C4 41 25 59 DC C4 41 2D 59 F4 C4 41 2D 59 D5 C4 41 25 58 E6 C4 E3 7D 19 CC 01 C5 F0 C6 D4 DD C4 C1 69 DB D7 C5 F8 10 25 ?? ?? ?? ?? C5 D9 66 E5 C4 C3 7D 19 F0 01 C4 41 48 C6 C8 DD C4 41 31 DB C7 C5 69 66 FB C5 E9 76 DB C5 81 EB EB C5 D9 EB DD C5 FD 10 25 ?? ?? ?? ?? C5 78 10 0D ?? ?? ?? ?? C4 41 39 66 F9 C4 C1 39 76 D1 C5 01 EB C2 C4 41 61 EB C8 C5 CD 58 D4 C4 41 2D 58 FC C4 C1 78 50 C1 C5 F5 59 EF C4 E3 7D 19 D7 01 C5 E8 C6 FF 88 C5 40 54 2D ?? ?? ?? ?? C5 B9 72 F7 0D C4 C1 61 72 F5 04 C4 C1 79 7E D8 C5 ED 5C D4 C5 39 FE 15 ?? ?? ?? ?? C4 41 79 70 CA 50 C4 C3 79 16 DA 02 4D 63 C0 C4 C3 79 16 D9 01 4D 63 D2 C4 E3 79 16 D9 03 4D 63 C9 48 63 C9 C5 CD 5C D2 C5 85 58 F5 C4 41 7B 10 AC 10 80 60 00 00 C4 41 79 70 DA FA C4 41 7B 10 84 12 80 60 00 00 C5 4D 58 D2 C4 41 11 16 B4 11 80 60 00 00 C5 B9 16 9C 11 80 60 00 00 C4 43 35 18 E3 01 C5 9D 54 3D ?? ?? ?? ?? C4 E3 0D 18 DB 01 C5 45 59 FB C5 AD 59 3D ?? ?? ?? ?? C4 41 05 59 EA C5 C5 58 25 ?? ?? ?? ?? C4 C1 5D 59 EA C5 D5 58 35 ?? ?? ?? ?? C4 41 4D 59 C2 C5 3D 58 0D ?? ?? ?? ?? C4 41 35 59 DA C5 25 58 25 ?? ?? ?? ?? C4 41 1D 59 F5 C4 C1 0D 58 D7 85 C0 75 6E C5 FC 10 B4 24 F0 01 00 00 C5 FC 10 BC 24 10 02 00 00 C5 7C 10 84 24 30 02 00 00 C5 7C 10 8C 24 D0 01 00 00 C5 7C 10 94 24 10 01 00 00 C5 7C 10 9C 24 30 01 00 00 C5 7C 10 A4 24 50 01 00 00 C5 7C 10 AC 24 70 01 00 00 C5 7C 10 B4 24 90 01 00 00 C5 7C 10 BC 24 B0 01 00 00 4C 8B AC 24 50 02 00 00 C5 FD 28 C2 48 81 C4 58 02 00 00 C3 C4 C1 7D 11 45 00 C4 C1 7D 11 4D 40 C4 C1 7D 11 95 80 00 00 00 0F 84 77 FF FF FF 33 D2 48 89 5C 24 28 8B DA 48 89 74 24 20 8B F0 0F A3 DE 72 1F FF C3 83 FB 20 7C F4 48 8B 5C 24 28 48 8B 74 24 20 C4 C1 7D 10 95 80 00 00 00 E9 43 FF FF FF C5 F8 77 49 8D 4C DD 00 49 8D 54 DD 40 4D 8D 84 DD 80 00 00 00 E8 ?? ?? ?? ?? EB C5 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_75_0_0 {
	meta:
		name = "__common_dexp_cout_rare"
		size = 880
		refs = "0016 _imldExpHATab"
	strings:
		$1 = { 55 48 83 EC 70 33 C0 4C 8B 01 4C 89 44 24 60 49 C1 E8 30 4C 8B 0D ?? ?? ?? ?? 41 81 E0 F0 7F 00 00 41 C1 E8 04 F2 0F 10 09 41 81 F8 FF 07 00 00 0F 84 02 03 00 00 41 81 F8 CA 03 00 00 0F 8E DF 02 00 00 F2 0F 10 05 ?? ?? ?? ?? 66 0F 2F C1 0F 82 B2 02 00 00 66 0F 2F 0D ?? ?? ?? ?? 0F 82 89 02 00 00 F2 0F 10 05 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? F2 0F 59 C1 F2 0F 11 44 24 50 F2 0F 10 54 24 50 F2 0F 10 05 ?? ?? ?? ?? 4C 89 4C 24 60 F2 0F 58 15 ?? ?? ?? ?? F2 0F 11 54 24 58 0F 28 D1 F2 0F 10 5C 24 58 8B 4C 24 58 44 8B C1 83 E1 3F F2 0F 5C 1D ?? ?? ?? ?? F2 0F 11 5C 24 50 44 8D 14 09 F2 0F 10 64 24 50 8D 4C 09 01 F2 0F 59 25 ?? ?? ?? ?? F2 0F 10 6C 24 50 F2 0F 5C D4 F2 0F 59 2D ?? ?? ?? ?? F2 0F 5C D5 F2 0F 59 C2 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C2 41 C1 E8 06 F2 0F 58 05 ?? ?? ?? ?? 66 0F 2F 0D ?? ?? ?? ?? F2 0F 59 C2 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C2 41 8D A8 FF 03 00 00 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C2 F2 0F 59 C2 F2 0F 58 C2 F2 43 0F 10 14 D3 F2 41 0F 58 04 CB F2 0F 59 C2 72 76 81 E5 FF 07 00 00 F2 0F 58 C2 81 FD FE 07 00 00 77 2B 49 C1 E9 30 C1 E5 04 41 81 E1 0F 80 FF FF 44 0B CD 66 44 89 4C 24 66 F2 0F 10 4C 24 60 F2 0F 59 C1 F2 0F 11 02 48 83 C4 70 5D C3 FF CD 81 E5 FF 07 00 00 0F B7 4C 24 66 C1 E5 04 81 E1 0F 80 FF FF 0B CD 66 89 4C 24 66 F2 0F 10 4C 24 60 F2 0F 59 C1 F2 0F 59 05 ?? ?? ?? ?? F2 0F 11 02 48 83 C4 70 5D C3 41 81 C0 3B 04 00 00 41 81 E0 FF 07 00 00 41 8B C0 0F B7 4C 24 66 C1 E0 04 81 E1 0F 80 FF FF 0B C8 66 89 4C 24 66 41 83 F8 32 F2 0F 10 5C 24 60 F2 0F 59 C3 F2 0F 59 DA 0F 28 CB F2 0F 58 C8 77 11 F2 0F 59 0D ?? ?? ?? ?? F2 0F 11 0A E9 CE 00 00 00 F2 0F 11 4C 24 20 F2 0F 10 4C 24 20 F2 0F 5C D9 F2 0F 11 5C 24 28 F2 0F 10 54 24 28 F2 0F 58 C2 F2 0F 11 44 24 28 F2 0F 10 44 24 20 F2 0F 59 05 ?? ?? ?? ?? F2 0F 11 44 24 30 F2 0F 10 64 24 20 F2 0F 10 5C 24 30 F2 0F 58 E3 F2 0F 11 64 24 38 F2 0F 10 44 24 38 F2 0F 10 6C 24 30 F2 0F 5C C5 F2 0F 11 44 24 40 F2 0F 10 54 24 20 F2 0F 10 4C 24 40 F2 0F 5C D1 F2 0F 11 54 24 48 F2 0F 10 5C 24 28 F2 0F 10 64 24 48 F2 0F 58 E3 F2 0F 11 64 24 48 F2 0F 10 44 24 40 F2 0F 59 05 ?? ?? ?? ?? F2 0F 11 44 24 40 F2 0F 10 4C 24 48 F2 0F 59 0D ?? ?? ?? ?? F2 0F 11 4C 24 48 F2 0F 10 54 24 40 F2 0F 10 6C 24 48 F2 0F 58 D5 F2 0F 11 12 B8 04 00 00 00 48 83 C4 70 5D C3 F2 0F 10 05 ?? ?? ?? ?? B8 04 00 00 00 F2 0F 59 C0 F2 0F 11 02 48 83 C4 70 5D C3 F2 0F 10 05 ?? ?? ?? ?? B8 03 00 00 00 F2 0F 59 C0 F2 0F 11 02 48 83 C4 70 5D C3 F2 0F 10 05 ?? ?? ?? ?? F2 0F 58 C1 F2 0F 11 02 48 83 C4 70 5D C3 8A 4C 24 67 80 E1 80 80 F9 80 74 0E F2 0F 59 C9 F2 0F 11 0A 48 83 C4 70 5D C3 F7 44 24 64 FF FF 0F 00 75 E8 83 7C 24 60 00 75 E1 4C 89 0A 48 83 C4 70 5D C3 0F 1F 40 00 }
	condition:
		$1
}

rule file_78_0_0 {
	meta:
		name = "__common_scosh_cout_rare"
		size = 1072
		refs = "0030 _vmldCoshHATab"
	strings:
		$1 = { 48 81 EC 88 00 00 00 33 C0 44 0F B7 41 02 41 81 E0 80 7F 00 00 44 0F 29 5C 24 70 41 81 F8 80 7F 00 00 44 0F 29 44 24 50 0F 29 7C 24 60 4C 8B 0D ?? ?? ?? ?? 0F 84 E7 03 00 00 F3 0F 5A 01 F2 0F 11 44 24 40 80 64 24 47 7F 0F B7 4C 24 46 81 E1 F0 7F 00 00 81 F9 90 3C 00 00 0F 8E 92 03 00 00 F2 44 0F 10 5C 24 40 F2 0F 10 05 ?? ?? ?? ?? 66 41 0F 2F C3 0F 86 5D 03 00 00 4C 89 4C 24 40 66 44 0F 2F 1D ?? ?? ?? ?? 0F 82 5B 01 00 00 F2 0F 10 05 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? F2 41 0F 59 C3 F2 0F 10 25 ?? ?? ?? ?? F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 44 24 20 F2 0F 10 4C 24 20 44 8B 44 24 20 41 8B C8 83 E1 3F F2 0F 5C 0D ?? ?? ?? ?? F2 0F 11 4C 24 28 44 8D 14 09 F2 0F 10 54 24 28 8D 4C 09 01 F2 0F 59 15 ?? ?? ?? ?? F2 0F 10 5C 24 28 F2 44 0F 5C DA F2 0F 59 1D ?? ?? ?? ?? F2 44 0F 5C DB F2 41 0F 59 E3 F2 43 0F 10 0C D3 F2 0F 58 25 ?? ?? ?? ?? F2 41 0F 59 E3 41 C1 E8 06 F2 0F 58 25 ?? ?? ?? ?? F2 41 0F 59 E3 41 81 C0 FF 03 00 00 41 FF C8 F2 0F 58 25 ?? ?? ?? ?? F2 41 0F 59 E3 41 81 E0 FF 07 00 00 41 81 F8 FE 07 00 00 F2 0F 58 25 ?? ?? ?? ?? F2 41 0F 59 E3 F2 41 0F 59 E3 F2 41 0F 58 E3 F2 0F 59 E1 F2 41 0F 58 24 CB F2 0F 58 CC 77 2F 49 C1 E9 30 41 C1 E0 04 41 81 E1 0F 80 FF FF 45 0B C8 66 44 89 4C 24 46 F2 0F 10 44 24 40 F2 0F 59 C1 F2 0F 5A C0 F3 0F 11 02 E9 5F 02 00 00 41 FF C8 41 81 E0 FF 07 00 00 0F B7 4C 24 46 41 C1 E0 04 81 E1 0F 80 FF FF 41 0B C8 66 89 4C 24 46 F2 0F 10 44 24 40 F2 0F 59 C8 F2 0F 59 0D ?? ?? ?? ?? F2 0F 5A C9 F3 0F 11 0A E9 1F 02 00 00 F2 0F 10 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? F2 41 0F 59 CB 44 0F B7 4C 24 46 41 81 E1 0F 80 FF FF F2 0F 58 0D ?? ?? ?? ?? F2 0F 11 4C 24 20 F2 0F 10 7C 24 20 44 8B 5C 24 20 45 8B D3 41 C1 EA 06 41 83 E3 3F 41 81 C2 FF 03 00 00 F2 0F 5C 3D ?? ?? ?? ?? F2 0F 11 7C 24 28 41 81 E2 FF 07 00 00 F2 44 0F 10 44 24 28 F2 44 0F 59 05 ?? ?? ?? ?? F2 0F 10 64 24 28 41 8D 4A FF F2 0F 59 25 ?? ?? ?? ?? F2 45 0F 5C D8 F2 44 0F 10 05 ?? ?? ?? ?? 81 E1 FF 07 00 00 C1 E1 04 41 F7 DA 44 0B C9 43 8D 0C 1B 41 83 C2 FC 41 81 E2 FF 07 00 00 F2 44 0F 5C DC 41 0F 28 EB F2 41 0F 59 EB F2 44 0F 59 C5 F2 41 0F 10 24 C8 F7 D9 F2 0F 10 3D ?? ?? ?? ?? 47 8D 44 1B 01 66 44 89 4C 24 46 41 81 E1 0F 80 FF FF 41 C1 E2 04 4C 8D 1D ?? ?? ?? ?? F2 0F 59 FD F2 44 0F 58 05 ?? ?? ?? ?? F2 44 0F 59 C5 45 0B CA F2 0F 58 3D ?? ?? ?? ?? F2 44 0F 58 05 ?? ?? ?? ?? F2 0F 59 FD F2 44 0F 59 C5 F2 41 0F 59 FB F2 0F 10 4C 24 40 4D 8B D3 66 44 89 4C 24 46 44 8D 89 80 00 00 00 81 C1 81 00 00 00 F2 0F 10 44 24 40 F2 43 0F 10 2C C3 4D 8B C3 F2 0F 59 E1 F2 0F 59 E9 F2 43 0F 10 14 CA 0F 28 CC F2 0F 59 D0 F2 41 0F 10 1C C8 F2 0F 58 CA F2 0F 59 D8 F2 0F 11 4C 24 30 0F 28 CC F2 0F 10 44 24 30 F2 0F 5C E2 F2 0F 5C C8 F2 0F 59 FC F2 0F 58 CA 0F 28 D5 F2 0F 11 4C 24 38 F2 0F 5C D3 F2 41 0F 59 D3 F2 44 0F 59 DC F2 0F 58 D3 F2 0F 10 4C 24 30 F2 0F 58 D5 F2 44 0F 59 C1 F2 0F 10 44 24 38 F2 0F 58 D0 F2 0F 58 D7 F2 41 0F 58 D0 F2 41 0F 58 D3 F2 0F 11 54 24 30 F2 44 0F 10 5C 24 30 F2 41 0F 58 CB F2 0F 5A C9 F3 0F 11 0A EB 31 F2 0F 10 05 ?? ?? ?? ?? B8 03 00 00 00 F2 0F 59 C0 F2 0F 5A C0 F3 0F 11 02 EB 16 F2 0F 10 05 ?? ?? ?? ?? F2 0F 58 44 24 40 F2 0F 5A C0 F3 0F 11 02 0F 28 7C 24 60 44 0F 28 44 24 50 44 0F 28 5C 24 70 48 81 C4 88 00 00 00 C3 F3 0F 10 01 F3 0F 59 C0 F3 0F 11 02 EB D9 90 }
	condition:
		$1
}

rule file_79_0_0 {
	meta:
		name = "__sse2_cosf4"
		size = 2240
		refs = "001d flAbsMask 0024 MMSPIo2 002f MMSINVPI 003c MMIHUGE 0049 MMSPI1 0054 MMSPI2 006d MMSPI4 0077 MMS05 007e MMSPI3 0099 MMSA9 00a9 MMSA5 00b0 MMSA3 00c3 MMSA7 010c flTwoPow30 012d flAllOnes 01b0 dbInvPio2 01c5 dbiOne 01cd dbRS 01ea PI02C_0 01f6 PI02C_1 0206 PI02C_2 0237 PI02C_3 0263 PI02C_4 0273 dbSignMask 0741 __spec_table"
	strings:
		$1 = { 48 81 EC 18 01 00 00 0F 29 BC 24 F0 00 00 00 0F 29 B4 24 00 01 00 00 0F 28 F0 0F 28 0D ?? ?? ?? ?? 0F 28 1D ?? ?? ?? ?? 66 0F DB C1 0F 28 25 ?? ?? ?? ?? 0F 28 D0 0F 28 F8 0F 28 2D ?? ?? ?? ?? 0F 58 C3 0F 59 C4 0F 28 25 ?? ?? ?? ?? 66 0F 66 FD 0F 28 2D ?? ?? ?? ?? 0F 50 C7 0B C0 0F 85 95 00 00 00 66 0F 5B C0 0F 28 D8 0F 28 3D ?? ?? ?? ?? 0F 5B C0 0F 28 0D ?? ?? ?? ?? 0F 28 35 ?? ?? ?? ?? 0F 5C C1 66 0F 72 F3 1F 0F 59 E0 0F 59 E8 0F 59 F0 0F 59 F8 0F 28 05 ?? ?? ?? ?? 0F 5C D4 0F 5C D5 0F 5C D6 0F 28 2D ?? ?? ?? ?? 0F 28 35 ?? ?? ?? ?? 0F 28 CA 0F 5C CF 0F 59 D2 0F 59 C2 0F 58 05 ?? ?? ?? ?? 0F 59 C2 0F 58 C5 0F 59 C2 0F 58 C6 0F 59 C2 0F 59 C1 0F 58 C1 66 0F EF C3 0F 28 B4 24 00 01 00 00 0F 28 BC 24 F0 00 00 00 48 81 C4 18 01 00 00 C3 66 0F DB 35 ?? ?? ?? ?? 0F 28 CE 0F 29 74 24 40 66 0F 66 35 ?? ?? ?? ?? 0F 50 D6 85 D2 0F 85 52 05 00 00 83 F8 0F 0F 84 F2 02 00 00 0F 29 7C 24 50 66 0F EF 3D ?? ?? ?? ?? 0F 29 7C 24 60 66 0F 5B C0 0F 28 D8 0F 28 3D ?? ?? ?? ?? 0F 5B C0 0F 28 0D ?? ?? ?? ?? 0F 28 35 ?? ?? ?? ?? 0F 5C C1 66 0F 72 F3 1F 0F 59 E0 0F 59 E8 0F 59 F0 0F 59 F8 0F 5C D4 0F 5C D5 0F 5C D6 0F 28 CA 0F 5C CF 0F 59 D2 66 0F DB 5C 24 60 66 0F DB 4C 24 60 66 0F DB 54 24 60 0F 29 5C 24 70 0F 29 8C 24 80 00 00 00 0F 29 94 24 90 00 00 00 0F 5A 4C 24 40 0F 5A 44 24 48 66 0F 28 1D ?? ?? ?? ?? 66 0F 59 D9 66 0F E6 DB 66 0F 70 DB DC 66 0F EB 1D ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 56 D3 66 0F 5C 15 ?? ?? ?? ?? 66 0F 29 84 24 A0 00 00 00 66 0F 28 05 ?? ?? ?? ?? 66 0F 59 C2 66 0F 28 25 ?? ?? ?? ?? 66 0F 59 E2 66 0F 5C C8 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 EA 66 0F 28 C1 66 0F 5C CC 66 0F 5C C1 66 0F 28 F1 66 0F 5C C4 66 0F 5C CD 66 0F 73 F3 3E 66 0F 5C F1 66 0F 28 F9 66 0F 28 25 ?? ?? ?? ?? 66 0F 5C F5 66 0F 58 C6 66 0F 58 C8 66 0F 59 E2 66 0F 5C F9 66 0F 28 E9 66 0F 5C CC 66 0F 58 C7 66 0F 5C E9 66 0F 59 15 ?? ?? ?? ?? 66 0F 5C EC 66 0F 58 C5 66 0F 28 2D ?? ?? ?? ?? 66 0F 5C C2 66 0F DB EB 66 0F 28 9C 24 A0 00 00 00 66 0F 59 1D ?? ?? ?? ?? 66 0F E6 DB 66 0F 58 C1 66 0F 28 8C 24 A0 00 00 00 66 0F EF 2D ?? ?? ?? ?? 66 0F 70 ED DD 66 0F 70 DB DC 66 0F EB 1D ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 56 D3 66 0F 29 84 24 B0 00 00 00 66 0F 5C 15 ?? ?? ?? ?? 66 0F 28 05 ?? ?? ?? ?? 66 0F 59 C2 66 0F 28 25 ?? ?? ?? ?? 66 0F 59 E2 66 0F D6 AC 24 C0 00 00 00 66 0F 5C C8 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 EA 66 0F 28 C1 66 0F 5C CC 66 0F 5C C1 66 0F 28 F1 66 0F 5C C4 66 0F 5C CD 66 0F 73 F3 3E 66 0F 5C F1 66 0F 28 F9 66 0F 28 25 ?? ?? ?? ?? 66 0F 5C F5 66 0F 58 C6 66 0F 58 C8 66 0F 59 E2 66 0F 5C F9 66 0F 28 E9 66 0F 5C CC 66 0F 58 C7 66 0F 5C E9 66 0F 59 15 ?? ?? ?? ?? 66 0F 5C EC 66 0F 58 C5 66 0F 28 2D ?? ?? ?? ?? 66 0F 5C C2 66 0F DB EB 66 0F 58 C8 66 0F EF 2D ?? ?? ?? ?? 66 0F 5A 94 24 B0 00 00 00 66 0F 70 ED DD 66 0F 5A D9 66 0F 14 D3 F3 0F 7E 9C 24 C0 00 00 00 66 0F 14 DD 0F 28 05 ?? ?? ?? ?? 0F 28 2D ?? ?? ?? ?? 0F 28 35 ?? ?? ?? ?? 0F 28 CA 0F 59 D2 66 0F DB 5C 24 50 66 0F DB 4C 24 50 66 0F DB 54 24 50 66 0F EB 5C 24 70 66 0F EB 8C 24 80 00 00 00 66 0F EB 94 24 90 00 00 00 0F 59 C2 0F 58 05 ?? ?? ?? ?? 0F 59 C2 0F 58 C5 0F 59 C2 0F 58 C6 0F 59 C2 0F 59 C1 0F 58 C1 66 0F EF C3 E9 0B 03 00 00 66 0F 70 C1 EE 0F 5A C9 0F 5A C0 66 0F 28 1D ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 59 D9 66 0F 59 F0 66 0F E6 DB 66 0F E6 F6 66 0F 70 DB DC 66 0F 70 F6 DC 66 0F EB 1D ?? ?? ?? ?? 66 0F EB 35 ?? ?? ?? ?? 66 0F 29 B4 24 D0 00 00 00 66 0F 28 15 ?? ?? ?? ?? 66 0F 56 D3 66 0F 5C 15 ?? ?? ?? ?? 66 0F 29 84 24 A0 00 00 00 66 0F 28 05 ?? ?? ?? ?? 66 0F 59 C2 66 0F 28 25 ?? ?? ?? ?? 66 0F 59 E2 66 0F 5C C8 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 EA 66 0F 28 C1 66 0F 5C CC 66 0F 5C C1 66 0F 28 F1 66 0F 5C C4 66 0F 5C CD 66 0F 73 F3 3E 66 0F 5C F1 66 0F 28 F9 66 0F 28 25 ?? ?? ?? ?? 66 0F 5C F5 66 0F 58 C6 66 0F 58 C8 66 0F 59 E2 66 0F 5C F9 66 0F 28 E9 66 0F 5C CC 66 0F 58 C7 66 0F 5C E9 66 0F 59 15 ?? ?? ?? ?? 66 0F 5C EC 66 0F 58 C5 66 0F 28 2D ?? ?? ?? ?? 66 0F 5C C2 66 0F DB EB 66 0F 58 C1 66 0F 28 8C 24 A0 00 00 00 66 0F EF 2D ?? ?? ?? ?? 66 0F 70 ED DD 66 0F 28 9C 24 D0 00 00 00 66 0F 28 15 ?? ?? ?? ?? 66 0F 56 94 24 D0 00 00 00 66 0F 29 84 24 B0 00 00 00 66 0F 5C 15 ?? ?? ?? ?? 66 0F 28 05 ?? ?? ?? ?? 66 0F 59 C2 66 0F 28 25 ?? ?? ?? ?? 66 0F 59 E2 66 0F D6 AC 24 C0 00 00 00 66 0F 5C C8 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 EA 66 0F 28 C1 66 0F 5C CC 66 0F 5C C1 66 0F 28 F1 66 0F 5C C4 66 0F 5C CD 66 0F 73 F3 3E 66 0F 5C F1 66 0F 28 F9 66 0F 28 25 ?? ?? ?? ?? 66 0F 5C F5 66 0F 58 C6 66 0F 58 C8 66 0F 59 E2 66 0F 5C F9 66 0F 28 E9 66 0F 5C CC 66 0F 58 C7 66 0F 5C E9 66 0F 59 15 ?? ?? ?? ?? 66 0F 5C EC 66 0F 58 C5 66 0F 28 2D ?? ?? ?? ?? 66 0F 5C C2 66 0F 5A 94 24 B0 00 00 00 66 0F DB EB 66 0F 58 C8 66 0F 5A D9 66 0F EF 2D ?? ?? ?? ?? 66 0F 14 D3 0F 28 05 ?? ?? ?? ?? 0F 28 CA 0F 59 D2 0F 59 C2 0F 58 05 ?? ?? ?? ?? 0F 59 C2 0F 58 05 ?? ?? ?? ?? 0F 59 C2 0F 58 05 ?? ?? ?? ?? 66 0F 70 ED DD 0F 59 C2 F3 0F 7E 9C 24 C0 00 00 00 0F 59 C1 66 0F 14 DD 0F 58 C1 66 0F EF C3 E9 B4 00 00 00 83 F8 0F 0F 84 85 00 00 00 66 0F 5B C0 0F 28 D8 0F 28 3D ?? ?? ?? ?? 0F 5B C0 0F 28 0D ?? ?? ?? ?? 0F 28 35 ?? ?? ?? ?? 0F 5C C1 66 0F 72 F3 1F 0F 59 E0 0F 59 E8 0F 59 F0 0F 59 F8 0F 5C D4 0F 5C D5 0F 5C D6 0F 28 CA 0F 5C CF 0F 59 D2 0F 28 05 ?? ?? ?? ?? 0F 28 2D ?? ?? ?? ?? 0F 28 35 ?? ?? ?? ?? 0F 59 C2 0F 58 05 ?? ?? ?? ?? 0F 59 C2 0F 58 C5 0F 59 C2 0F 58 C6 0F 59 C2 0F 59 C1 0F 58 C1 66 0F EF C3 0F 29 84 24 E0 00 00 00 89 44 24 20 8B 44 24 20 45 33 C9 A8 01 75 2F 49 FF C1 D1 F8 89 44 24 20 49 83 F9 04 7C ED 0F 28 84 24 E0 00 00 00 0F 28 B4 24 00 01 00 00 0F 28 BC 24 F0 00 00 00 48 81 C4 18 01 00 00 C3 42 8B 44 8C 40 48 8D 15 ?? ?? ?? ?? 89 44 24 28 48 89 54 24 30 F3 0F 10 44 24 28 4C 8B 44 24 30 0F 28 C8 66 0F 7E C1 0F 5A C9 F2 41 0F 10 90 10 05 00 00 81 E1 FF FF FF 7F 66 0F 7E C0 25 00 00 80 7F 3D 00 00 80 7F 0F 84 0E 01 00 00 C1 E9 17 81 E9 8E 00 00 00 81 E1 F8 FF 00 00 F2 41 0F 10 9C 48 10 04 00 00 F2 41 0F 10 AC 48 18 04 00 00 F2 41 0F 10 90 50 05 00 00 66 0F 57 E4 B8 38 43 00 00 66 0F C4 E0 03 66 0F 54 D3 66 0F 73 F3 28 F2 0F 59 D1 F2 0F 59 D9 F2 0F 59 CD F2 0F 10 C2 F2 0F 58 D3 F2 0F 10 EA F2 0F 5C C2 F2 0F 58 D4 F2 0F 58 D8 66 0F 7E D1 F2 0F 5C D4 F2 0F 58 CB B8 80 01 00 00 F2 41 0F 10 A0 40 05 00 00 F2 0F 5C EA 03 C9 8B D1 C1 E1 18 C1 F9 1F 23 C2 03 D1 33 D1 F2 0F 58 CD 81 E2 FE 00 00 00 F2 41 0F 10 1C D0 F2 41 0F 10 80 48 05 00 00 66 0F 70 D1 44 F2 0F 59 C9 F2 41 0F 10 6C D0 08 8B C8 81 E1 00 01 00 00 C1 E1 17 F2 0F 59 DA 66 0F 6E D1 F2 0F 5C C1 05 80 00 00 00 25 00 01 00 00 C1 E0 17 F2 0F 5C E1 66 0F 73 F2 20 66 0F 6E C8 66 0F 57 E2 F2 0F 59 C5 F2 0F 59 DC 66 0F 73 F1 20 66 0F 57 C1 F2 0F 58 C3 66 0F 5A C0 EB 04 F3 0F 5C C0 F3 0F 11 44 24 24 8B 44 24 24 42 89 84 8C E0 00 00 00 8B 44 24 20 E9 57 FE FF FF 66 66 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_86_0_0 {
	meta:
		name = "__GSHandlerCheck_SEH"
		size = 189
		refs = "0050 __GSHandlerCheckCommon 00a2 __C_specific_handler"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 48 8B 44 24 68 48 8B 40 38 48 89 44 24 30 48 8B 44 24 30 8B 00 48 6B C0 10 48 8B 4C 24 30 48 8D 44 01 04 48 89 44 24 38 4C 8B 44 24 38 48 8B 54 24 68 48 8B 4C 24 58 E8 ?? ?? ?? ?? 48 8B 44 24 38 8B 00 89 44 24 20 48 8B 44 24 50 8B 40 04 83 E0 66 85 C0 75 0D 8B 44 24 20 83 E0 01 89 44 24 24 EB 0B 8B 44 24 20 83 E0 02 89 44 24 24 83 7C 24 24 00 74 1F 4C 8B 4C 24 68 4C 8B 44 24 60 48 8B 54 24 58 48 8B 4C 24 50 E8 ?? ?? ?? ?? 89 44 24 28 EB 08 C7 44 24 28 01 00 00 00 8B 44 24 28 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_87_0_0 {
	meta:
		name = "??_L@YAXPEAX_K1P6AX0@Z2@Z"
		size = 161
		refs = "0051 _guard_check_icall 0098 ?__ArrayUnwind@@YAXPEAX_K1P6AX0@Z@Z"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 48 C7 44 24 28 00 00 00 00 C6 44 24 20 00 EB 0D 48 8B 44 24 28 48 FF C0 48 89 44 24 28 48 8B 44 24 60 48 39 44 24 28 74 34 48 8B 44 24 68 48 89 44 24 30 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 4C 24 50 FF 54 24 30 48 8B 44 24 58 48 8B 4C 24 50 48 03 C8 48 8B C1 48 89 44 24 50 EB B3 C6 44 24 20 01 0F B6 44 24 20 85 C0 75 19 4C 8B 4C 24 70 4C 8B 44 24 28 48 8B 54 24 58 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_88_0_0 {
	meta:
		name = "__common_scos_cout_rare"
		size = 112
		altNames = "__common_ssin_cout_rare"
	strings:
		$1 = { 48 83 EC 28 44 8B 01 0F B7 41 02 44 89 44 24 20 25 80 7F 00 00 41 C1 E8 18 41 83 E0 7F F3 0F 10 09 3D 80 7F 00 00 75 34 44 88 44 24 23 81 7C 24 20 00 00 80 7F 75 16 B8 01 00 00 00 66 0F EF C0 F3 0F 59 C8 F3 0F 11 0A 48 83 C4 28 C3 F3 0F 59 C9 33 C0 F3 0F 11 0A 48 83 C4 28 C3 33 C0 48 83 C4 28 C3 66 66 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_89_0_0 {
	meta:
		name = "__sse4_ceil2"
		size = 16
	strings:
		$1 = { 66 0F 3A 09 C0 02 C3 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_90_0_0 {
	meta:
		name = "__avx_acos4"
		size = 672
		refs = "0048 __common_dacos_data 0296 __common_dacos_cout_rare"
	strings:
		$1 = { 48 81 EC 18 02 00 00 C5 7C 11 BC 24 D0 01 00 00 C5 7C 11 B4 24 90 01 00 00 C5 7C 11 84 24 70 01 00 00 C5 FC 11 BC 24 B0 01 00 00 C5 FC 11 B4 24 F0 01 00 00 4C 89 AC 24 10 02 00 00 4C 8D AC 24 0F 01 00 00 C5 7D 10 35 ?? ?? ?? ?? 49 83 E5 C0 C5 FD 10 2D ?? ?? ?? ?? C5 8D 56 F8 C5 45 59 FD C5 45 59 C7 C5 C5 C2 25 ?? ?? ?? ?? 12 C5 85 58 ED C5 FD 5A D5 C5 3D 5D C5 C5 F8 52 F2 C5 3D C2 FD 15 C5 D5 58 ED C5 0D 54 F0 C4 E3 7D 19 E1 01 C5 D8 C6 D9 DD C5 FC 5A E6 C5 F8 50 D3 C5 DD 59 CC C5 D5 59 F4 C5 D5 59 D9 C5 E5 5C 25 ?? ?? ?? ?? C5 DD 59 15 ?? ?? ?? ?? C5 CD 59 EC C5 ED 58 0D ?? ?? ?? ?? C5 F5 59 DC C5 BD 59 0D ?? ?? ?? ?? C5 E5 58 15 ?? ?? ?? ?? C5 F5 58 1D ?? ?? ?? ?? C5 ED 59 E4 C5 BD 59 15 ?? ?? ?? ?? C5 DD 58 25 ?? ?? ?? ?? C5 ED 58 0D ?? ?? ?? ?? C5 BD 59 15 ?? ?? ?? ?? C5 DD 59 ED C4 C1 3D 59 E0 C5 ED 58 15 ?? ?? ?? ?? C5 CD 5C ED C5 BD 59 35 ?? ?? ?? ?? C4 E3 45 4B FD F0 C5 CD 58 35 ?? ?? ?? ?? C5 CD 59 F4 C5 CD 58 DB C5 F5 59 F4 C5 CD 58 CA C5 DD 59 D4 C5 BD 59 35 ?? ?? ?? ?? C5 E5 59 DA C5 CD 58 35 ?? ?? ?? ?? C5 E5 58 C9 C5 F5 59 D4 C5 ED 58 DE C5 BD 59 35 ?? ?? ?? ?? C5 E5 59 E4 C5 CD 58 35 ?? ?? ?? ?? C5 DD 58 CE C4 C1 75 59 F0 C4 C1 7D C2 C8 11 C4 C1 45 57 EE C5 CD 59 F5 C5 05 54 05 ?? ?? ?? ?? C5 BD 54 D9 C5 85 55 15 ?? ?? ?? ?? C5 ED 58 E3 C5 CD 58 CD C5 DD 58 C9 85 D2 75 41 C5 FC 10 B4 24 F0 01 00 00 C5 FC 10 BC 24 B0 01 00 00 C5 7C 10 84 24 70 01 00 00 C5 7C 10 B4 24 90 01 00 00 C5 7C 10 BC 24 D0 01 00 00 4C 8B AC 24 10 02 00 00 C5 FD 28 C1 48 81 C4 18 02 00 00 C3 C4 C1 7D 11 45 00 C4 C1 7D 11 4D 40 74 B1 33 C0 C5 7C 11 8C 24 A0 00 00 00 C5 7C 11 94 24 80 00 00 00 C5 7C 11 5C 24 60 C5 7C 11 64 24 40 C5 7C 11 6C 24 20 48 89 9C 24 C8 00 00 00 8B D8 48 89 B4 24 C0 00 00 00 8B F2 0F A3 DE 72 46 FF C3 83 FB 20 7C F4 C5 7C 10 8C 24 A0 00 00 00 C5 7C 10 94 24 80 00 00 00 C5 7C 10 5C 24 60 C5 7C 10 64 24 40 C5 7C 10 6C 24 20 C4 C1 7D 10 4D 40 48 8B 9C 24 C8 00 00 00 48 8B B4 24 C0 00 00 00 E9 2C FF FF FF C5 F8 77 49 8D 4C DD 00 49 8D 54 DD 40 E8 ?? ?? ?? ?? EB A6 0F 1F 40 00 }
	condition:
		$1
}

rule file_91_0_0 {
	meta:
		name = "__common_sasin_cout_rare"
		size = 2784
		refs = "007b _vmldASinHATab"
	strings:
		$1 = { 55 48 81 EC D0 00 00 00 33 C0 44 0F B7 41 02 41 81 E0 80 7F 00 00 F3 0F 10 09 41 81 F8 80 7F 00 00 44 0F 29 BC 24 A0 00 00 00 44 0F 29 B4 24 B0 00 00 00 44 0F 29 AC 24 C0 00 00 00 44 0F 29 5C 24 60 44 0F 29 54 24 70 44 0F 29 8C 24 80 00 00 00 44 0F 29 84 24 90 00 00 00 0F 84 63 0A 00 00 F3 0F 5A C1 F2 0F 11 44 24 38 80 64 24 3F 7F F2 44 0F 10 54 24 38 F2 44 0F 10 2D ?? ?? ?? ?? 4C 8B 0D ?? ?? ?? ?? 66 45 0F 2F EA 0F 82 DF 09 00 00 F2 0F 10 05 ?? ?? ?? ?? 66 41 0F 2F C2 0F 86 27 04 00 00 66 44 0F 2F 15 ?? ?? ?? ?? 0F 86 85 03 00 00 F2 44 0F 10 35 ?? ?? ?? ?? 41 0F 28 E2 F2 41 0F 59 E6 45 0F 28 CA F2 0F 11 64 24 28 45 0F 28 DA F2 44 0F 10 6C 24 28 41 0F 28 DE F2 44 0F 5C 6C 24 38 F2 44 0F 11 6C 24 20 F2 44 0F 10 44 24 28 F2 0F 10 4C 24 20 F2 44 0F 5C C1 F2 44 0F 11 44 24 28 F2 0F 10 54 24 28 F2 44 0F 5C CA F2 44 0F 11 4C 24 20 F2 0F 10 6C 24 28 0F 28 D5 F2 44 0F 58 DD F2 0F 59 D5 F2 44 0F 10 7C 24 20 0F 28 C2 F2 45 0F 59 DF F2 0F 59 DA F2 41 0F 58 C3 F2 44 0F 10 0D ?? ?? ?? ?? F2 44 0F 59 C8 F2 0F 11 5C 24 28 F2 0F 10 64 24 28 F2 44 0F 58 0D ?? ?? ?? ?? F2 0F 5C E2 F2 44 0F 59 C8 F2 0F 11 64 24 20 F2 0F 10 4C 24 28 F2 44 0F 10 6C 24 20 F2 44 0F 58 0D ?? ?? ?? ?? F2 41 0F 5C CD F2 44 0F 59 C8 F2 0F 11 4C 24 28 F2 44 0F 10 44 24 28 F2 44 0F 58 0D ?? ?? ?? ?? F2 41 0F 5C D0 F2 44 0F 59 C8 F2 0F 11 54 24 20 45 0F 28 C2 F2 0F 10 64 24 28 F2 0F 10 5C 24 20 F2 44 0F 59 FC F2 44 0F 58 0D ?? ?? ?? ?? F2 44 0F 58 DB F2 0F 59 EC F2 44 0F 59 C8 F2 45 0F 59 C3 F2 44 0F 58 0D ?? ?? ?? ?? F2 45 0F 58 C7 F2 44 0F 59 C8 45 0F 28 FE F2 44 0F 58 0D ?? ?? ?? ?? F2 44 0F 59 FD F2 44 0F 59 C8 F2 44 0F 11 7C 24 28 F2 44 0F 10 6C 24 28 F2 44 0F 5C ED F2 44 0F 58 0D ?? ?? ?? ?? F2 44 0F 11 6C 24 20 44 0F 28 ED F2 0F 10 54 24 28 F2 41 0F 58 E8 F2 44 0F 59 C8 F2 44 0F 59 DD F2 44 0F 58 0D ?? ?? ?? ?? F2 0F 10 4C 24 20 F2 44 0F 59 C8 F2 0F 5C D1 F2 0F 11 54 24 28 F2 0F 10 5C 24 28 F2 44 0F 5C EB 0F 28 DC F2 44 0F 58 0D ?? ?? ?? ?? F2 44 0F 11 6C 24 20 F2 0F 10 4C 24 28 F2 0F 10 54 24 20 44 0F 28 FA F2 0F 59 D9 F2 45 0F 58 F8 F2 44 0F 59 C8 F2 41 0F 59 E7 F2 44 0F 59 F3 F2 44 0F 58 0D ?? ?? ?? ?? F2 41 0F 58 E3 F2 44 0F 59 C8 F2 44 0F 11 74 24 28 44 0F 28 EB F2 44 0F 10 5C 24 28 F2 44 0F 5C DB F2 0F 58 DC F2 44 0F 58 0D ?? ?? ?? ?? F2 0F 59 C3 F2 44 0F 11 5C 24 20 F2 44 0F 10 5C 24 28 F2 44 0F 10 74 24 20 F2 44 0F 59 C8 F2 45 0F 5C DE F2 44 0F 11 5C 24 28 F2 44 0F 10 1D ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? F2 44 0F 59 DD F2 0F 59 C3 F2 0F 10 2D ?? ?? ?? ?? F2 44 0F 58 D8 F2 0F 59 CD F2 44 0F 59 C5 F2 0F 59 D5 F2 45 0F 58 D9 F2 44 0F 10 74 24 28 41 0F 28 C2 F2 45 0F 5C EE F2 0F 58 C1 F2 45 0F 58 D8 F2 44 0F 11 6C 24 20 F2 44 0F 58 DA F2 44 0F 10 74 24 28 F2 44 0F 10 6C 24 20 F2 0F 11 44 24 28 F2 0F 10 54 24 28 F2 0F 10 05 ?? ?? ?? ?? F2 44 0F 5C D2 F2 0F 59 E0 F2 44 0F 59 F0 F2 41 0F 59 C5 F2 44 0F 58 D1 F2 44 0F 11 54 24 20 F2 0F 10 4C 24 28 F2 44 0F 10 54 24 20 F2 45 0F 58 DA F2 44 0F 58 DC 0F 28 E1 F2 41 0F 58 E6 F2 44 0F 58 D8 F2 0F 11 64 24 28 F2 44 0F 10 54 24 28 F2 41 0F 5C CA F2 41 0F 58 CE F2 0F 11 4C 24 20 F2 0F 10 5C 24 28 F2 0F 10 54 24 20 8A 49 03 F2 44 0F 58 DA 80 E1 80 F2 44 0F 58 DB F2 44 0F 11 5C 24 30 40 8A 6C 24 37 40 80 E5 7F 40 0A E9 40 88 6C 24 37 F2 0F 5A 6C 24 30 F3 0F 11 2A E9 49 06 00 00 66 44 0F 2F 15 ?? ?? ?? ?? 72 44 F2 45 0F 58 D5 F2 44 0F 11 54 24 28 F2 0F 10 44 24 28 F2 0F 59 44 24 38 F2 0F 11 44 24 30 40 8A 6C 24 37 8A 49 03 40 80 E5 7F 80 E1 80 40 0A E9 40 88 6C 24 37 F2 0F 5A 4C 24 30 F3 0F 11 0A E9 FA 05 00 00 F2 45 0F 59 D2 F2 44 0F 11 54 24 28 F2 0F 10 44 24 28 8A 49 03 80 E1 80 F2 0F 58 44 24 38 F2 0F 11 44 24 30 40 8A 6C 24 37 40 80 E5 7F 40 0A E9 40 88 6C 24 37 F2 0F 5A 4C 24 30 F3 0F 11 0A E9 B6 05 00 00 4D 8B D1 F2 45 0F 5C EA F2 41 0F 59 C5 F2 0F 11 44 24 38 44 0F B7 44 24 3E 41 81 E0 F0 7F 00 00 41 C1 E8 04 41 81 C0 01 FC FF FF 45 8B D8 41 8B E8 41 F7 DB 41 81 C3 FF 03 00 00 49 C1 EA 30 41 81 E3 FF 07 00 00 41 C1 E3 04 41 81 E2 0F 80 FF FF 4C 89 4C 24 40 45 0B D3 66 44 89 54 24 46 83 E5 01 F2 44 0F 10 44 24 40 44 8B DD F2 41 0F 59 C0 0F 28 E8 F2 0F 10 15 ?? ?? ?? ?? F2 0F 58 E8 F2 44 0F 10 15 ?? ?? ?? ?? 75 03 0F 28 E8 F2 44 0F 59 D5 F2 0F 58 C2 F2 0F 11 44 24 48 45 0F 28 CA 44 8B 54 24 48 44 2B C5 41 C1 E3 08 41 81 E2 FF 01 00 00 45 03 D3 F2 44 0F 5C CD 4C 8D 1D ?? ?? ?? ?? F2 44 0F 11 4C 24 20 44 0F 28 CD F2 0F 10 5C 24 20 F2 44 0F 10 05 ?? ?? ?? ?? F2 44 0F 5C D3 F2 43 0F 10 04 D3 41 0F 28 CA 0F 28 E0 F2 45 0F 5C CA F2 0F 59 E0 F2 44 0F 59 D0 F2 0F 59 CC F2 41 0F 59 E1 F2 0F 5C 0D ?? ?? ?? ?? 41 D1 E8 F2 0F 58 CC F2 44 0F 59 C1 41 81 C0 FF 03 00 00 4C 89 4C 24 50 41 81 E0 FF 07 00 00 49 C1 E9 30 F2 44 0F 58 05 ?? ?? ?? ?? F2 44 0F 59 C1 41 81 E1 0F 80 FF FF 41 C1 E0 04 F2 44 0F 58 05 ?? ?? ?? ?? F2 44 0F 59 C1 45 0B C8 66 44 89 4C 24 56 F2 0F 10 5C 24 50 F2 44 0F 59 D3 F2 44 0F 58 05 ?? ?? ?? ?? F2 44 0F 59 C1 F2 44 0F 10 35 ?? ?? ?? ?? F2 44 0F 58 05 ?? ?? ?? ?? F2 44 0F 58 35 ?? ?? ?? ?? F2 44 0F 59 C1 F2 45 0F 59 F5 F2 44 0F 58 05 ?? ?? ?? ?? F2 44 0F 59 C1 F2 44 0F 58 05 ?? ?? ?? ?? F2 44 0F 59 C1 F2 0F 10 0D ?? ?? ?? ?? F2 44 0F 59 C0 F2 41 0F 59 C1 F2 44 0F 59 C5 44 0F 28 C9 F2 44 0F 58 C0 F2 45 0F 59 CA F2 44 0F 59 C3 F2 44 0F 11 4C 24 28 F2 44 0F 10 0D ?? ?? ?? ?? F2 45 0F 59 CD F2 0F 10 54 24 28 F2 0F 10 1D ?? ?? ?? ?? F2 41 0F 5C D2 F2 44 0F 58 0D ?? ?? ?? ?? F2 45 0F 59 CD F2 0F 11 54 24 20 0F 28 D3 F2 0F 10 6C 24 28 F2 0F 10 64 24 20 F2 0F 10 05 ?? ?? ?? ?? F2 0F 5C EC F2 44 0F 58 0D ?? ?? ?? ?? F2 0F 58 15 ?? ?? ?? ?? F2 45 0F 59 CD F2 41 0F 58 D6 F2 44 0F 58 0D ?? ?? ?? ?? F2 41 0F 59 D5 F2 45 0F 59 CD F2 0F 11 6C 24 28 0F 28 E9 F2 44 0F 10 5C 24 28 0F 28 E0 F2 41 0F 59 ED F2 44 0F 58 0D ?? ?? ?? ?? F2 45 0F 5C D3 F2 0F 58 25 ?? ?? ?? ?? F2 45 0F 59 CD F2 0F 58 E2 F2 44 0F 58 0D ?? ?? ?? ?? F2 45 0F 59 CD F2 44 0F 11 54 24 20 F2 44 0F 10 54 24 28 F2 44 0F 10 7C 24 20 F2 0F 11 6C 24 28 F2 45 0F 58 C7 F2 44 0F 58 0D ?? ?? ?? ?? F2 45 0F 59 CD F2 44 0F 10 5C 24 28 F2 44 0F 58 0D ?? ?? ?? ?? F2 45 0F 5C DD F2 45 0F 59 CD F2 44 0F 11 5C 24 20 44 0F 28 D9 F2 0F 10 54 24 28 F2 44 0F 10 7C 24 20 F2 44 0F 58 0D ?? ?? ?? ?? F2 41 0F 5C D7 F2 45 0F 59 CD F2 0F 11 54 24 28 F2 44 0F 10 74 24 28 F2 44 0F 58 0D ?? ?? ?? ?? F2 45 0F 59 CD F2 44 0F 58 0D ?? ?? ?? ?? F2 45 0F 59 CD F2 44 0F 58 0D ?? ?? ?? ?? F2 45 0F 59 CD F2 45 0F 59 CD F2 45 0F 59 CD F2 41 0F 58 E1 F2 44 0F 59 C4 41 0F 28 E5 F2 41 0F 5C E6 F2 0F 11 64 24 20 F2 44 0F 10 74 24 28 41 0F 28 EE 41 0F 28 E6 F2 41 0F 59 EE F2 41 0F 58 E5 F2 44 0F 59 F3 F2 44 0F 59 DD F2 0F 10 54 24 20 F2 44 0F 11 5C 24 28 F2 44 0F 10 7C 24 28 F2 0F 59 E2 F2 44 0F 5C FD F2 0F 59 DA F2 44 0F 11 7C 24 20 F2 44 0F 10 7C 24 28 F2 44 0F 10 5C 24 20 F2 0F 10 15 ?? ?? ?? ?? F2 45 0F 5C FB F2 41 0F 59 D5 F2 44 0F 11 7C 24 28 45 0F 28 FE F2 44 0F 10 5C 24 28 F2 41 0F 5C EB F2 0F 58 15 ?? ?? ?? ?? F2 0F 11 6C 24 20 F2 44 0F 10 5C 24 28 F2 44 0F 59 1D ?? ?? ?? ?? F2 41 0F 59 D5 F2 45 0F 58 FB F2 0F 58 15 ?? ?? ?? ?? F2 0F 10 6C 24 20 F2 41 0F 58 D1 F2 0F 58 EC F2 41 0F 59 D2 F2 0F 59 2D ?? ?? ?? ?? F2 44 0F 11 7C 24 28 F2 44 0F 10 7C 24 28 F2 44 0F 11 5C 24 48 F2 45 0F 5C F7 F2 45 0F 58 F3 F2 44 0F 11 74 24 20 44 0F 28 F0 F2 44 0F 10 7C 24 28 F2 44 0F 10 5C 24 20 F2 45 0F 58 F7 F2 44 0F 11 74 24 28 F2 44 0F 10 74 24 28 F2 41 0F 5C C6 F2 41 0F 58 C7 F2 0F 11 44 24 20 F2 44 0F 10 74 24 28 F2 41 0F 59 CE F2 44 0F 10 7C 24 20 F2 0F 11 4C 24 28 F2 0F 10 4C 24 28 F2 41 0F 5C CE F2 0F 11 4C 24 20 F2 0F 10 4C 24 28 F2 0F 10 44 24 20 F2 0F 5C C8 F2 0F 11 4C 24 28 F2 0F 10 44 24 28 F2 44 0F 5C F0 F2 44 0F 11 74 24 20 F2 0F 10 44 24 28 F2 44 0F 10 74 24 20 F2 45 0F 58 F3 F2 45 0F 58 F7 F2 44 0F 58 F3 F2 44 0F 58 F5 F2 45 0F 59 F2 F2 44 0F 59 D0 F2 45 0F 58 C6 F2 0F 10 05 ?? ?? ?? ?? F2 44 0F 58 C2 44 0F 28 E8 F2 0F 10 15 ?? ?? ?? ?? F2 45 0F 5C EA F2 41 0F 5C D0 F2 44 0F 11 6C 24 28 F2 44 0F 10 6C 24 28 F2 41 0F 5C C5 F2 41 0F 5C C2 F2 0F 11 44 24 20 F2 0F 10 5C 24 28 F2 0F 10 4C 24 20 8A 49 03 F2 0F 58 D1 80 E1 80 F2 0F 58 DA F2 0F 11 5C 24 30 40 8A 6C 24 37 40 80 E5 7F 40 0A E9 40 88 6C 24 37 F2 0F 5A 64 24 30 F3 0F 11 22 EB 11 B8 01 00 00 00 F3 0F 5C C9 F3 0F 5E C9 F3 0F 11 0A 44 0F 28 84 24 90 00 00 00 44 0F 28 8C 24 80 00 00 00 44 0F 28 54 24 70 44 0F 28 5C 24 60 44 0F 28 AC 24 C0 00 00 00 44 0F 28 B4 24 B0 00 00 00 44 0F 28 BC 24 A0 00 00 00 48 81 C4 D0 00 00 00 5D C3 F3 0F 5E C9 F3 0F 11 0A BA 01 00 00 00 33 C0 F7 01 FF FF 7F 00 0F 44 C2 EB A4 0F 1F 00 }
	condition:
		$1
}

rule file_93_0_0 {
	meta:
		name = "__avx_floor4"
		size = 16
	strings:
		$1 = { C4 E3 7D 09 C0 01 C3 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_96_0_0 {
	meta:
		name = "__sse2_atanf4"
		size = 192
		refs = "0007 s_dwAbsMask 000e s_fOne 002e s_dwSignMask 0035 s_fPi2 005d s_fA8 0064 s_fA7 0071 s_fA6 0078 s_fA5 0085 s_fA4 008c s_fA3 0099 s_fA2 00a0 s_fA1 00ad s_fA0"
	strings:
		$1 = { 0F 28 E8 66 0F DB 05 ?? ?? ?? ?? 0F 28 1D ?? ?? ?? ?? 0F 5F D8 0F 28 E0 0F 5D 05 ?? ?? ?? ?? 0F 5E C3 66 0F 66 25 ?? ?? ?? ?? 66 0F DB 2D ?? ?? ?? ?? 0F 28 15 ?? ?? ?? ?? 66 0F DB D4 66 0F DB 25 ?? ?? ?? ?? 66 0F EF D5 66 0F EF E5 66 0F EF E0 0F 59 C0 0F 28 D8 0F 59 C0 0F 28 2D ?? ?? ?? ?? 0F 28 0D ?? ?? ?? ?? 0F 59 E8 0F 59 C8 0F 58 2D ?? ?? ?? ?? 0F 58 0D ?? ?? ?? ?? 0F 59 E8 0F 59 C8 0F 58 2D ?? ?? ?? ?? 0F 58 0D ?? ?? ?? ?? 0F 59 E8 0F 59 C8 0F 58 2D ?? ?? ?? ?? 0F 58 0D ?? ?? ?? ?? 0F 59 C5 0F 59 CB 0F 58 05 ?? ?? ?? ?? 0F 58 C1 0F 59 C4 0F 58 C2 C3 0F 1F 44 00 00 }
	condition:
		$1
}

rule file_97_0_0 {
	meta:
		name = "__common_dlog_cout_rare"
		size = 704
		refs = "003e _imldLnHATab 0064 _2il0floatpacket_70 025c _2il0floatpacket_71"
	strings:
		$1 = { 48 83 EC 38 33 C0 44 0F B7 41 06 41 81 E0 F0 7F 00 00 41 81 F8 F0 7F 00 00 0F 84 4E 02 00 00 F2 0F 10 19 45 33 C0 48 8B 09 48 89 4C 24 30 48 C1 E9 30 F7 C1 F0 7F 00 00 75 14 F2 0F 59 1D ?? ?? ?? ?? 41 B8 C4 FF FF FF F2 0F 11 5C 24 30 F2 0F 10 05 ?? ?? ?? ?? 66 0F 2F D8 0F 86 D2 01 00 00 F2 0F 10 05 ?? ?? ?? ?? 0F 28 D3 F2 0F 5C D0 F2 0F 11 54 24 28 80 64 24 2F 7F F2 0F 10 4C 24 28 66 0F 2F 0D ?? ?? ?? ?? 0F 86 3F 01 00 00 F2 0F 11 5C 24 28 44 0F B7 4C 24 2E 41 81 E1 0F 80 FF FF 41 81 C9 F0 3F FF FF 66 44 89 4C 24 2E F2 0F 10 6C 24 28 0F 28 DD 0F B7 4C 24 36 81 E1 F0 7F 00 00 F2 0F 58 1D ?? ?? ?? ?? C1 E9 04 F2 0F 11 5C 24 20 0F 28 DD 44 8B 54 24 20 41 83 E2 7F F2 0F 58 1D ?? ?? ?? ?? F2 0F 11 5C 24 20 45 8D 84 08 01 FC FF FF F2 41 0F 2A C8 F2 0F 10 5C 24 20 47 8D 1C 52 48 8D 0D ?? ?? ?? ?? F2 0F 10 15 ?? ?? ?? ?? 4C 8B C9 F2 0F 10 25 ?? ?? ?? ?? 4C 8B C1 F2 0F 59 D1 F2 0F 5C 1D ?? ?? ?? ?? F2 0F 59 CC F2 0F 5C EB F2 43 0F 58 54 D8 08 F2 43 0F 58 4C D9 10 F2 42 0F 10 24 D9 F2 0F 59 DC F2 0F 59 E5 F2 0F 5C D8 0F 28 C3 F2 0F 58 DA F2 0F 58 C4 F2 0F 58 E1 F2 0F 10 2D ?? ?? ?? ?? F2 0F 59 E8 F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 E8 F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 E8 F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 E8 F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 E8 F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 E8 F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 E8 F2 0F 59 E8 F2 0F 58 E5 F2 0F 58 DC F2 0F 11 1A 48 83 C4 38 C3 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 C2 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C2 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C2 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C2 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C2 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C2 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C2 F2 0F 59 C2 F2 0F 58 D0 F2 0F 11 12 48 83 C4 38 C3 66 0F 2E D8 7A 02 74 12 F2 0F 5E C0 F2 0F 11 02 B8 01 00 00 00 48 83 C4 38 C3 F2 0F 10 0D ?? ?? ?? ?? B8 02 00 00 00 0F 57 0D ?? ?? ?? ?? F2 0F 5E C8 F2 0F 11 0A 48 83 C4 38 C3 44 8A 41 07 41 80 E0 80 41 80 F8 80 74 11 F2 0F 10 01 F2 0F 59 C0 F2 0F 11 02 48 83 C4 38 C3 F7 41 04 FF FF 0F 00 75 E6 83 39 00 75 E1 F2 0F 10 05 ?? ?? ?? ?? B8 01 00 00 00 F2 0F 5E C0 F2 0F 11 02 48 83 C4 38 C3 66 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_100_0_0 {
	meta:
		name = "_FindPESection"
		size = 164
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 63 40 3C 48 8B 4C 24 30 48 03 C8 48 8B C1 48 89 44 24 10 C7 04 24 00 00 00 00 48 8B 44 24 10 0F B7 40 14 48 8B 4C 24 10 48 8D 44 01 18 48 89 44 24 08 EB 16 8B 04 24 FF C0 89 04 24 48 8B 44 24 08 48 83 C0 28 48 89 44 24 08 48 8B 44 24 10 0F B7 40 06 39 04 24 73 31 48 8B 44 24 08 8B 40 0C 48 39 44 24 38 72 20 48 8B 44 24 08 8B 40 0C 48 8B 4C 24 08 03 41 08 8B C0 48 39 44 24 38 73 07 48 8B 44 24 08 EB 04 EB AB 33 C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_100_1_0 {
	meta:
		name = "_IsNonwritableInCurrentImage"
		size = 142
		refs = "000c __ImageBase 001b _ValidateImageBase 0047 _FindPESection"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 58 48 8D 05 ?? ?? ?? ?? 48 89 44 24 30 48 8B 4C 24 30 E8 ?? ?? ?? ?? 85 C0 75 04 33 C0 EB 62 48 8B 44 24 30 48 8B 4C 24 60 48 2B C8 48 8B C1 48 89 44 24 40 48 8B 54 24 40 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 89 44 24 38 48 83 7C 24 38 00 75 04 33 C0 EB 2D 48 8B 44 24 38 8B 40 24 25 00 00 00 80 85 C0 75 0A C7 44 24 20 01 00 00 00 EB 08 C7 44 24 20 00 00 00 00 8B 44 24 20 EB 04 33 C0 EB 00 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_100_2_0 {
	meta:
		name = "_IsNonwritableInCurrentImage$filt$0"
		size = 61
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 89 4D 48 48 8B 45 48 48 8B 00 8B 00 89 45 28 8B 45 28 3D 05 00 00 C0 75 09 C7 45 24 01 00 00 00 EB 07 C7 45 24 00 00 00 00 8B 45 24 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_100_3_0 {
	meta:
		name = "_ValidateImageBase"
		size = 119
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 89 04 24 48 8B 04 24 0F B7 00 3D 4D 5A 00 00 74 04 33 C0 EB 4E 48 8B 04 24 48 63 40 3C 48 8B 0C 24 48 03 C8 48 8B C1 48 89 44 24 08 48 8B 44 24 08 81 38 50 45 00 00 74 04 33 C0 EB 26 48 8B 44 24 08 48 83 C0 18 48 89 44 24 10 48 8B 44 24 10 0F B7 00 3D 0B 02 00 00 74 04 33 C0 EB 05 B8 01 00 00 00 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_102_0_0 {
	meta:
		name = "__avx_atan4"
		size = 656
		refs = "006c __common_datan_data"
	strings:
		$1 = { 55 48 81 EC 30 02 00 00 48 8D 6C 24 20 C5 7C 11 BD C0 00 00 00 C5 7C 11 B5 E0 00 00 00 C5 7C 11 AD 00 01 00 00 C5 7C 11 A5 20 01 00 00 C5 7C 11 9D 40 01 00 00 C5 7C 11 95 60 01 00 00 C5 7C 11 8D 80 01 00 00 C5 7C 11 85 A0 01 00 00 C5 FC 11 BD C0 01 00 00 C5 FC 11 B5 E0 01 00 00 4C 89 AD 00 02 00 00 4C 8D 6D 3F C5 FD 10 35 ?? ?? ?? ?? 49 83 E5 C0 C5 FD 10 25 ?? ?? ?? ?? C5 7D 10 35 ?? ?? ?? ?? C5 7D 10 3D ?? ?? ?? ?? C5 7D 10 2D ?? ?? ?? ?? C5 FD 54 1D ?? ?? ?? ?? C5 7D 54 C6 C5 E5 C2 C4 12 C5 DD 5D D3 C5 FD 55 0D ?? ?? ?? ?? C4 C1 75 57 E8 C5 E5 5F CC C5 FD 10 1D ?? ?? ?? ?? C4 C1 7D 11 6D 00 C5 FD 10 25 ?? ?? ?? ?? C5 FD 10 2D ?? ?? ?? ?? C5 6D 5E D1 C5 FD 10 0D ?? ?? ?? ?? C5 FD 10 15 ?? ?? ?? ?? C5 7D 10 25 ?? ?? ?? ?? C5 FD 55 FE C4 41 45 57 C8 C4 41 35 57 DA C4 41 7D 11 5D 20 C4 41 25 59 DB C5 FD 10 05 ?? ?? ?? ?? C5 FD 10 35 ?? ?? ?? ?? C5 FD 10 3D ?? ?? ?? ?? C4 41 7D 11 5D 40 C4 41 25 59 DB C5 7D 10 05 ?? ?? ?? ?? C5 7D 10 15 ?? ?? ?? ?? C4 41 7D 11 5D 60 C4 41 25 59 DB C5 7D 10 0D ?? ?? ?? ?? C4 41 0D 59 F3 C4 C1 65 59 DB C4 41 15 59 EB C4 41 0D 58 F7 C5 E5 58 DC C5 95 58 E5 C4 41 75 59 FB C4 C1 0D 59 EB C4 C1 65 59 DB C4 C1 5D 59 E3 C5 85 58 D2 C5 D5 58 E8 C5 E5 58 FF C4 41 5D 58 E8 C4 C1 6D 59 CB C4 C1 55 59 D3 C4 41 45 59 C3 C5 F5 58 C6 C4 41 6D 58 F1 C5 BD 58 15 ?? ?? ?? ?? C4 C1 7D 59 F3 C4 41 15 59 CB C4 C1 6D 59 DB C5 7C 10 AD 00 01 00 00 C4 41 4D 58 FA C5 B5 58 25 ?? ?? ?? ?? C5 E5 58 05 ?? ?? ?? ?? C4 C1 05 59 CB C4 41 0D 59 D3 C4 41 5D 59 DB C5 7C 10 B5 E0 00 00 00 C5 7C 10 BD C0 00 00 00 C5 F5 58 35 ?? ?? ?? ?? C5 AD 58 2D ?? ?? ?? ?? C4 C1 25 58 D4 C4 C1 7D 10 4D 40 C5 7C 10 95 60 01 00 00 C5 7C 10 9D 40 01 00 00 C5 55 59 E1 C5 CD 59 E9 C5 FC 10 B5 E0 01 00 00 C5 9D 58 D8 C5 D5 58 FA C5 7C 10 A5 20 01 00 00 C4 C1 65 59 65 60 C5 5D 58 C7 C5 FC 10 BD C0 01 00 00 C4 41 3D 59 4D 20 C5 7C 10 85 A0 01 00 00 C4 C1 35 58 45 00 C5 7C 10 8D 80 01 00 00 4C 8B AD 00 02 00 00 48 8D A5 10 02 00 00 5D C3 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_105_0_0 {
	meta:
		name = "__sse2_tanhf4"
		size = 272
		refs = "0011 s_fTh 0018 s_fRS 001f s_dwAbsMask 002d s_dwIndexMask 0058 s_fTen 0067 s_dwPosInf 0079 s_fOne 0097 s_fA2 00a1 s_fA0 00ac s_fA3 00b6 s_fA1"
	strings:
		$1 = { 48 83 EC 48 0F 29 7C 24 20 0F 29 74 24 30 4C 8D 0D ?? ?? ?? ?? 0F 28 35 ?? ?? ?? ?? 0F 28 3D ?? ?? ?? ?? 66 0F DB F8 0F 58 F7 0F 28 15 ?? ?? ?? ?? 66 0F DB D6 66 0F 7E D0 66 0F 70 D2 39 66 0F 7E D2 66 0F 70 D2 39 66 0F 7E D1 66 0F 70 D2 39 66 41 0F 7E D0 0F 28 1D ?? ?? ?? ?? 0F C2 DF 02 66 0F EF C7 0F 28 15 ?? ?? ?? ?? 0F 28 CF 0F C2 CA 02 66 0F DB CB 0F 28 2D ?? ?? ?? ?? 66 0F DB E9 0F 28 15 ?? ?? ?? ?? 0F 5C F2 0F 5C FE 0F 28 E7 0F 59 E7 0F 28 1D ?? ?? ?? ?? 0F 59 DC 0F 58 1D ?? ?? ?? ?? 66 0F EB C5 0F 28 15 ?? ?? ?? ?? 0F 59 E2 0F 58 25 ?? ?? ?? ?? 0F 59 E7 F3 41 0F 7E 14 81 F3 41 0F 7E 3C 91 F3 41 0F 7E 34 89 F3 43 0F 7E 2C 81 0F 14 D7 0F 14 F5 0F C6 D6 44 0F 28 F3 0F 59 F2 0F 58 F4 0F 59 E2 0F 58 E3 0F 5E F4 66 0F DF CE 66 0F EB C1 0F 28 74 24 30 0F 28 7C 24 20 48 83 C4 48 C3 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_106_0_0 {
	meta:
		name = "__scrt_is_ucrt_dll_in_use"
		size = 37
		refs = "0006 __scrt_ucrt_dll_is_in_use"
	strings:
		$1 = { 48 83 EC 18 83 3D ?? ?? ?? ?? 00 74 09 C7 04 24 01 00 00 00 EB 07 C7 04 24 00 00 00 00 8B 04 24 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_111_0_0 {
	meta:
		name = "__sse2_sinh2"
		size = 544
		refs = "000a __common_dsinh_data 0212 __common_dsinh_cout_rare"
	strings:
		$1 = { 48 81 EC 18 01 00 00 4C 8D 05 ?? ?? ?? ?? 44 0F 29 AC 24 D0 00 00 00 44 0F 29 A4 24 E0 00 00 00 44 0F 29 94 24 F0 00 00 00 44 0F 29 8C 24 00 01 00 00 0F 29 B4 24 C0 00 00 00 4C 89 AC 24 10 01 00 00 4C 8D 6C 24 6F 0F 28 35 ?? ?? ?? ?? 49 83 E5 C0 0F 54 F0 44 0F 28 D6 44 0F 28 0D ?? ?? ?? ?? 66 44 0F EF D0 66 45 0F 59 CA 0F 28 0D ?? ?? ?? ?? 66 44 0F 58 C9 41 0F 28 E1 66 0F 5C E1 F3 0F 7E 15 ?? ?? ?? ?? 66 41 0F 70 DA DD 66 0F 66 DA 0F 28 15 ?? ?? ?? ?? 66 0F 59 D4 0F 50 D3 0F 28 0D ?? ?? ?? ?? 44 0F 28 2D ?? ?? ?? ?? 66 0F 59 CC 66 44 0F 5C D2 66 44 0F 5C D1 41 0F 28 CA 83 E2 03 66 41 0F 59 CA 66 44 0F 59 E9 66 44 0F 58 2D ?? ?? ?? ?? 0F 28 2D ?? ?? ?? ?? 41 0F 54 E9 66 0F 7E E8 66 44 0F EF CD 44 0F 28 25 ?? ?? ?? ?? 66 41 0F 73 F1 2D 66 0F C5 CD 04 66 44 0F 59 E9 66 44 0F 59 E1 66 45 0F 59 EA 66 44 0F 58 25 ?? ?? ?? ?? 66 45 0F 58 EA 66 44 0F 59 E1 C1 E0 04 41 0F 28 E9 C1 E1 04 85 D2 F3 42 0F 7E 54 00 08 F3 42 0F 7E 1C 00 66 42 0F 16 54 01 08 66 0F D4 EA 66 41 0F FB D1 66 0F 6F E5 66 0F 58 E2 66 0F 5C EA 66 42 0F 16 1C 01 66 41 0F D4 D9 66 0F 58 EB 66 0F 58 DC 66 44 0F 59 E5 66 44 0F 59 EB 66 45 0F 58 EC 66 44 0F 58 ED 41 0F 56 F5 75 3F 44 0F 28 8C 24 00 01 00 00 0F 28 C6 0F 28 B4 24 C0 00 00 00 44 0F 28 94 24 F0 00 00 00 44 0F 28 A4 24 E0 00 00 00 44 0F 28 AC 24 D0 00 00 00 4C 8B AC 24 10 01 00 00 48 81 C4 18 01 00 00 C3 41 0F 29 45 00 41 0F 29 75 40 74 B5 33 C0 48 89 5C 24 28 8B D8 48 89 74 24 20 8B F2 8B CB 41 B8 01 00 00 00 41 D3 E0 41 85 F0 75 1B FF C3 83 FB 20 7C E9 48 8B 5C 24 28 48 8B 74 24 20 41 0F 28 75 40 E9 7A FF FF FF 49 8D 4C DD 00 49 8D 54 DD 40 E8 ?? ?? ?? ?? EB D4 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_114_0_0 {
	meta:
		name = "_raise_zerodivide"
		size = 32
	strings:
		$1 = { 66 0F 76 C0 66 0F EF C9 66 0F 72 F0 1C F3 0F 5E C1 C3 66 66 66 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_114_1_0 {
	meta:
		name = "__sse2_pow2"
		size = 1152
		refs = "000a s_Data"
	strings:
		$1 = { 48 81 EC 98 00 00 00 48 8D 05 ?? ?? ?? ?? 0F 29 7C 24 70 0F 29 74 24 60 48 89 84 24 80 00 00 00 66 0F 28 D8 66 0F 28 D0 66 0F DB 05 ?? ?? ?? ?? 66 0F 57 F6 4C 8B 84 24 80 00 00 00 66 0F FE 05 ?? ?? ?? ?? BA 00 00 00 00 89 94 24 88 00 00 00 66 0F 73 D0 2A 66 0F 7E C0 66 0F C5 C8 04 66 0F 29 4C 24 20 66 0F C5 D3 03 F3 41 0F 7E 84 C0 50 02 00 00 66 41 0F 16 84 C8 50 02 00 00 66 0F DB 15 ?? ?? ?? ?? 03 C0 66 41 0F 28 BC C0 60 22 00 00 66 0F C5 C3 07 66 0F 29 5C 24 30 66 0F FB 1D ?? ?? ?? ?? 03 C9 66 0F EB 15 ?? ?? ?? ?? 66 0F 72 E3 14 66 0F DB 1D ?? ?? ?? ?? 66 41 0F 28 AC C8 60 22 00 00 66 0F 28 E2 66 0F 29 74 24 40 66 0F FE 1D ?? ?? ?? ?? 66 0F 59 D0 81 EA 10 00 00 80 66 0F 5C 1D ?? ?? ?? ?? 2D 10 00 00 80 81 FA DF 7F 00 80 0F 8F C4 02 00 00 3D DF 7F 00 80 0F 8F B9 02 00 00 66 0F 70 F7 0E 66 0F 14 FD 66 0F 58 DF 66 0F C6 F5 02 66 0F 28 3D ?? ?? ?? ?? 66 0F DB FC 66 0F 5C E7 66 0F 59 F8 66 0F 59 E0 66 0F 5C FA 66 0F 58 15 ?? ?? ?? ?? 66 0F 58 FC 66 0F 28 E3 66 0F 58 DA 66 0F 5C E3 66 0F 58 E2 66 0F 28 C3 66 0F 58 DF 66 0F 5C C3 66 0F 58 C7 66 0F 58 FA 66 0F 58 C4 66 0F 28 D7 66 0F 59 FF 66 0F 28 25 ?? ?? ?? ?? 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 E7 66 0F 59 EF 66 0F 58 C6 66 0F 58 25 ?? ?? ?? ?? 66 0F 58 2D ?? ?? ?? ?? 66 0F 28 F3 66 0F 59 E7 66 0F 59 EF 66 0F 58 25 ?? ?? ?? ?? 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 E7 66 0F 59 EF 66 0F 28 F9 66 0F 58 25 ?? ?? ?? ?? 66 0F 59 E2 66 0F 70 D3 F1 66 0F 58 E5 66 0F 58 C4 66 0F 28 25 ?? ?? ?? ?? 66 0F 58 D8 66 0F 5C F3 66 0F 7E D0 66 0F 70 D2 FF 8B 4C 24 24 66 0F DB 3D ?? ?? ?? ?? 66 0F 58 C6 66 0F DB E3 25 00 00 F0 7F 81 E1 00 00 F0 7F 66 0F 5C DC 03 C1 3D 00 00 90 80 0F 87 DF 01 00 00 66 0F 7E D0 66 0F 59 C1 8B 4C 24 2C 25 00 00 F0 7F 81 E1 00 00 F0 7F 03 C1 3D 00 00 90 80 0F 87 BB 01 00 00 66 0F 28 EB 8B 44 24 24 25 FF FF FF 7F 8B 4C 24 20 0B C8 66 0F 5C CF 0F 84 9E 01 00 00 3D 00 00 F0 7F 66 0F 59 DF 0F 83 8F 01 00 00 8B 44 24 2C 25 FF FF FF 7F 8B 4C 24 28 0B C8 0F 84 7A 01 00 00 3D 00 00 F0 7F 66 0F 59 E9 0F 83 6B 01 00 00 66 0F 59 CC 66 0F 59 FC 66 0F 58 EB 66 0F 28 1D ?? ?? ?? ?? 66 0F 58 E9 66 0F 28 D7 66 0F 58 3D ?? ?? ?? ?? 66 0F 7E F8 66 0F C5 CF 04 66 0F C5 D7 05 C1 E2 10 66 0F 5C DF 0B CA 3D 80 FF 01 00 0F 8D 25 01 00 00 81 F9 80 FF 01 00 0F 8D 19 01 00 00 3D 00 1E FE FF 0F 8E 0E 01 00 00 81 F9 00 1E FE FF 0F 8E 02 01 00 00 83 E0 7F 83 E1 7F 03 C0 03 C9 66 0F 73 F7 2D 66 0F 28 25 ?? ?? ?? ?? 66 0F FE 3D ?? ?? ?? ?? 66 0F DB 3D ?? ?? ?? ?? 66 0F 58 DA 66 0F 58 E8 66 0F 28 05 ?? ?? ?? ?? F3 41 0F 7E 94 C0 90 62 00 00 66 0F 58 EB F3 41 0F 7E 9C C0 98 62 00 00 66 41 0F 16 94 C8 90 62 00 00 66 41 0F 16 9C C8 98 62 00 00 66 0F 59 C5 66 0F 28 CD 66 0F 59 E5 66 0F 59 ED 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 25 ?? ?? ?? ?? 66 0F 59 C5 66 0F 59 E5 66 0F 59 C5 66 0F 59 0D ?? ?? ?? ?? 66 0F 59 C2 66 0F 59 E2 66 0F 58 C3 66 0F 59 CA 66 0F 58 C4 66 0F 58 C1 66 0F 58 C2 66 0F 59 C7 E9 A9 00 00 00 66 0F 57 F6 66 0F 28 3D ?? ?? ?? ?? 66 0F C2 74 24 20 01 66 0F C2 7C 24 20 05 66 0F EF ED 66 0F DB F7 66 0F 76 6C 24 30 66 0F 70 FD B1 66 0F DB EE 66 0F DB EF 66 0F D7 D5 89 94 24 88 00 00 00 66 0F 29 6C 24 40 8B 84 24 88 00 00 00 A8 0F 75 1E F2 0F 10 44 24 30 F2 0F 10 4C 24 20 E8 60 00 00 00 F2 0F 11 44 24 50 8B 84 24 88 00 00 00 A9 00 0F 00 00 75 17 F2 0F 10 44 24 38 F2 0F 10 4C 24 28 E8 3B 00 00 00 F2 0F 11 44 24 58 4C 8B 84 24 80 00 00 00 66 0F 28 44 24 50 66 0F 76 C9 66 0F EF 4C 24 40 66 0F 54 C1 0F 28 74 24 60 0F 28 7C 24 70 48 81 C4 98 00 00 00 C3 0F 1F 80 00 00 00 00 }
	condition:
		$1
}

rule file_114_2_0 {
	meta:
		name = "pow_scalar"
		size = 3712
		refs = "00e4 s_Data 03f6 INF_c_2044_0_4 048b _2il0floatpacket_15 04f6 _2il0floatpacket_16 0c25 QNaN_c_2044_0_4"
	strings:
		$1 = { 53 56 57 41 54 41 55 41 56 41 57 55 48 81 EC F8 00 00 00 33 D2 F2 0F 11 8C 24 88 00 00 00 8B 9C 24 8C 00 00 00 8B CB 81 E1 FF FF FF 7F 44 0F 29 BC 24 90 00 00 00 81 F9 00 00 F0 7F 44 0F 29 B4 24 D0 00 00 00 44 0F 29 A4 24 E0 00 00 00 44 0F 29 9C 24 A0 00 00 00 44 0F 29 84 24 B0 00 00 00 0F 29 B4 24 C0 00 00 00 F2 0F 11 84 24 40 01 00 00 66 49 0F 7E C1 0F 83 93 01 00 00 8B 84 24 88 00 00 00 0B C8 0F 84 84 01 00 00 49 8B C1 48 C1 E8 20 8B E8 81 E5 FF FF FF 7F 4C 89 4C 24 28 8D 8D 00 00 F0 FF 81 F9 00 00 E0 7F 73 14 8B C8 81 E1 00 00 00 80 81 F9 00 00 00 80 0F 85 47 04 00 00 81 FD 00 00 F0 7F 0F 83 42 01 00 00 8B 4C 24 28 0B E9 0F 84 36 01 00 00 3D 00 00 10 00 73 2B F2 0F 59 05 ?? ?? ?? ?? 48 B8 00 00 00 00 00 00 F0 3F F2 0F 11 44 24 28 BA 34 00 00 00 48 89 44 24 30 8B 44 24 2C E9 0C 04 00 00 F2 0F 11 4C 24 20 8B 7C 24 24 81 E7 FF FF FF 7F 8B CF 8B 74 24 20 0B CE 74 6C 8D 8F 00 00 10 C0 81 F9 00 00 00 40 73 3D 81 FF 00 00 40 43 7D 56 8B CF 81 E1 00 00 F0 7F 81 C1 00 00 10 C0 C1 F9 14 83 F9 14 7F 23 8B EF D3 E5 C1 E5 0C 0B EE 75 14 83 C1 0B D3 E7 F7 D7 81 E7 00 00 00 80 C1 EF 1F FF C7 EB 26 33 FF EB 22 83 C1 0B D3 E6 F7 C6 FF FF FF 7F 75 EF F7 D6 81 E6 00 00 00 80 C1 EE 1F 8D 7E 01 EB 05 BF 02 00 00 00 25 00 00 00 80 3D 00 00 00 80 75 6D 85 FF 74 69 0F 28 C8 83 FF 01 0F 57 C0 F2 0F 5C C1 F2 0F 11 44 24 28 74 11 48 B8 00 00 00 00 00 00 F0 3F 48 89 44 24 30 EB 0F 48 B8 00 00 00 00 00 00 F0 BF 48 89 44 24 30 8B 44 24 2C 8B C8 81 E1 FF FF FF 7F 81 F9 00 00 10 00 0F 83 24 03 00 00 F2 0F 59 05 ?? ?? ?? ?? BA 34 00 00 00 F2 0F 11 44 24 28 8B 44 24 2C E9 08 03 00 00 F2 0F 11 4C 24 20 4C 89 4C 24 30 49 C1 E9 20 45 8B D9 F2 0F 11 4C 24 28 41 81 E3 FF FF FF 7F 44 8B 54 24 2C 41 81 E1 00 00 00 80 44 8B 44 24 24 41 81 E2 FF FF FF 7F 41 81 E0 00 00 00 80 8B 7C 24 30 41 81 FB 00 00 F0 7F 44 89 5C 24 34 44 89 54 24 2C 0F 84 1F 0A 00 00 C7 44 24 20 00 00 00 00 41 BF 01 00 00 00 8B 44 24 28 41 81 FA 00 00 F0 7F 0F 84 F3 09 00 00 33 F6 41 8B D3 81 E2 00 00 F0 7F 81 FA 00 00 F0 7F 0F 84 CC 09 00 00 33 ED 41 8B D2 81 E2 00 00 F0 7F 81 FA 00 00 F0 7F 0F 84 A8 09 00 00 33 DB 41 8B D3 8B CE 0B D7 BA 00 00 00 00 41 0F 44 D7 45 33 E4 0B CB 45 0F 44 E7 41 81 FB 00 00 F0 3F 44 89 64 24 30 0F 84 6E 09 00 00 45 33 FF F2 0F 11 4C 24 28 44 8B 6C 24 2C 41 81 E5 FF FF FF 7F 41 8B CD 44 8B 74 24 28 41 0B CE 74 7F 41 8D 8D 00 00 10 C0 81 F9 00 00 00 40 73 48 41 81 FD 00 00 40 43 7D 67 41 8B CD 81 E1 00 00 F0 7F 81 C1 00 00 10 C0 C1 F9 14 83 F9 14 7F 2D 45 8B E5 41 D3 E4 41 C1 E4 0C 45 0B E6 75 19 83 C1 0B 41 D3 E5 41 F7 D5 41 81 E5 00 00 00 80 41 C1 ED 1F 41 FF C5 EB 2E 45 33 ED EB 29 83 C1 0B 41 D3 E6 41 F7 C6 FF FF FF 7F 75 EC 41 F7 D6 41 81 E6 00 00 00 80 41 C1 EE 1F 45 8D 6E 01 EB 06 41 BD 02 00 00 00 41 81 FB 00 00 F0 3F 7E 04 B1 01 EB 08 0F 84 A7 08 00 00 B1 00 44 0B D0 0F 84 4B 01 00 00 45 85 C9 75 0B 45 85 FF 0F 85 3D 01 00 00 EB 0D 45 85 FF 74 08 85 F6 0F 85 2E 01 00 00 85 ED 0F 85 21 01 00 00 85 DB 0F 85 26 01 00 00 85 D2 74 0D 45 85 C0 74 08 85 F6 0F 85 D9 00 00 00 84 C9 74 22 45 85 C0 75 11 85 F6 74 19 F2 0F 10 0D ?? ?? ?? ?? E9 FB 00 00 00 85 F6 74 08 0F 57 C9 E9 EF 00 00 00 41 81 FB 00 00 F0 3F 7D 22 45 85 C0 75 0C 85 F6 74 19 0F 57 C9 E9 D5 00 00 00 85 F6 74 0D F2 0F 10 0D ?? ?? ?? ?? E9 C4 00 00 00 45 85 C9 75 23 83 7C 24 20 00 74 0D 45 85 C0 74 AB 0F 57 C9 E9 AB 00 00 00 85 D2 74 B0 45 85 C0 74 7B 41 83 FD 01 EB 60 83 7C 24 20 00 74 2C 45 85 C0 75 14 41 83 FD 01 0F 84 BF 07 00 00 F2 0F 10 0D ?? ?? ?? ?? EB 7C 41 83 FD 01 0F 57 C9 75 73 F2 0F 10 0D ?? ?? ?? ?? EB 69 83 7C 24 30 00 74 0F 45 85 ED 75 0A 85 D2 0F 84 77 07 00 00 EB 08 85 D2 0F 84 54 FF FF FF 45 85 C0 74 19 41 83 FD 01 0F 84 70 07 00 00 E8 9D F6 FF FF F2 0F 10 0D ?? ?? ?? ?? EB 2D 41 83 FD 01 74 10 83 7C 24 30 00 0F 84 25 FF FF FF 0F 57 C9 EB 17 F2 0F 10 0D ?? ?? ?? ?? EB 0D 0F 28 C8 EB 08 F2 0F 10 0D ?? ?? ?? ?? F2 0F 11 8C 24 88 00 00 00 E9 C8 06 00 00 48 B9 00 00 00 00 00 00 F0 3F 48 89 4C 24 30 8B F0 48 8D 2D ?? ?? ?? ?? F2 0F 11 44 24 20 81 E6 00 FE 0F 00 8B 4C 24 24 81 C6 00 02 00 00 81 E1 FF FF 0F 00 05 00 02 18 C0 C1 EE 0A 81 C9 00 00 F0 3F 89 4C 24 24 4C 8B CD 48 C1 E1 20 8D 3C 36 44 8B 54 24 20 49 0B CA 48 89 4C 24 28 44 8D 44 36 01 81 E1 00 00 00 F8 F2 0F 10 AC F5 50 02 00 00 89 4C 24 28 0F 28 D5 F2 0F 10 74 24 20 0F 28 DD F2 0F 10 64 24 28 F2 0F 59 D6 F2 0F 5C F4 F2 0F 59 DC F2 0F 59 F5 F2 0F 5C DA C1 F8 14 2B C2 8B D3 F2 44 0F 2A D8 48 8B C5 F2 0F 11 5C 24 38 81 E2 00 00 F0 7F F2 44 0F 10 44 24 38 81 C2 00 00 10 C0 F2 0F 10 0D ?? ?? ?? ?? F2 44 0F 58 C6 F2 44 0F 58 9C F8 60 22 00 00 F2 0F 58 CA F2 44 0F 11 44 24 38 F2 44 0F 11 5C 24 40 F2 44 0F 10 64 24 40 F2 44 0F 58 E1 F2 44 0F 11 64 24 48 8B 44 24 4C 44 8B D8 41 81 E3 00 00 F0 7F 41 81 C3 00 00 10 C0 41 C1 FB 14 C1 FA 14 44 03 DA F2 43 0F 10 84 C1 60 22 00 00 41 83 FB 0B 0F 8F 64 06 00 00 F2 0F 10 74 24 40 F2 0F 10 64 24 48 48 8B 94 24 88 00 00 00 F2 0F 5C F4 F2 0F 11 74 24 50 F2 0F 10 54 24 50 48 89 54 24 28 F2 0F 58 D1 F2 0F 11 54 24 50 81 E2 00 00 00 F8 F2 0F 10 6C 24 48 F2 0F 10 5C 24 38 89 54 24 28 F2 0F 58 EB F2 0F 11 6C 24 58 F2 44 0F 10 5C 24 48 F2 44 0F 10 44 24 58 F2 45 0F 5C D8 F2 44 0F 11 5C 24 60 F2 44 0F 10 74 24 38 F2 44 0F 10 64 24 60 F2 45 0F 58 F4 F2 44 0F 11 74 24 60 F2 0F 10 64 24 50 F2 44 0F 10 7C 24 60 F2 41 0F 58 E7 F2 0F 11 64 24 60 F2 0F 10 74 24 60 F2 0F 10 25 ?? ?? ?? ?? F2 0F 58 C6 F2 0F 11 44 24 60 F2 0F 10 44 24 38 F2 0F 10 74 24 60 F2 0F 58 C8 F2 0F 59 E1 F2 0F 58 25 ?? ?? ?? ?? F2 0F 59 E1 F2 0F 58 25 ?? ?? ?? ?? F2 0F 59 E1 F2 0F 58 25 ?? ?? ?? ?? F2 0F 59 E1 F2 0F 58 25 ?? ?? ?? ?? F2 0F 59 E1 F2 0F 58 25 ?? ?? ?? ?? F2 0F 59 E1 F2 0F 58 25 ?? ?? ?? ?? F2 0F 59 E1 F2 0F 58 F4 F2 0F 11 74 24 60 F2 0F 10 64 24 58 F2 0F 10 4C 24 60 F2 0F 58 E1 F2 0F 11 64 24 68 F2 0F 10 44 24 68 F2 0F 10 74 24 58 F2 0F 10 A4 24 88 00 00 00 F2 0F 5C C6 F2 0F 5C 64 24 28 F2 0F 11 44 24 70 F2 0F 10 54 24 60 F2 0F 10 4C 24 70 F2 0F 5C D1 F2 0F 11 54 24 60 48 8B 44 24 68 48 89 44 24 78 81 64 24 78 00 00 00 F8 F2 0F 10 6C 24 68 F2 0F 10 5C 24 78 F2 0F 10 15 ?? ?? ?? ?? F2 0F 5C EB F2 0F 11 AC 24 80 00 00 00 0F 28 EA F2 0F 10 74 24 78 F2 0F 59 74 24 28 F2 44 0F 10 84 24 80 00 00 00 F2 0F 58 EE F2 44 0F 59 C4 F2 44 0F 10 A4 24 80 00 00 00 F2 44 0F 59 64 24 28 F2 44 0F 10 5C 24 78 F2 45 0F 58 E0 F2 41 0F 59 E3 F2 0F 11 6C 24 20 F2 41 0F 58 E4 8B 5C 24 20 8B C3 83 E0 80 83 E3 7F C1 F8 07 F2 0F 10 5C 24 60 3D FF 03 00 00 F2 0F 59 9C 24 88 00 00 00 7C 52 3D 01 04 00 00 7C 34 48 8B 05 ?? ?? ?? ?? 48 89 84 24 88 00 00 00 48 C1 E8 20 8B 54 24 34 81 E2 00 00 00 80 0B C2 89 84 24 8C 00 00 00 F2 0F 10 8C 24 88 00 00 00 E9 46 03 00 00 F2 0F 10 4C 24 30 FF C8 F2 0F 58 C9 F2 0F 11 4C 24 30 E9 6B 02 00 00 3D 3C FC FF FF 0F 8F 5A 02 00 00 3D CC FB FF FF 7F 2A 8B 44 24 34 48 C7 84 24 88 00 00 00 00 00 00 00 25 00 00 00 80 89 84 24 8C 00 00 00 F2 0F 10 8C 24 88 00 00 00 E9 F3 02 00 00 F2 44 0F 10 35 ?? ?? ?? ?? 83 C0 6F C1 E0 14 48 8D 15 ?? ?? ?? ?? 05 00 00 F0 3F 48 8B EA 89 44 24 2C 8D 04 1B F2 44 0F 10 3D ?? ?? ?? ?? 8D 5C 1B 01 48 8B CA F2 0F 5C EA F2 0F 58 E3 F2 0F 5C F5 0F 28 DE F2 0F 10 15 ?? ?? ?? ?? F2 0F 58 DC F2 44 0F 59 F3 F2 0F 10 AC C2 90 62 00 00 F2 0F 10 8C DD 90 62 00 00 C7 44 24 28 00 00 00 00 F2 44 0F 10 5C 24 30 F2 44 0F 59 1D ?? ?? ?? ?? F2 44 0F 58 35 ?? ?? ?? ?? F2 44 0F 59 F3 48 8B 84 C1 90 62 00 00 F2 44 0F 58 F2 45 0F 28 E6 F2 44 0F 59 E3 F2 0F 10 15 ?? ?? ?? ?? F2 45 0F 58 E7 F2 44 0F 59 E5 44 0F 28 C2 F2 44 0F 59 C3 F2 44 0F 59 E3 F2 44 0F 59 C5 F2 44 0F 59 E3 F2 44 0F 58 E1 F2 45 0F 58 E0 F2 44 0F 10 44 24 28 41 0F 28 C0 F2 0F 59 C5 F2 41 0F 59 C3 F2 0F 11 44 24 20 8B 74 24 24 81 E6 FF FF FF 7F 81 FE 00 00 10 00 0F 86 B6 00 00 00 F2 44 0F 59 F3 F2 0F 5C F3 F2 45 0F 59 D8 F2 45 0F 58 FE F2 0F 58 F4 F2 44 0F 59 FB 44 0F 28 E3 F2 41 0F 58 D7 F2 44 0F 59 E2 F2 0F 59 D6 F2 44 0F 11 64 24 20 41 0F 28 DC 81 64 24 20 00 00 00 FF 0F 28 F5 F2 44 0F 10 74 24 20 48 89 44 24 28 F2 41 0F 5C DE F2 44 0F 59 E1 F2 0F 58 D3 C7 44 24 28 00 00 00 00 F2 44 0F 10 7C 24 28 F2 41 0F 5C F7 0F 28 E6 F2 0F 59 E2 F2 41 0F 59 D7 F2 41 0F 59 F6 F2 44 0F 58 E4 F2 45 0F 59 F7 F2 41 0F 58 CC F2 0F 58 CA F2 0F 58 CE F2 41 0F 58 CE F2 0F 58 CD F2 41 0F 59 CB F2 0F 11 8C 24 88 00 00 00 E9 36 01 00 00 48 89 44 24 20 33 C0 F2 44 0F 11 64 24 28 89 44 24 20 81 64 24 24 00 00 FF FF 89 44 24 28 F2 0F 10 4C 24 20 F2 0F 10 44 24 28 F2 0F 5C E9 F2 44 0F 5C E0 F2 44 0F 58 E5 41 0F 28 EB F2 41 0F 59 E8 F2 44 0F 59 C1 F2 44 0F 58 E0 F2 45 0F 59 C3 F2 44 0F 59 E5 41 0F 28 CC F2 41 0F 58 C8 F2 0F 11 8C 24 88 00 00 00 E9 CA 00 00 00 F2 0F 10 4C 24 30 C1 E0 14 48 8D 15 ?? ?? ?? ?? 05 00 00 F0 3F 8D 4C 1B 01 89 44 24 2C 8D 04 1B F2 0F 5C EA F2 0F 58 E3 F2 0F 5C F5 F2 0F 10 15 ?? ?? ?? ?? F2 0F 58 E6 F2 0F 10 35 ?? ?? ?? ?? 48 8B DA F2 0F 11 6C 24 20 F2 0F 10 AC C2 90 62 00 00 F2 0F 10 1D ?? ?? ?? ?? F2 0F 59 F4 F2 0F 59 D4 F2 0F 59 DC F2 0F 58 35 ?? ?? ?? ?? F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 DD F2 0F 59 F4 F2 0F 59 D4 F2 0F 59 F4 F2 0F 59 D4 F2 0F 59 F4 F2 0F 59 D5 F2 0F 59 F4 F2 0F 59 F5 C7 44 24 28 00 00 00 00 F2 0F 58 B4 CB 90 62 00 00 F2 0F 58 F2 F2 0F 58 F3 F2 0F 58 F5 F2 0F 59 CE F2 0F 59 4C 24 28 F2 0F 11 8C 24 88 00 00 00 0F 28 B4 24 C0 00 00 00 0F 28 C1 44 0F 28 84 24 B0 00 00 00 44 0F 28 9C 24 A0 00 00 00 44 0F 28 A4 24 E0 00 00 00 44 0F 28 B4 24 D0 00 00 00 44 0F 28 BC 24 90 00 00 00 48 81 C4 F8 00 00 00 5D 41 5F 41 5E 41 5D 41 5C 5F 5E 5B C3 E8 5F 02 00 00 F2 0F 10 0D ?? ?? ?? ?? E9 CC F8 FF FF E8 2D EF FF FF 0F 57 C9 F2 0F 5C 0D ?? ?? ?? ?? E9 B7 F8 FF FF 85 FF 0F 85 47 F7 FF FF E9 4C F7 FF FF 33 C9 85 FF 44 0F 45 F9 E9 88 F6 FF FF 33 DB 85 F6 41 0F 44 DF E9 4D F6 FF FF 33 ED 83 7C 24 20 00 41 0F 44 EF E9 26 F6 FF FF 33 F6 85 C0 41 0F 44 F7 E9 02 F6 FF FF 41 BF 01 00 00 00 33 C0 85 FF 41 0F 44 C7 89 44 24 20 E9 D8 F5 FF FF 33 D8 F7 C3 00 00 00 80 0F 85 F1 00 00 00 F7 84 24 44 01 00 00 00 00 00 80 75 1C 48 8B 05 ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? 48 89 84 24 88 00 00 00 E9 FB FE FF FF 48 8B 84 24 88 00 00 00 8B D8 48 C1 E8 20 25 FF FF FF 7F 8B D0 0B D3 74 CB 8D 90 00 00 10 C0 81 FA 00 00 00 40 73 50 3D 00 00 40 43 7D B6 8B C8 81 E1 00 00 F0 7F 81 C1 00 00 10 C0 C1 F9 14 83 F9 14 7F 4F 8B D0 D3 E2 C1 E2 0C 0B D3 75 28 83 C1 0B D3 E0 A9 00 00 00 80 74 89 48 8B 05 ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? 48 89 84 24 88 00 00 00 E9 84 FE FF FF 48 8B 05 ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? 48 89 84 24 88 00 00 00 E9 68 FE FF FF 83 C1 0B D3 E3 F7 C3 FF FF FF 7F 75 D7 F7 C3 00 00 00 80 0F 84 38 FF FF FF 48 8B 05 ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? 48 89 84 24 88 00 00 00 E9 33 FE FF FF F7 84 24 44 01 00 00 00 00 00 80 75 14 48 C7 84 24 88 00 00 00 00 00 00 00 0F 57 C9 E9 12 FE FF FF 48 8B 84 24 88 00 00 00 8B D8 48 C1 E8 20 25 FF FF FF 7F 8B D0 0B D3 74 D3 8D 90 00 00 10 C0 81 FA 00 00 00 40 0F 83 63 FF FF FF 3D 00 00 40 43 7D BA 8B C8 81 E1 00 00 F0 7F 81 C1 00 00 10 C0 C1 F9 14 83 F9 14 7F 37 8B D0 D3 E2 C1 E2 0C 0B D3 0F 85 37 FF FF FF 83 C1 0B D3 E0 A9 00 00 00 80 74 89 48 8B 05 ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? 48 89 84 24 88 00 00 00 E9 93 FD FF FF 83 C1 0B D3 E3 F7 C3 FF FF FF 7F 0F 85 FE FE FF FF F7 C3 00 00 00 80 0F 84 50 FF FF FF 48 8B 05 ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? 48 89 84 24 88 00 00 00 E9 5A FD FF FF 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_114_3_0 {
	meta:
		name = "_raise_invalid"
		size = 16
	strings:
		$1 = { B8 FF FF 8F FF 66 0F 6E C0 F3 0F 58 C0 C3 66 90 }
	condition:
		$1
}

rule file_118_0_0 {
	meta:
		name = "__avx_logf8"
		size = 544
		refs = "003f __common_slog_data 0217 __common_slog_cout_rare"
	strings:
		$1 = { 48 81 EC 18 02 00 00 C5 7C 11 B4 24 F0 01 00 00 C5 7C 11 A4 24 D0 01 00 00 C5 7C 11 9C 24 B0 01 00 00 C5 7C 11 8C 24 90 01 00 00 4C 89 AC 24 10 02 00 00 4C 8D AC 24 2F 01 00 00 C5 F8 10 25 ?? ?? ?? ?? 49 83 E5 C0 C5 F8 10 2D ?? ?? ?? ?? C5 F8 10 0D ?? ?? ?? ?? C5 F8 10 15 ?? ?? ?? ?? C5 79 FA F4 C4 E3 7D 19 C3 01 C4 C1 21 72 E6 17 C5 61 FA E4 C5 09 DB F5 C4 C1 31 72 E4 17 C5 99 DB ED C5 09 FE F4 C5 D1 FE E4 C5 F9 FE E9 C5 E1 FE C9 C5 E9 66 D9 C5 F1 EF C9 C4 43 25 18 C9 01 C4 41 7C 5B D9 C5 69 66 CD C5 B1 6B D3 C5 E9 63 D9 C5 F9 D7 D3 C5 24 59 1D ?? ?? ?? ?? C4 E3 0D 18 E4 01 C5 DC 5C 15 ?? ?? ?? ?? C5 EC 59 25 ?? ?? ?? ?? C5 DC 58 2D ?? ?? ?? ?? C5 54 59 CA C5 34 58 25 ?? ?? ?? ?? C5 1C 59 F2 C5 8C 58 0D ?? ?? ?? ?? C5 F4 59 DA C5 E4 58 25 ?? ?? ?? ?? C5 DC 59 EA C5 54 58 0D ?? ?? ?? ?? C5 34 59 E2 C5 1C 58 35 ?? ?? ?? ?? C5 8C 59 CA C5 F4 59 DA C5 E4 58 D2 C5 A4 58 CA 84 D2 75 38 C5 7C 10 8C 24 90 01 00 00 C5 7C 10 9C 24 B0 01 00 00 C5 7C 10 A4 24 D0 01 00 00 C5 7C 10 B4 24 F0 01 00 00 4C 8B AC 24 10 02 00 00 C5 FC 28 C1 48 81 C4 18 02 00 00 C3 C4 C1 7C 11 45 00 C4 C1 7C 11 4D 40 85 D2 74 B8 33 C0 C5 FC 11 B4 24 C0 00 00 00 C5 FC 11 BC 24 A0 00 00 00 C5 7C 11 84 24 80 00 00 00 C5 7C 11 54 24 60 C5 7C 11 6C 24 40 C5 7C 11 7C 24 20 48 89 9C 24 E8 00 00 00 8B D8 48 89 B4 24 E0 00 00 00 8B F2 0F A3 DE 72 4F FF C3 83 FB 20 7C F4 C5 FC 10 B4 24 C0 00 00 00 C5 FC 10 BC 24 A0 00 00 00 C5 7C 10 84 24 80 00 00 00 C5 7C 10 54 24 60 C5 7C 10 6C 24 40 C5 7C 10 7C 24 20 C4 C1 7C 10 4D 40 48 8B 9C 24 E8 00 00 00 48 8B B4 24 E0 00 00 00 E9 21 FF FF FF C5 F8 77 49 8D 4C 9D 00 49 8D 54 9D 40 E8 ?? ?? ?? ?? EB 9D 0F 1F 00 }
	condition:
		$1
}

rule file_122_0_0 {
	meta:
		name = "__sse2_acos2"
		size = 480
		refs = "000b iSignMask 004a dbOneHalf 0053 dbOne 00b0 dbTwo 00d7 dbPio2hi 00df dbPi 0101 dbA10 010d dbA09 0115 dbA08 011d dbA07 0136 dbA06 0142 dbA05 0158 dbA04 0160 dbA03 0170 dbA02 0178 dbA01 0190 dbA00"
	strings:
		$1 = { 48 81 EC A8 00 00 00 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F C2 D0 05 66 0F 29 54 24 20 66 0F 54 C8 66 0F 28 D8 66 0F 55 1D ?? ?? ?? ?? 66 0F 29 5C 24 30 66 0F 29 4C 24 40 66 0F 55 C8 66 0F 28 E1 66 0F C2 25 ?? ?? ?? ?? 05 66 0F 28 2D ?? ?? ?? ?? 66 0F 29 4C 24 50 66 0F 5C E9 66 0F 59 C9 66 0F 59 2D ?? ?? ?? ?? 66 0F 28 D4 66 0F 54 EC 66 0F 55 D1 66 0F 56 D5 66 0F 51 ED 66 0F 28 D9 66 0F 29 54 24 60 66 0F 59 D2 66 0F C2 1D ?? ?? ?? ?? 00 66 0F 29 5C 24 70 66 0F 28 0D ?? ?? ?? ?? 66 0F 56 4C 24 30 66 0F 28 05 ?? ?? ?? ?? 66 0F 56 44 24 40 66 0F 28 DC 66 0F 54 C4 66 0F 55 E1 66 0F 56 C4 66 0F 29 84 24 80 00 00 00 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 05 ?? ?? ?? ?? 66 0F 54 44 24 20 66 0F 28 E3 66 0F 54 C3 66 0F 55 D9 66 0F 28 CA 66 0F 56 C3 66 0F 59 0D ?? ?? ?? ?? 66 0F 28 DA 66 0F 59 1D ?? ?? ?? ?? 66 0F 58 0D ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 29 84 24 90 00 00 00 66 0F 59 CA 66 0F 59 DA 66 0F 58 0D ?? ?? ?? ?? 66 0F 54 EC 66 0F 58 1D ?? ?? ?? ?? 66 0F 55 64 24 50 66 0F 59 CA 66 0F 59 DA 66 0F 58 0D ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 CA 66 0F 59 DA 66 0F 58 0D ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 CA 66 0F 59 DA 66 0F 28 15 ?? ?? ?? ?? 66 0F 58 0D ?? ?? ?? ?? 66 0F 54 54 24 20 66 0F 59 4C 24 60 66 0F 56 EC 66 0F 58 CB 66 0F 59 CD 66 0F 28 44 24 70 66 0F 58 CD 66 0F 59 8C 24 80 00 00 00 66 0F 54 54 24 70 66 0F 58 8C 24 90 00 00 00 66 0F 55 C1 66 0F 56 C2 48 81 C4 A8 00 00 00 C3 66 90 }
	condition:
		$1
}

rule file_130_0_0 {
	meta:
		name = "??__D@YAXPEAX0_K1P6AX00@ZP6AX0@Z@Z"
		size = 193
		refs = "0051 _guard_check_icall 00b8 ?__ArrayUnwind@@YAXPEAX_K1P6AX0@Z@Z"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 48 C7 44 24 28 00 00 00 00 C6 44 24 20 00 EB 0D 48 8B 44 24 28 48 FF C0 48 89 44 24 28 48 8B 44 24 68 48 39 44 24 28 74 54 48 8B 44 24 70 48 89 44 24 30 48 8B 4C 24 30 E8 ?? ?? ?? ?? 41 B8 01 00 00 00 48 8B 54 24 58 48 8B 4C 24 50 FF 54 24 30 48 8B 44 24 60 48 8B 4C 24 50 48 03 C8 48 8B C1 48 89 44 24 50 48 8B 44 24 60 48 8B 4C 24 58 48 03 C8 48 8B C1 48 89 44 24 58 EB 93 C6 44 24 20 01 0F B6 44 24 20 85 C0 75 19 4C 8B 4C 24 78 4C 8B 44 24 28 48 8B 54 24 60 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_130_1_0 {
	meta:
		name = "?fin$0@?0???__D@YAXPEAX0_K1P6AX00@ZP6AX0@Z@Z@4HA"
		size = 46
		refs = "0022 ?__ArrayUnwind@@YAXPEAX_K1P6AX0@Z@Z"
		altNames = "?fin$0@?0???__C@YAXPEAX0_K1P6AX00@ZP6AX0@Z@Z@4HA"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 0F B6 45 20 85 C0 75 16 4C 8B 4D 78 4C 8B 45 28 48 8B 55 60 48 8B 4D 50 E8 ?? ?? ?? ?? 90 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_130_2_0 {
	meta:
		name = "??__D@YAXPEAX0_KHP6AX00@ZP6AX0@Z@Z"
		size = 77
		refs = "0044 ??__D@YAXPEAX0_K1P6AX00@ZP6AX0@Z@Z"
	strings:
		$1 = { 44 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 63 44 24 58 48 8B 4C 24 68 48 89 4C 24 28 48 8B 4C 24 60 48 89 4C 24 20 4C 8B C8 4C 8B 44 24 50 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_193_2_0 {
	meta:
		name = "??__C@YAXPEAX0_KHP6AX00@ZP6AX0@Z@Z"
		size = 77
		refs = "0044 ??__C@YAXPEAX0_K1P6AX00@ZP6AX0@Z@Z"
	strings:
		$1 = { 44 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 63 44 24 58 48 8B 4C 24 68 48 89 4C 24 28 48 8B 4C 24 60 48 89 4C 24 20 4C 8B C8 4C 8B 44 24 50 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_133_0_0 {
	meta:
		name = "?pre_c_initialization@@YAHXZ"
		size = 188
		refs = "0005 ?get_app_type@__scrt_main_policy@@SA?AW4_crt_app_type@@XZ 000c _set_app_type 0011 _get_startup_file_mode 0018 _set_fmode 001d _get_startup_commit_mode 0026 __p__commode 0036 __scrt_initialize_onexit_tables 0047 __scrt_fastfail 004c _RTC_Initialize 0053 _RTC_Terminate 0058 atexit 005d ?configure_argv@__scrt_wide_argv_policy@@SAHXZ 0070 ?__scrt_initialize_type_info@@YAXXZ 0075 __scrt_is_user_matherr_present 0080 _matherr 0085 __setusermatherr 008a _initialize_invalid_parameter_handler 008f _initialize_denormal_control 0094 _get_startup_thread_locale_mode 009b _configthreadlocale 00a0 _should_initialize_environment 00ac ?initialize_environment@@YAXXZ 00b1 __scrt_initialize_winrt"
	strings:
		$1 = { 48 83 EC 38 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 44 24 20 E8 ?? ?? ?? ?? 8B 4C 24 20 89 08 B9 01 00 00 00 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 0A B9 07 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 0A B9 07 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 0C 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 05 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_164_0_0 {
	meta:
		name = "?pre_c_initialization@@YAHXZ"
		size = 188
		refs = "0005 ?get_app_type@__scrt_winmain_policy@@SA?AW4_crt_app_type@@XZ 000c _set_app_type 0011 _get_startup_file_mode 0018 _set_fmode 001d _get_startup_commit_mode 0026 __p__commode 0036 __scrt_initialize_onexit_tables 0047 __scrt_fastfail 004c _RTC_Initialize 0053 _RTC_Terminate 0058 atexit 005d ?configure_argv@__scrt_narrow_argv_policy@@SAHXZ 0070 ?__scrt_initialize_type_info@@YAXXZ 0075 __scrt_is_user_matherr_present 0080 _matherr 0085 __setusermatherr 008a _initialize_invalid_parameter_handler 008f _initialize_denormal_control 0094 _get_startup_thread_locale_mode 009b _configthreadlocale 00a0 _should_initialize_environment 00ac ?initialize_environment@@YAXXZ 00b1 __scrt_initialize_winrt"
	strings:
		$1 = { 48 83 EC 38 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 44 24 20 E8 ?? ?? ?? ?? 8B 4C 24 20 89 08 B9 01 00 00 00 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 0A B9 07 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 0A B9 07 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 0C 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 05 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_327_0_0 {
	meta:
		name = "?pre_c_initialization@@YAHXZ"
		size = 188
		refs = "0005 ?get_app_type@__scrt_winmain_policy@@SA?AW4_crt_app_type@@XZ 000c _set_app_type 0011 _get_startup_file_mode 0018 _set_fmode 001d _get_startup_commit_mode 0026 __p__commode 0036 __scrt_initialize_onexit_tables 0047 __scrt_fastfail 004c _RTC_Initialize 0053 _RTC_Terminate 0058 atexit 005d ?configure_argv@__scrt_wide_argv_policy@@SAHXZ 0070 ?__scrt_initialize_type_info@@YAXXZ 0075 __scrt_is_user_matherr_present 0080 _matherr 0085 __setusermatherr 008a _initialize_invalid_parameter_handler 008f _initialize_denormal_control 0094 _get_startup_thread_locale_mode 009b _configthreadlocale 00a0 _should_initialize_environment 00ac ?initialize_environment@@YAXXZ 00b1 __scrt_initialize_winrt"
	strings:
		$1 = { 48 83 EC 38 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 44 24 20 E8 ?? ?? ?? ?? 8B 4C 24 20 89 08 B9 01 00 00 00 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 0A B9 07 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 0A B9 07 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 0C 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 05 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_384_0_0 {
	meta:
		name = "?pre_c_initialization@@YAHXZ"
		size = 188
		refs = "0005 ?get_app_type@__scrt_main_policy@@SA?AW4_crt_app_type@@XZ 000c _set_app_type 0011 _get_startup_file_mode 0018 _set_fmode 001d _get_startup_commit_mode 0026 __p__commode 0036 __scrt_initialize_onexit_tables 0047 __scrt_fastfail 004c _RTC_Initialize 0053 _RTC_Terminate 0058 atexit 005d ?configure_argv@__scrt_narrow_argv_policy@@SAHXZ 0070 ?__scrt_initialize_type_info@@YAXXZ 0075 __scrt_is_user_matherr_present 0080 _matherr 0085 __setusermatherr 008a _initialize_invalid_parameter_handler 008f _initialize_denormal_control 0094 _get_startup_thread_locale_mode 009b _configthreadlocale 00a0 _should_initialize_environment 00ac ?initialize_environment@@YAXXZ 00b1 __scrt_initialize_winrt"
	strings:
		$1 = { 48 83 EC 38 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 44 24 20 E8 ?? ?? ?? ?? 8B 4C 24 20 89 08 B9 01 00 00 00 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 0A B9 07 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 0A B9 07 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 0C 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 05 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_46_0_7 {
	meta:
		name = "?pre_c_initialization@@YAHXZ"
		size = 188
		refs = "0005 ?get_app_type@__scrt_winmain_policy@@SA?AW4_crt_app_type@@XZ 000c _set_app_type 0011 _get_startup_file_mode 0018 _set_fmode 001d _get_startup_commit_mode 0026 __p__commode 0036 __scrt_initialize_onexit_tables 0047 __scrt_fastfail 004c _RTC_Initialize 0053 _RTC_Terminate 0058 atexit 005d ?configure_argv@__scrt_narrow_argv_policy@@SAHXZ 0070 ?__scrt_initialize_type_info@@YAXXZ 0075 __scrt_is_user_matherr_present 0080 _matherr 0085 __setusermatherr 008a _initialize_invalid_parameter_handler 008f _initialize_denormal_control 0094 _get_startup_thread_locale_mode 009b _configthreadlocale 00a0 _should_initialize_environment 00ac ?initialize_environment@@YAXXZ 00b1 __scrt_initialize_winrt"
	strings:
		$1 = { 48 83 EC 38 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 44 24 20 E8 ?? ?? ?? ?? 8B 4C 24 20 89 08 B9 01 00 00 00 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 0A B9 07 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 0A B9 07 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 0C 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 05 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_310_0_7 {
	meta:
		name = "?pre_c_initialization@@YAHXZ"
		size = 188
		refs = "0005 ?get_app_type@__scrt_main_policy@@SA?AW4_crt_app_type@@XZ 000c _set_app_type 0011 _get_startup_file_mode 0018 _set_fmode 001d _get_startup_commit_mode 0026 __p__commode 0036 __scrt_initialize_onexit_tables 0047 __scrt_fastfail 004c _RTC_Initialize 0053 _RTC_Terminate 0058 atexit 005d ?configure_argv@__scrt_narrow_argv_policy@@SAHXZ 0070 ?__scrt_initialize_type_info@@YAXXZ 0075 __scrt_is_user_matherr_present 0080 _matherr 0085 __setusermatherr 008a _initialize_invalid_parameter_handler 008f _initialize_denormal_control 0094 _get_startup_thread_locale_mode 009b _configthreadlocale 00a0 _should_initialize_environment 00ac ?initialize_environment@@YAXXZ 00b1 __scrt_initialize_winrt"
	strings:
		$1 = { 48 83 EC 38 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 44 24 20 E8 ?? ?? ?? ?? 8B 4C 24 20 89 08 B9 01 00 00 00 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 0A B9 07 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 0A B9 07 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 0C 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 05 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_547_0_7 {
	meta:
		name = "?pre_c_initialization@@YAHXZ"
		size = 188
		refs = "0005 ?get_app_type@__scrt_winmain_policy@@SA?AW4_crt_app_type@@XZ 000c _set_app_type 0011 _get_startup_file_mode 0018 _set_fmode 001d _get_startup_commit_mode 0026 __p__commode 0036 __scrt_initialize_onexit_tables 0047 __scrt_fastfail 004c _RTC_Initialize 0053 _RTC_Terminate 0058 atexit 005d ?configure_argv@__scrt_wide_argv_policy@@SAHXZ 0070 ?__scrt_initialize_type_info@@YAXXZ 0075 __scrt_is_user_matherr_present 0080 _matherr 0085 __setusermatherr 008a _initialize_invalid_parameter_handler 008f _initialize_denormal_control 0094 _get_startup_thread_locale_mode 009b _configthreadlocale 00a0 _should_initialize_environment 00ac ?initialize_environment@@YAXXZ 00b1 __scrt_initialize_winrt"
	strings:
		$1 = { 48 83 EC 38 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 44 24 20 E8 ?? ?? ?? ?? 8B 4C 24 20 89 08 B9 01 00 00 00 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 0A B9 07 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 0A B9 07 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 0C 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 05 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_133_1_0 {
	meta:
		name = "?post_pgo_initialization@@YAHXZ"
		size = 16
		refs = "0005 __scrt_initialize_default_local_stdio_options"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 33 C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_133_2_0 {
	meta:
		name = "?pre_cpp_initialization@@YAXXZ"
		size = 26
		refs = "0005 __scrt_set_unhandled_exception_filter 000a _get_startup_new_mode 0011 _set_new_mode"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_133_3_0 {
	meta:
		name = "?__scrt_common_main@@YAHXZ"
		size = 19
		refs = "0005 __security_init_cookie 000a ?__scrt_common_main_seh@@YAHXZ"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_133_4_0 {
	meta:
		name = "?__scrt_common_main_seh@@YAHXZ"
		size = 407
		refs = "000a __scrt_initialize_crt 001b __scrt_fastfail 0025 __scrt_acquire_startup_lock 002f __scrt_current_native_startup_state 0058 __xi_z 005f __xi_a 0064 _initterm_e 0079 __xc_z 0080 __xc_a 0085 _initterm 00a0 __scrt_release_startup_lock 00a5 __scrt_get_dyn_tls_init_callback 00bf __scrt_is_nonwritable_in_current_image 00dd _guard_check_icall 00f0 __scrt_get_dyn_tls_dtor_callback 011e _register_thread_local_exe_atexit_callback 0123 ?invoke_main@@YAHXZ 012c __scrt_is_managed_app 013c exit 014a _cexit 0153 __scrt_uninitialize_crt 017a _exit 0188 _c_exit"
	strings:
		$1 = { 48 83 EC 58 B9 01 00 00 00 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 0A B9 07 00 00 00 E8 ?? ?? ?? ?? C6 44 24 20 00 E8 ?? ?? ?? ?? 88 44 24 21 83 3D ?? ?? ?? ?? 01 75 0C B9 07 00 00 00 E8 ?? ?? ?? ?? EB 58 83 3D ?? ?? ?? ?? 00 75 4A C7 05 ?? ?? ?? ?? 01 00 00 00 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 0A B8 FF 00 00 00 E9 1C 01 00 00 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 02 00 00 00 EB 05 C6 44 24 20 01 0F B6 4C 24 21 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 44 24 30 48 8B 44 24 30 48 83 38 00 74 36 48 8B 4C 24 30 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 25 48 8B 44 24 30 48 8B 00 48 89 44 24 40 48 8B 4C 24 40 E8 ?? ?? ?? ?? 45 33 C0 BA 02 00 00 00 33 C9 FF 54 24 40 E8 ?? ?? ?? ?? 48 89 44 24 38 48 8B 44 24 38 48 83 38 00 74 1E 48 8B 4C 24 38 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 0D 48 8B 44 24 38 48 8B 08 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 44 24 28 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 09 8B 4C 24 28 E8 ?? ?? ?? ?? 0F B6 44 24 20 85 C0 75 05 E8 ?? ?? ?? ?? 33 D2 B1 01 E8 ?? ?? ?? ?? 8B 44 24 28 EB 35 89 44 24 24 8B 44 24 24 89 44 24 2C E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 09 8B 4C 24 2C E8 ?? ?? ?? ?? 0F B6 44 24 20 85 C0 75 05 E8 ?? ?? ?? ?? 8B 44 24 2C EB 00 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_133_5_0 {
	meta:
		name = "?filt$0@?0??__scrt_common_main_seh@@YAHXZ@4HA"
		size = 48
		refs = "0024 _seh_filter_exe"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 89 4D 48 48 8B 45 48 48 8B 00 8B 00 89 45 24 48 8B 45 48 8B 4D 24 48 8B D0 E8 ?? ?? ?? ?? 90 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_133_9_0 {
	meta:
		name = "?invoke_main@@YAHXZ"
		size = 57
		refs = "0005 _get_initial_wide_environment 000f __p___wargv 0019 __p___argc 0030 wmain"
	strings:
		$1 = { 48 83 EC 38 E8 ?? ?? ?? ?? 48 89 44 24 20 E8 ?? ?? ?? ?? 48 89 44 24 28 E8 ?? ?? ?? ?? 48 8B 4C 24 20 4C 8B C1 48 8B 4C 24 28 48 8B 11 8B 08 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_384_9_0 {
	meta:
		name = "?invoke_main@@YAHXZ"
		size = 57
		refs = "0005 _get_initial_narrow_environment 000f __p___argv 0019 __p___argc 0030 main"
	strings:
		$1 = { 48 83 EC 38 E8 ?? ?? ?? ?? 48 89 44 24 20 E8 ?? ?? ?? ?? 48 89 44 24 28 E8 ?? ?? ?? ?? 48 8B 4C 24 20 4C 8B C1 48 8B 4C 24 28 48 8B 11 8B 08 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_134_0_0 {
	meta:
		name = "??3@YAXPEAX@Z"
		size = 29
		refs = "0014 _free_dbg"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 BA FF FF FF FF 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_135_2_0 {
	meta:
		name = "_RTC_InitBase"
		size = 63
		refs = "0006 ?init@?1??_RTC_InitBase@@9@4_NA 002a _CRT_RTC_INITW 0036 _RTC_SetErrorFuncW"
	strings:
		$1 = { 48 83 EC 38 80 3D ?? ?? ?? ?? 00 75 2D 41 B9 01 00 00 00 C6 05 ?? ?? ?? ?? 01 45 33 C0 C7 44 24 20 00 00 00 00 33 D2 33 C9 E8 ?? ?? ?? ?? 48 8B C8 48 83 C4 38 E9 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_135_3_0 {
	meta:
		name = "_RTC_Shutdown"
		size = 35
		refs = "001a _CRT_RTC_INITW"
	strings:
		$1 = { 48 83 EC 38 41 B9 01 00 00 00 C7 44 24 20 01 00 00 00 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_137_0_0 {
	meta:
		name = "__avx_tan4"
		size = 2640
		refs = "000a __common_dtan_reduction_data 007e __common_dtan_data 0269 __common_dtan_cout_rare 02ca _2il0floatpacket_355 030d _2il0floatpacket_356 0373 _2il0floatpacket_357 05e2 _2il0floatpacket_358 0609 _2il0floatpacket_361 061b _2il0floatpacket_362 0624 _2il0floatpacket_359 0661 _2il0floatpacket_360 0679 _2il0floatpacket_364 068a _2il0floatpacket_363 06dc _2il0floatpacket_368 06ef _2il0floatpacket_365 06f8 _2il0floatpacket_366 0701 _2il0floatpacket_367 0743 _2il0floatpacket_369 0750 _2il0floatpacket_371 0759 _2il0floatpacket_370"
	strings:
		$1 = { 48 81 EC B8 02 00 00 48 8D 15 ?? ?? ?? ?? C5 7C 11 BC 24 D0 01 00 00 33 C0 C5 7C 11 B4 24 70 02 00 00 C5 7C 11 AC 24 90 01 00 00 C5 7C 11 A4 24 B0 01 00 00 C5 7C 11 9C 24 90 02 00 00 C5 7C 11 94 24 F0 01 00 00 C5 7C 11 8C 24 50 02 00 00 C5 7C 11 84 24 30 02 00 00 C5 FC 11 BC 24 10 02 00 00 C5 FC 11 B4 24 70 01 00 00 4C 89 AC 24 B0 02 00 00 4C 8D AC 24 0F 01 00 00 C5 FD 10 15 ?? ?? ?? ?? 49 83 E5 C0 C5 FD 54 EA C5 D5 C2 0D ?? ?? ?? ?? 1E C5 ED 55 D0 C4 E3 7D 19 CB 01 C5 F0 C6 E3 DD C5 F8 50 CC 85 C9 0F 85 C1 01 00 00 C5 FD 10 3D ?? ?? ?? ?? C5 D5 59 35 ?? ?? ?? ?? C5 CD 58 CF C5 75 5C EF C5 15 59 05 ?? ?? ?? ?? C5 15 59 15 ?? ?? ?? ?? C5 15 59 25 ?? ?? ?? ?? C5 15 59 3D ?? ?? ?? ?? C4 41 55 5C C8 C4 41 35 5C DA C4 41 25 5C F4 C4 C1 0D 5C E7 C5 DD 59 EC C5 55 59 25 ?? ?? ?? ?? C5 55 59 2D ?? ?? ?? ?? C5 1D 58 35 ?? ?? ?? ?? C5 0D 59 FD C4 41 25 57 DB C5 E1 73 F1 3F C4 C3 7D 19 C8 01 C4 C1 49 73 F0 3F C4 C1 31 73 F0 3E C4 E3 65 18 FE 01 C5 C5 57 DA C5 E9 73 F1 3E C5 95 58 0D ?? ?? ?? ?? C5 85 58 3D ?? ?? ?? ?? C5 F5 59 F5 C5 45 59 C5 C4 43 6D 18 D1 01 C5 4D 58 0D ?? ?? ?? ?? C4 C1 2D C2 D3 0C C5 3D 58 15 ?? ?? ?? ?? C5 B5 59 ED C5 AD 59 CC C5 D5 58 2D ?? ?? ?? ?? C5 ED 55 E1 C5 6D 54 D5 C4 C1 5D 56 F2 C5 ED 54 E1 C5 ED 55 D5 C5 DD 56 FA C5 4D 5E C7 C5 BD 57 CB 85 C0 75 6E C5 FC 10 B4 24 70 01 00 00 C5 FC 10 BC 24 10 02 00 00 C5 7C 10 84 24 30 02 00 00 C5 7C 10 8C 24 50 02 00 00 C5 7C 10 94 24 F0 01 00 00 C5 7C 10 9C 24 90 02 00 00 C5 7C 10 A4 24 B0 01 00 00 C5 7C 10 AC 24 90 01 00 00 C5 7C 10 B4 24 70 02 00 00 C5 7C 10 BC 24 D0 01 00 00 4C 8B AC 24 B0 02 00 00 C5 FD 28 C1 48 81 C4 B8 02 00 00 C3 C4 C1 7D 11 45 00 C4 C1 7D 11 4D 40 74 84 33 D2 48 89 5C 24 28 8B DA 48 89 74 24 20 8B F0 0F A3 DE 72 1C FF C3 83 FB 20 7C F4 48 8B 5C 24 28 48 8B 74 24 20 C4 C1 7D 10 4D 40 E9 53 FF FF FF C5 F8 77 49 8D 4C DD 00 49 8D 54 DD 40 E8 ?? ?? ?? ?? EB D0 C5 FD 10 15 ?? ?? ?? ?? 41 B8 00 00 F0 7F C4 C1 7D 11 45 00 C4 C1 79 6E F0 C5 6D 54 D5 C5 2D C2 CA 00 C5 F9 70 D6 11 C5 69 DB D0 C4 43 7D 19 CB 01 C4 C3 7D 19 C7 01 C4 C1 30 C6 DB DD C4 41 69 DB CF C4 C1 51 73 D1 34 C4 C1 21 73 D2 34 C4 C1 79 7E EA C5 79 7E D9 C5 FA 6F 15 ?? ?? ?? ?? C5 F8 11 44 24 20 C5 E9 DB C0 C4 C3 79 16 E8 02 47 8D 14 52 C4 43 79 16 DB 02 44 8D 0C 49 41 C1 E2 03 41 C1 E1 03 43 8D 0C 40 C1 E1 03 47 8D 1C 5B 41 C1 E3 03 C4 41 F9 6E 34 12 C5 7A 6F 0D ?? ?? ?? ?? C4 C1 F9 6E 4C 12 08 C5 F8 50 C3 C5 78 11 7C 24 30 C4 41 69 DB FF C4 C1 F9 6E 1C 11 C4 C1 F9 6E 74 11 10 C5 09 16 14 11 C4 41 79 D4 F1 C5 71 16 6C 11 08 C4 41 61 16 04 13 C4 C1 49 16 4C 13 10 C4 41 F9 6E 64 11 08 C5 E9 73 D1 20 C4 C1 F9 6E 7C 12 10 41 B9 00 00 00 80 C4 C1 01 D4 F1 C5 7A 6F 3D ?? ?? ?? ?? C5 79 11 54 24 50 C4 41 09 DB CF C4 C1 19 16 64 13 08 C4 41 29 DB E7 C5 C1 16 5C 11 10 48 8D 15 ?? ?? ?? ?? C4 C1 39 DB FF C4 C1 29 73 D6 20 C4 C1 71 DB CF C5 79 11 44 24 40 C4 C1 39 73 D5 20 C5 FA 7F 7C 24 60 C4 C1 11 DB C7 C5 91 73 D6 20 C4 41 49 DB F7 C5 B1 F4 F7 C4 C1 59 DB EF C5 A9 F4 F9 C5 F1 73 D7 20 C5 A1 73 D4 20 C5 A9 F4 FA C5 D9 73 D3 20 C5 B1 F4 D2 C5 FA 7F B4 24 B0 00 00 00 C5 E9 73 D2 20 C5 B1 F4 F5 C4 C1 61 DB DF C5 A9 F4 ED C5 C1 D4 FA C5 91 F4 D4 C5 89 F4 E4 C5 7A 7F 64 24 70 C4 41 09 F4 E4 C5 7A 7F 84 24 90 00 00 00 C5 FA 7F 84 24 A0 00 00 00 C5 7A 7F A4 24 C0 00 00 00 C4 41 09 F4 E0 C5 09 F4 C0 C4 C1 49 DB C7 C5 F9 D4 C7 C5 F1 D4 F8 C5 91 F4 C3 C5 F1 73 D0 20 C5 F9 73 D4 20 C5 E9 D4 D0 C5 7A 7F 9C 24 80 00 00 00 C4 C1 39 DB DF C4 41 31 F4 DB C5 F9 73 D7 20 C5 E1 D4 DA C5 E9 73 D6 20 C4 C1 39 73 D0 20 C5 F1 D4 E3 C5 D1 D4 DA C4 C1 21 DB CF C4 C1 21 73 D3 20 C5 F1 D4 EB C5 F9 D4 F5 C5 91 F4 84 24 A0 00 00 00 C4 C1 79 D4 C0 C4 C1 19 DB CF C5 E1 73 D4 20 C5 F1 D4 D0 C5 A9 F4 8C 24 80 00 00 00 C5 29 F4 54 24 60 C5 61 D4 C2 C4 C1 71 D4 C3 C5 FA 6F 9C 24 B0 00 00 00 C5 D1 73 D6 20 C4 C1 61 DB D7 C4 C1 19 73 D4 20 C5 E9 D4 D0 C5 D1 D4 EA C5 91 F4 94 24 90 00 00 00 C5 11 F4 6C 24 70 C4 C1 69 D4 D4 C5 FA 6F 8C 24 C0 00 00 00 C4 C1 21 73 D0 20 C4 C1 71 DB C7 C5 99 73 F6 20 C5 F9 D4 C2 C5 A1 D4 D0 C5 79 10 5C 24 40 C5 F9 73 D5 20 C4 C1 21 73 D3 20 C4 C1 51 DB EF C4 41 31 F4 CB C5 A1 73 D3 20 C4 41 29 D4 D3 C4 41 31 DB CF C4 C1 39 73 F0 20 C4 41 31 D4 CA C4 C1 79 D4 C1 C5 79 10 4C 24 50 C5 E1 73 F0 20 C4 C1 21 73 D1 20 C5 B1 73 D1 20 C4 41 09 F4 F3 C5 F9 73 D2 20 C5 61 D4 D5 C4 C1 11 D4 D9 C4 41 09 DB DF C4 41 79 6E E9 C5 A1 D4 EB C5 F9 D4 C5 C5 89 73 F0 20 C4 C1 69 DB D7 C4 C1 79 70 F5 11 C4 C1 41 DB CF C4 41 59 DB FF C4 C1 59 73 D2 0C C5 89 D4 D2 C4 41 39 D4 CF C5 99 D4 F9 C5 49 DB 74 24 20 C5 E1 73 D2 0C C5 7A 6F 3D ?? ?? ?? ?? C5 49 DB 6C 24 30 C4 C1 09 EF C7 C4 41 11 EF C7 C5 59 EB D8 C4 C1 61 EB E8 C4 E3 25 18 CD 01 C5 7A 6F 1D ?? ?? ?? ?? C4 C1 09 EF EB C4 C1 11 EF DB C5 7A 6F 1D ?? ?? ?? ?? C4 62 7D 1A 25 ?? ?? ?? ?? C5 9D 58 E1 C4 C1 5D 5C F4 C5 21 DB E7 C4 41 21 DB D9 C5 C1 73 D7 18 C4 C1 31 73 D1 18 C5 F5 5C C6 C4 C1 71 73 F4 1C C4 C1 19 73 F3 1C C5 F1 EB CD C5 19 EB DB C5 FA 6F 35 ?? ?? ?? ?? C4 43 75 18 E3 01 C4 E3 55 18 DB 01 C5 1D 5C E3 C5 FA 6F 1D ?? ?? ?? ?? C4 41 61 DB D2 C5 E1 DB D2 C5 7A 6F 1D ?? ?? ?? ?? C4 C1 29 73 F2 28 C5 E1 73 F2 28 C4 41 09 EF F3 C5 29 EB D7 C4 C1 11 EF EB C4 C1 61 EB C9 C4 41 29 EB DE C5 71 EB ED C4 C3 25 18 FD 01 C4 E3 0D 18 ED 01 C5 45 5C D5 C4 C1 7D 58 D2 C5 FD 5C C2 C5 AD 58 C0 C4 C1 7D 58 DC C4 62 7D 1A 25 ?? ?? ?? ?? C4 41 6D 54 CC C4 41 6D 5C F1 C4 62 7D 1A 1D ?? ?? ?? ?? C4 62 7D 1A 15 ?? ?? ?? ?? C4 E2 7D 1A 2D ?? ?? ?? ?? C4 41 2D 59 E6 C4 C1 55 59 C9 C5 25 59 EB C4 C1 55 59 FE C4 C1 2D 59 C1 C5 1D 58 D1 C5 95 58 D7 C5 2D 58 CA C4 41 7D 58 E1 C4 C1 7D 5C C4 C4 41 7D 58 D1 C4 C1 7D 10 45 00 C4 62 7D 1A 1D ?? ?? ?? ?? C4 C1 7D 54 DB C5 7A 6F 1D ?? ?? ?? ?? C4 E2 7D 1A 2D ?? ?? ?? ?? C5 E5 C2 FD 1E C5 65 C2 F5 12 C5 8D 54 C8 C4 41 45 54 EC C4 C1 75 56 D5 C4 41 45 54 CA C4 C1 6D 58 D1 C4 C3 7D 19 E0 01 C5 D9 DB E6 C5 39 DB C6 C4 41 59 DB D3 C4 41 39 DB CB C4 41 79 7E D3 C5 79 7E C9 45 6B CB 68 6B C9 68 C4 43 79 16 D0 02 C4 43 79 16 CA 02 45 6B C0 68 45 6B DA 68 C4 C1 F9 6E B4 11 40 01 00 00 C4 61 F9 6E 9C 11 40 01 00 00 C4 41 F9 6E 84 11 50 01 00 00 C4 61 F9 6E B4 11 50 01 00 00 C4 41 49 16 94 10 40 01 00 00 C4 C1 21 16 9C 13 40 01 00 00 C4 C1 F9 6E 8C 11 58 01 00 00 C4 41 F9 6E 9C 11 68 01 00 00 C4 C1 39 16 AC 10 50 01 00 00 C4 E1 F9 6E B4 11 58 01 00 00 C4 61 F9 6E 84 11 68 01 00 00 C4 41 09 16 A4 13 50 01 00 00 C4 41 71 16 AC 10 58 01 00 00 C4 C1 49 16 A4 13 58 01 00 00 C4 41 F9 6E B4 11 70 01 00 00 C4 E1 F9 6E 8C 11 70 01 00 00 C4 C1 71 16 B4 13 70 01 00 00 C4 E3 2D 18 FB 01 C4 C1 21 16 9C 10 68 01 00 00 C4 43 55 18 CC 01 C4 C1 39 16 AC 13 68 01 00 00 C4 41 09 16 A4 10 70 01 00 00 C4 63 15 18 D4 01 C4 C1 F9 6E A4 11 78 01 00 00 C4 41 59 16 9C 10 78 01 00 00 C4 63 65 18 ED 01 C4 E1 F9 6E 9C 11 78 01 00 00 C4 41 61 16 84 13 78 01 00 00 C4 C1 F9 6E AC 11 80 01 00 00 C5 15 59 EA C4 63 1D 18 F6 01 C4 E1 F9 6E B4 11 80 01 00 00 C4 41 51 16 A4 10 80 01 00 00 C4 C1 49 16 A4 13 80 01 00 00 C4 C1 F9 6E B4 11 90 01 00 00 C4 C3 25 18 C8 01 C4 41 F9 6E 9C 11 88 01 00 00 C4 61 F9 6E 84 11 88 01 00 00 C4 C1 21 16 9C 10 88 01 00 00 C4 61 F9 6E 9C 11 90 01 00 00 C5 F5 59 CA C4 E3 1D 18 EC 01 C4 41 39 16 A4 13 88 01 00 00 C4 41 F9 6E 84 11 98 01 00 00 C4 C1 49 16 A4 10 90 01 00 00 C4 C1 39 16 B4 10 98 01 00 00 C4 43 65 18 E4 01 C4 C1 21 16 9C 13 90 01 00 00 C4 61 F9 6E 9C 11 98 01 00 00 C4 41 21 16 84 13 98 01 00 00 C5 1D 59 E2 C5 9D 58 ED C4 E3 5D 18 DB 01 C4 C1 F9 6E A4 11 A0 01 00 00 C4 41 59 16 9C 10 A0 01 00 00 C4 43 4D 18 C0 01 C4 E1 F9 6E B4 11 A0 01 00 00 C4 C1 49 16 A4 13 A0 01 00 00 C5 3D 59 C2 C5 BD 58 DB C4 63 25 18 DC 01 C5 C5 5C E2 C5 FD 5A FC C5 F8 53 F7 C5 FC 5A F6 C5 DD 59 E6 C4 43 05 18 FF 01 C5 85 5C FC C5 C5 59 E7 C5 5D 58 FF C5 CD 59 FC C5 C5 58 E6 C4 41 5D 59 FF C5 85 58 F6 C4 41 15 58 FA C4 41 4D 59 D1 C5 6D 59 CA C4 41 2D 58 D7 C4 41 75 58 FE C4 41 25 59 D9 C4 C1 35 59 C9 C4 41 55 59 C9 C5 25 58 F3 C4 C1 35 58 DF C5 0D 59 F1 C5 8D 58 E3 C5 DD 59 D2 C4 C1 6D 58 CA E9 60 F7 FF FF 66 0F 1F 44 00 00 }
	condition:
		$1
}

rule file_140_0_0 {
	meta:
		name = "__avx_ceilf8"
		size = 16
	strings:
		$1 = { C4 E3 7D 08 C0 02 C3 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_143_0_0 {
	meta:
		name = "__avx_log4"
		size = 640
		refs = "000a __common_dlog_data 0274 __common_dlog_cout_rare"
	strings:
		$1 = { 48 81 EC 18 02 00 00 48 8D 05 ?? ?? ?? ?? C5 FC 11 B4 24 F0 01 00 00 4C 89 AC 24 10 02 00 00 4C 8D AC 24 8F 01 00 00 C5 FD 54 1D ?? ?? ?? ?? 49 83 E5 C0 C5 E5 56 35 ?? ?? ?? ?? C5 FD 5A EE C5 F8 53 CD C5 FC 5A D1 C4 E3 7D 09 D2 00 C5 E1 73 D0 14 C4 E3 7D 19 C4 01 C5 D1 73 D4 14 C5 E0 C6 CD DD C5 FD C2 1D ?? ?? ?? ?? 11 C5 FD C2 25 ?? ?? ?? ?? 16 C5 FE E6 C9 C5 E5 56 E4 C4 E3 7D 19 E3 01 C5 D8 C6 EB DD C5 CD 54 25 ?? ?? ?? ?? C5 CD 5C F4 C5 F8 50 D5 C5 DD 59 E2 C5 CD 59 F2 C5 DD 5C 1D ?? ?? ?? ?? C5 E5 58 DE C5 C9 73 D2 28 C4 E3 7D 19 D5 01 C5 D1 73 D5 28 C4 C1 79 7E E9 C5 ED C2 15 ?? ?? ?? ?? 1E C5 F9 7E F1 4D 63 C9 C4 C3 79 16 EA 02 4D 63 D2 C4 C3 79 16 F0 02 C4 C1 7B 10 B4 01 40 A0 BF FF C5 ED 54 15 ?? ?? ?? ?? C4 C1 49 16 AC 02 40 A0 BF FF C5 ED 56 35 ?? ?? ?? ?? C5 F5 5C CE C5 E5 59 35 ?? ?? ?? ?? C5 F5 59 15 ?? ?? ?? ?? C5 CD 58 0D ?? ?? ?? ?? C5 E5 59 F3 48 63 C9 4D 63 C0 C5 F5 59 CE C5 FB 10 A4 01 40 A0 BF FF C4 C1 59 16 A4 00 40 A0 BF FF C4 E3 5D 18 E5 01 C5 E5 59 2D ?? ?? ?? ?? C5 D5 58 2D ?? ?? ?? ?? C5 F5 58 CD C5 F5 59 EE C5 E5 58 DD C5 E5 58 E4 C5 DD 58 CA 85 D2 75 1D C5 FC 10 B4 24 F0 01 00 00 4C 8B AC 24 10 02 00 00 C5 FD 28 C1 48 81 C4 18 02 00 00 C3 C4 C1 7D 11 45 00 C4 C1 7D 11 4D 40 74 D5 33 C0 C5 FC 11 BC 24 20 01 00 00 C5 7C 11 84 24 00 01 00 00 C5 7C 11 8C 24 E0 00 00 00 C5 7C 11 94 24 C0 00 00 00 C5 7C 11 9C 24 A0 00 00 00 C5 7C 11 A4 24 80 00 00 00 C5 7C 11 6C 24 60 C5 7C 11 74 24 40 C5 7C 11 7C 24 20 48 89 9C 24 48 01 00 00 8B D8 48 89 B4 24 40 01 00 00 8B F2 0F A3 DE 72 6A FF C3 83 FB 20 7C F4 C5 FC 10 BC 24 20 01 00 00 C5 7C 10 84 24 00 01 00 00 C5 7C 10 8C 24 E0 00 00 00 C5 7C 10 94 24 C0 00 00 00 C5 7C 10 9C 24 A0 00 00 00 C5 7C 10 A4 24 80 00 00 00 C5 7C 10 6C 24 60 C5 7C 10 74 24 40 C5 7C 10 7C 24 20 C4 C1 7D 10 4D 40 48 8B 9C 24 48 01 00 00 48 8B B4 24 40 01 00 00 E9 08 FF FF FF C5 F8 77 49 8D 4C DD 00 49 8D 54 DD 40 E8 ?? ?? ?? ?? EB 82 66 0F 1F 44 00 00 }
	condition:
		$1
}

rule file_144_0_0 {
	meta:
		name = "__common_datan2_cout_rare"
		size = 4464
		refs = "0011 _vmldAtanHATab"
	strings:
		$1 = { 57 48 81 EC C0 00 00 00 0F 29 74 24 70 F2 0F 10 35 ?? ?? ?? ?? F2 0F 10 01 0F 28 CE F2 0F 59 C1 F2 0F 59 0A F2 0F 11 44 24 38 F2 0F 11 4C 24 40 0F B7 44 24 3E 25 F0 7F 00 00 8A 54 24 47 44 0F B7 5C 24 46 80 E2 80 41 81 E3 F0 7F 00 00 C1 E8 04 8A 4C 24 3F C0 E9 07 C0 EA 07 44 0F 29 BC 24 90 00 00 00 44 0F 29 AC 24 A0 00 00 00 44 0F 29 9C 24 80 00 00 00 44 0F 29 84 24 B0 00 00 00 41 C1 EB 04 48 8B 3D ?? ?? ?? ?? 3D FF 07 00 00 0F 84 64 10 00 00 41 81 FB FF 07 00 00 0F 84 9C 0F 00 00 85 C0 75 15 F7 44 24 3C FF FF 0F 00 75 0B 83 7C 24 38 00 0F 84 AC 0E 00 00 45 85 DB 75 15 F7 44 24 44 FF FF 0F 00 75 0B 83 7C 24 40 00 0F 84 7F 0E 00 00 41 F7 DB F2 0F 11 44 24 38 44 03 D8 F2 0F 11 4C 24 40 44 8A 54 24 3F 44 8A 4C 24 47 41 80 E2 7F 41 80 E1 7F 41 83 FB CA 0F 8E B3 0D 00 00 41 83 FB 36 0F 8D 5E 0D 00 00 44 88 4C 24 47 84 D2 44 88 54 24 3F 75 0F F2 44 0F 10 05 ?? ?? ?? ?? 45 0F 28 D8 EB 12 F2 44 0F 10 05 ?? ?? ?? ?? F2 44 0F 10 1D ?? ?? ?? ?? F2 0F 10 4C 24 38 85 C0 F2 0F 10 6C 24 40 0F 28 D1 F2 0F 5E D5 4C 8B 4C 24 38 F2 0F 11 54 24 58 0F 8E C0 0E 00 00 3D FE 07 00 00 7D 24 4C 89 4C 24 38 05 01 FC FF FF 49 C1 E9 30 41 81 E1 0F 80 FF FF 41 81 C9 F0 3F FF FF 66 44 89 4C 24 3E EB 17 F2 0F 10 05 ?? ?? ?? ?? B8 FE 03 00 00 F2 0F 59 C8 F2 0F 11 4C 24 38 F7 D8 05 FF 03 00 00 48 89 7C 24 40 25 FF 07 00 00 48 C1 EF 30 C1 E0 04 81 E7 0F 80 FF FF 0B F8 66 89 7C 24 46 F2 0F 10 44 24 40 F2 0F 59 E8 66 0F 2F 15 ?? ?? ?? ?? 0F 82 03 08 00 00 F2 0F 10 25 ?? ?? ?? ?? 0F 28 C5 F2 0F 59 C4 B8 71 00 00 00 F2 0F 11 44 24 20 0F 28 C5 F2 44 0F 10 7C 24 20 F2 0F 11 54 24 40 F2 44 0F 5C FD F2 44 0F 11 7C 24 28 F2 0F 10 5C 24 20 F2 0F 10 54 24 28 44 8B 54 24 44 45 8B DA 41 81 E2 00 00 08 00 41 81 E3 00 00 F0 FF 41 81 CA 00 00 04 00 F2 0F 5C DA F2 0F 11 5C 24 20 45 0B DA F2 0F 10 4C 24 20 4C 8D 15 ?? ?? ?? ?? C7 44 24 40 00 00 00 00 F2 0F 5C C1 44 89 5C 24 44 4D 8B DA F2 0F 11 44 24 28 F2 0F 10 5C 24 20 F2 0F 10 4C 24 40 F2 0F 10 44 24 28 F2 0F 59 D9 F2 0F 59 C1 F2 44 0F 10 2D ?? ?? ?? ?? F2 41 0F 59 DD F2 41 0F 59 C5 44 0F 28 FB 44 0F B7 4C 24 5E F2 44 0F 58 F8 F2 44 0F 11 7C 24 20 41 81 E1 F0 7F 00 00 F2 0F 10 54 24 20 41 C1 E9 04 F2 0F 5C DA 8B 7C 24 5C F2 0F 58 D8 F2 0F 10 44 24 38 81 E7 FF FF 0F 00 F2 0F 11 5C 24 28 44 0F 28 F8 F2 0F 10 54 24 20 F2 44 0F 10 6C 24 28 F2 44 0F 58 FA F2 44 0F 11 7C 24 20 44 0F 28 F8 F2 0F 10 5C 24 20 41 C1 E1 14 F2 44 0F 5C FB F2 44 0F 11 7C 24 28 44 0B CF F2 44 0F 10 7C 24 20 41 81 C1 00 00 40 C0 F2 0F 10 5C 24 28 41 C1 F9 13 F2 44 0F 58 FB F2 44 0F 11 7C 24 30 44 0F 28 F8 F2 0F 10 5C 24 28 41 83 F9 71 F2 0F 58 D3 F2 0F 11 54 24 28 41 0F 4C C1 F2 0F 10 54 24 30 03 C0 48 63 C0 F2 44 0F 5C FA F2 44 0F 11 7C 24 30 F2 0F 10 5C 24 28 F2 0F 10 54 24 30 F2 0F 58 DA F2 0F 11 5C 24 30 F2 0F 10 5C 24 20 F2 0F 10 54 24 30 F2 41 0F 58 D5 44 0F 28 EB F2 44 0F 59 EC F2 44 0F 11 6C 24 20 F2 44 0F 10 7C 24 20 F2 44 0F 5C FB F2 44 0F 11 7C 24 28 F2 44 0F 10 7C 24 20 F2 44 0F 10 6C 24 28 F2 45 0F 5C FD F2 44 0F 11 7C 24 20 44 0F 28 F8 F2 44 0F 10 6C 24 20 F2 44 0F 59 3D ?? ?? ?? ?? F2 41 0F 5C DD F2 0F 11 5C 24 28 F2 0F 10 5C 24 20 F2 44 0F 10 6C 24 28 F2 44 0F 11 7C 24 20 F2 41 0F 58 D5 F2 44 0F 10 6C 24 20 F2 44 0F 5C 6C 24 38 F2 44 0F 11 6C 24 28 F2 44 0F 10 6C 24 20 F2 44 0F 10 7C 24 28 F2 45 0F 5C EF F2 44 0F 11 6C 24 20 F2 44 0F 10 7C 24 20 F2 41 0F 5C C7 F2 0F 11 44 24 28 F2 0F 10 44 24 20 F2 44 0F 10 6C 24 28 F2 0F 59 C1 F2 44 0F 59 E9 0F 28 C8 F2 41 0F 58 CD F2 0F 11 4C 24 20 F2 44 0F 10 7C 24 20 F2 41 0F 5C C7 F2 41 0F 58 C5 44 0F 28 ED F2 0F 11 44 24 28 F2 0F 10 44 24 20 F2 44 0F 10 7C 24 28 F2 44 0F 58 E8 F2 44 0F 11 6C 24 20 44 0F 28 ED F2 0F 10 4C 24 20 F2 44 0F 5C E9 F2 44 0F 11 6C 24 28 F2 44 0F 10 6C 24 20 F2 0F 10 4C 24 28 F2 44 0F 58 E9 F2 44 0F 11 6C 24 30 F2 0F 10 4C 24 28 F2 0F 58 C1 F2 0F 11 44 24 28 F2 0F 10 44 24 30 F2 0F 5C E8 F2 0F 11 6C 24 30 F2 0F 10 44 24 28 F2 0F 10 6C 24 30 F2 0F 58 C5 F2 0F 11 44 24 30 F2 44 0F 10 6C 24 20 F2 0F 10 4C 24 30 F2 41 0F 58 CF 45 0F 28 FD F2 44 0F 59 FC F2 44 0F 11 7C 24 20 44 0F 28 FE F2 0F 10 44 24 20 F2 41 0F 5C C5 F2 0F 11 44 24 28 F2 0F 10 44 24 20 F2 0F 10 6C 24 28 F2 0F 5C C5 F2 0F 11 44 24 20 F2 0F 10 6C 24 20 F2 44 0F 5C ED F2 44 0F 11 6C 24 28 F2 0F 10 6C 24 20 F2 44 0F 5E FD 41 0F 28 C7 F2 0F 59 C4 F2 44 0F 10 6C 24 28 F2 0F 11 44 24 28 F2 41 0F 58 CD F2 0F 10 44 24 28 F2 41 0F 5C C7 F2 0F 11 44 24 30 F2 0F 10 44 24 28 F2 44 0F 10 6C 24 30 F2 41 0F 5C C5 F2 0F 11 44 24 30 F2 44 0F 10 6C 24 30 F2 41 0F 59 ED F2 0F 5C F5 F2 0F 10 6C 24 30 F2 0F 59 CD F2 0F 11 4C 24 28 F2 0F 10 4C 24 28 F2 0F 5C F1 F2 0F 11 74 24 28 F2 0F 10 6C 24 28 48 8B 7C 24 30 F2 0F 10 74 24 28 F2 0F 10 44 24 30 48 89 7C 24 48 F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 EE F2 0F 59 E8 F2 0F 10 74 24 48 44 0F 28 ED 0F 28 C6 F2 0F 59 C3 F2 44 0F 59 EA F2 0F 59 DD F2 0F 59 D6 F2 44 0F 58 EB 44 0F 28 F8 F2 44 0F 58 EA F2 44 0F 11 6C 24 20 F2 0F 10 54 24 20 F2 0F 10 1D ?? ?? ?? ?? F2 44 0F 58 FA F2 44 0F 11 7C 24 20 F2 0F 10 4C 24 20 F2 0F 5C C1 F2 0F 58 C2 F2 0F 11 44 24 28 F2 44 0F 10 7C 24 20 41 0F 28 F7 41 0F 28 EF F2 41 0F 59 F7 F2 0F 59 EC F2 0F 59 DE F2 0F 10 44 24 28 F2 0F 11 6C 24 20 F2 44 0F 10 6C 24 20 F2 0F 58 1D ?? ?? ?? ?? F2 45 0F 5C EF F2 0F 59 DE F2 44 0F 11 6C 24 28 F2 0F 10 54 24 20 F2 0F 10 4C 24 28 F2 0F 58 1D ?? ?? ?? ?? F2 0F 5C D1 F2 0F 59 DE F2 0F 11 54 24 20 F2 0F 58 1D ?? ?? ?? ?? F2 0F 59 DE F2 0F 58 1D ?? ?? ?? ?? F2 0F 59 DE F2 0F 58 1D ?? ?? ?? ?? F2 0F 59 DE F2 0F 58 1D ?? ?? ?? ?? F2 0F 59 F3 F2 0F 10 5C 24 20 F2 0F 59 E6 F2 44 0F 5C FB F2 44 0F 11 7C 24 28 F2 44 0F 10 6C 24 20 F2 44 0F 10 7C 24 28 F2 0F 11 64 24 20 F2 41 0F 58 C7 F2 0F 10 64 24 20 F2 0F 5C E6 F2 0F 11 64 24 28 F2 0F 10 4C 24 20 F2 0F 10 6C 24 28 F2 0F 5C CD F2 0F 11 4C 24 20 F2 0F 10 54 24 20 F2 0F 5C F2 F2 0F 11 74 24 28 F2 0F 10 74 24 20 F2 0F 10 5C 24 28 0F 28 EE 44 0F 28 FB F2 44 0F 59 F8 F2 0F 59 F0 F2 41 0F 59 DD F2 41 0F 59 ED F2 44 0F 58 FE 0F 28 CD 0F 28 D5 F2 44 0F 58 FB F2 41 0F 58 CD F2 44 0F 11 7C 24 20 F2 0F 10 74 24 20 F2 0F 11 4C 24 20 F2 0F 10 64 24 20 F2 0F 5C D4 F2 0F 11 54 24 28 F2 0F 10 5C 24 20 F2 0F 10 4C 24 28 F2 0F 58 D9 F2 0F 11 5C 24 30 F2 0F 10 64 24 28 F2 44 0F 58 EC F2 44 0F 11 6C 24 28 F2 44 0F 10 6C 24 30 F2 41 0F 5C ED F2 0F 11 6C 24 30 F2 0F 10 54 24 28 F2 0F 10 4C 24 30 F2 0F 58 D1 F2 0F 11 54 24 30 4C 8B 4C 24 20 4C 89 4C 24 48 F2 0F 10 4C 24 48 0F 28 E1 F2 0F 10 5C 24 30 F2 41 0F 58 24 C2 F2 0F 58 C3 F2 0F 11 64 24 20 F2 0F 58 C6 F2 0F 10 6C 24 20 0F 28 F1 F2 0F 11 44 24 50 F2 0F 5C F5 F2 0F 11 74 24 28 F2 44 0F 10 7C 24 20 F2 44 0F 10 6C 24 28 F2 45 0F 58 FD F2 44 0F 11 7C 24 30 F2 0F 10 64 24 28 F2 41 0F 58 24 C3 F2 0F 11 64 24 28 F2 0F 10 6C 24 30 F2 0F 5C CD F2 0F 11 4C 24 30 F2 0F 10 5C 24 28 F2 0F 10 54 24 30 F2 0F 58 DA F2 0F 11 5C 24 30 4C 8B 4C 24 20 F2 0F 10 4C 24 30 4C 89 4C 24 48 48 8D 3D ?? ?? ?? ?? F2 0F 58 C1 C0 E1 07 F2 0F 58 44 C7 08 8A C2 C0 E0 07 F2 0F 11 44 24 50 41 0F 28 C0 49 C1 E9 38 44 8A 54 24 57 45 8A DA 41 C0 EA 07 41 80 E3 7F 41 80 E1 7F 41 32 D2 44 0A C8 44 88 4C 24 4F F2 0F 10 74 24 48 0F 28 D6 F2 0F 58 C6 C0 E2 07 F2 0F 11 44 24 20 F2 0F 10 4C 24 20 F2 0F 5C D1 F2 0F 11 54 24 28 44 0A DA F2 0F 10 64 24 20 F2 0F 10 5C 24 28 44 88 5C 24 57 F2 0F 58 E3 F2 0F 11 64 24 30 F2 0F 10 6C 24 28 F2 44 0F 58 C5 F2 44 0F 11 44 24 28 F2 44 0F 10 44 24 30 F2 41 0F 5C F0 F2 0F 11 74 24 30 F2 44 0F 10 7C 24 28 F2 44 0F 10 6C 24 30 F2 45 0F 58 FD F2 44 0F 11 7C 24 30 48 8B 54 24 20 F2 0F 10 44 24 30 48 89 54 24 48 F2 0F 58 44 24 50 F2 41 0F 58 C3 F2 44 0F 10 5C 24 48 F2 0F 11 44 24 50 F2 44 0F 58 D8 F2 44 0F 11 5C 24 60 8A 44 24 67 24 7F 0A C1 88 44 24 67 48 8B 4C 24 60 49 89 08 E9 0A 06 00 00 F2 0F 10 4C 24 38 44 8A CA 0F 28 C1 F2 0F 59 05 ?? ?? ?? ?? 41 C0 E1 07 C0 E1 07 F2 0F 11 44 24 20 F2 0F 10 54 24 20 F2 0F 10 05 ?? ?? ?? ?? F2 0F 5C 54 24 38 F2 0F 11 54 24 28 0F 28 D5 F2 0F 10 64 24 20 F2 44 0F 10 6C 24 28 F2 0F 59 D0 F2 41 0F 5C E5 F2 0F 11 64 24 20 F2 44 0F 10 7C 24 20 F2 41 0F 5C CF F2 0F 11 4C 24 28 F2 0F 10 4C 24 20 F2 0F 10 5C 24 28 F2 0F 11 54 24 20 0F 28 D6 F2 0F 10 64 24 20 F2 0F 5C E5 F2 0F 11 64 24 28 F2 44 0F 10 7C 24 20 F2 44 0F 10 6C 24 28 F2 45 0F 5C FD F2 44 0F 11 7C 24 20 F2 0F 10 64 24 20 F2 0F 5C EC F2 0F 11 6C 24 28 F2 44 0F 10 7C 24 20 F2 41 0F 5E D7 0F 28 EA F2 0F 59 E8 F2 0F 10 64 24 28 F2 0F 11 6C 24 28 F2 44 0F 10 6C 24 28 F2 44 0F 5C EA F2 44 0F 11 6C 24 30 F2 0F 10 54 24 28 F2 0F 10 6C 24 30 F2 0F 5C D5 F2 0F 11 54 24 30 F2 0F 10 6C 24 30 F2 44 0F 59 FD F2 41 0F 5C F7 F2 44 0F 10 7C 24 30 F2 41 0F 59 E7 F2 0F 11 64 24 28 F2 0F 10 64 24 28 F2 0F 5C F4 F2 0F 11 74 24 28 F2 0F 10 6C 24 28 48 8B 44 24 30 F2 0F 10 74 24 28 F2 0F 10 64 24 30 48 89 44 24 48 F2 0F 10 54 24 48 44 0F 28 EA F2 0F 58 2D ?? ?? ?? ?? F2 44 0F 59 E9 F2 0F 59 D3 F2 0F 59 EE F2 0F 59 EC 44 0F 28 FD F2 44 0F 59 FB F2 0F 59 CD F2 44 0F 58 F9 41 0F 28 CD F2 44 0F 58 FA F2 44 0F 11 7C 24 20 F2 0F 10 5C 24 20 F2 0F 58 CB F2 0F 11 4C 24 20 F2 0F 10 74 24 20 F2 44 0F 5C EE F2 44 0F 58 EB F2 0F 10 1D ?? ?? ?? ?? F2 44 0F 11 6C 24 28 F2 44 0F 10 6C 24 58 F2 45 0F 59 ED F2 41 0F 59 DD F2 0F 10 54 24 20 0F 28 F2 F2 0F 58 1D ?? ?? ?? ?? F2 0F 59 F0 F2 41 0F 59 DD F2 0F 10 64 24 28 F2 0F 11 74 24 20 F2 0F 10 6C 24 20 F2 0F 58 1D ?? ?? ?? ?? F2 0F 5C EA F2 41 0F 59 DD F2 0F 11 6C 24 28 F2 44 0F 10 7C 24 20 F2 0F 10 4C 24 28 F2 0F 58 1D ?? ?? ?? ?? F2 44 0F 5C F9 F2 41 0F 59 DD F2 44 0F 11 7C 24 20 F2 0F 58 1D ?? ?? ?? ?? F2 41 0F 59 DD F2 0F 58 1D ?? ?? ?? ?? F2 41 0F 59 DD F2 0F 58 1D ?? ?? ?? ?? F2 41 0F 59 DD F2 44 0F 10 6C 24 20 F2 0F 59 C3 F2 41 0F 5C D5 F2 0F 11 54 24 28 F2 0F 10 4C 24 20 F2 0F 10 54 24 28 F2 0F 11 44 24 20 F2 0F 58 E2 F2 0F 10 44 24 20 F2 0F 5C C3 F2 0F 11 44 24 28 F2 0F 10 6C 24 20 F2 0F 10 74 24 28 F2 0F 5C EE F2 0F 11 6C 24 20 F2 0F 10 44 24 20 F2 0F 5C D8 F2 0F 11 5C 24 28 F2 0F 10 54 24 20 F2 0F 10 5C 24 28 0F 28 EA 44 0F 28 EB F2 44 0F 59 EC F2 0F 59 D4 F2 0F 59 D9 F2 0F 59 E9 F2 44 0F 58 EA 44 0F 28 FD 0F 28 D5 F2 44 0F 58 EB F2 44 0F 58 F9 F2 44 0F 11 6C 24 20 F2 0F 10 74 24 20 F2 44 0F 11 7C 24 20 F2 0F 10 44 24 20 F2 0F 5C D0 F2 0F 11 54 24 28 F2 44 0F 10 6C 24 20 F2 0F 10 5C 24 28 F2 44 0F 58 EB F2 44 0F 11 6C 24 30 F2 44 0F 10 7C 24 28 F2 41 0F 58 CF F2 0F 11 4C 24 28 F2 0F 10 4C 24 30 F2 0F 5C E9 F2 0F 11 6C 24 30 F2 0F 10 54 24 28 F2 0F 10 44 24 30 F2 0F 58 D0 F2 0F 11 54 24 30 48 8B 7C 24 20 F2 0F 10 4C 24 30 48 89 7C 24 48 F2 0F 58 E1 48 C1 EF 38 F2 0F 58 E6 40 80 E7 7F 41 0A F9 40 88 7C 24 4F F2 0F 11 64 24 50 41 0F 28 E0 F2 0F 10 6C 24 48 0F 28 C5 F2 0F 58 E5 F2 0F 11 64 24 20 F2 0F 10 64 24 20 44 8A 54 24 57 45 8A DA 41 C0 EA 07 F2 0F 5C C4 F2 0F 11 44 24 28 F2 0F 10 54 24 20 F2 0F 10 4C 24 28 41 32 D2 41 80 E3 7F C0 E2 07 F2 0F 58 D1 F2 0F 11 54 24 30 F2 0F 10 5C 24 28 F2 44 0F 58 C3 F2 44 0F 11 44 24 28 44 0A DA F2 44 0F 10 44 24 30 44 88 5C 24 57 F2 41 0F 5C E8 F2 0F 11 6C 24 30 F2 0F 10 4C 24 28 F2 0F 10 44 24 30 F2 0F 58 C8 F2 0F 11 4C 24 30 48 8B 54 24 20 F2 0F 10 54 24 30 48 89 54 24 48 F2 0F 58 54 24 50 F2 41 0F 58 D3 F2 44 0F 10 5C 24 48 F2 0F 11 54 24 50 F2 44 0F 58 DA F2 44 0F 11 5C 24 60 8A 44 24 67 24 7F 0A C1 88 44 24 67 48 8B 4C 24 60 49 89 08 E9 83 01 00 00 41 83 FB 4A 0F 8D F4 00 00 00 44 88 54 24 3F F2 0F 5E 4C 24 38 F2 0F 10 05 ?? ?? ?? ?? C0 E1 07 F2 0F 5C C1 F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 44 24 60 8A 44 24 67 24 7F 0A C1 88 44 24 67 48 8B 54 24 60 49 89 10 E9 38 01 00 00 84 D2 0F 85 03 01 00 00 44 88 54 24 3F 44 88 4C 24 47 F2 0F 10 4C 24 38 F2 0F 5E 4C 24 40 F2 0F 11 4C 24 60 0F B7 44 24 66 A9 F0 7F 00 00 74 36 C0 E1 07 F2 0F 58 F1 F2 0F 11 74 24 20 F2 0F 10 44 24 20 F2 0F 59 C8 F2 0F 11 4C 24 60 8A 44 24 67 24 7F 0A C1 88 44 24 67 48 8B 54 24 60 49 89 10 E9 D2 00 00 00 F2 0F 59 C9 C0 E1 07 F2 0F 11 4C 24 20 F2 0F 10 44 24 20 F2 0F 58 44 24 60 F2 0F 11 44 24 60 8A 44 24 67 24 7F 0A C1 88 44 24 67 48 8B 54 24 60 49 89 10 E9 9A 00 00 00 85 C0 75 11 F7 44 24 3C FF FF 0F 00 75 07 E9 EA 01 00 00 74 2F F2 0F 10 05 ?? ?? ?? ?? C0 E1 07 F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 44 24 60 8A 44 24 67 24 7F 0A C1 88 44 24 67 48 8B 54 24 60 49 89 10 EB 56 84 D2 75 25 C0 E1 07 48 8B 05 ?? ?? ?? ?? 48 89 44 24 60 48 C1 E8 38 24 7F 0A C1 88 44 24 67 48 8B 54 24 60 49 89 10 EB 2D F2 0F 10 05 ?? ?? ?? ?? C0 E1 07 F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 44 24 60 8A 44 24 67 24 7F 0A C1 88 44 24 67 48 8B 54 24 60 49 89 10 0F 28 74 24 70 33 C0 44 0F 28 84 24 B0 00 00 00 44 0F }
	condition:
		$1
}

rule file_146_0_0 {
	meta:
		name = "__sse2_log102"
		size = 496
		refs = "0022 __common_dlog10_data 0072 _2il0floatpacket_52 01e0 __common_dlog10_cout_rare"
	strings:
		$1 = { 48 81 EC E8 00 00 00 0F 28 E0 44 0F 29 BC 24 C0 00 00 00 0F 28 E8 44 0F 29 B4 24 D0 00 00 00 4C 8D 05 ?? ?? ?? ?? 4C 89 AC 24 E0 00 00 00 4C 8D 6C 24 6F 44 0F 28 35 ?? ?? ?? ?? 49 83 E5 C0 44 0F 54 F0 44 0F 56 35 ?? ?? ?? ?? 66 41 0F 5A CE 66 0F C2 25 ?? ?? ?? ?? 01 66 0F C2 2D ?? ?? ?? ?? 06 0F 16 C9 0F 56 E5 0F 53 D1 66 0F 50 D4 0F 28 1D ?? ?? ?? ?? 0F 28 C8 66 0F 73 D1 14 44 0F 5A FA 66 44 0F 58 FB 66 44 0F 5C FB 66 0F 70 D1 DD 41 0F 28 E7 F3 0F E6 DA 0F 28 15 ?? ?? ?? ?? 66 0F 73 D4 28 41 0F 54 D6 85 D2 66 44 0F 5C F2 66 41 0F 59 D7 66 45 0F 59 F7 66 0F 5C 15 ?? ?? ?? ?? 66 0F 7E E0 66 0F 70 EC 02 0F 28 25 ?? ?? ?? ?? 66 41 0F C2 E7 01 66 41 0F 58 D6 66 0F 7E E9 0F 54 25 ?? ?? ?? ?? 44 0F 28 FA 0F 56 25 ?? ?? ?? ?? 66 0F 5C DC 66 44 0F 59 FA 66 0F 59 1D ?? ?? ?? ?? 0F 28 25 ?? ?? ?? ?? 66 0F 59 E2 44 0F 28 35 ?? ?? ?? ?? 66 0F 58 25 ?? ?? ?? ?? 66 44 0F 59 F2 66 41 0F 59 E7 66 44 0F 58 35 ?? ?? ?? ?? 66 0F 59 15 ?? ?? ?? ?? 66 41 0F 58 E6 66 41 0F 59 E7 48 63 C0 66 0F 58 E2 48 63 C9 F2 42 0F 10 8C 00 40 90 BF FF 66 42 0F 16 8C 01 40 90 BF FF 66 0F 58 E1 66 0F 58 E3 75 25 44 0F 28 B4 24 D0 00 00 00 0F 28 C4 44 0F 28 BC 24 C0 00 00 00 4C 8B AC 24 E0 00 00 00 48 81 C4 E8 00 00 00 C3 41 0F 29 45 00 41 0F 29 65 40 74 CF 33 C0 48 89 5C 24 28 8B D8 48 89 74 24 20 8B F2 8B CB 41 B8 01 00 00 00 41 D3 E0 41 85 F0 75 18 FF C3 83 FB 20 7C E9 48 8B 5C 24 28 48 8B 74 24 20 41 0F 28 65 40 EB 97 49 8D 4C DD 00 49 8D 54 DD 40 E8 ?? ?? ?? ?? EB D7 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_149_0_0 {
	meta:
		name = "__scrt_is_user_matherr_present"
		size = 37
		refs = "0006 __scrt_default_matherr"
	strings:
		$1 = { 48 83 EC 18 83 3D ?? ?? ?? ?? 00 75 09 C7 04 24 01 00 00 00 EB 07 C7 04 24 00 00 00 00 8B 04 24 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_154_0_0 {
	meta:
		name = "__sse4_floor2"
		size = 16
	strings:
		$1 = { 66 0F 3A 09 C0 01 C3 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_155_0_0 {
	meta:
		name = "__avx_powf8"
		size = 1520
		refs = "000a __common_spow_data 05e9 __common_spow_cout_rare"
	strings:
		$1 = { 48 81 EC 58 02 00 00 48 8D 15 ?? ?? ?? ?? C5 7C 11 BC 24 B0 01 00 00 C5 7C 11 B4 24 70 01 00 00 C5 7C 11 AC 24 50 01 00 00 C5 7C 11 A4 24 30 01 00 00 C5 7C 11 9C 24 10 01 00 00 C5 7C 11 94 24 30 02 00 00 C5 7C 11 8C 24 10 02 00 00 C5 7C 11 84 24 F0 01 00 00 C5 FC 11 BC 24 D0 01 00 00 C5 FC 11 B4 24 90 01 00 00 4C 89 AC 24 50 02 00 00 4C 8D 6C 24 6F 49 83 E5 C0 C4 C1 7C 11 45 20 C5 7D 10 25 ?? ?? ?? ?? C5 7D 10 35 ?? ?? ?? ?? C5 F8 10 25 ?? ?? ?? ?? C5 78 10 0D ?? ?? ?? ?? C4 C1 7C 11 4D 00 C5 F9 FA D4 C4 E3 7D 19 C3 01 C5 7C 5A C0 C5 FC 5A FB C5 E1 FA DC C4 41 3D 54 DC C4 41 45 54 FC C4 C1 25 56 C6 C4 41 05 56 FE C4 C1 71 DB E1 C4 C3 7D 19 CA 01 C5 FC 5A F1 C4 41 29 DB E9 C5 FD 5A C8 C4 41 7D 5A CF C5 7A 7F 6C 24 20 C4 C1 7C 5A EA C5 78 53 D1 C4 41 78 53 E9 C4 41 7C 5A F2 C4 41 7C 5A DD C4 43 7D 09 CE 00 C5 7D 10 35 ?? ?? ?? ?? C4 63 7D 19 C1 01 C4 C1 39 73 D0 14 C5 F1 73 D1 14 C5 38 C6 D1 DD C4 41 7E E6 D2 C5 B9 73 D7 14 C4 C3 7D 19 FC 01 C4 C1 71 73 D4 14 C5 38 C6 E9 DD C4 43 7D 09 C3 00 C4 41 7D 59 E1 C4 C1 7E E6 FD C4 C1 05 59 C0 C4 41 1D 5C DE C4 41 7D 5C E6 C4 C1 01 73 D1 28 C5 79 7E F8 C4 43 7D 19 CD 01 48 63 C0 C4 C1 09 73 D5 28 C4 41 79 7E F0 C4 63 79 16 F9 02 48 63 C9 C5 7B 10 AC 10 80 A1 BF FF 4D 63 C0 C4 43 79 16 F1 02 4D 63 C9 C5 11 16 AC 11 80 A1 BF FF C4 41 7B 10 BC 10 80 A1 BF FF C4 C1 79 73 D0 28 C4 63 7D 19 C1 01 C5 F1 73 D1 28 C5 F9 7E C8 C4 C1 79 7E C2 C4 41 01 16 BC 11 80 A1 BF FF 48 63 C0 C4 E3 79 16 C9 02 48 63 C9 4D 63 D2 C4 C3 79 16 C3 02 4D 63 DB C4 43 15 18 EF 01 C5 7B 10 BC 10 80 A1 BF FF C5 81 16 8C 11 80 A1 BF FF C5 7D 10 3D ?? ?? ?? ?? C4 41 7B 10 B4 12 80 A1 BF FF C4 C1 09 16 84 13 80 A1 BF FF C5 7D 10 35 ?? ?? ?? ?? C4 41 05 C2 C9 11 C4 41 05 C2 F8 11 C4 41 35 54 C6 C4 41 05 54 CE C5 7D 10 3D ?? ?? ?? ?? C4 41 3D 56 C7 C4 41 35 56 CF C4 41 2D 5C D0 C4 C1 45 5C F9 C4 E3 7D 18 C1 01 C5 FD 10 0D ?? ?? ?? ?? C5 2D 59 F1 C5 45 59 F9 C5 FD 10 0D ?? ?? ?? ?? C5 FD 10 3D ?? ?? ?? ?? C4 41 75 59 C3 C4 41 75 59 CC C5 3D 58 D7 C5 B5 58 CF C4 41 25 59 C3 C4 41 1D 59 CC C4 41 2D 59 D0 C4 41 75 59 C1 C4 41 25 58 DA C4 41 1D 58 C0 C4 C1 25 58 CD C5 3D 58 D0 C5 FD 10 05 ?? ?? ?? ?? C4 41 75 58 CE C4 41 2D 58 EF C5 35 59 CE C5 15 59 C5 C5 FD 10 2D ?? ?? ?? ?? C5 FD 10 35 ?? ?? ?? ?? C5 78 10 2D ?? ?? ?? ?? C5 35 59 FD C5 BD 59 ED C5 05 5C E6 C5 55 5C DE C5 1D 58 D0 C5 A5 58 C8 C5 78 10 25 ?? ?? ?? ?? C5 2D 5C F0 C5 F5 5C C0 C4 41 05 5C F6 C5 D5 5C E8 C5 7D 10 3D ?? ?? ?? ?? C4 63 7D 19 C7 01 C5 38 C6 DF DD C5 F8 10 3D ?? ?? ?? ?? C5 69 66 C7 C5 E9 76 D7 C4 63 7D 19 CE 01 C5 B0 C6 F6 DD C5 39 EB CA C5 F8 10 15 ?? ?? ?? ?? C5 59 66 C2 C5 D9 76 E2 C5 39 EB C4 C4 C1 48 54 E5 C4 41 31 EB C8 C5 61 66 C7 C5 E1 76 DF C4 C1 59 66 F4 C5 B9 EB DB C5 31 EB CE C5 7A 6F 44 24 20 C4 41 20 54 ED C5 B9 66 E2 C5 B9 76 D2 C5 D9 EB F2 C4 41 11 66 E4 C5 E1 EB FE C5 F9 10 25 ?? ?? ?? ?? C4 41 41 EB DC C4 41 31 6B CB C4 41 39 EF C0 C4 C1 31 63 D0 C5 F9 D7 C2 C4 41 55 59 CF C4 41 0D 59 C7 C5 28 54 DC C4 63 7D 19 D3 01 C4 C1 29 73 D2 0B C4 41 79 7E D8 C5 60 54 E4 C4 41 79 7E E2 C5 E1 73 D3 0B C4 C1 29 73 F2 34 41 C1 E0 03 C4 43 79 16 D9 02 41 C1 E2 03 C4 63 79 16 E1 02 41 C1 E1 03 C1 E1 03 C4 C1 F9 6E 84 10 00 36 00 00 C4 C1 F9 6E B4 12 00 36 00 00 C4 C1 79 16 AC 11 00 36 00 00 C5 C9 16 BC 11 00 36 00 00 C5 70 54 EC C4 E3 7D 19 CA 01 C5 F1 73 D1 0B C5 E8 54 E4 C5 E9 73 D2 0B C4 41 79 7E E8 C5 F1 73 F1 34 C4 C1 79 7E E3 41 C1 E0 03 C4 43 79 16 E9 02 41 C1 E3 03 C4 E3 79 16 E1 02 41 C1 E1 03 C1 E1 03 C4 41 F9 6E 9C 10 00 36 00 00 C4 41 F9 6E A4 13 00 36 00 00 C4 41 21 16 AC 11 00 36 00 00 C5 99 16 A4 11 00 36 00 00 C4 63 55 18 F7 01 C5 C1 73 F3 34 C4 41 0D 59 C0 C4 C1 3D 58 C6 C4 63 15 18 FC 01 C4 41 05 59 C9 C4 C1 35 58 E7 C4 E3 7D 19 C6 01 C4 C1 79 D4 EA C5 49 D4 CF C5 F9 73 F2 34 C4 C1 7C 10 55 00 C4 C3 7D 19 E0 01 C5 D9 D4 E1 C5 39 D4 C0 C4 43 55 18 D9 01 C4 C1 7D 5A DB C4 C3 5D 18 E8 01 C5 FD 5A F5 C4 E3 65 18 C6 01 84 C0 75 6A C5 FC 10 B4 24 90 01 00 00 C5 FC 10 BC 24 D0 01 00 00 C5 7C 10 84 24 F0 01 00 00 C5 7C 10 8C 24 10 02 00 00 C5 7C 10 94 24 30 02 00 00 C5 7C 10 9C 24 10 01 00 00 C5 7C 10 A4 24 30 01 00 00 C5 7C 10 AC 24 50 01 00 00 C5 7C 10 B4 24 70 01 00 00 C5 7C 10 BC 24 B0 01 00 00 4C 8B AC 24 50 02 00 00 48 81 C4 58 02 00 00 C3 C4 C1 7C 10 4D 20 C4 C1 7C 11 55 40 C4 C1 7C 11 85 80 00 00 00 C4 C1 7C 11 4D 00 85 C0 0F 84 73 FF FF FF 33 D2 48 89 5C 24 28 8B DA 48 89 74 24 20 8B F0 0F A3 DE 72 1F FF C3 83 FB 20 7C F4 48 8B 5C 24 28 48 8B 74 24 20 C4 C1 7C 10 85 80 00 00 00 E9 3F FF FF FF C5 F8 77 49 8D 4C 9D 00 49 8D 54 9D 40 4D 8D 84 9D 80 00 00 00 E8 ?? ?? ?? ?? EB C5 90 }
	condition:
		$1
}

rule file_158_0_0 {
	meta:
		name = "_RTC_AllocaHelper"
		size = 59
	strings:
		$1 = { 48 83 EC 08 4C 8B C9 48 85 C9 74 2A 48 85 D2 74 25 4D 85 C0 74 20 48 89 3C 24 B0 CC 48 8B F9 48 8B CA F3 AA 49 8B 00 48 8B 3C 24 49 89 41 04 49 89 51 0C 4D 89 08 48 83 C4 08 C3 }
	condition:
		$1
}

rule file_158_1_0 {
	meta:
		name = "_RTC_CheckStackVars"
		size = 129
		refs = "005e ?_RTC_StackFailure@@YAXPEAXPEBD@Z"
	strings:
		$1 = { 48 89 5C 24 10 48 89 6C 24 18 56 48 83 EC 20 33 DB 48 8B F2 48 8B E9 39 1A 7E 56 48 89 7C 24 30 8B FB 0F 1F 40 00 66 66 0F 1F 84 00 00 00 00 00 48 8B 56 08 48 63 0C 3A 81 7C 29 FC CC CC CC CC 75 11 48 63 44 3A 04 48 03 C1 81 3C 28 CC CC CC CC 74 0F 48 8B 4C 24 28 48 8B 54 3A 08 E8 ?? ?? ?? ?? FF C3 48 83 C7 10 3B 1E 7C C4 48 8B 7C 24 30 48 8B 5C 24 38 48 8B 6C 24 40 48 83 C4 20 5E C3 }
	condition:
		$1
}

rule file_158_2_0 {
	meta:
		name = "_RTC_CheckStackVars2"
		size = 259
		refs = "0064 ?_RTC_StackFailure@@YAXPEAXPEBD@Z 00cf ?_RTC_AllocaFailure@@YAXPEAXPEAU_RTC_ALLOCA_NODE@@H@Z"
	strings:
		$1 = { 40 53 57 48 83 EC 28 48 89 6C 24 40 33 FF 4C 89 7C 24 20 49 8B D8 48 8B EA 4C 8B F9 48 85 D2 74 5C 48 89 74 24 48 8B F7 39 3A 7E 4C 4C 89 74 24 50 44 8B F7 48 8B 55 08 4A 63 0C 32 42 81 7C 39 FC CC CC CC CC 75 12 4A 63 44 32 04 48 03 C1 42 81 3C 38 CC CC CC CC 74 0F 48 8B 4C 24 38 4A 8B 54 32 08 E8 ?? ?? ?? ?? FF C6 49 83 C6 10 3B 75 00 7C C1 4C 8B 74 24 50 48 8B 74 24 48 4C 8B 7C 24 20 48 8B C3 48 8B 6C 24 40 48 85 DB 74 6D 90 48 8B 40 04 FF C7 48 85 C0 75 F5 48 85 DB 74 5C 81 3B CC CC CC CC 75 1B 81 7B 14 CC CC CC CC 75 12 81 7B 18 CC CC CC CC 75 09 81 7B 1C CC CC CC CC 74 10 48 8B 4C 24 38 44 8B C7 48 8B D3 E8 ?? ?? ?? ?? 48 8B 43 0C 81 7C 18 FC CC CC CC CC 74 10 48 8B 4C 24 38 44 8B C7 48 8B D3 E8 ?? ?? ?? ?? 48 8B 5B 04 FF CF 48 85 DB 75 A4 48 83 C4 28 5F 5B C3 }
	condition:
		$1
}

rule file_160_0_0 {
	meta:
		name = "__sse2_ceil2"
		size = 80
		refs = "0006 _2il0floatpacket_4 000d _2il0floatpacket_5 0038 _2il0floatpacket_6"
	strings:
		$1 = { 0F 28 E0 0F 28 1D ?? ?? ?? ?? 0F 28 0D ?? ?? ?? ?? 0F 28 D3 0F 54 E1 0F 55 C8 66 0F C2 D1 01 66 0F 58 CB 66 0F 5C CB 0F 56 CC 0F 28 DA 0F 28 E9 66 0F C2 E8 01 0F 54 2D ?? ?? ?? ?? 0F 54 C2 66 0F 5C CD 0F 55 D9 0F 56 C3 C3 66 0F 1F 44 00 00 }
	condition:
		$1
}

rule file_161_0_0 {
	meta:
		name = "??2@YAPEAX_KAEBUnothrow_t@std@@@Z"
		size = 59
		refs = "001d ??2@YAPEAX_K@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 48 C7 44 24 30 FE FF FF FF 48 8B 4C 24 50 E8 ?? ?? ?? ?? 90 48 89 44 24 20 48 8B 44 24 20 EB 07 EB 05 48 8B 44 24 28 48 83 C4 48 C3 CC }
	condition:
		$1
}

rule file_161_2_0 {
	meta:
		name = "__catch$??2@YAPEAX_KAEBUnothrow_t@std@@@Z$0"
		size = 31
		refs = "000b $LN7 0014 __tryend$??2@YAPEAX_KAEBUnothrow_t@std@@@Z$1"
	strings:
		$1 = { 48 C7 45 28 00 00 00 00 48 8D 05 ?? ?? ?? ?? EB 07 48 8D 05 ?? ?? ?? ?? 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_162_0_0 {
	meta:
		name = "__avx_log104"
		size = 656
		refs = "000a __common_dlog10_data 027c __common_dlog10_cout_rare"
	strings:
		$1 = { 48 81 EC 18 02 00 00 48 8D 05 ?? ?? ?? ?? C5 FC 11 BC 24 F0 01 00 00 4C 89 AC 24 10 02 00 00 4C 8D AC 24 8F 01 00 00 C5 FD 54 1D ?? ?? ?? ?? 49 83 E5 C0 C5 E5 56 3D ?? ?? ?? ?? C5 FD 5A EF C5 F8 53 E5 C5 FC 5A E4 C4 E3 7D 09 E4 00 C5 F1 73 D0 14 C4 E3 7D 19 C2 01 C5 E1 73 D2 14 C5 FD C2 15 ?? ?? ?? ?? 11 C5 F0 C6 EB DD C5 FD C2 0D ?? ?? ?? ?? 16 C5 FE E6 DD C5 ED 56 D1 C4 E3 7D 19 D1 01 C5 E8 C6 E9 DD C5 C5 54 15 ?? ?? ?? ?? C5 C5 5C FA C5 F8 50 D5 C5 ED 59 D4 C5 C5 59 FC C5 ED 5C 0D ?? ?? ?? ?? C5 F5 58 CF C5 C1 73 D4 28 C4 E3 7D 19 E5 01 C5 D1 73 D5 28 C4 C1 79 7E E9 C5 DD C2 25 ?? ?? ?? ?? 1E C5 F9 7E F9 4D 63 C9 C4 C3 79 16 EA 02 4D 63 D2 C4 C3 79 16 F8 02 C4 C1 7B 10 BC 01 40 90 BF FF C5 DD 54 25 ?? ?? ?? ?? C4 C1 41 16 AC 02 40 90 BF FF C5 DD 56 3D ?? ?? ?? ?? C5 E5 5C DF C5 F5 59 3D ?? ?? ?? ?? C5 E5 59 25 ?? ?? ?? ?? C5 F5 59 1D ?? ?? ?? ?? C5 C5 58 3D ?? ?? ?? ?? 48 63 C9 4D 63 C0 C5 FB 10 94 01 40 90 BF FF C4 C1 69 16 94 00 40 90 BF FF C4 E3 6D 18 D5 01 C5 E5 58 2D ?? ?? ?? ?? C5 F5 59 D9 C5 F5 59 0D ?? ?? ?? ?? C5 D5 59 EB C5 D5 58 EF C5 D5 59 DB C5 E5 58 C9 C5 F5 58 D2 C5 ED 58 CC 85 D2 75 1D C5 FC 10 BC 24 F0 01 00 00 4C 8B AC 24 10 02 00 00 C5 FD 28 C1 48 81 C4 18 02 00 00 C3 C4 C1 7D 11 45 00 C4 C1 7D 11 4D 40 74 D5 33 C0 C5 FC 11 B4 24 20 01 00 00 C5 7C 11 84 24 00 01 00 00 C5 7C 11 8C 24 E0 00 00 00 C5 7C 11 94 24 C0 00 00 00 C5 7C 11 9C 24 A0 00 00 00 C5 7C 11 A4 24 80 00 00 00 C5 7C 11 6C 24 60 C5 7C 11 74 24 40 C5 7C 11 7C 24 20 48 89 9C 24 48 01 00 00 8B D8 48 89 B4 24 40 01 00 00 8B F2 0F A3 DE 72 6A FF C3 83 FB 20 7C F4 C5 FC 10 B4 24 20 01 00 00 C5 7C 10 84 24 00 01 00 00 C5 7C 10 8C 24 E0 00 00 00 C5 7C 10 94 24 C0 00 00 00 C5 7C 10 9C 24 A0 00 00 00 C5 7C 10 A4 24 80 00 00 00 C5 7C 10 6C 24 60 C5 7C 10 74 24 40 C5 7C 10 7C 24 20 C4 C1 7D 10 4D 40 48 8B 9C 24 48 01 00 00 48 8B B4 24 40 01 00 00 E9 08 FF FF FF C5 F8 77 49 8D 4C DD 00 49 8D 54 DD 40 E8 ?? ?? ?? ?? EB 82 66 66 66 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_164_9_0 {
	meta:
		name = "?invoke_main@@YAHXZ"
		size = 50
		refs = "0005 __scrt_get_show_window_mode 0011 _get_narrow_winmain_command_line 0024 __ImageBase 0029 WinMain"
	strings:
		$1 = { 48 83 EC 38 E8 ?? ?? ?? ?? 0F B7 C0 89 44 24 20 E8 ?? ?? ?? ?? 8B 4C 24 20 44 8B C9 4C 8B C0 33 D2 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_327_9_0 {
	meta:
		name = "?invoke_main@@YAHXZ"
		size = 50
		refs = "0005 __scrt_get_show_window_mode 0011 _get_wide_winmain_command_line 0024 __ImageBase 0029 wWinMain"
	strings:
		$1 = { 48 83 EC 38 E8 ?? ?? ?? ?? 0F B7 C0 89 44 24 20 E8 ?? ?? ?? ?? 8B 4C 24 20 44 8B C9 4C 8B C0 33 D2 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_166_0_0 {
	meta:
		name = "__common_dsinh_cout_rare"
		size = 2096
		refs = "006d _vmldSinhHATab 015a _2il0floatpacket_88"
	strings:
		$1 = { 41 54 48 81 EC E0 00 00 00 33 C0 4C 8B 09 4D 8B C1 49 C1 E8 30 F2 0F 10 11 41 81 E0 F0 7F 00 00 41 C1 E8 04 44 0F 29 7C 24 50 41 81 F8 FF 07 00 00 44 0F 29 74 24 60 44 0F 29 6C 24 70 44 0F 29 A4 24 80 00 00 00 44 0F 29 9C 24 90 00 00 00 44 0F 29 94 24 A0 00 00 00 44 0F 29 8C 24 B0 00 00 00 44 0F 29 84 24 C0 00 00 00 4C 8B 25 ?? ?? ?? ?? 4C 89 8C 24 D0 00 00 00 0F 84 A1 07 00 00 45 85 C0 0F 8E 6C 07 00 00 49 8B C9 48 C1 E9 38 4C 89 4C 24 38 83 E1 7F 88 4C 24 3F 41 81 F8 C9 03 00 00 0F 8E EB 06 00 00 F2 0F 10 44 24 38 F2 0F 10 0D ?? ?? ?? ?? 66 0F 2F C8 0F 86 BC 06 00 00 F2 0F 10 0D ?? ?? ?? ?? 66 0F 2F C8 0F 86 49 05 00 00 66 0F 2F 05 ?? ?? ?? ?? 0F 82 CE 04 00 00 F2 44 0F 10 2D ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? F2 44 0F 59 E8 F2 44 0F 10 25 ?? ?? ?? ?? F2 0F 10 25 ?? ?? ?? ?? 4C 89 64 24 48 49 C1 EC 30 F2 44 0F 58 2D ?? ?? ?? ?? F2 44 0F 11 6C 24 30 41 81 E4 0F 80 FF FF F2 44 0F 10 74 24 30 44 8B 44 24 30 45 8B D0 41 C1 EA 06 41 83 E0 3F 49 C1 E9 38 F2 44 0F 5C 35 ?? ?? ?? ?? F2 45 0F 59 E6 41 8D 8A FF 03 00 00 44 0F 57 35 ?? ?? ?? ?? 41 81 C2 FE 03 00 00 F2 44 0F 59 35 ?? ?? ?? ?? F2 41 0F 5C C4 44 0F 28 C8 0F 28 E8 41 81 E2 FF 07 00 00 F7 D9 41 C1 E2 04 83 C1 FC 45 0B E2 47 8D 14 00 81 E1 FF 07 00 00 66 44 89 64 24 4E 41 81 E4 0F 80 FF FF C1 E1 04 47 8D 44 00 01 44 0B E1 41 80 E1 80 F2 45 0F 58 CE F2 44 0F 11 4C 24 40 F2 44 0F 10 54 24 40 F2 41 0F 5C EA F2 0F 11 6C 24 20 F2 44 0F 10 5C 24 40 F2 44 0F 10 44 24 20 F2 45 0F 58 D8 F2 44 0F 11 5C 24 28 F2 44 0F 10 7C 24 20 F2 45 0F 58 F7 F2 44 0F 10 7C 24 48 F2 44 0F 11 74 24 20 F2 44 0F 10 5C 24 28 66 44 89 64 24 4E 4D 8B E3 F2 41 0F 5C C3 F2 0F 11 44 24 28 F2 44 0F 10 64 24 20 F2 44 0F 10 6C 24 28 F2 45 0F 58 E5 F2 44 0F 11 64 24 28 F2 0F 10 6C 24 40 0F 28 D5 44 0F 28 DD F2 0F 59 D4 0F 28 CD F2 44 0F 59 DD F2 44 0F 10 44 24 28 F2 0F 11 54 24 40 F2 44 0F 10 4C 24 40 F2 43 0F 10 14 C3 4D 8B C3 F2 41 0F 59 D7 F2 44 0F 5C CD F2 44 0F 11 4C 24 20 F2 44 0F 10 0D ?? ?? ?? ?? F2 45 0F 59 CB F2 0F 10 5C 24 40 F2 44 0F 10 54 24 20 F2 41 0F 5C DA F2 44 0F 10 15 ?? ?? ?? ?? F2 45 0F 59 D3 F2 44 0F 58 0D ?? ?? ?? ?? F2 0F 11 5C 24 40 F2 0F 10 44 24 40 F2 45 0F 59 CB F2 0F 5C C8 F2 44 0F 58 15 ?? ?? ?? ?? F2 44 0F 58 0D ?? ?? ?? ?? F2 45 0F 59 D3 F2 45 0F 59 CB F2 44 0F 59 D5 F2 43 0F 10 04 D3 41 F7 DA F2 0F 11 4C 24 20 F2 41 0F 59 C7 F2 44 0F 10 5C 24 48 41 8D 8A 80 00 00 00 41 81 C2 81 00 00 00 44 0F 28 F0 F2 44 0F 10 6C 24 40 F2 41 0F 10 0C CC F2 44 0F 10 64 24 20 F2 41 0F 59 CB F2 43 0F 10 1C D0 F2 44 0F 5C F1 F2 41 0F 59 DB F2 44 0F 11 74 24 40 44 0F 28 D8 F2 44 0F 10 7C 24 40 F2 45 0F 5C DF F2 44 0F 5C D9 F2 44 0F 11 5C 24 20 F2 44 0F 10 5C 24 40 F2 44 0F 10 74 24 20 45 0F 28 FB F2 44 0F 5C F3 F2 44 0F 58 F2 F2 0F 58 D3 F2 45 0F 58 FE F2 44 0F 11 7C 24 40 F2 44 0F 10 7C 24 40 F2 45 0F 5C DF 44 0F 28 F8 F2 44 0F 58 F9 F2 45 0F 58 DE F2 44 0F 11 5C 24 20 F2 44 0F 10 74 24 40 F2 44 0F 10 5C 24 20 F2 44 0F 11 7C 24 40 F2 44 0F 10 7C 24 40 F2 41 0F 5C C7 F2 0F 58 C1 F2 0F 11 44 24 20 F2 0F 10 4C 24 40 F2 0F 10 44 24 20 0F 28 D9 F2 0F 58 D0 F2 0F 58 DA F2 0F 11 5C 24 40 F2 0F 10 44 24 40 F2 0F 5C C8 F2 0F 58 CA F2 0F 11 4C 24 20 F2 0F 10 44 24 40 F2 0F 59 E0 0F 28 C8 F2 0F 10 5C 24 20 F2 0F 11 64 24 40 F2 0F 10 64 24 40 F2 0F 59 EB F2 0F 5C E0 F2 0F 11 64 24 20 F2 44 0F 10 7C 24 40 F2 0F 10 54 24 20 F2 44 0F 5C FA F2 44 0F 11 7C 24 40 45 0F 28 F8 F2 0F 10 64 24 40 F2 44 0F 59 FB F2 0F 5C CC F2 44 0F 59 C0 F2 0F 11 4C 24 20 0F 28 CB F2 41 0F 59 CA F2 44 0F 59 D0 F2 44 0F 58 F9 41 0F 28 CB F2 41 0F 59 C9 F2 45 0F 59 CE F2 44 0F 58 F9 F2 0F 10 54 24 40 41 0F 28 CC F2 0F 10 64 24 20 F2 44 0F 58 FD F2 0F 59 CC F2 41 0F 59 E5 F2 44 0F 59 EA F2 45 0F 58 F8 F2 44 0F 59 E2 F2 45 0F 58 DF 41 0F 28 EA 41 0F 28 D5 F2 41 0F 58 E9 F2 0F 11 6C 24 40 F2 44 0F 10 44 24 40 F2 45 0F 5C D0 F2 45 0F 58 D1 45 0F 28 CE F2 44 0F 11 54 24 20 F2 0F 10 5C 24 40 F2 0F 10 44 24 20 F2 0F 58 D3 F2 44 0F 58 D8 F2 0F 11 54 24 40 F2 44 0F 58 D9 F2 44 0F 58 DC F2 0F 10 64 24 40 F2 44 0F 5C EC F2 45 0F 58 DC F2 44 0F 58 EB F2 44 0F 11 6C 24 20 F2 44 0F 10 54 24 40 F2 0F 10 6C 24 20 F2 45 0F 58 CA F2 44 0F 58 DD F2 44 0F 11 4C 24 40 F2 44 0F 10 44 24 40 F2 45 0F 5C F0 F2 45 0F 58 F2 F2 44 0F 11 74 24 20 F2 44 0F 10 6C 24 40 F2 44 0F 10 64 24 20 F2 45 0F 58 DC F2 45 0F 58 DD F2 44 0F 11 5C 24 38 44 8A 5C 24 3F 41 80 E3 7F 45 0A D9 44 88 5C 24 3F 48 8B 4C 24 38 48 89 0A E9 FD 01 00 00 0F 28 D0 F2 0F 59 D0 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 CA 8A 8C 24 D7 00 00 00 80 E1 80 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 D1 F2 0F 59 D0 F2 0F 58 C2 F2 0F 11 44 24 38 44 8A 44 24 3F 41 80 E0 7F 44 0A C1 44 88 44 24 3F 4C 8B 4C 24 38 4C 89 0A E9 90 01 00 00 F2 0F 10 0D ?? ?? ?? ?? 4C 8D 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 10 15 ?? ?? ?? ?? F2 0F 10 1D ?? ?? ?? ?? 4C 89 64 24 48 F2 0F 58 0D ?? ?? ?? ?? F2 0F 11 4C 24 30 F2 0F 10 64 24 30 F2 0F 10 0D ?? ?? ?? ?? 8B 4C 24 30 44 8B D1 41 83 E2 3F F2 0F 5C 25 ?? ?? ?? ?? F2 0F 59 D4 47 8D 04 12 F2 0F 59 E3 F2 0F 5C C2 47 8D 5C 12 01 F2 0F 5C C4 F2 0F 59 C8 C1 E9 06 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 81 C1 FE 03 00 00 81 E1 FF 07 00 00 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 81 F9 FE 07 00 00 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 59 C8 F2 0F 58 C8 F2 43 0F 10 04 C1 F2 0F 59 C8 4D 8B C1 F2 43 0F 58 0C D8 F2 0F 58 C8 77 29 49 C1 EC 30 C1 E1 04 41 81 E4 0F 80 FF FF 44 0B E1 66 44 89 64 24 4E F2 0F 10 44 24 48 F2 0F 59 C8 F2 0F 11 4C 24 38 EB 39 FF C9 81 E1 FF 07 00 00 44 0F B7 44 24 4E C1 E1 04 41 81 E0 0F 80 FF FF 44 0B C1 66 44 89 44 24 4E F2 0F 10 44 24 48 F2 0F 59 C8 F2 0F 59 0D ?? ?? ?? ?? F2 0F 11 4C 24 38 44 8A 44 24 3F 8A 8C 24 D7 00 00 00 41 80 E0 7F 80 E1 80 44 0A C1 44 88 44 24 3F 4C 8B 4C 24 38 4C 89 0A EB 2F F2 0F 10 05 ?? ?? ?? ?? B8 03 00 00 00 F2 0F 59 C2 F2 0F 11 02 EB 18 F2 0F 10 05 ?? ?? ?? ?? F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C2 F2 0F 11 02 44 0F 28 84 24 C0 00 00 00 44 0F 28 8C 24 B0 00 00 00 44 0F 28 94 24 A0 00 00 00 44 0F 28 9C 24 90 00 00 00 44 0F 28 A4 24 80 00 00 00 44 0F 28 6C 24 70 44 0F 28 74 24 60 44 0F 28 7C 24 50 48 81 C4 E0 00 00 00 41 5C C3 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 D0 F2 0F 11 54 24 40 F2 0F 10 4C 24 40 4C 89 64 24 48 F2 0F 58 8C 24 D0 00 00 00 F2 0F 11 0A EB 8B F2 0F 58 D2 F2 0F 11 12 EB 81 66 0F 1F 44 00 00 }
	condition:
		$1
}

rule file_167_0_0 {
	meta:
		name = "__dyn_tls_dtor"
		size = 273
		refs = "002f dtor_list 0037 _tls_index 00b5 _guard_check_icall 00e0 _free_dbg"
	strings:
		$1 = { 4C 89 44 24 18 89 54 24 10 48 89 4C 24 08 48 83 EC 48 83 7C 24 58 03 74 0C 83 7C 24 58 00 74 05 E9 E7 00 00 00 48 C7 44 24 30 00 00 00 00 B8 ?? ?? ?? ?? 8B C0 8B 0D ?? ?? ?? ?? 65 48 8B 14 25 58 00 00 00 48 8B 0C CA 48 8B 04 08 48 89 44 24 28 EB 0A 48 8B 44 24 30 48 89 44 24 28 48 83 7C 24 28 00 0F 84 A3 00 00 00 48 8B 44 24 28 8B 00 FF C8 89 44 24 20 EB 0A 8B 44 24 20 FF C8 89 44 24 20 83 7C 24 20 00 7C 36 48 63 44 24 20 48 8B 4C 24 28 48 83 7C C1 10 00 74 22 48 63 44 24 20 48 8B 4C 24 28 48 8B 44 C1 10 48 89 44 24 38 48 8B 4C 24 38 E8 ?? ?? ?? ?? FF 54 24 38 EB B9 48 8B 44 24 28 48 8B 40 08 48 89 44 24 30 48 83 7C 24 30 00 74 0F BA 02 00 00 00 48 8B 4C 24 28 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? 8B C0 8B 0D ?? ?? ?? ?? 65 48 8B 14 25 58 00 00 00 48 8B 0C CA 48 8B 54 24 30 48 89 14 08 E9 47 FF FF FF 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_167_1_0 {
	meta:
		name = "??$?RUTlsDtorNode@@@__crt_internal_free_policy@@QEBAXQEBUTlsDtorNode@@@Z"
		size = 34
		refs = "0019 _free_dbg"
		altNames = "??$?RD@__crt_internal_free_policy@@QEBAXQEBD@Z ??$?RU__vcrt_ptd@@@__crt_internal_free_policy@@QEBAXQEBU__vcrt_ptd@@@Z ??$?RX@__crt_internal_free_policy@@QEBAXQEBX@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 BA 02 00 00 00 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_167_2_0 {
	meta:
		name = "??0?$__crt_unique_heap_ptr@UTlsDtorNode@@U__crt_internal_free_policy@@@@QEAA@QEAUTlsDtorNode@@@Z"
		size = 29
		altNames = "??0?$__crt_scoped_stack_ptr@_W@@QEAA@U?$__crt_scoped_stack_ptr_tag@_W@@@Z ??0?$__crt_scoped_stack_ptr_tag@_W@@QEAA@QEA_W@Z ??0?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QEAA@QEAD@Z ??0?$__crt_unique_heap_ptr@DU__crt_public_free_policy@@@@QEAA@QEAD@Z ??0?$__crt_unique_heap_ptr@U__vcrt_ptd@@U__crt_internal_free_policy@@@@QEAA@QEAU__vcrt_ptd@@@Z ??0?$__crt_unique_heap_ptr@XU__crt_internal_free_policy@@@@QEAA@QEAX@Z ??0_Timevec@std@@QEAA@PEAX@Z ??0id@locale@std@@QEAA@_K@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 8B 44 24 08 48 8B 4C 24 10 48 89 08 48 8B 44 24 08 C3 }
	condition:
		$1
}

rule file_167_4_0 {
	meta:
		name = "?detach@?$__crt_unique_heap_ptr@UTlsDtorNode@@U__crt_internal_free_policy@@@@QEAAPEAUTlsDtorNode@@XZ"
		size = 42
		altNames = "?detach@?$__crt_unique_heap_ptr@DU__crt_public_free_policy@@@@QEAAPEADXZ ?detach@?$__crt_unique_heap_ptr@U__vcrt_ptd@@U__crt_internal_free_policy@@@@QEAAPEAU__vcrt_ptd@@XZ ?detach@?$__crt_unique_heap_ptr@XU__crt_internal_free_policy@@@@QEAAPEAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 18 48 8B 44 24 20 48 8B 00 48 89 04 24 48 8B 44 24 20 48 C7 00 00 00 00 00 48 8B 04 24 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_167_5_0 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@UTlsDtorNode@@U__crt_internal_free_policy@@@@QEAAXXZ"
		size = 44
		refs = "0017 ??$?RUTlsDtorNode@@@__crt_internal_free_policy@@QEBAXQEBUTlsDtorNode@@@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 48 8B 10 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 40 48 C7 00 00 00 00 00 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_18_22_4 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QEAAXXZ"
		size = 44
		refs = "0017 ??$?RD@__crt_internal_free_policy@@QEBAXQEBD@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 48 8B 10 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 40 48 C7 00 00 00 00 00 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_26_7_4 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@DU__crt_public_free_policy@@@@QEAAXXZ"
		size = 44
		refs = "0017 ??$?RD@__crt_public_free_policy@@QEBAXQEBD@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 48 8B 10 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 40 48 C7 00 00 00 00 00 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_27_9_4 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@U__vcrt_ptd@@U__crt_internal_free_policy@@@@QEAAXXZ"
		size = 44
		refs = "0017 ??$?RU__vcrt_ptd@@@__crt_internal_free_policy@@QEBAXQEBU__vcrt_ptd@@@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 48 8B 10 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 40 48 C7 00 00 00 00 00 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_18_23_4 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@XU__crt_internal_free_policy@@@@QEAAXXZ"
		size = 44
		refs = "0017 ??$?RX@__crt_internal_free_policy@@QEBAXQEBX@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 48 8B 10 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 40 48 C7 00 00 00 00 00 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_167_6_0 {
	meta:
		name = "__tlregdtor"
		size = 526
		refs = "000a dtor_list 0012 _tls_index 002b dtor_list_head 00b8 ??_C@_0DA@HHHHCDMN@f?3?2dd?2vctools?2crt?2vcstartup?2src?2@ 00c7 _malloc_dbg 00d4 ??0?$__crt_unique_heap_ptr@UTlsDtorNode@@U__crt_internal_free_policy@@@@QEAA@QEAUTlsDtorNode@@@Z 00dc ?detach@?$__crt_unique_heap_ptr@UTlsDtorNode@@U__crt_internal_free_policy@@@@QEAAPEAUTlsDtorNode@@XZ 00eb ??1?$__crt_unique_heap_ptr@UTlsDtorNode@@U__crt_internal_free_policy@@@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 B8 ?? ?? ?? ?? 8B C0 8B 0D ?? ?? ?? ?? 65 48 8B 14 25 58 00 00 00 48 8B 0C CA 48 83 3C 08 00 75 5E B8 ?? ?? ?? ?? 8B C0 8B 0D ?? ?? ?? ?? 65 48 8B 14 25 58 00 00 00 48 03 04 CA B9 ?? ?? ?? ?? 8B C9 8B 15 ?? ?? ?? ?? 65 4C 8B 04 25 58 00 00 00 49 8B 14 D0 48 89 04 11 B8 ?? ?? ?? ?? 8B C0 8B 0D ?? ?? ?? ?? 65 48 8B 14 25 58 00 00 00 48 8B 0C CA C7 04 01 00 00 00 00 E9 F2 00 00 00 B8 ?? ?? ?? ?? 8B C0 8B 0D ?? ?? ?? ?? 65 48 8B 14 25 58 00 00 00 48 8B 0C CA 48 8B 04 01 83 38 1E 0F 85 CB 00 00 00 41 B9 43 00 00 00 4C 8D 05 ?? ?? ?? ?? BA 02 00 00 00 B9 00 01 00 00 E8 ?? ?? ?? ?? 48 8B D0 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 89 44 24 20 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 83 7C 24 20 00 75 0A B8 FF FF FF FF E9 08 01 00 00 48 8B 44 24 20 C7 00 00 00 00 00 B8 ?? ?? ?? ?? 8B C0 8B 0D ?? ?? ?? ?? 65 48 8B 14 25 58 00 00 00 48 8B 0C CA 48 8B 54 24 20 48 8B 04 08 48 89 42 08 B8 ?? ?? ?? ?? 8B C0 8B 0D ?? ?? ?? ?? 65 48 8B 14 25 58 00 00 00 48 8B 0C CA 48 8B 54 24 20 48 89 14 08 B8 ?? ?? ?? ?? 8B C0 8B 0D ?? ?? ?? ?? 65 48 8B 14 25 58 00 00 00 48 8B 0C CA 48 8B 04 01 C7 00 00 00 00 00 B8 ?? ?? ?? ?? 8B C0 8B 0D ?? ?? ?? ?? 65 48 8B 14 25 58 00 00 00 48 8B 0C CA 48 8B 04 01 B9 ?? ?? ?? ?? 8B C9 8B 15 ?? ?? ?? ?? 65 4C 8B 04 25 58 00 00 00 49 8B 14 D0 48 8B 0C 0A 48 63 09 48 8B 54 24 40 48 89 54 C8 10 8B 05 ?? ?? ?? ?? 65 48 8B 0C 25 58 00 00 00 BA ?? ?? ?? ?? 8B D2 48 8B 04 C1 48 8B 04 10 8B 00 FF C0 8B 0D ?? ?? ?? ?? 65 48 8B 14 25 58 00 00 00 41 B8 ?? ?? ?? ?? 45 8B C0 48 8B 0C CA 4A 8B 0C 01 89 01 33 C0 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_169_0_0 {
	meta:
		name = "__avx_sinhf8"
		size = 576
		refs = "0036 __common_ssinh_data 022f __common_ssinh_cout_rare"
	strings:
		$1 = { 48 81 EC 18 02 00 00 C5 7C 11 BC 24 F0 01 00 00 C5 7C 11 8C 24 B0 01 00 00 C5 FC 11 B4 24 D0 01 00 00 4C 89 AC 24 10 02 00 00 4C 8D AC 24 4F 01 00 00 C5 FC 54 2D ?? ?? ?? ?? 49 83 E5 C0 C5 54 57 F8 C5 7C 10 0D ?? ?? ?? ?? C5 84 59 0D ?? ?? ?? ?? C5 F8 10 35 ?? ?? ?? ?? C5 F8 10 15 ?? ?? ?? ?? C4 C1 74 58 C9 C5 81 66 E6 C4 63 7D 19 FB 01 C5 E1 66 DE C5 D9 6B E3 C5 C9 EF F6 C4 C1 74 5C D9 C5 D9 63 E6 C5 F9 D7 D4 C5 64 59 0D ?? ?? ?? ?? C4 41 04 5C F9 C5 64 59 0D ?? ?? ?? ?? C4 C1 04 5C D9 C5 E4 59 E3 C5 81 72 F1 17 C4 C3 7D 19 C9 01 C4 C1 69 FE CF C4 C1 49 72 F1 17 C4 41 69 FA FF C5 69 FE CE C5 E9 FA D6 C4 43 75 18 C9 01 C5 DC 59 0D ?? ?? ?? ?? C4 63 05 18 FA 01 C5 F4 58 15 ?? ?? ?? ?? C4 C1 34 58 F7 C4 41 34 5C CF C5 6C 59 FC C5 84 59 CB C5 74 58 FB C5 DC 59 1D ?? ?? ?? ?? C4 C1 4C 59 F7 C5 E4 58 0D ?? ?? ?? ?? C5 F4 59 D4 C5 EC 58 1D ?? ?? ?? ?? C5 E4 59 E4 C4 C1 5C 59 C9 C5 CC 58 D1 C4 41 6C 58 C9 C4 C1 54 56 C9 84 D2 75 2F C5 FC 10 B4 24 D0 01 00 00 C5 7C 10 8C 24 B0 01 00 00 C5 7C 10 BC 24 F0 01 00 00 4C 8B AC 24 10 02 00 00 C5 FC 28 C1 48 81 C4 18 02 00 00 C3 C4 C1 7C 11 45 00 C4 C1 7C 11 4D 40 85 D2 74 C1 33 C0 C5 FC 11 BC 24 E0 00 00 00 C5 7C 11 84 24 C0 00 00 00 C5 7C 11 94 24 A0 00 00 00 C5 7C 11 9C 24 80 00 00 00 C5 7C 11 64 24 60 C5 7C 11 6C 24 40 C5 7C 11 74 24 20 48 89 9C 24 08 01 00 00 8B D8 48 89 B4 24 00 01 00 00 8B F2 0F A3 DE 72 58 FF C3 83 FB 20 7C F4 C5 FC 10 BC 24 E0 00 00 00 C5 7C 10 84 24 C0 00 00 00 C5 7C 10 94 24 A0 00 00 00 C5 7C 10 9C 24 80 00 00 00 C5 7C 10 64 24 60 C5 7C 10 6C 24 40 C5 7C 10 74 24 20 C4 C1 7C 10 4D 40 48 8B 9C 24 08 01 00 00 48 8B B4 24 00 01 00 00 E9 18 FF FF FF C5 F8 77 49 8D 4C 9D 00 49 8D 54 9D 40 E8 ?? ?? ?? ?? EB 94 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_171_0_0 {
	meta:
		name = "__GSHandlerCheck"
		size = 58
		refs = "002c __GSHandlerCheckCommon"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 48 4C 8B 40 38 48 8B 54 24 48 48 8B 4C 24 38 E8 ?? ?? ?? ?? B8 01 00 00 00 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_171_1_0 {
	meta:
		name = "__GSHandlerCheckCommon"
		size = 248
		refs = "00ef __security_check_cookie"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 58 48 8B 44 24 70 8B 00 83 E0 F8 89 44 24 20 48 8B 44 24 60 48 89 44 24 38 48 8B 44 24 70 8B 00 C1 E8 02 83 E0 01 85 C0 74 29 48 8B 44 24 70 48 63 40 04 48 8B 4C 24 60 48 03 C8 48 8B C1 48 8B 4C 24 70 8B 49 08 F7 D9 48 63 C9 48 23 C1 48 89 44 24 38 48 63 44 24 20 48 8B 4C 24 38 48 8B 04 01 48 89 44 24 30 48 8B 44 24 68 48 8B 40 10 8B 40 08 48 8B 4C 24 68 48 03 41 08 48 89 44 24 40 48 8B 44 24 60 48 89 44 24 28 48 8B 44 24 40 0F B6 40 03 24 0F 0F B6 C0 85 C0 74 26 48 8B 44 24 40 0F B6 40 03 C0 E8 04 24 0F 0F B6 C0 6B C0 10 48 98 48 8B 4C 24 28 48 03 C8 48 8B C1 48 89 44 24 28 48 8B 44 24 28 48 8B 4C 24 30 48 33 C8 48 8B C1 48 89 44 24 30 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_172_0_0 {
	meta:
		name = "__common_ssinh_cout_rare"
		size = 2128
		refs = "0062 _vmldSinhHATab 0160 _2il0floatpacket_89"
	strings:
		$1 = { 48 81 EC D8 00 00 00 33 C0 44 0F B7 41 02 41 81 E0 80 7F 00 00 F3 0F 10 11 41 81 F8 80 7F 00 00 44 0F 29 7C 24 50 44 0F 29 74 24 60 44 0F 29 6C 24 70 44 0F 29 A4 24 80 00 00 00 44 0F 29 9C 24 90 00 00 00 44 0F 29 94 24 A0 00 00 00 44 0F 29 8C 24 B0 00 00 00 44 0F 29 84 24 C0 00 00 00 4C 8B 1D ?? ?? ?? ?? 0F 84 CE 07 00 00 F3 0F 5A D2 F2 0F 11 94 24 D0 00 00 00 44 0F B7 84 24 D6 00 00 00 41 81 E0 F0 7F 00 00 F2 0F 11 54 24 38 41 C1 E8 04 80 64 24 3F 7F 45 85 C0 0F 8E 6A 07 00 00 41 81 F8 C9 03 00 00 0F 8E FA 06 00 00 F2 0F 10 44 24 38 F2 0F 10 0D ?? ?? ?? ?? 66 0F 2F C8 0F 86 C7 06 00 00 F2 0F 10 0D ?? ?? ?? ?? 66 0F 2F C8 0F 86 51 05 00 00 66 0F 2F 05 ?? ?? ?? ?? 0F 82 D4 04 00 00 F2 44 0F 10 2D ?? ?? ?? ?? 4C 8D 15 ?? ?? ?? ?? F2 44 0F 59 E8 F2 44 0F 10 25 ?? ?? ?? ?? F2 0F 10 25 ?? ?? ?? ?? 4C 89 5C 24 48 49 C1 EB 30 F2 44 0F 58 2D ?? ?? ?? ?? F2 44 0F 11 6C 24 30 41 81 E3 0F 80 FF FF F2 44 0F 10 74 24 30 44 8B 44 24 30 41 8B C8 C1 E9 06 41 83 E0 3F 81 C1 FF 03 00 00 F2 44 0F 5C 35 ?? ?? ?? ?? F2 45 0F 59 E6 81 E1 FF 07 00 00 44 0F 57 35 ?? ?? ?? ?? 44 8D 49 FF F2 44 0F 59 35 ?? ?? ?? ?? F2 41 0F 5C C4 44 0F 28 C8 0F 28 E8 41 81 E1 FF 07 00 00 F7 D9 41 C1 E1 04 83 C1 FC 45 0B D9 47 8D 0C 00 81 E1 FF 07 00 00 66 44 89 5C 24 4E 41 81 E3 0F 80 FF FF C1 E1 04 47 8D 44 00 01 44 0B D9 F2 45 0F 58 CE F2 44 0F 11 4C 24 40 F2 44 0F 10 54 24 40 F2 41 0F 5C EA F2 0F 11 6C 24 20 F2 44 0F 10 5C 24 40 F2 44 0F 10 44 24 20 F2 45 0F 58 D8 F2 44 0F 11 5C 24 28 F2 44 0F 10 7C 24 20 F2 45 0F 58 F7 F2 44 0F 10 7C 24 48 F2 44 0F 11 74 24 20 F2 44 0F 10 5C 24 28 66 44 89 5C 24 4E 4D 8B DA F2 41 0F 5C C3 F2 0F 11 44 24 28 F2 44 0F 10 64 24 20 F2 44 0F 10 6C 24 28 F2 45 0F 58 E5 F2 44 0F 11 64 24 28 F2 0F 10 6C 24 40 0F 28 D5 44 0F 28 DD F2 0F 59 D4 0F 28 CD F2 44 0F 59 DD F2 44 0F 10 44 24 28 F2 0F 11 54 24 40 F2 44 0F 10 4C 24 40 F2 43 0F 10 14 C2 4D 8B C2 F2 41 0F 59 D7 F2 44 0F 5C CD F2 44 0F 11 4C 24 20 F2 44 0F 10 0D ?? ?? ?? ?? F2 45 0F 59 CB F2 0F 10 5C 24 40 F2 44 0F 10 54 24 20 F2 41 0F 5C DA F2 44 0F 10 15 ?? ?? ?? ?? F2 45 0F 59 D3 F2 44 0F 58 0D ?? ?? ?? ?? F2 0F 11 5C 24 40 F2 0F 10 44 24 40 F2 45 0F 59 CB F2 0F 5C C8 F2 44 0F 58 15 ?? ?? ?? ?? F2 44 0F 58 0D ?? ?? ?? ?? F2 45 0F 59 D3 F2 45 0F 59 CB F2 44 0F 59 D5 F2 43 0F 10 04 CA 41 F7 D9 F2 0F 11 4C 24 20 F2 41 0F 59 C7 F2 44 0F 10 5C 24 48 41 8D 89 80 00 00 00 41 81 C1 81 00 00 00 44 0F 28 F0 F2 44 0F 10 6C 24 40 F2 41 0F 10 0C CB F2 44 0F 10 64 24 20 F2 41 0F 59 CB F2 43 0F 10 1C C8 F2 44 0F 5C F1 F2 41 0F 59 DB F2 44 0F 11 74 24 40 44 0F 28 D8 F2 44 0F 10 7C 24 40 44 8A 94 24 D7 00 00 00 F2 45 0F 5C DF 41 80 E2 80 F2 44 0F 5C D9 F2 44 0F 11 5C 24 20 F2 44 0F 10 5C 24 40 F2 44 0F 10 74 24 20 45 0F 28 FB F2 44 0F 5C F3 F2 44 0F 58 F2 F2 0F 58 D3 F2 45 0F 58 FE F2 44 0F 11 7C 24 40 F2 44 0F 10 7C 24 40 F2 45 0F 5C DF 44 0F 28 F8 F2 44 0F 58 F9 F2 45 0F 58 DE F2 44 0F 11 5C 24 20 F2 44 0F 10 74 24 40 F2 44 0F 10 5C 24 20 F2 44 0F 11 7C 24 40 F2 44 0F 10 7C 24 40 F2 41 0F 5C C7 F2 0F 58 C1 F2 0F 11 44 24 20 F2 0F 10 4C 24 40 F2 0F 10 44 24 20 0F 28 D9 F2 0F 58 D0 F2 0F 58 DA F2 0F 11 5C 24 40 F2 0F 10 44 24 40 F2 0F 5C C8 F2 0F 58 CA F2 0F 11 4C 24 20 F2 0F 10 44 24 40 F2 0F 59 E0 0F 28 C8 F2 0F 10 5C 24 20 F2 0F 11 64 24 40 F2 0F 10 64 24 40 F2 0F 59 EB F2 0F 5C E0 F2 0F 11 64 24 20 F2 44 0F 10 7C 24 40 F2 0F 10 54 24 20 F2 44 0F 5C FA F2 44 0F 11 7C 24 40 45 0F 28 F8 F2 0F 10 64 24 40 F2 44 0F 59 FB F2 0F 5C CC F2 44 0F 59 C0 F2 0F 11 4C 24 20 41 0F 28 CA F2 0F 59 CB F2 44 0F 59 D0 F2 44 0F 58 F9 41 0F 28 C9 F2 41 0F 59 CB F2 45 0F 59 CE F2 44 0F 58 F9 F2 0F 10 54 24 40 41 0F 28 CC F2 0F 10 64 24 20 F2 44 0F 58 FD F2 0F 59 CC F2 41 0F 59 E5 F2 44 0F 59 EA F2 45 0F 58 F8 F2 44 0F 59 E2 F2 45 0F 58 DF 41 0F 28 EA F2 41 0F 58 E9 F2 0F 11 6C 24 40 F2 44 0F 10 44 24 40 F2 45 0F 5C D0 F2 45 0F 58 D1 45 0F 28 CE F2 44 0F 11 54 24 20 F2 0F 10 5C 24 40 F2 0F 10 44 24 20 0F 28 D3 F2 44 0F 58 D8 F2 41 0F 58 D5 F2 44 0F 58 D9 F2 0F 11 54 24 40 F2 44 0F 58 DC F2 0F 10 64 24 40 F2 45 0F 58 DC F2 44 0F 5C EC F2 44 0F 58 EB F2 44 0F 11 6C 24 20 F2 44 0F 10 54 24 40 F2 0F 10 6C 24 20 F2 45 0F 58 CA F2 44 0F 58 DD F2 44 0F 11 4C 24 40 F2 44 0F 10 44 24 40 F2 45 0F 5C F0 F2 45 0F 58 F2 F2 44 0F 11 74 24 20 F2 44 0F 10 6C 24 40 F2 44 0F 10 64 24 20 F2 45 0F 58 DC F2 45 0F 58 DD F2 44 0F 11 5C 24 38 8A 4C 24 3F 80 E1 7F 41 0A CA 88 4C 24 3F F2 44 0F 5A 5C 24 38 F3 44 0F 11 1A E9 0A 02 00 00 0F 28 D0 F2 0F 59 D0 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 CA 8A 8C 24 D7 00 00 00 80 E1 80 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 D1 F2 0F 59 D0 F2 0F 58 C2 F2 0F 11 44 24 38 44 8A 44 24 3F 41 80 E0 7F 44 0A C1 44 88 44 24 3F F2 0F 5A 44 24 38 F3 0F 11 02 E9 9B 01 00 00 F2 0F 10 0D ?? ?? ?? ?? 4C 8D 15 ?? ?? ?? ?? F2 0F 59 C8 F2 0F 10 15 ?? ?? ?? ?? F2 0F 10 1D ?? ?? ?? ?? 4C 89 5C 24 48 F2 0F 58 0D ?? ?? ?? ?? F2 0F 11 4C 24 30 F2 0F 10 64 24 30 F2 0F 10 0D ?? ?? ?? ?? 44 8B 44 24 30 41 8B C8 83 E1 3F F2 0F 5C 25 ?? ?? ?? ?? F2 0F 59 D4 44 8D 0C 09 F2 0F 59 E3 F2 0F 5C C2 8D 4C 09 01 F2 0F 5C C4 F2 0F 59 C8 41 C1 E8 06 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 41 81 C0 FE 03 00 00 41 81 E0 FF 07 00 00 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 41 81 F8 FE 07 00 00 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 59 C8 F2 0F 58 C8 F2 43 0F 10 04 CA F2 0F 59 C8 F2 41 0F 58 0C CA F2 0F 58 C8 77 2A 49 C1 EB 30 41 C1 E0 04 41 81 E3 0F 80 FF FF 45 0B D8 66 44 89 5C 24 4E F2 0F 10 44 24 48 F2 0F 59 C8 F2 0F 11 4C 24 38 EB 39 41 FF C8 41 81 E0 FF 07 00 00 0F B7 4C 24 4E 41 C1 E0 04 81 E1 0F 80 FF FF 41 0B C8 66 89 4C 24 4E F2 0F 10 44 24 48 F2 0F 59 C8 F2 0F 59 0D ?? ?? ?? ?? F2 0F 11 4C 24 38 44 8A 44 24 3F 8A 8C 24 D7 00 00 00 41 80 E0 7F 80 E1 80 44 0A C1 44 88 44 24 3F F2 0F 5A 44 24 38 F3 0F 11 02 EB 37 F2 0F 10 05 ?? ?? ?? ?? B8 03 00 00 00 F2 0F 59 C2 F2 0F 5A C0 F3 0F 11 02 EB 1C F2 0F 10 05 ?? ?? ?? ?? F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C2 F2 0F 5A C0 F3 0F 11 02 44 0F 28 84 24 C0 00 00 00 44 0F 28 8C 24 B0 00 00 00 44 0F 28 94 24 A0 00 00 00 44 0F 28 9C 24 90 00 00 00 44 0F 28 A4 24 80 00 00 00 44 0F 28 6C 24 70 44 0F 28 74 24 60 44 0F 28 7C 24 50 48 81 C4 D8 00 00 00 C3 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 D0 F2 0F 11 54 24 40 F3 0F 5A 11 F2 0F 10 4C 24 40 4C 89 5C 24 48 F2 0F 58 D1 F2 0F 5A D2 F3 0F 11 12 EB 8A F3 0F 58 D2 F3 0F 11 12 EB 80 66 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_174_0_0 {
	meta:
		name = "__common_spow_cout_rare"
		size = 2976
		refs = "0187 _2il0floatpacket_112 01b7 _vmlsPowHATab 01e9 _2il0floatpacket_113 0390 _2il0floatpacket_115 039f _2il0floatpacket_114 050f _2il0floatpacket_124 063f _2il0floatpacket_116 0669 _2il0floatpacket_117 0681 _2il0floatpacket_118 068d _2il0floatpacket_119 07c5 _2il0floatpacket_120 07ea _2il0floatpacket_121 0836 _2il0floatpacket_122 0845 _2il0floatpacket_123 098d _2il0floatpacket_126"
	strings:
		$1 = { 53 41 54 41 55 41 57 55 48 81 EC 90 00 00 00 33 C0 F3 0F 10 21 66 0F EF C0 F3 0F 10 1A 0F 28 CC 8B 12 0F 28 D3 44 0F 29 7C 24 60 44 0F 29 74 24 70 44 0F 29 AC 24 80 00 00 00 44 0F 29 44 24 50 0F 29 7C 24 40 8B 09 0F 2E E0 7A 02 74 06 89 4C 24 28 EB 0D 0F 28 CC F3 0F 58 CC F3 0F 11 4C 24 28 0F 2E D8 7A 02 74 06 89 54 24 3C EB 0D 0F 28 D3 F3 0F 58 D3 F3 0F 11 54 24 3C 66 0F 7E D5 41 BC 01 00 00 00 45 33 DB F7 44 24 28 FF FF 7F 00 0F B7 54 24 3E 45 0F 44 DC 45 33 D2 81 E5 FF FF FF 7F 81 E2 80 7F 00 00 45 33 C9 F7 44 24 3C FF FF 7F 00 44 0F B7 7C 24 2A 45 0F 44 D4 41 81 E7 80 7F 00 00 C1 EA 07 8D 8D 00 00 80 C0 81 FA FF 00 00 00 44 0F B6 6C 24 2B 8A 5C 24 3F 45 0F 45 CC 41 81 E5 80 00 00 00 80 E3 80 41 C1 EF 07 41 C1 ED 07 C0 EB 07 81 F9 00 00 00 40 73 3E 81 FD 00 00 80 4B 0F 8D 27 05 00 00 8B CD 81 E1 00 00 80 FF 81 C1 00 00 80 00 C1 E9 17 D3 E5 F7 C5 FF FF 7F 00 75 17 81 E5 FF FF FF 00 81 FD 00 00 80 00 BD 02 00 00 00 41 0F 44 EC EB 02 33 ED 45 85 ED 75 0A 41 83 FF 7F 0F 84 3C 0A 00 00 85 D2 75 09 45 85 D2 0F 85 6C 04 00 00 33 C9 41 81 FF FF 00 00 00 41 0F 45 CC 44 0B D9 0F 84 4B 04 00 00 45 0B D1 0F 84 42 04 00 00 0F 2E C8 7A 06 0F 84 B8 09 00 00 0F 2E 0D ?? ?? ?? ?? 7A 06 0F 84 83 09 00 00 85 C9 0F 84 BE 03 00 00 45 85 C9 0F 84 B5 03 00 00 0F 2F C8 77 08 85 ED 0F 84 7D 03 00 00 41 23 ED 48 8D 0D ?? ?? ?? ?? F3 0F 11 4C 24 2C 80 64 24 2F 7F 45 85 FF F3 44 0F 10 B4 A9 CC 05 00 00 B9 00 00 00 00 75 1B F3 0F 10 44 24 2C B9 C0 FF FF FF F3 0F 59 05 ?? ?? ?? ?? F3 0F 11 44 24 2C EB 06 F3 0F 10 44 24 2C F3 0F 11 44 24 30 4C 8D 25 ?? ?? ?? ?? 44 0F B7 54 24 32 4D 8B EC 41 81 E2 7F 80 FF FF 4D 8B FC 41 81 CA 80 3F FF FF 66 44 89 54 24 32 4D 8B D4 8B 6C 24 30 81 E5 00 00 78 00 44 0F B7 4C 24 2E 81 C5 00 00 08 00 41 81 E1 80 7F 00 00 41 C1 E9 07 C1 ED 14 44 8B 5C 24 2C 41 C1 E1 17 41 81 E3 FF FF 7F 00 45 0B CB 41 81 C1 00 00 C8 C0 4D 8B DD 41 C1 F9 17 44 03 C9 F3 45 0F 10 04 AC 03 ED F3 45 0F 2A E9 F3 0F 10 6C 24 30 4D 8B CD 0F 28 FD F3 41 0F 10 64 AD 24 F3 41 0F 59 F8 44 0F 28 FC F3 45 0F 58 FD 66 0F 7E F9 F3 44 0F 11 7C 24 34 81 E1 00 00 1E 00 F3 44 0F 10 7C 24 34 81 C1 00 00 02 00 C1 E9 12 F3 45 0F 5C EF F3 41 0F 58 E5 F3 41 0F 10 5C 8F 6C 03 C9 F3 0F 11 64 24 38 F3 44 0F 10 7C 24 34 41 0F 28 E7 F3 0F 59 FB F3 44 0F 59 C3 66 41 0F 7E FC F3 41 0F 10 84 8A 90 00 00 00 0F 28 DD F3 44 0F 10 6C 24 38 F3 0F 58 E0 F3 0F 11 64 24 34 41 81 E4 00 C0 07 00 F3 0F 10 64 24 34 41 81 C4 00 40 00 00 41 C1 EC 0F F3 44 0F 5C FC F3 44 0F 58 F8 F3 43 0F 10 94 A3 D8 00 00 00 45 03 E4 F3 44 0F 11 7C 24 38 F3 0F 10 64 24 34 44 0F 28 FC F3 43 0F 10 8C A5 1C 01 00 00 F3 0F 10 44 24 38 F3 44 0F 58 F9 F3 44 0F 58 E8 F3 44 0F 59 C2 F3 44 0F 11 7C 24 34 F3 44 0F 10 7C 24 34 F3 41 0F 5C E7 F3 0F 59 FA F3 0F 58 E1 F3 0F 10 15 ?? ?? ?? ?? 0F 28 C7 F3 0F 59 DA F3 0F 5C 05 ?? ?? ?? ?? F3 0F 11 64 24 38 F3 0F 10 64 24 34 F3 0F 10 4C 24 38 F3 0F 11 5C 24 34 F3 44 0F 58 E9 F3 0F 10 4C 24 34 F3 0F 5C 4C 24 30 F3 45 0F 58 6C A9 28 F3 0F 11 4C 24 38 49 8B ED F3 0F 10 4C 24 34 F3 44 0F 10 7C 24 38 F3 41 0F 5C CF F3 44 0F 58 AC 8D 94 00 00 00 F3 0F 11 4C 24 34 F3 0F 10 5C 24 34 F3 0F 5C EB F3 47 0F 58 AC A7 20 01 00 00 F3 0F 11 6C 24 38 41 0F 28 E8 F3 0F 59 EA F3 44 0F 10 7C 24 34 F3 0F 10 4C 24 38 F3 0F 11 6C 24 34 F3 0F 10 54 24 34 F3 41 0F 5C D0 F3 0F 11 54 24 38 F3 0F 10 54 24 34 F3 0F 10 5C 24 38 F3 0F 5C D3 41 0F 28 DF F3 0F 11 54 24 34 F3 0F 10 6C 24 34 F3 44 0F 5C C5 F3 44 0F 11 44 24 38 F3 44 0F 10 44 24 34 F3 41 0F 59 D8 F3 44 0F 59 C1 F3 0F 5C DF 0F 28 F8 F3 41 0F 58 D8 F3 0F 58 FC F3 0F 10 54 24 38 F3 0F 11 7C 24 34 F3 44 0F 59 FA F3 0F 59 CA F3 41 0F 58 DF F3 0F 10 54 24 34 F3 0F 58 CB F3 0F 5C E2 F3 0F 58 E0 F3 0F 11 64 24 38 F3 0F 10 5C 24 34 F3 0F 11 5C 24 28 0F B7 4C 24 2A 81 E1 80 7F 00 00 C1 E9 07 03 D1 F3 0F 10 54 24 38 81 FA 09 01 00 00 0F 8D F3 05 00 00 81 FA C0 00 00 00 0F 8F 3E 01 00 00 C7 44 24 34 00 00 80 3F F3 0F 10 44 24 34 F3 0F 58 05 ?? ?? ?? ?? F3 0F 11 44 24 34 F3 0F 10 4C 24 34 F3 44 0F 59 F1 F3 45 0F 11 30 E9 D3 00 00 00 33 C0 89 44 24 34 41 8B C4 F3 0F 10 4C 24 34 F3 0F 10 44 24 34 F3 0F 5E C8 F3 0F 11 4C 24 34 8B 54 24 34 41 89 10 E9 A8 00 00 00 41 83 FF 7F 7D 1C 84 DB 74 0E F3 0F 59 D2 F3 41 0F 11 10 E9 90 00 00 00 33 D2 41 89 10 E9 86 00 00 00 84 DB 74 1A 41 23 ED 48 8D 15 ?? ?? ?? ?? 8B 8C AA E8 05 00 00 89 4C 24 2C 41 89 08 EB 68 F3 0F 59 C9 41 23 ED F3 0F 59 D1 48 8D 15 ?? ?? ?? ?? F3 0F 59 94 AA CC 05 00 00 F3 41 0F 11 10 EB 46 F3 0F 58 E3 F3 41 0F 11 20 EB 3B F3 0F 58 CA F3 0F 11 4C 24 34 C7 44 24 38 00 00 80 3F 8A 54 24 37 8A 4C 24 3B 80 E2 80 80 E1 7F 0A CA 88 4C 24 3B F3 0F 10 4C 24 38 F3 0F 10 44 24 38 F3 0F 59 C8 F3 41 0F 11 08 0F 28 7C 24 40 44 0F 28 44 24 50 44 0F 28 AC 24 80 00 00 00 44 0F 28 74 24 70 44 0F 28 7C 24 60 48 81 C4 90 00 00 00 5D 41 5F 41 5D 41 5C 5B C3 BD 02 00 00 00 E9 03 FB FF FF F3 0F 10 2D ?? ?? ?? ?? 48 8D 1D ?? ?? ?? ?? F3 44 0F 10 44 24 28 48 8B EB F3 0F 58 C1 F3 0F 58 CA F3 0F 59 E8 F3 44 0F 58 E9 F3 0F 58 2D ?? ?? ?? ?? F3 0F 59 E8 45 0F 28 FD F3 0F 10 0D ?? ?? ?? ?? F3 0F 58 2D ?? ?? ?? ?? F3 0F 59 E8 F3 0F 58 2D ?? ?? ?? ?? F3 0F 59 E8 F3 0F 58 DD F3 0F 11 5C 24 34 F3 0F 10 7C 24 34 F3 44 0F 5C C7 F3 44 0F 58 C5 F3 44 0F 11 44 24 38 F3 0F 10 44 24 34 F3 0F 10 54 24 38 F3 44 0F 58 F8 F3 44 0F 11 7C 24 34 F3 0F 10 64 24 34 F3 0F 5C C4 F3 41 0F 58 C5 44 0F 28 E9 F3 0F 11 44 24 38 F3 0F 10 44 24 34 F3 44 0F 59 E8 F3 0F 10 64 24 38 F3 44 0F 11 6C 24 34 F3 0F 58 E2 F3 0F 10 5C 24 34 F3 0F 59 64 24 3C F3 0F 5C D8 F3 0F 11 5C 24 38 F3 0F 10 7C 24 34 F3 0F 10 6C 24 38 F3 0F 5C FD F3 0F 10 6C 24 3C F3 0F 59 CD F3 0F 11 7C 24 34 F3 44 0F 10 44 24 34 F3 41 0F 5C C0 F3 0F 11 44 24 38 F3 0F 10 54 24 34 F3 0F 10 5C 24 38 F3 0F 11 4C 24 34 F3 0F 10 44 24 34 F3 0F 5C 44 24 3C F3 0F 11 44 24 38 F3 44 0F 10 6C 24 34 F3 44 0F 10 7C 24 38 F3 45 0F 5C EF F3 44 0F 11 6C 24 34 F3 0F 10 44 24 34 F3 0F 5C E8 F3 0F 11 6C 24 38 F3 0F 10 7C 24 34 F3 0F 10 4C 24 38 44 0F 28 EF 0F 28 C1 F3 0F 59 C3 F3 0F 59 FB F3 44 0F 59 EA F3 0F 59 D1 F3 0F 58 C7 F3 0F 10 1D ?? ?? ?? ?? F3 0F 58 C2 41 0F 28 D5 F3 0F 58 E0 F3 0F 58 D3 F3 0F 11 54 24 34 F3 44 0F 10 44 24 34 F3 0F 10 0D ?? ?? ?? ?? F3 44 0F 5C C3 F3 44 0F 11 44 24 20 F3 44 0F 10 7C 24 20 8B 4C 24 34 8B D1 83 E1 7F F3 45 0F 5C EF F3 44 0F 11 6C 24 24 03 C9 F3 0F 10 44 24 24 F3 0F 58 E0 F3 0F 59 CC F3 0F 10 84 8B A4 01 00 00 C1 E2 0A F3 0F 58 0D ?? ?? ?? ?? F3 0F 59 CC C1 FA 11 F3 0F 58 0D ?? ?? ?? ?? F3 0F 59 CC F3 0F 59 C8 F3 0F 58 8C 8D A8 01 00 00 0F 28 D1 F3 0F 58 D0 F3 0F 11 54 24 2C 0F B7 5C 24 2E 8B CB 81 E1 80 7F 00 00 C1 E9 07 83 C1 81 03 CA 81 F9 80 00 00 00 0F 8D 22 02 00 00 83 F9 82 7C 31 83 C1 7F 81 E3 7F 80 FF FF 0F B6 C9 C1 E1 07 0B D9 66 89 5C 24 2E F3 0F 10 44 24 2C F3 41 0F 59 C6 F3 0F 11 44 24 2C F3 41 0F 11 00 E9 43 FD FF FF 81 F9 78 FF FF FF 0F 8C 20 01 00 00 F3 0F 11 54 24 34 83 C2 40 F3 0F 10 54 24 34 B9 00 00 80 3F 89 4C 24 28 83 C2 7F C1 E9 10 F3 0F 5C C2 0F B7 D9 F3 0F 58 C1 F3 0F 11 44 24 38 81 E3 7F 80 FF FF F3 44 0F 10 44 24 34 F3 0F 10 0D ?? ?? ?? ?? F3 41 0F 59 C8 F3 0F 10 44 24 38 F3 0F 11 4C 24 34 F3 0F 10 5C 24 34 0F B6 D2 F3 41 0F 5C D8 F3 0F 11 5C 24 38 F3 0F 10 6C 24 34 F3 0F 10 64 24 38 C1 E2 07 F3 0F 5C EC F3 0F 11 6C 24 34 0B DA F3 0F 10 7C 24 34 66 89 5C 24 2A F3 44 0F 5C C7 F3 44 0F 11 44 24 38 F3 0F 10 5C 24 34 F3 44 0F 10 6C 24 38 F3 44 0F 10 7C 24 28 F3 41 0F 58 C5 F3 41 0F 59 DF F3 41 0F 59 C7 F3 44 0F 10 2D ?? ?? ?? ?? F3 41 0F 59 C5 F3 41 0F 59 DD F3 0F 11 44 24 34 F3 0F 10 44 24 34 C7 44 24 34 00 00 80 00 F3 0F 58 D8 F3 0F 10 4C 24 34 F3 44 0F 10 7C 24 34 F3 41 0F 59 CF F3 0F 11 4C 24 34 F3 0F 10 54 24 34 F3 0F 58 DA F3 44 0F 59 F3 F3 0F 11 5C 24 2C F3 45 0F 11 30 E9 17 FC FF FF 81 F9 61 FF FF FF 7C 7E B9 00 00 80 3F 81 C2 BF 00 00 00 89 4C 24 28 C1 E9 10 0F B7 D9 0F B6 D2 81 E3 7F 80 FF FF C1 E2 07 0B DA 66 89 5C 24 2A F3 0F 10 05 ?? ?? ?? ?? F3 0F 10 4C 24 28 F3 44 0F 59 F0 F3 0F 59 D1 C7 44 24 34 00 00 80 00 F3 44 0F 59 F2 F3 0F 10 54 24 34 F3 0F 10 5C 24 34 F3 0F 59 DA F3 0F 11 5C 24 34 F3 0F 10 64 24 34 F3 44 0F 58 F4 F3 44 0F 11 74 24 2C F3 45 0F 11 30 E9 91 FB FF FF C7 44 24 34 00 00 80 00 F3 0F 10 44 24 34 F3 0F 10 4C 24 34 F3 0F 59 C8 F3 0F 11 4C 24 34 F3 0F 10 54 24 34 F3 44 0F 59 F2 F3 44 0F 11 74 24 2C F3 45 0F 11 30 E9 57 FB FF FF C7 44 24 34 00 00 00 7F F3 0F 10 4C 24 34 F3 0F 10 44 24 34 F3 0F 59 C8 F3 0F 11 4C 24 34 F3 0F 10 54 24 34 F3 44 0F 59 F2 F3 44 0F 11 74 24 2C F3 45 0F 11 30 E9 1D FB FF FF 8A 54 24 2B 48 8D 0D ?? ?? ?? ?? 80 E2 80 C0 EA 07 32 DA 0F B6 DB F3 0F 10 84 99 C0 05 00 00 F3 0F 59 C0 F3 41 0F 59 C6 F3 41 0F 11 00 E9 EB FA FF FF 85 ED 75 09 45 85 C9 0F 85 70 F6 FF FF 83 E5 01 48 8D 15 ?? ?? ?? ?? 8B 8C AA CC 05 00 00 41 89 08 E9 C5 FA FF FF F3 0F 59 C9 84 DB 74 24 41 23 ED 48 8D 05 ?? ?? ?? ?? F3 0F 10 84 A8 CC 05 00 00 41 8B C4 F3 0F 5E C1 F3 41 0F 11 00 E9 99 FA FF FF 41 23 ED 48 8D 15 ?? ?? ?? ?? F3 0F 10 84 AA CC 05 00 00 F3 0F 59 C1 F3 41 0F 11 00 E9 78 FA FF FF 45 85 DB 0F 84 BB F5 FF FF E9 2F FA FF FF 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_176_0_0 {
	meta:
		name = "__sse2_atan22"
		size = 736
		refs = "0027 iSignMask 005c dbPio2hi 00b8 iAbsMask 00d8 iMinWorkNum 00e1 iMaxWorkNum 012c dbPi 0158 dbA19 0160 dbA18 0168 dbA17 0170 dbA16 0193 dbA15 019b dbA14 01a3 dbA13 01ab dbA12 01c3 dbA11 01cb dbA10 01d3 dbA09 01db dbA08 01f3 dbA07 01fb dbA06 0203 dbA05 020b dbA04 0223 dbA03 022b dbA02 0233 dbA01 023b dbA00"
	strings:
		$1 = { 48 81 EC A8 00 00 00 0F 29 B4 24 90 00 00 00 0F 29 BC 24 80 00 00 00 66 0F 29 44 24 60 66 0F 29 4C 24 70 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F 54 D0 66 0F 54 D9 66 0F 29 54 24 20 66 0F 29 5C 24 30 66 0F 57 C2 66 0F 57 CB 66 0F 28 D0 66 0F C2 D1 05 66 0F 28 1D ?? ?? ?? ?? 66 0F 28 E2 66 0F 54 DA 66 0F 54 25 ?? ?? ?? ?? 66 0F 56 CC 66 0F 28 E2 66 0F 28 E8 66 0F 28 F1 66 0F 54 C2 66 0F 54 CA 66 0F 55 D6 66 0F 55 E5 66 0F 56 CC 66 0F 56 D0 66 0F 5E CA 66 0F 28 64 24 60 66 0F 28 6C 24 60 66 0F 28 74 24 70 66 0F 28 7C 24 70 66 0F 54 25 ?? ?? ?? ?? 66 0F 54 2D ?? ?? ?? ?? 66 0F 54 35 ?? ?? ?? ?? 66 0F 54 3D ?? ?? ?? ?? 66 0F C2 25 ?? ?? ?? ?? 06 66 0F C2 2D ?? ?? ?? ?? 01 66 0F C2 35 ?? ?? ?? ?? 06 66 0F C2 3D ?? ?? ?? ?? 01 66 0F 54 E5 66 0F 54 F7 66 0F 54 E6 66 0F 50 C4 83 F8 03 89 84 24 A0 00 00 00 0F 8C 63 01 00 00 66 0F 28 64 24 30 66 0F 72 E4 1F 66 0F 70 E4 F5 66 0F 54 25 ?? ?? ?? ?? 66 0F 29 64 24 40 66 0F 29 5C 24 50 66 0F 28 E1 66 0F 59 C9 66 0F 28 E9 66 0F 59 C9 66 0F 28 C1 66 0F 59 C9 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 3D ?? ?? ?? ?? 66 0F 59 D1 66 0F 59 D9 66 0F 59 F1 66 0F 59 F9 C7 84 24 A0 00 00 00 03 00 00 00 66 0F 58 15 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 58 3D ?? ?? ?? ?? 66 0F 59 D1 66 0F 59 D9 66 0F 59 F1 66 0F 59 F9 66 0F 58 15 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 58 3D ?? ?? ?? ?? 66 0F 59 D1 66 0F 59 D9 66 0F 59 F1 66 0F 59 F9 66 0F 58 15 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 58 3D ?? ?? ?? ?? 66 0F 59 D1 66 0F 59 D9 66 0F 59 F1 66 0F 59 F9 66 0F 58 15 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 58 3D ?? ?? ?? ?? 66 0F 59 D0 66 0F 59 D5 66 0F 59 D8 66 0F 59 F5 66 0F 58 D3 66 0F 58 F7 66 0F 58 F2 66 0F 59 F4 66 0F 58 74 24 50 66 0F 56 74 24 30 66 0F 58 74 24 40 66 0F 56 74 24 20 66 0F 28 C6 0F 28 B4 24 90 00 00 00 0F 28 BC 24 80 00 00 00 83 BC 24 A0 00 00 00 03 7D 34 F2 0F 10 44 24 60 F2 0F 10 4C 24 70 E8 3A 00 00 00 F2 0F 11 44 24 60 F2 0F 10 44 24 68 F2 0F 10 4C 24 78 E8 23 00 00 00 F2 0F 11 44 24 68 66 0F 28 44 24 60 48 81 C4 A8 00 00 00 C3 66 66 66 66 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_176_1_0 {
	meta:
		name = "__common_atan2_sd"
		size = 944
		refs = "0027 iSignMask 005c dbPio2hi 00b8 iAbsMask 00d8 iMinWorkNum 00e1 iMaxWorkNum 0125 dbPi 0151 dbA19 0159 dbA18 0161 dbA17 0169 dbA16 0181 dbA15 0189 dbA14 0191 dbA13 0199 dbA12 01b1 dbA11 01b9 dbA10 01c1 dbA09 01c9 dbA08 01e1 dbA07 01e9 dbA06 01f1 dbA05 01f9 dbA04 0211 dbA03 0219 dbA02 0221 dbA01 0229 dbA00 027e dbZero 0336 db3Pio4hi 0348 dbPio4hi"
	strings:
		$1 = { 48 81 EC A8 00 00 00 0F 29 B4 24 90 00 00 00 0F 29 BC 24 80 00 00 00 66 0F D6 44 24 20 66 0F D6 4C 24 30 F3 0F 7E 15 ?? ?? ?? ?? F3 0F 7E 1D ?? ?? ?? ?? 66 0F 54 D0 66 0F 54 D9 66 0F D6 54 24 40 66 0F D6 5C 24 50 66 0F 57 C2 66 0F 57 CB F3 0F 7E D0 F2 0F C2 D1 05 F3 0F 7E 1D ?? ?? ?? ?? F3 0F 7E E2 66 0F 54 DA 66 0F 54 25 ?? ?? ?? ?? 66 0F 56 CC F3 0F 7E E2 F3 0F 7E E8 F3 0F 7E F1 66 0F 54 C2 66 0F 54 CA 66 0F 55 D6 66 0F 55 E5 66 0F 56 CC 66 0F 56 D0 F2 0F 5E CA F3 0F 7E 64 24 20 F3 0F 7E 6C 24 20 F3 0F 7E 74 24 30 F3 0F 7E 7C 24 30 66 0F 54 25 ?? ?? ?? ?? 66 0F 54 2D ?? ?? ?? ?? 66 0F 54 35 ?? ?? ?? ?? 66 0F 54 3D ?? ?? ?? ?? F2 0F C2 25 ?? ?? ?? ?? 06 F2 0F C2 2D ?? ?? ?? ?? 01 F2 0F C2 35 ?? ?? ?? ?? 06 F2 0F C2 3D ?? ?? ?? ?? 01 66 0F 54 E5 66 0F 54 F7 66 0F 54 E6 66 0F 50 D4 83 E2 01 0F 84 5D 01 00 00 F3 0F 7E 64 24 50 66 0F 72 E4 1F 66 0F 70 E4 F5 66 0F 54 25 ?? ?? ?? ?? 66 0F D6 64 24 60 66 0F D6 5C 24 70 F3 0F 7E E1 F2 0F 59 C9 F3 0F 7E E9 F2 0F 59 C9 F3 0F 7E C1 F2 0F 59 C9 F3 0F 7E 15 ?? ?? ?? ?? F3 0F 7E 1D ?? ?? ?? ?? F3 0F 7E 35 ?? ?? ?? ?? F3 0F 7E 3D ?? ?? ?? ?? F2 0F 59 D1 F2 0F 59 D9 F2 0F 59 F1 F2 0F 59 F9 F2 0F 58 15 ?? ?? ?? ?? F2 0F 58 1D ?? ?? ?? ?? F2 0F 58 35 ?? ?? ?? ?? F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 D1 F2 0F 59 D9 F2 0F 59 F1 F2 0F 59 F9 F2 0F 58 15 ?? ?? ?? ?? F2 0F 58 1D ?? ?? ?? ?? F2 0F 58 35 ?? ?? ?? ?? F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 D1 F2 0F 59 D9 F2 0F 59 F1 F2 0F 59 F9 F2 0F 58 15 ?? ?? ?? ?? F2 0F 58 1D ?? ?? ?? ?? F2 0F 58 35 ?? ?? ?? ?? F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 D1 F2 0F 59 D9 F2 0F 59 F1 F2 0F 59 F9 F2 0F 58 15 ?? ?? ?? ?? F2 0F 58 1D ?? ?? ?? ?? F2 0F 58 35 ?? ?? ?? ?? F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 D0 F2 0F 59 D5 F2 0F 59 D8 F2 0F 59 F5 F2 0F 58 D3 F2 0F 58 F7 F2 0F 58 F2 F2 0F 59 F4 F2 0F 58 74 24 70 66 0F 56 74 24 50 F2 0F 58 74 24 60 66 0F 56 74 24 40 F3 0F 7E C6 E9 10 01 00 00 F3 0F 7E 54 24 20 F3 0F 7E 5C 24 30 F2 0F 58 15 ?? ?? ?? ?? F2 0F 58 1D ?? ?? ?? ?? 66 0F EB 54 24 40 66 0F EB 5C 24 50 66 0F D6 54 24 20 66 0F D6 5C 24 30 F3 0F 7E 44 24 20 48 8B 44 24 20 48 8B 54 24 30 48 23 05 ?? ?? ?? ?? 48 23 15 ?? ?? ?? ?? 48 3B 05 ?? ?? ?? ?? 0F 8F A5 00 00 00 74 42 48 3B 15 ?? ?? ?? ?? 0F 8F 96 00 00 00 48 23 D2 74 1B 48 8B 54 24 30 48 23 15 ?? ?? ?? ?? 75 71 66 0F 54 05 ?? ?? ?? ?? E9 82 00 00 00 48 23 C0 75 4D 48 8B 54 24 30 48 23 15 ?? ?? ?? ?? 75 51 EB DE 48 3B 15 ?? ?? ?? ?? 7F 58 7C 32 48 8B 54 24 30 48 23 15 ?? ?? ?? ?? 74 12 66 0F 54 05 ?? ?? ?? ?? 66 0F 56 05 ?? ?? ?? ?? EB 42 66 0F 54 05 ?? ?? ?? ?? 66 0F 56 05 ?? ?? ?? ?? EB 30 66 0F 54 05 ?? ?? ?? ?? 66 0F 56 05 ?? ?? ?? ?? EB 1E 66 0F 54 05 ?? ?? ?? ?? 66 0F 56 05 ?? ?? ?? ?? EB 0C F3 0F 7E 44 24 20 F2 0F 59 44 24 30 F2 0F 11 84 24 A0 00 00 00 0F 28 B4 24 90 00 00 00 0F 28 BC 24 80 00 00 00 F2 0F 10 84 24 A0 00 00 00 48 81 C4 A8 00 00 00 C3 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_178_0_0 {
	meta:
		name = "__avx_cosh4"
		size = 720
		refs = "000a __common_dcosh_data 02bb __common_dcosh_cout_rare"
	strings:
		$1 = { 48 81 EC 18 02 00 00 48 8D 05 ?? ?? ?? ?? C5 7C 11 B4 24 70 01 00 00 C5 7C 11 A4 24 30 01 00 00 C5 7C 11 94 24 50 01 00 00 C5 7C 11 8C 24 F0 01 00 00 C5 7C 11 84 24 D0 01 00 00 C5 FC 11 BC 24 B0 01 00 00 C5 FC 11 B4 24 90 01 00 00 4C 89 AC 24 10 02 00 00 4C 8D AC 24 CF 00 00 00 C5 FD 10 15 ?? ?? ?? ?? 49 83 E5 C0 C5 FD 10 1D ?? ?? ?? ?? C5 78 10 15 ?? ?? ?? ?? C5 F9 10 2D ?? ?? ?? ?? C5 ED 55 E0 C5 DD 59 3D ?? ?? ?? ?? C5 C5 58 F3 C5 F1 73 D2 0B C4 C3 7D 19 D6 01 C4 C1 69 73 D6 0B C4 C3 7D 19 E1 01 C4 C3 7D 19 F6 01 C4 41 58 C6 E1 DD C4 C1 48 C6 FE 88 C5 19 66 05 ?? ?? ?? ?? C5 41 DB 0D ?? ?? ?? ?? C4 C1 78 50 D0 C4 C1 39 72 F1 03 C5 79 7E C1 C4 41 29 FA D1 C4 C1 19 72 F2 03 C4 41 79 7E E3 48 63 C9 C4 43 79 16 C0 01 4D 63 C0 C4 43 79 16 C1 02 4D 63 C9 C5 FB 10 3C 01 C4 41 41 16 14 00 C4 43 79 16 E0 02 C4 41 7B 10 0C 01 4D 63 C0 C4 43 79 16 E1 03 4D 63 C9 C4 63 79 16 E1 01 C4 C1 7B 10 3C 00 4D 63 DB C4 41 41 16 24 01 C5 CD 5C FB C5 C5 59 1D ?? ?? ?? ?? C5 C5 59 3D ?? ?? ?? ?? C5 DD 5C DB C5 D9 73 F6 2C C4 C1 49 73 F6 2C C5 D9 DB E5 C5 C9 DB ED C4 43 79 16 C2 03 48 63 C9 4D 63 D2 C4 41 7B 10 04 03 C5 E5 5C DF C5 39 16 04 01 C4 41 31 16 0C 02 C5 29 D4 F4 C5 B9 FB E4 C5 31 D4 CD C5 99 FB ED C5 D9 FB C9 C5 D1 FB D2 C5 E5 59 FB C5 45 59 15 ?? ?? ?? ?? C5 2D 58 25 ?? ?? ?? ?? C4 43 0D 18 C9 01 C4 E3 75 18 E2 01 C5 35 5C C4 C5 B5 58 D4 C5 45 59 0D ?? ?? ?? ?? C5 9D 59 FF C5 B5 59 F3 C5 45 59 F2 C5 CD 58 DB C4 C1 65 59 C8 C5 8D 58 D9 C5 E5 58 CA 85 D2 75 53 C5 FC 10 B4 24 90 01 00 00 C5 FC 10 BC 24 B0 01 00 00 C5 7C 10 84 24 D0 01 00 00 C5 7C 10 8C 24 F0 01 00 00 C5 7C 10 94 24 50 01 00 00 C5 7C 10 A4 24 30 01 00 00 C5 7C 10 B4 24 70 01 00 00 4C 8B AC 24 10 02 00 00 C5 FD 28 C1 48 81 C4 18 02 00 00 C3 C4 C1 7D 11 45 00 C4 C1 7D 11 4D 40 74 9F 33 C0 C5 7C 11 5C 24 60 C5 7C 11 6C 24 40 C5 7C 11 7C 24 20 48 89 9C 24 88 00 00 00 8B D8 48 89 B4 24 80 00 00 00 8B F2 0F A3 DE 72 34 FF C3 83 FB 20 7C F4 C5 7C 10 5C 24 60 C5 7C 10 6C 24 40 C5 7C 10 7C 24 20 C4 C1 7D 10 4D 40 48 8B 9C 24 88 00 00 00 48 8B B4 24 80 00 00 00 E9 3E FF FF FF C5 F8 77 49 8D 4C DD 00 49 8D 54 DD 40 E8 ?? ?? ?? ?? EB B8 66 66 66 66 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_179_0_0 {
	meta:
		name = "__avx_atan2f8"
		size = 672
		refs = "005a __common_satan2_data 029a __common_satan2_cout_rare"
	strings:
		$1 = { 48 81 EC 58 02 00 00 C5 7C 11 BC 24 70 01 00 00 C5 7C 11 A4 24 30 02 00 00 C5 7C 11 9C 24 D0 01 00 00 C5 7C 11 94 24 10 02 00 00 C5 7C 11 84 24 F0 01 00 00 C5 FC 11 BC 24 B0 01 00 00 C5 FC 11 B4 24 90 01 00 00 4C 89 AC 24 50 02 00 00 4C 8D AC 24 CF 00 00 00 C5 FC 10 35 ?? ?? ?? ?? 49 83 E5 C0 C5 74 C2 1D ?? ?? ?? ?? 12 C5 F4 54 EE C5 FC 54 D6 C5 6C C2 D5 11 C5 D4 56 3D ?? ?? ?? ?? C4 E3 45 4A E2 A0 C4 63 6D 4A FD A0 C5 A4 54 3D ?? ?? ?? ?? C4 41 5C 5E DF C5 F8 10 25 ?? ?? ?? ?? C5 78 10 3D ?? ?? ?? ?? C5 74 57 C5 C5 FC 57 F2 C5 2C 55 15 ?? ?? ?? ?? C4 C3 7D 19 EC 01 C5 D1 FA EC C4 E3 7D 19 D3 01 C5 19 FA E4 C5 E9 FA D4 C5 E1 FA DC C4 C1 51 66 E7 C4 C1 51 76 EF C5 D9 EB E5 C4 C1 69 66 EF C4 C1 69 76 D7 C5 D1 EB D2 C4 C1 61 66 EF C5 D9 EB D2 C4 C1 19 66 E7 C4 41 19 76 E7 C4 C1 61 76 DF C4 C1 59 EB E4 C5 51 EB FB C4 C1 59 EB E7 C5 E9 6B D4 C5 E1 EF DB C4 C1 24 59 E3 C5 E9 63 EB C5 F9 D7 D5 C5 5C 59 FC C5 04 59 25 ?? ?? ?? ?? C5 84 59 15 ?? ?? ?? ?? C5 9C 58 1D ?? ?? ?? ?? C5 6C 58 25 ?? ?? ?? ?? C4 C1 64 59 EF C4 41 1C 59 E7 C5 D4 58 15 ?? ?? ?? ?? C5 9C 58 2D ?? ?? ?? ?? C4 C1 6C 59 DF C4 C1 54 59 EF C5 E4 58 15 ?? ?? ?? ?? C5 D4 58 1D ?? ?? ?? ?? C4 41 6C 59 FF C5 E4 59 E4 C5 84 58 15 ?? ?? ?? ?? C5 DC 58 DA C4 41 64 59 DB C4 41 24 58 D2 C4 41 2C 56 C0 C5 BC 58 D7 C5 EC 56 D6 84 D2 75 53 C5 FC 10 B4 24 90 01 00 00 C5 FC 10 BC 24 B0 01 00 00 C5 7C 10 84 24 F0 01 00 00 C5 7C 10 94 24 10 02 00 00 C5 7C 10 9C 24 D0 01 00 00 C5 7C 10 A4 24 30 02 00 00 C5 7C 10 BC 24 70 01 00 00 4C 8B AC 24 50 02 00 00 C5 FC 28 C2 48 81 C4 58 02 00 00 C3 C4 C1 7C 11 45 00 C4 C1 7C 11 4D 40 C4 C1 7C 11 95 80 00 00 00 85 D2 74 94 33 C0 C5 7C 11 4C 24 60 C5 7C 11 6C 24 40 C5 7C 11 74 24 20 48 89 9C 24 88 00 00 00 8B D8 48 89 B4 24 80 00 00 00 8B F2 0F A3 DE 72 37 FF C3 83 FB 20 7C F4 C5 7C 10 4C 24 60 C5 7C 10 6C 24 40 C5 7C 10 74 24 20 C4 C1 7C 10 95 80 00 00 00 48 8B 9C 24 88 00 00 00 48 8B B4 24 80 00 00 00 E9 30 FF FF FF C5 F8 77 49 8D 4C 9D 00 49 8D 54 9D 40 4D 8D 84 9D 80 00 00 00 E8 ?? ?? ?? ?? EB AD }
	condition:
		$1
}

rule file_180_0_0 {
	meta:
		name = "__sse2_log10f4"
		size = 704
		refs = "0012 flMantissaMask 001a s_dwPosInf 0022 s_dwSqrt2Addition 002d s_fOne 003d s_dwSqrt2Mask 0068 s_dwExpBias 0073 s_fInvLn10 00b0 s_fB2 00ca s_fB1 00d1 s_fB0 00db s_fLg2 0130 s_dwAbsMask 013c s_dwPosZero 0144 s_dwNegInf 0164 s_dwSpecial1 016c s_dwSpecial2 0196 s_fDenoAdd"
	strings:
		$1 = { 48 83 EC 78 0F 29 7C 24 50 0F 29 74 24 60 66 0F 6F 25 ?? ?? ?? ?? 66 0F 6F 1D ?? ?? ?? ?? 66 0F 6F 15 ?? ?? ?? ?? 66 0F DB E0 0F 28 2D ?? ?? ?? ?? 66 0F FE D4 66 0F 6F C8 66 0F DB 15 ?? ?? ?? ?? 66 0F EF EA 66 0F 72 E2 17 66 0F EB E5 66 0F 72 E0 17 0F 28 2D ?? ?? ?? ?? 0F 58 EC 0F 5C 25 ?? ?? ?? ?? 66 0F FA 05 ?? ?? ?? ?? 66 0F FE C2 0F 28 15 ?? ?? ?? ?? 0F 59 D4 0F 5E E5 C7 44 24 70 01 00 00 00 0F 29 4C 24 20 66 0F 66 D9 66 0F 66 0D ?? ?? ?? ?? 0F 5B C0 0F 28 EC 0F 59 E4 66 0F DB D9 0F 28 CC 0F 59 E4 66 0F D7 D3 0F 28 1D ?? ?? ?? ?? 81 FA FF FF 00 00 75 32 C7 44 24 70 00 00 00 00 0F 59 DC 0F 59 25 ?? ?? ?? ?? 0F 58 1D ?? ?? ?? ?? 0F 59 D9 0F 59 05 ?? ?? ?? ?? 0F 58 DC 0F 5C DA 0F 59 DD 0F 58 DA 0F 58 C3 83 7C 24 70 00 75 0F 0F 28 74 24 60 0F 28 7C 24 50 48 83 C4 78 C3 0F 28 54 24 20 0F 28 F2 66 0F EF FF 66 0F 6F C6 66 0F 76 05 ?? ?? ?? ?? 66 0F DB 05 ?? ?? ?? ?? 66 0F EB F8 66 0F 6F C6 66 0F DB 05 ?? ?? ?? ?? 66 0F 6F C8 66 0F 76 05 ?? ?? ?? ?? 66 0F DB 05 ?? ?? ?? ?? 66 0F EB F8 66 0F 66 0D ?? ?? ?? ?? 66 0F DB CE 66 0F EB F9 66 0F 6F C6 66 0F FE 05 ?? ?? ?? ?? 66 0F 66 05 ?? ?? ?? ?? 66 0F EB F8 66 0F 7F 7C 24 30 66 0F 6F C6 66 0F FE 05 ?? ?? ?? ?? 66 0F 66 05 ?? ?? ?? ?? 66 0F 6F C8 66 0F DB 0D ?? ?? ?? ?? 66 0F 7F 4C 24 40 66 0F 6F C8 66 0F 6F D6 66 0F EB 15 ?? ?? ?? ?? 0F 5C 15 ?? ?? ?? ?? 66 0F DB C2 66 0F 76 3D ?? ?? ?? ?? 66 0F DB F7 66 0F DF 3D ?? ?? ?? ?? 66 0F EB FE 66 0F DF CF 66 0F EB C1 66 0F 6F 25 ?? ?? ?? ?? 66 0F 6F 1D ?? ?? ?? ?? 66 0F 6F 15 ?? ?? ?? ?? 66 0F DB E0 0F 28 2D ?? ?? ?? ?? 66 0F FE D4 66 0F 6F C8 66 0F DB 15 ?? ?? ?? ?? 66 0F EF EA 66 0F 72 E2 17 66 0F EB E5 66 0F 72 E0 17 0F 28 3D ?? ?? ?? ?? 0F 58 FC 0F 5C 25 ?? ?? ?? ?? 66 0F FA 05 ?? ?? ?? ?? 0F 28 2D ?? ?? ?? ?? 0F 59 EC 0F 5E E7 66 0F FE C2 0F 28 D1 66 0F 66 D9 66 0F 66 0D ?? ?? ?? ?? 0F 5B C0 0F 28 FC 0F 59 E4 66 0F DB D9 0F 28 CC 0F 59 E4 66 0F D7 D3 0F 28 1D ?? ?? ?? ?? 0F 28 15 ?? ?? ?? ?? 0F 59 DC 0F 59 D4 0F 58 1D ?? ?? ?? ?? 0F 59 D9 0F 59 05 ?? ?? ?? ?? 0F 58 DA 0F 5C DD 0F 59 DF 0F 58 DD 0F 58 C3 66 0F EB 44 24 30 0F 58 44 24 40 0F 28 74 24 60 0F 28 7C 24 50 48 83 C4 78 C3 66 90 }
	condition:
		$1
}

rule file_181_0_0 {
	meta:
		name = "__common_dsin_cout_rare"
		size = 128
		refs = "0045 _vmldSinHATab"
	strings:
		$1 = { 48 83 EC 28 48 8B 01 48 89 44 24 20 48 C1 E8 38 44 0F B7 41 06 41 81 E0 F0 7F 00 00 83 E0 7F F2 0F 10 09 41 81 F8 F0 7F 00 00 75 3E 83 7C 24 20 00 75 28 88 44 24 27 81 7C 24 24 00 00 F0 7F 75 1A F2 0F 10 05 ?? ?? ?? ?? B8 01 00 00 00 F2 0F 59 C8 F2 0F 11 0A 48 83 C4 28 C3 F2 0F 59 C9 33 C0 F2 0F 11 0A 48 83 C4 28 C3 33 C0 48 83 C4 28 C3 66 66 66 66 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_374_0_0 {
	meta:
		name = "__common_dcos_cout_rare"
		size = 128
		refs = "0045 _vmldCosHATab"
	strings:
		$1 = { 48 83 EC 28 48 8B 01 48 89 44 24 20 48 C1 E8 38 44 0F B7 41 06 41 81 E0 F0 7F 00 00 83 E0 7F F2 0F 10 09 41 81 F8 F0 7F 00 00 75 3E 83 7C 24 20 00 75 28 88 44 24 27 81 7C 24 24 00 00 F0 7F 75 1A F2 0F 10 05 ?? ?? ?? ?? B8 01 00 00 00 F2 0F 59 C8 F2 0F 11 0A 48 83 C4 28 C3 F2 0F 59 C9 33 C0 F2 0F 11 0A 48 83 C4 28 C3 33 C0 48 83 C4 28 C3 66 66 66 66 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_182_2_0 {
	meta:
		name = "_RTC_GetErrDesc"
		size = 23
		refs = "000b ?_RTC_errlist@@3QBQEBDB"
	strings:
		$1 = { 83 F9 04 77 0F 48 63 C1 48 8D 0D ?? ?? ?? ?? 48 8B 04 C1 C3 33 C0 C3 }
	condition:
		$1
}

rule file_182_4_0 {
	meta:
		name = "_RTC_SetErrorFunc"
		size = 26
		refs = "0003 ?_RTC_ErrorReportFunc@@3P6AHHPEBDH00ZZEA 0011 ?_RTC_ErrorReportFuncW@@3P6AHHPEB_WH00ZZEA"
	strings:
		$1 = { 48 8B 05 ?? ?? ?? ?? 48 89 0D ?? ?? ?? ?? 48 C7 05 ?? ?? ?? ?? 00 00 00 00 C3 }
	condition:
		$1
}

rule file_182_5_0 {
	meta:
		name = "_RTC_SetErrorFuncW"
		size = 26
		refs = "0003 ?_RTC_ErrorReportFuncW@@3P6AHHPEB_WH00ZZEA 0011 ?_RTC_ErrorReportFunc@@3P6AHHPEBDH00ZZEA"
	strings:
		$1 = { 48 8B 05 ?? ?? ?? ?? 48 89 0D ?? ?? ?? ?? 48 C7 05 ?? ?? ?? ?? 00 00 00 00 C3 }
	condition:
		$1
}

rule file_182_6_0 {
	meta:
		name = "_RTC_SetErrorType"
		size = 30
		refs = "000b ?_RTC_ErrorLevels@@3PAHA"
	strings:
		$1 = { 83 F9 04 77 15 48 63 C1 4C 8D 05 ?? ?? ?? ?? 41 8B 0C 80 41 89 14 80 8B C1 C3 83 C8 FF C3 }
	condition:
		$1
}

rule file_184_0_0 {
	meta:
		name = "__sse4_floorf4"
		size = 16
	strings:
		$1 = { 66 0F 3A 08 C0 01 C3 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_185_0_0 {
	meta:
		name = "??_M@YAXPEAX_K1P6AX0@Z@Z"
		size = 183
		refs = "007c _guard_check_icall 00ae ?__ArrayUnwind@@YAXPEAX_K1P6AX0@Z@Z"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 C6 44 24 20 00 48 8B 44 24 58 48 0F AF 44 24 60 48 8B 4C 24 50 48 03 C8 48 8B C1 48 89 44 24 50 48 8B 44 24 60 48 89 44 24 30 48 8B 44 24 60 48 FF C8 48 89 44 24 60 48 83 7C 24 30 00 76 34 48 8B 44 24 58 48 8B 4C 24 50 48 2B C8 48 8B C1 48 89 44 24 50 48 8B 44 24 68 48 89 44 24 28 48 8B 4C 24 28 E8 ?? ?? ?? ?? 48 8B 4C 24 50 FF 54 24 28 EB AD C6 44 24 20 01 0F B6 44 24 20 85 C0 75 19 4C 8B 4C 24 68 4C 8B 44 24 60 48 8B 54 24 58 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_185_1_0 {
	meta:
		name = "?fin$0@?0???_M@YAXPEAX_K1P6AX0@Z@Z@4HA"
		size = 46
		refs = "0022 ?__ArrayUnwind@@YAXPEAX_K1P6AX0@Z@Z"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 0F B6 45 20 85 C0 75 16 4C 8B 4D 68 4C 8B 45 60 48 8B 55 58 48 8B 4D 50 E8 ?? ?? ?? ?? 90 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_185_2_0 {
	meta:
		name = "??_M@YAXPEAX_KHP6AX0@Z@Z"
		size = 57
		refs = "0030 ??_M@YAXPEAX_K1P6AX0@Z@Z"
	strings:
		$1 = { 4C 89 4C 24 20 44 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 63 44 24 40 4C 8B 4C 24 48 4C 8B C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_185_3_0 {
	meta:
		name = "?ArrayUnwindFilter@@YAHPEAU_EXCEPTION_POINTERS@@@Z"
		size = 57
		refs = "002e terminate"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 48 8B 00 48 89 44 24 28 48 8B 44 24 28 8B 00 89 44 24 20 81 7C 24 20 63 73 6D E0 74 02 EB 05 E8 ?? ?? ?? ?? 33 C0 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_185_4_0 {
	meta:
		name = "?__ArrayUnwind@@YAXPEAX_K1P6AX0@Z@Z"
		size = 119
		refs = "0061 _guard_check_icall"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 48 C7 44 24 20 00 00 00 00 EB 0D 48 8B 44 24 20 48 FF C0 48 89 44 24 20 48 8B 44 24 60 48 39 44 24 20 74 34 48 8B 44 24 58 48 8B 4C 24 50 48 2B C8 48 8B C1 48 89 44 24 50 48 8B 44 24 68 48 89 44 24 28 48 8B 4C 24 28 E8 ?? ?? ?? ?? 48 8B 4C 24 50 FF 54 24 28 EB B3 EB 00 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_185_5_0 {
	meta:
		name = "?filt$0@?0??__ArrayUnwind@@YAXPEAX_K1P6AX0@Z@Z@4HA"
		size = 33
		refs = "0015 ?ArrayUnwindFilter@@YAHPEAU_EXCEPTION_POINTERS@@@Z"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 89 4D 30 48 8B 45 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_192_0_0 {
	meta:
		name = "__avx_tanf8"
		size = 3696
		refs = "007d __common_stan_data 0234 __common_stan_cout_rare 02f3 __common_stan_reduction_data"
	strings:
		$1 = { 53 55 48 81 EC C8 02 00 00 33 DB C5 7C 11 BC 24 A0 02 00 00 C5 F1 EF C9 C5 7C 11 B4 24 80 02 00 00 C5 7C 11 AC 24 60 02 00 00 C5 7C 11 A4 24 40 02 00 00 C5 7C 11 9C 24 C0 01 00 00 C5 7C 11 94 24 80 01 00 00 C5 7C 11 8C 24 E0 01 00 00 C5 7C 11 84 24 00 02 00 00 C5 FC 11 BC 24 A0 01 00 00 C5 FC 11 B4 24 20 02 00 00 4C 89 AC 24 D8 00 00 00 4C 8D AC 24 1F 01 00 00 C5 FC 10 2D ?? ?? ?? ?? 49 83 E5 C0 C5 7C 54 C5 C5 BC C2 15 ?? ?? ?? ?? 1E C5 D4 55 E8 C4 E3 7D 19 D3 01 C5 E9 6B E3 C5 D9 63 D1 C5 F9 D7 C2 84 C0 0F 85 8A 01 00 00 C5 FC 10 3D ?? ?? ?? ?? C5 BC 59 35 ?? ?? ?? ?? C5 CC 58 E7 C5 5C 5C EF C5 14 59 0D ?? ?? ?? ?? C5 14 59 15 ?? ?? ?? ?? C5 14 59 25 ?? ?? ?? ?? C5 14 59 3D ?? ?? ?? ?? C4 41 3C 5C C1 C4 41 3C 5C DA C4 41 24 5C F4 C4 C1 0C 5C DF C5 E4 59 D3 C5 6C 59 15 ?? ?? ?? ?? C5 6C 59 0D ?? ?? ?? ?? C5 2C 58 25 ?? ?? ?? ?? C5 34 58 1D ?? ?? ?? ?? C5 9C 59 D2 C5 24 59 F3 C5 EC 58 15 ?? ?? ?? ?? C5 F1 72 F4 1F C4 C3 7D 19 E0 01 C4 C1 49 72 F0 1F C4 E3 75 18 FE 01 C5 C4 57 CD C5 D1 72 F4 1E C4 C1 59 72 F0 1E C5 C4 57 FF C4 E3 55 18 F4 01 C5 4C C2 FF 0C C4 C1 04 55 DE C5 04 54 EA C4 41 04 54 F6 C5 04 55 FA C4 C1 64 56 DD C4 C1 0C 56 E7 C5 E4 5E EC C5 D4 57 C9 84 DB 75 70 C5 FC 10 B4 24 20 02 00 00 C5 FC 10 BC 24 A0 01 00 00 C5 7C 10 84 24 00 02 00 00 C5 7C 10 8C 24 E0 01 00 00 C5 7C 10 94 24 80 01 00 00 C5 7C 10 9C 24 C0 01 00 00 C5 7C 10 A4 24 40 02 00 00 C5 7C 10 AC 24 60 02 00 00 C5 7C 10 B4 24 80 02 00 00 C5 7C 10 BC 24 A0 02 00 00 4C 8B AC 24 D8 00 00 00 C5 FC 28 C1 48 81 C4 C8 02 00 00 5D 5B C3 C4 C1 7C 11 45 00 C4 C1 7C 11 4D 40 85 DB 74 80 33 ED 0F A3 EB 72 12 FF C5 83 FD 20 7C F4 C4 C1 7C 10 4D 40 E9 67 FF FF FF C5 F8 77 49 8D 4C AD 00 49 8D 54 AD 40 E8 ?? ?? ?? ?? EB DA 41 BB 00 00 80 7F C4 C1 7C 11 45 00 C4 41 79 6E CB C4 41 79 70 D1 00 C4 43 2D 18 F2 01 C4 C1 7C 54 EE C4 41 54 C2 FE 00 C5 29 DB E0 C4 E3 7D 19 C6 01 C4 C1 11 72 D4 17 C5 A9 DB E6 C4 C1 21 72 F5 01 C5 89 72 D4 17 C4 41 21 FE CD C4 C1 51 72 F6 01 C4 C1 61 72 F1 02 C4 C1 79 7E DA C5 F8 11 44 24 20 C5 F8 11 74 24 30 C4 C3 79 16 D9 01 C4 C3 79 16 D8 02 C4 E3 79 16 DD 03 C4 43 7D 19 F8 01 C4 C1 01 6B D0 C4 41 51 FE FE C4 C1 11 72 F7 02 C5 E9 63 C9 C5 79 7E E9 C5 F9 D7 D9 C4 63 79 16 EA 01 C4 63 79 16 E8 02 C4 43 79 16 EB 03 89 9C 24 D0 00 00 00 48 8D 1D ?? ?? ?? ?? C4 41 79 6E 04 1A C4 C1 79 6E 3C 19 C4 C1 79 6E 14 18 C5 F9 6E 4C 1D 00 C5 79 6E 0C 19 C5 79 6E 14 1A C5 F9 6E 2C 18 C4 41 79 6E 34 1B C5 39 6C E7 C5 E9 6C E1 C4 41 31 6C FA C4 C1 51 6C DE C4 41 79 6E 74 1B 04 C4 41 79 6E 44 1A 04 C4 C1 79 6E 7C 19 04 C4 C1 79 6E 54 18 04 C5 F9 6E 4C 1D 04 C5 79 6E 4C 19 04 C5 79 6E 54 1A 04 C5 F9 6E 6C 18 04 C5 18 C6 DC 88 C5 00 C6 E3 88 C5 B9 6C E7 C5 69 6C E9 C4 41 31 6C FA C4 C1 51 6C DE C4 41 58 C6 ED 88 C5 80 C6 E3 88 C5 79 6E 7C 18 08 B8 FF FF 7F 00 C5 79 6E 74 1A 08 BA 00 00 80 00 C5 F9 6E 6C 19 08 B9 FF FF 00 00 C4 41 79 6E 44 1A 08 41 BA FF 00 00 00 C4 C1 79 6E 7C 19 08 41 B9 00 00 40 47 C4 C1 79 6E 54 18 08 41 B8 00 00 80 3F C5 F9 6E 4C 1D 08 BD 00 00 00 80 C5 39 6C CF C5 69 6C D1 C5 F9 6E D0 C4 C1 30 C6 CA 88 C5 79 6E CA C5 79 70 D2 00 C5 F9 6E D1 C4 41 51 6C C6 C5 A9 DB C0 C4 C1 79 6E 5C 1B 08 48 8D 1D ?? ?? ?? ?? C5 A9 DB F6 C4 C1 79 70 E9 00 BA FF FF 03 00 C5 81 6C FB C5 79 FE F5 C5 79 70 FA 00 C5 C9 FE F5 C5 B8 C6 DF 88 C4 C1 21 DB FF C5 E9 72 D1 10 C4 C1 29 72 D6 10 C4 41 09 DB CF C4 C1 11 DB EF C5 78 11 5C 24 40 C4 C1 21 72 D5 10 C5 FA 7F 7C 24 60 C5 91 72 D6 10 C4 41 49 DB F7 C5 B9 72 D4 10 C4 E2 31 40 F7 C4 C1 59 DB C7 C4 E2 29 40 FA C4 C1 71 DB CF C4 E2 31 40 D2 C5 D9 72 D3 10 C5 78 11 64 24 50 C4 41 19 DB E7 C5 FA 7F B4 24 B0 00 00 00 C5 E9 72 D2 10 C4 E2 31 40 F5 C5 C1 FE FA C5 7A 7F 64 24 70 C4 C1 61 DB DF C4 42 09 40 E4 B8 00 00 80 28 C5 7A 7F 84 24 90 00 00 00 B9 00 00 00 34 C5 FA 7F 84 24 A0 00 00 00 41 BB 00 F0 FF FF C5 7A 7F A4 24 C0 00 00 00 C4 42 09 40 E0 C4 62 09 40 C0 C4 E2 29 40 C1 C4 C1 49 DB CF C5 F9 72 D0 10 C5 F1 FE D7 C5 F9 FE FA C4 C1 39 DB C7 C4 E2 11 40 D3 C5 C9 72 D6 10 C4 E2 11 40 DC C5 E9 72 D2 10 C4 E2 09 40 E4 C4 C1 39 72 D0 10 C5 F1 72 D4 10 C5 E1 FE E1 C5 F1 72 D7 10 C5 7A 7F 9C 24 80 00 00 00 C5 F9 FE C4 C4 42 31 40 DB C5 E9 FE E0 C4 E2 29 40 ED C4 C1 21 DB D7 C5 D1 FE DE C4 C1 19 DB C7 C5 E9 FE D3 C4 C1 21 72 D3 10 C5 F1 FE F2 C5 E9 72 D4 10 C4 E2 11 40 8C 24 A0 00 00 00 C4 C1 19 72 D4 10 C4 C1 71 FE C8 C5 FA 6F 9C 24 B0 00 00 00 C5 F9 FE E9 C4 62 29 40 84 24 80 00 00 00 C5 E9 FE D5 C4 C1 61 DB EF C4 C1 39 FE CB C5 F9 72 D6 10 C5 51 FE D9 C4 C1 79 FE EB C5 B9 72 D2 10 C5 7A 6F 9C 24 C0 00 00 00 C5 E9 72 F2 10 C4 E2 11 40 84 24 90 00 00 00 C4 C1 21 DB CF C4 C1 79 FE C4 C5 99 72 D5 10 C5 F1 FE C8 C4 C1 51 DB EF C5 B9 FE C1 C5 C9 72 F6 10 C5 78 10 44 24 40 C4 C1 71 72 D0 10 C4 62 31 40 C9 C4 62 29 40 54 24 60 C4 C1 31 DB CF C5 B1 72 D3 10 C4 41 29 FE D1 C5 B1 72 D0 10 C4 C1 71 FE CA C4 C1 79 DB C7 C5 78 10 44 24 50 C5 19 FE E1 C4 C1 61 72 F4 10 C4 C1 19 72 D0 10 C4 62 11 40 6C 24 70 C5 E1 FE CD C4 42 09 40 F4 C4 C1 19 72 D3 10 C4 41 09 DB D7 C4 41 11 FE DC C4 41 41 DB F7 C4 41 59 DB FF C4 41 29 FE EB C4 41 69 FE D7 C5 F9 6E D5 C4 41 31 FE CD C4 C1 49 FE FE C4 C1 79 6E E0 C5 F9 70 F2 00 C4 C1 51 72 F1 10 C5 49 DB 64 24 20 C5 D1 FE C0 C5 F9 70 D4 00 C5 E1 72 D1 09 C5 49 DB 7C 24 30 C5 19 EF C2 C4 41 79 6E C9 C5 D9 72 D0 09 C5 01 EF DA C4 C1 61 EB F0 C4 C1 79 70 E9 00 C4 41 59 EB EB BD FF 01 00 00 41 B8 DB 0F C9 40 C4 C1 79 6E E2 41 B9 00 10 C9 40 41 BA 7A 77 95 B7 C5 F9 70 E4 00 C4 C3 4D 18 DD 01 C5 79 6E E8 C4 63 55 18 F5 01 B8 FF FF FF 7F C5 0C 58 DB C4 C1 79 70 ED 00 C4 41 24 5C C6 C5 79 6E F2 C4 41 79 70 F6 00 C5 09 DB EF C5 C1 72 D7 12 C4 41 64 5C C8 C5 19 EF C5 C5 81 EF DD C4 C1 09 DB EA C4 C1 11 72 F5 05 C5 89 72 F5 05 C4 41 11 EB E8 C5 89 EB EB C4 C1 29 72 D2 12 BA 00 00 80 35 C4 63 15 18 ED 01 C5 F9 6E E9 C5 79 70 F5 00 B9 7F 00 00 00 C4 C1 19 EF EE C4 41 01 EF E6 C5 79 6E FD C4 E3 3D 18 DB 01 C4 41 79 70 C7 00 C5 B9 DB C9 C5 B9 DB C0 C5 F1 72 F1 0E C5 F9 72 F0 0E C5 F1 EB CF C4 C1 79 EB C2 C5 F1 EB CD C4 41 79 EB D4 C5 14 5C EB C4 C1 79 6E FA C5 79 70 C7 00 C4 C3 75 18 CA 01 C4 41 79 6E D1 C4 43 55 18 E4 01 C4 C1 74 5C CC C4 41 79 70 FA 00 C5 B4 58 D9 C5 B4 5C C3 C5 74 58 E0 C4 C1 79 6E CB C5 F9 70 C1 00 C4 C1 1C 58 ED C4 41 79 6E E8 C4 41 79 70 CD 00 C4 E3 7D 18 C8 01 C5 64 54 E1 C4 C1 64 5C DC C4 43 35 18 F1 01 C4 43 05 18 FF 01 C4 43 3D 18 D0 01 C5 79 6E C2 C4 41 04 59 CC C5 84 59 C3 C4 41 2C 59 E4 C5 8C 59 ED C5 2C 59 F3 C4 41 79 70 D0 00 C4 C1 7C 58 C4 C4 41 54 58 E6 C5 F9 6E E8 C5 F9 70 FD 00 C4 C1 7C 58 DC C4 C1 7C 10 45 00 C5 34 58 EB C4 41 34 5C CD C5 34 58 E3 C4 63 45 18 F7 01 C4 41 7C 54 FE C4 C3 2D 18 DA 01 C5 84 C2 FB 1E C5 04 C2 FB 12 C4 41 44 54 C4 C5 79 6E E1 C4 C1 79 70 DC 00 C5 84 54 E8 C4 41 44 54 ED C4 C1 54 56 ED C4 41 54 58 E0 C4 63 7D 19 DE 01 C5 21 DB DC C5 A1 DB FB C5 C9 DB E4 C5 D9 DB DB C5 C9 72 F7 02 C5 C9 FE EF C5 C9 72 F3 02 C5 C9 FE E3 C5 B9 72 F5 03 C5 E1 72 F4 03 C5 79 7E C0 C4 C1 79 7E D8 C4 63 79 16 C2 01 C4 63 79 16 C1 02 C4 63 79 16 C5 03 C4 C3 79 16 D9 01 C4 C3 79 16 DA 02 C4 C3 79 16 DB 03 C5 79 6E 8C 18 40 04 00 00 C5 79 6E 94 1A 40 04 00 00 C5 79 6E 9C 19 40 04 00 00 C5 79 6E AC 1D 40 04 00 00 C4 C1 79 6E A4 18 40 04 00 00 C4 C1 79 6E AC 19 40 04 00 00 C4 C1 79 6E B4 1A 40 04 00 00 C4 C1 79 6E BC 1B 40 04 00 00 C4 41 31 6C F2 C4 41 21 6C FD C5 59 6C CD C5 49 6C D7 C4 41 08 C6 C7 88 C4 41 30 C6 DA 88 C5 F9 6E A4 18 44 04 00 00 C5 F9 6E AC 1A 44 04 00 00 8B 9C 24 D0 00 00 00 C4 C3 3D 18 DB 01 89 9C 24 D0 00 00 00 48 8D 1D ?? ?? ?? ?? C5 D9 6C FD C4 C1 7C 11 45 00 C5 79 6E AC 19 44 04 00 00 C5 F9 6E B4 1D 44 04 00 00 C5 91 6C EE C4 41 79 6E AC 18 44 04 00 00 C4 41 79 6E 8C 19 44 04 00 00 C4 41 79 6E 94 1A 44 04 00 00 C4 41 79 6E 84 1B 44 04 00 00 C4 41 11 6C D9 C4 C1 29 6C F0 C5 C0 C6 C5 88 C5 A0 C6 FE 88 C5 F9 6E AC 18 48 04 00 00 C5 79 6E B4 1A 48 04 00 00 C5 79 6E BC 19 48 04 00 00 C5 F9 6E A4 1D 48 04 00 00 C4 41 79 6E 84 18 48 04 00 00 C4 41 79 6E 9C 19 48 04 00 00 C4 C1 79 6E B4 1A 48 04 00 00 C4 41 51 6C EE C5 01 6C CC C4 C1 39 6C EB C4 41 10 C6 D1 88 C5 F9 6E A4 18 4C 04 00 00 C5 79 6E AC 1A 4C 04 00 00 C5 79 6E 8C 19 4C 04 00 00 C4 41 59 6C C5 C4 C1 79 6E A4 1B 4C 04 00 00 C4 E3 7D 18 C7 01 C4 C1 79 6E BC 1B 48 04 00 00 C5 49 6C F7 C4 41 50 C6 FE 88 C4 C1 79 6E BC 18 4C 04 00 00 C4 41 79 6E B4 19 4C 04 00 00 C4 41 41 6C EE C5 F9 6E BC 19 50 04 00 00 C5 79 6E B4 1D 50 04 00 00 C4 C3 2D 18 EF 01 C5 79 6E 94 1D 4C 04 00 00 C4 41 79 6E BC 1A 4C 04 00 00 C4 41 31 6C DA C5 01 6C CC C4 C1 38 C6 F3 88 C4 41 10 C6 D1 88 C5 79 6E 84 18 50 04 00 00 C5 79 6E 9C 1A 50 04 00 00 C4 41 39 6C FB C4 41 79 6E 8C 18 50 04 00 00 C4 41 79 6E 84 1A 50 04 00 00 C4 41 79 6E 9C 1B 50 04 00 00 C4 C1 41 6C E6 C4 41 39 6C F3 C5 00 C6 EC 88 C5 F9 6E A4 18 54 04 00 00 C5 79 6E 84 1D 54 04 00 00 C4 C3 4D 18 F2 01 C4 41 79 6E 94 19 50 04 00 00 C4 C1 31 6C FA C4 41 40 C6 FE 88 C5 79 6E 8C 1A 54 04 00 00 C5 79 6E 94 19 54 04 00 00 C4 41 59 6C D9 C4 C1 29 6C F8 C4 C1 79 6E A4 19 54 04 00 00 C4 41 79 6E 8C 1A 54 04 00 00 C4 41 79 6E 94 1B 54 04 00 00 C5 20 C6 F7 88 C4 41 31 6C DA C5 79 6E 8C 19 58 04 00 00 C5 79 6E 94 1D 58 04 00 00 C4 43 15 18 EF 01 C4 41 79 6E BC 18 54 04 00 00 C5 01 6C C4 C4 C1 38 C6 FB 88 C5 79 6E BC 18 58 04 00 00 C5 F9 6E A4 1A 58 04 00 00 C5 01 6C C4 C4 41 31 6C DA C4 41 79 6E BC 19 58 04 00 00 C4 C1 79 6E A4 1A 58 04 00 00 C4 41 79 6E 8C 1B 58 04 00 00 C4 41 38 C6 C3 88 C4 41 59 6C D9 C5 F9 6E A4 1A 5C 04 00 00 C5 79 6E 8C 19 5C 04 00 00 C4 E3 0D 18 FF 01 C4 41 79 6E B4 18 58 04 00 00 C4 41 09 6C D7 C4 41 28 C6 F3 88 C5 79 6E BC 18 5C 04 00 00 C5 79 6E 94 1D 5C 04 00 00 C5 01 6C DC C4 41 79 6E BC 18 5C 04 00 00 C4 C1 79 6E A4 19 5C 04 00 00 C4 C1 44 59 FC C4 43 3D 18 C6 01 C4 41 31 6C F2 C4 41 79 6E 8C 1A 5C 04 00 00 C4 41 79 6E 94 1B 5C 04 00 00 C4 41 20 C6 DE 88 C5 01 6C F4 C4 41 31 6C FA C4 C1 08 C6 E7 88 C5 79 6E 8C 18 60 04 00 00 C5 79 6E 94 1A 60 04 00 00 C5 79 6E B4 19 60 04 00 00 C5 79 6E BC 1D 60 04 00 00 C4 63 25 18 DC 01 C4 C1 31 6C E2 C4 41 09 6C CF C4 41 58 C6 C9 88 C4 41 79 6E 94 18 60 04 00 00 C4 41 79 6E B4 19 60 04 00 00 C4 41 79 6E BC 1A 60 04 00 00 C4 C1 79 6E A4 1B 60 04 00 00 C4 41 29 6C D6 C5 01 6C F4 C4 41 28 C6 FE 88 C5 F9 6E A4 18 64 04 00 00 C5 79 6E 94 1A 64 04 00 00 C5 79 6E B4 19 64 04 00 00 C4 C1 59 6C E2 C4 41 24 59 DC C4 41 24 58 D8 C4 43 35 18 CF 01 C5 79 6E BC 1D 64 04 00 00 C4 41 09 6C D7 C4 41 79 6E B4 18 64 04 00 00 C4 41 79 6E BC 19 64 04 00 00 C4 C1 58 C6 E2 88 C4 41 09 6C D7 C4 41 79 6E B4 1A 64 04 00 00 C4 41 79 6E BC 1B 64 04 00 00 C4 41 09 6C F7 C4 41 64 5C FC C4 41 28 C6 D6 88 C4 C1 64 5C DF C4 41 64 5C F4 8B 9C 24 D0 00 00 00 C4 43 5D 18 D2 01 C5 84 54 E1 C5 04 5C FC C4 41 2C 59 D4 C5 84 58 D8 C5 FC 53 C4 C5 8C 58 DB C4 41 2C 58 C1 C4 41 1C 59 CC C5 FC 54 C9 C5 5C 59 F1 C4 41 34 59 C0 C4 E3 6D 18 D2 01 C4 41 6C 5C FE C4 C1 74 59 C7 C4 C1 04 59 E7 C5 7C 58 F1 C5 DC 58 D2 C5 F4 59 CD C5 0C 59 F2 C4 C1 64 59 C6 C5 FC 59 D8 C4 C1 7C 5C E7 C5 64 5C FC C5 CC 58 DF C4 C1 04 59 D6 C5 CC 5C F3 C5 EC 59 C5 C5 E4 58 D1 C5 CC 58 EF C5 F4 5C CA C5 D4 58 C0 C5 F4 58 CB C5 FC 58 E1 C4 C1 3C 58 C3 C5 14 58 EC C4 41 7C 59 E4 C4 C1 1C 58 C5 C5 EC 58 C8 C4 C1 7C 10 45 00 E9 1C F3 FF FF 0F 1F 00 }
	condition:
		$1
}

rule file_193_0_0 {
	meta:
		name = "??__C@YAXPEAX0_K1P6AX00@ZP6AX0@Z@Z"
		size = 187
		refs = "0051 _guard_check_icall 00b2 ?__ArrayUnwind@@YAXPEAX_K1P6AX0@Z@Z"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 48 C7 44 24 28 00 00 00 00 C6 44 24 20 00 EB 0D 48 8B 44 24 28 48 FF C0 48 89 44 24 28 48 8B 44 24 68 48 39 44 24 28 74 4E 48 8B 44 24 70 48 89 44 24 30 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 54 24 58 48 8B 4C 24 50 FF 54 24 30 48 8B 44 24 60 48 8B 4C 24 50 48 03 C8 48 8B C1 48 89 44 24 50 48 8B 44 24 60 48 8B 4C 24 58 48 03 C8 48 8B C1 48 89 44 24 58 EB 99 C6 44 24 20 01 0F B6 44 24 20 85 C0 75 19 4C 8B 4C 24 78 4C 8B 44 24 28 48 8B 54 24 60 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_195_0_0 {
	meta:
		name = "?__scrt_initialize_thread_safe_statics@@YAHXZ"
		size = 296
		refs = "000f ?_Tss_mutex@@3U_RTL_CRITICAL_SECTION@@A 0014 __vcrt_InitializeCriticalSectionEx 001b ??_C@_1BK@MGMFAEKH@?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA3?$AA2?$AA?4?$AAd?$AAl?$AAl?$AA?$AA@ 0021 __imp_GetModuleHandleW 0038 __scrt_fastfail 003f ??_C@_0BM@HLJJNPAH@InitializeConditionVariable?$AA@ 004a __imp_GetProcAddress 0056 ??_C@_0BJ@JEBJOJFJ@SleepConditionVariableCS?$AA@ 006d ??_C@_0BJ@PGPPEPCC@WakeAllConditionVariable?$AA@ 009c ?_Tss_event@@3PEAXEA 00b4 _guard_check_icall 00bb ?_Tss_cv@@3U_RTL_CONDITION_VARIABLE@@A 00c9 ??$__crt_fast_encode_pointer@P6AHPEAU_RTL_CONDITION_VARIABLE@@PEAU_RTL_CRITICAL_SECTION@@K@Z@@YAP6AHPEAU_RTL_CONDITION_VARIABLE@@PEAU_RTL_CRITICAL_SECTION@@K@ZQ6AH01K@Z@Z 00d0 ?encoded_sleep_condition_variable_cs@@3P6AHPEAU_RTL_CONDITION_VARIABLE@@PEAU_RTL_CRITICAL_SECTION@@K@ZEA 00da ??$__crt_fast_encode_pointer@P6AXPEAU_RTL_CONDITION_VARIABLE@@@Z@@YAP6AXPEAU_RTL_CONDITION_VARIABLE@@@ZQ6AX0@Z@Z 00e1 ?encoded_wake_all_condition_variable@@3P6AXPEAU_RTL_CONDITION_VARIABLE@@@ZEA 00f6 __imp_CreateEventW 0118 ?__scrt_uninitialize_thread_safe_statics@@YAXXZ 011d atexit"
	strings:
		$1 = { 48 83 EC 58 45 33 C0 BA A0 0F 00 00 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 89 44 24 20 48 83 7C 24 20 00 75 0A B9 07 00 00 00 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B 4C 24 20 FF 15 ?? ?? ?? ?? 48 89 44 24 28 48 8D 15 ?? ?? ?? ?? 48 8B 4C 24 20 FF 15 ?? ?? ?? ?? 48 89 44 24 38 48 8D 15 ?? ?? ?? ?? 48 8B 4C 24 20 FF 15 ?? ?? ?? ?? 48 89 44 24 40 48 83 7C 24 28 00 74 5E 48 83 7C 24 38 00 74 56 48 83 7C 24 40 00 74 4E 48 C7 05 ?? ?? ?? ?? 00 00 00 00 48 8B 44 24 28 48 89 44 24 30 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? FF 54 24 30 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? EB 2E 45 33 C9 45 33 C0 BA 01 00 00 00 33 C9 FF 15 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 83 3D ?? ?? ?? ?? 00 75 0A B9 07 00 00 00 E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_195_6_0 {
	meta:
		name = "?__scrt_uninitialize_thread_safe_statics@@YAXXZ"
		size = 45
		refs = "0007 ?_Tss_mutex@@3U_RTL_CRITICAL_SECTION@@A 000d __imp_DeleteCriticalSection 0014 ?_Tss_event@@3PEAXEA 0024 __imp_CloseHandle"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 83 3D ?? ?? ?? ?? 00 74 0D 48 8B 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_195_7_0 {
	meta:
		name = "_Init_thread_abort"
		size = 40
		refs = "000a _Init_thread_lock 001a _Init_thread_unlock 001f _Init_thread_notify"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 E8 ?? ?? ?? ?? 48 8B 44 24 30 C7 00 00 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_195_8_0 {
	meta:
		name = "_Init_thread_footer"
		size = 91
		refs = "000a _Init_thread_lock 0010 _Init_global_epoch 002a _Init_thread_epoch 0032 _tls_index 004d _Init_thread_unlock 0052 _Init_thread_notify"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 E8 ?? ?? ?? ?? 8B 05 ?? ?? ?? ?? FF C0 89 05 ?? ?? ?? ?? 48 8B 44 24 30 8B 0D ?? ?? ?? ?? 89 08 B8 ?? ?? ?? ?? 8B C0 8B 0D ?? ?? ?? ?? 65 48 8B 14 25 58 00 00 00 48 8B 0C CA 8B 15 ?? ?? ?? ?? 89 14 08 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_195_9_0 {
	meta:
		name = "_Init_thread_header"
		size = 132
		refs = "000a _Init_thread_lock 0035 _Init_thread_wait 004f _Init_thread_unlock 0058 _Init_thread_epoch 0060 _tls_index 0073 _Init_global_epoch"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 E8 ?? ?? ?? ?? 48 8B 44 24 30 83 38 00 75 0D 48 8B 44 24 30 C7 00 FF FF FF FF EB 55 48 8B 44 24 30 83 38 FF 75 28 B9 64 00 00 00 E8 ?? ?? ?? ?? 48 8B 44 24 30 83 38 00 75 12 48 8B 44 24 30 C7 00 FF FF FF FF E8 ?? ?? ?? ?? EB 2A EB CE B8 ?? ?? ?? ?? 8B C0 8B 0D ?? ?? ?? ?? 65 48 8B 14 25 58 00 00 00 48 8B 0C CA 8B 15 ?? ?? ?? ?? 89 14 08 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_195_10_0 {
	meta:
		name = "_Init_thread_lock"
		size = 22
		refs = "0007 ?_Tss_mutex@@3U_RTL_CRITICAL_SECTION@@A 000d __imp_EnterCriticalSection"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_277_0_0 {
	meta:
		name = "?__scrt_initialize_type_info@@YAXXZ"
		size = 22
		refs = "0007 ?__type_info_root_node@@3U__type_info_node@@A 000d __imp_InitializeSListHead"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_195_12_0 {
	meta:
		name = "_Init_thread_unlock"
		size = 22
		refs = "0007 ?_Tss_mutex@@3U_RTL_CRITICAL_SECTION@@A 000d __imp_LeaveCriticalSection"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_368_5_0 {
	meta:
		name = "__scrt_set_unhandled_exception_filter"
		size = 22
		refs = "0007 __scrt_unhandled_exception_filter 000d __imp_SetUnhandledExceptionFilter"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_195_11_0 {
	meta:
		name = "_Init_thread_notify"
		size = 85
		refs = "0007 ?_Tss_event@@3PEAXEA 0011 ?encoded_wake_all_condition_variable@@3P6AXPEAU_RTL_CONDITION_VARIABLE@@@ZEA 0016 ??$__crt_fast_decode_pointer@P6AXPEAU_RTL_CONDITION_VARIABLE@@@Z@@YAP6AXPEAU_RTL_CONDITION_VARIABLE@@@ZQ6AX0@Z@Z 0025 _guard_check_icall 002c ?_Tss_cv@@3U_RTL_CONDITION_VARIABLE@@A 003f __imp_SetEvent 004c __imp_ResetEvent"
	strings:
		$1 = { 48 83 EC 38 48 83 3D ?? ?? ?? ?? 00 75 28 48 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 44 24 20 48 8B 4C 24 20 E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? FF 54 24 20 EB 1A 48 8B 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8B 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_195_13_0 {
	meta:
		name = "_Init_thread_wait"
		size = 233
		refs = "000b ?_Tss_event@@3PEAXEA 0015 ?encoded_sleep_condition_variable_cs@@3P6AHPEAU_RTL_CONDITION_VARIABLE@@PEAU_RTL_CRITICAL_SECTION@@K@ZEA 001a ??$__crt_fast_decode_pointer@P6AHPEAU_RTL_CONDITION_VARIABLE@@PEAU_RTL_CRITICAL_SECTION@@K@Z@@YAP6AHPEAU_RTL_CONDITION_VARIABLE@@PEAU_RTL_CRITICAL_SECTION@@K@ZQ6AH01K@Z@Z 0029 _guard_check_icall 0035 ?_Tss_mutex@@3U_RTL_CRITICAL_SECTION@@A 003c ?_Tss_cv@@3U_RTL_CONDITION_VARIABLE@@A 0079 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 008e ??_C@_1HK@LKKBAJNK@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAv?$AAc?$AAs?$AAt?$AAa?$AAr?$AAt?$AAu?$AAp?$AA?2?$AAs?$AAr?$AAc?$AA?2@ 0098 _CrtDbgReportW 00a5 _Init_thread_unlock 00b9 __imp_WaitForSingleObjectEx 00c2 _Init_thread_lock"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 58 48 83 3D ?? ?? ?? ?? 00 75 54 48 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 44 24 40 48 8B 4C 24 40 E8 ?? ?? ?? ?? 44 8B 44 24 60 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? FF 54 24 40 85 C0 74 0A C7 44 24 30 01 00 00 00 EB 08 C7 44 24 30 00 00 00 00 0F B6 44 24 30 E9 80 00 00 00 EB 7E 83 7C 24 60 FF 75 37 48 C7 44 24 28 00 00 00 00 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 8F 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 E8 ?? ?? ?? ?? 45 33 C0 8B 54 24 60 48 8B 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 89 44 24 38 E8 ?? ?? ?? ?? 83 7C 24 38 00 75 0A C7 44 24 34 01 00 00 00 EB 08 C7 44 24 34 00 00 00 00 0F B6 44 24 34 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_196_0_0 {
	meta:
		name = "__guard_check_icall_thunk"
		size = 33
		refs = "0011 __guard_check_icall_fptr"
	strings:
		$1 = { 48 50 51 52 41 50 41 51 48 83 EC 20 48 8B C8 FF 15 ?? ?? ?? ?? 48 83 C4 20 41 59 41 58 5A 59 58 C3 }
	condition:
		$1
}

rule file_201_0_0 {
	meta:
		name = "??2@YAPEAX_KHPEBDH@Z"
		size = 108
		refs = "002b _malloc_dbg 0049 _callnewh 005a ?__scrt_throw_std_bad_array_new_length@@YAXXZ 0061 ?__scrt_throw_std_bad_alloc@@YAXXZ"
	strings:
		$1 = { 44 89 4C 24 20 4C 89 44 24 18 89 54 24 10 48 89 4C 24 08 48 83 EC 38 44 8B 4C 24 58 4C 8B 44 24 50 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 89 44 24 20 48 83 7C 24 20 00 74 07 48 8B 44 24 20 EB 24 48 8B 4C 24 40 E8 ?? ?? ?? ?? 85 C0 75 14 48 83 7C 24 40 FF 75 07 E8 ?? ?? ?? ?? EB 05 E8 ?? ?? ?? ?? EB B0 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_201_1_0 {
	meta:
		name = "??_U@YAPEAX_KHPEBDH@Z"
		size = 52
		refs = "002b ??2@YAPEAX_KHPEBDH@Z"
	strings:
		$1 = { 44 89 4C 24 20 4C 89 44 24 18 89 54 24 10 48 89 4C 24 08 48 83 EC 28 44 8B 4C 24 48 4C 8B 44 24 40 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_291_1_0 {
	meta:
		name = "??_V@YAXPEAXHPEBDH@Z"
		size = 52
		refs = "002b ??3@YAXPEAXHPEBDH@Z"
	strings:
		$1 = { 44 89 4C 24 20 4C 89 44 24 18 89 54 24 10 48 89 4C 24 08 48 83 EC 28 44 8B 4C 24 48 4C 8B 44 24 40 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_202_0_0 {
	meta:
		name = "__common_stanh_cout_rare"
		size = 80
		refs = "0003 _imlsTanhHATab"
	strings:
		$1 = { 4C 8D 05 ?? ?? ?? ?? 8A 41 03 24 80 C0 E8 07 44 0F B6 C8 44 0F B7 51 02 41 81 E2 80 7F 00 00 41 81 FA 80 7F 00 00 43 8B 04 88 74 05 89 02 33 C0 C3 F7 01 FF FF 7F 00 74 F3 F3 0F 10 01 F3 0F 58 C0 F3 0F 11 02 EB E7 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_209_0_0 {
	meta:
		name = "__avx_expf8"
		size = 528
		refs = "002d __common_sexp_data 0200 __common_sexp_cout_rare"
	strings:
		$1 = { 48 81 EC 18 02 00 00 C5 7C 11 84 24 D0 01 00 00 C5 FC 11 B4 24 F0 01 00 00 4C 89 AC 24 10 02 00 00 4C 8D AC 24 6F 01 00 00 C5 FC 10 25 ?? ?? ?? ?? 49 83 E5 C0 C5 FC 59 0D ?? ?? ?? ?? C5 F8 10 15 ?? ?? ?? ?? C5 F8 10 35 ?? ?? ?? ?? C5 F8 10 1D ?? ?? ?? ?? C5 74 58 C4 C5 BC 5C CC C5 F8 54 E2 C4 E3 7D 19 C5 01 C5 D9 66 E6 C5 D0 54 EA C5 D1 66 D6 C5 D9 6B E2 C5 D1 EF ED C5 D9 63 F5 C5 F4 59 2D ?? ?? ?? ?? C5 F4 59 0D ?? ?? ?? ?? C5 F9 D7 D6 C5 FC 5C F5 C5 B9 FE D3 C4 63 7D 19 C4 01 C5 B9 72 F2 17 C5 CC 5C D1 C5 D9 FE DB C5 E1 72 F3 17 C5 EC 59 0D ?? ?? ?? ?? C5 F4 58 25 ?? ?? ?? ?? C5 DC 59 EA C5 D4 58 35 ?? ?? ?? ?? C4 E3 3D 18 DB 01 C5 4C 59 C2 C5 BC 58 0D ?? ?? ?? ?? C5 F4 59 E2 C5 DC 58 2D ?? ?? ?? ?? C5 D4 59 D2 C5 EC 58 0D ?? ?? ?? ?? C5 E4 59 C9 84 D2 75 26 C5 FC 10 B4 24 F0 01 00 00 C5 7C 10 84 24 D0 01 00 00 4C 8B AC 24 10 02 00 00 C5 FC 28 C1 48 81 C4 18 02 00 00 C3 C4 C1 7C 11 45 00 C4 C1 7C 11 4D 40 85 D2 74 CA 33 C0 C5 FC 11 BC 24 00 01 00 00 C5 7C 11 8C 24 E0 00 00 00 C5 7C 11 94 24 C0 00 00 00 C5 7C 11 9C 24 A0 00 00 00 C5 7C 11 A4 24 80 00 00 00 C5 7C 11 6C 24 60 C5 7C 11 74 24 40 C5 7C 11 7C 24 20 48 89 9C 24 28 01 00 00 8B D8 48 89 B4 24 20 01 00 00 8B F2 0F A3 DE 72 61 FF C3 83 FB 20 7C F4 C5 FC 10 BC 24 00 01 00 00 C5 7C 10 8C 24 E0 00 00 00 C5 7C 10 94 24 C0 00 00 00 C5 7C 10 9C 24 A0 00 00 00 C5 7C 10 A4 24 80 00 00 00 C5 7C 10 6C 24 60 C5 7C 10 74 24 40 C5 7C 10 7C 24 20 C4 C1 7C 10 4D 40 48 8B 9C 24 28 01 00 00 48 8B B4 24 20 01 00 00 E9 0F FF FF FF C5 F8 77 49 8D 4C 9D 00 49 8D 54 9D 40 E8 ?? ?? ?? ?? EB 8B 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_213_0_0 {
	meta:
		name = "__sse2_atan2f4"
		size = 1328
		refs = "0014 s_dwAbsMask 003d s_dwMaxNormal 0045 s_dwMinBound 0053 s_dwSignMask 0062 s_fOne 00ae s_fPi2 00be s_fPi 00d1 s_fA8 00db s_fA7 00e5 s_fA6 00ec s_fA5 00f9 s_fA4 0100 s_fA3 010d s_fA2 0114 s_fA1 0121 s_fA0 0155 INFP 015f INFN 016a NEGZERO 02b1 _2il0floatpacket_16 02db pi_or_zero 02f2 _2il0floatpacket_11 02fe _2il0floatpacket_10 0307 _2il0floatpacket_14 0317 _2il0floatpacket_9 032b _2il0floatpacket_8 033e _2il0floatpacket_7 034a _2il0floatpacket_15 035c _2il0floatpacket_13 0371 _2il0floatpacket_12 03f5 _2il0floatpacket_17 0400 _2il0floatpacket_18 041f _2il0floatpacket_20 0427 _2il0floatpacket_19 043b _2il0floatpacket_21 0449 _2il0floatpacket_22 047e _2il0floatpacket_23 048c _2il0floatpacket_24"
	strings:
		$1 = { 48 81 EC C8 00 00 00 0F 29 7C 24 60 0F 29 74 24 70 0F 28 15 ?? ?? ?? ?? 0F 28 EA 0F 11 84 24 80 00 00 00 66 0F DB E9 66 0F DB D0 0F 11 8C 24 90 00 00 00 0F 28 FD 0F 28 F2 66 0F 66 35 ?? ?? ?? ?? 66 0F 66 3D ?? ?? ?? ?? 66 0F DF F7 0F 50 C6 0F 28 35 ?? ?? ?? ?? 66 0F DB C6 0F 28 FE 66 0F EB 05 ?? ?? ?? ?? 0F 28 DD 66 0F DB F9 0F 11 44 24 50 66 0F EB 3D ?? ?? ?? ?? 0F C2 DA 01 0F 28 E3 66 0F DB E5 0F 28 C3 66 0F DF C2 66 0F EB E0 66 0F DB D3 0F 28 C3 66 0F DF C5 66 0F EB D0 0F 5E E2 66 0F DB F3 66 0F EF ED 66 0F DB 1D ?? ?? ?? ?? 0F C2 CD 01 66 0F EB E6 66 0F DB 0D ?? ?? ?? ?? 0F 28 C4 0F 59 C4 0F 28 D0 0F 59 D0 0F 28 35 ?? ?? ?? ?? 0F 59 F2 0F 28 2D ?? ?? ?? ?? 0F 59 EA 0F 58 35 ?? ?? ?? ?? 0F 58 2D ?? ?? ?? ?? 0F 59 F2 0F 59 EA 0F 58 35 ?? ?? ?? ?? 0F 58 2D ?? ?? ?? ?? 0F 59 F2 0F 59 EA 0F 58 35 ?? ?? ?? ?? 0F 58 2D ?? ?? ?? ?? 0F 59 F2 0F 59 C5 0F 58 35 ?? ?? ?? ?? 0F 58 C6 0F 59 C4 0F 28 6C 24 50 0F 58 C3 0F 59 C7 89 84 24 B0 00 00 00 0F 58 C1 0F 59 C5 83 BC 24 B0 00 00 00 0F 0F 84 8D 02 00 00 F3 0F 10 1D ?? ?? ?? ?? 33 C9 F3 0F 10 15 ?? ?? ?? ?? 0F 57 C0 F3 0F 10 0D ?? ?? ?? ?? 33 D2 44 0F 29 44 24 40 B8 00 00 80 3F 44 0F 29 4C 24 30 44 0F 29 54 24 20 44 8B 8C 8C 90 00 00 00 45 8B C1 44 8B 94 8C 80 00 00 00 45 8B DA 41 81 E3 00 00 00 80 44 89 8C 24 C4 00 00 00 41 81 E1 FF FF FF 7F 41 81 E0 00 00 00 80 F3 44 0F 10 8C 8C 80 00 00 00 41 81 F9 00 00 80 7F F3 0F 10 A4 8C 90 00 00 00 89 94 24 B4 00 00 00 89 94 24 B8 00 00 00 89 84 24 BC 00 00 00 44 89 94 24 C0 00 00 00 7F 10 41 81 E2 FF FF FF 7F 41 81 FA 00 00 80 7F 7E 0A F3 44 0F 58 CC E9 A0 01 00 00 44 0F 2E C8 7A 06 0F 84 A0 02 00 00 0F 2E E0 7A 06 0F 84 71 02 00 00 0F 2E E3 7A 06 0F 84 23 02 00 00 0F 2E E2 7A 06 0F 84 CC 01 00 00 44 0F 2E CB 7A 06 0F 84 B5 01 00 00 44 0F 2E CA 7A 06 0F 84 9E 01 00 00 44 8B 8C 24 C0 00 00 00 41 81 CB 00 00 80 3F 44 8B 94 24 C4 00 00 00 41 81 E1 FF FF FF 7F 41 81 E2 FF FF FF 7F 44 89 8C 24 B4 00 00 00 44 89 94 24 B8 00 00 00 F3 44 0F 10 84 24 B4 00 00 00 F3 0F 10 A4 24 B8 00 00 00 44 89 9C 24 BC 00 00 00 44 0F 2F C4 76 1E 44 0F 28 D0 F2 44 0F 10 0D ?? ?? ?? ?? F3 44 0F 5C D4 F3 45 0F 5E D0 F3 45 0F 5A C2 EB 0E F3 44 0F 5E C4 F3 45 0F 5A C0 45 0F 57 C9 41 0F 28 F0 4C 8D 0D ?? ?? ?? ?? F2 41 0F 59 F0 4D 8B D1 0F 28 FE F2 0F 59 FE F2 0F 10 2D ?? ?? ?? ?? F2 0F 59 EF F2 0F 10 25 ?? ?? ?? ?? F2 44 0F 10 15 ?? ?? ?? ?? F2 0F 58 EC F2 0F 59 EF F2 0F 10 25 ?? ?? ?? ?? 41 C1 F8 1F F2 0F 58 EC F2 0F 59 EF F2 0F 10 25 ?? ?? ?? ?? 4D 63 C0 F2 0F 58 EC F2 0F 59 EF F2 0F 10 25 ?? ?? ?? ?? F2 0F 58 EC F2 0F 10 25 ?? ?? ?? ?? F2 0F 59 E7 F2 41 0F 58 E2 F2 44 0F 10 15 ?? ?? ?? ?? F2 0F 59 E7 F2 41 0F 58 E2 F2 0F 59 E7 F2 0F 10 3D ?? ?? ?? ?? F2 0F 58 E7 F2 0F 59 F4 F2 0F 58 EE F2 44 0F 59 C5 F2 45 0F 58 C8 F3 44 0F 5A 84 24 BC 00 00 00 F2 47 0F 59 4C C1 18 F2 47 0F 58 4C C2 08 F2 45 0F 59 C8 F2 45 0F 5A C9 F3 44 0F 11 8C 8C A0 00 00 00 48 FF C1 48 83 F9 04 0F 8C C3 FD FF FF 44 0F 28 44 24 40 44 0F 28 4C 24 30 44 0F 28 54 24 20 0F 28 84 24 A0 00 00 00 0F 28 74 24 70 0F 28 7C 24 60 48 81 C4 C8 00 00 00 C3 F3 44 0F 10 0D ?? ?? ?? ?? EB B2 F3 44 0F 10 0D ?? ?? ?? ?? EB A7 44 0F 2E CB 7A 02 74 36 44 0F 2E CA 7A 02 74 20 44 0F 2F C8 F3 44 0F 10 0D ?? ?? ?? ?? F3 0F 10 25 ?? ?? ?? ?? 77 80 44 0F 28 CC E9 77 FF FF FF F3 44 0F 10 0D ?? ?? ?? ?? E9 69 FF FF FF F3 44 0F 10 0D ?? ?? ?? ?? E9 5B FF FF FF 44 0F 2E CB 7A 02 74 2D 44 0F 2E CA 7A 02 74 17 41 0F 2F C1 44 0F 28 C9 0F 87 3D FF FF FF 44 0F 28 C8 E9 34 FF FF FF F3 44 0F 10 0D ?? ?? ?? ?? E9 26 FF FF FF F3 44 0F 10 0D ?? ?? ?? ?? E9 18 FF FF FF 44 0F 2F C8 F3 44 0F 10 0D ?? ?? ?? ?? F3 0F 10 25 ?? ?? ?? ?? 0F 87 FD FE FF FF 44 0F 28 CC E9 F4 FE FF FF 45 85 DB 74 36 0F 2F E0 0F 87 E6 FE FF FF 0F 2F C4 76 0E F3 44 0F 10 0D ?? ?? ?? ?? E9 D3 FE FF FF 45 85 C0 F3 0F 10 25 ?? ?? ?? ?? 0F 84 C2 FE FF FF 44 0F 28 CC E9 B9 FE FF FF 0F 2F E0 0F 87 B0 FE FF FF 0F 2F C4 76 0E F3 44 0F 10 0D ?? ?? ?? ?? E9 9D FE FF FF 45 85 C0 F3 0F 10 25 ?? ?? ?? ?? 0F 84 8C FE FF FF 44 0F 28 CC E9 83 FE FF FF 66 0F 1F 44 00 00 }
	condition:
		$1
}

rule file_214_0_0 {
	meta:
		name = "??1type_info@@UEAA@XZ"
		size = 21
		refs = "000d ??_7type_info@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 89 08 C3 }
	condition:
		$1
}

rule file_46_144_3 {
	meta:
		name = "??1_Facet_base@std@@UEAA@XZ"
		size = 21
		refs = "000d ??_7_Facet_base@std@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 89 08 C3 }
	condition:
		$1
}

rule file_108_52_1 {
	meta:
		name = "??1_Ref_count_base@std@@UEAA@XZ"
		size = 21
		refs = "000d ??_7_Ref_count_base@std@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 89 08 C3 }
	condition:
		$1
}

rule file_107_165_3 {
	meta:
		name = "??1error_category@std@@UEAA@XZ"
		size = 21
		refs = "000d ??_7error_category@std@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 89 08 C3 }
	condition:
		$1
}

rule file_220_0_0 {
	meta:
		name = "__common_dlog10_cout_rare"
		size = 736
		refs = "003e _vmldLgHATab 006b _2il0floatpacket_78 0287 _2il0floatpacket_79"
	strings:
		$1 = { 48 83 EC 38 33 C0 44 0F B7 41 06 41 81 E0 F0 7F 00 00 41 81 F8 F0 7F 00 00 0F 84 79 02 00 00 F2 0F 10 11 45 33 C0 48 8B 09 48 89 4C 24 30 48 C1 E9 30 F7 C1 F0 7F 00 00 75 18 F2 0F 10 05 ?? ?? ?? ?? 41 B8 C4 FF FF FF F2 0F 59 D0 F2 0F 11 54 24 30 F2 0F 10 05 ?? ?? ?? ?? 66 0F 2F D0 0F 86 F9 01 00 00 0F 28 DA F2 0F 5C 1D ?? ?? ?? ?? F2 0F 11 5C 24 28 80 64 24 2F 7F F2 0F 10 44 24 28 66 0F 2F 05 ?? ?? ?? ?? 0F 86 56 01 00 00 F2 0F 11 54 24 28 44 0F B7 4C 24 2E 41 81 E1 0F 80 FF FF 41 81 C9 F0 3F FF FF 66 44 89 4C 24 2E F2 0F 10 64 24 28 0F 28 D4 0F 28 DC 0F B7 4C 24 36 81 E1 F0 7F 00 00 F2 0F 58 15 ?? ?? ?? ?? F2 0F 58 1D ?? ?? ?? ?? C1 E9 04 F2 0F 11 54 24 20 44 8B 54 24 20 41 83 E2 7F F2 0F 11 5C 24 20 45 8D 84 08 01 FC FF FF F2 0F 10 5C 24 20 48 8D 0D ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? 4C 8B C9 F2 0F 10 2D ?? ?? ?? ?? 47 8D 1C 52 F2 0F 10 15 ?? ?? ?? ?? F2 41 0F 2A C0 F2 0F 5C 1D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 5C E3 F2 0F 59 C5 4C 8B C1 F2 42 0F 10 2C D9 F2 0F 59 DD F2 43 0F 58 44 D9 10 F2 43 0F 58 4C D8 08 F2 0F 59 EC F2 0F 5C 1D ?? ?? ?? ?? 0F 28 E3 F2 0F 58 CB F2 0F 58 E5 F2 0F 59 D4 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D4 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D4 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D4 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D4 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D4 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D4 0F 28 E5 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 E2 F2 0F 59 DA F2 0F 58 C4 F2 0F 58 E8 F2 0F 58 EB F2 0F 58 CD F2 0F 11 0A 48 83 C4 38 C3 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 D8 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 CB F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CB F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CB F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CB F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CB F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CB F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CB F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CB F2 0F 58 D9 F2 0F 11 1A 48 83 C4 38 C3 66 0F 2E D0 7A 02 74 12 F2 0F 5E C0 F2 0F 11 02 B8 01 00 00 00 48 83 C4 38 C3 F2 0F 10 0D ?? ?? ?? ?? B8 02 00 00 00 0F 57 0D ?? ?? ?? ?? F2 0F 5E C8 F2 0F 11 0A 48 83 C4 38 C3 44 8A 41 07 41 80 E0 80 41 80 F8 80 74 11 F2 0F 10 01 F2 0F 59 C0 F2 0F 11 02 48 83 C4 38 C3 F7 41 04 FF FF 0F 00 75 E6 83 39 00 75 E1 F2 0F 10 05 ?? ?? ?? ?? B8 01 00 00 00 F2 0F 5E C0 F2 0F 11 02 48 83 C4 38 C3 90 }
	condition:
		$1
}

rule file_221_0_0 {
	meta:
		name = "__avx_acosf8"
		size = 576
		refs = "0036 __common_sacos_data 022b __common_sacos_cout_rare"
	strings:
		$1 = { 48 81 EC 18 02 00 00 C5 7C 11 BC 24 B0 01 00 00 C5 7C 11 B4 24 F0 01 00 00 C5 FC 11 B4 24 D0 01 00 00 4C 89 AC 24 10 02 00 00 4C 8D AC 24 4F 01 00 00 C5 FC 10 25 ?? ?? ?? ?? 49 83 E5 C0 C5 FC 10 0D ?? ?? ?? ?? C5 DC 56 E8 C5 D4 59 D9 C5 54 59 FD C5 54 C2 35 ?? ?? ?? ?? 12 C5 E4 58 D1 C5 84 5D CA C4 41 01 EF FF C5 DC 54 E0 C4 63 7D 19 F3 01 C5 89 6B F3 C4 41 49 63 F7 C5 FC 52 F2 C5 F4 C2 DA 15 C5 EC 58 D2 C4 C1 79 D7 D6 C5 4C 59 FE C5 6C 59 F6 C4 C1 6C 59 D7 C5 6C 5C 3D ?? ?? ?? ?? C5 84 59 35 ?? ?? ?? ?? C5 CC 58 15 ?? ?? ?? ?? C4 C1 0C 59 F7 C5 6C 59 FE C4 C1 0C 5C D7 C5 74 59 35 ?? ?? ?? ?? C4 E3 55 4A EA 30 C5 0C 58 3D ?? ?? ?? ?? C5 74 59 35 ?? ?? ?? ?? C5 8C 58 35 ?? ?? ?? ?? C5 74 59 F1 C4 41 04 59 FE C5 84 58 F6 C5 4C 59 F9 C5 04 58 35 ?? ?? ?? ?? C5 7C C2 F9 11 C5 0C 59 F1 C5 E4 54 0D ?? ?? ?? ?? C4 C1 74 54 F7 C5 E4 55 0D ?? ?? ?? ?? C5 74 58 FE C5 D4 57 CC C5 0C 59 F1 C5 8C 58 D1 C5 84 58 CA 84 D2 75 2F C5 FC 10 B4 24 D0 01 00 00 C5 7C 10 B4 24 F0 01 00 00 C5 7C 10 BC 24 B0 01 00 00 4C 8B AC 24 10 02 00 00 C5 FC 28 C1 48 81 C4 18 02 00 00 C3 C4 C1 7C 11 45 00 C4 C1 7C 11 4D 40 85 D2 74 C1 33 C0 C5 FC 11 BC 24 E0 00 00 00 C5 7C 11 84 24 C0 00 00 00 C5 7C 11 8C 24 A0 00 00 00 C5 7C 11 94 24 80 00 00 00 C5 7C 11 5C 24 60 C5 7C 11 64 24 40 C5 7C 11 6C 24 20 48 89 9C 24 08 01 00 00 8B D8 48 89 B4 24 00 01 00 00 8B F2 0F A3 DE 72 58 FF C3 83 FB 20 7C F4 C5 FC 10 BC 24 E0 00 00 00 C5 7C 10 84 24 C0 00 00 00 C5 7C 10 8C 24 A0 00 00 00 C5 7C 10 94 24 80 00 00 00 C5 7C 10 5C 24 60 C5 7C 10 64 24 40 C5 7C 10 6C 24 20 C4 C1 7C 10 4D 40 48 8B 9C 24 08 01 00 00 48 8B B4 24 00 01 00 00 E9 18 FF FF FF C5 F8 77 49 8D 4C 9D 00 49 8D 54 9D 40 E8 ?? ?? ?? ?? EB 94 66 66 66 66 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_222_0_0 {
	meta:
		name = "__vdecl_fmodf4"
		size = 107
		refs = "0011 fmodf"
	strings:
		$1 = { 48 83 EC 48 F3 0F 7F 44 24 20 F3 0F 7F 4C 24 30 E8 ?? ?? ?? ?? 66 0F 7E 44 24 20 66 0F 6E 44 24 24 66 0F 6E 4C 24 34 E8 ?? ?? ?? ?? 66 0F 7E 44 24 24 66 0F 6E 44 24 28 66 0F 6E 4C 24 38 E8 ?? ?? ?? ?? 66 0F 7E 44 24 28 66 0F 6E 44 24 2C 66 0F 6E 4C 24 3C E8 ?? ?? ?? ?? 66 0F 7E 44 24 2C F3 0F 6F 44 24 20 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_224_0_0 {
	meta:
		name = "__raise_securityfailure"
		size = 53
		refs = "000d __imp_SetUnhandledExceptionFilter 0018 __imp_UnhandledExceptionFilter 001e __imp_GetCurrentProcess 002c __imp_TerminateProcess"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 33 C9 FF 15 ?? ?? ?? ?? 48 8B 4C 24 30 FF 15 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? BA 09 04 00 C0 48 8B C8 FF 15 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_224_1_0 {
	meta:
		name = "__report_gsfailure"
		size = 209
		refs = "000f IsProcessorFeaturePresent 0021 GS_ContextRecord 0026 capture_previous_context 0050 GS_ExceptionRecord 00a2 __security_cookie 00b7 __security_cookie_complement 00c3 GS_ExceptionPointers 00c8 __raise_securityfailure"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 B9 17 00 00 00 E8 ?? ?? ?? ?? 85 C0 74 07 B9 02 00 00 00 CD 29 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 44 24 38 48 89 05 ?? ?? ?? ?? 48 8D 44 24 38 48 83 C0 08 48 89 05 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 8B 44 24 40 48 89 05 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 09 04 00 C0 C7 05 ?? ?? ?? ?? 01 00 00 00 C7 05 ?? ?? ?? ?? 01 00 00 00 B8 08 00 00 00 48 6B C0 00 48 8D 0D ?? ?? ?? ?? 48 C7 04 01 02 00 00 00 B8 08 00 00 00 48 6B C0 00 48 8B 0D ?? ?? ?? ?? 48 89 4C 04 20 B8 08 00 00 00 48 6B C0 01 48 8B 0D ?? ?? ?? ?? 48 89 4C 04 20 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_224_2_0 {
	meta:
		name = "__report_rangecheckfailure"
		size = 19
		refs = "000a __report_securityfailure"
	strings:
		$1 = { 48 83 EC 28 B9 08 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_224_3_0 {
	meta:
		name = "__report_securityfailure"
		size = 155
		refs = "000e IsProcessorFeaturePresent 0021 GS_ContextRecord 0026 capture_current_context 0050 GS_ExceptionRecord 008d GS_ExceptionPointers 0092 __raise_securityfailure"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 B9 17 00 00 00 E8 ?? ?? ?? ?? 85 C0 74 08 8B 44 24 30 8B C8 CD 29 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 44 24 28 48 89 05 ?? ?? ?? ?? 48 8D 44 24 28 48 83 C0 08 48 89 05 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 09 04 00 C0 C7 05 ?? ?? ?? ?? 01 00 00 00 C7 05 ?? ?? ?? ?? 01 00 00 00 B8 08 00 00 00 48 6B C0 00 48 8D 0D ?? ?? ?? ?? 8B 54 24 30 48 89 14 01 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_224_4_0 {
	meta:
		name = "__report_securityfailureEx"
		size = 270
		refs = "0017 IsProcessorFeaturePresent 002a GS_ContextRecord 002f capture_current_context 0059 GS_ExceptionRecord 0100 GS_ExceptionPointers 0105 __raise_securityfailure"
	strings:
		$1 = { 4C 89 44 24 18 89 54 24 10 89 4C 24 08 48 83 EC 38 B9 17 00 00 00 E8 ?? ?? ?? ?? 85 C0 74 08 8B 44 24 40 8B C8 CD 29 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 44 24 38 48 89 05 ?? ?? ?? ?? 48 8D 44 24 38 48 83 C0 08 48 89 05 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 09 04 00 C0 C7 05 ?? ?? ?? ?? 01 00 00 00 83 7C 24 48 00 76 10 48 83 7C 24 50 00 75 08 C7 44 24 48 00 00 00 00 83 7C 24 48 0E 76 0A 8B 44 24 48 FF C8 89 44 24 48 8B 44 24 48 FF C0 89 05 ?? ?? ?? ?? B8 08 00 00 00 48 6B C0 00 48 8D 0D ?? ?? ?? ?? 8B 54 24 40 48 89 14 01 C7 44 24 20 00 00 00 00 EB 0A 8B 44 24 20 FF C0 89 44 24 20 8B 44 24 48 39 44 24 20 73 22 8B 44 24 20 8B 4C 24 20 FF C1 8B C9 48 8D 15 ?? ?? ?? ?? 4C 8B 44 24 50 49 8B 04 C0 48 89 04 CA EB CA 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_224_5_0 {
	meta:
		name = "capture_current_context"
		size = 145
		refs = "0013 __imp_RtlCaptureContext 003a __imp_RtlLookupFunctionEntry 0088 __imp_RtlVirtualUnwind"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 8B 8C 24 80 00 00 00 FF 15 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 48 8B 80 F8 00 00 00 48 89 44 24 48 45 33 C0 48 8D 54 24 50 48 8B 4C 24 48 FF 15 ?? ?? ?? ?? 48 89 44 24 40 48 83 7C 24 40 00 74 41 48 C7 44 24 38 00 00 00 00 48 8D 44 24 58 48 89 44 24 30 48 8D 44 24 60 48 89 44 24 28 48 8B 84 24 80 00 00 00 48 89 44 24 20 4C 8B 4C 24 40 4C 8B 44 24 48 48 8B 54 24 50 33 C9 FF 15 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_224_6_0 {
	meta:
		name = "capture_previous_context"
		size = 178
		refs = "0013 __imp_RtlCaptureContext 0055 __imp_RtlLookupFunctionEntry 00a3 __imp_RtlVirtualUnwind"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 8B 8C 24 80 00 00 00 FF 15 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 48 8B 80 F8 00 00 00 48 89 44 24 50 C7 44 24 40 00 00 00 00 EB 0A 8B 44 24 40 FF C0 89 44 24 40 83 7C 24 40 02 7D 67 45 33 C0 48 8D 54 24 58 48 8B 4C 24 50 FF 15 ?? ?? ?? ?? 48 89 44 24 48 48 83 7C 24 48 00 74 43 48 C7 44 24 38 00 00 00 00 48 8D 44 24 60 48 89 44 24 30 48 8D 44 24 68 48 89 44 24 28 48 8B 84 24 80 00 00 00 48 89 44 24 20 4C 8B 4C 24 48 4C 8B 44 24 50 48 8B 54 24 58 33 C9 FF 15 ?? ?? ?? ?? EB 02 EB 02 EB 88 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_226_0_0 {
	meta:
		name = "__common_dpow_cout_rare"
		size = 2896
		refs = "01a0 _vmldPowHATab"
	strings:
		$1 = { 53 56 57 41 54 41 55 41 56 41 57 55 48 81 EC C8 00 00 00 33 C0 4C 8B 31 4D 8B EE 48 8B 1A 4D 8B E6 F2 0F 10 12 48 8B D3 48 89 5C 24 68 4D 8B CE 48 C1 EB 38 49 C1 ED 30 48 C1 EA 30 49 C1 EC 38 41 81 E5 F0 7F 00 00 49 C1 E9 20 81 E2 F0 7F 00 00 41 81 E4 80 00 00 00 80 E3 80 41 C1 ED 04 C1 EA 04 41 C1 EC 07 C0 EB 07 44 0F 29 BC 24 80 00 00 00 44 0F 29 74 24 70 44 0F 29 A4 24 90 00 00 00 44 0F 29 8C 24 A0 00 00 00 0F 29 BC 24 B0 00 00 00 F2 0F 10 09 41 8B CE 41 F7 C1 FF FF 0F 00 75 0F 85 C9 75 0B 41 BA 01 00 00 00 45 8B DA EB 09 45 33 D2 41 BB 01 00 00 00 8B 4C 24 6C 8B 7C 24 68 81 E1 FF FF 0F 00 75 09 85 FF 75 05 45 8B CB EB 03 45 33 C9 8B F2 33 ED 81 FA FF 07 00 00 41 0F 45 EB C1 E6 14 0B F1 8B CF 0B CE 74 6A 81 FA FF 03 00 00 8D 8A 01 FC FF FF 7C 18 85 ED 74 14 83 F9 14 7F 2A 44 8B FE 41 D3 E7 41 C1 E7 0C 44 0B FF 74 04 33 F6 EB 45 8D 8A 0C FC FF FF D3 E6 F7 D6 81 E6 00 00 00 80 C1 EE 1F FF C6 EB 2E 83 F9 35 7D 24 8D 8A 0C FC FF FF D3 E7 F7 C7 FF FF FF 7F 74 04 33 F6 EB 15 F7 D7 81 E7 00 00 00 80 C1 EF 1F 8D 77 01 EB 05 BE 02 00 00 00 45 85 E4 75 0D 41 81 FD FF 03 00 00 0F 84 CB 09 00 00 85 D2 75 09 45 85 C9 0F 85 DC 03 00 00 33 FF 41 81 FD FF 07 00 00 41 0F 45 FB 44 0B D7 0F 84 BD 03 00 00 44 0B CD 0F 84 B4 03 00 00 F2 0F 10 05 ?? ?? ?? ?? 48 8B 0D ?? ?? ?? ?? 66 0F 2E C8 7A 06 0F 84 41 09 00 00 66 0F 2E 0D ?? ?? ?? ?? 7A 06 0F 84 0D 09 00 00 85 FF 0F 84 2E 03 00 00 85 ED 0F 84 26 03 00 00 66 0F 2F C8 77 08 85 F6 0F 84 EF 02 00 00 41 23 F4 48 8D 0D ?? ?? ?? ?? 4C 89 74 24 30 49 C1 EE 38 41 83 E6 7F F2 0F 10 84 F1 A8 1A 00 00 33 C9 44 88 74 24 37 45 85 ED 75 1B F2 0F 10 4C 24 30 B9 38 FF FF FF F2 0F 59 0D ?? ?? ?? ?? F2 0F 11 4C 24 30 EB 06 F2 0F 10 4C 24 30 0F B7 6C 24 36 4C 8D 0D ?? ?? ?? ?? 81 E5 F0 7F 00 00 4D 8B D1 C1 ED 04 4D 8B E9 8B 7C 24 34 4D 8B F9 C1 E5 14 81 E7 FF FF 0F 00 F2 0F 11 4C 24 40 0B EF 0F B7 74 24 46 81 C5 00 40 18 C0 81 E6 0F 80 FF FF 4D 8B E1 81 CE F0 3F FF FF 49 8B F9 66 89 74 24 46 49 8B F1 C1 FD 14 03 E9 8B 4C 24 44 81 E1 00 C0 0F 00 81 C1 00 40 00 00 C1 E9 0F F2 0F 10 54 24 40 0F 28 DA F2 0F 2A FD F2 41 0F 10 2C C9 03 C9 44 0F 28 E5 49 8B E9 F2 44 0F 59 E2 F2 44 0F 11 64 24 48 44 8B 5C 24 4C 41 81 E3 00 FC 00 00 41 81 C3 00 04 00 00 41 C1 EB 0B F2 43 0F 10 8C DA 18 03 00 00 45 03 DB F2 44 0F 59 E1 F2 41 0F 58 BC CF 08 01 00 00 F2 0F 59 E9 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 D9 F2 44 0F 11 64 24 50 44 8B 74 24 54 41 81 E6 F0 0F 00 00 F2 0F 11 5C 24 58 41 83 C6 10 F2 0F 10 64 24 58 41 C1 EE 05 F2 0F 5C 64 24 40 F2 0F 11 64 24 60 F2 0F 10 5C 24 58 F2 47 0F 10 BC F5 30 06 00 00 45 03 F6 F2 45 0F 59 E7 F2 41 0F 59 EF F2 42 0F 58 BC DD 20 04 00 00 F2 44 0F 10 7C 24 60 45 0F 28 F4 F2 41 0F 5C DF F2 44 0F 5C 35 ?? ?? ?? ?? F2 43 0F 58 BC F7 38 0A 00 00 F2 0F 11 5C 24 58 F2 0F 10 64 24 58 F2 47 0F 10 8C DC 28 04 00 00 F2 0F 5C D4 F2 46 0F 58 8C F6 40 0A 00 00 F2 0F 11 54 24 60 0F 28 D5 F2 0F 59 D1 F2 44 0F 58 8C CF 10 01 00 00 F2 0F 10 5C 24 58 F2 0F 10 64 24 60 F2 0F 11 54 24 58 F2 44 0F 10 7C 24 58 F2 44 0F 5C FD F2 44 0F 11 7C 24 60 F2 44 0F 10 7C 24 58 F2 0F 10 54 24 60 F2 44 0F 5C FA F2 44 0F 11 7C 24 58 F2 0F 10 54 24 58 F2 0F 5C EA 0F 28 D3 F2 0F 11 6C 24 60 F2 0F 10 6C 24 58 F2 0F 59 D5 F2 0F 59 EC F2 41 0F 5C D4 44 0F 28 E7 F2 0F 58 D5 F2 45 0F 58 E6 F2 44 0F 10 7C 24 60 F2 41 0F 59 DF F2 41 0F 59 E7 F2 0F 58 D3 F2 44 0F 11 64 24 58 F2 0F 58 D4 F2 0F 10 5C 24 58 F2 0F 5C FB F2 41 0F 58 FE F2 0F 11 7C 24 60 F2 0F 10 64 24 58 F2 0F 11 64 24 38 0F B7 4C 24 3E 81 E1 F0 7F 00 00 C1 E9 04 03 D1 F2 0F 10 5C 24 60 81 FA 09 08 00 00 0F 8D 0C 06 00 00 81 FA C0 07 00 00 0F 8F 30 01 00 00 48 8B 15 ?? ?? ?? ?? 48 89 54 24 58 F2 0F 10 4C 24 58 F2 0F 58 0D ?? ?? ?? ?? F2 0F 11 4C 24 58 F2 0F 10 54 24 58 F2 0F 59 C2 E9 BF 00 00 00 48 89 4C 24 58 41 8B C3 F2 0F 10 4C 24 58 F2 0F 10 44 24 58 F2 0F 5E C8 F2 0F 11 4C 24 58 F2 0F 10 44 24 58 E9 96 00 00 00 41 81 FD FF 03 00 00 7D 11 84 DB 0F 84 85 00 00 00 0F 28 C2 F2 0F 59 C2 EB 7C 84 DB 74 15 41 23 F4 48 8D 15 ?? ?? ?? ?? F2 0F 59 84 F2 A8 1A 00 00 EB 63 F2 0F 59 C9 41 23 F4 F2 0F 59 D1 48 8D 15 ?? ?? ?? ?? 0F 28 C2 F2 0F 59 84 F2 A8 1A 00 00 EB 43 0F 28 C1 F2 0F 58 C2 EB 3A 48 8B 15 ?? ?? ?? ?? F2 0F 58 CA F2 0F 11 4C 24 58 48 89 54 24 60 8A 4C 24 5F 8A 5C 24 67 80 E1 80 80 E3 7F 0A D9 88 5C 24 67 F2 0F 10 44 24 60 F2 0F 10 4C 24 60 F2 0F 59 C1 0F 28 BC 24 B0 00 00 00 44 0F 28 8C 24 A0 00 00 00 44 0F 28 A4 24 90 00 00 00 44 0F 28 74 24 70 44 0F 28 BC 24 80 00 00 00 F2 41 0F 11 00 48 81 C4 C8 00 00 00 5D 41 5F 41 5E 41 5D 41 5C 5F 5E 5B C3 F2 44 0F 10 25 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? F2 44 0F 10 7C 24 38 48 8B D9 F2 44 0F 58 F2 F2 0F 58 D3 F2 45 0F 59 E6 F2 44 0F 58 CA F2 44 0F 58 25 ?? ?? ?? ?? F2 45 0F 59 E6 41 0F 28 F9 F2 44 0F 58 25 ?? ?? ?? ?? F2 45 0F 59 E6 F2 44 0F 58 25 ?? ?? ?? ?? F2 45 0F 59 E6 F2 41 0F 58 E4 F2 0F 11 64 24 58 F2 44 0F 10 74 24 58 F2 45 0F 5C FE F2 45 0F 58 FC F2 44 0F 11 7C 24 60 F2 0F 10 5C 24 58 F2 0F 10 64 24 60 F2 0F 58 FB F2 0F 11 7C 24 58 F2 0F 10 54 24 58 F2 0F 5C DA F2 41 0F 58 D9 44 0F 28 C9 F2 0F 11 5C 24 60 F2 44 0F 10 64 24 58 F2 45 0F 59 CC F2 0F 10 7C 24 60 F2 44 0F 11 4C 24 58 F2 0F 58 FC F2 0F 10 54 24 58 F2 0F 59 7C 24 68 F2 41 0F 5C D4 F2 0F 11 54 24 60 F2 0F 10 64 24 58 F2 0F 10 5C 24 60 F2 0F 5C E3 F2 0F 11 64 24 58 F2 0F 10 6C 24 58 F2 44 0F 5C E5 F2 44 0F 11 64 24 60 F2 44 0F 10 64 24 68 45 0F 28 F4 F2 44 0F 59 35 ?? ?? ?? ?? F2 0F 10 64 24 58 F2 0F 10 6C 24 60 F2 44 0F 11 74 24 58 F2 44 0F 10 7C 24 58 F2 44 0F 5C 7C 24 68 F2 44 0F 11 7C 24 60 F2 0F 10 54 24 58 F2 44 0F 10 4C 24 60 F2 41 0F 5C D1 F2 0F 11 54 24 58 F2 0F 10 5C 24 58 F2 44 0F 5C E3 F2 44 0F 11 64 24 60 F2 44 0F 10 74 24 58 F2 44 0F 10 4C 24 60 41 0F 28 D6 41 0F 28 D9 F2 0F 59 DD F2 44 0F 59 F5 F2 0F 59 D4 F2 41 0F 59 E1 F2 41 0F 58 DE F2 0F 58 DC F2 0F 10 25 ?? ?? ?? ?? F2 0F 58 E2 F2 0F 58 FB F2 0F 11 64 24 58 F2 0F 10 6C 24 58 8B 54 24 58 8B F2 83 E2 7F F2 0F 5C 2D ?? ?? ?? ?? F2 0F 11 6C 24 20 03 D2 F2 44 0F 10 7C 24 20 F2 41 0F 5C D7 F2 0F 11 54 24 28 F2 0F 10 54 24 28 F2 0F 10 A4 D1 48 12 00 00 F2 0F 58 FA F2 0F 10 15 ?? ?? ?? ?? F2 0F 59 D7 C1 FE 07 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D7 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D7 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D7 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D7 F2 0F 59 D4 F2 0F 58 94 D3 50 12 00 00 0F 28 DA F2 0F 58 DC F2 0F 11 5C 24 30 0F B7 54 24 36 8B EA 81 E5 F0 7F 00 00 C1 ED 04 8D 8C 2E 01 FC FF FF 81 F9 00 04 00 00 0F 8D 23 02 00 00 81 F9 02 FC FF FF 7C 31 81 C1 FF 03 00 00 81 E2 0F 80 FF FF 81 E1 FF 07 00 00 C1 E1 04 0B D1 66 89 54 24 36 F2 0F 10 4C 24 30 F2 0F 59 C1 F2 0F 11 44 24 30 E9 0F FD FF FF 81 F9 F8 FB FF FF 0F 8C 22 01 00 00 F2 0F 11 5C 24 58 81 C6 C8 00 00 00 F2 0F 10 5C 24 58 81 C6 FF 03 00 00 48 8B 15 ?? ?? ?? ?? 81 E6 FF 07 00 00 48 89 54 24 38 F2 0F 5C E3 48 C1 EA 30 F2 0F 58 E2 F2 0F 11 64 24 60 81 E2 0F 80 FF FF F2 44 0F 10 4C 24 58 F2 41 0F 59 C9 F2 0F 10 54 24 60 F2 0F 11 4C 24 58 F2 0F 10 4C 24 58 C1 E6 04 F2 41 0F 5C C9 F2 0F 11 4C 24 60 0B D6 F2 0F 10 6C 24 58 F2 0F 10 64 24 60 66 89 54 24 3E F2 0F 5C EC F2 0F 11 6C 24 58 F2 0F 10 7C 24 58 F2 44 0F 10 7C 24 38 F2 44 0F 5C CF F2 44 0F 11 4C 24 60 F2 0F 10 4C 24 58 F2 44 0F 10 64 24 60 F2 44 0F 10 35 ?? ?? ?? ?? F2 41 0F 58 D4 F2 41 0F 59 C6 F2 41 0F 59 CF F2 41 0F 59 D7 F2 0F 59 C8 F2 0F 59 C2 F2 0F 11 44 24 58 48 8B 0D ?? ?? ?? ?? F2 0F 10 44 24 58 48 89 4C 24 58 F2 0F 58 C8 F2 0F 10 54 24 58 F2 0F 10 44 24 58 F2 0F 59 D0 F2 0F 11 54 24 58 F2 44 0F 10 64 24 58 F2 41 0F 58 CC 0F 28 C1 F2 0F 11 44 24 30 E9 E1 FB FF FF 81 F9 C4 FB FF FF 7C 7D 48 8B 15 ?? ?? ?? ?? 81 C6 C7 04 00 00 48 89 54 24 38 81 E6 FF 07 00 00 48 C1 EA 30 C1 E6 04 81 E2 0F 80 FF FF 0B D6 66 89 54 24 3E F2 0F 10 0D ?? ?? ?? ?? F2 0F 10 54 24 38 F2 0F 59 C1 F2 0F 59 DA 48 8B 0D ?? ?? ?? ?? 48 89 4C 24 58 F2 0F 59 C3 F2 0F 10 5C 24 58 F2 0F 10 64 24 58 F2 0F 59 E3 F2 0F 11 64 24 58 F2 0F 10 6C 24 58 F2 0F 58 C5 F2 0F 11 44 24 30 E9 5C FB FF FF 48 8B 15 ?? ?? ?? ?? 48 89 54 24 58 F2 0F 10 4C 24 58 F2 0F 10 54 24 58 F2 0F 59 D1 F2 0F 11 54 24 58 F2 0F 10 5C 24 58 F2 0F 59 C3 F2 0F 11 44 24 30 E9 25 FB FF FF 48 8B 15 ?? ?? ?? ?? 48 89 54 24 58 F2 0F 10 54 24 58 F2 0F 10 4C 24 58 F2 0F 59 D1 F2 0F 11 54 24 58 F2 0F 10 5C 24 58 F2 0F 59 C3 F2 0F 11 44 24 30 E9 EE FA FF FF 8A 54 24 3F 48 8D 0D ?? ?? ?? ?? 80 E2 80 C0 EA 07 32 DA 0F B6 DB F2 0F 10 8C D9 90 1A 00 00 F2 0F 59 C9 F2 0F 59 C8 0F 28 C1 E9 BF FA FF FF 85 F6 75 08 85 ED 0F 85 E7 F6 FF FF 83 E6 01 48 8D 15 ?? ?? ?? ?? F2 0F 10 84 F2 A8 1A 00 00 E9 9B FA FF FF F2 0F 59 C9 84 DB 74 1F 41 23 F4 48 8D 05 ?? ?? ?? ?? F2 0F 10 84 F0 A8 1A 00 00 41 8B C3 F2 0F 5E C1 E9 74 FA FF FF 41 23 F4 48 8D 15 ?? ?? ?? ?? F2 0F 10 84 F2 A8 1A 00 00 F2 0F 59 C1 E9 58 FA FF FF 45 85 D2 0F 84 2C F6 FF FF E9 10 FA FF FF 0F 1F 80 00 00 00 00 }
	condition:
		$1
}

rule file_227_0_0 {
	meta:
		name = "__chkstk2"
		size = 63
	strings:
		$1 = { 41 50 41 51 4D 33 C9 4C 8D 44 24 18 4C 2B C0 4D 0F 42 C1 65 4C 8B 0C 25 10 00 00 00 4D 3B C1 F2 73 17 66 41 81 E0 00 F0 4D 8D 89 00 F0 FF FF 41 C6 01 00 4D 3B C1 F2 75 EF 41 59 41 58 F2 C3 }
	condition:
		$1
}

rule file_228_0_0 {
	meta:
		name = "__common_dasin_cout_rare"
		size = 2752
		refs = "0070 _vmldASinHATab"
	strings:
		$1 = { 56 48 81 EC D0 00 00 00 33 C0 44 0F B7 41 06 41 81 E0 F0 7F 00 00 F2 0F 10 01 41 81 F8 F0 7F 00 00 48 8B 31 44 0F 29 BC 24 A0 00 00 00 44 0F 29 B4 24 B0 00 00 00 44 0F 29 5C 24 60 44 0F 29 54 24 70 44 0F 29 8C 24 80 00 00 00 44 0F 29 84 24 90 00 00 00 0F 29 BC 24 C0 00 00 00 0F 84 3E 0A 00 00 48 89 74 24 38 48 C1 EE 38 F2 44 0F 10 1D ?? ?? ?? ?? 83 E6 7F 40 88 74 24 3F F2 44 0F 10 4C 24 38 4C 8B 0D ?? ?? ?? ?? 66 45 0F 2F D9 0F 82 B9 09 00 00 F2 0F 10 05 ?? ?? ?? ?? 66 41 0F 2F C1 0F 86 1A 04 00 00 66 44 0F 2F 0D ?? ?? ?? ?? 0F 86 7C 03 00 00 F2 44 0F 10 35 ?? ?? ?? ?? 41 0F 28 E1 F2 41 0F 59 E6 45 0F 28 C1 F2 0F 11 64 24 28 45 0F 28 D1 F2 44 0F 10 5C 24 28 41 0F 28 DE F2 44 0F 5C 5C 24 38 F2 44 0F 11 5C 24 20 F2 0F 10 7C 24 28 F2 0F 10 4C 24 20 F2 0F 5C F9 F2 0F 11 7C 24 28 F2 0F 10 54 24 28 F2 44 0F 5C C2 F2 44 0F 11 44 24 20 F2 0F 10 6C 24 28 0F 28 D5 F2 44 0F 58 D5 F2 0F 59 D5 F2 44 0F 10 7C 24 20 0F 28 C2 F2 45 0F 59 D7 F2 0F 59 DA F2 41 0F 58 C2 F2 44 0F 10 05 ?? ?? ?? ?? F2 44 0F 59 C0 F2 0F 11 5C 24 28 F2 0F 10 64 24 28 F2 44 0F 58 05 ?? ?? ?? ?? F2 0F 5C E2 F2 44 0F 59 C0 F2 0F 11 64 24 20 F2 0F 10 4C 24 28 F2 44 0F 10 5C 24 20 F2 44 0F 58 05 ?? ?? ?? ?? F2 41 0F 5C CB F2 44 0F 59 C0 F2 0F 11 4C 24 28 F2 0F 10 7C 24 28 F2 44 0F 58 05 ?? ?? ?? ?? F2 0F 5C D7 F2 44 0F 59 C0 F2 0F 11 54 24 20 41 0F 28 F9 F2 0F 10 64 24 28 F2 0F 10 5C 24 20 F2 44 0F 59 FC F2 44 0F 58 05 ?? ?? ?? ?? F2 44 0F 58 D3 F2 0F 59 EC F2 44 0F 59 C0 F2 41 0F 59 FA F2 44 0F 58 05 ?? ?? ?? ?? F2 41 0F 58 FF F2 44 0F 59 C0 45 0F 28 FE F2 44 0F 58 05 ?? ?? ?? ?? F2 44 0F 59 FD F2 44 0F 59 C0 F2 44 0F 11 7C 24 28 F2 44 0F 10 5C 24 28 F2 44 0F 5C DD F2 44 0F 58 05 ?? ?? ?? ?? F2 44 0F 11 5C 24 20 44 0F 28 DD F2 0F 10 54 24 28 F2 0F 58 EF F2 44 0F 59 C0 F2 44 0F 59 D5 F2 44 0F 58 05 ?? ?? ?? ?? F2 0F 10 4C 24 20 F2 44 0F 59 C0 F2 0F 5C D1 F2 0F 11 54 24 28 F2 0F 10 5C 24 28 F2 44 0F 5C DB 0F 28 DC F2 44 0F 58 05 ?? ?? ?? ?? F2 44 0F 11 5C 24 20 F2 0F 10 4C 24 28 F2 0F 10 54 24 20 44 0F 28 FA F2 0F 59 D9 F2 44 0F 58 FF F2 44 0F 59 C0 F2 41 0F 59 E7 F2 44 0F 59 F3 F2 44 0F 58 05 ?? ?? ?? ?? F2 41 0F 58 E2 F2 44 0F 59 C0 F2 44 0F 11 74 24 28 44 0F 28 DB F2 44 0F 10 54 24 28 F2 44 0F 5C D3 F2 0F 58 DC F2 44 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 44 0F 11 54 24 20 F2 44 0F 10 54 24 28 F2 44 0F 10 74 24 20 F2 44 0F 59 C0 F2 45 0F 5C D6 F2 44 0F 11 54 24 28 F2 44 0F 10 15 ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? F2 44 0F 59 D5 F2 0F 59 C3 F2 0F 10 2D ?? ?? ?? ?? F2 44 0F 58 D0 F2 0F 59 CD F2 0F 59 FD F2 0F 59 D5 F2 45 0F 58 D0 F2 44 0F 10 74 24 28 41 0F 28 C1 F2 45 0F 5C DE F2 0F 58 C1 F2 44 0F 58 D7 F2 44 0F 11 5C 24 20 F2 44 0F 58 D2 F2 44 0F 10 74 24 28 F2 44 0F 10 5C 24 20 F2 0F 11 44 24 28 F2 0F 10 54 24 28 F2 0F 10 05 ?? ?? ?? ?? F2 44 0F 5C CA F2 0F 59 E0 F2 44 0F 59 F0 F2 41 0F 59 C3 F2 44 0F 58 C9 F2 44 0F 11 4C 24 20 F2 0F 10 4C 24 28 F2 44 0F 10 4C 24 20 F2 45 0F 58 D1 F2 44 0F 58 D4 0F 28 E1 F2 41 0F 58 E6 F2 44 0F 58 D0 F2 0F 11 64 24 28 F2 44 0F 10 4C 24 28 F2 41 0F 5C C9 F2 41 0F 58 CE F2 0F 11 4C 24 20 F2 0F 10 5C 24 28 F2 0F 10 54 24 20 8A 49 07 F2 44 0F 58 D2 80 E1 80 F2 44 0F 58 D3 F2 44 0F 11 54 24 30 40 8A 74 24 37 40 80 E6 7F 40 0A F1 40 88 74 24 37 4C 8B 44 24 30 4C 89 02 E9 2C 06 00 00 66 44 0F 2F 0D ?? ?? ?? ?? 72 42 F2 45 0F 58 CB F2 44 0F 11 4C 24 28 F2 0F 10 44 24 28 F2 0F 59 44 24 38 F2 0F 11 44 24 30 40 8A 74 24 37 8A 49 07 40 80 E6 7F 80 E1 80 40 0A F1 40 88 74 24 37 4C 8B 44 24 30 4C 89 02 E9 DF 05 00 00 F2 45 0F 59 C9 F2 44 0F 11 4C 24 28 F2 0F 10 44 24 28 8A 49 07 80 E1 80 F2 0F 58 44 24 38 F2 0F 11 44 24 30 40 8A 74 24 37 40 80 E6 7F 40 0A F1 40 88 74 24 37 4C 8B 44 24 30 4C 89 02 E9 9D 05 00 00 4D 8B D1 F2 45 0F 5C D9 F2 41 0F 59 C3 F2 0F 11 44 24 38 44 0F B7 44 24 3E 41 81 E0 F0 7F 00 00 41 C1 E8 04 41 81 C0 01 FC FF FF 45 8B D8 41 8B F0 41 F7 DB 41 81 C3 FF 03 00 00 49 C1 EA 30 41 81 E3 FF 07 00 00 41 C1 E3 04 41 81 E2 0F 80 FF FF 4C 89 4C 24 40 45 0B D3 66 44 89 54 24 46 83 E6 01 F2 0F 10 7C 24 40 44 8B DE F2 0F 59 C7 0F 28 E8 F2 0F 10 15 ?? ?? ?? ?? F2 0F 58 E8 F2 44 0F 10 0D ?? ?? ?? ?? 75 03 0F 28 E8 F2 44 0F 59 CD F2 0F 58 C2 F2 0F 11 44 24 48 45 0F 28 C1 44 8B 54 24 48 44 2B C6 41 C1 E3 08 41 81 E2 FF 01 00 00 45 03 D3 F2 44 0F 5C C5 4C 8D 1D ?? ?? ?? ?? F2 44 0F 11 44 24 20 44 0F 28 C5 F2 0F 10 5C 24 20 F2 0F 10 3D ?? ?? ?? ?? F2 44 0F 5C CB F2 43 0F 10 04 D3 41 0F 28 C9 0F 28 E0 F2 45 0F 5C C1 F2 0F 59 E0 F2 44 0F 59 C8 F2 0F 59 CC F2 41 0F 59 E0 F2 0F 5C 0D ?? ?? ?? ?? 41 D1 E8 F2 0F 58 CC F2 0F 59 F9 41 81 C0 FF 03 00 00 4C 89 4C 24 50 41 81 E0 FF 07 00 00 49 C1 E9 30 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F9 41 81 E1 0F 80 FF FF 41 C1 E0 04 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F9 45 0B C8 66 44 89 4C 24 56 F2 0F 10 5C 24 50 F2 44 0F 59 CB F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F9 F2 44 0F 10 35 ?? ?? ?? ?? F2 0F 58 3D ?? ?? ?? ?? F2 44 0F 58 35 ?? ?? ?? ?? F2 0F 59 F9 F2 45 0F 59 F3 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F9 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F9 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 F8 F2 41 0F 59 C0 F2 0F 59 FD 44 0F 28 C1 F2 0F 58 F8 F2 45 0F 59 C1 F2 0F 59 FB F2 44 0F 11 44 24 28 F2 44 0F 10 05 ?? ?? ?? ?? F2 45 0F 59 C3 F2 0F 10 54 24 28 F2 0F 10 1D ?? ?? ?? ?? F2 41 0F 5C D1 F2 44 0F 58 05 ?? ?? ?? ?? F2 45 0F 59 C3 F2 0F 11 54 24 20 0F 28 D3 F2 0F 10 6C 24 28 F2 0F 10 64 24 20 F2 0F 10 05 ?? ?? ?? ?? F2 0F 5C EC F2 44 0F 58 05 ?? ?? ?? ?? F2 0F 58 15 ?? ?? ?? ?? F2 45 0F 59 C3 F2 41 0F 58 D6 F2 44 0F 58 05 ?? ?? ?? ?? F2 41 0F 59 D3 F2 45 0F 59 C3 F2 0F 11 6C 24 28 0F 28 E9 F2 44 0F 10 54 24 28 0F 28 E0 F2 41 0F 59 EB F2 44 0F 58 05 ?? ?? ?? ?? F2 45 0F 5C CA F2 0F 58 25 ?? ?? ?? ?? F2 45 0F 59 C3 F2 0F 58 E2 F2 44 0F 58 05 ?? ?? ?? ?? F2 45 0F 59 C3 F2 44 0F 11 4C 24 20 F2 44 0F 10 4C 24 28 F2 44 0F 10 7C 24 20 F2 0F 11 6C 24 28 F2 41 0F 58 FF F2 44 0F 58 05 ?? ?? ?? ?? F2 45 0F 59 C3 F2 44 0F 10 54 24 28 F2 44 0F 58 05 ?? ?? ?? ?? F2 45 0F 5C D3 F2 45 0F 59 C3 F2 44 0F 11 54 24 20 44 0F 28 D1 F2 0F 10 54 24 28 F2 44 0F 10 7C 24 20 F2 44 0F 58 05 ?? ?? ?? ?? F2 41 0F 5C D7 F2 45 0F 59 C3 F2 0F 11 54 24 28 F2 44 0F 10 74 24 28 F2 44 0F 58 05 ?? ?? ?? ?? F2 45 0F 59 C3 F2 44 0F 58 05 ?? ?? ?? ?? F2 45 0F 59 C3 F2 44 0F 58 05 ?? ?? ?? ?? F2 45 0F 59 C3 F2 45 0F 59 C3 F2 45 0F 59 C3 F2 41 0F 58 E0 F2 0F 59 FC 41 0F 28 E3 F2 41 0F 5C E6 F2 0F 11 64 24 20 F2 44 0F 10 74 24 28 41 0F 28 EE 41 0F 28 E6 F2 41 0F 59 EE F2 41 0F 58 E3 F2 44 0F 59 F3 F2 44 0F 59 D5 F2 0F 10 54 24 20 F2 44 0F 11 54 24 28 F2 44 0F 10 7C 24 28 F2 0F 59 E2 F2 44 0F 5C FD F2 0F 59 DA F2 44 0F 11 7C 24 20 F2 44 0F 10 7C 24 28 F2 44 0F 10 54 24 20 F2 0F 10 15 ?? ?? ?? ?? F2 45 0F 5C FA F2 41 0F 59 D3 F2 44 0F 11 7C 24 28 45 0F 28 FE F2 44 0F 10 54 24 28 F2 41 0F 5C EA F2 0F 58 15 ?? ?? ?? ?? F2 0F 11 6C 24 20 F2 44 0F 10 54 24 28 F2 44 0F 59 15 ?? ?? ?? ?? F2 41 0F 59 D3 F2 45 0F 58 FA F2 0F 58 15 ?? ?? ?? ?? F2 0F 10 6C 24 20 F2 41 0F 58 D0 F2 0F 58 EC F2 41 0F 59 D1 F2 0F 59 2D ?? ?? ?? ?? F2 44 0F 11 7C 24 28 F2 44 0F 10 7C 24 28 F2 44 0F 11 54 24 48 F2 45 0F 5C F7 F2 45 0F 58 F2 F2 44 0F 11 74 24 20 44 0F 28 F0 F2 44 0F 10 7C 24 28 F2 44 0F 10 54 24 20 F2 45 0F 58 F7 F2 44 0F 11 74 24 28 F2 44 0F 10 74 24 28 F2 41 0F 5C C6 F2 41 0F 58 C7 F2 0F 11 44 24 20 F2 44 0F 10 74 24 28 F2 41 0F 59 CE F2 44 0F 10 7C 24 20 F2 0F 11 4C 24 28 F2 0F 10 4C 24 28 F2 41 0F 5C CE F2 0F 11 4C 24 20 F2 0F 10 4C 24 28 F2 0F 10 44 24 20 F2 0F 5C C8 F2 0F 11 4C 24 28 F2 0F 10 44 24 28 F2 44 0F 5C F0 F2 44 0F 11 74 24 20 F2 0F 10 44 24 28 F2 44 0F 10 74 24 20 F2 45 0F 58 F2 F2 45 0F 58 F7 F2 44 0F 58 F3 F2 44 0F 58 F5 F2 45 0F 59 F1 F2 44 0F 59 C8 F2 41 0F 58 FE F2 0F 10 05 ?? ?? ?? ?? F2 0F 58 FA 44 0F 28 D8 F2 0F 10 15 ?? ?? ?? ?? F2 45 0F 5C D9 F2 0F 5C D7 F2 44 0F 11 5C 24 28 F2 44 0F 10 5C 24 28 F2 41 0F 5C C3 F2 41 0F 5C C1 F2 0F 11 44 24 20 F2 0F 10 5C 24 28 F2 0F 10 4C 24 20 8A 49 07 F2 0F 58 D1 80 E1 80 F2 0F 58 DA F2 0F 11 5C 24 30 40 8A 74 24 37 40 80 E6 7F 40 0A F1 40 88 74 24 37 48 8B 4C 24 30 48 89 0A EB 11 B8 01 00 00 00 F2 0F 5C C0 F2 0F 5E C0 F2 0F 11 02 0F 28 BC 24 C0 00 00 00 44 0F 28 84 24 90 00 00 00 44 0F 28 8C 24 80 00 00 00 44 0F 28 54 24 70 44 0F 28 5C 24 60 44 0F 28 B4 24 B0 00 00 00 44 0F 28 BC 24 A0 00 00 00 48 81 C4 D0 00 00 00 5E C3 F2 0F 5E C0 F2 0F 11 02 F7 41 04 FF FF 0F 00 75 AE BA 01 00 00 00 33 C0 83 39 00 0F 44 C2 EB 9F }
	condition:
		$1
}

rule file_229_0_0 {
	meta:
		name = "__avx_asinf8"
		size = 544
		refs = "0036 __common_sasin_data 0214 __common_sasin_cout_rare"
	strings:
		$1 = { 48 81 EC 18 02 00 00 C5 7C 11 BC 24 F0 01 00 00 C5 7C 11 84 24 D0 01 00 00 C5 FC 11 B4 24 B0 01 00 00 4C 89 AC 24 10 02 00 00 4C 8D AC 24 4F 01 00 00 C5 FC 10 15 ?? ?? ?? ?? 49 83 E5 C0 C5 FC 10 25 ?? ?? ?? ?? C5 EC 54 C8 C5 F4 59 DC C5 F4 59 E9 C5 74 C2 3D ?? ?? ?? ?? 1D C5 5C 5C C3 C5 F4 C2 E4 15 C4 C1 54 5D D8 C5 EC 55 D0 C4 63 7D 19 FD 01 C5 81 6B F5 C5 D1 EF ED C5 49 63 FD C4 C1 7C 52 F0 C4 41 3C 58 C0 C4 C1 79 D7 D7 C5 CC 59 EE C5 BC 59 F6 C5 3C 59 C5 C5 3C 5C 05 ?? ?? ?? ?? C5 3C 59 3D ?? ?? ?? ?? C5 84 58 2D ?? ?? ?? ?? C4 41 4C 59 F8 C4 41 54 59 C7 C5 E4 59 2D ?? ?? ?? ?? C5 3C 5C C6 C5 D4 58 2D ?? ?? ?? ?? C5 E4 59 35 ?? ?? ?? ?? C5 4C 58 3D ?? ?? ?? ?? C5 E4 59 F3 C5 04 59 FE C5 84 58 ED C5 D4 59 F3 C4 C3 75 4A E8 40 C5 4C 58 3D ?? ?? ?? ?? C5 84 59 DB C5 E4 59 CD C5 F4 58 CD C5 DC 54 1D ?? ?? ?? ?? C5 F4 58 E3 C5 DC 57 CA 84 D2 75 2F C5 FC 10 B4 24 B0 01 00 00 C5 7C 10 84 24 D0 01 00 00 C5 7C 10 BC 24 F0 01 00 00 4C 8B AC 24 10 02 00 00 C5 FC 28 C1 48 81 C4 18 02 00 00 C3 C4 C1 7C 11 45 00 C4 C1 7C 11 4D 40 85 D2 74 C1 33 C0 C5 FC 11 BC 24 E0 00 00 00 C5 7C 11 8C 24 C0 00 00 00 C5 7C 11 94 24 A0 00 00 00 C5 7C 11 9C 24 80 00 00 00 C5 7C 11 64 24 60 C5 7C 11 6C 24 40 C5 7C 11 74 24 20 48 89 9C 24 08 01 00 00 8B D8 48 89 B4 24 00 01 00 00 8B F2 0F A3 DE 72 58 FF C3 83 FB 20 7C F4 C5 FC 10 BC 24 E0 00 00 00 C5 7C 10 8C 24 C0 00 00 00 C5 7C 10 94 24 A0 00 00 00 C5 7C 10 9C 24 80 00 00 00 C5 7C 10 64 24 60 C5 7C 10 6C 24 40 C5 7C 10 74 24 20 C4 C1 7C 10 4D 40 48 8B 9C 24 08 01 00 00 48 8B B4 24 00 01 00 00 E9 18 FF FF FF C5 F8 77 49 8D 4C 9D 00 49 8D 54 9D 40 E8 ?? ?? ?? ?? EB 94 66 0F 1F 44 00 00 }
	condition:
		$1
}

rule file_230_0_0 {
	meta:
		name = "__sse4_exp2"
		size = 720
		refs = "0012 s_dwInvLn 001a s_dwNegRS 002b s_dwLnHi 0033 s_dwBias 0062 s_dwLnLo 0076 s_dwExp2 0094 s_dwA4 00b3 s_dwA5 00d6 s_dwA3 00de s_dwA2 00f6 s_dwOne 01a2 iAbsMask 01ae dbB1 01c7 dbB2 024a dbInf"
	strings:
		$1 = { 48 83 EC 48 0F 29 7C 24 20 0F 29 74 24 30 66 0F 28 1D ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 59 D8 66 0F C5 C8 03 66 0F 28 25 ?? ?? ?? ?? 66 0F 28 0D ?? ?? ?? ?? 66 0F 58 D3 66 0F 3A 09 DB 00 66 0F 28 E8 66 0F 7E D0 81 E1 FF 7F 00 00 66 0F 59 E3 66 0F C5 D2 04 81 F9 86 40 00 00 66 0F 59 1D ?? ?? ?? ?? 66 0F FE CA 66 0F C5 C8 07 66 0F 5C C4 4C 8D 05 ?? ?? ?? ?? 0F 8D A0 00 00 00 81 E1 FF 7F 00 00 83 E0 3F 83 E2 3F 66 0F 5C C3 66 0F 28 1D ?? ?? ?? ?? 66 0F 73 D1 06 F3 41 0F 7E 24 C0 81 F9 86 40 00 00 0F 8D 91 00 00 00 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 E8 66 0F 59 C0 66 0F 73 F1 34 66 41 0F 16 24 D0 66 0F 59 D0 66 0F 59 D8 66 0F 58 15 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 D0 66 0F 59 C3 66 0F 59 D5 66 0F 58 C5 66 0F 58 15 ?? ?? ?? ?? 66 0F EB CC 66 0F 58 C2 66 0F 59 C1 0F 28 74 24 30 0F 28 7C 24 20 48 83 C4 48 C3 66 66 66 0F 1F 84 00 00 00 00 00 83 E0 3F 83 E2 3F 66 0F 5C C3 66 0F 28 1D ?? ?? ?? ?? 66 0F 73 D1 06 F3 41 0F 7E 24 C0 0F 1F 00 4C 8D 05 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 F8 66 0F 59 C0 66 0F 73 F1 34 66 41 0F 16 24 D0 66 0F 59 F0 66 0F 59 D8 66 0F 58 35 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 F0 66 0F 59 C3 66 0F 59 F7 66 0F 58 C7 66 0F 58 35 ?? ?? ?? ?? 66 0F EB CC 66 0F 58 C6 66 0F 59 C8 66 0F 28 1D ?? ?? ?? ?? 66 0F DB DD 66 0F C2 1D ?? ?? ?? ?? 01 66 0F DB CB 66 0F 28 35 ?? ?? ?? ?? 66 0F DB F5 66 0F C2 35 ?? ?? ?? ?? 01 66 0F DF DE 66 0F DB C3 66 0F DB D3 66 0F DB E3 66 0F C5 C5 03 66 0F C5 D5 07 C1 E8 0F C1 EA 0F 66 0F FE 15 ?? ?? ?? ?? 66 0F 73 D2 06 F3 41 0F 7E BC C0 00 02 00 00 66 41 0F 16 BC D0 00 02 00 00 66 0F FE D7 66 0F 73 F2 34 66 0F EB D4 66 0F 59 C2 F3 41 0F 7E BC C0 10 02 00 00 66 41 0F 16 BC D0 10 02 00 00 66 0F 59 C7 66 0F EB C1 66 0F 28 3D ?? ?? ?? ?? 66 0F DB FD 66 0F C2 3D ?? ?? ?? ?? 01 66 0F DF F7 F3 41 0F 7E 8C C0 20 02 00 00 66 41 0F 16 8C D0 20 02 00 00 66 0F DB CE 66 0F 28 35 ?? ?? ?? ?? 66 0F DB F5 66 0F C2 35 ?? ?? ?? ?? 00 F3 41 0F 7E BC C0 30 02 00 00 66 41 0F 16 BC D0 30 02 00 00 66 0F DB F7 66 0F EB CE 66 0F 28 35 ?? ?? ?? ?? 66 0F C2 F5 03 66 0F DB EE 66 0F EB CD 66 0F 59 C9 66 0F EB C1 0F 28 74 24 30 0F 28 7C 24 20 48 83 C4 48 C3 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_231_0_0 {
	meta:
		name = "__sse2_expf4"
		size = 640
		refs = "0003 s_dwExp2_Table 000a s_dwInvLn 0011 s_dwNegRS 001b s_dwLnHi 0022 s_dwBias 0030 flAbsMask 003c flBound1 0060 s_dwLnLo 00ab flTwo 0172 flBound2 01ff flInf 0263 flOne"
	strings:
		$1 = { 4C 8D 05 ?? ?? ?? ?? 0F 28 15 ?? ?? ?? ?? 0F 28 1D ?? ?? ?? ?? 0F 59 D0 0F 28 25 ?? ?? ?? ?? 0F 28 0D ?? ?? ?? ?? 0F 5C 15 ?? ?? ?? ?? 0F 28 2D ?? ?? ?? ?? 66 0F DB E8 66 0F 66 2D ?? ?? ?? ?? 0F 50 CD 23 C9 0F 85 85 00 00 00 0F 28 E8 0F 58 DA 66 0F 7E D0 0F 59 E3 66 0F C5 D2 02 0F 59 1D ?? ?? ?? ?? 83 E0 3F 83 E2 3F 66 0F FE CA 0F 5C C4 F3 41 0F 7E 24 C0 66 0F C5 C2 04 41 0F 16 24 D0 66 0F C5 D2 06 0F 5C C3 83 E0 3F 83 E2 3F 66 0F 72 D1 06 F3 41 0F 7E 14 C0 41 0F 16 14 D0 0F 28 D8 0F 58 C0 0F 59 DB 0F 58 05 ?? ?? ?? ?? 0F C6 E2 88 66 0F 72 F1 17 0F 58 C3 66 0F EB CC 0F 59 C1 C3 66 66 66 66 66 0F 1F 84 00 00 00 00 00 0F 28 E8 0F 58 DA 66 0F 7E D1 0F 59 E3 66 44 0F C5 CA 02 0F 59 1D ?? ?? ?? ?? 83 E1 3F 41 83 E1 3F 66 0F FE CA 0F 5C C4 F3 41 0F 7E 24 C8 66 44 0F C5 D2 04 43 0F 16 24 C8 66 44 0F C5 DA 06 0F 5C C3 41 83 E2 3F 41 83 E3 3F 66 0F 72 D1 06 F3 43 0F 7E 1C D0 43 0F 16 1C D8 0F C6 E3 88 0F 28 D8 0F 58 C0 0F 59 DB 0F 58 05 ?? ?? ?? ?? 66 0F 72 F1 17 0F 58 C3 66 0F EB CC 0F 59 C8 0F 28 1D ?? ?? ?? ?? 66 0F DB DD 0F C2 1D ?? ?? ?? ?? 01 66 0F DB CB 0F 28 15 ?? ?? ?? ?? 66 0F DB D5 0F C2 15 ?? ?? ?? ?? 01 66 0F DF DA 66 0F DB C3 0F 50 D5 B8 03 00 00 00 23 C2 83 E2 0C 03 C0 0F 28 15 ?? ?? ?? ?? 0F 59 D5 0F 5C 15 ?? ?? ?? ?? 66 0F DB D3 66 0F DB E3 66 0F FE 15 ?? ?? ?? ?? 66 0F 72 D2 06 41 0F 28 9C C0 40 02 00 00 41 0F C6 9C 90 40 02 00 00 88 66 0F FE D3 66 0F 72 F2 17 66 0F EB D4 0F 59 C2 41 0F 28 9C C0 00 02 00 00 41 0F C6 9C 90 00 02 00 00 88 0F 59 C3 66 0F EB C1 0F 28 1D ?? ?? ?? ?? 66 0F DB DD 0F C2 1D ?? ?? ?? ?? 01 0F 28 15 ?? ?? ?? ?? 66 0F DB D5 0F C2 15 ?? ?? ?? ?? 01 66 0F DF D3 41 0F 28 8C C0 80 02 00 00 41 0F C6 8C 90 80 02 00 00 88 66 0F DB CA 0F 28 15 ?? ?? ?? ?? 66 0F DB D5 0F C2 15 ?? ?? ?? ?? 00 41 0F 28 9C C0 C0 02 00 00 41 0F C6 9C 90 C0 02 00 00 88 66 0F DB D3 66 0F EB CA 0F 28 15 ?? ?? ?? ?? 0F C2 D5 03 66 0F DB EA 66 0F EB CD 0F 59 C9 66 0F EB C1 C3 0F 1F 44 00 00 }
	condition:
		$1
}

rule file_234_0_0 {
	meta:
		name = "__sse2_exp2"
		size = 752
		refs = "0012 s_dwInvLn 001a s_dwNegRS 0026 s_dwLnHi 002e s_dwBias 0064 s_dwLnLo 0078 s_dwExp2 0096 s_dwA4 00b5 s_dwA5 00d8 s_dwA3 00e0 s_dwA2 00f8 s_dwOne 01c2 iAbsMask 01ce dbB1 01e7 dbB2 026a dbInf"
	strings:
		$1 = { 48 83 EC 68 0F 29 7C 24 40 0F 29 74 24 50 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F 59 D0 66 0F 28 25 ?? ?? ?? ?? 66 0F 28 0D ?? ?? ?? ?? 66 0F 5C 15 ?? ?? ?? ?? 66 0F C5 C8 03 66 0F 28 E8 66 0F 58 DA 66 0F 7E D0 81 E1 FF 7F 00 00 66 0F 59 E3 66 0F C5 D2 04 81 F9 86 40 00 00 66 0F 59 1D ?? ?? ?? ?? 66 0F FE CA 66 0F C5 C8 07 66 0F 5C C4 4C 8D 05 ?? ?? ?? ?? 0F 8D 9E 00 00 00 81 E1 FF 7F 00 00 83 E0 3F 83 E2 3F 66 0F 5C C3 66 0F 28 1D ?? ?? ?? ?? 66 0F 73 D1 06 F3 41 0F 7E 24 C0 81 F9 86 40 00 00 0F 8D 8F 00 00 00 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 E8 66 0F 59 C0 66 0F 73 F1 34 66 41 0F 16 24 D0 66 0F 59 D0 66 0F 59 D8 66 0F 58 15 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 D0 66 0F 59 C3 66 0F 59 D5 66 0F 58 C5 66 0F 58 15 ?? ?? ?? ?? 66 0F EB CC 66 0F 58 C2 66 0F 59 C1 0F 28 74 24 50 0F 28 7C 24 40 48 83 C4 68 C3 66 0F 1F 84 00 00 00 00 00 83 E0 3F 83 E2 3F 66 0F 5C C3 66 0F 28 1D ?? ?? ?? ?? 66 0F 73 D1 06 F3 41 0F 7E 24 C0 0F 1F 00 89 44 24 20 89 54 24 24 8B 44 24 20 8B 54 24 24 89 44 24 28 89 54 24 30 8B 44 24 28 8B 54 24 30 4C 8D 05 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 F8 66 0F 59 C0 66 0F 73 F1 34 66 41 0F 16 24 D0 66 0F 59 F0 66 0F 59 D8 66 0F 58 35 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 F0 66 0F 59 C3 66 0F 59 F7 66 0F 58 C7 66 0F 58 35 ?? ?? ?? ?? 66 0F EB CC 66 0F 58 C6 66 0F 59 C8 66 0F 28 1D ?? ?? ?? ?? 66 0F DB DD 66 0F C2 1D ?? ?? ?? ?? 01 66 0F DB CB 66 0F 28 35 ?? ?? ?? ?? 66 0F DB F5 66 0F C2 35 ?? ?? ?? ?? 01 66 0F DF DE 66 0F DB C3 66 0F DB D3 66 0F DB E3 66 0F C5 C5 03 66 0F C5 D5 07 C1 E8 0F C1 EA 0F 66 0F FE 15 ?? ?? ?? ?? 66 0F 73 D2 06 F3 41 0F 7E BC C0 00 02 00 00 66 41 0F 16 BC D0 00 02 00 00 66 0F FE D7 66 0F 73 F2 34 66 0F EB D4 66 0F 59 C2 F3 41 0F 7E BC C0 10 02 00 00 66 41 0F 16 BC D0 10 02 00 00 66 0F 59 C7 66 0F EB C1 66 0F 28 3D ?? ?? ?? ?? 66 0F DB FD 66 0F C2 3D ?? ?? ?? ?? 01 66 0F DF F7 F3 41 0F 7E 8C C0 20 02 00 00 66 41 0F 16 8C D0 20 02 00 00 66 0F DB CE 66 0F 28 35 ?? ?? ?? ?? 66 0F DB F5 66 0F C2 35 ?? ?? ?? ?? 00 F3 41 0F 7E BC C0 30 02 00 00 66 41 0F 16 BC D0 30 02 00 00 66 0F DB F7 66 0F EB CE 66 0F 28 35 ?? ?? ?? ?? 66 0F C2 F5 03 66 0F DB EE 66 0F EB CD 66 0F 59 C9 66 0F EB C1 0F 28 74 24 50 0F 28 7C 24 40 48 83 C4 68 C3 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_242_0_0 {
	meta:
		name = "?GetPdbDll@@YAPEAUHINSTANCE__@@XZ"
		size = 325
		refs = "000a __security_cookie 001b ?alreadyTried@?1??GetPdbDll@@YAPEAUHINSTANCE__@@XZ@4_NA 002e ?GetPdbDllFromInstallPath@@YAPEAUHINSTANCE__@@XZ 003e ?debugCrtFileName@@3QB_WB 0043 __vcrt_GetModuleHandleW 005e __vcrt_GetModuleFileNameW 007a ?GetPdbDllPathFromFilePath@@YAHPEB_WPEA_W_K@Z 0090 __vcrt_LoadLibraryExW 009f __imp_GetLastError 00c2 ??_C@_1BC@JINFINNJ@?$AAM?$AAS?$AAP?$AAD?$AAB?$AA1?$AA4?$AA0?$AA?$AA@ 0139 __security_check_cookie"
	strings:
		$1 = { 48 81 EC 58 04 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 40 04 00 00 80 3D ?? ?? ?? ?? 00 0F 85 05 01 00 00 C6 05 ?? ?? ?? ?? 01 E8 ?? ?? ?? ?? 48 85 C0 0F 85 F2 00 00 00 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 85 C0 74 71 41 B8 04 01 00 00 48 8D 94 24 30 02 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 74 57 41 B8 04 01 00 00 48 8D 54 24 20 48 8D 8C 24 30 02 00 00 E8 ?? ?? ?? ?? 85 C0 74 3B 33 D2 48 8D 4C 24 20 41 B8 00 09 00 00 E8 ?? ?? ?? ?? 48 85 C0 0F 85 90 00 00 00 FF 15 ?? ?? ?? ?? 83 F8 57 75 15 33 D2 44 8D 40 B1 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 85 C0 75 70 33 D2 48 8D 0D ?? ?? ?? ?? 41 B8 00 0A 00 00 E8 ?? ?? ?? ?? 48 85 C0 75 57 FF 15 ?? ?? ?? ?? 83 F8 57 75 4A 41 B8 04 01 00 00 48 8D 94 24 30 02 00 00 33 C9 E8 ?? ?? ?? ?? 85 C0 74 31 41 B8 04 01 00 00 48 8D 54 24 20 48 8D 8C 24 30 02 00 00 E8 ?? ?? ?? ?? 85 C0 74 15 33 D2 48 8D 4C 24 20 44 8D 42 08 E8 ?? ?? ?? ?? 48 85 C0 75 02 33 C0 48 8B 8C 24 40 04 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 58 04 00 00 C3 }
	condition:
		$1
}

rule file_242_1_0 {
	meta:
		name = "?GetPdbDllFromInstallPath@@YAPEAUHINSTANCE__@@XZ"
		size = 651
		refs = "000c __security_cookie 0020 ??_C@_1EI@MLPKHBGE@?$AAa?$AAp?$AAi?$AA?9?$AAm?$AAs?$AA?9?$AAw?$AAi?$AAn?$AA?9?$AAc?$AAo?$AAr?$AAe?$AA?9?$AAr?$AAe?$AAg?$AAi?$AAs?$AAt?$AAr?$AAy?$AA?9?$AAl?$AA1?$AA?9?$AA1?$AA?9?$AA0?$AA?4@ 002b __vcrt_LoadLibraryExW 003c ??_C@_1BK@JHLNAEJL@?$AAa?$AAd?$AAv?$AAa?$AAp?$AAi?$AA3?$AA2?$AA?4?$AAd?$AAl?$AAl?$AA?$AA@ 0055 __imp_GetLastError 0081 ??_C@_0O@COHOBMLB@RegOpenKeyExW?$AA@ 0092 __imp_GetProcAddress 00a5 ??_C@_0BB@GLNAEDBD@RegQueryValueExW?$AA@ 00c9 ??_C@_0M@HLOHPNFA@RegCloseKey?$AA@ 00ea _guard_check_icall 0104 ??_C@_1HE@EBEAGLFB@?$AAS?$AAO?$AAF?$AAT?$AAW?$AAA?$AAR?$AAE?$AA?2?$AAW?$AAo?$AAw?$AA6?$AA4?$AA3?$AA2?$AAN?$AAo?$AAd?$AAe?$AA?2?$AAM?$AAi?$AAc?$AAr?$AAo?$AAs?$AAo?$AAf?$AAt?$AA?2?$AAV@ 011a __imp_FreeLibrary 0154 ??_C@_1BG@EABPBLLF@?$AAP?$AAr?$AAo?$AAd?$AAu?$AAc?$AAt?$AAD?$AAi?$AAr?$AA?$AA@ 01e6 ?mspdbName@@3QB_WB 027e __security_check_cookie"
	strings:
		$1 = { 40 57 48 81 EC 60 02 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 50 02 00 00 33 D2 48 8D 0D ?? ?? ?? ?? 41 B8 00 08 00 00 E8 ?? ?? ?? ?? 48 8B F8 48 85 C0 75 47 33 D2 48 8D 0D ?? ?? ?? ?? 41 B8 00 08 00 00 E8 ?? ?? ?? ?? 48 8B F8 48 85 C0 75 2B FF 15 ?? ?? ?? ?? 83 F8 57 75 19 45 33 C0 48 8D 0D ?? ?? ?? ?? 33 D2 E8 ?? ?? ?? ?? 48 8B F8 48 85 C0 75 07 33 C0 E9 F4 01 00 00 48 8D 15 ?? ?? ?? ?? 48 89 9C 24 70 02 00 00 48 8B CF FF 15 ?? ?? ?? ?? 48 8B D8 48 85 C0 0F 84 C8 01 00 00 48 8D 15 ?? ?? ?? ?? 48 89 B4 24 80 02 00 00 48 8B CF FF 15 ?? ?? ?? ?? 48 8B F0 48 85 C0 0F 84 9C 01 00 00 48 8D 15 ?? ?? ?? ?? 48 89 AC 24 78 02 00 00 48 8B CF FF 15 ?? ?? ?? ?? 48 8B E8 48 85 C0 74 38 48 8B CB E8 ?? ?? ?? ?? 48 8D 44 24 38 41 B9 01 00 00 00 45 33 C0 48 89 44 24 20 48 8D 15 ?? ?? ?? ?? 48 C7 C1 02 00 00 80 FF D3 85 C0 74 10 48 8B CF FF 15 ?? ?? ?? ?? 33 C0 E9 35 01 00 00 48 8B CE C7 44 24 30 08 02 00 00 E8 ?? ?? ?? ?? 48 8B 4C 24 38 48 8D 44 24 30 48 89 44 24 28 4C 8D 4C 24 34 48 8D 44 24 40 45 33 C0 48 8D 15 ?? ?? ?? ?? 48 89 44 24 20 FF D6 48 8B CD 8B D8 E8 ?? ?? ?? ?? 48 8B 4C 24 38 FF D5 48 8B CF FF 15 ?? ?? ?? ?? 85 DB 75 A1 83 7C 24 34 01 75 9A 8B 54 24 30 F6 C2 01 75 91 D1 EA 44 8B CA 83 FA 02 72 87 FF CA 4C 8D 44 24 40 66 41 39 1C 50 4D 8D 04 50 0F 85 71 FF FF FF 8D 42 FF 66 83 7C 44 40 5C 74 0C B8 5C 00 00 00 41 8B D1 66 41 89 00 8B C2 F7 D0 83 F8 18 0F 82 4D FF FF FF 8B CA 48 8D 41 17 48 3D 04 01 00 00 0F 87 3B FF FF FF 0F 10 05 ?? ?? ?? ?? 8B 05 ?? ?? ?? ?? 33 D2 0F 10 0D ?? ?? ?? ?? 41 B8 00 09 00 00 0F 11 44 4C 40 F2 0F 10 05 ?? ?? ?? ?? 0F 11 4C 4C 50 F2 0F 11 44 4C 60 89 44 4C 68 0F B7 05 ?? ?? ?? ?? 66 89 44 4C 6C 48 8D 4C 24 40 E8 ?? ?? ?? ?? 48 8B D8 48 85 C0 75 1E FF 15 ?? ?? ?? ?? 83 F8 57 75 13 33 D2 44 8D 43 08 48 8D 4C 24 40 E8 ?? ?? ?? ?? 48 8B D8 48 8B C3 48 8B AC 24 78 02 00 00 48 8B B4 24 80 02 00 00 48 8B 9C 24 70 02 00 00 48 8B 8C 24 50 02 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 60 02 00 00 5F C3 }
	condition:
		$1
}

rule file_242_2_0 {
	meta:
		name = "?GetPdbDllPathFromFilePath@@YAHPEB_WPEA_W_K@Z"
		size = 261
		refs = "0010 __security_cookie 006b _wsplitpath_s 007a ?mspdbFilename@?1??GetPdbDllPathFromFilePath@@YAHPEB_WPEA_W_K@Z@4QB_WB 008c wcscpy_s 0097 ?dllExt@?1??GetPdbDllPathFromFilePath@@YAHPEB_WPEA_W_K@Z@4QB_WB 00d7 _wmakepath_s 00f0 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 20 57 48 81 EC 70 06 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 60 06 00 00 48 C7 44 24 40 00 01 00 00 48 8D 44 24 60 48 89 44 24 38 4C 8D 8C 24 60 04 00 00 48 8D 84 24 60 02 00 00 48 C7 44 24 30 00 01 00 00 49 8B F8 48 89 44 24 28 48 8B DA 48 C7 44 24 20 00 01 00 00 41 B8 03 00 00 00 48 8D 54 24 50 E8 ?? ?? ?? ?? 85 C0 74 04 33 C0 EB 6D 4C 8D 05 ?? ?? ?? ?? BA 09 00 00 00 48 8D 8C 24 60 02 00 00 E8 ?? ?? ?? ?? 85 C0 75 DF 4C 8D 05 ?? ?? ?? ?? 8D 50 04 48 8D 4C 24 60 E8 ?? ?? ?? ?? 85 C0 75 C7 48 8D 44 24 60 48 8B D7 48 89 44 24 28 4C 8D 8C 24 60 04 00 00 48 8D 84 24 60 02 00 00 48 8B CB 4C 8D 44 24 50 48 89 44 24 20 E8 ?? ?? ?? ?? 33 C9 85 C0 0F 94 C1 8B C1 48 8B 8C 24 60 06 00 00 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 98 06 00 00 48 81 C4 70 06 00 00 5F C3 }
	condition:
		$1
}

rule file_242_3_0 {
	meta:
		name = "?_RTC_GetSrcLine@@YAHPEAEPEA_WKPEAH1K@Z"
		size = 1137
		refs = "003a __imp_VirtualQuery 0069 __vcrt_GetModuleFileNameW 0102 ?PDBOK@?1??_RTC_GetSrcLine@@YAHPEAEPEA_WKPEAH1K@Z@4_NA 010b ?mspdb@@3PEAUHINSTANCE__@@EA 0112 ?GetPdbDll@@YAPEAUHINSTANCE__@@XZ 0135 ??_C@_0BB@KCIACLNC@PDBOpenValidate5?$AA@ 013e __imp_GetProcAddress 014e _guard_check_icall 01c4 ??_C@_01KDCPPGHE@r?$AA@ 02fc __imp_GetProcessHeap 030a __imp_HeapAlloc 03da __imp_HeapFree"
	strings:
		$1 = { 44 89 44 24 18 48 89 54 24 10 55 53 41 55 41 57 48 8D 6C 24 D1 48 81 EC D8 00 00 00 45 33 FF 48 8D 59 FF 45 89 39 48 8B CB 66 44 89 3A 4D 8B E9 48 8D 55 CF 45 8D 47 30 FF 15 ?? ?? ?? ?? 48 85 C0 75 0E 48 81 C4 D8 00 00 00 41 5F 41 5D 5B 5D C3 44 8B 45 7F 48 8B 4D D7 48 89 BC 24 C8 00 00 00 48 8B 7D 77 48 8B D7 E8 ?? ?? ?? ?? 85 C0 74 25 4C 8B 45 D7 B8 4D 5A 00 00 66 41 39 00 75 16 49 63 40 3C 85 C0 7E 0E 41 81 3C 00 50 45 00 00 49 8D 0C 00 74 07 33 C0 E9 BE 03 00 00 44 0F B7 49 14 41 2B D8 0F B7 51 06 4C 03 C9 48 89 B4 24 D0 00 00 00 41 8B F7 4C 89 B4 24 B8 00 00 00 45 8B F7 85 D2 74 2D 66 66 0F 1F 84 00 00 00 00 00 41 8B C6 48 8D 0C 80 41 8B 44 C9 24 3B D8 72 0B 8B F3 2B F0 41 3B 5C C9 20 72 08 41 FF C6 44 3B F2 72 DD 44 3B F2 0F 84 83 00 00 00 41 FF C6 44 38 3D ?? ?? ?? ?? 75 23 4C 39 3D ?? ?? ?? ?? 75 6E E8 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 85 C0 74 5D C6 05 ?? ?? ?? ?? 01 EB 07 48 8B 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B C8 FF 15 ?? ?? ?? ?? 48 8B D8 48 85 C0 74 35 48 8B C8 E8 ?? ?? ?? ?? 48 8D 45 B7 45 33 C9 48 89 44 24 38 45 33 C0 4C 89 7C 24 30 48 8D 45 C7 4C 89 7C 24 28 33 D2 48 8B CF 48 89 44 24 20 FF D3 85 C0 75 07 33 C0 E9 C5 02 00 00 48 8B 7D B7 48 8B 07 48 8B 18 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 3D 41 91 32 01 0F 85 88 02 00 00 48 8B 7D B7 48 8B 07 48 8B 58 38 48 8B CB E8 ?? ?? ?? ?? 4C 8D 4D BF 33 D2 4C 8D 05 ?? ?? ?? ?? 48 8B CF FF D3 85 C0 0F 84 5B 02 00 00 48 8B 7D BF 48 8B 07 48 8B 58 40 48 8B CB E8 ?? ?? ?? ?? 4C 89 7C 24 30 4C 8D 4D AF 4C 89 7C 24 28 44 8B C6 41 0F B7 D6 4C 89 7C 24 20 48 8B CF FF D3 85 C0 0F 84 09 02 00 00 48 8B 7D AF 4C 89 7D 97 48 8B 07 48 8B 98 D0 00 00 00 48 8B CB E8 ?? ?? ?? ?? 48 8D 55 97 48 8B CF FF D3 84 C0 0F 84 C3 01 00 00 48 8B 7D 97 48 85 FF 0F 84 B6 01 00 00 48 8B 07 4C 89 A4 24 C0 00 00 00 4D 8B E7 48 8B 58 10 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 85 C0 0F 84 5C 01 00 00 66 90 48 8B 7D 97 48 8B 07 48 8B 58 18 48 8B CB E8 ?? ?? ?? ?? 48 8D 45 6F 4C 89 7C 24 30 48 89 44 24 28 4C 8D 4D 57 48 8D 45 A3 33 D2 4C 8D 45 9F 48 89 44 24 20 48 8B CF FF D3 84 C0 0F 84 2D 01 00 00 0F B7 45 57 41 3B C6 75 0E 8B 4D 9F 3B CE 77 07 03 4D A3 3B F1 72 21 48 8B 7D 97 48 8B 07 48 8B 58 10 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 85 C0 75 8C E9 E1 00 00 00 8B 45 6F 85 C0 0F 84 EA 00 00 00 8B D8 48 C1 E3 03 FF 15 ?? ?? ?? ?? 4C 8B C3 33 D2 48 8B C8 FF 15 ?? ?? ?? ?? 4C 8B E0 48 85 C0 0F 84 C4 00 00 00 48 8B 7D 97 48 8B 17 48 8B 5A 18 48 8B CB E8 ?? ?? ?? ?? 48 8D 45 6F 4C 89 64 24 30 48 89 44 24 28 48 8D 55 A7 45 33 C9 4C 89 7C 24 20 45 33 C0 48 8B CF FF D3 84 C0 74 77 2B 75 9F 41 3B 34 24 72 6E 8B 55 6F 41 BE 01 00 00 00 41 8B CE 3B D1 76 12 0F 1F 40 00 8B C1 41 3B 34 C4 72 06 FF C1 3B CA 72 F2 48 8B 7D AF 8D 41 FF 41 8B 44 C4 04 25 FF FF FF 00 41 89 45 00 48 8B 07 48 8B 98 E0 00 00 00 48 8B CB E8 ?? ?? ?? ?? 4C 8B 45 5F 4C 8D 4D 67 8B 55 A7 48 8B CF 4C 89 7C 24 30 4C 89 7C 24 28 4C 89 7C 24 20 FF D3 84 C0 45 0F 45 FE FF 15 ?? ?? ?? ?? 4D 8B C4 33 D2 48 8B C8 FF 15 ?? ?? ?? ?? 48 8B 7D 97 48 8B 07 48 8B 18 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 4C 8B A4 24 C0 00 00 00 48 8B 7D AF 48 8B 07 48 8B 98 80 00 00 00 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B 7D BF 48 8B 07 48 8B 58 70 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B 7D B7 48 8B 17 48 8B 5A 58 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 41 8B C7 48 8B B4 24 D0 00 00 00 4C 8B B4 24 B8 00 00 00 48 8B BC 24 C8 00 00 00 48 81 C4 D8 00 00 00 41 5F 41 5D 5B 5D C3 }
	condition:
		$1
}

rule file_243_0_0 {
	meta:
		name = "__sse2_tanf4"
		size = 2576
		refs = "001a MMSRSHIFT 002a MMSINVPI 0031 MMSPI1 0041 MMSPI2 0049 MMIABSMASK 0051 MMIHUGE 0063 MMSPI3 006a MMSPI4 0084 MMSP1 008e MMSQ2 00b9 MMSP0 00c0 MMSQ1 00cd MMSQ0 0117 MMISIGNMASK 0128 flAllOnes 014a flTwoPow30 01c0 dbInvPio4 01d5 dbiOne 01dd MSK_LOW_BIT 01e5 dbRS 0202 PI04C_0 020e PI04C_1 021e PI04C_2 024f PI04C_3 027b PI04C_4 07e5 __spec_table"
	strings:
		$1 = { 48 81 EC 28 01 00 00 0F 29 BC 24 00 01 00 00 0F 29 B4 24 10 01 00 00 0F 28 2D ?? ?? ?? ?? 0F 28 F8 0F 28 F0 0F 28 D0 0F 59 05 ?? ?? ?? ?? 0F 28 25 ?? ?? ?? ?? 0F 58 C5 0F 28 D8 0F 5C C5 0F 28 2D ?? ?? ?? ?? 66 0F DB 3D ?? ?? ?? ?? 66 0F 66 3D ?? ?? ?? ?? 0F 50 C7 0B C0 0F 85 B4 00 00 00 0F 28 35 ?? ?? ?? ?? 0F 28 3D ?? ?? ?? ?? 0F 59 E0 0F 59 E8 0F 59 F0 0F 59 F8 66 0F 6F C3 0F 5C D4 0F 28 25 ?? ?? ?? ?? 0F 5C D5 0F 28 2D ?? ?? ?? ?? 0F 5C D6 66 0F 72 F3 1E 66 0F EF C9 0F C2 D9 04 0F 28 CA 0F 5C CF 0F 59 D2 66 0F 72 F0 1F 0F 59 E2 0F 59 EA 0F 58 25 ?? ?? ?? ?? 0F 58 2D ?? ?? ?? ?? 0F 59 E1 0F 59 EA 0F 58 2D ?? ?? ?? ?? 0F 28 CB 0F 28 D3 66 0F DB CC 66 0F DF D5 66 0F EB CA 0F 28 F3 0F 28 FB 66 0F DF F4 66 0F DB FD 66 0F EB F7 0F 5E F1 66 0F EF C6 0F 28 B4 24 10 01 00 00 0F 28 BC 24 00 01 00 00 48 81 C4 28 01 00 00 C3 0F 28 0D ?? ?? ?? ?? 0F 29 7C 24 40 66 0F DB CE 66 0F EF 3D ?? ?? ?? ?? 0F 29 54 24 50 66 0F DB 35 ?? ?? ?? ?? 0F 29 7C 24 60 0F 28 FE 0F 29 74 24 70 66 0F 66 35 ?? ?? ?? ?? 66 0F DB 4C 24 40 0F 29 8C 24 80 00 00 00 0F 50 D6 85 D2 0F 85 70 05 00 00 83 F8 0F 0F 84 DA 02 00 00 0F 28 35 ?? ?? ?? ?? 0F 28 3D ?? ?? ?? ?? 0F 59 E0 0F 59 E8 0F 59 F0 0F 59 F8 0F 5C D4 0F 5C D5 0F 5C D6 0F 5C D7 66 0F DB 5C 24 60 66 0F DB 54 24 60 0F 29 9C 24 90 00 00 00 0F 29 94 24 A0 00 00 00 0F 5A 44 24 70 0F 5A 4C 24 78 66 0F 28 1D ?? ?? ?? ?? 66 0F 59 D8 66 0F E6 DB 66 0F 70 DB DC 66 0F FE 1D ?? ?? ?? ?? 66 0F DB 1D ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 56 D3 66 0F 5C 15 ?? ?? ?? ?? 66 0F 29 8C 24 B0 00 00 00 66 0F 28 0D ?? ?? ?? ?? 66 0F 59 CA 66 0F 28 25 ?? ?? ?? ?? 66 0F 59 E2 66 0F 5C C1 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 EA 66 0F 28 C8 66 0F 5C C4 66 0F 5C C8 66 0F 28 F0 66 0F 5C CC 66 0F 5C C5 66 0F 72 E3 01 66 0F 5C F0 66 0F 28 F8 66 0F 28 25 ?? ?? ?? ?? 66 0F 5C F5 66 0F 58 CE 66 0F 58 C1 66 0F 59 E2 66 0F 5C F8 66 0F 28 E8 66 0F 5C C4 66 0F 58 CF 66 0F 5C E8 66 0F 59 15 ?? ?? ?? ?? 66 0F 5C EC 66 0F 58 CD 66 0F 5C CA 66 0F 28 EB 66 0F 28 9C 24 B0 00 00 00 66 0F 59 1D ?? ?? ?? ?? 66 0F E6 DB 66 0F 58 C8 66 0F 28 84 24 B0 00 00 00 66 0F 70 ED 88 66 0F 70 DB DC 66 0F FE 1D ?? ?? ?? ?? 66 0F DB 1D ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 56 D3 66 0F 29 8C 24 C0 00 00 00 66 0F 5C 15 ?? ?? ?? ?? 66 0F 28 0D ?? ?? ?? ?? 66 0F 59 CA 66 0F 28 25 ?? ?? ?? ?? 66 0F 59 E2 66 0F D6 AC 24 D0 00 00 00 66 0F 5C C1 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 EA 66 0F 28 C8 66 0F 5C C4 66 0F 5C C8 66 0F 28 F0 66 0F 5C CC 66 0F 5C C5 66 0F 72 E3 01 66 0F 5C F0 66 0F 28 F8 66 0F 28 25 ?? ?? ?? ?? 66 0F 5C F5 66 0F 58 CE 66 0F 58 C1 66 0F 59 E2 66 0F 5C F8 66 0F 28 E8 66 0F 5C C4 66 0F 58 CF 66 0F 5C E8 66 0F 59 15 ?? ?? ?? ?? 66 0F 5C EC 66 0F 58 CD 66 0F 5C CA 66 0F 28 EB 66 0F 58 C1 66 0F 5A 94 24 C0 00 00 00 66 0F 70 ED 88 66 0F 5A D8 66 0F 14 D3 F3 0F 7E 9C 24 D0 00 00 00 66 0F 14 DD 66 0F DB 5C 24 40 66 0F DB 54 24 40 66 0F EB 9C 24 90 00 00 00 66 0F EB 94 24 A0 00 00 00 0F 28 C3 66 0F 72 F0 1F 66 0F EF 84 24 80 00 00 00 66 0F 72 F3 1E 66 0F EF C9 0F C2 D9 04 0F 28 25 ?? ?? ?? ?? 0F 28 2D ?? ?? ?? ?? 0F 28 CA 0F 59 D2 0F 59 E2 0F 59 EA 0F 58 25 ?? ?? ?? ?? 0F 58 2D ?? ?? ?? ?? 0F 59 E1 0F 59 EA 0F 58 2D ?? ?? ?? ?? 0F 28 CB 0F 28 D3 66 0F DB CC 66 0F DF D5 66 0F EB CA 0F 28 F3 0F 28 FB 66 0F DF F4 66 0F DB FD 66 0F EB F7 0F 5E F1 66 0F EF C6 E9 7B 03 00 00 0F 5A C7 66 0F 70 FF EE 0F 5A FF 66 0F 28 1D ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 59 D8 66 0F 59 F7 66 0F E6 DB 66 0F E6 F6 66 0F 70 DB DC 66 0F 70 F6 DC 66 0F FE 1D ?? ?? ?? ?? 66 0F FE 35 ?? ?? ?? ?? 66 0F DB 1D ?? ?? ?? ?? 66 0F DB 35 ?? ?? ?? ?? 66 0F 29 B4 24 E0 00 00 00 66 0F 28 15 ?? ?? ?? ?? 66 0F 56 D3 66 0F 5C 15 ?? ?? ?? ?? 66 0F 28 0D ?? ?? ?? ?? 66 0F 59 CA 66 0F 28 25 ?? ?? ?? ?? 66 0F 59 E2 66 0F 5C C1 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 EA 66 0F 28 C8 66 0F 5C C4 66 0F 5C C8 66 0F 28 F0 66 0F 5C CC 66 0F 5C C5 66 0F 72 E3 01 66 0F 5C F0 66 0F 29 BC 24 B0 00 00 00 66 0F 28 F8 66 0F 28 25 ?? ?? ?? ?? 66 0F 5C F5 66 0F 58 CE 66 0F 58 C1 66 0F 59 E2 66 0F 5C F8 66 0F 28 E8 66 0F 5C C4 66 0F 58 CF 66 0F 5C E8 66 0F 59 15 ?? ?? ?? ?? 66 0F 5C EC 66 0F 58 CD 66 0F 5C CA 66 0F 28 EB 66 0F 58 C8 66 0F 28 84 24 B0 00 00 00 66 0F 70 ED 88 66 0F 6F 9C 24 E0 00 00 00 66 0F 28 15 ?? ?? ?? ?? 66 0F 56 94 24 E0 00 00 00 66 0F 29 8C 24 C0 00 00 00 66 0F 5C 15 ?? ?? ?? ?? 66 0F 28 0D ?? ?? ?? ?? 66 0F 59 CA 66 0F 28 25 ?? ?? ?? ?? 66 0F 59 E2 66 0F D6 AC 24 D0 00 00 00 66 0F 5C C1 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 EA 66 0F 28 C8 66 0F 5C C4 66 0F 5C C8 66 0F 28 F0 66 0F 5C CC 66 0F 5C C5 66 0F 72 E3 01 66 0F 5C F0 66 0F 28 F8 66 0F 28 25 ?? ?? ?? ?? 66 0F 5C F5 66 0F 58 CE 66 0F 58 C1 66 0F 59 E2 66 0F 5C F8 66 0F 28 E8 66 0F 5C C4 66 0F 58 CF 66 0F 5C E8 66 0F 59 15 ?? ?? ?? ?? 66 0F 5C EC 66 0F 58 CD 66 0F 5C CA 66 0F 28 EB 66 0F 58 C1 66 0F 5A 94 24 C0 00 00 00 66 0F 70 ED 88 66 0F 5A D8 66 0F 14 D3 F3 0F 7E 9C 24 D0 00 00 00 66 0F 14 DD 0F 28 C3 66 0F 72 F0 1F 66 0F EF 84 24 80 00 00 00 66 0F 72 F3 1E 66 0F EF C9 0F C2 D9 04 0F 28 25 ?? ?? ?? ?? 0F 28 2D ?? ?? ?? ?? 0F 28 CA 0F 59 D2 0F 59 E2 0F 59 EA 0F 58 25 ?? ?? ?? ?? 0F 58 2D ?? ?? ?? ?? 0F 59 E1 0F 59 EA 0F 58 2D ?? ?? ?? ?? 0F 28 CB 0F 28 D3 66 0F DB CC 66 0F DF D5 66 0F EB CA 0F 28 F3 0F 28 FB 66 0F DF F4 66 0F DB FD 66 0F EB F7 0F 5E F1 66 0F EF C6 E9 EE 00 00 00 83 F8 0F 0F 84 BB 00 00 00 0F 28 35 ?? ?? ?? ?? 0F 28 3D ?? ?? ?? ?? 0F 59 E0 0F 59 E8 0F 59 F0 0F 59 F8 0F 5C D4 0F 5C D5 0F 5C D6 0F 28 CA 0F 5C CF 66 0F EF FF 0F 59 D2 0F 29 8C 24 F0 00 00 00 0F 28 C3 66 0F 72 F0 1F 66 0F EF C7 66 0F 72 F3 1E 66 0F EF C9 0F C2 D9 04 0F 28 25 ?? ?? ?? ?? 0F 28 2D ?? ?? ?? ?? 0F 28 8C 24 F0 00 00 00 0F 59 E2 0F 59 EA 0F 58 25 ?? ?? ?? ?? 0F 58 2D ?? ?? ?? ?? 0F 59 E1 0F 59 EA 0F 58 2D ?? ?? ?? ?? 0F 28 CB 0F 28 D3 66 0F DB CC 66 0F DF D5 66 0F EB CA 0F 28 F3 0F 28 FB 66 0F DF F4 66 0F DB FD 66 0F EB F7 0F 5E F1 66 0F EF C6 0F 29 84 24 F0 00 00 00 89 44 24 20 8B 44 24 20 85 C0 74 16 45 33 C9 A8 01 75 2F 49 FF C1 D1 F8 89 44 24 20 49 83 F9 04 7C ED 0F 28 84 24 F0 00 00 00 0F 28 B4 24 10 01 00 00 0F 28 BC 24 00 01 00 00 48 81 C4 28 01 00 00 C3 42 8B 44 8C 50 48 8D 15 ?? ?? ?? ?? 89 44 24 28 48 89 54 24 30 F3 0F 10 44 24 28 4C 8B 44 24 30 66 0F 7E C0 25 00 00 80 7F 3D 00 00 80 7F 0F 84 DF 01 00 00 0F C6 C8 00 66 0F 7E C1 0F 5A C9 0F 5A C8 81 E1 FF FF FF 7F 81 E9 00 00 80 39 C1 E9 17 83 E9 1B 81 E1 F8 FF 00 00 F2 41 0F 10 9C 48 00 09 00 00 F2 41 0F 10 AC 48 08 09 00 00 F2 41 0F 10 90 B0 0A 00 00 66 0F 57 E4 BA C8 43 00 00 66 0F C4 E2 03 66 0F 54 D3 66 0F 73 F3 28 F2 0F 59 D1 F2 0F 59 D9 F2 0F 59 CD 66 0F 28 C2 F2 0F 58 D3 66 0F 28 EA F2 0F 5C C2 F2 0F 58 D4 F2 0F 58 C3 F2 41 0F 10 B0 A0 0A 00 00 F2 0F 5C D4 F2 0F 58 C1 F2 0F 5C EA F2 0F 58 C5 F2 0F 59 C6 F2 0F 5A D0 F3 41 0F 10 88 60 0A 00 00 F3 0F 59 CA 41 0F 28 B8 F0 09 00 00 F3 0F 2D D1 66 0F DB FA F2 41 0F 10 A0 70 0A 00 00 F3 0F 58 E1 F3 41 0F 58 88 90 0A 00 00 F3 41 0F 5C A0 70 0A 00 00 F3 41 0F 5C 88 90 0A 00 00 66 0F 28 EF 66 0F 73 F7 20 66 0F 73 F5 1D 66 0F 57 FD 81 C2 00 76 1C 00 83 E2 1F F2 41 0F 10 A8 30 0A 00 00 66 0F 57 EF F2 41 0F 10 90 10 0A 00 00 66 0F 57 D7 F2 41 0F 10 B0 20 0A 00 00 66 0F 57 F7 F2 41 0F 10 98 00 0A 00 00 66 0F 57 DF 49 8D 00 C1 E2 03 48 03 C2 C1 E2 03 48 03 C2 66 0F 73 F4 1D 66 0F 73 F1 1D F2 0F 59 EC F2 0F 59 D1 F2 0F 59 F4 F2 0F 59 D9 F2 0F 58 E8 F2 0F 58 D0 F2 0F 58 EE F2 0F 58 D3 F2 41 0F 10 B8 40 0A 00 00 F2 0F 5E FD F2 0F 59 78 40 F2 0F 10 58 38 F2 0F 59 DA F2 0F 10 60 18 F2 0F 59 E2 F2 0F 10 68 28 F2 0F 59 EA F2 0F 10 70 08 F2 0F 59 F2 F2 0F 59 D2 F2 0F 58 58 30 F2 0F 58 60 10 F2 0F 58 68 20 F2 0F 58 30 F2 0F 59 DA F2 0F 59 E2 F2 0F 59 D2 F2 0F 58 DD F2 0F 58 E6 F2 0F 59 DA F2 0F 58 DC F2 0F 5C DF F2 0F 5A C3 EB 04 F3 0F 5C C0 F3 0F 11 44 24 24 8B 44 24 24 42 89 84 8C F0 00 00 00 8B 44 24 20 E9 9F FD FF FF 90 }
	condition:
		$1
}

rule file_244_1_0 {
	meta:
		name = "?DebuggerProbe@@YAHK@Z"
		size = 65
		refs = "0031 __imp_RaiseException"
	strings:
		$1 = { 48 83 EC 58 C6 44 24 60 00 C7 44 24 20 01 10 00 00 89 4C 24 28 48 8D 44 24 60 48 89 44 24 30 4C 8D 4C 24 20 33 D2 44 8D 42 0A B9 88 13 6D 40 FF 15 ?? ?? ?? ?? EB 00 0F B6 44 24 60 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_244_2_0 {
	meta:
		name = "?filt$0@?0??DebuggerProbe@@YAHK@Z@4HA"
		size = 32
		altNames = "?filt$0@?0??DebuggerRuntime@@YAHKHPEAXPEB_W@Z@4HA"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 01 33 C9 81 38 88 13 6D 40 0F 94 C1 8B C1 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_244_3_0 {
	meta:
		name = "?DebuggerRuntime@@YAHKHPEAXPEB_W@Z"
		size = 79
		refs = "003f __imp_RaiseException"
	strings:
		$1 = { 48 83 EC 58 C6 44 24 60 00 C7 44 24 20 02 10 00 00 89 4C 24 28 89 54 24 2C 4C 89 44 24 30 48 8D 44 24 60 48 89 44 24 38 4C 89 4C 24 40 4C 8D 4C 24 20 33 D2 44 8D 42 0A B9 88 13 6D 40 FF 15 ?? ?? ?? ?? EB 00 0F B6 44 24 60 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_244_5_0 {
	meta:
		name = "?_RTC_AllocaFailure@@YAXPEAXPEAU_RTC_ALLOCA_NODE@@H@Z"
		size = 392
		refs = "000f __security_cookie 0020 ?_RTC_ErrorLevels@@3PAHA 0041 ??_C@_0EJ@LJKNEOLN@Stack?5area?5around?5_alloca?5memory@ 0046 ?failwithmessage@@YAXPEAXHHPEBD@Z 0056 ??_C@_08OMAHNMHJ@?6Data?3?5?$DM?$AA@ 0062 ??_C@_0EI@CLEPFNGI@Stack?5area?5around?5_alloca?5memory@ 006e ??_C@_0CK@DKGBICFE@?6Allocation?5number?5within?5this?5f@ 007a ??_C@_0BC@HHMKLAND@?$CFs?$CFs?$CFp?$CFs?$CFzd?$CFs?$CFd?$CFs?$AA@ 0096 ??_C@_07DFDJCKFN@?6Size?3?5?$AA@ 00b2 ??_C@_0N@MHFFIMFG@?6Address?3?50x?$AA@ 00c8 sprintf_s 00e2 ?_getMemBlockDataString@@YAXPEAD00_K@Z 00ef ?_strlen_priv@@YA_KPEBD@Z 0119 ??_C@_01EEMJAFIK@?6?$AA@ 0125 ??_C@_08KJEDNCKC@?$CFs?$CFs?$CFs?$CFs?$AA@ 0136 ??_C@_02LLMPMKNF@?$DO?5?$AA@ 0178 __security_check_cookie"
	strings:
		$1 = { 40 55 56 41 56 48 81 EC E0 01 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 C0 01 00 00 8B 35 ?? ?? ?? ?? 48 8B EA 4C 8B F1 83 FE FF 0F 84 39 01 00 00 48 85 D2 75 17 44 8D 42 04 8B D6 4C 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 1D 01 00 00 48 8B 42 0C 48 8D 0D ?? ?? ?? ?? 48 89 4C 24 50 4C 8D 0D ?? ?? ?? ?? 44 89 44 24 48 48 8D 0D ?? ?? ?? ?? 48 89 4C 24 40 4C 8D 05 ?? ?? ?? ?? 48 83 E8 24 48 89 9C 24 D8 01 00 00 48 89 44 24 38 48 8D 5A 20 48 8D 05 ?? ?? ?? ?? 48 89 BC 24 D0 01 00 00 48 89 44 24 30 48 8D 8C 24 B0 00 00 00 48 8D 05 ?? ?? ?? ?? 48 89 5C 24 28 BF 06 01 00 00 48 89 44 24 20 8B D7 E8 ?? ?? ?? ?? 4C 8B 4D 0C 48 8D 54 24 78 49 83 E9 24 48 8D 4C 24 60 4C 8B C3 E8 ?? ?? ?? ?? 48 8D 8C 24 B0 00 00 00 E8 ?? ?? ?? ?? 48 8D 8C 24 B0 00 00 00 48 2B F8 E8 ?? ?? ?? ?? 48 8D 8C 24 B0 00 00 00 48 8B D7 48 03 C8 4C 8D 4C 24 60 48 8D 05 ?? ?? ?? ?? 48 89 44 24 30 4C 8D 05 ?? ?? ?? ?? 48 8D 44 24 78 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 E8 ?? ?? ?? ?? 4C 8D 8C 24 B0 00 00 00 41 B8 04 00 00 00 8B D6 49 8B CE E8 ?? ?? ?? ?? 48 8B BC 24 D0 01 00 00 48 8B 9C 24 D8 01 00 00 48 8B 8C 24 C0 01 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 E0 01 00 00 41 5E 5E 5D C3 }
	condition:
		$1
}

rule file_244_6_0 {
	meta:
		name = "?_RTC_Failure@@YAXPEAXH@Z"
		size = 78
		refs = "000b __ImageBase 0013 ?_RTC_ErrorLevels@@3PAHA 001b ?_RTC_ErrorMessages@@3QBQEBDB 002c ?failwithmessage@@YAXPEAXHHPEBD@Z"
	strings:
		$1 = { 83 FA 04 77 2B 48 63 C2 4C 8D 0D ?? ?? ?? ?? 45 8B 94 81 ?? ?? ?? ?? 4D 8B 8C C1 ?? ?? ?? ?? 41 83 FA FF 74 28 44 8B C2 41 8B D2 E9 ?? ?? ?? ?? 4C 8B 0D ?? ?? ?? ?? BA 05 00 00 00 41 BA 01 00 00 00 44 8B C2 41 8B D2 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_244_7_0 {
	meta:
		name = "?_RTC_StackFailure@@YAXPEAXPEBD@Z"
		size = 302
		refs = "0015 __security_cookie 0026 ?_RTC_ErrorLevels@@3PAHA 0046 ?_strlen_priv@@YA_KPEBD@Z 0064 ?stack_premsg@@3QBDB 00cd ?stack_postmsg@@3QBDB 00f5 ??_C@_0CG@IAFNJNEE@Stack?5corrupted?5near?5unknown?5var@ 0105 ?failwithmessage@@YAXPEAXHHPEBD@Z 0115 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 18 48 89 74 24 20 57 48 81 EC 30 04 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 20 04 00 00 8B 3D ?? ?? ?? ?? 48 8B DA 48 8B F1 83 FF FF 0F 84 D0 00 00 00 80 3A 00 0F 84 B0 00 00 00 48 8B CA E8 ?? ?? ?? ?? 48 83 C0 2D 48 3D 00 04 00 00 0F 87 98 00 00 00 4C 8D 4C 24 20 33 C9 48 8D 15 ?? ?? ?? ?? 0F 1F 84 00 00 00 00 00 0F B6 04 11 88 44 0C 20 48 8D 49 01 84 C0 75 F0 48 8D 4C 24 20 48 FF C9 0F 1F 84 00 00 00 00 00 80 79 01 00 48 8D 49 01 75 F6 33 D2 0F 1F 40 00 0F B6 04 13 88 04 11 48 8D 52 01 84 C0 75 F1 48 8D 4C 24 20 48 FF C9 66 0F 1F 84 00 00 00 00 00 80 79 01 00 48 8D 49 01 75 F6 4C 8D 05 ?? ?? ?? ?? 33 D2 0F 1F 40 00 66 0F 1F 84 00 00 00 00 00 41 0F B6 04 10 88 04 11 48 8D 52 01 84 C0 75 F0 EB 07 4C 8D 0D ?? ?? ?? ?? 41 B8 02 00 00 00 8B D7 48 8B CE E8 ?? ?? ?? ?? 48 8B 8C 24 20 04 00 00 48 33 CC E8 ?? ?? ?? ?? 4C 8D 9C 24 30 04 00 00 49 8B 5B 20 49 8B 73 28 49 8B E3 5F C3 }
	condition:
		$1
}

rule file_244_8_0 {
	meta:
		name = "?_getMemBlockDataString@@YAXPEAD00_K@Z"
		size = 178
		refs = "0059 ??_C@_05MKKEDADM@?$CF?42X?5?$AA@ 0067 sprintf_s"
	strings:
		$1 = { 48 89 54 24 10 56 41 54 41 55 41 57 48 83 EC 28 45 33 FF BE 10 00 00 00 4C 3B CE 4D 8B E0 48 8B C2 4C 8B E9 49 0F 42 F1 48 85 F6 74 6B 48 89 5C 24 50 4C 2B E1 48 89 6C 24 60 48 8B EA 48 89 7C 24 68 48 8B F9 4C 89 74 24 20 45 8D 77 31 4C 8B FE 41 0F B6 1C 3C 4C 8D 05 ?? ?? ?? ?? 44 8B CB 49 8B D6 48 8B CD E8 ?? ?? ?? ?? 49 83 EE 03 88 1F 48 83 C5 03 48 8D 7F 01 48 83 EE 01 75 D2 48 8B 44 24 58 4C 8B 74 24 20 48 8B 7C 24 68 48 8B 6C 24 60 48 8B 5C 24 50 4A 8D 04 78 43 C6 04 2F 00 41 C6 04 07 00 48 83 C4 28 41 5F 41 5D 41 5C 5E C3 }
	condition:
		$1
}

rule file_244_9_0 {
	meta:
		name = "?_strlen_priv@@YA_KPEBD@Z"
		size = 20
	strings:
		$1 = { 48 8B C1 0F B6 10 48 FF C0 84 D2 75 F6 48 2B C1 48 FF C8 C3 }
	condition:
		$1
}

rule file_244_10_0 {
	meta:
		name = "?failwithmessage@@YAXPEAXHHPEBD@Z"
		size = 620
		refs = "0016 __security_cookie 0038 ?_RTC_GetErrorFuncW@@YAP6AHHPEB_WH00ZZPEBX@Z 0048 ?_RTC_GetErrorFunc@@YAP6AHHPEBDH00ZZPEBX@Z 0071 __imp_MultiByteToWideChar 00b5 ??_C@_1GM@OLMCBDMB@?$AAR?$AAu?$AAn?$AAt?$AAi?$AAm?$AAe?$AA?5?$AAC?$AAh?$AAe?$AAc?$AAk?$AA?5?$AAE?$AAr?$AAr?$AAo?$AAr?$AA?4?$AA?6?$AA?$AN?$AA?5?$AAU?$AAn?$AAa?$AAb?$AAl?$AAe?$AA?5?$AAt?$AAo@ 00bf ?DebuggerProbe@@YAHK@Z 00ca ?_RTC_NoFalsePositives@@3QBHB 00da ?DebuggerRuntime@@YAHKHPEAXPEB_W@Z 00fe __imp_IsDebuggerPresent 0134 ?_RTC_GetSrcLine@@YAHPEAEPEA_WKPEAH1K@Z 0141 _guard_check_icall 014d ??_C@_1EA@NFKNIFJP@?$AAR?$AAu?$AAn?$AA?9?$AAT?$AAi?$AAm?$AAe?$AA?5?$AAC?$AAh?$AAe?$AAc?$AAk?$AA?5?$AAF?$AAa?$AAi?$AAl?$AAu?$AAr?$AAe?$AA?5?$AA?$CD?$AA?$CF?$AAd?$AA?5?$AA?9?$AA?5?$AA?$CF?$AAs?$AA?$AA@ 0198 ??_C@_0BB@PFFGGCJP@Unknown?5Filename?$AA@ 01ae __imp_WideCharToMultiByte 01f0 ??_C@_0BE@GNBOBNCK@Unknown?5Module?5Name?$AA@ 021d ??_C@_0CA@IODNCDPG@Run?9Time?5Check?5Failure?5?$CD?$CFd?5?9?5?$CFs?$AA@ 0255 __security_check_cookie"
	strings:
		$1 = { 40 53 55 57 41 54 41 55 41 56 41 57 48 81 EC B0 0E 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 90 0E 00 00 45 33 ED 49 63 E8 45 8B F5 4D 8B F9 44 8B E2 48 8B F9 E8 ?? ?? ?? ?? 48 8B D8 48 85 C0 75 0B 48 8B CF E8 ?? ?? ?? ?? 4C 8B F0 44 89 6C 24 28 41 83 C9 FF 4D 8B C7 4C 89 6C 24 20 33 D2 48 89 B4 24 A8 0E 00 00 B9 E9 FD 00 00 FF 15 ?? ?? ?? ?? 48 63 C8 48 81 F9 00 02 00 00 73 31 89 44 24 28 41 83 C9 FF 48 8D 84 24 90 0A 00 00 4D 8B C7 33 D2 48 89 44 24 20 B9 E9 FD 00 00 FF 15 ?? ?? ?? ?? 48 8D B4 24 90 0A 00 00 85 C0 75 07 48 8D 35 ?? ?? ?? ?? B9 02 10 00 00 E8 ?? ?? ?? ?? 85 C0 74 21 48 8D 0D ?? ?? ?? ?? 4C 8B CE 8B 14 A9 4C 8B C7 8B CD E8 ?? ?? ?? ?? 85 C0 0F 85 5B 01 00 00 EB 02 B0 01 4D 85 F6 75 09 48 85 DB 0F 84 48 01 00 00 84 C0 74 0E FF 15 ?? ?? ?? ?? 85 C0 0F 85 36 01 00 00 48 8D 84 24 60 02 00 00 C7 44 24 28 04 01 00 00 48 8D 4F FB 48 89 44 24 20 4C 8D 4C 24 40 41 B8 04 01 00 00 48 8D 54 24 50 E8 ?? ?? ?? ?? 48 85 DB 74 39 48 8B CB E8 ?? ?? ?? ?? 44 8B 44 24 40 48 8D 05 ?? ?? ?? ?? 48 89 74 24 30 4C 8D 8C 24 60 02 00 00 89 6C 24 28 48 8D 54 24 50 41 8B CC 48 89 44 24 20 FF D3 E9 C5 00 00 00 4C 89 6C 24 38 48 8D 84 24 70 04 00 00 4C 89 6C 24 30 4C 8D 44 24 50 C7 44 24 28 0A 03 00 00 48 8D 1D ?? ?? ?? ?? 41 83 C9 FF 48 89 44 24 20 33 D2 B9 E9 FD 00 00 FF 15 ?? ?? ?? ?? 4C 89 6C 24 38 48 8D BC 24 70 04 00 00 85 C0 4C 89 6C 24 30 48 8D 84 24 80 07 00 00 C7 44 24 28 0A 03 00 00 48 0F 44 FB 48 89 44 24 20 41 83 C9 FF 4C 8D 84 24 60 02 00 00 33 D2 48 8D 35 ?? ?? ?? ?? B9 E9 FD 00 00 FF 15 ?? ?? ?? ?? 48 8D 9C 24 80 07 00 00 49 8B CE 85 C0 48 0F 44 DE E8 ?? ?? ?? ?? 44 8B 44 24 40 48 8D 05 ?? ?? ?? ?? 4C 89 7C 24 30 4C 8B CB 89 6C 24 28 48 8B D7 41 8B CC 48 89 44 24 20 41 FF D6 83 F8 01 75 01 CC 48 8B B4 24 A8 0E 00 00 48 8B 8C 24 90 0E 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 B0 0E 00 00 41 5F 41 5E 41 5D 41 5C 5F 5D 5B C3 }
	condition:
		$1
}

rule file_244_11_0 {
	meta:
		name = "_RTC_UninitUse"
		size = 287
		refs = "0010 __security_cookie 0021 ?_RTC_ErrorLevels@@3PAHA 003b ?_strlen_priv@@YA_KPEBD@Z 0059 ?uninit_premsg@@3QBDB 00bd ?uninit_postmsg@@3QBDB 00e5 ??_C@_0DE@OHJBPMBP@A?5variable?5is?5being?5used?5without@ 00fa ?failwithmessage@@YAXPEAXHHPEBD@Z 010a __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 10 57 48 81 EC 30 04 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 20 04 00 00 8B 3D ?? ?? ?? ?? 48 8B D9 83 FF FF 0F 84 CD 00 00 00 48 85 C9 0F 84 A8 00 00 00 E8 ?? ?? ?? ?? 48 83 C0 3A 48 3D 00 04 00 00 0F 87 93 00 00 00 4C 8D 4C 24 20 33 C9 48 8D 15 ?? ?? ?? ?? 0F 1F 00 0F B6 04 11 88 44 0C 20 48 8D 49 01 84 C0 75 F0 48 8D 4C 24 20 48 FF C9 0F 1F 84 00 00 00 00 00 80 79 01 00 48 8D 49 01 75 F6 33 D2 0F 1F 40 00 0F B6 04 13 88 04 11 48 8D 52 01 84 C0 75 F1 48 8D 4C 24 20 48 FF C9 66 0F 1F 84 00 00 00 00 00 80 79 01 00 48 8D 49 01 75 F6 4C 8D 05 ?? ?? ?? ?? 33 D2 0F 1F 40 00 66 0F 1F 84 00 00 00 00 00 41 0F B6 04 10 88 04 11 48 8D 52 01 84 C0 75 F0 EB 07 4C 8D 0D ?? ?? ?? ?? 48 8B 8C 24 38 04 00 00 41 B8 03 00 00 00 8B D7 E8 ?? ?? ?? ?? 48 8B 8C 24 20 04 00 00 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 48 04 00 00 48 81 C4 30 04 00 00 5F C3 }
	condition:
		$1
}

rule file_244_13_0 {
	meta:
		name = "_vsprintf_s_l"
		size = 98
		refs = "0021 __local_stdio_printf_options 0041 __stdio_common_vsprintf_s"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 30 49 8B D9 49 8B F8 48 8B F2 48 8B E9 E8 ?? ?? ?? ?? 4C 8B 54 24 60 4C 8B CF 4C 89 54 24 28 4C 8B C6 48 8B D5 48 89 5C 24 20 48 8B 08 E8 ?? ?? ?? ?? 48 8B 5C 24 40 83 C9 FF 48 8B 6C 24 48 85 C0 48 8B 74 24 50 0F 48 C1 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_244_14_0 {
	meta:
		name = "sprintf_s"
		size = 63
		refs = "0017 ??$__vcrt_va_start_verify_argument_type@QEBD@@YAXXZ 0034 _vsprintf_s_l"
	strings:
		$1 = { 4C 89 44 24 18 4C 89 4C 24 20 53 57 48 83 EC 38 48 8B DA 48 8B F9 E8 ?? ?? ?? ?? 4C 8B 44 24 60 48 8D 44 24 68 45 33 C9 48 89 44 24 20 48 8B D3 48 8B CF E8 ?? ?? ?? ?? 48 83 C4 38 5F 5B C3 }
	condition:
		$1
}

rule file_246_0_0 {
	meta:
		name = "??_U@YAPEAX_KAEBUnothrow_t@std@@@Z"
		size = 34
		refs = "0019 ??2@YAPEAX_KAEBUnothrow_t@std@@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_2_4_3 {
	meta:
		name = "??$?8DU?$char_traits@D@std@@@std@@YA_NAEBV?$istreambuf_iterator@DU?$char_traits@D@std@@@0@0@Z"
		size = 34
		refs = "0019 ?equal@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@QEBA_NAEBV12@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_10_22_2 {
	meta:
		name = "??$?8GU?$char_traits@G@std@@@std@@YA_NAEBV?$istreambuf_iterator@GU?$char_traits@G@std@@@0@0@Z"
		size = 34
		refs = "0019 ?equal@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@QEBA_NAEBV12@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_89_10_2 {
	meta:
		name = "??$?8V?$allocator@D@std@@V01@@std@@YA_NAEBU?$_Wrap_alloc@V?$allocator@D@std@@@0@0@Z"
		size = 34
		refs = "0019 ??$?8DD@std@@YA_NAEBV?$allocator@D@0@0@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_119_14_1 {
	meta:
		name = "??$?8V?$allocator@G@std@@V01@@std@@YA_NAEBU?$_Wrap_alloc@V?$allocator@G@std@@@0@0@Z"
		size = 34
		refs = "0019 ??$?8GG@std@@YA_NAEBV?$allocator@G@0@0@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_10_24_2 {
	meta:
		name = "??$?8V?$allocator@_W@std@@V01@@std@@YA_NAEBU?$_Wrap_alloc@V?$allocator@_W@std@@@0@0@Z"
		size = 34
		refs = "0019 ??$?8_W_W@std@@YA_NAEBV?$allocator@_W@0@0@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_103_25_3 {
	meta:
		name = "??$?8_WU?$char_traits@_W@std@@@std@@YA_NAEBV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@0@0@Z"
		size = 34
		refs = "0019 ?equal@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@QEBA_NAEBV12@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_36_18_3 {
	meta:
		name = "??$_Swap_adl@PEAD@std@@YAXAEAPEAD0@Z"
		size = 34
		refs = "0019 ??$swap@PEADX@std@@YAXAEAPEAD0@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_117_15_1 {
	meta:
		name = "??$destroy@PEAD@?$_Wrap_alloc@V?$allocator@D@std@@@std@@QEAAXPEAPEAD@Z"
		size = 34
		refs = "0019 ??$destroy@PEAD@?$allocator_traits@V?$allocator@D@std@@@std@@SAXAEAV?$allocator@D@1@PEAPEAD@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_17_1 {
	meta:
		name = "??$destroy@PEAD@?$allocator_traits@V?$allocator@D@std@@@std@@SAXAEAV?$allocator@D@1@PEAPEAD@Z"
		size = 34
		refs = "0019 ??$destroy@PEAD@?$allocator@D@std@@QEAAXPEAPEAD@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_103_175_3 {
	meta:
		name = "??$destroy@PEAG@?$_Wrap_alloc@V?$allocator@G@std@@@std@@QEAAXPEAPEAG@Z"
		size = 34
		refs = "0019 ??$destroy@PEAG@?$allocator_traits@V?$allocator@G@std@@@std@@SAXAEAV?$allocator@G@1@PEAPEAG@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_119_103_1 {
	meta:
		name = "??$destroy@PEAG@?$allocator_traits@V?$allocator@G@std@@@std@@SAXAEAV?$allocator@G@1@PEAPEAG@Z"
		size = 34
		refs = "0019 ??$destroy@PEAG@?$allocator@G@std@@QEAAXPEAPEAG@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_119_104_1 {
	meta:
		name = "??$destroy@PEA_W@?$_Wrap_alloc@V?$allocator@_W@std@@@std@@QEAAXPEAPEA_W@Z"
		size = 34
		refs = "0019 ??$destroy@PEA_W@?$allocator_traits@V?$allocator@_W@std@@@std@@SAXAEAV?$allocator@_W@1@PEAPEA_W@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_10_134_2 {
	meta:
		name = "??$destroy@PEA_W@?$allocator_traits@V?$allocator@_W@std@@@std@@SAXAEAV?$allocator@_W@1@PEAPEA_W@Z"
		size = 34
		refs = "0019 ??$destroy@PEA_W@?$allocator@_W@std@@QEAAXPEAPEA_W@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_66_47_3 {
	meta:
		name = "??$destroy@U_Container_proxy@std@@@?$_Wrap_alloc@V?$allocator@U_Container_proxy@std@@@std@@@std@@QEAAXPEAU_Container_proxy@1@@Z"
		size = 34
		refs = "0019 ??$destroy@U_Container_proxy@std@@@?$allocator_traits@V?$allocator@U_Container_proxy@std@@@std@@@std@@SAXAEAV?$allocator@U_Container_proxy@std@@@1@PEAU_Container_proxy@1@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_118_32_2 {
	meta:
		name = "??$destroy@U_Container_proxy@std@@@?$allocator_traits@V?$allocator@U_Container_proxy@std@@@std@@@std@@SAXAEAV?$allocator@U_Container_proxy@std@@@1@PEAU_Container_proxy@1@@Z"
		size = 34
		refs = "0019 ??$destroy@U_Container_proxy@std@@@?$allocator@U_Container_proxy@std@@@std@@QEAAXPEAU_Container_proxy@1@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_60_22_3 {
	meta:
		name = "??$destroy@V?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@@?$_Wrap_alloc@U?$_StaticAllocator@V?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@@@@std@@QEAAXPEAV?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@1@@Z"
		size = 34
		refs = "0019 ??$destroy@V?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@@?$allocator_traits@U?$_StaticAllocator@V?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@@@@std@@SAXAEAU?$_StaticAllocator@V?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@@@PEAV?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@1@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_36_41_3 {
	meta:
		name = "??$iter_swap@PEADPEAD@std@@YAXPEAD0@Z"
		size = 34
		refs = "0019 ??$swap@DX@std@@YAXAEAD0@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_89_227_2 {
	meta:
		name = "??G?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEBA_JAEBV?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@1@@Z"
		size = 34
		refs = "0019 ??G?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEBA_JAEBV01@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_103_531_3 {
	meta:
		name = "??G?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QEBA_JAEBV?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@1@@Z"
		size = 34
		refs = "0019 ??G?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QEBA_JAEBV01@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_103_534_3 {
	meta:
		name = "??G?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QEBA_JAEBV?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@1@@Z"
		size = 34
		refs = "0019 ??G?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QEBA_JAEBV01@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_2_144_3 {
	meta:
		name = "??Y?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV01@AEBV01@@Z"
		size = 34
		refs = "0019 ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@AEBV12@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_119_421_1 {
	meta:
		name = "??Y?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEAAAEAV01@AEBV01@@Z"
		size = 34
		refs = "0019 ?append@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEAAAEAV12@AEBV12@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_10_499_2 {
	meta:
		name = "??Y?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAAAEAV01@AEBV01@@Z"
		size = 34
		refs = "0019 ?append@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAAAEAV12@AEBV12@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_60_127_3 {
	meta:
		name = "?allocate@?$_Wrap_alloc@U?$_StaticAllocator@V?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@@@@std@@QEAAPEAV?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@2@_K@Z"
		size = 34
		refs = "0019 ?allocate@?$_StaticAllocator@V?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@@@QEBAPEAV?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@_K@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_36_161_3 {
	meta:
		name = "?allocate@?$_Wrap_alloc@V?$allocator@D@std@@@std@@QEAAPEAD_K@Z"
		size = 34
		refs = "0019 ?allocate@?$allocator@D@std@@QEAAPEAD_K@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_119_898_1 {
	meta:
		name = "?allocate@?$_Wrap_alloc@V?$allocator@G@std@@@std@@QEAAPEAG_K@Z"
		size = 34
		refs = "0019 ?allocate@?$allocator@G@std@@QEAAPEAG_K@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_48_282_2 {
	meta:
		name = "?allocate@?$_Wrap_alloc@V?$allocator@U_Container_proxy@std@@@std@@@std@@QEAAPEAU_Container_proxy@2@_K@Z"
		size = 34
		refs = "0019 ?allocate@?$allocator@U_Container_proxy@std@@@std@@QEAAPEAU_Container_proxy@2@_K@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_99_77_2 {
	meta:
		name = "?allocate@?$_Wrap_alloc@V?$allocator@_W@std@@@std@@QEAAPEA_W_K@Z"
		size = 34
		refs = "0019 ?allocate@?$allocator@_W@std@@QEAAPEA_W_K@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_85_14_2 {
	meta:
		name = "?spfun@std@@YAXAEAVios_base@1@_J@Z"
		size = 34
		refs = "0019 ?precision@ios_base@std@@QEAA_J_J@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_108_131_1 {
	meta:
		name = "?swap@?$shared_ptr@V__ExceptionPtr@@@std@@QEAAXAEAV12@@Z"
		size = 34
		refs = "0019 ?_Swap@?$_Ptr_base@V__ExceptionPtr@@@std@@QEAAXAEAV12@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_13_15_1 {
	meta:
		name = "?swfun@std@@YAXAEAVios_base@1@_J@Z"
		size = 34
		refs = "0019 ?width@ios_base@std@@QEAA_J_J@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_115_0_2 {
	meta:
		name = "_LDunscale"
		size = 34
		refs = "0019 _Dunscale"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_41_109_1 {
	meta:
		name = "_Lstat"
		size = 34
		refs = "0019 _Stat"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_248_0_0 {
	meta:
		name = "_RTC_Check_2_to_1"
		size = 49
		refs = "0024 ?_RTC_Failure@@YAXPEAXH@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 0F BF D9 8B C3 25 00 FF 00 00 74 16 3D 00 FF 00 00 74 0F 48 8B 4C 24 28 BA 01 00 00 00 E8 ?? ?? ?? ?? 0F B6 C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_248_1_0 {
	meta:
		name = "_RTC_Check_4_to_1"
		size = 51
		refs = "0026 ?_RTC_Failure@@YAXPEAXH@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 8B C1 8B D9 25 00 FF FF FF 05 00 01 00 00 A9 FF FE FF FF 74 0F 48 8B 4C 24 28 BA 01 00 00 00 E8 ?? ?? ?? ?? 0F B6 C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_248_2_0 {
	meta:
		name = "_RTC_Check_4_to_2"
		size = 51
		refs = "0026 ?_RTC_Failure@@YAXPEAXH@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 8B C1 8B D9 25 00 00 FF FF 05 00 00 01 00 A9 FF FF FE FF 74 0F 48 8B 4C 24 28 BA 01 00 00 00 E8 ?? ?? ?? ?? 0F B7 C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_248_3_0 {
	meta:
		name = "_RTC_Check_8_to_1"
		size = 56
		refs = "002b ?_RTC_Failure@@YAXPEAXH@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B C1 48 8B D9 48 25 00 FF FF FF 48 05 00 01 00 00 48 A9 FF FE FF FF 74 0F 48 8B 4C 24 28 BA 01 00 00 00 E8 ?? ?? ?? ?? 0F B6 C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_248_4_0 {
	meta:
		name = "_RTC_Check_8_to_2"
		size = 56
		refs = "002b ?_RTC_Failure@@YAXPEAXH@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B C1 48 8B D9 48 25 00 00 FF FF 48 05 00 00 01 00 48 A9 FF FF FE FF 74 0F 48 8B 4C 24 28 BA 01 00 00 00 E8 ?? ?? ?? ?? 0F B7 C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_248_5_0 {
	meta:
		name = "_RTC_Check_8_to_4"
		size = 76
		refs = "0040 ?_RTC_Failure@@YAXPEAXH@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B C1 48 8B D9 48 B9 00 00 00 00 FF FF FF FF 48 23 C1 48 B9 00 00 00 00 01 00 00 00 48 03 C1 48 B9 FF FF FF FF FE FF FF FF 48 85 C1 74 0F 48 8B 4C 24 28 BA 01 00 00 00 E8 ?? ?? ?? ?? 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_252_0_0 {
	meta:
		name = "__dyn_tls_init"
		size = 126
		refs = "001e __xd_a 003e __xd_z 0067 _guard_check_icall 0074 terminate"
	strings:
		$1 = { 4C 89 44 24 18 89 54 24 10 48 89 4C 24 08 48 83 EC 48 83 7C 24 58 02 74 02 EB 5E 48 8D 05 ?? ?? ?? ?? 48 83 C0 08 48 89 44 24 28 EB 0E 48 8B 44 24 28 48 83 C0 08 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 39 44 24 28 74 28 48 8B 44 24 28 48 83 38 00 74 1B 48 8B 44 24 28 48 8B 00 48 89 44 24 30 48 8B 4C 24 30 E8 ?? ?? ?? ?? FF 54 24 30 EB BC EB 06 E8 ?? ?? ?? ?? 90 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_252_1_0 {
	meta:
		name = "__dyn_tls_init$filt$0"
		size = 43
		refs = "001f dyntls_init_exception_filter"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 89 4D 38 48 8B 45 38 48 8B 00 8B 00 89 45 20 8B 45 20 8B C8 E8 ?? ?? ?? ?? 90 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_252_2_0 {
	meta:
		name = "dyntls_init_exception_filter"
		size = 24
	strings:
		$1 = { 89 4C 24 08 81 7C 24 08 63 73 6D E0 75 07 B8 01 00 00 00 EB 02 33 C0 C3 }
	condition:
		$1
}

rule file_254_0_0 {
	meta:
		name = "__avx_log10f8"
		size = 576
		refs = "0024 __common_slog10_data 0236 __common_slog10_cout_rare"
	strings:
		$1 = { 48 81 EC 18 02 00 00 C5 7C 11 84 24 F0 01 00 00 4C 89 AC 24 10 02 00 00 4C 8D AC 24 8F 01 00 00 C5 78 10 05 ?? ?? ?? ?? 49 83 E5 C0 C5 F8 10 2D ?? ?? ?? ?? C4 C1 79 FA C8 C4 E3 7D 19 C2 01 C4 C1 69 FA E0 C5 E9 72 E1 17 C5 E1 72 E4 17 C5 F1 DB CD C5 D9 DB E5 C5 FC C2 2D ?? ?? ?? ?? 11 C4 E3 6D 18 D3 01 C4 C1 71 FE D8 C4 C1 59 FE C8 C5 FC 5B D2 C4 E3 65 18 C9 01 C5 FC C2 1D ?? ?? ?? ?? 16 C5 F4 5C 0D ?? ?? ?? ?? C5 D4 56 E3 C5 E1 EF DB C4 C3 7D 19 E0 01 C4 C1 59 6B E8 C5 74 59 05 ?? ?? ?? ?? C5 D1 63 E3 C5 F4 59 D9 C5 F4 59 2D ?? ?? ?? ?? C5 3C 58 05 ?? ?? ?? ?? C5 F9 D7 D4 C5 D4 58 2D ?? ?? ?? ?? C5 3C 59 C3 C5 F4 59 25 ?? ?? ?? ?? C5 3C 58 C5 C5 DC 58 25 ?? ?? ?? ?? C5 F4 59 2D ?? ?? ?? ?? C5 3C 59 C3 C5 D4 58 2D ?? ?? ?? ?? C5 BC 58 E4 C5 6C 59 05 ?? ?? ?? ?? C5 EC 59 15 ?? ?? ?? ?? C5 DC 59 DB C5 E4 58 DD C5 E4 59 E1 C5 DC 58 2D ?? ?? ?? ?? C5 D4 59 C9 C4 C1 74 58 C8 C5 EC 58 C9 84 D2 75 1D C5 7C 10 84 24 F0 01 00 00 4C 8B AC 24 10 02 00 00 C5 FC 28 C1 48 81 C4 18 02 00 00 C3 C4 C1 7C 11 45 00 C4 C1 7C 11 4D 40 85 D2 74 D3 33 C0 C5 FC 11 B4 24 20 01 00 00 C5 FC 11 BC 24 00 01 00 00 C5 7C 11 8C 24 E0 00 00 00 C5 7C 11 94 24 C0 00 00 00 C5 7C 11 9C 24 A0 00 00 00 C5 7C 11 A4 24 80 00 00 00 C5 7C 11 6C 24 60 C5 7C 11 74 24 40 C5 7C 11 7C 24 20 48 89 9C 24 48 01 00 00 8B D8 48 89 B4 24 40 01 00 00 8B F2 0F A3 DE 72 6A FF C3 83 FB 20 7C F4 C5 FC 10 B4 24 20 01 00 00 C5 FC 10 BC 24 00 01 00 00 C5 7C 10 8C 24 E0 00 00 00 C5 7C 10 94 24 C0 00 00 00 C5 7C 10 9C 24 A0 00 00 00 C5 7C 10 A4 24 80 00 00 00 C5 7C 10 6C 24 60 C5 7C 10 74 24 40 C5 7C 10 7C 24 20 C4 C1 7C 10 4D 40 48 8B 9C 24 48 01 00 00 48 8B B4 24 40 01 00 00 E9 06 FF FF FF C5 F8 77 49 8D 4C 9D 00 49 8D 54 9D 40 E8 ?? ?? ?? ?? EB 82 0F 1F 40 00 }
	condition:
		$1
}

rule file_257_0_0 {
	meta:
		name = "__sse2_tanh2"
		size = 640
		refs = "001b s_dwAbsMsk 0027 s_dwInvLn 0032 s_dwExp2 003a s_dwRS 004a s_dwLnHi 0056 s_dwLnLo 007d s_dwExpbOvfBoundHi 00aa s_dwBias 00f5 s_dwExpbMask 014b s_dwA5 0165 s_dwA4 0188 s_dwA3 0194 s_dwA2 01fa s_dwSignMask 0223 s_dwLoSpecMask 022d s_dwHiSpecMask 0253 s_dwOne"
	strings:
		$1 = { 48 81 EC A8 00 00 00 0F 29 B4 24 90 00 00 00 0F 29 BC 24 80 00 00 00 66 0F 28 3D ?? ?? ?? ?? 66 0F 28 C8 66 0F 28 15 ?? ?? ?? ?? 66 0F 54 C7 4C 8D 15 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F 59 D0 66 0F 54 F9 66 0F 28 25 ?? ?? ?? ?? 66 0F 58 D3 66 0F 28 2D ?? ?? ?? ?? 66 0F 28 F2 66 0F 29 4C 24 20 66 0F 5C D3 48 8D 44 24 20 66 0F 28 CE 66 0F 59 E2 66 0F 57 DB 66 0F C2 3D ?? ?? ?? ?? 05 66 0F 73 F6 04 66 0F 29 4C 24 30 66 0F 59 EA 66 0F FB D9 66 0F 5C C4 66 41 0F 7E F0 66 0F 5C C5 66 0F 50 CF 66 0F FE 0D ?? ?? ?? ?? 41 81 E0 F0 03 00 00 66 0F 15 F6 66 0F FE 1D ?? ?? ?? ?? 66 0F 73 F1 2E 66 0F 7E F2 66 43 0F 28 3C 10 81 E2 F0 03 00 00 66 0F 73 F3 2E 66 0F 29 44 24 40 41 F7 D8 66 42 0F 28 34 12 41 81 C0 00 04 00 00 66 0F DB 0D ?? ?? ?? ?? 66 0F 28 EF F7 DA 66 0F DB 1D ?? ?? ?? ?? 66 0F C6 EE 00 81 C2 00 04 00 00 66 43 0F 28 24 10 66 0F C6 FE 03 66 42 0F 28 14 12 66 0F 59 E9 66 0F 28 F4 66 0F 59 F9 66 0F C6 E2 00 66 0F 29 6C 24 50 66 0F 28 C8 66 0F C6 F2 03 66 0F 59 E3 66 0F 28 15 ?? ?? ?? ?? 66 0F 59 C0 66 0F 29 64 24 60 66 0F 59 F3 66 0F 58 EF 66 0F 28 1D ?? ?? ?? ?? 83 F9 03 66 0F 59 D0 66 0F 58 E6 0F 84 B9 00 00 00 66 0F 29 7C 24 70 66 0F 59 D8 66 0F 58 15 ?? ?? ?? ?? 66 0F 28 FD 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 D0 66 0F 58 EC 66 0F 59 C3 66 0F 5C FC 66 0F 59 D1 66 0F 28 D8 66 0F 58 D1 66 0F 59 DD 66 0F 28 CA 66 0F 59 D7 66 0F 28 20 66 0F 59 C7 66 0F 58 DA 66 0F 59 CD 66 0F 28 7C 24 70 66 0F 58 DE 66 0F 28 6C 24 60 66 0F 58 DF 66 0F 5C F7 66 0F 28 54 24 50 66 0F 58 DD 66 0F 5C C6 66 0F 54 25 ?? ?? ?? ?? 66 0F 58 DA 66 0F 5C EA 66 0F 58 C1 66 0F 5C C5 66 0F 5E C3 83 F9 01 66 0F 56 C4 7D 02 EB 4B 7F 0A 66 0F 28 3D ?? ?? ?? ?? EB 0E 66 0F 28 3D ?? ?? ?? ?? EB 04 66 0F 57 FF 66 0F 28 08 66 0F 54 C7 66 0F 28 15 ?? ?? ?? ?? 66 0F 57 DB 66 0F 54 D1 66 0F 55 3D ?? ?? ?? ?? 66 0F C2 D9 03 66 0F 56 C7 66 0F 56 C2 66 0F 56 C3 0F 28 B4 24 90 00 00 00 0F 28 BC 24 80 00 00 00 48 81 C4 A8 00 00 00 C3 }
	condition:
		$1
}

rule file_260_0_0 {
	meta:
		name = "__common_dacos_cout_rare"
		size = 2720
		refs = "006b _vmldACosHATab 0a02 _2il0floatpacket_190"
	strings:
		$1 = { 55 48 81 EC D0 00 00 00 48 8D 6C 24 20 33 C0 44 0F B7 41 06 41 81 E0 F0 7F 00 00 48 89 BD A0 00 00 00 41 81 F8 F0 7F 00 00 44 0F 29 7D 60 44 0F 29 75 70 44 0F 29 AD 80 00 00 00 44 0F 29 A5 90 00 00 00 44 0F 29 5D 30 44 0F 29 55 40 0F 29 75 50 F2 0F 10 01 48 8B 39 0F 84 1C 0A 00 00 48 89 7D 18 48 C1 EF 38 F2 44 0F 10 2D ?? ?? ?? ?? 83 E7 7F 40 88 7D 1F F2 44 0F 10 5D 18 4C 8B 0D ?? ?? ?? ?? 66 45 0F 2F EB 0F 86 67 09 00 00 F2 0F 10 05 ?? ?? ?? ?? 66 41 0F 2F C3 0F 86 10 04 00 00 66 44 0F 2F 1D ?? ?? ?? ?? 0F 86 B4 03 00 00 F2 44 0F 10 2D ?? ?? ?? ?? 41 0F 28 C3 F2 41 0F 59 C5 41 0F 28 D3 F2 0F 11 45 10 45 0F 28 FB F2 0F 10 65 10 41 0F 28 DD F2 44 0F 10 15 ?? ?? ?? ?? F2 0F 5C 65 18 F2 0F 11 65 08 F2 0F 10 4D 10 F2 44 0F 10 65 08 F2 41 0F 5C CC F2 0F 11 4D 10 F2 0F 10 75 10 F2 0F 5C D6 F2 0F 11 55 08 F2 0F 10 6D 10 0F 28 D5 F2 44 0F 58 FD F2 0F 59 D5 F2 44 0F 10 75 08 0F 28 C2 F2 45 0F 59 FE F2 0F 59 DA F2 41 0F 58 C7 F2 44 0F 59 D0 F2 0F 11 5D 10 F2 0F 10 65 10 F2 44 0F 58 15 ?? ?? ?? ?? F2 0F 5C E2 F2 44 0F 59 D0 F2 0F 11 65 08 F2 0F 10 4D 10 F2 44 0F 10 65 08 F2 44 0F 58 15 ?? ?? ?? ?? F2 41 0F 5C CC F2 44 0F 59 D0 F2 0F 11 4D 10 F2 0F 10 75 10 F2 44 0F 58 15 ?? ?? ?? ?? F2 0F 5C D6 F2 44 0F 59 D0 F2 0F 11 55 08 41 0F 28 F3 F2 0F 10 65 10 F2 0F 10 5D 08 F2 44 0F 59 F4 F2 44 0F 58 15 ?? ?? ?? ?? F2 44 0F 58 FB F2 0F 59 EC F2 44 0F 59 D0 F2 41 0F 59 F7 F2 44 0F 58 15 ?? ?? ?? ?? F2 41 0F 58 F6 F2 44 0F 59 D0 45 0F 28 F5 F2 44 0F 58 15 ?? ?? ?? ?? F2 44 0F 59 F5 F2 44 0F 59 D0 F2 44 0F 11 75 10 F2 44 0F 10 65 10 F2 44 0F 5C E5 F2 44 0F 58 15 ?? ?? ?? ?? F2 44 0F 11 65 08 44 0F 28 E5 F2 0F 10 55 10 F2 0F 58 EE F2 44 0F 59 D0 F2 44 0F 59 FD F2 44 0F 58 15 ?? ?? ?? ?? F2 0F 10 4D 08 F2 44 0F 59 D0 F2 0F 5C D1 F2 0F 11 55 10 F2 0F 10 5D 10 F2 44 0F 5C E3 0F 28 DC F2 44 0F 58 15 ?? ?? ?? ?? F2 44 0F 11 65 08 F2 0F 10 4D 10 F2 0F 10 55 08 44 0F 28 F2 F2 0F 59 D9 F2 44 0F 58 F6 F2 44 0F 59 D0 F2 41 0F 59 E6 F2 44 0F 59 EB F2 44 0F 58 15 ?? ?? ?? ?? F2 41 0F 58 E7 F2 44 0F 59 D0 F2 44 0F 11 6D 10 44 0F 28 F3 F2 44 0F 10 6D 10 F2 44 0F 5C EB F2 0F 58 DC F2 44 0F 58 15 ?? ?? ?? ?? F2 0F 59 C3 F2 44 0F 59 D0 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 C5 F2 0F 10 2D ?? ?? ?? ?? F2 0F 59 EB F2 44 0F 11 6D 08 F2 0F 58 C5 F2 44 0F 10 6D 10 F2 41 0F 58 C2 F2 44 0F 10 15 ?? ?? ?? ?? F2 41 0F 59 F2 F2 41 0F 59 D2 F2 41 0F 59 CA F2 0F 58 C6 F2 44 0F 10 7D 08 F2 0F 58 C2 F2 45 0F 5C EF F2 44 0F 11 6D 10 41 0F 28 D3 F2 44 0F 10 65 10 F2 0F 58 D1 F2 45 0F 5C F4 F2 44 0F 11 75 08 F2 44 0F 10 6D 10 F2 44 0F 10 65 08 F2 0F 11 55 10 F2 0F 10 5D 10 F2 0F 11 4D 00 F2 44 0F 5C DB F2 44 0F 58 D9 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 E1 F2 44 0F 59 E9 F2 41 0F 59 CC F2 44 0F 11 5D 08 F2 0F 10 55 10 F2 44 0F 10 5D 08 F2 41 0F 58 C3 F2 0F 58 C4 0F 28 E2 F2 41 0F 58 E5 F2 0F 58 C1 F2 0F 11 65 10 F2 44 0F 10 5D 10 F2 41 0F 5C D3 F2 41 0F 58 D5 F2 0F 11 55 08 F2 0F 10 65 10 F2 0F 10 29 F2 0F 10 5D 08 66 0F 2F 2D ?? ?? ?? ?? F2 0F 58 C3 76 42 F2 0F 10 1D ?? ?? ?? ?? 0F 28 CB F2 0F 5C CC F2 0F 11 4D 10 F2 0F 10 55 10 F2 0F 10 0D ?? ?? ?? ?? F2 0F 5C DA F2 0F 5C C8 F2 0F 5C DC F2 0F 11 5D 08 F2 0F 10 55 10 F2 0F 10 65 08 F2 0F 58 CC EB 40 F2 0F 10 1D ?? ?? ?? ?? 0F 28 CC F2 0F 58 CB F2 0F 11 4D 10 F2 0F 10 55 10 F2 0F 5C DA F2 0F 58 DC F2 0F 10 25 ?? ?? ?? ?? F2 0F 58 C4 F2 0F 11 5D 08 F2 0F 10 55 10 F2 0F 10 4D 08 F2 0F 58 C8 F2 0F 58 D1 F2 0F 11 12 E9 BC 05 00 00 F2 0F 10 0D ?? ?? ?? ?? F2 45 0F 58 EB F2 44 0F 11 6D 10 F2 0F 10 45 10 F2 0F 59 45 18 F2 0F 11 45 00 40 8A 7D 07 8A 49 07 40 80 E7 7F 80 E1 80 40 0A F9 40 88 7D 07 F2 0F 5C 4D 00 F2 0F 58 0D ?? ?? ?? ?? F2 0F 11 0A E9 6F 05 00 00 4D 8B D1 F2 45 0F 5C EB F2 41 0F 59 C5 F2 0F 11 45 00 44 0F B7 45 06 41 81 E0 F0 7F 00 00 41 C1 E8 04 41 81 C0 01 FC FF FF 45 8B D8 41 8B F8 41 F7 DB 41 81 C3 FF 03 00 00 49 C1 EA 30 41 81 E3 FF 07 00 00 41 C1 E3 04 41 81 E2 0F 80 FF FF 4C 89 4D 18 45 0B D3 66 44 89 55 1E 83 E7 01 F2 0F 10 75 18 44 8B DF F2 0F 59 C6 0F 28 E8 F2 44 0F 10 1D ?? ?? ?? ?? F2 0F 58 E8 75 03 0F 28 E8 F2 44 0F 59 DD 44 2B C7 F2 0F 10 1D ?? ?? ?? ?? 45 0F 28 D3 41 C1 E3 08 44 0F 28 E5 41 D1 E8 F2 0F 58 C3 F2 44 0F 5C D5 F2 0F 11 45 20 41 81 C0 FF 03 00 00 44 8B 55 20 41 81 E0 FF 07 00 00 41 81 E2 FF 01 00 00 F2 44 0F 11 55 08 45 03 D3 F2 0F 10 75 08 4C 8D 1D ?? ?? ?? ?? F2 44 0F 5C DE F2 47 0F 10 3C D3 41 0F 28 E3 4C 89 4D 28 41 0F 28 D7 49 C1 E9 30 F2 45 0F 5C E3 F2 45 0F 59 DF F2 41 0F 59 D7 41 C1 E0 04 41 81 E1 0F 80 FF FF 45 0B C8 66 44 89 4D 2E F2 44 0F 10 75 28 F2 45 0F 59 DE F2 0F 59 E2 F2 41 0F 59 D4 F2 0F 5C 25 ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? F2 0F 58 E2 0F 28 C1 F2 41 0F 59 C3 F2 0F 11 45 10 F2 44 0F 10 55 10 F2 0F 10 35 ?? ?? ?? ?? F2 45 0F 5C D3 F2 0F 59 F4 F2 44 0F 11 55 08 F2 44 0F 10 15 ?? ?? ?? ?? F2 45 0F 59 D5 F2 0F 58 35 ?? ?? ?? ?? F2 0F 59 F4 F2 44 0F 58 15 ?? ?? ?? ?? F2 45 0F 59 D5 F2 0F 58 35 ?? ?? ?? ?? F2 0F 59 F4 F2 44 0F 58 15 ?? ?? ?? ?? F2 45 0F 59 D5 F2 0F 58 35 ?? ?? ?? ?? F2 0F 59 F4 F2 44 0F 58 15 ?? ?? ?? ?? F2 45 0F 59 D5 F2 0F 58 35 ?? ?? ?? ?? F2 0F 59 F4 F2 44 0F 58 15 ?? ?? ?? ?? F2 45 0F 59 D5 F2 0F 58 35 ?? ?? ?? ?? F2 0F 59 F4 F2 44 0F 58 15 ?? ?? ?? ?? F2 45 0F 59 D5 F2 0F 58 35 ?? ?? ?? ?? F2 0F 59 F4 F2 44 0F 58 15 ?? ?? ?? ?? F2 45 0F 59 D5 F2 41 0F 59 F7 F2 45 0F 59 FC F2 44 0F 58 15 ?? ?? ?? ?? F2 0F 59 F5 F2 45 0F 59 D5 F2 41 0F 58 F7 F2 44 0F 58 15 ?? ?? ?? ?? F2 41 0F 59 F6 F2 45 0F 59 D5 F2 0F 10 55 10 F2 0F 10 5D 08 F2 44 0F 10 25 ?? ?? ?? ?? F2 0F 5C D3 F2 44 0F 58 15 ?? ?? ?? ?? F2 44 0F 58 25 ?? ?? ?? ?? F2 45 0F 59 D5 F2 45 0F 59 E5 F2 44 0F 58 15 ?? ?? ?? ?? F2 45 0F 59 D5 F2 0F 11 55 10 0F 28 D1 F2 0F 10 65 10 F2 0F 10 1D ?? ?? ?? ?? F2 44 0F 5C DC F2 41 0F 59 D5 F2 44 0F 58 15 ?? ?? ?? ?? 44 0F 28 FB F2 44 0F 11 5D 08 F2 44 0F 10 5D 10 F2 0F 10 6D 08 F2 0F 11 55 10 F2 0F 58 F5 F2 45 0F 59 D5 F2 44 0F 58 3D ?? ?? ?? ?? F2 0F 10 65 10 F2 45 0F 58 FC F2 45 0F 59 D5 F2 41 0F 5C E5 F2 45 0F 59 FD F2 45 0F 59 D5 F2 0F 10 05 ?? ?? ?? ?? 45 0F 28 E5 44 0F 28 F0 F2 0F 11 65 08 F2 0F 10 6D 10 F2 0F 10 55 08 F2 44 0F 58 35 ?? ?? ?? ?? F2 0F 5C EA F2 45 0F 58 F7 F2 0F 11 6D 10 44 0F 28 F9 F2 0F 10 65 10 F2 45 0F 58 F2 F2 44 0F 5C E4 F2 41 0F 59 F6 F2 44 0F 11 65 08 F2 44 0F 10 75 10 41 0F 28 EE 41 0F 28 E6 F2 41 0F 59 EE F2 41 0F 58 E5 F2 44 0F 59 F3 F2 44 0F 59 FD F2 0F 10 55 08 F2 44 0F 11 7D 10 F2 44 0F 10 65 10 F2 0F 59 E2 F2 44 0F 5C E5 F2 0F 59 DA F2 44 0F 11 65 08 F2 44 0F 10 65 10 F2 44 0F 10 7D 08 F2 0F 10 15 ?? ?? ?? ?? F2 45 0F 5C E7 F2 41 0F 59 D5 F2 44 0F 11 65 10 F2 44 0F 10 7D 10 F2 41 0F 5C EF 45 0F 28 FE F2 0F 58 15 ?? ?? ?? ?? F2 0F 11 6D 08 F2 44 0F 10 65 10 F2 44 0F 59 25 ?? ?? ?? ?? F2 41 0F 59 D5 F2 45 0F 58 FC F2 0F 58 15 ?? ?? ?? ?? F2 0F 10 6D 08 F2 41 0F 58 D2 F2 0F 58 EC F2 41 0F 59 D3 F2 0F 59 2D ?? ?? ?? ?? F2 44 0F 11 7D 10 F2 44 0F 10 7D 10 F2 44 0F 11 65 20 F2 45 0F 5C F7 F2 45 0F 58 F4 F2 44 0F 11 75 08 44 0F 28 F0 F2 44 0F 10 7D 10 F2 44 0F 10 65 08 F2 45 0F 58 F7 F2 44 0F 11 75 10 F2 44 0F 10 75 10 F2 41 0F 5C C6 F2 41 0F 58 C7 F2 0F 11 45 08 F2 44 0F 10 75 10 F2 41 0F 59 CE F2 44 0F 10 7D 08 F2 0F 11 4D 10 F2 0F 10 4D 10 F2 41 0F 5C CE F2 0F 11 4D 08 F2 0F 10 4D 10 F2 0F 10 45 08 F2 0F 5C C8 F2 0F 11 4D 10 F2 0F 10 45 10 F2 44 0F 5C F0 F2 44 0F 11 75 08 F2 0F 10 45 10 F2 44 0F 10 75 08 F2 44 0F 10 29 F2 45 0F 58 F4 66 44 0F 2F 2D ?? ?? ?? ?? F2 45 0F 58 F7 F2 44 0F 58 F3 F2 44 0F 58 F5 F2 45 0F 59 F3 F2 44 0F 59 D8 F2 41 0F 58 F6 F2 0F 58 F2 77 4C F2 0F 10 15 ?? ?? ?? ?? 0F 28 C2 F2 0F 10 25 ?? ?? ?? ?? F2 41 0F 5C C3 F2 0F 5C E6 F2 0F 11 45 10 F2 0F 10 4D 10 F2 44 0F 11 5D 00 F2 0F 5C D1 F2 41 0F 5C D3 F2 0F 11 55 08 F2 44 0F 10 5D 10 F2 0F 10 5D 08 0F 28 F3 F2 0F 58 F4 F2 44 0F 58 DE F2 44 0F 11 1A EB 2B 66 41 0F 2E C5 7A 02 74 70 44 0F 57 2D ?? ?? ?? ?? 66 41 0F 2E C5 7A 02 74 49 B8 01 00 00 00 F2 0F 5C C0 F2 0F 5E C0 F2 0F 11 02 0F 28 75 50 44 0F 28 55 40 44 0F 28 5D 30 44 0F 28 A5 90 00 00 00 44 0F 28 AD 80 00 00 00 44 0F 28 75 70 44 0F 28 7D 60 48 8B BD A0 00 00 00 48 8D A5 B0 00 00 00 5D C3 F2 0F 10 05 ?? ?? ?? ?? F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 02 EB B2 48 8B 0D ?? ?? ?? ?? 48 89 0A EB A6 F2 0F 5E C0 F2 0F 11 02 F7 41 04 FF FF 0F 00 75 95 BA 01 00 00 00 33 C0 83 39 00 0F 44 C2 EB 86 66 0F 1F 44 00 00 }
	condition:
		$1
}

rule file_261_0_0 {
	meta:
		name = "__common_dtanh_cout_rare"
		size = 128
		refs = "0003 _imldTanhHATab"
	strings:
		$1 = { 4C 8D 05 ?? ?? ?? ?? 8A 41 07 24 80 C0 E8 07 44 0F B6 C8 0F B7 41 06 25 F0 7F 00 00 C1 E8 04 4F 8B 04 C8 3D FF 07 00 00 74 27 3D FE 07 00 00 75 05 4C 89 02 EB 18 F2 0F 10 09 F2 0F 10 05 ?? ?? ?? ?? F2 0F 58 C1 F2 0F 59 C8 F2 0F 11 0A 33 C0 C3 F7 41 04 FF FF 0F 00 75 0A 83 39 00 75 05 4C 89 02 EB EA F2 0F 10 01 F2 0F 58 C0 F2 0F 11 02 EB DC 66 66 66 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_264_0_0 {
	meta:
		name = "__avx_coshf8"
		size = 576
		refs = "0036 __common_scosh_data 0232 __common_scosh_cout_rare"
	strings:
		$1 = { 48 81 EC 18 02 00 00 C5 7C 11 A4 24 D0 01 00 00 C5 FC 11 BC 24 B0 01 00 00 C5 FC 11 B4 24 F0 01 00 00 4C 89 AC 24 10 02 00 00 4C 8D AC 24 4F 01 00 00 C5 FC 10 0D ?? ?? ?? ?? 49 83 E5 C0 C5 FC 10 1D ?? ?? ?? ?? C5 F8 10 15 ?? ?? ?? ?? C5 F8 10 35 ?? ?? ?? ?? C5 F4 55 E0 C5 5C 59 25 ?? ?? ?? ?? C5 9C 58 EB C5 59 66 E2 C4 E3 7D 19 E1 01 C5 D9 76 FA C5 99 EB FF C5 71 66 E2 C5 F1 76 D2 C5 99 EB CA C5 41 6B E1 C5 C1 EF FF C5 99 63 D7 C5 54 5C E3 C5 F9 D7 D2 C5 9C 59 1D ?? ?? ?? ?? C5 DC 5C FB C5 9C 59 25 ?? ?? ?? ?? C5 44 5C E4 C5 E9 72 F5 17 C4 E3 7D 19 EF 01 C5 C9 FE EA C5 E1 72 F7 17 C5 C9 FA CA C4 C1 1C 59 FC C5 C9 FE E3 C5 C9 FA F3 C5 C4 59 15 ?? ?? ?? ?? C5 EC 58 1D ?? ?? ?? ?? C4 E3 75 18 F6 01 C5 E4 59 CF C5 C4 59 1D ?? ?? ?? ?? C4 C1 74 59 D4 C4 41 6C 58 E4 C4 E3 55 18 E4 01 C5 DC 5C EE C5 DC 58 F6 C5 E4 58 25 ?? ?? ?? ?? C4 41 54 59 E4 C5 DC 59 CF C5 F4 58 15 ?? ?? ?? ?? C5 EC 59 FF C5 C4 59 CE C5 9C 58 D1 C5 EC 58 CE 84 D2 75 2F C5 FC 10 B4 24 F0 01 00 00 C5 FC 10 BC 24 B0 01 00 00 C5 7C 10 A4 24 D0 01 00 00 4C 8B AC 24 10 02 00 00 C5 FC 28 C1 48 81 C4 18 02 00 00 C3 C4 C1 7C 11 45 00 C4 C1 7C 11 4D 40 85 D2 74 C1 33 C0 C5 7C 11 84 24 E0 00 00 00 C5 7C 11 8C 24 C0 00 00 00 C5 7C 11 94 24 A0 00 00 00 C5 7C 11 9C 24 80 00 00 00 C5 7C 11 6C 24 60 C5 7C 11 74 24 40 C5 7C 11 7C 24 20 48 89 9C 24 08 01 00 00 8B D8 48 89 B4 24 00 01 00 00 8B F2 0F A3 DE 72 58 FF C3 83 FB 20 7C F4 C5 7C 10 84 24 E0 00 00 00 C5 7C 10 8C 24 C0 00 00 00 C5 7C 10 94 24 A0 00 00 00 C5 7C 10 9C 24 80 00 00 00 C5 7C 10 6C 24 60 C5 7C 10 74 24 40 C5 7C 10 7C 24 20 C4 C1 7C 10 4D 40 48 8B 9C 24 08 01 00 00 48 8B B4 24 00 01 00 00 E9 18 FF FF FF C5 F8 77 49 8D 4C 9D 00 49 8D 54 9D 40 E8 ?? ?? ?? ?? EB 94 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_270_0_0 {
	meta:
		name = "__GSHandlerCheck_SEH_noexcept"
		size = 102
		refs = "002d __GSHandlerCheck_SEH 0059 terminate"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 4C 8B 4C 24 58 4C 8B 44 24 50 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 89 44 24 20 48 8B 44 24 40 8B 40 04 83 E0 66 85 C0 75 19 48 8B 44 24 40 81 38 63 73 6D E0 75 0C 83 7C 24 20 01 75 05 E8 ?? ?? ?? ?? 8B 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_2_0_4 {
	meta:
		name = "__C_specific_handler_noexcept"
		size = 102
		refs = "002d __C_specific_handler 0059 terminate"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 4C 8B 4C 24 58 4C 8B 44 24 50 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 89 44 24 20 48 8B 44 24 40 8B 40 04 83 E0 66 85 C0 75 19 48 8B 44 24 40 81 38 63 73 6D E0 75 0C 83 7C 24 20 01 75 05 E8 ?? ?? ?? ?? 8B 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_277_1_0 {
	meta:
		name = "?__scrt_uninitialize_type_info@@YAXXZ"
		size = 21
		refs = "0007 ?__type_info_root_node@@3U__type_info_node@@A 000c __std_type_info_destroy_list"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_39_37_1 {
	meta:
		name = "??__E_Fac_tidy_reg@std@@YAXXZ"
		size = 21
		refs = "0007 ??__F_Fac_tidy_reg@std@@YAXXZ 000c atexit"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_63_1_3 {
	meta:
		name = "??__Einit_atexit@@YAXXZ"
		size = 21
		refs = "0007 ??__Finit_atexit@@YAXXZ 000c atexit"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_164_1 {
	meta:
		name = "??__Einit_cerr@std@@YAXXZ"
		size = 21
		refs = "0007 ?init_cerr@std@@3U_Init_cerr@1@A 000c ??0_Init_cerr@std@@QEAA@XZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_47_197_3 {
	meta:
		name = "??__Einit_cin@std@@YAXXZ"
		size = 21
		refs = "0007 ?init_cin@std@@3U_Init_cin@1@A 000c ??0_Init_cin@std@@QEAA@XZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_101_190_2 {
	meta:
		name = "??__Einit_clog@std@@YAXXZ"
		size = 21
		refs = "0007 ?init_clog@std@@3U_Init_clog@1@A 000c ??0_Init_clog@std@@QEAA@XZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_46_197_3 {
	meta:
		name = "??__Einit_cout@std@@YAXXZ"
		size = 21
		refs = "0007 ?init_cout@std@@3U_Init_cout@1@A 000c ??0_Init_cout@std@@QEAA@XZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_99_160_1 {
	meta:
		name = "??__Einit_ushcerr@std@@YAXXZ"
		size = 21
		refs = "0007 ?init_ushcerr@std@@3U_Init_ushcerr@1@A 000c ??0_Init_ushcerr@std@@QEAA@XZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_117_160_1 {
	meta:
		name = "??__Einit_ushcin@std@@YAXXZ"
		size = 21
		refs = "0007 ?init_ushcin@std@@3U_Init_ushcin@1@A 000c ??0_Init_ushcin@std@@QEAA@XZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_41_186_2 {
	meta:
		name = "??__Einit_ushclog@std@@YAXXZ"
		size = 21
		refs = "0007 ?init_ushclog@std@@3U_Init_ushclog@1@A 000c ??0_Init_ushclog@std@@QEAA@XZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_24_206_3 {
	meta:
		name = "??__Einit_ushcout@std@@YAXXZ"
		size = 21
		refs = "0007 ?init_ushcout@std@@3U_Init_ushcout@1@A 000c ??0_Init_ushcout@std@@QEAA@XZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_107_206_3 {
	meta:
		name = "??__Einit_wcerr@std@@YAXXZ"
		size = 21
		refs = "0007 ?init_wcerr@std@@3U_Init_wcerr@1@A 000c ??0_Init_wcerr@std@@QEAA@XZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_48_186_2 {
	meta:
		name = "??__Einit_wcin@std@@YAXXZ"
		size = 21
		refs = "0007 ?init_wcin@std@@3U_Init_wcin@1@A 000c ??0_Init_wcin@std@@QEAA@XZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_63_160_1 {
	meta:
		name = "??__Einit_wclog@std@@YAXXZ"
		size = 21
		refs = "0007 ?init_wclog@std@@3U_Init_wclog@1@A 000c ??0_Init_wclog@std@@QEAA@XZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_116_206_3 {
	meta:
		name = "??__Einit_wcout@std@@YAXXZ"
		size = 21
		refs = "0007 ?init_wcout@std@@3U_Init_wcout@1@A 000c ??0_Init_wcout@std@@QEAA@XZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_108_72_1 {
	meta:
		name = "??__F?m_badAllocExceptionPtr@__ExceptionPtr@@0V?$shared_ptr@V__ExceptionPtr@@@std@@A@@YAXXZ"
		size = 21
		refs = "0007 ?m_badAllocExceptionPtr@__ExceptionPtr@@0V?$shared_ptr@V__ExceptionPtr@@@std@@A 000c ??1?$shared_ptr@V__ExceptionPtr@@@std@@QEAA@XZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_33_39_2 {
	meta:
		name = "??__F_Fac_tidy_reg@std@@YAXXZ"
		size = 21
		refs = "0007 ?_Fac_tidy_reg@std@@3U_Fac_tidy_reg_t@1@B 000c ??1_Fac_tidy_reg_t@std@@QEAA@XZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_118_109_2 {
	meta:
		name = "??__F_Static@?1???$_Immortalize@V_Generic_error_category@std@@@std@@YAAEAV_Generic_error_category@0@XZ@YAXXZ"
		size = 21
		refs = "0007 ?_Static@?1???$_Immortalize@V_Generic_error_category@std@@@std@@YAAEAV_Generic_error_category@1@XZ@4U?$_Immortalizer@V_Generic_error_category@std@@@1@A 000c ??1?$_Immortalizer@V_Generic_error_category@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_88_190_2 {
	meta:
		name = "??__F_Static@?1???$_Immortalize@V_Iostream_error_category@std@@@std@@YAAEAV_Iostream_error_category@0@XZ@YAXXZ"
		size = 21
		refs = "0007 ?_Static@?1???$_Immortalize@V_Iostream_error_category@std@@@std@@YAAEAV_Iostream_error_category@1@XZ@4U?$_Immortalizer@V_Iostream_error_category@std@@@1@A 000c ??1?$_Immortalizer@V_Iostream_error_category@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_36_112_3 {
	meta:
		name = "??__F_Static@?1???$_Immortalize@V_System_error_category@std@@@std@@YAAEAV_System_error_category@0@XZ@YAXXZ"
		size = 21
		refs = "0007 ?_Static@?1???$_Immortalize@V_System_error_category@std@@@std@@YAAEAV_System_error_category@1@XZ@4U?$_Immortalizer@V_System_error_category@std@@@1@A 000c ??1?$_Immortalizer@V_System_error_category@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_5_200_3 {
	meta:
		name = "??__Fcerr@std@@YAXXZ"
		size = 21
		refs = "0007 ?cerr@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A 000c ??_D?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAXXZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_60_167_1 {
	meta:
		name = "??__Fcin@std@@YAXXZ"
		size = 21
		refs = "0007 ?cin@std@@3V?$basic_istream@DU?$char_traits@D@std@@@1@A 000c ??_D?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAXXZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_33_40_2 {
	meta:
		name = "??__Fclassic_locale@std@@YAXXZ"
		size = 21
		refs = "0007 ?classic_locale@std@@3Vlocale@1@A 000c ??1locale@std@@QEAA@XZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_101_193_2 {
	meta:
		name = "??__Fclog@std@@YAXXZ"
		size = 21
		refs = "0007 ?clog@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A 000c ??_D?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAXXZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_3_167_1 {
	meta:
		name = "??__Fcout@std@@YAXXZ"
		size = 21
		refs = "0007 ?cout@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A 000c ??_D?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAXXZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_168_1 {
	meta:
		name = "??__Fferr@std@@YAXXZ"
		size = 21
		refs = "0007 ?ferr@std@@3V?$basic_filebuf@DU?$char_traits@D@std@@@1@A 000c ??1?$basic_filebuf@DU?$char_traits@D@std@@@std@@UEAA@XZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_47_201_3 {
	meta:
		name = "??__Ffin@std@@YAXXZ"
		size = 21
		refs = "0007 ?fin@std@@3V?$basic_filebuf@DU?$char_traits@D@std@@@1@A 000c ??1?$basic_filebuf@DU?$char_traits@D@std@@@std@@UEAA@XZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_90_201_3 {
	meta:
		name = "??__Fflog@std@@YAXXZ"
		size = 21
		refs = "0007 ?flog@std@@3V?$basic_filebuf@DU?$char_traits@D@std@@@1@A 000c ??1?$basic_filebuf@DU?$char_traits@D@std@@@std@@UEAA@XZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_3_168_1 {
	meta:
		name = "??__Ffout@std@@YAXXZ"
		size = 21
		refs = "0007 ?fout@std@@3V?$basic_filebuf@DU?$char_traits@D@std@@@1@A 000c ??1?$basic_filebuf@DU?$char_traits@D@std@@@std@@UEAA@XZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_114_3_2 {
	meta:
		name = "??__Finit_atexit@@YAXXZ"
		size = 21
		refs = "0007 ?init_atexit@@3U_Init_atexit@@A 000c ??1_Init_atexit@@QEAA@XZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_5_165_1 {
	meta:
		name = "??__Finitlocks@@YAXXZ"
		size = 21
		refs = "0007 ?initlocks@@3V_Init_locks@std@@A 000c ??1_Init_locks@std@@QEAA@XZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_63_4_3 {
	meta:
		name = "??__Finitlocks@std@@YAXXZ"
		size = 21
		refs = "0007 ?initlocks@std@@3V_Init_locks@1@A 000c ??1_Init_locks@std@@QEAA@XZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_107_212_3 {
	meta:
		name = "??__Fwcerr@std@@YAXXZ"
		size = 21
		refs = "0007 ?wcerr@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 000c ??_D?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAXXZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_50_192_2 {
	meta:
		name = "??__Fwcerr@std@@YAXXZ"
		size = 21
		refs = "0007 ?wcerr@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A 000c ??_D?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAXXZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_4_166_1 {
	meta:
		name = "??__Fwcerr@std@@YAXXZ"
		size = 21
		refs = "0007 ?wcerr@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 000c ??_D?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAXXZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_99_166_1 {
	meta:
		name = "??__Fwcerr@std@@YAXXZ"
		size = 21
		refs = "0007 ?wcerr@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A 000c ??_D?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAXXZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_48_192_2 {
	meta:
		name = "??__Fwcin@std@@YAXXZ"
		size = 21
		refs = "0007 ?wcin@std@@3V?$basic_istream@_WU?$char_traits@_W@std@@@1@A 000c ??_D?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAXXZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_117_166_1 {
	meta:
		name = "??__Fwcin@std@@YAXXZ"
		size = 21
		refs = "0007 ?wcin@std@@3V?$basic_istream@GU?$char_traits@G@std@@@1@A 000c ??_D?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAXXZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_91_166_1 {
	meta:
		name = "??__Fwcin@std@@YAXXZ"
		size = 21
		refs = "0007 ?wcin@std@@3V?$basic_istream@_WU?$char_traits@_W@std@@@1@A 000c ??_D?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAXXZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_29_212_3 {
	meta:
		name = "??__Fwcin@std@@YAXXZ"
		size = 21
		refs = "0007 ?wcin@std@@3V?$basic_istream@GU?$char_traits@G@std@@@1@A 000c ??_D?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAXXZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_41_192_2 {
	meta:
		name = "??__Fwclog@std@@YAXXZ"
		size = 21
		refs = "0007 ?wclog@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A 000c ??_D?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAXXZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_76_192_2 {
	meta:
		name = "??__Fwclog@std@@YAXXZ"
		size = 21
		refs = "0007 ?wclog@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 000c ??_D?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAXXZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_8_212_3 {
	meta:
		name = "??__Fwclog@std@@YAXXZ"
		size = 21
		refs = "0007 ?wclog@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A 000c ??_D?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAXXZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_69_212_3 {
	meta:
		name = "??__Fwclog@std@@YAXXZ"
		size = 21
		refs = "0007 ?wclog@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 000c ??_D?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAXXZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_77_166_1 {
	meta:
		name = "??__Fwclog@std@@YAXXZ"
		size = 21
		refs = "0007 ?wclog@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A 000c ??_D?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAXXZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_63_166_1 {
	meta:
		name = "??__Fwclog@std@@YAXXZ"
		size = 21
		refs = "0007 ?wclog@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 000c ??_D?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAXXZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_116_212_3 {
	meta:
		name = "??__Fwcout@std@@YAXXZ"
		size = 21
		refs = "0007 ?wcout@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 000c ??_D?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAXXZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_82_192_2 {
	meta:
		name = "??__Fwcout@std@@YAXXZ"
		size = 21
		refs = "0007 ?wcout@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A 000c ??_D?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAXXZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_114_166_1 {
	meta:
		name = "??__Fwcout@std@@YAXXZ"
		size = 21
		refs = "0007 ?wcout@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 000c ??_D?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAXXZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_66_213_3 {
	meta:
		name = "??__Fwferr@std@@YAXXZ"
		size = 21
		refs = "0007 ?wferr@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A 000c ??1?$basic_filebuf@GU?$char_traits@G@std@@@std@@UEAA@XZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_86_193_2 {
	meta:
		name = "??__Fwferr@std@@YAXXZ"
		size = 21
		refs = "0007 ?wferr@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A 000c ??1?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UEAA@XZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_99_167_1 {
	meta:
		name = "??__Fwferr@std@@YAXXZ"
		size = 21
		refs = "0007 ?wferr@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A 000c ??1?$basic_filebuf@GU?$char_traits@G@std@@@std@@UEAA@XZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_4_167_1 {
	meta:
		name = "??__Fwferr@std@@YAXXZ"
		size = 21
		refs = "0007 ?wferr@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A 000c ??1?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UEAA@XZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_50_193_2 {
	meta:
		name = "??__Fwferr@std@@YAXXZ"
		size = 21
		refs = "0007 ?wferr@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A 000c ??1?$basic_filebuf@GU?$char_traits@G@std@@@std@@UEAA@XZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_40_193_2 {
	meta:
		name = "??__Fwfin@std@@YAXXZ"
		size = 21
		refs = "0007 ?wfin@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A 000c ??1?$basic_filebuf@GU?$char_traits@G@std@@@std@@UEAA@XZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_48_193_2 {
	meta:
		name = "??__Fwfin@std@@YAXXZ"
		size = 21
		refs = "0007 ?wfin@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A 000c ??1?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UEAA@XZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_117_167_1 {
	meta:
		name = "??__Fwfin@std@@YAXXZ"
		size = 21
		refs = "0007 ?wfin@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A 000c ??1?$basic_filebuf@GU?$char_traits@G@std@@@std@@UEAA@XZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_93_213_3 {
	meta:
		name = "??__Fwfin@std@@YAXXZ"
		size = 21
		refs = "0007 ?wfin@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A 000c ??1?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UEAA@XZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_8_213_3 {
	meta:
		name = "??__Fwflog@std@@YAXXZ"
		size = 21
		refs = "0007 ?wflog@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A 000c ??1?$basic_filebuf@GU?$char_traits@G@std@@@std@@UEAA@XZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_69_213_3 {
	meta:
		name = "??__Fwflog@std@@YAXXZ"
		size = 21
		refs = "0007 ?wflog@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A 000c ??1?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UEAA@XZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_41_193_2 {
	meta:
		name = "??__Fwflog@std@@YAXXZ"
		size = 21
		refs = "0007 ?wflog@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A 000c ??1?$basic_filebuf@GU?$char_traits@G@std@@@std@@UEAA@XZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_76_193_2 {
	meta:
		name = "??__Fwflog@std@@YAXXZ"
		size = 21
		refs = "0007 ?wflog@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A 000c ??1?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UEAA@XZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_88_193_2 {
	meta:
		name = "??__Fwfout@std@@YAXXZ"
		size = 21
		refs = "0007 ?wfout@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A 000c ??1?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UEAA@XZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_24_213_3 {
	meta:
		name = "??__Fwfout@std@@YAXXZ"
		size = 21
		refs = "0007 ?wfout@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A 000c ??1?$basic_filebuf@GU?$char_traits@G@std@@@std@@UEAA@XZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_114_167_1 {
	meta:
		name = "??__Fwfout@std@@YAXXZ"
		size = 21
		refs = "0007 ?wfout@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A 000c ??1?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UEAA@XZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_82_193_2 {
	meta:
		name = "??__Fwfout@std@@YAXXZ"
		size = 21
		refs = "0007 ?wfout@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A 000c ??1?$basic_filebuf@GU?$char_traits@G@std@@@std@@UEAA@XZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_116_213_3 {
	meta:
		name = "??__Fwfout@std@@YAXXZ"
		size = 21
		refs = "0007 ?wfout@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A 000c ??1?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UEAA@XZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_278_0_0 {
	meta:
		name = "__avx_sin4"
		size = 2224
		refs = "000a __common_dsin_reduction_data 007f __common_dsin_data 0236 __common_dsin_cout_rare 0240 __common_dsin_data_ha 02a7 _2il0floatpacket_264 02fa _2il0floatpacket_265 0353 _2il0floatpacket_266 05b8 _2il0floatpacket_267 05de _2il0floatpacket_270 05f1 _2il0floatpacket_269 05fa _2il0floatpacket_268 0624 _2il0floatpacket_271 0681 _2il0floatpacket_272 0689 _2il0floatpacket_273 06e7 _2il0floatpacket_277 06fa _2il0floatpacket_274 0703 _2il0floatpacket_275 070c _2il0floatpacket_276 0767 _2il0floatpacket_278 0775 _2il0floatpacket_279"
	strings:
		$1 = { 48 81 EC B8 02 00 00 4C 8D 15 ?? ?? ?? ?? C5 7C 11 BC 24 70 01 00 00 45 33 DB C5 7C 11 B4 24 B0 01 00 00 C5 7C 11 AC 24 50 02 00 00 C5 7C 11 A4 24 90 01 00 00 C5 7C 11 9C 24 10 02 00 00 C5 7C 11 94 24 F0 01 00 00 C5 7C 11 8C 24 D0 01 00 00 C5 7C 11 84 24 90 02 00 00 C5 FC 11 BC 24 70 02 00 00 C5 FC 11 B4 24 30 02 00 00 4C 89 AC 24 B0 02 00 00 4C 8D AC 24 0F 01 00 00 C5 FD 10 0D ?? ?? ?? ?? 49 83 E5 C0 C5 7D 54 E9 C5 95 C2 15 ?? ?? ?? ?? 1E C5 F5 55 E0 C4 E3 7D 19 D3 01 C5 E8 C6 EB DD C5 F8 50 C5 85 C0 0F 85 8D 01 00 00 C5 FD 10 35 ?? ?? ?? ?? C5 95 59 2D ?? ?? ?? ?? C5 D5 58 FE C5 C5 5C DE C5 65 59 1D ?? ?? ?? ?? C5 65 59 25 ?? ?? ?? ?? C5 65 59 3D ?? ?? ?? ?? C5 E5 59 15 ?? ?? ?? ?? C4 41 15 5C EB C4 41 15 5C F4 C4 C1 0D 5C CF C5 F5 5C DA C5 E5 59 D3 C5 ED 59 35 ?? ?? ?? ?? C5 B9 73 F7 3F C4 C3 7D 19 F9 01 C5 CD 58 3D ?? ?? ?? ?? C4 C1 29 73 F1 3F C4 C3 3D 18 EA 01 C5 45 59 C2 C5 3D 58 0D ?? ?? ?? ?? C5 35 59 D2 C5 2D 58 1D ?? ?? ?? ?? C5 25 59 E2 C5 1D 58 2D ?? ?? ?? ?? C5 15 59 F2 C5 0D 58 3D ?? ?? ?? ?? C5 E5 57 CD C5 85 59 DA C5 E5 58 2D ?? ?? ?? ?? C5 D5 59 D2 C5 ED 59 F1 C5 CD 58 C9 C5 F5 57 CC 45 85 DB 75 6E C5 FC 10 B4 24 30 02 00 00 C5 FC 10 BC 24 70 02 00 00 C5 7C 10 84 24 90 02 00 00 C5 7C 10 8C 24 D0 01 00 00 C5 7C 10 94 24 F0 01 00 00 C5 7C 10 9C 24 10 02 00 00 C5 7C 10 A4 24 90 01 00 00 C5 7C 10 AC 24 50 02 00 00 C5 7C 10 B4 24 B0 01 00 00 C5 7C 10 BC 24 70 01 00 00 4C 8B AC 24 B0 02 00 00 C5 FD 28 C1 48 81 C4 B8 02 00 00 C3 C4 C1 7D 11 45 00 C4 C1 7D 11 4D 40 74 84 33 C0 48 89 5C 24 28 8B D8 48 89 74 24 20 41 8B F3 0F A3 DE 72 1C FF C3 83 FB 20 7C F4 48 8B 5C 24 28 48 8B 74 24 20 C4 C1 7D 10 4D 40 E9 52 FF FF FF C5 F8 77 49 8D 4C DD 00 49 8D 54 DD 40 E8 ?? ?? ?? ?? EB D0 C5 7D 10 15 ?? ?? ?? ?? BA 00 00 F0 7F C4 41 7D 11 6D 00 C4 C1 7D 11 65 20 C4 C1 7D 11 45 40 C5 79 6E C2 C4 C1 79 70 E0 11 C4 41 2D 54 DD C4 C1 25 C2 D2 00 C4 C3 7D 19 D1 01 C4 41 68 C6 F9 DD C4 41 78 50 DF C4 C1 59 DB FD C4 43 7D 19 EF 01 C5 89 73 D7 34 C4 C1 59 DB CF C5 E1 73 D1 34 C5 79 7E F0 C5 F9 7E D9 C5 FA 6F 25 ?? ?? ?? ?? C5 78 11 6C 24 20 C4 41 59 DB ED C4 43 79 16 F0 02 44 8D 0C 40 C4 E3 79 16 DA 02 8D 0C 49 41 C1 E1 03 C1 E1 03 47 8D 04 40 41 C1 E0 03 8D 04 52 C1 E0 03 C5 78 11 7C 24 30 C4 41 59 DB FF C4 01 F9 6E 1C 11 C4 A1 F9 6E 7C 11 10 C5 7A 6F 35 ?? ?? ?? ?? C4 A1 F9 6E 04 11 C4 21 F9 6E 64 11 08 C4 81 F9 6E 74 11 08 C4 81 21 16 14 10 C4 A1 41 16 5C 10 10 C4 41 11 D4 DE C4 C1 01 D4 FE C4 21 79 16 14 10 C5 D9 73 D3 20 C4 21 19 16 4C 10 08 C4 01 49 16 44 10 08 C4 81 F9 6E 6C 11 10 C4 C1 19 73 D0 20 C5 7A 6F 2D ?? ?? ?? ?? C4 81 51 16 4C 10 10 4C 8D 15 ?? ?? ?? ?? C4 41 29 DB F5 C4 C1 51 73 D1 20 C4 C1 39 DB F5 C4 C1 31 DB C5 C4 C1 31 73 D3 20 C4 41 21 DB C5 C4 41 41 DB DD C5 79 11 54 24 50 C5 A9 73 D7 20 C4 C1 21 F4 FE C4 41 69 DB FD C5 F9 11 54 24 40 C5 E9 73 D1 20 C4 C1 71 DB CD C4 C1 61 DB DD C5 FA 7F 84 24 A0 00 00 00 41 B8 00 00 00 80 C5 FA 7F BC 24 C0 00 00 00 C5 7A 7F 74 24 70 C5 FA 7F AC 24 90 00 00 00 C5 A1 F4 F8 C5 B1 F4 C1 C5 B1 F4 CA C5 B9 F4 D2 C5 21 F4 F5 C5 B9 F4 EE C5 B1 F4 F6 C5 7A 7F 7C 24 60 C5 E9 73 D2 20 C4 41 39 F4 FF C5 F1 D4 CA C5 7A 7F BC 24 B0 00 00 00 C5 81 73 D0 20 C4 C1 51 DB C5 C5 D1 73 D5 20 C5 F9 D4 C1 C5 81 D4 D0 C5 29 F4 FB C5 A9 F4 DC C5 A1 F4 E4 C5 D9 73 D4 20 C4 C1 41 DB C5 C5 E1 D4 CC C5 7A 7F A4 24 80 00 00 00 C4 C1 01 73 D7 20 C4 41 39 F4 E4 C5 C1 73 D7 20 C5 F9 D4 D9 C5 81 D4 E3 C5 C9 D4 DD C4 41 19 DB FD C5 F1 73 D2 20 C5 01 D4 FB C4 41 71 D4 FF C5 A9 F4 8C 24 A0 00 00 00 C5 F1 D4 F7 C5 B1 F4 8C 24 80 00 00 00 C5 31 F4 4C 24 60 C4 C1 09 DB C5 C5 E1 73 D4 20 C5 F9 D4 EE C4 C1 19 73 D4 20 C4 C1 49 73 D7 20 C5 E1 D4 FD C4 C1 71 D4 CC C5 FA 6F 9C 24 B0 00 00 00 C4 C1 09 73 D6 20 C4 C1 61 DB C5 C5 D1 73 D7 20 C5 F9 D4 C1 C5 A9 F4 8C 24 90 00 00 00 C5 29 F4 54 24 70 C5 C9 D4 F0 C4 C1 71 D4 CE C5 FA 6F 84 24 C0 00 00 00 C5 E1 73 D3 20 C4 41 79 DB E5 C5 89 73 D6 20 C5 19 D4 E1 C5 31 D4 CB C4 C1 51 D4 CC C5 F9 10 6C 24 40 C4 C1 01 73 F7 20 C5 99 73 D5 20 C4 C1 69 DB D5 C4 41 39 F4 C4 C4 C1 49 DB F5 C4 41 39 DB C5 C5 C1 73 F7 20 C4 41 39 D4 C1 C5 F9 10 6C 24 50 C5 B1 73 D1 20 C4 41 09 D4 F0 C5 B9 73 D5 20 C4 C1 19 73 F6 20 C4 41 21 F4 D8 C5 B9 73 D0 20 C4 41 29 D4 D0 C5 99 D4 F6 C4 41 21 DB F5 C4 C1 71 DB CD C4 41 09 D4 DA C5 01 D4 D2 C4 41 31 D4 CB C4 C1 79 6E D0 C4 C1 61 73 F1 20 C5 79 70 CA 11 C4 41 59 DB ED C5 61 D4 C1 C4 C1 41 D4 E5 C5 B1 DB 7C 24 20 C5 91 73 D6 0C C5 7A 6F 1D ?? ?? ?? ?? C4 C1 61 73 D0 0C C5 31 DB 7C 24 30 C4 C1 41 EF CB C4 C1 01 EF C3 C5 11 EB F1 C5 61 EB E0 C5 7A 6F 1D ?? ?? ?? ?? C4 C3 0D 18 D4 01 C4 41 01 EF E3 C5 78 10 35 ?? ?? ?? ?? C4 E2 7D 1A 2D ?? ?? ?? ?? C5 55 58 EA C5 15 5C CD C4 C1 41 EF EB C4 C1 6D 5C D1 C4 63 7D 19 E9 01 C4 41 11 DB EE C4 41 70 54 CE C5 7A 6F 35 ?? ?? ?? ?? C4 C1 09 DB DA C5 09 DB DC C5 F9 73 F3 1C C4 C1 61 73 F3 1C C5 F9 EB CD C4 C1 61 EB C4 C5 D9 73 D4 18 C5 79 7E EA C4 41 79 7E C9 C1 E2 05 C4 63 79 16 E8 02 41 C1 E1 05 C4 63 79 16 C9 02 C1 E0 05 C1 E1 05 C4 E3 75 18 C8 01 C4 43 55 18 E4 01 C4 41 75 5C F4 C5 FA 6F 0D ?? ?? ?? ?? C5 FA 6F 05 ?? ?? ?? ?? C5 01 EF D9 C5 79 DB FE C5 C1 EF D9 C4 C1 41 73 F7 28 C4 C1 49 73 D2 18 C4 41 79 DB C0 C5 41 EB D6 C4 C1 41 73 F0 28 C5 29 EB FB C5 41 EB D4 C4 41 29 EB C3 C4 C3 05 18 F8 01 C4 C3 65 18 E3 01 C5 C5 5C CC C5 ED 58 E9 C5 ED 5C D5 C5 F5 58 C2 C4 41 7D 58 D6 C4 62 7D 1A 35 ?? ?? ?? ?? C4 41 55 54 DE C4 41 55 5C FB C4 62 7D 1A 25 ?? ?? ?? ?? C4 E2 7D 1A 35 ?? ?? ?? ?? C4 E2 7D 1A 15 ?? ?? ?? ?? C4 41 4D 59 C7 C4 C1 6D 59 FB C4 C1 1D 59 E2 C4 C1 6D 59 C7 C4 C1 4D 59 CB C4 C1 7D 10 55 00 C5 BD 58 DF C5 DD 58 E8 C5 E5 58 F5 C4 81 F9 6E 5C 11 10 C4 A1 61 16 6C 11 10 C5 75 58 FE C4 C1 75 5C CF C5 F5 58 C6 C4 A1 F9 6E 0C 12 C4 21 71 16 2C 10 C4 62 7D 1A 1D ?? ?? ?? ?? C4 41 6D 54 E3 C4 62 7D 1A 35 ?? ?? ?? ?? C4 41 1D C2 D6 12 C4 C1 1D C2 E6 1E C5 2D 54 C2 C4 01 F9 6E 14 11 C4 C1 5D 54 FF C4 21 29 16 0C 11 C4 21 F9 6E 54 12 08 C5 3D 56 FF C4 01 F9 6E 44 11 08 C5 DD 54 D0 C4 A1 F9 6E 44 12 10 C4 A1 79 16 4C 10 10 C4 C3 15 18 F9 01 C4 21 29 16 4C 10 08 C4 21 39 16 6C 11 08 C4 C3 35 18 E5 01 C5 05 59 DC C4 41 45 59 CF C4 63 75 18 C5 01 C4 41 3D 58 E3 C4 41 35 58 D4 C4 C1 3D 5C F4 C4 41 1D 5C F2 C4 C1 4D 58 C3 C4 41 0D 58 E9 C5 45 58 CC C5 15 58 D8 C4 41 05 59 EF C5 95 59 0D ?? ?? ?? ?? C5 95 59 3D ?? ?? ?? ?? C5 F5 58 1D ?? ?? ?? ?? C5 45 58 25 ?? ?? ?? ?? C4 C1 65 59 ED C4 41 1D 59 F5 C4 C1 55 59 F7 C4 41 05 59 F8 C5 8D 58 3D ?? ?? ?? ?? C4 C1 4D 59 E1 C4 41 45 59 ED C4 C1 5D 58 CB C4 C1 15 59 C0 C4 21 F9 6E 44 12 18 C5 FD 58 E1 C4 C1 35 5C CF C4 01 F9 6E 7C 11 18 C4 21 39 16 4C 10 18 C5 ED 59 D1 C4 A1 01 16 44 11 18 C4 E3 35 18 D8 01 C5 ED 58 C3 C5 DD 58 C8 C4 C1 7D 10 45 40 C5 AD 58 D1 C4 C1 6D 57 4D 20 E9 C7 F8 FF FF 66 90 }
	condition:
		$1
}

rule file_279_0_0 {
	meta:
		name = "__isa_available_init"
		size = 896
		refs = "0009 __security_cookie 002f __isa_enabled 0039 __isa_available 015e __memcpy_nt_iters 0168 __favor 0376 __security_check_cookie"
	strings:
		$1 = { 40 53 48 83 EC 50 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 40 C7 44 24 30 00 00 00 00 C7 44 24 34 00 00 00 00 C7 44 24 38 00 00 00 00 C7 05 ?? ?? ?? ?? 02 00 00 00 C7 05 ?? ?? ?? ?? 01 00 00 00 33 C0 33 C9 0F A2 4C 8D 44 24 20 41 89 00 41 89 58 04 41 89 48 08 41 89 50 0C B8 04 00 00 00 48 6B C0 00 8B 44 04 20 89 44 24 10 B8 04 00 00 00 48 6B C0 01 8B 44 04 20 35 47 65 6E 75 B9 04 00 00 00 48 6B C9 03 8B 4C 0C 20 81 F1 69 6E 65 49 0B C1 B9 04 00 00 00 48 6B C9 02 8B 4C 0C 20 81 F1 6E 74 65 6C 0B C1 85 C0 75 0A C7 44 24 08 01 00 00 00 EB 08 C7 44 24 08 00 00 00 00 0F B6 44 24 08 88 04 24 B8 04 00 00 00 48 6B C0 01 8B 44 04 20 35 41 75 74 68 B9 04 00 00 00 48 6B C9 03 8B 4C 0C 20 81 F1 65 6E 74 69 0B C1 B9 04 00 00 00 48 6B C9 02 8B 4C 0C 20 81 F1 63 41 4D 44 0B C1 85 C0 75 0A C7 44 24 0C 01 00 00 00 EB 08 C7 44 24 0C 00 00 00 00 0F B6 44 24 0C 88 44 24 01 B8 01 00 00 00 33 C9 0F A2 4C 8D 44 24 20 41 89 00 41 89 58 04 41 89 48 08 41 89 50 0C B8 04 00 00 00 48 6B C0 00 8B 44 04 20 89 44 24 04 0F B6 04 24 85 C0 0F 84 89 00 00 00 48 C7 05 ?? ?? ?? ?? FF FF FF FF 8B 05 ?? ?? ?? ?? 83 C8 04 89 05 ?? ?? ?? ?? 8B 44 24 04 25 F0 3F FF 0F 3D C0 06 01 00 74 50 8B 44 24 04 25 F0 3F FF 0F 3D 60 06 02 00 74 40 8B 44 24 04 25 F0 3F FF 0F 3D 70 06 02 00 74 30 8B 44 24 04 25 F0 3F FF 0F 3D 50 06 03 00 74 20 8B 44 24 04 25 F0 3F FF 0F 3D 60 06 03 00 74 10 8B 44 24 04 25 F0 3F FF 0F 3D 70 06 03 00 75 0F 8B 05 ?? ?? ?? ?? 83 C8 01 89 05 ?? ?? ?? ?? 0F B6 44 24 01 85 C0 74 1F 8B 44 24 04 25 00 0F F0 0F 3D 00 0F 60 00 7C 0F 8B 05 ?? ?? ?? ?? 83 C8 04 89 05 ?? ?? ?? ?? B8 04 00 00 00 48 6B C0 03 B9 04 00 00 00 48 6B C9 00 8B 44 04 20 89 44 0C 30 B8 04 00 00 00 48 6B C0 02 B9 04 00 00 00 48 6B C9 01 8B 44 04 20 89 44 0C 30 83 7C 24 10 07 7C 5C B8 07 00 00 00 33 C9 0F A2 4C 8D 44 24 20 41 89 00 41 89 58 04 41 89 48 08 41 89 50 0C B8 04 00 00 00 48 6B C0 01 B9 04 00 00 00 48 6B C9 02 8B 44 04 20 89 44 0C 30 B8 04 00 00 00 48 6B C0 01 8B 44 04 20 25 00 02 00 00 85 C0 74 0F 8B 05 ?? ?? ?? ?? 83 C8 02 89 05 ?? ?? ?? ?? B8 04 00 00 00 48 6B C0 01 8B 44 04 30 25 00 00 10 00 85 C0 0F 84 AE 00 00 00 C7 05 ?? ?? ?? ?? 02 00 00 00 8B 05 ?? ?? ?? ?? 83 C8 04 89 05 ?? ?? ?? ?? B8 04 00 00 00 48 6B C0 01 8B 44 04 30 25 00 00 00 08 85 C0 74 7F B8 04 00 00 00 48 6B C0 01 8B 44 04 30 25 00 00 00 10 85 C0 74 69 33 C9 0F 01 D0 48 C1 E2 20 48 0B D0 48 8B C2 48 89 44 24 18 48 8B 44 24 18 48 83 E0 06 48 83 F8 06 75 46 C7 05 ?? ?? ?? ?? 03 00 00 00 8B 05 ?? ?? ?? ?? 83 C8 08 89 05 ?? ?? ?? ?? B8 04 00 00 00 48 6B C0 02 8B 44 04 30 83 E0 20 85 C0 74 19 C7 05 ?? ?? ?? ?? 05 00 00 00 8B 05 ?? ?? ?? ?? 83 C8 20 89 05 ?? ?? ?? ?? 33 C0 48 8B 4C 24 40 48 33 CC E8 ?? ?? ?? ?? 48 83 C4 50 5B C3 }
	condition:
		$1
}

rule file_282_0_0 {
	meta:
		name = "__sse2_sinhf4"
		size = 432
		refs = "003f __common_ssinh_data 01a2 __common_ssinh_cout_rare"
	strings:
		$1 = { 48 81 EC 08 01 00 00 44 0F 29 AC 24 F0 00 00 00 44 0F 29 9C 24 C0 00 00 00 44 0F 29 94 24 D0 00 00 00 44 0F 29 8C 24 E0 00 00 00 44 0F 28 C8 4C 89 AC 24 00 01 00 00 4C 8D 6C 24 6F 0F 28 05 ?? ?? ?? ?? 49 83 E5 C0 41 0F 54 C1 44 0F 28 E8 0F 28 25 ?? ?? ?? ?? 66 45 0F EF E9 41 0F 59 E5 41 0F 28 CD 44 0F 28 15 ?? ?? ?? ?? 66 0F 66 0D ?? ?? ?? ?? 41 0F 58 E2 0F 50 D1 0F 28 CC 66 0F 72 F4 17 44 0F 28 1D ?? ?? ?? ?? 85 D2 0F 28 2D ?? ?? ?? ?? 41 0F 5C CA 44 0F 59 D9 44 0F 28 15 ?? ?? ?? ?? 45 0F 5C EB 44 0F 59 D1 0F 28 1D ?? ?? ?? ?? 45 0F 5C EA 41 0F 28 CD 41 0F 59 CD 0F 59 E9 0F 59 D9 0F 58 2D ?? ?? ?? ?? 0F 58 1D ?? ?? ?? ?? 0F 59 E9 0F 59 D9 41 0F 59 ED 0F 58 1D ?? ?? ?? ?? 41 0F 58 ED 0F 59 D9 66 0F 6F 15 ?? ?? ?? ?? 66 44 0F 6F D2 66 0F FA D4 66 44 0F FE D4 66 41 0F 6F E2 44 0F 5C D2 0F 58 E2 41 0F 59 DA 0F 59 E5 0F 58 E3 41 0F 58 E2 0F 56 C4 75 34 44 0F 28 8C 24 E0 00 00 00 44 0F 28 94 24 D0 00 00 00 44 0F 28 9C 24 C0 00 00 00 44 0F 28 AC 24 F0 00 00 00 4C 8B AC 24 00 01 00 00 48 81 C4 08 01 00 00 C3 45 0F 29 4D 00 41 0F 29 45 40 74 C0 33 C0 48 89 5C 24 28 8B D8 48 89 74 24 20 8B F2 8B CB 41 B8 01 00 00 00 41 D3 E0 41 85 F0 75 18 FF C3 83 FB 20 7C E9 48 8B 5C 24 28 48 8B 74 24 20 41 0F 28 45 40 EB 88 49 8D 4C 9D 00 49 8D 54 9D 40 E8 ?? ?? ?? ?? EB D7 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_284_1_0 {
	meta:
		name = "_guard_icall_checks_enforced"
		size = 47
		refs = "0007 __guard_check_icall_fptr 000e _guard_check_icall_nop"
	strings:
		$1 = { 48 83 EC 18 48 8B 05 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 3B C1 74 09 C7 04 24 01 00 00 00 EB 07 C7 04 24 00 00 00 00 8B 04 24 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_287_0_0 {
	meta:
		name = "__sse2_sinf4"
		size = 2240
		refs = "0023 MMIABSMASK 002e MMSINVPI 0035 MMIHUGE 003f MMSPI1 004a MMSPI2 0063 MMSPI4 006d MMSPI3 0085 MMSA9 0095 MMSA5 009c MMSA3 00af MMSA7 00e7 MMISIGNMASK 010c flTwoPow30 0132 flAllOnes 016f dbInvPio2 018a dbiOne 0195 MSK_LOW_BIT 01a0 dbRS 01b4 PI02C_0 01c9 PI02C_1 01e1 PI02C_2 0237 PI02C_3 0268 PI02C_4 0278 dbSignMask 0745 __spec_table"
	strings:
		$1 = { 48 81 EC 38 01 00 00 0F 29 BC 24 10 01 00 00 0F 29 B4 24 20 01 00 00 0F 28 F0 0F 28 D0 0F 28 F8 0F 28 0D ?? ?? ?? ?? 66 0F DB F9 0F 28 25 ?? ?? ?? ?? 0F 28 2D ?? ?? ?? ?? 0F 59 C4 0F 28 25 ?? ?? ?? ?? 66 0F 66 FD 0F 28 2D ?? ?? ?? ?? 0F 50 C7 0B C0 0F 85 8B 00 00 00 66 0F 5B C0 0F 28 D8 0F 28 3D ?? ?? ?? ?? 0F 5B C0 0F 28 35 ?? ?? ?? ?? 66 0F 72 F3 1F 0F 59 E0 0F 59 E8 0F 59 F0 0F 59 F8 0F 28 05 ?? ?? ?? ?? 0F 5C D4 0F 5C D5 0F 5C D6 0F 28 2D ?? ?? ?? ?? 0F 28 35 ?? ?? ?? ?? 0F 28 CA 0F 5C CF 0F 59 D2 0F 59 C2 0F 58 05 ?? ?? ?? ?? 0F 59 C2 0F 58 C5 0F 59 C2 0F 58 C6 0F 59 C2 0F 59 C1 0F 58 C1 66 0F EF C3 0F 28 B4 24 20 01 00 00 0F 28 BC 24 10 01 00 00 48 81 C4 38 01 00 00 C3 0F 28 1D ?? ?? ?? ?? 66 0F DB DE 0F 29 74 24 40 66 0F 5B C0 66 0F DB 35 ?? ?? ?? ?? 0F 28 CE 0F 29 74 24 50 66 0F 66 35 ?? ?? ?? ?? 0F 29 5C 24 60 0F 50 D6 85 D2 0F 85 4A 05 00 00 83 F8 0F 0F 84 E6 02 00 00 0F 29 7C 24 70 66 0F EF 3D ?? ?? ?? ?? 0F 28 D8 0F 29 BC 24 80 00 00 00 0F 28 3D ?? ?? ?? ?? 0F 5B C0 0F 28 35 ?? ?? ?? ?? 66 0F 72 F3 1F 0F 59 E0 0F 59 E8 0F 5C D4 0F 5A 64 24 50 0F 59 F0 0F 5C D5 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 EC 66 0F E6 ED 66 0F 70 ED DC 0F 59 F8 0F 5C D6 66 0F FE 2D ?? ?? ?? ?? 0F 28 CA 66 0F DB 2D ?? ?? ?? ?? 0F 5C CF 66 0F 28 3D ?? ?? ?? ?? 66 0F 56 FD 66 0F 5C 3D ?? ?? ?? ?? 66 0F 28 05 ?? ?? ?? ?? 66 0F 59 C7 66 0F DB 9C 24 80 00 00 00 66 0F 28 35 ?? ?? ?? ?? 66 0F 59 F7 66 0F 5C E0 0F 29 9C 24 90 00 00 00 66 0F 28 1D ?? ?? ?? ?? 66 0F 59 DF 66 0F 28 C4 66 0F 5C E6 66 0F DB 8C 24 80 00 00 00 66 0F 5C C4 0F 29 8C 24 A0 00 00 00 0F 59 D2 66 0F 28 CC 66 0F 5C C6 66 0F 5C E3 66 0F DB 94 24 80 00 00 00 66 0F 73 F5 3E 66 0F 5C CC 0F 29 94 24 B0 00 00 00 66 0F 28 D4 66 0F 28 35 ?? ?? ?? ?? 66 0F 5C CB 66 0F 58 C1 0F 5A 4C 24 58 66 0F 58 E0 66 0F 59 F7 66 0F 5C D4 66 0F 28 DC 66 0F 5C E6 66 0F 58 C2 66 0F 5C DC 66 0F 59 3D ?? ?? ?? ?? 66 0F 5C DE 66 0F 58 C3 66 0F 28 1D ?? ?? ?? ?? 66 0F 5C C7 66 0F DB DD 66 0F 28 E9 66 0F 59 2D ?? ?? ?? ?? 66 0F E6 ED 66 0F 58 C4 66 0F 28 E1 66 0F 70 DB DD 66 0F 70 ED DC 66 0F FE 2D ?? ?? ?? ?? 66 0F DB 2D ?? ?? ?? ?? 66 0F 28 3D ?? ?? ?? ?? 66 0F 56 FD 66 0F 29 84 24 C0 00 00 00 66 0F 5C 3D ?? ?? ?? ?? 66 0F 28 05 ?? ?? ?? ?? 66 0F 59 C7 66 0F 28 35 ?? ?? ?? ?? 66 0F 59 F7 66 0F D6 9C 24 D0 00 00 00 66 0F 5C E0 66 0F 28 1D ?? ?? ?? ?? 66 0F 59 DF 66 0F 28 C4 66 0F 5C E6 66 0F 5C C4 66 0F 28 CC 66 0F 5C C6 66 0F 5C E3 66 0F 73 F5 3E 66 0F 5C CC 66 0F 28 D4 66 0F 28 35 ?? ?? ?? ?? 66 0F 5C CB 66 0F 58 C1 66 0F 58 E0 66 0F 59 F7 66 0F 5C D4 66 0F 28 DC 66 0F 5C E6 66 0F 58 C2 66 0F 5C DC 66 0F 59 3D ?? ?? ?? ?? 66 0F 5C DE 66 0F 58 C3 66 0F 28 1D ?? ?? ?? ?? 66 0F 5C C7 66 0F 5A BC 24 C0 00 00 00 66 0F DB DD 66 0F 58 C4 66 0F 5A E8 66 0F 14 FD 0F 28 05 ?? ?? ?? ?? 0F 28 0D ?? ?? ?? ?? 0F 28 E7 0F 59 FF 66 0F DB 7C 24 70 66 0F EB BC 24 B0 00 00 00 0F 59 C7 66 0F 70 DB DD 0F 58 05 ?? ?? ?? ?? F3 0F 7E AC 24 D0 00 00 00 0F 59 C7 66 0F 14 EB 0F 58 05 ?? ?? ?? ?? 66 0F EF 6C 24 60 0F 59 C7 66 0F DB 64 24 70 0F 58 C1 66 0F EB A4 24 A0 00 00 00 0F 59 C7 66 0F DB 6C 24 70 0F 59 C4 66 0F EB AC 24 90 00 00 00 0F 58 C4 66 0F EF C5 E9 16 03 00 00 66 0F 70 C1 EE 0F 5A E1 0F 5A C0 66 0F 28 2D ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 59 EC 66 0F 59 F0 66 0F E6 ED 66 0F E6 F6 66 0F 70 ED DC 66 0F 70 F6 DC 66 0F FE 2D ?? ?? ?? ?? 66 0F FE 35 ?? ?? ?? ?? 66 0F DB 2D ?? ?? ?? ?? 66 0F DB 35 ?? ?? ?? ?? 66 0F 29 B4 24 E0 00 00 00 66 0F 28 3D ?? ?? ?? ?? 66 0F 56 FD 66 0F 5C 3D ?? ?? ?? ?? 66 0F 29 84 24 F0 00 00 00 66 0F 28 05 ?? ?? ?? ?? 66 0F 59 C7 66 0F 28 35 ?? ?? ?? ?? 66 0F 59 F7 66 0F 5C E0 66 0F 28 1D ?? ?? ?? ?? 66 0F 59 DF 66 0F 28 C4 66 0F 5C E6 66 0F 5C C4 66 0F 28 CC 66 0F 5C C6 66 0F 5C E3 66 0F 73 F5 3E 66 0F 5C CC 66 0F 28 D4 66 0F 28 35 ?? ?? ?? ?? 66 0F 5C CB 66 0F 58 C1 66 0F 58 E0 66 0F 59 F7 66 0F 5C D4 66 0F 28 DC 66 0F 5C E6 66 0F 58 C2 66 0F 5C DC 66 0F 59 3D ?? ?? ?? ?? 66 0F 5C DE 66 0F 58 C3 66 0F 28 1D ?? ?? ?? ?? 66 0F 5C C7 66 0F DB DD 66 0F 58 C4 66 0F 28 A4 24 F0 00 00 00 66 0F 70 DB DD 66 0F 28 AC 24 E0 00 00 00 66 0F 28 3D ?? ?? ?? ?? 66 0F 56 FD 66 0F 29 84 24 C0 00 00 00 66 0F 5C 3D ?? ?? ?? ?? 66 0F 28 05 ?? ?? ?? ?? 66 0F 59 C7 66 0F 28 35 ?? ?? ?? ?? 66 0F 59 F7 66 0F D6 9C 24 D0 00 00 00 66 0F 5C E0 66 0F 28 1D ?? ?? ?? ?? 66 0F 59 DF 66 0F 28 C4 66 0F 5C E6 66 0F 5C C4 66 0F 28 CC 66 0F 5C C6 66 0F 5C E3 66 0F 73 F5 3E 66 0F 5C CC 66 0F 28 D4 66 0F 28 35 ?? ?? ?? ?? 66 0F 5C CB 66 0F 58 C1 66 0F 58 E0 66 0F 59 F7 66 0F 5C D4 66 0F 28 DC 66 0F 5C E6 66 0F 58 C2 66 0F 5C DC 66 0F 59 3D ?? ?? ?? ?? 66 0F 5C DE 66 0F 58 C3 66 0F 28 1D ?? ?? ?? ?? 66 0F 5C C7 66 0F 5A BC 24 C0 00 00 00 66 0F DB DD 66 0F 58 C4 66 0F 5A E8 66 0F 14 FD 0F 28 05 ?? ?? ?? ?? 0F 28 0D ?? ?? ?? ?? 0F 28 E7 0F 59 FF 0F 59 C7 0F 58 05 ?? ?? ?? ?? 0F 59 C7 0F 58 05 ?? ?? ?? ?? 0F 59 C7 66 0F 70 DB DD 0F 58 C1 F3 0F 7E AC 24 D0 00 00 00 0F 59 C7 66 0F 14 EB 0F 59 C4 66 0F EF 6C 24 60 0F 58 C4 66 0F EF C5 E9 BB 00 00 00 83 F8 0F 0F 84 8C 00 00 00 0F 28 D8 0F 28 3D ?? ?? ?? ?? 0F 5B C0 0F 28 35 ?? ?? ?? ?? 66 0F 72 F3 1F 0F 59 E0 0F 59 E8 0F 59 F0 0F 59 F8 0F 28 05 ?? ?? ?? ?? 0F 5C D4 0F 5C D5 0F 5C D6 0F 28 2D ?? ?? ?? ?? 0F 28 35 ?? ?? ?? ?? 0F 28 CA 0F 5C CF 0F 59 D2 0F 28 05 ?? ?? ?? ?? 0F 28 2D ?? ?? ?? ?? 0F 28 35 ?? ?? ?? ?? 0F 59 C2 0F 58 05 ?? ?? ?? ?? 0F 59 C2 0F 58 C5 0F 59 C2 0F 58 C6 0F 59 C2 0F 59 C1 0F 58 C1 66 0F EF C3 0F 29 84 24 00 01 00 00 89 44 24 20 8B 44 24 20 45 33 C9 A8 01 75 2F 49 FF C1 D1 F8 89 44 24 20 49 83 F9 04 7C ED 0F 28 84 24 00 01 00 00 0F 28 B4 24 20 01 00 00 0F 28 BC 24 10 01 00 00 48 81 C4 38 01 00 00 C3 42 8B 44 8C 40 48 8D 15 ?? ?? ?? ?? 89 44 24 28 48 89 54 24 30 F3 0F 10 44 24 28 4C 8B 44 24 30 F3 0F 10 C8 66 0F 7E C1 0F 5A C8 F2 41 0F 10 90 10 05 00 00 81 E1 FF FF FF 7F 66 0F 7E C0 25 00 00 80 7F 3D 00 00 80 7F 0F 84 0F 01 00 00 C1 E9 17 81 E9 8E 00 00 00 81 E1 F8 FF 00 00 F2 41 0F 10 9C 48 10 04 00 00 F2 41 0F 10 AC 48 18 04 00 00 F2 41 0F 10 90 50 05 00 00 66 0F 57 E4 B8 38 43 00 00 66 0F C4 E0 03 66 0F 54 D3 66 0F 73 F3 28 F2 0F 59 D1 F2 0F 59 D9 F2 0F 59 CD 66 0F 28 C2 F2 0F 58 D3 66 0F 28 EA F2 0F 5C C2 F2 0F 58 D4 F2 0F 58 D8 66 0F 7E D1 F2 0F 5C D4 F2 0F 58 CB B8 80 01 00 00 F2 41 0F 10 A0 40 05 00 00 F2 0F 5C EA 03 C9 8B D1 C1 E1 18 C1 F9 1F 23 C2 03 D1 33 D1 F2 0F 58 CD 81 E2 FE 00 00 00 F2 41 0F 10 1C D0 F2 41 0F 10 80 48 05 00 00 66 0F 70 D1 44 F2 0F 59 C9 F2 41 0F 10 6C D0 08 8B C8 81 C1 80 00 00 00 81 E1 00 01 00 00 C1 E1 17 F2 0F 59 DA 66 0F 6E D1 F2 0F 5C C1 25 00 01 00 00 C1 E0 17 F2 0F 5C E1 66 0F 73 F2 20 66 0F 6E C8 66 0F 57 E2 F2 0F 59 C5 F2 0F 59 DC 66 0F 73 F1 20 66 0F 57 C1 F2 0F 58 C3 66 0F 5A C0 EB 04 F3 0F 5C C0 F3 0F 11 44 24 24 8B 44 24 24 42 89 84 8C 00 01 00 00 8B 44 24 20 E9 55 FE FF FF 0F 1F 80 00 00 00 00 }
	condition:
		$1
}

rule file_289_0_0 {
	meta:
		name = "__security_check_cookie"
		size = 33
		refs = "0003 __security_cookie 001d __report_gsfailure"
	strings:
		$1 = { 48 3B 0D ?? ?? ?? ?? F2 75 12 48 C1 C1 10 66 F7 C1 FF FF F2 75 02 F2 C3 48 C1 C9 10 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_290_0_0 {
	meta:
		name = "__avx_sinh4"
		size = 672
		refs = "000a __common_dsinh_data 0292 __common_dsinh_cout_rare"
	strings:
		$1 = { 48 81 EC 18 02 00 00 48 8D 15 ?? ?? ?? ?? C5 7C 11 BC 24 F0 01 00 00 C5 7C 11 B4 24 D0 01 00 00 C5 7C 11 AC 24 70 01 00 00 C5 7C 11 A4 24 50 01 00 00 C5 FC 11 BC 24 B0 01 00 00 C5 FC 11 B4 24 90 01 00 00 4C 89 AC 24 10 02 00 00 4C 8D AC 24 EF 00 00 00 C5 7D 54 35 ?? ?? ?? ?? 49 83 E5 C0 C5 8D 57 F0 C5 7D 10 2D ?? ?? ?? ?? C5 CD 59 15 ?? ?? ?? ?? C5 F9 10 1D ?? ?? ?? ?? C4 C1 6D 58 E5 C4 E3 7D 19 F1 01 C5 C8 C6 E9 DD C5 D1 66 15 ?? ?? ?? ?? C5 78 50 C2 C5 59 DB FB C4 C1 5D 5C CD C5 79 7E F9 C5 75 59 2D ?? ?? ?? ?? C5 F5 59 0D ?? ?? ?? ?? C4 C1 4D 5C D5 C4 E3 7D 19 E5 01 C4 C1 59 EF E7 C5 D0 54 DB C4 C1 79 7E D9 C5 ED 5C D1 C1 E1 04 C4 63 79 16 F8 02 C5 81 73 F4 2D 41 C1 E1 04 C4 C3 79 16 DA 02 C5 D0 57 DB C5 D1 73 F3 2D C1 E0 04 41 C1 E2 04 C5 ED 59 CA C4 61 F9 6E 64 11 08 C4 C1 F9 6E 7C 11 08 C4 E1 F9 6E 34 11 C5 19 16 6C 10 08 C4 41 41 16 64 12 08 C5 C9 16 3C 10 C4 C1 41 D4 FF C4 C1 11 D4 DF C4 41 11 FB EF C5 99 D4 E5 C5 19 FB E5 C5 75 59 3D ?? ?? ?? ?? C4 C1 F9 6E 34 11 C4 C1 49 16 34 12 C5 C9 D4 F5 C4 E3 45 18 F6 01 C4 E3 65 18 FC 01 C5 85 58 1D ?? ?? ?? ?? C5 E5 59 E1 C4 C3 15 18 EC 01 C5 45 58 ED C5 45 5C E5 C5 F5 59 3D ?? ?? ?? ?? C5 DD 59 EA C4 C1 4D 58 DC C5 45 58 3D ?? ?? ?? ?? C5 D5 58 D2 C4 C1 4D 58 F5 C5 85 59 C9 C5 ED 59 D6 C5 F5 59 CB C5 ED 58 D1 C5 ED 58 E3 C5 8D 56 CC 45 85 C0 75 4A C5 FC 10 B4 24 90 01 00 00 C5 FC 10 BC 24 B0 01 00 00 C5 7C 10 A4 24 50 01 00 00 C5 7C 10 AC 24 70 01 00 00 C5 7C 10 B4 24 D0 01 00 00 C5 7C 10 BC 24 F0 01 00 00 4C 8B AC 24 10 02 00 00 C5 FD 28 C1 48 81 C4 18 02 00 00 C3 C4 C1 7D 11 45 00 C4 C1 7D 11 4D 40 74 A8 33 C0 C5 7C 11 84 24 80 00 00 00 C5 7C 11 4C 24 60 C5 7C 11 54 24 40 C5 7C 11 5C 24 20 48 89 9C 24 A8 00 00 00 8B D8 48 89 B4 24 A0 00 00 00 41 8B F0 0F A3 DE 72 3D FF C3 83 FB 20 7C F4 C5 7C 10 84 24 80 00 00 00 C5 7C 10 4C 24 60 C5 7C 10 54 24 40 C5 7C 10 5C 24 20 C4 C1 7D 10 4D 40 48 8B 9C 24 A8 00 00 00 48 8B B4 24 A0 00 00 00 E9 34 FF FF FF C5 F8 77 49 8D 4C DD 00 49 8D 54 DD 40 E8 ?? ?? ?? ?? EB AF 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_291_0_0 {
	meta:
		name = "??3@YAXPEAXHPEBDH@Z"
		size = 42
		refs = "0021 _free_dbg"
	strings:
		$1 = { 44 89 4C 24 20 4C 89 44 24 18 89 54 24 10 48 89 4C 24 08 48 83 EC 28 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_293_0_0 {
	meta:
		name = "__common_dtan_cout_rare"
		size = 128
		refs = "004e _vmldTanHATab"
	strings:
		$1 = { 48 83 EC 28 33 C0 4C 8B 01 4C 89 44 24 20 49 C1 E8 38 44 0F B7 49 06 41 81 E1 F0 7F 00 00 41 83 E0 7F F2 0F 10 09 41 81 F9 F0 7F 00 00 44 88 44 24 27 74 05 48 83 C4 28 C3 83 7C 24 20 00 75 24 81 7C 24 24 00 00 F0 7F 75 1A F2 0F 10 05 ?? ?? ?? ?? B8 01 00 00 00 F2 0F 59 C8 F2 0F 11 0A 48 83 C4 28 C3 F2 0F 59 C9 F2 0F 11 0A 48 83 C4 28 C3 66 66 66 66 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_295_0_0 {
	meta:
		name = "__avx_cos4"
		size = 2192
		refs = "000a __common_dcos_reduction_data 007f __common_dcos_data 023a __common_dcos_cout_rare 0244 __common_dcos_data_ha 029b _2il0floatpacket_267 02db _2il0floatpacket_268 0331 _2il0floatpacket_269 05ac _2il0floatpacket_270 05ce _2il0floatpacket_272 05d6 _2il0floatpacket_273 05e5 _2il0floatpacket_271 0611 _2il0floatpacket_274 0636 _2il0floatpacket_276 066c _2il0floatpacket_275 06d3 _2il0floatpacket_280 06e6 _2il0floatpacket_277 06ef _2il0floatpacket_278 06f8 _2il0floatpacket_279 0755 _2il0floatpacket_281 0763 _2il0floatpacket_282"
	strings:
		$1 = { 48 81 EC B8 02 00 00 4C 8D 15 ?? ?? ?? ?? C5 7C 11 BC 24 90 02 00 00 45 33 DB C5 7C 11 B4 24 70 02 00 00 C5 7C 11 AC 24 50 02 00 00 C5 7C 11 A4 24 30 02 00 00 C5 7C 11 9C 24 10 02 00 00 C5 7C 11 94 24 F0 01 00 00 C5 7C 11 8C 24 D0 01 00 00 C5 7C 11 84 24 B0 01 00 00 C5 FC 11 BC 24 90 01 00 00 C5 FC 11 B4 24 70 01 00 00 4C 89 AC 24 B0 02 00 00 4C 8D AC 24 0F 01 00 00 C5 FD 58 25 ?? ?? ?? ?? 49 83 E5 C0 C5 DD 54 2D ?? ?? ?? ?? C5 D5 C2 0D ?? ?? ?? ?? 1E C4 E3 7D 19 CA 01 C5 F0 C6 DA DD C5 F8 50 C3 85 C0 0F 85 91 01 00 00 C5 FD 10 1D ?? ?? ?? ?? C5 DD 59 25 ?? ?? ?? ?? C5 DD 58 F3 C5 CD 5C EB C5 55 5C 3D ?? ?? ?? ?? C5 05 59 15 ?? ?? ?? ?? C5 05 59 25 ?? ?? ?? ?? C5 05 59 35 ?? ?? ?? ?? C5 85 59 1D ?? ?? ?? ?? C4 41 7D 5C DA C4 41 25 5C EC C4 C1 15 5C CE C5 F5 5C CB C5 F5 59 D9 C5 E5 59 25 ?? ?? ?? ?? C5 DD 58 2D ?? ?? ?? ?? C5 C1 73 F6 3F C4 C3 7D 19 F0 01 C5 D5 59 F3 C4 C1 31 73 F0 3F C4 C3 45 18 D1 01 C5 CD 58 3D ?? ?? ?? ?? C5 45 59 C3 C5 3D 58 0D ?? ?? ?? ?? C5 35 59 D3 C5 2D 58 1D ?? ?? ?? ?? C5 25 59 E3 C5 1D 58 2D ?? ?? ?? ?? C5 15 59 F3 C5 0D 58 3D ?? ?? ?? ?? C5 85 59 E3 C5 DD 59 E9 C5 D5 58 C9 C5 F5 57 CA 45 85 DB 75 6E C5 FC 10 B4 24 70 01 00 00 C5 FC 10 BC 24 90 01 00 00 C5 7C 10 84 24 B0 01 00 00 C5 7C 10 8C 24 D0 01 00 00 C5 7C 10 94 24 F0 01 00 00 C5 7C 10 9C 24 10 02 00 00 C5 7C 10 A4 24 30 02 00 00 C5 7C 10 AC 24 50 02 00 00 C5 7C 10 B4 24 70 02 00 00 C5 7C 10 BC 24 90 02 00 00 4C 8B AC 24 B0 02 00 00 C5 FD 28 C1 48 81 C4 B8 02 00 00 C3 C4 C1 7D 11 45 00 C4 C1 7D 11 4D 40 74 84 33 C0 48 89 5C 24 28 8B D8 48 89 74 24 20 41 8B F3 0F A3 DE 72 1C FF C3 83 FB 20 7C F4 48 8B 5C 24 28 48 8B 74 24 20 C4 C1 7D 10 4D 40 E9 52 FF FF FF C5 F8 77 49 8D 4C DD 00 49 8D 54 DD 40 E8 ?? ?? ?? ?? EB D0 C5 FD 10 25 ?? ?? ?? ?? BA 00 00 F0 7F C4 C1 7D 11 45 00 C5 F9 6E CA C5 79 70 C1 11 C5 5D 54 DD C5 25 C2 CC 00 C4 43 7D 19 CF 01 C4 41 30 C6 EF DD C4 41 78 50 DD C5 B9 DB F8 C4 C3 7D 19 C5 01 C5 A9 73 D7 34 C4 C1 39 DB D5 C5 E1 73 D2 34 C5 F9 7E D9 C5 79 7E D0 C5 7A 6F 05 ?? ?? ?? ?? C5 F8 11 44 24 20 C5 B9 DB C0 C4 E3 79 16 DA 02 8D 0C 49 C4 43 79 16 D0 02 44 8D 0C 40 C1 E1 03 41 C1 E1 03 8D 04 52 C1 E0 03 47 8D 04 40 41 C1 E0 03 C4 21 F9 6E 1C 11 C5 FA 6F 15 ?? ?? ?? ?? C4 21 21 16 14 10 C4 A1 F9 6E 7C 11 10 C5 79 D4 DA C4 C1 39 DB C5 C4 01 F9 6E 24 11 C4 81 F9 6E 74 11 08 C4 A1 41 16 5C 10 10 C5 F9 D4 FA C5 78 11 6C 24 30 C4 01 19 16 34 10 C4 01 49 16 4C 10 08 C4 01 F9 6E 7C 11 10 C4 C1 19 73 D1 20 C5 7A 6F 2D ?? ?? ?? ?? C4 A1 F9 6E 6C 11 08 C4 C1 31 DB F5 C5 79 11 74 24 40 C4 C1 31 73 D3 20 C4 81 01 16 4C 10 10 C4 41 09 DB FD C4 41 29 DB F5 C4 41 21 DB C5 C4 41 41 DB DD C5 E9 73 D1 20 C4 A1 51 16 64 10 08 4C 8D 15 ?? ?? ?? ?? C4 C1 71 DB CD C5 7A 7F 74 24 70 C4 C1 59 DB C5 C4 41 21 F4 F6 C5 D1 73 D4 20 C5 79 11 54 24 50 C5 A9 73 D7 20 C5 FA 7F 84 24 A0 00 00 00 C5 D9 73 D3 20 C5 A1 F4 F8 C4 C1 61 DB DD C5 B1 F4 C1 C5 B1 F4 CA C5 B9 F4 D2 C5 FA 7F AC 24 90 00 00 00 C5 E9 73 D2 20 C5 7A 7F B4 24 C0 00 00 00 41 B8 00 00 00 80 C5 7A 7F 7C 24 60 C5 F1 D4 CA C5 21 F4 F5 C5 B9 F4 EE C4 41 39 F4 FF C5 B1 F4 F6 C5 7A 7F BC 24 B0 00 00 00 C5 81 73 D0 20 C4 C1 51 DB C5 C5 D1 73 D5 20 C5 F9 D4 C1 C5 81 D4 D0 C5 A9 F4 C3 C5 81 73 D0 20 C4 C1 41 DB DD C5 A9 F4 C4 C5 C1 73 D7 20 C5 A1 F4 E4 C5 D9 73 D4 20 C5 7A 7F A4 24 80 00 00 00 C4 41 39 F4 E4 C5 F9 D4 C4 C5 E1 D4 C8 C5 C9 D4 C5 C5 81 D4 E1 C4 41 19 DB FD C5 F1 73 D2 20 C5 01 D4 F8 C4 41 71 D4 FF C5 A9 F4 8C 24 A0 00 00 00 C5 F1 D4 EF C5 B1 F4 8C 24 80 00 00 00 C5 31 F4 4C 24 60 C4 C1 09 DB F5 C5 E1 73 D4 20 C5 C9 D4 C5 C5 A9 F4 AC 24 90 00 00 00 C5 29 F4 54 24 70 C5 E1 D4 F8 C4 C1 19 73 D4 20 C4 C1 49 73 D7 20 C5 FA 6F 9C 24 B0 00 00 00 C4 C1 09 73 D6 20 C4 C1 71 D4 CC C4 41 51 D4 F6 C4 C1 61 DB C5 C5 E1 73 D3 20 C5 F9 D4 C1 C5 31 D4 CB C5 C9 D4 F0 C5 FA 6F 84 24 C0 00 00 00 C5 99 73 D7 20 C5 F9 10 6C 24 40 C4 C1 79 DB CD C4 C1 71 D4 CE C5 89 73 D5 20 C5 F9 73 D0 20 C4 41 39 F4 C6 C4 C1 01 73 F7 20 C5 99 D4 C9 C5 29 D4 D0 C4 41 39 DB C5 C5 99 73 D6 20 C4 41 39 D4 C1 C5 F9 10 6C 24 50 C5 B1 73 D1 20 C4 41 19 D4 E0 C5 B9 73 D5 20 C4 C1 09 73 F4 20 C4 41 21 F4 D8 C4 C1 79 6E C0 C4 41 21 DB C5 C4 C1 49 DB F5 C4 41 39 D4 E2 C5 89 D4 F6 C4 41 31 D4 CC C4 C1 61 73 F1 20 C4 C1 71 DB CD C4 C1 69 DB D5 C5 C1 73 F7 20 C4 41 59 DB ED C5 B1 73 D6 0C C5 F9 70 E0 11 C5 61 D4 C1 C5 01 D4 D2 C4 C1 41 D4 D5 C5 D9 DB 7C 24 20 C4 C1 61 73 D0 0C C5 7A 6F 25 ?? ?? ?? ?? C5 D9 DB 4C 24 30 C4 41 41 EF FC C4 41 71 EF F4 C4 41 31 EB EF C4 41 61 EB DE C5 F8 10 1D ?? ?? ?? ?? C5 7A 6F 35 ?? ?? ?? ?? C4 C3 15 18 C3 01 C4 E2 7D 1A 2D ?? ?? ?? ?? C5 55 58 C8 C5 B5 5C E5 C4 C1 71 EF EE C5 7D 5C FC C4 C1 41 EF E6 C5 31 DB EB C4 43 7D 19 CC 01 C5 18 54 CB C5 FA 6F 1D ?? ?? ?? ?? C4 41 61 DB DA C5 61 DB F2 C4 C1 79 73 F3 1C C4 C1 21 73 F6 1C C5 79 EB E4 C5 A1 EB C5 C5 7A 6F 1D ?? ?? ?? ?? C5 79 7E EA C4 41 79 7E C9 C1 E2 05 C4 63 79 16 E8 02 41 C1 E1 05 C4 63 79 16 C9 02 C1 E0 05 C1 E1 05 C4 E3 1D 18 D8 01 C4 E3 5D 18 ED 01 C5 FA 6F 05 ?? ?? ?? ?? C5 65 5C E5 C5 F1 EF D8 C5 A1 DB CE C5 41 EF F0 C5 C1 73 F1 28 C4 C1 49 73 D2 18 C4 C1 21 DB C8 C5 C1 EB C6 C5 C1 73 F1 28 C5 B9 73 D2 18 C4 C1 41 EB D0 C4 C1 79 EB E6 C5 69 EB D3 C4 C3 5D 18 EA 01 C4 E3 0D 18 DB 01 C5 D5 5C F3 C5 85 58 C6 C5 05 5C F8 C4 41 4D 58 DF C4 C1 25 58 FC C4 62 7D 1A 25 ?? ?? ?? ?? C4 41 7D 54 FC C4 C1 7D 5C D7 C4 E2 7D 1A 0D ?? ?? ?? ?? C4 E2 7D 1A 25 ?? ?? ?? ?? C4 62 7D 1A 05 ?? ?? ?? ?? C5 5D 59 D2 C4 C1 3D 59 DF C5 F5 59 EF C5 BD 59 F2 C4 C1 5D 59 C7 C5 2D 58 DB C5 55 58 E6 C4 C1 25 58 E4 C4 21 F9 6E 1C 12 C4 21 21 16 2C 10 C5 FD 58 D4 C5 7D 5C F2 C4 C1 7D 10 45 00 C5 8D 58 F4 C4 81 F9 6E 24 11 C4 21 59 16 0C 11 C4 A1 F9 6E 64 12 10 C4 62 7D 1A 3D ?? ?? ?? ?? C4 C1 7D 54 CF C4 E2 7D 1A 3D ?? ?? ?? ?? C5 F5 C2 EF 1E C5 75 C2 C7 12 C5 3D 54 D0 C5 D5 54 DA C4 21 F9 6E 44 12 08 C5 AD 56 CB C4 81 F9 6E 5C 11 08 C4 21 39 16 54 10 08 C5 55 54 FE C4 A1 61 16 6C 11 08 C4 63 2D 18 D5 01 C4 41 75 59 DA C4 C3 15 18 D1 01 C4 01 F9 6E 6C 11 10 C4 21 59 16 4C 10 10 C4 A1 11 16 7C 11 10 C4 E3 35 18 FF 01 C5 6D 59 C9 C4 41 45 58 E3 C4 C1 35 58 E4 C4 C1 45 5C F4 C5 1D 5C F4 C4 41 4D 58 C3 C4 41 0D 58 E9 C4 41 15 58 E0 C4 41 6D 58 EA C5 75 59 C1 C5 BD 59 1D ?? ?? ?? ?? C5 3D 59 0D ?? ?? ?? ?? C5 E5 58 2D ?? ?? ?? ?? C4 C1 55 59 F0 C5 4D 59 D9 C5 F5 59 CF C4 C1 25 59 D5 C4 41 6D 58 D4 C5 B5 58 15 ?? ?? ?? ?? C4 C1 6D 59 D8 C5 E5 58 2D ?? ?? ?? ?? C4 81 F9 6E 5C 11 18 C4 41 55 59 C0 C4 A1 61 16 6C 11 18 C5 BD 59 F7 C4 41 4D 58 CA C5 95 5C F1 C4 A1 F9 6E 4C 12 18 C4 A1 71 16 54 10 18 C5 05 59 FE C4 E3 6D 18 FD 01 C5 85 58 CF C5 B5 58 D1 C5 DD 58 CA E9 F4 F8 FF FF 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_299_0_0 {
	meta:
		name = "__common_trig_reduction"
		size = 1328
		refs = "003b _zero_none 006b _PI02_INV 0072 _PIO2_21x5 00c0 _PI04_INV 00c7 _PI04_21x5 017e _PIO2_25x2 0185 _DDP 01ad _PI04_25x2 01b4 _DP 02ba _2il0floatpacket_3 044b _TWO_26H 04ec _PI04 04f9 _PI02"
	strings:
		$1 = { 41 55 41 56 41 57 48 83 EC 50 4C 8B EA F2 0F 11 44 24 70 0F B7 44 24 76 8B C8 81 E1 F0 7F 00 00 C1 E9 04 44 0F 29 4C 24 30 81 F9 FF 07 00 00 44 0F 29 44 24 40 7C 19 F2 0F 10 0D ?? ?? ?? ?? 33 C0 F2 0F 59 C1 F2 41 0F 11 45 00 E9 BB 04 00 00 81 F9 1D 04 00 00 0F 8D 17 01 00 00 F2 0F 10 54 24 70 45 85 C0 75 25 F2 0F 10 05 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? F2 0F 59 C2 F2 0F 2C C0 FF C0 83 E0 FE F2 0F 2A C8 C1 E0 1E EB 52 41 83 F8 01 75 2A F2 0F 10 05 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? F2 0F 59 C2 F2 0F 2C C0 83 C8 01 F2 0F 2A C8 C1 E0 1E F7 D0 25 00 00 00 80 EB 22 F2 0F 10 05 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? F2 0F 59 C2 F2 0F 2C C0 FF C0 83 E0 FE F2 0F 2A C8 D1 F8 F2 0F 10 19 F2 0F 59 D9 F2 0F 10 61 08 F2 0F 5C D3 F2 0F 59 E1 44 0F 28 C2 F2 0F 10 69 10 F2 44 0F 5C C4 F2 0F 59 E9 F2 41 0F 5C D0 41 0F 28 C0 F2 0F 5C D4 F2 0F 5C C5 44 0F 28 C8 F2 44 0F 5C C0 F2 44 0F 5C C5 F2 41 0F 58 D0 F2 44 0F 58 CA 41 0F 28 D9 F2 41 0F 5C C1 F2 0F 58 C2 F2 0F 10 51 18 F2 0F 59 D1 F2 0F 5C DA F2 44 0F 5C CB F2 44 0F 5C CA F2 0F 10 51 20 F2 0F 59 CA F2 41 0F 58 C1 F2 0F 5C C1 F2 0F 58 D8 F2 41 0F 11 5D 00 E9 98 03 00 00 45 85 C0 75 13 45 33 DB 4C 8D 15 ?? ?? ?? ?? 4C 8D 0D ?? ?? ?? ?? EB 2D 41 83 F8 01 75 16 41 BB 01 00 00 00 4C 8D 15 ?? ?? ?? ?? 4C 8D 0D ?? ?? ?? ?? EB 11 45 33 DB 4C 8D 15 ?? ?? ?? ?? 4C 8D 0D ?? ?? ?? ?? 25 0F 80 FF FF 44 8D B1 38 FF FF FF 41 81 E6 FF 07 00 00 44 8D B9 E4 FB FF FF 41 C1 E6 04 41 0B C6 66 89 44 24 76 B8 1F 85 EB 51 41 F7 EF 41 C1 FF 1F C1 FA 03 41 2B D7 6B C2 E7 F2 44 0F 10 44 24 70 81 64 24 70 00 00 00 F8 8D 8C 01 E4 FB FF FF F2 0F 10 6C 24 70 83 F9 11 F2 44 0F 5C C5 7C 4B 48 63 D2 F2 45 0F 10 4C D1 08 F2 41 0F 10 04 D1 FF C2 F2 44 0F 59 CD F2 41 0F 59 C0 41 0F 28 D1 F2 0F 58 D0 F2 0F 5C C2 F2 44 0F 58 C8 41 0F 28 C9 F2 0F 58 CA F2 0F 11 4C 24 20 81 64 24 20 00 00 F0 FF F2 0F 5C 54 24 20 EB 0D F2 44 0F 10 0D ?? ?? ?? ?? 41 0F 28 D1 48 63 D2 0F 28 DA F2 41 0F 10 0C D1 F2 41 0F 59 C8 F2 0F 58 D9 0F 28 C3 F2 0F 5C D3 F2 0F 58 CA F2 41 0F 10 54 D1 08 F2 44 0F 58 C9 0F 28 CD F2 0F 59 CA F2 41 0F 59 D0 F2 0F 58 C1 0F 28 E0 F2 0F 5C E3 0F 28 DD 0F 57 25 ?? ?? ?? ?? F2 0F 58 CC F2 41 0F 10 64 D1 10 F2 0F 59 DC F2 41 0F 59 E0 F2 44 0F 58 C9 0F 28 C8 F2 41 0F 58 C9 F2 0F 58 CA F2 0F 58 CB F2 0F 11 4C 24 20 0F B7 44 24 26 25 F0 7F 00 00 C1 E8 04 F7 D8 66 49 0F 7E CF 41 0F 28 C9 8D 88 33 04 00 00 05 F4 03 00 00 C1 F8 1F 48 63 C0 4C 8B F0 49 F7 D6 4D 0B FE 49 D3 FF 45 8B F7 4C 23 F8 49 D3 E7 4C 89 7C 24 20 4C 8D 3D ?? ?? ?? ?? F2 0F 5C 44 24 20 F2 0F 58 C8 43 8D 0C 1E 83 E1 01 43 8D 44 1E 01 41 83 F8 01 F2 0F 5C C1 F2 44 0F 58 C8 F2 41 0F 10 04 CF F2 0F 58 C8 0F 28 C1 F2 0F 58 C2 F2 0F 5C C8 F2 0F 58 D1 0F 28 C8 F2 0F 58 CB F2 44 0F 58 CA F2 0F 5C C1 0F 28 D1 F2 0F 58 D8 F2 0F 58 D4 F2 44 0F 58 CB F2 0F 5C CA F2 41 0F 10 44 D1 18 0F 28 DD F2 0F 59 D8 F2 0F 58 E1 F2 41 0F 59 C0 F2 44 0F 58 CC 0F 28 E2 F2 0F 58 E3 0F 28 CC F2 0F 5C D4 F2 0F 58 C8 F2 0F 58 DA F2 0F 5C E1 F2 44 0F 58 CB F2 0F 58 C4 0F 28 D5 0F 28 E1 F2 44 0F 58 C8 F2 41 0F 10 44 D1 20 F2 0F 59 D0 F2 41 0F 59 C0 F2 0F 58 E2 0F 28 DC F2 0F 5C CC F2 0F 58 D1 0F 28 CD F2 44 0F 58 CA F2 41 0F 10 54 D1 28 F2 0F 59 CA F2 41 0F 59 D0 F2 0F 58 C1 F2 0F 58 D8 F2 0F 5C E3 F2 0F 58 C4 0F 28 E5 F2 44 0F 58 C8 F2 41 0F 10 44 D1 30 F2 0F 59 E0 F2 44 0F 59 C0 F2 0F 58 D4 0F 28 E3 F2 0F 10 05 ?? ?? ?? ?? F2 0F 58 E2 F2 0F 5C DC F2 0F 58 D3 F2 44 0F 58 CA F2 41 0F 10 54 D1 38 F2 0F 59 EA F2 44 0F 58 C5 41 0F 28 E8 F2 0F 58 EC F2 0F 59 C5 F2 0F 58 E8 F2 0F 11 6C 24 28 F2 0F 10 4C 24 28 F2 0F 5C C8 F2 0F 5C E1 F2 44 0F 58 C4 F2 45 0F 58 C8 F2 45 0F 10 02 41 0F 28 C0 F2 41 0F 59 C1 F2 44 0F 58 C9 F2 41 0F 59 C8 F2 45 0F 59 4A 08 F2 41 0F 58 C1 0F 28 D0 F2 0F 58 D1 F2 0F 5C CA F2 0F 58 C8 F2 0F 58 D1 7F 10 C1 E0 1E F2 41 0F 11 55 00 25 00 00 00 80 EB 25 D1 F8 66 0F 2F 15 ?? ?? ?? ?? 76 13 83 C0 FD F2 0F 5C 15 ?? ?? ?? ?? F2 41 0F 11 55 00 EB 06 F2 41 0F 11 55 00 44 0F 28 44 24 40 44 0F 28 4C 24 30 48 83 C4 50 41 5F 41 5E 41 5D C3 66 66 66 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_304_0_0 {
	meta:
		name = "DllMain"
		size = 20
	strings:
		$1 = { 4C 89 44 24 18 89 54 24 10 48 89 4C 24 08 B8 01 00 00 00 C3 }
	condition:
		$1
}

rule file_314_0_0 {
	meta:
		name = "__sse2_floor2"
		size = 80
		refs = "0006 _2il0floatpacket_4 0010 _2il0floatpacket_5 0038 _2il0floatpacket_6"
	strings:
		$1 = { 0F 28 E0 0F 28 1D ?? ?? ?? ?? 0F 28 E8 0F 28 0D ?? ?? ?? ?? 0F 28 D3 0F 54 E1 0F 55 C8 66 0F C2 D1 01 66 0F 58 CB 66 0F 5C CB 0F 56 CC 0F 28 DA 66 0F C2 E9 01 0F 54 2D ?? ?? ?? ?? 0F 54 C2 66 0F 5C CD 0F 55 D9 0F 56 C3 C3 66 0F 1F 44 00 00 }
	condition:
		$1
}

rule file_326_0_0 {
	meta:
		name = "__common_sacos_cout_rare"
		size = 2672
		refs = "0072 _vmldACosHATab 09d7 _2il0floatpacket_192"
	strings:
		$1 = { 55 48 81 EC D0 00 00 00 48 8D 6C 24 20 33 C0 44 0F B7 41 02 41 81 E0 80 7F 00 00 F3 0F 10 09 41 81 F8 80 7F 00 00 44 0F 29 7D 60 44 0F 29 75 70 44 0F 29 A5 80 00 00 00 44 0F 29 95 90 00 00 00 44 0F 29 45 30 0F 29 7D 40 0F 29 75 50 48 89 9D A0 00 00 00 0F 84 FA 09 00 00 F3 0F 5A C1 F2 0F 11 45 18 80 65 1F 7F F2 44 0F 10 45 18 F2 44 0F 10 25 ?? ?? ?? ?? 4C 8B 0D ?? ?? ?? ?? 66 45 0F 2F E0 0F 86 42 09 00 00 F2 0F 10 05 ?? ?? ?? ?? 66 41 0F 2F C0 0F 86 F7 03 00 00 66 44 0F 2F 05 ?? ?? ?? ?? 0F 86 9B 03 00 00 F2 44 0F 10 25 ?? ?? ?? ?? 41 0F 28 C0 F2 41 0F 59 C4 41 0F 28 D0 F2 0F 11 45 10 45 0F 28 F8 F2 0F 10 65 10 41 0F 28 DC F2 0F 10 3D ?? ?? ?? ?? F2 0F 5C 65 18 F2 0F 11 65 08 F2 0F 10 4D 10 F2 44 0F 10 55 08 F2 41 0F 5C CA F2 0F 11 4D 10 F2 0F 10 75 10 F2 0F 5C D6 F2 0F 11 55 08 F2 0F 10 6D 10 0F 28 D5 F2 44 0F 58 FD F2 0F 59 D5 F2 44 0F 10 75 08 0F 28 C2 F2 45 0F 59 FE F2 0F 59 DA F2 41 0F 58 C7 F2 0F 59 F8 F2 0F 11 5D 10 F2 0F 10 65 10 F2 0F 58 3D ?? ?? ?? ?? F2 0F 5C E2 F2 0F 59 F8 F2 0F 11 65 08 F2 0F 10 4D 10 F2 44 0F 10 55 08 F2 0F 58 3D ?? ?? ?? ?? F2 41 0F 5C CA F2 0F 59 F8 F2 0F 11 4D 10 F2 0F 10 75 10 F2 0F 58 3D ?? ?? ?? ?? F2 0F 5C D6 F2 0F 59 F8 F2 0F 11 55 08 41 0F 28 F0 F2 0F 10 65 10 F2 0F 10 5D 08 F2 44 0F 59 F4 F2 0F 58 3D ?? ?? ?? ?? F2 44 0F 58 FB F2 0F 59 EC F2 0F 59 F8 F2 41 0F 59 F7 F2 0F 58 3D ?? ?? ?? ?? F2 41 0F 58 F6 F2 0F 59 F8 45 0F 28 F4 F2 0F 58 3D ?? ?? ?? ?? F2 44 0F 59 F5 F2 0F 59 F8 F2 44 0F 11 75 10 F2 44 0F 10 55 10 F2 44 0F 5C D5 F2 0F 58 3D ?? ?? ?? ?? F2 44 0F 11 55 08 44 0F 28 D5 F2 0F 10 55 10 F2 0F 58 EE F2 0F 59 F8 F2 44 0F 59 FD F2 0F 58 3D ?? ?? ?? ?? F2 0F 10 4D 08 F2 0F 59 F8 F2 0F 5C D1 F2 0F 11 55 10 F2 0F 10 5D 10 F2 44 0F 5C D3 0F 28 DC F2 0F 58 3D ?? ?? ?? ?? F2 44 0F 11 55 08 F2 0F 10 4D 10 F2 0F 10 55 08 44 0F 28 F2 F2 0F 59 D9 F2 44 0F 58 F6 F2 0F 59 F8 F2 41 0F 59 E6 F2 44 0F 59 E3 F2 0F 58 3D ?? ?? ?? ?? F2 41 0F 58 E7 F2 0F 59 F8 F2 44 0F 11 65 10 44 0F 28 F3 F2 44 0F 10 65 10 F2 44 0F 5C E3 F2 0F 58 DC F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 C3 F2 0F 59 F8 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 C5 F2 0F 10 2D ?? ?? ?? ?? F2 0F 59 EB F2 44 0F 11 65 08 F2 0F 58 C5 F2 44 0F 10 65 10 F2 0F 58 C7 F2 0F 10 3D ?? ?? ?? ?? F2 0F 59 F7 F2 0F 59 D7 F2 0F 59 CF F2 0F 58 C6 F2 44 0F 10 7D 08 F2 0F 58 C2 F2 45 0F 5C E7 F2 44 0F 11 65 10 41 0F 28 D0 F2 44 0F 10 55 10 F2 0F 58 D1 F2 45 0F 5C F2 F2 44 0F 11 75 08 F2 44 0F 10 65 10 F2 44 0F 10 55 08 F2 0F 11 55 10 F2 0F 10 5D 10 F2 0F 11 4D 00 F2 44 0F 5C C3 F2 44 0F 58 C1 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 E1 F2 44 0F 59 E1 F2 41 0F 59 CA F2 44 0F 11 45 08 F2 0F 10 55 10 F2 44 0F 10 45 08 F2 41 0F 58 C0 F2 0F 58 C4 0F 28 E2 F2 41 0F 58 E4 F2 0F 58 C1 F2 0F 11 65 10 F2 44 0F 10 45 10 F2 41 0F 5C D0 F2 41 0F 58 D4 F2 0F 11 55 08 F3 0F 5A 29 F2 0F 10 65 10 F2 0F 10 5D 08 66 0F 2F 2D ?? ?? ?? ?? F2 0F 58 C3 76 42 F2 0F 10 1D ?? ?? ?? ?? 0F 28 CB F2 0F 5C CC F2 0F 11 4D 10 F2 0F 10 55 10 F2 0F 10 0D ?? ?? ?? ?? F2 0F 5C DA F2 0F 5C C8 F2 0F 5C DC F2 0F 11 5D 08 F2 0F 10 55 10 F2 0F 10 65 08 F2 0F 58 CC EB 40 F2 0F 10 1D ?? ?? ?? ?? 0F 28 CC F2 0F 58 CB F2 0F 11 4D 10 F2 0F 10 55 10 F2 0F 5C DA F2 0F 58 DC F2 0F 10 25 ?? ?? ?? ?? F2 0F 58 C4 F2 0F 11 5D 08 F2 0F 10 55 10 F2 0F 10 4D 08 F2 0F 58 C8 F2 0F 58 D1 F2 0F 5A D2 F3 0F 11 12 E9 B0 05 00 00 F2 0F 10 0D ?? ?? ?? ?? F2 45 0F 58 E0 F2 44 0F 11 65 10 F2 0F 10 45 10 F2 0F 59 45 18 F2 0F 11 45 00 8A 5D 07 8A 49 03 80 E3 7F 80 E1 80 0A D9 88 5D 07 F2 0F 5C 4D 00 F2 0F 58 0D ?? ?? ?? ?? F2 0F 5A C9 F3 0F 11 0A E9 63 05 00 00 4D 8B D1 F2 45 0F 5C E0 F2 41 0F 59 C4 F2 0F 11 45 00 44 0F B7 45 06 41 81 E0 F0 7F 00 00 41 C1 E8 04 41 81 C0 01 FC FF FF 45 8B D8 41 8B D8 41 F7 DB 41 81 C3 FF 03 00 00 49 C1 EA 30 41 81 E3 FF 07 00 00 41 C1 E3 04 41 81 E2 0F 80 FF FF 4C 89 4D 18 45 0B D3 66 44 89 55 1E 83 E3 01 F2 0F 10 75 18 44 8B DB F2 0F 59 C6 0F 28 E8 F2 44 0F 10 05 ?? ?? ?? ?? F2 0F 58 E8 75 03 0F 28 E8 F2 44 0F 59 C5 44 2B C3 F2 0F 10 1D ?? ?? ?? ?? 41 0F 28 F8 41 C1 E3 08 44 0F 28 D5 41 D1 E8 F2 0F 58 C3 F2 0F 5C FD F2 0F 11 45 20 41 81 C0 FF 03 00 00 44 8B 55 20 41 81 E0 FF 07 00 00 41 81 E2 FF 01 00 00 F2 0F 11 7D 08 45 03 D3 F2 0F 10 75 08 4C 8D 1D ?? ?? ?? ?? F2 44 0F 5C C6 F2 47 0F 10 3C D3 41 0F 28 E0 4C 89 4D 28 41 0F 28 D7 49 C1 E9 30 F2 45 0F 5C D0 F2 45 0F 59 C7 F2 41 0F 59 D7 41 C1 E0 04 41 81 E1 0F 80 FF FF 45 0B C8 66 44 89 4D 2E F2 44 0F 10 75 28 F2 45 0F 59 C6 F2 0F 59 E2 F2 41 0F 59 D2 F2 0F 5C 25 ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? F2 0F 58 E2 0F 28 C1 F2 41 0F 59 C0 F2 0F 11 45 10 F2 0F 10 7D 10 F2 0F 10 35 ?? ?? ?? ?? F2 41 0F 5C F8 F2 0F 59 F4 F2 0F 11 7D 08 F2 0F 10 3D ?? ?? ?? ?? F2 41 0F 59 FC F2 0F 58 35 ?? ?? ?? ?? F2 0F 59 F4 F2 0F 58 3D ?? ?? ?? ?? F2 41 0F 59 FC F2 0F 58 35 ?? ?? ?? ?? F2 0F 59 F4 F2 0F 58 3D ?? ?? ?? ?? F2 41 0F 59 FC F2 0F 58 35 ?? ?? ?? ?? F2 0F 59 F4 F2 0F 58 3D ?? ?? ?? ?? F2 41 0F 59 FC F2 0F 58 35 ?? ?? ?? ?? F2 0F 59 F4 F2 0F 58 3D ?? ?? ?? ?? F2 41 0F 59 FC F2 0F 58 35 ?? ?? ?? ?? F2 0F 59 F4 F2 0F 58 3D ?? ?? ?? ?? F2 41 0F 59 FC F2 0F 58 35 ?? ?? ?? ?? F2 0F 59 F4 F2 0F 58 3D ?? ?? ?? ?? F2 41 0F 59 FC F2 41 0F 59 F7 F2 45 0F 59 FA F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F5 F2 41 0F 59 FC F2 41 0F 58 F7 F2 0F 58 3D ?? ?? ?? ?? F2 41 0F 59 F6 F2 41 0F 59 FC F2 0F 10 55 10 F2 0F 10 5D 08 F2 44 0F 10 15 ?? ?? ?? ?? F2 0F 5C D3 F2 0F 58 3D ?? ?? ?? ?? F2 44 0F 58 15 ?? ?? ?? ?? F2 41 0F 59 FC F2 45 0F 59 D4 F2 0F 58 3D ?? ?? ?? ?? F2 41 0F 59 FC F2 0F 11 55 10 0F 28 D1 F2 0F 10 65 10 F2 0F 10 1D ?? ?? ?? ?? F2 44 0F 5C C4 F2 41 0F 59 D4 F2 0F 58 3D ?? ?? ?? ?? 44 0F 28 FB F2 44 0F 11 45 08 F2 44 0F 10 45 10 F2 0F 10 6D 08 F2 0F 11 55 10 F2 0F 58 F5 F2 41 0F 59 FC F2 44 0F 58 3D ?? ?? ?? ?? F2 0F 10 65 10 F2 45 0F 58 FA F2 41 0F 59 FC F2 41 0F 5C E4 F2 45 0F 59 FC F2 41 0F 59 FC F2 0F 10 05 ?? ?? ?? ?? 45 0F 28 D4 44 0F 28 F0 F2 0F 11 65 08 F2 0F 10 6D 10 F2 0F 10 55 08 F2 44 0F 58 35 ?? ?? ?? ?? F2 0F 5C EA F2 45 0F 58 F7 F2 0F 11 6D 10 44 0F 28 F9 F2 0F 10 65 10 F2 44 0F 58 F7 F2 44 0F 5C D4 F2 41 0F 59 F6 F2 44 0F 11 55 08 F2 44 0F 10 75 10 41 0F 28 EE 41 0F 28 E6 F2 41 0F 59 EE F2 41 0F 58 E4 F2 44 0F 59 F3 F2 44 0F 59 FD F2 0F 10 55 08 F2 44 0F 11 7D 10 F2 44 0F 10 55 10 F2 0F 59 E2 F2 44 0F 5C D5 F2 0F 59 DA F2 44 0F 11 55 08 F2 44 0F 10 55 10 F2 44 0F 10 7D 08 F2 0F 10 15 ?? ?? ?? ?? F2 45 0F 5C D7 F2 41 0F 59 D4 F2 44 0F 11 55 10 F2 44 0F 10 7D 10 F2 41 0F 5C EF 45 0F 28 FE F2 0F 58 15 ?? ?? ?? ?? F2 0F 11 6D 08 F2 44 0F 10 55 10 F2 44 0F 59 15 ?? ?? ?? ?? F2 41 0F 59 D4 F2 45 0F 58 FA F2 0F 58 15 ?? ?? ?? ?? F2 0F 10 6D 08 F2 0F 58 D7 F2 0F 58 EC F2 41 0F 59 D0 F2 0F 59 2D ?? ?? ?? ?? F2 44 0F 11 7D 10 F2 44 0F 10 7D 10 F2 44 0F 11 55 20 F2 45 0F 5C F7 F2 45 0F 58 F2 F2 44 0F 11 75 08 44 0F 28 F0 F2 44 0F 10 7D 10 F2 44 0F 10 55 08 F2 45 0F 58 F7 F2 44 0F 11 75 10 F2 44 0F 10 75 10 F2 41 0F 5C C6 F2 41 0F 58 C7 F2 0F 11 45 08 F2 44 0F 10 75 10 F2 41 0F 59 CE F2 44 0F 10 7D 08 F2 0F 11 4D 10 F2 0F 10 4D 10 F2 41 0F 5C CE F2 0F 11 4D 08 F2 0F 10 4D 10 F2 0F 10 45 08 F2 0F 5C C8 F2 0F 11 4D 10 F2 0F 10 45 10 F2 44 0F 5C F0 F2 44 0F 11 75 08 F2 0F 10 45 10 F2 44 0F 10 75 08 F3 44 0F 5A 21 F2 45 0F 58 F2 66 44 0F 2F 25 ?? ?? ?? ?? F2 45 0F 58 F7 F2 44 0F 58 F3 F2 44 0F 58 F5 F2 45 0F 59 F0 F2 44 0F 59 C0 F2 41 0F 58 F6 F2 0F 58 F2 77 4C F2 0F 10 15 ?? ?? ?? ?? 0F 28 C2 F2 0F 10 25 ?? ?? ?? ?? F2 41 0F 5C C0 F2 0F 5C E6 F2 0F 11 45 10 F2 0F 10 4D 10 F2 44 0F 11 45 00 F2 0F 5C D1 F2 41 0F 5C D0 F2 0F 11 55 08 F2 44 0F 10 45 10 F2 0F 10 5D 08 0F 28 F3 F2 0F 58 F4 F2 44 0F 58 C6 F2 45 0F 5A C0 F3 44 0F 11 02 EB 2B 66 41 0F 2E C4 7A 02 74 73 44 0F 57 25 ?? ?? ?? ?? 66 41 0F 2E C4 7A 02 74 48 B8 01 00 00 00 F3 0F 5C C9 F3 0F 5E C9 F3 0F 11 0A 0F 28 75 50 0F 28 7D 40 44 0F 28 45 30 44 0F 28 95 90 00 00 00 44 0F 28 A5 80 00 00 00 44 0F 28 75 70 44 0F 28 7D 60 48 8B 9D A0 00 00 00 48 8D A5 B0 00 00 00 5D C3 F2 0F 10 05 ?? ?? ?? ?? F2 0F 58 05 ?? ?? ?? ?? F2 0F 5A C0 F3 0F 11 02 EB AF F2 0F 5A 05 ?? ?? ?? ?? F3 0F 11 02 EB A1 F3 0F 5E C9 F3 0F 11 0A BA 01 00 00 00 33 C0 F7 01 FF FF 7F 00 0F 44 C2 EB 87 66 90 }
	condition:
		$1
}

rule file_328_0_0 {
	meta:
		name = "__common_satan2_cout_rare"
		size = 4656
		refs = "010c _vmldAtanHATab"
	strings:
		$1 = { 56 41 55 48 81 EC B8 00 00 00 F3 0F 10 19 F3 0F 10 12 F3 0F 5A C3 F3 0F 5A CA F2 0F 11 44 24 38 F2 0F 11 4C 24 40 0F B7 41 02 25 80 7F 00 00 44 8A 52 03 44 0F B7 4C 24 3E 41 80 E2 80 0F B7 74 24 46 41 81 E1 F0 7F 00 00 81 E6 F0 7F 00 00 C1 E8 07 44 8A 59 03 41 C0 EB 07 41 C0 EA 07 44 0F 29 BC 24 90 00 00 00 44 0F 29 B4 24 A0 00 00 00 44 0F 29 6C 24 70 44 0F 29 A4 24 80 00 00 00 41 C1 E9 04 C1 EE 04 3D FF 00 00 00 0F 84 65 10 00 00 44 0F B7 6A 02 41 81 E5 80 7F 00 00 41 81 FD 80 7F 00 00 0F 84 4C 10 00 00 45 85 C9 75 0C F7 01 FF FF 7F 00 0F 84 8F 0F 00 00 85 F6 75 0C F7 02 FF FF 7F 00 0F 84 3E 0F 00 00 F7 DE F2 0F 11 44 24 38 41 03 F1 F2 0F 11 4C 24 40 8A 54 24 3F 8A 44 24 47 80 E2 7F 24 7F 83 FE CA 0F 8E 42 0E 00 00 83 FE 36 0F 8D EB 0D 00 00 88 44 24 47 45 84 D2 88 54 24 3F 75 0D F2 0F 10 0D ?? ?? ?? ?? 0F 28 D1 EB 10 F2 0F 10 0D ?? ?? ?? ?? F2 0F 10 15 ?? ?? ?? ?? F2 0F 10 64 24 38 45 85 C9 F2 0F 10 44 24 40 0F 28 EC F2 0F 5E E8 48 8B 44 24 38 F2 0F 11 6C 24 58 0F 8E 8D 0F 00 00 41 81 F9 FE 07 00 00 7D 21 48 89 44 24 38 41 81 C1 01 FC FF FF 48 C1 E8 30 25 0F 80 FF FF 0D F0 3F FF FF 66 89 44 24 3E EB 18 F2 0F 10 1D ?? ?? ?? ?? 41 B9 FE 03 00 00 F2 0F 59 E3 F2 0F 11 64 24 38 41 F7 D9 48 8B 05 ?? ?? ?? ?? 41 81 C1 FF 03 00 00 48 89 44 24 40 41 81 E1 FF 07 00 00 48 C1 E8 30 41 C1 E1 04 25 0F 80 FF FF 41 0B C1 66 89 44 24 46 F2 0F 10 5C 24 40 F2 0F 59 C3 66 0F 2F 2D ?? ?? ?? ?? 0F 82 40 08 00 00 F2 44 0F 10 2D ?? ?? ?? ?? 0F 28 D8 F2 41 0F 59 DD 44 0F 28 F0 F2 0F 11 5C 24 20 F2 44 0F 10 7C 24 20 F2 0F 11 6C 24 40 F2 44 0F 5C F8 F2 44 0F 11 7C 24 28 F2 0F 10 6C 24 20 F2 0F 10 64 24 28 8B 4C 24 44 8B F1 81 E1 00 00 08 00 81 E6 00 00 F0 FF 81 C9 00 00 04 00 F2 0F 5C EC F2 0F 11 6C 24 20 0B F1 F2 0F 10 5C 24 20 C7 44 24 40 00 00 00 00 F2 44 0F 5C F3 89 74 24 44 F2 44 0F 11 74 24 28 F2 0F 10 6C 24 20 F2 0F 10 64 24 40 F2 44 0F 10 74 24 28 F2 0F 59 EC F2 44 0F 59 F4 F2 44 0F 10 25 ?? ?? ?? ?? F2 41 0F 59 EC F2 45 0F 59 F4 44 0F 28 FD 0F B7 54 24 5E F2 45 0F 58 FE F2 44 0F 11 7C 24 20 81 E2 F0 7F 00 00 F2 0F 10 5C 24 20 C1 EA 04 F2 0F 5C EB F2 0F 10 5C 24 38 F2 41 0F 58 EE F2 0F 11 6C 24 28 44 0F 28 FB F2 44 0F 10 64 24 20 F2 44 0F 10 74 24 28 F2 45 0F 58 FC F2 44 0F 11 7C 24 20 44 0F 28 FB F2 0F 10 6C 24 20 8B 44 24 5C F2 44 0F 5C FD F2 44 0F 11 7C 24 28 25 FF FF 0F 00 F2 44 0F 10 7C 24 20 F2 0F 10 6C 24 28 C1 E2 14 F2 44 0F 58 FD F2 44 0F 11 7C 24 30 44 0F 28 FB F2 0F 10 6C 24 28 0B D0 81 C2 00 00 40 C0 B8 71 00 00 00 C1 FA 13 F2 44 0F 58 E5 F2 44 0F 11 64 24 28 83 FA 71 F2 44 0F 10 64 24 30 0F 4C C2 48 8D 15 ?? ?? ?? ?? 03 C0 48 8B CA 48 63 C0 F2 45 0F 5C FC F2 44 0F 11 7C 24 30 F2 0F 10 6C 24 28 F2 44 0F 10 64 24 30 F2 41 0F 58 EC F2 0F 11 6C 24 30 F2 0F 10 6C 24 20 F2 44 0F 10 64 24 30 F2 45 0F 58 E6 44 0F 28 F5 F2 45 0F 59 F5 F2 44 0F 11 74 24 20 F2 44 0F 10 7C 24 20 F2 44 0F 5C FD F2 44 0F 11 7C 24 28 F2 44 0F 10 7C 24 20 F2 44 0F 10 74 24 28 F2 45 0F 5C FE F2 44 0F 11 7C 24 20 44 0F 28 FB F2 44 0F 10 74 24 20 F2 44 0F 59 3D ?? ?? ?? ?? F2 41 0F 5C EE F2 0F 11 6C 24 28 F2 0F 10 6C 24 20 F2 44 0F 10 74 24 28 F2 44 0F 11 7C 24 20 F2 45 0F 58 E6 F2 44 0F 10 74 24 20 F2 44 0F 5C 74 24 38 F2 44 0F 11 74 24 28 F2 44 0F 10 74 24 20 F2 44 0F 10 7C 24 28 F2 45 0F 5C F7 F2 44 0F 11 74 24 20 F2 44 0F 10 7C 24 20 F2 41 0F 5C DF F2 0F 11 5C 24 28 F2 0F 10 5C 24 20 F2 44 0F 10 74 24 28 F2 0F 59 DC F2 44 0F 59 F4 0F 28 E3 F2 41 0F 58 E6 F2 0F 11 64 24 20 F2 44 0F 10 7C 24 20 F2 41 0F 5C DF F2 41 0F 58 DE F2 0F 11 5C 24 28 0F 28 D8 F2 44 0F 10 74 24 20 F2 44 0F 10 7C 24 28 F2 41 0F 58 DE F2 0F 11 5C 24 20 0F 28 D8 F2 0F 10 64 24 20 F2 0F 5C DC F2 0F 11 5C 24 28 F2 0F 10 5C 24 20 F2 0F 10 64 24 28 F2 0F 58 DC F2 0F 11 5C 24 30 F2 0F 10 64 24 28 F2 44 0F 58 F4 F2 44 0F 11 74 24 28 F2 44 0F 10 74 24 30 F2 41 0F 5C C6 F2 0F 11 44 24 30 F2 0F 10 5C 24 28 F2 0F 10 44 24 30 F2 0F 58 D8 F2 0F 11 5C 24 30 F2 0F 10 5C 24 20 F2 0F 10 44 24 30 F2 41 0F 58 C7 44 0F 28 FB F2 45 0F 59 FD F2 44 0F 11 7C 24 20 F2 0F 10 64 24 20 F2 0F 5C E3 F2 0F 11 64 24 28 F2 44 0F 10 7C 24 20 F2 44 0F 10 74 24 28 F2 45 0F 5C FE F2 44 0F 11 7C 24 20 F2 44 0F 10 74 24 20 F2 41 0F 5C DE F2 44 0F 10 35 ?? ?? ?? ?? F2 0F 11 5C 24 28 F2 44 0F 10 7C 24 20 F2 0F 10 5C 24 28 F2 0F 58 C3 41 0F 28 DE F2 41 0F 5E DF 0F 28 E3 F2 41 0F 59 E5 F2 0F 11 64 24 28 F2 0F 10 64 24 28 F2 0F 5C E3 F2 0F 11 64 24 30 F2 0F 10 64 24 28 F2 0F 10 5C 24 30 F2 0F 5C E3 F2 0F 11 64 24 30 F2 0F 10 5C 24 30 F2 44 0F 59 FB F2 45 0F 5C F7 F2 44 0F 10 7C 24 30 F2 41 0F 59 C7 F2 0F 11 44 24 28 F2 0F 10 44 24 28 F2 44 0F 5C F0 F2 44 0F 11 74 24 28 F2 0F 10 64 24 28 4C 8B 4C 24 30 F2 0F 10 5C 24 28 F2 44 0F 10 74 24 30 4C 89 4C 24 48 F2 44 0F 10 7C 24 48 F2 0F 58 25 ?? ?? ?? ?? F2 0F 59 E3 41 0F 28 DF F2 0F 59 DD F2 41 0F 59 E6 44 0F 28 F4 F2 45 0F 59 F4 F2 0F 59 EC F2 45 0F 59 E7 F2 44 0F 58 F5 F2 44 0F 10 3D ?? ?? ?? ?? F2 45 0F 58 F4 F2 44 0F 11 74 24 20 44 0F 28 E3 F2 44 0F 10 74 24 20 F2 45 0F 58 E6 F2 44 0F 11 64 24 20 F2 0F 10 6C 24 20 F2 0F 5C DD F2 41 0F 58 DE F2 0F 11 5C 24 28 F2 0F 10 6C 24 20 0F 28 C5 0F 28 E5 F2 0F 59 C5 F2 41 0F 59 E5 F2 44 0F 59 F8 F2 0F 10 5C 24 28 F2 0F 11 64 24 20 F2 44 0F 10 74 24 20 F2 44 0F 58 3D ?? ?? ?? ?? F2 44 0F 5C F5 F2 44 0F 59 F8 F2 44 0F 11 74 24 28 F2 44 0F 58 3D ?? ?? ?? ?? F2 44 0F 59 F8 F2 44 0F 58 3D ?? ?? ?? ?? F2 44 0F 59 F8 F2 44 0F 58 3D ?? ?? ?? ?? F2 44 0F 59 F8 F2 44 0F 58 3D ?? ?? ?? ?? F2 44 0F 59 F8 F2 44 0F 58 3D ?? ?? ?? ?? F2 41 0F 59 C7 F2 44 0F 10 7C 24 20 F2 44 0F 10 64 24 28 F2 44 0F 59 E8 F2 45 0F 5C FC F2 44 0F 11 7C 24 20 F2 44 0F 10 74 24 20 F2 41 0F 5C EE F2 0F 11 6C 24 28 F2 44 0F 10 64 24 20 F2 0F 10 6C 24 28 F2 44 0F 11 6C 24 20 F2 0F 58 DD F2 44 0F 10 6C 24 20 F2 44 0F 5C E8 F2 44 0F 11 6C 24 28 F2 44 0F 10 7C 24 20 F2 44 0F 10 74 24 28 F2 45 0F 5C FE F2 44 0F 11 7C 24 20 F2 0F 10 64 24 20 F2 0F 5C C4 F2 0F 11 44 24 28 F2 0F 10 44 24 20 F2 0F 10 6C 24 28 44 0F 28 F0 44 0F 28 FD F2 44 0F 59 FB F2 0F 59 C3 F2 41 0F 59 EC F2 45 0F 59 F4 F2 44 0F 58 F8 41 0F 28 C6 41 0F 28 E6 F2 44 0F 58 FD F2 41 0F 58 C4 F2 44 0F 11 7C 24 20 F2 44 0F 10 7C 24 20 F2 0F 11 44 24 20 F2 44 0F 10 6C 24 20 F2 41 0F 5C E5 F2 0F 11 64 24 28 F2 0F 10 6C 24 20 F2 0F 10 44 24 28 F2 0F 58 E8 F2 0F 11 6C 24 30 F2 44 0F 10 6C 24 28 F2 45 0F 58 E5 F2 44 0F 11 64 24 28 F2 44 0F 10 64 24 30 F2 45 0F 5C F4 F2 44 0F 11 74 24 30 F2 0F 10 44 24 28 F2 44 0F 10 74 24 30 F2 41 0F 58 C6 F2 0F 11 44 24 30 4C 8B 6C 24 20 4C 89 6C 24 48 F2 44 0F 10 74 24 48 41 0F 28 EE 45 0F 28 EE F2 0F 10 64 24 30 F2 0F 58 2C C2 F2 0F 58 DC F2 0F 11 6C 24 20 F2 41 0F 58 DF F2 44 0F 10 64 24 20 F2 0F 11 5C 24 50 F2 45 0F 5C EC F2 44 0F 11 6C 24 28 F2 0F 10 44 24 20 F2 44 0F 10 7C 24 28 F2 41 0F 58 C7 F2 0F 11 44 24 30 F2 0F 10 64 24 28 F2 0F 58 24 C1 F2 0F 11 64 24 28 F2 0F 10 6C 24 30 F2 44 0F 5C F5 F2 44 0F 11 74 24 30 F2 44 0F 10 6C 24 28 F2 44 0F 10 64 24 30 F2 45 0F 58 EC F2 44 0F 11 6C 24 30 48 8B 4C 24 20 F2 0F 10 44 24 30 48 89 4C 24 48 48 8D 15 ?? ?? ?? ?? F2 0F 58 D8 41 C0 E3 07 0F 28 C1 F2 0F 58 5C C2 08 41 8A C2 C0 E0 07 F2 0F 11 5C 24 50 48 C1 E9 38 40 8A 74 24 57 44 8A CE 40 C0 EE 07 41 80 E1 7F 80 E1 7F 44 32 D6 0A C8 88 4C 24 4F F2 44 0F 10 74 24 48 41 0F 28 E6 F2 41 0F 58 C6 41 C0 E2 07 F2 0F 11 44 24 20 F2 0F 10 5C 24 20 F2 0F 5C E3 F2 0F 11 64 24 28 45 0A CA F2 44 0F 10 64 24 20 F2 0F 10 6C 24 28 44 88 4C 24 57 F2 44 0F 58 E5 F2 44 0F 11 64 24 30 F2 44 0F 10 6C 24 28 F2 41 0F 58 CD F2 0F 11 4C 24 28 F2 0F 10 4C 24 30 F2 44 0F 5C F1 F2 44 0F 11 74 24 30 F2 0F 10 44 24 28 F2 44 0F 10 7C 24 30 F2 41 0F 58 C7 F2 0F 11 44 24 30 4C 8B 54 24 20 F2 0F 10 4C 24 30 4C 89 54 24 48 F2 0F 58 4C 24 50 F2 0F 58 CA F2 0F 10 54 24 48 F2 0F 11 4C 24 50 F2 0F 58 D1 F2 0F 11 54 24 68 44 8A 6C 24 6F 41 80 E5 7F 45 0A EB 44 88 6C 24 6F F2 0F 5A 44 24 68 F3 41 0F 11 00 E9 93 06 00 00 F2 44 0F 10 6C 24 38 41 8A CA 41 0F 28 ED F2 0F 59 2D ?? ?? ?? ?? C0 E1 07 41 C0 E3 07 F2 0F 11 6C 24 20 F2 0F 10 64 24 20 F2 0F 10 2D ?? ?? ?? ?? F2 0F 5C 64 24 38 F2 0F 11 64 24 28 F2 0F 10 5C 24 20 F2 44 0F 10 7C 24 28 F2 41 0F 5C DF F2 0F 11 5C 24 20 F2 44 0F 10 64 24 20 F2 45 0F 5C EC 44 0F 28 E0 F2 44 0F 59 E5 F2 44 0F 11 6C 24 28 F2 0F 10 5C 24 20 F2 0F 10 64 24 28 F2 44 0F 11 64 24 20 F2 44 0F 10 7C 24 20 F2 44 0F 5C F8 F2 44 0F 11 7C 24 28 F2 44 0F 10 64 24 20 F2 44 0F 10 74 24 28 F2 45 0F 5C E6 F2 44 0F 11 64 24 20 F2 44 0F 10 6C 24 20 F2 41 0F 5C C5 F2 0F 11 44 24 28 F2 0F 10 05 ?? ?? ?? ?? F2 44 0F 10 74 24 20 44 0F 28 E8 F2 45 0F 5E EE 45 0F 28 FD F2 44 0F 59 FD F2 44 0F 10 64 24 28 F2 44 0F 11 7C 24 28 F2 44 0F 10 7C 24 28 F2 45 0F 5C FD F2 44 0F 11 7C 24 30 F2 44 0F 10 7C 24 28 F2 44 0F 10 6C 24 30 F2 45 0F 5C FD F2 44 0F 11 7C 24 30 F2 44 0F 10 6C 24 30 F2 45 0F 59 F5 F2 41 0F 5C C6 F2 44 0F 10 74 24 30 F2 45 0F 59 E6 F2 44 0F 11 64 24 28 F2 44 0F 10 64 24 28 F2 41 0F 5C C4 F2 0F 11 44 24 28 F2 44 0F 10 64 24 28 48 8B 44 24 30 F2 0F 10 44 24 28 48 89 44 24 48 F2 44 0F 10 6C 24 48 F2 44 0F 58 25 ?? ?? ?? ?? F2 44 0F 59 E0 F2 0F 10 44 24 30 F2 44 0F 59 E0 41 0F 28 C5 F2 0F 59 C3 F2 44 0F 59 EC F2 41 0F 59 DC 45 0F 28 FC F2 44 0F 59 FC F2 44 0F 58 FB 0F 28 D8 F2 45 0F 58 FD F2 44 0F 11 7C 24 20 F2 44 0F 10 64 24 20 F2 44 0F 10 3D ?? ?? ?? ?? F2 41 0F 58 DC F2 0F 11 5C 24 20 F2 0F 10 64 24 20 F2 0F 5C C4 F2 41 0F 58 C4 F2 0F 11 44 24 28 F2 0F 10 44 24 58 F2 0F 59 C0 F2 44 0F 59 F8 F2 44 0F 10 74 24 20 45 0F 28 EE F2 44 0F 58 3D ?? ?? ?? ?? F2 44 0F 59 ED F2 44 0F 59 F8 F2 0F 10 5C 24 28 F2 44 0F 11 6C 24 20 F2 0F 10 64 24 20 F2 44 0F 58 3D ?? ?? ?? ?? F2 41 0F 5C E6 F2 44 0F 59 F8 F2 0F 11 64 24 28 F2 44 0F 10 64 24 20 F2 44 0F 58 3D ?? ?? ?? ?? F2 44 0F 59 F8 F2 44 0F 58 3D ?? ?? ?? ?? F2 44 0F 59 F8 F2 44 0F 58 3D ?? ?? ?? ?? F2 44 0F 59 F8 F2 44 0F 58 3D ?? ?? ?? ?? F2 44 0F 59 F8 F2 0F 10 44 24 28 F2 41 0F 59 EF F2 44 0F 5C E0 F2 44 0F 11 64 24 20 F2 44 0F 10 6C 24 20 F2 45 0F 5C F5 F2 44 0F 11 74 24 28 F2 44 0F 10 6C 24 20 F2 44 0F 10 74 24 28 F2 0F 11 6C 24 20 F2 41 0F 58 DE F2 0F 10 6C 24 20 F2 41 0F 5C EF F2 0F 11 6C 24 28 F2 44 0F 10 64 24 20 F2 0F 10 44 24 28 F2 44 0F 5C E0 F2 44 0F 11 64 24 20 F2 0F 10 64 24 20 F2 44 0F 5C FC F2 44 0F 11 7C 24 28 F2 44 0F 10 74 24 20 F2 44 0F 10 7C 24 28 45 0F 28 E6 41 0F 28 C7 F2 0F 59 C3 F2 44 0F 59 F3 F2 45 0F 59 FD F2 45 0F 59 E5 F2 41 0F 58 C6 41 0F 28 E4 45 0F 28 F4 F2 41 0F 58 C7 F2 41 0F 58 E5 F2 0F 11 44 24 20 F2 0F 10 44 24 20 F2 0F 11 64 24 20 F2 0F 10 6C 24 20 F2 44 0F 5C F5 F2 44 0F 11 74 24 28 F2 0F 10 6C 24 20 F2 0F 10 64 24 28 F2 0F 58 EC F2 0F 11 6C 24 30 F2 44 0F 10 7C 24 28 F2 45 0F 58 EF F2 44 0F 11 6C 24 28 F2 44 0F 10 6C 24 30 F2 45 0F 5C E5 F2 44 0F 11 64 24 30 F2 0F 10 6C 24 28 F2 0F 10 64 24 30 F2 0F 58 EC F2 0F 11 6C 24 30 48 8B 54 24 20 F2 44 0F 10 64 24 30 48 89 54 24 48 F2 41 0F 58 DC 48 C1 EA 38 F2 0F 58 D8 80 E2 7F 0A D1 88 54 24 4F F2 0F 11 5C 24 50 0F 28 D9 F2 44 0F 10 6C 24 48 41 0F 28 C5 F2 41 0F 58 DD F2 0F 11 5C 24 20 F2 0F 10 5C 24 20 40 8A 74 24 57 44 8A CE 40 C0 EE 07 F2 0F 5C C3 F2 0F 11 44 24 28 F2 0F 10 6C 24 20 F2 0F 10 64 24 28 44 32 D6 41 80 E1 7F 41 C0 E2 07 F2 0F 58 EC F2 0F 11 6C 24 30 F2 44 0F 10 64 24 28 F2 41 0F 58 CC F2 0F 11 4C 24 28 45 0A CA F2 0F 10 4C 24 30 44 88 4C 24 57 F2 44 0F 5C E9 F2 44 0F 11 6C 24 30 F2 0F 10 5C 24 28 F2 0F 10 44 24 30 F2 0F 58 D8 F2 0F 11 5C 24 30 4C 8B 54 24 20 F2 0F 10 64 24 30 4C 89 54 24 48 F2 0F 58 64 24 50 F2 0F 58 E2 F2 0F 10 54 24 48 F2 0F 11 64 24 50 F2 0F 58 D4 F2 0F 11 54 24 68 44 8A 6C 24 6F 41 80 E5 7F 45 0A EB 44 88 6C 24 6F F2 0F 5A 44 24 68 F3 41 0F 11 00 E9 C5 01 00 00 83 FE 4A 0F 8D 27 01 00 00 88 54 24 3F F2 0F 5E 4C 24 38 F2 0F 10 05 ?? ?? ?? ?? 41 C0 E3 07 F2 0F 5C C1 F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 44 24 68 8A 44 24 6F 24 7F 41 0A C3 88 44 24 6F F2 0F 5A 4C 24 68 F3 41 0F 11 08 E9 77 01 00 00 45 84 D2 0F 85 3C 01 00 00 88 54 24 3F 88 44 24 47 F2 0F 10 54 24 38 F2 0F 5E 54 24 40 F2 0F 5A C2 F3 0F 11 44 24 60 0F B7 44 24 62 A9 80 7F 00 00 F2 0F 11 54 24 68 74 43 F2 0F 10 05 ?? ?? ?? ?? 41 C0 E3 07 F2 0F 58 C2 F2 0F 11 44 24 20 F2 0F 10 4C 24 20 F2 0F 59 D1 F2 0F 11 54 24 68 8A 44 24 6F 24 7F 41 0A C3 88 44 24 6F F2 0F 5A 54 24 68 F3 41 0F 11 10 E9 FB 00 00 00 F2 0F 5A 44 24 68 41 C0 E3 07 F3 0F 11 44 24 60 F3 0F 10 54 24 60 F3 0F 10 4C 24 60 F3 0F 59 D1 F3 0F 11 54 24 60 F3 0F 10 5C 24 60 F3 0F 5A DB F2 0F 58 5C 24 68 F2 0F 11 5C 24 68 8A 44 24 6F 24 7F 41 0A C3 88 44 24 6F F2 0F 5A 64 24 68 F3 }
	condition:
		$1
}

rule file_337_0_0 {
	meta:
		name = "__GSHandlerCheck_EH"
		size = 167
		refs = "003a __GSHandlerCheckCommon 008c __CxxFrameHandler3"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 48 8B 44 24 68 48 8B 40 38 48 83 C0 04 48 89 44 24 30 4C 8B 44 24 30 48 8B 54 24 68 48 8B 4C 24 58 E8 ?? ?? ?? ?? 48 8B 44 24 30 8B 00 89 44 24 20 48 8B 44 24 50 8B 40 04 83 E0 66 85 C0 75 0D 8B 44 24 20 83 E0 01 89 44 24 24 EB 0B 8B 44 24 20 83 E0 02 89 44 24 24 83 7C 24 24 00 74 1F 4C 8B 4C 24 68 4C 8B 44 24 60 48 8B 54 24 58 48 8B 4C 24 50 E8 ?? ?? ?? ?? 89 44 24 28 EB 08 C7 44 24 28 01 00 00 00 8B 44 24 28 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_343_0_0 {
	meta:
		name = "__avx_atan24"
		size = 768
		refs = "0063 __common_datan2_data 02f4 __common_datan2_cout_rare"
	strings:
		$1 = { 48 81 EC 58 02 00 00 C5 7C 11 AC 24 70 01 00 00 C5 7C 11 A4 24 D0 01 00 00 C5 7C 11 9C 24 B0 01 00 00 C5 7C 11 94 24 10 02 00 00 C5 7C 11 8C 24 F0 01 00 00 C5 7C 11 84 24 90 01 00 00 C5 FC 11 BC 24 50 01 00 00 C5 FC 11 B4 24 30 02 00 00 4C 89 AC 24 50 02 00 00 4C 8D AC 24 AF 00 00 00 C5 FD 10 25 ?? ?? ?? ?? 49 83 E5 C0 C5 7D 10 15 ?? ?? ?? ?? C5 F5 54 D4 C5 FD 54 EC C5 D5 C2 DA 15 C4 41 6D 56 EA C4 C3 55 4B E5 30 C4 63 6D 4B C5 30 C4 41 5D 5E E8 C5 F8 10 25 ?? ?? ?? ?? C5 65 54 25 ?? ?? ?? ?? C4 41 75 54 DA C4 41 7D 54 CA C5 78 10 15 ?? ?? ?? ?? C4 E3 7D 19 D6 01 C4 E3 7D 19 EF 01 C5 E8 C6 DE DD C5 D0 C6 EF DD C5 61 FA C4 C5 D1 FA FC C4 C1 39 66 D2 C5 F5 C2 25 ?? ?? ?? ?? 12 C4 C1 39 76 F2 C4 C1 41 66 EA C4 41 41 76 D2 C5 E9 EB DE C4 41 51 EB D2 C4 C1 61 EB EA C5 5D 54 15 ?? ?? ?? ?? C4 C1 15 59 E5 C5 F8 50 D5 C5 DD 59 EC C5 D5 59 DD C5 65 59 05 ?? ?? ?? ?? C5 E5 59 3D ?? ?? ?? ?? C5 E5 59 15 ?? ?? ?? ?? C5 BD 58 35 ?? ?? ?? ?? C5 45 58 05 ?? ?? ?? ?? C5 ED 58 15 ?? ?? ?? ?? C5 CD 59 F3 C5 E5 59 3D ?? ?? ?? ?? C5 ED 59 D3 C5 3D 59 C3 C5 CD 58 35 ?? ?? ?? ?? C5 C5 58 3D ?? ?? ?? ?? C5 ED 58 15 ?? ?? ?? ?? C5 3D 58 05 ?? ?? ?? ?? C5 CD 59 F3 C5 C5 59 FB C5 ED 59 D3 C5 3D 59 C3 C5 CD 58 35 ?? ?? ?? ?? C5 C5 58 3D ?? ?? ?? ?? C5 ED 58 15 ?? ?? ?? ?? C5 3D 58 05 ?? ?? ?? ?? C5 CD 59 F3 C5 C5 59 FB C5 ED 59 D3 C5 3D 59 C3 C5 CD 58 35 ?? ?? ?? ?? C5 C5 58 3D ?? ?? ?? ?? C5 ED 58 15 ?? ?? ?? ?? C5 3D 58 05 ?? ?? ?? ?? C5 CD 59 F4 C5 C5 59 DB C5 BD 59 E4 C5 CD 58 FA C5 E5 58 1D ?? ?? ?? ?? C5 C5 59 ED C5 DD 58 D3 C5 D5 58 DA C4 41 65 59 ED C4 41 15 58 E4 C4 41 1D 56 DB C4 C1 25 58 D2 C4 C1 6D 56 D1 85 D2 75 5C C5 FC 10 B4 24 30 02 00 00 C5 FC 10 BC 24 50 01 00 00 C5 7C 10 84 24 90 01 00 00 C5 7C 10 8C 24 F0 01 00 00 C5 7C 10 94 24 10 02 00 00 C5 7C 10 9C 24 B0 01 00 00 C5 7C 10 A4 24 D0 01 00 00 C5 7C 10 AC 24 70 01 00 00 4C 8B AC 24 50 02 00 00 C5 FD 28 C2 48 81 C4 58 02 00 00 C3 C4 C1 7D 11 45 00 C4 C1 7D 11 4D 40 C4 C1 7D 11 95 80 00 00 00 74 8D 33 C0 C5 7C 11 74 24 40 C5 7C 11 7C 24 20 48 89 5C 24 68 8B D8 48 89 74 24 60 8B F2 0F A3 DE 72 2B FF C3 83 FB 20 7C F4 C5 7C 10 74 24 40 C5 7C 10 7C 24 20 C4 C1 7D 10 95 80 00 00 00 48 8B 5C 24 68 48 8B 74 24 60 E9 41 FF FF FF C5 F8 77 49 8D 4C DD 00 49 8D 54 DD 40 4D 8D 84 DD 80 00 00 00 E8 ?? ?? ?? ?? EB B9 66 0F 1F 44 00 00 }
	condition:
		$1
}

rule file_348_0_0 {
	meta:
		name = "__common_dcosh_cout_rare"
		size = 1056
		refs = "0030 _vmldCoshHATab"
	strings:
		$1 = { 48 81 EC 88 00 00 00 33 C0 44 0F B7 41 06 41 81 E0 F0 7F 00 00 44 0F 29 74 24 70 41 81 F8 F0 7F 00 00 44 0F 29 5C 24 50 0F 29 7C 24 60 4C 8B 0D ?? ?? ?? ?? 0F 84 CE 03 00 00 48 8B 09 48 89 4C 24 40 48 C1 E9 38 83 E1 7F 88 4C 24 47 44 0F B7 44 24 46 41 81 E0 F0 7F 00 00 41 81 F8 90 3C 00 00 0F 8E 76 03 00 00 F2 44 0F 10 74 24 40 F2 0F 10 05 ?? ?? ?? ?? 66 41 0F 2F C6 0F 86 45 03 00 00 F2 0F 10 15 ?? ?? ?? ?? 4C 89 4C 24 40 F2 41 0F 59 D6 66 44 0F 2F 35 ?? ?? ?? ?? 0F 82 4A 01 00 00 F2 0F 10 05 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? F2 0F 10 25 ?? ?? ?? ?? F2 0F 58 D0 F2 0F 11 54 24 20 F2 0F 10 4C 24 20 44 8B 44 24 20 41 8B C8 83 E1 3F F2 0F 5C 0D ?? ?? ?? ?? F2 0F 11 4C 24 28 44 8D 14 09 F2 0F 10 54 24 28 8D 4C 09 01 F2 0F 59 15 ?? ?? ?? ?? F2 0F 10 5C 24 28 F2 44 0F 5C F2 F2 0F 59 1D ?? ?? ?? ?? F2 44 0F 5C F3 F2 41 0F 59 E6 F2 43 0F 10 0C D3 F2 0F 58 25 ?? ?? ?? ?? F2 41 0F 59 E6 41 C1 E8 06 F2 0F 58 25 ?? ?? ?? ?? F2 41 0F 59 E6 41 81 C0 FF 03 00 00 41 FF C8 F2 0F 58 25 ?? ?? ?? ?? F2 41 0F 59 E6 41 81 E0 FF 07 00 00 41 81 F8 FE 07 00 00 F2 0F 58 25 ?? ?? ?? ?? F2 41 0F 59 E6 F2 41 0F 59 E6 F2 41 0F 58 E6 F2 0F 59 E1 F2 41 0F 58 24 CB F2 0F 58 CC 77 2B 49 C1 E9 30 41 C1 E0 04 41 81 E1 0F 80 FF FF 45 0B C8 66 44 89 4C 24 46 F2 0F 10 44 24 40 F2 0F 59 C1 F2 0F 11 02 E9 3F 02 00 00 41 FF C8 41 81 E0 FF 07 00 00 0F B7 4C 24 46 41 C1 E0 04 81 E1 0F 80 FF FF 41 0B C8 66 89 4C 24 46 F2 0F 10 44 24 40 F2 0F 59 C8 F2 0F 59 0D ?? ?? ?? ?? F2 0F 11 0A E9 03 02 00 00 F2 0F 10 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 44 0F B7 4C 24 46 F2 0F 58 D1 F2 0F 11 54 24 20 41 81 E1 0F 80 FF FF F2 0F 10 7C 24 20 44 8B 5C 24 20 45 8B D3 41 C1 EA 06 41 83 E3 3F 41 81 C2 FF 03 00 00 F2 0F 5C 3D ?? ?? ?? ?? F2 0F 11 7C 24 28 41 8D 4A FF F2 44 0F 10 5C 24 28 81 E1 FF 07 00 00 F2 44 0F 59 1D ?? ?? ?? ?? 41 F7 DA F2 0F 10 64 24 28 41 83 C2 FC F2 0F 59 25 ?? ?? ?? ?? F2 45 0F 5C F3 F2 44 0F 10 1D ?? ?? ?? ?? 41 81 E2 FF 07 00 00 C1 E1 04 F2 44 0F 5C F4 41 0F 28 EE 44 0B C9 F2 41 0F 59 EE 43 8D 0C 1B F2 44 0F 59 DD F2 44 0F 58 1D ?? ?? ?? ?? F2 41 0F 10 24 C8 F7 D9 F2 0F 10 3D ?? ?? ?? ?? 47 8D 44 1B 01 66 44 89 4C 24 46 41 81 E1 0F 80 FF FF 41 C1 E2 04 4C 8D 1D ?? ?? ?? ?? F2 0F 59 FD 45 0B CA F2 44 0F 59 DD F2 0F 58 3D ?? ?? ?? ?? F2 44 0F 58 1D ?? ?? ?? ?? F2 0F 59 FD F2 44 0F 59 DD F2 41 0F 59 FE F2 0F 10 4C 24 40 4D 8B D3 66 44 89 4C 24 46 44 8D 89 80 00 00 00 81 C1 81 00 00 00 F2 0F 10 44 24 40 F2 43 0F 10 2C C3 4D 8B C3 F2 0F 59 E1 F2 0F 59 E9 F2 43 0F 10 14 CA 0F 28 CC F2 0F 59 D0 F2 41 0F 10 1C C8 F2 0F 58 CA F2 0F 59 D8 F2 0F 11 4C 24 30 0F 28 CC F2 0F 10 44 24 30 F2 0F 5C E2 F2 0F 5C C8 F2 0F 59 FC F2 0F 58 CA 0F 28 D5 F2 0F 11 4C 24 38 F2 0F 5C D3 F2 41 0F 59 D6 F2 44 0F 59 F4 F2 0F 58 D3 F2 0F 10 4C 24 30 F2 0F 58 D5 F2 44 0F 59 D9 F2 0F 10 44 24 38 F2 0F 58 D0 F2 0F 58 D7 F2 41 0F 58 D3 F2 41 0F 58 D6 F2 0F 11 54 24 30 F2 44 0F 10 74 24 30 F2 41 0F 58 CE F2 0F 11 0A EB 29 F2 0F 10 05 ?? ?? ?? ?? B8 03 00 00 00 F2 0F 59 C0 F2 0F 11 02 EB 12 F2 0F 10 05 ?? ?? ?? ?? F2 0F 58 44 24 40 F2 0F 11 02 0F 28 7C 24 60 44 0F 28 5C 24 50 44 0F 28 74 24 70 48 81 C4 88 00 00 00 C3 F2 0F 10 01 F2 0F 59 C0 F2 0F 11 02 EB D9 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_356_0_0 {
	meta:
		name = "__static_scalar_tan"
		size = 1408
		refs = "000c __spec_table"
	strings:
		$1 = { 53 56 57 41 54 48 83 EC 58 48 8D 05 ?? ?? ?? ?? F2 0F 11 84 24 80 00 00 00 48 89 44 24 40 0F 29 74 24 30 0F 29 7C 24 20 F2 0F 10 84 24 80 00 00 00 4C 8B 64 24 40 66 0F C5 C0 03 25 F0 7F 00 00 3D F0 7F 00 00 0F 84 0E 05 00 00 8B C8 81 E9 60 3F 00 00 C1 E9 07 81 E1 FC FF 00 00 4D 8D 9C 24 40 01 00 00 49 03 CB 66 48 0F 7E C0 44 8B 51 14 44 8B 41 18 8B D0 48 C1 E8 15 0D 00 00 00 80 C1 E8 0B 45 8B CA 4C 0F AF D2 4C 0F AF C8 4C 0F AF C0 8B 71 10 8B 79 0C 45 8B DA 49 C1 EA 20 4D 03 CA 4D 03 D8 45 8B C3 49 C1 EB 20 4D 03 CB 44 8B D6 48 0F AF F2 4C 0F AF D0 44 8B DF 48 0F AF FA 8B DE 48 C1 EE 20 4C 03 CB 41 8B D9 49 C1 E9 20 4C 03 D6 4D 03 D1 48 C1 E3 20 4C 0B C3 4C 0F AF D8 44 8B 49 08 8B 71 04 8B DF 48 C1 EF 20 4C 03 D3 41 8B DA 49 C1 EA 20 4C 03 DF 4D 03 DA 49 8B F9 4C 0F AF CA 48 0F AF F8 45 8B D1 49 C1 E9 20 4D 03 DA 45 8B D3 49 C1 EB 20 49 03 F9 49 03 FB 4C 8B CE 48 0F AF F2 4C 0F AF C8 49 C1 E2 20 4C 0B D3 8B 01 44 8B DE 48 C1 EE 20 49 03 FB 44 8B DF 48 C1 EF 20 4C 03 CE 4C 03 CF 48 0F AF D0 66 0F C5 D8 03 49 8D BC 24 40 01 00 00 48 2B CF 03 C9 03 C9 03 C9 83 C1 13 BE 00 80 00 00 23 F3 C1 EB 04 81 E3 FF 07 00 00 81 EB FF 03 00 00 2B CB 4C 03 CA 8B D1 83 C2 20 83 F9 00 0F 8C 16 03 00 00 F7 D9 83 C1 1D 41 D3 E1 41 8B F9 41 81 E1 FF FF FF 3F 41 F7 C1 00 00 00 20 0F 85 20 03 00 00 41 D3 E9 BB 00 00 00 00 49 C1 E1 20 4D 0B CB 49 83 F9 00 0F 84 89 02 00 00 4D 0F BD D9 B9 1D 00 00 00 41 2B CB 0F 8E A9 02 00 00 49 D3 E1 49 8B C2 49 D3 E2 03 D1 F7 D9 83 C1 40 48 D3 E8 49 D3 E8 4C 0B C8 4D 0B D0 F2 49 0F 2A C1 49 D1 EA F2 49 0F 2A DA 66 0F 57 E4 C1 E2 04 F7 DA 81 C2 F0 3F 00 00 0B D6 33 D3 66 0F C4 E2 03 F3 41 0F 7E 54 24 60 F3 41 0F 7E 7C 24 68 66 0F 57 ED 81 EA F0 03 00 00 66 0F C4 EA 03 F2 0F 59 C4 C1 E6 10 C1 FE 1F F2 0F 59 DD F3 0F 7E C8 F2 0F 59 C2 C1 EF 1E F2 0F 58 CB F2 0F 59 DA 03 FE 33 FE F2 0F 59 F9 8B C7 F2 0F 58 FB F3 0F 7E D0 F2 0F 58 C7 F2 0F 5C D0 F2 0F 58 FA 66 41 0F 28 0C 24 F2 0F 12 C0 66 0F 59 C8 F2 0F 12 FF F2 0F 2D D1 66 41 0F 28 54 24 10 66 0F 58 CA 66 41 0F 28 5C 24 20 66 0F 5C CA F3 41 0F 7E AC 24 80 00 00 00 C1 E0 04 81 C2 00 29 07 00 66 41 0F 28 64 24 30 66 0F 59 D9 03 D0 83 E2 1F F2 0F 59 E9 8B CA 66 0F 59 E1 D1 E1 66 0F 5C C3 66 41 0F 59 4C 24 40 03 D1 C1 E1 02 03 D1 F2 0F 58 E8 66 0F 28 D0 66 0F 5C C4 F3 41 0F 7E B4 24 90 00 00 00 C1 E2 04 49 8D 84 24 F0 01 00 00 66 41 0F 54 6C 24 50 66 0F 28 D8 48 03 C2 66 0F 5C D0 66 0F 15 C0 F2 0F 5E F5 66 0F 5C D4 F2 0F 5C DD 66 0F 5C D1 66 0F 28 48 30 66 0F 58 D7 66 0F 28 78 10 66 0F 59 F8 66 0F 28 60 60 66 0F 59 C8 66 0F 59 E0 F2 0F 58 D3 66 0F 28 D8 66 0F 59 C0 66 0F 58 38 66 0F 58 48 20 66 0F 59 C8 66 0F 58 60 50 66 0F 58 F9 66 0F 28 48 70 66 0F 59 C8 66 0F 59 C0 66 0F 58 E1 66 0F 28 48 40 66 0F 59 C8 66 0F 58 F9 66 0F 28 CB 66 0F 59 D8 F2 0F 59 C0 66 0F 59 88 90 00 00 00 66 0F 59 E3 F3 0F 7E D9 66 0F 58 FC F3 0F 7E E1 F2 0F 59 C7 66 0F 15 FF F2 0F 58 C7 66 0F 15 C9 F2 0F 58 D9 F2 0F 5C E3 F2 0F 58 CC F3 0F 7E E2 F3 0F 7E B8 90 00 00 00 66 0F 15 D2 F2 0F 58 B8 98 00 00 00 F2 0F 59 FA F2 0F 58 B8 88 00 00 00 F2 0F 58 F9 F2 0F 58 C7 F3 41 0F 7E BC 24 90 00 00 00 F2 0F 59 E6 F3 0F 7E 90 A8 00 00 00 66 0F 54 D6 F2 0F 59 EA F2 0F 59 B0 A0 00 00 00 F2 0F 5C FD F2 0F 5C 90 80 00 00 00 F2 0F 5C FC F2 0F 59 FE F3 0F 7E E3 F2 0F 5C DA F2 0F 58 D3 F2 0F 5C E2 F2 0F 58 C4 F2 0F 5C C7 F2 0F 58 C3 E9 0B 01 00 00 83 C2 40 4D 8B CA 4D 8B D0 49 C7 C0 00 00 00 00 49 83 F9 00 0F 85 5D FD FF FF 83 C2 40 4D 8B CA 4D 8B D0 49 83 F9 00 0F 85 4A FD FF FF E9 73 FD FF FF 0F 84 6D FD FF FF F7 D9 49 D3 EA 49 8B C1 49 D3 E9 2B D1 F7 D9 83 C1 40 48 D3 E0 4C 0B D0 E9 50 FD FF FF F7 D1 49 C1 E1 20 4D 0B CB 49 D3 E1 49 8B F9 41 F7 C1 00 00 00 80 75 56 41 D3 E9 BB 00 00 00 00 48 C1 EF 02 E9 EF FC FF FF 41 D3 E9 BB 00 00 00 40 D3 EB 49 C1 E1 20 4D 0B CB 48 C1 E3 20 81 C7 00 00 00 40 48 C7 C1 00 00 00 00 49 C7 C3 00 00 00 00 49 2B C8 4D 1B DA 49 1B D9 4C 8B C1 4D 8B D3 4C 8B CB BB 00 80 00 00 E9 AA FC FF FF 41 D3 E9 48 BB 00 00 00 00 01 00 00 00 48 D3 EB 48 C7 C1 00 00 00 00 49 C7 C3 00 00 00 00 49 2B C8 4D 1B DA 49 1B D9 4C 8B C1 4D 8B D3 4C 8B CB BB 00 80 00 00 48 C1 EF 02 81 C7 00 00 00 40 E9 66 FC FF FF F2 0F 5C C0 F2 0F 11 44 24 48 0F 28 74 24 30 0F 28 7C 24 20 F2 0F 10 44 24 48 48 83 C4 58 41 5C 5F 5E 5B C3 0F 1F 00 }
	condition:
		$1
}

rule file_356_1_0 {
	meta:
		name = "__sse2_tan2"
		size = 1712
		refs = "001b MMDRSHIFT 002b MMDPI1 0033 MMDPI2 003b MMIABSMASK 0043 MMDINVPI2 0057 MMDPI3 006b MMDHUGE 007f MMDPI4 00ba MMDP3 00c2 MMDQ3 00ca MMDP0 00d2 MMDQ0 00de MMDP2 00ea MMDQ2 00f6 MMDP1 0102 MMDQ1 016e MMISIGNMASK 0193 TWO_POW_30 01a5 flAllOnes 020f THE_PI04_INV 0224 MMI_ONE 022c MSK_LOW_BIT 0234 RS 0248 PI04C_0 0254 PI04C_1 0264 PI04C_2 0295 PI04C_3 02c1 PI04C_4"
	strings:
		$1 = { 48 81 EC D8 00 00 00 0F 29 BC 24 C0 00 00 00 0F 29 B4 24 B0 00 00 00 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 F8 66 0F 28 D0 66 0F 28 25 ?? ?? ?? ?? 66 0F 28 2D ?? ?? ?? ?? 66 0F 54 3D ?? ?? ?? ?? 66 0F 59 05 ?? ?? ?? ?? 66 0F 58 C6 66 0F 28 D8 66 0F 5C C6 66 0F 28 35 ?? ?? ?? ?? 66 0F 59 E0 66 0F 59 E8 66 0F 59 F0 66 0F 66 3D ?? ?? ?? ?? 66 0F 50 C7 0B C0 0F 85 E7 00 00 00 66 0F 28 3D ?? ?? ?? ?? 66 0F 59 F8 66 0F 28 C3 66 0F 73 F3 3E 66 0F 5C D4 66 0F 5C D5 66 0F 5C D6 66 0F 57 C9 66 0F C2 D9 04 66 0F 73 F0 3F 66 0F 28 CA 66 0F 59 D2 66 0F 5C CF 66 0F 28 25 ?? ?? ?? ?? 66 0F 28 2D ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 3D ?? ?? ?? ?? 66 0F 59 E2 66 0F 58 25 ?? ?? ?? ?? 66 0F 59 EA 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 E2 66 0F 58 25 ?? ?? ?? ?? 66 0F 59 EA 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 E2 66 0F 58 E6 66 0F 59 EA 66 0F 58 EF 66 0F 59 E1 66 0F 28 CB 66 0F 54 CC 66 0F 28 D3 66 0F 55 D5 66 0F 56 CA 66 0F 28 F3 66 0F 55 F4 66 0F 28 FB 66 0F 54 FD 66 0F 56 F7 66 0F 5E F1 66 0F 57 C6 0F 28 B4 24 B0 00 00 00 0F 28 BC 24 C0 00 00 00 48 81 C4 D8 00 00 00 C3 C7 44 24 20 00 00 00 00 66 0F 28 0D ?? ?? ?? ?? 66 0F DB CA 66 0F 29 54 24 30 66 0F 70 FF F5 66 0F DB 15 ?? ?? ?? ?? 66 0F 29 4C 24 40 66 0F 28 0D ?? ?? ?? ?? 66 0F 66 CA 66 0F 29 7C 24 50 66 0F 57 3D ?? ?? ?? ?? 66 0F 50 D1 66 0F 29 54 24 60 66 0F 29 7C 24 70 66 0F 28 3D ?? ?? ?? ?? 83 F2 03 0F 85 6C 03 00 00 83 F8 03 74 3C 66 0F 59 F8 66 0F 5C D4 66 0F 5C D5 66 0F 5C D6 66 0F 57 C9 66 0F 5C D7 66 0F 54 5C 24 70 66 0F 54 54 24 70 66 0F 29 9C 24 80 00 00 00 66 0F 29 94 24 90 00 00 00 66 0F 28 54 24 60 66 0F 28 1D ?? ?? ?? ?? 66 0F 59 DA 66 0F E6 DB 66 0F 70 DB 10 66 0F FE 1D ?? ?? ?? ?? 66 0F DB 1D ?? ?? ?? ?? 66 0F 28 05 ?? ?? ?? ?? 66 0F 56 C3 66 0F 5C 05 ?? ?? ?? ?? 66 0F 28 0D ?? ?? ?? ?? 66 0F 59 C8 66 0F 28 25 ?? ?? ?? ?? 66 0F 59 E0 66 0F 5C D1 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 E8 66 0F 28 CA 66 0F 5C D4 66 0F 5C CA 66 0F 28 F2 66 0F 5C CC 66 0F 5C D5 66 0F 72 E3 01 66 0F 5C F2 66 0F 28 FA 66 0F 28 25 ?? ?? ?? ?? 66 0F 5C F5 66 0F 58 CE 66 0F 58 D1 66 0F 59 E0 66 0F 5C FA 66 0F 28 EA 66 0F 5C D4 66 0F 58 CF 66 0F 5C EA 66 0F 59 05 ?? ?? ?? ?? 66 0F 5C EC 66 0F 58 CD 66 0F 5C C8 66 0F 58 D1 66 0F 28 25 ?? ?? ?? ?? 66 0F 28 2D ?? ?? ?? ?? 66 0F 28 F2 66 0F 59 D2 83 F8 03 74 1E 66 0F 54 5C 24 50 66 0F 54 4C 24 50 66 0F 56 9C 24 80 00 00 00 66 0F 56 8C 24 90 00 00 00 66 0F 28 C3 66 0F 73 F3 3E 66 0F 73 F0 3F 66 0F 59 E2 66 0F 59 EA 66 0F 58 25 ?? ?? ?? ?? 66 0F 58 2D ?? ?? ?? ?? 66 0F EF 44 24 40 66 0F 59 E2 66 0F 59 EA 66 0F EF C9 66 0F 58 25 ?? ?? ?? ?? 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 E2 66 0F 59 EA 66 0F C2 D9 04 66 0F 58 25 ?? ?? ?? ?? 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 E6 66 0F 28 CB 66 0F 54 CC 66 0F 28 D3 66 0F 55 D5 66 0F 56 CA 66 0F 28 F3 66 0F 55 F4 66 0F 28 FB 66 0F 54 FD 66 0F 56 F7 66 0F 5E F1 66 0F 57 C6 E9 A6 02 00 00 66 0F 28 1D ?? ?? ?? ?? 66 0F 59 DA 66 0F E6 DB 66 0F 70 DB 10 66 0F FE 1D ?? ?? ?? ?? 66 0F DB 1D ?? ?? ?? ?? 66 0F 28 05 ?? ?? ?? ?? 66 0F 56 C3 66 0F 5C 05 ?? ?? ?? ?? 66 0F 28 0D ?? ?? ?? ?? 66 0F 59 C8 66 0F 28 25 ?? ?? ?? ?? 66 0F 59 E0 66 0F 5C D1 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 E8 66 0F 28 CA 66 0F 5C D4 66 0F 5C CA 66 0F 28 F2 66 0F 5C CC 66 0F 5C D5 66 0F 72 E3 01 66 0F 5C F2 66 0F 28 FA 66 0F 28 25 ?? ?? ?? ?? 66 0F 5C F5 66 0F 58 CE 66 0F 58 D1 66 0F 59 E0 66 0F 5C FA 66 0F 28 EA 66 0F 5C D4 66 0F 58 CF 66 0F 5C EA 66 0F 59 05 ?? ?? ?? ?? 66 0F 5C EC 66 0F 58 CD 66 0F 5C C8 66 0F 58 D1 66 0F 28 C3 66 0F 73 F0 3F 66 0F EF 44 24 40 66 0F 73 F3 3E 66 0F EF C9 66 0F C2 D9 04 66 0F 28 CA 66 0F 59 D2 66 0F 28 25 ?? ?? ?? ?? 66 0F 28 2D ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 3D ?? ?? ?? ?? 66 0F 59 E2 66 0F 58 25 ?? ?? ?? ?? 66 0F 59 EA 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 E2 66 0F 58 25 ?? ?? ?? ?? 66 0F 59 EA 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 E2 66 0F 58 E6 66 0F 59 EA 66 0F 58 EF 66 0F 59 E1 66 0F 28 CB 66 0F 54 CC 66 0F 28 D3 66 0F 55 D5 66 0F 56 CA 66 0F 28 F3 66 0F 55 F4 66 0F 28 FB 66 0F 54 FD 66 0F 56 F7 66 0F 5E F1 66 0F 57 C6 E9 1E 01 00 00 89 44 24 20 83 F8 03 0F 84 F4 00 00 00 66 0F 28 54 24 30 66 0F 59 F8 66 0F 5C D4 66 0F EF E4 66 0F 5C D5 66 0F 5C D6 66 0F 57 C9 66 0F 28 CA 66 0F 59 D2 66 0F 5C CF 66 0F 29 8C 24 A0 00 00 00 66 0F 28 C3 66 0F 73 F0 3F 66 0F EF C4 66 0F 73 F3 3E 66 0F EF C9 66 0F C2 D9 04 66 0F 28 8C 24 A0 00 00 00 66 0F 28 25 ?? ?? ?? ?? 66 0F 28 2D ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 3D ?? ?? ?? ?? 66 0F 59 E2 66 0F 58 25 ?? ?? ?? ?? 66 0F 59 EA 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 E2 66 0F 58 25 ?? ?? ?? ?? 66 0F 59 EA 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 E2 66 0F 58 E6 66 0F 59 EA 66 0F 58 EF 66 0F 59 E1 66 0F 28 CB 66 0F 54 CC 66 0F 28 D3 66 0F 55 D5 66 0F 56 CA 66 0F 28 F3 66 0F 55 F4 66 0F 28 FB 66 0F 54 FD 66 0F 56 F7 66 0F 5E F1 66 0F 57 C6 66 0F 29 84 24 A0 00 00 00 8B 44 24 20 A8 01 75 4B D1 F8 A8 01 75 27 D1 F8 89 44 24 20 66 0F 28 84 24 A0 00 00 00 0F 28 B4 24 B0 00 00 00 0F 28 BC 24 C0 00 00 00 48 81 C4 D8 00 00 00 C3 F2 0F 10 44 24 38 89 44 24 20 E8 05 F4 FF FF F2 0F 11 84 24 A8 00 00 00 8B 44 24 20 EB BB F2 0F 10 44 24 30 E8 EB F3 FF FF F2 0F 11 84 24 A0 00 00 00 8B 44 24 20 EB 9B 66 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_357_0_0 {
	meta:
		name = "__common_slog10_cout_rare"
		size = 720
		refs = "003b _2il0floatpacket_77 005f _2il0floatpacket_93 0077 _2il0floatpacket_78 00b7 _vmldLgHATab 00d3 _2il0floatpacket_79 00db _2il0floatpacket_80 00e3 _2il0floatpacket_82 00ef _2il0floatpacket_81 0145 _2il0floatpacket_83 0158 _2il0floatpacket_84 0164 _2il0floatpacket_85 0170 _2il0floatpacket_86 017c _2il0floatpacket_87 0188 _2il0floatpacket_88 0194 _2il0floatpacket_89 01a0 _2il0floatpacket_90 01af _2il0floatpacket_91 026a _2il0floatpacket_92"
	strings:
		$1 = { 48 83 EC 38 33 C0 44 0F B7 41 02 41 81 E0 80 7F 00 00 41 81 F8 80 7F 00 00 0F 84 61 02 00 00 F3 0F 10 01 45 33 C0 8B 09 89 4C 24 28 C1 E9 10 F7 C1 80 7F 00 00 75 14 F3 0F 59 05 ?? ?? ?? ?? 41 B8 D8 FF FF FF F3 0F 11 44 24 28 66 0F EF C9 0F 2F C1 0F 86 F5 01 00 00 0F 28 D0 F3 0F 5C 15 ?? ?? ?? ?? F3 0F 11 54 24 24 80 64 24 27 7F F3 0F 10 4C 24 24 0F 2F 0D ?? ?? ?? ?? 0F 86 53 01 00 00 0F B7 4C 24 2A 81 E1 80 7F 00 00 C1 E9 07 F3 0F 11 44 24 24 44 0F B7 4C 24 26 41 81 E1 7F 80 FF FF 41 81 C9 80 3F FF FF 45 8D 44 08 81 66 44 89 4C 24 26 48 8D 0D ?? ?? ?? ?? F3 41 0F 2A D8 F3 0F 10 64 24 24 4C 8B C9 0F 28 C4 4C 8B C1 F3 0F 10 15 ?? ?? ?? ?? F3 0F 10 0D ?? ?? ?? ?? F3 0F 10 2D ?? ?? ?? ?? F3 0F 59 D3 F3 0F 58 05 ?? ?? ?? ?? F3 0F 59 D9 0F 28 CC F3 0F 11 44 24 20 F3 0F 58 CD 44 8B 54 24 20 41 83 E2 7F F3 0F 11 4C 24 20 F3 0F 10 4C 24 20 F3 0F 5C CD 47 8D 1C 52 F3 0F 5C E1 F3 43 0F 58 5C 99 08 F3 43 0F 58 54 98 04 F3 42 0F 10 04 99 F3 0F 59 C8 F3 0F 59 C4 F3 0F 5C 0D ?? ?? ?? ?? 0F 28 E9 F3 0F 58 D1 F3 0F 58 E8 F3 0F 10 25 ?? ?? ?? ?? F3 0F 59 E5 F3 0F 58 25 ?? ?? ?? ?? F3 0F 59 E5 F3 0F 58 25 ?? ?? ?? ?? F3 0F 59 E5 F3 0F 58 25 ?? ?? ?? ?? F3 0F 59 E5 F3 0F 58 25 ?? ?? ?? ?? F3 0F 59 E5 F3 0F 58 25 ?? ?? ?? ?? F3 0F 59 E5 F3 0F 58 25 ?? ?? ?? ?? F3 0F 59 E5 0F 28 E8 F3 0F 58 25 ?? ?? ?? ?? F3 0F 59 EC F3 0F 59 CC F3 0F 58 DD F3 0F 58 C3 F3 0F 58 C1 F3 0F 58 D0 F3 0F 11 12 48 83 C4 38 C3 F3 0F 10 05 ?? ?? ?? ?? F3 0F 59 D0 F3 0F 10 0D ?? ?? ?? ?? F3 0F 59 CA F3 0F 58 0D ?? ?? ?? ?? F3 0F 59 CA F3 0F 58 0D ?? ?? ?? ?? F3 0F 59 CA F3 0F 58 0D ?? ?? ?? ?? F3 0F 59 CA F3 0F 58 0D ?? ?? ?? ?? F3 0F 59 CA F3 0F 58 0D ?? ?? ?? ?? F3 0F 59 CA F3 0F 58 0D ?? ?? ?? ?? F3 0F 59 CA F3 0F 58 0D ?? ?? ?? ?? F3 0F 59 CA F3 0F 58 D1 F3 0F 11 12 48 83 C4 38 C3 0F 2E C1 7A 02 74 12 F3 0F 5E C9 F3 0F 11 0A B8 01 00 00 00 48 83 C4 38 C3 F3 0F 10 05 ?? ?? ?? ?? B8 02 00 00 00 F3 0F 5E C1 F3 0F 11 02 48 83 C4 38 C3 44 8A 41 03 41 80 E0 80 41 80 F8 80 74 11 F3 0F 10 01 F3 0F 59 C0 F3 0F 11 02 48 83 C4 38 C3 F7 01 FF FF 7F 00 75 E7 B8 01 00 00 00 66 0F EF C9 66 0F EF C0 F3 0F 5E C8 F3 0F 11 0A 48 83 C4 38 C3 66 66 66 66 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_359_0_0 {
	meta:
		name = "__chkstk"
		size = 81
	strings:
		$1 = { 48 83 EC 10 4C 89 14 24 4C 89 5C 24 08 4D 33 DB 4C 8D 54 24 18 4C 2B D0 4D 0F 42 D3 65 4C 8B 1C 25 10 00 00 00 4D 3B D3 F2 73 17 66 41 81 E2 00 F0 4D 8D 9B 00 F0 FF FF 41 C6 03 00 4D 3B D3 F2 75 EF 4C 8B 14 24 4C 8B 5C 24 08 48 83 C4 10 F2 C3 }
	condition:
		$1
}

rule file_362_0_0 {
	meta:
		name = "__static_scalar_cos"
		size = 1280
		refs = "000c __spec_table"
	strings:
		$1 = { 53 56 57 41 54 48 83 EC 58 48 8D 05 ?? ?? ?? ?? F2 0F 11 84 24 80 00 00 00 48 89 44 24 40 0F 29 74 24 30 0F 29 7C 24 20 F2 0F 10 84 24 80 00 00 00 4C 8B 64 24 40 66 0F C5 C0 03 25 F0 7F 00 00 3D F0 7F 00 00 0F 84 82 04 00 00 8B C8 81 E9 60 3F 00 00 C1 E9 07 81 E1 FC FF 00 00 4D 8D 9C 24 D0 00 00 00 49 03 CB 66 48 0F 7E C0 44 8B 51 14 44 8B 41 18 8B D0 48 C1 E8 15 0D 00 00 00 80 C1 E8 0B 45 8B CA 4C 0F AF D2 4C 0F AF C8 4C 0F AF C0 8B 71 10 8B 79 0C 45 8B DA 49 C1 EA 20 4D 03 CA 4D 03 D8 45 8B C3 49 C1 EB 20 4D 03 CB 44 8B D6 48 0F AF F2 4C 0F AF D0 44 8B DF 48 0F AF FA 8B DE 48 C1 EE 20 4C 03 CB 41 8B D9 49 C1 E9 20 4C 03 D6 4D 03 D1 48 C1 E3 20 4C 0B C3 4C 0F AF D8 44 8B 49 08 8B 71 04 8B DF 48 C1 EF 20 4C 03 D3 41 8B DA 49 C1 EA 20 4C 03 DF 4D 03 DA 49 8B F9 4C 0F AF CA 48 0F AF F8 45 8B D1 49 C1 E9 20 4D 03 DA 45 8B D3 49 C1 EB 20 49 03 F9 49 03 FB 4C 8B CE 48 0F AF F2 4C 0F AF C8 49 C1 E2 20 4C 0B D3 8B 01 44 8B DE 48 C1 EE 20 49 03 FB 44 8B DF 48 C1 EF 20 4C 03 CE 4C 03 CF 48 0F AF D0 66 0F C5 D8 03 49 8D BC 24 D0 00 00 00 48 2B CF 03 C9 03 C9 03 C9 83 C1 13 BE 00 80 00 00 23 F3 C1 EB 04 81 E3 FF 07 00 00 81 EB FF 03 00 00 2B CB 4C 03 CA 8B D1 83 C2 20 83 F9 01 0F 8C 8A 02 00 00 F7 D9 83 C1 1D 41 D3 E1 41 8B F9 41 81 E1 FF FF FF 1F 41 F7 C1 00 00 00 10 0F 85 94 02 00 00 41 D3 E9 BB 00 00 00 00 49 C1 E1 20 4D 0B CB 49 83 F9 00 0F 84 F5 01 00 00 4D 0F BD D9 B9 1D 00 00 00 41 2B CB 0F 8E 1D 02 00 00 49 D3 E1 49 8B C2 49 D3 E2 03 D1 F7 D9 83 C1 40 48 D3 E8 49 D3 E8 4C 0B C8 4D 0B D0 F2 49 0F 2A C1 49 D1 EA F2 49 0F 2A DA 66 0F 57 E4 C1 E2 04 F7 DA 81 C2 F0 3F 00 00 0B D6 33 D3 66 0F C4 E2 03 F3 41 0F 7E 94 24 C0 00 00 00 F3 41 0F 7E B4 24 C8 00 00 00 66 0F 57 ED 81 EA F0 03 00 00 66 0F C4 EA 03 F2 0F 59 C4 C1 E6 10 C1 FE 1F F2 0F 59 DD F3 0F 7E C8 F2 0F 59 C2 C1 EF 1D F2 0F 58 CB F2 0F 59 DA 03 FE 33 FE F2 0F 59 F1 8B C7 F2 0F 58 F3 F3 0F 7E D0 F2 0F 58 C6 F2 0F 5C D0 F2 0F 58 F2 F3 41 0F 7E 4C 24 70 F2 0F 59 C8 F3 41 0F 7E 94 24 80 00 00 00 F2 48 0F 2D D1 F2 0F 58 CA F3 41 0F 7E 5C 24 50 F2 0F 5C CA 66 41 0F 28 54 24 40 F2 0F 59 D9 66 0F 14 C9 C1 E0 03 81 C2 10 76 1C 00 F3 0F 7E E0 03 D0 83 E2 3F 66 41 0F 28 6C 24 30 49 8D 84 24 80 01 00 00 C1 E2 05 48 03 C2 66 0F 59 D1 F2 0F 5C C3 F2 41 0F 59 4C 24 60 F2 0F 5C E3 F3 0F 7E 78 08 66 0F 14 C0 F3 0F 7E DC F2 0F 5C E2 66 0F 59 E8 66 0F 5C C2 F2 0F 59 FC F2 0F 5C DC 66 0F 59 E8 66 0F 59 C0 F2 0F 5C DA 66 0F 28 10 F2 0F 5C CB F3 0F 7E 58 18 F2 0F 58 D3 F2 0F 5C FA F2 0F 5C CE 66 41 0F 28 74 24 10 F2 0F 59 D4 66 0F 59 F0 F2 0F 59 DC 66 0F 59 D0 66 0F 59 C0 66 41 0F 58 6C 24 20 F2 0F 59 20 66 41 0F 58 34 24 66 0F 59 E8 F3 0F 7E C3 F2 0F 58 58 08 66 0F 59 CF F3 0F 7E FC F2 0F 58 E3 66 0F 58 F5 F3 0F 7E 68 08 F2 0F 5C EB F2 0F 5C DC F2 0F 58 48 10 66 0F 59 F2 F2 0F 58 E8 F2 0F 58 DF F2 0F 58 CD F2 0F 58 CB F2 0F 58 CE 66 0F 15 F6 F3 0F 7E C4 F2 0F 58 CE F2 0F 58 C1 E9 13 01 00 00 83 C2 40 4D 8B CA 4D 8B D0 49 C7 C0 00 00 00 00 49 83 F9 00 0F 85 F1 FD FF FF 83 C2 40 4D 8B CA 4D 8B D0 49 83 F9 00 0F 85 DE FD FF FF 66 0F 57 C0 66 0F 57 F6 E9 86 FE FF FF 0F 84 F9 FD FF FF F7 D9 49 D3 EA 49 8B C1 49 D3 E9 2B D1 F7 D9 83 C1 40 48 D3 E0 4C 0B D0 E9 DC FD FF FF F7 D9 49 C1 E1 20 4D 0B CB 49 D3 E1 49 8B F9 41 F7 C1 00 00 00 80 75 56 41 D3 E9 BB 00 00 00 00 48 C1 EF 03 E9 7B FD FF FF 41 D3 E9 BB 00 00 00 20 D3 EB 49 C1 E1 20 4D 0B CB 48 C1 E3 20 81 C7 00 00 00 20 48 C7 C1 00 00 00 00 49 C7 C3 00 00 00 00 49 2B C8 4D 1B DA 49 1B D9 4C 8B C1 4D 8B D3 4C 8B CB BB 00 80 00 00 E9 36 FD FF FF 41 D3 E9 48 BB 00 00 00 00 01 00 00 00 48 D3 EB 48 C7 C1 00 00 00 00 49 C7 C3 00 00 00 00 49 2B C8 4D 1B DA 49 1B D9 4C 8B C1 4D 8B D3 4C 8B CB BB 00 80 00 00 48 C1 EF 03 81 C7 00 00 00 20 E9 F2 FC FF FF F2 0F 5C C0 F2 0F 11 44 24 48 0F 28 74 24 30 0F 28 7C 24 20 F2 0F 10 44 24 48 48 83 C4 58 41 5C 5F 5E 5B C3 66 66 66 66 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_362_1_0 {
	meta:
		name = "__sse2_cos2"
		size = 1184
		refs = "001b iABSMASK 0023 dbPio2 0033 dbNegRS 003b dbPi1 0043 dbInvPi 004b dbPi2 005f dbHUGE 0071 db05 008d dbPi3 00a1 dbPi4 00ad dbA8 00b5 dbA7 00dd dbA6 00e5 dbA5 00f5 dbA4 00fd dbA3 010d dbA2 0115 dbA1 0162 TWO_POW_30 0170 flAllOnes 01f1 THE_PI02_INV 0206 MMI_ONE 020e RS 0222 PI02C_0 022e PI02C_1 023e PI02C_2 026f PI02C_3 029b PI02C_4 02ab MMISIGNMASK"
	strings:
		$1 = { 48 81 EC D8 00 00 00 0F 29 BC 24 C0 00 00 00 0F 29 B4 24 B0 00 00 00 66 0F 54 05 ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 C8 66 0F 58 D0 66 0F 28 2D ?? ?? ?? ?? 66 0F 28 25 ?? ?? ?? ?? 66 0F 59 15 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F 54 0D ?? ?? ?? ?? 66 0F 5C D5 66 0F C2 0D ?? ?? ?? ?? 06 66 0F 58 EA 66 0F 73 F2 3F 66 0F 5C 2D ?? ?? ?? ?? 66 0F 50 C1 66 0F 59 E5 66 0F 59 DD 0B C0 0F 85 BC 00 00 00 66 0F 28 0D ?? ?? ?? ?? 66 0F 59 CD 66 0F 5C C4 66 0F 5C C3 66 0F 59 2D ?? ?? ?? ?? 66 0F 5C C1 66 0F 28 1D ?? ?? ?? ?? 66 0F 28 0D ?? ?? ?? ?? 66 0F 58 E8 66 0F 59 C0 66 0F 57 EA 66 0F 28 E0 66 0F 59 C0 66 0F 59 E5 66 0F 59 D8 66 0F 59 C8 66 0F 58 1D ?? ?? ?? ?? 66 0F 58 0D ?? ?? ?? ?? 66 0F 59 D8 66 0F 59 C8 66 0F 58 1D ?? ?? ?? ?? 66 0F 58 0D ?? ?? ?? ?? 66 0F 59 D8 66 0F 59 C8 66 0F 58 1D ?? ?? ?? ?? 66 0F 58 0D ?? ?? ?? ?? 66 0F 59 C3 66 0F 59 CC 66 0F 59 C5 66 0F 58 CD 66 0F 58 C1 0F 28 B4 24 B0 00 00 00 0F 28 BC 24 C0 00 00 00 48 81 C4 D8 00 00 00 C3 C7 44 24 20 00 00 00 00 66 0F 70 C9 F5 66 0F 28 35 ?? ?? ?? ?? 66 0F 54 F0 66 0F 28 3D ?? ?? ?? ?? 66 0F 29 4C 24 30 66 0F 57 0D ?? ?? ?? ?? 66 0F 66 FE 66 0F 29 74 24 40 66 0F 50 D7 66 0F 29 4C 24 50 66 0F 28 0D ?? ?? ?? ?? 66 0F 59 CD 83 F2 03 0F 85 D7 01 00 00 83 F8 03 74 47 66 0F 5C C4 66 0F 5C C3 66 0F 59 2D ?? ?? ?? ?? 66 0F 5C C1 66 0F 58 E8 66 0F 59 C0 66 0F EF EA 66 0F 54 54 24 50 66 0F 54 6C 24 50 66 0F 54 44 24 50 66 0F 29 54 24 60 66 0F 29 6C 24 70 66 0F 29 84 24 80 00 00 00 66 0F 28 C6 66 0F 28 1D ?? ?? ?? ?? 66 0F 59 DE 66 0F E6 DB 66 0F 70 DB DC 66 0F EB 1D ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 56 D3 66 0F 5C 15 ?? ?? ?? ?? 66 0F 28 0D ?? ?? ?? ?? 66 0F 59 CA 66 0F 28 25 ?? ?? ?? ?? 66 0F 59 E2 66 0F 5C C1 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 EA 66 0F 28 C8 66 0F 5C C4 66 0F 5C C8 66 0F 28 F0 66 0F 5C CC 66 0F 5C C5 66 0F 73 F3 3E 66 0F 5C F0 66 0F 28 F8 66 0F 28 25 ?? ?? ?? ?? 66 0F 5C F5 66 0F 58 CE 66 0F 58 C1 66 0F 59 E2 66 0F 5C F8 66 0F 28 E8 66 0F 5C C4 66 0F 58 CF 66 0F 5C E8 66 0F 59 15 ?? ?? ?? ?? 66 0F 5C EC 66 0F 58 CD 66 0F 28 2D ?? ?? ?? ?? 66 0F 5C CA 66 0F DB EB 66 0F 58 C1 66 0F EF 2D ?? ?? ?? ?? 66 0F EF E8 66 0F 59 C0 66 0F 28 1D ?? ?? ?? ?? 66 0F 28 0D ?? ?? ?? ?? 83 F8 03 74 27 66 0F 54 54 24 30 66 0F 54 6C 24 30 66 0F 54 44 24 30 66 0F 56 54 24 60 66 0F 56 6C 24 70 66 0F 56 84 24 80 00 00 00 66 0F 28 E0 66 0F 59 C0 66 0F 59 E5 66 0F 59 D8 66 0F 59 C8 66 0F 58 1D ?? ?? ?? ?? 66 0F 58 0D ?? ?? ?? ?? 66 0F 59 D8 66 0F 59 C8 66 0F 58 1D ?? ?? ?? ?? 66 0F 58 0D ?? ?? ?? ?? 66 0F 59 D8 66 0F 59 C8 66 0F 58 1D ?? ?? ?? ?? 66 0F 58 0D ?? ?? ?? ?? 66 0F 59 C3 66 0F 59 CC 66 0F 59 C5 66 0F 58 CD 66 0F 58 C1 E9 D4 00 00 00 66 0F 29 84 24 90 00 00 00 89 44 24 20 83 F8 03 0F 84 A1 00 00 00 66 0F 5C C4 66 0F 5C C3 66 0F 59 2D ?? ?? ?? ?? 66 0F 5C C1 66 0F 58 E8 66 0F 59 C0 66 0F EF EA 66 0F 28 1D ?? ?? ?? ?? 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 E0 66 0F 59 C0 66 0F 59 E5 66 0F 59 D8 66 0F 59 C8 66 0F 58 1D ?? ?? ?? ?? 66 0F 58 0D ?? ?? ?? ?? 66 0F 59 D8 66 0F 59 C8 66 0F 58 1D ?? ?? ?? ?? 66 0F 58 0D ?? ?? ?? ?? 66 0F 59 D8 66 0F 59 C8 66 0F 58 1D ?? ?? ?? ?? 66 0F 58 0D ?? ?? ?? ?? 66 0F 59 C3 66 0F 59 CC 66 0F 59 C5 66 0F 58 CD 66 0F 58 C1 66 0F 29 84 24 A0 00 00 00 8B 44 24 20 A8 01 75 4E D1 F8 A8 01 75 27 D1 F8 89 44 24 20 66 0F 28 84 24 A0 00 00 00 0F 28 B4 24 B0 00 00 00 0F 28 BC 24 C0 00 00 00 48 81 C4 D8 00 00 00 C3 F2 0F 10 84 24 98 00 00 00 89 44 24 20 E8 8E F6 FF FF F2 0F 11 84 24 A8 00 00 00 8B 44 24 20 EB B8 F2 0F 10 84 24 90 00 00 00 E8 71 F6 FF FF F2 0F 11 84 24 A0 00 00 00 8B 44 24 20 EB 95 66 90 }
	condition:
		$1
}

rule file_363_0_0 {
	meta:
		name = "__sse2_atan2"
		size = 400
		refs = "000c iAbsMask 0014 dbOne 0039 iSignMask 0041 dbPio2hi 007f dbA19 0087 dbA17 008f dbA18 0097 dbA16 00af dbA15 00b7 dbA13 00bf dbA14 00c7 dbA12 00df dbA11 00e7 dbA09 00ef dbA10 00f7 dbA08 010f dbA07 0117 dbA05 011f dbA06 0127 dbA04 013f dbA03 0147 dbA01 014f dbA02 0163 dbA00"
	strings:
		$1 = { 48 83 EC 58 66 0F 28 E8 66 0F DB 05 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F 5F D8 66 0F 28 E0 66 0F 5D 05 ?? ?? ?? ?? 66 0F 5E C3 66 0F C2 25 ?? ?? ?? ?? 06 66 0F DB 2D ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F DB D4 66 0F DB 25 ?? ?? ?? ?? 66 0F EF D5 66 0F EF E5 66 0F EF E0 66 0F 59 C0 66 0F 29 44 24 20 66 0F 59 C0 66 0F 29 44 24 30 66 0F 59 C0 66 0F 29 64 24 40 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 2D ?? ?? ?? ?? 66 0F 28 25 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F 59 C8 66 0F 59 E8 66 0F 59 E0 66 0F 59 D8 66 0F 58 0D ?? ?? ?? ?? 66 0F 58 2D ?? ?? ?? ?? 66 0F 58 25 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 C8 66 0F 59 E8 66 0F 59 E0 66 0F 59 D8 66 0F 58 0D ?? ?? ?? ?? 66 0F 58 2D ?? ?? ?? ?? 66 0F 58 25 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 C8 66 0F 59 E8 66 0F 59 E0 66 0F 59 D8 66 0F 58 0D ?? ?? ?? ?? 66 0F 58 2D ?? ?? ?? ?? 66 0F 58 25 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 C8 66 0F 59 E8 66 0F 59 E0 66 0F 59 C3 66 0F 58 0D ?? ?? ?? ?? 66 0F 58 2D ?? ?? ?? ?? 66 0F 58 25 ?? ?? ?? ?? 66 0F 59 4C 24 30 66 0F 59 6C 24 20 66 0F 58 05 ?? ?? ?? ?? 66 0F 59 4C 24 20 66 0F 59 64 24 30 66 0F 58 C5 66 0F 58 CC 66 0F 58 C1 66 0F 59 44 24 40 66 0F 58 C2 48 83 C4 58 C3 66 90 }
	condition:
		$1
}

rule file_364_0_0 {
	meta:
		name = "__sse2_logf4"
		size = 672
		refs = "0012 flMantissaMask 001a s_dwPosInf 0022 s_dwSqrt2Addition 002d s_fOne 003d s_dwSqrt2Mask 0068 s_dwExpBias 009e s_fB2 00b0 s_fB1 00b7 s_fB0 00c4 s_fLn2 0112 s_dwAbsMask 011e s_dwPosZero 0126 s_dwNegInf 0146 s_dwSpecial1 014e s_dwSpecial2 0178 s_fDenoAdd"
	strings:
		$1 = { 48 83 EC 78 0F 29 7C 24 50 0F 29 74 24 60 66 0F 6F 25 ?? ?? ?? ?? 66 0F 6F 1D ?? ?? ?? ?? 66 0F 6F 15 ?? ?? ?? ?? 66 0F DB E0 0F 28 2D ?? ?? ?? ?? 66 0F FE D4 66 0F 6F C8 66 0F DB 15 ?? ?? ?? ?? 66 0F EF EA 66 0F 72 E2 17 66 0F EB E5 66 0F 72 E0 17 0F 28 2D ?? ?? ?? ?? 0F 58 EC 0F 5C 25 ?? ?? ?? ?? 66 0F FA 05 ?? ?? ?? ?? 66 0F FE C2 0F 28 D4 0F 5E E5 0F 29 4C 24 40 66 0F 66 D9 66 0F 66 0D ?? ?? ?? ?? 0F 28 EC 0F 59 E4 66 0F DB D9 0F 28 CC 0F 59 E4 66 0F D7 D3 0F 28 1D ?? ?? ?? ?? 81 FA FF FF 00 00 75 3C 0F 59 DC 0F 59 25 ?? ?? ?? ?? 0F 58 1D ?? ?? ?? ?? 0F 5B C0 0F 59 D9 0F 59 05 ?? ?? ?? ?? 0F 58 DC 0F 5C DA 0F 59 DD 0F 58 DA 0F 58 C3 0F 28 74 24 60 0F 28 7C 24 50 48 83 C4 78 C3 0F 28 54 24 40 0F 28 F2 66 0F EF FF 66 0F 6F C6 66 0F 76 05 ?? ?? ?? ?? 66 0F DB 05 ?? ?? ?? ?? 66 0F EB F8 66 0F 6F C6 66 0F DB 05 ?? ?? ?? ?? 66 0F 6F C8 66 0F 76 05 ?? ?? ?? ?? 66 0F DB 05 ?? ?? ?? ?? 66 0F EB F8 66 0F 66 0D ?? ?? ?? ?? 66 0F DB CE 66 0F EB F9 66 0F 6F C6 66 0F FE 05 ?? ?? ?? ?? 66 0F 66 05 ?? ?? ?? ?? 66 0F EB F8 66 0F 7F 7C 24 20 66 0F 6F C6 66 0F FE 05 ?? ?? ?? ?? 66 0F 66 05 ?? ?? ?? ?? 66 0F 6F C8 66 0F DB 0D ?? ?? ?? ?? 66 0F 7F 4C 24 30 66 0F 6F C8 66 0F 6F D6 66 0F EB 15 ?? ?? ?? ?? 0F 5C 15 ?? ?? ?? ?? 66 0F DB C2 66 0F 76 3D ?? ?? ?? ?? 66 0F DB F7 66 0F DF 3D ?? ?? ?? ?? 66 0F EB FE 66 0F DF CF 66 0F EB C1 66 0F 6F 25 ?? ?? ?? ?? 66 0F 6F 1D ?? ?? ?? ?? 66 0F 6F 15 ?? ?? ?? ?? 66 0F DB E0 0F 28 2D ?? ?? ?? ?? 66 0F FE D4 66 0F 6F C8 66 0F DB 15 ?? ?? ?? ?? 66 0F EF EA 66 0F 72 E2 17 66 0F EB E5 66 0F 72 E0 17 0F 28 3D ?? ?? ?? ?? 0F 58 FC 0F 5C 25 ?? ?? ?? ?? 66 0F FA 05 ?? ?? ?? ?? 0F 28 EC 0F 5E E7 66 0F FE C2 0F 28 D1 66 0F 66 D9 66 0F 66 0D ?? ?? ?? ?? 0F 28 FC 0F 59 E4 66 0F DB D9 0F 28 CC 0F 59 E4 66 0F D7 D3 0F 28 1D ?? ?? ?? ?? 0F 28 15 ?? ?? ?? ?? 0F 59 DC 0F 59 D4 0F 58 1D ?? ?? ?? ?? 0F 5B C0 0F 59 D9 0F 59 05 ?? ?? ?? ?? 0F 58 DA 0F 5C DD 0F 59 DF 0F 58 DD 0F 58 C3 66 0F EB 44 24 20 0F 58 44 24 30 0F 28 74 24 60 0F 28 7C 24 50 48 83 C4 78 C3 0F 1F 80 00 00 00 00 }
	condition:
		$1
}

rule file_368_1_0 {
	meta:
		name = "__scrt_fastfail"
		size = 401
		refs = "0012 IsProcessorFeaturePresent 002b __crt_debugger_hook 004d __imp_RtlCaptureContext 006d __imp_RtlLookupFunctionEntry 00bb __imp_RtlVirtualUnwind 011f __imp_IsDebuggerPresent 015b __imp_SetUnhandledExceptionFilter 0166 __imp_UnhandledExceptionFilter"
	strings:
		$1 = { 89 4C 24 08 57 48 81 EC F0 05 00 00 B9 17 00 00 00 E8 ?? ?? ?? ?? 85 C0 74 0B 8B 84 24 00 06 00 00 8B C8 CD 29 B9 03 00 00 00 E8 ?? ?? ?? ?? 48 8D 84 24 20 01 00 00 48 8B F8 33 C0 B9 D0 04 00 00 F3 AA 48 8D 8C 24 20 01 00 00 FF 15 ?? ?? ?? ?? 48 8B 84 24 18 02 00 00 48 89 44 24 50 45 33 C0 48 8D 54 24 58 48 8B 4C 24 50 FF 15 ?? ?? ?? ?? 48 89 44 24 48 48 83 7C 24 48 00 74 41 48 C7 44 24 38 00 00 00 00 48 8D 44 24 70 48 89 44 24 30 48 8D 44 24 78 48 89 44 24 28 48 8D 84 24 20 01 00 00 48 89 44 24 20 4C 8B 4C 24 48 4C 8B 44 24 50 48 8B 54 24 58 33 C9 FF 15 ?? ?? ?? ?? 48 8B 84 24 F8 05 00 00 48 89 84 24 18 02 00 00 48 8D 84 24 F8 05 00 00 48 83 C0 08 48 89 84 24 B8 01 00 00 48 8D 84 24 80 00 00 00 48 8B F8 33 C0 B9 98 00 00 00 F3 AA C7 84 24 80 00 00 00 15 00 00 40 C7 84 24 84 00 00 00 01 00 00 00 48 8B 84 24 F8 05 00 00 48 89 84 24 90 00 00 00 FF 15 ?? ?? ?? ?? 83 F8 01 75 07 C6 44 24 40 01 EB 05 C6 44 24 40 00 0F B6 44 24 40 88 44 24 41 48 8D 84 24 80 00 00 00 48 89 44 24 60 48 8D 84 24 20 01 00 00 48 89 44 24 68 33 C9 FF 15 ?? ?? ?? ?? 48 8D 4C 24 60 FF 15 ?? ?? ?? ?? 89 44 24 44 83 7C 24 44 00 75 13 0F B6 44 24 41 85 C0 75 0A B9 03 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 F0 05 00 00 5F C3 }
	condition:
		$1
}

rule file_368_2_0 {
	meta:
		name = "__scrt_get_show_window_mode"
		size = 81
		refs = "0021 __imp_GetStartupInfoW"
	strings:
		$1 = { 40 57 48 81 EC A0 00 00 00 48 8D 44 24 30 48 8B F8 33 C0 B9 68 00 00 00 F3 AA 48 8D 4C 24 30 FF 15 ?? ?? ?? ?? 8B 44 24 6C 83 E0 01 85 C0 74 0B 0F B7 44 24 70 89 44 24 20 EB 08 C7 44 24 20 0A 00 00 00 0F B7 44 24 20 48 81 C4 A0 00 00 00 5F C3 }
	condition:
		$1
}

rule file_368_4_0 {
	meta:
		name = "__scrt_is_managed_app"
		size = 166
		refs = "0008 __imp_GetModuleHandleW"
	strings:
		$1 = { 48 83 EC 38 33 C9 FF 15 ?? ?? ?? ?? 48 89 44 24 20 48 83 7C 24 20 00 75 07 32 C0 E9 81 00 00 00 48 8B 44 24 20 0F B7 00 3D 4D 5A 00 00 74 04 32 C0 EB 6E 48 8B 44 24 20 48 63 40 3C 48 8B 4C 24 20 48 03 C8 48 8B C1 48 89 44 24 28 48 8B 44 24 28 81 38 50 45 00 00 74 04 32 C0 EB 44 48 8B 44 24 28 0F B7 40 18 3D 0B 02 00 00 74 04 32 C0 EB 30 48 8B 44 24 28 83 B8 84 00 00 00 0E 77 04 32 C0 EB 1E B8 08 00 00 00 48 6B C0 0E 48 8B 4C 24 28 83 BC 01 88 00 00 00 00 75 04 32 C0 EB 02 B0 01 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_368_6_0 {
	meta:
		name = "__scrt_unhandled_exception_filter"
		size = 114
		refs = "0067 terminate"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 48 8B 00 48 89 44 24 20 48 8B 44 24 20 81 38 63 73 6D E0 75 48 48 8B 44 24 20 83 78 18 04 75 3D 48 8B 44 24 20 81 78 20 20 05 93 19 74 2A 48 8B 44 24 20 81 78 20 21 05 93 19 74 1C 48 8B 44 24 20 81 78 20 22 05 93 19 74 0E 48 8B 44 24 20 81 78 20 00 40 99 01 75 05 E8 ?? ?? ?? ?? 33 C0 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_370_0_0 {
	meta:
		name = "__avx_exp4"
		size = 560
		refs = "000a __common_dexp_data 0229 __common_dexp_cout_rare"
	strings:
		$1 = { 48 81 EC 18 02 00 00 48 8D 05 ?? ?? ?? ?? C5 7C 11 94 24 F0 01 00 00 C5 7C 11 84 24 D0 01 00 00 4C 89 AC 24 10 02 00 00 4C 8D AC 24 6F 01 00 00 C5 FD 10 0D ?? ?? ?? ?? 49 83 E5 C0 C5 FD 59 15 ?? ?? ?? ?? C5 F9 10 25 ?? ?? ?? ?? C5 ED 58 D9 C5 E5 5C C9 C4 E3 7D 19 C5 01 C5 F8 C6 D5 DD C5 68 54 05 ?? ?? ?? ?? C5 39 66 15 ?? ?? ?? ?? C4 C1 78 50 D2 C5 E0 54 EC C4 E3 7D 19 DA 01 C5 D9 DF DB C5 F9 7E E9 C5 68 54 C4 C4 41 79 7E C1 C5 D9 DF E2 C5 E9 73 F4 2A C1 E1 03 C4 C3 79 16 E8 02 41 C1 E0 03 41 C1 E1 03 C4 43 79 16 C2 02 41 C1 E2 03 C4 61 F9 6E 14 01 C4 C1 29 16 2C 00 C4 41 F9 6E 14 01 C4 41 29 16 04 02 C4 43 55 18 C0 01 C5 F5 59 2D ?? ?? ?? ?? C5 F5 59 0D ?? ?? ?? ?? C5 7D 5C D5 C5 2D 5C D1 C5 AD 58 2D ?? ?? ?? ?? C4 C1 55 59 CA C5 F5 58 2D ?? ?? ?? ?? C5 F1 73 F3 2A C4 41 55 59 D2 C5 AD 58 2D ?? ?? ?? ?? C5 3D 59 C5 C4 63 7D 19 C5 01 C5 B9 D4 D9 C5 D1 D4 CA C4 E3 65 18 C9 01 85 D2 75 26 C5 7C 10 84 24 D0 01 00 00 C5 7C 10 94 24 F0 01 00 00 4C 8B AC 24 10 02 00 00 C5 FD 28 C1 48 81 C4 18 02 00 00 C3 C4 C1 7D 11 45 00 C4 C1 7D 11 4D 40 74 CC 33 C0 C5 FC 11 B4 24 00 01 00 00 C5 FC 11 BC 24 E0 00 00 00 C5 7C 11 8C 24 C0 00 00 00 C5 7C 11 9C 24 A0 00 00 00 C5 7C 11 A4 24 80 00 00 00 C5 7C 11 6C 24 60 C5 7C 11 74 24 40 C5 7C 11 7C 24 20 48 89 9C 24 28 01 00 00 8B D8 48 89 B4 24 20 01 00 00 8B F2 0F A3 DE 72 61 FF C3 83 FB 20 7C F4 C5 FC 10 B4 24 00 01 00 00 C5 FC 10 BC 24 E0 00 00 00 C5 7C 10 8C 24 C0 00 00 00 C5 7C 10 9C 24 A0 00 00 00 C5 7C 10 A4 24 80 00 00 00 C5 7C 10 6C 24 60 C5 7C 10 74 24 40 C5 7C 10 7C 24 20 C4 C1 7D 10 4D 40 48 8B 9C 24 28 01 00 00 48 8B B4 24 20 01 00 00 E9 11 FF FF FF C5 F8 77 49 8D 4C DD 00 49 8D 54 DD 40 E8 ?? ?? ?? ?? EB 8B 90 }
	condition:
		$1
}

rule file_371_0_0 {
	meta:
		name = "__vdecl_fmodf8"
		size = 199
		refs = "0011 fmodf"
	strings:
		$1 = { 48 83 EC 68 C5 FE 7F 44 24 20 C5 FE 7F 4C 24 40 E8 ?? ?? ?? ?? 66 0F 7E 44 24 20 66 0F 6E 44 24 24 66 0F 6E 4C 24 44 E8 ?? ?? ?? ?? 66 0F 7E 44 24 24 66 0F 6E 44 24 28 66 0F 6E 4C 24 48 E8 ?? ?? ?? ?? 66 0F 7E 44 24 28 66 0F 6E 44 24 2C 66 0F 6E 4C 24 4C E8 ?? ?? ?? ?? 66 0F 7E 44 24 2C 66 0F 6E 44 24 30 66 0F 6E 4C 24 50 E8 ?? ?? ?? ?? 66 0F 7E 44 24 30 66 0F 6E 44 24 34 66 0F 6E 4C 24 54 E8 ?? ?? ?? ?? 66 0F 7E 44 24 34 66 0F 6E 44 24 38 66 0F 6E 4C 24 58 E8 ?? ?? ?? ?? 66 0F 7E 44 24 38 66 0F 6E 44 24 3C 66 0F 6E 4C 24 5C E8 ?? ?? ?? ?? 66 0F 7E 44 24 3C C5 FE 6F 44 24 20 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_372_0_0 {
	meta:
		name = "_guard_check_icall"
		size = 25
		refs = "0010 __guard_check_icall_fptr"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 FF 15 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_89_1_3 {
	meta:
		name = "?_Mtx_lock@threads@stdext@@YAXPEAX@Z"
		size = 25
		refs = "0010 __imp_EnterCriticalSection"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 FF 15 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_89_3_3 {
	meta:
		name = "?_Mtx_unlock@threads@stdext@@YAXPEAX@Z"
		size = 25
		refs = "0010 __imp_LeaveCriticalSection"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 FF 15 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_41_100_1 {
	meta:
		name = "_Close_dir"
		size = 25
		refs = "0010 __imp_FindClose"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 FF 15 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_69_0_1 {
	meta:
		name = "_Mtxdst"
		size = 25
		refs = "0010 __imp_DeleteCriticalSection"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 FF 15 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_15_2_2 {
	meta:
		name = "_Mtxlock"
		size = 25
		refs = "0010 __imp_EnterCriticalSection"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 FF 15 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_15_3_2 {
	meta:
		name = "_Mtxunlock"
		size = 25
		refs = "0010 __imp_LeaveCriticalSection"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 FF 15 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_109_0_1 {
	meta:
		name = "_Smtx_lock_exclusive"
		size = 25
		refs = "0010 __imp_AcquireSRWLockExclusive"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 FF 15 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_109_1_1 {
	meta:
		name = "_Smtx_lock_shared"
		size = 25
		refs = "0010 __imp_AcquireSRWLockShared"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 FF 15 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_109_4_1 {
	meta:
		name = "_Smtx_unlock_exclusive"
		size = 25
		refs = "0010 __imp_ReleaseSRWLockExclusive"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 FF 15 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_88_5_3 {
	meta:
		name = "_Smtx_unlock_shared"
		size = 25
		refs = "0010 __imp_ReleaseSRWLockShared"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 FF 15 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_28_1_4 {
	meta:
		name = "__vcrt_GetModuleHandleW"
		size = 25
		refs = "0010 __imp_GetModuleHandleW"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 FF 15 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_375_0_0 {
	meta:
		name = "__mpx_init_static_rep"
		size = 254
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 F3 0F 1B 04 25 FF FF FF FF 66 0F 1B 44 24 30 48 83 7C 24 50 00 F2 75 06 F2 E9 CD 00 00 00 48 8B 44 24 58 48 89 04 24 EB 0B 48 8B 04 24 48 FF C8 48 89 04 24 48 83 3C 24 00 F2 0F 86 AB 00 00 00 48 8B 44 24 50 48 8B 4C 24 50 48 8B 49 08 48 8B 40 10 48 2B C1 48 89 44 24 18 48 8B 44 24 50 48 83 C0 08 48 89 44 24 08 48 8B 44 24 08 48 8B 00 48 8B 4C 24 08 48 8B 09 48 8B 54 24 18 48 FF CA F3 0F 1B 04 11 66 0F 1B 44 24 30 48 89 44 24 10 48 8B 44 24 50 48 8B 00 48 89 44 24 20 48 8B 44 24 20 48 8B 00 66 0F 1A 44 24 30 66 0F 1B 44 24 30 48 89 44 24 10 48 8B 44 24 50 48 89 44 24 28 48 8B 44 24 28 48 8B 00 48 8B 4C 24 10 66 0F 1A 44 24 30 0F 1B 04 08 48 8B 44 24 50 48 83 C0 18 48 89 44 24 50 F2 E9 3E FF FF FF 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_377_0_0 {
	meta:
		name = "__sse2_coshf4"
		size = 416
		refs = "0032 __common_scosh_data 0193 __common_scosh_cout_rare"
	strings:
		$1 = { 48 81 EC F8 00 00 00 44 0F 29 AC 24 E0 00 00 00 44 0F 29 94 24 C0 00 00 00 44 0F 29 8C 24 D0 00 00 00 4C 89 AC 24 F0 00 00 00 4C 8D 6C 24 6F 0F 28 1D ?? ?? ?? ?? 49 83 E5 C0 0F 28 15 ?? ?? ?? ?? 0F 55 D8 0F 59 D3 44 0F 28 CB 44 0F 28 2D ?? ?? ?? ?? 66 0F 6F 0D ?? ?? ?? ?? 41 0F 58 D5 66 44 0F 66 C9 66 0F 76 CB 66 44 0F EB C9 0F 28 CA 41 0F 50 D1 66 0F 72 F2 17 44 0F 28 0D ?? ?? ?? ?? 41 0F 5C CD 44 0F 28 2D ?? ?? ?? ?? 85 D2 44 0F 59 E9 44 0F 59 C9 41 0F 5C DD 44 0F 28 15 ?? ?? ?? ?? 41 0F 5C D9 0F 28 CB 0F 59 CB 0F 28 2D ?? ?? ?? ?? 44 0F 59 D1 0F 59 E9 44 0F 58 15 ?? ?? ?? ?? 0F 58 2D ?? ?? ?? ?? 44 0F 59 D1 0F 59 E9 44 0F 59 D3 0F 58 2D ?? ?? ?? ?? 44 0F 58 D3 0F 59 E9 66 0F 6F 25 ?? ?? ?? ?? 66 44 0F 6F CC 66 0F FA E2 66 44 0F FE CA 66 41 0F 6F D1 44 0F 58 CC 0F 5C D4 41 0F 59 E9 41 0F 59 D2 0F 58 D5 41 0F 58 D1 75 2E 44 0F 28 8C 24 D0 00 00 00 0F 28 C2 44 0F 28 94 24 C0 00 00 00 44 0F 28 AC 24 E0 00 00 00 4C 8B AC 24 F0 00 00 00 48 81 C4 F8 00 00 00 C3 41 0F 29 45 00 41 0F 29 55 40 74 C6 33 C0 48 89 5C 24 28 8B D8 48 89 74 24 20 8B F2 8B CB 41 B8 01 00 00 00 41 D3 E0 41 85 F0 75 18 FF C3 83 FB 20 7C E9 48 8B 5C 24 28 48 8B 74 24 20 41 0F 28 55 40 EB 8E 49 8D 4C 9D 00 49 8D 54 9D 40 E8 ?? ?? ?? ?? EB D7 0F 1F 80 00 00 00 00 }
	condition:
		$1
}

rule file_385_0_0 {
	meta:
		name = "__sse2_asin2"
		size = 656
		refs = "0049 __common_dasin_data 027c __common_dasin_cout_rare"
	strings:
		$1 = { 48 81 EC 18 01 00 00 44 0F 29 BC 24 E0 00 00 00 44 0F 29 B4 24 00 01 00 00 44 0F 29 9C 24 D0 00 00 00 44 0F 29 8C 24 C0 00 00 00 44 0F 29 84 24 F0 00 00 00 44 0F 28 C0 4C 89 AC 24 10 01 00 00 4C 8D 6C 24 6F 44 0F 28 1D ?? ?? ?? ?? 49 83 E5 C0 0F 28 0D ?? ?? ?? ?? 45 0F 28 F3 45 0F 54 F0 0F 28 E9 66 41 0F 59 EE 0F 28 E1 45 0F 28 FE 66 0F 5C E5 66 45 0F 59 FE 66 0F 5A D4 66 44 0F 5D FC 66 0F 58 E4 0F 16 D2 41 0F 28 EE 44 0F 52 CA 66 0F C2 E9 05 41 0F 5A D1 0F 28 1D ?? ?? ?? ?? 45 0F 55 D8 66 41 0F C2 DE 02 66 0F 50 D3 0F 28 DA 0F 28 05 ?? ?? ?? ?? 44 0F 28 0D ?? ?? ?? ?? 66 0F 59 DA 66 0F 59 D4 66 0F 59 E3 66 41 0F 59 C7 66 0F 5C 25 ?? ?? ?? ?? 66 0F 58 05 ?? ?? ?? ?? 66 45 0F 59 CF 0F 28 1D ?? ?? ?? ?? 0F 28 CC 66 0F 59 DC 66 0F 59 CA 66 0F 58 1D ?? ?? ?? ?? 66 44 0F 58 0D ?? ?? ?? ?? 66 0F 59 DC 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 DC 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 D9 41 0F 28 CF 85 D2 66 41 0F 59 CF 66 0F 5C DA 66 0F 59 C1 0F 28 25 ?? ?? ?? ?? 0F 54 DD 66 41 0F 59 E7 0F 28 15 ?? ?? ?? ?? 66 41 0F 59 D7 66 0F 58 25 ?? ?? ?? ?? 66 0F 58 15 ?? ?? ?? ?? 66 0F 58 C4 66 0F 59 D1 0F 28 E1 66 0F 59 E1 66 41 0F 58 D1 66 0F 59 C4 44 0F 28 0D ?? ?? ?? ?? 66 45 0F 59 CF 66 0F 58 C2 66 44 0F 58 0D ?? ?? ?? ?? 66 0F 59 C1 0F 28 15 ?? ?? ?? ?? 66 41 0F 58 C1 66 41 0F 59 D7 66 0F 59 C1 66 0F 58 15 ?? ?? ?? ?? 66 0F 58 C2 66 41 0F 59 C7 44 0F 28 FD 45 0F 55 FE 44 0F 56 FB 66 41 0F 59 C7 66 41 0F 58 C7 44 0F 28 35 ?? ?? ?? ?? 44 0F 54 F5 66 41 0F 58 C6 66 41 0F EF C3 75 3D 44 0F 28 84 24 F0 00 00 00 44 0F 28 8C 24 C0 00 00 00 44 0F 28 9C 24 D0 00 00 00 44 0F 28 B4 24 00 01 00 00 44 0F 28 BC 24 E0 00 00 00 4C 8B AC 24 10 01 00 00 48 81 C4 18 01 00 00 C3 45 0F 29 45 00 41 0F 29 45 40 74 B7 33 C0 48 89 5C 24 28 8B D8 48 89 74 24 20 8B F2 8B CB 41 B8 01 00 00 00 41 D3 E0 41 85 F0 75 1B FF C3 83 FB 20 7C E9 48 8B 5C 24 28 48 8B 74 24 20 41 0F 28 45 40 E9 7C FF FF FF 49 8D 4C DD 00 49 8D 54 DD 40 E8 ?? ?? ?? ?? EB D4 66 66 66 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_386_0_0 {
	meta:
		name = "__avx_floorf8"
		size = 16
	strings:
		$1 = { C4 E3 7D 08 C0 01 C3 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_388_0_0 {
	meta:
		name = "__sse4_expf4"
		size = 624
		refs = "0003 s_dwExp2_Table 000a s_dwInvLn 0014 s_dwLnHi 001b s_dwBias 0026 flAbsMask 0032 flBound1 0059 s_dwLnLo 00a4 flTwo 0165 flBound2 018e s_dwNegRS 01f2 flInf 0256 flOne"
	strings:
		$1 = { 4C 8D 05 ?? ?? ?? ?? 0F 28 1D ?? ?? ?? ?? 0F 59 D8 0F 28 25 ?? ?? ?? ?? 0F 28 0D ?? ?? ?? ?? 66 0F 5B D3 0F 28 2D ?? ?? ?? ?? 66 0F DB E8 66 0F 66 2D ?? ?? ?? ?? 0F 50 CD 23 C9 0F 85 7F 00 00 00 0F 28 E8 66 0F 3A 08 DB 00 66 0F 7E D0 0F 59 E3 66 0F C5 D2 02 0F 59 1D ?? ?? ?? ?? 83 E0 3F 83 E2 3F 66 0F FE CA 0F 5C C4 F3 41 0F 7E 24 C0 66 0F C5 C2 04 41 0F 16 24 D0 66 0F C5 D2 06 0F 5C C3 83 E0 3F 83 E2 3F 66 0F 72 D1 06 F3 41 0F 7E 14 C0 41 0F 16 14 D0 0F 28 D8 0F 58 C0 0F 59 DB 0F 58 05 ?? ?? ?? ?? 0F C6 E2 88 66 0F 72 F1 17 0F 58 C3 66 0F EB CC 0F 59 C1 C3 0F 1F 40 00 0F 28 E8 66 0F 3A 08 DB 00 66 0F 7E D1 0F 59 E3 66 44 0F C5 CA 02 0F 59 1D ?? ?? ?? ?? 83 E1 3F 41 83 E1 3F 66 0F FE CA 0F 5C C4 F3 41 0F 7E 24 C8 66 44 0F C5 D2 04 43 0F 16 24 C8 66 44 0F C5 DA 06 0F 5C C3 41 83 E2 3F 41 83 E3 3F 66 0F 72 D1 06 F3 43 0F 7E 1C D0 43 0F 16 1C D8 0F C6 E3 88 0F 28 D8 0F 58 C0 0F 59 DB 0F 58 05 ?? ?? ?? ?? 66 0F 72 F1 17 0F 58 C3 66 0F EB CC 0F 59 C8 0F 28 1D ?? ?? ?? ?? 66 0F DB DD 0F C2 1D ?? ?? ?? ?? 01 66 0F DB CB 0F 28 15 ?? ?? ?? ?? 66 0F DB D5 0F C2 15 ?? ?? ?? ?? 01 66 0F DF DA 66 0F DB C3 0F 50 D5 B8 03 00 00 00 23 C2 83 E2 0C 03 C0 0F 28 15 ?? ?? ?? ?? 0F 59 D5 0F 5C 15 ?? ?? ?? ?? 66 0F DB D3 66 0F DB E3 66 0F FE 15 ?? ?? ?? ?? 66 0F 72 D2 06 41 0F 28 9C C0 40 02 00 00 41 0F C6 9C 90 40 02 00 00 88 66 0F FE D3 66 0F 72 F2 17 66 0F EB D4 0F 59 C2 41 0F 28 9C C0 00 02 00 00 41 0F C6 9C 90 00 02 00 00 88 0F 59 C3 66 0F EB C1 0F 28 1D ?? ?? ?? ?? 66 0F DB DD 0F C2 1D ?? ?? ?? ?? 01 0F 28 15 ?? ?? ?? ?? 66 0F DB D5 0F C2 15 ?? ?? ?? ?? 01 66 0F DF D3 41 0F 28 8C C0 80 02 00 00 41 0F C6 8C 90 80 02 00 00 88 66 0F DB CA 0F 28 15 ?? ?? ?? ?? 66 0F DB D5 0F C2 15 ?? ?? ?? ?? 00 41 0F 28 9C C0 C0 02 00 00 41 0F C6 9C 90 C0 02 00 00 88 66 0F DB D3 66 0F EB CA 0F 28 15 ?? ?? ?? ?? 0F C2 D5 03 66 0F DB EA 66 0F EB CD 0F 59 C9 66 0F EB C1 C3 66 90 }
	condition:
		$1
}

rule file_395_0_0 {
	meta:
		name = "__common_slog_cout_rare"
		size = 720
		refs = "003d _imlsLnHATab 0063 _2il0floatpacket_72 026a _2il0floatpacket_73"
	strings:
		$1 = { 48 83 EC 38 33 C0 44 0F B7 41 02 41 81 E0 80 7F 00 00 41 81 F8 80 7F 00 00 0F 84 60 02 00 00 F3 0F 5A 19 F2 0F 11 5C 24 30 45 33 C0 0F B7 4C 24 36 F7 C1 F0 7F 00 00 75 14 F2 0F 59 1D ?? ?? ?? ?? 41 B8 C4 FF FF FF F2 0F 11 5C 24 30 F2 0F 10 05 ?? ?? ?? ?? 66 0F 2F D8 0F 86 DD 01 00 00 F2 0F 10 05 ?? ?? ?? ?? 0F 28 D3 F2 0F 5C D0 F2 0F 11 54 24 28 80 64 24 2F 7F F2 0F 10 4C 24 28 66 0F 2F 0D ?? ?? ?? ?? 0F 86 43 01 00 00 F2 0F 11 5C 24 28 44 0F B7 4C 24 2E 41 81 E1 0F 80 FF FF 41 81 C9 F0 3F FF FF 66 44 89 4C 24 2E F2 0F 10 6C 24 28 0F 28 DD 0F B7 4C 24 36 81 E1 F0 7F 00 00 F2 0F 58 1D ?? ?? ?? ?? C1 E9 04 F2 0F 11 5C 24 20 0F 28 DD 44 8B 54 24 20 41 83 E2 7F F2 0F 58 1D ?? ?? ?? ?? F2 0F 11 5C 24 20 45 8D 84 08 01 FC FF FF F2 41 0F 2A C8 F2 0F 10 5C 24 20 47 8D 1C 52 48 8D 0D ?? ?? ?? ?? F2 0F 10 15 ?? ?? ?? ?? 4C 8B C9 F2 0F 10 25 ?? ?? ?? ?? 4C 8B C1 F2 0F 59 D1 F2 0F 5C 1D ?? ?? ?? ?? F2 0F 59 CC F2 0F 5C EB F2 43 0F 58 54 D8 08 F2 43 0F 58 4C D9 10 F2 42 0F 10 24 D9 F2 0F 59 DC F2 0F 59 E5 F2 0F 5C D8 0F 28 C3 F2 0F 58 DA F2 0F 58 C4 F2 0F 58 E1 F2 0F 10 2D ?? ?? ?? ?? F2 0F 59 E8 F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 E8 F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 E8 F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 E8 F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 E8 F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 E8 F2 0F 59 C0 F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 E8 F2 0F 58 E5 F2 0F 58 DC F2 0F 5A DB F3 0F 11 1A 48 83 C4 38 C3 F2 0F 10 0D ?? ?? ?? ?? 0F 28 C2 F2 0F 59 CA F2 0F 59 C2 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 58 D1 F2 0F 5A D2 F3 0F 11 12 48 83 C4 38 C3 66 0F 2E D8 7A 02 74 16 F2 0F 5E C0 F2 0F 5A C0 F3 0F 11 02 B8 01 00 00 00 48 83 C4 38 C3 F2 0F 10 0D ?? ?? ?? ?? B8 02 00 00 00 0F 57 0D ?? ?? ?? ?? F2 0F 5E C8 F2 0F 5A C9 F3 0F 11 0A 48 83 C4 38 C3 44 8A 41 03 41 80 E0 80 41 80 F8 80 74 11 F3 0F 10 01 F3 0F 59 C0 F3 0F 11 02 48 83 C4 38 C3 F7 01 FF FF 7F 00 75 E7 F2 0F 10 05 ?? ?? ?? ?? B8 01 00 00 00 F2 0F 5E C0 F2 0F 5A C0 F3 0F 11 02 48 83 C4 38 C3 66 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_398_0_0 {
	meta:
		name = "__sse2_acosf4"
		size = 416
		refs = "0031 __common_sacos_data 019a __common_sacos_cout_rare"
	strings:
		$1 = { 48 81 EC F8 00 00 00 44 0F 29 84 24 C0 00 00 00 0F 29 BC 24 D0 00 00 00 0F 29 B4 24 E0 00 00 00 4C 89 AC 24 F0 00 00 00 4C 8D 6C 24 6F 44 0F 28 05 ?? ?? ?? ?? 49 83 E5 C0 41 0F 28 F8 44 0F 54 C0 0F 56 F8 0F 28 15 ?? ?? ?? ?? 0F 28 EF 0F 59 EA 0F 28 E7 0F 59 E7 0F 58 EA 0F 52 D5 0F 5D E5 0F 28 DF 0F 28 CA 0F C2 1D ?? ?? ?? ?? 02 0F 59 CA 0F 50 D3 0F 28 DC 0F 28 35 ?? ?? ?? ?? 0F C2 DD 05 0F 58 ED 0F 59 D5 85 D2 0F 59 E9 0F 28 0D ?? ?? ?? ?? 0F 59 CC 0F 5C 2D ?? ?? ?? ?? 0F 59 F5 0F 58 0D ?? ?? ?? ?? 0F 59 EA 0F 58 35 ?? ?? ?? ?? 0F 59 F5 0F 28 EC 0F 59 EC 0F 5C D6 0F 59 CD 0F 28 35 ?? ?? ?? ?? 0F 28 E8 0F 59 F4 0F 54 D3 0F C2 EC 01 0F 58 35 ?? ?? ?? ?? 0F 58 CE 0F 28 F3 0F 59 CC 0F 55 35 ?? ?? ?? ?? 0F 58 0D ?? ?? ?? ?? 0F 59 CC 0F 28 25 ?? ?? ?? ?? 0F 54 E3 0F 54 E5 0F 28 EB 0F 55 EF 0F 58 F4 0F 56 EA 66 41 0F EF E8 0F 59 CD 0F 58 CD 0F 58 F1 75 2C 0F 28 BC 24 D0 00 00 00 0F 28 C6 0F 28 B4 24 E0 00 00 00 44 0F 28 84 24 C0 00 00 00 4C 8B AC 24 F0 00 00 00 48 81 C4 F8 00 00 00 C3 41 0F 29 45 00 41 0F 29 75 40 74 C8 33 C0 48 89 5C 24 28 8B D8 48 89 74 24 20 8B F2 8B CB 41 B8 01 00 00 00 41 D3 E0 41 85 F0 75 18 FF C3 83 FB 20 7C E9 48 8B 5C 24 28 48 8B 74 24 20 41 0F 28 75 40 EB 90 49 8D 4C 9D 00 49 8D 54 9D 40 E8 ?? ?? ?? ?? EB D7 }
	condition:
		$1
}

rule file_401_0_0 {
	meta:
		name = "__sse2_cosh2"
		size = 576
		refs = "000a __common_dcosh_data 022b __common_dcosh_cout_rare"
	strings:
		$1 = { 48 81 EC 18 01 00 00 48 8D 05 ?? ?? ?? ?? 44 0F 29 9C 24 00 01 00 00 44 0F 29 94 24 E0 00 00 00 44 0F 29 84 24 C0 00 00 00 0F 29 BC 24 D0 00 00 00 0F 29 B4 24 F0 00 00 00 0F 28 F0 4C 89 AC 24 10 01 00 00 4C 8D 6C 24 6F 0F 28 15 ?? ?? ?? ?? 49 83 E5 C0 0F 28 CA 66 0F 73 D2 0B 0F 28 1D ?? ?? ?? ?? 0F 55 CE 66 0F 59 D9 0F 28 25 ?? ?? ?? ?? 66 0F 58 DC F3 44 0F 7E 05 ?? ?? ?? ?? 66 44 0F 70 D1 DD F3 0F 7E 3D ?? ?? ?? ?? 66 45 0F 66 D0 66 44 0F 70 C3 88 F3 44 0F 7E 1D ?? ?? ?? ?? 66 44 0F DB C7 66 45 0F FA D8 66 41 0F 6F F8 66 41 0F 72 F3 03 66 0F 72 F7 03 66 45 0F 7E D9 66 45 0F 70 DB 01 0F 28 05 ?? ?? ?? ?? 66 45 0F 7E DA 44 0F 28 DB 41 0F 50 D2 66 0F 73 F3 2C 66 44 0F 70 D7 01 0F 28 2D ?? ?? ?? ?? 66 44 0F 5C DC 66 0F 7E F9 66 45 0F 7E D0 0F 28 25 ?? ?? ?? ?? 0F 28 3D ?? ?? ?? ?? 66 41 0F 59 E3 66 41 0F 59 FB 66 0F 5C CC 66 0F 5C CF 44 0F 28 D9 83 E2 03 66 44 0F 59 D9 66 41 0F 59 EB 66 41 0F 59 C3 66 0F 59 E9 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 E9 66 41 0F 59 C3 4D 63 C9 48 63 C9 4D 63 D2 4D 63 C0 F2 45 0F 10 14 01 F2 44 0F 10 04 01 66 45 0F 16 14 02 66 0F DB 1D ?? ?? ?? ?? 66 45 0F 16 04 00 66 44 0F FB D3 66 44 0F D4 C3 66 44 0F FB D2 41 0F 28 D0 66 41 0F 5C D2 66 45 0F 58 C2 66 0F 59 EA 66 41 0F 59 C0 66 0F 58 C5 66 41 0F 58 C0 75 3B 0F 28 B4 24 F0 00 00 00 0F 28 BC 24 D0 00 00 00 44 0F 28 84 24 C0 00 00 00 44 0F 28 94 24 E0 00 00 00 44 0F 28 9C 24 00 01 00 00 4C 8B AC 24 10 01 00 00 48 81 C4 18 01 00 00 C3 41 0F 29 75 00 41 0F 29 45 40 74 B9 33 C0 48 89 5C 24 28 8B D8 48 89 74 24 20 8B F2 8B CB 41 B8 01 00 00 00 41 D3 E0 41 85 F0 75 18 FF C3 83 FB 20 7C E9 48 8B 5C 24 28 48 8B 74 24 20 41 0F 28 45 40 EB 81 49 8D 4C DD 00 49 8D 54 DD 40 E8 ?? ?? ?? ?? EB D7 66 66 66 66 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_402_0_0 {
	meta:
		name = "__sse2_log2"
		size = 1040
		refs = "0014 BT_Tbl 001c iExpMask 0061 dbOne 0069 dbLog2Hi 0071 iHi43Bits 008f iBias 00a7 dbLog2Lo 0107 dbZero 0138 dbP5 0140 dbP4 0150 dbP3 0158 dbP2 0168 dbP1 01b7 i00100000 01de i001fffff 0382 s_db1022xLn2Lo 038a s_db1022xLn2 03bc dwInf"
	strings:
		$1 = { 48 81 EC 88 00 00 00 0F 29 74 24 70 0F 29 7C 24 60 4C 8D 15 ?? ?? ?? ?? 66 0F 28 3D ?? ?? ?? ?? 66 0F 70 E8 B1 66 0F 28 C8 66 0F DB F8 66 0F 70 C0 5F 66 0F 7E E8 8B C8 66 0F 7E C2 25 00 F8 0F 00 81 E2 00 F8 0F 00 05 00 08 00 00 81 C2 00 08 00 00 25 00 F0 1F 00 81 E2 00 F0 1F 00 66 0F EB 3D ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F 70 C9 0D C1 E8 07 C1 EA 07 66 0F 72 D1 14 81 E9 00 00 10 00 66 0F FA 0D ?? ?? ?? ?? F3 0F E6 C9 66 0F DB DF 66 0F 5C FB 66 0F 59 D1 66 0F 59 0D ?? ?? ?? ?? F3 41 0F 7E 24 02 66 41 0F 16 24 12 81 F9 00 00 E0 7F 66 0F 7E C1 0F 83 BE 00 00 00 81 E9 00 00 10 00 81 F9 00 00 E0 7F 0F 83 AC 00 00 00 66 0F 59 DC 66 0F 59 FC 66 41 0F 28 44 02 10 66 0F 28 E8 66 41 0F 28 74 12 10 66 0F 14 C6 66 0F 15 EE 66 0F 58 C2 66 0F 28 E0 66 0F C2 05 ?? ?? ?? ?? 00 66 0F 58 E9 66 0F 5C 1D ?? ?? ?? ?? 66 0F DB C7 66 0F 58 E3 66 0F 58 E0 66 0F DF C7 66 0F 58 FB 66 0F 28 CF 66 0F 59 FF 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 59 D7 66 0F 59 F7 66 0F 58 15 ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 D7 66 0F 59 F1 66 0F 58 15 ?? ?? ?? ?? 66 0F 58 F2 66 0F 59 FE 66 0F 58 FD 66 0F 58 C7 66 0F 58 C4 E9 73 02 00 00 66 0F 70 F5 B1 66 0F 6F EE 66 0F 73 F6 20 66 0F 6F CE 66 0F 72 F6 10 66 0F 6F DD 66 0F EB F1 66 0F 29 5C 24 20 66 0F 72 D6 10 66 0F EB EE 66 0F 6F 0D ?? ?? ?? ?? 66 0F 70 ED F5 66 0F FE CD 66 0F 6F E3 66 0F 6F C1 66 0F 66 0D ?? ?? ?? ?? 66 0F 7F 6C 24 30 66 0F 66 05 ?? ?? ?? ?? 66 0F 6F 35 ?? ?? ?? ?? 66 0F 7F 4C 24 40 66 0F EF C8 66 0F 54 E0 66 0F 55 C6 66 0F 7F 4C 24 50 66 0F 54 F1 66 0F 54 CB 66 0F 56 C1 66 0F 5C C6 66 0F 56 C4 66 0F 28 3D ?? ?? ?? ?? 66 0F 70 E8 B1 66 0F 28 C8 66 0F DB F8 66 0F 70 C0 5F 66 0F 7E E8 8B C8 66 0F 7E C2 25 00 F8 0F 00 81 E2 00 F8 0F 00 05 00 08 00 00 81 C2 00 08 00 00 25 00 F0 1F 00 81 E2 00 F0 1F 00 66 0F EB 3D ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F 70 C9 0D C1 E8 07 C1 EA 07 66 0F 72 D1 14 81 E9 00 00 10 00 66 0F FA 0D ?? ?? ?? ?? F3 0F E6 C9 66 0F DB DF 66 0F 5C FB 66 0F 59 D1 66 0F 59 0D ?? ?? ?? ?? F3 41 0F 7E 24 02 66 41 0F 16 24 12 81 F9 00 00 E0 7F 66 0F 7E C1 0F 83 C0 FE FF FF 81 E9 00 00 10 00 81 F9 00 00 E0 7F 0F 83 AE FE FF FF 66 0F 59 DC 66 0F 59 FC 66 41 0F 28 44 02 10 66 0F 28 E8 66 41 0F 28 74 12 10 66 0F 14 C6 66 0F 15 EE 66 0F 58 C2 66 0F 28 E0 66 0F C2 05 ?? ?? ?? ?? 00 66 0F 58 E9 66 0F 5C 1D ?? ?? ?? ?? 66 0F DB C7 66 0F 58 E3 66 0F 58 E0 66 0F DF C7 66 0F 58 FB 66 0F 28 CF 66 0F 59 FF 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 59 D7 66 0F 59 F7 66 0F 58 15 ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 D7 66 0F 59 F1 66 0F 58 15 ?? ?? ?? ?? 66 0F 58 F2 66 0F 59 FE 66 0F 58 FD 66 0F 58 C7 66 0F 58 C4 66 0F 28 3D ?? ?? ?? ?? 66 0F 28 0D ?? ?? ?? ?? 66 0F 6F 54 24 40 66 0F 6F 5C 24 30 66 0F 6F 64 24 50 66 0F EF ED 66 0F 54 FC 66 0F 54 CC 66 0F 76 ED 66 0F 58 C7 66 0F 58 C1 66 0F 6F 25 ?? ?? ?? ?? 66 0F 54 C2 66 0F EF D5 66 0F 76 E3 66 0F EF C9 66 0F EF D4 66 0F 72 F3 01 66 0F DB 64 24 20 66 0F 76 D9 66 0F EF D3 66 0F 73 F3 34 66 0F EB D4 66 0F EB D3 66 0F 58 C2 0F 28 74 24 70 0F 28 7C 24 60 48 81 C4 88 00 00 00 C3 66 0F 1F 44 00 00 }
	condition:
		$1
}

rule file_0_0_1 {
	meta:
		name = "_Query_perf_counter"
		size = 25
		refs = "000b __imp_QueryPerformanceCounter"
	strings:
		$1 = { 48 83 EC 38 48 8D 4C 24 20 FF 15 ?? ?? ?? ?? 48 8B 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_0_1_1 {
	meta:
		name = "_Query_perf_frequency"
		size = 25
		refs = "000b __imp_QueryPerformanceFrequency"
	strings:
		$1 = { 48 83 EC 38 48 8D 4C 24 20 FF 15 ?? ?? ?? ?? 48 8B 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_0_2_1 {
	meta:
		name = "_Xtime_diff_to_millis"
		size = 72
		refs = "000c __security_cookie 0023 xtime_get 0032 _Xtime_diff_to_millis2 003f __security_check_cookie"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 48 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 30 BA 01 00 00 00 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8D 54 24 20 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 8B 4C 24 30 48 33 CC E8 ?? ?? ?? ?? 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_0_3_1 {
	meta:
		name = "_Xtime_diff_to_millis2"
		size = 136
		refs = "0013 __security_cookie 002f xtime_diff 007d __security_check_cookie"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 56 57 48 83 EC 58 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 48 4C 8B 44 24 78 48 8B 54 24 70 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8D 4C 24 38 48 8B F9 48 8B F0 B9 10 00 00 00 F3 A4 48 69 44 24 38 E8 03 00 00 48 89 44 24 20 8B 4C 24 40 81 C1 3F 42 0F 00 8B C1 99 B9 40 42 0F 00 F7 F9 48 98 48 8B 4C 24 20 48 03 C8 48 8B C1 48 8B 4C 24 48 48 33 CC E8 ?? ?? ?? ?? 48 83 C4 58 5F 5E C3 }
	condition:
		$1
}

rule file_0_4_1 {
	meta:
		name = "_Xtime_get_ticks"
		size = 47
		refs = "000a __crtGetSystemTimePreciseAsFileTime"
	strings:
		$1 = { 48 83 EC 38 48 8D 4C 24 20 E8 ?? ?? ?? ?? 8B 44 24 24 48 C1 E0 20 8B 4C 24 20 48 BA 00 80 C1 2A 21 4E 62 FE 48 03 C2 48 03 C1 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_0_5_1 {
	meta:
		name = "sys_get_time"
		size = 76
		refs = "000a _Xtime_get_ticks"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 E8 ?? ?? ?? ?? 48 89 44 24 20 33 D2 48 8B 44 24 20 B9 80 96 98 00 48 F7 F1 48 8B 4C 24 40 48 89 01 33 D2 48 8B 44 24 20 B9 80 96 98 00 48 F7 F1 48 8B C2 6B C0 64 48 8B 4C 24 40 89 41 08 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_0_6_1 {
	meta:
		name = "xtime_diff"
		size = 265
		refs = "0018 __security_cookie 003e xtime_normalize 00fe __security_check_cookie"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 56 57 48 83 EC 48 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 30 48 8D 44 24 20 48 8B F8 48 8B 74 24 68 B9 10 00 00 00 F3 A4 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 70 8B 40 08 39 44 24 28 7D 38 48 8B 44 24 70 48 8B 00 48 FF C0 48 8B 4C 24 20 48 2B C8 48 8B C1 48 89 44 24 20 48 8B 44 24 70 B9 00 CA 9A 3B 2B 48 08 8B C1 8B 4C 24 28 03 C8 8B C1 89 44 24 28 EB 2C 48 8B 44 24 70 48 8B 00 48 8B 4C 24 20 48 2B C8 48 8B C1 48 89 44 24 20 48 8B 44 24 70 8B 40 08 8B 4C 24 28 2B C8 8B C1 89 44 24 28 48 83 7C 24 20 00 7C 0F 48 83 7C 24 20 00 75 18 83 7C 24 28 00 7F 11 48 C7 44 24 20 00 00 00 00 C7 44 24 28 00 00 00 00 48 8D 44 24 20 48 8B 7C 24 60 48 8B F0 B9 10 00 00 00 F3 A4 48 8B 44 24 60 48 8B 4C 24 30 48 33 CC E8 ?? ?? ?? ?? 48 83 C4 48 5F 5E C3 }
	condition:
		$1
}

rule file_0_7_1 {
	meta:
		name = "xtime_get"
		size = 57
		refs = "002c sys_get_time"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 83 7C 24 38 01 75 08 48 83 7C 24 30 00 75 0A C7 44 24 38 00 00 00 00 EB 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_0_8_1 {
	meta:
		name = "xtime_normalize"
		size = 115
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 83 78 08 00 7D 2A 48 8B 44 24 08 48 8B 00 48 FF C8 48 8B 4C 24 08 48 89 01 48 8B 44 24 08 8B 40 08 05 00 CA 9A 3B 48 8B 4C 24 08 89 41 08 EB CB 48 8B 44 24 08 81 78 08 00 CA 9A 3B 7C 2A 48 8B 44 24 08 48 8B 00 48 FF C0 48 8B 4C 24 08 48 89 01 48 8B 44 24 08 8B 40 08 2D 00 CA 9A 3B 48 8B 4C 24 08 89 41 08 EB C8 C3 }
	condition:
		$1
}

rule file_1_0_1 {
	meta:
		name = "??$?0$$V@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@D@std@@@std@@V?$_String_val@U?$_Simple_types@D@std@@@2@$00@std@@QEAA@U_Zero_then_variadic_args_t@1@@Z"
		size = 46
		refs = "0013 ??0?$_Wrap_alloc@V?$allocator@D@std@@@std@@QEAA@XZ 0020 ??0?$_String_val@U?$_Simple_types@D@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 88 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8B C8 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_119_1_1 {
	meta:
		name = "??$?0$$V@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@G@std@@@std@@V?$_String_val@U?$_Simple_types@G@std@@@2@$00@std@@QEAA@U_Zero_then_variadic_args_t@1@@Z"
		size = 46
		refs = "0013 ??0?$_Wrap_alloc@V?$allocator@G@std@@@std@@QEAA@XZ 0020 ??0?$_String_val@U?$_Simple_types@G@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 88 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8B C8 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_41_0_1 {
	meta:
		name = "??$?0$$V@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@V?$_String_val@U?$_Simple_types@_W@std@@@2@$00@std@@QEAA@U_Zero_then_variadic_args_t@1@@Z"
		size = 46
		refs = "0013 ??0?$_Wrap_alloc@V?$allocator@_W@std@@@std@@QEAA@XZ 0020 ??0?$_String_val@U?$_Simple_types@_W@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 88 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8B C8 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_1_1 {
	meta:
		name = "??$?0U?$_Wrap_alloc@V?$allocator@D@std@@@std@@$$V@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@D@std@@@std@@V?$_String_val@U?$_Simple_types@D@std@@@2@$00@std@@QEAA@U_One_then_variadic_args_t@1@$$QEAU?$_Wrap_alloc@V?$allocator@D@std@@@1@@Z"
		size = 64
		refs = "0018 ??$forward@U?$_Wrap_alloc@V?$allocator@D@std@@@std@@@std@@YA$$QEAU?$_Wrap_alloc@V?$allocator@D@std@@@0@AEAU10@@Z 0025 ??0?$_Wrap_alloc@V?$allocator@D@std@@@std@@QEAA@$$QEAU01@@Z 0032 ??0?$_String_val@U?$_Simple_types@D@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 4C 89 44 24 18 88 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B D0 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8B C8 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_119_5_1 {
	meta:
		name = "??$?0U?$_Wrap_alloc@V?$allocator@G@std@@@std@@$$V@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@G@std@@@std@@V?$_String_val@U?$_Simple_types@G@std@@@2@$00@std@@QEAA@U_One_then_variadic_args_t@1@$$QEAU?$_Wrap_alloc@V?$allocator@G@std@@@1@@Z"
		size = 64
		refs = "0018 ??$forward@U?$_Wrap_alloc@V?$allocator@G@std@@@std@@@std@@YA$$QEAU?$_Wrap_alloc@V?$allocator@G@std@@@0@AEAU10@@Z 0025 ??0?$_Wrap_alloc@V?$allocator@G@std@@@std@@QEAA@$$QEAU01@@Z 0032 ??0?$_String_val@U?$_Simple_types@G@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 4C 89 44 24 18 88 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B D0 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8B C8 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_119_7_1 {
	meta:
		name = "??$?0U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@$$V@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@V?$_String_val@U?$_Simple_types@_W@std@@@2@$00@std@@QEAA@U_One_then_variadic_args_t@1@$$QEAU?$_Wrap_alloc@V?$allocator@_W@std@@@1@@Z"
		size = 64
		refs = "0018 ??$forward@U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@@std@@YA$$QEAU?$_Wrap_alloc@V?$allocator@_W@std@@@0@AEAU10@@Z 0025 ??0?$_Wrap_alloc@V?$allocator@_W@std@@@std@@QEAA@$$QEAU01@@Z 0032 ??0?$_String_val@U?$_Simple_types@_W@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 4C 89 44 24 18 88 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B D0 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8B C8 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_2_1 {
	meta:
		name = "??$?0U?$_Wrap_alloc@V?$allocator@D@std@@@std@@X@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAA@$$QEAU?$_Wrap_alloc@V?$allocator@D@std@@@1@@Z"
		size = 52
		refs = "0014 ??$forward@U?$_Wrap_alloc@V?$allocator@D@std@@@std@@@std@@YA$$QEAU?$_Wrap_alloc@V?$allocator@D@std@@@0@AEAU10@@Z 0026 ??$?0U?$_Wrap_alloc@V?$allocator@D@std@@@std@@$$V@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@D@std@@@std@@V?$_String_val@U?$_Simple_types@D@std@@@2@$00@std@@QEAA@U_One_then_variadic_args_t@1@$$QEAU?$_Wrap_alloc@V?$allocator@D@std@@@1@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 4C 24 48 E8 ?? ?? ?? ?? 48 8B 4C 24 40 4C 8B C0 0F B6 54 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_119_6_1 {
	meta:
		name = "??$?0U?$_Wrap_alloc@V?$allocator@G@std@@@std@@X@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QEAA@$$QEAU?$_Wrap_alloc@V?$allocator@G@std@@@1@@Z"
		size = 52
		refs = "0014 ??$forward@U?$_Wrap_alloc@V?$allocator@G@std@@@std@@@std@@YA$$QEAU?$_Wrap_alloc@V?$allocator@G@std@@@0@AEAU10@@Z 0026 ??$?0U?$_Wrap_alloc@V?$allocator@G@std@@@std@@$$V@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@G@std@@@std@@V?$_String_val@U?$_Simple_types@G@std@@@2@$00@std@@QEAA@U_One_then_variadic_args_t@1@$$QEAU?$_Wrap_alloc@V?$allocator@G@std@@@1@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 4C 24 48 E8 ?? ?? ?? ?? 48 8B 4C 24 40 4C 8B C0 0F B6 54 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_119_8_1 {
	meta:
		name = "??$?0U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@X@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QEAA@$$QEAU?$_Wrap_alloc@V?$allocator@_W@std@@@1@@Z"
		size = 52
		refs = "0014 ??$forward@U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@@std@@YA$$QEAU?$_Wrap_alloc@V?$allocator@_W@std@@@0@AEAU10@@Z 0026 ??$?0U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@$$V@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@V?$_String_val@U?$_Simple_types@_W@std@@@2@$00@std@@QEAA@U_One_then_variadic_args_t@1@$$QEAU?$_Wrap_alloc@V?$allocator@_W@std@@@1@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 4C 24 48 E8 ?? ?? ?? ?? 48 8B 4C 24 40 4C 8B C0 0F B6 54 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1_3_1 {
	meta:
		name = "??$?0V?$allocator@D@std@@@?$_Wrap_alloc@V?$allocator@D@std@@@std@@QEAA@$$QEAV?$allocator@D@1@@Z"
		size = 47
		refs = "0014 ??$forward@V?$allocator@D@std@@@std@@YA$$QEAV?$allocator@D@0@AEAV10@@Z 0021 ??0?$allocator@D@std@@QEAA@AEBV01@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B D0 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_38_1_3 {
	meta:
		name = "??$?0AEAU?$_Wrap_alloc@V?$allocator@D@std@@@std@@@?$_Wrap_alloc@V?$allocator@U_Container_proxy@std@@@std@@@std@@QEAA@AEAU?$_Wrap_alloc@V?$allocator@D@std@@@1@@Z"
		size = 47
		refs = "0014 ??$forward@AEAU?$_Wrap_alloc@V?$allocator@D@std@@@std@@@std@@YAAEAU?$_Wrap_alloc@V?$allocator@D@std@@@0@AEAU10@@Z 0021 ??$?0D@?$allocator@U_Container_proxy@std@@@std@@QEAA@AEBV?$allocator@D@1@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B D0 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_103_4_3 {
	meta:
		name = "??$?0AEAU?$_Wrap_alloc@V?$allocator@G@std@@@std@@@?$_Wrap_alloc@V?$allocator@U_Container_proxy@std@@@std@@@std@@QEAA@AEAU?$_Wrap_alloc@V?$allocator@G@std@@@1@@Z"
		size = 47
		refs = "0014 ??$forward@AEAU?$_Wrap_alloc@V?$allocator@G@std@@@std@@@std@@YAAEAU?$_Wrap_alloc@V?$allocator@G@std@@@0@AEAU10@@Z 0021 ??$?0G@?$allocator@U_Container_proxy@std@@@std@@QEAA@AEBV?$allocator@G@1@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B D0 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_104_1_3 {
	meta:
		name = "??$?0AEAU?$_Wrap_alloc@V?$allocator@_W@std@@@std@@@?$_Wrap_alloc@V?$allocator@U_Container_proxy@std@@@std@@@std@@QEAA@AEAU?$_Wrap_alloc@V?$allocator@_W@std@@@1@@Z"
		size = 47
		refs = "0014 ??$forward@AEAU?$_Wrap_alloc@V?$allocator@_W@std@@@std@@@std@@YAAEAU?$_Wrap_alloc@V?$allocator@_W@std@@@0@AEAU10@@Z 0021 ??$?0_W@?$allocator@U_Container_proxy@std@@@std@@QEAA@AEBV?$allocator@_W@1@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B D0 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_119_10_1 {
	meta:
		name = "??$?0V?$allocator@G@std@@@?$_Wrap_alloc@V?$allocator@G@std@@@std@@QEAA@$$QEAV?$allocator@G@1@@Z"
		size = 47
		refs = "0014 ??$forward@V?$allocator@G@std@@@std@@YA$$QEAV?$allocator@G@0@AEAV10@@Z 0021 ??0?$allocator@G@std@@QEAA@AEBV01@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B D0 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_119_11_1 {
	meta:
		name = "??$?0V?$allocator@_W@std@@@?$_Wrap_alloc@V?$allocator@_W@std@@@std@@QEAA@$$QEAV?$allocator@_W@1@@Z"
		size = 47
		refs = "0014 ??$forward@V?$allocator@_W@std@@@std@@YA$$QEAV?$allocator@_W@0@AEAV10@@Z 0021 ??0?$allocator@_W@std@@QEAA@AEBV01@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B D0 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_90_57_3 {
	meta:
		name = "??0?$_Wrap_alloc@V?$allocator@D@std@@@std@@QEAA@$$QEAU01@@Z"
		size = 47
		refs = "0014 ??$move@AEAU?$_Wrap_alloc@V?$allocator@D@std@@@std@@@std@@YA$$QEAU?$_Wrap_alloc@V?$allocator@D@std@@@0@AEAU10@@Z 0021 ??0?$allocator@D@std@@QEAA@AEBV01@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B D0 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_10_246_2 {
	meta:
		name = "??0?$_Wrap_alloc@V?$allocator@G@std@@@std@@QEAA@$$QEAU01@@Z"
		size = 47
		refs = "0014 ??$move@AEAU?$_Wrap_alloc@V?$allocator@G@std@@@std@@@std@@YA$$QEAU?$_Wrap_alloc@V?$allocator@G@std@@@0@AEAU10@@Z 0021 ??0?$allocator@G@std@@QEAA@AEBV01@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B D0 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_103_294_3 {
	meta:
		name = "??0?$_Wrap_alloc@V?$allocator@_W@std@@@std@@QEAA@$$QEAU01@@Z"
		size = 47
		refs = "0014 ??$move@AEAU?$_Wrap_alloc@V?$allocator@_W@std@@@std@@@std@@YA$$QEAU?$_Wrap_alloc@V?$allocator@_W@std@@@0@AEAU10@@Z 0021 ??0?$allocator@_W@std@@QEAA@AEBV01@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B D0 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_4_1 {
	meta:
		name = "??$_Fgetc@D@std@@YA_NAEADPEAU_iobuf@@@Z"
		size = 60
		refs = "0014 fgetc"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 4C 24 48 E8 ?? ?? ?? ?? 89 44 24 20 83 7C 24 20 FF 75 06 32 C0 EB 10 EB 0E 48 8B 44 24 40 0F B6 4C 24 20 88 08 B0 01 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1_5_1 {
	meta:
		name = "??$_Fputc@D@std@@YA_NDPEAU_iobuf@@@Z"
		size = 63
		refs = "001a fputc"
	strings:
		$1 = { 48 89 54 24 10 88 4C 24 08 48 83 EC 38 0F BE 44 24 40 48 8B 54 24 48 8B C8 E8 ?? ?? ?? ?? 83 F8 FF 74 0A C7 44 24 20 01 00 00 00 EB 08 C7 44 24 20 00 00 00 00 0F B6 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1_6_1 {
	meta:
		name = "??$_Immortalize@V_Iostream_error_category@std@@@std@@YAAEAV_Iostream_error_category@0@XZ"
		size = 78
		refs = "000f ??_B?1???$_Immortalize@V_Iostream_error_category@std@@@std@@YAAEAV_Iostream_error_category@0@XZ@51 002c ?_Static@?1???$_Immortalize@V_Iostream_error_category@std@@@std@@YAAEAV_Iostream_error_category@1@XZ@4U?$_Immortalizer@V_Iostream_error_category@std@@@1@A 0031 ??0?$_Immortalizer@V_Iostream_error_category@std@@@std@@QEAA@XZ 0038 ??__F_Static@?1???$_Immortalize@V_Iostream_error_category@std@@@std@@YAAEAV_Iostream_error_category@0@XZ@YAXXZ 003d atexit"
	strings:
		$1 = { 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 8B 05 ?? ?? ?? ?? 83 E0 01 85 C0 75 28 8B 05 ?? ?? ?? ?? 83 C8 01 89 05 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 48 8D 05 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_67_4_1 {
	meta:
		name = "??$_Immortalize@V_Generic_error_category@std@@@std@@YAAEAV_Generic_error_category@0@XZ"
		size = 78
		refs = "000f ??_B?1???$_Immortalize@V_Generic_error_category@std@@@std@@YAAEAV_Generic_error_category@0@XZ@51 002c ?_Static@?1???$_Immortalize@V_Generic_error_category@std@@@std@@YAAEAV_Generic_error_category@1@XZ@4U?$_Immortalizer@V_Generic_error_category@std@@@1@A 0031 ??0?$_Immortalizer@V_Generic_error_category@std@@@std@@QEAA@XZ 0038 ??__F_Static@?1???$_Immortalize@V_Generic_error_category@std@@@std@@YAAEAV_Generic_error_category@0@XZ@YAXXZ 003d atexit"
	strings:
		$1 = { 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 8B 05 ?? ?? ?? ?? 83 E0 01 85 C0 75 28 8B 05 ?? ?? ?? ?? 83 C8 01 89 05 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 48 8D 05 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_85_9_1 {
	meta:
		name = "??$_Immortalize@V_System_error_category@std@@@std@@YAAEAV_System_error_category@0@XZ"
		size = 78
		refs = "000f ??_B?1???$_Immortalize@V_System_error_category@std@@@std@@YAAEAV_System_error_category@0@XZ@51 002c ?_Static@?1???$_Immortalize@V_System_error_category@std@@@std@@YAAEAV_System_error_category@1@XZ@4U?$_Immortalizer@V_System_error_category@std@@@1@A 0031 ??0?$_Immortalizer@V_System_error_category@std@@@std@@QEAA@XZ 0038 ??__F_Static@?1???$_Immortalize@V_System_error_category@std@@@std@@YAAEAV_System_error_category@0@XZ@YAXXZ 003d atexit"
	strings:
		$1 = { 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 8B 05 ?? ?? ?? ?? 83 E0 01 85 C0 75 28 8B 05 ?? ?? ?? ?? 83 C8 01 89 05 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 48 8D 05 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1_7_1 {
	meta:
		name = "?dtor$0@?0???$_Immortalize@V_Iostream_error_category@std@@@std@@YAAEAV_Iostream_error_category@0@XZ@4HA"
		size = 22
		refs = "0007 ??_B?1???$_Immortalize@V_Iostream_error_category@std@@@std@@YAAEAV_Iostream_error_category@0@XZ@51"
	strings:
		$1 = { 40 55 48 8B EA 8B 05 ?? ?? ?? ?? 83 E0 FE 89 05 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_67_5_1 {
	meta:
		name = "?dtor$0@?0???$_Immortalize@V_Generic_error_category@std@@@std@@YAAEAV_Generic_error_category@0@XZ@4HA"
		size = 22
		refs = "0007 ??_B?1???$_Immortalize@V_Generic_error_category@std@@@std@@YAAEAV_Generic_error_category@0@XZ@51"
	strings:
		$1 = { 40 55 48 8B EA 8B 05 ?? ?? ?? ?? 83 E0 FE 89 05 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_85_10_1 {
	meta:
		name = "?dtor$0@?0???$_Immortalize@V_System_error_category@std@@@std@@YAAEAV_System_error_category@0@XZ@4HA"
		size = 22
		refs = "0007 ??_B?1???$_Immortalize@V_System_error_category@std@@@std@@YAAEAV_System_error_category@0@XZ@51"
	strings:
		$1 = { 40 55 48 8B EA 8B 05 ?? ?? ?? ?? 83 E0 FE 89 05 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_1_9_1 {
	meta:
		name = "??$_Ungetc@D@std@@YA_NAEBDPEAU_iobuf@@@Z"
		size = 67
		refs = "001e ungetc"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 0F B6 00 48 8B 54 24 48 8B C8 E8 ?? ?? ?? ?? 83 F8 FF 74 0A C7 44 24 20 01 00 00 00 EB 08 C7 44 24 20 00 00 00 00 0F B6 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1_12_1 {
	meta:
		name = "??$construct@PEADAEAPEAD@?$_Wrap_alloc@V?$allocator@D@std@@@std@@QEAAXPEAPEADAEAPEAD@Z"
		size = 52
		refs = "0019 ??$forward@AEAPEAD@std@@YAAEAPEADAEAPEAD@Z 002b ??$construct@PEADAEAPEAD@?$allocator_traits@V?$allocator@D@std@@@std@@SAXAEAV?$allocator@D@1@PEAPEADAEAPEAD@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 40 E8 ?? ?? ?? ?? 4C 8B C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_82_20_2 {
	meta:
		name = "??$construct@PEADAEAPEAD@?$allocator_traits@V?$allocator@D@std@@@std@@SAXAEAV?$allocator@D@1@PEAPEADAEAPEAD@Z"
		size = 52
		refs = "0019 ??$forward@AEAPEAD@std@@YAAEAPEADAEAPEAD@Z 002b ??$construct@PEADAEAPEAD@?$allocator@D@std@@QEAAXPEAPEADAEAPEAD@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 40 E8 ?? ?? ?? ?? 4C 8B C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_10_115_2 {
	meta:
		name = "??$construct@PEAGAEAPEAG@?$_Wrap_alloc@V?$allocator@G@std@@@std@@QEAAXPEAPEAGAEAPEAG@Z"
		size = 52
		refs = "0019 ??$forward@AEAPEAG@std@@YAAEAPEAGAEAPEAG@Z 002b ??$construct@PEAGAEAPEAG@?$allocator_traits@V?$allocator@G@std@@@std@@SAXAEAV?$allocator@G@1@PEAPEAGAEAPEAG@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 40 E8 ?? ?? ?? ?? 4C 8B C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_10_117_2 {
	meta:
		name = "??$construct@PEAGAEAPEAG@?$allocator_traits@V?$allocator@G@std@@@std@@SAXAEAV?$allocator@G@1@PEAPEAGAEAPEAG@Z"
		size = 52
		refs = "0019 ??$forward@AEAPEAG@std@@YAAEAPEAGAEAPEAG@Z 002b ??$construct@PEAGAEAPEAG@?$allocator@G@std@@QEAAXPEAPEAGAEAPEAG@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 40 E8 ?? ?? ?? ?? 4C 8B C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_99_7_2 {
	meta:
		name = "??$construct@PEA_WAEAPEA_W@?$_Wrap_alloc@V?$allocator@_W@std@@@std@@QEAAXPEAPEA_WAEAPEA_W@Z"
		size = 52
		refs = "0019 ??$forward@AEAPEA_W@std@@YAAEAPEA_WAEAPEA_W@Z 002b ??$construct@PEA_WAEAPEA_W@?$allocator_traits@V?$allocator@_W@std@@@std@@SAXAEAV?$allocator@_W@1@PEAPEA_WAEAPEA_W@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 40 E8 ?? ?? ?? ?? 4C 8B C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_104_9_3 {
	meta:
		name = "??$construct@PEA_WAEAPEA_W@?$allocator_traits@V?$allocator@_W@std@@@std@@SAXAEAV?$allocator@_W@1@PEAPEA_WAEAPEA_W@Z"
		size = 52
		refs = "0019 ??$forward@AEAPEA_W@std@@YAAEAPEA_WAEAPEA_W@Z 002b ??$construct@PEA_WAEAPEA_W@?$allocator@_W@std@@QEAAXPEAPEA_WAEAPEA_W@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 40 E8 ?? ?? ?? ?? 4C 8B C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_24_41_3 {
	meta:
		name = "??$construct@U_Container_proxy@std@@U12@@?$_Wrap_alloc@V?$allocator@U_Container_proxy@std@@@std@@@std@@QEAAXPEAU_Container_proxy@1@$$QEAU21@@Z"
		size = 52
		refs = "0019 ??$forward@U_Container_proxy@std@@@std@@YA$$QEAU_Container_proxy@0@AEAU10@@Z 002b ??$construct@U_Container_proxy@std@@U12@@?$allocator_traits@V?$allocator@U_Container_proxy@std@@@std@@@std@@SAXAEAV?$allocator@U_Container_proxy@std@@@1@PEAU_Container_proxy@1@$$QEAU31@@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 40 E8 ?? ?? ?? ?? 4C 8B C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_93_43_3 {
	meta:
		name = "??$construct@U_Container_proxy@std@@U12@@?$allocator_traits@V?$allocator@U_Container_proxy@std@@@std@@@std@@SAXAEAV?$allocator@U_Container_proxy@std@@@1@PEAU_Container_proxy@1@$$QEAU31@@Z"
		size = 52
		refs = "0019 ??$forward@U_Container_proxy@std@@@std@@YA$$QEAU_Container_proxy@0@AEAU10@@Z 002b ??$construct@U_Container_proxy@std@@U12@@?$allocator@U_Container_proxy@std@@@std@@QEAAXPEAU_Container_proxy@1@$$QEAU21@@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 40 E8 ?? ?? ?? ?? 4C 8B C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_13_1 {
	meta:
		name = "??$construct@PEADAEAPEAD@?$allocator@D@std@@QEAAXPEAPEADAEAPEAD@Z"
		size = 94
		refs = "001e ??2@YAPEAX_KPEAX@Z 0035 ??$forward@AEAPEAD@std@@YAAEAPEADAEAPEAD@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 54 24 48 B9 08 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 20 48 83 7C 24 20 00 74 21 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 8B 4C 24 20 48 8B 00 48 89 01 48 8B 44 24 20 48 89 44 24 28 EB 09 48 C7 44 24 28 00 00 00 00 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_119_91_1 {
	meta:
		name = "??$construct@PEAGAEAPEAG@?$allocator@G@std@@QEAAXPEAPEAGAEAPEAG@Z"
		size = 94
		refs = "001e ??2@YAPEAX_KPEAX@Z 0035 ??$forward@AEAPEAG@std@@YAAEAPEAGAEAPEAG@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 54 24 48 B9 08 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 20 48 83 7C 24 20 00 74 21 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 8B 4C 24 20 48 8B 00 48 89 01 48 8B 44 24 20 48 89 44 24 28 EB 09 48 C7 44 24 28 00 00 00 00 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_41_5_1 {
	meta:
		name = "??$construct@PEA_WAEAPEA_W@?$allocator@_W@std@@QEAAXPEAPEA_WAEAPEA_W@Z"
		size = 94
		refs = "001e ??2@YAPEAX_KPEAX@Z 0035 ??$forward@AEAPEA_W@std@@YAAEAPEA_WAEAPEA_W@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 54 24 48 B9 08 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 20 48 83 7C 24 20 00 74 21 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 8B 4C 24 20 48 8B 00 48 89 01 48 8B 44 24 20 48 89 44 24 28 EB 09 48 C7 44 24 28 00 00 00 00 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1_23_1 {
	meta:
		name = "??$use_facet@V?$codecvt@DDU_Mbstatet@@@std@@@std@@YAAEBV?$codecvt@DDU_Mbstatet@@@0@AEBVlocale@0@@Z"
		size = 287
		refs = "001d ??0_Lockit@std@@QEAA@H@Z 0025 ?_Psave@?$_Facetptr@V?$codecvt@DDU_Mbstatet@@@std@@@std@@2PEBVfacet@locale@2@EB 0031 ?id@?$codecvt@DDU_Mbstatet@@@std@@2V0locale@2@A 0036 ??Bid@locale@std@@QEAA_KXZ 004d ?_Getfacet@locale@std@@QEBAPEBVfacet@12@_K@Z 0088 ?_Getcat@?$codecvt@DDU_Mbstatet@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 0098 ??0bad_cast@std@@QEAA@XZ 009f _TI2?AVbad_cast@std@@ 00a9 _CxxThrowException 00e7 _guard_check_icall 00fa ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z 010e ??1_Lockit@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 81 EC 88 00 00 00 48 C7 44 24 58 FE FF FF FF 33 D2 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 05 ?? ?? ?? ?? 48 89 44 24 20 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 44 24 48 48 8B 54 24 48 48 8B 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 28 48 83 7C 24 28 00 74 05 E9 9B 00 00 00 48 83 7C 24 20 00 74 0F 48 8B 44 24 20 48 89 44 24 28 E9 84 00 00 00 48 8B 94 24 90 00 00 00 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1E 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 90 EB 4E 48 8B 44 24 20 48 89 44 24 28 48 8B 44 24 20 48 89 05 ?? ?? ?? ?? 48 8B 44 24 20 48 89 44 24 38 48 8B 44 24 38 48 8B 00 48 8B 40 08 48 89 44 24 40 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 4C 24 38 FF 54 24 40 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B 44 24 28 48 89 44 24 50 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 81 C4 88 00 00 00 C3 }
	condition:
		$1
}

rule file_40_37_2 {
	meta:
		name = "??$use_facet@V?$codecvt@GDU_Mbstatet@@@std@@@std@@YAAEBV?$codecvt@GDU_Mbstatet@@@0@AEBVlocale@0@@Z"
		size = 287
		refs = "001d ??0_Lockit@std@@QEAA@H@Z 0025 ?_Psave@?$_Facetptr@V?$codecvt@GDU_Mbstatet@@@std@@@std@@2PEBVfacet@locale@2@EB 0031 ?id@?$codecvt@GDU_Mbstatet@@@std@@2V0locale@2@A 0036 ??Bid@locale@std@@QEAA_KXZ 004d ?_Getfacet@locale@std@@QEBAPEBVfacet@12@_K@Z 0088 ?_Getcat@?$codecvt@GDU_Mbstatet@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 0098 ??0bad_cast@std@@QEAA@XZ 009f _TI2?AVbad_cast@std@@ 00a9 _CxxThrowException 00e7 _guard_check_icall 00fa ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z 010e ??1_Lockit@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 81 EC 88 00 00 00 48 C7 44 24 58 FE FF FF FF 33 D2 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 05 ?? ?? ?? ?? 48 89 44 24 20 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 44 24 48 48 8B 54 24 48 48 8B 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 28 48 83 7C 24 28 00 74 05 E9 9B 00 00 00 48 83 7C 24 20 00 74 0F 48 8B 44 24 20 48 89 44 24 28 E9 84 00 00 00 48 8B 94 24 90 00 00 00 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1E 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 90 EB 4E 48 8B 44 24 20 48 89 44 24 28 48 8B 44 24 20 48 89 05 ?? ?? ?? ?? 48 8B 44 24 20 48 89 44 24 38 48 8B 44 24 38 48 8B 00 48 8B 40 08 48 89 44 24 40 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 4C 24 38 FF 54 24 40 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B 44 24 28 48 89 44 24 50 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 81 C4 88 00 00 00 C3 }
	condition:
		$1
}

rule file_10_158_2 {
	meta:
		name = "??$use_facet@V?$codecvt@_WDU_Mbstatet@@@std@@@std@@YAAEBV?$codecvt@_WDU_Mbstatet@@@0@AEBVlocale@0@@Z"
		size = 287
		refs = "001d ??0_Lockit@std@@QEAA@H@Z 0025 ?_Psave@?$_Facetptr@V?$codecvt@_WDU_Mbstatet@@@std@@@std@@2PEBVfacet@locale@2@EB 0031 ?id@?$codecvt@_WDU_Mbstatet@@@std@@2V0locale@2@A 0036 ??Bid@locale@std@@QEAA_KXZ 004d ?_Getfacet@locale@std@@QEBAPEBVfacet@12@_K@Z 0088 ?_Getcat@?$codecvt@_WDU_Mbstatet@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 0098 ??0bad_cast@std@@QEAA@XZ 009f _TI2?AVbad_cast@std@@ 00a9 _CxxThrowException 00e7 _guard_check_icall 00fa ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z 010e ??1_Lockit@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 81 EC 88 00 00 00 48 C7 44 24 58 FE FF FF FF 33 D2 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 05 ?? ?? ?? ?? 48 89 44 24 20 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 44 24 48 48 8B 54 24 48 48 8B 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 28 48 83 7C 24 28 00 74 05 E9 9B 00 00 00 48 83 7C 24 20 00 74 0F 48 8B 44 24 20 48 89 44 24 28 E9 84 00 00 00 48 8B 94 24 90 00 00 00 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1E 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 90 EB 4E 48 8B 44 24 20 48 89 44 24 28 48 8B 44 24 20 48 89 05 ?? ?? ?? ?? 48 8B 44 24 20 48 89 44 24 38 48 8B 44 24 38 48 8B 00 48 8B 40 08 48 89 44 24 40 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 4C 24 38 FF 54 24 40 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B 44 24 28 48 89 44 24 50 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 81 C4 88 00 00 00 C3 }
	condition:
		$1
}

rule file_89_68_2 {
	meta:
		name = "??$use_facet@V?$collate@D@std@@@std@@YAAEBV?$collate@D@0@AEBVlocale@0@@Z"
		size = 287
		refs = "001d ??0_Lockit@std@@QEAA@H@Z 0025 ?_Psave@?$_Facetptr@V?$collate@D@std@@@std@@2PEBVfacet@locale@2@EB 0031 ?id@?$collate@D@std@@2V0locale@2@A 0036 ??Bid@locale@std@@QEAA_KXZ 004d ?_Getfacet@locale@std@@QEBAPEBVfacet@12@_K@Z 0088 ?_Getcat@?$collate@D@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 0098 ??0bad_cast@std@@QEAA@XZ 009f _TI2?AVbad_cast@std@@ 00a9 _CxxThrowException 00e7 _guard_check_icall 00fa ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z 010e ??1_Lockit@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 81 EC 88 00 00 00 48 C7 44 24 58 FE FF FF FF 33 D2 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 05 ?? ?? ?? ?? 48 89 44 24 20 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 44 24 48 48 8B 54 24 48 48 8B 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 28 48 83 7C 24 28 00 74 05 E9 9B 00 00 00 48 83 7C 24 20 00 74 0F 48 8B 44 24 20 48 89 44 24 28 E9 84 00 00 00 48 8B 94 24 90 00 00 00 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1E 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 90 EB 4E 48 8B 44 24 20 48 89 44 24 28 48 8B 44 24 20 48 89 05 ?? ?? ?? ?? 48 8B 44 24 20 48 89 44 24 38 48 8B 44 24 38 48 8B 00 48 8B 40 08 48 89 44 24 40 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 4C 24 38 FF 54 24 40 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B 44 24 28 48 89 44 24 50 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 81 C4 88 00 00 00 C3 }
	condition:
		$1
}

rule file_119_125_1 {
	meta:
		name = "??$use_facet@V?$collate@G@std@@@std@@YAAEBV?$collate@G@0@AEBVlocale@0@@Z"
		size = 287
		refs = "001d ??0_Lockit@std@@QEAA@H@Z 0025 ?_Psave@?$_Facetptr@V?$collate@G@std@@@std@@2PEBVfacet@locale@2@EB 0031 ?id@?$collate@G@std@@2V0locale@2@A 0036 ??Bid@locale@std@@QEAA_KXZ 004d ?_Getfacet@locale@std@@QEBAPEBVfacet@12@_K@Z 0088 ?_Getcat@?$collate@G@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 0098 ??0bad_cast@std@@QEAA@XZ 009f _TI2?AVbad_cast@std@@ 00a9 _CxxThrowException 00e7 _guard_check_icall 00fa ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z 010e ??1_Lockit@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 81 EC 88 00 00 00 48 C7 44 24 58 FE FF FF FF 33 D2 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 05 ?? ?? ?? ?? 48 89 44 24 20 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 44 24 48 48 8B 54 24 48 48 8B 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 28 48 83 7C 24 28 00 74 05 E9 9B 00 00 00 48 83 7C 24 20 00 74 0F 48 8B 44 24 20 48 89 44 24 28 E9 84 00 00 00 48 8B 94 24 90 00 00 00 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1E 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 90 EB 4E 48 8B 44 24 20 48 89 44 24 28 48 8B 44 24 20 48 89 05 ?? ?? ?? ?? 48 8B 44 24 20 48 89 44 24 38 48 8B 44 24 38 48 8B 00 48 8B 40 08 48 89 44 24 40 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 4C 24 38 FF 54 24 40 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B 44 24 28 48 89 44 24 50 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 81 C4 88 00 00 00 C3 }
	condition:
		$1
}

rule file_119_127_1 {
	meta:
		name = "??$use_facet@V?$collate@_W@std@@@std@@YAAEBV?$collate@_W@0@AEBVlocale@0@@Z"
		size = 287
		refs = "001d ??0_Lockit@std@@QEAA@H@Z 0025 ?_Psave@?$_Facetptr@V?$collate@_W@std@@@std@@2PEBVfacet@locale@2@EB 0031 ?id@?$collate@_W@std@@2V0locale@2@A 0036 ??Bid@locale@std@@QEAA_KXZ 004d ?_Getfacet@locale@std@@QEBAPEBVfacet@12@_K@Z 0088 ?_Getcat@?$collate@_W@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 0098 ??0bad_cast@std@@QEAA@XZ 009f _TI2?AVbad_cast@std@@ 00a9 _CxxThrowException 00e7 _guard_check_icall 00fa ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z 010e ??1_Lockit@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 81 EC 88 00 00 00 48 C7 44 24 58 FE FF FF FF 33 D2 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 05 ?? ?? ?? ?? 48 89 44 24 20 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 44 24 48 48 8B 54 24 48 48 8B 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 28 48 83 7C 24 28 00 74 05 E9 9B 00 00 00 48 83 7C 24 20 00 74 0F 48 8B 44 24 20 48 89 44 24 28 E9 84 00 00 00 48 8B 94 24 90 00 00 00 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1E 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 90 EB 4E 48 8B 44 24 20 48 89 44 24 28 48 8B 44 24 20 48 89 05 ?? ?? ?? ?? 48 8B 44 24 20 48 89 44 24 38 48 8B 44 24 38 48 8B 00 48 8B 40 08 48 89 44 24 40 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 4C 24 38 FF 54 24 40 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B 44 24 28 48 89 44 24 50 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 81 C4 88 00 00 00 C3 }
	condition:
		$1
}

rule file_96_39_2 {
	meta:
		name = "??$use_facet@V?$ctype@D@std@@@std@@YAAEBV?$ctype@D@0@AEBVlocale@0@@Z"
		size = 287
		refs = "001d ??0_Lockit@std@@QEAA@H@Z 0025 ?_Psave@?$_Facetptr@V?$ctype@D@std@@@std@@2PEBVfacet@locale@2@EB 0031 ?id@?$ctype@D@std@@2V0locale@2@A 0036 ??Bid@locale@std@@QEAA_KXZ 004d ?_Getfacet@locale@std@@QEBAPEBVfacet@12@_K@Z 0088 ?_Getcat@?$ctype@D@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 0098 ??0bad_cast@std@@QEAA@XZ 009f _TI2?AVbad_cast@std@@ 00a9 _CxxThrowException 00e7 _guard_check_icall 00fa ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z 010e ??1_Lockit@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 81 EC 88 00 00 00 48 C7 44 24 58 FE FF FF FF 33 D2 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 05 ?? ?? ?? ?? 48 89 44 24 20 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 44 24 48 48 8B 54 24 48 48 8B 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 28 48 83 7C 24 28 00 74 05 E9 9B 00 00 00 48 83 7C 24 20 00 74 0F 48 8B 44 24 20 48 89 44 24 28 E9 84 00 00 00 48 8B 94 24 90 00 00 00 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1E 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 90 EB 4E 48 8B 44 24 20 48 89 44 24 28 48 8B 44 24 20 48 89 05 ?? ?? ?? ?? 48 8B 44 24 20 48 89 44 24 38 48 8B 44 24 38 48 8B 00 48 8B 40 08 48 89 44 24 40 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 4C 24 38 FF 54 24 40 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B 44 24 28 48 89 44 24 50 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 81 C4 88 00 00 00 C3 }
	condition:
		$1
}

rule file_41_39_2 {
	meta:
		name = "??$use_facet@V?$ctype@G@std@@@std@@YAAEBV?$ctype@G@0@AEBVlocale@0@@Z"
		size = 287
		refs = "001d ??0_Lockit@std@@QEAA@H@Z 0025 ?_Psave@?$_Facetptr@V?$ctype@G@std@@@std@@2PEBVfacet@locale@2@EB 0031 ?id@?$ctype@G@std@@2V0locale@2@A 0036 ??Bid@locale@std@@QEAA_KXZ 004d ?_Getfacet@locale@std@@QEBAPEBVfacet@12@_K@Z 0088 ?_Getcat@?$ctype@G@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 0098 ??0bad_cast@std@@QEAA@XZ 009f _TI2?AVbad_cast@std@@ 00a9 _CxxThrowException 00e7 _guard_check_icall 00fa ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z 010e ??1_Lockit@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 81 EC 88 00 00 00 48 C7 44 24 58 FE FF FF FF 33 D2 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 05 ?? ?? ?? ?? 48 89 44 24 20 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 44 24 48 48 8B 54 24 48 48 8B 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 28 48 83 7C 24 28 00 74 05 E9 9B 00 00 00 48 83 7C 24 20 00 74 0F 48 8B 44 24 20 48 89 44 24 28 E9 84 00 00 00 48 8B 94 24 90 00 00 00 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1E 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 90 EB 4E 48 8B 44 24 20 48 89 44 24 28 48 8B 44 24 20 48 89 05 ?? ?? ?? ?? 48 8B 44 24 20 48 89 44 24 38 48 8B 44 24 38 48 8B 00 48 8B 40 08 48 89 44 24 40 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 4C 24 38 FF 54 24 40 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B 44 24 28 48 89 44 24 50 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 81 C4 88 00 00 00 C3 }
	condition:
		$1
}

rule file_88_39_2 {
	meta:
		name = "??$use_facet@V?$ctype@_W@std@@@std@@YAAEBV?$ctype@_W@0@AEBVlocale@0@@Z"
		size = 287
		refs = "001d ??0_Lockit@std@@QEAA@H@Z 0025 ?_Psave@?$_Facetptr@V?$ctype@_W@std@@@std@@2PEBVfacet@locale@2@EB 0031 ?id@?$ctype@_W@std@@2V0locale@2@A 0036 ??Bid@locale@std@@QEAA_KXZ 004d ?_Getfacet@locale@std@@QEBAPEBVfacet@12@_K@Z 0088 ?_Getcat@?$ctype@_W@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 0098 ??0bad_cast@std@@QEAA@XZ 009f _TI2?AVbad_cast@std@@ 00a9 _CxxThrowException 00e7 _guard_check_icall 00fa ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z 010e ??1_Lockit@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 81 EC 88 00 00 00 48 C7 44 24 58 FE FF FF FF 33 D2 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 05 ?? ?? ?? ?? 48 89 44 24 20 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 44 24 48 48 8B 54 24 48 48 8B 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 28 48 83 7C 24 28 00 74 05 E9 9B 00 00 00 48 83 7C 24 20 00 74 0F 48 8B 44 24 20 48 89 44 24 28 E9 84 00 00 00 48 8B 94 24 90 00 00 00 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1E 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 90 EB 4E 48 8B 44 24 20 48 89 44 24 28 48 8B 44 24 20 48 89 05 ?? ?? ?? ?? 48 8B 44 24 20 48 89 44 24 38 48 8B 44 24 38 48 8B 00 48 8B 40 08 48 89 44 24 40 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 4C 24 38 FF 54 24 40 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B 44 24 28 48 89 44 24 50 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 81 C4 88 00 00 00 C3 }
	condition:
		$1
}

rule file_38_86_3 {
	meta:
		name = "??$use_facet@V?$messages@D@std@@@std@@YAAEBV?$messages@D@0@AEBVlocale@0@@Z"
		size = 287
		refs = "001d ??0_Lockit@std@@QEAA@H@Z 0025 ?_Psave@?$_Facetptr@V?$messages@D@std@@@std@@2PEBVfacet@locale@2@EB 0031 ?id@?$messages@D@std@@2V0locale@2@A 0036 ??Bid@locale@std@@QEAA_KXZ 004d ?_Getfacet@locale@std@@QEBAPEBVfacet@12@_K@Z 0088 ?_Getcat@?$messages@D@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 0098 ??0bad_cast@std@@QEAA@XZ 009f _TI2?AVbad_cast@std@@ 00a9 _CxxThrowException 00e7 _guard_check_icall 00fa ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z 010e ??1_Lockit@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 81 EC 88 00 00 00 48 C7 44 24 58 FE FF FF FF 33 D2 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 05 ?? ?? ?? ?? 48 89 44 24 20 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 44 24 48 48 8B 54 24 48 48 8B 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 28 48 83 7C 24 28 00 74 05 E9 9B 00 00 00 48 83 7C 24 20 00 74 0F 48 8B 44 24 20 48 89 44 24 28 E9 84 00 00 00 48 8B 94 24 90 00 00 00 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1E 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 90 EB 4E 48 8B 44 24 20 48 89 44 24 28 48 8B 44 24 20 48 89 05 ?? ?? ?? ?? 48 8B 44 24 20 48 89 44 24 38 48 8B 44 24 38 48 8B 00 48 8B 40 08 48 89 44 24 40 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 4C 24 38 FF 54 24 40 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B 44 24 28 48 89 44 24 50 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 81 C4 88 00 00 00 C3 }
	condition:
		$1
}

rule file_10_168_2 {
	meta:
		name = "??$use_facet@V?$messages@G@std@@@std@@YAAEBV?$messages@G@0@AEBVlocale@0@@Z"
		size = 287
		refs = "001d ??0_Lockit@std@@QEAA@H@Z 0025 ?_Psave@?$_Facetptr@V?$messages@G@std@@@std@@2PEBVfacet@locale@2@EB 0031 ?id@?$messages@G@std@@2V0locale@2@A 0036 ??Bid@locale@std@@QEAA_KXZ 004d ?_Getfacet@locale@std@@QEBAPEBVfacet@12@_K@Z 0088 ?_Getcat@?$messages@G@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 0098 ??0bad_cast@std@@QEAA@XZ 009f _TI2?AVbad_cast@std@@ 00a9 _CxxThrowException 00e7 _guard_check_icall 00fa ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z 010e ??1_Lockit@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 81 EC 88 00 00 00 48 C7 44 24 58 FE FF FF FF 33 D2 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 05 ?? ?? ?? ?? 48 89 44 24 20 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 44 24 48 48 8B 54 24 48 48 8B 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 28 48 83 7C 24 28 00 74 05 E9 9B 00 00 00 48 83 7C 24 20 00 74 0F 48 8B 44 24 20 48 89 44 24 28 E9 84 00 00 00 48 8B 94 24 90 00 00 00 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1E 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 90 EB 4E 48 8B 44 24 20 48 89 44 24 28 48 8B 44 24 20 48 89 05 ?? ?? ?? ?? 48 8B 44 24 20 48 89 44 24 38 48 8B 44 24 38 48 8B 00 48 8B 40 08 48 89 44 24 40 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 4C 24 38 FF 54 24 40 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B 44 24 28 48 89 44 24 50 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 81 C4 88 00 00 00 C3 }
	condition:
		$1
}

rule file_119_135_1 {
	meta:
		name = "??$use_facet@V?$messages@_W@std@@@std@@YAAEBV?$messages@_W@0@AEBVlocale@0@@Z"
		size = 287
		refs = "001d ??0_Lockit@std@@QEAA@H@Z 0025 ?_Psave@?$_Facetptr@V?$messages@_W@std@@@std@@2PEBVfacet@locale@2@EB 0031 ?id@?$messages@_W@std@@2V0locale@2@A 0036 ??Bid@locale@std@@QEAA_KXZ 004d ?_Getfacet@locale@std@@QEBAPEBVfacet@12@_K@Z 0088 ?_Getcat@?$messages@_W@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 0098 ??0bad_cast@std@@QEAA@XZ 009f _TI2?AVbad_cast@std@@ 00a9 _CxxThrowException 00e7 _guard_check_icall 00fa ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z 010e ??1_Lockit@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 81 EC 88 00 00 00 48 C7 44 24 58 FE FF FF FF 33 D2 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 05 ?? ?? ?? ?? 48 89 44 24 20 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 44 24 48 48 8B 54 24 48 48 8B 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 28 48 83 7C 24 28 00 74 05 E9 9B 00 00 00 48 83 7C 24 20 00 74 0F 48 8B 44 24 20 48 89 44 24 28 E9 84 00 00 00 48 8B 94 24 90 00 00 00 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1E 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 90 EB 4E 48 8B 44 24 20 48 89 44 24 28 48 8B 44 24 20 48 89 05 ?? ?? ?? ?? 48 8B 44 24 20 48 89 44 24 38 48 8B 44 24 38 48 8B 00 48 8B 40 08 48 89 44 24 40 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 4C 24 38 FF 54 24 40 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B 44 24 28 48 89 44 24 50 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 81 C4 88 00 00 00 C3 }
	condition:
		$1
}

rule file_115_54_1 {
	meta:
		name = "??$use_facet@V?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAAEBV?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@AEBVlocale@0@@Z"
		size = 287
		refs = "001d ??0_Lockit@std@@QEAA@H@Z 0025 ?_Psave@?$_Facetptr@V?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@2PEBVfacet@locale@2@EB 0031 ?id@?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A 0036 ??Bid@locale@std@@QEAA_KXZ 004d ?_Getfacet@locale@std@@QEBAPEBVfacet@12@_K@Z 0088 ?_Getcat@?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 0098 ??0bad_cast@std@@QEAA@XZ 009f _TI2?AVbad_cast@std@@ 00a9 _CxxThrowException 00e7 _guard_check_icall 00fa ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z 010e ??1_Lockit@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 81 EC 88 00 00 00 48 C7 44 24 58 FE FF FF FF 33 D2 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 05 ?? ?? ?? ?? 48 89 44 24 20 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 44 24 48 48 8B 54 24 48 48 8B 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 28 48 83 7C 24 28 00 74 05 E9 9B 00 00 00 48 83 7C 24 20 00 74 0F 48 8B 44 24 20 48 89 44 24 28 E9 84 00 00 00 48 8B 94 24 90 00 00 00 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1E 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 90 EB 4E 48 8B 44 24 20 48 89 44 24 28 48 8B 44 24 20 48 89 05 ?? ?? ?? ?? 48 8B 44 24 20 48 89 44 24 38 48 8B 44 24 38 48 8B 00 48 8B 40 08 48 89 44 24 40 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 4C 24 38 FF 54 24 40 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B 44 24 28 48 89 44 24 50 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 81 C4 88 00 00 00 C3 }
	condition:
		$1
}

rule file_119_137_1 {
	meta:
		name = "??$use_facet@V?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAAEBV?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@AEBVlocale@0@@Z"
		size = 287
		refs = "001d ??0_Lockit@std@@QEAA@H@Z 0025 ?_Psave@?$_Facetptr@V?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@2PEBVfacet@locale@2@EB 0031 ?id@?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A 0036 ??Bid@locale@std@@QEAA_KXZ 004d ?_Getfacet@locale@std@@QEBAPEBVfacet@12@_K@Z 0088 ?_Getcat@?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 0098 ??0bad_cast@std@@QEAA@XZ 009f _TI2?AVbad_cast@std@@ 00a9 _CxxThrowException 00e7 _guard_check_icall 00fa ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z 010e ??1_Lockit@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 81 EC 88 00 00 00 48 C7 44 24 58 FE FF FF FF 33 D2 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 05 ?? ?? ?? ?? 48 89 44 24 20 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 44 24 48 48 8B 54 24 48 48 8B 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 28 48 83 7C 24 28 00 74 05 E9 9B 00 00 00 48 83 7C 24 20 00 74 0F 48 8B 44 24 20 48 89 44 24 28 E9 84 00 00 00 48 8B 94 24 90 00 00 00 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1E 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 90 EB 4E 48 8B 44 24 20 48 89 44 24 28 48 8B 44 24 20 48 89 05 ?? ?? ?? ?? 48 8B 44 24 20 48 89 44 24 38 48 8B 44 24 38 48 8B 00 48 8B 40 08 48 89 44 24 40 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 4C 24 38 FF 54 24 40 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B 44 24 28 48 89 44 24 50 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 81 C4 88 00 00 00 C3 }
	condition:
		$1
}

rule file_103_220_3 {
	meta:
		name = "??$use_facet@V?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAAEBV?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@AEBVlocale@0@@Z"
		size = 287
		refs = "001d ??0_Lockit@std@@QEAA@H@Z 0025 ?_Psave@?$_Facetptr@V?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@2PEBVfacet@locale@2@EB 0031 ?id@?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A 0036 ??Bid@locale@std@@QEAA_KXZ 004d ?_Getfacet@locale@std@@QEBAPEBVfacet@12@_K@Z 0088 ?_Getcat@?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 0098 ??0bad_cast@std@@QEAA@XZ 009f _TI2?AVbad_cast@std@@ 00a9 _CxxThrowException 00e7 _guard_check_icall 00fa ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z 010e ??1_Lockit@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 81 EC 88 00 00 00 48 C7 44 24 58 FE FF FF FF 33 D2 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 05 ?? ?? ?? ?? 48 89 44 24 20 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 44 24 48 48 8B 54 24 48 48 8B 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 28 48 83 7C 24 28 00 74 05 E9 9B 00 00 00 48 83 7C 24 20 00 74 0F 48 8B 44 24 20 48 89 44 24 28 E9 84 00 00 00 48 8B 94 24 90 00 00 00 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1E 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 90 EB 4E 48 8B 44 24 20 48 89 44 24 28 48 8B 44 24 20 48 89 05 ?? ?? ?? ?? 48 8B 44 24 20 48 89 44 24 38 48 8B 44 24 38 48 8B 00 48 8B 40 08 48 89 44 24 40 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 4C 24 38 FF 54 24 40 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B 44 24 28 48 89 44 24 50 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 81 C4 88 00 00 00 C3 }
	condition:
		$1
}

rule file_115_56_1 {
	meta:
		name = "??$use_facet@V?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAAEBV?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@AEBVlocale@0@@Z"
		size = 287
		refs = "001d ??0_Lockit@std@@QEAA@H@Z 0025 ?_Psave@?$_Facetptr@V?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@2PEBVfacet@locale@2@EB 0031 ?id@?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A 0036 ??Bid@locale@std@@QEAA_KXZ 004d ?_Getfacet@locale@std@@QEBAPEBVfacet@12@_K@Z 0088 ?_Getcat@?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 0098 ??0bad_cast@std@@QEAA@XZ 009f _TI2?AVbad_cast@std@@ 00a9 _CxxThrowException 00e7 _guard_check_icall 00fa ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z 010e ??1_Lockit@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 81 EC 88 00 00 00 48 C7 44 24 58 FE FF FF FF 33 D2 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 05 ?? ?? ?? ?? 48 89 44 24 20 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 44 24 48 48 8B 54 24 48 48 8B 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 28 48 83 7C 24 28 00 74 05 E9 9B 00 00 00 48 83 7C 24 20 00 74 0F 48 8B 44 24 20 48 89 44 24 28 E9 84 00 00 00 48 8B 94 24 90 00 00 00 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1E 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 90 EB 4E 48 8B 44 24 20 48 89 44 24 28 48 8B 44 24 20 48 89 05 ?? ?? ?? ?? 48 8B 44 24 20 48 89 44 24 38 48 8B 44 24 38 48 8B 00 48 8B 40 08 48 89 44 24 40 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 4C 24 38 FF 54 24 40 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B 44 24 28 48 89 44 24 50 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 81 C4 88 00 00 00 C3 }
	condition:
		$1
}

rule file_10_176_2 {
	meta:
		name = "??$use_facet@V?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAAEBV?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@AEBVlocale@0@@Z"
		size = 287
		refs = "001d ??0_Lockit@std@@QEAA@H@Z 0025 ?_Psave@?$_Facetptr@V?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@2PEBVfacet@locale@2@EB 0031 ?id@?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A 0036 ??Bid@locale@std@@QEAA_KXZ 004d ?_Getfacet@locale@std@@QEBAPEBVfacet@12@_K@Z 0088 ?_Getcat@?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 0098 ??0bad_cast@std@@QEAA@XZ 009f _TI2?AVbad_cast@std@@ 00a9 _CxxThrowException 00e7 _guard_check_icall 00fa ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z 010e ??1_Lockit@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 81 EC 88 00 00 00 48 C7 44 24 58 FE FF FF FF 33 D2 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 05 ?? ?? ?? ?? 48 89 44 24 20 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 44 24 48 48 8B 54 24 48 48 8B 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 28 48 83 7C 24 28 00 74 05 E9 9B 00 00 00 48 83 7C 24 20 00 74 0F 48 8B 44 24 20 48 89 44 24 28 E9 84 00 00 00 48 8B 94 24 90 00 00 00 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1E 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 90 EB 4E 48 8B 44 24 20 48 89 44 24 28 48 8B 44 24 20 48 89 05 ?? ?? ?? ?? 48 8B 44 24 20 48 89 44 24 38 48 8B 44 24 38 48 8B 00 48 8B 40 08 48 89 44 24 40 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 4C 24 38 FF 54 24 40 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B 44 24 28 48 89 44 24 50 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 81 C4 88 00 00 00 C3 }
	condition:
		$1
}

rule file_119_143_1 {
	meta:
		name = "??$use_facet@V?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAAEBV?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@AEBVlocale@0@@Z"
		size = 287
		refs = "001d ??0_Lockit@std@@QEAA@H@Z 0025 ?_Psave@?$_Facetptr@V?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@2PEBVfacet@locale@2@EB 0031 ?id@?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A 0036 ??Bid@locale@std@@QEAA_KXZ 004d ?_Getfacet@locale@std@@QEBAPEBVfacet@12@_K@Z 0088 ?_Getcat@?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 0098 ??0bad_cast@std@@QEAA@XZ 009f _TI2?AVbad_cast@std@@ 00a9 _CxxThrowException 00e7 _guard_check_icall 00fa ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z 010e ??1_Lockit@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 81 EC 88 00 00 00 48 C7 44 24 58 FE FF FF FF 33 D2 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 05 ?? ?? ?? ?? 48 89 44 24 20 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 44 24 48 48 8B 54 24 48 48 8B 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 28 48 83 7C 24 28 00 74 05 E9 9B 00 00 00 48 83 7C 24 20 00 74 0F 48 8B 44 24 20 48 89 44 24 28 E9 84 00 00 00 48 8B 94 24 90 00 00 00 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1E 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 90 EB 4E 48 8B 44 24 20 48 89 44 24 28 48 8B 44 24 20 48 89 05 ?? ?? ?? ?? 48 8B 44 24 20 48 89 44 24 38 48 8B 44 24 38 48 8B 00 48 8B 40 08 48 89 44 24 40 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 4C 24 38 FF 54 24 40 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B 44 24 28 48 89 44 24 50 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 81 C4 88 00 00 00 C3 }
	condition:
		$1
}

rule file_38_92_3 {
	meta:
		name = "??$use_facet@V?$moneypunct@D$00@std@@@std@@YAAEBV?$moneypunct@D$00@0@AEBVlocale@0@@Z"
		size = 287
		refs = "001d ??0_Lockit@std@@QEAA@H@Z 0025 ?_Psave@?$_Facetptr@V?$moneypunct@D$00@std@@@std@@2PEBVfacet@locale@2@EB 0031 ?id@?$moneypunct@D$00@std@@2V0locale@2@A 0036 ??Bid@locale@std@@QEAA_KXZ 004d ?_Getfacet@locale@std@@QEBAPEBVfacet@12@_K@Z 0088 ?_Getcat@?$moneypunct@D$00@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 0098 ??0bad_cast@std@@QEAA@XZ 009f _TI2?AVbad_cast@std@@ 00a9 _CxxThrowException 00e7 _guard_check_icall 00fa ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z 010e ??1_Lockit@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 81 EC 88 00 00 00 48 C7 44 24 58 FE FF FF FF 33 D2 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 05 ?? ?? ?? ?? 48 89 44 24 20 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 44 24 48 48 8B 54 24 48 48 8B 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 28 48 83 7C 24 28 00 74 05 E9 9B 00 00 00 48 83 7C 24 20 00 74 0F 48 8B 44 24 20 48 89 44 24 28 E9 84 00 00 00 48 8B 94 24 90 00 00 00 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1E 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 90 EB 4E 48 8B 44 24 20 48 89 44 24 28 48 8B 44 24 20 48 89 05 ?? ?? ?? ?? 48 8B 44 24 20 48 89 44 24 38 48 8B 44 24 38 48 8B 00 48 8B 40 08 48 89 44 24 40 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 4C 24 38 FF 54 24 40 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B 44 24 28 48 89 44 24 50 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 81 C4 88 00 00 00 C3 }
	condition:
		$1
}

rule file_38_94_3 {
	meta:
		name = "??$use_facet@V?$moneypunct@D$0A@@std@@@std@@YAAEBV?$moneypunct@D$0A@@0@AEBVlocale@0@@Z"
		size = 287
		refs = "001d ??0_Lockit@std@@QEAA@H@Z 0025 ?_Psave@?$_Facetptr@V?$moneypunct@D$0A@@std@@@std@@2PEBVfacet@locale@2@EB 0031 ?id@?$moneypunct@D$0A@@std@@2V0locale@2@A 0036 ??Bid@locale@std@@QEAA_KXZ 004d ?_Getfacet@locale@std@@QEBAPEBVfacet@12@_K@Z 0088 ?_Getcat@?$moneypunct@D$0A@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 0098 ??0bad_cast@std@@QEAA@XZ 009f _TI2?AVbad_cast@std@@ 00a9 _CxxThrowException 00e7 _guard_check_icall 00fa ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z 010e ??1_Lockit@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 81 EC 88 00 00 00 48 C7 44 24 58 FE FF FF FF 33 D2 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 05 ?? ?? ?? ?? 48 89 44 24 20 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 44 24 48 48 8B 54 24 48 48 8B 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 28 48 83 7C 24 28 00 74 05 E9 9B 00 00 00 48 83 7C 24 20 00 74 0F 48 8B 44 24 20 48 89 44 24 28 E9 84 00 00 00 48 8B 94 24 90 00 00 00 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1E 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 90 EB 4E 48 8B 44 24 20 48 89 44 24 28 48 8B 44 24 20 48 89 05 ?? ?? ?? ?? 48 8B 44 24 20 48 89 44 24 38 48 8B 44 24 38 48 8B 00 48 8B 40 08 48 89 44 24 40 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 4C 24 38 FF 54 24 40 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B 44 24 28 48 89 44 24 50 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 81 C4 88 00 00 00 C3 }
	condition:
		$1
}

rule file_10_180_2 {
	meta:
		name = "??$use_facet@V?$moneypunct@G$00@std@@@std@@YAAEBV?$moneypunct@G$00@0@AEBVlocale@0@@Z"
		size = 287
		refs = "001d ??0_Lockit@std@@QEAA@H@Z 0025 ?_Psave@?$_Facetptr@V?$moneypunct@G$00@std@@@std@@2PEBVfacet@locale@2@EB 0031 ?id@?$moneypunct@G$00@std@@2V0locale@2@A 0036 ??Bid@locale@std@@QEAA_KXZ 004d ?_Getfacet@locale@std@@QEBAPEBVfacet@12@_K@Z 0088 ?_Getcat@?$moneypunct@G$00@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 0098 ??0bad_cast@std@@QEAA@XZ 009f _TI2?AVbad_cast@std@@ 00a9 _CxxThrowException 00e7 _guard_check_icall 00fa ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z 010e ??1_Lockit@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 81 EC 88 00 00 00 48 C7 44 24 58 FE FF FF FF 33 D2 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 05 ?? ?? ?? ?? 48 89 44 24 20 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 44 24 48 48 8B 54 24 48 48 8B 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 28 48 83 7C 24 28 00 74 05 E9 9B 00 00 00 48 83 7C 24 20 00 74 0F 48 8B 44 24 20 48 89 44 24 28 E9 84 00 00 00 48 8B 94 24 90 00 00 00 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1E 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 90 EB 4E 48 8B 44 24 20 48 89 44 24 28 48 8B 44 24 20 48 89 05 ?? ?? ?? ?? 48 8B 44 24 20 48 89 44 24 38 48 8B 44 24 38 48 8B 00 48 8B 40 08 48 89 44 24 40 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 4C 24 38 FF 54 24 40 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B 44 24 28 48 89 44 24 50 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 81 C4 88 00 00 00 C3 }
	condition:
		$1
}

rule file_103_228_3 {
	meta:
		name = "??$use_facet@V?$moneypunct@G$0A@@std@@@std@@YAAEBV?$moneypunct@G$0A@@0@AEBVlocale@0@@Z"
		size = 287
		refs = "001d ??0_Lockit@std@@QEAA@H@Z 0025 ?_Psave@?$_Facetptr@V?$moneypunct@G$0A@@std@@@std@@2PEBVfacet@locale@2@EB 0031 ?id@?$moneypunct@G$0A@@std@@2V0locale@2@A 0036 ??Bid@locale@std@@QEAA_KXZ 004d ?_Getfacet@locale@std@@QEBAPEBVfacet@12@_K@Z 0088 ?_Getcat@?$moneypunct@G$0A@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 0098 ??0bad_cast@std@@QEAA@XZ 009f _TI2?AVbad_cast@std@@ 00a9 _CxxThrowException 00e7 _guard_check_icall 00fa ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z 010e ??1_Lockit@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 81 EC 88 00 00 00 48 C7 44 24 58 FE FF FF FF 33 D2 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 05 ?? ?? ?? ?? 48 89 44 24 20 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 44 24 48 48 8B 54 24 48 48 8B 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 28 48 83 7C 24 28 00 74 05 E9 9B 00 00 00 48 83 7C 24 20 00 74 0F 48 8B 44 24 20 48 89 44 24 28 E9 84 00 00 00 48 8B 94 24 90 00 00 00 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1E 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 90 EB 4E 48 8B 44 24 20 48 89 44 24 28 48 8B 44 24 20 48 89 05 ?? ?? ?? ?? 48 8B 44 24 20 48 89 44 24 38 48 8B 44 24 38 48 8B 00 48 8B 40 08 48 89 44 24 40 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 4C 24 38 FF 54 24 40 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B 44 24 28 48 89 44 24 50 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 81 C4 88 00 00 00 C3 }
	condition:
		$1
}

rule file_10_184_2 {
	meta:
		name = "??$use_facet@V?$moneypunct@_W$00@std@@@std@@YAAEBV?$moneypunct@_W$00@0@AEBVlocale@0@@Z"
		size = 287
		refs = "001d ??0_Lockit@std@@QEAA@H@Z 0025 ?_Psave@?$_Facetptr@V?$moneypunct@_W$00@std@@@std@@2PEBVfacet@locale@2@EB 0031 ?id@?$moneypunct@_W$00@std@@2V0locale@2@A 0036 ??Bid@locale@std@@QEAA_KXZ 004d ?_Getfacet@locale@std@@QEBAPEBVfacet@12@_K@Z 0088 ?_Getcat@?$moneypunct@_W$00@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 0098 ??0bad_cast@std@@QEAA@XZ 009f _TI2?AVbad_cast@std@@ 00a9 _CxxThrowException 00e7 _guard_check_icall 00fa ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z 010e ??1_Lockit@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 81 EC 88 00 00 00 48 C7 44 24 58 FE FF FF FF 33 D2 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 05 ?? ?? ?? ?? 48 89 44 24 20 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 44 24 48 48 8B 54 24 48 48 8B 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 28 48 83 7C 24 28 00 74 05 E9 9B 00 00 00 48 83 7C 24 20 00 74 0F 48 8B 44 24 20 48 89 44 24 28 E9 84 00 00 00 48 8B 94 24 90 00 00 00 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1E 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 90 EB 4E 48 8B 44 24 20 48 89 44 24 28 48 8B 44 24 20 48 89 05 ?? ?? ?? ?? 48 8B 44 24 20 48 89 44 24 38 48 8B 44 24 38 48 8B 00 48 8B 40 08 48 89 44 24 40 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 4C 24 38 FF 54 24 40 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B 44 24 28 48 89 44 24 50 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 81 C4 88 00 00 00 C3 }
	condition:
		$1
}

rule file_119_151_1 {
	meta:
		name = "??$use_facet@V?$moneypunct@_W$0A@@std@@@std@@YAAEBV?$moneypunct@_W$0A@@0@AEBVlocale@0@@Z"
		size = 287
		refs = "001d ??0_Lockit@std@@QEAA@H@Z 0025 ?_Psave@?$_Facetptr@V?$moneypunct@_W$0A@@std@@@std@@2PEBVfacet@locale@2@EB 0031 ?id@?$moneypunct@_W$0A@@std@@2V0locale@2@A 0036 ??Bid@locale@std@@QEAA_KXZ 004d ?_Getfacet@locale@std@@QEBAPEBVfacet@12@_K@Z 0088 ?_Getcat@?$moneypunct@_W$0A@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 0098 ??0bad_cast@std@@QEAA@XZ 009f _TI2?AVbad_cast@std@@ 00a9 _CxxThrowException 00e7 _guard_check_icall 00fa ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z 010e ??1_Lockit@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 81 EC 88 00 00 00 48 C7 44 24 58 FE FF FF FF 33 D2 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 05 ?? ?? ?? ?? 48 89 44 24 20 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 44 24 48 48 8B 54 24 48 48 8B 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 28 48 83 7C 24 28 00 74 05 E9 9B 00 00 00 48 83 7C 24 20 00 74 0F 48 8B 44 24 20 48 89 44 24 28 E9 84 00 00 00 48 8B 94 24 90 00 00 00 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1E 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 90 EB 4E 48 8B 44 24 20 48 89 44 24 28 48 8B 44 24 20 48 89 05 ?? ?? ?? ?? 48 8B 44 24 20 48 89 44 24 38 48 8B 44 24 38 48 8B 00 48 8B 40 08 48 89 44 24 40 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 4C 24 38 FF 54 24 40 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B 44 24 28 48 89 44 24 50 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 81 C4 88 00 00 00 C3 }
	condition:
		$1
}

rule file_2_52_3 {
	meta:
		name = "??$use_facet@V?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAAEBV?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@AEBVlocale@0@@Z"
		size = 287
		refs = "001d ??0_Lockit@std@@QEAA@H@Z 0025 ?_Psave@?$_Facetptr@V?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@2PEBVfacet@locale@2@EB 0031 ?id@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A 0036 ??Bid@locale@std@@QEAA_KXZ 004d ?_Getfacet@locale@std@@QEBAPEBVfacet@12@_K@Z 0088 ?_Getcat@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 0098 ??0bad_cast@std@@QEAA@XZ 009f _TI2?AVbad_cast@std@@ 00a9 _CxxThrowException 00e7 _guard_check_icall 00fa ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z 010e ??1_Lockit@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 81 EC 88 00 00 00 48 C7 44 24 58 FE FF FF FF 33 D2 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 05 ?? ?? ?? ?? 48 89 44 24 20 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 44 24 48 48 8B 54 24 48 48 8B 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 28 48 83 7C 24 28 00 74 05 E9 9B 00 00 00 48 83 7C 24 20 00 74 0F 48 8B 44 24 20 48 89 44 24 28 E9 84 00 00 00 48 8B 94 24 90 00 00 00 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1E 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 90 EB 4E 48 8B 44 24 20 48 89 44 24 28 48 8B 44 24 20 48 89 05 ?? ?? ?? ?? 48 8B 44 24 20 48 89 44 24 38 48 8B 44 24 38 48 8B 00 48 8B 40 08 48 89 44 24 40 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 4C 24 38 FF 54 24 40 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B 44 24 28 48 89 44 24 50 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 81 C4 88 00 00 00 C3 }
	condition:
		$1
}

rule file_10_188_2 {
	meta:
		name = "??$use_facet@V?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAAEBV?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@AEBVlocale@0@@Z"
		size = 287
		refs = "001d ??0_Lockit@std@@QEAA@H@Z 0025 ?_Psave@?$_Facetptr@V?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@2PEBVfacet@locale@2@EB 0031 ?id@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A 0036 ??Bid@locale@std@@QEAA_KXZ 004d ?_Getfacet@locale@std@@QEBAPEBVfacet@12@_K@Z 0088 ?_Getcat@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 0098 ??0bad_cast@std@@QEAA@XZ 009f _TI2?AVbad_cast@std@@ 00a9 _CxxThrowException 00e7 _guard_check_icall 00fa ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z 010e ??1_Lockit@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 81 EC 88 00 00 00 48 C7 44 24 58 FE FF FF FF 33 D2 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 05 ?? ?? ?? ?? 48 89 44 24 20 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 44 24 48 48 8B 54 24 48 48 8B 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 28 48 83 7C 24 28 00 74 05 E9 9B 00 00 00 48 83 7C 24 20 00 74 0F 48 8B 44 24 20 48 89 44 24 28 E9 84 00 00 00 48 8B 94 24 90 00 00 00 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1E 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 90 EB 4E 48 8B 44 24 20 48 89 44 24 28 48 8B 44 24 20 48 89 05 ?? ?? ?? ?? 48 8B 44 24 20 48 89 44 24 38 48 8B 44 24 38 48 8B 00 48 8B 40 08 48 89 44 24 40 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 4C 24 38 FF 54 24 40 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B 44 24 28 48 89 44 24 50 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 81 C4 88 00 00 00 C3 }
	condition:
		$1
}

rule file_119_155_1 {
	meta:
		name = "??$use_facet@V?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAAEBV?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@AEBVlocale@0@@Z"
		size = 287
		refs = "001d ??0_Lockit@std@@QEAA@H@Z 0025 ?_Psave@?$_Facetptr@V?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@2PEBVfacet@locale@2@EB 0031 ?id@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A 0036 ??Bid@locale@std@@QEAA_KXZ 004d ?_Getfacet@locale@std@@QEBAPEBVfacet@12@_K@Z 0088 ?_Getcat@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 0098 ??0bad_cast@std@@QEAA@XZ 009f _TI2?AVbad_cast@std@@ 00a9 _CxxThrowException 00e7 _guard_check_icall 00fa ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z 010e ??1_Lockit@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 81 EC 88 00 00 00 48 C7 44 24 58 FE FF FF FF 33 D2 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 05 ?? ?? ?? ?? 48 89 44 24 20 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 44 24 48 48 8B 54 24 48 48 8B 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 28 48 83 7C 24 28 00 74 05 E9 9B 00 00 00 48 83 7C 24 20 00 74 0F 48 8B 44 24 20 48 89 44 24 28 E9 84 00 00 00 48 8B 94 24 90 00 00 00 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1E 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 90 EB 4E 48 8B 44 24 20 48 89 44 24 28 48 8B 44 24 20 48 89 05 ?? ?? ?? ?? 48 8B 44 24 20 48 89 44 24 38 48 8B 44 24 38 48 8B 00 48 8B 40 08 48 89 44 24 40 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 4C 24 38 FF 54 24 40 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B 44 24 28 48 89 44 24 50 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 81 C4 88 00 00 00 C3 }
	condition:
		$1
}

rule file_62_32_1 {
	meta:
		name = "??$use_facet@V?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAAEBV?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@AEBVlocale@0@@Z"
		size = 287
		refs = "001d ??0_Lockit@std@@QEAA@H@Z 0025 ?_Psave@?$_Facetptr@V?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@2PEBVfacet@locale@2@EB 0031 ?id@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A 0036 ??Bid@locale@std@@QEAA_KXZ 004d ?_Getfacet@locale@std@@QEBAPEBVfacet@12@_K@Z 0088 ?_Getcat@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 0098 ??0bad_cast@std@@QEAA@XZ 009f _TI2?AVbad_cast@std@@ 00a9 _CxxThrowException 00e7 _guard_check_icall 00fa ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z 010e ??1_Lockit@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 81 EC 88 00 00 00 48 C7 44 24 58 FE FF FF FF 33 D2 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 05 ?? ?? ?? ?? 48 89 44 24 20 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 44 24 48 48 8B 54 24 48 48 8B 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 28 48 83 7C 24 28 00 74 05 E9 9B 00 00 00 48 83 7C 24 20 00 74 0F 48 8B 44 24 20 48 89 44 24 28 E9 84 00 00 00 48 8B 94 24 90 00 00 00 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1E 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 90 EB 4E 48 8B 44 24 20 48 89 44 24 28 48 8B 44 24 20 48 89 05 ?? ?? ?? ?? 48 8B 44 24 20 48 89 44 24 38 48 8B 44 24 38 48 8B 00 48 8B 40 08 48 89 44 24 40 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 4C 24 38 FF 54 24 40 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B 44 24 28 48 89 44 24 50 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 81 C4 88 00 00 00 C3 }
	condition:
		$1
}

rule file_119_157_1 {
	meta:
		name = "??$use_facet@V?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAAEBV?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@AEBVlocale@0@@Z"
		size = 287
		refs = "001d ??0_Lockit@std@@QEAA@H@Z 0025 ?_Psave@?$_Facetptr@V?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@2PEBVfacet@locale@2@EB 0031 ?id@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A 0036 ??Bid@locale@std@@QEAA_KXZ 004d ?_Getfacet@locale@std@@QEBAPEBVfacet@12@_K@Z 0088 ?_Getcat@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 0098 ??0bad_cast@std@@QEAA@XZ 009f _TI2?AVbad_cast@std@@ 00a9 _CxxThrowException 00e7 _guard_check_icall 00fa ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z 010e ??1_Lockit@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 81 EC 88 00 00 00 48 C7 44 24 58 FE FF FF FF 33 D2 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 05 ?? ?? ?? ?? 48 89 44 24 20 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 44 24 48 48 8B 54 24 48 48 8B 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 28 48 83 7C 24 28 00 74 05 E9 9B 00 00 00 48 83 7C 24 20 00 74 0F 48 8B 44 24 20 48 89 44 24 28 E9 84 00 00 00 48 8B 94 24 90 00 00 00 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1E 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 90 EB 4E 48 8B 44 24 20 48 89 44 24 28 48 8B 44 24 20 48 89 05 ?? ?? ?? ?? 48 8B 44 24 20 48 89 44 24 38 48 8B 44 24 38 48 8B 00 48 8B 40 08 48 89 44 24 40 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 4C 24 38 FF 54 24 40 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B 44 24 28 48 89 44 24 50 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 81 C4 88 00 00 00 C3 }
	condition:
		$1
}

rule file_10_194_2 {
	meta:
		name = "??$use_facet@V?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAAEBV?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@AEBVlocale@0@@Z"
		size = 287
		refs = "001d ??0_Lockit@std@@QEAA@H@Z 0025 ?_Psave@?$_Facetptr@V?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@2PEBVfacet@locale@2@EB 0031 ?id@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A 0036 ??Bid@locale@std@@QEAA_KXZ 004d ?_Getfacet@locale@std@@QEBAPEBVfacet@12@_K@Z 0088 ?_Getcat@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 0098 ??0bad_cast@std@@QEAA@XZ 009f _TI2?AVbad_cast@std@@ 00a9 _CxxThrowException 00e7 _guard_check_icall 00fa ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z 010e ??1_Lockit@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 81 EC 88 00 00 00 48 C7 44 24 58 FE FF FF FF 33 D2 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 05 ?? ?? ?? ?? 48 89 44 24 20 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 44 24 48 48 8B 54 24 48 48 8B 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 28 48 83 7C 24 28 00 74 05 E9 9B 00 00 00 48 83 7C 24 20 00 74 0F 48 8B 44 24 20 48 89 44 24 28 E9 84 00 00 00 48 8B 94 24 90 00 00 00 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1E 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 90 EB 4E 48 8B 44 24 20 48 89 44 24 28 48 8B 44 24 20 48 89 05 ?? ?? ?? ?? 48 8B 44 24 20 48 89 44 24 38 48 8B 44 24 38 48 8B 00 48 8B 40 08 48 89 44 24 40 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 4C 24 38 FF 54 24 40 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B 44 24 28 48 89 44 24 50 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 81 C4 88 00 00 00 C3 }
	condition:
		$1
}

rule file_11_46_2 {
	meta:
		name = "??$use_facet@V?$numpunct@D@std@@@std@@YAAEBV?$numpunct@D@0@AEBVlocale@0@@Z"
		size = 287
		refs = "001d ??0_Lockit@std@@QEAA@H@Z 0025 ?_Psave@?$_Facetptr@V?$numpunct@D@std@@@std@@2PEBVfacet@locale@2@EB 0031 ?id@?$numpunct@D@std@@2V0locale@2@A 0036 ??Bid@locale@std@@QEAA_KXZ 004d ?_Getfacet@locale@std@@QEBAPEBVfacet@12@_K@Z 0088 ?_Getcat@?$numpunct@D@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 0098 ??0bad_cast@std@@QEAA@XZ 009f _TI2?AVbad_cast@std@@ 00a9 _CxxThrowException 00e7 _guard_check_icall 00fa ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z 010e ??1_Lockit@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 81 EC 88 00 00 00 48 C7 44 24 58 FE FF FF FF 33 D2 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 05 ?? ?? ?? ?? 48 89 44 24 20 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 44 24 48 48 8B 54 24 48 48 8B 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 28 48 83 7C 24 28 00 74 05 E9 9B 00 00 00 48 83 7C 24 20 00 74 0F 48 8B 44 24 20 48 89 44 24 28 E9 84 00 00 00 48 8B 94 24 90 00 00 00 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1E 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 90 EB 4E 48 8B 44 24 20 48 89 44 24 28 48 8B 44 24 20 48 89 05 ?? ?? ?? ?? 48 8B 44 24 20 48 89 44 24 38 48 8B 44 24 38 48 8B 00 48 8B 40 08 48 89 44 24 40 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 4C 24 38 FF 54 24 40 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B 44 24 28 48 89 44 24 50 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 81 C4 88 00 00 00 C3 }
	condition:
		$1
}

rule file_10_196_2 {
	meta:
		name = "??$use_facet@V?$numpunct@G@std@@@std@@YAAEBV?$numpunct@G@0@AEBVlocale@0@@Z"
		size = 287
		refs = "001d ??0_Lockit@std@@QEAA@H@Z 0025 ?_Psave@?$_Facetptr@V?$numpunct@G@std@@@std@@2PEBVfacet@locale@2@EB 0031 ?id@?$numpunct@G@std@@2V0locale@2@A 0036 ??Bid@locale@std@@QEAA_KXZ 004d ?_Getfacet@locale@std@@QEBAPEBVfacet@12@_K@Z 0088 ?_Getcat@?$numpunct@G@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 0098 ??0bad_cast@std@@QEAA@XZ 009f _TI2?AVbad_cast@std@@ 00a9 _CxxThrowException 00e7 _guard_check_icall 00fa ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z 010e ??1_Lockit@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 81 EC 88 00 00 00 48 C7 44 24 58 FE FF FF FF 33 D2 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 05 ?? ?? ?? ?? 48 89 44 24 20 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 44 24 48 48 8B 54 24 48 48 8B 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 28 48 83 7C 24 28 00 74 05 E9 9B 00 00 00 48 83 7C 24 20 00 74 0F 48 8B 44 24 20 48 89 44 24 28 E9 84 00 00 00 48 8B 94 24 90 00 00 00 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1E 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 90 EB 4E 48 8B 44 24 20 48 89 44 24 28 48 8B 44 24 20 48 89 05 ?? ?? ?? ?? 48 8B 44 24 20 48 89 44 24 38 48 8B 44 24 38 48 8B 00 48 8B 40 08 48 89 44 24 40 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 4C 24 38 FF 54 24 40 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B 44 24 28 48 89 44 24 50 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 81 C4 88 00 00 00 C3 }
	condition:
		$1
}

rule file_10_198_2 {
	meta:
		name = "??$use_facet@V?$numpunct@_W@std@@@std@@YAAEBV?$numpunct@_W@0@AEBVlocale@0@@Z"
		size = 287
		refs = "001d ??0_Lockit@std@@QEAA@H@Z 0025 ?_Psave@?$_Facetptr@V?$numpunct@_W@std@@@std@@2PEBVfacet@locale@2@EB 0031 ?id@?$numpunct@_W@std@@2V0locale@2@A 0036 ??Bid@locale@std@@QEAA_KXZ 004d ?_Getfacet@locale@std@@QEBAPEBVfacet@12@_K@Z 0088 ?_Getcat@?$numpunct@_W@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 0098 ??0bad_cast@std@@QEAA@XZ 009f _TI2?AVbad_cast@std@@ 00a9 _CxxThrowException 00e7 _guard_check_icall 00fa ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z 010e ??1_Lockit@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 81 EC 88 00 00 00 48 C7 44 24 58 FE FF FF FF 33 D2 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 05 ?? ?? ?? ?? 48 89 44 24 20 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 44 24 48 48 8B 54 24 48 48 8B 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 28 48 83 7C 24 28 00 74 05 E9 9B 00 00 00 48 83 7C 24 20 00 74 0F 48 8B 44 24 20 48 89 44 24 28 E9 84 00 00 00 48 8B 94 24 90 00 00 00 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1E 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 90 EB 4E 48 8B 44 24 20 48 89 44 24 28 48 8B 44 24 20 48 89 05 ?? ?? ?? ?? 48 8B 44 24 20 48 89 44 24 38 48 8B 44 24 38 48 8B 00 48 8B 40 08 48 89 44 24 40 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 4C 24 38 FF 54 24 40 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B 44 24 28 48 89 44 24 50 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 81 C4 88 00 00 00 C3 }
	condition:
		$1
}

rule file_115_62_1 {
	meta:
		name = "??$use_facet@V?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAAEBV?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@AEBVlocale@0@@Z"
		size = 287
		refs = "001d ??0_Lockit@std@@QEAA@H@Z 0025 ?_Psave@?$_Facetptr@V?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@2PEBVfacet@locale@2@EB 0031 ?id@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A 0036 ??Bid@locale@std@@QEAA_KXZ 004d ?_Getfacet@locale@std@@QEBAPEBVfacet@12@_K@Z 0088 ?_Getcat@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 0098 ??0bad_cast@std@@QEAA@XZ 009f _TI2?AVbad_cast@std@@ 00a9 _CxxThrowException 00e7 _guard_check_icall 00fa ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z 010e ??1_Lockit@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 81 EC 88 00 00 00 48 C7 44 24 58 FE FF FF FF 33 D2 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 05 ?? ?? ?? ?? 48 89 44 24 20 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 44 24 48 48 8B 54 24 48 48 8B 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 28 48 83 7C 24 28 00 74 05 E9 9B 00 00 00 48 83 7C 24 20 00 74 0F 48 8B 44 24 20 48 89 44 24 28 E9 84 00 00 00 48 8B 94 24 90 00 00 00 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1E 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 90 EB 4E 48 8B 44 24 20 48 89 44 24 28 48 8B 44 24 20 48 89 05 ?? ?? ?? ?? 48 8B 44 24 20 48 89 44 24 38 48 8B 44 24 38 48 8B 00 48 8B 40 08 48 89 44 24 40 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 4C 24 38 FF 54 24 40 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B 44 24 28 48 89 44 24 50 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 81 C4 88 00 00 00 C3 }
	condition:
		$1
}

rule file_103_246_3 {
	meta:
		name = "??$use_facet@V?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAAEBV?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@AEBVlocale@0@@Z"
		size = 287
		refs = "001d ??0_Lockit@std@@QEAA@H@Z 0025 ?_Psave@?$_Facetptr@V?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@2PEBVfacet@locale@2@EB 0031 ?id@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A 0036 ??Bid@locale@std@@QEAA_KXZ 004d ?_Getfacet@locale@std@@QEBAPEBVfacet@12@_K@Z 0088 ?_Getcat@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 0098 ??0bad_cast@std@@QEAA@XZ 009f _TI2?AVbad_cast@std@@ 00a9 _CxxThrowException 00e7 _guard_check_icall 00fa ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z 010e ??1_Lockit@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 81 EC 88 00 00 00 48 C7 44 24 58 FE FF FF FF 33 D2 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 05 ?? ?? ?? ?? 48 89 44 24 20 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 44 24 48 48 8B 54 24 48 48 8B 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 28 48 83 7C 24 28 00 74 05 E9 9B 00 00 00 48 83 7C 24 20 00 74 0F 48 8B 44 24 20 48 89 44 24 28 E9 84 00 00 00 48 8B 94 24 90 00 00 00 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1E 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 90 EB 4E 48 8B 44 24 20 48 89 44 24 28 48 8B 44 24 20 48 89 05 ?? ?? ?? ?? 48 8B 44 24 20 48 89 44 24 38 48 8B 44 24 38 48 8B 00 48 8B 40 08 48 89 44 24 40 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 4C 24 38 FF 54 24 40 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B 44 24 28 48 89 44 24 50 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 81 C4 88 00 00 00 C3 }
	condition:
		$1
}

rule file_103_248_3 {
	meta:
		name = "??$use_facet@V?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAAEBV?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@AEBVlocale@0@@Z"
		size = 287
		refs = "001d ??0_Lockit@std@@QEAA@H@Z 0025 ?_Psave@?$_Facetptr@V?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@2PEBVfacet@locale@2@EB 0031 ?id@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A 0036 ??Bid@locale@std@@QEAA_KXZ 004d ?_Getfacet@locale@std@@QEBAPEBVfacet@12@_K@Z 0088 ?_Getcat@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 0098 ??0bad_cast@std@@QEAA@XZ 009f _TI2?AVbad_cast@std@@ 00a9 _CxxThrowException 00e7 _guard_check_icall 00fa ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z 010e ??1_Lockit@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 81 EC 88 00 00 00 48 C7 44 24 58 FE FF FF FF 33 D2 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 05 ?? ?? ?? ?? 48 89 44 24 20 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 44 24 48 48 8B 54 24 48 48 8B 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 28 48 83 7C 24 28 00 74 05 E9 9B 00 00 00 48 83 7C 24 20 00 74 0F 48 8B 44 24 20 48 89 44 24 28 E9 84 00 00 00 48 8B 94 24 90 00 00 00 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1E 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 90 EB 4E 48 8B 44 24 20 48 89 44 24 28 48 8B 44 24 20 48 89 05 ?? ?? ?? ?? 48 8B 44 24 20 48 89 44 24 38 48 8B 44 24 38 48 8B 00 48 8B 40 08 48 89 44 24 40 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 4C 24 38 FF 54 24 40 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B 44 24 28 48 89 44 24 50 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 81 C4 88 00 00 00 C3 }
	condition:
		$1
}

rule file_115_64_1 {
	meta:
		name = "??$use_facet@V?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAAEBV?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@AEBVlocale@0@@Z"
		size = 287
		refs = "001d ??0_Lockit@std@@QEAA@H@Z 0025 ?_Psave@?$_Facetptr@V?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@2PEBVfacet@locale@2@EB 0031 ?id@?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A 0036 ??Bid@locale@std@@QEAA_KXZ 004d ?_Getfacet@locale@std@@QEBAPEBVfacet@12@_K@Z 0088 ?_Getcat@?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 0098 ??0bad_cast@std@@QEAA@XZ 009f _TI2?AVbad_cast@std@@ 00a9 _CxxThrowException 00e7 _guard_check_icall 00fa ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z 010e ??1_Lockit@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 81 EC 88 00 00 00 48 C7 44 24 58 FE FF FF FF 33 D2 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 05 ?? ?? ?? ?? 48 89 44 24 20 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 44 24 48 48 8B 54 24 48 48 8B 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 28 48 83 7C 24 28 00 74 05 E9 9B 00 00 00 48 83 7C 24 20 00 74 0F 48 8B 44 24 20 48 89 44 24 28 E9 84 00 00 00 48 8B 94 24 90 00 00 00 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1E 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 90 EB 4E 48 8B 44 24 20 48 89 44 24 28 48 8B 44 24 20 48 89 05 ?? ?? ?? ?? 48 8B 44 24 20 48 89 44 24 38 48 8B 44 24 38 48 8B 00 48 8B 40 08 48 89 44 24 40 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 4C 24 38 FF 54 24 40 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B 44 24 28 48 89 44 24 50 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 81 C4 88 00 00 00 C3 }
	condition:
		$1
}

rule file_10_204_2 {
	meta:
		name = "??$use_facet@V?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAAEBV?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@AEBVlocale@0@@Z"
		size = 287
		refs = "001d ??0_Lockit@std@@QEAA@H@Z 0025 ?_Psave@?$_Facetptr@V?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@2PEBVfacet@locale@2@EB 0031 ?id@?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A 0036 ??Bid@locale@std@@QEAA_KXZ 004d ?_Getfacet@locale@std@@QEBAPEBVfacet@12@_K@Z 0088 ?_Getcat@?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 0098 ??0bad_cast@std@@QEAA@XZ 009f _TI2?AVbad_cast@std@@ 00a9 _CxxThrowException 00e7 _guard_check_icall 00fa ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z 010e ??1_Lockit@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 81 EC 88 00 00 00 48 C7 44 24 58 FE FF FF FF 33 D2 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 05 ?? ?? ?? ?? 48 89 44 24 20 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 44 24 48 48 8B 54 24 48 48 8B 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 28 48 83 7C 24 28 00 74 05 E9 9B 00 00 00 48 83 7C 24 20 00 74 0F 48 8B 44 24 20 48 89 44 24 28 E9 84 00 00 00 48 8B 94 24 90 00 00 00 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1E 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 90 EB 4E 48 8B 44 24 20 48 89 44 24 28 48 8B 44 24 20 48 89 05 ?? ?? ?? ?? 48 8B 44 24 20 48 89 44 24 38 48 8B 44 24 38 48 8B 00 48 8B 40 08 48 89 44 24 40 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 4C 24 38 FF 54 24 40 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B 44 24 28 48 89 44 24 50 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 81 C4 88 00 00 00 C3 }
	condition:
		$1
}

rule file_10_206_2 {
	meta:
		name = "??$use_facet@V?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAAEBV?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@AEBVlocale@0@@Z"
		size = 287
		refs = "001d ??0_Lockit@std@@QEAA@H@Z 0025 ?_Psave@?$_Facetptr@V?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@2PEBVfacet@locale@2@EB 0031 ?id@?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A 0036 ??Bid@locale@std@@QEAA_KXZ 004d ?_Getfacet@locale@std@@QEBAPEBVfacet@12@_K@Z 0088 ?_Getcat@?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 0098 ??0bad_cast@std@@QEAA@XZ 009f _TI2?AVbad_cast@std@@ 00a9 _CxxThrowException 00e7 _guard_check_icall 00fa ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z 010e ??1_Lockit@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 81 EC 88 00 00 00 48 C7 44 24 58 FE FF FF FF 33 D2 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 05 ?? ?? ?? ?? 48 89 44 24 20 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 44 24 48 48 8B 54 24 48 48 8B 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 28 48 83 7C 24 28 00 74 05 E9 9B 00 00 00 48 83 7C 24 20 00 74 0F 48 8B 44 24 20 48 89 44 24 28 E9 84 00 00 00 48 8B 94 24 90 00 00 00 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1E 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 90 EB 4E 48 8B 44 24 20 48 89 44 24 28 48 8B 44 24 20 48 89 05 ?? ?? ?? ?? 48 8B 44 24 20 48 89 44 24 38 48 8B 44 24 38 48 8B 00 48 8B 40 08 48 89 44 24 40 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 4C 24 38 FF 54 24 40 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B 44 24 28 48 89 44 24 50 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 81 C4 88 00 00 00 C3 }
	condition:
		$1
}

rule file_1_24_1 {
	meta:
		name = "?dtor$0@?0???$use_facet@V?$codecvt@DDU_Mbstatet@@@std@@@std@@YAAEBV?$codecvt@DDU_Mbstatet@@@0@AEBVlocale@0@@Z@4HA"
		size = 24
		refs = "000e ??1_Lockit@std@@QEAA@XZ"
		altNames = "?dtor$0@?0???$use_facet@V?$codecvt@GDU_Mbstatet@@@std@@@std@@YAAEBV?$codecvt@GDU_Mbstatet@@@0@AEBVlocale@0@@Z@4HA ?dtor$0@?0???$use_facet@V?$codecvt@_WDU_Mbstatet@@@std@@@std@@YAAEBV?$codecvt@_WDU_Mbstatet@@@0@AEBVlocale@0@@Z@4HA ?dtor$0@?0???$use_facet@V?$collate@D@std@@@std@@YAAEBV?$collate@D@0@AEBVlocale@0@@Z@4HA ?dtor$0@?0???$use_facet@V?$collate@G@std@@@std@@YAAEBV?$collate@G@0@AEBVlocale@0@@Z@4HA ?dtor$0@?0???$use_facet@V?$collate@_W@std@@@std@@YAAEBV?$collate@_W@0@AEBVlocale@0@@Z@4HA ?dtor$0@?0???$use_facet@V?$ctype@D@std@@@std@@YAAEBV?$ctype@D@0@AEBVlocale@0@@Z@4HA ?dtor$0@?0???$use_facet@V?$ctype@G@std@@@std@@YAAEBV?$ctype@G@0@AEBVlocale@0@@Z@4HA ?dtor$0@?0???$use_facet@V?$ctype@_W@std@@@std@@YAAEBV?$ctype@_W@0@AEBVlocale@0@@Z@4HA ?dtor$0@?0???$use_facet@V?$messages@D@std@@@std@@YAAEBV?$messages@D@0@AEBVlocale@0@@Z@4HA ?dtor$0@?0???$use_facet@V?$messages@G@std@@@std@@YAAEBV?$messages@G@0@AEBVlocale@0@@Z@4HA ?dtor$0@?0???$use_facet@V?$messages@_W@std@@@std@@YAAEBV?$messages@_W@0@AEBVlocale@0@@Z@4HA ?dtor$0@?0???$use_facet@V?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAAEBV?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@AEBVlocale@0@@Z@4HA ?dtor$0@?0???$use_facet@V?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAAEBV?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@AEBVlocale@0@@Z@4HA ?dtor$0@?0???$use_facet@V?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAAEBV?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@AEBVlocale@0@@Z@4HA ?dtor$0@?0???$use_facet@V?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAAEBV?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@AEBVlocale@0@@Z@4HA ?dtor$0@?0???$use_facet@V?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAAEBV?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@AEBVlocale@0@@Z@4HA ?dtor$0@?0???$use_facet@V?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAAEBV?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@AEBVlocale@0@@Z@4HA ?dtor$0@?0???$use_facet@V?$moneypunct@D$00@std@@@std@@YAAEBV?$moneypunct@D$00@0@AEBVlocale@0@@Z@4HA ?dtor$0@?0???$use_facet@V?$moneypunct@D$0A@@std@@@std@@YAAEBV?$moneypunct@D$0A@@0@AEBVlocale@0@@Z@4HA ?dtor$0@?0???$use_facet@V?$moneypunct@G$00@std@@@std@@YAAEBV?$moneypunct@G$00@0@AEBVlocale@0@@Z@4HA ?dtor$0@?0???$use_facet@V?$moneypunct@G$0A@@std@@@std@@YAAEBV?$moneypunct@G$0A@@0@AEBVlocale@0@@Z@4HA ?dtor$0@?0???$use_facet@V?$moneypunct@_W$00@std@@@std@@YAAEBV?$moneypunct@_W$00@0@AEBVlocale@0@@Z@4HA ?dtor$0@?0???$use_facet@V?$moneypunct@_W$0A@@std@@@std@@YAAEBV?$moneypunct@_W$0A@@0@AEBVlocale@0@@Z@4HA ?dtor$0@?0???$use_facet@V?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAAEBV?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@AEBVlocale@0@@Z@4HA ?dtor$0@?0???$use_facet@V?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAAEBV?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@AEBVlocale@0@@Z@4HA ?dtor$0@?0???$use_facet@V?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAAEBV?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@AEBVlocale@0@@Z@4HA ?dtor$0@?0???$use_facet@V?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAAEBV?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@AEBVlocale@0@@Z@4HA ?dtor$0@?0???$use_facet@V?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAAEBV?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@AEBVlocale@0@@Z@4HA ?dtor$0@?0???$use_facet@V?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAAEBV?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@AEBVlocale@0@@Z@4HA ?dtor$0@?0???$use_facet@V?$numpunct@D@std@@@std@@YAAEBV?$numpunct@D@0@AEBVlocale@0@@Z@4HA ?dtor$0@?0???$use_facet@V?$numpunct@G@std@@@std@@YAAEBV?$numpunct@G@0@AEBVlocale@0@@Z@4HA ?dtor$0@?0???$use_facet@V?$numpunct@_W@std@@@std@@YAAEBV?$numpunct@_W@0@AEBVlocale@0@@Z@4HA ?dtor$0@?0???$use_facet@V?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAAEBV?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@AEBVlocale@0@@Z@4HA ?dtor$0@?0???$use_facet@V?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAAEBV?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@AEBVlocale@0@@Z@4HA ?dtor$0@?0???$use_facet@V?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAAEBV?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@AEBVlocale@0@@Z@4HA ?dtor$0@?0???$use_facet@V?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAAEBV?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@AEBVlocale@0@@Z@4HA ?dtor$0@?0???$use_facet@V?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAAEBV?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@AEBVlocale@0@@Z@4HA ?dtor$0@?0???$use_facet@V?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAAEBV?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@AEBVlocale@0@@Z@4HA ?dtor$1@?0??_Locimp_ctor@_Locimp@locale@std@@CAXPEAV123@AEBV123@@Z@4HA"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 30 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_89_226_2 {
	meta:
		name = "?dtor$0@?0???G?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEBA?AV01@_J@Z@4HA"
		size = 24
		refs = "000e ??1?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 30 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_10_483_2 {
	meta:
		name = "?dtor$0@?0???G?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QEBA?AV01@_J@Z@4HA"
		size = 24
		refs = "000e ??1?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 30 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_103_533_3 {
	meta:
		name = "?dtor$0@?0???G?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QEBA?AV01@_J@Z@4HA"
		size = 24
		refs = "000e ??1?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 30 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_89_229_2 {
	meta:
		name = "?dtor$0@?0???H?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEBA?AV01@_J@Z@4HA"
		size = 24
		refs = "000e ??1?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 30 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_103_536_3 {
	meta:
		name = "?dtor$0@?0???H?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QEBA?AV01@_J@Z@4HA"
		size = 24
		refs = "000e ??1?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 30 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_103_538_3 {
	meta:
		name = "?dtor$0@?0???H?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QEBA?AV01@_J@Z@4HA"
		size = 24
		refs = "000e ??1?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 30 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_115_318_1 {
	meta:
		name = "?dtor$0@?0??_Init@?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IEAAXAEBV_Locinfo@2@@Z@4HA"
		size = 24
		refs = "000e ??1_Timevec@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 30 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_10_871_2 {
	meta:
		name = "?dtor$0@?0??_Init@?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IEAAXAEBV_Locinfo@2@@Z@4HA"
		size = 24
		refs = "000e ??1_Timevec@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 30 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_10_873_2 {
	meta:
		name = "?dtor$0@?0??_Init@?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IEAAXAEBV_Locinfo@2@@Z@4HA"
		size = 24
		refs = "000e ??1_Timevec@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 30 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_93_107_2 {
	meta:
		name = "?dtor$0@?0??_InitBadAllocException@__ExceptionPtr@@CA?AV?$shared_ptr@V__ExceptionPtr@@@std@@XZ@4HA"
		size = 24
		refs = "000e ??1bad_alloc@std@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 30 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_1_27_1 {
	meta:
		name = "??0?$_Immortalizer@V_Iostream_error_category@std@@@std@@QEAA@XZ"
		size = 76
		refs = "0017 ??2@YAPEAX_KPEAX@Z 002e ??0_Iostream_error_category@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 48 8B D0 B9 10 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 20 48 83 7C 24 20 00 74 11 48 8B 4C 24 20 E8 ?? ?? ?? ?? 48 89 44 24 28 EB 09 48 C7 44 24 28 00 00 00 00 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_67_19_1 {
	meta:
		name = "??0?$_Immortalizer@V_Generic_error_category@std@@@std@@QEAA@XZ"
		size = 76
		refs = "0017 ??2@YAPEAX_KPEAX@Z 002e ??0_Generic_error_category@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 48 8B D0 B9 10 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 20 48 83 7C 24 20 00 74 11 48 8B 4C 24 20 E8 ?? ?? ?? ?? 48 89 44 24 28 EB 09 48 C7 44 24 28 00 00 00 00 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_85_36_1 {
	meta:
		name = "??0?$_Immortalizer@V_System_error_category@std@@@std@@QEAA@XZ"
		size = 76
		refs = "0017 ??2@YAPEAX_KPEAX@Z 002e ??0_System_error_category@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 48 8B D0 B9 10 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 20 48 83 7C 24 20 00 74 11 48 8B 4C 24 20 E8 ?? ?? ?? ?? 48 89 44 24 28 EB 09 48 C7 44 24 28 00 00 00 00 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1_28_1 {
	meta:
		name = "??0?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAA@XZ"
		size = 37
		refs = "0017 ??$?0$$V@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@D@std@@@std@@V?$_String_val@U?$_Simple_types@D@std@@@2@$00@std@@QEAA@U_Zero_then_variadic_args_t@1@@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 0F B6 54 24 20 48 8B C8 E8 ?? ?? ?? ?? 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_119_178_1 {
	meta:
		name = "??0?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QEAA@XZ"
		size = 37
		refs = "0017 ??$?0$$V@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@G@std@@@std@@V?$_String_val@U?$_Simple_types@G@std@@@2@$00@std@@QEAA@U_Zero_then_variadic_args_t@1@@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 0F B6 54 24 20 48 8B C8 E8 ?? ?? ?? ?? 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_41_11_1 {
	meta:
		name = "??0?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QEAA@XZ"
		size = 37
		refs = "0017 ??$?0$$V@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@V?$_String_val@U?$_Simple_types@_W@std@@@2@$00@std@@QEAA@U_Zero_then_variadic_args_t@1@@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 0F B6 54 24 20 48 8B C8 E8 ?? ?? ?? ?? 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1_29_1 {
	meta:
		name = "??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEAA@PEBDPEBU_Container_base0@1@@Z"
		size = 57
		refs = "002b ?_Adopt@_Iterator_base0@std@@QEAAXPEBX@Z"
		altNames = "??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QEAA@PEBGPEBU_Container_base0@1@@Z ??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QEAA@PEB_WPEBU_Container_base0@1@@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 4C 24 38 48 89 08 48 8B 54 24 40 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_30_1 {
	meta:
		name = "??0?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEAA@PEADPEBU_Container_base0@1@@Z"
		size = 49
		refs = "0023 ??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEAA@PEBDPEBU_Container_base0@1@@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_101_47_2 {
	meta:
		name = "??0?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEAA@PEADPEBU_Container_base12@1@@Z"
		size = 49
		refs = "0023 ??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEAA@PEBDPEBU_Container_base12@1@@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_119_184_1 {
	meta:
		name = "??0?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QEAA@PEAGPEBU_Container_base0@1@@Z"
		size = 49
		refs = "0023 ??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QEAA@PEBGPEBU_Container_base0@1@@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_10_235_2 {
	meta:
		name = "??0?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QEAA@PEAGPEBU_Container_base12@1@@Z"
		size = 49
		refs = "0023 ??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QEAA@PEBGPEBU_Container_base12@1@@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_119_185_1 {
	meta:
		name = "??0?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QEAA@PEA_WPEBU_Container_base0@1@@Z"
		size = 49
		refs = "0023 ??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QEAA@PEB_WPEBU_Container_base0@1@@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_61_32_2 {
	meta:
		name = "??0?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QEAA@PEA_WPEBU_Container_base12@1@@Z"
		size = 49
		refs = "0023 ??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QEAA@PEB_WPEBU_Container_base12@1@@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_31_1 {
	meta:
		name = "??0?$_String_val@U?$_Simple_types@D@std@@@std@@QEAA@XZ"
		size = 58
		refs = "0012 ??0_Bxty@?$_String_val@U?$_Simple_types@D@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B C8 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 C7 40 10 00 00 00 00 48 8B 44 24 30 48 C7 40 18 00 00 00 00 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_119_187_1 {
	meta:
		name = "??0?$_String_val@U?$_Simple_types@G@std@@@std@@QEAA@XZ"
		size = 58
		refs = "0012 ??0_Bxty@?$_String_val@U?$_Simple_types@G@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B C8 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 C7 40 10 00 00 00 00 48 8B 44 24 30 48 C7 40 18 00 00 00 00 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_41_14_1 {
	meta:
		name = "??0?$_String_val@U?$_Simple_types@_W@std@@@std@@QEAA@XZ"
		size = 58
		refs = "0012 ??0_Bxty@?$_String_val@U?$_Simple_types@_W@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B C8 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 C7 40 10 00 00 00 00 48 8B 44 24 30 48 C7 40 18 00 00 00 00 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_33_1 {
	meta:
		name = "??0?$_Wrap_alloc@V?$allocator@D@std@@@std@@QEAA@XZ"
		size = 29
		refs = "000f ??0?$allocator@D@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_8_62_3 {
	meta:
		name = "??0?$_Iterator012@Urandom_access_iterator_tag@std@@D_JPEBDAEBDU_Iterator_base12@2@@std@@QEAA@XZ"
		size = 29
		refs = "000f ??0_Iterator_base12@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_10_210_2 {
	meta:
		name = "??0?$_Iterator012@Urandom_access_iterator_tag@std@@G_JPEBGAEBGU_Iterator_base12@2@@std@@QEAA@XZ"
		size = 29
		refs = "000f ??0_Iterator_base12@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_103_259_3 {
	meta:
		name = "??0?$_Iterator012@Urandom_access_iterator_tag@std@@_W_JPEB_WAEB_WU_Iterator_base12@2@@std@@QEAA@XZ"
		size = 29
		refs = "000f ??0_Iterator_base12@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_103_293_3 {
	meta:
		name = "??0?$_Wrap_alloc@V?$allocator@G@std@@@std@@QEAA@XZ"
		size = 29
		refs = "000f ??0?$allocator@G@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_93_14_1 {
	meta:
		name = "??0?$_Wrap_alloc@V?$allocator@_W@std@@@std@@QEAA@XZ"
		size = 29
		refs = "000f ??0?$allocator@_W@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_60_40_3 {
	meta:
		name = "??0?$shared_ptr@V__ExceptionPtr@@@std@@QEAA@XZ"
		size = 29
		refs = "000f ??0?$_Ptr_base@V__ExceptionPtr@@@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_62_115_1 {
	meta:
		name = "??E?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@QEAAAEAV01@XZ"
		size = 29
		refs = "000f ?_Inc@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@AEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_10_474_2 {
	meta:
		name = "??E?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@QEAAAEAV01@XZ"
		size = 29
		refs = "000f ?_Inc@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@AEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_10_475_2 {
	meta:
		name = "??E?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@XZ"
		size = 29
		refs = "000f ?_Inc@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@AEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_12_80_4 {
	meta:
		name = "?getECSUName@UnDecorator@@CA?AVDName@@XZ"
		size = 29
		refs = "000f ?getScopedName@UnDecorator@@CA?AVDName@@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_12_107_4 {
	meta:
		name = "?getStorageConvention@UnDecorator@@CA?AVDName@@XZ"
		size = 29
		refs = "000f ?getDataIndirectType@UnDecorator@@CA?AVDName@@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_34_1 {
	meta:
		name = "??0?$_Yarn@D@std@@QEAA@XZ"
		size = 32
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 C7 00 00 00 00 00 48 8B 44 24 08 C6 40 08 00 48 8B 44 24 08 C3 }
	condition:
		$1
}

rule file_1_35_1 {
	meta:
		name = "??0?$_Yarn@_W@std@@QEAA@XZ"
		size = 34
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 C7 00 00 00 00 00 33 C0 48 8B 4C 24 08 66 89 41 08 48 8B 44 24 08 C3 }
	condition:
		$1
}

rule file_1_36_1 {
	meta:
		name = "??0?$allocator@D@std@@QEAA@AEBV01@@Z"
		size = 16
		altNames = "??$?0D@?$allocator@U_Container_proxy@std@@@std@@QEAA@AEBV?$allocator@D@1@@Z ??$?0G@?$allocator@U_Container_proxy@std@@@std@@QEAA@AEBV?$allocator@G@1@@Z ??$?0H@?$_StaticAllocator@V?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@@@QEAA@AEBU?$_StaticAllocator@H@@@Z ??$?0Uoutput_iterator_tag@std@@@_Any_tag@std@@QEAA@$$QEAUoutput_iterator_tag@1@@Z ??$?0_W@?$allocator@U_Container_proxy@std@@@std@@QEAA@AEBV?$allocator@_W@1@@Z ??0?$allocator@G@std@@QEAA@AEBV01@@Z ??0?$allocator@_W@std@@QEAA@AEBV01@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 8B 44 24 08 C3 }
	condition:
		$1
}

rule file_1_38_1 {
	meta:
		name = "??0?$basic_filebuf@DU?$char_traits@D@std@@@std@@QEAA@PEAU_iobuf@@@Z"
		size = 78
		refs = "001d ??0?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAA@XZ 002a ??_7?$basic_filebuf@DU?$char_traits@D@std@@@std@@6B@ 003f ?_Init@?$basic_filebuf@DU?$char_traits@D@std@@@std@@IEAAXPEAU_iobuf@@W4_Initfl@12@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 08 45 33 C0 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_40_56_2 {
	meta:
		name = "??0?$basic_filebuf@GU?$char_traits@G@std@@@std@@QEAA@PEAU_iobuf@@@Z"
		size = 78
		refs = "001d ??0?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEAA@XZ 002a ??_7?$basic_filebuf@GU?$char_traits@G@std@@@std@@6B@ 003f ?_Init@?$basic_filebuf@GU?$char_traits@G@std@@@std@@IEAAXPEAU_iobuf@@W4_Initfl@12@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 08 45 33 C0 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_116_76_3 {
	meta:
		name = "??0?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@QEAA@PEAU_iobuf@@@Z"
		size = 78
		refs = "001d ??0?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEAA@XZ 002a ??_7?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@6B@ 003f ?_Init@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@IEAAXPEAU_iobuf@@W4_Initfl@12@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 08 45 33 C0 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1_39_1 {
	meta:
		name = "?dtor$0@?0???0?$basic_filebuf@DU?$char_traits@D@std@@@std@@QEAA@PEAU_iobuf@@@Z@4HA"
		size = 24
		refs = "000e ??1?$basic_streambuf@DU?$char_traits@D@std@@@std@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_41_5_2 {
	meta:
		name = "?dtor$0@?0???$?0U?$_Wrap_alloc@V?$allocator@D@std@@@std@@X@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAA@$$QEAU?$_Wrap_alloc@V?$allocator@D@std@@@1@@Z@4HA"
		size = 24
		refs = "000e ??1?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@D@std@@@std@@V?$_String_val@U?$_Simple_types@D@std@@@2@$00@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_103_13_3 {
	meta:
		name = "?dtor$0@?0???$?0U?$_Wrap_alloc@V?$allocator@G@std@@@std@@X@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QEAA@$$QEAU?$_Wrap_alloc@V?$allocator@G@std@@@1@@Z@4HA"
		size = 24
		refs = "000e ??1?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@G@std@@@std@@V?$_String_val@U?$_Simple_types@G@std@@@2@$00@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_103_16_3 {
	meta:
		name = "?dtor$0@?0???$?0U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@X@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QEAA@$$QEAU?$_Wrap_alloc@V?$allocator@_W@std@@@1@@Z@4HA"
		size = 24
		refs = "000e ??1?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@V?$_String_val@U?$_Simple_types@_W@std@@@2@$00@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_115_67_1 {
	meta:
		name = "?dtor$0@?0???0?$_Mpunct@D@std@@QEAA@AEBV_Locinfo@1@_K_N2@Z@4HA"
		size = 24
		refs = "000e ??1money_base@std@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_103_261_3 {
	meta:
		name = "?dtor$0@?0???0?$_Mpunct@G@std@@QEAA@AEBV_Locinfo@1@_K_N2@Z@4HA"
		size = 24
		refs = "000e ??1money_base@std@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_10_217_2 {
	meta:
		name = "?dtor$0@?0???0?$_Mpunct@_W@std@@QEAA@AEBV_Locinfo@1@_K_N2@Z@4HA"
		size = 24
		refs = "000e ??1money_base@std@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_96_44_2 {
	meta:
		name = "?dtor$0@?0???0?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAA@XZ@4HA"
		size = 24
		refs = "000e ??1?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@D@std@@@std@@V?$_String_val@U?$_Simple_types@D@std@@@2@$00@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_10_221_2 {
	meta:
		name = "?dtor$0@?0???0?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QEAA@XZ@4HA"
		size = 24
		refs = "000e ??1?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@G@std@@@std@@V?$_String_val@U?$_Simple_types@G@std@@@2@$00@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_61_27_2 {
	meta:
		name = "?dtor$0@?0???0?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QEAA@XZ@4HA"
		size = 24
		refs = "000e ??1?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@V?$_String_val@U?$_Simple_types@_W@std@@@2@$00@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_105_46_2 {
	meta:
		name = "?dtor$0@?0???0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEAA@PEBDPEBU_Container_base12@1@@Z@4HA"
		size = 24
		refs = "000e ??1?$_Iterator012@Urandom_access_iterator_tag@std@@D_JPEBDAEBDU_Iterator_base12@2@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_10_227_2 {
	meta:
		name = "?dtor$0@?0???0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QEAA@PEBGPEBU_Container_base12@1@@Z@4HA"
		size = 24
		refs = "000e ??1?$_Iterator012@Urandom_access_iterator_tag@std@@G_JPEBGAEBGU_Iterator_base12@2@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_20_32_3 {
	meta:
		name = "?dtor$0@?0???0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QEAA@PEB_WPEBU_Container_base12@1@@Z@4HA"
		size = 24
		refs = "000e ??1?$_Iterator012@Urandom_access_iterator_tag@std@@_W_JPEB_WAEB_WU_Iterator_base12@2@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_66_49_2 {
	meta:
		name = "?dtor$0@?0???0?$_String_val@U?$_Simple_types@D@std@@@std@@QEAA@XZ@4HA"
		size = 24
		refs = "000e ??1_Container_base12@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_10_241_2 {
	meta:
		name = "?dtor$0@?0???0?$_String_val@U?$_Simple_types@G@std@@@std@@QEAA@XZ@4HA"
		size = 24
		refs = "000e ??1_Container_base12@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_20_36_3 {
	meta:
		name = "?dtor$0@?0???0?$_String_val@U?$_Simple_types@_W@std@@@std@@QEAA@XZ@4HA"
		size = 24
		refs = "000e ??1_Container_base12@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_41_57_2 {
	meta:
		name = "?dtor$0@?0???0?$basic_filebuf@GU?$char_traits@G@std@@@std@@QEAA@PEAU_iobuf@@@Z@4HA"
		size = 24
		refs = "000e ??1?$basic_streambuf@GU?$char_traits@G@std@@@std@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_91_39_1 {
	meta:
		name = "?dtor$0@?0???0?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@QEAA@PEAU_iobuf@@@Z@4HA"
		size = 24
		refs = "000e ??1?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_69_84_3 {
	meta:
		name = "?dtor$0@?0???0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@AEBV01@@Z@4HA"
		size = 24
		refs = "000e ??1?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_105_66_2 {
	meta:
		name = "?dtor$0@?0???0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@PEBD@Z@4HA"
		size = 24
		refs = "000e ??1?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_38_128_3 {
	meta:
		name = "?dtor$0@?0???0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@PEBD_K@Z@4HA"
		size = 24
		refs = "000e ??1?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_91_51_1 {
	meta:
		name = "?dtor$0@?0???0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@_KD@Z@4HA"
		size = 24
		refs = "000e ??1?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_103_312_3 {
	meta:
		name = "?dtor$0@?0???0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEAA@AEBV01@@Z@4HA"
		size = 24
		refs = "000e ??1?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_103_314_3 {
	meta:
		name = "?dtor$0@?0???0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEAA@PEBG@Z@4HA"
		size = 24
		refs = "000e ??1?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_119_215_1 {
	meta:
		name = "?dtor$0@?0???0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEAA@PEBG_K@Z@4HA"
		size = 24
		refs = "000e ??1?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_10_273_2 {
	meta:
		name = "?dtor$0@?0???0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEAA@_KG@Z@4HA"
		size = 24
		refs = "000e ??1?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_10_276_2 {
	meta:
		name = "?dtor$0@?0???0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAA@AEBV01@@Z@4HA"
		size = 24
		refs = "000e ??1?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_61_38_2 {
	meta:
		name = "?dtor$0@?0???0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAA@PEB_W@Z@4HA"
		size = 24
		refs = "000e ??1?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_10_280_2 {
	meta:
		name = "?dtor$0@?0???0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAA@PEB_W_K@Z@4HA"
		size = 24
		refs = "000e ??1?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_10_283_2 {
	meta:
		name = "?dtor$0@?0???0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAA@_K_W@Z@4HA"
		size = 24
		refs = "000e ??1?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_66_71_2 {
	meta:
		name = "?dtor$0@?0???0?$codecvt@DDU_Mbstatet@@@std@@QEAA@AEBV_Locinfo@1@_K@Z@4HA"
		size = 24
		refs = "000e ??1codecvt_base@std@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_82_71_2 {
	meta:
		name = "?dtor$0@?0???0?$codecvt@GDU_Mbstatet@@@std@@QEAA@AEBV_Locinfo@1@_K@Z@4HA"
		size = 24
		refs = "000e ??1codecvt_base@std@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_103_333_3 {
	meta:
		name = "?dtor$0@?0???0?$codecvt@_WDU_Mbstatet@@@std@@QEAA@AEBV_Locinfo@1@_K@Z@4HA"
		size = 24
		refs = "000e ??1codecvt_base@std@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_115_90_1 {
	meta:
		name = "?dtor$0@?0???0?$collate@D@std@@QEAA@AEBV_Locinfo@1@_K@Z@4HA"
		size = 24
		refs = "000e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_10_289_2 {
	meta:
		name = "?dtor$0@?0???0?$collate@G@std@@QEAA@AEBV_Locinfo@1@_K@Z@4HA"
		size = 24
		refs = "000e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_10_291_2 {
	meta:
		name = "?dtor$0@?0???0?$collate@_W@std@@QEAA@AEBV_Locinfo@1@_K@Z@4HA"
		size = 24
		refs = "000e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_115_92_1 {
	meta:
		name = "?dtor$0@?0???0?$ctype@D@std@@QEAA@AEBV_Locinfo@1@_K@Z@4HA"
		size = 24
		refs = "000e ??1ctype_base@std@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_40_73_2 {
	meta:
		name = "?dtor$0@?0???0?$ctype@G@std@@QEAA@AEBV_Locinfo@1@_K@Z@4HA"
		size = 24
		refs = "000e ??1ctype_base@std@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_69_93_3 {
	meta:
		name = "?dtor$0@?0???0?$ctype@_W@std@@QEAA@AEBV_Locinfo@1@_K@Z@4HA"
		size = 24
		refs = "000e ??1ctype_base@std@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_115_94_1 {
	meta:
		name = "?dtor$0@?0???0?$messages@D@std@@QEAA@AEBV_Locinfo@1@_K@Z@4HA"
		size = 24
		refs = "000e ??1messages_base@std@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_119_242_1 {
	meta:
		name = "?dtor$0@?0???0?$messages@G@std@@QEAA@AEBV_Locinfo@1@_K@Z@4HA"
		size = 24
		refs = "000e ??1messages_base@std@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_10_299_2 {
	meta:
		name = "?dtor$0@?0???0?$messages@_W@std@@QEAA@AEBV_Locinfo@1@_K@Z@4HA"
		size = 24
		refs = "000e ??1messages_base@std@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_89_125_2 {
	meta:
		name = "?dtor$0@?0???0?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z@4HA"
		size = 24
		refs = "000e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_10_301_2 {
	meta:
		name = "?dtor$0@?0???0?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z@4HA"
		size = 24
		refs = "000e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_103_349_3 {
	meta:
		name = "?dtor$0@?0???0?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z@4HA"
		size = 24
		refs = "000e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_89_127_2 {
	meta:
		name = "?dtor$0@?0???0?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z@4HA"
		size = 24
		refs = "000e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_119_250_1 {
	meta:
		name = "?dtor$0@?0???0?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z@4HA"
		size = 24
		refs = "000e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_10_307_2 {
	meta:
		name = "?dtor$0@?0???0?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z@4HA"
		size = 24
		refs = "000e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_11_67_2 {
	meta:
		name = "?dtor$0@?0???0?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z@4HA"
		size = 24
		refs = "000e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_10_313_2 {
	meta:
		name = "?dtor$0@?0???0?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z@4HA"
		size = 24
		refs = "000e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_10_315_2 {
	meta:
		name = "?dtor$0@?0???0?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z@4HA"
		size = 24
		refs = "000e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_62_55_1 {
	meta:
		name = "?dtor$0@?0???0?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z@4HA"
		size = 24
		refs = "000e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_103_363_3 {
	meta:
		name = "?dtor$0@?0???0?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z@4HA"
		size = 24
		refs = "000e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_10_319_2 {
	meta:
		name = "?dtor$0@?0???0?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z@4HA"
		size = 24
		refs = "000e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_62_57_1 {
	meta:
		name = "?dtor$0@?0???0?$numpunct@D@std@@QEAA@AEBV_Locinfo@1@_K_N@Z@4HA"
		size = 24
		refs = "000e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_10_321_2 {
	meta:
		name = "?dtor$0@?0???0?$numpunct@G@std@@QEAA@AEBV_Locinfo@1@_K_N@Z@4HA"
		size = 24
		refs = "000e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_10_323_2 {
	meta:
		name = "?dtor$0@?0???0?$numpunct@_W@std@@QEAA@AEBV_Locinfo@1@_K_N@Z@4HA"
		size = 24
		refs = "000e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_115_102_1 {
	meta:
		name = "?dtor$0@?0???0?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z@4HA"
		size = 24
		refs = "000e ??1time_base@std@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_10_325_2 {
	meta:
		name = "?dtor$0@?0???0?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z@4HA"
		size = 24
		refs = "000e ??1time_base@std@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_119_272_1 {
	meta:
		name = "?dtor$0@?0???0?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z@4HA"
		size = 24
		refs = "000e ??1time_base@std@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_89_133_2 {
	meta:
		name = "?dtor$0@?0???0?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z@4HA"
		size = 24
		refs = "000e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_119_274_1 {
	meta:
		name = "?dtor$0@?0???0?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z@4HA"
		size = 24
		refs = "000e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_103_378_3 {
	meta:
		name = "?dtor$0@?0???0?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z@4HA"
		size = 24
		refs = "000e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_114_4_3 {
	meta:
		name = "?dtor$0@?0???0_Locimp@locale@std@@AEAA@AEBV012@@Z@4HA"
		size = 24
		refs = "000e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_114_7_3 {
	meta:
		name = "?dtor$0@?0???0_Locimp@locale@std@@AEAA@_N@Z@4HA"
		size = 24
		refs = "000e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_33_9_2 {
	meta:
		name = "?dtor$0@?0???0facet@locale@std@@IEAA@_K@Z@4HA"
		size = 24
		refs = "000e ??1_Facet_base@std@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_50_67_3 {
	meta:
		name = "?dtor$0@?0???0sentry@?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAA@AEAV12@@Z@4HA"
		size = 24
		refs = "000e ??1_Sentry_base@?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_105_49_1 {
	meta:
		name = "?dtor$0@?0???0sentry@?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAA@AEAV12@@Z@4HA"
		size = 24
		refs = "000e ??1_Sentry_base@?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_59_49_1 {
	meta:
		name = "?dtor$0@?0???0sentry@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAA@AEAV12@@Z@4HA"
		size = 24
		refs = "000e ??1_Sentry_base@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_38_393_3 {
	meta:
		name = "?dtor$0@?0??_Makexloc@_Locimp@locale@std@@CAXAEBV_Locinfo@3@HPEAV123@PEBV23@@Z@4HA"
		size = 24
		refs = "000e ??3_Crt_new_delete@std@@SAXPEAX@Z"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_23_20_2 {
	meta:
		name = "?dtor$0@?0??rethrow_exception@std@@YAXVexception_ptr@1@@Z@4HA"
		size = 24
		refs = "000e ??1exception_ptr@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_38_58_3 {
	meta:
		name = "?dtor$3@?0???$assign@V?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV01@V?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@1@0@Z@4HA"
		size = 24
		refs = "000e ??1?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_103_146_3 {
	meta:
		name = "?dtor$3@?0???$assign@V?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEAAAEAV01@V?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@1@0@Z@4HA"
		size = 24
		refs = "000e ??1?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_103_154_3 {
	meta:
		name = "?dtor$3@?0???$assign@V?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAAAEAV01@V?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@1@0@Z@4HA"
		size = 24
		refs = "000e ??1?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_1_40_1 {
	meta:
		name = "??0?$basic_ios@DU?$char_traits@D@std@@@std@@IEAA@XZ"
		size = 44
		refs = "000f ??0ios_base@std@@IEAA@XZ 001b ??_7?$basic_ios@DU?$char_traits@D@std@@@std@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_5_40_1 {
	meta:
		name = "??0?$basic_ios@GU?$char_traits@G@std@@@std@@IEAA@XZ"
		size = 44
		refs = "000f ??0ios_base@std@@IEAA@XZ 001b ??_7?$basic_ios@GU?$char_traits@G@std@@@std@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_116_78_3 {
	meta:
		name = "??0?$basic_ios@_WU?$char_traits@_W@std@@@std@@IEAA@XZ"
		size = 44
		refs = "000f ??0ios_base@std@@IEAA@XZ 001b ??_7?$basic_ios@_WU?$char_traits@_W@std@@@std@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_88_3_1 {
	meta:
		name = "??0bad_function_call@std@@QEAA@XZ"
		size = 44
		refs = "000f ??0exception@std@@QEAA@XZ 001b ??_7bad_function_call@std@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_41_1 {
	meta:
		name = "??0?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAA@PEAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z"
		size = 210
		refs = "0038 ??_8?$basic_ostream@DU?$char_traits@D@std@@@std@@7B@ 004c ??0?$basic_ios@DU?$char_traits@D@std@@@std@@IEAA@XZ 0070 ??_7?$basic_ostream@DU?$char_traits@D@std@@@std@@6B@ 00c3 ?init@?$basic_ios@DU?$char_traits@D@std@@@std@@IEAAXPEAV?$basic_streambuf@DU?$char_traits@D@std@@@2@_N@Z"
	strings:
		$1 = { 44 89 4C 24 20 44 88 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 28 FE FF FF FF C7 44 24 20 00 00 00 00 83 7C 24 58 00 74 2C 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 40 48 83 C0 10 48 8B C8 E8 ?? ?? ?? ?? 90 8B 44 24 20 83 C8 01 89 44 24 20 48 8B 44 24 40 48 8B 00 48 63 40 04 48 8B 4C 24 40 48 8D 15 ?? ?? ?? ?? 48 89 14 01 48 8B 44 24 40 48 8B 00 48 63 40 04 48 83 E8 10 48 8B 4C 24 40 48 8B 09 48 63 49 04 48 8B 54 24 40 89 44 0A FC 48 8B 44 24 40 48 8B 00 48 63 40 04 48 8B 4C 24 40 48 03 C8 48 8B C1 44 0F B6 44 24 50 48 8B 54 24 48 48 8B C8 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_5_41_1 {
	meta:
		name = "??0?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAA@PEAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z"
		size = 210
		refs = "0038 ??_8?$basic_ostream@GU?$char_traits@G@std@@@std@@7B@ 004c ??0?$basic_ios@GU?$char_traits@G@std@@@std@@IEAA@XZ 0070 ??_7?$basic_ostream@GU?$char_traits@G@std@@@std@@6B@ 00c3 ?init@?$basic_ios@GU?$char_traits@G@std@@@std@@IEAAXPEAV?$basic_streambuf@GU?$char_traits@G@std@@@2@_N@Z"
	strings:
		$1 = { 44 89 4C 24 20 44 88 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 28 FE FF FF FF C7 44 24 20 00 00 00 00 83 7C 24 58 00 74 2C 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 40 48 83 C0 10 48 8B C8 E8 ?? ?? ?? ?? 90 8B 44 24 20 83 C8 01 89 44 24 20 48 8B 44 24 40 48 8B 00 48 63 40 04 48 8B 4C 24 40 48 8D 15 ?? ?? ?? ?? 48 89 14 01 48 8B 44 24 40 48 8B 00 48 63 40 04 48 83 E8 10 48 8B 4C 24 40 48 8B 09 48 63 49 04 48 8B 54 24 40 89 44 0A FC 48 8B 44 24 40 48 8B 00 48 63 40 04 48 8B 4C 24 40 48 03 C8 48 8B C1 44 0F B6 44 24 50 48 8B 54 24 48 48 8B C8 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_114_41_1 {
	meta:
		name = "??0?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAA@PEAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z"
		size = 210
		refs = "0038 ??_8?$basic_ostream@_WU?$char_traits@_W@std@@@std@@7B@ 004c ??0?$basic_ios@_WU?$char_traits@_W@std@@@std@@IEAA@XZ 0070 ??_7?$basic_ostream@_WU?$char_traits@_W@std@@@std@@6B@ 00c3 ?init@?$basic_ios@_WU?$char_traits@_W@std@@@std@@IEAAXPEAV?$basic_streambuf@_WU?$char_traits@_W@std@@@2@_N@Z"
	strings:
		$1 = { 44 89 4C 24 20 44 88 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 28 FE FF FF FF C7 44 24 20 00 00 00 00 83 7C 24 58 00 74 2C 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 40 48 83 C0 10 48 8B C8 E8 ?? ?? ?? ?? 90 8B 44 24 20 83 C8 01 89 44 24 20 48 8B 44 24 40 48 8B 00 48 63 40 04 48 8B 4C 24 40 48 8D 15 ?? ?? ?? ?? 48 89 14 01 48 8B 44 24 40 48 8B 00 48 63 40 04 48 83 E8 10 48 8B 4C 24 40 48 8B 09 48 63 49 04 48 8B 54 24 40 89 44 0A FC 48 8B 44 24 40 48 8B 00 48 63 40 04 48 8B 4C 24 40 48 03 C8 48 8B C1 44 0F B6 44 24 50 48 8B 54 24 48 48 8B C8 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1_42_1 {
	meta:
		name = "?dtor$0@?0???0?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAA@PEAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z@4HA"
		size = 42
		refs = "0020 ??1?$basic_ios@DU?$char_traits@D@std@@@std@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 8B 45 20 83 E0 01 85 C0 74 11 83 65 20 FE 48 8B 4D 40 48 83 C1 10 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_5_42_1 {
	meta:
		name = "?dtor$0@?0???0?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAA@PEAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z@4HA"
		size = 42
		refs = "0020 ??1?$basic_ios@GU?$char_traits@G@std@@@std@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 8B 45 20 83 E0 01 85 C0 74 11 83 65 20 FE 48 8B 4D 40 48 83 C1 10 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_114_42_1 {
	meta:
		name = "?dtor$0@?0???0?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAA@PEAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z@4HA"
		size = 42
		refs = "0020 ??1?$basic_ios@_WU?$char_traits@_W@std@@@std@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 8B 45 20 83 E0 01 85 C0 74 11 83 65 20 FE 48 8B 4D 40 48 83 C1 10 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_1_43_1 {
	meta:
		name = "??0?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAA@XZ"
		size = 107
		refs = "0011 ??_7?$basic_streambuf@DU?$char_traits@D@std@@@std@@6B@ 001e ??2_Crt_new_delete@std@@SAPEAX_K@Z 0035 ??0locale@std@@QEAA@XZ 005d ?_Init@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 08 B9 10 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 20 48 83 7C 24 20 00 74 11 48 8B 4C 24 20 E8 ?? ?? ?? ?? 48 89 44 24 28 EB 09 48 C7 44 24 28 00 00 00 00 48 8B 44 24 40 48 8B 4C 24 28 48 89 48 60 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_40_61_2 {
	meta:
		name = "??0?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEAA@XZ"
		size = 107
		refs = "0011 ??_7?$basic_streambuf@GU?$char_traits@G@std@@@std@@6B@ 001e ??2_Crt_new_delete@std@@SAPEAX_K@Z 0035 ??0locale@std@@QEAA@XZ 005d ?_Init@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 08 B9 10 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 20 48 83 7C 24 20 00 74 11 48 8B 4C 24 20 E8 ?? ?? ?? ?? 48 89 44 24 28 EB 09 48 C7 44 24 28 00 00 00 00 48 8B 44 24 40 48 8B 4C 24 28 48 89 48 60 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_116_81_3 {
	meta:
		name = "??0?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEAA@XZ"
		size = 107
		refs = "0011 ??_7?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@6B@ 001e ??2_Crt_new_delete@std@@SAPEAX_K@Z 0035 ??0locale@std@@QEAA@XZ 005d ?_Init@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 08 B9 10 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 20 48 83 7C 24 20 00 74 11 48 8B 4C 24 20 E8 ?? ?? ?? ?? 48 89 44 24 28 EB 09 48 C7 44 24 28 00 00 00 00 48 8B 44 24 40 48 8B 4C 24 28 48 89 48 60 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1_44_1 {
	meta:
		name = "??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@$$QEAV01@@Z"
		size = 108
		refs = "001d ?_Getal@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAAAEAU?$_Wrap_alloc@V?$allocator@D@std@@@2@XZ 0026 ??$move@AEAU?$_Wrap_alloc@V?$allocator@D@std@@@std@@@std@@YA$$QEAU?$_Wrap_alloc@V?$allocator@D@std@@@0@AEAU10@@Z 0034 ??$?0U?$_Wrap_alloc@V?$allocator@D@std@@@std@@X@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAA@$$QEAU?$_Wrap_alloc@V?$allocator@D@std@@@1@@Z 0044 ?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_N_K@Z 004f ??$forward@V?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@@std@@YA$$QEAV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@0@AEAV10@@Z 005d ?_Assign_rv@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX$$QEAV12@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 4C 24 48 E8 ?? ?? ?? ?? 90 48 8B C8 E8 ?? ?? ?? ?? 90 48 8B D0 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 45 33 C0 33 D2 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 4C 24 48 E8 ?? ?? ?? ?? 90 48 8B D0 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_119_209_1 {
	meta:
		name = "??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEAA@$$QEAV01@@Z"
		size = 108
		refs = "001d ?_Getal@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QEAAAEAU?$_Wrap_alloc@V?$allocator@G@std@@@2@XZ 0026 ??$move@AEAU?$_Wrap_alloc@V?$allocator@G@std@@@std@@@std@@YA$$QEAU?$_Wrap_alloc@V?$allocator@G@std@@@0@AEAU10@@Z 0034 ??$?0U?$_Wrap_alloc@V?$allocator@G@std@@@std@@X@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QEAA@$$QEAU?$_Wrap_alloc@V?$allocator@G@std@@@1@@Z 0044 ?_Tidy@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEAAX_N_K@Z 004f ??$forward@V?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@@std@@YA$$QEAV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@0@AEAV10@@Z 005d ?_Assign_rv@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEAAX$$QEAV12@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 4C 24 48 E8 ?? ?? ?? ?? 90 48 8B C8 E8 ?? ?? ?? ?? 90 48 8B D0 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 45 33 C0 33 D2 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 4C 24 48 E8 ?? ?? ?? ?? 90 48 8B D0 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_119_219_1 {
	meta:
		name = "??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAA@$$QEAV01@@Z"
		size = 108
		refs = "001d ?_Getal@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QEAAAEAU?$_Wrap_alloc@V?$allocator@_W@std@@@2@XZ 0026 ??$move@AEAU?$_Wrap_alloc@V?$allocator@_W@std@@@std@@@std@@YA$$QEAU?$_Wrap_alloc@V?$allocator@_W@std@@@0@AEAU10@@Z 0034 ??$?0U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@X@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QEAA@$$QEAU?$_Wrap_alloc@V?$allocator@_W@std@@@1@@Z 0044 ?_Tidy@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAAX_N_K@Z 004f ??$forward@V?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@@std@@YA$$QEAV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@0@AEAV10@@Z 005d ?_Assign_rv@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAAX$$QEAV12@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 4C 24 48 E8 ?? ?? ?? ?? 90 48 8B C8 E8 ?? ?? ?? ?? 90 48 8B D0 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 45 33 C0 33 D2 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 4C 24 48 E8 ?? ?? ?? ?? 90 48 8B D0 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1_45_1 {
	meta:
		name = "??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@AEBV01@@Z"
		size = 117
		refs = "001d ?_Getal@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEBAAEBU?$_Wrap_alloc@V?$allocator@D@std@@@2@XZ 0030 ?select_on_container_copy_construction@?$_Wrap_alloc@V?$allocator@D@std@@@std@@QEBA?AU12@U_Nil@2@@Z 003d ??$?0U?$_Wrap_alloc@V?$allocator@D@std@@@std@@X@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAA@$$QEAU?$_Wrap_alloc@V?$allocator@D@std@@@1@@Z 004d ?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_N_K@Z 0054 ?npos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@2_KB 0066 ?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@AEBV12@_K1@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 28 FE FF FF FF 48 8B 4C 24 48 E8 ?? ?? ?? ?? 44 0F B6 44 24 20 48 8D 54 24 21 48 8B C8 E8 ?? ?? ?? ?? 48 8B D0 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 45 33 C0 33 D2 48 8B 4C 24 40 E8 ?? ?? ?? ?? 4C 8B 0D ?? ?? ?? ?? 45 33 C0 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_119_210_1 {
	meta:
		name = "??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEAA@AEBV01@@Z"
		size = 117
		refs = "001d ?_Getal@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QEBAAEBU?$_Wrap_alloc@V?$allocator@G@std@@@2@XZ 0030 ?select_on_container_copy_construction@?$_Wrap_alloc@V?$allocator@G@std@@@std@@QEBA?AU12@U_Nil@2@@Z 003d ??$?0U?$_Wrap_alloc@V?$allocator@G@std@@@std@@X@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QEAA@$$QEAU?$_Wrap_alloc@V?$allocator@G@std@@@1@@Z 004d ?_Tidy@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEAAX_N_K@Z 0054 ?npos@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@2_KB 0066 ?assign@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEAAAEAV12@AEBV12@_K1@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 28 FE FF FF FF 48 8B 4C 24 48 E8 ?? ?? ?? ?? 44 0F B6 44 24 20 48 8D 54 24 21 48 8B C8 E8 ?? ?? ?? ?? 48 8B D0 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 45 33 C0 33 D2 48 8B 4C 24 40 E8 ?? ?? ?? ?? 4C 8B 0D ?? ?? ?? ?? 45 33 C0 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_119_220_1 {
	meta:
		name = "??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAA@AEBV01@@Z"
		size = 117
		refs = "001d ?_Getal@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QEBAAEBU?$_Wrap_alloc@V?$allocator@_W@std@@@2@XZ 0030 ?select_on_container_copy_construction@?$_Wrap_alloc@V?$allocator@_W@std@@@std@@QEBA?AU12@U_Nil@2@@Z 003d ??$?0U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@X@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QEAA@$$QEAU?$_Wrap_alloc@V?$allocator@_W@std@@@1@@Z 004d ?_Tidy@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAAX_N_K@Z 0054 ?npos@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@2_KB 0066 ?assign@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAAAEAV12@AEBV12@_K1@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 28 FE FF FF FF 48 8B 4C 24 48 E8 ?? ?? ?? ?? 44 0F B6 44 24 20 48 8D 54 24 21 48 8B C8 E8 ?? ?? ?? ?? 48 8B D0 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 45 33 C0 33 D2 48 8B 4C 24 40 E8 ?? ?? ?? ?? 4C 8B 0D ?? ?? ?? ?? 45 33 C0 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1_47_1 {
	meta:
		name = "??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@PEBD@Z"
		size = 75
		refs = "001d ??0?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAA@XZ 002d ?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_N_K@Z 003c ?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@PEBD@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 45 33 C0 33 D2 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_119_212_1 {
	meta:
		name = "??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEAA@PEBG@Z"
		size = 75
		refs = "001d ??0?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QEAA@XZ 002d ?_Tidy@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEAAX_N_K@Z 003c ?assign@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEAAAEAV12@PEBG@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 45 33 C0 33 D2 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_41_17_1 {
	meta:
		name = "??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAA@PEB_W@Z"
		size = 75
		refs = "001d ??0?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QEAA@XZ 002d ?_Tidy@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAAX_N_K@Z 003c ?assign@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAAAEAV12@PEB_W@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 45 33 C0 33 D2 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1_49_1 {
	meta:
		name = "??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@XZ"
		size = 55
		refs = "0018 ??0?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAA@XZ 0028 ?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_N_K@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 45 33 C0 33 D2 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_119_216_1 {
	meta:
		name = "??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEAA@XZ"
		size = 55
		refs = "0018 ??0?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QEAA@XZ 0028 ?_Tidy@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEAAX_N_K@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 45 33 C0 33 D2 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_119_226_1 {
	meta:
		name = "??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAA@XZ"
		size = 55
		refs = "0018 ??0?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QEAA@XZ 0028 ?_Tidy@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAAX_N_K@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 45 33 C0 33 D2 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1_50_1 {
	meta:
		name = "??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@_KD@Z"
		size = 86
		refs = "0022 ??0?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAA@XZ 0032 ?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_N_K@Z 0047 ?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@_KD@Z"
	strings:
		$1 = { 44 88 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 45 33 C0 33 D2 48 8B 4C 24 40 E8 ?? ?? ?? ?? 44 0F B6 44 24 50 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1_52_1 {
	meta:
		name = "??0?$codecvt@DDU_Mbstatet@@@std@@QEAA@AEBV_Locinfo@1@_K@Z"
		size = 85
		refs = "0027 ??0codecvt_base@std@@QEAA@_K@Z 0034 ??_7?$codecvt@DDU_Mbstatet@@@std@@6B@ 0046 ?_Init@?$codecvt@DDU_Mbstatet@@@std@@IEAAXAEBV_Locinfo@2@@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 54 24 50 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_29_90_3 {
	meta:
		name = "??0?$codecvt@GDU_Mbstatet@@@std@@QEAA@AEBV_Locinfo@1@_K@Z"
		size = 85
		refs = "0027 ??0codecvt_base@std@@QEAA@_K@Z 0034 ??_7?$codecvt@GDU_Mbstatet@@@std@@6B@ 0046 ?_Init@?$codecvt@GDU_Mbstatet@@@std@@IEAAXAEBV_Locinfo@2@@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 54 24 50 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_119_231_1 {
	meta:
		name = "??0?$codecvt@_WDU_Mbstatet@@@std@@QEAA@AEBV_Locinfo@1@_K@Z"
		size = 85
		refs = "0027 ??0codecvt_base@std@@QEAA@_K@Z 0034 ??_7?$codecvt@_WDU_Mbstatet@@@std@@6B@ 0046 ?_Init@?$codecvt@_WDU_Mbstatet@@@std@@IEAAXAEBV_Locinfo@2@@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 54 24 50 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_38_132_3 {
	meta:
		name = "??0?$collate@D@std@@QEAA@AEBV_Locinfo@1@_K@Z"
		size = 85
		refs = "0027 ??0facet@locale@std@@IEAA@_K@Z 0034 ??_7?$collate@D@std@@6B@ 0046 ?_Init@?$collate@D@std@@IEAAXAEBV_Locinfo@2@@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 54 24 50 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_119_233_1 {
	meta:
		name = "??0?$collate@G@std@@QEAA@AEBV_Locinfo@1@_K@Z"
		size = 85
		refs = "0027 ??0facet@locale@std@@IEAA@_K@Z 0034 ??_7?$collate@G@std@@6B@ 0046 ?_Init@?$collate@G@std@@IEAAXAEBV_Locinfo@2@@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 54 24 50 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_119_235_1 {
	meta:
		name = "??0?$collate@_W@std@@QEAA@AEBV_Locinfo@1@_K@Z"
		size = 85
		refs = "0027 ??0facet@locale@std@@IEAA@_K@Z 0034 ??_7?$collate@_W@std@@6B@ 0046 ?_Init@?$collate@_W@std@@IEAAXAEBV_Locinfo@2@@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 54 24 50 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_66_72_2 {
	meta:
		name = "??0?$ctype@D@std@@QEAA@AEBV_Locinfo@1@_K@Z"
		size = 85
		refs = "0027 ??0ctype_base@std@@QEAA@_K@Z 0034 ??_7?$ctype@D@std@@6B@ 0046 ?_Init@?$ctype@D@std@@IEAAXAEBV_Locinfo@2@@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 54 24 50 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_119_237_1 {
	meta:
		name = "??0?$ctype@G@std@@QEAA@AEBV_Locinfo@1@_K@Z"
		size = 85
		refs = "0027 ??0ctype_base@std@@QEAA@_K@Z 0034 ??_7?$ctype@G@std@@6B@ 0046 ?_Init@?$ctype@G@std@@IEAAXAEBV_Locinfo@2@@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 54 24 50 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_86_72_2 {
	meta:
		name = "??0?$ctype@_W@std@@QEAA@AEBV_Locinfo@1@_K@Z"
		size = 85
		refs = "0027 ??0ctype_base@std@@QEAA@_K@Z 0034 ??_7?$ctype@_W@std@@6B@ 0046 ?_Init@?$ctype@_W@std@@IEAAXAEBV_Locinfo@2@@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 54 24 50 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_38_136_3 {
	meta:
		name = "??0?$messages@D@std@@QEAA@AEBV_Locinfo@1@_K@Z"
		size = 85
		refs = "0027 ??0messages_base@std@@QEAA@_K@Z 0034 ??_7?$messages@D@std@@6B@ 0046 ?_Init@?$messages@D@std@@IEAAXAEBV_Locinfo@2@@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 54 24 50 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_103_342_3 {
	meta:
		name = "??0?$messages@G@std@@QEAA@AEBV_Locinfo@1@_K@Z"
		size = 85
		refs = "0027 ??0messages_base@std@@QEAA@_K@Z 0034 ??_7?$messages@G@std@@6B@ 0046 ?_Init@?$messages@G@std@@IEAAXAEBV_Locinfo@2@@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 54 24 50 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_10_298_2 {
	meta:
		name = "??0?$messages@_W@std@@QEAA@AEBV_Locinfo@1@_K@Z"
		size = 85
		refs = "0027 ??0messages_base@std@@QEAA@_K@Z 0034 ??_7?$messages@_W@std@@6B@ 0046 ?_Init@?$messages@_W@std@@IEAAXAEBV_Locinfo@2@@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 54 24 50 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_89_124_2 {
	meta:
		name = "??0?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z"
		size = 85
		refs = "0027 ??0facet@locale@std@@IEAA@_K@Z 0034 ??_7?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@ 0046 ?_Init@?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IEAAXAEBV_Locinfo@2@@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 54 24 50 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_10_300_2 {
	meta:
		name = "??0?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z"
		size = 85
		refs = "0027 ??0facet@locale@std@@IEAA@_K@Z 0034 ??_7?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@ 0046 ?_Init@?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IEAAXAEBV_Locinfo@2@@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 54 24 50 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_119_247_1 {
	meta:
		name = "??0?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z"
		size = 85
		refs = "0027 ??0facet@locale@std@@IEAA@_K@Z 0034 ??_7?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@ 0046 ?_Init@?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IEAAXAEBV_Locinfo@2@@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 54 24 50 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_89_126_2 {
	meta:
		name = "??0?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z"
		size = 85
		refs = "0027 ??0facet@locale@std@@IEAA@_K@Z 0034 ??_7?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@ 0046 ?_Init@?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IEAAXAEBV_Locinfo@2@@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 54 24 50 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_119_249_1 {
	meta:
		name = "??0?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z"
		size = 85
		refs = "0027 ??0facet@locale@std@@IEAA@_K@Z 0034 ??_7?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@ 0046 ?_Init@?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IEAAXAEBV_Locinfo@2@@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 54 24 50 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_10_306_2 {
	meta:
		name = "??0?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z"
		size = 85
		refs = "0027 ??0facet@locale@std@@IEAA@_K@Z 0034 ??_7?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@ 0046 ?_Init@?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IEAAXAEBV_Locinfo@2@@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 54 24 50 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_62_52_1 {
	meta:
		name = "??0?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z"
		size = 85
		refs = "0027 ??0facet@locale@std@@IEAA@_K@Z 0034 ??_7?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@ 0046 ?_Init@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IEAAXAEBV_Locinfo@2@@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 54 24 50 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_103_358_3 {
	meta:
		name = "??0?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z"
		size = 85
		refs = "0027 ??0facet@locale@std@@IEAA@_K@Z 0034 ??_7?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@ 0046 ?_Init@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IEAAXAEBV_Locinfo@2@@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 54 24 50 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_103_360_3 {
	meta:
		name = "??0?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z"
		size = 85
		refs = "0027 ??0facet@locale@std@@IEAA@_K@Z 0034 ??_7?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@ 0046 ?_Init@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IEAAXAEBV_Locinfo@2@@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 54 24 50 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_62_54_1 {
	meta:
		name = "??0?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z"
		size = 85
		refs = "0027 ??0facet@locale@std@@IEAA@_K@Z 0034 ??_7?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@ 0046 ?_Init@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IEAAXAEBV_Locinfo@2@@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 54 24 50 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_119_261_1 {
	meta:
		name = "??0?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z"
		size = 85
		refs = "0027 ??0facet@locale@std@@IEAA@_K@Z 0034 ??_7?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@ 0046 ?_Init@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IEAAXAEBV_Locinfo@2@@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 54 24 50 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_119_263_1 {
	meta:
		name = "??0?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z"
		size = 85
		refs = "0027 ??0facet@locale@std@@IEAA@_K@Z 0034 ??_7?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@ 0046 ?_Init@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IEAAXAEBV_Locinfo@2@@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 54 24 50 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_38_144_3 {
	meta:
		name = "??0?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z"
		size = 85
		refs = "0027 ??0time_base@std@@QEAA@_K@Z 0034 ??_7?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@ 0046 ?_Init@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IEAAXAEBV_Locinfo@2@@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 54 24 50 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_119_269_1 {
	meta:
		name = "??0?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z"
		size = 85
		refs = "0027 ??0time_base@std@@QEAA@_K@Z 0034 ??_7?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@ 0046 ?_Init@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IEAAXAEBV_Locinfo@2@@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 54 24 50 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_119_271_1 {
	meta:
		name = "??0?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z"
		size = 85
		refs = "0027 ??0time_base@std@@QEAA@_K@Z 0034 ??_7?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@ 0046 ?_Init@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IEAAXAEBV_Locinfo@2@@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 54 24 50 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1_56_1 {
	meta:
		name = "??0?$fpos@U_Mbstatet@@@std@@QEAA@U_Mbstatet@@_J@Z"
		size = 61
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 8B 44 24 08 48 C7 00 00 00 00 00 48 8B 44 24 08 48 8B 4C 24 18 48 89 48 08 48 8B 44 24 08 48 8B 4C 24 10 48 89 48 10 48 8B 44 24 08 C3 }
	condition:
		$1
}

rule file_1_57_1 {
	meta:
		name = "??0?$fpos@U_Mbstatet@@@std@@QEAA@_J@Z"
		size = 65
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 57 48 8B 44 24 10 48 8B 4C 24 18 48 89 08 48 8B 44 24 10 48 C7 40 08 00 00 00 00 48 8B 44 24 10 48 83 C0 10 48 8B F8 33 C0 B9 08 00 00 00 F3 AA 48 8B 44 24 10 5F C3 }
	condition:
		$1
}

rule file_1_59_1 {
	meta:
		name = "??0_Facet_base@std@@QEAA@XZ"
		size = 26
		refs = "000d ??_7_Facet_base@std@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 08 C3 }
	condition:
		$1
}

rule file_12_11_4 {
	meta:
		name = "??0DNameNode@@IEAA@XZ"
		size = 26
		refs = "000d ??_7DNameNode@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 08 C3 }
	condition:
		$1
}

rule file_86_109_2 {
	meta:
		name = "??0ios_base@std@@IEAA@XZ"
		size = 26
		refs = "000d ??_7ios_base@std@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 08 C3 }
	condition:
		$1
}

rule file_1_60_1 {
	meta:
		name = "??0_Generic_error_category@std@@QEAA@XZ"
		size = 57
		refs = "000f ??0error_category@std@@QEAA@XZ 001b ??_7_Generic_error_category@std@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 C7 40 08 03 00 00 00 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_61_1 {
	meta:
		name = "??0_Init_cerr@std@@QEAA@XZ"
		size = 109
		refs = "000c ?cerr@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A 0013 ?_Ptr_cerr@std@@3PEAV?$basic_ostream@DU?$char_traits@D@std@@@1@EA 0032 ?_Ptr_cout@std@@3PEAV?$basic_ostream@DU?$char_traits@D@std@@@1@EA 003a ?tie@?$basic_ios@DU?$char_traits@D@std@@@std@@QEAAPEAV?$basic_ostream@DU?$char_traits@D@std@@@2@PEAV32@@Z 005f ?setf@ios_base@std@@QEAAHH@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8D 05 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 63 40 04 48 8D 0D ?? ?? ?? ?? 48 03 C8 48 8B C1 48 8B 15 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 63 40 04 48 8D 0D ?? ?? ?? ?? 48 03 C8 48 8B C1 BA 02 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_99_61_1 {
	meta:
		name = "??0_Init_ushcerr@std@@QEAA@XZ"
		size = 109
		refs = "000c ?wcerr@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A 0013 ?_Ptr_wcerr@std@@3PEAV?$basic_ostream@GU?$char_traits@G@std@@@1@EA 0032 ?_Ptr_wcout@std@@3PEAV?$basic_ostream@GU?$char_traits@G@std@@@1@EA 003a ?tie@?$basic_ios@GU?$char_traits@G@std@@@std@@QEAAPEAV?$basic_ostream@GU?$char_traits@G@std@@@2@PEAV32@@Z 005f ?setf@ios_base@std@@QEAAHH@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8D 05 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 63 40 04 48 8D 0D ?? ?? ?? ?? 48 03 C8 48 8B C1 48 8B 15 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 63 40 04 48 8D 0D ?? ?? ?? ?? 48 03 C8 48 8B C1 BA 02 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_4_61_1 {
	meta:
		name = "??0_Init_wcerr@std@@QEAA@XZ"
		size = 109
		refs = "000c ?wcerr@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 0013 ?_Ptr_wcerr@std@@3PEAV?$basic_ostream@_WU?$char_traits@_W@std@@@1@EA 0032 ?_Ptr_wcout@std@@3PEAV?$basic_ostream@_WU?$char_traits@_W@std@@@1@EA 003a ?tie@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QEAAPEAV?$basic_ostream@_WU?$char_traits@_W@std@@@2@PEAV32@@Z 005f ?setf@ios_base@std@@QEAAHH@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8D 05 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 63 40 04 48 8D 0D ?? ?? ?? ?? 48 03 C8 48 8B C1 48 8B 15 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 63 40 04 48 8D 0D ?? ?? ?? ?? 48 03 C8 48 8B C1 BA 02 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_62_1 {
	meta:
		name = "??0_Iostream_error_category@std@@QEAA@XZ"
		size = 57
		refs = "000f ??0_Generic_error_category@std@@QEAA@XZ 001b ??_7_Iostream_error_category@std@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 C7 40 08 05 00 00 00 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_63_1 {
	meta:
		name = "??0_Locinfo@std@@QEAA@PEBD@Z"
		size = 215
		refs = "0022 ??0_Lockit@std@@QEAA@H@Z 0034 ??0?$_Yarn@D@std@@QEAA@XZ 0058 ??0?$_Yarn@_W@std@@QEAA@XZ 009e ??_C@_0BA@ELKIONDK@bad?5locale?5name?$AA@ 00a8 ??0runtime_error@std@@QEAA@PEBD@Z 00af _TI2?AVruntime_error@std@@ 00b9 _CxxThrowException 00c8 ?_Locinfo_ctor@_Locinfo@std@@SAXPEAV12@PEBD@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 48 C7 44 24 20 FE FF FF FF 48 8B 44 24 50 33 D2 48 8B C8 E8 ?? ?? ?? ?? 90 48 8B 44 24 50 48 83 C0 08 48 8B C8 E8 ?? ?? ?? ?? 90 48 8B 44 24 50 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8B 44 24 50 48 83 C0 28 48 8B C8 E8 ?? ?? ?? ?? 90 48 8B 44 24 50 48 83 C0 38 48 8B C8 E8 ?? ?? ?? ?? 90 48 8B 44 24 50 48 83 C0 48 48 8B C8 E8 ?? ?? ?? ?? 90 48 8B 44 24 50 48 83 C0 58 48 8B C8 E8 ?? ?? ?? ?? 90 48 83 7C 24 58 00 75 22 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8B 54 24 58 48 8B 4C 24 50 E8 ?? ?? ?? ?? 90 48 8B 44 24 50 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_1_64_1 {
	meta:
		name = "?dtor$0@?0???0_Locinfo@std@@QEAA@PEBD@Z@4HA"
		size = 24
		refs = "000e ??1_Lockit@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 50 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_115_323_1 {
	meta:
		name = "?dtor$1@?0??_Makexloc@_Locimp@locale@std@@CAXAEBV_Locinfo@3@HPEAV123@PEBV23@@Z@4HA"
		size = 24
		refs = "000e ??3_Crt_new_delete@std@@SAXPEAX@Z"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 50 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_1_65_1 {
	meta:
		name = "?dtor$1@?0???0_Locinfo@std@@QEAA@PEBD@Z@4HA"
		size = 28
		refs = "0012 ??1?$_Yarn@D@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 50 48 83 C1 08 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_1_66_1 {
	meta:
		name = "?dtor$2@?0???0_Locinfo@std@@QEAA@PEBD@Z@4HA"
		size = 28
		refs = "0012 ??1?$_Yarn@D@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 50 48 83 C1 18 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_1_67_1 {
	meta:
		name = "?dtor$3@?0???0_Locinfo@std@@QEAA@PEBD@Z@4HA"
		size = 28
		refs = "0012 ??1?$_Yarn@_W@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 50 48 83 C1 28 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_1_68_1 {
	meta:
		name = "?dtor$4@?0???0_Locinfo@std@@QEAA@PEBD@Z@4HA"
		size = 28
		refs = "0012 ??1?$_Yarn@_W@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 50 48 83 C1 38 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_1_69_1 {
	meta:
		name = "?dtor$5@?0???0_Locinfo@std@@QEAA@PEBD@Z@4HA"
		size = 28
		refs = "0012 ??1?$_Yarn@D@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 50 48 83 C1 48 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_1_70_1 {
	meta:
		name = "?dtor$6@?0???0_Locinfo@std@@QEAA@PEBD@Z@4HA"
		size = 28
		refs = "0012 ??1?$_Yarn@D@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 50 48 83 C1 58 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_1_71_1 {
	meta:
		name = "??0_System_error@std@@IEAA@Verror_code@1@AEBV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@1@@Z"
		size = 256
		refs = "0024 __security_cookie 004b ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@AEBV01@@Z 007e ?_Makestr@_System_error@std@@CA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@Verror_code@2@V32@@Z 009f ??0runtime_error@std@@QEAA@AEBV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@1@@Z 00ad ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@XZ 00bc ??_7_System_error@std@@6B@ 00f2 __security_check_cookie"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 56 57 48 81 EC B8 00 00 00 48 C7 44 24 40 FE FF FF FF 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 A0 00 00 00 48 8D 44 24 60 48 89 44 24 20 48 8B 94 24 E0 00 00 00 48 8B 4C 24 20 E8 ?? ?? ?? ?? 48 89 44 24 28 48 8D 44 24 50 48 8B F8 48 8B B4 24 D8 00 00 00 B9 10 00 00 00 F3 A4 4C 8B 44 24 28 48 8D 54 24 50 48 8D 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 30 48 8B 44 24 30 48 89 44 24 38 48 8B 54 24 38 48 8B 8C 24 D0 00 00 00 E8 ?? ?? ?? ?? 90 48 8D 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 48 8B 84 24 D0 00 00 00 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 84 24 D0 00 00 00 48 8D 78 18 48 8B B4 24 D8 00 00 00 B9 10 00 00 00 F3 A4 48 8B 84 24 D0 00 00 00 48 8B 8C 24 A0 00 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 B8 00 00 00 5F 5E C3 }
	condition:
		$1
}

rule file_1_72_1 {
	meta:
		name = "?dtor$1@?0???0_System_error@std@@IEAA@Verror_code@1@AEBV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@1@@Z@4HA"
		size = 27
		refs = "0011 ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@XZ"
		altNames = "?dtor$0@?0??do_put@?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@DPEBUtm@@DD@Z@4HA"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 8D 80 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_2_324_3 {
	meta:
		name = "?dtor$0@?0??do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHAEAJ@Z@4HA"
		size = 27
		refs = "0011 ??1locale@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 8D 80 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_2_326_3 {
	meta:
		name = "?dtor$0@?0??do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHAEAK@Z@4HA"
		size = 27
		refs = "0011 ??1locale@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 8D 80 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_2_333_3 {
	meta:
		name = "?dtor$0@?0??do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHAEA_J@Z@4HA"
		size = 27
		refs = "0011 ??1locale@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 8D 80 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_2_335_3 {
	meta:
		name = "?dtor$0@?0??do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHAEA_K@Z@4HA"
		size = 27
		refs = "0011 ??1locale@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 8D 80 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_103_1174_3 {
	meta:
		name = "?dtor$0@?0??do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHAEAJ@Z@4HA"
		size = 27
		refs = "0011 ??1locale@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 8D 80 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_103_1176_3 {
	meta:
		name = "?dtor$0@?0??do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHAEAK@Z@4HA"
		size = 27
		refs = "0011 ??1locale@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 8D 80 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_103_1183_3 {
	meta:
		name = "?dtor$0@?0??do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHAEA_J@Z@4HA"
		size = 27
		refs = "0011 ??1locale@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 8D 80 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_103_1185_3 {
	meta:
		name = "?dtor$0@?0??do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHAEA_K@Z@4HA"
		size = 27
		refs = "0011 ??1locale@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 8D 80 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_103_1197_3 {
	meta:
		name = "?dtor$0@?0??do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHAEAJ@Z@4HA"
		size = 27
		refs = "0011 ??1locale@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 8D 80 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_103_1199_3 {
	meta:
		name = "?dtor$0@?0??do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHAEAK@Z@4HA"
		size = 27
		refs = "0011 ??1locale@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 8D 80 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_103_1206_3 {
	meta:
		name = "?dtor$0@?0??do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHAEA_J@Z@4HA"
		size = 27
		refs = "0011 ??1locale@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 8D 80 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_103_1208_3 {
	meta:
		name = "?dtor$0@?0??do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHAEA_K@Z@4HA"
		size = 27
		refs = "0011 ??1locale@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 8D 80 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_119_1124_1 {
	meta:
		name = "?dtor$0@?0??do_put@?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AEAVios_base@2@GPEBUtm@@DD@Z@4HA"
		size = 27
		refs = "0011 ??1?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 8D 80 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_119_1126_1 {
	meta:
		name = "?dtor$0@?0??do_put@?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AEAVios_base@2@_WPEBUtm@@DD@Z@4HA"
		size = 27
		refs = "0011 ??1?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 8D 80 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_38_559_3 {
	meta:
		name = "?dtor$4@?0??replace@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@V?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@2@0V?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@2@1@Z@4HA"
		size = 27
		refs = "0011 ??1?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 8D 80 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_10_1372_2 {
	meta:
		name = "?dtor$4@?0??replace@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEAAAEAV12@V?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@2@0V?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@2@1@Z@4HA"
		size = 27
		refs = "0011 ??1?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 8D 80 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_10_1381_2 {
	meta:
		name = "?dtor$4@?0??replace@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAAAEAV12@V?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@2@0V?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@2@1@Z@4HA"
		size = 27
		refs = "0011 ??1?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 8D 80 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_1_73_1 {
	meta:
		name = "??0_System_error@std@@QEAA@AEBV01@@Z"
		size = 83
		refs = "001b ??0runtime_error@std@@QEAA@AEBV01@@Z 0027 ??_7_System_error@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 56 57 48 83 EC 28 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 40 48 8B 4C 24 48 48 8D 78 18 48 8D 71 18 B9 10 00 00 00 F3 A4 48 8B 44 24 40 48 83 C4 28 5F 5E C3 }
	condition:
		$1
}

rule file_101_3_1 {
	meta:
		name = "??0future_error@std@@QEAA@AEBV01@@Z"
		size = 83
		refs = "001b ??0logic_error@std@@QEAA@AEBV01@@Z 0027 ??_7future_error@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 56 57 48 83 EC 28 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 40 48 8B 4C 24 48 48 8D 78 18 48 8D 71 18 B9 10 00 00 00 F3 A4 48 8B 44 24 40 48 83 C4 28 5F 5E C3 }
	condition:
		$1
}

rule file_1_78_1 {
	meta:
		name = "??0error_category@std@@QEAA@XZ"
		size = 40
		refs = "000d ??_7error_category@std@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 08 48 8B 4C 24 08 48 89 48 08 48 8B 44 24 08 C3 }
	condition:
		$1
}

rule file_1_79_1 {
	meta:
		name = "??0error_code@std@@QEAA@HAEBVerror_category@1@@Z"
		size = 45
		altNames = "??0error_condition@std@@QEAA@HAEBVerror_category@1@@Z"
	strings:
		$1 = { 4C 89 44 24 18 89 54 24 10 48 89 4C 24 08 48 8B 44 24 08 8B 4C 24 10 89 08 48 8B 44 24 08 48 8B 4C 24 18 48 89 48 08 48 8B 44 24 08 C3 }
	condition:
		$1
}

rule file_1_82_1 {
	meta:
		name = "??0exception@std@@QEAA@QEBD@Z"
		size = 99
		refs = "0017 ??_7exception@std@@6B@ 0054 __std_exception_copy"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 57 48 83 EC 30 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 40 48 83 C0 08 48 8B F8 33 C0 B9 10 00 00 00 F3 AA 48 8B 44 24 48 48 89 44 24 20 C6 44 24 28 01 48 8B 44 24 40 48 83 C0 08 48 8B D0 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 40 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_1_84_1 {
	meta:
		name = "??0facet@locale@std@@IEAA@_K@Z"
		size = 81
		refs = "001d ??0_Facet_base@std@@QEAA@XZ 002a ??_7facet@locale@std@@6B@ 0042 ?_Init_atomic_counter@std@@YAXAEAKK@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 40 48 83 C0 08 8B 54 24 48 48 8B C8 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1_87_1 {
	meta:
		name = "??0failure@ios_base@std@@QEAA@PEBDAEBVerror_code@2@@Z"
		size = 88
		refs = "0039 ??0system_error@std@@QEAA@Verror_code@1@PEBD@Z 0045 ??_7failure@ios_base@std@@6B@"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 56 57 48 83 EC 38 48 8D 44 24 20 48 8B F8 48 8B 74 24 60 B9 10 00 00 00 F3 A4 4C 8B 44 24 58 48 8D 54 24 20 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 50 48 83 C4 38 5F 5E C3 }
	condition:
		$1
}

rule file_1_90_1 {
	meta:
		name = "??0locale@std@@QEAA@AEBV01@@Z"
		size = 110
		refs = "0052 _guard_check_icall"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 48 C7 44 24 30 FE FF FF FF 48 8B 44 24 50 48 8B 4C 24 58 48 8B 49 08 48 89 48 08 48 8B 44 24 50 48 8B 40 08 48 8B 4C 24 50 48 8B 49 08 48 89 4C 24 28 48 8B 00 48 8B 40 08 48 89 44 24 20 48 8B 4C 24 20 E8 ?? ?? ?? ?? 90 48 8B 44 24 28 48 8B C8 FF 54 24 20 90 48 8B 44 24 50 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_1_91_1 {
	meta:
		name = "??0locale@std@@QEAA@XZ"
		size = 45
		refs = "0015 ?_Init@locale@std@@CAPEAV_Locimp@12@_N@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF B1 01 E8 ?? ?? ?? ?? 90 48 8B 4C 24 40 48 89 41 08 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1_93_1 {
	meta:
		name = "??0runtime_error@std@@QEAA@AEBV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@1@@Z"
		size = 62
		refs = "0014 ?c_str@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBAPEBDXZ 0021 ??0exception@std@@QEAA@QEBD@Z 002d ??_7runtime_error@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B D0 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_96_1 {
	meta:
		name = "??0system_error@std@@QEAA@Verror_code@1@PEBD@Z"
		size = 167
		refs = "0021 __security_cookie 003b ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@PEBD@Z 006a ??0_System_error@std@@IEAA@Verror_code@1@AEBV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@1@@Z 0075 ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@XZ 0084 ??_7system_error@std@@6B@ 009c __security_check_cookie"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 56 57 48 83 EC 78 48 C7 44 24 20 FE FF FF FF 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 60 48 8B 94 24 A0 00 00 00 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8D 44 24 30 48 8B F8 48 8B B4 24 98 00 00 00 B9 10 00 00 00 F3 A4 4C 8D 44 24 40 48 8D 54 24 30 48 8B 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 48 8B 84 24 90 00 00 00 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 84 24 90 00 00 00 48 8B 4C 24 60 48 33 CC E8 ?? ?? ?? ?? 48 83 C4 78 5F 5E C3 }
	condition:
		$1
}

rule file_1_97_1 {
	meta:
		name = "?dtor$0@?0???0system_error@std@@QEAA@Verror_code@1@PEBD@Z@4HA"
		size = 24
		refs = "000e ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@XZ"
		altNames = "?dtor$0@?0???0system_error@std@@QEAA@Verror_code@1@@Z@4HA ?dtor$1@?0??_Makestr@_System_error@std@@CA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@Verror_code@2@V32@@Z@4HA"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_3_359_1 {
	meta:
		name = "?dtor$0@?0??widen@?$basic_ios@DU?$char_traits@D@std@@@std@@QEBADD@Z@4HA"
		size = 24
		refs = "000e ??1locale@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_29_441_3 {
	meta:
		name = "?dtor$0@?0??widen@?$basic_ios@GU?$char_traits@G@std@@@std@@QEBAGD@Z@4HA"
		size = 24
		refs = "000e ??1locale@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_48_418_2 {
	meta:
		name = "?dtor$0@?0??widen@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QEBA_WD@Z@4HA"
		size = 24
		refs = "000e ??1locale@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_1_98_1 {
	meta:
		name = "??1?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@D@std@@@std@@V?$_String_val@U?$_Simple_types@D@std@@@2@$00@std@@QEAA@XZ"
		size = 27
		refs = "0012 ??1?$_String_val@U?$_Simple_types@D@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_119_309_1 {
	meta:
		name = "??1?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@G@std@@@std@@V?$_String_val@U?$_Simple_types@G@std@@@2@$00@std@@QEAA@XZ"
		size = 27
		refs = "0012 ??1?$_String_val@U?$_Simple_types@G@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_103_415_3 {
	meta:
		name = "??1?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@V?$_String_val@U?$_Simple_types@_W@std@@@2@$00@std@@QEAA@XZ"
		size = 27
		refs = "0012 ??1?$_String_val@U?$_Simple_types@_W@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_67_48_1 {
	meta:
		name = "??1?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAA@XZ"
		size = 27
		refs = "0012 ??1?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@D@std@@@std@@V?$_String_val@U?$_Simple_types@D@std@@@2@$00@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_119_314_1 {
	meta:
		name = "??1?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QEAA@XZ"
		size = 27
		refs = "0012 ??1?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@G@std@@@std@@V?$_String_val@U?$_Simple_types@G@std@@@2@$00@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_41_21_1 {
	meta:
		name = "??1?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QEAA@XZ"
		size = 27
		refs = "0012 ??1?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@V?$_String_val@U?$_Simple_types@_W@std@@@2@$00@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_105_56_1 {
	meta:
		name = "??1?$_String_val@U?$_Simple_types@D@std@@@std@@QEAA@XZ"
		size = 27
		refs = "0012 ??1_Bxty@?$_String_val@U?$_Simple_types@D@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_119_317_1 {
	meta:
		name = "??1?$_String_val@U?$_Simple_types@G@std@@@std@@QEAA@XZ"
		size = 27
		refs = "0012 ??1_Bxty@?$_String_val@U?$_Simple_types@G@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_41_22_1 {
	meta:
		name = "??1?$_String_val@U?$_Simple_types@_W@std@@@std@@QEAA@XZ"
		size = 27
		refs = "0012 ??1_Bxty@?$_String_val@U?$_Simple_types@_W@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_101_219_2 {
	meta:
		name = "?_Get_data@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAAAEAV?$_String_val@U?$_Simple_types@D@std@@@2@XZ"
		size = 27
		refs = "0012 ?_Get_second@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@D@std@@@std@@V?$_String_val@U?$_Simple_types@D@std@@@2@$00@std@@QEAAAEAV?$_String_val@U?$_Simple_types@D@std@@@2@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_4_188_1 {
	meta:
		name = "?_Get_data@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEBAAEBV?$_String_val@U?$_Simple_types@D@std@@@2@XZ"
		size = 27
		refs = "0012 ?_Get_second@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@D@std@@@std@@V?$_String_val@U?$_Simple_types@D@std@@@2@$00@std@@QEBAAEBV?$_String_val@U?$_Simple_types@D@std@@@2@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_10_635_2 {
	meta:
		name = "?_Get_data@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QEAAAEAV?$_String_val@U?$_Simple_types@G@std@@@2@XZ"
		size = 27
		refs = "0012 ?_Get_second@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@G@std@@@std@@V?$_String_val@U?$_Simple_types@G@std@@@2@$00@std@@QEAAAEAV?$_String_val@U?$_Simple_types@G@std@@@2@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_10_636_2 {
	meta:
		name = "?_Get_data@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QEBAAEBV?$_String_val@U?$_Simple_types@G@std@@@2@XZ"
		size = 27
		refs = "0012 ?_Get_second@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@G@std@@@std@@V?$_String_val@U?$_Simple_types@G@std@@@2@$00@std@@QEBAAEBV?$_String_val@U?$_Simple_types@G@std@@@2@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_41_49_1 {
	meta:
		name = "?_Get_data@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QEAAAEAV?$_String_val@U?$_Simple_types@_W@std@@@2@XZ"
		size = 27
		refs = "0012 ?_Get_second@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@V?$_String_val@U?$_Simple_types@_W@std@@@2@$00@std@@QEAAAEAV?$_String_val@U?$_Simple_types@_W@std@@@2@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_103_687_3 {
	meta:
		name = "?_Get_data@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QEBAAEBV?$_String_val@U?$_Simple_types@_W@std@@@2@XZ"
		size = 27
		refs = "0012 ?_Get_second@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@V?$_String_val@U?$_Simple_types@_W@std@@@2@$00@std@@QEBAAEBV?$_String_val@U?$_Simple_types@_W@std@@@2@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_50_121_3 {
	meta:
		name = "?_Getal@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAAAEAU?$_Wrap_alloc@V?$allocator@D@std@@@2@XZ"
		size = 27
		refs = "0012 ?_Get_first@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@D@std@@@std@@V?$_String_val@U?$_Simple_types@D@std@@@2@$00@std@@QEAAAEAU?$_Wrap_alloc@V?$allocator@D@std@@@2@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_54_124_3 {
	meta:
		name = "?_Getal@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEBAAEBU?$_Wrap_alloc@V?$allocator@D@std@@@2@XZ"
		size = 27
		refs = "0012 ?_Get_first@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@D@std@@@std@@V?$_String_val@U?$_Simple_types@D@std@@@2@$00@std@@QEBAAEBU?$_Wrap_alloc@V?$allocator@D@std@@@2@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_119_571_1 {
	meta:
		name = "?_Getal@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QEAAAEAU?$_Wrap_alloc@V?$allocator@G@std@@@2@XZ"
		size = 27
		refs = "0012 ?_Get_first@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@G@std@@@std@@V?$_String_val@U?$_Simple_types@G@std@@@2@$00@std@@QEAAAEAU?$_Wrap_alloc@V?$allocator@G@std@@@2@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_103_703_3 {
	meta:
		name = "?_Getal@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QEBAAEBU?$_Wrap_alloc@V?$allocator@G@std@@@2@XZ"
		size = 27
		refs = "0012 ?_Get_first@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@G@std@@@std@@V?$_String_val@U?$_Simple_types@G@std@@@2@$00@std@@QEBAAEBU?$_Wrap_alloc@V?$allocator@G@std@@@2@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_104_59_3 {
	meta:
		name = "?_Getal@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QEAAAEAU?$_Wrap_alloc@V?$allocator@_W@std@@@2@XZ"
		size = 27
		refs = "0012 ?_Get_first@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@V?$_String_val@U?$_Simple_types@_W@std@@@2@$00@std@@QEAAAEAU?$_Wrap_alloc@V?$allocator@_W@std@@@2@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_103_705_3 {
	meta:
		name = "?_Getal@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QEBAAEBU?$_Wrap_alloc@V?$allocator@_W@std@@@2@XZ"
		size = 27
		refs = "0012 ?_Get_first@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@V?$_String_val@U?$_Simple_types@_W@std@@@2@$00@std@@QEBAAEBU?$_Wrap_alloc@V?$allocator@_W@std@@@2@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_102_1 {
	meta:
		name = "??1?$_Yarn@D@std@@QEAA@XZ"
		size = 34
		refs = "0018 ?_Tidy@?$_Yarn@D@std@@AEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_40_126_2 {
	meta:
		name = "??1?$_Yarn@_W@std@@QEAA@XZ"
		size = 34
		refs = "0018 ?_Tidy@?$_Yarn@_W@std@@AEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_60_51_3 {
	meta:
		name = "??1?$shared_ptr@V__ExceptionPtr@@@std@@QEAA@XZ"
		size = 34
		refs = "0018 ?_Decref@?$_Ptr_base@V__ExceptionPtr@@@std@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_46_143_3 {
	meta:
		name = "??1_Container_base12@std@@QEAA@XZ"
		size = 34
		refs = "0018 ?_Orphan_all@_Container_base12@std@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_50_162_3 {
	meta:
		name = "?c_str@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBAPEBDXZ"
		size = 34
		refs = "0018 ?_Myptr@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEBAPEBDXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_103_1115_3 {
	meta:
		name = "?c_str@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEBAPEBGXZ"
		size = 34
		refs = "0018 ?_Myptr@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QEBAPEBGXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_61_126_2 {
	meta:
		name = "?c_str@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEBAPEB_WXZ"
		size = 34
		refs = "0018 ?_Myptr@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QEBAPEB_WXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1_104_1 {
	meta:
		name = "??1?$basic_filebuf@DU?$char_traits@D@std@@@std@@UEAA@XZ"
		size = 99
		refs = "001a ??_7?$basic_filebuf@DU?$char_traits@D@std@@@std@@6B@ 0036 ?_Reset_back@?$basic_filebuf@DU?$char_traits@D@std@@@std@@AEAAXXZ 004e ?close@?$basic_filebuf@DU?$char_traits@D@std@@@std@@QEAAPEAV12@XZ 0059 ??1?$basic_streambuf@DU?$char_traits@D@std@@@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 40 48 83 B8 80 00 00 00 00 74 0B 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 0F B6 40 7C 85 C0 74 0B 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_40_127_2 {
	meta:
		name = "??1?$basic_filebuf@GU?$char_traits@G@std@@@std@@UEAA@XZ"
		size = 99
		refs = "001a ??_7?$basic_filebuf@GU?$char_traits@G@std@@@std@@6B@ 0036 ?_Reset_back@?$basic_filebuf@GU?$char_traits@G@std@@@std@@AEAAXXZ 004e ?close@?$basic_filebuf@GU?$char_traits@G@std@@@std@@QEAAPEAV12@XZ 0059 ??1?$basic_streambuf@GU?$char_traits@G@std@@@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 40 48 83 B8 80 00 00 00 00 74 0B 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 0F B6 40 7C 85 C0 74 0B 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_116_147_3 {
	meta:
		name = "??1?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UEAA@XZ"
		size = 99
		refs = "001a ??_7?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@6B@ 0036 ?_Reset_back@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@AEAAXXZ 004e ?close@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@QEAAPEAV12@XZ 0059 ??1?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 40 48 83 B8 80 00 00 00 00 74 0B 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 0F B6 40 7C 85 C0 74 0B 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1_105_1 {
	meta:
		name = "??1?$basic_ios@DU?$char_traits@D@std@@@std@@UEAA@XZ"
		size = 39
		refs = "0011 ??_7?$basic_ios@DU?$char_traits@D@std@@@std@@6B@ 001e ??1ios_base@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_99_104_1 {
	meta:
		name = "??1?$basic_ios@GU?$char_traits@G@std@@@std@@UEAA@XZ"
		size = 39
		refs = "0011 ??_7?$basic_ios@GU?$char_traits@G@std@@@std@@6B@ 001e ??1ios_base@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_114_104_1 {
	meta:
		name = "??1?$basic_ios@_WU?$char_traits@_W@std@@@std@@UEAA@XZ"
		size = 39
		refs = "0011 ??_7?$basic_ios@_WU?$char_traits@_W@std@@@std@@6B@ 001e ??1ios_base@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_47_140_3 {
	meta:
		name = "??1?$codecvt@DDU_Mbstatet@@@std@@MEAA@XZ"
		size = 39
		refs = "0011 ??_7?$codecvt@DDU_Mbstatet@@@std@@6B@ 001e ??1codecvt_base@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_41_132_2 {
	meta:
		name = "??1?$codecvt@GDU_Mbstatet@@@std@@MEAA@XZ"
		size = 39
		refs = "0011 ??_7?$codecvt@GDU_Mbstatet@@@std@@6B@ 001e ??1codecvt_base@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_63_108_1 {
	meta:
		name = "??1?$codecvt@_WDU_Mbstatet@@@std@@MEAA@XZ"
		size = 39
		refs = "0011 ??_7?$codecvt@_WDU_Mbstatet@@@std@@6B@ 001e ??1codecvt_base@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_115_141_1 {
	meta:
		name = "??1?$messages@D@std@@MEAA@XZ"
		size = 39
		refs = "0011 ??_7?$messages@D@std@@6B@ 001e ??1messages_base@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_10_395_2 {
	meta:
		name = "??1?$messages@G@std@@MEAA@XZ"
		size = 39
		refs = "0011 ??_7?$messages@G@std@@6B@ 001e ??1messages_base@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_10_396_2 {
	meta:
		name = "??1?$messages@_W@std@@MEAA@XZ"
		size = 39
		refs = "0011 ??_7?$messages@_W@std@@6B@ 001e ??1messages_base@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_38_192_3 {
	meta:
		name = "??1?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEAA@XZ"
		size = 39
		refs = "0011 ??_7?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@ 001e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_10_397_2 {
	meta:
		name = "??1?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEAA@XZ"
		size = 39
		refs = "0011 ??_7?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@ 001e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_103_444_3 {
	meta:
		name = "??1?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEAA@XZ"
		size = 39
		refs = "0011 ??_7?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@ 001e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_89_179_2 {
	meta:
		name = "??1?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEAA@XZ"
		size = 39
		refs = "0011 ??_7?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@ 001e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_10_399_2 {
	meta:
		name = "??1?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEAA@XZ"
		size = 39
		refs = "0011 ??_7?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@ 001e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_103_446_3 {
	meta:
		name = "??1?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEAA@XZ"
		size = 39
		refs = "0011 ??_7?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@ 001e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_115_144_1 {
	meta:
		name = "??1?$moneypunct@D$00@std@@MEAA@XZ"
		size = 39
		refs = "0011 ??_7?$moneypunct@D$00@std@@6B@ 001e ??1?$_Mpunct@D@std@@MEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_115_145_1 {
	meta:
		name = "??1?$moneypunct@D$0A@@std@@MEAA@XZ"
		size = 39
		refs = "0011 ??_7?$moneypunct@D$0A@@std@@6B@ 001e ??1?$_Mpunct@D@std@@MEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_103_447_3 {
	meta:
		name = "??1?$moneypunct@G$00@std@@MEAA@XZ"
		size = 39
		refs = "0011 ??_7?$moneypunct@G$00@std@@6B@ 001e ??1?$_Mpunct@G@std@@MEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_119_337_1 {
	meta:
		name = "??1?$moneypunct@G$0A@@std@@MEAA@XZ"
		size = 39
		refs = "0011 ??_7?$moneypunct@G$0A@@std@@6B@ 001e ??1?$_Mpunct@G@std@@MEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_119_338_1 {
	meta:
		name = "??1?$moneypunct@_W$00@std@@MEAA@XZ"
		size = 39
		refs = "0011 ??_7?$moneypunct@_W$00@std@@6B@ 001e ??1?$_Mpunct@_W@std@@MEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_119_339_1 {
	meta:
		name = "??1?$moneypunct@_W$0A@@std@@MEAA@XZ"
		size = 39
		refs = "0011 ??_7?$moneypunct@_W$0A@@std@@6B@ 001e ??1?$_Mpunct@_W@std@@MEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_62_90_1 {
	meta:
		name = "??1?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEAA@XZ"
		size = 39
		refs = "0011 ??_7?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@ 001e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_10_405_2 {
	meta:
		name = "??1?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEAA@XZ"
		size = 39
		refs = "0011 ??_7?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@ 001e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_103_452_3 {
	meta:
		name = "??1?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEAA@XZ"
		size = 39
		refs = "0011 ??_7?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@ 001e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_2_117_3 {
	meta:
		name = "??1?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEAA@XZ"
		size = 39
		refs = "0011 ??_7?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@ 001e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_103_453_3 {
	meta:
		name = "??1?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEAA@XZ"
		size = 39
		refs = "0011 ??_7?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@ 001e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_10_408_2 {
	meta:
		name = "??1?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEAA@XZ"
		size = 39
		refs = "0011 ??_7?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@ 001e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_88_143_2 {
	meta:
		name = "??1codecvt_base@std@@UEAA@XZ"
		size = 39
		refs = "0011 ??_7codecvt_base@std@@6B@ 001e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_8_164_3 {
	meta:
		name = "??1ctype_base@std@@UEAA@XZ"
		size = 39
		refs = "0011 ??_7ctype_base@std@@6B@ 001e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_8_167_3 {
	meta:
		name = "??1facet@locale@std@@MEAA@XZ"
		size = 39
		refs = "0011 ??_7facet@locale@std@@6B@ 001e ??1_Facet_base@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_10_432_2 {
	meta:
		name = "??1time_base@std@@UEAA@XZ"
		size = 39
		refs = "0011 ??_7time_base@std@@6B@ 001e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_106_1 {
	meta:
		name = "??1?$basic_ostream@DU?$char_traits@D@std@@@std@@UEAA@XZ"
		size = 75
		refs = "001a ??_7?$basic_ostream@DU?$char_traits@D@std@@@std@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8B 40 F0 48 63 40 04 48 8B 4C 24 08 48 8D 15 ?? ?? ?? ?? 48 89 54 01 F0 48 8B 44 24 08 48 8B 40 F0 48 63 40 04 48 83 E8 10 48 8B 4C 24 08 48 8B 49 F0 48 63 49 04 48 8B 54 24 08 89 44 0A EC C3 }
	condition:
		$1
}

rule file_5_105_1 {
	meta:
		name = "??1?$basic_ostream@GU?$char_traits@G@std@@@std@@UEAA@XZ"
		size = 75
		refs = "001a ??_7?$basic_ostream@GU?$char_traits@G@std@@@std@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8B 40 F0 48 63 40 04 48 8B 4C 24 08 48 8D 15 ?? ?? ?? ?? 48 89 54 01 F0 48 8B 44 24 08 48 8B 40 F0 48 63 40 04 48 83 E8 10 48 8B 4C 24 08 48 8B 49 F0 48 63 49 04 48 8B 54 24 08 89 44 0A EC C3 }
	condition:
		$1
}

rule file_114_105_1 {
	meta:
		name = "??1?$basic_ostream@_WU?$char_traits@_W@std@@@std@@UEAA@XZ"
		size = 75
		refs = "001a ??_7?$basic_ostream@_WU?$char_traits@_W@std@@@std@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8B 40 F0 48 63 40 04 48 8B 4C 24 08 48 8D 15 ?? ?? ?? ?? 48 89 54 01 F0 48 8B 44 24 08 48 8B 40 F0 48 63 40 04 48 83 E8 10 48 8B 4C 24 08 48 8B 49 F0 48 63 49 04 48 8B 54 24 08 89 44 0A EC C3 }
	condition:
		$1
}

rule file_1_107_1 {
	meta:
		name = "??1?$basic_streambuf@DU?$char_traits@D@std@@@std@@UEAA@XZ"
		size = 92
		refs = "0011 ??_7?$basic_streambuf@DU?$char_traits@D@std@@@std@@6B@ 0043 ??_Glocale@std@@QEAAPEAXI@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 48 48 8B 44 24 50 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 50 48 8B 40 60 48 89 44 24 28 48 8B 44 24 28 48 89 44 24 20 48 83 7C 24 20 00 74 16 BA 01 00 00 00 48 8B 4C 24 20 E8 ?? ?? ?? ?? 48 89 44 24 30 EB 09 48 C7 44 24 30 00 00 00 00 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_40_130_2 {
	meta:
		name = "??1?$basic_streambuf@GU?$char_traits@G@std@@@std@@UEAA@XZ"
		size = 92
		refs = "0011 ??_7?$basic_streambuf@GU?$char_traits@G@std@@@std@@6B@ 0043 ??_Glocale@std@@QEAAPEAXI@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 48 48 8B 44 24 50 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 50 48 8B 40 60 48 89 44 24 28 48 8B 44 24 28 48 89 44 24 20 48 83 7C 24 20 00 74 16 BA 01 00 00 00 48 8B 4C 24 20 E8 ?? ?? ?? ?? 48 89 44 24 30 EB 09 48 C7 44 24 30 00 00 00 00 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_116_150_3 {
	meta:
		name = "??1?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@UEAA@XZ"
		size = 92
		refs = "0011 ??_7?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@6B@ 0043 ??_Glocale@std@@QEAAPEAXI@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 48 48 8B 44 24 50 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 50 48 8B 40 60 48 89 44 24 28 48 8B 44 24 28 48 89 44 24 20 48 83 7C 24 20 00 74 16 BA 01 00 00 00 48 8B 4C 24 20 E8 ?? ?? ?? ?? 48 89 44 24 30 EB 09 48 C7 44 24 30 00 00 00 00 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_1_108_1 {
	meta:
		name = "??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@XZ"
		size = 50
		refs = "001d ?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_N_K@Z 0028 ??1?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 45 33 C0 B2 01 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_119_322_1 {
	meta:
		name = "??1?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEAA@XZ"
		size = 50
		refs = "001d ?_Tidy@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEAAX_N_K@Z 0028 ??1?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 45 33 C0 B2 01 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_41_23_1 {
	meta:
		name = "??1?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAA@XZ"
		size = 50
		refs = "001d ?_Tidy@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAAX_N_K@Z 0028 ??1?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 45 33 C0 B2 01 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1_110_1 {
	meta:
		name = "??1?$ctype@D@std@@MEAA@XZ"
		size = 60
		refs = "001a ??_7?$ctype@D@std@@6B@ 0027 ?_Tidy@?$ctype@D@std@@IEAAXXZ 0032 ??1ctype_base@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_115_133_1 {
	meta:
		name = "??1?$_Mpunct@D@std@@MEAA@XZ"
		size = 60
		refs = "001a ??_7?$_Mpunct@D@std@@6B@ 0027 ?_Tidy@?$_Mpunct@D@std@@AEAAXXZ 0032 ??1money_base@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_103_418_3 {
	meta:
		name = "??1?$_Mpunct@G@std@@MEAA@XZ"
		size = 60
		refs = "001a ??_7?$_Mpunct@G@std@@6B@ 0027 ?_Tidy@?$_Mpunct@G@std@@AEAAXXZ 0032 ??1money_base@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_103_419_3 {
	meta:
		name = "??1?$_Mpunct@_W@std@@MEAA@XZ"
		size = 60
		refs = "001a ??_7?$_Mpunct@_W@std@@6B@ 0027 ?_Tidy@?$_Mpunct@_W@std@@AEAAXXZ 0032 ??1money_base@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_62_92_1 {
	meta:
		name = "??1?$numpunct@D@std@@MEAA@XZ"
		size = 60
		refs = "001a ??_7?$numpunct@D@std@@6B@ 0027 ?_Tidy@?$numpunct@D@std@@AEAAXXZ 0032 ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_10_409_2 {
	meta:
		name = "??1?$numpunct@G@std@@MEAA@XZ"
		size = 60
		refs = "001a ??_7?$numpunct@G@std@@6B@ 0027 ?_Tidy@?$numpunct@G@std@@AEAAXXZ 0032 ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_103_456_3 {
	meta:
		name = "??1?$numpunct@_W@std@@MEAA@XZ"
		size = 60
		refs = "001a ??_7?$numpunct@_W@std@@6B@ 0027 ?_Tidy@?$numpunct@_W@std@@AEAAXXZ 0032 ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_89_182_2 {
	meta:
		name = "??1?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEAA@XZ"
		size = 60
		refs = "001a ??_7?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@ 0027 ?_Tidy@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEAAXXZ 0032 ??1time_base@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_103_457_3 {
	meta:
		name = "??1?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEAA@XZ"
		size = 60
		refs = "001a ??_7?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@ 0027 ?_Tidy@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@AEAAXXZ 0032 ??1time_base@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_10_412_2 {
	meta:
		name = "??1?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEAA@XZ"
		size = 60
		refs = "001a ??_7?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@ 0027 ?_Tidy@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@AEAAXXZ 0032 ??1time_base@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1_115_1 {
	meta:
		name = "??1_Locinfo@std@@QEAA@XZ"
		size = 156
		refs = "0018 ?_Locinfo_dtor@_Locinfo@std@@SAXPEAV12@@Z 002a ??1?$_Yarn@D@std@@QEAA@XZ 004e ??1?$_Yarn@_W@std@@QEAA@XZ 0092 ??1_Lockit@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 C0 58 48 8B C8 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 C0 48 48 8B C8 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 C0 38 48 8B C8 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 C0 28 48 8B C8 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 C0 08 48 8B C8 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 8B C8 E8 ?? ?? ?? ?? 90 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1_124_1 {
	meta:
		name = "??1ios_base@std@@UEAA@XZ"
		size = 49
		refs = "001a ??_7ios_base@std@@6B@ 0027 ?_Ios_base_dtor@ios_base@std@@CAXPEAV12@@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1_125_1 {
	meta:
		name = "??1locale@std@@QEAA@XZ"
		size = 179
		refs = "004b _guard_check_icall"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 68 48 C7 44 24 50 FE FF FF FF 48 8B 44 24 70 48 83 78 08 00 0F 84 8C 00 00 00 48 8B 44 24 70 48 8B 40 08 48 8B 4C 24 70 48 8B 49 08 48 89 4C 24 38 48 8B 00 48 8B 40 10 48 89 44 24 28 48 8B 4C 24 28 E8 ?? ?? ?? ?? 90 48 8B 44 24 38 48 8B C8 FF 54 24 28 90 48 89 44 24 40 48 8B 44 24 40 48 89 44 24 20 48 83 7C 24 20 00 74 31 48 8B 44 24 20 48 8B 00 48 8B 00 48 89 44 24 30 48 8B 4C 24 30 E8 ?? ?? ?? ?? 90 BA 01 00 00 00 48 8B 4C 24 20 FF 54 24 30 90 48 89 44 24 48 EB 09 48 C7 44 24 48 00 00 00 00 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_1_128_1 {
	meta:
		name = "??2@YAPEAX_KPEAX@Z"
		size = 16
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 8B 44 24 10 C3 }
	condition:
		$1
}

rule file_1_129_1 {
	meta:
		name = "??2_Crt_new_delete@std@@SAPEAX_K@Z"
		size = 54
		refs = "000c ?nothrow@std@@3Unothrow_t@1@B 0016 ??2_Crt_new_delete@std@@SAPEAX_KAEBUnothrow_t@1@@Z 0028 ?_Xbad_alloc@std@@YAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8D 15 ?? ?? ?? ?? 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 89 44 24 20 48 83 7C 24 20 00 75 05 E8 ?? ?? ?? ?? 48 8B 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1_130_1 {
	meta:
		name = "??2_Crt_new_delete@std@@SAPEAX_KAEBUnothrow_t@1@@Z"
		size = 76
		refs = "0034 ??_C@_0CI@FIAODHFJ@f?3?2dd?2vctools?2crt?2crtw32?2stdhpp?2@ 0043 _malloc_dbg"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 83 7C 24 40 00 76 0C 48 8B 44 24 40 48 89 44 24 20 EB 09 48 C7 44 24 20 01 00 00 00 41 B9 4A 00 00 00 4C 8D 05 ?? ?? ?? ?? BA 02 00 00 00 48 8B 4C 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1_132_1 {
	meta:
		name = "??8error_category@std@@QEBA_NAEBV01@@Z"
		size = 59
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 18 48 8B 44 24 20 48 8B 4C 24 28 48 8B 49 08 48 39 48 08 75 09 C7 04 24 01 00 00 00 EB 07 C7 04 24 00 00 00 00 0F B6 04 24 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_1_133_1 {
	meta:
		name = "??8std@@YA_NAEBVerror_condition@0@0@Z"
		size = 122
		refs = "0014 ?category@error_condition@std@@QEBAAEBVerror_category@2@XZ 0033 ??8error_category@std@@QEBA_NAEBV01@@Z 0044 ?value@error_condition@std@@QEBAHXZ"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 4C 24 48 E8 ?? ?? ?? ?? 48 89 44 24 28 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 4C 24 28 48 8B D1 48 8B C8 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 2A 48 8B 4C 24 40 E8 ?? ?? ?? ?? 89 44 24 24 48 8B 4C 24 48 E8 ?? ?? ?? ?? 8B 4C 24 24 3B C8 75 0A C7 44 24 20 01 00 00 00 EB 08 C7 44 24 20 00 00 00 00 0F B6 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1_134_1 {
	meta:
		name = "??B?$fpos@U_Mbstatet@@@std@@QEBA_JXZ"
		size = 23
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8B 00 48 8B 4C 24 08 48 03 41 08 C3 }
	condition:
		$1
}

rule file_1_135_1 {
	meta:
		name = "??Bid@locale@std@@QEAA_KXZ"
		size = 95
		refs = "001c ??0_Lockit@std@@QEAA@H@Z 002d ?_Id_cnt@id@locale@std@@0HA 004e ??1_Lockit@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 48 83 38 00 75 3E 33 D2 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 40 48 83 38 00 75 1D 8B 05 ?? ?? ?? ?? FF C0 89 05 ?? ?? ?? ?? 48 63 05 ?? ?? ?? ?? 48 8B 4C 24 40 48 89 01 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 40 48 8B 00 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1_138_1 {
	meta:
		name = "??_D?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAXXZ"
		size = 48
		refs = "0016 ??1?$basic_ostream@DU?$char_traits@D@std@@@std@@UEAA@XZ 0027 ??1?$basic_ios@DU?$char_traits@D@std@@@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 83 C0 10 48 8B C8 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C0 10 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_5_137_1 {
	meta:
		name = "??_D?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAXXZ"
		size = 48
		refs = "0016 ??1?$basic_ostream@GU?$char_traits@G@std@@@std@@UEAA@XZ 0027 ??1?$basic_ios@GU?$char_traits@G@std@@@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 83 C0 10 48 8B C8 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C0 10 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_114_137_1 {
	meta:
		name = "??_D?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAXXZ"
		size = 48
		refs = "0016 ??1?$basic_ostream@_WU?$char_traits@_W@std@@@std@@UEAA@XZ 0027 ??1?$basic_ios@_WU?$char_traits@_W@std@@@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 83 C0 10 48 8B C8 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C0 10 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_140_1 {
	meta:
		name = "??_G?$basic_filebuf@DU?$char_traits@D@std@@@std@@UEAAPEAXI@Z"
		size = 59
		refs = "0013 ??1?$basic_filebuf@DU?$char_traits@D@std@@@std@@UEAA@XZ 002d ??3@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0F BA 98 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_40_165_2 {
	meta:
		name = "??_G?$basic_filebuf@GU?$char_traits@G@std@@@std@@UEAAPEAXI@Z"
		size = 59
		refs = "0013 ??1?$basic_filebuf@GU?$char_traits@G@std@@@std@@UEAA@XZ 002d ??3@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0F BA 98 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_116_185_3 {
	meta:
		name = "??_G?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UEAAPEAXI@Z"
		size = 59
		refs = "0013 ??1?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UEAA@XZ 002d ??3@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0F BA 98 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_141_1 {
	meta:
		name = "??_G?$basic_ios@DU?$char_traits@D@std@@@std@@UEAAPEAXI@Z"
		size = 59
		refs = "0013 ??1?$basic_ios@DU?$char_traits@D@std@@@std@@UEAA@XZ 002d ??3@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0F BA 60 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_40_166_2 {
	meta:
		name = "??_G?$basic_ios@GU?$char_traits@G@std@@@std@@UEAAPEAXI@Z"
		size = 59
		refs = "0013 ??1?$basic_ios@GU?$char_traits@G@std@@@std@@UEAA@XZ 002d ??3@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0F BA 60 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_116_186_3 {
	meta:
		name = "??_G?$basic_ios@_WU?$char_traits@_W@std@@@std@@UEAAPEAXI@Z"
		size = 59
		refs = "0013 ??1?$basic_ios@_WU?$char_traits@_W@std@@@std@@UEAA@XZ 002d ??3@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0F BA 60 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_142_1 {
	meta:
		name = "??_G?$basic_ostream@DU?$char_traits@D@std@@@std@@UEAAPEAXI@Z"
		size = 77
		refs = "001a ??_D?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAXXZ 003b ??3@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 83 E8 10 48 8B C8 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 16 48 8B 44 24 30 48 83 E8 10 BA 70 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 E8 10 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_5_141_1 {
	meta:
		name = "??_G?$basic_ostream@GU?$char_traits@G@std@@@std@@UEAAPEAXI@Z"
		size = 77
		refs = "001a ??_D?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAXXZ 003b ??3@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 83 E8 10 48 8B C8 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 16 48 8B 44 24 30 48 83 E8 10 BA 70 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 E8 10 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_114_141_1 {
	meta:
		name = "??_G?$basic_ostream@_WU?$char_traits@_W@std@@@std@@UEAAPEAXI@Z"
		size = 77
		refs = "001a ??_D?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAXXZ 003b ??3@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 83 E8 10 48 8B C8 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 16 48 8B 44 24 30 48 83 E8 10 BA 70 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 E8 10 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_143_1 {
	meta:
		name = "??_G?$basic_streambuf@DU?$char_traits@D@std@@@std@@UEAAPEAXI@Z"
		size = 59
		refs = "0013 ??1?$basic_streambuf@DU?$char_traits@D@std@@@std@@UEAA@XZ 002d ??3@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0F BA 68 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_40_168_2 {
	meta:
		name = "??_G?$basic_streambuf@GU?$char_traits@G@std@@@std@@UEAAPEAXI@Z"
		size = 59
		refs = "0013 ??1?$basic_streambuf@GU?$char_traits@G@std@@@std@@UEAA@XZ 002d ??3@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0F BA 68 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_116_188_3 {
	meta:
		name = "??_G?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@UEAAPEAXI@Z"
		size = 59
		refs = "0013 ??1?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@UEAA@XZ 002d ??3@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0F BA 68 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_144_1 {
	meta:
		name = "??_G?$codecvt@DDU_Mbstatet@@@std@@MEAAPEAXI@Z"
		size = 82
		refs = "0013 ??1?$codecvt@DDU_Mbstatet@@@std@@MEAA@XZ 0033 ??3_Crt_new_delete@std@@SAXPEAX@Z 0044 ?__global_delete@@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 26 8B 44 24 38 83 E0 04 85 C0 75 0C 48 8B 4C 24 30 E8 ?? ?? ?? ?? EB 0F BA 10 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_115_194_1 {
	meta:
		name = "??_G?$messages@D@std@@MEAAPEAXI@Z"
		size = 82
		refs = "0013 ??1?$messages@D@std@@MEAA@XZ 0033 ??3_Crt_new_delete@std@@SAXPEAX@Z 0044 ?__global_delete@@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 26 8B 44 24 38 83 E0 04 85 C0 75 0C 48 8B 4C 24 30 E8 ?? ?? ?? ?? EB 0F BA 10 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_10_511_2 {
	meta:
		name = "??_G?$messages@G@std@@MEAAPEAXI@Z"
		size = 82
		refs = "0013 ??1?$messages@G@std@@MEAA@XZ 0033 ??3_Crt_new_delete@std@@SAXPEAX@Z 0044 ?__global_delete@@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 26 8B 44 24 38 83 E0 04 85 C0 75 0C 48 8B 4C 24 30 E8 ?? ?? ?? ?? EB 0F BA 10 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_10_512_2 {
	meta:
		name = "??_G?$messages@_W@std@@MEAAPEAXI@Z"
		size = 82
		refs = "0013 ??1?$messages@_W@std@@MEAA@XZ 0033 ??3_Crt_new_delete@std@@SAXPEAX@Z 0044 ?__global_delete@@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 26 8B 44 24 38 83 E0 04 85 C0 75 0C 48 8B 4C 24 30 E8 ?? ?? ?? ?? EB 0F BA 10 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_89_238_2 {
	meta:
		name = "??_G?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 82
		refs = "0013 ??1?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEAA@XZ 0033 ??3_Crt_new_delete@std@@SAXPEAX@Z 0044 ?__global_delete@@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 26 8B 44 24 38 83 E0 04 85 C0 75 0C 48 8B 4C 24 30 E8 ?? ?? ?? ?? EB 0F BA 10 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_103_560_3 {
	meta:
		name = "??_G?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 82
		refs = "0013 ??1?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEAA@XZ 0033 ??3_Crt_new_delete@std@@SAXPEAX@Z 0044 ?__global_delete@@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 26 8B 44 24 38 83 E0 04 85 C0 75 0C 48 8B 4C 24 30 E8 ?? ?? ?? ?? EB 0F BA 10 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_119_438_1 {
	meta:
		name = "??_G?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 82
		refs = "0013 ??1?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEAA@XZ 0033 ??3_Crt_new_delete@std@@SAXPEAX@Z 0044 ?__global_delete@@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 26 8B 44 24 38 83 E0 04 85 C0 75 0C 48 8B 4C 24 30 E8 ?? ?? ?? ?? EB 0F BA 10 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_115_196_1 {
	meta:
		name = "??_G?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 82
		refs = "0013 ??1?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEAA@XZ 0033 ??3_Crt_new_delete@std@@SAXPEAX@Z 0044 ?__global_delete@@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 26 8B 44 24 38 83 E0 04 85 C0 75 0C 48 8B 4C 24 30 E8 ?? ?? ?? ?? EB 0F BA 10 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_103_562_3 {
	meta:
		name = "??_G?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 82
		refs = "0013 ??1?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEAA@XZ 0033 ??3_Crt_new_delete@std@@SAXPEAX@Z 0044 ?__global_delete@@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 26 8B 44 24 38 83 E0 04 85 C0 75 0C 48 8B 4C 24 30 E8 ?? ?? ?? ?? EB 0F BA 10 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_119_440_1 {
	meta:
		name = "??_G?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 82
		refs = "0013 ??1?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEAA@XZ 0033 ??3_Crt_new_delete@std@@SAXPEAX@Z 0044 ?__global_delete@@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 26 8B 44 24 38 83 E0 04 85 C0 75 0C 48 8B 4C 24 30 E8 ?? ?? ?? ?? EB 0F BA 10 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_62_121_1 {
	meta:
		name = "??_G?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 82
		refs = "0013 ??1?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEAA@XZ 0033 ??3_Crt_new_delete@std@@SAXPEAX@Z 0044 ?__global_delete@@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 26 8B 44 24 38 83 E0 04 85 C0 75 0C 48 8B 4C 24 30 E8 ?? ?? ?? ?? EB 0F BA 10 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_119_445_1 {
	meta:
		name = "??_G?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 82
		refs = "0013 ??1?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEAA@XZ 0033 ??3_Crt_new_delete@std@@SAXPEAX@Z 0044 ?__global_delete@@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 26 8B 44 24 38 83 E0 04 85 C0 75 0C 48 8B 4C 24 30 E8 ?? ?? ?? ?? EB 0F BA 10 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_103_569_3 {
	meta:
		name = "??_G?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 82
		refs = "0013 ??1?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEAA@XZ 0033 ??3_Crt_new_delete@std@@SAXPEAX@Z 0044 ?__global_delete@@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 26 8B 44 24 38 83 E0 04 85 C0 75 0C 48 8B 4C 24 30 E8 ?? ?? ?? ?? EB 0F BA 10 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_62_122_1 {
	meta:
		name = "??_G?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 82
		refs = "0013 ??1?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEAA@XZ 0033 ??3_Crt_new_delete@std@@SAXPEAX@Z 0044 ?__global_delete@@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 26 8B 44 24 38 83 E0 04 85 C0 75 0C 48 8B 4C 24 30 E8 ?? ?? ?? ?? EB 0F BA 10 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_119_447_1 {
	meta:
		name = "??_G?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 82
		refs = "0013 ??1?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEAA@XZ 0033 ??3_Crt_new_delete@std@@SAXPEAX@Z 0044 ?__global_delete@@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 26 8B 44 24 38 83 E0 04 85 C0 75 0C 48 8B 4C 24 30 E8 ?? ?? ?? ?? EB 0F BA 10 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_119_448_1 {
	meta:
		name = "??_G?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 82
		refs = "0013 ??1?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEAA@XZ 0033 ??3_Crt_new_delete@std@@SAXPEAX@Z 0044 ?__global_delete@@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 26 8B 44 24 38 83 E0 04 85 C0 75 0C 48 8B 4C 24 30 E8 ?? ?? ?? ?? EB 0F BA 10 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_33_28_2 {
	meta:
		name = "??_G_Fac_node@std@@QEAAPEAXI@Z"
		size = 82
		refs = "0013 ??1_Fac_node@std@@QEAA@XZ 0033 ??3_Fac_node@std@@SAXPEAX@Z 0044 ?__global_delete@@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 26 8B 44 24 38 83 E0 04 85 C0 75 0C 48 8B 4C 24 30 E8 ?? ?? ?? ?? EB 0F BA 10 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_105_177_2 {
	meta:
		name = "??_Gcodecvt_base@std@@UEAAPEAXI@Z"
		size = 82
		refs = "0013 ??1codecvt_base@std@@UEAA@XZ 0033 ??3_Crt_new_delete@std@@SAXPEAX@Z 0044 ?__global_delete@@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 26 8B 44 24 38 83 E0 04 85 C0 75 0C 48 8B 4C 24 30 E8 ?? ?? ?? ?? EB 0F BA 10 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_86_177_2 {
	meta:
		name = "??_Gctype_base@std@@UEAAPEAXI@Z"
		size = 82
		refs = "0013 ??1ctype_base@std@@UEAA@XZ 0033 ??3_Crt_new_delete@std@@SAXPEAX@Z 0044 ?__global_delete@@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 26 8B 44 24 38 83 E0 04 85 C0 75 0C 48 8B 4C 24 30 E8 ?? ?? ?? ?? EB 0F BA 10 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_69_200_3 {
	meta:
		name = "??_Gfacet@locale@std@@MEAAPEAXI@Z"
		size = 82
		refs = "0013 ??1facet@locale@std@@MEAA@XZ 0033 ??3_Crt_new_delete@std@@SAXPEAX@Z 0044 ?__global_delete@@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 26 8B 44 24 38 83 E0 04 85 C0 75 0C 48 8B 4C 24 30 E8 ?? ?? ?? ?? EB 0F BA 10 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_3_158_1 {
	meta:
		name = "??_Glocale@std@@QEAAPEAXI@Z"
		size = 82
		refs = "0013 ??1locale@std@@QEAA@XZ 0033 ??3_Crt_new_delete@std@@SAXPEAX@Z 0044 ?__global_delete@@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 26 8B 44 24 38 83 E0 04 85 C0 75 0C 48 8B 4C 24 30 E8 ?? ?? ?? ?? EB 0F BA 10 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_89_249_2 {
	meta:
		name = "??_Gmessages_base@std@@UEAAPEAXI@Z"
		size = 82
		refs = "0013 ??1messages_base@std@@UEAA@XZ 0033 ??3_Crt_new_delete@std@@SAXPEAX@Z 0044 ?__global_delete@@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 26 8B 44 24 38 83 E0 04 85 C0 75 0C 48 8B 4C 24 30 E8 ?? ?? ?? ?? EB 0F BA 10 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_115_207_1 {
	meta:
		name = "??_Gmoney_base@std@@UEAAPEAXI@Z"
		size = 82
		refs = "0013 ??1money_base@std@@UEAA@XZ 0033 ??3_Crt_new_delete@std@@SAXPEAX@Z 0044 ?__global_delete@@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 26 8B 44 24 38 83 E0 04 85 C0 75 0C 48 8B 4C 24 30 E8 ?? ?? ?? ?? EB 0F BA 10 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_10_540_2 {
	meta:
		name = "??_Gtime_base@std@@UEAAPEAXI@Z"
		size = 82
		refs = "0013 ??1time_base@std@@UEAA@XZ 0033 ??3_Crt_new_delete@std@@SAXPEAX@Z 0044 ?__global_delete@@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 26 8B 44 24 38 83 E0 04 85 C0 75 0C 48 8B 4C 24 30 E8 ?? ?? ?? ?? EB 0F BA 10 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_145_1 {
	meta:
		name = "??_G?$ctype@D@std@@MEAAPEAXI@Z"
		size = 82
		refs = "0013 ??1?$ctype@D@std@@MEAA@XZ 0033 ??3_Crt_new_delete@std@@SAXPEAX@Z 0044 ?__global_delete@@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 26 8B 44 24 38 83 E0 04 85 C0 75 0C 48 8B 4C 24 30 E8 ?? ?? ?? ?? EB 0F BA 30 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_62_123_1 {
	meta:
		name = "??_G?$numpunct@D@std@@MEAAPEAXI@Z"
		size = 82
		refs = "0013 ??1?$numpunct@D@std@@MEAA@XZ 0033 ??3_Crt_new_delete@std@@SAXPEAX@Z 0044 ?__global_delete@@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 26 8B 44 24 38 83 E0 04 85 C0 75 0C 48 8B 4C 24 30 E8 ?? ?? ?? ?? EB 0F BA 30 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_119_449_1 {
	meta:
		name = "??_G?$numpunct@G@std@@MEAAPEAXI@Z"
		size = 82
		refs = "0013 ??1?$numpunct@G@std@@MEAA@XZ 0033 ??3_Crt_new_delete@std@@SAXPEAX@Z 0044 ?__global_delete@@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 26 8B 44 24 38 83 E0 04 85 C0 75 0C 48 8B 4C 24 30 E8 ?? ?? ?? ?? EB 0F BA 30 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_119_450_1 {
	meta:
		name = "??_G?$numpunct@_W@std@@MEAAPEAXI@Z"
		size = 82
		refs = "0013 ??1?$numpunct@_W@std@@MEAA@XZ 0033 ??3_Crt_new_delete@std@@SAXPEAX@Z 0044 ?__global_delete@@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 26 8B 44 24 38 83 E0 04 85 C0 75 0C 48 8B 4C 24 30 E8 ?? ?? ?? ?? EB 0F BA 30 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_146_1 {
	meta:
		name = "??_G_Facet_base@std@@UEAAPEAXI@Z"
		size = 59
		refs = "0013 ??1_Facet_base@std@@UEAA@XZ 002d ??3@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0F BA 08 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_147_1 {
	meta:
		name = "??_G_Generic_error_category@std@@UEAAPEAXI@Z"
		size = 59
		refs = "0013 ??1_Generic_error_category@std@@UEAA@XZ 002d ??3@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0F BA 10 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_108_65_1 {
	meta:
		name = "??_G?$shared_ptr@V__ExceptionPtr@@@std@@QEAAPEAXI@Z"
		size = 59
		refs = "0013 ??1?$shared_ptr@V__ExceptionPtr@@@std@@QEAA@XZ 002d ??3@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0F BA 10 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_46_181_3 {
	meta:
		name = "??_G_Iostream_error_category@std@@UEAAPEAXI@Z"
		size = 59
		refs = "0013 ??1_Iostream_error_category@std@@UEAA@XZ 002d ??3@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0F BA 10 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_108_66_1 {
	meta:
		name = "??_G_Ref_count_base@std@@UEAAPEAXI@Z"
		size = 59
		refs = "0013 ??1_Ref_count_base@std@@UEAA@XZ 002d ??3@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0F BA 10 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_85_86_1 {
	meta:
		name = "??_G_System_error_category@std@@UEAAPEAXI@Z"
		size = 59
		refs = "0013 ??1_System_error_category@std@@UEAA@XZ 002d ??3@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0F BA 10 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_50_95_3 {
	meta:
		name = "??_Gerror_category@std@@UEAAPEAXI@Z"
		size = 59
		refs = "0013 ??1error_category@std@@UEAA@XZ 002d ??3@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0F BA 10 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_149_1 {
	meta:
		name = "??_G_System_error@std@@UEAAPEAXI@Z"
		size = 59
		refs = "0013 ??1_System_error@std@@UEAA@XZ 002d ??3@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0F BA 28 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_41_181_2 {
	meta:
		name = "??_Gfailure@ios_base@std@@UEAAPEAXI@Z"
		size = 59
		refs = "0013 ??1failure@ios_base@std@@UEAA@XZ 002d ??3@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0F BA 28 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_23_12_2 {
	meta:
		name = "??_Gfuture_error@std@@UEAAPEAXI@Z"
		size = 59
		refs = "0013 ??1future_error@std@@UEAA@XZ 002d ??3@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0F BA 28 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_24_205_3 {
	meta:
		name = "??_Gsystem_error@std@@UEAAPEAXI@Z"
		size = 59
		refs = "0013 ??1system_error@std@@UEAA@XZ 002d ??3@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0F BA 28 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_157_1 {
	meta:
		name = "??_Gios_base@std@@UEAAPEAXI@Z"
		size = 59
		refs = "0013 ??1ios_base@std@@UEAA@XZ 002d ??3@YAXPEAX_K@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0F BA 48 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_161_1 {
	meta:
		name = "??__E?id@?$codecvt@DDU_Mbstatet@@@std@@2V0locale@2@A@@YAXXZ"
		size = 23
		refs = "0009 ?id@?$codecvt@DDU_Mbstatet@@@std@@2V0locale@2@A 000e ??0id@locale@std@@QEAA@_K@Z"
	strings:
		$1 = { 48 83 EC 28 33 D2 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_33_32_2 {
	meta:
		name = "??__E?id@?$codecvt@GDU_Mbstatet@@@std@@2V0locale@2@A@@YAXXZ"
		size = 23
		refs = "0009 ?id@?$codecvt@GDU_Mbstatet@@@std@@2V0locale@2@A 000e ??0id@locale@std@@QEAA@_K@Z"
	strings:
		$1 = { 48 83 EC 28 33 D2 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_39_33_1 {
	meta:
		name = "??__E?id@?$codecvt@_WDU_Mbstatet@@@std@@2V0locale@2@A@@YAXXZ"
		size = 23
		refs = "0009 ?id@?$codecvt@_WDU_Mbstatet@@@std@@2V0locale@2@A 000e ??0id@locale@std@@QEAA@_K@Z"
	strings:
		$1 = { 48 83 EC 28 33 D2 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_89_253_2 {
	meta:
		name = "??__E?id@?$collate@D@std@@2V0locale@2@A@@YAXXZ"
		size = 23
		refs = "0009 ?id@?$collate@D@std@@2V0locale@2@A 000e ??0id@locale@std@@QEAA@_K@Z"
	strings:
		$1 = { 48 83 EC 28 33 D2 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_10_541_2 {
	meta:
		name = "??__E?id@?$collate@G@std@@2V0locale@2@A@@YAXXZ"
		size = 23
		refs = "0009 ?id@?$collate@G@std@@2V0locale@2@A 000e ??0id@locale@std@@QEAA@_K@Z"
	strings:
		$1 = { 48 83 EC 28 33 D2 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_103_589_3 {
	meta:
		name = "??__E?id@?$collate@_W@std@@2V0locale@2@A@@YAXXZ"
		size = 23
		refs = "0009 ?id@?$collate@_W@std@@2V0locale@2@A 000e ??0id@locale@std@@QEAA@_K@Z"
	strings:
		$1 = { 48 83 EC 28 33 D2 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_114_34_3 {
	meta:
		name = "??__E?id@?$ctype@D@std@@2V0locale@2@A@@YAXXZ"
		size = 23
		refs = "0009 ?id@?$ctype@D@std@@2V0locale@2@A 000e ??0id@locale@std@@QEAA@_K@Z"
	strings:
		$1 = { 48 83 EC 28 33 D2 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_33_35_2 {
	meta:
		name = "??__E?id@?$ctype@G@std@@2V0locale@2@A@@YAXXZ"
		size = 23
		refs = "0009 ?id@?$ctype@G@std@@2V0locale@2@A 000e ??0id@locale@std@@QEAA@_K@Z"
	strings:
		$1 = { 48 83 EC 28 33 D2 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_33_36_2 {
	meta:
		name = "??__E?id@?$ctype@_W@std@@2V0locale@2@A@@YAXXZ"
		size = 23
		refs = "0009 ?id@?$ctype@_W@std@@2V0locale@2@A 000e ??0id@locale@std@@QEAA@_K@Z"
	strings:
		$1 = { 48 83 EC 28 33 D2 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_115_211_1 {
	meta:
		name = "??__E?id@?$messages@D@std@@2V0locale@2@A@@YAXXZ"
		size = 23
		refs = "0009 ?id@?$messages@D@std@@2V0locale@2@A 000e ??0id@locale@std@@QEAA@_K@Z"
	strings:
		$1 = { 48 83 EC 28 33 D2 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_10_543_2 {
	meta:
		name = "??__E?id@?$messages@G@std@@2V0locale@2@A@@YAXXZ"
		size = 23
		refs = "0009 ?id@?$messages@G@std@@2V0locale@2@A 000e ??0id@locale@std@@QEAA@_K@Z"
	strings:
		$1 = { 48 83 EC 28 33 D2 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_103_591_3 {
	meta:
		name = "??__E?id@?$messages@_W@std@@2V0locale@2@A@@YAXXZ"
		size = 23
		refs = "0009 ?id@?$messages@_W@std@@2V0locale@2@A 000e ??0id@locale@std@@QEAA@_K@Z"
	strings:
		$1 = { 48 83 EC 28 33 D2 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_115_212_1 {
	meta:
		name = "??__E?id@?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A@@YAXXZ"
		size = 23
		refs = "0009 ?id@?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A 000e ??0id@locale@std@@QEAA@_K@Z"
	strings:
		$1 = { 48 83 EC 28 33 D2 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_103_592_3 {
	meta:
		name = "??__E?id@?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A@@YAXXZ"
		size = 23
		refs = "0009 ?id@?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A 000e ??0id@locale@std@@QEAA@_K@Z"
	strings:
		$1 = { 48 83 EC 28 33 D2 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_10_546_2 {
	meta:
		name = "??__E?id@?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A@@YAXXZ"
		size = 23
		refs = "0009 ?id@?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A 000e ??0id@locale@std@@QEAA@_K@Z"
	strings:
		$1 = { 48 83 EC 28 33 D2 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_115_213_1 {
	meta:
		name = "??__E?id@?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A@@YAXXZ"
		size = 23
		refs = "0009 ?id@?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A 000e ??0id@locale@std@@QEAA@_K@Z"
	strings:
		$1 = { 48 83 EC 28 33 D2 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_119_471_1 {
	meta:
		name = "??__E?id@?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A@@YAXXZ"
		size = 23
		refs = "0009 ?id@?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A 000e ??0id@locale@std@@QEAA@_K@Z"
	strings:
		$1 = { 48 83 EC 28 33 D2 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_10_548_2 {
	meta:
		name = "??__E?id@?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A@@YAXXZ"
		size = 23
		refs = "0009 ?id@?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A 000e ??0id@locale@std@@QEAA@_K@Z"
	strings:
		$1 = { 48 83 EC 28 33 D2 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_115_214_1 {
	meta:
		name = "??__E?id@?$moneypunct@D$00@std@@2V0locale@2@A@@YAXXZ"
		size = 23
		refs = "0009 ?id@?$moneypunct@D$00@std@@2V0locale@2@A 000e ??0id@locale@std@@QEAA@_K@Z"
	strings:
		$1 = { 48 83 EC 28 33 D2 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_89_258_2 {
	meta:
		name = "??__E?id@?$moneypunct@D$0A@@std@@2V0locale@2@A@@YAXXZ"
		size = 23
		refs = "0009 ?id@?$moneypunct@D$0A@@std@@2V0locale@2@A 000e ??0id@locale@std@@QEAA@_K@Z"
	strings:
		$1 = { 48 83 EC 28 33 D2 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_119_473_1 {
	meta:
		name = "??__E?id@?$moneypunct@G$00@std@@2V0locale@2@A@@YAXXZ"
		size = 23
		refs = "0009 ?id@?$moneypunct@G$00@std@@2V0locale@2@A 000e ??0id@locale@std@@QEAA@_K@Z"
	strings:
		$1 = { 48 83 EC 28 33 D2 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_103_597_3 {
	meta:
		name = "??__E?id@?$moneypunct@G$0A@@std@@2V0locale@2@A@@YAXXZ"
		size = 23
		refs = "0009 ?id@?$moneypunct@G$0A@@std@@2V0locale@2@A 000e ??0id@locale@std@@QEAA@_K@Z"
	strings:
		$1 = { 48 83 EC 28 33 D2 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_119_475_1 {
	meta:
		name = "??__E?id@?$moneypunct@_W$00@std@@2V0locale@2@A@@YAXXZ"
		size = 23
		refs = "0009 ?id@?$moneypunct@_W$00@std@@2V0locale@2@A 000e ??0id@locale@std@@QEAA@_K@Z"
	strings:
		$1 = { 48 83 EC 28 33 D2 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_119_476_1 {
	meta:
		name = "??__E?id@?$moneypunct@_W$0A@@std@@2V0locale@2@A@@YAXXZ"
		size = 23
		refs = "0009 ?id@?$moneypunct@_W$0A@@std@@2V0locale@2@A 000e ??0id@locale@std@@QEAA@_K@Z"
	strings:
		$1 = { 48 83 EC 28 33 D2 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_62_132_1 {
	meta:
		name = "??__E?id@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A@@YAXXZ"
		size = 23
		refs = "0009 ?id@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A 000e ??0id@locale@std@@QEAA@_K@Z"
	strings:
		$1 = { 48 83 EC 28 33 D2 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_119_477_1 {
	meta:
		name = "??__E?id@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A@@YAXXZ"
		size = 23
		refs = "0009 ?id@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A 000e ??0id@locale@std@@QEAA@_K@Z"
	strings:
		$1 = { 48 83 EC 28 33 D2 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_119_478_1 {
	meta:
		name = "??__E?id@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A@@YAXXZ"
		size = 23
		refs = "0009 ?id@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A 000e ??0id@locale@std@@QEAA@_K@Z"
	strings:
		$1 = { 48 83 EC 28 33 D2 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_62_133_1 {
	meta:
		name = "??__E?id@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A@@YAXXZ"
		size = 23
		refs = "0009 ?id@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A 000e ??0id@locale@std@@QEAA@_K@Z"
	strings:
		$1 = { 48 83 EC 28 33 D2 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_103_602_3 {
	meta:
		name = "??__E?id@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A@@YAXXZ"
		size = 23
		refs = "0009 ?id@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A 000e ??0id@locale@std@@QEAA@_K@Z"
	strings:
		$1 = { 48 83 EC 28 33 D2 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_103_603_3 {
	meta:
		name = "??__E?id@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A@@YAXXZ"
		size = 23
		refs = "0009 ?id@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A 000e ??0id@locale@std@@QEAA@_K@Z"
	strings:
		$1 = { 48 83 EC 28 33 D2 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_2_161_3 {
	meta:
		name = "??__E?id@?$numpunct@D@std@@2V0locale@2@A@@YAXXZ"
		size = 23
		refs = "0009 ?id@?$numpunct@D@std@@2V0locale@2@A 000e ??0id@locale@std@@QEAA@_K@Z"
	strings:
		$1 = { 48 83 EC 28 33 D2 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_103_604_3 {
	meta:
		name = "??__E?id@?$numpunct@G@std@@2V0locale@2@A@@YAXXZ"
		size = 23
		refs = "0009 ?id@?$numpunct@G@std@@2V0locale@2@A 000e ??0id@locale@std@@QEAA@_K@Z"
	strings:
		$1 = { 48 83 EC 28 33 D2 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_10_558_2 {
	meta:
		name = "??__E?id@?$numpunct@_W@std@@2V0locale@2@A@@YAXXZ"
		size = 23
		refs = "0009 ?id@?$numpunct@_W@std@@2V0locale@2@A 000e ??0id@locale@std@@QEAA@_K@Z"
	strings:
		$1 = { 48 83 EC 28 33 D2 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_38_274_3 {
	meta:
		name = "??__E?id@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A@@YAXXZ"
		size = 23
		refs = "0009 ?id@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A 000e ??0id@locale@std@@QEAA@_K@Z"
	strings:
		$1 = { 48 83 EC 28 33 D2 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_10_559_2 {
	meta:
		name = "??__E?id@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A@@YAXXZ"
		size = 23
		refs = "0009 ?id@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A 000e ??0id@locale@std@@QEAA@_K@Z"
	strings:
		$1 = { 48 83 EC 28 33 D2 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_10_560_2 {
	meta:
		name = "??__E?id@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A@@YAXXZ"
		size = 23
		refs = "0009 ?id@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A 000e ??0id@locale@std@@QEAA@_K@Z"
	strings:
		$1 = { 48 83 EC 28 33 D2 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_89_260_2 {
	meta:
		name = "??__E?id@?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A@@YAXXZ"
		size = 23
		refs = "0009 ?id@?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A 000e ??0id@locale@std@@QEAA@_K@Z"
	strings:
		$1 = { 48 83 EC 28 33 D2 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_119_485_1 {
	meta:
		name = "??__E?id@?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A@@YAXXZ"
		size = 23
		refs = "0009 ?id@?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A 000e ??0id@locale@std@@QEAA@_K@Z"
	strings:
		$1 = { 48 83 EC 28 33 D2 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_119_486_1 {
	meta:
		name = "??__E?id@?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A@@YAXXZ"
		size = 23
		refs = "0009 ?id@?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A 000e ??0id@locale@std@@QEAA@_K@Z"
	strings:
		$1 = { 48 83 EC 28 33 D2 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_162_1 {
	meta:
		name = "??__Ecerr@std@@YAXXZ"
		size = 49
		refs = "0010 ?ferr@std@@3V?$basic_filebuf@DU?$char_traits@D@std@@@1@A 0017 ?cerr@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A 001c ??0?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAA@PEAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z 0023 ??__Fcerr@std@@YAXXZ 0028 atexit"
	strings:
		$1 = { 48 83 EC 28 41 B9 01 00 00 00 45 33 C0 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_60_162_1 {
	meta:
		name = "??__Ecin@std@@YAXXZ"
		size = 49
		refs = "0010 ?fin@std@@3V?$basic_filebuf@DU?$char_traits@D@std@@@1@A 0017 ?cin@std@@3V?$basic_istream@DU?$char_traits@D@std@@@1@A 001c ??0?$basic_istream@DU?$char_traits@D@std@@@std@@QEAA@PEAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z 0023 ??__Fcin@std@@YAXXZ 0028 atexit"
	strings:
		$1 = { 48 83 EC 28 41 B9 01 00 00 00 45 33 C0 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_101_188_2 {
	meta:
		name = "??__Eclog@std@@YAXXZ"
		size = 49
		refs = "0010 ?flog@std@@3V?$basic_filebuf@DU?$char_traits@D@std@@@1@A 0017 ?clog@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A 001c ??0?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAA@PEAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z 0023 ??__Fclog@std@@YAXXZ 0028 atexit"
	strings:
		$1 = { 48 83 EC 28 41 B9 01 00 00 00 45 33 C0 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_46_195_3 {
	meta:
		name = "??__Ecout@std@@YAXXZ"
		size = 49
		refs = "0010 ?fout@std@@3V?$basic_filebuf@DU?$char_traits@D@std@@@1@A 0017 ?cout@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A 001c ??0?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAA@PEAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z 0023 ??__Fcout@std@@YAXXZ 0028 atexit"
	strings:
		$1 = { 48 83 EC 28 41 B9 01 00 00 00 45 33 C0 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_4_162_1 {
	meta:
		name = "??__Ewcerr@std@@YAXXZ"
		size = 49
		refs = "0010 ?wferr@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A 0017 ?wcerr@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 001c ??0?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAA@PEAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z 0023 ??__Fwcerr@std@@YAXXZ 0028 atexit"
	strings:
		$1 = { 48 83 EC 28 41 B9 01 00 00 00 45 33 C0 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_99_162_1 {
	meta:
		name = "??__Ewcerr@std@@YAXXZ"
		size = 49
		refs = "0010 ?wferr@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A 0017 ?wcerr@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A 001c ??0?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAA@PEAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z 0023 ??__Fwcerr@std@@YAXXZ 0028 atexit"
	strings:
		$1 = { 48 83 EC 28 41 B9 01 00 00 00 45 33 C0 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_86_188_2 {
	meta:
		name = "??__Ewcerr@std@@YAXXZ"
		size = 49
		refs = "0010 ?wferr@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A 0017 ?wcerr@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 001c ??0?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAA@PEAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z 0023 ??__Fwcerr@std@@YAXXZ 0028 atexit"
	strings:
		$1 = { 48 83 EC 28 41 B9 01 00 00 00 45 33 C0 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_66_208_3 {
	meta:
		name = "??__Ewcerr@std@@YAXXZ"
		size = 49
		refs = "0010 ?wferr@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A 0017 ?wcerr@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A 001c ??0?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAA@PEAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z 0023 ??__Fwcerr@std@@YAXXZ 0028 atexit"
	strings:
		$1 = { 48 83 EC 28 41 B9 01 00 00 00 45 33 C0 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_29_208_3 {
	meta:
		name = "??__Ewcin@std@@YAXXZ"
		size = 49
		refs = "0010 ?wfin@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A 0017 ?wcin@std@@3V?$basic_istream@GU?$char_traits@G@std@@@1@A 001c ??0?$basic_istream@GU?$char_traits@G@std@@@std@@QEAA@PEAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z 0023 ??__Fwcin@std@@YAXXZ 0028 atexit"
	strings:
		$1 = { 48 83 EC 28 41 B9 01 00 00 00 45 33 C0 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_48_188_2 {
	meta:
		name = "??__Ewcin@std@@YAXXZ"
		size = 49
		refs = "0010 ?wfin@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A 0017 ?wcin@std@@3V?$basic_istream@_WU?$char_traits@_W@std@@@1@A 001c ??0?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAA@PEAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z 0023 ??__Fwcin@std@@YAXXZ 0028 atexit"
	strings:
		$1 = { 48 83 EC 28 41 B9 01 00 00 00 45 33 C0 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_40_188_2 {
	meta:
		name = "??__Ewcin@std@@YAXXZ"
		size = 49
		refs = "0010 ?wfin@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A 0017 ?wcin@std@@3V?$basic_istream@GU?$char_traits@G@std@@@1@A 001c ??0?$basic_istream@GU?$char_traits@G@std@@@std@@QEAA@PEAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z 0023 ??__Fwcin@std@@YAXXZ 0028 atexit"
	strings:
		$1 = { 48 83 EC 28 41 B9 01 00 00 00 45 33 C0 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_91_162_1 {
	meta:
		name = "??__Ewcin@std@@YAXXZ"
		size = 49
		refs = "0010 ?wfin@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A 0017 ?wcin@std@@3V?$basic_istream@_WU?$char_traits@_W@std@@@1@A 001c ??0?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAA@PEAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z 0023 ??__Fwcin@std@@YAXXZ 0028 atexit"
	strings:
		$1 = { 48 83 EC 28 41 B9 01 00 00 00 45 33 C0 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_69_208_3 {
	meta:
		name = "??__Ewclog@std@@YAXXZ"
		size = 49
		refs = "0010 ?wflog@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A 0017 ?wclog@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 001c ??0?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAA@PEAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z 0023 ??__Fwclog@std@@YAXXZ 0028 atexit"
	strings:
		$1 = { 48 83 EC 28 41 B9 01 00 00 00 45 33 C0 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_8_208_3 {
	meta:
		name = "??__Ewclog@std@@YAXXZ"
		size = 49
		refs = "0010 ?wflog@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A 0017 ?wclog@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A 001c ??0?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAA@PEAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z 0023 ??__Fwclog@std@@YAXXZ 0028 atexit"
	strings:
		$1 = { 48 83 EC 28 41 B9 01 00 00 00 45 33 C0 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_63_162_1 {
	meta:
		name = "??__Ewclog@std@@YAXXZ"
		size = 49
		refs = "0010 ?wflog@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A 0017 ?wclog@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 001c ??0?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAA@PEAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z 0023 ??__Fwclog@std@@YAXXZ 0028 atexit"
	strings:
		$1 = { 48 83 EC 28 41 B9 01 00 00 00 45 33 C0 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_24_208_3 {
	meta:
		name = "??__Ewcout@std@@YAXXZ"
		size = 49
		refs = "0010 ?wfout@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A 0017 ?wcout@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A 001c ??0?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAA@PEAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z 0023 ??__Fwcout@std@@YAXXZ 0028 atexit"
	strings:
		$1 = { 48 83 EC 28 41 B9 01 00 00 00 45 33 C0 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_88_188_2 {
	meta:
		name = "??__Ewcout@std@@YAXXZ"
		size = 49
		refs = "0010 ?wfout@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A 0017 ?wcout@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 001c ??0?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAA@PEAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z 0023 ??__Fwcout@std@@YAXXZ 0028 atexit"
	strings:
		$1 = { 48 83 EC 28 41 B9 01 00 00 00 45 33 C0 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_82_188_2 {
	meta:
		name = "??__Ewcout@std@@YAXXZ"
		size = 49
		refs = "0010 ?wfout@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A 0017 ?wcout@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A 001c ??0?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAA@PEAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z 0023 ??__Fwcout@std@@YAXXZ 0028 atexit"
	strings:
		$1 = { 48 83 EC 28 41 B9 01 00 00 00 45 33 C0 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_114_162_1 {
	meta:
		name = "??__Ewcout@std@@YAXXZ"
		size = 49
		refs = "0010 ?wfout@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A 0017 ?wcout@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 001c ??0?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAA@PEAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z 0023 ??__Fwcout@std@@YAXXZ 0028 atexit"
	strings:
		$1 = { 48 83 EC 28 41 B9 01 00 00 00 45 33 C0 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_5_162_1 {
	meta:
		name = "??__Ewcout@std@@YAXXZ"
		size = 49
		refs = "0010 ?wfout@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A 0017 ?wcout@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A 001c ??0?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAA@PEAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z 0023 ??__Fwcout@std@@YAXXZ 0028 atexit"
	strings:
		$1 = { 48 83 EC 28 41 B9 01 00 00 00 45 33 C0 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_116_208_3 {
	meta:
		name = "??__Ewcout@std@@YAXXZ"
		size = 49
		refs = "0010 ?wfout@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A 0017 ?wcout@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 001c ??0?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAA@PEAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z 0023 ??__Fwcout@std@@YAXXZ 0028 atexit"
	strings:
		$1 = { 48 83 EC 28 41 B9 01 00 00 00 45 33 C0 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_163_1 {
	meta:
		name = "??__Eferr@std@@YAXXZ"
		size = 46
		refs = "000a __acrt_iob_func 0014 ?ferr@std@@3V?$basic_filebuf@DU?$char_traits@D@std@@@1@A 0019 ??0?$basic_filebuf@DU?$char_traits@D@std@@@std@@QEAA@PEAU_iobuf@@@Z 0020 ??__Fferr@std@@YAXXZ 0025 atexit"
	strings:
		$1 = { 48 83 EC 28 B9 02 00 00 00 E8 ?? ?? ?? ?? 48 8B D0 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_90_163_1 {
	meta:
		name = "??__Eflog@std@@YAXXZ"
		size = 46
		refs = "000a __acrt_iob_func 0014 ?flog@std@@3V?$basic_filebuf@DU?$char_traits@D@std@@@1@A 0019 ??0?$basic_filebuf@DU?$char_traits@D@std@@@std@@QEAA@PEAU_iobuf@@@Z 0020 ??__Fflog@std@@YAXXZ 0025 atexit"
	strings:
		$1 = { 48 83 EC 28 B9 02 00 00 00 E8 ?? ?? ?? ?? 48 8B D0 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_4_163_1 {
	meta:
		name = "??__Ewferr@std@@YAXXZ"
		size = 46
		refs = "000a __acrt_iob_func 0014 ?wferr@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A 0019 ??0?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@QEAA@PEAU_iobuf@@@Z 0020 ??__Fwferr@std@@YAXXZ 0025 atexit"
	strings:
		$1 = { 48 83 EC 28 B9 02 00 00 00 E8 ?? ?? ?? ?? 48 8B D0 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_99_163_1 {
	meta:
		name = "??__Ewferr@std@@YAXXZ"
		size = 46
		refs = "000a __acrt_iob_func 0014 ?wferr@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A 0019 ??0?$basic_filebuf@GU?$char_traits@G@std@@@std@@QEAA@PEAU_iobuf@@@Z 0020 ??__Fwferr@std@@YAXXZ 0025 atexit"
	strings:
		$1 = { 48 83 EC 28 B9 02 00 00 00 E8 ?? ?? ?? ?? 48 8B D0 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_86_189_2 {
	meta:
		name = "??__Ewferr@std@@YAXXZ"
		size = 46
		refs = "000a __acrt_iob_func 0014 ?wferr@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A 0019 ??0?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@QEAA@PEAU_iobuf@@@Z 0020 ??__Fwferr@std@@YAXXZ 0025 atexit"
	strings:
		$1 = { 48 83 EC 28 B9 02 00 00 00 E8 ?? ?? ?? ?? 48 8B D0 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_66_209_3 {
	meta:
		name = "??__Ewferr@std@@YAXXZ"
		size = 46
		refs = "000a __acrt_iob_func 0014 ?wferr@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A 0019 ??0?$basic_filebuf@GU?$char_traits@G@std@@@std@@QEAA@PEAU_iobuf@@@Z 0020 ??__Fwferr@std@@YAXXZ 0025 atexit"
	strings:
		$1 = { 48 83 EC 28 B9 02 00 00 00 E8 ?? ?? ?? ?? 48 8B D0 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_107_209_3 {
	meta:
		name = "??__Ewferr@std@@YAXXZ"
		size = 46
		refs = "000a __acrt_iob_func 0014 ?wferr@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A 0019 ??0?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@QEAA@PEAU_iobuf@@@Z 0020 ??__Fwferr@std@@YAXXZ 0025 atexit"
	strings:
		$1 = { 48 83 EC 28 B9 02 00 00 00 E8 ?? ?? ?? ?? 48 8B D0 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_63_163_1 {
	meta:
		name = "??__Ewflog@std@@YAXXZ"
		size = 46
		refs = "000a __acrt_iob_func 0014 ?wflog@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A 0019 ??0?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@QEAA@PEAU_iobuf@@@Z 0020 ??__Fwflog@std@@YAXXZ 0025 atexit"
	strings:
		$1 = { 48 83 EC 28 B9 02 00 00 00 E8 ?? ?? ?? ?? 48 8B D0 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_77_163_1 {
	meta:
		name = "??__Ewflog@std@@YAXXZ"
		size = 46
		refs = "000a __acrt_iob_func 0014 ?wflog@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A 0019 ??0?$basic_filebuf@GU?$char_traits@G@std@@@std@@QEAA@PEAU_iobuf@@@Z 0020 ??__Fwflog@std@@YAXXZ 0025 atexit"
	strings:
		$1 = { 48 83 EC 28 B9 02 00 00 00 E8 ?? ?? ?? ?? 48 8B D0 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_76_189_2 {
	meta:
		name = "??__Ewflog@std@@YAXXZ"
		size = 46
		refs = "000a __acrt_iob_func 0014 ?wflog@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A 0019 ??0?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@QEAA@PEAU_iobuf@@@Z 0020 ??__Fwflog@std@@YAXXZ 0025 atexit"
	strings:
		$1 = { 48 83 EC 28 B9 02 00 00 00 E8 ?? ?? ?? ?? 48 8B D0 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_8_209_3 {
	meta:
		name = "??__Ewflog@std@@YAXXZ"
		size = 46
		refs = "000a __acrt_iob_func 0014 ?wflog@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A 0019 ??0?$basic_filebuf@GU?$char_traits@G@std@@@std@@QEAA@PEAU_iobuf@@@Z 0020 ??__Fwflog@std@@YAXXZ 0025 atexit"
	strings:
		$1 = { 48 83 EC 28 B9 02 00 00 00 E8 ?? ?? ?? ?? 48 8B D0 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_69_209_3 {
	meta:
		name = "??__Ewflog@std@@YAXXZ"
		size = 46
		refs = "000a __acrt_iob_func 0014 ?wflog@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A 0019 ??0?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@QEAA@PEAU_iobuf@@@Z 0020 ??__Fwflog@std@@YAXXZ 0025 atexit"
	strings:
		$1 = { 48 83 EC 28 B9 02 00 00 00 E8 ?? ?? ?? ?? 48 8B D0 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_165_1 {
	meta:
		name = "??__Einitlocks@@YAXXZ"
		size = 33
		refs = "0007 ?initlocks@@3V_Init_locks@std@@A 000c ??0_Init_locks@std@@QEAA@XZ 0013 ??__Finitlocks@@YAXXZ 0018 atexit"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_108_71_1 {
	meta:
		name = "??__E?m_badAllocExceptionPtr@__ExceptionPtr@@0V?$shared_ptr@V__ExceptionPtr@@@std@@A@@YAXXZ"
		size = 33
		refs = "0007 ?m_badAllocExceptionPtr@__ExceptionPtr@@0V?$shared_ptr@V__ExceptionPtr@@@std@@A 000c ?_InitBadAllocException@__ExceptionPtr@@CA?AV?$shared_ptr@V__ExceptionPtr@@@std@@XZ 0013 ??__F?m_badAllocExceptionPtr@__ExceptionPtr@@0V?$shared_ptr@V__ExceptionPtr@@@std@@A@@YAXXZ 0018 atexit"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_92_2_1 {
	meta:
		name = "??__Einitlocks@std@@YAXXZ"
		size = 33
		refs = "0007 ?initlocks@std@@3V_Init_locks@1@A 000c ??0_Init_locks@std@@QEAA@XZ 0013 ??__Finitlocks@std@@YAXXZ 0018 atexit"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_171_1 {
	meta:
		name = "?_Allocate@std@@YAPEAX_K0_N@Z"
		size = 511
		refs = "0044 ?_Xbad_alloc@std@@YAXXZ 0099 ??2@YAPEAX_K@Z 00ad ??_C@_0BE@LMNLACIC@_Ptr_container?5?$CB?$DN?50?$AA@ 00bf ??_C@_1DG@HGDKEBPG@?$AA?$CC?$AA_?$AAP?$AAt?$AAr?$AA_?$AAc?$AAo?$AAn?$AAt?$AAa?$AAi?$AAn?$AAe?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA0?$AA?$CC?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA0?$AA?$AA@ 00cb ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 00e0 ??_C@_1FC@CNLMDHOG@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAs?$AAt?$AAd?$AAh?$AAp?$AAp?$AA?2@ 00ea _CrtDbgReportW 010f ??_C@_1BO@NKFMJPA@?$AAs?$AAt?$AAd?$AA?3?$AA?3?$AA_?$AAA?$AAl?$AAl?$AAo?$AAc?$AAa?$AAt?$AAe?$AA?$AA@ 0116 ??_C@_1CG@JNLFBNGN@?$AA?$CC?$AAi?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAa?$AAr?$AAg?$AAu?$AAm?$AAe?$AAn?$AAt?$AA?$CC?$AA?$AA@ 011b _invalid_parameter 0183 ??_C@_09GLJCAGLP@_Ptr?5?$CB?$DN?50?$AA@ 0195 ??_C@_1CC@GKJLLHIM@?$AA?$CC?$AA_?$AAP?$AAt?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA0?$AA?$CC?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA0?$AA?$AA@"
	strings:
		$1 = { 44 88 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 58 48 C7 44 24 30 00 00 00 00 48 83 7C 24 60 00 75 0A 48 8B 44 24 30 E9 CC 01 00 00 33 D2 48 C7 C0 FF FF FF FF 48 F7 74 24 68 48 3B 44 24 60 73 05 E8 ?? ?? ?? ?? 48 8B 44 24 60 48 0F AF 44 24 68 48 89 44 24 38 0F B6 44 24 70 85 C0 0F 84 04 01 00 00 48 81 7C 24 38 00 10 00 00 0F 82 F5 00 00 00 48 8B 44 24 38 48 83 C0 2F 48 89 44 24 48 48 8B 44 24 38 48 39 44 24 48 77 05 E8 ?? ?? ?? ?? 48 8B 4C 24 48 E8 ?? ?? ?? ?? 48 89 44 24 40 48 83 7C 24 40 00 75 75 48 8D 05 ?? ?? ?? ?? 48 85 C0 74 06 33 C0 85 C0 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 46 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 48 C7 44 24 20 00 00 00 00 41 B9 46 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 44 24 40 48 83 C0 2F 48 83 E0 E0 48 89 44 24 30 B8 08 00 00 00 48 6B C0 FF 48 8B 4C 24 30 48 8B 54 24 40 48 89 14 01 B8 08 00 00 00 48 6B C0 FE 48 8B 4C 24 30 48 BA FA FA FA FA FA FA FA FA 48 89 14 01 E9 8C 00 00 00 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 89 44 24 30 48 83 7C 24 30 00 75 75 48 8D 05 ?? ?? ?? ?? 48 85 C0 74 06 33 C0 85 C0 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 54 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 48 C7 44 24 20 00 00 00 00 41 B9 54 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_1_172_1 {
	meta:
		name = "?_Assign_rv@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX$$QEAV12@@Z"
		size = 283
		refs = "0014 ?_Myres@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAAAEA_KXZ 0024 ?_Mysize@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAAAEA_KXZ 0039 ?_Bx@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAAAEAT_Bxty@?$_String_val@U?$_Simple_types@D@std@@@2@XZ 0060 ?move@?$char_traits@D@std@@SAPEADPEADPEBD_K@Z 0083 ??$addressof@PEAD@std@@YAPEAPEADAEAPEAD@Z 0092 ?_Getal@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAAAEAU?$_Wrap_alloc@V?$allocator@D@std@@@2@XZ 00aa ??$construct@PEADAEAPEAD@?$_Wrap_alloc@V?$allocator@D@std@@@std@@QEAAXPEAPEADAEAPEAD@Z 0112 ?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_N_K@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 58 48 8B 4C 24 68 E8 ?? ?? ?? ?? 48 83 38 10 73 48 48 8B 4C 24 68 E8 ?? ?? ?? ?? 48 8B 00 48 FF C0 48 89 44 24 20 48 8B 4C 24 68 E8 ?? ?? ?? ?? 48 89 44 24 28 48 8B 4C 24 60 E8 ?? ?? ?? ?? 48 8B 4C 24 20 4C 8B C1 48 8B 4C 24 28 48 8B D1 48 8B C8 E8 ?? ?? ?? ?? EB 59 48 8B 4C 24 68 E8 ?? ?? ?? ?? 48 89 44 24 30 48 8B 4C 24 60 E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 89 44 24 38 48 8B 4C 24 60 E8 ?? ?? ?? ?? 48 8B 4C 24 30 4C 8B C1 48 8B 4C 24 38 48 8B D1 48 8B C8 E8 ?? ?? ?? ?? 48 8B 4C 24 68 E8 ?? ?? ?? ?? 48 C7 00 00 00 00 00 48 8B 4C 24 68 E8 ?? ?? ?? ?? 48 89 44 24 40 48 8B 4C 24 60 E8 ?? ?? ?? ?? 48 8B 4C 24 40 48 8B 09 48 89 08 48 8B 4C 24 68 E8 ?? ?? ?? ?? 48 89 44 24 48 48 8B 4C 24 60 E8 ?? ?? ?? ?? 48 8B 4C 24 48 48 8B 09 48 89 08 45 33 C0 33 D2 48 8B 4C 24 68 E8 ?? ?? ?? ?? 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_1_174_1 {
	meta:
		name = "?_Chassign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_K0D@Z"
		size = 101
		refs = "0026 ?_Myptr@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAAPEADXZ 0038 ?assign@?$char_traits@D@std@@SAXAEADAEBD@Z 005c ?assign@?$char_traits@D@std@@SAPEADPEAD_KD@Z"
	strings:
		$1 = { 44 88 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 83 7C 24 40 01 75 1E 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 03 44 24 38 48 8D 54 24 48 48 8B C8 E8 ?? ?? ?? ?? EB 22 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 03 44 24 38 44 0F B6 44 24 48 48 8B 54 24 40 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_175_1 {
	meta:
		name = "?_Check_offset@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBAX_K@Z"
		size = 49
		refs = "0014 ?_Mysize@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEBAAEB_KXZ 0028 ?_Xran@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBAXXZ"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 4C 24 38 48 39 08 73 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_119_502_1 {
	meta:
		name = "?_Check_offset@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEBAX_K@Z"
		size = 49
		refs = "0014 ?_Mysize@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QEBAAEB_KXZ 0028 ?_Xran@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEBAXXZ"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 4C 24 38 48 39 08 73 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_41_38_1 {
	meta:
		name = "?_Check_offset@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEBAX_K@Z"
		size = 49
		refs = "0014 ?_Mysize@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QEBAAEB_KXZ 0028 ?_Xran@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEBAXXZ"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 4C 24 38 48 39 08 73 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_176_1 {
	meta:
		name = "?_Clamp_suffix_size@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBA_K_K0@Z"
		size = 76
		refs = "0019 ?_Mysize@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEBAAEB_KXZ"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 4C 24 48 48 8B 00 48 2B C1 48 89 44 24 20 48 8B 44 24 20 48 39 44 24 50 77 09 48 8B 44 24 50 EB 07 EB 05 48 8B 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_119_505_1 {
	meta:
		name = "?_Clamp_suffix_size@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEBA_K_K0@Z"
		size = 76
		refs = "0019 ?_Mysize@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QEBAAEB_KXZ"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 4C 24 48 48 8B 00 48 2B C1 48 89 44 24 20 48 8B 44 24 20 48 39 44 24 50 77 09 48 8B 44 24 50 EB 07 EB 05 48 8B 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_41_39_1 {
	meta:
		name = "?_Clamp_suffix_size@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEBA_K_K0@Z"
		size = 76
		refs = "0019 ?_Mysize@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QEBAAEB_KXZ"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 4C 24 48 48 8B 00 48 2B C1 48 89 44 24 20 48 8B 44 24 20 48 39 44 24 50 77 09 48 8B 44 24 50 EB 07 EB 05 48 8B 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1_177_1 {
	meta:
		name = "?_Copy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_K0@Z"
		size = 560
		refs = "003c ?max_size@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBA_KXZ 0076 ?_Myres@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAAAEA_KXZ 014c ?_Getal@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAAAEAU?$_Wrap_alloc@V?$allocator@D@std@@@2@XZ 015c ?allocate@?$_Wrap_alloc@V?$allocator@D@std@@@std@@QEAAPEAD_K@Z 0185 ?_Myptr@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAAPEADXZ 0194 ??$_Unfancy@D@std@@YAPEADPEAD@Z 01ac ?copy@?$char_traits@D@std@@SAPEADPEADPEBD_K@Z 01be ?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_N_K@Z 01cb ?_Bx@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAAAEAT_Bxty@?$_String_val@U?$_Simple_types@D@std@@@2@XZ 01d3 ??$addressof@PEAD@std@@YAPEAPEADAEAPEAD@Z 01fa ??$construct@PEADAEAPEAD@?$_Wrap_alloc@V?$allocator@D@std@@@std@@QEAAXPEAPEADAEAPEAD@Z 0224 ?_Eos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_K@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 81 EC 98 00 00 00 48 C7 84 24 80 00 00 00 FE FF FF FF 48 8B 84 24 A8 00 00 00 48 83 C8 0F 48 89 44 24 20 48 8B 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 48 3B 44 24 20 73 12 48 8B 84 24 A8 00 00 00 48 89 44 24 20 E9 DD 00 00 00 33 D2 48 8B 44 24 20 B9 03 00 00 00 48 F7 F1 48 89 44 24 30 48 8B 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 33 D2 48 8B 00 B9 02 00 00 00 48 F7 F1 48 8B 4C 24 30 48 3B C1 77 05 E9 A0 00 00 00 48 8B 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 33 D2 48 8B 00 B9 02 00 00 00 48 F7 F1 48 89 44 24 38 48 8B 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 48 8B 4C 24 38 48 2B C1 48 89 44 24 40 48 8B 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 48 8B 4C 24 40 48 39 08 77 3E 48 8B 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 33 D2 48 8B 00 B9 02 00 00 00 48 F7 F1 48 89 44 24 48 48 8B 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 48 8B 4C 24 48 48 03 08 48 8B C1 48 89 44 24 20 EB 12 48 8B 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 20 48 8B 44 24 20 48 FF C0 48 89 44 24 50 48 8B 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 48 8B 4C 24 50 48 8B D1 48 8B C8 E8 ?? ?? ?? ?? 48 89 44 24 58 48 8B 44 24 58 48 89 44 24 28 EB 00 48 83 BC 24 B0 00 00 00 00 76 34 48 8B 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 70 48 8B 4C 24 28 E8 ?? ?? ?? ?? 4C 8B 84 24 B0 00 00 00 48 8B 4C 24 70 48 8B D1 48 8B C8 E8 ?? ?? ?? ?? 45 33 C0 B2 01 48 8B 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 48 8B 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 89 44 24 78 48 8B 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 4C 8D 44 24 28 48 8B 4C 24 78 48 8B D1 48 8B C8 E8 ?? ?? ?? ?? 48 8B 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 48 8B 4C 24 20 48 89 08 48 8B 94 24 B0 00 00 00 48 8B 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 98 00 00 00 C3 }
	condition:
		$1
}

rule file_1_179_1 {
	meta:
		name = "__catch$?_Copy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_K0@Z$0"
		size = 77
		refs = "001e ?_Getal@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAAAEAU?$_Wrap_alloc@V?$allocator@D@std@@@2@XZ 002d ?allocate@?$_Wrap_alloc@V?$allocator@D@std@@@std@@QEAAPEAD_K@Z 0042 $LN19"
	strings:
		$1 = { 48 8B 85 A8 00 00 00 48 89 45 20 48 8B 45 20 48 FF C0 48 89 45 60 48 8B 8D A0 00 00 00 E8 ?? ?? ?? ?? 48 8B 4D 60 48 8B D1 48 8B C8 E8 ?? ?? ?? ?? 48 89 45 68 48 8B 45 68 48 89 45 28 EB 00 48 8D 05 ?? ?? ?? ?? 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_119_516_1 {
	meta:
		name = "__catch$?_Copy@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEAAX_K0@Z$0"
		size = 77
		refs = "001e ?_Getal@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QEAAAEAU?$_Wrap_alloc@V?$allocator@G@std@@@2@XZ 002d ?allocate@?$_Wrap_alloc@V?$allocator@G@std@@@std@@QEAAPEAG_K@Z 0042 $LN19"
	strings:
		$1 = { 48 8B 85 A8 00 00 00 48 89 45 20 48 8B 45 20 48 FF C0 48 89 45 60 48 8B 8D A0 00 00 00 E8 ?? ?? ?? ?? 48 8B 4D 60 48 8B D1 48 8B C8 E8 ?? ?? ?? ?? 48 89 45 68 48 8B 45 68 48 89 45 28 EB 00 48 8D 05 ?? ?? ?? ?? 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_41_42_1 {
	meta:
		name = "__catch$?_Copy@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAAX_K0@Z$0"
		size = 77
		refs = "001e ?_Getal@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QEAAAEAU?$_Wrap_alloc@V?$allocator@_W@std@@@2@XZ 002d ?allocate@?$_Wrap_alloc@V?$allocator@_W@std@@@std@@QEAAPEA_W_K@Z 0042 $LN19"
	strings:
		$1 = { 48 8B 85 A8 00 00 00 48 89 45 20 48 8B 45 20 48 FF C0 48 89 45 60 48 8B 8D A0 00 00 00 E8 ?? ?? ?? ?? 48 8B 4D 60 48 8B D1 48 8B C8 E8 ?? ?? ?? ?? 48 89 45 68 48 8B 45 68 48 89 45 28 EB 00 48 8D 05 ?? ?? ?? ?? 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_1_181_1 {
	meta:
		name = "__catch$?_Copy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_K0@Z$1"
		size = 41
		refs = "000d ?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_N_K@Z 0016 _CxxThrowException 001e $LN17"
	strings:
		$1 = { 45 33 C0 B2 01 48 8B 8D A0 00 00 00 E8 ?? ?? ?? ?? 33 D2 33 C9 E8 ?? ?? ?? ?? 90 48 8D 05 ?? ?? ?? ?? 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_119_518_1 {
	meta:
		name = "__catch$?_Copy@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEAAX_K0@Z$1"
		size = 41
		refs = "000d ?_Tidy@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEAAX_N_K@Z 0016 _CxxThrowException 001e $LN17"
	strings:
		$1 = { 45 33 C0 B2 01 48 8B 8D A0 00 00 00 E8 ?? ?? ?? ?? 33 D2 33 C9 E8 ?? ?? ?? ?? 90 48 8D 05 ?? ?? ?? ?? 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_41_44_1 {
	meta:
		name = "__catch$?_Copy@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAAX_K0@Z$1"
		size = 41
		refs = "000d ?_Tidy@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAAX_N_K@Z 0016 _CxxThrowException 001e $LN17"
	strings:
		$1 = { 45 33 C0 B2 01 48 8B 8D A0 00 00 00 E8 ?? ?? ?? ?? 33 D2 33 C9 E8 ?? ?? ?? ?? 90 48 8D 05 ?? ?? ?? ?? 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_1_182_1 {
	meta:
		name = "?_Deallocate@std@@YAXPEAX_K1@Z"
		size = 935
		refs = "002b ??_C@_0BN@HMCJOMKN@_Count?5?$DM?$DN?5?$CIsize_t?$CJ?$CI?91?$CJ?5?1?5_Sz?$AA@ 003d ??_C@_1EI@MLOBABC@?$AA?$CC?$AA_?$AAC?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AA?$CI?$AAs?$AAi?$AAz?$AAe?$AA_?$AAt?$AA?$CJ?$AA?$CI?$AA?9?$AA1?$AA?$CJ?$AA?5?$AA?1?$AA?5?$AA_?$AAS?$AAz?$AA?$CC?$AA?5?$AA?$CG@ 0049 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 005e ??_C@_1FC@CNLMDHOG@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAs?$AAt?$AAd?$AAh?$AAp?$AAp?$AA?2@ 0068 _CrtDbgReportW 008d ??_C@_1CC@LOFJFFDB@?$AAs?$AAt?$AAd?$AA?3?$AA?3?$AA_?$AAD?$AAe?$AAa?$AAl?$AAl?$AAo?$AAc?$AAa?$AAt?$AAe?$AA?$AA@ 0094 ??_C@_1CG@JNLFBNGN@?$AA?$CC?$AAi?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAa?$AAr?$AAg?$AAu?$AAm?$AAe?$AAn?$AAt?$AA?$CC?$AA?$AA@ 0099 _invalid_parameter 00d7 ??_C@_0DD@GBGGGKGG@?$CI_Ptr_user?5?$CG?5?$CI_BIG_ALLOCATION_AL@ 00e9 ??_C@_1HE@CDMBFOKC@?$AA?$CC?$AA?$CI?$AA_?$AAP?$AAt?$AAr?$AA_?$AAu?$AAs?$AAe?$AAr?$AA?5?$AA?$CG?$AA?5?$AA?$CI?$AA_?$AAB?$AAI?$AAG?$AA_?$AAA?$AAL?$AAL?$AAO?$AAC?$AAA?$AAT?$AAI?$AAO?$AAN?$AA_?$AAA@ 0185 ??_C@_0EI@NOJHEJCJ@reinterpret_cast?$DMuintptr_t?5?$CK?$DO?$CI_P@ 0197 ??_C@_1JO@EKLKIEHP@?$AA?$CC?$AAr?$AAe?$AAi?$AAn?$AAt?$AAe?$AAr?$AAp?$AAr?$AAe?$AAt?$AA_?$AAc?$AAa?$AAs?$AAt?$AA?$DM?$AAu?$AAi?$AAn?$AAt?$AAp?$AAt?$AAr?$AA_?$AAt?$AA?5?$AA?$CK?$AA?$DO?$AA?$CI?$AA_@ 0206 ??_C@_0BL@OCKMEJON@_Ptr_container?5?$DM?5_Ptr_user?$AA@ 0218 ??_C@_1EE@PDHAHDDC@?$AA?$CC?$AA_?$AAP?$AAt?$AAr?$AA_?$AAc?$AAo?$AAn?$AAt?$AAa?$AAi?$AAn?$AAe?$AAr?$AA?5?$AA?$DM?$AA?5?$AA_?$AAP?$AAt?$AAr?$AA_?$AAu?$AAs?$AAe?$AAr?$AA?$CC?$AA?5?$AA?$CG?$AA?$CG?$AA?5@ 0291 ??_C@_0DB@GLFJLNCE@2?5?$CK?5sizeof?$CIvoid?5?$CK?$CJ?5?$DM?$DN?5_Ptr_user?5@ 02a3 ??_C@_1HA@NAPGMHAO@?$AA?$CC?$AA2?$AA?5?$AA?$CK?$AA?5?$AAs?$AAi?$AAz?$AAe?$AAo?$AAf?$AA?$CI?$AAv?$AAo?$AAi?$AAd?$AA?5?$AA?$CK?$AA?$CJ?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AA_?$AAP?$AAt?$AAr?$AA_?$AAu?$AAs?$AAe?$AAr@ 031c ??_C@_0CN@BLHJCAL@_Ptr_user?5?9?5_Ptr_container?5?$DM?$DN?5_N@ 032e ??_C@_1GI@DHJGPFNI@?$AA?$CC?$AA_?$AAP?$AAt?$AAr?$AA_?$AAu?$AAs?$AAe?$AAr?$AA?5?$AA?9?$AA?5?$AA_?$AAP?$AAt?$AAr?$AA_?$AAc?$AAo?$AAn?$AAt?$AAa?$AAi?$AAn?$AAe?$AAr?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AA_@ 039e ??3@YAXPEAX@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 58 33 D2 48 C7 C0 FF FF FF FF 48 F7 74 24 70 48 39 44 24 68 76 75 48 8D 05 ?? ?? ?? ?? 48 85 C0 74 06 33 C0 85 C0 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 5E 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 48 C7 44 24 20 00 00 00 00 41 B9 5E 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 44 24 68 48 0F AF 44 24 70 48 89 44 24 48 48 81 7C 24 48 00 10 00 00 0F 82 DC 02 00 00 48 8B 44 24 60 48 89 44 24 30 48 8B 44 24 30 48 83 E0 1F 48 85 C0 74 75 48 8D 05 ?? ?? ?? ?? 48 85 C0 74 06 33 C0 85 C0 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 64 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 48 C7 44 24 20 00 00 00 00 41 B9 64 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 E8 08 48 89 44 24 40 48 8B 44 24 40 48 8B 00 48 89 44 24 38 B8 08 00 00 00 48 6B C0 FF 48 8B 4C 24 40 48 BA FA FA FA FA FA FA FA FA 48 39 14 01 74 75 48 8D 05 ?? ?? ?? ?? 48 85 C0 74 06 33 C0 85 C0 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 6E 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 48 C7 44 24 20 00 00 00 00 41 B9 6E 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 44 24 30 48 39 44 24 38 72 75 48 8D 05 ?? ?? ?? ?? 48 85 C0 74 06 33 C0 85 C0 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 72 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 48 C7 44 24 20 00 00 00 00 41 B9 72 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 44 24 38 48 8B 4C 24 30 48 2B C8 48 8B C1 48 83 F8 10 73 75 48 8D 05 ?? ?? ?? ?? 48 85 C0 74 06 33 C0 85 C0 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 76 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 48 C7 44 24 20 00 00 00 00 41 B9 76 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 44 24 38 48 8B 4C 24 30 48 2B C8 48 8B C1 48 83 F8 2F 76 75 48 8D 05 ?? ?? ?? ?? 48 85 C0 74 06 33 C0 85 C0 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 7E 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 48 C7 44 24 20 00 00 00 00 41 B9 7E 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 44 24 38 48 89 44 24 60 48 8B 4C 24 60 E8 ?? ?? ?? ?? 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_1_183_1 {
	meta:
		name = "?_Decref@facet@locale@std@@UEAAPEAV_Facet_base@3@XZ"
		size = 43
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 83 C0 08 B9 FF FF FF FF F0 0F C1 08 FF C9 8B C1 85 C0 75 09 48 8B 44 24 08 EB 04 EB 02 33 C0 C3 }
	condition:
		$1
}

rule file_1_184_1 {
	meta:
		name = "?_Endwrite@?$basic_filebuf@DU?$char_traits@D@std@@@std@@IEAA_NXZ"
		size = 717
		refs = "0018 __security_cookie 005b ?eof@?$char_traits@D@std@@SAHXZ 007d _guard_check_icall 00ab ?eq_int_type@?$char_traits@D@std@@SA_NAEBH0@Z 00ce ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@_KD@Z 00e4 ?begin@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@2@XZ 00ec ??D?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEBAAEADXZ 00fe ?size@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBA_KXZ 0160 ?unshift@?$codecvt@DDU_Mbstatet@@@std@@QEBAHAEAU_Mbstatet@@PEAD1AEAPEAD@Z 0201 fwrite 021a ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@XZ 026a ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@_KD@Z 02c1 __security_check_cookie"
	strings:
		$1 = { 48 89 4C 24 08 48 81 EC D8 00 00 00 48 C7 44 24 78 FE FF FF FF 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 C0 00 00 00 48 8B 84 24 E0 00 00 00 48 83 78 68 00 74 10 48 8B 84 24 E0 00 00 00 0F B6 40 71 85 C0 75 0C B0 01 E9 68 02 00 00 E9 63 02 00 00 C7 44 24 58 08 00 00 00 E8 ?? ?? ?? ?? 89 44 24 40 48 8B 8C 24 E0 00 00 00 48 8B 09 48 8B 49 18 48 89 4C 24 50 48 8B 4C 24 50 E8 ?? ?? ?? ?? 8B 44 24 40 8B D0 48 8B 8C 24 E0 00 00 00 FF 54 24 50 89 44 24 44 E8 ?? ?? ?? ?? 89 44 24 48 48 8D 54 24 44 48 8D 4C 24 48 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 07 32 C0 E9 F8 01 00 00 45 33 C0 BA 08 00 00 00 48 8D 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 90 48 8D 94 24 80 00 00 00 48 8D 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 89 44 24 60 48 8D 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 48 8B 4C 24 60 48 03 C8 48 8B C1 48 89 44 24 68 48 8D 94 24 88 00 00 00 48 8D 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 8B 8C 24 E0 00 00 00 48 83 C1 74 48 8D 54 24 70 48 89 54 24 20 48 8B 54 24 68 4C 8B CA 4C 8B C0 48 8B D1 48 8B 84 24 E0 00 00 00 48 8B 48 68 E8 ?? ?? ?? ?? 89 44 24 34 83 7C 24 34 00 74 17 83 7C 24 34 01 74 1C 83 7C 24 34 03 0F 84 EF 00 00 00 E9 03 01 00 00 48 8B 84 24 E0 00 00 00 C6 40 71 00 48 8D 94 24 90 00 00 00 48 8D 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 8B 4C 24 70 48 2B C8 48 8B C1 48 89 44 24 38 48 83 7C 24 38 00 76 61 48 8D 94 24 98 00 00 00 48 8D 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 8B 8C 24 E0 00 00 00 4C 8B 89 80 00 00 00 4C 8B 44 24 38 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 48 39 44 24 38 74 1C C6 44 24 30 00 48 8D 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 0F B6 44 24 30 E9 8D 00 00 00 48 8B 84 24 E0 00 00 00 0F B6 40 71 85 C0 75 19 C6 44 24 31 01 48 8D 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 0F B6 44 24 31 EB 64 48 83 7C 24 38 00 75 15 45 33 C0 BA 08 00 00 00 48 8D 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? EB 32 C6 44 24 32 01 48 8D 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 0F B6 44 24 32 EB 2C C6 44 24 33 00 48 8D 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 0F B6 44 24 33 EB 13 E9 2C FE FF FF 48 8D 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 90 48 8B 8C 24 C0 00 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 D8 00 00 00 C3 }
	condition:
		$1
}

rule file_1_185_1 {
	meta:
		name = "?dtor$0@?0??_Endwrite@?$basic_filebuf@DU?$char_traits@D@std@@@std@@IEAA_NXZ@4HA"
		size = 27
		refs = "0011 ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@XZ"
		altNames = "?dtor$0@?0??do_put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@DN@Z@4HA ?dtor$0@?0??do_put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@DO@Z@4HA ?dtor$0@?0??do_put@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AEAVios_base@2@GN@Z@4HA ?dtor$0@?0??do_put@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AEAVios_base@2@GO@Z@4HA ?dtor$0@?0??do_put@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AEAVios_base@2@_WN@Z@4HA ?dtor$0@?0??do_put@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AEAVios_base@2@_WO@Z@4HA ?dtor$1@?0??_Getifld@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@1HAEBVlocale@2@@Z@4HA ?dtor$1@?0??_Getifld@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@1HAEBVlocale@2@@Z@4HA"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 8D A0 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_62_217_1 {
	meta:
		name = "?dtor$0@?0??_Iput@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@DPEAD_K@Z@4HA"
		size = 27
		refs = "0011 ??1locale@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 8D A0 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_119_780_1 {
	meta:
		name = "?dtor$0@?0??_Iput@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@AEBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AEAVios_base@2@GPEAD_K@Z@4HA"
		size = 27
		refs = "0011 ??1locale@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 8D A0 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_119_785_1 {
	meta:
		name = "?dtor$0@?0??_Iput@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@AEBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AEAVios_base@2@_WPEAD_K@Z@4HA"
		size = 27
		refs = "0011 ??1locale@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 8D A0 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_89_500_2 {
	meta:
		name = "?dtor$1@?0??do_transform@?$collate@D@std@@MEBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@PEBD0@Z@4HA"
		size = 27
		refs = "0011 ??1?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 8D A0 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_10_1278_2 {
	meta:
		name = "?dtor$1@?0??do_transform@?$collate@G@std@@MEBA?AV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@PEBG0@Z@4HA"
		size = 27
		refs = "0011 ??1?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 8D A0 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_10_1282_2 {
	meta:
		name = "?dtor$1@?0??do_transform@?$collate@_W@std@@MEBA?AV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@PEB_W0@Z@4HA"
		size = 27
		refs = "0011 ??1?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 8D A0 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_1_186_1 {
	meta:
		name = "?_Eos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_K@Z"
		size = 81
		refs = "0014 ?_Get_data@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAAAEAV?$_String_val@U?$_Simple_types@D@std@@@2@XZ 0036 ?_Myptr@?$_String_val@U?$_Simple_types@D@std@@@std@@QEAAPEADXZ 0048 ?assign@?$char_traits@D@std@@SAXAEADAEBD@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 89 44 24 28 C6 44 24 20 00 48 8B 44 24 28 48 8B 4C 24 48 48 89 48 10 48 8B 4C 24 28 E8 ?? ?? ?? ?? 48 03 44 24 48 48 8D 54 24 20 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1_195_1 {
	meta:
		name = "?_Getcat@?$codecvt@DDU_Mbstatet@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z"
		size = 241
		refs = "0049 ??2_Crt_new_delete@std@@SAPEAX_K@Z 0063 ?c_str@locale@std@@QEBAPEBDXZ 0070 ??0_Locinfo@std@@QEAA@PEBD@Z 009c ??0?$codecvt@DDU_Mbstatet@@@std@@QEAA@AEBV_Locinfo@1@_K@Z 00e0 ??1_Locinfo@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 81 EC C8 00 00 00 48 C7 44 24 50 FE FF FF FF C7 44 24 20 00 00 00 00 48 83 BC 24 D0 00 00 00 00 0F 84 B3 00 00 00 48 8B 84 24 D0 00 00 00 48 83 38 00 0F 85 A1 00 00 00 B9 10 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 28 48 83 7C 24 28 00 74 4D 48 8B 8C 24 D8 00 00 00 E8 ?? ?? ?? ?? 48 8B D0 48 8D 4C 24 58 E8 ?? ?? ?? ?? 48 89 44 24 38 48 8B 44 24 38 48 89 44 24 40 8B 44 24 20 83 C8 01 89 44 24 20 45 33 C0 48 8B 54 24 40 48 8B 4C 24 28 E8 ?? ?? ?? ?? 48 89 44 24 30 EB 09 48 C7 44 24 30 00 00 00 00 48 8B 44 24 30 48 89 44 24 48 48 8B 84 24 D0 00 00 00 48 8B 4C 24 48 48 89 08 8B 44 24 20 83 E0 01 85 C0 74 0F 83 64 24 20 FE 48 8D 4C 24 58 E8 ?? ?? ?? ?? B8 02 00 00 00 48 81 C4 C8 00 00 00 C3 }
	condition:
		$1
}

rule file_1_196_1 {
	meta:
		name = "?dtor$0@?0??_Getcat@?$codecvt@DDU_Mbstatet@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA"
		size = 24
		refs = "000e ??3_Crt_new_delete@std@@SAXPEAX@Z"
		altNames = "?dtor$0@?0??_Getcat@?$codecvt@GDU_Mbstatet@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$0@?0??_Getcat@?$codecvt@_WDU_Mbstatet@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$0@?0??_Getcat@?$collate@D@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$0@?0??_Getcat@?$collate@G@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$0@?0??_Getcat@?$collate@_W@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$0@?0??_Getcat@?$ctype@D@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$0@?0??_Getcat@?$ctype@G@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$0@?0??_Getcat@?$ctype@_W@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$0@?0??_Getcat@?$messages@D@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$0@?0??_Getcat@?$messages@G@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$0@?0??_Getcat@?$messages@_W@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$0@?0??_Getcat@?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$0@?0??_Getcat@?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$0@?0??_Getcat@?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$0@?0??_Getcat@?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$0@?0??_Getcat@?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$0@?0??_Getcat@?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$0@?0??_Getcat@?$moneypunct@D$00@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$0@?0??_Getcat@?$moneypunct@D$0A@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$0@?0??_Getcat@?$moneypunct@G$00@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$0@?0??_Getcat@?$moneypunct@G$0A@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$0@?0??_Getcat@?$moneypunct@_W$00@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$0@?0??_Getcat@?$moneypunct@_W$0A@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$0@?0??_Getcat@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$0@?0??_Getcat@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$0@?0??_Getcat@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$0@?0??_Getcat@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$0@?0??_Getcat@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$0@?0??_Getcat@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$0@?0??_Getcat@?$numpunct@D@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$0@?0??_Getcat@?$numpunct@G@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$0@?0??_Getcat@?$numpunct@_W@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$0@?0??_Getcat@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$0@?0??_Getcat@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$0@?0??_Getcat@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$0@?0??_Getcat@?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$0@?0??_Getcat@?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$0@?0??_Getcat@?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 28 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_1_197_1 {
	meta:
		name = "?dtor$1@?0??_Getcat@?$codecvt@DDU_Mbstatet@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA"
		size = 38
		refs = "001c ??1_Locinfo@std@@QEAA@XZ"
		altNames = "?dtor$1@?0??_Getcat@?$codecvt@GDU_Mbstatet@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$1@?0??_Getcat@?$codecvt@_WDU_Mbstatet@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$1@?0??_Getcat@?$ctype@D@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$1@?0??_Getcat@?$ctype@G@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$1@?0??_Getcat@?$ctype@_W@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$1@?0??_Getcat@?$messages@D@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$1@?0??_Getcat@?$messages@G@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$1@?0??_Getcat@?$messages@_W@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$1@?0??_Getcat@?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$1@?0??_Getcat@?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$1@?0??_Getcat@?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$1@?0??_Getcat@?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$1@?0??_Getcat@?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$1@?0??_Getcat@?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$1@?0??_Getcat@?$moneypunct@D$00@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$1@?0??_Getcat@?$moneypunct@D$0A@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$1@?0??_Getcat@?$moneypunct@G$00@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$1@?0??_Getcat@?$moneypunct@G$0A@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$1@?0??_Getcat@?$moneypunct@_W$00@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$1@?0??_Getcat@?$moneypunct@_W$0A@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$1@?0??_Getcat@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$1@?0??_Getcat@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$1@?0??_Getcat@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$1@?0??_Getcat@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$1@?0??_Getcat@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$1@?0??_Getcat@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$1@?0??_Getcat@?$numpunct@D@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$1@?0??_Getcat@?$numpunct@G@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$1@?0??_Getcat@?$numpunct@_W@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$1@?0??_Getcat@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$1@?0??_Getcat@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$1@?0??_Getcat@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$1@?0??_Getcat@?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$1@?0??_Getcat@?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$1@?0??_Getcat@?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 8B 45 20 83 E0 01 85 C0 74 0D 83 65 20 FE 48 8D 4D 58 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_1_198_1 {
	meta:
		name = "?_Getcat@?$ctype@D@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z"
		size = 241
		refs = "0049 ??2_Crt_new_delete@std@@SAPEAX_K@Z 0063 ?c_str@locale@std@@QEBAPEBDXZ 0070 ??0_Locinfo@std@@QEAA@PEBD@Z 009c ??0?$ctype@D@std@@QEAA@AEBV_Locinfo@1@_K@Z 00e0 ??1_Locinfo@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 81 EC C8 00 00 00 48 C7 44 24 50 FE FF FF FF C7 44 24 20 00 00 00 00 48 83 BC 24 D0 00 00 00 00 0F 84 B3 00 00 00 48 8B 84 24 D0 00 00 00 48 83 38 00 0F 85 A1 00 00 00 B9 30 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 28 48 83 7C 24 28 00 74 4D 48 8B 8C 24 D8 00 00 00 E8 ?? ?? ?? ?? 48 8B D0 48 8D 4C 24 58 E8 ?? ?? ?? ?? 48 89 44 24 38 48 8B 44 24 38 48 89 44 24 40 8B 44 24 20 83 C8 01 89 44 24 20 45 33 C0 48 8B 54 24 40 48 8B 4C 24 28 E8 ?? ?? ?? ?? 48 89 44 24 30 EB 09 48 C7 44 24 30 00 00 00 00 48 8B 44 24 30 48 89 44 24 48 48 8B 84 24 D0 00 00 00 48 8B 4C 24 48 48 89 08 8B 44 24 20 83 E0 01 85 C0 74 0F 83 64 24 20 FE 48 8D 4C 24 58 E8 ?? ?? ?? ?? B8 02 00 00 00 48 81 C4 C8 00 00 00 C3 }
	condition:
		$1
}

rule file_1_201_1 {
	meta:
		name = "?_Getctype@_Locinfo@std@@QEBA?AU_Ctypevec@@XZ"
		size = 82
		refs = "0016 _Getctype"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 56 57 48 83 EC 68 48 8D 4C 24 40 E8 ?? ?? ?? ?? 48 8D 4C 24 20 48 8B F9 48 8B F0 B9 20 00 00 00 F3 A4 48 8D 44 24 20 48 8B BC 24 88 00 00 00 48 8B F0 B9 20 00 00 00 F3 A4 48 8B 84 24 88 00 00 00 48 83 C4 68 5F 5E C3 }
	condition:
		$1
}

rule file_1_202_1 {
	meta:
		name = "?_Getfacet@locale@std@@QEBAPEBVfacet@12@_K@Z"
		size = 186
		refs = "0075 ?_Getgloballocale@locale@std@@CAPEAV_Locimp@12@XZ"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 48 8B 44 24 50 48 8B 40 08 48 8B 40 18 48 39 44 24 58 73 1D 48 8B 44 24 50 48 8B 40 08 48 8B 40 10 48 8B 4C 24 58 48 8B 04 C8 48 89 44 24 20 EB 09 48 C7 44 24 20 00 00 00 00 48 8B 44 24 20 48 89 44 24 28 48 83 7C 24 28 00 75 11 48 8B 44 24 50 48 8B 40 08 0F B6 40 24 85 C0 75 09 48 8B 44 24 28 EB 43 EB 41 E8 ?? ?? ?? ?? 48 89 44 24 30 48 8B 44 24 30 48 8B 40 18 48 39 44 24 58 73 19 48 8B 44 24 30 48 8B 40 10 48 8B 4C 24 58 48 8B 04 C8 48 89 44 24 38 EB 09 48 C7 44 24 38 00 00 00 00 48 8B 44 24 38 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_1_203_1 {
	meta:
		name = "?_Gnavail@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEBA_JXZ"
		size = 56
		altNames = "?_Gnavail@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEBA_JXZ ?_Gnavail@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEBA_JXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 18 48 8B 44 24 20 48 8B 40 38 48 83 38 00 74 10 48 8B 44 24 20 48 8B 40 50 8B 00 89 04 24 EB 07 C7 04 24 00 00 00 00 48 63 04 24 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_1_204_1 {
	meta:
		name = "?_Gndec@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAPEADXZ"
		size = 77
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 18 48 8B 44 24 20 48 8B 40 50 8B 00 FF C0 48 8B 4C 24 20 48 8B 49 50 89 01 48 8B 44 24 20 48 8B 40 38 48 8B 00 48 FF C8 48 89 04 24 48 8B 44 24 20 48 8B 40 38 48 8B 0C 24 48 89 08 48 8B 04 24 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_1_205_1 {
	meta:
		name = "?_Gninc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAPEADXZ"
		size = 85
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 18 48 8B 44 24 20 48 8B 40 50 8B 00 FF C8 48 8B 4C 24 20 48 8B 49 50 89 01 48 8B 44 24 20 48 8B 40 38 48 8B 00 48 89 04 24 48 8B 44 24 20 48 8B 40 38 48 8B 00 48 FF C0 48 8B 4C 24 20 48 8B 49 38 48 89 01 48 8B 04 24 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_1_206_1 {
	meta:
		name = "?_Grow@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA_N_K_N@Z"
		size = 238
		refs = "0019 ?max_size@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBA_KXZ 002a ?_Xlen@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBAXXZ 0034 ?_Myres@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAAAEA_KXZ 0048 ?_Mysize@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAAAEA_KXZ 005a ?_Copy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_K0@Z 00b0 ?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_N_K@Z 00c6 ?_Eos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_K@Z"
	strings:
		$1 = { 44 88 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 3B 44 24 48 73 0A 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 4C 24 48 48 39 08 73 1E 48 8B 4C 24 40 E8 ?? ?? ?? ?? 4C 8B 00 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? EB 6A 0F B6 44 24 50 85 C0 74 4D 48 83 7C 24 48 10 73 45 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 00 48 39 44 24 48 73 0C 48 8B 44 24 48 48 89 44 24 28 EB 12 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 00 48 89 44 24 28 4C 8B 44 24 28 B2 01 48 8B 4C 24 40 E8 ?? ?? ?? ?? EB 14 48 83 7C 24 48 00 75 0C 33 D2 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 7C 24 48 00 76 0A C7 44 24 20 01 00 00 00 EB 08 C7 44 24 20 00 00 00 00 0F B6 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1_207_1 {
	meta:
		name = "?_Incref@facet@locale@std@@UEAAXXZ"
		size = 18
		altNames = "?_Incref@_Ref_count_base@std@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 83 C0 08 F0 FF 00 C3 }
	condition:
		$1
}

rule file_1_208_1 {
	meta:
		name = "?_Init@?$basic_filebuf@DU?$char_traits@D@std@@@std@@IEAAXPEAU_iobuf@@W4_Initfl@12@@Z"
		size = 296
		refs = "0054 ?_Init@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAXXZ 00a1 _get_stream_buffer_pointers 00e5 ?_Init@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAXPEAPEAD0PEAH001@Z 010b ?_Stinit@?1??_Init@?$basic_filebuf@DU?$char_traits@D@std@@@std@@IEAAXPEAU_iobuf@@W4_Initfl@23@@Z@4U_Mbstatet@@A"
	strings:
		$1 = { 44 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 78 83 BC 24 90 00 00 00 01 75 0A C7 44 24 40 01 00 00 00 EB 08 C7 44 24 40 00 00 00 00 48 8B 84 24 80 00 00 00 0F B6 4C 24 40 88 48 7C 48 8B 84 24 80 00 00 00 C6 40 71 00 48 8B 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 48 83 BC 24 88 00 00 00 00 0F 84 82 00 00 00 33 C0 83 F8 01 74 7B 48 C7 44 24 58 00 00 00 00 48 C7 44 24 50 00 00 00 00 48 C7 44 24 48 00 00 00 00 4C 8D 4C 24 48 4C 8D 44 24 50 48 8D 54 24 58 48 8B 8C 24 88 00 00 00 E8 ?? ?? ?? ?? 48 8B 44 24 48 48 89 44 24 60 48 8B 44 24 60 48 89 44 24 30 48 8B 44 24 50 48 89 44 24 28 48 8B 44 24 58 48 89 44 24 20 4C 8B 4C 24 48 4C 8B 44 24 50 48 8B 54 24 58 48 8B 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 48 8B 8C 24 88 00 00 00 48 89 88 80 00 00 00 48 8B 84 24 80 00 00 00 48 8B 0D ?? ?? ?? ?? 48 89 48 74 48 8B 84 24 80 00 00 00 48 C7 40 68 00 00 00 00 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_1_209_1 {
	meta:
		name = "?_Init@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAXPEAPEAD0PEAH001@Z"
		size = 105
		altNames = "?_Init@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEAAXPEAPEAG0PEAH001@Z ?_Init@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEAAXPEAPEA_W0PEAH001@Z"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 8B 44 24 08 48 8B 4C 24 10 48 89 48 18 48 8B 44 24 08 48 8B 4C 24 28 48 89 48 20 48 8B 44 24 08 48 8B 4C 24 18 48 89 48 38 48 8B 44 24 08 48 8B 4C 24 30 48 89 48 40 48 8B 44 24 08 48 8B 4C 24 20 48 89 48 50 48 8B 44 24 08 48 8B 4C 24 38 48 89 48 58 C3 }
	condition:
		$1
}

rule file_1_210_1 {
	meta:
		name = "?_Init@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAXXZ"
		size = 155
		refs = "0080 ?setp@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAXPEAD0@Z 0092 ?setg@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAXPEAD00@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 83 C0 08 48 8B 4C 24 30 48 89 41 18 48 8B 44 24 30 48 83 C0 10 48 8B 4C 24 30 48 89 41 20 48 8B 44 24 30 48 83 C0 28 48 8B 4C 24 30 48 89 41 38 48 8B 44 24 30 48 83 C0 30 48 8B 4C 24 30 48 89 41 40 48 8B 44 24 30 48 83 C0 48 48 8B 4C 24 30 48 89 41 50 48 8B 44 24 30 48 83 C0 4C 48 8B 4C 24 30 48 89 41 58 45 33 C0 33 D2 48 8B 4C 24 30 E8 ?? ?? ?? ?? 45 33 C9 45 33 C0 33 D2 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_40_244_2 {
	meta:
		name = "?_Init@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEAAXXZ"
		size = 155
		refs = "0080 ?setp@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEAAXPEAG0@Z 0092 ?setg@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEAAXPEAG00@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 83 C0 08 48 8B 4C 24 30 48 89 41 18 48 8B 44 24 30 48 83 C0 10 48 8B 4C 24 30 48 89 41 20 48 8B 44 24 30 48 83 C0 28 48 8B 4C 24 30 48 89 41 38 48 8B 44 24 30 48 83 C0 30 48 8B 4C 24 30 48 89 41 40 48 8B 44 24 30 48 83 C0 48 48 8B 4C 24 30 48 89 41 50 48 8B 44 24 30 48 83 C0 4C 48 8B 4C 24 30 48 89 41 58 45 33 C0 33 D2 48 8B 4C 24 30 E8 ?? ?? ?? ?? 45 33 C9 45 33 C0 33 D2 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_116_266_3 {
	meta:
		name = "?_Init@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEAAXXZ"
		size = 155
		refs = "0080 ?setp@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEAAXPEA_W0@Z 0092 ?setg@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEAAXPEA_W00@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 83 C0 08 48 8B 4C 24 30 48 89 41 18 48 8B 44 24 30 48 83 C0 10 48 8B 4C 24 30 48 89 41 20 48 8B 44 24 30 48 83 C0 28 48 8B 4C 24 30 48 89 41 38 48 8B 44 24 30 48 83 C0 30 48 8B 4C 24 30 48 89 41 40 48 8B 44 24 30 48 83 C0 48 48 8B 4C 24 30 48 89 41 50 48 8B 44 24 30 48 83 C0 4C 48 8B 4C 24 30 48 89 41 58 45 33 C0 33 D2 48 8B 4C 24 30 E8 ?? ?? ?? ?? 45 33 C9 45 33 C0 33 D2 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_212_1 {
	meta:
		name = "?_Init@?$ctype@D@std@@IEAAXAEBV_Locinfo@2@@Z"
		size = 57
		refs = "001b ?_Getctype@_Locinfo@std@@QEBA?AU_Ctypevec@@XZ"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 56 57 48 83 EC 48 48 8D 54 24 20 48 8B 4C 24 68 E8 ?? ?? ?? ?? 48 8B 4C 24 60 48 8D 79 10 48 8B F0 B9 20 00 00 00 F3 A4 48 83 C4 48 5F 5E C3 }
	condition:
		$1
}

rule file_1_213_1 {
	meta:
		name = "?_Init@ios_base@std@@IEAAXXZ"
		size = 191
		refs = "0077 ?clear@ios_base@std@@QEAAXH@Z 0081 ??2_Crt_new_delete@std@@SAPEAX_K@Z 0098 ??0locale@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 48 C7 40 40 00 00 00 00 48 8B 44 24 40 48 C7 40 08 00 00 00 00 48 8B 44 24 40 C7 40 14 00 00 00 00 48 8B 44 24 40 C7 40 18 01 02 00 00 48 8B 44 24 40 48 C7 40 20 06 00 00 00 48 8B 44 24 40 48 C7 40 28 00 00 00 00 48 8B 44 24 40 48 C7 40 30 00 00 00 00 48 8B 44 24 40 48 C7 40 38 00 00 00 00 33 D2 48 8B 4C 24 40 E8 ?? ?? ?? ?? B9 10 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 20 48 83 7C 24 20 00 74 11 48 8B 4C 24 20 E8 ?? ?? ?? ?? 48 89 44 24 28 EB 09 48 C7 44 24 28 00 00 00 00 48 8B 44 24 40 48 8B 4C 24 28 48 89 48 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1_214_1 {
	meta:
		name = "?_Init_atomic_counter@std@@YAXAEAKK@Z"
		size = 21
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 8B 44 24 08 8B 4C 24 10 89 08 C3 }
	condition:
		$1
}

rule file_1_215_1 {
	meta:
		name = "?_Initcvt@?$basic_filebuf@DU?$char_traits@D@std@@@std@@IEAAXPEBV?$codecvt@DDU_Mbstatet@@@2@@Z"
		size = 75
		refs = "0014 ?always_noconv@codecvt_base@std@@QEBA_NXZ 0042 ?_Init@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAXXZ"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 38 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 0F 48 8B 44 24 30 48 C7 40 68 00 00 00 00 EB 18 48 8B 44 24 30 48 8B 4C 24 38 48 89 48 68 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_40_249_2 {
	meta:
		name = "?_Initcvt@?$basic_filebuf@GU?$char_traits@G@std@@@std@@IEAAXPEBV?$codecvt@GDU_Mbstatet@@@2@@Z"
		size = 75
		refs = "0014 ?always_noconv@codecvt_base@std@@QEBA_NXZ 0042 ?_Init@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEAAXXZ"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 38 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 0F 48 8B 44 24 30 48 C7 40 68 00 00 00 00 EB 18 48 8B 44 24 30 48 8B 4C 24 38 48 89 48 68 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_116_271_3 {
	meta:
		name = "?_Initcvt@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@IEAAXPEBV?$codecvt@_WDU_Mbstatet@@@2@@Z"
		size = 75
		refs = "0014 ?always_noconv@codecvt_base@std@@QEBA_NXZ 0042 ?_Init@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEAAXXZ"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 38 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 0F 48 8B 44 24 30 48 C7 40 68 00 00 00 00 EB 18 48 8B 44 24 30 48 8B 4C 24 38 48 89 48 68 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_216_1 {
	meta:
		name = "?_Inside@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA_NPEBD@Z"
		size = 95
		refs = "001c ?_Myptr@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAAPEADXZ 003c ?_Mysize@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAAAEA_KXZ"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 83 7C 24 48 00 74 3C 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 39 44 24 48 72 2B 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 89 44 24 20 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 4C 24 20 48 03 08 48 8B C1 48 3B 44 24 48 77 06 32 C0 EB 04 EB 02 B0 01 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1_217_1 {
	meta:
		name = "?_Lock@?$basic_filebuf@DU?$char_traits@D@std@@@std@@UEAAXXZ"
		size = 46
		refs = "0025 _lock_file"
		altNames = "?_Lock@?$basic_filebuf@GU?$char_traits@G@std@@@std@@UEAAXXZ ?_Lock@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 83 B8 80 00 00 00 00 74 11 48 8B 44 24 30 48 8B 88 80 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_3_237_1 {
	meta:
		name = "?_Unlock@?$basic_filebuf@DU?$char_traits@D@std@@@std@@UEAAXXZ"
		size = 46
		refs = "0025 _unlock_file"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 83 B8 80 00 00 00 00 74 11 48 8B 44 24 30 48 8B 88 80 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_29_296_3 {
	meta:
		name = "?_Unlock@?$basic_filebuf@GU?$char_traits@G@std@@@std@@UEAAXXZ"
		size = 46
		refs = "0025 _unlock_file"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 83 B8 80 00 00 00 00 74 11 48 8B 44 24 30 48 8B 88 80 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_48_273_2 {
	meta:
		name = "?_Unlock@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UEAAXXZ"
		size = 46
		refs = "0025 _unlock_file"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 83 B8 80 00 00 00 00 74 11 48 8B 44 24 30 48 8B 88 80 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_219_1 {
	meta:
		name = "?_Makestr@_System_error@std@@CA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@Verror_code@2@V32@@Z"
		size = 224
		refs = "001f __security_cookie 003c ?empty@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBA_NXZ 004a ??_C@_02LMMGGCAJ@?3?5?$AA@ 0057 ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@PEBD@Z 0069 ?message@error_code@std@@QEBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ 008a ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@AEBV12@@Z 0095 ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@XZ 00aa ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@$$QEAV01@@Z 00d7 __security_check_cookie"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 38 FE FF FF FF 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 60 C7 44 24 20 00 00 00 00 48 8B 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 14 48 8D 15 ?? ?? ?? ?? 48 8B 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 8D 54 24 40 48 8B 8C 24 88 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 28 48 8B 44 24 28 48 89 44 24 30 48 8B 54 24 30 48 8B 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 48 8B 94 24 90 00 00 00 48 8B 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 8B 44 24 20 83 C8 01 89 44 24 20 48 8B 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 48 8B 4C 24 60 48 33 CC E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_1_220_1 {
	meta:
		name = "?dtor$0@?0??_Makestr@_System_error@std@@CA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@Verror_code@2@V32@@Z@4HA"
		size = 27
		refs = "0011 ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 8D 90 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_115_327_1 {
	meta:
		name = "?dtor$5@?0??_Makexloc@_Locimp@locale@std@@CAXAEBV_Locinfo@3@HPEAV123@PEBV23@@Z@4HA"
		size = 27
		refs = "0011 ??3_Crt_new_delete@std@@SAXPEAX@Z"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 8D 90 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_1_222_1 {
	meta:
		name = "?_Myptr@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAAPEADXZ"
		size = 32
		refs = "000f ?_Get_data@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAAAEAV?$_String_val@U?$_Simple_types@D@std@@@2@XZ 0017 ?_Myptr@?$_String_val@U?$_Simple_types@D@std@@@std@@QEAAPEADXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_89_388_2 {
	meta:
		name = "?_Myptr@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEBAPEBDXZ"
		size = 32
		refs = "000f ?_Get_data@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEBAAEBV?$_String_val@U?$_Simple_types@D@std@@@2@XZ 0017 ?_Myptr@?$_String_val@U?$_Simple_types@D@std@@@std@@QEBAPEBDXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_103_975_3 {
	meta:
		name = "?_Myptr@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QEAAPEAGXZ"
		size = 32
		refs = "000f ?_Get_data@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QEAAAEAV?$_String_val@U?$_Simple_types@G@std@@@2@XZ 0017 ?_Myptr@?$_String_val@U?$_Simple_types@G@std@@@std@@QEAAPEAGXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_10_927_2 {
	meta:
		name = "?_Myptr@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QEBAPEBGXZ"
		size = 32
		refs = "000f ?_Get_data@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QEBAAEBV?$_String_val@U?$_Simple_types@G@std@@@2@XZ 0017 ?_Myptr@?$_String_val@U?$_Simple_types@G@std@@@std@@QEBAPEBGXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_61_95_2 {
	meta:
		name = "?_Myptr@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QEAAPEA_WXZ"
		size = 32
		refs = "000f ?_Get_data@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QEAAAEAV?$_String_val@U?$_Simple_types@_W@std@@@2@XZ 0017 ?_Myptr@?$_String_val@U?$_Simple_types@_W@std@@@std@@QEAAPEA_WXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_20_101_3 {
	meta:
		name = "?_Myptr@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QEBAPEB_WXZ"
		size = 32
		refs = "000f ?_Get_data@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QEBAAEBV?$_String_val@U?$_Simple_types@_W@std@@@2@XZ 0017 ?_Myptr@?$_String_val@U?$_Simple_types@_W@std@@@std@@QEBAPEB_WXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_93_286_3 {
	meta:
		name = "?_Orphan_all@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAAXXZ"
		size = 32
		refs = "000f ?_Get_data@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAAAEAV?$_String_val@U?$_Simple_types@D@std@@@2@XZ 0017 ?_Orphan_all@_Container_base12@std@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_10_946_2 {
	meta:
		name = "?_Orphan_all@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QEAAXXZ"
		size = 32
		refs = "000f ?_Get_data@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QEAAAEAV?$_String_val@U?$_Simple_types@G@std@@@2@XZ 0017 ?_Orphan_all@_Container_base12@std@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_61_102_2 {
	meta:
		name = "?_Orphan_all@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QEAAXXZ"
		size = 32
		refs = "000f ?_Get_data@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QEAAAEAV?$_String_val@U?$_Simple_types@_W@std@@@2@XZ 0017 ?_Orphan_all@_Container_base12@std@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_7_43_1 {
	meta:
		name = "_Cnd_init_in_situ"
		size = 32
		refs = "000f ?_get_cv@_Cnd_internal_imp_t@@QEAAPEAVstl_condition_variable_interface@details@Concurrency@@XZ 0017 ?create_stl_condition_variable@details@Concurrency@@YAXPEAVstl_condition_variable_interface@12@@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_224_1 {
	meta:
		name = "?_Myptr@?$_String_val@U?$_Simple_types@D@std@@@std@@QEAAPEADXZ"
		size = 61
		refs = "001e ??$_Unfancy@D@std@@YAPEADPEAD@Z"
		altNames = "?_Myptr@?$_String_val@U?$_Simple_types@D@std@@@std@@QEBAPEBDXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 48 83 78 18 10 72 14 48 8B 44 24 40 48 8B 08 E8 ?? ?? ?? ?? 48 89 44 24 20 EB 0A 48 8B 44 24 40 48 89 44 24 20 48 8B 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1_226_1 {
	meta:
		name = "?_Myres@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAAAEA_KXZ"
		size = 28
		refs = "000f ?_Get_data@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAAAEAV?$_String_val@U?$_Simple_types@D@std@@@2@XZ"
		altNames = "?_Mysize@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAAAEA_KXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C0 18 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_85_125_1 {
	meta:
		name = "?_Myres@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEBAAEB_KXZ"
		size = 28
		refs = "000f ?_Get_data@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEBAAEBV?$_String_val@U?$_Simple_types@D@std@@@2@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C0 18 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_119_835_1 {
	meta:
		name = "?_Myres@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QEAAAEA_KXZ"
		size = 28
		refs = "000f ?_Get_data@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QEAAAEAV?$_String_val@U?$_Simple_types@G@std@@@2@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C0 18 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_93_45_1 {
	meta:
		name = "?_Myres@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QEAAAEA_KXZ"
		size = 28
		refs = "000f ?_Get_data@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QEAAAEAV?$_String_val@U?$_Simple_types@_W@std@@@2@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C0 18 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_46_271_3 {
	meta:
		name = "?_Mysize@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEBAAEB_KXZ"
		size = 28
		refs = "000f ?_Get_data@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEBAAEBV?$_String_val@U?$_Simple_types@D@std@@@2@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C0 18 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_10_941_2 {
	meta:
		name = "?_Mysize@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QEAAAEA_KXZ"
		size = 28
		refs = "000f ?_Get_data@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QEAAAEAV?$_String_val@U?$_Simple_types@G@std@@@2@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C0 18 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_103_991_3 {
	meta:
		name = "?_Mysize@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QEBAAEB_KXZ"
		size = 28
		refs = "000f ?_Get_data@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QEBAAEBV?$_String_val@U?$_Simple_types@G@std@@@2@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C0 18 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_104_66_3 {
	meta:
		name = "?_Mysize@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QEAAAEA_KXZ"
		size = 28
		refs = "000f ?_Get_data@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QEAAAEAV?$_String_val@U?$_Simple_types@_W@std@@@2@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C0 18 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_10_944_2 {
	meta:
		name = "?_Mysize@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QEBAAEB_KXZ"
		size = 28
		refs = "000f ?_Get_data@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QEBAAEBV?$_String_val@U?$_Simple_types@_W@std@@@2@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C0 18 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_227_1 {
	meta:
		name = "?_Mysize@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAAAEA_KXZ"
		size = 28
		refs = "000f ?_Get_data@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAAAEAV?$_String_val@U?$_Simple_types@D@std@@@2@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C0 10 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_3_228_1 {
	meta:
		name = "?_Mysize@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEBAAEB_KXZ"
		size = 28
		refs = "000f ?_Get_data@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEBAAEBV?$_String_val@U?$_Simple_types@D@std@@@2@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C0 10 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_119_839_1 {
	meta:
		name = "?_Mysize@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QEAAAEA_KXZ"
		size = 28
		refs = "000f ?_Get_data@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QEAAAEAV?$_String_val@U?$_Simple_types@G@std@@@2@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C0 10 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_119_840_1 {
	meta:
		name = "?_Mysize@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QEBAAEB_KXZ"
		size = 28
		refs = "000f ?_Get_data@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QEBAAEBV?$_String_val@U?$_Simple_types@G@std@@@2@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C0 10 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_93_46_1 {
	meta:
		name = "?_Mysize@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QEAAAEA_KXZ"
		size = 28
		refs = "000f ?_Get_data@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QEAAAEAV?$_String_val@U?$_Simple_types@_W@std@@@2@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C0 10 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_41_66_1 {
	meta:
		name = "?_Mysize@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QEBAAEB_KXZ"
		size = 28
		refs = "000f ?_Get_data@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QEBAAEBV?$_String_val@U?$_Simple_types@_W@std@@@2@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C0 10 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_229_1 {
	meta:
		name = "?_Pnavail@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEBA_JXZ"
		size = 56
		altNames = "?_Pnavail@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEBA_JXZ ?_Pnavail@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEBA_JXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 18 48 8B 44 24 20 48 8B 40 40 48 83 38 00 74 10 48 8B 44 24 20 48 8B 40 58 8B 00 89 04 24 EB 07 C7 04 24 00 00 00 00 48 63 04 24 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_1_230_1 {
	meta:
		name = "?_Pninc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAPEADXZ"
		size = 85
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 18 48 8B 44 24 20 48 8B 40 58 8B 00 FF C8 48 8B 4C 24 20 48 8B 49 58 89 01 48 8B 44 24 20 48 8B 40 40 48 8B 00 48 89 04 24 48 8B 44 24 20 48 8B 40 40 48 8B 00 48 FF C0 48 8B 4C 24 20 48 8B 49 40 48 89 01 48 8B 04 24 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_1_231_1 {
	meta:
		name = "?_Reset_back@?$basic_filebuf@DU?$char_traits@D@std@@@std@@AEAAXXZ"
		size = 84
		refs = "000f ?eback@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEBAPEADXZ 004b ?setg@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAXPEAD00@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 4C 24 30 48 83 C1 70 48 3B C1 75 2E 48 8B 44 24 30 4C 8B 88 90 00 00 00 48 8B 44 24 30 4C 8B 80 88 00 00 00 48 8B 44 24 30 48 8B 90 88 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_40_268_2 {
	meta:
		name = "?_Reset_back@?$basic_filebuf@GU?$char_traits@G@std@@@std@@AEAAXXZ"
		size = 84
		refs = "000f ?eback@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEBAPEAGXZ 004b ?setg@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEAAXPEAG00@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 4C 24 30 48 83 C1 70 48 3B C1 75 2E 48 8B 44 24 30 4C 8B 88 90 00 00 00 48 8B 44 24 30 4C 8B 80 88 00 00 00 48 8B 44 24 30 48 8B 90 88 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_116_291_3 {
	meta:
		name = "?_Reset_back@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@AEAAXXZ"
		size = 84
		refs = "000f ?eback@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEBAPEA_WXZ 004b ?setg@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEAAXPEA_W00@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 4C 24 30 48 83 C1 70 48 3B C1 75 2E 48 8B 44 24 30 4C 8B 88 90 00 00 00 48 8B 44 24 30 4C 8B 80 88 00 00 00 48 8B 44 24 30 48 8B 90 88 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_232_1 {
	meta:
		name = "?_Set_back@?$basic_filebuf@DU?$char_traits@D@std@@@std@@AEAAXXZ"
		size = 125
		refs = "000f ?eback@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEBAPEADXZ 003d ?egptr@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEBAPEADXZ 0074 ?setg@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAXPEAD00@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 4C 24 30 48 83 C1 70 48 3B C1 74 2C 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 4C 24 30 48 89 81 88 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 4C 24 30 48 89 81 90 00 00 00 48 8B 44 24 30 48 83 C0 71 48 8B 4C 24 30 48 83 C1 70 48 8B 54 24 30 48 83 C2 70 4C 8B C8 4C 8B C1 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_233_1 {
	meta:
		name = "?_Tidy@?$_Yarn@D@std@@AEAAXXZ"
		size = 55
		refs = "0022 _free_dbg"
		altNames = "?_Tidy@?$_Yarn@_W@std@@AEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 83 38 00 74 12 BA 02 00 00 00 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 C7 00 00 00 00 00 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_235_1 {
	meta:
		name = "?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_N_K@Z"
		size = 262
		refs = "0026 ?_Myres@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAAAEA_KXZ 003a ?_Bx@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAAAEAT_Bxty@?$_String_val@U?$_Simple_types@D@std@@@2@XZ 0054 ??$addressof@PEAD@std@@YAPEAPEADAEAPEAD@Z 0063 ?_Getal@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAAAEAU?$_Wrap_alloc@V?$allocator@D@std@@@2@XZ 0073 ??$destroy@PEAD@?$_Wrap_alloc@V?$allocator@D@std@@@std@@QEAAXPEAPEAD@Z 0085 ??$_Unfancy@D@std@@YAPEADPEAD@Z 00a9 ?copy@?$char_traits@D@std@@SAPEADPEADPEBD_K@Z 00dd ?deallocate@?$_Wrap_alloc@V?$allocator@D@std@@@std@@QEAAXPEAD_K@Z 00fd ?_Eos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_K@Z"
	strings:
		$1 = { 4C 89 44 24 18 88 54 24 10 48 89 4C 24 08 48 83 EC 48 0F B6 44 24 58 85 C0 75 05 E9 C1 00 00 00 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 83 38 10 0F 82 AD 00 00 00 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 8B 00 48 89 44 24 20 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 89 44 24 28 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 8B 4C 24 28 48 8B D1 48 8B C8 E8 ?? ?? ?? ?? 48 83 7C 24 60 00 76 2E 48 8B 4C 24 20 E8 ?? ?? ?? ?? 48 89 44 24 30 48 8B 4C 24 50 E8 ?? ?? ?? ?? 4C 8B 44 24 60 48 8B 4C 24 30 48 8B D1 48 8B C8 E8 ?? ?? ?? ?? 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 8B 00 48 FF C0 48 89 44 24 38 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 8B 4C 24 38 4C 8B C1 48 8B 54 24 20 48 8B C8 E8 ?? ?? ?? ?? 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 C7 00 0F 00 00 00 48 8B 54 24 60 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_1_236_1 {
	meta:
		name = "?_Tidy@?$ctype@D@std@@IEAAXXZ"
		size = 90
		refs = "001e free 0043 ??_V@YAXPEAX@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 83 78 20 00 7E 10 48 8B 44 24 40 48 8B 48 18 E8 ?? ?? ?? ?? EB 23 48 8B 44 24 40 83 78 20 00 7D 18 48 8B 44 24 40 48 8B 40 18 48 89 44 24 20 48 8B 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 40 48 8B 48 28 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1_239_1 {
	meta:
		name = "?_Xlen@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBAXXZ"
		size = 26
		refs = "000c ??_C@_0BA@JFNIOLAK@string?5too?5long?$AA@ 0011 ?_Xlength_error@std@@YAXPEBD@Z"
		altNames = "?_Xlen@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEBAXXZ ?_Xlen@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEBAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_96_276_2 {
	meta:
		name = "?_Xran@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBAXXZ"
		size = 26
		refs = "000c ??_C@_0BI@CFPLBAOH@invalid?5string?5position?$AA@ 0011 ?_Xout_of_range@std@@YAXPEBD@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_10_1017_2 {
	meta:
		name = "?_Xran@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEBAXXZ"
		size = 26
		refs = "000c ??_C@_0BI@CFPLBAOH@invalid?5string?5position?$AA@ 0011 ?_Xout_of_range@std@@YAXPEBD@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_10_1018_2 {
	meta:
		name = "?_Xran@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEBAXXZ"
		size = 26
		refs = "000c ??_C@_0BI@CFPLBAOH@invalid?5string?5position?$AA@ 0011 ?_Xout_of_range@std@@YAXPEBD@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_243_1 {
	meta:
		name = "?address@?$_Wrap_alloc@V?$allocator@D@std@@@std@@QEBAPEADAEAD@Z"
		size = 29
		refs = "0014 ?pointer_to@?$pointer_traits@PEAD@std@@SAPEADAEAD@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_26_0_4 {
	meta:
		name = "??$?RD@__crt_public_free_policy@@QEBAXQEBD@Z"
		size = 29
		refs = "0014 free"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_119_895_1 {
	meta:
		name = "?address@?$_Wrap_alloc@V?$allocator@G@std@@@std@@QEBAPEAGAEAG@Z"
		size = 29
		refs = "0014 ?pointer_to@?$pointer_traits@PEAG@std@@SAPEAGAEAG@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_2_289_3 {
	meta:
		name = "?address@?$_Wrap_alloc@V?$allocator@U_Container_proxy@std@@@std@@@std@@QEBAPEAU_Container_proxy@2@AEAU32@@Z"
		size = 29
		refs = "0014 ?pointer_to@?$pointer_traits@PEAU_Container_proxy@std@@@std@@SAPEAU_Container_proxy@2@AEAU32@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_61_111_2 {
	meta:
		name = "?address@?$_Wrap_alloc@V?$allocator@_W@std@@@std@@QEBAPEA_WAEA_W@Z"
		size = 29
		refs = "0014 ?pointer_to@?$pointer_traits@PEA_W@std@@SAPEA_WAEA_W@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_245_1 {
	meta:
		name = "?allocate@?$allocator@D@std@@QEAAPEAD_K@Z"
		size = 37
		refs = "001c ?_Allocate@std@@YAPEAX_K0_N@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 41 B0 01 BA 01 00 00 00 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_246_1 {
	meta:
		name = "?always_noconv@codecvt_base@std@@QEBA_NXZ"
		size = 50
		refs = "0020 _guard_check_icall"
		altNames = "?date_order@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEBA?AW4dateorder@time_base@2@XZ ?date_order@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEBA?AW4dateorder@time_base@2@XZ ?date_order@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEBA?AW4dateorder@time_base@2@XZ ?decimal_point@?$_Mpunct@D@std@@QEBADXZ ?decimal_point@?$_Mpunct@G@std@@QEBAGXZ ?decimal_point@?$_Mpunct@_W@std@@QEBA_WXZ ?decimal_point@?$numpunct@D@std@@QEBADXZ ?decimal_point@?$numpunct@G@std@@QEBAGXZ ?decimal_point@?$numpunct@_W@std@@QEBA_WXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 48 8B 00 48 8B 40 18 48 89 44 24 20 48 8B 4C 24 20 E8 ?? ?? ?? ?? 48 8B 4C 24 40 FF 54 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1_247_1 {
	meta:
		name = "?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@AEBV12@@Z"
		size = 44
		refs = "0011 ?npos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@2_KB 0023 ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@AEBV12@_K1@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 4C 8B 0D ?? ?? ?? ?? 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_119_904_1 {
	meta:
		name = "?append@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEAAAEAV12@AEBV12@@Z"
		size = 44
		refs = "0011 ?npos@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@2_KB 0023 ?append@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEAAAEAV12@AEBV12@_K1@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 4C 8B 0D ?? ?? ?? ?? 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_119_907_1 {
	meta:
		name = "?append@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAAAEAV12@AEBV12@@Z"
		size = 44
		refs = "0011 ?npos@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@2_KB 0023 ?append@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAAAEAV12@AEBV12@_K1@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 4C 8B 0D ?? ?? ?? ?? 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_62_263_1 {
	meta:
		name = "?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@AEBV12@@Z"
		size = 44
		refs = "0011 ?npos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@2_KB 0023 ?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@AEBV12@_K1@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 4C 8B 0D ?? ?? ?? ?? 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_119_915_1 {
	meta:
		name = "?assign@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEAAAEAV12@AEBV12@@Z"
		size = 44
		refs = "0011 ?npos@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@2_KB 0023 ?assign@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEAAAEAV12@AEBV12@_K1@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 4C 8B 0D ?? ?? ?? ?? 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_119_921_1 {
	meta:
		name = "?assign@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAAAEAV12@AEBV12@@Z"
		size = 44
		refs = "0011 ?npos@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@2_KB 0023 ?assign@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAAAEAV12@AEBV12@_K1@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 4C 8B 0D ?? ?? ?? ?? 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_248_1 {
	meta:
		name = "?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@AEBV12@_K1@Z"
		size = 265
		refs = "0023 ?_Check_offset@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBAX_K@Z 0037 ?_Clamp_suffix_size@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBA_K_K0@Z 0046 ?_Mysize@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAAAEA_KXZ 0050 ?npos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@2_KB 0067 ?_Xlen@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBAXXZ 0098 ?_Grow@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA_N_K_N@Z 00a9 ?_Myptr@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEBAPEBDXZ 00bd ?_Myptr@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAAPEADXZ 00ec ?copy@?$char_traits@D@std@@SAPEADPEADPEBD_K@Z 00fb ?_Eos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_K@Z"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 48 8B 54 24 60 48 8B 4C 24 58 E8 ?? ?? ?? ?? 4C 8B 44 24 68 48 8B 54 24 60 48 8B 4C 24 58 E8 ?? ?? ?? ?? 48 89 44 24 68 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 8B 00 48 8B 0D ?? ?? ?? ?? 48 2B C8 48 8B C1 48 3B 44 24 68 77 0A 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 8B 00 48 03 44 24 68 48 89 44 24 20 48 83 7C 24 68 00 76 75 45 33 C0 48 8B 54 24 20 48 8B 4C 24 50 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 5C 48 8B 4C 24 58 E8 ?? ?? ?? ?? 48 03 44 24 60 48 89 44 24 30 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 89 44 24 28 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 8B 4C 24 28 48 03 08 48 8B C1 4C 8B 44 24 68 48 8B 4C 24 30 48 8B D1 48 8B C8 E8 ?? ?? ?? ?? 48 8B 54 24 20 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_1_249_1 {
	meta:
		name = "?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@PEBD@Z"
		size = 47
		refs = "0014 ?length@?$char_traits@D@std@@SA_KPEBD@Z 0026 ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@PEBD_K@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 38 E8 ?? ?? ?? ?? 4C 8B C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_41_77_1 {
	meta:
		name = "?append@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAAAEAV12@PEB_W@Z"
		size = 47
		refs = "0014 ?length@?$char_traits@_W@std@@SA_KPEB_W@Z 0026 ?append@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAAAEAV12@PEB_W_K@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 38 E8 ?? ?? ?? ?? 4C 8B C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_88_292_2 {
	meta:
		name = "?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@PEBD@Z"
		size = 47
		refs = "0014 ?length@?$char_traits@D@std@@SA_KPEBD@Z 0026 ?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@PEBD_K@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 38 E8 ?? ?? ?? ?? 4C 8B C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_10_1046_2 {
	meta:
		name = "?assign@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEAAAEAV12@PEBG@Z"
		size = 47
		refs = "0014 ?length@?$char_traits@G@std@@SA_KPEBG@Z 0026 ?assign@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEAAAEAV12@PEBG_K@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 38 E8 ?? ?? ?? ?? 4C 8B C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_119_923_1 {
	meta:
		name = "?assign@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAAAEAV12@PEB_W@Z"
		size = 47
		refs = "0014 ?length@?$char_traits@_W@std@@SA_KPEB_W@Z 0026 ?assign@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAAAEAV12@PEB_W_K@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 38 E8 ?? ?? ?? ?? 4C 8B C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_250_1 {
	meta:
		name = "?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@PEBD_K@Z"
		size = 268
		refs = "001e ?_Inside@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA_NPEBD@Z 002f ?_Myptr@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAAPEADXZ 0051 ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@AEBV12@_K1@Z 0060 ?_Mysize@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAAAEA_KXZ 006a ?npos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@2_KB 0081 ?_Xlen@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBAXXZ 00b2 ?_Grow@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA_N_K_N@Z 00ef ?copy@?$char_traits@D@std@@SAPEADPEADPEBD_K@Z 00fe ?_Eos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_K@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 31 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 4C 24 48 48 2B C8 48 8B C1 4C 8B 4C 24 50 4C 8B C0 48 8B 54 24 40 48 8B 4C 24 40 E8 ?? ?? ?? ?? E9 AD 00 00 00 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 00 48 8B 0D ?? ?? ?? ?? 48 2B C8 48 8B C1 48 3B 44 24 50 77 0A 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 00 48 03 44 24 50 48 89 44 24 20 48 83 7C 24 50 00 76 5E 45 33 C0 48 8B 54 24 20 48 8B 4C 24 40 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 45 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 89 44 24 28 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 4C 24 28 48 03 08 48 8B C1 4C 8B 44 24 50 48 8B 54 24 48 48 8B C8 E8 ?? ?? ?? ?? 48 8B 54 24 20 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1_251_1 {
	meta:
		name = "?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@_KD@Z"
		size = 177
		refs = "0019 ?_Mysize@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAAAEA_KXZ 0023 ?npos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@2_KB 003a ?_Xlen@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBAXXZ 006b ?_Grow@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA_N_K_N@Z 0094 ?_Chassign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_K0D@Z 00a3 ?_Eos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_K@Z"
	strings:
		$1 = { 44 88 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 00 48 8B 0D ?? ?? ?? ?? 48 2B C8 48 8B C1 48 3B 44 24 48 77 0A 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 00 48 03 44 24 48 48 89 44 24 20 48 83 7C 24 48 00 76 4A 45 33 C0 48 8B 54 24 20 48 8B 4C 24 40 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 31 48 8B 4C 24 40 E8 ?? ?? ?? ?? 44 0F B6 4C 24 50 4C 8B 44 24 48 48 8B 10 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 54 24 20 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1_252_1 {
	meta:
		name = "?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@AEBV12@_K1@Z"
		size = 225
		refs = "0023 ?_Check_offset@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBAX_K@Z 0037 ?_Clamp_suffix_size@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBA_K_K0@Z 0065 ?erase@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@_K@Z 0076 ?erase@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@_K0@Z 008a ?_Grow@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA_N_K_N@Z 009b ?_Myptr@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEBAPEBDXZ 00af ?_Myptr@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAAPEADXZ 00c4 ?copy@?$char_traits@D@std@@SAPEADPEADPEBD_K@Z 00d3 ?_Eos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_K@Z"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 54 24 50 48 8B 4C 24 48 E8 ?? ?? ?? ?? 4C 8B 44 24 58 48 8B 54 24 50 48 8B 4C 24 48 E8 ?? ?? ?? ?? 48 89 44 24 58 48 8B 44 24 48 48 39 44 24 40 75 30 48 8B 44 24 58 48 8B 4C 24 50 48 03 C8 48 8B C1 48 8B D0 48 8B 4C 24 40 E8 ?? ?? ?? ?? 4C 8B 44 24 50 33 D2 48 8B 4C 24 40 E8 ?? ?? ?? ?? EB 5B 45 33 C0 48 8B 54 24 58 48 8B 4C 24 40 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 42 48 8B 4C 24 48 E8 ?? ?? ?? ?? 48 03 44 24 50 48 89 44 24 20 48 8B 4C 24 40 E8 ?? ?? ?? ?? 4C 8B 44 24 58 48 8B 4C 24 20 48 8B D1 48 8B C8 E8 ?? ?? ?? ?? 48 8B 54 24 58 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1_254_1 {
	meta:
		name = "?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@PEBD_K@Z"
		size = 165
		refs = "001e ?_Inside@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA_NPEBD@Z 002f ?_Myptr@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAAPEADXZ 0051 ?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@AEBV12@_K1@Z 0065 ?_Grow@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA_N_K_N@Z 0088 ?copy@?$char_traits@D@std@@SAPEADPEADPEBD_K@Z 0097 ?_Eos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_K@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 2E 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 4C 24 38 48 2B C8 48 8B C1 4C 8B 4C 24 40 4C 8B C0 48 8B 54 24 30 48 8B 4C 24 30 E8 ?? ?? ?? ?? EB 49 45 33 C0 48 8B 54 24 40 48 8B 4C 24 30 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 2B 48 8B 4C 24 30 E8 ?? ?? ?? ?? 4C 8B 44 24 40 48 8B 54 24 38 48 8B C8 E8 ?? ?? ?? ?? 48 8B 54 24 40 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_255_1 {
	meta:
		name = "?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@_KD@Z"
		size = 116
		refs = "0016 ?npos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@2_KB 0027 ?_Xlen@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBAXXZ 0039 ?_Grow@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA_N_K_N@Z 0057 ?_Chassign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_K0D@Z 0066 ?_Eos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_K@Z"
	strings:
		$1 = { 44 88 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 05 ?? ?? ?? ?? 48 39 44 24 38 75 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 26 44 0F B6 4C 24 40 4C 8B 44 24 38 33 D2 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_256_1 {
	meta:
		name = "?assign@?$char_traits@D@std@@SAPEADPEAD_KD@Z"
		size = 46
		refs = "0025 memset"
	strings:
		$1 = { 44 88 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 0F BE 44 24 40 4C 8B 44 24 38 8B D0 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_257_1 {
	meta:
		name = "?assign@?$char_traits@D@std@@SAXAEADAEBD@Z"
		size = 26
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 8B 44 24 08 48 8B 4C 24 10 0F B6 09 88 08 C3 }
	condition:
		$1
}

rule file_1_258_1 {
	meta:
		name = "?begin@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@2@XZ"
		size = 112
		refs = "001d ?_Get_data@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAAAEAV?$_String_val@U?$_Simple_types@D@std@@@2@XZ 002d ?_Myptr@?$_String_val@U?$_Simple_types@D@std@@@std@@QEAAPEADXZ 003d ?_Getal@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAAAEAU?$_Wrap_alloc@V?$allocator@D@std@@@2@XZ 004e ?address@?$_Wrap_alloc@V?$allocator@D@std@@@std@@QEBAPEADAEAD@Z 0061 ??0?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEAA@PEADPEBU_Container_base0@1@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 48 C7 44 24 30 FE FF FF FF 48 8B 4C 24 50 E8 ?? ?? ?? ?? 90 48 89 44 24 20 48 8B 4C 24 20 E8 ?? ?? ?? ?? 90 48 89 44 24 28 48 8B 4C 24 50 E8 ?? ?? ?? ?? 90 48 8B 4C 24 28 48 8B D1 48 8B C8 E8 ?? ?? ?? ?? 90 4C 8B 44 24 20 48 8B D0 48 8B 4C 24 58 E8 ?? ?? ?? ?? 90 48 8B 44 24 58 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_105_297_2 {
	meta:
		name = "?begin@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@2@XZ"
		size = 112
		refs = "001d ?_Get_data@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAAAEAV?$_String_val@U?$_Simple_types@D@std@@@2@XZ 002d ?_Myptr@?$_String_val@U?$_Simple_types@D@std@@@std@@QEAAPEADXZ 003d ?_Getal@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAAAEAU?$_Wrap_alloc@V?$allocator@D@std@@@2@XZ 004e ?address@?$_Wrap_alloc@V?$allocator@D@std@@@std@@QEBAPEADAEAD@Z 0061 ??0?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEAA@PEADPEBU_Container_base12@1@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 48 C7 44 24 30 FE FF FF FF 48 8B 4C 24 50 E8 ?? ?? ?? ?? 90 48 89 44 24 20 48 8B 4C 24 20 E8 ?? ?? ?? ?? 90 48 89 44 24 28 48 8B 4C 24 50 E8 ?? ?? ?? ?? 90 48 8B 4C 24 28 48 8B D1 48 8B C8 E8 ?? ?? ?? ?? 90 4C 8B 44 24 20 48 8B D0 48 8B 4C 24 58 E8 ?? ?? ?? ?? 90 48 8B 44 24 58 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_119_932_1 {
	meta:
		name = "?begin@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEAA?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@2@XZ"
		size = 112
		refs = "001d ?_Get_data@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QEAAAEAV?$_String_val@U?$_Simple_types@G@std@@@2@XZ 002d ?_Myptr@?$_String_val@U?$_Simple_types@G@std@@@std@@QEAAPEAGXZ 003d ?_Getal@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QEAAAEAU?$_Wrap_alloc@V?$allocator@G@std@@@2@XZ 004e ?address@?$_Wrap_alloc@V?$allocator@G@std@@@std@@QEBAPEAGAEAG@Z 0061 ??0?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QEAA@PEAGPEBU_Container_base0@1@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 48 C7 44 24 30 FE FF FF FF 48 8B 4C 24 50 E8 ?? ?? ?? ?? 90 48 89 44 24 20 48 8B 4C 24 20 E8 ?? ?? ?? ?? 90 48 89 44 24 28 48 8B 4C 24 50 E8 ?? ?? ?? ?? 90 48 8B 4C 24 28 48 8B D1 48 8B C8 E8 ?? ?? ?? ?? 90 4C 8B 44 24 20 48 8B D0 48 8B 4C 24 58 E8 ?? ?? ?? ?? 90 48 8B 44 24 58 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_10_1061_2 {
	meta:
		name = "?begin@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEAA?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@2@XZ"
		size = 112
		refs = "001d ?_Get_data@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QEAAAEAV?$_String_val@U?$_Simple_types@G@std@@@2@XZ 002d ?_Myptr@?$_String_val@U?$_Simple_types@G@std@@@std@@QEAAPEAGXZ 003d ?_Getal@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QEAAAEAU?$_Wrap_alloc@V?$allocator@G@std@@@2@XZ 004e ?address@?$_Wrap_alloc@V?$allocator@G@std@@@std@@QEBAPEAGAEAG@Z 0061 ??0?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QEAA@PEAGPEBU_Container_base12@1@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 48 C7 44 24 30 FE FF FF FF 48 8B 4C 24 50 E8 ?? ?? ?? ?? 90 48 89 44 24 20 48 8B 4C 24 20 E8 ?? ?? ?? ?? 90 48 89 44 24 28 48 8B 4C 24 50 E8 ?? ?? ?? ?? 90 48 8B 4C 24 28 48 8B D1 48 8B C8 E8 ?? ?? ?? ?? 90 4C 8B 44 24 20 48 8B D0 48 8B 4C 24 58 E8 ?? ?? ?? ?? 90 48 8B 44 24 58 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_103_1112_3 {
	meta:
		name = "?begin@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAA?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@2@XZ"
		size = 112
		refs = "001d ?_Get_data@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QEAAAEAV?$_String_val@U?$_Simple_types@_W@std@@@2@XZ 002d ?_Myptr@?$_String_val@U?$_Simple_types@_W@std@@@std@@QEAAPEA_WXZ 003d ?_Getal@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QEAAAEAU?$_Wrap_alloc@V?$allocator@_W@std@@@2@XZ 004e ?address@?$_Wrap_alloc@V?$allocator@_W@std@@@std@@QEBAPEA_WAEA_W@Z 0061 ??0?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QEAA@PEA_WPEBU_Container_base12@1@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 48 C7 44 24 30 FE FF FF FF 48 8B 4C 24 50 E8 ?? ?? ?? ?? 90 48 89 44 24 20 48 8B 4C 24 20 E8 ?? ?? ?? ?? 90 48 89 44 24 28 48 8B 4C 24 50 E8 ?? ?? ?? ?? 90 48 8B 4C 24 28 48 8B D1 48 8B C8 E8 ?? ?? ?? ?? 90 4C 8B 44 24 20 48 8B D0 48 8B 4C 24 58 E8 ?? ?? ?? ?? 90 48 8B 44 24 58 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_119_933_1 {
	meta:
		name = "?begin@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAA?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@2@XZ"
		size = 112
		refs = "001d ?_Get_data@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QEAAAEAV?$_String_val@U?$_Simple_types@_W@std@@@2@XZ 002d ?_Myptr@?$_String_val@U?$_Simple_types@_W@std@@@std@@QEAAPEA_WXZ 003d ?_Getal@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QEAAAEAU?$_Wrap_alloc@V?$allocator@_W@std@@@2@XZ 004e ?address@?$_Wrap_alloc@V?$allocator@_W@std@@@std@@QEBAPEA_WAEA_W@Z 0061 ??0?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QEAA@PEA_WPEBU_Container_base0@1@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 48 C7 44 24 30 FE FF FF FF 48 8B 4C 24 50 E8 ?? ?? ?? ?? 90 48 89 44 24 20 48 8B 4C 24 20 E8 ?? ?? ?? ?? 90 48 89 44 24 28 48 8B 4C 24 50 E8 ?? ?? ?? ?? 90 48 8B 4C 24 28 48 8B D1 48 8B C8 E8 ?? ?? ?? ?? 90 4C 8B 44 24 20 48 8B D0 48 8B 4C 24 58 E8 ?? ?? ?? ?? 90 48 8B 44 24 58 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_1_259_1 {
	meta:
		name = "?c_str@?$_Yarn@D@std@@QEBAPEBDXZ"
		size = 56
		altNames = "?_C_str@?$_Yarn@D@std@@QEBAPEBDXZ ?_C_str@?$_Yarn@_W@std@@QEBAPEB_WXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 18 48 8B 44 24 20 48 83 38 00 74 0E 48 8B 44 24 20 48 8B 00 48 89 04 24 EB 0D 48 8B 44 24 20 48 83 C0 08 48 89 04 24 48 8B 04 24 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_1_261_1 {
	meta:
		name = "?c_str@locale@std@@QEBAPEBDXZ"
		size = 71
		refs = "0018 ??_C@_00CNPNBAHC@?$AA@ 0034 ?c_str@?$_Yarn@D@std@@QEBAPEBDXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 48 83 78 08 00 75 0E 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 EB 1A 48 8B 44 24 40 48 8B 40 08 48 83 C0 28 48 8B C8 E8 ?? ?? ?? ?? 48 89 44 24 20 48 8B 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1_264_1 {
	meta:
		name = "?clear@?$basic_ios@DU?$char_traits@D@std@@@std@@QEAAXH_N@Z"
		size = 76
		refs = "0043 ?clear@ios_base@std@@QEAAXH_N@Z"
		altNames = "?clear@?$basic_ios@GU?$char_traits@G@std@@@std@@QEAAXH_N@Z ?clear@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QEAAXH_N@Z"
	strings:
		$1 = { 44 88 44 24 18 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 48 83 78 48 00 75 0D 8B 44 24 48 83 C8 04 89 44 24 20 EB 08 8B 44 24 48 89 44 24 20 44 0F B6 44 24 50 8B 54 24 20 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1_265_1 {
	meta:
		name = "?clear@ios_base@std@@QEAAXH@Z"
		size = 35
		refs = "001a ?clear@ios_base@std@@QEAAXH_N@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_266_1 {
	meta:
		name = "?clear@ios_base@std@@QEAAXH_N@Z"
		size = 340
		refs = "005c _CxxThrowException 008f ?make_error_code@std@@YA?AVerror_code@1@W4io_errc@1@@Z 0099 ??_C@_0BF@PHHKMMFD@ios_base?3?3badbit?5set?$AA@ 00a3 ??0failure@ios_base@std@@QEAA@PEBDAEBVerror_code@2@@Z 00aa _TI5?AVfailure@ios_base@std@@ 00f1 ??_C@_0BG@FMKFHCIL@ios_base?3?3failbit?5set?$AA@ 0127 ??_C@_0BF@OOHOMBOF@ios_base?3?3eofbit?5set?$AA@"
	strings:
		$1 = { 44 88 44 24 18 89 54 24 10 48 89 4C 24 08 48 81 EC D8 00 00 00 8B 84 24 E8 00 00 00 83 E0 17 48 8B 8C 24 E0 00 00 00 89 41 10 48 8B 84 24 E0 00 00 00 48 8B 8C 24 E0 00 00 00 8B 49 14 8B 40 10 23 C1 85 C0 75 05 E9 01 01 00 00 0F B6 84 24 F0 00 00 00 85 C0 74 0E 33 D2 33 C9 E8 ?? ?? ?? ?? E9 E7 00 00 00 48 8B 84 24 E0 00 00 00 48 8B 8C 24 E0 00 00 00 8B 49 14 8B 40 10 23 C1 83 E0 04 85 C0 74 39 BA 01 00 00 00 48 8D 4C 24 20 E8 ?? ?? ?? ?? 4C 8B C0 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 50 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 50 E8 ?? ?? ?? ?? E9 8F 00 00 00 48 8B 84 24 E0 00 00 00 48 8B 8C 24 E0 00 00 00 8B 49 14 8B 40 10 23 C1 83 E0 02 85 C0 74 36 BA 01 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 4C 8B C0 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 78 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 78 E8 ?? ?? ?? ?? EB 3A BA 01 00 00 00 48 8D 4C 24 40 E8 ?? ?? ?? ?? 4C 8B C0 48 8D 15 ?? ?? ?? ?? 48 8D 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 D8 00 00 00 C3 }
	condition:
		$1
}

rule file_1_267_1 {
	meta:
		name = "?close@?$basic_filebuf@DU?$char_traits@D@std@@@std@@QEAAPEAV12@XZ"
		size = 129
		refs = "0033 ?_Endwrite@?$basic_filebuf@DU?$char_traits@D@std@@@std@@IEAA_NXZ 0054 fclose 0073 ?_Init@?$basic_filebuf@DU?$char_traits@D@std@@@std@@IEAAXPEAU_iobuf@@W4_Initfl@12@@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 48 89 44 24 20 48 8B 44 24 40 48 83 B8 80 00 00 00 00 75 0B 48 C7 44 24 20 00 00 00 00 EB 38 48 8B 4C 24 40 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 09 48 C7 44 24 20 00 00 00 00 48 8B 44 24 40 48 8B 88 80 00 00 00 E8 ?? ?? ?? ?? 85 C0 74 09 48 C7 44 24 20 00 00 00 00 41 B8 02 00 00 00 33 D2 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_40_306_2 {
	meta:
		name = "?close@?$basic_filebuf@GU?$char_traits@G@std@@@std@@QEAAPEAV12@XZ"
		size = 129
		refs = "0033 ?_Endwrite@?$basic_filebuf@GU?$char_traits@G@std@@@std@@IEAA_NXZ 0054 fclose 0073 ?_Init@?$basic_filebuf@GU?$char_traits@G@std@@@std@@IEAAXPEAU_iobuf@@W4_Initfl@12@@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 48 89 44 24 20 48 8B 44 24 40 48 83 B8 80 00 00 00 00 75 0B 48 C7 44 24 20 00 00 00 00 EB 38 48 8B 4C 24 40 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 09 48 C7 44 24 20 00 00 00 00 48 8B 44 24 40 48 8B 88 80 00 00 00 E8 ?? ?? ?? ?? 85 C0 74 09 48 C7 44 24 20 00 00 00 00 41 B8 02 00 00 00 33 D2 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_116_329_3 {
	meta:
		name = "?close@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@QEAAPEAV12@XZ"
		size = 129
		refs = "0033 ?_Endwrite@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@IEAA_NXZ 0054 fclose 0073 ?_Init@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@IEAAXPEAU_iobuf@@W4_Initfl@12@@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 48 89 44 24 20 48 8B 44 24 40 48 83 B8 80 00 00 00 00 75 0B 48 C7 44 24 20 00 00 00 00 EB 38 48 8B 4C 24 40 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 09 48 C7 44 24 20 00 00 00 00 48 8B 44 24 40 48 8B 88 80 00 00 00 E8 ?? ?? ?? ?? 85 C0 74 09 48 C7 44 24 20 00 00 00 00 41 B8 02 00 00 00 33 D2 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1_268_1 {
	meta:
		name = "?copy@?$char_traits@D@std@@SAPEADPEADPEBD_K@Z"
		size = 74
		refs = "0037 memcpy"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 83 7C 24 50 00 75 0C 48 8B 44 24 40 48 89 44 24 20 EB 19 4C 8B 44 24 50 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 89 44 24 20 48 8B 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_103_1119_3 {
	meta:
		name = "?copy@?$char_traits@G@std@@SAPEAGPEAGPEBG_K@Z"
		size = 74
		refs = "0037 wmemcpy"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 83 7C 24 50 00 75 0C 48 8B 44 24 40 48 89 44 24 20 EB 19 4C 8B 44 24 50 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 89 44 24 20 48 8B 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_10_1070_2 {
	meta:
		name = "?copy@?$char_traits@_W@std@@SAPEA_WPEA_WPEB_W_K@Z"
		size = 74
		refs = "0037 wmemcpy"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 83 7C 24 50 00 75 0C 48 8B 44 24 40 48 89 44 24 20 EB 19 4C 8B 44 24 50 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 89 44 24 20 48 8B 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_116_387_3 {
	meta:
		name = "?move@?$char_traits@D@std@@SAPEADPEADPEBD_K@Z"
		size = 74
		refs = "0037 memmove"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 83 7C 24 50 00 75 0C 48 8B 44 24 40 48 89 44 24 20 EB 19 4C 8B 44 24 50 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 89 44 24 20 48 8B 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_119_1212_1 {
	meta:
		name = "?move@?$char_traits@G@std@@SAPEAGPEAGPEBG_K@Z"
		size = 74
		refs = "0037 wmemmove"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 83 7C 24 50 00 75 0C 48 8B 44 24 40 48 89 44 24 20 EB 19 4C 8B 44 24 50 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 89 44 24 20 48 8B 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_61_141_2 {
	meta:
		name = "?move@?$char_traits@_W@std@@SAPEA_WPEA_WPEB_W_K@Z"
		size = 74
		refs = "0037 wmemmove"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 83 7C 24 50 00 75 0C 48 8B 44 24 40 48 89 44 24 20 EB 19 4C 8B 44 24 50 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 89 44 24 20 48 8B 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1_269_1 {
	meta:
		name = "?deallocate@?$_Wrap_alloc@V?$allocator@D@std@@@std@@QEAAXPEAD_K@Z"
		size = 44
		refs = "0023 ?deallocate@?$allocator@D@std@@QEAAXPEAD_K@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_10_563_2 {
	meta:
		name = "?_Addfac@_Locimp@locale@std@@AEAAXPEAVfacet@23@_K@Z"
		size = 44
		refs = "0023 ?_Locimp_Addfac@_Locimp@locale@std@@CAXPEAV123@PEAVfacet@23@_K@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_108_129_1 {
	meta:
		name = "?deallocate@?$_Wrap_alloc@U?$_StaticAllocator@V?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@@@@std@@QEAAXPEAV?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@2@_K@Z"
		size = 44
		refs = "0023 ?deallocate@?$_StaticAllocator@V?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@@@QEBAXPEAV?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@_K@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_119_947_1 {
	meta:
		name = "?deallocate@?$_Wrap_alloc@V?$allocator@G@std@@@std@@QEAAXPEAG_K@Z"
		size = 44
		refs = "0023 ?deallocate@?$allocator@G@std@@QEAAXPEAG_K@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_24_333_3 {
	meta:
		name = "?deallocate@?$_Wrap_alloc@V?$allocator@U_Container_proxy@std@@@std@@@std@@QEAAXPEAU_Container_proxy@2@_K@Z"
		size = 44
		refs = "0023 ?deallocate@?$allocator@U_Container_proxy@std@@@std@@QEAAXPEAU_Container_proxy@2@_K@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_103_1128_3 {
	meta:
		name = "?deallocate@?$_Wrap_alloc@V?$allocator@_W@std@@@std@@QEAAXPEA_W_K@Z"
		size = 44
		refs = "0023 ?deallocate@?$allocator@_W@std@@QEAAXPEA_W_K@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_27_45_3 {
	meta:
		name = "_Cnd_timedwait"
		size = 44
		refs = "0023 ?do_wait@@YAHPEAU_Cnd_internal_imp_t@@PEAU_Mtx_internal_imp_t@@PEBUxtime@@@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_270_1 {
	meta:
		name = "?deallocate@?$allocator@D@std@@QEAAXPEAD_K@Z"
		size = 45
		refs = "0024 ?_Deallocate@std@@YAXPEAX_K1@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 41 B8 01 00 00 00 48 8B 54 24 40 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_271_1 {
	meta:
		name = "?default_error_condition@error_category@std@@UEBA?AVerror_condition@2@H@Z"
		size = 48
		refs = "0022 ??0error_condition@std@@QEAA@HAEBVerror_category@1@@Z"
	strings:
		$1 = { 44 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 4C 8B 44 24 30 8B 54 24 40 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B 44 24 38 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_275_1 {
	meta:
		name = "?do_in@?$codecvt@DDU_Mbstatet@@@std@@MEBAHAEAU_Mbstatet@@PEBD1AEAPEBDPEAD3AEAPEAD@Z"
		size = 158
		altNames = "?do_out@?$codecvt@DDU_Mbstatet@@@std@@MEBAHAEAU_Mbstatet@@PEBD1AEAPEBDPEAD3AEAPEAD@Z"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 8B 44 24 28 48 8B 4C 24 18 48 89 08 48 8B 44 24 40 48 8B 4C 24 30 48 89 08 33 C0 83 F8 01 74 09 B8 03 00 00 00 EB 61 EB 5F EB 26 48 8B 44 24 28 48 8B 00 48 FF C0 48 8B 4C 24 28 48 89 01 48 8B 44 24 40 48 8B 00 48 FF C0 48 8B 4C 24 40 48 89 01 48 8B 44 24 28 48 8B 4C 24 20 48 39 08 74 26 48 8B 44 24 40 48 8B 4C 24 38 48 39 08 74 17 48 8B 44 24 28 48 8B 00 48 8B 4C 24 40 48 8B 09 0F B6 00 88 01 EB A5 33 C0 C3 }
	condition:
		$1
}

rule file_1_276_1 {
	meta:
		name = "?do_length@?$codecvt@DDU_Mbstatet@@@std@@MEBAHAEAU_Mbstatet@@PEBD1_K@Z"
		size = 86
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 18 48 8B 44 24 30 48 8B 4C 24 38 48 2B C8 48 8B C1 48 39 44 24 40 73 0B 48 8B 44 24 40 48 89 04 24 EB 14 48 8B 44 24 30 48 8B 4C 24 38 48 2B C8 48 8B C1 48 89 04 24 8B 04 24 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_1_278_1 {
	meta:
		name = "?do_narrow@?$ctype@D@std@@MEBADDD@Z"
		size = 20
	strings:
		$1 = { 44 88 44 24 18 88 54 24 10 48 89 4C 24 08 0F B6 44 24 10 C3 }
	condition:
		$1
}

rule file_1_279_1 {
	meta:
		name = "?do_narrow@?$ctype@D@std@@MEBAPEBDPEBD0DPEAD@Z"
		size = 68
		refs = "0036 memcpy"
	strings:
		$1 = { 44 88 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 38 48 8B 4C 24 40 48 2B C8 48 8B C1 4C 8B C0 48 8B 54 24 38 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 8B 44 24 40 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_281_1 {
	meta:
		name = "?do_tolower@?$ctype@D@std@@MEBADD@Z"
		size = 40
		refs = "001f _Tolower"
	strings:
		$1 = { 88 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 83 C0 10 0F B6 4C 24 38 48 8B D0 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_96_324_2 {
	meta:
		name = "?do_toupper@?$ctype@D@std@@MEBADD@Z"
		size = 40
		refs = "001f _Toupper"
	strings:
		$1 = { 88 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 83 C0 10 0F B6 4C 24 38 48 8B D0 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_282_1 {
	meta:
		name = "?do_tolower@?$ctype@D@std@@MEBAPEBDPEADPEBD@Z"
		size = 90
		refs = "0043 _Tolower"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 EB 0D 48 8B 44 24 38 48 FF C0 48 89 44 24 38 48 8B 44 24 40 48 39 44 24 38 74 22 48 8B 44 24 30 48 83 C0 10 48 8B 4C 24 38 0F B6 09 48 8B D0 E8 ?? ?? ?? ?? 48 8B 4C 24 38 88 01 EB C5 48 8B 44 24 38 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_284_1 {
	meta:
		name = "?do_toupper@?$ctype@D@std@@MEBAPEBDPEADPEBD@Z"
		size = 90
		refs = "0043 _Toupper"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 EB 0D 48 8B 44 24 38 48 FF C0 48 89 44 24 38 48 8B 44 24 40 48 39 44 24 38 74 22 48 8B 44 24 30 48 83 C0 10 48 8B 4C 24 38 0F B6 09 48 8B D0 E8 ?? ?? ?? ?? 48 8B 4C 24 38 88 01 EB C5 48 8B 44 24 38 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_285_1 {
	meta:
		name = "?do_unshift@?$codecvt@DDU_Mbstatet@@@std@@MEBAHAEAU_Mbstatet@@PEAD1AEAPEAD@Z"
		size = 36
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 8B 44 24 28 48 8B 4C 24 18 48 89 08 33 C0 C3 }
	condition:
		$1
}

rule file_1_287_1 {
	meta:
		name = "?do_widen@?$ctype@D@std@@MEBAPEBDPEBD0PEAD@Z"
		size = 68
		refs = "0036 memcpy"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 38 48 8B 4C 24 40 48 2B C8 48 8B C1 4C 8B C0 48 8B 54 24 38 48 8B 4C 24 48 E8 ?? ?? ?? ?? 48 8B 44 24 40 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_288_1 {
	meta:
		name = "?eback@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEBAPEADXZ"
		size = 18
		altNames = "?eback@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEBAPEAGXZ ?eback@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEBAPEA_WXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8B 40 18 48 8B 00 C3 }
	condition:
		$1
}

rule file_1_289_1 {
	meta:
		name = "?egptr@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEBAPEADXZ"
		size = 33
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8B 40 38 48 8B 4C 24 08 48 8B 49 50 48 63 09 48 03 08 48 8B C1 C3 }
	condition:
		$1
}

rule file_1_290_1 {
	meta:
		name = "?empty@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBA_NXZ"
		size = 53
		refs = "000f ?_Mysize@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEBAAEB_KXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 38 00 75 0A C7 44 24 20 01 00 00 00 EB 08 C7 44 24 20 00 00 00 00 0F B6 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_119_1155_1 {
	meta:
		name = "?empty@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEBA_NXZ"
		size = 53
		refs = "000f ?_Mysize@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QEBAAEB_KXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 38 00 75 0A C7 44 24 20 01 00 00 00 EB 08 C7 44 24 20 00 00 00 00 0F B6 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_41_88_1 {
	meta:
		name = "?empty@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEBA_NXZ"
		size = 53
		refs = "000f ?_Mysize@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QEBAAEB_KXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 38 00 75 0A C7 44 24 20 01 00 00 00 EB 08 C7 44 24 20 00 00 00 00 0F B6 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1_292_1 {
	meta:
		name = "?epptr@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEBAPEADXZ"
		size = 33
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8B 40 40 48 8B 4C 24 08 48 8B 49 58 48 63 09 48 03 08 48 8B C1 C3 }
	condition:
		$1
}

rule file_1_293_1 {
	meta:
		name = "?eq_int_type@?$char_traits@D@std@@SA_NAEBH0@Z"
		size = 55
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 18 48 8B 44 24 20 48 8B 4C 24 28 8B 09 39 08 75 09 C7 04 24 01 00 00 00 EB 07 C7 04 24 00 00 00 00 0F B6 04 24 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_1_294_1 {
	meta:
		name = "?equivalent@error_category@std@@UEBA_NAEBVerror_code@2@H@Z"
		size = 93
		refs = "0019 ?category@error_code@std@@QEBAAEBVerror_category@2@XZ 0026 ??8error_category@std@@QEBA_NAEBV01@@Z 0037 ?value@error_code@std@@QEBAHXZ"
	strings:
		$1 = { 44 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 4C 24 48 E8 ?? ?? ?? ?? 48 8B D0 48 8B 4C 24 40 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 1A 48 8B 4C 24 48 E8 ?? ?? ?? ?? 3B 44 24 50 75 0A C7 44 24 20 01 00 00 00 EB 08 C7 44 24 20 00 00 00 00 0F B6 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1_295_1 {
	meta:
		name = "?equivalent@error_category@std@@UEBA_NHAEBVerror_condition@2@@Z"
		size = 82
		refs = "0029 _guard_check_icall 0049 ??8std@@YA_NAEBVerror_condition@0@0@Z"
	strings:
		$1 = { 4C 89 44 24 18 89 54 24 10 48 89 4C 24 08 48 83 EC 48 48 8B 44 24 50 48 8B 00 48 8B 40 18 48 89 44 24 20 48 8B 4C 24 20 E8 ?? ?? ?? ?? 44 8B 44 24 58 48 8D 54 24 28 48 8B 4C 24 50 FF 54 24 20 48 8B 54 24 60 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_1_296_1 {
	meta:
		name = "?erase@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@_K0@Z"
		size = 206
		refs = "001e ?_Check_offset@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBAX_K@Z 0028 ?_Mysize@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAAAEA_KXZ 0049 ?_Eos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_K@Z 005d ?_Myptr@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAAPEADXZ 00b1 ?move@?$char_traits@D@std@@SAPEADPEADPEBD_K@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 4C 24 48 48 8B 00 48 2B C1 48 3B 44 24 50 77 11 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? EB 75 48 83 7C 24 50 00 76 6D 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 03 44 24 48 48 89 44 24 20 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 4C 24 50 48 8B 00 48 2B C1 48 89 44 24 28 48 8B 44 24 48 48 8B 4C 24 28 48 2B C8 48 8B C1 48 8B 4C 24 50 48 8B 54 24 20 48 03 D1 48 8B CA 4C 8B C0 48 8B D1 48 8B 4C 24 20 E8 ?? ?? ?? ?? 48 8B 54 24 28 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1_297_1 {
	meta:
		name = "?erase@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@_K@Z"
		size = 54
		refs = "0019 ?_Check_offset@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBAX_K@Z 0028 ?_Eos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_K@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_119_1168_1 {
	meta:
		name = "?erase@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEAAAEAV12@_K@Z"
		size = 54
		refs = "0019 ?_Check_offset@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEBAX_K@Z 0028 ?_Eos@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEAAX_K@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_41_91_1 {
	meta:
		name = "?erase@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAAAEAV12@_K@Z"
		size = 54
		refs = "0019 ?_Check_offset@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEBAX_K@Z 0028 ?_Eos@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAAX_K@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_298_1 {
	meta:
		name = "?gbump@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAXH@Z"
		size = 70
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 8B 44 24 08 48 8B 40 50 8B 4C 24 10 8B 00 2B C1 48 8B 4C 24 08 48 8B 49 50 89 01 48 8B 44 24 08 48 8B 40 38 48 63 4C 24 10 48 03 08 48 8B C1 48 8B 4C 24 08 48 8B 49 38 48 89 01 C3 }
	condition:
		$1
}

rule file_1_299_1 {
	meta:
		name = "?getloc@ios_base@std@@QEBA?AVlocale@2@XZ"
		size = 62
		refs = "0025 ??0locale@std@@QEAA@AEBV01@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 C7 44 24 20 00 00 00 00 48 8B 44 24 40 48 8B 50 40 48 8B 4C 24 48 E8 ?? ?? ?? ?? 8B 44 24 20 83 C8 01 89 44 24 20 48 8B 44 24 48 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1_300_1 {
	meta:
		name = "?gptr@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEBAPEADXZ"
		size = 18
		altNames = "?gptr@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEBAPEAGXZ ?gptr@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEBAPEA_WXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8B 40 38 48 8B 00 C3 }
	condition:
		$1
}

rule file_1_301_1 {
	meta:
		name = "?imbue@?$basic_filebuf@DU?$char_traits@D@std@@@std@@MEAAXAEBVlocale@2@@Z"
		size = 42
		refs = "0014 ??$use_facet@V?$codecvt@DDU_Mbstatet@@@std@@@std@@YAAEBV?$codecvt@DDU_Mbstatet@@@0@AEBVlocale@0@@Z 0021 ?_Initcvt@?$basic_filebuf@DU?$char_traits@D@std@@@std@@IEAAXPEBV?$codecvt@DDU_Mbstatet@@@2@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B D0 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_40_349_2 {
	meta:
		name = "?imbue@?$basic_filebuf@GU?$char_traits@G@std@@@std@@MEAAXAEBVlocale@2@@Z"
		size = 42
		refs = "0014 ??$use_facet@V?$codecvt@GDU_Mbstatet@@@std@@@std@@YAAEBV?$codecvt@GDU_Mbstatet@@@0@AEBVlocale@0@@Z 0021 ?_Initcvt@?$basic_filebuf@GU?$char_traits@G@std@@@std@@IEAAXPEBV?$codecvt@GDU_Mbstatet@@@2@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B D0 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_116_372_3 {
	meta:
		name = "?imbue@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@MEAAXAEBVlocale@2@@Z"
		size = 42
		refs = "0014 ??$use_facet@V?$codecvt@_WDU_Mbstatet@@@std@@@std@@YAAEBV?$codecvt@_WDU_Mbstatet@@@0@AEBVlocale@0@@Z 0021 ?_Initcvt@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@IEAAXPEBV?$codecvt@_WDU_Mbstatet@@@2@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B D0 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_303_1 {
	meta:
		name = "?in@?$codecvt@DDU_Mbstatet@@@std@@QEBAHAEAU_Mbstatet@@PEBD1AEAPEBDPEAD3AEAPEAD@Z"
		size = 132
		refs = "002f _guard_check_icall"
		altNames = "?in@?$codecvt@GDU_Mbstatet@@@std@@QEBAHAEAU_Mbstatet@@PEBD1AEAPEBDPEAG3AEAPEAG@Z ?in@?$codecvt@_WDU_Mbstatet@@@std@@QEBAHAEAU_Mbstatet@@PEBD1AEAPEBDPEA_W3AEAPEA_W@Z"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 58 48 8B 44 24 60 48 8B 00 48 8B 40 30 48 89 44 24 40 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 84 24 98 00 00 00 48 89 44 24 38 48 8B 84 24 90 00 00 00 48 89 44 24 30 48 8B 84 24 88 00 00 00 48 89 44 24 28 48 8B 84 24 80 00 00 00 48 89 44 24 20 4C 8B 4C 24 78 4C 8B 44 24 70 48 8B 54 24 68 48 8B 4C 24 60 FF 54 24 40 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_1_304_1 {
	meta:
		name = "?init@?$basic_ios@DU?$char_traits@D@std@@@std@@IEAAXPEAV?$basic_streambuf@DU?$char_traits@D@std@@@2@_N@Z"
		size = 130
		refs = "0019 ?_Init@ios_base@std@@IEAAXXZ 0040 ?widen@?$basic_ios@DU?$char_traits@D@std@@@std@@QEBADD@Z 0066 ?setstate@?$basic_ios@DU?$char_traits@D@std@@@std@@QEAAXH_N@Z 0079 ?_Addstd@ios_base@std@@SAXPEAV12@@Z"
	strings:
		$1 = { 44 88 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8B 4C 24 38 48 89 48 48 48 8B 44 24 30 48 C7 40 50 00 00 00 00 B2 20 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 4C 24 30 88 41 58 48 8B 44 24 30 48 83 78 48 00 75 12 45 33 C0 BA 04 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 0F B6 44 24 40 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_305_1 {
	meta:
		name = "?iostream_category@std@@YAAEBVerror_category@1@XZ"
		size = 24
		refs = "000e ??$_Immortalize@V_Iostream_error_category@std@@@std@@YAAEAV_Iostream_error_category@0@XZ"
	strings:
		$1 = { 48 83 EC 38 48 C7 44 24 20 FE FF FF FF E8 ?? ?? ?? ?? 90 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_67_129_1 {
	meta:
		name = "?generic_category@std@@YAAEBVerror_category@1@XZ"
		size = 24
		refs = "000e ??$_Immortalize@V_Generic_error_category@std@@@std@@YAAEAV_Generic_error_category@0@XZ"
	strings:
		$1 = { 48 83 EC 38 48 C7 44 24 20 FE FF FF FF E8 ?? ?? ?? ?? 90 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_85_182_1 {
	meta:
		name = "?system_category@std@@YAAEBVerror_category@1@XZ"
		size = 24
		refs = "000e ??$_Immortalize@V_System_error_category@std@@@std@@YAAEAV_System_error_category@0@XZ"
	strings:
		$1 = { 48 83 EC 38 48 C7 44 24 20 FE FF FF FF E8 ?? ?? ?? ?? 90 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1_306_1 {
	meta:
		name = "?length@?$char_traits@D@std@@SA_KPEBD@Z"
		size = 57
		refs = "0026 strlen"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 0F BE 00 85 C0 75 0B 48 C7 44 24 20 00 00 00 00 EB 0F 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 89 44 24 20 48 8B 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1_307_1 {
	meta:
		name = "?make_error_code@std@@YA?AVerror_code@1@W4io_errc@1@@Z"
		size = 45
		refs = "000e ?iostream_category@std@@YAAEBVerror_category@1@XZ 001f ??0error_code@std@@QEAA@HAEBVerror_category@1@@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 E8 ?? ?? ?? ?? 4C 8B C0 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_308_1 {
	meta:
		name = "?max_size@?$_Wrap_alloc@V?$allocator@D@std@@@std@@QEBA_KU_Nil@2@@Z"
		size = 28
		refs = "0013 ?max_size@?$allocator_traits@V?$allocator@D@std@@@std@@SA_KAEBV?$allocator@D@2@@Z"
	strings:
		$1 = { 88 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_119_1200_1 {
	meta:
		name = "?max_size@?$_Wrap_alloc@V?$allocator@G@std@@@std@@QEBA_KU_Nil@2@@Z"
		size = 28
		refs = "0013 ?max_size@?$allocator_traits@V?$allocator@G@std@@@std@@SA_KAEBV?$allocator@G@2@@Z"
	strings:
		$1 = { 88 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_41_93_1 {
	meta:
		name = "?max_size@?$_Wrap_alloc@V?$allocator@_W@std@@@std@@QEBA_KU_Nil@2@@Z"
		size = 28
		refs = "0013 ?max_size@?$allocator_traits@V?$allocator@_W@std@@@std@@SA_KAEBV?$allocator@_W@2@@Z"
	strings:
		$1 = { 88 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_311_1 {
	meta:
		name = "?max_size@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBA_KXZ"
		size = 79
		refs = "000f ?_Getal@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEBAAEBU?$_Wrap_alloc@V?$allocator@D@std@@@2@XZ 001c ?max_size@?$_Wrap_alloc@V?$allocator@D@std@@@std@@QEBA_KU_Nil@2@@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 48 48 8B 4C 24 50 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8B C8 E8 ?? ?? ?? ?? 48 89 44 24 28 48 83 7C 24 28 01 77 0B 48 C7 44 24 30 01 00 00 00 EB 0D 48 8B 44 24 28 48 FF C8 48 89 44 24 30 48 8B 44 24 30 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_119_1209_1 {
	meta:
		name = "?max_size@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEBA_KXZ"
		size = 79
		refs = "000f ?_Getal@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QEBAAEBU?$_Wrap_alloc@V?$allocator@G@std@@@2@XZ 001c ?max_size@?$_Wrap_alloc@V?$allocator@G@std@@@std@@QEBA_KU_Nil@2@@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 48 48 8B 4C 24 50 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8B C8 E8 ?? ?? ?? ?? 48 89 44 24 28 48 83 7C 24 28 01 77 0B 48 C7 44 24 30 01 00 00 00 EB 0D 48 8B 44 24 28 48 FF C8 48 89 44 24 30 48 8B 44 24 30 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_41_96_1 {
	meta:
		name = "?max_size@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEBA_KXZ"
		size = 79
		refs = "000f ?_Getal@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QEBAAEBU?$_Wrap_alloc@V?$allocator@_W@std@@@2@XZ 001c ?max_size@?$_Wrap_alloc@V?$allocator@_W@std@@@std@@QEBA_KU_Nil@2@@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 48 48 8B 4C 24 50 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8B C8 E8 ?? ?? ?? ?? 48 89 44 24 28 48 83 7C 24 28 01 77 0B 48 C7 44 24 30 01 00 00 00 EB 0D 48 8B 44 24 28 48 FF C8 48 89 44 24 30 48 8B 44 24 30 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_1_312_1 {
	meta:
		name = "?message@_Generic_error_category@std@@UEBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@H@Z"
		size = 70
		refs = "0020 ?_Syserror_map@std@@YAPEBDH@Z 002d ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@PEBD@Z"
	strings:
		$1 = { 44 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 C7 44 24 20 00 00 00 00 8B 4C 24 50 E8 ?? ?? ?? ?? 48 8B D0 48 8B 4C 24 48 E8 ?? ?? ?? ?? 8B 44 24 20 83 C8 01 89 44 24 20 48 8B 44 24 48 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1_313_1 {
	meta:
		name = "?message@_Iostream_error_category@std@@UEBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@H@Z"
		size = 112
		refs = "0025 ??_C@_0BG@PADBLCHM@iostream?5stream?5error?$AA@ 002f ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@PEBD@Z 0057 ?message@_Generic_error_category@std@@UEBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@H@Z"
	strings:
		$1 = { 44 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 C7 44 24 20 00 00 00 00 83 7C 24 50 01 75 25 48 8D 15 ?? ?? ?? ?? 48 8B 4C 24 48 E8 ?? ?? ?? ?? 8B 44 24 20 83 C8 01 89 44 24 20 48 8B 44 24 48 EB 26 EB 24 44 8B 44 24 50 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 8B 44 24 20 83 C8 01 89 44 24 20 48 8B 44 24 48 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1_314_1 {
	meta:
		name = "?message@error_code@std@@QEBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ"
		size = 120
		refs = "001c ?category@error_code@std@@QEBAAEBVerror_category@2@XZ 002b ?value@error_code@std@@QEBAHXZ 004a _guard_check_icall"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 C7 44 24 20 00 00 00 00 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 89 44 24 28 48 8B 4C 24 50 E8 ?? ?? ?? ?? 89 44 24 24 48 8B 4C 24 28 48 8B 09 48 8B 49 10 48 89 4C 24 30 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 24 44 8B C0 48 8B 54 24 58 48 8B 4C 24 28 FF 54 24 30 8B 44 24 20 83 C8 01 89 44 24 20 48 8B 44 24 58 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_1_318_1 {
	meta:
		name = "?not_eof@?$char_traits@D@std@@SAHAEBH@Z"
		size = 80
		refs = "000a ?eof@?$char_traits@D@std@@SAHXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 E8 ?? ?? ?? ?? 48 8B 4C 24 40 39 01 74 0D 48 8B 44 24 40 8B 00 89 44 24 24 EB 23 E8 ?? ?? ?? ?? 85 C0 75 0A C7 44 24 20 01 00 00 00 EB 08 C7 44 24 20 00 00 00 00 8B 44 24 20 89 44 24 24 8B 44 24 24 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1_319_1 {
	meta:
		name = "?out@?$codecvt@DDU_Mbstatet@@@std@@QEBAHAEAU_Mbstatet@@PEBD1AEAPEBDPEAD3AEAPEAD@Z"
		size = 132
		refs = "002f _guard_check_icall"
		altNames = "?out@?$codecvt@GDU_Mbstatet@@@std@@QEBAHAEAU_Mbstatet@@PEBG1AEAPEBGPEAD3AEAPEAD@Z ?out@?$codecvt@_WDU_Mbstatet@@@std@@QEBAHAEAU_Mbstatet@@PEB_W1AEAPEB_WPEAD3AEAPEAD@Z"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 58 48 8B 44 24 60 48 8B 00 48 8B 40 38 48 89 44 24 40 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 84 24 98 00 00 00 48 89 44 24 38 48 8B 84 24 90 00 00 00 48 89 44 24 30 48 8B 84 24 88 00 00 00 48 89 44 24 28 48 8B 84 24 80 00 00 00 48 89 44 24 20 4C 8B 4C 24 78 4C 8B 44 24 70 48 8B 54 24 68 48 8B 4C 24 60 FF 54 24 40 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_1_320_1 {
	meta:
		name = "?overflow@?$basic_filebuf@DU?$char_traits@D@std@@@std@@MEAAHH@Z"
		size = 1073
		refs = "001f __security_cookie 002f ?eof@?$char_traits@D@std@@SAHXZ 0045 ?eq_int_type@?$char_traits@D@std@@SA_NAEBH0@Z 0059 ?not_eof@?$char_traits@D@std@@SAHAEBH@Z 0070 ?pptr@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEBAPEADXZ 0094 ?epptr@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEBAPEADXZ 00ab ?to_char_type@?$char_traits@D@std@@SADAEBH@Z 00bc ?_Pninc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAPEADXZ 00fa ?_Reset_back@?$basic_filebuf@DU?$char_traits@D@std@@@std@@AEAAXXZ 012d ??$_Fputc@D@std@@YA_NDPEAU_iobuf@@@Z 0186 ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@_KD@Z 019c ?begin@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@2@XZ 01a4 ??D?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEBAAEADXZ 01b9 ?size@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBA_KXZ 0242 ?out@?$codecvt@DDU_Mbstatet@@@std@@QEBAHAEAU_Mbstatet@@PEBD1AEAPEBDPEAD3AEAPEAD@Z 02de fwrite 02fb ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@XZ 0372 ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@_KD@Z 0425 __security_check_cookie"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 81 EC F8 00 00 00 48 C7 84 24 A0 00 00 00 FE FF FF FF 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 E8 00 00 00 E8 ?? ?? ?? ?? 89 44 24 58 48 8D 94 24 08 01 00 00 48 8D 4C 24 58 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 17 48 8D 8C 24 08 01 00 00 E8 ?? ?? ?? ?? E9 B7 03 00 00 E9 8A 00 00 00 48 8B 8C 24 00 01 00 00 E8 ?? ?? ?? ?? 48 85 C0 74 5C 48 8B 8C 24 00 01 00 00 E8 ?? ?? ?? ?? 48 89 44 24 78 48 8B 8C 24 00 01 00 00 E8 ?? ?? ?? ?? 48 8B 4C 24 78 48 3B C8 73 33 48 8D 8C 24 08 01 00 00 E8 ?? ?? ?? ?? 88 44 24 42 48 8B 8C 24 00 01 00 00 E8 ?? ?? ?? ?? 0F B6 4C 24 42 88 08 8B 84 24 08 01 00 00 E9 46 03 00 00 EB 1C 48 8B 84 24 00 01 00 00 48 83 B8 80 00 00 00 00 75 0A E8 ?? ?? ?? ?? E9 28 03 00 00 48 8B 8C 24 00 01 00 00 E8 ?? ?? ?? ?? 48 8B 84 24 00 01 00 00 48 83 78 68 00 75 4F 48 8D 8C 24 08 01 00 00 E8 ?? ?? ?? ?? 48 8B 8C 24 00 01 00 00 48 8B 91 80 00 00 00 0F B6 C8 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 0D 8B 84 24 08 01 00 00 89 44 24 48 EB 09 E8 ?? ?? ?? ?? 89 44 24 48 8B 44 24 48 E9 C2 02 00 00 E9 BD 02 00 00 C7 44 24 70 08 00 00 00 48 8D 8C 24 08 01 00 00 E8 ?? ?? ?? ?? 88 44 24 40 45 33 C0 BA 08 00 00 00 48 8D 8C 24 C8 00 00 00 E8 ?? ?? ?? ?? 90 48 8D 94 24 A8 00 00 00 48 8D 8C 24 C8 00 00 00 E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 89 84 24 80 00 00 00 48 8D 8C 24 C8 00 00 00 E8 ?? ?? ?? ?? 48 8B 8C 24 80 00 00 00 48 03 C8 48 8B C1 48 89 84 24 88 00 00 00 48 8D 94 24 B0 00 00 00 48 8D 8C 24 C8 00 00 00 E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 8D 4C 24 41 48 8B 94 24 00 01 00 00 48 83 C2 74 4C 8D 84 24 90 00 00 00 4C 89 44 24 38 4C 8B 84 24 88 00 00 00 4C 89 44 24 30 48 89 44 24 28 48 8D 84 24 98 00 00 00 48 89 44 24 20 4C 8B C9 4C 8D 44 24 40 48 8B 84 24 00 01 00 00 48 8B 48 68 E8 ?? ?? ?? ?? 89 44 24 44 83 7C 24 44 00 0F 8C 95 01 00 00 83 7C 24 44 01 7E 10 83 7C 24 44 03 0F 84 32 01 00 00 E9 7E 01 00 00 48 8D 94 24 B8 00 00 00 48 8D 8C 24 C8 00 00 00 E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 8B 8C 24 90 00 00 00 48 2B C8 48 8B C1 48 89 44 24 50 48 83 7C 24 50 00 76 64 48 8D 94 24 C0 00 00 00 48 8D 8C 24 C8 00 00 00 E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 8B 8C 24 00 01 00 00 4C 8B 89 80 00 00 00 4C 8B 44 24 50 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 48 39 44 24 50 74 1F E8 ?? ?? ?? ?? 89 44 24 5C 48 8D 8C 24 C8 00 00 00 E8 ?? ?? ?? ?? 8B 44 24 5C E9 11 01 00 00 48 8B 84 24 00 01 00 00 C6 40 71 01 48 8D 44 24 40 48 39 84 24 98 00 00 00 74 21 8B 84 24 08 01 00 00 89 44 24 60 48 8D 8C 24 C8 00 00 00 E8 ?? ?? ?? ?? 8B 44 24 60 E9 D5 00 00 00 48 83 7C 24 50 00 76 02 EB 49 48 8D 8C 24 C8 00 00 00 E8 ?? ?? ?? ?? 48 83 F8 20 73 17 45 33 C0 BA 08 00 00 00 48 8D 8C 24 C8 00 00 00 E8 ?? ?? ?? ?? EB 1F E8 ?? ?? ?? ?? 89 44 24 64 48 8D 8C 24 C8 00 00 00 E8 ?? ?? ?? ?? 8B 44 24 64 E9 82 00 00 00 EB 6D 48 8B 84 24 00 01 00 00 48 8B 90 80 00 00 00 0F B6 4C 24 40 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 0D 8B 84 24 08 01 00 00 89 44 24 4C EB 09 E8 ?? ?? ?? ?? 89 44 24 4C 8B 44 24 4C 89 44 24 68 48 8D 8C 24 C8 00 00 00 E8 ?? ?? ?? ?? 8B 44 24 68 EB 2F E8 ?? ?? ?? ?? 89 44 24 6C 48 8D 8C 24 C8 00 00 00 E8 ?? ?? ?? ?? 8B 44 24 6C EB 13 E9 80 FD FF FF 48 8D 8C 24 C8 00 00 00 E8 ?? ?? ?? ?? 90 48 8B 8C 24 E8 00 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 F8 00 00 00 C3 }
	condition:
		$1
}

rule file_1_321_1 {
	meta:
		name = "?dtor$0@?0??overflow@?$basic_filebuf@DU?$char_traits@D@std@@@std@@MEAAHH@Z@4HA"
		size = 27
		refs = "0011 ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@XZ"
		altNames = "?dtor$0@?0??_Getifld@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@1HAEBVlocale@2@@Z@4HA ?dtor$0@?0??_Getifld@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@1HAEBVlocale@2@@Z@4HA ?dtor$0@?0??uflow@?$basic_filebuf@GU?$char_traits@G@std@@@std@@MEAAGXZ@4HA ?dtor$0@?0??uflow@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@MEAAGXZ@4HA"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 8D C8 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_119_675_1 {
	meta:
		name = "?dtor$2@?0??_Getffldx@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@1AEAVios_base@2@PEAH@Z@4HA"
		size = 27
		refs = "0011 ??1locale@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 8D C8 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_119_680_1 {
	meta:
		name = "?dtor$2@?0??_Getffldx@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@1AEAVios_base@2@PEAH@Z@4HA"
		size = 27
		refs = "0011 ??1locale@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 8D C8 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_89_337_2 {
	meta:
		name = "?dtor$6@?0??_Getmfld@?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@AEAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@0_NAEAVios_base@2@PEAD@Z@4HA"
		size = 27
		refs = "0011 ??1?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 8D C8 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_1_322_1 {
	meta:
		name = "?overflow@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHH@Z"
		size = 23
		refs = "000e ?eof@?$char_traits@D@std@@SAHXZ"
		altNames = "?pbackfail@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHH@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_323_1 {
	meta:
		name = "?pbackfail@?$basic_filebuf@DU?$char_traits@D@std@@@std@@MEAAHH@Z"
		size = 378
		refs = "0013 ?gptr@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEBAPEADXZ 0026 ?eback@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEBAPEADXZ 0044 ?eof@?$char_traits@D@std@@SAHXZ 0057 ?eq_int_type@?$char_traits@D@std@@SA_NAEBH0@Z 007c ?to_int_type@?$char_traits@D@std@@SAHAEBD@Z 00a0 ?_Gndec@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAPEADXZ 00aa ?not_eof@?$char_traits@D@std@@SAHAEBH@Z 0107 ?to_char_type@?$char_traits@D@std@@SADAEBH@Z 0121 ??$_Ungetc@D@std@@YA_NAEBDPEAU_iobuf@@@Z 0164 ?_Set_back@?$basic_filebuf@DU?$char_traits@D@std@@@std@@AEAAXXZ"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 48 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 85 C0 0F 84 98 00 00 00 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 89 44 24 30 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 8B 4C 24 30 48 3B C8 73 75 E8 ?? ?? ?? ?? 89 44 24 24 48 8D 54 24 58 48 8D 4C 24 24 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 38 48 8B 4C 24 50 E8 ?? ?? ?? ?? B9 01 00 00 00 48 6B C9 FF 48 03 C1 48 8B C8 E8 ?? ?? ?? ?? 89 44 24 28 48 8D 54 24 58 48 8D 4C 24 28 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 1E 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 8D 4C 24 58 E8 ?? ?? ?? ?? E9 C2 00 00 00 E9 BD 00 00 00 48 8B 44 24 50 48 83 B8 80 00 00 00 00 74 1F E8 ?? ?? ?? ?? 89 44 24 2C 48 8D 54 24 58 48 8D 4C 24 2C E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 0F E8 ?? ?? ?? ?? E9 85 00 00 00 E9 80 00 00 00 48 8B 44 24 50 48 83 78 68 00 75 33 48 8D 4C 24 58 E8 ?? ?? ?? ?? 88 44 24 20 48 8B 44 24 50 48 8B 90 80 00 00 00 48 8D 4C 24 20 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 08 8B 44 24 58 EB 43 EB 41 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 8B 4C 24 50 48 83 C1 70 48 3B C1 74 24 48 8D 4C 24 58 E8 ?? ?? ?? ?? 48 8B 4C 24 50 88 41 70 48 8B 4C 24 50 E8 ?? ?? ?? ?? 8B 44 24 58 EB 07 EB 05 E8 ?? ?? ?? ?? 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_1_325_1 {
	meta:
		name = "?pbump@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAXH@Z"
		size = 70
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 8B 44 24 08 48 8B 40 58 8B 4C 24 10 8B 00 2B C1 48 8B 4C 24 08 48 8B 49 58 89 01 48 8B 44 24 08 48 8B 40 40 48 63 4C 24 10 48 03 08 48 8B C1 48 8B 4C 24 08 48 8B 49 40 48 89 01 C3 }
	condition:
		$1
}

rule file_1_327_1 {
	meta:
		name = "?pptr@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEBAPEADXZ"
		size = 18
		altNames = "?pptr@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEBAPEAGXZ ?pptr@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEBAPEA_WXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8B 40 40 48 8B 00 C3 }
	condition:
		$1
}

rule file_1_329_1 {
	meta:
		name = "?seekoff@?$basic_filebuf@DU?$char_traits@D@std@@@std@@MEAA?AV?$fpos@U_Mbstatet@@@2@_JHH@Z"
		size = 252
		refs = "001e ?gptr@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEBAPEADXZ 0065 ?_Endwrite@?$basic_filebuf@DU?$char_traits@D@std@@@std@@IEAA_NXZ 0096 _fseeki64 00b0 fgetpos 00bb ?_BADOFF@std@@3_JB 00c5 ??0?$fpos@U_Mbstatet@@@std@@QEAA@_J@Z 00d6 ?_Reset_back@?$basic_filebuf@DU?$char_traits@D@std@@@std@@AEAAXXZ 00ee ??0?$fpos@U_Mbstatet@@@std@@QEAA@U_Mbstatet@@_J@Z"
	strings:
		$1 = { 44 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 4C 24 40 48 83 C1 70 48 3B C1 75 20 83 7C 24 58 01 75 19 48 8B 44 24 40 48 83 78 68 00 75 0D 48 8B 44 24 50 48 FF C8 48 89 44 24 50 48 8B 44 24 40 48 83 B8 80 00 00 00 00 74 59 48 8B 4C 24 40 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 48 48 83 7C 24 50 00 75 07 83 7C 24 58 01 74 1F 44 8B 44 24 58 48 8B 54 24 50 48 8B 44 24 40 48 8B 88 80 00 00 00 E8 ?? ?? ?? ?? 85 C0 75 1A 48 8D 54 24 20 48 8B 44 24 40 48 8B 88 80 00 00 00 E8 ?? ?? ?? ?? 85 C0 74 18 48 8B 15 ?? ?? ?? ?? 48 8B 4C 24 48 E8 ?? ?? ?? ?? 48 8B 44 24 48 EB 27 48 8B 4C 24 40 E8 ?? ?? ?? ?? 4C 8B 44 24 20 48 8B 44 24 40 48 8B 50 74 48 8B 4C 24 48 E8 ?? ?? ?? ?? 48 8B 44 24 48 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1_330_1 {
	meta:
		name = "?seekoff@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAA?AV?$fpos@U_Mbstatet@@@2@_JHH@Z"
		size = 51
		refs = "001b ?_BADOFF@std@@3_JB 0025 ??0?$fpos@U_Mbstatet@@@std@@QEAA@_J@Z"
		altNames = "?seekoff@?$basic_streambuf@GU?$char_traits@G@std@@@std@@MEAA?AV?$fpos@U_Mbstatet@@@2@_JHH@Z ?seekoff@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@MEAA?AV?$fpos@U_Mbstatet@@@2@_JHH@Z ?seekpos@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAA?AV?$fpos@U_Mbstatet@@@2@V32@H@Z ?seekpos@?$basic_streambuf@GU?$char_traits@G@std@@@std@@MEAA?AV?$fpos@U_Mbstatet@@@2@V32@H@Z ?seekpos@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@MEAA?AV?$fpos@U_Mbstatet@@@2@V32@H@Z"
	strings:
		$1 = { 44 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 15 ?? ?? ?? ?? 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B 44 24 38 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_331_1 {
	meta:
		name = "?seekpos@?$basic_filebuf@DU?$char_traits@D@std@@@std@@MEAA?AV?$fpos@U_Mbstatet@@@2@V32@H@Z"
		size = 278
		refs = "001e ?seekpos@?$fpos@U_Mbstatet@@@std@@QEBA_JXZ 002d ??B?$fpos@U_Mbstatet@@@std@@QEBA_JXZ 0050 ?_Endwrite@?$basic_filebuf@DU?$char_traits@D@std@@@std@@IEAA_NXZ 006d fsetpos 0095 _fseeki64 00af fgetpos 00ba ?_BADOFF@std@@3_JB 00c4 ??0?$fpos@U_Mbstatet@@@std@@QEAA@_J@Z 00da ?state@?$fpos@U_Mbstatet@@@std@@QEBA?AU_Mbstatet@@XZ 00f0 ?_Reset_back@?$basic_filebuf@DU?$char_traits@D@std@@@std@@AEAAXXZ 0108 ??0?$fpos@U_Mbstatet@@@std@@QEAA@U_Mbstatet@@_J@Z"
	strings:
		$1 = { 44 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 48 8B 4C 24 60 E8 ?? ?? ?? ?? 48 89 44 24 20 48 8B 4C 24 60 E8 ?? ?? ?? ?? 48 2B 44 24 20 48 89 44 24 28 48 8B 44 24 50 48 83 B8 80 00 00 00 00 74 6D 48 8B 4C 24 50 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 5C 48 8D 54 24 20 48 8B 44 24 50 48 8B 88 80 00 00 00 E8 ?? ?? ?? ?? 85 C0 75 42 48 83 7C 24 28 00 74 20 41 B8 01 00 00 00 48 8B 54 24 28 48 8B 44 24 50 48 8B 88 80 00 00 00 E8 ?? ?? ?? ?? 85 C0 75 1A 48 8D 54 24 20 48 8B 44 24 50 48 8B 88 80 00 00 00 E8 ?? ?? ?? ?? 85 C0 74 18 48 8B 15 ?? ?? ?? ?? 48 8B 4C 24 58 E8 ?? ?? ?? ?? 48 8B 44 24 58 EB 42 48 8D 54 24 30 48 8B 4C 24 60 E8 ?? ?? ?? ?? 48 8B 00 48 8B 4C 24 50 48 89 41 74 48 8B 4C 24 50 E8 ?? ?? ?? ?? 4C 8B 44 24 20 48 8B 44 24 50 48 8B 50 74 48 8B 4C 24 58 E8 ?? ?? ?? ?? 48 8B 44 24 58 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_40_385_2 {
	meta:
		name = "?seekpos@?$basic_filebuf@GU?$char_traits@G@std@@@std@@MEAA?AV?$fpos@U_Mbstatet@@@2@V32@H@Z"
		size = 278
		refs = "001e ?seekpos@?$fpos@U_Mbstatet@@@std@@QEBA_JXZ 002d ??B?$fpos@U_Mbstatet@@@std@@QEBA_JXZ 0050 ?_Endwrite@?$basic_filebuf@GU?$char_traits@G@std@@@std@@IEAA_NXZ 006d fsetpos 0095 _fseeki64 00af fgetpos 00ba ?_BADOFF@std@@3_JB 00c4 ??0?$fpos@U_Mbstatet@@@std@@QEAA@_J@Z 00da ?state@?$fpos@U_Mbstatet@@@std@@QEBA?AU_Mbstatet@@XZ 00f0 ?_Reset_back@?$basic_filebuf@GU?$char_traits@G@std@@@std@@AEAAXXZ 0108 ??0?$fpos@U_Mbstatet@@@std@@QEAA@U_Mbstatet@@_J@Z"
	strings:
		$1 = { 44 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 48 8B 4C 24 60 E8 ?? ?? ?? ?? 48 89 44 24 20 48 8B 4C 24 60 E8 ?? ?? ?? ?? 48 2B 44 24 20 48 89 44 24 28 48 8B 44 24 50 48 83 B8 80 00 00 00 00 74 6D 48 8B 4C 24 50 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 5C 48 8D 54 24 20 48 8B 44 24 50 48 8B 88 80 00 00 00 E8 ?? ?? ?? ?? 85 C0 75 42 48 83 7C 24 28 00 74 20 41 B8 01 00 00 00 48 8B 54 24 28 48 8B 44 24 50 48 8B 88 80 00 00 00 E8 ?? ?? ?? ?? 85 C0 75 1A 48 8D 54 24 20 48 8B 44 24 50 48 8B 88 80 00 00 00 E8 ?? ?? ?? ?? 85 C0 74 18 48 8B 15 ?? ?? ?? ?? 48 8B 4C 24 58 E8 ?? ?? ?? ?? 48 8B 44 24 58 EB 42 48 8D 54 24 30 48 8B 4C 24 60 E8 ?? ?? ?? ?? 48 8B 00 48 8B 4C 24 50 48 89 41 74 48 8B 4C 24 50 E8 ?? ?? ?? ?? 4C 8B 44 24 20 48 8B 44 24 50 48 8B 50 74 48 8B 4C 24 58 E8 ?? ?? ?? ?? 48 8B 44 24 58 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_116_408_3 {
	meta:
		name = "?seekpos@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@MEAA?AV?$fpos@U_Mbstatet@@@2@V32@H@Z"
		size = 278
		refs = "001e ?seekpos@?$fpos@U_Mbstatet@@@std@@QEBA_JXZ 002d ??B?$fpos@U_Mbstatet@@@std@@QEBA_JXZ 0050 ?_Endwrite@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@IEAA_NXZ 006d fsetpos 0095 _fseeki64 00af fgetpos 00ba ?_BADOFF@std@@3_JB 00c4 ??0?$fpos@U_Mbstatet@@@std@@QEAA@_J@Z 00da ?state@?$fpos@U_Mbstatet@@@std@@QEBA?AU_Mbstatet@@XZ 00f0 ?_Reset_back@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@AEAAXXZ 0108 ??0?$fpos@U_Mbstatet@@@std@@QEAA@U_Mbstatet@@_J@Z"
	strings:
		$1 = { 44 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 48 8B 4C 24 60 E8 ?? ?? ?? ?? 48 89 44 24 20 48 8B 4C 24 60 E8 ?? ?? ?? ?? 48 2B 44 24 20 48 89 44 24 28 48 8B 44 24 50 48 83 B8 80 00 00 00 00 74 6D 48 8B 4C 24 50 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 5C 48 8D 54 24 20 48 8B 44 24 50 48 8B 88 80 00 00 00 E8 ?? ?? ?? ?? 85 C0 75 42 48 83 7C 24 28 00 74 20 41 B8 01 00 00 00 48 8B 54 24 28 48 8B 44 24 50 48 8B 88 80 00 00 00 E8 ?? ?? ?? ?? 85 C0 75 1A 48 8D 54 24 20 48 8B 44 24 50 48 8B 88 80 00 00 00 E8 ?? ?? ?? ?? 85 C0 74 18 48 8B 15 ?? ?? ?? ?? 48 8B 4C 24 58 E8 ?? ?? ?? ?? 48 8B 44 24 58 EB 42 48 8D 54 24 30 48 8B 4C 24 60 E8 ?? ?? ?? ?? 48 8B 00 48 8B 4C 24 50 48 89 41 74 48 8B 4C 24 50 E8 ?? ?? ?? ?? 4C 8B 44 24 20 48 8B 44 24 50 48 8B 50 74 48 8B 4C 24 58 E8 ?? ?? ?? ?? 48 8B 44 24 58 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_1_334_1 {
	meta:
		name = "?select_on_container_copy_construction@?$_Wrap_alloc@V?$allocator@D@std@@@std@@QEBA?AU12@U_Nil@2@@Z"
		size = 57
		refs = "001e ?select_on_container_copy_construction@?$allocator_traits@V?$allocator@D@std@@@std@@SA?AV?$allocator@D@2@AEBV32@@Z 002b ??$?0V?$allocator@D@std@@@?$_Wrap_alloc@V?$allocator@D@std@@@std@@QEAA@$$QEAV?$allocator@D@1@@Z"
	strings:
		$1 = { 44 88 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 54 24 40 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B D0 48 8B 4C 24 48 E8 ?? ?? ?? ?? 48 8B 44 24 48 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_119_1243_1 {
	meta:
		name = "?select_on_container_copy_construction@?$_Wrap_alloc@V?$allocator@G@std@@@std@@QEBA?AU12@U_Nil@2@@Z"
		size = 57
		refs = "001e ?select_on_container_copy_construction@?$allocator_traits@V?$allocator@G@std@@@std@@SA?AV?$allocator@G@2@AEBV32@@Z 002b ??$?0V?$allocator@G@std@@@?$_Wrap_alloc@V?$allocator@G@std@@@std@@QEAA@$$QEAV?$allocator@G@1@@Z"
	strings:
		$1 = { 44 88 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 54 24 40 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B D0 48 8B 4C 24 48 E8 ?? ?? ?? ?? 48 8B 44 24 48 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_119_1244_1 {
	meta:
		name = "?select_on_container_copy_construction@?$_Wrap_alloc@V?$allocator@_W@std@@@std@@QEBA?AU12@U_Nil@2@@Z"
		size = 57
		refs = "001e ?select_on_container_copy_construction@?$allocator_traits@V?$allocator@_W@std@@@std@@SA?AV?$allocator@_W@2@AEBV32@@Z 002b ??$?0V?$allocator@_W@std@@@?$_Wrap_alloc@V?$allocator@_W@std@@@std@@QEAA@$$QEAV?$allocator@_W@1@@Z"
	strings:
		$1 = { 44 88 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 54 24 40 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B D0 48 8B 4C 24 48 E8 ?? ?? ?? ?? 48 8B 44 24 48 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1_335_1 {
	meta:
		name = "?select_on_container_copy_construction@?$allocator_traits@V?$allocator@D@std@@@std@@SA?AV?$allocator@D@2@AEBV32@@Z"
		size = 39
		refs = "0019 ??0?$allocator@D@std@@QEAA@AEBV01@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_89_86_2 {
	meta:
		name = "??0?$_Iterator012@Urandom_access_iterator_tag@std@@D_JPEBDAEBDU_Iterator_base12@2@@std@@QEAA@$$QEAU01@@Z"
		size = 39
		refs = "0019 ??0_Iterator_base12@std@@QEAA@AEBU01@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_38_101_3 {
	meta:
		name = "??0?$_Iterator012@Urandom_access_iterator_tag@std@@D_JPEBDAEBDU_Iterator_base12@2@@std@@QEAA@AEBU01@@Z"
		size = 39
		refs = "0019 ??0_Iterator_base12@std@@QEAA@AEBU01@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_103_254_3 {
	meta:
		name = "??0?$_Iterator012@Urandom_access_iterator_tag@std@@G_JPEBGAEBGU_Iterator_base12@2@@std@@QEAA@$$QEAU01@@Z"
		size = 39
		refs = "0019 ??0_Iterator_base12@std@@QEAA@AEBU01@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_103_255_3 {
	meta:
		name = "??0?$_Iterator012@Urandom_access_iterator_tag@std@@G_JPEBGAEBGU_Iterator_base12@2@@std@@QEAA@AEBU01@@Z"
		size = 39
		refs = "0019 ??0_Iterator_base12@std@@QEAA@AEBU01@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_103_257_3 {
	meta:
		name = "??0?$_Iterator012@Urandom_access_iterator_tag@std@@_W_JPEB_WAEB_WU_Iterator_base12@2@@std@@QEAA@$$QEAU01@@Z"
		size = 39
		refs = "0019 ??0_Iterator_base12@std@@QEAA@AEBU01@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_10_212_2 {
	meta:
		name = "??0?$_Iterator012@Urandom_access_iterator_tag@std@@_W_JPEB_WAEB_WU_Iterator_base12@2@@std@@QEAA@AEBU01@@Z"
		size = 39
		refs = "0019 ??0_Iterator_base12@std@@QEAA@AEBU01@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_38_112_3 {
	meta:
		name = "??0?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEAA@AEBV01@@Z"
		size = 39
		refs = "0019 ??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEAA@AEBV01@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_10_234_2 {
	meta:
		name = "??0?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QEAA@AEBV01@@Z"
		size = 39
		refs = "0019 ??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QEAA@AEBV01@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_10_236_2 {
	meta:
		name = "??0?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QEAA@AEBV01@@Z"
		size = 39
		refs = "0019 ??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QEAA@AEBV01@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_34_2_3 {
	meta:
		name = "??0exception_ptr@std@@QEAA@AEBV01@@Z"
		size = 39
		refs = "0019 ?__ExceptionPtrCopy@@YAXPEAXPEBX@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_89_203_2 {
	meta:
		name = "??4?$_Iterator012@Urandom_access_iterator_tag@std@@D_JPEBDAEBDU_Iterator_base12@2@@std@@QEAAAEAU01@$$QEAU01@@Z"
		size = 39
		refs = "0019 ??4_Iterator_base12@std@@QEAAAEAU01@AEBU01@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_103_483_3 {
	meta:
		name = "??4?$_Iterator012@Urandom_access_iterator_tag@std@@G_JPEBGAEBGU_Iterator_base12@2@@std@@QEAAAEAU01@$$QEAU01@@Z"
		size = 39
		refs = "0019 ??4_Iterator_base12@std@@QEAAAEAU01@AEBU01@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_10_438_2 {
	meta:
		name = "??4?$_Iterator012@Urandom_access_iterator_tag@std@@_W_JPEB_WAEB_WU_Iterator_base12@2@@std@@QEAAAEAU01@$$QEAU01@@Z"
		size = 39
		refs = "0019 ??4_Iterator_base12@std@@QEAAAEAU01@AEBU01@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_89_231_2 {
	meta:
		name = "??Y?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEAAAEAV01@_J@Z"
		size = 39
		refs = "0019 ??Y?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEAAAEAV01@_J@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_10_494_2 {
	meta:
		name = "??Y?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QEAAAEAV01@_J@Z"
		size = 39
		refs = "0019 ??Y?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QEAAAEAV01@_J@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_103_542_3 {
	meta:
		name = "??Y?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QEAAAEAV01@_J@Z"
		size = 39
		refs = "0019 ??Y?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QEAAAEAV01@_J@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_12_125_4 {
	meta:
		name = "?getVbTableType@UnDecorator@@CA?AVDName@@AEBV2@@Z"
		size = 39
		refs = "0019 ?getVfTableType@UnDecorator@@CA?AVDName@@AEBV2@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_119_1245_1 {
	meta:
		name = "?select_on_container_copy_construction@?$allocator_traits@V?$allocator@G@std@@@std@@SA?AV?$allocator@G@2@AEBV32@@Z"
		size = 39
		refs = "0019 ??0?$allocator@G@std@@QEAA@AEBV01@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_119_1246_1 {
	meta:
		name = "?select_on_container_copy_construction@?$allocator_traits@V?$allocator@_W@std@@@std@@SA?AV?$allocator@_W@2@AEBV32@@Z"
		size = 39
		refs = "0019 ??0?$allocator@_W@std@@QEAA@AEBV01@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_336_1 {
	meta:
		name = "?setbuf@?$basic_filebuf@DU?$char_traits@D@std@@@std@@MEAAPEAV?$basic_streambuf@DU?$char_traits@D@std@@@2@PEAD_J@Z"
		size = 148
		refs = "0060 setvbuf 0086 ?_Init@?$basic_filebuf@DU?$char_traits@D@std@@@std@@IEAAXPEAU_iobuf@@W4_Initfl@12@@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 48 83 B8 80 00 00 00 00 74 46 48 83 7C 24 48 00 75 12 48 83 7C 24 50 00 75 0A C7 44 24 20 04 00 00 00 EB 08 C7 44 24 20 00 00 00 00 4C 8B 4C 24 50 44 8B 44 24 20 48 8B 54 24 48 48 8B 44 24 40 48 8B 88 80 00 00 00 E8 ?? ?? ?? ?? 85 C0 74 06 33 C0 EB 23 EB 21 41 B8 01 00 00 00 48 8B 44 24 40 48 8B 90 80 00 00 00 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1_337_1 {
	meta:
		name = "?setbuf@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAPEAV12@PEAD_J@Z"
		size = 21
		altNames = "?setbuf@?$basic_streambuf@GU?$char_traits@G@std@@@std@@MEAAPEAV12@PEAG_J@Z ?setbuf@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@MEAAPEAV12@PEA_W_J@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 8B 44 24 08 C3 }
	condition:
		$1
}

rule file_1_338_1 {
	meta:
		name = "?setf@ios_base@std@@QEAAHH@Z"
		size = 61
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 18 48 8B 44 24 20 8B 40 18 89 04 24 8B 44 24 28 25 FF FF 00 00 48 8B 4C 24 20 8B 49 18 0B C8 8B C1 48 8B 4C 24 20 89 41 18 8B 04 24 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_1_339_1 {
	meta:
		name = "?setg@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAXPEAD00@Z"
		size = 82
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 8B 44 24 08 48 8B 40 18 48 8B 4C 24 10 48 89 08 48 8B 44 24 08 48 8B 40 38 48 8B 4C 24 18 48 89 08 48 8B 44 24 18 48 8B 4C 24 20 48 2B C8 48 8B C1 48 8B 4C 24 08 48 8B 49 50 89 01 C3 }
	condition:
		$1
}

rule file_1_340_1 {
	meta:
		name = "?setp@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAXPEAD0@Z"
		size = 77
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 8B 44 24 08 48 8B 40 20 48 8B 4C 24 10 48 89 08 48 8B 44 24 08 48 8B 40 40 48 8B 4C 24 10 48 89 08 48 8B 44 24 10 48 8B 4C 24 18 48 2B C8 48 8B C1 48 8B 4C 24 08 48 8B 49 58 89 01 C3 }
	condition:
		$1
}

rule file_1_341_1 {
	meta:
		name = "?setstate@?$basic_ios@DU?$char_traits@D@std@@@std@@QEAAXH_N@Z"
		size = 62
		refs = "001f ?rdstate@ios_base@std@@QEBAHXZ 0035 ?clear@?$basic_ios@DU?$char_traits@D@std@@@std@@QEAAXH_N@Z"
	strings:
		$1 = { 44 88 44 24 18 89 54 24 10 48 89 4C 24 08 48 83 EC 28 83 7C 24 38 00 74 20 48 8B 4C 24 30 E8 ?? ?? ?? ?? 0B 44 24 38 44 0F B6 44 24 40 8B D0 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_5_348_1 {
	meta:
		name = "?setstate@?$basic_ios@GU?$char_traits@G@std@@@std@@QEAAXH_N@Z"
		size = 62
		refs = "001f ?rdstate@ios_base@std@@QEBAHXZ 0035 ?clear@?$basic_ios@GU?$char_traits@G@std@@@std@@QEAAXH_N@Z"
	strings:
		$1 = { 44 88 44 24 18 89 54 24 10 48 89 4C 24 08 48 83 EC 28 83 7C 24 38 00 74 20 48 8B 4C 24 30 E8 ?? ?? ?? ?? 0B 44 24 38 44 0F B6 44 24 40 8B D0 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_116_417_3 {
	meta:
		name = "?setstate@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QEAAXH_N@Z"
		size = 62
		refs = "001f ?rdstate@ios_base@std@@QEBAHXZ 0035 ?clear@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QEAAXH_N@Z"
	strings:
		$1 = { 44 88 44 24 18 89 54 24 10 48 89 4C 24 08 48 83 EC 28 83 7C 24 38 00 74 20 48 8B 4C 24 30 E8 ?? ?? ?? ?? 0B 44 24 38 44 0F B6 44 24 40 8B D0 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_343_1 {
	meta:
		name = "?size@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBA_KXZ"
		size = 27
		refs = "000f ?_Mysize@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEBAAEB_KXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 00 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_85_149_1 {
	meta:
		name = "?capacity@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBA_KXZ"
		size = 27
		refs = "000f ?_Myres@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEBAAEB_KXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 00 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_119_1250_1 {
	meta:
		name = "?size@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEBA_KXZ"
		size = 27
		refs = "000f ?_Mysize@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QEBAAEB_KXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 00 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_119_1251_1 {
	meta:
		name = "?size@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEBA_KXZ"
		size = 27
		refs = "000f ?_Mysize@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QEBAAEB_KXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 00 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_344_1 {
	meta:
		name = "?state@?$fpos@U_Mbstatet@@@std@@QEBA?AU_Mbstatet@@XZ"
		size = 33
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 8B 44 24 08 48 8B 40 10 48 8B 4C 24 10 48 89 01 48 8B 44 24 10 C3 }
	condition:
		$1
}

rule file_1_345_1 {
	meta:
		name = "?sync@?$basic_filebuf@DU?$char_traits@D@std@@@std@@MEAAHXZ"
		size = 158
		refs = "0019 ?eof@?$char_traits@D@std@@SAHXZ 0038 _guard_check_icall 0063 ?eq_int_type@?$char_traits@D@std@@SA_NAEBH0@Z 007b fflush"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 48 48 8B 44 24 50 48 83 B8 80 00 00 00 00 74 75 E8 ?? ?? ?? ?? 89 44 24 24 48 8B 4C 24 50 48 8B 09 48 8B 49 18 48 89 4C 24 30 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 24 8B D0 48 8B 4C 24 50 FF 54 24 30 89 44 24 28 E8 ?? ?? ?? ?? 89 44 24 2C 48 8D 54 24 28 48 8D 4C 24 2C E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 1F 48 8B 44 24 50 48 8B 88 80 00 00 00 E8 ?? ?? ?? ?? 85 C0 7D 0A C7 44 24 20 FF FF FF FF EB 08 C7 44 24 20 00 00 00 00 8B 44 24 20 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_1_347_1 {
	meta:
		name = "?tie@?$basic_ios@DU?$char_traits@D@std@@@std@@QEAAPEAV?$basic_ostream@DU?$char_traits@D@std@@@2@PEAV32@@Z"
		size = 50
		altNames = "?tie@?$basic_ios@GU?$char_traits@G@std@@@std@@QEAAPEAV?$basic_ostream@GU?$char_traits@G@std@@@2@PEAV32@@Z ?tie@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QEAAPEAV?$basic_ostream@_WU?$char_traits@_W@std@@@2@PEAV32@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 18 48 8B 44 24 20 48 8B 40 50 48 89 04 24 48 8B 44 24 20 48 8B 4C 24 28 48 89 48 50 48 8B 04 24 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_1_350_1 {
	meta:
		name = "?uflow@?$basic_filebuf@DU?$char_traits@D@std@@@std@@MEAAHXZ"
		size = 1025
		refs = "001b __security_cookie 0033 ?gptr@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEBAPEADXZ 0057 ?egptr@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEBAPEADXZ 006e ?_Gninc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAPEADXZ 0076 ?to_int_type@?$char_traits@D@std@@SAHAEBD@Z 0094 ?eof@?$char_traits@D@std@@SAHXZ 00a6 ?_Reset_back@?$basic_filebuf@DU?$char_traits@D@std@@@std@@AEAAXXZ 00d3 ??$_Fgetc@D@std@@YA_NAEADPEAU_iobuf@@@Z 010e ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@XZ 0123 fgetc 0144 ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@XZ 0165 ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@_KD@Z 0187 ?begin@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@2@XZ 018f ??D?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEBAAEADXZ 01a1 ?size@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBA_KXZ 022d ?in@?$codecvt@DDU_Mbstatet@@@std@@QEBAHAEAU_Mbstatet@@PEBD1AEAPEBDPEAD3AEAPEAD@Z 02e4 ungetc 0346 ?erase@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@_K0@Z 0395 memcpy_s 03f5 __security_check_cookie"
	strings:
		$1 = { 48 89 4C 24 08 48 81 EC 08 01 00 00 48 C7 84 24 A0 00 00 00 FE FF FF FF 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 F0 00 00 00 48 8B 8C 24 10 01 00 00 E8 ?? ?? ?? ?? 48 85 C0 74 45 48 8B 8C 24 10 01 00 00 E8 ?? ?? ?? ?? 48 89 44 24 70 48 8B 8C 24 10 01 00 00 E8 ?? ?? ?? ?? 48 8B 4C 24 70 48 3B C8 73 1C 48 8B 8C 24 10 01 00 00 E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? E9 6A 03 00 00 EB 1C 48 8B 84 24 10 01 00 00 48 83 B8 80 00 00 00 00 75 0A E8 ?? ?? ?? ?? E9 4C 03 00 00 48 8B 8C 24 10 01 00 00 E8 ?? ?? ?? ?? 48 8B 84 24 10 01 00 00 48 83 78 68 00 75 4C C6 44 24 40 00 48 8B 84 24 10 01 00 00 48 8B 90 80 00 00 00 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 10 48 8D 4C 24 40 E8 ?? ?? ?? ?? 89 44 24 4C EB 09 E8 ?? ?? ?? ?? 89 44 24 4C 8B 44 24 4C E9 E9 02 00 00 E9 E4 02 00 00 48 8D 8C 24 D0 00 00 00 E8 ?? ?? ?? ?? 90 48 8B 84 24 10 01 00 00 48 8B 88 80 00 00 00 E8 ?? ?? ?? ?? 89 44 24 50 83 7C 24 50 FF 75 1F E8 ?? ?? ?? ?? 89 44 24 54 48 8D 8C 24 D0 00 00 00 E8 ?? ?? ?? ?? 8B 44 24 54 E9 98 02 00 00 44 0F B6 44 24 50 BA 01 00 00 00 48 8D 8C 24 D0 00 00 00 E8 ?? ?? ?? ?? 48 8D 44 24 42 48 89 84 24 80 00 00 00 48 8D 94 24 A8 00 00 00 48 8D 8C 24 D0 00 00 00 E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 89 44 24 78 48 8D 8C 24 D0 00 00 00 E8 ?? ?? ?? ?? 48 8B 4C 24 78 48 03 C8 48 8B C1 48 89 84 24 88 00 00 00 48 8D 94 24 B0 00 00 00 48 8D 8C 24 D0 00 00 00 E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 8B 8C 24 10 01 00 00 48 83 C1 74 48 8D 94 24 90 00 00 00 48 89 54 24 38 48 8B 94 24 80 00 00 00 48 89 54 24 30 48 8D 54 24 41 48 89 54 24 28 48 8D 54 24 68 48 89 54 24 20 48 8B 94 24 88 00 00 00 4C 8B CA 4C 8B C0 48 8B D1 48 8B 84 24 10 01 00 00 48 8B 48 68 E8 ?? ?? ?? ?? 89 44 24 48 83 7C 24 48 00 0F 8C 7A 01 00 00 83 7C 24 48 01 7E 10 83 7C 24 48 03 0F 84 FD 00 00 00 E9 63 01 00 00 48 8D 44 24 41 48 39 84 24 90 00 00 00 0F 84 A6 00 00 00 48 8D 94 24 B8 00 00 00 48 8D 8C 24 D0 00 00 00 E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 89 84 24 98 00 00 00 48 8D 8C 24 D0 00 00 00 E8 ?? ?? ?? ?? 48 8B 8C 24 98 00 00 00 48 03 C8 48 8B C1 48 2B 44 24 68 89 44 24 44 83 7C 24 44 00 7E 30 8B 44 24 44 FF C8 89 44 24 44 48 63 44 24 44 48 8B 4C 24 68 0F BE 04 01 48 8B 8C 24 10 01 00 00 48 8B 91 80 00 00 00 8B C8 E8 ?? ?? ?? ?? EB C9 48 8D 4C 24 41 E8 ?? ?? ?? ?? 89 44 24 58 48 8D 8C 24 D0 00 00 00 E8 ?? ?? ?? ?? 8B 44 24 58 E9 DB 00 00 00 EB 3A 48 8D 94 24 C0 00 00 00 48 8D 8C 24 D0 00 00 00 E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 8B 4C 24 68 48 2B C8 48 8B C1 4C 8B C0 33 D2 48 8D 8C 24 D0 00 00 00 E8 ?? ?? ?? ?? E9 87 00 00 00 48 8D 8C 24 D0 00 00 00 E8 ?? ?? ?? ?? 48 83 F8 01 73 02 EB 72 48 8D 94 24 C8 00 00 00 48 8D 8C 24 D0 00 00 00 E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 41 B9 01 00 00 00 4C 8B C0 BA 01 00 00 00 48 8D 4C 24 41 E8 ?? ?? ?? ?? 48 8D 4C 24 41 E8 ?? ?? ?? ?? 89 44 24 5C 48 8D 8C 24 D0 00 00 00 E8 ?? ?? ?? ?? 8B 44 24 5C EB 2F E8 ?? ?? ?? ?? 89 44 24 60 48 8D 8C 24 D0 00 00 00 E8 ?? ?? ?? ?? 8B 44 24 60 EB 13 E9 38 FD FF FF 48 8D 8C 24 D0 00 00 00 E8 ?? ?? ?? ?? 90 48 8B 8C 24 F0 00 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 08 01 00 00 C3 }
	condition:
		$1
}

rule file_1_351_1 {
	meta:
		name = "?dtor$0@?0??uflow@?$basic_filebuf@DU?$char_traits@D@std@@@std@@MEAAHXZ@4HA"
		size = 27
		refs = "0011 ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@XZ"
		altNames = "?dtor$1@?0??do_put@?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@_NAEAVios_base@2@DO@Z@4HA ?dtor$3@?0??_Getffldx@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1AEAVios_base@2@PEAH@Z@4HA"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 8D D0 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_62_154_1 {
	meta:
		name = "?dtor$0@?0??_Fput@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@DPEBD_K@Z@4HA"
		size = 27
		refs = "0011 ??1locale@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 8D D0 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_119_542_1 {
	meta:
		name = "?dtor$0@?0??_Fput@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@AEBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AEAVios_base@2@GPEBD_K@Z@4HA"
		size = 27
		refs = "0011 ??1locale@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 8D D0 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_10_626_2 {
	meta:
		name = "?dtor$0@?0??_Fput@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@AEBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AEAVios_base@2@_WPEBD_K@Z@4HA"
		size = 27
		refs = "0011 ??1locale@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 8D D0 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_5_223_3 {
	meta:
		name = "?dtor$2@?0??_Endwrite@?$basic_filebuf@DU?$char_traits@D@std@@@std@@IEAA_NXZ@4HA"
		size = 27
		refs = "0011 ??1?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 8D D0 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_82_214_2 {
	meta:
		name = "?dtor$2@?0??_Endwrite@?$basic_filebuf@GU?$char_traits@G@std@@@std@@IEAA_NXZ@4HA"
		size = 27
		refs = "0011 ??1?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 8D D0 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_116_236_3 {
	meta:
		name = "?dtor$2@?0??_Endwrite@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@IEAA_NXZ@4HA"
		size = 27
		refs = "0011 ??1?$_String_iterator@V