private rule architecture {
	meta:
		bits = 32
		endianness = "little"
		architecture = "x86"
	condition:
		true
}

rule file_0_0_0 {
	meta:
		name = "_memset"
		size = 35
	strings:
		$1 = { 8B 54 24 0C 8B 4C 24 04 85 D2 74 47 33 C0 8A 44 24 08 57 8B F9 83 FA 04 72 2D F7 D9 83 E1 03 74 08 2B D1 }
	condition:
		$1
}

rule file_0_2_0 {
	meta:
		name = "dwords"
		size = 26
	strings:
		$1 = { 8B C8 C1 E0 08 03 C1 8B C8 C1 E0 10 03 C1 8B CA 83 E2 03 C1 E9 02 74 06 F3 AB }
	condition:
		$1
}

rule file_1_0_0 {
	meta:
		name = "__mbsicoll"
		size = 64
		refs = "0005 ___mbcodepage 0019 ___mblcid 001f ___crtCompareStringA"
	strings:
		$1 = { 55 8B EC 51 A1 ?? ?? ?? ?? 50 6A FF 8B 4D 0C 51 6A FF 8B 55 08 52 6A 01 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 1C 89 45 FC 83 7D FC 00 75 07 B8 FF FF FF 7F EB 06 8B 45 FC 83 E8 02 8B E5 5D C3 }
	condition:
		$1
}

rule file_2_0_0 {
	meta:
		name = "__execve"
		size = 500
		refs = "0013 __mbsrchr 0041 __mbschr 0057 ??_C@_09HILO@spawnve?4c?$AA@ 0062 _strlen 006e __malloc_dbg 0087 ??_C@_02OFKN@?4?2?$AA@ 0090 _strcpy 00a0 _strcat 00eb __access 0104 _comexecmd 018a _ext_strings 01d0 __free_dbg"
	strings:
		$1 = { 55 8B EC 83 EC 18 8B 45 08 89 45 F0 6A 5C 8B 4D F0 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 6A 2F 8B 55 F0 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 F8 83 7D F8 00 75 7E 83 7D FC 00 75 76 6A 3A 8B 45 F0 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 75 5F 68 E6 00 00 00 68 ?? ?? ?? ?? 6A 02 8B 4D F0 51 E8 ?? ?? ?? ?? 83 C4 04 83 C0 03 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 F0 83 7D F0 00 75 08 83 C8 FF E9 6A 01 00 00 68 ?? ?? ?? ?? 8B 55 F0 52 E8 ?? ?? ?? ?? 83 C4 08 8B 45 08 50 8B 4D F0 51 E8 ?? ?? ?? ?? 83 C4 08 8B 55 F0 83 C2 02 89 55 FC EB 14 83 7D FC 00 74 08 8B 45 F8 3B 45 FC 76 06 8B 4D F8 89 4D FC C7 45 F4 FF FF FF FF 6A 2E 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 E8 83 7D E8 00 74 2F 6A 00 8B 45 F0 50 E8 ?? ?? ?? ?? 83 C4 08 83 F8 FF 74 17 8B 4D 10 51 8B 55 0C 52 8B 45 F0 50 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F4 E9 C4 00 00 00 68 17 01 00 00 68 ?? ?? ?? ?? 6A 02 8B 4D F0 51 E8 ?? ?? ?? ?? 83 C4 04 83 C0 05 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 FC 83 7D FC 00 75 08 83 C8 FF E9 A8 00 00 00 8B 55 F0 52 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4D F0 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 FC 03 D0 89 55 E8 C7 45 EC 03 00 00 00 EB 09 8B 45 EC 83 E8 01 89 45 EC 83 7D EC 00 7C 45 8B 4D EC 8B 14 8D ?? ?? ?? ?? 52 8B 45 E8 50 E8 ?? ?? ?? ?? 83 C4 08 6A 00 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 83 F8 FF 74 19 8B 55 10 52 8B 45 0C 50 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F4 EB 02 EB AC 6A 02 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 08 8B 45 F0 3B 45 08 74 0E 6A 02 8B 4D F0 51 E8 ?? ?? ?? ?? 83 C4 08 8B 45 F4 8B E5 5D C3 }
	condition:
		$1
}

rule file_2_1_0 {
	meta:
		name = "_comexecmd"
		size = 109
		refs = "001b __cenvarg 003a __p_overlay 0040 __dospawn 0051 __free_dbg"
	strings:
		$1 = { 55 8B EC 83 EC 0C 8B 45 08 50 8D 4D F8 51 8D 55 F4 52 8B 45 10 50 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 14 83 F8 FF 75 05 83 C8 FF EB 3D 8B 55 F8 52 8B 45 F4 50 8B 4D 08 51 8B 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 10 89 45 FC 6A 02 8B 45 F4 50 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 4D F8 51 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_583_1_0 {
	meta:
		name = "_wcomexecmd"
		size = 109
		refs = "001b __wcenvarg 003a __p_overlay 0040 __wdospawn 0051 __free_dbg"
	strings:
		$1 = { 55 8B EC 83 EC 0C 8B 45 08 50 8D 4D F8 51 8D 55 F4 52 8B 45 10 50 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 14 83 F8 FF 75 05 83 C8 FF EB 3D 8B 55 F8 52 8B 45 F4 50 8B 4D 08 51 8B 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 10 89 45 FC 6A 02 8B 45 F4 50 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 4D F8 51 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_0_0 {
	meta:
		name = "__cwait"
		size = 174
		refs = "0014 _errno 002c __imp__WaitForSingleObject@8 003e __imp__GetExitCodeProcess@8 0050 __imp__GetLastError@0 006c __doserrno 007a __dosmaperr 0095 __imp__CloseHandle@4"
	strings:
		$1 = { 55 8B EC 83 EC 0C 83 7D 0C FF 74 06 83 7D 0C FE 75 12 C7 05 ?? ?? ?? ?? 0A 00 00 00 83 C8 FF E9 86 00 00 00 6A FF 8B 45 0C 50 FF 15 ?? ?? ?? ?? 85 C0 75 1A 8D 4D F8 51 8B 55 0C 52 FF 15 ?? ?? ?? ?? 85 C0 74 08 8B 45 0C 89 45 F4 EB 41 FF 15 ?? ?? ?? ?? 89 45 FC 83 7D FC 06 75 15 C7 05 ?? ?? ?? ?? 0A 00 00 00 8B 4D FC 89 0D ?? ?? ?? ?? EB 0F FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 C7 45 F4 FF FF FF FF C7 45 F8 FF FF FF FF 8B 55 0C 52 FF 15 ?? ?? ?? ?? 83 7D 08 00 74 08 8B 45 08 8B 4D F8 89 08 8B 45 F4 8B E5 5D C3 }
	condition:
		$1
}

rule file_4_0_0 {
	meta:
		name = "__dup2"
		size = 347
		refs = "000b __nhandle 0020 ___pioinfo 003b _errno 0045 __doserrno 0065 _extend_ioinfo_arrays 00b5 __close 00c8 __imp__GetCurrentProcess@0 00d2 __get_osfhandle 00e3 __imp__DuplicateHandle@28 00ed __imp__GetLastError@0 00ff __set_osfhnd 0118 __dosmaperr"
	strings:
		$1 = { 55 8B EC 83 EC 08 8B 45 08 3B 05 ?? ?? ?? ?? 73 28 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F 8B 04 8D ?? ?? ?? ?? 0F BE 4C D0 04 83 E1 01 85 C9 74 09 81 7D 0C 00 08 00 00 72 1C C7 05 ?? ?? ?? ?? 09 00 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 83 C8 FF E9 02 01 00 00 8B 55 0C 3B 15 ?? ?? ?? ?? 7C 22 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 12 C7 05 ?? ?? ?? ?? 0C 00 00 00 83 C8 FF E9 D5 00 00 00 8B 4D 08 3B 4D 0C 75 07 33 C0 E9 C6 00 00 00 8B 55 0C C1 FA 05 8B 45 0C 83 E0 1F 8B 0C 95 ?? ?? ?? ?? 0F BE 54 C1 04 83 E2 01 85 D2 74 0C 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 04 6A 02 6A 01 6A 00 8D 4D F8 51 FF 15 ?? ?? ?? ?? 50 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 50 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 75 0B FF 15 ?? ?? ?? ?? 89 45 FC EB 17 8B 45 F8 50 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 08 C7 45 FC 00 00 00 00 83 7D FC 00 74 11 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 83 C8 FF EB 33 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F 8B 14 85 ?? ?? ?? ?? 0F BE 44 CA 04 24 EF 8B 4D 0C C1 F9 05 8B 55 0C 83 E2 1F 8B 0C 8D ?? ?? ?? ?? 88 44 D1 04 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_4_1_0 {
	meta:
		name = "_extend_ioinfo_arrays"
		size = 189
		refs = "001d __nhandle 002d ___pioinfo 003a ??_C@_06NGIC@dup2?4c?$AA@ 0046 __malloc_dbg"
	strings:
		$1 = { 55 8B EC 83 EC 08 C7 45 F8 00 00 00 00 EB 09 8B 45 F8 83 C0 01 89 45 F8 8B 4D 08 3B 0D ?? ?? ?? ?? 0F 8C 90 00 00 00 8B 55 F8 83 3C 95 ?? ?? ?? ?? 00 75 7E 68 D3 00 00 00 68 ?? ?? ?? ?? 6A 02 68 00 01 00 00 E8 ?? ?? ?? ?? 83 C4 10 89 45 FC 83 7D FC 00 74 57 8B 45 F8 8B 4D FC 89 0C 85 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 83 C2 20 89 15 ?? ?? ?? ?? EB 09 8B 45 FC 83 C0 08 89 45 FC 8B 4D F8 8B 14 8D ?? ?? ?? ?? 81 C2 00 01 00 00 39 55 FC 73 19 8B 45 FC C6 40 04 00 8B 4D FC C7 01 FF FF FF FF 8B 55 FC C6 42 05 0A EB C9 EB 05 83 C8 FF EB 07 E9 58 FF FF FF 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_5_0_0 {
	meta:
		name = "__EH_prolog"
		size = 31
	strings:
		$1 = { 6A FF 50 64 A1 00 00 00 00 50 8B 44 24 0C 64 89 25 00 00 00 00 89 6C 24 0C 8D 6C 24 0C 50 C3 }
	condition:
		$1
}

rule file_6_0_0 {
	meta:
		name = "__wfindfirst"
		size = 308
		refs = "0016 __imp__FindFirstFileW@8 002b __imp__GetLastError@0 005d $L17305 0064 $L17306 006a _errno 00b4 ___timet_from_ft 0106 _wcscpy 0117 $L17276 011b $L17277 011f $L17278"
	strings:
		$1 = { 55 8B EC 81 EC 5C 02 00 00 8D 85 AC FD FF FF 50 8B 4D 08 51 FF 15 ?? ?? ?? ?? 89 85 A8 FD FF FF 83 BD A8 FD FF FF FF 75 69 FF 15 ?? ?? ?? ?? 89 45 FC 8B 55 FC 89 95 A4 FD FF FF 8B 85 A4 FD FF FF 83 E8 02 89 85 A4 FD FF FF 83 BD A4 FD FF FF 10 77 2D 8B 95 A4 FD FF FF 33 C9 8A 8A ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 02 00 00 00 EB 16 C7 05 ?? ?? ?? ?? 0C 00 00 00 EB 0A C7 05 ?? ?? ?? ?? 16 00 00 00 83 C8 FF E9 81 00 00 00 8B 85 AC FD FF FF 2D 80 00 00 00 F7 D8 1B C0 23 85 AC FD FF FF 8B 4D 0C 89 01 8D 95 B0 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 89 41 04 8D 95 B8 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 89 41 08 8D 95 C0 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 89 41 0C 8B 55 0C 8B 85 CC FD FF FF 89 42 10 8D 8D D8 FD FF FF 51 8B 55 0C 83 C2 14 52 E8 ?? ?? ?? ?? 83 C4 08 8B 85 A8 FD FF FF 8B E5 5D C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 02 02 02 02 01 02 02 02 02 02 02 02 02 02 00 }
	condition:
		$1
}

rule file_6_1_0 {
	meta:
		name = "__wfindnext"
		size = 290
		refs = "0016 __imp__FindNextFileW@8 0020 __imp__GetLastError@0 0052 $L17309 0059 $L17310 005f _errno 00a6 ___timet_from_ft 00f8 _wcscpy 0105 $L17293 0109 $L17294 010d $L17295"
	strings:
		$1 = { 55 8B EC 81 EC 58 02 00 00 8D 85 AC FD FF FF 50 8B 4D 08 51 FF 15 ?? ?? ?? ?? 85 C0 75 66 FF 15 ?? ?? ?? ?? 89 45 FC 8B 55 FC 89 95 A8 FD FF FF 8B 85 A8 FD FF FF 83 E8 02 89 85 A8 FD FF FF 83 BD A8 FD FF FF 10 77 2D 8B 95 A8 FD FF FF 33 C9 8A 8A ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 02 00 00 00 EB 16 C7 05 ?? ?? ?? ?? 0C 00 00 00 EB 0A C7 05 ?? ?? ?? ?? 16 00 00 00 83 C8 FF EB 7D 8B 85 AC FD FF FF 2D 80 00 00 00 F7 D8 1B C0 23 85 AC FD FF FF 8B 4D 0C 89 01 8D 95 B0 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 89 41 04 8D 95 B8 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 89 41 08 8D 95 C0 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 89 41 0C 8B 55 0C 8B 85 CC FD FF FF 89 42 10 8D 8D D8 FD FF FF 51 8B 55 0C 83 C2 14 52 E8 ?? ?? ?? ?? 83 C4 08 33 C0 8B E5 5D C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 02 02 02 02 01 02 02 02 02 02 02 02 02 02 00 }
	condition:
		$1
}

rule file_7_0_0 {
	meta:
		name = "__getdrive"
		size = 89
		refs = "001e __imp__GetCurrentDirectoryA@8 0045 _toupper"
	strings:
		$1 = { 55 8B EC 81 EC 08 01 00 00 C7 45 FC 00 00 00 00 8D 85 F8 FE FF FF 50 68 04 01 00 00 FF 15 ?? ?? ?? ?? 85 C0 74 2C 8B 8D F9 FE FF FF 81 E1 FF 00 00 00 83 F9 3A 75 1B 8B 95 F8 FE FF FF 81 E2 FF 00 00 00 52 E8 ?? ?? ?? ?? 83 C4 04 83 E8 40 89 45 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_7_1_0 {
	meta:
		name = "__chdrive"
		size = 99
		refs = "0012 _errno 001c __doserrno 0041 __imp__SetCurrentDirectoryA@4 004f __imp__GetLastError@0 0055 __dosmaperr"
	strings:
		$1 = { 55 8B EC 51 83 7D 08 01 7C 06 83 7D 08 1F 7E 19 C7 05 ?? ?? ?? ?? 0D 00 00 00 C7 05 ?? ?? ?? ?? 0F 00 00 00 83 C8 FF EB 36 0F BE 45 08 83 C0 40 88 45 FC C6 45 FD 3A C6 45 FE 00 8D 4D FC 51 FF 15 ?? ?? ?? ?? 85 C0 74 04 33 C0 EB 12 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 83 C8 FF 8B E5 5D C3 }
	condition:
		$1
}

rule file_8_0_0 {
	meta:
		name = "_wcsncat"
		size = 122
	strings:
		$1 = { 55 8B EC 51 8B 45 08 89 45 FC 8B 4D 08 33 D2 66 8B 11 8B 45 08 83 C0 02 89 45 08 85 D2 74 02 EB E9 8B 4D 08 83 E9 02 89 4D 08 8B 55 10 8B 45 10 83 E8 01 89 45 10 85 D2 74 31 8B 4D 08 8B 55 0C 66 8B 02 66 89 01 8B 4D 08 33 D2 66 8B 11 8B 45 08 83 C0 02 89 45 08 8B 4D 0C 83 C1 02 89 4D 0C 85 D2 75 05 8B 45 FC EB 0D EB BF 8B 55 08 66 C7 02 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_10_0_0 {
	meta:
		name = "__execl"
		size = 205
		refs = "000d ??_C@_0BB@COCE@filename?5?$CB?$DN?5NULL?$AA@ 0016 ??_C@_07HEJO@execl?4c?$AA@ 001d __CrtDbgReport 003b ??_C@_0BG@GALO@?$CKfilename?5?$CB?$DN?5_T?$CI?8?20?8?$CJ?$AA@ 0065 ??_C@_0BA@BICO@arglist?5?$CB?$DN?5NULL?$AA@ 0093 ??_C@_0BF@GGKN@?$CKarglist?5?$CB?$DN?5_T?$CI?8?20?8?$CJ?$AA@ 00c1 __execve"
	strings:
		$1 = { 55 8B EC 53 56 57 83 7D 08 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 2F 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D6 8B 4D 08 0F BE 11 85 D2 75 1E 68 ?? ?? ?? ?? 6A 00 6A 30 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D2 83 7D 0C 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 31 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D6 8B 55 0C 0F BE 02 85 C0 75 1E 68 ?? ?? ?? ?? 6A 00 6A 32 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D2 6A 00 8D 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_11_0_0 {
	meta:
		name = "__openfile"
		size = 911
		refs = "000a __commode 0026 ??_C@_0BB@COCE@filename?5?$CB?$DN?5NULL?$AA@ 002f ??_C@_07INLA@_open?4c?$AA@ 0036 __CrtDbgReport 0050 ??_C@_0N@BKPP@mode?5?$CB?$DN?5NULL?$AA@ 007a ??_C@_0M@KJPK@str?5?$CB?$DN?5NULL?$AA@ 0140 $L1501 0147 $L1502 02b1 __sopen 02c7 __cflush 031d $L1462 0321 $L1486 0325 $L1480 0329 $L1477 032d $L1483 0331 $L1465 0335 $L1471 0339 $L1474 033d $L1468 0341 $L1489"
	strings:
		$1 = { 55 8B EC 83 EC 24 53 56 57 A1 ?? ?? ?? ?? 89 45 E4 C7 45 E8 00 00 00 00 C7 45 F0 00 00 00 00 83 7D 08 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 47 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D6 83 7D 0C 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 48 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 D2 85 D2 75 D6 83 7D 14 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 49 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D6 8B 4D 0C 8A 11 88 55 E0 80 7D E0 61 74 31 80 7D E0 72 74 08 80 7D E0 77 74 13 EB 35 C7 45 EC 00 00 00 00 8B 45 E4 0C 01 89 45 E4 EB 2B C7 45 EC 01 03 00 00 8B 4D E4 83 C9 02 89 4D E4 EB 19 C7 45 EC 09 01 00 00 8B 55 E4 83 CA 02 89 55 E4 EB 07 33 C0 E9 21 02 00 00 C7 45 FC 01 00 00 00 8B 45 0C 83 C0 01 89 45 0C 8B 4D 0C 0F BE 11 85 D2 0F 84 8C 01 00 00 83 7D FC 00 0F 84 82 01 00 00 8B 45 0C 0F BE 08 89 4D DC 8B 55 DC 83 EA 2B 89 55 DC 83 7D DC 49 0F 87 5A 01 00 00 8B 4D DC 33 C0 8A 81 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 8B 55 EC 83 E2 02 85 D2 74 09 C7 45 FC 00 00 00 00 EB 22 8B 45 EC 0C 02 89 45 EC 8B 4D EC 83 E1 FE 89 4D EC 8B 55 E4 80 CA 80 89 55 E4 8B 45 E4 24 FC 89 45 E4 E9 15 01 00 00 8B 4D EC 81 E1 00 C0 00 00 85 C9 74 09 C7 45 FC 00 00 00 00 EB 09 8B 55 EC 80 CE 80 89 55 EC E9 F1 00 00 00 8B 45 EC 25 00 C0 00 00 85 C0 74 09 C7 45 FC 00 00 00 00 EB 09 8B 4D EC 80 CD 40 89 4D EC E9 CE 00 00 00 83 7D E8 00 74 09 C7 45 FC 00 00 00 00 EB 10 C7 45 E8 01 00 00 00 8B 55 E4 80 CE 40 89 55 E4 E9 AA 00 00 00 83 7D E8 00 74 09 C7 45 FC 00 00 00 00 EB 10 C7 45 E8 01 00 00 00 8B 45 E4 80 E4 BF 89 45 E4 E9 86 00 00 00 83 7D F0 00 74 09 C7 45 FC 00 00 00 00 EB 10 C7 45 F0 01 00 00 00 8B 4D EC 83 C9 20 89 4D EC EB 65 83 7D F0 00 74 09 C7 45 FC 00 00 00 00 EB 10 C7 45 F0 01 00 00 00 8B 55 EC 83 CA 10 89 55 EC EB 44 8B 45 EC 25 00 10 00 00 85 C0 74 09 C7 45 FC 00 00 00 00 EB 09 8B 4D EC 80 CD 10 89 4D EC EB 24 8B 55 EC 83 E2 40 85 D2 74 09 C7 45 FC 00 00 00 00 EB 08 8B 45 EC 0C 40 89 45 EC EB 07 C7 45 FC 00 00 00 00 E9 5D FE FF FF 68 A4 01 00 00 8B 4D 10 51 8B 55 EC 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 F8 83 7D F8 00 7D 04 33 C0 EB 51 8B 0D ?? ?? ?? ?? 83 C1 01 89 0D ?? ?? ?? ?? 8B 55 14 89 55 F4 8B 45 F4 8B 4D E4 89 48 0C 8B 55 F4 C7 42 04 00 00 00 00 8B 45 F4 C7 00 00 00 00 00 8B 4D F4 C7 41 08 00 00 00 00 8B 55 F4 C7 42 1C 00 00 00 00 8B 45 F4 8B 4D F8 89 48 10 8B 45 F4 5F 5E 5B 8B E5 5D C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 09 09 09 09 09 09 09 09 09 09 09 09 09 09 09 09 09 09 09 09 09 09 09 09 01 09 09 09 09 09 09 09 09 09 09 09 09 09 02 03 04 09 09 09 09 09 09 09 09 09 09 09 09 09 05 06 09 09 09 09 09 09 09 09 09 09 07 09 09 09 09 09 08 }
	condition:
		$1
}

rule file_12_0_0 {
	meta:
		name = "_strxfrm"
		size = 179
		refs = "000f ___lc_handle 0018 ___lc_codepage 002c _strncpy 0038 _strlen 0045 ___lc_collate_cp 0060 ___crtLCMapStringA"
	strings:
		$1 = { 55 8B EC 83 EC 08 C7 45 F8 FF FF FF 7F 83 3D ?? ?? ?? ?? 00 75 2B 83 3D ?? ?? ?? ?? 00 75 22 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 04 EB 6E 6A 01 8B 0D ?? ?? ?? ?? 51 6A 00 6A 00 6A FF 8B 55 0C 52 68 00 04 00 00 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 20 89 45 FC 83 7D FC 00 75 02 EB 3A 8B 4D FC 89 4D F8 8B 55 FC 3B 55 10 7E 02 EB 2A 6A 01 A1 ?? ?? ?? ?? 50 8B 4D 10 51 8B 55 08 52 6A FF 8B 45 0C 50 68 00 04 00 00 8B 0D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 20 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_13_0_0 {
	meta:
		name = "__wexecvp"
		size = 23
		refs = "000e __wexecvpe"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_434_0_0 {
	meta:
		name = "__execvp"
		size = 23
		refs = "000e __execvpe"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_14_0_0 {
	meta:
		name = "__setargv"
		size = 216
		refs = "0008 ___mbctype_initialized 0010 ___initmbctable 001a _?_pgmname@?1??_setargv@@9@9 0022 __imp__GetModuleFileNameA@12 0028 __pgmptr 0031 __acmdln 0066 _parse_cmdline 0073 ??_C@_09MPMN@stdargv?4c?$AA@ 0084 __malloc_dbg 0097 __amsg_exit 00c7 ___argc 00d0 ___argv"
	strings:
		$1 = { 55 8B EC 83 EC 14 83 3D ?? ?? ?? ?? 00 75 05 E8 ?? ?? ?? ?? 68 04 01 00 00 68 ?? ?? ?? ?? 6A 00 FF 15 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? A1 ?? ?? ?? ?? 0F BE 08 85 C9 75 0B 8B 15 ?? ?? ?? ?? 89 55 EC EB 08 A1 ?? ?? ?? ?? 89 45 EC 8B 4D EC 89 4D F0 8D 55 FC 52 8D 45 F4 50 6A 00 6A 00 8B 4D F0 51 E8 ?? ?? ?? ?? 83 C4 14 68 80 00 00 00 68 ?? ?? ?? ?? 6A 02 8B 55 F4 8B 45 FC 8D 0C 90 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 F8 83 7D F8 00 75 0A 6A 08 E8 ?? ?? ?? ?? 83 C4 04 8D 55 FC 52 8D 45 F4 50 8B 4D F4 8B 55 F8 8D 04 8A 50 8B 4D F8 51 8B 55 F0 52 E8 ?? ?? ?? ?? 83 C4 14 8B 45 F4 83 E8 01 A3 ?? ?? ?? ?? 8B 4D F8 89 0D ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_14_1_0 {
	meta:
		name = "_parse_cmdline"
		size = 1060
		refs = "006d __mbctype"
	strings:
		$1 = { 55 8B EC 83 EC 14 8B 45 18 C7 00 00 00 00 00 8B 4D 14 C7 01 01 00 00 00 8B 55 08 89 55 FC 83 7D 0C 00 74 11 8B 45 0C 8B 4D 10 89 08 8B 55 0C 83 C2 04 89 55 0C 8B 45 FC 0F BE 08 83 F9 22 0F 85 C9 00 00 00 8B 55 FC 83 C2 01 89 55 FC 8B 45 FC 0F BE 08 83 F9 22 74 7A 8B 55 FC 0F BE 02 85 C0 74 70 8B 4D FC 33 D2 8A 11 33 C0 8A 82 ?? ?? ?? ?? 83 E0 04 85 C0 74 2F 8B 4D 18 8B 11 83 C2 01 8B 45 18 89 10 83 7D 10 00 74 1C 8B 4D 10 8B 55 FC 8A 02 88 01 8B 4D 10 83 C1 01 89 4D 10 8B 55 FC 83 C2 01 89 55 FC 8B 45 18 8B 08 83 C1 01 8B 55 18 89 0A 83 7D 10 00 74 13 8B 45 10 8B 4D FC 8A 11 88 10 8B 45 10 83 C0 01 89 45 10 E9 72 FF FF FF 8B 4D 18 8B 11 83 C2 01 8B 45 18 89 10 83 7D 10 00 74 0F 8B 4D 10 C6 01 00 8B 55 10 83 C2 01 89 55 10 8B 45 FC 0F BE 08 83 F9 22 75 09 8B 55 FC 83 C2 01 89 55 FC E9 CF 00 00 00 8B 45 18 8B 08 83 C1 01 8B 55 18 89 0A 83 7D 10 00 74 13 8B 45 10 8B 4D FC 8A 11 88 10 8B 45 10 83 C0 01 89 45 10 8B 4D FC 8A 11 88 55 F4 8B 45 FC 83 C0 01 89 45 FC 8B 4D F4 81 E1 FF 00 00 00 33 D2 8A 91 ?? ?? ?? ?? 83 E2 04 85 D2 74 2F 8B 45 18 8B 08 83 C1 01 8B 55 18 89 0A 83 7D 10 00 74 13 8B 45 10 8B 4D FC 8A 11 88 10 8B 45 10 83 C0 01 89 45 10 8B 4D FC 83 C1 01 89 4D FC 8B 55 F4 81 E2 FF 00 00 00 83 FA 20 74 1E 8B 45 F4 25 FF 00 00 00 85 C0 74 12 8B 4D F4 81 E1 FF 00 00 00 83 F9 09 0F 85 56 FF FF FF 8B 55 F4 81 E2 FF 00 00 00 85 D2 75 0B 8B 45 FC 83 E8 01 89 45 FC EB 0D 83 7D 10 00 74 07 8B 4D 10 C6 41 FF 00 C7 45 EC 00 00 00 00 8B 55 FC 0F BE 02 85 C0 74 21 8B 4D FC 0F BE 11 83 FA 20 74 0B 8B 45 FC 0F BE 08 83 F9 09 75 0B 8B 55 FC 83 C2 01 89 55 FC EB DF 8B 45 FC 0F BE 08 85 C9 75 05 E9 DE 01 00 00 83 7D 0C 00 74 11 8B 55 0C 8B 45 10 89 02 8B 4D 0C 83 C1 04 89 4D 0C 8B 55 14 8B 02 83 C0 01 8B 4D 14 89 01 C7 45 F8 01 00 00 00 C7 45 F0 00 00 00 00 8B 55 FC 0F BE 02 83 F8 5C 75 14 8B 4D FC 83 C1 01 89 4D FC 8B 55 F0 83 C2 01 89 55 F0 EB E1 8B 45 FC 0F BE 08 83 F9 22 75 51 8B 45 F0 33 D2 B9 02 00 00 00 F7 F1 85 D2 75 39 83 7D EC 00 74 20 8B 55 FC 0F BE 42 01 83 F8 22 75 0B 8B 4D FC 83 C1 01 89 4D FC EB 07 C7 45 F8 00 00 00 00 EB 07 C7 45 F8 00 00 00 00 33 D2 83 7D EC 00 0F 94 C2 89 55 EC 8B 45 F0 D1 E8 89 45 F0 8B 4D F0 8B 55 F0 83 EA 01 89 55 F0 85 C9 74 24 83 7D 10 00 74 0F 8B 45 10 C6 00 5C 8B 4D 10 83 C1 01 89 4D 10 8B 55 18 8B 02 83 C0 01 8B 4D 18 89 01 EB CC 8B 55 FC 0F BE 02 85 C0 74 1C 83 7D EC 00 75 1B 8B 4D FC 0F BE 11 83 FA 20 74 0B 8B 45 FC 0F BE 08 83 F9 09 75 05 E9 AB 00 00 00 83 7D F8 00 0F 84 93 00 00 00 83 7D 10 00 74 54 8B 55 FC 33 C0 8A 02 33 C9 8A 88 ?? ?? ?? ?? 83 E1 04 85 C9 74 29 8B 55 10 8B 45 FC 8A 08 88 0A 8B 55 10 83 C2 01 89 55 10 8B 45 FC 83 C0 01 89 45 FC 8B 4D 18 8B 11 83 C2 01 8B 45 18 89 10 8B 4D 10 8B 55 FC 8A 02 88 01 8B 4D 10 83 C1 01 89 4D 10 EB 2C 8B 55 FC 33 C0 8A 02 33 C9 8A 88 ?? ?? ?? ?? 83 E1 04 85 C9 74 16 8B 55 FC 83 C2 01 89 55 FC 8B 45 18 8B 08 83 C1 01 8B 55 18 89 0A 8B 45 18 8B 08 83 C1 01 8B 55 18 89 0A 8B 45 FC 83 C0 01 89 45 FC E9 6D FE FF FF 83 7D 10 00 74 0F 8B 4D 10 C6 01 00 8B 55 10 83 C2 01 89 55 10 8B 45 18 8B 08 83 C1 01 8B 55 18 89 0A E9 E8 FD FF FF 83 7D 0C 00 74 12 8B 45 0C C7 00 00 00 00 00 8B 4D 0C 83 C1 04 89 4D 0C 8B 55 14 8B 02 83 C0 01 8B 4D 14 89 01 8B E5 5D C3 }
	condition:
		$1
}

rule file_15_0_0 {
	meta:
		name = "_strcpy"
		size = 16
		altNames = "__mbscpy"
	strings:
		$1 = { 57 8B 7C 24 08 EB 6A 8D A4 24 00 00 00 00 8B FF }
	condition:
		$1
}

rule file_15_3_0 {
	meta:
		name = "find_end_of_dest_string_loop"
		size = 51
	strings:
		$1 = { 8B 01 BA FF FE FE 7E 03 D0 83 F0 FF 33 C2 83 C1 04 A9 00 01 01 81 74 E8 8B 41 FC 84 C0 74 23 84 E4 74 1A A9 00 00 FF 00 74 0E A9 00 00 00 FF 74 02 EB CD }
	condition:
		$1
}

rule file_15_9_0 {
	meta:
		name = "src_misaligned"
		size = 20
	strings:
		$1 = { 8A 11 41 84 D2 74 64 88 17 47 F7 C1 03 00 00 00 75 EE EB 05 }
	condition:
		$1
}

rule file_15_11_0 {
	meta:
		name = "main_loop_entrance"
		size = 52
	strings:
		$1 = { BA FF FE FE 7E 8B 01 03 D0 83 F0 FF 33 C2 8B 11 83 C1 04 A9 00 01 01 81 74 E1 84 D2 74 34 84 F6 74 27 F7 C2 00 00 FF 00 74 12 F7 C2 00 00 00 FF 74 02 EB C7 }
	condition:
		$1
}

rule file_16_0_0 {
	meta:
		name = "___crtLCMapStringA"
		size = 773
		refs = "0006 $T17286 000b __except_handler3 0011 __except_list 0028 _?f_use@?1??__crtLCMapStringA@@9@9 0036 ??_C@_13A@?$AA?$AA?$AA?$AA@ 0043 __imp__LCMapStringW@24 005e ??_C@_01A@?$AA?$AA@ 006b __imp__LCMapStringA@24 0095 _strncnt 00e0 ___lc_codepage 0107 __imp__MultiByteToWideChar@24 012d __alloca_probe 02a7 __imp__WideCharToMultiByte@32"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 C4 DC 53 56 57 89 65 E8 83 3D ?? ?? ?? ?? 00 75 57 6A 00 6A 00 6A 01 68 ?? ?? ?? ?? 68 00 01 00 00 6A 00 FF 15 ?? ?? ?? ?? 85 C0 74 0C C7 05 ?? ?? ?? ?? 01 00 00 00 EB 2F 6A 00 6A 00 6A 01 68 ?? ?? ?? ?? 68 00 01 00 00 6A 00 FF 15 ?? ?? ?? ?? 85 C0 74 0C C7 05 ?? ?? ?? ?? 02 00 00 00 EB 07 33 C0 E9 6B 02 00 00 83 7D 14 00 7E 13 8B 45 14 50 8B 4D 10 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 14 83 3D ?? ?? ?? ?? 02 75 23 8B 55 1C 52 8B 45 18 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 FF 15 ?? ?? ?? ?? E9 26 02 00 00 83 3D ?? ?? ?? ?? 01 0F 85 17 02 00 00 83 7D 20 00 75 09 8B 15 ?? ?? ?? ?? 89 55 20 6A 00 6A 00 8B 45 14 50 8B 4D 10 51 8B 55 24 F7 DA 1B D2 83 E2 08 83 C2 01 52 8B 45 20 50 FF 15 ?? ?? ?? ?? 89 45 E4 83 7D E4 00 75 07 33 C0 E9 D6 01 00 00 C7 45 FC 00 00 00 00 8B 45 E4 D1 E0 83 C0 03 24 FC E8 ?? ?? ?? ?? 89 65 D0 89 65 E8 8B 4D D0 89 4D DC C7 45 FC FF FF FF FF EB 17 B8 01 00 00 00 C3 8B 65 E8 C7 45 DC 00 00 00 00 C7 45 FC FF FF FF FF 83 7D DC 00 75 07 33 C0 E9 87 01 00 00 8B 55 E4 52 8B 45 DC 50 8B 4D 14 51 8B 55 10 52 6A 01 8B 45 20 50 FF 15 ?? ?? ?? ?? 85 C0 75 07 33 C0 E9 60 01 00 00 6A 00 6A 00 8B 4D E4 51 8B 55 DC 52 8B 45 0C 50 8B 4D 08 51 FF 15 ?? ?? ?? ?? 89 45 D8 83 7D D8 00 75 07 33 C0 E9 36 01 00 00 8B 55 0C 81 E2 00 04 00 00 85 D2 74 43 83 7D 1C 00 74 38 8B 45 D8 3B 45 1C 7E 07 33 C0 E9 14 01 00 00 8B 4D 1C 51 8B 55 18 52 8B 45 E4 50 8B 4D DC 51 8B 55 0C 52 8B 45 08 50 FF 15 ?? ?? ?? ?? 85 C0 75 07 33 C0 E9 EB 00 00 00 E9 DF 00 00 00 8B 4D D8 89 4D D4 C7 45 FC 01 00 00 00 8B 45 D4 D1 E0 83 C0 03 24 FC E8 ?? ?? ?? ?? 89 65 CC 89 65 E8 8B 55 CC 89 55 E0 C7 45 FC FF FF FF FF EB 17 B8 01 00 00 00 C3 8B 65 E8 C7 45 E0 00 00 00 00 C7 45 FC FF FF FF FF 83 7D E0 00 75 07 33 C0 E9 91 00 00 00 8B 45 D4 50 8B 4D E0 51 8B 55 E4 52 8B 45 DC 50 8B 4D 0C 51 8B 55 08 52 FF 15 ?? ?? ?? ?? 85 C0 75 04 33 C0 EB 6B 83 7D 1C 00 75 2E 6A 00 6A 00 6A 00 6A 00 8B 45 D4 50 8B 4D E0 51 68 20 02 00 00 8B 55 20 52 FF 15 ?? ?? ?? ?? 89 45 D8 83 7D D8 00 75 04 33 C0 EB 39 EB 30 6A 00 6A 00 8B 45 1C 50 8B 4D 18 51 8B 55 D4 52 8B 45 E0 50 68 20 02 00 00 8B 4D 20 51 FF 15 ?? ?? ?? ?? 89 45 D8 83 7D D8 00 75 04 33 C0 EB 07 8B 45 D8 EB 02 33 C0 8D 65 C0 8B 4D F0 64 89 0D ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_16_1_0 {
	meta:
		name = "_strncnt"
		size = 80
	strings:
		$1 = { 55 8B EC 83 EC 08 8B 45 0C 89 45 F8 8B 4D 08 89 4D FC 8B 55 F8 8B 45 F8 83 E8 01 89 45 F8 85 D2 74 15 8B 4D FC 0F BE 11 85 D2 74 0B 8B 45 FC 83 C0 01 89 45 FC EB DB 8B 4D FC 0F BE 11 85 D2 75 08 8B 45 FC 2B 45 08 EB 03 8B 45 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_17_0_0 {
	meta:
		name = "__wcwild"
		size = 441
		refs = "0007 ___wargv 0010 _argend 0020 _arghead 0067 _wadd 007d ??_C@_15IKB@?$AA?$CK?$AA?$DP?$AA?$AA@ 0088 _wcspbrk 00a3 _wmatch 0108 ??_C@_06BDME@wild?4c?$AA@ 011a __malloc_dbg 013f ___argc 01aa __free_dbg"
	strings:
		$1 = { 55 8B EC 83 EC 14 A1 ?? ?? ?? ?? 89 45 F4 C7 05 ?? ?? ?? ?? 00 00 00 00 8B 0D ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 89 55 F4 EB 09 8B 45 F4 83 C0 04 89 45 F4 8B 4D F4 83 39 00 0F 84 93 00 00 00 8B 55 F4 8B 02 33 C9 66 8B 08 8B 55 F4 8B 02 83 C0 02 8B 55 F4 89 02 83 F9 22 75 1C 8B 45 F4 8B 08 51 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 08 83 C8 FF E9 3B 01 00 00 EB 56 68 ?? ?? ?? ?? 8B 55 F4 8B 02 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 F0 83 7D F0 00 74 20 8B 4D F0 51 8B 55 F4 8B 02 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 08 83 C8 FF E9 FF 00 00 00 EB 1A 8B 4D F4 8B 11 52 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 08 83 C8 FF E9 E3 00 00 00 E9 58 FF FF FF C7 45 FC 00 00 00 00 A1 ?? ?? ?? ?? 89 45 EC EB 12 8B 4D EC 8B 51 04 89 55 EC 8B 45 FC 83 C0 01 89 45 FC 83 7D EC 00 74 02 EB E6 68 AB 00 00 00 68 ?? ?? ?? ?? 6A 02 8B 4D FC 8D 14 8D 04 00 00 00 52 E8 ?? ?? ?? ?? 83 C4 10 89 45 F8 83 7D F8 00 75 08 83 C8 FF E9 83 00 00 00 8B 45 F8 A3 ?? ?? ?? ?? 8B 4D FC 89 0D ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 89 55 EC EB 09 8B 45 EC 8B 48 04 89 4D EC 83 7D EC 00 74 15 8B 55 F8 8B 45 EC 8B 08 89 0A 8B 55 F8 83 C2 04 89 55 F8 EB DC 8B 45 F8 C7 00 00 00 00 00 8B 0D ?? ?? ?? ?? 89 4D EC EB 09 8B 15 ?? ?? ?? ?? 89 55 EC 83 7D EC 00 74 1E A1 ?? ?? ?? ?? 8B 48 04 89 0D ?? ?? ?? ?? 6A 02 8B 55 EC 52 E8 ?? ?? ?? ?? 83 C4 08 EB D3 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_17_1_0 {
	meta:
		name = "_wmatch"
		size = 591
		refs = "006b _wadd 00b1 _wfind 00c7 _argend 00cf ??_C@_13DOBH@?$AA?4?$AA?$AA@ 00d8 _wcscmp 00e8 ??_C@_15PLEI@?$AA?4?$AA?4?$AA?$AA@ 012d ??_C@_06BDME@wild?4c?$AA@ 0138 _wcslen 0145 __malloc_dbg 015e _wcscpy 01c0 _wcsncpy 0228 _arghead 0234 _wsort"
	strings:
		$1 = { 55 8B EC 83 EC 18 C7 45 F0 00 00 00 00 C7 45 EC 00 00 00 00 8B 45 0C 3B 45 08 74 32 8B 4D 0C 33 D2 66 8B 11 83 FA 5C 74 25 8B 45 0C 33 C9 66 8B 08 83 F9 2F 74 18 8B 55 0C 33 C0 66 8B 02 83 F8 3A 74 0B 8B 4D 0C 83 E9 02 89 4D 0C EB C6 8B 55 0C 33 C0 66 8B 02 83 F8 3A 75 1C 8B 4D 08 83 C1 02 39 4D 0C 74 11 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 E9 D4 01 00 00 8B 45 0C 33 C9 66 8B 08 83 F9 5C 74 1A 8B 55 0C 33 C0 66 8B 02 83 F8 2F 74 0D 8B 4D 0C 33 D2 66 8B 11 83 FA 3A 75 0E 8B 45 0C 2B 45 08 D1 F8 83 C0 01 89 45 F0 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 F4 83 7D F4 00 0F 84 7A 01 00 00 8B 15 ?? ?? ?? ?? 89 55 FC 68 ?? ?? ?? ?? 8B 45 F4 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 0F 84 11 01 00 00 68 ?? ?? ?? ?? 8B 4D F4 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 0F 84 F8 00 00 00 8B 55 0C 33 C0 66 8B 02 83 F8 5C 74 6F 8B 4D 0C 33 D2 66 8B 11 83 FA 3A 74 62 8B 45 0C 33 C9 66 8B 08 83 F9 2F 74 55 68 01 01 00 00 68 ?? ?? ?? ?? 6A 02 8B 55 F4 52 E8 ?? ?? ?? ?? 83 C4 04 8D 44 00 02 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 08 83 7D 08 00 74 1D 8B 4D F4 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 08 83 C8 FF E9 D1 00 00 00 EB 73 68 09 01 00 00 68 ?? ?? ?? ?? 6A 02 8B 45 F4 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D F0 03 C8 8D 54 09 02 52 E8 ?? ?? ?? ?? 83 C4 10 89 45 F8 83 7D F8 00 74 3B 8B 45 F4 50 8B 4D F0 51 8B 55 08 52 8B 45 F8 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D F0 8D 14 48 52 E8 ?? ?? ?? ?? 83 C4 08 8B 4D F0 D1 E1 2B C1 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 05 83 C8 FF EB 5C 8B 55 EC 83 C2 01 89 55 EC 6A 00 E8 ?? ?? ?? ?? 83 C4 04 89 45 F4 83 7D F4 00 0F 85 BF FE FF FF 83 7D EC 00 74 2A 83 7D FC 00 74 0B 8B 45 FC 8B 48 04 89 4D E8 EB 09 8B 15 ?? ?? ?? ?? 89 55 E8 8B 45 E8 50 E8 ?? ?? ?? ?? 83 C4 04 33 C0 EB 0C 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_17_2_0 {
	meta:
		name = "_wadd"
		size = 103
		refs = "000a ??_C@_06BDME@wild?4c?$AA@ 0013 __malloc_dbg 003c _arghead 0044 _argend"
		altNames = "_add"
	strings:
		$1 = { 55 8B EC 51 68 34 01 00 00 68 ?? ?? ?? ?? 6A 02 6A 08 E8 ?? ?? ?? ?? 83 C4 10 89 45 FC 83 7D FC 00 75 05 83 C8 FF EB 3B 8B 45 FC 8B 4D 08 89 08 8B 55 FC C7 42 04 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 0D A1 ?? ?? ?? ?? 8B 4D FC 89 48 04 EB 09 8B 55 FC 89 15 ?? ?? ?? ?? 8B 45 FC A3 ?? ?? ?? ?? 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_17_3_0 {
	meta:
		name = "_wsort"
		size = 107
		refs = "0028 __wcsicmp"
	strings:
		$1 = { 55 8B EC 83 EC 08 83 7D 08 00 74 5B 8B 45 08 8B 48 04 89 4D F8 83 7D F8 00 74 4C 8B 55 08 8B 02 50 8B 4D F8 8B 11 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 7D 1A 8B 45 08 8B 08 89 4D FC 8B 55 08 8B 45 F8 8B 08 89 0A 8B 55 F8 8B 45 FC 89 02 8B 4D F8 8B 51 04 89 55 F8 83 7D F8 00 75 BF 8B 45 08 8B 48 04 89 4D 08 EB A5 8B E5 5D C3 }
	condition:
		$1
}

rule file_25_3_0 {
	meta:
		name = "_sort"
		size = 107
		refs = "0028 __mbsicmp"
	strings:
		$1 = { 55 8B EC 83 EC 08 83 7D 08 00 74 5B 8B 45 08 8B 48 04 89 4D F8 83 7D F8 00 74 4C 8B 55 08 8B 02 50 8B 4D F8 8B 11 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 7D 1A 8B 45 08 8B 08 89 4D FC 8B 55 08 8B 45 F8 8B 08 89 0A 8B 55 F8 8B 45 FC 89 02 8B 4D F8 8B 51 04 89 55 F8 83 7D F8 00 75 BF 8B 45 08 8B 48 04 89 4D 08 EB A5 8B E5 5D C3 }
	condition:
		$1
}

rule file_17_4_0 {
	meta:
		name = "_wfind"
		size = 185
		refs = "000c _?findbuf@?1??wfind@@9@9 0019 ??_C@_06BDME@wild?4c?$AA@ 0025 __malloc_dbg 0033 _?_WildFindHandle@?1??wfind@@9@9 0042 __imp__FindClose@4 005d __imp__FindFirstFileW@8 0084 __imp__FindNextFileW@8"
	strings:
		$1 = { 55 8B EC 51 83 7D 08 00 74 6B 83 3D ?? ?? ?? ?? 00 75 1E 68 8F 01 00 00 68 ?? ?? ?? ?? 6A 02 68 54 03 00 00 E8 ?? ?? ?? ?? 83 C4 10 A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 74 16 A1 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 00 00 00 00 8B 0D ?? ?? ?? ?? 51 8B 55 08 52 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? FF 75 04 33 C0 EB 42 EB 32 A1 ?? ?? ?? ?? 50 8B 0D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 85 C0 75 1B 8B 15 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 00 00 00 00 33 C0 EB 0E A1 ?? ?? ?? ?? 83 C0 2C 89 45 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_19_0_0 {
	meta:
		name = "__findfirsti64"
		size = 338
		refs = "0017 __imp__FindFirstFileA@8 002c __imp__GetLastError@0 005e $L17136 0065 $L17137 006b _errno 00b5 ___timet_from_ft 00fb __allmul 0123 _strcpy 0135 $L17102 0139 $L17103 013d $L17104"
	strings:
		$1 = { 55 8B EC 81 EC 4C 01 00 00 56 8D 85 BC FE FF FF 50 8B 4D 08 51 FF 15 ?? ?? ?? ?? 89 85 B8 FE FF FF 83 BD B8 FE FF FF FF 75 69 FF 15 ?? ?? ?? ?? 89 45 FC 8B 55 FC 89 95 B4 FE FF FF 8B 85 B4 FE FF FF 83 E8 02 89 85 B4 FE FF FF 83 BD B4 FE FF FF 10 77 2D 8B 95 B4 FE FF FF 33 C9 8A 8A ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 02 00 00 00 EB 16 C7 05 ?? ?? ?? ?? 0C 00 00 00 EB 0A C7 05 ?? ?? ?? ?? 16 00 00 00 83 C8 FF E9 9D 00 00 00 8B 85 BC FE FF FF 2D 80 00 00 00 F7 D8 1B C0 23 85 BC FE FF FF 8B 4D 0C 89 01 8D 95 C0 FE FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 89 41 04 8D 95 C8 FE FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 89 41 08 8D 95 D0 FE FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 89 41 0C 8B 95 D8 FE FF FF 33 C0 6A 01 6A 00 50 52 E8 ?? ?? ?? ?? 8B 8D DC FE FF FF 33 F6 03 C1 13 D6 8B 4D 0C 89 41 10 89 51 14 8D 95 E8 FE FF FF 52 8B 45 0C 83 C0 18 50 E8 ?? ?? ?? ?? 83 C4 08 8B 85 B8 FE FF FF 5E 8B E5 5D C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 02 02 02 02 01 02 02 02 02 02 02 02 02 02 00 }
	condition:
		$1
}

rule file_19_1_0 {
	meta:
		name = "__findnexti64"
		size = 323
		refs = "0017 __imp__FindNextFileA@8 0021 __imp__GetLastError@0 0053 $L17140 005a $L17141 0060 _errno 00aa ___timet_from_ft 00f0 __allmul 0118 _strcpy 0126 $L17121 012a $L17122 012e $L17123"
	strings:
		$1 = { 55 8B EC 81 EC 48 01 00 00 56 8D 85 BC FE FF FF 50 8B 4D 08 51 FF 15 ?? ?? ?? ?? 85 C0 75 69 FF 15 ?? ?? ?? ?? 89 45 FC 8B 55 FC 89 95 B8 FE FF FF 8B 85 B8 FE FF FF 83 E8 02 89 85 B8 FE FF FF 83 BD B8 FE FF FF 10 77 2D 8B 95 B8 FE FF FF 33 C9 8A 8A ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 02 00 00 00 EB 16 C7 05 ?? ?? ?? ?? 0C 00 00 00 EB 0A C7 05 ?? ?? ?? ?? 16 00 00 00 83 C8 FF E9 99 00 00 00 8B 85 BC FE FF FF 2D 80 00 00 00 F7 D8 1B C0 23 85 BC FE FF FF 8B 4D 0C 89 01 8D 95 C0 FE FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 89 41 04 8D 95 C8 FE FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 89 41 08 8D 95 D0 FE FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 89 41 0C 8B 95 D8 FE FF FF 33 C0 6A 01 6A 00 50 52 E8 ?? ?? ?? ?? 8B 8D DC FE FF FF 33 F6 03 C1 13 D6 8B 4D 0C 89 41 10 89 51 14 8D 95 E8 FE FF FF 52 8B 45 0C 83 C0 18 50 E8 ?? ?? ?? ?? 83 C4 08 33 C0 5E 8B E5 5D C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 02 02 02 02 01 02 02 02 02 02 02 02 02 02 00 }
	condition:
		$1
}

rule file_20_0_0 {
	meta:
		name = "__allshl"
		size = 16
	strings:
		$1 = { 80 F9 40 73 15 80 F9 20 73 06 0F A5 C2 D3 E0 C3 }
	condition:
		$1
}

rule file_21_1_0 {
	meta:
		name = "_toupper"
		size = 299
		refs = "0008 ___lc_handle 0037 ___mb_cur_max 0045 __isctype 0055 __pctype 00ec ___crtLCMapStringA"
	strings:
		$1 = { 55 8B EC 83 EC 10 83 3D ?? ?? ?? ?? 00 75 1D 83 7D 08 61 7C 0F 83 7D 08 7A 7F 09 8B 45 08 83 E8 20 89 45 08 8B 45 08 E9 FB 00 00 00 81 7D 08 00 01 00 00 7D 3E 83 3D ?? ?? ?? ?? 01 7E 13 6A 02 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 F0 EB 14 8B 55 08 A1 ?? ?? ?? ?? 33 C9 66 8B 0C 50 83 E1 02 89 4D F0 83 7D F0 00 75 08 8B 45 08 E9 B4 00 00 00 8B 55 08 C1 FA 08 81 E2 FF 00 00 00 81 E2 FF 00 00 00 A1 ?? ?? ?? ?? 33 C9 66 8B 0C 50 81 E1 00 80 00 00 85 C9 74 22 8B 55 08 C1 FA 08 81 E2 FF 00 00 00 88 55 F8 8A 45 08 88 45 F9 C6 45 FA 00 C7 45 FC 02 00 00 00 EB 11 8A 4D 08 88 4D F8 C6 45 F9 00 C7 45 FC 01 00 00 00 6A 01 6A 00 6A 03 8D 55 F4 52 8B 45 FC 50 8D 4D F8 51 68 00 02 00 00 8B 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 20 89 45 FC 83 7D FC 00 75 05 8B 45 08 EB 26 83 7D FC 01 75 0A 8B 45 F4 25 FF 00 00 00 EB 16 8B 45 F4 25 FF 00 00 00 8B 4D F5 81 E1 FF 00 00 00 C1 E1 08 0B C1 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_0_0 {
	meta:
		name = "_fgetc"
		size = 138
		refs = "0010 ??_C@_0P@FHEA@stream?5?$CB?$DN?5NULL?$AA@ 0019 ??_C@_07JJAI@fgetc?4c?$AA@ 0020 __CrtDbgReport 0070 __filbuf"
	strings:
		$1 = { 55 8B EC 83 EC 08 53 56 57 83 7D 08 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 29 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D6 8B 4D 08 8B 51 04 83 EA 01 8B 45 08 89 50 04 8B 4D 08 83 79 04 00 7C 20 8B 55 08 8B 02 0F BE 08 81 E1 FF 00 00 00 89 4D F8 8B 55 08 8B 02 83 C0 01 8B 4D 08 89 01 EB 0F 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 F8 8B 45 F8 89 45 FC 8B 45 FC 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_1_0 {
	meta:
		name = "_getc"
		size = 17
		refs = "0008 _fgetc"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_414_2_0 {
	meta:
		name = "__inc"
		size = 17
		refs = "0008 _fgetwc"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_207_1_0 {
	meta:
		name = "__unlink"
		size = 17
		refs = "0008 _remove"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_24_1_0 {
	meta:
		name = "__wunlink"
		size = 17
		refs = "0008 __wremove"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_600_1_0 {
	meta:
		name = "_atoi"
		size = 17
		refs = "0008 _atol"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_290_1_0 {
	meta:
		name = "_getwc"
		size = 17
		refs = "0008 _fgetwc"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_310_1_0 {
	meta:
		name = "_putchar"
		size = 17
		refs = "0008 __fputchar"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_23_1_0 {
	meta:
		name = "__unloaddll"
		size = 29
		refs = "0009 __imp__FreeLibrary@4 0013 __imp__GetLastError@0"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 FF 15 ?? ?? ?? ?? 85 C0 75 08 FF 15 ?? ?? ?? ?? EB 02 33 C0 5D C3 }
	condition:
		$1
}

rule file_24_0_0 {
	meta:
		name = "__wremove"
		size = 65
		refs = "000a __imp__DeleteFileW@4 0014 __imp__GetLastError@0 002f __dosmaperr"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 50 FF 15 ?? ?? ?? ?? 85 C0 75 0B FF 15 ?? ?? ?? ?? 89 45 FC EB 07 C7 45 FC 00 00 00 00 83 7D FC 00 74 11 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 83 C8 FF EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_632_0_0 {
	meta:
		name = "__rmdir"
		size = 65
		refs = "000a __imp__RemoveDirectoryA@4 0014 __imp__GetLastError@0 002f __dosmaperr"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 50 FF 15 ?? ?? ?? ?? 85 C0 75 0B FF 15 ?? ?? ?? ?? 89 45 FC EB 07 C7 45 FC 00 00 00 00 83 7D FC 00 74 11 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 83 C8 FF EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_611_0_0 {
	meta:
		name = "__wrmdir"
		size = 65
		refs = "000a __imp__RemoveDirectoryW@4 0014 __imp__GetLastError@0 002f __dosmaperr"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 50 FF 15 ?? ?? ?? ?? 85 C0 75 0B FF 15 ?? ?? ?? ?? 89 45 FC EB 07 C7 45 FC 00 00 00 00 83 7D FC 00 74 11 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 83 C8 FF EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_207_0_0 {
	meta:
		name = "_remove"
		size = 65
		refs = "000a __imp__DeleteFileA@4 0014 __imp__GetLastError@0 002f __dosmaperr"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 50 FF 15 ?? ?? ?? ?? 85 C0 75 0B FF 15 ?? ?? ?? ?? 89 45 FC EB 07 C7 45 FC 00 00 00 00 83 7D FC 00 74 11 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 83 C8 FF EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_25_0_0 {
	meta:
		name = "__cwild"
		size = 439
		refs = "0007 ___argv 0010 _argend 0020 _arghead 0065 _add 007b ??_C@_02LHJO@?$CK?$DP?$AA@ 0086 __mbspbrk 00a1 _match 0106 ??_C@_06BDME@wild?4c?$AA@ 0118 __malloc_dbg 013d ___argc 01a8 __free_dbg"
	strings:
		$1 = { 55 8B EC 83 EC 14 A1 ?? ?? ?? ?? 89 45 F4 C7 05 ?? ?? ?? ?? 00 00 00 00 8B 0D ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 89 55 F4 EB 09 8B 45 F4 83 C0 04 89 45 F4 8B 4D F4 83 39 00 0F 84 91 00 00 00 8B 55 F4 8B 02 0F BE 08 8B 55 F4 8B 02 83 C0 01 8B 55 F4 89 02 83 F9 22 75 1C 8B 45 F4 8B 08 51 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 08 83 C8 FF E9 3B 01 00 00 EB 56 68 ?? ?? ?? ?? 8B 55 F4 8B 02 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 F0 83 7D F0 00 74 20 8B 4D F0 51 8B 55 F4 8B 02 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 08 83 C8 FF E9 FF 00 00 00 EB 1A 8B 4D F4 8B 11 52 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 08 83 C8 FF E9 E3 00 00 00 E9 5A FF FF FF C7 45 FC 00 00 00 00 A1 ?? ?? ?? ?? 89 45 EC EB 12 8B 4D EC 8B 51 04 89 55 EC 8B 45 FC 83 C0 01 89 45 FC 83 7D EC 00 74 02 EB E6 68 AB 00 00 00 68 ?? ?? ?? ?? 6A 02 8B 4D FC 8D 14 8D 04 00 00 00 52 E8 ?? ?? ?? ?? 83 C4 10 89 45 F8 83 7D F8 00 75 08 83 C8 FF E9 83 00 00 00 8B 45 F8 A3 ?? ?? ?? ?? 8B 4D FC 89 0D ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 89 55 EC EB 09 8B 45 EC 8B 48 04 89 4D EC 83 7D EC 00 74 15 8B 55 F8 8B 45 EC 8B 08 89 0A 8B 55 F8 83 C2 04 89 55 F8 EB DC 8B 45 F8 C7 00 00 00 00 00 8B 0D ?? ?? ?? ?? 89 4D EC EB 09 8B 15 ?? ?? ?? ?? 89 55 EC 83 7D EC 00 74 1E A1 ?? ?? ?? ?? 8B 48 04 89 0D ?? ?? ?? ?? 6A 02 8B 55 EC 52 E8 ?? ?? ?? ?? 83 C4 08 EB D3 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_25_1_0 {
	meta:
		name = "_match"
		size = 589
		refs = "005a __mbsdec 0081 _add 00bf _find 00d5 _argend 00dd ??_C@_01PJCK@?4?$AA@ 00e6 __mbscmp 00f6 ??_C@_02OOND@?4?4?$AA@ 0135 ??_C@_06BDME@wild?4c?$AA@ 0140 _strlen 014c __malloc_dbg 0165 _strcpy 01c5 __mbsnbcpy 0226 _arghead 0232 _sort"
	strings:
		$1 = { 55 8B EC 83 EC 18 C7 45 F0 00 00 00 00 C7 45 EC 00 00 00 00 8B 45 0C 3B 45 08 74 4A 8B 4D 0C 0F BE 11 83 FA 5C 74 3F 8B 45 0C 0F BE 08 83 F9 2F 74 34 8B 55 0C 0F BE 02 83 F8 3A 74 29 8B 4D 0C 83 E9 01 89 4D 0C 8B 55 0C 3B 55 08 76 16 8B 45 0C 83 C0 01 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 0C EB AE 8B 55 0C 0F BE 02 83 F8 3A 75 1C 8B 4D 08 83 C1 01 39 4D 0C 74 11 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 E9 BC 01 00 00 8B 45 0C 0F BE 08 83 F9 5C 74 16 8B 55 0C 0F BE 02 83 F8 2F 74 0B 8B 4D 0C 0F BE 11 83 FA 3A 75 0C 8B 45 0C 2B 45 08 83 C0 01 89 45 F0 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 F4 83 7D F4 00 0F 84 6A 01 00 00 8B 15 ?? ?? ?? ?? 89 55 FC 68 ?? ?? ?? ?? 8B 45 F4 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 0F 84 01 01 00 00 68 ?? ?? ?? ?? 8B 4D F4 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 0F 84 E8 00 00 00 8B 55 0C 0F BE 02 83 F8 5C 74 6A 8B 4D 0C 0F BE 11 83 FA 3A 74 5F 8B 45 0C 0F BE 08 83 F9 2F 74 54 68 01 01 00 00 68 ?? ?? ?? ?? 6A 02 8B 55 F4 52 E8 ?? ?? ?? ?? 83 C4 04 83 C0 01 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 08 83 7D 08 00 74 1D 8B 45 F4 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 08 83 C8 FF E9 C8 00 00 00 EB 6A 68 09 01 00 00 68 ?? ?? ?? ?? 6A 02 8B 55 F4 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D F0 8D 54 01 01 52 E8 ?? ?? ?? ?? 83 C4 10 89 45 F8 83 7D F8 00 74 34 8B 45 F4 50 8B 4D F0 51 8B 55 08 52 8B 45 F8 50 E8 ?? ?? ?? ?? 83 C4 0C 03 45 F0 50 E8 ?? ?? ?? ?? 83 C4 08 2B 45 F0 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 05 83 C8 FF EB 5C 8B 4D EC 83 C1 01 89 4D EC 6A 00 E8 ?? ?? ?? ?? 83 C4 04 89 45 F4 83 7D F4 00 0F 85 CF FE FF FF 83 7D EC 00 74 2A 83 7D FC 00 74 0B 8B 55 FC 8B 42 04 89 45 E8 EB 09 8B 0D ?? ?? ?? ?? 89 4D E8 8B 55 E8 52 E8 ?? ?? ?? ?? 83 C4 04 33 C0 EB 0C 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_25_4_0 {
	meta:
		name = "_find"
		size = 185
		refs = "000c _?findbuf@?1??find@@9@9 0019 ??_C@_06BDME@wild?4c?$AA@ 0025 __malloc_dbg 0033 _?_WildFindHandle@?1??find@@9@9 0042 __imp__FindClose@4 005d __imp__FindFirstFileA@8 0084 __imp__FindNextFileA@8"
	strings:
		$1 = { 55 8B EC 51 83 7D 08 00 74 6B 83 3D ?? ?? ?? ?? 00 75 1E 68 8F 01 00 00 68 ?? ?? ?? ?? 6A 02 68 44 02 00 00 E8 ?? ?? ?? ?? 83 C4 10 A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 74 16 A1 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 00 00 00 00 8B 0D ?? ?? ?? ?? 51 8B 55 08 52 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? FF 75 04 33 C0 EB 42 EB 32 A1 ?? ?? ?? ?? 50 8B 0D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 85 C0 75 1B 8B 15 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 00 00 00 00 33 C0 EB 0E A1 ?? ?? ?? ?? 83 C0 2C 89 45 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_26_0_0 {
	meta:
		name = "__mbsstr"
		size = 210
		refs = "0009 ___ismbcodepage 0019 _strstr 0030 _strlen 00bf __mbsinc"
	strings:
		$1 = { 55 8B EC 83 EC 10 56 83 3D ?? ?? ?? ?? 00 75 15 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 E9 A8 00 00 00 8B 55 08 89 55 FC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 8B F0 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 04 2B F0 8B 55 08 03 D6 89 55 F0 8B 45 FC 33 C9 8A 08 85 C9 74 71 8B 55 FC 3B 55 F0 77 69 8B 45 FC 89 45 F8 8B 4D 0C 89 4D F4 8B 55 F8 33 C0 8A 02 85 C0 74 31 8B 4D F4 33 D2 8A 11 85 D2 74 26 8B 45 F8 33 C9 8A 08 8B 55 F4 33 C0 8A 02 3B C8 75 14 8B 4D F8 83 C1 01 89 4D F8 8B 55 F4 83 C2 01 89 55 F4 EB C4 8B 45 F4 33 C9 8A 08 85 C9 75 05 8B 45 FC EB 13 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC EB 84 33 C0 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_28_0_0 {
	meta:
		name = "__rmtmp"
		size = 136
		refs = "0024 __nstream 002e ___piob 006f _fclose"
	strings:
		$1 = { 55 8B EC 83 EC 08 C7 45 FC 00 00 00 00 C7 45 F8 00 00 00 00 EB 09 8B 45 F8 83 C0 01 89 45 F8 8B 4D F8 3B 0D ?? ?? ?? ?? 7D 57 8B 55 F8 A1 ?? ?? ?? ?? 83 3C 90 00 74 47 8B 4D F8 8B 15 ?? ?? ?? ?? 8B 04 8A 8B 48 0C 81 E1 83 00 00 00 85 C9 74 2E 8B 55 F8 A1 ?? ?? ?? ?? 8B 0C 90 83 79 1C 00 74 1D 8B 55 F8 A1 ?? ?? ?? ?? 8B 0C 90 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 FC 83 C2 01 89 55 FC EB 95 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_29_0_0 {
	meta:
		name = "??2@YAPAXIHPBDH@Z"
		size = 31
		refs = "0016 __nh_malloc_dbg"
	strings:
		$1 = { 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 6A 01 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_30_0_0 {
	meta:
		name = "__heapwalk"
		size = 450
		refs = "0006 $T16906 000b __except_handler3 0011 __except_list 004a __crtheap 0051 __imp__HeapWalk@8 005b __imp__GetLastError@0 0066 __doserrno 0070 _errno 00ab __imp__HeapValidate@12"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 C4 D0 53 56 57 89 65 E8 C7 45 E0 FE FF FF FF 66 C7 45 CA 00 00 C6 45 C9 00 8B 45 08 8B 08 89 4D C0 83 7D C0 00 75 4C 8D 55 C0 52 A1 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 75 33 FF 15 ?? ?? ?? ?? 83 F8 78 75 1E C7 05 ?? ?? ?? ?? 78 00 00 00 C7 05 ?? ?? ?? ?? 28 00 00 00 B8 FB FF FF FF E9 2F 01 00 00 B8 FD FF FF FF E9 25 01 00 00 E9 D1 00 00 00 8B 4D 08 83 79 08 01 75 29 8B 55 08 8B 02 50 6A 00 8B 0D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 85 C0 75 0A B8 FC FF FF FF E9 F4 00 00 00 66 C7 45 CA 04 00 C7 45 FC 00 00 00 00 C7 45 E4 00 00 00 00 8D 55 C0 52 A1 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 75 07 C7 45 E4 01 00 00 00 C7 45 FC FF FF FF FF EB 17 B8 01 00 00 00 C3 8B 65 E8 C7 45 E4 02 00 00 00 C7 45 FC FF FF FF FF 83 7D E4 01 75 43 FF 15 ?? ?? ?? ?? 89 45 DC 81 7D DC 03 01 00 00 75 0A B8 FB FF FF FF E9 83 00 00 00 83 7D DC 78 75 1A 8B 4D DC 89 0D ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 28 00 00 00 B8 FB FF FF FF EB 63 B8 FC FF FF FF EB 5C 83 7D E4 02 75 07 B8 FC FF FF FF EB 4F 8B 55 CA 81 E2 FF FF 00 00 83 E2 03 85 D2 74 05 E9 4C FF FF FF 8B 45 08 8B 4D C0 89 08 8B 55 08 8B 45 C4 89 42 04 8B 4D CA 81 E1 FF FF 00 00 83 E1 04 85 C9 74 0C 8B 55 08 C7 42 08 01 00 00 00 EB 0A 8B 45 08 C7 40 08 00 00 00 00 8B 45 E0 8B 4D F0 64 89 0D ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_31_0_0 {
	meta:
		name = "_XMMI2_FP_Emulation"
		size = 11851
		refs = "0089 $L21478 0090 $L21479 00f0 $L21480 017a $L21481 01b6 __control87 01f5 $L21482 0268 __statusfp 02a0 _Fill_FPIEEE_RECORD 02f2 _isnand 035b _quietd 05a4 _MIN_DOUBLE_NORMALA 05ad _memcpy 05b7 _MAX_DOUBLE_NORMALA 05ca _POSINFDEA 05e0 _NEGINFDEA 05f6 _TWO_TO_1536A 0609 _TWO_TO_M1536A 094b $L21483 0a93 __real@8@00000000000000000000 0aa0 _ZERODA 0ac3 _NZERODA 0d51 $L21484 0d5e _issnand 0e8a $L21485 0f74 _isdenormald 1004 $L21486 1057 $L21487 105e $L21488 10ad $L21489 10d2 ??_C@_0EM@BBBH@XMMI2_FP_Emulation?5?$CI?$CJ?5INTERNAL?5X@ 10d7 __iob 10dc _fprintf 147c ??_C@_0EP@GOIF@XMMI2_FP_Emulation?5?$CI?$CJ?5INTERNAL?5X@ 1525 $L21490 179b $L21491 1a14 $L21492 1a1b $L21493 1a9e $L21494 1d10 $L21495 1f22 $L21496 2044 _isinfd 2058 _iszerod 2136 _MIN_SINGLE_NORMALA 215f _MAX_SINGLE_NORMALA 2370 _ZEROFA 2390 _NZEROFA 25e7 $L21497 28b8 ??_C@_0FI@LGJH@XMMI2_FP_Emulation?5?$CI?$CJ?5INTERNAL?5X@ 2995 $L21498 2c12 ??_C@_0EF@MHBD@XMMI2_FP_Emulation?5internal?5erro@ 2c38 ??_C@_0DO@LAGC@XMMI2_FP_Emulation?5internal?5erro@ 2c50 $L21410 2c54 $L21033 2c58 $L21391 2c5c $L21353 2c60 $L21123 2c64 $L21184 2c68 $L21258 2c6c $L21288 2c70 $L21303 2c74 $L21215 2c78 $L21228 2c7c $L21412 2ce2 $L21038 2cea $L21039 2cf2 $L21040 2cfa $L21041 2d02 $L21047 2d06 $L21048 2d0a $L21049 2d0e $L21050 2d12 $L21056 2d16 $L21057 2d1a $L21058 2d1e $L21059 2d22 $L21093 2d26 $L21094 2d2a $L21095 2d2e $L21096 2d32 $L21128 2d36 $L21133 2d52 $L21145 2d5e $L21146 2d72 $L21161 2d76 $L21160 2d92 $L21170 2d96 $L21169 2da2 $L21178 2da6 $L21179 2dc2 $L21220 2dc6 $L21221 2dca $L21222 2dce $L21223 2dd2 $L21245 2dd6 $L21246 2dda $L21247 2dde $L21248 2de2 $L21263 2de6 $L21264 2dea $L21265 2dfb $L21275 2dff $L21276 2e03 $L21277 2e07 $L21278 2e0b $L21293 2e0f $L21294 2e13 $L21295 2e17 $L21296 2e1b $L21308 2e1f $L21309 2e23 $L21310 2e27 $L21311 2e2b $L21358 2e33 $L21359 2e3b $L21396 2e3f $L21397 2e43 $L21398 2e47 $L21399"
	strings:
		$1 = { 55 8B EC 81 EC 20 01 00 00 53 56 57 DB E3 C7 45 DC 00 00 00 00 C7 45 CC 00 00 00 00 8B 45 08 8B 48 1C 8B 55 08 8B 42 0C 83 E0 03 8B 09 83 E1 FC 0B C8 8B 55 08 8B 42 1C 89 08 8B 4D 08 8B 51 1C 8B 45 08 8B 48 10 83 E1 07 C1 E1 02 8B 12 83 E2 E3 0B D1 8B 45 08 8B 48 1C 89 11 8B 55 08 8B 42 1C 8B 08 C1 E9 05 81 E1 FF 0F 00 00 89 8D 3C FF FF FF 83 BD 3C FF FF FF 61 0F 87 A6 2B 00 00 8B 85 3C FF FF FF 33 D2 8A 90 ?? ?? ?? ?? FF 24 95 ?? ?? ?? ?? 8B 4D 08 8B 51 1C 8B 42 10 89 45 F4 8B 4A 14 89 4D F8 8B 55 08 8B 42 1C 8B 48 28 89 4D D4 8B 50 2C 89 55 D8 8B 45 08 8B 48 1C 8B 11 C1 EA 05 81 E2 FF 0F 00 00 89 95 38 FF FF FF 8B 85 38 FF FF FF 83 E8 43 89 85 38 FF FF FF 83 BD 38 FF FF FF 07 77 75 8B 8D 38 FF FF FF FF 24 8D ?? ?? ?? ?? 8B 55 08 8B 42 1C 8B 08 81 E1 1F 00 FE FF 83 C9 20 8B 55 08 8B 42 1C 89 08 EB 4D 8B 4D 08 8B 51 1C 8B 02 25 1F 00 FE FF 0C 40 8B 4D 08 8B 51 1C 89 02 EB 34 8B 45 08 8B 48 1C 8B 11 81 E2 1F 00 FE FF 83 CA 60 8B 45 08 8B 48 1C 89 11 EB 19 8B 55 08 8B 42 1C 8B 08 81 E1 1F 00 FE FF 80 C9 80 8B 55 08 8B 42 1C 89 08 8B 4D 08 8B 51 0C 89 95 34 FF FF FF 83 BD 34 FF FF FF 03 77 2F 8B 85 34 FF FF FF FF 24 85 ?? ?? ?? ?? C7 45 E0 00 00 00 00 EB 19 C7 45 E0 00 01 00 00 EB 10 C7 45 E0 00 02 00 00 EB 07 C7 45 E0 00 03 00 00 68 1F 03 0B 00 8B 4D E0 81 C9 00 00 01 00 81 C9 1F 00 08 00 51 E8 ?? ?? ?? ?? 83 C4 08 8B 55 08 8B 42 1C 8B 08 C1 E9 05 81 E1 FF 0F 00 00 89 8D 30 FF FF FF 8B 95 30 FF FF FF 83 EA 01 89 95 30 FF FF FF 83 BD 30 FF FF FF 03 77 7B 8B 85 30 FF FF FF FF 24 85 ?? ?? ?? ?? DB E2 DD 45 F4 DD 45 D4 DE C1 DD 5D 9C DB E2 DD 45 F4 DD 45 D4 DE C1 DB 7D 80 EB 52 DB E2 DD 45 F4 DD 45 D4 DE E9 DD 5D 9C DB E2 DD 45 F4 DD 45 D4 DE E9 DB 7D 80 EB 36 DB E2 DD 45 F4 DD 45 D4 DE C9 DD 5D 9C DB E2 DD 45 F4 DD 45 D4 DE C9 DB 7D 80 EB 1A DB E2 DD 45 F4 DD 45 D4 DE F9 DD 5D 9C DB E2 DD 45 F4 DD 45 D4 DE F9 DB 7D 80 E8 ?? ?? ?? ?? 89 45 8C 8B 4D 8C 83 E1 08 85 C9 74 0C 8B 55 8C 81 E2 FF FF F7 FF 89 55 8C 8B 45 08 8B 08 83 E1 01 85 C9 75 58 8B 55 8C 83 E2 10 85 D2 74 4E 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 08 8B 51 1C 8B 42 0C 0C 10 8B 4D 08 8B 51 1C 89 42 0C 8B 45 08 8B 48 04 83 C9 01 8B 55 08 89 4A 04 8B 45 08 8B 48 1C 8B 51 04 83 CA 10 8B 45 08 8B 48 1C 89 51 04 B8 01 00 00 00 E9 60 29 00 00 8B 55 F8 52 8B 45 F4 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 18 8B 4D D8 51 8B 55 D4 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 0F 84 08 01 00 00 8B 45 08 8B 48 1C 8B 51 50 83 CA 01 8B 45 08 8B 48 1C 89 51 50 8B 55 F8 52 8B 45 F4 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 2F 8B 4D D8 51 8B 55 D4 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 1B 8B 45 F8 50 8B 4D F4 51 E8 ?? ?? ?? ?? 83 C4 08 8B 55 08 8B 42 1C DD 58 40 EB 12 8B 4D 08 8B 51 1C 8B 45 9C 89 42 40 8B 4D A0 89 4A 44 8B 55 08 8B 42 1C 8B 48 0C 83 E1 FD 8B 55 08 8B 42 1C 89 48 0C 8B 4D 08 8B 51 1C 8B 42 0C 24 FB 8B 4D 08 8B 51 1C 89 42 0C 8B 45 08 8B 48 1C 8B 51 0C 83 E2 FE 8B 45 08 8B 48 1C 89 51 0C 8B 55 08 8B 42 1C 8B 48 0C 83 E1 F7 8B 55 08 8B 42 1C 89 48 0C 8B 4D 8C 83 E1 10 85 C9 74 26 8B 55 08 8B 42 1C 8B 48 0C 83 C9 10 8B 55 08 8B 42 1C 89 48 0C 8B 4D 08 8B 51 04 83 CA 01 8B 45 08 89 50 04 EB 14 8B 4D 08 8B 51 1C 8B 42 0C 24 EF 8B 4D 08 8B 51 1C 89 42 0C 33 C0 E9 2C 28 00 00 8B 45 08 8B 08 83 E1 02 85 C9 75 32 8B 55 8C 81 E2 00 00 08 00 85 D2 74 25 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 08 8B 51 04 83 CA 02 8B 45 08 89 50 04 B8 01 00 00 00 E9 EE 27 00 00 8B 4D 08 8B 11 83 E2 04 85 D2 75 58 8B 45 8C 83 E0 08 85 C0 74 4E 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 08 8B 42 1C 8B 48 0C 83 C9 08 8B 55 08 8B 42 1C 89 48 0C 8B 4D 08 8B 51 04 83 CA 04 8B 45 08 89 50 04 8B 4D 08 8B 51 1C 8B 42 04 0C 08 8B 4D 08 8B 51 1C 89 42 04 B8 01 00 00 00 E9 8A 27 00 00 8B 45 9C 89 45 BC 8B 4D A0 89 4D C0 8B 55 C0 52 8B 45 BC 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 0F 84 A2 00 00 00 8B 4D 08 8B 51 1C 8B 42 50 0C 01 8B 4D 08 8B 51 1C 89 42 50 8B 45 08 8B 48 1C 8B 55 BC 89 51 40 8B 45 C0 89 41 44 8B 4D 08 8B 51 1C 8B 42 0C 24 FD 8B 4D 08 8B 51 1C 89 42 0C 8B 45 08 8B 48 1C 8B 51 0C 83 E2 FB 8B 45 08 8B 48 1C 89 51 0C 8B 55 08 8B 42 1C 8B 48 0C 83 E1 FE 8B 55 08 8B 42 1C 89 48 0C 8B 4D 08 8B 51 1C 8B 42 0C 24 F7 8B 4D 08 8B 51 1C 89 42 0C 8B 45 08 8B 48 1C 8B 51 0C 83 CA 10 8B 45 08 8B 48 1C 89 51 0C 8B 55 08 8B 42 04 0C 01 8B 4D 08 89 41 04 33 C0 E9 C4 26 00 00 8B 55 8C 81 E2 00 00 08 00 85 D2 74 0F 8B 45 08 8B 48 04 83 C9 02 8B 55 08 89 4A 04 6A 0A 68 ?? ?? ?? ?? 8D 45 A4 50 E8 ?? ?? ?? ?? 83 C4 0C 6A 0A 68 ?? ?? ?? ?? 8D 4D E8 51 E8 ?? ?? ?? ?? 83 C4 0C 6A 0A 68 ?? ?? ?? ?? 8D 95 60 FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 6A 0A 68 ?? ?? ?? ?? 8D 85 44 FF FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 6A 0A 68 ?? ?? ?? ?? 8D 4D B0 51 E8 ?? ?? ?? ?? 83 C4 0C 6A 0A 68 ?? ?? ?? ?? 8D 95 6C FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C DB 6D 80 DB 6D A4 D9 E0 DE D9 9B DD BD 58 FF FF FF D9 EE DB 6D 80 DE D9 9B DD BD 50 FF FF FF DB 6D 80 D9 EE DE D9 9B DD BD 40 FF FF FF DB 6D A4 DB 6D 80 DE D9 9B DD 7D FC 8B 85 58 FF FF FF 25 FF FF 00 00 25 00 45 00 00 3D 00 01 00 00 75 1A 8B 8D 50 FF FF FF 81 E1 FF FF 00 00 81 E1 00 45 00 00 81 F9 00 01 00 00 74 2E 8B 95 40 FF FF FF 81 E2 FF FF 00 00 81 E2 00 45 00 00 81 FA 00 01 00 00 75 1B 8B 45 FC 25 FF FF 00 00 25 00 45 00 00 3D 00 01 00 00 75 07 C7 45 DC 01 00 00 00 DB 6D 80 DB AD 44 FF FF FF DE D9 9B DD BD 58 FF FF FF DB 6D E8 D9 E0 DB 6D 80 DE D9 9B DD BD 50 FF FF FF DB 6D 80 DB 6D E8 DE D9 9B DD BD 40 FF FF FF DB AD 60 FF FF FF DB 6D 80 DE D9 9B DD 7D FC 8B 8D 58 FF FF FF 81 E1 FF FF 00 00 81 E1 00 45 00 00 81 F9 00 01 00 00 75 1A 8B 95 50 FF FF FF 81 E2 FF FF 00 00 81 E2 00 45 00 00 81 FA 00 01 00 00 74 2E 8B 85 40 FF FF FF 25 FF FF 00 00 25 00 45 00 00 3D 00 01 00 00 75 1E 8B 4D FC 81 E1 FF FF 00 00 81 E1 00 45 00 00 81 F9 00 01 00 00 75 07 C7 45 CC 01 00 00 00 8B 55 08 8B 02 83 E0 10 85 C0 0F 85 B7 00 00 00 83 7D DC 00 0F 84 AD 00 00 00 DB 6D 80 DB 6D B0 DE C9 DD 5D 9C 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 08 8B 42 1C 8B 48 0C 83 C9 02 8B 55 08 8B 42 1C 89 48 0C 8B 4D 08 8B 51 04 83 CA 10 8B 45 08 89 50 04 8B 4D 08 8B 51 1C 8B 42 04 0C 02 8B 4D 08 8B 51 1C 89 42 04 8B 45 08 8B 48 1C 8B 51 50 83 CA 01 8B 45 08 8B 48 1C 89 51 50 8B 55 08 8B 42 1C 8B 4D 9C 89 48 40 8B 55 A0 89 50 44 8B 45 8C 83 E0 01 85 C0 74 23 8B 4D 08 8B 51 1C 8B 42 0C 0C 01 8B 4D 08 8B 51 1C 89 42 0C 8B 45 08 8B 48 04 83 C9 20 8B 55 08 89 4A 04 B8 01 00 00 00 E9 1D 24 00 00 8B 45 08 8B 08 83 E1 08 85 C9 0F 85 BA 00 00 00 83 7D CC 00 0F 84 B0 00 00 00 DB 6D 80 DB AD 6C FF FF FF DE C9 DD 5D 9C 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 8B 45 08 8B 48 1C 8B 51 0C 83 CA 04 8B 45 08 8B 48 1C 89 51 0C 8B 55 08 8B 42 04 0C 08 8B 4D 08 89 41 04 8B 55 08 8B 42 1C 8B 48 04 83 C9 04 8B 55 08 8B 42 1C 89 48 04 8B 4D 08 8B 51 1C 8B 42 50 0C 01 8B 4D 08 8B 51 1C 89 42 50 8B 45 08 8B 48 1C 8B 55 9C 89 51 40 8B 45 A0 89 41 44 8B 4D 8C 83 E1 01 85 C9 74 24 8B 55 08 8B 42 1C 8B 48 0C 83 C9 01 8B 55 08 8B 42 1C 89 48 0C 8B 4D 08 8B 51 04 83 CA 20 8B 45 08 89 50 04 B8 01 00 00 00 E9 53 23 00 00 68 1F 03 0B 00 8B 4D E0 81 C9 00 00 01 00 81 C9 1F 00 08 00 51 E8 ?? ?? ?? ?? 83 C4 08 8B 55 08 8B 42 1C 8B 08 C1 E9 05 81 E1 FF 0F 00 00 89 8D 2C FF FF FF 8B 95 2C FF FF FF 83 EA 01 89 95 2C FF FF FF 83 BD 2C FF FF FF 03 77 3F 8B 85 2C FF FF FF FF 24 85 ?? ?? ?? ?? DD 45 F4 DD 45 D4 DE C1 DD 5D BC EB 25 DD 45 F4 DD 45 D4 DE E9 DD 5D BC EB 18 DD 45 F4 DD 45 D4 DE C9 DD 5D BC EB 0B DD 45 F4 DD 45 D4 DE F9 DD 5D BC E8 ?? ?? ?? ?? 89 45 8C 8B 4D 8C 83 E1 01 85 C9 74 0F 83 7D DC 00 74 09 8B 55 8C 83 CA 02 89 55 8C 8B 45 08 8B 08 83 E1 20 85 C9 0F 85 3D 01 00 00 8B 55 8C 83 E2 01 85 D2 75 17 8B 45 08 83 78 08 00 0F 84 26 01 00 00 83 7D DC 00 0F 84 1C 01 00 00 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 08 8B 42 1C 8B 48 0C 83 C9 01 8B 55 08 8B 42 1C 89 48 0C 8B 4D 08 8B 51 04 83 CA 20 8B 45 08 89 50 04 8B 4D 08 8B 51 1C 8B 42 04 0C 01 8B 4D 08 8B 51 1C 89 42 04 8B 45 08 8B 48 1C 8B 51 50 83 CA 01 8B 45 08 8B 48 1C 89 51 50 83 7D DC 00 74 24 8B 55 08 8B 42 1C 8B 48 0C 83 C9 02 8B 55 08 8B 42 1C 89 48 0C 8B 4D 08 8B 51 04 83 CA 10 8B 45 08 89 50 04 83 7D CC 00 74 23 8B 4D 08 8B 51 1C 8B 42 0C 0C 04 8B 4D 08 8B 51 1C 89 42 0C 8B 45 08 8B 48 04 83 C9 08 8B 55 08 89 4A 04 8B 45 08 83 78 08 00 74 4B 83 7D DC 00 74 45 DD 45 BC DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 75 14 8B 0D ?? ?? ?? ?? 89 4D BC 8B 15 ?? ?? ?? ?? 89 55 C0 EB 21 DD 45 BC DC 1D ?? ?? ?? ?? DF E0 F6 C4 01 74 11 A1 ?? ?? ?? ?? 89 45 BC 8B 0D ?? ?? ?? ?? 89 4D C0 8B 55 08 8B 42 1C 8B 4D BC 89 48 40 8B 55 C0 89 50 44 B8 01 00 00 00 E9 5A 21 00 00 8B 45 08 8B 48 1C 8B 51 50 83 CA 01 8B 45 08 8B 48 1C 89 51 50 8B 55 8C 83 E2 02 85 D2 74 25 8B 45 08 8B 48 1C 8B 51 0C 83 CA 02 8B 45 08 8B 48 1C 89 51 0C 8B 55 08 8B 42 04 0C 10 8B 4D 08 89 41 04 EB 15 8B 55 08 8B 42 1C 8B 48 0C 83 E1 FD 8B 55 08 8B 42 1C 89 48 0C 8B 4D 8C 83 E1 04 85 C9 74 26 8B 55 08 8B 42 1C 8B 48 0C 83 C9 04 8B 55 08 8B 42 1C 89 48 0C 8B 4D 08 8B 51 04 83 CA 08 8B 45 08 89 50 04 EB 14 8B 4D 08 8B 51 1C 8B 42 0C 24 FB 8B 4D 08 8B 51 1C 89 42 0C 8B 45 8C 83 E0 01 85 C0 74 25 8B 4D 08 8B 51 1C 8B 42 0C 0C 01 8B 4D 08 8B 51 1C 89 42 0C 8B 45 08 8B 48 04 83 C9 20 8B 55 08 89 4A 04 EB 15 8B 45 08 8B 48 1C 8B 51 0C 83 E2 FE 8B 45 08 8B 48 1C 89 51 0C 8B 55 08 83 7A 08 00 0F 84 94 00 00 00 83 7D DC 00 0F 84 8A 00 00 00 DD 45 BC DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 75 13 A1 ?? ?? ?? ?? 89 45 BC 8B 0D ?? ?? ?? ?? 89 4D C0 EB 21 DD 45 BC DC 1D ?? ?? ?? ?? DF E0 F6 C4 01 74 11 8B 15 ?? ?? ?? ?? 89 55 BC A1 ?? ?? ?? ?? 89 45 C0 8B 4D 08 8B 51 1C 8B 42 0C 0C 01 8B 4D 08 8B 51 1C 89 42 0C 8B 45 08 8B 48 04 83 C9 20 8B 55 08 89 4A 04 8B 45 08 8B 48 1C 8B 51 0C 83 CA 02 8B 45 08 8B 48 1C 89 51 0C 8B 55 08 8B 42 04 0C 10 8B 4D 08 89 41 04 8B 55 08 8B 42 1C 8B 4D BC 89 48 40 8B 55 C0 89 50 44 8B 45 8C 83 E0 08 85 C0 74 25 8B 4D 08 8B 51 1C 8B 42 0C 0C 08 8B 4D 08 8B 51 1C 89 42 0C 8B 45 08 8B 48 04 83 C9 04 8B 55 08 89 4A 04 EB 15 8B 45 08 8B 48 1C 8B 51 0C 83 E2 F7 8B 45 08 8B 48 1C 89 51 0C 8B 55 08 8B 42 1C 8B 48 0C 83 E1 EF 8B 55 08 8B 42 1C 89 48 0C 33 C0 E9 66 1F 00 00 8B 4D 08 8B 51 1C 8B 42 10 89 45 F4 8B 4A 14 89 4D F8 8B 55 08 8B 42 1C 8B 48 28 89 4D D4 8B 50 2C 89 55 D8 8B 45 08 8B 48 14 83 E1 07 89 8D 54 FF FF FF 8B 55 08 8B 42 1C 8B 08 81 E1 1F 00 FE FF 80 C9 E0 8B 55 08 8B 42 1C 89 08 8B 8D 54 FF FF FF 89 8D 28 FF FF FF 83 BD 28 FF FF FF 07 0F 87 98 00 00 00 8B 95 28 FF FF FF FF 24 95 ?? ?? ?? ?? 8B 45 F8 50 8B 4D F4 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 14 8B 55 D8 52 8B 45 D4 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 09 C7 45 E4 01 00 00 00 EB 07 C7 45 E4 00 00 00 00 E8 ?? ?? ?? ?? 89 45 8C 8B 4D 8C 83 E1 10 85 C9 74 07 C7 45 E4 01 00 00 00 EB 38 8B 55 F8 52 8B 45 F4 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 14 8B 4D D8 51 8B 55 D4 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 09 C7 45 E4 01 00 00 00 EB 07 C7 45 E4 00 00 00 00 83 7D E4 00 74 5A 8B 45 08 8B 08 83 E1 01 85 C9 75 4E 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 8B 45 08 8B 48 1C 8B 51 0C 83 CA 10 8B 45 08 8B 48 1C 89 51 0C 8B 55 08 8B 42 04 0C 01 8B 4D 08 89 41 04 8B 55 08 8B 42 1C 8B 48 04 83 C9 10 8B 55 08 8B 42 1C 89 48 04 B8 01 00 00 00 E9 09 1E 00 00 8B 4D F8 51 8B 55 F4 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 18 8B 45 D8 50 8B 4D D4 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 0F 84 FF 00 00 00 8B 95 54 FF FF FF 89 95 24 FF FF FF 83 BD 24 FF FF FF 07 77 2B 8B 85 24 FF FF FF FF 24 85 ?? ?? ?? ?? C7 45 C4 00 00 00 00 C7 45 C8 00 00 00 00 EB 0E C7 45 C4 FF FF FF FF C7 45 C8 FF FF FF FF 8B 4D 08 8B 51 1C 8B 42 50 0C 01 8B 4D 08 8B 51 1C 89 42 50 8B 45 08 8B 48 1C 8B 55 C4 89 51 40 8B 45 C8 89 41 44 8B 4D 08 8B 51 1C 8B 42 0C 24 FE 8B 4D 08 8B 51 1C 89 42 0C 8B 45 08 8B 48 1C 8B 51 0C 83 E2 FD 8B 45 08 8B 48 1C 89 51 0C 8B 55 08 8B 42 1C 8B 48 0C 83 E1 FB 8B 55 08 8B 42 1C 89 48 0C 8B 4D 08 8B 51 1C 8B 42 0C 24 F7 8B 4D 08 8B 51 1C 89 42 0C 83 7D E4 00 74 25 8B 45 08 8B 48 1C 8B 51 0C 83 CA 10 8B 45 08 8B 48 1C 89 51 0C 8B 55 08 8B 42 04 0C 01 8B 4D 08 89 41 04 EB 15 8B 55 08 8B 42 1C 8B 48 0C 83 E1 EF 8B 55 08 8B 42 1C 89 48 0C 33 C0 E9 DE 1C 00 00 8B 4D F8 51 8B 55 F4 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 14 8B 45 D8 50 8B 4D D4 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 17 C7 45 D0 01 00 00 00 8B 55 08 8B 42 04 0C 02 8B 4D 08 89 41 04 EB 07 C7 45 D0 00 00 00 00 83 7D D0 00 74 22 8B 55 08 8B 02 83 E0 02 85 C0 75 16 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 B8 01 00 00 00 E9 70 1C 00 00 DD 45 F4 DC 5D D4 DF E0 F6 C4 01 74 45 8B 95 54 FF FF FF 89 95 20 FF FF FF 83 BD 20 FF FF FF 07 77 2B 8B 85 20 FF FF }
	condition:
		$1
}

rule file_31_1_0 {
	meta:
		name = "_iszerod"
		size = 47
	strings:
		$1 = { 55 8B EC 51 8D 45 08 89 45 FC 8B 4D FC 8B 51 04 81 E2 FF FF FF 7F 85 D2 75 0F 8B 45 FC 83 38 00 75 07 B8 01 00 00 00 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_31_2_0 {
	meta:
		name = "_isinfd"
		size = 51
	strings:
		$1 = { 55 8B EC 51 8D 45 08 89 45 FC 8B 4D FC 8B 51 04 81 E2 FF FF FF 7F 81 FA 00 00 F8 7F 75 0F 8B 45 FC 83 38 00 75 07 B8 01 00 00 00 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_31_3_0 {
	meta:
		name = "_issnand"
		size = 67
	strings:
		$1 = { 55 8B EC 51 8D 45 08 89 45 FC 8B 4D FC 8B 51 04 81 E2 00 00 F8 7F 81 FA 00 00 F0 7F 75 1F 8B 45 FC 8B 48 04 81 E1 FF FF 07 00 85 C9 75 08 8B 55 FC 83 3A 00 74 07 B8 01 00 00 00 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_31_4_0 {
	meta:
		name = "_isnand"
		size = 67
	strings:
		$1 = { 55 8B EC 51 8D 45 08 89 45 FC 8B 4D FC 8B 51 04 81 E2 00 00 F0 7F 81 FA 00 00 F0 7F 75 1F 8B 45 FC 8B 48 04 81 E1 FF FF 0F 00 85 C9 75 08 8B 55 FC 83 3A 00 74 07 B8 01 00 00 00 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_31_5_0 {
	meta:
		name = "_quietd"
		size = 35
	strings:
		$1 = { 55 8B EC 51 8D 45 08 89 45 FC 8B 4D FC 8B 51 04 81 CA 00 00 08 00 8B 45 FC 89 50 04 DD 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_31_6_0 {
	meta:
		name = "_isdenormald"
		size = 63
	strings:
		$1 = { 55 8B EC 51 8D 45 08 89 45 FC 8B 4D FC 8B 51 04 81 E2 00 00 F0 7F 85 D2 75 1F 8B 45 FC 8B 48 04 81 E1 FF FF 0F 00 85 C9 75 08 8B 55 FC 83 3A 00 74 07 B8 01 00 00 00 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_31_7_0 {
	meta:
		name = "_Fill_FPIEEE_RECORD"
		size = 479
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 48 1C 8B 55 08 8B 42 0C 83 E0 03 8B 09 83 E1 FC 0B C8 8B 55 08 8B 42 1C 89 08 8B 4D 08 8B 51 1C 8B 45 08 8B 48 10 83 E1 07 C1 E1 02 8B 12 83 E2 E3 0B D1 8B 45 08 8B 48 1C 89 11 8B 55 08 8B 02 83 E0 20 F7 D8 1B C0 40 8B 4D 08 8B 51 1C 83 E0 01 8B 4A 08 83 E1 FE 0B C8 8B 55 08 8B 42 1C 89 48 08 8B 4D 08 8B 11 83 E2 10 F7 DA 1B D2 42 8B 45 08 8B 48 1C 83 E2 01 D1 E2 8B 41 08 24 FD 0B C2 8B 4D 08 8B 51 1C 89 42 08 8B 45 08 8B 08 83 E1 08 F7 D9 1B C9 41 8B 55 08 8B 42 1C 83 E1 01 C1 E1 02 8B 50 08 83 E2 FB 0B D1 8B 45 08 8B 48 1C 89 51 08 8B 55 08 8B 02 83 E0 04 F7 D8 1B C0 40 8B 4D 08 8B 51 1C 83 E0 01 C1 E0 03 8B 4A 08 83 E1 F7 0B C8 8B 55 08 8B 42 1C 89 48 08 8B 4D 08 8B 11 83 E2 01 F7 DA 1B D2 42 8B 45 08 8B 48 1C 83 E2 01 C1 E2 04 8B 41 08 24 EF 0B C2 8B 4D 08 8B 51 1C 89 42 08 8B 45 08 8B 48 1C 8B 51 0C 83 E2 FE 8B 45 08 8B 48 1C 89 51 0C 8B 55 08 8B 42 1C 8B 48 0C 83 E1 FD 8B 55 08 8B 42 1C 89 48 0C 8B 4D 08 8B 51 1C 8B 42 0C 24 FB 8B 4D 08 8B 51 1C 89 42 0C 8B 45 08 8B 48 1C 8B 51 0C 83 E2 F7 8B 45 08 8B 48 1C 89 51 0C 8B 55 08 8B 42 1C 8B 48 0C 83 E1 EF 8B 55 08 8B 42 1C 89 48 0C 8B 4D 08 8B 51 1C 8B 42 04 24 FE 8B 4D 08 8B 51 1C 89 42 04 8B 45 08 8B 48 1C 8B 51 04 83 E2 FD 8B 45 08 8B 48 1C 89 51 04 8B 55 08 8B 42 1C 8B 48 04 83 E1 FB 8B 55 08 8B 42 1C 89 48 04 8B 4D 08 8B 51 1C 8B 42 04 24 F7 8B 4D 08 8B 51 1C 89 42 04 8B 45 08 8B 48 1C 8B 51 04 83 E2 EF 8B 45 08 8B 48 1C 89 51 04 5D C3 }
	condition:
		$1
}

rule file_32_0_0 {
	meta:
		name = "__wsetlocale"
		size = 318
		refs = "0018 _wcslen 0028 ??_C@_0L@PAEN@wsetloca?4c?$AA@ 0033 __malloc_dbg 0057 _wcstombs 006a __free_dbg 0081 _setlocale 00a9 _?outwlocale@?1??_wsetlocale@@9@9 00bf _mbstowcs"
	strings:
		$1 = { 55 8B EC 83 EC 0C C7 45 F4 00 00 00 00 83 7D 0C 00 74 65 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 04 83 C0 01 89 45 FC 6A 21 68 ?? ?? ?? ?? 6A 02 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 F4 83 7D F4 00 75 07 33 C0 E9 F0 00 00 00 8B 55 FC 52 8B 45 0C 50 8B 4D F4 51 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 FF 75 15 6A 02 8B 55 F4 52 E8 ?? ?? ?? ?? 83 C4 08 33 C0 E9 C2 00 00 00 8B 45 F4 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 F8 6A 02 8B 55 F4 52 E8 ?? ?? ?? ?? 83 C4 08 83 7D F8 00 75 07 33 C0 E9 94 00 00 00 6A 02 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 08 6A 00 8B 4D F8 51 6A 00 E8 ?? ?? ?? ?? 83 C4 0C 89 45 FC 83 7D FC FF 75 04 33 C0 EB 67 8B 55 FC 83 C2 01 89 55 FC 6A 3A 68 ?? ?? ?? ?? 6A 02 8B 45 FC D1 E0 50 E8 ?? ?? ?? ?? 83 C4 10 A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 75 04 33 C0 EB 35 8B 4D FC 51 8B 55 F8 52 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 FF 75 15 6A 02 8B 0D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 08 33 C0 EB 05 A1 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_33_0_0 {
	meta:
		name = "__wcsdup"
		size = 72
		refs = "0013 _wcslen 0020 _malloc 0039 _wcscpy"
	strings:
		$1 = { 55 8B EC 51 83 7D 08 00 75 04 33 C0 EB 36 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 8D 4C 00 02 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 83 7D FC 00 74 12 8B 55 08 52 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_34_0_0 {
	meta:
		name = "__stricmp"
		size = 28
		refs = "000e ___lc_handle"
	strings:
		$1 = { 55 8B EC 57 56 53 8B 75 0C 8B 7D 08 8D 05 ?? ?? ?? ?? 83 78 08 00 75 3B B0 FF 8B FF }
	condition:
		$1
}

rule file_34_1_0 {
	meta:
		name = "chk_null"
		size = 50
	strings:
		$1 = { 0A C0 74 2E 8A 06 46 8A 27 47 38 C4 74 F2 2C 41 3C 1A 1A C9 80 E1 20 02 C1 04 41 86 E0 2C 41 3C 1A 1A C9 80 E1 20 02 C1 04 41 38 E0 74 D2 1A C0 1C FF }
	condition:
		$1
}

rule file_34_4_0 {
	meta:
		name = "chk_null2"
		size = 43
		refs = "0011 _tolower"
	strings:
		$1 = { 0A C0 74 27 8A 06 46 8A 1F 47 38 D8 74 F2 50 53 E8 ?? ?? ?? ?? 8B D8 83 C4 04 E8 ?? ?? ?? ?? 83 C4 04 38 C3 74 DA 1B C0 83 D8 FF }
	condition:
		$1
}

rule file_36_0_0 {
	meta:
		name = "__ftelli64"
		size = 737
		refs = "0010 ??_C@_0M@KJPK@str?5?$CB?$DN?5NULL?$AA@ 0019 ??_C@_0L@JOEJ@ftelli64?4c?$AA@ 0020 __CrtDbgReport 0060 __lseeki64 00da ___pioinfo 0135 _errno"
	strings:
		$1 = { 55 8B EC 83 EC 28 53 56 57 83 7D 08 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 5F 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D6 8B 4D 08 89 4D F4 8B 55 F4 8B 42 10 89 45 F8 8B 4D F4 83 79 04 00 7D 0A 8B 55 F4 C7 42 04 00 00 00 00 6A 01 6A 00 6A 00 8B 45 F8 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 E0 89 55 E4 83 7D E4 00 7F 13 7C 06 83 7D E0 00 73 0B 83 C8 FF 83 CA FF E9 54 02 00 00 8B 4D F4 8B 51 0C 81 E2 08 01 00 00 85 D2 75 1A 8B 45 F4 8B 40 04 99 8B 4D E0 2B C8 8B 75 E4 1B F2 8B C1 8B D6 E9 2A 02 00 00 8B 55 F4 8B 45 F4 8B 0A 2B 48 08 89 4D E8 8B 55 F4 8B 42 0C 83 E0 03 85 C0 74 58 8B 4D F8 C1 F9 05 8B 55 F8 83 E2 1F 8B 04 8D ?? ?? ?? ?? 0F BE 4C D0 04 81 E1 80 00 00 00 85 C9 74 34 8B 55 F4 8B 42 08 89 45 FC EB 09 8B 4D FC 83 C1 01 89 4D FC 8B 55 F4 8B 45 FC 3B 02 73 16 8B 4D FC 0F BE 11 83 FA 0A 75 09 8B 45 E8 83 C0 01 89 45 E8 EB D7 EB 25 8B 4D F4 8B 51 0C 81 E2 80 00 00 00 85 D2 75 15 C7 05 ?? ?? ?? ?? 16 00 00 00 83 C8 FF 83 CA FF E9 92 01 00 00 8B 45 E0 0B 45 E4 85 C0 75 0A 8B 45 E8 33 D2 E9 7E 01 00 00 8B 4D F4 8B 51 0C 83 E2 01 85 D2 0F 84 5C 01 00 00 8B 45 F4 83 78 04 00 75 0C C7 45 E8 00 00 00 00 E9 47 01 00 00 8B 4D F4 8B 55 F4 8B 01 2B 42 08 8B 4D F4 8B 51 04 03 D0 89 55 F0 8B 45 F8 C1 F8 05 8B 4D F8 83 E1 1F 8B 14 85 ?? ?? ?? ?? 0F BE 44 CA 04 25 80 00 00 00 85 C0 0F 84 F7 00 00 00 6A 02 6A 00 6A 00 8B 4D F8 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 D8 89 55 DC 8B 55 D8 3B 55 E0 75 61 8B 45 DC 3B 45 E4 75 59 8B 4D F4 8B 51 08 03 55 F0 89 55 EC 8B 45 F4 8B 48 08 89 4D FC EB 09 8B 55 FC 83 C2 01 89 55 FC 8B 45 FC 3B 45 EC 73 16 8B 4D FC 0F BE 11 83 FA 0A 75 09 8B 45 F0 83 C0 01 89 45 F0 EB D9 8B 4D F4 8B 51 0C 81 E2 00 20 00 00 85 D2 74 09 8B 45 F0 83 C0 01 89 45 F0 EB 76 6A 00 8B 4D E4 51 8B 55 E0 52 8B 45 F8 50 E8 ?? ?? ?? ?? 83 C4 10 81 7D F0 00 02 00 00 77 26 8B 4D F4 8B 51 0C 83 E2 08 85 D2 74 19 8B 45 F4 8B 48 0C 81 E1 00 04 00 00 85 C9 75 09 C7 45 F0 00 02 00 00 EB 09 8B 55 F4 8B 42 18 89 45 F0 8B 4D F8 C1 F9 05 8B 55 F8 83 E2 1F 8B 04 8D ?? ?? ?? ?? 0F BE 4C D0 04 83 E1 04 85 C9 74 09 8B 55 F0 83 C2 01 89 55 F0 8B 45 F0 33 C9 8B 55 E0 2B D0 8B 45 E4 1B C1 89 55 E0 89 45 E4 8B 4D E8 33 D2 8B 45 E0 03 C1 8B 4D E4 13 CA 8B D1 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_37_0_0 {
	meta:
		name = "__spawnl"
		size = 209
		refs = "000d ??_C@_0BB@HLKL@pathname?5?$CB?$DN?5NULL?$AA@ 0016 ??_C@_08OHNM@spawnl?4c?$AA@ 001d __CrtDbgReport 003b ??_C@_0BG@FCLP@?$CKpathname?5?$CB?$DN?5_T?$CI?8?20?8?$CJ?$AA@ 0065 ??_C@_0BA@BICO@arglist?5?$CB?$DN?5NULL?$AA@ 0093 ??_C@_0BF@GGKN@?$CKarglist?5?$CB?$DN?5_T?$CI?8?20?8?$CJ?$AA@ 00c5 __spawnve"
	strings:
		$1 = { 55 8B EC 53 56 57 83 7D 0C 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 36 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D6 8B 4D 0C 0F BE 11 85 D2 75 1E 68 ?? ?? ?? ?? 6A 00 6A 37 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D2 83 7D 10 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 38 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D6 8B 55 10 0F BE 02 85 C0 75 1E 68 ?? ?? ?? ?? 6A 00 6A 39 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D2 6A 00 8D 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 10 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_38_0_0 {
	meta:
		name = "_fputc"
		size = 153
		refs = "0010 ??_C@_0M@KJPK@str?5?$CB?$DN?5NULL?$AA@ 0019 ??_C@_07CJDP@fputc?4c?$AA@ 0020 __CrtDbgReport 007f __flsbuf"
	strings:
		$1 = { 55 8B EC 83 EC 0C 53 56 57 83 7D 0C 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 2D 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D6 8B 4D 0C 89 4D FC 8B 55 FC 8B 42 04 83 E8 01 8B 4D FC 89 41 04 8B 55 FC 83 7A 04 00 7C 25 8B 45 FC 8B 08 8A 55 08 88 11 0F BE 45 08 25 FF 00 00 00 89 45 F4 8B 4D FC 8B 11 83 C2 01 8B 45 FC 89 10 EB 13 8B 4D FC 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 F4 8B 45 F4 89 45 F8 8B 45 F8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_38_1_0 {
	meta:
		name = "_putc"
		size = 21
		refs = "000c _fputc"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_258_0_0 {
	meta:
		name = "__lrotl"
		size = 21
		refs = "000c __rotl"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_396_0_0 {
	meta:
		name = "__lrotr"
		size = 21
		refs = "000c __rotr"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_39_0_0 {
	meta:
		name = "__setmbcp"
		size = 766
		refs = "000b _getSystemCP 001a ___mbcodepage 002e _setSBCS 0033 _setSBUpLow 0062 ___rgcode_page_info 008f __mbctype 0113 ___rgctypeflag 0134 ___ismbcodepage 0144 _CPtoLCID 014c ___mblcid 0180 ___mbulinfo 01a1 __imp__GetCPInfo@8 02e2 _fSystemSet"
	strings:
		$1 = { 55 8B EC 83 EC 28 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 08 8B 4D 08 3B 0D ?? ?? ?? ?? 75 07 33 C0 E9 D3 02 00 00 83 7D 08 00 75 11 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 E9 BC 02 00 00 C7 45 FC 00 00 00 00 EB 09 8B 55 FC 83 C2 01 89 55 FC 83 7D FC 05 0F 83 3D 01 00 00 8B 45 FC 6B C0 30 8B 88 ?? ?? ?? ?? 3B 4D 08 0F 85 23 01 00 00 C7 45 DC 00 00 00 00 EB 09 8B 55 DC 83 C2 01 89 55 DC 81 7D DC 01 01 00 00 73 0C 8B 45 DC C6 80 ?? ?? ?? ?? 00 EB E2 C7 45 F4 00 00 00 00 EB 09 8B 4D F4 83 C1 01 89 4D F4 83 7D F4 04 73 7B 8B 55 FC 6B D2 30 8B 45 F4 8D 8C C2 ?? ?? ?? ?? 89 4D F8 EB 09 8B 55 F8 83 C2 02 89 55 F8 8B 45 F8 33 C9 8A 08 85 C9 74 4D 8B 55 F8 33 C0 8A 42 01 85 C0 74 41 8B 4D F8 33 D2 8A 11 89 55 DC EB 09 8B 45 DC 83 C0 01 89 45 DC 8B 4D F8 33 D2 8A 51 01 39 55 DC 77 1D 8B 45 DC 8B 4D F4 8A 90 ?? ?? ?? ?? 0A 91 ?? ?? ?? ?? 8B 45 DC 88 90 ?? ?? ?? ?? EB CD EB 9F E9 76 FF FF FF 8B 4D 08 89 0D ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 01 00 00 00 8B 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 04 A3 ?? ?? ?? ?? C7 45 F4 00 00 00 00 EB 09 8B 45 F4 83 C0 01 89 45 F4 83 7D F4 06 73 1E 8B 4D FC 6B C9 30 8B 55 F4 8B 45 F4 66 8B 8C 41 ?? ?? ?? ?? 66 89 0C 55 ?? ?? ?? ?? EB D3 E8 ?? ?? ?? ?? 33 C0 E9 68 01 00 00 E9 B0 FE FF FF 8D 55 E0 52 8B 45 08 50 FF 15 ?? ?? ?? ?? 83 F8 01 0F 85 32 01 00 00 C7 45 DC 00 00 00 00 EB 09 8B 4D DC 83 C1 01 89 4D DC 81 7D DC 01 01 00 00 73 0C 8B 55 DC C6 82 ?? ?? ?? ?? 00 EB E2 8B 45 08 A3 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 00 00 00 00 83 7D E0 01 0F 86 B5 00 00 00 8D 4D E6 89 4D D8 EB 09 8B 55 D8 83 C2 02 89 55 D8 8B 45 D8 33 C9 8A 08 85 C9 74 47 8B 55 D8 33 C0 8A 42 01 85 C0 74 3B 8B 4D D8 33 D2 8A 11 89 55 DC EB 09 8B 45 DC 83 C0 01 89 45 DC 8B 4D D8 33 D2 8A 51 01 39 55 DC 77 17 8B 45 DC 8A 88 ?? ?? ?? ?? 80 C9 04 8B 55 DC 88 8A ?? ?? ?? ?? EB D3 EB A5 C7 45 DC 01 00 00 00 EB 09 8B 45 DC 83 C0 01 89 45 DC 81 7D DC FF 00 00 00 73 17 8B 4D DC 8A 91 ?? ?? ?? ?? 80 CA 08 8B 45 DC 88 90 ?? ?? ?? ?? EB D7 8B 0D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 04 A3 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 01 00 00 00 EB 0A C7 05 ?? ?? ?? ?? 00 00 00 00 C7 45 F4 00 00 00 00 EB 09 8B 55 F4 83 C2 01 89 55 F4 83 7D F4 06 73 0F 8B 45 F4 66 C7 04 45 ?? ?? ?? ?? 00 00 EB E2 E8 ?? ?? ?? ?? 33 C0 EB 1A 83 3D ?? ?? ?? ?? 00 74 0E E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 EB 03 83 C8 FF 8B E5 5D C3 }
	condition:
		$1
}

rule file_39_1_0 {
	meta:
		name = "_getSystemCP"
		size = 89
		refs = "0005 _fSystemSet 001f __imp__GetOEMCP@0 0037 __imp__GetACP@0 004e ___lc_codepage"
	strings:
		$1 = { 55 8B EC C7 05 ?? ?? ?? ?? 00 00 00 00 83 7D 08 FE 75 12 C7 05 ?? ?? ?? ?? 01 00 00 00 FF 15 ?? ?? ?? ?? EB 32 83 7D 08 FD 75 12 C7 05 ?? ?? ?? ?? 01 00 00 00 FF 15 ?? ?? ?? ?? EB 1A 83 7D 08 FC 75 11 C7 05 ?? ?? ?? ?? 01 00 00 00 A1 ?? ?? ?? ?? EB 03 8B 45 08 5D C3 }
	condition:
		$1
}

rule file_39_2_0 {
	meta:
		name = "_CPtoLCID"
		size = 119
		refs = "0023 $L17535 002a $L17536 0050 $L17376 0054 $L17384 0058 $L17392 005c $L17400 0060 $L17373"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 89 45 FC 8B 4D FC 81 E9 A4 03 00 00 89 4D FC 83 7D FC 12 77 2E 8B 45 FC 33 D2 8A 90 ?? ?? ?? ?? FF 24 95 ?? ?? ?? ?? B8 11 04 00 00 EB 17 B8 04 08 00 00 EB 10 B8 12 04 00 00 EB 09 B8 04 04 00 00 EB 02 33 C0 8B E5 5D C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 04 04 04 01 04 04 04 04 04 04 04 04 04 04 04 04 02 03 }
	condition:
		$1
}

rule file_39_3_0 {
	meta:
		name = "_setSBCS"
		size = 116
		refs = "0024 __mbctype 002d ___mbcodepage 0037 ___ismbcodepage 0041 ___mblcid 0068 ___mbulinfo"
	strings:
		$1 = { 55 8B EC 51 C7 45 FC 00 00 00 00 EB 09 8B 45 FC 83 C0 01 89 45 FC 81 7D FC 01 01 00 00 7D 0C 8B 4D FC C6 81 ?? ?? ?? ?? 00 EB E2 C7 05 ?? ?? ?? ?? 00 00 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 C7 45 FC 00 00 00 00 EB 09 8B 55 FC 83 C2 01 89 55 FC 83 7D FC 06 7D 0F 8B 45 FC 66 C7 04 45 ?? ?? ?? ?? 00 00 EB E2 8B E5 5D C3 }
	condition:
		$1
}

rule file_39_4_0 {
	meta:
		name = "_setSBUpLow"
		size = 770
		refs = "0012 ___mbcodepage 0019 __imp__GetCPInfo@8 00cb ___mblcid 00ed ___crtGetStringTypeA 0122 ___crtLCMapStringA 01a8 __mbctype 01d0 __mbcasemap"
	strings:
		$1 = { 55 8B EC 81 EC 1C 05 00 00 8D 85 E8 FC FF FF 50 8B 0D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 83 F8 01 0F 85 13 02 00 00 C7 85 E4 FA FF FF 00 00 00 00 EB 0F 8B 95 E4 FA FF FF 83 C2 01 89 95 E4 FA FF FF 81 BD E4 FA FF FF 00 01 00 00 73 15 8B 85 E4 FA FF FF 8A 8D E4 FA FF FF 88 8C 05 FC FC FF FF EB D0 C6 85 FC FC FF FF 20 8D 95 EE FC FF FF 89 55 FC EB 09 8B 45 FC 83 C0 02 89 45 FC 8B 4D FC 33 D2 8A 11 85 D2 74 40 8B 45 FC 33 C9 8A 08 89 8D E4 FA FF FF EB 0F 8B 95 E4 FA FF FF 83 C2 01 89 95 E4 FA FF FF 8B 45 FC 33 C9 8A 48 01 39 8D E4 FA FF FF 77 10 8B 95 E4 FA FF FF C6 84 15 FC FC FF FF 20 EB D1 EB AC 6A 00 A1 ?? ?? ?? ?? 50 8B 0D ?? ?? ?? ?? 51 8D 95 FC FD FF FF 52 68 00 01 00 00 8D 85 FC FC FF FF 50 6A 01 E8 ?? ?? ?? ?? 83 C4 1C 6A 00 8B 0D ?? ?? ?? ?? 51 68 00 01 00 00 8D 95 E8 FB FF FF 52 68 00 01 00 00 8D 85 FC FC FF FF 50 68 00 01 00 00 8B 0D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 20 6A 00 8B 15 ?? ?? ?? ?? 52 68 00 01 00 00 8D 85 E8 FA FF FF 50 68 00 01 00 00 8D 8D FC FC FF FF 51 68 00 02 00 00 8B 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 20 C7 85 E4 FA FF FF 00 00 00 00 EB 0F 8B 85 E4 FA FF FF 83 C0 01 89 85 E4 FA FF FF 81 BD E4 FA FF FF 00 01 00 00 0F 83 AB 00 00 00 8B 8D E4 FA FF FF 33 D2 66 8B 94 4D FC FD FF FF 83 E2 01 85 D2 74 36 8B 85 E4 FA FF FF 8A 88 ?? ?? ?? ?? 80 C9 10 8B 95 E4 FA FF FF 88 8A ?? ?? ?? ?? 8B 85 E4 FA FF FF 8B 8D E4 FA FF FF 8A 94 0D E8 FB FF FF 88 90 ?? ?? ?? ?? EB 59 8B 85 E4 FA FF FF 33 C9 66 8B 8C 45 FC FD FF FF 83 E1 02 85 C9 74 35 8B 95 E4 FA FF FF 8A 82 ?? ?? ?? ?? 0C 20 8B 8D E4 FA FF FF 88 81 ?? ?? ?? ?? 8B 95 E4 FA FF FF 8B 85 E4 FA FF FF 8A 8C 05 E8 FA FF FF 88 8A ?? ?? ?? ?? EB 0D 8B 95 E4 FA FF FF C6 82 ?? ?? ?? ?? 00 E9 36 FF FF FF E9 C5 00 00 00 C7 85 E4 FA FF FF 00 00 00 00 EB 0F 8B 85 E4 FA FF FF 83 C0 01 89 85 E4 FA FF FF 81 BD E4 FA FF FF 00 01 00 00 0F 83 9A 00 00 00 83 BD E4 FA FF FF 41 72 3B 83 BD E4 FA FF FF 5A 77 32 8B 8D E4 FA FF FF 8A 91 ?? ?? ?? ?? 80 CA 10 8B 85 E4 FA FF FF 88 90 ?? ?? ?? ?? 8B 8D E4 FA FF FF 83 C1 20 8B 95 E4 FA FF FF 88 8A ?? ?? ?? ?? EB 51 83 BD E4 FA FF FF 61 72 3B 83 BD E4 FA FF FF 7A 77 32 8B 85 E4 FA FF FF 8A 88 ?? ?? ?? ?? 80 C9 20 8B 95 E4 FA FF FF 88 8A ?? ?? ?? ?? 8B 85 E4 FA FF FF 83 E8 20 8B 8D E4 FA FF FF 88 81 ?? ?? ?? ?? EB 0D 8B 95 E4 FA FF FF C6 82 ?? ?? ?? ?? 00 E9 47 FF FF FF 8B E5 5D C3 }
	condition:
		$1
}

rule file_39_5_0 {
	meta:
		name = "__getmbcp"
		size = 23
		refs = "0005 ___ismbcodepage 000d ___mbcodepage"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? 00 74 07 A1 ?? ?? ?? ?? EB 02 33 C0 5D C3 }
	condition:
		$1
}

rule file_39_6_0 {
	meta:
		name = "___initmbctable"
		size = 34
		refs = "0005 ___mbctype_initialized 000f __setmbcp"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? 00 75 14 6A FD E8 ?? ?? ?? ?? 83 C4 04 C7 05 ?? ?? ?? ?? 01 00 00 00 5D C3 }
	condition:
		$1
}

rule file_40_0_0 {
	meta:
		name = "___crtwsetenv"
		size = 750
		refs = "0014 _wcschr 0047 __wenviron 004d ___winitenv 005b _copy_environ 007c __environ 0084 ___mbtow_environ 00b5 ??_C@_08FEIK@setenv?4c?$AA@ 00be __malloc_dbg 013e _wfindenv 0171 __free_dbg 01bc __realloc_dbg 0273 _wcslen 0299 _wcscpy 02d5 __imp__SetEnvironmentVariableW@8"
	strings:
		$1 = { 55 8B EC 83 EC 18 56 83 7D 08 00 74 1F 6A 3D 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 E8 83 7D E8 00 74 08 8B 4D 08 3B 4D E8 75 08 83 C8 FF E9 B5 02 00 00 8B 55 E8 33 C0 66 8B 42 02 F7 D8 1B C0 40 89 45 EC 8B 0D ?? ?? ?? ?? 3B 0D ?? ?? ?? ?? 75 14 8B 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 04 A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 0F 85 B3 00 00 00 83 7D 0C 00 74 1F 83 3D ?? ?? ?? ?? 00 74 16 E8 ?? ?? ?? ?? 85 C0 74 08 83 C8 FF E9 55 02 00 00 E9 8E 00 00 00 83 7D EC 00 74 07 33 C0 E9 43 02 00 00 83 3D ?? ?? ?? ?? 00 75 37 68 87 00 00 00 68 ?? ?? ?? ?? 6A 02 6A 04 E8 ?? ?? ?? ?? 83 C4 10 A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 75 08 83 C8 FF E9 0E 02 00 00 A1 ?? ?? ?? ?? C7 00 00 00 00 00 83 3D ?? ?? ?? ?? 00 75 38 68 8E 00 00 00 68 ?? ?? ?? ?? 6A 02 6A 04 E8 ?? ?? ?? ?? 83 C4 10 A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 75 08 83 C8 FF E9 CE 01 00 00 8B 0D ?? ?? ?? ?? C7 01 00 00 00 00 8B 15 ?? ?? ?? ?? 89 55 F4 8B 45 E8 2B 45 08 D1 F8 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 F8 83 7D F8 00 0F 8C 93 00 00 00 8B 55 F4 83 3A 00 0F 84 87 00 00 00 83 7D EC 00 74 73 6A 02 8B 45 F8 8B 4D F4 8B 14 81 52 E8 ?? ?? ?? ?? 83 C4 08 EB 09 8B 45 F8 83 C0 01 89 45 F8 8B 4D F8 8B 55 F4 83 3C 8A 00 74 15 8B 45 F8 8B 4D F4 8B 55 F8 8B 75 F4 8B 54 96 04 89 14 81 EB D6 68 B9 00 00 00 68 ?? ?? ?? ?? 6A 02 8B 45 F8 C1 E0 02 50 8B 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 89 45 F4 83 7D F4 00 74 09 8B 55 F4 89 15 ?? ?? ?? ?? EB 0C 8B 45 F8 8B 4D F4 8B 55 08 89 14 81 EB 73 83 7D EC 00 75 66 83 7D F8 00 7D 08 8B 45 F8 F7 D8 89 45 F8 68 CE 00 00 00 68 ?? ?? ?? ?? 6A 02 8B 4D F8 8D 14 8D 08 00 00 00 52 8B 45 F4 50 E8 ?? ?? ?? ?? 83 C4 14 89 45 F4 83 7D F4 00 75 08 83 C8 FF E9 BC 00 00 00 8B 4D F8 8B 55 F4 8B 45 08 89 04 8A 8B 4D F8 8B 55 F4 C7 44 8A 04 00 00 00 00 8B 45 F4 A3 ?? ?? ?? ?? EB 07 33 C0 E9 91 00 00 00 83 7D 0C 00 0F 84 85 00 00 00 68 E5 00 00 00 68 ?? ?? ?? ?? 6A 02 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 8D 54 00 04 52 E8 ?? ?? ?? ?? 83 C4 10 89 45 F0 83 7D F0 00 74 57 8B 45 08 50 8B 4D F0 51 E8 ?? ?? ?? ?? 83 C4 08 8B 55 E8 2B 55 08 D1 FA 8B 45 F0 8D 0C 50 89 4D FC 8B 55 FC 66 C7 02 00 00 8B 45 FC 83 C0 02 89 45 FC 8B 4D EC F7 D9 1B C9 F7 D1 23 4D FC 51 8B 55 F0 52 FF 15 ?? ?? ?? ?? 6A 02 8B 45 F0 50 E8 ?? ?? ?? ?? 83 C4 08 33 C0 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_40_1_0 {
	meta:
		name = "_wfindenv"
		size = 128
		refs = "0005 __wenviron 002e __wcsnicoll"
	strings:
		$1 = { 55 8B EC 51 A1 ?? ?? ?? ?? 89 45 FC EB 09 8B 4D FC 83 C1 04 89 4D FC 8B 55 FC 83 3A 00 74 4F 8B 45 0C 50 8B 4D FC 8B 11 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 33 8B 4D FC 8B 11 8B 45 0C 33 C9 66 8B 0C 42 83 F9 3D 74 12 8B 55 FC 8B 02 8B 4D 0C 33 D2 66 8B 14 48 85 D2 75 0E 8B 45 FC 2B 05 ?? ?? ?? ?? C1 F8 02 EB 10 EB A0 8B 45 FC 2B 05 ?? ?? ?? ?? C1 F8 02 F7 D8 8B E5 5D C3 }
	condition:
		$1
}

rule file_40_2_0 {
	meta:
		name = "_copy_environ"
		size = 239
		refs = "0043 ??_C@_08FEIK@setenv?4c?$AA@ 0055 __malloc_dbg 006e __amsg_exit 0096 _wcslen 00c4 _wcscpy"
	strings:
		$1 = { 55 8B EC 83 EC 10 C7 45 F0 00 00 00 00 8B 45 08 89 45 F4 83 7D 08 00 75 07 33 C0 E9 CB 00 00 00 8B 4D F4 8B 11 8B 45 F4 83 C0 04 89 45 F4 85 D2 74 0B 8B 4D F0 83 C1 01 89 4D F0 EB E3 68 46 01 00 00 68 ?? ?? ?? ?? 6A 02 8B 55 F0 8D 04 95 04 00 00 00 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 F8 8B 4D F8 89 4D FC 83 7D FC 00 75 0A 6A 09 E8 ?? ?? ?? ?? 83 C4 04 8B 55 08 89 55 F4 8B 45 F4 83 38 00 74 5C 68 4F 01 00 00 68 ?? ?? ?? ?? 6A 02 8B 4D F4 8B 11 52 E8 ?? ?? ?? ?? 83 C4 04 8D 44 00 02 50 E8 ?? ?? ?? ?? 83 C4 10 8B 4D F8 89 01 8B 55 F8 83 3A 00 74 14 8B 45 F4 8B 08 51 8B 55 F8 8B 02 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4D F4 83 C1 04 89 4D F4 8B 55 F8 83 C2 04 89 55 F8 EB 9C 8B 45 F8 C7 00 00 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_0_0 {
	meta:
		name = "__chdir"
		size = 192
		refs = "000f __imp__SetCurrentDirectoryA@4 0029 __imp__GetCurrentDirectoryA@8 0073 __mbctoupper 009e __imp__SetEnvironmentVariableA@8 00ac __imp__GetLastError@0 00b2 __dosmaperr"
	strings:
		$1 = { 55 8B EC 81 EC 0C 01 00 00 8B 45 08 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 8F 00 00 00 8D 8D F8 FE FF FF 51 68 05 01 00 00 FF 15 ?? ?? ?? ?? 85 C0 74 79 0F BE 95 F8 FE FF FF 83 FA 5C 74 0C 0F BE 85 F8 FE FF FF 83 F8 2F 75 16 0F BE 8D F8 FE FF FF 0F BE 95 F9 FE FF FF 3B CA 75 04 33 C0 EB 5D C6 85 F4 FE FF FF 3D 8B 85 F8 FE FF FF 25 FF 00 00 00 50 E8 ?? ?? ?? ?? 83 C4 04 88 85 F5 FE FF FF C6 85 F6 FE FF FF 3A C6 85 F7 FE FF FF 00 8D 8D F8 FE FF FF 51 8D 95 F4 FE FF FF 52 FF 15 ?? ?? ?? ?? 85 C0 74 04 33 C0 EB 12 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 83 C8 FF 8B E5 5D C3 }
	condition:
		$1
}

rule file_42_0_0 {
	meta:
		name = "__set_error_mode"
		size = 76
		refs = "0022 ___error_mode"
	strings:
		$1 = { 55 8B EC 83 EC 08 8B 45 08 89 45 F8 83 7D F8 00 7C 2C 83 7D F8 02 7E 08 83 7D F8 03 74 16 EB 1E 8B 0D ?? ?? ?? ?? 89 4D FC 8B 55 08 89 15 ?? ?? ?? ?? EB 11 A1 ?? ?? ?? ?? 89 45 FC EB 07 C7 45 FC FF FF FF FF 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_43_0_0 {
	meta:
		name = "__strerror"
		size = 150
		refs = "0006 _?bldmsg@?1??_strerror@@9@9 0025 _strcat 002d ??_C@_02HFBK@?3?5?$AA@ 0040 _errno 004e __sys_nerr 006e __sys_errlist 0081 ??_C@_01BJG@?6?$AA@"
	strings:
		$1 = { 55 8B EC 51 C6 05 ?? ?? ?? ?? 00 83 7D 08 00 74 2D 8B 45 08 0F BE 08 85 C9 74 23 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 08 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 08 83 3D ?? ?? ?? ?? 00 7C 18 A1 ?? ?? ?? ?? 3B 05 ?? ?? ?? ?? 7D 0B 8B 0D ?? ?? ?? ?? 89 4D FC EB 09 8B 15 ?? ?? ?? ?? 89 55 FC 8B 45 FC 8B 0C 85 ?? ?? ?? ?? 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 08 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_44_0_0 {
	meta:
		name = "__mbctoupper"
		size = 211
		refs = "003a __mbctype 0051 ___mbcodepage 0069 ___mblcid 006f ___crtLCMapStringA 00bd __mbcasemap"
	strings:
		$1 = { 55 8B EC 83 EC 0C 81 7D 08 FF 00 00 00 0F 86 90 00 00 00 8B 45 08 C1 E8 08 25 FF 00 00 00 88 45 FC 8B 4D 08 81 E1 FF 00 00 00 88 4D FD 8B 55 FC 81 E2 FF 00 00 00 33 C0 8A 82 ?? ?? ?? ?? 83 E0 04 85 C0 75 08 8B 45 08 E9 82 00 00 00 6A 01 8B 0D ?? ?? ?? ?? 51 6A 02 8D 55 F8 52 6A 02 8D 45 FC 50 68 00 02 00 00 8B 0D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 20 85 C0 75 05 8B 45 08 EB 50 8B 55 F9 81 E2 FF 00 00 00 89 55 08 8B 45 F8 25 FF 00 00 00 C1 E0 08 8B 4D 08 03 C8 89 4D 08 8B 45 08 EB 2C 8B 55 08 33 C0 8A 82 ?? ?? ?? ?? 83 E0 20 83 F8 20 75 10 8B 4D 08 33 D2 8A 91 ?? ?? ?? ?? 89 55 F4 EB 06 8B 45 08 89 45 F4 8B 45 F4 8B E5 5D C3 }
	condition:
		$1
}

rule file_45_0_0 {
	meta:
		name = "_mblen"
		size = 226
		refs = "0008 ___mb_cur_max 0019 ??_C@_0CD@NPPL@MB_CUR_MAX?5?$DN?$DN?51?5?$HM?$HM?5MB_CUR_MAX?5?$DN?$DN@ 0022 ??_C@_07GLO@mblen?4c?$AA@ 0029 __CrtDbgReport 0062 __pctype 009c ___lc_codepage 00a3 __imp__MultiByteToWideChar@24"
	strings:
		$1 = { 55 8B EC 53 56 57 83 3D ?? ?? ?? ?? 01 74 27 83 3D ?? ?? ?? ?? 02 74 1E 68 ?? ?? ?? ?? 6A 00 6A 36 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 CA 83 7D 08 00 74 10 8B 4D 08 0F BE 11 85 D2 74 06 83 7D 0C 00 75 07 33 C0 E9 84 00 00 00 8B 45 08 33 C9 8A 08 8B 15 ?? ?? ?? ?? 33 C0 66 8B 04 4A 25 00 80 00 00 85 C0 74 42 83 3D ?? ?? ?? ?? 01 7E 2D 8B 4D 0C 3B 0D ?? ?? ?? ?? 7C 22 6A 00 6A 00 8B 15 ?? ?? ?? ?? 52 8B 45 08 50 6A 09 8B 0D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 85 C0 75 05 83 C8 FF EB 2D A1 ?? ?? ?? ?? EB 26 6A 00 6A 00 6A 01 8B 55 08 52 6A 09 A1 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 75 05 83 C8 FF EB 05 B8 01 00 00 00 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_46_0_0 {
	meta:
		name = "__get_sbh_threshold"
		size = 39
		refs = "0005 ___active_heap 000d ___sbh_threshold 001d ___old_sbh_threshold"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? 03 75 07 A1 ?? ?? ?? ?? EB 12 83 3D ?? ?? ?? ?? 02 75 07 A1 ?? ?? ?? ?? EB 02 33 C0 5D C3 }
	condition:
		$1
}

rule file_46_1_0 {
	meta:
		name = "__set_sbh_threshold"
		size = 266
		refs = "0006 ___active_heap 001a ___sbh_threshold 0052 ___old_sbh_threshold 0083 __GetLinkerVersion 00a6 ___sbh_heap_init 00e2 ___old_sbh_new_region"
	strings:
		$1 = { 55 8B EC 51 83 3D ?? ?? ?? ?? 03 75 22 81 7D 08 F8 03 00 00 77 12 8B 45 08 A3 ?? ?? ?? ?? B8 01 00 00 00 E9 DE 00 00 00 33 C0 E9 D7 00 00 00 83 3D ?? ?? ?? ?? 02 75 2F 8B 4D 08 83 C1 0F 83 E1 F0 89 4D 08 81 7D 08 80 07 00 00 77 13 8B 55 08 89 15 ?? ?? ?? ?? B8 01 00 00 00 E9 A6 00 00 00 33 C0 E9 9F 00 00 00 83 3D ?? ?? ?? ?? 01 0F 85 90 00 00 00 83 7D 08 00 0F 86 86 00 00 00 8D 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D FC 81 E1 FF 00 00 00 83 F9 06 7C 34 81 7D 08 F8 03 00 00 77 29 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 19 8B 45 08 A3 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 03 00 00 00 B8 01 00 00 00 EB 3C EB 38 8B 4D 08 83 C1 0F 83 E1 F0 89 4D 08 81 7D 08 80 07 00 00 77 23 E8 ?? ?? ?? ?? 85 C0 74 1A 8B 55 08 89 15 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 02 00 00 00 B8 01 00 00 00 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_46_2_0 {
	meta:
		name = "___sbh_heap_init"
		size = 98
		refs = "000b __crtheap 0012 __imp__HeapAlloc@12 0017 ___sbh_pHeaderList 002d ___sbh_threshold 0039 ___sbh_pHeaderScan 003f ___sbh_pHeaderDefer 0049 ___sbh_cntHeaderList 0053 ___sbh_sizeHeaderList"
	strings:
		$1 = { 55 8B EC 68 40 01 00 00 6A 00 A1 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 75 04 33 C0 EB 38 8B 4D 08 89 0D ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 89 15 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 00 00 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 C7 05 ?? ?? ?? ?? 10 00 00 00 B8 01 00 00 00 5D C3 }
	condition:
		$1
}

rule file_46_3_0 {
	meta:
		name = "___sbh_find_block"
		size = 85
		refs = "0007 ___sbh_cntHeaderList 0010 ___sbh_pHeaderList"
	strings:
		$1 = { 55 8B EC 83 EC 0C A1 ?? ?? ?? ?? 6B C0 14 8B 0D ?? ?? ?? ?? 03 C8 89 4D F4 8B 15 ?? ?? ?? ?? 89 55 F8 8B 45 F8 3B 45 F4 73 25 8B 4D F8 8B 55 08 2B 51 0C 89 55 FC 81 7D FC 00 00 10 00 73 05 8B 45 F8 EB 0D 8B 45 F8 83 C0 14 89 45 F8 EB D3 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_46_4_0 {
	meta:
		name = "___sbh_verify_block"
		size = 95
	strings:
		$1 = { 55 8B EC 83 EC 0C 8B 45 08 8B 4D 0C 2B 48 0C 89 4D F8 8B 55 F8 C1 EA 0F 89 55 FC B8 00 00 00 80 8B 4D FC D3 E8 8B 4D 08 8B 51 08 23 D0 85 D2 75 20 8B 45 F8 83 E0 0F 85 C0 75 16 8B 4D F8 81 E1 FF 0F 00 00 85 C9 74 09 C7 45 F4 01 00 00 00 EB 07 C7 45 F4 00 00 00 00 8B 45 F4 8B E5 5D C3 }
	condition:
		$1
}

rule file_46_5_0 {
	meta:
		name = "___sbh_free_block"
		size = 1500
		refs = "0479 ___sbh_pHeaderDefer 0485 ___sbh_indGroupDefer 04aa __imp__VirtualFree@12 0559 __crtheap 0560 __imp__HeapFree@12 0566 ___sbh_cntHeaderList 056e ___sbh_pHeaderList 0591 _memmove 05c3 ___sbh_pHeaderScan"
	strings:
		$1 = { 55 8B EC 83 EC 3C 8B 45 08 8B 48 10 89 4D C4 8B 55 08 8B 45 0C 2B 42 0C 89 45 F0 8B 4D F0 C1 E9 0F 89 4D FC 8B 55 FC 69 D2 04 02 00 00 8B 45 C4 8D 8C 10 44 01 00 00 89 4D F8 8B 55 0C 83 EA 04 89 55 E4 8B 45 E4 8B 08 83 E9 01 89 4D D0 8B 55 D0 83 E2 01 85 D2 74 05 E9 7B 05 00 00 8B 45 E4 03 45 D0 89 45 C8 8B 4D C8 8B 11 89 55 EC 8B 45 E4 8B 48 FC 89 4D F4 8B 55 EC 83 E2 01 85 D2 0F 85 22 01 00 00 8B 45 EC C1 F8 04 83 E8 01 89 45 DC 83 7D DC 3F 76 07 C7 45 DC 3F 00 00 00 8B 4D C8 8B 55 C8 8B 41 04 3B 42 08 0F 85 D0 00 00 00 83 7D DC 20 73 5F BA 00 00 00 80 8B 4D DC D3 EA F7 D2 8B 45 FC 8B 4D C4 8B 44 81 44 23 C2 8B 4D FC 8B 55 C4 89 44 8A 44 8B 45 C4 03 45 DC 8A 48 04 80 E9 01 8B 55 C4 03 55 DC 88 4A 04 8B 45 C4 03 45 DC 0F BE 48 04 85 C9 75 18 BA 00 00 00 80 8B 4D DC D3 EA F7 D2 8B 45 08 8B 08 23 CA 8B 55 08 89 0A EB 6B 8B 4D DC 83 E9 20 B8 00 00 00 80 D3 E8 F7 D0 8B 4D FC 8B 55 C4 8B 8C 8A C4 00 00 00 23 C8 8B 55 FC 8B 45 C4 89 8C 90 C4 00 00 00 8B 4D C4 03 4D DC 8A 51 04 80 EA 01 8B 45 C4 03 45 DC 88 50 04 8B 4D C4 03 4D DC 0F BE 51 04 85 D2 75 1D 8B 4D DC 83 E9 20 B8 00 00 00 80 D3 E8 F7 D0 8B 4D 08 8B 51 04 23 D0 8B 45 08 89 50 04 8B 4D C8 8B 51 08 8B 45 C8 8B 48 04 89 4A 04 8B 55 C8 8B 42 04 8B 4D C8 8B 51 08 89 50 08 8B 45 D0 03 45 EC 89 45 D0 8B 4D D0 C1 F9 04 83 E9 01 89 4D D8 83 7D D8 3F 76 07 C7 45 D8 3F 00 00 00 8B 55 F4 83 E2 01 85 D2 0F 85 56 01 00 00 8B 45 E4 2B 45 F4 89 45 CC 8B 4D F4 C1 F9 04 83 E9 01 89 4D D4 83 7D D4 3F 76 07 C7 45 D4 3F 00 00 00 8B 55 D0 03 55 F4 89 55 D0 8B 45 D0 C1 F8 04 83 E8 01 89 45 D8 83 7D D8 3F 76 07 C7 45 D8 3F 00 00 00 8B 4D D4 3B 4D D8 0F 84 00 01 00 00 8B 55 CC 8B 45 CC 8B 4A 04 3B 48 08 0F 85 D0 00 00 00 83 7D D4 20 73 5F BA 00 00 00 80 8B 4D D4 D3 EA F7 D2 8B 45 FC 8B 4D C4 8B 44 81 44 23 C2 8B 4D FC 8B 55 C4 89 44 8A 44 8B 45 C4 03 45 D4 8A 48 04 80 E9 01 8B 55 C4 03 55 D4 88 4A 04 8B 45 C4 03 45 D4 0F BE 48 04 85 C9 75 18 BA 00 00 00 80 8B 4D D4 D3 EA F7 D2 8B 45 08 8B 08 23 CA 8B 55 08 89 0A EB 6B 8B 4D D4 83 E9 20 B8 00 00 00 80 D3 E8 F7 D0 8B 4D FC 8B 55 C4 8B 8C 8A C4 00 00 00 23 C8 8B 55 FC 8B 45 C4 89 8C 90 C4 00 00 00 8B 4D C4 03 4D D4 8A 51 04 80 EA 01 8B 45 C4 03 45 D4 88 50 04 8B 4D C4 03 4D D4 0F BE 51 04 85 D2 75 1D 8B 4D D4 83 E9 20 B8 00 00 00 80 D3 E8 F7 D0 8B 4D 08 8B 51 04 23 D0 8B 45 08 89 50 04 8B 4D CC 8B 51 08 8B 45 CC 8B 48 04 89 4A 04 8B 55 CC 8B 42 04 8B 4D CC 8B 51 08 89 50 08 8B 45 CC 89 45 E4 8B 4D F4 83 E1 01 85 C9 75 0C 8B 55 D4 3B 55 D8 0F 84 10 01 00 00 8B 45 D8 8B 4D F8 8D 14 C1 89 55 E0 8B 45 E4 8B 4D E0 8B 51 04 89 50 04 8B 45 E4 8B 4D E0 89 48 08 8B 55 E0 8B 45 E4 89 42 04 8B 4D E4 8B 51 04 8B 45 E4 89 42 08 8B 4D E4 8B 55 E4 8B 41 04 3B 42 08 0F 85 C8 00 00 00 83 7D D8 20 73 5B 8B 4D C4 03 4D D8 0F BE 51 04 8B 45 C4 03 45 D8 8A 48 04 80 C1 01 8B 45 C4 03 45 D8 88 48 04 85 D2 75 16 BA 00 00 00 80 8B 4D D8 D3 EA 8B 45 08 8B 08 0B CA 8B 55 08 89 0A B8 00 00 00 80 8B 4D D8 D3 E8 8B 4D FC 8B 55 C4 8B 4C 8A 44 0B C8 8B 55 FC 8B 45 C4 89 4C 90 44 EB 67 8B 4D C4 03 4D D8 0F BE 51 04 8B 45 C4 03 45 D8 8A 48 04 80 C1 01 8B 45 C4 03 45 D8 88 48 04 85 D2 75 1B 8B 4D D8 83 E9 20 BA 00 00 00 80 D3 EA 8B 45 08 8B 48 04 0B CA 8B 55 08 89 4A 04 8B 4D D8 83 E9 20 B8 00 00 00 80 D3 E8 8B 4D FC 8B 55 C4 8B 8C 8A C4 00 00 00 0B C8 8B 55 FC 8B 45 C4 89 8C 90 C4 00 00 00 8B 4D E4 8B 55 D0 89 11 8B 45 E4 03 45 D0 8B 4D D0 89 48 FC 8B 55 F8 8B 02 83 E8 01 8B 4D F8 89 01 8B 55 F8 83 3A 00 0F 85 61 01 00 00 83 3D ?? ?? ?? ?? 00 0F 84 43 01 00 00 A1 ?? ?? ?? ?? C1 E0 0F 8B 0D ?? ?? ?? ?? 8B 51 0C 03 D0 89 55 E8 68 00 40 00 00 68 00 80 00 00 8B 45 E8 50 FF 15 ?? ?? ?? ?? BA 00 00 00 80 8B 0D ?? ?? ?? ?? D3 EA A1 ?? ?? ?? ?? 8B 48 08 0B CA 8B 15 ?? ?? ?? ?? 89 4A 08 A1 ?? ?? ?? ?? 8B 48 10 8B 15 ?? ?? ?? ?? C7 84 91 C4 00 00 00 00 00 00 00 A1 ?? ?? ?? ?? 8B 48 10 8A 51 43 80 EA 01 A1 ?? ?? ?? ?? 8B 48 10 88 51 43 8B 15 ?? ?? ?? ?? 8B 42 10 0F BE 48 43 85 C9 75 14 8B 15 ?? ?? ?? ?? 8B 42 04 24 FE 8B 0D ?? ?? ?? ?? 89 41 04 8B 15 ?? ?? ?? ?? 83 7A 08 FF 0F 85 92 00 00 00 68 00 80 00 00 6A 00 A1 ?? ?? ?? ?? 8B 48 0C 51 FF 15 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 8B 42 10 50 6A 00 8B 0D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 6B D2 14 A1 ?? ?? ?? ?? 03 C2 8B 0D ?? ?? ?? ?? 83 C1 14 2B C1 50 8B 15 ?? ?? ?? ?? 83 C2 14 52 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 0D ?? ?? ?? ?? 83 E9 01 89 0D ?? ?? ?? ?? 8B 55 08 3B 15 ?? ?? ?? ?? 76 09 8B 45 08 83 E8 14 89 45 08 8B 0D ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 8B 55 08 89 15 ?? ?? ?? ?? 8B 45 FC A3 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_46_6_0 {
	meta:
		name = "___sbh_alloc_block"
		size = 1334
		refs = "0008 ___sbh_cntHeaderList 0011 ___sbh_pHeaderList 0063 ___sbh_pHeaderScan 0143 ___sbh_alloc_new_region 015c ___sbh_alloc_new_group 0508 ___sbh_pHeaderDefer 0513 ___sbh_indGroupDefer"
	strings:
		$1 = { 55 8B EC 83 EC 38 56 A1 ?? ?? ?? ?? 6B C0 14 8B 0D ?? ?? ?? ?? 03 C8 89 4D D4 8B 55 08 83 C2 17 83 E2 F0 89 55 D8 8B 45 D8 C1 F8 04 83 E8 01 89 45 E0 83 7D E0 20 7D 14 83 CA FF 8B 4D E0 D3 EA 89 55 DC C7 45 CC FF FF FF FF EB 15 C7 45 DC 00 00 00 00 8B 4D E0 83 E9 20 83 C8 FF D3 E8 89 45 CC 8B 0D ?? ?? ?? ?? 89 4D E8 8B 55 E8 3B 55 D4 73 24 8B 45 E8 8B 4D DC 23 08 8B 55 E8 8B 45 CC 23 42 04 0B C8 85 C9 74 02 EB 0B 8B 4D E8 83 C1 14 89 4D E8 EB D4 8B 55 E8 3B 55 D4 0F 85 DB 00 00 00 A1 ?? ?? ?? ?? 89 45 E8 8B 4D E8 3B 0D ?? ?? ?? ?? 73 24 8B 55 E8 8B 45 DC 23 02 8B 4D E8 8B 55 CC 23 51 04 0B C2 85 C0 74 02 EB 0B 8B 45 E8 83 C0 14 89 45 E8 EB D1 8B 4D E8 3B 0D ?? ?? ?? ?? 0F 85 95 00 00 00 8B 55 E8 3B 55 D4 73 16 8B 45 E8 83 78 08 00 74 02 EB 0B 8B 4D E8 83 C1 14 89 4D E8 EB E2 8B 55 E8 3B 55 D4 75 49 A1 ?? ?? ?? ?? 89 45 E8 8B 4D E8 3B 0D ?? ?? ?? ?? 73 16 8B 55 E8 83 7A 08 00 74 02 EB 0B 8B 45 E8 83 C0 14 89 45 E8 EB DF 8B 4D E8 3B 0D ?? ?? ?? ?? 75 15 E8 ?? ?? ?? ?? 89 45 E8 83 7D E8 00 75 07 33 C0 E9 DA 03 00 00 8B 55 E8 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D E8 8B 51 10 89 02 8B 45 E8 8B 48 10 83 39 FF 75 07 33 C0 E9 B4 03 00 00 8B 55 E8 89 15 ?? ?? ?? ?? 8B 45 E8 8B 48 10 89 4D C8 8B 55 C8 8B 02 89 45 D0 83 7D D0 FF 74 23 8B 4D D0 8B 55 C8 8B 45 DC 23 44 8A 44 8B 4D D0 8B 55 C8 8B 75 CC 23 B4 8A C4 00 00 00 0B C6 85 C0 75 35 C7 45 D0 00 00 00 00 8B 45 D0 8B 4D C8 8B 55 DC 23 54 81 44 8B 45 D0 8B 4D C8 8B 75 CC 23 B4 81 C4 00 00 00 0B D6 85 D2 75 0B 8B 55 D0 83 C2 01 89 55 D0 EB D2 8B 45 D0 69 C0 04 02 00 00 8B 4D C8 8D 94 01 44 01 00 00 89 55 FC C7 45 E0 00 00 00 00 8B 45 D0 8B 4D C8 8B 55 DC 23 54 81 44 89 55 E4 83 7D E4 00 75 1A C7 45 E0 20 00 00 00 8B 45 D0 8B 4D C8 8B 55 CC 23 94 81 C4 00 00 00 89 55 E4 83 7D E4 00 7C 13 8B 45 E4 D1 E0 89 45 E4 8B 4D E0 83 C1 01 89 4D E0 EB E7 8B 55 E0 8B 45 FC 8B 4C D0 04 89 4D F0 8B 55 F0 8B 02 2B 45 D8 89 45 F8 8B 4D F8 C1 F9 04 83 E9 01 89 4D EC 83 7D EC 3F 7E 07 C7 45 EC 3F 00 00 00 8B 55 EC 3B 55 E0 0F 84 18 02 00 00 8B 45 F0 8B 4D F0 8B 50 04 3B 51 08 0F 85 D0 00 00 00 83 7D E0 20 7D 5F B8 00 00 00 80 8B 4D E0 D3 E8 F7 D0 8B 4D D0 8B 55 C8 8B 4C 8A 44 23 C8 8B 55 D0 8B 45 C8 89 4C 90 44 8B 4D C8 03 4D E0 8A 51 04 80 EA 01 8B 45 C8 03 45 E0 88 50 04 8B 4D C8 03 4D E0 0F BE 51 04 85 D2 75 18 B8 00 00 00 80 8B 4D E0 D3 E8 F7 D0 8B 4D E8 8B 11 23 D0 8B 45 E8 89 10 EB 6B 8B 4D E0 83 E9 20 BA 00 00 00 80 D3 EA F7 D2 8B 45 D0 8B 4D C8 8B 84 81 C4 00 00 00 23 C2 8B 4D D0 8B 55 C8 89 84 8A C4 00 00 00 8B 45 C8 03 45 E0 8A 48 04 80 E9 01 8B 55 C8 03 55 E0 88 4A 04 8B 45 C8 03 45 E0 0F BE 48 04 85 C9 75 1D 8B 4D E0 83 E9 20 BA 00 00 00 80 D3 EA F7 D2 8B 45 E8 8B 48 04 23 CA 8B 55 E8 89 4A 04 8B 45 F0 8B 48 08 8B 55 F0 8B 42 04 89 41 04 8B 4D F0 8B 51 04 8B 45 F0 8B 48 08 89 4A 08 83 7D F8 00 0F 84 0E 01 00 00 8B 55 EC 8B 45 FC 8D 0C D0 89 4D F4 8B 55 F0 8B 45 F4 8B 48 04 89 4A 04 8B 55 F0 8B 45 F4 89 42 08 8B 4D F4 8B 55 F0 89 51 04 8B 45 F0 8B 48 04 8B 55 F0 89 51 08 8B 45 F0 8B 4D F0 8B 50 04 3B 51 08 0F 85 C6 00 00 00 83 7D EC 20 7D 5A 8B 45 C8 03 45 EC 0F BE 48 04 8B 55 C8 03 55 EC 8A 42 04 04 01 8B 55 C8 03 55 EC 88 42 04 85 C9 75 16 B8 00 00 00 80 8B 4D EC D3 E8 8B 4D E8 8B 11 0B D0 8B 45 E8 89 10 BA 00 00 00 80 8B 4D EC D3 EA 8B 45 D0 8B 4D C8 8B 44 81 44 0B C2 8B 4D D0 8B 55 C8 89 44 8A 44 EB 66 8B 45 C8 03 45 EC 0F BE 48 04 8B 55 C8 03 55 EC 8A 42 04 04 01 8B 55 C8 03 55 EC 88 42 04 85 C9 75 1B 8B 4D EC 83 E9 20 B8 00 00 00 80 D3 E8 8B 4D E8 8B 51 04 0B D0 8B 45 E8 89 50 04 8B 4D EC 83 E9 20 BA 00 00 00 80 D3 EA 8B 45 D0 8B 4D C8 8B 84 81 C4 00 00 00 0B C2 8B 4D D0 8B 55 C8 89 84 8A C4 00 00 00 83 7D F8 00 74 14 8B 45 F0 8B 4D F8 89 08 8B 55 F0 03 55 F8 8B 45 F8 89 42 FC 8B 4D F0 03 4D F8 89 4D F0 8B 55 D8 83 C2 01 8B 45 F0 89 10 8B 4D D8 83 C1 01 8B 55 F0 03 55 D8 89 4A FC 8B 45 FC 8B 08 8B 55 FC 8B 02 83 C0 01 8B 55 FC 89 02 85 C9 75 20 8B 45 E8 3B 05 ?? ?? ?? ?? 75 15 8B 4D D0 3B 0D ?? ?? ?? ?? 75 0A C7 05 ?? ?? ?? ?? 00 00 00 00 8B 55 C8 8B 45 D0 89 02 8B 45 F0 83 C0 04 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_46_7_0 {
	meta:
		name = "___sbh_alloc_new_region"
		size = 271
		refs = "0005 ___sbh_cntHeaderList 000b ___sbh_sizeHeaderList 0020 ___sbh_pHeaderList 0028 __crtheap 002f __imp__HeapReAlloc@16 007e __imp__HeapAlloc@12 00a5 __imp__VirtualAlloc@16 00ca __imp__HeapFree@12"
	strings:
		$1 = { 55 8B EC 51 A1 ?? ?? ?? ?? 3B 05 ?? ?? ?? ?? 75 4A 8B 0D ?? ?? ?? ?? 83 C1 10 6B C9 14 51 8B 15 ?? ?? ?? ?? 52 6A 00 A1 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 75 07 33 C0 E9 C8 00 00 00 8B 4D FC 89 0D ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 83 C2 10 89 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? 6B C0 14 8B 0D ?? ?? ?? ?? 03 C8 89 4D FC 68 C4 41 00 00 6A 08 8B 15 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 8B 4D FC 89 41 10 8B 55 FC 83 7A 10 00 75 04 33 C0 EB 76 6A 04 68 00 20 00 00 68 00 00 10 00 6A 00 FF 15 ?? ?? ?? ?? 8B 4D FC 89 41 0C 8B 55 FC 83 7A 0C 00 75 1A 8B 45 FC 8B 48 10 51 6A 00 8B 15 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 33 C0 EB 39 8B 45 FC C7 00 00 00 00 00 8B 4D FC C7 41 04 00 00 00 00 8B 55 FC C7 42 08 FF FF FF FF A1 ?? ?? ?? ?? 83 C0 01 A3 ?? ?? ?? ?? 8B 4D FC 8B 51 10 C7 02 FF FF FF FF 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_46_8_0 {
	meta:
		name = "___sbh_alloc_new_group"
		size = 494
		refs = "00a9 __imp__VirtualAlloc@16"
	strings:
		$1 = { 55 8B EC 83 EC 2C 8B 45 08 8B 48 10 89 4D D4 8B 55 08 8B 42 08 89 45 F8 C7 45 D8 00 00 00 00 83 7D F8 00 7C 13 8B 4D F8 D1 E1 89 4D F8 8B 55 D8 83 C2 01 89 55 D8 EB E7 8B 45 D8 69 C0 04 02 00 00 8B 4D D4 8D 94 01 44 01 00 00 89 55 F4 C7 45 E0 00 00 00 00 EB 09 8B 45 E0 83 C0 01 89 45 E0 83 7D E0 3F 7D 20 8B 4D E0 8B 55 F4 8D 04 CA 89 45 E8 8B 4D E8 8B 55 E8 89 51 08 8B 45 E8 8B 4D E8 89 48 04 EB D1 8B 55 D8 C1 E2 0F 8B 45 08 8B 48 0C 03 CA 89 4D F0 6A 04 68 00 10 00 00 68 00 80 00 00 8B 55 F0 52 FF 15 ?? ?? ?? ?? 85 C0 75 08 83 C8 FF E9 31 01 00 00 8B 45 F0 05 00 70 00 00 89 45 E4 8B 4D F0 89 4D FC EB 0C 8B 55 FC 81 C2 00 10 00 00 89 55 FC 8B 45 FC 3B 45 E4 77 5D 8B 4D FC C7 41 08 FF FF FF FF 8B 55 FC C7 82 FC 0F 00 00 FF FF FF FF 8B 45 FC 83 C0 0C 89 45 E8 8B 4D E8 C7 01 F0 0F 00 00 8B 55 E8 81 C2 00 10 00 00 8B 45 E8 89 50 04 8B 4D E8 81 E9 00 10 00 00 8B 55 E8 89 4A 08 8B 45 E8 05 EC 0F 00 00 89 45 DC 8B 4D DC C7 01 F0 0F 00 00 EB 8F 8B 55 F4 81 C2 F8 01 00 00 89 55 EC 8B 45 F0 83 C0 0C 8B 4D EC 89 41 04 8B 55 EC 8B 42 04 89 45 E8 8B 4D E8 8B 55 EC 89 51 08 8B 45 E4 83 C0 0C 8B 4D EC 89 41 08 8B 55 EC 8B 42 08 89 45 E8 8B 4D E8 8B 55 EC 89 51 04 8B 45 D8 8B 4D D4 C7 44 81 44 00 00 00 00 8B 55 D8 8B 45 D4 C7 84 90 C4 00 00 00 01 00 00 00 8B 4D D4 0F BE 51 43 8B 45 D4 8A 48 43 80 C1 01 8B 45 D4 88 48 43 85 D2 75 0F 8B 4D 08 8B 51 04 83 CA 01 8B 45 08 89 50 04 BA 00 00 00 80 8B 4D D8 D3 EA F7 D2 8B 45 08 8B 48 08 23 CA 8B 55 08 89 4A 08 8B 45 D8 8B E5 5D C3 }
	condition:
		$1
}

rule file_46_9_0 {
	meta:
		name = "___sbh_resize_block"
		size = 1515
	strings:
		$1 = { 55 8B EC 83 EC 30 8B 45 10 83 C0 17 24 F0 89 45 E4 8B 4D 08 8B 51 10 89 55 D0 8B 45 08 8B 4D 0C 2B 48 0C 89 4D F4 8B 55 F4 C1 EA 0F 89 55 FC 8B 45 FC 69 C0 04 02 00 00 8B 4D D0 8D 94 01 44 01 00 00 89 55 F8 8B 45 0C 83 E8 04 89 45 EC 8B 4D EC 8B 11 83 EA 01 89 55 D8 8B 45 EC 03 45 D8 89 45 D4 8B 4D D4 8B 11 89 55 F0 8B 45 E4 3B 45 D8 0F 8E B0 02 00 00 8B 4D F0 83 E1 01 85 C9 75 0B 8B 55 D8 03 55 F0 39 55 E4 7E 07 33 C0 E9 55 05 00 00 8B 45 F0 C1 F8 04 83 E8 01 89 45 E0 83 7D E0 3F 76 07 C7 45 E0 3F 00 00 00 8B 4D D4 8B 55 D4 8B 41 04 3B 42 08 0F 85 D0 00 00 00 83 7D E0 20 73 5F BA 00 00 00 80 8B 4D E0 D3 EA F7 D2 8B 45 FC 8B 4D D0 8B 44 81 44 23 C2 8B 4D FC 8B 55 D0 89 44 8A 44 8B 45 D0 03 45 E0 8A 48 04 80 E9 01 8B 55 D0 03 55 E0 88 4A 04 8B 45 D0 03 45 E0 0F BE 48 04 85 C9 75 18 BA 00 00 00 80 8B 4D E0 D3 EA F7 D2 8B 45 08 8B 08 23 CA 8B 55 08 89 0A EB 6B 8B 4D E0 83 E9 20 B8 00 00 00 80 D3 E8 F7 D0 8B 4D FC 8B 55 D0 8B 8C 8A C4 00 00 00 23 C8 8B 55 FC 8B 45 D0 89 8C 90 C4 00 00 00 8B 4D D0 03 4D E0 8A 51 04 80 EA 01 8B 45 D0 03 45 E0 88 50 04 8B 4D D0 03 4D E0 0F BE 51 04 85 D2 75 1D 8B 4D E0 83 E9 20 B8 00 00 00 80 D3 E8 F7 D0 8B 4D 08 8B 51 04 23 D0 8B 45 08 89 50 04 8B 4D D4 8B 51 08 8B 45 D4 8B 48 04 89 4A 04 8B 55 D4 8B 42 04 8B 4D D4 8B 51 08 89 50 08 8B 45 D8 03 45 F0 2B 45 E4 89 45 F0 83 7D F0 00 0F 8E 46 01 00 00 8B 4D EC 03 4D E4 89 4D D4 8B 55 F0 C1 FA 04 83 EA 01 89 55 E0 83 7D E0 3F 76 07 C7 45 E0 3F 00 00 00 8B 45 E0 8B 4D F8 8D 14 C1 89 55 E8 8B 45 D4 8B 4D E8 8B 51 04 89 50 04 8B 45 D4 8B 4D E8 89 48 08 8B 55 E8 8B 45 D4 89 42 04 8B 4D D4 8B 51 04 8B 45 D4 89 42 08 8B 4D D4 8B 55 D4 8B 41 04 3B 42 08 0F 85 C8 00 00 00 83 7D E0 20 73 5B 8B 4D D0 03 4D E0 0F BE 51 04 8B 45 D0 03 45 E0 8A 48 04 80 C1 01 8B 45 D0 03 45 E0 88 48 04 85 D2 75 16 BA 00 00 00 80 8B 4D E0 D3 EA 8B 45 08 8B 08 0B CA 8B 55 08 89 0A B8 00 00 00 80 8B 4D E0 D3 E8 8B 4D FC 8B 55 D0 8B 4C 8A 44 0B C8 8B 55 FC 8B 45 D0 89 4C 90 44 EB 67 8B 4D D0 03 4D E0 0F BE 51 04 8B 45 D0 03 45 E0 8A 48 04 80 C1 01 8B 45 D0 03 45 E0 88 48 04 85 D2 75 1B 8B 4D E0 83 E9 20 BA 00 00 00 80 D3 EA 8B 45 08 8B 48 04 0B CA 8B 55 08 89 4A 04 8B 4D E0 83 E9 20 B8 00 00 00 80 D3 E8 8B 4D FC 8B 55 D0 8B 8C 8A C4 00 00 00 0B C8 8B 55 FC 8B 45 D0 89 8C 90 C4 00 00 00 8B 4D D4 8B 55 F0 89 11 8B 45 D4 03 45 F0 8B 4D F0 89 48 FC 8B 55 E4 83 C2 01 8B 45 EC 89 10 8B 4D E4 83 C1 01 8B 55 EC 03 55 E4 89 4A FC E9 BC 02 00 00 8B 45 E4 3B 45 D8 0F 8D B0 02 00 00 8B 4D E4 83 C1 01 8B 55 EC 89 0A 8B 45 E4 83 C0 01 8B 4D EC 03 4D E4 89 41 FC 8B 55 EC 03 55 E4 89 55 EC 8B 45 D8 2B 45 E4 89 45 D8 8B 4D D8 C1 F9 04 83 E9 01 89 4D DC 83 7D DC 3F 76 07 C7 45 DC 3F 00 00 00 8B 55 F0 83 E2 01 85 D2 0F 85 3B 01 00 00 8B 45 F0 C1 F8 04 83 E8 01 89 45 E0 83 7D E0 3F 76 07 C7 45 E0 3F 00 00 00 8B 4D D4 8B 55 D4 8B 41 04 3B 42 08 0F 85 D0 00 00 00 83 7D E0 20 73 5F BA 00 00 00 80 8B 4D E0 D3 EA F7 D2 8B 45 FC 8B 4D D0 8B 44 81 44 23 C2 8B 4D FC 8B 55 D0 89 44 8A 44 8B 45 D0 03 45 E0 8A 48 04 80 E9 01 8B 55 D0 03 55 E0 88 4A 04 8B 45 D0 03 45 E0 0F BE 48 04 85 C9 75 18 BA 00 00 00 80 8B 4D E0 D3 EA F7 D2 8B 45 08 8B 08 23 CA 8B 55 08 89 0A EB 6B 8B 4D E0 83 E9 20 B8 00 00 00 80 D3 E8 F7 D0 8B 4D FC 8B 55 D0 8B 8C 8A C4 00 00 00 23 C8 8B 55 FC 8B 45 D0 89 8C 90 C4 00 00 00 8B 4D D0 03 4D E0 8A 51 04 80 EA 01 8B 45 D0 03 45 E0 88 50 04 8B 4D D0 03 4D E0 0F BE 51 04 85 D2 75 1D 8B 4D E0 83 E9 20 B8 00 00 00 80 D3 E8 F7 D0 8B 4D 08 8B 51 04 23 D0 8B 45 08 89 50 04 8B 4D D4 8B 51 08 8B 45 D4 8B 48 04 89 4A 04 8B 55 D4 8B 42 04 8B 4D D4 8B 51 08 89 50 08 8B 45 D8 03 45 F0 89 45 D8 8B 4D D8 C1 F9 04 83 E9 01 89 4D DC 83 7D DC 3F 76 07 C7 45 DC 3F 00 00 00 8B 55 DC 8B 45 F8 8D 0C D0 89 4D E8 8B 55 EC 8B 45 E8 8B 48 04 89 4A 04 8B 55 EC 8B 45 E8 89 42 08 8B 4D E8 8B 55 EC 89 51 04 8B 45 EC 8B 48 04 8B 55 EC 89 51 08 8B 45 EC 8B 4D EC 8B 50 04 3B 51 08 0F 85 C6 00 00 00 83 7D DC 20 73 5A 8B 45 D0 03 45 DC 0F BE 48 04 8B 55 D0 03 55 DC 8A 42 04 04 01 8B 55 D0 03 55 DC 88 42 04 85 C9 75 16 B8 00 00 00 80 8B 4D DC D3 E8 8B 4D 08 8B 11 0B D0 8B 45 08 89 10 BA 00 00 00 80 8B 4D DC D3 EA 8B 45 FC 8B 4D D0 8B 44 81 44 0B C2 8B 4D FC 8B 55 D0 89 44 8A 44 EB 66 8B 45 D0 03 45 DC 0F BE 48 04 8B 55 D0 03 55 DC 8A 42 04 04 01 8B 55 D0 03 55 DC 88 42 04 85 C9 75 1B 8B 4D DC 83 E9 20 B8 00 00 00 80 D3 E8 8B 4D 08 8B 51 04 0B D0 8B 45 08 89 50 04 8B 4D DC 83 E9 20 BA 00 00 00 80 D3 EA 8B 45 FC 8B 4D D0 8B 84 81 C4 00 00 00 0B C2 8B 4D FC 8B 55 D0 89 84 8A C4 00 00 00 8B 45 EC 8B 4D D8 89 08 8B 55 EC 03 55 D8 8B 45 D8 89 42 FC B8 01 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_46_10_0 {
	meta:
		name = "___sbh_heapmin"
		size = 304
		refs = "0006 ___sbh_pHeaderDefer 0012 ___sbh_indGroupDefer 0037 __imp__VirtualFree@12 00c0 ___sbh_cntHeaderList 00d4 __crtheap 00db __imp__HeapFree@12 00e9 ___sbh_pHeaderList 010c _memmove"
	strings:
		$1 = { 55 8B EC 51 83 3D ?? ?? ?? ?? 00 0F 84 1B 01 00 00 A1 ?? ?? ?? ?? C1 E0 0F 8B 0D ?? ?? ?? ?? 8B 51 0C 03 D0 89 55 FC 68 00 40 00 00 68 00 80 00 00 8B 45 FC 50 FF 15 ?? ?? ?? ?? BA 00 00 00 80 8B 0D ?? ?? ?? ?? D3 EA A1 ?? ?? ?? ?? 8B 48 08 0B CA 8B 15 ?? ?? ?? ?? 89 4A 08 A1 ?? ?? ?? ?? 8B 48 10 8B 15 ?? ?? ?? ?? C7 84 91 C4 00 00 00 00 00 00 00 A1 ?? ?? ?? ?? 8B 48 10 8A 51 43 80 EA 01 A1 ?? ?? ?? ?? 8B 48 10 88 51 43 8B 15 ?? ?? ?? ?? 8B 42 10 0F BE 48 43 85 C9 75 14 8B 15 ?? ?? ?? ?? 8B 42 04 24 FE 8B 0D ?? ?? ?? ?? 89 41 04 8B 15 ?? ?? ?? ?? 83 7A 08 FF 75 64 83 3D ?? ?? ?? ?? 01 7E 5B A1 ?? ?? ?? ?? 8B 48 10 51 6A 00 8B 15 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? 6B C0 14 8B 0D ?? ?? ?? ?? 03 C8 8B 15 ?? ?? ?? ?? 83 C2 14 2B CA 51 A1 ?? ?? ?? ?? 83 C0 14 50 8B 0D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 15 ?? ?? ?? ?? 83 EA 01 89 15 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 00 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_46_11_0 {
	meta:
		name = "___sbh_heap_check"
		size = 1565
		refs = "000a ___sbh_cntHeaderList 0014 ___sbh_pHeaderList 001b __imp__IsBadWritePtr@8"
	strings:
		$1 = { 55 8B EC 81 EC 68 01 00 00 A1 ?? ?? ?? ?? 6B C0 14 50 8B 0D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 85 C0 74 08 83 C8 FF E9 EE 05 00 00 8B 15 ?? ?? ?? ?? 89 95 C4 FE FF FF C7 85 E0 FE FF FF 00 00 00 00 EB 0F 8B 85 E0 FE FF FF 83 C0 01 89 85 E0 FE FF FF 8B 8D E0 FE FF FF 3B 0D ?? ?? ?? ?? 0F 8D B3 05 00 00 8B 95 C4 FE FF FF 8B 42 10 89 85 A0 FE FF FF 68 C4 41 00 00 8B 8D A0 FE FF FF 51 FF 15 ?? ?? ?? ?? 85 C0 74 0A B8 FE FF FF FF E9 86 05 00 00 8B 95 C4 FE FF FF 8B 42 0C 89 85 D8 FE FF FF 8B 8D A0 FE FF FF 81 C1 44 01 00 00 89 4D E8 8B 95 C4 FE FF FF 8B 42 08 89 45 FC C7 85 BC FE FF FF 00 00 00 00 C7 85 A8 FE FF FF 00 00 00 00 C7 45 F4 00 00 00 00 EB 09 8B 4D F4 83 C1 01 89 4D F4 83 7D F4 20 0F 8D EE 04 00 00 C7 85 E4 FE FF FF 00 00 00 00 C7 85 B0 FE FF FF 00 00 00 00 C7 85 D4 FE FF FF 00 00 00 00 C7 85 B4 FE FF FF 00 00 00 00 EB 0F 8B 95 B4 FE FF FF 83 C2 01 89 95 B4 FE FF FF 83 BD B4 FE FF FF 40 7D 13 8B 85 B4 FE FF FF C7 84 85 E8 FE FF FF 00 00 00 00 EB D5 83 7D FC 00 0F 8C 31 04 00 00 68 00 80 00 00 8B 8D D8 FE FF FF 51 FF 15 ?? ?? ?? ?? 85 C0 74 0A B8 FC FF FF FF E9 AD 04 00 00 8B 95 D8 FE FF FF 89 55 F8 C7 85 C0 FE FF FF 00 00 00 00 EB 0F 8B 85 C0 FE FF FF 83 C0 01 89 85 C0 FE FF FF 83 BD C0 FE FF FF 08 0F 8D 77 01 00 00 8B 4D F8 83 C1 0C 89 8D D0 FE FF FF 8B 95 D0 FE FF FF 81 C2 F0 0F 00 00 89 95 C8 FE FF FF 8B 85 D0 FE FF FF 83 78 FC FF 75 0B 8B 8D C8 FE FF FF 83 39 FF 74 0A B8 FB FF FF FF E9 3D 04 00 00 8B 95 D0 FE FF FF 8B 02 89 85 B8 FE FF FF 8B 8D B8 FE FF FF 89 8D AC FE FF FF 8B 95 AC FE FF FF 83 E2 01 85 D2 74 36 8B 85 B8 FE FF FF 83 E8 01 89 85 B8 FE FF FF 81 BD B8 FE FF FF 00 04 00 00 7E 0A B8 FA FF FF FF E9 F1 03 00 00 8B 8D D4 FE FF FF 83 C1 01 89 8D D4 FE FF FF EB 42 8B 95 B8 FE FF FF C1 FA 04 83 EA 01 89 95 B4 FE FF FF 83 BD B4 FE FF FF 3F 7E 0A C7 85 B4 FE FF FF 3F 00 00 00 8B 85 B4 FE FF FF 8B 8C 85 E8 FE FF FF 83 C1 01 8B 95 B4 FE FF FF 89 8C 95 E8 FE FF FF 83 BD B8 FE FF FF 10 7C 19 8B 85 B8 FE FF FF 83 E0 0F 85 C0 75 0C 81 BD B8 FE FF FF F0 0F 00 00 7E 0A B8 F9 FF FF FF E9 72 03 00 00 8B 8D D0 FE FF FF 03 8D B8 FE FF FF 8B 51 FC 3B 95 AC FE FF FF 74 0A B8 F8 FF FF FF E9 51 03 00 00 8B 85 D0 FE FF FF 03 85 B8 FE FF FF 89 85 D0 FE FF FF 8B 8D D0 FE FF FF 3B 8D C8 FE FF FF 0F 82 F0 FE FF FF 8B 95 D0 FE FF FF 3B 95 C8 FE FF FF 74 0A B8 F8 FF FF FF E9 15 03 00 00 8B 45 F8 05 00 10 00 00 89 45 F8 E9 6D FE FF FF 8B 4D E8 8B 11 3B 95 D4 FE FF FF 74 0A B8 F7 FF FF FF E9 EE 02 00 00 8B 45 E8 89 85 CC FE FF FF C7 45 EC 00 00 00 00 EB 09 8B 4D EC 83 C1 01 89 4D EC 83 7D EC 40 0F 8D 2D 02 00 00 C7 85 98 FE FF FF 00 00 00 00 8B 95 CC FE FF FF 89 95 D0 FE FF FF 8B 85 D0 FE FF FF 8B 48 04 89 8D A4 FE FF FF 8B 95 A4 FE FF FF 3B 95 CC FE FF FF 0F 84 23 01 00 00 8B 45 EC 8B 8D 98 FE FF FF 3B 8C 85 E8 FE FF FF 0F 84 0D 01 00 00 8B 95 A4 FE FF FF 3B 95 D8 FE FF FF 72 13 8B 85 D8 FE FF FF 05 00 80 00 00 39 85 A4 FE FF FF 72 0A B8 F6 FF FF FF E9 51 02 00 00 8B 8D A4 FE FF FF 81 E1 00 F0 FF FF 89 8D 9C FE FF FF 8B 95 9C FE FF FF 83 C2 0C 89 55 F0 8B 45 F0 05 F0 0F 00 00 89 85 DC FE FF FF 8B 4D F0 3B 8D DC FE FF FF 74 1F 8B 55 F0 3B 95 A4 FE FF FF 75 02 EB 12 8B 45 F0 8B 08 83 E1 FE 8B 55 F0 03 D1 89 55 F0 EB D6 8B 45 F0 3B 85 DC FE FF FF 75 0A B8 F5 FF FF FF E9 E6 01 00 00 8B 8D A4 FE FF FF 8B 11 C1 FA 04 83 EA 01 89 95 B4 FE FF FF 83 BD B4 FE FF FF 3F 7E 0A C7 85 B4 FE FF FF 3F 00 00 00 8B 85 B4 FE FF FF 3B 45 EC 74 0A B8 F4 FF FF FF E9 AA 01 00 00 8B 8D A4 FE FF FF 8B 51 08 3B 95 D0 FE FF FF 74 0A B8 F3 FF FF FF E9 8F 01 00 00 8B 85 A4 FE FF FF 89 85 D0 FE FF FF 8B 8D 98 FE FF FF 83 C1 01 89 8D 98 FE FF FF E9 BC FE FF FF 83 BD 98 FE FF FF 00 74 6E 83 7D EC 20 7D 32 BA 00 00 00 80 8B 4D EC D3 EA 8B 85 E4 FE FF FF 0B C2 89 85 E4 FE FF FF BA 00 00 00 80 8B 4D EC D3 EA 8B 85 BC FE FF FF 0B C2 89 85 BC FE FF FF EB 36 8B 4D EC 83 E9 20 BA 00 00 00 80 D3 EA 8B 85 B0 FE FF FF 0B C2 89 85 B0 FE FF FF 8B 4D EC 83 E9 20 BA 00 00 00 80 D3 EA 8B 85 A8 FE FF FF 0B C2 89 85 A8 FE FF FF 8B 8D D0 FE FF FF 8B 51 04 3B 95 CC FE FF FF 75 12 8B 45 EC 8B 8D 98 FE FF FF 3B 8C 85 E8 FE FF FF 74 0A B8 F2 FF FF FF E9 CB 00 00 00 8B 95 CC FE FF FF 8B 42 08 3B 85 D0 FE FF FF 74 0A B8 F1 FF FF FF E9 B0 00 00 00 8B 8D CC FE FF FF 83 C1 08 89 8D CC FE FF FF E9 C0 FD FF FF 8B 55 F4 8B 85 A0 FE FF FF 8B 8D E4 FE FF FF 3B 4C 90 44 75 18 8B 55 F4 8B 85 A0 FE FF FF 8B 8D B0 FE FF FF 3B 8C 90 C4 00 00 00 74 07 B8 F0 FF FF FF EB 68 8B 95 D8 FE FF FF 81 C2 00 80 00 00 89 95 D8 FE FF FF 8B 45 E8 05 04 02 00 00 89 45 E8 8B 4D FC D1 E1 89 4D FC E9 FF FA FF FF 8B 95 C4 FE FF FF 8B 85 BC FE FF FF 3B 02 75 11 8B 8D C4 FE FF FF 8B 95 A8 FE FF FF 3B 51 04 74 07 B8 EF FF FF FF EB 16 8B 85 C4 FE FF FF 83 C0 14 89 85 C4 FE FF FF E9 2C FA FF FF 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_46_13_0 {
	meta:
		name = "__set_old_sbh_threshold"
		size = 43
		refs = "001c ___old_sbh_threshold"
	strings:
		$1 = { 55 8B EC 8B 45 08 83 C0 0F 24 F0 89 45 08 81 7D 08 80 07 00 00 77 10 8B 4D 08 89 0D ?? ?? ?? ?? B8 01 00 00 00 EB 02 33 C0 5D C3 }
	condition:
		$1
}

rule file_46_14_0 {
	meta:
		name = "___old_sbh_new_region"
		size = 478
		refs = "0008 ___old_small_block_heap 0020 __crtheap 0027 __imp__HeapAlloc@12 004b __imp__VirtualAlloc@16 0161 _memset 01b8 __imp__VirtualFree@12 01d4 __imp__HeapFree@12"
	strings:
		$1 = { 55 8B EC 83 EC 0C 83 3D ?? ?? ?? ?? FF 75 09 C7 45 F4 ?? ?? ?? ?? EB 23 68 20 20 00 00 6A 00 A1 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 89 45 F4 83 7D F4 00 75 07 33 C0 E9 9F 01 00 00 6A 04 68 00 20 00 00 68 00 00 40 00 6A 00 FF 15 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 0F 84 60 01 00 00 6A 04 68 00 10 00 00 68 00 00 01 00 8B 4D FC 51 FF 15 ?? ?? ?? ?? 85 C0 0F 84 31 01 00 00 81 7D F4 ?? ?? ?? ?? 75 28 83 3D ?? ?? ?? ?? 00 75 0A C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 75 0A C7 05 ?? ?? ?? ?? ?? ?? ?? ?? EB 29 8B 55 F4 C7 02 ?? ?? ?? ?? 8B 45 F4 8B 0D ?? ?? ?? ?? 89 48 04 8B 55 F4 89 15 ?? ?? ?? ?? 8B 45 F4 8B 48 04 8B 55 F4 89 11 8B 45 F4 8B 4D FC 89 48 10 8B 55 FC 81 C2 00 00 40 00 8B 45 F4 89 50 14 8B 4D F4 83 C1 18 8B 55 F4 89 4A 08 8B 45 F4 05 98 00 00 00 8B 4D F4 89 41 0C C7 45 F8 00 00 00 00 EB 09 8B 55 F8 83 C2 01 89 55 F8 81 7D F8 00 04 00 00 7D 34 83 7D F8 10 7D 10 8B 45 F8 8B 4D F4 C7 44 C1 18 F0 00 00 00 EB 0E 8B 55 F8 8B 45 F4 C7 44 D0 18 FF FF FF FF 8B 4D F8 8B 55 F4 C7 44 CA 1C F1 00 00 00 EB BA 68 00 00 01 00 6A 00 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D F4 8B 51 10 81 C2 00 00 01 00 39 55 FC 73 2D 8B 45 FC 83 C0 08 8B 4D FC 89 01 8B 55 FC C7 42 04 F0 00 00 00 8B 45 FC C6 80 F8 00 00 00 FF 8B 4D FC 81 C1 00 10 00 00 89 4D FC EB C2 8B 45 F4 EB 2F 68 00 80 00 00 6A 00 8B 55 FC 52 FF 15 ?? ?? ?? ?? 81 7D F4 ?? ?? ?? ?? 74 13 8B 45 F4 50 6A 00 8B 0D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_46_15_0 {
	meta:
		name = "___old_sbh_release_region"
		size = 115
		refs = "0013 __imp__VirtualFree@12 0019 ___old_sbh_p_starting_region 0031 ___old_small_block_heap 005a __crtheap 0061 __imp__HeapFree@12"
	strings:
		$1 = { 55 8B EC 68 00 80 00 00 6A 00 8B 45 08 8B 48 10 51 FF 15 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 3B 55 08 75 0C 8B 45 08 8B 48 04 89 0D ?? ?? ?? ?? 81 7D 08 ?? ?? ?? ?? 74 30 8B 55 08 8B 42 04 8B 4D 08 8B 11 89 10 8B 45 08 8B 08 8B 55 08 8B 42 04 89 41 04 8B 4D 08 51 6A 00 8B 15 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? EB 0A C7 05 ?? ?? ?? ?? FF FF FF FF 5D C3 }
	condition:
		$1
}

rule file_46_16_0 {
	meta:
		name = "___old_sbh_decommit_pages"
		size = 343
		refs = "0007 ___old_small_block_heap 007a __imp__VirtualFree@12 008c ___old_sbh_decommitable_pages 0137 ___old_sbh_release_region"
	strings:
		$1 = { 55 8B EC 83 EC 14 A1 ?? ?? ?? ?? 89 45 EC 8B 4D EC 83 79 10 FF 0F 84 23 01 00 00 C7 45 F4 FF 03 00 00 C7 45 F0 00 00 00 00 8B 55 F4 8B 45 EC 8D 4C D0 18 89 4D FC EB 12 8B 55 F4 83 EA 01 89 55 F4 8B 45 FC 83 E8 08 89 45 FC 83 7D F4 00 0F 8C 80 00 00 00 8B 4D FC 81 39 F0 00 00 00 75 70 68 00 40 00 00 68 00 10 00 00 8B 55 F4 C1 E2 0C 8B 45 EC 8B 48 10 03 CA 51 FF 15 ?? ?? ?? ?? 85 C0 74 4D 8B 55 FC C7 02 FF FF FF FF A1 ?? ?? ?? ?? 83 E8 01 A3 ?? ?? ?? ?? 8B 4D EC 83 79 0C 00 74 0B 8B 55 EC 8B 42 0C 3B 45 FC 76 09 8B 4D EC 8B 55 FC 89 51 0C 8B 45 F0 83 C0 01 89 45 F0 8B 4D 08 83 E9 01 89 4D 08 83 7D 08 00 75 02 EB 05 E9 64 FF FF FF 8B 55 EC 89 55 F8 8B 45 EC 8B 48 04 89 4D EC 83 7D F0 00 74 55 8B 55 F8 83 7A 18 FF 75 4C C7 45 F4 01 00 00 00 8B 45 F8 83 C0 20 89 45 FC EB 12 8B 4D F4 83 C1 01 89 4D F4 8B 55 FC 83 C2 08 89 55 FC 81 7D F4 00 04 00 00 7D 0A 8B 45 FC 83 38 FF 75 02 EB DB 81 7D F4 00 04 00 00 75 0C 8B 4D F8 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 EC 3B 15 ?? ?? ?? ?? 74 0A 83 7D 08 00 0F 8F BB FE FF FF 8B E5 5D C3 }
	condition:
		$1
}

rule file_46_17_0 {
	meta:
		name = "___old_sbh_find_block"
		size = 144
		refs = "0009 ___old_small_block_heap"
	strings:
		$1 = { 55 8B EC 83 EC 08 C7 45 F8 ?? ?? ?? ?? 8B 45 F8 8B 4D 08 3B 48 10 76 61 8B 55 F8 8B 45 08 3B 42 14 73 56 8B 4D 08 83 E1 0F 85 C9 75 48 8B 55 08 81 E2 FF 0F 00 00 33 C0 05 00 01 00 00 3B D0 72 34 8B 4D 0C 8B 55 F8 89 11 8B 45 08 25 00 F0 FF FF 89 45 FC 8B 4D 10 8B 55 FC 89 11 8B 45 FC 05 00 01 00 00 8B 4D 08 2B C8 C1 F9 04 8B 55 FC 8D 44 0A 08 EB 17 33 C0 EB 13 8B 45 F8 8B 08 89 4D F8 81 7D F8 ?? ?? ?? ?? 75 83 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_46_18_0 {
	meta:
		name = "___old_sbh_free_block"
		size = 108
		refs = "0049 ___old_sbh_decommitable_pages 0061 ___old_sbh_decommit_pages"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 8B 4D 0C 2B 48 10 C1 F9 0C 8B 55 08 8D 44 CA 18 89 45 FC 8B 4D 10 33 D2 8A 11 8B 45 FC 8B 08 03 CA 8B 55 FC 89 0A 8B 45 10 C6 00 00 8B 4D FC C7 41 04 F1 00 00 00 8B 55 FC 81 3A F0 00 00 00 75 20 A1 ?? ?? ?? ?? 83 C0 01 A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 20 75 0A 6A 10 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_46_19_0 {
	meta:
		name = "___old_sbh_alloc_block"
		size = 952
		refs = "0007 ___old_sbh_p_starting_region 008f ___old_sbh_alloc_block_from_page 0191 ___old_small_block_heap 0219 __imp__VirtualAlloc@16 0234 _memset 034d ___old_sbh_new_region"
	strings:
		$1 = { 55 8B EC 83 EC 20 A1 ?? ?? ?? ?? 89 45 E0 8B 4D E0 83 79 10 FF 0F 84 5C 01 00 00 8B 55 E0 8B 42 08 89 45 FC 8B 4D E0 81 C1 18 20 00 00 89 4D F0 8B 55 E0 83 C2 18 8B 45 FC 2B C2 C1 F8 03 C1 E0 0C 8B 4D E0 8B 51 10 03 D0 89 55 F8 EB 15 8B 45 FC 83 C0 08 89 45 FC 8B 4D F8 81 C1 00 10 00 00 89 4D F8 8B 55 FC 3B 55 F0 73 69 8B 45 FC 8B 08 3B 4D 08 7C 5A 8B 55 FC 8B 42 04 3B 45 08 76 4F 8B 4D 08 51 8B 55 FC 8B 02 50 8B 4D F8 51 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F4 83 7D F4 00 74 27 8B 55 E0 89 15 ?? ?? ?? ?? 8B 45 FC 8B 08 2B 4D 08 8B 55 FC 89 0A 8B 45 E0 8B 4D FC 89 48 08 8B 45 F4 E9 EE 02 00 00 8B 55 FC 8B 45 08 89 42 04 E9 7A FF FF FF 8B 4D E0 83 C1 18 89 4D FC 8B 55 E0 8B 42 08 89 45 F0 8B 4D E0 8B 51 10 89 55 F8 EB 15 8B 45 FC 83 C0 08 89 45 FC 8B 4D F8 81 C1 00 10 00 00 89 4D F8 8B 55 FC 3B 55 F0 73 69 8B 45 FC 8B 08 3B 4D 08 7C 5A 8B 55 FC 8B 42 04 3B 45 08 76 4F 8B 4D 08 51 8B 55 FC 8B 02 50 8B 4D F8 51 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F4 83 7D F4 00 74 27 8B 55 E0 89 15 ?? ?? ?? ?? 8B 45 FC 8B 08 2B 4D 08 8B 55 FC 89 0A 8B 45 E0 8B 4D FC 89 48 08 8B 45 F4 E9 4B 02 00 00 8B 55 FC 8B 45 08 89 42 04 E9 7A FF FF FF 8B 4D E0 8B 11 89 55 E0 8B 45 E0 3B 05 ?? ?? ?? ?? 0F 85 80 FE FF FF C7 45 E0 ?? ?? ?? ?? 8B 4D E0 83 79 10 FF 0F 84 95 01 00 00 8B 55 E0 83 7A 0C 00 0F 84 88 01 00 00 8B 45 E0 8B 48 0C 89 4D FC 8B 55 E0 83 C2 18 8B 45 FC 2B C2 C1 F8 03 C1 E0 0C 8B 4D E0 8B 51 10 03 D0 89 55 F8 C7 45 EC 00 00 00 00 8B 45 FC 89 45 F0 EB 12 8B 4D F0 83 C1 08 89 4D F0 8B 55 EC 83 C2 01 89 55 EC 8B 45 F0 83 38 FF 75 08 83 7D EC 10 7D 02 EB DE 6A 04 68 00 10 00 00 8B 4D EC C1 E1 0C 51 8B 55 F8 52 FF 15 ?? ?? ?? ?? 3B 45 F8 0F 85 0D 01 00 00 6A 00 8B 45 EC C1 E0 0C 50 8B 4D F8 51 E8 ?? ?? ?? ?? 83 C4 0C C7 45 E8 00 00 00 00 8B 55 F8 89 55 E4 8B 45 FC 89 45 F0 EB 1E 8B 4D E8 83 C1 01 89 4D E8 8B 55 E4 81 C2 00 10 00 00 89 55 E4 8B 45 F0 83 C0 08 89 45 F0 8B 4D E8 3B 4D EC 7D 34 8B 55 E4 83 C2 08 8B 45 E4 89 10 8B 4D E4 C7 41 04 F0 00 00 00 8B 55 E4 C6 82 F8 00 00 00 FF 8B 45 F0 C7 00 F0 00 00 00 8B 4D F0 C7 41 04 F1 00 00 00 EB A6 8B 55 E0 89 15 ?? ?? ?? ?? 8B 45 E0 05 18 20 00 00 39 45 F0 73 13 8B 4D F0 83 39 FF 74 0B 8B 55 F0 83 C2 08 89 55 F0 EB E0 8B 45 E0 05 18 20 00 00 39 45 F0 1B C9 23 4D F0 8B 55 E0 89 4A 0C 8B 45 F8 8A 4D 08 88 48 08 8B 55 E0 8B 45 FC 89 42 08 8B 4D FC 8B 11 2B 55 08 8B 45 FC 89 10 8B 4D 08 8B 55 F8 8D 44 0A 08 8B 4D F8 89 01 8B 55 F8 8B 42 04 2B 45 08 8B 4D F8 89 41 04 8B 45 F8 05 00 01 00 00 E9 81 00 00 00 33 C0 EB 7D 8B 55 E0 8B 02 89 45 E0 81 7D E0 ?? ?? ?? ?? 0F 85 49 FE FF FF E8 ?? ?? ?? ?? 89 45 E0 83 7D E0 00 74 58 8B 4D E0 8B 51 10 89 55 F8 8B 45 F8 8A 4D 08 88 48 08 8B 55 E0 89 15 ?? ?? ?? ?? 8B 45 08 8B 4D F8 8D 54 01 08 8B 45 F8 89 10 B9 F0 00 00 00 2B 4D 08 8B 55 F8 89 4A 04 8B 45 08 25 FF 00 00 00 8B 4D E0 8B 51 18 2B D0 8B 45 E0 89 50 18 8B 45 F8 05 00 01 00 00 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_46_20_0 {
	meta:
		name = "___old_sbh_alloc_block_from_page"
		size = 681
	strings:
		$1 = { 55 8B EC 83 EC 14 8B 45 08 8B 08 89 4D FC 8B 55 FC 89 55 F8 8B 45 08 05 F8 00 00 00 89 45 EC 8B 4D 08 8B 51 04 3B 55 10 72 63 8B 45 F8 8A 4D 10 88 08 8B 55 F8 03 55 10 3B 55 EC 73 1E 8B 45 08 8B 08 03 4D 10 8B 55 08 89 0A 8B 45 08 8B 48 04 2B 4D 10 8B 55 08 89 4A 04 EB 15 8B 45 08 83 C0 08 8B 4D 08 89 01 8B 55 08 C7 42 04 00 00 00 00 8B 45 08 83 C0 08 8B 4D F8 2B C8 C1 E1 04 8B 55 08 8D 84 0A 00 01 00 00 E9 18 02 00 00 8B 45 08 8B 48 04 8B 55 F8 33 C0 8A 04 0A 85 C0 74 0C 8B 4D 08 8B 55 F8 03 51 04 89 55 F8 8B 45 F8 03 45 10 3B 45 EC 0F 83 EF 00 00 00 8B 4D F8 33 D2 8A 11 85 D2 0F 85 CC 00 00 00 8B 45 F8 83 C0 01 89 45 F4 C7 45 F0 01 00 00 00 EB 12 8B 4D F4 83 C1 01 89 4D F4 8B 55 F0 83 C2 01 89 55 F0 8B 45 F4 33 C9 8A 08 85 C9 75 02 EB E1 8B 55 F0 3B 55 10 73 33 8B 45 F8 3B 45 FC 75 0B 8B 4D 08 8B 55 F0 89 51 04 EB 18 8B 45 0C 2B 45 F0 89 45 0C 8B 4D 0C 3B 4D 10 73 07 33 C0 E9 78 01 00 00 8B 55 F4 89 55 F8 EB 5E 8B 45 F8 03 45 10 3B 45 EC 73 19 8B 4D F8 03 4D 10 8B 55 08 89 0A 8B 45 F0 2B 45 10 8B 4D 08 89 41 04 EB 15 8B 55 08 83 C2 08 8B 45 08 89 10 8B 4D 08 C7 41 04 00 00 00 00 8B 55 F8 8A 45 10 88 02 8B 4D 08 83 C1 08 8B 55 F8 2B D1 C1 E2 04 8B 45 08 8D 84 10 00 01 00 00 E9 12 01 00 00 EB 0F 8B 4D F8 33 D2 8A 11 8B 45 F8 03 C2 89 45 F8 E9 02 FF FF FF 8B 4D 08 83 C1 08 89 4D F8 8B 55 F8 3B 55 FC 0F 83 E5 00 00 00 8B 45 F8 03 45 10 3B 45 EC 0F 83 D6 00 00 00 8B 4D F8 33 D2 8A 11 85 D2 0F 85 B3 00 00 00 8B 45 F8 83 C0 01 89 45 F4 C7 45 F0 01 00 00 00 EB 12 8B 4D F4 83 C1 01 89 4D F4 8B 55 F0 83 C2 01 89 55 F0 8B 45 F4 33 C9 8A 08 85 C9 75 02 EB E1 8B 55 F0 3B 55 10 73 1D 8B 45 0C 2B 45 F0 89 45 0C 8B 4D 0C 3B 4D 10 73 04 33 C0 EB 7B 8B 55 F4 89 55 F8 EB 5B 8B 45 F8 03 45 10 3B 45 EC 73 19 8B 4D F8 03 4D 10 8B 55 08 89 0A 8B 45 F0 2B 45 10 8B 4D 08 89 41 04 EB 15 8B 55 08 83 C2 08 8B 45 08 89 10 8B 4D 08 C7 41 04 00 00 00 00 8B 55 F8 8A 45 10 88 02 8B 4D 08 83 C1 08 8B 55 F8 2B D1 C1 E2 04 8B 45 08 8D 84 10 00 01 00 00 EB 18 EB 0F 8B 4D F8 33 D2 8A 11 8B 45 F8 03 C2 89 45 F8 E9 0F FF FF FF 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_46_21_0 {
	meta:
		name = "___old_sbh_resize_block"
		size = 356
	strings:
		$1 = { 55 8B EC 83 EC 18 C7 45 EC 00 00 00 00 8B 45 08 8B 4D 0C 2B 48 10 C1 F9 0C 8B 55 08 8D 44 CA 18 89 45 FC 8B 4D 10 33 D2 8A 11 89 55 F4 8B 45 F4 3B 45 14 76 32 8B 4D 10 8A 55 14 88 11 8B 45 F4 2B 45 14 8B 4D FC 8B 11 03 D0 8B 45 FC 89 10 8B 4D FC C7 41 04 F1 00 00 00 8B 55 EC 83 C2 01 89 55 EC E9 F6 00 00 00 8B 45 F4 3B 45 14 0F 83 EA 00 00 00 8B 4D 10 03 4D 14 8B 55 0C 81 C2 F8 00 00 00 3B CA 0F 87 D3 00 00 00 8B 45 10 03 45 F4 89 45 F0 8B 4D 10 03 4D 14 89 4D E8 EB 09 8B 55 F0 83 C2 01 89 55 F0 8B 45 F0 3B 45 E8 73 0D 8B 4D F0 33 D2 8A 11 85 D2 75 02 EB E2 8B 45 F0 3B 45 E8 0F 85 95 00 00 00 8B 4D 10 8A 55 14 88 11 8B 45 0C 8B 4D 10 3B 08 77 68 8B 55 0C 8B 45 E8 3B 02 76 5E 8B 4D 0C 81 C1 F8 00 00 00 39 4D E8 73 3B 8B 55 0C 8B 45 E8 89 02 C7 45 F8 00 00 00 00 EB 12 8B 4D F8 83 C1 01 89 4D F8 8B 55 E8 83 C2 01 89 55 E8 8B 45 E8 33 C9 8A 08 85 C9 75 02 EB E1 8B 55 0C 8B 45 F8 89 42 04 EB 15 8B 4D 0C 83 C1 08 8B 55 0C 89 0A 8B 45 0C C7 40 04 00 00 00 00 8B 4D F4 2B 4D 14 8B 55 FC 8B 02 03 C1 8B 4D FC 89 01 8B 55 EC 83 C2 01 89 55 EC 8B 45 EC 8B E5 5D C3 }
	condition:
		$1
}

rule file_46_22_0 {
	meta:
		name = "___old_sbh_heap_check"
		size = 567
		refs = "0010 ___old_small_block_heap 0015 ___old_sbh_p_starting_region"
	strings:
		$1 = { 55 8B EC 83 EC 28 C7 45 F8 00 00 00 00 C7 45 E4 ?? ?? ?? ?? A1 ?? ?? ?? ?? 3B 45 E4 75 09 8B 4D F8 83 C1 01 89 4D F8 8B 55 E4 8B 42 10 89 45 FC 83 7D FC FF 0F 84 D5 01 00 00 C7 45 F4 00 00 00 00 C7 45 D8 00 00 00 00 8B 4D E4 8B 51 10 89 55 FC EB 15 8B 45 F4 83 C0 01 89 45 F4 8B 4D FC 81 C1 00 10 00 00 89 4D FC 81 7D F4 00 04 00 00 0F 8D 9A 01 00 00 8B 55 F4 8B 45 E4 83 7C D0 18 FF 75 2E 83 7D D8 00 75 1A 8B 4D F4 8B 55 E4 8D 44 CA 18 8B 4D E4 39 41 0C 74 08 83 C8 FF E9 91 01 00 00 8B 55 D8 83 C2 01 89 55 D8 E9 5A 01 00 00 8B 45 FC 05 F8 00 00 00 8B 4D FC 39 01 72 0A B8 FE FF FF FF E9 6A 01 00 00 8B 55 FC 33 C0 8A 82 F8 00 00 00 3D FF 00 00 00 74 0A B8 FD FF FF FF E9 4E 01 00 00 C7 45 F0 00 00 00 00 C7 45 E8 00 00 00 00 C7 45 DC 00 00 00 00 C7 45 E0 00 00 00 00 81 7D F0 F0 00 00 00 0F 8D D9 00 00 00 8B 4D F0 8B 55 FC 8D 44 0A 08 8B 4D FC 3B 01 75 09 8B 55 E8 83 C2 01 89 55 E8 8B 45 FC 03 45 F0 33 C9 8A 48 08 85 C9 75 20 8B 55 DC 83 C2 01 89 55 DC 8B 45 E0 83 C0 01 89 45 E0 8B 4D F0 83 C1 01 89 4D F0 E9 8B 00 00 00 8B 55 F4 8B 45 E4 8B 4D E0 3B 4C D0 1C 7C 0A B8 FC FF FF FF E9 C3 00 00 00 83 7D E8 01 75 1E 8B 55 FC 8B 45 E0 3B 42 04 7D 0A B8 FB FF FF FF E9 A8 00 00 00 8B 4D E8 83 C1 01 89 4D E8 C7 45 E0 00 00 00 00 8B 55 F0 83 C2 01 89 55 EC EB 09 8B 45 EC 83 C0 01 89 45 EC 8B 4D FC 03 4D F0 33 D2 8A 51 08 8B 45 F0 03 C2 39 45 EC 7D 18 8B 4D FC 03 4D EC 33 D2 8A 51 08 85 D2 74 07 B8 FA FF FF FF EB 59 EB CA 8B 45 EC 89 45 F0 E9 1A FF FF FF 8B 4D F4 8B 55 E4 8B 45 DC 3B 44 CA 18 74 07 B8 F9 FF FF FF EB 36 83 7D E8 00 75 07 B8 F8 FF FF FF EB 29 E9 44 FE FF FF 8B 4D E4 8B 11 89 55 E4 81 7D E4 ?? ?? ?? ?? 0F 85 F0 FD FF FF 83 7D F8 00 75 07 B8 F7 FF FF FF EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_47_0_0 {
	meta:
		name = "__heapchk"
		size = 130
		refs = "000d ___active_heap 0015 ___sbh_heap_check 0030 ___old_sbh_heap_check 0044 __crtheap 004b __imp__HeapValidate@12 0055 __imp__GetLastError@0 0060 __doserrno 006a _errno"
	strings:
		$1 = { 55 8B EC 51 C7 45 FC FE FF FF FF 83 3D ?? ?? ?? ?? 03 75 12 E8 ?? ?? ?? ?? 85 C0 7D 07 C7 45 FC FC FF FF FF EB 19 83 3D ?? ?? ?? ?? 02 75 10 E8 ?? ?? ?? ?? 85 C0 7D 07 C7 45 FC FC FF FF FF 6A 00 6A 00 A1 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 75 28 FF 15 ?? ?? ?? ?? 83 F8 78 75 16 C7 05 ?? ?? ?? ?? 78 00 00 00 C7 05 ?? ?? ?? ?? 28 00 00 00 EB 07 C7 45 FC FC FF FF FF 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_48_0_0 {
	meta:
		name = "__assert"
		size = 894
		refs = "000e ___error_mode 0020 ___app_type 0028 __iob 0041 _setvbuf 0055 __assertstring 005f _fprintf 006c _fflush 0079 ??_C@_0BC@OIMC@Assertion?5failed?$CB?$AA@ 0085 _strcpy 008e _dblnewline 009b _strcat 00a3 ??_C@_09PIFG@Program?3?5?$AA@ 00c6 __imp__GetModuleFileNameA@12 00cf ??_C@_0BH@NNCD@?$DMprogram?5name?5unknown?$DO?$AA@ 00f6 _strlen 0127 _dotdotdot 0134 _strncpy 0153 _newline 0168 ??_C@_06FAAO@File?3?5?$AA@ 019d _strncat 01e6 ??_C@_06JMOL@Line?3?5?$AA@ 0217 __itoa 0235 ??_C@_0N@NOAB@Expression?3?5?$AA@ 02e5 ??_C@_0HA@EJLJ@For?5information?5on?5how?5your?5prog@ 030f ??_C@_0DN@MHHJ@?$CIPress?5Retry?5to?5debug?5the?5applic@ 0328 ??_C@_0CF@JPDF@Microsoft?5Visual?5C?$CL?$CL?5Runtime?5Lib@ 0334 ___crtMessageBoxA 034d _raise 0357 __exit 0373 _abort"
	strings:
		$1 = { 55 8B EC 81 EC 28 03 00 00 53 56 57 83 3D ?? ?? ?? ?? 01 74 12 83 3D ?? ?? ?? ?? 00 75 5A 83 3D ?? ?? ?? ?? 01 75 51 A1 ?? ?? ?? ?? 25 0C 01 00 00 85 C0 75 13 6A 00 6A 04 6A 00 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 E9 FA 02 00 00 68 ?? ?? ?? ?? 8D 8D E4 FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 08 8B 15 ?? ?? ?? ?? 52 8D 85 E4 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 08 68 ?? ?? ?? ?? 8D 8D E4 FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 08 68 04 01 00 00 8D 95 DC FC FF FF 52 6A 00 FF 15 ?? ?? ?? ?? 85 C0 75 14 68 ?? ?? ?? ?? 8D 85 DC FC FF FF 50 E8 ?? ?? ?? ?? 83 C4 08 8D 8D DC FC FF FF 89 8D E0 FD FF FF 8D 95 DC FC FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 83 C0 0B 83 F8 3C 76 36 8D 85 DC FC FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 8B 8D E0 FD FF FF 8D 54 01 CF 89 95 E0 FD FF FF 6A 03 A1 ?? ?? ?? ?? 50 8B 8D E0 FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 95 E0 FD FF FF 52 8D 85 E4 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 08 8B 0D ?? ?? ?? ?? 51 8D 95 E4 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 68 ?? ?? ?? ?? 8D 85 E4 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 04 83 C0 08 83 F8 3C 76 2D 6A 31 8B 55 0C 52 8D 85 E4 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 0D ?? ?? ?? ?? 51 8D 95 E4 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 EB 13 8B 45 0C 50 8D 8D E4 FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 08 8B 15 ?? ?? ?? ?? 52 8D 85 E4 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 08 68 ?? ?? ?? ?? 8D 8D E4 FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 08 6A 0A 8D 95 E4 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 8D 84 05 E4 FD FF FF 50 8B 4D 10 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 15 ?? ?? ?? ?? 52 8D 85 E4 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 08 68 ?? ?? ?? ?? 8D 8D E4 FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 08 8D 95 E4 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 8B F0 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 8D 8C 06 B0 00 00 00 81 F9 1C 02 00 00 76 47 8D 95 E4 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 05 B3 00 00 00 B9 1C 02 00 00 2B C8 51 8B 55 08 52 8D 85 E4 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 0D ?? ?? ?? ?? 51 8D 95 E4 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 EB 13 8B 45 08 50 8D 8D E4 FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 08 8B 15 ?? ?? ?? ?? 52 8D 85 E4 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 08 68 ?? ?? ?? ?? 8D 8D E4 FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 08 8B 15 ?? ?? ?? ?? 52 8D 85 E4 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 08 68 ?? ?? ?? ?? 8D 8D E4 FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 08 68 12 20 01 00 68 ?? ?? ?? ?? 8D 95 E4 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 89 85 D8 FC FF FF 83 BD D8 FC FF FF 03 75 11 6A 16 E8 ?? ?? ?? ?? 83 C4 04 6A 03 E8 ?? ?? ?? ?? 83 BD D8 FC FF FF 04 75 03 CC EB 10 83 BD D8 FC FF FF 05 75 02 EB 05 E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_49_0_0 {
	meta:
		name = "_wcsxfrm"
		size = 286
		refs = "000f ___lc_handle 0023 _wcsncpy 002f _wcslen 003e ??_C@_09NOMD@wcsxfrm?4c?$AA@ 0049 __malloc_dbg 0060 ___lc_collate_cp 007f ___crtLCMapStringW 0110 __free_dbg"
	strings:
		$1 = { 55 8B EC 83 EC 0C C7 45 FC FF FF FF 7F 83 3D ?? ?? ?? ?? 00 75 25 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 04 E9 DF 00 00 00 6A 5E 68 ?? ?? ?? ?? 6A 02 8B 4D 10 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 F8 83 7D F8 00 75 05 E9 AB 00 00 00 8B 15 ?? ?? ?? ?? 52 8B 45 10 50 8B 4D F8 51 6A FF 8B 55 0C 52 68 00 04 00 00 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 1C 89 45 FC 83 7D FC 00 75 41 8B 0D ?? ?? ?? ?? 51 6A 00 6A 00 6A FF 8B 55 0C 52 68 00 04 00 00 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 1C 89 45 FC 83 7D FC 00 75 09 C7 45 FC FF FF FF 7F EB 09 8B 4D FC 83 E9 01 89 4D FC EB 39 C7 45 F4 00 00 00 00 EB 09 8B 55 F4 83 C2 01 89 55 F4 8B 45 F4 3B 45 FC 7D 16 8B 4D F8 03 4D F4 66 0F B6 11 8B 45 F4 8B 4D 08 66 89 14 41 EB D9 8B 55 FC 83 EA 01 89 55 FC 6A 02 8B 45 F8 50 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_50_0_0 {
	meta:
		name = "__alldiv"
		size = 33
	strings:
		$1 = { 57 56 53 33 FF 8B 44 24 14 0B C0 7D 14 47 8B 54 24 10 F7 D8 F7 DA 83 D8 00 89 44 24 14 89 54 24 10 }
	condition:
		$1
}

rule file_50_1_0 {
	meta:
		name = "L1"
		size = 28
	strings:
		$1 = { 8B 44 24 1C 0B C0 7D 14 47 8B 54 24 18 F7 D8 F7 DA 83 D8 00 89 44 24 1C 89 54 24 18 }
	condition:
		$1
}

rule file_50_2_0 {
	meta:
		name = "L2"
		size = 28
	strings:
		$1 = { 0B C0 75 18 8B 4C 24 18 8B 44 24 14 33 D2 F7 F1 8B D8 8B 44 24 10 F7 F1 8B D3 EB 41 }
	condition:
		$1
}

rule file_50_4_0 {
	meta:
		name = "L5"
		size = 46
	strings:
		$1 = { D1 EB D1 D9 D1 EA D1 D8 0B DB 75 F4 F7 F1 8B F0 F7 64 24 1C 8B C8 8B 44 24 18 F7 E6 03 D1 72 0E 3B 54 24 14 77 08 72 07 3B 44 24 10 76 01 }
	condition:
		$1
}

rule file_51_0_0 {
	meta:
		name = "___crtCompareStringA"
		size = 1016
		refs = "0006 $T17304 000b __except_handler3 0011 __except_list 0028 _?f_use@?1??__crtCompareStringA@@9@9 0032 ??_C@_13A@?$AA?$AA?$AA?$AA@ 0043 __imp__CompareStringW@24 005a ??_C@_01A@?$AA?$AA@ 006b __imp__CompareStringA@24 0095 _strncnt 00f9 ___lc_codepage 014c __imp__GetCPInfo@8 0174 ??_C@_0DN@PPKB@cchCount1?$DN?$DN0?5?$CG?$CG?5cchCount2?$DN?$DN1?5?$HM?$HM?5@ 0180 ??_C@_07FOIK@a_cmp?4c?$AA@ 0187 __CrtDbgReport 02a0 __imp__MultiByteToWideChar@24 02c6 __alloca_probe"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 C4 C8 53 56 57 89 65 E8 83 3D ?? ?? ?? ?? 00 75 57 6A 01 68 ?? ?? ?? ?? 6A 01 68 ?? ?? ?? ?? 6A 00 6A 00 FF 15 ?? ?? ?? ?? 85 C0 74 0C C7 05 ?? ?? ?? ?? 01 00 00 00 EB 2F 6A 01 68 ?? ?? ?? ?? 6A 01 68 ?? ?? ?? ?? 6A 00 6A 00 FF 15 ?? ?? ?? ?? 85 C0 74 0C C7 05 ?? ?? ?? ?? 02 00 00 00 EB 07 33 C0 E9 5E 03 00 00 83 7D 14 00 7E 13 8B 45 14 50 8B 4D 10 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 14 83 7D 1C 00 7E 13 8B 55 1C 52 8B 45 18 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 1C 83 3D ?? ?? ?? ?? 02 75 23 8B 4D 1C 51 8B 55 18 52 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 FF 15 ?? ?? ?? ?? E9 00 03 00 00 83 3D ?? ?? ?? ?? 01 0F 85 F1 02 00 00 83 7D 20 00 75 09 8B 0D ?? ?? ?? ?? 89 4D 20 83 7D 14 00 74 0A 83 7D 1C 00 0F 85 7C 01 00 00 8B 55 14 3B 55 1C 75 0A B8 02 00 00 00 E9 C2 02 00 00 83 7D 1C 01 7E 0A B8 01 00 00 00 E9 B2 02 00 00 83 7D 14 01 7E 0A B8 03 00 00 00 E9 A2 02 00 00 8D 45 C4 50 8B 4D 20 51 FF 15 ?? ?? ?? ?? 85 C0 75 07 33 C0 E9 89 02 00 00 83 7D 14 00 75 06 83 7D 1C 01 74 2D 83 7D 14 01 75 06 83 7D 1C 00 74 21 68 ?? ?? ?? ?? 6A 00 68 B6 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 D2 85 D2 75 C1 83 7D 14 00 7E 73 83 7D C4 02 73 0A B8 03 00 00 00 E9 34 02 00 00 8D 45 CA 89 45 C0 EB 09 8B 4D C0 83 C1 02 89 4D C0 8B 55 C0 33 C0 8A 02 85 C0 74 3D 8B 4D C0 33 D2 8A 51 01 85 D2 74 31 8B 45 10 33 C9 8A 08 8B 55 C0 33 C0 8A 02 3B C8 7C 1D 8B 4D 10 33 D2 8A 11 8B 45 C0 33 C9 8A 48 01 3B D1 7F 0A B8 02 00 00 00 E9 DD 01 00 00 EB AF B8 03 00 00 00 E9 D1 01 00 00 83 7D 1C 00 7E 73 83 7D C4 02 73 0A B8 01 00 00 00 E9 BB 01 00 00 8D 55 CA 89 55 C0 EB 09 8B 45 C0 83 C0 02 89 45 C0 8B 4D C0 33 D2 8A 11 85 D2 74 3D 8B 45 C0 33 C9 8A 48 01 85 C9 74 31 8B 55 18 33 C0 8A 02 8B 4D C0 33 D2 8A 11 3B C2 7C 1D 8B 45 18 33 C9 8A 08 8B 55 C0 33 C0 8A 42 01 3B C8 7F 0A B8 02 00 00 00 E9 64 01 00 00 EB AF B8 01 00 00 00 E9 58 01 00 00 6A 00 6A 00 8B 4D 14 51 8B 55 10 52 6A 09 8B 45 20 50 FF 15 ?? ?? ?? ?? 89 45 E4 83 7D E4 00 75 07 33 C0 E9 30 01 00 00 C7 45 FC 00 00 00 00 8B 45 E4 D1 E0 83 C0 03 24 FC E8 ?? ?? ?? ?? 89 65 BC 89 65 E8 8B 4D BC 89 4D DC C7 45 FC FF FF FF FF EB 17 B8 01 00 00 00 C3 8B 65 E8 C7 45 DC 00 00 00 00 C7 45 FC FF FF FF FF 83 7D DC 00 75 07 33 C0 E9 E1 00 00 00 8B 55 E4 52 8B 45 DC 50 8B 4D 14 51 8B 55 10 52 6A 01 8B 45 20 50 FF 15 ?? ?? ?? ?? 85 C0 75 07 33 C0 E9 BA 00 00 00 6A 00 6A 00 8B 4D 1C 51 8B 55 18 52 6A 09 8B 45 20 50 FF 15 ?? ?? ?? ?? 89 45 E0 83 7D E0 00 75 07 33 C0 E9 92 00 00 00 C7 45 FC 01 00 00 00 8B 45 E0 D1 E0 83 C0 03 24 FC E8 ?? ?? ?? ?? 89 65 B8 89 65 E8 8B 4D B8 89 4D D8 C7 45 FC FF FF FF FF EB 17 B8 01 00 00 00 C3 8B 65 E8 C7 45 D8 00 00 00 00 C7 45 FC FF FF FF FF 83 7D D8 00 75 04 33 C0 EB 46 8B 55 E0 52 8B 45 D8 50 8B 4D 1C 51 8B 55 18 52 6A 01 8B 45 20 50 FF 15 ?? ?? ?? ?? 85 C0 75 04 33 C0 EB 22 8B 4D E0 51 8B 55 D8 52 8B 45 E4 50 8B 4D DC 51 8B 55 0C 52 8B 45 08 50 FF 15 ?? ?? ?? ?? EB 02 33 C0 8D 65 AC 8B 4D F0 64 89 0D ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_52_0_0 {
	meta:
		name = "__mbsrchr"
		size = 187
		refs = "000f ___ismbcodepage 001f _strrchr 0042 __mbctype"
	strings:
		$1 = { 55 8B EC 83 EC 08 C7 45 FC 00 00 00 00 83 3D ?? ?? ?? ?? 00 75 15 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 E9 8C 00 00 00 8B 55 08 33 C0 8A 02 89 45 F8 8B 4D F8 81 E1 FF 00 00 00 33 D2 8A 91 ?? ?? ?? ?? 83 E2 04 85 D2 74 41 8B 45 08 83 C0 01 89 45 08 8B 4D 08 33 D2 8A 11 85 D2 74 1F 8B 45 F8 C1 E0 08 8B 4D 08 33 D2 8A 11 0B C2 39 45 0C 75 09 8B 45 08 83 E8 01 89 45 FC EB 0C 83 7D FC 00 75 06 8B 4D 08 89 4D FC EB 0E 8B 55 0C 3B 55 F8 75 06 8B 45 08 89 45 FC 8B 4D 08 33 D2 8A 11 8B 45 08 83 C0 01 89 45 08 85 D2 0F 85 77 FF FF FF 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_53_0_0 {
	meta:
		name = "__mbsicmp"
		size = 616
		refs = "0008 ___ismbcodepage 0018 __stricmp 0045 __mbctype 006a ___mbcodepage 0084 ___mblcid 008a ___crtLCMapStringA 0102 __mbcasemap"
	strings:
		$1 = { 55 8B EC 83 EC 18 83 3D ?? ?? ?? ?? 00 75 15 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 E9 40 02 00 00 8B 55 08 66 0F B6 02 66 89 45 FC 8B 4D 08 83 C1 01 89 4D 08 8B 55 FC 81 E2 FF 00 00 00 33 C0 8A 82 ?? ?? ?? ?? 83 E0 04 85 C0 0F 84 88 00 00 00 8B 4D 08 33 D2 8A 11 85 D2 75 08 66 C7 45 FC 00 00 EB 73 6A 01 A1 ?? ?? ?? ?? 50 6A 02 8D 4D F4 51 6A 02 8B 55 08 83 EA 01 52 68 00 02 00 00 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 20 89 45 F0 83 7D F0 01 75 0B 66 0F B6 4D F4 66 89 4D FC EB 2C 83 7D F0 02 75 1C 8B 55 F4 81 E2 FF 00 00 00 C1 E2 08 8B 45 F5 25 FF 00 00 00 03 D0 66 89 55 FC EB 0A B8 FF FF FF 7F E9 93 01 00 00 8B 4D 08 83 C1 01 89 4D 08 EB 42 8B 55 FC 81 E2 FF FF 00 00 33 C0 8A 82 ?? ?? ?? ?? 83 E0 10 83 F8 10 75 16 8B 4D FC 81 E1 FF FF 00 00 33 D2 8A 91 ?? ?? ?? ?? 89 55 EC EB 0B 8B 45 FC 25 FF FF 00 00 89 45 EC 66 8B 4D EC 66 89 4D FC 8B 55 0C 66 0F B6 02 66 89 45 F8 8B 4D 0C 83 C1 01 89 4D 0C 8B 55 F8 81 E2 FF 00 00 00 33 C0 8A 82 ?? ?? ?? ?? 83 E0 04 85 C0 0F 84 88 00 00 00 8B 4D 0C 33 D2 8A 11 85 D2 75 08 66 C7 45 F8 00 00 EB 73 6A 01 A1 ?? ?? ?? ?? 50 6A 02 8D 4D F4 51 6A 02 8B 55 0C 83 EA 01 52 68 00 02 00 00 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 20 89 45 F0 83 7D F0 01 75 0B 66 0F B6 4D F4 66 89 4D F8 EB 2C 83 7D F0 02 75 1C 8B 55 F4 81 E2 FF 00 00 00 C1 E2 08 8B 45 F5 25 FF 00 00 00 03 D0 66 89 55 F8 EB 0A B8 FF FF FF 7F E9 99 00 00 00 8B 4D 0C 83 C1 01 89 4D 0C EB 42 8B 55 F8 81 E2 FF FF 00 00 33 C0 8A 82 ?? ?? ?? ?? 83 E0 10 83 F8 10 75 16 8B 4D F8 81 E1 FF FF 00 00 33 D2 8A 91 ?? ?? ?? ?? 89 55 E8 EB 0B 8B 45 F8 25 FF FF 00 00 89 45 E8 66 8B 4D E8 66 89 4D F8 8B 55 FC 81 E2 FF FF 00 00 8B 45 F8 25 FF FF 00 00 3B D0 74 22 8B 4D FC 81 E1 FF FF 00 00 8B 55 F8 81 E2 FF FF 00 00 33 C0 3B CA 0F 9E C0 48 83 E0 02 83 C0 FF EB 15 8B 45 FC 25 FF FF 00 00 85 C0 75 04 33 C0 EB 05 E9 C0 FD FF FF 8B E5 5D C3 }
	condition:
		$1
}

rule file_54_0_0 {
	meta:
		name = "__mbschr"
		size = 197
		refs = "0006 ___ismbcodepage 0016 _strchr 0051 __mbctype"
	strings:
		$1 = { 55 8B EC 51 83 3D ?? ?? ?? ?? 00 75 15 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 E9 9F 00 00 00 EB 09 8B 55 08 83 C2 01 89 55 08 8B 45 08 66 0F B6 08 66 89 4D FC 8B 55 FC 81 E2 FF FF 00 00 85 D2 74 68 8B 45 FC 25 FF 00 00 00 33 C9 8A 88 ?? ?? ?? ?? 83 E1 04 85 C9 74 3C 8B 55 08 83 C2 01 89 55 08 8B 45 08 33 C9 8A 08 85 C9 75 04 33 C0 EB 4D 8B 55 FC 81 E2 FF FF 00 00 C1 E2 08 8B 45 08 33 C9 8A 08 0B D1 39 55 0C 75 08 8B 45 08 83 E8 01 EB 2B EB 10 8B 55 FC 81 E2 FF FF 00 00 39 55 0C 75 02 EB 05 E9 77 FF FF FF 8B 45 FC 25 FF FF 00 00 39 45 0C 75 05 8B 45 08 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_55_0_0 {
	meta:
		name = "??2@YAPAXI@Z"
		size = 28
		refs = "000b __nh_malloc"
	strings:
		$1 = { 55 8B EC 51 6A 01 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_56_0_0 {
	meta:
		name = "__cintrindisp2"
		size = 62
		refs = "0014 __matherr_flag 001c __trandisp2 0022 intrinflag"
	strings:
		$1 = { 55 8B EC 81 C4 60 FD FF FF 53 9B D9 BD 5C FF FF FF 9B 83 3D ?? ?? ?? ?? 00 74 14 E8 ?? ?? ?? ?? C6 05 ?? ?? ?? ?? 01 E8 89 00 00 00 5B C9 C3 D9 C9 DD 95 7A FF FF FF D9 C9 DD 55 82 EB DD }
	condition:
		$1
}

rule file_56_1_0 {
	meta:
		name = "__cintrindisp1"
		size = 54
		refs = "0013 __matherr_flag 001b __trandisp1 0021 intrinflag"
	strings:
		$1 = { 55 8B EC 81 C4 60 FD FF FF 53 9B D9 BD 5C FF FF FF 83 3D ?? ?? ?? ?? 00 74 14 E8 ?? ?? ?? ?? C6 05 ?? ?? ?? ?? 01 E8 4C 00 00 00 5B C9 C3 DD 95 7A FF FF FF EB E4 }
	condition:
		$1
}

rule file_56_2_0 {
	meta:
		name = "__ctrandisp2"
		size = 369
		refs = "002e __trandisp2 003c intrinflag 0043 ___fastflag 004c LocalFac 00c1 IeeeAdjU 00d1 DblMin 00dd _zero 00ef IeeeAdjO 00ff DblMax 010b _infinity 0160 __87except"
	strings:
		$1 = { 55 8B EC 81 C4 60 FD FF FF 53 FF 75 0C FF 75 08 E8 88 01 00 00 83 C4 08 FF 75 14 FF 75 10 E8 7A 01 00 00 83 C4 08 9B D9 BD 5C FF FF FF E8 ?? ?? ?? ?? E8 03 00 00 00 5B C9 C3 C6 05 ?? ?? ?? ?? 00 83 3D ?? ?? ?? ?? 00 75 4C DD 15 ?? ?? ?? ?? 8A 85 70 FF FF FF 0A C0 74 1A 3C FF 74 40 3C FE 74 3C 0A C0 74 30 0F BE C0 89 85 72 FF FF FF E9 9B 00 00 00 66 8B 85 5C FF FF FF 66 83 E0 20 75 15 9B DF E0 66 83 E0 20 74 0C C7 85 72 FF FF FF 08 00 00 00 EB 79 D9 AD 5C FF FF FF 9B C3 66 A1 ?? ?? ?? ?? 66 25 F0 7F 66 0B C0 74 08 66 3D F0 7F 74 30 EB BF C7 85 72 FF FF FF 04 00 00 00 DD 05 ?? ?? ?? ?? D9 C9 D9 FD DD D9 D9 C0 D9 E1 DC 1D ?? ?? ?? ?? 9B DF E0 9E 73 34 DC 0D ?? ?? ?? ?? EB 2C C7 85 72 FF FF FF 03 00 00 00 DD 05 ?? ?? ?? ?? D9 C9 D9 FD DD D9 D9 C0 D9 E1 DC 1D ?? ?? ?? ?? 9B DF E0 9E 76 06 DC 0D ?? ?? ?? ?? 56 57 8B 9D 6C FF FF FF 43 89 9D 76 FF FF FF 80 3D ?? ?? ?? ?? 00 75 1A FC 8D 75 08 8D BD 7A FF FF FF A5 A5 80 7B 0C 01 74 08 8D 75 10 8D 7D 82 A5 A5 DD 5D 8A 8D 85 72 FF FF FF 8D 9D 5C FF FF FF 53 50 8B 9D 6C FF FF FF 8A 43 0E 0F BE C0 50 E8 ?? ?? ?? ?? 83 C4 0C 5F 5E DD 45 8A E9 25 FF FF FF }
	condition:
		$1
}

rule file_56_3_0 {
	meta:
		name = "__ctrandisp1"
		size = 44
		refs = "0020 __trandisp1"
	strings:
		$1 = { 55 8B EC 81 C4 60 FD FF FF 53 FF 75 0C FF 75 08 E8 17 00 00 00 83 C4 08 9B D9 BD 5C FF FF FF E8 ?? ?? ?? ?? E8 A0 FE FF FF 5B C9 C3 }
	condition:
		$1
}

rule file_56_4_0 {
	meta:
		name = "__fload"
		size = 60
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 66 8B 45 0E 66 8B D8 66 25 F0 7F 66 3D F0 7F 75 1E 66 81 CB FF 7F 66 89 5D FE 8B 45 0C 8B 5D 08 0F A4 D8 0B 89 45 FA 89 5D F6 DB 6D F6 EB 03 DD 45 08 5B C9 C3 }
	condition:
		$1
}

rule file_57_0_0 {
	meta:
		name = "__wutime"
		size = 75
		refs = "0010 __wopen 002e __futime 003d __close"
	strings:
		$1 = { 55 8B EC 83 EC 08 68 02 80 00 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 7D 05 83 C8 FF EB 22 8B 4D 0C 51 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 F8 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_534_0_0 {
	meta:
		name = "__utime"
		size = 75
		refs = "0010 __open 002e __futime 003d __close"
	strings:
		$1 = { 55 8B EC 83 EC 08 68 02 80 00 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 7D 05 83 C8 FF EB 22 8B 4D 0C 51 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 F8 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_58_0_0 {
	meta:
		name = "__CIcos"
		size = 20
		refs = "0007 __checkTOS_withFB"
		altNames = "__CIacos __CIasin __CIatan __CIlog __CIlog10 __CIsin __CIsqrt __CItan"
	strings:
		$1 = { 83 EC 08 DD 14 24 E8 ?? ?? ?? ?? E8 0D 00 00 00 83 C4 08 C3 }
	condition:
		$1
}

rule file_58_1_0 {
	meta:
		name = "_cos"
		size = 154
		refs = "0005 __fload_withFB 001a __DEFAULT_CW_in_mem 0028 ___fastflag 002f __fast_exit 003a _NAME_ 003f __math_exit 0045 __pi_by_2_to_61 005a __convertTOStoQNaN 0072 __indefinite 0094 __startOneArgErrorHandling"
	strings:
		$1 = { 8D 54 24 04 E8 ?? ?? ?? ?? 52 9B D9 3C 24 74 50 66 81 3C 24 7F 02 74 06 D9 2D ?? ?? ?? ?? D9 FF 9B DF E0 9E 7A 1D 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 12 00 00 00 8D 0D ?? ?? ?? ?? E9 ?? ?? ?? ?? DB 2D ?? ?? ?? ?? D9 C9 D9 F5 9B DF E0 9E 7A F8 DD D9 D9 FF EB CD E8 ?? ?? ?? ?? EB 1B A9 FF FF 0F 00 75 F2 83 7C 24 08 00 75 EB DD D8 DB 2D ?? ?? ?? ?? B8 01 00 00 00 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 12 00 00 00 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule file_59_0_0 {
	meta:
		name = "__strnicmp"
		size = 44
		refs = "0019 ___lc_handle"
	strings:
		$1 = { 55 8B EC 57 56 53 8B 4D 10 0B C9 0F 84 95 00 00 00 8B 75 08 8B 7D 0C 8D 05 ?? ?? ?? ?? 83 78 08 00 75 43 B7 41 B3 5A B6 20 8D 49 00 }
	condition:
		$1
}

rule file_59_1_0 {
	meta:
		name = "lupe"
		size = 24
	strings:
		$1 = { 8A 26 0A E4 8A 07 74 21 0A C0 74 1D 46 47 38 FC 72 06 38 DC 77 02 02 E6 }
	condition:
		$1
}

rule file_59_7_0 {
	meta:
		name = "lupe2"
		size = 43
		refs = "0012 _tolower"
	strings:
		$1 = { 8A 06 0B C0 8A 1F 74 23 0B DB 74 1F 46 47 51 50 53 E8 ?? ?? ?? ?? 8B D8 83 C4 04 E8 ?? ?? ?? ?? 83 C4 04 59 3B C3 75 09 49 75 D5 }
	condition:
		$1
}

rule file_60_0_0 {
	meta:
		name = "__frnd"
		size = 27
	strings:
		$1 = { 55 8B EC 83 EC 08 53 56 57 DD 45 08 D9 FC DD 5D F8 DD 45 F8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_61_0_0 {
	meta:
		name = "___crtsetenv"
		size = 736
		refs = "0014 __mbschr 0045 __environ 004b ___initenv 0059 _copy_environ 007a __wenviron 0082 ___wtomb_environ 00b3 ??_C@_08FEIK@setenv?4c?$AA@ 00bc __malloc_dbg 013a _findenv 016d __free_dbg 01b8 __realloc_dbg 026b _strlen 0290 _strcpy 02c7 __imp__SetEnvironmentVariableA@8"
	strings:
		$1 = { 55 8B EC 83 EC 18 56 83 7D 08 00 74 1F 6A 3D 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 E8 83 7D E8 00 74 08 8B 4D 08 3B 4D E8 75 08 83 C8 FF E9 A7 02 00 00 8B 55 E8 0F BE 42 01 F7 D8 1B C0 40 89 45 EC 8B 0D ?? ?? ?? ?? 3B 0D ?? ?? ?? ?? 75 14 8B 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 04 A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 0F 85 B3 00 00 00 83 7D 0C 00 74 1F 83 3D ?? ?? ?? ?? 00 74 16 E8 ?? ?? ?? ?? 85 C0 74 08 83 C8 FF E9 49 02 00 00 E9 8E 00 00 00 83 7D EC 00 74 07 33 C0 E9 37 02 00 00 83 3D ?? ?? ?? ?? 00 75 37 68 87 00 00 00 68 ?? ?? ?? ?? 6A 02 6A 04 E8 ?? ?? ?? ?? 83 C4 10 A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 75 08 83 C8 FF E9 02 02 00 00 A1 ?? ?? ?? ?? C7 00 00 00 00 00 83 3D ?? ?? ?? ?? 00 75 38 68 8E 00 00 00 68 ?? ?? ?? ?? 6A 02 6A 04 E8 ?? ?? ?? ?? 83 C4 10 A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 75 08 83 C8 FF E9 C2 01 00 00 8B 0D ?? ?? ?? ?? C7 01 00 00 00 00 8B 15 ?? ?? ?? ?? 89 55 F4 8B 45 E8 2B 45 08 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 F8 83 7D F8 00 0F 8C 93 00 00 00 8B 55 F4 83 3A 00 0F 84 87 00 00 00 83 7D EC 00 74 73 6A 02 8B 45 F8 8B 4D F4 8B 14 81 52 E8 ?? ?? ?? ?? 83 C4 08 EB 09 8B 45 F8 83 C0 01 89 45 F8 8B 4D F8 8B 55 F4 83 3C 8A 00 74 15 8B 45 F8 8B 4D F4 8B 55 F8 8B 75 F4 8B 54 96 04 89 14 81 EB D6 68 B9 00 00 00 68 ?? ?? ?? ?? 6A 02 8B 45 F8 C1 E0 02 50 8B 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 89 45 F4 83 7D F4 00 74 09 8B 55 F4 89 15 ?? ?? ?? ?? EB 0C 8B 45 F8 8B 4D F4 8B 55 08 89 14 81 EB 73 83 7D EC 00 75 66 83 7D F8 00 7D 08 8B 45 F8 F7 D8 89 45 F8 68 CE 00 00 00 68 ?? ?? ?? ?? 6A 02 8B 4D F8 8D 14 8D 08 00 00 00 52 8B 45 F4 50 E8 ?? ?? ?? ?? 83 C4 14 89 45 F4 83 7D F4 00 75 08 83 C8 FF E9 B2 00 00 00 8B 4D F8 8B 55 F4 8B 45 08 89 04 8A 8B 4D F8 8B 55 F4 C7 44 8A 04 00 00 00 00 8B 45 F4 A3 ?? ?? ?? ?? EB 07 33 C0 E9 87 00 00 00 83 7D 0C 00 74 7F 68 E5 00 00 00 68 ?? ?? ?? ?? 6A 02 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 83 C0 02 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 F0 83 7D F0 00 74 52 8B 55 08 52 8B 45 F0 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4D E8 2B 4D 08 8B 55 F0 03 D1 89 55 FC 8B 45 FC C6 00 00 8B 4D FC 83 C1 01 89 4D FC 8B 55 EC F7 DA 1B D2 F7 D2 23 55 FC 52 8B 45 F0 50 FF 15 ?? ?? ?? ?? 6A 02 8B 4D F0 51 E8 ?? ?? ?? ?? 83 C4 08 33 C0 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_61_1_0 {
	meta:
		name = "_findenv"
		size = 124
		refs = "0005 __environ 002e __mbsnbicoll"
	strings:
		$1 = { 55 8B EC 51 A1 ?? ?? ?? ?? 89 45 FC EB 09 8B 4D FC 83 C1 04 89 4D FC 8B 55 FC 83 3A 00 74 4B 8B 45 0C 50 8B 4D FC 8B 11 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 2F 8B 4D FC 8B 11 8B 45 0C 0F BE 0C 02 83 F9 3D 74 10 8B 55 FC 8B 02 8B 4D 0C 0F BE 14 08 85 D2 75 0E 8B 45 FC 2B 05 ?? ?? ?? ?? C1 F8 02 EB 10 EB A4 8B 45 FC 2B 05 ?? ?? ?? ?? C1 F8 02 F7 D8 8B E5 5D C3 }
	condition:
		$1
}

rule file_61_2_0 {
	meta:
		name = "_copy_environ"
		size = 238
		refs = "0043 ??_C@_08FEIK@setenv?4c?$AA@ 0055 __malloc_dbg 006e __amsg_exit 0096 _strlen 00c3 _strcpy"
	strings:
		$1 = { 55 8B EC 83 EC 10 C7 45 F0 00 00 00 00 8B 45 08 89 45 F4 83 7D 08 00 75 07 33 C0 E9 CA 00 00 00 8B 4D F4 8B 11 8B 45 F4 83 C0 04 89 45 F4 85 D2 74 0B 8B 4D F0 83 C1 01 89 4D F0 EB E3 68 46 01 00 00 68 ?? ?? ?? ?? 6A 02 8B 55 F0 8D 04 95 04 00 00 00 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 F8 8B 4D F8 89 4D FC 83 7D FC 00 75 0A 6A 09 E8 ?? ?? ?? ?? 83 C4 04 8B 55 08 89 55 F4 8B 45 F4 83 38 00 74 5B 68 4F 01 00 00 68 ?? ?? ?? ?? 6A 02 8B 4D F4 8B 11 52 E8 ?? ?? ?? ?? 83 C4 04 83 C0 01 50 E8 ?? ?? ?? ?? 83 C4 10 8B 4D F8 89 01 8B 55 F8 83 3A 00 74 14 8B 45 F4 8B 08 51 8B 55 F8 8B 02 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4D F4 83 C1 04 89 4D F4 8B 55 F8 83 C2 04 89 55 F8 EB 9D 8B 45 F8 C7 00 00 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_63_1_0 {
	meta:
		name = "_sqrt"
		size = 166
		refs = "0005 __fload_withFB 001d __load_CW 002c ___fastflag 0033 __fast_exit 003e _NAME_ 0043 __math_exit 005f __convertTOStoQNaN 007e __indefinite 00a0 __startOneArgErrorHandling"
	strings:
		$1 = { 8D 54 24 04 E8 ?? ?? ?? ?? 52 9B D9 3C 24 8B 44 24 0C 74 51 66 81 3C 24 7F 02 74 05 E8 ?? ?? ?? ?? A9 00 00 00 80 75 1F D9 FA 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 05 00 00 00 8D 0D ?? ?? ?? ?? E9 ?? ?? ?? ?? A9 00 00 F0 7F 75 2C A9 FF FF 0F 00 75 25 83 7C 24 08 00 75 1E EB CC E8 ?? ?? ?? ?? EB 22 A9 FF FF 0F 00 75 F2 83 7C 24 08 00 75 EB 25 00 00 00 80 74 B0 DD D8 DB 2D ?? ?? ?? ?? B8 01 00 00 00 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 05 00 00 00 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule file_64_0_0 {
	meta:
		name = "__wcreat"
		size = 26
		refs = "0011 __wopen"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 68 02 03 00 00 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_366_0_0 {
	meta:
		name = "__creat"
		size = 26
		refs = "0011 __open"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 68 02 03 00 00 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_65_0_0 {
	meta:
		name = "__ismbcalnum"
		size = 245
		refs = "003c ___ismbcodepage 004d ___mblcid 0054 ___mbcodepage 0066 ___crtGetStringTypeA 00b8 __ctype 00d3 __mbctype"
	strings:
		$1 = { 55 8B EC 83 EC 10 81 7D 08 FF 00 00 00 0F 86 97 00 00 00 66 C7 45 F8 00 00 33 C0 66 89 45 FA 8B 4D 08 C1 E9 08 81 E1 FF 00 00 00 88 4D FC 8B 55 08 81 E2 FF 00 00 00 88 55 FD 83 3D ?? ?? ?? ?? 00 75 07 33 C0 E9 A7 00 00 00 6A 01 A1 ?? ?? ?? ?? 50 8B 0D ?? ?? ?? ?? 51 8D 55 F8 52 6A 02 8D 45 FC 50 6A 01 E8 ?? ?? ?? ?? 83 C4 1C 85 C0 75 04 33 C0 EB 7C 8B 4D FA 81 E1 FF FF 00 00 85 C9 75 1C 8B 55 F8 81 E2 FF FF 00 00 81 E2 07 01 00 00 85 D2 74 09 C7 45 F4 01 00 00 00 EB 07 C7 45 F4 00 00 00 00 8B 45 F4 EB 47 8B 45 08 25 FF 00 00 00 33 C9 66 8B 0C 45 ?? ?? ?? ?? 81 E1 07 01 00 00 85 C9 75 21 8B 55 08 81 E2 FF 00 00 00 33 C0 8A 82 ?? ?? ?? ?? 83 E0 01 85 C0 75 09 C7 45 F0 00 00 00 00 EB 07 C7 45 F0 01 00 00 00 8B 45 F0 8B E5 5D C3 }
	condition:
		$1
}

rule file_66_0_0 {
	meta:
		name = "__ioinit"
		size = 779
		refs = "000c ??_C@_08KFDJ@ioinit?4c?$AA@ 0018 __malloc_dbg 002b __amsg_exit 0036 ___pioinfo 003c __nhandle 007f __imp__GetStartupInfoA@4 01d3 __imp__GetFileType@4 0271 __imp__GetStdHandle@4 0303 __imp__SetHandleCount@4"
	strings:
		$1 = { 55 8B EC 83 EC 6C 68 81 00 00 00 68 ?? ?? ?? ?? 6A 02 68 00 01 00 00 E8 ?? ?? ?? ?? 83 C4 10 89 45 B0 83 7D B0 00 75 0A 6A 1B E8 ?? ?? ?? ?? 83 C4 04 8B 45 B0 A3 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 20 00 00 00 EB 09 8B 4D B0 83 C1 08 89 4D B0 8B 15 ?? ?? ?? ?? 81 C2 00 01 00 00 39 55 B0 73 19 8B 45 B0 C6 40 04 00 8B 4D B0 C7 01 FF FF FF FF 8B 55 B0 C6 42 05 0A EB CD 8D 45 B8 50 FF 15 ?? ?? ?? ?? 8B 4D EA 81 E1 FF FF 00 00 85 C9 0F 84 7A 01 00 00 83 7D EC 00 0F 84 70 01 00 00 8B 55 EC 8B 02 89 45 9C 8B 4D EC 83 C1 04 89 4D FC 8B 55 FC 03 55 9C 89 55 A0 81 7D 9C 00 08 00 00 7D 08 8B 45 9C 89 45 98 EB 07 C7 45 98 00 08 00 00 8B 4D 98 89 4D 9C C7 45 A4 01 00 00 00 EB 09 8B 55 A4 83 C2 01 89 55 A4 A1 ?? ?? ?? ?? 3B 45 9C 0F 8D 87 00 00 00 68 B6 00 00 00 68 ?? ?? ?? ?? 6A 02 68 00 01 00 00 E8 ?? ?? ?? ?? 83 C4 10 89 45 B0 83 7D B0 00 75 0B 8B 0D ?? ?? ?? ?? 89 4D 9C EB 5A 8B 55 A4 8B 45 B0 89 04 95 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 83 C1 20 89 0D ?? ?? ?? ?? EB 09 8B 55 B0 83 C2 08 89 55 B0 8B 45 A4 8B 0C 85 ?? ?? ?? ?? 81 C1 00 01 00 00 39 4D B0 73 19 8B 55 B0 C6 42 04 00 8B 45 B0 C7 00 FF FF FF FF 8B 4D B0 C6 41 05 0A EB C9 E9 62 FF FF FF C7 45 A8 00 00 00 00 EB 1B 8B 55 A8 83 C2 01 89 55 A8 8B 45 FC 83 C0 01 89 45 FC 8B 4D A0 83 C1 04 89 4D A0 8B 55 A8 3B 55 9C 7D 65 8B 45 A0 83 38 FF 74 58 8B 4D FC 0F BE 11 83 E2 01 85 D2 74 4B 8B 45 FC 0F BE 08 83 E1 08 85 C9 75 10 8B 55 A0 8B 02 50 FF 15 ?? ?? ?? ?? 85 C0 74 2E 8B 4D A8 C1 F9 05 8B 55 A8 83 E2 1F 8B 04 8D ?? ?? ?? ?? 8D 0C D0 89 4D B0 8B 55 B0 8B 45 A0 8B 08 89 0A 8B 55 B0 8B 45 FC 8A 08 88 4A 04 E9 78 FF FF FF C7 45 A8 00 00 00 00 EB 09 8B 55 A8 83 C2 01 89 55 A8 83 7D A8 03 0F 8D D1 00 00 00 8B 45 A8 8B 0D ?? ?? ?? ?? 8D 14 C1 89 55 B0 8B 45 B0 83 38 FF 0F 85 A2 00 00 00 8B 4D B0 C6 41 04 81 83 7D A8 00 75 09 C7 45 94 F6 FF FF FF EB 10 8B 55 A8 83 EA 01 F7 DA 1B D2 83 C2 F5 89 55 94 8B 45 94 50 FF 15 ?? ?? ?? ?? 89 45 B4 83 7D B4 FF 74 58 8B 4D B4 51 FF 15 ?? ?? ?? ?? 89 45 AC 83 7D AC 00 74 45 8B 55 B0 8B 45 B4 89 02 8B 4D AC 81 E1 FF 00 00 00 83 F9 02 75 10 8B 55 B0 8A 42 04 0C 40 8B 4D B0 88 41 04 EB 1D 8B 55 AC 81 E2 FF 00 00 00 83 FA 03 75 0F 8B 45 B0 8A 48 04 80 C9 08 8B 55 B0 88 4A 04 EB 0F 8B 45 B0 8A 48 04 80 C9 40 8B 55 B0 88 4A 04 EB 0F 8B 45 B0 8A 48 04 80 C9 80 8B 55 B0 88 4A 04 E9 1C FF FF FF A1 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_66_1_0 {
	meta:
		name = "__ioterm"
		size = 82
		refs = "0022 ___pioinfo 0037 __free_dbg"
	strings:
		$1 = { 55 8B EC 51 C7 45 FC 00 00 00 00 EB 09 8B 45 FC 83 C0 01 89 45 FC 83 7D FC 40 7D 32 8B 4D FC 83 3C 8D ?? ?? ?? ?? 00 74 23 6A 02 8B 55 FC 8B 04 95 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4D FC C7 04 8D ?? ?? ?? ?? 00 00 00 00 EB BF 8B E5 5D C3 }
	condition:
		$1
}

rule file_67_0_0 {
	meta:
		name = "_vfwprintf"
		size = 163
		refs = "0010 ??_C@_0M@KJPK@str?5?$CB?$DN?5NULL?$AA@ 0019 ??_C@_0L@NDDH@vfwprint?4c?$AA@ 0020 __CrtDbgReport 003a ??_C@_0P@LNLA@format?5?$CB?$DN?5NULL?$AA@ 0068 __stbuf 007f __woutput 0092 __ftbuf"
	strings:
		$1 = { 55 8B EC 83 EC 0C 53 56 57 83 7D 08 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 37 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D6 83 7D 0C 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 38 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D6 8B 55 08 89 55 FC 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 F8 8B 4D 10 51 8B 55 0C 52 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F4 8B 4D FC 51 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 08 8B 45 F4 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_68_0_0 {
	meta:
		name = "?_JumpToContinuation@@YGXPAXPAUEHRegistrationNode@@@Z"
		size = 54
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B 45 0C 83 C0 0C 89 45 FC 64 8B 1D 00 00 00 00 8B 03 64 A3 00 00 00 00 8B 45 08 8B 5D 0C 8B 63 FC 8B 6D FC FF E0 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_68_4_0 {
	meta:
		name = "?_UnwindNestedFrames@@YGXPAUEHRegistrationNode@@PAUEHExceptionRecord@@@Z"
		size = 86
		refs = "0015 $ReturnPoint$16554 0028 _RtlUnwind@16"
	strings:
		$1 = { 55 8B EC 83 EC 08 53 56 57 64 A1 00 00 00 00 89 45 F8 C7 45 FC ?? ?? ?? ?? 6A 00 8B 45 0C 50 8B 4D FC 51 8B 55 08 52 E8 ?? ?? ?? ?? 8B 45 0C 8B 48 04 83 E1 FD 8B 55 0C 89 4A 04 64 A1 00 00 00 00 8B 5D F8 89 03 64 89 1D 00 00 00 00 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_68_5_0 {
	meta:
		name = "___CxxFrameHandler"
		size = 60
		refs = "0028 ___InternalCxxFrameHandler"
	strings:
		$1 = { 55 8B EC 83 EC 08 53 56 57 FC 89 45 F8 6A 00 6A 00 6A 00 8B 45 F8 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 20 89 45 FC 5F 5E 5B 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_68_6_0 {
	meta:
		name = "___CxxLongjmpUnwind@4"
		size = 38
		refs = "001b ___FrameUnwindToState"
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 48 1C 51 8B 55 08 8B 42 28 50 6A 00 8B 4D 08 8B 51 18 52 E8 ?? ?? ?? ?? 83 C4 10 5D C2 04 00 }
	condition:
		$1
}

rule file_68_7_0 {
	meta:
		name = "?_CallCatchBlock2@@YAPAXPAUEHRegistrationNode@@PBU_s_FuncInfo@@PAXHK@Z"
		size = 104
		refs = "0013 ?CatchGuardHandler@@YA?AW4_EXCEPTION_DISPOSITION@@PAUEHExceptionRecord@@PAUCatchGuardRN@@PAX2@Z 004e __CallSettingFrame@12"
	strings:
		$1 = { 55 8B EC 83 EC 18 53 56 57 C7 45 EC 00 00 00 00 C7 45 F0 ?? ?? ?? ?? 8B 45 0C 89 45 F4 8B 4D 08 89 4D F8 8B 55 14 83 C2 01 89 55 FC 64 A1 00 00 00 00 89 45 EC 8D 85 EC FF FF FF 64 A3 00 00 00 00 8B 45 18 50 8B 4D 08 51 8B 55 10 52 E8 ?? ?? ?? ?? 89 45 E8 8B 45 EC 64 A3 00 00 00 00 8B 45 E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_68_8_0 {
	meta:
		name = "?CatchGuardHandler@@YA?AW4_EXCEPTION_DISPOSITION@@PAUEHExceptionRecord@@PAUCatchGuardRN@@PAX2@Z"
		size = 57
		refs = "002d ___InternalCxxFrameHandler"
	strings:
		$1 = { 55 8B EC 53 56 57 FC 6A 00 8B 45 0C 50 8B 4D 0C 8B 51 10 52 8B 45 0C 8B 48 08 51 6A 00 8B 55 10 52 8B 45 0C 8B 48 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 20 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_68_9_0 {
	meta:
		name = "?_CallSETranslator@@YAHPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAX2PBU_s_FuncInfo@@H1@Z"
		size = 202
		refs = "0013 ?TranslatorGuardHandler@@YA?AW4_EXCEPTION_DISPOSITION@@PAUEHExceptionRecord@@PAUTranslatorGuardRN@@PAX2@Z 004e $ExceptionContinuation$16654 008c ?__pSETranslator@@3P6AXIPAU_EXCEPTION_POINTERS@@@ZA"
	strings:
		$1 = { 55 8B EC 83 EC 34 53 56 57 C7 45 D8 00 00 00 00 C7 45 DC ?? ?? ?? ?? 8B 45 18 89 45 E0 8B 4D 0C 89 4D E4 8B 55 1C 89 55 E8 8B 45 20 89 45 EC C7 45 F0 00 00 00 00 C7 45 F4 00 00 00 00 C7 45 F8 00 00 00 00 C7 45 FC 00 00 00 00 C7 45 F0 ?? ?? ?? ?? 89 65 F4 89 6D F8 64 A1 00 00 00 00 89 45 D8 8D 85 D8 FF FF FF 64 A3 00 00 00 00 C7 45 CC 01 00 00 00 8B 4D 08 89 4D D0 8B 55 10 89 55 D4 8D 45 D0 50 8B 4D 08 8B 11 52 FF 15 ?? ?? ?? ?? 83 C4 08 C7 45 CC 00 00 00 00 83 7D FC 00 74 17 64 8B 1D 00 00 00 00 8B 03 8B 5D D8 89 03 64 89 1D 00 00 00 00 EB 09 8B 45 D8 64 A3 00 00 00 00 8B 45 CC 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_68_10_0 {
	meta:
		name = "?TranslatorGuardHandler@@YA?AW4_EXCEPTION_DISPOSITION@@PAUEHExceptionRecord@@PAUTranslatorGuardRN@@PAX2@Z"
		size = 129
		refs = "004e ___InternalCxxFrameHandler 0067 ?_UnwindNestedFrames@@YGXPAUEHRegistrationNode@@PAUEHExceptionRecord@@@Z"
	strings:
		$1 = { 55 8B EC 53 56 57 FC 8B 45 08 8B 48 04 83 E1 66 85 C9 74 11 8B 55 0C C7 42 24 01 00 00 00 B8 01 00 00 00 EB 57 6A 01 8B 45 0C 8B 48 14 51 8B 55 0C 8B 42 10 50 8B 4D 0C 8B 51 08 52 6A 00 8B 45 10 50 8B 4D 0C 8B 51 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 20 8B 4D 0C 83 79 24 00 75 0D 8B 55 08 52 8B 45 0C 50 E8 ?? ?? ?? ?? 8B 5D 0C 8B 63 1C 8B 6B 20 FF 63 18 B8 01 00 00 00 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_68_11_0 {
	meta:
		name = "?_GetRangeOfTrysToCheck@@YAPBU_s_TryBlockMapEntry@@PBU_s_FuncInfo@@HHPAI1@Z"
		size = 144
		refs = "0024 ?_inconsistency@@YAXXZ"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 53 56 57 8B 48 10 8B 70 0C 89 4D FC 8B 4D 0C 85 C9 8B FE 8B DE 7C 3B 83 FE FF 75 05 E8 ?? ?? ?? ?? 8B 45 FC 4E 8B 4D 10 8D 14 B6 8D 04 90 3B 48 04 7E 05 3B 48 08 7E 05 83 FE FF 75 0B 8B 45 0C 8B FB 48 8B DE 89 45 0C 8B 45 0C 85 C0 7D C8 8B 45 08 8B 4D 14 8B 55 18 46 89 31 89 3A 3B 78 0C 77 04 3B F7 76 05 E8 ?? ?? ?? ?? 8B 4D FC 8D 04 B6 5F 5E 8D 04 81 5B 8B E5 5D C3 90 90 90 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_69_0_0 {
	meta:
		name = "___unDName"
		size = 94
		refs = "0019 _heap 001e ?Constructor@HeapManager@@QAEXP6APAXI@ZP6AXPAX@Z@Z 003e ??0UnDecorator@@QAE@PADPBDHP6APADJ@ZK@Z 0046 ??BUnDecorator@@QAEPADXZ 0053 ?Destructor@HeapManager@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 83 EC 7C 83 7D 14 00 75 04 33 C0 EB 4A 8B 45 18 50 8B 4D 14 51 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 1C 81 E2 FF FF 00 00 52 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 8D 4D 88 E8 ?? ?? ?? ?? 8D 4D 88 E8 ?? ?? ?? ?? 89 45 84 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 84 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_1_0 {
	meta:
		name = "?Constructor@HeapManager@@QAEXP6APAXI@ZP6AXPAX@Z@Z"
		size = 60
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 4D 08 89 08 8B 55 FC 8B 45 0C 89 42 04 8B 4D FC C7 41 10 00 00 00 00 8B 55 FC C7 42 08 00 00 00 00 8B 45 FC C7 40 0C 00 00 00 00 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_69_2_0 {
	meta:
		name = "?Destructor@HeapManager@@QAEXXZ"
		size = 73
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 83 78 04 00 74 35 8B 4D FC 8B 55 FC 8B 42 08 89 41 0C 8B 4D FC 83 79 0C 00 74 20 8B 55 FC 8B 42 0C 8B 4D FC 8B 10 89 51 08 8B 45 FC 8B 48 0C 51 8B 55 FC FF 52 04 83 C4 04 EB CB 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_3_0 {
	meta:
		name = "___unDNameEx"
		size = 90
		refs = "0019 _heap 001e ?Constructor@HeapManager@@QAEXP6APAXI@ZP6AXPAX@Z@Z 003a ??0UnDecorator@@QAE@PADPBDHP6APADJ@ZK@Z 0042 ??BUnDecorator@@QAEPADXZ 004f ?Destructor@HeapManager@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 83 EC 7C 83 7D 14 00 75 04 33 C0 EB 46 8B 45 18 50 8B 4D 14 51 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 20 52 8B 45 1C 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 8D 4D 88 E8 ?? ?? ?? ?? 8D 4D 88 E8 ?? ?? ?? ?? 89 45 84 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 84 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_4_0 {
	meta:
		name = "??0UnDecorator@@QAE@PADPBDHP6APADJ@ZK@Z"
		size = 110
		refs = "000b ??0Replicator@@QAE@XZ 001e ?name@UnDecorator@@0PBDB 002a ?gName@UnDecorator@@0PBDB 0033 ?maxStringLength@UnDecorator@@0HA 003b ?outputString@UnDecorator@@0PADA 0047 ?pZNameList@UnDecorator@@0PAVReplicator@@A 0050 ?pArgList@UnDecorator@@0PAVReplicator@@A 0058 ?disableFlags@UnDecorator@@0KA 0061 ?m_pGetParameter@UnDecorator@@0P6APADJ@ZA"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC 83 C1 3C E8 ?? ?? ?? ?? 8B 45 0C A3 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 8B 55 10 89 15 ?? ?? ?? ?? 8B 45 08 A3 ?? ?? ?? ?? 8B 4D FC 83 C1 3C 89 0D ?? ?? ?? ?? 8B 55 FC 89 15 ?? ?? ?? ?? 8B 45 18 A3 ?? ?? ?? ?? 8B 4D 14 89 0D ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 14 00 }
	condition:
		$1
}

rule file_69_5_0 {
	meta:
		name = "??BUnDecorator@@QAEPADXZ"
		size = 375
		refs = "000d ??0DName@@QAE@XZ 001b ?name@UnDecorator@@0PBDB 0044 ?gName@UnDecorator@@0PBDB 0056 ?getDecoratedName@UnDecorator@@CA?AVDName@@XZ 005f ??_C@_04GNO@CV?3?5?$AA@ 0068 ??H@YA?AVDName@@PBDABV0@@Z 0074 ??4DName@@QAEAAV0@ABV0@@Z 009b ?getTemplateName@UnDecorator@@CA?AVDName@@XZ 00c6 ?status@DName@@QBE?AW4DNameStatus@@XZ 00e4 ?doNameOnly@UnDecorator@@SAHXZ 0103 ??4DName@@QAEAAV0@PBD@Z 0117 ?outputString@UnDecorator@@0PADA 0122 ?length@DName@@QBEHXZ 012a ?maxStringLength@UnDecorator@@0HA 0131 _heap 013d ??2@YAPAXIAAVHeapManager@@H@Z 016a ?getString@DName@@QBEPADPADH@Z"
	strings:
		$1 = { 55 8B EC 83 EC 38 89 4D C8 8D 4D F8 E8 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 0F 84 9C 00 00 00 A1 ?? ?? ?? ?? 0F BE 08 83 F9 3F 75 47 8B 15 ?? ?? ?? ?? 0F BE 42 01 83 F8 40 75 38 8B 0D ?? ?? ?? ?? 83 C1 02 89 0D ?? ?? ?? ?? 8D 55 E8 52 E8 ?? ?? ?? ?? 83 C4 04 50 68 ?? ?? ?? ?? 8D 45 E0 50 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D F8 E8 ?? ?? ?? ?? EB 48 8B 0D ?? ?? ?? ?? 0F BE 11 83 FA 3F 75 25 A1 ?? ?? ?? ?? 0F BE 48 01 83 F9 24 75 17 8D 55 D8 52 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D F8 E8 ?? ?? ?? ?? EB 15 8D 45 D0 50 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D F8 E8 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? 83 F8 03 75 07 33 C0 E9 9D 00 00 00 8B 0D ?? ?? ?? ?? 0F BE 11 85 D2 74 09 E8 ?? ?? ?? ?? 85 C0 74 0D 8D 4D F8 E8 ?? ?? ?? ?? 83 F8 01 75 10 A1 ?? ?? ?? ?? 50 8D 4D F0 E8 ?? ?? ?? ?? EB 0C 8D 4D F8 51 8D 4D F0 E8 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 75 31 8D 4D F0 E8 ?? ?? ?? ?? 83 C0 01 A3 ?? ?? ?? ?? 6A 01 68 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 0C 89 45 CC 8B 45 CC A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 74 16 8B 0D ?? ?? ?? ?? 51 8B 15 ?? ?? ?? ?? 52 8D 4D F0 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_6_0 {
	meta:
		name = "?getDecoratedName@UnDecorator@@CA?AVDName@@XZ"
		size = 522
		refs = "0007 ?doTypeOnly@UnDecorator@@SAHXZ 0010 ?disableFlags@UnDecorator@@0KA 0023 ?getDataType@UnDecorator@@CA?AVDName@@PAV2@@Z 002f ??0DName@@QAE@ABV0@@Z 0058 ?gName@UnDecorator@@0PBDB 007a ?getSymbolName@UnDecorator@@CA?AVDName@@XZ 008e ?isUDC@DName@@QBEHXZ 0099 ?isValid@DName@@QBEHXZ 00d4 ?getScope@UnDecorator@@CA?AVDName@@XZ 00e8 ?isEmpty@DName@@QBEHXZ 00f9 ??_C@_02NNPM@?3?3?$AA@ 0105 ??HDName@@QBE?AV0@PBD@Z 010c ??HDName@@QBE?AV0@ABV0@@Z 0115 ??4DName@@QAEAAV0@ABV0@@Z 0123 ?setIsUDC@DName@@QAEXXZ 017c ?doNameOnly@UnDecorator@@SAHXZ 018e ??0DName@@QAE@XZ 0198 ?composeDeclaration@UnDecorator@@CA?AVDName@@ABV2@@Z 01d4 ??0DName@@QAE@W4DNameStatus@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 5C E8 ?? ?? ?? ?? 85 C0 74 47 A1 ?? ?? ?? ?? 80 E4 DF A3 ?? ?? ?? ?? 6A 00 8D 4D DC 51 E8 ?? ?? ?? ?? 83 C4 08 50 8D 4D F8 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 80 CE 20 89 15 ?? ?? ?? ?? 8D 45 F8 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 B0 01 00 00 8B 0D ?? ?? ?? ?? 0F BE 11 83 FA 3F 0F 85 75 01 00 00 A1 ?? ?? ?? ?? 83 C0 01 A3 ?? ?? ?? ?? 8D 4D D4 51 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D F0 E8 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? 89 45 EC 8D 4D F0 E8 ?? ?? ?? ?? 85 C0 75 14 8D 55 F0 52 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 51 01 00 00 A1 ?? ?? ?? ?? 0F BE 08 85 C9 74 58 8B 15 ?? ?? ?? ?? 0F BE 02 83 F8 40 74 4A 8D 4D CC 51 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D E4 E8 ?? ?? ?? ?? 8D 4D E4 E8 ?? ?? ?? ?? 85 C0 75 29 8D 55 F0 52 8D 45 BC 50 68 ?? ?? ?? ?? 8D 4D C4 51 8D 4D E4 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 50 8D 4D F0 E8 ?? ?? ?? ?? 83 7D EC 00 74 08 8D 4D F0 E8 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? 85 C0 74 14 8D 55 F0 52 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 BF 00 00 00 A1 ?? ?? ?? ?? 0F BE 08 85 C9 74 0E 8B 15 ?? ?? ?? ?? 0F BE 02 83 F8 40 75 6D 8B 0D ?? ?? ?? ?? 0F BE 11 85 D2 74 0D A1 ?? ?? ?? ?? 83 C0 01 A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 2C 83 7D EC 00 75 26 8D 4D B4 E8 ?? ?? ?? ?? 50 8D 4D AC 51 E8 ?? ?? ?? ?? 83 C4 08 8D 55 F0 52 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 EB 56 8D 45 F0 50 8D 4D A4 51 E8 ?? ?? ?? ?? 83 C4 08 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 EB 38 6A 01 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 EB 29 8B 15 ?? ?? ?? ?? 0F BE 02 85 C0 74 0F 6A 01 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 EB 0D 6A 02 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_7_0 {
	meta:
		name = "?getSymbolName@UnDecorator@@CA?AVDName@@XZ"
		size = 88
		refs = "0007 ?gName@UnDecorator@@0PBDB 0027 ?getOperatorName@UnDecorator@@CA?AVDName@@XZ 0033 ??0DName@@QAE@ABV0@@Z 0041 ?getZName@UnDecorator@@CA?AVDName@@XZ"
	strings:
		$1 = { 55 8B EC 83 EC 10 A1 ?? ?? ?? ?? 0F BE 08 83 F9 3F 75 29 8B 15 ?? ?? ?? ?? 83 C2 01 89 15 ?? ?? ?? ?? 8D 45 F8 50 E8 ?? ?? ?? ?? 83 C4 04 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 EB 18 8D 4D F0 51 E8 ?? ?? ?? ?? 83 C4 04 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_8_0 {
	meta:
		name = "?getZName@UnDecorator@@CA?AVDName@@XZ"
		size = 264
		refs = "0007 ?gName@UnDecorator@@0PBDB 0035 ?pZNameList@UnDecorator@@0PAVReplicator@@A 003a ??AReplicator@@QBEABVDName@@H@Z 0043 ??0DName@@QAE@ABV0@@Z 0053 ??0DName@@QAE@XZ 006a ?getTemplateName@UnDecorator@@CA?AVDName@@XZ 0076 ??4DName@@QAEAAV0@ABV0@@Z 00b9 ??4DName@@QAEAAV0@W4DNameStatus@@@Z 00ca ??0DName@@QAE@AAPBDD@Z 00de ?isFull@Replicator@@QBEHXZ 00f1 ??YReplicator@@QAEAAV0@ABVDName@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 1C A1 ?? ?? ?? ?? 0F BE 08 83 E9 30 89 4D FC 83 7D FC 00 7C 35 83 7D FC 09 7F 2F 8B 15 ?? ?? ?? ?? 83 C2 01 89 15 ?? ?? ?? ?? 8B 45 FC 50 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 B5 00 00 00 8D 4D F4 E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 0F BE 11 83 FA 3F 75 5A 8D 45 EC 50 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D F4 E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 0F BE 11 A1 ?? ?? ?? ?? 83 C0 01 A3 ?? ?? ?? ?? 83 FA 40 74 28 8B 0D ?? ?? ?? ?? 83 E9 01 89 0D ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 0F BE 02 F7 D8 1B C0 83 C0 02 50 8D 4D F4 E8 ?? ?? ?? ?? EB 18 6A 40 68 ?? ?? ?? ?? 8D 4D E4 E8 ?? ?? ?? ?? 50 8D 4D F4 E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 0F 8D 4D F4 51 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 55 F4 52 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_9_0 {
	meta:
		name = "?getOperatorName@UnDecorator@@CA?AVDName@@XZ"
		size = 1556
		refs = "000d ??0DName@@QAE@XZ 0021 ?gName@UnDecorator@@0PBDB 0060 $L3436 0067 $L3437 007e ??0DName@@QAE@W4DNameStatus@@@Z 0098 ?getZName@UnDecorator@@CA?AVDName@@XZ 00a4 ??4DName@@QAEAAV0@ABV0@@Z 00b4 ?isEmpty@DName@@QBEHXZ 00d6 ??H@YA?AVDName@@DABV0@@Z 00ee ??0DName@@QAE@ABV0@@Z 0106 _nameTable 010f ??4DName@@QAEAAV0@PBD@Z 017d $L3438 0184 $L3439 01dc ??0DName@@QAE@PBD@Z 0229 ?getOperatorName@UnDecorator@@CA?AVDName@@XZ 0249 ?isUDTThunk@DName@@QBEHXZ 026f ??HDName@@QBE?AV0@ABV0@@Z 02af _rttiTable 0309 $L3440 0314 ?getDataType@UnDecorator@@CA?AVDName@@PAV2@@Z 033e ??HDName@@QBE?AV0@D@Z 0385 ?getSignedDimension@UnDecorator@@CA?AVDName@@XZ 0398 ??YDName@@QAEAAV0@ABV0@@Z 03fd ?getDimension@UnDecorator@@CA?AVDName@@XZ 04c0 ?setIsUDC@DName@@QAEXXZ 04d7 ??_C@_08KMNC@operator?$AA@ 04e3 ??H@YA?AVDName@@PBDABV0@@Z 0506 $L1127 050a $L1129 050e $L1137 0512 $L1149 0516 $L1147 051a $L1177 051e $L1296 0582 $L1182 0586 $L1184 058a $L1197 058e $L1206 0592 $L1232 0596 $L1244 059a $L1246 059e $L1286 05a2 $L1295 0600 $L1260 0604 $L1267 0608 $L1280"
	strings:
		$1 = { 55 8B EC 81 EC E0 00 00 00 8D 4D F0 E8 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? C7 45 EC 00 00 00 00 A1 ?? ?? ?? ?? 0F BE 08 89 8D 34 FF FF FF 8B 15 ?? ?? ?? ?? 83 C2 01 89 15 ?? ?? ?? ?? 8B 85 34 FF FF FF 89 85 30 FF FF FF 83 BD 30 FF FF FF 5F 0F 87 51 04 00 00 8B 95 30 FF FF FF 33 C9 8A 8A ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? A1 ?? ?? ?? ?? 83 E8 01 A3 ?? ?? ?? ?? 6A 02 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 78 04 00 00 8B 0D ?? ?? ?? ?? 89 4D E8 8D 55 D0 52 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 E8 A3 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? 85 C0 75 2A 8B 0D ?? ?? ?? ?? 0F BE 51 FF 83 FA 31 75 1B 8D 45 F0 50 6A 7E 8D 4D C8 51 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D F0 E8 ?? ?? ?? ?? 8D 55 F0 52 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 08 04 00 00 A1 ?? ?? ?? ?? 0F BE 48 FF 8B 14 8D ?? ?? ?? ?? 52 8D 4D F0 E8 ?? ?? ?? ?? E9 9E 03 00 00 C7 45 EC 01 00 00 00 A1 ?? ?? ?? ?? 0F BE 48 FF 8B 14 8D ?? ?? ?? ?? 52 8D 4D F0 E8 ?? ?? ?? ?? E9 79 03 00 00 A1 ?? ?? ?? ?? 0F BE 08 89 8D 2C FF FF FF 8B 15 ?? ?? ?? ?? 83 C2 01 89 15 ?? ?? ?? ?? 8B 85 2C FF FF FF 89 85 28 FF FF FF 83 BD 28 FF FF FF 59 0F 87 23 03 00 00 8B 95 28 FF FF FF 33 C9 8A 8A ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? A1 ?? ?? ?? ?? 83 E8 01 A3 ?? ?? ?? ?? 6A 02 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 5B 03 00 00 8B 0D ?? ?? ?? ?? 0F BE 51 FF 8B 04 95 ?? ?? ?? ?? 50 8D 4D F0 E8 ?? ?? ?? ?? E9 DF 02 00 00 8B 0D ?? ?? ?? ?? 0F BE 51 FF 8B 04 95 ?? ?? ?? ?? 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 1A 03 00 00 8B 0D ?? ?? ?? ?? 0F BE 51 FF 8B 04 95 ?? ?? ?? ?? 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 F8 02 00 00 8B 0D ?? ?? ?? ?? 0F BE 51 FF 8B 04 95 ?? ?? ?? ?? 50 8D 4D F0 E8 ?? ?? ?? ?? 8D 4D C0 51 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D F8 E8 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? 85 C0 75 1E 8D 4D F8 E8 ?? ?? ?? ?? 85 C0 74 12 6A 01 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 9F 02 00 00 8D 55 F8 52 8D 45 B8 50 8D 4D F0 E8 ?? ?? ?? ?? 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 7E 02 00 00 E9 1C 02 00 00 8B 0D ?? ?? ?? ?? 0F BE 51 FF 8B 04 95 ?? ?? ?? ?? 50 8D 4D F0 E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 0F BE 11 8B 04 95 ?? ?? ?? ?? 50 8D 4D F8 E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 0F BE 11 89 95 24 FF FF FF A1 ?? ?? ?? ?? 83 C0 01 A3 ?? ?? ?? ?? 8B 8D 24 FF FF FF 89 8D 20 FF FF FF 8B 95 20 FF FF FF 83 EA 30 89 95 20 FF FF FF 83 BD 20 FF FF FF 04 0F 87 5A 01 00 00 8B 85 20 FF FF FF FF 24 85 ?? ?? ?? ?? 6A 00 8D 4D B0 51 E8 ?? ?? ?? ?? 83 C4 08 50 8D 4D E0 E8 ?? ?? ?? ?? 8D 55 F8 52 8D 45 98 50 8D 4D F0 51 8D 55 A0 52 6A 20 8D 45 A8 50 8D 4D E0 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 A1 01 00 00 8D 4D F8 51 8D 55 90 52 8D 4D F0 E8 ?? ?? ?? ?? 50 8D 4D D8 E8 ?? ?? ?? ?? 6A 2C 8D 45 80 50 8D 4D 88 51 E8 ?? ?? ?? ?? 83 C4 04 8B C8 E8 ?? ?? ?? ?? 50 8D 4D D8 E8 ?? ?? ?? ?? 6A 2C 8D 95 70 FF FF FF 52 8D 85 78 FF FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 8B C8 E8 ?? ?? ?? ?? 50 8D 4D D8 E8 ?? ?? ?? ?? 6A 2C 8D 8D 60 FF FF FF 51 8D 95 68 FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 8B C8 E8 ?? ?? ?? ?? 50 8D 4D D8 E8 ?? ?? ?? ?? 6A 29 8D 85 50 FF FF FF 50 8D 8D 58 FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 8B C8 E8 ?? ?? ?? ?? 50 8D 4D D8 E8 ?? ?? ?? ?? 6A 27 8D 95 48 FF FF FF 52 8D 4D D8 E8 ?? ?? ?? ?? 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 CC 00 00 00 8D 45 F8 50 8D 8D 40 FF FF FF 51 8D 4D F0 E8 ?? ?? ?? ?? 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 A8 00 00 00 8B 15 ?? ?? ?? ?? 83 EA 01 89 15 ?? ?? ?? ?? 6A 02 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 87 00 00 00 A1 ?? ?? ?? ?? 0F BE 48 FF 8B 14 8D ?? ?? ?? ?? 52 8D 4D F0 E8 ?? ?? ?? ?? EB 0F 6A 01 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 EB 5D EB 0F 6A 01 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 EB 4C 83 7D EC 00 74 0A 8D 4D F0 E8 ?? ?? ?? ?? EB 2D 8D 4D F0 E8 ?? ?? ?? ?? 85 C0 75 21 8D 45 F0 50 68 ?? ?? ?? ?? 8D 8D 38 FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D F0 E8 ?? ?? ?? ?? 8D 55 F0 52 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 01 01 02 02 02 02 02 02 02 02 06 06 06 06 06 06 06 03 04 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 06 06 06 06 05 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 08 08 08 08 08 08 08 08 08 08 08 08 08 08 08 08 08 08 08 08 08 08 08 08 08 08 08 08 08 08 08 08 08 08 08 08 08 08 08 08 08 08 08 08 08 08 08 01 01 01 01 01 01 01 02 02 02 08 08 08 08 08 08 08 03 03 03 03 03 03 03 03 03 03 08 03 03 03 03 04 05 06 03 03 07 07 08 03 03 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_69_10_0 {
	meta:
		name = "?getScope@UnDecorator@@CA?AVDName@@XZ"
		size = 866
		refs = "000d ??0DName@@QAE@XZ 0019 ?status@DName@@QBE?AW4DNameStatus@@XZ 0026 ?gName@UnDecorator@@0PBDB 004b ?isEmpty@DName@@QBEHXZ 0058 ??_C@_02NNPM@?3?3?$AA@ 0061 ??H@YA?AVDName@@PBDABV0@@Z 006d ??4DName@@QAEAAV0@ABV0@@Z 0088 ??H@YA?AVDName@@DABV0@@Z 00f0 $L3463 00f7 $L3464 00fc ?doNameOnly@UnDecorator@@SAHXZ 0117 ?getDecoratedName@UnDecorator@@CA?AVDName@@XZ 0130 ??HDName@@QBE?AV0@D@Z 0137 ??HDName@@QBE?AV0@ABV0@@Z 0173 ?getZName@UnDecorator@@CA?AVDName@@XZ 01bf ??_C@_0BG@LHIO@?$GAanonymous?5namespace?8?$AA@ 023a ?getLexicalFrame@UnDecorator@@CA?AVDName@@XZ 02c6 ??4DName@@QAEAAV0@W4DNameStatus@@@Z 02ec ??0DName@@QAE@W4DNameStatus@@@Z 02f3 ??HDName@@QBE?AV0@PBD@Z 031d ??0DName@@QAE@ABV0@@Z 0328 $L1327 032c $L1330 0330 $L1319 0334 $L1336 0338 $L1340"
	strings:
		$1 = { 55 8B EC 81 EC BC 00 00 00 8D 4D F8 E8 ?? ?? ?? ?? C6 45 F4 00 8D 4D F8 E8 ?? ?? ?? ?? 85 C0 0F 85 6E 02 00 00 A1 ?? ?? ?? ?? 0F BE 08 85 C9 0F 84 5E 02 00 00 8B 15 ?? ?? ?? ?? 0F BE 02 83 F8 40 0F 84 4C 02 00 00 8D 4D F8 E8 ?? ?? ?? ?? 85 C0 75 49 8D 4D F8 51 68 ?? ?? ?? ?? 8D 55 EC 52 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D F8 E8 ?? ?? ?? ?? 8B 45 F4 25 FF 00 00 00 85 C0 74 1F 8D 4D F8 51 6A 5B 8D 55 E4 52 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D F8 E8 ?? ?? ?? ?? C6 45 F4 00 A1 ?? ?? ?? ?? 0F BE 08 83 F9 3F 0F 85 B7 01 00 00 8B 15 ?? ?? ?? ?? 83 C2 01 89 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? 0F BE 08 89 8D 48 FF FF FF 8B 95 48 FF FF FF 83 EA 24 89 95 48 FF FF FF 83 BD 48 FF FF FF 25 0F 87 3B 01 00 00 8B 8D 48 FF FF FF 33 C0 8A 81 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 42 8D 55 F8 52 8D 45 C4 50 6A 27 8D 4D CC 51 8D 55 DC 52 E8 ?? ?? ?? ?? 83 C4 04 50 6A 60 8D 45 D4 50 E8 ?? ?? ?? ?? 83 C4 0C 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 50 8D 4D F8 E8 ?? ?? ?? ?? EB 0C 8D 4D BC 51 E8 ?? ?? ?? ?? 83 C4 04 E9 0B 01 00 00 8B 15 ?? ?? ?? ?? 83 EA 01 89 15 ?? ?? ?? ?? 8D 45 F8 50 8D 4D AC 51 8D 55 B4 52 E8 ?? ?? ?? ?? 83 C4 04 8B C8 E8 ?? ?? ?? ?? 50 8D 4D F8 E8 ?? ?? ?? ?? E9 D3 00 00 00 A1 ?? ?? ?? ?? 0F BE 08 83 F9 40 74 11 8B 15 ?? ?? ?? ?? 83 C2 01 89 15 ?? ?? ?? ?? EB E2 A1 ?? ?? ?? ?? 83 C0 01 A3 ?? ?? ?? ?? 8D 4D F8 51 68 ?? ?? ?? ?? 8D 55 A4 52 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D F8 E8 ?? ?? ?? ?? E9 85 00 00 00 A1 ?? ?? ?? ?? 83 C0 01 A3 ?? ?? ?? ?? 8D 4D F8 51 8D 55 8C 52 6A 5D 8D 45 94 50 8D 4D 9C 51 E8 ?? ?? ?? ?? 83 C4 04 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 50 8D 4D F8 E8 ?? ?? ?? ?? C6 45 F4 01 EB 41 E8 ?? ?? ?? ?? 85 C0 75 29 8D 55 F8 52 8D 85 7C FF FF FF 50 8D 4D 84 51 E8 ?? ?? ?? ?? 83 C4 04 8B C8 E8 ?? ?? ?? ?? 50 8D 4D F8 E8 ?? ?? ?? ?? EB 0F 8D 95 74 FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 EB 2A 8D 45 F8 50 8D 8D 64 FF FF FF 51 8D 95 6C FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 8B C8 E8 ?? ?? ?? ?? 50 8D 4D F8 E8 ?? ?? ?? ?? E9 82 FD FF FF A1 ?? ?? ?? ?? 8A 08 88 8D 44 FF FF FF 80 BD 44 FF FF FF 00 74 0B 80 BD 44 FF FF FF 40 74 57 EB 57 8D 4D F8 E8 ?? ?? ?? ?? 85 C0 74 0C 6A 02 8D 4D F8 E8 ?? ?? ?? ?? EB 3B 8D 55 F8 52 8D 85 4C FF FF FF 50 68 ?? ?? ?? ?? 8D 8D 54 FF FF FF 51 6A 02 8D 8D 5C FF FF FF E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 50 8D 4D F8 E8 ?? ?? ?? ?? EB 0C EB 0A 6A 01 8D 4D F8 E8 ?? ?? ?? ?? 8D 55 F8 52 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 01 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 02 04 04 04 04 04 04 04 04 04 03 }
	condition:
		$1
}

rule file_69_11_0 {
	meta:
		name = "?getSignedDimension@UnDecorator@@CA?AVDName@@XZ"
		size = 131
		refs = "0007 ?gName@UnDecorator@@0PBDB 0018 ??0DName@@QAE@W4DNameStatus@@@Z 0043 ?getDimension@UnDecorator@@CA?AVDName@@XZ 0052 ??H@YA?AVDName@@DABV0@@Z 005e ??0DName@@QAE@ABV0@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 18 A1 ?? ?? ?? ?? 0F BE 08 85 C9 75 0F 6A 02 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 EB 5E 8B 15 ?? ?? ?? ?? 0F BE 02 83 F8 3F 75 38 8B 0D ?? ?? ?? ?? 83 C1 01 89 0D ?? ?? ?? ?? 8D 55 F8 52 E8 ?? ?? ?? ?? 83 C4 04 50 6A 2D 8D 45 F0 50 E8 ?? ?? ?? ?? 83 C4 0C 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 EB 18 8D 4D E8 51 E8 ?? ?? ?? ?? 83 C4 04 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_12_0 {
	meta:
		name = "?getDimension@UnDecorator@@CA?AVDName@@XZ"
		size = 318
		refs = "0007 ?gName@UnDecorator@@0PBDB 0018 ??0DName@@QAE@W4DNameStatus@@@Z 0063 ??0DName@@QAE@K@Z 006c ??0DName@@QAE@ABV0@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 A1 ?? ?? ?? ?? 0F BE 08 85 C9 75 12 6A 02 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 16 01 00 00 8B 15 ?? ?? ?? ?? 0F BE 02 83 F8 30 7C 46 8B 0D ?? ?? ?? ?? 0F BE 11 83 FA 39 7F 38 A1 ?? ?? ?? ?? 0F BE 08 83 E9 2F 89 4D F0 8B 55 F0 52 A1 ?? ?? ?? ?? 83 C0 01 A3 ?? ?? ?? ?? 8D 4D F4 E8 ?? ?? ?? ?? 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 C2 00 00 00 C7 45 FC 00 00 00 00 8B 0D ?? ?? ?? ?? 0F BE 11 83 FA 40 74 72 A1 ?? ?? ?? ?? 0F BE 08 85 C9 75 12 6A 02 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 8F 00 00 00 8B 15 ?? ?? ?? ?? 0F BE 02 83 F8 41 7C 26 8B 0D ?? ?? ?? ?? 0F BE 11 83 FA 50 7F 18 8B 45 FC C1 E0 04 8B 0D ?? ?? ?? ?? 0F BE 11 8D 44 10 BF 89 45 FC EB 0F 6A 01 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 EB 4C 8B 0D ?? ?? ?? ?? 83 C1 01 89 0D ?? ?? ?? ?? EB 80 8B 15 ?? ?? ?? ?? 0F BE 02 8B 0D ?? ?? ?? ?? 83 C1 01 89 0D ?? ?? ?? ?? 83 F8 40 74 0F 6A 01 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 EB 0F 8B 55 FC 52 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_13_0 {
	meta:
		name = "?getNumberOfDimensions@UnDecorator@@CAHXZ"
		size = 233
		refs = "0005 ?gName@UnDecorator@@0PBDB"
	strings:
		$1 = { 55 8B EC 51 A1 ?? ?? ?? ?? 0F BE 08 85 C9 75 07 33 C0 E9 CE 00 00 00 8B 15 ?? ?? ?? ?? 0F BE 02 83 F8 30 7C 2D 8B 0D ?? ?? ?? ?? 0F BE 11 83 FA 39 7F 1F A1 ?? ?? ?? ?? 0F BE 00 83 E8 2F 8B 0D ?? ?? ?? ?? 83 C1 01 89 0D ?? ?? ?? ?? E9 93 00 00 00 C7 45 FC 00 00 00 00 8B 15 ?? ?? ?? ?? 0F BE 02 83 F8 40 74 5A 8B 0D ?? ?? ?? ?? 0F BE 11 85 D2 75 04 33 C0 EB 6D A1 ?? ?? ?? ?? 0F BE 08 83 F9 41 7C 26 8B 15 ?? ?? ?? ?? 0F BE 02 83 F8 50 7F 18 8B 4D FC C1 E1 04 8B 15 ?? ?? ?? ?? 0F BE 02 8D 4C 01 BF 89 4D FC EB 05 83 C8 FF EB 35 8B 15 ?? ?? ?? ?? 83 C2 01 89 15 ?? ?? ?? ?? EB 98 A1 ?? ?? ?? ?? 0F BE 08 8B 15 ?? ?? ?? ?? 83 C2 01 89 15 ?? ?? ?? ?? 83 F9 40 74 05 83 C8 FF EB 03 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_14_0 {
	meta:
		name = "?getTemplateName@UnDecorator@@CA?AVDName@@XZ"
		size = 350
		refs = "000a ?gName@UnDecorator@@0PBDB 002b ??0DName@@QAE@W4DNameStatus@@@Z 0048 ?pArgList@UnDecorator@@0PAVReplicator@@A 0053 ?pZNameList@UnDecorator@@0PAVReplicator@@A 005f ?pTemplateArgList@UnDecorator@@0PAVReplicator@@A 006d ??0Replicator@@QAE@XZ 00a9 ?getZName@UnDecorator@@CA?AVDName@@XZ 00b8 ??0DName@@QAE@ABV0@@Z 00c3 ?isEmpty@DName@@QBEHXZ 00d3 ?getTemplateArgumentList@UnDecorator@@CA?AVDName@@XZ 00e5 ??H@YA?AVDName@@DABV0@@Z 00f4 ??YDName@@QAEAAV0@ABV0@@Z 00ff ?getLastChar@DName@@QBEDXZ 0114 ??YDName@@QAEAAV0@D@Z"
	strings:
		$1 = { 55 8B EC 81 EC E0 00 00 00 A1 ?? ?? ?? ?? 0F BE 08 83 F9 3F 75 0F 8B 15 ?? ?? ?? ?? 0F BE 42 01 83 F8 24 74 12 6A 01 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 23 01 00 00 8B 0D ?? ?? ?? ?? 83 C1 02 89 0D ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 89 95 38 FF FF FF A1 ?? ?? ?? ?? 89 85 44 FF FF FF 8B 0D ?? ?? ?? ?? 89 8D 48 FF FF FF 8D 4D C4 E8 ?? ?? ?? ?? 8D 8D 4C FF FF FF E8 ?? ?? ?? ?? 8D 4D 88 E8 ?? ?? ?? ?? 8D 55 C4 89 15 ?? ?? ?? ?? 8D 85 4C FF FF FF A3 ?? ?? ?? ?? 8D 4D 88 89 0D ?? ?? ?? ?? 8D 95 30 FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 50 8D 8D 3C FF FF FF E8 ?? ?? ?? ?? 8D 8D 3C FF FF FF E8 ?? ?? ?? ?? 85 C0 75 5A 8D 85 28 FF FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 50 6A 3C 8D 8D 20 FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 8D 3C FF FF FF E8 ?? ?? ?? ?? 8D 8D 3C FF FF FF E8 ?? ?? ?? ?? 0F BE D0 83 FA 3E 75 0D 6A 20 8D 8D 3C FF FF FF E8 ?? ?? ?? ?? 6A 3E 8D 8D 3C FF FF FF E8 ?? ?? ?? ?? 8B 85 38 FF FF FF A3 ?? ?? ?? ?? 8B 8D 44 FF FF FF 89 0D ?? ?? ?? ?? 8B 95 48 FF FF FF 89 15 ?? ?? ?? ?? 8D 85 3C FF FF FF 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_15_0 {
	meta:
		name = "?getTemplateArgumentList@UnDecorator@@CA?AVDName@@XZ"
		size = 609
		refs = "0011 ??0DName@@QAE@XZ 0019 ?status@DName@@QBE?AW4DNameStatus@@XZ 0026 ?gName@UnDecorator@@0PBDB 005c ??YDName@@QAEAAV0@D@Z 008e ?pTemplateArgList@UnDecorator@@0PAVReplicator@@A 0093 ??AReplicator@@QBEABVDName@@H@Z 009c ??YDName@@QAEAAV0@ABV0@@Z 00d3 ??_C@_04BMNE@void?$AA@ 00db ??4DName@@QAEAAV0@PBD@Z 0114 ?getTemplateConstant@UnDecorator@@CA?AVDName@@XZ 0120 ??4DName@@QAEAAV0@ABV0@@Z 013f ?getSignedDimension@UnDecorator@@CA?AVDName@@XZ 014b ??0DName@@QAE@ABV0@@Z 0150 ?haveTemplateParameters@UnDecorator@@SAHXZ 0162 ?getString@DName@@QBEPADPADH@Z 016b _atol 0175 ?m_pGetParameter@UnDecorator@@0P6APADJ@ZA 0194 ??_C@_01HAF@?8?$AA@ 01a1 ??_C@_0BE@EFGJ@?$GAtemplate?9parameter?$AA@ 01aa ??H@YA?AVDName@@PBDABV0@@Z 01b4 ??HDName@@QBE?AV0@PBD@Z 0201 ?getPrimaryDataType@UnDecorator@@CA?AVDName@@ABV2@@Z 0226 ?isFull@Replicator@@QBEHXZ 0239 ??YReplicator@@QAEAAV0@ABVDName@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 78 C7 45 FC 01 00 00 00 8D 4D F4 E8 ?? ?? ?? ?? 8D 4D F4 E8 ?? ?? ?? ?? 85 C0 0F 85 29 02 00 00 A1 ?? ?? ?? ?? 0F BE 08 85 C9 0F 84 19 02 00 00 8B 15 ?? ?? ?? ?? 0F BE 02 83 F8 40 0F 84 07 02 00 00 83 7D FC 00 74 09 C7 45 FC 00 00 00 00 EB 0A 6A 2C 8D 4D F4 E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 0F BE 11 83 EA 30 89 55 F0 83 7D F0 00 7C 30 83 7D F0 09 7F 2A A1 ?? ?? ?? ?? 83 C0 01 A3 ?? ?? ?? ?? 8B 4D F0 51 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 8D 4D F4 E8 ?? ?? ?? ?? E9 A4 01 00 00 8B 15 ?? ?? ?? ?? 89 55 E4 8D 4D E8 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 0F BE 08 83 F9 58 75 21 8B 15 ?? ?? ?? ?? 83 C2 01 89 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 4D E8 E8 ?? ?? ?? ?? E9 2D 01 00 00 A1 ?? ?? ?? ?? 0F BE 08 83 F9 24 75 38 8B 15 ?? ?? ?? ?? 0F BE 42 01 83 F8 24 74 29 8B 0D ?? ?? ?? ?? 83 C1 01 89 0D ?? ?? ?? ?? 8D 55 C0 52 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D E8 E8 ?? ?? ?? ?? E9 E8 00 00 00 A1 ?? ?? ?? ?? 0F BE 08 83 F9 3F 0F 85 B9 00 00 00 8D 55 B8 52 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D DC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 6B 6A 10 8D 45 C8 50 8D 4D DC E8 ?? ?? ?? ?? 8D 4D C8 51 E8 ?? ?? ?? ?? 83 C4 04 50 FF 15 ?? ?? ?? ?? 83 C4 04 89 45 D8 83 7D D8 00 74 0E 8B 55 D8 52 8D 4D E8 E8 ?? ?? ?? ?? EB 2E 68 ?? ?? ?? ?? 8D 45 A8 50 8D 4D DC 51 68 ?? ?? ?? ?? 8D 55 B0 52 E8 ?? ?? ?? ?? 83 C4 0C 8B C8 E8 ?? ?? ?? ?? 50 8D 4D E8 E8 ?? ?? ?? ?? EB 2E 68 ?? ?? ?? ?? 8D 45 98 50 8D 4D DC 51 68 ?? ?? ?? ?? 8D 55 A0 52 E8 ?? ?? ?? ?? 83 C4 0C 8B C8 E8 ?? ?? ?? ?? 50 8D 4D E8 E8 ?? ?? ?? ?? EB 1E 8D 4D 90 E8 ?? ?? ?? ?? 50 8D 45 88 50 E8 ?? ?? ?? ?? 83 C4 08 50 8D 4D E8 E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 2B 4D E4 83 F9 01 7E 1E 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 0F 8D 55 E8 52 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 45 E8 50 8D 4D F4 E8 ?? ?? ?? ?? E9 C7 FD FF FF 8D 4D F4 51 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_16_0 {
	meta:
		name = "?getTemplateConstant@UnDecorator@@CA?AVDName@@XZ"
		size = 756
		refs = "000a ?gName@UnDecorator@@0PBDB 0049 $L3498 0050 $L3499 005c ?getSignedDimension@UnDecorator@@CA?AVDName@@XZ 0068 ??0DName@@QAE@ABV0@@Z 0090 ??_C@_04BAK@NULL?$AA@ 0098 ??0DName@@QAE@PBD@Z 00ac ?getDecoratedName@UnDecorator@@CA?AVDName@@XZ 00bc ??_C@_01KNJC@?$CG?$AA@ 00ce ??HDName@@QBE?AV0@ABV0@@Z 0117 ?isValid@DName@@QBEHXZ 013d ?getString@DName@@QBEPADPADH@Z 014b ??0DName@@QAE@W4DNameStatus@@@Z 019c ??HDName@@QBE?AV0@D@Z 01e3 ?haveTemplateParameters@UnDecorator@@SAHXZ 0204 _atol 020e ?m_pGetParameter@UnDecorator@@0P6APADJ@ZA 0230 ??_C@_01HAF@?8?$AA@ 0240 ??_C@_0BE@EFGJ@?$GAtemplate?9parameter?$AA@ 024c ??H@YA?AVDName@@PBDABV0@@Z 0256 ??HDName@@QBE?AV0@PBD@Z 0297 $L1506 029b $L1474 029f $L1476 02a3 $L1479 02a7 $L1496 02ab $L1507"
	strings:
		$1 = { 55 8B EC 81 EC F8 00 00 00 A1 ?? ?? ?? ?? 0F BE 08 89 8D 0C FF FF FF 8B 15 ?? ?? ?? ?? 83 C2 01 89 15 ?? ?? ?? ?? 8B 85 0C FF FF FF 89 85 08 FF FF FF 83 BD 08 FF FF FF 44 0F 87 47 02 00 00 8B 95 08 FF FF FF 33 C9 8A 8A ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? 8D 85 68 FF FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 1F 02 00 00 8B 0D ?? ?? ?? ?? 0F BE 11 83 FA 40 75 22 A1 ?? ?? ?? ?? 83 C0 01 A3 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 EF 01 00 00 8D 8D 58 FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 50 8D 95 50 FF FF FF 52 68 ?? ?? ?? ?? 8D 8D 60 FF FF FF E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 B0 01 00 00 8D 85 48 FF FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D F0 E8 ?? ?? ?? ?? 8D 8D 40 FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D F8 E8 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? 85 C0 0F 84 95 00 00 00 8D 4D F8 E8 ?? ?? ?? ?? 85 C0 0F 84 85 00 00 00 6A 64 8D 55 8D 52 8D 4D F0 E8 ?? ?? ?? ?? 85 C0 75 12 6A 01 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 3C 01 00 00 8A 45 8D 88 45 8C 0F BE 4D 8C 83 F9 2D 75 0C 8A 55 8E 88 55 8D C6 45 8E 2E EB 04 C6 45 8D 2E 8D 45 F8 50 8D 8D 28 FF FF FF 51 6A 65 8D 95 30 FF FF FF 52 8D 45 8C 50 8D 8D 38 FF FF FF E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 DB 00 00 00 6A 02 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 C9 00 00 00 8D 8D 20 FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D 84 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 44 6A 10 8D 95 70 FF FF FF 52 8D 4D 84 E8 ?? ?? ?? ?? 8D 85 70 FF FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 50 FF 15 ?? ?? ?? ?? 83 C4 04 89 45 80 83 7D 80 00 74 11 8B 4D 80 51 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 EB 64 68 ?? ?? ?? ?? 8D 95 10 FF FF FF 52 8D 45 84 50 68 ?? ?? ?? ?? 8D 8D 18 FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 8B C8 E8 ?? ?? ?? ?? 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 EB 2B 8B 15 ?? ?? ?? ?? 83 EA 01 89 15 ?? ?? ?? ?? 6A 02 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 EB 0D 6A 01 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 01 02 03 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 04 }
	condition:
		$1
}

rule file_69_17_0 {
	meta:
		name = "?composeDeclaration@UnDecorator@@CA?AVDName@@ABV2@@Z"
		size = 5051
		refs = "000d ??0DName@@QAE@XZ 0012 ?getTypeEncoding@UnDecorator@@CAHXZ 001d ?isUDC@DName@@QBEHXZ 0033 ??0DName@@QAE@W4DNameStatus@@@Z 0053 ??H@YA?AVDName@@W4DNameStatus@@ABV0@@Z 005f ??0DName@@QAE@ABV0@@Z 0220 ?doMSKeywords@UnDecorator@@SAHXZ 0229 ?doAllocationModel@UnDecorator@@SAHXZ 0236 ?getBasedType@UnDecorator@@CA?AVDName@@XZ 0245 ??H@YA?AVDName@@DABV0@@Z 0251 ??4DName@@QAEAAV0@ABV0@@Z 0268 ??_5DName@@QAEAAV0@ABV0@@Z 0329 ?getCallIndex@UnDecorator@@CA?AVDName@@XZ 033f ??HDName@@QBE?AV0@D@Z 0346 ??HDName@@QBE?AV0@ABV0@@Z 0356 ??YDName@@QAEAAV0@ABV0@@Z 035b ??_C@_03IKAL@?$HN?8?5?$AA@ 036b ?getVCallThunkType@UnDecorator@@CA?AVDName@@XZ 0375 ??HDName@@QBE?AV0@PBD@Z 038c ?doAllocationLanguage@UnDecorator@@SAHXZ 03b0 ?getCallingConvention@UnDecorator@@CA?AVDName@@XZ 04e8 ?getDisplacement@UnDecorator@@CA?AVDName@@XZ 05d9 ?doThisTypes@UnDecorator@@SAHXZ 05e9 ?getThisType@UnDecorator@@CA?AVDName@@XZ 0687 ?isEmpty@DName@@QBEHXZ 069c ?doNameOnly@UnDecorator@@SAHXZ 06ef ?getReturnType@UnDecorator@@CA?AVDName@@PAV2@@Z 06f8 ??_C@_01FCOA@?5?$AA@ 0704 ??H@YA?AVDName@@PBDABV0@@Z 0736 _heap 073d ??2@YAPAXIAAVHeapManager@@H@Z 0866 ??_C@_0L@DNFK@?$GAvtordisp?$HL?$AA@ 088c ??_C@_0L@NBLO@?$GAadjustor?$HL?$AA@ 0894 ??YDName@@QAEAAV0@PBD@Z 08c6 ?getArgumentTypes@UnDecorator@@CA?AVDName@@XZ 09c4 ?doThrowTypes@UnDecorator@@SAHXZ 09d4 ?getThrowTypes@UnDecorator@@CA?AVDName@@XZ 09ff ?doFunctionReturns@UnDecorator@@SAHXZ 0a60 ?getVfTableType@UnDecorator@@CA?AVDName@@ABV2@@Z 0aa0 ?getVbTableType@UnDecorator@@CA?AVDName@@ABV2@@Z 0ad6 ??_C@_02OLAP@?$HN?8?$AA@ 0ae9 ?getGuardNumber@UnDecorator@@CA?AVDName@@XZ 0bd1 ??_C@_0CB@DNFG@?$GAlocal?5static?5destructor?5helper?8@ 0c8b ??_C@_0DB@MCGN@?$GAtemplate?5static?5data?5member?5con@ 0d45 ??_C@_0DA@HHNE@?$GAtemplate?5static?5data?5member?5des@ 0e9a ?getExternalDataType@UnDecorator@@CA?AVDName@@ABV2@@Z 0ef5 ?doMemberTypes@UnDecorator@@SAHXZ 0f85 ??_C@_07LNPG@static?5?$AA@ 10e4 ??_C@_08HPJA@virtual?5?$AA@ 1101 ?doAccessSpecifiers@UnDecorator@@SAHXZ 11a0 ??_C@_09ODI@private?3?5?$AA@ 1256 ??_C@_0M@CBDC@protected?3?5?$AA@ 12ff ??_C@_08EIIM@public?3?5?$AA@ 138c ??_C@_08DJI@?$FLthunk?$FN?3?$AA@"
	strings:
		$1 = { 55 8B EC 81 EC 8C 02 00 00 8D 4D F0 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 FC 8B 4D 0C E8 ?? ?? ?? ?? 89 45 F8 81 7D FC FF FF 00 00 75 12 6A 01 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 78 13 00 00 81 7D FC FE FF 00 00 75 23 8B 45 0C 50 6A 02 8D 4D C4 51 E8 ?? ?? ?? ?? 83 C4 0C 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 4C 13 00 00 8B 55 FC 81 E2 00 80 00 00 85 D2 0F 84 AE 09 00 00 8B 45 FC 25 00 80 00 00 85 C0 74 1C 8B 4D FC 81 E1 00 18 00 00 33 D2 81 F9 00 08 00 00 0F 94 C2 89 95 3C FE FF FF EB 13 8B 45 FC 25 00 60 00 00 F7 D8 1B C0 40 89 85 3C FE FF FF 83 BD 3C FE FF FF 00 74 11 8B 4D FC 81 E1 00 04 00 00 89 8D 38 FE FF FF EB 0F 8B 55 FC 81 E2 00 10 00 00 89 95 38 FE FF FF 83 BD 38 FE FF FF 00 74 3F 8B 45 FC 25 00 80 00 00 85 C0 74 1C 8B 4D FC 81 E1 00 1B 00 00 33 D2 81 F9 00 10 00 00 0F 94 C2 89 95 34 FE FF FF EB 0A C7 85 34 FE FF FF 00 00 00 00 83 BD 34 FE FF FF 00 0F 85 02 09 00 00 8B 45 FC 25 00 80 00 00 85 C0 74 1C 8B 4D FC 81 E1 00 18 00 00 33 D2 81 F9 00 08 00 00 0F 94 C2 89 95 30 FE FF FF EB 13 8B 45 FC 25 00 60 00 00 F7 D8 1B C0 40 89 85 30 FE FF FF 83 BD 30 FE FF FF 00 74 11 8B 4D FC 81 E1 00 04 00 00 89 8D 2C FE FF FF EB 0F 8B 55 FC 81 E2 00 10 00 00 89 95 2C FE FF FF 83 BD 2C FE FF FF 00 74 7E 8B 45 FC 25 00 80 00 00 85 C0 74 1C 8B 4D FC 81 E1 00 1B 00 00 33 D2 81 F9 00 11 00 00 0F 94 C2 89 95 28 FE FF FF EB 0A C7 85 28 FE FF FF 00 00 00 00 83 BD 28 FE FF FF 00 0F 85 56 08 00 00 8B 45 FC 25 00 80 00 00 85 C0 74 1C 8B 4D FC 81 E1 00 1B 00 00 33 D2 81 F9 00 12 00 00 0F 94 C2 89 95 24 FE FF FF EB 0A C7 85 24 FE FF FF 00 00 00 00 83 BD 24 FE FF FF 00 0F 85 17 08 00 00 8B 45 FC 25 00 40 00 00 85 C0 74 4D E8 ?? ?? ?? ?? 85 C0 74 2F E8 ?? ?? ?? ?? 85 C0 74 26 8D 4D BC 51 E8 ?? ?? ?? ?? 83 C4 04 50 6A 20 8D 55 B4 52 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D F0 E8 ?? ?? ?? ?? EB 15 8D 45 AC 50 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D F0 E8 ?? ?? ?? ?? 8B 4D FC 81 E1 00 80 00 00 85 C9 74 1C 8B 55 FC 81 E2 00 18 00 00 33 C0 81 FA 00 08 00 00 0F 94 C0 89 85 20 FE FF FF EB 14 8B 4D FC 81 E1 00 60 00 00 F7 D9 1B C9 41 89 8D 20 FE FF FF 83 BD 20 FE FF FF 00 74 11 8B 55 FC 81 E2 00 04 00 00 89 95 1C FE FF FF EB 0E 8B 45 FC 25 00 10 00 00 89 85 1C FE FF FF 83 BD 1C FE FF FF 00 0F 84 21 01 00 00 8B 4D FC 81 E1 00 80 00 00 85 C9 74 1C 8B 55 FC 81 E2 00 18 00 00 33 C0 81 FA 00 18 00 00 0F 94 C0 89 85 18 FE FF FF EB 0A C7 85 18 FE FF FF 00 00 00 00 83 BD 18 FE FF FF 00 0F 84 E1 00 00 00 6A 2C 8D 4D 8C 51 8D 55 9C 52 E8 ?? ?? ?? ?? 83 C4 04 50 8D 45 94 50 6A 7B 8D 4D A4 51 8B 4D 0C E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 50 8D 4D F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 95 7C FF FF FF 52 8D 45 84 50 E8 ?? ?? ?? ?? 83 C4 04 8B C8 E8 ?? ?? ?? ?? 50 8D 4D F0 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 57 E8 ?? ?? ?? ?? 85 C0 74 4E 8D 4D F0 51 8D 95 5C FF FF FF 52 6A 20 8D 85 64 FF FF FF 50 8D 8D 74 FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 50 6A 20 8D 95 6C FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 50 8D 4D F0 E8 ?? ?? ?? ?? EB 18 8D 85 54 FF FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D F0 E8 ?? ?? ?? ?? E9 26 06 00 00 8D 4D D4 E8 ?? ?? ?? ?? 8D 4D DC E8 ?? ?? ?? ?? 8D 4D E8 E8 ?? ?? ?? ?? 8B 4D FC 81 E1 00 80 00 00 85 C9 74 1C 8B 55 FC 81 E2 00 18 00 00 33 C0 81 FA 00 08 00 00 0F 94 C0 89 85 14 FE FF FF EB 14 8B 4D FC 81 E1 00 60 00 00 F7 D9 1B C9 41 89 8D 14 FE FF FF 83 BD 14 FE FF FF 00 74 11 8B 55 FC 81 E2 00 04 00 00 89 95 10 FE FF FF EB 0E 8B 45 FC 25 00 10 00 00 89 85 10 FE FF FF 83 BD 10 FE FF FF 00 0F 84 87 00 00 00 8B 4D FC 81 E1 00 80 00 00 85 C9 74 1C 8B 55 FC 81 E2 00 18 00 00 33 C0 81 FA 00 08 00 00 0F 94 C0 89 85 0C FE FF FF EB 14 8B 4D FC 81 E1 00 60 00 00 F7 D9 1B C9 41 89 8D 0C FE FF FF 83 BD 0C FE FF FF 00 74 29 8B 55 FC 81 E2 00 07 00 00 81 FA 00 05 00 00 75 18 8D 85 4C FF FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D D4 E8 ?? ?? ?? ?? 8D 8D 44 FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D DC E8 ?? ?? ?? ?? 8B 55 FC 81 E2 00 80 00 00 85 D2 74 1A 8B 45 FC 25 00 18 00 00 33 C9 3D 00 08 00 00 0F 94 C1 89 8D 08 FE FF FF EB 14 8B 55 FC 81 E2 00 60 00 00 F7 DA 1B D2 42 89 95 08 FE FF FF 83 BD 08 FE FF FF 00 0F 84 BB 00 00 00 8B 45 FC 25 00 80 00 00 85 C0 74 1C 8B 4D FC 81 E1 00 18 00 00 33 D2 81 F9 00 08 00 00 0F 94 C2 89 95 04 FE FF FF EB 13 8B 45 FC 25 00 60 00 00 F7 D8 1B C0 40 89 85 04 FE FF FF 83 BD 04 FE FF FF 00 74 3C 8B 4D FC 81 E1 00 80 00 00 85 C9 74 1C 8B 55 FC 81 E2 00 07 00 00 33 C0 81 FA 00 02 00 00 0F 94 C0 89 85 00 FE FF FF EB 0A C7 85 00 FE FF FF 01 00 00 00 83 BD 00 FE FF FF 00 75 3B E8 ?? ?? ?? ?? 85 C0 74 1A 8D 8D 3C FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D E8 E8 ?? ?? ?? ?? EB 18 8D 95 34 FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D E8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 4F E8 ?? ?? ?? ?? 85 C0 74 2C 8D 45 F0 50 8D 8D 24 FF FF FF 51 8D 95 2C FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 8B C8 E8 ?? ?? ?? ?? 50 8D 4D F0 E8 ?? ?? ?? ?? EB 18 8D 85 1C FF FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D F0 E8 ?? ?? ?? ?? EB 18 8D 8D 14 FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D F0 E8 ?? ?? ?? ?? 8B 4D 0C E8 ?? ?? ?? ?? 85 C0 75 41 8D 4D F0 E8 ?? ?? ?? ?? 85 C0 75 29 E8 ?? ?? ?? ?? 85 C0 75 20 8B 55 0C 52 6A 20 8D 85 0C FF FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D F0 E8 ?? ?? ?? ?? EB 0C 8B 4D 0C 51 8D 4D F0 E8 ?? ?? ?? ?? C7 45 E4 00 00 00 00 8D 4D CC E8 ?? ?? ?? ?? 83 7D F8 00 74 4E 6A 00 8D 95 04 FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 50 68 ?? ?? ?? ?? 8D 85 FC FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D F0 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 14 8D 4D F0 51 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 86 0C 00 00 EB 62 6A 00 68 ?? ?? ?? ?? 6A 08 E8 ?? ?? ?? ?? 83 C4 0C 89 85 F8 FE FF FF 83 BD F8 FE FF FF 00 74 13 8B 8D F8 FE FF FF E8 ?? ?? ?? ?? 89 85 FC FD FF FF EB 0A C7 85 FC FD FF FF 00 00 00 00 8B 95 FC FD FF FF 89 55 E4 8B 45 E4 50 8D 8D F0 FE FF FF 51 E8 ?? ?? ?? ?? 83 C4 08 50 8D 4D CC E8 ?? ?? ?? ?? 8B 55 FC 81 E2 00 80 00 00 85 D2 74 1A 8B 45 FC 25 00 18 00 00 33 C9 3D 00 08 00 00 0F 94 C1 89 8D F8 FD FF FF EB 14 8B 55 FC 81 E2 00 60 00 00 F7 DA 1B D2 42 89 95 F8 FD FF FF 83 BD F8 FD FF FF 00 74 10 8B 45 FC 25 00 04 00 00 89 85 F4 FD FF FF EB 0F 8B 4D FC 81 E1 00 10 00 00 89 8D F4 FD FF FF 83 BD F4 FD FF FF 00 0F 84 B0 00 00 00 8B 55 FC 81 E2 00 80 00 00 85 D2 74 1A 8B 45 FC 25 00 18 00 00 33 C9 3D 00 08 00 00 0F 94 C1 89 8D F0 FD FF FF EB 14 8B 55 FC 81 E2 00 60 00 00 F7 DA 1B D2 42 89 95 F0 FD FF FF 83 BD F0 FD FF FF 00 74 42 8B 45 FC 25 00 07 00 00 3D 00 05 00 00 75 33 6A 2C 8D 8D E0 FE FF FF 51 8D 55 D4 52 68 ?? ?? ?? ?? 8D 85 E8 FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 8B C8 E8 ?? ?? ?? ?? 50 8D 4D F0 E8 ?? ?? ?? ?? EB 0D 68 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 8D D8 FE FF FF 51 8D 4D DC E8 ?? ?? ?? ?? 50 8D 4D F0 E8 ?? ?? ?? ?? 6A 29 8D 95 C0 FE FF FF 52 8D 85 D0 FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 50 6A 28 8D 8D C8 FE FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 8B C8 E8 ?? ?? ?? ?? 50 8D 4D F0 E8 ?? ?? ?? ?? 8B 55 FC 81 E2 00 80 00 00 85 D2 74 1A 8B 45 FC 25 00 18 00 00 33 C9 3D 00 08 00 00 0F 94 C1 89 8D EC FD FF FF EB 14 8B 55 FC 81 E2 00 60 00 00 F7 DA 1B D2 42 89 95 EC FD FF FF 83 BD EC FD FF FF 00 0F 84 8C 00 00 00 8B 45 FC 25 00 80 00 00 85 C0 74 1C 8B 4D FC 81 E1 00 18 00 00 33 D2 81 F9 00 08 00 00 0F 94 C2 89 95 E8 FD FF FF EB 13 8B 45 FC 25 00 60 00 00 F7 D8 1B C0 40 89 85 E8 FD FF FF 83 BD E8 FD FF FF 00 74 3C 8B 4D FC 81 E1 00 80 00 00 85 C9 74 1C 8B 55 FC 81 E2 00 07 00 00 33 C0 81 FA 00 02 00 00 0F 94 C0 89 85 E4 FD FF FF EB 0A C7 85 E4 FD FF FF 01 00 00 00 83 BD E4 FD FF FF 00 75 0C 8D 4D E8 51 8D 4D F0 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 1A 8D 95 B8 FE FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D F0 E8 ?? ?? ?? ?? EB 18 8D 85 B0 FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D F0 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 1E 83 7D E4 00 74 18 8D 4D F0 51 8B 4D E4 E8 ?? ?? ?? ?? 8D 55 CC 52 8D 4D F0 E8 ?? ?? ?? ?? E9 80 04 00 00 8B 45 0C 50 8D 4D F0 E8 ?? ?? ?? ?? 8B 4D FC 81 E1 00 80 00 00 85 C9 75 35 8B 55 FC 81 E2 00 78 00 00 81 FA 00 68 00 00 75 24 8D 45 F0 50 8D 8D A8 FE FF FF 51 E8 ?? ?? ?? ?? 83 C4 08 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 3F 09 00 00 8B 55 FC 81 E2 00 80 00 00 85 D2 75 33 8B 45 FC 25 00 78 00 00 3D 00 70 00 00 75 24 8D 4D F0 51 8D 95 A0 FE FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 FF 08 00 00 8B 45 FC 25 00 80 00 00 85 C0 75 64 8B 4D FC 81 E1 00 78 00 00 81 F9 00 60 00 00 75 53 68 ?? ?? ?? ?? 8D 95 80 FE FF FF 52 8D 85 90 FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 50 8D 8D 88 FE FF FF 51 6A 7B 8D 95 98 FE FF FF 52 8D 4D F0 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 8F 08 00 00 8B 45 FC 25 00 80 00 00 85 C0 74 1C 8B 4D FC 81 E1 00 18 00 00 33 D2 81 F9 00 08 00 00 0F 94 C2 89 95 E0 FD FF FF EB 13 8B 45 FC 25 00 60 00 00 F7 D8 1B C0 40 89 85 E0 FD FF FF 83 BD E0 FD FF FF 00 74 11 8B 4D FC 81 E1 00 04 00 00 89 8D DC FD FF FF EB 0F 8B 55 FC 81 E2 00 10 00 00 89 95 DC FD FF FF 83 BD DC FD FF FF 00 74 4D 8B 45 FC 25 00 80 00 00 85 C0 74 1C 8B 4D FC 81 E1 00 1B 00 00 33 D2 81 F9 00 10 00 00 0F 94 C2 89 95 D8 FD FF FF EB 0A C7 85 D8 FD FF FF 00 00 00 00 83 BD D8 FD FF FF 00 74 12 68 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? E9 A2 01 00 00 8B 45 FC 25 00 80 00 00 85 C0 74 1C 8B 4D FC 81 E1 00 18 00 00 33 D2 81 F9 00 08 00 00 0F 94 C2 89 95 D4 FD FF FF EB 13 8B 45 FC 25 00 60 00 00 F7 D8 1B C0 40 89 85 D4 FD FF FF 83 BD D4 FD FF FF 00 74 11 8B 4D FC 81 E1 00 04 00 00 89 8D D0 FD FF FF EB 0F 8B 55 FC 81 E2 00 10 00 00 89 95 D0 FD FF FF 83 BD D0 FD FF FF 00 74 4D 8B 45 FC 25 00 80 00 00 85 C0 74 1C 8B 4D FC 81 E1 00 1B 00 00 33 D2 81 F9 00 11 00 00 0F 94 C2 89 95 CC FD FF FF EB 0A C7 85 CC FD FF FF 00 00 00 00 83 BD CC FD FF FF 00 74 12 68 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? E9 E8 00 00 00 8B 45 FC 25 00 80 00 00 85 C0 74 1C 8B 4D FC 81 E1 00 18 00 00 33 D2 81 F9 00 08 00 00 0F 94 C2 89 95 C8 FD FF FF EB 13 8B 45 FC 25 00 60 00 00 F7 D8 1B C0 40 89 85 C8 FD FF FF 83 BD C8 FD FF FF 00 74 11 8B 4D FC 81 E1 00 04 00 00 89 8D C4 FD FF FF EB 0F 8B 55 FC 81 E2 00 10 00 00 89 95 C4 FD FF FF 83 BD C4 FD FF FF 00 74 4A 8B 45 FC 25 00 80 00 00 85 C0 74 1C 8B 4D FC 81 E1 00 1B 00 00 33 D2 81 F9 00 12 00 00 0F 94 C2 89 95 C0 FD FF FF EB 0A C7 85 C0 FD FF FF 00 00 00 00 83 BD C0 FD FF FF 00 74 0F 68 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? EB 31 8B 45 FC 25 00 80 00 00 85 C0 75 25 8B 4D FC 81 E1 00 78 00 00 81 F9 00 78 00 00 75 14 8D 55 F0 52 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 33 06 00 00 8B 45 FC 25 00 80 00 00 85 C0 74 1C 8B 4D FC 81 E1 00 18 00 00 33 D2 81 F9 00 08 00 00 0F 94 C2 89 95 BC FD FF FF EB 13 8B 45 FC 25 00 60 00 00 F7 D8 1B C0 40 89 85 BC FD FF FF 83 BD BC FD FF FF 00 74 11 8B 4D FC 81 E1 00 04 00 00 89 8D B8 FD FF FF EB 0F 8B 55 FC 81 E2 00 10 00 00 89 95 B8 FD FF FF 83 BD B8 FD FF FF 00 0F 84 99 00 00 00 8B 45 FC 25 00 80 00 00 85 C0 74 1C 8B 4D FC 81 E1 00 1B 00 00 33 D2 81 F9 00 11 00 00 0F 94 C2 89 95 B4 FD FF FF EB 0A C7 85 B4 FD FF FF 00 00 00 00 83 BD B4 FD FF FF 00 75 3B 8B 45 FC 25 00 80 00 00 85 C0 74 1C 8B 4D FC 81 E1 00 1B 00 00 33 D2 81 F9 00 12 00 00 0F 94 C2 89 95 B0 FD FF FF EB 0A C7 85 B0 FD FF FF 00 00 00 00 83 BD B0 FD FF FF 00 74 23 8D 45 F0 50 68 ?? ?? ?? ?? 8D 8D 78 FE FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D F0 E8 ?? ?? ?? ?? EB 1C 8D 55 F0 52 8D 85 70 FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 08 50 8D 4D F0 E8 ?? ?? ?? ?? 8B 4D FC 81 E1 00 80 00 00 85 C9 74 1C 8B 55 FC 81 E2 00 18 00 00 33 C0 81 FA 00 08 00 00 0F 94 C0 89 85 AC FD FF FF EB 14 8B 4D FC 81 E1 00 60 00 00 F7 D9 1B C9 41 89 8D AC FD FF FF 83 BD AC FD FF FF 00 0F 84 27 04 00 00 E8 ?? ?? ?? ?? 85 C0 0F 84 FF 01 00 00 8B 55 FC 81 E2 00 80 00 00 85 D2 74 1A 8B 45 FC 25 00 18 00 00 33 C9 3D 00 08 00 00 0F 94 C1 89 8D A8 FD FF FF EB 14 8B 55 FC 81 E2 00 60 00 00 F7 DA 1B D2 42 89 95 A8 FD FF FF 83 BD A8 FD FF FF 00 74 5C 8B 45 FC 25 00 80 00 00 85 C0 74 1C 8B 4D FC 81 E1 00 07 00 00 33 D2 81 F9 00 02 00 00 0F 94 C2 89 95 A4 FD FF FF EB 0A C7 85 A4 FD FF FF 01 00 00 00 83 BD A4 FD FF FF 00 74 21 8D 45 F0 50 68 ?? ?? ?? ?? 8D 8D 68 FE FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D F0 E8 ?? ?? ?? ?? 8B 55 FC 81 E2 00 80 00 00 85 D2 74 13 8B 45 FC 25 00 07 00 00 3D 00 01 00 00 0F 84 1E 01 00 00 8B 4D FC 81 E1 00 80 00 00 85 C9 74 1C 8B 55 FC 81 E2 00 18 00 00 33 C0 81 FA 00 08 00 00 0F 94 C0 89 85 A0 FD FF FF EB 14 8B 4D FC 81 E1 00 60 00 00 F7 D9 1B C9 41 89 8D A0 FD FF FF 83 BD }
	condition:
		$1
}

rule file_69_18_0 {
	meta:
		name = "?getTypeEncoding@UnDecorator@@CAHXZ"
		size = 1834
		refs = "000e ?gName@UnDecorator@@0PBDB 019e $L3692 0268 $L3693 026f $L3694 0471 $L3695 0688 $L1691 068c $L1692 0690 $L1689 0698 $L1687 06a0 $L1685 06a4 $L1703 06a8 $L1704 06ac $L1699 06b0 $L1700 06b4 $L1701 06b8 $L1702 06bc $L1722 0706 $L1734 070a $L1737 070e $L1740 0712 $L1742 0716 $L1746 071a $L1744 071e $L1748 0722 $L1750 0726 $L1752"
	strings:
		$1 = { 55 8B EC 83 EC 70 C7 45 FC 00 00 00 00 A1 ?? ?? ?? ?? 0F BE 08 83 F9 5F 75 16 8B 55 FC 80 CE 40 89 55 FC A1 ?? ?? ?? ?? 83 C0 01 A3 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 0F BE 11 83 FA 41 0F 8C EA 01 00 00 A1 ?? ?? ?? ?? 0F BE 08 83 F9 5A 0F 8F D9 01 00 00 8B 15 ?? ?? ?? ?? 0F BE 02 83 E8 41 89 45 F8 8B 0D ?? ?? ?? ?? 83 C1 01 89 0D ?? ?? ?? ?? 8B 55 FC 80 CE 80 89 55 FC 8B 45 F8 83 E0 01 85 C0 74 0B 8B 4D FC 80 CD 20 89 4D FC EB 09 8B 55 FC 80 E6 DF 89 55 FC 83 7D F8 18 0F 8D 85 01 00 00 8B 45 FC 25 00 80 00 00 85 C0 74 14 8B 4D FC 80 E5 E7 80 CD 08 89 4D FC 8B 55 FC 89 55 EC EB 0F 8B 45 FC 80 E4 9F 89 45 FC 8B 4D FC 89 4D EC 8B 55 F8 83 E2 18 89 55 E8 83 7D E8 00 74 11 83 7D E8 08 74 39 83 7D E8 10 74 62 E9 85 00 00 00 8B 45 FC 25 00 80 00 00 85 C0 74 0E 8B 4D FC 80 E1 3F 83 C9 40 89 4D E4 EB 0C 8B 55 FC 80 E6 E7 80 CE 08 89 55 E4 8B 45 E4 89 45 FC EB 66 8B 4D FC 81 E1 00 80 00 00 85 C9 74 0E 8B 55 FC 80 E2 3F 80 CA 80 89 55 E0 EB 0C 8B 45 FC 80 E4 E7 80 CC 10 89 45 E0 8B 4D E0 89 4D FC EB 37 8B 55 FC 81 E2 00 80 00 00 85 D2 74 0A 8B 45 FC 24 3F 89 45 DC EB 09 8B 4D FC 80 E5 E7 89 4D DC 8B 55 DC 89 55 FC EB 0F C7 45 FC FF FF 00 00 8B 45 FC E9 FF 04 00 00 8B 45 F8 83 E0 06 89 45 D8 83 7D D8 06 0F 87 80 00 00 00 8B 4D D8 FF 24 8D ?? ?? ?? ?? 8B 55 FC 80 E6 F8 80 CE 04 89 55 FC EB 77 8B 45 FC 80 E4 F8 80 CC 01 89 45 FC EB 69 8B 4D FC 81 E1 00 80 00 00 85 C9 74 0E 8B 55 FC 80 E6 F8 80 CE 02 89 55 D4 EB 35 8B 45 FC 25 00 80 00 00 85 C0 74 14 8B 4D FC 80 E5 E7 80 CD 08 89 4D FC 8B 55 FC 89 55 D0 EB 0F 8B 45 FC 80 E4 9F 89 45 FC 8B 4D FC 89 4D D0 8B 55 D0 89 55 D4 8B 45 D4 89 45 FC EB 11 EB 0F C7 45 FC FF FF 00 00 8B 45 FC E9 5D 04 00 00 E9 55 04 00 00 8B 0D ?? ?? ?? ?? 0F BE 11 83 FA 24 0F 85 CD 01 00 00 A1 ?? ?? ?? ?? 83 C0 01 A3 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 0F BE 11 89 55 CC 83 7D CC 45 0F 87 87 01 00 00 8B 4D CC 33 C0 8A 81 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 8B 55 FC 80 E6 64 80 CE 90 89 55 FC E9 73 01 00 00 8B 45 FC 80 E4 67 80 CC 98 89 45 FC E9 62 01 00 00 8B 4D FC 80 E5 64 80 CD 91 89 4D FC E9 51 01 00 00 8B 55 FC 80 E6 64 80 CE 92 89 55 FC E9 40 01 00 00 C7 45 FC FE FF 00 00 E9 34 01 00 00 A1 ?? ?? ?? ?? 0F BE 08 83 E9 30 89 4D F4 8B 55 FC 80 CE 80 89 55 FC 8B 45 FC 25 00 80 00 00 85 C0 74 14 8B 4D FC 80 E5 E7 80 CD 08 89 4D FC 8B 55 FC 89 55 C8 EB 0F 8B 45 FC 80 E4 9F 89 45 FC 8B 4D FC 89 4D C8 8B 55 FC 80 E6 F8 80 CE 05 89 55 FC 8B 45 F4 83 E0 01 85 C0 74 0B 8B 4D FC 80 CD 20 89 4D FC EB 09 8B 55 FC 80 E6 DF 89 55 FC 8B 45 F4 83 E0 06 89 45 C4 83 7D C4 00 74 11 83 7D C4 02 74 3A 83 7D C4 04 74 61 E9 84 00 00 00 8B 4D FC 81 E1 00 80 00 00 85 C9 74 0E 8B 55 FC 80 E2 3F 83 CA 40 89 55 C0 EB 0C 8B 45 FC 80 E4 E7 80 CC 08 89 45 C0 8B 4D C0 89 4D FC EB 64 8B 55 FC 81 E2 00 80 00 00 85 D2 74 0C 8B 45 FC 24 3F 0C 80 89 45 BC EB 0C 8B 4D FC 80 E5 E7 80 CD 10 89 4D BC 8B 55 BC 89 55 FC EB 37 8B 45 FC 25 00 80 00 00 85 C0 74 0B 8B 4D FC 80 E1 3F 89 4D B8 EB 09 8B 55 FC 80 E6 E7 89 55 B8 8B 45 B8 89 45 FC EB 0F C7 45 FC FF FF 00 00 8B 45 FC E9 9E 02 00 00 EB 0F C7 45 FC FF FF 00 00 8B 45 FC E9 8D 02 00 00 8B 0D ?? ?? ?? ?? 83 C1 01 89 0D ?? ?? ?? ?? E9 76 02 00 00 8B 15 ?? ?? ?? ?? 0F BE 02 83 F8 30 0F 8C 47 02 00 00 8B 0D ?? ?? ?? ?? 0F BE 11 83 FA 38 0F 8F 35 02 00 00 A1 ?? ?? ?? ?? 0F BE 08 89 4D F0 8B 15 ?? ?? ?? ?? 83 C2 01 89 15 ?? ?? ?? ?? 8B 45 FC 80 E4 7F 89 45 FC 8B 4D F0 89 4D B4 8B 55 B4 83 EA 30 89 55 B4 83 7D B4 08 0F 87 EB 01 00 00 8B 45 B4 FF 24 85 ?? ?? ?? ?? 8B 4D FC 81 E1 00 80 00 00 85 C9 74 0E 8B 55 FC 80 E6 F8 80 CE 02 89 55 B0 EB 35 8B 45 FC 25 00 80 00 00 85 C0 74 14 8B 4D FC 80 E5 E7 80 CD 08 89 4D FC 8B 55 FC 89 55 AC EB 0F 8B 45 FC 80 E4 9F 89 45 FC 8B 4D FC 89 4D AC 8B 55 AC 89 55 B0 8B 45 B0 89 45 FC 8B 4D FC 81 E1 00 80 00 00 85 C9 74 0E 8B 55 FC 80 E2 3F 83 CA 40 89 55 A8 EB 0C 8B 45 FC 80 E4 E7 80 CC 08 89 45 A8 8B 4D A8 89 4D FC E9 65 01 00 00 8B 55 FC 81 E2 00 80 00 00 85 D2 74 0E 8B 45 FC 80 E4 F8 80 CC 02 89 45 A4 EB 36 8B 4D FC 81 E1 00 80 00 00 85 C9 74 14 8B 55 FC 80 E6 E7 80 CE 08 89 55 FC 8B 45 FC 89 45 A0 EB 0F 8B 4D FC 80 E5 9F 89 4D FC 8B 55 FC 89 55 A0 8B 45 A0 89 45 A4 8B 4D A4 89 4D FC 8B 55 FC 81 E2 00 80 00 00 85 D2 74 0C 8B 45 FC 24 3F 0C 80 89 45 9C EB 0C 8B 4D FC 80 E5 E7 80 CD 10 89 4D 9C 8B 55 9C 89 55 FC E9 DE 00 00 00 8B 45 FC 25 00 80 00 00 85 C0 74 0E 8B 4D FC 80 E5 F8 80 CD 02 89 4D 98 EB 36 8B 55 FC 81 E2 00 80 00 00 85 D2 74 14 8B 45 FC 80 E4 E7 80 CC 08 89 45 FC 8B 4D FC 89 4D 94 EB 0F 8B 55 FC 80 E6 9F 89 55 FC 8B 45 FC 89 45 94 8B 4D 94 89 4D 98 8B 55 98 89 55 FC 8B 45 FC 25 00 80 00 00 85 C0 74 0B 8B 4D FC 80 E1 3F 89 4D 90 EB 09 8B 55 FC 80 E6 E7 89 55 90 8B 45 90 89 45 FC EB 60 8B 4D FC 80 E5 9F 80 CD 40 89 4D FC EB 52 8B 55 FC 80 E6 87 80 CE 60 89 55 FC EB 44 8B 45 FC 80 E4 9F 80 CC 20 89 45 FC EB 36 8B 4D FC 80 E5 87 80 CD 68 89 4D FC EB 28 8B 55 FC 80 E6 87 80 CE 70 89 55 FC EB 1A 8B 45 FC 80 E4 87 80 CC 78 89 45 FC EB 0C C7 45 FC FF FF 00 00 8B 45 FC EB 22 EB 1D 8B 0D ?? ?? ?? ?? 0F BE 11 85 D2 74 09 C7 45 FC FF FF 00 00 EB 07 C7 45 FC FE FF 00 00 8B 45 FC 8B E5 5D C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 01 01 01 01 01 01 06 06 06 06 06 06 06 06 06 06 06 02 03 06 04 05 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_69_19_0 {
	meta:
		name = "?getBasedType@UnDecorator@@CA?AVDName@@XZ"
		size = 187
		refs = "0009 ?UScore@UnDecorator@@SAPBDW4Tokens@@@Z 0015 ??0DName@@QAE@PBD@Z 001a ?gName@UnDecorator@@0PBDB 005b ??_C@_04BMNE@void?$AA@ 0063 ??YDName@@QAEAAV0@PBD@Z 006e ?getScopedName@UnDecorator@@CA?AVDName@@XZ 007a ??YDName@@QAEAAV0@ABV0@@Z 0086 ??0DName@@QAE@W4DNameStatus@@@Z 0097 ??YDName@@QAEAAV0@W4DNameStatus@@@Z 009c ??_C@_02CEEM@?$CJ?5?$AA@ 00b0 ??0DName@@QAE@ABV0@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 18 6A 00 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D F8 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 0F BE 08 85 C9 74 6C 8B 15 ?? ?? ?? ?? 0F BE 02 89 45 EC 8B 0D ?? ?? ?? ?? 83 C1 01 89 0D ?? ?? ?? ?? 8B 55 EC 89 55 E8 83 7D E8 30 74 0E 83 7D E8 32 74 17 83 7D E8 35 74 28 EB 35 68 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? EB 26 8D 45 F0 50 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D F8 E8 ?? ?? ?? ?? EB 0F 6A 01 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 EB 28 EB 0A 6A 02 8D 4D F8 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? 8D 4D F8 51 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_20_0 {
	meta:
		name = "?getScopedName@UnDecorator@@CA?AVDName@@XZ"
		size = 272
		refs = "000a ??0DName@@QAE@XZ 0013 ?getZName@UnDecorator@@CA?AVDName@@XZ 001f ??4DName@@QAEAAV0@ABV0@@Z 0027 ?status@DName@@QBE?AW4DNameStatus@@XZ 0031 ?gName@UnDecorator@@0PBDB 0052 ??_C@_02NNPM@?3?3?$AA@ 005f ?getScope@UnDecorator@@CA?AVDName@@XZ 0069 ??HDName@@QBE?AV0@PBD@Z 0070 ??HDName@@QBE?AV0@ABV0@@Z 00ad ??4DName@@QAEAAV0@W4DNameStatus@@@Z 00b7 ?isEmpty@DName@@QBEHXZ 00e2 ??0DName@@QAE@W4DNameStatus@@@Z 0105 ??0DName@@QAE@ABV0@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 40 8D 4D F8 E8 ?? ?? ?? ?? 8D 45 F0 50 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D F8 E8 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? 85 C0 75 4E 8B 0D ?? ?? ?? ?? 0F BE 11 85 D2 74 41 A1 ?? ?? ?? ?? 0F BE 08 83 F9 40 74 34 8D 55 F8 52 8D 45 D8 50 68 ?? ?? ?? ?? 8D 4D E0 51 8D 55 E8 52 E8 ?? ?? ?? ?? 83 C4 04 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 50 8D 4D F8 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 0F BE 08 83 F9 40 75 11 8B 15 ?? ?? ?? ?? 83 C2 01 89 15 ?? ?? ?? ?? EB 62 A1 ?? ?? ?? ?? 0F BE 08 85 C9 74 0C 6A 01 8D 4D F8 E8 ?? ?? ?? ?? EB 4A 8D 4D F8 E8 ?? ?? ?? ?? 85 C0 74 0C 6A 02 8D 4D F8 E8 ?? ?? ?? ?? EB 32 8D 55 F8 52 8D 45 C0 50 68 ?? ?? ?? ?? 8D 4D C8 51 6A 02 8D 4D D0 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 50 8D 4D F8 E8 ?? ?? ?? ?? 8D 55 F8 52 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_21_0 {
	meta:
		name = "?getCallingConvention@UnDecorator@@CA?AVDName@@XZ"
		size = 344
		refs = "0007 ?gName@UnDecorator@@0PBDB 004c ??0DName@@QAE@XZ 0051 ?doMSKeywords@UnDecorator@@SAHXZ 0077 $L3707 007e $L3708 0085 ?UScore@UnDecorator@@SAPBDW4Tokens@@@Z 0091 ??4DName@@QAEAAV0@PBD@Z 0106 ??0DName@@QAE@ABV0@@Z 0115 ??0DName@@QAE@W4DNameStatus@@@Z 012f $L1843 0133 $L1845 0137 $L1847 013b $L1849 013f $L1851 0143 $L1853 0147 $L1839"
	strings:
		$1 = { 55 8B EC 83 EC 10 A1 ?? ?? ?? ?? 0F BE 08 85 C9 0F 84 08 01 00 00 8B 15 ?? ?? ?? ?? 0F BE 02 83 E8 41 89 45 FC 8B 0D ?? ?? ?? ?? 83 C1 01 89 0D ?? ?? ?? ?? 83 7D FC 00 0F 82 D1 00 00 00 83 7D FC 0A 0F 87 C7 00 00 00 8D 4D F4 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 84 A1 00 00 00 8B 55 FC 83 E2 FE 89 55 F0 83 7D F0 0C 0F 87 8E 00 00 00 8B 4D F0 33 C0 8A 81 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 6A 01 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D F4 E8 ?? ?? ?? ?? EB 67 6A 02 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D F4 E8 ?? ?? ?? ?? EB 52 6A 04 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D F4 E8 ?? ?? ?? ?? EB 3D 6A 03 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D F4 E8 ?? ?? ?? ?? EB 28 6A 05 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D F4 E8 ?? ?? ?? ?? EB 13 6A 06 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D F4 E8 ?? ?? ?? ?? 8D 55 F4 52 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 EB 1C 6A 01 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 EB 0D 6A 02 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 06 01 06 02 06 03 06 04 06 06 06 05 }
	condition:
		$1
}

rule file_69_22_0 {
	meta:
		name = "?getReturnType@UnDecorator@@CA?AVDName@@PAV2@@Z"
		size = 92
		refs = "0007 ?gName@UnDecorator@@0PBDB 002a ??0DName@@QAE@PAV0@@Z 0033 ??0DName@@QAE@ABV0@@Z 0045 ?getDataType@UnDecorator@@CA?AVDName@@PAV2@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 A1 ?? ?? ?? ?? 0F BE 08 83 F9 40 75 29 8B 15 ?? ?? ?? ?? 83 C2 01 89 15 ?? ?? ?? ?? 8B 45 0C 50 8D 4D F8 E8 ?? ?? ?? ?? 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 EB 1C 8B 4D 0C 51 8D 55 F0 52 E8 ?? ?? ?? ?? 83 C4 08 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_23_0 {
	meta:
		name = "?getDataType@UnDecorator@@CA?AVDName@@PAV2@@Z"
		size = 289
		refs = "000e ??0DName@@QAE@PAV0@@Z 0014 ?gName@UnDecorator@@0PBDB 0043 ??H@YA?AVDName@@W4DNameStatus@@ABV0@@Z 004f ??0DName@@QAE@ABV0@@Z 006e ?isEmpty@DName@@QBEHXZ 0077 ??_C@_04BMNE@void?$AA@ 007f ??0DName@@QAE@PBD@Z 0090 ??_C@_05JDPM@void?5?$AA@ 0099 ??H@YA?AVDName@@PBDABV0@@Z 00c3 ??0DName@@QAE@XZ 00d3 ?getDataIndirectType@UnDecorator@@CA?AVDName@@ABV2@D0H@Z 00df ??4DName@@QAEAAV0@ABV0@@Z 00ec ?getPrimaryDataType@UnDecorator@@CA?AVDName@@ABV2@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 3C 8B 45 0C 50 8D 4D F8 E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 8A 11 88 55 C4 80 7D C4 00 74 15 80 7D C4 3F 0F 84 81 00 00 00 80 7D C4 58 74 28 E9 C9 00 00 00 8D 45 F8 50 6A 02 8D 4D F0 51 E8 ?? ?? ?? ?? 83 C4 0C 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 C2 00 00 00 8B 15 ?? ?? ?? ?? 83 C2 01 89 15 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? 85 C0 74 15 68 ?? ?? ?? ?? 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 92 00 00 00 8D 45 F8 50 68 ?? ?? ?? ?? 8D 4D E8 51 E8 ?? ?? ?? ?? 83 C4 0C 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 EB 6F 8B 15 ?? ?? ?? ?? 83 C2 01 89 15 ?? ?? ?? ?? 6A 00 8D 4D E0 E8 ?? ?? ?? ?? 50 6A 00 8D 45 F8 50 8D 4D D8 51 E8 ?? ?? ?? ?? 83 C4 14 50 8D 4D F8 E8 ?? ?? ?? ?? 8D 55 F8 52 8D 45 D0 50 E8 ?? ?? ?? ?? 83 C4 08 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 EB 1C 8D 55 F8 52 8D 45 C8 50 E8 ?? ?? ?? ?? 83 C4 08 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_24_0 {
	meta:
		name = "?getPrimaryDataType@UnDecorator@@CA?AVDName@@ABV2@@Z"
		size = 745
		refs = "000a ??0DName@@QAE@XZ 000f ?gName@UnDecorator@@0PBDB 002a $L3730 0031 $L3731 0040 ??H@YA?AVDName@@W4DNameStatus@@ABV0@@Z 004c ??0DName@@QAE@ABV0@@Z 0059 ??_C@_08CACH@volatile?$AA@ 0061 ??4DName@@QAEAAV0@PBD@Z 0069 ?isEmpty@DName@@QBEHXZ 0077 ??YDName@@QAEAAV0@D@Z 009a ?setPtrRef@DName@@QAEAAV1@XZ 00a8 ?getReferenceType@UnDecorator@@CA?AVDName@@ABV2@0@Z 0105 ??0DName@@QAE@W4DNameStatus@@@Z 013d $L3732 0144 $L3733 015e ?getFunctionIndirectType@UnDecorator@@CA?AVDName@@ABV2@@Z 018e ?getPtrRefDataType@UnDecorator@@CA?AVDName@@ABV2@H@Z 01c9 ?getDataIndirectType@UnDecorator@@CA?AVDName@@ABV2@D0H@Z 01d6 ?getBasicDataType@UnDecorator@@CA?AVDName@@ABV2@@Z 023a $L1895 023e $L1903 0242 $L1899 0246 $L1897 024a $L1909 0291 $L1920 0295 $L1912 0299 $L1914 029d $L1916 02a1 $L1922"
	strings:
		$1 = { 55 8B EC 83 EC 68 8D 4D F8 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 0F BE 08 89 4D 9C 83 7D 9C 42 0F 87 F7 01 00 00 8B 45 9C 33 D2 8A 90 ?? ?? ?? ?? FF 24 95 ?? ?? ?? ?? 8B 4D 0C 51 6A 02 8D 55 E8 52 E8 ?? ?? ?? ?? 83 C4 0C 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 DE 01 00 00 68 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? 8B 4D 0C E8 ?? ?? ?? ?? 85 C0 75 0A 6A 20 8D 4D F8 E8 ?? ?? ?? ?? 8B 45 0C 50 8D 4D F0 E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 83 C1 01 89 0D ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? 50 8D 55 F8 52 8D 45 E0 50 E8 ?? ?? ?? ?? 83 C4 0C 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 76 01 00 00 8B 0D ?? ?? ?? ?? 0F BE 51 01 83 FA 24 74 42 A1 ?? ?? ?? ?? 0F BE 48 01 85 C9 75 23 8B 55 0C 52 6A 02 8D 45 D8 50 E8 ?? ?? ?? ?? 83 C4 0C 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 37 01 00 00 6A 01 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 25 01 00 00 8B 0D ?? ?? ?? ?? 83 C1 02 89 0D ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 0F BE 02 89 45 98 83 7D 98 43 0F 87 D5 00 00 00 8B 55 98 33 C9 8A 8A ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? A1 ?? ?? ?? ?? 83 C0 01 A3 ?? ?? ?? ?? 8B 4D 0C 51 8D 55 D0 52 E8 ?? ?? ?? ?? 83 C4 08 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 C0 00 00 00 A1 ?? ?? ?? ?? 83 C0 01 A3 ?? ?? ?? ?? 6A 01 8B 4D 0C 51 8D 55 C8 52 E8 ?? ?? ?? ?? 83 C4 0C 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 90 00 00 00 A1 ?? ?? ?? ?? 83 C0 01 A3 ?? ?? ?? ?? 6A 00 8D 4D C0 E8 ?? ?? ?? ?? 50 6A 00 8B 4D 0C 51 8D 55 B8 52 E8 ?? ?? ?? ?? 83 C4 14 50 8D 45 B0 50 E8 ?? ?? ?? ?? 83 C4 08 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 EB 4B 8B 4D 0C 51 6A 02 8D 55 A8 52 E8 ?? ?? ?? ?? 83 C4 0C 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 EB 2B 6A 01 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 EB 1C 8B 45 0C 50 8D 4D A0 51 E8 ?? ?? ?? ?? 83 C4 08 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 01 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 02 03 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 01 02 03 }
	condition:
		$1
}

rule file_69_25_0 {
	meta:
		name = "?getArgumentTypes@UnDecorator@@CA?AVDName@@XZ"
		size = 297
		refs = "0007 ?gName@UnDecorator@@0PBDB 002e ??_C@_03NAME@?4?4?4?$AA@ 0036 ??0DName@@QAE@PBD@Z 0050 ??_C@_04BMNE@void?$AA@ 0069 ?getArgumentList@UnDecorator@@CA?AVDName@@XZ 0075 ??0DName@@QAE@ABV0@@Z 007d ?status@DName@@QBE?AW4DNameStatus@@XZ 00c9 ??_C@_04MFFO@?0?4?4?4?$AA@ 00d5 ??HDName@@QBE?AV0@PBD@Z 010d ??0DName@@QAE@W4DNameStatus@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 20 A1 ?? ?? ?? ?? 8A 08 88 4D E4 80 7D E4 58 74 2C 80 7D E4 5A 74 02 EB 46 8B 15 ?? ?? ?? ?? 83 C2 01 89 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 E3 00 00 00 A1 ?? ?? ?? ?? 83 C0 01 A3 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 C1 00 00 00 8D 4D F0 51 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D F8 E8 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? 85 C0 0F 85 8D 00 00 00 8B 15 ?? ?? ?? ?? 8A 02 88 45 E0 80 7D E0 00 74 0E 80 7D E0 40 74 47 80 7D E0 5A 74 13 EB 5F 8D 4D F8 51 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 EB 6C 8B 15 ?? ?? ?? ?? 83 C2 01 89 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 E8 50 8D 4D F8 E8 ?? ?? ?? ?? 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 EB 3E 8B 0D ?? ?? ?? ?? 83 C1 01 89 0D ?? ?? ?? ?? 8D 55 F8 52 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 EB 1E 6A 01 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 EB 0F 8D 45 F8 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_26_0 {
	meta:
		name = "?getArgumentList@UnDecorator@@CA?AVDName@@XZ"
		size = 313
		refs = "0011 ??0DName@@QAE@XZ 0019 ?status@DName@@QBE?AW4DNameStatus@@XZ 0026 ?gName@UnDecorator@@0PBDB 005d ??YDName@@QAEAAV0@D@Z 00a1 ?pArgList@UnDecorator@@0PAVReplicator@@A 00a6 ??AReplicator@@QBEABVDName@@H@Z 00af ??YDName@@QAEAAV0@ABV0@@Z 00cc ?getPrimaryDataType@UnDecorator@@CA?AVDName@@ABV2@@Z 00d8 ??0DName@@QAE@ABV0@@Z 00f0 ?isFull@Replicator@@QBEHXZ 0103 ??YReplicator@@QAEAAV0@ABVDName@@@Z 011b ??YDName@@QAEAAV0@W4DNameStatus@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 2C C7 45 FC 01 00 00 00 8D 4D F4 E8 ?? ?? ?? ?? 8D 4D F4 E8 ?? ?? ?? ?? 85 C0 0F 85 01 01 00 00 A1 ?? ?? ?? ?? 0F BE 08 83 F9 40 0F 84 F0 00 00 00 8B 15 ?? ?? ?? ?? 0F BE 02 83 F8 5A 0F 84 DE 00 00 00 83 7D FC 00 74 09 C7 45 FC 00 00 00 00 EB 0A 6A 2C 8D 4D F4 E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 0F BE 11 85 D2 0F 84 A3 00 00 00 A1 ?? ?? ?? ?? 0F BE 08 83 E9 30 89 4D F0 83 7D F0 00 7C 2F 83 7D F0 09 7F 29 8B 15 ?? ?? ?? ?? 83 C2 01 89 15 ?? ?? ?? ?? 8B 45 F0 50 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 8D 4D F4 E8 ?? ?? ?? ?? EB 5E 8B 0D ?? ?? ?? ?? 89 4D E4 8D 4D DC E8 ?? ?? ?? ?? 50 8D 55 D4 52 E8 ?? ?? ?? ?? 83 C4 08 50 8D 4D E8 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 2B 45 E4 83 F8 01 7E 1E 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 0F 8D 4D E8 51 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 55 E8 52 8D 4D F4 E8 ?? ?? ?? ?? EB 0C 6A 02 8D 4D F4 E8 ?? ?? ?? ?? EB 05 E9 EF FE FF FF 8D 45 F4 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_27_0 {
	meta:
		name = "?getThrowTypes@UnDecorator@@CA?AVDName@@XZ"
		size = 181
		refs = "0007 ?gName@UnDecorator@@0PBDB 0033 ??0DName@@QAE@XZ 003c ??0DName@@QAE@ABV0@@Z 0050 ?getArgumentTypes@UnDecorator@@CA?AVDName@@XZ 0059 ??_C@_07HEFF@?5throw?$CI?$AA@ 0062 ??H@YA?AVDName@@PBDABV0@@Z 006c ??HDName@@QBE?AV0@D@Z 0093 ??0DName@@QAE@PBD@Z 009a ??HDName@@QBE?AV0@W4DNameStatus@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 38 A1 ?? ?? ?? ?? 0F BE 08 85 C9 74 6C 8B 15 ?? ?? ?? ?? 0F BE 02 83 F8 5A 75 25 8B 0D ?? ?? ?? ?? 83 C1 01 89 0D ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 EB 6C 6A 29 8D 55 E0 52 8D 45 F0 50 E8 ?? ?? ?? ?? 83 C4 04 50 68 ?? ?? ?? ?? 8D 4D E8 51 E8 ?? ?? ?? ?? 83 C4 0C 8B C8 E8 ?? ?? ?? ?? 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 EB 33 6A 29 8D 55 C8 52 6A 02 8D 45 D0 50 68 ?? ?? ?? ?? 8D 4D D8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_28_0 {
	meta:
		name = "?getBasicDataType@UnDecorator@@CA?AVDName@@ABV2@@Z"
		size = 1135
		refs = "0007 ?gName@UnDecorator@@0PBDB 003b ??0DName@@QAE@XZ 0065 $L3756 006c $L3757 0071 ??_C@_04KENI@char?$AA@ 0079 ??4DName@@QAEAAV0@PBD@Z 0083 ??_C@_05BODP@short?$AA@ 0095 ??_C@_03EMIM@int?$AA@ 00a7 ??_C@_04LHCN@long?$AA@ 00b9 ??_C@_05PIME@float?$AA@ 00cb ??_C@_05FFFH@long?5?$AA@ 00d8 ??_C@_06PJOP@double?$AA@ 00e0 ??YDName@@QAEAAV0@PBD@Z 013d $L3758 0144 $L3759 0149 ??_C@_04PPPK@bool?$AA@ 0158 ??_C@_06LHNP@__int8?$AA@ 0167 ??_C@_07CCKL@__int16?$AA@ 0176 ??_C@_07KFKC@__int32?$AA@ 0185 ??_C@_07BGNA@__int64?$AA@ 0194 ??_C@_08NLKA@__int128?$AA@ 01a3 ??_C@_07EAPL@wchar_t?$AA@ 01b2 ??_C@_07CNPM@UNKNOWN?$AA@ 01d2 ?getECSUDataType@UnDecorator@@CA?AVDName@@XZ 01de ??4DName@@QAEAAV0@ABV0@@Z 01e6 ?isEmpty@DName@@QBEHXZ 01f6 ??0DName@@QAE@ABV0@@Z 0231 $L3760 0238 $L3761 0241 ??_C@_09OKF@unsigned?5?$AA@ 024a ??H@YA?AVDName@@PBDABV0@@Z 0261 ??_C@_07MFKF@signed?5?$AA@ 029d $L3762 02d6 ??H@YA?AVDName@@DABV0@@Z 02e2 ??YDName@@QAEAAV0@ABV0@@Z 0325 ??_C@_05KCGI@const?$AA@ 033c ??_C@_09GJCC@?5volatile?$AA@ 0355 ??_C@_08CACH@volatile?$AA@ 036e ?getPointerType@UnDecorator@@CA?AVDName@@ABV2@0@Z 038e ??H@YA?AVDName@@W4DNameStatus@@ABV0@@Z 03a5 $L2001 03a9 $L2003 03ad $L2005 03b1 $L2007 03b5 $L2009 03b9 $L2012 03bd $L2011 03c1 $L2014 03c5 $L2015 03c9 $L2036 03ea $L2022 03ee $L2024 03f2 $L2026 03f6 $L2028 03fa $L2030 03fe $L2020 0402 $L2032 0406 $L2034 041e $L2046 0422 $L2044 0426 $L2049 042a $L2041 044b $L2054 044f $L2051"
	strings:
		$1 = { 55 8B EC 83 EC 70 A1 ?? ?? ?? ?? 0F BE 08 85 C9 0F 84 6D 03 00 00 8B 15 ?? ?? ?? ?? 8A 02 88 45 EC 8B 0D ?? ?? ?? ?? 83 C1 01 89 0D ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D F0 E8 ?? ?? ?? ?? 8B 55 EC 81 E2 FF 00 00 00 89 55 A0 8B 45 A0 83 E8 43 89 45 A0 83 7D A0 1C 0F 87 62 01 00 00 8B 55 A0 33 C9 8A 8A ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? E9 80 01 00 00 68 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? E9 6E 01 00 00 68 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? E9 5C 01 00 00 68 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? E9 4A 01 00 00 68 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? E9 38 01 00 00 68 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? E9 19 01 00 00 8B 45 EC 25 FF 00 00 00 83 E0 03 89 45 FC E9 06 01 00 00 8B 0D ?? ?? ?? ?? 8A 11 88 55 F8 8B 45 F8 25 FF 00 00 00 89 45 9C 8B 0D ?? ?? ?? ?? 83 C1 01 89 0D ?? ?? ?? ?? 8B 55 9C 89 55 98 8B 45 98 83 E8 44 89 45 98 83 7D 98 13 77 7B 8B 55 98 33 C9 8A 8A ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? EB 67 68 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? EB 58 68 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? EB 49 68 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? EB 3A 68 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? EB 2B 68 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? EB 1C 68 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? EB 0D 68 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? EB 42 A1 ?? ?? ?? ?? 83 E8 01 A3 ?? ?? ?? ?? 8D 4D D4 51 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D F0 E8 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? 85 C0 74 14 8D 55 F0 52 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 9F 01 00 00 83 7D FC FF 0F 85 EE 00 00 00 8B 45 EC 25 FF 00 00 00 89 45 94 8B 4D 94 83 E9 43 89 4D 94 83 7D 94 1C 0F 87 95 00 00 00 8B 45 94 33 D2 8A 90 ?? ?? ?? ?? FF 24 95 ?? ?? ?? ?? 8D 4D F0 51 68 ?? ?? ?? ?? 8D 55 CC 52 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D F0 E8 ?? ?? ?? ?? EB 63 8D 45 F0 50 68 ?? ?? ?? ?? 8D 4D C4 51 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D F0 E8 ?? ?? ?? ?? EB 43 8B 55 F8 81 E2 FF 00 00 00 89 55 90 8B 45 90 83 E8 45 89 45 90 83 7D 90 08 77 28 8B 4D 90 FF 24 8D ?? ?? ?? ?? 8D 55 F0 52 68 ?? ?? ?? ?? 8D 45 BC 50 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D F0 E8 ?? ?? ?? ?? 8B 4D 0C E8 ?? ?? ?? ?? 85 C0 75 1B 8B 4D 0C 51 6A 20 8D 55 B4 52 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D F0 E8 ?? ?? ?? ?? 8D 45 F0 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 A7 00 00 00 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D 0C 51 8D 4D DC E8 ?? ?? ?? ?? 8B 4D 0C E8 ?? ?? ?? ?? 85 C0 74 47 8B 55 FC 83 E2 01 85 D2 74 26 68 ?? ?? ?? ?? 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 FC 83 E0 02 85 C0 74 0D 68 ?? ?? ?? ?? 8D 4D E4 E8 ?? ?? ?? ?? EB 17 8B 4D FC 83 E1 02 85 C9 74 0D 68 ?? ?? ?? ?? 8D 4D E4 E8 ?? ?? ?? ?? 8D 55 DC 52 8D 45 E4 50 8D 4D AC 51 E8 ?? ?? ?? ?? 83 C4 0C 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 EB 1E 8B 55 0C 52 6A 02 8D 45 A4 50 E8 ?? ?? ?? ?? 83 C4 0C 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 01 01 02 02 03 03 09 04 05 06 07 07 07 07 09 09 09 09 09 09 09 09 09 09 09 08 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 01 01 02 02 03 03 04 04 05 07 07 07 07 07 07 07 07 06 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 03 01 03 01 03 01 03 01 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 02 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_69_29_0 {
	meta:
		name = "?getECSUDataType@UnDecorator@@CA?AVDName@@XZ"
		size = 419
		refs = "0007 ?doEcsu@UnDecorator@@SAHXZ 0010 ?doNameOnly@UnDecorator@@SAHXZ 0032 ??0DName@@QAE@XZ 0038 ?gName@UnDecorator@@0PBDB 0066 $L3769 006d $L3770 0081 ??_C@_0P@DBCM@?$GAunknown?5ecsu?8?$AA@ 0089 ??0DName@@QAE@PBD@Z 0096 ??_C@_06HODG@union?5?$AA@ 009e ??4DName@@QAEAAV0@PBD@Z 00a5 ??_C@_07EFPK@struct?5?$AA@ 00b4 ??_C@_06FJFG@class?5?$AA@ 00cf ?getEnumType@UnDecorator@@CA?AVDName@@XZ 00d8 ??_C@_05OOP@enum?5?$AA@ 00e1 ??H@YA?AVDName@@PBDABV0@@Z 00ed ??4DName@@QAEAAV0@ABV0@@Z 0110 ?getECSUName@UnDecorator@@CA?AVDName@@XZ 011c ??YDName@@QAEAAV0@ABV0@@Z 0128 ??0DName@@QAE@ABV0@@Z 0133 $L2081 0137 $L2083 013b $L2085 013f $L2087 0143 $L2089 0147 $L2078"
	strings:
		$1 = { 55 8B EC 83 EC 38 E8 ?? ?? ?? ?? 85 C0 74 12 E8 ?? ?? ?? ?? 85 C0 75 09 C7 45 D0 01 00 00 00 EB 07 C7 45 D0 00 00 00 00 8B 45 D0 89 45 EC 8D 4D F8 E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 0F BE 11 89 55 CC A1 ?? ?? ?? ?? 83 C0 01 A3 ?? ?? ?? ?? 8B 4D CC 89 4D C8 83 7D C8 57 0F 87 92 00 00 00 8B 45 C8 33 D2 8A 90 ?? ?? ?? ?? FF 24 95 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 83 E9 01 89 0D ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 9A 00 00 00 68 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? EB 4D 68 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? EB 3E 68 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? EB 2F E8 ?? ?? ?? ?? 89 45 EC 8D 55 E4 52 E8 ?? ?? ?? ?? 83 C4 04 50 68 ?? ?? ?? ?? 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D F8 E8 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? 83 7D EC 00 74 0C 8D 4D F8 51 8D 4D F0 E8 ?? ?? ?? ?? 8D 55 D4 52 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D F0 E8 ?? ?? ?? ?? 8D 45 F0 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 01 02 03 04 }
	condition:
		$1
}

rule file_69_30_0 {
	meta:
		name = "?getECSUName@UnDecorator@@CA?AVDName@@XZ"
		size = 34
		refs = "000b ?getScopedName@UnDecorator@@CA?AVDName@@XZ 0017 ??0DName@@QAE@ABV0@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 8D 45 F8 50 E8 ?? ?? ?? ?? 83 C4 04 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_42_0 {
	meta:
		name = "?getCallIndex@UnDecorator@@CA?AVDName@@XZ"
		size = 34
		refs = "000b ?getDimension@UnDecorator@@CA?AVDName@@XZ 0017 ??0DName@@QAE@ABV0@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 8D 45 F8 50 E8 ?? ?? ?? ?? 83 C4 04 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_41_0 {
	meta:
		name = "?getDisplacement@UnDecorator@@CA?AVDName@@XZ"
		size = 34
		refs = "000b ?getDimension@UnDecorator@@CA?AVDName@@XZ 0017 ??0DName@@QAE@ABV0@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 8D 45 F8 50 E8 ?? ?? ?? ?? 83 C4 04 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_43_0 {
	meta:
		name = "?getGuardNumber@UnDecorator@@CA?AVDName@@XZ"
		size = 34
		refs = "000b ?getDimension@UnDecorator@@CA?AVDName@@XZ 0017 ??0DName@@QAE@ABV0@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 8D 45 F8 50 E8 ?? ?? ?? ?? 83 C4 04 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_47_0 {
	meta:
		name = "?getStorageConvention@UnDecorator@@CA?AVDName@@XZ"
		size = 34
		refs = "000b ?getDataIndirectType@UnDecorator@@CA?AVDName@@XZ 0017 ??0DName@@QAE@ABV0@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 8D 45 F8 50 E8 ?? ?? ?? ?? 83 C4 04 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_31_0 {
	meta:
		name = "?getEnumType@UnDecorator@@CA?AVDName@@XZ"
		size = 325
		refs = "000a ??0DName@@QAE@XZ 000f ?gName@UnDecorator@@0PBDB 003f $L3775 0044 ??_C@_05MGEE@char?5?$AA@ 004c ??4DName@@QAEAAV0@PBD@Z 0053 ??_C@_06EFPO@short?5?$AA@ 0064 ??_C@_04FHKM@int?5?$AA@ 0073 ??_C@_05FFFH@long?5?$AA@ 0087 ??0DName@@QAE@W4DNameStatus@@@Z 00c5 $L3776 00ce ??_C@_09OKF@unsigned?5?$AA@ 00d7 ??H@YA?AVDName@@PBDABV0@@Z 00e3 ??4DName@@QAEAAV0@ABV0@@Z 00ef ??0DName@@QAE@ABV0@@Z 0109 $L1807 0111 $L1809 0119 $L1811 011d $L1812 0121 $L1814 0129 $L1821 012d $L1818"
	strings:
		$1 = { 55 8B EC 83 EC 1C 8D 4D F8 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 0F BE 08 85 C9 0F 84 DA 00 00 00 8B 15 ?? ?? ?? ?? 0F BE 02 89 45 EC 8B 4D EC 83 E9 30 89 4D EC 83 7D EC 07 77 48 8B 55 EC FF 24 95 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? EB 3E 68 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? EB 2F EB 2D 68 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? EB 1E 68 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? EB 0F 6A 01 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 EB 75 A1 ?? ?? ?? ?? 0F BE 08 89 4D E8 8B 15 ?? ?? ?? ?? 83 C2 01 89 15 ?? ?? ?? ?? 8B 45 E8 89 45 E4 8B 4D E4 83 E9 31 89 4D E4 83 7D E4 06 77 28 8B 55 E4 FF 24 95 ?? ?? ?? ?? 8D 45 F8 50 68 ?? ?? ?? ?? 8D 4D F0 51 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D F8 E8 ?? ?? ?? ?? 8D 55 F8 52 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 EB 0D 6A 02 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_69_32_0 {
	meta:
		name = "?getFunctionIndirectType@UnDecorator@@CA?AVDName@@ABV2@@Z"
		size = 1132
		refs = "000a ?gName@UnDecorator@@0PBDB 0020 ??H@YA?AVDName@@W4DNameStatus@@ABV0@@Z 002c ??0DName@@QAE@ABV0@@Z 0067 ??0DName@@QAE@W4DNameStatus@@@Z 0128 ??0DName@@QAE@XZ 014b ??_C@_02NNPM@?3?3?$AA@ 0154 ??H@YA?AVDName@@PBDABV0@@Z 0160 ??4DName@@QAEAAV0@ABV0@@Z 017d ?getScope@UnDecorator@@CA?AVDName@@XZ 018c ??H@YA?AVDName@@DABV0@@Z 0196 ??HDName@@QBE?AV0@ABV0@@Z 0222 ?doThisTypes@UnDecorator@@SAHXZ 022f ?getThisType@UnDecorator@@CA?AVDName@@XZ 0252 ??_5DName@@QAEAAV0@ABV0@@Z 0261 ?doMSKeywords@UnDecorator@@SAHXZ 0279 ?getBasedType@UnDecorator@@CA?AVDName@@XZ 02d5 ?getCallingConvention@UnDecorator@@CA?AVDName@@XZ 030a ?isEmpty@DName@@QBEHXZ 0333 ??HDName@@QBE?AV0@D@Z 0343 _heap 034a ??2@YAPAXIAAVHeapManager@@H@Z 0392 ?getReturnType@UnDecorator@@CA?AVDName@@PAV2@@Z 03b3 ?getArgumentTypes@UnDecorator@@CA?AVDName@@XZ 03d8 ??YDName@@QAEAAV0@ABV0@@Z 03fc ?doThrowTypes@UnDecorator@@SAHXZ 040c ?getThrowTypes@UnDecorator@@CA?AVDName@@XZ"
	strings:
		$1 = { 55 8B EC 81 EC F0 00 00 00 A1 ?? ?? ?? ?? 0F BE 08 85 C9 75 23 8B 55 0C 52 6A 02 8D 45 D8 50 E8 ?? ?? ?? ?? 83 C4 0C 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 30 04 00 00 8B 0D ?? ?? ?? ?? 0F BE 11 83 FA 36 7C 0D A1 ?? ?? ?? ?? 0F BE 08 83 F9 39 7E 20 8B 15 ?? ?? ?? ?? 0F BE 02 83 F8 5F 74 12 6A 01 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 F5 03 00 00 8B 0D ?? ?? ?? ?? 0F BE 11 83 EA 36 89 55 E8 A1 ?? ?? ?? ?? 83 C0 01 A3 ?? ?? ?? ?? 83 7D E8 29 75 64 8B 0D ?? ?? ?? ?? 0F BE 11 85 D2 74 32 A1 ?? ?? ?? ?? 0F BE 08 83 E9 3D 89 4D E8 8B 15 ?? ?? ?? ?? 83 C2 01 89 15 ?? ?? ?? ?? 83 7D E8 04 7C 06 83 7D E8 07 7E 07 C7 45 E8 FF FF FF FF EB 23 8B 45 0C 50 6A 02 8D 4D D0 51 E8 ?? ?? ?? ?? 83 C4 0C 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 71 03 00 00 EB 13 83 7D E8 00 7C 06 83 7D E8 03 7E 07 C7 45 E8 FF FF FF FF 83 7D E8 FF 75 12 6A 01 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 44 03 00 00 8D 4D F8 E8 ?? ?? ?? ?? 8B 55 0C 52 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 E8 83 E0 02 85 C0 0F 84 10 01 00 00 8D 4D F0 51 68 ?? ?? ?? ?? 8D 55 C8 52 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D F0 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 0F BE 08 85 C9 74 35 8D 55 F0 52 8D 45 B0 50 8D 4D C0 51 E8 ?? ?? ?? ?? 83 C4 04 50 6A 20 8D 55 B8 52 E8 ?? ?? ?? ?? 83 C4 0C 8B C8 E8 ?? ?? ?? ?? 50 8D 4D F0 E8 ?? ?? ?? ?? EB 1B 8D 45 F0 50 6A 02 8D 4D A8 51 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D F0 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 0F BE 02 85 C0 74 31 8B 0D ?? ?? ?? ?? 0F BE 11 83 FA 40 75 0F A1 ?? ?? ?? ?? 83 C0 01 A3 ?? ?? ?? ?? EB 12 6A 01 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 6C 02 00 00 EB 23 8D 4D F0 51 6A 02 8D 55 A0 52 E8 ?? ?? ?? ?? 83 C4 0C 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 47 02 00 00 E8 ?? ?? ?? ?? 85 C0 74 17 8D 45 98 50 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D F8 E8 ?? ?? ?? ?? EB 15 8D 4D 90 51 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D F8 E8 ?? ?? ?? ?? 8B 55 E8 83 E2 04 85 D2 74 59 E8 ?? ?? ?? ?? 85 C0 74 38 8D 45 F0 50 8D 8D 78 FF FF FF 51 8D 55 88 52 E8 ?? ?? ?? ?? 83 C4 04 50 6A 20 8D 45 80 50 E8 ?? ?? ?? ?? 83 C4 0C 8B C8 E8 ?? ?? ?? ?? 50 8D 4D F0 E8 ?? ?? ?? ?? EB 18 8D 8D 70 FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D F0 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 2C 8D 55 F0 52 8D 85 60 FF FF FF 50 8D 8D 68 FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 8B C8 E8 ?? ?? ?? ?? 50 8D 4D F0 E8 ?? ?? ?? ?? EB 18 8D 95 58 FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D F0 E8 ?? ?? ?? ?? 8B 4D 0C E8 ?? ?? ?? ?? 85 C0 75 2E 6A 29 8D 85 48 FF FF FF 50 8D 4D F0 51 6A 28 8D 95 50 FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 8B C8 E8 ?? ?? ?? ?? 50 8D 4D F0 E8 ?? ?? ?? ?? 6A 00 68 ?? ?? ?? ?? 6A 08 E8 ?? ?? ?? ?? 83 C4 0C 89 85 44 FF FF FF 83 BD 44 FF FF FF 00 74 13 8B 8D 44 FF FF FF E8 ?? ?? ?? ?? 89 85 10 FF FF FF EB 0A C7 85 10 FF FF FF 00 00 00 00 8B 85 10 FF FF FF 89 45 EC 8B 4D EC 51 8D 95 3C FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 50 8D 4D E0 E8 ?? ?? ?? ?? 6A 29 8D 85 24 FF FF FF 50 8D 8D 34 FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 50 6A 28 8D 95 2C FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 8B C8 E8 ?? ?? ?? ?? 50 8D 4D F0 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 16 8B 45 E8 83 E0 02 85 C0 74 0C 8D 4D F8 51 8D 4D F0 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 1A 8D 95 1C FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D F0 E8 ?? ?? ?? ?? EB 18 8D 85 14 FF FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D F0 E8 ?? ?? ?? ?? 83 7D EC 00 74 0E 8D 4D F0 51 8B 4D EC E8 ?? ?? ?? ?? EB 0F 6A 03 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 EB 0F 8D 55 E0 52 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_33_0 {
	meta:
		name = "?getPtrRefType@UnDecorator@@CA?AVDName@@ABV2@0H@Z"
		size = 390
		refs = "0007 ?gName@UnDecorator@@0PBDB 0051 ??0DName@@QAE@D@Z 0059 ?isEmpty@DName@@QBEHXZ 0071 ?isPtrRef@DName@@QBEHXZ 0081 ??YDName@@QAEAAV0@ABV0@@Z 00a6 ?getFunctionIndirectType@UnDecorator@@CA?AVDName@@ABV2@@Z 00b2 ??0DName@@QAE@ABV0@@Z 00db ?getDataIndirectType@UnDecorator@@CA?AVDName@@ABV2@D0H@Z 00f8 ?getPtrRefDataType@UnDecorator@@CA?AVDName@@ABV2@H@Z 0113 ??0DName@@QAE@W4DNameStatus@@@Z 0129 ??YDName@@QAEAAV0@D@Z"
	strings:
		$1 = { 55 8B EC 83 EC 30 A1 ?? ?? ?? ?? 0F BE 08 85 C9 0F 84 F7 00 00 00 8B 15 ?? ?? ?? ?? 0F BE 02 83 F8 36 7C 0E 8B 0D ?? ?? ?? ?? 0F BE 11 83 FA 39 7E 0D A1 ?? ?? ?? ?? 0F BE 08 83 F9 5F 75 7F 8B 55 14 F7 DA 1A D2 80 E2 04 80 C2 26 52 8D 4D F8 E8 ?? ?? ?? ?? 8B 4D 0C E8 ?? ?? ?? ?? 85 C0 75 24 8B 4D 10 E8 ?? ?? ?? ?? 85 C0 75 0C 8B 4D 10 E8 ?? ?? ?? ?? 85 C0 75 0C 8B 45 0C 50 8D 4D F8 E8 ?? ?? ?? ?? 8B 4D 10 E8 ?? ?? ?? ?? 85 C0 75 0C 8B 4D 10 51 8D 4D F8 E8 ?? ?? ?? ?? 8D 55 F8 52 8D 45 E0 50 E8 ?? ?? ?? ?? 83 C4 08 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 C4 00 00 00 6A 00 8B 4D 0C 51 8B 55 14 F7 DA 1A D2 80 E2 04 80 C2 26 52 8B 45 10 50 8D 4D D8 51 E8 ?? ?? ?? ?? 83 C4 14 50 8D 4D F0 E8 ?? ?? ?? ?? 8B 55 14 52 8D 45 F0 50 8D 4D D0 51 E8 ?? ?? ?? ?? 83 C4 0C 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 EB 75 6A 02 8D 4D E8 E8 ?? ?? ?? ?? 8B 55 14 F7 DA 1A D2 80 E2 04 80 C2 26 52 8D 4D E8 E8 ?? ?? ?? ?? 8B 4D 0C E8 ?? ?? ?? ?? 85 C0 75 0C 8B 45 0C 50 8D 4D E8 E8 ?? ?? ?? ?? 8B 4D 10 E8 ?? ?? ?? ?? 85 C0 75 22 8B 4D 0C E8 ?? ?? ?? ?? 85 C0 75 0A 6A 20 8D 4D E8 E8 ?? ?? ?? ?? 8B 4D 10 51 8D 4D E8 E8 ?? ?? ?? ?? 8D 55 E8 52 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_34_0 {
	meta:
		name = "?getDataIndirectType@UnDecorator@@CA?AVDName@@ABV2@D0H@Z"
		size = 1443
		refs = "000a ?gName@UnDecorator@@0PBDB 0043 ??0DName@@QAE@XZ 0048 ?doMSKeywords@UnDecorator@@SAHXZ 0086 ?isEmpty@DName@@QBEHXZ 0091 ?UScore@UnDecorator@@SAPBDW4Tokens@@@Z 00a7 ??HDName@@QBE?AV0@D@Z 00ae ??HDName@@QBE?AV0@PBD@Z 00b7 ??4DName@@QAEAAV0@ABV0@@Z 00cc ??4DName@@QAEAAV0@PBD@Z 01c7 ??0DName@@QAE@D@Z 01f0 ??HDName@@QBE?AV0@ABV0@@Z 0217 ??0DName@@QAE@W4DNameStatus@@@Z 0230 ??_C@_02NNPM@?3?3?$AA@ 0239 ??H@YA?AVDName@@PBDABV0@@Z 0262 ?getScope@UnDecorator@@CA?AVDName@@XZ 0286 ??H@YA?AVDName@@W4DNameStatus@@ABV0@@Z 02b6 ??_5DName@@QAEAAV0@ABV0@@Z 02cd ??YDName@@QAEAAV0@W4DNameStatus@@@Z 0346 ?getBasedType@UnDecorator@@CA?AVDName@@XZ 0391 ??_C@_09DFMA@volatile?5?$AA@ 03bc ??_C@_06IEC@const?5?$AA@ 03f2 ?isPtrRef@DName@@QBEHXZ 0414 ??H@YA?AVDName@@DABV0@@Z 0420 ??YDName@@QAEAAV0@ABV0@@Z 0496 ?setPtrRef@DName@@QAEAAV1@XZ 04a2 ??0DName@@QAE@ABV0@@Z"
	strings:
		$1 = { 55 8B EC 81 EC F0 00 00 00 A1 ?? ?? ?? ?? 0F BE 08 85 C9 0F 84 A7 04 00 00 8B 15 ?? ?? ?? ?? 0F BE 02 8B 0D ?? ?? ?? ?? 0F BE 11 33 C9 83 FA 41 0F 9C C1 49 83 E1 2B 83 C1 16 2B C1 89 45 F4 8D 4D F8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 84 4A 01 00 00 C7 45 F0 01 00 00 00 8B 55 F4 83 E2 0C 89 95 14 FF FF FF 83 BD 14 FF FF FF 04 74 12 83 BD 14 FF FF FF 08 0F 84 8C 00 00 00 E9 0B 01 00 00 8D 4D F8 E8 ?? ?? ?? ?? 85 C0 75 2F 6A 07 E8 ?? ?? ?? ?? 83 C4 04 50 8D 45 D8 50 6A 20 8D 4D E0 51 8D 4D F8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 50 8D 4D F8 E8 ?? ?? ?? ?? EB 13 6A 07 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D F8 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 83 C2 01 89 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? 0F BE 08 8B 15 ?? ?? ?? ?? 0F BE 02 33 D2 83 F8 41 0F 9C C2 4A 83 E2 2B 83 C2 16 2B CA 89 4D F4 E9 8B 00 00 00 8D 4D F8 E8 ?? ?? ?? ?? 85 C0 75 2F 6A 08 E8 ?? ?? ?? ?? 83 C4 04 50 8D 45 C8 50 6A 20 8D 4D D0 51 8D 4D F8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 50 8D 4D F8 E8 ?? ?? ?? ?? EB 13 6A 08 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D F8 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 83 C2 01 89 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? 0F BE 08 8B 15 ?? ?? ?? ?? 0F BE 02 33 D2 83 F8 41 0F 9C C2 4A 83 E2 2B 83 C2 16 2B CA 89 4D F4 EB 07 C7 45 F0 00 00 00 00 83 7D F0 00 0F 85 BD FE FF FF A1 ?? ?? ?? ?? 83 C0 01 A3 ?? ?? ?? ?? 83 7D F4 00 0F 82 F9 02 00 00 83 7D F4 1F 0F 87 EF 02 00 00 8A 4D 10 51 8D 4D E8 E8 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? 85 C0 75 26 8D 55 F8 52 8D 45 B8 50 6A 20 8D 4D C0 51 8D 4D E8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 50 8D 4D E8 E8 ?? ?? ?? ?? 8B 55 F4 83 E2 10 85 D2 0F 84 F6 00 00 00 83 7D 18 00 74 12 6A 01 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 7C 03 00 00 0F BE 45 10 85 C0 74 6D 8D 4D E8 51 68 ?? ?? ?? ?? 8D 55 B0 52 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D E8 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 0F BE 08 85 C9 74 26 8D 55 E8 52 8D 45 A0 50 8D 4D A8 51 E8 ?? ?? ?? ?? 83 C4 04 8B C8 E8 ?? ?? ?? ?? 50 8D 4D E8 E8 ?? ?? ?? ?? EB 1B 8D 55 E8 52 6A 02 8D 45 98 50 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D E8 E8 ?? ?? ?? ?? EB 22 8B 0D ?? ?? ?? ?? 0F BE 11 85 D2 74 15 8D 45 90 50 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D E8 E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 0F BE 11 85 D2 75 0C 6A 02 8D 4D E8 E8 ?? ?? ?? ?? EB 2E A1 ?? ?? ?? ?? 0F BE 08 8B 15 ?? ?? ?? ?? 83 C2 01 89 15 ?? ?? ?? ?? 83 F9 40 74 12 6A 01 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 9E 02 00 00 E8 ?? ?? ?? ?? 85 C0 74 55 8B 45 F4 83 E0 0C 89 85 10 FF FF FF 83 BD 10 FF FF FF 0C 74 02 EB 3C 83 7D 18 00 74 12 6A 01 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 66 02 00 00 8D 4D E8 51 8D 55 80 52 8D 45 88 50 E8 ?? ?? ?? ?? 83 C4 04 8B C8 E8 ?? ?? ?? ?? 50 8D 4D E8 E8 ?? ?? ?? ?? EB 23 8B 4D F4 83 E1 0C 83 F9 0C 75 18 8D 95 78 FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 F4 83 E0 02 85 C0 74 21 8D 4D E8 51 68 ?? ?? ?? ?? 8D 95 70 FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 F4 83 E0 01 85 C0 74 21 8D 4D E8 51 68 ?? ?? ?? ?? 8D 95 68 FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D E8 E8 ?? ?? ?? ?? 83 7D 18 00 0F 85 B0 00 00 00 8B 4D 0C E8 ?? ?? ?? ?? 85 C0 75 7A 8B 4D 0C E8 ?? ?? ?? ?? 85 C0 75 0C 8B 4D 14 E8 ?? ?? ?? ?? 85 C0 74 20 8B 45 0C 50 6A 20 8D 8D 60 FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D E8 E8 ?? ?? ?? ?? EB 40 8B 55 0C 52 8D 85 48 FF FF FF 50 6A 20 8D 8D 50 FF FF FF 51 8B 55 14 52 6A 20 8D 85 58 FF FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 50 8D 4D E8 E8 ?? ?? ?? ?? EB 2A 8B 4D 14 E8 ?? ?? ?? ?? 85 C0 75 1E 8B 4D 14 51 6A 20 8D 95 40 FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D E8 E8 ?? ?? ?? ?? 8D 4D E8 E8 ?? ?? ?? ?? 8D 45 E8 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 F1 00 00 00 6A 01 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 DF 00 00 00 83 7D 18 00 0F 85 93 00 00 00 8B 4D 0C E8 ?? ?? ?? ?? 85 C0 0F 85 83 00 00 00 8B 4D 0C E8 ?? ?? ?? ?? 85 C0 75 0C 8B 4D 14 E8 ?? ?? ?? ?? 85 C0 74 26 8B 4D 0C 51 6A 02 8D 95 38 FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 87 00 00 00 8B 45 0C 50 8D 8D 20 FF FF FF 51 6A 20 8D 95 28 FF FF FF 52 8B 45 14 50 6A 02 8D 8D 30 FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 EB 42 83 7D 18 00 75 2F 8B 4D 14 E8 ?? ?? ?? ?? 85 C0 75 23 8B 55 14 52 6A 02 8D 85 18 FF FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 EB 0D 6A 02 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_35_0 {
	meta:
		name = "?getPtrRefDataType@UnDecorator@@CA?AVDName@@ABV2@H@Z"
		size = 246
		refs = "0007 ?gName@UnDecorator@@0PBDB 003d ?isEmpty@DName@@QBEHXZ 0046 ??_C@_04BMNE@void?$AA@ 004e ??0DName@@QAE@PBD@Z 005f ??_C@_05JDPM@void?5?$AA@ 0068 ??H@YA?AVDName@@PBDABV0@@Z 0074 ??0DName@@QAE@ABV0@@Z 00a1 ?getArrayType@UnDecorator@@CA?AVDName@@ABV2@@Z 00bf ?getBasicDataType@UnDecorator@@CA?AVDName@@ABV2@@Z 00df ??H@YA?AVDName@@W4DNameStatus@@ABV0@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 20 A1 ?? ?? ?? ?? 0F BE 08 85 C9 0F 84 BE 00 00 00 83 7D 10 00 74 61 8B 15 ?? ?? ?? ?? 0F BE 02 83 F8 58 75 53 8B 0D ?? ?? ?? ?? 83 C1 01 89 0D ?? ?? ?? ?? 8B 4D 0C E8 ?? ?? ?? ?? 85 C0 74 15 68 ?? ?? ?? ?? 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 98 00 00 00 8B 55 0C 52 68 ?? ?? ?? ?? 8D 45 F8 50 E8 ?? ?? ?? ?? 83 C4 0C 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 EB 75 8B 0D ?? ?? ?? ?? 0F BE 11 83 FA 59 75 2B A1 ?? ?? ?? ?? 83 C0 01 A3 ?? ?? ?? ?? 8B 4D 0C 51 8D 55 F0 52 E8 ?? ?? ?? ?? 83 C4 08 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 EB 3C 8B 45 0C 50 8D 4D E8 51 E8 ?? ?? ?? ?? 83 C4 08 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 EB 1E 8B 55 0C 52 6A 02 8D 45 E0 50 E8 ?? ?? ?? ?? 83 C4 0C 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_36_0 {
	meta:
		name = "?getArrayType@UnDecorator@@CA?AVDName@@ABV2@@Z"
		size = 475
		refs = "000a ?gName@UnDecorator@@0PBDB 001a ?getNumberOfDimensions@UnDecorator@@CAHXZ 0046 ??0DName@@QAE@D@Z 004d ??HDName@@QBE?AV0@W4DNameStatus@@@Z 0054 ??HDName@@QBE?AV0@D@Z 005e ?getBasicDataType@UnDecorator@@CA?AVDName@@ABV2@@Z 006a ??0DName@@QAE@ABV0@@Z 007a ??0DName@@QAE@XZ 0099 ?getDimension@UnDecorator@@CA?AVDName@@XZ 00a8 ??H@YA?AVDName@@DABV0@@Z 00bb ??YDName@@QAEAAV0@ABV0@@Z 00c5 ?isEmpty@DName@@QBEHXZ 00f7 ??HDName@@QBE?AV0@ABV0@@Z 0100 ??4DName@@QAEAAV0@ABV0@@Z 010d ?getPrimaryDataType@UnDecorator@@CA?AVDName@@ABV2@@Z 0141 ??_C@_02NBBN@?$CJ?$FL?$AA@ 015e ??HDName@@QBE?AV0@PBD@Z"
	strings:
		$1 = { 55 8B EC 81 EC AC 00 00 00 A1 ?? ?? ?? ?? 0F BE 08 85 C9 0F 84 0C 01 00 00 E8 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 7D 07 C7 45 FC 00 00 00 00 83 7D FC 00 75 42 6A 5D 8D 55 DC 52 6A 02 8D 45 E4 50 6A 5B 8D 4D EC E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 50 8D 4D D4 51 E8 ?? ?? ?? ?? 83 C4 08 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 61 01 00 00 8D 4D F4 E8 ?? ?? ?? ?? 8B 55 FC 8B 45 FC 83 E8 01 89 45 FC 85 D2 74 33 6A 5D 8D 4D BC 51 8D 55 CC 52 E8 ?? ?? ?? ?? 83 C4 04 50 6A 5B 8D 45 C4 50 E8 ?? ?? ?? ?? 83 C4 0C 8B C8 E8 ?? ?? ?? ?? 50 8D 4D F4 E8 ?? ?? ?? ?? EB BD 8B 4D 0C E8 ?? ?? ?? ?? 85 C0 75 37 8D 4D F4 51 8D 55 A4 52 6A 29 8D 45 AC 50 8B 4D 0C 51 6A 28 8D 55 B4 52 E8 ?? ?? ?? ?? 83 C4 0C 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 50 8D 4D F4 E8 ?? ?? ?? ?? 8D 45 F4 50 8D 4D 9C 51 E8 ?? ?? ?? ?? 83 C4 08 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 E9 B2 00 00 00 8B 4D 0C E8 ?? ?? ?? ?? 85 C0 75 5D 6A 5D 8D 95 7C FF FF FF 52 6A 02 8D 45 84 50 68 ?? ?? ?? ?? 8D 4D 8C 51 8B 55 0C 52 6A 28 8D 45 94 50 E8 ?? ?? ?? ?? 83 C4 0C 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 50 8D 8D 74 FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 08 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 EB 49 6A 5D 8D 95 5C FF FF FF 52 6A 02 8D 85 64 FF FF FF 50 6A 5B 8D 8D 6C FF FF FF E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 50 8D 8D 54 FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 08 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_37_0 {
	meta:
		name = "?getLexicalFrame@UnDecorator@@CA?AVDName@@XZ"
		size = 62
		refs = "0011 ?getDimension@UnDecorator@@CA?AVDName@@XZ 0020 ??H@YA?AVDName@@DABV0@@Z 002a ??HDName@@QBE?AV0@D@Z 0033 ??0DName@@QAE@ABV0@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 18 6A 27 8D 45 E8 50 8D 4D F8 51 E8 ?? ?? ?? ?? 83 C4 04 50 6A 60 8D 55 F0 52 E8 ?? ?? ?? ?? 83 C4 0C 8B C8 E8 ?? ?? ?? ?? 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_38_0 {
	meta:
		name = "?getThisType@UnDecorator@@CA?AVDName@@XZ"
		size = 56
		refs = "000c ??0DName@@QAE@XZ 0021 ?getDataIndirectType@UnDecorator@@CA?AVDName@@ABV2@D0H@Z 002d ??0DName@@QAE@ABV0@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 18 6A 01 8D 4D F8 E8 ?? ?? ?? ?? 50 6A 00 8D 4D F0 E8 ?? ?? ?? ?? 50 8D 45 E8 50 E8 ?? ?? ?? ?? 83 C4 14 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_39_0 {
	meta:
		name = "?getPointerType@UnDecorator@@CA?AVDName@@ABV2@0@Z"
		size = 44
		refs = "0015 ?getPtrRefType@UnDecorator@@CA?AVDName@@ABV2@0H@Z 0021 ??0DName@@QAE@ABV0@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 6A 01 8B 45 10 50 8B 4D 0C 51 8D 55 F8 52 E8 ?? ?? ?? ?? 83 C4 10 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_40_0 {
	meta:
		name = "?getReferenceType@UnDecorator@@CA?AVDName@@ABV2@0@Z"
		size = 44
		refs = "0015 ?getPtrRefType@UnDecorator@@CA?AVDName@@ABV2@0H@Z 0021 ??0DName@@QAE@ABV0@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 6A 00 8B 45 10 50 8B 4D 0C 51 8D 55 F8 52 E8 ?? ?? ?? ?? 83 C4 10 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_44_0 {
	meta:
		name = "?getVbTableType@UnDecorator@@CA?AVDName@@ABV2@@Z"
		size = 38
		refs = "000f ?getVfTableType@UnDecorator@@CA?AVDName@@ABV2@@Z 001b ??0DName@@QAE@ABV0@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 8B 45 0C 50 8D 4D F8 51 E8 ?? ?? ?? ?? 83 C4 08 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_45_0 {
	meta:
		name = "?getVCallThunkType@UnDecorator@@CA?AVDName@@XZ"
		size = 104
		refs = "0007 ?gName@UnDecorator@@0PBDB 002e ??_C@_06MJGO@?$HLflat?$HN?$AA@ 0036 ??0DName@@QAE@PBD@Z 003f ??0DName@@QAE@ABV0@@Z 004e ??0DName@@QAE@W4DNameStatus@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 0C A1 ?? ?? ?? ?? 8A 08 88 4D F4 80 7D F4 00 74 32 80 7D F4 41 74 02 EB 39 8B 15 ?? ?? ?? ?? 83 C2 01 89 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 EB 1C 6A 02 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 EB 0D 6A 01 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_46_0 {
	meta:
		name = "?getVfTableType@UnDecorator@@CA?AVDName@@ABV2@@Z"
		size = 446
		refs = "000e ??0DName@@QAE@ABV0@@Z 0016 ?isValid@DName@@QBEHXZ 0024 ?gName@UnDecorator@@0PBDB 0046 ?getStorageConvention@UnDecorator@@CA?AVDName@@XZ 0050 ??HDName@@QBE?AV0@D@Z 0057 ??HDName@@QBE?AV0@ABV0@@Z 0060 ??4DName@@QAEAAV0@ABV0@@Z 0087 ??_C@_05EMIF@?$HLfor?5?$AA@ 008f ??YDName@@QAEAAV0@PBD@Z 00cc ?getScope@UnDecorator@@CA?AVDName@@XZ 00db ??H@YA?AVDName@@DABV0@@Z 00ee ??YDName@@QAEAAV0@ABV0@@Z 0128 ??_C@_02HMEB@s?5?$AA@ 0157 ??YDName@@QAEAAV0@W4DNameStatus@@@Z 0161 ??YDName@@QAEAAV0@D@Z 019b ??H@YA?AVDName@@W4DNameStatus@@ABV0@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 40 8B 45 0C 50 8D 4D F8 E8 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? 85 C0 0F 84 62 01 00 00 8B 0D ?? ?? ?? ?? 0F BE 11 85 D2 0F 84 51 01 00 00 8D 45 F8 50 8D 4D E0 51 6A 20 8D 55 E8 52 8D 45 F0 50 E8 ?? ?? ?? ?? 83 C4 04 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 50 8D 4D F8 E8 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? 85 C0 0F 84 0E 01 00 00 8B 0D ?? ?? ?? ?? 0F BE 11 83 FA 40 0F 84 DF 00 00 00 68 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? 85 C0 0F 84 96 00 00 00 A1 ?? ?? ?? ?? 0F BE 08 85 C9 0F 84 86 00 00 00 8B 15 ?? ?? ?? ?? 0F BE 02 83 F8 40 74 78 6A 27 8D 4D C8 51 8D 55 D8 52 E8 ?? ?? ?? ?? 83 C4 04 50 6A 60 8D 45 D0 50 E8 ?? ?? ?? ?? 83 C4 0C 8B C8 E8 ?? ?? ?? ?? 50 8D 4D F8 E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 0F BE 11 83 FA 40 75 0D A1 ?? ?? ?? ?? 83 C0 01 A3 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? 85 C0 74 1B 8B 0D ?? ?? ?? ?? 0F BE 11 83 FA 40 74 0D 68 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? E9 5A FF FF FF 8D 4D F8 E8 ?? ?? ?? ?? 85 C0 74 20 A1 ?? ?? ?? ?? 0F BE 08 85 C9 75 0A 6A 02 8D 4D F8 E8 ?? ?? ?? ?? 6A 7D 8D 4D F8 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 0F BE 02 83 F8 40 75 0F 8B 0D ?? ?? ?? ?? 83 C1 01 89 0D ?? ?? ?? ?? EB 27 8D 4D F8 E8 ?? ?? ?? ?? 85 C0 74 1B 8D 55 F8 52 6A 02 8D 45 C0 50 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D F8 E8 ?? ?? ?? ?? 8D 4D F8 51 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_48_0 {
	meta:
		name = "?getDataIndirectType@UnDecorator@@CA?AVDName@@XZ"
		size = 56
		refs = "000c ??0DName@@QAE@XZ 0021 ?getDataIndirectType@UnDecorator@@CA?AVDName@@ABV2@D0H@Z 002d ??0DName@@QAE@ABV0@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 18 6A 00 8D 4D F8 E8 ?? ?? ?? ?? 50 6A 00 8D 4D F0 E8 ?? ?? ?? ?? 50 8D 45 E8 50 E8 ?? ?? ?? ?? 83 C4 14 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_49_0 {
	meta:
		name = "?getExternalDataType@UnDecorator@@CA?AVDName@@ABV2@@Z"
		size = 151
		refs = "0009 _heap 0010 ??2@YAPAXIAAVHeapManager@@H@Z 0024 ??0DName@@QAE@XZ 0043 ?getDataType@UnDecorator@@CA?AVDName@@PAV2@@Z 004f ??0DName@@QAE@ABV0@@Z 0066 ?getStorageConvention@UnDecorator@@CA?AVDName@@XZ 0070 ??HDName@@QBE?AV0@D@Z 0077 ??HDName@@QBE?AV0@ABV0@@Z 0080 ??4DName@@QAEAAV0@ABV0@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 34 6A 00 68 ?? ?? ?? ?? 6A 08 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F0 83 7D F0 00 74 0D 8B 4D F0 E8 ?? ?? ?? ?? 89 45 CC EB 07 C7 45 CC 00 00 00 00 8B 45 CC 89 45 FC 8B 4D FC 51 8D 55 E8 52 E8 ?? ?? ?? ?? 83 C4 08 50 8D 4D F4 E8 ?? ?? ?? ?? 8B 45 0C 50 8D 4D D0 51 6A 20 8D 55 D8 52 8D 45 E0 50 E8 ?? ?? ?? ?? 83 C4 04 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 50 8B 4D FC E8 ?? ?? ?? ?? 8D 4D F4 51 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_50_0 {
	meta:
		name = "?doMSKeywords@UnDecorator@@SAHXZ"
		size = 18
		refs = "0004 ?disableFlags@UnDecorator@@0KA"
	strings:
		$1 = { 55 8B EC A1 ?? ?? ?? ?? 83 E0 02 F7 D8 1B C0 40 5D C3 }
	condition:
		$1
}

rule file_69_51_0 {
	meta:
		name = "?doFunctionReturns@UnDecorator@@SAHXZ"
		size = 18
		refs = "0004 ?disableFlags@UnDecorator@@0KA"
	strings:
		$1 = { 55 8B EC A1 ?? ?? ?? ?? 83 E0 04 F7 D8 1B C0 40 5D C3 }
	condition:
		$1
}

rule file_69_52_0 {
	meta:
		name = "?doAllocationModel@UnDecorator@@SAHXZ"
		size = 18
		refs = "0004 ?disableFlags@UnDecorator@@0KA"
	strings:
		$1 = { 55 8B EC A1 ?? ?? ?? ?? 83 E0 08 F7 D8 1B C0 40 5D C3 }
	condition:
		$1
}

rule file_69_53_0 {
	meta:
		name = "?doAllocationLanguage@UnDecorator@@SAHXZ"
		size = 18
		refs = "0004 ?disableFlags@UnDecorator@@0KA"
	strings:
		$1 = { 55 8B EC A1 ?? ?? ?? ?? 83 E0 10 F7 D8 1B C0 40 5D C3 }
	condition:
		$1
}

rule file_69_54_0 {
	meta:
		name = "?doThisTypes@UnDecorator@@SAHXZ"
		size = 23
		refs = "0004 ?disableFlags@UnDecorator@@0KA"
	strings:
		$1 = { 55 8B EC A1 ?? ?? ?? ?? 83 E0 60 33 C9 83 F8 60 0F 95 C1 8B C1 5D C3 }
	condition:
		$1
}

rule file_69_55_0 {
	meta:
		name = "?doAccessSpecifiers@UnDecorator@@SAHXZ"
		size = 20
		refs = "0004 ?disableFlags@UnDecorator@@0KA"
	strings:
		$1 = { 55 8B EC A1 ?? ?? ?? ?? 25 80 00 00 00 F7 D8 1B C0 40 5D C3 }
	condition:
		$1
}

rule file_69_56_0 {
	meta:
		name = "?doThrowTypes@UnDecorator@@SAHXZ"
		size = 20
		refs = "0004 ?disableFlags@UnDecorator@@0KA"
	strings:
		$1 = { 55 8B EC A1 ?? ?? ?? ?? 25 00 01 00 00 F7 D8 1B C0 40 5D C3 }
	condition:
		$1
}

rule file_69_57_0 {
	meta:
		name = "?doMemberTypes@UnDecorator@@SAHXZ"
		size = 20
		refs = "0004 ?disableFlags@UnDecorator@@0KA"
	strings:
		$1 = { 55 8B EC A1 ?? ?? ?? ?? 25 00 02 00 00 F7 D8 1B C0 40 5D C3 }
	condition:
		$1
}

rule file_69_61_0 {
	meta:
		name = "?doEcsu@UnDecorator@@SAHXZ"
		size = 20
		refs = "0004 ?disableFlags@UnDecorator@@0KA"
	strings:
		$1 = { 55 8B EC A1 ?? ?? ?? ?? 25 00 80 00 00 F7 D8 1B C0 40 5D C3 }
	condition:
		$1
}

rule file_69_62_0 {
	meta:
		name = "?UScore@UnDecorator@@SAPBDW4Tokens@@@Z"
		size = 39
		refs = "0004 ?doUnderScore@UnDecorator@@SAHXZ 0012 _tokenTable"
	strings:
		$1 = { 55 8B EC E8 ?? ?? ?? ?? 85 C0 74 0C 8B 45 08 8B 04 85 ?? ?? ?? ?? EB 0D 8B 4D 08 8B 04 8D ?? ?? ?? ?? 83 C0 02 5D C3 }
	condition:
		$1
}

rule file_69_63_0 {
	meta:
		name = "?doUnderScore@UnDecorator@@SAHXZ"
		size = 18
		refs = "0004 ?disableFlags@UnDecorator@@0KA"
	strings:
		$1 = { 55 8B EC A1 ?? ?? ?? ?? 83 E0 01 F7 D8 1B C0 40 5D C3 }
	condition:
		$1
}

rule file_69_64_0 {
	meta:
		name = "??2@YAPAXIAAVHeapManager@@H@Z"
		size = 23
		refs = "000c _heap 0011 ?getMemory@HeapManager@@QAEPAXIH@Z"
	strings:
		$1 = { 55 8B EC 8B 45 10 50 8B 4D 08 51 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_69_65_0 {
	meta:
		name = "?getMemory@HeapManager@@QAEPAXIH@Z"
		size = 256
		refs = "005a _heap 0064 ??2@YAPAXIAAVHeapManager@@H@Z 0078 ??0Block@HeapManager@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 83 EC 10 89 4D F4 8B 45 08 83 C0 07 24 F8 89 45 08 83 7D 0C 00 74 11 8B 4D 08 51 8B 55 F4 FF 12 83 C4 04 E9 CF 00 00 00 83 7D 08 00 75 07 C7 45 08 01 00 00 00 8B 45 F4 8B 48 10 3B 4D 08 0F 83 94 00 00 00 81 7D 08 FC 01 00 00 76 07 33 C0 E9 A3 00 00 00 6A 01 68 ?? ?? ?? ?? 68 00 02 00 00 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F8 83 7D F8 00 74 0D 8B 4D F8 E8 ?? ?? ?? ?? 89 45 F0 EB 07 C7 45 F0 00 00 00 00 8B 55 F0 89 55 FC 83 7D FC 00 74 41 8B 45 F4 83 78 0C 00 74 16 8B 4D F4 8B 51 0C 8B 45 FC 89 02 8B 4D F4 8B 55 FC 89 51 0C EB 12 8B 45 F4 8B 4D FC 89 48 0C 8B 55 F4 8B 45 FC 89 42 08 B9 FC 01 00 00 2B 4D 08 8B 55 F4 89 4A 10 EB 04 33 C0 EB 21 EB 0F 8B 45 F4 8B 48 10 2B 4D 08 8B 55 F4 89 4A 10 8B 45 F4 8B 48 0C 8B 55 F4 8B 42 10 8D 44 01 04 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_69_66_0 {
	meta:
		name = "??0Block@HeapManager@@QAE@XZ"
		size = 23
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 00 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_67_0 {
	meta:
		name = "??H@YA?AVDName@@DABV0@@Z"
		size = 49
		refs = "0016 ??0DName@@QAE@D@Z 001d ??HDName@@QBE?AV0@ABV0@@Z 0026 ??0DName@@QAE@ABV0@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 8B 45 10 50 8D 4D F0 51 8A 55 0C 52 8D 4D F8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_68_0 {
	meta:
		name = "??H@YA?AVDName@@W4DNameStatus@@ABV0@@Z"
		size = 49
		refs = "0016 ??0DName@@QAE@W4DNameStatus@@@Z 001d ??HDName@@QBE?AV0@ABV0@@Z 0026 ??0DName@@QAE@ABV0@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 8B 45 10 50 8D 4D F0 51 8B 55 0C 52 8D 4D F8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_69_0 {
	meta:
		name = "??H@YA?AVDName@@PBDABV0@@Z"
		size = 49
		refs = "0016 ??0DName@@QAE@PBD@Z 001d ??HDName@@QBE?AV0@ABV0@@Z 0026 ??0DName@@QAE@ABV0@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 8B 45 10 50 8D 4D F0 51 8B 55 0C 52 8D 4D F8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_70_0 {
	meta:
		name = "??0DName@@QAE@XZ"
		size = 83
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 00 00 00 00 8B 4D FC 8B 51 04 83 E2 F0 8B 45 FC 89 50 04 8B 4D FC 8B 51 04 83 E2 EF 8B 45 FC 89 50 04 8B 4D FC 8B 51 04 83 E2 DF 8B 45 FC 89 50 04 8B 4D FC 8B 51 04 83 E2 BF 8B 45 FC 89 50 04 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_71_0 {
	meta:
		name = "??0DName@@QAE@D@Z"
		size = 107
		refs = "005e ?doPchar@DName@@AAEXPBDH@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 48 04 83 E1 F0 8B 55 FC 89 4A 04 8B 45 FC 8B 48 04 83 E1 EF 8B 55 FC 89 4A 04 8B 45 FC 8B 48 04 83 E1 DF 8B 55 FC 89 4A 04 8B 45 FC 8B 48 04 83 E1 BF 8B 55 FC 89 4A 04 8B 45 FC C7 00 00 00 00 00 0F BE 4D 08 85 C9 74 0E 6A 01 8D 55 08 52 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_69_72_0 {
	meta:
		name = "??0DName@@QAE@ABV0@@Z"
		size = 161
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 8B 48 04 C1 E1 1C C1 F9 1C 83 E1 0F 8B 55 FC 8B 42 04 24 F0 0B C1 8B 4D FC 89 41 04 8B 55 08 8B 42 04 C1 E8 04 83 E0 01 83 E0 01 C1 E0 04 8B 4D FC 8B 51 04 83 E2 EF 0B D0 8B 45 FC 89 50 04 8B 4D 08 8B 51 04 C1 EA 05 83 E2 01 83 E2 01 C1 E2 05 8B 45 FC 8B 48 04 83 E1 DF 0B CA 8B 55 FC 89 4A 04 8B 45 08 8B 48 04 C1 E9 06 83 E1 01 83 E1 01 C1 E1 06 8B 55 FC 8B 42 04 24 BF 0B C1 8B 4D FC 89 41 04 8B 55 FC 8B 45 08 8B 08 89 0A 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_69_73_0 {
	meta:
		name = "??0DName@@QAE@PAV0@@Z"
		size = 186
		refs = "0012 _heap 0019 ??2@YAPAXIAAVHeapManager@@H@Z 0031 ??0pDNameNode@@QAE@PAVDName@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D F8 83 7D 08 00 74 5E 6A 00 68 ?? ?? ?? ?? 6A 0C E8 ?? ?? ?? ?? 83 C4 0C 89 45 FC 83 7D FC 00 74 11 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 89 45 F4 EB 07 C7 45 F4 00 00 00 00 8B 4D F8 8B 55 F4 89 11 8B 45 F8 8B 08 F7 D9 1B C9 83 E1 FD 83 C1 03 83 E1 0F 8B 55 F8 8B 42 04 24 F0 0B C1 8B 4D F8 89 41 04 EB 17 8B 55 F8 8B 42 04 24 F0 8B 4D F8 89 41 04 8B 55 F8 C7 02 00 00 00 00 8B 45 F8 8B 48 04 83 E1 EF 8B 55 F8 89 4A 04 8B 45 F8 8B 48 04 83 E1 DF 8B 55 F8 89 4A 04 8B 45 F8 8B 48 04 83 E1 BF 8B 55 F8 89 4A 04 8B 45 F8 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_69_74_0 {
	meta:
		name = "??0DName@@QAE@PBD@Z"
		size = 116
		refs = "0057 ?strlen@@YAIPBD@Z 0067 ?doPchar@DName@@AAEXPBDH@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 48 04 83 E1 F0 8B 55 FC 89 4A 04 8B 45 FC C7 00 00 00 00 00 8B 4D FC 8B 51 04 83 E2 EF 8B 45 FC 89 50 04 8B 4D FC 8B 51 04 83 E2 DF 8B 45 FC 89 50 04 8B 4D FC 8B 51 04 83 E2 BF 8B 45 FC 89 50 04 83 7D 08 00 74 19 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 50 8B 55 08 52 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_69_75_0 {
	meta:
		name = "??0DName@@QAE@AAPBDD@Z"
		size = 501
		refs = "0116 ?doNoIdentCharCheck@UnDecorator@@SAHXZ 0151 ?doPchar@DName@@AAEXPBDH@Z 01af ?status@DName@@QBE?AW4DNameStatus@@XZ"
	strings:
		$1 = { 55 8B EC 83 EC 0C 56 89 4D F4 8B 45 F4 8B 48 04 83 E1 F0 8B 55 F4 89 4A 04 8B 45 F4 8B 48 04 83 E1 EF 8B 55 F4 89 4A 04 8B 45 F4 8B 48 04 83 E1 DF 8B 55 F4 89 4A 04 8B 45 F4 8B 48 04 83 E1 BF 8B 55 F4 89 4A 04 8B 45 F4 C7 00 00 00 00 00 8B 4D 08 83 39 00 0F 84 80 01 00 00 8B 55 08 8B 02 0F BE 08 85 C9 0F 84 5E 01 00 00 C7 45 F8 00 00 00 00 8B 55 08 8B 02 89 45 FC EB 0D 8B 4D 08 8B 11 83 C2 01 8B 45 08 89 10 8B 4D 08 8B 11 0F BE 02 85 C0 0F 84 AC 00 00 00 8B 4D 08 8B 11 0F BE 02 0F BE 4D 0C 3B C1 0F 84 98 00 00 00 8B 55 08 8B 02 0F BE 08 83 F9 5F 74 64 8B 55 08 8B 02 0F BE 08 83 F9 24 74 57 8B 55 08 8B 02 0F BE 08 83 F9 61 7C 0D 8B 55 08 8B 02 0F BE 08 83 F9 7A 7E 3D 8B 55 08 8B 02 0F BE 08 83 F9 41 7C 0D 8B 55 08 8B 02 0F BE 08 83 F9 5A 7E 23 8B 55 08 8B 02 0F BE 08 83 F9 30 7C 0D 8B 55 08 8B 02 0F BE 08 83 F9 39 7E 09 E8 ?? ?? ?? ?? 85 C0 74 0B 8B 55 F8 83 C2 01 89 55 F8 EB 17 8B 45 F4 8B 48 04 83 E1 F0 83 C9 01 8B 55 F4 89 4A 04 E9 AB 00 00 00 E9 37 FF FF FF 8B 45 F8 50 8B 4D FC 51 8B 4D F4 E8 ?? ?? ?? ?? 8B 55 08 8B 02 0F BE 08 85 C9 74 4A 8B 55 08 8B 02 0F BE 08 0F BE 55 0C 8B 45 08 8B 00 83 C0 01 8B 75 08 89 06 3B CA 74 1D 8B 4D F4 8B 51 04 83 E2 F0 83 CA 03 8B 45 F4 89 50 04 8B 4D F4 C7 01 00 00 00 00 EB 0E 8B 55 F4 8B 42 04 24 F0 8B 4D F4 89 41 04 EB 1C 8B 4D F4 E8 ?? ?? ?? ?? 85 C0 75 10 8B 55 F4 8B 42 04 24 F0 0C 02 8B 4D F4 89 41 04 EB 10 8B 55 F4 8B 42 04 24 F0 0C 02 8B 4D F4 89 41 04 EB 10 8B 55 F4 8B 42 04 24 F0 0C 01 8B 4D F4 89 41 04 8B 45 F4 5E 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_69_77_0 {
	meta:
		name = "??0DName@@QAE@K@Z"
		size = 174
		refs = "00a1 ?doPchar@DName@@AAEXPBDH@Z"
	strings:
		$1 = { 55 8B EC 83 EC 14 89 4D EC 8D 45 FE 89 45 F0 8B 4D EC 8B 51 04 83 E2 F0 8B 45 EC 89 50 04 8B 4D EC C7 01 00 00 00 00 8B 55 EC 8B 42 04 24 EF 8B 4D EC 89 41 04 8B 55 EC 8B 42 04 24 DF 8B 4D EC 89 41 04 8B 55 EC 8B 42 04 24 BF 8B 4D EC 89 41 04 8B 55 F0 C6 02 00 8B 45 08 33 D2 B9 0A 00 00 00 F7 F1 83 C2 30 8B 45 F0 83 E8 01 89 45 F0 8B 4D F0 88 11 8B 45 08 33 D2 B9 0A 00 00 00 F7 F1 89 45 08 83 7D 08 00 75 CE 8B 55 F0 8D 45 F4 2B D0 B9 0A 00 00 00 2B CA 51 8B 55 F0 52 8B 4D EC E8 ?? ?? ?? ?? 8B 45 EC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_69_78_0 {
	meta:
		name = "??0DName@@QAE@W4DNameStatus@@@Z"
		size = 193
		refs = "003d _heap 0044 ??2@YAPAXIAAVHeapManager@@H@Z 005c ??0DNameStatusNode@@QAE@W4DNameStatus@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 89 4D F8 83 7D 08 01 74 0F 83 7D 08 03 74 09 C7 45 F4 00 00 00 00 EB 06 8B 45 08 89 45 F4 8B 4D F4 83 E1 0F 8B 55 F8 8B 42 04 24 F0 0B C1 8B 4D F8 89 41 04 6A 00 68 ?? ?? ?? ?? 6A 10 E8 ?? ?? ?? ?? 83 C4 0C 89 45 FC 83 7D FC 00 74 11 8B 55 08 52 8B 4D FC E8 ?? ?? ?? ?? 89 45 F0 EB 07 C7 45 F0 00 00 00 00 8B 45 F8 8B 4D F0 89 08 8B 55 F8 8B 42 04 24 EF 8B 4D F8 89 41 04 8B 55 F8 8B 42 04 24 DF 8B 4D F8 89 41 04 8B 55 F8 8B 42 04 24 BF 8B 4D F8 89 41 04 8B 55 F8 83 3A 00 75 12 8B 45 F8 8B 48 04 83 E1 F0 83 C9 03 8B 55 F8 89 4A 04 8B 45 F8 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_69_79_0 {
	meta:
		name = "?isValid@DName@@QBEHXZ"
		size = 57
		refs = "000d ?status@DName@@QBE?AW4DNameStatus@@XZ"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 85 C0 74 16 8B 4D FC E8 ?? ?? ?? ?? 83 F8 02 74 09 C7 45 F8 00 00 00 00 EB 07 C7 45 F8 01 00 00 00 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_80_0 {
	meta:
		name = "?isEmpty@DName@@QBEHXZ"
		size = 52
		refs = "0015 ?isValid@DName@@QBEHXZ"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 83 38 00 74 15 8B 4D FC E8 ?? ?? ?? ?? 85 C0 74 09 C7 45 F8 00 00 00 00 EB 07 C7 45 F8 01 00 00 00 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_81_0 {
	meta:
		name = "?status@DName@@QBE?AW4DNameStatus@@XZ"
		size = 23
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 40 04 C1 E0 1C C1 F8 1C 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_82_0 {
	meta:
		name = "?setPtrRef@DName@@QAEAAV1@XZ"
		size = 29
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 48 04 83 C9 10 8B 55 FC 89 4A 04 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_83_0 {
	meta:
		name = "?isPtrRef@DName@@QBEHXZ"
		size = 23
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 40 04 C1 E8 04 83 E0 01 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_84_0 {
	meta:
		name = "?isUDC@DName@@QBEHXZ"
		size = 60
		refs = "000d ?isEmpty@DName@@QBEHXZ"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 85 C0 75 19 8B 45 FC 8B 48 04 C1 E9 05 83 E1 01 85 C9 74 09 C7 45 F8 01 00 00 00 EB 07 C7 45 F8 00 00 00 00 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_85_0 {
	meta:
		name = "?setIsUDC@DName@@QAEXXZ"
		size = 38
		refs = "000b ?isEmpty@DName@@QBEHXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 85 C0 75 0F 8B 45 FC 8B 48 04 83 C9 20 8B 55 FC 89 4A 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_86_0 {
	meta:
		name = "?isUDTThunk@DName@@QBEHXZ"
		size = 60
		refs = "000d ?isEmpty@DName@@QBEHXZ"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 85 C0 75 19 8B 45 FC 8B 48 04 C1 E9 06 83 E1 01 85 C9 74 09 C7 45 F8 01 00 00 00 EB 07 C7 45 F8 00 00 00 00 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_87_0 {
	meta:
		name = "?length@DName@@QBEHXZ"
		size = 82
		refs = "0014 ?isEmpty@DName@@QBEHXZ 002a ?nextNode@DNameNode@@QBEPAV1@XZ"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D F4 C7 45 FC 00 00 00 00 8B 4D F4 E8 ?? ?? ?? ?? 85 C0 75 2F 8B 45 F4 8B 08 89 4D F8 EB 0B 8B 4D F8 E8 ?? ?? ?? ?? 89 45 F8 83 7D F8 00 74 14 8B 55 F8 8B 02 8B 4D F8 FF 10 8B 4D FC 03 C8 89 4D FC EB DB 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_88_0 {
	meta:
		name = "?getLastChar@DName@@QBEDXZ"
		size = 110
		refs = "0014 ?isEmpty@DName@@QBEHXZ 002a ?nextNode@DNameNode@@QBEPAV1@XZ"
	strings:
		$1 = { 55 8B EC 83 EC 10 89 4D F4 C7 45 FC 00 00 00 00 8B 4D F4 E8 ?? ?? ?? ?? 85 C0 75 31 8B 45 F4 8B 08 89 4D F8 EB 0B 8B 4D F8 E8 ?? ?? ?? ?? 89 45 F8 83 7D F8 00 74 16 8B 55 F8 8B 02 8B 4D F8 FF 10 85 C0 74 06 8B 4D F8 89 4D FC EB D9 83 7D FC 00 74 10 8B 55 FC 8B 02 8B 4D FC FF 50 04 88 45 F3 EB 04 C6 45 F3 00 8A 45 F3 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_89_0 {
	meta:
		name = "?getString@DName@@QBEPADPADH@Z"
		size = 245
		refs = "000d ?isEmpty@DName@@QBEHXZ 0023 ?length@DName@@QBEHXZ 0030 _heap 0039 ??2@YAPAXIAAVHeapManager@@H@Z 00cf ?nextNode@DNameNode@@QBEPAV1@XZ"
	strings:
		$1 = { 55 8B EC 83 EC 1C 89 4D E4 8B 4D E4 E8 ?? ?? ?? ?? 85 C0 0F 85 C7 00 00 00 83 7D 08 00 75 2A 8B 4D E4 E8 ?? ?? ?? ?? 83 C0 01 89 45 0C 6A 00 68 ?? ?? ?? ?? 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 0C 89 45 E8 8B 4D E8 89 4D 08 83 7D 08 00 0F 84 8B 00 00 00 8B 55 0C 89 55 F4 8B 45 E4 8B 08 89 4D F8 8B 55 08 89 55 FC 83 7D F8 00 74 6B 83 7D F4 00 7E 65 8B 45 F8 8B 10 8B 4D F8 FF 12 89 45 F0 C7 45 EC 00 00 00 00 83 7D F0 00 74 3E 8B 45 F4 2B 45 F0 85 C0 7D 06 8B 4D F4 89 4D F0 8B 55 F0 52 8B 45 FC 50 8B 4D F8 8B 11 8B 4D F8 FF 52 08 89 45 EC 83 7D EC 00 74 12 8B 45 F4 2B 45 F0 89 45 F4 8B 4D FC 03 4D F0 89 4D FC 8B 4D F8 E8 ?? ?? ?? ?? 89 45 F8 EB 8F 8B 55 FC C6 02 00 EB 0C 83 7D 08 00 74 06 8B 45 08 C6 00 00 8B 45 08 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_69_90_0 {
	meta:
		name = "??HDName@@QBE?AV0@D@Z"
		size = 80
		refs = "0011 ??0DName@@QAE@ABV0@@Z 0019 ?isEmpty@DName@@QBEHXZ 0029 ??4DName@@QAEAAV0@D@Z 0037 ??YDName@@QAEAAV0@D@Z"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D F4 8B 45 F4 50 8D 4D F8 E8 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? 85 C0 74 0E 8A 4D 0C 51 8D 4D F8 E8 ?? ?? ?? ?? EB 0C 8A 55 0C 52 8D 4D F8 E8 ?? ?? ?? ?? 8D 45 F8 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_69_91_0 {
	meta:
		name = "??HDName@@QBE?AV0@PBD@Z"
		size = 80
		refs = "0011 ??0DName@@QAE@ABV0@@Z 0019 ?isEmpty@DName@@QBEHXZ 0029 ??4DName@@QAEAAV0@PBD@Z 0037 ??YDName@@QAEAAV0@PBD@Z"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D F4 8B 45 F4 50 8D 4D F8 E8 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? 85 C0 74 0E 8B 4D 0C 51 8D 4D F8 E8 ?? ?? ?? ?? EB 0C 8B 55 0C 52 8D 4D F8 E8 ?? ?? ?? ?? 8D 45 F8 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_69_93_0 {
	meta:
		name = "??HDName@@QBE?AV0@PAV0@@Z"
		size = 80
		refs = "0011 ??0DName@@QAE@ABV0@@Z 0019 ?isEmpty@DName@@QBEHXZ 0029 ??4DName@@QAEAAV0@PAV0@@Z 0037 ??YDName@@QAEAAV0@PAV0@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D F4 8B 45 F4 50 8D 4D F8 E8 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? 85 C0 74 0E 8B 4D 0C 51 8D 4D F8 E8 ?? ?? ?? ?? EB 0C 8B 55 0C 52 8D 4D F8 E8 ?? ?? ?? ?? 8D 45 F8 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_69_94_0 {
	meta:
		name = "??HDName@@QBE?AV0@W4DNameStatus@@@Z"
		size = 80
		refs = "0011 ??0DName@@QAE@ABV0@@Z 0019 ?isEmpty@DName@@QBEHXZ 0029 ??4DName@@QAEAAV0@W4DNameStatus@@@Z 0037 ??YDName@@QAEAAV0@W4DNameStatus@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D F4 8B 45 F4 50 8D 4D F8 E8 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? 85 C0 74 0E 8B 4D 0C 51 8D 4D F8 E8 ?? ?? ?? ?? EB 0C 8B 55 0C 52 8D 4D F8 E8 ?? ?? ?? ?? 8D 45 F8 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_69_92_0 {
	meta:
		name = "??HDName@@QBE?AV0@ABV0@@Z"
		size = 111
		refs = "0011 ??0DName@@QAE@ABV0@@Z 0019 ?isEmpty@DName@@QBEHXZ 0029 ??4DName@@QAEAAV0@ABV0@@Z 003f ?status@DName@@QBE?AW4DNameStatus@@XZ 0048 ??YDName@@QAEAAV0@W4DNameStatus@@@Z 0056 ??YDName@@QAEAAV0@ABV0@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D F4 8B 45 F4 50 8D 4D F8 E8 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? 85 C0 74 0E 8B 4D 0C 51 8D 4D F8 E8 ?? ?? ?? ?? EB 2B 8B 4D 0C E8 ?? ?? ?? ?? 85 C0 74 13 8B 4D 0C E8 ?? ?? ?? ?? 50 8D 4D F8 E8 ?? ?? ?? ?? EB 0C 8B 55 0C 52 8D 4D F8 E8 ?? ?? ?? ?? 8D 45 F8 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_69_95_0 {
	meta:
		name = "??YDName@@QAEAAV0@D@Z"
		size = 163
		refs = "0019 ?isEmpty@DName@@QBEHXZ 0029 ??4DName@@QAEAAV0@D@Z 0035 ?clone@DNameNode@@QAEPAV1@XZ 0049 _heap 0050 ??2@YAPAXIAAVHeapManager@@H@Z 0068 ??0charNode@@QAE@D@Z 0082 ??YDNameNode@@QAEAAV0@PAV0@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D F8 0F BE 45 08 85 C0 0F 84 85 00 00 00 8B 4D F8 E8 ?? ?? ?? ?? 85 C0 74 0E 8A 4D 08 51 8B 4D F8 E8 ?? ?? ?? ?? EB 6B 8B 55 F8 8B 0A E8 ?? ?? ?? ?? 8B 4D F8 89 01 8B 55 F8 83 3A 00 74 42 6A 00 68 ?? ?? ?? ?? 6A 0C E8 ?? ?? ?? ?? 83 C4 0C 89 45 FC 83 7D FC 00 74 11 8A 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 89 45 F4 EB 07 C7 45 F4 00 00 00 00 8B 4D F4 51 8B 55 F8 8B 0A E8 ?? ?? ?? ?? EB 12 8B 45 F8 8B 48 04 83 E1 F0 83 C9 03 8B 55 F8 89 4A 04 8B 45 F8 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_69_96_0 {
	meta:
		name = "??YDName@@QAEAAV0@PBD@Z"
		size = 177
		refs = "0025 ?isEmpty@DName@@QBEHXZ 0035 ??4DName@@QAEAAV0@PBD@Z 0041 ?clone@DNameNode@@QAEPAV1@XZ 0055 _heap 005c ??2@YAPAXIAAVHeapManager@@H@Z 0076 ??0pcharNode@@QAE@PBDH@Z 0090 ??YDNameNode@@QAEAAV0@PAV0@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D F8 83 7D 08 00 0F 84 95 00 00 00 8B 45 08 0F BE 08 85 C9 0F 84 87 00 00 00 8B 4D F8 E8 ?? ?? ?? ?? 85 C0 74 0E 8B 55 08 52 8B 4D F8 E8 ?? ?? ?? ?? EB 6D 8B 45 F8 8B 08 E8 ?? ?? ?? ?? 8B 4D F8 89 01 8B 55 F8 83 3A 00 74 44 6A 00 68 ?? ?? ?? ?? 6A 10 E8 ?? ?? ?? ?? 83 C4 0C 89 45 FC 83 7D FC 00 74 13 6A 00 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 89 45 F4 EB 07 C7 45 F4 00 00 00 00 8B 4D F4 51 8B 55 F8 8B 0A E8 ?? ?? ?? ?? EB 12 8B 45 F8 8B 48 04 83 E1 F0 83 C9 03 8B 55 F8 89 4A 04 8B 45 F8 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_69_97_0 {
	meta:
		name = "??YDName@@QAEAAV0@ABV0@@Z"
		size = 132
		refs = "000b ?isEmpty@DName@@QBEHXZ 0017 ?status@DName@@QBE?AW4DNameStatus@@XZ 0020 ??YDName@@QAEAAV0@W4DNameStatus@@@Z 003a ??4DName@@QAEAAV0@ABV0@@Z 0046 ?clone@DNameNode@@QAEPAV1@XZ 0063 ??YDNameNode@@QAEAAV0@PAV0@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D 08 E8 ?? ?? ?? ?? 85 C0 74 13 8B 4D 08 E8 ?? ?? ?? ?? 50 8B 4D FC E8 ?? ?? ?? ?? EB 55 8B 4D FC E8 ?? ?? ?? ?? 85 C0 74 0E 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? EB 3B 8B 4D FC 8B 09 E8 ?? ?? ?? ?? 8B 55 FC 89 02 8B 45 FC 83 38 00 74 12 8B 4D 08 8B 11 52 8B 45 FC 8B 08 E8 ?? ?? ?? ?? EB 12 8B 4D FC 8B 51 04 83 E2 F0 83 CA 03 8B 45 FC 89 50 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_69_98_0 {
	meta:
		name = "??YDName@@QAEAAV0@PAV0@@Z"
		size = 241
		refs = "0017 ?isEmpty@DName@@QBEHXZ 0027 ??4DName@@QAEAAV0@PAV0@@Z 0034 ?status@DName@@QBE?AW4DNameStatus@@XZ 0050 _heap 0057 ??2@YAPAXIAAVHeapManager@@H@Z 006f ??0pDNameNode@@QAE@PAVDName@@@Z 0091 ?clone@DNameNode@@QAEPAV1@XZ 00ac ??YDNameNode@@QAEAAV0@PAV0@@Z 00e4 ??YDName@@QAEAAV0@W4DNameStatus@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 89 4D F4 83 7D 08 00 0F 84 D5 00 00 00 8B 4D F4 E8 ?? ?? ?? ?? 85 C0 74 11 8B 45 08 50 8B 4D F4 E8 ?? ?? ?? ?? E9 B8 00 00 00 8B 4D 08 E8 ?? ?? ?? ?? 85 C0 74 11 8B 4D 08 E8 ?? ?? ?? ?? 83 F8 02 0F 85 8A 00 00 00 6A 00 68 ?? ?? ?? ?? 6A 0C E8 ?? ?? ?? ?? 83 C4 0C 89 45 F8 83 7D F8 00 74 11 8B 4D 08 51 8B 4D F8 E8 ?? ?? ?? ?? 89 45 F0 EB 07 C7 45 F0 00 00 00 00 8B 55 F0 89 55 FC 83 7D FC 00 74 27 8B 45 F4 8B 08 E8 ?? ?? ?? ?? 8B 4D F4 89 01 8B 55 F4 83 3A 00 74 0E 8B 45 FC 50 8B 4D F4 8B 09 E8 ?? ?? ?? ?? EB 09 8B 55 F4 C7 02 00 00 00 00 8B 45 F4 83 38 00 75 12 8B 4D F4 8B 51 04 83 E2 F0 83 CA 03 8B 45 F4 89 50 04 EB 11 8B 4D 08 E8 ?? ?? ?? ?? 50 8B 4D F4 E8 ?? ?? ?? ?? 8B 45 F4 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_69_99_0 {
	meta:
		name = "??YDName@@QAEAAV0@W4DNameStatus@@@Z"
		size = 195
		refs = "000d ?isEmpty@DName@@QBEHXZ 0029 ??4DName@@QAEAAV0@W4DNameStatus@@@Z 0035 _heap 003c ??2@YAPAXIAAVHeapManager@@H@Z 0054 ??0DNameStatusNode@@QAE@W4DNameStatus@@@Z 0076 ?clone@DNameNode@@QAEPAV1@XZ 0091 ??YDNameNode@@QAEAAV0@PAV0@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 89 4D F4 8B 4D F4 E8 ?? ?? ?? ?? 85 C0 75 0C 83 7D 08 01 74 06 83 7D 08 03 75 11 8B 45 08 50 8B 4D F4 E8 ?? ?? ?? ?? E9 88 00 00 00 6A 00 68 ?? ?? ?? ?? 6A 10 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F8 83 7D F8 00 74 11 8B 4D 08 51 8B 4D F8 E8 ?? ?? ?? ?? 89 45 F0 EB 07 C7 45 F0 00 00 00 00 8B 55 F0 89 55 FC 83 7D FC 00 74 27 8B 45 F4 8B 08 E8 ?? ?? ?? ?? 8B 4D F4 89 01 8B 55 F4 83 3A 00 74 0E 8B 45 FC 50 8B 4D F4 8B 09 E8 ?? ?? ?? ?? EB 09 8B 55 F4 C7 02 00 00 00 00 8B 45 F4 83 38 00 75 12 8B 4D F4 8B 51 04 83 E2 F0 83 CA 03 8B 45 F4 89 50 04 8B 45 F4 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_69_100_0 {
	meta:
		name = "??_5DName@@QAEAAV0@ABV0@@Z"
		size = 77
		refs = "000d ?status@DName@@QBE?AW4DNameStatus@@XZ 001a ?isValid@DName@@QBEHXZ"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 83 F8 03 74 2E 8B 4D 08 E8 ?? ?? ?? ?? 85 C0 75 22 8B 4D 08 E8 ?? ?? ?? ?? 89 45 F8 8B 45 F8 83 E0 0F 8B 4D FC 8B 51 04 83 E2 F0 0B D0 8B 45 FC 89 50 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_69_101_0 {
	meta:
		name = "??4DName@@QAEAAV0@D@Z"
		size = 75
		refs = "003e ?doPchar@DName@@AAEXPBDH@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 48 04 83 E1 EF 8B 55 FC 89 4A 04 8B 45 FC 8B 48 04 83 E1 DF 8B 55 FC 89 4A 04 8B 45 FC 8B 48 04 83 E1 BF 8B 55 FC 89 4A 04 6A 01 8D 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_69_102_0 {
	meta:
		name = "??4DName@@QAEAAV0@PBD@Z"
		size = 86
		refs = "0039 ?strlen@@YAIPBD@Z 0049 ?doPchar@DName@@AAEXPBDH@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 48 04 83 E1 EF 8B 55 FC 89 4A 04 8B 45 FC 8B 48 04 83 E1 DF 8B 55 FC 89 4A 04 8B 45 FC 8B 48 04 83 E1 BF 8B 55 FC 89 4A 04 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 50 8B 4D 08 51 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_69_103_0 {
	meta:
		name = "??4DName@@QAEAAV0@ABV0@@Z"
		size = 190
		refs = "000b ?status@DName@@QBE?AW4DNameStatus@@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 85 C0 74 11 8B 4D FC E8 ?? ?? ?? ?? 83 F8 02 0F 85 91 00 00 00 8B 45 08 8B 48 04 C1 E1 1C C1 F9 1C 83 E1 0F 8B 55 FC 8B 42 04 24 F0 0B C1 8B 4D FC 89 41 04 8B 55 08 8B 42 04 C1 E8 04 83 E0 01 83 E0 01 C1 E0 04 8B 4D FC 8B 51 04 83 E2 EF 0B D0 8B 45 FC 89 50 04 8B 4D 08 8B 51 04 C1 EA 05 83 E2 01 83 E2 01 C1 E2 05 8B 45 FC 8B 48 04 83 E1 DF 0B CA 8B 55 FC 89 4A 04 8B 45 08 8B 48 04 C1 E9 06 83 E1 01 83 E1 01 C1 E1 06 8B 55 FC 8B 42 04 24 BF 0B C1 8B 4D FC 89 41 04 8B 55 FC 8B 45 08 8B 08 89 0A 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_69_104_0 {
	meta:
		name = "??4DName@@QAEAAV0@PAV0@@Z"
		size = 198
		refs = "000d ?status@DName@@QBE?AW4DNameStatus@@XZ 0060 _heap 0067 ??2@YAPAXIAAVHeapManager@@H@Z 007f ??0pDNameNode@@QAE@PAVDName@@@Z 00b9 ??4DName@@QAEAAV0@W4DNameStatus@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D F8 8B 4D F8 E8 ?? ?? ?? ?? 85 C0 74 11 8B 4D F8 E8 ?? ?? ?? ?? 83 F8 02 0F 85 97 00 00 00 83 7D 08 00 0F 84 83 00 00 00 8B 45 F8 8B 48 04 83 E1 EF 8B 55 F8 89 4A 04 8B 45 F8 8B 48 04 83 E1 DF 8B 55 F8 89 4A 04 8B 45 F8 8B 48 04 83 E1 BF 8B 55 F8 89 4A 04 6A 00 68 ?? ?? ?? ?? 6A 0C E8 ?? ?? ?? ?? 83 C4 0C 89 45 FC 83 7D FC 00 74 11 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 89 45 F4 EB 07 C7 45 F4 00 00 00 00 8B 4D F8 8B 55 F4 89 11 8B 45 F8 83 38 00 75 12 8B 4D F8 8B 51 04 83 E2 F0 83 CA 03 8B 45 F8 89 50 04 EB 0A 6A 03 8B 4D F8 E8 ?? ?? ?? ?? 8B 45 F8 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_69_105_0 {
	meta:
		name = "??4DName@@QAEAAV0@W4DNameStatus@@@Z"
		size = 230
		refs = "0022 ?status@DName@@QBE?AW4DNameStatus@@XZ 008c _heap 0093 ??2@YAPAXIAAVHeapManager@@H@Z 00ab ??0DNameStatusNode@@QAE@W4DNameStatus@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D F8 83 7D 08 01 74 06 83 7D 08 03 75 31 8B 45 F8 C7 00 00 00 00 00 8B 4D F8 E8 ?? ?? ?? ?? 83 F8 03 74 16 8B 4D 08 83 E1 0F 8B 55 F8 8B 42 04 24 F0 0B C1 8B 4D F8 89 41 04 E9 97 00 00 00 8B 4D F8 E8 ?? ?? ?? ?? 85 C0 74 0D 8B 4D F8 E8 ?? ?? ?? ?? 83 F8 02 75 7E 8B 55 F8 8B 42 04 24 EF 8B 4D F8 89 41 04 8B 55 F8 8B 42 04 24 DF 8B 4D F8 89 41 04 8B 55 F8 8B 42 04 24 BF 8B 4D F8 89 41 04 6A 00 68 ?? ?? ?? ?? 6A 10 E8 ?? ?? ?? ?? 83 C4 0C 89 45 FC 83 7D FC 00 74 11 8B 55 08 52 8B 4D FC E8 ?? ?? ?? ?? 89 45 F4 EB 07 C7 45 F4 00 00 00 00 8B 45 F8 8B 4D F4 89 08 8B 55 F8 83 3A 00 75 12 8B 45 F8 8B 48 04 83 E1 F0 83 C9 03 8B 55 F8 89 4A 04 8B 45 F8 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_69_106_0 {
	meta:
		name = "?doPchar@DName@@AAEXPBDH@Z"
		size = 329
		refs = "000d ?status@DName@@QBE?AW4DNameStatus@@XZ 0039 ??4DName@@QAEAAV0@W4DNameStatus@@@Z 0082 _heap 0089 ??2@YAPAXIAAVHeapManager@@H@Z 00a3 ??0charNode@@QAE@D@Z 00fd ??0pcharNode@@QAE@PBDH@Z"
	strings:
		$1 = { 55 8B EC 83 EC 18 89 4D F4 8B 4D F4 E8 ?? ?? ?? ?? 83 F8 01 0F 84 29 01 00 00 8B 4D F4 E8 ?? ?? ?? ?? 83 F8 03 0F 84 18 01 00 00 8B 45 F4 83 38 00 74 0F 6A 03 8B 4D F4 E8 ?? ?? ?? ?? E9 01 01 00 00 83 7D 08 00 0F 84 E5 00 00 00 83 7D 0C 00 0F 84 DB 00 00 00 8B 4D 0C 89 4D F0 83 7D F0 00 74 08 83 7D F0 01 74 17 EB 6D 8B 55 F4 8B 42 04 24 F0 0C 03 8B 4D F4 89 41 04 E9 B0 00 00 00 6A 00 68 ?? ?? ?? ?? 6A 0C E8 ?? ?? ?? ?? 83 C4 0C 89 45 FC 83 7D FC 00 74 13 8B 55 08 8A 02 50 8B 4D FC E8 ?? ?? ?? ?? 89 45 EC EB 07 C7 45 EC 00 00 00 00 8B 4D F4 8B 55 EC 89 11 8B 45 F4 83 38 00 75 12 8B 4D F4 8B 51 04 83 E2 F0 83 CA 03 8B 45 F4 89 50 04 EB 58 6A 00 68 ?? ?? ?? ?? 6A 10 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F8 83 7D F8 00 74 15 8B 4D 0C 51 8B 55 08 52 8B 4D F8 E8 ?? ?? ?? ?? 89 45 E8 EB 07 C7 45 E8 00 00 00 00 8B 45 F4 8B 4D E8 89 08 8B 55 F4 83 3A 00 75 12 8B 45 F4 8B 48 04 83 E1 F0 83 C9 03 8B 55 F4 89 4A 04 EB 12 8B 45 F4 8B 48 04 83 E1 F0 83 C9 01 8B 55 F4 89 4A 04 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_69_107_0 {
	meta:
		name = "?isFull@Replicator@@QBEHXZ"
		size = 24
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 33 C9 83 38 09 0F 94 C1 8B C1 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_108_0 {
	meta:
		name = "??0Replicator@@QAE@XZ"
		size = 49
		refs = "0010 ??0DName@@QAE@W4DNameStatus@@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 6A 03 8B 4D FC 83 C1 2C E8 ?? ?? ?? ?? 6A 01 8B 4D FC 83 C1 34 E8 ?? ?? ?? ?? 8B 45 FC C7 00 FF FF FF FF 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_109_0 {
	meta:
		name = "??YReplicator@@QAEAAV0@ABVDName@@@Z"
		size = 132
		refs = "000d ?isFull@Replicator@@QBEHXZ 0019 ?isEmpty@DName@@QBEHXZ 0024 _heap 002b ??2@YAPAXIAAVHeapManager@@H@Z 0043 ??0DName@@QAE@ABV0@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 89 4D F4 8B 4D F4 E8 ?? ?? ?? ?? 85 C0 75 66 8B 4D 08 E8 ?? ?? ?? ?? 85 C0 75 5A 6A 00 68 ?? ?? ?? ?? 6A 08 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F8 83 7D F8 00 74 11 8B 45 08 50 8B 4D F8 E8 ?? ?? ?? ?? 89 45 F0 EB 07 C7 45 F0 00 00 00 00 8B 4D F0 89 4D FC 83 7D FC 00 74 1C 8B 55 F4 8B 02 83 C0 01 8B 4D F4 89 01 8B 55 F4 8B 02 8B 4D F4 8B 55 FC 89 54 81 04 8B 45 F4 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_69_110_0 {
	meta:
		name = "??AReplicator@@QBEABVDName@@H@Z"
		size = 69
	strings:
		$1 = { 55 8B EC 51 89 4D FC 83 7D 08 00 7C 06 83 7D 08 09 7E 08 8B 45 FC 83 C0 2C EB 24 8B 45 FC 83 38 FF 74 0A 8B 4D FC 8B 55 08 3B 11 7E 08 8B 45 FC 83 C0 34 EB 0A 8B 45 08 8B 4D FC 8B 44 81 04 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_69_111_0 {
	meta:
		name = "??0DNameNode@@IAE@XZ"
		size = 33
		refs = "000c ??_7DNameNode@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC C7 41 04 00 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_112_0 {
	meta:
		name = "?nextNode@DNameNode@@QBEPAV1@XZ"
		size = 17
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 40 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_113_0 {
	meta:
		name = "?clone@DNameNode@@QAEPAV1@XZ"
		size = 116
		refs = "000c _heap 0013 ??2@YAPAXIAAVHeapManager@@H@Z 0045 ??0DName@@QAE@PAVDNameNode@@@Z 005d ??0pDNameNode@@QAE@PAVDName@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 14 89 4D F4 6A 00 68 ?? ?? ?? ?? 6A 0C E8 ?? ?? ?? ?? 83 C4 0C 89 45 FC 83 7D FC 00 74 43 6A 00 68 ?? ?? ?? ?? 6A 08 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F8 83 7D F8 00 74 11 8B 45 F4 50 8B 4D F8 E8 ?? ?? ?? ?? 89 45 F0 EB 07 C7 45 F0 00 00 00 00 8B 4D F0 51 8B 4D FC E8 ?? ?? ?? ?? 89 45 EC EB 07 C7 45 EC 00 00 00 00 8B 45 EC 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_114_0 {
	meta:
		name = "??0DName@@QAE@PAVDNameNode@@@Z"
		size = 80
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 4D 08 89 08 8B 55 FC 8B 42 04 24 F0 8B 4D FC 89 41 04 8B 55 FC 8B 42 04 24 EF 8B 4D FC 89 41 04 8B 55 FC 8B 42 04 24 DF 8B 4D FC 89 41 04 8B 55 FC 8B 42 04 24 BF 8B 4D FC 89 41 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_69_115_0 {
	meta:
		name = "??YDNameNode@@QAEAAV0@PAV0@@Z"
		size = 84
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 83 7D 08 00 74 3C 8B 45 F8 83 78 04 00 74 2A 8B 4D F8 8B 51 04 89 55 FC EB 09 8B 45 FC 8B 48 04 89 4D FC 8B 55 FC 83 7A 04 00 74 02 EB EC 8B 45 FC 8B 4D 08 89 48 04 EB 09 8B 55 F8 8B 45 08 89 42 04 8B 45 F8 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_69_116_0 {
	meta:
		name = "??0charNode@@QAE@D@Z"
		size = 42
		refs = "000b ??0DNameNode@@IAE@XZ 0014 ??_7charNode@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC 8A 55 08 88 51 08 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_69_117_0 {
	meta:
		name = "?length@charNode@@UBEHXZ"
		size = 16
	strings:
		$1 = { 55 8B EC 51 89 4D FC B8 01 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_118_0 {
	meta:
		name = "?getLastChar@charNode@@UBEDXZ"
		size = 17
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8A 40 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_119_0 {
	meta:
		name = "?getString@charNode@@UBEPADPADH@Z"
		size = 48
	strings:
		$1 = { 55 8B EC 51 89 4D FC 83 7D 08 00 74 13 83 7D 0C 00 74 0D 8B 45 08 8B 4D FC 8A 51 08 88 10 EB 07 C7 45 08 00 00 00 00 8B 45 08 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_69_120_0 {
	meta:
		name = "??0pcharNode@@QAE@PBDH@Z"
		size = 168
		refs = "000d ??0DNameNode@@IAE@XZ 0016 ??_7pcharNode@@6B@ 002b ?strlen@@YAIPBD@Z 0044 _heap 004d ??2@YAPAXIAAVHeapManager@@H@Z 0082 ?strncpy@@YAPADPADPBDI@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 8B 4D F8 E8 ?? ?? ?? ?? 8B 45 F8 C7 00 ?? ?? ?? ?? 83 7D 0C 00 75 15 83 7D 08 00 74 0F 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 0C 83 7D 0C 00 74 50 83 7D 08 00 74 4A 6A 00 68 ?? ?? ?? ?? 8B 55 0C 52 E8 ?? ?? ?? ?? 83 C4 0C 89 45 FC 8B 45 F8 8B 4D FC 89 48 08 8B 55 F8 8B 45 0C 89 42 0C 8B 4D F8 83 79 08 00 74 17 8B 55 0C 52 8B 45 08 50 8B 4D F8 8B 51 08 52 E8 ?? ?? ?? ?? 83 C4 0C EB 14 8B 45 F8 C7 40 08 00 00 00 00 8B 4D F8 C7 41 0C 00 00 00 00 8B 45 F8 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_69_121_0 {
	meta:
		name = "?length@pcharNode@@UBEHXZ"
		size = 17
		altNames = "?length@DNameStatusNode@@UBEHXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 40 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_122_0 {
	meta:
		name = "?getLastChar@pcharNode@@UBEDXZ"
		size = 50
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 83 78 0C 00 74 15 8B 4D FC 8B 51 0C 8B 45 FC 8B 48 08 8A 54 11 FF 88 55 FB EB 04 C6 45 FB 00 8A 45 FB 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_123_0 {
	meta:
		name = "?getString@pcharNode@@UBEPADPADH@Z"
		size = 98
		refs = "000d ?length@pcharNode@@UBEHXZ 0046 ?strncpy@@YAPADPADPBDI@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 39 45 0C 7E 0B 8B 4D FC E8 ?? ?? ?? ?? 89 45 0C 8B 45 FC 83 78 08 00 74 28 83 7D 08 00 74 22 83 7D 0C 00 74 1C 8B 4D 0C 51 8B 55 FC 8B 42 08 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F8 EB 07 C7 45 F8 00 00 00 00 8B 45 F8 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_69_124_0 {
	meta:
		name = "??0pDNameNode@@QAE@PAVDName@@@Z"
		size = 91
		refs = "000d ??0DNameNode@@IAE@XZ 0016 ??_7pDNameNode@@6B@ 0024 ?status@DName@@QBE?AW4DNameStatus@@XZ"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC C7 00 ?? ?? ?? ?? 83 7D 08 00 74 23 8B 4D 08 E8 ?? ?? ?? ?? 83 F8 01 74 0D 8B 4D 08 E8 ?? ?? ?? ?? 83 F8 03 75 09 C7 45 F8 00 00 00 00 EB 06 8B 4D 08 89 4D F8 8B 55 FC 8B 45 F8 89 42 08 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_69_125_0 {
	meta:
		name = "?length@pDNameNode@@UBEHXZ"
		size = 48
		refs = "0019 ?length@DName@@QBEHXZ"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 83 78 08 00 74 10 8B 4D FC 8B 49 08 E8 ?? ?? ?? ?? 89 45 F8 EB 07 C7 45 F8 00 00 00 00 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_126_0 {
	meta:
		name = "?getLastChar@pDNameNode@@UBEDXZ"
		size = 45
		refs = "0019 ?getLastChar@DName@@QBEDXZ"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 83 78 08 00 74 10 8B 4D FC 8B 49 08 E8 ?? ?? ?? ?? 88 45 FB EB 04 C6 45 FB 00 8A 45 FB 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_127_0 {
	meta:
		name = "?getString@pDNameNode@@UBEPADPADH@Z"
		size = 70
		refs = "002d ?getString@DName@@QBEPADPADH@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 83 78 08 00 74 24 83 7D 08 00 74 1E 83 7D 0C 00 74 18 8B 4D 0C 51 8B 55 08 52 8B 45 FC 8B 48 08 E8 ?? ?? ?? ?? 89 45 F8 EB 07 C7 45 F8 00 00 00 00 8B 45 F8 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_69_128_0 {
	meta:
		name = "??0DNameStatusNode@@QAE@W4DNameStatus@@@Z"
		size = 64
		refs = "000b ??0DNameNode@@IAE@XZ 0014 ??_7DNameStatusNode@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC 8B 55 08 89 51 08 8B 45 FC 33 C9 83 78 08 02 0F 95 C1 49 83 E1 04 8B 55 FC 89 4A 0C 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_69_130_0 {
	meta:
		name = "?getLastChar@DNameStatusNode@@UBEDXZ"
		size = 28
		refs = "0014 ??_C@_04NODD@?5?$DP?$DP?5?$AA@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 83 78 08 02 0F 95 C0 48 22 05 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_131_0 {
	meta:
		name = "?getString@DNameStatusNode@@UBEPADPADH@Z"
		size = 96
		refs = "000d ?length@DNameStatusNode@@UBEHXZ 003b ??_C@_04NODD@?5?$DP?$DP?5?$AA@ 0044 ?strncpy@@YAPADPADPBDI@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 39 45 0C 7E 0B 8B 4D FC E8 ?? ?? ?? ?? 89 45 0C 8B 45 FC 83 78 08 02 75 26 83 7D 08 00 74 20 83 7D 0C 00 74 1A 8B 4D 0C 51 68 ?? ?? ?? ?? 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F8 EB 07 C7 45 F8 00 00 00 00 8B 45 F8 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_69_132_0 {
	meta:
		name = "?strlen@@YAIPBD@Z"
		size = 50
	strings:
		$1 = { 55 8B EC 51 C7 45 FC 00 00 00 00 EB 09 8B 45 08 83 C0 01 89 45 08 8B 4D 08 0F BE 11 85 D2 74 0B 8B 45 FC 83 C0 01 89 45 FC EB E2 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_133_0 {
	meta:
		name = "?strncpy@@YAPADPADPBDI@Z"
		size = 74
	strings:
		$1 = { 55 8B EC 51 8B 45 08 89 45 FC EB 1B 8B 4D FC 83 C1 01 89 4D FC 8B 55 0C 83 C2 01 89 55 0C 8B 45 10 83 E8 01 89 45 10 83 7D 10 00 74 16 8B 4D FC 8B 55 0C 8A 02 88 01 8B 4D FC 0F BE 11 85 D2 74 02 EB C9 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_70_0_0 {
	meta:
		name = "__wexecvpe"
		size = 748
		refs = "0017 ??_C@_0BB@COCE@filename?5?$CB?$DN?5NULL?$AA@ 0020 ??_C@_09PKLP@execvpe?4c?$AA@ 0027 __CrtDbgReport 0047 ??_C@_0BG@GALO@?$CKfilename?5?$CB?$DN?5_T?$CI?8?20?8?$CJ?$AA@ 0071 ??_C@_0BC@DJDH@argvector?5?$CB?$DN?5NULL?$AA@ 009d ??_C@_0BD@DPK@?$CKargvector?5?$CB?$DN?5NULL?$AA@ 00cf ??_C@_0BI@GGEG@?$CK?$CKargvector?5?$CB?$DN?5_T?$CI?8?20?8?$CJ?$AA@ 00ff __wexecve 0108 _errno 0116 _wcschr 014e ??_C@_19KDPP@?$AAP?$AAA?$AAT?$AAH?$AA?$AA@ 0153 __wgetenv 0177 __malloc_dbg 0211 ??_C@_13HMCP@?$AA?2?$AA?$AA@ 021a _wcscat 0226 _wcslen 02db __free_dbg"
	strings:
		$1 = { 55 8B EC 83 EC 10 53 56 57 C7 45 F4 00 00 00 00 83 7D 08 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 49 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D6 8B 4D 08 33 D2 66 8B 11 85 D2 75 1E 68 ?? ?? ?? ?? 6A 00 6A 4A 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D0 83 7D 0C 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 4B 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D6 8B 55 0C 83 3A 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 4C 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D4 8B 4D 0C 8B 11 33 C0 66 8B 02 85 C0 75 1E 68 ?? ?? ?? ?? 6A 00 6A 4D 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 CE 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 83 3D ?? ?? ?? ?? 02 75 54 6A 5C 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 42 6A 2F 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 30 8B 4D 08 33 D2 66 8B 11 85 D2 74 0E 8B 45 08 33 C9 66 8B 48 02 83 F9 3A 74 16 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 89 45 F8 83 7D F8 00 75 05 E9 66 01 00 00 6A 5A 68 ?? ?? ?? ?? 6A 02 68 08 02 00 00 E8 ?? ?? ?? ?? 83 C4 10 89 45 F4 8B 55 F4 89 55 FC 83 7D FC 00 75 05 E9 3C 01 00 00 8B 45 F8 33 C9 66 8B 08 85 C9 74 3B 8B 55 F8 33 C0 66 8B 02 83 F8 3B 74 2E 8B 4D F4 81 C1 08 04 00 00 39 4D FC 73 20 8B 55 FC 8B 45 F8 66 8B 08 66 89 0A 8B 55 FC 83 C2 02 89 55 FC 8B 45 F8 83 C0 02 89 45 F8 EB B9 8B 4D FC 66 C7 01 00 00 8B 55 FC 83 EA 02 89 55 FC 8B 45 FC 89 45 F0 8B 4D F4 89 4D FC 8B 55 F0 33 C0 66 8B 02 83 F8 5C 74 1E 8B 4D F0 33 D2 66 8B 11 83 FA 2F 74 11 68 ?? ?? ?? ?? 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B F0 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 03 F0 81 FE 04 01 00 00 73 12 8B 45 08 50 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 EB 02 EB 75 8B 55 10 52 8B 45 0C 50 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 0C 83 3D ?? ?? ?? ?? 02 74 38 8B 55 FC 33 C0 66 8B 02 83 F8 5C 74 0D 8B 4D FC 33 D2 66 8B 11 83 FA 2F 75 1C 8B 45 FC 33 C9 66 8B 48 02 83 F9 5C 74 10 8B 55 FC 33 C0 66 8B 42 02 83 F8 2F 74 02 EB 20 8B 4D F8 33 D2 66 8B 11 85 D2 74 14 8B 45 F8 8B 4D F8 83 C1 02 89 4D F8 85 C0 0F 85 C4 FE FF FF 83 7D F4 00 74 0E 6A 02 8B 55 F4 52 E8 ?? ?? ?? ?? 83 C4 08 83 C8 FF 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_71_0_0 {
	meta:
		name = "__fcloseall"
		size = 172
		refs = "0024 __nstream 002e ___piob 005e _fclose 0089 __free_dbg"
	strings:
		$1 = { 55 8B EC 83 EC 08 C7 45 FC 00 00 00 00 C7 45 F8 03 00 00 00 EB 09 8B 45 F8 83 C0 01 89 45 F8 8B 4D F8 3B 0D ?? ?? ?? ?? 7D 7B 8B 55 F8 A1 ?? ?? ?? ?? 83 3C 90 00 74 68 8B 4D F8 8B 15 ?? ?? ?? ?? 8B 04 8A 8B 48 0C 81 E1 83 00 00 00 85 C9 74 22 8B 55 F8 A1 ?? ?? ?? ?? 8B 0C 90 51 E8 ?? ?? ?? ?? 83 C4 04 83 F8 FF 74 09 8B 55 FC 83 C2 01 89 55 FC 83 7D F8 14 7C 27 6A 02 8B 45 F8 8B 0D ?? ?? ?? ?? 8B 14 81 52 E8 ?? ?? ?? ?? 83 C4 08 8B 45 F8 8B 0D ?? ?? ?? ?? C7 04 81 00 00 00 00 E9 71 FF FF FF 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_72_0_0 {
	meta:
		name = "__mbslen"
		size = 118
		refs = "0006 ___ismbcodepage 0012 _strlen 004c __mbctype"
	strings:
		$1 = { 55 8B EC 51 83 3D ?? ?? ?? ?? 00 75 0E 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 EB 57 C7 45 FC 00 00 00 00 EB 12 8B 4D FC 83 C1 01 89 4D FC 8B 55 08 83 C2 01 89 55 08 8B 45 08 33 C9 8A 08 85 C9 74 2E 8B 55 08 33 C0 8A 02 33 C9 8A 88 ?? ?? ?? ?? 83 E1 04 85 C9 74 16 8B 55 08 83 C2 01 89 55 08 8B 45 08 33 C9 8A 08 85 C9 75 02 EB 02 EB B5 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_73_0_0 {
	meta:
		name = "_frexp"
		size = 250
		refs = "0011 __ctrlfp 0045 __sptype 0069 __d_ind 0081 __except1 0099 __handle_qnan1 00ab __real@8@3fff8000000000000000 00d8 __decomp"
	strings:
		$1 = { 55 8B EC 83 EC 10 68 FF FF 00 00 68 3F 13 00 00 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 8B 45 0E 25 FF FF 00 00 25 F0 7F 00 00 3D F0 7F 00 00 0F 85 98 00 00 00 8B 4D 10 C7 01 FF FF FF FF 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 F0 83 7D F0 00 7E 4D 83 7D F0 02 7E 08 83 7D F0 03 74 29 EB 3F 8B 4D FC 51 8B 15 ?? ?? ?? ?? 52 A1 ?? ?? ?? ?? 50 8B 4D 0C 51 8B 55 08 52 6A 17 6A 08 E8 ?? ?? ?? ?? 83 C4 1C EB 6C 8B 45 FC 50 8B 4D 0C 51 8B 55 08 52 6A 17 E8 ?? ?? ?? ?? 83 C4 10 EB 54 8B 45 FC 50 DD 45 08 DC 05 ?? ?? ?? ?? 83 EC 08 DD 1C 24 8B 4D 0C 51 8B 55 08 52 6A 17 6A 08 E8 ?? ?? ?? ?? 83 C4 1C EB 2B 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C DD 5D F4 68 FF FF 00 00 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 DD 45 F4 8B E5 5D C3 }
	condition:
		$1
}

rule file_74_0_0 {
	meta:
		name = "__commit"
		size = 174
		refs = "0009 __nhandle 001e ___pioinfo 0030 _errno 0061 __get_osfhandle 006b __imp__FlushFileBuffers@4 0075 __imp__GetLastError@0 0092 __doserrno"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 3B 05 ?? ?? ?? ?? 73 1F 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F 8B 04 8D ?? ?? ?? ?? 0F BE 4C D0 04 83 E1 01 85 C9 75 0F C7 05 ?? ?? ?? ?? 09 00 00 00 83 C8 FF EB 6D 8B 55 08 C1 FA 05 8B 45 08 83 E0 1F 8B 0C 95 ?? ?? ?? ?? 0F BE 54 C1 04 83 E2 01 85 D2 74 3A 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 50 FF 15 ?? ?? ?? ?? 85 C0 75 0B FF 15 ?? ?? ?? ?? 89 45 FC EB 07 C7 45 FC 00 00 00 00 83 7D FC 00 75 02 EB 1A 8B 4D FC 89 0D ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 09 00 00 00 C7 45 FC FF FF FF FF 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_75_0_0 {
	meta:
		name = "_fgetpos"
		size = 57
		refs = "0009 __ftelli64"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 89 01 89 51 04 8B 55 0C 89 55 FC 8B 45 FC 8B 4D FC 8B 10 23 51 04 83 FA FF 74 04 33 C0 EB 03 83 C8 FF 8B E5 5D C3 }
	condition:
		$1
}

rule file_76_0_0 {
	meta:
		name = "_mainCRTStartup"
		size = 304
		refs = "0006 $T17376 000b __except_handler3 0011 __except_list 0028 __imp__GetVersion@0 002d __osver 003f __winminor 0051 __winmajor 0066 __winver 007f __heap_init 008d _fast_error_exit 009c __ioinit 00a2 __imp__GetCommandLineA@0 00a7 __acmdln 00ac ___crtGetEnvironmentStringsA 00b1 __aenvptr 00b6 __setargv 00bb __setenvp 00c0 __cinit 00c6 __environ 00cc ___initenv 00d8 ___argv 00df ___argc 00e5 _main 00f4 _exit 010b __XcptFilter 011b __exit"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 C4 F0 53 56 57 89 65 E8 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? C1 E8 08 25 FF 00 00 00 A3 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 81 E1 FF 00 00 00 89 0D ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? C1 E2 08 03 15 ?? ?? ?? ?? 89 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? C1 E8 10 25 FF FF 00 00 A3 ?? ?? ?? ?? 6A 00 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 0A 6A 1C E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 E8 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 52 A1 ?? ?? ?? ?? 50 8B 0D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 0C 89 45 E4 8B 55 E4 52 E8 ?? ?? ?? ?? 8B 45 EC 8B 08 8B 11 89 55 E0 8B 45 EC 50 8B 4D E0 51 E8 ?? ?? ?? ?? 83 C4 08 C3 8B 65 E8 8B 55 E0 52 E8 ?? ?? ?? ?? 8B 4D F0 64 89 0D ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_76_1_0 {
	meta:
		name = "__amsg_exit"
		size = 45
		refs = "0005 ___error_mode 000d __FF_MSGBANNER 0016 __NMSG_WRITE 0024 __aexit_rtn"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? 02 74 05 E8 ?? ?? ?? ?? 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 68 FF 00 00 00 FF 15 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_76_2_0 {
	meta:
		name = "_fast_error_exit"
		size = 42
		refs = "0005 ___error_mode 000d __FF_MSGBANNER 0016 __NMSG_WRITE 0024 __imp__ExitProcess@4"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? 02 74 05 E8 ?? ?? ?? ?? 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 68 FF 00 00 00 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_77_0_0 {
	meta:
		name = "_strcspn"
		size = 20
		altNames = "_strpbrk _strspn"
	strings:
		$1 = { 55 8B EC 56 33 C0 50 50 50 50 50 50 50 50 8B 55 0C 8D 49 00 }
	condition:
		$1
}

rule file_78_0_0 {
	meta:
		name = "__87except"
		size = 380
		refs = "0034 $L525 0091 __handle_exc 0103 __raise_exc 0116 __ctrlfp 012e __matherr_flag 013a __matherr 0151 __set_errno 015c $L504 0160 $L507 0164 $L505 0168 $L506 0170 $L510 0174 $L509 0178 $L508"
	strings:
		$1 = { 55 8B EC 83 EC 70 8B 45 10 33 C9 66 8B 08 89 4D F0 8D 55 F0 89 55 F4 8B 45 0C 8B 08 89 4D 94 8B 55 94 83 EA 01 89 55 94 83 7D 94 07 77 40 8B 45 94 FF 24 85 ?? ?? ?? ?? C7 45 FC 08 00 00 00 EB 34 C7 45 FC 11 00 00 00 EB 2B C7 45 FC 12 00 00 00 EB 22 C7 45 FC 04 00 00 00 EB 19 C7 45 FC 10 00 00 00 EB 10 8B 4D 0C C7 01 01 00 00 00 C7 45 FC 00 00 00 00 83 7D FC 00 0F 84 8B 00 00 00 8B 55 F4 8B 02 50 8B 4D 0C 83 C1 18 51 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8B 45 08 89 45 90 83 7D 90 10 74 0E 83 7D 90 16 74 08 83 7D 90 1D 74 02 EB 26 8B 4D D0 83 C9 01 89 4D D0 8B 55 D0 83 E2 E1 83 CA 02 89 55 D0 8B 45 0C 8B 48 10 89 4D C0 8B 50 14 89 55 C4 EB 08 8B 45 D0 24 FE 89 45 D0 8B 4D 0C 83 C1 18 51 8B 55 0C 83 C2 08 52 8B 45 08 50 8B 4D FC 51 8B 55 F4 52 8D 45 98 50 E8 ?? ?? ?? ?? 83 C4 18 68 FF FF 00 00 8B 4D F4 8B 11 52 E8 ?? ?? ?? ?? 83 C4 08 C7 45 F8 00 00 00 00 8B 45 0C 83 38 08 74 18 83 3D ?? ?? ?? ?? 00 75 0F 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 F8 83 7D F8 00 75 0E 8B 55 0C 8B 02 50 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_79_0_0 {
	meta:
		name = "_localtime"
		size = 608
		refs = "0016 ___tzset 0037 __timezone 0043 _gmtime 004f __daylight 005b __isindst 006b __dstbias"
	strings:
		$1 = { 55 8B EC 83 EC 08 8B 45 08 83 38 00 7D 07 33 C0 E9 47 02 00 00 E8 ?? ?? ?? ?? 8B 4D 08 81 39 80 F4 03 00 7E 6B 8B 55 08 81 3A 7F 0B FC 7F 7D 60 8B 45 08 8B 08 2B 0D ?? ?? ?? ?? 89 4D FC 8D 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 F8 83 3D ?? ?? ?? ?? 00 74 35 8B 45 F8 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 25 8B 4D FC 2B 0D ?? ?? ?? ?? 89 4D FC 8D 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 F8 8B 45 F8 C7 40 20 01 00 00 00 E9 C9 01 00 00 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 F8 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 17 A1 ?? ?? ?? ?? 03 05 ?? ?? ?? ?? 8B 4D F8 8B 11 2B D0 89 55 FC EB 0E 8B 45 F8 8B 08 2B 0D ?? ?? ?? ?? 89 4D FC 8B 45 FC 99 B9 3C 00 00 00 F7 F9 8B 45 F8 89 10 8B 4D F8 83 39 00 7D 16 8B 55 F8 8B 02 83 C0 3C 8B 4D F8 89 01 8B 55 FC 83 EA 3C 89 55 FC 8B 45 FC 99 B9 3C 00 00 00 F7 F9 8B 55 F8 8B 4A 04 03 C8 89 4D FC 8B 45 FC 99 B9 3C 00 00 00 F7 F9 8B 45 F8 89 50 04 8B 4D F8 83 79 04 00 7D 18 8B 55 F8 8B 42 04 83 C0 3C 8B 4D F8 89 41 04 8B 55 FC 83 EA 3C 89 55 FC 8B 45 FC 99 B9 3C 00 00 00 F7 F9 8B 55 F8 8B 4A 08 03 C8 89 4D FC 8B 45 FC 99 B9 18 00 00 00 F7 F9 8B 45 F8 89 50 08 8B 4D F8 83 79 08 00 7D 18 8B 55 F8 8B 42 08 83 C0 18 8B 4D F8 89 41 08 8B 55 FC 83 EA 18 89 55 FC 8B 45 FC 99 B9 18 00 00 00 F7 F9 89 45 FC 83 7D FC 00 7E 37 8B 55 F8 8B 42 18 03 45 FC 99 B9 07 00 00 00 F7 F9 8B 45 F8 89 50 18 8B 4D F8 8B 51 0C 03 55 FC 8B 45 F8 89 50 0C 8B 4D F8 8B 51 1C 03 55 FC 8B 45 F8 89 50 1C EB 7C 83 7D FC 00 7D 76 8B 4D F8 8B 51 18 8B 45 FC 8D 44 02 07 99 B9 07 00 00 00 F7 F9 8B 45 F8 89 50 18 8B 4D F8 8B 51 0C 03 55 FC 8B 45 F8 89 50 0C 8B 4D F8 83 79 0C 00 7F 34 8B 55 F8 8B 42 0C 83 C0 1F 8B 4D F8 89 41 0C 8B 55 F8 C7 42 1C 6C 01 00 00 8B 45 F8 C7 40 10 0B 00 00 00 8B 4D F8 8B 51 14 83 EA 01 8B 45 F8 89 50 14 EB 0F 8B 4D F8 8B 51 1C 03 55 FC 8B 45 F8 89 50 1C 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_83_0_0 {
	meta:
		name = "__handle_qnan1"
		size = 84
		refs = "0005 __matherr_flag 002b __umatherr 0036 _errno 0048 __ctrlfp"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? 00 75 28 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 6A 00 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 6A 01 E8 ?? ?? ?? ?? 83 C4 24 EB 1E C7 05 ?? ?? ?? ?? 21 00 00 00 68 FF FF 00 00 8B 45 14 50 E8 ?? ?? ?? ?? 83 C4 08 DD 45 0C 5D C3 }
	condition:
		$1
}

rule file_83_1_0 {
	meta:
		name = "__handle_qnan2"
		size = 102
		refs = "0011 __matherr_flag 003b __umatherr 0046 _errno 0058 __ctrlfp"
	strings:
		$1 = { 55 8B EC 83 EC 08 DD 45 0C DC 45 14 DD 5D F8 83 3D ?? ?? ?? ?? 00 75 2C 8B 45 1C 50 8B 4D FC 51 8B 55 F8 52 8B 45 18 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 6A 01 E8 ?? ?? ?? ?? 83 C4 24 EB 1E C7 05 ?? ?? ?? ?? 21 00 00 00 68 FF FF 00 00 8B 55 1C 52 E8 ?? ?? ?? ?? 83 C4 08 DD 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_83_2_0 {
	meta:
		name = "__except1"
		size = 178
		refs = "0013 __handle_exc 003f __raise_exc 004b __errcode 0057 __matherr_flag 0085 __umatherr 0093 __set_errno 00a4 __ctrlfp"
	strings:
		$1 = { 55 8B EC 83 EC 5C 8B 45 20 50 8D 4D 18 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 28 8B 45 DC 24 FE 89 45 DC 8D 4D 18 51 8D 55 10 52 8B 45 0C 50 8B 4D 08 51 8D 55 20 52 8D 45 A4 50 E8 ?? ?? ?? ?? 83 C4 18 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 83 3D ?? ?? ?? ?? 00 75 30 83 7D FC 00 74 2A 8B 55 20 52 8B 45 1C 50 8B 4D 18 51 6A 00 6A 00 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 24 EB 20 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 68 FF FF 00 00 8B 4D 20 51 E8 ?? ?? ?? ?? 83 C4 08 DD 45 18 8B E5 5D C3 }
	condition:
		$1
}

rule file_83_3_0 {
	meta:
		name = "__except2"
		size = 206
		refs = "0013 __handle_exc 0057 __raise_exc 0063 __errcode 006f __matherr_flag 00a1 __umatherr 00af __set_errno 00c0 __ctrlfp"
	strings:
		$1 = { 55 8B EC 83 EC 5C 8B 45 28 50 8D 4D 20 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 40 8B 45 DC 0C 01 89 45 DC 8B 4D DC 83 E1 E1 83 C9 02 89 4D DC 8B 55 18 89 55 CC 8B 45 1C 89 45 D0 8D 4D 20 51 8D 55 10 52 8B 45 0C 50 8B 4D 08 51 8D 55 28 52 8D 45 A4 50 E8 ?? ?? ?? ?? 83 C4 18 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 83 3D ?? ?? ?? ?? 00 75 34 83 7D FC 00 74 2E 8B 55 28 52 8B 45 24 50 8B 4D 20 51 8B 55 1C 52 8B 45 18 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 24 EB 20 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 68 FF FF 00 00 8B 45 28 50 E8 ?? ?? ?? ?? 83 C4 08 DD 45 20 8B E5 5D C3 }
	condition:
		$1
}

rule file_83_4_0 {
	meta:
		name = "__raise_exc"
		size = 1217
		refs = "0172 __statfp 034a __clrfp 035c __imp__RaiseException@16 0402 $L17120 04b1 $L16924 04b5 $L16923 04b9 $L16922 04bd $L16921"
	strings:
		$1 = { 55 8B EC 83 EC 18 8B 45 08 C7 40 04 00 00 00 00 8B 4D 08 C7 41 08 00 00 00 00 8B 55 08 C7 42 0C 00 00 00 00 8B 45 10 83 E0 10 85 C0 74 16 C7 45 FC 8F 00 00 C0 8B 4D 08 8B 51 04 83 CA 01 8B 45 08 89 50 04 8B 4D 10 83 E1 02 85 C9 74 15 C7 45 FC 93 00 00 C0 8B 55 08 8B 42 04 0C 02 8B 4D 08 89 41 04 8B 55 10 83 E2 01 85 D2 74 16 C7 45 FC 91 00 00 C0 8B 45 08 8B 48 04 83 C9 04 8B 55 08 89 4A 04 8B 45 10 83 E0 04 85 C0 74 16 C7 45 FC 8E 00 00 C0 8B 4D 08 8B 51 04 83 CA 08 8B 45 08 89 50 04 8B 4D 10 83 E1 08 85 C9 74 15 C7 45 FC 90 00 00 C0 8B 55 08 8B 42 04 0C 10 8B 4D 08 89 41 04 8B 55 0C 8B 02 83 E0 01 F7 D8 1B C0 40 83 E0 01 C1 E0 04 8B 4D 08 8B 51 08 83 E2 EF 0B D0 8B 45 08 89 50 08 8B 4D 0C 8B 11 83 E2 04 F7 DA 1B D2 42 83 E2 01 C1 E2 03 8B 45 08 8B 48 08 83 E1 F7 0B CA 8B 55 08 89 4A 08 8B 45 0C 8B 08 83 E1 08 F7 D9 1B C9 41 83 E1 01 C1 E1 02 8B 55 08 8B 42 08 24 FB 0B C1 8B 4D 08 89 41 08 8B 55 0C 8B 02 83 E0 10 F7 D8 1B C0 40 83 E0 01 D1 E0 8B 4D 08 8B 51 08 83 E2 FD 0B D0 8B 45 08 89 50 08 8B 4D 0C 8B 11 83 E2 20 F7 DA 1B D2 42 83 E2 01 8B 45 08 8B 48 08 83 E1 FE 0B CA 8B 55 08 89 4A 08 E8 ?? ?? ?? ?? 89 45 F8 8B 45 F8 83 E0 01 85 C0 74 0F 8B 4D 08 8B 51 0C 83 CA 10 8B 45 08 89 50 0C 8B 4D F8 83 E1 04 85 C9 74 0E 8B 55 08 8B 42 0C 0C 08 8B 4D 08 89 41 0C 8B 55 F8 83 E2 08 85 D2 74 0F 8B 45 08 8B 48 0C 83 C9 04 8B 55 08 89 4A 0C 8B 45 F8 83 E0 10 85 C0 74 0F 8B 4D 08 8B 51 0C 83 CA 02 8B 45 08 89 50 0C 8B 4D F8 83 E1 20 85 C9 74 0E 8B 55 08 8B 42 0C 0C 01 8B 4D 08 89 41 0C 8B 55 0C 8B 02 25 00 0C 00 00 89 45 F4 81 7D F4 00 08 00 00 77 1A 81 7D F4 00 08 00 00 74 2B 83 7D F4 00 74 49 81 7D F4 00 04 00 00 74 2E EB 4B 81 7D F4 00 0C 00 00 74 02 EB 40 8B 4D 08 8B 11 83 CA 03 8B 45 08 89 10 EB 31 8B 4D 08 8B 11 83 E2 FC 83 CA 02 8B 45 08 89 10 EB 1F 8B 4D 08 8B 11 83 E2 FC 83 CA 01 8B 45 08 89 10 EB 0D 8B 4D 08 8B 11 83 E2 FC 8B 45 08 89 10 8B 4D 0C 8B 11 81 E2 00 03 00 00 89 55 F0 83 7D F0 00 74 35 81 7D F0 00 02 00 00 74 1A 81 7D F0 00 03 00 00 74 02 EB 31 8B 45 08 8B 08 83 E1 E3 8B 55 08 89 0A EB 22 8B 45 08 8B 08 83 E1 E3 83 C9 04 8B 55 08 89 0A EB 10 8B 45 08 8B 08 83 E1 E3 83 C9 08 8B 55 08 89 0A 8B 45 14 25 FF 0F 00 00 C1 E0 05 8B 4D 08 8B 11 81 E2 1F 00 FE FF 0B D0 8B 45 08 89 10 8B 4D 08 8B 51 20 83 CA 01 8B 45 08 89 50 20 8B 4D 08 8B 51 20 83 E2 E1 83 CA 02 8B 45 08 89 50 20 8B 4D 08 8B 55 18 8B 02 89 41 10 8B 52 04 89 51 14 8B 45 08 8B 48 50 83 C9 01 8B 55 08 89 4A 50 8B 45 08 8B 48 50 83 E1 E1 83 C9 02 8B 55 08 89 4A 50 8B 45 08 8B 4D 1C 8B 11 89 50 40 8B 49 04 89 48 44 E8 ?? ?? ?? ?? 8D 55 08 52 6A 01 6A 00 8B 45 FC 50 FF 15 ?? ?? ?? ?? 8B 4D 08 8B 51 08 C1 EA 04 83 E2 01 85 D2 74 0D 8B 45 0C 8B 08 83 E1 FE 8B 55 0C 89 0A 8B 45 08 8B 48 08 C1 E9 03 83 E1 01 85 C9 74 0C 8B 55 0C 8B 02 24 FB 8B 4D 0C 89 01 8B 55 08 8B 42 08 C1 E8 02 83 E0 01 85 C0 74 0D 8B 4D 0C 8B 11 83 E2 F7 8B 45 0C 89 10 8B 4D 08 8B 51 08 D1 EA 83 E2 01 85 D2 74 0D 8B 45 0C 8B 08 83 E1 EF 8B 55 0C 89 0A 8B 45 08 8B 48 08 83 E1 01 85 C9 74 0C 8B 55 0C 8B 02 24 DF 8B 4D 0C 89 01 8B 55 08 8B 02 83 E0 03 89 45 EC 83 7D EC 03 77 4D 8B 4D EC FF 24 8D ?? ?? ?? ?? 8B 55 0C 8B 02 80 E4 F3 80 CC 0C 8B 4D 0C 89 01 EB 31 8B 55 0C 8B 02 80 E4 F3 80 CC 08 8B 4D 0C 89 01 EB 1F 8B 55 0C 8B 02 80 E4 F3 80 CC 04 8B 4D 0C 89 01 EB 0D 8B 55 0C 8B 02 80 E4 F3 8B 4D 0C 89 01 8B 55 08 8B 02 C1 E8 02 83 E0 07 89 45 E8 83 7D E8 00 74 0E 83 7D E8 01 74 1A 83 7D E8 02 74 26 EB 31 8B 4D 0C 8B 11 80 E6 F3 80 CE 03 8B 45 0C 89 10 EB 1F 8B 4D 0C 8B 11 80 E6 F3 80 CE 02 8B 45 0C 89 10 EB 0D 8B 4D 0C 8B 11 80 E6 F3 8B 45 0C 89 10 8B 4D 08 8B 55 1C 8B 41 40 89 02 8B 49 44 89 4A 04 8B E5 5D C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_83_5_0 {
	meta:
		name = "__handle_exc"
		size = 882
		refs = "0026 __set_statfp 00d9 __real@8@00000000000000000000 00e6 __d_inf 013c __d_max 023a __decomp"
	strings:
		$1 = { 55 8B EC 83 EC 44 8B 45 08 83 E0 1F 89 45 FC 8B 4D 08 83 E1 08 85 C9 74 21 8B 55 10 83 E2 01 85 D2 74 17 6A 01 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 24 F7 89 45 FC E9 04 03 00 00 8B 4D 08 83 E1 04 85 C9 74 21 8B 55 10 83 E2 04 85 D2 74 17 6A 04 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 24 FB 89 45 FC E9 D9 02 00 00 8B 4D 08 83 E1 01 85 C9 0F 84 6E 01 00 00 8B 55 10 83 E2 08 85 D2 0F 84 60 01 00 00 6A 08 E8 ?? ?? ?? ?? 83 C4 04 8B 45 10 25 00 0C 00 00 89 45 E0 81 7D E0 00 08 00 00 77 21 81 7D E0 00 08 00 00 74 6D 83 7D E0 00 74 24 81 7D E0 00 04 00 00 0F 84 9A 00 00 00 E9 13 01 00 00 81 7D E0 00 0C 00 00 0F 84 C8 00 00 00 E9 01 01 00 00 8B 4D 0C DD 01 DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 75 13 8B 15 ?? ?? ?? ?? 89 55 D8 A1 ?? ?? ?? ?? 89 45 DC EB 0B DD 05 ?? ?? ?? ?? D9 E0 DD 5D D8 8B 4D 0C 8B 55 D8 89 11 8B 45 DC 89 41 04 E9 BE 00 00 00 8B 4D 0C DD 01 DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 75 13 8B 15 ?? ?? ?? ?? 89 55 D0 A1 ?? ?? ?? ?? 89 45 D4 EB 0B DD 05 ?? ?? ?? ?? D9 E0 DD 5D D0 8B 4D 0C 8B 55 D0 89 11 8B 45 D4 89 41 04 EB 7E 8B 4D 0C DD 01 DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 75 13 8B 15 ?? ?? ?? ?? 89 55 C8 A1 ?? ?? ?? ?? 89 45 CC EB 0B DD 05 ?? ?? ?? ?? D9 E0 DD 5D C8 8B 4D 0C 8B 55 C8 89 11 8B 45 CC 89 41 04 EB 3E 8B 4D 0C DD 01 DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 75 13 8B 15 ?? ?? ?? ?? 89 55 C0 A1 ?? ?? ?? ?? 89 45 C4 EB 0B DD 05 ?? ?? ?? ?? D9 E0 DD 5D C0 8B 4D 0C 8B 55 C0 89 11 8B 45 C4 89 41 04 8B 4D FC 83 E1 FE 89 4D FC E9 5D 01 00 00 8B 55 08 83 E2 02 85 D2 0F 84 4F 01 00 00 8B 45 10 83 E0 10 85 C0 0F 84 41 01 00 00 C7 45 F8 00 00 00 00 8B 4D 08 83 E1 10 85 C9 74 07 C7 45 F8 01 00 00 00 8B 55 0C DD 02 DC 1D ?? ?? ?? ?? DF E0 F6 C4 40 0F 85 F3 00 00 00 8D 45 E8 50 8B 4D 0C 8B 51 04 52 8B 01 50 E8 ?? ?? ?? ?? 83 C4 0C DD 5D F0 8B 4D E8 81 E9 00 06 00 00 89 4D EC 81 7D EC CE FB FF FF 7D 18 DD 45 F0 DC 0D ?? ?? ?? ?? DD 5D F0 C7 45 F8 01 00 00 00 E9 9D 00 00 00 DD 45 F0 DC 1D ?? ?? ?? ?? DF E0 F6 C4 01 74 09 C7 45 BC 01 00 00 00 EB 07 C7 45 BC 00 00 00 00 8B 55 BC 89 55 E4 66 8B 45 F6 66 25 0F 00 66 89 45 F6 66 8B 4D F6 80 C9 10 66 89 4D F6 EB 09 8B 55 EC 83 C2 01 89 55 EC 81 7D EC 03 FC FF FF 7D 3E 8B 45 F0 83 E0 01 85 C0 74 0D 83 7D F8 00 75 07 C7 45 F8 01 00 00 00 8B 4D F0 D1 E9 89 4D F0 8B 55 F4 83 E2 01 85 D2 74 0B 8B 45 F0 0D 00 00 00 80 89 45 F0 8B 4D F4 D1 E9 89 4D F4 EB B0 83 7D E4 00 74 08 DD 45 F0 D9 E0 DD 5D F0 8B 55 0C 8B 45 F0 89 02 8B 4D F4 89 4A 04 EB 07 C7 45 F8 01 00 00 00 83 7D F8 00 74 0A 6A 10 E8 ?? ?? ?? ?? 83 C4 04 8B 55 FC 83 E2 FD 89 55 FC 8B 45 08 83 E0 10 85 C0 74 1D 8B 4D 10 83 E1 20 85 C9 74 13 6A 20 E8 ?? ?? ?? ?? 83 C4 04 8B 55 FC 83 E2 EF 89 55 FC 33 C0 83 7D FC 00 0F 94 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_83_6_0 {
	meta:
		name = "__umatherr"
		size = 155
		refs = "000b __get_fname 004f __ctrlfp 005b __matherr 006b __set_errno"
	strings:
		$1 = { 55 8B EC 83 EC 20 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 E4 83 7D E4 00 74 5C 8B 4D 08 89 4D E0 8B 55 10 89 55 E8 8B 45 14 89 45 EC 8B 4D 18 89 4D F0 8B 55 1C 89 55 F4 8B 45 20 89 45 F8 8B 4D 24 89 4D FC 68 FF FF 00 00 8B 55 28 52 E8 ?? ?? ?? ?? 83 C4 08 8D 45 E0 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 0C 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 DD 45 F8 EB 20 68 FF FF 00 00 8B 55 28 52 E8 ?? ?? ?? ?? 83 C4 08 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 DD 45 20 8B E5 5D C3 }
	condition:
		$1
}

rule file_83_7_0 {
	meta:
		name = "__set_errno"
		size = 56
		refs = "0020 _errno"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 89 45 FC 83 7D FC 01 74 0E 83 7D FC 01 7E 1E 83 7D FC 03 7E 0E EB 16 C7 05 ?? ?? ?? ?? 21 00 00 00 EB 0A C7 05 ?? ?? ?? ?? 22 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_83_8_0 {
	meta:
		name = "__get_fname"
		size = 63
		refs = "0022 _?_names@?1??_get_fname@@9@9"
	strings:
		$1 = { 55 8B EC 51 C7 45 FC 00 00 00 00 EB 09 8B 45 FC 83 C0 01 89 45 FC 83 7D FC 1B 7D 1D 8B 4D FC 8B 14 CD ?? ?? ?? ?? 3B 55 08 75 0C 8B 45 FC 8B 04 C5 ?? ?? ?? ?? EB 04 EB D4 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_83_9_0 {
	meta:
		name = "__errcode"
		size = 113
	strings:
		$1 = { 55 8B EC 51 8B 45 08 83 E0 20 85 C0 74 09 C7 45 FC 05 00 00 00 EB 53 8B 4D 08 83 E1 08 85 C9 74 09 C7 45 FC 01 00 00 00 EB 40 8B 55 08 83 E2 04 85 D2 74 09 C7 45 FC 02 00 00 00 EB 2D 8B 45 08 83 E0 01 85 C0 74 09 C7 45 FC 03 00 00 00 EB 1A 8B 4D 08 83 E1 02 85 C9 74 09 C7 45 FC 04 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_84_0_0 {
	meta:
		name = "__setenvp"
		size = 329
		refs = "0008 ___mbctype_initialized 0010 ___initmbctable 001c __aenvptr 0046 _strlen 005c ??_C@_09IGKD@stdenvp?4c?$AA@ 006e __malloc_dbg 007d __environ 008d __amsg_exit 0105 _strcpy 0121 __free_dbg 013d ___env_initialized"
	strings:
		$1 = { 55 8B EC 83 EC 10 83 3D ?? ?? ?? ?? 00 75 05 E8 ?? ?? ?? ?? C7 45 F8 00 00 00 00 A1 ?? ?? ?? ?? 89 45 FC 8B 4D FC 0F BE 11 85 D2 74 2C 8B 45 FC 0F BE 08 83 F9 3D 74 09 8B 55 F8 83 C2 01 89 55 F8 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D FC 8D 54 01 01 89 55 FC EB CA 6A 6D 68 ?? ?? ?? ?? 6A 02 8B 45 F8 8D 0C 85 04 00 00 00 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 F4 8B 55 F4 89 15 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 75 0A 6A 09 E8 ?? ?? ?? ?? 83 C4 04 A1 ?? ?? ?? ?? 89 45 FC EB 09 8B 4D FC 03 4D F0 89 4D FC 8B 55 FC 0F BE 02 85 C0 74 66 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 83 C0 01 89 45 F0 8B 55 FC 0F BE 02 83 F8 3D 74 47 6A 79 68 ?? ?? ?? ?? 6A 02 8B 4D F0 51 E8 ?? ?? ?? ?? 83 C4 10 8B 55 F4 89 02 8B 45 F4 83 38 00 75 0A 6A 09 E8 ?? ?? ?? ?? 83 C4 04 8B 4D FC 51 8B 55 F4 8B 02 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4D F4 83 C1 04 89 4D F4 EB 87 6A 02 8B 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 08 C7 05 ?? ?? ?? ?? 00 00 00 00 8B 45 F4 C7 00 00 00 00 00 C7 05 ?? ?? ?? ?? 01 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_86_0_0 {
	meta:
		name = "_wcsncmp"
		size = 102
	strings:
		$1 = { 55 8B EC 83 7D 10 00 75 04 33 C0 EB 57 8B 45 10 83 E8 01 89 45 10 83 7D 10 00 74 34 8B 4D 08 33 D2 66 8B 11 85 D2 74 28 8B 45 08 33 C9 66 8B 08 8B 55 0C 33 C0 66 8B 02 3B C8 75 14 8B 4D 08 83 C1 02 89 4D 08 8B 55 0C 83 C2 02 89 55 0C EB BD 8B 45 08 33 C9 66 8B 08 8B C1 8B 55 0C 33 C9 66 8B 0A 2B C1 5D C3 }
	condition:
		$1
}

rule file_87_0_0 {
	meta:
		name = "__wcsrev"
		size = 117
	strings:
		$1 = { 55 8B EC 83 EC 0C 8B 45 08 89 45 F8 8B 4D 08 89 4D F4 8B 55 08 33 C0 66 8B 02 8B 4D 08 83 C1 02 89 4D 08 85 C0 74 02 EB E9 8B 55 08 83 EA 04 89 55 08 8B 45 F4 3B 45 08 73 34 8B 4D F4 66 8B 11 66 89 55 FC 8B 45 F4 8B 4D 08 66 8B 11 66 89 10 8B 45 F4 83 C0 02 89 45 F4 8B 4D 08 66 8B 55 FC 66 89 11 8B 45 08 83 E8 02 89 45 08 EB C4 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_88_0_0 {
	meta:
		name = "__popen"
		size = 1271
		refs = "0074 __pipe 00cb __imp__GetCurrentProcess@0 00e1 ___pioinfo 0109 __imp__DuplicateHandle@28 0189 __imp__CloseHandle@4 0192 __free_osfhnd 01a2 __set_osfhnd 01e8 __close 0207 __fdopen 021f _idtab 02ba ??_C@_07KFDO@COMSPEC?$AA@ 02bf _getenv 02d6 ??_C@_02JMK@?1c?$AA@ 02e5 __spawnl 02f7 _errno 0309 __osver 031a ??_C@_0M@IPJP@command?4com?$AA@ 0323 ??_C@_07OOMJ@cmd?4exe?$AA@ 0343 __spawnlp 0431 _fclose"
	strings:
		$1 = { 55 8B EC 83 EC 50 56 C7 45 E0 00 00 00 00 83 7D 08 00 74 1C 83 7D 0C 00 74 16 8B 45 0C 0F BE 08 83 F9 77 74 10 8B 55 0C 0F BE 02 83 F8 72 74 05 E9 BB 04 00 00 8B 4D 0C 0F BE 51 01 83 FA 74 75 09 C7 45 E0 00 40 00 00 EB 13 8B 45 0C 0F BE 48 01 83 F9 62 75 07 C7 45 E0 00 80 00 00 8B 55 E0 80 CA 80 89 55 E0 8B 45 E0 50 68 00 04 00 00 8D 4D E4 51 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 FF 75 05 E9 6B 04 00 00 8B 55 0C 0F BE 02 83 F8 77 75 17 C7 45 FC 00 00 00 00 C7 45 C8 00 00 00 00 C7 45 C0 01 00 00 00 EB 15 C7 45 FC 01 00 00 00 C7 45 C8 01 00 00 00 C7 45 C0 00 00 00 00 C7 45 B8 01 00 00 00 8B 4D B8 89 4D B4 FF 15 ?? ?? ?? ?? 89 45 D8 8B 55 FC C1 FA 05 8B 45 FC 83 E0 1F 8B 0C 95 ?? ?? ?? ?? 8B 14 C1 89 55 EC 83 7D EC FF 74 20 6A 02 6A 00 6A 00 8D 45 C4 50 8B 4D D8 51 8B 55 EC 52 8B 45 D8 50 FF 15 ?? ?? ?? ?? 85 C0 75 05 E9 A6 03 00 00 8B 4D FC C1 F9 05 8B 55 FC 83 E2 1F 8B 04 8D ?? ?? ?? ?? 8A 4C D0 04 88 4D D0 6A 02 6A 01 6A 00 8D 55 D4 52 8B 45 D8 50 8B 4D C8 8B 54 8D E4 C1 FA 05 8B 45 C8 8B 4C 85 E4 83 E1 1F 8B 14 95 ?? ?? ?? ?? 8B 04 CA 50 8B 4D D8 51 FF 15 ?? ?? ?? ?? 85 C0 75 05 E9 42 03 00 00 8B 55 FC C1 FA 05 8B 45 FC 83 E0 1F 8B 0C 95 ?? ?? ?? ?? 8B 14 C1 52 FF 15 ?? ?? ?? ?? 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D D4 51 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 08 8B 45 C8 8B 4C 85 E4 C1 F9 05 8B 55 C8 8B 44 95 E4 83 E0 1F 8B 0C 8D ?? ?? ?? ?? 8B 55 FC C1 FA 05 8B 75 FC 83 E6 1F 8B 14 95 ?? ?? ?? ?? 8A 44 C1 04 88 44 F2 04 8B 4D C8 8B 54 8D E4 52 E8 ?? ?? ?? ?? 83 C4 04 8B 45 C8 C7 44 85 B4 00 00 00 00 8B 4D 0C 51 8B 55 C0 8B 44 95 E4 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 F4 83 7D F4 00 75 05 E9 27 02 00 00 6A 00 E8 ?? ?? ?? ?? 83 C4 04 89 45 F8 83 7D F8 00 75 05 E9 F8 01 00 00 8B 4D C0 8B 54 8D E4 C1 FA 05 8B 45 C0 8B 4C 85 E4 83 E1 1F 8B 14 95 ?? ?? ?? ?? 8B 04 CA 89 45 BC 8B 4D C0 8B 54 8D E4 C1 FA 05 8B 45 C0 8B 4C 85 E4 83 E1 1F 8B 14 95 ?? ?? ?? ?? C7 04 CA FF FF FF FF 8B 45 C0 8B 4C 85 E4 C1 F9 05 8B 55 C0 8B 44 95 E4 83 E0 1F 8B 0C 8D ?? ?? ?? ?? 8A 54 C1 04 88 55 CC 8B 45 C0 8B 4C 85 E4 C1 F9 05 8B 55 C0 8B 44 95 E4 83 E0 1F 8B 0C 8D ?? ?? ?? ?? C6 44 C1 04 00 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 89 45 F0 83 7D F0 00 74 38 6A 00 8B 55 08 52 68 ?? ?? ?? ?? 8B 45 F0 50 8B 4D F0 51 6A 01 E8 ?? ?? ?? ?? 83 C4 18 89 45 DC 83 7D DC FF 75 58 83 3D ?? ?? ?? ?? 02 74 09 83 3D ?? ?? ?? ?? 0D 75 46 8B 15 ?? ?? ?? ?? 81 E2 00 80 00 00 85 D2 74 09 C7 45 B0 ?? ?? ?? ?? EB 07 C7 45 B0 ?? ?? ?? ?? 8B 45 B0 89 45 F0 6A 00 8B 4D 08 51 68 ?? ?? ?? ?? 8B 55 F0 52 8B 45 F0 50 6A 01 E8 ?? ?? ?? ?? 83 C4 18 89 45 DC 8B 4D C0 8B 54 8D E4 C1 FA 05 8B 45 C0 8B 4C 85 E4 83 E1 1F 8B 14 95 ?? ?? ?? ?? 8B 45 BC 89 04 CA 8B 4D C0 8B 54 8D E4 C1 FA 05 8B 45 C0 8B 4C 85 E4 83 E1 1F 8B 14 95 ?? ?? ?? ?? 8A 45 CC 88 44 CA 04 83 7D DC FF 75 05 E9 88 00 00 00 6A 03 6A 01 6A 00 8D 4D D4 51 8B 55 D8 52 8B 45 C4 50 8B 4D D8 51 FF 15 ?? ?? ?? ?? 8B 55 FC C1 FA 05 8B 45 FC 83 E0 1F 8B 0C 95 ?? ?? ?? ?? 8B 14 C1 52 FF 15 ?? ?? ?? ?? 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D D4 51 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC C1 F8 05 8B 4D FC 83 E1 1F 8B 14 85 ?? ?? ?? ?? 8A 45 D0 88 44 CA 04 8B 4D F8 8B 55 DC 89 51 04 8B 45 F8 8B 4D F4 89 08 8B 45 F4 E9 CF 00 00 00 8B 55 F8 C7 02 00 00 00 00 8B 45 F4 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D C0 C7 44 8D B4 00 00 00 00 6A 02 6A 01 6A 00 8D 55 D4 52 8B 45 D8 50 8B 4D C4 51 8B 55 D8 52 FF 15 ?? ?? ?? ?? 8B 45 FC C1 F8 05 8B 4D FC 83 E1 1F 8B 14 85 ?? ?? ?? ?? 8B 04 CA 50 FF 15 ?? ?? ?? ?? 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 D4 52 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4D FC C1 F9 05 8B 55 FC 83 E2 1F 8B 04 8D ?? ?? ?? ?? 8A 4D D0 88 4C D0 04 8B 55 C4 52 FF 15 ?? ?? ?? ?? 8B 45 C8 83 7C 85 B4 00 74 10 8B 4D C8 8B 54 8D E4 52 E8 ?? ?? ?? ?? 83 C4 04 8B 45 C0 83 7C 85 B4 00 74 10 8B 4D C0 8B 54 8D E4 52 E8 ?? ?? ?? ?? 83 C4 04 33 C0 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_88_1_0 {
	meta:
		name = "__pclose"
		size = 121
		refs = "0018 _idtab 002f _fclose 0044 __cwait 0052 _errno"
	strings:
		$1 = { 55 8B EC 83 EC 0C C7 45 F8 FF FF FF FF 83 7D 08 00 74 15 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 83 7D FC 00 75 02 EB 48 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 6A 01 8B 55 FC 8B 42 04 50 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 FF 75 09 83 3D ?? ?? ?? ?? 04 75 06 8B 55 F4 89 55 F8 8B 45 FC C7 00 00 00 00 00 8B 4D FC C7 41 04 00 00 00 00 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_88_2_0 {
	meta:
		name = "_idtab"
		size = 188
		refs = "0007 ___idpairs 001b ___idtabsiz 005f ??_C@_07OCEB@popen?4c?$AA@ 007a __realloc_dbg"
	strings:
		$1 = { 55 8B EC 83 EC 08 A1 ?? ?? ?? ?? 89 45 F8 EB 09 8B 4D F8 83 C1 08 89 4D F8 8B 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8D 0C D0 39 4D F8 73 0E 8B 55 F8 8B 02 3B 45 08 75 02 EB 02 EB D6 8B 0D ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 8D 04 CA 39 45 F8 73 05 8B 45 F8 EB 65 83 7D 08 00 75 31 68 02 02 00 00 68 ?? ?? ?? ?? 6A 02 8B 0D ?? ?? ?? ?? 8D 14 CD 08 00 00 00 52 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 14 89 45 FC 83 7D FC 00 75 04 33 C0 EB 2A 8B 4D FC 89 0D ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 8B 45 FC 8D 0C D0 89 4D F8 8B 15 ?? ?? ?? ?? 83 C2 01 89 15 ?? ?? ?? ?? 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_90_0_0 {
	meta:
		name = "_DllMain@12"
		size = 37
		refs = "000b __pRawDllMain 0018 __imp__DisableThreadLibraryCalls@4"
	strings:
		$1 = { 55 8B EC 83 7D 0C 01 75 13 83 3D ?? ?? ?? ?? 00 75 0A 8B 45 08 50 FF 15 ?? ?? ?? ?? B8 01 00 00 00 5D C2 0C 00 }
	condition:
		$1
}

rule file_91_0_0 {
	meta:
		name = "__EH_prolog2"
		size = 55
	strings:
		$1 = { 51 8B 4C 24 08 89 5C 24 08 8D 5C 24 08 F7 D9 23 E1 8B 4B F8 89 2C 24 8B EC 6A FF 50 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 51 8B 43 FC 8B 4B 04 89 4D 04 59 50 C3 }
	condition:
		$1
}

rule file_92_0_0 {
	meta:
		name = "_wprintf"
		size = 124
		refs = "0016 ??_C@_0P@LNLA@format?5?$CB?$DN?5NULL?$AA@ 001f ??_C@_09NNCG@wprintf?4c?$AA@ 0026 __CrtDbgReport 003a __iob 003f __stbuf 0057 __woutput 006b __ftbuf"
	strings:
		$1 = { 55 8B EC 83 EC 0C 53 56 57 8D 45 0C 89 45 F4 83 7D 08 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 38 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D6 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 8B 55 F4 52 8B 45 08 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 89 45 F8 68 ?? ?? ?? ?? 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 8B 45 F8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_93_0_0 {
	meta:
		name = "__mbscspn"
		size = 275
		refs = "0008 ___ismbcodepage 0018 _strcspn 006b __mbctype"
	strings:
		$1 = { 55 8B EC 83 EC 08 83 3D ?? ?? ?? ?? 00 75 15 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 E9 EB 00 00 00 8B 55 08 89 55 F8 EB 09 8B 45 F8 83 C0 01 89 45 F8 8B 4D F8 33 D2 8A 11 85 D2 0F 84 C5 00 00 00 8B 45 0C 89 45 FC EB 09 8B 4D FC 83 C1 01 89 4D FC 8B 55 FC 33 C0 8A 02 85 C0 74 6B 8B 4D FC 33 D2 8A 11 33 C0 8A 82 ?? ?? ?? ?? 83 E0 04 85 C0 74 3F 8B 4D FC 33 D2 8A 11 8B 45 F8 33 C9 8A 08 3B D1 75 14 8B 55 FC 33 C0 8A 42 01 8B 4D F8 33 D2 8A 51 01 3B C2 74 0C 8B 45 FC 33 C9 8A 48 01 85 C9 75 02 EB 21 8B 55 FC 83 C2 01 89 55 FC EB 14 8B 45 FC 33 C9 8A 08 8B 55 F8 33 C0 8A 02 3B C8 75 02 EB 02 EB 81 8B 4D FC 33 D2 8A 11 85 D2 74 02 EB 31 8B 45 F8 33 C9 8A 08 33 D2 8A 91 ?? ?? ?? ?? 83 E2 04 85 D2 74 16 8B 45 F8 83 C0 01 89 45 F8 8B 4D F8 33 D2 8A 11 85 D2 75 02 EB 05 E9 23 FF FF FF 8B 45 F8 2B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_94_0_0 {
	meta:
		name = "_setvbuf"
		size = 342
		refs = "0017 ??_C@_0M@KJPK@str?5?$CB?$DN?5NULL?$AA@ 0020 ??_C@_09GCII@setvbuf?4c?$AA@ 0027 __CrtDbgReport 0077 __flush 0083 __freebuf 00dd __malloc_dbg 00ef __cflush"
	strings:
		$1 = { 55 8B EC 83 EC 08 53 56 57 C7 45 F8 00 00 00 00 83 7D 08 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 36 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D6 83 7D 10 04 74 23 83 7D 14 02 72 15 81 7D 14 FF FF FF 7F 77 0C 83 7D 10 00 74 0E 83 7D 10 40 74 08 83 C8 FF E9 EC 00 00 00 8B 4D 14 83 E1 FE 89 4D 14 8B 55 08 89 55 FC 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 FC 8B 42 0C 25 F3 C2 FF FF 8B 4D FC 89 41 0C 8B 55 10 83 E2 04 85 D2 74 21 8B 45 FC 8B 48 0C 83 C9 04 8B 55 FC 89 4A 0C 8B 45 FC 83 C0 14 89 45 0C C7 45 14 02 00 00 00 EB 62 83 7D 0C 00 75 4D 68 85 00 00 00 68 ?? ?? ?? ?? 6A 02 8B 4D 14 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 0C 83 7D 0C 00 75 18 8B 15 ?? ?? ?? ?? 83 C2 01 89 15 ?? ?? ?? ?? C7 45 F8 FF FF FF FF EB 47 8B 45 FC 8B 48 0C 81 C9 08 04 00 00 8B 55 FC 89 4A 0C EB 0F 8B 45 FC 8B 48 0C 80 CD 05 8B 55 FC 89 4A 0C 8B 45 FC 8B 4D 14 89 48 18 8B 55 FC 8B 45 0C 89 42 08 8B 4D FC 8B 55 0C 89 11 8B 45 FC C7 40 04 00 00 00 00 8B 45 F8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_95_0_0 {
	meta:
		name = "_mbstowcs"
		size = 488
		refs = "002a ??_C@_09MFCA@s?5?$CB?$DN?5NULL?$AA@ 0033 ??_C@_0L@IBOD@mbstowcs?4c?$AA@ 003a __CrtDbgReport 0059 ___lc_handle 00ba ___lc_codepage 00c1 __imp__MultiByteToWideChar@24 00db __imp__GetLastError@0 00e6 _errno 0131 __pctype 01a2 _strlen"
	strings:
		$1 = { 55 8B EC 83 EC 10 53 56 57 C7 45 FC 00 00 00 00 83 7D 08 00 74 0D 83 7D 10 00 75 07 33 C0 E9 BE 01 00 00 83 7D 0C 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 55 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D6 83 7D 08 00 0F 84 3D 01 00 00 83 3D ?? ?? ?? ?? 00 75 49 8B 4D FC 3B 4D 10 73 39 8B 55 0C 03 55 FC 66 0F B6 02 8B 4D 08 66 89 01 8B 55 0C 03 55 FC 0F BE 02 85 C0 75 08 8B 45 FC E9 54 01 00 00 8B 4D FC 83 C1 01 89 4D FC 8B 55 08 83 C2 02 89 55 08 EB BF 8B 45 FC E9 38 01 00 00 8B 45 10 50 8B 4D 08 51 6A FF 8B 55 0C 52 6A 09 A1 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 74 0B 8B 45 FC 83 E8 01 E9 08 01 00 00 FF 15 ?? ?? ?? ?? 83 F8 7A 74 12 C7 05 ?? ?? ?? ?? 2A 00 00 00 83 C8 FF E9 EB 00 00 00 8B 4D 10 89 4D F0 8B 55 0C 89 55 F8 EB 09 8B 45 F8 83 C0 01 89 45 F8 8B 4D F0 8B 55 F0 83 EA 01 89 55 F0 85 C9 74 33 8B 45 F8 33 C9 8A 08 85 C9 74 28 8B 55 F8 33 C0 8A 02 8B 0D ?? ?? ?? ?? 33 D2 66 8B 14 41 81 E2 00 80 00 00 85 D2 74 09 8B 45 F8 83 C0 01 89 45 F8 EB B4 8B 4D F8 2B 4D 0C 89 4D F4 8B 55 10 52 8B 45 08 50 8B 4D F4 51 8B 55 0C 52 6A 01 A1 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 75 0F C7 05 ?? ?? ?? ?? 2A 00 00 00 83 C8 FF EB 52 8B 45 FC EB 4D 83 3D ?? ?? ?? ?? 00 75 0E 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 04 EB 36 6A 00 6A 00 6A FF 8B 55 0C 52 6A 09 A1 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 75 0F C7 05 ?? ?? ?? ?? 2A 00 00 00 83 C8 FF EB 06 8B 45 FC 83 E8 01 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_96_0_0 {
	meta:
		name = "_strcmp"
		size = 16
	strings:
		$1 = { 8B 54 24 04 8B 4C 24 08 F7 C2 03 00 00 00 75 3C }
	condition:
		$1
}

rule file_96_1_0 {
	meta:
		name = "dodwords"
		size = 48
	strings:
		$1 = { 8B 02 3A 01 75 2E 0A C0 74 26 3A 61 01 75 25 0A E4 74 1D C1 E8 10 3A 41 02 75 19 0A C0 74 11 3A 61 03 75 10 83 C1 04 83 C2 04 0A E4 75 D2 8B FF }
	condition:
		$1
}

rule file_96_4_0 {
	meta:
		name = "dopartial"
		size = 28
	strings:
		$1 = { F7 C2 01 00 00 00 74 14 8A 02 42 3A 01 75 E9 41 0A C0 74 E0 F7 C2 02 00 00 00 74 A8 }
	condition:
		$1
}

rule file_96_5_0 {
	meta:
		name = "doword"
		size = 28
	strings:
		$1 = { 66 8B 02 83 C2 02 3A 01 75 D2 0A C0 74 CA 3A 61 01 75 C9 0A E4 74 C1 83 C1 02 EB 8C }
	condition:
		$1
}

rule file_97_0_0 {
	meta:
		name = "__wmkdir"
		size = 67
		refs = "000c __imp__CreateDirectoryW@8 0016 __imp__GetLastError@0 0031 __dosmaperr"
	strings:
		$1 = { 55 8B EC 51 6A 00 8B 45 08 50 FF 15 ?? ?? ?? ?? 85 C0 75 0B FF 15 ?? ?? ?? ?? 89 45 FC EB 07 C7 45 FC 00 00 00 00 83 7D FC 00 74 11 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 83 C8 FF EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_468_0_0 {
	meta:
		name = "__mkdir"
		size = 67
		refs = "000c __imp__CreateDirectoryA@8 0016 __imp__GetLastError@0 0031 __dosmaperr"
	strings:
		$1 = { 55 8B EC 51 6A 00 8B 45 08 50 FF 15 ?? ?? ?? ?? 85 C0 75 0B FF 15 ?? ?? ?? ?? 89 45 FC EB 07 C7 45 FC 00 00 00 00 83 7D FC 00 74 11 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 83 C8 FF EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_98_1_0 {
	meta:
		name = "str_misaligned"
		size = 20
	strings:
		$1 = { 8A 01 41 84 C0 74 40 F7 C1 03 00 00 00 75 F1 05 00 00 00 00 }
	condition:
		$1
}

rule file_98_2_0 {
	meta:
		name = "main_loop"
		size = 51
	strings:
		$1 = { 8B 01 BA FF FE FE 7E 03 D0 83 F0 FF 33 C2 83 C1 04 A9 00 01 01 81 74 E8 8B 41 FC 84 C0 74 32 84 E4 74 24 A9 00 00 FF 00 74 13 A9 00 00 00 FF 74 02 EB CD }
	condition:
		$1
}

rule file_99_0_0 {
	meta:
		name = "__getws"
		size = 157
		refs = "001c ??_C@_0P@OOIN@string?5?$CB?$DN?5NULL?$AA@ 0025 ??_C@_06CIMD@gets?4c?$AA@ 002c __CrtDbgReport 0040 __iob 0045 _fgetwc"
	strings:
		$1 = { 55 8B EC 83 EC 0C 53 56 57 8B 45 08 89 45 FC 8B 4D 08 89 4D F4 83 7D 08 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 2D 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 D2 85 D2 75 D6 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 25 FF FF 00 00 89 45 F8 83 7D F8 0A 74 31 81 7D F8 FF FF 00 00 75 13 8B 45 FC 3B 45 08 75 09 C7 45 F4 00 00 00 00 EB 1F EB 15 8B 4D FC 66 8B 55 F8 66 89 11 8B 45 FC 83 C0 02 89 45 FC EB B4 8B 4D FC 66 C7 01 00 00 8B 45 F4 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_0_0 {
	meta:
		name = "__ismbcprint"
		size = 245
		refs = "003c ___ismbcodepage 004d ___mblcid 0054 ___mbcodepage 0066 ___crtGetStringTypeA 00b8 __ctype 00d3 __mbctype"
	strings:
		$1 = { 55 8B EC 83 EC 10 81 7D 08 FF 00 00 00 0F 86 97 00 00 00 66 C7 45 F8 00 00 33 C0 66 89 45 FA 8B 4D 08 C1 E9 08 81 E1 FF 00 00 00 88 4D FC 8B 55 08 81 E2 FF 00 00 00 88 55 FD 83 3D ?? ?? ?? ?? 00 75 07 33 C0 E9 A7 00 00 00 6A 01 A1 ?? ?? ?? ?? 50 8B 0D ?? ?? ?? ?? 51 8D 55 F8 52 6A 02 8D 45 FC 50 6A 01 E8 ?? ?? ?? ?? 83 C4 1C 85 C0 75 04 33 C0 EB 7C 8B 4D FA 81 E1 FF FF 00 00 85 C9 75 1C 8B 55 F8 81 E2 FF FF 00 00 81 E2 57 01 00 00 85 D2 74 09 C7 45 F4 01 00 00 00 EB 07 C7 45 F4 00 00 00 00 8B 45 F4 EB 47 8B 45 08 25 FF 00 00 00 33 C9 66 8B 0C 45 ?? ?? ?? ?? 81 E1 57 01 00 00 85 C9 75 21 8B 55 08 81 E2 FF 00 00 00 33 C0 8A 82 ?? ?? ?? ?? 83 E0 03 85 C0 75 09 C7 45 F0 00 00 00 00 EB 07 C7 45 F0 01 00 00 00 8B 45 F0 8B E5 5D C3 }
	condition:
		$1
}

rule file_102_0_0 {
	meta:
		name = "__wcsicmp"
		size = 328
		refs = "0008 ___lc_handle 00e0 _towlower"
	strings:
		$1 = { 55 8B EC 83 EC 14 83 3D ?? ?? ?? ?? 00 0F 85 B4 00 00 00 8B 45 08 33 C9 66 8B 08 83 F9 5A 7F 1D 8B 55 08 33 C0 66 8B 02 83 F8 41 7C 10 8B 4D 08 33 D2 66 8B 11 83 C2 20 89 55 F4 EB 0B 8B 45 08 33 C9 66 8B 08 89 4D F4 66 8B 55 F4 66 89 55 FC 8B 45 0C 33 C9 66 8B 08 83 F9 5A 7F 1D 8B 55 0C 33 C0 66 8B 02 83 F8 41 7C 10 8B 4D 0C 33 D2 66 8B 11 83 C2 20 89 55 F0 EB 0B 8B 45 0C 33 C9 66 8B 08 89 4D F0 66 8B 55 F0 66 89 55 F8 8B 45 08 83 C0 02 89 45 08 8B 4D 0C 83 C1 02 89 4D 0C 8B 55 FC 81 E2 FF FF 00 00 85 D2 74 19 8B 45 FC 25 FF FF 00 00 8B 4D F8 81 E1 FF FF 00 00 3B C1 0F 84 4E FF FF FF EB 6A 8B 55 08 66 8B 02 66 89 45 EE 66 8B 4D EE 51 8B 55 08 83 C2 02 89 55 08 E8 ?? ?? ?? ?? 83 C4 04 66 89 45 FC 8B 45 0C 66 8B 08 66 89 4D EC 66 8B 55 EC 52 8B 45 0C 83 C0 02 89 45 0C E8 ?? ?? ?? ?? 83 C4 04 66 89 45 F8 8B 4D FC 81 E1 FF FF 00 00 85 C9 74 15 8B 55 FC 81 E2 FF FF 00 00 8B 45 F8 25 FF FF 00 00 3B D0 74 96 8B 45 FC 25 FF FF 00 00 8B 4D F8 81 E1 FF FF 00 00 2B C1 8B E5 5D C3 }
	condition:
		$1
}

rule file_104_0_0 {
	meta:
		name = "__fullpath"
		size = 215
		refs = "001f __getcwd 0037 _malloc 0049 _errno 0076 __imp__GetFullPathNameA@16 0090 _free 00bf __imp__GetLastError@0 00c5 __dosmaperr"
	strings:
		$1 = { 55 8B EC 83 EC 0C 83 7D 0C 00 74 0A 8B 45 0C 0F BE 08 85 C9 75 15 8B 55 10 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 E9 A8 00 00 00 83 7D 08 00 75 2D 68 04 01 00 00 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 83 7D FC 00 75 0E C7 05 ?? ?? ?? ?? 0C 00 00 00 33 C0 EB 7E C7 45 10 04 01 00 00 EB 06 8B 4D 08 89 4D FC 8D 55 F4 52 8B 45 FC 50 8B 4D 10 51 8B 55 0C 52 FF 15 ?? ?? ?? ?? 89 45 F8 8B 45 F8 3B 45 10 72 20 83 7D 08 00 75 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 C7 05 ?? ?? ?? ?? 22 00 00 00 33 C0 EB 2E 83 7D F8 00 75 25 83 7D 08 00 75 0C 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 33 C0 EB 03 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_105_0_0 {
	meta:
		name = "__XcptFilter"
		size = 425
		refs = "000b _xcptlookup 002a __imp__UnhandledExceptionFilter@4 006c __pxcptinfoptrs 008a __First_FPE_Indx 00a4 __Num_FPE 00b5 __XcptActTab 00c0 __fpecode"
	strings:
		$1 = { 55 8B EC 83 EC 14 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 F4 83 7D F4 00 74 09 8B 4D F4 83 79 08 00 75 0F 8B 55 0C 52 FF 15 ?? ?? ?? ?? E9 72 01 00 00 8B 45 F4 83 78 08 05 75 14 8B 4D F4 C7 41 08 00 00 00 00 B8 01 00 00 00 E9 55 01 00 00 8B 55 F4 83 7A 08 01 75 08 83 C8 FF E9 44 01 00 00 8B 45 F4 8B 48 08 89 4D FC 8B 15 ?? ?? ?? ?? 89 55 EC 8B 45 0C A3 ?? ?? ?? ?? 8B 4D F4 83 79 04 08 0F 85 FA 00 00 00 8B 15 ?? ?? ?? ?? 89 55 F0 EB 09 8B 45 F0 83 C0 01 89 45 F0 8B 0D ?? ?? ?? ?? 03 0D ?? ?? ?? ?? 39 4D F0 7D 12 8B 55 F0 6B D2 0C C7 82 ?? ?? ?? ?? 00 00 00 00 EB D4 A1 ?? ?? ?? ?? 89 45 F8 8B 4D F4 81 39 8E 00 00 C0 75 0F C7 05 ?? ?? ?? ?? 83 00 00 00 E9 88 00 00 00 8B 55 F4 81 3A 90 00 00 C0 75 0C C7 05 ?? ?? ?? ?? 81 00 00 00 EB 71 8B 45 F4 81 38 91 00 00 C0 75 0C C7 05 ?? ?? ?? ?? 84 00 00 00 EB 5A 8B 4D F4 81 39 93 00 00 C0 75 0C C7 05 ?? ?? ?? ?? 85 00 00 00 EB 43 8B 55 F4 81 3A 8D 00 00 C0 75 0C C7 05 ?? ?? ?? ?? 82 00 00 00 EB 2C 8B 45 F4 81 38 8F 00 00 C0 75 0C C7 05 ?? ?? ?? ?? 86 00 00 00 EB 15 8B 4D F4 81 39 92 00 00 C0 75 0A C7 05 ?? ?? ?? ?? 8A 00 00 00 8B 15 ?? ?? ?? ?? 52 6A 08 FF 55 FC 83 C4 08 8B 45 F8 A3 ?? ?? ?? ?? EB 17 8B 4D F4 C7 41 08 00 00 00 00 8B 55 F4 8B 42 04 50 FF 55 FC 83 C4 04 8B 4D EC 89 0D ?? ?? ?? ?? 83 C8 FF 8B E5 5D C3 }
	condition:
		$1
}

rule file_105_1_0 {
	meta:
		name = "_xcptlookup"
		size = 91
		refs = "0007 __XcptActTab 001f __XcptActTabCount"
	strings:
		$1 = { 55 8B EC 51 C7 45 FC ?? ?? ?? ?? 8B 45 FC 8B 08 3B 4D 08 74 1D 8B 55 FC 83 C2 0C 89 55 FC A1 ?? ?? ?? ?? 6B C0 0C 05 ?? ?? ?? ?? 39 45 FC 73 02 EB D9 8B 0D ?? ?? ?? ?? 6B C9 0C 81 C1 ?? ?? ?? ?? 39 4D FC 73 0A 8B 55 FC 8B 02 3B 45 08 74 04 33 C0 EB 03 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_106_0_0 {
	meta:
		name = "__mbsset"
		size = 182
		refs = "000e ___ismbcodepage 001e __strset"
	strings:
		$1 = { 55 8B EC 83 EC 0C 8B 45 08 89 45 F4 83 3D ?? ?? ?? ?? 00 75 15 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 E9 88 00 00 00 8B 45 0C C1 E8 08 88 45 F8 8B 4D F8 81 E1 FF 00 00 00 85 C9 74 51 8B 55 0C 81 E2 FF 00 00 00 88 55 FC 8B 45 08 33 C9 8A 08 85 C9 74 38 8B 55 08 8A 45 F8 88 02 8B 4D 08 83 C1 01 89 4D 08 8B 55 08 33 C0 8A 02 85 C0 74 13 8B 4D 08 8A 55 FC 88 11 8B 45 08 83 C0 01 89 45 08 EB 07 8B 4D 08 C6 41 FF 20 EB BD EB 1E 8B 55 08 33 C0 8A 02 85 C0 74 13 8B 4D 08 8A 55 0C 88 11 8B 45 08 83 C0 01 89 45 08 EB E2 8B 45 F4 8B E5 5D C3 }
	condition:
		$1
}

rule file_107_0_0 {
	meta:
		name = "_wscanf"
		size = 91
		refs = "0016 ??_C@_0P@LNLA@format?5?$CB?$DN?5NULL?$AA@ 001f ??_C@_08GJIK@wscanf?4c?$AA@ 0026 __CrtDbgReport 0042 __iob 0047 __winput"
	strings:
		$1 = { 55 8B EC 83 EC 08 53 56 57 8D 45 0C 89 45 FC 83 7D 08 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 37 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D6 8B 55 FC 52 8B 45 08 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 89 45 F8 8B 45 F8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_108_0_0 {
	meta:
		name = "__chsize"
		size = 613
		refs = "0009 __chkstk 002b __nhandle 0040 ___pioinfo 0052 _errno 0069 ??_C@_09NPGF@size?5?$DO?$DN?50?$AA@ 0075 ??_C@_08EIOK@chsize?4c?$AA@ 007c __CrtDbgReport 0098 __lseek 0100 _memset 0111 __setmode 0182 __write 019a __doserrno 020a __get_osfhandle 0214 __imp__SetEndOfFile@4 023a __imp__GetLastError@0"
	strings:
		$1 = { 55 8B EC B8 24 10 00 00 E8 ?? ?? ?? ?? 53 56 57 8D 85 FC EF FF FF 89 85 EC EF FF FF C7 85 E4 EF FF FF 00 00 00 00 8B 4D 08 3B 0D ?? ?? ?? ?? 73 1F 8B 55 08 C1 FA 05 8B 45 08 83 E0 1F 8B 0C 95 ?? ?? ?? ?? 0F BE 54 C1 04 83 E2 01 85 D2 75 12 C7 05 ?? ?? ?? ?? 09 00 00 00 83 C8 FF E9 FC 01 00 00 83 7D 0C 00 7D 21 68 ?? ?? ?? ?? 6A 00 68 81 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D3 6A 01 6A 00 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 89 85 F4 EF FF FF 83 BD F4 EF FF FF FF 74 1F 6A 02 6A 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 89 85 F0 EF FF FF 83 BD F0 EF FF FF FF 75 08 83 C8 FF E9 89 01 00 00 8B 45 0C 2B 85 F0 EF FF FF 89 85 E8 EF FF FF 83 BD E8 EF FF FF 00 0F 8E F9 00 00 00 68 00 10 00 00 6A 00 8B 8D EC EF FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 68 00 80 00 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 81 BD E8 EF FF FF 00 10 00 00 7C 0C C7 85 E0 EF FF FF 00 10 00 00 EB 0C 8B 85 E8 EF FF FF 89 85 E0 EF FF FF 8B 8D E0 EF FF FF 89 8D F8 EF FF FF 81 BD E8 EF FF FF 00 10 00 00 7C 0C C7 85 DC EF FF FF 00 10 00 00 EB 0C 8B 95 E8 EF FF FF 89 95 DC EF FF FF 8B 85 DC EF FF FF 50 8B 8D EC EF FF FF 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 89 85 F8 EF FF FF 83 BD F8 EF FF FF FF 75 21 83 3D ?? ?? ?? ?? 05 75 0A C7 05 ?? ?? ?? ?? 0D 00 00 00 8B 85 F8 EF FF FF 89 85 E4 EF FF FF EB 1F 8B 8D E8 EF FF FF 2B 8D F8 EF FF FF 89 8D E8 EF FF FF 83 BD E8 EF FF FF 00 0F 8F 43 FF FF FF 8B 55 FC 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 EB 59 83 BD E8 EF FF FF 00 7D 50 6A 00 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 50 FF 15 ?? ?? ?? ?? F7 D8 1B C0 F7 D8 48 89 85 E4 EF FF FF 83 BD E4 EF FF FF FF 75 15 C7 05 ?? ?? ?? ?? 0D 00 00 00 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? 6A 00 8B 8D F4 EF FF FF 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 85 E4 EF FF FF 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_109_0_0 {
	meta:
		name = "__allrem"
		size = 32
	strings:
		$1 = { 53 57 33 FF 8B 44 24 10 0B C0 7D 14 47 8B 54 24 0C F7 D8 F7 DA 83 D8 00 89 44 24 10 89 54 24 0C }
	condition:
		$1
}

rule file_109_1_0 {
	meta:
		name = "L1"
		size = 27
	strings:
		$1 = { 8B 44 24 18 0B C0 7D 13 8B 54 24 14 F7 D8 F7 DA 83 D8 00 89 44 24 18 89 54 24 14 }
	condition:
		$1
}

rule file_109_2_0 {
	meta:
		name = "L2"
		size = 31
	strings:
		$1 = { 0B C0 75 1B 8B 4C 24 14 8B 44 24 10 33 D2 F7 F1 8B 44 24 0C F7 F1 8B C2 33 D2 4F 79 4E EB 53 }
	condition:
		$1
}

rule file_109_4_0 {
	meta:
		name = "L5"
		size = 43
	strings:
		$1 = { D1 EB D1 D9 D1 EA D1 D8 0B DB 75 F4 F7 F1 8B C8 F7 64 24 18 91 F7 64 24 14 03 D1 72 0E 3B 54 24 10 77 08 72 0E 3B 44 24 0C 76 08 }
	condition:
		$1
}

rule file_111_0_0 {
	meta:
		name = "__wfsopen"
		size = 244
		refs = "0010 ??_C@_0N@MCKG@file?5?$CB?$DN?5NULL?$AA@ 0019 ??_C@_07OMGG@fopen?4c?$AA@ 0020 __CrtDbgReport 0040 ??_C@_0BC@GOED@?$CKfile?5?$CB?$DN?5_T?$CI?8?20?8?$CJ?$AA@ 006a ??_C@_0N@BKPP@mode?5?$CB?$DN?5NULL?$AA@ 009a ??_C@_0BC@IPFL@?$CKmode?5?$CB?$DN?5_T?$CI?8?20?8?$CJ?$AA@ 00be __getstream 00e0 __wopenfile"
	strings:
		$1 = { 55 8B EC 83 EC 08 53 56 57 83 7D 08 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 35 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D6 8B 4D 08 33 D2 66 8B 11 85 D2 75 1E 68 ?? ?? ?? ?? 6A 00 6A 36 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D0 83 7D 0C 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 37 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D6 8B 55 0C 33 C0 66 8B 02 85 C0 75 1E 68 ?? ?? ?? ?? 6A 00 6A 38 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D0 E8 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 75 04 33 C0 EB 1E 8B 55 FC 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 89 45 F8 8B 45 F8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_111_1_0 {
	meta:
		name = "__wfopen"
		size = 23
		refs = "000e __wfsopen"
	strings:
		$1 = { 55 8B EC 6A 40 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_185_1_0 {
	meta:
		name = "_fopen"
		size = 23
		refs = "000e __fsopen"
	strings:
		$1 = { 55 8B EC 6A 40 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_112_0_0 {
	meta:
		name = "__mbsnbicoll"
		size = 79
		refs = "000f ___mbcodepage 0028 ___mblcid 002e ___crtCompareStringA"
	strings:
		$1 = { 55 8B EC 51 83 7D 10 00 75 04 33 C0 EB 3D A1 ?? ?? ?? ?? 50 8B 4D 10 51 8B 55 0C 52 8B 45 10 50 8B 4D 08 51 6A 01 8B 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 1C 89 45 FC 83 7D FC 00 75 07 B8 FF FF FF 7F EB 06 8B 45 FC 83 E8 02 8B E5 5D C3 }
	condition:
		$1
}

rule file_113_0_0 {
	meta:
		name = "_vwprintf"
		size = 122
		refs = "000c __iob 0017 ??_C@_0P@LNLA@format?5?$CB?$DN?5NULL?$AA@ 0020 ??_C@_0L@JFE@vwprintf?4c?$AA@ 0027 __CrtDbgReport 003f __stbuf 0056 __woutput 0069 __ftbuf"
	strings:
		$1 = { 55 8B EC 83 EC 0C 53 56 57 C7 45 FC ?? ?? ?? ?? 83 7D 08 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 33 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D6 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 F8 8B 55 0C 52 8B 45 08 50 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F4 8B 55 FC 52 8B 45 F8 50 E8 ?? ?? ?? ?? 83 C4 08 8B 45 F4 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_114_0_0 {
	meta:
		name = "_strstr"
		size = 24
	strings:
		$1 = { 8B 4C 24 08 57 53 56 8A 11 8B 7C 24 10 84 D2 74 69 8A 71 01 84 F6 74 4F }
	condition:
		$1
}

rule file_114_1_0 {
	meta:
		name = "findnext"
		size = 17
	strings:
		$1 = { 8B F7 8B 4C 24 14 8A 07 46 38 D0 74 15 84 C0 74 0B }
	condition:
		$1
}

rule file_114_7_0 {
	meta:
		name = "compare_loop"
		size = 35
	strings:
		$1 = { 8A 61 02 84 E4 74 28 8A 06 83 C6 02 38 E0 75 C4 8A 41 03 84 C0 74 18 8A 66 FF 83 C1 02 38 E0 74 DF EB B1 }
	condition:
		$1
}

rule file_115_0_0 {
	meta:
		name = "__wopenfile"
		size = 918
		refs = "000a __commode 0026 ??_C@_0BB@COCE@filename?5?$CB?$DN?5NULL?$AA@ 002f ??_C@_07INLA@_open?4c?$AA@ 0036 __CrtDbgReport 0050 ??_C@_0N@BKPP@mode?5?$CB?$DN?5NULL?$AA@ 007a ??_C@_0M@KJPK@str?5?$CB?$DN?5NULL?$AA@ 0147 $L1489 014e $L1490 02b8 __wsopen 02ce __cflush 0324 $L1449 0328 $L1473 032c $L1467 0330 $L1464 0334 $L1470 0338 $L1452 033c $L1458 0340 $L1461 0344 $L1455 0348 $L1476"
	strings:
		$1 = { 55 8B EC 83 EC 24 53 56 57 A1 ?? ?? ?? ?? 89 45 E4 C7 45 E8 00 00 00 00 C7 45 F0 00 00 00 00 83 7D 08 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 47 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D6 83 7D 0C 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 48 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 D2 85 D2 75 D6 83 7D 14 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 49 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D6 8B 4D 0C 33 D2 66 8B 11 89 55 E0 83 7D E0 61 74 31 83 7D E0 72 74 08 83 7D E0 77 74 13 EB 35 C7 45 EC 00 00 00 00 8B 45 E4 0C 01 89 45 E4 EB 2B C7 45 EC 01 03 00 00 8B 4D E4 83 C9 02 89 4D E4 EB 19 C7 45 EC 09 01 00 00 8B 55 E4 83 CA 02 89 55 E4 EB 07 33 C0 E9 25 02 00 00 C7 45 FC 01 00 00 00 8B 45 0C 83 C0 02 89 45 0C 8B 4D 0C 33 D2 66 8B 11 85 D2 0F 84 8E 01 00 00 83 7D FC 00 0F 84 84 01 00 00 8B 45 0C 33 C9 66 8B 08 89 4D DC 8B 55 DC 83 EA 2B 89 55 DC 83 7D DC 49 0F 87 5A 01 00 00 8B 4D DC 33 C0 8A 81 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 8B 55 EC 83 E2 02 85 D2 74 09 C7 45 FC 00 00 00 00 EB 22 8B 45 EC 0C 02 89 45 EC 8B 4D EC 83 E1 FE 89 4D EC 8B 55 E4 80 CA 80 89 55 E4 8B 45 E4 24 FC 89 45 E4 E9 15 01 00 00 8B 4D EC 81 E1 00 C0 00 00 85 C9 74 09 C7 45 FC 00 00 00 00 EB 09 8B 55 EC 80 CE 80 89 55 EC E9 F1 00 00 00 8B 45 EC 25 00 C0 00 00 85 C0 74 09 C7 45 FC 00 00 00 00 EB 09 8B 4D EC 80 CD 40 89 4D EC E9 CE 00 00 00 83 7D E8 00 74 09 C7 45 FC 00 00 00 00 EB 10 C7 45 E8 01 00 00 00 8B 55 E4 80 CE 40 89 55 E4 E9 AA 00 00 00 83 7D E8 00 74 09 C7 45 FC 00 00 00 00 EB 10 C7 45 E8 01 00 00 00 8B 45 E4 80 E4 BF 89 45 E4 E9 86 00 00 00 83 7D F0 00 74 09 C7 45 FC 00 00 00 00 EB 10 C7 45 F0 01 00 00 00 8B 4D EC 83 C9 20 89 4D EC EB 65 83 7D F0 00 74 09 C7 45 FC 00 00 00 00 EB 10 C7 45 F0 01 00 00 00 8B 55 EC 83 CA 10 89 55 EC EB 44 8B 45 EC 25 00 10 00 00 85 C0 74 09 C7 45 FC 00 00 00 00 EB 09 8B 4D EC 80 CD 10 89 4D EC EB 24 8B 55 EC 83 E2 40 85 D2 74 09 C7 45 FC 00 00 00 00 EB 08 8B 45 EC 0C 40 89 45 EC EB 07 C7 45 FC 00 00 00 00 E9 59 FE FF FF 68 A4 01 00 00 8B 4D 10 51 8B 55 EC 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 F8 83 7D F8 00 7D 04 33 C0 EB 51 8B 0D ?? ?? ?? ?? 83 C1 01 89 0D ?? ?? ?? ?? 8B 55 14 89 55 F4 8B 45 F4 8B 4D E4 89 48 0C 8B 55 F4 C7 42 04 00 00 00 00 8B 45 F4 C7 00 00 00 00 00 8B 4D F4 C7 41 08 00 00 00 00 8B 55 F4 C7 42 1C 00 00 00 00 8B 45 F4 8B 4D F8 89 48 10 8B 45 F4 5F 5E 5B 8B E5 5D C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 09 09 09 09 09 09 09 09 09 09 09 09 09 09 09 09 09 09 09 09 09 09 09 09 01 09 09 09 09 09 09 09 09 09 09 09 09 09 02 03 04 09 09 09 09 09 09 09 09 09 09 09 09 09 05 06 09 09 09 09 09 09 09 09 09 09 07 09 09 09 09 09 08 }
	condition:
		$1
}

rule file_116_0_0 {
	meta:
		name = "__mbsbtype"
		size = 101
		refs = "0008 ___ismbcodepage 0044 __mbbtype"
	strings:
		$1 = { 55 8B EC 83 EC 08 83 3D ?? ?? ?? ?? 00 75 04 33 C0 EB 4E C7 45 FC FF FF FF FF 8B 45 08 33 C9 8A 08 85 C9 75 05 83 C8 FF EB 37 8B 55 FC 52 8B 45 08 8A 08 88 4D FB 8A 55 FB 52 8B 45 08 83 C0 01 89 45 08 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 8B 4D 0C 8B 55 0C 83 EA 01 89 55 0C 85 C9 75 BC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_118_0_0 {
	meta:
		name = "__wsetargv"
		size = 206
		refs = "000c _?_pgmname@?1??_wsetargv@@9@9 0014 __imp__GetModuleFileNameW@12 001a __wpgmptr 0023 __wcmdln 005a _wparse_cmdline 0067 ??_C@_09MPMN@stdargv?4c?$AA@ 007a __malloc_dbg 008d __amsg_exit 00bd ___argc 00c6 ___wargv"
	strings:
		$1 = { 55 8B EC 83 EC 14 68 04 01 00 00 68 ?? ?? ?? ?? 6A 00 FF 15 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 C9 66 8B 08 85 C9 75 0B 8B 15 ?? ?? ?? ?? 89 55 EC EB 08 A1 ?? ?? ?? ?? 89 45 EC 8B 4D EC 89 4D F0 8D 55 FC 52 8D 45 F4 50 6A 00 6A 00 8B 4D F0 51 E8 ?? ?? ?? ?? 83 C4 14 68 80 00 00 00 68 ?? ?? ?? ?? 6A 02 8B 55 FC D1 E2 8B 45 F4 8D 0C 82 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 F8 83 7D F8 00 75 0A 6A 08 E8 ?? ?? ?? ?? 83 C4 04 8D 55 FC 52 8D 45 F4 50 8B 4D F4 8B 55 F8 8D 04 8A 50 8B 4D F8 51 8B 55 F0 52 E8 ?? ?? ?? ?? 83 C4 14 8B 45 F4 83 E8 01 A3 ?? ?? ?? ?? 8B 4D F8 89 0D ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_118_1_0 {
	meta:
		name = "_wparse_cmdline"
		size = 841
	strings:
		$1 = { 55 8B EC 83 EC 14 8B 45 18 C7 00 00 00 00 00 8B 4D 14 C7 01 01 00 00 00 8B 55 08 89 55 FC 83 7D 0C 00 74 11 8B 45 0C 8B 4D 10 89 08 8B 55 0C 83 C2 04 89 55 0C 8B 45 FC 33 C9 66 8B 08 83 F9 22 0F 85 8B 00 00 00 8B 55 FC 83 C2 02 89 55 FC 8B 45 FC 33 C9 66 8B 08 83 F9 22 74 36 8B 55 FC 33 C0 66 8B 02 85 C0 74 2A 8B 4D 18 8B 11 83 C2 01 8B 45 18 89 10 83 7D 10 00 74 15 8B 4D 10 8B 55 FC 66 8B 02 66 89 01 8B 4D 10 83 C1 02 89 4D 10 EB B4 8B 55 18 8B 02 83 C0 01 8B 4D 18 89 01 83 7D 10 00 74 11 8B 55 10 66 C7 02 00 00 8B 45 10 83 C0 02 89 45 10 8B 4D FC 33 D2 66 8B 11 83 FA 22 75 09 8B 45 FC 83 C0 02 89 45 FC E9 8A 00 00 00 8B 4D 18 8B 11 83 C2 01 8B 45 18 89 10 83 7D 10 00 74 15 8B 4D 10 8B 55 FC 66 8B 02 66 89 01 8B 4D 10 83 C1 02 89 4D 10 8B 55 FC 66 8B 02 66 89 45 F4 8B 4D FC 83 C1 02 89 4D FC 8B 55 F4 81 E2 FF FF 00 00 83 FA 20 74 1A 8B 45 F4 25 FF FF 00 00 85 C0 74 0E 8B 4D F4 81 E1 FF FF 00 00 83 F9 09 75 9D 8B 55 F4 81 E2 FF FF 00 00 85 D2 75 0B 8B 45 FC 83 E8 02 89 45 FC EB 0F 83 7D 10 00 74 09 8B 4D 10 66 C7 41 FE 00 00 C7 45 EC 00 00 00 00 8B 55 FC 33 C0 66 8B 02 85 C0 74 25 8B 4D FC 33 D2 66 8B 11 83 FA 20 74 0D 8B 45 FC 33 C9 66 8B 08 83 F9 09 75 0B 8B 55 FC 83 C2 02 89 55 FC EB DB 8B 45 FC 33 C9 66 8B 08 85 C9 75 05 E9 7C 01 00 00 83 7D 0C 00 74 11 8B 55 0C 8B 45 10 89 02 8B 4D 0C 83 C1 04 89 4D 0C 8B 55 14 8B 02 83 C0 01 8B 4D 14 89 01 C7 45 F8 01 00 00 00 C7 45 F0 00 00 00 00 8B 55 FC 33 C0 66 8B 02 83 F8 5C 75 14 8B 4D FC 83 C1 02 89 4D FC 8B 55 F0 83 C2 01 89 55 F0 EB DF 8B 45 FC 33 C9 66 8B 08 83 F9 22 75 53 8B 45 F0 33 D2 B9 02 00 00 00 F7 F1 85 D2 75 3B 83 7D EC 00 74 22 8B 55 FC 33 C0 66 8B 42 02 83 F8 22 75 0B 8B 4D FC 83 C1 02 89 4D FC EB 07 C7 45 F8 00 00 00 00 EB 07 C7 45 F8 00 00 00 00 33 D2 83 7D EC 00 0F 94 C2 89 55 EC 8B 45 F0 D1 E8 89 45 F0 8B 4D F0 8B 55 F0 83 EA 01 89 55 F0 85 C9 74 26 83 7D 10 00 74 11 8B 45 10 66 C7 00 5C 00 8B 4D 10 83 C1 02 89 4D 10 8B 55 18 8B 02 83 C0 01 8B 4D 18 89 01 EB CA 8B 55 FC 33 C0 66 8B 02 85 C0 74 20 83 7D EC 00 75 1C 8B 4D FC 33 D2 66 8B 11 83 FA 20 74 0D 8B 45 FC 33 C9 66 8B 08 83 F9 09 75 02 EB 3C 83 7D F8 00 74 28 83 7D 10 00 74 15 8B 55 10 8B 45 FC 66 8B 08 66 89 0A 8B 55 10 83 C2 02 89 55 10 8B 45 18 8B 08 83 C1 01 8B 55 18 89 0A 8B 45 FC 83 C0 02 89 45 FC E9 D1 FE FF FF 83 7D 10 00 74 11 8B 4D 10 66 C7 01 00 00 8B 55 10 83 C2 02 89 55 10 8B 45 18 8B 08 83 C1 01 8B 55 18 89 0A E9 42 FE FF FF 83 7D 0C 00 74 12 8B 45 0C C7 00 00 00 00 00 8B 4D 0C 83 C1 04 89 4D 0C 8B 55 14 8B 02 83 C0 01 8B 4D 14 89 01 8B E5 5D C3 }
	condition:
		$1
}

rule file_119_0_0 {
	meta:
		name = "__mbsdup"
		size = 71
		refs = "0013 _strlen 001f _malloc 0038 _strcpy"
		altNames = "__strdup"
	strings:
		$1 = { 55 8B EC 51 83 7D 08 00 75 04 33 C0 EB 35 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 83 C0 01 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 83 7D FC 00 74 12 8B 4D 08 51 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 08 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_120_0_0 {
	meta:
		name = "__mbsnbset"
		size = 233
		refs = "000e ___ismbcodepage 0022 __strnset"
	strings:
		$1 = { 55 8B EC 83 EC 0C 8B 45 08 89 45 F4 83 3D ?? ?? ?? ?? 00 75 19 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C E9 B7 00 00 00 8B 4D 0C C1 E9 08 88 4D F8 8B 55 F8 81 E2 FF 00 00 00 85 D2 74 70 8B 45 0C 25 FF 00 00 00 88 45 FC 8B 4D 10 8B 55 10 83 EA 01 89 55 10 85 C9 74 53 8B 45 08 33 C9 8A 08 85 C9 74 48 8B 55 10 8B 45 10 83 E8 01 89 45 10 85 D2 74 0C 8B 4D 08 33 D2 8A 51 01 85 D2 75 08 8B 45 08 C6 00 20 EB 24 8B 4D 08 8A 55 F8 88 11 8B 45 08 83 C0 01 89 45 08 8B 4D 08 8A 55 FC 88 11 8B 45 08 83 C0 01 89 45 08 EB 9D EB 2E 8B 4D 10 8B 55 10 83 EA 01 89 55 10 85 C9 74 1E 8B 45 08 33 C9 8A 08 85 C9 74 13 8B 55 08 8A 45 0C 88 02 8B 4D 08 83 C1 01 89 4D 08 EB D2 8B 45 F4 8B E5 5D C3 }
	condition:
		$1
}

rule file_122_0_0 {
	meta:
		name = "_ldiv"
		size = 66
		altNames = "_div"
	strings:
		$1 = { 55 8B EC 83 EC 08 8B 45 08 99 F7 7D 0C 89 45 F8 8B 45 08 99 F7 7D 0C 89 55 FC 83 7D 08 00 7D 18 83 7D FC 00 7E 12 8B 45 F8 83 C0 01 89 45 F8 8B 4D FC 2B 4D 0C 89 4D FC 8B 45 F8 8B 55 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_123_0_0 {
	meta:
		name = "__mbsncpy"
		size = 249
		refs = "000c ___ismbcodepage 0020 _strncpy 004a __mbctype"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 89 45 FC 83 3D ?? ?? ?? ?? 00 75 19 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C E9 C9 00 00 00 83 7D 10 00 0F 84 9B 00 00 00 8B 4D 10 83 E9 01 89 4D 10 8B 55 0C 33 C0 8A 02 33 C9 8A 88 ?? ?? ?? ?? 83 E1 04 85 C9 74 4E 8B 55 08 8B 45 0C 8A 08 88 0A 8B 55 08 83 C2 01 89 55 08 8B 45 0C 83 C0 01 89 45 0C 8B 4D 08 8B 55 0C 8A 02 88 01 8B 4D 08 33 D2 8A 11 8B 45 08 83 C0 01 89 45 08 8B 4D 0C 83 C1 01 89 4D 0C 85 D2 75 09 8B 55 08 C6 42 FE 00 EB 30 EB 29 8B 45 08 8B 4D 0C 8A 11 88 10 8B 45 08 33 C9 8A 08 8B 55 08 83 C2 01 89 55 08 8B 45 0C 83 C0 01 89 45 0C 85 C9 75 02 EB 05 E9 5B FF FF FF 8B 4D 10 8B 55 10 83 EA 01 89 55 10 85 C9 74 11 8B 45 08 C6 00 00 8B 4D 08 83 C1 01 89 4D 08 EB DF 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_124_0_0 {
	meta:
		name = "_ctime"
		size = 45
		refs = "0009 _localtime 001e _asctime"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 83 7D FC 00 74 0E 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_406_0_0 {
	meta:
		name = "__wctime"
		size = 45
		refs = "0009 _localtime 001e __wasctime"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 83 7D FC 00 74 0E 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_125_0_0 {
	meta:
		name = "_fputs"
		size = 181
		refs = "0010 ??_C@_0P@OOIN@string?5?$CB?$DN?5NULL?$AA@ 0019 ??_C@_07IFF@fputs?4c?$AA@ 0020 __CrtDbgReport 003a ??_C@_0P@FHEA@stream?5?$CB?$DN?5NULL?$AA@ 0062 _strlen 0071 __stbuf 008a _fwrite 009d __ftbuf"
	strings:
		$1 = { 55 8B EC 83 EC 0C 53 56 57 83 7D 08 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 2F 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D6 83 7D 0C 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 30 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D6 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 F8 8B 4D 0C 51 8B 55 FC 52 6A 01 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 F4 8B 4D 0C 51 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 08 8B 45 F4 2B 45 FC F7 D8 1B C0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_126_0_0 {
	meta:
		name = "_scanf"
		size = 91
		refs = "0016 ??_C@_0P@LNLA@format?5?$CB?$DN?5NULL?$AA@ 001f ??_C@_07BNNN@scanf?4c?$AA@ 0026 __CrtDbgReport 0042 __iob 0047 __input"
	strings:
		$1 = { 55 8B EC 83 EC 08 53 56 57 8D 45 0C 89 45 FC 83 7D 08 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 34 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D6 8B 55 FC 52 8B 45 08 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 89 45 F8 8B 45 F8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_127_0_0 {
	meta:
		name = "__wcsnicoll"
		size = 123
		refs = "0010 ___lc_handle 0024 __wcsnicmp 002e ___lc_collate_cp 0050 ___crtCompareStringW 0062 _errno"
	strings:
		$1 = { 55 8B EC 51 83 7D 10 00 75 04 33 C0 EB 69 83 3D ?? ?? ?? ?? 00 75 16 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C EB 4A A1 ?? ?? ?? ?? 50 8B 4D 10 51 8B 55 0C 52 8B 45 10 50 8B 4D 08 51 68 01 10 00 00 8B 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 1C 89 45 FC 83 7D FC 00 75 11 C7 05 ?? ?? ?? ?? 16 00 00 00 B8 FF FF FF 7F EB 06 8B 45 FC 83 E8 02 8B E5 5D C3 }
	condition:
		$1
}

rule file_129_0_0 {
	meta:
		name = "??0exception@@QAE@XZ"
		size = 43
		refs = "000c ??_7exception@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC C7 41 04 00 00 00 00 8B 55 FC C7 42 08 00 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_129_1_0 {
	meta:
		name = "??_Gexception@@UAEPAXI@Z"
		size = 46
		refs = "000b ??1exception@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 85 C0 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_144_5_0 {
	meta:
		name = "??_G__non_rtti_object@@UAEPAXI@Z"
		size = 46
		refs = "000b ??1__non_rtti_object@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 85 C0 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_144_12_0 {
	meta:
		name = "??_Gbad_cast@@UAEPAXI@Z"
		size = 46
		refs = "000b ??1bad_cast@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 85 C0 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_144_3_0 {
	meta:
		name = "??_Gbad_typeid@@UAEPAXI@Z"
		size = 46
		refs = "000b ??1bad_typeid@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 85 C0 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_465_1_0 {
	meta:
		name = "??_Gtype_info@@UAEPAXI@Z"
		size = 46
		refs = "000b ??1type_info@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 85 C0 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_129_2_0 {
	meta:
		name = "??0exception@@QAE@ABQBD@Z"
		size = 105
		refs = "000e ??_7exception@@6B@ 0019 _strlen 0025 ??2@YAPAXI@Z 004f _strcpy"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 C7 00 ?? ?? ?? ?? 8B 4D 08 8B 11 52 E8 ?? ?? ?? ?? 83 C4 04 83 C0 01 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 8B 45 F8 8B 4D FC 89 48 04 8B 55 F8 83 7A 04 00 74 15 8B 45 08 8B 08 51 8B 55 F8 8B 42 04 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4D F8 C7 41 08 01 00 00 00 8B 45 F8 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_129_3_0 {
	meta:
		name = "??0exception@@QAE@ABV0@@Z"
		size = 132
		refs = "000e ??_7exception@@6B@ 002f _strlen 003b ??2@YAPAXI@Z 0066 _strcpy"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 C7 00 ?? ?? ?? ?? 8B 4D F8 8B 55 08 8B 42 08 89 41 08 8B 4D F8 83 79 08 00 74 48 8B 55 08 8B 42 04 50 E8 ?? ?? ?? ?? 83 C4 04 83 C0 01 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 8B 4D F8 8B 55 FC 89 51 04 8B 45 F8 83 78 04 00 74 16 8B 4D 08 8B 51 04 52 8B 45 F8 8B 48 04 51 E8 ?? ?? ?? ?? 83 C4 08 EB 0C 8B 55 F8 8B 45 08 8B 48 04 89 4A 04 8B 45 F8 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_129_4_0 {
	meta:
		name = "??4exception@@QAEAAV0@ABV0@@Z"
		size = 44
		refs = "0013 ??1exception@@UAE@XZ 001f ??0exception@@QAE@ABV0@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 3B 45 08 74 14 8B 4D FC E8 ?? ?? ?? ?? 8B 4D 08 51 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_129_5_0 {
	meta:
		name = "??1exception@@UAE@XZ"
		size = 52
		refs = "000e ??_7exception@@6B@ 0029 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 C7 00 ?? ?? ?? ?? 8B 4D F8 83 79 08 00 74 15 8B 55 F8 8B 42 04 89 45 FC 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_129_6_0 {
	meta:
		name = "?what@exception@@UBEPBDXZ"
		size = 33
		refs = "0019 ??_C@_0BC@OIDF@Unknown?5exception?$AA@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 83 78 04 00 74 08 8B 4D FC 8B 41 04 EB 05 B8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_131_0_0 {
	meta:
		name = "__tempnam"
		size = 600
		refs = "0015 ??_C@_03LDNL@TMP?$AA@ 001a _getenv 0031 __access 0053 __stripquote 009e __free_dbg 00a8 ??_C@_01PCFE@?2?$AA@ 00c5 ??_C@_01PJCK@?4?$AA@ 00d4 _strlen 0102 _malloc 0126 _strcat 0155 __mbsrchr 01bb __old_pfxlen 01c6 __tempoff 0203 _free 0221 __ultoa 023c _errno"
	strings:
		$1 = { 55 8B EC 83 EC 1C C7 45 EC 00 00 00 00 C7 45 F0 00 00 00 00 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 83 7D FC 00 74 1E 6A 00 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 83 F8 FF 74 0B 8B 4D FC 89 4D 08 E9 81 00 00 00 83 7D FC 00 74 30 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 F0 83 7D F0 00 74 1B 6A 00 8B 45 F0 50 E8 ?? ?? ?? ?? 83 C4 08 83 F8 FF 74 08 8B 4D F0 89 4D 08 EB 4B 83 7D 08 00 74 13 6A 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 83 F8 FF 75 32 6A 02 8B 45 F0 50 E8 ?? ?? ?? ?? 83 C4 08 6A 00 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 08 83 F8 FF 74 09 C7 45 08 ?? ?? ?? ?? EB 07 C7 45 08 ?? ?? ?? ?? 83 7D 0C 00 74 0F 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 EC 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D EC 8D 54 08 0C 89 55 E4 81 7D E4 04 01 00 00 77 15 8B 45 E4 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 F4 83 7D F4 00 75 05 E9 2C 01 00 00 8B 4D F4 C6 01 00 8B 55 08 52 8B 45 F4 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 08 8D 44 02 FF 89 45 E8 8B 4D E8 0F BE 11 83 FA 5C 75 26 6A 5C 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 39 45 E8 74 11 68 ?? ?? ?? ?? 8B 4D F4 51 E8 ?? ?? ?? ?? 83 C4 08 EB 1C 8B 55 E8 0F BE 02 83 F8 2F 74 11 68 ?? ?? ?? ?? 8B 4D F4 51 E8 ?? ?? ?? ?? 83 C4 08 83 7D 0C 00 74 10 8B 55 0C 52 8B 45 F4 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4D F4 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 F4 03 D0 89 55 FC A1 ?? ?? ?? ?? 3B 45 EC 73 0A C7 05 ?? ?? ?? ?? 01 00 00 00 8B 4D EC 89 0D ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 89 55 F8 A1 ?? ?? ?? ?? 83 C0 01 A3 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 2B 4D F8 81 F9 FF 7F 00 00 76 15 8B 55 F4 52 E8 ?? ?? ?? ?? 83 C4 04 C7 45 F4 00 00 00 00 EB 30 6A 0A 8B 45 FC 50 8B 0D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 0C 6A 00 8B 55 F4 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 A6 83 3D ?? ?? ?? ?? 0D 74 9D 6A 02 8B 45 F0 50 E8 ?? ?? ?? ?? 83 C4 08 8B 45 F4 8B E5 5D C3 }
	condition:
		$1
}

rule file_131_1_0 {
	meta:
		name = "__stripquote"
		size = 176
		refs = "0013 ??_C@_09MEIK@tempnam?4c?$AA@ 001e _strlen 002a __malloc_dbg 00a3 __free_dbg"
	strings:
		$1 = { 55 8B EC 83 EC 0C C7 45 FC 00 00 00 00 68 E4 00 00 00 68 ?? ?? ?? ?? 6A 02 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 83 C0 01 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 F4 83 7D F4 00 75 04 33 C0 EB 6E 8B 4D F4 89 4D F8 8B 55 08 0F BE 02 85 C0 74 3D 8B 4D 08 0F BE 11 83 FA 22 75 14 8B 45 08 83 C0 01 89 45 08 8B 4D FC 83 C1 01 89 4D FC EB 1C 8B 55 F4 8B 45 08 8A 08 88 0A 8B 55 F4 83 C2 01 89 55 F4 8B 45 08 83 C0 01 89 45 08 EB B9 83 7D FC 00 74 0B 8B 4D F4 C6 01 00 8B 45 F8 EB 10 6A 02 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 08 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_132_0_0 {
	meta:
		name = "__wspawnvp"
		size = 27
		refs = "0012 __wspawnvpe"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_311_0_0 {
	meta:
		name = "__spawnvp"
		size = 27
		refs = "0012 __spawnvpe"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_209_0_0 {
	meta:
		name = "_strtol"
		size = 27
		refs = "0012 _strtoxl"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_302_0_0 {
	meta:
		name = "_wcstol"
		size = 27
		refs = "0012 _wcstoxl"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_133_0_0 {
	meta:
		name = "__ZeroTail"
		size = 132
	strings:
		$1 = { 55 8B EC 83 EC 0C 8B 45 0C 99 83 E2 1F 03 C2 C1 F8 05 89 45 F4 8B 45 0C 25 1F 00 00 80 79 05 48 83 C8 E0 40 B9 1F 00 00 00 2B C8 89 4D FC 83 CA FF 8B 4D FC D3 E2 F7 D2 89 55 F8 8B 45 F4 8B 4D 08 8B 14 81 23 55 F8 85 D2 74 04 33 C0 EB 31 8B 45 F4 83 C0 01 89 45 F4 EB 09 8B 4D F4 83 C1 01 89 4D F4 83 7D F4 03 7D 12 8B 55 F4 8B 45 08 83 3C 90 00 74 04 33 C0 EB 07 EB DF B8 01 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_133_1_0 {
	meta:
		name = "__IncMan"
		size = 168
		refs = "0054 ___addl"
	strings:
		$1 = { 55 8B EC 83 EC 10 8B 45 0C 99 83 E2 1F 03 C2 C1 F8 05 89 45 F4 8B 45 0C 25 1F 00 00 80 79 05 48 83 C8 E0 40 B9 1F 00 00 00 2B C8 89 4D FC BA 01 00 00 00 8B 4D FC D3 E2 89 55 F8 8B 45 F4 8B 4D 08 8D 14 81 52 8B 45 F8 50 8B 4D F4 8B 55 08 8B 04 8A 50 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F0 8B 4D F4 83 E9 01 89 4D F4 EB 09 8B 55 F4 83 EA 01 89 55 F4 83 7D F4 00 7C 29 83 7D F0 00 74 23 8B 45 F4 8B 4D 08 8D 14 81 52 6A 01 8B 45 F4 8B 4D 08 8B 14 81 52 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F0 EB C8 8B 45 F0 8B E5 5D C3 }
	condition:
		$1
}

rule file_133_2_0 {
	meta:
		name = "__RoundMan"
		size = 219
		refs = "0071 __ZeroTail 0085 __IncMan"
	strings:
		$1 = { 55 8B EC 83 EC 1C C7 45 E8 00 00 00 00 8B 45 0C 83 E8 01 89 45 FC 8B 4D FC 83 C1 01 89 4D F4 8B 45 F4 99 83 E2 1F 03 C2 C1 F8 05 89 45 EC 8B 55 F4 81 E2 1F 00 00 80 79 05 4A 83 CA E0 42 B8 1F 00 00 00 2B C2 89 45 F8 BA 01 00 00 00 8B 4D F8 D3 E2 89 55 E4 8B 45 EC 8B 4D 08 8B 14 81 23 55 E4 85 D2 74 2A 8B 45 F4 83 C0 01 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 13 8B 55 FC 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 E8 83 CA FF 8B 4D F8 D3 E2 8B 45 EC 8B 4D 08 8B 04 81 23 C2 8B 4D EC 8B 55 08 89 04 8A 8B 45 EC 83 C0 01 89 45 F0 EB 09 8B 4D F0 83 C1 01 89 4D F0 83 7D F0 03 7D 0F 8B 55 F0 8B 45 08 C7 04 90 00 00 00 00 EB E2 8B 45 E8 8B E5 5D C3 }
	condition:
		$1
}

rule file_133_3_0 {
	meta:
		name = "__CopyMan"
		size = 76
	strings:
		$1 = { 55 8B EC 83 EC 0C 8B 45 0C 89 45 FC 8B 4D 08 89 4D F8 C7 45 F4 00 00 00 00 EB 09 8B 55 F4 83 C2 01 89 55 F4 83 7D F4 03 7D 1E 8B 45 F8 8B 4D FC 8B 11 89 10 8B 45 F8 83 C0 04 89 45 F8 8B 4D FC 83 C1 04 89 4D FC EB D3 8B E5 5D C3 }
	condition:
		$1
}

rule file_133_4_0 {
	meta:
		name = "__FillZeroMan"
		size = 47
	strings:
		$1 = { 55 8B EC 51 C7 45 FC 00 00 00 00 EB 09 8B 45 FC 83 C0 01 89 45 FC 83 7D FC 03 7D 0F 8B 4D FC 8B 55 08 C7 04 8A 00 00 00 00 EB E2 8B E5 5D C3 }
	condition:
		$1
}

rule file_133_5_0 {
	meta:
		name = "__IsZeroMan"
		size = 55
	strings:
		$1 = { 55 8B EC 51 C7 45 FC 00 00 00 00 EB 09 8B 45 FC 83 C0 01 89 45 FC 83 7D FC 03 7D 12 8B 4D FC 8B 55 08 83 3C 8A 00 74 04 33 C0 EB 07 EB DF B8 01 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_133_6_0 {
	meta:
		name = "__ShrMan"
		size = 236
	strings:
		$1 = { 55 8B EC 83 EC 18 56 8B 45 0C 99 83 E2 1F 03 C2 C1 F8 05 89 45 E8 8B 45 0C 25 1F 00 00 80 79 05 48 83 C8 E0 40 89 45 FC 83 CA FF 8B 4D FC D3 E2 F7 D2 89 55 EC C7 45 F8 00 00 00 00 C7 45 F4 00 00 00 00 EB 09 8B 45 F4 83 C0 01 89 45 F4 83 7D F4 03 7D 4D 8B 4D F4 8B 55 08 8B 04 8A 23 45 EC 89 45 F0 8B 4D F4 8B 55 08 8B 04 8A 8B 4D FC D3 E8 8B 4D F4 8B 55 08 89 04 8A 8B 45 F4 8B 4D 08 8B 14 81 0B 55 F8 8B 45 F4 8B 4D 08 89 14 81 B9 20 00 00 00 2B 4D FC 8B 55 F0 D3 E2 89 55 F8 EB A4 C7 45 F4 02 00 00 00 EB 09 8B 45 F4 83 E8 01 89 45 F4 83 7D F4 00 7C 2E 8B 4D F4 3B 4D E8 7C 17 8B 55 F4 2B 55 E8 8B 45 F4 8B 4D 08 8B 75 08 8B 14 96 89 14 81 EB 0D 8B 45 F4 8B 4D 08 C7 04 81 00 00 00 00 EB C3 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_133_7_0 {
	meta:
		name = "__ld12cvt"
		size = 578
		refs = "0064 __IsZeroMan 007d __FillZeroMan 0099 __CopyMan 00ac __RoundMan 0120 __ShrMan"
	strings:
		$1 = { 55 8B EC 83 EC 34 8B 45 08 33 C9 66 8B 48 0A 81 E1 FF 7F 00 00 81 E9 FF 3F 00 00 89 4D FC 8B 55 08 33 C0 66 8B 42 0A 25 00 80 00 00 89 45 E0 8B 4D 08 8B 51 06 89 55 E8 8B 45 08 8B 48 02 89 4D EC 8B 55 08 33 C0 66 8B 02 C1 E0 10 89 45 F0 81 7D FC 01 C0 FF FF 75 38 C7 45 F8 00 00 00 00 8D 4D E8 51 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 09 C7 45 E4 00 00 00 00 EB 13 8D 55 E8 52 E8 ?? ?? ?? ?? 83 C4 04 C7 45 E4 02 00 00 00 E9 4C 01 00 00 8D 45 E8 50 8D 4D D0 51 E8 ?? ?? ?? ?? 83 C4 08 8B 55 10 8B 42 08 50 8D 4D E8 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 09 8B 55 FC 83 C2 01 89 55 FC 8B 45 10 8B 4D 10 8B 50 04 2B 51 08 39 55 FC 7D 1F 8D 45 E8 50 E8 ?? ?? ?? ?? 83 C4 04 C7 45 F8 00 00 00 00 C7 45 E4 02 00 00 00 E9 EC 00 00 00 8B 4D 10 8B 55 FC 3B 51 04 7F 65 8B 45 10 8B 48 04 2B 4D FC 89 4D CC 8D 55 D0 52 8D 45 E8 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4D CC 51 8D 55 E8 52 E8 ?? ?? ?? ?? 83 C4 08 8B 45 10 8B 48 08 51 8D 55 E8 52 E8 ?? ?? ?? ?? 83 C4 08 8B 45 10 8B 48 0C 83 C1 01 51 8D 55 E8 52 E8 ?? ?? ?? ?? 83 C4 08 C7 45 F8 00 00 00 00 C7 45 E4 02 00 00 00 EB 7C 8B 45 10 8B 4D FC 3B 08 7C 41 8D 55 E8 52 E8 ?? ?? ?? ?? 83 C4 04 8B 45 E8 0D 00 00 00 80 89 45 E8 8B 4D 10 8B 51 0C 52 8D 45 E8 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4D 10 8B 11 8B 45 10 03 50 14 89 55 F8 C7 45 E4 01 00 00 00 EB 31 8B 4D 10 8B 55 FC 03 51 14 89 55 F8 8B 45 E8 25 FF FF FF 7F 89 45 E8 8B 4D 10 8B 51 0C 52 8D 45 E8 50 E8 ?? ?? ?? ?? 83 C4 08 C7 45 E4 00 00 00 00 8B 4D 10 8B 51 0C 83 C2 01 B8 20 00 00 00 2B C2 89 45 F4 8B 55 F8 8B 4D F4 D3 E2 8B 45 E8 0B C2 8B 4D E0 F7 D9 1B C9 81 E1 00 00 00 80 0B C1 89 45 DC 8B 55 10 83 7A 10 40 75 13 8B 45 0C 8B 4D DC 89 48 04 8B 55 0C 8B 45 EC 89 02 EB 11 8B 4D 10 83 79 10 20 75 08 8B 55 0C 8B 45 DC 89 02 8B 45 E4 8B E5 5D C3 }
	condition:
		$1
}

rule file_133_8_0 {
	meta:
		name = "__ld12tod"
		size = 26
		refs = "0004 _DoubleFormat 0011 __ld12cvt"
	strings:
		$1 = { 55 8B EC 68 ?? ?? ?? ?? 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_133_9_0 {
	meta:
		name = "__ld12tof"
		size = 26
		refs = "0004 _FloatFormat 0011 __ld12cvt"
	strings:
		$1 = { 55 8B EC 68 ?? ?? ?? ?? 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_133_10_0 {
	meta:
		name = "__ld12told"
		size = 191
		refs = "0059 __RoundMan"
	strings:
		$1 = { 55 8B EC 83 EC 18 C7 45 EC 00 00 00 00 8B 45 08 33 C9 66 8B 48 0A 81 E1 FF 7F 00 00 66 89 4D FC 8B 55 08 33 C0 66 8B 42 0A 25 00 80 00 00 66 89 45 E8 8B 4D 08 8B 51 06 89 55 F0 8B 45 08 8B 48 02 89 4D F4 8B 55 08 33 C0 66 8B 02 C1 E0 10 89 45 F8 6A 40 8D 4D F0 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 13 C7 45 F0 00 00 00 80 66 8B 55 FC 66 83 C2 01 66 89 55 FC 8B 45 FC 25 FF FF 00 00 3D FF 7F 00 00 75 07 C7 45 EC 01 00 00 00 8B 4D 0C 8B 55 F0 89 51 04 8B 45 0C 8B 4D F4 89 08 8B 55 E8 81 E2 FF FF 00 00 8B 45 FC 25 FF FF 00 00 0B D0 8B 4D 0C 66 89 51 08 8B 45 EC 8B E5 5D C3 }
	condition:
		$1
}

rule file_133_11_0 {
	meta:
		name = "__atodbl"
		size = 54
		refs = "001b ___strgtold12 002b __ld12tod"
	strings:
		$1 = { 55 8B EC 83 EC 10 6A 00 6A 00 6A 00 6A 00 8B 45 0C 50 8D 4D F0 51 8D 55 F4 52 E8 ?? ?? ?? ?? 83 C4 1C 8B 45 08 50 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_133_13_0 {
	meta:
		name = "__atoflt"
		size = 54
		refs = "001b ___strgtold12 002b __ld12tof"
	strings:
		$1 = { 55 8B EC 83 EC 10 6A 00 6A 00 6A 00 6A 00 8B 45 0C 50 8D 4D F0 51 8D 55 F4 52 E8 ?? ?? ?? ?? 83 C4 1C 8B 45 08 50 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_133_12_0 {
	meta:
		name = "__atoldbl"
		size = 54
		refs = "001b ___strgtold12 002b __ld12told"
	strings:
		$1 = { 55 8B EC 83 EC 10 6A 00 6A 00 6A 00 6A 01 8B 45 0C 50 8D 4D F0 51 8D 55 F4 52 E8 ?? ?? ?? ?? 83 C4 1C 8B 45 08 50 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_134_0_0 {
	meta:
		name = "__forcdecpt"
		size = 168
		refs = "000e _tolower 0025 ___mb_cur_max 0036 __isctype 004a __pctype 006c ___decimal_point"
	strings:
		$1 = { 55 8B EC 83 EC 0C 8B 45 08 0F BE 08 51 E8 ?? ?? ?? ?? 83 C4 04 83 F8 65 74 46 8B 55 08 83 C2 01 89 55 08 83 3D ?? ?? ?? ?? 01 7E 16 6A 04 8B 45 08 0F BE 08 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 F4 EB 18 8B 55 08 0F BE 02 8B 0D ?? ?? ?? ?? 33 D2 66 8B 14 41 83 E2 04 89 55 F4 83 7D F4 00 75 BA 8B 45 08 8A 08 88 4D F8 8B 55 08 A0 ?? ?? ?? ?? 88 02 8B 4D 08 83 C1 01 89 4D 08 8B 55 08 8A 02 88 45 FC 8B 4D 08 8A 55 F8 88 11 8A 45 FC 88 45 F8 8B 4D 08 0F BE 11 8B 45 08 83 C0 01 89 45 08 85 D2 75 D7 8B E5 5D C3 }
	condition:
		$1
}

rule file_134_1_0 {
	meta:
		name = "__cropzeros"
		size = 215
		refs = "0017 ___decimal_point"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 0F BE 08 85 C9 74 1C 8B 55 08 0F BE 02 0F BE 0D ?? ?? ?? ?? 3B C1 74 0B 8B 55 08 83 C2 01 89 55 08 EB DA 8B 45 08 0F BE 08 8B 55 08 83 C2 01 89 55 08 85 C9 0F 84 92 00 00 00 8B 45 08 0F BE 08 85 C9 74 21 8B 55 08 0F BE 02 83 F8 65 74 16 8B 4D 08 0F BE 11 83 FA 45 74 0B 8B 45 08 83 C0 01 89 45 08 EB D5 8B 4D 08 89 4D FC 8B 55 08 83 EA 01 89 55 08 8B 45 08 0F BE 08 83 F9 30 75 0B 8B 55 08 83 EA 01 89 55 08 EB EA 8B 45 08 0F BE 08 0F BE 15 ?? ?? ?? ?? 3B CA 75 09 8B 45 08 83 E8 01 89 45 08 8B 4D 08 83 C1 01 89 4D 08 8B 55 08 8B 45 FC 8A 08 88 0A 8B 55 08 0F BE 02 8B 4D FC 83 C1 01 89 4D FC 85 C0 74 02 EB D8 8B E5 5D C3 }
	condition:
		$1
}

rule file_134_2_0 {
	meta:
		name = "__positive"
		size = 45
		refs = "000b __real@8@00000000000000000000"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 DD 00 DC 1D ?? ?? ?? ?? DF E0 F6 C4 01 75 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_134_3_0 {
	meta:
		name = "__fassign"
		size = 72
		refs = "0015 __atodbl 0035 __atoflt"
	strings:
		$1 = { 55 8B EC 83 EC 0C 83 7D 08 00 74 20 8B 45 10 50 8D 4D F8 51 E8 ?? ?? ?? ?? 83 C4 08 8B 55 0C 8B 45 F8 89 02 8B 4D FC 89 4A 04 EB 18 8B 55 10 52 8D 45 F4 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4D 0C 8B 55 F4 89 11 8B E5 5D C3 }
	condition:
		$1
}

rule file_134_4_0 {
	meta:
		name = "__cftoe"
		size = 444
		refs = "0009 _g_fmt 0013 _g_pflt 003c __shift 0050 __fltout 0082 __fptostr 00c5 ___decimal_point 00cc ??_C@_05OFLO@e?$CL000?$AA@ 00e6 _strcpy"
	strings:
		$1 = { 55 8B EC 83 EC 0C 0F BE 05 ?? ?? ?? ?? 85 C0 74 34 8B 0D ?? ?? ?? ?? 89 4D F8 8B 55 F8 33 C0 83 3A 2D 0F 94 C0 8B 4D 0C 03 C8 89 4D FC 33 D2 83 7D 10 00 0F 9F C2 52 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 EB 44 8B 4D 08 8B 51 04 52 8B 01 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 F8 8B 4D F8 51 8B 55 10 83 C2 01 52 8B 45 F8 33 C9 83 38 2D 0F 94 C1 8B 55 0C 03 D1 33 C0 83 7D 10 00 0F 9F C0 03 D0 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D 0C 89 4D FC 8B 55 F8 83 3A 2D 75 0F 8B 45 FC C6 00 2D 8B 4D FC 83 C1 01 89 4D FC 83 7D 10 00 7E 1F 8B 55 FC 8B 45 FC 8A 48 01 88 0A 8B 55 FC 83 C2 01 89 55 FC 8B 45 FC 8A 0D ?? ?? ?? ?? 88 08 68 ?? ?? ?? ?? 8B 55 FC 03 55 10 0F BE 05 ?? ?? ?? ?? F7 D8 1B C0 40 03 D0 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D 14 00 74 06 8B 4D FC C6 01 45 8B 55 FC 83 C2 01 89 55 FC 8B 45 F8 8B 48 0C 0F BE 11 83 FA 30 0F 84 9E 00 00 00 8B 45 F8 8B 48 04 83 E9 01 89 4D F4 83 7D F4 00 7D 0E 8B 55 F4 F7 DA 89 55 F4 8B 45 FC C6 00 2D 8B 4D FC 83 C1 01 89 4D FC 83 7D F4 64 7C 25 8B 45 F4 99 B9 64 00 00 00 F7 F9 8B 55 FC 8A 0A 02 C8 8B 55 FC 88 0A 8B 45 F4 99 B9 64 00 00 00 F7 F9 89 55 F4 8B 55 FC 83 C2 01 89 55 FC 83 7D F4 0A 7C 25 8B 45 F4 99 B9 0A 00 00 00 F7 F9 8B 55 FC 8A 0A 02 C8 8B 55 FC 88 0A 8B 45 F4 99 B9 0A 00 00 00 F7 F9 89 55 F4 8B 55 FC 83 C2 01 89 55 FC 8B 45 FC 8A 08 02 4D F4 8B 55 FC 88 0A 8B 45 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_134_5_0 {
	meta:
		name = "__cftof"
		size = 388
		refs = "0009 _g_fmt 0013 _g_pflt 002f _g_magnitude 0066 __fltout 0090 __fptostr 00c4 __shift 0105 ___decimal_point 0176 _memset"
	strings:
		$1 = { 55 8B EC 83 EC 10 0F BE 05 ?? ?? ?? ?? 85 C0 74 4A 8B 0D ?? ?? ?? ?? 89 4D F8 8B 55 F8 33 C0 83 3A 2D 0F 94 C0 8B 4D 0C 03 C8 89 4D FC 8B 15 ?? ?? ?? ?? 3B 55 10 75 21 8B 45 FC 03 05 ?? ?? ?? ?? 89 45 F4 8B 4D F4 C6 01 30 8B 55 F4 83 C2 01 89 55 F4 8B 45 F4 C6 00 00 EB 3C 8B 4D 08 8B 51 04 52 8B 01 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 F8 8B 4D F8 51 8B 55 F8 8B 45 10 03 42 04 50 8B 4D F8 33 D2 83 39 2D 0F 94 C2 8B 45 0C 03 C2 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D 0C 89 4D FC 8B 55 F8 83 3A 2D 75 0F 8B 45 FC C6 00 2D 8B 4D FC 83 C1 01 89 4D FC 8B 55 F8 83 7A 04 00 7F 1F 6A 01 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4D FC C6 01 30 8B 55 FC 83 C2 01 89 55 FC EB 0C 8B 45 F8 8B 4D FC 03 48 04 89 4D FC 83 7D 10 00 0F 8E 8B 00 00 00 6A 01 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC 8A 0D ?? ?? ?? ?? 88 08 8B 55 FC 83 C2 01 89 55 FC 8B 45 F8 83 78 04 00 7D 60 0F BE 0D ?? ?? ?? ?? 85 C9 74 0D 8B 55 F8 8B 42 04 F7 D8 89 45 10 EB 26 8B 4D F8 8B 51 04 F7 DA 39 55 10 7D 08 8B 45 10 89 45 F0 EB 0B 8B 4D F8 8B 51 04 F7 DA 89 55 F0 8B 45 F0 89 45 10 8B 4D 10 51 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 08 8B 45 10 50 6A 30 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_134_6_0 {
	meta:
		name = "__cftog"
		size = 244
		refs = "000f __fltout 0017 _g_pflt 0028 _g_magnitude 0052 __fptostr 0072 _g_round_expansion 00ac __cftoe_g 00e9 __cftof_g"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 8B 48 04 51 8B 10 52 E8 ?? ?? ?? ?? 83 C4 08 A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B 48 04 83 E9 01 89 0D ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 33 C0 83 3A 2D 0F 94 C0 8B 4D 0C 03 C8 89 4D FC 8B 15 ?? ?? ?? ?? 52 8B 45 10 50 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 15 ?? ?? ?? ?? 8B 42 04 83 E8 01 33 C9 39 05 ?? ?? ?? ?? 0F 9C C1 88 0D ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 8B 42 04 83 E8 01 A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? FC 7C 0B 8B 0D ?? ?? ?? ?? 3B 4D 10 7C 1A 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 EB 3B 0F BE 05 ?? ?? ?? ?? 85 C0 74 1C 8B 4D FC 0F BE 11 8B 45 FC 83 C0 01 89 45 FC 85 D2 74 02 EB EB 8B 4D FC C6 41 FE 00 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_134_7_0 {
	meta:
		name = "__cftoe_g"
		size = 52
		refs = "0006 _g_fmt 001c __cftoe"
	strings:
		$1 = { 55 8B EC 51 C6 05 ?? ?? ?? ?? 01 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 FC C6 05 ?? ?? ?? ?? 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_134_8_0 {
	meta:
		name = "__cftof_g"
		size = 48
		refs = "0006 _g_fmt 0018 __cftof"
	strings:
		$1 = { 55 8B EC 51 C6 05 ?? ?? ?? ?? 01 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 89 45 FC C6 05 ?? ?? ?? ?? 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_134_9_0 {
	meta:
		name = "__cfltcvt"
		size = 95
		refs = "0020 __cftoe 003c __cftof 0056 __cftog"
	strings:
		$1 = { 55 8B EC 83 7D 10 65 74 06 83 7D 10 45 75 1A 8B 45 18 50 8B 4D 14 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 EB 34 83 7D 10 66 75 16 8B 4D 14 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C EB 18 8B 4D 18 51 8B 55 14 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_134_10_0 {
	meta:
		name = "__shift"
		size = 46
		refs = "000e _strlen 0025 _memmove"
	strings:
		$1 = { 55 8B EC 83 7D 0C 00 74 23 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 83 C0 01 50 8B 4D 08 51 8B 55 08 03 55 0C 52 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_135_0_0 {
	meta:
		name = "__mbsnextc"
		size = 77
		refs = "0016 __mbctype"
	strings:
		$1 = { 55 8B EC 51 C7 45 FC 00 00 00 00 8B 45 08 33 C9 8A 08 33 D2 8A 91 ?? ?? ?? ?? 83 E2 04 85 D2 74 16 8B 45 08 33 C9 8A 08 C1 E1 08 89 4D FC 8B 55 08 83 C2 01 89 55 08 8B 45 08 33 C9 8A 08 8B 55 FC 03 D1 89 55 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_136_0_0 {
	meta:
		name = "__mbsnbicmp"
		size = 827
		refs = "0015 ___ismbcodepage 0029 __strnicmp 006a __mbctype 0100 ___mbulinfo 018f __mbcasemap"
	strings:
		$1 = { 55 8B EC 83 EC 14 83 7D 10 00 75 07 33 C0 E9 24 03 00 00 83 3D ?? ?? ?? ?? 00 75 19 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C E9 02 03 00 00 8B 45 10 8B 4D 10 83 E9 01 89 4D 10 85 C0 0F 84 EC 02 00 00 8B 55 08 66 0F B6 02 66 89 45 FC 8B 4D 08 83 C1 01 89 4D 08 8B 55 FC 81 E2 FF 00 00 00 33 C0 8A 82 ?? ?? ?? ?? 83 E0 04 85 C0 0F 84 F0 00 00 00 83 7D 10 00 75 3C 66 C7 45 FC 00 00 8B 4D 0C 33 D2 8A 11 33 C0 8A 82 ?? ?? ?? ?? 83 E0 04 85 C0 74 09 C7 45 F4 00 00 00 00 EB 0A 8B 4D 0C 33 D2 8A 11 89 55 F4 66 8B 45 F4 66 89 45 F8 E9 2C 02 00 00 8B 4D 08 33 D2 8A 11 85 D2 75 0B 66 C7 45 FC 00 00 E9 96 00 00 00 8B 45 FC 25 FF FF 00 00 C1 E0 08 8B 4D 08 33 D2 8A 11 0B C2 66 89 45 FC 8B 45 08 83 C0 01 89 45 08 8B 4D FC 81 E1 FF FF 00 00 33 D2 66 8B 15 ?? ?? ?? ?? 3B CA 7C 26 8B 45 FC 25 FF FF 00 00 33 C9 66 8B 0D ?? ?? ?? ?? 3B C1 7F 11 66 8B 55 FC 66 03 15 ?? ?? ?? ?? 66 89 55 FC EB 39 8B 45 FC 25 FF FF 00 00 33 C9 66 8B 0D ?? ?? ?? ?? 3B C1 7C 24 8B 55 FC 81 E2 FF FF 00 00 33 C0 66 A1 ?? ?? ?? ?? 3B D0 7F 0F 66 8B 4D FC 66 03 0D ?? ?? ?? ?? 66 89 4D FC EB 42 8B 55 FC 81 E2 FF FF 00 00 33 C0 8A 82 ?? ?? ?? ?? 83 E0 10 83 F8 10 75 16 8B 4D FC 81 E1 FF FF 00 00 33 D2 8A 91 ?? ?? ?? ?? 89 55 F0 EB 0B 8B 45 FC 25 FF FF 00 00 89 45 F0 66 8B 4D F0 66 89 4D FC 8B 55 0C 66 0F B6 02 66 89 45 F8 8B 4D 0C 83 C1 01 89 4D 0C 8B 55 F8 81 E2 FF 00 00 00 33 C0 8A 82 ?? ?? ?? ?? 83 E0 04 85 C0 0F 84 CA 00 00 00 83 7D 10 00 75 0B 66 C7 45 F8 00 00 E9 FB 00 00 00 8B 4D 10 83 E9 01 89 4D 10 8B 55 0C 33 C0 8A 02 85 C0 75 0B 66 C7 45 F8 00 00 E9 98 00 00 00 8B 4D F8 81 E1 FF FF 00 00 C1 E1 08 8B 55 0C 33 C0 8A 02 0B C8 66 89 4D F8 8B 4D 0C 83 C1 01 89 4D 0C 8B 55 F8 81 E2 FF FF 00 00 33 C0 66 A1 ?? ?? ?? ?? 3B D0 7C 27 8B 4D F8 81 E1 FF FF 00 00 33 D2 66 8B 15 ?? ?? ?? ?? 3B CA 7F 11 66 8B 45 F8 66 03 05 ?? ?? ?? ?? 66 89 45 F8 EB 3A 8B 4D F8 81 E1 FF FF 00 00 33 D2 66 8B 15 ?? ?? ?? ?? 3B CA 7C 24 8B 45 F8 25 FF FF 00 00 33 C9 66 8B 0D ?? ?? ?? ?? 3B C1 7F 0F 66 8B 55 F8 66 03 15 ?? ?? ?? ?? 66 89 55 F8 EB 42 8B 45 F8 25 FF FF 00 00 33 C9 8A 88 ?? ?? ?? ?? 83 E1 10 83 F9 10 75 16 8B 55 F8 81 E2 FF FF 00 00 33 C0 8A 82 ?? ?? ?? ?? 89 45 EC EB 0C 8B 4D F8 81 E1 FF FF 00 00 89 4D EC 66 8B 55 EC 66 89 55 F8 8B 45 FC 25 FF FF 00 00 8B 4D F8 81 E1 FF FF 00 00 3B C1 74 23 8B 55 FC 81 E2 FF FF 00 00 8B 45 F8 25 FF FF 00 00 33 C9 3B D0 0F 9E C1 49 83 E1 02 83 C1 FF 8B C1 EB 18 8B 55 FC 81 E2 FF FF 00 00 85 D2 75 04 33 C0 EB 07 E9 00 FD FF FF 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_137_0_0 {
	meta:
		name = "__open"
		size = 63
		refs = "0034 __sopen"
	strings:
		$1 = { 55 8B EC 83 EC 08 8D 45 10 89 45 F8 8B 4D F8 83 C1 04 89 4D F8 8B 55 F8 8B 42 FC 89 45 FC C7 45 F8 00 00 00 00 8B 4D FC 51 6A 40 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_292_0_0 {
	meta:
		name = "__wopen"
		size = 63
		refs = "0034 __wsopen"
	strings:
		$1 = { 55 8B EC 83 EC 08 8D 45 10 89 45 F8 8B 4D F8 83 C1 04 89 4D F8 8B 55 F8 8B 42 FC 89 45 FC C7 45 F8 00 00 00 00 8B 4D FC 51 6A 40 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_137_1_0 {
	meta:
		name = "__sopen"
		size = 1264
		refs = "005e __fmode 00ab _errno 00b5 __doserrno 00e1 $L17796 00e8 $L17797 0213 __umaskval 0294 __alloc_osfhnd 02d9 __imp__CreateFileA@28 02e8 __imp__GetLastError@0 02ee __dosmaperr 0303 __imp__GetFileType@4 0316 __imp__CloseHandle@4 0359 __set_osfhnd 0377 ___pioinfo 03b9 __lseek 03da __close 03fa __read 0417 __chsize 04ab $L17732 04af $L17733 04b3 $L17734 04b7 $L17735 04bb $L17736"
	strings:
		$1 = { 55 8B EC 83 EC 48 C7 45 DC 0C 00 00 00 C7 45 E0 00 00 00 00 8B 45 0C 25 80 00 00 00 85 C0 74 0D C7 45 E4 00 00 00 00 C6 45 C8 10 EB 0B C7 45 E4 01 00 00 00 C6 45 C8 00 8B 4D 0C 81 E1 00 80 00 00 85 C9 75 2C 8B 55 0C 81 E2 00 40 00 00 85 D2 74 0A 8A 45 C8 0C 80 88 45 C8 EB 15 81 3D ?? ?? ?? ?? 00 80 00 00 74 09 8A 4D C8 80 C9 80 88 4D C8 8B 55 0C 83 E2 03 89 55 C0 83 7D C0 00 74 0E 83 7D C0 01 74 11 83 7D C0 02 74 14 EB 1B C7 45 CC 00 00 00 80 EB 2E C7 45 CC 00 00 00 40 EB 25 C7 45 CC 00 00 00 C0 EB 1C C7 05 ?? ?? ?? ?? 16 00 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 83 C8 FF E9 E2 03 00 00 8B 45 10 89 45 BC 8B 4D BC 83 E9 10 89 4D BC 83 7D BC 30 77 36 8B 45 BC 33 D2 8A 90 ?? ?? ?? ?? FF 24 95 ?? ?? ?? ?? C7 45 F8 00 00 00 00 EB 37 C7 45 F8 01 00 00 00 EB 2E C7 45 F8 02 00 00 00 EB 25 C7 45 F8 03 00 00 00 EB 1C C7 05 ?? ?? ?? ?? 16 00 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 83 C8 FF E9 7B 03 00 00 8B 4D 0C 81 E1 00 07 00 00 89 4D B8 81 7D B8 00 04 00 00 7F 37 81 7D B8 00 04 00 00 74 4B 81 7D B8 00 02 00 00 7F 1A 81 7D B8 00 02 00 00 74 54 83 7D B8 00 74 33 81 7D B8 00 01 00 00 74 33 EB 55 81 7D B8 00 03 00 00 74 43 EB 4A 81 7D B8 00 05 00 00 74 26 81 7D B8 00 06 00 00 74 26 81 7D B8 00 07 00 00 74 14 EB 2D C7 45 E8 03 00 00 00 EB 40 C7 45 E8 04 00 00 00 EB 37 C7 45 E8 01 00 00 00 EB 2E C7 45 E8 05 00 00 00 EB 25 C7 45 E8 02 00 00 00 EB 1C C7 05 ?? ?? ?? ?? 16 00 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 83 C8 FF E9 C9 02 00 00 C7 45 D8 80 00 00 00 8B 55 0C 81 E2 00 01 00 00 85 D2 74 3D 8D 45 14 89 45 D4 8B 4D D4 83 C1 04 89 4D D4 8B 55 D4 8B 42 FC 89 45 F0 C7 45 D4 00 00 00 00 8B 0D ?? ?? ?? ?? F7 D1 8B 55 F0 23 D1 81 E2 80 00 00 00 85 D2 75 07 C7 45 D8 01 00 00 00 8B 45 0C 83 E0 40 85 C0 74 18 8B 4D D8 81 C9 00 00 00 04 89 4D D8 8B 55 CC 81 CA 00 00 01 00 89 55 CC 8B 45 0C 25 00 10 00 00 85 C0 74 09 8B 4D D8 80 CD 01 89 4D D8 8B 55 0C 83 E2 20 85 D2 74 0D 8B 45 D8 0D 00 00 00 08 89 45 D8 EB 16 8B 4D 0C 83 E1 10 85 C9 74 0C 8B 55 D8 81 CA 00 00 00 10 89 55 D8 E8 ?? ?? ?? ?? 89 45 EC 83 7D EC FF 75 1C C7 05 ?? ?? ?? ?? 18 00 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 83 C8 FF E9 EA 01 00 00 6A 00 8B 45 D8 50 8B 4D E8 51 8D 55 DC 52 8B 45 F8 50 8B 4D CC 51 8B 55 08 52 FF 15 ?? ?? ?? ?? 89 45 FC 83 7D FC FF 75 17 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 83 C8 FF E9 AA 01 00 00 8B 45 FC 50 FF 15 ?? ?? ?? ?? 89 45 F4 83 7D F4 00 75 21 8B 4D FC 51 FF 15 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 83 C8 FF E9 76 01 00 00 83 7D F4 02 75 0B 8A 55 C8 80 CA 40 88 55 C8 EB 0E 83 7D F4 03 75 08 8A 45 C8 0C 08 88 45 C8 8B 4D FC 51 8B 55 EC 52 E8 ?? ?? ?? ?? 83 C4 08 8A 45 C8 0C 01 88 45 C8 8B 4D EC C1 F9 05 8B 55 EC 83 E2 1F 8B 04 8D ?? ?? ?? ?? 8A 4D C8 88 4C D0 04 0F BE 55 C8 83 E2 48 85 D2 0F 85 CD 00 00 00 0F BE 45 C8 25 80 00 00 00 85 C0 0F 84 BC 00 00 00 8B 4D 0C 83 E1 02 85 C9 0F 84 AE 00 00 00 6A 02 6A FF 8B 55 EC 52 E8 ?? ?? ?? ?? 83 C4 0C 89 45 C4 83 7D C4 FF 75 22 81 3D ?? ?? ?? ?? 83 00 00 00 74 14 8B 45 EC 50 E8 ?? ?? ?? ?? 83 C4 04 83 C8 FF E9 BE 00 00 00 EB 73 C6 45 D0 00 6A 01 8D 4D D0 51 8B 55 EC 52 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 2F 0F BE 45 D0 83 F8 1A 75 26 8B 4D C4 51 8B 55 EC 52 E8 ?? ?? ?? ?? 83 C4 08 83 F8 FF 75 11 8B 45 EC 50 E8 ?? ?? ?? ?? 83 C4 04 83 C8 FF EB 73 6A 00 6A 00 8B 4D EC 51 E8 ?? ?? ?? ?? 83 C4 0C 89 45 C4 83 7D C4 FF 75 11 8B 55 EC 52 E8 ?? ?? ?? ?? 83 C4 04 83 C8 FF EB 49 0F BE 45 C8 83 E0 48 85 C0 75 3B 8B 4D 0C 83 E1 08 85 C9 74 31 8B 55 EC C1 FA 05 8B 45 EC 83 E0 1F 8B 0C 95 ?? ?? ?? ?? 8A 54 C1 04 80 CA 20 8B 45 EC C1 F8 05 8B 4D EC 83 E1 1F 8B 04 85 ?? ?? ?? ?? 88 54 C8 04 8B 45 EC 8B E5 5D C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 01 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 02 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 03 }
	condition:
		$1
}

rule file_138_0_0 {
	meta:
		name = "__fpmath"
		size = 33
		refs = "0007 __cfltcvt_init 000c __ms_p5_mp_test_fdiv 0011 __adjust_fdiv 0016 __setdefaultprecision"
	strings:
		$1 = { 55 8B EC 53 56 57 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? DB E2 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_138_2_0 {
	meta:
		name = "__cfltcvt_init"
		size = 65
		refs = "0005 __cfltcvt_tab 0009 __cfltcvt 0013 __cropzeros 001d __fassign 0027 __forcdecpt 0031 __positive"
	strings:
		$1 = { 55 8B EC C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_138_3_0 {
	meta:
		name = "___setfflag"
		size = 28
		refs = "0005 ___fastflag"
	strings:
		$1 = { 55 8B EC 51 A1 ?? ?? ?? ?? 89 45 FC 8B 4D 08 89 0D ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_564_0_0 {
	meta:
		name = "?_set_new_handler@@YAP6AHI@ZP6AHI@Z@Z"
		size = 28
		refs = "0005 ?_pnhHeap@@3P6AHI@ZA"
	strings:
		$1 = { 55 8B EC 51 A1 ?? ?? ?? ?? 89 45 FC 8B 4D 08 89 0D ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_418_19_0 {
	meta:
		name = "__CrtSetAllocHook"
		size = 28
		refs = "0005 __pfnAllocHook"
	strings:
		$1 = { 55 8B EC 51 A1 ?? ?? ?? ?? 89 45 FC 8B 4D 08 89 0D ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_418_17_0 {
	meta:
		name = "__CrtSetBreakAlloc"
		size = 28
		refs = "0005 __crtBreakAlloc"
	strings:
		$1 = { 55 8B EC 51 A1 ?? ?? ?? ?? 89 45 FC 8B 4D 08 89 0D ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_418_27_0 {
	meta:
		name = "__CrtSetDumpClient"
		size = 28
		refs = "0005 __pfnDumpClient"
	strings:
		$1 = { 55 8B EC 51 A1 ?? ?? ?? ?? 89 45 FC 8B 4D 08 89 0D ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_150_3_0 {
	meta:
		name = "__CrtSetReportHook"
		size = 28
		refs = "0005 __pfnReportHook"
	strings:
		$1 = { 55 8B EC 51 A1 ?? ?? ?? ?? 89 45 FC 8B 4D 08 89 0D ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_139_0_0 {
	meta:
		name = "__cinit"
		size = 56
		refs = "0005 __FPinit 0013 ___xi_z 0018 ___xi_a 001d __initterm 0025 ___xc_z 002a ___xc_a"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? 00 74 06 FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 08 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_139_1_0 {
	meta:
		name = "_exit"
		size = 21
		refs = "000c _doexit"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_139_2_0 {
	meta:
		name = "__exit"
		size = 21
		refs = "000c _doexit"
	strings:
		$1 = { 55 8B EC 6A 00 6A 01 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_139_3_0 {
	meta:
		name = "__cexit"
		size = 19
		refs = "000a _doexit"
	strings:
		$1 = { 55 8B EC 6A 01 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_139_4_0 {
	meta:
		name = "__c_exit"
		size = 19
		refs = "000a _doexit"
	strings:
		$1 = { 55 8B EC 6A 01 6A 01 6A 00 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_139_5_0 {
	meta:
		name = "_doexit"
		size = 217
		refs = "0006 __C_Exit_Done 0013 __imp__GetCurrentProcess@0 001a __imp__TerminateProcess@8 0020 __C_Termination_Done 002d __exitflag 0039 ___onexitbegin 0042 ___onexitend 006d ___xp_z 0072 ___xp_a 0077 __initterm 007f ___xt_z 0084 ___xt_a 0092 _?fExit@?1??doexit@@9@9 009c __CrtSetDbgFlag 00b5 __CrtDumpMemoryLeaks 00d1 __imp__ExitProcess@4"
	strings:
		$1 = { 55 8B EC 51 83 3D ?? ?? ?? ?? 01 75 11 8B 45 08 50 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 01 00 00 00 8A 4D 10 88 0D ?? ?? ?? ?? 83 7D 0C 00 75 47 83 3D ?? ?? ?? ?? 00 74 2C 8B 15 ?? ?? ?? ?? 89 55 FC 8B 45 FC 83 E8 04 89 45 FC 8B 4D FC 3B 0D ?? ?? ?? ?? 72 0F 8B 55 FC 83 3A 00 74 05 8B 45 FC FF 10 EB DD 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 08 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 08 83 3D ?? ?? ?? ?? 00 75 20 6A FF E8 ?? ?? ?? ?? 83 C4 04 83 E0 20 85 C0 74 0F C7 05 ?? ?? ?? ?? 01 00 00 00 E8 ?? ?? ?? ?? 83 7D 10 00 74 02 EB 14 C7 05 ?? ?? ?? ?? 01 00 00 00 8B 4D 08 51 FF 15 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_139_6_0 {
	meta:
		name = "__initterm"
		size = 37
	strings:
		$1 = { 55 8B EC 8B 45 08 3B 45 0C 73 18 8B 4D 08 83 39 00 74 05 8B 55 08 FF 12 8B 45 08 83 C0 04 89 45 08 EB E0 5D C3 }
	condition:
		$1
}

rule file_140_0_0 {
	meta:
		name = "__getstream"
		size = 238
		refs = "0024 __nstream 002e ___piob 0066 ??_C@_08HJEP@stream?4c?$AA@ 006f __malloc_dbg"
	strings:
		$1 = { 55 8B EC 83 EC 08 C7 45 F8 00 00 00 00 C7 45 FC 00 00 00 00 EB 09 8B 45 FC 83 C0 01 89 45 FC 8B 4D FC 3B 0D ?? ?? ?? ?? 7D 7C 8B 55 FC A1 ?? ?? ?? ?? 83 3C 90 00 74 2B 8B 4D FC 8B 15 ?? ?? ?? ?? 8B 04 8A 8B 48 0C 81 E1 83 00 00 00 85 C9 75 10 8B 55 FC A1 ?? ?? ?? ?? 8B 0C 90 89 4D F8 EB 45 EB 3E 6A 55 68 ?? ?? ?? ?? 6A 02 6A 20 E8 ?? ?? ?? ?? 83 C4 10 8B 55 FC 8B 0D ?? ?? ?? ?? 89 04 91 8B 55 FC A1 ?? ?? ?? ?? 83 3C 90 00 74 0F 8B 4D FC 8B 15 ?? ?? ?? ?? 8B 04 8A 89 45 F8 EB 05 E9 70 FF FF FF 83 7D F8 00 74 3B 8B 4D F8 C7 41 04 00 00 00 00 8B 55 F8 C7 42 0C 00 00 00 00 8B 45 F8 C7 40 08 00 00 00 00 8B 4D F8 C7 01 00 00 00 00 8B 55 F8 C7 42 1C 00 00 00 00 8B 45 F8 C7 40 10 FF FF FF FF 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_141_0_0 {
	meta:
		name = "___get_qualified_locale"
		size = 512
		refs = "0008 _pfnGetLocaleInfoA 0010 _IsThisWindowsNT 0019 __imp__GetLocaleInfoA@16 0025 _crtGetLocaleInfoA@16 0039 _GetLcidFromDefault 0047 _pchLanguage 0068 ___rg_language 006d _TranslateName 007c _pchCountry 009d ___rg_country 00ab _iLcidState 00e0 _GetLcidFromLangCountry 00e7 _GetLcidFromLanguage 0103 _GetLcidFromCountry 0129 _ProcessCodePage 0144 __imp__IsValidCodePage@4 0157 _lcidLanguage 015e __imp__IsValidLocale@8 0185 _lcidCountry 01f0 __itoa"
	strings:
		$1 = { 55 8B EC 83 EC 08 83 3D ?? ?? ?? ?? 00 75 23 E8 ?? ?? ?? ?? 85 C0 74 0A A1 ?? ?? ?? ?? 89 45 F8 EB 07 C7 45 F8 ?? ?? ?? ?? 8B 4D F8 89 0D ?? ?? ?? ?? 83 7D 08 00 75 0A E8 ?? ?? ?? ?? E9 CC 00 00 00 8B 55 08 89 15 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 74 20 A1 ?? ?? ?? ?? 0F BE 08 85 C9 74 14 68 ?? ?? ?? ?? 6A 40 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 55 08 83 C2 40 89 15 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 74 20 A1 ?? ?? ?? ?? 0F BE 08 85 C9 74 14 68 ?? ?? ?? ?? 6A 16 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C C7 05 ?? ?? ?? ?? 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 31 8B 15 ?? ?? ?? ?? 0F BE 02 85 C0 74 24 83 3D ?? ?? ?? ?? 00 74 14 8B 0D ?? ?? ?? ?? 0F BE 11 85 D2 74 07 E8 ?? ?? ?? ?? EB 05 E8 ?? ?? ?? ?? EB 21 83 3D ?? ?? ?? ?? 00 74 13 A1 ?? ?? ?? ?? 0F BE 08 85 C9 74 07 E8 ?? ?? ?? ?? EB 05 E8 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 75 07 33 C0 E9 DE 00 00 00 8B 55 08 81 C2 80 00 00 00 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 83 7D FC 00 74 13 8B 45 FC 25 FF FF 00 00 50 FF 15 ?? ?? ?? ?? 85 C0 75 07 33 C0 E9 A9 00 00 00 6A 01 8B 0D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 85 C0 75 07 33 C0 E9 8F 00 00 00 83 7D 0C 00 74 25 8B 55 0C 66 A1 ?? ?? ?? ?? 66 89 02 8B 4D 0C 66 8B 15 ?? ?? ?? ?? 66 89 51 02 8B 45 0C 66 8B 4D FC 66 89 48 04 83 7D 10 00 74 59 6A 40 8B 55 10 52 68 01 10 00 00 A1 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 75 04 33 C0 EB 3F 6A 40 8B 4D 10 83 C1 40 51 68 02 10 00 00 8B 15 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 85 C0 75 04 33 C0 EB 1C 6A 0A 8B 45 10 05 80 00 00 00 50 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 0C B8 01 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_141_1_0 {
	meta:
		name = "_TranslateName"
		size = 130
		refs = "0041 __stricmp"
	strings:
		$1 = { 55 8B EC 83 EC 0C C7 45 F8 01 00 00 00 C7 45 F4 00 00 00 00 8B 45 F4 3B 45 0C 7F 62 83 7D F8 00 74 5C 8B 45 F4 03 45 0C 99 2B C2 D1 F8 89 45 FC 8B 4D FC 8B 55 08 8B 04 CA 50 8B 4D 10 8B 11 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 F8 83 7D F8 00 75 11 8B 45 FC 8B 4D 08 8D 54 C1 04 8B 45 10 89 10 EB 1A 83 7D F8 00 7D 0B 8B 4D FC 83 E9 01 89 4D 0C EB 09 8B 55 FC 83 C2 01 89 55 F4 EB 96 8B E5 5D C3 }
	condition:
		$1
}

rule file_141_2_0 {
	meta:
		name = "_GetLcidFromLangCountry"
		size = 186
		refs = "0005 _pchLanguage 000b _strlen 001c _bAbbrevLanguage 0022 _pchCountry 0039 _bAbbrevCountry 003f _lcidLanguage 0061 _GetPrimaryLen 006f _iPrimaryLen 0076 _LangCountryEnumProc@4 007c __imp__EnumSystemLocalesA@8 0082 _iLcidState"
	strings:
		$1 = { 55 8B EC 51 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 33 C9 83 F8 03 0F 94 C1 89 0D ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 04 33 C9 83 F8 03 0F 94 C1 89 0D ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 09 C7 45 FC 02 00 00 00 EB 12 8B 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 8B 45 FC A3 ?? ?? ?? ?? 6A 01 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 81 E1 00 01 00 00 85 C9 74 1C 8B 15 ?? ?? ?? ?? 81 E2 00 02 00 00 85 D2 74 0C A1 ?? ?? ?? ?? 83 E0 07 85 C0 75 0A C7 05 ?? ?? ?? ?? 00 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_141_3_0 {
	meta:
		name = "_LangCountryEnumProc@4"
		size = 804
		refs = "000b _LcidFromHexString 001d _bAbbrevCountry 0038 _pfnGetLocaleInfoA 0042 _iLcidState 005a _pchCountry 0060 __stricmp 0077 _bAbbrevLanguage 00b4 _pchLanguage 00db _lcidCountry 00e7 _lcidLanguage 0103 _iPrimaryLen 011c __strnicmp 0144 _strlen 016f _TestDefaultCountry 0261 _TestDefaultLanguage"
	strings:
		$1 = { 55 8B EC 83 EC 7C 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 84 6A 78 8D 4D 88 51 8B 15 ?? ?? ?? ?? F7 DA 1B D2 81 E2 05 F0 FF FF 81 C2 02 10 00 00 52 8B 45 84 50 FF 15 ?? ?? ?? ?? 85 C0 75 14 C7 05 ?? ?? ?? ?? 00 00 00 00 B8 01 00 00 00 E9 CA 02 00 00 8D 4D 88 51 8B 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 0F 85 20 01 00 00 6A 78 8D 45 88 50 8B 0D ?? ?? ?? ?? F7 D9 1B C9 81 E1 02 F0 FF FF 81 C1 01 10 00 00 51 8B 55 84 52 FF 15 ?? ?? ?? ?? 85 C0 75 14 C7 05 ?? ?? ?? ?? 00 00 00 00 B8 01 00 00 00 E9 70 02 00 00 8D 45 88 50 8B 0D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 2B 8B 15 ?? ?? ?? ?? 81 CA 04 03 00 00 89 15 ?? ?? ?? ?? 8B 45 84 A3 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 89 0D ?? ?? ?? ?? E9 9F 00 00 00 8B 15 ?? ?? ?? ?? 83 E2 02 85 D2 0F 85 8E 00 00 00 83 3D ?? ?? ?? ?? 00 74 53 A1 ?? ?? ?? ?? 50 8D 4D 88 51 8B 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 36 A1 ?? ?? ?? ?? 0C 02 A3 ?? ?? ?? ?? 8B 4D 84 89 0D ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 04 3B 05 ?? ?? ?? ?? 75 08 8B 45 84 A3 ?? ?? ?? ?? EB 32 8B 0D ?? ?? ?? ?? 83 E1 01 85 C9 75 25 8B 55 84 52 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 15 A1 ?? ?? ?? ?? 0C 01 A3 ?? ?? ?? ?? 8B 4D 84 89 0D ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 81 E2 00 03 00 00 81 FA 00 03 00 00 0F 84 6A 01 00 00 6A 78 8D 45 88 50 8B 0D ?? ?? ?? ?? F7 D9 1B C9 81 E1 02 F0 FF FF 81 C1 01 10 00 00 51 8B 55 84 52 FF 15 ?? ?? ?? ?? 85 C0 75 14 C7 05 ?? ?? ?? ?? 00 00 00 00 B8 01 00 00 00 E9 38 01 00 00 8D 45 88 50 8B 0D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 0F 85 AF 00 00 00 8B 15 ?? ?? ?? ?? 80 CE 02 89 15 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 74 21 A1 ?? ?? ?? ?? 80 CC 01 A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 75 09 8B 4D 84 89 0D ?? ?? ?? ?? EB 74 83 3D ?? ?? ?? ?? 00 74 4C 8B 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 04 3B 05 ?? ?? ?? ?? 75 35 6A 01 8B 45 84 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 21 8B 0D ?? ?? ?? ?? 80 CD 01 89 0D ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 75 09 8B 55 84 89 15 ?? ?? ?? ?? EB 1F A1 ?? ?? ?? ?? 80 CC 01 A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 75 09 8B 4D 84 89 0D ?? ?? ?? ?? EB 61 83 3D ?? ?? ?? ?? 00 75 58 83 3D ?? ?? ?? ?? 00 74 4F 8B 15 ?? ?? ?? ?? 52 8D 45 88 50 8B 0D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 31 6A 00 8B 55 84 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 1F A1 ?? ?? ?? ?? 80 CC 01 A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 75 09 8B 4D 84 89 0D ?? ?? ?? ?? A1 ?? ?? ?? ?? 83 E0 04 F7 D8 1B C0 40 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_141_4_0 {
	meta:
		name = "_GetLcidFromLanguage"
		size = 116
		refs = "0005 _pchLanguage 000b _strlen 001c _bAbbrevLanguage 003a _GetPrimaryLen 0048 _iPrimaryLen 004f _LanguageEnumProc@4 0055 __imp__EnumSystemLocalesA@8 005b _iLcidState"
	strings:
		$1 = { 55 8B EC 51 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 33 C9 83 F8 03 0F 94 C1 89 0D ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 74 09 C7 45 FC 02 00 00 00 EB 12 8B 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 8B 45 FC A3 ?? ?? ?? ?? 6A 01 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 83 E1 04 85 C9 75 0A C7 05 ?? ?? ?? ?? 00 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_141_5_0 {
	meta:
		name = "_LanguageEnumProc@4"
		size = 287
		refs = "000b _LcidFromHexString 001d _bAbbrevLanguage 0038 _pfnGetLocaleInfoA 0042 _iLcidState 005a _pchLanguage 0060 __stricmp 007b _TestDefaultLanguage 008b _lcidCountry 0097 _lcidLanguage 00b4 _iPrimaryLen 00cd __strnicmp"
	strings:
		$1 = { 55 8B EC 83 EC 7C 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 84 6A 78 8D 4D 88 51 8B 15 ?? ?? ?? ?? F7 DA 1B D2 81 E2 02 F0 FF FF 81 C2 01 10 00 00 52 8B 45 84 50 FF 15 ?? ?? ?? ?? 85 C0 75 14 C7 05 ?? ?? ?? ?? 00 00 00 00 B8 01 00 00 00 E9 C5 00 00 00 8D 4D 88 51 8B 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 3E 83 3D ?? ?? ?? ?? 00 75 12 6A 01 8B 45 84 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 21 8B 4D 84 89 0D ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 89 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? 0C 04 A3 ?? ?? ?? ?? EB 63 83 3D ?? ?? ?? ?? 00 75 5A 83 3D ?? ?? ?? ?? 00 74 51 8B 0D ?? ?? ?? ?? 51 8D 55 88 52 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 34 6A 00 8B 4D 84 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 22 8B 55 84 89 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? A3 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 83 C9 04 89 0D ?? ?? ?? ?? A1 ?? ?? ?? ?? 83 E0 04 F7 D8 1B C0 40 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_141_6_0 {
	meta:
		name = "_GetLcidFromCountry"
		size = 69
		refs = "0004 _pchCountry 000a _strlen 001b _bAbbrevCountry 0022 _CountryEnumProc@4 0028 __imp__EnumSystemLocalesA@8 002e _iLcidState"
	strings:
		$1 = { 55 8B EC A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 33 C9 83 F8 03 0F 94 C1 89 0D ?? ?? ?? ?? 6A 01 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 83 E2 04 85 D2 75 0A C7 05 ?? ?? ?? ?? 00 00 00 00 5D C3 }
	condition:
		$1
}

rule file_141_7_0 {
	meta:
		name = "_CountryEnumProc@4"
		size = 172
		refs = "000b _LcidFromHexString 001d _bAbbrevCountry 0038 _pfnGetLocaleInfoA 0042 _iLcidState 0057 _pchCountry 005d __stricmp 006d _TestDefaultCountry 007d _lcidCountry 0089 _lcidLanguage"
	strings:
		$1 = { 55 8B EC 83 EC 7C 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 84 6A 78 8D 4D 88 51 8B 15 ?? ?? ?? ?? F7 DA 1B D2 81 E2 05 F0 FF FF 81 C2 02 10 00 00 52 8B 45 84 50 FF 15 ?? ?? ?? ?? 85 C0 75 11 C7 05 ?? ?? ?? ?? 00 00 00 00 B8 01 00 00 00 EB 55 8D 4D 88 51 8B 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 31 8B 45 84 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 21 8B 4D 84 89 0D ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 89 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? 0C 04 A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? 83 E0 04 F7 D8 1B C0 40 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_141_8_0 {
	meta:
		name = "_GetLcidFromDefault"
		size = 43
		refs = "0004 _iLcidState 0014 __imp__GetUserDefaultLCID@0 0019 _lcidCountry 0025 _lcidLanguage"
	strings:
		$1 = { 55 8B EC A1 ?? ?? ?? ?? 0D 04 01 00 00 A3 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_141_9_0 {
	meta:
		name = "_ProcessCodePage"
		size = 155
		refs = "0017 ??_C@_03EKFG@ACP?$AA@ 0020 _strcmp 0038 _lcidCountry 003f _pfnGetLocaleInfoA 0054 ??_C@_03DGJE@OCP?$AA@ 0090 _atol"
	strings:
		$1 = { 55 8B EC 83 EC 08 83 7D 08 00 74 1F 8B 45 08 0F BE 08 85 C9 74 15 68 ?? ?? ?? ?? 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 28 6A 08 8D 45 F8 50 68 04 10 00 00 8B 0D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 85 C0 75 04 33 C0 EB 4C 8D 55 F8 89 55 08 EB 38 68 ?? ?? ?? ?? 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 23 6A 08 8D 4D F8 51 6A 0B 8B 15 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 85 C0 75 04 33 C0 EB 12 8D 45 F8 89 45 08 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_141_10_0 {
	meta:
		name = "_TestDefaultCountry"
		size = 79
		refs = "0038 ___rglangidNotDefault"
	strings:
		$1 = { 55 8B EC 83 EC 08 66 8B 45 08 66 89 45 FC C7 45 F8 00 00 00 00 EB 09 8B 4D F8 83 C1 01 89 4D F8 83 7D F8 0A 73 20 8B 55 FC 81 E2 FF FF 00 00 8B 45 F8 33 C9 66 8B 0C 45 ?? ?? ?? ?? 3B D1 75 04 33 C0 EB 07 EB D1 B8 01 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_141_11_0 {
	meta:
		name = "_TestDefaultLanguage"
		size = 135
		refs = "0032 _pfnGetLocaleInfoA 0043 _LcidFromHexString 0057 _pchLanguage 005d _GetPrimaryLen 006e _strlen"
	strings:
		$1 = { 55 8B EC 83 EC 7C 56 8B 45 08 25 FF FF 00 00 25 FF 03 00 00 25 FF FF 00 00 80 CC 04 25 FF FF 00 00 89 45 FC 6A 78 8D 4D 84 51 6A 01 8B 55 FC 52 FF 15 ?? ?? ?? ?? 85 C0 75 04 33 C0 EB 44 8D 45 84 50 E8 ?? ?? ?? ?? 83 C4 04 39 45 08 74 2E 83 7D 0C 00 74 28 8B 0D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 04 8B F0 8B 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 04 3B F0 75 04 33 C0 EB 05 B8 01 00 00 00 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_141_12_0 {
	meta:
		name = "_IsThisWindowsNT"
		size = 77
		refs = "001c __imp__GetVersionExA@4"
	strings:
		$1 = { 55 8B EC 81 EC 98 00 00 00 C7 85 6C FF FF FF 94 00 00 00 8D 85 6C FF FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 74 15 83 BD 7C FF FF FF 02 75 0C C7 85 68 FF FF FF 01 00 00 00 EB 0A C7 85 68 FF FF FF 00 00 00 00 8B 85 68 FF FF FF 8B E5 5D C3 }
	condition:
		$1
}

rule file_141_13_0 {
	meta:
		name = "_crtGetLocaleInfoA@16"
		size = 388
		refs = "0040 ___rgLocInfo 0126 _strncpy 017a __imp__GetLocaleInfoA@16"
	strings:
		$1 = { 55 8B EC 83 EC 14 C7 45 F0 00 00 00 00 C7 45 FC 1A 00 00 00 C7 45 F8 00 00 00 00 8B 45 F0 3B 45 FC 0F 8F 41 01 00 00 8B 45 F0 03 45 FC 99 2B C2 D1 F8 89 45 F4 8B 4D F4 6B C9 2C 8B 55 08 3B 91 ?? ?? ?? ?? 0F 85 F4 00 00 00 8B 45 0C 89 45 EC 83 7D EC 0B 77 21 83 7D EC 0B 0F 84 89 00 00 00 83 7D EC 01 74 2E 83 7D EC 03 74 4A 83 7D EC 07 74 66 E9 91 00 00 00 81 7D EC 01 10 00 00 74 25 81 7D EC 02 10 00 00 74 3E 81 7D EC 04 10 00 00 74 68 EB 74 8B 4D F4 6B C9 2C 81 C1 ?? ?? ?? ?? 89 4D F8 EB 63 8B 55 F4 6B D2 2C 8B 82 ?? ?? ?? ?? 89 45 F8 EB 52 8B 4D F4 6B C9 2C 81 C1 ?? ?? ?? ?? 89 4D F8 EB 41 8B 55 F4 6B D2 2C 8B 82 ?? ?? ?? ?? 89 45 F8 EB 30 8B 4D F4 6B C9 2C 81 C1 ?? ?? ?? ?? 89 4D F8 EB 1F 8B 55 F4 6B D2 2C 81 C2 ?? ?? ?? ?? 89 55 F8 EB 0E 8B 45 F4 6B C0 2C 05 ?? ?? ?? ?? 89 45 F8 83 7D F8 00 74 06 83 7D 14 01 7D 02 EB 52 8B 4D 14 83 E9 01 51 8B 55 F8 52 8B 45 10 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D 10 03 4D 14 C6 41 FF 00 B8 01 00 00 00 EB 40 8B 55 F4 6B D2 2C 8B 45 08 3B 82 ?? ?? ?? ?? 73 0B 8B 4D F4 83 E9 01 89 4D FC EB 09 8B 55 F4 83 C2 01 89 55 F0 E9 B3 FE FF FF 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 FF 15 ?? ?? ?? ?? 8B E5 5D C2 10 00 }
	condition:
		$1
}

rule file_141_14_0 {
	meta:
		name = "_LcidFromHexString"
		size = 118
	strings:
		$1 = { 55 8B EC 83 EC 08 C7 45 FC 00 00 00 00 8B 45 08 8A 08 88 4D F8 0F BE 55 F8 8B 45 08 83 C0 01 89 45 08 85 D2 74 49 0F BE 4D F8 83 F9 61 7C 13 0F BE 55 F8 83 FA 66 7F 0A 8A 45 F8 04 D9 88 45 F8 EB 1A 0F BE 4D F8 83 F9 41 7C 11 0F BE 55 F8 83 FA 46 7F 08 8A 45 F8 04 F9 88 45 F8 8B 4D FC C1 E1 04 0F BE 55 F8 8D 44 11 D0 89 45 FC EB 9E 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_141_15_0 {
	meta:
		name = "_GetPrimaryLen"
		size = 101
	strings:
		$1 = { 55 8B EC 83 EC 08 C7 45 F8 00 00 00 00 8B 45 08 8A 08 88 4D FC 8B 55 08 83 C2 01 89 55 08 0F BE 45 FC 83 F8 41 7C 09 0F BE 4D FC 83 F9 5A 7E 12 0F BE 55 FC 83 FA 61 7C 25 0F BE 45 FC 83 F8 7A 7F 1C 8B 4D F8 83 C1 01 89 4D F8 8B 55 08 8A 02 88 45 FC 8B 4D 08 83 C1 01 89 4D 08 EB C0 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_142_0_0 {
	meta:
		name = "___initconin"
		size = 36
		refs = "0013 ??_C@_06MICP@CONIN$?$AA@ 0019 __imp__CreateFileA@28 001e __coninpfh"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 03 6A 00 6A 03 68 00 00 00 C0 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_142_1_0 {
	meta:
		name = "___initconout"
		size = 36
		refs = "0013 ??_C@_07GLCC@CONOUT$?$AA@ 0019 __imp__CreateFileA@28 001e __confh"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 03 6A 00 6A 03 68 00 00 00 40 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_142_2_0 {
	meta:
		name = "___termcon"
		size = 66
		refs = "0005 __confh 001d __imp__CloseHandle@4 0023 __coninpfh"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? FF 74 15 83 3D ?? ?? ?? ?? FE 74 0C A1 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? FF 74 16 83 3D ?? ?? ?? ?? FE 74 0D 8B 0D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_144_0_0 {
	meta:
		name = "___RTCastToVoid"
		size = 154
		refs = "0006 $T16982 000b __except_handler3 0011 __except_list 003c ?FindCompleteObject@@YAPAXPAPAX@Z 006f ??_C@_0CB@FCJM@Access?5violation?5?9?5no?5RTTI?5data?$CB@ 0077 ??0__non_rtti_object@@QAE@PBD@Z 007c __TI3?AV__non_rtti_object@@ 0085 __CxxThrowException@8"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 C4 E0 53 56 57 89 65 E8 83 7D 08 00 75 04 33 C0 EB 59 C7 45 FC 00 00 00 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 D4 C7 45 FC FF FF FF FF 8B 45 D4 EB 37 8B 4D EC 8B 11 8B 02 89 45 D8 8B 4D D8 33 C0 81 F9 05 00 00 C0 0F 94 C0 C3 8B 65 E8 68 ?? ?? ?? ?? 8D 4D DC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 55 DC 52 E8 ?? ?? ?? ?? 8B 4D F0 64 89 0D ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_144_1_0 {
	meta:
		name = "??0__non_rtti_object@@QAE@PBD@Z"
		size = 37
		refs = "000f ??0bad_typeid@@QAE@PBD@Z 0018 ??_7__non_rtti_object@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_144_7_0 {
	meta:
		name = "??0__non_rtti_object@@QAE@ABV0@@Z"
		size = 37
		refs = "000f ??0bad_typeid@@QAE@ABV0@@Z 0018 ??_7__non_rtti_object@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_144_11_0 {
	meta:
		name = "??0bad_cast@@QAE@ABQBD@Z"
		size = 37
		refs = "000f ??0exception@@QAE@ABQBD@Z 0018 ??_7bad_cast@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_144_14_0 {
	meta:
		name = "??0bad_cast@@QAE@ABV0@@Z"
		size = 37
		refs = "000f ??0exception@@QAE@ABV0@@Z 0018 ??_7bad_cast@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_144_8_0 {
	meta:
		name = "??0bad_typeid@@QAE@ABV0@@Z"
		size = 37
		refs = "000f ??0exception@@QAE@ABV0@@Z 0018 ??_7bad_typeid@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_144_2_0 {
	meta:
		name = "??0bad_typeid@@QAE@PBD@Z"
		size = 37
		refs = "000f ??0exception@@QAE@ABQBD@Z 0018 ??_7bad_typeid@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8D 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_144_4_0 {
	meta:
		name = "??1bad_typeid@@UAE@XZ"
		size = 19
		refs = "000b ??1exception@@UAE@XZ"
		altNames = "??1bad_cast@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_144_6_0 {
	meta:
		name = "??1__non_rtti_object@@UAE@XZ"
		size = 19
		refs = "000b ??1bad_typeid@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_144_9_0 {
	meta:
		name = "___RTtypeid"
		size = 229
		refs = "0006 $T17012 000b __except_handler3 0011 __except_list 002d ??_C@_0CE@DOMJ@Attempted?5a?5typeid?5of?5NULL?5point@ 0035 ??0bad_typeid@@QAE@PBD@Z 003a __TI2?AVbad_typeid@@ 0043 __CxxThrowException@8 0064 __imp__IsBadReadPtr@8 0082 ??_C@_0CB@OFOA@Bad?5read?5pointer?5?9?5no?5RTTI?5data?$CB@ 008a ??0__non_rtti_object@@QAE@PBD@Z 008f __TI3?AV__non_rtti_object@@ 00ba ??_C@_0CB@FCJM@Access?5violation?5?9?5no?5RTTI?5data?$CB@"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 C4 C0 53 56 57 89 65 E8 83 7D 08 00 75 1B 68 ?? ?? ?? ?? 8D 4D D8 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 D8 50 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D 08 8B 11 8B 42 FC 89 45 E4 6A 08 8B 4D E4 8B 51 0C 52 FF 15 ?? ?? ?? ?? 85 C0 75 15 8B 45 E4 8B 48 0C 89 4D B8 C7 45 FC FF FF FF FF 8B 45 B8 EB 53 68 ?? ?? ?? ?? 8D 4D CC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 55 CC 52 E8 ?? ?? ?? ?? 8B 45 EC 8B 08 8B 11 89 55 BC 8B 45 BC 33 C9 3D 05 00 00 C0 0F 94 C1 8B C1 C3 8B 65 E8 68 ?? ?? ?? ?? 8D 4D C0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 55 C0 52 E8 ?? ?? ?? ?? 8B 4D F0 64 89 0D ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_144_10_0 {
	meta:
		name = "___RTDynamicCast"
		size = 403
		refs = "0006 $T17026 000b __except_handler3 0011 __except_list 003f ?FindCompleteObject@@YAPAXPAPAX@Z 008b ?FindSITargetTypeInstance@@YAPBU_s_RTTIBaseClassDescriptor@@PAXPBU_s_RTTICompleteObjectLocator@@PAUTypeDescriptor@@H2@Z 00bc ?FindMITargetTypeInstance@@YAPBU_s_RTTIBaseClassDescriptor@@PAXPBU_s_RTTICompleteObjectLocator@@PAUTypeDescriptor@@H2@Z 00dd ?FindVITargetTypeInstance@@YAPBU_s_RTTIBaseClassDescriptor@@PAXPBU_s_RTTICompleteObjectLocator@@PAUTypeDescriptor@@H2@Z 00f9 ?PMDtoOffset@@YAHPAXABUPMD@@@Z 011a ??_C@_0BC@OEMP@Bad?5dynamic_cast?$CB?$AA@ 0126 ??0bad_cast@@QAE@ABQBD@Z 012b __TI2?AVbad_cast@@ 0134 __CxxThrowException@8 0165 ??_C@_0CB@FCJM@Access?5violation?5?9?5no?5RTTI?5data?$CB@ 016d ??0__non_rtti_object@@QAE@PBD@Z 0172 __TI3?AV__non_rtti_object@@"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 C4 C4 53 56 57 89 65 E8 83 7D 08 00 75 07 33 C0 E9 4F 01 00 00 C7 45 FC 00 00 00 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 D4 8B 4D 08 8B 11 8B 42 FC 89 45 DC 8B 4D 08 2B 4D 0C 89 4D 08 8B 55 08 2B 55 D4 89 55 D8 8B 45 DC 8B 48 10 8B 51 04 83 E2 01 85 D2 75 21 8B 45 14 50 8B 4D D8 51 8B 55 10 52 8B 45 DC 50 8B 4D D4 51 E8 ?? ?? ?? ?? 83 C4 14 89 45 E4 EB 50 8B 55 DC 8B 42 10 8B 48 04 83 E1 02 85 C9 75 21 8B 55 14 52 8B 45 D8 50 8B 4D 10 51 8B 55 DC 52 8B 45 D4 50 E8 ?? ?? ?? ?? 83 C4 14 89 45 E4 EB 1F 8B 4D 14 51 8B 55 D8 52 8B 45 10 50 8B 4D DC 51 8B 55 D4 52 E8 ?? ?? ?? ?? 83 C4 14 89 45 E4 83 7D E4 00 74 1D 8B 45 E4 83 C0 08 50 8B 4D D4 51 E8 ?? ?? ?? ?? 83 C4 08 8B 55 D4 03 D0 89 55 E0 EB 2E C7 45 E0 00 00 00 00 83 7D 18 00 74 21 C7 45 C4 ?? ?? ?? ?? 8D 45 C4 50 8D 4D C8 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 4D C8 51 E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF EB 3E 8B 55 EC 8B 02 8B 08 89 4D B4 8B 55 B4 33 C0 81 FA 05 00 00 C0 0F 94 C0 C3 8B 65 E8 C7 45 E0 00 00 00 00 68 ?? ?? ?? ?? 8D 4D B8 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 B8 50 E8 ?? ?? ?? ?? 8B 45 E0 8B 4D F0 64 89 0D ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_144_15_0 {
	meta:
		name = "?FindCompleteObject@@YAPAXPAPAX@Z"
		size = 62
	strings:
		$1 = { 55 8B EC 83 EC 08 8B 45 08 8B 08 8B 51 FC 89 55 FC 8B 45 FC 8B 4D 08 2B 48 04 89 4D F8 8B 55 FC 83 7A 08 00 74 11 8B 45 FC 8B 4D 08 2B 48 08 8B 55 F8 03 11 89 55 F8 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_144_16_0 {
	meta:
		name = "?FindSITargetTypeInstance@@YAPBU_s_RTTIBaseClassDescriptor@@PAXPBU_s_RTTICompleteObjectLocator@@PAUTypeDescriptor@@H2@Z"
		size = 131
		refs = "005e _strcmp"
	strings:
		$1 = { 55 8B EC 83 EC 0C C7 45 F4 00 00 00 00 8B 45 0C 8B 48 10 8B 51 0C 89 55 FC EB 12 8B 45 F4 83 C0 01 89 45 F4 8B 4D FC 83 C1 04 89 4D FC 8B 55 0C 8B 42 10 8B 4D F4 3B 48 08 73 42 8B 55 FC 8B 02 89 45 F8 8B 4D F8 8B 11 3B 55 18 74 1C 8B 45 18 83 C0 08 50 8B 4D F8 8B 11 83 C2 08 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 12 8B 45 F8 8B 48 14 83 E1 01 85 C9 75 05 8B 45 F8 EB 04 EB 9E 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_144_17_0 {
	meta:
		name = "?FindMITargetTypeInstance@@YAPBU_s_RTTIBaseClassDescriptor@@PAXPBU_s_RTTICompleteObjectLocator@@PAUTypeDescriptor@@H2@Z"
		size = 379
		refs = "0062 _strcmp 00d6 ?PMDtoOffset@@YAHPAXABUPMD@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 18 C7 45 EC 00 00 00 00 8B 45 0C 8B 48 10 8B 51 0C 89 55 F8 EB 12 8B 45 EC 83 C0 01 89 45 EC 8B 4D F8 83 C1 04 89 4D F8 8B 55 0C 8B 42 10 8B 4D EC 3B 48 08 0F 83 B2 00 00 00 8B 55 F8 8B 02 89 45 F4 8B 4D F4 8B 11 3B 55 18 74 1C 8B 45 18 83 C0 08 50 8B 4D F4 8B 11 83 C2 08 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 7F C7 45 E8 00 00 00 00 8B 45 F8 83 C0 04 89 45 FC EB 12 8B 4D E8 83 C1 01 89 4D E8 8B 55 FC 83 C2 04 89 55 FC 8B 45 F4 8B 4D E8 3B 48 04 73 50 8B 55 FC 8B 02 89 45 F0 8B 4D F0 8B 11 3B 55 10 74 1C 8B 45 10 83 C0 08 50 8B 4D F0 8B 11 83 C2 08 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 20 8B 45 F0 83 C0 08 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 3B 45 14 75 08 8B 45 F4 E9 8D 00 00 00 EB 93 E9 2A FF FF FF C7 45 EC 00 00 00 00 8B 55 0C 8B 42 10 8B 48 0C 89 4D F8 EB 12 8B 55 EC 83 C2 01 89 55 EC 8B 45 F8 83 C0 04 89 45 F8 8B 4D 0C 8B 51 10 8B 45 EC 3B 42 08 73 4F 8B 4D F8 8B 11 89 55 F4 8B 45 F4 8B 08 3B 4D 18 74 1C 8B 55 18 83 C2 08 52 8B 45 F4 8B 08 83 C1 08 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 1F 8B 55 F4 8B 42 14 83 E0 01 85 C0 75 12 8B 4D F4 8B 51 14 83 E2 02 85 D2 75 05 8B 45 F4 EB 04 EB 91 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_144_18_0 {
	meta:
		name = "?FindVITargetTypeInstance@@YAPBU_s_RTTIBaseClassDescriptor@@PAXPBU_s_RTTICompleteObjectLocator@@PAUTypeDescriptor@@H2@Z"
		size = 468
		refs = "006a _strcmp 00e6 ?PMDtoOffset@@YAHPAXABUPMD@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 1C 56 C7 45 E8 00 00 00 00 C7 45 EC 00 00 00 00 8B 45 0C 8B 48 10 8B 51 0C 89 55 F8 EB 12 8B 45 EC 83 C0 01 89 45 EC 8B 4D F8 83 C1 04 89 4D F8 8B 55 0C 8B 42 10 8B 4D EC 3B 48 08 0F 83 F4 00 00 00 8B 55 F8 8B 02 89 45 F4 8B 4D F4 8B 11 3B 55 18 74 20 8B 45 18 83 C0 08 50 8B 4D F4 8B 11 83 C2 08 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 0F 85 BD 00 00 00 C7 45 E4 00 00 00 00 8B 45 F8 83 C0 04 89 45 FC EB 12 8B 4D E4 83 C1 01 89 4D E4 8B 55 FC 83 C2 04 89 55 FC 8B 45 F4 8B 4D E4 3B 48 04 0F 83 8A 00 00 00 8B 55 FC 8B 02 89 45 F0 8B 4D F0 8B 11 3B 55 10 74 1C 8B 45 10 83 C0 08 50 8B 4D F0 8B 11 83 C2 08 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 57 8B 45 F0 83 C0 08 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 3B 45 14 75 3F 83 7D E8 00 74 33 8B 55 E8 83 C2 08 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 8B F0 8B 4D F4 83 C1 08 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 3B F0 74 07 33 C0 E9 A4 00 00 00 8B 45 F4 89 45 E8 E9 55 FF FF FF E9 E8 FE FF FF 83 7D E8 00 74 08 8B 45 E8 E9 86 00 00 00 C7 45 EC 00 00 00 00 8B 4D 0C 8B 51 10 8B 42 0C 89 45 F8 EB 12 8B 4D EC 83 C1 01 89 4D EC 8B 55 F8 83 C2 04 89 55 F8 8B 45 0C 8B 48 10 8B 55 EC 3B 51 08 73 4F 8B 45 F8 8B 08 89 4D F4 8B 55 F4 8B 02 3B 45 18 74 1C 8B 4D 18 83 C1 08 51 8B 55 F4 8B 02 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 1F 8B 4D F4 8B 51 14 83 E2 01 85 D2 75 12 8B 45 F4 8B 48 14 83 E1 02 85 C9 75 05 8B 45 F4 EB 04 EB 91 33 C0 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_144_19_0 {
	meta:
		name = "?PMDtoOffset@@YAHPAXABUPMD@@@Z"
		size = 70
	strings:
		$1 = { 55 8B EC 51 C7 45 FC 00 00 00 00 8B 45 0C 83 78 04 00 7C 20 8B 4D 0C 8B 51 04 89 55 FC 8B 45 08 03 45 FC 8B 08 8B 55 0C 8B 42 08 8B 55 FC 03 14 01 89 55 FC 8B 45 0C 8B 4D FC 03 08 89 4D FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_145_0_0 {
	meta:
		name = "_modf"
		size = 398
		refs = "000b __ctrlfp 001b _newcw 0047 __d_ind 005f __sptype 0098 __copysign 00d8 __handle_qnan1 00e9 __real@8@3fff8000000000000000 0117 __except1 0125 __real@8@00000000000000000000 0155 __frnd"
	strings:
		$1 = { 55 8B EC 83 EC 18 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 08 89 45 F4 68 FF FF 00 00 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4D 0E 81 E1 FF FF 00 00 81 E1 F0 7F 00 00 81 F9 F0 7F 00 00 0F 85 DD 00 00 00 8B 55 10 A1 ?? ?? ?? ?? 89 02 8B 0D ?? ?? ?? ?? 89 4A 04 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 E8 83 7D E8 00 7E 75 83 7D E8 02 7E 08 83 7D E8 03 74 40 EB 67 8B 4D 10 8B 55 08 89 11 8B 45 0C 89 41 04 8B 4D 0C 51 8B 55 08 52 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 10 DD 5D F8 68 FF FF 00 00 8B 45 F4 50 E8 ?? ?? ?? ?? 83 C4 08 DD 45 F8 E9 CF 00 00 00 8B 4D 10 8B 55 08 89 11 8B 45 0C 89 41 04 8B 4D F4 51 8B 55 0C 52 8B 45 08 50 6A 1C E8 ?? ?? ?? ?? 83 C4 10 E9 A6 00 00 00 DD 45 08 DC 05 ?? ?? ?? ?? DD 5D F8 8B 4D 10 8B 55 F8 89 11 8B 45 FC 89 41 04 8B 4D F4 51 8B 55 FC 52 8B 45 F8 50 8B 4D 0C 51 8B 55 08 52 6A 1C 6A 08 E8 ?? ?? ?? ?? 83 C4 1C EB 6A DD 45 08 DC 1D ?? ?? ?? ?? DF E0 F6 C4 40 74 1C 8B 45 10 8B 4D 08 89 08 8B 55 0C 89 50 04 8B 45 08 89 45 F8 8B 4D 0C 89 4D FC EB 2A 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 DD 5D EC 8B 4D 10 8B 55 EC 89 11 8B 45 F0 89 41 04 DD 45 08 DC 65 EC DD 5D F8 68 FF FF 00 00 8B 4D F4 51 E8 ?? ?? ?? ?? 83 C4 08 DD 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_146_0_0 {
	meta:
		name = "___init_numeric"
		size = 678
		refs = "0011 ___lc_id 001a ___lc_handle 0026 _?dec_pnt@?1??__init_numeric@@9@9 0033 ___getlocaleinfo 0043 _?thous_sep@?1??__init_numeric@@9@9 0060 _?grping@?1??__init_numeric@@9@9 0084 _fix_grouping 009a __free_dbg 00ea ___lconv 00f0 ___lconv_static_decimal 0165 ___decimal_point 016b ___decimal_point_length 01d0 ??_C@_09IMJJ@initnum?4c?$AA@ 01d9 __malloc_dbg 01fc ??_C@_01PJCK@?4?$AA@ 0209 _strcpy"
	strings:
		$1 = { 55 8B EC 83 EC 08 C7 45 F8 00 00 00 00 33 C0 66 A1 ?? ?? ?? ?? 89 45 FC 83 3D ?? ?? ?? ?? 00 0F 84 55 01 00 00 68 ?? ?? ?? ?? 6A 0E 8B 4D FC 51 6A 01 E8 ?? ?? ?? ?? 83 C4 10 8B 55 F8 0B D0 89 55 F8 68 ?? ?? ?? ?? 6A 0F 8B 45 FC 50 6A 01 E8 ?? ?? ?? ?? 83 C4 10 8B 4D F8 0B C8 89 4D F8 68 ?? ?? ?? ?? 6A 10 8B 55 FC 52 6A 01 E8 ?? ?? ?? ?? 83 C4 10 8B 4D F8 0B C8 89 4D F8 8B 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 04 83 7D F8 00 74 58 6A 02 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 0D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 08 C7 05 ?? ?? ?? ?? 00 00 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 83 C8 FF E9 B9 01 00 00 A1 ?? ?? ?? ?? 81 38 ?? ?? ?? ?? 74 3A 6A 02 8B 0D ?? ?? ?? ?? 8B 11 52 E8 ?? ?? ?? ?? 83 C4 08 6A 02 A1 ?? ?? ?? ?? 8B 48 04 51 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 15 ?? ?? ?? ?? 8B 42 08 50 E8 ?? ?? ?? ?? 83 C4 08 8B 0D ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 89 11 A1 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 89 48 04 8B 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? 89 42 08 8B 0D ?? ?? ?? ?? 8B 11 8A 02 A2 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 01 00 00 00 33 C0 E9 28 01 00 00 6A 02 8B 0D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 08 6A 02 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 08 C7 05 ?? ?? ?? ?? 00 00 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 68 88 00 00 00 68 ?? ?? ?? ?? 6A 02 6A 02 E8 ?? ?? ?? ?? 83 C4 10 8B 0D ?? ?? ?? ?? 89 01 8B 15 ?? ?? ?? ?? 83 3A 00 75 08 83 C8 FF E9 A7 00 00 00 68 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B 08 51 E8 ?? ?? ?? ?? 83 C4 08 68 8D 00 00 00 68 ?? ?? ?? ?? 6A 02 6A 02 E8 ?? ?? ?? ?? 83 C4 10 8B 15 ?? ?? ?? ?? 89 42 04 A1 ?? ?? ?? ?? 83 78 04 00 75 05 83 C8 FF EB 63 8B 0D ?? ?? ?? ?? 8B 51 04 C6 02 00 68 92 00 00 00 68 ?? ?? ?? ?? 6A 02 6A 02 E8 ?? ?? ?? ?? 83 C4 10 8B 0D ?? ?? ?? ?? 89 41 08 8B 15 ?? ?? ?? ?? 83 7A 08 00 75 05 83 C8 FF EB 27 A1 ?? ?? ?? ?? 8B 48 08 C6 01 00 8B 15 ?? ?? ?? ?? 8B 02 8A 08 88 0D ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 01 00 00 00 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_146_1_0 {
	meta:
		name = "_fix_grouping"
		size = 125
	strings:
		$1 = { 55 8B EC 51 8B 45 08 0F BE 08 85 C9 74 6B 8B 55 08 0F BE 02 83 F8 30 7C 24 8B 4D 08 0F BE 11 83 FA 39 7F 19 8B 45 08 0F BE 08 83 E9 30 8B 55 08 88 0A 8B 45 08 83 C0 01 89 45 08 EB 3A 8B 4D 08 0F BE 11 83 FA 3B 75 26 8B 45 08 89 45 FC 8B 4D FC 8B 55 FC 8A 42 01 88 01 8B 4D FC 83 C1 01 89 4D FC 8B 55 FC 0F BE 02 85 C0 75 E2 EB 09 8B 4D 08 83 C1 01 89 4D 08 EB 8B 8B E5 5D C3 }
	condition:
		$1
}

rule file_147_0_0 {
	meta:
		name = "__woutput"
		size = 3266
		refs = "0079 ___lookuptable 00ce $L2133 00ea _write_char 0169 $L2134 0170 $L2135 01bf _get_int_arg 0328 $L2136 032f $L2137 0387 ___mb_cur_max 039b _mbtowc 03fa ___nullstring 0406 _strlen 0513 __pctype 0551 ___wnullstring 0697 __cfltcvt_tab 07c7 _get_int64_arg 0979 __aullrem 099e __aulldiv 0aca _write_multi_char 0ae8 _write_string 0c07 $NORMAL_STATE$1887 0c0b $L1888 0c0f $L1889 0c13 $L1899 0c17 $L1903 0c1b $L1904 0c1f $L1908 0c23 $L1918 0c27 $L1896 0c2b $L1897 0c2f $L1895 0c33 $L1894 0c37 $L1898 0c3b $L1891 0c50 $L1923 0c54 $L1978 0c58 $L1948 0c5c $L2003 0c60 $L1932 0c64 $L1924 0c68 $L1998 0c6c $L1979 0c70 $L1970 0c74 $L2008 0c78 $L2001 0c7c $L1949 0c80 $L2000 0c84 $L2005 0c88 $L1920"
	strings:
		$1 = { 55 8B EC 81 EC A0 04 00 00 C7 45 DC 00 00 00 00 C7 85 D4 FB FF FF 00 00 00 00 C7 45 E8 00 00 00 00 8B 45 0C 66 8B 08 66 89 4D D8 8B 55 D8 81 E2 FF FF 00 00 8B 45 0C 83 C0 02 89 45 0C 85 D2 0F 84 B8 0B 00 00 83 BD D4 FB FF FF 00 0F 8C AB 0B 00 00 8B 4D D8 81 E1 FF FF 00 00 83 F9 20 7C 28 8B 55 D8 81 E2 FF FF 00 00 83 FA 78 7F 1A 8B 45 D8 25 FF FF 00 00 0F BE 88 ?? ?? ?? ?? 83 E1 0F 89 8D 74 FB FF FF EB 0A C7 85 74 FB FF FF 00 00 00 00 8B 95 74 FB FF FF 89 55 F4 8B 45 F4 8B 4D E8 0F BE 94 C1 ?? ?? ?? ?? C1 FA 04 89 55 E8 8B 45 E8 89 85 70 FB FF FF 83 BD 70 FB FF FF 07 0F 87 33 0B 00 00 8B 8D 70 FB FF FF FF 24 8D ?? ?? ?? ?? C7 45 E4 01 00 00 00 8D 95 D4 FB FF FF 52 8B 45 08 50 66 8B 4D D8 51 E8 ?? ?? ?? ?? 83 C4 0C E9 02 0B 00 00 C7 45 F8 00 00 00 00 8B 55 F8 89 95 C4 FB FF FF 8B 85 C4 FB FF FF 89 85 BC FB FF FF 8B 8D BC FB FF FF 89 4D F0 C7 45 FC 00 00 00 00 C7 85 CC FB FF FF FF FF FF FF C7 45 E4 00 00 00 00 E9 C0 0A 00 00 8B 55 D8 81 E2 FF FF 00 00 89 95 6C FB FF FF 8B 85 6C FB FF FF 83 E8 20 89 85 6C FB FF FF 83 BD 6C FB FF FF 10 77 48 8B 95 6C FB FF FF 33 C9 8A 8A ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? 8B 45 FC 0C 04 89 45 FC EB 29 8B 4D FC 83 C9 01 89 4D FC EB 1E 8B 55 FC 83 CA 02 89 55 FC EB 13 8B 45 FC 0C 80 89 45 FC EB 09 8B 4D FC 83 C9 08 89 4D FC E9 4C 0A 00 00 8B 55 D8 81 E2 FF FF 00 00 83 FA 2A 75 34 8D 45 10 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 BC FB FF FF 83 BD BC FB FF FF 00 7D 17 8B 4D FC 83 C9 04 89 4D FC 8B 95 BC FB FF FF F7 DA 89 95 BC FB FF FF EB 1C 8B 85 BC FB FF FF 6B C0 0A 8B 4D D8 81 E1 FF FF 00 00 8D 54 08 D0 89 95 BC FB FF FF E9 E9 09 00 00 C7 85 CC FB FF FF 00 00 00 00 E9 DA 09 00 00 8B 45 D8 25 FF FF 00 00 83 F8 2A 75 27 8D 4D 10 51 E8 ?? ?? ?? ?? 83 C4 04 89 85 CC FB FF FF 83 BD CC FB FF FF 00 7D 0A C7 85 CC FB FF FF FF FF FF FF EB 1B 8B 95 CC FB FF FF 6B D2 0A 8B 45 D8 25 FF FF 00 00 8D 4C 02 D0 89 8D CC FB FF FF E9 86 09 00 00 8B 55 D8 81 E2 FF FF 00 00 89 95 68 FB FF FF 83 BD 68 FB FF FF 49 74 14 83 BD 68 FB FF FF 68 74 48 83 BD 68 FB FF FF 77 74 49 EB 50 8B 45 0C 33 C9 66 8B 08 83 F9 36 75 22 8B 55 0C 33 C0 66 8B 42 02 83 F8 34 75 14 8B 4D 0C 83 C1 04 89 4D 0C 8B 55 FC 80 CE 80 89 55 FC EB 0C C7 45 E8 00 00 00 00 E9 F9 FD FF FF EB 13 8B 45 FC 0C 20 89 45 FC EB 09 8B 4D FC 80 CD 08 89 4D FC E9 05 09 00 00 8B 55 D8 81 E2 FF FF 00 00 89 95 64 FB FF FF 8B 85 64 FB FF FF 83 E8 43 89 85 64 FB FF FF 83 BD 64 FB FF FF 35 0F 87 0F 07 00 00 8B 95 64 FB FF FF 33 C9 8A 8A ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? 8B 45 FC 25 30 08 00 00 85 C0 75 09 8B 4D FC 83 C9 20 89 4D FC C7 45 E4 01 00 00 00 8D 55 10 52 E8 ?? ?? ?? ?? 83 C4 04 66 89 45 EC 8B 45 FC 83 E0 20 85 C0 74 49 8B 4D EC 81 E1 FF FF 00 00 81 E1 FF 00 00 00 88 8D B8 FB FF FF C6 85 B9 FB FF FF 00 8B 15 ?? ?? ?? ?? 52 8D 85 B8 FB FF FF 50 8D 8D D8 FB FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 7D 0A C7 85 C4 FB FF FF 01 00 00 00 EB 0B 66 8B 55 EC 66 89 95 D8 FB FF FF 8D 85 D8 FB FF FF 89 45 E0 C7 45 DC 01 00 00 00 E9 5B 06 00 00 8D 4D 10 51 E8 ?? ?? ?? ?? 83 C4 04 89 85 B4 FB FF FF 83 BD B4 FB FF FF 00 74 0C 8B 95 B4 FB FF FF 83 7A 04 00 75 19 A1 ?? ?? ?? ?? 89 45 E0 8B 4D E0 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 DC EB 4F 8B 55 FC 81 E2 00 08 00 00 85 D2 74 23 8B 85 B4 FB FF FF 8B 48 04 89 4D E0 8B 95 B4 FB FF FF 0F BF 02 D1 E8 89 45 DC C7 45 E4 01 00 00 00 EB 1F C7 45 E4 00 00 00 00 8B 8D B4 FB FF FF 8B 51 04 89 55 E0 8B 85 B4 FB FF FF 0F BF 08 89 4D DC E9 C7 05 00 00 8B 55 FC 81 E2 30 08 00 00 85 D2 75 08 8B 45 FC 0C 20 89 45 FC 83 BD CC FB FF FF FF 75 0C C7 85 60 FB FF FF FF FF FF 7F EB 0C 8B 8D CC FB FF FF 89 8D 60 FB FF FF 8B 95 60 FB FF FF 89 95 A8 FB FF FF 8D 45 10 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 E0 8B 4D FC 83 E1 20 85 C9 0F 84 84 00 00 00 83 7D E0 00 75 09 8B 15 ?? ?? ?? ?? 89 55 E0 8B 45 E0 89 85 B0 FB FF FF C7 45 DC 00 00 00 00 EB 09 8B 4D DC 83 C1 01 89 4D DC 8B 55 DC 3B 95 A8 FB FF FF 7D 4D 8B 85 B0 FB FF FF 0F BE 08 85 C9 74 40 8B 95 B0 FB FF FF 33 C0 8A 02 8B 0D ?? ?? ?? ?? 33 D2 66 8B 14 41 81 E2 00 80 00 00 85 D2 74 0F 8B 85 B0 FB FF FF 83 C0 01 89 85 B0 FB FF FF 8B 8D B0 FB FF FF 83 C1 01 89 8D B0 FB FF FF EB 9F EB 66 83 7D E0 00 75 09 8B 15 ?? ?? ?? ?? 89 55 E0 C7 45 E4 01 00 00 00 8B 45 E0 89 85 AC FB FF FF 8B 8D A8 FB FF FF 8B 95 A8 FB FF FF 83 EA 01 89 95 A8 FB FF FF 85 C9 74 20 8B 85 AC FB FF FF 33 C9 66 8B 08 85 C9 74 11 8B 95 AC FB FF FF 83 C2 02 89 95 AC FB FF FF EB C7 8B 85 AC FB FF FF 2B 45 E0 D1 F8 89 45 DC E9 79 04 00 00 8D 4D 10 51 E8 ?? ?? ?? ?? 83 C4 04 89 85 A4 FB FF FF 8B 55 FC 83 E2 20 85 D2 74 12 8B 85 A4 FB FF FF 66 8B 8D D4 FB FF FF 66 89 08 EB 0E 8B 95 A4 FB FF FF 8B 85 D4 FB FF FF 89 02 C7 85 C4 FB FF FF 01 00 00 00 E9 2E 04 00 00 C7 45 F8 01 00 00 00 66 8B 4D D8 66 83 C1 20 66 89 4D D8 8B 55 FC 83 CA 40 89 55 FC 8D 85 D8 FB FF FF 89 45 E0 83 BD CC FB FF FF 00 7D 0C C7 85 CC FB FF FF 06 00 00 00 EB 21 83 BD CC FB FF FF 00 75 18 8B 4D D8 81 E1 FF FF 00 00 83 F9 67 75 0A C7 85 CC FB FF FF 01 00 00 00 8B 55 10 83 C2 08 89 55 10 8B 45 10 83 E8 08 8B 08 8B 50 04 89 8D 9C FB FF FF 89 95 A0 FB FF FF 8B 45 F8 50 8B 8D CC FB FF FF 51 0F BE 55 D8 52 8B 45 E0 50 8D 8D 9C FB FF FF 51 FF 15 ?? ?? ?? ?? 83 C4 14 8B 55 FC 81 E2 80 00 00 00 85 D2 74 16 83 BD CC FB FF FF 00 75 0D 8B 45 E0 50 FF 15 ?? ?? ?? ?? 83 C4 04 8B 4D D8 81 E1 FF FF 00 00 83 F9 67 75 1A 8B 55 FC 81 E2 80 00 00 00 85 D2 75 0D 8B 45 E0 50 FF 15 ?? ?? ?? ?? 83 C4 04 8B 4D E0 0F BE 11 83 FA 2D 75 12 8B 45 FC 80 CC 01 89 45 FC 8B 4D E0 83 C1 01 89 4D E0 8B 55 E0 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 DC E9 13 03 00 00 8B 45 FC 0C 40 89 45 FC C7 85 C8 FB FF FF 0A 00 00 00 E9 84 00 00 00 C7 85 C8 FB FF FF 0A 00 00 00 EB 78 C7 85 CC FB FF FF 08 00 00 00 C7 85 D0 FB FF FF 07 00 00 00 EB 0A C7 85 D0 FB FF FF 27 00 00 00 C7 85 C8 FB FF FF 10 00 00 00 8B 4D FC 81 E1 80 00 00 00 85 C9 74 20 66 C7 85 C0 FB FF FF 30 00 8B 95 D0 FB FF FF 83 C2 51 66 89 95 C2 FB FF FF C7 45 F0 02 00 00 00 EB 1F C7 85 C8 FB FF FF 08 00 00 00 8B 45 FC 25 80 00 00 00 85 C0 74 09 8B 4D FC 80 CD 02 89 4D FC 8B 55 FC 81 E2 00 80 00 00 85 D2 74 1D 8D 45 10 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 88 FB FF FF 89 95 8C FB FF FF E9 91 00 00 00 8B 4D FC 83 E1 20 85 C9 74 48 8B 55 FC 83 E2 40 85 D2 74 1E 8D 45 10 50 E8 ?? ?? ?? ?? 83 C4 04 0F BF C0 99 89 85 88 FB FF FF 89 95 8C FB FF FF EB 1E 8D 4D 10 51 E8 ?? ?? ?? ?? 83 C4 04 25 FF FF 00 00 99 89 85 88 FB FF FF 89 95 8C FB FF FF EB 3F 8B 55 FC 83 E2 40 85 D2 74 1B 8D 45 10 50 E8 ?? ?? ?? ?? 83 C4 04 99 89 85 88 FB FF FF 89 95 8C FB FF FF EB 1A 8D 4D 10 51 E8 ?? ?? ?? ?? 83 C4 04 33 D2 89 85 88 FB FF FF 89 95 8C FB FF FF 8B 45 FC 83 E0 40 85 C0 74 3E 83 BD 8C FB FF FF 00 7F 35 7C 09 83 BD 88 FB FF FF 00 73 2A 8B 8D 88 FB FF FF F7 D9 8B 95 8C FB FF FF 83 D2 00 F7 DA 89 8D 94 FB FF FF 89 95 98 FB FF FF 8B 45 FC 80 CC 01 89 45 FC EB 18 8B 8D 88 FB FF FF 89 8D 94 FB FF FF 8B 95 8C FB FF FF 89 95 98 FB FF FF 8B 45 FC 25 00 80 00 00 85 C0 75 1B 8B 8D 94 FB FF FF 8B 95 98 FB FF FF 83 E2 00 89 8D 94 FB FF FF 89 95 98 FB FF FF 83 BD CC FB FF FF 00 7D 0C C7 85 CC FB FF FF 01 00 00 00 EB 08 8B 45 FC 24 F7 89 45 FC 8B 8D 94 FB FF FF 0B 8D 98 FB FF FF 85 C9 75 07 C7 45 F0 00 00 00 00 8D 95 D7 FD FF FF 89 55 E0 8B 85 CC FB FF FF 8B 8D CC FB FF FF 83 E9 01 89 8D CC FB FF FF 85 C0 7F 14 8B 95 94 FB FF FF 0B 95 98 FB FF FF 85 D2 0F 84 81 00 00 00 8B 85 C8 FB FF FF 99 52 50 8B 85 98 FB FF FF 50 8B 8D 94 FB FF FF 51 E8 ?? ?? ?? ?? 83 C0 30 89 85 90 FB FF FF 8B 85 C8 FB FF FF 99 52 50 8B 95 98 FB FF FF 52 8B 85 94 FB FF FF 50 E8 ?? ?? ?? ?? 89 85 94 FB FF FF 89 95 98 FB FF FF 83 BD 90 FB FF FF 39 7E 12 8B 8D 90 FB FF FF 03 8D D0 FB FF FF 89 8D 90 FB FF FF 8B 55 E0 8A 85 90 FB FF FF 88 02 8B 4D E0 83 E9 01 89 4D E0 E9 52 FF FF FF 8D 95 D7 FD FF FF 2B 55 E0 89 55 DC 8B 45 E0 83 C0 01 89 45 E0 8B 4D FC 81 E1 00 02 00 00 85 C9 74 29 8B 55 E0 0F BE 02 83 F8 30 75 06 83 7D DC 00 75 18 8B 4D E0 83 E9 01 89 4D E0 8B 55 E0 C6 02 30 8B 45 DC 83 C0 01 89 45 DC 83 BD C4 FB FF FF 00 0F 85 BE 01 00 00 8B 4D FC 83 E1 40 85 C9 74 55 8B 55 FC 81 E2 00 01 00 00 85 D2 74 12 66 C7 85 C0 FB FF FF 2D 00 C7 45 F0 01 00 00 00 EB 36 8B 45 FC 83 E0 01 85 C0 74 12 66 C7 85 C0 FB FF FF 2B 00 C7 45 F0 01 00 00 00 EB 1A 8B 4D FC 83 E1 02 85 C9 74 10 66 C7 85 C0 FB FF FF 20 00 C7 45 F0 01 00 00 00 8B 95 BC FB FF FF 2B 55 DC 2B 55 F0 89 95 84 FB FF FF 8B 45 FC 83 E0 0C 85 C0 75 1C 8D 8D D4 FB FF FF 51 8B 55 08 52 8B 85 84 FB FF FF 50 6A 20 E8 ?? ?? ?? ?? 83 C4 10 8D 8D D4 FB FF FF 51 8B 55 08 52 8B 45 F0 50 8D 8D C0 FB FF FF 51 E8 ?? ?? ?? ?? 83 C4 10 8B 55 FC 83 E2 08 85 D2 74 26 8B 45 FC 83 E0 04 85 C0 75 1C 8D 8D D4 FB FF FF 51 8B 55 08 52 8B 85 84 FB FF FF 50 6A 30 E8 ?? ?? ?? ?? 83 C4 10 83 7D E4 00 0F 85 8E 00 00 00 83 7D DC 00 0F 8E 84 00 00 00 8B 4D E0 89 8D 80 FB FF FF 8B 55 DC 89 95 7C FB FF FF 8B 85 7C FB FF FF 8B 8D 7C FB FF FF 83 E9 01 89 8D 7C FB FF FF 85 C0 7E 57 8B 15 ?? ?? ?? ?? 52 8B 85 80 FB FF FF 50 8D 4D EC 51 E8 ?? ?? ?? ?? 83 C4 0C 89 85 78 FB FF FF 83 BD 78 FB FF FF 00 7F 02 EB 2C 8D 95 D4 FB FF FF 52 8B 45 08 50 66 8B 4D EC 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 95 80 FB FF FF 03 95 78 FB FF FF 89 95 80 FB FF FF EB 90 EB 1B 8D 85 D4 FB FF FF 50 8B 4D 08 51 8B 55 DC 52 8B 45 E0 50 E8 ?? ?? ?? ?? 83 C4 10 8B 4D FC 83 E1 04 85 C9 74 1C 8D 95 D4 FB FF FF 52 8B 45 08 50 8B 8D 84 FB FF FF 51 6A 20 E8 ?? ?? ?? ?? 83 C4 10 E9 24 F4 FF FF 8B 85 D4 FB FF FF 8B E5 5D C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 05 05 01 05 05 05 05 05 05 05 02 05 03 05 05 04 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 0E 01 0E 01 0E 0E 0E 0E 0E 0E 0E 0E 0E 0E 0E 02 0E 0E 0E 0E 03 0E 04 0E 0E 0E 0E 0E 0E 0E 0E 05 06 07 07 07 0E 06 0E 0E 0E 0E 08 09 0A 0E 0E 0B 0E 0C 0E 0E 0D }
	condition:
		$1
}

rule file_147_1_0 {
	meta:
		name = "_write_char"
		size = 58
		refs = "000d _fputwc"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 66 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 25 FF FF 00 00 3D FF FF 00 00 75 0B 8B 55 10 C7 02 FF FF FF FF EB 0D 8B 45 10 8B 08 83 C1 01 8B 55 10 89 0A 5D C3 }
	condition:
		$1
}

rule file_147_2_0 {
	meta:
		name = "_write_multi_char"
		size = 54
		refs = "0021 _write_char"
	strings:
		$1 = { 55 8B EC 8B 45 0C 8B 4D 0C 83 E9 01 89 4D 0C 85 C0 7E 21 8B 55 14 52 8B 45 10 50 66 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 14 83 3A FF 75 02 EB 02 EB CF 5D C3 }
	condition:
		$1
}

rule file_147_3_0 {
	meta:
		name = "_write_string"
		size = 76
		refs = "0035 _write_char"
	strings:
		$1 = { 55 8B EC 51 8B 45 0C 8B 4D 0C 83 E9 01 89 4D 0C 85 C0 7E 34 8B 55 14 52 8B 45 10 50 8B 4D 08 66 8B 11 66 89 55 FE 66 8B 45 FE 50 8B 4D 08 83 C1 02 89 4D 08 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 14 83 3A FF 75 02 EB 02 EB BC 8B E5 5D C3 }
	condition:
		$1
}

rule file_147_4_0 {
	meta:
		name = "_get_int_arg"
		size = 26
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 08 83 C1 04 8B 55 08 89 0A 8B 45 08 8B 08 8B 41 FC 5D C3 }
	condition:
		$1
}

rule file_147_5_0 {
	meta:
		name = "_get_int64_arg"
		size = 31
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 08 83 C1 08 8B 55 08 89 0A 8B 45 08 8B 08 83 E9 08 8B 01 8B 51 04 5D C3 }
	condition:
		$1
}

rule file_148_0_0 {
	meta:
		name = "__mbsrev"
		size = 210
		refs = "0014 ___ismbcodepage 0020 __strrev 0042 __mbctype"
	strings:
		$1 = { 55 8B EC 83 EC 0C 8B 45 08 89 45 F8 8B 4D 08 89 4D F4 83 3D ?? ?? ?? ?? 00 75 11 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 E9 A2 00 00 00 8B 45 08 33 C9 8A 08 85 C9 74 55 8B 55 08 33 C0 8A 02 33 C9 8A 88 ?? ?? ?? ?? 83 E1 04 8B 55 08 83 C2 01 89 55 08 85 C9 74 34 8B 45 08 33 C9 8A 08 85 C9 74 27 8B 55 08 8A 02 88 45 FC 8B 4D 08 8B 55 08 8A 42 FF 88 01 8B 4D 08 8A 55 FC 88 51 FF 8B 45 08 83 C0 01 89 45 08 EB 02 EB 02 EB A0 8B 4D 08 83 E9 01 89 4D 08 8B 55 F4 3B 55 08 73 2E 8B 45 F4 8A 08 88 4D FC 8B 55 F4 8B 45 08 8A 08 88 0A 8B 55 F4 83 C2 01 89 55 F4 8B 45 08 8A 4D FC 88 08 8B 55 08 83 EA 01 89 55 08 EB CA 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_149_0_0 {
	meta:
		name = "__wspawnlpe"
		size = 246
		refs = "000e ??_C@_0BB@COCE@filename?5?$CB?$DN?5NULL?$AA@ 0017 ??_C@_0L@GDDK@spawnlpe?4c?$AA@ 001e __CrtDbgReport 003e ??_C@_0BG@GALO@?$CKfilename?5?$CB?$DN?5_T?$CI?8?20?8?$CJ?$AA@ 0068 ??_C@_0BA@BICO@arglist?5?$CB?$DN?5NULL?$AA@ 0098 ??_C@_0BF@GGKN@?$CKarglist?5?$CB?$DN?5_T?$CI?8?20?8?$CJ?$AA@ 00e8 __wspawnvpe"
	strings:
		$1 = { 55 8B EC 51 53 56 57 83 7D 0C 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3A 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D6 8B 4D 0C 33 D2 66 8B 11 85 D2 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3B 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D0 83 7D 10 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3C 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D6 8B 55 10 33 C0 66 8B 02 85 C0 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3D 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D0 8D 55 10 89 55 FC 8B 45 FC 8B 08 8B 55 FC 83 C2 04 89 55 FC 85 C9 74 02 EB EC 8B 45 FC 8B 08 51 8D 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 10 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_150_1_0 {
	meta:
		name = "__CrtSetReportMode"
		size = 87
		refs = "0021 __CrtDbgMode"
	strings:
		$1 = { 55 8B EC 51 83 7D 08 00 7C 06 83 7D 08 03 7C 05 83 C8 FF EB 3E 83 7D 0C FF 75 0C 8B 45 08 8B 04 85 ?? ?? ?? ?? EB 2C 8B 4D 0C 83 E1 F8 85 C9 74 05 83 C8 FF EB 1D 8B 55 08 8B 04 95 ?? ?? ?? ?? 89 45 FC 8B 4D 08 8B 55 0C 89 14 8D ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_150_2_0 {
	meta:
		name = "__CrtSetReportFile"
		size = 126
		refs = "0023 __CrtDbgFile 0040 __imp__GetStdHandle@4"
	strings:
		$1 = { 55 8B EC 51 83 7D 08 00 7C 06 83 7D 08 03 7C 07 B8 FE FF FF FF EB 63 83 7D 0C FA 75 0C 8B 45 08 8B 04 85 ?? ?? ?? ?? EB 51 8B 4D 08 8B 14 8D ?? ?? ?? ?? 89 55 FC 83 7D 0C FC 75 14 6A F5 FF 15 ?? ?? ?? ?? 8B 4D 08 89 04 8D ?? ?? ?? ?? EB 27 83 7D 0C FB 75 14 6A F4 FF 15 ?? ?? ?? ?? 8B 55 08 89 04 95 ?? ?? ?? ?? EB 0D 8B 45 08 8B 4D 0C 89 0C 85 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_150_4_0 {
	meta:
		name = "__CrtDbgReport"
		size = 912
		refs = "0009 __chkstk 0081 __crtAssertBusy 0087 __imp__InterlockedIncrement@4 0095 _?pfnwsprintfA@?2??_CrtDbgReport@@9@9 009d ??_C@_0L@HKL@user32?4dll?$AA@ 00a3 __imp__LoadLibraryA@4 00b7 ??_C@_09NJAK@wsprintfA?$AA@ 00c4 __imp__GetProcAddress@8 00e7 ??_C@_0DC@EMDK@Second?5Chance?5Assertion?5Failed?3?5@ 0104 __imp__OutputDebugStringA@4 010f __imp__InterlockedDecrement@4 0114 __CrtDbgBreak 013e __vsnprintf 014a ??_C@_0CL@LCCP@_CrtDbgReport?3?5String?5too?5long?5o@ 0156 _strcpy 016f ??_C@_0BD@BEAK@Assertion?5failed?3?5?$AA@ 017b ??_C@_0BC@OIMC@Assertion?5failed?$CB?$AA@ 01a4 _strcat 01b7 __CrtDbgMode 01c3 ??_C@_01FEHD@?$AN?$AA@ 01d7 ??_C@_01BJG@?6?$AA@ 0200 ??_C@_0M@ODEP@?$CFs?$CI?$CFd?$CJ?5?3?5?$CFs?$AA@ 0211 __snprintf 024a __pfnReportHook 02a3 __CrtDbgFile 02bb _strlen 02d7 __imp__WriteFile@20 031e __itoa 0352 _CrtMessageWindow"
	strings:
		$1 = { 55 8B EC B8 2C 30 00 00 E8 ?? ?? ?? ?? 57 C6 85 F8 CF FF FF 00 B9 FF 03 00 00 33 C0 8D BD F9 CF FF FF F3 AB 66 AB AA C6 85 F8 DF FF FF 00 B9 FF 03 00 00 33 C0 8D BD F9 DF FF FF F3 AB 66 AB AA C6 85 00 F0 FF FF 00 B9 FF 03 00 00 33 C0 8D BD 01 F0 FF FF F3 AB 66 AB AA 8D 45 1C 89 85 FC EF FF FF 83 7D 08 00 7C 06 83 7D 08 03 7C 08 83 C8 FF E9 15 03 00 00 83 7D 08 02 0F 85 A0 00 00 00 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 0F 8E 8D 00 00 00 83 3D ?? ?? ?? ?? 00 75 42 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 89 85 F4 CF FF FF 83 BD F4 CF FF FF 00 74 20 68 ?? ?? ?? ?? 8B 8D F4 CF FF FF 51 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 75 08 83 C8 FF E9 AD 02 00 00 8B 55 10 52 8B 45 0C 50 68 ?? ?? ?? ?? 8D 8D F8 DF FF FF 51 FF 15 ?? ?? ?? ?? 83 C4 10 8D 95 F8 DF FF FF 52 FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C8 FF E9 6B 02 00 00 83 7D 18 00 74 37 8B 85 FC EF FF FF 50 8B 4D 18 51 68 ED 0F 00 00 8D 95 00 F0 FF FF 52 E8 ?? ?? ?? ?? 83 C4 10 85 C0 7D 14 68 ?? ?? ?? ?? 8D 85 00 F0 FF FF 50 E8 ?? ?? ?? ?? 83 C4 08 83 7D 08 02 75 32 83 7D 18 00 74 0C C7 85 D8 CF FF FF ?? ?? ?? ?? EB 0A C7 85 D8 CF FF FF ?? ?? ?? ?? 8B 8D D8 CF FF FF 51 8D 95 F8 CF FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 8D 85 00 F0 FF FF 50 8D 8D F8 CF FF FF 51 E8 ?? ?? ?? ?? 83 C4 08 83 7D 08 02 75 39 8B 55 08 8B 04 95 ?? ?? ?? ?? 83 E0 01 85 C0 74 14 68 ?? ?? ?? ?? 8D 8D F8 CF FF FF 51 E8 ?? ?? ?? ?? 83 C4 08 68 ?? ?? ?? ?? 8D 95 F8 CF FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 83 7D 0C 00 74 42 8D 85 F8 CF FF FF 50 8B 4D 10 51 8B 55 0C 52 68 ?? ?? ?? ?? 68 00 10 00 00 8D 85 F8 DF FF FF 50 E8 ?? ?? ?? ?? 83 C4 18 85 C0 7D 14 68 ?? ?? ?? ?? 8D 8D F8 DF FF FF 51 E8 ?? ?? ?? ?? 83 C4 08 EB 16 8D 95 F8 CF FF FF 52 8D 85 F8 DF FF FF 50 E8 ?? ?? ?? ?? 83 C4 08 83 3D ?? ?? ?? ?? 00 74 3B 8D 8D F8 EF FF FF 51 8D 95 F8 DF FF FF 52 8B 45 08 50 FF 15 ?? ?? ?? ?? 83 C4 0C 85 C0 74 1C 83 7D 08 02 75 0B 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B 85 F8 EF FF FF E9 FF 00 00 00 8B 4D 08 8B 14 8D ?? ?? ?? ?? 83 E2 01 85 D2 74 3E 8B 45 08 83 3C 85 ?? ?? ?? ?? FF 74 31 6A 00 8D 8D F0 CF FF FF 51 8D 95 F8 DF FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 50 8D 85 F8 DF FF FF 50 8B 4D 08 8B 14 8D ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 8B 45 08 8B 0C 85 ?? ?? ?? ?? 83 E1 02 85 C9 74 0D 8D 95 F8 DF FF FF 52 FF 15 ?? ?? ?? ?? 8B 45 08 8B 0C 85 ?? ?? ?? ?? 83 E1 04 85 C9 74 6E 83 7D 10 00 74 1D 6A 0A 8D 95 DC CF FF FF 52 8B 45 10 50 E8 ?? ?? ?? ?? 83 C4 0C 89 85 D4 CF FF FF EB 0A C7 85 D4 CF FF FF 00 00 00 00 8D 8D 00 F0 FF FF 51 8B 55 14 52 8B 85 D4 CF FF FF 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 14 89 85 F8 EF FF FF 83 7D 08 02 75 0B 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B 85 F8 EF FF FF EB 13 83 7D 08 02 75 0B 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 33 C0 5F 8B E5 5D C3 }
	condition:
		$1
}

rule file_150_5_0 {
	meta:
		name = "_CrtMessageWindow"
		size = 780
		refs = "0009 __chkstk 0014 ??_C@_0BG@FBEA@szUserMessage?5?$CB?$DN?5NULL?$AA@ 0020 ??_C@_08GFHP@dbgrpt?4c?$AA@ 0027 __CrtDbgReport 0034 __CrtDbgBreak 004e __imp__GetModuleFileNameA@12 0057 ??_C@_0BH@NNCD@?$DMprogram?5name?5unknown?$DO?$AA@ 0063 _strcpy 0078 _strlen 009d ??_C@_03NAME@?4?4?4?$AA@ 00a6 _strncpy 0114 ??_C@_0HD@BHFH@?6?6For?5information?5on?5how?5your?5pr@ 0120 ??_C@_00A@?$AA@ 0159 ??_C@_0N@NOAB@Expression?3?5?$AA@ 0179 ??_C@_02JJJH@?6?6?$AA@ 01b0 ??_C@_07LFGN@?6Line?3?5?$AA@ 01e7 ??_C@_07HJII@?6File?3?5?$AA@ 0227 ??_C@_09DCKN@?6Module?3?5?$AA@ 0287 __CrtDbgModeMsg 028d ??_C@_0FD@EBDD@Debug?5?$CFs?$CB?6?6Program?3?5?$CFs?$CFs?$CFs?$CFs?$CFs?$CFs@ 029e __snprintf 02aa ??_C@_0CL@LCCP@_CrtDbgReport?3?5String?5too?5long?5o@ 02c3 ??_C@_0CD@GCMD@Microsoft?5Visual?5C?$CL?$CL?5Debug?5Libra@ 02cf ___crtMessageBoxA 02e8 _raise 02f2 __exit"
	strings:
		$1 = { 55 8B EC B8 38 11 00 00 E8 ?? ?? ?? ?? 83 7D 18 00 75 25 68 ?? ?? ?? ?? 6A 00 68 DA 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 05 E8 ?? ?? ?? ?? 33 C0 85 C0 75 CF 68 04 01 00 00 8D 8D F8 FE FF FF 51 6A 00 FF 15 ?? ?? ?? ?? 85 C0 75 14 68 ?? ?? ?? ?? 8D 95 F8 FE FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 8D 85 F8 FE FF FF 89 45 FC 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 83 F8 40 76 29 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D FC 8D 54 01 C0 89 55 FC 6A 03 68 ?? ?? ?? ?? 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D 14 89 8D F0 EE FF FF 83 BD F0 EE FF FF 00 74 49 8B 95 F0 EE FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 83 F8 40 76 35 8B 85 F0 EE FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 8B 8D F0 EE FF FF 8D 54 01 C0 89 95 F0 EE FF FF 6A 03 68 ?? ?? ?? ?? 8B 85 F0 EE FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 83 7D 08 02 75 0C C7 85 EC EE FF FF ?? ?? ?? ?? EB 0A C7 85 EC EE FF FF ?? ?? ?? ?? 8B 4D 18 0F BE 11 85 D2 74 0B 8B 45 18 89 85 E8 EE FF FF EB 0A C7 85 E8 EE FF FF ?? ?? ?? ?? 8B 4D 18 0F BE 11 85 D2 74 12 83 7D 08 02 75 0C C7 85 E4 EE FF FF ?? ?? ?? ?? EB 0A C7 85 E4 EE FF FF ?? ?? ?? ?? 8B 45 18 0F BE 08 85 C9 74 0C C7 85 E0 EE FF FF ?? ?? ?? ?? EB 0A C7 85 E0 EE FF FF ?? ?? ?? ?? 83 7D 10 00 74 0B 8B 55 10 89 95 DC EE FF FF EB 0A C7 85 DC EE FF FF ?? ?? ?? ?? 83 7D 10 00 74 0C C7 85 D8 EE FF FF ?? ?? ?? ?? EB 0A C7 85 D8 EE FF FF ?? ?? ?? ?? 83 7D 0C 00 74 0B 8B 45 0C 89 85 D4 EE FF FF EB 0A C7 85 D4 EE FF FF ?? ?? ?? ?? 83 7D 0C 00 74 0C C7 85 D0 EE FF FF ?? ?? ?? ?? EB 0A C7 85 D0 EE FF FF ?? ?? ?? ?? 83 BD F0 EE FF FF 00 74 0E 8B 8D F0 EE FF FF 89 8D CC EE FF FF EB 0A C7 85 CC EE FF FF ?? ?? ?? ?? 83 BD F0 EE FF FF 00 74 0C C7 85 C8 EE FF FF ?? ?? ?? ?? EB 0A C7 85 C8 EE FF FF ?? ?? ?? ?? 8B 95 EC EE FF FF 52 8B 85 E8 EE FF FF 50 8B 8D E4 EE FF FF 51 8B 95 E0 EE FF FF 52 8B 85 DC EE FF FF 50 8B 8D D8 EE FF FF 51 8B 95 D4 EE FF FF 52 8B 85 D0 EE FF FF 50 8B 8D CC EE FF FF 51 8B 95 C8 EE FF FF 52 8B 45 FC 50 8B 4D 08 8B 14 8D ?? ?? ?? ?? 52 68 ?? ?? ?? ?? 68 00 10 00 00 8D 85 F4 EE FF FF 50 E8 ?? ?? ?? ?? 83 C4 3C 85 C0 7D 14 68 ?? ?? ?? ?? 8D 8D F4 EE FF FF 51 E8 ?? ?? ?? ?? 83 C4 08 68 12 20 01 00 68 ?? ?? ?? ?? 8D 95 F4 EE FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 89 85 F4 FE FF FF 83 BD F4 FE FF FF 03 75 11 6A 16 E8 ?? ?? ?? ?? 83 C4 04 6A 03 E8 ?? ?? ?? ?? 83 BD F4 FE FF FF 04 75 07 B8 01 00 00 00 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_151_0_0 {
	meta:
		name = "__mbsncmp"
		size = 363
		refs = "0015 ___ismbcodepage 0029 _strncmp 006a __mbctype"
	strings:
		$1 = { 55 8B EC 83 EC 10 83 7D 10 00 75 07 33 C0 E9 54 01 00 00 83 3D ?? ?? ?? ?? 00 75 19 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C E9 32 01 00 00 8B 45 10 8B 4D 10 83 E9 01 89 4D 10 85 C0 0F 84 1C 01 00 00 8B 55 08 66 0F B6 02 66 89 45 FC 8B 4D 08 83 C1 01 89 4D 08 8B 55 FC 81 E2 FF 00 00 00 33 C0 8A 82 ?? ?? ?? ?? 83 E0 04 85 C0 74 3C 8B 4D 08 33 D2 8A 11 85 D2 75 09 C7 45 F4 00 00 00 00 EB 20 8B 45 FC 25 FF FF 00 00 C1 E0 08 8B 4D 08 33 D2 8A 11 0B C2 89 45 F4 8B 45 08 83 C0 01 89 45 08 66 8B 4D F4 66 89 4D FC 8B 55 0C 66 0F B6 02 66 89 45 F8 8B 4D 0C 83 C1 01 89 4D 0C 8B 55 F8 81 E2 FF 00 00 00 33 C0 8A 82 ?? ?? ?? ?? 83 E0 04 85 C0 74 3C 8B 4D 0C 33 D2 8A 11 85 D2 75 09 C7 45 F0 00 00 00 00 EB 20 8B 45 F8 25 FF FF 00 00 C1 E0 08 8B 4D 0C 33 D2 8A 11 0B C2 89 45 F0 8B 45 0C 83 C0 01 89 45 0C 66 8B 4D F0 66 89 4D F8 8B 55 FC 81 E2 FF FF 00 00 8B 45 F8 25 FF FF 00 00 3B D0 74 22 8B 4D FC 81 E1 FF FF 00 00 8B 55 F8 81 E2 FF FF 00 00 33 C0 3B CA 0F 9E C0 48 83 E0 02 83 C0 FF EB 17 8B 45 FC 25 FF FF 00 00 85 C0 75 04 33 C0 EB 07 E9 D0 FE FF FF 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_152_0_0 {
	meta:
		name = "__wexeclpe"
		size = 242
		refs = "000e ??_C@_0BB@COCE@filename?5?$CB?$DN?5NULL?$AA@ 0017 ??_C@_09LJIK@execlpe?4c?$AA@ 001e __CrtDbgReport 003e ??_C@_0BG@GALO@?$CKfilename?5?$CB?$DN?5_T?$CI?8?20?8?$CJ?$AA@ 0068 ??_C@_0BA@BICO@arglist?5?$CB?$DN?5NULL?$AA@ 0098 ??_C@_0BF@GGKN@?$CKarglist?5?$CB?$DN?5_T?$CI?8?20?8?$CJ?$AA@ 00e4 __wexecvpe"
	strings:
		$1 = { 55 8B EC 51 53 56 57 83 7D 08 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 32 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D6 8B 4D 08 33 D2 66 8B 11 85 D2 75 1E 68 ?? ?? ?? ?? 6A 00 6A 33 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D0 83 7D 0C 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 34 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D6 8B 55 0C 33 C0 66 8B 02 85 C0 75 1E 68 ?? ?? ?? ?? 6A 00 6A 35 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D0 8D 55 0C 89 55 FC 8B 45 FC 8B 08 8B 55 FC 83 C2 04 89 55 FC 85 C9 74 02 EB EC 8B 45 FC 8B 08 51 8D 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_153_0_0 {
	meta:
		name = "_strncmp"
		size = 26
	strings:
		$1 = { 55 8B EC 57 56 53 8B 4D 10 E3 26 8B D9 8B 7D 08 8B F7 33 C0 F2 AE F7 D9 03 CB }
	condition:
		$1
}

rule file_153_1_0 {
	meta:
		name = "okay"
		size = 19
	strings:
		$1 = { 8B FE 8B 75 0C F3 A6 8A 46 FF 33 C9 3A 47 FF 77 04 74 04 }
	condition:
		$1
}

rule file_154_0_0 {
	meta:
		name = "__mbsnbcpy"
		size = 273
		refs = "000c ___ismbcodepage 0020 _strncpy 004a __mbctype"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 89 45 FC 83 3D ?? ?? ?? ?? 00 75 19 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C E9 E1 00 00 00 83 7D 10 00 0F 84 B3 00 00 00 8B 4D 10 83 E9 01 89 4D 10 8B 55 0C 33 C0 8A 02 33 C9 8A 88 ?? ?? ?? ?? 83 E1 04 85 C9 74 66 8B 55 08 8B 45 0C 8A 08 88 0A 8B 55 08 83 C2 01 89 55 08 8B 45 0C 83 C0 01 89 45 0C 83 7D 10 00 75 09 8B 4D 08 C6 41 FF 00 EB 69 8B 55 10 83 EA 01 89 55 10 8B 45 08 8B 4D 0C 8A 11 88 10 8B 45 08 33 C9 8A 08 8B 55 08 83 C2 01 89 55 08 8B 45 0C 83 C0 01 89 45 0C 85 C9 75 09 8B 4D 08 C6 41 FE 00 EB 30 EB 29 8B 55 08 8B 45 0C 8A 08 88 0A 8B 55 08 33 C0 8A 02 8B 4D 08 83 C1 01 89 4D 08 8B 55 0C 83 C2 01 89 55 0C 85 C0 75 02 EB 05 E9 43 FF FF FF 8B 45 10 8B 4D 10 83 E9 01 89 4D 10 85 C0 74 11 8B 55 08 C6 02 00 8B 45 08 83 C0 01 89 45 08 EB DF 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_155_0_0 {
	meta:
		name = "__swab"
		size = 95
	strings:
		$1 = { 55 8B EC 83 EC 08 83 7D 10 01 7E 4F 8B 45 08 8A 08 88 4D F8 8B 55 08 83 C2 01 89 55 08 8B 45 08 8A 08 88 4D FC 8B 55 08 83 C2 01 89 55 08 8B 45 0C 8A 4D FC 88 08 8B 55 0C 83 C2 01 89 55 0C 8B 45 0C 8A 4D F8 88 08 8B 55 0C 83 C2 01 89 55 0C 8B 45 10 83 E8 02 89 45 10 EB AB 8B E5 5D C3 }
	condition:
		$1
}

rule file_156_0_0 {
	meta:
		name = "__wchmod"
		size = 119
		refs = "000a __imp__GetFileAttributesW@4 0019 __imp__GetLastError@0 001f __dosmaperr 0055 __imp__SetFileAttributesW@8"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 50 FF 15 ?? ?? ?? ?? 89 45 FC 83 7D FC FF 75 14 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 83 C8 FF EB 48 8B 4D 0C 81 E1 80 00 00 00 85 C9 74 0B 8B 55 FC 83 E2 FE 89 55 FC EB 08 8B 45 FC 0C 01 89 45 FC 8B 4D FC 51 8B 55 08 52 FF 15 ?? ?? ?? ?? 85 C0 75 14 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 83 C8 FF EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_542_0_0 {
	meta:
		name = "__chmod"
		size = 119
		refs = "000a __imp__GetFileAttributesA@4 0019 __imp__GetLastError@0 001f __dosmaperr 0055 __imp__SetFileAttributesA@8"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 50 FF 15 ?? ?? ?? ?? 89 45 FC 83 7D FC FF 75 14 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 83 C8 FF EB 48 8B 4D 0C 81 E1 80 00 00 00 85 C9 74 0B 8B 55 FC 83 E2 FE 89 55 FC EB 08 8B 45 FC 0C 01 89 45 FC 8B 4D FC 51 8B 55 08 52 FF 15 ?? ?? ?? ?? 85 C0 75 14 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 83 C8 FF EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_158_0_0 {
	meta:
		name = "__getpath"
		size = 300
	strings:
		$1 = { 55 8B EC 51 8B 45 08 0F BE 08 83 F9 3B 75 0B 8B 55 08 83 C2 01 89 55 08 EB EA 8B 45 08 89 45 FC 8B 4D 10 83 E9 01 89 4D 10 83 7D 10 00 75 05 E9 E1 00 00 00 8B 55 08 0F BE 02 85 C0 0F 84 BD 00 00 00 8B 4D 08 0F BE 11 83 FA 3B 0F 84 AE 00 00 00 8B 45 08 0F BE 08 83 F9 22 74 38 8B 55 0C 8B 45 08 8A 08 88 0A 8B 55 0C 83 C2 01 89 55 0C 8B 45 08 83 C0 01 89 45 08 8B 4D 10 83 E9 01 89 4D 10 83 7D 10 00 75 0B 8B 55 08 89 55 FC E9 83 00 00 00 EB 66 8B 45 08 83 C0 01 89 45 08 8B 4D 08 0F BE 11 85 D2 74 40 8B 45 08 0F BE 08 83 F9 22 74 35 8B 55 0C 8B 45 08 8A 08 88 0A 8B 55 0C 83 C2 01 89 55 0C 8B 45 08 83 C0 01 89 45 08 8B 4D 10 83 E9 01 89 4D 10 83 7D 10 00 75 08 8B 55 08 89 55 FC EB 30 EB B6 8B 45 08 0F BE 08 85 C9 74 09 8B 55 08 83 C2 01 89 55 08 E9 35 FF FF FF 8B 45 08 0F BE 08 83 F9 3B 75 0B 8B 55 08 83 C2 01 89 55 08 EB EA 8B 45 0C C6 00 00 8B 45 FC 2B 45 08 F7 D8 1B C0 23 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_159_0_0 {
	meta:
		name = "__wspawnvpe"
		size = 664
		refs = "0017 ??_C@_0BB@COCE@filename?5?$CB?$DN?5NULL?$AA@ 0020 ??_C@_0L@CAAP@spawnvpe?4c?$AA@ 0027 __CrtDbgReport 0047 ??_C@_0BG@GALO@?$CKfilename?5?$CB?$DN?5_T?$CI?8?20?8?$CJ?$AA@ 0071 ??_C@_0N@IMCP@argv?5?$CB?$DN?5NULL?$AA@ 009d ??_C@_0O@IICG@?$CKargv?5?$CB?$DN?5NULL?$AA@ 00cf ??_C@_0BD@MODE@?$CK?$CKargv?5?$CB?$DN?5_T?$CI?8?20?8?$CJ?$AA@ 0103 __wspawnve 0115 _errno 0123 _wcschr 012f ??_C@_19KDPP@?$AAP?$AAA?$AAT?$AAH?$AA?$AA@ 0134 __wgetenv 0153 __malloc_dbg 0176 __wgetpath 019f _wcslen 01cb ??_C@_13HMCP@?$AA?2?$AA?$AA@ 01d4 _wcscat 0287 __free_dbg"
	strings:
		$1 = { 55 8B EC 83 EC 10 53 56 57 C7 45 FC 00 00 00 00 83 7D 0C 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 4C 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D6 8B 4D 0C 33 D2 66 8B 11 85 D2 75 1E 68 ?? ?? ?? ?? 6A 00 6A 4D 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D0 83 7D 10 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 4E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D6 8B 55 10 83 3A 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 4F 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D4 8B 4D 10 8B 11 33 C0 66 8B 02 85 C0 75 1E 68 ?? ?? ?? ?? 6A 00 6A 50 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 CE 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 89 45 F4 83 7D F4 FF 75 50 83 3D ?? ?? ?? ?? 02 75 47 6A 2F 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 35 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 89 45 F8 83 7D F8 00 74 1F 6A 61 68 ?? ?? ?? ?? 6A 02 68 08 02 00 00 E8 ?? ?? ?? ?? 83 C4 10 89 45 FC 83 7D FC 00 75 05 E9 12 01 00 00 68 03 01 00 00 8B 4D FC 51 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F8 83 7D F8 00 0F 84 F0 00 00 00 8B 45 FC 33 C9 66 8B 08 85 C9 0F 84 E0 00 00 00 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D FC 8D 54 41 FE 89 55 F0 8B 45 F0 33 C9 66 8B 08 83 F9 5C 74 1E 8B 55 F0 33 C0 66 8B 02 83 F8 2F 74 11 68 ?? ?? ?? ?? 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 8B F0 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 04 03 F0 81 FE 04 01 00 00 73 12 8B 4D 0C 51 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 08 EB 02 EB 67 8B 45 14 50 8B 4D 10 51 8B 55 FC 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 F4 83 7D F4 FF 75 3F 83 3D ?? ?? ?? ?? 02 74 38 8B 4D FC 33 D2 66 8B 11 83 FA 5C 74 0D 8B 45 FC 33 C9 66 8B 08 83 F9 2F 75 1C 8B 55 FC 33 C0 66 8B 42 02 83 F8 5C 74 10 8B 4D FC 33 D2 66 8B 51 02 83 FA 2F 74 02 EB 05 E9 EE FE FF FF 83 7D FC 00 74 0E 6A 02 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 8B 45 F4 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_160_1_0 {
	meta:
		name = "_sin"
		size = 154
		refs = "0005 __fload_withFB 001a __DEFAULT_CW_in_mem 0028 ___fastflag 002f __fast_exit 003a _NAME_ 003f __math_exit 0045 __pi_by_2_to_61 005a __convertTOStoQNaN 0072 __indefinite 0094 __startOneArgErrorHandling"
	strings:
		$1 = { 8D 54 24 04 E8 ?? ?? ?? ?? 52 9B D9 3C 24 74 50 66 81 3C 24 7F 02 74 06 D9 2D ?? ?? ?? ?? D9 FE 9B DF E0 9E 7A 1D 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 1E 00 00 00 8D 0D ?? ?? ?? ?? E9 ?? ?? ?? ?? DB 2D ?? ?? ?? ?? D9 C9 D9 F5 9B DF E0 9E 7A F8 DD D9 D9 FE EB CD E8 ?? ?? ?? ?? EB 1B A9 FF FF 0F 00 75 F2 83 7C 24 08 00 75 EB DD D8 DB 2D ?? ?? ?? ?? B8 01 00 00 00 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 1E 00 00 00 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule file_161_0_0 {
	meta:
		name = "_memchr"
		size = 27
	strings:
		$1 = { 8B 44 24 0C 53 85 C0 74 4A 8B 54 24 08 33 DB 8A 5C 24 0C F7 C2 03 00 00 00 74 12 }
	condition:
		$1
}

rule file_161_1_0 {
	meta:
		name = "str_misaligned"
		size = 18
	strings:
		$1 = { 8A 0A 42 32 CB 74 6C 48 74 2E F7 C2 03 00 00 00 75 EE }
	condition:
		$1
}

rule file_161_2_0 {
	meta:
		name = "main_loop_start"
		size = 22
	strings:
		$1 = { 83 E8 04 72 12 57 8B FB C1 E3 08 03 DF 8B FB C1 E3 10 03 DF EB 17 }
	condition:
		$1
}

rule file_161_8_0 {
	meta:
		name = "main_loop_entry"
		size = 27
	strings:
		$1 = { 8B 0A 33 CB BF FF FE FE 7E 03 F9 83 F1 FF 33 CF 83 C2 04 81 E1 00 01 01 81 74 E0 }
	condition:
		$1
}

rule file_161_9_0 {
	meta:
		name = "char_is_found"
		size = 24
	strings:
		$1 = { 8B 4A FC 32 CB 74 23 32 EB 74 19 C1 E9 10 32 CB 74 0C 32 EB 74 02 EB C8 }
	condition:
		$1
}

rule file_162_0_0 {
	meta:
		name = "__wstati64"
		size = 1195
		refs = "000b ??_C@_15BBGC@?$AA?$DP?$AA?$CK?$AA?$AA@ 0014 _wcspbrk 0021 _errno 002b __doserrno 0086 _towlower 009e __getdrive 00b5 __imp__FindFirstFileW@8 00cd ??_C@_17FIDB@?$AA?4?$AA?1?$AA?2?$AA?$AA@ 00f2 __wfullpath 0110 _wcslen 0124 _IsRootUNCName 0138 __imp__GetDriveTypeW@4 0196 ___loctotime_t 01d0 __imp__FileTimeToLocalFileTime@8 01e8 __imp__FileTimeToSystemTime@8 01f2 __imp__GetLastError@0 01f8 __dosmaperr 0208 __imp__FindClose@4 0431 ___wdtoxmode 0457 __allmul"
	strings:
		$1 = { 55 8B EC 81 EC 7C 04 00 00 56 68 ?? ?? ?? ?? 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 1C C7 05 ?? ?? ?? ?? 02 00 00 00 C7 05 ?? ?? ?? ?? 02 00 00 00 83 C8 FF E9 6B 04 00 00 8B 4D 08 33 D2 66 8B 51 02 83 FA 3A 75 54 8B 45 08 33 C9 66 8B 08 85 C9 74 29 8B 55 08 33 C0 66 8B 42 04 85 C0 75 1C C7 05 ?? ?? ?? ?? 02 00 00 00 C7 05 ?? ?? ?? ?? 02 00 00 00 83 C8 FF E9 28 04 00 00 8B 4D 08 66 8B 11 52 E8 ?? ?? ?? ?? 83 C4 04 25 FF FF 00 00 83 E8 60 89 85 9C FB FF FF EB 0B E8 ?? ?? ?? ?? 89 85 9C FB FF FF 8D 85 B0 FD FF FF 50 8B 4D 08 51 FF 15 ?? ?? ?? ?? 89 85 A8 FD FF FF 83 BD A8 FD FF FF FF 0F 85 F4 00 00 00 68 ?? ?? ?? ?? 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 60 68 04 01 00 00 8B 45 08 50 8D 8D A0 FB FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 89 85 AC FD FF FF 83 BD AC FD FF FF 00 74 39 8B 95 AC FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 83 F8 03 74 13 8B 85 AC FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 12 8B 8D AC FD FF FF 51 FF 15 ?? ?? ?? ?? 83 F8 01 77 1C C7 05 ?? ?? ?? ?? 02 00 00 00 C7 05 ?? ?? ?? ?? 02 00 00 00 83 C8 FF E9 49 03 00 00 C7 85 B0 FD FF FF 10 00 00 00 C7 85 CC FD FF FF 00 00 00 00 C7 85 D0 FD FF FF 00 00 00 00 66 C7 85 DC FD FF FF 00 00 6A FF 6A 00 6A 00 6A 00 6A 01 6A 01 68 BC 07 00 00 E8 ?? ?? ?? ?? 83 C4 1C 8B 55 0C 89 42 24 8B 45 0C 8B 4D 0C 8B 51 24 89 50 20 8B 45 0C 8B 4D 0C 8B 51 24 89 50 28 E9 65 02 00 00 8D 85 84 FB FF FF 50 8D 8D C4 FD FF FF 51 FF 15 ?? ?? ?? ?? 85 C0 74 18 8D 95 8C FB FF FF 52 8D 85 84 FB FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 75 24 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 8B 8D A8 FD FF FF 51 FF 15 ?? ?? ?? ?? 83 C8 FF E9 92 02 00 00 6A FF 8B 95 98 FB FF FF 81 E2 FF FF 00 00 52 8B 85 96 FB FF FF 25 FF FF 00 00 50 8B 8D 94 FB FF FF 81 E1 FF FF 00 00 51 8B 95 92 FB FF FF 81 E2 FF FF 00 00 52 8B 85 8E FB FF FF 25 FF FF 00 00 50 8B 8D 8C FB FF FF 81 E1 FF FF 00 00 51 E8 ?? ?? ?? ?? 83 C4 1C 8B 55 0C 89 42 24 83 BD BC FD FF FF 00 75 0D 83 BD C0 FD FF FF 00 0F 84 B2 00 00 00 8D 85 84 FB FF FF 50 8D 8D BC FD FF FF 51 FF 15 ?? ?? ?? ?? 85 C0 74 18 8D 95 8C FB FF FF 52 8D 85 84 FB FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 75 24 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 8B 8D A8 FD FF FF 51 FF 15 ?? ?? ?? ?? 83 C8 FF E9 CC 01 00 00 6A FF 8B 95 98 FB FF FF 81 E2 FF FF 00 00 52 8B 85 96 FB FF FF 25 FF FF 00 00 50 8B 8D 94 FB FF FF 81 E1 FF FF 00 00 51 8B 95 92 FB FF FF 81 E2 FF FF 00 00 52 8B 85 8E FB FF FF 25 FF FF 00 00 50 8B 8D 8C FB FF FF 81 E1 FF FF 00 00 51 E8 ?? ?? ?? ?? 83 C4 1C 8B 55 0C 89 42 20 EB 0C 8B 45 0C 8B 4D 0C 8B 51 24 89 50 20 83 BD B4 FD FF FF 00 75 0D 83 BD B8 FD FF FF 00 0F 84 B2 00 00 00 8D 85 84 FB FF FF 50 8D 8D B4 FD FF FF 51 FF 15 ?? ?? ?? ?? 85 C0 74 18 8D 95 8C FB FF FF 52 8D 85 84 FB FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 75 24 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 8B 8D A8 FD FF FF 51 FF 15 ?? ?? ?? ?? 83 C8 FF E9 F8 00 00 00 6A FF 8B 95 98 FB FF FF 81 E2 FF FF 00 00 52 8B 85 96 FB FF FF 25 FF FF 00 00 50 8B 8D 94 FB FF FF 81 E1 FF FF 00 00 51 8B 95 92 FB FF FF 81 E2 FF FF 00 00 52 8B 85 8E FB FF FF 25 FF FF 00 00 50 8B 8D 8C FB FF FF 81 E1 FF FF 00 00 51 E8 ?? ?? ?? ?? 83 C4 1C 8B 55 0C 89 42 28 EB 0C 8B 45 0C 8B 4D 0C 8B 51 24 89 50 28 8B 85 A8 FD FF FF 50 FF 15 ?? ?? ?? ?? 8B 4D 08 51 8B 95 B0 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 8B 4D 0C 66 89 41 06 8B 55 0C 66 C7 42 08 01 00 8B 85 CC FD FF FF 33 C9 6A 01 6A 00 51 50 E8 ?? ?? ?? ?? 8B 8D D0 FD FF FF 33 F6 03 C1 13 D6 8B 4D 0C 89 41 18 89 51 1C 8B 55 0C 66 C7 42 04 00 00 8B 45 0C 66 C7 40 0C 00 00 8B 4D 0C 66 C7 41 0A 00 00 8B 95 9C FB FF FF 83 EA 01 8B 45 0C 89 10 8B 4D 0C 8B 55 0C 8B 02 89 41 10 33 C0 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_162_1_0 {
	meta:
		name = "_IsRootUNCName"
		size = 261
		refs = "0009 _wcslen"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 83 F8 05 0F 82 E6 00 00 00 8B 4D 08 33 D2 66 8B 11 83 FA 5C 74 11 8B 45 08 33 C9 66 8B 08 83 F9 2F 0F 85 C8 00 00 00 8B 55 08 33 C0 66 8B 42 02 83 F8 5C 74 12 8B 4D 08 33 D2 66 8B 51 02 83 FA 2F 0F 85 A8 00 00 00 8B 45 08 83 C0 04 89 45 FC 8B 4D FC 83 C1 02 89 4D FC 8B 55 FC 33 C0 66 8B 02 85 C0 74 1E 8B 4D FC 33 D2 66 8B 11 83 FA 5C 74 0D 8B 45 FC 33 C9 66 8B 08 83 F9 2F 75 02 EB 02 EB CD 8B 55 FC 33 C0 66 8B 02 85 C0 74 60 8B 4D FC 33 D2 66 8B 51 02 85 D2 74 53 8B 45 FC 83 C0 02 89 45 FC 8B 4D FC 33 D2 66 8B 11 85 D2 74 1E 8B 45 FC 33 C9 66 8B 08 83 F9 5C 74 0D 8B 55 FC 33 C0 66 8B 02 83 F8 2F 75 02 EB 02 EB CD 8B 4D FC 33 D2 66 8B 11 85 D2 74 0D 8B 45 FC 33 C9 66 8B 48 02 85 C9 75 07 B8 01 00 00 00 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_163_0_0 {
	meta:
		name = "_wcscmp"
		size = 105
	strings:
		$1 = { 55 8B EC 51 C7 45 FC 00 00 00 00 8B 45 08 33 C9 66 8B 08 8B 55 0C 33 C0 66 8B 02 2B C8 89 4D FC 83 7D FC 00 75 20 8B 4D 0C 33 D2 66 8B 11 85 D2 74 14 8B 45 08 83 C0 02 89 45 08 8B 4D 0C 83 C1 02 89 4D 0C EB C5 83 7D FC 00 7D 09 C7 45 FC FF FF FF FF EB 0D 83 7D FC 00 7E 07 C7 45 FC 01 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_164_0_0 {
	meta:
		name = "__heapmin"
		size = 96
		refs = "0005 ___active_heap 000d ___sbh_heapmin 001f ___old_sbh_decommit_pages 0029 __crtheap 0030 __imp__HeapCompact@8 003a __imp__GetLastError@0 0045 __doserrno 004f _errno"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? 03 75 07 E8 ?? ?? ?? ?? EB 13 83 3D ?? ?? ?? ?? 02 75 0A 6A 20 E8 ?? ?? ?? ?? 83 C4 04 6A 00 A1 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 75 24 FF 15 ?? ?? ?? ?? 83 F8 78 75 14 C7 05 ?? ?? ?? ?? 78 00 00 00 C7 05 ?? ?? ?? ?? 28 00 00 00 83 C8 FF EB 02 33 C0 5D C3 }
	condition:
		$1
}

rule file_165_0_0 {
	meta:
		name = "_wcstombs"
		size = 736
		refs = "0031 ??_C@_0N@ILLM@pwcs?5?$CB?$DN?5NULL?$AA@ 003a ??_C@_0L@LIHO@wcstombs?4c?$AA@ 0041 __CrtDbgReport 0060 ___lc_handle 0080 _errno 00cf ___mb_cur_max 00e9 _wcsncnt 010f ___lc_codepage 0116 __imp__WideCharToMultiByte@32 01a2 __imp__GetLastError@0 028a _wcslen"
	strings:
		$1 = { 55 8B EC 83 EC 14 53 56 57 C7 45 FC 00 00 00 00 C7 45 EC 00 00 00 00 83 7D 08 00 74 0D 83 7D 10 00 75 07 33 C0 E9 AF 02 00 00 83 7D 0C 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 7E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D6 83 7D 08 00 0F 84 1E 02 00 00 83 3D ?? ?? ?? ?? 00 75 66 8B 4D FC 3B 4D 10 73 56 8B 55 0C 33 C0 66 8B 02 3D FF 00 00 00 7E 12 C7 05 ?? ?? ?? ?? 2A 00 00 00 83 C8 FF E9 49 02 00 00 8B 4D 08 03 4D FC 8B 55 0C 8A 02 88 01 8B 4D 0C 33 D2 66 8B 11 8B 45 0C 83 C0 02 89 45 0C 85 D2 75 08 8B 45 FC E9 1F 02 00 00 8B 4D FC 83 C1 01 89 4D FC EB A2 8B 45 FC E9 0C 02 00 00 83 3D ?? ?? ?? ?? 01 0F 85 80 00 00 00 83 7D 10 00 76 13 8B 55 10 52 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 10 8D 4D EC 51 6A 00 8B 55 10 52 8B 45 08 50 8B 4D 10 51 8B 55 0C 52 68 20 02 00 00 A1 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 74 25 83 7D EC 00 75 1F 8B 4D 08 03 4D FC 0F BE 51 FF 85 D2 75 09 8B 45 FC 83 E8 01 89 45 FC 8B 45 FC E9 91 01 00 00 C7 05 ?? ?? ?? ?? 2A 00 00 00 83 C8 FF E9 7F 01 00 00 8D 4D EC 51 6A 00 8B 55 10 52 8B 45 08 50 6A FF 8B 4D 0C 51 68 20 02 00 00 8B 15 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 74 11 83 7D EC 00 75 0B 8B 45 FC 83 E8 01 E9 3F 01 00 00 83 7D EC 00 75 0B FF 15 ?? ?? ?? ?? 83 F8 7A 74 12 C7 05 ?? ?? ?? ?? 2A 00 00 00 83 C8 FF E9 1C 01 00 00 8B 45 FC 3B 45 10 0F 83 AE 00 00 00 8D 4D EC 51 6A 00 8B 15 ?? ?? ?? ?? 52 8D 45 F4 50 6A 01 8B 4D 0C 51 6A 00 8B 15 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 89 45 F0 83 7D F0 00 74 06 83 7D EC 00 74 12 C7 05 ?? ?? ?? ?? 2A 00 00 00 83 C8 FF E9 C9 00 00 00 8B 45 FC 03 45 F0 3B 45 10 76 08 8B 45 FC E9 B6 00 00 00 C7 45 F8 00 00 00 00 EB 12 8B 4D F8 83 C1 01 89 4D F8 8B 55 FC 83 C2 01 89 55 FC 8B 45 F8 3B 45 F0 7D 23 8B 4D 08 03 4D FC 8B 55 F8 8A 44 15 F4 88 01 8B 4D 08 03 4D FC 0F BE 11 85 D2 75 05 8B 45 FC EB 72 EB C3 8B 45 0C 83 C0 02 89 45 0C E9 46 FF FF FF 8B 45 FC EB 5D 83 3D ?? ?? ?? ?? 00 75 0E 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 04 EB 46 8D 55 EC 52 6A 00 6A 00 6A 00 6A FF 8B 45 0C 50 68 20 02 00 00 8B 0D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 74 06 83 7D EC 00 74 0F C7 05 ?? ?? ?? ?? 2A 00 00 00 83 C8 FF EB 06 8B 45 FC 83 E8 01 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_165_1_0 {
	meta:
		name = "_wcsncnt"
		size = 97
	strings:
		$1 = { 55 8B EC 83 EC 08 8B 45 0C 83 C0 01 89 45 F8 8B 4D 08 89 4D FC 8B 55 F8 83 EA 01 89 55 F8 83 7D F8 00 74 17 8B 45 FC 33 C9 66 8B 08 85 C9 74 0B 8B 55 FC 83 C2 02 89 55 FC EB DA 83 7D F8 00 74 19 8B 45 FC 33 C9 66 8B 08 85 C9 75 0D 8B 45 FC 2B 45 08 D1 F8 83 C0 01 EB 03 8B 45 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_166_0_0 {
	meta:
		name = "_wcschr"
		size = 77
	strings:
		$1 = { 55 8B EC 8B 45 08 33 C9 66 8B 08 85 C9 74 20 8B 55 08 33 C0 66 8B 02 8B 4D 0C 81 E1 FF FF 00 00 3B C1 74 0B 8B 55 08 83 C2 02 89 55 08 EB D4 8B 45 08 33 C9 66 8B 08 8B 55 0C 81 E2 FF FF 00 00 3B CA 75 05 8B 45 08 EB 02 33 C0 5D C3 }
	condition:
		$1
}

rule file_167_0_0 {
	meta:
		name = "__getbuf"
		size = 199
		refs = "000e ??_C@_0M@KJPK@str?5?$CB?$DN?5NULL?$AA@ 0017 ??_C@_09EMDO@_getbuf?4c?$AA@ 001e __CrtDbgReport 0033 __cflush 0055 __malloc_dbg"
	strings:
		$1 = { 55 8B EC 51 53 56 57 83 7D 08 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 2E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D6 8B 0D ?? ?? ?? ?? 83 C1 01 89 0D ?? ?? ?? ?? 8B 55 08 89 55 FC 6A 3B 68 ?? ?? ?? ?? 6A 02 68 00 10 00 00 E8 ?? ?? ?? ?? 83 C4 10 8B 4D FC 89 41 08 8B 55 FC 83 7A 08 00 74 1B 8B 45 FC 8B 48 0C 83 C9 08 8B 55 FC 89 4A 0C 8B 45 FC C7 40 18 00 10 00 00 EB 25 8B 4D FC 8B 51 0C 83 CA 04 8B 45 FC 89 50 0C 8B 4D FC 83 C1 14 8B 55 FC 89 4A 08 8B 45 FC C7 40 18 02 00 00 00 8B 4D FC 8B 55 FC 8B 42 08 89 01 8B 4D FC C7 41 04 00 00 00 00 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_168_0_0 {
	meta:
		name = "__GetLinkerVersion"
		size = 92
		refs = "0013 __imp__GetModuleHandleA@4"
	strings:
		$1 = { 55 8B EC 83 EC 08 8B 45 08 C7 00 00 00 00 00 6A 00 FF 15 ?? ?? ?? ?? 89 45 F8 8B 4D F8 33 D2 66 8B 11 81 FA 4D 5A 00 00 75 09 8B 45 F8 83 78 3C 00 75 02 EB 23 8B 4D F8 8B 55 F8 03 51 3C 89 55 FC 8B 45 08 8B 4D FC 8A 51 1A 88 10 8B 45 08 8B 4D FC 8A 51 1B 88 50 01 8B E5 5D C3 }
	condition:
		$1
}

rule file_168_1_0 {
	meta:
		name = "___heap_select"
		size = 548
		refs = "0009 __chkstk 002a __imp__GetVersionExA@4 005b ??_C@_0BF@BBGL@__MSVCRT_HEAP_SELECT?$AA@ 0061 __imp__GetEnvironmentVariableA@12 00ba ??_C@_0BH@PHHF@__GLOBAL_HEAP_SELECTED?$AA@ 00bf _strncmp 00e8 __imp__GetModuleFileNameA@12 013e _strstr 0162 _strchr 01c4 _strtol 01fc __GetLinkerVersion"
	strings:
		$1 = { 55 8B EC B8 38 12 00 00 E8 ?? ?? ?? ?? C7 85 C8 ED FF FF 00 00 00 00 C7 85 68 FF FF FF 94 00 00 00 8D 85 68 FF FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 74 1C 83 BD 78 FF FF FF 02 75 13 83 BD 6C FF FF FF 05 72 0A B8 01 00 00 00 E9 D2 01 00 00 68 90 10 00 00 8D 8D D8 EE FF FF 51 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 0F 84 87 01 00 00 8D 95 D8 EE FF FF 89 55 FC EB 09 8B 45 FC 83 C0 01 89 45 FC 8B 4D FC 0F BE 11 85 D2 74 25 8B 45 FC 0F BE 08 83 F9 61 7C 18 8B 55 FC 0F BE 02 83 F8 7A 7F 0D 8B 4D FC 8A 11 80 C2 E0 8B 45 FC 88 10 EB C8 6A 16 8D 8D D8 EE FF FF 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 0E 8D 95 D8 EE FF FF 89 95 C8 ED FF FF EB 73 68 04 01 00 00 8D 85 D4 ED FF FF 50 6A 00 FF 15 ?? ?? ?? ?? 8D 8D D4 ED FF FF 89 4D FC EB 09 8B 55 FC 83 C2 01 89 55 FC 8B 45 FC 0F BE 08 85 C9 74 25 8B 55 FC 0F BE 02 83 F8 61 7C 18 8B 4D FC 0F BE 11 83 FA 7A 7F 0D 8B 45 FC 8A 08 80 C1 E0 8B 55 FC 88 0A EB C8 8D 85 D4 ED FF FF 50 8D 8D D8 EE FF FF 51 E8 ?? ?? ?? ?? 83 C4 08 89 85 C8 ED FF FF 83 BD C8 ED FF FF 00 0F 84 9C 00 00 00 6A 2C 8B 95 C8 ED FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 89 85 C8 ED FF FF 83 BD C8 ED FF FF 00 74 7C 8B 85 C8 ED FF FF 83 C0 01 89 85 C8 ED FF FF 8B 8D C8 ED FF FF 89 4D FC 8B 55 FC 0F BE 02 85 C0 74 1E 8B 4D FC 0F BE 11 83 FA 3B 75 08 8B 45 FC C6 00 00 EB 09 8B 4D FC 83 C1 01 89 4D FC EB D8 6A 0A 6A 00 8B 95 C8 ED FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 89 85 D0 ED FF FF 83 BD D0 ED FF FF 02 74 12 83 BD D0 ED FF FF 03 74 09 83 BD D0 ED FF FF 01 75 08 8B 85 D0 ED FF FF EB 2C 8D 85 CC ED FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 8B 8D CC ED FF FF 81 E1 FF 00 00 00 83 F9 06 7C 07 B8 03 00 00 00 EB 05 B8 02 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_168_2_0 {
	meta:
		name = "__heap_init"
		size = 141
		refs = "0016 __imp__HeapCreate@12 001b __crtheap 002d ___heap_select 0032 ___active_heap 0045 ___sbh_heap_init 0059 __imp__HeapDestroy@4 006d ___old_sbh_new_region"
	strings:
		$1 = { 55 8B EC 6A 00 68 00 10 00 00 33 C0 83 7D 08 00 0F 94 C0 50 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 75 04 33 C0 EB 5F E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 03 75 24 68 F8 03 00 00 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 11 8B 0D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 33 C0 EB 2A EB 23 83 3D ?? ?? ?? ?? 02 75 1A E8 ?? ?? ?? ?? 85 C0 75 11 8B 15 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 33 C0 EB 05 B8 01 00 00 00 5D C3 }
	condition:
		$1
}

rule file_168_3_0 {
	meta:
		name = "__heap_term"
		size = 232
		refs = "0008 ___active_heap 0014 ___sbh_pHeaderList 0032 ___sbh_cntHeaderList 004b __imp__VirtualFree@12 006d __crtheap 0074 __imp__HeapFree@12 00a6 ___old_small_block_heap 00e0 __imp__HeapDestroy@4"
	strings:
		$1 = { 55 8B EC 83 EC 0C 83 3D ?? ?? ?? ?? 03 0F 85 87 00 00 00 A1 ?? ?? ?? ?? 89 45 F8 C7 45 FC 00 00 00 00 EB 09 8B 4D FC 83 C1 01 89 4D FC 8B 55 FC 3B 15 ?? ?? ?? ?? 7D 4B 68 00 40 00 00 68 00 00 10 00 8B 45 F8 8B 48 0C 51 FF 15 ?? ?? ?? ?? 68 00 80 00 00 6A 00 8B 55 F8 8B 42 0C 50 FF 15 ?? ?? ?? ?? 8B 4D F8 8B 51 10 52 6A 00 A1 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 8B 4D F8 83 C1 14 89 4D F8 EB A1 8B 15 ?? ?? ?? ?? 52 6A 00 A1 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? EB 3E 83 3D ?? ?? ?? ?? 02 75 35 C7 45 F4 ?? ?? ?? ?? 8B 4D F4 83 79 10 00 74 14 68 00 80 00 00 6A 00 8B 55 F4 8B 42 10 50 FF 15 ?? ?? ?? ?? 8B 4D F4 8B 11 89 55 F4 81 7D F4 ?? ?? ?? ?? 75 D2 A1 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_169_0_0 {
	meta:
		name = "_wcslen"
		size = 48
	strings:
		$1 = { 55 8B EC 51 8B 45 08 89 45 FC 8B 4D FC 33 D2 66 8B 11 8B 45 FC 83 C0 02 89 45 FC 85 D2 74 02 EB E9 8B 45 FC 2B 45 08 D1 F8 83 E8 01 8B E5 5D C3 }
	condition:
		$1
}

rule file_170_0_0 {
	meta:
		name = "__wcenvarg"
		size = 984
		refs = "002b _wcslen 004f ??_C@_09MOBB@cenvarg?4c?$AA@ 005c __malloc_dbg 007b _errno 0085 __doserrno 00f8 __wenvptr 0100 ___crtGetEnvironmentStringsW 021d __free_dbg 0275 _wcscpy 032f _memcpy"
	strings:
		$1 = { 55 8B EC 83 EC 30 8B 45 08 89 45 E4 C7 45 F8 02 00 00 00 EB 27 8B 4D E4 8B 11 89 55 E0 8B 45 E0 50 8B 4D E4 83 C1 04 89 4D E4 E8 ?? ?? ?? ?? 83 C4 04 8B 55 F8 8D 44 02 01 89 45 F8 8B 4D E4 83 39 00 74 02 EB CF 8B 55 F8 89 55 FC 6A 61 68 ?? ?? ?? ?? 6A 02 8B 45 F8 D1 E0 50 E8 ?? ?? ?? ?? 83 C4 10 8B 4D 10 89 01 8B 55 10 83 3A 00 75 25 8B 45 14 C7 00 00 00 00 00 C7 05 ?? ?? ?? ?? 0C 00 00 00 C7 05 ?? ?? ?? ?? 08 00 00 00 83 C8 FF E9 3F 03 00 00 83 7D 0C 00 74 40 8B 4D 0C 89 4D E4 C7 45 F8 02 00 00 00 EB 27 8B 55 E4 8B 02 89 45 DC 8B 4D DC 51 8B 55 E4 83 C2 04 89 55 E4 E8 ?? ?? ?? ?? 83 C4 04 8B 4D F8 8D 54 01 01 89 55 F8 8B 45 E4 83 38 00 74 02 EB CF C7 45 E8 00 00 00 00 83 7D 0C 00 75 0E 8B 4D 14 C7 01 00 00 00 00 E9 53 01 00 00 83 3D ?? ?? ?? ?? 00 75 1B E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 75 08 83 C8 FF E9 BA 02 00 00 C7 45 EC 00 00 00 00 EB 1E 8B 55 EC A1 ?? ?? ?? ?? 8D 0C 50 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 EC 8D 44 02 01 89 45 EC 8B 4D EC 8B 15 ?? ?? ?? ?? 33 C0 66 8B 04 4A 85 C0 74 16 8B 4D EC 8B 15 ?? ?? ?? ?? 33 C0 66 8B 04 4A 83 F8 3D 74 02 EB B9 8B 4D EC 89 4D F4 8B 55 F4 A1 ?? ?? ?? ?? 33 C9 66 8B 0C 50 83 F9 3D 75 5C 8B 55 F4 A1 ?? ?? ?? ?? 33 C9 66 8B 4C 50 02 85 C9 74 49 8B 55 F4 A1 ?? ?? ?? ?? 33 C9 66 8B 4C 50 04 83 F9 3A 75 35 8B 55 F4 A1 ?? ?? ?? ?? 33 C9 66 8B 4C 50 06 83 F9 3D 75 21 8B 55 F4 A1 ?? ?? ?? ?? 8D 4C 50 08 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 F4 8D 44 02 05 89 45 F4 EB 91 8B 4D F4 2B 4D EC 8B 55 F8 03 D1 89 55 F8 68 AA 00 00 00 68 ?? ?? ?? ?? 6A 02 8B 45 F8 D1 E0 50 E8 ?? ?? ?? ?? 83 C4 10 8B 4D 14 89 01 8B 55 14 83 3A 00 75 35 6A 02 8B 45 10 8B 08 51 E8 ?? ?? ?? ?? 83 C4 08 8B 55 10 C7 02 00 00 00 00 C7 05 ?? ?? ?? ?? 0C 00 00 00 C7 05 ?? ?? ?? ?? 08 00 00 00 83 C8 FF E9 8B 01 00 00 8B 45 10 8B 08 89 4D F0 8B 55 08 89 55 E4 8B 45 E4 83 38 00 75 0B 8B 4D F0 83 C1 02 89 4D F0 EB 39 8B 55 E4 8B 02 50 8B 4D F0 51 E8 ?? ?? ?? ?? 83 C4 08 8B 55 E4 8B 02 89 45 D8 8B 4D D8 51 8B 55 E4 83 C2 04 89 55 E4 E8 ?? ?? ?? ?? 83 C4 04 8B 4D F0 8D 54 41 02 89 55 F0 8B 45 E4 83 38 00 74 4B 8B 4D E4 8B 11 52 8B 45 F0 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4D E4 8B 11 89 55 D4 8B 45 D4 50 8B 4D E4 83 C1 04 89 4D E4 E8 ?? ?? ?? ?? 83 C4 04 8B 55 F0 8D 04 42 89 45 F0 8B 4D F0 66 C7 01 20 00 8B 55 F0 83 C2 02 89 55 F0 EB AD 8B 45 F0 66 C7 40 FE 00 00 8B 4D F0 66 C7 01 00 00 8B 55 14 8B 02 89 45 F0 83 7D 0C 00 74 79 8B 4D F4 2B 4D EC D1 E1 51 8B 55 EC A1 ?? ?? ?? ?? 8D 0C 50 51 8B 55 F0 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 F4 2B 45 EC 8B 4D F0 8D 14 41 89 55 F0 8B 45 0C 89 45 E4 8B 4D E4 83 39 00 74 3B 8B 55 E4 8B 02 50 8B 4D F0 51 E8 ?? ?? ?? ?? 83 C4 08 8B 55 E4 8B 02 89 45 D0 8B 4D D0 51 8B 55 E4 83 C2 04 89 55 E4 E8 ?? ?? ?? ?? 83 C4 04 8B 4D F0 8D 54 41 02 89 55 F0 EB BD 83 7D F0 00 74 23 8B 45 14 8B 4D F0 3B 08 75 11 8B 55 F0 66 C7 02 00 00 8B 45 F0 83 C0 02 89 45 F0 8B 4D F0 66 C7 01 00 00 6A 02 8B 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 08 C7 05 ?? ?? ?? ?? 00 00 00 00 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_171_0_0 {
	meta:
		name = "___InternalCxxFrameHandler"
		size = 239
		refs = "001b ?_inconsistency@@YAXXZ 004d ___FrameUnwindToState 00df ?FindHandler@@YAXPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAU_CONTEXT@@PAXPBU_s_FuncInfo@@EH1@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 8B 45 18 81 38 20 05 93 19 75 09 C7 45 F8 00 00 00 00 EB 08 E8 ?? ?? ?? ?? 89 45 F8 8B 4D 08 8B 51 04 83 E2 66 85 D2 74 2F 8B 45 18 83 78 04 00 74 1C 83 7D 1C 00 75 16 6A FF 8B 4D 18 51 8B 55 14 52 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 10 B8 01 00 00 00 E9 8D 00 00 00 8B 4D 18 83 79 0C 00 74 7F 8B 55 08 81 3A 63 73 6D E0 75 4C 8B 45 08 81 78 14 20 05 93 19 76 40 8B 4D 08 8B 51 1C 8B 42 08 89 45 FC 83 7D FC 00 74 2E 8B 4D 24 81 E1 FF 00 00 00 51 8B 55 20 52 8B 45 1C 50 8B 4D 18 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 FF 55 FC 83 C4 20 EB 2D 8B 45 20 50 8B 4D 1C 51 8A 55 24 52 8B 45 18 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 20 B8 01 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_171_1_0 {
	meta:
		name = "?FindHandler@@YAXPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAU_CONTEXT@@PAXPBU_s_FuncInfo@@EH1@Z"
		size = 665
		refs = "002e ?_inconsistency@@YAXXZ 0070 ?_pCurrentException@@3PAUEHExceptionRecord@@A 0086 ?_pCurrentExContext@@3PAU_CONTEXT@@A 0098 ?_ValidateRead@@YAHPBXI@Z 012f ?_GetRangeOfTrysToCheck@@YAPBU_s_TryBlockMapEntry@@PBU_s_FuncInfo@@HHPAI1@Z 01e9 ?TypeMatch@@YAHPBU_s_HandlerType@@PBU_s_CatchableType@@PBU_s_ThrowInfo@@@Z 0225 ?CatchIt@@YAXPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAU_CONTEXT@@PAXPBU_s_FuncInfo@@PBU_s_HandlerType@@PBU_s_CatchableType@@PBU_s_TryBlockMapEntry@@H1E@Z 024c ?_DestructExceptionObject@@YAXPAUEHExceptionRecord@@E@Z 0283 ?FindHandlerForForeignException@@YAXPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAU_CONTEXT@@PAXPBU_s_FuncInfo@@HH1@Z 028d ?terminate@@YAXXZ"
	strings:
		$1 = { 55 8B EC 83 EC 30 C6 45 F8 00 8B 45 0C 8B 48 08 89 4D FC 83 7D FC FF 7C 14 8B 55 18 8B 45 FC 3B 42 04 7D 09 C7 45 D8 00 00 00 00 EB 08 E8 ?? ?? ?? ?? 89 45 D8 8B 4D 08 81 39 63 73 6D E0 0F 85 AA 00 00 00 8B 55 08 83 7A 10 03 0F 85 9D 00 00 00 8B 45 08 81 78 14 20 05 93 19 0F 85 8D 00 00 00 8B 4D 08 83 79 1C 00 0F 85 80 00 00 00 83 3D ?? ?? ?? ?? 00 75 05 E9 19 02 00 00 8B 15 ?? ?? ?? ?? 89 55 08 A1 ?? ?? ?? ?? 89 45 10 C6 45 F8 01 6A 01 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 09 C7 45 D4 00 00 00 00 EB 08 E8 ?? ?? ?? ?? 89 45 D4 8B 55 08 81 3A 63 73 6D E0 75 28 8B 45 08 83 78 10 03 75 1F 8B 4D 08 81 79 14 20 05 93 19 75 13 8B 55 08 83 7A 1C 00 75 0A E8 ?? ?? ?? ?? 89 45 D0 EB 07 C7 45 D0 00 00 00 00 8B 45 08 81 38 63 73 6D E0 0F 85 58 01 00 00 8B 4D 08 83 79 10 03 0F 85 4B 01 00 00 8B 55 08 81 7A 14 20 05 93 19 0F 85 3B 01 00 00 8D 45 F4 50 8D 4D EC 51 8B 55 FC 52 8B 45 20 50 8B 4D 18 51 E8 ?? ?? ?? ?? 83 C4 14 89 45 F0 EB 12 8B 55 EC 83 C2 01 89 55 EC 8B 45 F0 83 C0 14 89 45 F0 8B 4D EC 3B 4D F4 0F 83 DF 00 00 00 8B 55 F0 8B 02 3B 45 FC 7F 0B 8B 4D F0 8B 55 FC 3B 51 04 7E 02 EB CB 8B 45 F0 8B 48 10 89 4D E4 8B 55 F0 8B 42 0C 89 45 DC EB 12 8B 4D DC 83 E9 01 89 4D DC 8B 55 E4 83 C2 10 89 55 E4 83 7D DC 00 0F 8E 93 00 00 00 8B 45 08 8B 48 1C 8B 51 0C 83 C2 04 89 55 E8 8B 45 08 8B 48 1C 8B 51 0C 8B 02 89 45 E0 EB 12 8B 4D E0 83 E9 01 89 4D E0 8B 55 E8 83 C2 04 89 55 E8 83 7D E0 00 7E 57 8B 45 08 8B 48 1C 51 8B 55 E8 8B 02 50 8B 4D E4 51 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 02 EB C9 8A 55 F8 52 8B 45 24 50 8B 4D 20 51 8B 55 F0 52 8B 45 E8 8B 08 51 8B 55 E4 52 8B 45 18 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 2C EB 65 E9 51 FF FF FF E9 03 FF FF FF 8B 55 1C 81 E2 FF 00 00 00 85 D2 74 0E 6A 01 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 EB 3C 8B 4D 1C 81 E1 FF 00 00 00 85 C9 75 2A 8B 55 24 52 8B 45 20 50 8B 4D FC 51 8B 55 18 52 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 20 EB 05 E8 ?? ?? ?? ?? EB 02 EB 9E 8B E5 5D C3 }
	condition:
		$1
}

rule file_171_2_0 {
	meta:
		name = "?FindHandlerForForeignException@@YAXPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAU_CONTEXT@@PAXPBU_s_FuncInfo@@HH1@Z"
		size = 275
		refs = "0008 ?__pSETranslator@@3P6AXIPAU_EXCEPTION_POINTERS@@@ZA 002c ?_CallSETranslator@@YAHPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAX2PBU_s_FuncInfo@@H1@Z 0051 ?_GetRangeOfTrysToCheck@@YAPBU_s_TryBlockMapEntry@@PBU_s_FuncInfo@@HHPAI1@Z 0103 ?CatchIt@@YAXPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAU_CONTEXT@@PAXPBU_s_FuncInfo@@PBU_s_HandlerType@@PBU_s_CatchableType@@PBU_s_TryBlockMapEntry@@H1E@Z"
	strings:
		$1 = { 55 8B EC 83 EC 0C 83 3D ?? ?? ?? ?? 00 74 2D 8B 45 24 50 8B 4D 20 51 8B 55 18 52 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 1C 85 C0 74 05 E9 D3 00 00 00 8D 4D FC 51 8D 55 F4 52 8B 45 1C 50 8B 4D 20 51 8B 55 18 52 E8 ?? ?? ?? ?? 83 C4 14 89 45 F8 EB 12 8B 45 F4 83 C0 01 89 45 F4 8B 4D F8 83 C1 14 89 4D F8 8B 55 F4 3B 55 FC 0F 83 94 00 00 00 8B 45 F8 8B 4D 1C 3B 08 7C 42 8B 55 F8 8B 45 1C 3B 42 04 7F 37 8B 4D F8 8B 51 0C 83 EA 01 C1 E2 04 8B 45 F8 8B 48 10 83 7C 11 04 00 74 20 8B 55 F8 8B 42 0C 83 E8 01 C1 E0 04 8B 4D F8 8B 51 10 8B 44 02 04 0F BE 48 08 85 C9 74 02 EB 94 6A 01 8B 55 24 52 8B 45 20 50 8B 4D F8 51 6A 00 8B 55 F8 8B 42 0C 83 E8 01 C1 E0 04 8B 4D F8 8B 51 10 03 D0 52 8B 45 18 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 2C E9 4E FF FF FF 8B E5 5D C3 }
	condition:
		$1
}

rule file_171_3_0 {
	meta:
		name = "?TypeMatch@@YAHPBU_s_HandlerType@@PBU_s_CatchableType@@PBU_s_ThrowInfo@@@Z"
		size = 182
		refs = "0048 _strcmp"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 83 78 04 00 74 0E 8B 4D 08 8B 51 04 0F BE 42 08 85 C0 75 0A B8 01 00 00 00 E9 8D 00 00 00 8B 4D 08 8B 55 0C 8B 41 04 3B 42 04 74 24 8B 4D 0C 8B 51 04 83 C2 08 52 8B 45 08 8B 48 04 83 C1 08 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 04 33 C0 EB 5B 8B 55 0C 8B 02 83 E0 02 85 C0 74 0C 8B 4D 08 8B 11 83 E2 08 85 D2 74 39 8B 45 10 8B 08 83 E1 01 85 C9 74 0C 8B 55 08 8B 02 83 E0 01 85 C0 74 21 8B 4D 10 8B 11 83 E2 02 85 D2 74 0C 8B 45 08 8B 08 83 E1 02 85 C9 74 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_171_4_0 {
	meta:
		name = "___FrameUnwindToState"
		size = 247
		refs = "0006 $T17142 000b __except_handler3 0011 __except_list 0056 ?_inconsistency@@YAXXZ 008c __CallSettingFrame@12 009e ?FrameUnwindFilter@@YAHPAU_EXCEPTION_POINTERS@@@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 C4 EC 53 56 57 89 65 E8 8B 45 08 8B 48 08 89 4D E4 8B 55 E4 3B 55 14 0F 84 89 00 00 00 83 7D E4 FF 7E 14 8B 45 10 8B 4D E4 3B 48 04 7D 09 C7 45 E0 00 00 00 00 EB 08 E8 ?? ?? ?? ?? 89 45 E0 C7 45 FC 00 00 00 00 8B 55 10 8B 42 08 8B 4D E4 83 7C C8 04 00 74 1C 68 03 01 00 00 8B 55 08 52 8B 45 10 8B 48 08 8B 55 E4 8B 44 D1 04 50 E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF EB 17 8B 4D EC 51 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 65 E8 C7 45 FC FF FF FF FF 8B 55 10 8B 42 08 8B 4D E4 8B 14 C8 89 55 E4 E9 6B FF FF FF 8B 45 E4 3B 45 14 75 09 C7 45 DC 00 00 00 00 EB 08 E8 ?? ?? ?? ?? 89 45 DC 8B 4D 08 8B 55 E4 89 51 08 8B 4D F0 64 89 0D ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_171_5_0 {
	meta:
		name = "?FrameUnwindFilter@@YAHPAU_EXCEPTION_POINTERS@@@Z"
		size = 44
		refs = "0022 ?terminate@@YAXXZ"
		altNames = "?ArrayUnwindFilter@@YAHPAU_EXCEPTION_POINTERS@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 8B 45 08 8B 08 89 4D FC 8B 55 FC 8B 02 89 45 F8 81 7D F8 63 73 6D E0 74 02 EB 05 E8 ?? ?? ?? ?? 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_171_6_0 {
	meta:
		name = "?CatchIt@@YAXPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAU_CONTEXT@@PAXPBU_s_FuncInfo@@PBU_s_HandlerType@@PBU_s_CatchableType@@PBU_s_TryBlockMapEntry@@H1E@Z"
		size = 183
		refs = "0023 ?BuildCatchObject@@YAXPAUEHExceptionRecord@@PAUEHRegistrationNode@@PBU_s_HandlerType@@PBU_s_CatchableType@@@Z 0039 ?_UnwindNestedFrames@@YGXPAUEHRegistrationNode@@PAUEHExceptionRecord@@@Z 005f ___FrameUnwindToState 0096 ?CallCatchBlock@@YAPAXPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAU_CONTEXT@@PBU_s_FuncInfo@@PAXHK@Z 00af ?_JumpToContinuation@@YGXPAXPAUEHRegistrationNode@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 8B 45 0C 89 45 FC 83 7D 20 00 74 18 8B 4D 20 51 8B 55 1C 52 8B 45 FC 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 10 83 7D 2C 00 75 0F 8B 55 08 52 8B 45 0C 50 E8 ?? ?? ?? ?? EB 0D 8B 4D 08 51 8B 55 2C 52 E8 ?? ?? ?? ?? 8B 45 24 8B 08 51 8B 55 18 52 8B 45 14 50 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 10 8B 55 24 8B 42 04 83 C0 01 8B 4D 0C 89 41 08 68 00 01 00 00 8B 55 28 52 8B 45 1C 8B 48 0C 51 8B 55 18 52 8B 45 10 50 8B 4D FC 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 1C 89 45 F8 83 7D F8 00 74 0D 8B 45 0C 50 8B 4D F8 51 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_171_7_0 {
	meta:
		name = "?CallCatchBlock@@YAPAXPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAU_CONTEXT@@PBU_s_FuncInfo@@PAXHK@Z"
		size = 321
		refs = "0006 $T17160 000b __except_handler3 0011 __except_list 003d ?_pCurrentException@@3PAUEHExceptionRecord@@A 0046 ?_pCurrentExContext@@3PAU_CONTEXT@@A 0081 ?_CallCatchBlock2@@YAPAXPAUEHRegistrationNode@@PBU_s_FuncInfo@@PAXHK@Z 0099 ?ExFilterRethrow@@YAHPAU_EXCEPTION_POINTERS@@@Z 00b9 __local_unwind2 011b __abnormal_termination 0125 ?_DestructExceptionObject@@YAXPAUEHExceptionRecord@@E@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 C4 E0 53 56 57 89 65 E8 8B 45 18 89 45 D4 C7 45 DC 00 00 00 00 8B 4D 0C 8B 51 FC 89 55 D8 A1 ?? ?? ?? ?? 89 45 E4 8B 0D ?? ?? ?? ?? 89 4D E0 8B 55 08 89 15 ?? ?? ?? ?? 8B 45 10 A3 ?? ?? ?? ?? C7 45 FC 00 00 00 00 C7 45 FC 01 00 00 00 8B 4D 20 51 8B 55 1C 52 8B 45 18 50 8B 4D 14 51 8B 55 0C 52 E8 ?? ?? ?? ?? 83 C4 14 89 45 D4 C7 45 FC 00 00 00 00 EB 31 8B 45 EC 50 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 65 E8 C7 45 D4 00 00 00 00 6A FF C7 45 D0 00 00 00 00 8D 4D F0 51 E8 ?? ?? ?? ?? 83 C4 08 8B 45 D0 EB 6B C7 45 FC FF FF FF FF E8 02 00 00 00 EB 5A 8B 55 0C 8B 45 D8 89 42 FC 8B 4D E4 89 0D ?? ?? ?? ?? 8B 55 E0 89 15 ?? ?? ?? ?? 8B 45 08 81 38 63 73 6D E0 75 33 8B 4D 08 83 79 10 03 75 2A 8B 55 08 81 7A 14 20 05 93 19 75 1E 83 7D DC 00 75 18 83 7D D4 00 74 12 E8 ?? ?? ?? ?? 50 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 C3 8B 45 D4 8B 4D F0 64 89 0D ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_171_8_0 {
	meta:
		name = "?ExFilterRethrow@@YAHPAU_EXCEPTION_POINTERS@@@Z"
		size = 66
	strings:
		$1 = { 55 8B EC 51 8B 45 08 8B 08 89 4D FC 8B 55 FC 81 3A 63 73 6D E0 75 25 8B 45 FC 83 78 10 03 75 1C 8B 4D FC 81 79 14 20 05 93 19 75 10 8B 55 FC 83 7A 1C 00 75 07 B8 01 00 00 00 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_171_9_0 {
	meta:
		name = "?BuildCatchObject@@YAXPAUEHExceptionRecord@@PAUEHRegistrationNode@@PBU_s_HandlerType@@PBU_s_CatchableType@@@Z"
		size = 635
		refs = "0006 $T17173 000b __except_handler3 0011 __except_list 0078 ?_ValidateRead@@YAHPBXI@Z 008a ?_ValidateWrite@@YAHPAXI@Z 00ae ?AdjustPointer@@YAPAXPAXABUPMD@@@Z 00bd ?_inconsistency@@YAXXZ 010c _memmove 01e3 ?_ValidateExecute@@YAHP6GHXZ@Z 021f ?_CallMemberFunction2@@YGXPAX00H@Z 0248 ?_CallMemberFunction1@@YGXPAX00@Z 0266 ?terminate@@YAXXZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 C4 F4 53 56 57 89 65 E8 8B 45 10 83 78 04 00 74 17 8B 4D 10 8B 51 04 0F BE 42 08 85 C0 74 09 8B 4D 10 83 79 08 00 75 05 E9 1F 02 00 00 8B 55 10 8B 42 08 8B 4D 0C 8D 54 01 0C 89 55 E4 C7 45 FC 00 00 00 00 8B 45 10 8B 08 83 E1 08 85 C9 74 58 6A 01 8B 55 08 8B 42 18 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 39 6A 01 8B 4D E4 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 27 8B 55 E4 8B 45 08 8B 48 18 89 0A 8B 55 14 83 C2 08 52 8B 45 E4 8B 08 51 E8 ?? ?? ?? ?? 83 C4 08 8B 55 E4 89 02 EB 05 E8 ?? ?? ?? ?? E9 8D 01 00 00 8B 45 14 8B 08 83 E1 01 85 C9 74 78 6A 01 8B 55 08 8B 42 18 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 59 6A 01 8B 4D E4 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 47 8B 55 14 8B 42 14 50 8B 4D 08 8B 51 18 52 8B 45 E4 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D 14 83 79 14 04 75 22 8B 55 E4 83 3A 00 74 1A 8B 45 14 83 C0 08 50 8B 4D E4 8B 11 52 E8 ?? ?? ?? ?? 83 C4 08 8B 4D E4 89 01 EB 05 E8 ?? ?? ?? ?? E9 09 01 00 00 8B 55 14 83 7A 18 00 75 5D 6A 01 8B 45 08 8B 48 18 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 3E 6A 01 8B 55 E4 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 2C 8B 45 14 8B 48 14 51 8B 55 14 83 C2 08 52 8B 45 08 8B 48 18 51 E8 ?? ?? ?? ?? 83 C4 08 50 8B 55 E4 52 E8 ?? ?? ?? ?? 83 C4 0C EB 05 E8 ?? ?? ?? ?? E9 A3 00 00 00 6A 01 8B 45 08 8B 48 18 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 0F 84 85 00 00 00 6A 01 8B 55 E4 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 73 8B 45 14 8B 48 18 51 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 60 8B 55 14 8B 02 83 E0 04 85 C0 74 2B 6A 01 8B 4D 14 83 C1 08 51 8B 55 08 8B 42 18 50 E8 ?? ?? ?? ?? 83 C4 08 50 8B 4D 14 8B 51 18 52 8B 45 E4 50 E8 ?? ?? ?? ?? EB 27 8B 4D 14 83 C1 08 51 8B 55 08 8B 42 18 50 E8 ?? ?? ?? ?? 83 C4 08 50 8B 4D 14 8B 51 18 52 8B 45 E4 50 E8 ?? ?? ?? ?? EB 05 E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF EB 0E B8 01 00 00 00 C3 8B 65 E8 E8 ?? ?? ?? ?? 8B 4D F0 64 89 0D ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_171_10_0 {
	meta:
		name = "?_DestructExceptionObject@@YAXPAUEHExceptionRecord@@E@Z"
		size = 134
		refs = "0006 $T17183 000b __except_handler3 0011 __except_list 0051 ?_CallMemberFunction0@@YGXPAX0@Z 0071 ?terminate@@YAXXZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 EC 08 53 56 57 89 65 E8 83 7D 08 00 74 49 8B 45 08 8B 48 1C 83 79 04 00 74 3D C7 45 FC 00 00 00 00 8B 55 08 8B 42 1C 8B 48 04 51 8B 55 08 8B 42 18 50 E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF EB 17 8B 45 0C 25 FF 00 00 00 F7 D8 1B C0 F7 D8 C3 8B 65 E8 E8 ?? ?? ?? ?? 8B 4D F0 64 89 0D ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_171_11_0 {
	meta:
		name = "?AdjustPointer@@YAPAXPAXABUPMD@@@Z"
		size = 70
	strings:
		$1 = { 55 8B EC 51 8B 45 0C 8B 4D 08 03 08 89 4D FC 8B 55 0C 83 7A 04 00 7C 27 8B 45 0C 8B 48 04 8B 55 08 8B 04 0A 8B 4D 0C 8B 51 08 8B 4D FC 03 0C 10 89 4D FC 8B 55 0C 8B 45 FC 03 42 04 89 45 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_172_0_0 {
	meta:
		name = "__getch"
		size = 276
		refs = "000f _chbuf 003c __coninpfh 0055 ___initconin 0066 __imp__GetConsoleMode@8 0074 __imp__SetConsoleMode@8 008a __imp__ReadConsoleInputA@16 00ce __getextendedkeycode"
	strings:
		$1 = { 55 8B EC 83 EC 24 C7 45 DC 00 00 00 00 83 3D ?? ?? ?? ?? FF 74 24 A1 ?? ?? ?? ?? 25 FF 00 00 00 25 FF 00 00 00 89 45 DC C7 05 ?? ?? ?? ?? FF FF FF FF 8B 45 DC E9 D6 00 00 00 83 3D ?? ?? ?? ?? FF 75 08 83 C8 FF E9 C5 00 00 00 83 3D ?? ?? ?? ?? FE 75 05 E8 ?? ?? ?? ?? 8D 4D FC 51 8B 15 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 6A 00 A1 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 8D 4D E4 51 6A 01 8D 55 E8 52 A1 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 74 06 83 7D E4 00 75 09 C7 45 DC FF FF FF FF EB 5C 8B 4D E8 81 E1 FF FF 00 00 83 F9 01 75 49 83 7D EC 00 74 43 8B 55 F6 81 E2 FF 00 00 00 89 55 DC 83 7D DC 00 74 02 EB 34 8D 45 EC 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 E0 83 7D E0 00 74 1A 8B 4D E0 33 D2 8A 11 89 55 DC 8B 45 E0 33 C9 8A 48 01 89 0D ?? ?? ?? ?? EB 05 E9 7B FF FF FF 8B 55 FC 52 A1 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 8B 45 DC 8B E5 5D C3 }
	condition:
		$1
}

rule file_172_1_0 {
	meta:
		name = "__getche"
		size = 89
		refs = "0006 _chbuf 002f __getch 0041 __putch"
	strings:
		$1 = { 55 8B EC 51 83 3D ?? ?? ?? ?? FF 74 21 A1 ?? ?? ?? ?? 25 FF 00 00 00 25 FF 00 00 00 89 45 FC C7 05 ?? ?? ?? ?? FF FF FF FF 8B 45 FC EB 27 E8 ?? ?? ?? ?? 89 45 FC 83 7D FC FF 74 16 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 83 F8 FF 74 05 8B 45 FC EB 03 83 C8 FF 8B E5 5D C3 }
	condition:
		$1
}

rule file_172_2_0 {
	meta:
		name = "__kbhit"
		size = 246
		refs = "0008 _chbuf 001b __coninpfh 0023 ___initconin 003d __imp__GetNumberOfConsoleInputEvents@8 0052 __alloca_probe 0080 __imp__PeekConsoleInputA@16 00d9 __getextendedkeycode"
	strings:
		$1 = { 55 8B EC 83 EC 10 83 3D ?? ?? ?? ?? FF 74 0A B8 01 00 00 00 E9 D6 00 00 00 83 3D ?? ?? ?? ?? FE 75 05 E8 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? FF 74 35 8D 45 F8 50 8B 0D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 85 C0 74 20 83 7D F8 00 74 1A 8B 45 F8 6B C0 14 E8 ?? ?? ?? ?? 89 65 F0 8B 55 F0 89 55 F4 83 7D F4 00 75 07 33 C0 E9 83 00 00 00 8D 45 FC 50 8B 4D F8 51 8B 55 F4 52 A1 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 74 65 83 7D FC 00 74 5F 8B 4D FC 3B 4D F8 77 57 EB 12 8B 55 FC 83 EA 01 89 55 FC 8B 45 F4 83 C0 14 89 45 F4 83 7D FC 00 76 3D 8B 4D F4 33 D2 66 8B 11 83 FA 01 75 2E 8B 45 F4 83 78 04 00 74 25 8B 4D F4 0F BE 51 0E 85 D2 75 13 8B 45 F4 83 C0 04 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 07 B8 01 00 00 00 EB 04 EB AB 33 C0 8D 65 F0 8B E5 5D C3 }
	condition:
		$1
}

rule file_172_3_0 {
	meta:
		name = "__ungetch"
		size = 43
		refs = "000b _chbuf"
	strings:
		$1 = { 55 8B EC 83 7D 08 FF 74 09 83 3D ?? ?? ?? ?? FF 74 05 83 C8 FF EB 12 8B 45 08 25 FF 00 00 00 A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_172_4_0 {
	meta:
		name = "__getextendedkeycode"
		size = 365
		refs = "004e _EnhancedKeys 00e0 _NormalKeys"
	strings:
		$1 = { 55 8B EC 83 EC 0C 8B 45 08 8B 48 0C 89 4D FC 8B 55 FC 81 E2 00 01 00 00 85 D2 0F 84 AA 00 00 00 C7 45 F8 00 00 00 00 C7 45 F4 00 00 00 00 EB 09 8B 45 F4 83 C0 01 89 45 F4 83 7D F4 0C 0F 83 82 00 00 00 8B 4D F4 6B C9 0A 33 D2 66 8B 91 ?? ?? ?? ?? 8B 45 08 33 C9 66 8B 48 08 3B D1 75 61 8B 55 FC 83 E2 03 85 D2 74 10 8B 45 F4 6B C0 0A 05 ?? ?? ?? ?? 89 45 F8 EB 45 8B 4D FC 83 E1 0C 85 C9 74 11 8B 55 F4 6B D2 0A 81 C2 ?? ?? ?? ?? 89 55 F8 EB 2A 8B 45 FC 83 E0 10 85 C0 74 11 8B 4D F4 6B C9 0A 81 C1 ?? ?? ?? ?? 89 4D F8 EB 0F 8B 55 F4 6B D2 0A 81 C2 ?? ?? ?? ?? 89 55 F8 EB 05 E9 6B FF FF FF E9 9C 00 00 00 8B 45 FC 83 E0 03 85 C0 74 15 8B 4D 08 33 D2 66 8B 51 08 8D 04 D5 ?? ?? ?? ?? 89 45 F8 EB 51 8B 4D FC 83 E1 0C 85 C9 74 15 8B 55 08 33 C0 66 8B 42 08 8D 0C C5 ?? ?? ?? ?? 89 4D F8 EB 32 8B 55 FC 83 E2 10 85 D2 74 15 8B 45 08 33 C9 66 8B 48 08 8D 14 CD ?? ?? ?? ?? 89 55 F8 EB 13 8B 45 08 33 C9 66 8B 48 08 8D 14 CD ?? ?? ?? ?? 89 55 F8 8B 45 F8 33 C9 8A 08 85 C9 74 0E 8B 55 F8 33 C0 8A 02 3D E0 00 00 00 75 0C 8B 4D F8 33 D2 8A 51 01 85 D2 75 07 C7 45 F8 00 00 00 00 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_173_0_0 {
	meta:
		name = "__setjmp3"
		size = 123
		refs = "0028 __except_list"
	strings:
		$1 = { 8B 54 24 04 89 2A 89 5A 04 89 7A 08 89 72 0C 89 62 10 8B 04 24 89 42 14 C7 42 20 30 32 43 56 C7 42 24 00 00 00 00 64 A1 ?? ?? ?? ?? 89 42 18 83 F8 FF 75 09 C7 42 1C FF FF FF FF EB 3B 8B 4C 24 08 0B C9 74 0A 8B 44 24 0C 89 42 24 49 75 08 8B 40 0C 89 42 1C EB 21 8B 44 24 10 89 42 1C 49 74 17 56 57 8D 74 24 1C 8D 7A 28 83 F9 06 76 05 B9 06 00 00 00 F3 A5 5F 5E 2B C0 C3 }
	condition:
		$1
}

rule file_174_0_0 {
	meta:
		name = "__strupr"
		size = 250
		refs = "000f ___lc_handle 0077 ___crtLCMapStringA 008c ??_C@_08ENH@strupr?4c?$AA@ 0097 __malloc_dbg 00de _strcpy 00ec __free_dbg"
	strings:
		$1 = { 55 8B EC 83 EC 0C C7 45 F8 00 00 00 00 83 3D ?? ?? ?? ?? 00 75 47 8B 45 08 89 45 F4 EB 09 8B 4D F4 83 C1 01 89 4D F4 8B 55 F4 0F BE 02 85 C0 74 24 8B 4D F4 0F BE 11 83 FA 61 7C 17 8B 45 F4 0F BE 08 83 F9 7A 7F 0C 8B 55 F4 8A 02 04 E0 8B 4D F4 88 01 EB C9 8B 45 08 E9 99 00 00 00 6A 01 6A 00 6A 00 6A 00 6A FF 8B 55 08 52 68 00 02 00 00 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 20 89 45 FC 83 7D FC 00 75 02 EB 5C 6A 62 68 ?? ?? ?? ?? 6A 02 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 F8 83 7D F8 00 75 02 EB 3C 6A 01 6A 00 8B 55 FC 52 8B 45 F8 50 6A FF 8B 4D 08 51 68 00 02 00 00 8B 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 20 85 C0 75 02 EB 10 8B 45 F8 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 08 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_175_0_0 {
	meta:
		name = "___wsetargv"
		size = 225
		refs = "000c _?_pgmname@?1??__wsetargv@@9@9 0014 __imp__GetModuleFileNameW@12 001a __wpgmptr 0023 __wcmdln 005a _wparse_cmdline 0067 ??_C@_09MPMN@stdargv?4c?$AA@ 007a __malloc_dbg 008d __amsg_exit 00bd ___argc 00c6 ___wargv 00cb __wcwild"
	strings:
		$1 = { 55 8B EC 83 EC 14 68 04 01 00 00 68 ?? ?? ?? ?? 6A 00 FF 15 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 C9 66 8B 08 85 C9 75 0B 8B 15 ?? ?? ?? ?? 89 55 EC EB 08 A1 ?? ?? ?? ?? 89 45 EC 8B 4D EC 89 4D F0 8D 55 FC 52 8D 45 F4 50 6A 00 6A 00 8B 4D F0 51 E8 ?? ?? ?? ?? 83 C4 14 68 80 00 00 00 68 ?? ?? ?? ?? 6A 02 8B 55 FC D1 E2 8B 45 F4 8D 0C 82 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 F8 83 7D F8 00 75 0A 6A 08 E8 ?? ?? ?? ?? 83 C4 04 8D 55 FC 52 8D 45 F4 50 8B 4D F4 8B 55 F8 8D 04 8A 50 8B 4D F8 51 8B 55 F0 52 E8 ?? ?? ?? ?? 83 C4 14 8B 45 F4 83 E8 01 A3 ?? ?? ?? ?? 8B 4D F8 89 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 0A 6A 08 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_175_1_0 {
	meta:
		name = "_wparse_cmdline"
		size = 920
	strings:
		$1 = { 55 8B EC 83 EC 14 8B 45 18 C7 00 00 00 00 00 8B 4D 14 C7 01 01 00 00 00 8B 55 08 89 55 FC 83 7D 0C 00 74 11 8B 45 0C 8B 4D 10 89 08 8B 55 0C 83 C2 04 89 55 0C 83 7D 10 00 74 15 8B 45 10 8B 4D FC 66 8B 11 66 89 10 8B 45 10 83 C0 02 89 45 10 8B 4D 18 8B 11 83 C2 01 8B 45 18 89 10 8B 4D FC 33 D2 66 8B 11 83 FA 22 0F 85 8B 00 00 00 8B 45 FC 83 C0 02 89 45 FC 8B 4D FC 33 D2 66 8B 11 83 FA 22 74 36 8B 45 FC 33 C9 66 8B 08 85 C9 74 2A 8B 55 18 8B 02 83 C0 01 8B 4D 18 89 01 83 7D 10 00 74 15 8B 55 10 8B 45 FC 66 8B 08 66 89 0A 8B 55 10 83 C2 02 89 55 10 EB B4 8B 45 18 8B 08 83 C1 01 8B 55 18 89 0A 83 7D 10 00 74 11 8B 45 10 66 C7 00 00 00 8B 4D 10 83 C1 02 89 4D 10 8B 55 FC 33 C0 66 8B 02 83 F8 22 75 09 8B 4D FC 83 C1 02 89 4D FC E9 89 00 00 00 8B 55 18 8B 02 83 C0 01 8B 4D 18 89 01 83 7D 10 00 74 15 8B 55 10 8B 45 FC 66 8B 08 66 89 0A 8B 55 10 83 C2 02 89 55 10 8B 45 FC 66 8B 08 66 89 4D F4 8B 55 FC 83 C2 02 89 55 FC 8B 45 F4 25 FF FF 00 00 83 F8 20 74 1B 8B 4D F4 81 E1 FF FF 00 00 85 C9 74 0E 8B 55 F4 81 E2 FF FF 00 00 83 FA 09 75 9D 8B 45 F4 25 FF FF 00 00 85 C0 75 0B 8B 4D FC 83 E9 02 89 4D FC EB 0F 83 7D 10 00 74 09 8B 55 10 66 C7 42 FE 00 00 C7 45 EC 00 00 00 00 8B 45 FC 33 C9 66 8B 08 85 C9 74 25 8B 55 FC 33 C0 66 8B 02 83 F8 20 74 0D 8B 4D FC 33 D2 66 8B 11 83 FA 09 75 0B 8B 45 FC 83 C0 02 89 45 FC EB DB 8B 4D FC 33 D2 66 8B 11 85 D2 75 05 E9 A4 01 00 00 83 7D 0C 00 74 11 8B 45 0C 8B 4D 10 89 08 8B 55 0C 83 C2 04 89 55 0C 8B 45 14 8B 08 83 C1 01 8B 55 14 89 0A 83 7D 10 00 74 15 8B 45 10 8B 4D FC 66 8B 11 66 89 10 8B 45 10 83 C0 02 89 45 10 8B 4D 18 8B 11 83 C2 01 8B 45 18 89 10 C7 45 F8 01 00 00 00 C7 45 F0 00 00 00 00 8B 4D FC 33 D2 66 8B 11 83 FA 5C 75 14 8B 45 FC 83 C0 02 89 45 FC 8B 4D F0 83 C1 01 89 4D F0 EB DF 8B 55 FC 33 C0 66 8B 02 83 F8 22 75 53 8B 45 F0 33 D2 B9 02 00 00 00 F7 F1 85 D2 75 3B 83 7D EC 00 74 22 8B 55 FC 33 C0 66 8B 42 02 83 F8 22 75 0B 8B 4D FC 83 C1 02 89 4D FC EB 07 C7 45 F8 00 00 00 00 EB 07 C7 45 F8 00 00 00 00 33 D2 83 7D EC 00 0F 94 C2 89 55 EC 8B 45 F0 D1 E8 89 45 F0 8B 4D F0 8B 55 F0 83 EA 01 89 55 F0 85 C9 74 26 83 7D 10 00 74 11 8B 45 10 66 C7 00 5C 00 8B 4D 10 83 C1 02 89 4D 10 8B 55 18 8B 02 83 C0 01 8B 4D 18 89 01 EB CA 8B 55 FC 33 C0 66 8B 02 85 C0 74 20 83 7D EC 00 75 1C 8B 4D FC 33 D2 66 8B 11 83 FA 20 74 0D 8B 45 FC 33 C9 66 8B 08 83 F9 09 75 02 EB 3C 83 7D F8 00 74 28 83 7D 10 00 74 15 8B 55 10 8B 45 FC 66 8B 08 66 89 0A 8B 55 10 83 C2 02 89 55 10 8B 45 18 8B 08 83 C1 01 8B 55 18 89 0A 8B 45 FC 83 C0 02 89 45 FC E9 D1 FE FF FF 83 7D 10 00 74 11 8B 4D 10 66 C7 01 00 00 8B 55 10 83 C2 02 89 55 10 8B 45 18 8B 08 83 C1 01 8B 55 18 89 0A E9 1A FE FF FF 83 7D 0C 00 74 12 8B 45 0C C7 00 00 00 00 00 8B 4D 0C 83 C1 04 89 4D 0C 8B 55 14 8B 02 83 C0 01 8B 4D 14 89 01 8B E5 5D C3 }
	condition:
		$1
}

rule file_176_0_0 {
	meta:
		name = "__wspawnl"
		size = 213
		refs = "000d ??_C@_0BB@HLKL@pathname?5?$CB?$DN?5NULL?$AA@ 0016 ??_C@_08OHNM@spawnl?4c?$AA@ 001d __CrtDbgReport 003d ??_C@_0BG@FCLP@?$CKpathname?5?$CB?$DN?5_T?$CI?8?20?8?$CJ?$AA@ 0067 ??_C@_0BA@BICO@arglist?5?$CB?$DN?5NULL?$AA@ 0097 ??_C@_0BF@GGKN@?$CKarglist?5?$CB?$DN?5_T?$CI?8?20?8?$CJ?$AA@ 00c9 __wspawnve"
	strings:
		$1 = { 55 8B EC 53 56 57 83 7D 0C 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 36 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D6 8B 4D 0C 33 D2 66 8B 11 85 D2 75 1E 68 ?? ?? ?? ?? 6A 00 6A 37 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D0 83 7D 10 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 38 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D6 8B 55 10 33 C0 66 8B 02 85 C0 75 1E 68 ?? ?? ?? ?? 6A 00 6A 39 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D0 6A 00 8D 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 10 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_177_0_0 {
	meta:
		name = "__wsplitpath"
		size = 592
		refs = "0019 _wcslen 0044 _wcsncpy"
	strings:
		$1 = { 55 8B EC 83 EC 20 C7 45 F4 00 00 00 00 C7 45 F8 00 00 00 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 83 F8 01 72 3A 8B 4D 08 33 D2 66 8B 51 02 83 FA 3A 75 2C 83 7D 0C 00 74 1B 6A 02 8B 45 08 50 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 0C 66 C7 42 04 00 00 8B 45 08 83 C0 04 89 45 08 EB 0E 83 7D 0C 00 74 08 8B 4D 0C 66 C7 01 00 00 C7 45 F4 00 00 00 00 8B 55 08 89 55 FC EB 09 8B 45 FC 83 C0 02 89 45 FC 8B 4D FC 33 D2 66 8B 11 85 D2 74 3A 8B 45 FC 33 C9 66 8B 08 83 F9 2F 74 0D 8B 55 FC 33 C0 66 8B 02 83 F8 5C 75 0B 8B 4D FC 83 C1 02 89 4D F4 EB 13 8B 55 FC 33 C0 66 8B 02 83 F8 2E 75 06 8B 4D FC 89 4D F8 EB B1 83 7D F4 00 74 58 83 7D 10 00 74 4A 8B 55 F4 2B 55 08 D1 EA 81 FA FF 00 00 00 73 0D 8B 45 F4 2B 45 08 D1 E8 89 45 EC EB 07 C7 45 EC FF 00 00 00 8B 4D EC 89 4D F0 8B 55 F0 52 8B 45 08 50 8B 4D 10 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 F0 8B 45 10 66 C7 04 50 00 00 8B 4D F4 89 4D 08 EB 0E 83 7D 10 00 74 08 8B 55 10 66 C7 02 00 00 83 7D F8 00 0F 84 AD 00 00 00 8B 45 F8 3B 45 08 0F 82 A1 00 00 00 83 7D 14 00 74 4A 8B 4D F8 2B 4D 08 D1 E9 81 F9 FF 00 00 00 73 0D 8B 55 F8 2B 55 08 D1 EA 89 55 E8 EB 07 C7 45 E8 FF 00 00 00 8B 45 E8 89 45 F0 8B 4D F0 51 8B 55 08 52 8B 45 14 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D F0 8B 55 14 66 C7 04 4A 00 00 83 7D 18 00 74 49 8B 45 FC 2B 45 F8 D1 E8 3D FF 00 00 00 73 0D 8B 4D FC 2B 4D F8 D1 E9 89 4D E4 EB 07 C7 45 E4 FF 00 00 00 8B 55 E4 89 55 F0 8B 45 F0 50 8B 4D F8 51 8B 55 18 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 F0 8B 4D 18 66 C7 04 41 00 00 EB 5E 83 7D 14 00 74 4A 8B 55 FC 2B 55 08 D1 EA 81 FA FF 00 00 00 73 0D 8B 45 FC 2B 45 08 D1 E8 89 45 E0 EB 07 C7 45 E0 FF 00 00 00 8B 4D E0 89 4D F0 8B 55 F0 52 8B 45 08 50 8B 4D 14 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 F0 8B 45 14 66 C7 04 50 00 00 83 7D 18 00 74 08 8B 4D 18 66 C7 01 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_178_0_0 {
	meta:
		name = "___crtGetEnvironmentStringsA"
		size = 537
		refs = "0016 _?f_use@?1??__crtGetEnvironmentStringsA@@9@9 001f __imp__GetEnvironmentStringsW@0 003a __imp__GetEnvironmentStrings@0 00d9 __imp__WideCharToMultiByte@32 00e9 ??_C@_07BNNE@a_env?4c?$AA@ 00f4 __malloc_dbg 010a __imp__FreeEnvironmentStringsW@4 013e __free_dbg 01e8 __imp__FreeEnvironmentStringsA@4 01fd _memcpy"
	strings:
		$1 = { 55 8B EC 83 EC 18 C7 45 EC 00 00 00 00 C7 45 E8 00 00 00 00 83 3D ?? ?? ?? ?? 00 75 3D FF 15 ?? ?? ?? ?? 89 45 EC 83 7D EC 00 74 0C C7 05 ?? ?? ?? ?? 01 00 00 00 EB 22 FF 15 ?? ?? ?? ?? 89 45 E8 83 7D E8 00 74 0C C7 05 ?? ?? ?? ?? 02 00 00 00 EB 07 33 C0 E9 BB 01 00 00 83 3D ?? ?? ?? ?? 01 0F 85 F7 00 00 00 83 7D EC 00 75 16 FF 15 ?? ?? ?? ?? 89 45 EC 83 7D EC 00 75 07 33 C0 E9 92 01 00 00 8B 45 EC 89 45 F8 8B 4D F8 33 D2 66 8B 11 85 D2 74 20 8B 45 F8 83 C0 02 89 45 F8 8B 4D F8 33 D2 66 8B 11 85 D2 75 09 8B 45 F8 83 C0 02 89 45 F8 EB D4 8B 4D F8 2B 4D EC D1 F9 83 C1 01 89 4D FC 6A 00 6A 00 6A 00 6A 00 8B 55 FC 52 8B 45 EC 50 6A 00 6A 00 FF 15 ?? ?? ?? ?? 89 45 F0 83 7D F0 00 74 1E 6A 64 68 ?? ?? ?? ?? 6A 02 8B 4D F0 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 E8 83 7D E8 00 75 11 8B 55 EC 52 FF 15 ?? ?? ?? ?? 33 C0 E9 00 01 00 00 6A 00 6A 00 8B 45 F0 50 8B 4D E8 51 8B 55 FC 52 8B 45 EC 50 6A 00 6A 00 FF 15 ?? ?? ?? ?? 85 C0 75 15 6A 02 8B 4D E8 51 E8 ?? ?? ?? ?? 83 C4 08 C7 45 E8 00 00 00 00 8B 55 EC 52 FF 15 ?? ?? ?? ?? 8B 45 E8 E9 B7 00 00 00 83 3D ?? ?? ?? ?? 02 0F 85 A8 00 00 00 83 7D E8 00 75 16 FF 15 ?? ?? ?? ?? 89 45 E8 83 7D E8 00 75 07 33 C0 E9 8E 00 00 00 8B 45 E8 89 45 F4 8B 4D F4 0F BE 11 85 D2 74 1E 8B 45 F4 83 C0 01 89 45 F4 8B 4D F4 0F BE 11 85 D2 75 09 8B 45 F4 83 C0 01 89 45 F4 EB D8 8B 4D F4 2B 4D E8 83 C1 01 89 4D F0 68 8F 00 00 00 68 ?? ?? ?? ?? 6A 02 8B 55 F0 52 E8 ?? ?? ?? ?? 83 C4 10 89 45 F4 83 7D F4 00 75 0E 8B 45 E8 50 FF 15 ?? ?? ?? ?? 33 C0 EB 25 8B 4D F0 51 8B 55 E8 52 8B 45 F4 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D E8 51 FF 15 ?? ?? ?? ?? 8B 45 F4 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_179_0_0 {
	meta:
		name = "_towupper"
		size = 180
		refs = "001e ___lc_handle 006f _iswctype 009b ___crtLCMapStringW"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 25 FF FF 00 00 3D FF FF 00 00 75 09 66 8B 45 08 E9 94 00 00 00 83 3D ?? ?? ?? ?? 00 75 31 8B 4D 08 81 E1 FF FF 00 00 83 F9 61 7C 1D 8B 55 08 81 E2 FF FF 00 00 83 FA 7A 7F 0F 8B 45 08 25 FF FF 00 00 83 E8 20 66 89 45 08 66 8B 45 08 EB 5A 8B 4D 08 81 E1 FF FF 00 00 81 F9 00 01 00 00 7D 19 6A 02 66 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 06 66 8B 45 08 EB 30 6A 00 6A 01 8D 45 FC 50 6A 01 8D 4D 08 51 68 00 02 00 00 8B 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 1C 85 C0 75 06 66 8B 45 08 EB 04 66 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_180_0_0 {
	meta:
		name = "_vprintf"
		size = 122
		refs = "000c __iob 0017 ??_C@_0P@LNLA@format?5?$CB?$DN?5NULL?$AA@ 0020 ??_C@_09BPGO@vprintf?4c?$AA@ 0027 __CrtDbgReport 003f __stbuf 0056 __output 0069 __ftbuf"
	strings:
		$1 = { 55 8B EC 83 EC 0C 53 56 57 C7 45 FC ?? ?? ?? ?? 83 7D 08 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 31 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D6 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 F8 8B 55 0C 52 8B 45 08 50 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F4 8B 55 FC 52 8B 45 F8 50 E8 ?? ?? ?? ?? 83 C4 08 8B 45 F4 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_181_0_0 {
	meta:
		name = "__ismbcl0"
		size = 64
		refs = "0006 ___mbcodepage 0015 __ismbclegal"
	strings:
		$1 = { 55 8B EC 51 81 3D ?? ?? ?? ?? A4 03 00 00 75 22 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 12 81 7D 08 9F 88 00 00 73 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_181_1_0 {
	meta:
		name = "__ismbcl1"
		size = 73
		refs = "0006 ___mbcodepage 0015 __ismbclegal"
	strings:
		$1 = { 55 8B EC 51 81 3D ?? ?? ?? ?? A4 03 00 00 75 2B 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 1B 81 7D 08 9F 88 00 00 72 12 81 7D 08 72 98 00 00 77 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_181_2_0 {
	meta:
		name = "__ismbcl2"
		size = 73
		refs = "0006 ___mbcodepage 0015 __ismbclegal"
	strings:
		$1 = { 55 8B EC 51 81 3D ?? ?? ?? ?? A4 03 00 00 75 2B 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 1B 81 7D 08 9F 98 00 00 72 12 81 7D 08 A4 EA 00 00 77 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_182_0_0 {
	meta:
		name = "__wincmdln"
		size = 188
		refs = "0006 ___mbctype_initialized 000e ___initmbctable 0013 __acmdln 004f __ismbblead"
	strings:
		$1 = { 55 8B EC 51 83 3D ?? ?? ?? ?? 00 75 05 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 89 45 FC 8B 4D FC 33 D2 8A 11 83 FA 22 75 56 8B 45 FC 83 C0 01 89 45 FC 8B 4D FC 33 D2 8A 11 83 FA 22 74 2A 8B 45 FC 33 C9 8A 08 85 C9 74 1F 8B 55 FC 33 C0 8A 02 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 09 8B 4D FC 83 C1 01 89 4D FC EB C1 8B 55 FC 33 C0 8A 02 83 F8 22 75 09 8B 4D FC 83 C1 01 89 4D FC EB 17 8B 55 FC 33 C0 8A 02 83 F8 20 7E 0B 8B 4D FC 83 C1 01 89 4D FC EB E9 8B 55 FC 33 C0 8A 02 85 C0 74 17 8B 4D FC 33 D2 8A 11 83 FA 20 7F 0B 8B 45 FC 83 C0 01 89 45 FC EB DE 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_183_0_0 {
	meta:
		name = "__CxxThrowException@8"
		size = 65
		refs = "000e _?ExceptionTemplate@?1??_CxxThrowException@@9@8@4UEHExceptionRecord@@B 0035 __imp__RaiseException@16"
	strings:
		$1 = { 55 8B EC 83 EC 20 56 57 B9 08 00 00 00 BE ?? ?? ?? ?? 8D 7D E0 F3 A5 8B 45 08 89 45 F8 8B 4D 0C 89 4D FC 8D 55 F4 52 8B 45 F0 50 8B 4D E4 51 8B 55 E0 52 FF 15 ?? ?? ?? ?? 5F 5E 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_184_0_0 {
	meta:
		name = "_setbuf"
		size = 102
		refs = "000d ??_C@_0P@FHEA@stream?5?$CB?$DN?5NULL?$AA@ 0016 ??_C@_08FFN@setbuf?4c?$AA@ 001d __CrtDbgReport 0041 _setvbuf"
	strings:
		$1 = { 55 8B EC 53 56 57 83 7D 08 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 2F 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D6 83 7D 0C 00 75 14 6A 00 6A 04 6A 00 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 10 EB 17 68 00 02 00 00 6A 00 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_185_0_0 {
	meta:
		name = "__fsopen"
		size = 240
		refs = "0010 ??_C@_0N@MCKG@file?5?$CB?$DN?5NULL?$AA@ 0019 ??_C@_07OMGG@fopen?4c?$AA@ 0020 __CrtDbgReport 003e ??_C@_0BC@GOED@?$CKfile?5?$CB?$DN?5_T?$CI?8?20?8?$CJ?$AA@ 0068 ??_C@_0N@BKPP@mode?5?$CB?$DN?5NULL?$AA@ 0096 ??_C@_0BC@IPFL@?$CKmode?5?$CB?$DN?5_T?$CI?8?20?8?$CJ?$AA@ 00ba __getstream 00dc __openfile"
	strings:
		$1 = { 55 8B EC 83 EC 08 53 56 57 83 7D 08 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 35 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D6 8B 4D 08 0F BE 11 85 D2 75 1E 68 ?? ?? ?? ?? 6A 00 6A 36 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D2 83 7D 0C 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 37 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D6 8B 55 0C 0F BE 02 85 C0 75 1E 68 ?? ?? ?? ?? 6A 00 6A 38 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D2 E8 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 75 04 33 C0 EB 1E 8B 55 FC 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 89 45 F8 8B 45 F8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_186_0_0 {
	meta:
		name = "_floor"
		size = 309
		refs = "000c _newcw 0012 __ctrlfp 0040 __sptype 0086 __handle_qnan1 009b __real@8@3fff8000000000000000 00b2 __except1 00c4 __frnd"
	strings:
		$1 = { 55 8B EC 83 EC 10 68 FF FF 00 00 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 F4 8B 4D 0E 81 E1 FF FF 00 00 81 E1 F0 7F 00 00 81 F9 F0 7F 00 00 0F 85 84 00 00 00 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 F0 83 7D F0 00 7E 42 83 7D F0 02 7E 08 83 7D F0 03 74 1B EB 34 68 FF FF 00 00 8B 4D F4 51 E8 ?? ?? ?? ?? 83 C4 08 DD 45 08 E9 BA 00 00 00 8B 55 F4 52 8B 45 0C 50 8B 4D 08 51 6A 0B E8 ?? ?? ?? ?? 83 C4 10 E9 9F 00 00 00 8B 55 F4 52 DD 45 08 DC 05 ?? ?? ?? ?? 83 EC 08 DD 1C 24 8B 45 0C 50 8B 4D 08 51 6A 0B 6A 08 E8 ?? ?? ?? ?? 83 C4 1C EB 76 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 DD 5D F8 DD 45 F8 DC 5D 08 DF E0 F6 C4 40 74 16 68 FF FF 00 00 8B 4D F4 51 E8 ?? ?? ?? ?? 83 C4 08 DD 45 F8 EB 40 8B 55 F4 83 E2 20 85 D2 74 16 68 FF FF 00 00 8B 45 F4 50 E8 ?? ?? ?? ?? 83 C4 08 DD 45 F8 EB 20 8B 4D F4 51 8B 55 FC 52 8B 45 F8 50 8B 4D 0C 51 8B 55 08 52 6A 0B 6A 10 E8 ?? ?? ?? ?? 83 C4 1C 8B E5 5D C3 }
	condition:
		$1
}

rule file_187_0_0 {
	meta:
		name = "_time"
		size = 385
		refs = "000f __imp__GetLocalTime@4 0019 __imp__GetSystemTime@4 002a _gmt_cache 0089 _dstflag_cache 00a1 __imp__GetTimeZoneInformation@4 0162 ___loctotime_t"
	strings:
		$1 = { 55 8B EC 81 EC D8 00 00 00 8D 45 DC 50 FF 15 ?? ?? ?? ?? 8D 4D F0 51 FF 15 ?? ?? ?? ?? 8B 55 FA 81 E2 FF FF 00 00 33 C0 66 A1 ?? ?? ?? ?? 3B D0 75 66 8B 4D F8 81 E1 FF FF 00 00 33 D2 66 8B 15 ?? ?? ?? ?? 3B CA 75 50 8B 45 F6 25 FF FF 00 00 33 C9 66 8B 0D ?? ?? ?? ?? 3B C1 75 3B 8B 55 F2 81 E2 FF FF 00 00 33 C0 66 A1 ?? ?? ?? ?? 3B D0 75 26 8B 4D F0 81 E1 FF FF 00 00 33 D2 66 8B 15 ?? ?? ?? ?? 3B CA 75 10 A1 ?? ?? ?? ?? 89 85 28 FF FF FF E9 88 00 00 00 8D 8D 30 FF FF FF 51 FF 15 ?? ?? ?? ?? 89 85 2C FF FF FF 83 BD 2C FF FF FF FF 74 34 83 BD 2C FF FF FF 02 75 1F 8B 55 CA 81 E2 FF FF 00 00 85 D2 74 12 83 7D D8 00 74 0C C7 85 28 FF FF FF 01 00 00 00 EB 0A C7 85 28 FF FF FF 00 00 00 00 EB 0A C7 85 28 FF FF FF FF FF FF FF 8B 85 28 FF FF FF A3 ?? ?? ?? ?? 8B 4D F0 89 0D ?? ?? ?? ?? 8B 55 F4 89 15 ?? ?? ?? ?? 8B 45 F8 A3 ?? ?? ?? ?? 8B 4D FC 89 0D ?? ?? ?? ?? 8B 95 28 FF FF FF 52 8B 45 E8 25 FF FF 00 00 50 8B 4D E6 81 E1 FF FF 00 00 51 8B 55 E4 81 E2 FF FF 00 00 52 8B 45 E2 25 FF FF 00 00 50 8B 4D DE 81 E1 FF FF 00 00 51 8B 55 DC 81 E2 FF FF 00 00 52 E8 ?? ?? ?? ?? 83 C4 1C 89 45 EC 83 7D 08 00 74 08 8B 45 08 8B 4D EC 89 08 8B 45 EC 8B E5 5D C3 }
	condition:
		$1
}

rule file_189_0_0 {
	meta:
		name = "__wgetcwd"
		size = 32
		refs = "000f __wgetdcwd"
	strings:
		$1 = { 55 8B EC 51 8B 45 0C 50 8B 4D 08 51 6A 00 E8 ?? ?? ?? ?? 83 C4 0C 89 45 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_451_0_0 {
	meta:
		name = "__getcwd"
		size = 32
		refs = "000f __getdcwd"
	strings:
		$1 = { 55 8B EC 51 8B 45 0C 50 8B 4D 08 51 6A 00 E8 ?? ?? ?? ?? 83 C4 0C 89 45 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_189_1_0 {
	meta:
		name = "__wgetdcwd"
		size = 293
		refs = "0014 __validdrive 0021 __doserrno 002b _errno 006c __imp__GetFullPathNameW@16 0083 __imp__GetCurrentDirectoryW@8 00d8 _malloc 011a _wcscpy"
	strings:
		$1 = { 55 8B EC 81 EC 20 02 00 00 83 7D 08 00 74 66 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 1B C7 05 ?? ?? ?? ?? 0F 00 00 00 C7 05 ?? ?? ?? ?? 0D 00 00 00 33 C0 E9 E7 00 00 00 8B 4D 08 83 C1 40 66 89 4D F0 66 C7 45 F2 3A 00 66 C7 45 F4 2E 00 66 C7 45 F6 00 00 8D 55 F8 52 8D 85 E4 FD FF FF 50 68 04 01 00 00 8D 4D F0 51 FF 15 ?? ?? ?? ?? 89 45 EC EB 15 8D 95 E4 FD FF FF 52 68 04 01 00 00 FF 15 ?? ?? ?? ?? 89 45 EC 83 7D EC 00 74 12 8B 45 EC 83 C0 01 89 45 EC 81 7D EC 04 01 00 00 76 04 33 C0 EB 7B 8B 4D 0C 89 4D FC 83 7D FC 00 75 46 8B 55 EC 3B 55 10 7E 0B 8B 45 EC 89 85 E0 FD FF FF EB 09 8B 4D 10 89 8D E0 FD FF FF 8B 95 E0 FD FF FF D1 E2 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 83 7D FC 00 75 0E C7 05 ?? ?? ?? ?? 0C 00 00 00 33 C0 EB 2B EB 16 8B 45 EC 3B 45 10 7E 0E C7 05 ?? ?? ?? ?? 22 00 00 00 33 C0 EB 13 8D 8D E4 FD FF FF 51 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_190_0_0 {
	meta:
		name = "_difftime"
		size = 20
	strings:
		$1 = { 55 8B EC 51 8B 45 08 2B 45 0C 89 45 FC DB 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_191_0_0 {
	meta:
		name = "__mbsinc"
		size = 48
		refs = "000e __mbctype"
	strings:
		$1 = { 55 8B EC 8B 45 08 33 C9 8A 08 33 D2 8A 91 ?? ?? ?? ?? 83 E2 04 8B 45 08 83 C0 01 89 45 08 85 D2 74 09 8B 4D 08 83 C1 01 89 4D 08 8B 45 08 5D C3 }
	condition:
		$1
}

rule file_194_0_0 {
	meta:
		name = "__cprintf"
		size = 30
		refs = "0013 _output"
	strings:
		$1 = { 55 8B EC 51 8D 45 0C 89 45 FC 8B 4D FC 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_194_1_0 {
	meta:
		name = "_output"
		size = 3331
		refs = "0067 ___lookuptable 00bc $L1937 00d1 __pctype 00f2 _write_char 0113 ??_C@_0P@PIHB@ch?5?$CB?$DN?5_T?$CI?8?20?8?$CJ?$AA@ 011f ??_C@_08MIHI@output?4c?$AA@ 0126 __CrtDbgReport 01c0 $L1938 01c7 $L1939 0211 _get_int_arg 02e3 $L1940 02ea $L1941 037a $L1942 0381 $L1943 03ac _get_short_arg 03c4 _wctomb 043c ___nullstring 0448 _strlen 050f ___wnullstring 06a9 __cfltcvt_tab 07d2 _get_int64_arg 0983 __aullrem 09a8 __aulldiv 0ac6 _write_multi_char 0ae0 _write_string 0c05 $NORMAL_STATE$1671 0c09 $L1683 0c0d $L1684 0c11 $L1694 0c15 $L1698 0c19 $L1699 0c1d $L1703 0c21 $L1714 0c25 $L1691 0c29 $L1692 0c2d $L1690 0c31 $L1689 0c35 $L1693 0c39 $L1686 0c4e $L1709 0c52 $L1712 0c56 $L1708 0c5a $L1713 0c5e $L1705 0c91 $L1719 0c95 $L1772 0c99 $L1745 0c9d $L1797 0ca1 $L1729 0ca5 $L1720 0ca9 $L1792 0cad $L1773 0cb1 $L1764 0cb5 $L1802 0cb9 $L1795 0cbd $L1746 0cc1 $L1794 0cc5 $L1799 0cc9 $L1716"
	strings:
		$1 = { 55 8B EC 81 EC A8 02 00 00 53 56 57 C7 45 DC 00 00 00 00 C7 85 D4 FD FF FF 00 00 00 00 C7 45 E8 00 00 00 00 8B 45 08 8A 08 88 4D D8 0F BE 55 D8 8B 45 08 83 C0 01 89 45 08 85 D2 0F 84 B7 0B 00 00 83 BD D4 FD FF FF 00 0F 8C AA 0B 00 00 0F BE 4D D8 83 F9 20 7C 1F 0F BE 55 D8 83 FA 78 7F 16 0F BE 45 D8 0F BE 88 ?? ?? ?? ?? 83 E1 0F 89 8D 70 FD FF FF EB 0A C7 85 70 FD FF FF 00 00 00 00 8B 95 70 FD FF FF 89 55 F4 8B 45 F4 8B 4D E8 0F BE 94 C1 ?? ?? ?? ?? C1 FA 04 89 55 E8 8B 45 E8 89 85 6C FD FF FF 83 BD 6C FD FF FF 07 0F 87 40 0B 00 00 8B 8D 6C FD FF FF FF 24 8D ?? ?? ?? ?? C7 45 E4 00 00 00 00 8B 55 D8 81 E2 FF 00 00 00 A1 ?? ?? ?? ?? 33 C9 66 8B 0C 50 81 E1 00 80 00 00 85 C9 74 54 8D 95 D4 FD FF FF 52 0F BE 45 D8 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4D 08 8A 11 88 55 D8 8B 45 08 83 C0 01 89 45 08 0F BE 4D D8 85 C9 75 21 68 ?? ?? ?? ?? 6A 00 68 86 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 D2 85 D2 75 D1 8D 85 D4 FD FF FF 50 0F BE 4D D8 51 E8 ?? ?? ?? ?? 83 C4 08 E9 A1 0A 00 00 C7 45 F8 00 00 00 00 8B 55 F8 89 95 C4 FD FF FF 8B 85 C4 FD FF FF 89 85 BC FD FF FF 8B 8D BC FD FF FF 89 4D F0 C7 45 FC 00 00 00 00 C7 85 CC FD FF FF FF FF FF FF C7 45 E4 00 00 00 00 E9 5F 0A 00 00 0F BE 55 D8 89 95 68 FD FF FF 8B 85 68 FD FF FF 83 E8 20 89 85 68 FD FF FF 83 BD 68 FD FF FF 10 77 48 8B 95 68 FD FF FF 33 C9 8A 8A ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? 8B 45 FC 0C 04 89 45 FC EB 29 8B 4D FC 83 C9 01 89 4D FC EB 1E 8B 55 FC 83 CA 02 89 55 FC EB 13 8B 45 FC 0C 80 89 45 FC EB 09 8B 4D FC 83 C9 08 89 4D FC E9 F0 09 00 00 0F BE 55 D8 83 FA 2A 75 34 8D 45 0C 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 BC FD FF FF 83 BD BC FD FF FF 00 7D 17 8B 4D FC 83 C9 04 89 4D FC 8B 95 BC FD FF FF F7 DA 89 95 BC FD FF FF EB 17 8B 85 BC FD FF FF 6B C0 0A 0F BE 4D D8 8D 54 08 D0 89 95 BC FD FF FF E9 97 09 00 00 C7 85 CC FD FF FF 00 00 00 00 E9 88 09 00 00 0F BE 45 D8 83 F8 2A 75 27 8D 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 04 89 85 CC FD FF FF 83 BD CC FD FF FF 00 7D 0A C7 85 CC FD FF FF FF FF FF FF EB 17 8B 95 CC FD FF FF 6B D2 0A 0F BE 45 D8 8D 4C 02 D0 89 8D CC FD FF FF E9 3C 09 00 00 0F BE 55 D8 89 95 64 FD FF FF 8B 85 64 FD FF FF 83 E8 49 89 85 64 FD FF FF 83 BD 64 FD FF FF 2E 77 6C 8B 95 64 FD FF FF 33 C9 8A 8A ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? 8B 45 FC 0C 10 89 45 FC EB 4D 8B 4D 08 0F BE 11 83 FA 36 75 20 8B 45 08 0F BE 48 01 83 F9 34 75 14 8B 55 08 83 C2 02 89 55 08 8B 45 FC 80 CC 80 89 45 FC EB 0C C7 45 E8 00 00 00 00 E9 91 FD FF FF EB 14 8B 4D FC 83 C9 20 89 4D FC EB 09 8B 55 FC 80 CE 08 89 55 FC E9 A9 08 00 00 0F BE 45 D8 89 85 60 FD FF FF 8B 8D 60 FD FF FF 83 E9 43 89 8D 60 FD FF FF 83 BD 60 FD FF FF 35 0F 87 C3 06 00 00 8B 85 60 FD FF FF 33 D2 8A 90 ?? ?? ?? ?? FF 24 95 ?? ?? ?? ?? 8B 4D FC 81 E1 30 08 00 00 85 C9 75 09 8B 55 FC 80 CE 08 89 55 FC 8B 45 FC 25 10 08 00 00 85 C0 74 39 8D 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 04 66 89 45 EC 66 8B 55 EC 52 8D 85 D8 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 DC 83 7D DC 00 7D 0A C7 85 C4 FD FF FF 01 00 00 00 EB 26 8D 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 04 66 89 85 B8 FD FF FF 8A 95 B8 FD FF FF 88 95 D8 FD FF FF C7 45 DC 01 00 00 00 8D 85 D8 FD FF FF 89 45 E0 E9 1F 06 00 00 8D 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 04 89 85 B4 FD FF FF 83 BD B4 FD FF FF 00 74 0C 8B 95 B4 FD FF FF 83 7A 04 00 75 19 A1 ?? ?? ?? ?? 89 45 E0 8B 4D E0 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 DC EB 4F 8B 55 FC 81 E2 00 08 00 00 85 D2 74 23 8B 85 B4 FD FF FF 8B 48 04 89 4D E0 8B 95 B4 FD FF FF 0F BF 02 D1 E8 89 45 DC C7 45 E4 01 00 00 00 EB 1F C7 45 E4 00 00 00 00 8B 8D B4 FD FF FF 8B 51 04 89 55 E0 8B 85 B4 FD FF FF 0F BF 08 89 4D DC E9 8B 05 00 00 8B 55 FC 81 E2 30 08 00 00 85 D2 75 09 8B 45 FC 80 CC 08 89 45 FC 83 BD CC FD FF FF FF 75 0C C7 85 5C FD FF FF FF FF FF 7F EB 0C 8B 8D CC FD FF FF 89 8D 5C FD FF FF 8B 95 5C FD FF FF 89 95 A8 FD FF FF 8D 45 0C 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 E0 8B 4D FC 81 E1 10 08 00 00 85 C9 74 68 83 7D E0 00 75 09 8B 15 ?? ?? ?? ?? 89 55 E0 C7 45 E4 01 00 00 00 8B 45 E0 89 85 AC FD FF FF 8B 8D A8 FD FF FF 8B 95 A8 FD FF FF 83 EA 01 89 95 A8 FD FF FF 85 C9 74 20 8B 85 AC FD FF FF 33 C9 66 8B 08 85 C9 74 11 8B 95 AC FD FF FF 83 C2 02 89 95 AC FD FF FF EB C7 8B 85 AC FD FF FF 2B 45 E0 D1 F8 89 45 DC EB 5B 83 7D E0 00 75 09 8B 0D ?? ?? ?? ?? 89 4D E0 8B 55 E0 89 95 B0 FD FF FF 8B 85 A8 FD FF FF 8B 8D A8 FD FF FF 83 E9 01 89 8D A8 FD FF FF 85 C0 74 1E 8B 95 B0 FD FF FF 0F BE 02 85 C0 74 11 8B 8D B0 FD FF FF 83 C1 01 89 8D B0 FD FF FF EB C9 8B 95 B0 FD FF FF 2B 55 E0 89 55 DC E9 64 04 00 00 8D 45 0C 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 A4 FD FF FF 8B 4D FC 83 E1 20 85 C9 74 12 8B 95 A4 FD FF FF 66 8B 85 D4 FD FF FF 66 89 02 EB 0E 8B 8D A4 FD FF FF 8B 95 D4 FD FF FF 89 11 C7 85 C4 FD FF FF 01 00 00 00 E9 19 04 00 00 C7 45 F8 01 00 00 00 8A 45 D8 04 20 88 45 D8 8B 4D FC 83 C9 40 89 4D FC 8D 95 D8 FD FF FF 89 55 E0 83 BD CC FD FF FF 00 7D 0C C7 85 CC FD FF FF 06 00 00 00 EB 1C 83 BD CC FD FF FF 00 75 13 0F BE 45 D8 83 F8 67 75 0A C7 85 CC FD FF FF 01 00 00 00 8B 4D 0C 83 C1 08 89 4D 0C 8B 55 0C 83 EA 08 8B 02 8B 4A 04 89 85 9C FD FF FF 89 8D A0 FD FF FF 8B 55 F8 52 8B 85 CC FD FF FF 50 0F BE 4D D8 51 8B 55 E0 52 8D 85 9C FD FF FF 50 FF 15 ?? ?? ?? ?? 83 C4 14 8B 4D FC 81 E1 80 00 00 00 85 C9 74 16 83 BD CC FD FF FF 00 75 0D 8B 55 E0 52 FF 15 ?? ?? ?? ?? 83 C4 04 0F BE 45 D8 83 F8 67 75 1A 8B 4D FC 81 E1 80 00 00 00 85 C9 75 0D 8B 55 E0 52 FF 15 ?? ?? ?? ?? 83 C4 04 8B 45 E0 0F BE 08 83 F9 2D 75 12 8B 55 FC 80 CE 01 89 55 FC 8B 45 E0 83 C0 01 89 45 E0 8B 4D E0 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 DC E9 0C 03 00 00 8B 55 FC 83 CA 40 89 55 FC C7 85 C8 FD FF FF 0A 00 00 00 E9 81 00 00 00 C7 85 C8 FD FF FF 0A 00 00 00 EB 75 C7 85 CC FD FF FF 08 00 00 00 C7 85 D0 FD FF FF 07 00 00 00 EB 0A C7 85 D0 FD FF FF 27 00 00 00 C7 85 C8 FD FF FF 10 00 00 00 8B 45 FC 25 80 00 00 00 85 C0 74 1D C6 85 C0 FD FF FF 30 8B 8D D0 FD FF FF 83 C1 51 88 8D C1 FD FF FF C7 45 F0 02 00 00 00 EB 20 C7 85 C8 FD FF FF 08 00 00 00 8B 55 FC 81 E2 80 00 00 00 85 D2 74 09 8B 45 FC 80 CC 02 89 45 FC 8B 4D FC 81 E1 00 80 00 00 85 C9 74 1D 8D 55 0C 52 E8 ?? ?? ?? ?? 83 C4 04 89 85 88 FD FF FF 89 95 8C FD FF FF E9 91 00 00 00 8B 45 FC 83 E0 20 85 C0 74 48 8B 4D FC 83 E1 40 85 C9 74 1E 8D 55 0C 52 E8 ?? ?? ?? ?? 83 C4 04 0F BF C0 99 89 85 88 FD FF FF 89 95 8C FD FF FF EB 1E 8D 45 0C 50 E8 ?? ?? ?? ?? 83 C4 04 25 FF FF 00 00 99 89 85 88 FD FF FF 89 95 8C FD FF FF EB 3F 8B 4D FC 83 E1 40 85 C9 74 1B 8D 55 0C 52 E8 ?? ?? ?? ?? 83 C4 04 99 89 85 88 FD FF FF 89 95 8C FD FF FF EB 1A 8D 45 0C 50 E8 ?? ?? ?? ?? 83 C4 04 33 C9 89 85 88 FD FF FF 89 8D 8C FD FF FF 8B 55 FC 83 E2 40 85 D2 74 3E 83 BD 8C FD FF FF 00 7F 35 7C 09 83 BD 88 FD FF FF 00 73 2A 8B 85 88 FD FF FF F7 D8 8B 8D 8C FD FF FF 83 D1 00 F7 D9 89 85 94 FD FF FF 89 8D 98 FD FF FF 8B 55 FC 80 CE 01 89 55 FC EB 18 8B 85 88 FD FF FF 89 85 94 FD FF FF 8B 8D 8C FD FF FF 89 8D 98 FD FF FF 8B 55 FC 81 E2 00 80 00 00 85 D2 75 1B 8B 85 94 FD FF FF 8B 8D 98 FD FF FF 83 E1 00 89 85 94 FD FF FF 89 8D 98 FD FF FF 83 BD CC FD FF FF 00 7D 0C C7 85 CC FD FF FF 01 00 00 00 EB 09 8B 55 FC 83 E2 F7 89 55 FC 8B 85 94 FD FF FF 0B 85 98 FD FF FF 85 C0 75 07 C7 45 F0 00 00 00 00 8D 4D D7 89 4D E0 8B 95 CC FD FF FF 8B 85 CC FD FF FF 83 E8 01 89 85 CC FD FF FF 85 D2 7F 14 8B 8D 94 FD FF FF 0B 8D 98 FD FF FF 85 C9 0F 84 81 00 00 00 8B 85 C8 FD FF FF 99 52 50 8B 95 98 FD FF FF 52 8B 85 94 FD FF FF 50 E8 ?? ?? ?? ?? 83 C0 30 89 85 90 FD FF FF 8B 85 C8 FD FF FF 99 52 50 8B 8D 98 FD FF FF 51 8B 95 94 FD FF FF 52 E8 ?? ?? ?? ?? 89 85 94 FD FF FF 89 95 98 FD FF FF 83 BD 90 FD FF FF 39 7E 12 8B 85 90 FD FF FF 03 85 D0 FD FF FF 89 85 90 FD FF FF 8B 4D E0 8A 95 90 FD FF FF 88 11 8B 45 E0 83 E8 01 89 45 E0 E9 52 FF FF FF 8D 4D D7 2B 4D E0 89 4D DC 8B 55 E0 83 C2 01 89 55 E0 8B 45 FC 25 00 02 00 00 85 C0 74 29 8B 4D E0 0F BE 11 83 FA 30 75 06 83 7D DC 00 75 18 8B 45 E0 83 E8 01 89 45 E0 8B 4D E0 C6 01 30 8B 55 DC 83 C2 01 89 55 DC 83 BD C4 FD FF FF 00 0F 85 B3 01 00 00 8B 45 FC 83 E0 40 85 C0 74 4F 8B 4D FC 81 E1 00 01 00 00 85 C9 74 10 C6 85 C0 FD FF FF 2D C7 45 F0 01 00 00 00 EB 32 8B 55 FC 83 E2 01 85 D2 74 10 C6 85 C0 FD FF FF 2B C7 45 F0 01 00 00 00 EB 18 8B 45 FC 83 E0 02 85 C0 74 0E C6 85 C0 FD FF FF 20 C7 45 F0 01 00 00 00 8B 8D BC FD FF FF 2B 4D DC 2B 4D F0 89 8D 84 FD FF FF 8B 55 FC 83 E2 0C 85 D2 75 18 8D 85 D4 FD FF FF 50 8B 8D 84 FD FF FF 51 6A 20 E8 ?? ?? ?? ?? 83 C4 0C 8D 95 D4 FD FF FF 52 8B 45 F0 50 8D 8D C0 FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 FC 83 E2 08 85 D2 74 22 8B 45 FC 83 E0 04 85 C0 75 18 8D 8D D4 FD FF FF 51 8B 95 84 FD FF FF 52 6A 30 E8 ?? ?? ?? ?? 83 C4 0C 83 7D E4 00 0F 84 9D 00 00 00 83 7D DC 00 0F 8E 93 00 00 00 8B 45 E0 89 85 80 FD FF FF 8B 4D DC 89 8D 7C FD FF FF 8B 95 7C FD FF FF 8B 85 7C FD FF FF 83 E8 01 89 85 7C FD FF FF 85 D2 74 66 8B 8D 80 FD FF FF 66 8B 11 66 89 95 5A FD FF FF 66 8B 85 5A FD FF FF 50 8D 8D 78 FD FF FF 51 8B 95 80 FD FF FF 83 C2 02 89 95 80 FD FF FF E8 ?? ?? ?? ?? 83 C4 08 89 85 74 FD FF FF 83 BD 74 FD FF FF 00 7F 02 EB 1F 8D 85 D4 FD FF FF 50 8B 8D 74 FD FF FF 51 8D 95 78 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C EB 81 EB 17 8D 85 D4 FD FF FF 50 8B 4D DC 51 8B 55 E0 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 FC 83 E0 04 85 C0 74 18 8D 8D D4 FD FF FF 51 8B 95 84 FD FF FF 52 6A 20 E8 ?? ?? ?? ?? 83 C4 0C E9 2C F4 FF FF 8B 85 D4 FD FF FF 5F 5E 5B 8B E5 5D C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 05 05 01 05 05 05 05 05 05 05 02 05 03 05 05 04 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 01 04 04 04 02 04 04 04 04 04 04 04 04 04 04 03 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 0E 01 0E 01 0E 0E 0E 0E 0E 0E 0E 0E 0E 0E 0E 02 0E 0E 0E 0E 03 0E 04 0E 0E 0E 0E 0E 0E 0E 0E 05 06 07 07 07 0E 06 0E 0E 0E 0E 08 09 0A 0E 0E 0B 0E 0C 0E 0E 0D }
	condition:
		$1
}

rule file_194_2_0 {
	meta:
		name = "_write_char"
		size = 46
		refs = "0008 __putch"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 83 F8 FF 75 0B 8B 4D 0C C7 01 FF FF FF FF EB 0D 8B 55 0C 8B 02 83 C0 01 8B 4D 0C 89 01 5D C3 }
	condition:
		$1
}

rule file_194_3_0 {
	meta:
		name = "_write_multi_char"
		size = 49
		refs = "001c _write_char"
	strings:
		$1 = { 55 8B EC 8B 45 0C 8B 4D 0C 83 E9 01 89 4D 0C 85 C0 7E 1C 8B 55 10 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4D 10 83 39 FF 75 02 EB 02 EB D4 5D C3 }
	condition:
		$1
}

rule file_194_4_0 {
	meta:
		name = "_write_string"
		size = 70
		refs = "002f _write_char"
	strings:
		$1 = { 55 8B EC 51 8B 45 0C 8B 4D 0C 83 E9 01 89 4D 0C 85 C0 7E 2E 8B 55 10 52 8B 45 08 0F BE 08 89 4D FC 8B 55 FC 52 8B 45 08 83 C0 01 89 45 08 E8 ?? ?? ?? ?? 83 C4 08 8B 4D 10 83 39 FF 75 02 EB 02 EB C2 8B E5 5D C3 }
	condition:
		$1
}

rule file_194_7_0 {
	meta:
		name = "_get_short_arg"
		size = 27
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 08 83 C1 04 8B 55 08 89 0A 8B 45 08 8B 08 66 8B 41 FC 5D C3 }
	condition:
		$1
}

rule file_195_0_0 {
	meta:
		name = "_perror"
		size = 184
		refs = "0022 _strlen 0033 __write 003d ??_C@_02HFBK@?3?5?$AA@ 004f _errno 005d __sys_nerr 007d __sys_errlist 00a4 ??_C@_01BJG@?6?$AA@"
	strings:
		$1 = { 55 8B EC 83 EC 08 C7 45 FC 02 00 00 00 83 7D 08 00 74 3A 8B 45 08 0F BE 08 85 C9 74 30 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 50 8B 45 08 50 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 0C 6A 02 68 ?? ?? ?? ?? 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 0C 83 3D ?? ?? ?? ?? 00 7C 18 A1 ?? ?? ?? ?? 3B 05 ?? ?? ?? ?? 7D 0B 8B 0D ?? ?? ?? ?? 89 4D F8 EB 09 8B 15 ?? ?? ?? ?? 89 55 F8 8B 45 F8 8B 0C 85 ?? ?? ?? ?? 89 4D 08 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 50 8B 45 08 50 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 0C 6A 01 68 ?? ?? ?? ?? 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_196_0_0 {
	meta:
		name = "__strncoll"
		size = 125
		refs = "0010 ___lc_handle 0024 _strncmp 002e ___lc_collate_cp 0050 ___crtCompareStringA 006c _errno"
	strings:
		$1 = { 55 8B EC 51 83 7D 10 00 75 04 33 C0 EB 6B 83 3D ?? ?? ?? ?? 00 75 16 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C EB 4C A1 ?? ?? ?? ?? 50 8B 4D 10 51 8B 55 0C 52 8B 45 10 50 8B 4D 08 51 68 00 10 00 00 8B 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 1C 89 45 FC 83 7D FC 00 75 02 EB 08 8B 45 FC 83 E8 02 EB 0F C7 05 ?? ?? ?? ?? 16 00 00 00 B8 FF FF FF 7F 8B E5 5D C3 }
	condition:
		$1
}

rule file_197_0_0 {
	meta:
		name = "fFEXP"
		size = 103
		refs = "0023 __adjust_fdiv 002f __safe_fdivr 0041 __rttospop 005e __rtonepop 0063 __rtindfpop"
	strings:
		$1 = { C6 85 70 FF FF FF FE 32 ED D9 EA DE C9 E8 3B 01 00 00 D9 E8 DE C1 F6 85 61 FF FF FF 01 74 14 D9 E8 83 3D ?? ?? ?? ?? 01 74 04 DE F1 EB 05 E8 ?? ?? ?? ?? F6 C2 40 75 02 D9 FD 0A ED 74 02 D9 E0 E9 ?? ?? ?? ?? E8 46 01 00 00 0B C0 74 14 32 ED 83 F8 02 74 02 F6 D5 D9 C9 D9 E1 EB 9F E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_197_2_0 {
	meta:
		name = "__rtinfnpopse"
		size = 16
		refs = "0004 __infinity"
	strings:
		$1 = { DD D8 DB 2D ?? ?? ?? ?? C6 85 70 FF FF FF 02 C3 }
	condition:
		$1
}

rule file_197_3_0 {
	meta:
		name = "__fFLN"
		size = 181
		refs = "0025 __minfinity 003f __rtonepop 0067 __infinity 007b __rtzeronpop 0082 __rtindfnpop"
	strings:
		$1 = { D9 ED D9 C9 D9 E4 9B DD BD 60 FF FF FF 9B F6 85 61 FF FF FF 41 75 D2 D9 F1 C3 C6 85 70 FF FF FF 02 DD D8 DB 2D ?? ?? ?? ?? C3 0A C9 75 53 C3 D9 EC EB 02 D9 ED D9 C9 0A C9 75 AE D9 F1 C3 E9 ?? ?? ?? ?? E8 CF 00 00 00 DD D8 DD D8 0A C9 75 0E D9 EE 83 F8 01 75 06 0A ED 74 02 D9 E0 C3 C6 85 70 FF FF FF 02 DB 2D ?? ?? ?? ?? 83 F8 01 75 ED 0A ED 74 E9 D9 E0 EB E5 DD D8 E9 ?? ?? ?? ?? DD D8 E9 ?? ?? ?? ?? 58 D9 E4 9B DD BD 60 FF FF FF 9B F6 85 61 FF FF FF 01 75 0F DD D8 DB 2D ?? ?? ?? ?? 0A ED 74 02 D9 E0 C3 C6 85 70 FF FF FF 04 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_197_5_0 {
	meta:
		name = "__rtinfnpop"
		size = 16
		refs = "0004 __infinity"
	strings:
		$1 = { DD D8 DB 2D ?? ?? ?? ?? C6 85 70 FF FF FF 03 C3 }
	condition:
		$1
}

rule file_197_7_0 {
	meta:
		name = "__ffexpm1"
		size = 169
		refs = "0006 _log2max 0053 _half 008f __powhlp 00a4 __rttosnpopde"
	strings:
		$1 = { D9 C0 D9 E1 DB 2D ?? ?? ?? ?? DE D9 9B DD BD 60 FF FF FF 9B F6 85 61 FF FF FF 41 75 95 D9 C0 D9 FC D9 E4 9B DD BD 60 FF FF FF 9B 8A 95 61 FF FF FF D9 C9 D8 E1 D9 E4 9B DD BD 60 FF FF FF D9 E1 D9 F0 C3 D9 C0 D9 FC D8 D9 9B DF E0 9E 75 1A D9 C0 DC 0D ?? ?? ?? ?? D9 C0 D9 FC DE D9 9B DF E0 9E 74 0D B8 01 00 00 00 C3 B8 00 00 00 00 EB F8 B8 02 00 00 00 EB F1 56 83 EC 74 8B F4 56 83 EC 08 DD 1C 24 83 EC 08 DD 1C 24 9B DD 76 08 E8 ?? ?? ?? ?? 83 C4 14 DD 66 08 DD 06 83 C4 74 5E 85 C0 74 05 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_198_0_0 {
	meta:
		name = "_XMMI_FP_Emulation"
		size = 7706
		refs = "0089 $L21040 0090 $L21041 00d5 $L21042 0154 $L21043 018e __control87 01bd $L21044 01fc __statusfp 0234 _Fill_FPIEEE_RECORD 0282 _isnanf 02db _quietf 0512 _MIN_SINGLE_NORMALA 0527 __real@8@00000000000000000000 055b _NEGINFFA 056b _MAX_SINGLE_NORMALA 058d _POSINFFA 05be _TWO_TO_192A 0685 _TWO_TO_M192A 0778 $L21045 08b9 _ZEROFA 08d3 _NZEROFA 0b1b $L21046 0b24 _issnanf 0c30 $L21047 0d04 _isdenormalf 0d85 $L21048 0dbb $L21049 0dc2 $L21050 0df7 $L21051 11f0 $L21052 13e8 $L21053 146b $L21054 16e2 $L21055 1a3c $L21056 1cb6 $L20713 1cba $L20979 1cbe $L20942 1cc2 $L20809 1cc6 $L20869 1cca $L20899 1cce $L20912 1cea $L20718 1cf2 $L20719 1cfa $L20720 1d02 $L20721 1d0a $L20727 1d0e $L20728 1d12 $L20729 1d16 $L20730 1d1a $L20736 1d1e $L20737 1d22 $L20738 1d26 $L20739 1d2a $L20779 1d2e $L20780 1d32 $L20781 1d36 $L20782 1d3a $L20814 1d3e $L20819 1d5a $L20831 1d66 $L20832 1d7a $L20847 1d7e $L20846 1d9a $L20856 1d9e $L20855 1daa $L20864 1dae $L20865 1dca $L20904 1dce $L20905 1dd2 $L20906 1dd6 $L20907 1dda $L20917 1de2 $L20918 1dea $L20929 1dee $L20930 1df2 $L20931 1df6 $L20932 1dfa $L20947 1e02 $L20948 1e0a $L20984 1e0e $L20985 1e12 $L20986 1e16 $L20987"
	strings:
		$1 = { 55 8B EC 81 EC 9C 00 00 00 53 56 57 DB E3 C7 45 F0 00 00 00 00 C7 45 E4 00 00 00 00 8B 45 08 8B 48 1C 8B 55 08 8B 42 0C 83 E0 03 8B 09 83 E1 FC 0B C8 8B 55 08 8B 42 1C 89 08 8B 4D 08 8B 51 1C 8B 45 08 8B 48 10 83 E1 07 C1 E1 02 8B 12 83 E2 E3 0B D1 8B 45 08 8B 48 1C 89 11 8B 55 08 8B 42 1C 8B 08 C1 E9 05 81 E1 FF 0F 00 00 89 4D B8 8B 55 B8 83 EA 2B 89 55 B8 83 7D B8 17 0F 87 2D 1C 00 00 8B 4D B8 33 C0 8A 81 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 8B 55 08 8B 42 1C 8B 48 10 89 4D FC 8B 55 08 8B 42 1C 8B 48 28 89 4D EC 8B 55 08 8B 42 1C 8B 08 C1 E9 05 81 E1 FF 0F 00 00 89 4D B4 8B 55 B4 83 EA 2B 89 55 B4 83 7D B4 07 77 70 8B 45 B4 FF 24 85 ?? ?? ?? ?? 8B 4D 08 8B 51 1C 8B 02 25 1F 00 FE FF 0C 20 8B 4D 08 8B 51 1C 89 02 EB 4D 8B 45 08 8B 48 1C 8B 11 81 E2 1F 00 FE FF 83 CA 40 8B 45 08 8B 48 1C 89 11 EB 32 8B 55 08 8B 42 1C 8B 08 81 E1 1F 00 FE FF 83 C9 60 8B 55 08 8B 42 1C 89 08 EB 17 8B 4D 08 8B 51 1C 8B 02 25 1F 00 FE FF 0C 80 8B 4D 08 8B 51 1C 89 02 8B 45 08 8B 48 0C 89 4D B0 83 7D B0 03 77 2C 8B 55 B0 FF 24 95 ?? ?? ?? ?? C7 45 F4 00 00 00 00 EB 19 C7 45 F4 00 01 00 00 EB 10 C7 45 F4 00 02 00 00 EB 07 C7 45 F4 00 03 00 00 68 1F 03 0B 00 8B 45 F4 0D 00 00 02 00 0D 1F 00 08 00 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4D 08 8B 51 1C 8B 02 C1 E8 05 25 FF 0F 00 00 89 45 AC 8B 4D AC 83 E9 01 89 4D AC 83 7D AC 03 77 44 8B 55 AC FF 24 95 ?? ?? ?? ?? DB E2 D9 45 FC D9 45 EC DE C1 DD 5D D4 EB 2B DB E2 D9 45 FC D9 45 EC DE E9 DD 5D D4 EB 1C DB E2 D9 45 FC D9 45 EC DE C9 DD 5D D4 EB 0D DB E2 D9 45 FC D9 45 EC DE F9 DD 5D D4 E8 ?? ?? ?? ?? 89 45 CC 8B 45 CC 83 E0 08 85 C0 74 0C 8B 4D CC 81 E1 FF FF F7 FF 89 4D CC 8B 55 08 8B 02 83 E0 01 85 C0 75 58 8B 4D CC 83 E1 10 85 C9 74 4E 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 8B 45 08 8B 48 1C 8B 51 0C 83 CA 10 8B 45 08 8B 48 1C 89 51 0C 8B 55 08 8B 42 04 0C 01 8B 4D 08 89 41 04 8B 55 08 8B 42 1C 8B 48 04 83 C9 10 8B 55 08 8B 42 1C 89 48 04 B8 01 00 00 00 E9 32 1A 00 00 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 14 8B 55 EC 52 E8 ?? ?? ?? ?? 83 C4 04 85 C0 0F 84 FC 00 00 00 8B 45 08 8B 48 1C 8B 51 50 83 CA 01 8B 45 08 8B 48 1C 89 51 50 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 27 8B 45 EC 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 17 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 08 8B 42 1C D9 58 40 EB 12 DD 45 D4 D9 5D A8 D9 45 A8 8B 4D 08 8B 51 1C D9 5A 40 8B 45 08 8B 48 1C 8B 51 0C 83 E2 FD 8B 45 08 8B 48 1C 89 51 0C 8B 55 08 8B 42 1C 8B 48 0C 83 E1 FB 8B 55 08 8B 42 1C 89 48 0C 8B 4D 08 8B 51 1C 8B 42 0C 24 FE 8B 4D 08 8B 51 1C 89 42 0C 8B 45 08 8B 48 1C 8B 51 0C 83 E2 F7 8B 45 08 8B 48 1C 89 51 0C 8B 55 CC 83 E2 10 85 D2 74 25 8B 45 08 8B 48 1C 8B 51 0C 83 CA 10 8B 45 08 8B 48 1C 89 51 0C 8B 55 08 8B 42 04 0C 01 8B 4D 08 89 41 04 EB 15 8B 55 08 8B 42 1C 8B 48 0C 83 E1 EF 8B 55 08 8B 42 1C 89 48 0C 33 C0 E9 12 19 00 00 8B 4D 08 8B 11 83 E2 02 85 D2 75 30 8B 45 CC 25 00 00 08 00 85 C0 74 24 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 08 8B 42 04 0C 02 8B 4D 08 89 41 04 B8 01 00 00 00 E9 D6 18 00 00 8B 55 08 8B 02 83 E0 04 85 C0 75 58 8B 4D CC 83 E1 08 85 C9 74 4E 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 8B 45 08 8B 48 1C 8B 51 0C 83 CA 08 8B 45 08 8B 48 1C 89 51 0C 8B 55 08 8B 42 04 0C 04 8B 4D 08 89 41 04 8B 55 08 8B 42 1C 8B 48 04 83 C9 08 8B 55 08 8B 42 1C 89 48 04 B8 01 00 00 00 E9 72 18 00 00 DD 45 D4 D9 5D DC 8B 4D DC 51 E8 ?? ?? ?? ?? 83 C4 04 85 C0 0F 84 9D 00 00 00 8B 55 08 8B 42 1C 8B 48 50 83 C9 01 8B 55 08 8B 42 1C 89 48 50 8B 4D 08 8B 51 1C 8B 45 DC 89 42 40 8B 4D 08 8B 51 1C 8B 42 0C 24 FD 8B 4D 08 8B 51 1C 89 42 0C 8B 45 08 8B 48 1C 8B 51 0C 83 E2 FB 8B 45 08 8B 48 1C 89 51 0C 8B 55 08 8B 42 1C 8B 48 0C 83 E1 FE 8B 55 08 8B 42 1C 89 48 0C 8B 4D 08 8B 51 1C 8B 42 0C 24 F7 8B 4D 08 8B 51 1C 89 42 0C 8B 45 08 8B 48 1C 8B 51 0C 83 CA 10 8B 45 08 8B 48 1C 89 51 0C 8B 55 08 8B 42 04 0C 01 8B 4D 08 89 41 04 33 C0 E9 BB 17 00 00 8B 55 CC 81 E2 00 00 08 00 85 D2 74 0F 8B 45 08 8B 48 04 83 C9 02 8B 55 08 89 4A 04 DD 05 ?? ?? ?? ?? D9 E0 DC 5D D4 DF E0 F6 C4 01 74 10 DD 45 D4 DC 1D ?? ?? ?? ?? DF E0 F6 C4 01 75 20 DD 05 ?? ?? ?? ?? DC 5D D4 DF E0 F6 C4 01 74 17 DD 45 D4 DC 1D ?? ?? ?? ?? DF E0 F6 C4 01 74 07 C7 45 F0 01 00 00 00 D9 05 ?? ?? ?? ?? DC 5D D4 DF E0 F6 C4 01 74 12 DD 05 ?? ?? ?? ?? D9 E0 DC 5D D4 DF E0 F6 C4 41 74 20 DD 05 ?? ?? ?? ?? DC 5D D4 DF E0 F6 C4 01 74 17 D9 05 ?? ?? ?? ?? DC 5D D4 DF E0 F6 C4 41 75 07 C7 45 E4 01 00 00 00 8B 45 08 8B 08 83 E1 10 85 C9 0F 85 B7 00 00 00 83 7D F0 00 0F 84 AD 00 00 00 DD 05 ?? ?? ?? ?? DC 4D D4 DD 5D D4 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 8B 45 08 8B 48 1C 8B 51 0C 83 CA 02 8B 45 08 8B 48 1C 89 51 0C 8B 55 08 8B 42 04 0C 10 8B 4D 08 89 41 04 8B 55 08 8B 42 1C 8B 48 04 83 C9 02 8B 55 08 8B 42 1C 89 48 04 8B 4D 08 8B 51 1C 8B 42 50 0C 01 8B 4D 08 8B 51 1C 89 42 50 DD 45 D4 D9 5D A4 D9 45 A4 8B 45 08 8B 48 1C D9 59 40 8B 55 CC 83 E2 01 85 D2 74 23 8B 45 08 8B 48 1C 8B 51 0C 83 CA 01 8B 45 08 8B 48 1C 89 51 0C 8B 55 08 8B 42 04 0C 20 8B 4D 08 89 41 04 B8 01 00 00 00 E9 46 16 00 00 8B 55 08 8B 02 83 E0 08 85 C0 0F 85 B9 00 00 00 83 7D E4 00 0F 84 AF 00 00 00 DD 05 ?? ?? ?? ?? DC 4D D4 DD 5D D4 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 08 8B 42 1C 8B 48 0C 83 C9 04 8B 55 08 8B 42 1C 89 48 0C 8B 4D 08 8B 51 04 83 CA 08 8B 45 08 89 50 04 8B 4D 08 8B 51 1C 8B 42 04 0C 04 8B 4D 08 8B 51 1C 89 42 04 8B 45 08 8B 48 1C 8B 51 50 83 CA 01 8B 45 08 8B 48 1C 89 51 50 DD 45 D4 D9 5D A0 D9 45 A0 8B 55 08 8B 42 1C D9 58 40 8B 4D CC 83 E1 01 85 C9 74 24 8B 55 08 8B 42 1C 8B 48 0C 83 C9 01 8B 55 08 8B 42 1C 89 48 0C 8B 4D 08 8B 51 04 83 CA 20 8B 45 08 89 50 04 B8 01 00 00 00 E9 7D 15 00 00 68 1F 03 0B 00 8B 4D F4 81 C9 00 00 01 00 81 C9 1F 00 08 00 51 E8 ?? ?? ?? ?? 83 C4 08 8B 55 08 8B 42 1C 8B 08 C1 E9 05 81 E1 FF 0F 00 00 89 4D 9C 8B 55 9C 83 EA 01 89 55 9C 83 7D 9C 03 77 3C 8B 45 9C FF 24 85 ?? ?? ?? ?? D9 45 FC D9 45 EC DE C1 DD 5D C0 EB 25 D9 45 FC D9 45 EC DE E9 DD 5D C0 EB 18 D9 45 FC D9 45 EC DE C9 DD 5D C0 EB 0B D9 45 FC D9 45 EC DE F9 DD 5D C0 DD 45 C0 D9 5D DC E8 ?? ?? ?? ?? 89 45 CC 8B 4D 08 8B 11 83 E2 20 85 D2 0F 85 24 01 00 00 8B 45 CC 83 E0 01 85 C0 75 17 8B 4D 08 83 79 08 00 0F 84 0D 01 00 00 83 7D F0 00 0F 84 03 01 00 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 8B 45 08 8B 48 1C 8B 51 0C 83 CA 01 8B 45 08 8B 48 1C 89 51 0C 8B 55 08 8B 42 04 0C 20 8B 4D 08 89 41 04 8B 55 08 8B 42 1C 8B 48 04 83 C9 01 8B 55 08 8B 42 1C 89 48 04 8B 4D 08 8B 51 1C 8B 42 50 0C 01 8B 4D 08 8B 51 1C 89 42 50 83 7D F0 00 74 23 8B 45 08 8B 48 1C 8B 51 0C 83 CA 02 8B 45 08 8B 48 1C 89 51 0C 8B 55 08 8B 42 04 0C 10 8B 4D 08 89 41 04 83 7D E4 00 74 24 8B 55 08 8B 42 1C 8B 48 0C 83 C9 04 8B 55 08 8B 42 1C 89 48 0C 8B 4D 08 8B 51 04 83 CA 08 8B 45 08 89 50 04 8B 4D 08 83 79 08 00 74 39 83 7D F0 00 74 33 D9 45 DC DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 75 0B 8B 15 ?? ?? ?? ?? 89 55 DC EB 18 D9 45 DC DC 1D ?? ?? ?? ?? DF E0 F6 C4 01 74 08 A1 ?? ?? ?? ?? 89 45 DC 8B 4D 08 8B 51 1C 8B 45 DC 89 42 40 B8 01 00 00 00 E9 BF 13 00 00 8B 4D 08 8B 51 1C 8B 42 50 0C 01 8B 4D 08 8B 51 1C 89 42 50 8B 45 CC 83 E0 02 85 C0 74 25 8B 4D 08 8B 51 1C 8B 42 0C 0C 02 8B 4D 08 8B 51 1C 89 42 0C 8B 45 08 8B 48 04 83 C9 10 8B 55 08 89 4A 04 EB 15 8B 45 08 8B 48 1C 8B 51 0C 83 E2 FD 8B 45 08 8B 48 1C 89 51 0C 8B 55 CC 83 E2 04 85 D2 74 25 8B 45 08 8B 48 1C 8B 51 0C 83 CA 04 8B 45 08 8B 48 1C 89 51 0C 8B 55 08 8B 42 04 0C 08 8B 4D 08 89 41 04 EB 15 8B 55 08 8B 42 1C 8B 48 0C 83 E1 FB 8B 55 08 8B 42 1C 89 48 0C 8B 4D CC 83 E1 01 85 C9 74 26 8B 55 08 8B 42 1C 8B 48 0C 83 C9 01 8B 55 08 8B 42 1C 89 48 0C 8B 4D 08 8B 51 04 83 CA 20 8B 45 08 89 50 04 EB 14 8B 4D 08 8B 51 1C 8B 42 0C 24 FE 8B 4D 08 8B 51 1C 89 42 0C 8B 45 08 83 78 08 00 0F 84 81 00 00 00 83 7D F0 00 74 7B D9 45 DC DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 75 0B 8B 0D ?? ?? ?? ?? 89 4D DC EB 19 D9 45 DC DC 1D ?? ?? ?? ?? DF E0 F6 C4 01 74 09 8B 15 ?? ?? ?? ?? 89 55 DC 8B 45 08 8B 48 1C 8B 51 0C 83 CA 01 8B 45 08 8B 48 1C 89 51 0C 8B 55 08 8B 42 04 0C 20 8B 4D 08 89 41 04 8B 55 08 8B 42 1C 8B 48 0C 83 C9 02 8B 55 08 8B 42 1C 89 48 0C 8B 4D 08 8B 51 04 83 CA 10 8B 45 08 89 50 04 8B 4D 08 8B 51 1C 8B 45 DC 89 42 40 8B 4D CC 83 E1 08 85 C9 74 26 8B 55 08 8B 42 1C 8B 48 0C 83 C9 08 8B 55 08 8B 42 1C 89 48 0C 8B 4D 08 8B 51 04 83 CA 04 8B 45 08 89 50 04 EB 14 8B 4D 08 8B 51 1C 8B 42 0C 24 F7 8B 4D 08 8B 51 1C 89 42 0C 8B 45 08 8B 48 1C 8B 51 0C 83 E2 EF 8B 45 08 8B 48 1C 89 51 0C 33 C0 E9 E5 11 00 00 8B 55 08 8B 42 1C 8B 48 10 89 4D FC 8B 55 08 8B 42 1C 8B 48 28 89 4D EC 8B 55 08 8B 42 14 83 E0 07 89 45 BC 8B 4D 08 8B 51 1C 8B 02 25 1F 00 FE FF 0C E0 8B 4D 08 8B 51 1C 89 02 8B 45 BC 89 45 98 83 7D 98 07 0F 87 85 00 00 00 8B 4D 98 FF 24 8D ?? ?? ?? ?? 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 10 8B 45 EC 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 09 C7 45 F8 01 00 00 00 EB 07 C7 45 F8 00 00 00 00 E8 ?? ?? ?? ?? 89 45 CC 8B 4D CC 83 E1 10 85 C9 74 07 C7 45 F8 01 00 00 00 EB 30 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 10 8B 45 EC 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 09 C7 45 F8 01 00 00 00 EB 07 C7 45 F8 00 00 00 00 83 7D F8 00 74 5A 8B 4D 08 8B 11 83 E2 01 85 D2 75 4E 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 08 8B 51 1C 8B 42 0C 0C 10 8B 4D 08 8B 51 1C 89 42 0C 8B 45 08 8B 48 04 83 C9 01 8B 55 08 89 4A 04 8B 45 08 8B 48 1C 8B 51 04 83 CA 10 8B 45 08 8B 48 1C 89 51 04 B8 01 00 00 00 E9 B5 10 00 00 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 14 8B 45 EC 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 0F 84 E1 00 00 00 8B 4D BC 89 4D 94 83 7D 94 07 77 1A 8B 55 94 FF 24 95 ?? ?? ?? ?? C7 45 E0 00 00 00 00 EB 07 C7 45 E0 FF FF FF FF 8B 45 08 8B 48 1C 8B 51 50 83 CA 01 8B 45 08 8B 48 1C 89 51 50 8B 55 08 8B 42 1C 8B 4D E0 89 48 40 8B 55 08 8B 42 1C 8B 48 0C 83 E1 FE 8B 55 08 8B 42 1C 89 48 0C 8B 4D 08 8B 51 1C 8B 42 0C 24 FD 8B 4D 08 8B 51 1C 89 42 0C 8B 45 08 8B 48 1C 8B 51 0C 83 E2 FB 8B 45 08 8B 48 1C 89 51 0C 8B 55 08 8B 42 1C 8B 48 0C 83 E1 F7 8B 55 08 8B 42 1C 89 48 0C 83 7D F8 00 74 25 8B 4D 08 8B 51 1C 8B 42 0C 0C 10 8B 4D 08 8B 51 1C 89 42 0C 8B 45 08 8B 48 04 83 C9 01 8B 55 08 89 4A 04 EB 15 8B 45 08 8B 48 1C 8B 51 0C 83 E2 EF 8B 45 08 8B 48 1C 89 51 0C 33 C0 E9 B0 0F 00 00 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 10 8B 45 EC 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 18 C7 45 E8 01 00 00 00 8B 4D 08 8B 51 04 83 CA 02 8B 45 08 89 50 04 EB 07 C7 45 E8 00 00 00 00 83 7D E8 00 74 22 8B 4D 08 8B 11 83 E2 02 85 D2 75 16 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 B8 01 00 00 00 E9 49 0F 00 00 D9 45 FC D8 5D EC DF E0 F6 C4 01 74 28 8B 4D BC 89 4D 90 83 7D 90 07 77 1A 8B 55 90 FF 24 95 ?? ?? ?? ?? C7 45 E0 FF FF FF FF EB 07 C7 45 E0 00 00 00 00 EB 70 D9 45 FC D8 5D EC DF E0 F6 C4 41 75 30 8B 45 BC 89 45 8C 83 7D 8C 07 77 22 8B 55 8C 33 C9 8A 8A ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? C7 45 E0 FF FF FF FF EB 07 C7 45 E0 00 00 00 00 EB 33 D9 45 FC D8 5D EC DF E0 F6 C4 40 74 26 8B 45 BC 89 45 88 83 7D 88 07 77 1A 8B 4D 88 FF 24 8D ?? ?? ?? ?? C7 45 E0 FF FF FF FF EB 07 C7 45 E0 00 00 00 00 8B 55 08 8B 42 1C 8B 48 50 83 C9 01 8B 55 08 8B 42 1C 89 48 50 8B 4D 08 8B 51 1C 8B 45 E0 89 42 40 8B 4D 08 8B 51 1C 8B 42 0C 24 FE 8B 4D 08 8B 51 1C 89 42 0C 8B 45 08 8B 48 1C 8B 51 0C 83 E2 FD 8B 45 08 8B 48 1C 89 51 0C 8B 55 08 8B 42 1C 8B 48 0C 83 E1 FB 8B 55 08 8B 42 1C 89 48 0C 8B 4D 08 8B 51 1C 8B 42 0C 24 F7 8B 4D 08 8B 51 1C 89 42 0C 8B 45 08 8B 48 1C 8B 51 0C 83 E2 EF 8B 45 08 8B 48 1C 89 51 0C 33 C0 E9 15 0E 00 00 8B 55 08 8B 42 1C 8B 48 10 89 4D FC 8B 55 08 8B 42 1C 8B 48 28 89 4D EC 8B 55 08 8B 42 1C 8B 08 C1 E9 05 81 E1 FF 0F 00 00 89 4D 84 83 7D 84 3B 74 08 83 7D 84 3C 74 34 EB 7B 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 10 8B 45 EC 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 09 C7 45 F8 01 00 00 00 EB 07 C7 45 F8 00 00 00 00 EB 49 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 10 8B 55 EC 52 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 09 C7 45 F8 01 00 00 00 EB 07 C7 45 F8 00 00 00 00 E8 ?? ?? ?? ?? 89 45 CC 8B 45 CC 83 E0 10 85 C0 74 07 C7 45 F8 01 00 00 00 8B 4D 08 8B 51 1C 8B 02 25 1F 00 FE FF 0C E0 8B 4D 08 8B 51 1C 89 02 83 7D F8 00 74 5A 8B 45 08 8B 08 83 E1 01 85 C9 75 4E 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 8B 45 08 8B 48 1C 8B 51 0C 83 CA 10 8B 45 08 8B 48 1C 89 51 0C 8B 55 08 8B 42 04 0C 01 8B 4D 08 89 41 04 8B 55 08 8B 42 1C 8B 48 04 83 C9 10 8B 55 08 8B 42 1C 89 48 04 B8 01 00 00 00 E9 E9 0C 00 00 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 14 8B 55 EC 52 E8 ?? ?? ?? ?? 83 C4 04 85 C0 0F 84 AF 00 00 00 8B 45 08 8B 48 18 81 E1 6F F7 FF FF 83 C9 45 8B 55 08 89 4A 18 8B }
	condition:
		$1
}

rule file_198_1_0 {
	meta:
		name = "_issnanf"
		size = 57
	strings:
		$1 = { 55 8B EC 51 8D 45 08 89 45 FC 8B 4D FC 8B 11 81 E2 00 00 C0 7F 81 FA 00 00 80 7F 75 16 8B 45 FC 8B 08 81 E1 FF FF 3F 00 85 C9 74 07 B8 01 00 00 00 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_198_2_0 {
	meta:
		name = "_isnanf"
		size = 57
	strings:
		$1 = { 55 8B EC 51 8D 45 08 89 45 FC 8B 4D FC 8B 11 81 E2 00 00 80 7F 81 FA 00 00 80 7F 75 16 8B 45 FC 8B 08 81 E1 FF FF 7F 00 85 C9 74 07 B8 01 00 00 00 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_198_3_0 {
	meta:
		name = "_quietf"
		size = 33
	strings:
		$1 = { 55 8B EC 51 8D 45 08 89 45 FC 8B 4D FC 8B 11 81 CA 00 00 40 00 8B 45 FC 89 10 D9 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_198_4_0 {
	meta:
		name = "_isdenormalf"
		size = 53
	strings:
		$1 = { 55 8B EC 51 8D 45 08 89 45 FC 8B 4D FC 8B 11 81 E2 00 00 80 7F 85 D2 75 16 8B 45 FC 8B 08 81 E1 FF FF 7F 00 85 C9 74 07 B8 01 00 00 00 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_201_0_0 {
	meta:
		name = "___crtCompareStringW"
		size = 705
		refs = "0006 $T17278 000b __except_handler3 0011 __except_list 0028 _?f_use@?1??__crtCompareStringW@@9@9 0032 ??_C@_13A@?$AA?$AA?$AA?$AA@ 0043 __imp__CompareStringW@24 005a ??_C@_01A@?$AA?$AA@ 006b __imp__CompareStringA@24 0095 _wcsncnt 0136 ___lc_codepage 0158 __imp__WideCharToMultiByte@32 017c __alloca_probe"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 C4 DC 53 56 57 89 65 E8 83 3D ?? ?? ?? ?? 00 75 57 6A 01 68 ?? ?? ?? ?? 6A 01 68 ?? ?? ?? ?? 6A 00 6A 00 FF 15 ?? ?? ?? ?? 85 C0 74 0C C7 05 ?? ?? ?? ?? 01 00 00 00 EB 2F 6A 01 68 ?? ?? ?? ?? 6A 01 68 ?? ?? ?? ?? 6A 00 6A 00 FF 15 ?? ?? ?? ?? 85 C0 74 0C C7 05 ?? ?? ?? ?? 02 00 00 00 EB 07 33 C0 E9 27 02 00 00 83 7D 14 00 7E 13 8B 45 14 50 8B 4D 10 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 14 83 7D 1C 00 7E 13 8B 55 1C 52 8B 45 18 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 1C 83 7D 14 00 74 06 83 7D 1C 00 75 31 8B 4D 14 2B 4D 1C 85 C9 75 09 C7 45 D4 02 00 00 00 EB 16 8B 55 14 2B 55 1C 33 C0 85 D2 0F 9D C0 48 24 FE 83 C0 03 89 45 D4 8B 45 D4 E9 B8 01 00 00 83 3D ?? ?? ?? ?? 01 75 23 8B 4D 1C 51 8B 55 18 52 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 FF 15 ?? ?? ?? ?? E9 8C 01 00 00 83 3D ?? ?? ?? ?? 02 0F 85 7D 01 00 00 83 7D 20 00 75 09 8B 0D ?? ?? ?? ?? 89 4D 20 6A 00 6A 00 6A 00 6A 00 8B 55 14 52 8B 45 10 50 68 20 02 00 00 8B 4D 20 51 FF 15 ?? ?? ?? ?? 89 45 DC 83 7D DC 00 75 07 33 C0 E9 41 01 00 00 C7 45 FC 00 00 00 00 8B 45 DC 83 C0 03 24 FC E8 ?? ?? ?? ?? 89 65 D0 89 65 E8 8B 55 D0 89 55 E0 C7 45 FC FF FF FF FF EB 17 B8 01 00 00 00 C3 8B 65 E8 C7 45 E0 00 00 00 00 C7 45 FC FF FF FF FF 83 7D E0 00 75 07 33 C0 E9 F4 00 00 00 6A 00 6A 00 8B 45 DC 50 8B 4D E0 51 8B 55 14 52 8B 45 10 50 68 20 02 00 00 8B 4D 20 51 FF 15 ?? ?? ?? ?? 85 C0 75 07 33 C0 E9 C6 00 00 00 6A 00 6A 00 6A 00 6A 00 8B 55 1C 52 8B 45 18 50 68 20 02 00 00 8B 4D 20 51 FF 15 ?? ?? ?? ?? 89 45 D8 83 7D D8 00 75 07 33 C0 E9 97 00 00 00 C7 45 FC 01 00 00 00 8B 45 D8 83 C0 03 24 FC E8 ?? ?? ?? ?? 89 65 CC 89 65 E8 8B 55 CC 89 55 E4 C7 45 FC FF FF FF FF EB 17 B8 01 00 00 00 C3 8B 65 E8 C7 45 E4 00 00 00 00 C7 45 FC FF FF FF FF 83 7D E4 00 75 04 33 C0 EB 4D 6A 00 6A 00 8B 45 D8 50 8B 4D E4 51 8B 55 1C 52 8B 45 18 50 68 20 02 00 00 8B 4D 20 51 FF 15 ?? ?? ?? ?? 85 C0 75 04 33 C0 EB 22 8B 55 D8 52 8B 45 E4 50 8B 4D DC 51 8B 55 E0 52 8B 45 0C 50 8B 4D 08 51 FF 15 ?? ?? ?? ?? EB 02 33 C0 8D 65 C0 8B 4D F0 64 89 0D ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_201_1_0 {
	meta:
		name = "_wcsncnt"
		size = 86
	strings:
		$1 = { 55 8B EC 83 EC 08 8B 45 0C 89 45 F8 8B 4D 08 89 4D FC 8B 55 F8 8B 45 F8 83 E8 01 89 45 F8 85 D2 74 17 8B 4D FC 33 D2 66 8B 11 85 D2 74 0B 8B 45 FC 83 C0 02 89 45 FC EB D9 8B 4D FC 33 D2 66 8B 11 85 D2 75 0A 8B 45 FC 2B 45 08 D1 F8 EB 03 8B 45 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_202_0_0 {
	meta:
		name = "__freebuf"
		size = 146
		refs = "000d ??_C@_0P@FHEA@stream?5?$CB?$DN?5NULL?$AA@ 0016 ??_C@_0L@JIE@_freebuf?4c?$AA@ 001d __CrtDbgReport 0057 __free_dbg"
	strings:
		$1 = { 55 8B EC 53 56 57 83 7D 08 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 30 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D6 8B 4D 08 8B 51 0C 81 E2 83 00 00 00 85 D2 74 4D 8B 45 08 8B 48 0C 83 E1 08 85 C9 74 40 6A 02 8B 55 08 8B 42 08 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4D 08 8B 51 0C 81 E2 F7 FB FF FF 8B 45 08 89 50 0C 8B 4D 08 C7 01 00 00 00 00 8B 55 08 C7 42 08 00 00 00 00 8B 45 08 C7 40 04 00 00 00 00 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_203_0_0 {
	meta:
		name = "__dup"
		size = 285
		refs = "000b __nhandle 0020 ___pioinfo 0032 _errno 003c __doserrno 0067 __alloc_osfhnd 009c __imp__GetCurrentProcess@0 00a6 __get_osfhandle 00b7 __imp__DuplicateHandle@28 00c1 __imp__GetLastError@0 00d3 __set_osfhnd 00ec __dosmaperr"
	strings:
		$1 = { 55 8B EC 83 EC 10 8B 45 08 3B 05 ?? ?? ?? ?? 73 1F 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F 8B 04 8D ?? ?? ?? ?? 0F BE 4C D0 04 83 E1 01 85 C9 75 1C C7 05 ?? ?? ?? ?? 09 00 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 83 C8 FF E9 CD 00 00 00 8B 55 08 C1 FA 05 8B 45 08 83 E0 1F 8B 0C 95 ?? ?? ?? ?? 8A 54 C1 04 88 55 F0 E8 ?? ?? ?? ?? 89 45 FC 83 7D FC FF 75 1C C7 05 ?? ?? ?? ?? 18 00 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 83 C8 FF E9 89 00 00 00 6A 02 6A 01 6A 00 8D 45 F4 50 FF 15 ?? ?? ?? ?? 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 50 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 75 0B FF 15 ?? ?? ?? ?? 89 45 F8 EB 17 8B 55 F4 52 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 C7 45 F8 00 00 00 00 83 7D F8 00 74 11 8B 4D F8 51 E8 ?? ?? ?? ?? 83 C4 04 83 C8 FF EB 21 0F BE 55 F0 83 E2 EF 8B 45 FC C1 F8 05 8B 4D FC 83 E1 1F 8B 04 85 ?? ?? ?? ?? 88 54 C8 04 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_204_0_0 {
	meta:
		name = "__cscanf"
		size = 81
		refs = "0014 ??_C@_0P@LNLA@format?5?$CB?$DN?5NULL?$AA@ 0020 ??_C@_07IEFA@input?4c?$AA@ 0027 __CrtDbgReport 0043 _input"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8D 45 0C 89 45 FC 83 7D 08 00 75 21 68 ?? ?? ?? ?? 6A 00 68 83 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D3 8B 55 FC 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_204_1_0 {
	meta:
		name = "_input"
		size = 4755
		refs = "0013 ??_C@_0P@LNLA@format?5?$CB?$DN?5NULL?$AA@ 001f ??_C@_07IEFA@input?4c?$AA@ 0026 __CrtDbgReport 005b ___mb_cur_max 006d __isctype 0084 __pctype 00ae __whiteout 00b7 __ungetch 00d0 _isspace 01ff $L1922 0206 $L1923 0333 __inc 037f $L1924 0386 $L1925 03c1 _cbrackset 03e6 _sbrackset 0446 _memset 06ef _mbtowc 0955 __allshl 0967 __hextodec 0de9 ___decimal_point 1072 __cfltcvt_tab 11e4 $L1663 11e8 $L1655 11ec $L1657 11f0 $L1660 11f4 $L1656 11f8 $L1661 11fc $L1662 1200 $DEFAULT_LABEL$1659 1252 $L1686 1256 $L1760 125a $L1828 125e $L1742 1262 $L1826 1266 $L1759 126a $L1690 126e $L1743 1272 $L1692 1276 $L1862"
	strings:
		$1 = { 55 8B EC 81 EC 20 02 00 00 53 56 57 83 7D 08 00 75 21 68 ?? ?? ?? ?? 6A 00 68 09 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D3 C6 45 D8 00 0F BE 4D D8 89 4D E0 8B 55 E0 89 55 CC 8B 45 08 33 C9 8A 08 85 C9 0F 84 81 11 00 00 83 3D ?? ?? ?? ?? 01 7E 1A 6A 08 8B 55 08 33 C0 8A 02 50 E8 ?? ?? ?? ?? 83 C4 08 89 85 08 FE FF FF EB 1B 8B 4D 08 33 D2 8A 11 A1 ?? ?? ?? ?? 33 C9 66 8B 0C 50 83 E1 08 89 8D 08 FE FF FF 83 BD 08 FE FF FF 00 74 3D 8B 55 E0 83 EA 01 89 55 E0 8D 45 E0 50 E8 ?? ?? ?? ?? 83 C4 04 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 08 83 C1 01 89 4D 08 8B 55 08 33 C0 8A 02 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 02 EB E1 8B 4D 08 33 D2 8A 11 83 FA 25 0F 85 0F 10 00 00 C7 45 C0 00 00 00 00 C6 45 F8 00 C7 45 94 00 00 00 00 8B 45 94 89 85 18 FE FF FF 8B 8D 18 FE FF FF 89 4D E4 C6 45 F0 00 8A 55 F0 88 55 98 8A 45 98 88 45 90 8A 4D 90 88 4D E8 8A 55 E8 88 55 9C C6 45 EC 00 C6 45 C8 01 C7 85 24 FE FF FF 00 00 00 00 0F BE 45 E8 85 C0 0F 85 51 01 00 00 8B 4D 08 83 C1 01 89 4D 08 8B 55 08 33 C0 8A 02 89 45 F4 83 3D ?? ?? ?? ?? 01 7E 1C 6A 04 8B 4D F4 81 E1 FF 00 00 00 51 E8 ?? ?? ?? ?? 83 C4 08 89 85 04 FE FF FF EB 1D 8B 55 F4 81 E2 FF 00 00 00 A1 ?? ?? ?? ?? 33 C9 66 8B 0C 50 83 E1 04 89 8D 04 FE FF FF 83 BD 04 FE FF FF 00 74 27 8B 95 18 FE FF FF 83 C2 01 89 95 18 FE FF FF 8B 45 E4 8B 4D E4 8D 14 81 8B 45 F4 8D 4C 50 D0 89 4D E4 E9 C7 00 00 00 8B 55 F4 89 95 00 FE FF FF 8B 85 00 FE FF FF 83 E8 2A 89 85 00 FE FF FF 83 BD 00 FE FF FF 4D 0F 87 9A 00 00 00 8B 95 00 FE FF FF 33 C9 8A 8A ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? E9 88 00 00 00 8A 45 C8 2C 01 88 45 C8 8A 4D EC 80 E9 01 88 4D EC EB 75 8B 55 08 33 C0 8A 42 01 83 F8 36 75 35 8B 4D 08 33 D2 8A 51 02 83 FA 34 75 28 8B 45 08 83 C0 02 89 45 08 8B 8D 24 FE FF FF 83 C1 01 89 8D 24 FE FF FF C7 45 D0 00 00 00 00 C7 45 D4 00 00 00 00 EB 33 EB 29 8A 55 C8 80 C2 01 88 55 C8 EB 26 8A 45 C8 04 01 88 45 C8 8A 4D EC 80 C1 01 88 4D EC EB 13 8A 55 90 80 C2 01 88 55 90 EB 08 8A 45 E8 04 01 88 45 E8 E9 A3 FE FF FF 0F BE 4D 90 85 C9 75 1B 8B 55 0C 89 95 2C FE FF FF 8B 45 0C 83 C0 04 89 45 0C 8B 4D 0C 8B 51 FC 89 55 C4 C6 45 E8 00 0F BE 45 EC 85 C0 75 2B 8B 4D 08 33 D2 8A 11 83 FA 53 74 0C 8B 45 08 33 C9 8A 08 83 F9 43 75 0B 8A 55 EC 80 C2 01 88 55 EC EB 08 8A 45 EC 2C 01 88 45 EC 8B 4D 08 33 D2 8A 11 83 CA 20 89 55 F4 83 7D F4 6E 74 34 83 7D F4 63 74 1A 83 7D F4 7B 74 14 8D 45 E0 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 28 FE FF FF EB 14 8B 4D E0 83 C1 01 89 4D E0 E8 ?? ?? ?? ?? 89 85 28 FE FF FF 83 BD 18 FE FF FF 00 74 0A 83 7D E4 00 0F 84 81 0D 00 00 8B 55 F4 89 95 FC FD FF FF 8B 85 FC FD FF FF 83 E8 63 89 85 FC FD FF FF 83 BD FC FD FF FF 18 0F 87 0D 0D 00 00 8B 95 FC FD FF FF 33 C9 8A 8A ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? 83 BD 18 FE FF FF 00 75 18 8B 85 18 FE FF FF 83 C0 01 89 85 18 FE FF FF 8B 4D E4 83 C1 01 89 4D E4 0F BE 55 EC 85 D2 7E 08 8A 45 9C 04 01 88 45 9C C7 85 20 FE FF FF ?? ?? ?? ?? 8A 4D F0 80 E9 01 88 4D F0 EB 6D 0F BE 55 EC 85 D2 7E 08 8A 45 9C 04 01 88 45 9C C7 85 20 FE FF FF ?? ?? ?? ?? 8A 4D F0 80 E9 01 88 4D F0 EB 48 0F BE 55 EC 85 D2 7E 08 8A 45 9C 04 01 88 45 9C 8B 4D 08 83 C1 01 89 4D 08 8B 55 08 89 95 20 FE FF FF 8B 85 20 FE FF FF 33 C9 8A 08 83 F9 5E 75 17 8B 95 20 FE FF FF 83 C2 01 89 95 20 FE FF FF 8A 45 F0 2C 01 88 45 F0 6A 20 6A 00 8D 4D A0 51 E8 ?? ?? ?? ?? 83 C4 0C 83 7D F4 7B 75 26 8B 95 20 FE FF FF 33 C0 8A 02 83 F8 5D 75 17 C6 45 F8 5D 8B 8D 20 FE FF FF 83 C1 01 89 8D 20 FE FF FF C6 45 AB 20 8B 95 20 FE FF FF 33 C0 8A 02 83 F8 5D 0F 84 59 01 00 00 8B 8D 20 FE FF FF 8A 11 88 95 14 FE FF FF 8B 85 20 FE FF FF 83 C0 01 89 85 20 FE FF FF 8B 8D 14 FE FF FF 81 E1 FF 00 00 00 83 F9 2D 75 1C 8B 55 F8 81 E2 FF 00 00 00 85 D2 74 0F 8B 85 20 FE FF FF 33 C9 8A 08 83 F9 5D 75 45 8A 95 14 FE FF FF 88 55 F8 8B 45 F8 25 FF 00 00 00 C1 F8 03 8B 8D 14 FE FF FF 81 E1 FF 00 00 00 83 E1 07 BA 01 00 00 00 D3 E2 8A 44 05 A0 0A C2 8B 4D F8 81 E1 FF 00 00 00 C1 F9 03 88 44 0D A0 E9 C5 00 00 00 8B 95 20 FE FF FF 8A 02 88 85 14 FE FF FF 8B 8D 20 FE FF FF 83 C1 01 89 8D 20 FE FF FF 8B 55 F8 81 E2 FF 00 00 00 8B 85 14 FE FF FF 25 FF 00 00 00 3B D0 7D 0B 8A 8D 14 FE FF FF 88 4D DC EB 0F 8A 55 F8 88 55 DC 8A 85 14 FE FF FF 88 45 F8 8A 4D F8 88 8D 14 FE FF FF EB 0F 8A 95 14 FE FF FF 80 C2 01 88 95 14 FE FF FF 8B 85 14 FE FF FF 25 FF 00 00 00 8B 4D DC 81 E1 FF 00 00 00 3B C1 7F 40 8B 95 14 FE FF FF 81 E2 FF 00 00 00 C1 FA 03 8B 8D 14 FE FF FF 81 E1 FF 00 00 00 83 E1 07 B8 01 00 00 00 D3 E0 8A 4C 15 A0 0A C8 8B 95 14 FE FF FF 81 E2 FF 00 00 00 C1 FA 03 88 4C 15 A0 EB 99 C6 45 F8 00 E9 94 FE FF FF 8B 85 20 FE FF FF 33 C9 8A 08 85 C9 75 05 E9 E2 0B 00 00 83 7D F4 7B 75 09 8B 95 20 FE FF FF 89 55 08 8B 45 C4 89 85 1C FE FF FF 8B 4D E0 83 E9 01 89 4D E0 8B 95 28 FE FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 83 BD 18 FE FF FF 00 74 14 8B 45 E4 8B 4D E4 83 E9 01 89 4D E4 85 C0 0F 84 0C 01 00 00 8B 55 E0 83 C2 01 89 55 E0 E8 ?? ?? ?? ?? 89 85 28 FE FF FF 8B 85 28 FE FF FF C1 F8 03 0F BE 54 05 A0 0F BE 45 F0 33 D0 8B 8D 28 FE FF FF 83 E1 07 B8 01 00 00 00 D3 E0 23 D0 85 D2 0F 84 AB 00 00 00 0F BE 4D 90 85 C9 0F 85 8E 00 00 00 0F BE 55 9C 85 D2 74 70 8A 85 28 FE FF FF 88 85 10 FE FF FF 8B 8D 28 FE FF FF 81 E1 FF 00 00 00 8B 15 ?? ?? ?? ?? 33 C0 66 8B 04 4A 25 00 80 00 00 85 C0 74 14 8B 4D E0 83 C1 01 89 4D E0 E8 ?? ?? ?? ?? 88 85 11 FE FF FF 8B 15 ?? ?? ?? ?? 52 8D 85 10 FE FF FF 50 8D 4D FC 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 C4 66 8B 45 FC 66 89 02 8B 4D C4 83 C1 02 89 4D C4 EB 14 8B 55 C4 8A 85 28 FE FF FF 88 02 8B 4D C4 83 C1 01 89 4D C4 EB 0F 8B 95 1C FE FF FF 83 C2 01 89 95 1C FE FF FF EB 1A 8B 45 E0 83 E8 01 89 45 E0 8B 8D 28 FE FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 EB 05 E9 D7 FE FF FF 8B 95 1C FE FF FF 3B 55 C4 74 31 0F BE 45 90 85 C0 75 27 8B 4D CC 83 C1 01 89 4D CC 83 7D F4 63 74 18 0F BE 55 9C 85 D2 74 0A 8B 45 C4 66 C7 00 00 00 EB 06 8B 4D C4 C6 01 00 EB 05 E9 48 0A 00 00 E9 30 09 00 00 C7 45 F4 64 00 00 00 83 BD 28 FE FF FF 2D 75 0B 8A 55 98 80 C2 01 88 55 98 EB 09 83 BD 28 FE FF FF 2B 75 37 8B 45 E4 83 E8 01 89 45 E4 83 7D E4 00 75 14 83 BD 18 FE FF FF 00 74 0B 8A 4D E8 80 C1 01 88 4D E8 EB 14 8B 55 E0 83 C2 01 89 55 E0 E8 ?? ?? ?? ?? 89 85 28 FE FF FF 83 BD 28 FE FF FF 30 0F 85 83 00 00 00 8B 45 E0 83 C0 01 89 45 E0 E8 ?? ?? ?? ?? 89 85 28 FE FF FF 0F BE 8D 28 FE FF FF 83 F9 78 74 0C 0F BE 95 28 FE FF FF 83 FA 58 75 1D 8B 45 E0 83 C0 01 89 45 E0 E8 ?? ?? ?? ?? 89 85 28 FE FF FF C7 45 F4 78 00 00 00 EB 3A 8B 4D 94 83 C1 01 89 4D 94 83 7D F4 78 74 09 C7 45 F4 6F 00 00 00 EB 22 8B 55 E0 83 EA 01 89 55 E0 8B 85 28 FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 C7 85 28 FE FF FF 30 00 00 00 EB 57 C6 45 C8 01 83 BD 28 FE FF FF 2D 75 0B 8A 4D 98 80 C1 01 88 4D 98 EB 09 83 BD 28 FE FF FF 2B 75 36 8B 55 E4 83 EA 01 89 55 E4 83 7D E4 00 75 13 83 BD 18 FE FF FF 00 74 0A 8A 45 E8 04 01 88 45 E8 EB 14 8B 4D E0 83 C1 01 89 4D E0 E8 ?? ?? ?? ?? 89 85 28 FE FF FF 83 BD 24 FE FF FF 00 0F 84 E6 01 00 00 0F BE 55 E8 85 D2 0F 85 BA 01 00 00 83 7D F4 78 0F 85 86 00 00 00 83 3D ?? ?? ?? ?? 01 7E 1C 68 80 00 00 00 8B 85 28 FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 08 89 85 F8 FD FF FF EB 1D 8B 8D 28 FE FF FF 8B 15 ?? ?? ?? ?? 33 C0 66 8B 04 4A 25 80 00 00 00 89 85 F8 FD FF FF 83 BD F8 FD FF FF 00 74 2D B9 04 00 00 00 8B 45 D0 8B 55 D4 E8 ?? ?? ?? ?? 89 45 D0 89 55 D4 8B 8D 28 FE FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 89 85 28 FE FF FF EB 09 8A 55 E8 80 C2 01 88 55 E8 E9 A9 00 00 00 83 3D ?? ?? ?? ?? 01 7E 19 6A 04 8B 85 28 FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 08 89 85 F4 FD FF FF EB 1B 8B 8D 28 FE FF FF 8B 15 ?? ?? ?? ?? 33 C0 66 8B 04 4A 83 E0 04 89 85 F4 FD FF FF 83 BD F4 FD FF FF 00 74 5A 83 7D F4 6F 75 2C 83 BD 28 FE FF FF 38 7D 18 B9 03 00 00 00 8B 45 D0 8B 55 D4 E8 ?? ?? ?? ?? 89 45 D0 89 55 D4 EB 09 8A 4D E8 80 C1 01 88 4D E8 EB 26 B9 02 00 00 00 8B 45 D0 8B 55 D4 E8 ?? ?? ?? ?? 03 45 D0 13 55 D4 B9 01 00 00 00 E8 ?? ?? ?? ?? 89 45 D0 89 55 D4 EB 09 8A 55 E8 80 C2 01 88 55 E8 0F BE 45 E8 85 C0 75 5C 8B 4D 94 83 C1 01 89 4D 94 8B 85 28 FE FF FF 83 E8 30 99 8B 4D D0 03 C8 8B 45 D4 13 C2 89 4D D0 89 45 D4 83 BD 18 FE FF FF 00 74 1A 8B 4D E4 83 E9 01 89 4D E4 83 7D E4 00 75 0B 8A 55 E8 80 C2 01 88 55 E8 EB 14 8B 45 E0 83 C0 01 89 45 E0 E8 ?? ?? ?? ?? 89 85 28 FE FF FF EB 18 8B 4D E0 83 E9 01 89 4D E0 8B 95 28 FE FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 E9 3A FE FF FF 0F BE 45 98 85 C0 74 13 8B 4D D0 F7 D9 8B 55 D4 83 D2 00 F7 DA 89 4D D0 89 55 D4 E9 9B 01 00 00 0F BE 45 E8 85 C0 0F 85 7F 01 00 00 83 7D F4 78 74 06 83 7D F4 70 75 79 83 3D ?? ?? ?? ?? 01 7E 1C 68 80 00 00 00 8B 8D 28 FE FF FF 51 E8 ?? ?? ?? ?? 83 C4 08 89 85 F0 FD FF FF EB 1D 8B 95 28 FE FF FF A1 ?? ?? ?? ?? 33 C9 66 8B 0C 50 81 E1 80 00 00 00 89 8D F0 FD FF FF 83 BD F0 FD FF FF 00 74 20 8B 55 C0 C1 E2 04 89 55 C0 8B 85 28 FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 28 FE FF FF EB 09 8A 4D E8 80 C1 01 88 4D E8 E9 84 00 00 00 83 3D ?? ?? ?? ?? 01 7E 19 6A 04 8B 95 28 FE FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 89 85 EC FD FF FF EB 1B 8B 85 28 FE FF FF 8B 0D ?? ?? ?? ?? 33 D2 66 8B 14 41 83 E2 04 89 95 EC FD FF FF 83 BD EC FD FF FF 00 74 35 83 7D F4 6F 75 1F 83 BD 28 FE FF FF 38 7D 0B 8B 45 C0 C1 E0 03 89 45 C0 EB 09 8A 4D E8 80 C1 01 88 4D E8 EB 0E 8B 55 C0 8B 45 C0 8D 0C 90 D1 E1 89 4D C0 EB 09 8A 55 E8 80 C2 01 88 55 E8 0F BE 45 E8 85 C0 75 51 8B 4D 94 83 C1 01 89 4D 94 8B 95 28 FE FF FF 8B 45 C0 8D 4C 10 D0 89 4D C0 83 BD 18 FE FF FF 00 74 19 8B 55 E4 83 EA 01 89 55 E4 83 7D E4 00 75 0A 8A 45 E8 04 01 88 45 E8 EB 14 8B 4D E0 83 C1 01 89 4D E0 E8 ?? ?? ?? ?? 89 85 28 FE FF FF EB 18 8B 55 E0 83 EA 01 89 55 E0 8B 85 28 FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 E9 75 FE FF FF 0F BE 4D 98 85 C9 74 08 8B 55 C0 F7 DA 89 55 C0 83 7D F4 46 75 07 C7 45 94 00 00 00 00 83 7D 94 00 74 48 0F BE 45 90 85 C0 75 3E 8B 4D CC 83 C1 01 89 4D CC 83 BD 24 FE FF FF 00 74 10 8B 55 C4 8B 45 D0 89 02 8B 4D D4 89 4A 04 EB 1C 0F BE 55 C8 85 D2 74 0A 8B 45 C4 8B 4D C0 89 08 EB 0A 8B 55 C4 66 8B 45 C0 66 89 02 EB 05 E9 11 05 00 00 E9 F9 03 00 00 8B 4D E0 89 4D C0 0F BE 55 90 85 D2 75 02 EB AF E9 E4 03 00 00 8D 85 30 FE FF FF 89 85 20 FE FF FF 83 BD 28 FE FF FF 2D 75 1A 8B 8D 20 FE FF FF C6 01 2D 8B 95 20 FE FF FF 83 C2 01 89 95 20 FE FF FF EB 09 83 BD 28 FE FF FF 2B 75 1D 8B 45 E4 83 E8 01 89 45 E4 8B 4D E0 83 C1 01 89 4D E0 E8 ?? ?? ?? ?? 89 85 28 FE FF FF 83 BD 18 FE FF FF 00 74 09 81 7D E4 5D 01 00 00 7E 07 C7 45 E4 5D 01 00 00 83 3D ?? ?? ?? ?? 01 7E 19 6A 04 8B 95 28 FE FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 89 85 E8 FD FF FF EB 1B 8B 85 28 FE FF FF 8B 0D ?? ?? ?? ?? 33 D2 66 8B 14 41 83 E2 04 89 95 E8 FD FF FF 83 BD E8 FD FF FF 00 74 4F 8B 45 E4 8B 4D E4 83 E9 01 89 4D E4 85 C0 74 3F 8B 55 94 83 C2 01 89 55 94 8B 85 20 FE FF FF 8A 8D 28 FE FF FF 88 08 8B 95 20 FE FF FF 83 C2 01 89 95 20 FE FF FF 8B 45 E0 83 C0 01 89 45 E0 E8 ?? ?? ?? ?? 89 85 28 FE FF FF E9 6B FF FF FF 0F BE 0D ?? ?? ?? ?? 0F BE 95 28 FE FF FF 3B CA 0F 85 DA 00 00 00 8B 45 E4 8B 4D E4 83 E9 01 89 4D E4 85 C0 0F 84 C6 00 00 00 8B 55 E0 83 C2 01 89 55 E0 E8 ?? ?? ?? ?? 89 85 28 FE FF FF 8B 85 20 FE FF FF 8A 0D ?? ?? ?? ?? 88 08 8B 95 20 FE FF FF 83 C2 01 89 95 20 FE FF FF 83 3D ?? ?? ?? ?? 01 7E 19 6A 04 8B 85 28 FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 08 89 85 E4 FD FF FF EB 1B 8B 8D 28 FE FF FF 8B 15 ?? ?? ?? ?? 33 C0 66 8B 04 4A 83 E0 04 89 85 E4 FD FF FF 83 BD E4 FD FF FF 00 74 4F 8B 4D E4 8B 55 E4 83 EA 01 89 55 E4 85 C9 74 3F 8B 45 94 83 C0 01 89 45 94 8B 8D 20 FE FF FF 8A 95 28 FE FF FF 88 11 8B 85 20 FE FF FF 83 C0 01 89 85 20 FE FF FF 8B 4D E0 83 C1 01 89 4D E0 E8 ?? ?? ?? ?? 89 85 28 FE FF FF E9 6B FF FF FF 83 7D 94 00 0F 84 45 01 00 00 83 BD 28 FE FF FF 65 74 0D 83 BD 28 FE FF FF 45 0F 85 2F 01 00 00 8B 55 E4 8B 45 E4 83 E8 01 89 45 E4 85 D2 0F 84 1B 01 00 00 8B 8D 20 FE FF FF C6 01 65 8B 95 20 FE FF FF 83 C2 01 89 95 20 FE FF FF 8B 45 E0 83 C0 01 89 45 E0 E8 ?? ?? ?? ?? 89 85 28 FE FF FF 83 BD 28 FE FF FF 2D 75 1A 8B 8D 20 FE FF FF C6 01 2D 8B 95 20 FE FF FF 83 C2 01 89 95 20 FE FF FF EB 09 83 BD 28 FE FF FF 2B 75 2F 8B 45 E4 8B 4D E4 83 E9 01 89 4D E4 85 C0 75 0B 8B 55 E4 83 C2 01 89 55 E4 EB 14 8B 45 E0 83 C0 01 89 45 E0 E8 ?? ?? ?? ?? 89 85 28 FE FF FF 83 3D ?? ?? ?? ?? 01 7E 19 6A 04 8B 8D 28 FE FF FF 51 E8 ?? ?? ?? ?? 83 C4 08 89 85 E0 FD FF FF EB 1A 8B 95 28 FE FF FF A1 ?? ?? ?? ?? 33 C9 66 8B 0C 50 83 E1 04 89 8D E0 FD FF FF 83 BD E0 FD FF FF 00 74 4F 8B 55 E4 8B 45 E4 83 E8 01 89 45 E4 85 D2 74 3F 8B 4D 94 83 C1 01 89 4D 94 8B 95 20 FE FF FF 8A 85 28 FE FF FF 88 02 8B 8D 20 }
	condition:
		$1
}

rule file_204_2_0 {
	meta:
		name = "__hextodec"
		size = 88
		refs = "0008 ___mb_cur_max 0016 __isctype 0027 __pctype"
	strings:
		$1 = { 55 8B EC 83 EC 08 83 3D ?? ?? ?? ?? 01 7E 13 6A 04 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC EB 15 8B 4D 08 8B 15 ?? ?? ?? ?? 33 C0 66 8B 04 4A 83 E0 04 89 45 FC 83 7D FC 00 74 08 8B 4D 08 89 4D F8 EB 0C 8B 55 08 83 E2 DF 83 EA 07 89 55 F8 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_204_4_0 {
	meta:
		name = "__whiteout"
		size = 50
		refs = "0012 __inc 001e _isspace"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 8B 08 83 C1 01 8B 55 08 89 0A E8 ?? ?? ?? ?? 89 45 FC 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 02 EB D9 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_205_0_0 {
	meta:
		name = "__execv"
		size = 251
		refs = "000d ??_C@_0BB@COCE@filename?5?$CB?$DN?5NULL?$AA@ 0016 ??_C@_07GBGM@execv?4c?$AA@ 001d __CrtDbgReport 003b ??_C@_0BG@GALO@?$CKfilename?5?$CB?$DN?5_T?$CI?8?20?8?$CJ?$AA@ 0065 ??_C@_0BC@DJDH@argvector?5?$CB?$DN?5NULL?$AA@ 0091 ??_C@_0BD@DPK@?$CKargvector?5?$CB?$DN?5NULL?$AA@ 00c1 ??_C@_0BI@GGEG@?$CK?$CKargvector?5?$CB?$DN?5_T?$CI?8?20?8?$CJ?$AA@ 00ef __execve"
	strings:
		$1 = { 55 8B EC 53 56 57 83 7D 08 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 29 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D6 8B 4D 08 0F BE 11 85 D2 75 1E 68 ?? ?? ?? ?? 6A 00 6A 2A 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D2 83 7D 0C 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 2B 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D6 8B 55 0C 83 3A 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 2C 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D4 8B 4D 0C 8B 11 0F BE 02 85 C0 75 1E 68 ?? ?? ?? ?? 6A 00 6A 2D 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D0 6A 00 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_206_0_0 {
	meta:
		name = "__CRT_INIT@12"
		size = 269
		refs = "000f __imp__GetVersion@0 0014 __osver 001b __heap_init 003b __winminor 004d __winmajor 0062 __winver 007a __imp__GetCommandLineA@0 007f __acmdln 0084 ___crtGetEnvironmentStringsA 0089 __aenvptr 008e __ioinit 0093 __setargv 0098 __setenvp 009d __cinit 00a3 ___proc_attached 00d2 __C_Termination_Done 00da __cexit 00e1 __CrtSetDbgFlag 00f0 __CrtDumpMemoryLeaks 00f5 __ioterm 00fa __heap_term"
	strings:
		$1 = { 55 8B EC 83 7D 0C 01 0F 85 A5 00 00 00 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? 6A 00 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 07 33 C0 E9 DC 00 00 00 A1 ?? ?? ?? ?? C1 E8 08 25 FF 00 00 00 A3 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 81 E1 FF 00 00 00 89 0D ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? C1 E2 08 03 15 ?? ?? ?? ?? 89 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? C1 E8 10 25 FF FF 00 00 A3 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 83 C1 01 89 0D ?? ?? ?? ?? EB 52 83 7D 0C 00 75 4C 83 3D ?? ?? ?? ?? 00 7E 3F 8B 15 ?? ?? ?? ?? 83 EA 01 89 15 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 75 05 E8 ?? ?? ?? ?? 6A FF E8 ?? ?? ?? ?? 83 C4 04 83 E0 20 85 C0 74 05 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 04 33 C0 EB 05 B8 01 00 00 00 5D C2 0C 00 }
	condition:
		$1
}

rule file_206_1_0 {
	meta:
		name = "__DllMainCRTStartup@12"
		size = 243
		refs = "0013 ___proc_attached 002f __pRawDllMain 005e __CRT_INIT@12 007c _DllMain@12"
	strings:
		$1 = { 55 8B EC 51 C7 45 FC 01 00 00 00 83 7D 0C 00 75 10 83 3D ?? ?? ?? ?? 00 75 07 33 C0 E9 CC 00 00 00 83 7D 0C 01 74 06 83 7D 0C 02 75 42 83 3D ?? ?? ?? ?? 00 74 15 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 FF 15 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 74 14 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 75 04 33 C0 EB 7E 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 89 45 FC 83 7D 0C 01 75 15 83 7D FC 00 75 0F 8B 45 10 50 6A 00 8B 4D 08 51 E8 ?? ?? ?? ?? 83 7D 0C 00 74 06 83 7D 0C 03 75 40 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 85 C0 75 07 C7 45 FC 00 00 00 00 83 7D FC 00 74 1E 83 3D ?? ?? ?? ?? 00 74 15 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 FF 15 ?? ?? ?? ?? 89 45 FC 8B 45 FC 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_206_2_0 {
	meta:
		name = "__amsg_exit"
		size = 63
		refs = "0005 ___error_mode 0017 ___app_type 001f __FF_MSGBANNER 0028 __NMSG_WRITE 0036 __aexit_rtn"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? 01 74 12 83 3D ?? ?? ?? ?? 00 75 0E 83 3D ?? ?? ?? ?? 01 75 05 E8 ?? ?? ?? ?? 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 68 FF 00 00 00 FF 15 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_209_1_0 {
	meta:
		name = "_strtoxl"
		size = 816
		refs = "0026 ___mb_cur_max 003a __isctype 0050 __pctype 0202 _toupper 02d4 _errno"
	strings:
		$1 = { 55 8B EC 83 EC 20 8B 45 08 89 45 FC C7 45 F4 00 00 00 00 8B 4D FC 8A 11 88 55 F8 8B 45 FC 83 C0 01 89 45 FC 83 3D ?? ?? ?? ?? 01 7E 19 6A 08 8B 4D F8 81 E1 FF 00 00 00 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 E8 EB 1A 8B 55 F8 81 E2 FF 00 00 00 A1 ?? ?? ?? ?? 33 C9 66 8B 0C 50 83 E1 08 89 4D E8 83 7D E8 00 74 13 8B 55 FC 8A 02 88 45 F8 8B 4D FC 83 C1 01 89 4D FC EB AB 0F BE 55 F8 83 FA 2D 75 1B 8B 45 14 0C 02 89 45 14 8B 4D FC 8A 11 88 55 F8 8B 45 FC 83 C0 01 89 45 FC EB 1A 0F BE 4D F8 83 F9 2B 75 11 8B 55 FC 8A 02 88 45 F8 8B 4D FC 83 C1 01 89 4D FC 83 7D 10 00 7C 0C 83 7D 10 01 74 06 83 7D 10 24 7E 15 83 7D 0C 00 74 08 8B 55 0C 8B 45 08 89 02 33 C0 E9 4E 02 00 00 83 7D 10 00 75 38 0F BE 4D F8 83 F9 30 74 09 C7 45 10 0A 00 00 00 EB 26 8B 55 FC 0F BE 02 83 F8 78 74 0B 8B 4D FC 0F BE 11 83 FA 58 75 09 C7 45 10 10 00 00 00 EB 07 C7 45 10 08 00 00 00 83 7D 10 10 75 39 0F BE 45 F8 83 F8 30 75 30 8B 4D FC 0F BE 11 83 FA 78 74 0B 8B 45 FC 0F BE 08 83 F9 58 75 1A 8B 55 FC 83 C2 01 89 55 FC 8B 45 FC 8A 08 88 4D F8 8B 55 FC 83 C2 01 89 55 FC 83 C8 FF 33 D2 F7 75 10 89 45 F0 83 3D ?? ?? ?? ?? 01 7E 18 6A 04 8B 45 F8 25 FF 00 00 00 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 E4 EB 1B 8B 4D F8 81 E1 FF 00 00 00 8B 15 ?? ?? ?? ?? 33 C0 66 8B 04 4A 83 E0 04 89 45 E4 83 7D E4 00 74 0C 0F BE 4D F8 83 E9 30 89 4D EC EB 5F 83 3D ?? ?? ?? ?? 01 7E 1C 68 03 01 00 00 8B 55 F8 81 E2 FF 00 00 00 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 E0 EB 1D 8B 45 F8 25 FF 00 00 00 8B 0D ?? ?? ?? ?? 33 D2 66 8B 14 41 81 E2 03 01 00 00 89 55 E0 83 7D E0 00 74 15 0F BE 45 F8 50 E8 ?? ?? ?? ?? 83 C4 04 83 E8 37 89 45 EC EB 02 EB 5D 8B 4D EC 3B 4D 10 72 02 EB 53 8B 55 14 83 CA 08 89 55 14 8B 45 F4 3B 45 F0 72 15 8B 4D F4 3B 4D F0 75 1C 83 C8 FF 33 D2 F7 75 10 39 55 EC 77 0F 8B 55 F4 0F AF 55 10 03 55 EC 89 55 F4 EB 08 8B 45 14 0C 04 89 45 14 8B 4D FC 8A 11 88 55 F8 8B 45 FC 83 C0 01 89 45 FC E9 F6 FE FF FF 8B 4D FC 83 E9 01 89 4D FC 8B 55 14 83 E2 08 85 D2 75 15 83 7D 0C 00 74 06 8B 45 08 89 45 FC C7 45 F4 00 00 00 00 EB 71 8B 4D 14 83 E1 04 85 C9 75 30 8B 55 14 83 E2 01 85 D2 75 5D 8B 45 14 83 E0 02 85 C0 74 09 81 7D F4 00 00 00 80 77 13 8B 4D 14 83 E1 02 85 C9 75 40 81 7D F4 FF FF FF 7F 76 37 C7 05 ?? ?? ?? ?? 22 00 00 00 8B 55 14 83 E2 01 85 D2 74 09 C7 45 F4 FF FF FF FF EB 1A 8B 45 14 83 E0 02 85 C0 74 09 C7 45 F4 00 00 00 80 EB 07 C7 45 F4 FF FF FF 7F 83 7D 0C 00 74 08 8B 4D 0C 8B 55 FC 89 11 8B 45 14 83 E0 02 85 C0 74 08 8B 4D F4 F7 D9 89 4D F4 8B 45 F4 8B E5 5D C3 }
	condition:
		$1
}

rule file_209_2_0 {
	meta:
		name = "_strtoul"
		size = 27
		refs = "0012 _strtoxl"
	strings:
		$1 = { 55 8B EC 6A 01 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_302_2_0 {
	meta:
		name = "_wcstoul"
		size = 27
		refs = "0012 _wcstoxl"
	strings:
		$1 = { 55 8B EC 6A 01 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_210_0_0 {
	meta:
		name = "_getenv"
		size = 198
		refs = "0007 __environ 0010 ___env_initialized 0026 __wenviron 002e ___wtomb_environ 0057 _strlen 009c __mbsnbicoll"
	strings:
		$1 = { 55 8B EC 83 EC 08 A1 ?? ?? ?? ?? 89 45 F8 83 3D ?? ?? ?? ?? 00 75 07 33 C0 E9 A4 00 00 00 83 7D F8 00 75 22 83 3D ?? ?? ?? ?? 00 74 19 E8 ?? ?? ?? ?? 85 C0 74 07 33 C0 E9 85 00 00 00 8B 0D ?? ?? ?? ?? 89 4D F8 83 7D F8 00 74 74 83 7D 08 00 74 6E 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 8B 45 F8 83 38 00 74 57 8B 4D F8 8B 11 52 E8 ?? ?? ?? ?? 83 C4 04 3B 45 FC 76 39 8B 45 F8 8B 08 8B 55 FC 0F BE 04 11 83 F8 3D 75 28 8B 4D FC 51 8B 55 08 52 8B 45 F8 8B 08 51 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 0E 8B 55 F8 8B 02 8B 4D FC 8D 44 08 01 EB 0D 8B 55 F8 83 C2 04 89 55 F8 EB A1 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_212_0_0 {
	meta:
		name = "__fcvt"
		size = 57
		refs = "000d __fltout 002e __fpcvt"
	strings:
		$1 = { 55 8B EC 51 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 8B 55 18 52 8B 45 14 50 8B 4D FC 8B 51 04 03 55 10 52 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_212_1_0 {
	meta:
		name = "__ecvt"
		size = 73
		refs = "0019 __fltout 0022 __fpcvt"
	strings:
		$1 = { 55 8B EC 51 8B 45 18 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 FC 8B 55 FC 03 55 10 0F BE 02 85 C0 74 09 8B 4D FC 03 4D 10 C6 01 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_212_2_0 {
	meta:
		name = "__fpcvt"
		size = 85
		refs = "0025 _buf 002a __fptostr"
	strings:
		$1 = { 55 8B EC 51 81 7D 0C 5B 01 00 00 7E 09 C7 45 FC 5B 01 00 00 EB 06 8B 45 0C 89 45 FC 8B 4D 08 51 8B 55 FC 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 45 08 33 C9 83 38 2D 0F 94 C1 8B 55 14 89 0A 8B 45 10 8B 4D 08 8B 51 04 89 10 B8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_213_0_0 {
	meta:
		name = "___setargv"
		size = 235
		refs = "0008 ___mbctype_initialized 0010 ___initmbctable 001a _?_pgmname@?1??__setargv@@9@9 0022 __imp__GetModuleFileNameA@12 0028 __pgmptr 0031 __acmdln 0066 _parse_cmdline 0073 ??_C@_09MPMN@stdargv?4c?$AA@ 0084 __malloc_dbg 0097 __amsg_exit 00c7 ___argc 00d0 ___argv 00d5 __cwild"
	strings:
		$1 = { 55 8B EC 83 EC 14 83 3D ?? ?? ?? ?? 00 75 05 E8 ?? ?? ?? ?? 68 04 01 00 00 68 ?? ?? ?? ?? 6A 00 FF 15 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? A1 ?? ?? ?? ?? 0F BE 08 85 C9 75 0B 8B 15 ?? ?? ?? ?? 89 55 EC EB 08 A1 ?? ?? ?? ?? 89 45 EC 8B 4D EC 89 4D F0 8D 55 FC 52 8D 45 F4 50 6A 00 6A 00 8B 4D F0 51 E8 ?? ?? ?? ?? 83 C4 14 68 80 00 00 00 68 ?? ?? ?? ?? 6A 02 8B 55 F4 8B 45 FC 8D 0C 90 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 F8 83 7D F8 00 75 0A 6A 08 E8 ?? ?? ?? ?? 83 C4 04 8D 55 FC 52 8D 45 F4 50 8B 4D F4 8B 55 F8 8D 04 8A 50 8B 4D F8 51 8B 55 F0 52 E8 ?? ?? ?? ?? 83 C4 14 8B 45 F4 83 E8 01 A3 ?? ?? ?? ?? 8B 4D F8 89 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 0A 6A 08 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_213_1_0 {
	meta:
		name = "_parse_cmdline"
		size = 1135
		refs = "0093 __mbctype"
	strings:
		$1 = { 55 8B EC 83 EC 14 8B 45 18 C7 00 00 00 00 00 8B 4D 14 C7 01 01 00 00 00 8B 55 08 89 55 FC 83 7D 0C 00 74 11 8B 45 0C 8B 4D 10 89 08 8B 55 0C 83 C2 04 89 55 0C 83 7D 10 00 74 13 8B 45 10 8B 4D FC 8A 11 88 10 8B 45 10 83 C0 01 89 45 10 8B 4D 18 8B 11 83 C2 01 8B 45 18 89 10 8B 4D FC 0F BE 11 83 FA 22 0F 85 C9 00 00 00 8B 45 FC 83 C0 01 89 45 FC 8B 4D FC 0F BE 11 83 FA 22 74 7A 8B 45 FC 0F BE 08 85 C9 74 70 8B 55 FC 33 C0 8A 02 33 C9 8A 88 ?? ?? ?? ?? 83 E1 04 85 C9 74 2F 8B 55 18 8B 02 83 C0 01 8B 4D 18 89 01 83 7D 10 00 74 1C 8B 55 10 8B 45 FC 8A 08 88 0A 8B 55 10 83 C2 01 89 55 10 8B 45 FC 83 C0 01 89 45 FC 8B 4D 18 8B 11 83 C2 01 8B 45 18 89 10 83 7D 10 00 74 13 8B 4D 10 8B 55 FC 8A 02 88 01 8B 4D 10 83 C1 01 89 4D 10 E9 72 FF FF FF 8B 55 18 8B 02 83 C0 01 8B 4D 18 89 01 83 7D 10 00 74 0F 8B 55 10 C6 02 00 8B 45 10 83 C0 01 89 45 10 8B 4D FC 0F BE 11 83 FA 22 75 09 8B 45 FC 83 C0 01 89 45 FC E9 CE 00 00 00 8B 4D 18 8B 11 83 C2 01 8B 45 18 89 10 83 7D 10 00 74 13 8B 4D 10 8B 55 FC 8A 02 88 01 8B 4D 10 83 C1 01 89 4D 10 8B 55 FC 8A 02 88 45 F4 8B 4D FC 83 C1 01 89 4D FC 8B 55 F4 81 E2 FF 00 00 00 33 C0 8A 82 ?? ?? ?? ?? 83 E0 04 85 C0 74 2F 8B 4D 18 8B 11 83 C2 01 8B 45 18 89 10 83 7D 10 00 74 13 8B 4D 10 8B 55 FC 8A 02 88 01 8B 4D 10 83 C1 01 89 4D 10 8B 55 FC 83 C2 01 89 55 FC 8B 45 F4 25 FF 00 00 00 83 F8 20 74 1F 8B 4D F4 81 E1 FF 00 00 00 85 C9 74 12 8B 55 F4 81 E2 FF 00 00 00 83 FA 09 0F 85 56 FF FF FF 8B 45 F4 25 FF 00 00 00 85 C0 75 0B 8B 4D FC 83 E9 01 89 4D FC EB 0D 83 7D 10 00 74 07 8B 55 10 C6 42 FF 00 C7 45 EC 00 00 00 00 8B 45 FC 0F BE 08 85 C9 74 21 8B 55 FC 0F BE 02 83 F8 20 74 0B 8B 4D FC 0F BE 11 83 FA 09 75 0B 8B 45 FC 83 C0 01 89 45 FC EB DF 8B 4D FC 0F BE 11 85 D2 75 05 E9 04 02 00 00 83 7D 0C 00 74 11 8B 45 0C 8B 4D 10 89 08 8B 55 0C 83 C2 04 89 55 0C 8B 45 14 8B 08 83 C1 01 8B 55 14 89 0A 83 7D 10 00 74 13 8B 45 10 8B 4D FC 8A 11 88 10 8B 45 10 83 C0 01 89 45 10 8B 4D 18 8B 11 83 C2 01 8B 45 18 89 10 C7 45 F8 01 00 00 00 C7 45 F0 00 00 00 00 8B 4D FC 0F BE 11 83 FA 5C 75 14 8B 45 FC 83 C0 01 89 45 FC 8B 4D F0 83 C1 01 89 4D F0 EB E1 8B 55 FC 0F BE 02 83 F8 22 75 51 8B 45 F0 33 D2 B9 02 00 00 00 F7 F1 85 D2 75 39 83 7D EC 00 74 20 8B 55 FC 0F BE 42 01 83 F8 22 75 0B 8B 4D FC 83 C1 01 89 4D FC EB 07 C7 45 F8 00 00 00 00 EB 07 C7 45 F8 00 00 00 00 33 D2 83 7D EC 00 0F 94 C2 89 55 EC 8B 45 F0 D1 E8 89 45 F0 8B 4D F0 8B 55 F0 83 EA 01 89 55 F0 85 C9 74 24 83 7D 10 00 74 0F 8B 45 10 C6 00 5C 8B 4D 10 83 C1 01 89 4D 10 8B 55 18 8B 02 83 C0 01 8B 4D 18 89 01 EB CC 8B 55 FC 0F BE 02 85 C0 74 1C 83 7D EC 00 75 1B 8B 4D FC 0F BE 11 83 FA 20 74 0B 8B 45 FC 0F BE 08 83 F9 09 75 05 E9 AB 00 00 00 83 7D F8 00 0F 84 93 00 00 00 83 7D 10 00 74 54 8B 55 FC 33 C0 8A 02 33 C9 8A 88 ?? ?? ?? ?? 83 E1 04 85 C9 74 29 8B 55 10 8B 45 FC 8A 08 88 0A 8B 55 10 83 C2 01 89 55 10 8B 45 FC 83 C0 01 89 45 FC 8B 4D 18 8B 11 83 C2 01 8B 45 18 89 10 8B 4D 10 8B 55 FC 8A 02 88 01 8B 4D 10 83 C1 01 89 4D 10 EB 2C 8B 55 FC 33 C0 8A 02 33 C9 8A 88 ?? ?? ?? ?? 83 E1 04 85 C9 74 16 8B 55 FC 83 C2 01 89 55 FC 8B 45 18 8B 08 83 C1 01 8B 55 18 89 0A 8B 45 18 8B 08 83 C1 01 8B 55 18 89 0A 8B 45 FC 83 C0 01 89 45 FC E9 6D FE FF FF 83 7D 10 00 74 0F 8B 4D 10 C6 01 00 8B 55 10 83 C2 01 89 55 10 8B 45 18 8B 08 83 C1 01 8B 55 18 89 0A E9 C2 FD FF FF 83 7D 0C 00 74 12 8B 45 0C C7 00 00 00 00 00 8B 4D 0C 83 C1 04 89 4D 0C 8B 55 14 8B 02 83 C0 01 8B 4D 14 89 01 8B E5 5D C3 }
	condition:
		$1
}

rule file_214_0_0 {
	meta:
		name = "__mbsnccnt"
		size = 127
		refs = "0045 __mbctype"
	strings:
		$1 = { 55 8B EC 51 C7 45 FC 00 00 00 00 EB 12 8B 45 FC 83 C0 01 89 45 FC 8B 4D 08 83 C1 01 89 4D 08 8B 55 0C 8B 45 0C 83 E8 01 89 45 0C 85 D2 74 49 8B 4D 08 33 D2 8A 11 85 D2 74 3E 8B 45 08 33 C9 8A 08 33 D2 8A 91 ?? ?? ?? ?? 83 E2 04 85 D2 74 26 8B 45 0C 8B 4D 0C 83 E9 01 89 4D 0C 85 C0 74 14 8B 55 08 83 C2 01 89 55 08 8B 45 08 33 C9 8A 08 85 C9 75 02 EB 02 EB 95 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_215_0_0 {
	meta:
		name = "__mbctohira"
		size = 68
		refs = "0008 __ismbckata"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 2C 81 7D 08 93 83 00 00 77 23 81 7D 08 7F 83 00 00 73 0E 8B 4D 08 81 E9 A1 00 00 00 89 4D 08 EB 0C 8B 55 08 81 EA A2 00 00 00 89 55 08 8B 45 08 5D C3 }
	condition:
		$1
}

rule file_216_0_0 {
	meta:
		name = "__mbscoll"
		size = 64
		refs = "0005 ___mbcodepage 0019 ___mblcid 001f ___crtCompareStringA"
	strings:
		$1 = { 55 8B EC 51 A1 ?? ?? ?? ?? 50 6A FF 8B 4D 0C 51 6A FF 8B 55 08 52 6A 00 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 1C 89 45 FC 83 7D FC 00 75 07 B8 FF FF FF 7F EB 06 8B 45 FC 83 E8 02 8B E5 5D C3 }
	condition:
		$1
}

rule file_218_0_0 {
	meta:
		name = "__mbctokata"
		size = 54
		refs = "0008 __ismbchira"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 1E 8B 4D 08 81 C1 A1 00 00 00 89 4D 08 81 7D 08 7F 83 00 00 72 09 8B 55 08 83 C2 01 89 55 08 8B 45 08 5D C3 }
	condition:
		$1
}

rule file_219_0_0 {
	meta:
		name = "__mbbtombc"
		size = 165
		refs = "0006 ___mbcodepage 002d _mbbtable 0071 _mbctable"
	strings:
		$1 = { 55 8B EC 51 81 3D ?? ?? ?? ?? A4 03 00 00 74 08 8B 45 08 E9 89 00 00 00 83 7D 08 20 72 17 83 7D 08 7E 77 11 8B 45 08 33 C9 66 8B 0C 45 ?? ?? ?? ?? 8B C1 EB 6C 81 7D 08 DC 00 00 00 75 07 B8 8F 83 00 00 EB 5C 81 7D 08 A1 00 00 00 72 50 81 7D 08 DF 00 00 00 77 47 C7 45 FC 00 00 00 00 EB 09 8B 55 FC 83 C2 01 89 55 FC 8B 45 FC 33 C9 8A 0C 85 ?? ?? ?? ?? 85 C9 74 25 8B 55 FC 33 C0 8A 04 95 ?? ?? ?? ?? 39 45 08 75 12 8B 4D FC 33 D2 66 8B 14 8D ?? ?? ?? ?? 89 55 08 EB 02 EB C2 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_219_1_0 {
	meta:
		name = "__mbctombb"
		size = 255
		refs = "0008 ___mbcodepage 003b _mbbtable 0078 _mbctable"
	strings:
		$1 = { 55 8B EC 83 EC 08 81 3D ?? ?? ?? ?? A4 03 00 00 74 08 8B 45 08 E9 E1 00 00 00 C7 45 F8 00 00 00 00 EB 09 8B 45 F8 83 C0 01 89 45 F8 83 7D F8 5E 7F 1F 8B 4D F8 33 D2 66 8B 14 4D ?? ?? ?? ?? 39 55 08 75 0B 8B 45 F8 83 C0 20 E9 AC 00 00 00 EB D2 81 7D 08 96 83 00 00 0F 87 9A 00 00 00 C7 45 F8 00 00 00 00 EB 09 8B 45 F8 83 C0 01 89 45 F8 8B 4D F8 33 D2 8A 14 8D ?? ?? ?? ?? 85 D2 74 78 8B 45 F8 33 C9 66 8B 0C 85 ?? ?? ?? ?? 8B 55 08 2B D1 89 55 FC 83 7D FC 00 75 10 8B 45 F8 33 C9 8A 0C 85 ?? ?? ?? ?? 8B C1 EB 50 8B 55 08 81 E2 00 FF 00 00 8B 45 F8 33 C9 66 8B 0C 85 ?? ?? ?? ?? 81 E1 00 FF 00 00 3B D1 75 28 83 7D FC 00 7E 22 8B 55 F8 0F BE 04 95 ?? ?? ?? ?? 8B 4D FC 2B C8 85 C9 7D 0E 8B 55 F8 33 C0 8A 04 95 ?? ?? ?? ?? EB 08 E9 6F FF FF FF 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_220_0_0 {
	meta:
		name = "_fclose"
		size = 221
		refs = "003c ??_C@_0M@KJPK@str?5?$CB?$DN?5NULL?$AA@ 0045 ??_C@_08PHBD@fclose?4c?$AA@ 004c __CrtDbgReport 0073 __flush 0082 __freebuf 0091 __close 00b8 __free_dbg"
	strings:
		$1 = { 55 8B EC 83 EC 08 53 56 57 C7 45 FC FF FF FF FF 8B 45 08 89 45 F8 8B 4D F8 8B 51 0C 83 E2 40 85 D2 74 12 8B 45 F8 C7 40 0C 00 00 00 00 83 C8 FF E9 A1 00 00 00 83 7D 08 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 77 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D6 8B 55 F8 8B 42 0C 25 83 00 00 00 85 C0 74 5B 8B 4D F8 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 04 8B 45 F8 8B 48 10 51 E8 ?? ?? ?? ?? 83 C4 04 85 C0 7D 09 C7 45 FC FF FF FF FF EB 24 8B 55 F8 83 7A 1C 00 74 1B 6A 02 8B 45 F8 8B 48 1C 51 E8 ?? ?? ?? ?? 83 C4 08 8B 55 F8 C7 42 1C 00 00 00 00 8B 45 F8 C7 40 0C 00 00 00 00 8B 45 FC 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_221_0_0 {
	meta:
		name = "_ungetwc"
		size = 602
		refs = "0010 ??_C@_0M@KJPK@str?5?$CB?$DN?5NULL?$AA@ 0019 ??_C@_09JKFL@ungetwc?4c?$AA@ 0020 __CrtDbgReport 0088 __getbuf 00be ___pioinfo 00cd ___badioinfo 00f0 _wctomb 0102 _errno"
	strings:
		$1 = { 55 8B EC 83 EC 0C 53 56 57 83 7D 0C 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 62 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D6 8B 4D 08 81 E1 FF FF 00 00 81 F9 FF FF 00 00 0F 84 07 02 00 00 8B 55 0C 8B 42 0C 83 E0 01 85 C0 75 25 8B 4D 0C 8B 51 0C 81 E2 80 00 00 00 85 D2 0F 84 E6 01 00 00 8B 45 0C 8B 48 0C 83 E1 02 85 C9 0F 85 D5 01 00 00 8B 55 0C 83 7A 08 00 75 0C 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 8B 51 0C 83 E2 40 85 D2 0F 85 2B 01 00 00 8B 45 0C 83 78 10 FF 74 21 8B 4D 0C 8B 51 10 C1 FA 05 8B 45 0C 8B 48 10 83 E1 1F 8B 14 95 ?? ?? ?? ?? 8D 04 CA 89 45 F4 EB 07 C7 45 F4 ?? ?? ?? ?? 8B 4D F4 0F BE 51 04 81 E2 80 00 00 00 85 D2 0F 84 E5 00 00 00 66 8B 45 08 50 8D 4D F8 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC FF 75 13 C7 05 ?? ?? ?? ?? 2A 00 00 00 66 0D FF FF E9 40 01 00 00 8B 55 0C 8B 45 0C 8B 0A 3B 48 08 75 1F 8B 55 0C 83 7A 04 00 74 09 66 0D FF FF E9 21 01 00 00 8B 45 0C 8B 08 03 4D FC 8B 55 0C 89 0A 83 7D FC 01 75 19 8B 45 0C 8B 08 83 E9 01 8B 55 0C 89 0A 8B 45 0C 8B 08 8A 55 F8 88 11 EB 2E 8B 45 0C 8B 08 83 E9 01 8B 55 0C 89 0A 8B 45 0C 8B 08 8A 55 F9 88 11 8B 45 0C 8B 08 83 E9 01 8B 55 0C 89 0A 8B 45 0C 8B 08 8A 55 F8 88 11 8B 45 0C 8B 48 04 03 4D FC 8B 55 0C 89 4A 04 8B 45 0C 8B 48 0C 83 E1 EF 8B 55 0C 89 4A 0C 8B 45 0C 8B 48 0C 83 C9 01 8B 55 0C 89 4A 0C 8B 45 08 25 FF FF 00 00 25 FF FF 00 00 E9 88 00 00 00 8B 45 0C 8B 4D 0C 8B 10 3B 51 08 75 1C 8B 45 0C 83 78 04 00 74 06 66 0D FF FF EB 6C 8B 4D 0C 8B 11 83 C2 02 8B 45 0C 89 10 8B 4D 0C 8B 51 04 83 C2 02 8B 45 0C 89 50 04 8B 4D 0C 8B 51 0C 83 E2 EF 8B 45 0C 89 50 0C 8B 4D 0C 8B 51 0C 83 CA 01 8B 45 0C 89 50 0C 8B 4D 08 81 E1 FF FF 00 00 81 E1 FF FF 00 00 8B 55 0C 8B 02 83 E8 02 8B 55 0C 89 02 8B 45 0C 8B 10 66 89 0A 8B 45 0C 8B 08 66 8B 01 EB 04 66 0D FF FF 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_222_0_0 {
	meta:
		name = "__trandisp1"
		size = 103
		refs = "0029 XAMtoTagTab"
	strings:
		$1 = { 80 7A 0E 05 75 11 66 8B 9D 5C FF FF FF 80 CF 02 80 E7 FE B3 3F EB 04 66 BB 3F 13 66 89 9D 5E FF FF FF D9 AD 5E FF FF FF BB ?? ?? ?? ?? D9 E5 89 95 6C FF FF FF 9B DD BD 60 FF FF FF C6 85 70 FF FF FF 00 9B 8A 8D 61 FF FF FF D0 E1 D0 F9 D0 C1 8A C1 24 0F D7 0F BE C0 81 E1 04 04 00 00 8B DA 03 D8 83 C3 10 FF 23 }
	condition:
		$1
}

rule file_222_1_0 {
	meta:
		name = "__trandisp2"
		size = 140
		refs = "0029 XAMtoTagTab"
	strings:
		$1 = { 80 7A 0E 05 75 11 66 8B 9D 5C FF FF FF 80 CF 02 80 E7 FE B3 3F EB 04 66 BB 3F 13 66 89 9D 5E FF FF FF D9 AD 5E FF FF FF BB ?? ?? ?? ?? D9 E5 89 95 6C FF FF FF 9B DD BD 60 FF FF FF C6 85 70 FF FF FF 00 D9 C9 8A 8D 61 FF FF FF D9 E5 9B DD BD 60 FF FF FF D9 C9 8A AD 61 FF FF FF D0 E5 D0 FD D0 C5 8A C5 24 0F D7 8A E0 D0 E1 D0 F9 D0 C1 8A C1 24 0F D7 D0 E4 D0 E4 0A C4 0F BE C0 81 E1 04 04 00 00 8B DA 03 D8 83 C3 10 FF 23 }
	condition:
		$1
}

rule file_222_11_0 {
	meta:
		name = "__tosnan1"
		size = 43
		refs = "0026 One"
	strings:
		$1 = { DB BD 62 FF FF FF DB AD 62 FF FF FF F6 85 69 FF FF FF 40 74 08 C6 85 70 FF FF FF 07 C3 C6 85 70 FF FF FF 01 DC 05 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_222_13_0 {
	meta:
		name = "__tosnan2"
		size = 40
	strings:
		$1 = { DB BD 62 FF FF FF DB AD 62 FF FF FF F6 85 69 FF FF FF 40 74 09 C6 85 70 FF FF FF 07 EB 07 C6 85 70 FF FF FF 01 DE C1 C3 }
	condition:
		$1
}

rule file_222_14_0 {
	meta:
		name = "__nan2"
		size = 63
	strings:
		$1 = { DB BD 62 FF FF FF DB AD 62 FF FF FF F6 85 69 FF FF FF 40 74 20 D9 C9 DB BD 62 FF FF FF DB AD 62 FF FF FF F6 85 69 FF FF FF 40 74 09 C6 85 70 FF FF FF 07 EB 07 C6 85 70 FF FF FF 01 DE C1 C3 }
	condition:
		$1
}

rule file_222_16_0 {
	meta:
		name = "__rtindfnpop"
		size = 17
		refs = "0004 __indefinite"
	strings:
		$1 = { DD D8 DB 2D ?? ?? ?? ?? 80 BD 70 FF FF FF 00 7F 07 }
	condition:
		$1
}

rule file_223_1_0 {
	meta:
		name = "_atan"
		size = 139
		refs = "0005 __fload_withFB 001a __DEFAULT_CW_in_mem 0024 ___fastflag 002b __fast_exit 0036 _NAME_ 003b __math_exit 0040 __convertTOStoQNaN 0058 __piby2 0085 __startOneArgErrorHandling"
	strings:
		$1 = { 8D 54 24 04 E8 ?? ?? ?? ?? 52 9B D9 3C 24 74 36 66 81 3C 24 7F 02 74 06 D9 2D ?? ?? ?? ?? D9 E8 D9 F3 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 0F 00 00 00 8D 0D ?? ?? ?? ?? E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 26 A9 FF FF 0F 00 75 F2 83 7C 24 08 00 75 EB DD D8 DB 2D ?? ?? ?? ?? A9 00 00 00 80 74 BF D9 E0 EB BB B8 01 00 00 00 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 0F 00 00 00 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule file_225_0_0 {
	meta:
		name = "?set_new_handler@@YAP6AXXZP6AXXZ@Z"
		size = 43
		refs = "000c ??_C@_0M@HAOM@setnewh?4cpp?$AA@ 0011 ??_C@_0L@ODMK@new_p?5?$DN?$DN?50?$AA@ 0016 __assert 0020 ?_set_new_handler@@YAP6AHI@ZP6AHI@Z@Z"
	strings:
		$1 = { 55 8B EC 83 7D 08 00 74 14 6A 34 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 6A 00 E8 ?? ?? ?? ?? 83 C4 04 33 C0 5D C3 }
	condition:
		$1
}

rule file_226_0_0 {
	meta:
		name = "_asctime"
		size = 377
		refs = "0009 _buf 0051 ___dnames 0062 ___mnames 0095 _store_dt"
	strings:
		$1 = { 55 8B EC 83 EC 10 C7 45 FC ?? ?? ?? ?? 8B 45 08 8B 48 18 6B C9 03 89 4D F4 8B 55 08 8B 42 10 6B C0 03 89 45 F8 C7 45 F0 00 00 00 00 EB 12 8B 4D F0 83 C1 01 89 4D F0 8B 55 FC 83 C2 01 89 55 FC 83 7D F0 03 7D 25 8B 45 F4 03 45 F0 8B 4D FC 8A 90 ?? ?? ?? ?? 88 11 8B 45 F8 03 45 F0 8B 4D FC 8A 90 ?? ?? ?? ?? 88 51 04 EB C3 8B 45 FC C6 00 20 8B 4D FC 83 C1 04 89 4D FC 8B 55 FC C6 02 20 8B 45 FC 83 C0 01 89 45 FC 8B 4D 08 8B 51 0C 52 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 8B 4D FC C6 01 20 8B 55 FC 83 C2 01 89 55 FC 8B 45 08 8B 48 08 51 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 8B 45 FC C6 00 3A 8B 4D FC 83 C1 01 89 4D FC 8B 55 08 8B 42 04 50 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 8B 55 FC C6 02 3A 8B 45 FC 83 C0 01 89 45 FC 8B 4D 08 8B 11 52 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 8B 4D FC C6 01 20 8B 55 FC 83 C2 01 89 55 FC 8B 45 08 8B 40 14 99 B9 64 00 00 00 F7 F9 83 C0 13 50 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 8B 45 08 8B 40 14 99 B9 64 00 00 00 F7 F9 52 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 8B 45 FC C6 00 0A 8B 4D FC 83 C1 01 89 4D FC 8B 55 FC C6 02 00 B8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_226_1_0 {
	meta:
		name = "_store_dt"
		size = 64
	strings:
		$1 = { 55 8B EC 8B 45 0C 99 B9 0A 00 00 00 F7 F9 83 C0 30 8B 55 08 88 02 8B 45 08 83 C0 01 89 45 08 8B 45 0C 99 B9 0A 00 00 00 F7 F9 83 C2 30 8B 45 08 88 10 8B 4D 08 83 C1 01 89 4D 08 8B 45 08 5D C3 }
	condition:
		$1
}

rule file_227_0_0 {
	meta:
		name = "_printf"
		size = 124
		refs = "0016 ??_C@_0P@LNLA@format?5?$CB?$DN?5NULL?$AA@ 001f ??_C@_08GNFC@printf?4c?$AA@ 0026 __CrtDbgReport 003a __iob 003f __stbuf 0057 __output 006b __ftbuf"
	strings:
		$1 = { 55 8B EC 83 EC 0C 53 56 57 8D 45 0C 89 45 F4 83 7D 08 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 36 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D6 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 8B 55 F4 52 8B 45 08 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 89 45 F8 68 ?? ?? ?? ?? 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 8B 45 F8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_228_0_0 {
	meta:
		name = "_wcstok"
		size = 248
		refs = "000d _?nextoken@?1??wcstok@@9@9"
	strings:
		$1 = { 55 8B EC 83 EC 08 83 7D 08 00 75 08 A1 ?? ?? ?? ?? 89 45 08 8B 4D 08 33 D2 66 8B 11 85 D2 74 4C 8B 45 0C 89 45 F8 EB 09 8B 4D F8 83 C1 02 89 4D F8 8B 55 F8 33 C0 66 8B 02 85 C0 74 16 8B 4D F8 33 D2 66 8B 11 8B 45 08 33 C9 66 8B 08 3B D1 74 02 EB D5 8B 55 F8 33 C0 66 8B 02 85 C0 75 02 EB 0B 8B 4D 08 83 C1 02 89 4D 08 EB A8 8B 55 08 89 55 FC EB 09 8B 45 08 83 C0 02 89 45 08 8B 4D 08 33 D2 66 8B 11 85 D2 74 54 8B 45 0C 89 45 F8 EB 09 8B 4D F8 83 C1 02 89 4D F8 8B 55 F8 33 C0 66 8B 02 85 C0 74 16 8B 4D F8 33 D2 66 8B 11 8B 45 08 33 C9 66 8B 08 3B D1 74 02 EB D5 8B 55 F8 33 C0 66 8B 02 85 C0 74 13 8B 4D 08 66 C7 01 00 00 8B 55 08 83 C2 02 89 55 08 EB 02 EB 97 8B 45 08 A3 ?? ?? ?? ?? 8B 4D FC 3B 4D 08 75 04 33 C0 EB 03 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_229_0_0 {
	meta:
		name = "_mbtowc"
		size = 348
		refs = "0008 ___mb_cur_max 0019 ??_C@_0CD@NPPL@MB_CUR_MAX?5?$DN?$DN?51?5?$HM?$HM?5MB_CUR_MAX?5?$DN?$DN@ 0022 ??_C@_08MOLN@mbtowc?4c?$AA@ 0029 __CrtDbgReport 0070 ___lc_handle 009c __pctype 00e1 ___lc_codepage 00e8 __imp__MultiByteToWideChar@24 0108 _errno"
	strings:
		$1 = { 55 8B EC 53 56 57 83 3D ?? ?? ?? ?? 01 74 27 83 3D ?? ?? ?? ?? 02 74 1E 68 ?? ?? ?? ?? 6A 00 6A 4F 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 CA 83 7D 0C 00 74 06 83 7D 10 00 75 07 33 C0 E9 08 01 00 00 8B 4D 0C 0F BE 11 85 D2 75 15 83 7D 08 00 74 08 8B 45 08 66 C7 00 00 00 33 C0 E9 E9 00 00 00 83 3D ?? ?? ?? ?? 00 75 1D 83 7D 08 00 74 0D 8B 4D 0C 66 0F B6 11 8B 45 08 66 89 10 B8 01 00 00 00 E9 C3 00 00 00 8B 4D 0C 33 D2 8A 11 A1 ?? ?? ?? ?? 33 C9 66 8B 0C 50 81 E1 00 80 00 00 85 C9 74 6C 83 3D ?? ?? ?? ?? 01 7E 37 8B 55 10 3B 15 ?? ?? ?? ?? 7C 2C 33 C0 83 7D 08 00 0F 95 C0 50 8B 4D 08 51 8B 15 ?? ?? ?? ?? 52 8B 45 0C 50 6A 09 8B 0D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 85 C0 75 25 8B 55 10 3B 15 ?? ?? ?? ?? 72 0B 8B 45 0C 0F BE 48 01 85 C9 75 0F C7 05 ?? ?? ?? ?? 2A 00 00 00 83 C8 FF EB 42 A1 ?? ?? ?? ?? EB 3B 33 D2 83 7D 08 00 0F 95 C2 52 8B 45 08 50 6A 01 8B 4D 0C 51 6A 09 8B 15 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 85 C0 75 0F C7 05 ?? ?? ?? ?? 2A 00 00 00 83 C8 FF EB 05 B8 01 00 00 00 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_230_0_0 {
	meta:
		name = "_swprintf"
		size = 324
		refs = "001c ??_C@_0P@OOIN@string?5?$CB?$DN?5NULL?$AA@ 0025 ??_C@_0L@LJJP@swprintf?4c?$AA@ 002c __CrtDbgReport 0046 ??_C@_0P@LNLA@format?5?$CB?$DN?5NULL?$AA@ 009b __woutput 00e6 __flsbuf"
	strings:
		$1 = { 55 8B EC 83 EC 34 53 56 57 8D 45 E0 89 45 DC 8D 4D 10 89 4D D4 83 7D 08 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 5F 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 D2 85 D2 75 D6 83 7D 0C 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 60 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D6 8B 4D DC C7 41 0C 42 00 00 00 8B 55 DC 8B 45 08 89 42 08 8B 4D DC 8B 55 08 89 11 8B 45 DC C7 40 04 FF FF FF 7F 8B 4D D4 51 8B 55 0C 52 8B 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 89 45 D8 8B 4D DC 8B 51 04 83 EA 01 8B 45 DC 89 50 04 8B 4D DC 83 79 04 00 7C 22 8B 55 DC 8B 02 C6 00 00 33 C9 81 E1 FF 00 00 00 89 4D D0 8B 55 DC 8B 02 83 C0 01 8B 4D DC 89 01 EB 11 8B 55 DC 52 6A 00 E8 ?? ?? ?? ?? 83 C4 08 89 45 D0 8B 45 DC 8B 48 04 83 E9 01 8B 55 DC 89 4A 04 8B 45 DC 83 78 04 00 7C 21 8B 4D DC 8B 11 C6 02 00 33 C0 25 FF 00 00 00 89 45 CC 8B 4D DC 8B 11 83 C2 01 8B 45 DC 89 10 EB 11 8B 4D DC 51 6A 00 E8 ?? ?? ?? ?? 83 C4 08 89 45 CC 8B 45 D8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_231_0_0 {
	meta:
		name = "__isatty"
		size = 47
		refs = "0008 __nhandle 0021 ___pioinfo"
	strings:
		$1 = { 55 8B EC 8B 45 08 3B 05 ?? ?? ?? ?? 72 04 33 C0 EB 1B 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F 8B 04 8D ?? ?? ?? ?? 0F BE 44 D0 04 83 E0 40 5D C3 }
	condition:
		$1
}

rule file_232_0_0 {
	meta:
		name = "__calloc_base"
		size = 282
		refs = "0054 ___active_heap 0060 ___sbh_threshold 006b ___sbh_alloc_block 0086 _memset 009d ___old_sbh_threshold 00ab ___old_sbh_alloc_block 00db __crtheap 00e2 __imp__HeapAlloc@12 00f1 __newmode 0102 __callnewh"
	strings:
		$1 = { 55 8B EC 83 EC 10 8B 45 08 89 45 F0 8B 4D 0C 89 4D F4 8B 55 0C 0F AF 55 08 89 55 0C 8B 45 0C 89 45 FC 83 7D 0C E0 77 19 83 7D 0C 00 75 07 C7 45 0C 01 00 00 00 8B 4D 0C 83 C1 0F 83 E1 F0 89 4D 0C C7 45 F8 00 00 00 00 83 7D 0C E0 0F 87 97 00 00 00 83 3D ?? ?? ?? ?? 03 75 34 8B 55 FC 3B 15 ?? ?? ?? ?? 77 27 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 F8 83 7D F8 00 74 12 8B 4D FC 51 6A 00 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 0C EB 3E 83 3D ?? ?? ?? ?? 02 75 35 8B 45 0C 3B 05 ?? ?? ?? ?? 77 2A 8B 4D 0C C1 E9 04 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 F8 83 7D F8 00 74 12 8B 55 0C 52 6A 00 8B 45 F8 50 E8 ?? ?? ?? ?? 83 C4 0C 83 7D F8 00 75 16 8B 4D 0C 51 6A 08 8B 15 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 89 45 F8 83 7D F8 00 75 09 83 3D ?? ?? ?? ?? 00 75 05 8B 45 F8 EB 19 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 04 33 C0 EB 05 E9 2B FF FF FF 8B E5 5D C3 }
	condition:
		$1
}

rule file_233_0_0 {
	meta:
		name = "__except_handler3"
		size = 189
		refs = "005b __global_unwind2 0068 __local_unwind2 0079 __NLG_Notify"
	strings:
		$1 = { 55 8B EC 83 EC 08 53 56 57 55 FC 8B 5D 0C 8B 45 08 F7 40 04 06 00 00 00 0F 85 82 00 00 00 89 45 F8 8B 45 10 89 45 FC 8D 45 F8 89 43 FC 8B 73 0C 8B 7B 08 83 FE FF 74 61 8D 0C 76 83 7C 8F 04 00 74 45 56 55 8D 6B 10 FF 54 8F 04 5D 5E 8B 5D 0C 0B C0 74 33 78 3C 8B 7B 08 53 E8 ?? ?? ?? ?? 83 C4 04 8D 6B 10 56 53 E8 ?? ?? ?? ?? 83 C4 08 8D 0C 76 6A 01 8B 44 8F 08 E8 ?? ?? ?? ?? 8B 04 8F 89 43 0C FF 54 8F 08 8B 7B 08 8D 0C 76 8B 34 8F EB A1 B8 00 00 00 00 EB 1C B8 01 00 00 00 EB 15 55 8D 6B 10 6A FF 53 E8 ?? ?? ?? ?? 83 C4 08 5D B8 01 00 00 00 5D 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_233_1_0 {
	meta:
		name = "__seh_longjmp_unwind@4"
		size = 27
		refs = "0010 __local_unwind2"
	strings:
		$1 = { 55 8B 4C 24 08 8B 29 8B 41 1C 50 8B 41 18 50 E8 ?? ?? ?? ?? 83 C4 08 5D C2 04 00 }
	condition:
		$1
}

rule file_234_0_0 {
	meta:
		name = "__realloc_base"
		size = 1045
		refs = "0017 __malloc_base 002e __free_base 003e ___active_heap 005f ___sbh_find_block 0078 ___sbh_threshold 008f ___sbh_resize_block 00a7 ___sbh_alloc_block 00e6 _memcpy 0105 ___sbh_free_block 0132 __crtheap 0139 __imp__HeapAlloc@12 01be __imp__HeapReAlloc@16 01cd __newmode 01e1 __callnewh 0243 ___old_sbh_find_block 025c ___old_sbh_threshold 027a ___old_sbh_resize_block 0295 ___old_sbh_alloc_block 02e9 ___old_sbh_free_block"
	strings:
		$1 = { 55 8B EC 83 EC 30 8B 45 0C 89 45 FC 83 7D 08 00 75 11 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 04 E9 EE 03 00 00 83 7D 0C 00 75 13 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 33 C0 E9 D5 03 00 00 83 3D ?? ?? ?? ?? 03 0F 85 AF 01 00 00 C7 45 F4 00 00 00 00 83 7D 0C E0 0F 87 6B 01 00 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 F0 83 7D F0 00 0F 84 19 01 00 00 8B 4D 0C 3B 0D ?? ?? ?? ?? 0F 87 8A 00 00 00 8B 55 0C 52 8B 45 08 50 8B 4D F0 51 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 08 8B 55 08 89 55 F4 EB 6A 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 F4 83 7D F4 00 74 55 8B 4D 08 8B 51 FC 83 EA 01 89 55 F8 8B 45 F8 3B 45 0C 73 08 8B 4D F8 89 4D DC EB 06 8B 55 0C 89 55 DC 8B 45 DC 50 8B 4D 08 51 8B 55 F4 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 F0 8B 4D 08 51 8B 55 F0 52 E8 ?? ?? ?? ?? 83 C4 08 83 7D F4 00 75 7A 83 7D 0C 00 75 07 C7 45 0C 01 00 00 00 8B 45 0C 83 C0 0F 24 F0 89 45 0C 8B 4D 0C 51 6A 00 8B 15 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 89 45 F4 83 7D F4 00 74 46 8B 45 08 8B 48 FC 83 E9 01 89 4D F8 8B 55 F8 3B 55 0C 73 08 8B 45 F8 89 45 D8 EB 06 8B 4D 0C 89 4D D8 8B 55 D8 52 8B 45 08 50 8B 4D F4 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 08 52 8B 45 F0 50 E8 ?? ?? ?? ?? 83 C4 08 83 7D F0 00 75 33 83 7D 0C 00 75 07 C7 45 0C 01 00 00 00 8B 4D 0C 83 C1 0F 83 E1 F0 89 4D 0C 8B 55 0C 52 8B 45 08 50 6A 00 8B 0D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 89 45 F4 83 7D F4 00 75 09 83 3D ?? ?? ?? ?? 00 75 08 8B 45 F4 E9 35 02 00 00 8B 55 0C 52 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 07 33 C0 E9 1E 02 00 00 E9 51 FE FF FF 83 3D ?? ?? ?? ?? 02 0F 85 A4 01 00 00 83 7D 0C E0 77 1A 83 7D 0C 00 76 0D 8B 45 0C 83 C0 0F 24 F0 89 45 0C EB 07 C7 45 0C 10 00 00 00 C7 45 F4 00 00 00 00 83 7D 0C E0 0F 87 43 01 00 00 8D 4D EC 51 8D 55 E0 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 89 45 E8 83 7D E8 00 0F 84 08 01 00 00 8B 4D 0C 3B 0D ?? ?? ?? ?? 0F 83 8A 00 00 00 8B 55 0C C1 EA 04 52 8B 45 E8 50 8B 4D EC 51 8B 55 E0 52 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 08 8B 45 08 89 45 F4 EB 63 8B 4D 0C C1 E9 04 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 F4 83 7D F4 00 74 4B 8B 55 E8 33 C0 8A 02 C1 E0 04 89 45 E4 8B 4D E4 3B 4D 0C 73 08 8B 55 E4 89 55 D4 EB 06 8B 45 0C 89 45 D4 8B 4D D4 51 8B 55 08 52 8B 45 F4 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D E8 51 8B 55 EC 52 8B 45 E0 50 E8 ?? ?? ?? ?? 83 C4 0C 83 7D F4 00 75 67 8B 4D 0C 51 6A 00 8B 15 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 89 45 F4 83 7D F4 00 74 4B 8B 45 E8 33 C9 8A 08 C1 E1 04 89 4D E4 8B 55 E4 3B 55 0C 73 08 8B 45 E4 89 45 D0 EB 06 8B 4D 0C 89 4D D0 8B 55 D0 52 8B 45 08 50 8B 4D F4 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 E8 52 8B 45 EC 50 8B 4D E0 51 E8 ?? ?? ?? ?? 83 C4 0C EB 1A 8B 55 0C 52 8B 45 08 50 6A 00 8B 0D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 89 45 F4 83 7D F4 00 75 09 83 3D ?? ?? ?? ?? 00 75 08 8B 45 F4 E9 81 00 00 00 8B 55 0C 52 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 04 33 C0 EB 6D E9 7C FE FF FF C7 45 F4 00 00 00 00 83 7D 0C E0 77 31 83 7D 0C 00 75 07 C7 45 0C 01 00 00 00 8B 45 0C 83 C0 0F 24 F0 89 45 0C 8B 4D 0C 51 8B 55 08 52 6A 00 A1 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 89 45 F4 83 7D F4 00 75 09 83 3D ?? ?? ?? ?? 00 75 05 8B 45 F4 EB 16 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 04 33 C0 EB 02 EB 98 8B E5 5D C3 }
	condition:
		$1
}

rule file_235_0_0 {
	meta:
		name = "__wwincmdln"
		size = 152
		refs = "0005 __wcmdln"
	strings:
		$1 = { 55 8B EC 51 A1 ?? ?? ?? ?? 89 45 FC 8B 4D FC 33 D2 66 8B 11 83 FA 22 75 3C 8B 45 FC 83 C0 02 89 45 FC 8B 4D FC 33 D2 66 8B 11 83 FA 22 74 0E 8B 45 FC 33 C9 66 8B 08 85 C9 74 02 EB DC 8B 55 FC 33 C0 66 8B 02 83 F8 22 75 09 8B 4D FC 83 C1 02 89 4D FC EB 18 8B 55 FC 33 C0 66 8B 02 83 F8 20 7E 0B 8B 4D FC 83 C1 02 89 4D FC EB E8 8B 55 FC 33 C0 66 8B 02 85 C0 74 18 8B 4D FC 33 D2 66 8B 11 83 FA 20 7F 0B 8B 45 FC 83 C0 02 89 45 FC EB DC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_237_0_0 {
	meta:
		name = "__fsqrt"
		size = 27
	strings:
		$1 = { 55 8B EC 83 EC 08 53 56 57 DD 45 08 D9 FA DD 5D F8 DD 45 F8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_238_0_0 {
	meta:
		name = "_strncat"
		size = 27
	strings:
		$1 = { 8B 4C 24 0C 57 85 C9 0F 84 A7 00 00 00 8B 7C 24 08 56 F7 C7 03 00 00 00 53 74 0F }
	condition:
		$1
}

rule file_238_2_0 {
	meta:
		name = "find_end_of_front_string_loop"
		size = 49
	strings:
		$1 = { 8B 07 BA FF FE FE 7E 03 D0 83 F0 FF 33 C2 83 C7 04 A9 00 01 01 81 74 E8 8B 47 FC 84 C0 74 1F 84 E4 74 16 A9 00 00 FF 00 74 0A A9 00 00 00 FF 75 CF }
	condition:
		$1
}

rule file_238_7_0 {
	meta:
		name = "copy_start"
		size = 21
	strings:
		$1 = { 8B 74 24 14 F7 C6 03 00 00 00 75 09 8B D9 C1 E9 02 75 4E EB 1C }
	condition:
		$1
}

rule file_238_8_0 {
	meta:
		name = "back_misaligned"
		size = 28
	strings:
		$1 = { 8A 16 46 84 D2 74 33 88 17 47 49 74 23 F7 C6 03 00 00 00 75 EB 8B D9 C1 E9 02 75 30 }
	condition:
		$1
}

rule file_238_16_0 {
	meta:
		name = "main_loop_entrance"
		size = 50
	strings:
		$1 = { BA FF FE FE 7E 8B 06 03 D0 83 F0 FF 33 C2 8B 16 83 C6 04 A9 00 01 01 81 74 DE 84 D2 74 D0 84 F6 74 2A F7 C2 00 00 FF 00 74 12 F7 C2 00 00 00 FF 75 C6 }
	condition:
		$1
}

rule file_238_18_0 {
	meta:
		name = "byte_2"
		size = 16
	strings:
		$1 = { 66 89 17 33 D2 8B 44 24 10 88 57 02 5B 5E 5F C3 }
	condition:
		$1
}

rule file_240_0_0 {
	meta:
		name = "__itoa"
		size = 66
		refs = "001e _xtoa"
	strings:
		$1 = { 55 8B EC 83 7D 10 0A 75 1E 83 7D 08 00 7D 18 6A 01 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 EB 16 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 8B 45 0C 5D C3 }
	condition:
		$1
}

rule file_240_1_0 {
	meta:
		name = "_xtoa"
		size = 194
	strings:
		$1 = { 55 8B EC 83 EC 10 8B 45 0C 89 45 FC 83 7D 14 00 74 17 8B 4D FC C6 01 2D 8B 55 FC 83 C2 01 89 55 FC 8B 45 08 F7 D8 89 45 08 8B 4D FC 89 4D F8 8B 45 08 33 D2 F7 75 10 89 55 F4 8B 45 08 33 D2 F7 75 10 89 45 08 83 7D F4 09 76 16 8B 55 F4 83 C2 57 8B 45 FC 88 10 8B 4D FC 83 C1 01 89 4D FC EB 14 8B 55 F4 83 C2 30 8B 45 FC 88 10 8B 4D FC 83 C1 01 89 4D FC 83 7D 08 00 77 B4 8B 55 FC C6 02 00 8B 45 FC 83 E8 01 89 45 FC 8B 4D FC 8A 11 88 55 F0 8B 45 FC 8B 4D F8 8A 11 88 10 8B 45 F8 8A 4D F0 88 08 8B 55 FC 83 EA 01 89 55 FC 8B 45 F8 83 C0 01 89 45 F8 8B 4D F8 3B 4D FC 72 CC 8B E5 5D C3 }
	condition:
		$1
}

rule file_240_2_0 {
	meta:
		name = "__ltoa"
		size = 63
		refs = "0031 _xtoa"
	strings:
		$1 = { 55 8B EC 51 83 7D 10 0A 75 0F 83 7D 08 00 7D 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 45 FC 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 8B 45 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_240_3_0 {
	meta:
		name = "__ultoa"
		size = 30
		refs = "0012 _xtoa"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 8B 45 0C 5D C3 }
	condition:
		$1
}

rule file_240_4_0 {
	meta:
		name = "__i64toa"
		size = 72
		refs = "003d _x64toa@20"
	strings:
		$1 = { 55 8B EC 51 83 7D 14 0A 75 17 83 7D 0C 00 7F 11 7C 06 83 7D 08 00 73 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 45 FC 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 8B 45 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_240_5_0 {
	meta:
		name = "_x64toa@20"
		size = 242
		refs = "004a __aullrem 0061 __aulldiv"
	strings:
		$1 = { 55 8B EC 83 EC 10 8B 45 10 89 45 FC 83 7D 18 00 74 22 8B 4D FC C6 01 2D 8B 55 FC 83 C2 01 89 55 FC 8B 45 08 F7 D8 8B 4D 0C 83 D1 00 F7 D9 89 45 08 89 4D 0C 8B 55 FC 89 55 F8 8B 45 14 33 C9 51 50 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 89 45 F4 8B 4D 14 33 D2 52 51 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 89 45 08 89 55 0C 83 7D F4 09 76 16 8B 55 F4 83 C2 57 8B 45 FC 88 10 8B 4D FC 83 C1 01 89 4D FC EB 14 8B 55 F4 83 C2 30 8B 45 FC 88 10 8B 4D FC 83 C1 01 89 4D FC 83 7D 0C 00 77 99 72 06 83 7D 08 00 77 91 8B 55 FC C6 02 00 8B 45 FC 83 E8 01 89 45 FC 8B 4D FC 8A 11 88 55 F0 8B 45 FC 8B 4D F8 8A 11 88 10 8B 45 F8 8A 4D F0 88 08 8B 55 FC 83 EA 01 89 55 FC 8B 45 F8 83 C0 01 89 45 F8 8B 4D F8 3B 4D FC 72 CC 8B E5 5D C2 14 00 }
	condition:
		$1
}

rule file_240_6_0 {
	meta:
		name = "__ui64toa"
		size = 31
		refs = "0016 _x64toa@20"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 8B 45 10 5D C3 }
	condition:
		$1
}

rule file_241_0_0 {
	meta:
		name = "__wspawnle"
		size = 246
		refs = "000e ??_C@_0BB@HLKL@pathname?5?$CB?$DN?5NULL?$AA@ 0017 ??_C@_09ENKL@spawnle?4c?$AA@ 001e __CrtDbgReport 003e ??_C@_0BG@FCLP@?$CKpathname?5?$CB?$DN?5_T?$CI?8?20?8?$CJ?$AA@ 0068 ??_C@_0BA@BICO@arglist?5?$CB?$DN?5NULL?$AA@ 0098 ??_C@_0BF@GGKN@?$CKarglist?5?$CB?$DN?5_T?$CI?8?20?8?$CJ?$AA@ 00e8 __wspawnve"
	strings:
		$1 = { 55 8B EC 51 53 56 57 83 7D 0C 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 37 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D6 8B 4D 0C 33 D2 66 8B 11 85 D2 75 1E 68 ?? ?? ?? ?? 6A 00 6A 38 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D0 83 7D 10 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 39 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D6 8B 55 10 33 C0 66 8B 02 85 C0 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3A 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D0 8D 55 10 89 55 FC 8B 45 FC 8B 08 8B 55 FC 83 C2 04 89 55 FC 85 C9 74 02 EB EC 8B 45 FC 8B 08 51 8D 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 10 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_242_0_0 {
	meta:
		name = "_gets"
		size = 206
		refs = "001c ??_C@_0P@OOIN@string?5?$CB?$DN?5NULL?$AA@ 0025 ??_C@_06CIMD@gets?4c?$AA@ 002c __CrtDbgReport 0040 __iob 007c __filbuf"
	strings:
		$1 = { 55 8B EC 83 EC 10 53 56 57 8B 45 08 89 45 FC 8B 4D 08 89 4D F4 83 7D 08 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 2D 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 D2 85 D2 75 D6 A1 ?? ?? ?? ?? 83 E8 01 A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 7C 21 8B 0D ?? ?? ?? ?? 0F BE 11 81 E2 FF 00 00 00 89 55 F0 A1 ?? ?? ?? ?? 83 C0 01 A3 ?? ?? ?? ?? EB 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 89 45 F0 8B 4D F0 89 4D F8 83 7D F8 0A 74 2C 83 7D F8 FF 75 13 8B 55 FC 3B 55 08 75 09 C7 45 F4 00 00 00 00 EB 1B EB 13 8B 45 FC 8A 4D F8 88 08 8B 55 FC 83 C2 01 89 55 FC EB 81 8B 45 FC C6 00 00 8B 45 F4 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_243_0_0 {
	meta:
		name = "__ismbcpunct"
		size = 239
		refs = "003c ___ismbcodepage 004d ___mblcid 0054 ___mbcodepage 0066 ___crtGetStringTypeA 00b5 __ctype 00cd __mbctype"
	strings:
		$1 = { 55 8B EC 83 EC 10 81 7D 08 FF 00 00 00 0F 86 94 00 00 00 66 C7 45 F8 00 00 33 C0 66 89 45 FA 8B 4D 08 C1 E9 08 81 E1 FF 00 00 00 88 4D FC 8B 55 08 81 E2 FF 00 00 00 88 55 FD 83 3D ?? ?? ?? ?? 00 75 07 33 C0 E9 A1 00 00 00 6A 01 A1 ?? ?? ?? ?? 50 8B 0D ?? ?? ?? ?? 51 8D 55 F8 52 6A 02 8D 45 FC 50 6A 01 E8 ?? ?? ?? ?? 83 C4 1C 85 C0 75 04 33 C0 EB 76 8B 4D FA 81 E1 FF FF 00 00 85 C9 75 19 8B 55 F8 81 E2 FF FF 00 00 83 E2 10 85 D2 74 09 C7 45 F4 01 00 00 00 EB 07 C7 45 F4 00 00 00 00 8B 45 F4 EB 44 8B 45 08 25 FF 00 00 00 33 C9 66 8B 0C 45 ?? ?? ?? ?? 83 E1 10 85 C9 75 21 8B 55 08 81 E2 FF 00 00 00 33 C0 8A 82 ?? ?? ?? ?? 83 E0 02 85 C0 75 09 C7 45 F0 00 00 00 00 EB 07 C7 45 F0 01 00 00 00 8B 45 F0 8B E5 5D C3 }
	condition:
		$1
}

rule file_244_0_0 {
	meta:
		name = "_swscanf"
		size = 185
		refs = "001c ??_C@_0P@OOIN@string?5?$CB?$DN?5NULL?$AA@ 0025 ??_C@_09NANO@swscanf?4c?$AA@ 002c __CrtDbgReport 0046 ??_C@_0P@LNLA@format?5?$CB?$DN?5NULL?$AA@ 0089 _wcslen 00a5 __winput"
	strings:
		$1 = { 55 8B EC 83 EC 2C 53 56 57 8D 45 E0 89 45 DC 8D 4D 10 89 4D D4 83 7D 08 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 43 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 D2 85 D2 75 D6 83 7D 0C 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 44 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D6 8B 4D DC C7 41 0C 49 00 00 00 8B 55 DC 8B 45 08 89 42 08 8B 4D DC 8B 55 08 89 11 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 D1 E0 8B 4D DC 89 41 04 8B 55 D4 52 8B 45 0C 50 8B 4D DC 51 E8 ?? ?? ?? ?? 83 C4 0C 89 45 D8 8B 45 D8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_245_0_0 {
	meta:
		name = "__cenvarg"
		size = 946
		refs = "002b _strlen 004f ??_C@_09MOBB@cenvarg?4c?$AA@ 005a __malloc_dbg 0079 _errno 0083 __doserrno 00f6 __aenvptr 00fe ___crtGetEnvironmentStringsA 0208 __free_dbg 0260 _strcpy 030f _memcpy"
	strings:
		$1 = { 55 8B EC 83 EC 30 8B 45 08 89 45 E4 C7 45 F8 02 00 00 00 EB 27 8B 4D E4 8B 11 89 55 E0 8B 45 E0 50 8B 4D E4 83 C1 04 89 4D E4 E8 ?? ?? ?? ?? 83 C4 04 8B 55 F8 8D 44 02 01 89 45 F8 8B 4D E4 83 39 00 74 02 EB CF 8B 55 F8 89 55 FC 6A 61 68 ?? ?? ?? ?? 6A 02 8B 45 F8 50 E8 ?? ?? ?? ?? 83 C4 10 8B 4D 10 89 01 8B 55 10 83 3A 00 75 25 8B 45 14 C7 00 00 00 00 00 C7 05 ?? ?? ?? ?? 0C 00 00 00 C7 05 ?? ?? ?? ?? 08 00 00 00 83 C8 FF E9 1B 03 00 00 83 7D 0C 00 74 40 8B 4D 0C 89 4D E4 C7 45 F8 02 00 00 00 EB 27 8B 55 E4 8B 02 89 45 DC 8B 4D DC 51 8B 55 E4 83 C2 04 89 55 E4 E8 ?? ?? ?? ?? 83 C4 04 8B 4D F8 8D 54 01 01 89 55 F8 8B 45 E4 83 38 00 74 02 EB CF C7 45 E8 00 00 00 00 83 7D 0C 00 75 0E 8B 4D 14 C7 01 00 00 00 00 E9 40 01 00 00 83 3D ?? ?? ?? ?? 00 75 1B E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 75 08 83 C8 FF E9 96 02 00 00 C7 45 EC 00 00 00 00 EB 1C 8B 15 ?? ?? ?? ?? 03 55 EC 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D EC 8D 54 01 01 89 55 EC A1 ?? ?? ?? ?? 03 45 EC 0F BE 08 85 C9 74 13 8B 15 ?? ?? ?? ?? 03 55 EC 0F BE 02 83 F8 3D 74 02 EB C2 8B 4D EC 89 4D F4 8B 15 ?? ?? ?? ?? 03 55 F4 0F BE 02 83 F8 3D 75 56 8B 0D ?? ?? ?? ?? 03 4D F4 0F BE 51 01 85 D2 74 45 A1 ?? ?? ?? ?? 03 45 F4 0F BE 48 02 83 F9 3A 75 34 8B 15 ?? ?? ?? ?? 03 55 F4 0F BE 42 03 83 F8 3D 75 22 8B 4D F4 8B 15 ?? ?? ?? ?? 8D 44 0A 04 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D F4 8D 54 01 05 89 55 F4 EB 99 8B 45 F4 2B 45 EC 8B 4D F8 03 C8 89 4D F8 68 AA 00 00 00 68 ?? ?? ?? ?? 6A 02 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 10 8B 4D 14 89 01 8B 55 14 83 3A 00 75 35 6A 02 8B 45 10 8B 08 51 E8 ?? ?? ?? ?? 83 C4 08 8B 55 10 C7 02 00 00 00 00 C7 05 ?? ?? ?? ?? 0C 00 00 00 C7 05 ?? ?? ?? ?? 08 00 00 00 83 C8 FF E9 7A 01 00 00 8B 45 10 8B 08 89 4D F0 8B 55 08 89 55 E4 8B 45 E4 83 38 00 75 0B 8B 4D F0 83 C1 01 89 4D F0 EB 39 8B 55 E4 8B 02 50 8B 4D F0 51 E8 ?? ?? ?? ?? 83 C4 08 8B 55 E4 8B 02 89 45 D8 8B 4D D8 51 8B 55 E4 83 C2 04 89 55 E4 E8 ?? ?? ?? ?? 83 C4 04 8B 4D F0 8D 54 01 01 89 55 F0 8B 45 E4 83 38 00 74 48 8B 4D E4 8B 11 52 8B 45 F0 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4D E4 8B 11 89 55 D4 8B 45 D4 50 8B 4D E4 83 C1 04 89 4D E4 E8 ?? ?? ?? ?? 83 C4 04 8B 55 F0 03 D0 89 55 F0 8B 45 F0 C6 00 20 8B 4D F0 83 C1 01 89 4D F0 EB B0 8B 55 F0 C6 42 FF 00 8B 45 F0 C6 00 00 8B 4D 14 8B 11 89 55 F0 83 7D 0C 00 74 74 8B 45 F4 2B 45 EC 50 8B 0D ?? ?? ?? ?? 03 4D EC 51 8B 55 F0 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 F4 2B 45 EC 8B 4D F0 03 C8 89 4D F0 8B 55 0C 89 55 E4 8B 45 E4 83 38 00 74 3B 8B 4D E4 8B 11 52 8B 45 F0 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4D E4 8B 11 89 55 D0 8B 45 D0 50 8B 4D E4 83 C1 04 89 4D E4 E8 ?? ?? ?? ?? 83 C4 04 8B 55 F0 8D 44 02 01 89 45 F0 EB BD 83 7D F0 00 74 1F 8B 4D 14 8B 55 F0 3B 11 75 0F 8B 45 F0 C6 00 00 8B 4D F0 83 C1 01 89 4D F0 8B 55 F0 C6 02 00 6A 02 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 08 C7 05 ?? ?? ?? ?? 00 00 00 00 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_246_0_0 {
	meta:
		name = "__heapused"
		size = 17
		refs = "0005 _errno"
	strings:
		$1 = { 55 8B EC C7 05 ?? ?? ?? ?? 28 00 00 00 33 C0 5D C3 }
	condition:
		$1
}

rule file_247_0_0 {
	meta:
		name = "_abs"
		size = 33
		altNames = "_labs"
	strings:
		$1 = { 55 8B EC 51 83 7D 08 00 7C 08 8B 45 08 89 45 FC EB 08 8B 4D 08 F7 D9 89 4D FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_248_0_0 {
	meta:
		name = "_fpieee_flt_simd"
		size = 4203
		refs = "0006 $T18064 000b __except_handler3 0011 __except_list 00aa ??_C@_0BD@OECF@i386?2filter_simd?4c?$AA@ 00b1 __CrtDbgReport 01a7 $L18068 01ae $L18069 02ee _InstInfoTable5X 030d _InstInfoTableCX 032c _InstInfoTable2X 034b _InstInfoTableEX 0416 _InstInfoTableX 04e2 _modrm32 0520 _LoadOperand 076a $L18070 09be $L18071 09c5 $L18072 0ac0 $L18073 0ac7 $L18074 0bad $L18075 0bb4 $L18076 0c38 _XMMI2_FP_Emulation 0c56 _XMMI_FP_Emulation 0d9c _AdjustExceptionResult 0e4d $L18077 0e54 $L18078 0eb7 _UpdateResult 0f11 $L17348 0f15 $L17346 0f19 $L17349 0f1d $L17347 0f21 $L17345 0f25 $L17350 0ff7 $L17411 0ffb $L17412 0fff $L17413 1003 $L17414 1007 $L17429 100b $L17430 100f $L17431 1013 $L17426 1020 $L17441 1024 $L17442 1028 $L17443 102c $L17438 1039 $L17453 103d $L17454 1041 $L17455 1045 $L17450 1052 $L17478 1056 $L17479 105a $L17480 105e $L17475"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 81 C4 68 FE FF FF 53 56 57 89 65 E8 C7 85 D4 FE FF FF FF FF FF FF C7 45 DC 00 00 00 00 C7 85 88 FE FF FF 00 00 00 00 8B 45 0C 8B 08 89 8D 7C FE FF FF 8B 95 7C FE FF FF 83 C2 14 89 95 80 FE FF FF 8B 85 80 FE FF FF 83 38 00 74 14 8B 8D 80 FE FF FF 8B 11 52 FF 55 10 83 C4 04 E9 83 0E 00 00 8B 45 0C 8B 48 04 89 4D E0 8B 55 E0 8B 02 25 20 00 01 00 3D 20 00 01 00 74 34 B9 01 00 00 00 85 C9 74 1E 6A 00 6A 00 68 79 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 D2 85 D2 75 D3 33 C0 E9 35 0E 00 00 8B 45 E0 05 CC 00 00 00 89 85 8C FE FF FF 8B 8D 8C FE FF FF 8B 51 18 89 95 78 FF FF FF 8B 85 78 FF FF FF C1 E8 06 83 E0 01 85 C0 74 07 33 C0 E9 01 0E 00 00 8B 8D 8C FE FF FF 8B 51 10 89 95 C8 FE FF FF C7 85 D0 FE FF FF 00 00 00 00 C6 45 80 00 C7 45 FC 00 00 00 00 C6 85 DC FE FF FF 01 C6 85 C0 FE FF FF 00 8B 45 E0 8B 88 B8 00 00 00 89 8D 94 FE FF FF 8B 95 DC FE FF FF 81 E2 FF 00 00 00 85 D2 0F 84 B9 00 00 00 8B 85 94 FE FF FF 8A 08 88 8D D8 FE FF FF 8B 95 94 FE FF FF 83 C2 01 89 95 94 FE FF FF 8B 85 D8 FE FF FF 25 FF 00 00 00 89 85 78 FE FF FF 8B 8D 78 FE FF FF 83 E9 26 89 8D 78 FE FF FF 81 BD 78 FE FF FF CD 00 00 00 77 64 8B 85 78 FE FF FF 33 D2 8A 90 ?? ?? ?? ?? FF 24 95 ?? ?? ?? ?? C6 85 C0 FE FF FF 01 8B 4D DC 83 C1 01 89 4D DC EB 44 C7 85 D0 FE FF FF 01 00 00 00 8B 55 DC 83 C2 01 89 55 DC EB 2F C6 85 C0 FE FF FF 01 C7 85 D0 FE FF FF 01 00 00 00 8B 45 DC 83 C0 01 89 45 DC EB 13 C6 45 80 01 EB 0D C6 45 80 01 EB 07 C6 85 DC FE FF FF 00 E9 33 FF FF FF C7 45 FC FF FF FF FF EB 52 B8 01 00 00 00 C3 8B 65 E8 B9 01 00 00 00 85 C9 74 1E 6A 00 6A 00 68 E9 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 D2 85 D2 75 D3 C7 85 74 FE FF FF 00 00 00 00 C7 45 FC FF FF FF FF 8B 85 74 FE FF FF E9 98 0C 00 00 8B 45 80 25 FF 00 00 00 85 C0 74 34 B9 01 00 00 00 85 C9 74 1E 6A 00 6A 00 68 F4 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 D2 85 D2 75 D3 33 C0 E9 58 0C 00 00 C7 45 FC 01 00 00 00 8B 85 94 FE FF FF 89 85 BC FE FF FF 8B 8D D8 FE FF FF 81 E1 FF 00 00 00 83 F9 0F 74 09 C6 45 80 01 E9 68 03 00 00 8B 95 BC FE FF FF 8B 02 C1 E8 04 83 E0 0F 83 F8 05 75 0C C7 85 CC FE FF FF ?? ?? ?? ?? EB 66 8B 8D BC FE FF FF 8B 11 C1 EA 04 83 E2 0F 83 FA 0C 75 0C C7 85 CC FE FF FF ?? ?? ?? ?? EB 47 8B 85 BC FE FF FF 8B 08 C1 E9 04 83 E1 0F 83 F9 02 75 0C C7 85 CC FE FF FF ?? ?? ?? ?? EB 28 8B 95 BC FE FF FF 8B 02 C1 E8 04 83 E0 0F 83 F8 0E 75 0C C7 85 CC FE FF FF ?? ?? ?? ?? EB 09 C6 45 80 01 E9 E3 02 00 00 8B 8D BC FE FF FF 8B 11 C1 EA 0E 83 E2 03 33 C0 83 FA 03 0F 95 C0 88 85 98 FE FF FF 8B 8D BC FE FF FF 8B 11 83 E2 0F 8B 85 98 FE FF FF 25 FF 00 00 00 C1 E0 04 0B D0 89 95 90 FE FF FF 83 BD 90 FE FF FF 20 76 09 C6 45 80 01 E9 94 02 00 00 8B 8D 90 FE FF FF 8B 95 D0 FE FF FF 8D 04 4A 8B 8D CC FE FF FF 8D 14 81 89 95 84 FE FF FF 8B 85 84 FE FF FF 8B 08 81 E1 FF 0F 00 00 85 C9 75 09 C6 45 80 01 E9 5B 02 00 00 8B 95 84 FE FF FF 8B 02 C1 E8 0C 83 E0 1F 83 F8 1E 75 59 8B 8D C0 FE FF FF 81 E1 FF 00 00 00 85 C9 74 1D 8B 95 84 FE FF FF 8B 02 C1 E8 11 83 E0 1F 8D 0C 85 ?? ?? ?? ?? 89 8D 84 FE FF FF EB 1B 8B 95 84 FE FF FF 8B 02 C1 E8 11 83 E0 1F 8D 0C 85 ?? ?? ?? ?? 89 8D 84 FE FF FF C6 85 C0 FE FF FF 00 C7 85 D0 FE FF FF 02 00 00 00 8B 95 84 FE FF FF 8B 02 25 FF 0F 00 00 8B 8D C0 FE FF FF 81 E1 FF 00 00 00 03 C1 89 85 08 FF FF FF 8B 55 DC 83 C2 03 89 55 DC 8B 85 98 FE FF FF 25 FF 00 00 00 85 C0 74 68 8B 8D BC FE FF FF 89 8D 94 FE FF FF 8B 95 94 FE FF FF 83 C2 01 89 95 94 FE FF FF 8B 85 94 FE FF FF 8A 08 88 8D D8 FE FF FF 8B 95 94 FE FF FF 83 C2 01 89 95 94 FE FF FF 8B 85 94 FE FF FF 50 8B 4D E0 51 8B 95 8C FE FF FF 83 C2 10 52 8B 85 D8 FE FF FF 25 FF 00 00 00 FF 14 85 ?? ?? ?? ?? 83 C4 0C 89 85 88 FE FF FF 8B 4D E0 51 8D 95 18 FF FF FF 52 8B 85 BC FE FF FF 8B 08 C1 E9 0B 83 E1 07 51 8B 95 84 FE FF FF 8B 02 C1 E8 0C 83 E0 1F 50 8A 8D C0 FE FF FF 51 E8 ?? ?? ?? ?? 83 C4 14 8B 95 84 FE FF FF 8B 02 C1 E8 0C 83 E0 1F 83 F8 1F 75 49 8B 4D E0 51 8D 95 18 FF FF FF 52 8B 85 BC FE FF FF 8B 08 C1 E9 08 83 E1 07 51 8B 95 84 FE FF FF 8B 02 C1 E8 11 83 E0 1F 50 8A 8D C0 FE FF FF 51 E8 ?? ?? ?? ?? 83 C4 14 8B 95 50 FF FF FF 83 E2 FE 89 95 50 FF FF FF EB 38 8B 45 E0 50 8D 8D 38 FF FF FF 51 8B 95 BC FE FF FF 8B 02 C1 E8 08 83 E0 07 50 8B 8D 84 FE FF FF 8B 11 C1 EA 11 83 E2 1F 52 8A 85 C0 FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 14 8B 4D E0 51 8D 95 58 FF FF FF 52 8B 85 BC FE FF FF 8B 08 C1 E9 0B 83 E1 07 51 8B 95 84 FE FF FF 8B 02 C1 E8 19 83 E0 1F 50 8A 8D C0 FE FF FF 51 E8 ?? ?? ?? ?? 83 C4 14 8B 55 DC 03 95 88 FE FF FF 89 55 DC 8B 85 84 FE FF FF 8B 08 C1 E9 16 83 E1 07 83 F9 01 75 2B 8B 95 94 FE FF FF 03 95 88 FE FF FF 89 95 94 FE FF FF 8B 85 94 FE FF FF 33 C9 8A 08 89 8D 0C FF FF FF 8B 55 DC 83 C2 01 89 55 DC C7 45 FC FF FF FF FF EB 52 B8 01 00 00 00 C3 8B 65 E8 B8 01 00 00 00 85 C0 74 1E 6A 00 6A 00 68 A3 03 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D3 C7 85 70 FE FF FF 00 00 00 00 C7 45 FC FF FF FF FF 8B 85 70 FE FF FF E9 68 08 00 00 8B 55 80 81 E2 FF 00 00 00 85 D2 74 34 B8 01 00 00 00 85 C0 74 1E 6A 00 6A 00 68 AC 03 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D3 33 C0 E9 27 08 00 00 8B 95 8C FE FF FF 33 C0 66 8B 02 25 00 03 00 00 89 85 6C FE FF FF 83 BD 6C FE FF FF 00 74 32 81 BD 6C FE FF FF 00 02 00 00 74 1A 81 BD 6C FE FF FF 00 03 00 00 74 02 EB 22 C7 85 AC FE FF FF 00 00 00 00 EB 16 C7 85 AC FE FF FF 01 00 00 00 EB 0A C7 85 AC FE FF FF 02 00 00 00 8B 8D 8C FE FF FF 8B 51 18 89 95 78 FF FF FF 8B 85 78 FF FF FF C1 E8 0D 83 E0 03 83 E0 03 89 85 68 FE FF FF 83 BD 68 FE FF FF 03 77 3B 8B 8D 68 FE FF FF FF 24 8D ?? ?? ?? ?? C7 85 A8 FE FF FF 00 00 00 00 EB 22 C7 85 A8 FE FF FF 01 00 00 00 EB 16 C7 85 A8 FE FF FF 02 00 00 00 EB 0A C7 85 A8 FE FF FF 03 00 00 00 8B 95 78 FF FF FF 81 E2 80 1F 00 00 C1 EA 07 89 95 9C FE FF FF 8B 85 78 FF FF FF C1 E8 0F 83 E0 01 89 85 A4 FE FF FF 8B 4D E0 8B 91 C0 00 00 00 89 95 B4 FE FF FF 8B 85 0C FF FF FF 89 85 B0 FE FF FF 8D 8D A0 FE FF FF 89 8D 7C FF FF FF 8B 95 78 FF FF FF 83 E2 3F 89 95 E0 FE FF FF C7 85 E4 FE FF FF 00 00 00 00 8D 85 E4 FE FF FF 89 85 C4 FE FF FF 8B 8D 84 FE FF FF 8B 11 C1 EA 1E 83 E2 03 83 C2 01 89 55 E4 8B 85 C0 FE FF FF 25 FF 00 00 00 85 C0 74 07 C7 45 E4 01 00 00 00 C7 85 90 FE FF FF 00 00 00 00 EB 0F 8B 8D 90 FE FF FF 83 C1 01 89 8D 90 FE FF FF 8B 95 90 FE FF FF 3B 55 E4 0F 83 41 06 00 00 C7 85 A0 FE FF FF 00 00 00 00 8B 45 88 24 FE 89 45 88 8B 4D 88 83 E1 FD 89 4D 88 8B 55 88 83 E2 FB 89 55 88 8B 45 88 24 F7 89 45 88 8B 4D 88 83 E1 EF 89 4D 88 8B 55 8C 83 E2 FE 89 55 8C 8B 45 8C 24 FD 89 45 8C 8B 4D 8C 83 E1 FB 89 4D 8C 8B 55 8C 83 E2 F7 89 55 8C 8B 45 8C 24 EF 89 45 8C 8B 4D 90 83 E1 FE 89 4D 90 8B 55 90 83 E2 FD 89 55 90 8B 45 90 24 FB 89 45 90 8B 4D 90 83 E1 F7 89 4D 90 8B 55 90 83 E2 EF 89 55 90 8B 85 A8 FE FF FF 83 E0 03 8B 4D 84 83 E1 FC 0B C8 89 4D 84 8B 95 AC FE FF FF 83 E2 07 C1 E2 02 8B 45 84 24 E3 0B C2 89 45 84 8B 8D 08 FF FF FF 81 E1 FF 0F 00 00 C1 E1 05 8B 55 84 81 E2 1F 00 FE FF 0B D1 89 55 84 8B 85 30 FF FF FF 83 E0 01 83 E0 01 8B 4D A4 83 E1 FE 0B C8 89 4D A4 83 BD D0 FE FF FF 01 75 1F 8B 95 90 FE FF FF 8B 84 D5 20 FF FF FF 89 45 94 8B 8C D5 24 FF FF FF 89 4D 98 E9 97 00 00 00 83 BD D0 FE FF FF 00 75 12 8B 95 90 FE FF FF 8B 84 95 20 FF FF FF 89 45 94 EB 7C 8B 8D 08 FF FF FF 89 8D 64 FE FF FF 8B 95 64 FE FF FF 83 EA 59 89 95 64 FE FF FF 83 BD 64 FE FF FF 08 77 58 8B 8D 64 FE FF FF 33 C0 8A 81 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 8B 95 90 FE FF FF 8B 84 95 20 FF FF FF 33 C9 89 45 94 89 4D 98 EB 2C 8B 95 90 FE FF FF 8B 84 95 20 FF FF FF 89 45 94 EB 1A 8B 8D 90 FE FF FF 8B 94 CD 20 FF FF FF 89 55 94 8B 84 CD 24 FF FF FF 89 45 98 8B 8D 30 FF FF FF D1 E9 83 E1 0F 83 E1 0F D1 E1 8B 55 A4 83 E2 E1 0B D1 89 55 A4 8B 85 50 FF FF FF 83 E0 01 85 C0 0F 84 F2 00 00 00 8B 8D 50 FF FF FF 83 E1 01 83 E1 01 8B 55 BC 83 E2 FE 0B D1 89 55 BC 83 BD D0 FE FF FF 01 75 1F 8B 85 90 FE FF FF 8B 8C C5 40 FF FF FF 89 4D AC 8B 94 C5 44 FF FF FF 89 55 B0 E9 97 00 00 00 83 BD D0 FE FF FF 00 75 12 8B 85 90 FE FF FF 8B 8C 85 40 FF FF FF 89 4D AC EB 7C 8B 95 08 FF FF FF 89 95 60 FE FF FF 8B 85 60 FE FF FF 83 E8 59 89 85 60 FE FF FF 83 BD 60 FE FF FF 08 77 58 8B 95 60 FE FF FF 33 C9 8A 8A ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? 8B 85 90 FE FF FF 8B 8C 85 40 FF FF FF 33 D2 89 4D AC 89 55 B0 EB 2C 8B 85 90 FE FF FF 8B 8C 85 40 FF FF FF 89 4D AC EB 1A 8B 95 90 FE FF FF 8B 84 D5 40 FF FF FF 89 45 AC 8B 8C D5 44 FF FF FF 89 4D B0 8B 95 50 FF FF FF D1 EA 83 E2 0F 83 E2 0F D1 E2 8B 45 BC 24 E1 0B C2 89 45 BC EB 09 8B 4D BC 83 E1 FE 89 4D BC 8B 55 D4 83 E2 FE 89 55 D4 83 BD D0 FE FF FF 01 75 1F 8B 85 90 FE FF FF 8B 8C C5 60 FF FF FF 89 4D C4 8B 94 C5 64 FF FF FF 89 55 C8 E9 97 00 00 00 83 BD D0 FE FF FF 00 75 12 8B 85 90 FE FF FF 8B 8C 85 60 FF FF FF 89 4D C4 EB 7C 8B 95 08 FF FF FF 89 95 5C FE FF FF 8B 85 5C FE FF FF 83 E8 59 89 85 5C FE FF FF 83 BD 5C FE FF FF 08 77 58 8B 95 5C FE FF FF 33 C9 8A 8A ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? 8B 85 90 FE FF FF 8B 8C 85 60 FF FF FF 33 D2 89 4D C4 89 55 C8 EB 2C 8B 85 90 FE FF FF 8B 8C 85 60 FF FF FF 89 4D C4 EB 1A 8B 95 90 FE FF FF 8B 84 D5 60 FF FF FF 89 45 C4 8B 8C D5 64 FF FF FF 89 4D C8 8B 95 70 FF FF FF D1 EA 83 E2 0F 83 E2 0F D1 E2 8B 45 D4 24 E1 0B C2 89 45 D4 8D 4D 84 89 8D B8 FE FF FF 83 BD D0 FE FF FF 01 74 09 83 BD D0 FE FF FF 02 75 1E 8D 95 9C FE FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 8B 8D 90 FE FF FF 89 84 8D E8 FE FF FF EB 1C 8D 95 9C FE FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 8B 8D 90 FE FF FF 89 84 8D E8 FE FF FF 8B 95 90 FE FF FF 8B 85 A0 FE FF FF 89 84 95 F8 FE FF FF 8B 8D 90 FE FF FF 83 BC 8D E8 FE FF FF 01 0F 85 12 01 00 00 8B 95 7C FF FF FF 8B 02 C1 E8 05 83 E0 01 85 C0 74 13 8B 8D C4 FE FF FF 8B 11 83 CA 20 8B 85 C4 FE FF FF 89 10 8B 8D 7C FF FF FF 8B 11 C1 EA 04 83 E2 01 85 D2 74 13 8B 85 C4 FE FF FF 8B 08 83 C9 10 8B 95 C4 FE FF FF 89 0A 8B 85 7C FF FF FF 8B 08 C1 E9 03 83 E1 01 85 C9 74 12 8B 95 C4 FE FF FF 8B 02 0C 08 8B 8D C4 FE FF FF 89 01 8B 95 7C FF FF FF 8B 02 C1 E8 02 83 E0 01 85 C0 74 13 8B 8D C4 FE FF FF 8B 11 83 CA 04 8B 85 C4 FE FF FF 89 10 8B 8D 7C FF FF FF 8B 11 D1 EA 83 E2 01 85 D2 74 13 8B 85 C4 FE FF FF 8B 08 83 C9 02 8B 95 C4 FE FF FF 89 0A 8B 85 7C FF FF FF 8B 08 83 E1 01 85 C9 74 12 8B 95 C4 FE FF FF 8B 02 0C 01 8B 8D C4 FE FF FF 89 01 8D 55 84 52 FF 55 10 83 C4 04 89 85 D4 FE FF FF 83 BD D4 FE FF FF FF 74 0B 8B 85 D4 FE FF FF E9 73 01 00 00 8D 85 9C FE FF FF 50 8B 8D 08 FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 08 8B 55 D4 83 E2 01 83 E2 01 8B 85 70 FF FF FF 24 FE 0B C2 89 85 70 FF FF FF 8B 8D B4 FE FF FF 89 8D 10 FF FF FF 8B 95 70 FF FF FF 83 E2 01 85 D2 0F 84 C6 00 00 00 83 BD D0 FE FF FF 01 75 1F 8B 85 90 FE FF FF 8B 4D C4 89 8C C5 60 FF FF FF 8B 55 C8 89 94 C5 64 FF FF FF E9 9E 00 00 00 83 BD D0 FE FF FF 00 75 15 8B 85 90 FE FF FF 8B 4D C4 89 8C 85 60 FF FF FF E9 80 00 00 00 8B 95 08 FF FF FF 89 95 58 FE FF FF 8B 85 58 FE FF FF 83 E8 59 89 85 58 FE FF FF 83 BD 58 FE FF FF 08 77 5C 8B 95 58 FE FF FF 33 C9 8A 8A ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? 8B 85 90 FE FF FF 8B 4D C4 33 D2 89 8C C5 60 FF FF FF 89 94 C5 64 FF FF FF EB 2C 8B 85 90 FE FF FF 8B 4D C4 89 8C 85 60 FF FF FF EB 1A 8B 95 90 FE FF FF 8B 45 C4 89 84 D5 60 FF FF FF 8B 4D C8 89 8C D5 64 FF FF FF E9 A1 F9 FF FF 8B 95 10 FF FF FF 52 8B 45 E0 50 8D 8D 58 FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 E0 8B 82 B8 00 00 00 89 85 94 FE FF FF 8B 8D 94 FE FF FF 03 4D DC 89 8D 94 FE FF FF 8B 55 E0 8B 85 94 FE FF FF 89 82 B8 00 00 00 8B 8D 8C FE FF FF 8B 95 C8 FE FF FF 89 51 10 8B 85 D4 FE FF FF 8B 4D F0 64 89 0D ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 05 05 05 05 05 05 05 00 05 05 05 05 05 05 05 00 05 05 05 05 05 05 05 00 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 00 00 01 02 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 05 02 05 03 04 ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_248_1_0 {
	meta:
		name = "_LoadOperand"
		size = 1199
		refs = "011a $L18082 03c2 $L18083 043f $L17543 0443 $L17516 044b $L17533 044f $L17531 0453 $L17529 0457 $L17525 0467 $L17521 046b $L17523 046f $L17541 0473 $L17535 047b $L17537 0483 $L17527 0487 $L17519 048b $L17539 048f $L17548 0493 $L17549 0497 $L17550 049b $L17551 049f $L17545 04a3 $L17553 04a7 $L17554 04ab $L17555"
	strings:
		$1 = { 55 8B EC 83 EC 20 8B 45 14 8B 4D 0C 89 08 8B 55 14 83 3A 1F 75 14 8B 45 14 8B 48 18 83 E1 FE 8B 55 14 89 4A 18 E9 11 04 00 00 83 7D 0C 15 74 12 83 7D 0C 14 74 0C 83 7D 0C 17 74 06 83 7D 0C 1B 75 26 8B 45 08 25 FF 00 00 00 85 C0 74 0F 83 7D 0C 14 75 09 8B 4D 14 C7 01 08 00 00 00 8B 55 14 8B 45 10 89 42 04 EB 4F 8B 4D 08 81 E1 FF 00 00 00 85 C9 74 42 83 7D 0C 1F 74 3C 83 7D 0C 12 75 09 8B 55 14 C7 02 0D 00 00 00 83 7D 0C 13 75 09 8B 45 14 C7 00 19 00 00 00 83 7D 0C 0E 75 09 8B 4D 14 C7 01 0D 00 00 00 83 7D 0C 0C 75 09 8B 55 14 C7 02 0B 00 00 00 8B 45 18 05 CC 00 00 00 89 45 EC C7 45 F0 00 00 00 00 EB 09 8B 4D F0 83 C1 01 89 4D F0 83 7D F0 04 73 10 8B 55 F0 8B 45 14 C7 44 90 08 00 00 00 00 EB E1 8B 4D 14 8B 51 18 83 CA 01 8B 45 14 89 50 18 8B 4D 14 8B 11 89 55 E4 8B 45 E4 83 E8 08 89 45 E4 83 7D E4 13 0F 87 27 03 00 00 8B 4D E4 FF 24 8D ?? ?? ?? ?? 8B 55 14 8B 42 18 24 E1 0C 0A 8B 4D 14 89 41 18 8B 55 EC 8B 42 10 8B 4D 14 83 C1 08 8B 10 89 11 8B 50 04 89 51 04 8B 50 08 89 51 08 8B 40 0C 89 41 0C E9 E6 02 00 00 8B 4D 14 8B 51 18 83 E2 E1 8B 45 14 89 50 18 8B 4D EC 8B 51 10 8B 45 14 83 C0 08 8B 0A 89 08 8B 4A 04 89 48 04 8B 4A 08 89 48 08 8B 52 0C 89 50 0C E9 B0 02 00 00 8B 45 14 8B 48 18 83 E1 E1 83 C9 02 8B 55 14 89 4A 18 8B 45 EC 8B 48 10 8B 55 14 83 C2 08 8B 01 89 02 8B 41 04 89 42 04 8B 41 08 89 42 08 8B 49 0C 89 4A 0C E9 77 02 00 00 8B 55 14 8B 42 18 24 E1 8B 4D 14 89 41 18 8B 55 EC 8B 42 10 8B 08 8B 50 04 8B 45 14 89 48 08 89 50 0C E9 50 02 00 00 8B 4D 14 8B 51 18 83 E2 E1 83 CA 02 8B 45 14 89 50 18 8B 4D EC 8B 51 10 8B 02 8B 4A 04 8B 55 14 89 42 08 89 4A 0C E9 25 02 00 00 8B 45 14 8B 48 18 83 E1 E1 8B 55 14 89 4A 18 8B 45 EC 8B 48 10 8B 55 14 8B 01 89 42 08 E9 03 02 00 00 8B 4D 14 8B 51 18 83 E2 E1 83 CA 0A 8B 45 14 89 50 18 8B 4D EC 8B 51 10 8B 02 8B 4A 04 8B 55 14 89 42 08 89 4A 0C E9 D8 01 00 00 8B 45 14 8B 48 18 83 E1 E1 83 C9 0A 8B 55 14 89 4A 18 8B 45 EC 8B 48 10 8B 55 14 8B 01 89 42 08 E9 B3 01 00 00 8B 4D EC 81 C1 A0 00 00 00 89 4D FC 8B 55 14 8B 42 18 24 E1 8B 4D 14 89 41 18 8B 55 10 C1 E2 04 8B 45 FC 03 C2 89 45 F8 8B 4D F8 8B 55 14 83 C2 08 8B 01 89 02 8B 41 04 89 42 04 8B 41 08 89 42 08 8B 49 0C 89 4A 0C E9 67 01 00 00 8B 55 EC 81 C2 A0 00 00 00 89 55 FC 8B 45 14 8B 48 18 83 E1 E1 83 C9 02 8B 55 14 89 4A 18 8B 45 10 C1 E0 04 8B 4D FC 03 C8 89 4D F8 8B 55 F8 8B 45 14 83 C0 08 8B 0A 89 08 8B 4A 04 89 48 04 8B 4A 08 89 48 08 8B 52 0C 89 50 0C E9 17 01 00 00 8B 45 EC 05 A0 00 00 00 89 45 FC 8B 4D 14 8B 51 18 83 E2 E1 83 CA 0A 8B 45 14 89 50 18 8B 4D 10 C1 E1 04 8B 55 FC 03 D1 89 55 F8 8B 45 14 8B 4D F8 8B 11 89 50 08 E9 DC 00 00 00 8B 45 EC 83 C0 20 89 45 F4 8B 4D 14 8B 51 18 83 E2 E1 83 CA 0A 8B 45 14 89 50 18 8B 4D 10 C1 E1 04 8B 55 F4 03 D1 89 55 E8 8B 45 E8 8B 08 8B 50 04 8B 45 14 89 48 08 89 50 0C E9 9D 00 00 00 8B 4D 14 8B 51 18 83 E2 E1 83 CA 0A 8B 45 14 89 50 18 8B 4D 10 89 4D E0 83 7D E0 07 77 7F 8B 55 E0 FF 24 95 ?? ?? ?? ?? 8B 45 14 8B 4D 18 8B 91 B0 00 00 00 89 50 08 EB 64 8B 45 14 8B 4D 18 8B 91 AC 00 00 00 89 50 08 EB 53 8B 45 14 8B 4D 18 8B 91 A8 00 00 00 89 50 08 EB 42 8B 45 14 8B 4D 18 8B 91 A4 00 00 00 89 50 08 EB 31 8B 45 14 8B 4D 18 8B 91 B4 00 00 00 89 50 08 EB 20 8B 45 14 8B 4D 18 8B 91 A0 00 00 00 89 50 08 EB 0F 8B 45 14 8B 4D 18 8B 91 9C 00 00 00 89 50 08 8B E5 5D C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_248_2_0 {
	meta:
		name = "_LoadImm8"
		size = 229
	strings:
		$1 = { 55 8B EC 83 EC 08 8B 45 08 89 45 FC C7 45 F8 02 00 00 00 8B 4D 08 8B 11 C1 EA 0E 83 E2 03 83 FA 03 0F 84 B0 00 00 00 8B 45 08 8B 08 C1 E9 08 83 E1 07 83 F9 04 75 09 8B 55 F8 83 C2 01 89 55 F8 8B 45 08 8B 08 C1 E9 0E 83 E1 03 85 C9 75 06 8B 55 F8 89 55 F8 8B 45 08 8B 08 C1 E9 0E 83 E1 03 83 F9 01 75 09 8B 55 F8 83 C2 01 89 55 F8 8B 45 08 8B 08 C1 E9 0E 83 E1 03 83 F9 02 75 09 8B 55 F8 83 C2 04 89 55 F8 8B 45 08 8B 08 C1 E9 0E 83 E1 03 85 C9 75 19 8B 55 08 8B 02 C1 E8 08 83 E0 07 83 F8 05 75 09 8B 4D F8 83 C1 04 89 4D F8 8B 55 08 8B 02 C1 E8 0E 83 E0 03 83 F8 01 75 18 8B 4D 08 8B 11 C1 EA 08 83 E2 07 85 D2 75 09 8B 45 F8 83 C0 01 89 45 F8 8B 4D FC 03 4D F8 33 C0 8A 01 8B E5 5D C3 }
	condition:
		$1
}

rule file_248_3_0 {
	meta:
		name = "_AdjustExceptionResult"
		size = 1108
		refs = "0053 $L18086 005a $L18087 0076 $L18088 00eb $L18089 0104 $L18090 013f $L18091 0146 $L18092 017d $L18093 01b4 $L18094 01f0 $L18095 0209 $L18096 0252 $L18097 0259 $L18098 02a1 $L18099 02e6 $L18100 0318 $L17589 031c $L17580 0320 $L17591 0324 $L17577 0344 $L17585 0348 $L17586 034c $L17587 0350 $L17588 0354 $L17594 0358 $L17601 035c $L17608 0360 $L17615 0364 $L17599 0368 $L17600 0384 $L17607 0388 $L17606 0394 $L17614 0398 $L17613 03b4 $L17620 03c0 $L17621 03d4 $L17627 03d8 $L17634 03dc $L17641 03e0 $L17648 03e4 $L17632 03e8 $L17633 0404 $L17640 0408 $L17639 0414 $L17647 0418 $L17646 0434 $L17653 0440 $L17654"
	strings:
		$1 = { 55 8B EC 83 EC 30 8B 45 0C 8B 48 1C 8B 51 50 83 E2 01 85 D2 75 05 E9 F9 02 00 00 8B 45 0C 8B 48 1C 8B 51 50 D1 EA 83 E2 0F 83 FA 07 74 05 E9 E1 02 00 00 8B 45 08 89 45 FC 8B 4D FC 83 E9 39 89 4D FC 83 7D FC 1B 0F 87 C8 02 00 00 8B 45 FC 33 D2 8A 90 ?? ?? ?? ?? FF 24 95 ?? ?? ?? ?? 8B 4D 0C 8B 51 1C 8B 42 40 89 45 F8 83 7D F8 03 77 5A 8B 4D F8 FF 24 8D ?? ?? ?? ?? 8B 55 0C 8B 42 18 25 6A F7 FF FF 0C 40 8B 4D 0C 89 41 18 EB 3B 8B 55 0C 8B 42 18 25 2A F7 FF FF 8B 4D 0C 89 41 18 EB 28 8B 55 0C 8B 42 18 25 2B F7 FF FF 0C 01 8B 4D 0C 89 41 18 EB 13 8B 55 0C 8B 42 18 25 6F F7 FF FF 0C 45 8B 4D 0C 89 41 18 E9 45 02 00 00 8B 55 0C 8B 42 1C 8B 48 40 89 4D F4 83 7D F4 03 0F 87 EF 00 00 00 8B 55 F4 FF 24 95 ?? ?? ?? ?? 8B 45 0C 8B 48 14 89 4D F0 83 7D F0 07 77 26 8B 55 F0 FF 24 95 ?? ?? ?? ?? 8B 45 0C 8B 48 1C C7 41 40 FF FF FF FF EB 0D 8B 55 0C 8B 42 1C C7 40 40 00 00 00 00 E9 AB 00 00 00 8B 4D 0C 8B 51 14 89 55 EC 83 7D EC 07 77 2E 8B 4D EC 33 C0 8A 81 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 8B 55 0C 8B 42 1C C7 40 40 FF FF FF FF EB 0D 8B 4D 0C 8B 51 1C C7 42 40 00 00 00 00 EB 6C 8B 45 0C 8B 48 14 89 4D E8 83 7D E8 07 77 26 8B 55 E8 FF 24 95 ?? ?? ?? ?? 8B 45 0C 8B 48 1C C7 41 40 FF FF FF FF EB 0D 8B 55 0C 8B 42 1C C7 40 40 00 00 00 00 EB 35 8B 4D 0C 8B 51 14 89 55 E4 83 7D E4 07 77 26 8B 45 E4 FF 24 85 ?? ?? ?? ?? 8B 4D 0C 8B 51 1C C7 42 40 00 00 00 00 EB 0D 8B 45 0C 8B 48 1C C7 41 40 FF FF FF FF 8B 55 0C 8B 42 1C 8B 48 40 89 4D E0 83 7D E0 03 0F 87 2A 01 00 00 8B 55 E0 FF 24 95 ?? ?? ?? ?? 8B 45 0C 8B 48 14 89 4D DC 83 7D DC 07 77 34 8B 55 DC FF 24 95 ?? ?? ?? ?? 8B 45 0C 8B 48 1C C7 41 40 FF FF FF FF C7 41 44 FF FF FF FF EB 14 8B 55 0C 8B 42 1C C7 40 40 00 00 00 00 C7 40 44 00 00 00 00 E9 D8 00 00 00 8B 4D 0C 8B 51 14 89 55 D8 83 7D D8 07 77 3C 8B 4D D8 33 C0 8A 81 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 8B 55 0C 8B 42 1C C7 40 40 FF FF FF FF C7 40 44 FF FF FF FF EB 14 8B 4D 0C 8B 51 1C C7 42 40 00 00 00 00 C7 42 44 00 00 00 00 E9 88 00 00 00 8B 45 0C 8B 48 14 89 4D D4 83 7D D4 07 77 34 8B 55 D4 FF 24 95 ?? ?? ?? ?? 8B 45 0C 8B 48 1C C7 41 40 FF FF FF FF C7 41 44 FF FF FF FF EB 14 8B 55 0C 8B 42 1C C7 40 40 00 00 00 00 C7 40 44 00 00 00 00 EB 43 8B 4D 0C 8B 51 14 89 55 D0 83 7D D0 07 77 34 8B 45 D0 FF 24 85 ?? ?? ?? ?? 8B 4D 0C 8B 51 1C C7 42 40 00 00 00 00 C7 42 44 00 00 00 00 EB 14 8B 45 0C 8B 48 1C C7 41 40 FF FF FF FF C7 41 44 FF FF FF FF 8B E5 5D C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 01 01 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 02 02 01 01 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 01 01 01 01 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 01 01 01 01 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_248_4_0 {
	meta:
		name = "_UpdateResult"
		size = 558
		refs = "0050 $L18102 0135 $L18103 01be $L17686 01c2 $L17688 01c6 $L17671 01ca $L17682 01ce $L17680 01d2 $L17678 01d6 $L17676 01e6 $L17674 01ee $L17685 01f2 $L17684 020e $L17691 0212 $L17692 0216 $L17693 021a $L17694 0222 $L17696 0226 $L17697 022a $L17698"
	strings:
		$1 = { 55 8B EC 83 EC 1C 8B 45 08 8B 48 04 89 4D F8 8B 55 0C 81 C2 CC 00 00 00 89 55 F0 8B 45 F0 05 A0 00 00 00 89 45 FC 8B 4D F0 83 C1 20 89 4D F4 8B 55 08 8B 02 89 45 E8 8B 4D E8 83 E9 08 89 4D E8 83 7D E8 13 0F 87 70 01 00 00 8B 55 E8 FF 24 95 ?? ?? ?? ?? 8B 45 08 83 C0 08 8B 4D F0 8B 51 10 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C E9 3F 01 00 00 8B 4D 08 8B 51 08 8B 41 0C 8B 4D F0 8B 49 10 89 11 89 41 04 E9 26 01 00 00 8B 55 F0 8B 42 10 8B 4D 08 8B 51 08 89 10 E9 13 01 00 00 8B 45 08 8B 48 08 8B 50 0C 8B 45 F0 8B 40 10 89 08 89 50 04 E9 FA 00 00 00 8B 4D F0 8B 51 10 8B 45 08 8B 48 08 89 0A E9 E7 00 00 00 8B 55 08 83 C2 08 8B 45 F8 C1 E0 04 8B 4D FC 03 C8 8B 02 89 01 8B 42 04 89 41 04 8B 42 08 89 41 08 8B 52 0C 89 51 0C E9 BB 00 00 00 8B 45 F8 C1 E0 04 8B 4D F4 03 C8 89 4D EC 8B 55 08 8B 42 08 8B 4A 0C 8B 55 EC 89 02 89 4A 04 E9 97 00 00 00 8B 45 F8 89 45 E4 83 7D E4 07 77 7F 8B 4D E4 FF 24 8D ?? ?? ?? ?? 8B 55 0C 8B 45 08 8B 48 08 89 8A B0 00 00 00 EB 64 8B 55 0C 8B 45 08 8B 48 08 89 8A AC 00 00 00 EB 53 8B 55 0C 8B 45 08 8B 48 08 89 8A A8 00 00 00 EB 42 8B 55 0C 8B 45 08 8B 48 08 89 8A A4 00 00 00 EB 31 8B 55 0C 8B 45 08 8B 48 08 89 8A B4 00 00 00 EB 20 8B 55 0C 8B 45 08 8B 48 08 89 8A A0 00 00 00 EB 0F 8B 55 0C 8B 45 08 8B 48 08 89 8A 9C 00 00 00 8B 55 0C 8B 45 10 89 82 C0 00 00 00 8B E5 5D C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_248_5_0 {
	meta:
		name = "_ValidateResult"
		size = 267
		refs = "00e7 ??_C@_0BD@OECF@i386?2filter_simd?4c?$AA@ 00ee __CrtDbgReport"
	strings:
		$1 = { 55 8B EC 83 EC 0C 53 56 57 C6 45 F8 00 8B 45 08 89 45 FC 8B 4D 08 83 C1 04 89 4D F4 8B 55 FC 8B 02 83 E0 01 8B 4D F4 8B 11 83 E2 01 3B C2 74 04 C6 45 F8 01 8B 45 FC 8B 08 D1 E9 83 E1 01 8B 55 F4 8B 02 D1 E8 83 E0 01 3B C8 74 04 C6 45 F8 01 8B 4D FC 8B 11 C1 EA 02 83 E2 01 8B 45 F4 8B 08 C1 E9 02 83 E1 01 3B D1 74 04 C6 45 F8 01 8B 55 FC 8B 02 C1 E8 03 83 E0 01 8B 4D F4 8B 11 C1 EA 03 83 E2 01 3B C2 74 04 C6 45 F8 01 8B 45 FC 8B 08 C1 E9 04 83 E1 01 8B 55 F4 8B 02 C1 E8 04 83 E0 01 3B C8 74 04 C6 45 F8 01 8B 4D FC 8B 11 C1 EA 05 83 E2 01 8B 45 F4 8B 08 C1 E9 05 83 E1 01 3B D1 74 04 C6 45 F8 01 8B 45 F8 25 FF 00 00 00 85 C0 74 2D B9 01 00 00 00 85 C9 74 1E 6A 00 6A 00 68 5E 07 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 D2 85 D2 75 D3 8A 45 F8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_248_6_0 {
	meta:
		name = "_ax0"
		size = 21
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 4D 0C 8B 91 B0 00 00 00 89 10 33 C0 5D C3 }
	condition:
		$1
}

rule file_248_7_0 {
	meta:
		name = "_ax8"
		size = 33
	strings:
		$1 = { 55 8B EC 8B 45 10 33 C9 8A 08 8B 55 0C 8B 82 B0 00 00 00 03 C1 8B 4D 08 89 01 B8 01 00 00 00 5D C3 }
	condition:
		$1
}

rule file_248_8_0 {
	meta:
		name = "_ax32"
		size = 29
	strings:
		$1 = { 55 8B EC 8B 45 0C 8B 88 B0 00 00 00 8B 55 10 03 0A 8B 45 08 89 08 B8 04 00 00 00 5D C3 }
	condition:
		$1
}

rule file_248_9_0 {
	meta:
		name = "_cx0"
		size = 21
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 4D 0C 8B 91 AC 00 00 00 89 10 33 C0 5D C3 }
	condition:
		$1
}

rule file_248_10_0 {
	meta:
		name = "_cx8"
		size = 33
	strings:
		$1 = { 55 8B EC 8B 45 10 33 C9 8A 08 8B 55 0C 8B 82 AC 00 00 00 03 C1 8B 4D 08 89 01 B8 01 00 00 00 5D C3 }
	condition:
		$1
}

rule file_248_11_0 {
	meta:
		name = "_cx32"
		size = 29
	strings:
		$1 = { 55 8B EC 8B 45 0C 8B 88 AC 00 00 00 8B 55 10 03 0A 8B 45 08 89 08 B8 04 00 00 00 5D C3 }
	condition:
		$1
}

rule file_248_12_0 {
	meta:
		name = "_dx0"
		size = 21
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 4D 0C 8B 91 A8 00 00 00 89 10 33 C0 5D C3 }
	condition:
		$1
}

rule file_248_13_0 {
	meta:
		name = "_dx8"
		size = 33
	strings:
		$1 = { 55 8B EC 8B 45 10 33 C9 8A 08 8B 55 0C 8B 82 A8 00 00 00 03 C1 8B 4D 08 89 01 B8 01 00 00 00 5D C3 }
	condition:
		$1
}

rule file_248_14_0 {
	meta:
		name = "_dx32"
		size = 29
	strings:
		$1 = { 55 8B EC 8B 45 0C 8B 88 A8 00 00 00 8B 55 10 03 0A 8B 45 08 89 08 B8 04 00 00 00 5D C3 }
	condition:
		$1
}

rule file_248_15_0 {
	meta:
		name = "_bx0"
		size = 21
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 4D 0C 8B 91 A4 00 00 00 89 10 33 C0 5D C3 }
	condition:
		$1
}

rule file_248_16_0 {
	meta:
		name = "_bx8"
		size = 33
	strings:
		$1 = { 55 8B EC 8B 45 10 33 C9 8A 08 8B 55 0C 8B 82 A4 00 00 00 03 C1 8B 4D 08 89 01 B8 01 00 00 00 5D C3 }
	condition:
		$1
}

rule file_248_17_0 {
	meta:
		name = "_bx32"
		size = 29
	strings:
		$1 = { 55 8B EC 8B 45 0C 8B 88 A4 00 00 00 8B 55 10 03 0A 8B 45 08 89 08 B8 04 00 00 00 5D C3 }
	condition:
		$1
}

rule file_248_18_0 {
	meta:
		name = "_sib0"
		size = 543
		refs = "0053 $L18118 0136 $L18119 01df $L17831 01e3 $L17832 01e7 $L17833 01eb $L17834 01ef $L17835 01f3 $L17836 01f7 $L17837 01fb $L17838 01ff $L17848 0203 $L17849 0207 $L17850 020b $L17851 020f $L17852 0213 $L17853 0217 $L17854 021b $L17855"
	strings:
		$1 = { 55 8B EC 83 EC 14 8B 45 10 33 C9 8A 08 89 4D F8 8B 4D F8 C1 E9 06 BA 01 00 00 00 D3 E2 89 55 FC 8B 45 F8 C1 E8 03 83 E0 07 89 45 F4 83 7D F4 04 75 0C C7 45 F4 00 00 00 00 E9 90 00 00 00 8B 4D F4 83 E1 07 89 4D F0 83 7D F0 07 77 7A 8B 55 F0 FF 24 95 ?? ?? ?? ?? 8B 45 0C 8B 88 B0 00 00 00 89 4D F4 EB 69 8B 55 0C 8B 82 AC 00 00 00 89 45 F4 EB 5B 8B 4D 0C 8B 91 A8 00 00 00 89 55 F4 EB 4D 8B 45 0C 8B 88 A4 00 00 00 89 4D F4 EB 3F 8B 55 0C 8B 82 C4 00 00 00 89 45 F4 EB 31 8B 4D 0C 8B 91 B4 00 00 00 89 55 F4 EB 23 8B 45 0C 8B 88 A0 00 00 00 89 4D F4 EB 15 8B 55 0C 8B 82 9C 00 00 00 89 45 F4 EB 07 C7 45 F4 00 00 00 00 8B 4D F8 83 E1 07 89 4D F8 83 7D F8 05 75 1E 8B 55 F4 0F AF 55 FC 8B 45 10 8B 48 01 03 CA 8B 55 08 89 0A B8 05 00 00 00 E9 E0 00 00 00 83 7D F8 04 75 1C 8B 45 F4 0F AF 45 FC 8B 4D 0C 8B 91 C4 00 00 00 03 D0 8B 45 08 89 10 E9 B9 00 00 00 8B 4D F8 83 E1 07 89 4D EC 83 7D EC 07 0F 87 8A 00 00 00 8B 55 EC FF 24 95 ?? ?? ?? ?? 8B 45 08 8B 4D 0C 8B 91 B0 00 00 00 89 10 EB 79 8B 45 08 8B 4D 0C 8B 91 AC 00 00 00 89 10 EB 69 8B 45 08 8B 4D 0C 8B 91 A8 00 00 00 89 10 EB 59 8B 45 08 8B 4D 0C 8B 91 A4 00 00 00 89 10 EB 49 8B 45 08 8B 4D 0C 8B 91 C4 00 00 00 89 10 EB 39 8B 45 08 8B 4D 0C 8B 91 B4 00 00 00 89 10 EB 29 8B 45 08 8B 4D 0C 8B 91 A0 00 00 00 89 10 EB 19 8B 45 08 8B 4D 0C 8B 91 9C 00 00 00 89 10 EB 09 8B 45 08 C7 00 00 00 00 00 8B 4D F4 0F AF 4D FC 8B 55 08 8B 02 03 C1 8B 4D 08 89 01 B8 01 00 00 00 8B E5 5D C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_248_19_0 {
	meta:
		name = "_sib8"
		size = 525
		refs = "0053 $L18121 011a $L18122 01cd $L17874 01d1 $L17875 01d5 $L17876 01d9 $L17877 01dd $L17878 01e1 $L17879 01e5 $L17880 01e9 $L17881 01ed $L17890 01f1 $L17891 01f5 $L17892 01f9 $L17893 01fd $L17894 0201 $L17895 0205 $L17896 0209 $L17897"
	strings:
		$1 = { 55 8B EC 83 EC 14 8B 45 10 33 C9 8A 08 89 4D F8 8B 4D F8 C1 E9 06 BA 01 00 00 00 D3 E2 89 55 FC 8B 45 F8 C1 E8 03 83 E0 07 89 45 F4 83 7D F4 04 75 0C C7 45 F4 00 00 00 00 E9 90 00 00 00 8B 4D F4 83 E1 07 89 4D F0 83 7D F0 07 77 7A 8B 55 F0 FF 24 95 ?? ?? ?? ?? 8B 45 0C 8B 88 B0 00 00 00 89 4D F4 EB 69 8B 55 0C 8B 82 AC 00 00 00 89 45 F4 EB 5B 8B 4D 0C 8B 91 A8 00 00 00 89 55 F4 EB 4D 8B 45 0C 8B 88 A4 00 00 00 89 4D F4 EB 3F 8B 55 0C 8B 82 C4 00 00 00 89 45 F4 EB 31 8B 4D 0C 8B 91 B4 00 00 00 89 55 F4 EB 23 8B 45 0C 8B 88 A0 00 00 00 89 4D F4 EB 15 8B 55 0C 8B 82 9C 00 00 00 89 45 F4 EB 07 C7 45 F4 00 00 00 00 8B 4D F8 83 E1 07 89 4D F8 83 7D F8 04 75 24 8B 55 10 33 C0 8A 42 01 8B 4D 0C 03 81 C4 00 00 00 8B 55 F4 0F AF 55 FC 03 C2 8B 4D 08 89 01 E9 C3 00 00 00 8B 55 F8 83 E2 07 89 55 EC 83 7D EC 07 0F 87 8A 00 00 00 8B 45 EC FF 24 85 ?? ?? ?? ?? 8B 4D 08 8B 55 0C 8B 82 B0 00 00 00 89 01 EB 79 8B 4D 08 8B 55 0C 8B 82 AC 00 00 00 89 01 EB 69 8B 4D 08 8B 55 0C 8B 82 A8 00 00 00 89 01 EB 59 8B 4D 08 8B 55 0C 8B 82 A4 00 00 00 89 01 EB 49 8B 4D 08 8B 55 0C 8B 82 C4 00 00 00 89 01 EB 39 8B 4D 08 8B 55 0C 8B 82 B4 00 00 00 89 01 EB 29 8B 4D 08 8B 55 0C 8B 82 A0 00 00 00 89 01 EB 19 8B 4D 08 8B 55 0C 8B 82 9C 00 00 00 89 01 EB 09 8B 4D 08 C7 01 00 00 00 00 8B 55 10 33 C0 8A 42 01 8B 4D F4 0F AF 4D FC 03 C1 8B 55 08 8B 0A 03 C8 8B 55 08 89 0A B8 02 00 00 00 8B E5 5D C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_248_20_0 {
	meta:
		name = "_sib32"
		size = 521
		refs = "0053 $L18124 0118 $L18125 01c9 $L17917 01cd $L17918 01d1 $L17919 01d5 $L17920 01d9 $L17921 01dd $L17922 01e1 $L17923 01e5 $L17924 01e9 $L17933 01ed $L17934 01f1 $L17935 01f5 $L17936 01f9 $L17937 01fd $L17938 0201 $L17939 0205 $L17940"
	strings:
		$1 = { 55 8B EC 83 EC 14 8B 45 10 33 C9 8A 08 89 4D F8 8B 4D F8 C1 E9 06 BA 01 00 00 00 D3 E2 89 55 FC 8B 45 F8 C1 E8 03 83 E0 07 89 45 F4 83 7D F4 04 75 0C C7 45 F4 00 00 00 00 E9 90 00 00 00 8B 4D F4 83 E1 07 89 4D F0 83 7D F0 07 77 7A 8B 55 F0 FF 24 95 ?? ?? ?? ?? 8B 45 0C 8B 88 B0 00 00 00 89 4D F4 EB 69 8B 55 0C 8B 82 AC 00 00 00 89 45 F4 EB 5B 8B 4D 0C 8B 91 A8 00 00 00 89 55 F4 EB 4D 8B 45 0C 8B 88 A4 00 00 00 89 4D F4 EB 3F 8B 55 0C 8B 82 C4 00 00 00 89 45 F4 EB 31 8B 4D 0C 8B 91 B4 00 00 00 89 55 F4 EB 23 8B 45 0C 8B 88 A0 00 00 00 89 4D F4 EB 15 8B 55 0C 8B 82 9C 00 00 00 89 45 F4 EB 07 C7 45 F4 00 00 00 00 8B 4D F8 83 E1 07 89 4D F8 83 7D F8 04 75 22 8B 55 10 8B 42 01 8B 4D 0C 03 81 C4 00 00 00 8B 55 F4 0F AF 55 FC 03 C2 8B 4D 08 89 01 E9 C1 00 00 00 8B 55 F8 83 E2 07 89 55 EC 83 7D EC 07 0F 87 8A 00 00 00 8B 45 EC FF 24 85 ?? ?? ?? ?? 8B 4D 08 8B 55 0C 8B 82 B0 00 00 00 89 01 EB 79 8B 4D 08 8B 55 0C 8B 82 AC 00 00 00 89 01 EB 69 8B 4D 08 8B 55 0C 8B 82 A8 00 00 00 89 01 EB 59 8B 4D 08 8B 55 0C 8B 82 A4 00 00 00 89 01 EB 49 8B 4D 08 8B 55 0C 8B 82 C4 00 00 00 89 01 EB 39 8B 4D 08 8B 55 0C 8B 82 B4 00 00 00 89 01 EB 29 8B 4D 08 8B 55 0C 8B 82 A0 00 00 00 89 01 EB 19 8B 4D 08 8B 55 0C 8B 82 9C 00 00 00 89 01 EB 09 8B 4D 08 C7 01 00 00 00 00 8B 55 F4 0F AF 55 FC 8B 45 10 8B 48 01 03 CA 8B 55 08 8B 02 03 C1 8B 4D 08 89 01 B8 05 00 00 00 8B E5 5D C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_248_21_0 {
	meta:
		name = "_d32"
		size = 20
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 4D 10 8B 11 89 10 B8 04 00 00 00 5D C3 }
	condition:
		$1
}

rule file_248_22_0 {
	meta:
		name = "_bp8"
		size = 33
	strings:
		$1 = { 55 8B EC 8B 45 10 33 C9 8A 08 8B 55 0C 8B 82 B4 00 00 00 03 C1 8B 4D 08 89 01 B8 01 00 00 00 5D C3 }
	condition:
		$1
}

rule file_248_23_0 {
	meta:
		name = "_bp32"
		size = 29
	strings:
		$1 = { 55 8B EC 8B 45 0C 8B 88 B4 00 00 00 8B 55 10 03 0A 8B 45 08 89 08 B8 04 00 00 00 5D C3 }
	condition:
		$1
}

rule file_248_24_0 {
	meta:
		name = "_si0"
		size = 21
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 4D 0C 8B 91 A0 00 00 00 89 10 33 C0 5D C3 }
	condition:
		$1
}

rule file_248_25_0 {
	meta:
		name = "_si8"
		size = 33
	strings:
		$1 = { 55 8B EC 8B 45 10 33 C9 8A 08 8B 55 0C 8B 82 A0 00 00 00 03 C1 8B 4D 08 89 01 B8 01 00 00 00 5D C3 }
	condition:
		$1
}

rule file_248_26_0 {
	meta:
		name = "_si32"
		size = 29
	strings:
		$1 = { 55 8B EC 8B 45 0C 8B 88 A0 00 00 00 8B 55 10 03 0A 8B 45 08 89 08 B8 04 00 00 00 5D C3 }
	condition:
		$1
}

rule file_248_27_0 {
	meta:
		name = "_di0"
		size = 21
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 4D 0C 8B 91 9C 00 00 00 89 10 33 C0 5D C3 }
	condition:
		$1
}

rule file_248_28_0 {
	meta:
		name = "_di8"
		size = 33
	strings:
		$1 = { 55 8B EC 8B 45 10 33 C9 8A 08 8B 55 0C 8B 82 9C 00 00 00 03 C1 8B 4D 08 89 01 B8 01 00 00 00 5D C3 }
	condition:
		$1
}

rule file_248_29_0 {
	meta:
		name = "_di32"
		size = 29
	strings:
		$1 = { 55 8B EC 8B 45 0C 8B 88 9C 00 00 00 8B 55 10 03 0A 8B 45 08 89 08 B8 04 00 00 00 5D C3 }
	condition:
		$1
}

rule file_249_0_0 {
	meta:
		name = "_fgets"
		size = 293
		refs = "001c ??_C@_0P@OOIN@string?5?$CB?$DN?5NULL?$AA@ 0025 ??_C@_07LIGC@fgets?4c?$AA@ 002c __CrtDbgReport 0046 ??_C@_0M@KJPK@str?5?$CB?$DN?5NULL?$AA@ 00cb __filbuf"
	strings:
		$1 = { 55 8B EC 83 EC 14 53 56 57 8B 45 08 89 45 F8 8B 4D 08 89 4D F0 83 7D 08 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3B 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 D2 85 D2 75 D6 83 7D 10 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3C 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D6 83 7D 0C 00 7F 07 33 C0 E9 A8 00 00 00 8B 4D 10 89 4D FC 8B 55 0C 83 EA 01 89 55 0C 83 7D 0C 00 0F 84 86 00 00 00 8B 45 FC 8B 48 04 83 E9 01 8B 55 FC 89 4A 04 8B 45 FC 83 78 04 00 7C 1F 8B 4D FC 8B 11 0F BE 02 25 FF 00 00 00 89 45 EC 8B 4D FC 8B 11 83 C2 01 8B 45 FC 89 10 EB 0F 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 EC 8B 55 EC 89 55 F4 83 7D F4 FF 75 13 8B 45 F8 3B 45 08 75 09 C7 45 F0 00 00 00 00 EB 29 EB 21 8B 4D F8 8A 55 F4 88 11 0F BE 45 F4 8B 4D F8 83 C1 01 89 4D F8 83 F8 0A 75 02 EB 05 E9 67 FF FF FF 8B 55 F8 C6 02 00 8B 45 F0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_250_0_0 {
	meta:
		name = "__mbsncat"
		size = 333
		refs = "0014 ___ismbcodepage 0028 _strncat 0062 __ismbslead 0095 __mbctype 012b __mbsbtype"
	strings:
		$1 = { 55 8B EC 51 83 7D 10 00 75 08 8B 45 08 E9 37 01 00 00 83 3D ?? ?? ?? ?? 00 75 19 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C E9 15 01 00 00 8B 45 08 89 45 FC 8B 4D 08 33 D2 8A 11 8B 45 08 83 C0 01 89 45 08 85 D2 74 02 EB EA 8B 4D 08 83 E9 01 89 4D 08 8B 55 08 52 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 09 8B 4D 08 83 E9 01 89 4D 08 8B 55 10 8B 45 10 83 E8 01 89 45 10 85 D2 0F 84 92 00 00 00 8B 4D 0C 33 D2 8A 11 33 C0 8A 82 ?? ?? ?? ?? 83 E0 04 85 C0 74 4E 8B 4D 08 8B 55 0C 8A 02 88 01 8B 4D 08 83 C1 01 89 4D 08 8B 55 0C 83 C2 01 89 55 0C 8B 45 08 8B 4D 0C 8A 11 88 10 8B 45 08 33 C9 8A 08 8B 55 08 83 C2 01 89 55 08 8B 45 0C 83 C0 01 89 45 0C 85 C9 75 09 8B 4D 08 C6 41 FE 00 EB 30 EB 29 8B 55 08 8B 45 0C 8A 08 88 0A 8B 55 08 33 C0 8A 02 8B 4D 08 83 C1 01 89 4D 08 8B 55 0C 83 C2 01 89 55 0C 85 C0 75 02 EB 05 E9 5A FF FF FF 8B 45 08 2B 45 FC 83 E8 01 50 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 83 F8 01 75 09 8B 55 08 C6 42 FF 00 EB 06 8B 45 08 C6 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_251_0_0 {
	meta:
		name = "__strtime"
		size = 198
		refs = "000c __imp__GetLocalTime@4"
	strings:
		$1 = { 55 8B EC 83 EC 1C 8D 45 EC 50 FF 15 ?? ?? ?? ?? 8B 4D F4 81 E1 FF FF 00 00 89 4D E8 8B 55 F6 81 E2 FF FF 00 00 89 55 E4 8B 45 F8 25 FF FF 00 00 89 45 FC 8B 4D 08 C6 41 05 3A 8B 55 08 C6 42 02 3A 8B 45 08 C6 40 08 00 8B 45 E8 99 B9 0A 00 00 00 F7 F9 83 C0 30 8B 55 08 88 02 8B 45 E8 99 B9 0A 00 00 00 F7 F9 83 C2 30 8B 45 08 88 50 01 8B 45 E4 99 B9 0A 00 00 00 F7 F9 83 C0 30 8B 55 08 88 42 03 8B 45 E4 99 B9 0A 00 00 00 F7 F9 83 C2 30 8B 45 08 88 50 04 8B 45 FC 99 B9 0A 00 00 00 F7 F9 83 C0 30 8B 55 08 88 42 06 8B 45 FC 99 B9 0A 00 00 00 F7 F9 83 C2 30 8B 45 08 88 50 07 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_252_0_0 {
	meta:
		name = "__fstat"
		size = 1021
		refs = "0012 __nhandle 0027 ___pioinfo 0039 _errno 0062 __imp__GetFileType@4 012a __imp__PeekNamedPipe@24 016f __imp__GetLastError@0 0175 __dosmaperr 01d2 __imp__GetFileInformationByHandle@8 0231 __imp__FileTimeToLocalFileTime@8 0243 __imp__FileTimeToSystemTime@8 0294 ___loctotime_t"
	strings:
		$1 = { 55 8B EC 83 EC 5C C7 45 AC 00 00 00 00 8B 45 08 3B 05 ?? ?? ?? ?? 73 1F 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F 8B 04 8D ?? ?? ?? ?? 0F BE 4C D0 04 83 E1 01 85 C9 75 12 C7 05 ?? ?? ?? ?? 09 00 00 00 83 C8 FF E9 B0 03 00 00 8B 55 08 C1 FA 05 8B 45 08 83 E0 1F 8B 0C 95 ?? ?? ?? ?? 8B 14 C1 52 FF 15 ?? ?? ?? ?? 80 E4 7F 89 45 B8 83 7D B8 01 0F 84 12 01 00 00 83 7D B8 02 74 0A 83 7D B8 03 0F 85 CB 00 00 00 83 7D B8 02 75 0B 8B 45 0C 66 C7 40 06 00 20 EB 09 8B 4D 0C 66 C7 41 06 00 10 8B 55 0C 8B 45 08 89 02 8B 4D 0C 8B 55 08 89 51 10 8B 45 0C 66 C7 40 08 01 00 8B 4D 0C 66 C7 41 04 00 00 8B 55 0C 66 C7 42 0C 00 00 8B 45 0C 66 C7 40 0A 00 00 8B 4D 0C C7 41 20 00 00 00 00 8B 55 0C C7 42 1C 00 00 00 00 8B 45 0C C7 40 18 00 00 00 00 83 7D B8 02 75 0C 8B 4D 0C C7 41 14 00 00 00 00 EB 47 6A 00 8D 55 A4 52 6A 00 6A 00 6A 00 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F 8B 14 85 ?? ?? ?? ?? 8B 04 CA 50 FF 15 ?? ?? ?? ?? 89 45 A8 83 7D A8 00 74 0B 8B 4D 0C 8B 55 A4 89 51 14 EB 0A 8B 45 0C C7 40 14 00 00 00 00 E9 A5 02 00 00 83 7D B8 00 75 16 C7 05 ?? ?? ?? ?? 09 00 00 00 C7 45 AC FF FF FF FF E9 89 02 00 00 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 C7 45 AC FF FF FF FF E9 6E 02 00 00 8B 4D 0C 66 C7 41 06 00 00 8B 55 0C 66 C7 42 0C 00 00 8B 45 0C 66 C7 40 0A 00 00 8B 4D 0C 66 C7 41 04 00 00 8B 55 0C 66 C7 42 08 01 00 8D 45 BC 50 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F 8B 04 8D ?? ?? ?? ?? 8B 0C D0 51 FF 15 ?? ?? ?? ?? 85 C0 75 1B FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 C7 45 AC FF FF FF FF E9 01 02 00 00 8B 55 BC 83 E2 01 85 D2 74 15 8B 45 0C 66 8B 48 06 66 81 C9 24 01 8B 55 0C 66 89 4A 06 EB 13 8B 45 0C 66 8B 48 06 66 81 C9 B6 01 8B 55 0C 66 89 4A 06 8D 45 B0 50 8D 4D D0 51 FF 15 ?? ?? ?? ?? 85 C0 74 12 8D 55 F0 52 8D 45 B0 50 FF 15 ?? ?? ?? ?? 85 C0 75 0C C7 45 AC FF FF FF FF E9 9F 01 00 00 6A FF 8B 4D FC 81 E1 FF FF 00 00 51 8B 55 FA 81 E2 FF FF 00 00 52 8B 45 F8 25 FF FF 00 00 50 8B 4D F6 81 E1 FF FF 00 00 51 8B 55 F2 81 E2 FF FF 00 00 52 8B 45 F0 25 FF FF 00 00 50 E8 ?? ?? ?? ?? 83 C4 1C 8B 4D 0C 89 41 1C 83 7D C8 00 75 06 83 7D CC 00 74 7C 8D 55 B0 52 8D 45 C8 50 FF 15 ?? ?? ?? ?? 85 C0 74 12 8D 4D F0 51 8D 55 B0 52 FF 15 ?? ?? ?? ?? 85 C0 75 0C C7 45 AC FF FF FF FF E9 19 01 00 00 6A FF 8B 45 FC 25 FF FF 00 00 50 8B 4D FA 81 E1 FF FF 00 00 51 8B 55 F8 81 E2 FF FF 00 00 52 8B 45 F6 25 FF FF 00 00 50 8B 4D F2 81 E1 FF FF 00 00 51 8B 55 F0 81 E2 FF FF 00 00 52 E8 ?? ?? ?? ?? 83 C4 1C 8B 4D 0C 89 41 18 EB 0C 8B 55 0C 8B 45 0C 8B 48 1C 89 4A 18 83 7D C0 00 75 06 83 7D C4 00 74 7C 8D 55 B0 52 8D 45 C0 50 FF 15 ?? ?? ?? ?? 85 C0 74 12 8D 4D F0 51 8D 55 B0 52 FF 15 ?? ?? ?? ?? 85 C0 75 0C C7 45 AC FF FF FF FF E9 85 00 00 00 6A FF 8B 45 FC 25 FF FF 00 00 50 8B 4D FA 81 E1 FF FF 00 00 51 8B 55 F8 81 E2 FF FF 00 00 52 8B 45 F6 25 FF FF 00 00 50 8B 4D F2 81 E1 FF FF 00 00 51 8B 55 F0 81 E2 FF FF 00 00 52 E8 ?? ?? ?? ?? 83 C4 1C 8B 4D 0C 89 41 20 EB 0C 8B 55 0C 8B 45 0C 8B 48 1C 89 4A 20 8B 55 0C 8B 45 E0 89 42 14 8B 4D 0C 66 8B 51 06 80 CE 80 8B 45 0C 66 89 50 06 8B 4D 0C C7 01 00 00 00 00 8B 55 0C C7 42 10 00 00 00 00 8B 45 AC 8B E5 5D C3 }
	condition:
		$1
}

rule file_253_0_0 {
	meta:
		name = "?_ValidateRead@@YAHPBXI@Z"
		size = 43
		refs = "0015 __imp__IsBadReadPtr@8"
	strings:
		$1 = { 55 8B EC 51 C7 45 FC 01 00 00 00 8B 45 0C 50 8B 4D 08 51 FF 15 ?? ?? ?? ?? 85 C0 74 07 C7 45 FC 00 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_253_1_0 {
	meta:
		name = "?_ValidateWrite@@YAHPAXI@Z"
		size = 43
		refs = "0015 __imp__IsBadWritePtr@8"
	strings:
		$1 = { 55 8B EC 51 C7 45 FC 01 00 00 00 8B 45 0C 50 8B 4D 08 51 FF 15 ?? ?? ?? ?? 85 C0 74 07 C7 45 FC 00 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_253_2_0 {
	meta:
		name = "?_ValidateExecute@@YAHP6GHXZ@Z"
		size = 39
		refs = "0011 __imp__IsBadCodePtr@4"
	strings:
		$1 = { 55 8B EC 51 C7 45 FC 01 00 00 00 8B 45 08 50 FF 15 ?? ?? ?? ?? 85 C0 74 07 C7 45 FC 00 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_254_0_0 {
	meta:
		name = "__strlwr"
		size = 250
		refs = "000f ___lc_handle 0077 ___crtLCMapStringA 008c ??_C@_08FNDD@strlwr?4c?$AA@ 0097 __malloc_dbg 00de _strcpy 00ec __free_dbg"
	strings:
		$1 = { 55 8B EC 83 EC 0C C7 45 F8 00 00 00 00 83 3D ?? ?? ?? ?? 00 75 47 8B 45 08 89 45 F4 EB 09 8B 4D F4 83 C1 01 89 4D F4 8B 55 F4 0F BE 02 85 C0 74 24 8B 4D F4 0F BE 11 83 FA 41 7C 17 8B 45 F4 0F BE 08 83 F9 5A 7F 0C 8B 55 F4 8A 02 04 20 8B 4D F4 88 01 EB C9 8B 45 08 E9 99 00 00 00 6A 01 6A 00 6A 00 6A 00 6A FF 8B 55 08 52 68 00 01 00 00 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 20 89 45 FC 83 7D FC 00 75 02 EB 5C 6A 64 68 ?? ?? ?? ?? 6A 02 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 F8 83 7D F8 00 75 02 EB 3C 6A 01 6A 00 8B 55 FC 52 8B 45 F8 50 6A FF 8B 4D 08 51 68 00 01 00 00 8B 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 20 85 C0 75 02 EB 10 8B 45 F8 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 08 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_255_0_0 {
	meta:
		name = "__lseeki64"
		size = 255
		refs = "000b __nhandle 0020 ___pioinfo 0032 _errno 003c __doserrno 0060 __get_osfhandle 0094 __imp__SetFilePointer@16 00a3 __imp__GetLastError@0 00b5 __dosmaperr"
	strings:
		$1 = { 55 8B EC 83 EC 10 8B 45 08 3B 05 ?? ?? ?? ?? 73 1F 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F 8B 04 8D ?? ?? ?? ?? 0F BE 4C D0 04 83 E1 01 85 C9 75 1F C7 05 ?? ?? ?? ?? 09 00 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 83 C8 FF 83 CA FF E9 AC 00 00 00 8B 55 0C 89 55 F8 8B 45 10 89 45 FC 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 F4 83 7D F4 FF 75 12 C7 05 ?? ?? ?? ?? 09 00 00 00 83 C8 FF 83 CA FF EB 79 8B 55 14 52 8D 45 FC 50 8B 4D F8 51 8B 55 F4 52 FF 15 ?? ?? ?? ?? 89 45 F8 83 7D F8 FF 75 23 FF 15 ?? ?? ?? ?? 89 45 F0 83 7D F0 00 74 14 8B 45 F0 50 E8 ?? ?? ?? ?? 83 C4 04 83 C8 FF 83 CA FF EB 37 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F 8B 04 8D ?? ?? ?? ?? 8A 4C D0 04 80 E1 FD 8B 55 08 C1 FA 05 8B 45 08 83 E0 1F 8B 14 95 ?? ?? ?? ?? 88 4C C2 04 8B 45 F8 8B 55 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_257_0_0 {
	meta:
		name = "_system"
		size = 265
		refs = "000a ??_C@_07KFDO@COMSPEC?$AA@ 000f _getenv 0035 __access 0057 ??_C@_0BF@GFJL@?$CKcommand?5?$CB?$DN?5_T?$CI?8?20?8?$CJ?$AA@ 0060 ??_C@_08DLLJ@system?4c?$AA@ 0067 __CrtDbgReport 007d ??_C@_02JMK@?1c?$AA@ 00a1 __spawnve 00b3 _errno 00ca __osver 00db ??_C@_0M@IPJP@command?4com?$AA@ 00e4 ??_C@_07OOMJ@cmd?4exe?$AA@ 00fb __spawnvpe"
	strings:
		$1 = { 55 8B EC 83 EC 1C 53 56 57 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 89 45 F0 83 7D 08 00 75 2D 83 7D F0 00 75 09 C7 45 E8 00 00 00 00 EB 16 6A 00 8B 45 F0 50 E8 ?? ?? ?? ?? 83 C4 08 F7 D8 1B C0 40 89 45 E8 8B 45 E8 E9 B6 00 00 00 8B 4D 08 0F BE 11 85 D2 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3B 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D2 C7 45 F4 ?? ?? ?? ?? 8B 4D 08 89 4D F8 C7 45 FC 00 00 00 00 83 7D F0 00 74 34 6A 00 8D 55 F0 52 8B 45 F0 50 6A 00 E8 ?? ?? ?? ?? 83 C4 10 89 45 EC 83 7D EC FF 75 12 83 3D ?? ?? ?? ?? 02 74 0E 83 3D ?? ?? ?? ?? 0D 74 05 8B 45 EC EB 3A 8B 0D ?? ?? ?? ?? 81 E1 00 80 00 00 85 C9 74 09 C7 45 E4 ?? ?? ?? ?? EB 07 C7 45 E4 ?? ?? ?? ?? 8B 55 E4 89 55 F0 6A 00 8D 45 F0 50 8B 4D F0 51 6A 00 E8 ?? ?? ?? ?? 83 C4 10 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_258_1_0 {
	meta:
		name = "__rotl"
		size = 80
	strings:
		$1 = { 55 8B EC 83 EC 08 8B 45 08 89 45 F8 8B 4D 0C 83 E1 1F 89 4D 0C 8B 55 0C 8B 45 0C 83 E8 01 89 45 0C 85 D2 74 24 8B 4D F8 81 E1 00 00 00 80 89 4D FC 8B 55 F8 D1 E2 89 55 F8 83 7D FC 00 74 08 8B 45 F8 0C 01 89 45 F8 EB CC 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_259_0_0 {
	meta:
		name = "__stati64"
		size = 1182
		refs = "000b ??_C@_02DIIM@?$DP?$CK?$AA@ 0014 __mbspbrk 0021 _errno 002b __doserrno 0080 __mbctolower 0093 __getdrive 00aa __imp__FindFirstFileA@8 00c2 ??_C@_03MNBA@?4?1?2?$AA@ 00e7 __fullpath 0105 _strlen 0119 _IsRootUNCName 012d __imp__GetDriveTypeA@4 0189 ___loctotime_t 01c3 __imp__FileTimeToLocalFileTime@8 01db __imp__FileTimeToSystemTime@8 01e5 __imp__GetLastError@0 01eb __dosmaperr 01fb __imp__FindClose@4 0424 ___dtoxmode 044a __allmul"
	strings:
		$1 = { 55 8B EC 81 EC 68 02 00 00 56 68 ?? ?? ?? ?? 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 1C C7 05 ?? ?? ?? ?? 02 00 00 00 C7 05 ?? ?? ?? ?? 02 00 00 00 83 C8 FF E9 5E 04 00 00 8B 4D 08 0F BE 51 01 83 FA 3A 75 4B 8B 45 08 0F BE 08 85 C9 74 27 8B 55 08 0F BE 42 02 85 C0 75 1C C7 05 ?? ?? ?? ?? 02 00 00 00 C7 05 ?? ?? ?? ?? 02 00 00 00 83 C8 FF E9 21 04 00 00 8B 4D 08 0F BE 11 52 E8 ?? ?? ?? ?? 83 C4 04 83 E8 60 89 85 B0 FD FF FF EB 0B E8 ?? ?? ?? ?? 89 85 B0 FD FF FF 8D 85 C0 FE FF FF 50 8B 4D 08 51 FF 15 ?? ?? ?? ?? 89 85 B8 FE FF FF 83 BD B8 FE FF FF FF 0F 85 F2 00 00 00 68 ?? ?? ?? ?? 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 60 68 04 01 00 00 8B 45 08 50 8D 8D B4 FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 89 85 BC FE FF FF 83 BD BC FE FF FF 00 74 39 8B 95 BC FE FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 83 F8 03 74 13 8B 85 BC FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 12 8B 8D BC FE FF FF 51 FF 15 ?? ?? ?? ?? 83 F8 01 77 1C C7 05 ?? ?? ?? ?? 02 00 00 00 C7 05 ?? ?? ?? ?? 02 00 00 00 83 C8 FF E9 47 03 00 00 C7 85 C0 FE FF FF 10 00 00 00 C7 85 DC FE FF FF 00 00 00 00 C7 85 E0 FE FF FF 00 00 00 00 C6 85 EC FE FF FF 00 6A FF 6A 00 6A 00 6A 00 6A 01 6A 01 68 BC 07 00 00 E8 ?? ?? ?? ?? 83 C4 1C 8B 55 0C 89 42 24 8B 45 0C 8B 4D 0C 8B 51 24 89 50 20 8B 45 0C 8B 4D 0C 8B 51 24 89 50 28 E9 65 02 00 00 8D 85 98 FD FF FF 50 8D 8D D4 FE FF FF 51 FF 15 ?? ?? ?? ?? 85 C0 74 18 8D 95 A0 FD FF FF 52 8D 85 98 FD FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 75 24 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 8B 8D B8 FE FF FF 51 FF 15 ?? ?? ?? ?? 83 C8 FF E9 92 02 00 00 6A FF 8B 95 AC FD FF FF 81 E2 FF FF 00 00 52 8B 85 AA FD FF FF 25 FF FF 00 00 50 8B 8D A8 FD FF FF 81 E1 FF FF 00 00 51 8B 95 A6 FD FF FF 81 E2 FF FF 00 00 52 8B 85 A2 FD FF FF 25 FF FF 00 00 50 8B 8D A0 FD FF FF 81 E1 FF FF 00 00 51 E8 ?? ?? ?? ?? 83 C4 1C 8B 55 0C 89 42 24 83 BD CC FE FF FF 00 75 0D 83 BD D0 FE FF FF 00 0F 84 B2 00 00 00 8D 85 98 FD FF FF 50 8D 8D CC FE FF FF 51 FF 15 ?? ?? ?? ?? 85 C0 74 18 8D 95 A0 FD FF FF 52 8D 85 98 FD FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 75 24 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 8B 8D B8 FE FF FF 51 FF 15 ?? ?? ?? ?? 83 C8 FF E9 CC 01 00 00 6A FF 8B 95 AC FD FF FF 81 E2 FF FF 00 00 52 8B 85 AA FD FF FF 25 FF FF 00 00 50 8B 8D A8 FD FF FF 81 E1 FF FF 00 00 51 8B 95 A6 FD FF FF 81 E2 FF FF 00 00 52 8B 85 A2 FD FF FF 25 FF FF 00 00 50 8B 8D A0 FD FF FF 81 E1 FF FF 00 00 51 E8 ?? ?? ?? ?? 83 C4 1C 8B 55 0C 89 42 20 EB 0C 8B 45 0C 8B 4D 0C 8B 51 24 89 50 20 83 BD C4 FE FF FF 00 75 0D 83 BD C8 FE FF FF 00 0F 84 B2 00 00 00 8D 85 98 FD FF FF 50 8D 8D C4 FE FF FF 51 FF 15 ?? ?? ?? ?? 85 C0 74 18 8D 95 A0 FD FF FF 52 8D 85 98 FD FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 75 24 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 8B 8D B8 FE FF FF 51 FF 15 ?? ?? ?? ?? 83 C8 FF E9 F8 00 00 00 6A FF 8B 95 AC FD FF FF 81 E2 FF FF 00 00 52 8B 85 AA FD FF FF 25 FF FF 00 00 50 8B 8D A8 FD FF FF 81 E1 FF FF 00 00 51 8B 95 A6 FD FF FF 81 E2 FF FF 00 00 52 8B 85 A2 FD FF FF 25 FF FF 00 00 50 8B 8D A0 FD FF FF 81 E1 FF FF 00 00 51 E8 ?? ?? ?? ?? 83 C4 1C 8B 55 0C 89 42 28 EB 0C 8B 45 0C 8B 4D 0C 8B 51 24 89 50 28 8B 85 B8 FE FF FF 50 FF 15 ?? ?? ?? ?? 8B 4D 08 51 8B 95 C0 FE FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 8B 4D 0C 66 89 41 06 8B 55 0C 66 C7 42 08 01 00 8B 85 DC FE FF FF 33 C9 6A 01 6A 00 51 50 E8 ?? ?? ?? ?? 8B 8D E0 FE FF FF 33 F6 03 C1 13 D6 8B 4D 0C 89 41 18 89 51 1C 8B 55 0C 66 C7 42 04 00 00 8B 45 0C 66 C7 40 0C 00 00 8B 4D 0C 66 C7 41 0A 00 00 8B 95 B0 FD FF FF 83 EA 01 8B 45 0C 89 10 8B 4D 0C 8B 55 0C 8B 02 89 41 10 33 C0 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_259_1_0 {
	meta:
		name = "_IsRootUNCName"
		size = 233
		refs = "0009 _strlen"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 83 F8 05 0F 82 CA 00 00 00 8B 4D 08 0F BE 11 83 FA 5C 74 0F 8B 45 08 0F BE 08 83 F9 2F 0F 85 B0 00 00 00 8B 55 08 0F BE 42 01 83 F8 5C 74 10 8B 4D 08 0F BE 51 01 83 FA 2F 0F 85 94 00 00 00 8B 45 08 83 C0 02 89 45 FC 8B 4D FC 83 C1 01 89 4D FC 8B 55 FC 0F BE 02 85 C0 74 1A 8B 4D FC 0F BE 11 83 FA 5C 74 0B 8B 45 FC 0F BE 08 83 F9 2F 75 02 EB 02 EB D3 8B 55 FC 0F BE 02 85 C0 74 54 8B 4D FC 0F BE 51 01 85 D2 74 49 8B 45 FC 83 C0 01 89 45 FC 8B 4D FC 0F BE 11 85 D2 74 1A 8B 45 FC 0F BE 08 83 F9 5C 74 0B 8B 55 FC 0F BE 02 83 F8 2F 75 02 EB 02 EB D3 8B 4D FC 0F BE 11 85 D2 74 0B 8B 45 FC 0F BE 48 01 85 C9 75 07 B8 01 00 00 00 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_260_0_0 {
	meta:
		name = "__execle"
		size = 238
		refs = "0014 ??_C@_0BB@COCE@filename?5?$CB?$DN?5NULL?$AA@ 001d ??_C@_08PNDI@execle?4c?$AA@ 0024 __CrtDbgReport 0042 ??_C@_0BG@GALO@?$CKfilename?5?$CB?$DN?5_T?$CI?8?20?8?$CJ?$AA@ 006c ??_C@_0BA@BICO@arglist?5?$CB?$DN?5NULL?$AA@ 009a ??_C@_0BF@GGKN@?$CKarglist?5?$CB?$DN?5_T?$CI?8?20?8?$CJ?$AA@ 00e0 __execve"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8D 45 0C 89 45 FC 83 7D 08 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 33 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D6 8B 55 08 0F BE 02 85 C0 75 1E 68 ?? ?? ?? ?? 6A 00 6A 34 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D2 83 7D 0C 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 35 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 D2 85 D2 75 D6 8B 45 0C 0F BE 08 85 C9 75 1E 68 ?? ?? ?? ?? 6A 00 6A 36 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 D2 85 D2 75 D2 8B 45 FC 8B 08 8B 55 FC 83 C2 04 89 55 FC 85 C9 74 02 EB EC 8B 45 FC 8B 08 51 8D 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_261_0_0 {
	meta:
		name = "__mbsupr"
		size = 220
		refs = "0031 __mbctype 0040 ___mbcodepage 0058 ___mblcid 005e ___crtLCMapStringA 00b5 __mbcasemap"
	strings:
		$1 = { 55 8B EC 83 EC 10 8B 45 08 89 45 FC EB 09 8B 4D FC 83 C1 01 89 4D FC 8B 55 FC 33 C0 8A 02 85 C0 0F 84 AF 00 00 00 8B 4D FC 33 D2 8A 11 33 C0 8A 82 ?? ?? ?? ?? 83 E0 04 85 C0 74 57 6A 01 8B 0D ?? ?? ?? ?? 51 6A 02 8D 55 F8 52 6A 02 8B 45 FC 50 68 00 02 00 00 8B 0D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 20 89 45 F4 83 7D F4 00 75 04 33 C0 EB 66 8B 55 FC 8A 45 F8 88 02 83 7D F4 01 7E 11 8B 4D FC 83 C1 01 89 4D FC 8B 55 FC 8A 45 F9 88 02 EB 3D 8B 4D FC 33 D2 8A 11 33 C0 8A 82 ?? ?? ?? ?? 83 E0 20 83 F8 20 75 14 8B 4D FC 33 D2 8A 11 33 C0 8A 82 ?? ?? ?? ?? 89 45 F0 EB 0A 8B 4D FC 33 D2 8A 11 89 55 F0 8B 45 FC 8A 4D F0 88 08 E9 39 FF FF FF 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_262_0_0 {
	meta:
		name = "__makepath"
		size = 322
		refs = "007b __mbsdec"
	strings:
		$1 = { 55 8B EC 51 83 7D 0C 00 74 2C 8B 45 0C 0F BE 08 85 C9 74 22 8B 55 08 8B 45 0C 8A 08 88 0A 8B 55 08 83 C2 01 89 55 08 8B 45 08 C6 00 3A 8B 4D 08 83 C1 01 89 4D 08 8B 55 10 89 55 FC 83 7D FC 00 74 68 8B 45 FC 0F BE 08 85 C9 74 5E 8B 55 08 8B 45 FC 8A 08 88 0A 8B 55 08 83 C2 01 89 55 08 8B 45 FC 83 C0 01 89 45 FC 8B 4D FC 0F BE 11 85 D2 75 DA 8B 45 FC 50 8B 4D 10 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 8B 55 FC 0F BE 02 83 F8 2F 74 1A 8B 4D FC 0F BE 11 83 FA 5C 74 0F 8B 45 08 C6 00 5C 8B 4D 08 83 C1 01 89 4D 08 8B 55 14 89 55 FC 83 7D FC 00 74 28 8B 45 FC 0F BE 08 85 C9 74 1E 8B 55 08 8B 45 FC 8A 08 88 0A 8B 55 08 83 C2 01 89 55 08 8B 45 FC 83 C0 01 89 45 FC EB D8 8B 4D 18 89 4D FC 83 7D FC 00 74 4E 8B 55 FC 0F BE 02 85 C0 74 1A 8B 4D FC 0F BE 11 83 FA 2E 74 0F 8B 45 08 C6 00 2E 8B 4D 08 83 C1 01 89 4D 08 8B 55 08 8B 45 FC 8A 08 88 0A 8B 55 08 0F BE 02 8B 4D 08 83 C1 01 89 4D 08 8B 55 FC 83 C2 01 89 55 FC 85 C0 74 02 EB D8 EB 06 8B 45 08 C6 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_264_0_0 {
	meta:
		name = "_fabs"
		size = 243
		refs = "0011 __ctrlfp 003c __sptype 0097 __handle_qnan1 00a9 __real@8@3fff8000000000000000 00c0 __except1"
	strings:
		$1 = { 55 8B EC 83 EC 10 68 FF FF 00 00 68 3F 13 00 00 E8 ?? ?? ?? ?? 83 C4 08 89 45 F4 8B 45 0E 25 FF FF 00 00 25 F0 7F 00 00 3D F0 7F 00 00 0F 85 96 00 00 00 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 F0 83 7D F0 01 74 0E 83 7D F0 02 74 1E 83 7D F0 03 74 30 EB 46 68 FF FF 00 00 8B 45 F4 50 E8 ?? ?? ?? ?? 83 C4 08 DD 45 08 EB 7F 68 FF FF 00 00 8B 4D F4 51 E8 ?? ?? ?? ?? 83 C4 08 DD 45 08 D9 E0 EB 67 8B 55 F4 52 8B 45 0C 50 8B 4D 08 51 6A 15 E8 ?? ?? ?? ?? 83 C4 10 EB 4F 8B 55 F4 52 DD 45 08 DC 05 ?? ?? ?? ?? 83 EC 08 DD 1C 24 8B 45 0C 50 8B 4D 08 51 6A 15 6A 08 E8 ?? ?? ?? ?? 83 C4 1C EB 26 8B 55 0C 81 E2 FF FF FF 7F 89 55 FC 8B 45 08 89 45 F8 68 FF FF 00 00 8B 4D F4 51 E8 ?? ?? ?? ?? 83 C4 08 DD 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_265_0_0 {
	meta:
		name = "_clock"
		size = 98
		refs = "000e __imp__GetSystemTimeAsFileTime@4 0022 __allshl 0035 _start_tics 0058 __aulldiv"
	strings:
		$1 = { 55 8B EC 83 EC 10 56 57 8D 45 F8 50 FF 15 ?? ?? ?? ?? 8B 75 F8 33 FF 8B 45 FC 33 D2 B9 20 00 00 00 E8 ?? ?? ?? ?? 03 F0 13 FA 89 75 F0 89 7D F4 8B 4D F0 2B 0D ?? ?? ?? ?? 8B 55 F4 1B 15 ?? ?? ?? ?? 89 4D F0 89 55 F4 6A 00 68 10 27 00 00 8B 45 F4 50 8B 4D F0 51 E8 ?? ?? ?? ?? 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_265_1_0 {
	meta:
		name = "___inittime"
		size = 60
		refs = "000e __imp__GetSystemTimeAsFileTime@4 0022 __allshl 002c _start_tics"
	strings:
		$1 = { 55 8B EC 83 EC 08 56 57 8D 45 F8 50 FF 15 ?? ?? ?? ?? 8B 75 F8 33 FF 8B 45 FC 33 D2 B9 20 00 00 00 E8 ?? ?? ?? ?? 03 F0 13 FA 89 35 ?? ?? ?? ?? 89 3D ?? ?? ?? ?? 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_266_0_0 {
	meta:
		name = "_strncpy"
		size = 36
	strings:
		$1 = { 8B 4C 24 0C 57 85 C9 74 7A 56 53 8B D9 8B 74 24 14 F7 C6 03 00 00 00 8B 7C 24 10 75 07 C1 E9 02 75 6F EB 21 }
	condition:
		$1
}

rule file_266_1_0 {
	meta:
		name = "src_misaligned"
		size = 28
	strings:
		$1 = { 8A 06 46 88 07 47 49 74 25 84 C0 74 29 F7 C6 03 00 00 00 75 EB 8B D9 C1 E9 02 75 51 }
	condition:
		$1
}

rule file_266_6_0 {
	meta:
		name = "dest_align_loop"
		size = 18
	strings:
		$1 = { 88 07 47 49 0F 84 8A 00 00 00 F7 C7 03 00 00 00 75 EE }
	condition:
		$1
}

rule file_266_12_0 {
	meta:
		name = "main_loop_entrance"
		size = 54
	strings:
		$1 = { BA FF FE FE 7E 8B 06 03 D0 83 F0 FF 33 C2 8B 16 83 C6 04 A9 00 01 01 81 74 DE 84 D2 74 2C 84 F6 74 1E F7 C2 00 00 FF 00 74 0C F7 C2 00 00 00 FF 75 C6 89 17 EB 18 }
	condition:
		$1
}

rule file_268_0_0 {
	meta:
		name = "__filbuf"
		size = 480
		refs = "0010 ??_C@_0M@KJPK@str?5?$CB?$DN?5NULL?$AA@ 0019 ??_C@_09DNOI@_filbuf?4c?$AA@ 0020 __CrtDbgReport 00a2 __getbuf 00cc __read 0148 ___pioinfo 0157 ___badioinfo"
	strings:
		$1 = { 55 8B EC 83 EC 08 53 56 57 83 7D 08 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 69 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D6 8B 4D 08 89 4D FC 8B 55 FC 8B 42 0C 25 83 00 00 00 85 C0 74 0D 8B 4D FC 8B 51 0C 83 E2 40 85 D2 74 08 83 C8 FF E9 7C 01 00 00 8B 45 FC 8B 48 0C 83 E1 02 85 C9 74 16 8B 55 FC 8B 42 0C 0C 20 8B 4D FC 89 41 0C 83 C8 FF E9 59 01 00 00 8B 55 FC 8B 42 0C 0C 01 8B 4D FC 89 41 0C 8B 55 FC 8B 42 0C 25 0C 01 00 00 85 C0 75 0E 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 EB 0B 8B 55 FC 8B 45 FC 8B 48 08 89 0A 8B 55 FC 8B 42 18 50 8B 4D FC 8B 51 08 52 8B 45 FC 8B 48 10 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 FC 89 42 04 8B 45 FC 83 78 04 00 74 09 8B 4D FC 83 79 04 FF 75 30 8B 55 FC 8B 42 04 F7 D8 1B C0 83 E0 10 83 C0 10 8B 4D FC 8B 51 0C 0B D0 8B 45 FC 89 50 0C 8B 4D FC C7 41 04 00 00 00 00 83 C8 FF E9 BE 00 00 00 8B 55 FC 8B 42 0C 25 82 00 00 00 85 C0 75 53 8B 4D FC 83 79 10 FF 74 21 8B 55 FC 8B 42 10 C1 F8 05 8B 4D FC 8B 51 10 83 E2 1F 8B 04 85 ?? ?? ?? ?? 8D 0C D0 89 4D F8 EB 07 C7 45 F8 ?? ?? ?? ?? 8B 55 F8 0F BE 42 04 25 82 00 00 00 3D 82 00 00 00 75 0F 8B 4D FC 8B 51 0C 80 CE 20 8B 45 FC 89 50 0C 8B 4D FC 81 79 18 00 02 00 00 75 27 8B 55 FC 8B 42 0C 83 E0 08 85 C0 74 1A 8B 4D FC 8B 51 0C 81 E2 00 04 00 00 85 D2 75 0A 8B 45 FC C7 40 18 00 10 00 00 8B 4D FC 8B 51 04 83 EA 01 8B 45 FC 89 50 04 8B 4D FC 8B 11 0F BE 02 25 FF 00 00 00 8B 4D FC 8B 11 83 C2 01 8B 4D FC 89 11 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_269_0_0 {
	meta:
		name = "__fltout"
		size = 113
		refs = "000f ___dtold 0017 _fos 0038 _$I10_OUTPUT 0040 _ret"
	strings:
		$1 = { 55 8B EC 83 EC 0C 8D 45 08 50 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 08 68 ?? ?? ?? ?? 6A 00 6A 11 83 EC 0C 8B D4 8B 45 F4 89 02 8B 4D F8 89 4A 04 66 8B 45 FC 66 89 42 08 E8 ?? ?? ?? ?? 83 C4 18 A3 ?? ?? ?? ?? 0F BE 0D ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 0F BF 15 ?? ?? ?? ?? 89 15 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? B8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_269_1_0 {
	meta:
		name = "___dtold"
		size = 354
	strings:
		$1 = { 55 8B EC 83 EC 1C C7 45 F4 00 00 00 80 66 C7 45 FC 00 00 8B 45 0C 33 C9 66 8B 48 06 81 E1 F0 7F 00 00 C1 F9 04 66 89 4D EC 8B 55 0C 33 C0 66 8B 42 06 25 00 80 00 00 66 89 45 E8 8B 4D 0C 8B 51 04 81 E2 FF FF 0F 00 89 55 F8 8B 45 0C 8B 08 89 4D F0 8B 55 EC 81 E2 FF FF 00 00 89 55 E4 83 7D E4 00 74 13 81 7D E4 FF 07 00 00 74 02 EB 4B 66 C7 45 FC FF 7F EB 5E 83 7D F8 00 75 27 83 7D F0 00 75 21 8B 45 08 C7 40 04 00 00 00 00 8B 4D 08 C7 01 00 00 00 00 8B 55 08 66 C7 42 08 00 00 E9 BA 00 00 00 0F BF 45 EC 05 01 3C 00 00 66 89 45 FC C7 45 F4 00 00 00 00 EB 1B 66 8B 4D EC 66 81 E9 FF 03 66 89 4D EC 0F BF 55 EC 81 C2 FF 3F 00 00 66 89 55 FC 8B 45 F8 C1 E0 0B 8B 4D F4 0B C8 8B 55 F0 C1 EA 15 0B CA 8B 45 08 89 48 04 8B 4D F0 C1 E1 0B 8B 55 08 89 0A 8B 45 08 8B 48 04 81 E1 00 00 00 80 85 C9 75 3B 8B 55 08 8B 42 04 D1 E0 8B 4D 08 8B 11 81 E2 00 00 00 80 F7 DA 1B D2 F7 DA 0B C2 8B 4D 08 89 41 04 8B 55 08 8B 02 D1 E0 8B 4D 08 89 01 66 8B 55 FC 66 83 EA 01 66 89 55 FC EB B5 8B 45 E8 25 FF FF 00 00 8B 4D FC 81 E1 FF FF 00 00 0B C1 8B 55 08 66 89 42 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_270_0_0 {
	meta:
		name = "__snprintf"
		size = 249
		refs = "001c ??_C@_0P@OOIN@string?5?$CB?$DN?5NULL?$AA@ 0025 ??_C@_09NEAG@sprintf?4c?$AA@ 002c __CrtDbgReport 0046 ??_C@_0P@LNLA@format?5?$CB?$DN?5NULL?$AA@ 009a __output 00e5 __flsbuf"
	strings:
		$1 = { 55 8B EC 83 EC 30 53 56 57 8D 45 E0 89 45 DC 8D 4D 14 89 4D D4 83 7D 08 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 5D 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 D2 85 D2 75 D6 83 7D 10 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 5E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D6 8B 4D DC C7 41 0C 42 00 00 00 8B 55 DC 8B 45 08 89 42 08 8B 4D DC 8B 55 08 89 11 8B 45 DC 8B 4D 0C 89 48 04 8B 55 D4 52 8B 45 10 50 8B 4D DC 51 E8 ?? ?? ?? ?? 83 C4 0C 89 45 D8 8B 55 DC 8B 42 04 83 E8 01 8B 4D DC 89 41 04 8B 55 DC 83 7A 04 00 7C 22 8B 45 DC 8B 08 C6 01 00 33 D2 81 E2 FF 00 00 00 89 55 D0 8B 45 DC 8B 08 83 C1 01 8B 55 DC 89 0A EB 11 8B 45 DC 50 6A 00 E8 ?? ?? ?? ?? 83 C4 08 89 45 D0 8B 45 D8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_271_0_0 {
	meta:
		name = "__chkesp"
		size = 56
		refs = "000f ??_C@_0NM@ELEE@The?5value?5of?5ESP?5was?5not?5properl@ 0014 ??_C@_00A@?$AA@ 001b ??_C@_0O@FHMD@i386?2chkesp?4c?$AA@ 0022 __CrtDbgReport"
	strings:
		$1 = { 75 01 C3 55 8B EC 83 EC 00 50 52 53 56 57 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 2A 68 ?? ?? ?? ?? 6A 01 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 5F 5E 5B 5A 58 8B E5 5D C3 }
	condition:
		$1
}

rule file_273_0_0 {
	meta:
		name = "_gmtime"
		size = 449
		refs = "0018 _tb 00f0 __lpdays 00f9 __days"
	strings:
		$1 = { 55 8B EC 83 EC 14 8B 45 08 8B 08 89 4D F4 C7 45 F8 00 00 00 00 C7 45 FC ?? ?? ?? ?? 83 7D F4 00 7D 07 33 C0 E9 94 01 00 00 8B 45 F4 99 B9 80 1F 86 07 F7 F9 89 45 EC 8B 55 EC 69 D2 80 1F 86 07 8B 45 F4 2B C2 89 45 F4 8B 4D EC 8D 14 8D 46 00 00 00 89 55 EC 81 7D F4 80 33 E1 01 7C 5B 8B 45 EC 83 C0 01 89 45 EC 8B 4D F4 81 E9 80 33 E1 01 89 4D F4 81 7D F4 80 33 E1 01 7C 3D 8B 55 EC 83 C2 01 89 55 EC 8B 45 F4 2D 80 33 E1 01 89 45 F4 81 7D F4 00 85 E2 01 7C 17 8B 4D EC 83 C1 01 89 4D EC 8B 55 F4 81 EA 00 85 E2 01 89 55 F4 EB 09 8B 45 F8 83 C0 01 89 45 F8 8B 4D FC 8B 55 EC 89 51 14 8B 45 F4 99 B9 80 51 01 00 F7 F9 8B 55 FC 89 42 1C 8B 45 FC 8B 48 1C 69 C9 80 51 01 00 8B 55 F4 2B D1 89 55 F4 83 7D F8 00 74 09 C7 45 F0 ?? ?? ?? ?? EB 07 C7 45 F0 ?? ?? ?? ?? C7 45 EC 01 00 00 00 EB 09 8B 45 EC 83 C0 01 89 45 EC 8B 4D EC 8B 55 F0 8B 45 FC 8B 0C 8A 3B 48 1C 7D 02 EB E4 8B 55 EC 83 EA 01 89 55 EC 8B 45 FC 8B 4D EC 89 48 10 8B 55 FC 8B 45 EC 8B 4D F0 8B 52 1C 2B 14 81 8B 45 FC 89 50 0C 8B 4D 08 8B 01 99 B9 80 51 01 00 F7 F9 83 C0 04 99 B9 07 00 00 00 F7 F9 8B 45 FC 89 50 18 8B 45 F4 99 B9 10 0E 00 00 F7 F9 8B 55 FC 89 42 08 8B 45 FC 8B 48 08 69 C9 10 0E 00 00 8B 55 F4 2B D1 89 55 F4 8B 45 F4 99 B9 3C 00 00 00 F7 F9 8B 55 FC 89 42 04 8B 45 FC 8B 48 04 6B C9 3C 8B 55 F4 2B D1 8B 45 FC 89 10 8B 4D FC C7 41 20 00 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_277_2_0 {
	meta:
		name = "fFMOD"
		size = 30
		refs = "0004 __adjust_fdiv 0010 __adj_fprem"
	strings:
		$1 = { D9 C9 83 3D ?? ?? ?? ?? 01 74 04 D9 F8 EB 05 E8 ?? ?? ?? ?? 9B DF E0 9B 9E 7A E7 DD D9 C3 }
	condition:
		$1
}

rule file_278_0_0 {
	meta:
		name = "__mbsnicmp"
		size = 731
		refs = "0015 ___ismbcodepage 0029 __strnicmp 006a __mbctype 00be ___mbulinfo 014d __mbcasemap"
	strings:
		$1 = { 55 8B EC 83 EC 10 83 7D 10 00 75 07 33 C0 E9 C4 02 00 00 83 3D ?? ?? ?? ?? 00 75 19 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C E9 A2 02 00 00 8B 45 10 8B 4D 10 83 E9 01 89 4D 10 85 C0 0F 84 8C 02 00 00 8B 55 08 66 0F B6 02 66 89 45 FC 8B 4D 08 83 C1 01 89 4D 08 8B 55 FC 81 E2 FF 00 00 00 33 C0 8A 82 ?? ?? ?? ?? 83 E0 04 85 C0 0F 84 AE 00 00 00 8B 4D 08 33 D2 8A 11 85 D2 75 0B 66 C7 45 FC 00 00 E9 96 00 00 00 8B 45 FC 25 FF FF 00 00 C1 E0 08 8B 4D 08 33 D2 8A 11 0B C2 66 89 45 FC 8B 45 08 83 C0 01 89 45 08 8B 4D FC 81 E1 FF FF 00 00 33 D2 66 8B 15 ?? ?? ?? ?? 3B CA 7C 26 8B 45 FC 25 FF FF 00 00 33 C9 66 8B 0D ?? ?? ?? ?? 3B C1 7F 11 66 8B 55 FC 66 03 15 ?? ?? ?? ?? 66 89 55 FC EB 39 8B 45 FC 25 FF FF 00 00 33 C9 66 8B 0D ?? ?? ?? ?? 3B C1 7C 24 8B 55 FC 81 E2 FF FF 00 00 33 C0 66 A1 ?? ?? ?? ?? 3B D0 7F 0F 66 8B 4D FC 66 03 0D ?? ?? ?? ?? 66 89 4D FC EB 42 8B 55 FC 81 E2 FF FF 00 00 33 C0 8A 82 ?? ?? ?? ?? 83 E0 10 83 F8 10 75 16 8B 4D FC 81 E1 FF FF 00 00 33 D2 8A 91 ?? ?? ?? ?? 89 55 F4 EB 0B 8B 45 FC 25 FF FF 00 00 89 45 F4 66 8B 4D F4 66 89 4D FC 8B 55 0C 66 0F B6 02 66 89 45 F8 8B 4D 0C 83 C1 01 89 4D 0C 8B 55 F8 81 E2 FF 00 00 00 33 C0 8A 82 ?? ?? ?? ?? 83 E0 04 85 C0 0F 84 AE 00 00 00 8B 4D 0C 33 D2 8A 11 85 D2 75 0B 66 C7 45 F8 00 00 E9 96 00 00 00 8B 45 F8 25 FF FF 00 00 C1 E0 08 8B 4D 0C 33 D2 8A 11 0B C2 66 89 45 F8 8B 45 0C 83 C0 01 89 45 0C 8B 4D F8 81 E1 FF FF 00 00 33 D2 66 8B 15 ?? ?? ?? ?? 3B CA 7C 26 8B 45 F8 25 FF FF 00 00 33 C9 66 8B 0D ?? ?? ?? ?? 3B C1 7F 11 66 8B 55 F8 66 03 15 ?? ?? ?? ?? 66 89 55 F8 EB 39 8B 45 F8 25 FF FF 00 00 33 C9 66 8B 0D ?? ?? ?? ?? 3B C1 7C 24 8B 55 F8 81 E2 FF FF 00 00 33 C0 66 A1 ?? ?? ?? ?? 3B D0 7F 0F 66 8B 4D F8 66 03 0D ?? ?? ?? ?? 66 89 4D F8 EB 42 8B 55 F8 81 E2 FF FF 00 00 33 C0 8A 82 ?? ?? ?? ?? 83 E0 10 83 F8 10 75 16 8B 4D F8 81 E1 FF FF 00 00 33 D2 8A 91 ?? ?? ?? ?? 89 55 F0 EB 0B 8B 45 F8 25 FF FF 00 00 89 45 F0 66 8B 4D F0 66 89 4D F8 8B 55 FC 81 E2 FF FF 00 00 8B 45 F8 25 FF FF 00 00 3B D0 74 22 8B 4D FC 81 E1 FF FF 00 00 8B 55 F8 81 E2 FF FF 00 00 33 C0 3B CA 0F 9E C0 48 83 E0 02 83 C0 FF EB 17 8B 45 FC 25 FF FF 00 00 85 C0 75 04 33 C0 EB 07 E9 60 FD FF FF 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_279_0_0 {
	meta:
		name = "_memmove"
		size = 32
		altNames = "_memcpy"
	strings:
		$1 = { 55 8B EC 57 56 8B 75 0C 8B 4D 10 8B 7D 08 8B C1 8B D1 03 C6 3B FE 76 08 3B F8 0F 82 78 01 00 00 }
	condition:
		$1
}

rule file_279_1_0 {
	meta:
		name = "CopyUp"
		size = 28
		refs = "0018 TrailUpVec"
	strings:
		$1 = { F7 C7 03 00 00 00 75 14 C1 E9 02 83 E2 03 83 F9 08 72 29 F3 A5 FF 24 95 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_279_2_0 {
	meta:
		name = "CopyLeadUp"
		size = 24
		refs = "0014 LeadUpVec"
	strings:
		$1 = { 8B C7 BA 03 00 00 00 83 E9 04 72 0C 83 E0 03 03 C8 FF 24 85 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_279_4_0 {
	meta:
		name = "CopyUnwindUp"
		size = 20
		refs = "0003 UnwindUpVec 0008 LeadUp1 000c LeadUp2 0010 LeadUp3"
	strings:
		$1 = { FF 24 8D ?? ?? ?? ?? 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_279_23_0 {
	meta:
		name = "ByteCopyDown"
		size = 20
		refs = "0003 TrailDownVec 0008 LeadDown1 000c LeadDown2 0010 LeadDown3"
	strings:
		$1 = { FF 24 8D ?? ?? ?? ?? 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_279_5_0 {
	meta:
		name = "LeadUp1"
		size = 44
		refs = "0025 TrailUpVec"
	strings:
		$1 = { 23 D1 8A 06 88 07 8A 46 01 88 47 01 8A 46 02 C1 E9 02 88 47 02 83 C6 03 83 C7 03 83 F9 08 72 CC F3 A5 FF 24 95 ?? ?? ?? ?? 8D 49 00 }
	condition:
		$1
}

rule file_279_6_0 {
	meta:
		name = "LeadUp2"
		size = 36
		refs = "001f TrailUpVec"
	strings:
		$1 = { 23 D1 8A 06 88 07 8A 46 01 C1 E9 02 88 47 01 83 C6 02 83 C7 02 83 F9 08 72 A6 F3 A5 FF 24 95 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_279_7_0 {
	meta:
		name = "LeadUp3"
		size = 60
		refs = "0015 TrailUpVec 001c UnwindUp0 0020 UnwindUp1 0024 UnwindUp2 0028 UnwindUp3 002c UnwindUp4 0030 UnwindUp5 0034 UnwindUp6 0038 UnwindUp7"
	strings:
		$1 = { 23 D1 8A 06 88 07 46 C1 E9 02 47 83 F9 08 72 8C F3 A5 FF 24 95 ?? ?? ?? ?? 8D 49 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_279_14_0 {
	meta:
		name = "UnwindUp1"
		size = 19
	strings:
		$1 = { 8B 44 8E FC 89 44 8F FC 8D 04 8D 00 00 00 00 03 F0 03 F8 }
	condition:
		$1
}

rule file_279_15_0 {
	meta:
		name = "UnwindUp0"
		size = 25
		refs = "0003 TrailUpVec 0009 TrailUp0 000d TrailUp1 0011 TrailUp2 0015 TrailUp3"
	strings:
		$1 = { FF 24 95 ?? ?? ?? ?? 8B FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_279_34_0 {
	meta:
		name = "UnwindDown0"
		size = 25
		refs = "0003 TrailDownVec 0009 TrailDown0 000d TrailDown1 0011 TrailDown2 0015 TrailDown3"
	strings:
		$1 = { FF 24 95 ?? ?? ?? ?? 8B FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_279_18_0 {
	meta:
		name = "TrailUp2"
		size = 20
	strings:
		$1 = { 8A 06 88 07 8A 46 01 88 47 01 8B 45 08 5E 5F C9 C3 8D 49 00 }
	condition:
		$1
}

rule file_279_19_0 {
	meta:
		name = "TrailUp3"
		size = 24
	strings:
		$1 = { 8A 06 88 07 8A 46 01 88 47 01 8A 46 02 88 47 02 8B 45 08 5E 5F C9 C3 90 }
	condition:
		$1
}

rule file_279_20_0 {
	meta:
		name = "CopyDown"
		size = 40
		refs = "0022 TrailDownVec"
	strings:
		$1 = { 8D 74 31 FC 8D 7C 39 FC F7 C7 03 00 00 00 75 24 C1 E9 02 83 E2 03 83 F9 08 72 0D FD F3 A5 FC FF 24 95 ?? ?? ?? ?? 8B FF }
	condition:
		$1
}

rule file_279_22_0 {
	meta:
		name = "CopyLeadDown"
		size = 24
		refs = "0014 LeadDownVec"
	strings:
		$1 = { 8B C7 BA 03 00 00 00 83 F9 04 72 0C 83 E0 03 2B C8 FF 24 85 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_279_24_0 {
	meta:
		name = "LeadDown1"
		size = 32
		refs = "0019 TrailDownVec"
	strings:
		$1 = { 8A 46 03 23 D1 88 47 03 4E C1 E9 02 4F 83 F9 08 72 B6 FD F3 A5 FC FF 24 95 ?? ?? ?? ?? 8D 49 00 }
	condition:
		$1
}

rule file_279_25_0 {
	meta:
		name = "LeadDown2"
		size = 40
		refs = "0023 TrailDownVec"
	strings:
		$1 = { 8A 46 03 23 D1 88 47 03 8A 46 02 C1 E9 02 88 47 02 83 EE 02 83 EF 02 83 F9 08 72 8C FD F3 A5 FC FF 24 95 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_279_26_0 {
	meta:
		name = "LeadDown3"
		size = 84
		refs = "002d TrailDownVec 0034 UnwindDown7 0038 UnwindDown6 003c UnwindDown5 0040 UnwindDown4 0044 UnwindDown3 0048 UnwindDown2 004c UnwindDown1 0050 UnwindDown0"
	strings:
		$1 = { 8A 46 03 23 D1 88 47 03 8A 46 02 88 47 02 8A 46 01 C1 E9 02 88 47 01 83 EE 03 83 EF 03 83 F9 08 0F 82 5A FF FF FF FD F3 A5 FC FF 24 95 ?? ?? ?? ?? 8D 49 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_279_33_0 {
	meta:
		name = "UnwindDown1"
		size = 19
	strings:
		$1 = { 8B 44 8E 04 89 44 8F 04 8D 04 8D 00 00 00 00 03 F0 03 F8 }
	condition:
		$1
}

rule file_279_36_0 {
	meta:
		name = "TrailDown1"
		size = 16
	strings:
		$1 = { 8A 46 03 88 47 03 8B 45 08 5E 5F C9 C3 8D 49 00 }
	condition:
		$1
}

rule file_279_37_0 {
	meta:
		name = "TrailDown2"
		size = 20
	strings:
		$1 = { 8A 46 03 88 47 03 8A 46 02 88 47 02 8B 45 08 5E 5F C9 C3 90 }
	condition:
		$1
}

rule file_279_38_0 {
	meta:
		name = "TrailDown3"
		size = 25
	strings:
		$1 = { 8A 46 03 88 47 03 8A 46 02 88 47 02 8A 46 01 88 47 01 8B 45 08 5E 5F C9 C3 }
	condition:
		$1
}

rule file_281_0_0 {
	meta:
		name = "__vsnprintf"
		size = 243
		refs = "0016 ??_C@_0P@OOIN@string?5?$CB?$DN?5NULL?$AA@ 001f ??_C@_0L@HE@vsprintf?4c?$AA@ 0026 __CrtDbgReport 0040 ??_C@_0P@LNLA@format?5?$CB?$DN?5NULL?$AA@ 0094 __output 00df __flsbuf"
	strings:
		$1 = { 55 8B EC 83 EC 2C 53 56 57 8D 45 E0 89 45 DC 83 7D 08 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 5A 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D6 83 7D 10 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 5B 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 D2 85 D2 75 D6 8B 45 DC C7 40 0C 42 00 00 00 8B 4D DC 8B 55 08 89 51 08 8B 45 DC 8B 4D 08 89 08 8B 55 DC 8B 45 0C 89 42 04 8B 4D 14 51 8B 55 10 52 8B 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 89 45 D8 8B 4D DC 8B 51 04 83 EA 01 8B 45 DC 89 50 04 8B 4D DC 83 79 04 00 7C 22 8B 55 DC 8B 02 C6 00 00 33 C9 81 E1 FF 00 00 00 89 4D D4 8B 55 DC 8B 02 83 C0 01 8B 4D DC 89 01 EB 11 8B 55 DC 52 6A 00 E8 ?? ?? ?? ?? 83 C4 08 89 45 D4 8B 45 D8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_282_0_0 {
	meta:
		name = "_fflush"
		size = 83
		refs = "000c _flsall 001a __flush 0042 __commit"
	strings:
		$1 = { 55 8B EC 83 7D 08 00 75 0C 6A 00 E8 ?? ?? ?? ?? 83 C4 04 EB 3C 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 05 83 C8 FF EB 27 8B 4D 08 8B 51 0C 81 E2 00 40 00 00 85 D2 74 15 8B 45 08 8B 48 10 51 E8 ?? ?? ?? ?? 83 C4 04 F7 D8 1B C0 EB 02 33 C0 5D C3 }
	condition:
		$1
}

rule file_282_1_0 {
	meta:
		name = "__flush"
		size = 183
		refs = "0058 __write"
	strings:
		$1 = { 55 8B EC 83 EC 0C C7 45 FC 00 00 00 00 8B 45 08 89 45 F8 8B 4D F8 8B 51 0C 83 E2 03 83 FA 02 75 7A 8B 45 F8 8B 48 0C 81 E1 08 01 00 00 85 C9 74 6A 8B 55 F8 8B 45 F8 8B 0A 2B 48 08 89 4D F4 83 7D F4 00 7E 56 8B 55 F4 52 8B 45 F8 8B 48 08 51 8B 55 F8 8B 42 10 50 E8 ?? ?? ?? ?? 83 C4 0C 3B 45 F4 75 21 8B 4D F8 8B 51 0C 81 E2 80 00 00 00 85 D2 74 0F 8B 45 F8 8B 48 0C 83 E1 FD 8B 55 F8 89 4A 0C EB 16 8B 45 F8 8B 48 0C 83 C9 20 8B 55 F8 89 4A 0C C7 45 FC FF FF FF FF 8B 45 F8 8B 4D F8 8B 51 08 89 10 8B 45 F8 C7 40 04 00 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_282_3_0 {
	meta:
		name = "_flsall"
		size = 222
		refs = "002b __nstream 0039 ___piob 0073 _fflush"
	strings:
		$1 = { 55 8B EC 83 EC 0C C7 45 FC 00 00 00 00 C7 45 F8 00 00 00 00 C7 45 F4 00 00 00 00 EB 09 8B 45 F4 83 C0 01 89 45 F4 8B 4D F4 3B 0D ?? ?? ?? ?? 0F 8D 97 00 00 00 8B 55 F4 A1 ?? ?? ?? ?? 83 3C 90 00 0F 84 80 00 00 00 8B 4D F4 8B 15 ?? ?? ?? ?? 8B 04 8A 8B 48 0C 81 E1 83 00 00 00 85 C9 74 67 83 7D 08 01 75 24 8B 55 F4 A1 ?? ?? ?? ?? 8B 0C 90 51 E8 ?? ?? ?? ?? 83 C4 04 83 F8 FF 74 09 8B 55 FC 83 C2 01 89 55 FC EB 3D 83 7D 08 00 75 37 8B 45 F4 8B 0D ?? ?? ?? ?? 8B 14 81 8B 42 0C 83 E0 02 85 C0 74 21 8B 4D F4 8B 15 ?? ?? ?? ?? 8B 04 8A 50 E8 ?? ?? ?? ?? 83 C4 04 83 F8 FF 75 07 C7 45 F8 FF FF FF FF E9 51 FF FF FF 83 7D 08 01 75 05 8B 45 FC EB 03 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_283_0_0 {
	meta:
		name = "__findfirst"
		size = 308
		refs = "0016 __imp__FindFirstFileA@8 002b __imp__GetLastError@0 005d $L17148 0064 $L17149 006a _errno 00b4 ___timet_from_ft 0106 _strcpy 0117 $L17102 011b $L17103 011f $L17104"
	strings:
		$1 = { 55 8B EC 81 EC 4C 01 00 00 8D 85 BC FE FF FF 50 8B 4D 08 51 FF 15 ?? ?? ?? ?? 89 85 B8 FE FF FF 83 BD B8 FE FF FF FF 75 69 FF 15 ?? ?? ?? ?? 89 45 FC 8B 55 FC 89 95 B4 FE FF FF 8B 85 B4 FE FF FF 83 E8 02 89 85 B4 FE FF FF 83 BD B4 FE FF FF 10 77 2D 8B 95 B4 FE FF FF 33 C9 8A 8A ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 02 00 00 00 EB 16 C7 05 ?? ?? ?? ?? 0C 00 00 00 EB 0A C7 05 ?? ?? ?? ?? 16 00 00 00 83 C8 FF E9 81 00 00 00 8B 85 BC FE FF FF 2D 80 00 00 00 F7 D8 1B C0 23 85 BC FE FF FF 8B 4D 0C 89 01 8D 95 C0 FE FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 89 41 04 8D 95 C8 FE FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 89 41 08 8D 95 D0 FE FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 89 41 0C 8B 55 0C 8B 85 DC FE FF FF 89 42 10 8D 8D E8 FE FF FF 51 8B 55 0C 83 C2 14 52 E8 ?? ?? ?? ?? 83 C4 08 8B 85 B8 FE FF FF 8B E5 5D C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 02 02 02 02 01 02 02 02 02 02 02 02 02 02 00 }
	condition:
		$1
}

rule file_283_1_0 {
	meta:
		name = "__findnext"
		size = 290
		refs = "0016 __imp__FindNextFileA@8 0020 __imp__GetLastError@0 0052 $L17152 0059 $L17153 005f _errno 00a6 ___timet_from_ft 00f8 _strcpy 0105 $L17119 0109 $L17120 010d $L17121"
	strings:
		$1 = { 55 8B EC 81 EC 48 01 00 00 8D 85 BC FE FF FF 50 8B 4D 08 51 FF 15 ?? ?? ?? ?? 85 C0 75 66 FF 15 ?? ?? ?? ?? 89 45 FC 8B 55 FC 89 95 B8 FE FF FF 8B 85 B8 FE FF FF 83 E8 02 89 85 B8 FE FF FF 83 BD B8 FE FF FF 10 77 2D 8B 95 B8 FE FF FF 33 C9 8A 8A ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 02 00 00 00 EB 16 C7 05 ?? ?? ?? ?? 0C 00 00 00 EB 0A C7 05 ?? ?? ?? ?? 16 00 00 00 83 C8 FF EB 7D 8B 85 BC FE FF FF 2D 80 00 00 00 F7 D8 1B C0 23 85 BC FE FF FF 8B 4D 0C 89 01 8D 95 C0 FE FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 89 41 04 8D 95 C8 FE FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 89 41 08 8D 95 D0 FE FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 89 41 0C 8B 55 0C 8B 85 DC FE FF FF 89 42 10 8D 8D E8 FE FF FF 51 8B 55 0C 83 C2 14 52 E8 ?? ?? ?? ?? 83 C4 08 33 C0 8B E5 5D C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 02 02 02 02 01 02 02 02 02 02 02 02 02 02 00 }
	condition:
		$1
}

rule file_283_2_0 {
	meta:
		name = "__findclose"
		size = 36
		refs = "0009 __imp__FindClose@4 0013 _errno"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 FF 15 ?? ?? ?? ?? 85 C0 75 0F C7 05 ?? ?? ?? ?? 16 00 00 00 83 C8 FF EB 02 33 C0 5D C3 }
	condition:
		$1
}

rule file_283_3_0 {
	meta:
		name = "___timet_from_ft"
		size = 141
		refs = "0026 __imp__FileTimeToLocalFileTime@8 0038 __imp__FileTimeToSystemTime@8 0082 ___loctotime_t"
	strings:
		$1 = { 55 8B EC 83 EC 18 8B 45 08 83 38 00 75 0E 8B 4D 08 83 79 04 00 75 05 83 C8 FF EB 6D 8D 55 F8 52 8B 45 08 50 FF 15 ?? ?? ?? ?? 85 C0 74 12 8D 4D E8 51 8D 55 F8 52 FF 15 ?? ?? ?? ?? 85 C0 75 05 83 C8 FF EB 44 6A FF 8B 45 F4 25 FF FF 00 00 50 8B 4D F2 81 E1 FF FF 00 00 51 8B 55 F0 81 E2 FF FF 00 00 52 8B 45 EE 25 FF FF 00 00 50 8B 4D EA 81 E1 FF FF 00 00 51 8B 55 E8 81 E2 FF FF 00 00 52 E8 ?? ?? ?? ?? 83 C4 1C 8B E5 5D C3 }
	condition:
		$1
}

rule file_284_0_0 {
	meta:
		name = "__mbsnbcoll"
		size = 79
		refs = "000f ___mbcodepage 0028 ___mblcid 002e ___crtCompareStringA"
	strings:
		$1 = { 55 8B EC 51 83 7D 10 00 75 04 33 C0 EB 3D A1 ?? ?? ?? ?? 50 8B 4D 10 51 8B 55 0C 52 8B 45 10 50 8B 4D 08 51 6A 00 8B 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 1C 89 45 FC 83 7D FC 00 75 07 B8 FF FF FF 7F EB 06 8B 45 FC 83 E8 02 8B E5 5D C3 }
	condition:
		$1
}

rule file_285_0_0 {
	meta:
		name = "__input"
		size = 5079
		refs = "0013 ??_C@_0P@LNLA@format?5?$CB?$DN?5NULL?$AA@ 001f ??_C@_07IEFA@input?4c?$AA@ 0026 __CrtDbgReport 0040 ??_C@_0P@FHEA@stream?5?$CB?$DN?5NULL?$AA@ 0088 ___mb_cur_max 009a __isctype 00b2 __pctype 00e4 __whiteout 00ed __un_inc 0106 _isspace 0235 $L1932 023c $L1933 0371 __inc 03c0 $L1934 03c7 $L1935 0403 _cbrackset 0428 _sbrackset 0489 _memset 074f _mbtowc 09d8 __allshl 09ea __hextodec 0e8a ___decimal_point 113a __cfltcvt_tab 1328 $L1660 132c $L1652 1330 $L1654 1334 $L1657 1338 $L1653 133c $L1658 1340 $L1659 1344 $DEFAULT_LABEL$1656 1396 $L1683 139a $L1757 139e $L1825 13a2 $L1739 13a6 $L1823 13aa $L1756 13ae $L1687 13b2 $L1740 13b6 $L1689 13ba $L1859"
	strings:
		$1 = { 55 8B EC 81 EC 24 02 00 00 53 56 57 83 7D 0C 00 75 21 68 ?? ?? ?? ?? 6A 00 68 09 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D3 83 7D 08 00 75 21 68 ?? ?? ?? ?? 6A 00 68 0C 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D3 C6 45 D8 00 0F BE 55 D8 89 55 E0 8B 45 E0 89 45 CC 8B 4D 0C 33 D2 8A 11 85 D2 0F 84 64 12 00 00 83 3D ?? ?? ?? ?? 01 7E 1A 6A 08 8B 45 0C 33 C9 8A 08 51 E8 ?? ?? ?? ?? 83 C4 08 89 85 08 FE FF FF EB 1C 8B 55 0C 33 C0 8A 02 8B 0D ?? ?? ?? ?? 33 D2 66 8B 14 41 83 E2 08 89 95 08 FE FF FF 83 BD 08 FE FF FF 00 74 45 8B 45 E0 83 E8 01 89 45 E0 8B 4D 08 51 8B 55 08 52 8D 45 E0 50 E8 ?? ?? ?? ?? 83 C4 08 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4D 0C 83 C1 01 89 4D 0C 8B 55 0C 33 C0 8A 02 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 02 EB E1 8B 4D 0C 33 D2 8A 11 83 FA 25 0F 85 AB 10 00 00 C7 45 C0 00 00 00 00 C6 45 F8 00 C7 45 94 00 00 00 00 8B 45 94 89 85 18 FE FF FF 8B 8D 18 FE FF FF 89 4D E4 C6 45 F0 00 8A 55 F0 88 55 98 8A 45 98 88 45 90 8A 4D 90 88 4D E8 8A 55 E8 88 55 9C C6 45 EC 00 C6 45 C8 01 C7 85 24 FE FF FF 00 00 00 00 0F BE 45 E8 85 C0 0F 85 51 01 00 00 8B 4D 0C 83 C1 01 89 4D 0C 8B 55 0C 33 C0 8A 02 89 45 F4 83 3D ?? ?? ?? ?? 01 7E 1C 6A 04 8B 4D F4 81 E1 FF 00 00 00 51 E8 ?? ?? ?? ?? 83 C4 08 89 85 04 FE FF FF EB 1D 8B 55 F4 81 E2 FF 00 00 00 A1 ?? ?? ?? ?? 33 C9 66 8B 0C 50 83 E1 04 89 8D 04 FE FF FF 83 BD 04 FE FF FF 00 74 27 8B 95 18 FE FF FF 83 C2 01 89 95 18 FE FF FF 8B 45 E4 8B 4D E4 8D 14 81 8B 45 F4 8D 4C 50 D0 89 4D E4 E9 C7 00 00 00 8B 55 F4 89 95 00 FE FF FF 8B 85 00 FE FF FF 83 E8 2A 89 85 00 FE FF FF 83 BD 00 FE FF FF 4D 0F 87 9A 00 00 00 8B 95 00 FE FF FF 33 C9 8A 8A ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? E9 88 00 00 00 8A 45 C8 2C 01 88 45 C8 8A 4D EC 80 E9 01 88 4D EC EB 75 8B 55 0C 33 C0 8A 42 01 83 F8 36 75 35 8B 4D 0C 33 D2 8A 51 02 83 FA 34 75 28 8B 45 0C 83 C0 02 89 45 0C 8B 8D 24 FE FF FF 83 C1 01 89 8D 24 FE FF FF C7 45 D0 00 00 00 00 C7 45 D4 00 00 00 00 EB 33 EB 29 8A 55 C8 80 C2 01 88 55 C8 EB 26 8A 45 C8 04 01 88 45 C8 8A 4D EC 80 C1 01 88 4D EC EB 13 8A 55 90 80 C2 01 88 55 90 EB 08 8A 45 E8 04 01 88 45 E8 E9 A3 FE FF FF 0F BE 4D 90 85 C9 75 1B 8B 55 10 89 95 2C FE FF FF 8B 45 10 83 C0 04 89 45 10 8B 4D 10 8B 51 FC 89 55 C4 C6 45 E8 00 0F BE 45 EC 85 C0 75 2B 8B 4D 0C 33 D2 8A 11 83 FA 53 74 0C 8B 45 0C 33 C9 8A 08 83 F9 43 75 0B 8A 55 EC 80 C2 01 88 55 EC EB 08 8A 45 EC 2C 01 88 45 EC 8B 4D 0C 33 D2 8A 11 83 CA 20 89 55 F4 83 7D F4 6E 74 3F 83 7D F4 63 74 1E 83 7D F4 7B 74 18 8B 45 08 50 8D 4D E0 51 E8 ?? ?? ?? ?? 83 C4 08 89 85 28 FE FF FF EB 1B 8B 55 E0 83 C2 01 89 55 E0 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 28 FE FF FF 83 BD 18 FE FF FF 00 74 0A 83 7D E4 00 0F 84 0E 0E 00 00 8B 4D F4 89 8D FC FD FF FF 8B 95 FC FD FF FF 83 EA 63 89 95 FC FD FF FF 83 BD FC FD FF FF 18 0F 87 94 0D 00 00 8B 8D FC FD FF FF 33 C0 8A 81 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 83 BD 18 FE FF FF 00 75 18 8B 95 18 FE FF FF 83 C2 01 89 95 18 FE FF FF 8B 45 E4 83 C0 01 89 45 E4 0F BE 4D EC 85 C9 7E 09 8A 55 9C 80 C2 01 88 55 9C C7 85 20 FE FF FF ?? ?? ?? ?? 8A 45 F0 2C 01 88 45 F0 EB 6F 0F BE 4D EC 85 C9 7E 09 8A 55 9C 80 C2 01 88 55 9C C7 85 20 FE FF FF ?? ?? ?? ?? 8A 45 F0 2C 01 88 45 F0 EB 4A 0F BE 4D EC 85 C9 7E 09 8A 55 9C 80 C2 01 88 55 9C 8B 45 0C 83 C0 01 89 45 0C 8B 4D 0C 89 8D 20 FE FF FF 8B 95 20 FE FF FF 33 C0 8A 02 83 F8 5E 75 18 8B 8D 20 FE FF FF 83 C1 01 89 8D 20 FE FF FF 8A 55 F0 80 EA 01 88 55 F0 6A 20 6A 00 8D 45 A0 50 E8 ?? ?? ?? ?? 83 C4 0C 83 7D F4 7B 75 26 8B 8D 20 FE FF FF 33 D2 8A 11 83 FA 5D 75 17 C6 45 F8 5D 8B 85 20 FE FF FF 83 C0 01 89 85 20 FE FF FF C6 45 AB 20 8B 8D 20 FE FF FF 33 D2 8A 11 83 FA 5D 0F 84 58 01 00 00 8B 85 20 FE FF FF 8A 08 88 8D 14 FE FF FF 8B 95 20 FE FF FF 83 C2 01 89 95 20 FE FF FF 8B 85 14 FE FF FF 25 FF 00 00 00 83 F8 2D 75 1C 8B 4D F8 81 E1 FF 00 00 00 85 C9 74 0F 8B 95 20 FE FF FF 33 C0 8A 02 83 F8 5D 75 46 8A 8D 14 FE FF FF 88 4D F8 8B 55 F8 81 E2 FF 00 00 00 C1 FA 03 8B 8D 14 FE FF FF 81 E1 FF 00 00 00 83 E1 07 B8 01 00 00 00 D3 E0 8A 4C 15 A0 0A C8 8B 55 F8 81 E2 FF 00 00 00 C1 FA 03 88 4C 15 A0 E9 C4 00 00 00 8B 85 20 FE FF FF 8A 08 88 8D 14 FE FF FF 8B 95 20 FE FF FF 83 C2 01 89 95 20 FE FF FF 8B 45 F8 25 FF 00 00 00 8B 8D 14 FE FF FF 81 E1 FF 00 00 00 3B C1 7D 0B 8A 95 14 FE FF FF 88 55 DC EB 0F 8A 45 F8 88 45 DC 8A 8D 14 FE FF FF 88 4D F8 8A 55 F8 88 95 14 FE FF FF EB 0E 8A 85 14 FE FF FF 04 01 88 85 14 FE FF FF 8B 8D 14 FE FF FF 81 E1 FF 00 00 00 8B 55 DC 81 E2 FF 00 00 00 3B CA 7F 3F 8B 85 14 FE FF FF 25 FF 00 00 00 C1 F8 03 8B 8D 14 FE FF FF 81 E1 FF 00 00 00 83 E1 07 BA 01 00 00 00 D3 E2 8A 44 05 A0 0A C2 8B 8D 14 FE FF FF 81 E1 FF 00 00 00 C1 F9 03 88 44 0D A0 EB 9A C6 45 F8 00 E9 95 FE FF FF 8B 95 20 FE FF FF 33 C0 8A 02 85 C0 75 05 E9 B0 0C 00 00 83 7D F4 7B 75 09 8B 8D 20 FE FF FF 89 4D 0C 8B 55 C4 89 95 1C FE FF FF 8B 45 E0 83 E8 01 89 45 E0 8B 4D 08 51 8B 95 28 FE FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 83 BD 18 FE FF FF 00 74 14 8B 45 E4 8B 4D E4 83 E9 01 89 4D E4 85 C0 0F 84 2A 01 00 00 8B 55 E0 83 C2 01 89 55 E0 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 28 FE FF FF 83 BD 28 FE FF FF FF 0F 84 DF 00 00 00 8B 8D 28 FE FF FF C1 F9 03 0F BE 54 0D A0 0F BE 45 F0 33 D0 8B 8D 28 FE FF FF 83 E1 07 B8 01 00 00 00 D3 E0 23 D0 85 D2 0F 84 B1 00 00 00 0F BE 4D 90 85 C9 0F 85 94 00 00 00 0F BE 55 9C 85 D2 74 76 8A 85 28 FE FF FF 88 85 10 FE FF FF 8B 8D 28 FE FF FF 81 E1 FF 00 00 00 8B 15 ?? ?? ?? ?? 33 C0 66 8B 04 4A 25 00 80 00 00 85 C0 74 1B 8B 4D E0 83 C1 01 89 4D E0 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 88 85 11 FE FF FF A1 ?? ?? ?? ?? 50 8D 8D 10 FE FF FF 51 8D 55 FC 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 C4 66 8B 4D FC 66 89 08 8B 55 C4 83 C2 02 89 55 C4 EB 14 8B 45 C4 8A 8D 28 FE FF FF 88 08 8B 55 C4 83 C2 01 89 55 C4 EB 0F 8B 85 1C FE FF FF 83 C0 01 89 85 1C FE FF FF EB 1E 8B 4D E0 83 E9 01 89 4D E0 8B 55 08 52 8B 85 28 FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 08 EB 05 E9 B9 FE FF FF 8B 8D 1C FE FF FF 3B 4D C4 74 31 0F BE 55 90 85 D2 75 27 8B 45 CC 83 C0 01 89 45 CC 83 7D F4 63 74 18 0F BE 4D 9C 85 C9 74 0A 8B 55 C4 66 C7 02 00 00 EB 06 8B 45 C4 C6 00 00 EB 05 E9 F4 0A 00 00 E9 99 09 00 00 C7 45 F4 64 00 00 00 83 BD 28 FE FF FF 2D 75 0B 8A 4D 98 80 C1 01 88 4D 98 EB 09 83 BD 28 FE FF FF 2B 75 3D 8B 55 E4 83 EA 01 89 55 E4 83 7D E4 00 75 13 83 BD 18 FE FF FF 00 74 0A 8A 45 E8 04 01 88 45 E8 EB 1B 8B 4D E0 83 C1 01 89 4D E0 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 89 85 28 FE FF FF 83 BD 28 FE FF FF 30 0F 85 95 00 00 00 8B 45 E0 83 C0 01 89 45 E0 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 89 85 28 FE FF FF 0F BE 95 28 FE FF FF 83 FA 78 74 0C 0F BE 85 28 FE FF FF 83 F8 58 75 24 8B 4D E0 83 C1 01 89 4D E0 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 89 85 28 FE FF FF C7 45 F4 78 00 00 00 EB 3E 8B 45 94 83 C0 01 89 45 94 83 7D F4 78 74 09 C7 45 F4 6F 00 00 00 EB 26 8B 4D E0 83 E9 01 89 4D E0 8B 55 08 52 8B 85 28 FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 08 C7 85 28 FE FF FF 30 00 00 00 EB 5E C6 45 C8 01 83 BD 28 FE FF FF 2D 75 0B 8A 4D 98 80 C1 01 88 4D 98 EB 09 83 BD 28 FE FF FF 2B 75 3D 8B 55 E4 83 EA 01 89 55 E4 83 7D E4 00 75 13 83 BD 18 FE FF FF 00 74 0A 8A 45 E8 04 01 88 45 E8 EB 1B 8B 4D E0 83 C1 01 89 4D E0 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 89 85 28 FE FF FF 83 BD 24 FE FF FF 00 0F 84 EE 01 00 00 0F BE 45 E8 85 C0 0F 85 C2 01 00 00 83 7D F4 78 0F 85 85 00 00 00 83 3D ?? ?? ?? ?? 01 7E 1C 68 80 00 00 00 8B 8D 28 FE FF FF 51 E8 ?? ?? ?? ?? 83 C4 08 89 85 F8 FD FF FF EB 1D 8B 95 28 FE FF FF A1 ?? ?? ?? ?? 33 C9 66 8B 0C 50 81 E1 80 00 00 00 89 8D F8 FD FF FF 83 BD F8 FD FF FF 00 74 2D B9 04 00 00 00 8B 45 D0 8B 55 D4 E8 ?? ?? ?? ?? 89 45 D0 89 55 D4 8B 95 28 FE FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 89 85 28 FE FF FF EB 08 8A 45 E8 04 01 88 45 E8 E9 A7 00 00 00 83 3D ?? ?? ?? ?? 01 7E 19 6A 04 8B 8D 28 FE FF FF 51 E8 ?? ?? ?? ?? 83 C4 08 89 85 F4 FD FF FF EB 1A 8B 95 28 FE FF FF A1 ?? ?? ?? ?? 33 C9 66 8B 0C 50 83 E1 04 89 8D F4 FD FF FF 83 BD F4 FD FF FF 00 74 5A 83 7D F4 6F 75 2C 83 BD 28 FE FF FF 38 7D 18 B9 03 00 00 00 8B 45 D0 8B 55 D4 E8 ?? ?? ?? ?? 89 45 D0 89 55 D4 EB 09 8A 55 E8 80 C2 01 88 55 E8 EB 26 B9 02 00 00 00 8B 45 D0 8B 55 D4 E8 ?? ?? ?? ?? 03 45 D0 13 55 D4 B9 01 00 00 00 E8 ?? ?? ?? ?? 89 45 D0 89 55 D4 EB 08 8A 45 E8 04 01 88 45 E8 0F BE 4D E8 85 C9 75 63 8B 55 94 83 C2 01 89 55 94 8B 85 28 FE FF FF 83 E8 30 99 8B 4D D0 03 C8 8B 45 D4 13 C2 89 4D D0 89 45 D4 83 BD 18 FE FF FF 00 74 1A 8B 4D E4 83 E9 01 89 4D E4 83 7D E4 00 75 0B 8A 55 E8 80 C2 01 88 55 E8 EB 1B 8B 45 E0 83 C0 01 89 45 E0 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 89 85 28 FE FF FF EB 1C 8B 55 E0 83 EA 01 89 55 E0 8B 45 08 50 8B 8D 28 FE FF FF 51 E8 ?? ?? ?? ?? 83 C4 08 E9 32 FE FF FF 0F BE 55 98 85 D2 74 13 8B 45 D0 F7 D8 8B 4D D4 83 D1 00 F7 D9 89 45 D0 89 4D D4 E9 A4 01 00 00 0F BE 55 E8 85 D2 0F 85 88 01 00 00 83 7D F4 78 74 06 83 7D F4 70 75 78 83 3D ?? ?? ?? ?? 01 7E 1C 68 80 00 00 00 8B 85 28 FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 08 89 85 F0 FD FF FF EB 1D 8B 8D 28 FE FF FF 8B 15 ?? ?? ?? ?? 33 C0 66 8B 04 4A 25 80 00 00 00 89 85 F0 FD FF FF 83 BD F0 FD FF FF 00 74 20 8B 4D C0 C1 E1 04 89 4D C0 8B 95 28 FE FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 89 85 28 FE FF FF EB 08 8A 45 E8 04 01 88 45 E8 E9 82 00 00 00 83 3D ?? ?? ?? ?? 01 7E 19 6A 04 8B 8D 28 FE FF FF 51 E8 ?? ?? ?? ?? 83 C4 08 89 85 EC FD FF FF EB 1A 8B 95 28 FE FF FF A1 ?? ?? ?? ?? 33 C9 66 8B 0C 50 83 E1 04 89 8D EC FD FF FF 83 BD EC FD FF FF 00 74 34 83 7D F4 6F 75 1E 83 BD 28 FE FF FF 38 7D 0B 8B 55 C0 C1 E2 03 89 55 C0 EB 08 8A 45 E8 04 01 88 45 E8 EB 0E 8B 4D C0 8B 55 C0 8D 04 8A D1 E0 89 45 C0 EB 09 8A 4D E8 80 C1 01 88 4D E8 0F BE 55 E8 85 D2 75 59 8B 45 94 83 C0 01 89 45 94 8B 8D 28 FE FF FF 8B 55 C0 8D 44 0A D0 89 45 C0 83 BD 18 FE FF FF 00 74 1A 8B 4D E4 83 E9 01 89 4D E4 83 7D E4 00 75 0B 8A 55 E8 80 C2 01 88 55 E8 EB 1B 8B 45 E0 83 C0 01 89 45 E0 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 89 85 28 FE FF FF EB 1C 8B 55 E0 83 EA 01 89 55 E0 8B 45 08 50 8B 8D 28 FE FF FF 51 E8 ?? ?? ?? ?? 83 C4 08 E9 6C FE FF FF 0F BE 55 98 85 D2 74 08 8B 45 C0 F7 D8 89 45 C0 83 7D F4 46 75 07 C7 45 94 00 00 00 00 83 7D 94 00 74 48 0F BE 4D 90 85 C9 75 3E 8B 55 CC 83 C2 01 89 55 CC 83 BD 24 FE FF FF 00 74 10 8B 45 C4 8B 4D D0 89 08 8B 55 D4 89 50 04 EB 1C 0F BE 45 C8 85 C0 74 0A 8B 4D C4 8B 55 C0 89 11 EB 0A 8B 45 C4 66 8B 4D C0 66 89 08 EB 05 E9 8D 05 00 00 E9 32 04 00 00 8B 55 E0 89 55 C0 0F BE 45 90 85 C0 75 02 EB AF E9 1D 04 00 00 8D 8D 30 FE FF FF 89 8D 20 FE FF FF 83 BD 28 FE FF FF 2D 75 1A 8B 95 20 FE FF FF C6 02 2D 8B 85 20 FE FF FF 83 C0 01 89 85 20 FE FF FF EB 09 83 BD 28 FE FF FF 2B 75 24 8B 4D E4 83 E9 01 89 4D E4 8B 55 E0 83 C2 01 89 55 E0 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 28 FE FF FF 83 BD 18 FE FF FF 00 74 09 81 7D E4 5D 01 00 00 7E 07 C7 45 E4 5D 01 00 00 83 3D ?? ?? ?? ?? 01 7E 19 6A 04 8B 8D 28 FE FF FF 51 E8 ?? ?? ?? ?? 83 C4 08 89 85 E8 FD FF FF EB 1A 8B 95 28 FE FF FF A1 ?? ?? ?? ?? 33 C9 66 8B 0C 50 83 E1 04 89 8D E8 FD FF FF 83 BD E8 FD FF FF 00 74 56 8B 55 E4 8B 45 E4 83 E8 01 89 45 E4 85 D2 74 46 8B 4D 94 83 C1 01 89 4D 94 8B 95 20 FE FF FF 8A 85 28 FE FF FF 88 02 8B 8D 20 FE FF FF 83 C1 01 89 8D 20 FE FF FF 8B 55 E0 83 C2 01 89 55 E0 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 28 FE FF FF E9 65 FF FF FF 0F BE 0D ?? ?? ?? ?? 0F BE 95 28 FE FF FF 3B CA 0F 85 E7 00 00 00 8B 45 E4 8B 4D E4 83 E9 01 89 4D E4 85 C0 0F 84 D3 00 00 00 8B 55 E0 83 C2 01 89 55 E0 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 28 FE FF FF 8B 8D 20 FE FF FF 8A 15 ?? ?? ?? ?? 88 11 8B 85 20 FE FF FF 83 C0 01 89 85 20 FE FF FF 83 3D ?? ?? ?? ?? 01 7E 19 6A 04 8B 8D 28 FE FF FF 51 E8 ?? ?? ?? ?? 83 C4 08 89 85 E4 FD FF FF EB 1A 8B 95 28 FE FF FF A1 ?? ?? ?? ?? 33 C9 66 8B 0C 50 83 E1 04 89 8D E4 FD FF FF 83 BD E4 FD FF FF 00 74 56 8B 55 E4 8B 45 E4 83 E8 01 89 45 E4 85 D2 74 46 8B 4D 94 83 C1 01 89 4D 94 8B 95 20 FE FF FF 8A 85 28 FE FF FF 88 02 8B 8D 20 FE FF FF 83 C1 01 89 8D 20 FE FF FF 8B 55 E0 83 C2 01 89 55 E0 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 28 FE FF FF E9 65 FF FF FF 83 7D 94 00 0F 84 5B 01 00 00 83 BD 28 FE FF FF 65 74 0D 83 BD 28 FE FF FF 45 0F 85 45 01 00 00 8B 4D E4 8B 55 E4 83 EA 01 89 55 E4 85 C9 0F 84 31 01 00 00 8B 85 20 FE FF FF C6 00 65 8B 8D 20 FE FF FF 83 C1 01 89 8D 20 FE FF FF 8B 55 E0 83 C2 01 89 55 E0 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 28 FE FF FF 83 BD 28 FE FF FF 2D 75 1A 8B 8D 20 FE FF FF C6 01 2D 8B 95 20 }
	condition:
		$1
}

rule file_285_2_0 {
	meta:
		name = "__inc"
		size = 81
		refs = "0040 __filbuf"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 8B 48 04 83 E9 01 8B 55 08 89 4A 04 8B 45 08 83 78 04 00 7C 1F 8B 4D 08 8B 11 0F BE 02 25 FF 00 00 00 89 45 FC 8B 4D 08 8B 11 83 C2 01 8B 45 08 89 10 EB 0F 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_285_3_0 {
	meta:
		name = "__un_inc"
		size = 27
		refs = "0012 _ungetc"
	strings:
		$1 = { 55 8B EC 83 7D 08 FF 74 10 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_285_4_0 {
	meta:
		name = "__whiteout"
		size = 57
		refs = "0016 __inc 0025 _isspace"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 8B 08 83 C1 01 8B 55 08 89 0A 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 02 EB D2 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_287_0_0 {
	meta:
		name = "__strset"
		size = 32
	strings:
		$1 = { 55 8B EC 57 8B 7D 08 8B D7 33 C0 83 C9 FF F2 AE 41 41 F7 D9 8A 45 0C 8B FA F3 AA 8B C2 5F C9 C3 }
	condition:
		$1
}

rule file_288_0_0 {
	meta:
		name = "__expand_base"
		size = 380
		refs = "0015 ___active_heap 0025 ___sbh_find_block 0041 ___sbh_threshold 0054 ___sbh_resize_block 008e __crtheap 0095 __imp__HeapReAlloc@16 00d4 ___old_sbh_find_block 00f0 ___old_sbh_threshold 010a ___old_sbh_resize_block"
	strings:
		$1 = { 55 8B EC 83 EC 14 83 7D 0C E0 76 07 33 C0 E9 65 01 00 00 83 3D ?? ?? ?? ?? 03 0F 85 81 00 00 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 F8 83 7D F8 00 74 30 C7 45 FC 00 00 00 00 8B 4D 0C 3B 0D ?? ?? ?? ?? 77 1E 8B 55 0C 52 8B 45 08 50 8B 4D F8 51 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 06 8B 55 08 89 55 FC 83 7D F8 00 75 31 83 7D 0C 00 75 07 C7 45 0C 01 00 00 00 8B 45 0C 83 C0 0F 24 F0 89 45 0C 8B 4D 0C 51 8B 55 08 52 6A 10 A1 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 89 45 FC E9 D4 00 00 00 83 3D ?? ?? ?? ?? 02 0F 85 94 00 00 00 83 7D 0C 00 75 07 C7 45 0C 01 00 00 00 8B 4D 0C 83 C1 0F 83 E1 F0 89 4D 0C 8D 55 F4 52 8D 45 EC 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F0 83 7D F0 00 74 3C C7 45 FC 00 00 00 00 8B 55 0C 3B 15 ?? ?? ?? ?? 77 25 8B 45 0C C1 E8 04 50 8B 4D F0 51 8B 55 F4 52 8B 45 EC 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 06 8B 4D 08 89 4D FC 8B 45 FC EB 58 83 7D F0 00 75 1A 8B 55 0C 52 8B 45 08 50 6A 10 8B 0D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 89 45 FC EB 33 83 7D 0C 00 75 07 C7 45 0C 01 00 00 00 8B 55 0C 83 C2 0F 83 E2 F0 89 55 0C 8B 45 0C 50 8B 4D 08 51 6A 10 8B 15 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 89 45 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_289_0_0 {
	meta:
		name = "__dosmaperr"
		size = 139
		refs = "0008 __doserrno 002d _errtable 003f _errno"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 A3 ?? ?? ?? ?? C7 45 FC 00 00 00 00 EB 09 8B 4D FC 83 C1 01 89 4D FC 83 7D FC 2D 73 23 8B 55 FC 8B 45 08 3B 04 D5 ?? ?? ?? ?? 75 12 8B 4D FC 8B 14 CD ?? ?? ?? ?? 89 15 ?? ?? ?? ?? EB 42 EB CE 83 7D 08 13 72 12 83 7D 08 24 77 0C C7 05 ?? ?? ?? ?? 0D 00 00 00 EB 28 81 7D 08 BC 00 00 00 72 15 81 7D 08 CA 00 00 00 77 0C C7 05 ?? ?? ?? ?? 08 00 00 00 EB 0A C7 05 ?? ?? ?? ?? 16 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_290_0_0 {
	meta:
		name = "_fgetwc"
		size = 456
		refs = "0035 ___pioinfo 0044 ___badioinfo 00a1 __filbuf 00d0 __pctype 0140 _ungetc 0167 _mbtowc 0175 _errno 01bd __filwbuf"
	strings:
		$1 = { 55 8B EC 83 EC 1C 8B 45 08 8B 48 0C 83 E1 40 85 C9 0F 85 72 01 00 00 8B 55 08 83 7A 10 FF 74 21 8B 45 08 8B 48 10 C1 F9 05 8B 55 08 8B 42 10 83 E0 1F 8B 0C 8D ?? ?? ?? ?? 8D 14 C1 89 55 EC EB 07 C7 45 EC ?? ?? ?? ?? 8B 45 EC 0F BE 48 04 81 E1 80 00 00 00 85 C9 0F 84 2C 01 00 00 C7 45 FC 01 00 00 00 8B 55 08 8B 42 04 83 E8 01 8B 4D 08 89 41 04 8B 55 08 83 7A 04 00 7C 20 8B 45 08 8B 08 0F BE 11 81 E2 FF 00 00 00 89 55 E8 8B 45 08 8B 08 83 C1 01 8B 55 08 89 0A EB 0F 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 E8 8B 4D E8 89 4D F0 83 7D F0 FF 75 09 66 0D FF FF E9 04 01 00 00 8A 55 F0 88 55 F4 8B 45 F4 25 FF 00 00 00 8B 0D ?? ?? ?? ?? 33 D2 66 8B 14 41 81 E2 00 80 00 00 85 D2 74 76 8B 45 08 8B 48 04 83 E9 01 8B 55 08 89 4A 04 8B 45 08 83 78 04 00 7C 1F 8B 4D 08 8B 11 0F BE 02 25 FF 00 00 00 89 45 E4 8B 4D 08 8B 11 83 C2 01 8B 45 08 89 10 EB 0F 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 E4 8B 55 E4 89 55 F0 83 7D F0 FF 75 17 8B 45 08 50 0F BE 4D F4 51 E8 ?? ?? ?? ?? 83 C4 08 66 0D FF FF EB 77 8A 55 F0 88 55 F5 C7 45 FC 02 00 00 00 8B 45 FC 50 8D 4D F4 51 8D 55 F8 52 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 FF 75 10 C7 05 ?? ?? ?? ?? 2A 00 00 00 66 0D FF FF EB 41 66 8B 45 F8 EB 3B 8B 45 08 8B 48 04 83 E9 02 8B 55 08 89 4A 04 8B 45 08 83 78 04 00 7C 17 8B 4D 08 8B 11 66 8B 02 8B 4D 08 8B 11 83 C2 02 8B 4D 08 89 11 EB 0C 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_291_0_0 {
	meta:
		name = "_wWinMainCRTStartup"
		size = 342
		refs = "0006 $T17566 000b __except_handler3 0011 __except_list 0028 __imp__GetVersion@0 002d __osver 003f __winminor 0051 __winmajor 0066 __winver 007f __heap_init 008d _fast_error_exit 009c __ioinit 00a1 ___crtGetCommandLineW 00a6 __wcmdln 00ab ___crtGetEnvironmentStringsW 00b0 __wenvptr 00b5 __wsetargv 00ba __wsetenvp 00bf __cinit 00d0 __imp__GetStartupInfoW@4 00d5 __wwincmdln 0108 __imp__GetModuleHandleA@4 010e _wWinMain@16 011a _exit 0131 __XcptFilter 0141 __exit"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 C4 A4 53 56 57 89 65 E8 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? C1 E8 08 25 FF 00 00 00 A3 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 81 E1 FF 00 00 00 89 0D ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? C1 E2 08 03 15 ?? ?? ?? ?? 89 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? C1 E8 10 25 FF FF 00 00 A3 ?? ?? ?? ?? 6A 00 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 0A 6A 1C E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 45 D0 00 00 00 00 8D 4D A4 51 FF 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 9C 8B 55 D0 83 E2 01 85 D2 74 0D 8B 45 D4 25 FF FF 00 00 89 45 94 EB 07 C7 45 94 0A 00 00 00 8B 4D 94 51 8B 55 9C 52 6A 00 6A 00 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 89 45 A0 8B 45 A0 50 E8 ?? ?? ?? ?? 8B 4D EC 8B 11 8B 02 89 45 98 8B 4D EC 51 8B 55 98 52 E8 ?? ?? ?? ?? 83 C4 08 C3 8B 65 E8 8B 45 98 50 E8 ?? ?? ?? ?? 8B 4D F0 64 89 0D ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_291_1_0 {
	meta:
		name = "__amsg_exit"
		size = 45
		refs = "0005 ___error_mode 000d __FF_MSGBANNER 0016 __NMSG_WRITE 0024 __aexit_rtn"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? 01 75 05 E8 ?? ?? ?? ?? 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 68 FF 00 00 00 FF 15 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_291_2_0 {
	meta:
		name = "_fast_error_exit"
		size = 42
		refs = "0005 ___error_mode 000d __FF_MSGBANNER 0016 __NMSG_WRITE 0024 __imp__ExitProcess@4"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? 01 75 05 E8 ?? ?? ?? ?? 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 68 FF 00 00 00 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_292_1_0 {
	meta:
		name = "__wsopen"
		size = 1270
		refs = "005e __fmode 00ab _errno 00b5 __doserrno 00e1 $L17789 00e8 $L17790 0213 __umaskval 0294 __alloc_osfhnd 02d9 __imp__CreateFileW@28 02e8 __imp__GetLastError@0 02ee __dosmaperr 0303 __imp__GetFileType@4 0316 __imp__CloseHandle@4 0359 __set_osfhnd 0377 ___pioinfo 03b9 __lseek 03da __close 03fc __read 041d __chsize 04b1 $L17724 04b5 $L17725 04b9 $L17726 04bd $L17727 04c1 $L17728"
	strings:
		$1 = { 55 8B EC 83 EC 48 C7 45 DC 0C 00 00 00 C7 45 E0 00 00 00 00 8B 45 0C 25 80 00 00 00 85 C0 74 0D C7 45 E4 00 00 00 00 C6 45 C8 10 EB 0B C7 45 E4 01 00 00 00 C6 45 C8 00 8B 4D 0C 81 E1 00 80 00 00 85 C9 75 2C 8B 55 0C 81 E2 00 40 00 00 85 D2 74 0A 8A 45 C8 0C 80 88 45 C8 EB 15 81 3D ?? ?? ?? ?? 00 80 00 00 74 09 8A 4D C8 80 C9 80 88 4D C8 8B 55 0C 83 E2 03 89 55 C0 83 7D C0 00 74 0E 83 7D C0 01 74 11 83 7D C0 02 74 14 EB 1B C7 45 CC 00 00 00 80 EB 2E C7 45 CC 00 00 00 40 EB 25 C7 45 CC 00 00 00 C0 EB 1C C7 05 ?? ?? ?? ?? 16 00 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 83 C8 FF E9 E8 03 00 00 8B 45 10 89 45 BC 8B 4D BC 83 E9 10 89 4D BC 83 7D BC 30 77 36 8B 45 BC 33 D2 8A 90 ?? ?? ?? ?? FF 24 95 ?? ?? ?? ?? C7 45 F8 00 00 00 00 EB 37 C7 45 F8 01 00 00 00 EB 2E C7 45 F8 02 00 00 00 EB 25 C7 45 F8 03 00 00 00 EB 1C C7 05 ?? ?? ?? ?? 16 00 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 83 C8 FF E9 81 03 00 00 8B 4D 0C 81 E1 00 07 00 00 89 4D B8 81 7D B8 00 04 00 00 7F 37 81 7D B8 00 04 00 00 74 4B 81 7D B8 00 02 00 00 7F 1A 81 7D B8 00 02 00 00 74 54 83 7D B8 00 74 33 81 7D B8 00 01 00 00 74 33 EB 55 81 7D B8 00 03 00 00 74 43 EB 4A 81 7D B8 00 05 00 00 74 26 81 7D B8 00 06 00 00 74 26 81 7D B8 00 07 00 00 74 14 EB 2D C7 45 E8 03 00 00 00 EB 40 C7 45 E8 04 00 00 00 EB 37 C7 45 E8 01 00 00 00 EB 2E C7 45 E8 05 00 00 00 EB 25 C7 45 E8 02 00 00 00 EB 1C C7 05 ?? ?? ?? ?? 16 00 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 83 C8 FF E9 CF 02 00 00 C7 45 D8 80 00 00 00 8B 55 0C 81 E2 00 01 00 00 85 D2 74 3D 8D 45 14 89 45 D4 8B 4D D4 83 C1 04 89 4D D4 8B 55 D4 8B 42 FC 89 45 F0 C7 45 D4 00 00 00 00 8B 0D ?? ?? ?? ?? F7 D1 8B 55 F0 23 D1 81 E2 80 00 00 00 85 D2 75 07 C7 45 D8 01 00 00 00 8B 45 0C 83 E0 40 85 C0 74 18 8B 4D D8 81 C9 00 00 00 04 89 4D D8 8B 55 CC 81 CA 00 00 01 00 89 55 CC 8B 45 0C 25 00 10 00 00 85 C0 74 09 8B 4D D8 80 CD 01 89 4D D8 8B 55 0C 83 E2 20 85 D2 74 0D 8B 45 D8 0D 00 00 00 08 89 45 D8 EB 16 8B 4D 0C 83 E1 10 85 C9 74 0C 8B 55 D8 81 CA 00 00 00 10 89 55 D8 E8 ?? ?? ?? ?? 89 45 EC 83 7D EC FF 75 1C C7 05 ?? ?? ?? ?? 18 00 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 83 C8 FF E9 F0 01 00 00 6A 00 8B 45 D8 50 8B 4D E8 51 8D 55 DC 52 8B 45 F8 50 8B 4D CC 51 8B 55 08 52 FF 15 ?? ?? ?? ?? 89 45 FC 83 7D FC FF 75 17 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 83 C8 FF E9 B0 01 00 00 8B 45 FC 50 FF 15 ?? ?? ?? ?? 89 45 F4 83 7D F4 00 75 21 8B 4D FC 51 FF 15 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 83 C8 FF E9 7C 01 00 00 83 7D F4 02 75 0B 8A 55 C8 80 CA 40 88 55 C8 EB 0E 83 7D F4 03 75 08 8A 45 C8 0C 08 88 45 C8 8B 4D FC 51 8B 55 EC 52 E8 ?? ?? ?? ?? 83 C4 08 8A 45 C8 0C 01 88 45 C8 8B 4D EC C1 F9 05 8B 55 EC 83 E2 1F 8B 04 8D ?? ?? ?? ?? 8A 4D C8 88 4C D0 04 0F BE 55 C8 83 E2 48 85 D2 0F 85 D3 00 00 00 0F BE 45 C8 25 80 00 00 00 85 C0 0F 84 C2 00 00 00 8B 4D 0C 83 E1 02 85 C9 0F 84 B4 00 00 00 6A 02 6A FF 8B 55 EC 52 E8 ?? ?? ?? ?? 83 C4 0C 89 45 C4 83 7D C4 FF 75 22 81 3D ?? ?? ?? ?? 83 00 00 00 74 14 8B 45 EC 50 E8 ?? ?? ?? ?? 83 C4 04 83 C8 FF E9 C4 00 00 00 EB 79 66 C7 45 D0 00 00 6A 01 8D 4D D0 51 8B 55 EC 52 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 33 8B 45 D0 25 FF FF 00 00 83 F8 1A 75 26 8B 4D C4 51 8B 55 EC 52 E8 ?? ?? ?? ?? 83 C4 08 83 F8 FF 75 11 8B 45 EC 50 E8 ?? ?? ?? ?? 83 C4 04 83 C8 FF EB 73 6A 00 6A 00 8B 4D EC 51 E8 ?? ?? ?? ?? 83 C4 0C 89 45 C4 83 7D C4 FF 75 11 8B 55 EC 52 E8 ?? ?? ?? ?? 83 C4 04 83 C8 FF EB 49 0F BE 45 C8 83 E0 48 85 C0 75 3B 8B 4D 0C 83 E1 08 85 C9 74 31 8B 55 EC C1 FA 05 8B 45 EC 83 E0 1F 8B 0C 95 ?? ?? ?? ?? 8A 54 C1 04 80 CA 20 8B 45 EC C1 F8 05 8B 4D EC 83 E1 1F 8B 04 85 ?? ?? ?? ?? 88 54 C8 04 8B 45 EC 8B E5 5D C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 01 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 02 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 03 }
	condition:
		$1
}

rule file_293_0_0 {
	meta:
		name = "__ismbclegal"
		size = 83
		refs = "0013 __mbctype"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 C1 E8 08 25 FF 00 00 00 33 C9 8A 88 ?? ?? ?? ?? 83 E1 04 85 C9 74 27 8B 55 08 81 E2 FF 00 00 00 81 E2 FF 00 00 00 33 C0 8A 82 ?? ?? ?? ?? 83 E0 08 85 C0 74 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_294_0_0 {
	meta:
		name = "__copysign"
		size = 42
	strings:
		$1 = { 55 8B EC 83 EC 08 8B 45 08 89 45 F8 8B 4D 0C 81 E1 FF FF FF 7F 8B 55 14 81 E2 00 00 00 80 0B CA 89 4D FC DD 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_294_1_0 {
	meta:
		name = "__chgsign"
		size = 44
	strings:
		$1 = { 55 8B EC 83 EC 08 8B 45 08 89 45 F8 8B 4D 0C 81 E1 FF FF FF 7F 8B 55 0C F7 D2 81 E2 00 00 00 80 0B CA 89 4D FC DD 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_294_2_0 {
	meta:
		name = "__scalb"
		size = 25
		refs = "0010 _ldexp"
	strings:
		$1 = { 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_294_3_0 {
	meta:
		name = "__logb"
		size = 300
		refs = "0011 __ctrlfp 003c __sptype 0082 __handle_qnan1 0097 __real@8@3fff8000000000000000 00ae __except1 00bc __real@8@00000000000000000000 00cd __d_inf 00fc __decomp"
	strings:
		$1 = { 55 8B EC 83 EC 18 68 FF FF 00 00 68 3F 13 00 00 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 8B 45 0E 25 FF FF 00 00 25 F0 7F 00 00 3D F0 7F 00 00 0F 85 84 00 00 00 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 EC 83 7D EC 00 7E 42 83 7D EC 02 7E 08 83 7D EC 03 74 1B EB 34 68 FF FF 00 00 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 DD 45 08 E9 B5 00 00 00 8B 4D FC 51 8B 55 0C 52 8B 45 08 50 6A 25 E8 ?? ?? ?? ?? 83 C4 10 E9 9A 00 00 00 8B 4D FC 51 DD 45 08 DC 05 ?? ?? ?? ?? 83 EC 08 DD 1C 24 8B 55 0C 52 8B 45 08 50 6A 25 6A 08 E8 ?? ?? ?? ?? 83 C4 1C EB 71 DD 45 08 DC 1D ?? ?? ?? ?? DF E0 F6 C4 40 74 28 8B 4D FC 51 DD 05 ?? ?? ?? ?? D9 E0 83 EC 08 DD 1C 24 8B 55 0C 52 8B 45 08 50 6A 25 6A 04 E8 ?? ?? ?? ?? 83 C4 1C EB 39 8D 4D F8 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? DD D8 83 C4 0C 8B 4D F8 83 E9 01 89 4D E8 DB 45 E8 DD 5D F0 68 FF FF 00 00 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 08 DD 45 F0 8B E5 5D C3 }
	condition:
		$1
}

rule file_294_4_0 {
	meta:
		name = "__nextafter"
		size = 826
		refs = "0011 __ctrlfp 00bd __except2 010b __handle_qnan2 0142 __real@8@00000000000000000000 0253 __decomp 026f __set_exp"
	strings:
		$1 = { 55 8B EC 83 EC 24 68 FF FF 00 00 68 3F 13 00 00 E8 ?? ?? ?? ?? 83 C4 08 89 45 F4 8B 45 0E 25 FF FF 00 00 25 F0 7F 00 00 3D F0 7F 00 00 74 1B 8B 4D 16 81 E1 FF FF 00 00 81 E1 F0 7F 00 00 81 F9 F0 7F 00 00 0F 85 CD 00 00 00 8B 55 0E 81 E2 FF FF 00 00 81 E2 F8 7F 00 00 81 FA F0 7F 00 00 75 10 8B 45 0C C1 E0 0D 85 C0 75 2D 83 7D 08 00 75 27 8B 4D 16 81 E1 FF FF 00 00 81 E1 F8 7F 00 00 81 F9 F0 7F 00 00 75 41 8B 55 14 C1 E2 0D 85 D2 75 06 83 7D 10 00 74 31 8B 45 F4 50 DD 45 08 DC 45 10 83 EC 08 DD 1C 24 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 6A 26 6A 08 E8 ?? ?? ?? ?? 83 C4 24 E9 6D 02 00 00 8B 55 0E 81 E2 FF FF 00 00 81 E2 F8 7F 00 00 81 FA F8 7F 00 00 74 14 8B 45 16 25 FF FF 00 00 25 F8 7F 00 00 3D F8 7F 00 00 75 23 8B 4D F4 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 6A 26 E8 ?? ?? ?? ?? 83 C4 18 E9 1F 02 00 00 DD 45 10 DC 5D 08 DF E0 F6 C4 40 74 19 68 FF FF 00 00 8B 45 F4 50 E8 ?? ?? ?? ?? 83 C4 08 DD 45 08 E9 F9 01 00 00 DD 45 08 DC 1D ?? ?? ?? ?? DF E0 F6 C4 40 74 24 C7 45 F8 01 00 00 00 DD 45 10 DC 5D 08 DF E0 F6 C4 41 75 09 C7 45 FC 00 00 00 00 EB 07 C7 45 FC 00 00 00 80 DD 45 08 DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 75 0D DD 45 10 DC 5D 08 DF E0 F6 C4 01 75 1D DD 45 08 DC 1D ?? ?? ?? ?? DF E0 F6 C4 01 74 2D DD 45 10 DC 5D 08 DF E0 F6 C4 41 75 20 8B 4D 08 83 E9 01 89 4D F8 8B 55 0C 89 55 FC 83 7D 08 00 75 09 8B 45 FC 83 E8 01 89 45 FC EB 58 DD 45 08 DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 75 0D DD 45 10 DC 5D 08 DF E0 F6 C4 41 74 1D DD 45 08 DC 1D ?? ?? ?? ?? DF E0 F6 C4 01 74 2B DD 45 10 DC 5D 08 DF E0 F6 C4 01 74 1E 8B 4D 08 83 C1 01 89 4D F8 8B 55 0C 89 55 FC 83 7D F8 00 75 09 8B 45 FC 83 C0 01 89 45 FC 8B 4D FE 81 E1 FF FF 00 00 81 E1 F0 7F 00 00 85 C9 75 70 8B 55 FC C1 E2 0C 85 D2 75 06 83 7D F8 00 74 60 8D 45 F0 50 8B 4D FC 51 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 0C DD 5D E8 8B 45 F0 05 00 06 00 00 50 8B 4D EC 51 8B 55 E8 52 E8 ?? ?? ?? ?? 83 C4 0C DD 5D F8 8B 45 F4 50 8B 4D FC 51 8B 55 F8 52 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 6A 26 6A 12 E8 ?? ?? ?? ?? 83 C4 24 E9 90 00 00 00 81 7D FC 00 00 F0 7F 75 06 83 7D F8 00 74 0F 81 7D FC 00 00 F0 FF 75 64 83 7D F8 00 75 5E 8D 4D E4 51 8B 55 FC 52 8B 45 F8 50 E8 ?? ?? ?? ?? 83 C4 0C DD 5D DC 8B 4D E4 81 E9 00 06 00 00 51 8B 55 E0 52 8B 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C DD 5D F8 8B 4D F4 51 8B 55 FC 52 8B 45 F8 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 6A 26 6A 11 E8 ?? ?? ?? ?? 83 C4 24 EB 14 68 FF FF 00 00 8B 55 F4 52 E8 ?? ?? ?? ?? 83 C4 08 DD 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_294_5_0 {
	meta:
		name = "__finite"
		size = 34
	strings:
		$1 = { 55 8B EC 8B 45 0E 25 FF FF 00 00 25 F0 7F 00 00 3D F0 7F 00 00 75 04 33 C0 EB 05 B8 01 00 00 00 5D C3 }
	condition:
		$1
}

rule file_294_6_0 {
	meta:
		name = "__isnan"
		size = 73
	strings:
		$1 = { 55 8B EC 8B 45 0E 25 FF FF 00 00 25 F8 7F 00 00 3D F0 7F 00 00 75 10 8B 4D 0C C1 E1 0D 85 C9 75 1D 83 7D 08 00 75 17 8B 55 0E 81 E2 FF FF 00 00 81 E2 F8 7F 00 00 81 FA F8 7F 00 00 75 07 B8 01 00 00 00 EB 02 33 C0 5D C3 }
	condition:
		$1
}

rule file_294_7_0 {
	meta:
		name = "__fpclass"
		size = 211
		refs = "0023 __sptype 00a8 __real@8@00000000000000000000"
	strings:
		$1 = { 55 8B EC 83 EC 08 8B 45 0E 25 FF FF 00 00 25 F0 7F 00 00 3D F0 7F 00 00 75 46 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 F8 83 7D F8 01 74 0E 83 7D F8 02 74 12 83 7D F8 03 74 13 EB 18 B8 00 02 00 00 E9 84 00 00 00 B8 04 00 00 00 EB 7D B8 02 00 00 00 EB 76 B8 01 00 00 00 EB 6F 8B 45 0E 25 FF FF 00 00 25 00 80 00 00 89 45 FC 8B 4D 0E 81 E1 FF FF 00 00 81 E1 F0 7F 00 00 85 C9 75 20 8B 55 0C C1 E2 0C 85 D2 75 06 83 7D 08 00 74 10 8B 45 FC F7 D8 1B C0 24 90 05 80 00 00 00 EB 2C DD 45 08 DC 1D ?? ?? ?? ?? DF E0 F6 C4 40 74 0E 8B 45 FC F7 D8 1B C0 24 E0 83 C0 40 EB 0E 8B 45 FC F7 D8 1B C0 24 08 05 00 01 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_297_0_0 {
	meta:
		name = "__wchdir"
		size = 218
		refs = "000f __imp__SetCurrentDirectoryW@4 0029 __imp__GetCurrentDirectoryW@8 0088 _towupper 00b8 __imp__SetEnvironmentVariableW@8 00c6 __imp__GetLastError@0 00cc __dosmaperr"
	strings:
		$1 = { 55 8B EC 81 EC 14 02 00 00 8B 45 08 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 A9 00 00 00 8D 8D F4 FD FF FF 51 68 05 01 00 00 FF 15 ?? ?? ?? ?? 85 C0 0F 84 8F 00 00 00 8B 95 F4 FD FF FF 81 E2 FF FF 00 00 83 FA 5C 74 10 8B 85 F4 FD FF FF 25 FF FF 00 00 83 F8 2F 75 20 8B 8D F4 FD FF FF 81 E1 FF FF 00 00 8B 95 F6 FD FF FF 81 E2 FF FF 00 00 3B CA 75 04 33 C0 EB 60 66 C7 85 EC FD FF FF 3D 00 66 8B 85 F4 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 66 89 85 EE FD FF FF 66 C7 85 F0 FD FF FF 3A 00 66 C7 85 F2 FD FF FF 00 00 8D 8D F4 FD FF FF 51 8D 95 EC FD FF FF 52 FF 15 ?? ?? ?? ?? 85 C0 74 04 33 C0 EB 12 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 83 C8 FF 8B E5 5D C3 }
	condition:
		$1
}

rule file_301_0_0 {
	meta:
		name = "__wcsnicmp"
		size = 381
		refs = "0019 ___lc_handle 0100 _towlower"
	strings:
		$1 = { 55 8B EC 83 EC 18 C7 45 FC 00 00 00 00 83 7D 10 00 0F 84 5F 01 00 00 83 3D ?? ?? ?? ?? 00 0F 85 C3 00 00 00 8B 45 08 33 C9 66 8B 08 83 F9 5A 7F 1D 8B 55 08 33 C0 66 8B 02 83 F8 41 7C 10 8B 4D 08 33 D2 66 8B 11 83 C2 20 89 55 F0 EB 0B 8B 45 08 33 C9 66 8B 08 89 4D F0 66 8B 55 F0 66 89 55 F8 8B 45 0C 33 C9 66 8B 08 83 F9 5A 7F 1D 8B 55 0C 33 C0 66 8B 02 83 F8 41 7C 10 8B 4D 0C 33 D2 66 8B 11 83 C2 20 89 55 EC EB 0B 8B 45 0C 33 C9 66 8B 08 89 4D EC 66 8B 55 EC 66 89 55 F4 8B 45 08 83 C0 02 89 45 08 8B 4D 0C 83 C1 02 89 4D 0C 8B 55 10 83 EA 01 89 55 10 83 7D 10 00 74 26 8B 45 F8 25 FF FF 00 00 85 C0 74 1A 8B 4D F8 81 E1 FF FF 00 00 8B 55 F4 81 E2 FF FF 00 00 3B CA 0F 84 3F FF FF FF EB 79 8B 45 08 66 8B 08 66 89 4D EA 66 8B 55 EA 52 8B 45 08 83 C0 02 89 45 08 E8 ?? ?? ?? ?? 83 C4 04 66 89 45 F8 8B 4D 0C 66 8B 11 66 89 55 E8 66 8B 45 E8 50 8B 4D 0C 83 C1 02 89 4D 0C E8 ?? ?? ?? ?? 83 C4 04 66 89 45 F4 8B 55 10 83 EA 01 89 55 10 83 7D 10 00 74 22 8B 45 F8 25 FF FF 00 00 85 C0 74 16 8B 4D F8 81 E1 FF FF 00 00 8B 55 F4 81 E2 FF FF 00 00 3B CA 74 87 8B 45 F8 25 FF FF 00 00 8B 4D F4 81 E1 FF FF 00 00 2B C1 89 45 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_302_1_0 {
	meta:
		name = "_wcstoxl"
		size = 721
		refs = "002e _iswctype 019c _towupper 0275 _errno"
	strings:
		$1 = { 55 8B EC 83 EC 14 8B 45 08 89 45 FC C7 45 F4 00 00 00 00 8B 4D FC 66 8B 11 66 89 55 F8 8B 45 FC 83 C0 02 89 45 FC 6A 08 66 8B 4D F8 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 15 8B 55 FC 66 8B 02 66 89 45 F8 8B 4D FC 83 C1 02 89 4D FC EB D8 8B 55 F8 81 E2 FF FF 00 00 83 FA 2D 75 1D 8B 45 14 0C 02 89 45 14 8B 4D FC 66 8B 11 66 89 55 F8 8B 45 FC 83 C0 02 89 45 FC EB 21 8B 4D F8 81 E1 FF FF 00 00 83 F9 2B 75 13 8B 55 FC 66 8B 02 66 89 45 F8 8B 4D FC 83 C1 02 89 4D FC 83 7D 10 00 7C 0C 83 7D 10 01 74 06 83 7D 10 24 7E 15 83 7D 0C 00 74 08 8B 55 0C 8B 45 08 89 02 33 C0 E9 0C 02 00 00 83 7D 10 00 75 41 8B 4D F8 81 E1 FF FF 00 00 83 F9 30 74 09 C7 45 10 0A 00 00 00 EB 2A 8B 55 FC 33 C0 66 8B 02 83 F8 78 74 0D 8B 4D FC 33 D2 66 8B 11 83 FA 58 75 09 C7 45 10 10 00 00 00 EB 07 C7 45 10 08 00 00 00 83 7D 10 10 75 43 8B 45 F8 25 FF FF 00 00 83 F8 30 75 36 8B 4D FC 33 D2 66 8B 11 83 FA 78 74 0D 8B 45 FC 33 C9 66 8B 08 83 F9 58 75 1C 8B 55 FC 83 C2 02 89 55 FC 8B 45 FC 66 8B 08 66 89 4D F8 8B 55 FC 83 C2 02 89 55 FC 83 C8 FF 33 D2 F7 75 10 89 45 F0 6A 04 66 8B 45 F8 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 11 8B 4D F8 81 E1 FF FF 00 00 83 E9 30 89 4D EC EB 32 68 03 01 00 00 66 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 1A 66 8B 45 F8 50 E8 ?? ?? ?? ?? 83 C4 04 25 FF FF 00 00 83 E8 37 89 45 EC EB 02 EB 5F 8B 4D EC 3B 4D 10 72 02 EB 55 8B 55 14 83 CA 08 89 55 14 8B 45 F4 3B 45 F0 72 15 8B 4D F4 3B 4D F0 75 1C 83 C8 FF 33 D2 F7 75 10 39 55 EC 77 0F 8B 55 F4 0F AF 55 10 03 55 EC 89 55 F4 EB 08 8B 45 14 0C 04 89 45 14 8B 4D FC 66 8B 11 66 89 55 F8 8B 45 FC 83 C0 02 89 45 FC E9 4B FF FF FF 8B 4D FC 83 E9 02 89 4D FC 8B 55 14 83 E2 08 85 D2 75 15 83 7D 0C 00 74 06 8B 45 08 89 45 FC C7 45 F4 00 00 00 00 EB 71 8B 4D 14 83 E1 04 85 C9 75 30 8B 55 14 83 E2 01 85 D2 75 5D 8B 45 14 83 E0 02 85 C0 74 09 81 7D F4 00 00 00 80 77 13 8B 4D 14 83 E1 02 85 C9 75 40 81 7D F4 FF FF FF 7F 76 37 C7 05 ?? ?? ?? ?? 22 00 00 00 8B 55 14 83 E2 01 85 D2 74 09 C7 45 F4 FF FF FF FF EB 1A 8B 45 14 83 E0 02 85 C0 74 09 C7 45 F4 00 00 00 80 EB 07 C7 45 F4 FF FF FF 7F 83 7D 0C 00 74 08 8B 4D 0C 8B 55 FC 89 11 8B 45 14 83 E0 02 85 C0 74 08 8B 4D F4 F7 D9 89 4D F4 8B 45 F4 8B E5 5D C3 }
	condition:
		$1
}

rule file_303_0_0 {
	meta:
		name = "__mbsncoll"
		size = 119
		refs = "0019 __mbsnbcnt 0038 ___mbcodepage 0050 ___mblcid 0056 ___crtCompareStringA"
	strings:
		$1 = { 55 8B EC 83 EC 0C 83 7D 10 00 75 04 33 C0 EB 63 8B 45 10 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 F8 8B 55 10 52 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 F4 8B 0D ?? ?? ?? ?? 51 8B 55 F4 52 8B 45 0C 50 8B 4D F8 51 8B 55 08 52 6A 00 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 1C 89 45 FC 83 7D FC 00 75 07 B8 FF FF FF 7F EB 06 8B 45 FC 83 E8 02 8B E5 5D C3 }
	condition:
		$1
}

rule file_309_0_0 {
	meta:
		name = "__aulldiv"
		size = 34
	strings:
		$1 = { 53 56 8B 44 24 18 0B C0 75 18 8B 4C 24 14 8B 44 24 10 33 D2 F7 F1 8B D8 8B 44 24 0C F7 F1 8B D3 EB 41 }
	condition:
		$1
}

rule file_309_2_0 {
	meta:
		name = "L3"
		size = 46
	strings:
		$1 = { D1 E9 D1 DB D1 EA D1 D8 0B C9 75 F4 F7 F3 8B F0 F7 64 24 18 8B C8 8B 44 24 14 F7 E6 03 D1 72 0E 3B 54 24 10 77 08 72 07 3B 44 24 0C 76 01 }
	condition:
		$1
}

rule file_310_0_0 {
	meta:
		name = "__fputchar"
		size = 93
		refs = "0005 __iob 004c __flsbuf"
	strings:
		$1 = { 55 8B EC 51 A1 ?? ?? ?? ?? 83 E8 01 A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 7C 28 8B 0D ?? ?? ?? ?? 8A 55 08 88 11 0F BE 45 08 25 FF 00 00 00 89 45 FC 8B 0D ?? ?? ?? ?? 83 C1 01 89 0D ?? ?? ?? ?? EB 14 68 ?? ?? ?? ?? 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_312_0_0 {
	meta:
		name = "__wrename"
		size = 69
		refs = "000e __imp__MoveFileW@8 0018 __imp__GetLastError@0 0033 __dosmaperr"
	strings:
		$1 = { 55 8B EC 51 8B 45 0C 50 8B 4D 08 51 FF 15 ?? ?? ?? ?? 85 C0 75 0B FF 15 ?? ?? ?? ?? 89 45 FC EB 07 C7 45 FC 00 00 00 00 83 7D FC 00 74 11 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 83 C8 FF EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_376_0_0 {
	meta:
		name = "_rename"
		size = 69
		refs = "000e __imp__MoveFileA@8 0018 __imp__GetLastError@0 0033 __dosmaperr"
	strings:
		$1 = { 55 8B EC 51 8B 45 0C 50 8B 4D 08 51 FF 15 ?? ?? ?? ?? 85 C0 75 0B FF 15 ?? ?? ?? ?? 89 45 FC EB 07 C7 45 FC 00 00 00 00 83 7D FC 00 74 11 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 83 C8 FF EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_313_0_0 {
	meta:
		name = "__mbccpy"
		size = 65
		refs = "0018 __mbctype"
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 4D 0C 8A 11 88 10 8B 45 0C 33 C9 8A 08 33 D2 8A 91 ?? ?? ?? ?? 83 E2 04 85 D2 74 1C 8B 45 0C 83 C0 01 89 45 0C 8B 4D 08 83 C1 01 89 4D 08 8B 55 08 8B 45 0C 8A 08 88 0A 5D C3 }
	condition:
		$1
}

rule file_314_0_0 {
	meta:
		name = "_fread"
		size = 463
		refs = "009f _memcpy 0119 __read 0183 __filbuf"
	strings:
		$1 = { 55 8B EC 83 EC 24 8B 45 08 89 45 F8 8B 4D 0C 0F AF 4D 10 89 4D F0 8B 55 F0 89 55 F4 83 7D F4 00 75 07 33 C0 E9 A2 01 00 00 8B 45 14 8B 48 0C 81 E1 0C 01 00 00 85 C9 74 0B 8B 55 14 8B 42 18 89 45 E4 EB 07 C7 45 E4 00 10 00 00 83 7D F4 00 0F 84 73 01 00 00 8B 4D 14 8B 51 0C 81 E2 0C 01 00 00 85 D2 74 74 8B 45 14 83 78 04 00 74 6B 8B 4D 14 8B 55 F4 3B 51 04 73 08 8B 45 F4 89 45 E0 EB 09 8B 4D 14 8B 51 04 89 55 E0 8B 45 E0 89 45 E8 8B 4D E8 51 8B 55 14 8B 02 50 8B 4D F8 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 F4 2B 55 E8 89 55 F4 8B 45 14 8B 48 04 2B 4D E8 8B 55 14 89 4A 04 8B 45 14 8B 08 03 4D E8 8B 55 14 89 0A 8B 45 F8 03 45 E8 89 45 F8 E9 EA 00 00 00 8B 4D F4 3B 4D E4 0F 82 99 00 00 00 83 7D E4 00 74 12 8B 45 F4 33 D2 F7 75 E4 8B 45 F4 2B C2 89 45 DC EB 06 8B 4D F4 89 4D DC 8B 55 DC 89 55 E8 8B 45 E8 50 8B 4D F8 51 8B 55 14 8B 42 10 50 E8 ?? ?? ?? ?? 83 C4 0C 89 45 EC 83 7D EC 00 75 1F 8B 4D 14 8B 51 0C 83 CA 10 8B 45 14 89 50 0C 8B 45 F0 2B 45 F4 33 D2 F7 75 0C E9 83 00 00 00 83 7D EC FF 75 1C 8B 4D 14 8B 51 0C 83 CA 20 8B 45 14 89 50 0C 8B 45 F0 2B 45 F4 33 D2 F7 75 0C EB 61 8B 4D F4 2B 4D EC 89 4D F4 8B 55 F8 03 55 EC 89 55 F8 EB 45 8B 45 14 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 83 7D FC FF 75 0D 8B 45 F0 2B 45 F4 33 D2 F7 75 0C EB 2B 8B 4D F8 8A 55 FC 88 11 8B 45 F8 83 C0 01 89 45 F8 8B 4D F4 83 E9 01 89 4D F4 8B 55 14 8B 42 18 89 45 E4 E9 83 FE FF FF 8B 45 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_315_0_0 {
	meta:
		name = "__ismbcupper"
		size = 190
		refs = "003c ___ismbcodepage 004a ___mblcid 0051 ___mbcodepage 0063 ___crtGetStringTypeA 00ab __mbctype"
	strings:
		$1 = { 55 8B EC 83 EC 0C 81 7D 08 FF 00 00 00 0F 86 91 00 00 00 66 C7 45 F8 00 00 33 C0 66 89 45 FA 8B 4D 08 C1 E9 08 81 E1 FF 00 00 00 88 4D FC 8B 55 08 81 E2 FF 00 00 00 88 55 FD 83 3D ?? ?? ?? ?? 00 75 04 33 C0 EB 73 6A 01 A1 ?? ?? ?? ?? 50 8B 0D ?? ?? ?? ?? 51 8D 55 F8 52 6A 02 8D 45 FC 50 6A 01 E8 ?? ?? ?? ?? 83 C4 1C 85 C0 75 04 33 C0 EB 48 8B 4D FA 81 E1 FF FF 00 00 85 C9 75 19 8B 55 F8 81 E2 FF FF 00 00 83 E2 01 85 D2 74 09 C7 45 F4 01 00 00 00 EB 07 C7 45 F4 00 00 00 00 8B 45 F4 EB 16 8B 45 08 33 C9 8A 88 ?? ?? ?? ?? 83 E1 10 33 C0 83 F9 10 0F 94 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_316_0_0 {
	meta:
		name = "___crtGetStringTypeW"
		size = 621
		refs = "0006 $T17283 000b __except_handler3 0011 __except_list 0028 _?f_use@?1??__crtGetStringTypeW@@9@9 0036 ??_C@_13A@?$AA?$AA?$AA?$AA@ 003e __imp__GetStringTypeW@16 0059 ??_C@_01A@?$AA?$AA@ 0063 __imp__GetStringTypeA@20 00b6 ___lc_codepage 00d8 __imp__WideCharToMultiByte@32 00fc __alloca_probe 0117 _memset 01d2 ___lc_handle 024b _memmove"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 C4 DC 53 56 57 89 65 E8 83 3D ?? ?? ?? ?? 00 75 4F 8D 45 E4 50 6A 01 68 ?? ?? ?? ?? 6A 01 FF 15 ?? ?? ?? ?? 85 C0 74 0C C7 05 ?? ?? ?? ?? 01 00 00 00 EB 2C 8D 4D E4 51 6A 01 68 ?? ?? ?? ?? 6A 01 6A 00 FF 15 ?? ?? ?? ?? 85 C0 74 0C C7 05 ?? ?? ?? ?? 02 00 00 00 EB 07 33 C0 E9 DB 01 00 00 83 3D ?? ?? ?? ?? 01 75 1B 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 FF 15 ?? ?? ?? ?? E9 B7 01 00 00 83 3D ?? ?? ?? ?? 02 0F 85 A8 01 00 00 83 7D 18 00 75 08 A1 ?? ?? ?? ?? 89 45 18 6A 00 6A 00 6A 00 6A 00 8B 4D 10 51 8B 55 0C 52 68 20 02 00 00 8B 45 18 50 FF 15 ?? ?? ?? ?? 89 45 D8 83 7D D8 00 75 07 33 C0 E9 6D 01 00 00 C7 45 FC 00 00 00 00 8B 45 D8 83 C0 03 24 FC E8 ?? ?? ?? ?? 89 65 D0 89 65 E8 8B 4D D0 89 4D D4 8B 55 D8 52 6A 00 8B 45 D4 50 E8 ?? ?? ?? ?? 83 C4 0C C7 45 FC FF FF FF FF EB 17 B8 01 00 00 00 C3 8B 65 E8 C7 45 D4 00 00 00 00 C7 45 FC FF FF FF FF 83 7D D4 00 75 07 33 C0 E9 0E 01 00 00 6A 00 6A 00 8B 4D D8 51 8B 55 D4 52 8B 45 10 50 8B 4D 0C 51 68 20 02 00 00 8B 55 18 52 FF 15 ?? ?? ?? ?? 85 C0 75 07 33 C0 E9 E0 00 00 00 C7 45 FC 01 00 00 00 8B 45 D8 8D 44 00 02 83 C0 03 24 FC E8 ?? ?? ?? ?? 89 65 CC 89 65 E8 8B 4D CC 89 4D DC C7 45 FC FF FF FF FF EB 17 B8 01 00 00 00 C3 8B 65 E8 C7 45 DC 00 00 00 00 C7 45 FC FF FF FF FF 83 7D DC 00 75 07 33 C0 E9 8F 00 00 00 83 7D 1C 00 75 09 8B 15 ?? ?? ?? ?? 89 55 1C 8B 45 10 8B 4D DC 66 C7 04 41 FF FF 8B 55 10 8B 45 DC 66 C7 44 50 FE FF FF 8B 4D DC 51 8B 55 D8 52 8B 45 D4 50 8B 4D 08 51 8B 55 1C 52 FF 15 ?? ?? ?? ?? 89 45 E0 8B 45 10 8B 4D DC 33 D2 66 8B 54 41 FE 81 FA FF FF 00 00 74 14 8B 45 10 8B 4D DC 33 D2 66 8B 14 41 81 FA FF FF 00 00 74 04 33 C0 EB 1D 8B 45 10 D1 E0 50 8B 4D DC 51 8B 55 14 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 E0 EB 02 33 C0 8D 65 C0 8B 4D F0 64 89 0D ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_318_0_0 {
	meta:
		name = "__hypot"
		size = 31
		refs = "0016 __hypothlp"
	strings:
		$1 = { 55 8B EC 6A 18 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_318_1_0 {
	meta:
		name = "__cabs"
		size = 31
		refs = "0016 __hypothlp"
	strings:
		$1 = { 55 8B EC 6A 11 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_318_2_0 {
	meta:
		name = "__hypothlp"
		size = 842
		refs = "0012 __ctrlfp 00c0 __except2 0110 __handle_qnan2 012f __d_inf 013d __real@8@00000000000000000000 01f7 _sqrt 01ff __decomp 0232 __get_exp 0259 __set_exp"
	strings:
		$1 = { 55 8B EC 83 EC 38 56 68 FF FF 00 00 68 3F 13 00 00 E8 ?? ?? ?? ?? 83 C4 08 89 45 E8 8B 45 0E 25 FF FF 00 00 25 F0 7F 00 00 3D F0 7F 00 00 74 1B 8B 4D 16 81 E1 FF FF 00 00 81 E1 F0 7F 00 00 81 F9 F0 7F 00 00 0F 85 ED 00 00 00 8B 55 0E 81 E2 FF FF 00 00 81 E2 F8 7F 00 00 81 FA F0 7F 00 00 75 10 8B 45 0C C1 E0 0D 85 C0 75 2D 83 7D 08 00 75 27 8B 4D 16 81 E1 FF FF 00 00 81 E1 F8 7F 00 00 81 F9 F0 7F 00 00 75 43 8B 55 14 C1 E2 0D 85 D2 75 06 83 7D 10 00 74 33 8B 45 E8 50 DD 45 08 DC 45 10 83 EC 08 DD 1C 24 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 8B 55 18 52 6A 08 E8 ?? ?? ?? ?? 83 C4 24 E9 79 02 00 00 8B 45 0E 25 FF FF 00 00 25 F8 7F 00 00 3D F8 7F 00 00 74 17 8B 4D 16 81 E1 FF FF 00 00 81 E1 F8 7F 00 00 81 F9 F8 7F 00 00 75 25 8B 55 E8 52 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 8B 4D 18 51 E8 ?? ?? ?? ?? 83 C4 18 E9 29 02 00 00 68 FF FF 00 00 8B 55 E8 52 E8 ?? ?? ?? ?? 83 C4 08 DD 05 ?? ?? ?? ?? E9 0D 02 00 00 DD 45 08 DC 1D ?? ?? ?? ?? DF E0 F6 C4 01 74 08 DD 45 08 D9 E0 DD 5D 08 DD 45 10 DC 1D ?? ?? ?? ?? DF E0 F6 C4 01 74 08 DD 45 10 D9 E0 DD 5D 10 DD 45 10 DC 5D 08 DF E0 F6 C4 41 75 0E 8B 45 10 89 45 D0 8B 4D 14 89 4D D4 EB 0C 8B 55 08 89 55 D0 8B 45 0C 89 45 D4 8B 4D D0 89 4D DC 8B 55 D4 89 55 E0 DD 45 DC DC 1D ?? ?? ?? ?? DF E0 F6 C4 40 74 1C 68 FF FF 00 00 8B 45 E8 50 E8 ?? ?? ?? ?? 83 C4 08 DD 05 ?? ?? ?? ?? E9 7E 01 00 00 DD 45 08 DC 75 DC DD 5D 08 DD 45 10 DC 75 DC DD 5D 10 DD 45 08 DC 4D 08 DD 45 10 DC 4D 10 DE C1 DD 5D F0 8D 4D EC 51 8B 55 F4 52 8B 45 F0 50 E8 ?? ?? ?? ?? DD 1C 24 E8 ?? ?? ?? ?? DD 5D C8 83 C4 0C 8D 4D E4 51 8B 55 E0 52 8B 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C DC 4D C8 DD 5D F8 8B 75 EC 03 75 E4 8B 4D FC 51 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 08 03 F0 89 75 D8 81 7D D8 00 04 00 00 7E 4B 8B 45 D8 2D 00 06 00 00 50 8B 4D FC 51 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 0C DD 5D F8 8B 45 E8 50 8B 4D FC 51 8B 55 F8 52 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 8B 4D 18 51 6A 11 E8 ?? ?? ?? ?? 83 C4 24 E9 B3 00 00 00 81 7D D8 03 FC FF FF 7D 49 8B 55 D8 81 C2 00 06 00 00 52 8B 45 FC 50 8B 4D F8 51 E8 ?? ?? ?? ?? 83 C4 0C DD 5D F8 8B 55 E8 52 8B 45 FC 50 8B 4D F8 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 8B 45 18 50 6A 12 E8 ?? ?? ?? ?? 83 C4 24 EB 61 8B 4D D8 51 8B 55 FC 52 8B 45 F8 50 E8 ?? ?? ?? ?? 83 C4 0C DD 5D F8 8B 4D E8 83 E1 20 85 C9 74 16 68 FF FF 00 00 8B 55 E8 52 E8 ?? ?? ?? ?? 83 C4 08 DD 45 F8 EB 2A 8B 45 E8 50 8B 4D FC 51 8B 55 F8 52 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 8B 4D 18 51 6A 10 E8 ?? ?? ?? ?? 83 C4 24 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_319_0_0 {
	meta:
		name = "__ismbbkalnum"
		size = 21
		refs = "000c _x_ismbbtype"
	strings:
		$1 = { 55 8B EC 6A 01 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_425_0_0 {
	meta:
		name = "__tell"
		size = 21
		refs = "000c __lseek"
	strings:
		$1 = { 55 8B EC 6A 01 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_319_1_0 {
	meta:
		name = "__ismbbkprint"
		size = 21
		refs = "000c _x_ismbbtype"
	strings:
		$1 = { 55 8B EC 6A 03 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_319_2_0 {
	meta:
		name = "__ismbbkpunct"
		size = 21
		refs = "000c _x_ismbbtype"
	strings:
		$1 = { 55 8B EC 6A 02 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_319_3_0 {
	meta:
		name = "__ismbbalnum"
		size = 24
		refs = "000f _x_ismbbtype"
	strings:
		$1 = { 55 8B EC 6A 01 68 07 01 00 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_319_4_0 {
	meta:
		name = "__ismbbalpha"
		size = 24
		refs = "000f _x_ismbbtype"
	strings:
		$1 = { 55 8B EC 6A 01 68 03 01 00 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_319_5_0 {
	meta:
		name = "__ismbbgraph"
		size = 24
		refs = "000f _x_ismbbtype"
	strings:
		$1 = { 55 8B EC 6A 03 68 17 01 00 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_319_6_0 {
	meta:
		name = "__ismbbprint"
		size = 24
		refs = "000f _x_ismbbtype"
	strings:
		$1 = { 55 8B EC 6A 03 68 57 01 00 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_319_7_0 {
	meta:
		name = "__ismbbpunct"
		size = 21
		refs = "000c _x_ismbbtype"
	strings:
		$1 = { 55 8B EC 6A 02 6A 10 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_319_8_0 {
	meta:
		name = "__ismbblead"
		size = 21
		refs = "000c _x_ismbbtype"
	strings:
		$1 = { 55 8B EC 6A 04 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_319_9_0 {
	meta:
		name = "__ismbbtrail"
		size = 21
		refs = "000c _x_ismbbtype"
	strings:
		$1 = { 55 8B EC 6A 08 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_319_10_0 {
	meta:
		name = "__ismbbkana"
		size = 59
		refs = "0006 ___mbcodepage 0019 _x_ismbbtype"
	strings:
		$1 = { 55 8B EC 51 81 3D ?? ?? ?? ?? A4 03 00 00 75 1D 6A 03 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_319_11_0 {
	meta:
		name = "_x_ismbbtype"
		size = 98
		refs = "0018 __mbctype 0032 __ctype"
	strings:
		$1 = { 55 8B EC 83 EC 08 8B 45 08 25 FF 00 00 00 89 45 08 8B 4D 08 33 D2 8A 91 ?? ?? ?? ?? 23 55 10 85 D2 75 31 83 7D 0C 00 74 15 8B 45 08 33 C9 66 8B 0C 45 ?? ?? ?? ?? 23 4D 0C 89 4D FC EB 07 C7 45 FC 00 00 00 00 83 7D FC 00 75 09 C7 45 F8 00 00 00 00 EB 07 C7 45 F8 01 00 00 00 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_321_1_0 {
	meta:
		name = "_acos"
		size = 183
		refs = "0005 __fload_withFB 0019 __load_CW 0036 ___fastflag 003d __fast_exit 0048 _NAME_ 004d __math_exit 0077 __convertTOStoQNaN 008f __indefinite 00b1 __startOneArgErrorHandling"
	strings:
		$1 = { 8D 54 24 04 E8 ?? ?? ?? ?? 52 9B D9 3C 24 74 6D 66 81 3C 24 7F 02 74 05 E8 ?? ?? ?? ?? 3D 00 00 F0 3F 73 2D D9 E8 D8 C1 D9 E8 D8 E2 DE C9 D9 FA D9 C9 D9 F3 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 0D 00 00 00 8D 0D ?? ?? ?? ?? E9 ?? ?? ?? ?? 77 38 8B 44 24 0C 8B C8 25 FF FF 0F 00 0B 44 24 08 75 27 81 E1 00 00 00 80 DD D8 74 04 D9 EB EB C2 D9 EE EB BE E8 ?? ?? ?? ?? EB 1B A9 FF FF 0F 00 75 F2 83 7C 24 08 00 75 EB DD D8 DB 2D ?? ?? ?? ?? B8 01 00 00 00 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 0D 00 00 00 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule file_322_0_0 {
	meta:
		name = "__getdllprocaddr"
		size = 62
		refs = "001c __imp__GetProcAddress@8"
	strings:
		$1 = { 55 8B EC 83 7D 0C 00 75 1B 81 7D 10 FF FF 00 00 7F 10 8B 45 10 50 8B 4D 08 51 FF 15 ?? ?? ?? ?? EB 1A EB 16 83 7D 10 FF 75 10 8B 55 0C 52 8B 45 08 50 FF 15 ?? ?? ?? ?? EB 02 33 C0 5D C3 }
	condition:
		$1
}

rule file_323_0_0 {
	meta:
		name = "__wsearchenv"
		size = 358
		refs = "0010 __waccess 0029 __wfullpath 0046 __wgetenv 0074 __wgetpath 00a4 _wcslen 0124 _wcscpy"
	strings:
		$1 = { 55 8B EC 81 EC 20 02 00 00 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 26 68 04 01 00 00 8B 4D 08 51 8B 55 10 52 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 08 8B 45 10 66 C7 00 00 00 E9 21 01 00 00 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 F4 83 7D F4 00 75 0D 8B 55 10 66 C7 02 00 00 E9 FF 00 00 00 68 04 01 00 00 8D 85 E4 FD FF FF 50 8B 4D F4 51 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F4 83 7D F4 00 0F 84 D2 00 00 00 8B 95 E4 FD FF FF 81 E2 FF FF 00 00 85 D2 0F 84 BE 00 00 00 8D 85 E4 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 E0 FD FF FF 8B 8D E0 FD FF FF 8D 94 4D E4 FD FF FF 89 55 FC 8B 45 FC 33 C9 66 8B 48 FE 89 4D F8 83 7D F8 2F 74 2C 83 7D F8 5C 74 26 83 7D F8 3A 74 20 8B 55 FC 66 C7 02 5C 00 8B 45 FC 83 C0 02 89 45 FC 8B 8D E0 FD FF FF 83 C1 01 89 8D E0 FD FF FF 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 8B 8D E0 FD FF FF 03 C8 81 F9 04 01 00 00 77 3A 8B 55 08 52 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 6A 00 8D 8D E4 FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 15 8D 95 E4 FD FF FF 52 8B 45 10 50 E8 ?? ?? ?? ?? 83 C4 08 EB 0D E9 09 FF FF FF 8B 4D 10 66 C7 01 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_324_0_0 {
	meta:
		name = "__wtmpnam"
		size = 127
		refs = "0007 _namebuf0 0012 _winit_namebuf 0021 _wgenfname 0036 __waccess 006f _wcscpy"
	strings:
		$1 = { 55 8B EC 33 C0 66 A1 ?? ?? ?? ?? 85 C0 75 0C 6A 00 E8 ?? ?? ?? ?? 83 C4 04 EB 13 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 02 EB 4D 6A 00 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 15 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 02 EB 27 EB D8 83 7D 08 00 75 09 C7 45 08 ?? ?? ?? ?? EB 11 68 ?? ?? ?? ?? 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 8B 45 08 EB 02 33 C0 5D C3 }
	condition:
		$1
}

rule file_324_1_0 {
	meta:
		name = "_winit_namebuf"
		size = 182
		refs = "000f _namebuf0 0018 _namebuf1 001d ??_C@_13HMCP@?$AA?2?$AA?$AA@ 0026 _wcscpy 0094 __getpid 009a __ultow 00a2 ??_C@_13DOBH@?$AA?4?$AA?$AA@ 00ab _wcscat"
	strings:
		$1 = { 55 8B EC 83 EC 08 83 7D 08 00 75 09 C7 45 FC ?? ?? ?? ?? EB 07 C7 45 FC ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4D FC 83 C1 02 89 4D F8 8B 55 F8 33 C0 66 8B 42 FE 83 F8 5C 74 1F 8B 4D F8 33 D2 66 8B 51 FE 83 FA 2F 74 11 8B 45 F8 66 C7 00 5C 00 8B 4D F8 83 C1 02 89 4D F8 83 7D 08 00 74 13 8B 55 F8 66 C7 02 74 00 8B 45 F8 83 C0 02 89 45 F8 EB 11 8B 4D F8 66 C7 01 73 00 8B 55 F8 83 C2 02 89 55 F8 6A 20 8B 45 F8 50 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 0C 68 ?? ?? ?? ?? 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_324_2_0 {
	meta:
		name = "_wgenfname"
		size = 105
		refs = "000d _wcsrchr 0029 _wcstoul 004f __ultow 005c _wcscpy"
	strings:
		$1 = { 55 8B EC 83 EC 10 6A 2E 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 F4 8B 4D F4 83 C1 02 89 4D F4 6A 20 6A 00 8B 55 F4 52 E8 ?? ?? ?? ?? 83 C4 0C 83 C0 01 89 45 F0 81 7D F0 FF 7F 00 00 72 05 83 C8 FF EB 21 6A 20 8D 45 F8 50 8B 4D F0 51 E8 ?? ?? ?? ?? 83 C4 0C 50 8B 55 F4 52 E8 ?? ?? ?? ?? 83 C4 08 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_325_0_0 {
	meta:
		name = "__mktemp"
		size = 396
		refs = "0024 ??_C@_0BB@BKHM@template?5?$CB?$DN?5NULL?$AA@ 002d ??_C@_08DHKB@mktemp?4c?$AA@ 0034 __CrtDbgReport 0052 ??_C@_0BG@EHFM@?$CKtemplate?5?$CB?$DN?5_T?$CI?8?20?8?$CJ?$AA@ 0076 __getpid 00ac __ismbstrail 011e _errno 0136 __access"
	strings:
		$1 = { 55 8B EC 83 EC 14 53 56 57 8B 45 08 89 45 F8 C7 45 FC 61 00 00 00 C7 45 EC 00 00 00 00 83 7D 08 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3A 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D6 8B 55 08 0F BE 02 85 C0 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3B 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D2 E8 ?? ?? ?? ?? 89 45 F0 8B 55 F8 0F BE 02 85 C0 74 0B 8B 4D F8 83 C1 01 89 4D F8 EB EB 8B 55 F8 83 EA 01 89 55 F8 8B 45 F8 3B 45 08 72 53 8B 4D F8 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 3F 8B 45 F8 0F BE 08 83 F9 58 75 34 83 7D EC 05 7D 2E 8B 55 EC 83 C2 01 89 55 EC 8B 45 F0 33 D2 B9 0A 00 00 00 F7 F1 83 C2 30 8B 45 F8 88 10 8B 45 F0 33 D2 B9 0A 00 00 00 F7 F1 89 45 F0 EB 9C 8B 55 F8 0F BE 02 83 F8 58 75 06 83 7D EC 05 7D 04 33 C0 EB 7A 8B 4D F8 8A 55 FC 88 11 8B 45 FC 83 C0 01 89 45 FC 8B 0D ?? ?? ?? ?? 89 4D F4 C7 05 ?? ?? ?? ?? 00 00 00 00 6A 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 09 83 3D ?? ?? ?? ?? 0D 75 2F C7 05 ?? ?? ?? ?? 00 00 00 00 83 7D FC 7B 75 0C 8B 45 F4 A3 ?? ?? ?? ?? 33 C0 EB 1F 8B 4D F8 8A 55 FC 88 11 8B 45 FC 83 C0 01 89 45 FC EB B6 8B 4D F4 89 0D ?? ?? ?? ?? 8B 45 08 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_326_0_0 {
	meta:
		name = "_fwrite"
		size = 537
		refs = "009f _memcpy 00f9 __flush 0148 __write 01c1 __flsbuf"
	strings:
		$1 = { 55 8B EC 83 EC 28 8B 45 08 89 45 F8 8B 4D 0C 0F AF 4D 10 89 4D F0 8B 55 F0 89 55 F4 83 7D F4 00 75 07 33 C0 E9 EC 01 00 00 8B 45 14 8B 48 0C 81 E1 0C 01 00 00 85 C9 74 0B 8B 55 14 8B 42 18 89 45 E4 EB 07 C7 45 E4 00 10 00 00 83 7D F4 00 0F 84 BD 01 00 00 8B 4D 14 8B 51 0C 81 E2 08 01 00 00 85 D2 74 74 8B 45 14 83 78 04 00 74 6B 8B 4D 14 8B 55 F4 3B 51 04 73 08 8B 45 F4 89 45 E0 EB 09 8B 4D 14 8B 51 04 89 55 E0 8B 45 E0 89 45 E8 8B 4D E8 51 8B 55 F8 52 8B 45 14 8B 08 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 F4 2B 55 E8 89 55 F4 8B 45 14 8B 48 04 2B 4D E8 8B 55 14 89 4A 04 8B 45 14 8B 08 03 4D E8 8B 55 14 89 0A 8B 45 F8 03 45 E8 89 45 F8 E9 34 01 00 00 8B 4D F4 3B 4D E4 0F 82 CA 00 00 00 8B 55 14 8B 42 0C 25 08 01 00 00 85 C0 74 20 8B 4D 14 51 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 10 8B 45 F0 2B 45 F4 33 D2 F7 75 0C E9 01 01 00 00 83 7D E4 00 74 12 8B 45 F4 33 D2 F7 75 E4 8B 45 F4 2B C2 89 45 DC EB 06 8B 4D F4 89 4D DC 8B 55 DC 89 55 E8 8B 45 E8 50 8B 4D F8 51 8B 55 14 8B 42 10 50 E8 ?? ?? ?? ?? 83 C4 0C 89 45 EC 83 7D EC FF 75 1F 8B 4D 14 8B 51 0C 83 CA 20 8B 45 14 89 50 0C 8B 45 F0 2B 45 F4 33 D2 F7 75 0C E9 9E 00 00 00 8B 4D F4 2B 4D EC 89 4D F4 8B 55 F8 03 55 EC 89 55 F8 8B 45 EC 3B 45 E8 73 1C 8B 4D 14 8B 51 0C 83 CA 20 8B 45 14 89 50 0C 8B 45 F0 2B 45 F4 33 D2 F7 75 0C EB 68 EB 5E 8B 4D F8 0F BE 11 89 55 FC 8B 45 14 50 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 83 F8 FF 75 0D 8B 45 F0 2B 45 F4 33 D2 F7 75 0C EB 3B 8B 55 F8 83 C2 01 89 55 F8 8B 45 F4 83 E8 01 89 45 F4 8B 4D 14 83 79 18 00 7E 0B 8B 55 14 8B 42 18 89 45 D8 EB 07 C7 45 D8 01 00 00 00 8B 4D D8 89 4D E4 E9 39 FE FF FF 8B 45 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_327_0_0 {
	meta:
		name = "__flswbuf"
		size = 649
		refs = "0010 ??_C@_0M@KJPK@str?5?$CB?$DN?5NULL?$AA@ 0019 ??_C@_09LGEI@_flsbuf?4c?$AA@ 0020 __CrtDbgReport 0118 __iob 012c __isatty 013c __getbuf 0167 ??_C@_0DP@IHIN@?$CI?$CCinconsistent?5IOB?5fields?$CC?0?5stre@ 01ce __write 01ef ___pioinfo 01fe ___badioinfo 0219 __lseek"
	strings:
		$1 = { 55 8B EC 83 EC 18 53 56 57 83 7D 0C 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 69 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D6 8B 4D 0C 89 4D F8 8B 55 F8 8B 42 10 89 45 F0 8B 4D F8 8B 51 0C 81 E2 82 00 00 00 85 D2 74 0D 8B 45 F8 8B 48 0C 83 E1 40 85 C9 74 18 8B 55 F8 8B 42 0C 0C 20 8B 4D F8 89 41 0C B8 FF FF 00 00 E9 0B 02 00 00 8B 55 F8 8B 42 0C 83 E0 01 85 C0 74 4C 8B 4D F8 C7 41 04 00 00 00 00 8B 55 F8 8B 42 0C 83 E0 10 85 C0 74 1C 8B 4D F8 8B 55 F8 8B 42 08 89 01 8B 4D F8 8B 51 0C 83 E2 FE 8B 45 F8 89 50 0C EB 19 8B 4D F8 8B 51 0C 83 CA 20 8B 45 F8 89 50 0C B8 FF FF 00 00 E9 B2 01 00 00 8B 4D F8 8B 51 0C 83 CA 02 8B 45 F8 89 50 0C 8B 4D F8 8B 51 0C 83 E2 EF 8B 45 F8 89 50 0C 8B 4D F8 C7 41 04 00 00 00 00 C7 45 FC 00 00 00 00 8B 55 FC 89 55 F4 8B 45 F8 8B 48 0C 81 E1 0C 01 00 00 85 C9 75 2E 81 7D F8 ?? ?? ?? ?? 74 09 81 7D F8 ?? ?? ?? ?? 75 10 8B 55 F0 52 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 0C 8B 45 F8 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D F8 8B 51 0C 81 E2 08 01 00 00 85 D2 0F 84 DC 00 00 00 8B 45 F8 8B 4D F8 8B 10 2B 51 08 85 D2 7D 21 68 ?? ?? ?? ?? 6A 00 68 A0 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 CA 8B 4D F8 8B 55 F8 8B 01 2B 42 08 89 45 FC 8B 4D F8 8B 51 08 83 C2 02 8B 45 F8 89 10 8B 4D F8 8B 51 18 83 EA 02 8B 45 F8 89 50 04 83 7D FC 00 7E 1C 8B 4D FC 51 8B 55 F8 8B 42 08 50 8B 4D F0 51 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F4 EB 46 83 7D F0 FF 74 1B 8B 55 F0 C1 FA 05 8B 45 F0 83 E0 1F 8B 0C 95 ?? ?? ?? ?? 8D 14 C1 89 55 E8 EB 07 C7 45 E8 ?? ?? ?? ?? 8B 45 E8 0F BE 48 04 83 E1 20 85 C9 74 10 6A 02 6A 00 8B 55 F0 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 08 25 FF FF 00 00 8B 4D F8 8B 51 08 66 89 02 EB 2A C7 45 FC 02 00 00 00 8B 45 08 25 FF FF 00 00 66 89 45 EC 8B 4D FC 51 8D 55 EC 52 8B 45 F0 50 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F4 8B 4D F4 3B 4D FC 74 15 8B 55 F8 8B 42 0C 0C 20 8B 4D F8 89 41 0C B8 FF FF 00 00 EB 08 8B 45 08 25 FF FF 00 00 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_328_0_0 {
	meta:
		name = "__execlp"
		size = 203
		refs = "000d ??_C@_0BB@COCE@filename?5?$CB?$DN?5NULL?$AA@ 0016 ??_C@_08MGBO@execlp?4c?$AA@ 001d __CrtDbgReport 003b ??_C@_0BG@GALO@?$CKfilename?5?$CB?$DN?5_T?$CI?8?20?8?$CJ?$AA@ 0065 ??_C@_0BA@BICO@arglist?5?$CB?$DN?5NULL?$AA@ 0093 ??_C@_0BF@GGKN@?$CKarglist?5?$CB?$DN?5_T?$CI?8?20?8?$CJ?$AA@ 00bf __execvp"
	strings:
		$1 = { 55 8B EC 53 56 57 83 7D 08 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 31 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D6 8B 4D 08 0F BE 11 85 D2 75 1E 68 ?? ?? ?? ?? 6A 00 6A 32 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D2 83 7D 0C 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 33 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D6 8B 55 0C 0F BE 02 85 C0 75 1E 68 ?? ?? ?? ?? 6A 00 6A 34 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D2 8D 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_329_0_0 {
	meta:
		name = "__putenv"
		size = 264
		refs = "0008 ___env_initialized 001a ??_C@_08GFKD@putenv?4c?$AA@ 0025 _strlen 0031 __malloc_dbg 0052 _strcpy 0060 ___crtsetenv 0075 __wenviron 0090 __imp__MultiByteToWideChar@24 00f2 ___crtwsetenv"
	strings:
		$1 = { 55 8B EC 83 EC 0C 83 3D ?? ?? ?? ?? 00 75 08 83 C8 FF E9 ED 00 00 00 6A 7F 68 ?? ?? ?? ?? 6A 02 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 83 C0 01 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 F8 83 7D F8 00 75 08 83 C8 FF E9 BB 00 00 00 8B 4D 08 51 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 08 6A 01 8B 45 F8 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 08 83 C8 FF E9 91 00 00 00 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 6A 00 6A 00 6A FF 8B 4D 08 51 6A 00 6A 01 FF 15 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 75 05 83 C8 FF EB 62 68 AF 00 00 00 68 ?? ?? ?? ?? 6A 02 8B 55 FC D1 E2 52 E8 ?? ?? ?? ?? 83 C4 10 89 45 F4 83 7D F4 00 75 05 83 C8 FF EB 3A 8B 45 FC 50 8B 4D F4 51 6A FF 8B 55 08 52 6A 00 6A 01 FF 15 ?? ?? ?? ?? 85 C0 75 05 83 C8 FF EB 19 6A 00 8B 45 F4 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 05 83 C8 FF EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_330_0_0 {
	meta:
		name = "__putws"
		size = 200
		refs = "0017 ??_C@_0P@OOIN@string?5?$CB?$DN?5NULL?$AA@ 0020 ??_C@_06JIPE@puts?4c?$AA@ 0027 __CrtDbgReport 003b __iob 0040 __stbuf 0074 _fputwc 00b7 __ftbuf"
	strings:
		$1 = { 55 8B EC 83 EC 0C 53 56 57 C7 45 F8 FF FF 00 00 83 7D 08 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 31 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D6 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 8B 4D 08 33 D2 66 8B 11 85 D2 74 35 68 ?? ?? ?? ?? 8B 45 08 66 8B 08 66 89 4D F6 66 8B 55 F6 52 8B 45 08 83 C0 02 89 45 08 E8 ?? ?? ?? ?? 83 C4 08 25 FF FF 00 00 3D FF FF 00 00 75 02 EB 24 EB BF 68 ?? ?? ?? ?? 6A 0A E8 ?? ?? ?? ?? 83 C4 08 25 FF FF 00 00 3D FF FF 00 00 74 07 C7 45 F8 00 00 00 00 68 ?? ?? ?? ?? 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 8B 45 F8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_331_0_0 {
	meta:
		name = "_wmainCRTStartup"
		size = 303
		refs = "0006 $T17558 000b __except_handler3 0011 __except_list 0028 __imp__GetVersion@0 002d __osver 003f __winminor 0051 __winmajor 0066 __winver 007f __heap_init 008d _fast_error_exit 009c __ioinit 00a1 ___crtGetCommandLineW 00a6 __wcmdln 00ab ___crtGetEnvironmentStringsW 00b0 __wenvptr 00b5 __wsetargv 00ba __wsetenvp 00bf __cinit 00c5 __wenviron 00cb ___winitenv 00d7 ___wargv 00de ___argc 00e4 _wmain 00f3 _exit 010a __XcptFilter 011a __exit"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 C4 F0 53 56 57 89 65 E8 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? C1 E8 08 25 FF 00 00 00 A3 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 81 E1 FF 00 00 00 89 0D ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? C1 E2 08 03 15 ?? ?? ?? ?? 89 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? C1 E8 10 25 FF FF 00 00 A3 ?? ?? ?? ?? 6A 00 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 0A 6A 1C E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 52 A1 ?? ?? ?? ?? 50 8B 0D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 0C 89 45 E4 8B 55 E4 52 E8 ?? ?? ?? ?? 8B 45 EC 8B 08 8B 11 89 55 E0 8B 45 EC 50 8B 4D E0 51 E8 ?? ?? ?? ?? 83 C4 08 C3 8B 65 E8 8B 55 E0 52 E8 ?? ?? ?? ?? 8B 4D F0 64 89 0D ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_334_0_0 {
	meta:
		name = "_vsprintf"
		size = 243
		refs = "0016 ??_C@_0P@OOIN@string?5?$CB?$DN?5NULL?$AA@ 001f ??_C@_0L@HE@vsprintf?4c?$AA@ 0026 __CrtDbgReport 0040 ??_C@_0P@LNLA@format?5?$CB?$DN?5NULL?$AA@ 0095 __output 00df __flsbuf"
	strings:
		$1 = { 55 8B EC 83 EC 2C 53 56 57 8D 45 E0 89 45 DC 83 7D 08 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 5A 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D6 83 7D 0C 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 5B 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 D2 85 D2 75 D6 8B 45 DC C7 40 0C 42 00 00 00 8B 4D DC 8B 55 08 89 51 08 8B 45 DC 8B 4D 08 89 08 8B 55 DC C7 42 04 FF FF FF 7F 8B 45 10 50 8B 4D 0C 51 8B 55 DC 52 E8 ?? ?? ?? ?? 83 C4 0C 89 45 D8 8B 45 DC 8B 48 04 83 E9 01 8B 55 DC 89 4A 04 8B 45 DC 83 78 04 00 7C 21 8B 4D DC 8B 11 C6 02 00 33 C0 25 FF 00 00 00 89 45 D4 8B 4D DC 8B 11 83 C2 01 8B 45 DC 89 10 EB 11 8B 4D DC 51 6A 00 E8 ?? ?? ?? ?? 83 C4 08 89 45 D4 8B 45 D8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_335_0_0 {
	meta:
		name = "_ungetc"
		size = 318
		refs = "000e ??_C@_0M@KJPK@str?5?$CB?$DN?5NULL?$AA@ 0017 ??_C@_08JKP@ungetc?4c?$AA@ 001e __CrtDbgReport 007d __getbuf"
	strings:
		$1 = { 55 8B EC 51 53 56 57 83 7D 0C 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 60 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D6 8B 4D 0C 89 4D FC 83 7D 08 FF 74 2A 8B 55 FC 8B 42 0C 83 E0 01 85 C0 75 25 8B 4D FC 8B 51 0C 81 E2 80 00 00 00 85 D2 74 0D 8B 45 FC 8B 48 0C 83 E1 02 85 C9 74 08 83 C8 FF E9 C8 00 00 00 8B 55 FC 83 7A 08 00 75 0C 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D FC 8B 55 FC 8B 01 3B 42 08 75 1E 8B 4D FC 83 79 04 00 74 08 83 C8 FF E9 95 00 00 00 8B 55 FC 8B 02 83 C0 01 8B 4D FC 89 01 8B 55 FC 8B 42 0C 83 E0 40 85 C0 74 31 8B 4D FC 8B 11 83 EA 01 8B 45 FC 89 10 8B 4D FC 8B 11 0F BE 02 0F BE 4D 08 3B C1 74 12 8B 55 FC 8B 02 83 C0 01 8B 4D FC 89 01 83 C8 FF EB 4C EB 17 8B 55 FC 8B 02 83 E8 01 8B 4D FC 89 01 8B 55 FC 8B 02 8A 4D 08 88 08 8B 55 FC 8B 42 04 83 C0 01 8B 4D FC 89 41 04 8B 55 FC 8B 42 0C 24 EF 8B 4D FC 89 41 0C 8B 55 FC 8B 42 0C 0C 01 8B 4D FC 89 41 0C 8B 45 08 25 FF 00 00 00 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_336_0_0 {
	meta:
		name = "__memicmp"
		size = 44
		refs = "0019 ___lc_handle"
	strings:
		$1 = { 55 8B EC 57 56 53 8B 4D 10 0B C9 0F 84 85 00 00 00 8B 75 08 8B 7D 0C 8D 05 ?? ?? ?? ?? 83 78 08 00 75 3B B7 41 B3 5A B6 20 8D 49 00 }
	condition:
		$1
}

rule file_336_1_0 {
	meta:
		name = "lupe"
		size = 20
	strings:
		$1 = { 8A 26 46 8A 07 47 38 C4 74 18 38 FC 72 06 38 DC 77 02 02 E6 }
	condition:
		$1
}

rule file_336_7_0 {
	meta:
		name = "lupe2"
		size = 36
		refs = "000e _tolower"
	strings:
		$1 = { 8A 06 46 8A 1F 47 38 D8 74 1A 51 50 53 E8 ?? ?? ?? ?? 8B D8 83 C4 04 E8 ?? ?? ?? ?? 83 C4 04 59 38 D8 75 05 }
	condition:
		$1
}

rule file_337_0_0 {
	meta:
		name = "__snwprintf"
		size = 326
		refs = "001c ??_C@_0P@OOIN@string?5?$CB?$DN?5NULL?$AA@ 0025 ??_C@_0L@LJJP@swprintf?4c?$AA@ 002c __CrtDbgReport 0046 ??_C@_0P@LNLA@format?5?$CB?$DN?5NULL?$AA@ 009c __woutput 00e7 __flsbuf"
	strings:
		$1 = { 55 8B EC 83 EC 34 53 56 57 8D 45 E0 89 45 DC 8D 4D 14 89 4D D4 83 7D 08 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 5F 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 D2 85 D2 75 D6 83 7D 10 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 60 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D6 8B 4D DC C7 41 0C 42 00 00 00 8B 55 DC 8B 45 08 89 42 08 8B 4D DC 8B 55 08 89 11 8B 45 0C D1 E0 8B 4D DC 89 41 04 8B 55 D4 52 8B 45 10 50 8B 4D DC 51 E8 ?? ?? ?? ?? 83 C4 0C 89 45 D8 8B 55 DC 8B 42 04 83 E8 01 8B 4D DC 89 41 04 8B 55 DC 83 7A 04 00 7C 22 8B 45 DC 8B 08 C6 01 00 33 D2 81 E2 FF 00 00 00 89 55 D0 8B 45 DC 8B 08 83 C1 01 8B 55 DC 89 0A EB 11 8B 45 DC 50 6A 00 E8 ?? ?? ?? ?? 83 C4 08 89 45 D0 8B 4D DC 8B 51 04 83 EA 01 8B 45 DC 89 50 04 8B 4D DC 83 79 04 00 7C 22 8B 55 DC 8B 02 C6 00 00 33 C9 81 E1 FF 00 00 00 89 4D CC 8B 55 DC 8B 02 83 C0 01 8B 4D DC 89 01 EB 11 8B 55 DC 52 6A 00 E8 ?? ?? ?? ?? 83 C4 08 89 45 CC 8B 45 D8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_339_0_0 {
	meta:
		name = "__setdefaultprecision"
		size = 23
		refs = "000e __controlfp"
	strings:
		$1 = { 55 8B EC 68 00 00 03 00 68 00 00 01 00 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_340_0_0 {
	meta:
		name = "___lconv_init"
		size = 61
		refs = "0005 ___lconv_c"
	strings:
		$1 = { 55 8B EC C6 05 ?? ?? ?? ?? FF C6 05 ?? ?? ?? ?? FF C6 05 ?? ?? ?? ?? FF C6 05 ?? ?? ?? ?? FF C6 05 ?? ?? ?? ?? FF C6 05 ?? ?? ?? ?? FF C6 05 ?? ?? ?? ?? FF C6 05 ?? ?? ?? ?? FF 5D C3 }
	condition:
		$1
}

rule file_341_0_0 {
	meta:
		name = "__wpopen"
		size = 1281
		refs = "007c __pipe 00d5 __imp__GetCurrentProcess@0 00eb ___pioinfo 0113 __imp__DuplicateHandle@28 0193 __imp__CloseHandle@4 019c __free_osfhnd 01ac __set_osfhnd 01f2 __close 0211 __wfdopen 0229 _idtab 02c4 ??_C@_1BA@NIMI@?$AAC?$AAO?$AAM?$AAS?$AAP?$AAE?$AAC?$AA?$AA@ 02c9 __wgetenv 02e0 ??_C@_15FEDO@?$AA?1?$AAc?$AA?$AA@ 02ef __wspawnl 0301 _errno 0313 __osver 0324 ??_C@_1BI@PFHA@?$AAc?$AAo?$AAm?$AAm?$AAa?$AAn?$AAd?$AA?4?$AAc?$AAo?$AAm?$AA?$AA@ 032d ??_C@_1BA@OMOC@?$AAc?$AAm?$AAd?$AA?4?$AAe?$AAx?$AAe?$AA?$AA@ 034d __wspawnlp 043b _fclose"
	strings:
		$1 = { 55 8B EC 83 EC 50 56 C7 45 E0 00 00 00 00 83 7D 08 00 74 20 83 7D 0C 00 74 1A 8B 45 0C 33 C9 66 8B 08 83 F9 77 74 12 8B 55 0C 33 C0 66 8B 02 83 F8 72 74 05 E9 C1 04 00 00 8B 4D 0C 33 D2 66 8B 51 02 83 FA 74 75 09 C7 45 E0 00 40 00 00 EB 15 8B 45 0C 33 C9 66 8B 48 02 83 F9 62 75 07 C7 45 E0 00 80 00 00 8B 55 E0 80 CA 80 89 55 E0 8B 45 E0 50 68 00 04 00 00 8D 4D E4 51 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 FF 75 05 E9 6D 04 00 00 8B 55 0C 33 C0 66 8B 02 83 F8 77 75 17 C7 45 FC 00 00 00 00 C7 45 C8 00 00 00 00 C7 45 C0 01 00 00 00 EB 15 C7 45 FC 01 00 00 00 C7 45 C8 01 00 00 00 C7 45 C0 00 00 00 00 C7 45 B8 01 00 00 00 8B 4D B8 89 4D B4 FF 15 ?? ?? ?? ?? 89 45 D8 8B 55 FC C1 FA 05 8B 45 FC 83 E0 1F 8B 0C 95 ?? ?? ?? ?? 8B 14 C1 89 55 EC 83 7D EC FF 74 20 6A 02 6A 00 6A 00 8D 45 C4 50 8B 4D D8 51 8B 55 EC 52 8B 45 D8 50 FF 15 ?? ?? ?? ?? 85 C0 75 05 E9 A6 03 00 00 8B 4D FC C1 F9 05 8B 55 FC 83 E2 1F 8B 04 8D ?? ?? ?? ?? 8A 4C D0 04 88 4D D0 6A 02 6A 01 6A 00 8D 55 D4 52 8B 45 D8 50 8B 4D C8 8B 54 8D E4 C1 FA 05 8B 45 C8 8B 4C 85 E4 83 E1 1F 8B 14 95 ?? ?? ?? ?? 8B 04 CA 50 8B 4D D8 51 FF 15 ?? ?? ?? ?? 85 C0 75 05 E9 42 03 00 00 8B 55 FC C1 FA 05 8B 45 FC 83 E0 1F 8B 0C 95 ?? ?? ?? ?? 8B 14 C1 52 FF 15 ?? ?? ?? ?? 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D D4 51 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 08 8B 45 C8 8B 4C 85 E4 C1 F9 05 8B 55 C8 8B 44 95 E4 83 E0 1F 8B 0C 8D ?? ?? ?? ?? 8B 55 FC C1 FA 05 8B 75 FC 83 E6 1F 8B 14 95 ?? ?? ?? ?? 8A 44 C1 04 88 44 F2 04 8B 4D C8 8B 54 8D E4 52 E8 ?? ?? ?? ?? 83 C4 04 8B 45 C8 C7 44 85 B4 00 00 00 00 8B 4D 0C 51 8B 55 C0 8B 44 95 E4 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 F4 83 7D F4 00 75 05 E9 27 02 00 00 6A 00 E8 ?? ?? ?? ?? 83 C4 04 89 45 F8 83 7D F8 00 75 05 E9 F8 01 00 00 8B 4D C0 8B 54 8D E4 C1 FA 05 8B 45 C0 8B 4C 85 E4 83 E1 1F 8B 14 95 ?? ?? ?? ?? 8B 04 CA 89 45 BC 8B 4D C0 8B 54 8D E4 C1 FA 05 8B 45 C0 8B 4C 85 E4 83 E1 1F 8B 14 95 ?? ?? ?? ?? C7 04 CA FF FF FF FF 8B 45 C0 8B 4C 85 E4 C1 F9 05 8B 55 C0 8B 44 95 E4 83 E0 1F 8B 0C 8D ?? ?? ?? ?? 8A 54 C1 04 88 55 CC 8B 45 C0 8B 4C 85 E4 C1 F9 05 8B 55 C0 8B 44 95 E4 83 E0 1F 8B 0C 8D ?? ?? ?? ?? C6 44 C1 04 00 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 89 45 F0 83 7D F0 00 74 38 6A 00 8B 55 08 52 68 ?? ?? ?? ?? 8B 45 F0 50 8B 4D F0 51 6A 01 E8 ?? ?? ?? ?? 83 C4 18 89 45 DC 83 7D DC FF 75 58 83 3D ?? ?? ?? ?? 02 74 09 83 3D ?? ?? ?? ?? 0D 75 46 8B 15 ?? ?? ?? ?? 81 E2 00 80 00 00 85 D2 74 09 C7 45 B0 ?? ?? ?? ?? EB 07 C7 45 B0 ?? ?? ?? ?? 8B 45 B0 89 45 F0 6A 00 8B 4D 08 51 68 ?? ?? ?? ?? 8B 55 F0 52 8B 45 F0 50 6A 01 E8 ?? ?? ?? ?? 83 C4 18 89 45 DC 8B 4D C0 8B 54 8D E4 C1 FA 05 8B 45 C0 8B 4C 85 E4 83 E1 1F 8B 14 95 ?? ?? ?? ?? 8B 45 BC 89 04 CA 8B 4D C0 8B 54 8D E4 C1 FA 05 8B 45 C0 8B 4C 85 E4 83 E1 1F 8B 14 95 ?? ?? ?? ?? 8A 45 CC 88 44 CA 04 83 7D DC FF 75 05 E9 88 00 00 00 6A 03 6A 01 6A 00 8D 4D D4 51 8B 55 D8 52 8B 45 C4 50 8B 4D D8 51 FF 15 ?? ?? ?? ?? 8B 55 FC C1 FA 05 8B 45 FC 83 E0 1F 8B 0C 95 ?? ?? ?? ?? 8B 14 C1 52 FF 15 ?? ?? ?? ?? 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D D4 51 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC C1 F8 05 8B 4D FC 83 E1 1F 8B 14 85 ?? ?? ?? ?? 8A 45 D0 88 44 CA 04 8B 4D F8 8B 55 DC 89 51 04 8B 45 F8 8B 4D F4 89 08 8B 45 F4 E9 CF 00 00 00 8B 55 F8 C7 02 00 00 00 00 8B 45 F4 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D C0 C7 44 8D B4 00 00 00 00 6A 02 6A 01 6A 00 8D 55 D4 52 8B 45 D8 50 8B 4D C4 51 8B 55 D8 52 FF 15 ?? ?? ?? ?? 8B 45 FC C1 F8 05 8B 4D FC 83 E1 1F 8B 14 85 ?? ?? ?? ?? 8B 04 CA 50 FF 15 ?? ?? ?? ?? 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 D4 52 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4D FC C1 F9 05 8B 55 FC 83 E2 1F 8B 04 8D ?? ?? ?? ?? 8A 4D D0 88 4C D0 04 8B 55 C4 52 FF 15 ?? ?? ?? ?? 8B 45 C8 83 7C 85 B4 00 74 10 8B 4D C8 8B 54 8D E4 52 E8 ?? ?? ?? ?? 83 C4 04 8B 45 C0 83 7C 85 B4 00 74 10 8B 4D C0 8B 54 8D E4 52 E8 ?? ?? ?? ?? 83 C4 04 33 C0 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_342_0_0 {
	meta:
		name = "?set_terminate@@YAP6AXXZP6AXXZ@Z"
		size = 58
		refs = "0016 ?_ValidateExecute@@YAHP6GHXZ@Z 0023 ?__pTerminate@@3P6AXXZA"
	strings:
		$1 = { 55 8B EC 51 C7 45 FC 00 00 00 00 83 7D 08 00 74 10 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 12 8B 0D ?? ?? ?? ?? 89 4D FC 8B 55 08 89 15 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_342_3_0 {
	meta:
		name = "?__set_inconsistency@@YAP6AXXZP6AXXZ@Z"
		size = 58
		refs = "0016 ?_ValidateExecute@@YAHP6GHXZ@Z 0023 ?__pInconsistency@@3P6AXXZA"
	strings:
		$1 = { 55 8B EC 51 C7 45 FC 00 00 00 00 83 7D 08 00 74 10 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 12 8B 0D ?? ?? ?? ?? 89 4D FC 8B 55 08 89 15 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_342_2_0 {
	meta:
		name = "?_set_se_translator@@YAP6AXIPAU_EXCEPTION_POINTERS@@@ZP6AXI0@Z@Z"
		size = 58
		refs = "0016 ?_ValidateExecute@@YAHP6GHXZ@Z 0023 ?__pSETranslator@@3P6AXIPAU_EXCEPTION_POINTERS@@@ZA"
	strings:
		$1 = { 55 8B EC 51 C7 45 FC 00 00 00 00 83 7D 08 00 74 10 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 12 8B 0D ?? ?? ?? ?? 89 4D FC 8B 55 08 89 15 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_342_1_0 {
	meta:
		name = "?set_unexpected@@YAP6AXXZP6AXXZ@Z"
		size = 58
		refs = "0016 ?_ValidateExecute@@YAHP6GHXZ@Z 0023 ?__pUnexpected@@3P6AXXZA"
	strings:
		$1 = { 55 8B EC 51 C7 45 FC 00 00 00 00 83 7D 08 00 74 10 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 12 8B 0D ?? ?? ?? ?? 89 4D FC 8B 55 08 89 15 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_343_0_0 {
	meta:
		name = "__wfindfirsti64"
		size = 338
		refs = "0017 __imp__FindFirstFileW@8 002c __imp__GetLastError@0 005e $L17310 0065 $L17311 006b _errno 00b5 ___timet_from_ft 00fb __allmul 0123 _wcscpy 0135 $L17276 0139 $L17277 013d $L17278"
	strings:
		$1 = { 55 8B EC 81 EC 5C 02 00 00 56 8D 85 AC FD FF FF 50 8B 4D 08 51 FF 15 ?? ?? ?? ?? 89 85 A8 FD FF FF 83 BD A8 FD FF FF FF 75 69 FF 15 ?? ?? ?? ?? 89 45 FC 8B 55 FC 89 95 A4 FD FF FF 8B 85 A4 FD FF FF 83 E8 02 89 85 A4 FD FF FF 83 BD A4 FD FF FF 10 77 2D 8B 95 A4 FD FF FF 33 C9 8A 8A ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 02 00 00 00 EB 16 C7 05 ?? ?? ?? ?? 0C 00 00 00 EB 0A C7 05 ?? ?? ?? ?? 16 00 00 00 83 C8 FF E9 9D 00 00 00 8B 85 AC FD FF FF 2D 80 00 00 00 F7 D8 1B C0 23 85 AC FD FF FF 8B 4D 0C 89 01 8D 95 B0 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 89 41 04 8D 95 B8 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 89 41 08 8D 95 C0 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 89 41 0C 8B 95 C8 FD FF FF 33 C0 6A 01 6A 00 50 52 E8 ?? ?? ?? ?? 8B 8D CC FD FF FF 33 F6 03 C1 13 D6 8B 4D 0C 89 41 10 89 51 14 8D 95 D8 FD FF FF 52 8B 45 0C 83 C0 18 50 E8 ?? ?? ?? ?? 83 C4 08 8B 85 A8 FD FF FF 5E 8B E5 5D C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 02 02 02 02 01 02 02 02 02 02 02 02 02 02 00 }
	condition:
		$1
}

rule file_343_1_0 {
	meta:
		name = "__wfindnexti64"
		size = 323
		refs = "0017 __imp__FindNextFileW@8 0021 __imp__GetLastError@0 0053 $L17314 005a $L17315 0060 _errno 00aa ___timet_from_ft 00f0 __allmul 0118 _wcscpy 0126 $L17295 012a $L17296 012e $L17297"
	strings:
		$1 = { 55 8B EC 81 EC 58 02 00 00 56 8D 85 AC FD FF FF 50 8B 4D 08 51 FF 15 ?? ?? ?? ?? 85 C0 75 69 FF 15 ?? ?? ?? ?? 89 45 FC 8B 55 FC 89 95 A8 FD FF FF 8B 85 A8 FD FF FF 83 E8 02 89 85 A8 FD FF FF 83 BD A8 FD FF FF 10 77 2D 8B 95 A8 FD FF FF 33 C9 8A 8A ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 02 00 00 00 EB 16 C7 05 ?? ?? ?? ?? 0C 00 00 00 EB 0A C7 05 ?? ?? ?? ?? 16 00 00 00 83 C8 FF E9 99 00 00 00 8B 85 AC FD FF FF 2D 80 00 00 00 F7 D8 1B C0 23 85 AC FD FF FF 8B 4D 0C 89 01 8D 95 B0 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 89 41 04 8D 95 B8 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 89 41 08 8D 95 C0 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 89 41 0C 8B 95 C8 FD FF FF 33 C0 6A 01 6A 00 50 52 E8 ?? ?? ?? ?? 8B 8D CC FD FF FF 33 F6 03 C1 13 D6 8B 4D 0C 89 41 10 89 51 14 8D 95 D8 FD FF FF 52 8B 45 0C 83 C0 18 50 E8 ?? ?? ?? ?? 83 C4 08 33 C0 5E 8B E5 5D C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 02 02 02 02 01 02 02 02 02 02 02 02 02 02 00 }
	condition:
		$1
}

rule file_344_0_0 {
	meta:
		name = "?name@type_info@@QBEPBDXZ"
		size = 193
		refs = "001c __free_base 0021 __malloc_base 0031 ___unDName 0040 _strlen 0074 ??_C@_0M@BGND@typname?4cpp?$AA@ 008b __malloc_dbg 00a4 _strcpy"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D F4 8B 45 F4 83 78 04 00 0F 85 A1 00 00 00 68 00 28 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 8B 4D F4 83 C1 09 51 6A 00 E8 ?? ?? ?? ?? 83 C4 18 89 45 FC 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 83 E8 01 89 45 F8 EB 09 8B 45 F8 83 E8 01 89 45 F8 8B 4D FC 03 4D F8 0F BE 11 83 FA 20 75 0B 8B 45 FC 03 45 F8 C6 00 00 EB DE 6A 30 68 ?? ?? ?? ?? 6A 02 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 83 C0 01 50 E8 ?? ?? ?? ?? 83 C4 10 8B 55 F4 89 42 04 8B 45 FC 50 8B 4D F4 8B 51 04 52 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D F4 8B 41 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_345_0_0 {
	meta:
		name = "__wasctime"
		size = 399
		refs = "0009 _buf 0050 ___dnames 0064 ___mnames 009f _store_dt"
	strings:
		$1 = { 55 8B EC 83 EC 10 C7 45 FC ?? ?? ?? ?? 8B 45 08 8B 48 18 6B C9 03 89 4D F4 8B 55 08 8B 42 10 6B C0 03 89 45 F8 C7 45 F0 00 00 00 00 EB 12 8B 4D F0 83 C1 01 89 4D F0 8B 55 FC 83 C2 02 89 55 FC 83 7D F0 03 7D 2B 8B 45 F4 03 45 F0 66 0F BE 88 ?? ?? ?? ?? 8B 55 FC 66 89 0A 8B 45 F8 03 45 F0 66 0F BE 88 ?? ?? ?? ?? 8B 55 FC 66 89 4A 08 EB BD 8B 45 FC 66 C7 00 20 00 8B 4D FC 83 C1 08 89 4D FC 8B 55 FC 66 C7 02 20 00 8B 45 FC 83 C0 02 89 45 FC 8B 4D 08 8B 51 0C 52 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 8B 4D FC 66 C7 01 20 00 8B 55 FC 83 C2 02 89 55 FC 8B 45 08 8B 48 08 51 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 8B 45 FC 66 C7 00 3A 00 8B 4D FC 83 C1 02 89 4D FC 8B 55 08 8B 42 04 50 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 8B 55 FC 66 C7 02 3A 00 8B 45 FC 83 C0 02 89 45 FC 8B 4D 08 8B 11 52 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 8B 4D FC 66 C7 01 20 00 8B 55 FC 83 C2 02 89 55 FC 8B 45 08 8B 40 14 99 B9 64 00 00 00 F7 F9 83 C0 13 50 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 8B 45 08 8B 40 14 99 B9 64 00 00 00 F7 F9 52 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 8B 45 FC 66 C7 00 0A 00 8B 4D FC 83 C1 02 89 4D FC 8B 55 FC 66 C7 02 00 00 B8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_345_1_0 {
	meta:
		name = "_store_dt"
		size = 66
	strings:
		$1 = { 55 8B EC 8B 45 0C 99 B9 0A 00 00 00 F7 F9 83 C0 30 8B 55 08 66 89 02 8B 45 08 83 C0 02 89 45 08 8B 45 0C 99 B9 0A 00 00 00 F7 F9 83 C2 30 8B 45 08 66 89 10 8B 4D 08 83 C1 02 89 4D 08 8B 45 08 5D C3 }
	condition:
		$1
}

rule file_346_0_0 {
	meta:
		name = "__filwbuf"
		size = 501
		refs = "0010 ??_C@_0M@KJPK@str?5?$CB?$DN?5NULL?$AA@ 0019 ??_C@_09DNOI@_filbuf?4c?$AA@ 0020 __CrtDbgReport 00a6 __getbuf 00d0 __read 0158 ___pioinfo 0167 ___badioinfo"
	strings:
		$1 = { 55 8B EC 83 EC 08 53 56 57 83 7D 08 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 69 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D6 8B 4D 08 89 4D FC 8B 55 FC 8B 42 0C 25 83 00 00 00 85 C0 74 0D 8B 4D FC 8B 51 0C 83 E2 40 85 D2 74 0A B8 FF FF 00 00 E9 8F 01 00 00 8B 45 FC 8B 48 0C 83 E1 02 85 C9 74 18 8B 55 FC 8B 42 0C 0C 20 8B 4D FC 89 41 0C B8 FF FF 00 00 E9 6A 01 00 00 8B 55 FC 8B 42 0C 0C 01 8B 4D FC 89 41 0C 8B 55 FC 8B 42 0C 25 0C 01 00 00 85 C0 75 0E 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 EB 0B 8B 55 FC 8B 45 FC 8B 48 08 89 0A 8B 55 FC 8B 42 18 50 8B 4D FC 8B 51 08 52 8B 45 FC 8B 48 10 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 FC 89 42 04 8B 45 FC 83 78 04 00 74 12 8B 4D FC 83 79 04 01 74 09 8B 55 FC 83 7A 04 FF 75 32 8B 45 FC 8B 48 04 F7 D9 1B C9 83 E1 10 83 C1 10 8B 55 FC 8B 42 0C 0B C1 8B 4D FC 89 41 0C 8B 55 FC C7 42 04 00 00 00 00 B8 FF FF 00 00 E9 C4 00 00 00 8B 45 FC 8B 48 0C 81 E1 82 00 00 00 85 C9 75 55 8B 55 FC 83 7A 10 FF 74 21 8B 45 FC 8B 48 10 C1 F9 05 8B 55 FC 8B 42 10 83 E0 1F 8B 0C 8D ?? ?? ?? ?? 8D 14 C1 89 55 F8 EB 07 C7 45 F8 ?? ?? ?? ?? 8B 45 F8 0F BE 48 04 81 E1 82 00 00 00 81 F9 82 00 00 00 75 0F 8B 55 FC 8B 42 0C 80 CC 20 8B 4D FC 89 41 0C 8B 55 FC 81 7A 18 00 02 00 00 75 26 8B 45 FC 8B 48 0C 83 E1 08 85 C9 74 19 8B 55 FC 8B 42 0C 25 00 04 00 00 85 C0 75 0A 8B 4D FC C7 41 18 00 10 00 00 8B 55 FC 8B 42 04 83 E8 02 8B 4D FC 89 41 04 8B 55 FC 8B 02 33 C9 66 8B 08 8B C1 25 FF FF 00 00 8B 55 FC 8B 0A 83 C1 02 8B 55 FC 89 0A 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_348_0_0 {
	meta:
		name = "_wcsftime"
		size = 248
		refs = "0020 _wcslen 0030 ??_C@_0L@NIEK@wcsftime?4c?$AA@ 003d __malloc_dbg 0085 _wcstombs 00a6 _strftime 00be _mbstowcs 00dc __free_dbg"
	strings:
		$1 = { 55 8B EC 83 EC 10 C7 45 F0 00 00 00 00 C7 45 F8 00 00 00 00 C7 45 FC 00 00 00 00 8B 45 10 50 E8 ?? ?? ?? ?? 83 C4 04 83 C0 01 89 45 F4 6A 3C 68 ?? ?? ?? ?? 6A 02 8B 4D 0C D1 E1 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 FC 83 7D FC 00 75 07 33 C0 E9 A0 00 00 00 6A 3F 68 ?? ?? ?? ?? 6A 02 8B 55 F4 D1 E2 52 E8 ?? ?? ?? ?? 83 C4 10 89 45 F8 83 7D F8 00 75 02 EB 5F 8B 45 F4 D1 E0 50 8B 4D 10 51 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 FF 75 02 EB 42 8B 45 14 50 8B 4D F8 51 8B 55 0C D1 E2 52 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 24 8B 4D 0C 51 8B 55 FC 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F0 83 7D F0 FF 75 07 C7 45 F0 00 00 00 00 6A 02 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 08 8B 45 F0 8B E5 5D C3 }
	condition:
		$1
}

rule file_349_0_0 {
	meta:
		name = "_ldexp"
		size = 700
		refs = "0011 __ctrlfp 003c __sptype 0090 __handle_qnan2 00a5 __real@8@3fff8000000000000000 00ca __except2 00db __real@8@00000000000000000000 010c __decomp 015d __d_inf 016a __copysign 01b7 __set_exp"
	strings:
		$1 = { 55 8B EC 83 EC 54 68 FF FF 00 00 68 3F 13 00 00 E8 ?? ?? ?? ?? 83 C4 08 89 45 F4 8B 45 0E 25 FF FF 00 00 25 F0 7F 00 00 3D F0 7F 00 00 0F 85 A3 00 00 00 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 E0 83 7D E0 00 7E 50 83 7D E0 02 7E 08 83 7D E0 03 74 1B EB 42 68 FF FF 00 00 8B 45 F4 50 E8 ?? ?? ?? ?? 83 C4 08 DD 45 08 E9 45 02 00 00 8B 4D F4 51 DB 45 10 DD 5D D8 8B 55 DC 52 8B 45 D8 50 8B 4D 0C 51 8B 55 08 52 6A 19 E8 ?? ?? ?? ?? 83 C4 18 E9 1C 02 00 00 8B 45 F4 50 DD 45 08 DC 05 ?? ?? ?? ?? 83 EC 08 DD 1C 24 DB 45 10 DD 5D D0 8B 4D D4 51 8B 55 D0 52 8B 45 0C 50 8B 4D 08 51 6A 19 6A 08 E8 ?? ?? ?? ?? 83 C4 24 E9 E2 01 00 00 DD 45 08 DC 1D ?? ?? ?? ?? DF E0 F6 C4 40 74 19 68 FF FF 00 00 8B 55 F4 52 E8 ?? ?? ?? ?? 83 C4 08 DD 45 08 E9 B9 01 00 00 8D 45 F0 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C DD 5D E4 83 7D 10 00 7D 0A 8B 45 10 F7 D8 89 45 CC EB 06 8B 4D 10 89 4D CC 81 7D CC FF FF FF 7F 7E 08 8B 55 10 89 55 EC EB 09 8B 45 F0 03 45 10 89 45 EC 81 7D EC 00 0A 00 00 7E 4C 8B 4D F4 51 8B 55 E8 52 8B 45 E4 50 8B 0D ?? ?? ?? ?? 51 8B 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 08 DD 1C 24 DB 45 10 DD 5D C4 8B 45 C8 50 8B 4D C4 51 8B 55 0C 52 8B 45 08 50 6A 19 6A 11 E8 ?? ?? ?? ?? 83 C4 24 E9 1D 01 00 00 81 7D EC 00 04 00 00 7E 50 8B 4D EC 81 E9 00 06 00 00 51 8B 55 E8 52 8B 45 E4 50 E8 ?? ?? ?? ?? 83 C4 0C DD 5D F8 8B 4D F4 51 8B 55 FC 52 8B 45 F8 50 DB 45 10 DD 5D BC 8B 4D C0 51 8B 55 BC 52 8B 45 0C 50 8B 4D 08 51 6A 19 6A 11 E8 ?? ?? ?? ?? 83 C4 24 E9 C4 00 00 00 81 7D EC 03 F6 FF FF 7D 3A 8B 55 F4 52 DD 45 E4 DC 0D ?? ?? ?? ?? 83 EC 08 DD 1C 24 DB 45 10 DD 5D B4 8B 45 B8 50 8B 4D B4 51 8B 55 0C 52 8B 45 08 50 6A 19 6A 12 E8 ?? ?? ?? ?? 83 C4 24 E9 81 00 00 00 81 7D EC 03 FC FF FF 7D 4D 8B 4D EC 81 C1 00 06 00 00 51 8B 55 E8 52 8B 45 E4 50 E8 ?? ?? ?? ?? 83 C4 0C DD 5D F8 8B 4D F4 51 8B 55 FC 52 8B 45 F8 50 DB 45 10 DD 5D AC 8B 4D B0 51 8B 55 AC 52 8B 45 0C 50 8B 4D 08 51 6A 19 6A 12 E8 ?? ?? ?? ?? 83 C4 24 EB 2B 8B 55 EC 52 8B 45 E8 50 8B 4D E4 51 E8 ?? ?? ?? ?? 83 C4 0C DD 5D F8 68 FF FF 00 00 8B 55 F4 52 E8 ?? ?? ?? ?? 83 C4 08 DD 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_350_0_0 {
	meta:
		name = "__msize_base"
		size = 188
		refs = "0008 ___active_heap 0014 ___sbh_find_block 003e __crtheap 0045 __imp__HeapSize@12 0064 ___old_sbh_find_block"
	strings:
		$1 = { 55 8B EC 83 EC 14 83 3D ?? ?? ?? ?? 03 75 3F 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 83 7D FC 00 74 0C 8B 4D 08 8B 51 FC 83 EA 09 89 55 F8 83 7D FC 00 75 16 8B 45 08 50 6A 00 8B 0D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 89 45 F8 EB 67 83 3D ?? ?? ?? ?? 02 75 48 8D 55 F4 52 8D 45 EC 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F0 83 7D F0 00 74 0D 8B 55 F0 33 C0 8A 02 C1 E0 04 89 45 F8 83 7D F0 00 75 16 8B 4D 08 51 6A 00 8B 15 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 89 45 F8 EB 16 8B 45 08 50 6A 00 8B 0D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 89 45 F8 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_351_0_0 {
	meta:
		name = "_tmpnam"
		size = 126
		refs = "0006 _namebuf0 0011 _init_namebuf 0020 _genfname 0035 __access 006e _strcpy"
	strings:
		$1 = { 55 8B EC 0F BE 05 ?? ?? ?? ?? 85 C0 75 0C 6A 00 E8 ?? ?? ?? ?? 83 C4 04 EB 13 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 02 EB 4D 6A 00 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 15 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 02 EB 27 EB D8 83 7D 08 00 75 09 C7 45 08 ?? ?? ?? ?? EB 11 68 ?? ?? ?? ?? 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 8B 45 08 EB 02 33 C0 5D C3 }
	condition:
		$1
}

rule file_351_1_0 {
	meta:
		name = "_tmpfile"
		size = 293
		refs = "0009 _namebuf1 0014 _init_namebuf 0023 _genfname 0034 __getstream 0058 __sopen 006a _errno 0097 ??_C@_09MBMN@tmpfile?4c?$AA@ 00a3 _strlen 00af __malloc_dbg 00ca __close 00e0 _strcpy 0105 __commode"
	strings:
		$1 = { 55 8B EC 83 EC 08 0F BE 05 ?? ?? ?? ?? 85 C0 75 0C 6A 01 E8 ?? ?? ?? ?? 83 C4 04 EB 16 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 05 E9 EC 00 00 00 E8 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 75 05 E9 D9 00 00 00 68 80 01 00 00 6A 40 68 42 85 00 00 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 89 45 F8 83 7D F8 FF 75 1E 83 3D ?? ?? ?? ?? 11 75 15 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 02 EB 02 EB C0 83 7D F8 FF 75 05 E9 8E 00 00 00 68 F1 00 00 00 68 ?? ?? ?? ?? 6A 02 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 83 C0 01 50 E8 ?? ?? ?? ?? 83 C4 10 8B 4D FC 89 41 1C 8B 55 FC 83 7A 1C 00 75 0E 8B 45 F8 50 E8 ?? ?? ?? ?? 83 C4 04 EB 4C 68 ?? ?? ?? ?? 8B 4D FC 8B 51 1C 52 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC C7 40 04 00 00 00 00 8B 4D FC C7 01 00 00 00 00 8B 55 FC C7 42 08 00 00 00 00 A1 ?? ?? ?? ?? 0C 80 8B 4D FC 89 41 0C 8B 55 FC 8B 45 F8 89 42 10 8B 45 FC EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_351_2_0 {
	meta:
		name = "_init_namebuf"
		size = 172
		refs = "000f _namebuf0 0018 _namebuf1 001d ??_C@_01PCFE@?2?$AA@ 0026 _strcpy 008a __getpid 0090 __ultoa 0098 ??_C@_01PJCK@?4?$AA@ 00a1 _strcat"
	strings:
		$1 = { 55 8B EC 83 EC 08 83 7D 08 00 75 09 C7 45 FC ?? ?? ?? ?? EB 07 C7 45 FC ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4D FC 83 C1 01 89 4D F8 8B 55 F8 0F BE 42 FF 83 F8 5C 74 1B 8B 4D F8 0F BE 51 FF 83 FA 2F 74 0F 8B 45 F8 C6 00 5C 8B 4D F8 83 C1 01 89 4D F8 83 7D 08 00 74 11 8B 55 F8 C6 02 74 8B 45 F8 83 C0 01 89 45 F8 EB 0F 8B 4D F8 C6 01 73 8B 55 F8 83 C2 01 89 55 F8 6A 20 8B 45 F8 50 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 0C 68 ?? ?? ?? ?? 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_351_3_0 {
	meta:
		name = "_genfname"
		size = 105
		refs = "000d __mbsrchr 0029 _strtoul 004f __ultoa 005c _strcpy"
	strings:
		$1 = { 55 8B EC 83 EC 0C 6A 2E 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 F8 8B 4D F8 83 C1 01 89 4D F8 6A 20 6A 00 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 0C 83 C0 01 89 45 F4 81 7D F4 FF 7F 00 00 72 05 83 C8 FF EB 21 6A 20 8D 45 FC 50 8B 4D F4 51 E8 ?? ?? ?? ?? 83 C4 0C 50 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 08 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_352_0_0 {
	meta:
		name = "__output"
		size = 3362
		refs = "0067 ___lookuptable 00bc $L1944 00d1 __pctype 00f6 _write_char 0117 ??_C@_0P@PIHB@ch?5?$CB?$DN?5_T?$CI?8?20?8?$CJ?$AA@ 0123 ??_C@_08MIHI@output?4c?$AA@ 012a __CrtDbgReport 01c8 $L1945 01cf $L1946 0219 _get_int_arg 02ea $L1947 02f1 $L1948 0381 $L1949 0388 $L1950 03b3 _get_short_arg 03cb _wctomb 0444 ___nullstring 0450 _strlen 0516 ___wnullstring 06af __cfltcvt_tab 07d6 _get_int64_arg 0987 __aullrem 09ac __aulldiv 0ace _write_multi_char 0aec _write_string 0c24 $NORMAL_STATE$1673 0c28 $L1685 0c2c $L1686 0c30 $L1696 0c34 $L1700 0c38 $L1701 0c3c $L1705 0c40 $L1716 0c44 $L1693 0c48 $L1694 0c4c $L1692 0c50 $L1691 0c54 $L1695 0c58 $L1688 0c6d $L1711 0c71 $L1714 0c75 $L1710 0c79 $L1715 0c7d $L1707 0cb0 $L1721 0cb4 $L1774 0cb8 $L1747 0cbc $L1799 0cc0 $L1731 0cc4 $L1722 0cc8 $L1794 0ccc $L1775 0cd0 $L1766 0cd4 $L1804 0cd8 $L1797 0cdc $L1748 0ce0 $L1796 0ce4 $L1801 0ce8 $L1718"
	strings:
		$1 = { 55 8B EC 81 EC A8 02 00 00 53 56 57 C7 45 DC 00 00 00 00 C7 85 D4 FD FF FF 00 00 00 00 C7 45 E8 00 00 00 00 8B 45 0C 8A 08 88 4D D8 0F BE 55 D8 8B 45 0C 83 C0 01 89 45 0C 85 D2 0F 84 D6 0B 00 00 83 BD D4 FD FF FF 00 0F 8C C9 0B 00 00 0F BE 4D D8 83 F9 20 7C 1F 0F BE 55 D8 83 FA 78 7F 16 0F BE 45 D8 0F BE 88 ?? ?? ?? ?? 83 E1 0F 89 8D 70 FD FF FF EB 0A C7 85 70 FD FF FF 00 00 00 00 8B 95 70 FD FF FF 89 55 F4 8B 45 F4 8B 4D E8 0F BE 94 C1 ?? ?? ?? ?? C1 FA 04 89 55 E8 8B 45 E8 89 85 6C FD FF FF 83 BD 6C FD FF FF 07 0F 87 5F 0B 00 00 8B 8D 6C FD FF FF FF 24 8D ?? ?? ?? ?? C7 45 E4 00 00 00 00 8B 55 D8 81 E2 FF 00 00 00 A1 ?? ?? ?? ?? 33 C9 66 8B 0C 50 81 E1 00 80 00 00 85 C9 74 58 8D 95 D4 FD FF FF 52 8B 45 08 50 0F BE 4D D8 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 0C 8A 02 88 45 D8 8B 4D 0C 83 C1 01 89 4D 0C 0F BE 55 D8 85 D2 75 21 68 ?? ?? ?? ?? 6A 00 68 86 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D1 8D 8D D4 FD FF FF 51 8B 55 08 52 0F BE 45 D8 50 E8 ?? ?? ?? ?? 83 C4 0C E9 B8 0A 00 00 C7 45 F8 00 00 00 00 8B 4D F8 89 8D C4 FD FF FF 8B 95 C4 FD FF FF 89 95 BC FD FF FF 8B 85 BC FD FF FF 89 45 F0 C7 45 FC 00 00 00 00 C7 85 CC FD FF FF FF FF FF FF C7 45 E4 00 00 00 00 E9 76 0A 00 00 0F BE 4D D8 89 8D 68 FD FF FF 8B 95 68 FD FF FF 83 EA 20 89 95 68 FD FF FF 83 BD 68 FD FF FF 10 77 48 8B 8D 68 FD FF FF 33 C0 8A 81 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 8B 55 FC 83 CA 04 89 55 FC EB 28 8B 45 FC 0C 01 89 45 FC EB 1E 8B 4D FC 83 C9 02 89 4D FC EB 13 8B 55 FC 80 CA 80 89 55 FC EB 08 8B 45 FC 0C 08 89 45 FC E9 07 0A 00 00 0F BE 4D D8 83 F9 2A 75 33 8D 55 10 52 E8 ?? ?? ?? ?? 83 C4 04 89 85 BC FD FF FF 83 BD BC FD FF FF 00 7D 16 8B 45 FC 0C 04 89 45 FC 8B 8D BC FD FF FF F7 D9 89 8D BC FD FF FF EB 17 8B 95 BC FD FF FF 6B D2 0A 0F BE 45 D8 8D 4C 02 D0 89 8D BC FD FF FF E9 AF 09 00 00 C7 85 CC FD FF FF 00 00 00 00 E9 A0 09 00 00 0F BE 55 D8 83 FA 2A 75 27 8D 45 10 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 CC FD FF FF 83 BD CC FD FF FF 00 7D 0A C7 85 CC FD FF FF FF FF FF FF EB 17 8B 8D CC FD FF FF 6B C9 0A 0F BE 55 D8 8D 44 11 D0 89 85 CC FD FF FF E9 54 09 00 00 0F BE 4D D8 89 8D 64 FD FF FF 8B 95 64 FD FF FF 83 EA 49 89 95 64 FD FF FF 83 BD 64 FD FF FF 2E 77 6C 8B 8D 64 FD FF FF 33 C0 8A 81 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 8B 55 FC 83 CA 10 89 55 FC EB 4C 8B 45 0C 0F BE 08 83 F9 36 75 20 8B 55 0C 0F BE 42 01 83 F8 34 75 14 8B 4D 0C 83 C1 02 89 4D 0C 8B 55 FC 80 CE 80 89 55 FC EB 0C C7 45 E8 00 00 00 00 E9 89 FD FF FF EB 13 8B 45 FC 0C 20 89 45 FC EB 09 8B 4D FC 80 CD 08 89 4D FC E9 C1 08 00 00 0F BE 55 D8 89 95 60 FD FF FF 8B 85 60 FD FF FF 83 E8 43 89 85 60 FD FF FF 83 BD 60 FD FF FF 35 0F 87 C0 06 00 00 8B 95 60 FD FF FF 33 C9 8A 8A ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? 8B 45 FC 25 30 08 00 00 85 C0 75 09 8B 4D FC 80 CD 08 89 4D FC 8B 55 FC 81 E2 10 08 00 00 85 D2 74 39 8D 45 10 50 E8 ?? ?? ?? ?? 83 C4 04 66 89 45 EC 66 8B 4D EC 51 8D 95 D8 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 DC 83 7D DC 00 7D 0A C7 85 C4 FD FF FF 01 00 00 00 EB 26 8D 45 10 50 E8 ?? ?? ?? ?? 83 C4 04 66 89 85 B8 FD FF FF 8A 8D B8 FD FF FF 88 8D D8 FD FF FF C7 45 DC 01 00 00 00 8D 95 D8 FD FF FF 89 55 E0 E9 1C 06 00 00 8D 45 10 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 B4 FD FF FF 83 BD B4 FD FF FF 00 74 0C 8B 8D B4 FD FF FF 83 79 04 00 75 1A 8B 15 ?? ?? ?? ?? 89 55 E0 8B 45 E0 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 DC EB 4F 8B 4D FC 81 E1 00 08 00 00 85 C9 74 23 8B 95 B4 FD FF FF 8B 42 04 89 45 E0 8B 8D B4 FD FF FF 0F BF 11 D1 EA 89 55 DC C7 45 E4 01 00 00 00 EB 1F C7 45 E4 00 00 00 00 8B 85 B4 FD FF FF 8B 48 04 89 4D E0 8B 95 B4 FD FF FF 0F BF 02 89 45 DC E9 87 05 00 00 8B 4D FC 81 E1 30 08 00 00 85 C9 75 09 8B 55 FC 80 CE 08 89 55 FC 83 BD CC FD FF FF FF 75 0C C7 85 5C FD FF FF FF FF FF 7F EB 0C 8B 85 CC FD FF FF 89 85 5C FD FF FF 8B 8D 5C FD FF FF 89 8D A8 FD FF FF 8D 55 10 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 E0 8B 45 FC 25 10 08 00 00 85 C0 74 68 83 7D E0 00 75 09 8B 0D ?? ?? ?? ?? 89 4D E0 C7 45 E4 01 00 00 00 8B 55 E0 89 95 AC FD FF FF 8B 85 A8 FD FF FF 8B 8D A8 FD FF FF 83 E9 01 89 8D A8 FD FF FF 85 C0 74 20 8B 95 AC FD FF FF 33 C0 66 8B 02 85 C0 74 11 8B 8D AC FD FF FF 83 C1 02 89 8D AC FD FF FF EB C7 8B 95 AC FD FF FF 2B 55 E0 D1 FA 89 55 DC EB 5A 83 7D E0 00 75 08 A1 ?? ?? ?? ?? 89 45 E0 8B 4D E0 89 8D B0 FD FF FF 8B 95 A8 FD FF FF 8B 85 A8 FD FF FF 83 E8 01 89 85 A8 FD FF FF 85 D2 74 1E 8B 8D B0 FD FF FF 0F BE 11 85 D2 74 11 8B 85 B0 FD FF FF 83 C0 01 89 85 B0 FD FF FF EB C9 8B 8D B0 FD FF FF 2B 4D E0 89 4D DC E9 62 04 00 00 8D 55 10 52 E8 ?? ?? ?? ?? 83 C4 04 89 85 A4 FD FF FF 8B 45 FC 83 E0 20 85 C0 74 12 8B 8D A4 FD FF FF 66 8B 95 D4 FD FF FF 66 89 11 EB 0E 8B 85 A4 FD FF FF 8B 8D D4 FD FF FF 89 08 C7 85 C4 FD FF FF 01 00 00 00 E9 17 04 00 00 C7 45 F8 01 00 00 00 8A 55 D8 80 C2 20 88 55 D8 8B 45 FC 0C 40 89 45 FC 8D 8D D8 FD FF FF 89 4D E0 83 BD CC FD FF FF 00 7D 0C C7 85 CC FD FF FF 06 00 00 00 EB 1C 83 BD CC FD FF FF 00 75 13 0F BE 55 D8 83 FA 67 75 0A C7 85 CC FD FF FF 01 00 00 00 8B 45 10 83 C0 08 89 45 10 8B 4D 10 83 E9 08 8B 11 8B 41 04 89 95 9C FD FF FF 89 85 A0 FD FF FF 8B 4D F8 51 8B 95 CC FD FF FF 52 0F BE 45 D8 50 8B 4D E0 51 8D 95 9C FD FF FF 52 FF 15 ?? ?? ?? ?? 83 C4 14 8B 45 FC 25 80 00 00 00 85 C0 74 16 83 BD CC FD FF FF 00 75 0D 8B 4D E0 51 FF 15 ?? ?? ?? ?? 83 C4 04 0F BE 55 D8 83 FA 67 75 19 8B 45 FC 25 80 00 00 00 85 C0 75 0D 8B 4D E0 51 FF 15 ?? ?? ?? ?? 83 C4 04 8B 55 E0 0F BE 02 83 F8 2D 75 12 8B 4D FC 80 CD 01 89 4D FC 8B 55 E0 83 C2 01 89 55 E0 8B 45 E0 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 DC E9 0C 03 00 00 8B 4D FC 83 C9 40 89 4D FC C7 85 C8 FD FF FF 0A 00 00 00 E9 82 00 00 00 C7 85 C8 FD FF FF 0A 00 00 00 EB 76 C7 85 CC FD FF FF 08 00 00 00 C7 85 D0 FD FF FF 07 00 00 00 EB 0A C7 85 D0 FD FF FF 27 00 00 00 C7 85 C8 FD FF FF 10 00 00 00 8B 55 FC 81 E2 80 00 00 00 85 D2 74 1D C6 85 C0 FD FF FF 30 8B 85 D0 FD FF FF 83 C0 51 88 85 C1 FD FF FF C7 45 F0 02 00 00 00 EB 20 C7 85 C8 FD FF FF 08 00 00 00 8B 4D FC 81 E1 80 00 00 00 85 C9 74 09 8B 55 FC 80 CE 02 89 55 FC 8B 45 FC 25 00 80 00 00 85 C0 74 1D 8D 4D 10 51 E8 ?? ?? ?? ?? 83 C4 04 89 85 88 FD FF FF 89 95 8C FD FF FF E9 91 00 00 00 8B 55 FC 83 E2 20 85 D2 74 48 8B 45 FC 83 E0 40 85 C0 74 1E 8D 4D 10 51 E8 ?? ?? ?? ?? 83 C4 04 0F BF C0 99 89 85 88 FD FF FF 89 95 8C FD FF FF EB 1E 8D 55 10 52 E8 ?? ?? ?? ?? 83 C4 04 25 FF FF 00 00 99 89 85 88 FD FF FF 89 95 8C FD FF FF EB 3F 8B 45 FC 83 E0 40 85 C0 74 1B 8D 4D 10 51 E8 ?? ?? ?? ?? 83 C4 04 99 89 85 88 FD FF FF 89 95 8C FD FF FF EB 1A 8D 55 10 52 E8 ?? ?? ?? ?? 83 C4 04 33 C9 89 85 88 FD FF FF 89 8D 8C FD FF FF 8B 55 FC 83 E2 40 85 D2 74 3E 83 BD 8C FD FF FF 00 7F 35 7C 09 83 BD 88 FD FF FF 00 73 2A 8B 85 88 FD FF FF F7 D8 8B 8D 8C FD FF FF 83 D1 00 F7 D9 89 85 94 FD FF FF 89 8D 98 FD FF FF 8B 55 FC 80 CE 01 89 55 FC EB 18 8B 85 88 FD FF FF 89 85 94 FD FF FF 8B 8D 8C FD FF FF 89 8D 98 FD FF FF 8B 55 FC 81 E2 00 80 00 00 85 D2 75 1B 8B 85 94 FD FF FF 8B 8D 98 FD FF FF 83 E1 00 89 85 94 FD FF FF 89 8D 98 FD FF FF 83 BD CC FD FF FF 00 7D 0C C7 85 CC FD FF FF 01 00 00 00 EB 09 8B 55 FC 83 E2 F7 89 55 FC 8B 85 94 FD FF FF 0B 85 98 FD FF FF 85 C0 75 07 C7 45 F0 00 00 00 00 8D 4D D7 89 4D E0 8B 95 CC FD FF FF 8B 85 CC FD FF FF 83 E8 01 89 85 CC FD FF FF 85 D2 7F 14 8B 8D 94 FD FF FF 0B 8D 98 FD FF FF 85 C9 0F 84 81 00 00 00 8B 85 C8 FD FF FF 99 52 50 8B 95 98 FD FF FF 52 8B 85 94 FD FF FF 50 E8 ?? ?? ?? ?? 83 C0 30 89 85 90 FD FF FF 8B 85 C8 FD FF FF 99 52 50 8B 8D 98 FD FF FF 51 8B 95 94 FD FF FF 52 E8 ?? ?? ?? ?? 89 85 94 FD FF FF 89 95 98 FD FF FF 83 BD 90 FD FF FF 39 7E 12 8B 85 90 FD FF FF 03 85 D0 FD FF FF 89 85 90 FD FF FF 8B 4D E0 8A 95 90 FD FF FF 88 11 8B 45 E0 83 E8 01 89 45 E0 E9 52 FF FF FF 8D 4D D7 2B 4D E0 89 4D DC 8B 55 E0 83 C2 01 89 55 E0 8B 45 FC 25 00 02 00 00 85 C0 74 29 8B 4D E0 0F BE 11 83 FA 30 75 06 83 7D DC 00 75 18 8B 45 E0 83 E8 01 89 45 E0 8B 4D E0 C6 01 30 8B 55 DC 83 C2 01 89 55 DC 83 BD C4 FD FF FF 00 0F 85 CE 01 00 00 8B 45 FC 83 E0 40 85 C0 74 4F 8B 4D FC 81 E1 00 01 00 00 85 C9 74 10 C6 85 C0 FD FF FF 2D C7 45 F0 01 00 00 00 EB 32 8B 55 FC 83 E2 01 85 D2 74 10 C6 85 C0 FD FF FF 2B C7 45 F0 01 00 00 00 EB 18 8B 45 FC 83 E0 02 85 C0 74 0E C6 85 C0 FD FF FF 20 C7 45 F0 01 00 00 00 8B 8D BC FD FF FF 2B 4D DC 2B 4D F0 89 8D 84 FD FF FF 8B 55 FC 83 E2 0C 85 D2 75 1C 8D 85 D4 FD FF FF 50 8B 4D 08 51 8B 95 84 FD FF FF 52 6A 20 E8 ?? ?? ?? ?? 83 C4 10 8D 85 D4 FD FF FF 50 8B 4D 08 51 8B 55 F0 52 8D 85 C0 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 10 8B 4D FC 83 E1 08 85 C9 74 26 8B 55 FC 83 E2 04 85 D2 75 1C 8D 85 D4 FD FF FF 50 8B 4D 08 51 8B 95 84 FD FF FF 52 6A 30 E8 ?? ?? ?? ?? 83 C4 10 83 7D E4 00 0F 84 A4 00 00 00 83 7D DC 00 0F 8E 9A 00 00 00 8B 45 E0 89 85 80 FD FF FF 8B 4D DC 89 8D 7C FD FF FF 8B 95 7C FD FF FF 8B 85 7C FD FF FF 83 E8 01 89 85 7C FD FF FF 85 D2 74 6D 8B 8D 80 FD FF FF 66 8B 11 66 89 95 5A FD FF FF 66 8B 85 5A FD FF FF 50 8D 8D 78 FD FF FF 51 8B 95 80 FD FF FF 83 C2 02 89 95 80 FD FF FF E8 ?? ?? ?? ?? 83 C4 08 89 85 74 FD FF FF 83 BD 74 FD FF FF 00 7F 02 EB 26 8D 85 D4 FD FF FF 50 8B 4D 08 51 8B 95 74 FD FF FF 52 8D 85 78 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 10 E9 7A FF FF FF EB 1B 8D 8D D4 FD FF FF 51 8B 55 08 52 8B 45 DC 50 8B 4D E0 51 E8 ?? ?? ?? ?? 83 C4 10 8B 55 FC 83 E2 04 85 D2 74 1C 8D 85 D4 FD FF FF 50 8B 4D 08 51 8B 95 84 FD FF FF 52 6A 20 E8 ?? ?? ?? ?? 83 C4 10 E9 0D F4 FF FF 8B 85 D4 FD FF FF 5F 5E 5B 8B E5 5D C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 05 05 01 05 05 05 05 05 05 05 02 05 03 05 05 04 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 01 04 04 04 02 04 04 04 04 04 04 04 04 04 04 03 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 0E 01 0E 01 0E 0E 0E 0E 0E 0E 0E 0E 0E 0E 0E 02 0E 0E 0E 0E 03 0E 04 0E 0E 0E 0E 0E 0E 0E 0E 05 06 07 07 07 0E 06 0E 0E 0E 0E 08 09 0A 0E 0E 0B 0E 0C 0E 0E 0D }
	condition:
		$1
}

rule file_352_1_0 {
	meta:
		name = "_write_char"
		size = 119
		refs = "004b __flsbuf"
	strings:
		$1 = { 55 8B EC 51 8B 45 0C 8B 48 04 83 E9 01 8B 55 0C 89 4A 04 8B 45 0C 83 78 04 00 7C 26 8B 4D 0C 8B 11 8A 45 08 88 02 0F BE 4D 08 81 E1 FF 00 00 00 89 4D FC 8B 55 0C 8B 02 83 C0 01 8B 4D 0C 89 01 EB 13 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC FF 75 0B 8B 4D 10 C7 01 FF FF FF FF EB 0D 8B 55 10 8B 02 83 C0 01 8B 4D 10 89 01 8B E5 5D C3 }
	condition:
		$1
}

rule file_352_2_0 {
	meta:
		name = "_write_multi_char"
		size = 53
		refs = "0020 _write_char"
	strings:
		$1 = { 55 8B EC 8B 45 0C 8B 4D 0C 83 E9 01 89 4D 0C 85 C0 7E 20 8B 55 14 52 8B 45 10 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 14 83 3A FF 75 02 EB 02 EB D0 5D C3 }
	condition:
		$1
}

rule file_352_3_0 {
	meta:
		name = "_write_string"
		size = 74
		refs = "0033 _write_char"
	strings:
		$1 = { 55 8B EC 51 8B 45 0C 8B 4D 0C 83 E9 01 89 4D 0C 85 C0 7E 32 8B 55 14 52 8B 45 10 50 8B 4D 08 0F BE 11 89 55 FC 8B 45 FC 50 8B 4D 08 83 C1 01 89 4D 08 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 14 83 3A FF 75 02 EB 02 EB BE 8B E5 5D C3 }
	condition:
		$1
}

rule file_353_0_0 {
	meta:
		name = "__waccess"
		size = 94
		refs = "000a __imp__GetFileAttributesW@4 0019 __imp__GetLastError@0 001f __dosmaperr 0041 _errno 004b __doserrno"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 50 FF 15 ?? ?? ?? ?? 89 45 FC 83 7D FC FF 75 14 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 83 C8 FF EB 2F 8B 4D FC 83 E1 01 85 C9 74 23 8B 55 0C 83 E2 02 85 D2 74 19 C7 05 ?? ?? ?? ?? 0D 00 00 00 C7 05 ?? ?? ?? ?? 05 00 00 00 83 C8 FF EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_419_0_0 {
	meta:
		name = "__access"
		size = 94
		refs = "000a __imp__GetFileAttributesA@4 0019 __imp__GetLastError@0 001f __dosmaperr 0041 _errno 004b __doserrno"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 50 FF 15 ?? ?? ?? ?? 89 45 FC 83 7D FC FF 75 14 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 83 C8 FF EB 2F 8B 4D FC 83 E1 01 85 C9 74 23 8B 55 0C 83 E2 02 85 D2 74 19 C7 05 ?? ?? ?? ?? 0D 00 00 00 C7 05 ?? ?? ?? ?? 05 00 00 00 83 C8 FF EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_354_0_0 {
	meta:
		name = "__ms_p5_test_fdiv"
		size = 94
		refs = "0039 __real@8@3fff8000000000000000"
	strings:
		$1 = { 55 8B EC 83 EC 1C 53 56 57 C7 45 E8 00 00 00 80 C7 45 EC FF FF 47 41 C7 45 F8 00 00 00 C0 C7 45 FC 7E 01 50 41 DD 45 F8 DC 75 E8 DC 4D E8 DC 6D F8 DD 5D F0 DD 45 F0 DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 75 09 C7 45 E4 01 00 00 00 EB 07 C7 45 E4 00 00 00 00 8B 45 E4 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_354_1_0 {
	meta:
		name = "__ms_p5_mp_test_fdiv"
		size = 66
		refs = "0007 ??_C@_08OBID@KERNEL32?$AA@ 000d __imp__GetModuleHandleA@4 001b ??_C@_0BK@JEGK@IsProcessorFeaturePresent?$AA@ 0025 __imp__GetProcAddress@8 003a __ms_p5_test_fdiv"
	strings:
		$1 = { 55 8B EC 83 EC 08 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 74 1F 68 ?? ?? ?? ?? 8B 45 FC 50 FF 15 ?? ?? ?? ?? 89 45 F8 83 7D F8 00 74 07 6A 00 FF 55 F8 EB 05 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_355_0_0 {
	meta:
		name = "__fltin"
		size = 200
		refs = "0022 ___strgtold12 0058 __ld12tod 0096 _flt"
	strings:
		$1 = { 55 8B EC 83 EC 24 C7 45 E0 00 00 00 00 6A 00 6A 00 6A 00 6A 00 8B 45 08 50 8D 4D EC 51 8D 55 F0 52 E8 ?? ?? ?? ?? 83 C4 1C 89 45 FC 8B 45 FC 83 E0 04 85 C0 74 19 8B 4D E0 80 CD 02 89 4D E0 C7 45 E4 00 00 00 00 C7 45 E8 00 00 00 00 EB 45 8D 55 E4 52 8D 45 F0 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 DC 8B 4D FC 83 E1 02 85 C9 75 06 83 7D DC 01 75 09 8B 55 E0 80 CA 80 89 55 E0 8B 45 FC 83 E0 01 85 C0 75 06 83 7D DC 02 75 09 8B 4D E0 80 CD 01 89 4D E0 8B 15 ?? ?? ?? ?? 8B 45 E0 89 02 8B 4D EC 2B 4D 08 8B 15 ?? ?? ?? ?? 89 4A 04 A1 ?? ?? ?? ?? 8B 4D E4 89 48 10 8B 55 E8 89 50 14 A1 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_356_0_0 {
	meta:
		name = "__spawnle"
		size = 242
		refs = "000e ??_C@_0BB@HLKL@pathname?5?$CB?$DN?5NULL?$AA@ 0017 ??_C@_09ENKL@spawnle?4c?$AA@ 001e __CrtDbgReport 003c ??_C@_0BG@FCLP@?$CKpathname?5?$CB?$DN?5_T?$CI?8?20?8?$CJ?$AA@ 0066 ??_C@_0BA@BICO@arglist?5?$CB?$DN?5NULL?$AA@ 0094 ??_C@_0BF@GGKN@?$CKarglist?5?$CB?$DN?5_T?$CI?8?20?8?$CJ?$AA@ 00e4 __spawnve"
	strings:
		$1 = { 55 8B EC 51 53 56 57 83 7D 0C 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 37 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D6 8B 4D 0C 0F BE 11 85 D2 75 1E 68 ?? ?? ?? ?? 6A 00 6A 38 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D2 83 7D 10 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 39 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D6 8B 55 10 0F BE 02 85 C0 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3A 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D2 8D 55 10 89 55 FC 8B 45 FC 8B 08 8B 55 FC 83 C2 04 89 55 FC 85 C9 74 02 EB EC 8B 45 FC 8B 08 51 8D 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 10 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_357_0_0 {
	meta:
		name = "__mbclen"
		size = 34
		refs = "000e __mbctype"
	strings:
		$1 = { 55 8B EC 8B 45 08 33 C9 8A 08 33 D2 8A 91 ?? ?? ?? ?? 8B C2 83 E0 04 F7 D8 1B C0 F7 D8 83 C0 01 5D C3 }
	condition:
		$1
}

rule file_358_0_0 {
	meta:
		name = "__aullshr"
		size = 16
	strings:
		$1 = { 80 F9 40 73 15 80 F9 20 73 06 0F AD D0 D3 EA C3 }
	condition:
		$1
}

rule file_359_0_0 {
	meta:
		name = "??_N@YGXPAXIHP6EX0@Z1@Z"
		size = 162
		refs = "0006 $T269 000b __except_handler3 0011 __except_list 008a ?__ArrayUnwind@@YGXPAXIHP6EX0@Z@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 C4 F0 53 56 57 C7 45 E0 00 00 00 00 C7 45 FC 00 00 00 00 C7 45 E4 00 00 00 00 EB 09 8B 45 E4 83 C0 01 89 45 E4 8B 4D E4 3B 4D 10 7D 13 6A 01 8B 4D 08 FF 55 14 8B 55 08 03 55 0C 89 55 08 EB DC C7 45 E0 01 00 00 00 C7 45 FC FF FF FF FF E8 02 00 00 00 EB 1C 83 7D E0 00 75 15 8B 45 18 50 8B 4D E4 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? C3 8B 4D F0 64 89 0D ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C2 14 00 }
	condition:
		$1
}

rule file_360_0_0 {
	meta:
		name = "__isctype"
		size = 183
		refs = "0018 __pctype 0099 ___crtGetStringTypeA"
	strings:
		$1 = { 55 8B EC 83 EC 0C 8B 45 08 83 C0 01 3D 00 01 00 00 77 17 8B 4D 08 8B 15 ?? ?? ?? ?? 33 C0 66 8B 04 4A 23 45 0C E9 89 00 00 00 8B 4D 08 C1 F9 08 81 E1 FF 00 00 00 81 E1 FF 00 00 00 8B 15 ?? ?? ?? ?? 33 C0 66 8B 04 4A 25 00 80 00 00 85 C0 74 22 8B 4D 08 C1 F9 08 81 E1 FF 00 00 00 88 4D F4 8A 55 08 88 55 F5 C6 45 F6 00 C7 45 F8 02 00 00 00 EB 11 8A 45 08 88 45 F4 C6 45 F5 00 C7 45 F8 01 00 00 00 6A 01 6A 00 6A 00 8D 4D FC 51 8B 55 F8 52 8D 45 F4 50 6A 01 E8 ?? ?? ?? ?? 83 C4 1C 85 C0 75 04 33 C0 EB 0B 8B 45 FC 25 FF FF 00 00 23 45 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_361_0_0 {
	meta:
		name = "_atof"
		size = 114
		refs = "0006 ___mb_cur_max 0018 __isctype 002d __pctype 0057 _strlen 0064 __fltin"
	strings:
		$1 = { 55 8B EC 51 83 3D ?? ?? ?? ?? 01 7E 17 6A 08 8B 45 08 33 C9 8A 08 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC EB 19 8B 55 08 33 C0 8A 02 8B 0D ?? ?? ?? ?? 33 D2 66 8B 14 41 83 E2 08 89 55 FC 83 7D FC 00 74 0B 8B 45 08 83 C0 01 89 45 08 EB B6 6A 00 6A 00 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 50 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 DD 40 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_362_1_0 {
	meta:
		name = "_tan"
		size = 158
		refs = "0005 __fload_withFB 001a __DEFAULT_CW_in_mem 002a ___fastflag 0031 __fast_exit 003c _NAME_ 0041 __math_exit 0047 __pi_by_2_to_61 005e __convertTOStoQNaN 0076 __indefinite 0098 __startOneArgErrorHandling"
	strings:
		$1 = { 8D 54 24 04 E8 ?? ?? ?? ?? 52 9B D9 3C 24 74 54 66 81 3C 24 7F 02 74 06 D9 2D ?? ?? ?? ?? D9 F2 9B DF E0 9E 7A 1F DD D8 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 20 00 00 00 8D 0D ?? ?? ?? ?? E9 ?? ?? ?? ?? DB 2D ?? ?? ?? ?? D9 C9 D9 F5 9B DF E0 9E 7A F8 DD D9 D9 F2 DD D8 EB CB E8 ?? ?? ?? ?? EB 1B A9 FF FF 0F 00 75 F2 83 7C 24 08 00 75 EB DD D8 DB 2D ?? ?? ?? ?? B8 01 00 00 00 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 20 00 00 00 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule file_363_0_0 {
	meta:
		name = "__fputwchar"
		size = 23
		refs = "0004 __iob 000e _fputwc"
	strings:
		$1 = { 55 8B EC 68 ?? ?? ?? ?? 66 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_390_8_0 {
	meta:
		name = "_iswalnum"
		size = 23
		refs = "000e _iswctype"
	strings:
		$1 = { 55 8B EC 68 07 01 00 00 66 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_390_1_0 {
	meta:
		name = "_iswalpha"
		size = 23
		refs = "000e _iswctype"
	strings:
		$1 = { 55 8B EC 68 03 01 00 00 66 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_390_10_0 {
	meta:
		name = "_iswgraph"
		size = 23
		refs = "000e _iswctype"
	strings:
		$1 = { 55 8B EC 68 17 01 00 00 66 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_390_9_0 {
	meta:
		name = "_iswprint"
		size = 23
		refs = "000e _iswctype"
	strings:
		$1 = { 55 8B EC 68 57 01 00 00 66 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_390_5_0 {
	meta:
		name = "_iswxdigit"
		size = 23
		refs = "000e _iswctype"
	strings:
		$1 = { 55 8B EC 68 80 00 00 00 66 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_363_1_0 {
	meta:
		name = "_putwchar"
		size = 18
		refs = "0009 __fputwchar"
	strings:
		$1 = { 55 8B EC 66 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_364_0_0 {
	meta:
		name = "__fptostr"
		size = 250
		refs = "00d8 _strlen 00ef _memmove"
	strings:
		$1 = { 55 8B EC 83 EC 0C 8B 45 08 89 45 FC 8B 4D 10 8B 51 0C 89 55 F8 8B 45 FC C6 00 30 8B 4D FC 83 C1 01 89 4D FC 83 7D 0C 00 7E 41 8B 55 F8 0F BE 02 85 C0 74 14 8B 4D F8 0F BE 11 89 55 F4 8B 45 F8 83 C0 01 89 45 F8 EB 07 C7 45 F4 30 00 00 00 8B 4D FC 8A 55 F4 88 11 8B 45 FC 83 C0 01 89 45 FC 8B 4D 0C 83 E9 01 89 4D 0C EB B9 8B 55 FC C6 02 00 83 7D 0C 00 7C 3D 8B 45 F8 0F BE 08 83 F9 35 7C 32 8B 55 FC 83 EA 01 89 55 FC 8B 45 FC 0F BE 08 83 F9 39 75 11 8B 55 FC C6 02 30 8B 45 FC 83 E8 01 89 45 FC EB E4 8B 4D FC 8A 11 80 C2 01 8B 45 FC 88 10 8B 4D 08 0F BE 11 83 FA 31 75 11 8B 45 10 8B 48 04 83 C1 01 8B 55 10 89 4A 04 EB 26 8B 45 08 83 C0 01 50 E8 ?? ?? ?? ?? 83 C4 04 83 C0 01 50 8B 4D 08 83 C1 01 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_367_0_0 {
	meta:
		name = "__stricoll"
		size = 108
		refs = "0006 ___lc_handle 0016 __strcmpi 0021 ___lc_collate_cp 003f ___crtCompareStringA 005b _errno"
	strings:
		$1 = { 55 8B EC 51 83 3D ?? ?? ?? ?? 00 75 12 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 EB 49 8B 15 ?? ?? ?? ?? 52 6A FF 8B 45 0C 50 6A FF 8B 4D 08 51 68 01 10 00 00 8B 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 1C 89 45 FC 83 7D FC 00 75 02 EB 08 8B 45 FC 83 E8 02 EB 0F C7 05 ?? ?? ?? ?? 16 00 00 00 B8 FF FF FF 7F 8B E5 5D C3 }
	condition:
		$1
}

rule file_368_0_0 {
	meta:
		name = "__aullrem"
		size = 33
	strings:
		$1 = { 53 8B 44 24 14 0B C0 75 18 8B 4C 24 10 8B 44 24 0C 33 D2 F7 F1 8B 44 24 08 F7 F1 8B C2 33 D2 EB 50 }
	condition:
		$1
}

rule file_368_2_0 {
	meta:
		name = "L3"
		size = 43
	strings:
		$1 = { D1 E9 D1 DB D1 EA D1 D8 0B C9 75 F4 F7 F3 8B C8 F7 64 24 14 91 F7 64 24 10 03 D1 72 0E 3B 54 24 0C 77 08 72 0E 3B 44 24 08 76 08 }
	condition:
		$1
}

rule file_369_0_0 {
	meta:
		name = "__wexecl"
		size = 209
		refs = "000d ??_C@_0BB@COCE@filename?5?$CB?$DN?5NULL?$AA@ 0016 ??_C@_07HEJO@execl?4c?$AA@ 001d __CrtDbgReport 003d ??_C@_0BG@GALO@?$CKfilename?5?$CB?$DN?5_T?$CI?8?20?8?$CJ?$AA@ 0067 ??_C@_0BA@BICO@arglist?5?$CB?$DN?5NULL?$AA@ 0097 ??_C@_0BF@GGKN@?$CKarglist?5?$CB?$DN?5_T?$CI?8?20?8?$CJ?$AA@ 00c5 __wexecve"
	strings:
		$1 = { 55 8B EC 53 56 57 83 7D 08 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 2F 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D6 8B 4D 08 33 D2 66 8B 11 85 D2 75 1E 68 ?? ?? ?? ?? 6A 00 6A 30 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D0 83 7D 0C 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 31 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D6 8B 55 0C 33 C0 66 8B 02 85 C0 75 1E 68 ?? ?? ?? ?? 6A 00 6A 32 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D0 6A 00 8D 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_370_0_0 {
	meta:
		name = "__getw"
		size = 233
		refs = "001d ??_C@_0M@KJPK@str?5?$CB?$DN?5NULL?$AA@ 0026 ??_C@_06GAJJ@getw?4c?$AA@ 002d __CrtDbgReport 0093 __filbuf"
	strings:
		$1 = { 55 8B EC 83 EC 1C 53 56 57 C7 45 F4 04 00 00 00 8D 45 EC 89 45 F8 83 7D 08 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 30 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D6 8B 55 08 89 55 FC 8B 45 F4 8B 4D F4 83 E9 01 89 4D F4 85 C0 74 5A 8B 55 FC 8B 42 04 83 E8 01 8B 4D FC 89 41 04 8B 55 FC 83 7A 04 00 7C 20 8B 45 FC 8B 08 0F BE 11 81 E2 FF 00 00 00 89 55 E8 8B 45 FC 8B 08 83 C1 01 8B 55 FC 89 0A EB 0F 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 E8 8B 4D F8 8A 55 E8 88 11 8B 45 F8 83 C0 01 89 45 F8 EB 96 8B 4D FC 8B 51 0C 83 E2 10 85 D2 75 15 8B 45 FC 8B 48 0C 83 E1 20 85 C9 75 08 8B 55 EC 89 55 E4 EB 07 C7 45 E4 FF FF FF FF 8B 45 E4 89 45 F0 8B 45 F0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_371_0_0 {
	meta:
		name = "__fpieee_flt"
		size = 2839
		refs = "0073 _fpieee_flt_simd 0119 ??_C@_0O@HFDC@i386?2filter?4c?$AA@ 0120 __CrtDbgReport 019b _instr_info_table 0612 $L17283 0626 __FillOperand 0680 __PreventStackOverwrite 06a9 __UpdateFpCtxt 06c5 __IsMemoryLocation 06fc __GetFpRegVal 0738 __ieee_adj_single 0752 __ieee_adj_double 082b __AdjustLocation 095a $L17284 0aef $L17006 0af3 $L17012 0afb $L17010 0aff $L17002 0b07 $L17034 0b0b $L17035 0b0f $L17036 0b13 $L17037"
	strings:
		$1 = { 55 8B EC 81 EC 0C 01 00 00 53 56 57 81 7D 08 8E 00 00 C0 74 3D 81 7D 08 8F 00 00 C0 74 34 81 7D 08 90 00 00 C0 74 2B 81 7D 08 91 00 00 C0 74 22 81 7D 08 93 00 00 C0 74 19 81 7D 08 B4 02 00 C0 74 10 81 7D 08 B5 02 00 C0 74 07 33 C0 E9 96 0A 00 00 DB E3 81 7D 08 B4 02 00 C0 74 09 81 7D 08 B5 02 00 C0 75 19 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C E9 69 0A 00 00 8B 45 0C 8B 08 89 8D 64 FF FF FF 8B 95 64 FF FF FF 83 C2 14 89 95 68 FF FF FF 8B 45 0C 8B 48 04 89 4D FC 8B 55 FC 83 C2 1C 89 95 74 FF FF FF 8B 85 68 FF FF FF 83 38 00 74 35 8B 8D 68 FF FF FF 8B 11 52 FF 55 10 83 C4 04 89 45 90 83 7D 90 FF 75 15 8B 85 74 FF FF FF 8B 48 04 80 E1 00 8B 95 74 FF FF FF 89 4A 04 8B 45 90 E9 FA 09 00 00 8B 85 74 FF FF FF 8B 48 0C 33 D2 8A 11 83 E2 F8 81 FA D8 00 00 00 74 34 B8 01 00 00 00 85 C0 74 1E 6A 00 6A 00 68 E3 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D3 33 C0 E9 AE 09 00 00 8B 95 74 FF FF FF 8B 42 0C 66 8B 08 66 89 8D 78 FF FF FF 8B 95 78 FF FF FF C1 EA 0E 83 E2 03 33 C0 83 FA 03 0F 94 C0 89 85 7C FF FF FF 8B 8D 78 FF FF FF 83 E1 07 C1 E1 04 8B 95 7C FF FF FF C1 E2 03 0B CA 8B 85 78 FF FF FF C1 E8 0B 83 E0 07 0B C8 89 8D 70 FF FF FF 8B 8D 70 FF FF FF 8D 14 8D ?? ?? ?? ?? 89 95 6C FF FF FF 8B 85 6C FF FF FF 8B 08 81 E1 FF 0F 00 00 81 E1 FF 0F 00 00 C1 E1 05 8B 55 A0 81 E2 1F 00 FE FF 0B D1 89 55 A0 8B 85 74 FF FF FF 8B 08 89 4D 8C 8B 95 74 FF FF FF 8B 42 04 89 45 80 8B 4D 8C 81 E1 00 0C 00 00 89 8D 38 FF FF FF 81 BD 38 FF FF FF 00 08 00 00 77 23 81 BD 38 FF FF FF 00 08 00 00 74 3C 83 BD 38 FF FF FF 00 74 1C 81 BD 38 FF FF FF 00 04 00 00 74 1B EB 3C 81 BD 38 FF FF FF 00 0C 00 00 74 27 EB 2E 8B 55 A0 83 E2 FC 89 55 A0 EB 23 8B 45 A0 24 FC 0C 01 89 45 A0 EB 17 8B 4D A0 83 E1 FC 83 C9 02 89 4D A0 EB 09 8B 55 A0 83 CA 03 89 55 A0 8B 45 8C 25 00 03 00 00 89 85 34 FF FF FF 83 BD 34 FF FF FF 00 74 33 81 BD 34 FF FF FF 00 02 00 00 74 19 81 BD 34 FF FF FF 00 03 00 00 74 02 EB 23 8B 4D A0 83 E1 E3 89 4D A0 EB 18 8B 55 A0 83 E2 E3 83 CA 04 89 55 A0 EB 0A 8B 45 A0 24 E3 0C 08 89 45 A0 8B 4D 8C 83 E1 20 F7 D9 1B C9 41 83 E1 01 8B 55 A8 83 E2 FE 0B D1 89 55 A8 8B 45 8C 83 E0 10 F7 D8 1B C0 40 83 E0 01 D1 E0 8B 4D A8 83 E1 FD 0B C8 89 4D A8 8B 55 8C 83 E2 08 F7 DA 1B D2 42 83 E2 01 C1 E2 02 8B 45 A8 24 FB 0B C2 89 45 A8 8B 4D 8C 83 E1 04 F7 D9 1B C9 41 83 E1 01 C1 E1 03 8B 55 A8 83 E2 F7 0B D1 89 55 A8 8B 45 8C 83 E0 01 F7 D8 1B C0 40 83 E0 01 C1 E0 04 8B 4D A8 83 E1 EF 0B C8 89 4D A8 8B 55 80 83 E2 20 F7 DA 1B D2 F7 DA 83 E2 01 8B 45 AC 24 FE 0B C2 89 45 AC 8B 4D 80 83 E1 10 F7 D9 1B C9 F7 D9 83 E1 01 D1 E1 8B 55 AC 83 E2 FD 0B D1 89 55 AC 8B 45 80 83 E0 08 F7 D8 1B C0 F7 D8 83 E0 01 C1 E0 02 8B 4D AC 83 E1 FB 0B C8 89 4D AC 8B 55 80 83 E2 04 F7 DA 1B D2 F7 DA 83 E2 01 C1 E2 03 8B 45 AC 24 F7 0B C2 89 45 AC 8B 4D 80 83 E1 01 F7 D9 1B C9 F7 D9 83 E1 01 C1 E1 04 8B 55 AC 83 E2 EF 0B D1 89 55 AC 8B 45 A8 83 E0 01 85 C0 74 16 8B 4D AC 83 E1 01 85 C9 74 0C C7 85 30 FF FF FF 01 00 00 00 EB 0A C7 85 30 FF FF FF 00 00 00 00 8B 95 30 FF FF FF 83 E2 01 8B 45 A4 24 FE 0B C2 89 45 A4 8B 4D A8 D1 E9 83 E1 01 85 C9 74 18 8B 55 AC D1 EA 83 E2 01 85 D2 74 0C C7 85 2C FF FF FF 01 00 00 00 EB 0A C7 85 2C FF FF FF 00 00 00 00 8B 85 2C FF FF FF 83 E0 01 D1 E0 8B 4D A4 83 E1 FD 0B C8 89 4D A4 8B 55 A8 C1 EA 02 83 E2 01 85 D2 74 19 8B 45 AC C1 E8 02 83 E0 01 85 C0 74 0C C7 85 28 FF FF FF 01 00 00 00 EB 0A C7 85 28 FF FF FF 00 00 00 00 8B 8D 28 FF FF FF 83 E1 01 C1 E1 02 8B 55 A4 83 E2 FB 0B D1 89 55 A4 8B 45 A8 C1 E8 03 83 E0 01 85 C0 74 19 8B 4D AC C1 E9 03 83 E1 01 85 C9 74 0C C7 85 24 FF FF FF 01 00 00 00 EB 0A C7 85 24 FF FF FF 00 00 00 00 8B 95 24 FF FF FF 83 E2 01 C1 E2 03 8B 45 A4 24 F7 0B C2 89 45 A4 8B 4D A8 C1 E9 04 83 E1 01 85 C9 74 19 8B 55 AC C1 EA 04 83 E2 01 85 D2 74 0C C7 85 20 FF FF FF 01 00 00 00 EB 0A C7 85 20 FF FF FF 00 00 00 00 8B 85 20 FF FF FF 83 E0 01 C1 E0 04 8B 4D A4 83 E1 EF 0B C8 89 4D A4 8B 95 6C FF FF FF 8B 02 C1 E8 0C 83 E0 1F 83 F8 08 75 14 8B 8D 78 FF FF FF C1 E9 08 83 E1 07 89 8D 1C FF FF FF EB 14 8B 95 6C FF FF FF 8B 02 C1 E8 0C 83 E0 1F 89 85 1C FF FF FF 8B 8D 1C FF FF FF 89 4D 84 8B 95 6C FF FF FF 8B 02 C1 E8 11 83 E0 1F 83 F8 08 75 14 8B 8D 78 FF FF FF C1 E9 08 83 E1 07 89 8D 18 FF FF FF EB 14 8B 95 6C FF FF FF 8B 02 C1 E8 11 83 E0 1F 89 85 18 FF FF FF 8B 8D 18 FF FF FF 89 4D 88 8B 95 6C FF FF FF 8B 02 C1 E8 16 83 E0 1F 83 F8 08 75 14 8B 8D 78 FF FF FF C1 E9 08 83 E1 07 89 8D 14 FF FF FF EB 14 8B 95 6C FF FF FF 8B 02 C1 E8 16 83 E0 1F 89 85 14 FF FF FF 8B 8D 14 FF FF FF 89 4D F8 8B 55 08 89 95 10 FF FF FF 8B 85 10 FF FF FF 05 72 FF FF 3F 89 85 10 FF FF FF 83 BD 10 FF FF FF 05 0F 87 0A 03 00 00 8B 8D 10 FF FF FF FF 24 8D ?? ?? ?? ?? 8B 55 84 52 8B 85 74 FF FF FF 50 8D 4D B0 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 88 52 8B 85 74 FF FF FF 50 8D 4D C8 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 F8 52 8B 85 74 FF FF FF 50 8D 4D E0 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 F0 83 E2 FE 89 55 F0 8D 45 A0 50 FF 55 10 83 C4 04 89 45 90 83 7D 90 FF 75 39 8B 4D F8 51 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 F8 8B 85 6C FF FF FF 8B 08 C1 E1 02 C1 F9 1D 51 8B 55 F8 52 8D 45 E0 50 8B 8D 74 FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 10 E9 5E 02 00 00 8B 95 6C FF FF FF 8B 02 C1 E8 16 83 E0 1F 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 0F 84 43 01 00 00 8B 4D 84 51 8B 95 74 FF FF FF 52 8D 45 B0 50 E8 ?? ?? ?? ?? 83 C4 0C 6A 00 8B 8D 74 FF FF FF 51 8D 95 3C FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 08 89 8D 54 FF FF FF 8B 50 04 89 95 58 FF FF FF 66 8B 40 08 66 89 85 5C FF FF FF 8B 4D F0 83 C9 01 89 4D F0 83 7D F8 0D 75 16 8B 55 F0 83 E2 E1 89 55 F0 A1 ?? ?? ?? ?? 89 85 60 FF FF FF EB 18 8B 4D F0 83 E1 E1 83 C9 02 89 4D F0 8B 15 ?? ?? ?? ?? 89 95 60 FF FF FF 81 7D 08 91 00 00 C0 75 0E 8B 85 60 FF FF FF F7 D8 89 85 60 FF FF FF DB 85 60 FF FF FF DB AD 54 FF FF FF D9 FD DD D9 DB BD 54 FF FF FF 83 7D F8 0D 75 17 DB AD 54 FF FF FF D9 9D 50 FF FF FF 8B 8D 50 FF FF FF 89 4D E0 EB 1E DB AD 54 FF FF FF DD 9D 48 FF FF FF 8B 95 48 FF FF FF 89 55 E0 8B 85 4C FF FF FF 89 45 E4 DB E2 8D 4D A0 51 FF 55 10 83 C4 04 89 45 90 83 7D 90 FF 75 39 8B 55 F8 52 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 F8 8B 8D 6C FF FF FF 8B 11 C1 E2 02 C1 FA 1D 52 8B 45 F8 50 8D 4D E0 51 8B 95 74 FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 10 E9 FC 00 00 00 8B 85 6C FF FF FF 8B 08 C1 E1 02 C1 F9 1D 51 8B 55 84 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 94 8B 85 6C FF FF FF 8B 08 C1 E1 02 C1 F9 1D 51 8B 55 88 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 98 8B 85 6C FF FF FF 8B 08 C1 E1 02 C1 F9 1D 51 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 9C 8B 45 94 3B 45 9C 75 07 C7 45 94 1F 00 00 00 8B 4D 98 3B 4D 9C 75 07 C7 45 98 1F 00 00 00 8B 55 9C 52 8B 85 74 FF FF FF 50 8D 4D E0 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 94 52 8B 85 74 FF FF FF 50 8D 4D B0 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 98 52 8B 85 74 FF FF FF 50 8D 4D C8 51 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 A0 52 FF 55 10 83 C4 04 89 45 90 83 7D 90 FF 75 2C 8B 45 9C 50 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 9C 6A 00 8B 55 9C 52 8D 45 E0 50 8B 8D 74 FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 10 83 7D 90 FF 0F 85 C8 01 00 00 8B 95 74 FF FF FF 8B 42 04 24 00 8B 8D 74 FF FF FF 89 41 04 8B 95 74 FF FF FF 8B 02 89 45 8C 8B 4D A0 83 E1 03 89 8D 0C FF FF FF 83 BD 0C FF FF FF 03 77 40 8B 95 0C FF FF FF FF 24 95 ?? ?? ?? ?? 8B 45 8C 80 E4 F3 89 45 8C EB 28 8B 4D 8C 80 E5 F3 80 CD 04 89 4D 8C EB 1A 8B 55 8C 80 E6 F3 80 CE 08 89 55 8C EB 0C 8B 45 8C 80 E4 F3 80 CC 0C 89 45 8C 8B 4D A0 C1 E9 02 83 E1 07 89 8D 08 FF FF FF 83 BD 08 FF FF FF 00 74 14 83 BD 08 FF FF FF 01 74 19 83 BD 08 FF FF FF 02 74 1E EB 25 8B 55 8C 80 E6 FC 80 CE 03 89 55 8C EB 17 8B 45 8C 80 E4 FC 80 CC 02 89 45 8C EB 09 8B 4D 8C 80 E5 FC 89 4D 8C 8B 55 A8 83 E2 01 85 D2 74 13 8B 45 8C 24 DF 89 45 8C 8B 4D 8C 89 8D 04 FF FF FF EB 12 8B 55 8C 83 CA 20 89 55 8C 8B 45 8C 89 85 04 FF FF FF 8B 4D A8 D1 E9 83 E1 01 85 C9 74 14 8B 55 8C 83 E2 EF 89 55 8C 8B 45 8C 89 85 00 FF FF FF EB 12 8B 4D 8C 83 C9 10 89 4D 8C 8B 55 8C 89 95 00 FF FF FF 8B 45 A8 C1 E8 02 83 E0 01 85 C0 74 14 8B 4D 8C 83 E1 F7 89 4D 8C 8B 55 8C 89 95 FC FE FF FF EB 11 8B 45 8C 0C 08 89 45 8C 8B 4D 8C 89 8D FC FE FF FF 8B 55 A8 C1 EA 03 83 E2 01 85 D2 74 13 8B 45 8C 24 FB 89 45 8C 8B 4D 8C 89 8D F8 FE FF FF EB 12 8B 55 8C 83 CA 04 89 55 8C 8B 45 8C 89 85 F8 FE FF FF 8B 4D A8 C1 E9 04 83 E1 01 85 C9 74 14 8B 55 8C 83 E2 FE 89 55 8C 8B 45 8C 89 85 F4 FE FF FF EB 12 8B 4D 8C 83 C9 01 89 4D 8C 8B 55 8C 89 95 F4 FE FF FF 8B 85 74 FF FF FF 8B 4D 8C 89 08 8B 45 90 5F 5E 5B 8B E5 5D C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_371_1_0 {
	meta:
		name = "__FillOperand"
		size = 787
		refs = "002f $L17288 0036 $L17289 0059 __GetFpRegVal 0250 __zero80 028f ??_C@_0O@HFDC@i386?2filter?4c?$AA@ 0296 __CrtDbgReport 02bf $L17059 02c3 $L17085 02c7 $L17074 02cb $L17062 02cf $L17064 02d3 $L17066 02d7 $L17070 02db $L17068 02df $L17060 02e3 $L17072 02e7 $L17083 02eb $L17084 02ef $L17056"
	strings:
		$1 = { 55 8B EC 83 EC 20 53 56 57 8B 45 08 8B 48 10 83 C9 01 8B 55 08 89 4A 10 8B 45 10 89 45 E4 83 7D E4 1F 0F 87 90 02 00 00 8B 55 E4 33 C9 8A 8A ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? 8B 45 08 8B 48 10 83 E1 E1 83 C9 04 8B 55 08 89 4A 10 8B 45 10 50 8B 4D 0C 51 8D 55 E8 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D 08 8B 10 89 11 8B 50 04 89 51 04 66 8B 40 08 66 89 41 08 E9 3E 02 00 00 8B 4D 08 8B 51 10 83 E2 E1 83 CA 04 8B 45 08 89 50 10 8B 4D 0C 8B 51 14 8B 45 08 8B 0A 89 08 8B 4A 04 89 48 04 66 8B 52 08 66 89 50 08 E9 0C 02 00 00 8B 45 08 8B 48 10 83 E1 E1 83 C9 08 8B 55 08 89 4A 10 8B 45 0C 8B 48 14 8B 55 08 66 8B 01 66 89 02 E9 E6 01 00 00 8B 4D 08 8B 51 10 83 E2 E1 83 CA 0A 8B 45 08 89 50 10 8B 4D 0C 8B 51 14 8B 45 08 8B 0A 89 08 E9 C2 01 00 00 8B 55 08 8B 42 10 24 E1 0C 0C 8B 4D 08 89 41 10 8B 55 0C 8B 42 14 8B 08 8B 50 04 8B 45 08 89 08 89 50 04 E9 9A 01 00 00 8B 4D 08 8B 51 10 83 E2 E1 83 CA 02 8B 45 08 89 50 10 8B 4D 0C 8B 51 14 8B 45 08 8B 0A 89 08 8B 52 04 89 50 04 E9 70 01 00 00 8B 45 08 8B 48 10 83 E1 E1 8B 55 08 89 4A 10 8B 45 0C 8B 48 14 8B 55 08 8B 01 89 02 E9 4F 01 00 00 8B 4D 08 8B 51 10 83 E2 E1 83 CA 14 8B 45 08 89 50 10 8B 4D 0C 8B 51 14 8B 45 08 8B 0A 89 08 8B 4A 04 89 48 04 66 8B 52 08 66 89 50 08 E9 1D 01 00 00 8B 45 08 8B 48 10 83 E1 E1 83 C9 16 8B 55 08 89 4A 10 8B 45 0C 8B 48 04 81 E1 00 01 00 00 F7 D9 1B C9 F7 D9 89 4D FC 8B 55 0C 8B 42 04 25 00 04 00 00 F7 D8 1B C0 83 E0 04 89 45 F8 8B 4D 0C 8B 51 04 81 E2 00 01 00 00 F7 DA 1B D2 83 E2 08 89 55 F4 8B 45 FC 0B 45 F8 0B 45 F4 89 45 E0 83 7D E0 00 74 11 83 7D E0 01 74 16 81 7D E0 00 01 00 00 74 18 EB 21 8B 4D 08 C7 01 01 00 00 00 EB 1F 8B 55 08 C7 02 02 00 00 00 EB 14 8B 45 08 C7 00 00 00 00 00 EB 09 8B 4D 08 C7 01 03 00 00 00 EB 7C 8B 55 08 8B 42 10 24 E1 0C 04 8B 4D 08 89 41 10 8B 55 08 A1 ?? ?? ?? ?? 89 02 8B 0D ?? ?? ?? ?? 89 4A 04 66 A1 ?? ?? ?? ?? 66 89 42 08 EB 4D 8B 4D 08 8B 51 10 83 E2 FE 8B 45 08 89 50 10 EB 3C B9 01 00 00 00 85 C9 74 1E 6A 00 6A 00 68 A5 03 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 D2 85 D2 75 D3 8B 45 08 8B 48 10 83 E1 FE 8B 55 08 89 4A 10 5F 5E 5B 8B E5 5D C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 01 02 03 04 05 06 07 08 09 0A 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 0B }
	condition:
		$1
}

rule file_371_2_0 {
	meta:
		name = "__UpdateFpCtxt"
		size = 69
		refs = "0012 __AdjustStack 0026 __UpdateResult"
	strings:
		$1 = { 55 8B EC 83 7D 14 00 7D 10 8B 45 14 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 83 7D 14 00 7E 10 8B 55 14 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_371_3_0 {
	meta:
		name = "__UpdateResult"
		size = 490
		refs = "001f $L17292 0030 __SetFpRegVal 00f8 $L17293 0171 ??_C@_0O@HFDC@i386?2filter?4c?$AA@ 0178 __CrtDbgReport 0192 $L17114 01b2 $L17139 01b6 $L17129 01ba $L17117 01be $L17119 01c2 $L17121 01c6 $L17125 01ca $L17123 01ce $L17115 01d2 $L17127 01da $L17134 01de $L17135 01e2 $L17136 01e6 $L17137"
	strings:
		$1 = { 55 8B EC 83 EC 08 53 56 57 8B 45 10 89 45 FC 83 7D FC 11 0F 87 72 01 00 00 8B 4D FC FF 24 8D ?? ?? ?? ?? 8B 55 0C 52 8B 45 10 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C E9 4F 01 00 00 8B 55 0C 8B 45 08 8B 48 14 8B 02 89 01 8B 42 04 89 41 04 66 8B 52 08 66 89 51 08 E9 2F 01 00 00 8B 45 08 8B 48 14 8B 55 0C 66 8B 02 66 89 01 E9 1B 01 00 00 8B 4D 08 8B 51 14 8B 45 0C 8B 08 89 0A E9 09 01 00 00 8B 55 0C 8B 02 8B 4A 04 8B 55 08 8B 52 14 89 02 89 4A 04 E9 F1 00 00 00 8B 45 08 8B 48 14 8B 55 0C 8B 02 89 01 8B 52 04 89 51 04 E9 D9 00 00 00 8B 45 08 8B 48 14 8B 55 0C 8B 02 89 01 E9 C7 00 00 00 8B 4D 0C 8B 55 08 8B 42 14 8B 11 89 10 8B 51 04 89 50 04 66 8B 49 08 66 89 48 08 E9 A7 00 00 00 8B 55 0C 8B 02 89 45 F8 83 7D F8 03 77 6A 8B 4D F8 FF 24 8D ?? ?? ?? ?? 8B 55 08 8B 42 04 80 CC 40 8B 4D 08 89 41 04 8B 55 08 8B 42 04 80 E4 FA 8B 4D 08 89 41 04 EB 40 8B 55 08 8B 42 04 80 E4 BA 8B 4D 08 89 41 04 EB 2F 8B 55 08 8B 42 04 80 CC 01 8B 4D 08 89 41 04 8B 55 08 8B 42 04 80 E4 BB 8B 4D 08 89 41 04 EB 0F 8B 55 08 8B 42 04 80 CC 45 8B 4D 08 89 41 04 EB 2D BA 01 00 00 00 85 D2 74 1E 6A 00 6A 00 68 4B 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D3 5F 5E 5B 8B E5 5D C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_371_4_0 {
	meta:
		name = "__AdjustStack"
		size = 322
		refs = "0049 __SetTag 0088 _memcpy 00b1 _memmove"
	strings:
		$1 = { 55 8B EC 83 EC 58 8B 45 08 83 C0 04 89 45 FC 83 7D 0C 00 0F 8E C7 00 00 00 C7 45 F8 00 00 00 00 EB 09 8B 4D F8 83 C1 01 89 4D F8 8B 55 F8 3B 55 0C 7D 42 6A 03 8B 45 FC 8B 08 C1 E9 0B 83 E1 07 51 8B 55 08 83 C2 08 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 FC 8B 08 C1 E9 0B 83 E1 07 83 C1 01 83 E1 07 C1 E1 0B 8B 55 FC 8B 02 80 E4 C7 0B C1 8B 4D FC 89 01 EB AD 8B 55 0C 6B D2 0A 52 8B 45 08 83 C0 1C 50 8D 4D A8 51 E8 ?? ?? ?? ?? 83 C4 0C BA 08 00 00 00 2B 55 0C 6B D2 0A 52 8B 45 0C 6B C0 0A 8B 4D 08 8D 54 01 1C 52 8B 45 08 83 C0 1C 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D 0C 6B C9 0A 51 8D 55 A8 52 B8 08 00 00 00 2B 45 0C 6B C0 0A 8B 4D 08 8D 54 01 1C 52 E8 ?? ?? ?? ?? 83 C4 0C EB 5E 83 7D 0C 00 7D 58 8B 45 FC 8B 08 C1 E9 0B 83 E1 07 83 E9 01 83 E1 07 C1 E1 0B 8B 55 FC 8B 02 80 E4 C7 0B C1 8B 4D FC 89 01 6A 00 8B 55 FC 8B 02 C1 E8 0B 83 E0 07 50 8B 4D 08 83 C1 08 51 E8 ?? ?? ?? ?? 83 C4 0C 6A 46 8B 55 08 83 C2 1C 52 8B 45 08 83 C0 26 50 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_371_5_0 {
	meta:
		name = "__AdjustLocation"
		size = 69
	strings:
		$1 = { 55 8B EC 83 EC 08 8B 45 08 89 45 F8 83 7D F8 00 7C 26 83 7D F8 07 7E 02 EB 1E 8B 4D 08 2B 4D 0C 89 4D FC 83 7D FC 00 7C 06 83 7D FC 07 7E 07 C7 45 FC 1F 00 00 00 EB 06 8B 55 08 89 55 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_371_6_0 {
	meta:
		name = "__PreventStackOverwrite"
		size = 76
		refs = "000c __IsMemoryLocation"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 2B 8B 4D 08 8B 55 08 8B 81 C4 00 00 00 3B 42 30 76 1A 54 58 89 45 FC 8B 4D 08 8B 51 30 83 C2 04 39 55 FC 77 07 C7 45 0C 1F 00 00 00 8B 45 0C 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_371_7_0 {
	meta:
		name = "__IsMemoryLocation"
		size = 37
	strings:
		$1 = { 55 8B EC 51 8B 45 08 89 45 FC 83 7D FC 0A 7C 0F 83 7D FC 10 7E 02 EB 07 B8 01 00 00 00 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_371_8_0 {
	meta:
		name = "__GetFpRegVal"
		size = 90
		refs = "003b __zero80"
	strings:
		$1 = { 55 8B EC 83 7D 10 00 7C 2D 83 7D 10 08 7D 27 8B 45 10 6B C0 0A 8B 4D 0C 8D 54 01 1C 8B 45 08 8B 0A 89 08 8B 4A 04 89 48 04 66 8B 52 08 66 89 50 08 8B 45 08 EB 22 8B 45 08 8B 0D ?? ?? ?? ?? 89 08 8B 15 ?? ?? ?? ?? 89 50 04 66 8B 0D ?? ?? ?? ?? 66 89 48 08 8B 45 08 5D C3 }
	condition:
		$1
}

rule file_371_9_0 {
	meta:
		name = "__SetFpRegVal"
		size = 207
		refs = "00c4 __SetTag"
	strings:
		$1 = { 55 8B EC 83 EC 10 8B 45 08 83 C0 04 89 45 FC 83 7D 0C 00 0F 8C B2 00 00 00 83 7D 0C 08 0F 8D A8 00 00 00 8B 4D 10 8B 55 0C 6B D2 0A 8B 45 08 8D 54 10 1C 8B 01 89 02 8B 41 04 89 42 04 66 8B 49 08 66 89 4A 08 8B 55 FC 8B 02 C1 E8 0B 83 E0 07 03 45 0C 33 D2 B9 08 00 00 00 F7 F1 89 55 F4 8B 55 10 33 C0 66 8B 42 08 25 FF 7F 00 00 89 45 F0 83 7D F0 00 74 0B 81 7D F0 FF 7F 00 00 74 25 EB 2C 8B 4D 10 83 39 00 75 12 8B 55 10 83 7A 04 00 75 09 C7 45 F8 01 00 00 00 EB 07 C7 45 F8 02 00 00 00 EB 10 C7 45 F8 02 00 00 00 EB 07 C7 45 F8 00 00 00 00 8B 45 F8 50 8B 4D F4 51 8B 55 08 83 C2 08 52 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_371_10_0 {
	meta:
		name = "__SetTag"
		size = 67
	strings:
		$1 = { 55 8B EC 83 EC 08 8B 45 0C D1 E0 89 45 FC BA 03 00 00 00 8B 4D FC D3 E2 89 55 F8 8B 45 10 8B 4D FC D3 E0 89 45 10 8B 4D F8 F7 D1 8B 55 08 8B 02 23 C1 8B 4D 10 23 4D F8 0B C1 8B 55 08 89 02 8B E5 5D C3 }
	condition:
		$1
}

rule file_372_0_0 {
	meta:
		name = "fFATN2"
		size = 80
		refs = "004c __rtindfpop"
	strings:
		$1 = { C6 85 70 FF FF FF FE D9 E1 D9 C9 D9 E1 D9 C9 D9 F3 0A C9 74 04 D9 EB DE E1 0A ED 74 02 D9 E0 C3 D9 E1 D9 C0 D9 C0 D9 E8 DE E1 D9 C9 D9 E8 DE C1 DE C9 D9 E4 9B DD BD 60 FF FF FF 9B F6 85 61 FF FF FF 01 75 05 32 ED D9 FA C3 58 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_372_2_0 {
	meta:
		name = "_rtforatn20"
		size = 29
		refs = "0012 __rtzeronpop 0019 __rtindfnpop"
	strings:
		$1 = { DD D8 0A C9 74 0B DD D8 D9 EB 0A ED 74 02 D9 E0 C3 E9 ?? ?? ?? ?? DD D8 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_372_3_0 {
	meta:
		name = "_rtforatnby0"
		size = 16
		refs = "000c __rtchsifneg"
	strings:
		$1 = { DD D8 8A CD EB 00 E8 CF FF FF FF E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_373_0_0 {
	meta:
		name = "__wgetpath"
		size = 322
	strings:
		$1 = { 55 8B EC 51 8B 45 08 33 C9 66 8B 08 83 F9 3B 75 0B 8B 55 08 83 C2 02 89 55 08 EB E8 8B 45 08 89 45 FC 8B 4D 10 83 E9 01 89 4D 10 83 7D 10 00 75 05 E9 F3 00 00 00 8B 55 08 33 C0 66 8B 02 85 C0 0F 84 CB 00 00 00 8B 4D 08 33 D2 66 8B 11 83 FA 3B 0F 84 BA 00 00 00 8B 45 08 33 C9 66 8B 08 83 F9 22 74 3A 8B 55 0C 8B 45 08 66 8B 08 66 89 0A 8B 55 0C 83 C2 02 89 55 0C 8B 45 08 83 C0 02 89 45 08 8B 4D 10 83 E9 01 89 4D 10 83 7D 10 00 75 0B 8B 55 08 89 55 FC E9 8D 00 00 00 EB 6E 8B 45 08 83 C0 02 89 45 08 8B 4D 08 33 D2 66 8B 11 85 D2 74 44 8B 45 08 33 C9 66 8B 08 83 F9 22 74 37 8B 55 0C 8B 45 08 66 8B 08 66 89 0A 8B 55 0C 83 C2 02 89 55 0C 8B 45 08 83 C0 02 89 45 08 8B 4D 10 83 E9 01 89 4D 10 83 7D 10 00 75 08 8B 55 08 89 55 FC EB 34 EB B0 8B 45 08 33 C9 66 8B 08 85 C9 74 09 8B 55 08 83 C2 02 89 55 08 E9 25 FF FF FF 8B 45 08 33 C9 66 8B 08 83 F9 3B 75 0B 8B 55 08 83 C2 02 89 55 08 EB E8 8B 45 0C 66 C7 00 00 00 8B 45 FC 2B 45 08 F7 D8 1B C0 23 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_375_0_0 {
	meta:
		name = "_strtod"
		size = 314
		refs = "000e ___mb_cur_max 0020 __isctype 0035 __pctype 005f _strlen 006c __fltin 00d5 __HUGE 00f3 _errno"
	strings:
		$1 = { 55 8B EC 83 EC 18 8B 45 08 89 45 F8 83 3D ?? ?? ?? ?? 01 7E 17 6A 08 8B 4D F8 33 D2 8A 11 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 E8 EB 19 8B 45 F8 33 C9 8A 08 8B 15 ?? ?? ?? ?? 33 C0 66 8B 04 4A 83 E0 08 89 45 E8 83 7D E8 00 74 0B 8B 4D F8 83 C1 01 89 4D F8 EB B6 6A 00 6A 00 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 04 50 8B 45 F8 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 F4 83 7D 0C 00 74 0E 8B 4D F4 8B 55 F8 03 51 04 8B 45 0C 89 10 8B 4D F4 8B 11 89 55 FC 8B 45 FC 25 40 02 00 00 85 C0 74 1E C7 45 EC 00 00 00 00 C7 45 F0 00 00 00 00 83 7D 0C 00 74 08 8B 4D 0C 8B 55 08 89 11 EB 77 8B 45 FC 25 81 00 00 00 85 C0 74 35 8B 4D F8 0F BE 11 83 FA 2D 75 0D DD 05 ?? ?? ?? ?? D9 E0 DD 5D EC EB 11 A1 ?? ?? ?? ?? 89 45 EC 8B 0D ?? ?? ?? ?? 89 4D F0 C7 05 ?? ?? ?? ?? 22 00 00 00 EB 36 8B 55 FC 81 E2 00 01 00 00 85 D2 74 1A C7 45 EC 00 00 00 00 C7 45 F0 00 00 00 00 C7 05 ?? ?? ?? ?? 22 00 00 00 EB 0F 8B 45 F4 8B 48 10 89 4D EC 8B 50 14 89 55 F0 DD 45 EC 8B E5 5D C3 }
	condition:
		$1
}

rule file_377_0_0 {
	meta:
		name = "__itow"
		size = 55
		refs = "0013 __itoa 002c __imp__MultiByteToWideChar@24"
	strings:
		$1 = { 55 8B EC 83 EC 14 8B 45 10 50 8D 4D EC 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 6A 14 8B 45 0C 50 6A FF 8D 4D EC 51 6A 01 6A 00 FF 15 ?? ?? ?? ?? 8B 45 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_377_1_0 {
	meta:
		name = "__ltow"
		size = 55
		refs = "0013 __ltoa 002c __imp__MultiByteToWideChar@24"
	strings:
		$1 = { 55 8B EC 83 EC 28 8B 45 10 50 8D 4D D8 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 6A 28 8B 45 0C 50 6A FF 8D 4D D8 51 6A 01 6A 00 FF 15 ?? ?? ?? ?? 8B 45 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_377_2_0 {
	meta:
		name = "__ultow"
		size = 55
		refs = "0013 __ultoa 002c __imp__MultiByteToWideChar@24"
	strings:
		$1 = { 55 8B EC 83 EC 28 8B 45 10 50 8D 4D D8 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 6A 28 8B 45 0C 50 6A FF 8D 4D D8 51 6A 01 6A 00 FF 15 ?? ?? ?? ?? 8B 45 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_377_3_0 {
	meta:
		name = "__i64tow"
		size = 59
		refs = "0017 __i64toa 0030 __imp__MultiByteToWideChar@24"
	strings:
		$1 = { 55 8B EC 83 EC 50 8B 45 14 50 8D 4D B0 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 6A 50 8B 4D 10 51 6A FF 8D 55 B0 52 6A 01 6A 00 FF 15 ?? ?? ?? ?? 8B 45 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_377_4_0 {
	meta:
		name = "__ui64tow"
		size = 59
		refs = "0017 __ui64toa 0030 __imp__MultiByteToWideChar@24"
	strings:
		$1 = { 55 8B EC 83 EC 50 8B 45 14 50 8D 4D B0 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 6A 50 8B 4D 10 51 6A FF 8D 55 B0 52 6A 01 6A 00 FF 15 ?? ?? ?? ?? 8B 45 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_378_0_0 {
	meta:
		name = "fFSINH"
		size = 25
	strings:
		$1 = { C6 85 70 FF FF FF FF E8 9C 00 00 00 0A DB 74 7B E8 D6 00 00 00 DE E9 EB 4E }
	condition:
		$1
}

rule file_378_1_0 {
	meta:
		name = "fFTANH"
		size = 57
		refs = "0006 _tanhmaxarg"
	strings:
		$1 = { D9 C0 D9 E1 DB 2D ?? ?? ?? ?? DE D9 9B DD BD 60 FF FF FF 9B F6 85 61 FF FF FF 41 75 64 E8 6D 00 00 00 0A DB 74 5B D9 C0 E8 93 00 00 00 D9 C9 E8 9E 00 00 00 DE E9 DE F1 C3 }
	condition:
		$1
}

rule file_378_2_0 {
	meta:
		name = "fFCOSH"
		size = 34
		refs = "001e __rttospop"
	strings:
		$1 = { C6 85 70 FF FF FF FF E8 4A 00 00 00 0A DB 74 33 E8 72 00 00 00 D9 E8 D9 E0 D9 C9 D9 FD E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_378_4_0 {
	meta:
		name = "_rtforcshinf"
		size = 32
		refs = "0004 __infinity 000b __rtinfnpop 0010 __rtchsifneg"
	strings:
		$1 = { DD D8 DB 2D ?? ?? ?? ?? C3 C3 E8 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? C6 85 70 FF FF FF 08 }
	condition:
		$1
}

rule file_378_5_0 {
	meta:
		name = "_rtfortnhinf"
		size = 91
		refs = "0001 __rtonenpop 000e __ffexpm1 0034 __rttospop"
	strings:
		$1 = { E8 ?? ?? ?? ?? EB E8 D9 EA DE C9 33 DB E8 ?? ?? ?? ?? F6 D3 F6 85 61 FF FF FF 01 74 09 E8 28 00 00 00 D9 C9 DD D8 F6 C2 40 75 08 F6 D7 D9 E8 DE C1 D9 FD E9 ?? ?? ?? ?? E8 0D 00 00 00 DE C1 0A FF 75 06 D9 E8 DC C1 DE C1 C3 D9 C0 D9 E8 0A FF 75 06 D8 C1 D9 E0 D9 C9 DE F1 C3 }
	condition:
		$1
}

rule file_379_0_0 {
	meta:
		name = "__umask"
		size = 40
		refs = "0011 __umaskval"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 25 80 01 00 00 89 45 08 8B 0D ?? ?? ?? ?? 89 4D FC 8B 55 08 89 15 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_380_0_0 {
	meta:
		name = "__mbsninc"
		size = 36
		refs = "0016 __mbsnbcnt"
	strings:
		$1 = { 55 8B EC 83 7D 08 00 75 04 33 C0 EB 15 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 8B 55 08 03 C2 5D C3 }
	condition:
		$1
}

rule file_381_0_0 {
	meta:
		name = "__startTwoArgErrorHandling"
		size = 23
	strings:
		$1 = { 55 8B EC 83 C4 E0 89 45 E0 8B 45 18 89 45 F0 8B 45 1C 89 45 F4 EB 09 }
	condition:
		$1
}

rule file_381_1_0 {
	meta:
		name = "__startOneArgErrorHandling"
		size = 60
		refs = "0025 __87except"
	strings:
		$1 = { 55 8B EC 83 C4 E0 89 45 E0 DD 5D F8 89 4D E4 8B 45 10 8B 4D 14 89 45 E8 89 4D EC 8D 45 08 8D 4D E0 50 51 52 E8 ?? ?? ?? ?? 83 C4 0C DD 45 F8 66 81 7D 08 7F 02 74 03 D9 6D 08 C9 C3 }
	condition:
		$1
}

rule file_382_0_0 {
	meta:
		name = "__mbspbrk"
		size = 285
		refs = "0008 ___ismbcodepage 0018 _strpbrk 006b __mbctype"
	strings:
		$1 = { 55 8B EC 83 EC 08 83 3D ?? ?? ?? ?? 00 75 15 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 E9 F5 00 00 00 8B 55 08 89 55 F8 EB 09 8B 45 F8 83 C0 01 89 45 F8 8B 4D F8 33 D2 8A 11 85 D2 0F 84 C5 00 00 00 8B 45 0C 89 45 FC EB 09 8B 4D FC 83 C1 01 89 4D FC 8B 55 FC 33 C0 8A 02 85 C0 74 6B 8B 4D FC 33 D2 8A 11 33 C0 8A 82 ?? ?? ?? ?? 83 E0 04 85 C0 74 3F 8B 4D FC 33 D2 8A 11 8B 45 F8 33 C9 8A 08 3B D1 75 14 8B 55 FC 33 C0 8A 42 01 8B 4D F8 33 D2 8A 51 01 3B C2 74 0C 8B 45 FC 33 C9 8A 48 01 85 C9 75 02 EB 21 8B 55 FC 83 C2 01 89 55 FC EB 14 8B 45 FC 33 C9 8A 08 8B 55 F8 33 C0 8A 02 3B C8 75 02 EB 02 EB 81 8B 4D FC 33 D2 8A 11 85 D2 74 02 EB 31 8B 45 F8 33 C9 8A 08 33 D2 8A 91 ?? ?? ?? ?? 83 E2 04 85 D2 74 16 8B 45 F8 83 C0 01 89 45 F8 8B 4D F8 33 D2 8A 11 85 D2 75 02 EB 05 E9 23 FF FF FF 8B 45 F8 33 C9 8A 08 8B C1 F7 D8 1B C0 23 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_384_0_0 {
	meta:
		name = "__wstrtime"
		size = 210
		refs = "000c __imp__GetLocalTime@4"
	strings:
		$1 = { 55 8B EC 83 EC 1C 8D 45 EC 50 FF 15 ?? ?? ?? ?? 8B 4D F4 81 E1 FF FF 00 00 89 4D E8 8B 55 F6 81 E2 FF FF 00 00 89 55 E4 8B 45 F8 25 FF FF 00 00 89 45 FC 8B 4D 08 66 C7 41 0A 3A 00 8B 55 08 66 C7 42 04 3A 00 8B 45 08 66 C7 40 10 00 00 8B 45 E8 99 B9 0A 00 00 00 F7 F9 83 C0 30 8B 55 08 66 89 02 8B 45 E8 99 B9 0A 00 00 00 F7 F9 83 C2 30 8B 45 08 66 89 50 02 8B 45 E4 99 B9 0A 00 00 00 F7 F9 83 C0 30 8B 55 08 66 89 42 06 8B 45 E4 99 B9 0A 00 00 00 F7 F9 83 C2 30 8B 45 08 66 89 50 08 8B 45 FC 99 B9 0A 00 00 00 F7 F9 83 C0 30 8B 55 08 66 89 42 0C 8B 45 FC 99 B9 0A 00 00 00 F7 F9 83 C2 30 8B 45 08 66 89 50 0E 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_385_0_0 {
	meta:
		name = "__wtol"
		size = 48
		refs = "001c __imp__WideCharToMultiByte@32 0025 _atol"
		altNames = "__wtoi"
	strings:
		$1 = { 55 8B EC 83 EC 14 6A 00 6A 00 6A 14 8D 45 EC 50 6A FF 8B 4D 08 51 6A 00 6A 00 FF 15 ?? ?? ?? ?? 8D 55 EC 52 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_385_2_0 {
	meta:
		name = "__wtoi64"
		size = 48
		refs = "001c __imp__WideCharToMultiByte@32 0025 __atoi64"
	strings:
		$1 = { 55 8B EC 83 EC 50 6A 00 6A 00 6A 50 8D 45 B0 50 6A FF 8B 4D 08 51 6A 00 6A 00 FF 15 ?? ?? ?? ?? 8D 55 B0 52 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_387_0_0 {
	meta:
		name = "___wrt2err"
		size = 57
		refs = "0027 ___pioinfo 0031 __imp__WriteFile@20"
	strings:
		$1 = { 55 8B EC 83 EC 08 8B 45 08 0F BE 08 89 4D FC 8B 55 08 83 C2 01 89 55 08 6A 00 8D 45 F8 50 8B 4D FC 51 8B 55 08 52 A1 ?? ?? ?? ?? 8B 48 10 51 FF 15 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_388_0_0 {
	meta:
		name = "__wsystem"
		size = 267
		refs = "000a ??_C@_1BA@NIMI@?$AAC?$AAO?$AAM?$AAS?$AAP?$AAE?$AAC?$AA?$AA@ 000f __wgetenv 0035 __waccess 0059 ??_C@_0BF@GFJL@?$CKcommand?5?$CB?$DN?5_T?$CI?8?20?8?$CJ?$AA@ 0062 ??_C@_08DLLJ@system?4c?$AA@ 0069 __CrtDbgReport 007f ??_C@_15FEDO@?$AA?1?$AAc?$AA?$AA@ 00a3 __wspawnve 00b5 _errno 00cc __osver 00dd ??_C@_1BI@PFHA@?$AAc?$AAo?$AAm?$AAm?$AAa?$AAn?$AAd?$AA?4?$AAc?$AAo?$AAm?$AA?$AA@ 00e6 ??_C@_1BA@OMOC@?$AAc?$AAm?$AAd?$AA?4?$AAe?$AAx?$AAe?$AA?$AA@ 00fd __wspawnvpe"
	strings:
		$1 = { 55 8B EC 83 EC 1C 53 56 57 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 89 45 F0 83 7D 08 00 75 2D 83 7D F0 00 75 09 C7 45 E8 00 00 00 00 EB 16 6A 00 8B 45 F0 50 E8 ?? ?? ?? ?? 83 C4 08 F7 D8 1B C0 40 89 45 E8 8B 45 E8 E9 B8 00 00 00 8B 4D 08 33 D2 66 8B 11 85 D2 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3B 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D0 C7 45 F4 ?? ?? ?? ?? 8B 4D 08 89 4D F8 C7 45 FC 00 00 00 00 83 7D F0 00 74 34 6A 00 8D 55 F0 52 8B 45 F0 50 6A 00 E8 ?? ?? ?? ?? 83 C4 10 89 45 EC 83 7D EC FF 75 12 83 3D ?? ?? ?? ?? 02 74 0E 83 3D ?? ?? ?? ?? 0D 74 05 8B 45 EC EB 3A 8B 0D ?? ?? ?? ?? 81 E1 00 80 00 00 85 C9 74 09 C7 45 E4 ?? ?? ?? ?? EB 07 C7 45 E4 ?? ?? ?? ?? 8B 55 E4 89 55 F0 6A 00 8D 45 F0 50 8B 4D F0 51 6A 00 E8 ?? ?? ?? ?? 83 C4 10 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_389_0_0 {
	meta:
		name = "_fdiv_main_routine"
		size = 279
		refs = "0028 fdiv_risc_table 006e fdiv_scale_1 0085 fdiv_scale_2 00f8 one_shl_63"
	strings:
		$1 = { DB 6C 24 10 DB 6C 24 04 8B 44 24 08 03 C0 0F 83 86 00 00 00 35 00 00 00 0E A9 00 00 00 0E 74 03 DE F9 C3 C1 E8 1C 80 B8 ?? ?? ?? ?? 00 75 03 DE F9 C3 8B 44 24 0C 25 FF 7F 00 00 74 67 3D FF 7F 00 00 74 60 D9 7C 24 1C 8B 44 24 1C 0D 3F 03 00 00 25 FF F3 00 00 89 44 24 20 D9 6C 24 20 8B 44 24 18 25 FF 7F 00 00 83 F8 01 74 17 D8 0D ?? ?? ?? ?? D9 C9 D8 0D ?? ?? ?? ?? D9 C9 D9 6C 24 1C DE F9 C3 D8 0D ?? ?? ?? ?? D9 C9 D8 0D ?? ?? ?? ?? D9 C9 D9 6C 24 1C DE F9 C3 8B 44 24 04 0B 44 24 08 75 03 DE F9 C3 8B 44 24 0C 25 FF 7F 00 00 75 F2 D9 7C 24 1C 8B 44 24 1C 0D 3F 03 00 00 25 FF F3 00 00 89 44 24 20 D9 6C 24 20 8B 44 24 18 25 FF 7F 00 00 74 11 3D FF 7F 00 00 74 32 8B 44 24 14 03 C0 73 2A EB 08 8B 44 24 14 03 C0 72 20 D9 C9 DD D8 D9 C0 D8 0D ?? ?? ?? ?? DB 7C 24 04 DB 6C 24 10 D9 C9 9B D9 6C 24 1C E9 F8 FE FF FF D9 6C 24 1C DE F9 C3 }
	condition:
		$1
}

rule file_389_10_0 {
	meta:
		name = "label8"
		size = 28
	strings:
		$1 = { DB 7C 24 0C D9 C0 DB 3C 24 DB 7C 24 20 E8 9C FE FF FF DB 6C 24 20 D9 C9 83 C4 2C C3 }
	condition:
		$1
}

rule file_389_12_0 {
	meta:
		name = "label10"
		size = 22
	strings:
		$1 = { DB 3C 24 DB 7C 24 0C E8 81 FE FF FF DB 6C 24 0C D9 C9 83 C4 2C C3 }
	condition:
		$1
}

rule file_389_14_0 {
	meta:
		name = "label12"
		size = 28
	strings:
		$1 = { D9 C9 DB 7C 24 0C D9 C0 DB 3C 24 DB 7C 24 20 E8 5E FE FF FF DB 6C 24 20 83 C4 2C C3 }
	condition:
		$1
}

rule file_389_15_0 {
	meta:
		name = "label13"
		size = 16
	strings:
		$1 = { DB 3C 24 DB 7C 24 0C E8 4A FE FF FF 83 C4 2C C3 }
	condition:
		$1
}

rule file_389_16_0 {
	meta:
		name = "label14"
		size = 20
	strings:
		$1 = { DB 7C 24 0C DB 3C 24 E8 3A FE FF FF DB 6C 24 0C 83 C4 2C C3 }
	condition:
		$1
}

rule file_389_17_0 {
	meta:
		name = "label15"
		size = 16
	strings:
		$1 = { DB 7C 24 0C DB 3C 24 E8 26 FE FF FF 83 C4 2C C3 }
	condition:
		$1
}

rule file_389_18_0 {
	meta:
		name = "label16"
		size = 32
	strings:
		$1 = { DB 7C 24 0C D9 C9 D9 C0 DB 3C 24 DB 7C 24 20 E8 0E FE FF FF D9 C9 DB 6C 24 20 D9 CA 83 C4 2C C3 }
	condition:
		$1
}

rule file_389_20_0 {
	meta:
		name = "label18"
		size = 26
	strings:
		$1 = { DB 3C 24 D9 C9 DB 7C 24 0C E8 EF FD FF FF D9 C9 DB 6C 24 0C D9 CA 83 C4 2C C3 }
	condition:
		$1
}

rule file_389_22_0 {
	meta:
		name = "label20"
		size = 32
	strings:
		$1 = { D9 CA DB 7C 24 0C D9 C9 D9 C0 DB 3C 24 DB 7C 24 20 E8 C8 FD FF FF D9 C9 DB 6C 24 20 83 C4 2C C3 }
	condition:
		$1
}

rule file_389_23_0 {
	meta:
		name = "label21"
		size = 20
	strings:
		$1 = { DB 3C 24 D9 C9 DB 7C 24 0C E8 B0 FD FF FF D9 C9 83 C4 2C C3 }
	condition:
		$1
}

rule file_389_24_0 {
	meta:
		name = "label22"
		size = 24
	strings:
		$1 = { DB 7C 24 0C D9 C9 DB 3C 24 E8 9C FD FF FF D9 C9 DB 6C 24 0C 83 C4 2C C3 }
	condition:
		$1
}

rule file_389_25_0 {
	meta:
		name = "label23"
		size = 20
	strings:
		$1 = { DB 7C 24 0C D9 C9 DB 3C 24 E8 84 FD FF FF D9 C9 83 C4 2C C3 }
	condition:
		$1
}

rule file_389_26_0 {
	meta:
		name = "label24"
		size = 32
	strings:
		$1 = { DB 7C 24 0C D9 CA D9 C0 DB 3C 24 DB 7C 24 20 E8 6A FD FF FF D9 CA DB 6C 24 20 D9 CB 83 C4 2C C3 }
	condition:
		$1
}

rule file_389_28_0 {
	meta:
		name = "label26"
		size = 26
	strings:
		$1 = { DB 3C 24 D9 CA DB 7C 24 0C E8 4B FD FF FF D9 CA DB 6C 24 0C D9 CB 83 C4 2C C3 }
	condition:
		$1
}

rule file_389_30_0 {
	meta:
		name = "label28"
		size = 32
	strings:
		$1 = { D9 CB DB 7C 24 0C D9 CA D9 C0 DB 3C 24 DB 7C 24 20 E8 24 FD FF FF D9 CA DB 6C 24 20 83 C4 2C C3 }
	condition:
		$1
}

rule file_389_31_0 {
	meta:
		name = "label29"
		size = 20
	strings:
		$1 = { DB 3C 24 D9 CA DB 7C 24 0C E8 0C FD FF FF D9 CA 83 C4 2C C3 }
	condition:
		$1
}

rule file_389_32_0 {
	meta:
		name = "label30"
		size = 24
	strings:
		$1 = { DB 7C 24 0C D9 CA DB 3C 24 E8 F8 FC FF FF D9 CA DB 6C 24 0C 83 C4 2C C3 }
	condition:
		$1
}

rule file_389_33_0 {
	meta:
		name = "label31"
		size = 20
	strings:
		$1 = { DB 7C 24 0C D9 CA DB 3C 24 E8 E0 FC FF FF D9 CA 83 C4 2C C3 }
	condition:
		$1
}

rule file_389_34_0 {
	meta:
		name = "label32"
		size = 32
	strings:
		$1 = { DB 7C 24 0C D9 CB D9 C0 DB 3C 24 DB 7C 24 20 E8 C6 FC FF FF D9 CB DB 6C 24 20 D9 CC 83 C4 2C C3 }
	condition:
		$1
}

rule file_389_36_0 {
	meta:
		name = "label34"
		size = 26
	strings:
		$1 = { DB 3C 24 D9 CB DB 7C 24 0C E8 A7 FC FF FF D9 CB DB 6C 24 0C D9 CC 83 C4 2C C3 }
	condition:
		$1
}

rule file_389_38_0 {
	meta:
		name = "label36"
		size = 32
	strings:
		$1 = { D9 CC DB 7C 24 0C D9 CB D9 C0 DB 3C 24 DB 7C 24 20 E8 80 FC FF FF D9 CB DB 6C 24 20 83 C4 2C C3 }
	condition:
		$1
}

rule file_389_39_0 {
	meta:
		name = "label37"
		size = 20
	strings:
		$1 = { DB 3C 24 D9 CB DB 7C 24 0C E8 68 FC FF FF D9 CB 83 C4 2C C3 }
	condition:
		$1
}

rule file_389_40_0 {
	meta:
		name = "label38"
		size = 24
	strings:
		$1 = { DB 7C 24 0C D9 CB DB 3C 24 E8 54 FC FF FF D9 CB DB 6C 24 0C 83 C4 2C C3 }
	condition:
		$1
}

rule file_389_41_0 {
	meta:
		name = "label39"
		size = 20
	strings:
		$1 = { DB 7C 24 0C D9 CB DB 3C 24 E8 3C FC FF FF D9 CB 83 C4 2C C3 }
	condition:
		$1
}

rule file_389_42_0 {
	meta:
		name = "label40"
		size = 32
	strings:
		$1 = { DB 7C 24 0C D9 CC D9 C0 DB 3C 24 DB 7C 24 20 E8 22 FC FF FF D9 CC DB 6C 24 20 D9 CD 83 C4 2C C3 }
	condition:
		$1
}

rule file_389_44_0 {
	meta:
		name = "label42"
		size = 26
	strings:
		$1 = { DB 3C 24 D9 CC DB 7C 24 0C E8 03 FC FF FF D9 CC DB 6C 24 0C D9 CD 83 C4 2C C3 }
	condition:
		$1
}

rule file_389_46_0 {
	meta:
		name = "label44"
		size = 32
	strings:
		$1 = { D9 CD DB 7C 24 0C D9 CC D9 C0 DB 3C 24 DB 7C 24 20 E8 DC FB FF FF D9 CC DB 6C 24 20 83 C4 2C C3 }
	condition:
		$1
}

rule file_389_47_0 {
	meta:
		name = "label45"
		size = 20
	strings:
		$1 = { DB 3C 24 D9 CC DB 7C 24 0C E8 C4 FB FF FF D9 CC 83 C4 2C C3 }
	condition:
		$1
}

rule file_389_48_0 {
	meta:
		name = "label46"
		size = 24
	strings:
		$1 = { DB 7C 24 0C D9 CC DB 3C 24 E8 B0 FB FF FF D9 CC DB 6C 24 0C 83 C4 2C C3 }
	condition:
		$1
}

rule file_389_49_0 {
	meta:
		name = "label47"
		size = 20
	strings:
		$1 = { DB 7C 24 0C D9 CC DB 3C 24 E8 98 FB FF FF D9 CC 83 C4 2C C3 }
	condition:
		$1
}

rule file_389_50_0 {
	meta:
		name = "label48"
		size = 32
	strings:
		$1 = { DB 7C 24 0C D9 CD D9 C0 DB 3C 24 DB 7C 24 20 E8 7E FB FF FF D9 CD DB 6C 24 20 D9 CE 83 C4 2C C3 }
	condition:
		$1
}

rule file_389_52_0 {
	meta:
		name = "label50"
		size = 26
	strings:
		$1 = { DB 3C 24 D9 CD DB 7C 24 0C E8 5F FB FF FF D9 CD DB 6C 24 0C D9 CE 83 C4 2C C3 }
	condition:
		$1
}

rule file_389_54_0 {
	meta:
		name = "label52"
		size = 32
	strings:
		$1 = { D9 CE DB 7C 24 0C D9 CD D9 C0 DB 3C 24 DB 7C 24 20 E8 38 FB FF FF D9 CD DB 6C 24 20 83 C4 2C C3 }
	condition:
		$1
}

rule file_389_55_0 {
	meta:
		name = "label53"
		size = 20
	strings:
		$1 = { DB 3C 24 D9 CD DB 7C 24 0C E8 20 FB FF FF D9 CD 83 C4 2C C3 }
	condition:
		$1
}

rule file_389_56_0 {
	meta:
		name = "label54"
		size = 24
	strings:
		$1 = { DB 7C 24 0C D9 CD DB 3C 24 E8 0C FB FF FF D9 CD DB 6C 24 0C 83 C4 2C C3 }
	condition:
		$1
}

rule file_389_57_0 {
	meta:
		name = "label55"
		size = 20
	strings:
		$1 = { DB 7C 24 0C D9 CD DB 3C 24 E8 F4 FA FF FF D9 CD 83 C4 2C C3 }
	condition:
		$1
}

rule file_389_58_0 {
	meta:
		name = "label56"
		size = 32
	strings:
		$1 = { DB 7C 24 0C D9 CE D9 C0 DB 3C 24 DB 7C 24 20 E8 DA FA FF FF D9 CE DB 6C 24 20 D9 CF 83 C4 2C C3 }
	condition:
		$1
}

rule file_389_60_0 {
	meta:
		name = "label58"
		size = 26
	strings:
		$1 = { DB 3C 24 D9 CE DB 7C 24 0C E8 BB FA FF FF D9 CE DB 6C 24 0C D9 CF 83 C4 2C C3 }
	condition:
		$1
}

rule file_389_62_0 {
	meta:
		name = "label60"
		size = 32
	strings:
		$1 = { D9 CF DB 7C 24 0C D9 CE D9 C0 DB 3C 24 DB 7C 24 20 E8 94 FA FF FF D9 CE DB 6C 24 20 83 C4 2C C3 }
	condition:
		$1
}

rule file_389_63_0 {
	meta:
		name = "label61"
		size = 20
	strings:
		$1 = { DB 3C 24 D9 CE DB 7C 24 0C E8 7C FA FF FF D9 CE 83 C4 2C C3 }
	condition:
		$1
}

rule file_389_64_0 {
	meta:
		name = "label62"
		size = 24
	strings:
		$1 = { DB 7C 24 0C D9 CE DB 3C 24 E8 68 FA FF FF D9 CE DB 6C 24 0C 83 C4 2C C3 }
	condition:
		$1
}

rule file_389_65_0 {
	meta:
		name = "label63"
		size = 20
	strings:
		$1 = { DB 7C 24 0C D9 CE DB 3C 24 E8 50 FA FF FF D9 CE 83 C4 2C C3 }
	condition:
		$1
}

rule file_389_66_0 {
	meta:
		name = "__fdivp_sti_st"
		size = 19
	strings:
		$1 = { 83 EC 2C DB 3C 24 DB 7C 24 0C E8 3B FA FF FF 83 C4 2C C3 }
	condition:
		$1
}

rule file_389_67_0 {
	meta:
		name = "__fdivrp_sti_st"
		size = 19
	strings:
		$1 = { 83 EC 2C DB 7C 24 0C DB 3C 24 E8 28 FA FF FF 83 C4 2C C3 }
	condition:
		$1
}

rule file_389_68_0 {
	meta:
		name = "__adj_fdiv_m32"
		size = 76
	strings:
		$1 = { 50 8B 44 24 08 25 00 00 80 7F 3D 00 00 80 7F 74 33 DF E0 25 00 38 00 00 74 0D D9 44 24 08 E8 B7 FF FF FF 58 C2 04 00 D9 C9 83 EC 0C DB 3C 24 D9 44 24 14 E8 A2 FF FF FF DB 2C 24 D9 C9 83 C4 0C 58 C2 04 00 D8 74 24 08 58 C2 04 00 }
	condition:
		$1
}

rule file_389_69_0 {
	meta:
		name = "__adj_fdiv_m64"
		size = 76
	strings:
		$1 = { 50 8B 44 24 0C 25 00 00 F0 7F 3D 00 00 F0 7F 74 33 DF E0 25 00 38 00 00 74 0D DD 44 24 08 E8 6B FF FF FF 58 C2 08 00 D9 C9 83 EC 0C DB 3C 24 DD 44 24 14 E8 56 FF FF FF DB 2C 24 D9 C9 83 C4 0C 58 C2 08 00 DC 74 24 08 58 C2 08 00 }
	condition:
		$1
}

rule file_389_70_0 {
	meta:
		name = "__adj_fdiv_m16i"
		size = 52
	strings:
		$1 = { 50 DF E0 25 00 38 00 00 74 0D DF 44 24 08 E8 2F FF FF FF 58 C2 04 00 D9 C9 83 EC 0C DB 3C 24 DF 44 24 14 E8 1A FF FF FF DB 2C 24 D9 C9 83 C4 0C 58 C2 04 00 }
	condition:
		$1
}

rule file_389_71_0 {
	meta:
		name = "__adj_fdiv_m32i"
		size = 52
	strings:
		$1 = { 50 DF E0 25 00 38 00 00 74 0D DB 44 24 08 E8 FB FE FF FF 58 C2 04 00 D9 C9 83 EC 0C DB 3C 24 DB 44 24 14 E8 E6 FE FF FF DB 2C 24 D9 C9 83 C4 0C 58 C2 04 00 }
	condition:
		$1
}

rule file_389_72_0 {
	meta:
		name = "__adj_fdivr_m32"
		size = 76
	strings:
		$1 = { 50 8B 44 24 08 25 00 00 80 7F 3D 00 00 80 7F 74 33 DF E0 25 00 38 00 00 74 0D D9 44 24 08 E8 CA FE FF FF 58 C2 04 00 D9 C9 83 EC 0C DB 3C 24 D9 44 24 14 E8 B5 FE FF FF DB 2C 24 D9 C9 83 C4 0C 58 C2 04 00 D8 7C 24 08 58 C2 04 00 }
	condition:
		$1
}

rule file_389_73_0 {
	meta:
		name = "__adj_fdivr_m64"
		size = 76
	strings:
		$1 = { 50 8B 44 24 0C 25 00 00 F0 7F 3D 00 00 F0 7F 74 33 DF E0 25 00 38 00 00 74 0D DD 44 24 08 E8 7E FE FF FF 58 C2 08 00 D9 C9 83 EC 0C DB 3C 24 DD 44 24 14 E8 69 FE FF FF DB 2C 24 D9 C9 83 C4 0C 58 C2 08 00 DC 7C 24 08 58 C2 08 00 }
	condition:
		$1
}

rule file_389_74_0 {
	meta:
		name = "__adj_fdivr_m16i"
		size = 52
	strings:
		$1 = { 50 DF E0 25 00 38 00 00 74 0D DF 44 24 08 E8 42 FE FF FF 58 C2 04 00 D9 C9 83 EC 0C DB 3C 24 DF 44 24 14 E8 2D FE FF FF DB 2C 24 D9 C9 83 C4 0C 58 C2 04 00 }
	condition:
		$1
}

rule file_389_75_0 {
	meta:
		name = "__adj_fdivr_m32i"
		size = 52
	strings:
		$1 = { 50 DF E0 25 00 38 00 00 74 0D DB 44 24 08 E8 0E FE FF FF 58 C2 04 00 D9 C9 83 EC 0C DB 3C 24 DB 44 24 14 E8 F9 FD FF FF DB 2C 24 D9 C9 83 C4 0C 58 C2 04 00 }
	condition:
		$1
}

rule file_389_76_0 {
	meta:
		name = "__safe_fdiv"
		size = 21
	strings:
		$1 = { 50 83 EC 2C DB 3C 24 DB 7C 24 0C E8 14 F8 FF FF 83 C4 2C 58 C3 }
	condition:
		$1
}

rule file_389_77_0 {
	meta:
		name = "__safe_fdivr"
		size = 21
	strings:
		$1 = { 50 83 EC 2C DB 7C 24 0C DB 3C 24 E8 FF F7 FF FF 83 C4 2C 58 C3 }
	condition:
		$1
}

rule file_389_78_0 {
	meta:
		name = "__fprem_common"
		size = 518
		refs = "001f fprem_risc_table 0163 half 017e big_number 01cf one_shr_64"
	strings:
		$1 = { 50 53 51 8B 44 24 16 35 00 07 00 00 A9 00 07 00 00 0F 85 83 01 00 00 C1 E8 0B 83 E0 0F 80 B8 ?? ?? ?? ?? 00 0F 84 70 01 00 00 8B 44 24 16 25 00 00 FF 7F 3D 00 00 FF 7F 0F 84 5C 01 00 00 8B 44 24 2E 25 00 00 FF 7F 0F 84 4D 01 00 00 3D 00 00 FF 7F 0F 84 42 01 00 00 8B 44 24 2C 03 C0 0F 85 36 01 00 00 8B 44 24 14 03 C0 0F 85 2A 01 00 00 8B 44 24 18 25 FF 7F 00 00 83 C0 3F 8B 5C 24 30 81 E3 FF 7F 00 00 2B D8 77 5E 8B 44 24 18 25 FF 7F 00 00 83 C0 0A 8B 5C 24 30 81 E3 FF 7F 00 00 2B D8 0F 88 F2 00 00 00 DB 6C 24 28 8B 44 24 18 8B 5C 24 30 81 E3 FF 7F 00 00 8B CB 2B D8 83 E3 07 83 CB 04 2B CB 8B D8 81 E3 00 80 00 00 0B CB 89 4C 24 18 DB 6C 24 10 89 44 24 18 D9 C9 D9 F8 DB 7C 24 28 DD D8 EB A2 F7 C2 02 00 00 00 75 08 DB 6C 24 10 DB 7C 24 1C D9 7C 24 34 8B 44 24 34 0D 3F 03 00 00 89 44 24 38 D9 6C 24 38 8B 44 24 18 25 FF 7F 00 00 8B 5C 24 30 81 E3 FF 7F 00 00 2B D8 83 E3 3F 83 CB 20 83 C3 01 8B CB 8B 44 24 18 8B 5C 24 30 81 E3 FF 7F 00 00 25 00 80 00 00 0B D8 89 5C 24 18 DB 6C 24 10 D9 E1 DB 6C 24 28 D9 E1 D8 D1 DF E0 25 00 01 00 00 75 02 D8 E1 D9 C9 DC 0D ?? ?? ?? ?? D9 C9 83 E9 01 75 E4 8B 5C 24 30 DB 7C 24 28 DD D8 DB 6C 24 1C DB 2D ?? ?? ?? ?? D9 F8 DD D8 DB 6C 24 28 D9 6C 24 34 81 E3 00 80 00 00 74 0E D9 E0 EB 0A DB 6C 24 10 DB 6C 24 28 D9 F8 F7 C2 03 00 00 00 74 56 DD 7C 24 3C F7 C2 01 00 00 00 74 1F D9 7C 24 34 8B 44 24 34 0D 00 03 00 00 89 44 24 38 D9 6C 24 38 DC 0D ?? ?? ?? ?? D9 6C 24 34 8B 44 24 3C D9 C9 DD D8 DB 6C 24 1C D9 C9 25 00 43 00 00 83 EC 1C D9 34 24 81 64 24 04 FF BC 00 00 09 44 24 04 D9 24 24 83 C4 1C 59 5B 58 C3 }
	condition:
		$1
}

rule file_389_79_0 {
	meta:
		name = "__adj_fprem"
		size = 178
		refs = "006a one_shl_64"
	strings:
		$1 = { 52 83 EC 30 DB 7C 24 18 DB 3C 24 33 D2 8B 44 24 06 A9 00 00 FF 7F 74 0A E8 DD FD FF FF 83 C4 30 5A C3 DB 2C 24 DB 6C 24 18 8B 04 24 0B 44 24 04 74 79 D9 C9 DB 7C 24 0C DB 2C 24 D9 C9 83 CA 02 D9 7C 24 24 8B 44 24 24 0D 3F 03 00 00 89 44 24 28 D9 6C 24 28 8B 44 24 20 25 FF 7F 00 00 3D BE 7F 00 00 77 18 83 CA 01 DC 0D ?? ?? ?? ?? DB 7C 24 18 DC 0D ?? ?? ?? ?? DB 3C 24 EB 20 D9 7C 24 24 8B 44 24 24 0D 00 03 00 00 89 44 24 28 D9 6C 24 28 DD D8 DC 0D ?? ?? ?? ?? DB 3C 24 D9 6C 24 24 E8 54 FD FF FF 83 C4 30 5A C3 D9 F8 83 C4 30 5A C3 }
	condition:
		$1
}

rule file_389_80_0 {
	meta:
		name = "__fprem1_common"
		size = 518
		refs = "001f fprem_risc_table 0163 half 017e big_number 01cf one_shr_64"
	strings:
		$1 = { 50 53 51 8B 44 24 16 35 00 07 00 00 A9 00 07 00 00 0F 85 83 01 00 00 C1 E8 0B 83 E0 0F 80 B8 ?? ?? ?? ?? 00 0F 84 70 01 00 00 8B 44 24 16 25 00 00 FF 7F 3D 00 00 FF 7F 0F 84 5C 01 00 00 8B 44 24 2E 25 00 00 FF 7F 0F 84 4D 01 00 00 3D 00 00 FF 7F 0F 84 42 01 00 00 8B 44 24 2C 03 C0 0F 85 36 01 00 00 8B 44 24 14 03 C0 0F 85 2A 01 00 00 8B 44 24 18 25 FF 7F 00 00 83 C0 3F 8B 5C 24 30 81 E3 FF 7F 00 00 2B D8 77 5E 8B 44 24 18 25 FF 7F 00 00 83 C0 0A 8B 5C 24 30 81 E3 FF 7F 00 00 2B D8 0F 88 F2 00 00 00 DB 6C 24 28 8B 44 24 18 8B 5C 24 30 81 E3 FF 7F 00 00 8B CB 2B D8 83 E3 07 83 CB 04 2B CB 8B D8 81 E3 00 80 00 00 0B CB 89 4C 24 18 DB 6C 24 10 89 44 24 18 D9 C9 D9 F8 DB 7C 24 28 DD D8 EB A2 F7 C3 02 00 00 00 75 08 DB 6C 24 10 DB 7C 24 1C D9 7C 24 34 8B 44 24 34 0D 3F 03 00 00 89 44 24 38 D9 6C 24 38 8B 44 24 18 25 FF 7F 00 00 8B 5C 24 30 81 E3 FF 7F 00 00 2B D8 83 E3 3F 83 CB 20 83 C3 01 8B CB 8B 44 24 18 8B 5C 24 30 81 E3 FF 7F 00 00 25 00 80 00 00 0B D8 89 5C 24 18 DB 6C 24 10 D9 E1 DB 6C 24 28 D9 E1 D8 D1 DF E0 25 00 01 00 00 75 02 D8 E1 D9 C9 DC 0D ?? ?? ?? ?? D9 C9 83 E9 01 75 E4 8B 5C 24 30 DB 7C 24 28 DD D8 DB 6C 24 1C DB 2D ?? ?? ?? ?? D9 F5 DD D8 DB 6C 24 28 D9 6C 24 34 81 E3 00 80 00 00 74 0E D9 E0 EB 0A DB 6C 24 10 DB 6C 24 28 D9 F5 F7 C2 03 00 00 00 74 56 DD 7C 24 3C F7 C2 01 00 00 00 74 1F D9 7C 24 34 8B 44 24 34 0D 00 03 00 00 89 44 24 38 D9 6C 24 38 DC 0D ?? ?? ?? ?? D9 6C 24 34 8B 44 24 3C D9 C9 DD D8 DB 6C 24 1C D9 C9 25 00 43 00 00 83 EC 1C D9 34 24 81 64 24 04 FF BC 00 00 09 44 24 04 D9 24 24 83 C4 1C 59 5B 58 C3 }
	condition:
		$1
}

rule file_389_81_0 {
	meta:
		name = "__adj_fprem1"
		size = 181
		refs = "006d one_shl_64"
	strings:
		$1 = { 52 83 EC 30 DB 7C 24 18 DB 3C 24 BA 00 00 00 00 8B 44 24 06 A9 00 00 FF 7F 74 0A E8 DA FD FF FF 83 C4 30 5A C3 DB 2C 24 DB 6C 24 18 8B 04 24 0B 44 24 04 74 79 D9 C9 DB 7C 24 0C DB 2C 24 D9 C9 83 CA 02 D9 7C 24 24 8B 44 24 24 0D 3F 03 00 00 89 44 24 28 D9 6C 24 28 8B 44 24 20 25 FF 7F 00 00 3D BE 7F 00 00 77 18 83 CA 01 DC 0D ?? ?? ?? ?? DB 7C 24 18 DC 0D ?? ?? ?? ?? DB 3C 24 EB 20 D9 7C 24 24 8B 44 24 24 0D 00 03 00 00 89 44 24 28 D9 6C 24 28 DD D8 DC 0D ?? ?? ?? ?? DB 3C 24 D9 6C 24 24 E8 51 FD FF FF 83 C4 30 5A C3 D9 F8 83 C4 30 5A C3 }
	condition:
		$1
}

rule file_390_0_0 {
	meta:
		name = "_isleadbyte"
		size = 32
		refs = "000d __pctype"
	strings:
		$1 = { 55 8B EC 8B 45 08 25 FF 00 00 00 8B 0D ?? ?? ?? ?? 33 D2 66 8B 14 41 8B C2 25 00 80 00 00 5D C3 }
	condition:
		$1
}

rule file_390_2_0 {
	meta:
		name = "_iswupper"
		size = 20
		refs = "000b _iswctype"
	strings:
		$1 = { 55 8B EC 6A 01 66 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_390_3_0 {
	meta:
		name = "_iswlower"
		size = 20
		refs = "000b _iswctype"
	strings:
		$1 = { 55 8B EC 6A 02 66 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_390_4_0 {
	meta:
		name = "_iswdigit"
		size = 20
		refs = "000b _iswctype"
	strings:
		$1 = { 55 8B EC 6A 04 66 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_390_6_0 {
	meta:
		name = "_iswspace"
		size = 20
		refs = "000b _iswctype"
	strings:
		$1 = { 55 8B EC 6A 08 66 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_390_7_0 {
	meta:
		name = "_iswpunct"
		size = 20
		refs = "000b _iswctype"
	strings:
		$1 = { 55 8B EC 6A 10 66 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_390_11_0 {
	meta:
		name = "_iswcntrl"
		size = 20
		refs = "000b _iswctype"
	strings:
		$1 = { 55 8B EC 6A 20 66 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_390_12_0 {
	meta:
		name = "_iswascii"
		size = 22
	strings:
		$1 = { 55 8B EC 8B 45 08 25 FF FF 00 00 3D 80 00 00 00 1B C0 F7 D8 5D C3 }
	condition:
		$1
}

rule file_391_0_0 {
	meta:
		name = "__rt_probe_read4@4"
		size = 133
		refs = "0006 $T16356 000b __except_handler3 0011 __except_list"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 C4 EC 53 56 57 89 65 E8 C7 45 FC 00 00 00 00 8B 45 08 8B 08 89 4D DC C7 45 E4 01 00 00 00 C7 45 FC FF FF FF FF EB 2A 8B 55 EC 8B 02 8B 08 89 4D E0 8B 55 E0 33 C0 81 FA 05 00 00 C0 0F 94 C0 C3 8B 65 E8 C7 45 E4 00 00 00 00 C7 45 FC FF FF FF FF 8B 45 E4 8B 4D F0 64 89 0D ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_392_0_0 {
	meta:
		name = "__strnicoll"
		size = 125
		refs = "0010 ___lc_handle 0024 __strnicmp 002e ___lc_collate_cp 0050 ___crtCompareStringA 006c _errno"
	strings:
		$1 = { 55 8B EC 51 83 7D 10 00 75 04 33 C0 EB 6B 83 3D ?? ?? ?? ?? 00 75 16 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C EB 4C A1 ?? ?? ?? ?? 50 8B 4D 10 51 8B 55 0C 52 8B 45 10 50 8B 4D 08 51 68 01 10 00 00 8B 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 1C 89 45 FC 83 7D FC 00 75 02 EB 08 8B 45 FC 83 E8 02 EB 0F C7 05 ?? ?? ?? ?? 16 00 00 00 B8 FF FF FF 7F 8B E5 5D C3 }
	condition:
		$1
}

rule file_393_0_0 {
	meta:
		name = "_fsetpos"
		size = 29
		refs = "0014 __fseeki64"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 8B 48 04 51 8B 10 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_394_0_0 {
	meta:
		name = "__setmode"
		size = 252
		refs = "0009 __nhandle 001e ___pioinfo 0030 _errno"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 3B 05 ?? ?? ?? ?? 73 1F 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F 8B 04 8D ?? ?? ?? ?? 0F BE 4C D0 04 83 E1 01 85 C9 75 12 C7 05 ?? ?? ?? ?? 09 00 00 00 83 C8 FF E9 B8 00 00 00 8B 55 08 C1 FA 05 8B 45 08 83 E0 1F 8B 0C 95 ?? ?? ?? ?? 0F BE 54 C1 04 81 E2 80 00 00 00 89 55 FC 81 7D 0C 00 80 00 00 75 32 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F 8B 14 85 ?? ?? ?? ?? 8A 44 CA 04 24 7F 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F 8B 0C 8D ?? ?? ?? ?? 88 44 D1 04 EB 4B 81 7D 0C 00 40 00 00 75 33 8B 55 08 C1 FA 05 8B 45 08 83 E0 1F 8B 0C 95 ?? ?? ?? ?? 8A 54 C1 04 80 CA 80 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F 8B 04 85 ?? ?? ?? ?? 88 54 C8 04 EB 0F C7 05 ?? ?? ?? ?? 16 00 00 00 83 C8 FF EB 11 8B 45 FC F7 D8 1B C0 25 00 C0 FF FF 05 00 80 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_395_0_0 {
	meta:
		name = "__mbsnset"
		size = 412
		refs = "0015 ___ismbcodepage 0029 __strnset 008e __mbctype"
	strings:
		$1 = { 55 8B EC 83 EC 1C 8B 45 08 89 45 F0 C7 45 FC 00 00 00 00 83 3D ?? ?? ?? ?? 00 75 19 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C E9 63 01 00 00 8B 4D 0C C1 E9 08 88 4D F4 8B 55 F4 81 E2 FF 00 00 00 85 D2 0F 84 CF 00 00 00 8B 45 0C 25 FF 00 00 00 88 45 F8 8B 4D 10 8B 55 10 83 EA 01 89 55 10 85 C9 0F 84 AE 00 00 00 8B 45 08 33 C9 8A 08 85 C9 0F 84 9F 00 00 00 83 7D FC 00 75 1F 8B 55 08 33 C0 8A 02 33 C9 8A 88 ?? ?? ?? ?? 83 E1 04 85 C9 74 09 C7 45 EC 01 00 00 00 EB 07 C7 45 EC 00 00 00 00 8B 55 EC 89 55 FC 8B 45 08 8A 4D F4 88 08 8B 55 08 83 C2 01 89 55 08 8B 45 08 33 C9 8A 08 85 C9 74 45 83 7D FC 00 75 1F 8B 55 08 33 C0 8A 02 33 C9 8A 88 ?? ?? ?? ?? 83 E1 04 85 C9 74 09 C7 45 E8 01 00 00 00 EB 07 C7 45 E8 00 00 00 00 8B 55 E8 89 55 FC 8B 45 08 8A 4D F8 88 08 8B 55 08 83 C2 01 89 55 08 EB 07 8B 45 08 C6 40 FF 20 E9 3E FF FF FF EB 60 8B 4D 10 8B 55 10 83 EA 01 89 55 10 85 C9 74 50 8B 45 08 33 C9 8A 08 85 C9 74 45 83 7D FC 00 75 1F 8B 55 08 33 C0 8A 02 33 C9 8A 88 ?? ?? ?? ?? 83 E1 04 85 C9 74 09 C7 45 E4 01 00 00 00 EB 07 C7 45 E4 00 00 00 00 8B 55 E4 89 55 FC 8B 45 08 8A 4D 0C 88 08 8B 55 08 83 C2 01 89 55 08 EB A0 83 7D FC 00 74 11 8B 45 08 33 C9 8A 08 85 C9 74 06 8B 55 08 C6 02 20 8B 45 F0 8B E5 5D C3 }
	condition:
		$1
}

rule file_396_1_0 {
	meta:
		name = "__rotr"
		size = 80
	strings:
		$1 = { 55 8B EC 83 EC 08 8B 45 08 89 45 F8 8B 4D 0C 83 E1 1F 89 4D 0C 8B 55 0C 8B 45 0C 83 E8 01 89 45 0C 85 D2 74 24 8B 4D F8 83 E1 01 89 4D FC 8B 55 F8 D1 EA 89 55 F8 83 7D FC 00 74 0B 8B 45 F8 0D 00 00 00 80 89 45 F8 EB CC 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_397_0_0 {
	meta:
		name = "__ismbchira"
		size = 57
		refs = "0006 ___mbcodepage"
	strings:
		$1 = { 55 8B EC 51 81 3D ?? ?? ?? ?? A4 03 00 00 75 1B 81 7D 08 9F 82 00 00 72 12 81 7D 08 F1 82 00 00 77 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_397_1_0 {
	meta:
		name = "__ismbckata"
		size = 66
		refs = "0006 ___mbcodepage"
	strings:
		$1 = { 55 8B EC 51 81 3D ?? ?? ?? ?? A4 03 00 00 75 24 81 7D 08 40 83 00 00 72 1B 81 7D 08 96 83 00 00 77 12 81 7D 08 7F 83 00 00 74 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_397_2_0 {
	meta:
		name = "__ismbcsymbol"
		size = 66
		refs = "0006 ___mbcodepage"
	strings:
		$1 = { 55 8B EC 51 81 3D ?? ?? ?? ?? A4 03 00 00 75 24 81 7D 08 41 81 00 00 72 1B 81 7D 08 AC 81 00 00 77 12 81 7D 08 7F 81 00 00 74 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_398_0_0 {
	meta:
		name = "__fltinf"
		size = 225
		refs = "0026 ___strgtold12 005c __ld12tod 00a0 _flt"
	strings:
		$1 = { 55 8B EC 83 EC 24 C7 45 E0 00 00 00 00 6A 01 8B 45 14 50 8B 4D 10 51 6A 00 8B 55 08 52 8D 45 EC 50 8D 4D F0 51 E8 ?? ?? ?? ?? 83 C4 1C 89 45 FC 8B 55 FC 83 E2 04 85 D2 74 19 8B 45 E0 80 CC 02 89 45 E0 C7 45 E4 00 00 00 00 C7 45 E8 00 00 00 00 EB 45 8D 4D E4 51 8D 55 F0 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 DC 8B 45 FC 83 E0 02 85 C0 75 06 83 7D DC 01 75 09 8B 4D E0 80 C9 80 89 4D E0 8B 55 FC 83 E2 01 85 D2 75 06 83 7D DC 02 75 09 8B 45 E0 80 CC 01 89 45 E0 8B 4D EC 2B 4D 08 8B 15 ?? ?? ?? ?? 89 4A 04 A1 ?? ?? ?? ?? 8B 4D 0C 3B 48 04 74 09 8B 55 E0 83 CA 40 89 55 E0 A1 ?? ?? ?? ?? 8B 4D E4 89 48 10 8B 55 E8 89 50 14 A1 ?? ?? ?? ?? 8B 4D E0 89 08 A1 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_401_0_0 {
	meta:
		name = "_mktime"
		size = 19
		refs = "000a __make_time_t"
	strings:
		$1 = { 55 8B EC 6A 01 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_418_15_0 {
	meta:
		name = "__msize"
		size = 19
		refs = "000a __msize_dbg"
	strings:
		$1 = { 55 8B EC 6A 01 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_418_13_0 {
	meta:
		name = "_free"
		size = 19
		refs = "000a __free_dbg"
	strings:
		$1 = { 55 8B EC 6A 01 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_401_1_0 {
	meta:
		name = "__mkgmtime"
		size = 19
		refs = "000a __make_time_t"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_401_2_0 {
	meta:
		name = "__make_time_t"
		size = 777
		refs = "009f __days 0278 ___tzset 0281 __timezone 028d _localtime 02bf __dstbias 02dc _gmtime"
	strings:
		$1 = { 55 8B EC 83 EC 1C 56 57 8B 45 08 8B 48 14 89 4D F4 83 7D F4 45 7C 09 81 7D F4 8B 00 00 00 7E 05 E9 DB 02 00 00 8B 55 08 83 7A 10 00 7C 09 8B 45 08 83 78 10 0B 7E 5F 8B 4D 08 8B 41 10 99 B9 0C 00 00 00 F7 F9 8B 55 F4 03 D0 89 55 F4 8B 45 08 8B 40 10 99 B9 0C 00 00 00 F7 F9 8B 45 08 89 50 10 8B 4D 08 83 79 10 00 7D 18 8B 55 08 8B 42 10 83 C0 0C 8B 4D 08 89 41 10 8B 55 F4 83 EA 01 89 55 F4 83 7D F4 45 7C 09 81 7D F4 8B 00 00 00 7E 05 E9 6A 02 00 00 8B 45 08 8B 48 10 8B 14 8D ?? ?? ?? ?? 89 55 F0 8B 45 F4 83 E0 03 85 C0 75 12 8B 4D 08 83 79 10 01 7E 09 8B 55 F0 83 C2 01 89 55 F0 8B 45 F4 83 E8 46 69 C0 6D 01 00 00 8B 4D F4 83 E9 01 C1 F9 02 8D 54 08 EF 89 55 F8 8B 45 F8 03 45 F0 89 45 F8 8B 4D 08 8B 51 0C 89 55 F0 8B 45 F8 03 45 F0 89 45 F4 83 7D F8 00 7C 0C 83 7D F0 00 7C 06 83 7D F4 00 7C 12 83 7D F8 00 7D 11 83 7D F0 00 7D 0B 83 7D F4 00 7C 05 E9 DE 01 00 00 8B 4D F4 6B C9 18 89 4D F0 83 7D F4 00 74 14 8B 45 F0 99 F7 7D F4 33 D2 83 F8 18 0F 95 C2 89 55 EC EB 07 C7 45 EC 00 00 00 00 83 7D EC 00 74 05 E9 A9 01 00 00 8B 45 08 8B 48 08 89 4D F8 8B 55 F0 03 55 F8 89 55 F4 83 7D F0 00 7C 0C 83 7D F8 00 7C 06 83 7D F4 00 7C 12 83 7D F0 00 7D 11 83 7D F8 00 7D 0B 83 7D F4 00 7C 05 E9 6E 01 00 00 8B 45 F4 6B C0 3C 89 45 F0 83 7D F4 00 74 14 8B 45 F0 99 F7 7D F4 33 C9 83 F8 3C 0F 95 C1 89 4D E8 EB 07 C7 45 E8 00 00 00 00 83 7D E8 00 74 05 E9 39 01 00 00 8B 55 08 8B 42 04 89 45 F8 8B 4D F0 03 4D F8 89 4D F4 83 7D F0 00 7C 0C 83 7D F8 00 7C 06 83 7D F4 00 7C 12 83 7D F0 00 7D 11 83 7D F8 00 7D 0B 83 7D F4 00 7C 05 E9 FE 00 00 00 8B 55 F4 6B D2 3C 89 55 F0 83 7D F4 00 74 14 8B 45 F0 99 F7 7D F4 33 C9 83 F8 3C 0F 95 C1 89 4D E4 EB 07 C7 45 E4 00 00 00 00 83 7D E4 00 74 05 E9 C9 00 00 00 8B 55 08 8B 02 89 45 F8 8B 4D F0 03 4D F8 89 4D F4 83 7D F0 00 7C 0C 83 7D F8 00 7C 06 83 7D F4 00 7C 12 83 7D F0 00 7D 11 83 7D F8 00 7D 0B 83 7D F4 00 7C 05 E9 8F 00 00 00 83 7D 0C 00 74 60 E8 ?? ?? ?? ?? 8B 55 F4 03 15 ?? ?? ?? ?? 89 55 F4 8D 45 F4 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 83 7D FC 00 75 02 EB 61 8B 4D 08 83 79 20 00 7F 12 8B 55 08 83 7A 20 00 7D 24 8B 45 FC 83 78 20 00 7E 1B 8B 4D F4 03 0D ?? ?? ?? ?? 89 4D F4 8D 55 F4 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC EB 17 8D 45 F4 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 83 7D FC 00 75 02 EB 12 8B 75 FC B9 09 00 00 00 8B 7D 08 F3 A5 8B 45 F4 EB 03 83 C8 FF 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_402_3_0 {
	meta:
		name = "dstnext"
		size = 16
	strings:
		$1 = { 8A 06 0A C0 74 0A 46 0F A3 04 24 73 F3 8D 46 FF }
	condition:
		$1
}

rule file_403_0_0 {
	meta:
		name = "__wcsicoll"
		size = 106
		refs = "0006 ___lc_handle 0016 __wcsicmp 0021 ___lc_codepage 003f ___crtCompareStringW 0051 _errno"
	strings:
		$1 = { 55 8B EC 51 83 3D ?? ?? ?? ?? 00 75 12 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 EB 47 8B 15 ?? ?? ?? ?? 52 6A FF 8B 45 0C 50 6A FF 8B 4D 08 51 68 01 10 00 00 8B 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 1C 89 45 FC 83 7D FC 00 75 11 C7 05 ?? ?? ?? ?? 16 00 00 00 B8 FF FF FF 7F EB 06 8B 45 FC 83 E8 02 8B E5 5D C3 }
	condition:
		$1
}

rule file_404_0_0 {
	meta:
		name = "__mbstok"
		size = 267
		refs = "0006 ___ismbcodepage 0016 _strtok 002d _?nextoken@?1??_mbstok@@9@9 004f __mbsspnp 007c __mbctype 00a0 __mbspbrk"
	strings:
		$1 = { 55 8B EC 51 83 3D ?? ?? ?? ?? 00 75 15 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 E9 E5 00 00 00 83 7D 08 00 74 0B 8B 55 08 89 15 ?? ?? ?? ?? EB 10 83 3D ?? ?? ?? ?? 00 75 07 33 C0 E9 C4 00 00 00 8B 45 0C 50 8B 0D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 08 83 7D 08 00 75 07 33 C0 E9 A1 00 00 00 8B 55 08 33 C0 8A 02 85 C0 74 22 8B 4D 08 33 D2 8A 11 33 C0 8A 82 ?? ?? ?? ?? 83 E0 04 85 C0 74 10 8B 4D 08 33 D2 8A 51 01 85 D2 75 04 33 C0 EB 70 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 0B 8B 55 FC 33 C0 8A 02 85 C0 75 0C C7 05 ?? ?? ?? ?? 00 00 00 00 EB 3D 8B 4D FC 33 D2 8A 11 33 C0 8A 82 ?? ?? ?? ?? 83 E0 04 85 C0 74 0F 8B 4D FC C6 01 00 8B 55 FC 83 C2 01 89 55 FC 8B 45 FC C6 00 00 8B 4D FC 83 C1 01 89 4D FC 8B 55 FC 89 15 ?? ?? ?? ?? 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_405_0_0 {
	meta:
		name = "__execlpe"
		size = 238
		refs = "000e ??_C@_0BB@COCE@filename?5?$CB?$DN?5NULL?$AA@ 0017 ??_C@_09LJIK@execlpe?4c?$AA@ 001e __CrtDbgReport 003c ??_C@_0BG@GALO@?$CKfilename?5?$CB?$DN?5_T?$CI?8?20?8?$CJ?$AA@ 0066 ??_C@_0BA@BICO@arglist?5?$CB?$DN?5NULL?$AA@ 0094 ??_C@_0BF@GGKN@?$CKarglist?5?$CB?$DN?5_T?$CI?8?20?8?$CJ?$AA@ 00e0 __execvpe"
	strings:
		$1 = { 55 8B EC 51 53 56 57 83 7D 08 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 32 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D6 8B 4D 08 0F BE 11 85 D2 75 1E 68 ?? ?? ?? ?? 6A 00 6A 33 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D2 83 7D 0C 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 34 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D6 8B 55 0C 0F BE 02 85 C0 75 1E 68 ?? ?? ?? ?? 6A 00 6A 35 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D2 8D 55 0C 89 55 FC 8B 45 FC 8B 08 8B 55 FC 83 C2 04 89 55 FC 85 C9 74 02 EB EC 8B 45 FC 8B 08 51 8D 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_408_0_0 {
	meta:
		name = "_wcsncpy"
		size = 116
	strings:
		$1 = { 55 8B EC 51 8B 45 08 89 45 FC 83 7D 10 00 74 35 8B 4D 08 8B 55 0C 66 8B 02 66 89 01 8B 4D 08 33 D2 66 8B 11 8B 45 08 83 C0 02 89 45 08 8B 4D 0C 83 C1 02 89 4D 0C 85 D2 74 0B 8B 55 10 83 EA 01 89 55 10 EB C5 83 7D 10 00 74 22 8B 45 10 83 E8 01 89 45 10 83 7D 10 00 74 13 8B 4D 08 66 C7 01 00 00 8B 55 08 83 C2 02 89 55 08 EB DE 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_409_0_0 {
	meta:
		name = "_sscanf"
		size = 183
		refs = "001c ??_C@_0P@OOIN@string?5?$CB?$DN?5NULL?$AA@ 0025 ??_C@_08EJDA@sscanf?4c?$AA@ 002c __CrtDbgReport 0046 ??_C@_0P@LNLA@format?5?$CB?$DN?5NULL?$AA@ 0089 _strlen 00a3 __input"
	strings:
		$1 = { 55 8B EC 83 EC 2C 53 56 57 8D 45 E0 89 45 DC 8D 4D 10 89 4D D4 83 7D 08 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 42 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 D2 85 D2 75 D6 83 7D 0C 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 43 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D6 8B 4D DC C7 41 0C 49 00 00 00 8B 55 DC 8B 45 08 89 42 08 8B 4D DC 8B 55 08 89 11 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D DC 89 41 04 8B 55 D4 52 8B 45 0C 50 8B 4D DC 51 E8 ?? ?? ?? ?? 83 C4 0C 89 45 D8 8B 45 D8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_410_0_0 {
	meta:
		name = "_WinMainCRTStartup"
		size = 343
		refs = "0006 $T17385 000b __except_handler3 0011 __except_list 0028 __imp__GetVersion@0 002d __osver 003f __winminor 0051 __winmajor 0066 __winver 007f __heap_init 008d _fast_error_exit 009c __ioinit 00a2 __imp__GetCommandLineA@0 00a7 __acmdln 00ac ___crtGetEnvironmentStringsA 00b1 __aenvptr 00b6 __setargv 00bb __setenvp 00c0 __cinit 00d1 __imp__GetStartupInfoA@4 00d6 __wincmdln 0109 __imp__GetModuleHandleA@4 010f _WinMain@16 011b _exit 0132 __XcptFilter 0142 __exit"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 C4 A4 53 56 57 89 65 E8 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? C1 E8 08 25 FF 00 00 00 A3 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 81 E1 FF 00 00 00 89 0D ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? C1 E2 08 03 15 ?? ?? ?? ?? 89 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? C1 E8 10 25 FF FF 00 00 A3 ?? ?? ?? ?? 6A 00 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 0A 6A 1C E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 E8 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 45 D0 00 00 00 00 8D 4D A4 51 FF 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 9C 8B 55 D0 83 E2 01 85 D2 74 0D 8B 45 D4 25 FF FF 00 00 89 45 94 EB 07 C7 45 94 0A 00 00 00 8B 4D 94 51 8B 55 9C 52 6A 00 6A 00 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 89 45 A0 8B 45 A0 50 E8 ?? ?? ?? ?? 8B 4D EC 8B 11 8B 02 89 45 98 8B 4D EC 51 8B 55 98 52 E8 ?? ?? ?? ?? 83 C4 08 C3 8B 65 E8 8B 45 98 50 E8 ?? ?? ?? ?? 8B 4D F0 64 89 0D ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_411_0_0 {
	meta:
		name = "__wspawnlp"
		size = 211
		refs = "000d ??_C@_0BB@COCE@filename?5?$CB?$DN?5NULL?$AA@ 0016 ??_C@_09HGIN@spawnlp?4c?$AA@ 001d __CrtDbgReport 003d ??_C@_0BG@GALO@?$CKfilename?5?$CB?$DN?5_T?$CI?8?20?8?$CJ?$AA@ 0067 ??_C@_0BA@BICO@arglist?5?$CB?$DN?5NULL?$AA@ 0097 ??_C@_0BF@GGKN@?$CKarglist?5?$CB?$DN?5_T?$CI?8?20?8?$CJ?$AA@ 00c7 __wspawnvp"
	strings:
		$1 = { 55 8B EC 53 56 57 83 7D 0C 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 38 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D6 8B 4D 0C 33 D2 66 8B 11 85 D2 75 1E 68 ?? ?? ?? ?? 6A 00 6A 39 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D0 83 7D 10 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3A 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D6 8B 55 10 33 C0 66 8B 02 85 C0 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3B 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D0 8D 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_412_0_0 {
	meta:
		name = "__except_handler2"
		size = 174
		refs = "0057 __global_unwind2 0064 __local_unwind2"
	strings:
		$1 = { 55 8B EC 83 EC 08 53 56 57 55 FC 8B 5D 0C 8B 45 08 F7 40 04 06 00 00 00 75 77 89 45 F8 8B 45 10 89 45 FC 8D 45 F8 89 43 14 8B 73 0C 8B 7B 08 83 FE FF 74 56 8D 0C 76 83 7C 8F 04 00 74 3A 56 55 8B 6B 10 FF 54 8F 04 5D 5E 8B 5D 0C 0B C0 74 28 78 31 8B 7B 08 53 E8 ?? ?? ?? ?? 83 C4 04 8B 6B 10 56 53 E8 ?? ?? ?? ?? 83 C4 08 8D 0C 76 8B 04 8F 89 43 0C FF 54 8F 08 8B 7B 08 8D 0C 76 8B 34 8F EB AC B8 00 00 00 00 EB 1C B8 01 00 00 00 EB 15 55 8B 6B 10 6A FF 53 E8 ?? ?? ?? ?? 83 C4 08 5D B8 01 00 00 00 5D 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_413_0_0 {
	meta:
		name = "__ftime"
		size = 271
		refs = "000a ___tzset 000f __timezone 0028 __imp__GetSystemTimeAsFileTime@4 003c __aulldiv 0048 _elapsed_minutes_cache 0057 __imp__GetTimeZoneInformation@4 0088 _dstflag_cache 00dc __aullrem"
	strings:
		$1 = { 55 8B EC 81 EC BC 00 00 00 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 99 B9 3C 00 00 00 F7 F9 8B 55 08 66 89 42 06 8D 45 F4 50 FF 15 ?? ?? ?? ?? 6A 00 68 00 46 C3 23 8B 4D F8 51 8B 55 F4 52 E8 ?? ?? ?? ?? 89 45 FC 8B 45 FC 3B 05 ?? ?? ?? ?? 74 62 8D 8D 48 FF FF FF 51 FF 15 ?? ?? ?? ?? 89 85 44 FF FF FF 83 BD 44 FF FF FF FF 74 34 83 BD 44 FF FF FF 02 75 1F 8B 55 E2 81 E2 FF FF 00 00 85 D2 74 12 83 7D F0 00 74 0C C7 05 ?? ?? ?? ?? 01 00 00 00 EB 0A C7 05 ?? ?? ?? ?? 00 00 00 00 EB 0A C7 05 ?? ?? ?? ?? FF FF FF FF 8B 45 FC A3 ?? ?? ?? ?? 8B 4D 08 66 8B 15 ?? ?? ?? ?? 66 89 51 08 6A 00 68 10 27 00 00 8B 45 F8 50 8B 4D F4 51 E8 ?? ?? ?? ?? 6A 00 68 E8 03 00 00 52 50 E8 ?? ?? ?? ?? 8B 55 08 66 89 42 04 8B 45 F4 2D 00 80 3E D5 8B 4D F8 81 D9 DE B1 9D 01 6A 00 68 80 96 98 00 51 50 E8 ?? ?? ?? ?? 8B 55 08 89 02 8B E5 5D C3 }
	condition:
		$1
}

rule file_414_0_0 {
	meta:
		name = "__winput"
		size = 5646
		refs = "0009 __chkstk 0017 ??_C@_0P@LNLA@format?5?$CB?$DN?5NULL?$AA@ 0023 ??_C@_07IEFA@input?4c?$AA@ 002a __CrtDbgReport 0044 ??_C@_0P@FHEA@stream?5?$CB?$DN?5NULL?$AA@ 0095 _iswctype 00b6 __whiteout 00bf __un_inc 00d7 _iswspace 0191 ___mb_cur_max 01ab __isctype 01ca __pctype 023c $L2160 0243 $L2161 0387 __inc 03d7 $L2162 03de $L2163 0420 _cbrackset 044b _sbrackset 04b9 _memset 078d _wctomb 0a7e __allshl 0a91 __hextodec 1044 ___decimal_point 104d _mbtowc 139c __malloc_dbg 13bf _wcstombs 13db __cfltcvt_tab 13ec __free_dbg 155f $L1891 1563 $L1883 1567 $L1885 156b $L1888 156f $L1884 1573 $L1889 1577 $L1890 157b $DEFAULT_LABEL$1887 15cd $L1914 15d1 $L1984 15d5 $L2052 15d9 $L1966 15dd $L2050 15e1 $L1983 15e5 $L1918 15e9 $L1967 15ed $L1920 15f1 $L2086"
	strings:
		$1 = { 55 8B EC B8 64 23 00 00 E8 ?? ?? ?? ?? 53 56 57 83 7D 0C 00 75 21 68 ?? ?? ?? ?? 6A 00 68 09 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D3 83 7D 08 00 75 21 68 ?? ?? ?? ?? 6A 00 68 0C 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D3 C6 45 DC 00 0F BE 55 DC 89 55 E4 8B 45 E4 89 45 C8 8B 4D 0C 33 D2 66 8B 11 85 D2 0F 84 8E 14 00 00 6A 08 8B 45 0C 66 8B 08 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 44 8B 55 E4 83 EA 01 89 55 E4 8B 45 08 50 8B 4D 08 51 8D 55 E4 52 E8 ?? ?? ?? ?? 83 C4 08 50 E8 ?? ?? ?? ?? 83 C4 08 8B 45 0C 83 C0 02 89 45 0C 8B 4D 0C 66 8B 11 52 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 02 EB E2 8B 45 0C 33 C9 66 8B 08 83 F9 25 0F 85 94 13 00 00 C7 45 BC 00 00 00 00 66 C7 45 FC 00 00 C7 85 B0 DF FF FF 00 00 00 00 8B 95 B0 DF FF FF 89 95 D8 DC FF FF 8B 85 D8 DC FF FF 89 45 E8 C6 45 F4 00 8A 4D F4 88 8D B4 DF FF FF 8A 95 B4 DF FF FF 88 95 AC DF FF FF 8A 85 AC DF FF FF 88 45 EC 8A 4D EC 88 8D B8 DF FF FF C6 45 F0 00 C6 45 C4 01 C7 85 E4 DC FF FF 00 00 00 00 0F BE 55 EC 85 D2 0F 85 77 01 00 00 8B 45 0C 83 C0 02 89 45 0C 8B 4D 0C 33 D2 66 8B 11 89 55 F8 8B 45 F8 25 FF FF 00 00 25 00 FF 00 00 85 C0 75 7E 83 3D ?? ?? ?? ?? 01 7E 22 6A 04 8B 4D F8 81 E1 FF FF 00 00 81 E1 FF 00 00 00 51 E8 ?? ?? ?? ?? 83 C4 08 89 85 C4 DC FF FF EB 23 8B 55 F8 81 E2 FF FF 00 00 81 E2 FF 00 00 00 A1 ?? ?? ?? ?? 33 C9 66 8B 0C 50 83 E1 04 89 8D C4 DC FF FF 83 BD C4 DC FF FF 00 74 27 8B 95 D8 DC FF FF 83 C2 01 89 95 D8 DC FF FF 8B 45 E8 8B 4D E8 8D 14 81 8B 45 F8 8D 4C 50 D0 89 4D E8 E9 CF 00 00 00 8B 55 F8 89 95 C0 DC FF FF 8B 85 C0 DC FF FF 83 E8 2A 89 85 C0 DC FF FF 83 BD C0 DC FF FF 4D 0F 87 A2 00 00 00 8B 95 C0 DC FF FF 33 C9 8A 8A ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? E9 90 00 00 00 8A 45 C4 2C 01 88 45 C4 8A 4D F0 80 E9 01 88 4D F0 EB 7D 8B 55 0C 33 C0 66 8B 42 02 83 F8 36 75 36 8B 4D 0C 33 D2 66 8B 51 04 83 FA 34 75 28 8B 45 0C 83 C0 04 89 45 0C 8B 8D E4 DC FF FF 83 C1 01 89 8D E4 DC FF FF C7 45 D4 00 00 00 00 C7 45 D8 00 00 00 00 EB 39 EB 2F 8A 55 C4 80 C2 01 88 55 C4 EB 2C 8A 45 C4 04 01 88 45 C4 8A 4D F0 80 C1 01 88 4D F0 EB 19 8A 95 AC DF FF FF 80 C2 01 88 95 AC DF FF FF EB 08 8A 45 EC 04 01 88 45 EC E9 7D FE FF FF 0F BE 8D AC DF FF FF 85 C9 75 1B 8B 55 10 89 95 EC DC FF FF 8B 45 10 83 C0 04 89 45 10 8B 4D 10 8B 51 FC 89 55 C0 C6 45 EC 00 0F BE 45 F0 85 C0 75 2D 8B 4D 0C 33 D2 66 8B 11 83 FA 53 74 0D 8B 45 0C 33 C9 66 8B 08 83 F9 43 75 0B 8A 55 F0 80 EA 01 88 55 F0 EB 08 8A 45 F0 04 01 88 45 F0 8B 4D 0C 33 D2 66 8B 11 83 CA 20 89 55 F8 83 7D F8 6E 74 41 83 7D F8 63 74 1F 83 7D F8 7B 74 19 8B 45 08 50 8D 4D E4 51 E8 ?? ?? ?? ?? 83 C4 08 66 89 85 E8 DC FF FF EB 1C 8B 55 E4 83 C2 01 89 55 E4 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 66 89 85 E8 DC FF FF 83 BD D8 DC FF FF 00 74 0A 83 7D E8 00 0F 84 B4 10 00 00 8B 4D F8 89 8D BC DC FF FF 8B 95 BC DC FF FF 83 EA 63 89 95 BC DC FF FF 83 BD BC DC FF FF 18 0F 87 2F 10 00 00 8B 8D BC DC FF FF 33 C0 8A 81 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 83 BD D8 DC FF FF 00 75 18 8B 95 D8 DC FF FF 83 C2 01 89 95 D8 DC FF FF 8B 45 E8 83 C0 01 89 45 E8 0F BE 4D F0 85 C9 7E 0F 8A 95 B8 DF FF FF 80 C2 01 88 95 B8 DF FF FF C7 85 E0 DC FF FF ?? ?? ?? ?? 8A 45 F4 2C 01 88 45 F4 EB 7C 0F BE 4D F0 85 C9 7E 0F 8A 95 B8 DF FF FF 80 C2 01 88 95 B8 DF FF FF C7 85 E0 DC FF FF ?? ?? ?? ?? 8A 45 F4 2C 01 88 45 F4 EB 51 0F BE 4D F0 85 C9 7E 0F 8A 95 B8 DF FF FF 80 C2 01 88 95 B8 DF FF FF 8B 45 0C 83 C0 02 89 45 0C 8B 4D 0C 89 8D E0 DC FF FF 8B 95 E0 DC FF FF 33 C0 66 8B 02 83 F8 5E 75 18 8B 8D E0 DC FF FF 83 C1 02 89 8D E0 DC FF FF 8A 55 F4 80 EA 01 88 55 F4 68 00 20 00 00 6A 00 8D 85 BC DF FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 83 7D F8 7B 75 2C 8B 8D E0 DC FF FF 33 D2 66 8B 11 83 FA 5D 75 1C 66 C7 45 FC 5D 00 8B 85 E0 DC FF FF 83 C0 02 89 85 E0 DC FF FF C6 85 C7 DF FF FF 20 8B 8D E0 DC FF FF 33 D2 66 8B 11 83 FA 5D 0F 84 79 01 00 00 8B 85 E0 DC FF FF 66 8B 08 66 89 8D D4 DC FF FF 8B 95 E0 DC FF FF 83 C2 02 89 95 E0 DC FF FF 8B 85 D4 DC FF FF 25 FF FF 00 00 83 F8 2D 75 1D 8B 4D FC 81 E1 FF FF 00 00 85 C9 74 10 8B 95 E0 DC FF FF 33 C0 66 8B 02 83 F8 5D 75 4E 66 8B 8D D4 DC FF FF 66 89 4D FC 8B 55 FC 81 E2 FF FF 00 00 C1 FA 03 8B 8D D4 DC FF FF 81 E1 FF FF 00 00 83 E1 07 B8 01 00 00 00 D3 E0 8A 8C 15 BC DF FF FF 0A C8 8B 55 FC 81 E2 FF FF 00 00 C1 FA 03 88 8C 15 BC DF FF FF E9 DA 00 00 00 8B 85 E0 DC FF FF 66 8B 08 66 89 8D D4 DC FF FF 8B 95 E0 DC FF FF 83 C2 02 89 95 E0 DC FF FF 8B 45 FC 25 FF FF 00 00 8B 8D D4 DC FF FF 81 E1 FF FF 00 00 3B C1 7D 0D 66 8B 95 D4 DC FF FF 66 89 55 E0 EB 13 66 8B 45 FC 66 89 45 E0 66 8B 8D D4 DC FF FF 66 89 4D FC 66 8B 55 FC 66 89 95 D4 DC FF FF EB 12 66 8B 85 D4 DC FF FF 66 05 01 00 66 89 85 D4 DC FF FF 8B 8D D4 DC FF FF 81 E1 FF FF 00 00 8B 55 E0 81 E2 FF FF 00 00 3B CA 7F 45 8B 85 D4 DC FF FF 25 FF FF 00 00 C1 F8 03 8B 8D D4 DC FF FF 81 E1 FF FF 00 00 83 E1 07 BA 01 00 00 00 D3 E2 8A 84 05 BC DF FF FF 0A C2 8B 8D D4 DC FF FF 81 E1 FF FF 00 00 C1 F9 03 88 84 0D BC DF FF FF EB 90 66 C7 45 FC 00 00 E9 73 FE FF FF 8B 95 E0 DC FF FF 33 C0 66 8B 02 85 C0 75 05 E9 86 0E 00 00 83 7D F8 7B 75 09 8B 8D E0 DC FF FF 89 4D 0C 8B 55 C0 89 95 DC DC FF FF 8B 45 E4 83 E8 01 89 45 E4 8B 4D 08 51 66 8B 95 E8 DC FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 83 BD D8 DC FF FF 00 74 14 8B 45 E8 8B 4D E8 83 E9 01 89 4D E8 85 C0 0F 84 F8 00 00 00 8B 55 E4 83 C2 01 89 55 E4 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 66 89 85 E8 DC FF FF 8B 8D E8 DC FF FF 81 E1 FF FF 00 00 81 F9 FF FF 00 00 0F 84 A0 00 00 00 8B 95 E8 DC FF FF 81 E2 FF FF 00 00 C1 FA 03 0F BE 84 15 BC DF FF FF 0F BE 4D F4 33 C1 8B 8D E8 DC FF FF 81 E1 FF FF 00 00 83 E1 07 BA 01 00 00 00 D3 E2 23 C2 85 C0 74 67 0F BE 85 AC DF FF FF 85 C0 75 4B 0F BE 8D B8 DF FF FF 85 C9 74 18 8B 55 C0 66 8B 85 E8 DC FF FF 66 89 02 8B 4D C0 83 C1 02 89 4D C0 EB 26 66 8B 95 E8 DC FF FF 52 8B 45 C0 50 E8 ?? ?? ?? ?? 83 C4 08 89 85 D0 DC FF FF 8B 4D C0 03 8D D0 DC FF FF 89 4D C0 EB 0F 8B 95 DC DC FF FF 83 C2 02 89 95 DC DC FF FF EB 1F 8B 45 E4 83 E8 01 89 45 E4 8B 4D 08 51 66 8B 95 E8 DC FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 EB 05 E9 EB FE FF FF 8B 85 DC DC FF FF 3B 45 C0 74 37 0F BE 8D AC DF FF FF 85 C9 75 2A 8B 55 C8 83 C2 01 89 55 C8 83 7D F8 63 74 1B 0F BE 85 B8 DF FF FF 85 C0 74 0A 8B 4D C0 66 C7 01 00 00 EB 06 8B 55 C0 C6 02 00 EB 05 E9 F5 0C 00 00 E9 29 0C 00 00 C7 45 F8 64 00 00 00 8B 85 E8 DC FF FF 25 FF FF 00 00 83 F8 2D 75 11 8A 8D B4 DF FF FF 80 C1 01 88 8D B4 DF FF FF EB 11 8B 95 E8 DC FF FF 81 E2 FF FF 00 00 83 FA 2B 75 3F 8B 45 E8 83 E8 01 89 45 E8 83 7D E8 00 75 14 83 BD D8 DC FF FF 00 74 0B 8A 4D EC 80 C1 01 88 4D EC EB 1C 8B 55 E4 83 C2 01 89 55 E4 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 66 89 85 E8 DC FF FF 8B 8D E8 DC FF FF 81 E1 FF FF 00 00 83 F9 30 0F 85 A7 00 00 00 8B 55 E4 83 C2 01 89 55 E4 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 66 89 85 E8 DC FF FF 8B 8D E8 DC FF FF 81 E1 FF FF 00 00 83 F9 78 74 11 8B 95 E8 DC FF FF 81 E2 FF FF 00 00 83 FA 58 75 25 8B 45 E4 83 C0 01 89 45 E4 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 66 89 85 E8 DC FF FF C7 45 F8 78 00 00 00 EB 44 8B 95 B0 DF FF FF 83 C2 01 89 95 B0 DF FF FF 83 7D F8 78 74 09 C7 45 F8 6F 00 00 00 EB 26 8B 45 E4 83 E8 01 89 45 E4 8B 4D 08 51 66 8B 95 E8 DC FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 66 C7 85 E8 DC FF FF 30 00 EB 75 C6 45 C4 01 8B 85 E8 DC FF FF 25 FF FF 00 00 83 F8 2D 75 11 8A 8D B4 DF FF FF 80 C1 01 88 8D B4 DF FF FF EB 11 8B 95 E8 DC FF FF 81 E2 FF FF 00 00 83 FA 2B 75 3F 8B 45 E8 83 E8 01 89 45 E8 83 7D E8 00 75 14 83 BD D8 DC FF FF 00 74 0B 8A 4D EC 80 C1 01 88 4D EC EB 1C 8B 55 E4 83 C2 01 89 55 E4 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 66 89 85 E8 DC FF FF 83 BD E4 DC FF FF 00 0F 84 69 02 00 00 0F BE 4D EC 85 C9 0F 85 3A 02 00 00 83 7D F8 78 0F 85 B8 00 00 00 8B 95 E8 DC FF FF 81 E2 FF FF 00 00 81 E2 00 FF 00 00 85 D2 0F 85 90 00 00 00 83 3D ?? ?? ?? ?? 01 7E 26 68 80 00 00 00 8B 85 E8 DC FF FF 25 FF FF 00 00 25 FF 00 00 00 50 E8 ?? ?? ?? ?? 83 C4 08 89 85 B8 DC FF FF EB 29 8B 8D E8 DC FF FF 81 E1 FF FF 00 00 81 E1 FF 00 00 00 8B 15 ?? ?? ?? ?? 33 C0 66 8B 04 4A 25 80 00 00 00 89 85 B8 DC FF FF 83 BD B8 DC FF FF 00 74 2F B9 04 00 00 00 8B 45 D4 8B 55 D8 E8 ?? ?? ?? ?? 89 45 D4 89 55 D8 66 8B 8D E8 DC FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 66 89 85 E8 DC FF FF EB 09 8A 55 EC 80 C2 01 88 55 EC E9 DF 00 00 00 8B 85 E8 DC FF FF 25 FF FF 00 00 25 00 FF 00 00 85 C0 0F 85 BE 00 00 00 83 3D ?? ?? ?? ?? 01 7E 25 6A 04 8B 8D E8 DC FF FF 81 E1 FF FF 00 00 81 E1 FF 00 00 00 51 E8 ?? ?? ?? ?? 83 C4 08 89 85 B4 DC FF FF EB 26 8B 95 E8 DC FF FF 81 E2 FF FF 00 00 81 E2 FF 00 00 00 A1 ?? ?? ?? ?? 33 C9 66 8B 0C 50 83 E1 04 89 8D B4 DC FF FF 83 BD B4 DC FF FF 00 74 61 83 7D F8 6F 75 33 8B 95 E8 DC FF FF 81 E2 FF FF 00 00 83 FA 38 7D 18 B9 03 00 00 00 8B 45 D4 8B 55 D8 E8 ?? ?? ?? ?? 89 45 D4 89 55 D8 EB 08 8A 45 EC 04 01 88 45 EC EB 26 B9 02 00 00 00 8B 45 D4 8B 55 D8 E8 ?? ?? ?? ?? 03 45 D4 13 55 D8 B9 01 00 00 00 E8 ?? ?? ?? ?? 89 45 D4 89 55 D8 EB 09 8A 4D EC 80 C1 01 88 4D EC 0F BE 55 EC 85 D2 75 6F 8B 85 B0 DF FF FF 83 C0 01 89 85 B0 DF FF FF 8B 85 E8 DC FF FF 25 FF FF 00 00 83 E8 30 99 8B 4D D4 03 C8 8B 45 D8 13 C2 89 4D D4 89 45 D8 83 BD D8 DC FF FF 00 74 1A 8B 4D E8 83 E9 01 89 4D E8 83 7D E8 00 75 0B 8A 55 EC 80 C2 01 88 55 EC EB 1C 8B 45 E4 83 C0 01 89 45 E4 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 66 89 85 E8 DC FF FF EB 1D 8B 55 E4 83 EA 01 89 55 E4 8B 45 08 50 66 8B 8D E8 DC FF FF 51 E8 ?? ?? ?? ?? 83 C4 08 E9 BA FD FF FF 0F BE 95 B4 DF FF FF 85 D2 74 13 8B 45 D4 F7 D8 8B 4D D8 83 D1 00 F7 D9 89 45 D4 89 4D D8 E9 25 02 00 00 0F BE 55 EC 85 D2 0F 85 06 02 00 00 83 7D F8 78 74 0A 83 7D F8 70 0F 85 AB 00 00 00 8B 85 E8 DC FF FF 25 FF FF 00 00 25 00 FF 00 00 85 C0 0F 85 85 00 00 00 83 3D ?? ?? ?? ?? 01 7E 28 68 80 00 00 00 8B 8D E8 DC FF FF 81 E1 FF FF 00 00 81 E1 FF 00 00 00 51 E8 ?? ?? ?? ?? 83 C4 08 89 85 B0 DC FF FF EB 29 8B 95 E8 DC FF FF 81 E2 FF FF 00 00 81 E2 FF 00 00 00 A1 ?? ?? ?? ?? 33 C9 66 8B 0C 50 81 E1 80 00 00 00 89 8D B0 DC FF FF 83 BD B0 DC FF FF 00 74 22 8B 55 BC C1 E2 04 89 55 BC 66 8B 85 E8 DC FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 66 89 85 E8 DC FF FF EB 09 8A 4D EC 80 C1 01 88 4D EC E9 BB 00 00 00 8B 95 E8 DC FF FF 81 E2 FF FF 00 00 81 E2 00 FF 00 00 85 D2 0F 85 98 00 00 00 83 3D ?? ?? ?? ?? 01 7E 23 6A 04 8B 85 E8 DC FF FF 25 FF FF 00 00 25 FF 00 00 00 50 E8 ?? ?? ?? ?? 83 C4 08 89 85 AC DC FF FF EB 27 8B 8D E8 DC FF FF 81 E1 FF FF 00 00 81 E1 FF 00 00 00 8B 15 ?? ?? ?? ?? 33 C0 66 8B 04 4A 83 E0 04 89 85 AC DC FF FF 83 BD AC DC FF FF 00 74 3C 83 7D F8 6F 75 26 8B 8D E8 DC FF FF 81 E1 FF FF 00 00 83 F9 38 7D 0B 8B 55 BC C1 E2 03 89 55 BC EB 08 8A 45 EC 04 01 88 45 EC EB 0E 8B 4D BC 8B 55 BC 8D 04 8A D1 E0 89 45 BC EB 09 8A 4D EC 80 C1 01 88 4D EC 0F BE 55 EC 85 D2 75 66 8B 85 B0 DF FF FF 83 C0 01 89 85 B0 DF FF FF 8B 8D E8 DC FF FF 81 E1 FF FF 00 00 8B 55 BC 8D 44 0A D0 89 45 BC 83 BD D8 DC FF FF 00 74 1A 8B 4D E8 83 E9 01 89 4D E8 83 7D E8 00 75 0B 8A 55 EC 80 C2 01 88 55 EC EB 1C 8B 45 E4 83 C0 01 89 45 E4 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 66 89 85 E8 DC FF FF EB 1D 8B 55 E4 83 EA 01 89 55 E4 8B 45 08 50 66 8B 8D E8 DC FF FF 51 E8 ?? ?? ?? ?? 83 C4 08 E9 EE FD FF FF 0F BE 95 B4 DF FF FF 85 D2 74 08 8B 45 BC F7 D8 89 45 BC 83 7D F8 46 75 0A C7 85 B0 DF FF FF 00 00 00 00 83 BD B0 DF FF FF 00 74 4B 0F BE 8D AC DF FF FF 85 C9 75 3E 8B 55 C8 83 C2 01 89 55 C8 83 BD E4 DC FF FF 00 74 10 8B 45 C0 8B 4D D4 89 08 8B 55 D8 89 50 04 EB 1C 0F BE 45 C4 85 C0 74 0A 8B 4D C0 8B 55 BC 89 11 EB 0A 8B 45 C0 66 8B 4D BC 66 89 08 EB 05 E9 41 06 00 00 E9 75 05 00 00 8B 55 E4 89 55 BC 0F BE 85 AC DF FF FF 85 C0 75 02 EB AC E9 5D 05 00 00 8D 8D F0 DC FF FF 89 4D D0 8B 95 E8 DC FF FF 81 E2 FF FF 00 00 83 FA 2D 75 13 8B 45 D0 66 C7 00 2D 00 8B 4D D0 83 C1 02 89 4D D0 EB 11 8B 95 E8 DC FF FF 81 E2 FF FF 00 00 83 FA 2B 75 25 8B 45 E8 83 E8 01 89 45 E8 8B 4D E4 83 C1 01 89 4D E4 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 66 89 85 E8 DC FF FF 83 BD D8 DC FF FF 00 74 09 81 7D E8 5D 01 00 00 7E 07 C7 45 E8 5D 01 00 00 8B 85 E8 DC FF FF 25 FF FF 00 00 25 00 FF 00 00 85 C0 0F 85 B3 00 00 00 83 3D ?? ?? ?? ?? 01 7E 25 6A 04 8B 8D E8 DC FF FF 81 E1 FF FF 00 00 81 E1 FF 00 00 00 51 E8 ?? ?? ?? ?? 83 C4 08 89 85 A8 DC FF FF EB 26 8B 95 E8 DC FF FF 81 E2 FF FF 00 00 81 E2 FF 00 00 00 A1 ?? ?? ?? ?? 33 C9 66 8B 0C 50 83 E1 04 89 8D A8 DC FF FF 83 BD A8 DC FF FF 00 74 56 8B 55 E8 8B 45 E8 83 E8 01 89 45 E8 85 D2 74 46 8B 8D B0 DF FF FF 83 C1 01 89 }
	condition:
		$1
}

rule file_414_1_0 {
	meta:
		name = "__hextodec"
		size = 152
		refs = "0017 ___mb_cur_max 0031 __isctype 004d __pctype 0071 _iswctype"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 25 FF FF 00 00 25 00 FF 00 00 85 C0 75 54 83 3D ?? ?? ?? ?? 01 7E 1F 6A 04 8B 4D 08 81 E1 FF FF 00 00 81 E1 FF 00 00 00 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC EB 20 8B 55 08 81 E2 FF FF 00 00 81 E2 FF 00 00 00 A1 ?? ?? ?? ?? 33 C9 66 8B 0C 50 83 E1 04 89 4D FC 83 7D FC 00 74 06 66 8B 45 08 EB 2B 6A 02 66 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 0D 8B 45 08 25 FF FF 00 00 83 E8 27 EB 0B 8B 45 08 25 FF FF 00 00 83 E8 07 8B E5 5D C3 }
	condition:
		$1
}

rule file_414_3_0 {
	meta:
		name = "__un_inc"
		size = 37
		refs = "001c _ungetwc"
	strings:
		$1 = { 55 8B EC 8B 45 08 25 FF FF 00 00 3D FF FF 00 00 74 11 8B 4D 0C 51 66 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_414_4_0 {
	meta:
		name = "__whiteout"
		size = 60
		refs = "0016 __inc 0027 _iswspace"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 8B 08 83 C1 01 8B 55 08 89 0A 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 04 66 89 45 FC 66 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 02 EB D0 66 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_415_0_0 {
	meta:
		name = "__fgetwchar"
		size = 18
		refs = "0004 __iob 0009 _fgetwc"
	strings:
		$1 = { 55 8B EC 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_417_0_0 {
	meta:
		name = "__execvpe"
		size = 805
		refs = "0017 ??_C@_0BB@COCE@filename?5?$CB?$DN?5NULL?$AA@ 0020 ??_C@_09PKLP@execvpe?4c?$AA@ 0027 __CrtDbgReport 0045 ??_C@_0BG@GALO@?$CKfilename?5?$CB?$DN?5_T?$CI?8?20?8?$CJ?$AA@ 006f ??_C@_0BC@DJDH@argvector?5?$CB?$DN?5NULL?$AA@ 009b ??_C@_0BD@DPK@?$CKargvector?5?$CB?$DN?5NULL?$AA@ 00cb ??_C@_0BI@GGEG@?$CK?$CKargvector?5?$CB?$DN?5_T?$CI?8?20?8?$CJ?$AA@ 00fb __execve 0104 _errno 0112 __mbschr 0146 ??_C@_04LNMG@PATH?$AA@ 014b _getenv 016f __malloc_dbg 01f8 __mbsrchr 0205 ??_C@_01PCFE@?2?$AA@ 020e _strcat 0238 _strlen 0314 __free_dbg"
	strings:
		$1 = { 55 8B EC 83 EC 10 53 56 57 C7 45 F4 00 00 00 00 83 7D 08 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 49 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D6 8B 4D 08 0F BE 11 85 D2 75 1E 68 ?? ?? ?? ?? 6A 00 6A 4A 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D2 83 7D 0C 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 4B 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D6 8B 55 0C 83 3A 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 4C 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D4 8B 4D 0C 8B 11 0F BE 02 85 C0 75 1E 68 ?? ?? ?? ?? 6A 00 6A 4D 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D0 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 83 3D ?? ?? ?? ?? 02 75 50 6A 5C 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 3E 6A 2F 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 2C 8B 4D 08 0F BE 11 85 D2 74 0C 8B 45 08 0F BE 48 01 83 F9 3A 74 16 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 89 45 F8 83 7D F8 00 75 05 E9 A7 01 00 00 6A 5A 68 ?? ?? ?? ?? 6A 02 68 04 01 00 00 E8 ?? ?? ?? ?? 83 C4 10 89 45 F4 8B 55 F4 89 55 FC 83 7D FC 00 75 05 E9 7D 01 00 00 8B 45 F8 0F BE 08 85 C9 74 37 8B 55 F8 0F BE 02 83 F8 3B 74 2C 8B 4D F4 81 C1 02 01 00 00 39 4D FC 73 1E 8B 55 FC 8B 45 F8 8A 08 88 0A 8B 55 FC 83 C2 01 89 55 FC 8B 45 F8 83 C0 01 89 45 F8 EB BF 8B 4D FC C6 01 00 8B 55 FC 83 EA 01 89 55 FC 8B 45 FC 89 45 F0 8B 4D F4 89 4D FC 8B 55 F0 0F BE 02 83 F8 5C 75 26 6A 5C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 39 45 F0 74 11 68 ?? ?? ?? ?? 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 08 EB 1C 8B 45 F0 0F BE 08 83 F9 2F 74 11 68 ?? ?? ?? ?? 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 8B F0 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 03 F0 81 FE 04 01 00 00 73 12 8B 55 08 52 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 EB 05 E9 99 00 00 00 8B 4D 10 51 8B 55 0C 52 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 0C 83 3D ?? ?? ?? ?? 02 74 5E 6A 5C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 39 45 FC 74 13 6A 2F 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 08 39 45 FC 75 36 8B 75 FC 83 C6 01 6A 5C 8B 45 FC 83 C0 01 50 E8 ?? ?? ?? ?? 83 C4 08 3B F0 74 1D 8B 75 FC 83 C6 01 6A 2F 8B 4D FC 83 C1 01 51 E8 ?? ?? ?? ?? 83 C4 08 3B F0 74 02 EB 1E 8B 55 F8 0F BE 02 85 C0 74 14 8B 4D F8 8B 55 F8 83 C2 01 89 55 F8 85 C9 0F 85 83 FE FF FF 83 7D F4 00 74 0E 6A 02 8B 45 F4 50 E8 ?? ?? ?? ?? 83 C4 08 83 C8 FF 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_418_0_0 {
	meta:
		name = "_malloc"
		size = 38
		refs = "000b __newmode 0015 __nh_malloc_dbg"
	strings:
		$1 = { 55 8B EC 51 6A 00 6A 00 6A 01 A1 ?? ?? ?? ?? 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 14 89 45 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_418_1_0 {
	meta:
		name = "__malloc_dbg"
		size = 44
		refs = "0011 __newmode 001b __nh_malloc_dbg"
	strings:
		$1 = { 55 8B EC 51 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 A1 ?? ?? ?? ?? 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 14 89 45 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_418_2_0 {
	meta:
		name = "__nh_malloc"
		size = 27
		refs = "0012 __nh_malloc_dbg"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 01 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_418_3_0 {
	meta:
		name = "__nh_malloc_dbg"
		size = 74
		refs = "0015 __heap_alloc_dbg 0035 __callnewh"
	strings:
		$1 = { 55 8B EC 51 8B 45 18 50 8B 4D 14 51 8B 55 10 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 FC 83 7D FC 00 75 06 83 7D 0C 00 75 05 8B 45 FC EB 16 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 04 33 C0 EB 02 EB BE 8B E5 5D C3 }
	condition:
		$1
}

rule file_418_4_0 {
	meta:
		name = "__heap_alloc"
		size = 23
		refs = "000e __heap_alloc_dbg"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 01 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_418_5_0 {
	meta:
		name = "__heap_alloc_dbg"
		size = 787
		refs = "0011 __crtDbgFlag 001d __CrtCheckMemory 0026 ??_C@_0BC@EPKL@_CrtCheckMemory?$CI?$CJ?$AA@ 0032 ??_C@_09IMJC@dbgheap?4c?$AA@ 0039 __CrtDbgReport 004e __lRequestCurr 005a __crtBreakAlloc 007b __pfnAllocHook 0095 ??_C@_0DF@DKHF@Client?5hook?5allocation?5failure?5a@ 00b8 ??_C@_0CB@CPBI@Client?5hook?5allocation?5failure?4?6@ 00bd ??_C@_02DILL@?$CFs?$AA@ 011c ??_C@_0CE@FMIA@Invalid?5allocation?5size?3?5?$CFu?5byte@ 016b ??_C@_0DC@CGID@Error?3?5memory?5allocation?3?5bad?5me@ 019e __heap_alloc_base 0215 __lTotalAlloc 0223 __lCurAlloc 0237 __lMaxAlloc 024b __pFirstBlock 0264 __pLastBlock 02b9 __bNoMansLandFill 02c6 _memset 02f2 __bCleanLandFill"
	strings:
		$1 = { 55 8B EC 83 EC 10 53 56 57 C7 45 F4 00 00 00 00 A1 ?? ?? ?? ?? 83 E0 04 85 C0 74 30 E8 ?? ?? ?? ?? 85 C0 75 21 68 ?? ?? ?? ?? 6A 00 68 4C 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D0 8B 15 ?? ?? ?? ?? 89 55 F8 8B 45 F8 3B 05 ?? ?? ?? ?? 75 01 CC 8B 4D 14 51 8B 55 10 52 8B 45 F8 50 8B 4D 0C 51 8B 55 08 52 6A 00 6A 01 FF 15 ?? ?? ?? ?? 83 C4 1C 85 C0 75 5E 83 7D 10 00 74 2B 8B 45 14 50 8B 4D 10 51 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 1C 83 F8 01 75 01 CC 33 D2 85 D2 75 D7 EB 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 85 C0 75 DA 33 C0 E9 28 02 00 00 8B 4D 0C 81 E1 FF FF 00 00 83 F9 02 74 14 8B 15 ?? ?? ?? ?? 83 E2 01 85 D2 75 07 C7 45 F4 01 00 00 00 83 7D 08 E0 77 0B 8B 45 08 83 C0 24 83 F8 E0 76 2C 8B 4D 08 51 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 01 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 85 D2 75 DB 33 C0 E9 C9 01 00 00 8B 45 0C 25 FF FF 00 00 83 F8 04 74 40 83 7D 0C 01 74 3A 8B 4D 0C 81 E1 FF FF 00 00 83 F9 02 74 2C 83 7D 0C 03 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 01 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 85 D2 75 DA 8B 45 08 83 C0 24 89 45 F0 8B 4D F0 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 83 7D FC 00 75 07 33 C0 E9 57 01 00 00 8B 15 ?? ?? ?? ?? 83 C2 01 89 15 ?? ?? ?? ?? 83 7D F4 00 74 49 8B 45 FC C7 00 00 00 00 00 8B 4D FC C7 41 04 00 00 00 00 8B 55 FC C7 42 08 00 00 00 00 8B 45 FC C7 40 0C BC BA DC FE 8B 4D FC 8B 55 08 89 51 10 8B 45 FC C7 40 14 03 00 00 00 8B 4D FC C7 41 18 00 00 00 00 E9 A0 00 00 00 8B 15 ?? ?? ?? ?? 03 55 08 89 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? 03 45 08 A3 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 3B 0D ?? ?? ?? ?? 76 0C 8B 15 ?? ?? ?? ?? 89 15 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 74 0D A1 ?? ?? ?? ?? 8B 4D FC 89 48 04 EB 09 8B 55 FC 89 15 ?? ?? ?? ?? 8B 45 FC 8B 0D ?? ?? ?? ?? 89 08 8B 55 FC C7 42 04 00 00 00 00 8B 45 FC 8B 4D 10 89 48 08 8B 55 FC 8B 45 14 89 42 0C 8B 4D FC 8B 55 08 89 51 10 8B 45 FC 8B 4D 0C 89 48 14 8B 55 FC 8B 45 F8 89 42 18 8B 4D FC 89 0D ?? ?? ?? ?? 6A 04 33 D2 8A 15 ?? ?? ?? ?? 52 8B 45 FC 83 C0 1C 50 E8 ?? ?? ?? ?? 83 C4 0C 6A 04 33 C9 8A 0D ?? ?? ?? ?? 51 8B 55 08 8B 45 FC 8D 4C 10 20 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 08 52 33 C0 A0 ?? ?? ?? ?? 50 8B 4D FC 83 C1 20 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 FC 83 C0 20 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_418_6_0 {
	meta:
		name = "_calloc"
		size = 36
		refs = "0013 __calloc_dbg"
	strings:
		$1 = { 55 8B EC 51 6A 00 6A 00 6A 01 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 14 89 45 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_418_11_0 {
	meta:
		name = "__expand"
		size = 36
		refs = "0013 __expand_dbg"
	strings:
		$1 = { 55 8B EC 51 6A 00 6A 00 6A 01 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 14 89 45 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_418_8_0 {
	meta:
		name = "_realloc"
		size = 36
		refs = "0013 __realloc_dbg"
	strings:
		$1 = { 55 8B EC 51 6A 00 6A 00 6A 01 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 14 89 45 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_418_7_0 {
	meta:
		name = "__calloc_dbg"
		size = 96
		refs = "0021 __malloc_dbg"
	strings:
		$1 = { 55 8B EC 83 EC 0C 8B 45 0C 0F AF 45 08 89 45 0C 8B 4D 18 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 F8 83 7D F8 00 74 28 8B 55 F8 89 55 F4 8B 45 F4 03 45 0C 89 45 FC 8B 4D F4 3B 4D FC 73 11 8B 55 F4 C6 02 00 8B 45 F4 83 C0 01 89 45 F4 EB E7 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_418_9_0 {
	meta:
		name = "__realloc_dbg"
		size = 44
		refs = "001b _realloc_help"
	strings:
		$1 = { 55 8B EC 51 6A 01 8B 45 18 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 18 89 45 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_418_10_0 {
	meta:
		name = "_realloc_help"
		size = 1297
		refs = "0027 __malloc_dbg 0048 __free_dbg 0057 __crtDbgFlag 0063 __CrtCheckMemory 006c ??_C@_0BC@EPKL@_CrtCheckMemory?$CI?$CJ?$AA@ 0078 ??_C@_09IMJC@dbgheap?4c?$AA@ 007f __CrtDbgReport 0094 __lRequestCurr 00a0 __crtBreakAlloc 00c3 __pfnAllocHook 00dd ??_C@_0DI@KKMM@Client?5hook?5re?9allocation?5failur@ 0100 ??_C@_0CE@EAMN@Client?5hook?5re?9allocation?5failur@ 0105 ??_C@_02DILL@?$CFs?$AA@ 0137 ??_C@_0CN@FHGE@Allocation?5too?5large?5or?5negative@ 0181 ??_C@_0DC@CGID@Error?3?5memory?5allocation?3?5bad?5me@ 01ab __CrtIsValidHeapPointer 01b7 ??_C@_0CC@GPMO@_CrtIsValidHeapPointer?$CIpUserData@ 0212 ??_C@_0EF@EDKM@pOldBlock?9?$DOnLine?5?$DN?$DN?5IGNORE_LINE?5@ 0278 ??_C@_0DK@DKOM@_BLOCK_TYPE?$CIpOldBlock?9?$DOnBlockUse@ 02b0 __realloc_base 02d5 __expand_base 0305 __lTotalAlloc 0324 __lCurAlloc 0347 __lMaxAlloc 0378 __bCleanLandFill 0388 _memset 0394 __bNoMansLandFill 03e7 ??_C@_0DC@BOCN@fRealloc?5?$HM?$HM?5?$CI?$CBfRealloc?5?$CG?$CG?5pNewBl@ 043c __pLastBlock 0446 ??_C@_0BJ@NMEF@_pLastBlock?5?$DN?$DN?5pOldBlock?$AA@ 0490 __pFirstBlock 049a ??_C@_0BK@JDHA@_pFirstBlock?5?$DN?$DN?5pOldBlock?$AA@"
	strings:
		$1 = { 55 8B EC 83 EC 14 53 56 57 C7 45 EC 00 00 00 00 83 7D 08 00 75 1D 8B 45 18 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 10 E9 D7 04 00 00 83 7D 1C 00 74 1D 83 7D 0C 00 75 17 8B 4D 10 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 33 C0 E9 B4 04 00 00 A1 ?? ?? ?? ?? 83 E0 04 85 C0 74 30 E8 ?? ?? ?? ?? 85 C0 75 21 68 ?? ?? ?? ?? 6A 00 68 46 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D0 8B 15 ?? ?? ?? ?? 89 55 F0 8B 45 F0 3B 05 ?? ?? ?? ?? 75 01 CC 8B 4D 18 51 8B 55 14 52 8B 45 F0 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 6A 02 FF 15 ?? ?? ?? ?? 83 C4 1C 85 C0 75 5E 83 7D 14 00 74 2B 8B 4D 18 51 8B 55 14 52 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 1C 83 F8 01 75 01 CC 33 C0 85 C0 75 D7 EB 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 85 C9 75 DA 33 C0 E9 DE 03 00 00 83 7D 0C DB 76 2C 8B 55 0C 52 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 01 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 85 C0 75 DB 33 C0 E9 AC 03 00 00 83 7D 10 01 74 42 8B 4D 10 81 E1 FF FF 00 00 83 F9 04 74 34 8B 55 10 81 E2 FF FF 00 00 83 FA 02 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 01 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 85 C0 75 DA 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 21 68 ?? ?? ?? ?? 6A 00 68 6E 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 D2 85 D2 75 C9 8B 45 08 83 E8 20 89 45 F8 8B 4D F8 83 79 14 03 75 07 C7 45 EC 01 00 00 00 83 7D EC 00 74 3E 8B 55 F8 81 7A 0C BC BA DC FE 75 09 8B 45 F8 83 78 18 00 74 21 68 ?? ?? ?? ?? 6A 00 68 78 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 C4 EB 64 8B 55 F8 8B 42 14 25 FF FF 00 00 83 F8 02 75 15 8B 4D 10 81 E1 FF FF 00 00 83 F9 01 75 07 C7 45 10 02 00 00 00 8B 55 F8 8B 42 14 25 FF FF 00 00 8B 4D 10 81 E1 FF FF 00 00 3B C1 74 21 68 ?? ?? ?? ?? 6A 00 68 7F 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 D2 85 D2 75 C1 83 7D 1C 00 74 25 8B 45 0C 83 C0 24 50 8B 4D F8 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 F4 83 7D F4 00 75 07 33 C0 E9 43 02 00 00 EB 23 8B 55 0C 83 C2 24 52 8B 45 F8 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 F4 83 7D F4 00 75 07 33 C0 E9 1E 02 00 00 8B 0D ?? ?? ?? ?? 83 C1 01 89 0D ?? ?? ?? ?? 83 7D EC 00 75 56 8B 55 F4 A1 ?? ?? ?? ?? 2B 42 10 A3 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 03 4D 0C 89 0D ?? ?? ?? ?? 8B 55 F4 A1 ?? ?? ?? ?? 2B 42 10 A3 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 03 4D 0C 89 0D ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 3B 15 ?? ?? ?? ?? 76 0A A1 ?? ?? ?? ?? A3 ?? ?? ?? ?? 8B 4D F4 83 C1 20 89 4D FC 8B 55 F4 8B 45 0C 3B 42 10 76 24 8B 4D F4 8B 55 0C 2B 51 10 52 33 C0 A0 ?? ?? ?? ?? 50 8B 4D F4 8B 55 FC 03 51 10 52 E8 ?? ?? ?? ?? 83 C4 0C 6A 04 33 C0 A0 ?? ?? ?? ?? 50 8B 4D FC 03 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 0C 83 7D EC 00 75 1B 8B 55 F4 8B 45 14 89 42 08 8B 4D F4 8B 55 18 89 51 0C 8B 45 F4 8B 4D F0 89 48 18 8B 55 F4 8B 45 0C 89 42 10 83 7D 1C 00 75 2F 83 7D 1C 00 75 08 8B 4D F4 3B 4D F8 74 21 68 ?? ?? ?? ?? 6A 00 68 B5 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 D2 85 D2 75 C5 8B 45 F4 3B 45 F8 74 06 83 7D EC 00 74 08 8B 45 FC E9 E7 00 00 00 8B 4D F4 83 39 00 74 10 8B 55 F4 8B 02 8B 4D F4 8B 51 04 89 50 04 EB 3C A1 ?? ?? ?? ?? 3B 45 F8 74 21 68 ?? ?? ?? ?? 6A 00 68 C4 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 CF 8B 55 F4 8B 42 04 A3 ?? ?? ?? ?? 8B 4D F4 83 79 04 00 74 0F 8B 55 F4 8B 42 04 8B 4D F4 8B 11 89 10 EB 3B A1 ?? ?? ?? ?? 3B 45 F8 74 21 68 ?? ?? ?? ?? 6A 00 68 CF 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 CF 8B 55 F4 8B 02 A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 74 0E 8B 0D ?? ?? ?? ?? 8B 55 F4 89 51 04 EB 08 8B 45 F4 A3 ?? ?? ?? ?? 8B 4D F4 8B 15 ?? ?? ?? ?? 89 11 8B 45 F4 C7 40 04 00 00 00 00 8B 4D F4 89 0D ?? ?? ?? ?? 8B 45 FC 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_418_12_0 {
	meta:
		name = "__expand_dbg"
		size = 44
		refs = "001b _realloc_help"
	strings:
		$1 = { 55 8B EC 51 6A 00 8B 45 18 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 18 89 45 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_418_14_0 {
	meta:
		name = "__free_dbg"
		size = 1004
		refs = "0008 __crtDbgFlag 0014 __CrtCheckMemory 001d ??_C@_0BC@EPKL@_CrtCheckMemory?$CI?$CJ?$AA@ 0029 ??_C@_09IMJC@dbgheap?4c?$AA@ 0030 __CrtDbgReport 0062 __pfnAllocHook 006e ??_C@_0BL@MBNA@Client?5hook?5free?5failure?4?6?$AA@ 0073 ??_C@_02DILL@?$CFs?$AA@ 009d __CrtIsValidHeapPointer 00a9 ??_C@_0CC@GPMO@_CrtIsValidHeapPointer?$CIpUserData@ 010b ??_C@_0CH@PHOC@_BLOCK_TYPE_IS_VALID?$CIpHead?9?$DOnBlo@ 0145 __bNoMansLandFill 0152 _CheckBytes 017a _szBlockUseName 0180 ??_C@_0CL@IJIL@DAMAGE?3?5before?5?$CFhs?5block?5?$CI?$CD?$CFd?$CJ?5a@ 01e6 ??_C@_0CK@OJNB@DAMAGE?3?5after?5?$CFhs?5block?5?$CI?$CD?$CFd?$CJ?5at@ 0225 ??_C@_0DN@KKIO@pHead?9?$DOnLine?5?$DN?$DN?5IGNORE_LINE?5?$CG?$CG?5p@ 0259 __bDeadLandFill 0263 _memset 026f __free_base 029d ??_C@_0BO@PLHH@pHead?9?$DOnBlockUse?5?$DN?$DN?5nBlockUse?$AA@ 02c7 __lCurAlloc 02fe __pLastBlock 0308 ??_C@_0BF@NLNN@_pLastBlock?5?$DN?$DN?5pHead?$AA@ 0354 __pFirstBlock 035e ??_C@_0BG@JCEC@_pFirstBlock?5?$DN?$DN?5pHead?$AA@"
	strings:
		$1 = { 55 8B EC 51 53 56 57 A1 ?? ?? ?? ?? 83 E0 04 85 C0 74 30 E8 ?? ?? ?? ?? 85 C0 75 21 68 ?? ?? ?? ?? 6A 00 68 02 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D0 83 7D 08 00 75 05 E9 97 03 00 00 6A 00 6A 00 6A 00 8B 55 0C 52 6A 00 8B 45 08 50 6A 03 FF 15 ?? ?? ?? ?? 83 C4 1C 85 C0 75 2B 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 85 C9 75 DA E9 4D 03 00 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 21 68 ?? ?? ?? ?? 6A 00 68 14 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 C9 8B 4D 08 83 E9 20 89 4D FC 8B 55 FC 8B 42 14 25 FF FF 00 00 83 F8 04 74 43 8B 4D FC 83 79 14 01 74 3A 8B 55 FC 8B 42 14 25 FF FF 00 00 83 F8 02 74 2A 8B 4D FC 83 79 14 03 74 21 68 ?? ?? ?? ?? 6A 00 68 1A 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 D2 85 D2 75 A7 A1 ?? ?? ?? ?? 83 E0 04 85 C0 0F 85 C5 00 00 00 6A 04 8A 0D ?? ?? ?? ?? 51 8B 55 FC 83 C2 1C 52 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 43 8B 45 FC 83 C0 20 50 8B 4D FC 8B 51 18 52 8B 45 FC 8B 48 14 81 E1 FF FF 00 00 8B 14 8D ?? ?? ?? ?? 52 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 01 E8 ?? ?? ?? ?? 83 C4 20 83 F8 01 75 01 CC 33 C0 85 C0 75 BD 6A 04 8A 0D ?? ?? ?? ?? 51 8B 55 FC 8B 42 10 8B 4D FC 8D 54 01 20 52 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 43 8B 45 FC 83 C0 20 50 8B 4D FC 8B 51 18 52 8B 45 FC 8B 48 14 81 E1 FF FF 00 00 8B 14 8D ?? ?? ?? ?? 52 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 01 E8 ?? ?? ?? ?? 83 C4 20 83 F8 01 75 01 CC 33 C0 85 C0 75 BD 8B 4D FC 83 79 14 03 75 6C 8B 55 FC 81 7A 0C BC BA DC FE 75 09 8B 45 FC 83 78 18 00 74 21 68 ?? ?? ?? ?? 6A 00 68 2F 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 C4 8B 55 FC 8B 42 10 83 C0 24 50 33 C9 8A 0D ?? ?? ?? ?? 51 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 E9 6A 01 00 00 8B 4D FC 83 79 14 02 75 0D 83 7D 0C 01 75 07 C7 45 0C 02 00 00 00 8B 55 FC 8B 42 14 3B 45 0C 74 21 68 ?? ?? ?? ?? 6A 00 68 3C 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 CE 8B 55 FC A1 ?? ?? ?? ?? 2B 42 10 A3 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 83 E1 02 85 C9 0F 85 D8 00 00 00 8B 55 FC 83 3A 00 74 10 8B 45 FC 8B 08 8B 55 FC 8B 42 04 89 41 04 EB 3E 8B 0D ?? ?? ?? ?? 3B 4D FC 74 21 68 ?? ?? ?? ?? 6A 00 68 4B 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 D2 85 D2 75 CE 8B 45 FC 8B 48 04 89 0D ?? ?? ?? ?? 8B 55 FC 83 7A 04 00 74 0F 8B 45 FC 8B 48 04 8B 55 FC 8B 02 89 01 EB 3D 8B 0D ?? ?? ?? ?? 3B 4D FC 74 21 68 ?? ?? ?? ?? 6A 00 68 55 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 D2 85 D2 75 CE 8B 45 FC 8B 08 89 0D ?? ?? ?? ?? 8B 55 FC 8B 42 10 83 C0 24 50 33 C9 8A 0D ?? ?? ?? ?? 51 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 EB 29 8B 4D FC C7 41 14 00 00 00 00 8B 55 FC 8B 42 10 50 33 C9 8A 0D ?? ?? ?? ?? 51 8B 55 FC 83 C2 20 52 E8 ?? ?? ?? ?? 83 C4 0C 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_418_16_0 {
	meta:
		name = "__msize_dbg"
		size = 322
		refs = "000a __crtDbgFlag 0016 __CrtCheckMemory 001f ??_C@_0BC@EPKL@_CrtCheckMemory?$CI?$CJ?$AA@ 002b ??_C@_09IMJC@dbgheap?4c?$AA@ 0032 __CrtDbgReport 004a __CrtIsValidHeapPointer 0056 ??_C@_0CC@GPMO@_CrtIsValidHeapPointer?$CIpUserData@ 00b8 ??_C@_0CH@PHOC@_BLOCK_TYPE_IS_VALID?$CIpHead?9?$DOnBlo@ 0109 ??_C@_0BO@PLHH@pHead?9?$DOnBlockUse?5?$DN?$DN?5nBlockUse?$AA@"
	strings:
		$1 = { 55 8B EC 83 EC 08 53 56 57 A1 ?? ?? ?? ?? 83 E0 04 85 C0 74 30 E8 ?? ?? ?? ?? 85 C0 75 21 68 ?? ?? ?? ?? 6A 00 68 9D 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D0 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 21 68 ?? ?? ?? ?? 6A 00 68 A9 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 C9 8B 4D 08 83 E9 20 89 4D F8 8B 55 F8 8B 42 14 25 FF FF 00 00 83 F8 04 74 43 8B 4D F8 83 79 14 01 74 3A 8B 55 F8 8B 42 14 25 FF FF 00 00 83 F8 02 74 2A 8B 4D F8 83 79 14 03 74 21 68 ?? ?? ?? ?? 6A 00 68 AF 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 D2 85 D2 75 A7 8B 45 F8 83 78 14 02 75 0D 83 7D 0C 01 75 07 C7 45 0C 02 00 00 00 8B 4D F8 83 79 14 03 74 32 8B 55 F8 8B 42 14 3B 45 0C 74 21 68 ?? ?? ?? ?? 6A 00 68 B6 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 CE 8B 55 F8 8B 42 10 89 45 FC 8B 45 FC 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_418_18_0 {
	meta:
		name = "__CrtSetDbgBlockType"
		size = 137
		refs = "000c __CrtIsValidHeapPointer 0053 ??_C@_0CH@PHOC@_BLOCK_TYPE_IS_VALID?$CIpHead?9?$DOnBlo@ 005f ??_C@_09IMJC@dbgheap?4c?$AA@ 0066 __CrtDbgReport"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 6B 8B 4D 08 83 E9 20 89 4D FC 8B 55 FC 8B 42 14 25 FF FF 00 00 83 F8 04 74 43 8B 4D FC 83 79 14 01 74 3A 8B 55 FC 8B 42 14 25 FF FF 00 00 83 F8 02 74 2A 8B 4D FC 83 79 14 03 74 21 68 ?? ?? ?? ?? 6A 00 68 FF 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 D2 85 D2 75 A7 8B 45 FC 8B 4D 0C 89 48 14 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_418_20_0 {
	meta:
		name = "_CheckBytes"
		size = 136
		refs = "0055 ??_C@_0DK@EKKL@memory?5check?5error?5at?50x?$CF08X?5?$DN?50@ 0062 __CrtDbgReport"
	strings:
		$1 = { 55 8B EC 51 53 56 57 C7 45 FC 01 00 00 00 8B 45 10 8B 4D 10 83 E9 01 89 4D 10 85 C0 74 60 8B 55 08 33 C0 8A 02 8B 4D 0C 81 E1 FF 00 00 00 8B 55 08 83 C2 01 89 55 08 3B C1 74 41 8B 45 0C 25 FF 00 00 00 50 8B 4D 08 33 D2 8A 51 FF 52 8B 45 08 83 E8 01 50 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 20 83 F8 01 75 01 CC 33 C9 85 C9 75 C6 C7 45 FC 00 00 00 00 EB 90 8B 45 FC 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_418_21_0 {
	meta:
		name = "__CrtCheckMemory"
		size = 854
		refs = "000a __crtDbgFlag 0020 __heapchk 005a $L18634 005f ??_C@_0CE@JMCB@_heapchk?5fails?5with?5_HEAPBADBEGI@ 0064 ??_C@_02DILL@?$CFs?$AA@ 0071 __CrtDbgReport 008a ??_C@_0CD@DNMG@_heapchk?5fails?5with?5_HEAPBADNODE@ 00b2 ??_C@_0CC@JNDP@_heapchk?5fails?5with?5_HEAPBADEND?4@ 00da ??_C@_0CC@EHNC@_heapchk?5fails?5with?5_HEAPBADPTR?4@ 0102 ??_C@_0CL@ODIE@_heapchk?5fails?5with?5unknown?5retu@ 013b __pFirstBlock 01a0 _szBlockUseName 01ac ??_C@_07GJHM@DAMAGED?$AA@ 01b3 __bNoMansLandFill 01c0 _CheckBytes 01de ??_C@_0CL@IJIL@DAMAGE?3?5before?5?$CFhs?5block?5?$CI?$CD?$CFd?$CJ?5a@ 023b ??_C@_0CK@OJNB@DAMAGE?3?5after?5?$CFhs?5block?5?$CI?$CD?$CFd?$CJ?5at@ 0274 __bDeadLandFill 0294 ??_C@_0CJ@LHHG@DAMAGE?3?5on?5top?5of?5Free?5block?5at?5@ 02dd ??_C@_0CA@EJPI@?$CFhs?5allocated?5at?5file?5?$CFhs?$CI?$CFd?$CJ?4?6?$AA@ 0310 ??_C@_0CJ@GCII@?$CFhs?5located?5at?50x?$CF08X?5is?5?$CFu?5byte@ 0346 $L18105 034a $L18097 034e $L18089 0352 $L18081"
	strings:
		$1 = { 55 8B EC 83 EC 18 53 56 57 A1 ?? ?? ?? ?? 83 E0 01 85 C0 75 0A B8 01 00 00 00 E9 20 03 00 00 E8 ?? ?? ?? ?? 89 45 F4 83 7D F4 FF 0F 84 02 01 00 00 83 7D F4 FE 0F 84 F8 00 00 00 8B 4D F4 89 4D E8 8B 55 E8 83 C2 06 89 55 E8 83 7D E8 03 0F 87 AD 00 00 00 8B 45 E8 FF 24 85 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 85 C9 75 DA E9 9E 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 85 D2 75 DA EB 76 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 85 C0 75 DA EB 4E 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 85 C9 75 DA EB 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 85 D2 75 DA C7 45 FC 00 00 00 00 E9 09 02 00 00 C7 45 FC 01 00 00 00 A1 ?? ?? ?? ?? 89 45 F8 EB 08 8B 4D F8 8B 11 89 55 F8 83 7D F8 00 0F 84 E6 01 00 00 C7 45 F0 01 00 00 00 8B 45 F8 8B 48 14 81 E1 FF FF 00 00 83 F9 04 74 23 8B 55 F8 83 7A 14 01 74 1A 8B 45 F8 8B 48 14 81 E1 FF FF 00 00 83 F9 02 74 09 8B 55 F8 83 7A 14 03 75 18 8B 45 F8 8B 48 14 81 E1 FF FF 00 00 8B 14 8D ?? ?? ?? ?? 89 55 EC EB 07 C7 45 EC ?? ?? ?? ?? 6A 04 A0 ?? ?? ?? ?? 50 8B 4D F8 83 C1 1C 51 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 3A 8B 55 F8 83 C2 20 52 8B 45 F8 8B 48 18 51 8B 55 EC 52 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 20 83 F8 01 75 01 CC 33 C0 85 C0 75 CD C7 45 F0 00 00 00 00 6A 04 8A 0D ?? ?? ?? ?? 51 8B 55 F8 8B 42 10 8B 4D F8 8D 54 01 20 52 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 3A 8B 45 F8 83 C0 20 50 8B 4D F8 8B 51 18 52 8B 45 EC 50 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 20 83 F8 01 75 01 CC 33 C9 85 C9 75 CD C7 45 F0 00 00 00 00 8B 55 F8 83 7A 14 00 75 50 8B 45 F8 8B 48 10 51 8A 15 ?? ?? ?? ?? 52 8B 45 F8 83 C0 20 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 2F 8B 4D F8 83 C1 20 51 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 85 D2 75 D8 C7 45 F0 00 00 00 00 83 7D F0 00 75 76 8B 45 F8 83 78 08 00 74 33 8B 4D F8 8B 51 0C 52 8B 45 F8 8B 48 08 51 8B 55 EC 52 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 20 83 F8 01 75 01 CC 33 C0 85 C0 75 CD 8B 4D F8 8B 51 10 52 8B 45 F8 83 C0 20 50 8B 4D EC 51 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 20 83 F8 01 75 01 CC 33 D2 85 D2 75 CD C7 45 FC 00 00 00 00 E9 08 FE FF FF 8B 45 FC 5F 5E 5B 8B E5 5D C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_418_22_0 {
	meta:
		name = "__CrtSetDbgFlag"
		size = 34
		refs = "0005 __crtDbgFlag"
	strings:
		$1 = { 55 8B EC 51 A1 ?? ?? ?? ?? 89 45 FC 83 7D 08 FF 74 09 8B 4D 08 89 0D ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_418_23_0 {
	meta:
		name = "__CrtDoForAllClientObjects"
		size = 83
		refs = "0005 __crtDbgFlag 0014 __pFirstBlock"
	strings:
		$1 = { 55 8B EC 51 A1 ?? ?? ?? ?? 83 E0 01 85 C0 75 02 EB 3D 8B 0D ?? ?? ?? ?? 89 4D FC EB 08 8B 55 FC 8B 02 89 45 FC 83 7D FC 00 74 24 8B 4D FC 8B 51 14 81 E2 FF FF 00 00 83 FA 04 75 11 8B 45 0C 50 8B 4D FC 83 C1 20 51 FF 55 08 83 C4 08 EB CE 8B E5 5D C3 }
	condition:
		$1
}

rule file_418_24_0 {
	meta:
		name = "__CrtIsValidPointer"
		size = 75
		refs = "0014 __imp__IsBadReadPtr@8 002c __imp__IsBadWritePtr@8"
	strings:
		$1 = { 55 8B EC 51 83 7D 08 00 74 33 8B 45 0C 50 8B 4D 08 51 FF 15 ?? ?? ?? ?? 85 C0 75 21 83 7D 10 00 74 12 8B 55 0C 52 8B 45 08 50 FF 15 ?? ?? ?? ?? 85 C0 75 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_418_25_0 {
	meta:
		name = "__CrtIsValidHeapPointer"
		size = 292
		refs = "001f __CrtIsValidPointer 0033 ___active_heap 0042 ___sbh_find_block 005e ___sbh_verify_block 006c __osver 008e __crtheap 0095 __imp__HeapValidate@12 00b7 ___old_sbh_find_block"
	strings:
		$1 = { 55 8B EC 83 EC 10 83 7D 08 00 75 07 33 C0 E9 0D 01 00 00 6A 01 6A 20 8B 45 08 83 E8 20 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 07 33 C0 E9 EF 00 00 00 83 3D ?? ?? ?? ?? 03 75 64 8B 4D 08 83 E9 20 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 83 7D FC 00 74 18 8B 55 08 83 EA 20 52 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 E9 B6 00 00 00 8B 0D ?? ?? ?? ?? 81 E1 00 80 00 00 85 C9 74 0A B8 01 00 00 00 E9 9C 00 00 00 8B 55 08 83 EA 20 52 6A 00 A1 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? E9 82 00 00 00 83 3D ?? ?? ?? ?? 02 75 63 8D 4D F8 51 8D 55 F0 52 8B 45 08 83 E8 20 50 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F4 83 7D F4 00 74 16 8B 4D F4 33 D2 8A 11 85 D2 74 07 B8 01 00 00 00 EB 47 33 C0 EB 43 A1 ?? ?? ?? ?? 25 00 80 00 00 85 C0 74 07 B8 01 00 00 00 EB 2E 8B 4D 08 83 E9 20 51 6A 00 8B 15 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? EB 16 8B 45 08 83 E8 20 50 6A 00 8B 0D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_418_26_0 {
	meta:
		name = "__CrtIsMemoryBlock"
		size = 209
		refs = "000b __CrtIsValidHeapPointer 0063 __CrtIsValidPointer 0081 __lRequestCurr"
	strings:
		$1 = { 55 8B EC 83 EC 08 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 07 33 C0 E9 B0 00 00 00 8B 4D 08 83 E9 20 89 4D FC 8B 55 FC 8B 42 14 25 FF FF 00 00 83 F8 04 74 22 8B 4D FC 83 79 14 01 74 19 8B 55 FC 8B 42 14 25 FF FF 00 00 83 F8 02 74 09 8B 4D FC 83 79 14 03 75 6B 6A 01 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 55 8B 4D FC 8B 51 10 3B 55 0C 75 4A 8B 45 FC 8B 48 18 3B 0D ?? ?? ?? ?? 7F 3C 83 7D 10 00 74 0B 8B 55 10 8B 45 FC 8B 48 18 89 0A 83 7D 14 00 74 0B 8B 55 14 8B 45 FC 8B 48 08 89 0A 83 7D 18 00 74 0B 8B 55 18 8B 45 FC 8B 48 0C 89 0A C7 45 F8 01 00 00 00 EB 07 C7 45 F8 00 00 00 00 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_418_28_0 {
	meta:
		name = "__CrtMemCheckpoint"
		size = 342
		refs = "0010 ??_C@_0CI@GMAO@_CrtMemCheckPoint?3?5NULL?5state?5po@ 0015 ??_C@_02DILL@?$CFs?$AA@ 0022 __CrtDbgReport 003f __pFirstBlock 0112 ??_C@_0CD@MEMI@Bad?5memory?5block?5found?5at?50x?$CF08X@ 013c __lMaxAlloc 0148 __lTotalAlloc"
	strings:
		$1 = { 55 8B EC 83 EC 08 53 56 57 83 7D 08 00 75 2B 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 85 C0 75 DA E9 15 01 00 00 8B 4D 08 8B 15 ?? ?? ?? ?? 89 11 C7 45 FC 00 00 00 00 EB 09 8B 45 FC 83 C0 01 89 45 FC 83 7D FC 05 7D 1E 8B 4D FC 8B 55 08 C7 44 8A 18 00 00 00 00 8B 45 FC 8B 4D 08 C7 44 81 04 00 00 00 00 EB D3 8B 15 ?? ?? ?? ?? 89 55 F8 EB 08 8B 45 F8 8B 08 89 4D F8 83 7D F8 00 0F 84 9F 00 00 00 8B 55 F8 8B 42 14 25 FF FF 00 00 85 C0 7C 66 8B 4D F8 8B 51 14 81 E2 FF FF 00 00 83 FA 05 7D 55 8B 45 F8 8B 48 14 81 E1 FF FF 00 00 8B 55 08 8B 44 8A 04 83 C0 01 8B 4D F8 8B 51 14 81 E2 FF FF 00 00 8B 4D 08 89 44 91 04 8B 55 F8 8B 42 14 25 FF FF 00 00 8B 4D 08 8B 54 81 18 8B 45 F8 03 50 10 8B 4D F8 8B 41 14 25 FF FF 00 00 8B 4D 08 89 54 81 18 EB 25 8B 55 F8 52 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 85 C0 75 DB E9 4F FF FF FF 8B 4D 08 8B 15 ?? ?? ?? ?? 89 51 2C 8B 45 08 8B 0D ?? ?? ?? ?? 89 48 30 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_418_29_0 {
	meta:
		name = "__CrtMemDifference"
		size = 291
		refs = "0023 ??_C@_0CI@MNAE@_CrtMemDifference?3?5NULL?5state?5po@ 0028 ??_C@_02DILL@?$CFs?$AA@ 0035 __CrtDbgReport 00d5 __crtDbgFlag"
	strings:
		$1 = { 55 8B EC 83 EC 08 53 56 57 C7 45 F8 00 00 00 00 83 7D 08 00 74 0C 83 7D 0C 00 74 06 83 7D 10 00 75 2E 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 85 C0 75 DA 8B 45 F8 E9 CC 00 00 00 C7 45 FC 00 00 00 00 EB 09 8B 4D FC 83 C1 01 89 4D FC 83 7D FC 05 0F 8D 80 00 00 00 8B 55 FC 8B 45 10 8B 4D FC 8B 75 0C 8B 54 90 18 2B 54 8E 18 8B 45 FC 8B 4D 08 89 54 81 18 8B 55 FC 8B 45 10 8B 4D FC 8B 75 0C 8B 54 90 04 2B 54 8E 04 8B 45 FC 8B 4D 08 89 54 81 04 8B 55 FC 8B 45 08 83 7C 90 18 00 75 0D 8B 4D FC 8B 55 08 83 7C 8A 04 00 74 25 83 7D FC 00 74 1F 83 7D FC 02 75 12 83 7D FC 02 75 13 A1 ?? ?? ?? ?? 83 E0 10 85 C0 74 07 C7 45 F8 01 00 00 00 E9 6D FF FF FF 8B 4D 10 8B 55 0C 8B 41 2C 2B 42 2C 8B 4D 08 89 41 2C 8B 55 10 8B 45 0C 8B 4A 30 2B 48 30 8B 55 08 89 4A 30 8B 45 08 C7 00 00 00 00 00 8B 45 F8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_418_30_0 {
	meta:
		name = "__CrtMemDumpAllObjectsSince"
		size = 677
		refs = "0011 ??_C@_0BE@FPPM@Dumping?5objects?5?9?$DO?6?$AA@ 0016 ??_C@_02DILL@?$CFs?$AA@ 0023 __CrtDbgReport 0045 __pFirstBlock 009f __crtDbgFlag 00c4 __CrtIsValidPointer 00d7 ??_C@_0BE@FEMA@?$CDFile?5Error?$CD?$CI?$CFd?$CJ?5?3?5?$AA@ 0108 ??_C@_0L@BLDJ@?$CFhs?$CI?$CFd?$CJ?5?3?5?$AA@ 0130 ??_C@_06MBCE@?$HL?$CFld?$HN?5?$AA@ 017f ??_C@_0DE@PFEA@client?5block?5at?50x?$CF08X?0?5subtype?5@ 01a1 __pfnDumpClient 01c6 __printMemBlockData 01ea ??_C@_0CI@JLM@normal?5block?5at?50x?$CF08X?0?5?$CFu?5bytes@ 0247 ??_C@_0DB@DBPF@crt?5block?5at?50x?$CF08X?0?5subtype?5?$CFx?0@ 0279 ??_C@_0BH@PKIJ@Object?5dump?5complete?4?6?$AA@"
	strings:
		$1 = { 55 8B EC 83 EC 08 53 56 57 C7 45 F8 00 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 85 C0 75 DA 83 7D 08 00 74 08 8B 4D 08 8B 11 89 55 F8 A1 ?? ?? ?? ?? 89 45 FC EB 08 8B 4D FC 8B 11 89 55 FC 83 7D FC 00 0F 84 18 02 00 00 8B 45 FC 3B 45 F8 0F 84 0C 02 00 00 8B 4D FC 8B 51 14 81 E2 FF FF 00 00 83 FA 03 74 2D 8B 45 FC 8B 48 14 81 E1 FF FF 00 00 85 C9 74 1D 8B 55 FC 8B 42 14 25 FF FF 00 00 83 F8 02 75 12 8B 0D ?? ?? ?? ?? 83 E1 10 85 C9 75 05 E9 C4 01 00 00 8B 55 FC 83 7A 08 00 74 70 6A 00 6A 01 8B 45 FC 8B 48 08 51 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 2A 8B 55 FC 8B 42 0C 50 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 85 C9 75 D8 EB 2F 8B 55 FC 8B 42 0C 50 8B 4D FC 8B 51 08 52 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 1C 83 F8 01 75 01 CC 33 C0 85 C0 75 D1 8B 4D FC 8B 51 18 52 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 85 C0 75 D8 8B 4D FC 8B 51 14 81 E2 FF FF 00 00 83 FA 04 75 71 8B 45 FC 8B 48 10 51 8B 55 FC 8B 42 14 C1 F8 10 25 FF FF 00 00 50 8B 4D FC 83 C1 20 51 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 20 83 F8 01 75 01 CC 33 D2 85 D2 75 C2 83 3D ?? ?? ?? ?? 00 74 19 8B 45 FC 8B 48 10 51 8B 55 FC 83 C2 20 52 FF 15 ?? ?? ?? ?? 83 C4 08 EB 0C 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 E9 A1 00 00 00 8B 4D FC 83 79 14 01 75 3D 8B 55 FC 8B 42 10 50 8B 4D FC 83 C1 20 51 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 1C 83 F8 01 75 01 CC 33 D2 85 D2 75 D1 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 EB 5B 8B 4D FC 8B 51 14 81 E2 FF FF 00 00 83 FA 02 75 4A 8B 45 FC 8B 48 10 51 8B 55 FC 8B 42 14 C1 F8 10 25 FF FF 00 00 50 8B 4D FC 83 C1 20 51 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 20 83 F8 01 75 01 CC 33 D2 85 D2 75 C2 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 E9 D6 FD FF FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 85 C9 75 DA 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_418_31_0 {
	meta:
		name = "__printMemBlockData"
		size = 276
		refs = "0050 ___mb_cur_max 0067 __isctype 007d __pctype 00c0 ??_C@_05JLAO@?$CF?42X?5?$AA@ 00d0 _sprintf 00ed ??_C@_0BA@POLM@?5Data?3?5?$DM?$CFs?$DO?5?$CFs?6?$AA@ 00fa __CrtDbgReport"
	strings:
		$1 = { 55 8B EC 83 EC 5C 53 56 57 C7 45 B4 00 00 00 00 EB 09 8B 45 B4 83 C0 01 89 45 B4 8B 4D 08 83 79 10 10 7D 0B 8B 55 08 8B 42 10 89 45 AC EB 07 C7 45 AC 10 00 00 00 8B 4D B4 3B 4D AC 0F 8D 9A 00 00 00 8B 55 08 03 55 B4 8A 42 20 88 45 B0 83 3D ?? ?? ?? ?? 01 7E 1C 68 57 01 00 00 8B 4D B0 81 E1 FF 00 00 00 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 A8 EB 1D 8B 55 B0 81 E2 FF 00 00 00 A1 ?? ?? ?? ?? 33 C9 66 8B 0C 50 81 E1 57 01 00 00 89 4D A8 83 7D A8 00 74 0E 8B 55 B0 81 E2 FF 00 00 00 89 55 A4 EB 07 C7 45 A4 20 00 00 00 8B 45 B4 8A 4D A4 88 4C 05 B8 8B 55 B0 81 E2 FF 00 00 00 52 68 ?? ?? ?? ?? 8B 45 B4 6B C0 03 8D 4C 05 CC 51 E8 ?? ?? ?? ?? 83 C4 0C E9 36 FF FF FF 8B 55 B4 C6 44 15 B8 00 8D 45 CC 50 8D 4D B8 51 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 1C 83 F8 01 75 01 CC 33 D2 85 D2 75 D7 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_418_32_0 {
	meta:
		name = "__CrtDumpMemoryLeaks"
		size = 116
		refs = "000e __CrtMemCheckpoint 0023 __crtDbgFlag 0035 ??_C@_0BI@KONA@Detected?5memory?5leaks?$CB?6?$AA@ 003a ??_C@_02DILL@?$CFs?$AA@ 0047 __CrtDbgReport 005d __CrtMemDumpAllObjectsSince"
	strings:
		$1 = { 55 8B EC 83 EC 34 53 56 57 8D 45 CC 50 E8 ?? ?? ?? ?? 83 C4 04 83 7D E0 00 75 19 83 7D D4 00 75 13 8B 0D ?? ?? ?? ?? 83 E1 10 85 C9 74 3D 83 7D D8 00 74 37 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 85 D2 75 DA 6A 00 E8 ?? ?? ?? ?? 83 C4 04 B8 01 00 00 00 EB 02 33 C0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_418_33_0 {
	meta:
		name = "__CrtMemDumpStatistics"
		size = 197
		refs = "0030 _szBlockUseName 004c ??_C@_0BO@MEJD@?$CFld?5bytes?5in?5?$CFld?5?$CFhs?5Blocks?4?6?$AA@ 0059 __CrtDbgReport 0076 ??_C@_0CB@COID@Largest?5number?5used?3?5?$CFld?5bytes?4?6@ 009e ??_C@_0BP@LCCN@Total?5allocations?3?5?$CFld?5bytes?4?6?$AA@"
	strings:
		$1 = { 55 8B EC 51 53 56 57 83 7D 08 00 75 05 E9 AC 00 00 00 C7 45 FC 00 00 00 00 EB 09 8B 45 FC 83 C0 01 89 45 FC 83 7D FC 05 7D 44 8B 4D FC 8B 14 8D ?? ?? ?? ?? 52 8B 45 FC 8B 4D 08 8B 54 81 04 52 8B 45 FC 8B 4D 08 8B 54 81 18 52 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 20 83 F8 01 75 01 CC 33 C0 85 C0 75 BE EB AD 8B 4D 08 8B 51 2C 52 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 85 C0 75 D8 8B 4D 08 8B 51 30 52 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 85 C0 75 D8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_420_0_0 {
	meta:
		name = "___tzset"
		size = 41
		refs = "0005 _?first_time@?1??__tzset@@9@9 0016 __tzset"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? 00 75 1B 83 3D ?? ?? ?? ?? 00 75 12 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 83 C0 01 A3 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_420_1_0 {
	meta:
		name = "__tzset"
		size = 889
		refs = "000f _tzapiused 0019 _dstend 0027 _dststart 002c ??_C@_02JHIA@TZ?$AA@ 0031 _getenv 0046 _tzinfo 004c __imp__GetTimeZoneInformation@4 006e __timezone 00ad __daylight 00c4 __dstbias 00e8 __tzname 00fa ___lc_codepage 0101 __imp__WideCharToMultiByte@32 017b _lastTZ 018e _strcmp 01a7 __free_dbg 01b4 ??_C@_07DEKI@tzset?4c?$AA@ 01bf _strlen 01cb __malloc_dbg 01f0 _strcpy 0205 _strncpy 0240 _atol"
	strings:
		$1 = { 55 8B EC 83 EC 0C C7 45 FC 00 00 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 C7 05 ?? ?? ?? ?? FF FF FF FF A1 ?? ?? ?? ?? A3 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 89 45 F4 83 7D F4 00 0F 85 2A 01 00 00 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 83 F8 FF 0F 84 11 01 00 00 C7 05 ?? ?? ?? ?? 01 00 00 00 8B 0D ?? ?? ?? ?? 6B C9 3C 89 0D ?? ?? ?? ?? 33 D2 66 8B 15 ?? ?? ?? ?? 85 D2 74 16 A1 ?? ?? ?? ?? 6B C0 3C 8B 0D ?? ?? ?? ?? 03 C8 89 0D ?? ?? ?? ?? 33 D2 66 8B 15 ?? ?? ?? ?? 85 D2 74 28 83 3D ?? ?? ?? ?? 00 74 1F C7 05 ?? ?? ?? ?? 01 00 00 00 A1 ?? ?? ?? ?? 2B 05 ?? ?? ?? ?? 6B C0 3C A3 ?? ?? ?? ?? EB 14 C7 05 ?? ?? ?? ?? 00 00 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 8D 4D F8 51 6A 00 6A 3F 8B 15 ?? ?? ?? ?? 52 6A FF 68 ?? ?? ?? ?? 68 20 02 00 00 A1 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 74 12 83 7D F8 00 75 0C 8B 0D ?? ?? ?? ?? C6 41 3F 00 EB 09 8B 15 ?? ?? ?? ?? C6 02 00 8D 45 F8 50 6A 00 6A 3F 8B 0D ?? ?? ?? ?? 51 6A FF 68 ?? ?? ?? ?? 68 20 02 00 00 8B 15 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 85 C0 74 11 83 7D F8 00 75 0B A1 ?? ?? ?? ?? C6 40 3F 00 EB 09 8B 0D ?? ?? ?? ?? C6 01 00 E9 06 02 00 00 8B 55 F4 0F BE 02 85 C0 74 20 83 3D ?? ?? ?? ?? 00 74 1C 8B 0D ?? ?? ?? ?? 51 8B 55 F4 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 05 E9 D7 01 00 00 6A 02 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 08 68 0C 01 00 00 68 ?? ?? ?? ?? 6A 02 8B 4D F4 51 E8 ?? ?? ?? ?? 83 C4 04 83 C0 01 50 E8 ?? ?? ?? ?? 83 C4 10 A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 75 05 E9 90 01 00 00 8B 55 F4 52 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 08 6A 03 8B 4D F4 51 8B 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 0C A1 ?? ?? ?? ?? C6 40 03 00 8B 4D F4 83 C1 03 89 4D F4 8B 55 F4 0F BE 02 83 F8 2D 75 12 8B 4D FC 83 C1 01 89 4D FC 8B 55 F4 83 C2 01 89 55 F4 8B 45 F4 50 E8 ?? ?? ?? ?? 83 C4 04 69 C0 10 0E 00 00 A3 ?? ?? ?? ?? 8B 4D F4 0F BE 11 83 FA 2B 74 16 8B 45 F4 0F BE 08 83 F9 30 7C 16 8B 55 F4 0F BE 02 83 F8 39 7F 0B 8B 4D F4 83 C1 01 89 4D F4 EB D4 8B 55 F4 0F BE 02 83 F8 3A 0F 85 96 00 00 00 8B 4D F4 83 C1 01 89 4D F4 8B 55 F4 52 E8 ?? ?? ?? ?? 83 C4 04 6B C0 3C 8B 0D ?? ?? ?? ?? 03 C8 89 0D ?? ?? ?? ?? 8B 55 F4 0F BE 02 83 F8 30 7C 16 8B 4D F4 0F BE 11 83 FA 39 7F 0B 8B 45 F4 83 C0 01 89 45 F4 EB DF 8B 4D F4 0F BE 11 83 FA 3A 75 44 8B 45 F4 83 C0 01 89 45 F4 8B 4D F4 51 E8 ?? ?? ?? ?? 83 C4 04 8B 15 ?? ?? ?? ?? 03 D0 89 15 ?? ?? ?? ?? 8B 45 F4 0F BE 08 83 F9 30 7C 16 8B 55 F4 0F BE 02 83 F8 39 7F 0B 8B 4D F4 83 C1 01 89 4D F4 EB DF 83 7D FC 00 74 0E 8B 15 ?? ?? ?? ?? F7 DA 89 15 ?? ?? ?? ?? 8B 45 F4 0F BE 08 89 0D ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 74 20 6A 03 8B 55 F4 52 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 0D ?? ?? ?? ?? C6 41 03 00 EB 09 8B 15 ?? ?? ?? ?? C6 02 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_420_2_0 {
	meta:
		name = "__isindst"
		size = 762
		refs = "0006 __daylight 001c _dststart 002a _dstend 0036 _tzapiused 0046 _tzinfo 00a0 _cvtdate"
	strings:
		$1 = { 55 8B EC 51 83 3D ?? ?? ?? ?? 00 75 07 33 C0 E9 E2 02 00 00 8B 45 08 8B 48 14 3B 0D ?? ?? ?? ?? 75 12 8B 55 08 8B 42 14 3B 05 ?? ?? ?? ?? 0F 84 C7 01 00 00 83 3D ?? ?? ?? ?? 00 0F 84 74 01 00 00 33 C9 66 8B 0D ?? ?? ?? ?? 85 C9 75 5B 33 D2 66 8B 15 ?? ?? ?? ?? 52 33 C0 66 A1 ?? ?? ?? ?? 50 33 C9 66 8B 0D ?? ?? ?? ?? 51 33 D2 66 8B 15 ?? ?? ?? ?? 52 6A 00 33 C0 66 A1 ?? ?? ?? ?? 50 33 C9 66 8B 0D ?? ?? ?? ?? 51 33 D2 66 8B 15 ?? ?? ?? ?? 52 8B 45 08 8B 48 14 51 6A 01 6A 01 E8 ?? ?? ?? ?? 83 C4 2C EB 51 33 D2 66 8B 15 ?? ?? ?? ?? 52 33 C0 66 A1 ?? ?? ?? ?? 50 33 C9 66 8B 0D ?? ?? ?? ?? 51 33 D2 66 8B 15 ?? ?? ?? ?? 52 33 C0 66 A1 ?? ?? ?? ?? 50 6A 00 6A 00 33 C9 66 8B 0D ?? ?? ?? ?? 51 8B 55 08 8B 42 14 50 6A 00 6A 01 E8 ?? ?? ?? ?? 83 C4 2C 33 C9 66 8B 0D ?? ?? ?? ?? 85 C9 75 5B 33 D2 66 8B 15 ?? ?? ?? ?? 52 33 C0 66 A1 ?? ?? ?? ?? 50 33 C9 66 8B 0D ?? ?? ?? ?? 51 33 D2 66 8B 15 ?? ?? ?? ?? 52 6A 00 33 C0 66 A1 ?? ?? ?? ?? 50 33 C9 66 8B 0D ?? ?? ?? ?? 51 33 D2 66 8B 15 ?? ?? ?? ?? 52 8B 45 08 8B 48 14 51 6A 01 6A 00 E8 ?? ?? ?? ?? 83 C4 2C EB 51 33 D2 66 8B 15 ?? ?? ?? ?? 52 33 C0 66 A1 ?? ?? ?? ?? 50 33 C9 66 8B 0D ?? ?? ?? ?? 51 33 D2 66 8B 15 ?? ?? ?? ?? 52 33 C0 66 A1 ?? ?? ?? ?? 50 6A 00 6A 00 33 C9 66 8B 0D ?? ?? ?? ?? 51 8B 55 08 8B 42 14 50 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 2C EB 46 6A 00 6A 00 6A 00 6A 02 6A 00 6A 00 6A 01 6A 04 8B 4D 08 8B 51 14 52 6A 01 6A 01 E8 ?? ?? ?? ?? 83 C4 2C 6A 00 6A 00 6A 00 6A 02 6A 00 6A 00 6A 05 6A 0A 8B 45 08 8B 48 14 51 6A 01 6A 00 E8 ?? ?? ?? ?? 83 C4 2C 8B 15 ?? ?? ?? ?? 3B 15 ?? ?? ?? ?? 7D 4B 8B 45 08 8B 48 1C 3B 0D ?? ?? ?? ?? 7C 0E 8B 55 08 8B 42 1C 3B 05 ?? ?? ?? ?? 7E 07 33 C0 E9 CA 00 00 00 8B 4D 08 8B 51 1C 3B 15 ?? ?? ?? ?? 7E 18 8B 45 08 8B 48 1C 3B 0D ?? ?? ?? ?? 7D 0A B8 01 00 00 00 E9 A4 00 00 00 EB 43 8B 55 08 8B 42 1C 3B 05 ?? ?? ?? ?? 7C 0E 8B 4D 08 8B 51 1C 3B 15 ?? ?? ?? ?? 7E 07 B8 01 00 00 00 EB 7F 8B 45 08 8B 48 1C 3B 0D ?? ?? ?? ?? 7E 12 8B 55 08 8B 42 1C 3B 05 ?? ?? ?? ?? 7D 04 33 C0 EB 5F 8B 4D 08 8B 51 04 6B D2 3C 8B 45 08 8B 08 03 CA 8B 55 08 8B 42 08 69 C0 10 0E 00 00 03 C8 69 C9 E8 03 00 00 89 4D FC 8B 4D 08 8B 51 1C 3B 15 ?? ?? ?? ?? 75 16 8B 45 FC 3B 05 ?? ?? ?? ?? 7C 07 B8 01 00 00 00 EB 18 33 C0 EB 14 8B 4D FC 3B 0D ?? ?? ?? ?? 7D 07 B8 01 00 00 00 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_420_3_0 {
	meta:
		name = "_cvtdate"
		size = 504
		refs = "0020 __lpdays 002f __days 011b _dststart 0155 _dstend 017f __dstbias"
	strings:
		$1 = { 55 8B EC 83 EC 14 83 7D 0C 01 0F 85 CC 00 00 00 8B 45 10 83 E0 03 85 C0 75 0F 8B 4D 14 8B 14 8D ?? ?? ?? ?? 89 55 F4 EB 0D 8B 45 14 8B 0C 85 ?? ?? ?? ?? 89 4D F4 8B 55 F4 83 C2 01 89 55 F8 8B 45 10 83 E8 46 69 C0 6D 01 00 00 8B 4D F8 03 C8 8B 55 10 83 EA 01 C1 FA 02 8D 44 11 F3 99 B9 07 00 00 00 F7 F9 89 55 FC 8B 55 FC 3B 55 1C 7F 19 8B 45 1C 2B 45 FC 8B 4D 18 83 E9 01 6B C9 07 03 4D F8 03 C8 89 4D F8 EB 14 8B 55 1C 2B 55 FC 8B 45 18 6B C0 07 03 45 F8 03 C2 89 45 F8 83 7D 18 05 75 37 8B 4D 10 83 E1 03 85 C9 75 0F 8B 55 14 8B 04 95 ?? ?? ?? ?? 89 45 F0 EB 0D 8B 4D 14 8B 14 8D ?? ?? ?? ?? 89 55 F0 8B 45 F8 3B 45 F0 7E 09 8B 4D F8 83 E9 07 89 4D F8 EB 35 8B 55 10 83 E2 03 85 D2 75 0F 8B 45 14 8B 0C 85 ?? ?? ?? ?? 89 4D EC EB 0D 8B 55 14 8B 04 95 ?? ?? ?? ?? 89 45 EC 8B 4D EC 89 4D F8 8B 55 F8 03 55 20 89 55 F8 83 7D 08 01 75 3A 8B 45 F8 A3 ?? ?? ?? ?? 8B 4D 24 6B C9 3C 8B 55 28 03 D1 6B D2 3C 8B 45 2C 03 C2 69 C0 E8 03 00 00 8B 4D 30 03 C8 89 0D ?? ?? ?? ?? 8B 55 10 89 15 ?? ?? ?? ?? E9 A3 00 00 00 8B 45 F8 A3 ?? ?? ?? ?? 8B 4D 24 6B C9 3C 8B 55 28 03 D1 6B D2 3C 8B 45 2C 03 C2 69 C0 E8 03 00 00 8B 4D 30 03 C8 89 0D ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 69 D2 E8 03 00 00 A1 ?? ?? ?? ?? 03 C2 A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 7D 23 8B 0D ?? ?? ?? ?? 81 C1 00 5C 26 05 89 0D ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 83 EA 01 89 15 ?? ?? ?? ?? EB 2A 81 3D ?? ?? ?? ?? 00 5C 26 05 7C 1E A1 ?? ?? ?? ?? 2D 00 5C 26 05 A3 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 83 C1 01 89 0D ?? ?? ?? ?? 8B 55 10 89 15 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_421_0_0 {
	meta:
		name = "__free_base"
		size = 197
		refs = "0013 ___active_heap 001f ___sbh_find_block 0038 ___sbh_free_block 004d __crtheap 0054 __imp__HeapFree@12 0070 ___old_sbh_find_block 008d ___old_sbh_free_block"
	strings:
		$1 = { 55 8B EC 83 EC 10 83 7D 08 00 75 05 E9 B0 00 00 00 83 3D ?? ?? ?? ?? 03 75 40 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 83 7D FC 00 74 10 8B 4D 08 51 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 08 83 7D FC 00 75 13 8B 45 08 50 6A 00 8B 0D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? EB 67 83 3D ?? ?? ?? ?? 02 75 4B 8D 55 F8 52 8D 45 F0 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F4 83 7D F4 00 74 14 8B 55 F4 52 8B 45 F8 50 8B 4D F0 51 E8 ?? ?? ?? ?? 83 C4 0C 83 7D F4 00 75 12 8B 55 08 52 6A 00 A1 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? EB 13 8B 4D 08 51 6A 00 8B 15 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_422_0_0 {
	meta:
		name = "__wdospawn"
		size = 884
		refs = "003e $L17700 0058 _errno 0062 __doserrno 00c4 _memset 00d3 __nhandle 0100 ___pioinfo 011f ??_C@_09FGIN@dospawn?4c?$AA@ 0132 __calloc_dbg 02bc __imp__CreateProcessW@40 02c8 __imp__GetLastError@0 02d6 __free_dbg 02eb __dosmaperr 0300 __exit 0312 __imp__WaitForSingleObject@8 0320 __imp__GetExitCodeProcess@8 032a __imp__CloseHandle@4 0360 $L17624 0364 $L17626 0368 $L17625 0370 $L17627"
	strings:
		$1 = { 55 8B EC 81 EC 90 00 00 00 C7 85 78 FF FF FF 00 00 00 00 C6 45 9C 00 8A 45 9C 88 45 98 8A 4D 98 88 4D 80 8B 55 08 89 95 74 FF FF FF 83 BD 74 FF FF FF 04 77 21 8B 85 74 FF FF FF FF 24 85 ?? ?? ?? ?? C6 45 80 01 EB 2A EB 28 C6 45 98 01 EB 22 C6 45 9C 01 EB 1C C7 05 ?? ?? ?? ?? 16 00 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 83 C8 FF E9 EA 02 00 00 8B 4D 10 89 4D 90 8B 55 10 33 C0 66 8B 02 85 C0 74 37 8B 4D 10 33 D2 66 8B 11 85 D2 74 0B 8B 45 10 83 C0 02 89 45 10 EB E9 8B 4D 10 33 D2 66 8B 51 02 85 D2 74 11 8B 45 10 66 C7 00 20 00 8B 4D 10 83 C1 02 89 4D 10 EB BD 6A 44 6A 00 8D 55 A8 52 E8 ?? ?? ?? ?? 83 C4 0C C7 45 A8 44 00 00 00 A1 ?? ?? ?? ?? 89 45 94 EB 09 8B 4D 94 83 E9 01 89 4D 94 83 7D 94 00 74 24 8B 55 94 83 EA 01 C1 FA 05 8B 45 94 83 E8 01 83 E0 1F 8B 0C 95 ?? ?? ?? ?? 0F BE 54 C1 04 85 D2 75 02 EB CD 8B 45 94 6B C0 05 83 C0 04 66 89 45 DA 6A 76 68 ?? ?? ?? ?? 6A 02 6A 01 8B 4D DA 81 E1 FF FF 00 00 51 E8 ?? ?? ?? ?? 83 C4 14 89 45 DC 8B 55 DC 8B 45 94 89 02 8B 4D DC 83 C1 04 89 4D FC 8B 55 94 8B 45 DC 8D 4C 10 04 89 4D 88 C7 45 8C 00 00 00 00 8B 55 DC 83 C2 04 89 55 FC 8B 45 94 8B 4D DC 8D 54 01 04 89 55 88 EB 1B 8B 45 8C 83 C0 01 89 45 8C 8B 4D FC 83 C1 01 89 4D FC 8B 55 88 83 C2 04 89 55 88 8B 45 8C 3B 45 94 7D 4F 8B 4D 8C C1 F9 05 8B 55 8C 83 E2 1F 8B 04 8D ?? ?? ?? ?? 8D 0C D0 89 4D A0 8B 55 A0 0F BE 42 04 83 E0 10 85 C0 75 17 8B 4D FC 8B 55 A0 8A 42 04 88 01 8B 4D 88 8B 55 A0 8B 02 89 01 EB 0F 8B 4D FC C6 01 00 8B 55 88 C7 02 FF FF FF FF EB 8E 0F BE 45 9C 85 C0 74 7F C7 45 8C 00 00 00 00 8B 4D DC 83 C1 04 89 4D FC 8B 55 94 8B 45 DC 8D 4C 10 04 89 4D 88 EB 1B 8B 55 8C 83 C2 01 89 55 8C 8B 45 FC 83 C0 01 89 45 FC 8B 4D 88 83 C1 04 89 4D 88 83 7D 94 03 7D 0B 8B 55 94 89 95 70 FF FF FF EB 0A C7 85 70 FF FF FF 03 00 00 00 8B 45 8C 3B 85 70 FF FF FF 7D 11 8B 4D FC C6 01 00 8B 55 88 C7 02 FF FF FF FF EB AE 8B 85 78 FF FF FF 0C 08 89 85 78 FF FF FF C7 05 ?? ?? ?? ?? 00 00 00 00 8B 0D ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 8B 95 78 FF FF FF 80 CE 04 89 95 78 FF FF FF 8D 45 EC 50 8D 4D A8 51 6A 00 8B 55 14 52 8B 85 78 FF FF FF 50 6A 01 6A 00 6A 00 8B 4D 90 51 8B 55 0C 52 FF 15 ?? ?? ?? ?? 89 85 7C FF FF FF FF 15 ?? ?? ?? ?? 89 45 A4 6A 02 8B 45 DC 50 E8 ?? ?? ?? ?? 83 C4 08 83 BD 7C FF FF FF 00 75 11 8B 4D A4 51 E8 ?? ?? ?? ?? 83 C4 04 83 C8 FF EB 65 83 7D 08 02 75 07 6A 00 E8 ?? ?? ?? ?? 83 7D 08 00 75 26 6A FF 8B 55 EC 52 FF 15 ?? ?? ?? ?? 8D 45 84 50 8B 4D EC 51 FF 15 ?? ?? ?? ?? 8B 55 EC 52 FF 15 ?? ?? ?? ?? EB 1F 83 7D 08 04 75 13 8B 45 EC 50 FF 15 ?? ?? ?? ?? C7 45 84 00 00 00 00 EB 06 8B 4D EC 89 4D 84 8B 55 F0 52 FF 15 ?? ?? ?? ?? 8B 45 84 8B E5 5D C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_423_0_0 {
	meta:
		name = "_wcspbrk"
		size = 89
	strings:
		$1 = { 55 8B EC 51 8B 45 08 33 C9 66 8B 08 85 C9 74 43 8B 55 0C 89 55 FC EB 09 8B 45 FC 83 C0 02 89 45 FC 8B 4D FC 33 D2 66 8B 11 85 D2 74 1B 8B 45 FC 33 C9 66 8B 08 8B 55 08 33 C0 66 8B 02 3B C8 75 05 8B 45 08 EB 0F EB D0 8B 4D 08 83 C1 02 89 4D 08 EB B1 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_424_0_0 {
	meta:
		name = "__mbcjistojms"
		size = 174
		refs = "0008 ___mbcodepage"
	strings:
		$1 = { 55 8B EC 83 EC 08 81 3D ?? ?? ?? ?? A4 03 00 00 74 08 8B 45 08 E9 90 00 00 00 8B 45 08 C1 E8 08 25 FF 00 00 00 89 45 FC 8B 4D 08 81 E1 FF 00 00 00 89 4D F8 83 7D FC 21 72 12 83 7D FC 7E 77 0C 83 7D F8 21 72 06 83 7D F8 7E 76 04 33 C0 EB 5A 8B 55 FC 83 E2 01 85 D2 74 1C 83 7D F8 5F 77 0B 8B 45 F8 83 C0 1F 89 45 F8 EB 09 8B 4D F8 83 C1 20 89 4D F8 EB 09 8B 55 F8 83 C2 7E 89 55 F8 8B 45 FC 83 E8 21 D1 E8 05 81 00 00 00 89 45 FC 81 7D FC 9F 00 00 00 76 09 8B 4D FC 83 C1 40 89 4D FC 8B 45 FC C1 E0 08 0B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_424_1_0 {
	meta:
		name = "__mbcjmstojis"
		size = 271
		refs = "0008 ___mbcodepage 0041 __mbctype"
	strings:
		$1 = { 55 8B EC 83 EC 08 81 3D ?? ?? ?? ?? A4 03 00 00 74 08 8B 45 08 E9 F1 00 00 00 8B 45 08 C1 E8 08 25 FF 00 00 00 89 45 FC 8B 4D 08 81 E1 FF 00 00 00 89 4D F8 8B 55 FC 81 E2 FF 00 00 00 33 C0 8A 82 ?? ?? ?? ?? 83 E0 04 85 C0 74 18 8B 4D F8 81 E1 FF 00 00 00 33 D2 8A 91 ?? ?? ?? ?? 83 E2 08 85 D2 75 07 33 C0 E9 A0 00 00 00 81 7D FC A0 00 00 00 1B C0 24 C0 05 C1 00 00 00 8B 4D FC 2B C8 89 4D FC 81 7D F8 9F 00 00 00 72 1F 8B 55 FC C1 E2 09 81 C2 00 22 00 00 89 55 08 8B 45 F8 83 E8 7E 8B 4D 08 0B C8 89 4D 08 EB 2B 8B 55 FC C1 E2 09 81 C2 00 21 00 00 89 55 08 B8 7E 00 00 00 3B 45 F8 1B C9 F7 D9 83 C1 1F 8B 55 F8 2B D1 8B 45 08 0B C2 89 45 08 81 7D 08 7E 7E 00 00 77 25 81 7D 08 21 21 00 00 72 1C 8B 4D 08 81 E1 FF 00 00 00 83 F9 7E 77 0E 8B 55 08 81 E2 FF 00 00 00 83 FA 21 73 04 33 C0 EB 03 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_426_0_0 {
	meta:
		name = "?terminate@@YAXXZ"
		size = 129
		refs = "0006 $T16626 000b __except_handler3 0011 __except_list 002f ?__pTerminate@@3P6AXXZA 006b _abort"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 EC 08 53 56 57 89 65 E8 C7 45 FC 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 26 C7 45 FC 01 00 00 00 FF 15 ?? ?? ?? ?? C7 45 FC 00 00 00 00 EB 10 B8 01 00 00 00 C3 8B 65 E8 C7 45 FC 00 00 00 00 C7 45 FC FF FF FF FF E8 02 00 00 00 EB 06 E8 ?? ?? ?? ?? C3 8B 4D F0 64 89 0D ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_426_2_0 {
	meta:
		name = "?_inconsistency@@YAXXZ"
		size = 129
		refs = "0006 $T16643 000b __except_handler3 0011 __except_list 002f ?__pInconsistency@@3P6AXXZA 006b ?terminate@@YAXXZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 EC 08 53 56 57 89 65 E8 C7 45 FC 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 26 C7 45 FC 01 00 00 00 FF 15 ?? ?? ?? ?? C7 45 FC 00 00 00 00 EB 10 B8 01 00 00 00 C3 8B 65 E8 C7 45 FC 00 00 00 00 C7 45 FC FF FF FF FF E8 02 00 00 00 EB 06 E8 ?? ?? ?? ?? C3 8B 4D F0 64 89 0D ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_426_1_0 {
	meta:
		name = "?unexpected@@YAXXZ"
		size = 25
		refs = "0005 ?__pUnexpected@@3P6AXXZA 0013 ?terminate@@YAXXZ"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? 00 74 06 FF 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_428_0_0 {
	meta:
		name = "_fscanf"
		size = 132
		refs = "0016 ??_C@_0P@FHEA@stream?5?$CB?$DN?5NULL?$AA@ 001f ??_C@_08KDEN@fscanf?4c?$AA@ 0026 __CrtDbgReport 0040 ??_C@_0P@LNLA@format?5?$CB?$DN?5NULL?$AA@ 0070 __input"
	strings:
		$1 = { 55 8B EC 83 EC 08 53 56 57 8D 45 10 89 45 FC 83 7D 08 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 36 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D6 83 7D 0C 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 37 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 D2 85 D2 75 D6 8B 45 FC 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F8 8B 45 F8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_429_1_0 {
	meta:
		name = "_rand"
		size = 39
		refs = "0004 _holdrand"
	strings:
		$1 = { 55 8B EC A1 ?? ?? ?? ?? 69 C0 FD 43 03 00 05 C3 9E 26 00 A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? C1 F8 10 25 FF 7F 00 00 5D C3 }
	condition:
		$1
}

rule file_430_0_0 {
	meta:
		name = "__strnset"
		size = 24
	strings:
		$1 = { 55 8B EC 57 53 8B 7D 08 8B D7 8B 5D 10 33 C0 8B CB E3 10 F2 AE 75 01 41 }
	condition:
		$1
}

rule file_431_0_0 {
	meta:
		name = "___mbtow_environ"
		size = 173
		refs = "0007 __environ 002c __imp__MultiByteToWideChar@24 0041 ??_C@_0L@KCLJ@mbtowenv?4c?$AA@ 004e __malloc_dbg 0092 ___crtwsetenv"
	strings:
		$1 = { 55 8B EC 83 EC 0C A1 ?? ?? ?? ?? 89 45 F4 8B 4D F4 83 39 00 0F 84 8D 00 00 00 6A 00 6A 00 6A FF 8B 55 F4 8B 02 50 6A 00 6A 01 FF 15 ?? ?? ?? ?? 89 45 F8 83 7D F8 00 75 05 83 C8 FF EB 6B 6A 3C 68 ?? ?? ?? ?? 6A 02 8B 4D F8 D1 E1 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 FC 83 7D FC 00 75 05 83 C8 FF EB 46 8B 55 F8 52 8B 45 FC 50 6A FF 8B 4D F4 8B 11 52 6A 00 6A 01 FF 15 ?? ?? ?? ?? 89 45 F8 83 7D F8 00 75 05 83 C8 FF EB 1E 6A 00 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4D F4 83 C1 04 89 4D F4 E9 67 FF FF FF 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_432_0_0 {
	meta:
		name = "__statfp"
		size = 22
	strings:
		$1 = { 55 8B EC 51 53 56 57 9B DD 7D FC 0F BF 45 FC 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_432_1_0 {
	meta:
		name = "__clrfp"
		size = 23
	strings:
		$1 = { 55 8B EC 51 53 56 57 DD 7D FC DB E2 0F BF 45 FC 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_432_2_0 {
	meta:
		name = "__ctrlfp"
		size = 50
	strings:
		$1 = { 55 8B EC 83 EC 08 53 56 57 9B D9 7D F8 8B 45 08 23 45 0C 0F BF 4D F8 8B 55 0C F7 D2 23 CA 0B C1 66 89 45 FC D9 6D FC 0F BF 45 F8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_432_3_0 {
	meta:
		name = "__set_statfp"
		size = 117
		refs = "0015 _over 0043 _under"
	strings:
		$1 = { 55 8B EC 83 EC 0C 53 56 57 8B 45 08 83 E0 01 85 C0 74 0A DB 2D ?? ?? ?? ?? DB 5D F4 9B 8B 4D 08 83 E1 08 85 C9 74 10 9B DF E0 DB 2D ?? ?? ?? ?? DD 5D F8 9B 9B DF E0 8B 55 08 83 E2 10 85 D2 74 0A DB 2D ?? ?? ?? ?? DD 5D F8 9B 8B 45 08 83 E0 04 85 C0 74 09 D9 EE D9 E8 DE F1 DD D8 9B 8B 4D 08 83 E1 20 85 C9 74 06 D9 EB DD 5D F8 9B 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_433_0_0 {
	meta:
		name = "__wsetenvp"
		size = 331
		refs = "000e __wenvptr 003c _wcslen 0052 ??_C@_09IGKD@stdenvp?4c?$AA@ 0064 __malloc_dbg 0073 __wenviron 0083 __amsg_exit 0104 _wcscpy 0123 __free_dbg 013f ___env_initialized"
	strings:
		$1 = { 55 8B EC 83 EC 10 C7 45 F8 00 00 00 00 A1 ?? ?? ?? ?? 89 45 FC 8B 4D FC 33 D2 66 8B 11 85 D2 74 2E 8B 45 FC 33 C9 66 8B 08 83 F9 3D 74 09 8B 55 F8 83 C2 01 89 55 F8 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D FC 8D 54 41 02 89 55 FC EB C6 6A 6D 68 ?? ?? ?? ?? 6A 02 8B 45 F8 8D 0C 85 04 00 00 00 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 F4 8B 55 F4 89 15 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 75 0A 6A 09 E8 ?? ?? ?? ?? 83 C4 04 A1 ?? ?? ?? ?? 89 45 FC EB 0C 8B 4D F0 8B 55 FC 8D 04 4A 89 45 FC 8B 4D FC 33 D2 66 8B 11 85 D2 74 6D 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 83 C0 01 89 45 F0 8B 4D FC 33 D2 66 8B 11 83 FA 3D 74 49 6A 79 68 ?? ?? ?? ?? 6A 02 8B 45 F0 D1 E0 50 E8 ?? ?? ?? ?? 83 C4 10 8B 4D F4 89 01 8B 55 F4 83 3A 00 75 0A 6A 09 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 50 8B 4D F4 8B 11 52 E8 ?? ?? ?? ?? 83 C4 08 8B 45 F4 83 C0 04 89 45 F4 E9 7B FF FF FF 6A 02 8B 0D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 08 C7 05 ?? ?? ?? ?? 00 00 00 00 8B 55 F4 C7 02 00 00 00 00 C7 05 ?? ?? ?? ?? 01 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_435_0_0 {
	meta:
		name = "__getdiskfree"
		size = 115
		refs = "005d __imp__GetDiskFreeSpaceA@20 0067 __imp__GetLastError@0"
	strings:
		$1 = { 55 8B EC 83 EC 08 83 7D 08 00 75 09 C7 45 F8 00 00 00 00 EB 29 83 7D 08 1A 76 07 B8 57 00 00 00 EB 4D 8D 45 FC 89 45 F8 0F BE 4D 08 83 C1 40 88 4D FC C6 45 FD 3A C6 45 FE 5C C6 45 FF 00 8B 55 0C 52 8B 45 0C 83 C0 04 50 8B 4D 0C 83 C1 0C 51 8B 55 0C 83 C2 08 52 8B 45 F8 50 FF 15 ?? ?? ?? ?? 85 C0 75 08 FF 15 ?? ?? ?? ?? EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_436_0_0 {
	meta:
		name = "_wcstod"
		size = 426
		refs = "001d _iswctype 0036 ??_C@_08HJEI@wcstod?4c?$AA@ 0041 _wcslen 004e __malloc_dbg 008d _wctomb 00c9 __fltin 00da __free_dbg 0145 __HUGE 0163 _errno"
	strings:
		$1 = { 55 8B EC 83 EC 24 8B 45 08 89 45 F8 C7 45 E8 00 00 00 00 6A 08 8B 4D F8 66 8B 11 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 0B 8B 45 F8 83 C0 02 89 45 F8 EB E0 6A 42 68 ?? ?? ?? ?? 6A 02 8B 4D F8 51 E8 ?? ?? ?? ?? 83 C4 04 8D 54 00 02 52 E8 ?? ?? ?? ?? 83 C4 10 89 45 E0 C7 45 E4 00 00 00 00 EB 09 8B 45 E4 83 C0 01 89 45 E4 8B 4D E4 8B 55 F8 33 C0 66 8B 04 4A 85 C0 74 30 8B 4D E4 8B 55 F8 66 8B 04 4A 50 8B 4D E0 03 4D E4 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 DC 83 7D DC 00 7F 02 EB 0B 8B 55 E8 03 55 DC 89 55 E8 EB B7 8B 45 E0 03 45 E8 C6 00 00 8B 4D E8 83 C1 01 89 4D E8 6A 00 6A 00 8B 55 E8 52 8B 45 E0 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 F4 6A 02 8B 4D E0 51 E8 ?? ?? ?? ?? 83 C4 08 83 7D 0C 00 74 11 8B 55 F4 8B 42 04 8B 4D F8 8D 14 41 8B 45 0C 89 10 8B 4D F4 8B 11 89 55 FC 8B 45 FC 25 40 02 00 00 85 C0 74 1E C7 45 EC 00 00 00 00 C7 45 F0 00 00 00 00 83 7D 0C 00 74 08 8B 4D 0C 8B 55 08 89 11 EB 79 8B 45 FC 25 81 00 00 00 85 C0 74 37 8B 4D F8 33 D2 66 8B 11 83 FA 2D 75 0D DD 05 ?? ?? ?? ?? D9 E0 DD 5D EC EB 11 A1 ?? ?? ?? ?? 89 45 EC 8B 0D ?? ?? ?? ?? 89 4D F0 C7 05 ?? ?? ?? ?? 22 00 00 00 EB 36 8B 55 FC 81 E2 00 01 00 00 85 D2 74 1A C7 45 EC 00 00 00 00 C7 45 F0 00 00 00 00 C7 05 ?? ?? ?? ?? 22 00 00 00 EB 0F 8B 45 F4 8B 48 10 89 4D EC 8B 50 14 89 55 F0 DD 45 EC 8B E5 5D C3 }
	condition:
		$1
}

rule file_437_0_0 {
	meta:
		name = "_wcscat"
		size = 84
	strings:
		$1 = { 55 8B EC 51 8B 45 08 89 45 FC 8B 4D FC 33 D2 66 8B 11 85 D2 74 0B 8B 45 FC 83 C0 02 89 45 FC EB E9 8B 4D FC 8B 55 0C 66 8B 02 66 89 01 8B 4D FC 33 D2 66 8B 11 8B 45 FC 83 C0 02 89 45 FC 8B 4D 0C 83 C1 02 89 4D 0C 85 D2 74 02 EB D4 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_437_1_0 {
	meta:
		name = "_wcscpy"
		size = 61
	strings:
		$1 = { 55 8B EC 51 8B 45 08 89 45 FC 8B 4D FC 8B 55 0C 66 8B 02 66 89 01 8B 4D FC 33 D2 66 8B 11 8B 45 FC 83 C0 02 89 45 FC 8B 4D 0C 83 C1 02 89 4D 0C 85 D2 74 02 EB D4 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_438_0_0 {
	meta:
		name = "__splitpath"
		size = 578
		refs = "0019 _strlen 0042 __mbsnbcpy 0094 __mbctype"
	strings:
		$1 = { 55 8B EC 83 EC 20 C7 45 F4 00 00 00 00 C7 45 F8 00 00 00 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 83 F8 01 72 36 8B 4D 08 0F BE 51 01 83 FA 3A 75 2A 83 7D 0C 00 74 19 6A 02 8B 45 08 50 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 0C C6 42 02 00 8B 45 08 83 C0 02 89 45 08 EB 0C 83 7D 0C 00 74 06 8B 4D 0C C6 01 00 C7 45 F4 00 00 00 00 8B 55 08 89 55 FC EB 09 8B 45 FC 83 C0 01 89 45 FC 8B 4D FC 0F BE 11 85 D2 74 55 8B 45 FC 33 C9 8A 08 33 D2 8A 91 ?? ?? ?? ?? 83 E2 04 85 D2 74 0B 8B 45 FC 83 C0 01 89 45 FC EB 32 8B 4D FC 0F BE 11 83 FA 2F 74 0B 8B 45 FC 0F BE 08 83 F9 5C 75 0B 8B 55 FC 83 C2 01 89 55 F4 EB 11 8B 45 FC 0F BE 08 83 F9 2E 75 06 8B 55 FC 89 55 F8 EB 98 83 7D F4 00 74 50 83 7D 10 00 74 42 8B 45 F4 2B 45 08 3D FF 00 00 00 73 0B 8B 4D F4 2B 4D 08 89 4D EC EB 07 C7 45 EC FF 00 00 00 8B 55 EC 89 55 F0 8B 45 F0 50 8B 4D 08 51 8B 55 10 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 10 03 45 F0 C6 00 00 8B 4D F4 89 4D 08 EB 0C 83 7D 10 00 74 06 8B 55 10 C6 02 00 83 7D F8 00 0F 84 A0 00 00 00 8B 45 F8 3B 45 08 0F 82 94 00 00 00 83 7D 14 00 74 43 8B 4D F8 2B 4D 08 81 F9 FF 00 00 00 73 0B 8B 55 F8 2B 55 08 89 55 E8 EB 07 C7 45 E8 FF 00 00 00 8B 45 E8 89 45 F0 8B 4D F0 51 8B 55 08 52 8B 45 14 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D 14 03 4D F0 C6 01 00 83 7D 18 00 74 43 8B 55 FC 2B 55 F8 81 FA FF 00 00 00 73 0B 8B 45 FC 2B 45 F8 89 45 E4 EB 07 C7 45 E4 FF 00 00 00 8B 4D E4 89 4D F0 8B 55 F0 52 8B 45 F8 50 8B 4D 18 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 18 03 55 F0 C6 02 00 EB 54 83 7D 14 00 74 42 8B 45 FC 2B 45 08 3D FF 00 00 00 73 0B 8B 4D FC 2B 4D 08 89 4D E0 EB 07 C7 45 E0 FF 00 00 00 8B 55 E0 89 55 F0 8B 45 F0 50 8B 4D 08 51 8B 55 14 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 14 03 45 F0 C6 00 00 83 7D 18 00 74 06 8B 4D 18 C6 01 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_439_0_0 {
	meta:
		name = "__wspawnv"
		size = 259
		refs = "000d ??_C@_0BB@HLKL@pathname?5?$CB?$DN?5NULL?$AA@ 0016 ??_C@_08PCCO@spawnv?4c?$AA@ 001d __CrtDbgReport 003d ??_C@_0BG@FCLP@?$CKpathname?5?$CB?$DN?5_T?$CI?8?20?8?$CJ?$AA@ 0067 ??_C@_0N@IMCP@argv?5?$CB?$DN?5NULL?$AA@ 0093 ??_C@_0O@IICG@?$CKargv?5?$CB?$DN?5NULL?$AA@ 00c5 ??_C@_0BD@MODE@?$CK?$CKargv?5?$CB?$DN?5_T?$CI?8?20?8?$CJ?$AA@ 00f7 __wspawnve"
	strings:
		$1 = { 55 8B EC 53 56 57 83 7D 0C 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 30 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D6 8B 4D 0C 33 D2 66 8B 11 85 D2 75 1E 68 ?? ?? ?? ?? 6A 00 6A 31 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D0 83 7D 10 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 32 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D6 8B 55 10 83 3A 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 33 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D4 8B 4D 10 8B 11 33 C0 66 8B 02 85 C0 75 1E 68 ?? ?? ?? ?? 6A 00 6A 34 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 CE 6A 00 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 10 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_440_0_0 {
	meta:
		name = "_ftell"
		size = 656
		refs = "0010 ??_C@_0M@KJPK@str?5?$CB?$DN?5NULL?$AA@ 0019 ??_C@_07CMIP@ftell?4c?$AA@ 0020 __CrtDbgReport 005e __lseek 00c0 ___pioinfo 011b _errno"
	strings:
		$1 = { 55 8B EC 83 EC 1C 53 56 57 83 7D 08 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 63 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D6 8B 4D 08 89 4D F4 8B 55 F4 8B 42 10 89 45 F8 8B 4D F4 83 79 04 00 7D 0A 8B 55 F4 C7 42 04 00 00 00 00 6A 01 6A 00 8B 45 F8 50 E8 ?? ?? ?? ?? 83 C4 0C 89 45 E4 83 7D E4 00 7D 08 83 C8 FF E9 13 02 00 00 8B 4D F4 8B 51 0C 81 E2 08 01 00 00 85 D2 75 10 8B 45 F4 8B 4D E4 2B 48 04 8B C1 E9 F3 01 00 00 8B 55 F4 8B 45 F4 8B 0A 2B 48 08 89 4D E8 8B 55 F4 8B 42 0C 83 E0 03 85 C0 74 58 8B 4D F8 C1 F9 05 8B 55 F8 83 E2 1F 8B 04 8D ?? ?? ?? ?? 0F BE 4C D0 04 81 E1 80 00 00 00 85 C9 74 34 8B 55 F4 8B 42 08 89 45 FC EB 09 8B 4D FC 83 C1 01 89 4D FC 8B 55 F4 8B 45 FC 3B 02 73 16 8B 4D FC 0F BE 11 83 FA 0A 75 09 8B 45 E8 83 C0 01 89 45 E8 EB D7 EB 22 8B 4D F4 8B 51 0C 81 E2 80 00 00 00 85 D2 75 12 C7 05 ?? ?? ?? ?? 16 00 00 00 83 C8 FF E9 5E 01 00 00 83 7D E4 00 75 08 8B 45 E8 E9 50 01 00 00 8B 45 F4 8B 48 0C 83 E1 01 85 C9 0F 84 39 01 00 00 8B 55 F4 83 7A 04 00 75 0C C7 45 E8 00 00 00 00 E9 24 01 00 00 8B 45 F4 8B 4D F4 8B 10 2B 51 08 8B 45 F4 8B 48 04 03 CA 89 4D F0 8B 55 F8 C1 FA 05 8B 45 F8 83 E0 1F 8B 0C 95 ?? ?? ?? ?? 0F BE 54 C1 04 81 E2 80 00 00 00 85 D2 0F 84 DF 00 00 00 6A 02 6A 00 8B 45 F8 50 E8 ?? ?? ?? ?? 83 C4 0C 3B 45 E4 75 59 8B 4D F4 8B 51 08 03 55 F0 89 55 EC 8B 45 F4 8B 48 08 89 4D FC EB 09 8B 55 FC 83 C2 01 89 55 FC 8B 45 FC 3B 45 EC 73 16 8B 4D FC 0F BE 11 83 FA 0A 75 09 8B 45 F0 83 C0 01 89 45 F0 EB D9 8B 4D F4 8B 51 0C 81 E2 00 20 00 00 85 D2 74 09 8B 45 F0 83 C0 01 89 45 F0 EB 71 6A 00 8B 4D E4 51 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 0C 81 7D F0 00 02 00 00 77 25 8B 45 F4 8B 48 0C 83 E1 08 85 C9 74 18 8B 55 F4 8B 42 0C 25 00 04 00 00 85 C0 75 09 C7 45 F0 00 02 00 00 EB 09 8B 4D F4 8B 51 18 89 55 F0 8B 45 F8 C1 F8 05 8B 4D F8 83 E1 1F 8B 14 85 ?? ?? ?? ?? 0F BE 44 CA 04 83 E0 04 85 C0 74 09 8B 4D F0 83 C1 01 89 4D F0 8B 55 E4 2B 55 F0 89 55 E4 8B 45 E4 03 45 E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_441_0_0 {
	meta:
		name = "__mbbtype"
		size = 147
		refs = "001f __mbctype 0063 __ctype"
	strings:
		$1 = { 55 8B EC 51 8B 45 0C 89 45 FC 83 7D FC 01 74 02 EB 24 8B 4D 08 81 E1 FF 00 00 00 33 D2 8A 91 ?? ?? ?? ?? 83 E2 08 85 D2 74 07 B8 02 00 00 00 EB 5E 83 C8 FF EB 59 8B 45 08 25 FF 00 00 00 33 C9 8A 88 ?? ?? ?? ?? 83 E1 04 85 C9 74 07 B8 01 00 00 00 EB 3B 8B 55 08 81 E2 FF 00 00 00 33 C0 66 8B 04 55 ?? ?? ?? ?? 25 57 01 00 00 85 C0 75 18 8B 4D 08 81 E1 FF 00 00 00 33 D2 8A 91 ?? ?? ?? ?? 83 E2 03 85 D2 74 04 33 C0 EB 03 83 C8 FF 8B E5 5D C3 }
	condition:
		$1
}

rule file_442_0_0 {
	meta:
		name = "__wstrdate"
		size = 218
		refs = "000c __imp__GetLocalTime@4"
	strings:
		$1 = { 55 8B EC 83 EC 1C 8D 45 E4 50 FF 15 ?? ?? ?? ?? 8B 4D E6 81 E1 FF FF 00 00 89 4D FC 8B 55 EA 81 E2 FF FF 00 00 89 55 F8 8B 45 E4 25 FF FF 00 00 99 B9 64 00 00 00 F7 F9 89 55 F4 8B 55 08 66 C7 42 0A 2F 00 8B 45 08 66 C7 40 04 2F 00 8B 4D 08 66 C7 41 10 00 00 8B 45 FC 99 B9 0A 00 00 00 F7 F9 83 C0 30 8B 55 08 66 89 02 8B 45 FC 99 B9 0A 00 00 00 F7 F9 83 C2 30 8B 45 08 66 89 50 02 8B 45 F8 99 B9 0A 00 00 00 F7 F9 83 C0 30 8B 55 08 66 89 42 06 8B 45 F8 99 B9 0A 00 00 00 F7 F9 83 C2 30 8B 45 08 66 89 50 08 8B 45 F4 99 B9 0A 00 00 00 F7 F9 83 C0 30 8B 55 08 66 89 42 0C 8B 45 F4 99 B9 0A 00 00 00 F7 F9 83 C2 30 8B 45 08 66 89 50 0E 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_443_0_0 {
	meta:
		name = "__ismbcdigit"
		size = 223
		refs = "003c ___ismbcodepage 004d ___mblcid 0054 ___mbcodepage 0066 ___crtGetStringTypeA 00a9 ___mb_cur_max 00b7 __isctype 00c8 __pctype"
	strings:
		$1 = { 55 8B EC 83 EC 10 81 7D 08 FF 00 00 00 0F 86 94 00 00 00 66 C7 45 F8 00 00 33 C0 66 89 45 FA 8B 4D 08 C1 E9 08 81 E1 FF 00 00 00 88 4D FC 8B 55 08 81 E2 FF 00 00 00 88 55 FD 83 3D ?? ?? ?? ?? 00 75 07 33 C0 E9 91 00 00 00 6A 01 A1 ?? ?? ?? ?? 50 8B 0D ?? ?? ?? ?? 51 8D 55 F8 52 6A 02 8D 45 FC 50 6A 01 E8 ?? ?? ?? ?? 83 C4 1C 85 C0 75 04 33 C0 EB 66 8B 4D FA 81 E1 FF FF 00 00 85 C9 75 19 8B 55 F8 81 E2 FF FF 00 00 83 E2 04 85 D2 74 09 C7 45 F4 01 00 00 00 EB 07 C7 45 F4 00 00 00 00 8B 45 F4 EB 34 83 3D ?? ?? ?? ?? 01 7E 13 6A 04 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 F0 EB 15 8B 4D 08 8B 15 ?? ?? ?? ?? 33 C0 66 8B 04 4A 83 E0 04 89 45 F0 8B 45 F0 8B E5 5D C3 }
	condition:
		$1
}

rule file_444_0_0 {
	meta:
		name = "__wcsupr"
		size = 261
		refs = "000f ___lc_handle 0083 ___crtLCMapStringW 0098 ??_C@_08JBHP@wcsupr?4c?$AA@ 00a5 __malloc_dbg 00e9 _wcscpy 00f7 __free_dbg"
	strings:
		$1 = { 55 8B EC 83 EC 0C C7 45 F4 00 00 00 00 83 3D ?? ?? ?? ?? 00 75 52 8B 45 08 89 45 FC EB 09 8B 4D FC 83 C1 02 89 4D FC 8B 55 FC 33 C0 66 8B 02 85 C0 74 2D 8B 4D FC 33 D2 66 8B 11 83 FA 61 7C 1E 8B 45 FC 33 C9 66 8B 08 83 F9 7A 7F 11 8B 55 FC 33 C0 66 8B 02 83 E8 20 8B 4D FC 66 89 01 EB BE 8B 45 08 E9 99 00 00 00 6A 00 6A 00 8B 55 F4 52 6A FF 8B 45 08 50 68 00 02 00 00 8B 0D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 1C 89 45 F8 83 7D F8 00 75 02 EB 5B 6A 55 68 ?? ?? ?? ?? 6A 02 8B 55 F8 D1 E2 52 E8 ?? ?? ?? ?? 83 C4 10 89 45 F4 83 7D F4 00 75 02 EB 39 6A 00 8B 45 F8 50 8B 4D F4 51 6A FF 8B 55 08 52 68 00 02 00 00 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 1C 85 C0 75 02 EB 10 8B 4D F4 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 45 F4 50 E8 ?? ?? ?? ?? 83 C4 08 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_445_0_0 {
	meta:
		name = "_rewind"
		size = 200
		refs = "0010 ??_C@_0M@KJPK@str?5?$CB?$DN?5NULL?$AA@ 0019 ??_C@_08KGLM@rewind?4c?$AA@ 0020 __CrtDbgReport 0047 __flush 0071 ___pioinfo 0080 ___badioinfo 00ba __lseek"
	strings:
		$1 = { 55 8B EC 83 EC 0C 53 56 57 83 7D 08 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 2E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D6 8B 4D 08 89 4D F8 8B 55 F8 8B 42 10 89 45 FC 8B 4D F8 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 F8 8B 42 0C 24 CF 8B 4D F8 89 41 0C 83 7D FC FF 74 1B 8B 55 FC C1 FA 05 8B 45 FC 83 E0 1F 8B 0C 95 ?? ?? ?? ?? 8D 14 C1 89 55 F4 EB 07 C7 45 F4 ?? ?? ?? ?? 8B 45 F4 8A 48 04 80 E1 FD 8B 55 F4 88 4A 04 8B 45 F8 8B 48 0C 81 E1 80 00 00 00 85 C9 74 0E 8B 55 F8 8B 42 0C 24 FC 8B 4D F8 89 41 0C 6A 00 6A 00 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 0C 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_447_0_0 {
	meta:
		name = "__heapadd"
		size = 18
		refs = "0005 _errno"
	strings:
		$1 = { 55 8B EC C7 05 ?? ?? ?? ?? 28 00 00 00 83 C8 FF 5D C3 }
	condition:
		$1
}

rule file_448_0_0 {
	meta:
		name = "__onexit"
		size = 164
		refs = "0007 ___onexitbegin 000d __msize_dbg 0016 ___onexitend 002a ??_C@_08CEA@onexit?4c?$AA@ 004c __realloc_dbg"
	strings:
		$1 = { 55 8B EC 51 6A 02 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 08 8B 0D ?? ?? ?? ?? 2B 0D ?? ?? ?? ?? 83 C1 04 3B C1 73 5C 6A 68 68 ?? ?? ?? ?? 6A 02 6A 02 8B 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 08 83 C0 10 50 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 14 89 45 FC 83 7D FC 00 75 04 33 C0 EB 40 8B 0D ?? ?? ?? ?? 2B 0D ?? ?? ?? ?? C1 F9 02 8B 55 FC 8D 04 8A A3 ?? ?? ?? ?? 8B 4D FC 89 0D ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 8B 45 08 89 02 8B 0D ?? ?? ?? ?? 83 C1 04 89 0D ?? ?? ?? ?? 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_448_1_0 {
	meta:
		name = "_atexit"
		size = 24
		refs = "0008 __onexit"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 F7 D8 1B C0 F7 D8 48 5D C3 }
	condition:
		$1
}

rule file_448_2_0 {
	meta:
		name = "___onexitinit"
		size = 77
		refs = "0009 ??_C@_08CEA@onexit?4c?$AA@ 0015 __malloc_dbg 001d ___onexitbegin 002d __amsg_exit 0047 ___onexitend"
	strings:
		$1 = { 55 8B EC 68 B6 00 00 00 68 ?? ?? ?? ?? 6A 02 68 80 00 00 00 E8 ?? ?? ?? ?? 83 C4 10 A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 75 0A 6A 18 E8 ?? ?? ?? ?? 83 C4 04 A1 ?? ?? ?? ?? C7 00 00 00 00 00 8B 0D ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_449_0_0 {
	meta:
		name = "_vswprintf"
		size = 318
		refs = "0016 ??_C@_0P@OOIN@string?5?$CB?$DN?5NULL?$AA@ 001f ??_C@_0L@DMNN@vswprint?4c?$AA@ 0026 __CrtDbgReport 0040 ??_C@_0P@LNLA@format?5?$CB?$DN?5NULL?$AA@ 0095 __woutput 00df __flsbuf"
	strings:
		$1 = { 55 8B EC 83 EC 30 53 56 57 8D 45 E0 89 45 DC 83 7D 08 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 5C 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D6 83 7D 0C 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 5D 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 D2 85 D2 75 D6 8B 45 DC C7 40 0C 42 00 00 00 8B 4D DC 8B 55 08 89 51 08 8B 45 DC 8B 4D 08 89 08 8B 55 DC C7 42 04 FF FF FF 7F 8B 45 10 50 8B 4D 0C 51 8B 55 DC 52 E8 ?? ?? ?? ?? 83 C4 0C 89 45 D8 8B 45 DC 8B 48 04 83 E9 01 8B 55 DC 89 4A 04 8B 45 DC 83 78 04 00 7C 21 8B 4D DC 8B 11 C6 02 00 33 C0 25 FF 00 00 00 89 45 D4 8B 4D DC 8B 11 83 C2 01 8B 45 DC 89 10 EB 11 8B 4D DC 51 6A 00 E8 ?? ?? ?? ?? 83 C4 08 89 45 D4 8B 55 DC 8B 42 04 83 E8 01 8B 4D DC 89 41 04 8B 55 DC 83 7A 04 00 7C 22 8B 45 DC 8B 08 C6 01 00 33 D2 81 E2 FF 00 00 00 89 55 D0 8B 45 DC 8B 08 83 C1 01 8B 55 DC 89 0A EB 11 8B 45 DC 50 6A 00 E8 ?? ?? ?? ?? 83 C4 08 89 45 D0 8B 45 D8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_450_0_0 {
	meta:
		name = "___crtLCMapStringW"
		size = 743
		refs = "0006 $T17285 000b __except_handler3 0011 __except_list 0028 _?f_use@?1??__crtLCMapStringW@@9@9 0036 ??_C@_13A@?$AA?$AA?$AA?$AA@ 0043 __imp__LCMapStringW@24 005e ??_C@_01A@?$AA?$AA@ 006b __imp__LCMapStringA@24 0095 _wcsncnt 00e0 ___lc_codepage 0102 __imp__WideCharToMultiByte@32 0126 __alloca_probe 026d _strncpy 0290 __imp__MultiByteToWideChar@24"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 C4 D8 53 56 57 89 65 E8 83 3D ?? ?? ?? ?? 00 75 57 6A 00 6A 00 6A 01 68 ?? ?? ?? ?? 68 00 01 00 00 6A 00 FF 15 ?? ?? ?? ?? 85 C0 74 0C C7 05 ?? ?? ?? ?? 01 00 00 00 EB 2F 6A 00 6A 00 6A 01 68 ?? ?? ?? ?? 68 00 01 00 00 6A 00 FF 15 ?? ?? ?? ?? 85 C0 74 0C C7 05 ?? ?? ?? ?? 02 00 00 00 EB 07 33 C0 E9 4D 02 00 00 83 7D 14 00 7E 13 8B 45 14 50 8B 4D 10 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 14 83 3D ?? ?? ?? ?? 01 75 23 8B 55 1C 52 8B 45 18 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 FF 15 ?? ?? ?? ?? E9 08 02 00 00 83 3D ?? ?? ?? ?? 02 0F 85 F9 01 00 00 83 7D 20 00 75 09 8B 15 ?? ?? ?? ?? 89 55 20 6A 00 6A 00 6A 00 6A 00 8B 45 14 50 8B 4D 10 51 68 20 02 00 00 8B 55 20 52 FF 15 ?? ?? ?? ?? 89 45 E0 83 7D E0 00 75 07 33 C0 E9 BD 01 00 00 C7 45 FC 00 00 00 00 8B 45 E0 83 C0 03 24 FC E8 ?? ?? ?? ?? 89 65 D0 89 65 E8 8B 45 D0 89 45 E4 C7 45 FC FF FF FF FF EB 17 B8 01 00 00 00 C3 8B 65 E8 C7 45 E4 00 00 00 00 C7 45 FC FF FF FF FF 83 7D E4 00 75 07 33 C0 E9 70 01 00 00 6A 00 6A 00 8B 4D E0 51 8B 55 E4 52 8B 45 14 50 8B 4D 10 51 68 20 02 00 00 8B 55 20 52 FF 15 ?? ?? ?? ?? 85 C0 75 07 33 C0 E9 42 01 00 00 6A 00 6A 00 8B 45 E0 50 8B 4D E4 51 8B 55 0C 52 8B 45 08 50 FF 15 ?? ?? ?? ?? 89 45 D4 83 7D D4 00 75 07 33 C0 E9 18 01 00 00 C7 45 FC 01 00 00 00 8B 45 D4 83 C0 03 24 FC E8 ?? ?? ?? ?? 89 65 CC 89 65 E8 8B 4D CC 89 4D DC C7 45 FC FF FF FF FF EB 17 B8 01 00 00 00 C3 8B 65 E8 C7 45 DC 00 00 00 00 C7 45 FC FF FF FF FF 83 7D DC 00 75 07 33 C0 E9 CB 00 00 00 8B 55 D4 52 8B 45 DC 50 8B 4D E0 51 8B 55 E4 52 8B 45 0C 50 8B 4D 08 51 FF 15 ?? ?? ?? ?? 85 C0 75 07 33 C0 E9 A2 00 00 00 8B 55 0C 81 E2 00 04 00 00 85 D2 74 38 8B 45 D4 89 45 D8 83 7D 1C 00 74 2A 8B 4D 1C 3B 4D D4 7D 08 8B 55 1C 89 55 C8 EB 06 8B 45 D4 89 45 C8 8B 4D C8 51 8B 55 DC 52 8B 45 18 50 E8 ?? ?? ?? ?? 83 C4 0C EB 56 83 7D 1C 00 75 27 6A 00 6A 00 8B 4D D4 51 8B 55 DC 52 6A 01 8B 45 20 50 FF 15 ?? ?? ?? ?? 89 45 D8 83 7D D8 00 75 04 33 C0 EB 32 EB 29 8B 4D 1C 51 8B 55 18 52 8B 45 D4 50 8B 4D DC 51 6A 01 8B 55 20 52 FF 15 ?? ?? ?? ?? 89 45 D8 83 7D D8 00 75 04 33 C0 EB 07 8B 45 D8 EB 02 33 C0 8D 65 BC 8B 4D F0 64 89 0D ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_451_1_0 {
	meta:
		name = "__getdcwd"
		size = 284
		refs = "0014 __validdrive 0021 __doserrno 002b _errno 0065 __imp__GetFullPathNameA@16 007c __imp__GetCurrentDirectoryA@8 00cf _malloc 0111 _strcpy"
	strings:
		$1 = { 55 8B EC 81 EC 18 01 00 00 83 7D 08 00 74 5F 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 1B C7 05 ?? ?? ?? ?? 0F 00 00 00 C7 05 ?? ?? ?? ?? 0D 00 00 00 33 C0 E9 DE 00 00 00 8B 4D 08 83 C1 40 88 4D F4 C6 45 F5 3A C6 45 F6 2E C6 45 F7 00 8D 55 F8 52 8D 85 EC FE FF FF 50 68 04 01 00 00 8D 4D F4 51 FF 15 ?? ?? ?? ?? 89 45 F0 EB 15 8D 95 EC FE FF FF 52 68 04 01 00 00 FF 15 ?? ?? ?? ?? 89 45 F0 83 7D F0 00 74 12 8B 45 F0 83 C0 01 89 45 F0 81 7D F0 04 01 00 00 76 04 33 C0 EB 79 8B 4D 0C 89 4D FC 83 7D FC 00 75 44 8B 55 F0 3B 55 10 7E 0B 8B 45 F0 89 85 E8 FE FF FF EB 09 8B 4D 10 89 8D E8 FE FF FF 8B 95 E8 FE FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 83 7D FC 00 75 0E C7 05 ?? ?? ?? ?? 0C 00 00 00 33 C0 EB 2B EB 16 8B 45 F0 3B 45 10 7E 0E C7 05 ?? ?? ?? ?? 22 00 00 00 33 C0 EB 13 8D 8D EC FE FF FF 51 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_451_2_0 {
	meta:
		name = "__validdrive"
		size = 78
		refs = "002e __imp__GetDriveTypeA@4"
	strings:
		$1 = { 55 8B EC 83 EC 08 83 7D 08 00 75 07 B8 01 00 00 00 EB 37 8B 45 08 83 C0 40 88 45 F8 C6 45 F9 3A C6 45 FA 5C C6 45 FB 00 8D 4D F8 51 FF 15 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 74 06 83 7D FC 01 75 04 33 C0 EB 05 B8 01 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_452_0_0 {
	meta:
		name = "_wctomb"
		size = 158
		refs = "0015 ___lc_handle 002d _errno 0058 ___mb_cur_max 006e ___lc_codepage 0075 __imp__WideCharToMultiByte@32"
	strings:
		$1 = { 55 8B EC 83 EC 08 83 7D 08 00 75 07 33 C0 E9 87 00 00 00 83 3D ?? ?? ?? ?? 00 75 2D 8B 45 0C 25 FF FF 00 00 3D FF 00 00 00 7E 0F C7 05 ?? ?? ?? ?? 2A 00 00 00 83 C8 FF EB 60 8B 4D 08 8A 55 0C 88 11 B8 01 00 00 00 EB 51 C7 45 F8 00 00 00 00 8D 45 F8 50 6A 00 8B 0D ?? ?? ?? ?? 51 8B 55 08 52 6A 01 8D 45 0C 50 68 20 02 00 00 8B 0D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 74 06 83 7D F8 00 74 0F C7 05 ?? ?? ?? ?? 2A 00 00 00 83 C8 FF EB 03 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_453_0_0 {
	meta:
		name = "_qsort"
		size = 564
		refs = "006c _shortsort 0096 _swap"
	strings:
		$1 = { 55 8B EC 81 EC 0C 01 00 00 83 7D 0C 02 72 06 83 7D 10 00 75 05 E9 16 02 00 00 C7 45 F0 00 00 00 00 8B 45 08 89 45 F4 8B 4D 0C 83 E9 01 8B 55 10 0F AF D1 8B 45 08 03 C2 89 85 F4 FE FF FF 8B 85 F4 FE FF FF 2B 45 F4 33 D2 F7 75 10 83 C0 01 89 45 FC 83 7D FC 08 77 20 8B 4D 14 51 8B 55 10 52 8B 85 F4 FE FF FF 50 8B 4D F4 51 E8 ?? ?? ?? ?? 83 C4 10 E9 87 01 00 00 8B 55 FC D1 EA 0F AF 55 10 8B 45 F4 03 C2 89 45 F8 8B 4D 10 51 8B 55 F4 52 8B 45 F8 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D F4 89 4D EC 8B 95 F4 FE FF FF 03 55 10 89 95 70 FF FF FF 8B 45 EC 03 45 10 89 45 EC 8B 4D EC 3B 8D F4 FE FF FF 77 12 8B 55 F4 52 8B 45 EC 50 FF 55 14 83 C4 08 85 C0 7E DA 8B 8D 70 FF FF FF 2B 4D 10 89 8D 70 FF FF FF 8B 95 70 FF FF FF 3B 55 F4 76 15 8B 45 F4 50 8B 8D 70 FF FF FF 51 FF 55 14 83 C4 08 85 C0 7D D1 8B 95 70 FF FF FF 3B 55 EC 73 02 EB 19 8B 45 10 50 8B 8D 70 FF FF FF 51 8B 55 EC 52 E8 ?? ?? ?? ?? 83 C4 0C EB 85 8B 45 10 50 8B 8D 70 FF FF FF 51 8B 55 F4 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 85 70 FF FF FF 83 E8 01 2B 45 F4 8B 8D F4 FE FF FF 2B 4D EC 3B C1 7C 4F 8B 55 F4 03 55 10 3B 95 70 FF FF FF 73 29 8B 45 F0 8B 4D F4 89 8C 85 74 FF FF FF 8B 95 70 FF FF FF 2B 55 10 8B 45 F0 89 94 85 F8 FE FF FF 8B 4D F0 83 C1 01 89 4D F0 8B 55 EC 3B 95 F4 FE FF FF 73 0B 8B 45 EC 89 45 F4 E9 94 FE FF FF EB 53 8B 4D EC 3B 8D F4 FE FF FF 73 26 8B 55 F0 8B 45 EC 89 84 95 74 FF FF FF 8B 4D F0 8B 95 F4 FE FF FF 89 94 8D F8 FE FF FF 8B 45 F0 83 C0 01 89 45 F0 8B 4D F4 03 4D 10 3B 8D 70 FF FF FF 73 14 8B 95 70 FF FF FF 2B 55 10 89 95 F4 FE FF FF E9 3F FE FF FF 8B 45 F0 83 E8 01 89 45 F0 83 7D F0 00 7C 22 8B 4D F0 8B 94 8D 74 FF FF FF 89 55 F4 8B 45 F0 8B 8C 85 F8 FE FF FF 89 8D F4 FE FF FF E9 0E FE FF FF 8B E5 5D C3 }
	condition:
		$1
}

rule file_453_1_0 {
	meta:
		name = "_shortsort"
		size = 109
		refs = "0057 _swap"
	strings:
		$1 = { 55 8B EC 83 EC 08 8B 45 0C 3B 45 08 76 5B 8B 4D 08 89 4D F8 8B 55 08 03 55 10 89 55 FC EB 09 8B 45 FC 03 45 10 89 45 FC 8B 4D FC 3B 4D 0C 77 1A 8B 55 F8 52 8B 45 FC 50 FF 55 14 83 C4 08 85 C0 7E 06 8B 4D FC 89 4D F8 EB D5 8B 55 10 52 8B 45 0C 50 8B 4D F8 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 0C 2B 55 10 89 55 0C EB 9D 8B E5 5D C3 }
	condition:
		$1
}

rule file_453_2_0 {
	meta:
		name = "_swap"
		size = 78
	strings:
		$1 = { 55 8B EC 51 8B 45 08 3B 45 0C 74 3E 8B 4D 10 8B 55 10 83 EA 01 89 55 10 85 C9 74 2E 8B 45 08 8A 08 88 4D FC 8B 55 08 8B 45 0C 8A 08 88 0A 8B 55 08 83 C2 01 89 55 08 8B 45 0C 8A 4D FC 88 08 8B 55 0C 83 C2 01 89 55 0C EB C2 8B E5 5D C3 }
	condition:
		$1
}

rule file_454_0_0 {
	meta:
		name = "__malloc_base"
		size = 32
		refs = "0005 __newmode 000f __nh_malloc_base"
	strings:
		$1 = { 55 8B EC 51 A1 ?? ?? ?? ?? 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_454_1_0 {
	meta:
		name = "__nh_malloc_base"
		size = 87
		refs = "0019 __heap_alloc_base 0042 __callnewh"
	strings:
		$1 = { 55 8B EC 51 83 7D 08 E0 76 04 33 C0 EB 45 83 7D 08 E0 77 11 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC EB 07 C7 45 FC 00 00 00 00 83 7D FC 00 75 06 83 7D 0C 00 75 05 8B 45 FC EB 16 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 04 33 C0 EB 02 EB BB 8B E5 5D C3 }
	condition:
		$1
}

rule file_454_2_0 {
	meta:
		name = "__heap_alloc_base"
		size = 198
		refs = "0006 ___active_heap 0012 ___sbh_threshold 001d ___sbh_alloc_block 0060 ___old_sbh_threshold 006e ___old_sbh_alloc_block 008a __crtheap 0091 __imp__HeapAlloc@12"
	strings:
		$1 = { 55 8B EC 51 83 3D ?? ?? ?? ?? 03 75 2A 8B 45 08 3B 05 ?? ?? ?? ?? 77 1D 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 8D 00 00 00 EB 60 83 3D ?? ?? ?? ?? 02 75 57 83 7D 08 00 74 0E 8B 55 08 83 C2 0F 83 E2 F0 89 55 08 EB 07 C7 45 08 10 00 00 00 8B 45 08 3B 05 ?? ?? ?? ?? 77 1D 8B 4D 08 C1 E9 04 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 83 7D FC 00 74 05 8B 45 FC EB 3F 8B 55 08 52 6A 00 A1 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? EB 2B 83 7D 08 00 75 07 C7 45 08 01 00 00 00 8B 4D 08 83 C1 0F 83 E1 F0 89 4D 08 8B 55 08 52 6A 00 A1 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_456_0_0 {
	meta:
		name = "_memcmp"
		size = 45
	strings:
		$1 = { 8B 44 24 0C 85 C0 74 44 8B 54 24 04 56 57 8B F2 8B 7C 24 10 0B D7 83 E2 03 74 32 A9 01 00 00 00 74 0B 8A 0E 3A 0F 75 52 46 47 48 74 1D }
	condition:
		$1
}

rule file_456_1_0 {
	meta:
		name = "main_loop"
		size = 29
	strings:
		$1 = { 8A 0E 8A 17 38 D1 75 45 8A 4E 01 8A 57 01 38 D1 75 3B 83 C7 02 83 C6 02 83 E8 02 75 E3 }
	condition:
		$1
}

rule file_456_4_0 {
	meta:
		name = "dwords"
		size = 40
	strings:
		$1 = { 8B C8 83 E0 03 C1 E9 02 74 2B F3 A7 74 27 8B 4E FC 8B 57 FC 38 D1 75 10 38 F5 75 0C C1 E9 10 C1 EA 10 38 D1 75 02 38 F5 }
	condition:
		$1
}

rule file_456_7_0 {
	meta:
		name = "tail_loop_start"
		size = 39
	strings:
		$1 = { 85 C0 74 C4 8B 16 8B 0F 38 CA 75 E7 48 74 18 38 EE 75 E0 48 74 11 81 E1 00 00 FF 00 81 E2 00 00 FF 00 3B D1 75 CD 48 }
	condition:
		$1
}

rule file_458_0_0 {
	meta:
		name = "?__CxxUnhandledExceptionFilter@@YGJPAU_EXCEPTION_POINTERS@@@Z"
		size = 91
		refs = "002a ?terminate@@YAXXZ 0030 _pOldExceptFilter 003e ?_ValidateExecute@@YAHP6GHXZ@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 08 81 39 63 73 6D E0 75 1E 8B 55 08 8B 02 83 78 10 03 75 13 8B 4D 08 8B 11 81 7A 14 20 05 93 19 75 05 E8 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 74 1E A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 0C 8B 4D 08 51 FF 15 ?? ?? ?? ?? EB 02 33 C0 5D C2 04 00 }
	condition:
		$1
}

rule file_458_1_0 {
	meta:
		name = "?__CxxSetUnhandledExceptionFilter@@YAXXZ"
		size = 21
		refs = "0004 ?__CxxUnhandledExceptionFilter@@YGJPAU_EXCEPTION_POINTERS@@@Z 000a __imp__SetUnhandledExceptionFilter@4 000f _pOldExceptFilter"
	strings:
		$1 = { 55 8B EC 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_458_2_0 {
	meta:
		name = "?__CxxRestoreUnhandledExceptionFilter@@YAXXZ"
		size = 17
		refs = "0004 _pOldExceptFilter 000b __imp__SetUnhandledExceptionFilter@4"
	strings:
		$1 = { 55 8B EC A1 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_459_0_0 {
	meta:
		name = "__CIpow"
		size = 25
	strings:
		$1 = { 83 EC 10 D9 C9 DD 1C 24 DD 54 24 08 8B 44 24 0C E8 0D 00 00 00 83 C4 10 C3 }
	condition:
		$1
}

rule file_459_1_0 {
	meta:
		name = "_pow"
		size = 516
		refs = "0005 __fload_withFB 0019 __load_CW 0059 __twoToTOS 0066 ___fastflag 006d __fast_exit 0073 POW_name 007d __check_range_exit 009a __startTwoArgErrorHandling 011d __powhlp 0177 __infinity 01ce __indefinite 01ec __half"
	strings:
		$1 = { 8D 54 24 0C E8 ?? ?? ?? ?? 8B C8 50 9B D9 3C 24 66 81 3C 24 7F 02 74 05 E8 ?? ?? ?? ?? 81 E1 00 00 F0 7F 8D 54 24 08 81 F9 00 00 F0 7F 0F 84 9D 00 00 00 E8 ?? ?? ?? ?? 0F 84 8E 00 00 00 A9 00 00 F0 7F 0F 84 F6 00 00 00 8A 4C 24 0F 80 E1 80 0F 85 61 01 00 00 D9 F1 E8 ?? ?? ?? ?? 80 F9 01 75 02 D9 E0 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? 8D 0D ?? ?? ?? ?? BA 1D 00 00 00 E9 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? 8D 0D ?? ?? ?? ?? BA 1D 00 00 00 E8 ?? ?? ?? ?? 5A C3 8D 54 24 08 E8 ?? ?? ?? ?? F6 44 24 16 08 75 03 41 EB 33 DE C1 B8 01 00 00 00 EB C5 F6 44 24 0E 08 75 F0 DE C1 B8 07 00 00 00 EB B5 33 C9 EB 16 33 C9 25 FF FF 0F 00 0B 44 24 10 75 C3 8D 54 24 08 E8 ?? ?? ?? ?? 8B 44 24 0C 8B D0 25 00 00 F0 7F 81 E2 FF FF 0F 00 3D 00 00 F0 7F 75 06 0B 54 24 08 75 B8 85 C9 75 BB 83 EC 74 8B CC 51 83 EC 10 DD 1C 24 DD 5C 24 08 9B DD 71 08 E8 ?? ?? ?? ?? 83 C4 10 59 DD 61 08 DD 01 83 C4 74 85 C0 0F 84 ?? ?? ?? ?? B8 01 00 00 00 E9 42 FF FF FF 8B 44 24 0C 25 FF FF 0F 00 0B 44 24 08 0F 85 F7 FE FF FF DD D8 8B 44 24 14 A9 00 00 F0 7F 74 3D E8 78 00 00 00 8A 6C 24 0F C0 ED 07 F7 44 24 17 80 00 00 00 74 16 DB 2D ?? ?? ?? ?? 84 CD 74 02 D9 E0 B8 02 00 00 00 E9 F6 FE FF FF D9 EE 84 CD 0F 84 ?? ?? ?? ?? D9 E0 E9 ?? ?? ?? ?? DD D8 25 FF FF 0F 00 0B 44 24 10 75 07 D9 E8 E9 ?? ?? ?? ?? D9 EE E9 ?? ?? ?? ?? D9 C1 E8 1E 00 00 00 D9 E0 84 C9 0F 85 8E FE FF FF DD D8 DD D8 DB 2D ?? ?? ?? ?? B8 01 00 00 00 E9 A5 FE FF FF D9 C0 D9 FC D8 D9 B1 00 9B DF E0 9E 75 17 DC 0D ?? ?? ?? ?? FE C1 D9 C0 D9 FC DE D9 9B DF E0 9E 75 02 FE C1 C3 DD D8 C3 }
	condition:
		$1
}

rule file_460_0_0 {
	meta:
		name = "__fgetchar"
		size = 82
		refs = "0005 __iob 0041 __filbuf"
	strings:
		$1 = { 55 8B EC 51 A1 ?? ?? ?? ?? 83 E8 01 A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 7C 21 8B 0D ?? ?? ?? ?? 0F BE 11 81 E2 FF 00 00 00 89 55 FC A1 ?? ?? ?? ?? 83 C0 01 A3 ?? ?? ?? ?? EB 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_461_1_0 {
	meta:
		name = "__fFSIN"
		size = 33
		refs = "001d __rtindfnpop"
	strings:
		$1 = { D9 FE 9B DF E0 9B 9E 7A 0C C3 D9 F2 9B DF E0 DD D8 9E 7A 01 C3 C6 85 70 FF FF FF 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_462_1_0 {
	meta:
		name = "probepages"
		size = 20
	strings:
		$1 = { 81 E9 00 10 00 00 2D 00 10 00 00 85 01 3D 00 10 00 00 73 EC }
	condition:
		$1
}

rule file_463_0_0 {
	meta:
		name = "__wexeclp"
		size = 207
		refs = "000d ??_C@_0BB@COCE@filename?5?$CB?$DN?5NULL?$AA@ 0016 ??_C@_08MGBO@execlp?4c?$AA@ 001d __CrtDbgReport 003d ??_C@_0BG@GALO@?$CKfilename?5?$CB?$DN?5_T?$CI?8?20?8?$CJ?$AA@ 0067 ??_C@_0BA@BICO@arglist?5?$CB?$DN?5NULL?$AA@ 0097 ??_C@_0BF@GGKN@?$CKarglist?5?$CB?$DN?5_T?$CI?8?20?8?$CJ?$AA@ 00c3 __wexecvp"
	strings:
		$1 = { 55 8B EC 53 56 57 83 7D 08 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 31 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D6 8B 4D 08 33 D2 66 8B 11 85 D2 75 1E 68 ?? ?? ?? ?? 6A 00 6A 32 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D0 83 7D 0C 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 33 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D6 8B 55 0C 33 C0 66 8B 02 85 C0 75 1E 68 ?? ?? ?? ?? 6A 00 6A 34 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D0 8D 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_464_0_0 {
	meta:
		name = "___initstdio"
		size = 294
		refs = "0006 __nstream 0032 ??_C@_07HPAH@_file?4c?$AA@ 0041 __calloc_dbg 0049 ___piob 008e __amsg_exit 00b4 __iob 00ed ___pioinfo"
	strings:
		$1 = { 55 8B EC 51 83 3D ?? ?? ?? ?? 00 75 0C C7 05 ?? ?? ?? ?? 00 02 00 00 EB 13 83 3D ?? ?? ?? ?? 14 7D 0A C7 05 ?? ?? ?? ?? 14 00 00 00 68 83 00 00 00 68 ?? ?? ?? ?? 6A 02 6A 04 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 14 A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 75 3F C7 05 ?? ?? ?? ?? 14 00 00 00 68 86 00 00 00 68 ?? ?? ?? ?? 6A 02 6A 04 8B 0D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 14 A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 75 0A 6A 1A E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 EB 09 8B 55 FC 83 C2 01 89 55 FC 83 7D FC 14 7D 19 8B 45 FC C1 E0 05 05 ?? ?? ?? ?? 8B 4D FC 8B 15 ?? ?? ?? ?? 89 04 8A EB D8 C7 45 FC 00 00 00 00 EB 09 8B 45 FC 83 C0 01 89 45 FC 83 7D FC 03 7D 44 8B 4D FC C1 F9 05 8B 55 FC 83 E2 1F 8B 04 8D ?? ?? ?? ?? 83 3C D0 FF 74 19 8B 4D FC C1 F9 05 8B 55 FC 83 E2 1F 8B 04 8D ?? ?? ?? ?? 83 3C D0 00 75 10 8B 4D FC C1 E1 05 C7 81 ?? ?? ?? ?? FF FF FF FF EB AD 8B E5 5D C3 }
	condition:
		$1
}

rule file_464_1_0 {
	meta:
		name = "___endstdio"
		size = 26
		refs = "0004 __flushall 000b __exitflag 0014 __fcloseall"
	strings:
		$1 = { 55 8B EC E8 ?? ?? ?? ?? 0F BE 05 ?? ?? ?? ?? 85 C0 74 05 E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_465_0_0 {
	meta:
		name = "??1type_info@@UAE@XZ"
		size = 44
		refs = "000c ??_7type_info@@6B@ 0021 __free_base"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC 83 79 04 00 74 0F 8B 55 FC 8B 42 04 50 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_465_2_0 {
	meta:
		name = "??8type_info@@QBEHABV0@@Z"
		size = 40
		refs = "0016 _strcmp"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 83 C0 09 50 8B 4D 08 83 C1 09 51 E8 ?? ?? ?? ?? 83 C4 08 F7 D8 1B C0 40 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_465_3_0 {
	meta:
		name = "??9type_info@@QBEHABV0@@Z"
		size = 41
		refs = "0016 _strcmp"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 83 C0 09 50 8B 4D 08 83 C1 09 51 E8 ?? ?? ?? ?? 83 C4 08 F7 D8 1B C0 F7 D8 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_465_4_0 {
	meta:
		name = "?before@type_info@@QBEHABV1@@Z"
		size = 44
		refs = "0016 _strcmp"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 83 C0 09 50 8B 4D 08 83 C1 09 51 E8 ?? ?? ?? ?? 83 C4 08 33 D2 85 C0 0F 9F C2 8B C2 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_465_5_0 {
	meta:
		name = "?raw_name@type_info@@QBEPBDXZ"
		size = 17
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 83 C0 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_465_6_0 {
	meta:
		name = "??0type_info@@AAE@ABV0@@Z"
		size = 25
		refs = "000c ??_7type_info@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_465_7_0 {
	meta:
		name = "??4type_info@@AAEAAV0@ABV0@@Z"
		size = 16
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_467_0_0 {
	meta:
		name = "__eof"
		size = 181
		refs = "000b __nhandle 0020 ___pioinfo 0032 _errno 003c __doserrno 0052 __lseek"
	strings:
		$1 = { 55 8B EC 83 EC 0C 8B 45 08 3B 05 ?? ?? ?? ?? 73 1F 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F 8B 04 8D ?? ?? ?? ?? 0F BE 4C D0 04 83 E1 01 85 C9 75 19 C7 05 ?? ?? ?? ?? 09 00 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 83 C8 FF EB 68 6A 01 6A 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F8 83 7D F8 FF 74 19 6A 02 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 89 45 FC 83 7D FC FF 75 09 C7 45 F4 FF FF FF FF EB 2A 8B 4D F8 3B 4D FC 75 09 C7 45 F4 01 00 00 00 EB 19 6A 00 8B 55 F8 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C C7 45 F4 00 00 00 00 8B 45 F4 8B E5 5D C3 }
	condition:
		$1
}

rule file_469_0_0 {
	meta:
		name = "__wcsncoll"
		size = 123
		refs = "0010 ___lc_handle 0024 _wcsncmp 002e ___lc_collate_cp 0050 ___crtCompareStringW 0062 _errno"
	strings:
		$1 = { 55 8B EC 51 83 7D 10 00 75 04 33 C0 EB 69 83 3D ?? ?? ?? ?? 00 75 16 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C EB 4A A1 ?? ?? ?? ?? 50 8B 4D 10 51 8B 55 0C 52 8B 45 10 50 8B 4D 08 51 68 00 10 00 00 8B 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 1C 89 45 FC 83 7D FC 00 75 11 C7 05 ?? ?? ?? ?? 16 00 00 00 B8 FF FF FF 7F EB 06 8B 45 FC 83 E8 02 8B E5 5D C3 }
	condition:
		$1
}

rule file_470_0_0 {
	meta:
		name = "__twoToTOS"
		size = 21
	strings:
		$1 = { D9 C0 D9 FC DC E1 D9 C9 D9 E0 D9 F0 D9 E8 DE C1 D9 FD DD D9 C3 }
	condition:
		$1
}

rule file_470_1_0 {
	meta:
		name = "__load_CW"
		size = 23
	strings:
		$1 = { 8B 54 24 04 81 E2 00 03 00 00 83 CA 7F 66 89 54 24 06 D9 6C 24 06 C3 }
	condition:
		$1
}

rule file_470_2_0 {
	meta:
		name = "__convertTOStoQNaN"
		size = 25
		refs = "000f One"
	strings:
		$1 = { A9 00 00 08 00 74 06 B8 07 00 00 00 C3 DC 05 ?? ?? ?? ?? B8 01 00 00 00 C3 }
	condition:
		$1
}

rule file_470_3_0 {
	meta:
		name = "__fload_withFB"
		size = 67
	strings:
		$1 = { 8B 42 04 25 00 00 F0 7F 3D 00 00 F0 7F 74 03 DD 02 C3 8B 42 04 83 EC 0A 0D 00 00 FF 7F 89 44 24 06 8B 42 04 8B 0A 0F A4 C8 0B C1 E1 0B 89 44 24 04 89 0C 24 DB 2C 24 83 C4 0A A9 00 00 00 00 8B 42 04 C3 }
	condition:
		$1
}

rule file_470_4_0 {
	meta:
		name = "__checkTOS_withFB"
		size = 22
	strings:
		$1 = { 8B 44 24 08 25 00 00 F0 7F 3D 00 00 F0 7F 74 01 C3 8B 44 24 08 C3 }
	condition:
		$1
}

rule file_470_6_0 {
	meta:
		name = "__math_exit"
		size = 42
		refs = "001f __startOneArgErrorHandling"
	strings:
		$1 = { 66 8B 04 24 66 3D 7F 02 74 1E 66 83 E0 20 74 15 9B DF E0 66 83 E0 20 74 0C B8 08 00 00 00 E8 ?? ?? ?? ?? 5A C3 D9 2C 24 5A C3 }
	condition:
		$1
}

rule file_470_7_0 {
	meta:
		name = "__check_overflow_exit"
		size = 20
	strings:
		$1 = { 83 EC 08 DD 14 24 8B 44 24 04 83 C4 08 25 00 00 F0 7F EB 14 }
	condition:
		$1
}

rule file_470_8_0 {
	meta:
		name = "__check_range_exit"
		size = 163
		refs = "003f __startOneArgErrorHandling 0046 __startTwoArgErrorHandling 0053 IeeeAdjU 0063 DblMin 0074 _zero 007c IeeeAdjO 008c DblMax 009d _infinity"
	strings:
		$1 = { 83 EC 08 DD 14 24 8B 44 24 04 83 C4 08 25 00 00 F0 7F 74 3D 3D 00 00 F0 7F 74 5F 66 8B 04 24 66 3D 7F 02 74 2A 66 83 E0 20 75 21 9B DF E0 66 83 E0 20 74 18 B8 08 00 00 00 83 FA 1D 74 07 E8 ?? ?? ?? ?? 5A C3 E8 ?? ?? ?? ?? 5A C3 D9 2C 24 5A C3 DD 05 ?? ?? ?? ?? D9 C9 D9 FD DD D9 D9 C0 D9 E1 DC 1D ?? ?? ?? ?? 9B DF E0 9E B8 04 00 00 00 73 C7 DC 0D ?? ?? ?? ?? EB BF DD 05 ?? ?? ?? ?? D9 C9 D9 FD DD D9 D9 C0 D9 E1 DC 1D ?? ?? ?? ?? 9B DF E0 9E B8 03 00 00 00 76 9E DC 0D ?? ?? ?? ?? EB 96 }
	condition:
		$1
}

rule file_471_0_0 {
	meta:
		name = "___ld12mul"
		size = 1085
		refs = "0258 ___addl 02c8 ___shl_12 0317 ___shr_12"
	strings:
		$1 = { 55 8B EC 83 EC 48 66 C7 45 D4 00 00 C7 45 FC 00 00 00 00 C7 45 EC 00 00 00 00 C7 45 F0 00 00 00 00 C7 45 F4 00 00 00 00 8B 45 08 66 8B 48 0A 66 89 4D E8 8B 55 0C 66 8B 42 0A 66 89 45 E0 8B 4D E8 81 E1 FF FF 00 00 8B 55 E0 81 E2 FF FF 00 00 33 CA 81 E1 00 80 00 00 66 89 4D D4 66 8B 45 E8 66 25 FF 7F 66 89 45 E8 66 8B 4D E0 66 81 E1 FF 7F 66 89 4D E0 8B 55 E8 81 E2 FF FF 00 00 8B 45 E0 25 FF FF 00 00 03 D0 66 89 55 D0 8B 4D E8 81 E1 FF FF 00 00 81 F9 FF 7F 00 00 7D 20 8B 55 E0 81 E2 FF FF 00 00 81 FA FF 7F 00 00 7D 0F 8B 45 D0 25 FF FF 00 00 3D FD BF 00 00 7E 37 8B 4D D4 81 E1 FF FF 00 00 F7 D9 1B C9 81 E1 00 00 00 80 81 C1 00 80 FF 7F 8B 55 08 89 4A 08 8B 45 08 C7 40 04 00 00 00 00 8B 4D 08 C7 01 00 00 00 00 E9 45 03 00 00 8B 55 D0 81 E2 FF FF 00 00 81 FA BF 3F 00 00 7F 22 8B 45 08 C7 40 08 00 00 00 00 8B 4D 08 C7 41 04 00 00 00 00 8B 55 08 C7 02 00 00 00 00 E9 12 03 00 00 8B 45 E8 25 FF FF 00 00 85 C0 75 3A 66 8B 4D D0 66 83 C1 01 66 89 4D D0 8B 55 08 8B 42 08 25 FF FF FF 7F 85 C0 75 1F 8B 4D 08 83 79 04 00 75 16 8B 55 08 83 3A 00 75 0E 8B 45 08 66 C7 40 0A 00 00 E9 CC 02 00 00 8B 4D E0 81 E1 FF FF 00 00 85 C9 75 4F 66 8B 55 D0 66 83 C2 01 66 89 55 D0 8B 45 0C 8B 48 08 81 E1 FF FF FF 7F 85 C9 75 33 8B 55 0C 83 7A 04 00 75 2A 8B 45 0C 83 38 00 75 22 8B 4D 08 C7 41 08 00 00 00 00 8B 55 08 C7 42 04 00 00 00 00 8B 45 08 C7 00 00 00 00 00 E9 70 02 00 00 C7 45 D8 00 00 00 00 C7 45 E4 00 00 00 00 EB 09 8B 4D E4 83 C1 01 89 4D E4 83 7D E4 05 0F 8D B5 00 00 00 8B 55 E4 D1 E2 89 55 DC C7 45 F8 08 00 00 00 B8 05 00 00 00 2B 45 E4 89 45 CC EB 09 8B 4D CC 83 E9 01 89 4D CC 83 7D CC 00 7E 7C 8B 55 08 03 55 DC 89 55 C8 8B 45 0C 03 45 F8 89 45 C4 8B 4D D8 8D 54 0D EC 89 55 C0 8B 45 C8 33 C9 66 8B 08 8B 55 C4 33 C0 66 8B 02 0F AF C8 89 4D BC 8B 4D C0 51 8B 55 BC 52 8B 45 C0 8B 08 51 E8 ?? ?? ?? ?? 83 C4 0C 89 45 B8 83 7D B8 00 74 14 8B 55 D8 66 8B 44 15 F0 66 05 01 00 8B 4D D8 66 89 44 0D F0 8B 55 DC 83 C2 02 89 55 DC 8B 45 F8 83 E8 02 89 45 F8 E9 75 FF FF FF 8B 4D D8 83 C1 02 89 4D D8 E9 38 FF FF FF 66 8B 55 D0 66 81 EA FE 3F 66 89 55 D0 0F BF 45 D0 85 C0 7E 27 8B 4D F4 81 E1 00 00 00 80 85 C9 75 1A 8D 55 EC 52 E8 ?? ?? ?? ?? 83 C4 04 66 8B 45 D0 66 2D 01 00 66 89 45 D0 EB D1 0F BF 4D D0 85 C9 7F 58 66 8B 55 D0 66 83 EA 01 66 89 55 D0 0F BF 45 D0 85 C0 7D 33 8B 4D EC 81 E1 FF FF 00 00 83 E1 01 85 C9 74 09 8B 55 FC 83 C2 01 89 55 FC 8D 45 EC 50 E8 ?? ?? ?? ?? 83 C4 04 66 8B 4D D0 66 83 C1 01 66 89 4D D0 EB C5 83 7D FC 00 74 0B 66 8B 55 EC 80 CA 01 66 89 55 EC 8B 45 EC 25 FF FF 00 00 3D 00 80 00 00 7F 11 8B 4D EC 81 E1 FF FF 01 00 81 F9 00 80 01 00 75 61 83 7D EE FF 75 52 C7 45 EE 00 00 00 00 83 7D F2 FF 75 3A C7 45 F2 00 00 00 00 8B 55 F6 81 E2 FF FF 00 00 81 FA FF FF 00 00 75 14 66 C7 45 F6 00 80 66 8B 45 D0 66 05 01 00 66 89 45 D0 EB 0C 66 8B 4D F6 66 83 C1 01 66 89 4D F6 EB 09 8B 55 F2 83 C2 01 89 55 F2 EB 09 8B 45 EE 83 C0 01 89 45 EE 8B 4D D0 81 E1 FF FF 00 00 81 F9 FF 7F 00 00 7C 34 8B 55 D4 81 E2 FF FF 00 00 F7 DA 1B D2 81 E2 00 00 00 80 81 C2 00 80 FF 7F 8B 45 08 89 50 08 8B 4D 08 C7 41 04 00 00 00 00 8B 55 08 C7 02 00 00 00 00 EB 36 8B 45 08 66 8B 4D EE 66 89 08 8B 55 08 8B 45 F0 89 42 02 8B 4D 08 8B 55 F4 89 51 06 8B 45 D0 25 FF FF 00 00 8B 4D D4 81 E1 FF FF 00 00 0B C1 8B 55 08 66 89 42 0A 8B E5 5D C3 }
	condition:
		$1
}

rule file_471_1_0 {
	meta:
		name = "___multtenpow12"
		size = 195
		refs = "0007 __pow10pos 002b __pow10neg 00b6 ___ld12mul"
	strings:
		$1 = { 55 8B EC 83 EC 18 B8 ?? ?? ?? ?? 83 E8 60 89 45 FC 83 7D 0C 00 75 05 E9 A3 00 00 00 83 7D 0C 00 7D 13 8B 4D 0C F7 D9 89 4D 0C BA ?? ?? ?? ?? 83 EA 60 89 55 FC 83 7D 10 00 75 08 8B 45 08 66 C7 00 00 00 83 7D 0C 00 74 76 8B 4D FC 83 C1 54 89 4D FC 8B 55 0C 83 E2 07 89 55 E8 8B 45 0C C1 F8 03 89 45 0C 83 7D E8 00 75 02 EB D7 8B 4D E8 6B C9 0C 8B 55 FC 03 D1 89 55 F8 8B 45 F8 33 C9 66 8B 08 81 F9 00 80 00 00 7C 23 8B 55 F8 8B 02 89 45 EC 8B 4A 04 89 4D F0 8B 52 08 89 55 F4 8B 45 EE 83 E8 01 89 45 EE 8D 4D EC 89 4D F8 8B 55 F8 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 EB 84 8B E5 5D C3 }
	condition:
		$1
}

rule file_472_0_0 {
	meta:
		name = "__putch"
		size = 80
		refs = "000e __confh 0016 ___initconout 0037 __imp__WriteConsoleA@20"
	strings:
		$1 = { 55 8B EC 83 EC 08 8A 45 08 88 45 F8 83 3D ?? ?? ?? ?? FE 75 05 E8 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? FF 74 1C 6A 00 8D 4D FC 51 6A 01 8D 55 F8 52 A1 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 75 05 83 C8 FF EB 08 8B 45 F8 25 FF 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_473_0_0 {
	meta:
		name = "__setjmp"
		size = 56
		refs = "001a __except_list"
	strings:
		$1 = { 8B 54 24 04 89 2A 89 5A 04 89 7A 08 89 72 0C 89 62 10 8B 04 24 89 42 14 64 A1 ?? ?? ?? ?? 89 42 18 83 F8 FF 75 09 C7 42 1C FF FF FF FF EB 06 8B 40 0C 89 42 1C 2B C0 C3 }
	condition:
		$1
}

rule file_474_0_0 {
	meta:
		name = "_wcsrchr"
		size = 105
	strings:
		$1 = { 55 8B EC 51 8B 45 08 89 45 FC 8B 4D 08 33 D2 66 8B 11 8B 45 08 83 C0 02 89 45 08 85 D2 74 02 EB E9 8B 4D 08 83 E9 02 89 4D 08 8B 55 08 3B 55 FC 74 17 8B 45 08 33 C9 66 8B 08 8B 55 0C 81 E2 FF FF 00 00 3B CA 74 02 EB D8 8B 45 08 33 C9 66 8B 08 8B 55 0C 81 E2 FF FF 00 00 3B CA 75 05 8B 45 08 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_475_0_0 {
	meta:
		name = "??_M@YGXPAXIHP6EX0@Z@Z"
		size = 164
		refs = "0006 $T16482 000b __except_handler3 0011 __except_list 008c ?__ArrayUnwind@@YGXPAXIHP6EX0@Z@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 C4 F4 53 56 57 C7 45 E4 00 00 00 00 8B 45 0C 0F AF 45 10 8B 4D 08 03 C8 89 4D 08 C7 45 FC 00 00 00 00 8B 55 10 83 EA 01 89 55 10 83 7D 10 00 7C 11 8B 45 08 2B 45 0C 89 45 08 8B 4D 08 FF 55 14 EB E0 C7 45 E4 01 00 00 00 C7 45 FC FF FF FF FF E8 02 00 00 00 EB 1C 83 7D E4 00 75 15 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? C3 8B 4D F0 64 89 0D ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C2 10 00 }
	condition:
		$1
}

rule file_475_1_0 {
	meta:
		name = "?__ArrayUnwind@@YGXPAXIHP6EX0@Z@Z"
		size = 128
		refs = "0006 $T16494 000b __except_handler3 0011 __except_list 005b ?ArrayUnwindFilter@@YAHPAU_EXCEPTION_POINTERS@@@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 EC 08 53 56 57 89 65 E8 C7 45 FC 00 00 00 00 8B 45 10 83 E8 01 89 45 10 83 7D 10 00 7C 11 8B 4D 08 2B 4D 0C 89 4D 08 8B 4D 08 FF 55 14 EB E0 C7 45 FC FF FF FF FF EB 17 8B 55 EC 52 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 65 E8 C7 45 FC FF FF FF FF 8B 4D F0 64 89 0D ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C2 10 00 }
	condition:
		$1
}

rule file_476_0_0 {
	meta:
		name = "_sprintf"
		size = 250
		refs = "001c ??_C@_0P@OOIN@string?5?$CB?$DN?5NULL?$AA@ 0025 ??_C@_09NEAG@sprintf?4c?$AA@ 002c __CrtDbgReport 0046 ??_C@_0P@LNLA@format?5?$CB?$DN?5NULL?$AA@ 009b __output 00e6 __flsbuf"
	strings:
		$1 = { 55 8B EC 83 EC 30 53 56 57 8D 45 E0 89 45 DC 8D 4D 10 89 4D D4 83 7D 08 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 5D 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 D2 85 D2 75 D6 83 7D 0C 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 5E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D6 8B 4D DC C7 41 0C 42 00 00 00 8B 55 DC 8B 45 08 89 42 08 8B 4D DC 8B 55 08 89 11 8B 45 DC C7 40 04 FF FF FF 7F 8B 4D D4 51 8B 55 0C 52 8B 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 89 45 D8 8B 4D DC 8B 51 04 83 EA 01 8B 45 DC 89 50 04 8B 4D DC 83 79 04 00 7C 22 8B 55 DC 8B 02 C6 00 00 33 C9 81 E1 FF 00 00 00 89 4D D0 8B 55 DC 8B 02 83 C0 01 8B 4D DC 89 01 EB 11 8B 55 DC 52 6A 00 E8 ?? ?? ?? ?? 83 C4 08 89 45 D0 8B 45 D8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_478_0_0 {
	meta:
		name = "__getsystime"
		size = 160
		refs = "000c __imp__GetLocalTime@4 008d _mktime"
	strings:
		$1 = { 55 8B EC 83 EC 10 8D 45 F0 50 FF 15 ?? ?? ?? ?? 8B 4D 08 C7 41 20 FF FF FF FF 8B 55 FC 81 E2 FF FF 00 00 8B 45 08 89 10 8B 4D FA 81 E1 FF FF 00 00 8B 55 08 89 4A 04 8B 45 F8 25 FF FF 00 00 8B 4D 08 89 41 08 8B 55 F6 81 E2 FF FF 00 00 8B 45 08 89 50 0C 8B 4D F2 81 E1 FF FF 00 00 83 E9 01 8B 55 08 89 4A 10 8B 45 F0 25 FF FF 00 00 2D 6C 07 00 00 8B 4D 08 89 41 14 8B 55 F4 81 E2 FF FF 00 00 8B 45 08 89 50 18 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FE 25 FF FF 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_478_1_0 {
	meta:
		name = "__setsystime"
		size = 126
		refs = "000b _mktime 0068 __imp__SetLocalTime@4 0072 __imp__GetLastError@0"
	strings:
		$1 = { 55 8B EC 83 EC 10 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 08 8B 51 14 81 C2 6C 07 00 00 66 89 55 F0 8B 45 08 8B 48 10 83 C1 01 66 89 4D F2 8B 55 08 66 8B 42 0C 66 89 45 F6 8B 4D 08 66 8B 51 08 66 89 55 F8 8B 45 08 66 8B 48 04 66 89 4D FA 8B 55 08 66 8B 02 66 89 45 FC 66 8B 4D 0C 66 89 4D FE 8D 55 F0 52 FF 15 ?? ?? ?? ?? 85 C0 75 08 FF 15 ?? ?? ?? ?? EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_479_0_0 {
	meta:
		name = "__CallSettingFrame@12"
		size = 39
		refs = "001f __NLG_Notify1"
	strings:
		$1 = { 55 8B EC 83 EC 04 53 51 8B 45 0C 83 C0 0C 89 45 FC 8B 45 08 55 FF 75 10 8B 4D 10 8B 6D FC E8 ?? ?? ?? ?? 56 57 FF D0 }
	condition:
		$1
}

rule file_479_1_0 {
	meta:
		name = "__NLG_Return"
		size = 37
		refs = "001a __NLG_Notify1"
	strings:
		$1 = { 5F 5E 8B DD 5D 8B 4D 10 55 8B EB 81 F9 00 01 00 00 75 05 B9 02 00 00 00 51 E8 ?? ?? ?? ?? 5D 59 5B C9 C2 0C 00 }
	condition:
		$1
}

rule file_480_0_0 {
	meta:
		name = "__wputenv"
		size = 271
		refs = "0008 ___env_initialized 001a ??_C@_08GFKD@putenv?4c?$AA@ 0025 _wcslen 0032 __malloc_dbg 0053 _wcscpy 0061 ___crtwsetenv 0076 __environ 0095 __imp__WideCharToMultiByte@32 00f9 ___crtsetenv"
	strings:
		$1 = { 55 8B EC 83 EC 0C 83 3D ?? ?? ?? ?? 00 75 08 83 C8 FF E9 F4 00 00 00 6A 7F 68 ?? ?? ?? ?? 6A 02 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 8D 4C 00 02 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 F8 83 7D F8 00 75 08 83 C8 FF E9 C1 00 00 00 8B 55 08 52 8B 45 F8 50 E8 ?? ?? ?? ?? 83 C4 08 6A 01 8B 4D F8 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 08 83 C8 FF E9 97 00 00 00 83 3D ?? ?? ?? ?? 00 0F 84 88 00 00 00 6A 00 6A 00 6A 00 6A 00 6A FF 8B 55 08 52 6A 00 6A 01 FF 15 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 75 05 83 C8 FF EB 64 68 93 00 00 00 68 ?? ?? ?? ?? 6A 02 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 F4 83 7D F4 00 75 05 83 C8 FF EB 3E 6A 00 6A 00 8B 4D FC 51 8B 55 F4 52 6A FF 8B 45 08 50 6A 00 6A 01 FF 15 ?? ?? ?? ?? 85 C0 75 05 83 C8 FF EB 19 6A 00 8B 4D F4 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 05 83 C8 FF EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_481_1_0 {
	meta:
		name = "_log10"
		size = 184
		refs = "0005 __fload_withFB 001e __DEFAULT_CW_in_mem 0038 ___fastflag 003f __fast_exit 0045 LOG_name 004f __math_exit 006c __indefinite 0078 __convertTOStoQNaN 0090 __minfinity 00b2 __startOneArgErrorHandling"
	strings:
		$1 = { 8D 54 24 04 E8 ?? ?? ?? ?? 52 9B D9 3C 24 74 43 8B 44 24 0C 66 81 3C 24 7F 02 74 06 D9 2D ?? ?? ?? ?? A9 00 00 F0 7F 74 55 A9 00 00 00 80 75 38 D9 EC D9 C9 D9 F1 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? 8D 0D ?? ?? ?? ?? BA 1B 00 00 00 E9 ?? ?? ?? ?? A9 FF FF 0F 00 75 1D 83 7C 24 08 00 75 16 25 00 00 00 80 74 CE DD D8 DB 2D ?? ?? ?? ?? B8 01 00 00 00 EB 22 E8 ?? ?? ?? ?? EB 1B A9 FF FF 0F 00 75 AB 83 7C 24 08 00 75 A4 DD D8 DB 2D ?? ?? ?? ?? B8 02 00 00 00 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? 8D 0D ?? ?? ?? ?? BA 1B 00 00 00 E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule file_482_0_0 {
	meta:
		name = "_wcsspn"
		size = 108
	strings:
		$1 = { 55 8B EC 83 EC 08 8B 45 08 89 45 FC 8B 4D FC 33 D2 66 8B 11 85 D2 74 48 8B 45 0C 89 45 F8 EB 09 8B 4D F8 83 C1 02 89 4D F8 8B 55 F8 33 C0 66 8B 02 8B 4D FC 33 D2 66 8B 11 3B C2 74 18 8B 45 F8 33 C9 66 8B 08 85 C9 75 0A 8B 45 FC 2B 45 08 D1 F8 EB 15 EB CB 8B 55 FC 83 C2 02 89 55 FC EB AC 8B 45 FC 2B 45 08 D1 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_485_0_0 {
	meta:
		name = "__alloc_osfhnd"
		size = 301
		refs = "002f ___pioinfo 00a8 ??_C@_09LNLM@osfinfo?4c?$AA@ 00b4 __malloc_dbg 00d2 __nhandle"
	strings:
		$1 = { 55 8B EC 83 EC 0C C7 45 F8 FF FF FF FF C7 45 F4 00 00 00 00 EB 09 8B 45 F4 83 C0 01 89 45 F4 83 7D F4 40 0F 8D FD 00 00 00 8B 4D F4 83 3C 8D ?? ?? ?? ?? 00 74 6F 8B 55 F4 8B 04 95 ?? ?? ?? ?? 89 45 FC EB 09 8B 4D FC 83 C1 08 89 4D FC 8B 55 F4 8B 04 95 ?? ?? ?? ?? 05 00 01 00 00 39 45 FC 73 36 8B 4D FC 0F BE 51 04 83 E2 01 85 D2 75 26 8B 45 FC C7 00 FF FF FF FF 8B 4D F4 C1 E1 05 8B 55 F4 8B 45 FC 2B 04 95 ?? ?? ?? ?? C1 F8 03 03 C8 89 4D F8 EB 02 EB AD 83 7D F8 FF 74 05 E9 83 00 00 00 EB 7C 6A 79 68 ?? ?? ?? ?? 6A 02 68 00 01 00 00 E8 ?? ?? ?? ?? 83 C4 10 89 45 FC 83 7D FC 00 74 5B 8B 4D F4 8B 55 FC 89 14 8D ?? ?? ?? ?? A1 ?? ?? ?? ?? 83 C0 20 A3 ?? ?? ?? ?? EB 09 8B 4D FC 83 C1 08 89 4D FC 8B 55 F4 8B 04 95 ?? ?? ?? ?? 05 00 01 00 00 39 45 FC 73 19 8B 4D FC C6 41 04 00 8B 55 FC C7 02 FF FF FF FF 8B 45 FC C6 40 05 0A EB CA 8B 4D F4 C1 E1 05 89 4D F8 EB 05 E9 F0 FE FF FF 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_485_1_0 {
	meta:
		name = "__set_osfhnd"
		size = 175
		refs = "0009 __nhandle 0022 ___pioinfo 002e ___app_type 0057 __imp__SetStdHandle@8 0096 _errno 00a0 __doserrno"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 3B 05 ?? ?? ?? ?? 0F 83 81 00 00 00 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F 8B 04 8D ?? ?? ?? ?? 83 3C D0 FF 75 68 83 3D ?? ?? ?? ?? 01 75 42 8B 4D 08 89 4D FC 83 7D FC 00 74 0E 83 7D FC 01 74 16 83 7D FC 02 74 1E EB 28 8B 55 0C 52 6A F6 FF 15 ?? ?? ?? ?? EB 1A 8B 45 0C 50 6A F5 FF 15 ?? ?? ?? ?? EB 0C 8B 4D 0C 51 6A F4 FF 15 ?? ?? ?? ?? 8B 55 08 C1 FA 05 8B 45 08 83 E0 1F 8B 0C 95 ?? ?? ?? ?? 8B 55 0C 89 14 C1 33 C0 EB 17 C7 05 ?? ?? ?? ?? 09 00 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 83 C8 FF 8B E5 5D C3 }
	condition:
		$1
}

rule file_485_2_0 {
	meta:
		name = "__free_osfhnd"
		size = 201
		refs = "0009 __nhandle 0022 ___pioinfo 004d ___app_type 0074 __imp__SetStdHandle@8 00b0 _errno 00ba __doserrno"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 3B 05 ?? ?? ?? ?? 0F 83 9B 00 00 00 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F 8B 04 8D ?? ?? ?? ?? 0F BE 4C D0 04 83 E1 01 85 C9 74 7C 8B 55 08 C1 FA 05 8B 45 08 83 E0 1F 8B 0C 95 ?? ?? ?? ?? 83 3C C1 FF 74 63 83 3D ?? ?? ?? ?? 01 75 3C 8B 55 08 89 55 FC 83 7D FC 00 74 0E 83 7D FC 01 74 14 83 7D FC 02 74 1A EB 22 6A 00 6A F6 FF 15 ?? ?? ?? ?? EB 16 6A 00 6A F5 FF 15 ?? ?? ?? ?? EB 0A 6A 00 6A F4 FF 15 ?? ?? ?? ?? 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F 8B 14 85 ?? ?? ?? ?? C7 04 CA FF FF FF FF 33 C0 EB 17 C7 05 ?? ?? ?? ?? 09 00 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 83 C8 FF 8B E5 5D C3 }
	condition:
		$1
}

rule file_485_3_0 {
	meta:
		name = "__get_osfhandle"
		size = 94
		refs = "0008 __nhandle 001d ___pioinfo 0047 _errno 0051 __doserrno"
	strings:
		$1 = { 55 8B EC 8B 45 08 3B 05 ?? ?? ?? ?? 73 37 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F 8B 04 8D ?? ?? ?? ?? 0F BE 4C D0 04 83 E1 01 85 C9 74 18 8B 55 08 C1 FA 05 8B 45 08 83 E0 1F 8B 0C 95 ?? ?? ?? ?? 8B 04 C1 EB 17 C7 05 ?? ?? ?? ?? 09 00 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 83 C8 FF 5D C3 }
	condition:
		$1
}

rule file_485_4_0 {
	meta:
		name = "__open_osfhandle"
		size = 240
		refs = "004e __imp__GetFileType@4 005d __imp__GetLastError@0 0063 __dosmaperr 0090 __alloc_osfhnd 009f _errno 00a9 __doserrno 00bf __set_osfhnd 00de ___pioinfo"
	strings:
		$1 = { 55 8B EC 83 EC 0C C6 45 F4 00 8B 45 0C 83 E0 08 85 C0 74 09 8A 4D F4 80 C9 20 88 4D F4 8B 55 0C 81 E2 00 40 00 00 85 D2 74 08 8A 45 F4 0C 80 88 45 F4 8B 4D 0C 81 E1 80 00 00 00 85 C9 74 09 8A 55 F4 80 CA 10 88 55 F4 8B 45 08 50 FF 15 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 75 14 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 83 C8 FF EB 7D 83 7D FC 02 75 0B 8A 4D F4 80 C9 40 88 4D F4 EB 0F 83 7D FC 03 75 09 8A 55 F4 80 CA 08 88 55 F4 E8 ?? ?? ?? ?? 89 45 F8 83 7D F8 FF 75 19 C7 05 ?? ?? ?? ?? 18 00 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 83 C8 FF EB 36 8B 45 08 50 8B 4D F8 51 E8 ?? ?? ?? ?? 83 C4 08 8A 55 F4 80 CA 01 88 55 F4 8B 45 F8 C1 F8 05 8B 4D F8 83 E1 1F 8B 14 85 ?? ?? ?? ?? 8A 45 F4 88 44 CA 04 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_486_0_0 {
	meta:
		name = "__ismbcspace"
		size = 223
		refs = "003c ___ismbcodepage 004d ___mblcid 0054 ___mbcodepage 0066 ___crtGetStringTypeA 00a9 ___mb_cur_max 00b7 __isctype 00c8 __pctype"
	strings:
		$1 = { 55 8B EC 83 EC 10 81 7D 08 FF 00 00 00 0F 86 94 00 00 00 66 C7 45 F8 00 00 33 C0 66 89 45 FA 8B 4D 08 C1 E9 08 81 E1 FF 00 00 00 88 4D FC 8B 55 08 81 E2 FF 00 00 00 88 55 FD 83 3D ?? ?? ?? ?? 00 75 07 33 C0 E9 91 00 00 00 6A 01 A1 ?? ?? ?? ?? 50 8B 0D ?? ?? ?? ?? 51 8D 55 F8 52 6A 02 8D 45 FC 50 6A 01 E8 ?? ?? ?? ?? 83 C4 1C 85 C0 75 04 33 C0 EB 66 8B 4D FA 81 E1 FF FF 00 00 85 C9 75 19 8B 55 F8 81 E2 FF FF 00 00 83 E2 08 85 D2 74 09 C7 45 F4 01 00 00 00 EB 07 C7 45 F4 00 00 00 00 8B 45 F4 EB 34 83 3D ?? ?? ?? ?? 01 7E 13 6A 08 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 F0 EB 15 8B 4D 08 8B 15 ?? ?? ?? ?? 33 C0 66 8B 04 4A 83 E0 08 89 45 F0 8B 45 F0 8B E5 5D C3 }
	condition:
		$1
}

rule file_487_0_0 {
	meta:
		name = "__locking"
		size = 341
		refs = "000b __nhandle 0020 ___pioinfo 0032 _errno 003c __doserrno 0055 __lseek 00a7 __get_osfhandle 00b1 __imp__UnlockFile@20 00bb __imp__GetLastError@0 00df __imp__LockFile@20 0105 __imp__Sleep@4 0143 __dosmaperr"
	strings:
		$1 = { 55 8B EC 83 EC 0C 8B 45 08 3B 05 ?? ?? ?? ?? 73 1F 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F 8B 04 8D ?? ?? ?? ?? 0F BE 4C D0 04 83 E1 01 85 C9 75 1C C7 05 ?? ?? ?? ?? 09 00 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 83 C8 FF E9 05 01 00 00 6A 01 6A 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F4 83 7D F4 FF 75 08 83 C8 FF E9 E4 00 00 00 83 7D 0C 01 74 06 83 7D 0C 03 75 09 C7 45 F8 09 00 00 00 EB 07 C7 45 F8 00 00 00 00 C7 45 FC 00 00 00 00 83 7D 0C 00 75 2E 6A 00 8B 45 10 50 6A 00 8B 4D F4 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 50 FF 15 ?? ?? ?? ?? 85 C0 75 09 FF 15 ?? ?? ?? ?? 89 45 FC EB 2C 6A 00 8B 45 10 50 6A 00 8B 4D F4 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 50 FF 15 ?? ?? ?? ?? 85 C0 75 09 FF 15 ?? ?? ?? ?? 89 45 FC 83 7D F8 00 7E 06 83 7D FC 00 75 02 EB 19 68 E8 03 00 00 FF 15 ?? ?? ?? ?? 8B 45 F8 83 E8 01 89 45 F8 E9 72 FF FF FF 83 7D FC 00 74 32 83 7D 0C 01 74 06 83 7D 0C 03 75 15 C7 05 ?? ?? ?? ?? 24 00 00 00 8B 4D FC 89 0D ?? ?? ?? ?? EB 0C 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 83 C8 FF EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_488_0_0 {
	meta:
		name = "__wmktemp"
		size = 381
		refs = "0024 ??_C@_0BB@BKHM@template?5?$CB?$DN?5NULL?$AA@ 002d ??_C@_08DHKB@mktemp?4c?$AA@ 0034 __CrtDbgReport 0054 ??_C@_0BG@EHFM@?$CKtemplate?5?$CB?$DN?5_T?$CI?8?20?8?$CJ?$AA@ 0078 __getpid 010d _errno 0125 __waccess"
	strings:
		$1 = { 55 8B EC 83 EC 14 53 56 57 8B 45 08 89 45 F8 C7 45 FC 61 00 00 00 C7 45 EC 00 00 00 00 83 7D 08 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3A 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D6 8B 55 08 33 C0 66 8B 02 85 C0 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3B 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D0 E8 ?? ?? ?? ?? 89 45 F0 8B 55 F8 33 C0 66 8B 02 85 C0 74 0B 8B 4D F8 83 C1 02 89 4D F8 EB E9 8B 55 F8 83 EA 02 89 55 F8 8B 45 F8 33 C9 66 8B 08 83 F9 58 75 35 83 7D EC 05 7D 2F 8B 55 EC 83 C2 01 89 55 EC 8B 45 F0 33 D2 B9 0A 00 00 00 F7 F1 83 C2 30 8B 45 F8 66 89 10 8B 45 F0 33 D2 B9 0A 00 00 00 F7 F1 89 45 F0 EB B5 8B 55 F8 33 C0 66 8B 02 83 F8 58 75 06 83 7D EC 05 7D 04 33 C0 EB 7E 8B 4D F8 66 8B 55 FC 66 89 11 8B 45 FC 83 C0 01 89 45 FC 8B 0D ?? ?? ?? ?? 89 4D F4 C7 05 ?? ?? ?? ?? 00 00 00 00 6A 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 09 83 3D ?? ?? ?? ?? 0D 75 31 C7 05 ?? ?? ?? ?? 00 00 00 00 83 7D FC 7B 75 0C 8B 45 F4 A3 ?? ?? ?? ?? 33 C0 EB 21 8B 4D F8 66 8B 55 FC 66 89 11 8B 45 FC 83 C0 01 89 45 FC EB B4 8B 4D F4 89 0D ?? ?? ?? ?? 8B 45 08 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_490_0_0 {
	meta:
		name = "__wperror"
		size = 294
		refs = "0012 _wcslen 0022 ??_C@_09EOOK@wperror?4c?$AA@ 002d __malloc_dbg 004f _wcstombs 0061 __free_dbg 0082 _strlen 0093 __write 009d ??_C@_02HFBK@?3?5?$AA@ 00bd _errno 00cc __sys_nerr 00eb __sys_errlist 0112 ??_C@_01BJG@?6?$AA@"
	strings:
		$1 = { 55 8B EC 83 EC 10 C7 45 F4 02 00 00 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 83 C0 01 89 45 FC 6A 35 68 ?? ?? ?? ?? 6A 02 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 F8 83 7D F8 00 75 05 E9 E0 00 00 00 8B 55 FC 52 8B 45 08 50 8B 4D F8 51 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 13 6A 02 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 08 E9 B5 00 00 00 83 7D F8 00 74 3A 8B 45 F8 0F BE 08 85 C9 74 30 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 04 50 8B 45 F8 50 8B 4D F4 51 E8 ?? ?? ?? ?? 83 C4 0C 6A 02 68 ?? ?? ?? ?? 8B 55 F4 52 E8 ?? ?? ?? ?? 83 C4 0C 6A 02 8B 45 F8 50 E8 ?? ?? ?? ?? 83 C4 08 83 3D ?? ?? ?? ?? 00 7C 19 8B 0D ?? ?? ?? ?? 3B 0D ?? ?? ?? ?? 7D 0B 8B 15 ?? ?? ?? ?? 89 55 F0 EB 08 A1 ?? ?? ?? ?? 89 45 F0 8B 4D F0 8B 14 8D ?? ?? ?? ?? 89 55 F8 8B 45 F8 50 E8 ?? ?? ?? ?? 83 C4 04 50 8B 4D F8 51 8B 55 F4 52 E8 ?? ?? ?? ?? 83 C4 0C 6A 01 68 ?? ?? ?? ?? 8B 45 F4 50 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_491_0_0 {
	meta:
		name = "__fseeki64"
		size = 329
		refs = "0010 ??_C@_0M@KJPK@str?5?$CB?$DN?5NULL?$AA@ 0019 ??_C@_0L@GDOJ@fseeki64?4c?$AA@ 0020 __CrtDbgReport 005c _errno 0086 __ftelli64 00a9 __flush 0117 __lseeki64"
	strings:
		$1 = { 55 8B EC 83 EC 10 53 56 57 83 7D 08 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 68 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D6 8B 4D 08 89 4D FC 8B 55 FC 8B 42 0C 25 83 00 00 00 85 C0 74 12 83 7D 14 00 74 1E 83 7D 14 01 74 18 83 7D 14 02 74 12 C7 05 ?? ?? ?? ?? 16 00 00 00 83 C8 FF E9 D6 00 00 00 8B 4D FC 8B 51 0C 83 E2 EF 8B 45 FC 89 50 0C 83 7D 14 01 75 23 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 03 C8 8B 45 10 13 C2 89 4D 0C 89 45 10 C7 45 14 00 00 00 00 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 FC 8B 42 0C 25 80 00 00 00 85 C0 74 11 8B 4D FC 8B 51 0C 83 E2 FC 8B 45 FC 89 50 0C EB 33 8B 4D FC 8B 51 0C 83 E2 01 85 D2 74 26 8B 45 FC 8B 48 0C 83 E1 08 85 C9 74 19 8B 55 FC 8B 42 0C 25 00 04 00 00 85 C0 75 0A 8B 4D FC C7 41 18 00 02 00 00 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 FC 8B 42 10 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 F4 89 55 F8 8B 4D F4 23 4D F8 83 F9 FF 75 09 C7 45 F0 FF FF FF FF EB 07 C7 45 F0 00 00 00 00 8B 45 F0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_492_0_0 {
	meta:
		name = "___init_monetary"
		size = 304
		refs = "0006 ___lc_handle 0014 ??_C@_09KPNI@initmon?4c?$AA@ 001f __calloc_dbg 003e __get_lc_lconv 004e __free_lc_lconv 005c __free_dbg 0072 ___lconv 00a2 ___lconv_intl 00d6 ___lconv_c"
	strings:
		$1 = { 55 8B EC 51 83 3D ?? ?? ?? ?? 00 0F 84 BB 00 00 00 6A 4A 68 ?? ?? ?? ?? 6A 02 6A 30 6A 01 E8 ?? ?? ?? ?? 83 C4 14 89 45 FC 83 7D FC 00 75 0A B8 01 00 00 00 E9 F3 00 00 00 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 24 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 6A 02 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 08 B8 01 00 00 00 E9 BF 00 00 00 8B 45 FC 8B 0D ?? ?? ?? ?? 8B 11 89 10 8B 45 FC 8B 0D ?? ?? ?? ?? 8B 51 04 89 50 04 8B 45 FC 8B 0D ?? ?? ?? ?? 8B 51 08 89 50 08 8B 45 FC A3 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 04 6A 02 8B 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC A3 ?? ?? ?? ?? 33 C0 EB 60 8B 0D ?? ?? ?? ?? 8B 11 89 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B 48 04 89 0D ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 8B 42 08 A3 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 04 6A 02 8B 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 08 C7 05 ?? ?? ?? ?? 00 00 00 00 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_492_1_0 {
	meta:
		name = "__get_lc_lconv"
		size = 525
		refs = "0011 ___lc_id 0036 ___getlocaleinfo 00c9 _fix_grouping"
	strings:
		$1 = { 55 8B EC 83 EC 08 C7 45 F8 00 00 00 00 33 C0 66 A1 ?? ?? ?? ?? 89 45 FC 83 7D 08 00 75 08 83 C8 FF E9 E3 01 00 00 8B 4D 08 83 C1 0C 51 6A 15 8B 55 FC 52 6A 01 E8 ?? ?? ?? ?? 83 C4 10 8B 4D F8 0B C8 89 4D F8 8B 55 08 83 C2 10 52 6A 14 8B 45 FC 50 6A 01 E8 ?? ?? ?? ?? 83 C4 10 8B 4D F8 0B C8 89 4D F8 8B 55 08 83 C2 14 52 6A 16 8B 45 FC 50 6A 01 E8 ?? ?? ?? ?? 83 C4 10 8B 4D F8 0B C8 89 4D F8 8B 55 08 83 C2 18 52 6A 17 8B 45 FC 50 6A 01 E8 ?? ?? ?? ?? 83 C4 10 8B 4D F8 0B C8 89 4D F8 8B 55 08 83 C2 1C 52 6A 18 8B 45 FC 50 6A 01 E8 ?? ?? ?? ?? 83 C4 10 8B 4D F8 0B C8 89 4D F8 8B 55 08 8B 42 1C 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 08 83 C1 20 51 6A 50 8B 55 FC 52 6A 01 E8 ?? ?? ?? ?? 83 C4 10 8B 4D F8 0B C8 89 4D F8 8B 55 08 83 C2 24 52 6A 51 8B 45 FC 50 6A 01 E8 ?? ?? ?? ?? 83 C4 10 8B 4D F8 0B C8 89 4D F8 8B 55 08 83 C2 28 52 6A 1A 8B 45 FC 50 6A 00 E8 ?? ?? ?? ?? 83 C4 10 8B 4D F8 0B C8 89 4D F8 8B 55 08 83 C2 29 52 6A 19 8B 45 FC 50 6A 00 E8 ?? ?? ?? ?? 83 C4 10 8B 4D F8 0B C8 89 4D F8 8B 55 08 83 C2 2A 52 6A 54 8B 45 FC 50 6A 00 E8 ?? ?? ?? ?? 83 C4 10 8B 4D F8 0B C8 89 4D F8 8B 55 08 83 C2 2B 52 6A 55 8B 45 FC 50 6A 00 E8 ?? ?? ?? ?? 83 C4 10 8B 4D F8 0B C8 89 4D F8 8B 55 08 83 C2 2C 52 6A 56 8B 45 FC 50 6A 00 E8 ?? ?? ?? ?? 83 C4 10 8B 4D F8 0B C8 89 4D F8 8B 55 08 83 C2 2D 52 6A 57 8B 45 FC 50 6A 00 E8 ?? ?? ?? ?? 83 C4 10 8B 4D F8 0B C8 89 4D F8 8B 55 08 83 C2 2E 52 6A 52 8B 45 FC 50 6A 00 E8 ?? ?? ?? ?? 83 C4 10 8B 4D F8 0B C8 89 4D F8 8B 55 08 83 C2 2F 52 6A 53 8B 45 FC 50 6A 00 E8 ?? ?? ?? ?? 83 C4 10 8B 4D F8 0B C8 89 4D F8 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_492_3_0 {
	meta:
		name = "__free_lc_lconv"
		size = 147
		refs = "0014 ___lconv_static_null 0024 __free_dbg"
	strings:
		$1 = { 55 8B EC 83 7D 08 00 75 05 E9 83 00 00 00 8B 45 08 81 78 0C ?? ?? ?? ?? 74 77 6A 02 8B 4D 08 8B 51 0C 52 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 45 08 8B 48 10 51 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 55 08 8B 42 14 50 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 4D 08 8B 51 18 52 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 45 08 8B 48 1C 51 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 55 08 8B 42 20 50 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 4D 08 8B 51 24 52 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_493_0_0 {
	meta:
		name = "__spawnlp"
		size = 207
		refs = "000d ??_C@_0BB@COCE@filename?5?$CB?$DN?5NULL?$AA@ 0016 ??_C@_09HGIN@spawnlp?4c?$AA@ 001d __CrtDbgReport 003b ??_C@_0BG@GALO@?$CKfilename?5?$CB?$DN?5_T?$CI?8?20?8?$CJ?$AA@ 0065 ??_C@_0BA@BICO@arglist?5?$CB?$DN?5NULL?$AA@ 0093 ??_C@_0BF@GGKN@?$CKarglist?5?$CB?$DN?5_T?$CI?8?20?8?$CJ?$AA@ 00c3 __spawnvp"
	strings:
		$1 = { 55 8B EC 53 56 57 83 7D 0C 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 38 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D6 8B 4D 0C 0F BE 11 85 D2 75 1E 68 ?? ?? ?? ?? 6A 00 6A 39 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D2 83 7D 10 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3A 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D6 8B 55 10 0F BE 02 85 C0 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3B 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C9 85 C9 75 D2 8D 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_494_0_0 {
	meta:
		name = "_wcscoll"
		size = 106
		refs = "0006 ___lc_handle 0016 _wcscmp 0021 ___lc_collate_cp 003f ___crtCompareStringW 0051 _errno"
	strings:
		$1 = { 55 8B EC 51 83 3D ?? ?? ?? ?? 00 75 12 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 EB 47 8B 15 ?? ?? ?? ?? 52 6A FF 8B 45 0C 50 6A FF 8B 4D 08 51 68 00 10 00 00 8B 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 1C 89 45 FC 83 7D FC 00 75 11 C7 05 ?? ?? ?? ?? 16 00 00 00 B8 FF FF FF 7F EB 06 8B 45 FC 83 E8 02 8B E5 5D C3 }
	condition:
		$1
}

rule file_495_0_0 {
	meta:
		name = "__wcsnset"
		size = 66
	strings:
		$1 = { 55 8B EC 51 8B 45 08 89 45 FC 8B 4D 10 8B 55 10 83 EA 01 89 55 10 85 C9 74 21 8B 45 08 33 C9 66 8B 08 85 C9 74 15 8B 55 08 66 8B 45 0C 66 89 02 8B 4D 08 83 C1 02 89 4D 08 EB CF 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_497_0_0 {
	meta:
		name = "__powhlp"
		size = 612
		refs = "0012 __real@8@00000000000000000000 0053 __real@8@3fff8000000000000000 0063 __d_inf 0099 __d_ind 01b7 __d_inttype 021d __d_mzero"
	strings:
		$1 = { 55 8B EC 83 EC 28 C7 45 F4 00 00 00 00 DD 45 08 DC 1D ?? ?? ?? ?? DF E0 F6 C4 01 74 0A DD 45 08 D9 E0 DD 5D E8 EB 0C 8B 45 08 89 45 E8 8B 4D 0C 89 4D EC 8B 55 E8 89 55 F8 8B 45 EC 89 45 FC 81 7D 14 00 00 F0 7F 75 6C 83 7D 10 00 75 66 DD 45 F8 DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 75 15 8B 4D 18 8B 15 ?? ?? ?? ?? 89 11 A1 ?? ?? ?? ?? 89 41 04 EB 3C DD 45 F8 DC 1D ?? ?? ?? ?? DF E0 F6 C4 01 74 12 8B 4D 18 C7 01 00 00 00 00 C7 41 04 00 00 00 00 EB 1A 8B 55 18 A1 ?? ?? ?? ?? 89 02 8B 0D ?? ?? ?? ?? 89 4A 04 C7 45 F4 01 00 00 00 E9 A9 01 00 00 81 7D 14 00 00 F0 FF 75 6E 83 7D 10 00 75 68 DD 45 F8 DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 75 12 8B 55 18 C7 02 00 00 00 00 C7 42 04 00 00 00 00 EB 41 DD 45 F8 DC 1D ?? ?? ?? ?? DF E0 F6 C4 01 74 16 8B 45 18 8B 0D ?? ?? ?? ?? 89 08 8B 15 ?? ?? ?? ?? 89 50 04 EB 1B 8B 45 18 8B 0D ?? ?? ?? ?? 89 08 8B 15 ?? ?? ?? ?? 89 50 04 C7 45 F4 01 00 00 00 E9 32 01 00 00 81 7D 0C 00 00 F0 7F 75 63 83 7D 08 00 75 5D DD 45 10 DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 75 16 8B 45 18 8B 0D ?? ?? ?? ?? 89 08 8B 15 ?? ?? ?? ?? 89 50 04 EB 32 DD 45 10 DC 1D ?? ?? ?? ?? DF E0 F6 C4 01 74 12 8B 45 18 C7 00 00 00 00 00 C7 40 04 00 00 00 00 EB 10 8B 4D 18 C7 01 00 00 00 00 C7 41 04 00 00 F0 3F E9 C6 00 00 00 81 7D 0C 00 00 F0 FF 0F 85 B9 00 00 00 83 7D 08 00 0F 85 AF 00 00 00 8B 55 14 52 8B 45 10 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 F0 DD 45 10 DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 75 35 83 7D F0 01 75 0D DD 05 ?? ?? ?? ?? D9 E0 DD 5D E0 EB 12 8B 0D ?? ?? ?? ?? 89 4D E0 8B 15 ?? ?? ?? ?? 89 55 E4 8B 45 18 8B 4D E0 89 08 8B 55 E4 89 50 04 EB 57 DD 45 10 DC 1D ?? ?? ?? ?? DF E0 F6 C4 01 74 37 83 7D F0 01 75 13 A1 ?? ?? ?? ?? 89 45 D8 8B 0D ?? ?? ?? ?? 89 4D DC EB 0E C7 45 D8 00 00 00 00 C7 45 DC 00 00 00 00 8B 55 18 8B 45 D8 89 02 8B 4D DC 89 4A 04 EB 10 8B 55 18 C7 02 00 00 00 00 C7 42 04 00 00 F0 3F 8B 45 F4 8B E5 5D C3 }
	condition:
		$1
}

rule file_497_1_0 {
	meta:
		name = "__d_inttype"
		size = 128
		refs = "000f __fpclass 002c __frnd 0048 __real@8@40008000000000000000"
	strings:
		$1 = { 55 8B EC 83 EC 08 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 25 90 00 00 00 85 C0 74 04 33 C0 EB 59 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 DD 5D F8 DD 45 F8 DC 5D 08 DF E0 F6 C4 40 74 37 DD 45 08 DC 35 ?? ?? ?? ?? 83 EC 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DD 45 08 DC 35 ?? ?? ?? ?? DE D9 DF E0 F6 C4 40 74 07 B8 02 00 00 00 EB 09 B8 01 00 00 00 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_499_0_0 {
	meta:
		name = "__wgetenv"
		size = 200
		refs = "0007 __wenviron 0010 ___env_initialized 0026 __environ 002e ___mbtow_environ 0057 _wcslen 009e __wcsnicoll"
	strings:
		$1 = { 55 8B EC 83 EC 08 A1 ?? ?? ?? ?? 89 45 F8 83 3D ?? ?? ?? ?? 00 75 07 33 C0 E9 A6 00 00 00 83 7D F8 00 75 22 83 3D ?? ?? ?? ?? 00 74 19 E8 ?? ?? ?? ?? 85 C0 74 07 33 C0 E9 87 00 00 00 8B 0D ?? ?? ?? ?? 89 4D F8 83 7D F8 00 74 76 83 7D 08 00 74 70 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 8B 45 F8 83 38 00 74 59 8B 4D F8 8B 11 52 E8 ?? ?? ?? ?? 83 C4 04 3B 45 FC 76 3B 8B 45 F8 8B 08 8B 55 FC 33 C0 66 8B 04 51 83 F8 3D 75 28 8B 4D FC 51 8B 55 08 52 8B 45 F8 8B 08 51 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 0E 8B 55 F8 8B 02 8B 4D FC 8D 44 48 02 EB 0D 8B 55 F8 83 C2 04 89 55 F8 EB 9F 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_500_0_0 {
	meta:
		name = "_signal"
		size = 403
		refs = "0041 _ConsoleCtrlHandler_Installed 004b _ctrlevent_capture@4 0051 __imp__SetConsoleCtrlHandler@8 0068 __imp__GetLastError@0 006d __doserrno 0092 $L17065 0099 $L17066 009f _ctrlc_action 00b2 _ctrlbreak_action 00c6 _abort_action 00d9 _term_action 0104 _siglookup 013e __XcptActTabCount 0147 __XcptActTab 015b _errno 016a $L16987 016e $L16990 0172 $L16988 0176 $L16989 017a $L16984"
	strings:
		$1 = { 55 8B EC 83 EC 0C 83 7D 0C 04 74 06 83 7D 0C 03 75 05 E9 42 01 00 00 83 7D 08 02 74 16 83 7D 08 15 74 10 83 7D 08 16 74 0A 83 7D 08 0F 0F 85 B8 00 00 00 83 7D 08 02 74 06 83 7D 08 15 75 37 83 3D ?? ?? ?? ?? 00 75 2E 6A 01 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 83 F8 01 75 0C C7 05 ?? ?? ?? ?? 01 00 00 00 EB 10 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? E9 E3 00 00 00 8B 45 08 89 45 F4 8B 4D F4 83 E9 02 89 4D F4 83 7D F4 14 77 5E 8B 45 F4 33 D2 8A 90 ?? ?? ?? ?? FF 24 95 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 89 4D F8 8B 55 0C 89 15 ?? ?? ?? ?? EB 38 A1 ?? ?? ?? ?? 89 45 F8 8B 4D 0C 89 0D ?? ?? ?? ?? EB 25 8B 15 ?? ?? ?? ?? 89 55 F8 8B 45 0C A3 ?? ?? ?? ?? EB 12 8B 0D ?? ?? ?? ?? 89 4D F8 8B 55 0C 89 15 ?? ?? ?? ?? EB 69 83 7D 08 08 74 0E 83 7D 08 04 74 08 83 7D 08 0B 74 02 EB 5A 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 83 7D FC 00 75 02 EB 43 8B 4D FC 8B 51 08 89 55 F8 8B 45 FC 8B 48 04 3B 4D 08 75 2A 8B 55 FC 8B 45 0C 89 42 08 8B 4D FC 83 C1 0C 89 4D FC 8B 15 ?? ?? ?? ?? 6B D2 0C 81 C2 ?? ?? ?? ?? 39 55 FC 72 02 EB 02 EB CB 8B 45 F8 EB 0D C7 05 ?? ?? ?? ?? 16 00 00 00 83 C8 FF 8B E5 5D C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 04 04 04 04 04 04 04 04 04 04 04 04 01 04 04 04 04 04 02 03 }
	condition:
		$1
}

rule file_500_1_0 {
	meta:
		name = "_ctrlevent_capture@4"
		size = 104
		refs = "000f _ctrlc_action 0027 _ctrlbreak_action"
	strings:
		$1 = { 55 8B EC 83 EC 0C 83 7D 08 00 75 18 C7 45 F8 ?? ?? ?? ?? 8B 45 F8 8B 08 89 4D F4 C7 45 FC 02 00 00 00 EB 16 C7 45 F8 ?? ?? ?? ?? 8B 55 F8 8B 02 89 45 F4 C7 45 FC 15 00 00 00 83 7D F4 00 75 04 33 C0 EB 1E 83 7D F4 01 74 13 8B 4D F8 C7 01 00 00 00 00 8B 55 FC 52 FF 55 F4 83 C4 04 B8 01 00 00 00 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_500_2_0 {
	meta:
		name = "_raise"
		size = 433
		refs = "0022 $L17071 0029 $L17072 0030 _ctrlc_action 0041 _ctrlbreak_action 0052 _abort_action 0063 _term_action 0076 _siglookup 00ab __exit 00c2 __pxcptinfoptrs 00db __fpecode 00f4 __First_FPE_Indx 010e __Num_FPE 011f __XcptActTab 0184 $L17013 0188 $L17017 018c $L17016 0190 $L17014 0194 $L17015 0198 $L17018"
	strings:
		$1 = { 55 8B EC 83 EC 18 8B 45 08 89 45 E8 8B 4D E8 83 E9 02 89 4D E8 83 7D E8 14 77 72 8B 45 E8 33 D2 8A 90 ?? ?? ?? ?? FF 24 95 ?? ?? ?? ?? C7 45 F0 ?? ?? ?? ?? 8B 4D F0 8B 11 89 55 EC EB 57 C7 45 F0 ?? ?? ?? ?? 8B 45 F0 8B 08 89 4D EC EB 46 C7 45 F0 ?? ?? ?? ?? 8B 55 F0 8B 02 89 45 EC EB 35 C7 45 F0 ?? ?? ?? ?? 8B 4D F0 8B 11 89 55 EC EB 24 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 83 C0 08 89 45 F0 8B 4D F0 8B 11 89 55 EC EB 08 83 C8 FF E9 EB 00 00 00 83 7D EC 01 75 07 33 C0 E9 DE 00 00 00 83 7D EC 00 75 07 6A 03 E8 ?? ?? ?? ?? 83 7D 08 08 74 0C 83 7D 08 0B 74 06 83 7D 08 04 75 2B A1 ?? ?? ?? ?? 89 45 F4 C7 05 ?? ?? ?? ?? 00 00 00 00 83 7D 08 08 75 13 8B 0D ?? ?? ?? ?? 89 4D FC C7 05 ?? ?? ?? ?? 8C 00 00 00 83 7D 08 08 75 39 8B 15 ?? ?? ?? ?? 89 55 F8 EB 09 8B 45 F8 83 C0 01 89 45 F8 8B 0D ?? ?? ?? ?? 03 0D ?? ?? ?? ?? 39 4D F8 7D 12 8B 55 F8 6B D2 0C C7 82 ?? ?? ?? ?? 00 00 00 00 EB D4 EB 09 8B 45 F0 C7 00 00 00 00 00 83 7D 08 08 75 11 8B 0D ?? ?? ?? ?? 51 6A 08 FF 55 EC 83 C4 08 EB 0A 8B 55 08 52 FF 55 EC 83 C4 04 83 7D 08 08 74 0C 83 7D 08 0B 74 06 83 7D 08 04 75 17 8B 45 F4 A3 ?? ?? ?? ?? 83 7D 08 08 75 09 8B 4D FC 89 0D ?? ?? ?? ?? 33 C0 8B E5 5D C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 05 01 05 05 05 01 05 05 01 05 05 05 02 05 05 05 05 05 03 04 }
	condition:
		$1
}

rule file_500_3_0 {
	meta:
		name = "_siglookup"
		size = 93
		refs = "0007 __XcptActTab 0020 __XcptActTabCount"
	strings:
		$1 = { 55 8B EC 51 C7 45 FC ?? ?? ?? ?? 8B 45 FC 8B 48 04 3B 4D 08 74 1D 8B 55 FC 83 C2 0C 89 55 FC A1 ?? ?? ?? ?? 6B C0 0C 05 ?? ?? ?? ?? 39 45 FC 73 02 EB D8 8B 0D ?? ?? ?? ?? 6B C9 0C 81 C1 ?? ?? ?? ?? 39 4D FC 73 10 8B 55 FC 8B 42 04 3B 45 08 75 05 8B 45 FC EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_501_0_0 {
	meta:
		name = "_fgetws"
		size = 239
		refs = "001c ??_C@_0P@OOIN@string?5?$CB?$DN?5NULL?$AA@ 0025 ??_C@_07LIGC@fgets?4c?$AA@ 002c __CrtDbgReport 0046 ??_C@_0M@KJPK@str?5?$CB?$DN?5NULL?$AA@ 008d _fgetwc"
	strings:
		$1 = { 55 8B EC 83 EC 10 53 56 57 8B 45 08 89 45 F8 8B 4D 08 89 4D F0 83 7D 08 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3B 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 D2 85 D2 75 D6 83 7D 10 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3C 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 85 C0 75 D6 83 7D 0C 00 7F 04 33 C0 EB 75 8B 4D 10 89 4D FC 8B 55 0C 83 EA 01 89 55 0C 83 7D 0C 00 74 55 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 25 FF FF 00 00 89 45 F4 81 7D F4 FF FF 00 00 75 13 8B 4D F8 3B 4D 08 75 09 C7 45 F0 00 00 00 00 EB 2F EB 25 8B 55 F8 66 8B 45 F4 66 89 02 8B 4D F4 81 E1 FF FF 00 00 8B 55 F8 83 C2 02 89 55 F8 83 F9 0A 75 02 EB 02 EB 9C 8B 45 F8 66 C7 00 00 00 8B 45 F0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_502_0_0 {
	meta:
		name = "__FF_MSGBANNER"
		size = 73
		refs = "0005 ___error_mode 0017 ___app_type 0024 __NMSG_WRITE 002d __adbgmsg"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? 01 74 12 83 3D ?? ?? ?? ?? 00 75 32 83 3D ?? ?? ?? ?? 01 75 29 68 FC 00 00 00 E8 ?? ?? ?? ?? 83 C4 04 83 3D ?? ?? ?? ?? 00 74 06 FF 15 ?? ?? ?? ?? 68 FF 00 00 00 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_502_1_0 {
	meta:
		name = "__NMSG_WRITE"
		size = 447
		refs = "002d _rterrs 0067 __CrtDbgReport 0076 ___error_mode 0088 ___app_type 00a1 _strlen 00b8 __imp__GetStdHandle@4 00bf __imp__WriteFile@20 00e5 __imp__GetModuleFileNameA@12 00ee ??_C@_0BH@NNCD@?$DMprogram?5name?5unknown?$DO?$AA@ 00fa _strcpy 013a ??_C@_03NAME@?4?4?4?$AA@ 0143 _strncpy 014b ??_C@_0BK@DEOK@Runtime?5Error?$CB?6?6Program?3?5?$AA@ 016a _strcat 0172 ??_C@_02JJJH@?6?6?$AA@ 01a5 ??_C@_0CF@JPDF@Microsoft?5Visual?5C?$CL?$CL?5Runtime?5Lib@ 01b1 ___crtMessageBoxA"
	strings:
		$1 = { 55 8B EC 81 EC B0 01 00 00 53 56 57 C7 45 F8 00 00 00 00 EB 09 8B 45 F8 83 C0 01 89 45 F8 83 7D F8 12 73 13 8B 4D F8 8B 55 08 3B 14 CD ?? ?? ?? ?? 75 02 EB 02 EB DE 8B 45 F8 8B 4D 08 3B 0C C5 ?? ?? ?? ?? 0F 85 6E 01 00 00 81 7D 08 FC 00 00 00 74 21 8B 55 F8 8B 04 D5 ?? ?? ?? ?? 50 6A 00 6A 00 6A 00 6A 01 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 3D ?? ?? ?? ?? 01 74 12 83 3D ?? ?? ?? ?? 00 75 42 83 3D ?? ?? ?? ?? 01 75 39 6A 00 8D 4D FC 51 8B 55 F8 8B 04 D5 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 50 8B 4D F8 8B 14 CD ?? ?? ?? ?? 52 6A F4 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? E9 F0 00 00 00 81 7D 08 FC 00 00 00 0F 84 E3 00 00 00 68 04 01 00 00 8D 85 F0 FE FF FF 50 6A 00 FF 15 ?? ?? ?? ?? 85 C0 75 14 68 ?? ?? ?? ?? 8D 8D F0 FE FF FF 51 E8 ?? ?? ?? ?? 83 C4 08 8D 95 F0 FE FF FF 89 55 F4 8B 45 F4 50 E8 ?? ?? ?? ?? 83 C4 04 83 C0 01 83 F8 3C 76 2C 8D 8D F0 FE FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 F4 8D 44 02 C5 89 45 F4 6A 03 68 ?? ?? ?? ?? 8B 4D F4 51 E8 ?? ?? ?? ?? 83 C4 0C 68 ?? ?? ?? ?? 8D 95 50 FE FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 8B 45 F4 50 8D 8D 50 FE FF FF 51 E8 ?? ?? ?? ?? 83 C4 08 68 ?? ?? ?? ?? 8D 95 50 FE FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 8B 45 F8 8B 0C C5 ?? ?? ?? ?? 51 8D 95 50 FE FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 68 10 20 01 00 68 ?? ?? ?? ?? 8D 85 50 FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_502_2_0 {
	meta:
		name = "__GET_RTERRMSG"
		size = 80
		refs = "0025 _rterrs"
	strings:
		$1 = { 55 8B EC 51 C7 45 FC 00 00 00 00 EB 09 8B 45 FC 83 C0 01 89 45 FC 83 7D FC 12 73 13 8B 4D FC 8B 55 08 3B 14 CD ?? ?? ?? ?? 75 02 EB 02 EB DE 8B 45 FC 8B 4D 08 3B 0C C5 ?? ?? ?? ?? 75 0C 8B 55 FC 8B 04 D5 ?? ?? ?? ?? EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_503_0_0 {
	meta:
		name = "__ismbcgraph"
		size = 245
		refs = "003c ___ismbcodepage 004d ___mblcid 0054 ___mbcodepage 0066 ___crtGetStringTypeA 00b8 __ctype 00d3 __mbctype"
	strings:
		$1 = { 55 8B EC 83 EC 10 81 7D 08 FF 00 00 00 0F 86 97 00 00 00 66 C7 45 F8 00 00 33 C0 66 89 45 FA 8B 4D 08 C1 E9 08 81 E1 FF 00 00 00 88 4D FC 8B 55 08 81 E2 FF 00 00 00 88 55 