private rule architecture {
	meta:
		bits = 32
		endianness = "big"
		architecture = "PowerPC"
	condition:
		true
}

rule file_0_0_0 {
	meta:
		name = "__fsetlocking"
		size = 64
	strings:
		$1 = { 80 03 00 00 2C 04 00 00 7C 69 1B 78 54 0B 8F FE 2F 8B 00 00 7C 60 00 26 54 63 FF FE 20 63 00 02 4D 82 00 20 2F 84 00 02 54 00 04 5E 90 09 00 00 4C BE 00 20 60 00 80 00 90 09 00 00 4E 80 00 20 }
	condition:
		$1
}

rule file_1_0_0 {
	meta:
		name = "get_scope"
		size = 216
	strings:
		$1 = { A0 03 00 00 7C 6B 1B 78 2F 80 00 0A 41 9E 00 58 2F 80 00 02 38 60 00 0F 4C BE 00 20 3D 20 ?? ?? 81 0B 00 04 81 29 ?? ?? 81 69 00 04 80 09 00 00 7D 0B 58 38 7F 8B 00 00 39 69 00 0C 41 9E 00 20 81 4B 00 04 7D 69 5B 78 80 0B 00 00 39 6B 00 0C 7D 0A 50 38 7F 8A 00 00 40 9E FF E8 80 69 00 08 4E 80 00 20 88 03 00 08 2F 80 00 FF 41 9E 00 60 80 03 00 08 3D 40 FE 80 38 60 00 02 54 09 00 12 7F 89 50 00 4D 9E 00 20 2F 80 00 00 40 9E 00 28 80 0B 00 0C 2F 80 00 00 40 9E 00 1C 80 0B 00 10 2F 80 00 00 40 9E 00 10 80 0B 00 14 2F 80 00 01 4D 9E 00 20 3C 00 FE C0 7F 89 00 00 38 60 00 0E 4C BE 00 20 38 60 00 05 4E 80 00 20 88 63 00 09 54 63 07 3E 4E 80 00 20 }
	condition:
		$1
}

rule file_1_1_0 {
	meta:
		name = "prefixcmp"
		size = 40
	strings:
		$1 = { 80 03 00 10 38 60 00 01 81 24 00 10 7F 80 48 40 4D 9C 00 20 7F 80 48 00 38 60 FF FF 4C 9E 00 20 38 60 00 00 4E 80 00 20 }
	condition:
		$1
}

rule file_1_2_0 {
	meta:
		name = "scopecmp"
		size = 40
	strings:
		$1 = { 80 03 00 04 38 60 FF FF 81 24 00 04 7F 80 48 40 4D 9D 00 20 7C 00 4A 78 7C 00 00 34 54 00 D9 7E 68 03 00 01 4E 80 00 20 }
	condition:
		$1
}

rule file_1_3_0 {
	meta:
		name = "free_prefixlist"
		size = 64
		refs = "001c free"
	strings:
		$1 = { 2C 03 00 00 94 21 FF F0 7C 08 02 A6 93 E1 00 0C 90 01 00 14 41 82 00 18 83 E3 00 18 4? ?? ?? ?? 2F 9F 00 00 7F E3 FB 78 40 9E FF F0 80 01 00 14 83 E1 00 0C 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_1_4_0 {
	meta:
		name = "free_scopelist"
		size = 64
		refs = "001c free"
	strings:
		$1 = { 2C 03 00 00 94 21 FF F0 7C 08 02 A6 93 E1 00 0C 90 01 00 14 41 82 00 18 83 E3 00 0C 4? ?? ?? ?? 2F 9F 00 00 7F E3 FB 78 40 9E FF F0 80 01 00 14 83 E1 00 0C 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_1_5_0 {
	meta:
		name = "in6aicmp"
		size = 44
		refs = "0018 memcmp"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 38 63 00 08 38 84 00 08 90 01 00 14 38 A0 00 10 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_1_6_0 {
	meta:
		name = "match_prefix"
		size = 248
	strings:
		$1 = { A0 03 00 00 7C 69 1B 78 94 21 FF D0 2F 80 00 02 41 9E 00 18 2F 80 00 0A 41 9E 00 4C 7C A3 2B 78 38 21 00 30 4E 80 00 20 A1 43 00 02 38 00 00 00 81 63 00 04 39 00 00 0A B1 41 00 0A 39 40 FF FF 39 21 00 08 90 01 00 18 B1 01 00 08 90 01 00 0C 90 01 00 10 90 01 00 14 B1 41 00 1A 91 61 00 1C 90 01 00 20 38 A0 00 00 38 C9 00 08 60 A5 FF 00 81 04 00 10 7C 8B 23 78 7C CA 33 78 2B 88 00 07 40 9D 00 48 88 E4 00 00 88 09 00 08 7F 87 00 00 40 9E 00 50 38 E8 FF F8 54 E7 E8 FE 38 E7 00 01 7C E9 03 A6 48 00 00 14 88 EB 00 00 88 0A 00 00 7F 87 00 00 40 9E 00 2C 39 6B 00 01 39 4A 00 01 39 08 FF F8 42 00 FF E4 88 0B 00 00 7C A8 46 30 89 4A 00 00 7D 40 02 78 7C 0B 40 39 41 82 00 0C 38 84 00 18 4B FF FF 8C 80 A4 00 14 38 21 00 30 7C A3 2B 78 4E 80 00 20 }
	condition:
		$1
}

rule file_1_7_0 {
	meta:
		name = "get_label"
		size = 20
	strings:
		$1 = { 3D 20 ?? ?? 3C A0 7F FF 80 89 ?? ?? 60 A5 FF FF 4B FF FE F8 }
	condition:
		$1
}

rule file_1_8_0 {
	meta:
		name = "rfc3484_sort"
		size = 1564
		refs = "0358 __check_native 0578 __assert_fail"
	strings:
		$1 = { 94 21 FF B0 7C 08 02 A6 90 01 00 54 93 21 00 34 83 23 00 00 93 A1 00 44 1F B9 00 2C 93 E1 00 4C 83 E5 00 00 93 81 00 40 7F 9F EA 14 88 1C 00 21 93 01 00 30 2F 80 00 00 83 04 00 00 93 C1 00 48 1F D8 00 2C 93 41 00 38 7C BA 2B 78 93 61 00 3C 7F 7F F2 14 92 41 00 18 92 61 00 1C 92 81 00 20 92 A1 00 24 92 C1 00 28 92 E1 00 2C 40 9E 01 E0 88 1B 00 21 2F 80 00 00 40 9E 01 74 7D 3F E8 2E 82 A9 00 14 7E A3 AB 78 4B FF FC 99 7D 3F F0 2E 7C 77 1B 78 80 69 00 14 4B FF FC 89 7C 76 1B 78 3E 80 ?? ?? 3A 94 ?? ?? 80 94 00 08 38 A0 00 00 7E A3 AB 78 4B FF FE 41 7D 3F F0 2E 7C 75 1B 78 80 94 00 08 80 69 00 14 38 A0 00 00 4B FF FE 29 7F 95 18 00 41 9D 01 70 41 9C 01 14 88 1C 00 21 2F 80 00 00 41 9E 00 48 82 BC 00 24 82 9B 00 24 7F 95 A0 00 41 9E 00 38 80 1C 00 28 81 3B 00 28 2F 80 FF FF 90 01 00 08 91 21 00 0C 41 9E 02 E0 2F 89 FF FF 41 9E 02 28 2F 80 00 00 40 9E 02 F8 2F 89 00 00 38 60 00 01 40 BE 00 C8 7F 96 B8 00 41 9D 01 14 41 9C 00 B8 88 1C 00 21 2F 80 00 00 41 9E 00 1C 7D 7F E8 2E 7D 3F F0 2E 80 0B 00 04 81 49 00 04 7F 80 50 00 41 9E 02 CC 7C 78 C8 10 7C 63 19 10 60 63 00 01 48 00 00 88 7C 0B 03 78 38 E0 00 20 7D 69 02 78 7C E9 03 A6 39 60 00 00 3C 00 80 00 48 00 00 10 39 6B 00 01 42 40 00 10 54 00 F8 7E 7C 07 48 39 41 82 FF F0 55 4A 10 3A 7D 08 52 14 7F 7B 52 14 80 08 00 08 81 5B 00 0C 39 00 00 20 39 20 00 00 7D 09 03 A6 7D 4A 02 78 3C 00 80 00 48 00 00 10 39 29 00 01 42 40 00 10 54 00 F8 7E 7C 07 50 39 41 82 FF F0 7F 8B 48 00 38 60 FF FF 41 BD 00 0C 40 BC FF 74 38 60 00 01 80 01 00 54 82 41 00 18 7C 08 03 A6 82 61 00 1C 82 81 00 20 82 A1 00 24 82 C1 00 28 82 E1 00 2C 83 01 00 30 83 21 00 34 83 41 00 38 83 61 00 3C 83 81 00 40 83 A1 00 44 83 C1 00 48 83 E1 00 4C 38 21 00 50 4E 80 00 20 89 3B 00 22 71 28 00 01 41 A2 00 80 38 60 FF FF 4B FF FF A8 88 1B 00 21 2F 80 00 00 41 BE FF F0 7D 3F E8 2E 3A 9C 00 04 3A BB 00 04 82 69 00 14 7E 63 9B 78 4B FF FA B5 7D 3F F0 2E 7C 77 1B 78 80 69 00 14 4B FF FA A5 7C 76 1B 78 7E 83 A3 78 4B FF FA 99 7C 72 1B 78 7E A3 AB 78 4B FF FA 8D 7F 97 90 00 41 9E 01 68 7F 96 18 00 41 BE FF 48 88 1C 00 22 70 07 00 01 41 A2 FF 88 89 3B 00 22 71 2B 00 01 41 A2 FF 30 70 07 00 02 41 82 00 5C 71 2B 00 02 41 A2 FF 78 7E 63 9B 78 4B FF FD 19 7C 73 1B 78 7E 83 A3 78 4B FF FD 0D 7D 3F F0 2E 7C 74 1B 78 80 69 00 14 4B FF FC FD 7C 72 1B 78 7E A3 AB 78 4B FF FC F1 7F 93 A0 00 41 9E 00 28 7F 92 18 00 38 60 00 01 41 9E FE E0 7D 3F E8 2E 82 A9 00 14 4B FF FD 84 71 28 00 02 41 82 FF AC 4B FF FE C4 7F 92 18 00 38 60 FF FF 40 9E FE BC 4B FF FF DC 3A A0 FF FF 38 00 00 00 90 01 00 0C 7E A3 AB 78 38 81 00 08 7E 85 A3 78 38 C1 00 0C 4? ?? ?? ?? 81 5A 00 04 2F 8A 00 00 40 9D 00 7C 81 01 00 08 39 60 00 00 80 E1 00 0C 81 3A 00 00 48 00 00 1C 7F 94 00 00 41 9E 00 40 39 6B 00 01 7F 8A 58 00 39 29 00 2C 40 9D 00 50 80 09 00 24 7F 80 A8 00 40 9E FF E0 80 09 00 28 2F 80 FF FF 41 9E 00 0C 7F 80 40 00 40 9E 02 0C 91 09 00 28 81 5A 00 04 4B FF FF C8 80 09 00 28 2F 80 FF FF 41 9E 00 0C 7F 80 38 00 40 9E 01 CC 90 E9 00 28 81 5A 00 04 4B FF FF A8 80 01 00 08 81 21 00 0C 4B FF FD 30 2F 89 FF FF 38 00 00 00 90 01 00 08 41 BE FF 48 3A 80 FF FF 4B FF FF 48 7F 96 18 00 38 60 FF FF 40 9E FD E4 4B FF FE 98 2F 89 00 00 40 9E FD 14 38 60 FF FF 4B FF FD D0 2F 80 00 02 41 9E 00 7C 2F 80 00 0A 40 BE FD 2C A0 1C 00 04 2F 80 00 0A 40 9E 01 C0 A0 1B 00 04 2F 80 00 0A 40 9E 01 94 80 EB 00 14 39 60 00 04 7D 69 03 A6 81 09 00 14 39 40 00 00 39 20 00 00 7C C7 4A 14 7D 7C 4A 14 80 06 00 08 81 6B 00 0C 7F 80 58 00 40 BE FC F8 7C C8 4A 14 7D 7B 4A 14 80 C6 00 08 81 6B 00 0C 7F 86 58 00 40 BE FC DC 39 4A 00 01 39 29 00 04 42 00 FF C8 4B FF FC BC A0 1C 00 04 2F 80 00 02 40 9E 00 D0 A0 1B 00 04 2F 80 00 02 40 9E 00 A4 81 6B 00 14 88 1C 00 23 81 6B 00 04 81 5C 00 08 20 00 00 20 7D 4A 5A 78 39 60 FF FF 7D 60 00 30 7C 07 50 39 39 60 00 00 40 82 00 28 39 00 00 20 7D 09 03 A6 3C 00 80 00 7C 07 50 39 40 82 00 14 39 6B 00 01 42 40 00 0C 54 00 F8 7E 4B FF FF EC 81 29 00 14 88 1B 00 23 81 29 00 04 81 5B 00 08 20 00 00 20 7D 4A 4A 78 39 20 FF FF 7D 20 00 30 7C 08 50 39 39 20 00 00 40 A2 FC A8 38 E0 00 20 7C E9 03 A6 3C 00 80 00 7C 08 50 39 40 A2 FC 94 39 29 00 01 42 40 FC 8C 54 00 F8 7E 4B FF FF EC 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 05 DA 38 C6 ?? ?? 4? ?? ?? ?? 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 05 D9 38 C6 ?? ?? 4? ?? ?? ?? 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 05 BC 38 C6 ?? ?? 4? ?? ?? ?? 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 05 B6 38 C6 ?? ?? 4? ?? ?? ?? 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 05 F9 38 C6 ?? ?? 4? ?? ?? ?? 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 05 F8 38 C6 ?? ?? 4? ?? ?? ?? }
	condition:
		$1
}

rule file_1_9_0 {
	meta:
		name = "gaiconf_init"
		size = 3044
		refs = "0088 _IO_new_fopen 0094 fileno 00a4 __fxstat64 00b6 _GLOBAL_OFFSET_TABLE_ 00ca __libc_tsd_CTYPE_B 00da _nl_current_LC_CTYPE 0118 __getline 0130 strchr 02e4 free 02ec _IO_new_fclose 032c malloc 03bc qsort 052c strcmp 0544 __errno_location 057c inet_pton 059c strtoul"
	strings:
		$1 = { 94 21 FE F0 7C 08 02 A6 7D 80 00 26 3C 60 ?? ?? 3C 80 ?? ?? 90 01 01 14 38 63 ?? ?? 38 00 00 00 93 41 00 F8 38 84 ?? ?? 91 C1 00 C8 91 E1 00 CC 92 01 00 D0 92 21 00 D4 92 41 00 D8 92 61 00 DC 92 81 00 E0 92 A1 00 E4 92 C1 00 E8 92 E1 00 EC 93 01 00 F0 93 21 00 F4 93 61 00 FC 93 81 01 00 93 A1 01 04 93 C1 01 08 93 E1 01 0C 91 81 00 C4 90 01 00 0C 90 01 00 10 98 01 00 08 90 01 00 14 90 01 00 18 98 01 00 09 4? ?? ?? ?? 7C 7A 1B 79 41 82 08 84 4? ?? ?? ?? 38 A1 00 48 7C 64 1B 78 38 60 00 03 4? ?? ?? ?? 2C 03 00 00 40 82 09 28 83 FA 00 00 3D 20 ?? ?? 90 61 00 1C 39 29 ?? ?? 63 FF 80 00 90 61 00 20 83 69 ?? ?? 3E 60 ?? ?? 93 FA 00 00 73 FF 00 10 81 29 ?? ?? 3E 80 ?? ?? 3E A0 ?? ?? 3B 20 00 00 3B C0 00 00 3B A0 00 00 7F 7B 12 14 7F 89 12 14 3A 73 ?? ?? 3D E0 ?? ?? 3A 94 ?? ?? 3A B5 ?? ?? 40 82 01 D8 38 61 00 1C 38 81 00 20 7F 45 D3 78 4? ?? ?? ?? 2F 83 00 00 40 9D 01 C0 82 E1 00 1C 38 80 00 23 7E E3 BB 78 4? ?? ?? ?? 2C 03 00 00 41 82 00 0C 9B E3 00 00 82 E1 00 1C 81 3B 00 00 81 5C 00 00 48 00 00 08 3A F7 00 01 2F 89 00 00 41 9E 09 88 88 17 00 00 54 0B 08 3C 7D 69 5A 2E 71 65 00 20 40 82 FF E4 2F 80 00 00 41 9E 06 CC 81 5C 00 00 7E FF BB 78 48 00 00 10 8C 1F 00 01 2F 80 00 00 41 9E 04 D8 2F 89 00 00 41 9E 09 10 88 1F 00 00 54 0B 08 3C 7D 69 5A 2E 71 68 00 20 41 82 FF DC 2F 80 00 00 7C F7 F8 50 41 9E 00 10 38 00 00 00 98 1F 00 00 3B FF 00 01 81 3B 00 00 81 5C 00 00 48 00 00 08 3B FF 00 01 2F 89 00 00 41 9E 08 F4 88 1F 00 00 54 0B 08 3C 7D 69 5A 2E 71 65 00 20 40 82 FF E4 2F 80 00 00 7F EB FB 78 41 9E 00 34 81 5C 00 00 48 00 00 10 8C 0B 00 01 2F 80 00 00 41 9E 00 20 2F 89 00 00 41 9E 08 A4 88 0B 00 00 54 00 08 3C 7C 09 02 2E 70 08 00 20 41 82 FF DC 7F 8B B8 00 41 9E 00 A4 88 0B 00 00 2F 80 00 00 41 9E 00 10 38 00 00 00 98 0B 00 00 39 6B 00 01 81 3B 00 00 80 DC 00 00 48 00 00 08 39 6B 00 01 2F 89 00 00 41 9E 08 94 88 0B 00 00 54 0A 06 3E 55 48 08 3C 7D 09 42 2E 71 05 00 20 40 82 FF E0 2F 8A 00 00 7D 78 5B 78 41 9E 00 30 81 5C 00 00 48 00 00 10 8C 0B 00 01 70 08 00 FF 41 82 00 1C 2F 89 00 00 41 9E 08 68 54 00 0D FC 7C 09 02 2E 70 05 00 20 41 82 FF E0 2F 87 00 06 38 00 00 00 98 0B 00 00 41 9E 05 2C 2B 87 00 06 41 9D 03 A4 2F 87 00 05 41 9E 02 50 83 FA 00 00 73 FF 00 10 41 82 FE 30 80 61 00 1C 4? ?? ?? ?? 7F 43 D3 78 4? ?? ?? ?? 83 81 00 10 2F 9C 00 00 40 9E 05 58 3F E0 ?? ?? 3B FF ?? ?? 7F FB FB 78 83 41 00 18 3B 9F 00 C0 7F 98 E3 78 2F 9A 00 00 41 9E 00 AC 8A E1 00 09 2E 17 00 00 41 92 06 FC 1C 7A 00 18 4? ?? ?? ?? 2F 83 00 00 7C 7C 1B 78 7C 78 1B 78 41 9E 07 EC 41 92 07 38 2F 9A 00 00 80 61 00 14 40 9D 00 54 39 3A FF FF 7F 49 03 A6 1D 29 00 18 7C 6B 1B 78 7D 3C 4A 14 81 4B 00 08 80 0B 00 0C 80 EB 00 00 81 0B 00 04 90 E9 00 00 91 09 00 04 91 49 00 08 90 09 00 0C 81 4B 00 10 80 0B 00 14 91 49 00 10 90 09 00 14 39 29 FF E8 81 6B 00 18 42 00 FF C8 4B FF F4 8D 80 81 00 18 3C C0 ?? ?? 7F 83 E3 78 38 A0 00 18 38 C6 ?? ?? 3F 80 ?? ?? 4? ?? ?? ?? 3B 9C ?? ?? 2F 9E 00 00 3B 5F 01 38 7F 57 D3 78 41 9E 00 9C 21 19 00 00 7D 1E 01 94 1C 68 00 0C 7D 1E 43 78 4? ?? ?? ?? 2F 03 00 00 7C 77 1B 78 2F 99 00 00 7C 7A 1B 78 41 9A 07 58 7F CA F3 78 41 9E 06 2C 2F 8A 00 00 40 9D 00 3C 39 2A FF FF 7D 49 03 A6 1D 29 00 0C 7F AB EB 78 7D 37 4A 14 81 0B 00 00 81 4B 00 04 80 0B 00 08 91 09 00 00 91 49 00 04 90 09 00 08 39 29 FF F4 81 6B 00 0C 42 00 FF E0 7F A3 EB 78 4B FF F4 25 3C C0 ?? ?? 7E E3 BB 78 7F C4 F3 78 38 A0 00 0C 38 C6 ?? ?? 3E E0 ?? ?? 4? ?? ?? ?? 3A F7 ?? ?? 3F A0 ?? ?? 3B DD ?? ?? 80 7E 00 04 93 7E 00 04 7F 83 F8 00 41 9E 00 08 4? ?? ?? ?? 80 7E 00 08 93 1E 00 08 7F 83 E0 00 41 9E 00 08 4? ?? ?? ?? 80 7D ?? ?? 93 5D ?? ?? 7F 83 B8 00 41 9E 00 08 4? ?? ?? ?? 81 21 00 98 81 41 00 9C 91 3E 00 14 91 5E 00 18 80 01 01 14 81 81 00 C4 7C 08 03 A6 81 C1 00 C8 81 E1 00 CC 7D 80 81 20 82 01 00 D0 82 21 00 D4 82 41 00 D8 82 61 00 DC 82 81 00 E0 82 A1 00 E4 82 C1 00 E8 82 E1 00 EC 83 01 00 F0 83 21 00 F4 83 41 00 F8 83 61 00 FC 83 81 01 00 83 A1 01 04 83 C1 01 08 83 E1 01 0C 38 21 01 10 4E 80 00 20 3C 80 ?? ?? 7E E3 BB 78 38 84 ?? ?? 4? ?? ?? ?? 2F 83 00 00 40 BE FD A0 3A 41 00 08 3A 21 00 10 3A 01 00 0C 4? ?? ?? ?? 39 C0 00 00 91 C3 00 00 7C 76 1B 78 38 80 00 2F 7F E3 FB 78 4? ?? ?? ?? 7C 77 1B 79 41 82 00 0C 99 D7 00 00 3A F7 00 01 38 60 00 0A 7F E4 FB 78 38 A1 00 28 4? ?? ?? ?? 2F 83 00 00 41 BE FD 50 2F 97 00 00 41 9E 03 AC 7E E3 BB 78 38 81 00 24 38 A0 00 0A 4? ?? ?? ?? 2F 83 FF FF 7C 7F 1B 78 41 9E 04 58 81 21 00 24 88 09 00 00 2F 80 00 00 40 BE FD 1C 2B 9F 00 80 41 9D FD 14 7F 03 C3 78 38 81 00 24 38 A0 00 0A 4? ?? ?? ?? 2F 83 FF FF 7C 78 1B 78 41 9E 05 60 81 21 00 24 88 09 00 00 2F 80 00 00 40 BE FC E8 2F 98 00 00 41 BC FC E0 38 60 00 1C 4? ?? ?? ?? 2C 03 00 00 41 82 05 B0 81 61 00 2C 81 21 00 30 80 01 00 34 81 41 00 28 93 E3 00 10 7F FF 00 34 57 FF D9 7E 91 43 00 00 91 63 00 04 91 23 00 08 90 03 00 0C 93 03 00 14 80 11 00 00 81 30 00 00 89 72 00 00 30 00 00 01 91 23 00 18 7F FF 5B 78 90 70 00 00 90 11 00 00 9B F2 00 00 83 FA 00 00 4B FF FC 78 7C F7 F8 50 4B FF FB 60 2F 87 00 07 41 9E 00 30 2F 87 00 0A 40 9E FC 5C 7E E3 BB 78 7E A4 AB 78 4? ?? ?? ?? 2F 83 00 00 40 BE FC 48 3A 41 00 09 3A 21 00 18 3A 01 00 14 4B FF FE A8 7E E3 BB 78 7E 84 A3 78 4? ?? ?? ?? 7C 72 1B 79 40 A2 FC 24 4? ?? ?? ?? 38 80 00 2F 92 43 00 00 7C 76 1B 78 7F E3 FB 78 4? ?? ?? ?? 7C 77 1B 79 41 82 00 0C 9A 57 00 00 3A F7 00 01 38 60 00 0A 7F E4 FB 78 38 A1 00 38 4? ?? ?? ?? 2F 83 00 00 41 9E 02 50 80 01 00 38 2F 80 00 00 40 BE FB D8 80 01 00 3C 2F 80 00 00 40 BE FB CC 81 21 00 40 60 00 FF FF 7F 89 00 00 40 9E FB BC 2F 97 00 00 41 9E 04 78 7E E3 BB 78 38 81 00 24 38 A0 00 0A 4? ?? ?? ?? 2F 83 FF FF 7C 7F 1B 78 41 9E 04 38 81 21 00 24 88 09 00 00 2F 80 00 00 40 BE FB 88 2B 9F 00 5F 40 BD FB 80 2B 9F 00 80 41 9D FB 78 7F 03 C3 78 38 81 00 24 38 A0 00 0A 4? ?? ?? ?? 2F 83 FF FF 7C 78 1B 78 41 9E 04 58 81 21 00 24 88 09 00 00 2F 80 00 00 40 BE FB 4C 2F 98 00 00 41 BC FB 44 38 60 00 10 4? ?? ?? ?? 2C 03 00 00 41 82 04 14 2F 9F 00 60 41 9E 04 20 23 FF 00 80 38 00 FF FF 7C 00 F8 30 81 21 00 44 7D 60 00 26 55 6B FF FE 93 A3 00 0C 3B DE 00 01 7C 09 48 38 91 23 00 00 7D 79 CB 78 7C 7D 1B 78 90 03 00 04 93 03 00 08 83 FA 00 00 4B FF FA F0 7E E3 BB 78 7E 64 9B 78 4? ?? ?? ?? 2F 83 00 00 40 BE FA D8 88 1F 00 00 35 00 FF 87 40 82 00 10 88 1F 00 01 35 20 FF 9B 41 82 00 E8 7C 00 00 26 54 00 1F FE 39 2F ?? ?? 2F 80 00 00 90 09 00 0C 41 BE FA A8 38 00 00 01 83 FA 00 00 90 09 00 10 4B FF FA 9C 7E FF BB 78 81 3B 00 00 38 E0 00 00 4B FF F9 7C 8B 41 00 08 2E 1A 00 00 41 92 01 BC 1C 7C 00 18 4? ?? ?? ?? 2F 83 00 00 7C 7F 1B 78 7C 7B 1B 78 41 9E 00 A8 41 92 01 D8 2F 9C 00 00 80 61 00 0C 40 9D 00 54 39 3C FF FF 7F 89 03 A6 1D 29 00 18 7C 6B 1B 78 7D 3F 4A 14 81 4B 00 08 80 0B 00 0C 80 EB 00 00 81 0B 00 04 90 E9 00 00 91 09 00 04 91 49 00 08 90 09 00 0C 81 4B 00 10 80 0B 00 14 91 49 00 10 90 09 00 14 39 29 FF E8 81 6B 00 18 42 00 FF C8 4B FF EF 59 80 81 00 10 3C C0 ?? ?? 7F E3 FB 78 38 A0 00 18 38 C6 ?? ?? 3F E0 ?? ?? 4? ?? ?? ?? 3B FF ?? ?? 4B FF FA 10 88 1F 00 02 34 A0 FF 8D 40 A2 FF 14 88 1F 00 03 2C 00 00 00 4B FF FF 08 3B A0 00 00 80 61 00 0C 4B FF EF 11 80 61 00 14 4B FF EF 09 7F A3 EB 78 4B FF EF 41 4? ?? ?? ?? 4B FF FB 8C 3B E0 00 80 4B FF FC 70 38 60 00 02 7F E4 FB 78 38 A1 00 44 4? ?? ?? ?? 2F 83 00 00 41 BE F9 80 2F 97 00 00 41 9E 01 C4 7E E3 BB 78 38 81 00 24 38 A0 00 0A 4? ?? ?? ?? 2F 83 FF FF 7C 7F 1B 78 41 9E 02 0C 81 21 00 24 88 09 00 00 2F 80 00 00 40 BE F9 4C 2B 9F 00 20 41 9D F9 44 7F 03 C3 78 38 81 00 24 38 A0 00 0A 4? ?? ?? ?? 2F 83 FF FF 7C 78 1B 78 41 9E 01 F4 81 21 00 24 88 09 00 00 2F 80 00 00 40 BE F9 18 2F 98 00 00 3B FF 00 60 40 9C FD CC 83 FA 00 00 4B FF F9 08 7F 43 D3 78 4? ?? ?? ?? 80 61 00 0C 3B A0 00 00 4B FF EE 49 80 61 00 14 4B FF EE 41 7F A3 EB 78 4B FF EE 79 4? ?? ?? ?? 4B FF FA C4 80 16 00 00 2F 80 00 22 40 9E FB A4 83 FA 00 00 4B FF F8 C8 3B 9C 00 01 93 81 00 10 4B FF FE 40 3B 5A 00 01 93 41 00 18 4B FF F9 00 39 5E FF FF 1C 0A 00 0C 7D 23 02 14 7F 23 01 2E 38 00 00 0E 93 29 00 04 90 09 00 08 4B FF F9 BC 3B 9C FF FF 1C 1C 00 18 7D 23 02 14 7F 43 01 2E 38 00 00 01 93 49 00 10 93 49 00 04 93 49 00 08 93 49 00 0C 90 09 00 14 4B FF FE 04 3B 5A FF FF 1C 1A 00 18 7D 23 02 14 7E E3 01 2E 38 00 00 28 92 E9 00 10 92 E9 00 04 92 E9 00 08 92 E9 00 0C 90 09 00 14 4B FF F8 A4 81 2A 00 00 81 29 00 24 39 29 01 00 91 3B 00 00 4B FF F6 E4 81 2A 00 00 81 29 00 24 39 29 01 00 91 3B 00 00 4B FF F7 50 81 2A 00 00 81 29 00 24 39 29 01 00 91 3B 00 00 4B FF F7 00 81 2A 00 00 81 29 00 24 39 29 01 00 91 3B 00 00 4B FF F6 6C 81 26 00 00 81 29 00 24 39 29 01 00 91 3B 00 00 4B FF F7 60 81 2A 00 00 81 29 00 24 39 29 01 00 91 3B 00 00 88 0B 00 00 4B FF F7 88 3B E0 00 20 4B FF FE 58 7F 9B F8 00 41 BE FD EC 7F 63 DB 78 4? ?? ?? ?? 4B FF FD E0 80 16 00 00 2F 80 00 22 40 9E FA 9C 83 FA 00 00 4B FF F7 8C 7F 9B F8 00 41 9E 00 0C 7F 63 DB 78 4? ?? ?? ?? 7F 98 E0 00 41 BE FD B4 7F 03 C3 78 4? ?? ?? ?? 4B FF FD A8 80 16 00 00 2F 80 00 22 40 9E FB C4 4B FF F7 54 80 16 00 00 2F 80 00 22 40 9E FD F0 83 FA 00 00 4B FF F7 44 3B E0 00 80 4B FF FB A4 80 16 00 00 2F 80 00 22 40 9E FE 08 83 FA 00 00 4B FF F7 28 80 61 00 1C 4? ?? ?? ?? 7F 43 D3 78 4? ?? ?? ?? 4B FF FD 54 38 00 00 00 4B FF FB EC 80 16 00 00 2F 80 00 22 40 9E FB A4 83 FA 00 00 4B FF F6 F8 }
	condition:
		$1
}

rule file_1_10_0 {
	meta:
		name = "gaih_inet_serv.clone.1"
		size = 264
		refs = "0074 __getservbyname_r"
	strings:
		$1 = { 94 21 FF B0 7C 08 02 A6 90 01 00 54 93 21 00 34 7C B9 2B 78 93 41 00 38 7C 9A 23 78 93 61 00 3C 7C DB 33 78 93 81 00 40 7C 7C 1B 78 93 A1 00 44 3B A4 00 0A 93 C1 00 48 3B C0 04 00 93 E1 00 4C 7C 3F 0B 78 38 1E 00 1E 81 21 00 00 54 00 00 36 7C 00 00 D0 7D 21 01 6E 7F C7 F3 78 7F 83 E3 78 38 C1 00 17 7F A4 EB 78 38 BF 00 0C 54 C6 00 36 39 1F 00 08 4? ?? ?? ?? 57 DE 08 3C 7C 60 1B 79 2F 80 00 22 41 82 00 10 41 9E FF BC 38 60 01 08 48 00 00 40 81 3F 00 08 38 60 01 08 2F 89 00 00 41 9E 00 30 81 7A 00 00 90 1B 00 00 91 7B 00 04 88 1A 00 08 70 0B 00 02 41 82 00 48 81 79 00 00 80 09 00 08 38 60 00 00 91 7B 00 08 90 1B 00 0C 39 7F 00 50 80 0B 00 04 83 2B FF E4 7C 08 03 A6 83 4B FF E8 83 6B FF EC 83 8B FF F0 83 AB FF F4 83 CB FF F8 83 EB FF FC 7D 61 5B 78 4E 80 00 20 81 7A 00 04 4B FF FF BC }
	condition:
		$1
}

rule file_1_11_0 {
	meta:
		name = "gaih_inet"
		size = 6424
		refs = "02a4 __idna_to_ascii_lz 039c __inet_aton 049c malloc 0544 free 0560 strlen 058c memcpy 0610 strchr 0630 inet_pton 06c8 strtoul 072a __nss_not_use_nscd_hosts 0752 __nss_database_custom 0762 __nss_hosts_database 077a _res_hconf 078a _GLOBAL_OFFSET_TABLE_ 0792 __libc_resp 07a0 __res_maybe_init 0810 __nss_lookup_function 082c _dl_mcount_wrapper_check 091a in6addr_loopback 0a1c __idna_to_unicode_lzlz 0df8 __strdup 0fd0 __gethostbyname2_r 1364 if_nametoindex 13ac __gethostbyaddr_r 1534 __nscd_getai 1730 mempcpy 17a6 __libc_h_errno 1808 __errno_location 18c0 _res_hconf_init 18ec __nss_database_lookup 1914 __assert_fail"
	strings:
		$1 = { 94 21 FF 40 7C 08 02 A6 7D 80 00 26 39 20 00 00 90 01 00 C4 80 05 00 0C 93 81 00 B0 3F 80 ?? ?? 2C 80 00 00 3B 9C ?? ?? 93 E1 00 BC 3B 9C 00 1C 7C 3F 0B 78 92 C1 00 98 7C F6 3B 78 92 E1 00 9C 7C 77 1B 78 93 61 00 AC 7C 9B 23 78 93 A1 00 B4 7C DD 33 78 93 C1 00 B8 7C BE 2B 78 91 C1 00 78 91 E1 00 7C 92 01 00 80 92 21 00 84 92 41 00 88 92 61 00 8C 92 81 00 90 92 A1 00 94 93 01 00 A0 93 21 00 A4 93 41 00 A8 91 81 00 74 93 9F 00 10 91 3F 00 14 41 86 00 C4 81 65 00 08 2F 0B 00 00 3C 80 ?? ?? 38 84 ?? ?? 38 84 01 94 41 9A 00 8C 81 24 00 00 7F 8B 48 00 41 9E 00 80 38 84 00 14 89 24 00 0A 2F 89 00 00 40 9E FF E4 40 9A 01 3C 38 60 01 08 39 7F 00 C0 80 0B 00 04 81 8B FF B4 7C 08 03 A6 81 CB FF B8 81 EB FF BC 7D 83 81 20 82 0B FF C0 82 2B FF C4 82 4B FF C8 82 6B FF CC 82 8B FF D0 82 AB FF D4 82 CB FF D8 82 EB FF DC 83 0B FF E0 83 2B FF E4 83 4B FF E8 83 6B FF EC 83 8B FF F0 83 AB FF F4 83 CB FF F8 83 EB FF FC 7D 61 5B 78 4E 80 00 20 41 86 00 38 89 24 00 08 71 26 00 02 40 82 00 2C 81 24 00 04 7F 80 48 00 40 9E FF 6C 48 00 00 1C 81 65 00 08 2F 0B 00 00 40 BA FF 40 3C 80 ?? ?? 38 84 ?? ?? 38 84 01 80 2F 9B 00 00 41 9E 08 6C 89 24 00 08 71 28 00 01 40 A2 FF 50 81 5B 00 04 2F 8A 00 00 41 9C 01 4C 2F 8B 00 00 40 9E 00 7C 40 86 00 78 38 84 00 14 88 04 00 0A 2F 80 00 00 41 9E 00 A4 39 7F 00 10 38 E0 00 00 48 00 00 14 38 84 00 14 88 04 00 0A 2F 80 00 00 41 9E 00 88 88 04 00 09 2F 80 00 00 41 9E FF E8 80 01 00 00 81 04 00 00 94 01 FF E0 80 04 00 04 39 21 00 1F 55 29 00 36 90 E9 00 00 91 09 00 04 90 09 00 08 91 49 00 0C 91 2B 00 00 7D 2B 4B 78 4B FF FF B4 38 60 01 07 4B FF FE C8 89 64 00 08 39 00 00 00 81 21 00 00 71 66 00 02 81 64 00 00 95 21 FF E0 39 21 00 1F 55 29 00 36 91 3F 00 10 91 09 00 00 91 69 00 04 40 82 00 08 80 04 00 04 90 09 00 08 91 49 00 0C 2D 97 00 00 41 8E 07 30 80 BE 00 00 80 01 00 00 70 A8 00 40 94 01 FF D0 38 00 00 00 38 81 00 1F 54 84 00 36 90 9F 00 14 90 04 00 08 90 04 00 1C 90 04 00 00 41 82 01 10 70 A9 02 00 54 A5 C7 FE 41 82 00 08 60 A5 00 02 38 00 00 00 7F E4 FB 78 94 04 00 2C 7E E3 BB 78 4? ?? ?? ?? 2F 83 00 00 90 7F 00 18 7C 60 1B 78 41 9E 02 9C 2F 80 00 C9 38 60 00 0A 41 BE FE 14 2F 80 00 CA 38 60 00 69 40 9E FE 08 38 60 00 0B 4B FF FE 00 88 04 00 0A 2F 80 00 00 40 9E 08 2C 3B 44 00 14 88 1A 00 0A 2F 80 00 00 41 9E 07 E4 3A BF 00 10 3B 1E 00 0C 48 00 00 20 81 7A 00 00 7F 89 58 00 41 9E 00 2C 3B 5A 00 14 88 1A 00 0A 2F 80 00 00 41 9E 07 BC 88 1A 00 08 70 09 00 01 40 A2 FF E8 81 3E 00 08 2F 89 00 00 40 BE FF D0 81 3E 00 0C 2F 89 00 00 41 9E 00 18 70 0A 00 02 40 82 00 10 80 1A 00 04 7F 89 00 00 40 9E FF BC 80 01 00 00 7F 44 D3 78 80 7B 00 00 7F 05 C3 78 94 01 FF E0 3B 21 00 1F 57 39 00 36 7F 26 CB 78 4B FF FB 85 2F 83 00 00 90 7F 00 18 41 9E 00 80 70 6B 01 00 40 82 FF 84 4B FF FD 48 7E F9 BB 78 7F 23 CB 78 38 84 00 0C 4? ?? ?? ?? 2F 83 00 00 41 9E 00 68 80 1E 00 04 2F 80 00 00 41 9E 02 34 2F 80 00 02 41 9E 02 2C 2F 80 00 0A 38 60 00 09 40 9E FD 10 81 3E 00 00 71 2A 00 08 41 A2 FD 04 83 1F 00 14 39 60 00 00 81 58 00 0C 91 78 00 10 91 58 00 18 39 40 00 00 61 4A FF FF 91 58 00 14 91 78 00 0C 90 18 00 08 48 00 01 F8 93 35 00 00 7F 35 CB 78 4B FF FF 04 83 1F 00 14 3B 80 00 00 3A 80 00 00 83 78 00 08 2F 9B 00 00 41 9E 01 E8 2F 98 00 00 41 9E 0A EC 2D 14 00 00 3B 20 00 00 7F 1A C3 78 3B 60 00 00 63 39 FF FF 7F 98 D0 00 41 9E 05 A4 A2 BA 00 0A 2E 15 00 0A 41 92 01 54 3A 80 00 10 83 1F 00 10 3A 74 00 20 2F 98 00 00 40 BE 00 34 48 00 00 B8 80 18 00 0C B0 09 00 02 80 1A 00 0C 93 63 00 28 90 03 00 24 93 63 00 2C 83 18 00 00 3B A3 00 1C 2F 98 00 00 41 9E 00 8C 3B 80 00 00 7E 63 9B 78 4? ?? ?? ?? 2F 83 00 00 90 7D 00 00 41 9E 00 98 81 78 00 04 39 23 00 20 80 18 00 08 81 5E 00 00 92 A3 00 04 91 43 00 00 91 63 00 08 90 03 00 0C 92 83 00 10 91 23 00 14 93 83 00 18 B2 A3 00 20 93 63 00 1C 40 92 FF 8C 80 18 00 0C 93 69 00 04 B0 09 00 02 80 1A 00 18 80 DA 00 0C 80 FA 00 10 81 1A 00 14 90 C3 00 28 90 E3 00 2C 91 03 00 30 90 03 00 34 80 1A 00 1C 90 09 00 18 4B FF FF 6C 3B 80 00 00 81 36 00 00 38 09 00 01 90 16 00 00 83 5A 00 00 2F 9A 00 00 41 9E 09 E0 83 1F 00 14 4B FF FF 04 7F 83 E3 78 4? ?? ?? ?? 38 60 00 0A 4B FF FB 88 83 3F 00 2C 7F 99 B8 00 41 9E 00 44 7F 23 CB 78 4? ?? ?? ?? 81 21 00 00 38 03 00 1F 54 00 00 36 7C 00 00 D0 7D 21 01 6E 7C 65 1B 78 7F 24 CB 78 38 61 00 1F 54 63 00 36 38 A5 00 01 4? ?? ?? ?? 7C 79 1B 78 80 7F 00 2C 4? ?? ?? ?? 80 9F 00 14 4B FF FD F4 3A 80 00 1C 41 AA FE B0 80 1E 00 00 54 00 06 F8 2F 80 00 08 40 9E FE A0 80 1A 00 0C 2F 80 00 00 40 BE FE 94 80 1A 00 10 2F 80 00 00 40 BE FE 88 80 1A 00 14 7F 80 C8 00 40 9E FE 7C 4B FF FF 4C 83 1F 00 14 38 00 00 02 81 3E 00 00 90 18 00 08 71 2B 00 02 7F 3C CB 78 41 82 03 78 3A 80 00 00 4B FF FE 20 7F 23 CB 78 38 80 00 25 4? ?? ?? ?? 2E 03 00 00 7C 7A 1B 78 40 92 10 EC 7F 3C CB 78 38 60 00 0A 7F 84 E3 78 38 B8 00 0C 4? ?? ?? ?? 2F 83 00 00 40 9D 07 AC 80 1E 00 04 2F 80 00 00 41 9E 06 60 2F 80 00 0A 41 9E 06 58 2F 80 00 02 38 60 00 09 40 9E FA 7C 83 1F 00 14 81 38 00 0C 2F 89 00 00 40 BE FA 6C 81 38 00 10 2F 89 00 00 40 BE FA 60 81 78 00 14 61 29 FF FF 7F 8B 48 00 40 9E FA 50 81 38 00 18 90 18 00 08 91 38 00 0C 41 92 00 50 81 38 00 0C 3C 00 FE 80 55 29 00 12 7F 89 00 00 41 9E 0C B4 88 18 00 0C 3B 9A 00 01 2F 80 00 FF 41 9E 0C 94 7F 83 E3 78 38 9F 00 2C 38 A0 00 0A 4? ?? ?? ?? 81 3F 00 2C 90 78 00 1C 88 09 00 00 2F 80 00 00 40 9E 0F F4 83 1F 00 14 80 1E 00 00 70 06 00 02 40 82 07 DC 81 38 00 08 3B 80 00 00 2F 89 00 00 40 BE FF 04 80 1E 00 00 38 60 01 02 70 08 00 04 40 82 F9 C8 83 7E 00 04 91 3F 00 1C 2F 9B 00 02 41 9E 08 48 2F 9B 00 0A 41 9E 08 34 3F 60 ?? ?? 80 1B ?? ?? 2F 80 00 00 40 9D 07 A0 30 00 00 01 2F 80 00 64 90 1B ?? ?? 40 9D 07 90 38 00 00 00 90 1B ?? ?? 3D 20 ?? ?? 88 09 ?? ?? 2F 80 00 00 41 9E 0D C8 3D 20 ?? ?? 80 09 ?? ?? 2F 80 00 00 41 9E 11 68 90 1F 00 1C 3B 40 00 00 3D 20 ?? ?? 80 09 ?? ?? 2F 80 00 00 41 9E 11 3C 3D C0 ?? ?? 39 CE ?? ?? 83 6E ?? ?? 7F 7B 12 14 80 7B 00 00 38 80 00 00 4? ?? ?? ?? 2F 83 FF FF 41 9E 0C C4 81 3B 00 00 2F 9A 00 00 81 09 00 08 55 00 04 E2 91 1F 00 50 90 09 00 08 80 01 00 00 94 01 FB F0 3B 41 00 1F 57 5A 00 36 40 9E 0C B4 3E 00 ?? ?? 80 7F 00 1C 92 FF 00 54 3B 60 04 00 39 20 FF FF 3A 20 FF FF 3A 40 00 00 3B 1F 00 14 3A 80 00 00 3A 10 ?? ?? 3A 7F 00 2C 7F B5 EB 78 7E 04 83 78 91 3F 00 68 4? ?? ?? ?? 7C 7D 1B 79 81 3F 00 68 41 82 03 24 3A E0 00 00 7F A3 EB 78 92 FF 00 18 4? ?? ?? ?? 7F 23 CB 78 7F 04 C3 78 7F A9 03 A6 7F 45 D3 78 7F 66 DB 78 38 FF 00 18 39 1F 00 28 39 20 00 00 4E 80 04 21 2F 83 00 01 41 9E 02 2C 2F 83 FF FE 40 9E 01 DC 80 1F 00 18 2F 80 00 22 40 9E 02 94 81 FF 00 28 2F 8F FF FF 40 9E 02 6C 57 69 08 3C 81 61 00 00 38 09 00 1E 54 00 00 36 7C 00 00 D0 7D 61 01 6E 7F 7B 4A 14 38 01 00 1F 54 00 00 36 7D 60 4A 14 7F 9A 58 00 41 9E 00 08 7D 3B 4B 78 7C 1A 03 78 4B FF FF 70 80 01 00 00 81 7F 00 14 94 01 FF D0 38 01 00 1F 54 00 00 36 90 09 00 00 81 6B 00 00 92 EB 00 00 92 EB 00 04 92 EB 00 08 92 EB 00 0C 92 EB 00 10 92 EB 00 14 92 EB 00 18 92 EB 00 1C 80 1E 00 04 2F 80 00 00 40 9E 00 C4 81 3E 00 00 83 1F 00 14 71 26 00 01 39 20 00 0A 91 38 00 08 40 82 00 34 3D 60 ?? ?? 39 2B ?? ?? 81 0B ?? ?? 80 09 00 0C 81 49 00 04 81 69 00 08 91 18 00 0C 91 58 00 10 91 78 00 14 90 18 00 18 83 1F 00 14 80 1E 00 04 2F 80 00 00 81 38 00 00 40 9E 00 7C 80 1E 00 00 70 08 00 01 38 00 00 02 90 09 00 08 40 82 00 70 3C 00 7F 00 60 00 00 01 90 09 00 0C 3B 80 00 00 3A 80 00 00 4B FF FA A8 80 01 00 00 94 01 FF D0 39 21 00 1F 55 29 00 36 91 3F 00 14 92 E9 00 00 92 E9 00 04 92 E9 00 08 92 E9 00 0C 92 E9 00 10 92 E9 00 14 92 E9 00 18 92 E9 00 1C 80 1E 00 04 2F 80 00 00 41 BE FE FC 2F 80 00 0A 41 BE FF 3C 83 1F 00 14 2F 80 00 02 41 BE FF 84 3B 80 00 00 3A 80 00 00 4B FF FA 48 39 40 00 00 4B FF F7 AC 80 BE 00 00 70 A9 00 02 41 A2 FA 58 2F 9C 00 00 41 9E 09 88 70 AA 00 80 41 82 03 F4 70 AB 02 00 54 A5 C7 FE 41 82 00 08 60 A5 00 02 7F 83 E3 78 38 9F 00 2C 4? ?? ?? ?? 7C 60 1B 79 40 A2 F8 94 80 1F 00 2C 7F 80 E0 00 41 9E 03 C4 7C 1C 03 78 4B FF FA 10 81 FF 00 28 7C 69 1B 78 69 EF 00 04 7D EF 00 34 55 EF D9 7E 3A E9 00 02 7D F2 7B 78 81 7F 00 1C 56 EA 10 3A 7D 4B 52 14 80 0A 00 04 2F 80 00 01 41 9E 04 B0 80 6B 00 00 2F 83 00 00 41 9E 04 A4 90 7F 00 1C 4B FF FD 88 80 1E 00 00 7C 69 1B 78 70 06 00 02 41 82 00 0C 2F 9C 00 00 41 9E 00 30 81 78 00 00 2F 8B 00 00 41 9E 00 14 7D 78 5B 78 81 6B 00 00 2F 8B 00 00 40 9E FF F4 3A E0 00 03 3A 40 00 00 39 E0 00 00 4B FF FF 94 81 78 00 00 83 8B 00 04 4B FF FF D0 80 1F 00 10 7F 80 E0 00 40 9E F7 70 4B FF F5 F0 7C 69 1B 78 2F 8F 00 02 40 9E FF 58 3A E0 00 00 3A 40 FF FD 39 E0 FF FD 4B FF FF 5C 7C 69 1B 78 81 FF 00 28 4B FF FF E0 80 01 00 00 38 BE 00 0C 80 7B 00 00 94 01 FF E0 38 01 00 1F 54 00 00 36 7C 06 03 78 90 1F 00 10 4B FF F3 CD 2F 83 00 00 90 7F 00 18 41 9E F7 14 4B FF F5 98 80 1E 00 00 70 08 00 02 40 82 03 5C 3D 60 ?? ?? 80 7F 00 1C 80 8B ?? ?? 91 3F 00 68 4? ?? ?? ?? 7C 7D 1B 79 81 3F 00 68 41 82 0C 20 80 1E 00 04 2F 80 00 0A 41 9E 00 10 2F 80 00 00 39 E0 00 00 40 9E 00 D0 38 00 00 00 90 1F 00 2C 3A E0 00 00 7F A3 EB 78 92 FF 00 18 4? ?? ?? ?? 39 40 00 00 92 61 00 08 7F 23 CB 78 38 80 00 0A 7F A9 03 A6 38 BF 00 30 7F 46 D3 78 7F 67 DB 78 39 1F 00 18 39 3F 00 28 4E 80 04 21 81 5F 00 18 2F 8A 00 22 40 9E 00 E4 80 1F 00 28 2F 80 FF FF 40 9E 00 D8 57 69 08 3C 81 61 00 00 38 09 00 1E 54 00 00 36 7C 00 00 D0 7D 61 01 6E 7F 7B 4A 14 38 01 00 1F 54 00 00 36 7D 60 4A 14 7F 9A 58 00 41 9E 00 08 7D 3B 4B 78 7C 1A 03 78 4B FF FF 78 7D 57 53 78 82 5F 00 2C 2F 92 00 00 41 9E 00 0C 2F 9C 00 00 41 9E 0C 4C 2F 97 00 00 41 9E 08 D8 80 1E 00 04 3A 20 00 01 3A 40 00 00 39 E0 00 00 3A 80 00 01 2F 80 00 02 41 9E 00 A4 2F 80 00 00 41 9E 00 9C 2F 80 00 0A 41 9E 00 78 2F 91 00 01 41 9E 01 A0 2F 89 00 01 41 9E 01 98 2F 91 FF FE 41 9E 07 B4 2F 89 FF FF 3A E9 00 02 40 9E FD D0 2F 91 FF FF 3A E0 00 01 41 BE FD C4 3A F1 00 02 7E 29 8B 78 4B FF FD B8 83 1F 00 14 38 00 00 0A 90 18 00 08 4B FF F9 E4 2F 83 00 01 7C 69 1B 78 41 9E 03 B8 2F 8A 00 00 40 9E 02 20 7C 71 1B 78 80 1E 00 04 3A 40 00 00 39 E0 00 00 4B FF FF 78 80 1E 00 00 70 06 00 08 41 A2 FF 84 70 08 00 10 40 82 00 0C 2F 94 00 00 40 BE FF 74 38 00 00 00 90 1F 00 2C 3A E0 00 00 7F A3 EB 78 92 FF 00 18 4? ?? ?? ?? 7F 23 CB 78 92 61 00 08 38 80 00 02 38 BF 00 30 7F A9 03 A6 7F 46 D3 78 7F 67 DB 78 39 1F 00 18 39 3F 00 28 39 40 00 00 4E 80 04 21 80 1F 00 18 2F 80 00 22 40 9E 00 4C 81 7F 00 28 2F 8B FF FF 40 9E 00 40 57 69 08 3C 81 61 00 00 38 09 00 1E 54 00 00 36 7C 00 00 D0 7D 61 01 6E 7F 7B 4A 14 38 01 00 1F 54 00 00 36 7D 60 4A 14 7F 9A 58 00 41 9E 00 08 7D 3B 4B 78 7C 1A 03 78 4B FF FF 78 2F 83 00 01 7C 69 1B 78 41 9E 03 F4 2F 80 00 00 39 E0 00 00 41 9E 00 28 80 1F 00 28 2F 80 FF FF 41 9E 0A 74 2F 80 00 02 39 E0 FF FD 41 9E 00 10 68 0F 00 04 7D EF 00 34 55 EF D9 7E 80 1E 00 04 2F 80 00 02 40 9E FE 94 7D 31 4B 78 7D F2 7B 78 4B FF FE 88 83 1F 00 14 3B 80 00 00 81 38 00 08 4B FF F9 08 7F 83 E3 78 4? ?? ?? ?? 7C 7C 1B 79 40 82 F6 48 38 60 00 0A 4B FF F2 CC 80 1E 00 00 3A E0 00 03 39 20 00 01 70 08 00 02 41 A2 FC 3C 2F 9C 00 00 40 9E FC 34 3D 40 ?? ?? 80 7F 00 1C 80 8A ?? ?? 91 3F 00 68 4? ?? ?? ?? 7C 7D 1B 79 81 3F 00 68 41 A2 FC 14 80 01 00 00 94 01 FE F0 4? ?? ?? ?? 81 3F 00 14 3B 81 00 1F 80 69 00 04 57 9C 00 36 2F 83 00 00 40 BE 00 08 7F 23 CB 78 7F 84 E3 78 7F A9 03 A6 38 A0 01 00 7E 66 9B 78 38 FF 00 18 39 1F 00 28 4E 80 04 21 2F 83 00 01 41 9E 08 68 7F 3C CB 78 3A E0 00 03 39 20 00 01 4B FF FB B8 3D 40 ?? ?? 80 7F 00 1C 80 8A ?? ?? 91 3F 00 68 4? ?? ?? ?? 7C 7D 1B 79 81 3F 00 68 40 82 FC AC 4B FF FC 88 81 38 00 08 7F 3C CB 78 4B FF F8 28 80 1B ?? ?? 2F 80 00 00 40 9E F8 84 4B FF F8 70 81 FF 00 28 2F 8F FF FF 41 9E 08 AC 2F 8F 00 02 41 9E 05 B0 69 EF 00 04 80 1E 00 04 7D EF 00 34 55 EF D9 7E 7D 31 4B 78 7D F2 7B 78 4B FF FD 40 38 60 00 00 4B FF F1 BC 2F 8F 00 00 80 1F 00 50 81 2E ?? ?? 82 FF 00 54 7D 29 12 14 81 29 00 00 7E BD AB 78 90 09 00 08 40 9E 05 00 83 1F 00 14 38 60 01 02 80 18 00 08 2F 80 00 00 41 9E F1 84 4B FF F4 D0 54 00 06 F8 2F 80 00 18 41 BE F7 C8 80 01 00 00 3B 40 02 00 94 01 FD F0 3B 01 00 1F 57 18 00 36 48 00 00 3C 2F 83 00 00 40 9E 08 40 81 7F 00 24 2F 8B 00 00 40 9E 00 70 80 1E 00 04 2F 80 00 0A 40 9E 00 D4 80 1E 00 00 70 09 00 08 41 82 00 C8 2F 9B 00 0A 40 9E 00 C0 3B 60 00 02 7F 23 CB 78 7F 64 DB 78 38 BF 00 30 7F 06 C3 78 7F 47 D3 78 39 1F 00 24 39 3F 00 28 4? ?? ?? ?? 2F 83 00 22 40 9E FF A4 80 1F 00 28 2F 80 FF FF 41 9E 04 D4 2F 80 00 02 38 60 01 05 40 9E F0 E4 38 60 00 03 4B FF F0 DC 3A A0 00 00 }
	condition:
		$1
}

rule file_1_12_0 {
	meta:
		name = "freeaddrinfo"
		size = 84
		refs = "0024 free"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 93 E1 00 0C 7C 7F 1B 79 90 01 00 14 93 C1 00 08 41 82 00 24 80 7F 00 18 83 DF 00 1C 4? ?? ?? ?? 7F E3 FB 78 4? ?? ?? ?? 2F 9E 00 00 7F DF F3 78 40 9E FF E4 80 01 00 14 83 C1 00 08 7C 08 03 A6 83 E1 00 0C 38 21 00 10 4E 80 00 20 }
	condition:
		$1
}

rule file_1_13_0 {
	meta:
		name = "getaddrinfo"
		size = 2312
		refs = "00e0 __check_pf 01fa __pthread_once 028c qsort 0338 __connect 0358 __errno_location 03dc __socket 0420 memcmp 044c memcpy 0494 __getsockname 0500 bsearch 0624 qsort_r 0690 free 071c strtoul 077c freeaddrinfo 07d8 __assert_fail 07fc _Unwind_Resume 08a4 __lll_lock_wait_private 08dc __xstat64"
	strings:
		$1 = { 94 21 FE C0 7C 08 02 A6 93 81 01 30 7C 7C 1B 79 90 01 01 44 38 00 00 00 93 E1 01 3C 7C 3F 0B 78 91 C1 00 F8 7C CE 33 78 93 A1 01 34 7C 9D 23 78 93 C1 01 38 7C BE 2B 78 91 E1 00 FC 92 01 01 00 92 21 01 04 92 41 01 08 92 61 01 0C 92 81 01 10 92 A1 01 14 92 C1 01 18 92 E1 01 1C 93 01 01 20 93 21 01 24 93 41 01 28 93 61 01 2C 90 1F 00 0C 41 82 00 10 88 1C 00 00 2F 80 00 2A 41 9E 06 34 2F 9D 00 00 41 9E 00 10 88 1D 00 00 2F 80 00 2A 41 9E 03 64 41 82 03 74 2F 9E 00 00 41 9E 06 60 80 1E 00 00 54 09 00 28 2F 89 00 00 40 9E 04 D4 54 0B FF FE 2F 8B 00 00 40 9E 04 C4 38 00 00 00 7F E4 FB 78 90 1F 00 10 38 7F 00 08 9C 04 00 09 38 BF 00 10 38 DF 00 14 90 1F 00 14 98 1F 00 08 4? ?? ?? ?? 80 1E 00 00 70 09 00 20 41 82 00 8C 81 3E 00 04 2F 89 00 00 40 9E 05 D0 89 3F 00 08 2F 89 00 00 41 9E 00 24 89 3F 00 09 2F 89 00 00 40 9E 00 68 81 5E 00 08 81 7E 00 0C 90 1F 00 5C 38 00 00 02 48 00 00 20 89 7F 00 09 2F 8B 00 00 41 9E 00 48 81 5E 00 08 81 7E 00 0C 90 1F 00 5C 38 00 00 0A 91 3F 00 60 91 5F 00 64 91 7F 00 68 81 1E 00 10 81 5E 00 14 81 7E 00 18 81 3E 00 1C 3B DF 00 5C 91 1F 00 6C 91 5F 00 70 91 7F 00 74 91 3F 00 78 90 1F 00 60 2F 9D 00 00 41 9E 05 78 88 1D 00 00 38 80 00 00 2F 80 00 00 40 9E 05 80 80 1E 00 04 39 20 00 00 91 3F 00 1C 2B 80 00 0A 41 9D 06 04 3D 20 A0 20 7D 2B 00 31 40 80 05 F8 7F C5 F3 78 7F 83 E3 78 38 DF 00 0C 38 FF 00 1C 4B FF E4 D5 7C 7E 1B 79 40 82 05 B0 81 3F 00 0C 3A A0 00 00 2F 89 00 00 41 9E 00 14 81 29 00 1C 3A B5 00 01 2F 89 00 00 40 9E FF F4 80 1F 00 1C 2B 80 00 01 40 9D 04 98 3D 20 ?? ?? 90 3F 00 EC 38 09 ?? ?? 2F 80 00 00 3D E0 ?? ?? 39 EF ?? ?? 80 0F 00 2C 90 1F 00 F0 41 9E 06 94 3C 80 ?? ?? 38 6F 00 2C 38 84 ?? ?? 4? ?? ?? ?? 1D 75 00 2C 81 21 00 00 80 7F 00 10 38 0B 00 1E 54 00 00 36 7C 00 00 D0 7D 21 01 6E 56 A9 10 3A 38 09 00 1E 54 00 00 36 81 21 00 00 7C 00 00 D0 2F 83 00 00 3A 61 00 17 7D 21 01 6E 56 73 00 36 38 01 00 17 54 0B 00 36 91 7F 00 E8 41 9E 00 18 3C C0 ?? ?? 80 9F 00 14 38 A0 00 18 38 C6 ?? ?? 4? ?? ?? ?? 83 BF 00 0C 2F 9D 00 00 41 9E 05 1C 81 3F 00 E8 7E 7E 9B 78 3A C0 00 00 3B 09 FF FC 3B 40 FF FF 3B 20 00 00 39 20 00 00 3B 60 00 00 3A E0 FF FF 3B 80 00 00 3A 80 00 1C 2F 89 00 00 93 BE 00 00 92 FE 00 28 97 78 00 04 41 9E 00 14 80 A9 00 10 80 1D 00 10 7F 85 00 00 41 9E 01 30 2F 9A FF FF 9B 9E 00 21 9B 9E 00 22 9B 9E 00 23 92 FE 00 24 41 9E 00 CC 2F 96 00 02 40 9E 00 10 80 1D 00 04 2F 80 00 0A 41 9E 00 A8 38 00 00 00 7F 43 D3 78 90 1F 00 34 38 9F 00 34 38 A0 00 10 90 1F 00 38 90 1F 00 3C 90 1F 00 40 4? ?? ?? ?? 92 9F 00 20 80 9D 00 14 7F 43 D3 78 80 BD 00 10 4? ?? ?? ?? 2F 83 00 00 41 9E 01 28 4? ?? ?? ?? 80 03 00 00 2F 80 00 61 41 9E 00 44 9B 9E 00 20 80 1D 00 18 2F 80 00 00 41 9E 00 14 2F 99 00 00 40 9E 04 40 93 3D 00 18 7C 19 03 78 80 1D 00 1C 3B DE 00 2C 2F 80 00 00 41 9E 02 4C 7F A9 EB 78 3B 7B 00 01 7C 1D 03 78 4B FF FF 24 2F 96 00 0A 40 9E FF BC 80 1D 00 04 2F 80 00 02 40 9E FF B0 38 00 00 06 7F 43 D3 78 44 00 00 02 7C 00 00 26 82 DD 00 04 38 80 00 02 38 A0 00 00 7E C3 B3 78 4? ?? ?? ?? 2F 83 FF FF 92 9F 00 20 7C 7A 1B 78 41 9E FF 6C 4B FF FF 50 88 1D 00 01 2F 80 00 00 40 BE FC 98 3B A0 00 00 40 82 FC 94 2F 9D 00 00 38 60 FF FE 41 BE 01 74 4B FF FC 84 80 69 00 14 80 9D 00 14 4? ?? ?? ?? 2F 83 00 00 40 9E FE C4 38 9B FF FF 88 BE FF F4 1C 84 00 2C 1C 7B 00 2C 7C 93 22 14 7C 73 1A 14 38 63 00 04 38 84 00 04 4? ?? ?? ?? 89 1E FF F4 89 5E FF F5 89 7E FF F6 89 3E FF F7 80 1E FF F8 99 1E 00 20 99 5E 00 21 99 7E 00 22 99 3E 00 23 90 1E 00 24 4B FF FE F4 1E 5B 00 2C 7E 13 92 14 3A 30 00 04 7F 43 D3 78 7E 24 8B 78 38 BF 00 20 4? ?? ?? ?? 2C 03 00 00 40 A2 FE BC 80 1F 00 20 39 60 00 01 99 7E 00 21 98 1E 00 20 80 9F 00 10 2F 84 00 00 41 9E 00 6C 80 1D 00 04 2F 80 00 02 41 9E 02 8C 7D 33 92 14 81 49 00 0C 81 69 00 10 80 09 00 14 81 29 00 18 91 5F 00 4C 91 7F 00 50 90 1F 00 54 91 3F 00 58 3D 60 ?? ?? 80 BF 00 14 80 EB ?? ?? 38 7F 00 44 38 C0 00 18 4? ?? ?? ?? 2C 03 00 00 41 82 00 1C 88 03 00 00 98 1E 00 22 88 03 00 01 98 1E 00 23 80 03 00 04 90 1E 00 24 80 1D 00 04 2F 80 00 02 40 9E FE 40 2F 96 00 0A 40 9E FE 38 81 3E 00 0C 2F 89 00 00 40 9E 02 9C 81 3E 00 10 2F 89 00 00 40 9E 02 90 81 3E 00 14 6D 2B FF FF 2F 8B FF FF 40 9E 02 80 B0 10 00 04 7E 53 92 14 80 12 00 18 90 11 00 04 38 00 00 10 98 1E 00 20 4B FF FD F4 40 82 FB 40 38 60 FF FF 39 7F 01 40 80 0B 00 04 81 CB FF B8 7C 08 03 A6 81 EB FF BC 82 0B FF C0 82 2B FF C4 82 4B FF C8 82 6B FF CC 82 8B FF D0 82 AB FF D4 82 CB FF D8 82 EB FF DC 83 0B FF E0 83 2B FF E4 83 4B FF E8 83 6B FF EC 83 8B FF F0 83 AB FF F4 83 CB FF F8 83 EB FF FC 7D 61 5B 78 4E 80 00 20 2F 9A FF FF 41 9E 00 14 38 00 00 06 7F 43 D3 78 44 00 00 02 7C 00 00 26 80 0F 00 10 92 7F 00 2C 2F 80 00 00 92 BF 00 30 40 9E 01 F8 3C C0 ?? ?? 80 7F 00 E8 7E A4 AB 78 38 A0 00 04 38 C6 ?? ?? 38 FF 00 2C 4? ?? ?? ?? 81 7F 00 E8 2F 95 00 01 80 0B 00 00 1C 00 00 2C 7D 13 00 2E 91 1F 00 0C 7D 09 43 78 40 9D 00 2C 3A B5 FF FF 7D 0A 43 78 7E A9 03 A6 48 00 00 08 7D 2A 4B 78 84 0B 00 04 1C 00 00 2C 7D 33 00 2E 91 2A 00 1C 42 00 FF EC 38 00 00 00 93 28 00 18 90 09 00 1C 80 01 00 00 81 3F 00 EC 90 09 00 00 7D 21 4B 78 80 7F 00 10 4? ?? ?? ?? 80 1F 00 0C 38 60 FF FE 2F 80 00 00 41 BE FE E4 90 0E 00 00 38 60 00 00 4B FF FE D8 88 1C 00 01 2F 80 00 00 40 BE F9 C8 4C 1C 00 00 3B 80 00 00 4B FF F9 BC 2F 89 00 02 41 9E 00 C8 2F 89 00 0A 40 BE FA A4 88 1F 00 09 2F 80 00 00 40 9E FA 98 80 7F 00 10 4? ?? ?? ?? 38 60 FF FE 4B FF FE 94 38 80 00 00 4B FF FA 98 3F C0 ?? ?? 3B DE ?? ?? 3B DE 02 34 4B FF F9 98 38 9F 00 18 93 BF 00 24 7F A3 EB 78 38 A0 00 0A 4? ?? ?? ?? 81 3F 00 18 90 7F 00 28 38 9F 00 24 88 09 00 00 2F 80 00 00 41 BE FA 5C 80 1E 00 00 70 0B 04 00 40 A2 FF A4 38 00 FF FF 90 1F 00 28 4B FF FA 44 2F 96 00 02 40 9E FD 74 80 11 00 04 39 20 00 00 61 29 FF FF 90 7F 00 4C 90 7F 00 50 91 3F 00 54 90 1F 00 58 4B FF FD 78 80 7F 00 0C 4? ?? ?? ?? 80 7F 00 10 4? ?? ?? ?? 57 C3 06 2C 7C 63 00 D0 4B FF FD F4 88 1F 00 08 2F 80 00 00 40 9E F9 DC 4B FF FF 44 80 7F 00 10 4? ?? ?? ?? 38 60 FF FA 4B FF FD D4 3B 20 00 00 4B FF FE 40 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 09 13 38 C6 ?? ?? 4? ?? ?? ?? 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 08 F8 38 C6 ?? ?? 4? ?? ?? ?? 4? ?? ?? ?? 3B CF 00 30 39 60 00 01 39 20 00 00 7C 00 F0 28 7C 00 48 00 40 82 00 0C 7D 60 F1 2D 40 A2 FF F0 4C 00 01 2C 2F 80 00 00 40 9E 00 78 81 3F 00 F0 2F 89 00 00 41 9E 00 10 80 0F 00 0C 2F 80 00 00 40 9E 00 8C 3C C0 ?? ?? 80 7F 00 E8 7E A4 AB 78 38 A0 00 04 38 C6 ?? ?? 38 FF 00 2C 4? ?? ?? ?? 38 00 00 00 7C 00 04 AC 7D 20 F0 28 7C 00 F1 2D 40 A2 FF F8 2F 89 00 01 40 9D FD B0 80 82 8B 68 38 00 00 DD 7F C3 F3 78 60 84 00 01 38 A0 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FD 8C 7F C3 F3 78 4? ?? ?? ?? 4B FF FF 84 81 3F 00 F0 2F 89 00 00 40 9E F9 78 4B FF D0 F1 80 0F 00 2C 60 00 00 02 90 0F 00 2C 4B FF F9 64 3C 80 ?? ?? 38 60 00 03 38 84 ?? ?? 38 BF 00 80 4? ?? ?? ?? 2F 83 00 00 40 9E 00 1C 38 7F 00 D0 38 8F 00 14 38 A0 00 08 4? ?? ?? ?? 2F 83 00 00 41 BE FF 48 4B FF D0 A9 4B FF FF 40 }
	condition:
		$1
}

rule file_1_14_0 {
	meta:
		name = "fini"
		size = 140
		refs = "0038 free"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 93 A1 00 14 3F A0 ?? ?? 93 C1 00 18 3B DD ?? ?? 93 E1 00 1C 3F E0 ?? ?? 3B FF ?? ?? 80 7E 00 04 90 01 00 24 7F 83 F8 00 41 9E 00 0C 93 FE 00 04 4? ?? ?? ?? 80 7E 00 08 38 1F 00 C0 7F 83 00 00 41 9E 00 0C 90 1E 00 08 4? ?? ?? ?? 80 7D ?? ?? 3B FF 01 38 7F 83 F8 00 41 9E 00 10 3D 20 ?? ?? 93 E9 ?? ?? 4? ?? ?? ?? 80 01 00 24 83 A1 00 14 7C 08 03 A6 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 }
	condition:
		$1
}

rule file_3_0_0 {
	meta:
		name = "bcopy"
		size = 420
		refs = "0088 _wordcopy_fwd_dest_aligned 0130 _wordcopy_bwd_dest_aligned 0188 _wordcopy_fwd_aligned 019c _wordcopy_bwd_aligned"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 90 01 00 24 7C 03 20 50 7F 80 28 40 93 81 00 10 7C 9C 23 78 93 A1 00 14 7C 7D 1B 78 93 61 00 0C 93 C1 00 18 93 E1 00 1C 41 9C 00 B0 2B 85 00 0F 7C BB 2B 78 40 9D 00 60 7C 04 00 D0 54 00 07 BE 2F 80 00 00 7F 60 28 50 41 9E 00 24 7C 09 03 A6 3B 80 00 00 7C 03 E0 AE 7C 04 E1 AE 3B 9C 00 01 42 00 FF F4 7F A3 E2 14 7F 84 E2 14 73 A0 00 03 41 82 01 04 7F 83 E3 78 7F A4 EB 78 57 65 F0 BE 4? ?? ?? ?? 57 60 00 3A 7F BD 02 14 7F 9C 02 14 57 7B 07 BE 2F 9B 00 00 41 9E 00 1C 7F 69 03 A6 3B BD FF FF 3B 9C FF FF 8C 1D 00 01 9C 1C 00 01 42 00 FF F8 80 01 00 24 83 61 00 0C 7C 08 03 A6 83 81 00 10 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 2B 85 00 0F 7F C5 1A 14 7F E5 22 14 7C A0 2B 78 40 9D 00 58 57 EB 07 BE 2F 8B 00 00 7F AB 28 50 41 9E 00 1C 7D 69 03 A6 7F C9 F3 78 8C 09 FF FF 9C 1F FF FF 42 00 FF F8 7F CB F0 50 73 C0 00 03 41 82 00 70 7F E3 FB 78 7F C4 F3 78 57 A5 F0 BE 4? ?? ?? ?? 73 A0 00 03 57 BD 00 3A 7F DD F0 50 7F FD F8 50 41 A2 FF 78 7C 09 03 A6 8C 1E FF FF 9C 1F FF FF 42 00 FF F8 80 01 00 24 83 61 00 0C 7C 08 03 A6 83 81 00 10 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 7F 83 E3 78 7F A4 EB 78 57 65 F0 BE 4? ?? ?? ?? 4B FF FF 00 7F E3 FB 78 7F C4 F3 78 57 A5 F0 BE 4? ?? ?? ?? 4B FF FF 94 }
	condition:
		$1
}

rule file_4_0_0 {
	meta:
		name = "__libc_cleanup_routine"
		size = 56
		altNames = "__pthread_cleanup_routine"
	strings:
		$1 = { 7C 08 02 A6 94 21 FF F0 90 01 00 14 80 03 00 08 2F 80 00 00 41 BE 00 14 80 03 00 00 80 63 00 04 7C 09 03 A6 4E 80 04 21 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_5_0_0 {
	meta:
		name = "__atomic_pwritev64_replacement"
		size = 464
		refs = "00e8 mempcpy 0108 __pwrite64 0114 free 0162 _GLOBAL_OFFSET_TABLE_ 016a __libc_errno 0198 __libc_alloca_cutoff 01b0 malloc"
	strings:
		$1 = { 7D 80 00 26 2E 05 00 00 94 21 FF C0 7C 08 02 A6 92 E1 00 1C 7C F7 3B 78 93 01 00 20 7D 18 43 78 93 A1 00 34 7C 7D 1B 78 93 C1 00 38 7C BE 2B 78 93 E1 00 3C 7C 3F 0B 78 90 01 00 44 92 C1 00 18 93 21 00 24 93 41 00 28 93 61 00 2C 93 81 00 30 91 81 00 14 40 91 01 34 80 04 00 04 3D 00 7F FF 61 08 FF FF 7F 80 40 40 41 9D 00 F8 39 20 00 00 7C A9 03 A6 3B 60 00 00 48 00 00 10 80 0B 00 04 7F 8A 00 40 41 9C 00 DC 39 29 00 01 7F 7B 02 14 55 20 18 38 7D 5B 40 50 7D 64 02 14 42 00 FF E0 2B 9B 80 00 41 9D 00 EC 38 1B 00 1E 81 21 00 00 54 00 00 36 7C 00 00 D0 7D 21 01 6E 3A C1 00 17 56 D6 00 36 40 91 00 BC 3B 80 00 00 7C 9A 23 78 7E C3 B3 78 3B 20 00 00 80 9A 00 00 3B 39 00 01 80 BA 00 04 3B 5A 00 08 4? ?? ?? ?? 7F 99 F0 00 40 9E FF E8 7F A3 EB 78 7E C4 B3 78 7F 65 DB 78 7E E7 BB 78 7F 08 C3 78 4? ?? ?? ?? 7C 7A 1B 78 7F 83 E3 78 4? ?? ?? ?? 39 7F 00 40 80 0B 00 04 7F 43 D3 78 81 8B FF D4 7C 08 03 A6 82 CB FF D8 82 EB FF DC 7D 80 81 20 83 0B FF E0 83 2B FF E4 83 4B FF E8 83 6B FF EC 83 8B FF F0 83 AB FF F4 83 CB FF F8 83 EB FF FC 7D 61 5B 78 4E 80 00 20 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 38 00 00 16 90 09 00 00 3B 40 FF FF 4B FF FF 9C 3B 80 00 00 4B FF FF 70 3B 60 00 00 4B FF FF 1C 7F 63 DB 78 90 9F 00 08 4? ?? ?? ?? 2F 83 00 00 80 9F 00 08 40 9E FF 04 7F 63 DB 78 90 9F 00 08 4? ?? ?? ?? 3B 80 00 00 7C 76 1B 79 80 9F 00 08 3B 40 FF FF 41 A2 FF 4C 7E DC B3 78 4B FF FF 00 }
	condition:
		$1
}

rule file_5_1_0 {
	meta:
		name = "pwritev64"
		size = 364
		refs = "0096 _GLOBAL_OFFSET_TABLE_ 009e __libc_errno 00f0 __libc_enable_asynccancel 0128 __libc_disable_asynccancel"
	strings:
		$1 = { 94 21 FF D0 7C 08 02 A6 93 61 00 1C 7C 7B 1B 78 93 81 00 20 7C 9C 23 78 93 A1 00 24 7C BD 2B 78 93 C1 00 28 7C FE 3B 78 93 E1 00 2C 7D 1F 43 78 90 01 00 34 93 21 00 14 93 41 00 18 80 02 8B 60 2F 80 00 00 40 9E 00 AC 38 00 01 41 7D 06 43 78 44 00 00 02 7C 00 00 26 74 09 10 00 40 82 00 D8 2F 83 00 00 41 9C 00 30 80 01 00 34 83 21 00 14 7C 08 03 A6 83 41 00 18 83 61 00 1C 83 81 00 20 83 A1 00 24 83 C1 00 28 83 E1 00 2C 38 21 00 30 4E 80 00 20 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 80 09 00 00 2F 80 00 26 40 9E FF BC 80 01 00 34 7F 63 DB 78 7F 84 E3 78 83 21 00 14 7C 08 03 A6 7F A5 EB 78 7F C7 F3 78 83 41 00 18 7F E8 FB 78 83 61 00 1C 83 81 00 20 83 A1 00 24 83 C1 00 28 83 E1 00 2C 38 21 00 30 4B FF FD 44 4? ?? ?? ?? 38 00 01 41 7C 7A 1B 78 7F 84 E3 78 7F 63 DB 78 7F A5 EB 78 7F E6 FB 78 7F C7 F3 78 44 00 00 02 7C 00 00 26 74 09 10 00 7C 79 1B 78 40 82 00 30 7F 43 D3 78 4? ?? ?? ?? 7F 23 CB 78 4B FF FF 30 3D 20 ?? ?? 39 29 ?? ?? 81 69 ?? ?? 7D 6B 12 14 90 6B 00 00 38 60 FF FF 4B FF FF 50 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 90 69 00 00 3B 20 FF FF 4B FF FF BC }
	condition:
		$1
}

rule file_6_0_0 {
	meta:
		name = "decode_name"
		size = 272
	strings:
		$1 = { 39 43 00 01 7C 69 1B 78 38 80 00 5C 38 A0 00 0A 38 C0 00 09 38 E0 00 20 48 00 00 24 7D 68 5B 78 98 0A FF FF 7D 2B 4B 78 7D 09 43 78 88 0B 00 00 39 4A 00 01 2F 80 00 00 41 9E 00 5C 88 09 00 00 39 69 00 01 2F 80 00 5C 40 9E FF D4 89 09 00 01 2F 88 00 30 41 9E 00 44 2F 88 00 5C 41 9E 00 78 2F 88 00 31 40 9E FF B8 89 09 00 02 2F 88 00 33 40 9E FF AC 89 09 00 03 39 89 00 03 2F 88 00 34 40 9E FF 9C 98 8A FF FF 39 29 00 04 7D 8B 63 78 4B FF FF 9C 4E 80 00 20 89 09 00 02 2F 88 00 34 41 9E 00 40 2F 88 00 31 40 9E FF 74 89 09 00 03 39 89 00 03 2F 88 00 31 41 9E 00 48 2F 88 00 32 40 9E FF 5C 98 AA FF FF 39 29 00 04 7D 8B 63 78 4B FF FF 5C 99 0A FF FF 39 2B 00 01 4B FF FF 50 89 09 00 03 39 89 00 03 2F 88 00 30 40 9E FF 30 98 EA FF FF 39 29 00 04 7D 8B 63 78 4B FF FF 30 98 CA FF FF 39 29 00 04 7D 8B 63 78 4B FF FF 20 }
	condition:
		$1
}

rule file_6_1_0 {
	meta:
		name = "__setmntent"
		size = 160
		refs = "0028 strlen 0054 mempcpy 0068 _IO_new_fopen"
		altNames = "setmntent"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 93 A1 00 14 7C 7D 1B 78 7C 83 23 78 93 E1 00 1C 7C 3F 0B 78 90 01 00 24 93 C1 00 18 90 9F 00 08 4? ?? ?? ?? 38 03 00 20 81 21 00 00 54 00 00 36 7C 00 00 D0 80 9F 00 08 7D 21 01 6E 7C 65 1B 78 3B C1 00 17 57 DE 00 36 7F C3 F3 78 4? ?? ?? ?? 38 00 63 00 B0 03 00 00 7F C4 F3 78 7F A3 EB 78 4? ?? ?? ?? 2C 03 00 00 41 82 00 10 80 03 00 00 60 00 80 00 90 03 00 00 39 7F 00 20 80 0B 00 04 83 AB FF F4 7C 08 03 A6 83 CB FF F8 83 EB FF FC 7D 61 5B 78 4E 80 00 20 }
	condition:
		$1
}

rule file_6_2_0 {
	meta:
		name = "__endmntent"
		size = 44
		refs = "0014 _IO_new_fclose"
		altNames = "endmntent"
	strings:
		$1 = { 2F 83 00 00 94 21 FF F0 7C 08 02 A6 90 01 00 14 41 9E 00 08 4? ?? ?? ?? 80 01 00 14 38 60 00 01 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_6_3_0 {
	meta:
		name = "__getmntent_r"
		size = 1080
		refs = "0098 fgets_unlocked 00ac strchr 0308 sscanf 0430 __lll_lock_wait_private"
		altNames = "getmntent_r"
	strings:
		$1 = { 94 21 FB E0 7C 08 02 A6 90 01 04 24 80 03 00 00 93 81 04 10 7C DC 33 78 70 00 80 00 93 A1 04 14 7C 7D 1B 78 93 C1 04 18 7C BE 2B 78 93 E1 04 1C 7C 9F 23 78 93 61 04 0C 40 82 00 50 80 63 00 48 3B 62 8B 60 81 23 00 08 7F 89 D8 00 41 9E 00 30 39 60 00 01 7D 20 18 28 7C 09 00 00 40 82 00 0C 7D 60 19 2D 40 A2 FF F0 4C 00 01 2C 2F 89 00 00 40 9E 03 C0 80 7D 00 48 93 63 00 08 81 23 00 04 38 09 00 01 90 03 00 04 3B 60 00 00 7F C3 F3 78 7F 84 E3 78 7F A5 EB 78 4? ?? ?? ?? 2F 83 00 00 41 9E 00 B8 7F C3 F3 78 38 80 00 0A 4? ?? ?? ?? 2C 03 00 00 41 82 00 28 9B 63 00 00 7F C3 F3 78 88 03 00 00 2F 80 00 20 2F 00 00 09 41 9E 00 08 40 9A 00 3C 38 63 00 01 4B FF FF E8 38 80 04 00 7F A5 EB 78 38 61 00 08 4? ?? ?? ?? 38 80 00 0A 2F 83 00 00 38 61 00 08 41 BE FF C4 4? ?? ?? ?? 2F 83 00 00 41 9E FF D8 4B FF FF B4 2F 80 00 00 41 BE FF 7C 2F 80 00 23 41 9E FF 74 7C 7E 1B 78 48 00 00 0C 41 86 00 6C 41 9A 00 68 8C 1E 00 01 2F 80 00 00 2C 80 00 20 2F 00 00 09 40 9E FF E8 4B FF FC E5 90 7F 00 00 3D 20 ?? ?? 38 09 ?? ?? 90 1F 00 04 48 00 02 D4 80 1D 00 00 3B E0 00 00 70 09 80 00 41 82 02 68 80 01 04 24 7F E3 FB 78 83 61 04 0C 7C 08 03 A6 83 81 04 10 83 A1 04 14 83 C1 04 18 83 E1 04 1C 38 21 04 20 4E 80 00 20 38 00 00 00 98 1E 00 00 4B FF FC 8D 2F 9E FF FF 90 7F 00 00 41 BE FF A4 7F C3 F3 78 38 63 00 01 88 03 00 00 7C 69 1B 78 2F 80 00 20 2F 00 00 09 41 BE FF EC 41 9A FF E8 2F 83 00 00 41 BE FF 7C 2F 80 00 00 3B 80 00 00 40 BE 00 10 48 00 00 24 41 86 01 CC 41 9A 01 C8 8C 09 00 01 2F 80 00 00 2C 80 00 20 2F 00 00 09 40 9E FF E8 3B 80 00 00 4B FF FC 25 2F 9C 00 00 7F 8B E3 78 90 7F 00 04 41 9E 02 10 88 0B 00 00 7D 69 5B 78 2F 80 00 20 2F 00 00 09 41 9E 00 08 40 9A 00 0C 39 6B 00 01 4B FF FF E4 2F 8B 00 00 41 9E 01 E8 2F 80 00 00 3B C0 00 00 40 BE 00 10 48 00 00 24 41 86 01 70 41 9A 01 6C 8C 09 00 01 2F 80 00 00 2C 80 00 20 2F 00 00 09 40 9E FF E8 3B C0 00 00 7D 63 5B 78 4B FF FB B5 2F 9E 00 00 7F C9 F3 78 90 7F 00 08 41 9E 00 FC 88 09 00 00 7D 2B 4B 78 2F 80 00 20 2F 00 00 09 41 9E 00 08 40 9A 00 0C 39 29 00 01 4B FF FF E4 2F 89 00 00 41 9E 00 D4 2F 80 00 00 3B C0 00 00 40 BE 00 10 48 00 00 24 41 86 00 E0 41 9A 00 DC 8C 0B 00 01 2F 80 00 00 2C 80 00 20 2F 00 00 09 40 9E FF E8 3B C0 00 00 7D 23 4B 78 4B FF FB 45 2F 9E 00 00 90 7F 00 0C 41 9E 00 9C 3C 80 ?? ?? 7F C3 F3 78 38 84 ?? ?? 38 BF 00 10 38 DF 00 14 4C C6 31 82 4? ?? ?? ?? 2C 03 00 00 41 82 00 78 2F 83 00 01 41 9E 00 78 80 1D 00 00 70 09 80 00 40 A2 FE 44 80 7D 00 48 80 03 00 04 30 00 FF FF 2F 80 00 00 90 03 00 04 40 BE FE 2C 90 03 00 08 7C 00 04 AC 7D 20 18 28 7C 00 19 2D 40 A2 FF F8 2F 89 00 01 40 9D FE 10 80 82 8B 68 38 00 00 DD 38 A0 00 01 60 84 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FD F0 3D 20 ?? ?? 38 09 ?? ?? 90 1F 00 0C 38 00 00 00 90 1F 00 10 38 00 00 00 90 1F 00 14 4B FF FF 84 38 00 00 00 98 0B 00 00 3B CB 00 01 4B FF FF 34 38 00 00 00 98 09 00 00 3B 89 00 01 4B FF FE 48 38 00 00 00 98 09 00 00 3B C9 00 01 4B FF FE A4 80 7D 00 48 80 03 00 04 30 00 FF FF 2F 80 00 00 90 03 00 04 40 9E FD 88 93 E3 00 08 7C 00 04 AC 7C 00 18 28 7F E0 19 2D 40 A2 FF F8 2F 80 00 01 40 9D FD 6C 80 82 8B 68 38 00 00 DD 38 A0 00 01 60 84 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FD 4C 3D 20 ?? ?? 38 09 ?? ?? 90 1F 00 08 4B FF FF 58 4? ?? ?? ?? 4B FF FC 40 }
	condition:
		$1
}

rule file_6_4_0 {
	meta:
		name = "__addmntent"
		size = 1492
		refs = "005c fseek 0164 fprintf 0258 strlen"
		altNames = "addmntent"
	strings:
		$1 = { 94 21 FF D0 7C 08 02 A6 7C 89 23 78 90 01 00 34 38 A0 00 02 38 80 00 00 93 E1 00 2C 7C 3F 0B 78 93 01 00 10 7C 78 1B 78 93 21 00 14 93 41 00 18 93 61 00 1C 93 81 00 20 93 A1 00 24 93 C1 00 28 92 E1 00 0C 83 29 00 00 83 49 00 04 83 69 00 08 83 89 00 0C 83 A9 00 10 83 C9 00 14 4? ?? ?? ?? 2F 83 00 00 38 60 00 01 40 9E 01 04 3A F9 FF FF 7E EB BB 78 8D 2B 00 01 2F 89 00 20 2B 09 00 20 41 9E 01 38 2F 89 00 00 2C 89 00 5C 41 99 01 A4 39 29 FF F7 2B 09 00 01 40 9E 01 0C 40 9E 02 E8 3A FA FF FF 7E EB BB 78 8D 2B 00 01 2F 89 00 20 2B 09 00 20 41 9E 01 24 2F 89 00 00 2C 89 00 5C 41 99 01 64 39 29 FF F7 2B 09 00 01 40 9E 00 F8 40 9E 02 1C 3A FB FF FF 7E EB BB 78 8D 2B 00 01 2F 89 00 20 2B 09 00 20 41 9E 01 10 2F 89 00 00 2C 89 00 5C 41 99 01 54 39 29 FF F7 2B 09 00 01 40 9E 00 E4 40 9E 03 18 3A FC FF FF 7E EB BB 78 8D 2B 00 01 2F 89 00 20 2B 09 00 20 41 9E 00 FC 2F 89 00 00 2C 89 00 5C 41 99 01 14 39 29 FF F7 2B 09 00 01 40 9E 00 D0 40 9E 01 1C 3C 80 ?? ?? 7F 03 C3 78 38 84 ?? ?? 7F 25 CB 78 7F 46 D3 78 7F 67 DB 78 7F 88 E3 78 7F A9 EB 78 7F CA F3 78 4C C6 31 82 4? ?? ?? ?? 54 63 0F FE 39 7F 00 30 80 0B 00 04 82 EB FF DC 7C 08 03 A6 83 0B FF E0 83 2B FF E4 83 4B FF E8 83 6B FF EC 83 8B FF F0 83 AB FF F4 83 CB FF F8 83 EB FF FC 7D 61 5B 78 4E 80 00 20 40 B9 FE F8 8D 2B 00 01 2F 89 00 20 2B 09 00 20 40 9E FE D0 2F 89 00 00 41 9E FE E4 48 00 01 C4 40 B9 FF 0C 8D 2B 00 01 2F 89 00 20 2B 09 00 20 40 9E FE E4 2F 89 00 00 41 9E FE F8 48 00 01 0C 40 B9 FF 20 8D 2B 00 01 2F 89 00 20 2B 09 00 20 40 9E FE F8 2F 89 00 00 41 9E FF 0C 48 00 02 1C 40 B9 FF 34 8D 2B 00 01 2F 89 00 20 2B 09 00 20 40 9E FF 0C 2F 89 00 00 41 9E FF 20 48 00 00 34 40 86 FE 84 2F 89 00 00 4B FF FF B0 40 86 FE 44 2F 89 00 00 4B FF FF 84 40 86 FE D4 2F 89 00 00 4B FF FF D8 40 86 FE 94 2F 89 00 00 4B FF FF AC 7F 83 E3 78 4? ?? ?? ?? 81 21 00 00 54 63 10 3A 38 03 00 1F 54 00 00 36 7C 00 00 D0 7D 21 01 6E 39 40 00 5C 39 60 00 30 3B 81 00 17 57 9C 00 36 7F 89 E3 78 38 C0 00 31 38 80 00 32 38 A0 00 34 48 00 00 28 2F 80 00 5C 41 9A 02 34 41 86 02 D8 41 9E 02 F0 98 09 00 00 39 29 00 01 88 17 00 00 2F 80 00 00 41 BE FE 84 8C 17 00 01 2F 80 00 20 2F 00 00 09 2C 80 00 0A 40 9E FF CC 38 E9 00 01 99 49 00 00 99 69 00 01 39 29 00 04 98 A7 00 01 99 67 00 02 4B FF FF C8 7F 43 D3 78 4? ?? ?? ?? 81 21 00 00 54 63 10 3A 38 03 00 1F 54 00 00 36 7C 00 00 D0 7D 21 01 6E 39 40 00 5C 39 60 00 30 3B 41 00 17 57 5A 00 36 7F 49 D3 78 38 C0 00 31 38 80 00 32 38 A0 00 34 48 00 00 28 2F 80 00 5C 41 9A 01 B8 41 86 01 EC 41 9E 02 78 98 09 00 00 39 29 00 01 88 17 00 00 2F 80 00 00 41 BE FD 84 8C 17 00 01 2F 80 00 20 2F 00 00 09 2C 80 00 0A 40 9E FF CC 38 E9 00 01 99 49 00 00 99 69 00 01 39 29 00 04 98 A7 00 01 99 67 00 02 4B FF FF C8 7F 23 CB 78 4? ?? ?? ?? 81 21 00 00 54 63 10 3A 38 03 00 1F 54 00 00 36 7C 00 00 D0 7D 21 01 6E 39 40 00 5C 39 60 00 30 3B 21 00 17 57 39 00 36 7F 29 CB 78 38 C0 00 31 38 80 00 32 38 A0 00 34 48 00 00 28 2F 80 00 5C 41 9A 01 3C 41 86 01 70 41 9E 01 D0 98 09 00 00 39 29 00 01 88 17 00 00 2F 80 00 00 41 BE FC B8 8C 17 00 01 2F 80 00 20 2F 00 00 09 2C 80 00 0A 40 9E FF CC 38 E9 00 01 99 49 00 00 99 69 00 01 39 29 00 04 98 A7 00 01 99 67 00 02 4B FF FF C8 7F 63 DB 78 4? ?? ?? ?? 81 21 00 00 54 63 10 3A 38 03 00 1F 54 00 00 36 7C 00 00 D0 7D 21 01 6E 39 40 00 5C 39 60 00 30 3B 61 00 17 57 7B 00 36 7F 69 DB 78 38 C0 00 31 38 80 00 32 38 A0 00 34 48 00 00 28 2F 80 00 5C 41 9A 00 50 41 86 00 F4 41 9E 01 58 98 09 00 00 39 29 00 01 88 17 00 00 2F 80 00 00 41 BE FC 88 8C 17 00 01 2F 80 00 20 2F 00 00 09 2C 80 00 0A 40 9E FF CC 38 E9 00 01 99 49 00 00 99 69 00 01 39 29 00 04 98 A7 00 01 99 67 00 02 4B FF FF C8 38 E9 00 01 99 49 00 00 99 69 00 01 39 29 00 04 98 C7 00 01 98 C7 00 02 4B FF FF AC 38 E9 00 01 99 49 00 00 99 69 00 01 39 29 00 04 98 C7 00 01 98 C7 00 02 4B FF FD C8 38 E9 00 01 99 49 00 00 99 69 00 01 39 29 00 04 98 C7 00 01 98 C7 00 02 4B FF FE 44 38 E9 00 01 99 49 00 00 99 69 00 01 39 29 00 04 98 C7 00 01 98 C7 00 02 4B FF FE C0 38 E9 00 01 99 49 00 00 99 69 00 01 39 29 00 04 98 C7 00 01 98 87 00 02 4B FF FE 0C 38 E9 00 01 99 49 00 00 99 69 00 01 39 29 00 04 98 C7 00 01 98 87 00 02 4B FF FE 88 38 E9 00 01 99 49 00 00 99 69 00 01 39 29 00 04 98 C7 00 01 98 87 00 02 4B FF FF 04 38 E9 00 01 99 49 00 00 99 69 00 01 39 29 00 04 98 C7 00 01 98 87 00 02 4B FF FD 20 98 09 00 00 99 49 00 01 39 29 00 02 4B FF FD 10 98 09 00 00 99 49 00 01 39 29 00 02 4B FF FE 30 98 09 00 00 99 49 00 01 39 29 00 02 4B FF FD 88 98 09 00 00 99 49 00 01 39 29 00 02 4B FF FE A8 }
	condition:
		$1
}

rule file_6_5_0 {
	meta:
		name = "__hasmntopt"
		size = 212
		refs = "0024 strlen 0060 strchr 0078 strstr"
		altNames = "hasmntopt"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 93 E1 00 1C 7C 7F 1B 78 7C 83 23 78 93 A1 00 14 93 C1 00 18 7C 9E 23 78 90 01 00 24 4? ?? ?? ?? 7C 7D 1B 78 83 FF 00 0C 48 00 00 40 41 9E 00 10 88 09 FF FF 2F 80 00 2C 40 9E 00 20 7C 09 E8 AE 2F 80 00 00 2F 00 00 3D 2C 80 00 2C 41 9E 00 3C 41 9A 00 38 41 86 00 34 4? ?? ?? ?? 2C 03 00 00 3B E3 00 01 41 82 00 44 7F C4 F3 78 7F E3 FB 78 4? ?? ?? ?? 38 80 00 2C 7C 69 1B 79 7D 23 4B 78 7F 89 F8 00 40 82 FF A8 80 01 00 24 7D 23 4B 78 83 A1 00 14 7C 08 03 A6 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 80 01 00 24 39 20 00 00 7D 23 4B 78 83 A1 00 14 7C 08 03 A6 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 }
	condition:
		$1
}

rule file_7_0_0 {
	meta:
		name = "__setitimer"
		size = 16
		refs = "000c __syscall_error"
	strings:
		$1 = { 38 00 00 68 44 00 00 02 4C A3 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_8_0_0 {
	meta:
		name = "__isoc99_vwscanf"
		size = 464
		refs = "000e stdin 00a8 _IO_vfwscanf 0150 __lll_lock_wait_private 01cc _Unwind_Resume"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 93 C1 00 18 3F C0 ?? ?? 90 01 00 24 93 E1 00 1C 83 FE ?? ?? 93 61 00 0C 7C 7B 1B 78 80 1F 00 00 93 81 00 10 7C 9C 23 78 70 00 80 00 93 A1 00 14 40 82 00 F0 80 7F 00 48 3B A2 8B 60 81 23 00 08 7F 89 E8 00 41 9E 00 30 39 60 00 01 7D 20 18 28 7C 09 00 00 40 82 00 0C 7D 60 19 2D 40 A2 FF F0 4C 00 01 2C 2F 89 00 00 40 9E 00 E0 80 7F 00 48 93 A3 00 08 81 63 00 04 81 3E ?? ?? 38 0B 00 01 90 03 00 04 80 09 00 3C 7D 23 4B 78 7F 64 DB 78 60 00 00 10 90 09 00 3C 7F 85 E3 78 38 C0 00 00 4? ?? ?? ?? 80 1F 00 00 7C 7E 1B 78 81 3F 00 3C 70 0B 80 00 38 00 FF EB 7D 20 00 38 90 1F 00 3C 40 82 00 38 80 7F 00 48 81 23 00 04 38 09 FF FF 2F 80 00 00 90 03 00 04 40 9E 00 20 90 03 00 08 7C 00 04 AC 7D 20 18 28 7C 00 19 2D 40 A2 FF F8 2F 89 00 01 41 9D 00 34 80 01 00 24 7F C3 F3 78 83 61 00 0C 7C 08 03 A6 83 81 00 10 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 7F E9 FB 78 4B FF FF 60 80 82 8B 68 38 00 00 DD 38 A0 00 01 60 84 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF B4 4? ?? ?? ?? 4B FF FF 20 80 1F 00 00 7C 7E 1B 78 81 3F 00 3C 70 0B 80 00 38 00 FF EB 7D 20 00 38 90 1F 00 3C 40 82 00 54 80 7F 00 48 80 03 00 04 30 00 FF FF 2F 80 00 00 90 03 00 04 40 9E 00 3C 90 03 00 08 7C 00 04 AC 7D 20 18 28 7C 00 19 2D 40 A2 FF F8 2F 89 00 01 40 BD 00 20 80 82 8B 68 38 00 00 DD 38 A0 00 01 60 84 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 7F C3 F3 78 4? ?? ?? ?? }
	condition:
		$1
}

rule file_1143_0_0 {
	meta:
		name = "__isoc99_vscanf"
		size = 464
		refs = "000e stdin 00a8 _IO_vfscanf 0150 __lll_lock_wait_private 01cc _Unwind_Resume"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 93 C1 00 18 3F C0 ?? ?? 90 01 00 24 93 E1 00 1C 83 FE ?? ?? 93 61 00 0C 7C 7B 1B 78 80 1F 00 00 93 81 00 10 7C 9C 23 78 70 00 80 00 93 A1 00 14 40 82 00 F0 80 7F 00 48 3B A2 8B 60 81 23 00 08 7F 89 E8 00 41 9E 00 30 39 60 00 01 7D 20 18 28 7C 09 00 00 40 82 00 0C 7D 60 19 2D 40 A2 FF F0 4C 00 01 2C 2F 89 00 00 40 9E 00 E0 80 7F 00 48 93 A3 00 08 81 63 00 04 81 3E ?? ?? 38 0B 00 01 90 03 00 04 80 09 00 3C 7D 23 4B 78 7F 64 DB 78 60 00 00 10 90 09 00 3C 7F 85 E3 78 38 C0 00 00 4? ?? ?? ?? 80 1F 00 00 7C 7E 1B 78 81 3F 00 3C 70 0B 80 00 38 00 FF EB 7D 20 00 38 90 1F 00 3C 40 82 00 38 80 7F 00 48 81 23 00 04 38 09 FF FF 2F 80 00 00 90 03 00 04 40 9E 00 20 90 03 00 08 7C 00 04 AC 7D 20 18 28 7C 00 19 2D 40 A2 FF F8 2F 89 00 01 41 9D 00 34 80 01 00 24 7F C3 F3 78 83 61 00 0C 7C 08 03 A6 83 81 00 10 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 7F E9 FB 78 4B FF FF 60 80 82 8B 68 38 00 00 DD 38 A0 00 01 60 84 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF B4 4? ?? ?? ?? 4B FF FF 20 80 1F 00 00 7C 7E 1B 78 81 3F 00 3C 70 0B 80 00 38 00 FF EB 7D 20 00 38 90 1F 00 3C 40 82 00 54 80 7F 00 48 80 03 00 04 30 00 FF FF 2F 80 00 00 90 03 00 04 40 9E 00 3C 90 03 00 08 7C 00 04 AC 7D 20 18 28 7C 00 19 2D 40 A2 FF F8 2F 89 00 01 40 BD 00 20 80 82 8B 68 38 00 00 DD 38 A0 00 01 60 84 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 7F C3 F3 78 4? ?? ?? ?? }
	condition:
		$1
}

rule file_9_0_0 {
	meta:
		name = "allocate"
		size = 44
		refs = "0010 malloc"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 38 60 04 00 90 01 00 14 4? ?? ?? ?? 3D 20 ?? ?? 80 01 00 14 38 21 00 10 90 69 ?? ?? 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_9_1_0 {
	meta:
		name = "getnetgrent"
		size = 212
		refs = "000a __pthread_once 006c __getnetgrent_r 0092 _GLOBAL_OFFSET_TABLE_ 009a __libc_errno"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 3D 20 ?? ?? 90 01 00 24 38 09 ?? ?? 2F 80 00 00 93 A1 00 14 7C BD 2B 78 93 C1 00 18 7C 7E 1B 78 93 E1 00 1C 7C 9F 23 78 93 81 00 10 41 9E 00 7C 3C 60 ?? ?? 3C 80 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 4? ?? ?? ?? 3D 20 ?? ?? 80 C9 ?? ?? 2F 86 00 00 41 9E 00 38 7F C3 F3 78 7F E4 FB 78 7F A5 EB 78 38 E0 04 00 4? ?? ?? ?? 80 01 00 24 83 81 00 10 7C 08 03 A6 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 38 00 00 0C 90 09 00 00 38 60 FF FF 4B FF FF C4 3F 80 ?? ?? 80 1C ?? ?? 2F 80 00 00 40 9E FF 90 4B FF FF 15 80 1C ?? ?? 60 00 00 02 90 1C ?? ?? 4B FF FF 7C }
	condition:
		$1
}

rule file_10_0_0 {
	meta:
		name = "putwc"
		size = 420
		refs = "0128 __woverflow 0134 __lll_lock_wait_private 01a0 _Unwind_Resume"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 90 01 00 24 80 04 00 00 93 C1 00 18 7C 7E 1B 78 70 00 80 00 93 E1 00 1C 7C 9F 23 78 93 A1 00 14 40 82 00 50 80 64 00 48 3B A2 8B 60 81 23 00 08 7F 89 E8 00 41 9E 00 30 39 60 00 01 7D 20 18 28 7C 09 00 00 40 82 00 0C 7D 60 19 2D 40 A2 FF F0 4C 00 01 2C 2F 89 00 00 40 9E 00 D4 80 7F 00 48 93 A3 00 08 81 23 00 04 38 09 00 01 90 03 00 04 81 3F 00 5C 2F 89 00 00 41 9E 00 A0 81 69 00 10 80 09 00 14 7F 8B 00 40 40 9C 00 90 38 0B 00 04 93 CB 00 00 90 09 00 10 80 1F 00 00 70 09 80 00 40 82 00 38 80 7F 00 48 81 23 00 04 38 09 FF FF 2F 80 00 00 90 03 00 04 40 9E 00 20 90 03 00 08 7C 00 04 AC 7D 20 18 28 7C 00 19 2D 40 A2 FF F8 2F 89 00 01 41 9D 00 24 80 01 00 24 7F C3 F3 78 83 A1 00 14 7C 08 03 A6 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 80 82 8B 68 38 00 00 DD 38 A0 00 01 60 84 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF C4 7F E3 FB 78 7F C4 F3 78 4? ?? ?? ?? 7C 7E 1B 78 4B FF FF 70 4? ?? ?? ?? 4B FF FF 2C 80 1F 00 00 7C 7E 1B 78 70 09 80 00 40 82 00 54 80 7F 00 48 80 03 00 04 30 00 FF FF 2F 80 00 00 90 03 00 04 40 9E 00 3C 90 03 00 08 7C 00 04 AC 7D 20 18 28 7C 00 19 2D 40 A2 FF F8 2F 89 00 01 40 BD 00 20 80 82 8B 68 38 00 00 DD 38 A0 00 01 60 84 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 7F C3 F3 78 4? ?? ?? ?? }
	condition:
		$1
}

rule file_11_0_0 {
	meta:
		name = "parse_printf_format"
		size = 360
		refs = "0038 __strchrnul 004e __printf_arginfo_table 005c __parse_one_specmb"
	strings:
		$1 = { 94 21 FF A0 7C 08 02 A6 93 C1 00 58 7C 9E 23 78 38 80 00 25 90 01 00 64 38 00 00 00 93 A1 00 54 7C BD 2B 78 93 E1 00 5C 3B E0 00 00 90 01 00 08 93 61 00 4C 93 81 00 50 4? ?? ?? ?? 88 03 00 00 2F 80 00 00 41 9E 00 C0 3B 80 00 00 3F 60 ?? ?? 7F E4 FB 78 38 A1 00 0C 38 C1 00 08 4? ?? ?? ?? 80 01 00 2C 7F FF 1A 14 2F 80 FF FF 41 9E 00 14 7F 80 F0 40 40 9C 00 0C 54 00 10 3A 7F 9D 01 2E 80 01 00 28 2F 80 FF FF 41 9E 00 14 7F 9E 00 40 40 9D 00 0C 54 00 10 3A 7F 9D 01 2E 80 81 00 30 7F 9E 20 40 40 9D 00 44 80 01 00 38 2F 80 00 00 41 9E 00 38 2F 80 00 01 41 9E 00 74 80 01 00 14 54 85 10 3A 81 3B ?? ?? 38 61 00 0C 54 00 10 3A 7C 09 00 2E 7C 84 F0 50 7C BD 2A 14 38 C1 00 3C 7C 09 03 A6 4E 80 04 21 80 61 00 24 88 03 00 00 2F 80 00 00 40 9E FF 5C 80 01 00 08 7F 9F 00 40 41 9C 00 3C 80 01 00 64 7F E3 FB 78 83 61 00 4C 7C 08 03 A6 83 81 00 50 83 A1 00 54 83 C1 00 58 83 E1 00 5C 38 21 00 60 4E 80 00 20 80 01 00 34 54 84 10 3A 7C 1D 21 2E 4B FF FF B0 7C 1F 03 78 80 01 00 64 7F E3 FB 78 83 61 00 4C 7C 08 03 A6 83 81 00 50 83 A1 00 54 83 C1 00 58 83 E1 00 5C 38 21 00 60 4E 80 00 20 }
	condition:
		$1
}

rule file_12_0_0 {
	meta:
		name = "getwchar_unlocked"
		size = 84
		refs = "000a _IO_stdin 004c __wuflow"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 3D 20 ?? ?? 90 01 00 14 80 69 ?? ?? 81 23 00 5C 2F 89 00 00 41 9E 00 30 81 69 00 00 80 09 00 04 7F 8B 00 40 40 9C 00 20 38 0B 00 04 80 6B 00 00 90 09 00 00 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 4? ?? ?? ?? 4B FF FF EC }
	condition:
		$1
}

rule file_13_0_0 {
	meta:
		name = "rename"
		size = 16
		refs = "000c __syscall_error"
	strings:
		$1 = { 38 00 00 26 44 00 00 02 4C A3 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_14_0_0 {
	meta:
		name = "posix_spawn_file_actions_destroy"
		size = 40
		refs = "0010 free"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 80 63 00 08 4? ?? ?? ?? 80 01 00 14 38 60 00 00 7C 08 03 A6 38 21 00 10 4E 80 00 20 }
	condition:
		$1
}

rule file_15_0_0 {
	meta:
		name = "__mmap"
		size = 16
		refs = "000c __syscall_error"
	strings:
		$1 = { 38 00 00 5A 44 00 00 02 4C A3 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_16_0_0 {
	meta:
		name = "__nl_langinfo_l"
		size = 120
	strings:
		$1 = { 7C 69 86 71 41 80 00 4C 2F 89 00 06 41 9E 00 44 2F 89 00 0C 41 9D 00 3C 54 63 04 3E 6C 60 FF FF 2F 80 FF FF 41 9E 00 44 55 29 10 3A 7D 24 48 2E 80 09 00 20 7F 83 00 40 40 9C 00 24 38 63 00 08 54 63 10 3A 7D 29 1A 14 80 69 00 04 4E 80 00 20 3C 60 ?? ?? 38 63 ?? ?? 4E 80 00 20 3C 60 ?? ?? 38 63 ?? ?? 4E 80 00 20 39 29 00 10 55 29 10 3A 7C 64 48 2E 4E 80 00 20 }
	condition:
		$1
}

rule file_17_0_0 {
	meta:
		name = "translate"
		size = 96
		refs = "001c __uselocale 0026 _libc_intl_domainname 0034 __dcgettext"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 93 C1 00 08 7C 7E 1B 78 7C 83 23 78 90 01 00 14 93 E1 00 0C 4? ?? ?? ?? 7C 7F 1B 78 3C 60 ?? ?? 7F C4 F3 78 38 A0 00 05 38 63 ?? ?? 4? ?? ?? ?? 7C 7E 1B 78 7F E3 FB 78 4? ?? ?? ?? 80 01 00 14 7F C3 F3 78 83 E1 00 0C 7C 08 03 A6 83 C1 00 08 38 21 00 10 4E 80 00 20 }
	condition:
		$1
}

rule file_17_1_0 {
	meta:
		name = "strerror_l"
		size = 248
		refs = "0022 _sys_nerr_internal 0032 _sys_errlist_internal 0062 .LANCHOR0 006c free 009c __asprintf"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 93 E1 00 0C 7C 7F 1B 79 93 C1 00 08 7C 9E 23 78 90 01 00 14 41 80 00 44 3D 20 ?? ?? 80 09 ?? ?? 7F 9F 00 00 40 9C 00 34 3D 20 ?? ?? 57 E0 10 3A 39 29 ?? ?? 7C 69 00 2E 2F 83 00 00 41 9E 00 1C 80 01 00 14 83 C1 00 08 7C 08 03 A6 83 E1 00 0C 38 21 00 10 4B FF FF 44 3D 22 ?? ?? 39 29 ?? ?? 80 69 00 00 4? ?? ?? ?? 3C 60 ?? ?? 7F C4 F3 78 38 63 ?? ?? 4B FF FF 25 3C 80 ?? ?? 7C 65 1B 78 3C 62 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 7F E6 FB 78 4C C6 31 82 4? ?? ?? ?? 2F 83 FF FF 41 9E 00 28 80 01 00 14 3D 22 ?? ?? 39 29 ?? ?? 83 C1 00 08 7C 08 03 A6 80 69 00 00 83 E1 00 0C 38 21 00 10 4E 80 00 20 3D 22 ?? ?? 83 C1 00 08 38 00 00 00 83 E1 00 0C 39 29 ?? ?? 90 09 00 00 38 60 00 00 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_17_2_0 {
	meta:
		name = "strerror_thread_freeres"
		size = 44
		refs = "000a .LANCHOR0 0018 free"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 3D 22 ?? ?? 90 01 00 14 39 29 ?? ?? 80 69 00 00 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_18_0_0 {
	meta:
		name = "__scanf"
		size = 148
		refs = "0056 stdin 0080 _IO_vfscanf"
	strings:
		$1 = { 94 21 FF 80 7C 08 02 A6 90 81 00 1C 90 01 00 84 90 A1 00 20 90 C1 00 24 90 E1 00 28 91 01 00 2C 91 21 00 30 91 41 00 34 40 86 00 24 D8 21 00 38 D8 41 00 40 D8 61 00 48 D8 81 00 50 D8 A1 00 58 D8 C1 00 60 D8 E1 00 68 D9 01 00 70 38 00 00 01 98 01 00 08 3D 20 ?? ?? 38 00 00 00 98 01 00 09 7C 64 1B 78 38 01 00 88 80 69 ?? ?? 38 A1 00 08 90 01 00 0C 38 C0 00 00 38 01 00 18 90 01 00 10 4? ?? ?? ?? 80 01 00 84 38 21 00 80 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_917_0_0 {
	meta:
		name = "__wscanf"
		size = 148
		refs = "0056 stdin 0080 _IO_vfwscanf"
	strings:
		$1 = { 94 21 FF 80 7C 08 02 A6 90 81 00 1C 90 01 00 84 90 A1 00 20 90 C1 00 24 90 E1 00 28 91 01 00 2C 91 21 00 30 91 41 00 34 40 86 00 24 D8 21 00 38 D8 41 00 40 D8 61 00 48 D8 81 00 50 D8 A1 00 58 D8 C1 00 60 D8 E1 00 68 D9 01 00 70 38 00 00 01 98 01 00 08 3D 20 ?? ?? 38 00 00 00 98 01 00 09 7C 64 1B 78 38 01 00 88 80 69 ?? ?? 38 A1 00 08 90 01 00 0C 38 C0 00 00 38 01 00 18 90 01 00 10 4? ?? ?? ?? 80 01 00 84 38 21 00 80 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_19_0_0 {
	meta:
		name = "fstatvfs"
		size = 124
		refs = "0020 __fstatfs 003c __fxstat64 005c __internal_statvfs"
	strings:
		$1 = { 94 21 FF 40 7C 08 02 A6 93 E1 00 BC 7C 9F 23 78 38 81 00 08 93 C1 00 B8 7C 7E 1B 78 90 01 00 C4 4? ?? ?? ?? 2F 83 00 00 38 60 FF FF 41 9C 00 38 38 60 00 03 7F C4 F3 78 38 A1 00 48 4? ?? ?? ?? 38 C0 00 00 2F 83 FF FF 41 9E 00 08 38 C1 00 48 38 60 00 00 7F E4 FB 78 38 A1 00 08 4? ?? ?? ?? 38 60 00 00 80 01 00 C4 83 C1 00 B8 7C 08 03 A6 83 E1 00 BC 38 21 00 C0 4E 80 00 20 }
	condition:
		$1
}

rule file_20_0_0 {
	meta:
		name = "syscall"
		size = 40
		refs = "0024 __syscall_error"
	strings:
		$1 = { 7C 60 1B 78 7C 83 23 78 7C A4 2B 78 7C C5 33 78 7C E6 3B 78 7D 07 43 78 7D 28 4B 78 44 00 00 02 4C A3 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_21_0_0 {
	meta:
		name = "__strverscmp"
		size = 296
	strings:
		$1 = { 7F 83 20 00 7C 69 1B 78 38 60 00 00 4D 9E 00 20 89 69 00 00 39 29 00 01 89 44 00 00 38 84 00 01 69 60 00 30 7C 6A 58 51 7C 00 00 34 38 EB FF D0 54 00 D9 7E 21 07 00 09 7D 00 01 94 40 82 00 C8 2F 8B 00 00 4D 9E 00 20 3C C0 ?? ?? 38 C6 ?? ?? 48 00 00 08 4D 9E 00 20 89 69 00 00 39 29 00 01 89 44 00 00 38 84 00 01 69 60 00 30 7D 06 40 AE 7C 00 00 34 7C 6A 58 51 2F 8B 00 00 54 00 D9 7E 39 6B FF D0 20 EB 00 09 7C E0 01 94 7D 07 42 14 41 82 FF C4 1D 08 00 03 7C C6 42 14 69 40 00 30 20 00 00 00 7C 06 01 94 38 EA FF D0 21 67 00 09 7D 60 01 94 88 0B 00 0C 7C 00 07 74 2F 80 00 02 4D 9E 00 20 2F 80 00 03 39 29 FF FF 41 9E 00 0C 7C 03 03 78 4E 80 00 20 8D 69 00 01 38 0B FF D0 2B 80 00 09 41 9D 00 2C 89 64 00 00 38 84 00 01 38 0B FF D0 2B 80 00 09 40 9D FF E0 38 60 00 01 4E 80 00 20 3C C0 ?? ?? 38 C6 ?? ?? 4B FF FF 88 89 24 00 00 38 09 FF D0 2B 80 00 09 4D BD 00 20 38 60 FF FF 4E 80 00 20 }
	condition:
		$1
}

rule file_22_0_0 {
	meta:
		name = "getnetent"
		size = 264
		refs = "0052 _GLOBAL_OFFSET_TABLE_ 005a __libc_h_errno 0062 __getnetent_r 007c __nss_getent 0084 __errno_location 00dc __lll_lock_wait_private"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 39 60 00 01 93 61 00 0C 3F 60 ?? ?? 39 20 00 00 93 81 00 10 3B 9B ?? ?? 90 01 00 24 93 A1 00 14 93 C1 00 18 93 E1 00 1C 7C 00 E0 28 7C 00 48 00 40 82 00 0C 7D 60 E1 2D 40 A2 FF F0 4C 00 01 2C 2F 80 00 00 40 9E 00 8C 3D 00 ?? ?? 39 08 ?? ?? 81 08 ?? ?? 3C A0 ?? ?? 3C 60 ?? ?? 38 9C 00 04 38 A5 ?? ?? 38 C0 04 00 38 FC 00 14 7D 08 12 14 38 63 ?? ?? 4? ?? ?? ?? 7C 7E 1B 78 4? ?? ?? ?? 7C 7F 1B 78 83 A3 00 00 38 00 00 00 7C 00 04 AC 7D 20 E0 28 7C 00 E1 2D 40 A2 FF F8 2F 89 00 01 41 9D 00 3C 80 01 00 24 7F C3 F3 78 93 BF 00 00 7C 08 03 A6 83 61 00 0C 83 81 00 10 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 7F 83 E3 78 4? ?? ?? ?? 4B FF FF 70 80 82 8B 68 38 00 00 DD 7F 83 E3 78 60 84 00 01 38 A0 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF A8 }
	condition:
		$1
}

rule file_23_0_0 {
	meta:
		name = "__dup2"
		size = 16
		refs = "000c __syscall_error"
	strings:
		$1 = { 38 00 00 3F 44 00 00 02 4C A3 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_24_0_0 {
	meta:
		name = "__wctrans"
		size = 228
		refs = "000a _GLOBAL_OFFSET_TABLE_ 0016 _nl_current_LC_CTYPE 0054 __rawmemchr 0074 strcmp"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 3D 20 ?? ?? 39 29 ?? ?? 90 01 00 24 81 29 ?? ?? 7D 29 12 14 93 81 00 10 81 29 00 00 93 A1 00 14 7C 7D 1B 78 38 60 00 00 93 C1 00 18 93 E1 00 1C 83 89 00 00 83 FC 00 50 88 1F 00 00 2F 80 00 00 41 9E 00 58 3B C0 00 00 48 00 00 1C 4? ?? ?? ?? 3B DE 00 01 88 03 00 01 3B E3 00 01 2F 80 00 00 41 9E 00 58 7F E4 FB 78 7F A3 EB 78 4? ?? ?? ?? 38 80 00 00 2F 83 00 00 7F E3 FB 78 40 9E FF D0 80 1C 00 6C 7F DE 02 14 38 1E 00 08 54 00 10 3A 7F 9C 02 14 80 7C 00 04 80 01 00 24 83 81 00 10 7C 08 03 A6 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 80 01 00 24 38 60 00 00 83 81 00 10 7C 08 03 A6 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 }
	condition:
		$1
}

rule file_25_0_0 {
	meta:
		name = "critical_factorization"
		size = 508
		refs = "0002 _GLOBAL_OFFSET_TABLE_ 000e _nl_current_LC_CTYPE 001a __libc_tsd_CTYPE_TOLOWER"
	strings:
		$1 = { 3D 20 ?? ?? 94 21 FF E0 39 29 ?? ?? 81 49 ?? ?? 93 A1 00 14 7D 4A 12 14 81 69 ?? ?? 93 E1 00 1C 39 00 00 01 83 AA 00 00 38 E0 00 00 93 C1 00 18 39 80 FF FF 3B C0 00 01 7D 6B 12 14 7C 08 3A 14 7F 80 20 40 40 9C 00 54 81 4B 00 00 2F 8A 00 00 41 9E 01 98 7F E3 62 14 7C C3 00 AE 7F FF 40 AE 54 C6 10 3A 57 FF 10 3A 7C CA 30 2E 7D 4A F8 2E 54 C6 06 3E 55 4A 06 3E 7F 8A 30 40 40 9D 00 D0 7C 07 03 78 39 00 00 01 7F CC 00 50 7C 08 3A 14 7F 80 20 40 41 9C FF B4 81 69 ?? ?? 93 C5 00 00 7D 6B 12 14 81 29 ?? ?? 83 AB 00 00 3B E0 00 01 39 40 00 01 39 00 00 00 38 C0 FF FF 7F C9 12 14 7C 0A 42 14 7F 84 00 40 40 9D 00 54 81 7E 00 00 2F 8B 00 00 41 9E 00 F0 7C E3 00 AE 54 E7 10 3A 7C EB 38 2E 54 E7 06 3E 7D 23 32 14 7D 29 50 AE 55 29 10 3A 7D 6B 48 2E 55 6B 06 3E 7F 8B 38 40 40 9C 00 68 7C 08 03 78 39 40 00 01 7F E6 00 50 7C 0A 42 14 7F 84 00 40 41 9D FF B4 38 66 00 01 39 8C 00 01 7F 83 60 40 40 BC 00 0C 83 E5 00 00 7D 83 63 78 93 E5 00 00 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 7F 86 50 00 41 9E 00 34 7C EC 3B 78 3B C0 00 01 38 E7 00 01 39 00 00 01 4B FF FE D8 7F 87 58 00 41 9E 00 28 7D 06 43 78 3B E0 00 01 39 08 00 01 39 40 00 01 4B FF FF 40 7F 88 F0 00 41 9E 00 1C 39 08 00 01 4B FF FE AC 7F 8A F8 00 41 9E 00 1C 39 4A 00 01 4B FF FF 20 7D 1E 43 78 7C 07 03 78 39 00 00 01 4B FF FE 8C 7D 5F 53 78 7C 08 03 78 39 40 00 01 4B FF FF 00 81 3D 00 00 81 69 00 30 39 6B 02 00 91 7E 00 00 7D 23 00 AE 55 29 10 3A 7C EB 48 2E 54 E7 06 3E 4B FF FF 04 81 5D 00 00 81 4A 00 30 39 4A 02 00 91 4B 00 00 4B FF FE 5C }
	condition:
		$1
}

rule file_25_1_0 {
	meta:
		name = "two_way_long_needle"
		size = 1484
		refs = "009a _GLOBAL_OFFSET_TABLE_ 00a6 __libc_tsd_CTYPE_TOLOWER 00ae _nl_current_LC_CTYPE 0108 __strncasecmp 013c memchr"
	strings:
		$1 = { 94 21 FB A0 7C 08 02 A6 7D 80 00 26 93 61 04 4C 7C 9B 23 78 7C C4 33 78 93 81 04 50 7C 7C 1B 78 7C A3 2B 78 93 E1 04 5C 7C BF 2B 78 38 A1 00 08 90 01 04 64 93 A1 04 54 93 C1 04 58 7C DE 33 78 91 E1 04 1C 92 01 04 20 92 21 04 24 92 41 04 28 92 61 04 2C 92 81 04 30 92 A1 04 34 92 C1 04 38 92 E1 04 3C 93 01 04 40 93 21 04 44 93 41 04 48 91 81 04 18 4B FF FD 91 38 00 01 00 7C 09 03 A6 7C 7D 1B 78 39 21 00 08 97 C9 00 04 42 00 FF FC 2F 9E 00 00 41 9E 00 64 3D 20 ?? ?? 7F C9 03 A6 39 29 ?? ?? 81 49 ?? ?? 7D 4A 12 14 81 29 ?? ?? 81 6A 00 00 7D 29 12 14 80 C9 00 00 39 1E FF FF 39 20 00 00 7D 47 53 78 2F 8B 00 00 7C 09 40 50 41 9E 04 DC 7D 5F 48 AE 38 A1 00 08 39 29 00 01 55 4A 10 3A 7D 4B 50 2E 55 4A 10 3A 7D 45 52 14 90 0A 00 04 42 00 FF D4 82 61 00 08 7F E3 FB 78 7F A5 EB 78 7C 9F 9A 14 4? ?? ?? ?? 2F 83 00 00 40 9E 02 6C 3D 20 ?? ?? 3B 00 00 00 39 29 ?? ?? 7F 38 F2 14 82 09 ?? ?? 7C 7C DA 14 81 29 ?? ?? 38 80 00 00 7C BB C8 50 7E A9 12 14 4? ?? ?? ?? 2F 83 00 00 7E 10 12 14 3A DD FF FF 3B 40 00 00 3A FE FF FF 7E 53 F0 50 7E 14 83 78 7E 3F B2 14 21 FD 00 01 40 9E 01 68 2F 99 00 00 41 9E 01 64 81 35 00 00 2F 89 00 00 41 9E 03 F8 7D 7C CA 14 88 0B FF FF 54 00 10 3A 7D 69 00 2E 38 01 00 08 55 6B 10 3A 7D 60 5A 14 80 0B 00 04 2F 80 00 00 40 9E 01 A4 7F 9A E8 40 7F 4A D3 78 40 9C 00 08 7F AA EB 78 7F 8A B8 40 40 9C 00 70 38 0A 00 01 80 D4 00 00 7F 80 B8 40 7D 0A C2 14 7D 7F 52 14 7D 1C 42 14 7C AA B8 50 39 6B 00 01 7C A9 03 A6 39 08 FF FF 40 BD 00 10 48 00 03 D8 39 4A 00 01 42 40 00 38 2F 89 00 00 41 9E 03 50 88 0B FF FF 39 6B 00 01 8C E8 00 01 54 00 10 3A 54 E7 10 3A 7C 09 00 2E 7C E9 38 2E 7F 80 38 00 41 9E FF D0 7F 8A B8 40 41 9C 01 44 7F 9A E8 40 7F A6 EB 78 40 9C 00 68 7D 18 B2 14 81 35 00 00 7C FA B0 50 80 B4 00 00 7D 1C 42 14 38 E7 00 01 7E CA B3 78 7C E9 03 A6 39 71 FF FF 39 08 00 01 48 00 00 10 42 40 00 CC 7D 46 53 78 39 4A FF FF 2F 89 00 00 41 9E 02 C4 88 0B 00 01 39 6B FF FF 8C E8 FF FF 54 00 10 3A 54 E7 10 3A 7C 09 00 2E 7C E9 38 2E 7F 80 38 00 41 9E FF CC 3B 5A 00 01 7F 9A 30 40 41 9D 00 9C 7F 18 9A 14 7E 5A 93 78 7F 3B CB 78 7F 38 F2 14 7C 7C DA 14 38 80 00 00 7C BB C8 50 4? ?? ?? ?? 2F 83 00 00 41 9E FE A0 38 60 00 00 80 01 04 64 81 81 04 18 7C 08 03 A6 81 E1 04 1C 82 01 04 20 7D 80 81 20 82 21 04 24 82 41 04 28 82 61 04 2C 82 81 04 30 82 A1 04 34 82 C1 04 38 82 E1 04 3C 83 01 04 40 83 21 04 44 83 41 04 48 83 61 04 4C 83 81 04 50 83 A1 04 54 83 C1 04 58 83 E1 04 5C 38 21 04 60 4E 80 00 20 7F 46 D3 78 3B 5A 00 01 7F 9A 30 40 40 9D FF 6C 7C 7C C2 14 4B FF FF 90 2F 9A 00 00 41 9E 00 10 7F 80 98 40 40 9C 00 08 7E 40 93 78 7F 18 02 14 3B 40 00 00 7F 3B CB 78 4B FF FF 4C 7F 0F C2 14 7F 18 52 14 3B 40 00 00 7F 3B CB 78 4B FF FF 38 7D 3D F0 50 7F 89 E8 40 41 9C 01 8C 3D 60 ?? ?? 39 6B ?? ?? 3A 9D FF FF 82 4B ?? ?? 39 29 00 01 2E 14 FF FF 91 21 00 08 7E DF A2 14 81 6B ?? ?? 7E 52 12 14 3B 20 00 00 7E EB 12 14 3B 1E FF FF 7E 55 93 78 7E 7D B0 50 7F FF EA 14 22 3D 00 01 7F 59 F2 14 7C 7C DA 14 38 80 00 00 7C BB D0 50 4? ?? ?? ?? 2F 83 00 00 40 BE FE E8 2F 9A 00 00 41 BE FE E4 81 37 00 00 2F 89 00 00 41 9E 01 9C 7D 7C D2 14 88 0B FF FF 38 A1 00 08 54 00 10 3A 7D 69 00 2E 55 6B 10 3A 7D 65 5A 14 80 0B 00 04 2F 80 00 00 40 9E 00 D4 7F 9D C0 40 40 9C 00 70 38 1D 00 01 80 D5 00 00 7F 80 C0 40 7D 59 EA 14 7D 5C 52 14 7C 1D C0 50 39 7F 00 01 7C 09 03 A6 39 4A FF FF 7F A8 EB 78 40 BD 00 10 48 00 01 30 39 08 00 01 42 40 00 38 2F 89 00 00 41 9E 00 B8 88 0B FF FF 39 6B 00 01 8C EA 00 01 54 00 10 3A 54 E7 10 3A 7C 09 00 2E 7C E9 38 2E 7F 80 38 00 41 9E FF D0 7F 88 C0 40 41 9C 00 6C 41 92 00 80 7D 59 A2 14 81 37 00 00 7D 5C 52 14 80 F5 00 00 7C 13 B0 50 39 4A 00 01 7C 09 03 A6 39 76 FF FF 48 00 00 08 42 40 00 58 2F 89 00 00 41 9E 00 94 88 0B 00 01 39 6B FF FF 8D 0A FF FF 54 00 10 3A 55 08 10 3A 7C 09 00 2E 7D 09 40 2E 7F 80 40 00 41 9E FF D4 80 01 00 08 7F 39 02 14 7F 5B D3 78 4B FF FE D0 7F 31 CA 14 7F 39 42 14 7F 5B D3 78 4B FF FE C0 7F A9 EB 78 4B FF FE 74 7C 7C CA 14 4B FF FD B4 81 26 00 00 81 29 00 30 39 29 02 00 91 37 00 00 4B FF FF 3C 81 25 00 00 81 29 00 30 39 29 02 00 91 35 00 00 4B FF FD 30 81 26 00 00 81 29 00 30 39 29 02 00 91 35 00 00 4B FF FC A4 81 27 00 00 81 29 00 30 39 29 02 00 91 37 00 00 4B FF FF 60 81 30 00 00 81 29 00 00 81 29 00 30 39 29 02 00 91 35 00 00 4B FF FB F8 38 A0 00 01 7C A9 03 A6 4B FF FE D4 81 32 00 00 81 29 00 00 81 29 00 30 39 29 02 00 91 37 00 00 4B FF FE 54 81 66 00 00 81 6B 00 30 39 6B 02 00 91 67 00 00 4B FF FB 18 38 00 00 01 7C 09 03 A6 4B FF FC 2C }
	condition:
		$1
}

rule file_25_2_0 {
	meta:
		name = "__strcasestr"
		size = 1468
		refs = "0076 _GLOBAL_OFFSET_TABLE_ 007e __libc_tsd_CTYPE_TOLOWER 0082 _nl_current_LC_CTYPE 01b8 __strncasecmp 0340 memchr"
	strings:
		$1 = { 94 21 FF A0 7C 08 02 A6 7D 80 00 26 93 C1 00 58 7C 9E 23 78 90 01 00 64 91 E1 00 1C 92 01 00 20 92 21 00 24 92 41 00 28 92 61 00 2C 92 81 00 30 92 A1 00 34 92 C1 00 38 92 E1 00 3C 93 01 00 40 93 21 00 44 93 41 00 48 93 61 00 4C 93 81 00 50 93 A1 00 54 93 E1 00 5C 91 81 00 18 88 03 00 00 2F 80 00 00 41 9E 03 24 88 04 00 00 2F 80 00 00 41 9E 00 94 3D 60 ?? ?? 39 6B ?? ?? 81 0B ?? ?? 81 6B ?? ?? 7D 08 12 14 7D 6B 12 14 81 28 00 00 80 AB 00 00 7C 9F 23 78 7C 6B 1B 78 39 40 00 01 7D 06 43 78 48 00 00 10 88 1F 00 00 2F 80 00 00 41 9E 00 B0 2F 89 00 00 41 9E 04 64 88 0B 00 00 89 1F 00 00 3B FF 00 01 8C EB 00 01 54 00 10 3A 55 08 10 3A 7C 09 00 2E 7D 09 40 2E 2F 87 00 00 7C 00 42 78 7C 00 00 34 54 00 D9 7E 7C 0A 50 38 40 9E FF B8 88 1F 00 00 2F 80 00 00 41 9E 00 64 38 60 00 00 80 01 00 64 81 81 00 18 7C 08 03 A6 81 E1 00 1C 82 01 00 20 7D 80 81 20 82 21 00 24 82 41 00 28 82 61 00 2C 82 81 00 30 82 A1 00 34 82 C1 00 38 82 E1 00 3C 83 01 00 40 83 21 00 44 83 41 00 48 83 61 00 4C 83 81 00 50 83 A1 00 54 83 C1 00 58 83 E1 00 5C 38 21 00 60 4E 80 00 20 2F 8A 00 00 40 BE FF A0 7F FE F8 50 2B 9F 00 1F 3B A3 00 01 3B 9F FF FF 40 9D 00 1C 7F A3 EB 78 7F 84 E3 78 7F C5 F3 78 7F E6 FB 78 4B FF F8 A9 4B FF FF 74 7F E4 FB 78 38 A1 00 08 7F C3 F3 78 4B FF F6 99 82 C1 00 08 7C 7B 1B 78 7C 9E B2 14 7F C3 F3 78 7F 65 DB 78 4? ?? ?? ?? 2F 83 00 00 41 9E 01 D4 3D 60 ?? ?? 39 6B ?? ?? 81 0B ?? ?? 7D 08 12 14 81 28 00 00 7D 5D DA 14 2F 89 00 00 41 9E 03 B8 7E 1B F8 50 7C 1E D8 AE 7F 10 D8 40 54 00 10 3A 7E A9 00 2E 56 B5 06 3E 40 98 00 08 7F 70 DB 78 3A 9B FF FF 3A 10 00 01 2E 14 FF FF 92 01 00 08 82 CB ?? ?? 3B 5B 00 01 81 6B ?? ?? 7E FE A2 14 7E D6 12 14 7F 0B 12 14 7D 53 50 F8 7E 3B B8 50 7E 5E D2 14 21 FB 00 01 41 9E 03 44 88 0A 00 00 38 6A 00 01 54 00 10 3A 7C 09 00 2E 54 00 06 3E 7F 95 00 00 40 9E 01 20 7F 9F D0 40 7C 63 9A 14 7F 48 D3 78 40 9D 00 60 7C 1A F8 50 80 D6 00 00 39 72 00 01 7C 09 03 A6 48 00 00 0C 39 08 00 01 42 40 00 44 2F 89 00 00 41 9E 02 A4 88 0B FF FF 39 6B 00 01 54 00 10 3A 7C E9 00 2E 8C 0A 00 01 54 00 10 3A 7C 09 00 2E 54 00 06 3E 7F 87 00 00 41 9E FF CC 2F 80 00 00 41 BE FE 44 7F 9F 40 40 41 9D 00 A8 41 92 02 44 7D 43 A2 14 81 38 00 00 7D 5D 52 14 80 F6 00 00 7C 11 B8 50 39 4A 00 01 7C 09 03 A6 39 77 FF FF 48 00 00 08 42 40 02 1C 2F 89 00 00 41 9E 02 4C 88 0B 00 01 39 6B FF FF 54 00 10 3A 7D 09 00 2E 8C 0A FF FF 54 00 10 3A 7C 09 00 2E 54 00 06 3E 7F 88 00 00 41 9E FF D0 2F 80 00 00 41 BE FD D8 7F 23 82 14 7F D9 FA 14 7C 7D E2 14 38 80 00 00 7C BC F0 50 4? ?? ?? ?? 2F 83 00 00 40 BE FD B8 2F 9E 00 00 41 BE FD B0 7D 59 DA 14 7D 5D 52 14 7F DC F3 78 81 38 00 00 2F 89 00 00 4B FF FE D4 7C 6F 1A 14 7F 23 42 14 4B FF FF BC 2F 80 00 00 41 BE FD 84 7C 6A 1B 78 4B FF FF DC 7C 9F 23 78 39 40 00 01 4B FF FD 64 3D 20 ?? ?? 39 29 ?? ?? 82 A9 ?? ?? 3A FB FF FF 81 29 ?? ?? 3B 40 00 00 3B 20 00 00 7E 56 F8 50 7E B5 12 14 7E 89 12 14 7E 7E BA 14 22 3B 00 01 7F 19 FA 14 7C 7D E2 14 38 80 00 00 7C BC C0 50 4? ?? ?? ?? 2F 83 00 00 40 BE FD 24 2F 98 00 00 41 BE FD 20 7F 9A D8 40 7F 4A D3 78 40 9C 00 08 7F 6A DB 78 7F 9F 50 40 40 9D 00 68 7D 0A CA 14 81 35 00 00 7D 7E 52 14 80 D4 00 00 7D 1D 42 14 7C 0A F8 50 39 6B 00 01 7C 09 03 A6 39 08 FF FF 48 00 00 0C 39 4A 00 01 42 40 00 38 2F 89 00 00 41 9E 01 24 88 0B FF FF 39 6B 00 01 8C E8 00 01 54 00 10 3A 54 E7 10 3A 7C 09 00 2E 7C E9 38 2E 7F 80 38 00 41 9E FF D0 7F 9F 50 40 41 9D 00 98 7F 9B D0 40 7F 66 DB 78 40 9D 00 68 7D 19 BA 14 81 35 00 00 7C FA B8 50 80 B4 00 00 7D 1D 42 14 38 E7 00 01 7E EA BB 78 7C E9 03 A6 39 73 FF FF 39 08 00 01 48 00 00 10 42 40 00 54 7D 46 53 78 39 4A FF FF 2F 89 00 00 41 9E 00 C0 88 0B 00 01 39 6B FF FF 8C E8 FF FF 54 00 10 3A 54 E7 10 3A 7C 09 00 2E 7C E9 38 2E 7F 80 38 00 41 9E FF CC 3B 5A 00 01 7F 9A 30 40 41 9D 00 38 7F 39 B2 14 7E 5A 93 78 7F 1C C3 78 4B FF FE D8 7F 46 D3 78 4B FF FF E0 7F 31 CA 14 7F 39 52 14 3B 40 00 00 7F 1C C3 78 4B FF FE BC 7C 7D 1A 14 4B FF FB F4 7C 7D CA 14 4B FF FB EC 81 25 00 00 81 29 00 30 39 29 02 00 91 26 00 00 4B FF FB 90 81 26 00 00 81 29 00 30 39 29 02 00 91 38 00 00 4B FF FD 50 81 27 00 00 81 29 00 30 39 29 02 00 91 38 00 00 4B FF FD A8 81 26 00 00 81 29 00 30 39 29 02 00 91 35 00 00 4B FF FE D0 81 25 00 00 81 29 00 30 39 29 02 00 91 35 00 00 4B FF FF 34 81 36 00 00 81 29 00 00 81 29 00 30 39 29 02 00 91 38 00 00 4B FF FC AC 81 2B ?? ?? 7D 29 12 14 81 29 00 00 81 29 00 00 81 29 00 30 39 29 02 00 2F 89 00 00 91 28 00 00 4B FF FC 2C }
	condition:
		$1
}

rule file_26_1_0 {
	meta:
		name = "__libc_csu_init"
		size = 236
		refs = "000e __preinit_array_end 001a __preinit_array_start 007a __init_array_start 007c _init 0082 __init_array_end"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 93 41 00 08 3F 40 ?? ?? 3B 5A ?? ?? 93 61 00 0C 3F 60 ?? ?? 3B 7B ?? ?? 7F 5B D0 50 93 81 00 10 7F 5A 16 71 93 A1 00 14 7C BC 2B 78 7C 9D 23 78 93 C1 00 18 7C 7E 1B 78 90 01 00 24 93 E1 00 1C 41 82 00 30 3B 7B FF FC 3B E0 00 00 84 1B 00 04 7F C3 F3 78 7F A4 EB 78 7F 85 E3 78 7C 09 03 A6 3B FF 00 01 4E 80 04 21 7F 9F D0 00 40 9E FF E0 3F 60 ?? ?? 4? ?? ?? ?? 3F 40 ?? ?? 3B 7B ?? ?? 3B 5A ?? ?? 7F 5B D0 50 7F 5A 16 71 41 82 00 30 3B 7B FF FC 3B E0 00 00 84 1B 00 04 7F C3 F3 78 7F A4 EB 78 7F 85 E3 78 7C 09 03 A6 3B FF 00 01 4E 80 04 21 7F 9F D0 00 40 9E FF E0 80 01 00 24 83 41 00 08 7C 08 03 A6 83 61 00 0C 83 81 00 10 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 }
	condition:
		$1
}

rule file_26_2_0 {
	meta:
		name = "__libc_csu_fini"
		size = 116
		refs = "000e __fini_array_start 0016 __fini_array_end 0058 _fini"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 93 C1 00 08 3F C0 ?? ?? 93 E1 00 0C 3F E0 ?? ?? 3B FF ?? ?? 90 01 00 14 38 1E ?? ?? 7F E0 F8 50 7F FF 16 71 41 82 00 2C 3B FF FF FF 57 FE 10 3A 7F DE 02 14 3B DE 00 04 84 1E FF FC 7C 09 03 A6 4E 80 04 21 2F 9F 00 00 3B FF FF FF 40 9E FF EC 4? ?? ?? ?? 80 01 00 14 83 C1 00 08 7C 08 03 A6 83 E1 00 0C 38 21 00 10 4E 80 00 20 }
	condition:
		$1
}

rule file_27_0_0 {
	meta:
		name = "xdr_rmtcall_args"
		size = 360
		refs = "0030 xdr_u_long"
	strings:
		$1 = { 94 21 FF D0 7C 08 02 A6 93 A1 00 24 7C 9D 23 78 93 C1 00 28 7C 7E 1B 78 93 E1 00 2C 3B E0 00 00 90 01 00 34 93 41 00 18 93 61 00 1C 93 81 00 20 4? ?? ?? ?? 2F 83 00 00 40 9E 00 30 80 01 00 34 7F E3 FB 78 83 41 00 18 7C 08 03 A6 83 61 00 1C 83 81 00 20 83 A1 00 24 83 C1 00 28 83 E1 00 2C 38 21 00 30 4E 80 00 20 7F C3 F3 78 38 9D 00 04 4? ?? ?? ?? 2F 83 00 00 41 9E FF C4 7F C3 F3 78 38 9D 00 08 4? ?? ?? ?? 2F 83 00 00 41 9E FF B0 81 3E 00 04 7C 3B 0B 78 97 FB 00 08 7F C3 F3 78 80 09 00 10 7C 09 03 A6 4E 80 04 21 7F 64 DB 78 7C 7C 1B 78 7F C3 F3 78 4? ?? ?? ?? 2F 83 00 00 41 9E FF 7C 81 3E 00 04 7F C3 F3 78 80 09 00 10 7C 09 03 A6 4E 80 04 21 80 1D 00 14 7C 7B 1B 78 80 9D 00 10 7F C3 F3 78 7C 09 03 A6 4C C6 31 82 4E 80 04 21 2F 83 00 00 41 9E FF 44 81 3E 00 04 7F C3 F3 78 80 09 00 10 7C 09 03 A6 4E 80 04 21 81 3E 00 04 7F 7B 18 50 80 09 00 14 7F 84 E3 78 97 7D 00 0C 7C 7A 1B 78 7C 09 03 A6 7F C3 F3 78 4E 80 04 21 7F C3 F3 78 7F A4 EB 78 4? ?? ?? ?? 2F 83 00 00 41 9E FE F8 81 3E 00 04 7F C3 F3 78 7F 44 D3 78 80 09 00 14 3B E0 00 01 7C 09 03 A6 4E 80 04 21 4B FF FE D8 }
	condition:
		$1
}

rule file_27_1_0 {
	meta:
		name = "xdr_rmtcallres"
		size = 192
		refs = "000a xdr_u_long 003c xdr_reference"
	strings:
		$1 = { 94 21 FF D0 7C 08 02 A6 3C C0 ?? ?? 90 01 00 34 38 A0 00 04 38 C6 ?? ?? 80 04 00 00 93 E1 00 2C 7C 9F 23 78 7C 24 0B 78 93 A1 00 24 3B A0 00 00 93 C1 00 28 7C 7E 1B 78 94 04 00 08 4? ?? ?? ?? 2F 83 00 00 40 9E 00 24 80 01 00 34 7F A3 EB 78 83 C1 00 28 7C 08 03 A6 83 A1 00 24 83 E1 00 2C 38 21 00 30 4E 80 00 20 7F C3 F3 78 38 9F 00 04 4? ?? ?? ?? 2F 83 00 00 41 9E FF D0 80 1F 00 0C 7F C3 F3 78 81 21 00 08 80 9F 00 08 7C 09 03 A6 91 3F 00 00 4C C6 31 82 4E 80 04 21 80 01 00 34 7C 7D 1B 78 83 C1 00 28 7C 08 03 A6 7F A3 EB 78 83 E1 00 2C 83 A1 00 24 38 21 00 30 4E 80 00 20 }
	condition:
		$1
}

rule file_27_2_0 {
	meta:
		name = "pmap_rmtcall"
		size = 372
		refs = "00a8 clntudp_create 00ba xdr_rmtcall_args 00c2 xdr_rmtcallres"
	strings:
		$1 = { 94 21 FF 90 7C 08 02 A6 3D 60 ?? ?? 90 01 00 74 39 6B ?? ?? 38 00 00 6F 92 81 00 40 3A 80 00 10 92 A1 00 44 7D 15 43 78 92 C1 00 48 7D 56 53 78 92 E1 00 4C 93 01 00 50 7C 98 23 78 3C 80 00 01 93 21 00 54 60 84 86 A0 7C B9 2B 78 93 41 00 58 38 A0 00 02 7C DA 33 78 93 61 00 5C 38 C1 00 38 7C FB 3B 78 93 81 00 60 38 E1 00 08 7D 3C 4B 78 93 A1 00 64 93 C1 00 68 93 E1 00 6C 7C 7F 1B 78 83 C1 00 78 81 8B 00 04 B0 03 00 02 38 00 FF FF 81 6B 00 00 83 BE 00 00 90 01 00 08 83 DE 00 04 91 61 00 38 91 81 00 3C 4? ?? ?? ?? 7C 77 1B 79 41 82 00 78 81 77 00 04 3C A0 ?? ?? 80 01 00 7C 3C E0 ?? ?? 39 21 00 38 93 01 00 1C 38 80 00 05 90 01 00 0C 38 A5 ?? ?? 38 C1 00 1C 80 0B 00 00 38 E7 ?? ?? 93 21 00 20 39 01 00 0C 7C 09 03 A6 93 41 00 24 92 A1 00 2C 93 61 00 30 92 C1 00 14 93 81 00 18 93 A1 00 38 93 C1 00 3C 4E 80 04 21 81 37 00 04 7C 74 1B 78 80 09 00 10 7E E3 BB 78 7C 09 03 A6 4E 80 04 21 38 00 00 00 82 A1 00 44 B0 1F 00 02 7E 83 A3 78 80 01 00 74 82 81 00 40 7C 08 03 A6 82 C1 00 48 82 E1 00 4C 83 01 00 50 83 21 00 54 83 41 00 58 83 61 00 5C 83 81 00 60 83 A1 00 64 83 C1 00 68 83 E1 00 6C 38 21 00 70 4E 80 00 20 }
	condition:
		$1
}

rule file_27_3_0 {
	meta:
		name = "clnt_broadcast"
		size = 1364
		refs = "007c authunix_create_default 0094 __socket 00b0 __setsockopt 00c8 getifaddrs 015c freeifaddrs 0180 _create_xid 0218 xdrmem_create 0224 xdr_callmsg 0238 xdr_rmtcall_args 0282 xdr_rmtcallres 0286 xdr_void 0296 _null_auth 02d4 __sendto 02fe _libc_intl_domainname 0308 __dcgettext 0310 perror 0318 __close 03e8 __poll 042c __recvfrom 0438 __errno_location 04ac xdr_replymsg"
	strings:
		$1 = { 94 21 D6 E0 7D 80 00 26 7C 08 02 A6 92 A1 28 F4 7D 55 53 78 90 01 29 24 92 C1 28 F8 92 E1 28 FC 3A E0 00 01 93 01 29 00 93 21 29 04 7D 39 4B 78 93 41 29 08 7C 7A 1B 78 93 61 29 0C 7C 9B 23 78 93 81 29 10 7C BC 2B 78 93 A1 29 14 7C DD 33 78 93 C1 29 18 7C FE 3B 78 93 E1 29 1C 7D 1F 43 78 91 81 28 D8 91 E1 28 DC 92 01 28 E0 92 21 28 E4 92 41 28 E8 92 61 28 EC 92 81 28 F0 4? ?? ?? ?? 7C 78 1B 78 38 80 00 02 92 E1 00 0C 38 60 00 02 38 A0 00 11 4? ?? ?? ?? 7C 76 1B 79 41 80 02 F4 38 80 00 01 38 A0 00 06 38 C1 00 0C 38 E0 00 04 4? ?? ?? ?? 2F 83 00 00 41 9C 02 3C 38 61 00 14 92 C1 00 18 B2 E1 00 1C 4? ?? ?? ?? 2F 83 00 00 40 9E 02 CC 81 41 00 14 38 60 00 00 3A E0 00 00 2F 8A 00 00 7D 49 53 78 40 BE 00 1C 48 00 00 70 81 29 00 00 2F 17 00 13 2F 89 00 00 41 9E 00 5C 41 99 00 58 80 09 00 08 54 00 07 BE 2F 80 00 03 40 9E FF E0 81 69 00 0C 2F 8B 00 00 41 BE FF D4 A0 0B 00 00 2F 80 00 02 40 9E FF C8 81 09 00 14 56 EB 10 3A 81 29 00 00 3A F7 00 01 80 08 00 04 39 01 00 08 2F 89 00 00 7D 68 5A 14 90 0B 00 A8 2F 17 00 13 40 9E FF AC 7D 43 53 78 4? ?? ?? ?? 38 00 00 02 3A 60 00 00 B0 01 00 20 38 00 00 6F 92 61 00 24 92 61 00 28 92 61 00 2C B0 01 00 22 4? ?? ?? ?? 38 00 00 02 82 58 00 00 7C 74 1B 78 80 F8 00 04 38 61 00 50 81 18 00 08 38 81 01 00 81 58 00 0C 38 A0 05 78 81 78 00 10 38 C0 00 00 81 38 00 14 92 61 00 84 3E 60 00 01 62 73 86 A0 90 01 00 88 90 01 00 90 38 00 00 05 90 01 00 94 38 01 00 10 90 E1 00 9C 91 01 00 A0 91 41 00 A4 91 61 00 A8 91 21 00 AC 93 C1 00 78 3B C0 00 01 90 01 00 40 92 81 00 80 92 61 00 8C 92 41 00 98 93 41 00 68 93 61 00 6C 93 81 00 70 93 A1 00 7C 93 E1 00 4C 93 21 00 48 4? ?? ?? ?? 38 61 00 50 38 81 00 80 4? ?? ?? ?? 2F 83 00 00 41 BE 00 E8 38 61 00 50 38 81 00 68 4? ?? ?? ?? 2F 83 00 00 41 BE 00 D4 81 21 00 54 38 61 00 50 80 09 00 10 7C 09 03 A6 4E 80 04 21 81 21 00 54 7C 7C 1B 78 80 09 00 1C 2F 80 00 00 41 9E 00 10 38 61 00 50 7C 09 03 A6 4E 80 04 21 2E 17 00 00 2D 95 00 00 3F 40 ?? ?? 3E 20 ?? ?? 3B 60 0F A0 3A 61 00 40 3B 5A ?? ?? 3E 40 ?? ?? 3A 00 00 02 3A 31 ?? ?? 41 92 01 10 3B A1 00 AC 3B C0 00 00 48 00 00 08 41 9A 01 00 84 1D 00 04 7E C3 B3 78 38 81 01 00 7F 85 E3 78 90 01 00 24 38 C0 00 00 38 E1 00 20 39 00 00 10 4? ?? ?? ?? 3B DE 00 01 7F 9C 18 00 7F 1E B8 00 41 9E FF CC 3C 80 ?? ?? 38 84 ?? ?? 48 00 00 0C 3C 80 ?? ?? 38 84 ?? ?? 3C 60 ?? ?? 38 A0 00 05 38 63 ?? ?? 4? ?? ?? ?? 3B C0 00 03 4? ?? ?? ?? 7E C3 B3 78 4? ?? ?? ?? 81 38 00 20 7F 03 C3 78 80 09 00 10 7C 09 03 A6 4E 80 04 21 80 01 29 24 81 81 28 D8 7F C3 F3 78 7C 08 03 A6 81 E1 28 DC 82 01 28 E0 7D 81 81 20 82 21 28 E4 82 41 28 E8 82 61 28 EC 82 81 28 F0 82 A1 28 F4 82 C1 28 F8 82 E1 28 FC 83 01 29 00 83 21 29 04 83 41 29 08 83 61 29 0C 83 81 29 10 83 A1 29 14 83 C1 29 18 83 E1 29 1C 38 21 29 20 4E 80 00 20 3C 80 ?? ?? 38 84 ?? ?? 4B FF FF 64 3C 60 ?? ?? 38 63 ?? ?? 4? ?? ?? ?? 3A E0 00 00 4B FF FD B4 41 8E 01 64 3B D2 ?? ?? 3B A0 00 10 81 7E 00 00 38 61 00 18 81 3E 00 04 38 80 00 01 80 1E 00 08 7F 65 DB 78 91 61 00 8C 91 21 00 90 90 01 00 94 92 61 00 9C 93 41 00 A0 4? ?? ?? ?? 2F 83 FF FF 41 9E 00 7C 2F 83 00 00 40 9E 00 18 2F 9B 36 B0 3B 7B 07 D0 40 BE FE 9C 3B C0 00 05 4B FF FF 08 38 81 06 78 93 A1 00 08 38 A0 22 60 38 C0 00 00 38 E1 00 30 39 01 00 08 7E C3 B3 78 4? ?? ?? ?? 2C 03 00 00 40 80 00 54 4? ?? ?? ?? 80 03 00 00 2F 80 00 04 41 9E FF CC 3C 80 ?? ?? 38 84 ?? ?? 3C 60 ?? ?? 38 A0 00 05 38 63 ?? ?? 4? ?? ?? ?? 3B C0 00 04 4? ?? ?? ?? 4B FF FE AC 4? ?? ?? ?? 80 03 00 00 2F 80 00 04 41 9E FF 44 3C 80 ?? ?? 38 84 ?? ?? 4B FF FF CC 2B 83 00 03 40 9D FF 30 7C 65 1B 78 38 C0 00 01 38 61 00 50 38 81 06 78 4? ?? ?? ?? 38 61 00 50 38 81 00 80 4? ?? ?? ?? 39 E0 00 00 2F 83 00 00 41 9E 00 10 80 01 00 80 7F 94 00 00 41 9E 00 58 38 81 00 80 92 01 00 50 38 61 00 50 92 21 00 A0 4? ?? ?? ?? 38 61 00 50 7F E9 03 A6 7F 24 CB 78 4C C6 31 82 4E 80 04 21 81 21 00 54 80 09 00 1C 2F 80 00 00 41 9E 00 10 38 61 00 50 7C 09 03 A6 4E 80 04 21 2F 8F 00 00 41 9E FE AC 3B C0 00 00 4B FF FD FC 80 01 00 88 2F 80 00 00 40 BE FF A4 80 01 00 98 2F 80 00 00 40 9E FF 98 80 01 00 10 7F 23 CB 78 38 81 00 30 7E A9 03 A6 B0 01 00 32 4E 80 04 21 7C 6F 1B 78 4B FF FF 78 }
	condition:
		$1
}

rule file_28_0_0 {
	meta:
		name = "compute_tzname_max"
		size = 80
		refs = "000a __tzname_cur_max"
	strings:
		$1 = { 3D 20 ?? ?? 81 29 ?? ?? 3D 60 ?? ?? 7C 69 1A 14 88 09 00 00 7D 2A 4B 78 2F 80 00 00 41 9E 00 24 8C 0A 00 01 2F 80 00 00 40 9E FF F8 80 0B ?? ?? 7D 29 50 50 7F 80 48 40 40 9C 00 08 91 2B ?? ?? 39 2A 00 01 7F 89 18 40 41 9C FF C8 4E 80 00 20 }
	condition:
		$1
}

rule file_28_1_0 {
	meta:
		name = "__tzfile_read"
		size = 2900
		refs = "0022 __use_tzfile 0094 free 0106 __libc_enable_secure 0128 strstr 0144 getenv 015c strlen 01a0 mempcpy 01b8 memcpy 01d4 __xstat64 0204 _IO_new_fopen 0210 fileno 0220 __fxstat64 0288 fread_unlocked 02a8 memcmp 02b8 _IO_new_fclose 03cc malloc 0730 __tzstring 0746 __tzname 0806 __daylight 0812 __timezone 094c fseek 095c ftello 0a80 __uflow 0b44 __assert_fail"
	strings:
		$1 = { 94 21 FF 00 7D 80 00 26 7C 08 02 A6 93 C1 00 F8 7C 7E 1B 79 90 01 01 04 38 00 00 00 93 61 00 EC 3F 60 ?? ?? 93 01 00 E0 7C B8 2B 78 93 21 00 E4 7C 99 23 78 93 A1 00 F4 93 E1 00 FC 7C 3F 0B 78 83 BB ?? ?? 91 C1 00 B8 91 E1 00 BC 92 01 00 C0 92 21 00 C4 92 41 00 C8 92 61 00 CC 92 81 00 D0 92 A1 00 D4 92 C1 00 D8 92 E1 00 DC 93 41 00 E8 93 81 00 F0 91 81 00 B4 90 1B ?? ?? 41 82 02 A0 88 1E 00 00 3F 80 ?? ?? 2F 80 00 00 40 9E 00 78 80 7C ?? ?? 4? ?? ?? ?? 38 00 00 00 90 1C ?? ?? 39 7F 01 00 80 0B 00 04 81 8B FF B4 7C 08 03 A6 81 CB FF B8 81 EB FF BC 7D 80 81 20 82 0B FF C0 82 2B FF C4 82 4B FF C8 82 6B FF CC 82 8B FF D0 82 AB FF D4 82 CB FF D8 82 EB FF DC 83 0B FF E0 83 2B FF E4 83 4B FF E8 83 6B FF EC 83 8B FF F0 83 AB FF F4 83 CB FF F8 83 EB FF FC 7D 61 5B 78 4E 80 00 20 3D 20 ?? ?? 81 29 ?? ?? 2E 00 00 2F 2F 89 00 00 41 9E 00 24 41 92 01 B8 3C 80 ?? ?? 7F C3 F3 78 38 84 ?? ?? 4? ?? ?? ?? 3F 80 ?? ?? 2F 83 00 00 40 9E FF 5C 41 92 00 88 3C 60 ?? ?? 38 63 ?? ?? 4? ?? ?? ?? 7C 7C 1B 79 41 82 01 BC 88 1C 00 00 2F 80 00 00 41 9E 01 B0 4? ?? ?? ?? 7C 77 1B 78 3A C3 00 01 7F C3 F3 78 4? ?? ?? ?? 81 21 00 00 3B 43 00 01 7E DA B2 14 38 16 00 1E 54 00 00 36 7C 00 00 D0 7D 21 01 6E 7F 84 E3 78 7E E5 BB 78 3B 81 00 17 57 9C 00 36 7F 83 E3 78 4? ?? ?? ?? 38 00 00 2F 98 03 00 00 7F C4 F3 78 38 63 00 01 7F 45 D3 78 4? ?? ?? ?? 7F 9E E3 78 2F 9D 00 00 41 9E 00 34 38 60 00 03 7F C4 F3 78 38 BF 00 40 4? ?? ?? ?? 2F 83 00 00 40 9E 00 1C 3D 20 ?? ?? 81 7F 00 48 39 29 ?? ?? 80 09 00 08 7F 8B 00 00 41 9E 01 3C 3C 80 ?? ?? 7F C3 F3 78 38 84 ?? ?? 4? ?? ?? ?? 7C 7E 1B 79 41 82 00 BC 4? ?? ?? ?? 38 BF 00 40 7C 64 1B 78 38 60 00 03 4? ?? ?? ?? 7C 7A 1B 79 40 82 00 98 3F 80 ?? ?? 80 7C ?? ?? 3E A0 ?? ?? 3B B5 ?? ?? 4? ?? ?? ?? 80 1E 00 00 81 3F 00 40 38 7F 00 10 81 5F 00 44 60 00 80 00 90 1E 00 00 38 80 00 2C 38 A0 00 01 91 3D 00 10 7F C6 F3 78 91 5D 00 14 81 3F 00 48 81 5F 00 4C 80 1F 00 90 91 3D 00 08 91 5D 00 0C 90 1D 00 18 93 5C ?? ?? 4? ?? ?? ?? 2F 83 00 01 40 9E 00 24 3E 80 ?? ?? 3A 94 ?? ?? 38 7F 00 10 7E 84 A3 78 38 A0 00 04 4? ?? ?? ?? 7C 72 1B 79 41 82 00 CC 7F C3 F3 78 4? ?? ?? ?? 4B FF FD D4 7F C3 F3 78 4? ?? ?? ?? 3F 80 ?? ?? 4B FF FD C4 3C 80 ?? ?? 38 84 ?? ?? 38 A0 00 0F 4? ?? ?? ?? 2F 83 00 00 41 BE FE 38 3C 80 ?? ?? 7F C3 F3 78 38 84 ?? ?? 38 A0 00 13 4? ?? ?? ?? 2F 83 00 00 40 BE FD 90 4B FF FE 18 3F 80 ?? ?? 3A C0 00 14 3A E0 00 13 3B 9C ?? ?? 4B FF FE 50 2F 9D 00 00 3F C0 ?? ?? 3B DE ?? ?? 41 BE FE D0 4B FF FE 9C 80 09 00 0C 81 7F 00 4C 7F 8B 00 00 40 9E FE BC 80 09 00 10 81 7F 00 40 7F 8B 00 00 40 9E FE AC 80 09 00 14 81 7F 00 44 7F 8B 00 00 40 9E FE 9C 80 09 00 18 81 3F 00 90 7F 89 00 00 40 9E FE 8C 38 00 00 01 90 1B ?? ?? 4B FF FD 28 82 7F 00 30 81 3F 00 34 83 5F 00 38 1D F3 00 05 80 1F 00 2C 55 30 18 38 92 7D 00 1C 39 EF 00 03 3A 3A 00 03 91 3D 00 20 55 EF 00 3A 7E 31 82 14 90 1D 00 24 54 0E 18 38 7E 31 7A 14 82 FF 00 28 56 31 00 3A 82 DF 00 24 7C 79 72 14 7C 63 8A 14 4? ?? ?? ?? 2F 83 00 00 90 7C ?? ?? 41 BE FE DC 2F 99 00 00 92 5D 00 34 7D E3 7A 14 56 60 10 3A 91 FD 00 2C 7C 03 02 14 7E 0F 82 14 90 1D 00 28 7E 23 8A 14 92 15 ?? ?? 92 3D 00 30 41 9E 00 0C 7E 31 72 14 92 38 00 00 38 80 00 05 7E 65 9B 78 7F C6 F3 78 4? ?? ?? ?? 80 1D 00 1C 7F 83 00 00 40 BE FE 88 2F 83 00 00 41 9E 06 64 81 5D 00 28 39 20 00 00 81 7D 00 20 7C 69 03 A6 88 0A 00 00 7F 8B 00 40 41 BD 00 14 4B FF FE 60 7C 0A 48 AE 7F 80 58 40 40 BC FE 54 39 29 00 01 42 00 FF F0 3A 60 00 00 3A 5F 00 07 3B 1F 00 0B 81 3E 00 04 7E 59 93 78 80 1E 00 08 7F 89 00 40 40 9C 05 F4 88 69 00 00 39 29 00 01 91 3E 00 04 9C 79 00 01 7F 99 C0 00 40 9E FF E4 7F 80 48 40 40 9D 06 44 38 09 00 01 88 69 00 00 90 1E 00 04 2B 83 00 01 41 BD FD F8 81 3D 00 2C 56 79 18 38 7D 29 CA 14 98 69 00 04 81 3E 00 04 80 1E 00 08 7F 89 00 40 40 9C 06 04 38 09 00 01 88 69 00 00 90 1E 00 04 7F 9A 18 40 41 BC FD C4 81 3D 00 2C 3A 73 00 01 7D 69 CA 14 98 6B 00 05 80 1D 00 20 7F 80 98 40 80 1F 00 08 7C 09 C9 2E 41 9D FF 64 80 75 ?? ?? 38 80 00 01 7F 45 D3 78 7F C6 F3 78 4? ?? ?? ?? 7F 9A 18 00 40 BE FD 84 80 1D 00 24 2F 80 00 00 41 9E 00 98 3A 60 00 00 3A 5F 00 07 3B 1F 00 0B 7E 55 93 78 7E 59 93 78 81 3E 00 04 80 1E 00 08 7F 89 00 40 40 9C 05 6C 38 09 00 01 88 69 00 00 90 1E 00 04 9C 79 00 01 7F 99 C0 00 40 9E FF DC 81 3D 00 30 56 79 18 38 80 1F 00 08 7C 09 C9 2E 81 3E 00 04 80 1E 00 08 7F 89 00 40 40 9C 05 20 38 09 00 01 88 69 00 00 90 1E 00 04 9C 75 00 01 7F 98 A8 00 40 9E FF DC 80 1D 00 24 3A 73 00 01 81 3D 00 30 7F 80 98 40 80 1F 00 08 7F 29 CA 14 90 19 00 04 41 9D FF 7C 2F 97 00 00 41 9E 04 D8 3B 20 00 00 81 3E 00 04 80 1E 00 08 7F 89 00 40 40 9C 05 24 39 69 00 01 88 09 00 00 91 7E 00 04 57 29 18 38 81 7D 00 2C 3B 39 00 01 7F 97 C8 00 7C 00 00 34 54 00 D9 7E 7D 2B 4A 14 68 00 00 01 98 09 00 06 40 9E FF C0 81 7D 00 20 7F 8B C8 40 40 9D 00 28 7D 79 58 50 81 3D 00 2C 7D 69 03 A6 57 20 18 38 7D 29 02 14 38 00 00 00 98 09 00 06 39 29 00 08 42 00 FF F8 2F 96 00 00 41 9E 04 50 3B 20 00 00 81 3E 00 04 80 1E 00 08 7F 89 00 40 40 9C 04 8C 39 69 00 01 88 09 00 00 91 7E 00 04 57 29 18 38 81 7D 00 2C 3B 39 00 01 7F 96 C8 00 7C 00 00 34 54 00 D9 7E 7D 2B 4A 14 68 00 00 01 98 09 00 07 40 9E FF C0 81 7D 00 20 7F 8B C8 40 40 9D 00 28 57 20 18 38 81 3D 00 2C 7F 39 58 50 7F 29 03 A6 7D 29 02 14 38 00 00 00 98 09 00 07 39 29 00 08 42 00 FF F8 88 1F 00 14 2F 80 00 00 40 9E 01 FC 81 3D 00 34 2F 89 00 00 41 9E 00 14 88 09 00 00 2F 80 00 00 40 9E 00 08 90 1D 00 34 7F C3 F3 78 4? ?? ?? ?? 80 1D 00 20 2F 80 00 00 41 9E 00 34 3B C0 00 00 81 3D 00 2C 57 C0 18 38 80 7D 00 00 3B DE 00 01 7D 29 02 14 88 09 00 05 7C 63 02 14 4? ?? ?? ?? 80 1D 00 20 7F 80 F0 40 41 9D FF D8 83 DD 00 1C 3E E0 ?? ?? 38 00 00 00 2F 9E 00 00 90 17 ?? ?? 3B 17 ?? ?? 90 18 00 04 41 9E 00 68 7F 16 C3 78 48 00 00 0C 2F 9E 00 00 41 9E 00 58 81 3D 00 28 3B DE FF FF 80 1D 00 2C 7D 29 F0 AE 55 29 18 38 7D 20 4A 14 8B 89 00 04 57 99 10 3A 7C 18 C8 2E 2F 80 00 00 40 9E FF D0 88 09 00 05 80 7D 00 00 7C 63 02 14 4? ?? ?? ?? 20 1C 00 01 7C 78 C9 2E 54 00 10 3A 7C 16 00 2E 2F 80 00 00 41 9E FF A8 80 17 ?? ?? 2F 80 00 00 41 9E 02 54 80 18 00 04 2F 80 00 00 41 9E 02 38 7F 43 D3 78 4B FF F7 D1 81 5D 00 1C 2F 8A 00 00 40 9E 00 30 81 7D 00 2C 39 20 00 00 80 0B 00 00 90 1D 00 38 90 1D 00 3C 3D 60 ?? ?? 7C 00 00 D0 91 2B ?? ?? 3D 20 ?? ?? 90 09 ?? ?? 4B FF FB 58 38 A0 00 00 7D 49 03 A6 38 00 00 00 81 7D 00 2C 2F 05 00 00 90 1D 00 38 39 20 00 01 90 1D 00 3C 2C 09 00 00 38 C0 00 00 81 1D 00 28 39 2A FF FF 2F 80 00 00 40 9E 00 34 7D 48 48 AE 55 4A 18 38 7C EB 52 14 88 E7 00 04 2C 87 00 00 40 86 00 1C 7C CB 50 2E 40 9A 01 EC 38 00 00 01 42 40 00 44 39 29 FF FF 4B FF FF CC 40 9A 00 2C 7D 48 48 AE 55 4A 18 38 7C EB 52 14 88 E7 00 04 2C 87 00 00 41 86 00 0C 7C AB 50 2E 4F 00 00 00 41 9E FF D0 4B FF FF C4 4F 00 00 00 41 9E FF C4 4B FF FF B8 90 DD 00 3C 90 BD 00 38 40 9A 01 80 7C C0 33 78 90 DD 00 38 39 20 00 00 4B FF FF 30 38 7F 00 10 38 80 00 2C 38 A0 00 01 7F C6 F3 78 4? ?? ?? ?? 2F 83 00 01 40 BE F9 C4 38 7F 00 10 7E 84 A3 78 38 A0 00 04 4? ?? ?? ?? 2F 83 00 00 40 9E F9 AC 80 1F 00 38 7F C3 F3 78 80 9F 00 28 38 A0 00 01 81 7F 00 30 81 5F 00 24 7C 84 02 14 81 3F 00 34 1D 6B 00 09 80 1F 00 2C 7C 84 52 14 1D 29 00 06 7C 84 5A 14 1C 00 00 0C 7C 84 4A 14 7C 84 02 14 4? ?? ?? ?? 2F 83 00 00 40 9E F9 60 7F C3 F3 78 4? ?? ?? ?? 2C 03 00 00 41 A0 F9 50 81 3F 00 70 38 03 00 02 7C 0B FE 70 7F 8B 48 00 81 3F 00 74 41 9D F9 38 40 9E 00 0C 7F 80 48 40 41 9D F9 2C 39 29 FF FF 81 5E 00 08 7F 03 48 50 81 3E 00 04 38 18 00 1E 81 61 00 00 54 00 00 36 7F 89 50 40 7C 00 00 D0 7D 61 01 6E 3B 21 00 17 57 39 00 36 40 9C 01 8C 38 09 00 01 88 69 00 00 90 1E 00 04 2F 83 00 0A 40 9E F8 E4 3A F8 FF FF 7F 23 CB 78 38 80 00 01 7E E5 BB 78 7F C6 F3 78 4? ?? ?? ?? 7F 97 18 00 40 9E F8 C4 38 00 00 00 7F 19 C2 14 98 18 FF FF 7F 23 CB 78 4? ?? ?? ?? 90 7D 00 34 4B FF FC D4 3D 20 ?? ?? 80 09 ?? ?? 90 18 00 04 4B FF FD C0 80 1D 00 20 2F 80 00 01 40 9E 01 00 3D 20 ?? ?? 80 69 ?? ?? 4? ?? ?? ?? 3D 20 ?? ?? 90 69 ?? ?? 4B FF FD 90 7C C9 2A 78 7D 29 00 34 55 29 D9 7E 7C C0 33 78 69 29 00 01 4B FF FD AC 7C A9 32 78 90 DD 00 3C 7D 29 00 34 55 29 D9 7E 90 BD 00 38 7C C0 33 78 69 29 00 01 4B FF FD 8C 7F C3 F3 78 4? ?? ?? ?? 2F 83 FF FF 41 9E F8 2C 81 3E 00 04 80 1E 00 08 4B FF FA 04 80 1D 00 20 2F 80 00 00 41 9E FA 78 4B FF F9 C8 3B 20 00 00 4B FF FB F8 3B 20 00 00 4B FF FB 70 7F C3 F3 78 4? ?? ?? ?? 2F 83 FF FF 41 9E F7 F0 4B FF FA E0 7F C3 F3 78 4? ?? ?? ?? 2F 83 FF FF 41 9E F7 DC 4B FF FA 94 7F C3 F3 78 4? ?? ?? ?? 4B FF FA 04 7F C3 F3 78 4? ?? ?? ?? 4B FF F9 C4 7F C3 F3 78 4? ?? ?? ?? 2F 83 FF FF 7C 60 1B 78 41 9E F7 AC 4B FF FB 70 7F C3 F3 78 4? ?? ?? ?? 2F 83 FF FF 7C 60 1B 78 40 9E FA DC 4B FF F7 90 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 01 C8 38 C6 ?? ?? 4? ?? ?? ?? 7F C3 F3 78 4? ?? ?? ?? 4B FF FE 7C }
	condition:
		$1
}

rule file_28_2_0 {
	meta:
		name = "__tzfile_default"
		size = 556
		refs = "0040 strlen 0068 __tzfile_read 006e __use_tzfile 009c mempcpy 00a8 memcpy 0172 __tzname 01ae __timezone"
	strings:
		$1 = { 94 21 FF C0 7C 08 02 A6 93 01 00 20 7C D8 33 78 90 01 00 44 93 21 00 24 93 41 00 28 93 61 00 2C 93 A1 00 34 7C 7D 1B 78 93 C1 00 38 7C BE 2B 78 93 E1 00 3C 7C 9F 23 78 92 E1 00 1C 93 81 00 30 4? ?? ?? ?? 3B 63 00 01 7F E3 FB 78 4? ?? ?? ?? 38 A1 00 08 3B 23 00 01 7F 59 DA 14 3C 60 ?? ?? 38 63 ?? ?? 7F 44 D3 78 4? ?? ?? ?? 3D 20 ?? ?? 80 09 ?? ?? 2F 80 00 00 41 9E 01 44 3E E0 ?? ?? 3B 97 ?? ?? 80 1C 00 20 2B 80 00 01 40 9D 01 64 80 61 00 08 7F A4 EB 78 7F 65 DB 78 4? ?? ?? ?? 7F E4 FB 78 7F 25 CB 78 4? ?? ?? ?? 81 3C 00 1C 80 01 00 08 2F 89 00 00 90 17 ?? ?? 38 00 00 02 90 1C 00 20 41 9E 00 A4 80 9C 00 38 3D 60 ?? ?? 80 BC 00 3C 39 40 00 00 80 CB ?? ?? 7C 84 C0 50 80 FC 00 2C 7C A5 F0 50 81 1C 00 28 38 00 00 00 39 60 00 00 7D 29 03 A6 48 00 00 2C 88 09 00 06 2F 80 00 00 40 9E 00 48 7C 06 50 2E 7C 00 22 14 7C 06 51 2E 39 6B 00 01 88 09 00 04 39 4A 00 04 42 40 00 48 7D 28 58 AE 2F 00 00 00 55 29 18 38 7D 27 4A 14 88 09 00 04 7C 08 59 AE 88 09 00 07 2F 80 00 00 40 BE FF D0 40 BA FF B4 7C 06 50 2E 39 6B 00 01 7C 00 2A 14 7C 06 51 2E 39 4A 00 04 88 09 00 04 42 00 FF C0 81 1C 00 2C 38 00 00 00 3D 20 ?? ?? 93 DC 00 3C 39 68 00 08 98 08 00 04 39 49 ?? ?? 7F 43 D3 78 98 08 00 05 7C 1E 00 D0 93 C8 00 00 93 08 00 08 9B 68 00 0D 39 00 00 01 99 0B 00 04 93 EA 00 04 93 A9 ?? ?? 3D 20 ?? ?? 93 1C 00 38 90 09 ?? ?? 4B FF F2 A5 80 01 00 44 82 E1 00 1C 7C 08 03 A6 83 01 00 20 83 21 00 24 83 41 00 28 83 61 00 2C 83 81 00 30 83 A1 00 34 83 C1 00 38 83 E1 00 3C 38 21 00 40 4E 80 00 20 38 00 00 00 82 E1 00 1C 90 09 ?? ?? 80 01 00 44 83 01 00 20 7C 08 03 A6 83 21 00 24 83 41 00 28 83 61 00 2C 83 81 00 30 83 A1 00 34 83 C1 00 38 83 E1 00 3C 38 21 00 40 4E 80 00 20 }
	condition:
		$1
}

rule file_28_3_0 {
	meta:
		name = "__tzfile_compute"
		size = 1820
		refs = "0106 __tzname 01d8 __tzstring 0282 __daylight 02a6 __timezone 02e4 strcmp 0524 __assert_fail 0554 __tzset_parse_tz 0564 __offtime 057c __tz_compute 05b8 strlen"
	strings:
		$1 = { 2F 84 00 00 94 21 FF C0 7C 08 02 A6 93 61 00 2C 7C FB 3B 78 93 C1 00 38 7C DE 33 78 93 E1 00 3C 7C BF 2B 78 90 01 00 44 92 81 00 10 92 A1 00 14 92 C1 00 18 92 E1 00 1C 93 01 00 20 93 21 00 24 93 41 00 28 93 81 00 30 93 A1 00 34 90 61 00 08 40 9E 00 A8 3F A0 ?? ?? 3B BD ?? ?? 38 00 00 00 80 FD 00 30 90 1F 00 00 90 1E 00 00 81 7D 00 24 81 01 00 08 38 0B 00 01 7C 09 03 A6 55 69 18 38 39 29 FF F8 7D 27 4A 14 42 40 00 30 80 09 00 00 7D 2A 4B 78 39 6B FF FF 7F 80 40 00 39 29 FF F8 41 9D FF E8 80 0A 00 04 90 1F 00 00 80 0A 00 00 7F 88 00 00 41 9E 02 4C 80 01 00 44 82 81 00 10 7C 08 03 A6 82 A1 00 14 82 C1 00 18 82 E1 00 1C 83 01 00 20 83 21 00 24 83 41 00 28 83 61 00 2C 83 81 00 30 83 A1 00 34 83 C1 00 38 83 E1 00 3C 38 21 00 40 4E 80 00 20 3F 20 ?? ?? 3B B9 ?? ?? 81 7D 00 1C 3F 40 ?? ?? 38 00 00 00 2F 8B 00 00 90 1A ?? ?? 3B 9A ?? ?? 90 1C 00 04 41 9E 04 C8 3D 20 ?? ?? 81 29 ?? ?? 80 09 00 00 7F 80 18 00 41 9D 04 B4 39 4B FF FF 55 40 10 3A 7C 09 00 2E 7F 83 00 00 40 9C 04 04 3F 00 88 1A 7C 03 00 50 63 18 22 EF 7F 00 C0 96 7C 08 FE 70 7F 18 02 14 7F 18 BE 70 7F 08 C0 50 7F 8B C0 40 39 00 00 00 41 9D 02 68 38 E8 00 01 7F 8A 38 40 40 9D 00 30 7C 0A 42 14 54 00 F8 7E 54 0B 10 3A 7D 69 58 2E 7F 83 58 00 41 9C 00 0C 7C 08 03 78 4B FF FF D8 7C 0A 03 78 7F 8A 38 40 41 9D FF D8 3A AA FF FF 7D 58 53 78 81 7D 00 28 81 3D 00 2C 7C 0B A8 AE 80 79 ?? ?? 54 00 18 38 7D 29 02 14 88 09 00 05 8A E9 00 04 7C 63 02 14 4? ?? ?? ?? 81 3D 00 1C 56 E0 10 3A 7F 98 48 40 7C 7C 01 2E 40 9C 03 14 81 7D 00 28 7F 94 E3 78 48 00 00 14 80 1D 00 1C 3B 18 00 01 7F 80 C0 40 40 9D 00 64 7D 2B C0 AE 80 1D 00 2C 55 29 18 38 7D 20 4A 14 8A E9 00 04 89 29 00 05 56 F6 10 3A 7C 1C B0 2E 2F 80 00 00 40 9E FF CC 80 7D 00 00 22 F7 00 01 56 F7 10 3A 7C 63 4A 14 4? ?? ?? ?? 7C 7C B1 2E 7C 14 B8 2E 2F 80 00 00 40 9E 02 AC 80 1D 00 1C 3B 18 00 01 81 7D 00 28 7F 80 C0 40 41 9D FF A4 80 1A ?? ?? 2F 80 00 00 41 9E 03 5C 7E EB A8 AE 81 3D 00 3C 3D 60 ?? ?? 80 1D 00 38 83 1D 00 2C 7D 20 02 78 7C 00 00 34 54 00 D9 7E 68 00 00 01 7D 29 00 D0 90 0B ?? ?? 3D 60 ?? ?? 91 2B ?? ?? 41 9E 02 34 80 1C 00 04 2F 80 00 00 41 9E 02 18 56 FA 18 38 80 79 ?? ?? 7D 38 D2 14 88 09 00 04 90 1B 00 20 54 00 10 3A 7F 9C 00 2E 88 09 00 05 7F 84 E3 78 7C 63 02 14 4? ?? ?? ?? 2F 83 00 00 40 9E 02 3C 7C 18 D0 2E 93 9B 00 28 90 1B 00 24 4B FF FD 60 2F 8B 00 00 41 9E 01 40 81 2A 00 04 39 0B FF FF 55 08 18 38 7D 47 42 14 81 4A 00 04 7F 0A 48 00 40 B8 FD 98 38 C0 00 01 90 DE 00 00 41 BE FD 8C 7D 07 40 2E 39 08 00 01 7F 88 00 00 40 BE FD 7C 39 4A 00 01 7F 8A 48 00 40 BE FD 70 55 69 18 38 7D 69 03 A6 7D 27 4A 14 39 40 00 01 48 00 00 30 81 09 FF F0 81 69 FF F8 38 08 00 01 7F 8B 00 00 40 9E 00 24 81 09 FF F4 81 69 FF FC 39 29 FF F8 38 08 00 01 7F 8B 00 00 40 9E 00 0C 39 4A 00 01 42 00 FF D0 80 01 00 44 91 5E 00 00 7C 08 03 A6 82 81 00 10 82 A1 00 14 82 C1 00 18 82 E1 00 1C 83 01 00 20 83 21 00 24 83 41 00 28 83 61 00 2C 83 81 00 30 83 A1 00 34 83 C1 00 38 83 E1 00 3C 38 21 00 40 4E 80 00 20 7F 18 50 50 57 00 10 3A 7C E9 00 2E 7C 09 02 14 7F 83 38 00 40 9C 00 AC 2B 98 00 09 40 9D 00 18 39 58 FF F6 55 40 10 3A 7C 09 00 2E 7F 83 00 00 41 BC FD 6C 39 78 FF FF 55 60 10 3A 7D 49 00 2E 7D 75 5B 78 7D 29 02 14 7F 83 50 00 40 BC FD 90 84 09 FF FC 7D 78 5B 78 39 6B FF FF 7F 83 00 00 7D 75 5B 78 41 9C FF EC 4B FF FD 74 81 2A 00 04 2F 09 00 00 40 B9 FE C0 38 00 00 01 82 81 00 10 90 1E 00 00 80 01 00 44 82 A1 00 14 7C 08 03 A6 82 C1 00 18 82 E1 00 1C 83 01 00 20 83 21 00 24 83 41 00 28 83 61 00 2C 83 81 00 30 83 A1 00 34 83 C1 00 38 83 E1 00 3C 38 21 00 40 4E 80 00 20 39 18 00 0A 7F 8B 40 40 40 9D 00 14 55 0B 10 3A 7D 69 58 2E 7F 83 58 00 40 BC FC C4 7C 09 03 78 84 09 00 04 3B 18 00 01 7F 83 00 00 40 9C FF F4 3A B8 FF FF 4B FF FC E8 3D 20 ?? ?? 80 09 ?? ?? 90 1C 00 04 4B FF FD E0 80 1D 00 20 2F 80 00 01 40 9E 00 20 3D 20 ?? ?? 80 69 ?? ?? 4? ?? ?? ?? 90 7A ?? ?? 4B FF FD B4 81 7D 00 28 4B FF FD 68 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 02 F3 38 C6 ?? ?? 4? ?? ?? ?? 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 02 FA 38 C6 ?? ?? 4? ?? ?? ?? 80 7D 00 34 2F 83 00 00 41 9E 01 98 4? ?? ?? ?? 38 61 00 08 38 80 00 00 7F 65 DB 78 4? ?? ?? ?? 2F 83 00 00 41 9E 01 7C 80 61 00 08 7F 64 DB 78 38 A0 00 01 4? ?? ?? ?? 81 3D 00 24 80 7D 00 30 55 29 18 38 80 19 ?? ?? 7C 63 4A 14 7F 83 00 00 40 9E FA C4 80 1D 00 20 2F 80 00 02 40 9E 01 24 4? ?? ?? ?? 83 79 ?? ?? 90 7A ?? ?? 7F 63 DB 78 4? ?? ?? ?? 38 63 00 01 7C 7B 1A 14 4? ?? ?? ?? 90 7C 00 04 4B FF FA 90 80 1C 00 04 3D 20 ?? ?? 2F 80 00 00 90 09 ?? ?? 4B FF FC 98 3A E0 00 00 80 1D 00 20 7F 97 00 40 40 9C 00 4C 81 7D 00 2C 56 E9 18 38 7D 2B 4A 14 89 69 00 04 2F 8B 00 00 41 9E 00 34 80 1C 00 04 2F 80 00 00 41 9E 00 0C 3A F7 00 01 4B FF FF CC 88 09 00 05 3A F7 00 01 80 7D 00 00 7C 63 02 14 4? ?? ?? ?? 90 7C 00 04 4B FF FF B0 7F 97 00 00 40 BE 00 08 3A E0 00 00 81 3D 00 2C 56 F8 18 38 80 79 ?? ?? 7D 29 C2 14 88 09 00 05 7C 63 02 14 4? ?? ?? ?? 81 3C 00 04 7C 60 1B 78 90 7A ?? ?? 2F 09 00 00 2F 83 00 00 40 9A FC 04 81 7D 00 20 81 5D 00 2C 7F 97 58 40 7D 37 58 50 7F 0A C2 14 39 29 00 01 41 9D 00 80 2F 8B 00 00 40 BE 00 1C 48 00 00 74 89 58 00 04 7F 0B C3 78 3B 18 00 08 2F 8A 00 00 40 9E 00 40 35 29 FF FF 40 82 FF E8 2F 80 00 00 4B FF FB B8 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 02 95 38 C6 ?? ?? 4? ?? ?? ?? 83 1D 00 1C 3A B8 FF FF 4B FF FA C4 88 0B 00 05 80 79 ?? ?? 7C 63 02 14 4? ?? ?? ?? 80 1A ?? ?? 90 7C 00 04 2F 80 00 00 4B FF FB 6C 39 20 00 01 4B FF FF A0 }
	condition:
		$1
}

rule file_29_0_0 {
	meta:
		name = "fgetpwent"
		size = 512
		refs = "003c _IO_new_fgetpos 008a _GLOBAL_OFFSET_TABLE_ 0092 __libc_errno 00c0 __fgetpwent_r 00e0 realloc 00f8 _IO_new_fsetpos 018c free 01b8 malloc 01d4 __lll_lock_wait_private"
	strings:
		$1 = { 94 21 FF C0 7C 08 02 A6 38 81 00 0C 90 01 00 44 93 81 00 30 7C 7C 1B 78 92 C1 00 18 92 E1 00 1C 93 01 00 20 93 21 00 24 93 41 00 28 93 61 00 2C 93 A1 00 34 93 C1 00 38 93 E1 00 3C 4? ?? ?? ?? 7C 60 1B 79 38 60 00 00 40 82 01 04 3F 00 ?? ?? 3B B8 ?? ?? 39 60 00 01 7D 20 E8 28 7C 09 00 00 40 82 00 0C 7D 60 E9 2D 40 A2 FF F0 4C 00 01 2C 2F 89 00 00 40 9E 01 5C 3F 40 ?? ?? 80 BA ?? ?? 2F 85 00 00 41 9E 01 24 3F E0 ?? ?? 3B FF ?? ?? 83 3F ?? ?? 3B 7D 00 08 3B DA ?? ?? 7F 39 12 14 48 00 00 0C 80 BE 00 00 2F 85 00 00 38 E1 00 08 7F 64 DB 78 7F 83 E3 78 41 9E 00 54 80 DD 00 04 4? ?? ?? ?? 2F 83 00 22 40 9E 00 D0 81 3D 00 04 80 7E 00 00 38 09 04 00 7C 04 03 78 90 1D 00 04 4? ?? ?? ?? 7C 77 1B 79 41 82 00 9C 92 FE 00 00 7F 83 E3 78 38 81 00 0C 4? ?? ?? ?? 2F 83 00 00 41 9E FF A4 38 00 00 00 90 1E 00 00 38 00 00 00 90 01 00 08 81 3F ?? ?? 7D 29 12 14 83 C9 00 00 38 00 00 00 7C 00 04 AC 7D 20 E8 28 7C 00 E9 2D 40 A2 FF F8 2F 89 00 01 41 9D 00 A4 83 FF ?? ?? 80 61 00 08 7F FF 12 14 93 DF 00 00 80 01 00 44 82 C1 00 18 7C 08 03 A6 82 E1 00 1C 83 01 00 20 83 21 00 24 83 41 00 28 83 61 00 2C 83 81 00 30 83 A1 00 34 83 C1 00 38 83 E1 00 3C 38 21 00 40 4E 80 00 20 82 D9 00 00 80 7E 00 00 4? ?? ?? ?? 92 D9 00 00 4B FF FF 58 80 1A ?? ?? 2F 80 00 00 40 9E FF 74 4B FF FF 68 38 00 04 00 38 60 04 00 90 1D 00 04 3F E0 ?? ?? 4? ?? ?? ?? 7C 65 1B 78 90 7A ?? ?? 2F 83 00 00 3B FF ?? ?? 4B FF FE C4 7F A3 EB 78 4? ?? ?? ?? 4B FF FE A0 80 82 8B 68 38 00 00 DD 7F A3 EB 78 60 84 00 01 38 A0 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF 40 }
	condition:
		$1
}

rule file_438_0_0 {
	meta:
		name = "fgetsgent"
		size = 512
		refs = "003c _IO_new_fgetpos 008a _GLOBAL_OFFSET_TABLE_ 0092 __libc_errno 00c0 __fgetsgent_r 00e0 realloc 00f8 _IO_new_fsetpos 018c free 01b8 malloc 01d4 __lll_lock_wait_private"
	strings:
		$1 = { 94 21 FF C0 7C 08 02 A6 38 81 00 0C 90 01 00 44 93 81 00 30 7C 7C 1B 78 92 C1 00 18 92 E1 00 1C 93 01 00 20 93 21 00 24 93 41 00 28 93 61 00 2C 93 A1 00 34 93 C1 00 38 93 E1 00 3C 4? ?? ?? ?? 7C 60 1B 79 38 60 00 00 40 82 01 04 3F 00 ?? ?? 3B B8 ?? ?? 39 60 00 01 7D 20 E8 28 7C 09 00 00 40 82 00 0C 7D 60 E9 2D 40 A2 FF F0 4C 00 01 2C 2F 89 00 00 40 9E 01 5C 3F 40 ?? ?? 80 BA ?? ?? 2F 85 00 00 41 9E 01 24 3F E0 ?? ?? 3B FF ?? ?? 83 3F ?? ?? 3B 7D 00 08 3B DA ?? ?? 7F 39 12 14 48 00 00 0C 80 BE 00 00 2F 85 00 00 38 E1 00 08 7F 64 DB 78 7F 83 E3 78 41 9E 00 54 80 DD 00 04 4? ?? ?? ?? 2F 83 00 22 40 9E 00 D0 81 3D 00 04 80 7E 00 00 38 09 04 00 7C 04 03 78 90 1D 00 04 4? ?? ?? ?? 7C 77 1B 79 41 82 00 9C 92 FE 00 00 7F 83 E3 78 38 81 00 0C 4? ?? ?? ?? 2F 83 00 00 41 9E FF A4 38 00 00 00 90 1E 00 00 38 00 00 00 90 01 00 08 81 3F ?? ?? 7D 29 12 14 83 C9 00 00 38 00 00 00 7C 00 04 AC 7D 20 E8 28 7C 00 E9 2D 40 A2 FF F8 2F 89 00 01 41 9D 00 A4 83 FF ?? ?? 80 61 00 08 7F FF 12 14 93 DF 00 00 80 01 00 44 82 C1 00 18 7C 08 03 A6 82 E1 00 1C 83 01 00 20 83 21 00 24 83 41 00 28 83 61 00 2C 83 81 00 30 83 A1 00 34 83 C1 00 38 83 E1 00 3C 38 21 00 40 4E 80 00 20 82 D9 00 00 80 7E 00 00 4? ?? ?? ?? 92 D9 00 00 4B FF FF 58 80 1A ?? ?? 2F 80 00 00 40 9E FF 74 4B FF FF 68 38 00 04 00 38 60 04 00 90 1D 00 04 3F E0 ?? ?? 4? ?? ?? ?? 7C 65 1B 78 90 7A ?? ?? 2F 83 00 00 3B FF ?? ?? 4B FF FE C4 7F A3 EB 78 4? ?? ?? ?? 4B FF FE A0 80 82 8B 68 38 00 00 DD 7F A3 EB 78 60 84 00 01 38 A0 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF 40 }
	condition:
		$1
}

rule file_842_0_0 {
	meta:
		name = "fgetspent"
		size = 512
		refs = "003c _IO_new_fgetpos 008a _GLOBAL_OFFSET_TABLE_ 0092 __libc_errno 00c0 __fgetspent_r 00e0 realloc 00f8 _IO_new_fsetpos 018c free 01b8 malloc 01d4 __lll_lock_wait_private"
	strings:
		$1 = { 94 21 FF C0 7C 08 02 A6 38 81 00 0C 90 01 00 44 93 81 00 30 7C 7C 1B 78 92 C1 00 18 92 E1 00 1C 93 01 00 20 93 21 00 24 93 41 00 28 93 61 00 2C 93 A1 00 34 93 C1 00 38 93 E1 00 3C 4? ?? ?? ?? 7C 60 1B 79 38 60 00 00 40 82 01 04 3F 00 ?? ?? 3B B8 ?? ?? 39 60 00 01 7D 20 E8 28 7C 09 00 00 40 82 00 0C 7D 60 E9 2D 40 A2 FF F0 4C 00 01 2C 2F 89 00 00 40 9E 01 5C 3F 40 ?? ?? 80 BA ?? ?? 2F 85 00 00 41 9E 01 24 3F E0 ?? ?? 3B FF ?? ?? 83 3F ?? ?? 3B 7D 00 08 3B DA ?? ?? 7F 39 12 14 48 00 00 0C 80 BE 00 00 2F 85 00 00 38 E1 00 08 7F 64 DB 78 7F 83 E3 78 41 9E 00 54 80 DD 00 04 4? ?? ?? ?? 2F 83 00 22 40 9E 00 D0 81 3D 00 04 80 7E 00 00 38 09 04 00 7C 04 03 78 90 1D 00 04 4? ?? ?? ?? 7C 77 1B 79 41 82 00 9C 92 FE 00 00 7F 83 E3 78 38 81 00 0C 4? ?? ?? ?? 2F 83 00 00 41 9E FF A4 38 00 00 00 90 1E 00 00 38 00 00 00 90 01 00 08 81 3F ?? ?? 7D 29 12 14 83 C9 00 00 38 00 00 00 7C 00 04 AC 7D 20 E8 28 7C 00 E9 2D 40 A2 FF F8 2F 89 00 01 41 9D 00 A4 83 FF ?? ?? 80 61 00 08 7F FF 12 14 93 DF 00 00 80 01 00 44 82 C1 00 18 7C 08 03 A6 82 E1 00 1C 83 01 00 20 83 21 00 24 83 41 00 28 83 61 00 2C 83 81 00 30 83 A1 00 34 83 C1 00 38 83 E1 00 3C 38 21 00 40 4E 80 00 20 82 D9 00 00 80 7E 00 00 4? ?? ?? ?? 92 D9 00 00 4B FF FF 58 80 1A ?? ?? 2F 80 00 00 40 9E FF 74 4B FF FF 68 38 00 04 00 38 60 04 00 90 1D 00 04 3F E0 ?? ?? 4? ?? ?? ?? 7C 65 1B 78 90 7A ?? ?? 2F 83 00 00 3B FF ?? ?? 4B FF FE C4 7F A3 EB 78 4? ?? ?? ?? 4B FF FE A0 80 82 8B 68 38 00 00 DD 7F A3 EB 78 60 84 00 01 38 A0 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF 40 }
	condition:
		$1
}

rule file_30_0_0 {
	meta:
		name = "__getclktck"
		size = 24
		refs = "0002 _dl_clktck"
	strings:
		$1 = { 3D 20 ?? ?? 80 69 ?? ?? 2F 83 00 00 4C BE 00 20 38 60 00 64 4E 80 00 20 }
	condition:
		$1
}

rule file_31_0_0 {
	meta:
		name = "__libc_pause"
		size = 108
		refs = "0018 __syscall_error 0028 __libc_enable_asynccancel 0048 __libc_disable_asynccancel"
		altNames = "pause"
	strings:
		$1 = { 81 42 8B 60 2C 0A 00 00 40 82 00 14 38 00 00 1D 44 00 00 02 4C A3 00 20 4? ?? ?? ?? 94 21 FF D0 7D 28 02 A6 91 21 00 34 4? ?? ?? ?? 90 61 00 10 38 00 00 1D 44 00 00 02 7C 00 00 26 90 61 00 08 90 01 00 0C 80 61 00 10 4? ?? ?? ?? 80 81 00 34 80 01 00 0C 80 61 00 08 7C 88 03 A6 7C 0F F1 20 38 21 00 30 4C A3 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_4_0_3 {
	meta:
		name = "__libc_pause"
		size = 108
		refs = "0018 __syscall_error 0028 __pthread_enable_asynccancel 0048 __pthread_disable_asynccancel"
	strings:
		$1 = { 81 42 8B 60 2C 0A 00 00 40 82 00 14 38 00 00 1D 44 00 00 02 4C A3 00 20 4? ?? ?? ?? 94 21 FF D0 7D 28 02 A6 91 21 00 34 4? ?? ?? ?? 90 61 00 10 38 00 00 1D 44 00 00 02 7C 00 00 26 90 61 00 08 90 01 00 0C 80 61 00 10 4? ?? ?? ?? 80 81 00 34 80 01 00 0C 80 61 00 08 7C 88 03 A6 7C 0F F1 20 38 21 00 30 4C A3 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_4_2_3 {
	meta:
		name = "pause"
		size = 108
		refs = "0018 __syscall_error 0028 __pthread_enable_asynccancel 0048 __pthread_disable_asynccancel"
	strings:
		$1 = { 81 42 8B 60 2C 0A 00 00 40 82 00 14 38 00 00 1D 44 00 00 02 4C A3 00 20 4? ?? ?? ?? 94 21 FF D0 7D 28 02 A6 91 21 00 34 4? ?? ?? ?? 90 61 00 10 38 00 00 1D 44 00 00 02 7C 00 00 26 90 61 00 08 90 01 00 0C 80 61 00 10 4? ?? ?? ?? 80 81 00 34 80 01 00 0C 80 61 00 08 7C 88 03 A6 7C 0F F1 20 38 21 00 30 4C A3 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_31_1_0 {
	meta:
		name = "__pause_nocancel"
		size = 16
		refs = "000c __syscall_error"
	strings:
		$1 = { 38 00 00 1D 44 00 00 02 4C A3 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_32_0_0 {
	meta:
		name = "getsubopt"
		size = 392
		refs = "0058 __strchrnul 006c memchr 0098 strncmp"
	strings:
		$1 = { 94 21 FF D0 7C 08 02 A6 90 01 00 34 92 E1 00 0C 7C B7 2B 78 93 21 00 14 7C 79 1B 78 93 61 00 1C 93 A1 00 24 7C 9D 23 78 93 C1 00 28 3B C0 FF FF 93 01 00 10 93 41 00 18 93 81 00 20 93 E1 00 2C 83 63 00 00 88 1B 00 00 2F 80 00 00 41 9E 00 98 38 80 00 2C 7F 63 DB 78 4? ?? ?? ?? 38 80 00 3D 7C 7A 1B 78 7C BB D0 50 7F 63 DB 78 4? ?? ?? ?? 7C 78 1B 79 41 82 01 0C 83 FD 00 00 2F 9F 00 00 41 9E 00 40 7F 9B C0 50 3B C0 00 00 7F E4 FB 78 7F 63 DB 78 7F 85 E3 78 4? ?? ?? ?? 2F 83 00 00 40 9E 00 10 7C 1F E0 AE 2F 80 00 00 41 9E 00 70 87 FD 00 04 3B DE 00 01 2F 9F 00 00 40 9E FF D0 93 77 00 00 88 1A 00 00 2F 80 00 00 41 9E 00 10 38 00 00 00 98 1A 00 00 3B 5A 00 01 93 59 00 00 3B C0 FF FF 80 01 00 34 7F C3 F3 78 82 E1 00 0C 7C 08 03 A6 83 01 00 10 83 21 00 14 83 41 00 18 83 61 00 1C 83 81 00 20 83 A1 00 24 83 C1 00 28 83 E1 00 2C 38 21 00 30 4E 80 00 20 7F 98 D0 00 41 9E 00 08 38 18 00 01 90 17 00 00 88 1A 00 00 2F 80 00 00 41 9E 00 10 38 00 00 00 98 1A 00 00 3B 5A 00 01 80 01 00 34 7F C3 F3 78 93 59 00 00 7C 08 03 A6 82 E1 00 0C 83 01 00 10 83 21 00 14 83 41 00 18 83 61 00 1C 83 81 00 20 83 A1 00 24 83 C1 00 28 83 E1 00 2C 38 21 00 30 4E 80 00 20 7F 58 D3 78 4B FF FE F4 }
	condition:
		$1
}

rule file_33_0_0 {
	meta:
		name = "day_of_the_week"
		size = 228
		refs = "001e __mon_yday"
	strings:
		$1 = { 81 23 00 10 3D 40 51 EB 81 03 00 14 61 4A 85 1F 2F 89 00 01 80 83 00 0C 39 68 07 6C 3C C0 ?? ?? 4F DD E8 42 55 29 08 3C 1D 08 01 6D 7C 00 00 26 54 00 FF FE 38 C6 ?? ?? 7C 00 58 50 7C C6 4A 2E 7C 0B 16 70 7D 6B 01 94 7C EB 50 96 7D 40 50 96 7D 65 FE 70 38 84 9A 58 7C E7 1E 70 7D 04 42 14 7C E5 38 50 7C 00 FE 70 7D 49 2E 70 7D 08 32 14 1C E7 00 19 7D 08 5A 14 7D 29 00 50 7D 4A 3E 70 7C 00 50 50 7D 28 4A 14 7D 67 58 50 7D 29 02 14 55 6B 0F FE 7D 29 5A 14 3D 60 92 49 61 6B 24 93 7C 09 58 96 7D 2A FE 70 7C 00 4A 14 7C 00 16 70 7C 0A 00 50 1C 00 00 07 7D 20 48 50 38 09 00 07 7D 20 58 96 7C 0A FE 70 7D 29 02 14 7D 29 16 70 7D 2A 48 50 1D 29 00 07 7C 09 00 50 90 03 00 18 4E 80 00 20 }
	condition:
		$1
}

rule file_33_1_0 {
	meta:
		name = "__strptime_internal"
		size = 12316
		refs = "009c memcpy 00be _nl_C_LC_TIME 03c4 __strptime_internal 0680 __localtime_r 0738 strlen 0750 __strncasecmp_l 0774 strcmp 16fa __mon_yday 1928 _nl_parse_alt_digit 1efc _nl_select_era_entry 2e08 __assert_fail"
	strings:
		$1 = { 7D 80 00 26 2E 06 00 00 94 21 FF 20 7C 08 02 A6 90 01 00 E4 93 21 00 C4 7C B9 2B 78 93 41 00 C8 7C DA 33 78 93 61 00 CC 93 C1 00 D8 7C FE 3B 78 93 E1 00 DC 7C 9F 23 78 91 C1 00 98 91 E1 00 9C 92 01 00 A0 92 21 00 A4 92 41 00 A8 92 61 00 AC 92 81 00 B0 92 A1 00 B4 92 C1 00 B8 92 E1 00 BC 93 01 00 C0 93 81 00 D0 93 A1 00 D4 91 81 00 94 90 61 00 48 83 67 00 08 41 92 02 E8 81 26 00 00 7C A4 2B 78 81 46 00 04 38 61 00 14 38 A0 00 2C 91 21 00 0C 3B 81 00 14 91 41 00 10 4? ?? ?? ?? 3F 00 ?? ?? 3E C0 AA AA 3E 20 ?? ?? 3E 40 ?? ?? 3E A0 88 88 3B 18 ?? ?? 62 D6 AA AB 3E E0 ?? ?? 3A 31 ?? ?? 3A 52 ?? ?? 3E 60 ?? ?? 3E 80 ?? ?? 62 B5 88 89 88 1F 00 00 2F 80 00 00 41 9E 02 58 81 5E 00 34 54 09 08 3C 7D 2A 4A 2E 71 25 00 20 41 82 00 40 81 21 00 48 88 09 00 00 54 00 08 3C 7C 0A 02 2E 70 06 00 20 41 82 00 20 39 29 00 01 91 21 00 48 88 09 00 00 54 00 08 3C 7C 0A 02 2E 70 0B 00 20 40 82 FF E8 3B FF 00 01 4B FF FF A8 2F 80 00 25 41 9E 00 80 81 21 00 48 89 69 00 00 39 29 00 01 91 21 00 48 7F 80 58 00 41 BE FF DC 38 60 00 00 80 01 00 E4 81 81 00 94 7C 08 03 A6 81 C1 00 98 81 E1 00 9C 7D 80 81 20 82 01 00 A0 82 21 00 A4 82 41 00 A8 82 61 00 AC 82 81 00 B0 82 A1 00 B4 82 C1 00 B8 82 E1 00 BC 83 01 00 C0 83 21 00 C4 83 41 00 C8 83 61 00 CC 83 81 00 D0 83 A1 00 D4 83 C1 00 D8 83 E1 00 DC 38 21 00 E0 4E 80 00 20 39 7F 00 01 41 92 01 74 89 2B 00 00 2F 89 00 30 41 9E 00 64 2B 89 00 30 41 9D 00 50 2F 89 00 23 41 9E 00 54 2F 89 00 2D 40 BE 00 0C 48 00 00 48 8D 2B 00 01 38 09 FF D0 54 00 06 3E 2B 80 00 09 40 9D FF F0 39 29 FF DB 83 A1 00 48 55 29 06 3E 2B 89 00 55 3B EB 00 01 7F AB EB 78 40 9D 00 20 38 60 00 00 4B FF FF 3C 38 09 FF A2 2B 80 00 01 41 BD FF C4 39 6B 00 01 4B FF FF 90 55 29 10 3A 7C 18 48 2E 7C 00 C2 14 7C 09 03 A6 4E 80 04 20 3B BD 00 01 93 A1 00 48 89 3D 00 00 2F 89 00 20 41 9E FF F0 39 29 FF D0 55 20 06 3E 2B 80 00 09 41 9D 29 D4 39 7D 00 01 91 61 00 48 1D 49 00 0A 88 1D 00 01 2B 80 00 2F 40 9D 00 1C 2B 80 00 39 41 9D 00 14 39 7D 00 02 7D 20 52 14 91 61 00 48 39 29 FF D0 2B 89 00 44 41 9D 00 08 39 29 00 64 91 3C 00 14 39 20 00 01 80 01 00 0C 64 00 00 80 51 20 AA 94 90 01 00 0C 4B FF FE 18 3B BD 00 01 93 A1 00 48 89 3D 00 00 2F 89 00 20 41 9E FF F0 38 09 FF D0 54 09 06 3E 2B 89 00 09 41 9D 29 E0 39 7D 00 01 91 61 00 48 1D 40 00 0A 89 3D 00 01 2B 89 00 2F 40 9D 00 1C 2B 89 00 39 41 9D 00 14 39 7D 00 02 7D 29 52 14 91 61 00 48 38 09 FF D0 98 01 00 0F 80 01 00 0C 39 20 00 01 51 20 AA 94 90 01 00 0C 4B FF FD AC 89 3F 00 01 4B FF FE C8 41 92 12 00 81 21 00 0C 7F 23 CB 78 81 41 00 10 38 81 00 14 91 3A 00 00 38 A0 00 2C 91 5A 00 04 4? ?? ?? ?? 80 61 00 48 4B FF FD F8 38 00 FF FF 90 C1 00 0C 7C BC 2B 78 98 01 00 0F 38 00 FF FF 90 01 00 10 4B FF FD 28 80 01 00 0C 54 0B 02 D8 3D 20 00 08 7F 8B 48 00 41 9E 28 DC 39 20 00 02 93 A1 00 48 51 20 9A D8 90 01 00 0C 39 37 ?? ?? 80 89 00 CC 88 04 00 00 2F 80 00 00 41 9E 29 18 80 61 00 48 7F 85 E3 78 38 C1 00 0C 7F C7 F3 78 4? ?? ?? ?? 2F 83 00 00 90 61 00 48 40 9E FD 04 38 60 00 00 4B FF FD 7C 80 01 00 0C 54 0B 02 D8 3D 20 00 08 7F 8B 48 00 41 9E 28 C4 39 20 00 02 93 A1 00 48 51 20 9A D8 90 01 00 0C 39 37 ?? ?? 80 89 00 C8 88 04 00 00 2F 80 00 00 41 9E 28 30 80 61 00 48 7F 85 E3 78 38 C1 00 0C 7F C7 F3 78 4? ?? ?? ?? 2F 83 00 00 90 61 00 48 41 9E 28 00 80 01 00 0C 39 20 00 01 51 20 AA 94 90 01 00 0C 4B FF FC 90 88 1F 00 00 3B FF 00 01 2F 80 00 59 41 9E 1A 58 2B 80 00 59 41 9D 13 84 2F 80 00 43 41 9E 1C E4 2F 80 00 58 41 9E 0F 90 38 60 00 00 4B FF FC E0 7F A3 EB 78 7E 44 93 78 7F 85 E3 78 38 C1 00 0C 7F C7 F3 78 4? ?? ?? ?? 2F 83 00 00 90 61 00 48 40 9E FF 9C 38 60 00 00 4B FF FC B4 88 1D 00 00 30 00 FF D0 54 00 06 3E 2B 80 00 09 41 9D 28 4C 39 6B 00 01 91 61 00 48 89 2B 00 00 38 09 FF D0 54 00 06 3E 2B 80 00 09 40 9D FF E8 4B FF FC 00 89 3D 00 00 2F 89 00 20 40 9E 00 18 39 6B 00 01 91 61 00 48 89 2B 00 00 2F 89 00 20 41 9E FF F0 38 09 FF D0 54 09 06 3E 2B 89 00 09 41 9D 27 04 1D 00 00 0A 2B 88 00 17 39 4B 00 01 91 41 00 48 41 9D 00 30 89 2B 00 01 2B 89 00 2F 40 9D 00 24 2B 89 00 39 41 9D 00 1C 7D 29 42 14 38 09 FF D0 2B 80 00 17 39 4B 00 02 91 41 00 48 41 9D 26 CC 90 1C 00 08 39 20 00 00 80 01 00 0C 51 20 F8 00 90 01 00 0C 4B FF FB 78 89 3D 00 00 2F 89 00 20 40 9E 00 18 39 6B 00 01 91 61 00 48 89 2B 00 00 2F 89 00 20 41 9E FF F0 39 29 FF D0 55 20 06 3E 2B 80 00 09 41 9D 26 E4 1D 49 00 0A 2B 8A 00 0C 39 0B 00 01 91 01 00 48 41 9D 00 28 88 0B 00 01 2B 80 00 2F 40 9D 00 1C 2B 80 00 39 41 9D 00 14 39 0B 00 02 7D 20 52 14 91 01 00 48 39 29 FF D0 39 29 FF FF 2B 89 00 0B 41 9D 26 A8 91 3C 00 10 80 01 00 0C 39 20 00 01 64 00 10 00 51 20 AA 94 90 01 00 0C 4B FF FA E8 88 1D 00 00 54 00 08 3C 7C 0A 02 2E 70 05 00 20 41 A2 FA D4 39 6B 00 01 91 61 00 48 88 0B 00 00 54 00 08 3C 7C 0A 02 2E 70 09 00 20 40 82 FF E8 4B FF FA B4 38 00 00 00 90 01 00 08 88 1D 00 00 30 00 FF D0 54 00 06 3E 2B 80 00 09 41 9D 26 44 38 00 00 00 1C 00 00 0A 90 01 00 08 89 2B 00 00 39 6B 00 01 91 61 00 48 39 29 FF D0 7C 09 02 14 90 01 00 08 89 2B 00 00 39 29 FF D0 55 29 06 3E 2B 89 00 09 40 9D FF D0 38 61 00 08 7F 84 E3 78 4? ?? ?? ?? 2F 83 00 00 40 9E FA 4C 38 60 00 00 4B FF FA C4 89 3D 00 00 2F 89 00 20 40 9E 00 18 39 6B 00 01 91 61 00 48 89 2B 00 00 2F 89 00 20 41 9E FF F0 38 09 FF D0 54 09 06 3E 2B 89 00 09 41 9D 25 E8 1D 00 00 0A 2B 88 00 35 39 4B 00 01 91 41 00 48 41 9D 00 30 89 2B 00 01 2B 89 00 2F 40 9D 00 24 2B 89 00 39 41 9D 00 1C 7D 29 42 14 38 09 FF D0 2B 80 00 35 39 4B 00 02 91 41 00 48 41 9D 25 88 98 01 00 0E 39 20 00 01 80 01 00 0C 51 20 C9 8C 90 01 00 0C 4B FF F9 BC 81 21 00 0C 3C 00 00 10 55 29 02 D8 7F 89 00 00 41 9E 12 B4 81 FB 00 BC 7D E3 7B 78 4? ?? ?? ?? 7F A4 EB 78 7C 70 1B 78 7E 05 83 78 7D E3 7B 78 7F C6 F3 78 4? ?? ?? ?? 2F 83 00 00 40 9E 11 30 80 01 00 48 39 37 ?? ?? 80 7B 00 BC 80 89 00 BC 7E 00 82 14 92 01 00 48 4? ?? ?? ?? 2F 83 00 00 40 9E 16 BC 80 01 00 0C 39 20 00 00 51 20 C1 CE 90 01 00 0C 4B FF F9 44 80 01 00 0C 3D 20 00 10 54 0B 02 D8 7F 8B 48 00 41 9E 16 58 80 9B 00 D0 89 24 00 00 2F 89 00 00 41 9E 16 28 7F A3 EB 78 7F 85 E3 78 38 C1 00 0C 7F C7 F3 78 4? ?? ?? ?? 2F 83 00 00 90 61 00 48 41 9E 16 04 83 A1 00 0C 77 AA 00 18 40 A2 F8 F4 39 37 ?? ?? 80 7B 00 D0 80 89 00 D0 4? ?? ?? ?? 2F 83 00 00 41 BE F8 DC 38 00 00 01 50 1D 9A D8 93 A1 00 0C 4B FF F8 CC 80 01 00 0C 3D 20 00 10 54 0B 02 D8 7F 8B 48 00 41 BE FB 84 80 9B 00 CC 89 24 00 00 2F 89 00 00 41 BE FB 54 7F A3 EB 78 7F 85 E3 78 38 C1 00 0C 7F C7 F3 78 4? ?? ?? ?? 2F 83 00 00 90 61 00 48 41 BE FB 30 39 37 ?? ?? 80 7B 00 CC 80 89 00 CC 4? ?? ?? ?? 2F 83 00 00 41 BE F8 70 80 01 00 0C 39 20 00 01 51 20 9A D8 90 01 00 0C 4B FF F8 5C 89 3D 00 00 2F 89 00 20 40 9E 00 18 39 6B 00 01 91 61 00 48 89 2B 00 00 2F 89 00 20 41 9E FF F0 38 09 FF D0 54 00 06 3E 2B 80 00 09 41 9D 26 BC 83 A1 00 48 38 00 00 03 7C 09 03 A6 89 3D 00 00 3B BD 00 01 93 A1 00 48 39 29 FF D0 1C 09 00 0A 2B 80 27 0F 41 9D 00 2C 89 7D 00 00 2B 8B 00 2F 40 9D 00 20 2B 8B 00 39 41 9D 00 18 39 2B FF D0 3B BD 00 01 7D 29 02 14 93 A1 00 48 42 00 FF D0 2B 89 27 0F 41 9D 24 50 39 29 F8 94 91 3C 00 14 39 20 00 01 80 01 00 0C 54 00 02 4E 51 20 AA 94 90 01 00 0C 4B FF F7 B4 80 01 00 0C 3D 20 00 10 54 0B 02 D8 7F 8B 48 00 41 9E 14 68 80 9B 00 C4 89 24 00 00 2F 89 00 00 41 9E 14 38 7F A3 EB 78 7F 85 E3 78 38 C1 00 0C 7F C7 F3 78 4? ?? ?? ?? 2F 83 00 00 90 61 00 48 41 9E 14 14 80 01 00 0C 74 05 00 18 40 A2 F9 AC 39 37 ?? ?? 80 7B 00 C4 80 89 00 C4 90 01 00 88 4? ?? ?? ?? 2F 83 00 00 80 01 00 88 41 BE F9 8C 39 20 00 01 51 20 9A D8 4B FF F9 80 80 01 00 0C 3D 20 00 10 54 0B 02 D8 7F 8B 48 00 41 BE FA 50 80 9B 00 C8 89 24 00 00 2F 89 00 00 41 BE FA 20 7F A3 EB 78 7F 85 E3 78 38 C1 00 0C 7F C7 F3 78 4? ?? ?? ?? 2F 83 00 00 90 61 00 48 41 BE F9 FC 80 01 00 0C 74 06 00 18 40 A2 F9 30 39 37 ?? ?? 80 7B 00 C8 80 89 00 C8 4B FF FF 84 88 1D 00 00 3B BD 00 01 93 A1 00 48 2F 80 00 25 41 9E F6 C4 38 60 00 00 4B FF F7 3C 80 01 00 0C 39 20 FF FF 93 21 00 6C 39 F4 ?? ?? 54 06 6F BE 93 41 00 70 3A 00 00 00 39 C0 00 00 90 C1 00 50 7F 99 E3 78 7F 7A DB 78 91 21 00 4C 93 E1 00 68 48 00 00 A0 7F BC EA 14 7F 8E E8 40 40 9C 01 68 80 01 00 0C 7F AE EB 78 92 01 00 4C 74 05 00 18 40 82 01 58 80 7F 00 04 80 8F 00 00 4? ?? ?? ?? 2F 83 00 00 40 9E 12 E0 92 01 00 4C 83 A1 00 48 83 8F 00 1C 7F 83 E3 78 4? ?? ?? ?? 7F A4 EB 78 7C 7F 1B 78 7F E5 FB 78 7F 83 E3 78 7F C6 F3 78 4? ?? ?? ?? 2F 83 00 00 40 9E 0A 24 7F FD FA 14 7F 9F 70 40 40 9D 0A 18 39 20 00 02 92 01 00 4C 7F EE FB 78 91 21 00 50 2F 90 00 06 39 EF 00 04 3A 10 00 01 41 9E 0C 5C 83 A1 00 48 80 01 00 0C 54 00 02 D8 3D 40 00 10 7F 80 50 00 41 BE FF 94 3F F0 00 02 3B 9F 00 07 57 9C 04 3E 3B 9C 00 08 57 9C 10 3A 7F 9A E2 14 80 1C 00 04 7C 03 03 78 90 01 00 88 4? ?? ?? ?? 7F A4 EB 78 80 01 00 88 7C 7B 1B 78 7F 65 DB 78 7C 03 03 78 7F C6 F3 78 4? ?? ?? ?? 2F 83 00 00 40 9E 00 3C 7F BD DA 14 7F 9D 70 40 40 9D 00 30 80 01 00 0C 7F AE EB 78 92 01 00 4C 74 0B 00 18 40 82 00 1C 80 7C 00 04 80 8F 00 1C 4? ?? ?? ?? 2F 83 00 00 40 9E 11 C8 92 01 00 4C 57 FF 04 3E 83 81 00 48 3B FF 00 08 57 FF 10 3A 7F FA FA 14 83 7F 00 04 7F 63 DB 78 4? ?? ?? ?? 7F 84 E3 78 7C 7D 1B 78 7F A5 EB 78 7F 63 DB 78 7F C6 F3 78 4? ?? ?? ?? 2F 83 00 00 41 BE FE 94 80 01 00 0C 54 00 02 D8 3C C0 00 08 7F 80 30 00 41 9E FF 04 83 A1 00 48 4B FF FE B4 89 3D 00 00 2F 89 00 20 40 9E 00 18 39 6B 00 01 91 61 00 48 89 2B 00 00 2F 89 00 20 41 9E FF F0 39 29 FF D0 55 20 06 3E 2B 80 00 09 41 9D 20 1C 1D 49 00 0A 2B 8A 00 35 39 2B 00 01 91 21 00 48 41 BD F4 B4 88 0B 00 01 2B 80 00 2F 40 BD F4 A8 2B 80 00 39 41 BD F4 A0 7C 00 52 14 30 00 FF D0 2B 80 00 35 39 2B 00 02 91 21 00 48 40 9D F4 88 38 60 00 00 4B FF F5 00 89 3D 00 00 2F 89 00 20 40 9E 00 18 39 6B 00 01 91 61 00 48 89 2B 00 00 2F 89 00 20 41 9E FF F0 38 09 FF D0 54 09 06 3E 2B 89 00 09 41 9D 20 94 1D 00 00 0A 2B 88 00 3D 39 4B 00 01 91 41 00 48 41 9D 00 30 89 2B 00 01 2B 89 00 2F 40 9D 00 24 2B 89 00 39 41 9D 00 1C 7D 29 42 14 38 09 FF D0 2B 80 00 3D 39 4B 00 02 91 41 00 48 41 9D 20 5C 90 1C 00 00 4B FF F4 08 88 1F 00 00 3B FF 00 01 2F 80 00 56 41 9E 13 A8 2B 80 00 56 41 9D 0C 10 2F 80 00 4D 41 9E 1B 24 2B 80 00 4D 41 9D 17 14 2F 80 00 48 41 9E 18 AC 2F 80 00 49 41 9E 15 F8 38 60 00 00 4B FF F4 48 7F A3 EB 78 7E 24 8B 78 7F 85 E3 78 38 C1 00 0C 7F C7 F3 78 4? ?? ?? ?? 2F 83 00 00 90 61 00 48 40 9E F3 A4 38 60 00 00 4B FF F4 1C 89 3D 00 00 2F 89 00 20 40 9E 00 18 39 6B 00 01 91 61 00 48 89 2B 00 00 2F 89 00 20 41 9E FF F0 38 09 FF D0 54 0A 06 3E 2B 8A 00 09 41 9D 1F C8 39 29 FF CF 2B 89 00 06 39 6B 00 01 91 61 00 48 41 9D 1F AC 3D 20 24 92 61 29 49 25 7D 20 48 16 7D 69 00 50 55 6B F8 7E 7D 29 5A 14 55 29 F0 BE 1D 29 00 07 7C 09 00 50 90 1C 00 18 39 20 00 01 80 01 00 0C 51 20 F0 42 90 01 00 0C 4B FF F3 1C 89 3D 00 00 2F 89 00 20 40 9E 00 18 39 6B 00 01 91 61 00 48 89 2B 00 00 2F 89 00 20 41 9E FF F0 39 29 FF D0 55 20 06 3E 2B 80 00 09 41 9D 1E 38 2B 89 00 06 39 6B 00 01 91 61 00 48 41 9D 1E 20 91 3C 00 18 39 20 00 01 80 01 00 0C 51 20 F0 42 90 01 00 0C 4B FF F2 C4 89 3D 00 00 2F 89 00 20 40 9E 00 18 39 6B 00 01 91 61 00 48 89 2B 00 00 2F 89 00 20 41 9E FF F0 38 09 FF D0 54 09 06 3E 2B 89 00 09 41 9D 1E A8 1D 00 00 0A 2B 88 00 35 39 4B 00 01 91 41 00 48 41 9D 00 30 89 2B 00 01 2B 89 00 2F 40 9D 00 24 2B 89 00 39 41 9D 00 1C 7D 29 42 14 38 09 FF D0 2B 80 00 35 39 4B 00 02 91 41 00 48 41 9D 1E 70 98 01 00 0E 39 20 00 01 80 01 00 0C 51 20 D1 4A 90 01 00 0C 4B FF F2 3C 80 01 00 0C 38 C0 FF FF 93 21 00 6C 39 F3 ?? ?? 54 05 6F BE 93 41 00 70 3A 00 00 00 39 C0 00 00 90 A1 00 50 7F 99 E3 78 7F 7A DB 78 90 C1 00 4C 93 E1 00 68 48 00 00 A0 7F FD FA 14 7F 8E F8 40 40 9C 01 6C 80 01 00 0C 7F EE FB 78 92 01 00 4C 74 05 00 18 40 82 01 5C 80 7C 00 04 80 8F 00 00 4? ?? ?? ?? 2F 83 00 00 40 9E 0B 28 92 01 00 4C 83 A1 00 48 83 8F 00 30 7F 83 E3 78 4? ?? ?? ?? 7F A4 EB 78 7C 7F 1B 78 7F E5 FB 78 7F 83 E3 78 7F C6 F3 78 4? ?? ?? ?? 2F 83 00 00 40 9E 05 54 7F FD FA 14 7F 9F 70 40 40 9D 05 48 39 20 00 02 92 01 00 4C 7F EE FB 78 91 21 00 50 2F 90 00 0B 39 EF 00 04 3A 10 00 01 41 9E 08 28 83 A1 00 48 80 01 00 0C 54 00 02 D8 3D 20 00 10 7F 80 48 00 41 BE FF 94 3F F0 00 02 3B 7F 00 1A 57 7B 04 3E 3B 7B 00 08 57 7B 10 3A 7F 7A DA 14 80 1B 00 04 7C 03 03 78 90 01 00 88 4? ?? ?? ?? 7F A4 EB 78 80 01 00 88 7C 7C 1B 78 7F 85 E3 78 7C 03 03 78 7F C6 F3 78 4? ?? ?? ?? 2F 83 00 00 40 9E 00 3C 7F BD E2 14 7F 8E E8 40 40 9C 00 30 80 01 00 0C 7F AE EB 78 92 01 00 4C 74 0A 00 18 40 82 00 1C 80 7B 00 04 80 8F 00 30 4? ?? ?? ?? 2F 83 00 00 40 9E 0A 44 }
	condition:
		$1
}

rule file_34_0_0 {
	meta:
		name = "jrand48"
		size = 48
		refs = "000a __libc_drand48_data 0018 __jrand48_r"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 3C 80 ?? ?? 38 A1 00 08 90 01 00 24 38 84 ?? ?? 4? ?? ?? ?? 80 01 00 24 80 61 00 08 38 21 00 20 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_439_0_0 {
	meta:
		name = "nrand48"
		size = 48
		refs = "000a __libc_drand48_data 0018 __nrand48_r"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 3C 80 ?? ?? 38 A1 00 08 90 01 00 24 38 84 ?? ?? 4? ?? ?? ?? 80 01 00 24 80 61 00 08 38 21 00 20 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_35_0_0 {
	meta:
		name = "_longjmp_unwind"
		size = 68
		refs = "000a __pthread_cleanup_upto"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 3D 20 ?? ?? 90 01 00 14 38 09 ?? ?? 2F 80 00 00 93 E1 00 0C 7C 3F 0B 78 41 9E 00 0C 7F E4 FB 78 4? ?? ?? ?? 39 7F 00 10 80 0B 00 04 83 EB FF FC 7C 08 03 A6 7D 61 5B 78 4E 80 00 20 }
	condition:
		$1
}

rule file_36_0_0 {
	meta:
		name = "checkhdr"
		size = 212
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 93 C1 00 08 3F C0 ?? ?? 90 01 00 14 80 1E ?? ?? 93 E1 00 0C 3B E0 00 00 2F 80 00 00 41 9E 00 58 81 63 00 0C 80 03 00 08 81 23 00 04 7C 0B 02 14 7C 00 4A 78 6C 09 D8 67 2F 89 53 09 41 9E 00 54 6C 09 01 25 2F 89 BE EB 41 9E 00 50 3B E0 00 02 39 3E ?? ?? 38 00 00 00 90 1E ?? ?? 7F E3 FB 78 80 09 00 04 7C 09 03 A6 4E 80 04 21 38 00 00 01 90 1E ?? ?? 80 01 00 14 7F E3 FB 78 83 C1 00 08 7C 08 03 A6 83 E1 00 0C 38 21 00 10 4E 80 00 20 3B E0 00 01 4B FF FF BC 81 23 00 00 3B E0 00 03 7D 23 4A 14 89 29 00 18 2F 89 00 D7 40 9E FF A4 81 63 00 10 3B E0 00 00 81 23 00 14 7D 69 4A 78 7F 89 00 00 40 9E FF 88 4B FF FF AC }
	condition:
		$1
}

rule file_36_1_0 {
	meta:
		name = "mabort"
		size = 188
		refs = "002a _libc_intl_domainname 003c __dcgettext 0040 __libc_fatal"
	strings:
		$1 = { 2F 83 00 01 94 21 FF F0 7C 08 02 A6 90 01 00 14 41 9E 00 6C 40 9D 00 84 2F 83 00 02 41 9E 00 28 2F 83 00 03 41 9E 00 3C 3C 60 ?? ?? 3C 80 ?? ?? 38 84 ?? ?? 38 A0 00 05 38 63 ?? ?? 4? ?? ?? ?? 4? ?? ?? ?? 3C 60 ?? ?? 3C 80 ?? ?? 38 84 ?? ?? 38 A0 00 05 38 63 ?? ?? 4? ?? ?? ?? 4? ?? ?? ?? 3C 60 ?? ?? 3C 80 ?? ?? 38 84 ?? ?? 38 A0 00 05 38 63 ?? ?? 4? ?? ?? ?? 4? ?? ?? ?? 3C 60 ?? ?? 3C 80 ?? ?? 38 84 ?? ?? 38 A0 00 05 38 63 ?? ?? 4? ?? ?? ?? 4? ?? ?? ?? 2F 83 00 00 40 BE FF 8C 3C 60 ?? ?? 3C 80 ?? ?? 38 84 ?? ?? 38 A0 00 05 38 63 ?? ?? 4? ?? ?? ?? 4? ?? ?? ?? }
	condition:
		$1
}

rule file_36_2_0 {
	meta:
		name = "memalignhook"
		size = 404
		refs = "0052 _GLOBAL_OFFSET_TABLE_ 005a __libc_errno 0092 __memalign_hook 0140 memset 0170 mcheck_check_all 0188 memalign"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 93 C1 00 18 3F C0 ?? ?? 3B DE ?? ?? 90 01 00 24 80 1E 00 0C 93 E1 00 1C 7C 9F 23 78 2F 80 00 00 93 81 00 10 93 A1 00 14 40 9E 01 38 38 03 00 17 7F A3 00 D0 7F BD 00 38 38 1D 00 01 7C 00 00 F8 7F 80 F8 40 40 9C 00 40 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 38 00 00 0C 90 09 00 00 38 60 00 00 80 01 00 24 83 81 00 10 7C 08 03 A6 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 80 1E 00 10 3F 80 ?? ?? 2F 80 00 00 90 1C ?? ?? 41 9E 00 E4 38 9F 00 01 7C 09 03 A6 7C 84 EA 14 4E 80 04 21 7C 6A 1B 78 2F 8A 00 00 3D 20 ?? ?? 38 09 ?? ?? 90 1C ?? ?? 38 60 00 00 41 BE FF A4 81 3E 00 08 3B BD FF E8 7D 6A EA 14 7F EA E9 2E 2F 89 00 00 6D 20 FE DA 90 6B 00 08 68 00 BE EB 91 2B 00 0C 91 7E 00 08 90 0B 00 04 41 9E 00 1C 80 09 00 0C 91 69 00 08 7C 0B 02 14 6C 00 FE DA 68 00 BE EB 90 09 00 04 6D 40 FE DA 91 4B 00 10 68 00 BE EB 7D 2B FA 14 90 0B 00 14 38 00 FF D7 3B CB 00 18 98 09 00 18 7F C3 F3 78 7F E5 FB 78 38 80 00 93 4? ?? ?? ?? 80 01 00 24 7F C3 F3 78 83 81 00 10 7C 08 03 A6 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 90 61 00 08 90 A1 00 0C 4? ?? ?? ?? 80 A1 00 0C 80 61 00 08 4B FF FE B8 38 9F 00 01 7C 84 EA 14 4? ?? ?? ?? 7C 6A 1B 78 4B FF FF 24 }
	condition:
		$1
}

rule file_36_3_0 {
	meta:
		name = "mallochook"
		size = 352
		refs = "003e _GLOBAL_OFFSET_TABLE_ 0046 __libc_errno 007a __malloc_hook 011c memset 0144 mcheck_check_all 0154 malloc"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 93 A1 00 14 3F A0 ?? ?? 3B BD ?? ?? 90 01 00 24 80 1D 00 0C 93 C1 00 18 7C 7E 1B 78 2F 80 00 00 93 E1 00 1C 40 9E 01 14 38 00 FF E6 7F 9E 00 40 40 9D 00 3C 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 38 00 00 0C 90 09 00 00 38 60 00 00 80 01 00 24 83 A1 00 14 7C 08 03 A6 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 80 1D 00 14 3F E0 ?? ?? 2F 80 00 00 90 1F ?? ?? 41 9E 00 CC 38 7E 00 19 7C 09 03 A6 4E 80 04 21 7C 6B 1B 78 2F 8B 00 00 3D 20 ?? ?? 38 09 ?? ?? 90 1F ?? ?? 38 60 00 00 41 BE FF AC 81 3D 00 08 93 CB 00 00 2F 89 00 00 6D 20 FE DA 90 6B 00 08 68 00 BE EB 91 2B 00 0C 91 7D 00 08 90 0B 00 04 41 9E 00 1C 80 09 00 0C 91 69 00 08 7C 00 5A 14 6C 00 FE DA 68 00 BE EB 90 09 00 04 6D 60 FE DA 91 6B 00 10 68 00 BE EB 7D 2B F2 14 90 0B 00 14 38 00 FF D7 3B EB 00 18 98 09 00 18 7F E3 FB 78 7F C5 F3 78 38 80 00 93 4? ?? ?? ?? 80 01 00 24 7F E3 FB 78 83 A1 00 14 7C 08 03 A6 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 90 81 00 08 4? ?? ?? ?? 80 81 00 08 4B FF FE E4 38 7E 00 19 4? ?? ?? ?? 7C 6B 1B 78 4B FF FF 3C }
	condition:
		$1
}

rule file_36_4_0 {
	meta:
		name = "freehook"
		size = 348
		refs = "00c0 memset 00ce __free_hook 0118 mcheck_check_all 0124 free"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 93 C1 00 18 3F C0 ?? ?? 3B DE ?? ?? 90 01 00 24 80 1E 00 0C 93 81 00 10 7C 7C 1B 78 2F 80 00 00 93 A1 00 14 7C 9D 23 78 93 E1 00 1C 40 9E 00 E4 2F 9C 00 00 41 9E 00 8C 3B FC FF E8 7F E3 FB 78 4B FF FA D1 81 3F 00 0C 3C 00 D8 67 2F 89 00 00 60 00 53 09 90 1F 00 04 90 1F 00 14 41 9E 00 20 80 1F 00 08 81 69 00 0C 90 09 00 08 7C 00 5A 14 6C 00 FE DA 68 00 BE EB 90 09 00 04 81 7F 00 08 2F 8B 00 00 41 9E 00 C8 80 0B 00 08 91 2B 00 0C 7D 29 02 14 6D 29 FE DA 69 29 BE EB 91 2B 00 04 38 00 00 00 80 BF 00 00 90 1F 00 0C 7F 83 E3 78 38 80 00 95 90 1F 00 08 4? ?? ?? ?? 83 9F 00 10 80 1E 00 18 3F E0 ?? ?? 2F 80 00 00 90 1F ?? ?? 41 9E 00 48 7F 83 E3 78 7C 09 03 A6 7F A4 EB 78 4E 80 04 21 3D 20 ?? ?? 38 09 ?? ?? 83 81 00 10 90 1F ?? ?? 80 01 00 24 83 A1 00 14 7C 08 03 A6 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 4? ?? ?? ?? 4B FF FF 1C 7F 83 E3 78 4? ?? ?? ?? 3D 20 ?? ?? 38 09 ?? ?? 83 81 00 10 90 1F ?? ?? 80 01 00 24 83 A1 00 14 7C 08 03 A6 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 91 3E 00 08 4B FF FF 50 }
	condition:
		$1
}

rule file_36_5_0 {
	meta:
		name = "reallochook"
		size = 688
		refs = "00da __free_hook 00e2 __malloc_hook 00f2 __memalign_hook 00f6 __realloc_hook 01fe _GLOBAL_OFFSET_TABLE_ 0206 __libc_errno 024c mcheck_check_all 0264 memset 028c realloc"
	strings:
		$1 = { 94 21 FF D0 7C 08 02 A6 93 A1 00 24 7C 9D 23 79 93 41 00 18 7C 7A 1B 78 93 61 00 1C 7C BB 2B 78 90 01 00 34 92 E1 00 0C 93 01 00 10 93 21 00 14 93 81 00 20 93 C1 00 28 93 E1 00 2C 41 82 02 64 3F C0 ?? ?? 3B DE ?? ?? 80 1E 00 0C 2F 80 00 00 40 9E 01 FC 38 00 FF E6 7F 9D 00 40 41 9D 01 A0 2F 9A 00 00 3B 80 00 00 3B E0 00 00 41 9E 00 68 3B FA FF E8 83 9A FF E8 7F E3 FB 78 4B FF F9 41 81 3F 00 0C 2F 89 00 00 41 9E 00 20 80 1F 00 08 81 69 00 0C 90 09 00 08 7C 00 5A 14 6C 00 FE DA 68 00 BE EB 90 09 00 04 81 7F 00 08 2F 8B 00 00 41 9E 01 E8 80 0B 00 08 91 2B 00 0C 7D 29 02 14 6D 29 FE DA 69 29 BE EB 91 2B 00 04 7F 9D E0 40 41 9C 01 A0 80 1E 00 1C 3E E0 ?? ?? 81 5E 00 18 3F 00 ?? ?? 2F 80 00 00 81 7E 00 14 81 3E 00 10 3F 20 ?? ?? 3F 40 ?? ?? 91 57 ?? ?? 91 78 ?? ?? 91 39 ?? ?? 90 1A ?? ?? 41 9E 01 7C 7F E3 FB 78 7C 09 03 A6 38 9D 00 19 7F 65 DB 78 4E 80 04 21 7C 7F 1B 78 3D 20 ?? ?? 2F 9F 00 00 38 09 ?? ?? 3D 20 ?? ?? 90 17 ?? ?? 38 09 ?? ?? 3D 20 ?? ?? 90 18 ?? ?? 38 09 ?? ?? 3D 20 ?? ?? 90 19 ?? ?? 38 09 ?? ?? 38 60 00 00 90 1A ?? ?? 41 9E 00 BC 81 3E 00 08 93 BF 00 00 2F 89 00 00 6D 20 FE DA 90 7F 00 08 68 00 BE EB 91 3F 00 0C 93 FE 00 08 90 1F 00 04 41 9E 00 1C 80 09 00 0C 93 E9 00 08 7C 00 FA 14 6C 00 FE DA 68 00 BE EB 90 09 00 04 7F 9C E8 40 93 FF 00 10 6F E0 FE DA 68 00 BE EB 90 1F 00 14 7D 3F EA 14 38 00 FF D7 98 09 00 18 41 9C 00 94 38 7F 00 18 80 01 00 34 82 E1 00 0C 7C 08 03 A6 83 01 00 10 83 21 00 14 83 41 00 18 83 61 00 1C 83 81 00 20 83 A1 00 24 83 C1 00 28 83 E1 00 2C 38 21 00 30 4E 80 00 20 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 38 00 00 0C 90 09 00 00 38 60 00 00 80 01 00 34 82 E1 00 0C 7C 08 03 A6 83 01 00 10 83 21 00 14 83 41 00 18 83 61 00 1C 83 81 00 20 83 A1 00 24 83 C1 00 28 83 E1 00 2C 38 21 00 30 4E 80 00 20 4? ?? ?? ?? 4B FF FE 04 38 7C 00 18 7C 7F 1A 14 38 80 00 93 7C BC E8 50 4? ?? ?? ?? 38 7F 00 18 4B FF FF 5C 7C 7A EA 14 38 80 00 95 7C BD E0 50 4? ?? ?? ?? 4B FF FE 54 7F E3 FB 78 38 9D 00 19 4? ?? ?? ?? 7C 7F 1B 78 4B FF FE 90 91 3E 00 08 4B FF FE 30 7C A4 2B 78 4B FF FC 01 38 60 00 00 4B FF FF 6C }
	condition:
		$1
}

rule file_36_6_0 {
	meta:
		name = "mcheck_check_all"
		size = 100
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 93 C1 00 08 3F C0 ?? ?? 3B DE ?? ?? 93 E1 00 0C 83 FE 00 08 90 01 00 14 38 00 00 00 2F 9F 00 00 90 1E 00 0C 41 9E 00 18 7F E3 FB 78 4B FF FE 3D 83 FF 00 0C 2F 9F 00 00 40 9E FF F0 38 00 00 01 83 E1 00 0C 90 1E 00 0C 80 01 00 14 83 C1 00 08 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_36_7_0 {
	meta:
		name = "mcheck"
		size = 252
		refs = "0022 __libc_malloc_initialized 007c malloc 0080 free 0086 __free_hook 008e __malloc_hook 0096 __realloc_hook 00ba __memalign_hook"
	strings:
		$1 = { 2C 03 00 00 94 21 FF E0 7C 08 02 A6 93 A1 00 14 90 01 00 24 93 C1 00 18 93 E1 00 1C 41 82 00 D4 3D 20 ?? ?? 80 09 ?? ?? 3F E0 ?? ?? 3B DF ?? ?? 2F 80 00 00 90 7E 00 04 40 9D 00 30 83 BF ?? ?? 33 BD FF FF 7F BD E9 10 80 01 00 24 7F A3 EB 78 83 C1 00 18 7C 08 03 A6 83 A1 00 14 83 E1 00 1C 38 21 00 20 4E 80 00 20 80 1F ?? ?? 3B A0 00 00 2F 80 00 00 40 9E FF D4 38 60 00 00 4? ?? ?? ?? 4? ?? ?? ?? 3D 00 ?? ?? 80 A8 ?? ?? 3D 40 ?? ?? 80 CA ?? ?? 3D 20 ?? ?? 90 BE 00 18 3C A0 ?? ?? 38 A5 ?? ?? 90 A8 ?? ?? 3D 00 ?? ?? 39 08 ?? ?? 91 0A ?? ?? 3D 40 ?? ?? 3D 60 ?? ?? 80 09 ?? ?? 39 4A ?? ?? 80 EB ?? ?? 91 4B ?? ?? 3D 60 ?? ?? 90 1E 00 1C 38 0B ?? ?? 90 09 ?? ?? 38 00 00 01 90 DE 00 14 90 FE 00 10 90 1F ?? ?? 4B FF FF 5C 3C 60 ?? ?? 38 63 ?? ?? 4B FF FF 28 }
	condition:
		$1
}

rule file_36_8_0 {
	meta:
		name = "mcheck_pedantic"
		size = 52
		refs = "000c mcheck"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 2C 03 00 00 40 82 00 10 38 00 00 01 3D 20 ?? ?? 90 09 ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_1370_0_0 {
	meta:
		name = "_IO_str_chk_overflow"
		size = 16
		refs = "000c __chk_fail"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? }
	condition:
		$1
}

rule file_507_0_0 {
	meta:
		name = "__stack_chk_fail_local"
		size = 16
		refs = "000c __stack_chk_fail"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? }
	condition:
		$1
}

rule file_66_0_3 {
	meta:
		name = "__vmx_longjmp"
		size = 16
		refs = "000c __libc_longjmp"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? }
	condition:
		$1
}

rule file_66_1_3 {
	meta:
		name = "__vmx_siglongjmp"
		size = 16
		refs = "000c __libc_siglongjmp"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? }
	condition:
		$1
}

rule file_255_1_0 {
	meta:
		name = "_dl_start"
		size = 16
		refs = "000c abort"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? }
	condition:
		$1
}

rule file_66_2_3 {
	meta:
		name = "longjmp"
		size = 16
		refs = "000c __libc_longjmp"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? }
	condition:
		$1
}

rule file_66_3_3 {
	meta:
		name = "siglongjmp"
		size = 16
		refs = "000c __libc_siglongjmp"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? }
	condition:
		$1
}

rule file_818_10_0 {
	meta:
		name = "svctcp_rendezvous_abort"
		size = 16
		refs = "000c abort"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? }
	condition:
		$1
}

rule file_166_10_0 {
	meta:
		name = "svcunix_rendezvous_abort"
		size = 16
		refs = "000c abort"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? }
	condition:
		$1
}

rule file_36_9_0 {
	meta:
		name = "mprobe"
		size = 32
	strings:
		$1 = { 3D 20 ?? ?? 80 09 ?? ?? 2F 80 00 00 40 9E 00 0C 38 60 FF FF 4E 80 00 20 38 63 FF E8 4B FF F5 C0 }
	condition:
		$1
}

rule file_39_0_0 {
	meta:
		name = "_create_xid"
		size = 264
		refs = "004c getpid 006c __gettimeofday 0084 __srand48_r 0094 lrand48_r 00dc __lll_lock_wait_private"
	strings:
		$1 = { 94 21 FF D0 7C 08 02 A6 39 60 00 01 93 C1 00 28 3F C0 ?? ?? 39 20 00 00 93 E1 00 2C 3B FE ?? ?? 90 01 00 34 93 81 00 20 93 A1 00 24 7C 00 F8 28 7C 00 48 00 40 82 00 0C 7D 60 F9 2D 40 A2 FF F0 4C 00 01 2C 2F 80 00 00 40 9E 00 90 4? ?? ?? ?? 80 1F 00 04 7C 7C 1B 78 7F 80 18 00 3B BF 00 08 41 9E 00 2C 38 80 00 00 38 61 00 0C 4? ?? ?? ?? 80 01 00 0C 80 61 00 10 7F A4 EB 78 7C 63 02 78 7C 63 E2 78 4? ?? ?? ?? 93 9F 00 04 7F A3 EB 78 38 81 00 08 4? ?? ?? ?? 38 00 00 00 7C 00 04 AC 7D 20 F8 28 7C 00 F9 2D 40 A2 FF F8 2F 89 00 01 41 9D 00 34 80 01 00 34 80 61 00 08 7C 08 03 A6 83 81 00 20 83 A1 00 24 83 C1 00 28 83 E1 00 2C 38 21 00 30 4E 80 00 20 7F E3 FB 78 4? ?? ?? ?? 4B FF FF 6C 80 82 8B 68 38 00 00 DD 7F E3 FB 78 60 84 00 01 38 A0 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF B0 }
	condition:
		$1
}

rule file_40_0_0 {
	meta:
		name = "alphasort64"
		size = 48
		refs = "001c strcoll"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 80 63 00 00 80 84 00 00 38 63 00 13 38 84 00 13 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_65_0_0 {
	meta:
		name = "versionsort64"
		size = 48
		refs = "001c __strverscmp"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 80 63 00 00 80 84 00 00 38 63 00 13 38 84 00 13 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_41_0_0 {
	meta:
		name = "lrand48"
		size = 52
		refs = "0006 __libc_drand48_data 001c __nrand48_r"
	strings:
		$1 = { 94 21 FF E0 3C 60 ?? ?? 7C 08 02 A6 38 63 ?? ?? 38 A1 00 08 7C 64 1B 78 90 01 00 24 4? ?? ?? ?? 80 01 00 24 80 61 00 08 38 21 00 20 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_1292_0_0 {
	meta:
		name = "mrand48"
		size = 52
		refs = "0006 __libc_drand48_data 001c __jrand48_r"
	strings:
		$1 = { 94 21 FF E0 3C 60 ?? ?? 7C 08 02 A6 38 63 ?? ?? 38 A1 00 08 7C 64 1B 78 90 01 00 24 4? ?? ?? ?? 80 01 00 24 80 61 00 08 38 21 00 20 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_42_0_0 {
	meta:
		name = "__realpath_chk"
		size = 44
		refs = "0014 __realpath 0028 __chk_fail"
	strings:
		$1 = { 2B 85 0F FF 94 21 FF F0 7C 08 02 A6 90 01 00 14 40 9D 00 18 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_43_0_0 {
	meta:
		name = "psignal"
		size = 332
		refs = "004a _sys_siglist 0062 _libc_intl_domainname 006c __dcgettext 008c __fxprintf 00e4 __asprintf 010c free"
	strings:
		$1 = { 94 21 FF D0 7C 08 02 A6 93 E1 00 2C 7C 9F 23 79 93 81 00 20 7C 7C 1B 78 90 01 00 34 93 A1 00 24 93 C1 00 28 41 82 00 10 88 1F 00 00 2F 80 00 00 40 9E 01 00 3F C0 ?? ?? 3B DE ?? ?? 7F DF F3 78 2B 9C 00 40 41 9D 00 6C 3D 20 ?? ?? 57 80 10 3A 39 29 ?? ?? 7C 89 00 2E 2F 84 00 00 41 9E 00 54 3C 60 ?? ?? 38 63 ?? ?? 38 A0 00 05 4? ?? ?? ?? 3C 80 ?? ?? 7C 67 1B 78 7F E5 FB 78 7F C6 F3 78 38 84 ?? ?? 38 60 00 00 4C C6 31 82 4? ?? ?? ?? 80 01 00 34 83 81 00 20 7C 08 03 A6 83 A1 00 24 83 C1 00 28 83 E1 00 2C 38 21 00 30 4E 80 00 20 3F A0 ?? ?? 3B BD ?? ?? 3C 80 ?? ?? 38 84 ?? ?? 38 A0 00 05 7F A3 EB 78 4? ?? ?? ?? 7F E5 FB 78 7C 64 1B 78 7F C6 F3 78 38 61 00 08 7F 87 E3 78 4C C6 31 82 4? ?? ?? ?? 2F 83 00 00 41 9C 00 50 80 A1 00 08 3C 80 ?? ?? 38 84 ?? ?? 38 60 00 00 4C C6 31 82 4? ?? ?? ?? 80 61 00 08 4? ?? ?? ?? 80 01 00 34 83 81 00 20 7C 08 03 A6 83 A1 00 24 83 C1 00 28 83 E1 00 2C 38 21 00 30 4E 80 00 20 3F C0 ?? ?? 3B DE ?? ?? 4B FF FF 08 3C 80 ?? ?? 38 84 ?? ?? 7F A3 EB 78 4B FF FF 20 }
	condition:
		$1
}

rule file_44_0_0 {
	meta:
		name = "__lcong48_r"
		size = 72
	strings:
		$1 = { 81 63 00 00 7C 69 1B 78 A0 03 00 04 38 60 00 00 91 64 00 00 B0 04 00 04 A1 09 00 08 A1 49 00 06 A0 09 00 0C A1 69 00 0A 55 09 80 1E 7D 49 4B 78 B0 04 00 0C 38 00 00 01 91 64 00 10 91 24 00 14 B0 04 00 0E 4E 80 00 20 }
	condition:
		$1
}

rule file_45_0_0 {
	meta:
		name = "grantpt"
		size = 1300
		refs = "0050 realloc 0078 __ptsname_internal 0090 memchr 00ac malloc 00b8 __errno_location 00d4 free 00e8 __libc_fcntl 0120 __getuid 0140 __chown 014c __fork 0174 __setrlimit 0188 __dup2 019c __opendir 01ac __readdir64 01d4 strtol 0254 __chmod 02bc __waitpid 02fc __assert_fail 031c __closedir 0388 basename 03a0 execle 03a8 _exit 0440 __sysconf 047c __getgrnam_r 04a0 __getgid"
	strings:
		$1 = { 94 21 EF 50 7C 08 02 A6 93 E1 10 AC 7C 3F 0B 78 93 A1 10 A4 3B BF 00 98 93 61 10 9C 3B 60 10 00 93 81 10 A0 7C 7C 1B 78 93 C1 10 A8 7F BE EB 78 90 01 10 B4 93 41 10 98 48 00 00 28 7F 9E E8 00 3B 60 00 80 41 9E 00 64 7F C3 F3 78 7F 64 DB 78 4? ?? ?? ?? 2F 83 00 00 41 9E 00 60 7C 7E 1B 78 2F 9B 00 00 41 9E FF D8 7F 83 E3 78 7F C4 F3 78 7F 65 DB 78 38 DF 00 30 4? ?? ?? ?? 7C 7A 1B 79 40 82 00 88 7F C3 F3 78 38 80 00 00 7F 65 DB 78 4? ?? ?? ?? 2F 83 00 00 40 9E 00 88 7F 9E E8 00 57 7B 08 3C 40 9E FF A4 7F 63 DB 78 4? ?? ?? ?? 2F 83 00 00 40 9E FF A8 4? ?? ?? ?? 38 00 00 0C 90 03 00 00 7C 7B 1B 78 7F 9E E8 00 41 9E 00 0C 7F C3 F3 78 4? ?? ?? ?? 7F 83 E3 78 83 DB 00 00 38 80 00 01 4C C6 31 82 4? ?? ?? ?? 2F 83 FF FF 41 9E 02 C4 2F 9E 00 19 41 9E 03 BC 93 DB 00 00 3B 40 FF FF 48 00 01 70 2F 9A 00 19 41 9E 02 A0 4? ?? ?? ?? 7C 7B 1B 78 93 43 00 00 4B FF FF AC 4? ?? ?? ?? 80 1F 00 48 7C 7A 1B 78 7F 80 18 00 41 9E 00 DC 80 BF 00 4C 7F C3 F3 78 7F 44 D3 78 4? ?? ?? ?? 2F 83 00 00 40 BC 00 C4 4? ?? ?? ?? 2F 83 FF FF 7C 60 1B 78 41 9E 01 54 2F 83 00 00 40 9E 01 54 38 60 00 04 90 1F 00 14 38 9F 00 14 90 1F 00 18 4? ?? ?? ?? 2F 9C 00 03 41 9E 00 18 7F 83 E3 78 38 80 00 03 4? ?? ?? ?? 2F 83 00 00 41 9C 02 A4 3C 60 ?? ?? 38 63 ?? ?? 4? ?? ?? ?? 7C 7E 1B 79 41 82 01 D8 7F C3 F3 78 4? ?? ?? ?? 2C 03 00 00 41 82 01 60 89 23 00 13 38 09 FF D0 2B 80 00 09 41 9D FF E4 38 63 00 13 38 9F 00 10 38 A0 00 0A 4? ?? ?? ?? 81 3F 00 10 88 09 00 00 2F 80 00 00 40 BE FF C4 2F 83 00 03 41 BE FF BC 80 1E 00 00 7F 83 00 00 41 BE FF B0 38 00 00 06 44 00 00 02 7C 00 00 26 4B FF FF A0 3F 60 ?? ?? 80 BB ?? ?? 2F 85 FF FF 41 9E 02 24 80 1F 00 4C 7F 85 00 00 41 9E 00 18 7F C3 F3 78 7F 44 D3 78 4? ?? ?? ?? 2F 83 00 00 41 BC FF 14 80 1F 00 40 54 00 05 FE 2F 80 01 90 41 9E 00 5C 7F C3 F3 78 38 80 01 90 4? ?? ?? ?? 3B 40 00 00 2F 83 00 00 41 BC FE EC 7F 9E E8 00 41 9E 00 0C 7F C3 F3 78 4? ?? ?? ?? 39 7F 10 B0 80 0B 00 04 7F 43 D3 78 83 6B FF EC 7C 08 03 A6 83 4B FF E8 83 8B FF F0 83 AB FF F4 83 CB FF F8 83 EB FF FC 7D 61 5B 78 4E 80 00 20 3B 40 00 00 4B FF FF BC 3B 40 FF FF 4B FF FF B4 38 9F 00 0C 38 A0 00 00 4? ?? ?? ?? 2F 83 FF FF 41 BE FF E8 80 1F 00 0C 70 09 00 7F 40 82 00 30 54 00 C6 3E 2B 80 00 05 40 9D 00 EC 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 00 EA 38 C6 ?? ?? 4? ?? ?? ?? 4? ?? ?? ?? 38 00 00 08 90 03 00 00 3B 40 FF FF 4B FF FF 54 7F C3 F3 78 3F C0 ?? ?? 4? ?? ?? ?? 3B DE ?? ?? 38 00 00 05 7F C3 F3 78 38 80 00 00 44 00 00 02 7C 00 00 26 74 09 10 00 7C 7D 1B 78 40 82 01 AC 2F 83 00 00 40 9E 01 AC 38 00 00 05 7F C3 F3 78 38 80 00 01 44 00 00 02 7C 00 00 26 74 09 10 00 7C 7E 1B 78 40 82 01 5C 2F 83 00 01 40 9E 01 5C 38 80 00 02 4? ?? ?? ?? 3F C0 ?? ?? 3B DE ?? ?? 7F C3 F3 78 4? ?? ?? ?? 38 A0 00 00 7C 64 1B 78 38 C0 00 00 7F C3 F3 78 4C C6 31 82 4? ?? ?? ?? 38 60 00 04 4? ?? ?? ?? 3B 40 00 16 4B FF FD 60 80 1B 00 00 3B 40 FF FF 2F 80 00 09 40 9E FD 34 4B FF FE B0 3D 20 ?? ?? 39 29 ?? ?? 54 00 10 3A 7C 09 00 2E 7D 20 4A 14 7D 29 03 A6 4E 80 04 20 4? ?? ?? ?? 38 00 00 0D 90 03 00 00 3B 40 FF FF 4B FF FE 70 4? ?? ?? ?? 38 00 00 16 90 03 00 00 3B 40 FF FF 4B FF FE 5C 4? ?? ?? ?? 38 00 00 09 90 03 00 00 3B 40 FF FF 4B FF FE 48 4? ?? ?? ?? 38 00 00 0C 90 03 00 00 3B 40 FF FF 4B FF FE 34 38 60 00 01 4? ?? ?? ?? 38 60 00 45 4? ?? ?? ?? 2F 83 FF FF 7C 66 1B 78 41 9E 00 60 38 06 00 1E 81 21 00 00 54 00 00 36 7C 00 00 D0 7D 21 01 6E 3C 60 ?? ?? 38 63 ?? ?? 38 A1 00 17 38 9F 00 1C 54 A5 00 36 38 FF 00 08 4? ?? ?? ?? 81 3F 00 08 2F 89 00 00 41 9E 00 0C 80 09 00 08 90 1B ?? ?? 80 BB ?? ?? 2F 85 FF FF 40 BE FD 80 4? ?? ?? ?? 7C 65 1B 78 4B FF FD 74 38 C0 04 00 4B FF FF A0 38 00 00 16 90 1B 00 00 3B 40 FF FF 4B FF FD B4 4? ?? ?? ?? 93 C3 00 00 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 00 24 38 C6 ?? ?? 4? ?? ?? ?? 4? ?? ?? ?? 93 A3 00 00 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 00 22 38 C6 ?? ?? 4? ?? ?? ?? }
	condition:
		$1
}

rule file_46_0_0 {
	meta:
		name = "atol"
		size = 40
		refs = "0014 strtol"
		altNames = "atoi atoll"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 38 80 00 00 38 A0 00 0A 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_47_0_0 {
	meta:
		name = "__getpwuid_r"
		size = 696
		refs = "0002 __nss_not_use_nscd_passwd 006e __nss_database_custom 00c2 _GLOBAL_OFFSET_TABLE_ 00ca __libc_errno 00dc _dl_mcount_wrapper_check 0130 __nss_next2 0244 __nscd_getpwuid_r 0268 __nss_passwd_lookup2"
	strings:
		$1 = { 3D 20 ?? ?? 94 21 FF C0 7C 08 02 A6 81 69 ?? ?? 92 E1 00 1C 7C F7 3B 78 2F 8B 00 00 93 41 00 28 7C DA 33 78 93 61 00 2C 7C BB 2B 78 93 81 00 30 7C 7C 1B 78 93 A1 00 34 7C 9D 23 78 90 01 00 44 93 01 00 20 93 21 00 24 93 C1 00 38 93 E1 00 3C 40 9D 01 CC 39 6B 00 01 2F 8B 00 64 91 69 ?? ?? 40 9D 00 1C 38 00 00 00 90 09 ?? ?? 3D 20 ?? ?? 88 09 ?? ?? 2F 80 00 00 41 9E 01 B8 3F E0 ?? ?? 88 1F ?? ?? 3B DF ?? ?? 2F 80 00 00 41 9E 01 C8 81 62 8F F4 81 3E 00 04 81 5E 00 08 7D 29 5A 78 38 09 00 01 91 21 00 08 7C 00 00 34 54 00 D9 7E 7D 4B 5A 78 2F 80 00 00 91 61 00 0C 40 9E 01 28 3F 00 ?? ?? 3B 18 ?? ?? 83 D8 ?? ?? 3F 20 ?? ?? 7F DE 12 14 3B 39 ?? ?? 80 61 00 0C 4? ?? ?? ?? 80 01 00 0C 7F A4 EB 78 7F 65 DB 78 7C 09 03 A6 7F 46 D3 78 7F C7 F3 78 7F 83 E3 78 4E 80 04 21 7F 24 CB 78 7C 7F 1B 78 2F 9F FF FE 38 61 00 08 38 A0 00 00 38 C1 00 0C 7F E7 FB 78 39 00 00 00 40 9E 00 10 80 1E 00 00 2F 80 00 22 41 9E 00 C4 4? ?? ?? ?? 2F 83 00 00 41 9E FF A0 2F 9F 00 01 41 9E 00 5C 2B 9F 00 01 38 00 00 00 90 17 00 00 40 9D 01 60 81 38 ?? ?? 7D 29 12 14 80 69 00 00 2F 83 00 22 41 9E 00 A8 80 01 00 44 82 E1 00 1C 7C 08 03 A6 83 01 00 20 83 21 00 24 83 41 00 28 83 61 00 2C 83 81 00 30 83 A1 00 34 83 C1 00 38 83 E1 00 3C 38 21 00 40 4E 80 00 20 93 B7 00 00 38 60 00 00 80 01 00 44 83 18 ?? ?? 7F 18 12 14 82 E1 00 1C 7C 08 03 A6 90 78 00 00 83 01 00 20 83 21 00 24 83 41 00 28 83 61 00 2C 83 81 00 30 83 A1 00 34 83 C1 00 38 83 E1 00 3C 38 21 00 40 4E 80 00 20 3F 00 ?? ?? 3B E0 FF FF 3B 18 ?? ?? 81 38 ?? ?? 7D 29 12 14 80 69 00 00 38 00 00 00 90 17 00 00 2F 83 00 22 40 9E FF 60 2F 9F FF FE 41 BE FF 58 38 60 00 16 4B FF FF 8C 40 BE FE 60 3D 20 ?? ?? 88 09 ?? ?? 2F 80 00 00 40 9E FE 50 7F 83 E3 78 7F A4 EB 78 7F 65 DB 78 7F 46 D3 78 7E E7 BB 78 4? ?? ?? ?? 2C 03 00 00 40 80 FF 1C 4B FF FE 2C 3C 80 ?? ?? 38 61 00 08 38 84 ?? ?? 38 A0 00 00 38 C1 00 0C 4? ?? ?? ?? 2F 83 00 00 40 9E 00 30 80 02 8F F4 81 21 00 0C 81 61 00 08 7D 29 02 78 7D 60 02 78 91 3E 00 08 90 1E 00 04 7C 00 06 AC 38 00 00 01 98 1F ?? ?? 4B FF FE 20 80 02 8F F4 7C 00 00 F8 90 1E 00 04 4B FF FF E4 38 60 00 00 4B FF FE F0 }
	condition:
		$1
}

rule file_214_0_0 {
	meta:
		name = "__getgrgid_r"
		size = 696
		refs = "0002 __nss_not_use_nscd_group 006e __nss_database_custom 00c2 _GLOBAL_OFFSET_TABLE_ 00ca __libc_errno 00dc _dl_mcount_wrapper_check 0130 __nss_next2 0244 __nscd_getgrgid_r 0268 __nss_group_lookup2"
	strings:
		$1 = { 3D 20 ?? ?? 94 21 FF C0 7C 08 02 A6 81 69 ?? ?? 92 E1 00 1C 7C F7 3B 78 2F 8B 00 00 93 41 00 28 7C DA 33 78 93 61 00 2C 7C BB 2B 78 93 81 00 30 7C 7C 1B 78 93 A1 00 34 7C 9D 23 78 90 01 00 44 93 01 00 20 93 21 00 24 93 C1 00 38 93 E1 00 3C 40 9D 01 CC 39 6B 00 01 2F 8B 00 64 91 69 ?? ?? 40 9D 00 1C 38 00 00 00 90 09 ?? ?? 3D 20 ?? ?? 88 09 ?? ?? 2F 80 00 00 41 9E 01 B8 3F E0 ?? ?? 88 1F ?? ?? 3B DF ?? ?? 2F 80 00 00 41 9E 01 C8 81 62 8F F4 81 3E 00 04 81 5E 00 08 7D 29 5A 78 38 09 00 01 91 21 00 08 7C 00 00 34 54 00 D9 7E 7D 4B 5A 78 2F 80 00 00 91 61 00 0C 40 9E 01 28 3F 00 ?? ?? 3B 18 ?? ?? 83 D8 ?? ?? 3F 20 ?? ?? 7F DE 12 14 3B 39 ?? ?? 80 61 00 0C 4? ?? ?? ?? 80 01 00 0C 7F A4 EB 78 7F 65 DB 78 7C 09 03 A6 7F 46 D3 78 7F C7 F3 78 7F 83 E3 78 4E 80 04 21 7F 24 CB 78 7C 7F 1B 78 2F 9F FF FE 38 61 00 08 38 A0 00 00 38 C1 00 0C 7F E7 FB 78 39 00 00 00 40 9E 00 10 80 1E 00 00 2F 80 00 22 41 9E 00 C4 4? ?? ?? ?? 2F 83 00 00 41 9E FF A0 2F 9F 00 01 41 9E 00 5C 2B 9F 00 01 38 00 00 00 90 17 00 00 40 9D 01 60 81 38 ?? ?? 7D 29 12 14 80 69 00 00 2F 83 00 22 41 9E 00 A8 80 01 00 44 82 E1 00 1C 7C 08 03 A6 83 01 00 20 83 21 00 24 83 41 00 28 83 61 00 2C 83 81 00 30 83 A1 00 34 83 C1 00 38 83 E1 00 3C 38 21 00 40 4E 80 00 20 93 B7 00 00 38 60 00 00 80 01 00 44 83 18 ?? ?? 7F 18 12 14 82 E1 00 1C 7C 08 03 A6 90 78 00 00 83 01 00 20 83 21 00 24 83 41 00 28 83 61 00 2C 83 81 00 30 83 A1 00 34 83 C1 00 38 83 E1 00 3C 38 21 00 40 4E 80 00 20 3F 00 ?? ?? 3B E0 FF FF 3B 18 ?? ?? 81 38 ?? ?? 7D 29 12 14 80 69 00 00 38 00 00 00 90 17 00 00 2F 83 00 22 40 9E FF 60 2F 9F FF FE 41 BE FF 58 38 60 00 16 4B FF FF 8C 40 BE FE 60 3D 20 ?? ?? 88 09 ?? ?? 2F 80 00 00 40 9E FE 50 7F 83 E3 78 7F A4 EB 78 7F 65 DB 78 7F 46 D3 78 7E E7 BB 78 4? ?? ?? ?? 2C 03 00 00 40 80 FF 1C 4B FF FE 2C 3C 80 ?? ?? 38 61 00 08 38 84 ?? ?? 38 A0 00 00 38 C1 00 0C 4? ?? ?? ?? 2F 83 00 00 40 9E 00 30 80 02 8F F4 81 21 00 0C 81 61 00 08 7D 29 02 78 7D 60 02 78 91 3E 00 08 90 1E 00 04 7C 00 06 AC 38 00 00 01 98 1F ?? ?? 4B FF FE 20 80 02 8F F4 7C 00 00 F8 90 1E 00 04 4B FF FF E4 38 60 00 00 4B FF FE F0 }
	condition:
		$1
}

rule file_71_0_0 {
	meta:
		name = "__getgrnam_r"
		size = 696
		refs = "0002 __nss_not_use_nscd_group 006e __nss_database_custom 00c2 _GLOBAL_OFFSET_TABLE_ 00ca __libc_errno 00dc _dl_mcount_wrapper_check 0130 __nss_next2 0244 __nscd_getgrnam_r 0268 __nss_group_lookup2"
	strings:
		$1 = { 3D 20 ?? ?? 94 21 FF C0 7C 08 02 A6 81 69 ?? ?? 92 E1 00 1C 7C F7 3B 78 2F 8B 00 00 93 41 00 28 7C DA 33 78 93 61 00 2C 7C BB 2B 78 93 81 00 30 7C 7C 1B 78 93 A1 00 34 7C 9D 23 78 90 01 00 44 93 01 00 20 93 21 00 24 93 C1 00 38 93 E1 00 3C 40 9D 01 CC 39 6B 00 01 2F 8B 00 64 91 69 ?? ?? 40 9D 00 1C 38 00 00 00 90 09 ?? ?? 3D 20 ?? ?? 88 09 ?? ?? 2F 80 00 00 41 9E 01 B8 3F E0 ?? ?? 88 1F ?? ?? 3B DF ?? ?? 2F 80 00 00 41 9E 01 C8 81 62 8F F4 81 3E 00 04 81 5E 00 08 7D 29 5A 78 38 09 00 01 91 21 00 08 7C 00 00 34 54 00 D9 7E 7D 4B 5A 78 2F 80 00 00 91 61 00 0C 40 9E 01 28 3F 00 ?? ?? 3B 18 ?? ?? 83 D8 ?? ?? 3F 20 ?? ?? 7F DE 12 14 3B 39 ?? ?? 80 61 00 0C 4? ?? ?? ?? 80 01 00 0C 7F A4 EB 78 7F 65 DB 78 7C 09 03 A6 7F 46 D3 78 7F C7 F3 78 7F 83 E3 78 4E 80 04 21 7F 24 CB 78 7C 7F 1B 78 2F 9F FF FE 38 61 00 08 38 A0 00 00 38 C1 00 0C 7F E7 FB 78 39 00 00 00 40 9E 00 10 80 1E 00 00 2F 80 00 22 41 9E 00 C4 4? ?? ?? ?? 2F 83 00 00 41 9E FF A0 2F 9F 00 01 41 9E 00 5C 2B 9F 00 01 38 00 00 00 90 17 00 00 40 9D 01 60 81 38 ?? ?? 7D 29 12 14 80 69 00 00 2F 83 00 22 41 9E 00 A8 80 01 00 44 82 E1 00 1C 7C 08 03 A6 83 01 00 20 83 21 00 24 83 41 00 28 83 61 00 2C 83 81 00 30 83 A1 00 34 83 C1 00 38 83 E1 00 3C 38 21 00 40 4E 80 00 20 93 B7 00 00 38 60 00 00 80 01 00 44 83 18 ?? ?? 7F 18 12 14 82 E1 00 1C 7C 08 03 A6 90 78 00 00 83 01 00 20 83 21 00 24 83 41 00 28 83 61 00 2C 83 81 00 30 83 A1 00 34 83 C1 00 38 83 E1 00 3C 38 21 00 40 4E 80 00 20 3F 00 ?? ?? 3B E0 FF FF 3B 18 ?? ?? 81 38 ?? ?? 7D 29 12 14 80 69 00 00 38 00 00 00 90 17 00 00 2F 83 00 22 40 9E FF 60 2F 9F FF FE 41 BE FF 58 38 60 00 16 4B FF FF 8C 40 BE FE 60 3D 20 ?? ?? 88 09 ?? ?? 2F 80 00 00 40 9E FE 50 7F 83 E3 78 7F A4 EB 78 7F 65 DB 78 7F 46 D3 78 7E E7 BB 78 4? ?? ?? ?? 2C 03 00 00 40 80 FF 1C 4B FF FE 2C 3C 80 ?? ?? 38 61 00 08 38 84 ?? ?? 38 A0 00 00 38 C1 00 0C 4? ?? ?? ?? 2F 83 00 00 40 9E 00 30 80 02 8F F4 81 21 00 0C 81 61 00 08 7D 29 02 78 7D 60 02 78 91 3E 00 08 90 1E 00 04 7C 00 06 AC 38 00 00 01 98 1F ?? ?? 4B FF FE 20 80 02 8F F4 7C 00 00 F8 90 1E 00 04 4B FF FF E4 38 60 00 00 4B FF FE F0 }
	condition:
		$1
}

rule file_323_0_0 {
	meta:
		name = "__getpwnam_r"
		size = 696
		refs = "0002 __nss_not_use_nscd_passwd 006e __nss_database_custom 00c2 _GLOBAL_OFFSET_TABLE_ 00ca __libc_errno 00dc _dl_mcount_wrapper_check 0130 __nss_next2 0244 __nscd_getpwnam_r 0268 __nss_passwd_lookup2"
	strings:
		$1 = { 3D 20 ?? ?? 94 21 FF C0 7C 08 02 A6 81 69 ?? ?? 92 E1 00 1C 7C F7 3B 78 2F 8B 00 00 93 41 00 28 7C DA 33 78 93 61 00 2C 7C BB 2B 78 93 81 00 30 7C 7C 1B 78 93 A1 00 34 7C 9D 23 78 90 01 00 44 93 01 00 20 93 21 00 24 93 C1 00 38 93 E1 00 3C 40 9D 01 CC 39 6B 00 01 2F 8B 00 64 91 69 ?? ?? 40 9D 00 1C 38 00 00 00 90 09 ?? ?? 3D 20 ?? ?? 88 09 ?? ?? 2F 80 00 00 41 9E 01 B8 3F E0 ?? ?? 88 1F ?? ?? 3B DF ?? ?? 2F 80 00 00 41 9E 01 C8 81 62 8F F4 81 3E 00 04 81 5E 00 08 7D 29 5A 78 38 09 00 01 91 21 00 08 7C 00 00 34 54 00 D9 7E 7D 4B 5A 78 2F 80 00 00 91 61 00 0C 40 9E 01 28 3F 00 ?? ?? 3B 18 ?? ?? 83 D8 ?? ?? 3F 20 ?? ?? 7F DE 12 14 3B 39 ?? ?? 80 61 00 0C 4? ?? ?? ?? 80 01 00 0C 7F A4 EB 78 7F 65 DB 78 7C 09 03 A6 7F 46 D3 78 7F C7 F3 78 7F 83 E3 78 4E 80 04 21 7F 24 CB 78 7C 7F 1B 78 2F 9F FF FE 38 61 00 08 38 A0 00 00 38 C1 00 0C 7F E7 FB 78 39 00 00 00 40 9E 00 10 80 1E 00 00 2F 80 00 22 41 9E 00 C4 4? ?? ?? ?? 2F 83 00 00 41 9E FF A0 2F 9F 00 01 41 9E 00 5C 2B 9F 00 01 38 00 00 00 90 17 00 00 40 9D 01 60 81 38 ?? ?? 7D 29 12 14 80 69 00 00 2F 83 00 22 41 9E 00 A8 80 01 00 44 82 E1 00 1C 7C 08 03 A6 83 01 00 20 83 21 00 24 83 41 00 28 83 61 00 2C 83 81 00 30 83 A1 00 34 83 C1 00 38 83 E1 00 3C 38 21 00 40 4E 80 00 20 93 B7 00 00 38 60 00 00 80 01 00 44 83 18 ?? ?? 7F 18 12 14 82 E1 00 1C 7C 08 03 A6 90 78 00 00 83 01 00 20 83 21 00 24 83 41 00 28 83 61 00 2C 83 81 00 30 83 A1 00 34 83 C1 00 38 83 E1 00 3C 38 21 00 40 4E 80 00 20 3F 00 ?? ?? 3B E0 FF FF 3B 18 ?? ?? 81 38 ?? ?? 7D 29 12 14 80 69 00 00 38 00 00 00 90 17 00 00 2F 83 00 22 40 9E FF 60 2F 9F FF FE 41 BE FF 58 38 60 00 16 4B FF FF 8C 40 BE FE 60 3D 20 ?? ?? 88 09 ?? ?? 2F 80 00 00 40 9E FE 50 7F 83 E3 78 7F A4 EB 78 7F 65 DB 78 7F 46 D3 78 7E E7 BB 78 4? ?? ?? ?? 2C 03 00 00 40 80 FF 1C 4B FF FE 2C 3C 80 ?? ?? 38 61 00 08 38 84 ?? ?? 38 A0 00 00 38 C1 00 0C 4? ?? ?? ?? 2F 83 00 00 40 9E 00 30 80 02 8F F4 81 21 00 0C 81 61 00 08 7D 29 02 78 7D 60 02 78 91 3E 00 08 90 1E 00 04 7C 00 06 AC 38 00 00 01 98 1F ?? ?? 4B FF FE 20 80 02 8F F4 7C 00 00 F8 90 1E 00 04 4B FF FF E4 38 60 00 00 4B FF FE F0 }
	condition:
		$1
}

rule file_48_0_0 {
	meta:
		name = "__futimes"
		size = 632
		refs = "00e6 _GLOBAL_OFFSET_TABLE_ 00ee __libc_errno 0150 _itoa_word"
	strings:
		$1 = { 7D 80 00 26 2E 04 00 00 94 21 FF B0 7C 08 02 A6 93 C1 00 48 7C 7E 1B 78 93 E1 00 4C 7C 9F 23 78 90 01 00 54 93 A1 00 44 91 81 00 40 41 92 00 4C 81 64 00 04 3D 20 00 0F 61 29 42 3F 7F 8B 48 40 41 9D 00 A4 80 04 00 0C 2F 80 00 00 41 9C 00 98 7F 80 48 00 41 9D 00 90 81 44 00 00 1D 6B 03 E8 81 24 00 08 1C 00 03 E8 91 41 00 08 91 61 00 0C 91 21 00 10 90 01 00 14 3F A0 ?? ?? 80 1D ?? ?? 2F 80 00 00 40 9E 00 B4 41 92 00 54 38 A1 00 08 38 00 01 30 7F C3 F3 78 38 80 00 00 38 C0 00 00 44 00 00 02 7C 00 00 26 74 09 10 00 40 82 00 58 2F 83 FF FF 41 9E 01 B8 80 01 00 54 81 81 00 40 7C 08 03 A6 83 A1 00 44 83 C1 00 48 7D 80 81 20 83 E1 00 4C 38 21 00 50 4E 80 00 20 38 A0 00 00 4B FF FF B0 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 38 00 00 16 90 09 00 00 38 60 FF FF 4B FF FF B8 3D 20 ?? ?? 39 29 ?? ?? 81 69 ?? ?? 7D 6B 12 14 90 6B 00 00 81 29 ?? ?? 7D 29 12 14 80 09 00 00 38 60 FF FF 2F 80 00 26 40 9E FF 8C 38 00 00 01 90 1D ?? ?? 7C 24 0B 78 38 00 00 00 9C 04 00 32 7F C3 F3 78 38 A0 00 0A 38 C0 00 00 4? ?? ?? ?? 3D 60 ?? ?? 39 2B ?? ?? 80 0B ?? ?? 81 09 00 04 7F E4 FB 78 81 49 00 08 A1 69 00 0C 39 23 FF F2 90 03 FF F2 38 00 00 FB 91 03 FF F6 7D 23 4B 78 91 49 00 08 B1 69 00 0C 44 00 00 02 7C 00 00 26 74 09 10 00 40 82 00 A4 2F 83 FF FF 40 9E FF 18 3D 20 ?? ?? 39 29 ?? ?? 83 E9 ?? ?? 7F FF 12 14 80 1F 00 00 2F 80 00 14 41 9E 00 30 41 9D 00 1C 2F 80 00 02 41 9E 00 3C 2F 80 00 0D 41 9E 00 90 38 60 FF FF 4B FF FE E0 2F 80 00 24 41 9E 00 0C 2F 80 00 28 40 9E FF EC 81 29 ?? ?? 7D 29 12 14 38 00 00 26 90 09 00 00 38 60 FF FF 4B FF FE B8 38 00 00 37 7F C3 F3 78 38 80 00 01 38 A0 00 00 44 00 00 02 7C 00 00 26 74 09 10 00 40 82 00 34 2F 83 FF FF 38 60 FF FF 41 BE FE 8C 38 00 00 26 90 1F 00 00 4B FF FE 80 3D 20 ?? ?? 39 29 ?? ?? 81 69 ?? ?? 7D 6B 12 14 90 6B 00 00 4B FF FF 5C 90 7F 00 00 38 60 FF FF 4B FF FE 5C 40 92 FF 8C 38 60 FF FF 4B FF FE 50 3D 20 ?? ?? 39 29 ?? ?? 4B FF FE A4 }
	condition:
		$1
}

rule file_49_0_0 {
	meta:
		name = "wmemset"
		size = 116
	strings:
		$1 = { 2B 85 00 03 7C 69 1B 78 40 9D 00 44 39 65 FF FC 55 6B F0 BE 39 6B 00 01 7D 69 03 A6 90 89 00 00 90 89 00 04 90 89 00 08 90 89 00 0C 39 29 00 10 42 00 FF EC 38 A5 FF FC 54 A9 F0 BE 39 29 00 01 55 29 20 36 7D 23 4A 14 54 A5 07 BE 2F 85 00 00 4D 9E 00 20 2F 85 00 01 90 89 00 00 4D 9E 00 20 2F 85 00 03 90 89 00 04 4C 9E 00 20 90 89 00 08 4E 80 00 20 }
	condition:
		$1
}

rule file_50_0_0 {
	meta:
		name = "fdatasync"
		size = 116
		refs = "0018 __syscall_error 002c __libc_enable_asynccancel 0050 __libc_disable_asynccancel"
	strings:
		$1 = { 81 42 8B 60 2C 0A 00 00 40 82 00 14 38 00 00 94 44 00 00 02 4C A3 00 20 4? ?? ?? ?? 94 21 FF D0 7D 28 02 A6 91 21 00 34 90 61 00 14 4? ?? ?? ?? 90 61 00 10 80 61 00 14 38 00 00 94 44 00 00 02 7C 00 00 26 90 61 00 08 90 01 00 0C 80 61 00 10 4? ?? ?? ?? 80 81 00 34 80 01 00 0C 80 61 00 08 7C 88 03 A6 7C 0F F1 20 38 21 00 30 4C A3 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_50_1_0 {
	meta:
		name = "__fdatasync_nocancel"
		size = 16
		refs = "000c __syscall_error"
	strings:
		$1 = { 38 00 00 94 44 00 00 02 4C A3 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_51_0_0 {
	meta:
		name = "_dl_add_to_namespace_list"
		size = 224
		refs = "000a __pthread_mutex_lock 002e _dl_load_write_lock 003e _dl_ns 006e __pthread_mutex_unlock 007a _dl_load_adds"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 3D 20 ?? ?? 90 01 00 14 38 09 ?? ?? 2F 80 00 00 93 C1 00 08 7C 9E 23 78 93 E1 00 0C 7C 7F 1B 78 41 9E 00 10 3C 60 ?? ?? 38 63 ?? ?? 4? ?? ?? ?? 1F DE 00 4C 3D 60 ?? ?? 39 6B ?? ?? 7D 2B F0 2E 2F 89 00 00 40 BE 00 0C 48 00 00 88 7C 09 03 78 80 09 00 0C 2F 80 00 00 40 9E FF F4 91 3F 00 10 93 E9 00 0C 3D 20 ?? ?? 38 09 ?? ?? 2F 80 00 00 3D 00 ?? ?? 39 08 ?? ?? 7F CB F2 14 81 28 00 00 81 48 00 04 80 FE 00 04 31 8A 00 01 7D 69 01 94 91 3F 02 50 38 07 00 01 91 5F 02 54 90 1E 00 04 91 68 00 00 91 88 00 04 41 9E 00 10 3C 60 ?? ?? 38 63 ?? ?? 4? ?? ?? ?? 80 01 00 14 83 C1 00 08 7C 08 03 A6 83 E1 00 0C 38 21 00 10 4E 80 00 20 7F EB F1 2E 4B FF FF 90 }
	condition:
		$1
}

rule file_51_1_0 {
	meta:
		name = "_dl_new_object"
		size = 720
		refs = "004c strlen 0060 calloc 008c memcpy 0096 _dl_debug_mask 00c6 _dl_ns 017e _GLOBAL_OFFSET_TABLE_ 0186 __libc_errno 0194 realloc 01a8 __getcwd 01cc free 0248 malloc 0260 mempcpy 02a4 strchr"
	strings:
		$1 = { 94 21 FF D0 7C 08 02 A6 93 E1 00 2C 7C 7F 1B 78 7C 83 23 78 90 01 00 34 92 E1 00 0C 93 21 00 14 7D 19 43 78 93 41 00 18 93 61 00 1C 7C FB 3B 78 93 81 00 20 7C DC 33 78 93 A1 00 24 7C BD 2B 78 93 C1 00 28 7C 9E 23 78 93 01 00 10 4? ?? ?? ?? 7C 65 1B 78 38 80 00 01 38 63 02 69 3A E5 00 01 4? ?? ?? ?? 7C 7A 1B 79 41 82 01 6C 38 1A 02 58 93 5A 00 14 3B 1A 02 5C 90 1A 01 68 38 7A 02 68 7F C4 F3 78 93 1A 00 1C 7E E5 BB 78 4? ?? ?? ?? 80 1A 01 98 3D 60 ?? ?? 90 7A 02 5C 53 A0 F0 02 90 1A 01 98 39 20 00 01 80 0B ?? ?? 91 3A 02 64 70 0B 01 00 93 FA 00 04 41 82 01 54 1C 19 00 4C 93 9A 01 70 3D 20 ?? ?? 93 3A 00 18 39 29 ?? ?? 7D 49 00 2E 38 00 FF FF 39 7A 01 BC 90 1A 02 3C 2F 8A 00 00 38 00 00 04 91 7A 01 D0 39 20 00 00 90 1A 01 CC 41 9E 00 10 39 4A 01 60 91 5A 01 BC 39 20 00 01 2F 9C 00 00 40 BE 00 0C 48 00 01 28 7C 1C 03 78 80 1C 01 70 2F 80 00 00 40 9E FF F4 2F 89 00 00 40 9E 00 F0 3B 9C 01 60 73 60 00 08 55 29 10 3A 41 82 00 14 41 9E 00 F0 80 1A 01 BC 39 20 00 00 90 1A 01 C0 7F 8B 49 2E 38 1A 01 60 90 1A 01 D4 8B DF 00 00 2F 9E 00 00 41 9E 00 78 7F E3 FB 78 4? ?? ?? ?? 2F 9E 00 2F 3B 63 00 01 3B A0 00 80 3B 80 00 00 41 9E 00 CC 3F 20 ?? ?? 3B 39 ?? ?? 83 39 ?? ?? 7F 39 12 14 7C 9D DA 14 7F 83 E3 78 4? ?? ?? ?? 7F A4 EB 78 7C 7E 1B 79 3B BD 00 80 41 82 00 20 4? ?? ?? ?? 7F DC F3 78 2F 83 00 00 40 9E 00 E8 80 19 00 00 2F 80 00 22 41 9E FF CC 7F 83 E3 78 3B C0 FF FF 4? ?? ?? ?? 93 DA 01 AC 80 01 00 34 7F 43 D3 78 82 E1 00 0C 7C 08 03 A6 83 01 00 10 83 21 00 14 83 41 00 18 83 61 00 1C 83 81 00 20 83 A1 00 24 83 C1 00 28 83 E1 00 2C 38 21 00 30 4E 80 00 20 91 3A 02 04 4B FF FE AC 80 1A 01 BC 3B 9C 01 60 7F 00 E0 00 40 9A FF 0C 4B FF FF 28 39 20 00 00 7F 8B 49 2E 4B FF FF 1C 2F 89 00 00 7F 5C D3 78 40 BE FF D8 4B FF FE E8 7F 63 DB 78 4? ?? ?? ?? 7C 7E 1B 79 41 82 00 74 7F C3 F3 78 7F E4 FB 78 7F 65 DB 78 4? ?? ?? ?? 48 00 00 08 7D 23 4B 78 88 03 FF FF 39 23 FF FF 2F 80 00 2F 40 9E FF F0 7F 9E 48 00 41 9E 00 14 38 00 00 00 98 09 00 00 93 DA 01 AC 4B FF FF 44 7C 69 1B 78 4B FF FF EC 7F C3 F3 78 38 80 00 00 4? ?? ?? ?? 88 03 FF FF 2F 80 00 2F 41 BE FF A8 38 00 00 2F 98 03 00 00 38 63 00 01 4B FF FF 98 3B C0 FF FF 93 DA 01 AC 4B FF FF 08 }
	condition:
		$1
}

rule file_53_0_0 {
	meta:
		name = "__atfct_seterrno_2"
		size = 584
		refs = "0032 _GLOBAL_OFFSET_TABLE_ 003a __libc_errno 0070 __fxstat64 00d4 __xstat64 0110 strchr 0128 __lxstat64"
	strings:
		$1 = { 94 21 FF 70 7C 08 02 A6 93 C1 00 88 7C BE 2B 79 93 E1 00 8C 7C 7F 1B 78 90 01 00 94 41 82 01 A8 2F 9F 00 14 41 9E 00 38 2F 9F 00 02 41 9E 00 D4 3F C0 ?? ?? 3B DE ?? ?? 83 DE ?? ?? 7F DE 12 14 93 FE 00 00 80 01 00 94 83 C1 00 88 7C 08 03 A6 83 E1 00 8C 38 21 00 90 4E 80 00 20 41 82 00 38 38 60 00 03 90 C1 00 78 38 A1 00 08 90 E1 00 7C 4? ?? ?? ?? 2F 83 00 00 80 C1 00 78 80 E1 00 7C 40 BE FF C4 80 01 00 18 54 00 04 26 2F 80 40 00 41 9E 01 80 2F 87 00 00 41 BE FF 98 38 60 00 03 7C C4 33 78 38 A1 00 08 4? ?? ?? ?? 2F 83 00 00 40 BE FF 94 80 01 00 18 54 00 04 26 2F 80 40 00 40 9E FF 70 3C 80 ?? ?? 38 60 00 03 38 84 ?? ?? 38 A1 00 08 4? ?? ?? ?? 2F 83 00 00 40 9E 00 14 80 01 00 18 54 00 04 26 2F 80 40 00 41 BE FF 44 3F C0 ?? ?? 3B E0 00 26 3B DE ?? ?? 4B FF FF 3C 41 82 00 5C 38 80 00 2F 90 E1 00 7C 38 7E 00 0E 4? ?? ?? ?? 38 00 00 00 98 03 00 00 7F C4 F3 78 38 60 00 03 38 A1 00 08 4? ?? ?? ?? 80 E1 00 7C 2F 83 FF FF 41 9E 00 9C 2F 83 00 00 40 9E 00 20 81 21 00 18 55 29 04 26 6D 20 FF FF 2F 80 A0 00 41 9E 00 0C 3B E0 00 09 4B FF FE D8 3F C0 ?? ?? 3B DE ?? ?? 2F 87 00 00 41 BE FE D0 38 80 00 2F 90 E1 00 7C 38 67 00 0E 4? ?? ?? ?? 38 00 00 00 98 03 00 00 38 A1 00 08 38 60 00 03 80 E1 00 7C 7C E4 3B 78 4? ?? ?? ?? 2F 83 FF FF 41 9E 00 58 2F 83 00 00 40 BE FE 94 81 21 00 18 55 29 04 26 6D 20 FF FF 2F 80 A0 00 41 9E FE 80 3B E0 00 09 4B FF FE 78 2F 87 00 00 40 9E FE 58 4B FF FE 64 3F C0 ?? ?? 3B DE ?? ?? 81 3E ?? ?? 7D 29 12 14 80 09 00 00 2F 80 00 02 40 9E FF 7C 3B E0 00 09 4B FF FE 48 81 3E ?? ?? 7D 29 12 14 80 09 00 00 2F 80 00 02 40 9E FE 34 3B E0 00 09 4B FF FE 2C 3C 80 ?? ?? 38 60 00 03 38 84 ?? ?? 38 A1 00 08 4? ?? ?? ?? 80 C1 00 78 2F 83 00 00 80 E1 00 7C 40 BE FE C0 80 01 00 18 54 00 04 26 2F 80 40 00 40 9E FE B0 4B FF FE 50 }
	condition:
		$1
}

rule file_53_1_0 {
	meta:
		name = "renameat"
		size = 532
		refs = "000e __have_atfcts 00a2 _GLOBAL_OFFSET_TABLE_ 00aa __libc_errno 00dc strlen 0120 __snprintf 01bc __atfct_seterrno_2"
	strings:
		$1 = { 94 21 FF D0 7C 08 02 A6 93 81 00 20 3F 80 ?? ?? 90 01 00 34 80 1C ?? ?? 93 41 00 18 7C BA 2B 78 2F 80 00 00 93 61 00 1C 7C 7B 1B 78 93 A1 00 24 7C 9D 23 78 93 C1 00 28 7C DE 33 78 93 E1 00 2C 7C 3F 0B 78 93 21 00 14 41 9C 00 7C 38 00 01 25 44 00 00 02 7C 00 00 26 74 09 10 00 40 82 01 80 2F 83 FF FF 7C 60 1B 78 41 9E 00 38 39 7F 00 30 7C 03 03 78 80 0B 00 04 83 2B FF E4 7C 08 03 A6 83 4B FF E8 83 6B FF EC 83 8B FF F0 83 AB FF F4 83 CB FF F8 83 EB FF FC 7D 61 5B 78 4E 80 00 20 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 81 29 00 00 38 00 FF FF 2F 89 00 26 40 9E FF B0 90 1C ?? ?? 2F 9B FF 9C 41 9E 01 00 88 1D 00 00 2F 80 00 2F 41 9E 00 F4 7F A3 EB 78 4? ?? ?? ?? 7C 64 1B 79 41 82 01 10 38 04 00 3E 81 21 00 00 54 00 00 36 7C 00 00 D0 7D 21 01 6E 3C A0 ?? ?? 7F A7 EB 78 3B 81 00 17 57 9C 00 36 7F 83 E3 78 38 84 00 20 38 A5 ?? ?? 7F 66 DB 78 4C C6 31 82 4? ?? ?? ?? 2F 9A FF 9C 7F 9D E3 78 41 9E 00 A8 88 1E 00 00 2F 80 00 2F 41 9E 00 9C 7F C3 F3 78 4? ?? ?? ?? 7C 64 1B 79 41 82 00 AC 38 04 00 3E 81 21 00 00 54 00 00 36 7C 00 00 D0 7D 21 01 6E 3C A0 ?? ?? 7F C7 F3 78 3B 21 00 17 57 39 00 36 7F 23 CB 78 38 84 00 20 38 A5 ?? ?? 7F 46 D3 78 4C C6 31 82 4? ?? ?? ?? 7F 3E CB 78 38 00 00 26 7F A3 EB 78 7F C4 F3 78 44 00 00 02 7C 00 00 26 74 09 10 00 7C 60 1B 78 41 82 FE C4 7F 44 D3 78 7F 25 CB 78 7F 66 DB 78 7F 87 E3 78 4? ?? ?? ?? 38 00 FF FF 4B FF FE A8 2F 9A FF 9C 3B 80 00 00 40 9E FF 60 3B 20 00 00 4B FF FF B4 3D 20 ?? ?? 39 29 ?? ?? 81 69 ?? ?? 7D 6B 12 14 90 6B 00 00 4B FF FE B8 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 38 00 00 02 7D 29 12 14 90 09 00 00 38 00 FF FF 4B FF FE 5C }
	condition:
		$1
}

rule file_54_0_0 {
	meta:
		name = "__getdate_r"
		size = 1428
		refs = "0044 getenv 00a0 __xstat64 00d4 __access 00f0 _IO_new_fopen 0158 strptime 0188 __getline 01c0 free 01d4 _IO_new_fclose 01f4 time 0200 __localtime_r 034c mktime 0470 memset"
		altNames = "getdate_r"
	strings:
		$1 = { 94 21 FF 00 7C 08 02 A6 93 A1 00 F4 7C 7D 1B 78 3C 60 ?? ?? 38 63 ?? ?? 93 41 00 E8 3B 40 00 01 93 C1 00 F8 93 E1 00 FC 7C 9F 23 78 90 01 01 04 92 E1 00 DC 93 01 00 E0 93 21 00 E4 93 61 00 EC 93 81 00 F0 4? ?? ?? ?? 7C 7E 1B 79 41 82 00 10 88 1E 00 00 2F 80 00 00 40 9E 00 3C 80 01 01 04 7F 43 D3 78 82 E1 00 DC 7C 08 03 A6 83 01 00 E0 83 21 00 E4 83 41 00 E8 83 61 00 EC 83 81 00 F0 83 A1 00 F4 83 C1 00 F8 83 E1 00 FC 38 21 01 00 4E 80 00 20 38 60 00 03 7F C4 F3 78 38 A1 00 70 4? ?? ?? ?? 3B 40 00 03 2F 83 00 00 41 BC FF B0 81 21 00 80 38 00 00 00 60 00 80 00 55 29 04 26 7F 89 00 00 3B 40 00 04 40 9E FF 94 7F C3 F3 78 38 80 00 04 4? ?? ?? ?? 3B 40 00 02 2F 83 00 00 41 BC FF 7C 3C 80 ?? ?? 7F C3 F3 78 38 84 ?? ?? 4? ?? ?? ?? 7C 7C 1B 79 41 A2 FF 64 81 3C 00 00 38 00 00 00 7C 39 0B 78 61 29 80 00 91 3C 00 00 3B 60 00 00 3A E0 00 00 90 01 00 08 3F C0 80 00 3B 00 FF FF 94 19 00 0C 3B 40 00 00 48 00 00 50 93 DF 00 18 93 DF 00 0C 93 DF 00 10 93 DF 00 14 93 DF 00 04 93 DF 00 00 93 DF 00 08 93 1F 00 20 93 5F 00 24 93 5F 00 28 4? ?? ?? ?? 7C 7B 1B 79 41 82 00 10 88 1B 00 00 2F 80 00 00 41 9E 00 50 80 1C 00 00 70 08 00 10 40 82 00 44 7F 85 E3 78 7F 24 CB 78 38 61 00 08 4? ?? ?? ?? 7F E5 FB 78 7C 69 1B 79 7F A3 EB 78 38 09 FF FF 41 80 00 20 80 81 00 08 7D 24 00 AE 2F 89 00 0A 40 9E FF 84 7E E4 01 AE 80 81 00 08 4B FF FF 78 80 61 00 08 4? ?? ?? ?? 80 1C 00 00 70 09 00 20 40 82 01 98 7F 83 E3 78 4? ?? ?? ?? 2F 9B 00 00 3B 40 00 07 41 BE FE 7C 88 1B 00 00 2F 80 00 00 40 9E FE 70 38 61 00 10 4? ?? ?? ?? 38 61 00 10 38 81 00 14 4? ?? ?? ?? 83 9F 00 18 2B 9C 00 06 41 9D 01 68 83 BF 00 14 3C 00 80 00 7F 9D 00 00 41 9E 02 B8 83 DF 00 10 39 00 00 00 2B 9E 00 0B 7F C9 F3 78 41 9D 00 14 80 1F 00 0C 3D 60 80 00 7F 80 58 00 41 9E 02 0C 80 1F 00 08 3D 60 80 00 7F 80 58 00 41 9E 01 AC 81 7F 00 04 7C 07 03 78 81 5F 00 00 3C C0 80 00 7F 8B 30 00 41 9E 01 88 3D 60 80 00 7F 8A 58 00 41 9E 01 70 2B 87 00 17 40 9D 01 08 7F C9 F3 78 3C 00 80 00 7F 9D 00 00 41 9E 01 A0 3C 00 80 00 7F 89 00 00 41 9E 01 88 2F 88 00 00 40 9E 00 A8 80 1F 00 10 81 5F 00 14 2B 80 00 0B 81 3F 00 0C 41 9D 01 28 3D 60 AB 50 7D 68 00 31 41 80 01 78 3D 60 14 A0 7D 68 00 31 41 80 01 04 3D 60 40 00 7D 68 00 31 40 80 01 04 2F 89 00 00 3B 40 00 08 40 BD FD 78 39 4A 07 6C 71 40 00 03 39 60 00 1C 40 82 00 48 3D 00 51 EB 61 08 85 1F 7D 0A 40 96 7D 40 FE 70 7D 0B 2E 70 7D 60 58 50 1D 6B 00 64 7F 8A 58 00 39 60 00 1D 40 9E 00 20 7D 08 3E 70 7C 00 40 50 1D 60 01 90 7D 4B 5A 78 7D 6B 00 34 55 6B D9 7E 39 6B 00 1C 7F 89 58 00 3B 40 00 08 41 BD FD 18 7F E3 FB 78 4? ?? ?? ?? 38 63 00 01 7C 63 00 34 54 63 D9 7E 54 7A 18 38 4B FF FC FC 7F 83 E3 78 4? ?? ?? ?? 3B 40 00 05 4B FF FC EC 39 00 00 00 83 BF 00 14 83 DF 00 10 4B FF FE A8 3D 60 80 00 7F 9E 58 00 40 9E FE F8 81 7F 00 0C 7F 8B F0 00 40 9E FE EC 81 7F 00 18 7F 8B F0 00 40 9E FE E0 81 21 00 1C 39 00 00 01 7C 09 00 50 81 21 00 24 54 0B 0F FE 80 01 00 20 91 3F 00 10 7C 0B 02 14 90 1F 00 0C 4B FF FE B8 39 29 FF FF 2B 89 00 1D 40 BD FF 70 3B 40 00 08 4B FF FC 7C 39 60 00 00 91 7F 00 00 4B FF FE 8C 39 60 00 00 91 7F 00 04 4B FF FE 74 81 7F 00 04 7F 8B 00 00 41 9E 01 40 81 5F 00 00 38 00 00 00 90 1F 00 08 7F C9 F3 78 38 E0 00 00 4B FF FE 44 80 01 00 24 90 1F 00 10 4B FF FE 74 80 01 00 28 90 1F 00 14 4B FF FE 5C 39 29 FF FF 2B 89 00 1E 40 BD FF 08 3B 40 00 08 4B FF FC 14 7F 9D 00 00 41 9E 01 28 3C 00 80 00 7F 9C 00 00 3B 60 00 01 41 9E 00 64 38 80 00 00 38 A0 00 2C 38 61 00 40 4? ?? ?? ?? 38 61 00 40 93 A1 00 54 3B 9C 00 07 93 C1 00 50 93 61 00 4C 4? ?? ?? ?? 3F 60 92 49 80 01 00 58 63 7B 24 93 83 BF 00 14 7C 00 E0 50 83 DF 00 10 7F 60 D8 96 7C 09 FE 70 7F 7B 02 14 7F 7B 16 70 7F 69 D8 50 1F 7B 00 07 7F 7B 00 50 3B 7B 00 01 93 7F 00 0C 7F C9 F3 78 39 00 00 01 4B FF FD 74 83 DF 00 10 39 00 00 00 7F 9E E8 00 40 9E FD 48 80 1F 00 0C 7F 80 F0 00 40 9E FD 3C 80 01 00 2C 39 3C 00 07 3D 60 92 49 83 A1 00 28 7C 00 48 50 83 C1 00 24 61 6B 24 93 93 BF 00 14 7D 60 58 96 93 DF 00 10 7C 09 FE 70 7D 6B 02 14 7D 6B 16 70 7D 29 58 50 1D 29 00 07 7C 09 00 50 81 21 00 20 39 00 00 01 7C 00 4A 14 90 1F 00 0C 4B FF FC E8 81 5F 00 00 7F 8A 58 00 40 9E FE C0 80 01 00 1C 81 61 00 18 7F 80 50 00 81 41 00 14 90 1F 00 08 91 7F 00 04 91 5F 00 00 41 9E FE A0 7C 07 03 78 4B FF FC EC 83 A1 00 24 80 01 00 28 7F BD F0 50 57 BD 0F FE 7F BD 02 14 93 BF 00 14 4B FF FE C4 }
	condition:
		$1
}

rule file_54_1_0 {
	meta:
		name = "getdate"
		size = 96
		refs = "001c __getdate_r 0042 getdate_err"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 93 E1 00 0C 3F E0 ?? ?? 3B FF ?? ?? 7F E4 FB 78 90 01 00 14 4? ?? ?? ?? 7C 60 1B 79 7F E3 FB 78 40 82 00 18 80 01 00 14 83 E1 00 0C 38 21 00 10 7C 08 03 A6 4E 80 00 20 3D 20 ?? ?? 83 E1 00 0C 90 09 ?? ?? 38 60 00 00 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_55_0_0 {
	meta:
		name = "__nss_ethers_lookup2"
		size = 168
		refs = "000e __nss_ethers_database 0058 __nss_lookup 0090 __nss_database_lookup"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 93 E1 00 1C 3F E0 ?? ?? 90 01 00 24 80 1F ?? ?? 93 61 00 0C 7C 9B 23 78 2F 80 00 00 93 81 00 10 7C BC 2B 78 93 A1 00 14 7C DD 33 78 38 DF ?? ?? 93 C1 00 18 7C 7E 1B 78 41 9E 00 40 90 1E 00 00 7F C3 F3 78 7F 64 DB 78 7F 85 E3 78 7F A6 EB 78 4? ?? ?? ?? 80 01 00 24 83 61 00 0C 7C 08 03 A6 83 81 00 10 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 3C 60 ?? ?? 38 63 ?? ?? 38 80 00 00 38 A0 00 00 4? ?? ?? ?? 2F 83 00 00 38 60 FF FF 41 BC FF C0 80 1F ?? ?? 4B FF FF A0 }
	condition:
		$1
}

rule file_862_0_0 {
	meta:
		name = "__nss_aliases_lookup2"
		size = 168
		refs = "000e __nss_aliases_database 0058 __nss_lookup 0090 __nss_database_lookup"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 93 E1 00 1C 3F E0 ?? ?? 90 01 00 24 80 1F ?? ?? 93 61 00 0C 7C 9B 23 78 2F 80 00 00 93 81 00 10 7C BC 2B 78 93 A1 00 14 7C DD 33 78 38 DF ?? ?? 93 C1 00 18 7C 7E 1B 78 41 9E 00 40 90 1E 00 00 7F C3 F3 78 7F 64 DB 78 7F 85 E3 78 7F A6 EB 78 4? ?? ?? ?? 80 01 00 24 83 61 00 0C 7C 08 03 A6 83 81 00 10 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 3C 60 ?? ?? 38 63 ?? ?? 38 80 00 00 38 A0 00 00 4? ?? ?? ?? 2F 83 00 00 38 60 FF FF 41 BC FF C0 80 1F ?? ?? 4B FF FF A0 }
	condition:
		$1
}

rule file_812_0_0 {
	meta:
		name = "__nss_netgroup_lookup2"
		size = 168
		refs = "000e __nss_netgroup_database 0058 __nss_lookup 0090 __nss_database_lookup"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 93 E1 00 1C 3F E0 ?? ?? 90 01 00 24 80 1F ?? ?? 93 61 00 0C 7C 9B 23 78 2F 80 00 00 93 81 00 10 7C BC 2B 78 93 A1 00 14 7C DD 33 78 38 DF ?? ?? 93 C1 00 18 7C 7E 1B 78 41 9E 00 40 90 1E 00 00 7F C3 F3 78 7F 64 DB 78 7F 85 E3 78 7F A6 EB 78 4? ?? ?? ?? 80 01 00 24 83 61 00 0C 7C 08 03 A6 83 81 00 10 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 3C 60 ?? ?? 38 63 ?? ?? 38 80 00 00 38 A0 00 00 4? ?? ?? ?? 2F 83 00 00 38 60 FF FF 41 BC FF C0 80 1F ?? ?? 4B FF FF A0 }
	condition:
		$1
}

rule file_650_0_0 {
	meta:
		name = "__nss_protocols_lookup2"
		size = 168
		refs = "000e __nss_protocols_database 0058 __nss_lookup 0090 __nss_database_lookup"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 93 E1 00 1C 3F E0 ?? ?? 90 01 00 24 80 1F ?? ?? 93 61 00 0C 7C 9B 23 78 2F 80 00 00 93 81 00 10 7C BC 2B 78 93 A1 00 14 7C DD 33 78 38 DF ?? ?? 93 C1 00 18 7C 7E 1B 78 41 9E 00 40 90 1E 00 00 7F C3 F3 78 7F 64 DB 78 7F 85 E3 78 7F A6 EB 78 4? ?? ?? ?? 80 01 00 24 83 61 00 0C 7C 08 03 A6 83 81 00 10 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 3C 60 ?? ?? 38 63 ?? ?? 38 80 00 00 38 A0 00 00 4? ?? ?? ?? 2F 83 00 00 38 60 FF FF 41 BC FF C0 80 1F ?? ?? 4B FF FF A0 }
	condition:
		$1
}

rule file_278_0_0 {
	meta:
		name = "__nss_rpc_lookup2"
		size = 168
		refs = "000e __nss_rpc_database 0058 __nss_lookup 0090 __nss_database_lookup"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 93 E1 00 1C 3F E0 ?? ?? 90 01 00 24 80 1F ?? ?? 93 61 00 0C 7C 9B 23 78 2F 80 00 00 93 81 00 10 7C BC 2B 78 93 A1 00 14 7C DD 33 78 38 DF ?? ?? 93 C1 00 18 7C 7E 1B 78 41 9E 00 40 90 1E 00 00 7F C3 F3 78 7F 64 DB 78 7F 85 E3 78 7F A6 EB 78 4? ?? ?? ?? 80 01 00 24 83 61 00 0C 7C 08 03 A6 83 81 00 10 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 3C 60 ?? ?? 38 63 ?? ?? 38 80 00 00 38 A0 00 00 4? ?? ?? ?? 2F 83 00 00 38 60 FF FF 41 BC FF C0 80 1F ?? ?? 4B FF FF A0 }
	condition:
		$1
}

rule file_646_0_0 {
	meta:
		name = "__nss_services_lookup2"
		size = 168
		refs = "000e __nss_services_database 0058 __nss_lookup 0090 __nss_database_lookup"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 93 E1 00 1C 3F E0 ?? ?? 90 01 00 24 80 1F ?? ?? 93 61 00 0C 7C 9B 23 78 2F 80 00 00 93 81 00 10 7C BC 2B 78 93 A1 00 14 7C DD 33 78 38 DF ?? ?? 93 C1 00 18 7C 7E 1B 78 41 9E 00 40 90 1E 00 00 7F C3 F3 78 7F 64 DB 78 7F 85 E3 78 7F A6 EB 78 4? ?? ?? ?? 80 01 00 24 83 61 00 0C 7C 08 03 A6 83 81 00 10 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 3C 60 ?? ?? 38 63 ?? ?? 38 80 00 00 38 A0 00 00 4? ?? ?? ?? 2F 83 00 00 38 60 FF FF 41 BC FF C0 80 1F ?? ?? 4B FF FF A0 }
	condition:
		$1
}

rule file_57_0_0 {
	meta:
		name = "__setstate_r"
		size = 276
		refs = "00f6 _GLOBAL_OFFSET_TABLE_ 00fe __libc_errno"
		altNames = "setstate_r"
	strings:
		$1 = { 2C 03 00 00 41 82 00 F0 2F 84 00 00 41 9E 00 E8 80 04 00 0C 81 24 00 08 2F 80 00 00 40 9E 00 C0 90 09 FF FC 3D 00 66 66 61 08 66 67 80 03 00 00 7D 20 40 96 7C 0B FE 70 7D 29 0E 70 7D 2B 48 50 1D 29 00 05 7D 29 00 50 2B 89 00 04 41 9D 00 A8 39 69 00 04 91 24 00 0C 3D 40 ?? ?? 2F 89 00 00 39 4A ?? ?? 55 6B 10 3A 7D 6A 5A 14 55 20 10 3A 81 6B 00 04 7D 4A 00 2E 38 03 00 04 91 64 00 10 91 44 00 14 41 9E 00 40 81 23 00 00 7D 09 40 96 7D 29 FE 70 7D 08 0E 70 7D 09 40 50 7D 4A 42 14 7D 2A 5B D6 7D 29 59 D6 55 08 10 3A 7D 49 50 50 55 4A 10 3A 7D 00 42 14 7D 40 52 14 91 04 00 04 91 44 00 00 55 6B 10 3A 90 04 00 08 7D 60 5A 14 38 60 00 00 91 64 00 18 4E 80 00 20 81 64 00 04 7D 69 58 50 7D 6B 16 70 1D 6B 00 05 7C 0B 02 14 4B FF FF 30 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 38 00 00 16 90 09 00 00 38 60 FF FF 4E 80 00 20 }
	condition:
		$1
}

rule file_57_1_0 {
	meta:
		name = "__random_r"
		size = 208
		refs = "00b2 _GLOBAL_OFFSET_TABLE_ 00ba __libc_errno"
		altNames = "random_r"
	strings:
		$1 = { 7C 69 1B 79 41 82 00 AC 2F 84 00 00 41 9E 00 A4 80 09 00 0C 81 49 00 08 2F 80 00 00 41 9E 00 6C 81 69 00 00 80 C9 00 18 80 E9 00 04 38 0B 00 04 7F 86 00 40 81 0B 00 00 80 A7 00 00 7D 05 42 14 55 05 F8 7E 91 0B 00 00 90 A4 00 00 41 9D 00 1C 38 E7 00 04 7D 40 53 78 90 09 00 00 38 60 00 00 90 E9 00 04 4E 80 00 20 38 E7 00 04 7F 86 38 40 41 BD FF E8 7D 47 53 78 90 09 00 00 38 60 00 00 90 E9 00 04 4E 80 00 20 81 6A 00 00 3D 20 41 C6 61 29 4E 6D 7D 29 59 D6 38 60 00 00 38 09 30 39 54 00 00 7E 90 0A 00 00 90 04 00 00 4E 80 00 20 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 38 00 00 16 90 09 00 00 38 60 FF FF 4E 80 00 20 }
	condition:
		$1
}

rule file_57_2_0 {
	meta:
		name = "__srandom_r"
		size = 288
		refs = "0108 __random_r"
		altNames = "srandom_r"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 39 20 FF FF 93 E1 00 1C 7C 9F 23 79 90 01 00 24 93 C1 00 18 40 82 00 20 80 01 00 24 7D 23 4B 78 83 C1 00 18 7C 08 03 A6 83 E1 00 1C 38 21 00 20 4E 80 00 20 81 7F 00 0C 2B 8B 00 04 41 BD FF DC 2F 83 00 00 80 DF 00 08 38 00 00 01 41 9E 00 08 7C 60 1B 78 2F 8B 00 00 90 06 00 00 39 20 00 00 41 BE FF B8 83 DF 00 10 2F 9E 00 01 40 9D 00 68 3C E0 83 4E 3D 00 00 01 3C A0 7F FF 39 3E FF FF 7C CB 33 78 7D 29 03 A6 60 E7 0B 5F 61 08 F3 1D 60 A5 FF FF 48 00 00 0C 94 0B 00 04 42 40 00 38 7D 20 38 96 7C 0A FE 70 7D 29 02 14 7D 29 86 70 7D 2A 48 50 7D 49 41 D6 1D 29 F4 EC 7C 0A 00 50 1C 00 41 A7 7C 09 02 15 40 80 FF D0 7C 00 2A 14 4B FF FF C8 1F DE 00 0A 80 1F 00 14 90 DF 00 04 37 DE FF FF 54 00 10 3A 7C 06 02 14 90 1F 00 00 39 20 00 00 41 A0 FF 24 7F E3 FB 78 38 81 00 08 4? ?? ?? ?? 2F 9E 00 00 3B DE FF FF 40 9E FF EC 39 20 00 00 4B FF FF 04 }
	condition:
		$1
}

rule file_57_3_0 {
	meta:
		name = "__initstate_r"
		size = 328
		refs = "00b0 __srandom_r 012a _GLOBAL_OFFSET_TABLE_ 0132 __libc_errno"
		altNames = "initstate_r"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 93 E1 00 1C 7C DF 33 79 93 C1 00 18 7C 9E 23 78 90 01 00 24 93 81 00 10 93 A1 00 14 41 82 01 04 81 3F 00 08 2F 89 00 00 41 9E 00 14 80 1F 00 0C 2F 80 00 00 40 9E 00 D4 90 09 FF FC 2B 85 00 7F 41 9D 00 B8 2B 85 00 1F 23 A5 00 3F 7F BD E9 10 23 BD 00 01 41 9D 00 10 2B 85 00 07 40 9D 00 C4 3B A0 00 00 39 7D 00 04 93 BF 00 0C 3D 20 ?? ?? 39 29 ?? ?? 55 6B 10 3A 7D 69 5A 14 80 0B 00 04 57 AB 10 3A 7D 69 58 2E 3B 9E 00 04 54 09 10 3A 90 1F 00 10 7D 3C 4A 14 91 7F 00 14 7F E4 FB 78 91 3F 00 18 93 9F 00 08 4? ?? ?? ?? 2F 9D 00 00 38 00 00 00 90 1E 00 00 38 60 00 00 41 9E 00 1C 80 1F 00 04 7F 9C 00 50 7F 9C 16 70 1F 9C 00 05 7F BD E2 14 93 BE 00 00 80 01 00 24 83 81 00 10 7C 08 03 A6 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 23 A5 00 FF 7F BD E9 10 23 BD 00 03 4B FF FF 60 81 7F 00 04 7D 69 58 50 7D 6B 16 70 1D 6B 00 05 7C 0B 02 14 4B FF FF 1C 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 38 00 00 16 90 09 00 00 38 60 FF FF 4B FF FF 9C }
	condition:
		$1
}

rule file_58_0_0 {
	meta:
		name = "fputwc"
		size = 448
		refs = "0080 _IO_fwide 0144 __woverflow 0150 __lll_lock_wait_private 01bc _Unwind_Resume"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 90 01 00 24 80 04 00 00 93 C1 00 18 7C 7E 1B 78 70 00 80 00 93 E1 00 1C 7C 9F 23 78 93 A1 00 14 40 82 00 50 80 64 00 48 3B A2 8B 60 81 23 00 08 7F 89 E8 00 41 9E 00 30 39 60 00 01 7D 20 18 28 7C 09 00 00 40 82 00 0C 7D 60 19 2D 40 A2 FF F0 4C 00 01 2C 2F 89 00 00 40 9E 00 F0 80 7F 00 48 93 A3 00 08 81 23 00 04 38 09 00 01 90 03 00 04 7F E3 FB 78 38 80 00 01 4? ?? ?? ?? 2F 83 00 00 41 9C 00 8C 81 3F 00 5C 2F 89 00 00 41 9E 00 A8 81 69 00 10 80 09 00 14 7F 8B 00 40 40 9C 00 98 38 0B 00 04 93 CB 00 00 90 09 00 10 80 1F 00 00 70 09 80 00 40 82 00 38 80 7F 00 48 81 23 00 04 38 09 FF FF 2F 80 00 00 90 03 00 04 40 9E 00 20 90 03 00 08 7C 00 04 AC 7D 20 18 28 7C 00 19 2D 40 A2 FF F8 2F 89 00 01 41 9D 00 2C 80 01 00 24 7F C3 F3 78 83 A1 00 14 7C 08 03 A6 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 3B C0 FF FF 4B FF FF 9C 80 82 8B 68 38 00 00 DD 38 A0 00 01 60 84 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF BC 7F E3 FB 78 7F C4 F3 78 4? ?? ?? ?? 7C 7E 1B 78 4B FF FF 68 4? ?? ?? ?? 4B FF FF 10 80 1F 00 00 7C 7E 1B 78 70 09 80 00 40 82 00 54 80 7F 00 48 80 03 00 04 30 00 FF FF 2F 80 00 00 90 03 00 04 40 9E 00 3C 90 03 00 08 7C 00 04 AC 7D 20 18 28 7C 00 19 2D 40 A2 FF F8 2F 89 00 01 40 BD 00 20 80 82 8B 68 38 00 00 DD 38 A0 00 01 60 84 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 7F C3 F3 78 4? ?? ?? ?? }
	condition:
		$1
}

rule file_59_0_0 {
	meta:
		name = "__towctrans_l"
		size = 112
		altNames = "__towctrans"
	strings:
		$1 = { 2C 04 00 00 4D 82 00 20 81 24 00 00 80 04 00 04 7C 69 4C 30 7F 89 00 40 4C 9C 00 20 39 29 00 05 55 29 10 3A 7C 04 48 2E 2F 80 00 00 4D 9E 00 20 81 24 00 08 81 64 00 0C 7C 69 4C 30 7D 29 58 38 55 29 10 3A 7C 09 02 14 7C 04 00 2E 2F 80 00 00 4D 9E 00 20 81 24 00 10 7C 69 48 38 55 29 10 3A 7C 09 02 14 7C 04 00 2E 7C 63 02 14 4E 80 00 20 }
	condition:
		$1
}

rule file_60_0_0 {
	meta:
		name = "wcscmp"
		size = 52
	strings:
		$1 = { 38 63 FF FC 38 84 FF FC 48 00 00 08 40 9A 00 20 84 03 00 04 85 24 00 04 2F 80 00 00 7F 00 48 00 40 9E FF EC 7C 69 00 D0 4E 80 00 20 7C 69 00 50 4E 80 00 20 }
	condition:
		$1
}

rule file_61_0_0 {
	meta:
		name = "__iswalnum_l"
		size = 176
		altNames = "iswalnum_l"
	strings:
		$1 = { 54 69 00 31 7C 60 1B 78 41 82 00 94 81 24 00 00 38 60 00 00 81 69 00 68 39 6B 00 13 55 6B 10 3A 7D 29 5A 14 81 29 00 04 81 69 00 00 81 49 00 04 7C 0B 5C 30 7F 8B 50 40 4C 9C 00 20 39 6B 00 05 55 6B 10 3A 7D 69 58 2E 2F 8B 00 00 4D 9E 00 20 81 49 00 08 81 09 00 0C 7C 0A 54 30 7D 4A 40 38 55 4A 10 3A 7D 6A 5A 14 7D 69 58 2E 2F 8B 00 00 4D 9E 00 20 81 49 00 10 54 08 D9 7E 54 00 06 FE 7D 0A 50 38 55 4A 10 3A 7D 6A 5A 14 7C 69 58 2E 7C 63 04 30 54 63 07 FE 4E 80 00 20 81 24 00 34 54 60 08 3C 7C 69 02 2E 54 63 05 28 4E 80 00 20 }
	condition:
		$1
}

rule file_61_1_0 {
	meta:
		name = "__iswalpha_l"
		size = 176
		altNames = "iswalpha_l"
	strings:
		$1 = { 54 69 00 31 7C 60 1B 78 41 82 00 94 81 24 00 00 38 60 00 00 81 69 00 68 39 6B 00 0A 55 6B 10 3A 7D 29 5A 14 81 29 00 04 81 69 00 00 81 49 00 04 7C 0B 5C 30 7F 8B 50 40 4C 9C 00 20 39 6B 00 05 55 6B 10 3A 7D 69 58 2E 2F 8B 00 00 4D 9E 00 20 81 49 00 08 81 09 00 0C 7C 0A 54 30 7D 4A 40 38 55 4A 10 3A 7D 6A 5A 14 7D 69 58 2E 2F 8B 00 00 4D 9E 00 20 81 49 00 10 54 08 D9 7E 54 00 06 FE 7D 0A 50 38 55 4A 10 3A 7D 6A 5A 14 7C 69 58 2E 7C 63 04 30 54 63 07 FE 4E 80 00 20 81 24 00 34 54 60 08 3C 7C 69 02 2E 54 63 07 7A 4E 80 00 20 }
	condition:
		$1
}

rule file_61_2_0 {
	meta:
		name = "__iswblank_l"
		size = 176
		altNames = "iswblank_l"
	strings:
		$1 = { 54 69 00 31 7C 60 1B 78 41 82 00 94 81 24 00 00 38 60 00 00 81 69 00 68 39 6B 00 10 55 6B 10 3A 7D 29 5A 14 81 29 00 04 81 69 00 00 81 49 00 04 7C 0B 5C 30 7F 8B 50 40 4C 9C 00 20 39 6B 00 05 55 6B 10 3A 7D 69 58 2E 2F 8B 00 00 4D 9E 00 20 81 49 00 08 81 09 00 0C 7C 0A 54 30 7D 4A 40 38 55 4A 10 3A 7D 6A 5A 14 7D 69 58 2E 2F 8B 00 00 4D 9E 00 20 81 49 00 10 54 08 D9 7E 54 00 06 FE 7D 0A 50 38 55 4A 10 3A 7D 6A 5A 14 7C 69 58 2E 7C 63 04 30 54 63 07 FE 4E 80 00 20 81 24 00 34 54 60 08 3C 7C 69 02 2E 54 63 05 EE 4E 80 00 20 }
	condition:
		$1
}

rule file_61_3_0 {
	meta:
		name = "__iswcntrl_l"
		size = 176
		altNames = "iswcntrl_l"
	strings:
		$1 = { 54 69 00 31 7C 60 1B 78 41 82 00 94 81 24 00 00 38 60 00 00 81 69 00 68 39 6B 00 11 55 6B 10 3A 7D 29 5A 14 81 29 00 04 81 69 00 00 81 49 00 04 7C 0B 5C 30 7F 8B 50 40 4C 9C 00 20 39 6B 00 05 55 6B 10 3A 7D 69 58 2E 2F 8B 00 00 4D 9E 00 20 81 49 00 08 81 09 00 0C 7C 0A 54 30 7D 4A 40 38 55 4A 10 3A 7D 6A 5A 14 7D 69 58 2E 2F 8B 00 00 4D 9E 00 20 81 49 00 10 54 08 D9 7E 54 00 06 FE 7D 0A 50 38 55 4A 10 3A 7D 6A 5A 14 7C 69 58 2E 7C 63 04 30 54 63 07 FE 4E 80 00 20 81 24 00 34 54 60 08 3C 7C 69 02 2E 54 63 05 AC 4E 80 00 20 }
	condition:
		$1
}

rule file_61_4_0 {
	meta:
		name = "__iswdigit_l"
		size = 176
		altNames = "iswdigit_l"
	strings:
		$1 = { 54 60 00 31 7C 69 1B 78 41 82 00 94 81 64 00 00 38 60 00 00 81 4B 00 68 38 0A 00 0B 54 00 10 3A 7D 6B 02 14 81 6B 00 04 81 4B 00 00 80 0B 00 04 7D 2A 54 30 7F 8A 00 40 4C 9C 00 20 39 4A 00 05 55 4A 10 3A 7C 0B 50 2E 2F 80 00 00 4D 9E 00 20 81 4B 00 08 81 0B 00 0C 7D 2A 54 30 7D 4A 40 38 55 4A 10 3A 7C 0A 02 14 7C 0B 00 2E 2F 80 00 00 4D 9E 00 20 81 4B 00 10 55 28 D9 7E 55 29 06 FE 7D 0A 50 38 55 4A 10 3A 7C 0A 02 14 7C 6B 00 2E 7C 63 4C 30 54 63 07 FE 4E 80 00 20 39 23 FF D0 20 69 00 09 38 60 00 00 7C 63 19 14 4E 80 00 20 }
	condition:
		$1
}

rule file_61_5_0 {
	meta:
		name = "__iswlower_l"
		size = 176
		altNames = "iswlower_l"
	strings:
		$1 = { 54 69 00 31 7C 60 1B 78 41 82 00 94 81 24 00 00 38 60 00 00 81 69 00 68 39 6B 00 09 55 6B 10 3A 7D 29 5A 14 81 29 00 04 81 69 00 00 81 49 00 04 7C 0B 5C 30 7F 8B 50 40 4C 9C 00 20 39 6B 00 05 55 6B 10 3A 7D 69 58 2E 2F 8B 00 00 4D 9E 00 20 81 49 00 08 81 09 00 0C 7C 0A 54 30 7D 4A 40 38 55 4A 10 3A 7D 6A 5A 14 7D 69 58 2E 2F 8B 00 00 4D 9E 00 20 81 49 00 10 54 08 D9 7E 54 00 06 FE 7D 0A 50 38 55 4A 10 3A 7D 6A 5A 14 7C 69 58 2E 7C 63 04 30 54 63 07 FE 4E 80 00 20 81 24 00 34 54 60 08 3C 7C 69 02 2E 54 63 07 BC 4E 80 00 20 }
	condition:
		$1
}

rule file_61_6_0 {
	meta:
		name = "__iswgraph_l"
		size = 176
		altNames = "iswgraph_l"
	strings:
		$1 = { 54 69 00 31 7C 60 1B 78 41 82 00 94 81 24 00 00 38 60 00 00 81 69 00 68 39 6B 00 0F 55 6B 10 3A 7D 29 5A 14 81 29 00 04 81 69 00 00 81 49 00 04 7C 0B 5C 30 7F 8B 50 40 4C 9C 00 20 39 6B 00 05 55 6B 10 3A 7D 69 58 2E 2F 8B 00 00 4D 9E 00 20 81 49 00 08 81 09 00 0C 7C 0A 54 30 7D 4A 40 38 55 4A 10 3A 7D 6A 5A 14 7D 69 58 2E 2F 8B 00 00 4D 9E 00 20 81 49 00 10 54 08 D9 7E 54 00 06 FE 7D 0A 50 38 55 4A 10 3A 7D 6A 5A 14 7C 69 58 2E 7C 63 04 30 54 63 07 FE 4E 80 00 20 81 24 00 34 54 60 08 3C 7C 69 02 2E 54 63 06 30 4E 80 00 20 }
	condition:
		$1
}

rule file_61_7_0 {
	meta:
		name = "__iswprint_l"
		size = 176
		altNames = "iswprint_l"
	strings:
		$1 = { 54 69 00 31 7C 60 1B 78 41 82 00 94 81 24 00 00 38 60 00 00 81 69 00 68 39 6B 00 0E 55 6B 10 3A 7D 29 5A 14 81 29 00 04 81 69 00 00 81 49 00 04 7C 0B 5C 30 7F 8B 50 40 4C 9C 00 20 39 6B 00 05 55 6B 10 3A 7D 69 58 2E 2F 8B 00 00 4D 9E 00 20 81 49 00 08 81 09 00 0C 7C 0A 54 30 7D 4A 40 38 55 4A 10 3A 7D 6A 5A 14 7D 69 58 2E 2F 8B 00 00 4D 9E 00 20 81 49 00 10 54 08 D9 7E 54 00 06 FE 7D 0A 50 38 55 4A 10 3A 7D 6A 5A 14 7C 69 58 2E 7C 63 04 30 54 63 07 FE 4E 80 00 20 81 24 00 34 54 60 08 3C 7C 69 02 2E 54 63 06 72 4E 80 00 20 }
	condition:
		$1
}

rule file_61_8_0 {
	meta:
		name = "__iswpunct_l"
		size = 176
		altNames = "iswpunct_l"
	strings:
		$1 = { 54 69 00 31 7C 60 1B 78 41 82 00 94 81 24 00 00 38 60 00 00 81 69 00 68 39 6B 00 12 55 6B 10 3A 7D 29 5A 14 81 29 00 04 81 69 00 00 81 49 00 04 7C 0B 5C 30 7F 8B 50 40 4C 9C 00 20 39 6B 00 05 55 6B 10 3A 7D 69 58 2E 2F 8B 00 00 4D 9E 00 20 81 49 00 08 81 09 00 0C 7C 0A 54 30 7D 4A 40 38 55 4A 10 3A 7D 6A 5A 14 7D 69 58 2E 2F 8B 00 00 4D 9E 00 20 81 49 00 10 54 08 D9 7E 54 00 06 FE 7D 0A 50 38 55 4A 10 3A 7D 6A 5A 14 7C 69 58 2E 7C 63 04 30 54 63 07 FE 4E 80 00 20 81 24 00 34 54 60 08 3C 7C 69 02 2E 54 63 05 6A 4E 80 00 20 }
	condition:
		$1
}

rule file_61_9_0 {
	meta:
		name = "__iswspace_l"
		size = 176
		altNames = "iswspace_l"
	strings:
		$1 = { 54 69 00 31 7C 60 1B 78 41 82 00 94 81 24 00 00 38 60 00 00 81 69 00 68 39 6B 00 0D 55 6B 10 3A 7D 29 5A 14 81 29 00 04 81 69 00 00 81 49 00 04 7C 0B 5C 30 7F 8B 50 40 4C 9C 00 20 39 6B 00 05 55 6B 10 3A 7D 69 58 2E 2F 8B 00 00 4D 9E 00 20 81 49 00 08 81 09 00 0C 7C 0A 54 30 7D 4A 40 38 55 4A 10 3A 7D 6A 5A 14 7D 69 58 2E 2F 8B 00 00 4D 9E 00 20 81 49 00 10 54 08 D9 7E 54 00 06 FE 7D 0A 50 38 55 4A 10 3A 7D 6A 5A 14 7C 69 58 2E 7C 63 04 30 54 63 07 FE 4E 80 00 20 81 24 00 34 54 60 08 3C 7C 69 02 2E 54 63 06 B4 4E 80 00 20 }
	condition:
		$1
}

rule file_61_10_0 {
	meta:
		name = "__iswupper_l"
		size = 176
		altNames = "iswupper_l"
	strings:
		$1 = { 54 69 00 31 7C 60 1B 78 41 82 00 94 81 24 00 00 38 60 00 00 81 69 00 68 39 6B 00 08 55 6B 10 3A 7D 29 5A 14 81 29 00 04 81 69 00 00 81 49 00 04 7C 0B 5C 30 7F 8B 50 40 4C 9C 00 20 39 6B 00 05 55 6B 10 3A 7D 69 58 2E 2F 8B 00 00 4D 9E 00 20 81 49 00 08 81 09 00 0C 7C 0A 54 30 7D 4A 40 38 55 4A 10 3A 7D 6A 5A 14 7D 69 58 2E 2F 8B 00 00 4D 9E 00 20 81 49 00 10 54 08 D9 7E 54 00 06 FE 7D 0A 50 38 55 4A 10 3A 7D 6A 5A 14 7C 69 58 2E 7C 63 04 30 54 63 07 FE 4E 80 00 20 81 24 00 34 54 60 08 3C 7C 69 02 2E 54 63 07 FE 4E 80 00 20 }
	condition:
		$1
}

rule file_61_11_0 {
	meta:
		name = "__iswxdigit_l"
		size = 176
		altNames = "iswxdigit_l"
	strings:
		$1 = { 54 69 00 31 7C 60 1B 78 41 82 00 94 81 24 00 00 38 60 00 00 81 69 00 68 39 6B 00 0C 55 6B 10 3A 7D 29 5A 14 81 29 00 04 81 69 00 00 81 49 00 04 7C 0B 5C 30 7F 8B 50 40 4C 9C 00 20 39 6B 00 05 55 6B 10 3A 7D 69 58 2E 2F 8B 00 00 4D 9E 00 20 81 49 00 08 81 09 00 0C 7C 0A 54 30 7D 4A 40 38 55 4A 10 3A 7D 6A 5A 14 7D 69 58 2E 2F 8B 00 00 4D 9E 00 20 81 49 00 10 54 08 D9 7E 54 00 06 FE 7D 0A 50 38 55 4A 10 3A 7D 6A 5A 14 7C 69 58 2E 7C 63 04 30 54 63 07 FE 4E 80 00 20 81 24 00 34 54 60 08 3C 7C 69 02 2E 54 63 06 F6 4E 80 00 20 }
	condition:
		$1
}

rule file_61_12_0 {
	meta:
		name = "__towlower_l"
		size = 128
		altNames = "towlower_l"
	strings:
		$1 = { 81 24 00 00 81 69 00 6C 38 0B 00 09 54 00 10 3A 7D 29 02 14 81 29 00 04 81 69 00 00 80 09 00 04 7C 6B 5C 30 7F 8B 00 40 4C 9C 00 20 39 6B 00 05 55 6B 10 3A 7C 09 58 2E 2F 80 00 00 4D 9E 00 20 81 69 00 08 81 49 00 0C 7C 6B 5C 30 7D 6B 50 38 55 6B 10 3A 7C 0B 02 14 7C 09 00 2E 2F 80 00 00 4D 9E 00 20 81 69 00 10 7C 6B 58 38 55 6B 10 3A 7C 0B 02 14 7C 09 00 2E 7C 63 02 14 4E 80 00 20 }
	condition:
		$1
}

rule file_61_13_0 {
	meta:
		name = "__towupper_l"
		size = 128
		altNames = "towupper_l"
	strings:
		$1 = { 81 24 00 00 81 69 00 6C 38 0B 00 08 54 00 10 3A 7D 29 02 14 81 29 00 04 81 69 00 00 80 09 00 04 7C 6B 5C 30 7F 8B 00 40 4C 9C 00 20 39 6B 00 05 55 6B 10 3A 7C 09 58 2E 2F 80 00 00 4D 9E 00 20 81 69 00 08 81 49 00 0C 7C 6B 5C 30 7D 6B 50 38 55 6B 10 3A 7C 0B 02 14 7C 09 00 2E 2F 80 00 00 4D 9E 00 20 81 69 00 10 7C 6B 58 38 55 6B 10 3A 7C 0B 02 14 7C 09 00 2E 7C 63 02 14 4E 80 00 20 }
	condition:
		$1
}

rule file_62_0_0 {
	meta:
		name = "__strnlen"
		size = 276
	strings:
		$1 = { 2C 04 00 00 7C 67 1B 78 38 60 00 00 4D 82 00 20 7C 87 22 14 7F 87 20 40 41 9D 00 F4 70 E0 00 03 41 82 00 E4 88 07 00 00 7C E9 3B 78 2F 80 00 00 40 BE 00 14 48 00 00 9C 88 09 00 00 2F 80 00 00 41 9E 00 94 39 29 00 01 71 2A 00 03 40 82 FF EC 3D 00 80 80 7D 2B 4B 78 61 08 80 80 48 00 00 5C 81 4B 00 00 39 2B 00 01 3D 4A FE FF 38 0A FE FF 7C 0A 40 39 41 82 00 3C 88 0B 00 00 2F 80 00 00 41 9E 00 7C 88 0B 00 01 2F 80 00 00 41 9E 00 34 88 0B 00 02 39 2B 00 02 2F 80 00 00 41 9E 00 24 88 0B 00 03 39 2B 00 03 2F 80 00 00 41 9E 00 14 39 6B 00 04 7C 89 23 78 7F 84 58 40 41 9D FF A4 7F 84 48 40 41 9C 00 20 7C 67 48 50 4E 80 00 20 7C E9 3B 78 7F 84 48 40 41 9C 00 18 7C 67 48 50 4E 80 00 20 7C 89 23 78 7C 67 48 50 4E 80 00 20 7C 89 23 78 7C 67 48 50 4E 80 00 20 7D 69 5B 78 4B FF FF C0 7C E9 3B 78 4B FF FF 48 38 80 FF FF 4B FF FF 0C }
	condition:
		$1
}

rule file_63_0_0 {
	meta:
		name = "posix_spawnp"
		size = 36
		refs = "0010 __spawni"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 39 20 00 01 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_64_0_0 {
	meta:
		name = "wait_on_socket"
		size = 292
		refs = "0034 __poll 0066 _GLOBAL_OFFSET_TABLE_ 006e __libc_errno 0088 __gettimeofday"
	strings:
		$1 = { 94 21 FF D0 7C 08 02 A6 93 E1 00 2C 7C 9F 23 78 7F E5 FB 78 90 01 00 34 38 80 00 01 38 00 00 19 90 61 00 08 38 61 00 08 B0 01 00 0C 93 A1 00 24 93 C1 00 28 4? ?? ?? ?? 2F 83 FF FF 7C 60 1B 78 41 9E 00 24 7C 03 03 78 80 01 00 34 83 A1 00 24 7C 08 03 A6 83 C1 00 28 83 E1 00 2C 38 21 00 30 4E 80 00 20 3F C0 ?? ?? 3B DE ?? ?? 83 DE ?? ?? 7F DE 12 14 81 3E 00 00 2F 89 00 04 40 9E FF C8 38 61 00 10 38 80 00 00 4? ?? ?? ?? 81 21 00 14 3C 00 10 62 81 61 00 10 39 29 01 F4 60 00 4D D3 7F A9 00 96 1D 6B 03 E8 7D 29 FE 70 7F BD 36 70 7F A9 E8 50 7F BD 5A 14 7F BD FA 14 7F E5 FB 78 7C 1F 03 78 48 00 00 3C 81 3E 00 00 2F 89 00 04 40 BE FF 74 4? ?? ?? ?? 80 01 00 14 81 21 00 10 30 00 01 F4 7D 60 F8 96 1D 29 FC 18 7C 00 FE 70 7D 6B 36 70 7C AB 00 50 7C A5 4A 14 7C A5 EA 14 38 80 00 01 38 61 00 08 4? ?? ?? ?? 38 80 00 00 7C 60 1B 78 2F 80 FF FF 38 61 00 10 41 9E FF AC 4B FF FF 24 }
	condition:
		$1
}

rule file_64_1_0 {
	meta:
		name = "open_socket"
		size = 808
		refs = "000e __have_sock_cloexec 005c __socket 00fc __connect 0112 _GLOBAL_OFFSET_TABLE_ 012a __libc_errno 0138 memcpy 0158 __send 028c __fcntl 02ac __gettimeofday 02e0 __poll"
	strings:
		$1 = { 94 21 FF 40 7C 08 02 A6 93 A1 00 B4 3F A0 ?? ?? 90 01 00 C4 80 1D ?? ?? 93 21 00 A4 7C 99 23 78 2F 80 00 00 93 41 00 A8 7C 7A 1B 78 93 61 00 AC 7C BB 2B 78 93 E1 00 BC 7C 3F 0B 78 93 01 00 A0 93 81 00 B0 93 C1 00 B8 41 9C 02 1C 3C 80 00 08 38 60 00 01 60 84 08 01 38 A0 00 00 4? ?? ?? ?? 80 1D ?? ?? 7C 7E 1B 78 2F 80 00 00 41 9E 01 6C 41 9C 01 F4 2F 9E 00 00 41 9C 01 78 39 3B 00 0F 81 7D ?? ?? 55 29 00 3A 38 09 00 1E 81 21 00 00 54 00 00 36 2F 8B 00 00 7C 00 00 D0 7D 21 01 6E 3B 9B 00 0C 3B A1 00 17 57 BD 00 36 41 9C 01 D0 3D 20 ?? ?? 38 C9 ?? ?? 80 E9 ?? ?? 7F E4 FB 78 81 06 00 04 38 00 00 01 81 46 00 08 B4 04 00 20 7F C3 F3 78 38 A0 00 6E 81 66 00 0C 81 26 00 10 88 06 00 14 90 FF 00 22 91 1F 00 26 91 5F 00 2A 91 7F 00 2E 91 3F 00 32 98 1F 00 36 4? ?? ?? ?? 2F 83 00 00 41 9C 00 A0 7F 65 DB 78 93 7D 00 08 3F 60 ?? ?? 38 00 00 02 93 5D 00 04 3B 7B ?? ?? 7F 24 CB 78 90 1D 00 00 83 7B ?? ?? 3F 20 10 62 38 7D 00 0C 3B 40 00 01 4? ?? ?? ?? 7F 7B 12 14 3B 00 00 1C 63 39 4D D3 7F 85 E3 78 38 C0 40 00 7F A4 EB 78 7F C3 F3 78 4? ?? ?? ?? 2F 83 FF FF 7F 03 E0 00 41 9E 00 C8 40 9A 01 2C 39 7F 00 C0 80 0B 00 04 7F C3 F3 78 83 0B FF E0 7C 08 03 A6 83 2B FF E4 83 4B FF E8 83 6B FF EC 83 8B FF F0 83 AB FF F4 83 CB FF F8 83 EB FF FC 7D 61 5B 78 4E 80 00 20 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 80 09 00 00 2F 80 00 73 41 9E FF 4C 38 00 00 06 7F C3 F3 78 44 00 00 02 7C 00 00 26 3B C0 FF FF 4B FF FF 98 2F 83 FF FF 38 00 00 01 41 9E 00 5C 2F 80 00 00 90 1D ?? ?? 4B FF FE 84 39 7F 00 C0 80 0B 00 04 3B C0 FF FF 7F C3 F3 78 83 0B FF E0 7C 08 03 A6 83 2B FF E4 83 4B FF E8 83 6B FF EC 83 8B FF F0 83 AB FF F4 83 CB FF F8 83 EB FF FC 7D 61 5B 78 4E 80 00 20 80 1B 00 00 2C 80 00 04 40 86 FF 34 4B FF FF 10 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 80 09 00 00 68 00 00 16 30 00 FF FF 7C 00 01 10 60 00 00 01 4B FF FF 84 38 60 00 01 38 80 00 01 38 A0 00 00 4? ?? ?? ?? 7C 7E 1B 78 4B FF FD FC 7F C3 F3 78 38 80 00 04 38 A0 08 02 4C C6 31 82 4? ?? ?? ?? 4B FF FE 20 40 BE FF 2C 80 1B 00 00 38 80 00 00 38 7F 00 10 2F 80 00 0B 40 BE FF 18 4? ?? ?? ?? 2F 9A 00 00 41 9E 00 40 80 1F 00 10 38 A0 13 88 81 3F 00 14 30 00 00 05 91 3F 00 0C 90 1F 00 08 38 7F 00 18 93 DF 00 18 38 80 00 01 B3 1F 00 1C 4? ?? ?? ?? 2F 83 00 00 40 BD FE D8 3B 40 00 00 4B FF FE 58 81 3F 00 0C 80 1F 00 14 81 7F 00 10 7C 00 48 50 80 BF 00 08 7D 20 C8 96 7C AB 28 50 1C A5 03 E8 7D 29 36 70 7C 00 FE 70 7C 00 48 50 7C A5 02 14 4B FF FF AC }
	condition:
		$1
}

rule file_64_2_0 {
	meta:
		name = "get_mapping"
		size = 916
		refs = "004a _GLOBAL_OFFSET_TABLE_ 005a __libc_errno 0068 strlen 0120 __recvmsg 0174 strcmp 01a0 __mmap 0210 malloc 0248 __close 028c __nscd_unmap 02f0 __munmap 0318 __fxstat64 0360 time"
	strings:
		$1 = { 94 21 FF 10 7C 08 02 A6 7D 80 00 26 93 C1 00 E8 7C 7E 1B 78 7C 83 23 78 93 E1 00 EC 7C 3F 0B 78 90 01 00 F4 92 C1 00 C8 92 E1 00 CC 93 01 00 D0 7C 98 23 78 93 21 00 D4 3B 20 FF FF 93 41 00 D8 93 61 00 DC 93 81 00 E0 3F 80 ?? ?? 3B 9C ?? ?? 93 A1 00 E4 7C BD 2B 78 83 5C ?? ?? 91 81 00 C0 7F 5A 12 14 92 A1 00 C4 4? ?? ?? ?? 38 03 00 1F 81 21 00 00 54 00 00 36 7C 00 00 D0 83 7A 00 00 7D 21 01 6E 3A E3 00 01 7F 04 C3 78 38 01 00 17 7F C3 F3 78 7E E5 BB 78 54 16 00 36 4B FF F8 A1 7C 7E 1B 79 41 80 01 B0 38 00 00 00 92 DF 00 10 39 1F 00 08 90 1F 00 30 39 60 00 10 39 40 00 01 90 1F 00 34 39 3F 00 20 38 80 13 88 90 1F 00 48 38 1F 00 10 91 1F 00 18 39 00 00 08 90 1F 00 38 38 00 00 02 92 FF 00 14 91 1F 00 1C 90 1F 00 3C 91 3F 00 40 91 5F 00 24 91 5F 00 28 91 7F 00 20 93 3F 00 2C 91 7F 00 44 4B FF F7 11 2F 83 00 00 40 9D 01 3C 7F C3 F3 78 38 9F 00 30 3C A0 40 00 4? ?? ?? ?? 2F 83 FF FF 40 9E 00 10 80 1A 00 00 2F 80 00 04 41 9E FF E0 80 1F 00 44 3B 20 FF FF 2B 80 00 0B 40 9D 01 08 81 3F 00 40 2F 89 00 00 41 9E 00 FC 80 09 00 00 2F 80 00 10 40 9E 00 F0 7E 17 18 00 83 5F 00 2C 40 92 01 94 7E C3 B3 78 7F 04 C3 78 4? ?? ?? ?? 3B 20 FF FF 2F 83 00 00 40 9E 00 C4 41 92 01 88 80 9F 00 0C 38 60 00 00 38 A0 00 01 38 C0 00 01 7F 47 D3 78 39 00 00 00 4? ?? ?? ?? 3B 20 FF FF 2F 83 FF FF 7C 78 1B 78 41 9E 00 94 80 03 00 00 2F 80 00 01 40 9E 01 28 80 03 00 04 2F 80 00 68 40 9E 01 1C 83 23 00 18 2F 99 00 00 41 9E 01 10 80 03 00 0C 2F 80 00 00 41 9E 01 74 80 1F 00 08 57 39 10 3A 82 F8 00 1C 3B 39 00 0F 2F 80 00 00 82 BF 00 0C 3A D7 00 68 57 39 00 36 7E D6 CA 14 41 9E 01 80 38 60 00 14 4? ?? ?? ?? 2C 03 00 00 41 82 00 D0 80 18 00 04 93 03 00 00 7F 39 02 14 7C 18 CA 14 92 C3 00 08 7C 79 1B 78 90 03 00 04 38 00 00 01 92 E3 00 10 90 03 00 0C 7F 43 D3 78 4? ?? ?? ?? 7F C3 F3 78 4? ?? ?? ?? 80 7D 00 00 83 9C ?? ?? 7F 9C 12 14 2F 83 00 00 93 7C 00 00 93 3D 00 00 41 9E 00 24 39 23 00 0C 7D 60 48 28 39 6B FF FF 7D 60 49 2D 40 A2 FF F4 2F 8B 00 00 40 BE 00 08 4? ?? ?? ?? 39 7F 00 F0 80 0B 00 04 7F 23 CB 78 81 8B FF D0 7C 08 03 A6 82 AB FF D4 82 CB FF D8 7D 80 81 20 82 EB FF DC 83 0B FF E0 83 2B FF E4 83 4B FF E8 83 6B FF EC 83 8B FF F0 83 AB FF F4 83 CB FF F8 83 EB FF FC 7D 61 5B 78 4E 80 00 20 7F 83 B8 40 40 BD 00 A0 82 BF 00 0C 7F 03 C3 78 7E A4 AB 78 4? ?? ?? ?? 3B 20 FF FF 4B FF FF 4C 3A F7 00 08 7F 83 B8 00 41 9E FE 68 4B FF FF 3C 38 60 00 03 7F 44 D3 78 38 BF 00 50 4? ?? ?? ?? 2F 83 00 00 40 BE FF 24 81 3F 00 80 80 1F 00 84 2F 89 00 00 40 9D 00 10 91 3F 00 08 90 1F 00 0C 4B FF FE 4C 40 9E 00 0C 2B 80 00 67 41 9D FF EC 3B 20 FF FF 4B FF FE F4 82 C3 00 10 82 E3 00 14 38 60 00 00 4? ?? ?? ?? 7C 60 FE 70 32 F7 01 2C 7E D6 01 94 7F 80 B0 40 41 BD FF 70 7F 80 B0 00 41 BE FF 60 83 38 00 18 4B FF FE 60 7F 96 A8 40 40 9D FE 80 4B FF FF 58 }
	condition:
		$1
}

rule file_64_3_0 {
	meta:
		name = "__readall"
		size = 228
		refs = "000e _GLOBAL_OFFSET_TABLE_ 0016 __libc_errno 0050 __read"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 93 61 00 0C 3F 60 ?? ?? 3B 7B ?? ?? 83 7B ?? ?? 90 01 00 24 7F 7B 12 14 93 41 00 08 93 81 00 10 7C BC 2B 78 93 A1 00 14 7C 7D 1B 78 93 C1 00 18 7C 9E 23 78 93 E1 00 1C 7C BF 2B 78 7F C4 F3 78 7F E5 FB 78 7F A3 EB 78 4? ?? ?? ?? 2F 83 FF FF 7C 7A 1B 78 2F 03 00 00 41 9E 00 40 40 99 00 58 7F E3 F8 51 7F DE 1A 14 40 82 FF D4 7C 7F E0 50 80 01 00 24 83 41 00 08 7C 08 03 A6 83 61 00 0C 83 81 00 10 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 80 1B 00 00 2F 80 00 04 41 BE FF 9C 2F 80 00 0B 41 9E 00 18 7F 43 D3 78 4B FF FF C0 41 9A FF B8 80 1B 00 00 4B FF FF E8 7F A3 EB 78 38 80 00 C8 4B FF FA E5 2F 83 00 00 41 9D FF 6C 7F 43 D3 78 4B FF FF 98 }
	condition:
		$1
}

rule file_64_4_0 {
	meta:
		name = "__readvall"
		size = 592
		refs = "000e _GLOBAL_OFFSET_TABLE_ 0016 __libc_errno 005c __readv 0134 memcpy"
	strings:
		$1 = { 94 21 FF D0 7C 08 02 A6 93 C1 00 28 3F C0 ?? ?? 3B DE ?? ?? 83 DE ?? ?? 90 01 00 34 7F DE 12 14 92 E1 00 0C 93 01 00 10 93 21 00 14 93 41 00 18 93 61 00 1C 7C 7B 1B 78 93 81 00 20 7C BC 2B 78 93 A1 00 24 7C 9D 23 78 93 E1 00 2C 7C 3F 0B 78 7F 63 DB 78 7F A4 EB 78 7F 85 E3 78 4? ?? ?? ?? 2F 83 FF FF 40 9E 00 24 80 1E 00 00 2F 80 00 04 41 9E FF E0 2F 80 00 0B 7C 7A 1B 78 40 BE 00 4C 3B 40 00 00 48 00 00 10 2F 83 00 00 7C 7A 1B 78 40 9D 01 84 2F 9C 00 00 40 9D 00 30 7F 89 03 A6 39 20 00 00 3B C0 00 00 55 2B 18 38 7D 7D 5A 14 80 0B 00 04 39 29 00 01 7F DE 02 14 42 00 FF EC 7F 9A F0 40 41 9C 00 40 39 7F 00 30 80 0B 00 04 7F 43 D3 78 82 EB FF DC 7C 08 03 A6 83 0B FF E0 83 2B FF E4 83 4B FF E8 83 6B FF EC 83 8B FF F0 83 AB FF F4 83 CB FF F8 83 EB FF FC 7D 61 5B 78 4E 80 00 20 57 85 18 38 81 21 00 00 38 05 00 1E 54 00 00 36 7C 00 00 D0 7C 39 0B 78 7D 21 01 6E 3F 00 ?? ?? 38 61 00 17 7F A4 EB 78 54 63 00 36 3B 18 ?? ?? 4? ?? ?? ?? 83 18 ?? ?? 7C 7D 1B 78 7F 57 D3 78 7F 18 12 14 80 1D 00 04 7F 80 B8 40 40 9D 00 88 81 3D 00 00 7C 17 00 50 90 1D 00 04 7E E9 BA 14 92 FD 00 00 7F A4 EB 78 7F 85 E3 78 7F 63 DB 78 4? ?? ?? ?? 2F 03 FF FF 7C 77 1B 78 2F 83 00 00 41 9A 00 64 41 9D 00 7C 40 9E 00 A4 80 01 00 00 39 7F 00 30 7F 43 D3 78 90 19 00 00 80 0B 00 04 7F 21 CB 78 82 EB FF DC 7C 08 03 A6 83 0B FF E0 83 2B FF E4 83 4B FF E8 83 6B FF EC 83 8B FF F0 83 AB FF F4 83 CB FF F8 83 EB FF FC 7D 61 5B 78 4E 80 00 20 7E E0 B8 50 3B 9C FF FF 3B BD 00 08 4B FF FF 64 80 18 00 00 2F 80 00 04 41 BE FF 78 2F 80 00 0B 41 9E 00 40 7E FA BB 78 4B FF FF 90 7F 5A 1A 14 7F 9A F0 40 41 9C FF 3C 4B FF FF 80 41 9E FE B4 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 80 09 00 00 4B FF FE 48 80 18 00 00 4B FF FF C0 7F 63 DB 78 38 80 00 C8 4B FF F8 91 2F 83 00 00 41 9D FF 20 4B FF FF B0 }
	condition:
		$1
}

rule file_64_5_0 {
	meta:
		name = "__nscd_unmap"
		size = 104
		refs = "0028 __munmap 0030 free 0064 __assert_fail"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 80 03 00 0C 93 E1 00 0C 7C 7F 1B 78 2F 80 00 00 40 9E 00 2C 80 9F 00 08 80 63 00 00 4? ?? ?? ?? 7F E3 FB 78 4? ?? ?? ?? 80 01 00 14 83 E1 00 0C 38 21 00 10 7C 08 03 A6 4E 80 00 20 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 01 10 38 C6 ?? ?? 4? ?? ?? ?? }
	condition:
		$1
}

rule file_64_6_0 {
	meta:
		name = "__nscd_get_map_ref"
		size = 384
		refs = "0114 time"
	strings:
		$1 = { 94 21 FF C0 7C 08 02 A6 90 01 00 44 93 C1 00 38 83 C5 00 04 93 81 00 30 7C 7C 1B 78 2F 9E FF FF 93 A1 00 34 7C DD 33 78 93 E1 00 3C 7C BF 2B 78 93 41 00 28 93 61 00 2C 41 9E 00 A0 39 60 00 00 39 20 00 01 39 40 00 06 7C 00 F8 28 7C 00 58 00 40 82 00 0C 7D 20 F9 2D 40 A2 FF F0 4C 00 01 2C 90 01 00 0C 80 01 00 0C 90 01 00 08 80 01 00 08 2F 80 00 00 40 9E 00 FC 83 DF 00 04 2F 9E FF FF 41 9E 00 50 2F 9E 00 00 41 9E 00 B8 81 3E 00 00 80 09 00 0C 2F 80 00 00 41 9E 00 6C 81 69 00 1C 80 1E 00 10 7F 8B 00 40 41 9D 00 98 80 09 00 08 70 09 00 01 90 1D 00 00 40 82 00 B0 39 3E 00 0C 7D 60 48 28 39 6B 00 01 7D 60 49 2D 40 A2 FF F4 38 00 00 00 90 1F 00 00 80 01 00 44 7F C3 F3 78 83 41 00 28 7C 08 03 A6 83 61 00 2C 83 81 00 30 83 A1 00 34 83 C1 00 38 83 E1 00 3C 38 21 00 40 4E 80 00 20 83 49 00 10 38 60 00 00 83 69 00 14 90 81 00 18 4? ?? ?? ?? 7C 60 FE 70 33 7B 01 2C 7F 5A 01 94 80 81 00 18 7F 80 D0 40 41 9D 00 14 7F 80 D0 00 40 9E 00 2C 7F 83 D8 40 40 9D 00 24 7F 83 E3 78 38 BF 00 04 4B FF FB 25 2F 83 FF FF 7C 7E 1B 78 41 BE FF 7C 81 23 00 00 4B FF FF 50 81 3E 00 00 4B FF FF 38 3B C0 FF FF 4B FF FF 64 35 4A FF FF 40 82 FE D4 3B C0 FF FF 4B FF FF 5C }
	condition:
		$1
}

rule file_64_7_0 {
	meta:
		name = "__nscd_cache_search"
		size = 484
		refs = "0050 __nis_hash 0148 memcmp"
	strings:
		$1 = { 94 21 FF D0 7C 08 02 A6 93 C1 00 28 7C 9E 23 78 7C A4 2B 78 93 81 00 20 7C DC 33 78 93 A1 00 24 7C 7D 1B 78 7F C3 F3 78 90 01 00 34 92 C1 00 08 7C F6 3B 78 93 41 00 18 93 61 00 1C 93 E1 00 2C 7C BF 2B 78 92 E1 00 0C 93 01 00 10 93 21 00 14 4? ?? ?? ?? 39 60 00 00 81 3C 00 00 83 5C 00 10 80 09 00 18 7D 43 03 96 7C 0A 01 D6 7C 60 18 50 38 63 00 18 54 63 10 3A 7D 29 1A 14 83 69 00 08 2F 9B FF FF 41 9E 01 24 38 1B 00 1C 7F 9A 00 40 41 9C 01 18 82 FC 00 04 7F 97 DA 14 73 80 00 03 40 82 01 08 3F 20 CC CC 63 39 CC CD 7F 3A C8 16 3B 00 00 00 57 39 D9 7E 3A D6 00 18 48 00 00 58 2F 99 00 00 41 9E 00 E0 2F 98 00 00 41 9E 00 20 7D 37 DA 14 71 20 00 03 40 82 00 CC 3B 7B 00 1C 7F 9A D8 40 41 9C 00 C0 83 69 00 10 2F 9C FF FF 41 9E 00 B4 38 1C 00 1C 7F 9A 00 40 41 9C 00 A8 7F 97 E2 14 73 80 00 03 40 82 00 9C 3B 39 FF FF 23 18 00 01 88 1C 00 00 7F 80 E8 00 40 9E 00 7C 80 1C 00 04 7F 80 F8 00 40 9E 00 70 80 9C 00 08 7C 04 FA 14 7F 9A 00 40 41 9C 00 60 7F C3 F3 78 7C 97 22 14 7F E5 FB 78 4? ?? ?? ?? 2F 83 00 00 40 9E 00 48 81 3C 00 14 38 09 00 18 7F 9A 00 40 41 9C 00 38 7D 77 4A 14 71 60 00 07 40 82 00 38 88 0B 00 12 2F 80 00 00 41 9E 00 20 7C 17 48 2E 7C 09 02 14 7F 9A 00 40 41 9C 00 10 7D 36 4A 14 7F 9A 48 40 40 9C 00 14 83 9C 00 10 7F 9B E0 00 40 9E FF 20 39 60 00 00 80 01 00 34 7D 63 5B 78 82 C1 00 08 7C 08 03 A6 82 E1 00 0C 83 01 00 10 83 21 00 14 83 41 00 18 83 61 00 1C 83 81 00 20 83 A1 00 24 83 C1 00 28 83 E1 00 2C 38 21 00 30 4E 80 00 20 }
	condition:
		$1
}

rule file_64_8_0 {
	meta:
		name = "__nscd_open_socket"
		size = 244
		refs = "006e _GLOBAL_OFFSET_TABLE_ 0076 __libc_errno 00b0 __read"
	strings:
		$1 = { 2B 84 04 00 94 21 FF E0 7C 08 02 A6 93 61 00 0C 7C FB 3B 78 90 01 00 24 7C 80 23 78 7C 64 1B 78 93 81 00 10 7C DC 33 78 93 A1 00 14 3B A0 FF FF 93 41 00 08 93 C1 00 18 93 E1 00 1C 40 9D 00 30 80 01 00 24 7F A3 EB 78 83 41 00 08 7C 08 03 A6 83 61 00 0C 83 81 00 10 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 3F E0 ?? ?? 3B FF ?? ?? 83 5F ?? ?? 7C A3 2B 78 7F 5A 12 14 7C 05 03 78 83 DA 00 00 4B FF F1 BD 7C 7D 1B 79 41 80 00 50 38 80 13 88 4B FF F0 89 2F 83 00 00 40 9D 00 30 7F A3 EB 78 7F 84 E3 78 7F 65 DB 78 4? ?? ?? ?? 2F 83 FF FF 40 9E 00 10 80 1A 00 00 2F 80 00 04 41 9E FF E0 7F 83 D8 00 41 9E FF 74 38 00 00 06 7F A3 EB 78 44 00 00 02 7C 00 00 26 83 FF ?? ?? 7F FF 12 14 93 DF 00 00 3B A0 FF FF 4B FF FF 50 }
	condition:
		$1
}

rule file_66_0_0 {
	meta:
		name = "convert_and_print"
		size = 404
		refs = "003c strlen 006c realloc 0094 __mbsrtowcs 00fa stderr 0108 __vfwprintf 015c fputws_unlocked"
	strings:
		$1 = { 94 21 FF C0 7C 08 02 A6 93 41 00 28 7C 7A 1B 79 93 01 00 20 7C 98 23 78 93 E1 00 3C 7C 3F 0B 78 90 01 00 44 93 21 00 24 93 61 00 2C 93 81 00 30 93 A1 00 34 93 C1 00 38 41 82 00 D4 4? ?? ?? ?? 3B C0 00 00 3B A3 00 01 57 BB 10 3A 3B 3B 00 1E 57 39 00 36 7F 39 00 D0 3B 80 00 00 48 00 00 44 41 9A 00 08 7F DE 00 38 7F C3 F3 78 4? ?? ?? ?? 7C 7E 1B 79 41 82 00 D8 7F C3 F3 78 93 9F 00 0C 38 9F 00 08 7F A5 EB 78 93 9F 00 10 38 DF 00 0C 93 5F 00 08 4? ?? ?? ?? 7F 9D 18 00 40 9E 00 54 2B 9D 07 CF 7F 64 DB 78 2F 1E 00 00 20 1D 0F 9F 7C 00 01 10 41 9D FF AC 80 01 00 00 38 9F 00 08 7F A5 EB 78 93 9F 00 0C 38 DF 00 0C 7C 01 C9 6E 3B C1 00 17 93 9F 00 10 57 DE 00 36 7F C3 F3 78 93 5F 00 08 4? ?? ?? ?? 7F 9D 18 00 41 9E FF B4 2F 83 FF FF 41 9E 00 4C 3D 20 ?? ?? 80 69 ?? ?? 7F C4 F3 78 7F 05 C3 78 4? ?? ?? ?? 39 7F 00 40 80 0B 00 04 83 0B FF E0 7C 08 03 A6 83 2B FF E4 83 4B FF E8 83 6B FF EC 83 8B FF F0 83 AB FF F4 83 CB FF F8 83 EB FF FC 7D 61 5B 78 4E 80 00 20 3F C0 ?? ?? 3B DE ?? ?? 4B FF FF B0 3D 20 ?? ?? 80 89 ?? ?? 3C 60 ?? ?? 38 63 ?? ?? 4? ?? ?? ?? 39 7F 00 40 80 0B 00 04 83 0B FF E0 7C 08 03 A6 83 2B FF E4 83 4B FF E8 83 6B FF EC 83 8B FF F0 83 AB FF F4 83 CB FF F8 83 EB FF FC 7D 61 5B 78 4E 80 00 20 }
	condition:
		$1
}

rule file_66_1_0 {
	meta:
		name = "vwarnx"
		size = 260
		refs = "000e stderr 0036 __progname 004c __fwprintf 0064 putwc_unlocked 009c fprintf 00b4 vfprintf 00fc __overflow"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 93 E1 00 1C 3F E0 ?? ?? 90 01 00 24 81 3F ?? ?? 93 A1 00 14 7C 9D 23 78 80 09 00 6C 93 C1 00 18 7C 7E 1B 78 2F 80 00 00 40 9D 00 54 3D 60 ?? ?? 80 AB ?? ?? 3C 80 ?? ?? 7D 23 4B 78 38 84 ?? ?? 4C C6 31 82 4? ?? ?? ?? 7F C3 F3 78 7F A4 EB 78 4B FF FE 15 80 9F ?? ?? 38 60 00 0A 4? ?? ?? ?? 80 01 00 24 83 A1 00 14 7C 08 03 A6 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 3D 60 ?? ?? 80 AB ?? ?? 3C 80 ?? ?? 7D 23 4B 78 38 84 ?? ?? 4C C6 31 82 4? ?? ?? ?? 2F 9E 00 00 41 9E 00 14 80 7F ?? ?? 7F C4 F3 78 7F A5 EB 78 4? ?? ?? ?? 80 7F ?? ?? 81 23 00 14 80 03 00 18 7F 89 00 40 40 9C 00 30 39 60 00 0A 99 69 00 00 38 09 00 01 90 03 00 14 80 01 00 24 83 A1 00 14 7C 08 03 A6 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 38 80 00 0A 4? ?? ?? ?? 4B FF FF 68 }
	condition:
		$1
}

rule file_66_2_0 {
	meta:
		name = "vwarn"
		size = 356
		refs = "000e stderr 001e _GLOBAL_OFFSET_TABLE_ 002a __libc_errno 0052 __progname 0068 __fwprintf 008c fputws_unlocked 00ec fprintf 0104 vfprintf 011c fwrite_unlocked"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 93 E1 00 1C 3F E0 ?? ?? 90 01 00 24 81 3F ?? ?? 93 C1 00 18 3F C0 ?? ?? 3B DE ?? ?? 80 09 00 6C 81 7E ?? ?? 7D 6B 12 14 93 61 00 0C 2F 80 00 00 93 81 00 10 7C 9B 23 78 7C 7C 1B 78 93 A1 00 14 83 AB 00 00 40 9D 00 88 3D 60 ?? ?? 80 AB ?? ?? 3C 80 ?? ?? 7D 23 4B 78 38 84 ?? ?? 4C C6 31 82 4? ?? ?? ?? 2F 9C 00 00 41 9E 00 20 7F 83 E3 78 7F 64 DB 78 4B FF FC ED 3C 60 ?? ?? 80 9F ?? ?? 38 63 ?? ?? 4? ?? ?? ?? 83 DE ?? ?? 80 7F ?? ?? 7F DE 12 14 93 BE 00 00 3C 80 ?? ?? 38 84 ?? ?? 4C C6 31 82 4? ?? ?? ?? 80 01 00 24 83 61 00 0C 7C 08 03 A6 83 81 00 10 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 3D 60 ?? ?? 80 AB ?? ?? 3C 80 ?? ?? 7D 23 4B 78 38 84 ?? ?? 4C C6 31 82 4? ?? ?? ?? 2F 9C 00 00 41 9E 00 2C 80 7F ?? ?? 7F 84 E3 78 7F 65 DB 78 4? ?? ?? ?? 3C 60 ?? ?? 80 DF ?? ?? 38 63 ?? ?? 38 80 00 01 38 A0 00 02 4? ?? ?? ?? 83 DE ?? ?? 80 7F ?? ?? 7F DE 12 14 93 BE 00 00 3C 80 ?? ?? 38 84 ?? ?? 4C C6 31 82 4? ?? ?? ?? 80 01 00 24 83 61 00 0C 7C 08 03 A6 83 81 00 10 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 }
	condition:
		$1
}

rule file_66_3_0 {
	meta:
		name = "warn"
		size = 132
		refs = "0070 vwarn"
		altNames = "warnx"
	strings:
		$1 = { 94 21 FF 80 7C 08 02 A6 90 81 00 1C 90 01 00 84 90 A1 00 20 90 C1 00 24 90 E1 00 28 91 01 00 2C 91 21 00 30 91 41 00 34 40 86 00 24 D8 21 00 38 D8 41 00 40 D8 61 00 48 D8 81 00 50 D8 A1 00 58 D8 C1 00 60 D8 E1 00 68 D9 01 00 70 38 00 00 01 98 01 00 08 38 00 00 00 38 81 00 08 98 01 00 09 38 01 00 88 90 01 00 0C 38 01 00 18 90 01 00 10 4? ?? ?? ?? 80 01 00 84 38 21 00 80 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_66_5_0 {
	meta:
		name = "verr"
		size = 40
		refs = "001c vwarn 0024 exit"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 93 E1 00 0C 7C 7F 1B 78 7C 83 23 78 7C A4 2B 78 90 01 00 14 4? ?? ?? ?? 7F E3 FB 78 4? ?? ?? ?? }
	condition:
		$1
}

rule file_66_6_0 {
	meta:
		name = "verrx"
		size = 40
		refs = "001c vwarnx 0024 exit"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 93 E1 00 0C 7C 7F 1B 78 7C 83 23 78 7C A4 2B 78 90 01 00 14 4? ?? ?? ?? 7F E3 FB 78 4? ?? ?? ?? }
	condition:
		$1
}

rule file_66_7_0 {
	meta:
		name = "err"
		size = 112
		refs = "006c verr"
		altNames = "errx"
	strings:
		$1 = { 94 21 FF 90 7C 08 02 A6 90 A1 00 18 90 01 00 74 90 C1 00 1C 90 E1 00 20 91 01 00 24 91 21 00 28 91 41 00 2C 40 86 00 24 D8 21 00 30 D8 41 00 38 D8 61 00 40 D8 81 00 48 D8 A1 00 50 D8 C1 00 58 D8 E1 00 60 D9 01 00 68 38 00 00 02 98 01 00 08 38 00 00 00 38 A1 00 08 98 01 00 09 38 01 00 78 90 01 00 0C 38 01 00 10 90 01 00 10 4? ?? ?? ?? }
	condition:
		$1
}

rule file_200_3_0 {
	meta:
		name = "_IO_obstack_printf"
		size = 128
		refs = "006c _IO_obstack_vprintf"
	strings:
		$1 = { 94 21 FF 90 7C 08 02 A6 90 A1 00 18 90 01 00 74 90 C1 00 1C 90 E1 00 20 91 01 00 24 91 21 00 28 91 41 00 2C 40 86 00 24 D8 21 00 30 D8 41 00 38 D8 61 00 40 D8 81 00 48 D8 A1 00 50 D8 C1 00 58 D8 E1 00 60 D9 01 00 68 38 00 00 02 98 01 00 08 38 00 00 00 38 A1 00 08 98 01 00 09 38 01 00 78 90 01 00 0C 38 01 00 10 90 01 00 10 4? ?? ?? ?? 80 01 00 74 38 21 00 70 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_1382_0_0 {
	meta:
		name = "___asprintf"
		size = 128
		refs = "006c _IO_vasprintf"
	strings:
		$1 = { 94 21 FF 90 7C 08 02 A6 90 A1 00 18 90 01 00 74 90 C1 00 1C 90 E1 00 20 91 01 00 24 91 21 00 28 91 41 00 2C 40 86 00 24 D8 21 00 30 D8 41 00 38 D8 61 00 40 D8 81 00 48 D8 A1 00 50 D8 C1 00 58 D8 E1 00 60 D9 01 00 68 38 00 00 02 98 01 00 08 38 00 00 00 38 A1 00 08 98 01 00 09 38 01 00 78 90 01 00 0C 38 01 00 10 90 01 00 10 4? ?? ?? ?? 80 01 00 74 38 21 00 70 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_1243_0_0 {
	meta:
		name = "__dprintf"
		size = 128
		refs = "006c _IO_vdprintf"
	strings:
		$1 = { 94 21 FF 90 7C 08 02 A6 90 A1 00 18 90 01 00 74 90 C1 00 1C 90 E1 00 20 91 01 00 24 91 21 00 28 91 41 00 2C 40 86 00 24 D8 21 00 30 D8 41 00 38 D8 61 00 40 D8 81 00 48 D8 A1 00 50 D8 C1 00 58 D8 E1 00 60 D9 01 00 68 38 00 00 02 98 01 00 08 38 00 00 00 38 A1 00 08 98 01 00 09 38 01 00 78 90 01 00 0C 38 01 00 10 90 01 00 10 4? ?? ?? ?? 80 01 00 74 38 21 00 70 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_864_0_0 {
	meta:
		name = "__fprintf"
		size = 128
		refs = "006c vfprintf"
	strings:
		$1 = { 94 21 FF 90 7C 08 02 A6 90 A1 00 18 90 01 00 74 90 C1 00 1C 90 E1 00 20 91 01 00 24 91 21 00 28 91 41 00 2C 40 86 00 24 D8 21 00 30 D8 41 00 38 D8 61 00 40 D8 81 00 48 D8 A1 00 50 D8 C1 00 58 D8 E1 00 60 D9 01 00 68 38 00 00 02 98 01 00 08 38 00 00 00 38 A1 00 08 98 01 00 09 38 01 00 78 90 01 00 0C 38 01 00 10 90 01 00 10 4? ?? ?? ?? 80 01 00 74 38 21 00 70 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_1258_0_0 {
	meta:
		name = "__fscanf"
		size = 128
		refs = "006c __vfscanf"
	strings:
		$1 = { 94 21 FF 90 7C 08 02 A6 90 A1 00 18 90 01 00 74 90 C1 00 1C 90 E1 00 20 91 01 00 24 91 21 00 28 91 41 00 2C 40 86 00 24 D8 21 00 30 D8 41 00 38 D8 61 00 40 D8 81 00 48 D8 A1 00 50 D8 C1 00 58 D8 E1 00 60 D9 01 00 68 38 00 00 02 98 01 00 08 38 00 00 00 38 A1 00 08 98 01 00 09 38 01 00 78 90 01 00 0C 38 01 00 10 90 01 00 10 4? ?? ?? ?? 80 01 00 74 38 21 00 70 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_849_0_0 {
	meta:
		name = "__fwprintf"
		size = 128
		refs = "006c __vfwprintf"
	strings:
		$1 = { 94 21 FF 90 7C 08 02 A6 90 A1 00 18 90 01 00 74 90 C1 00 1C 90 E1 00 20 91 01 00 24 91 21 00 28 91 41 00 2C 40 86 00 24 D8 21 00 30 D8 41 00 38 D8 61 00 40 D8 81 00 48 D8 A1 00 50 D8 C1 00 58 D8 E1 00 60 D9 01 00 68 38 00 00 02 98 01 00 08 38 00 00 00 38 A1 00 08 98 01 00 09 38 01 00 78 90 01 00 0C 38 01 00 10 90 01 00 10 4? ?? ?? ?? 80 01 00 74 38 21 00 70 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_878_0_0 {
	meta:
		name = "__fwscanf"
		size = 128
		refs = "006c __vfwscanf"
	strings:
		$1 = { 94 21 FF 90 7C 08 02 A6 90 A1 00 18 90 01 00 74 90 C1 00 1C 90 E1 00 20 91 01 00 24 91 21 00 28 91 41 00 2C 40 86 00 24 D8 21 00 30 D8 41 00 38 D8 61 00 40 D8 81 00 48 D8 A1 00 50 D8 C1 00 58 D8 E1 00 60 D9 01 00 68 38 00 00 02 98 01 00 08 38 00 00 00 38 A1 00 08 98 01 00 09 38 01 00 78 90 01 00 0C 38 01 00 10 90 01 00 10 4? ?? ?? ?? 80 01 00 74 38 21 00 70 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_541_0_0 {
	meta:
		name = "__isoc99_sscanf"
		size = 128
		refs = "006c __isoc99_vsscanf"
	strings:
		$1 = { 94 21 FF 90 7C 08 02 A6 90 A1 00 18 90 01 00 74 90 C1 00 1C 90 E1 00 20 91 01 00 24 91 21 00 28 91 41 00 2C 40 86 00 24 D8 21 00 30 D8 41 00 38 D8 61 00 40 D8 81 00 48 D8 A1 00 50 D8 C1 00 58 D8 E1 00 60 D9 01 00 68 38 00 00 02 98 01 00 08 38 00 00 00 38 A1 00 08 98 01 00 09 38 01 00 78 90 01 00 0C 38 01 00 10 90 01 00 10 4? ?? ?? ?? 80 01 00 74 38 21 00 70 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_1041_0_0 {
	meta:
		name = "__isoc99_swscanf"
		size = 128
		refs = "006c __isoc99_vswscanf"
	strings:
		$1 = { 94 21 FF 90 7C 08 02 A6 90 A1 00 18 90 01 00 74 90 C1 00 1C 90 E1 00 20 91 01 00 24 91 21 00 28 91 41 00 2C 40 86 00 24 D8 21 00 30 D8 41 00 38 D8 61 00 40 D8 81 00 48 D8 A1 00 50 D8 C1 00 58 D8 E1 00 60 D9 01 00 68 38 00 00 02 98 01 00 08 38 00 00 00 38 A1 00 08 98 01 00 09 38 01 00 78 90 01 00 0C 38 01 00 10 90 01 00 10 4? ?? ?? ?? 80 01 00 74 38 21 00 70 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_1249_79_0 {
	meta:
		name = "__nldbl__IO_fprintf"
		size = 128
		refs = "006c __nldbl_vfprintf"
	strings:
		$1 = { 94 21 FF 90 7C 08 02 A6 90 A1 00 18 90 01 00 74 90 C1 00 1C 90 E1 00 20 91 01 00 24 91 21 00 28 91 41 00 2C 40 86 00 24 D8 21 00 30 D8 41 00 38 D8 61 00 40 D8 81 00 48 D8 A1 00 50 D8 C1 00 58 D8 E1 00 60 D9 01 00 68 38 00 00 02 98 01 00 08 38 00 00 00 38 A1 00 08 98 01 00 09 38 01 00 78 90 01 00 0C 38 01 00 10 90 01 00 10 4? ?? ?? ?? 80 01 00 74 38 21 00 70 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_1249_81_0 {
	meta:
		name = "__nldbl__IO_sprintf"
		size = 128
		refs = "006c __nldbl_vsprintf"
	strings:
		$1 = { 94 21 FF 90 7C 08 02 A6 90 A1 00 18 90 01 00 74 90 C1 00 1C 90 E1 00 20 91 01 00 24 91 21 00 28 91 41 00 2C 40 86 00 24 D8 21 00 30 D8 41 00 38 D8 61 00 40 D8 81 00 48 D8 A1 00 50 D8 C1 00 58 D8 E1 00 60 D9 01 00 68 38 00 00 02 98 01 00 08 38 00 00 00 38 A1 00 08 98 01 00 09 38 01 00 78 90 01 00 0C 38 01 00 10 90 01 00 10 4? ?? ?? ?? 80 01 00 74 38 21 00 70 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_1249_84_0 {
	meta:
		name = "__nldbl__IO_sscanf"
		size = 128
		refs = "006c __nldbl_vsscanf"
	strings:
		$1 = { 94 21 FF 90 7C 08 02 A6 90 A1 00 18 90 01 00 74 90 C1 00 1C 90 E1 00 20 91 01 00 24 91 21 00 28 91 41 00 2C 40 86 00 24 D8 21 00 30 D8 41 00 38 D8 61 00 40 D8 81 00 48 D8 A1 00 50 D8 C1 00 58 D8 E1 00 60 D9 01 00 68 38 00 00 02 98 01 00 08 38 00 00 00 38 A1 00 08 98 01 00 09 38 01 00 78 90 01 00 0C 38 01 00 10 90 01 00 10 4? ?? ?? ?? 80 01 00 74 38 21 00 70 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_1249_10_0 {
	meta:
		name = "__nldbl___asprintf"
		size = 128
		refs = "006c __nldbl_vasprintf"
	strings:
		$1 = { 94 21 FF 90 7C 08 02 A6 90 A1 00 18 90 01 00 74 90 C1 00 1C 90 E1 00 20 91 01 00 24 91 21 00 28 91 41 00 2C 40 86 00 24 D8 21 00 30 D8 41 00 38 D8 61 00 40 D8 81 00 48 D8 A1 00 50 D8 C1 00 58 D8 E1 00 60 D9 01 00 68 38 00 00 02 98 01 00 08 38 00 00 00 38 A1 00 08 98 01 00 09 38 01 00 78 90 01 00 0C 38 01 00 10 90 01 00 10 4? ?? ?? ?? 80 01 00 74 38 21 00 70 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_1249_70_0 {
	meta:
		name = "__nldbl___isoc99_fscanf"
		size = 128
		refs = "006c __nldbl___isoc99_vfscanf"
	strings:
		$1 = { 94 21 FF 90 7C 08 02 A6 90 A1 00 18 90 01 00 74 90 C1 00 1C 90 E1 00 20 91 01 00 24 91 21 00 28 91 41 00 2C 40 86 00 24 D8 21 00 30 D8 41 00 38 D8 61 00 40 D8 81 00 48 D8 A1 00 50 D8 C1 00 58 D8 E1 00 60 D9 01 00 68 38 00 00 02 98 01 00 08 38 00 00 00 38 A1 00 08 98 01 00 09 38 01 00 78 90 01 00 0C 38 01 00 10 90 01 00 10 4? ?? ?? ?? 80 01 00 74 38 21 00 70 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_1249_76_0 {
	meta:
		name = "__nldbl___isoc99_fwscanf"
		size = 128
		refs = "006c __nldbl___isoc99_vfwscanf"
	strings:
		$1 = { 94 21 FF 90 7C 08 02 A6 90 A1 00 18 90 01 00 74 90 C1 00 1C 90 E1 00 20 91 01 00 24 91 21 00 28 91 41 00 2C 40 86 00 24 D8 21 00 30 D8 41 00 38 D8 61 00 40 D8 81 00 48 D8 A1 00 50 D8 C1 00 58 D8 E1 00 60 D9 01 00 68 38 00 00 02 98 01 00 08 38 00 00 00 38 A1 00 08 98 01 00 09 38 01 00 78 90 01 00 0C 38 01 00 10 90 01 00 10 4? ?? ?? ?? 80 01 00 74 38 21 00 70 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_1249_68_0 {
	meta:
		name = "__nldbl___isoc99_sscanf"
		size = 128
		refs = "006c __nldbl___isoc99_vsscanf"
	strings:
		$1 = { 94 21 FF 90 7C 08 02 A6 90 A1 00 18 90 01 00 74 90 C1 00 1C 90 E1 00 20 91 01 00 24 91 21 00 28 91 41 00 2C 40 86 00 24 D8 21 00 30 D8 41 00 38 D8 61 00 40 D8 81 00 48 D8 A1 00 50 D8 C1 00 58 D8 E1 00 60 D9 01 00 68 38 00 00 02 98 01 00 08 38 00 00 00 38 A1 00 08 98 01 00 09 38 01 00 78 90 01 00 0C 38 01 00 10 90 01 00 10 4? ?? ?? ?? 80 01 00 74 38 21 00 70 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_1249_74_0 {
	meta:
		name = "__nldbl___isoc99_swscanf"
		size = 128
		refs = "006c __nldbl___isoc99_vswscanf"
	strings:
		$1 = { 94 21 FF 90 7C 08 02 A6 90 A1 00 18 90 01 00 74 90 C1 00 1C 90 E1 00 20 91 01 00 24 91 21 00 28 91 41 00 2C 40 86 00 24 D8 21 00 30 D8 41 00 38 D8 61 00 40 D8 81 00 48 D8 A1 00 50 D8 C1 00 58 D8 E1 00 60 D9 01 00 68 38 00 00 02 98 01 00 08 38 00 00 00 38 A1 00 08 98 01 00 09 38 01 00 78 90 01 00 0C 38 01 00 10 90 01 00 10 4? ?? ?? ?? 80 01 00 74 38 21 00 70 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_1249_78_0 {
	meta:
		name = "__nldbl_asprintf"
		size = 128
		refs = "006c __nldbl_vasprintf"
	strings:
		$1 = { 94 21 FF 90 7C 08 02 A6 90 A1 00 18 90 01 00 74 90 C1 00 1C 90 E1 00 20 91 01 00 24 91 21 00 28 91 41 00 2C 40 86 00 24 D8 21 00 30 D8 41 00 38 D8 61 00 40 D8 81 00 48 D8 A1 00 50 D8 C1 00 58 D8 E1 00 60 D9 01 00 68 38 00 00 02 98 01 00 08 38 00 00 00 38 A1 00 08 98 01 00 09 38 01 00 78 90 01 00 0C 38 01 00 10 90 01 00 10 4? ?? ?? ?? 80 01 00 74 38 21 00 70 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_1249_12_0 {
	meta:
		name = "__nldbl_dprintf"
		size = 128
		refs = "006c __nldbl_vdprintf"
	strings:
		$1 = { 94 21 FF 90 7C 08 02 A6 90 A1 00 18 90 01 00 74 90 C1 00 1C 90 E1 00 20 91 01 00 24 91 21 00 28 91 41 00 2C 40 86 00 24 D8 21 00 30 D8 41 00 38 D8 61 00 40 D8 81 00 48 D8 A1 00 50 D8 C1 00 58 D8 E1 00 60 D9 01 00 68 38 00 00 02 98 01 00 08 38 00 00 00 38 A1 00 08 98 01 00 09 38 01 00 78 90 01 00 0C 38 01 00 10 90 01 00 10 4? ?? ?? ?? 80 01 00 74 38 21 00 70 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_1249_5_0 {
	meta:
		name = "__nldbl_fprintf"
		size = 128
		refs = "006c __nldbl_vfprintf"
	strings:
		$1 = { 94 21 FF 90 7C 08 02 A6 90 A1 00 18 90 01 00 74 90 C1 00 1C 90 E1 00 20 91 01 00 24 91 21 00 28 91 41 00 2C 40 86 00 24 D8 21 00 30 D8 41 00 38 D8 61 00 40 D8 81 00 48 D8 A1 00 50 D8 C1 00 58 D8 E1 00 60 D9 01 00 68 38 00 00 02 98 01 00 08 38 00 00 00 38 A1 00 08 98 01 00 09 38 01 00 78 90 01 00 0C 38 01 00 10 90 01 00 10 4? ?? ?? ?? 80 01 00 74 38 21 00 70 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_1249_28_0 {
	meta:
		name = "__nldbl_fscanf"
		size = 128
		refs = "006c __nldbl_vfscanf"
	strings:
		$1 = { 94 21 FF 90 7C 08 02 A6 90 A1 00 18 90 01 00 74 90 C1 00 1C 90 E1 00 20 91 01 00 24 91 21 00 28 91 41 00 2C 40 86 00 24 D8 21 00 30 D8 41 00 38 D8 61 00 40 D8 81 00 48 D8 A1 00 50 D8 C1 00 58 D8 E1 00 60 D9 01 00 68 38 00 00 02 98 01 00 08 38 00 00 00 38 A1 00 08 98 01 00 09 38 01 00 78 90 01 00 0C 38 01 00 10 90 01 00 10 4? ?? ?? ?? 80 01 00 74 38 21 00 70 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_1249_14_0 {
	meta:
		name = "__nldbl_fwprintf"
		size = 128
		refs = "006c __nldbl_vfwprintf"
	strings:
		$1 = { 94 21 FF 90 7C 08 02 A6 90 A1 00 18 90 01 00 74 90 C1 00 1C 90 E1 00 20 91 01 00 24 91 21 00 28 91 41 00 2C 40 86 00 24 D8 21 00 30 D8 41 00 38 D8 61 00 40 D8 81 00 48 D8 A1 00 50 D8 C1 00 58 D8 E1 00 60 D9 01 00 68 38 00 00 02 98 01 00 08 38 00 00 00 38 A1 00 08 98 01 00 09 38 01 00 78 90 01 00 0C 38 01 00 10 90 01 00 10 4? ?? ?? ?? 80 01 00 74 38 21 00 70 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_1249_34_0 {
	meta:
		name = "__nldbl_fwscanf"
		size = 128
		refs = "006c __nldbl_vfwscanf"
	strings:
		$1 = { 94 21 FF 90 7C 08 02 A6 90 A1 00 18 90 01 00 74 90 C1 00 1C 90 E1 00 20 91 01 00 24 91 21 00 28 91 41 00 2C 40 86 00 24 D8 21 00 30 D8 41 00 38 D8 61 00 40 D8 81 00 48 D8 A1 00 50 D8 C1 00 58 D8 E1 00 60 D9 01 00 68 38 00 00 02 98 01 00 08 38 00 00 00 38 A1 00 08 98 01 00 09 38 01 00 78 90 01 00 0C 38 01 00 10 90 01 00 10 4? ?? ?? ?? 80 01 00 74 38 21 00 70 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_1249_8_0 {
	meta:
		name = "__nldbl_obstack_printf"
		size = 128
		refs = "006c __nldbl_obstack_vprintf"
	strings:
		$1 = { 94 21 FF 90 7C 08 02 A6 90 A1 00 18 90 01 00 74 90 C1 00 1C 90 E1 00 20 91 01 00 24 91 21 00 28 91 41 00 2C 40 86 00 24 D8 21 00 30 D8 41 00 38 D8 61 00 40 D8 81 00 48 D8 A1 00 50 D8 C1 00 58 D8 E1 00 60 D9 01 00 68 38 00 00 02 98 01 00 08 38 00 00 00 38 A1 00 08 98 01 00 09 38 01 00 78 90 01 00 0C 38 01 00 10 90 01 00 10 4? ?? ?? ?? 80 01 00 74 38 21 00 70 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_1249_1_0 {
	meta:
		name = "__nldbl_sprintf"
		size = 128
		refs = "006c __nldbl_vsprintf"
	strings:
		$1 = { 94 21 FF 90 7C 08 02 A6 90 A1 00 18 90 01 00 74 90 C1 00 1C 90 E1 00 20 91 01 00 24 91 21 00 28 91 41 00 2C 40 86 00 24 D8 21 00 30 D8 41 00 38 D8 61 00 40 D8 81 00 48 D8 A1 00 50 D8 C1 00 58 D8 E1 00 60 D9 01 00 68 38 00 00 02 98 01 00 08 38 00 00 00 38 A1 00 08 98 01 00 09 38 01 00 78 90 01 00 0C 38 01 00 10 90 01 00 10 4? ?? ?? ?? 80 01 00 74 38 21 00 70 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_1249_24_0 {
	meta:
		name = "__nldbl_sscanf"
		size = 128
		refs = "006c __nldbl_vsscanf"
	strings:
		$1 = { 94 21 FF 90 7C 08 02 A6 90 A1 00 18 90 01 00 74 90 C1 00 1C 90 E1 00 20 91 01 00 24 91 21 00 28 91 41 00 2C 40 86 00 24 D8 21 00 30 D8 41 00 38 D8 61 00 40 D8 81 00 48 D8 A1 00 50 D8 C1 00 58 D8 E1 00 60 D9 01 00 68 38 00 00 02 98 01 00 08 38 00 00 00 38 A1 00 08 98 01 00 09 38 01 00 78 90 01 00 0C 38 01 00 10 90 01 00 10 4? ?? ?? ?? 80 01 00 74 38 21 00 70 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_1249_32_0 {
	meta:
		name = "__nldbl_swscanf"
		size = 128
		refs = "006c __nldbl_vswscanf"
	strings:
		$1 = { 94 21 FF 90 7C 08 02 A6 90 A1 00 18 90 01 00 74 90 C1 00 1C 90 E1 00 20 91 01 00 24 91 21 00 28 91 41 00 2C 40 86 00 24 D8 21 00 30 D8 41 00 38 D8 61 00 40 D8 81 00 48 D8 A1 00 50 D8 C1 00 58 D8 E1 00 60 D9 01 00 68 38 00 00 02 98 01 00 08 38 00 00 00 38 A1 00 08 98 01 00 09 38 01 00 78 90 01 00 0C 38 01 00 10 90 01 00 10 4? ?? ?? ?? 80 01 00 74 38 21 00 70 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_612_0_0 {
	meta:
		name = "__sprintf"
		size = 128
		refs = "006c _IO_vsprintf"
	strings:
		$1 = { 94 21 FF 90 7C 08 02 A6 90 A1 00 18 90 01 00 74 90 C1 00 1C 90 E1 00 20 91 01 00 24 91 21 00 28 91 41 00 2C 40 86 00 24 D8 21 00 30 D8 41 00 38 D8 61 00 40 D8 81 00 48 D8 A1 00 50 D8 C1 00 58 D8 E1 00 60 D9 01 00 68 38 00 00 02 98 01 00 08 38 00 00 00 38 A1 00 08 98 01 00 09 38 01 00 78 90 01 00 0C 38 01 00 10 90 01 00 10 4? ?? ?? ?? 80 01 00 74 38 21 00 70 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_341_0_0 {
	meta:
		name = "__sscanf"
		size = 128
		refs = "006c _IO_vsscanf"
	strings:
		$1 = { 94 21 FF 90 7C 08 02 A6 90 A1 00 18 90 01 00 74 90 C1 00 1C 90 E1 00 20 91 01 00 24 91 21 00 28 91 41 00 2C 40 86 00 24 D8 21 00 30 D8 41 00 38 D8 61 00 40 D8 81 00 48 D8 A1 00 50 D8 C1 00 58 D8 E1 00 60 D9 01 00 68 38 00 00 02 98 01 00 08 38 00 00 00 38 A1 00 08 98 01 00 09 38 01 00 78 90 01 00 0C 38 01 00 10 90 01 00 10 4? ?? ?? ?? 80 01 00 74 38 21 00 70 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_848_0_0 {
	meta:
		name = "__swscanf"
		size = 128
		refs = "006c vswscanf"
	strings:
		$1 = { 94 21 FF 90 7C 08 02 A6 90 A1 00 18 90 01 00 74 90 C1 00 1C 90 E1 00 20 91 01 00 24 91 21 00 28 91 41 00 2C 40 86 00 24 D8 21 00 30 D8 41 00 38 D8 61 00 40 D8 81 00 48 D8 A1 00 50 D8 C1 00 58 D8 E1 00 60 D9 01 00 68 38 00 00 02 98 01 00 08 38 00 00 00 38 A1 00 08 98 01 00 09 38 01 00 78 90 01 00 0C 38 01 00 10 90 01 00 10 4? ?? ?? ?? 80 01 00 74 38 21 00 70 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_200_5_0 {
	meta:
		name = "obstack_printf"
		size = 128
		refs = "006c _IO_obstack_vprintf"
	strings:
		$1 = { 94 21 FF 90 7C 08 02 A6 90 A1 00 18 90 01 00 74 90 C1 00 1C 90 E1 00 20 91 01 00 24 91 21 00 28 91 41 00 2C 40 86 00 24 D8 21 00 30 D8 41 00 38 D8 61 00 40 D8 81 00 48 D8 A1 00 50 D8 C1 00 58 D8 E1 00 60 D9 01 00 68 38 00 00 02 98 01 00 08 38 00 00 00 38 A1 00 08 98 01 00 09 38 01 00 78 90 01 00 0C 38 01 00 10 90 01 00 10 4? ?? ?? ?? 80 01 00 74 38 21 00 70 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_67_0_0 {
	meta:
		name = "cancel_handler"
		size = 128
		refs = "0040 free 005c __closedir"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 90 01 00 24 80 03 00 08 93 81 00 10 2F 80 00 00 93 A1 00 14 7C 7D 1B 78 93 C1 00 18 93 E1 00 1C 83 83 00 04 41 9E 00 24 3B DC FF FC 3B E0 00 00 84 7E 00 04 3B FF 00 01 4? ?? ?? ?? 80 1D 00 08 7F 80 F8 40 41 9D FF EC 7F 83 E3 78 4? ?? ?? ?? 80 7D 00 00 4? ?? ?? ?? 80 01 00 24 83 81 00 10 7C 08 03 A6 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 }
	condition:
		$1
}

rule file_67_1_0 {
	meta:
		name = "__scandir64"
		size = 536
		refs = "004c __opendir 0058 __errno_location 0090 __readdir64 00b8 malloc 00d0 memcpy 0118 qsort 0124 __closedir 01a8 free 01e4 realloc 0214 _Unwind_Resume"
	strings:
		$1 = { 94 21 FF B0 7D 80 00 26 7C 08 02 A6 93 01 00 30 7C 98 23 78 93 21 00 34 7C D9 33 78 93 C1 00 48 90 01 00 54 92 A1 00 24 92 C1 00 28 92 E1 00 2C 93 41 00 38 93 61 00 3C 93 81 00 40 93 A1 00 44 93 E1 00 4C 91 81 00 20 90 A1 00 18 4? ?? ?? ?? 7C 7E 1B 79 41 82 01 3C 4? ?? ?? ?? 81 21 00 18 38 00 00 00 82 E3 00 00 2E 09 00 00 90 03 00 00 7C 7D 1B 78 93 C1 00 08 3B 40 00 00 3B 60 00 00 90 01 00 0C 3B 80 00 00 90 01 00 10 7F C3 F3 78 4? ?? ?? ?? 7C 7F 1B 79 41 82 00 5C 40 92 00 D8 93 9D 00 00 80 01 00 10 7F 80 D0 00 41 9E 01 24 A2 BF 00 10 7E A3 AB 78 4? ?? ?? ?? 2F 83 00 00 41 9E 00 34 82 C1 00 10 7F E4 FB 78 7E A5 AB 78 4? ?? ?? ?? 56 C0 10 3A 7C 7B 01 2E 3A D6 00 01 7F C3 F3 78 92 C1 00 10 4? ?? ?? ?? 7C 7F 1B 79 40 82 FF AC 83 FD 00 00 2F 9F 00 00 40 9E 00 B0 2F 99 00 00 41 9E 00 18 80 81 00 10 7F 63 DB 78 38 A0 00 04 7F 26 CB 78 4? ?? ?? ?? 93 78 00 00 7F C3 F3 78 4? ?? ?? ?? 92 FD 00 00 80 61 00 10 80 01 00 54 81 81 00 20 7C 08 03 A6 82 A1 00 24 82 C1 00 28 7D 80 81 20 82 E1 00 2C 83 01 00 30 83 21 00 34 83 41 00 38 83 61 00 3C 83 81 00 40 83 A1 00 44 83 C1 00 48 83 E1 00 4C 38 21 00 50 4E 80 00 20 80 01 00 18 7C 09 03 A6 4E 80 04 21 2F 83 00 00 93 9D 00 00 41 9E FF 04 4B FF FF 14 38 60 FF FF 4B FF FF 9C 30 00 FF FF 54 09 10 3A 7C 7B 48 2E 90 01 00 10 4? ?? ?? ?? 80 01 00 10 2F 80 00 00 40 9E FF E4 7F 63 DB 78 4? ?? ?? ?? 38 00 FF FF 90 01 00 10 7F F7 FB 78 4B FF FF 54 2F 9A 00 00 41 9E 00 28 57 5A 08 3C 7F 63 DB 78 57 44 10 3A 4? ?? ?? ?? 2C 03 00 00 41 A2 FF 08 90 61 00 0C 7C 7B 1B 78 4B FF FE B8 3B 40 00 0A 4B FF FF DC 7C 7F 1B 78 38 61 00 08 4B FF FD 75 7F E3 FB 78 4? ?? ?? ?? }
	condition:
		$1
}

rule file_68_0_0 {
	meta:
		name = "ether_ntohost"
		size = 440
		refs = "006a _GLOBAL_OFFSET_TABLE_ 0086 __libc_errno 00cc __nss_next2 0120 strcpy 0178 __nss_ethers_lookup"
	strings:
		$1 = { 94 21 FB B0 7C 08 02 A6 93 E1 04 4C 3F E0 ?? ?? 81 3F ?? ?? 92 E1 04 2C 7C 77 1B 78 2F 89 00 00 93 21 04 34 3B 3F ?? ?? 93 C1 04 48 7C 9E 23 78 90 01 04 54 93 01 04 30 93 41 04 38 93 61 04 3C 93 81 04 40 93 A1 04 44 41 9E 01 14 2F 89 FF FF 80 19 00 04 38 60 FF FF 91 21 00 08 90 01 00 0C 41 9E 00 84 3F A0 ?? ?? 3F 40 ?? ?? 3B BD ?? ?? 3B 61 00 0C 3B 81 00 08 3B 01 00 10 3B 21 00 1C 3B 5A ?? ?? 83 5A ?? ?? 7F 5A 12 14 48 00 00 08 80 01 00 0C 7F 25 CB 78 7C 09 03 A6 7F 47 D3 78 7F 04 C3 78 38 C0 04 00 7F C3 F3 78 4E 80 04 21 7F A4 EB 78 7C 7F 1B 78 38 A0 00 00 7F 83 E3 78 7F 66 DB 78 7F E7 FB 78 39 00 00 00 4? ?? ?? ?? 2F 83 00 00 41 9E FF BC 2F 9F 00 01 38 60 FF FF 41 9E 00 38 80 01 04 54 82 E1 04 2C 7C 08 03 A6 83 01 04 30 83 21 04 34 83 41 04 38 83 61 04 3C 83 81 04 40 83 A1 04 44 83 C1 04 48 83 E1 04 4C 38 21 04 50 4E 80 00 20 80 81 00 10 7E E3 BB 78 4? ?? ?? ?? 80 01 04 54 38 60 00 00 82 E1 04 2C 7C 08 03 A6 83 01 04 30 83 21 04 34 83 41 04 38 83 61 04 3C 83 81 04 40 83 A1 04 44 83 C1 04 48 83 E1 04 4C 38 21 04 50 4E 80 00 20 3F A0 ?? ?? 3B BD ?? ?? 3B 61 00 0C 3B 81 00 08 7F 83 E3 78 7F A4 EB 78 7F 65 DB 78 4? ?? ?? ?? 2F 83 00 00 41 9E 00 14 38 00 FF FF 90 1F ?? ?? 38 60 FF FF 4B FF FF 54 80 01 00 0C 3F 40 ?? ?? 81 21 00 08 3B 01 00 10 90 19 00 04 3B 5A ?? ?? 3B 21 00 1C 91 3F ?? ?? 4B FF FE D0 }
	condition:
		$1
}

rule file_69_0_0 {
	meta:
		name = "clnttcp_geterr"
		size = 32
	strings:
		$1 = { 81 23 00 08 81 49 00 24 81 69 00 28 80 09 00 2C 91 44 00 00 91 64 00 04 90 04 00 08 4E 80 00 20 }
	condition:
		$1
}

rule file_69_1_0 {
	meta:
		name = "clnttcp_freeres"
		size = 60
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 38 00 00 02 80 63 00 08 94 03 00 4C 7C 80 23 78 7C 09 03 A6 7C A4 2B 78 4C C6 31 82 4E 80 04 21 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_69_3_0 {
	meta:
		name = "clnttcp_control"
		size = 292
	strings:
		$1 = { 2B 84 00 0F 81 63 00 08 40 9D 00 0C 38 60 00 00 4E 80 00 20 3D 20 ?? ?? 39 29 ?? ?? 54 84 10 3A 7C 09 20 2E 7D 20 4A 14 7D 29 03 A6 4E 80 04 20 80 05 00 00 38 60 00 01 90 0B 00 3C 4E 80 00 20 81 25 00 00 38 00 00 01 81 45 00 04 38 60 00 01 91 2B 00 08 91 4B 00 0C 90 0B 00 10 4E 80 00 20 81 2B 00 08 38 60 00 01 81 4B 00 0C 91 25 00 00 91 45 00 04 4E 80 00 20 81 0B 00 14 38 60 00 01 81 4B 00 18 81 2B 00 1C 80 0B 00 20 91 05 00 00 91 45 00 04 91 25 00 08 90 05 00 0C 4E 80 00 20 80 0B 00 00 38 60 00 01 90 05 00 00 4E 80 00 20 38 00 00 01 90 0B 00 04 38 60 00 01 4E 80 00 20 38 00 00 00 90 0B 00 04 38 60 00 01 4E 80 00 20 80 0B 00 30 38 60 00 01 90 05 00 00 4E 80 00 20 81 25 00 00 38 60 00 01 38 09 FF FF 90 0B 00 30 4E 80 00 20 80 0B 00 40 38 60 00 01 90 05 00 00 4E 80 00 20 80 05 00 00 38 60 00 01 90 0B 00 40 4E 80 00 20 80 0B 00 3C 38 60 00 01 90 05 00 00 4E 80 00 20 }
	condition:
		$1
}

rule file_69_4_0 {
	meta:
		name = "clnttcp_destroy"
		size = 120
		refs = "0048 free 0070 __close"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 93 E1 00 0C 83 E3 00 08 93 C1 00 08 7C 7E 1B 78 80 1F 00 04 2F 80 00 00 40 9E 00 48 81 3F 00 50 80 09 00 1C 2F 80 00 00 41 9E 00 10 38 7F 00 4C 7C 09 03 A6 4E 80 04 21 7F E3 FB 78 4? ?? ?? ?? 7F C3 F3 78 4? ?? ?? ?? 80 01 00 14 83 C1 00 08 7C 08 03 A6 83 E1 00 0C 38 21 00 10 4E 80 00 20 80 7F 00 00 4? ?? ?? ?? 4B FF FF B4 }
	condition:
		$1
}

rule file_69_5_0 {
	meta:
		name = "clnttcp_call"
		size = 904
		refs = "00aa xdr_void 00be _null_auth 0160 xdrrec_endofrecord 01a8 xdrrec_skiprecord 01bc xdr_replymsg 0244 _seterr_reply 0308 xdr_opaque_auth"
	strings:
		$1 = { 94 21 FF 70 7C 08 02 A6 7D 80 00 26 90 01 00 94 93 E1 00 8C 83 E3 00 08 92 C1 00 68 3A DF 00 30 80 1F 00 10 93 21 00 74 3B 3F 00 4C 2F 80 00 00 93 41 00 78 7D 1A 43 78 93 61 00 7C 7C FB 3B 78 93 81 00 80 7C DC 33 78 93 A1 00 84 7C BD 2B 78 93 C1 00 88 7C 7E 1B 78 81 49 00 04 91 E1 00 4C 92 01 00 50 92 21 00 54 92 41 00 58 92 61 00 5C 92 81 00 60 92 A1 00 64 92 E1 00 6C 93 01 00 70 91 81 00 48 90 81 00 38 81 29 00 00 40 9E 00 0C 91 3F 00 08 91 5F 00 0C 2F 9B 00 00 3A 80 00 01 41 9E 01 FC 2E 14 00 00 3E E0 ?? ?? 3A 20 00 02 3B 00 00 00 3A 40 00 01 3A F7 ?? ?? 3E 60 ?? ?? 3A 1F 00 24 82 B6 00 00 7F 23 CB 78 81 3F 00 50 7E C4 B3 78 3A B5 FF FF 93 1F 00 4C 93 1F 00 24 80 09 00 0C 92 B6 00 00 7C 09 03 A6 80 BF 00 48 4E 80 04 21 2F 83 00 00 41 9E 02 1C 81 3F 00 50 7F 23 CB 78 38 81 00 38 80 09 00 04 7C 09 03 A6 4E 80 04 21 2F 83 00 00 41 9E 01 FC 80 7E 00 00 7F 24 CB 78 81 23 00 20 80 09 00 04 7C 09 03 A6 4E 80 04 21 2F 83 00 00 41 9E 01 DC 7F 23 CB 78 7F A9 03 A6 7F 84 E3 78 4C C6 31 82 4E 80 04 21 2F 83 00 00 41 9E 01 C0 7F 23 CB 78 7E 84 A3 78 4? ?? ?? ?? 2F 83 00 00 41 9E 01 D4 41 92 01 E0 80 1F 00 08 2F 80 00 00 41 9E 01 08 92 5F 00 4C 39 F3 ?? ?? 81 6F 00 00 7F 23 CB 78 81 2F 00 04 80 0F 00 08 91 61 00 14 91 21 00 18 90 01 00 1C 93 01 00 24 92 E1 00 28 4? ?? ?? ?? 2F 83 00 00 38 81 00 08 7F 23 CB 78 41 9E 01 54 4? ?? ?? ?? 2F 83 00 00 40 9E 00 6C 80 7F 00 24 2F 83 00 00 41 9E FF B4 80 01 00 94 81 81 00 48 7C 08 03 A6 81 E1 00 4C 82 01 00 50 7D 80 81 20 82 21 00 54 82 41 00 58 82 61 00 5C 82 81 00 60 82 A1 00 64 82 C1 00 68 82 E1 00 6C 83 01 00 70 83 21 00 74 83 41 00 78 83 61 00 7C 83 81 00 80 83 A1 00 84 83 C1 00 88 83 E1 00 8C 38 21 00 90 4E 80 00 20 80 01 00 08 7F 95 00 00 40 9E FF 4C 38 61 00 08 7E 04 83 78 4? ?? ?? ?? 80 7F 00 24 2F 83 00 00 41 9E 00 6C 2F 91 00 00 41 BE FF 7C 80 7E 00 00 81 23 00 20 80 09 00 0C 7C 09 03 A6 4E 80 04 21 2F 83 00 00 41 9E 00 98 3A 31 FF FF 4B FF FE 48 80 1F 00 0C 2F 80 00 00 40 9E FE F4 38 00 00 05 90 1F 00 24 38 60 00 05 4B FF FF 3C 80 1F 00 08 2F 80 00 00 40 BE FE 00 82 9F 00 0C 7E 94 00 34 56 94 D9 7E 6A 94 00 01 4B FF FD EC 80 7E 00 00 38 81 00 14 81 23 00 20 80 09 00 08 7C 09 03 A6 4E 80 04 21 2F 83 00 00 40 9E 00 7C 38 00 00 07 90 1F 00 24 38 00 00 06 90 1F 00 28 80 01 00 18 2F 80 00 00 41 9E 00 18 38 00 00 02 90 1F 00 4C 7F 23 CB 78 38 81 00 14 4? ?? ?? ?? 80 7F 00 24 4B FF FE C4 80 1F 00 24 2F 80 00 00 40 9E 00 0C 38 00 00 01 90 1F 00 24 7F 23 CB 78 38 80 00 01 4? ?? ?? ?? 80 7F 00 24 4B FF FE 9C 38 00 00 03 90 1F 00 24 38 60 00 03 4B FF FE 8C 38 60 00 00 4B FF FE 84 7F 23 CB 78 7F 69 03 A6 7F 44 D3 78 4C C6 31 82 4E 80 04 21 2F 83 00 00 40 BE FF 80 80 1F 00 24 2F 80 00 00 40 BE FF 74 38 00 00 02 90 1F 00 24 4B FF FF 68 }
	condition:
		$1
}

rule file_69_6_0 {
	meta:
		name = "writetcp"
		size = 148
		refs = "0044 __write 0058 __errno_location"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 93 81 00 10 7C BC 2B 79 93 A1 00 14 7C 7D 1B 78 93 C1 00 18 7C 9E 23 78 90 01 00 24 93 E1 00 1C 40 81 00 48 7F 9F E3 78 48 00 00 08 40 81 00 3C 80 7D 00 00 7F C4 F3 78 7F E5 FB 78 4? ?? ?? ?? 2F 83 FF FF 7F E3 F8 51 7F DE 1A 14 40 9E FF E0 4? ?? ?? ?? 3B 80 FF FF 80 03 00 00 90 1D 00 28 38 00 00 03 90 1D 00 24 80 01 00 24 7F 83 E3 78 83 A1 00 14 7C 08 03 A6 83 81 00 10 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 }
	condition:
		$1
}

rule file_69_7_0 {
	meta:
		name = "readtcp"
		size = 332
		refs = "0070 __poll 0090 __read 0110 __errno_location"
	strings:
		$1 = { 94 21 FF D0 7C 08 02 A6 90 01 00 34 93 A1 00 24 3F A0 10 62 63 BD 4D D3 80 03 00 0C 93 C1 00 28 7C BE 2B 79 7F A0 E8 96 81 23 00 08 7C 00 FE 70 93 81 00 20 7F BD 36 70 1D 29 03 E8 93 E1 00 2C 7F A0 E8 50 7C 7F 1B 78 7C 9C 23 78 7F BD 4A 14 41 82 00 6C 80 03 00 00 90 01 00 08 38 00 00 01 B0 01 00 0C 38 80 00 01 7F A5 EB 78 38 61 00 08 4? ?? ?? ?? 2F 83 FF FF 41 9E 00 98 2F 83 00 00 41 9E 00 60 80 7F 00 00 7F C5 F3 78 7F 84 E3 78 4? ?? ?? ?? 2F 83 FF FF 7C 7E 1B 78 41 9E 00 98 2F 83 00 00 40 9E 00 18 38 00 00 68 90 1F 00 28 38 00 00 04 3B C0 FF FF 90 1F 00 24 80 01 00 34 7F C3 F3 78 83 81 00 20 7C 08 03 A6 83 A1 00 24 83 C1 00 28 83 E1 00 2C 38 21 00 30 4E 80 00 20 38 00 00 05 83 81 00 20 90 1F 00 24 3B C0 FF FF 7F C3 F3 78 80 01 00 34 83 A1 00 24 7C 08 03 A6 83 C1 00 28 83 E1 00 2C 38 21 00 30 4E 80 00 20 4? ?? ?? ?? 80 03 00 00 2F 80 00 04 41 9E FF 48 39 20 00 04 90 1F 00 28 3B C0 FF FF 91 3F 00 24 4B FF FF 8C 4? ?? ?? ?? 80 03 00 00 90 1F 00 28 38 00 00 04 90 1F 00 24 4B FF FF 74 }
	condition:
		$1
}

rule file_69_8_0 {
	meta:
		name = "clnttcp_create"
		size = 820
		refs = "0050 malloc 00cc _create_xid 00f8 xdrmem_create 0104 xdr_callhdr 0164 xdrrec_create 0178 authnone_create 01cc pmap_getport 01f4 __socket 0200 bindresvport 0218 __connect 0244 free 0294 __close 029c __rpc_thread_createerr 02aa _libc_intl_domainname 02b8 __dcgettext 02d8 __fxprintf 02fc __errno_location"
	strings:
		$1 = { 94 21 FF A0 7C 08 02 A6 93 C1 00 58 7C 7E 1B 78 38 60 00 0C 90 01 00 64 92 C1 00 38 7D 16 43 78 93 01 00 40 7C F8 3B 78 93 21 00 44 7C 99 23 78 93 41 00 48 7C BA 2B 78 93 61 00 4C 7C DB 33 78 93 81 00 50 93 A1 00 54 93 E1 00 5C 92 E1 00 3C 4? ?? ?? ?? 7C 7D 1B 78 38 60 00 64 4? ?? ?? ?? 2F 9D 00 00 7F BC EB 78 7C 7F 1B 78 41 9E 02 30 2F 83 00 00 41 9E 02 28 A0 1E 00 02 2F 80 00 00 41 9E 01 3C 80 1B 00 00 2F 80 00 00 41 9C 01 5C 39 20 00 00 91 3F 00 04 81 1E 00 00 3A E0 00 00 81 5E 00 04 81 7E 00 08 81 3E 00 0C 3B DF 00 4C 91 1F 00 14 91 5F 00 18 91 7F 00 1C 91 3F 00 20 90 1F 00 00 92 FF 00 0C 92 FF 00 10 4? ?? ?? ?? 38 00 00 02 90 61 00 08 38 9F 00 30 38 A0 00 18 38 C0 00 00 90 01 00 10 7F C3 F3 78 92 E1 00 0C 93 21 00 14 93 41 00 18 4? ?? ?? ?? 7F C3 F3 78 38 81 00 08 4? ?? ?? ?? 2F 83 00 00 41 9E 01 28 81 3F 00 50 7F C3 F3 78 80 09 00 10 7C 09 03 A6 4E 80 04 21 81 3F 00 50 90 7F 00 48 80 09 00 1C 2F 80 00 00 41 9E 00 10 7F C3 F3 78 7C 09 03 A6 4E 80 04 21 3C E0 ?? ?? 3D 00 ?? ?? 7F C3 F3 78 7F 04 C3 78 7E C5 B3 78 7F E6 FB 78 38 E7 ?? ?? 39 08 ?? ?? 4? ?? ?? ?? 3D 20 ?? ?? 38 09 ?? ?? 93 FC 00 08 90 1C 00 04 4? ?? ?? ?? 90 7C 00 00 80 01 00 64 7F A3 EB 78 82 C1 00 38 7C 08 03 A6 82 E1 00 3C 83 01 00 40 83 21 00 44 83 41 00 48 83 61 00 4C 83 81 00 50 83 A1 00 54 83 C1 00 58 83 E1 00 5C 38 21 00 60 4E 80 00 20 7F C3 F3 78 7F 24 CB 78 7F 45 D3 78 38 C0 00 06 4? ?? ?? ?? 2C 03 00 00 41 82 01 48 80 1B 00 00 B0 7E 00 02 2F 80 00 00 40 9C FE AC 38 80 00 01 38 A0 00 06 38 60 00 02 4? ?? ?? ?? 38 80 00 00 90 7B 00 00 4? ?? ?? ?? 80 7B 00 00 2F 83 00 00 41 9C 00 E0 7F C4 F3 78 38 A0 00 10 4? ?? ?? ?? 2F 83 00 00 41 9C 00 CC 38 00 00 01 90 1F 00 04 80 1B 00 00 4B FF FE 68 80 1F 00 04 2F 80 00 00 40 9E 00 54 7F E3 FB 78 4? ?? ?? ?? 7F 83 E3 78 4? ?? ?? ?? 80 01 00 64 3B A0 00 00 82 C1 00 38 7C 08 03 A6 7F A3 EB 78 82 E1 00 3C 83 01 00 40 83 21 00 44 83 41 00 48 83 61 00 4C 83 81 00 50 83 A1 00 54 83 C1 00 58 83 E1 00 5C 38 21 00 60 4E 80 00 20 80 7B 00 00 4? ?? ?? ?? 4B FF FF A8 4? ?? ?? ?? 3C 80 ?? ?? 7C 7E 1B 78 3C 60 ?? ?? 38 84 ?? ?? 38 A0 00 05 38 63 ?? ?? 4? ?? ?? ?? 3C 80 ?? ?? 3C A0 ?? ?? 7C 66 1B 78 38 84 ?? ?? 38 60 00 00 38 A5 ?? ?? 4C C6 31 82 4? ?? ?? ?? 38 00 00 0C 90 1E 00 00 90 1E 00 08 4B FF FF 58 4? ?? ?? ?? 38 00 00 0C 90 03 00 00 7C 7E 1B 78 4? ?? ?? ?? 80 03 00 00 90 1E 00 08 80 7B 00 00 2F 83 00 00 41 BC FF 30 4? ?? ?? ?? 4B FF FF 28 7F E3 FB 78 4? ?? ?? ?? 7F A3 EB 78 4? ?? ?? ?? 3B A0 00 00 4B FF FE 50 }
	condition:
		$1
}

rule file_70_0_0 {
	meta:
		name = "__vmx__libc_longjmp"
		size = 88
		refs = "001c _longjmp_unwind 0040 __vmx__longjmp 0050 __sigprocmask"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 93 C1 00 08 7C 7E 1B 78 90 01 00 14 93 E1 00 0C 7C 9F 23 78 4? ?? ?? ?? 80 1E 01 C0 2F 80 00 00 40 9E 00 1C 2F 9F 00 00 40 9E 00 08 3B E0 00 01 7F C3 F3 78 7F E4 FB 78 4? ?? ?? ?? 38 9E 01 C4 38 A0 00 00 38 60 00 02 4? ?? ?? ?? 4B FF FF D8 }
	condition:
		$1
}

rule file_1393_0_0 {
	meta:
		name = "__longjmp_chk"
		size = 88
		refs = "001c _longjmp_unwind 0040 ____longjmp_chk 0050 __sigprocmask"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 93 C1 00 08 7C 7E 1B 78 90 01 00 14 93 E1 00 0C 7C 9F 23 78 4? ?? ?? ?? 80 1E 01 C0 2F 80 00 00 40 9E 00 1C 2F 9F 00 00 40 9E 00 08 3B E0 00 01 7F C3 F3 78 7F E4 FB 78 4? ?? ?? ?? 38 9E 01 C4 38 A0 00 00 38 60 00 02 4? ?? ?? ?? 4B FF FF D8 }
	condition:
		$1
}

rule file_72_0_0 {
	meta:
		name = "__vwprintf"
		size = 52
		refs = "000a stdout 0020 __vfwprintf"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 3D 20 ?? ?? 90 01 00 14 7C 60 1B 78 7C 85 23 78 80 69 ?? ?? 7C 04 03 78 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_1249_26_0 {
	meta:
		name = "__nldbl_vscanf"
		size = 52
		refs = "000a stdin 0020 __nldbl_vfscanf"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 3D 20 ?? ?? 90 01 00 14 7C 60 1B 78 7C 85 23 78 80 69 ?? ?? 7C 04 03 78 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_1249_20_0 {
	meta:
		name = "__nldbl_vwprintf"
		size = 52
		refs = "000a stdout 0020 __nldbl_vfwprintf"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 3D 20 ?? ?? 90 01 00 14 7C 60 1B 78 7C 85 23 78 80 69 ?? ?? 7C 04 03 78 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_806_0_0 {
	meta:
		name = "__vprintf"
		size = 52
		refs = "000a stdout 0020 vfprintf"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 3D 20 ?? ?? 90 01 00 14 7C 60 1B 78 7C 85 23 78 80 69 ?? ?? 7C 04 03 78 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_73_0_0 {
	meta:
		name = "__link"
		size = 16
		refs = "000c __syscall_error"
	strings:
		$1 = { 38 00 00 09 44 00 00 02 4C A3 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_74_0_0 {
	meta:
		name = "call_fclose"
		size = 40
		refs = "0014 _IO_new_fclose"
	strings:
		$1 = { 2F 83 00 00 94 21 FF F0 7C 08 02 A6 90 01 00 14 41 9E 00 08 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_74_1_0 {
	meta:
		name = "getpass"
		size = 464
		refs = "0034 _IO_new_fopen 0058 fileno 0060 __tcgetattr 0084 __fxprintf 008c fflush_unlocked 00a0 __getline 00d2 stdin 00e4 _IO_new_fclose 011c memcpy 0140 tcsetattr 01a2 stderr 01cc _Unwind_Resume"
	strings:
		$1 = { 94 21 FF 60 7C 08 02 A6 3C 80 ?? ?? 93 C1 00 98 7C 7E 1B 78 3C 60 ?? ?? 38 84 ?? ?? 93 E1 00 9C 38 63 ?? ?? 90 01 00 A4 93 61 00 8C 93 81 00 90 93 A1 00 94 4? ?? ?? ?? 7C 7F 1B 79 41 82 01 5C 80 1F 00 00 7F FD FB 78 7F FB FB 78 60 00 80 00 90 1F 00 00 7F E3 FB 78 4? ?? ?? ?? 38 81 00 44 4? ?? ?? ?? 2F 83 00 00 3B 80 00 00 41 9E 00 A4 3C 80 ?? ?? 7F A3 EB 78 38 84 ?? ?? 7F C5 F3 78 4C C6 31 82 4? ?? ?? ?? 7F A3 EB 78 4? ?? ?? ?? 3F C0 ?? ?? 38 7E ?? ?? 38 83 00 04 7F E5 FB 78 4? ?? ?? ?? 81 3E ?? ?? 2F 89 00 00 41 9E 00 1C 2F 83 00 00 41 9C 00 D8 38 63 FF FF 7C 09 18 AE 2F 80 00 0A 41 9E 00 8C 2F 9C 00 00 40 9E 00 A8 3D 20 ?? ?? 80 09 ?? ?? 7F 9F 00 00 41 9E 00 0C 7F E3 FB 78 4? ?? ?? ?? 80 01 00 A4 80 7E ?? ?? 7C 08 03 A6 83 61 00 8C 83 81 00 90 83 A1 00 94 83 C1 00 98 83 E1 00 9C 38 21 00 A0 4E 80 00 20 38 81 00 44 38 A0 00 3C 38 61 00 08 4? ?? ?? ?? 81 21 00 50 38 00 FF 77 7D 20 00 38 7F E3 FB 78 90 01 00 50 4? ?? ?? ?? 38 80 00 02 38 A1 00 44 4? ?? ?? ?? 7C 7C 00 34 57 9C D9 7E 4B FF FF 24 2F 9C 00 00 38 00 00 00 7C 09 19 AE 41 9E FF 74 3C 80 ?? ?? 7F A3 EB 78 38 84 ?? ?? 4C C6 31 82 4? ?? ?? ?? 7F E3 FB 78 4? ?? ?? ?? 38 80 00 02 38 A1 00 08 4? ?? ?? ?? 4B FF FF 48 38 00 00 00 98 09 00 00 4B FF FF 34 3D 20 ?? ?? 83 E9 ?? ?? 3D 20 ?? ?? 83 A9 ?? ?? 7F FB EA 78 33 7B FF FF 7F 7B D9 10 7F FB D8 38 4B FF FE 9C 7C 7F 1B 78 7F 63 DB 78 4B FF FE 15 7F E3 FB 78 4? ?? ?? ?? }
	condition:
		$1
}

rule file_75_0_0 {
	meta:
		name = "__isoc99_fscanf"
		size = 520
		refs = "00f0 _IO_vfscanf 0188 __lll_lock_wait_private 0204 _Unwind_Resume"
	strings:
		$1 = { 94 21 FF 80 7C 08 02 A6 93 E1 00 7C 7C 7F 1B 78 90 01 00 84 93 A1 00 74 93 C1 00 78 90 A1 00 18 90 C1 00 1C 90 E1 00 20 91 01 00 24 91 21 00 28 91 41 00 2C 40 86 00 24 D8 21 00 30 D8 41 00 38 D8 61 00 40 D8 81 00 48 D8 A1 00 50 D8 C1 00 58 D8 E1 00 60 D9 01 00 68 80 1F 00 00 7C 9D 23 78 70 00 80 00 40 82 00 50 80 7F 00 48 3B C2 8B 60 81 23 00 08 7F 89 F0 00 41 9E 00 30 39 60 00 01 7D 20 18 28 7C 09 00 00 40 82 00 0C 7D 60 19 2D 40 A2 FF F0 4C 00 01 2C 2F 89 00 00 40 9E 00 EC 80 7F 00 48 93 C3 00 08 81 23 00 04 38 09 00 01 90 03 00 04 80 1F 00 3C 7F E3 FB 78 7F A4 EB 78 60 00 00 10 90 1F 00 3C 38 00 00 02 38 A1 00 08 98 01 00 08 38 00 00 00 38 C0 00 00 98 01 00 09 38 01 00 88 90 01 00 0C 38 01 00 10 90 01 00 10 4? ?? ?? ?? 80 1F 00 00 7C 7E 1B 78 81 3F 00 3C 70 0B 80 00 38 00 FF EB 7D 20 00 38 90 1F 00 3C 40 82 00 38 80 7F 00 48 81 23 00 04 38 09 FF FF 2F 80 00 00 90 03 00 04 40 9E 00 20 90 03 00 08 7C 00 04 AC 7D 20 18 28 7C 00 19 2D 40 A2 FF F8 2F 89 00 01 41 9D 00 24 80 01 00 84 7F C3 F3 78 83 A1 00 74 7C 08 03 A6 83 C1 00 78 83 E1 00 7C 38 21 00 80 4E 80 00 20 80 82 8B 68 38 00 00 DD 38 A0 00 01 60 84 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF C4 4? ?? ?? ?? 4B FF FF 14 80 1F 00 00 7C 7E 1B 78 81 3F 00 3C 70 0B 80 00 38 00 FF EB 7D 20 00 38 90 1F 00 3C 40 82 00 54 80 7F 00 48 80 03 00 04 30 00 FF FF 2F 80 00 00 90 03 00 04 40 9E 00 3C 90 03 00 08 7C 00 04 AC 7D 20 18 28 7C 00 19 2D 40 A2 FF F8 2F 89 00 01 40 BD 00 20 80 82 8B 68 38 00 00 DD 38 A0 00 01 60 84 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 7F C3 F3 78 4? ?? ?? ?? }
	condition:
		$1
}

rule file_810_0_0 {
	meta:
		name = "__isoc99_fwscanf"
		size = 520
		refs = "00f0 _IO_vfwscanf 0188 __lll_lock_wait_private 0204 _Unwind_Resume"
	strings:
		$1 = { 94 21 FF 80 7C 08 02 A6 93 E1 00 7C 7C 7F 1B 78 90 01 00 84 93 A1 00 74 93 C1 00 78 90 A1 00 18 90 C1 00 1C 90 E1 00 20 91 01 00 24 91 21 00 28 91 41 00 2C 40 86 00 24 D8 21 00 30 D8 41 00 38 D8 61 00 40 D8 81 00 48 D8 A1 00 50 D8 C1 00 58 D8 E1 00 60 D9 01 00 68 80 1F 00 00 7C 9D 23 78 70 00 80 00 40 82 00 50 80 7F 00 48 3B C2 8B 60 81 23 00 08 7F 89 F0 00 41 9E 00 30 39 60 00 01 7D 20 18 28 7C 09 00 00 40 82 00 0C 7D 60 19 2D 40 A2 FF F0 4C 00 01 2C 2F 89 00 00 40 9E 00 EC 80 7F 00 48 93 C3 00 08 81 23 00 04 38 09 00 01 90 03 00 04 80 1F 00 3C 7F E3 FB 78 7F A4 EB 78 60 00 00 10 90 1F 00 3C 38 00 00 02 38 A1 00 08 98 01 00 08 38 00 00 00 38 C0 00 00 98 01 00 09 38 01 00 88 90 01 00 0C 38 01 00 10 90 01 00 10 4? ?? ?? ?? 80 1F 00 00 7C 7E 1B 78 81 3F 00 3C 70 0B 80 00 38 00 FF EB 7D 20 00 38 90 1F 00 3C 40 82 00 38 80 7F 00 48 81 23 00 04 38 09 FF FF 2F 80 00 00 90 03 00 04 40 9E 00 20 90 03 00 08 7C 00 04 AC 7D 20 18 28 7C 00 19 2D 40 A2 FF F8 2F 89 00 01 41 9D 00 24 80 01 00 84 7F C3 F3 78 83 A1 00 74 7C 08 03 A6 83 C1 00 78 83 E1 00 7C 38 21 00 80 4E 80 00 20 80 82 8B 68 38 00 00 DD 38 A0 00 01 60 84 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF C4 4? ?? ?? ?? 4B FF FF 14 80 1F 00 00 7C 7E 1B 78 81 3F 00 3C 70 0B 80 00 38 00 FF EB 7D 20 00 38 90 1F 00 3C 40 82 00 54 80 7F 00 48 80 03 00 04 30 00 FF FF 2F 80 00 00 90 03 00 04 40 9E 00 3C 90 03 00 08 7C 00 04 AC 7D 20 18 28 7C 00 19 2D 40 A2 FF F8 2F 89 00 01 40 BD 00 20 80 82 8B 68 38 00 00 DD 38 A0 00 01 60 84 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 7F C3 F3 78 4? ?? ?? ?? }
	condition:
		$1
}

rule file_77_0_0 {
	meta:
		name = "mktemp"
		size = 76
		refs = "0020 __gen_tempname"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 38 80 00 00 38 A0 00 00 93 E1 00 0C 38 C0 00 02 90 01 00 14 7C 7F 1B 78 4? ?? ?? ?? 2F 83 00 00 40 BC 00 0C 38 00 00 00 98 1F 00 00 80 01 00 14 7F E3 FB 78 83 E1 00 0C 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_78_0_0 {
	meta:
		name = "__strcasecmp"
		size = 96
		refs = "0006 _GLOBAL_OFFSET_TABLE_ 000e __libc_tsd_LOCALE"
	strings:
		$1 = { 7F 83 20 00 3D 60 ?? ?? 39 6B ?? ?? 81 6B ?? ?? 7D 6B 12 14 7C 69 1B 78 81 6B 00 00 38 60 00 00 4D 9E 00 20 81 4B 00 38 39 29 FF FF 38 84 FF FF 48 00 00 08 4D 9E 00 20 8D 69 00 01 8C 04 00 01 55 68 10 3A 54 00 10 3A 7C 6A 40 2E 7C 0A 00 2E 2F 8B 00 00 7C 60 18 51 41 82 FF DC 4E 80 00 20 }
	condition:
		$1
}

rule file_79_0_0 {
	meta:
		name = "strftime"
		size = 52
		refs = "000a _GLOBAL_OFFSET_TABLE_ 0016 __libc_tsd_LOCALE 0020 __strftime_l"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 3D 20 ?? ?? 39 29 ?? ?? 90 01 00 14 81 29 ?? ?? 7D 29 12 14 80 E9 00 00 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_919_0_0 {
	meta:
		name = "__strtol_internal"
		size = 52
		refs = "000a _GLOBAL_OFFSET_TABLE_ 0016 __libc_tsd_LOCALE 0020 ____strtol_l_internal"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 3D 20 ?? ?? 39 29 ?? ?? 90 01 00 14 81 29 ?? ?? 7D 29 12 14 80 E9 00 00 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_1281_0_0 {
	meta:
		name = "__strtoll_internal"
		size = 52
		refs = "000a _GLOBAL_OFFSET_TABLE_ 0016 __libc_tsd_LOCALE 0020 ____strtoll_l_internal"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 3D 20 ?? ?? 39 29 ?? ?? 90 01 00 14 81 29 ?? ?? 7D 29 12 14 80 E9 00 00 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_785_0_0 {
	meta:
		name = "__strtoul_internal"
		size = 52
		refs = "000a _GLOBAL_OFFSET_TABLE_ 0016 __libc_tsd_LOCALE 0020 ____strtoul_l_internal"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 3D 20 ?? ?? 39 29 ?? ?? 90 01 00 14 81 29 ?? ?? 7D 29 12 14 80 E9 00 00 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_800_0_0 {
	meta:
		name = "__strtoull_internal"
		size = 52
		refs = "000a _GLOBAL_OFFSET_TABLE_ 0016 __libc_tsd_LOCALE 0020 ____strtoull_l_internal"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 3D 20 ?? ?? 39 29 ?? ?? 90 01 00 14 81 29 ?? ?? 7D 29 12 14 80 E9 00 00 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_81_0_0 {
	meta:
		name = "__wcstol_internal"
		size = 52
		refs = "000a _GLOBAL_OFFSET_TABLE_ 0016 __libc_tsd_LOCALE 0020 ____wcstol_l_internal"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 3D 20 ?? ?? 39 29 ?? ?? 90 01 00 14 81 29 ?? ?? 7D 29 12 14 80 E9 00 00 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_705_0_0 {
	meta:
		name = "__wcstoll_internal"
		size = 52
		refs = "000a _GLOBAL_OFFSET_TABLE_ 0016 __libc_tsd_LOCALE 0020 ____wcstoll_l_internal"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 3D 20 ?? ?? 39 29 ?? ?? 90 01 00 14 81 29 ?? ?? 7D 29 12 14 80 E9 00 00 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_207_0_0 {
	meta:
		name = "__wcstoul_internal"
		size = 52
		refs = "000a _GLOBAL_OFFSET_TABLE_ 0016 __libc_tsd_LOCALE 0020 ____wcstoul_l_internal"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 3D 20 ?? ?? 39 29 ?? ?? 90 01 00 14 81 29 ?? ?? 7D 29 12 14 80 E9 00 00 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_840_0_0 {
	meta:
		name = "__wcstoull_internal"
		size = 52
		refs = "000a _GLOBAL_OFFSET_TABLE_ 0016 __libc_tsd_LOCALE 0020 ____wcstoull_l_internal"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 3D 20 ?? ?? 39 29 ?? ?? 90 01 00 14 81 29 ?? ?? 7D 29 12 14 80 E9 00 00 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_339_0_0 {
	meta:
		name = "wcsftime"
		size = 52
		refs = "000a _GLOBAL_OFFSET_TABLE_ 0016 __libc_tsd_LOCALE 0020 __wcsftime_l"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 3D 20 ?? ?? 39 29 ?? ?? 90 01 00 14 81 29 ?? ?? 7D 29 12 14 80 E9 00 00 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_80_0_0 {
	meta:
		name = "__socketpair"
		size = 48
		refs = "002c __syscall_error"
	strings:
		$1 = { 94 21 FF D0 90 61 00 14 90 81 00 18 90 A1 00 1C 90 C1 00 20 38 60 00 08 38 81 00 14 38 00 00 66 44 00 00 02 38 21 00 30 4C A3 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_81_1_0 {
	meta:
		name = "wcstol"
		size = 56
		refs = "000a _GLOBAL_OFFSET_TABLE_ 0016 __libc_tsd_LOCALE 0024 ____wcstol_l_internal"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 3D 20 ?? ?? 39 29 ?? ?? 90 01 00 14 81 29 ?? ?? 7D 29 12 14 80 E9 00 00 38 C0 00 00 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_136_0_0 {
	meta:
		name = "strptime"
		size = 56
		refs = "000a _GLOBAL_OFFSET_TABLE_ 0016 __libc_tsd_LOCALE 0024 __strptime_internal"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 3D 20 ?? ?? 39 29 ?? ?? 90 01 00 14 81 29 ?? ?? 7D 29 12 14 80 E9 00 00 38 C0 00 00 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_919_1_0 {
	meta:
		name = "strtol"
		size = 56
		refs = "000a _GLOBAL_OFFSET_TABLE_ 0016 __libc_tsd_LOCALE 0024 ____strtol_l_internal"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 3D 20 ?? ?? 39 29 ?? ?? 90 01 00 14 81 29 ?? ?? 7D 29 12 14 80 E9 00 00 38 C0 00 00 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_1281_1_0 {
	meta:
		name = "strtoll"
		size = 56
		refs = "000a _GLOBAL_OFFSET_TABLE_ 0016 __libc_tsd_LOCALE 0024 ____strtoll_l_internal"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 3D 20 ?? ?? 39 29 ?? ?? 90 01 00 14 81 29 ?? ?? 7D 29 12 14 80 E9 00 00 38 C0 00 00 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_785_1_0 {
	meta:
		name = "strtoul"
		size = 56
		refs = "000a _GLOBAL_OFFSET_TABLE_ 0016 __libc_tsd_LOCALE 0024 ____strtoul_l_internal"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 3D 20 ?? ?? 39 29 ?? ?? 90 01 00 14 81 29 ?? ?? 7D 29 12 14 80 E9 00 00 38 C0 00 00 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_800_1_0 {
	meta:
		name = "strtoull"
		size = 56
		refs = "000a _GLOBAL_OFFSET_TABLE_ 0016 __libc_tsd_LOCALE 0024 ____strtoull_l_internal"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 3D 20 ?? ?? 39 29 ?? ?? 90 01 00 14 81 29 ?? ?? 7D 29 12 14 80 E9 00 00 38 C0 00 00 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_705_1_0 {
	meta:
		name = "wcstoll"
		size = 56
		refs = "000a _GLOBAL_OFFSET_TABLE_ 0016 __libc_tsd_LOCALE 0024 ____wcstoll_l_internal"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 3D 20 ?? ?? 39 29 ?? ?? 90 01 00 14 81 29 ?? ?? 7D 29 12 14 80 E9 00 00 38 C0 00 00 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_207_1_0 {
	meta:
		name = "wcstoul"
		size = 56
		refs = "000a _GLOBAL_OFFSET_TABLE_ 0016 __libc_tsd_LOCALE 0024 ____wcstoul_l_internal"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 3D 20 ?? ?? 39 29 ?? ?? 90 01 00 14 81 29 ?? ?? 7D 29 12 14 80 E9 00 00 38 C0 00 00 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_840_1_0 {
	meta:
		name = "wcstoull"
		size = 56
		refs = "000a _GLOBAL_OFFSET_TABLE_ 0016 __libc_tsd_LOCALE 0024 ____wcstoull_l_internal"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 3D 20 ?? ?? 39 29 ?? ?? 90 01 00 14 81 29 ?? ?? 7D 29 12 14 80 E9 00 00 38 C0 00 00 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_82_0_0 {
	meta:
		name = "nfsservctl"
		size = 16
		refs = "000c __syscall_error"
	strings:
		$1 = { 38 00 00 A8 44 00 00 02 4C A3 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_83_0_0 {
	meta:
		name = "listxattr"
		size = 16
		refs = "000c __syscall_error"
	strings:
		$1 = { 38 00 00 D7 44 00 00 02 4C A3 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_84_0_0 {
	meta:
		name = "memfrob"
		size = 36
	strings:
		$1 = { 2C 04 00 00 4D 82 00 20 7C 89 03 A6 39 23 FF FF 8C 09 00 01 68 00 00 2A 98 09 00 00 42 00 FF F4 4E 80 00 20 }
	condition:
		$1
}

rule file_86_0_0 {
	meta:
		name = "sigignore"
		size = 88
		refs = "0028 memset 0040 __sigaction"
	strings:
		$1 = { 94 21 FF 60 7C 08 02 A6 38 80 00 00 90 01 00 A4 38 A0 00 80 38 00 00 01 93 E1 00 9C 7C 7F 1B 78 38 61 00 0C 90 01 00 08 4? ?? ?? ?? 38 00 00 00 7F E3 FB 78 90 01 00 8C 38 81 00 08 38 A0 00 00 4? ?? ?? ?? 80 01 00 A4 83 E1 00 9C 38 21 00 A0 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_87_0_0 {
	meta:
		name = "seteuid"
		size = 176
		refs = "001e __nptl_setxid 005a _GLOBAL_OFFSET_TABLE_ 0062 __libc_errno"
	strings:
		$1 = { 2F 83 FF FF 7C 08 02 A6 94 21 FF D0 7C 64 1B 78 90 01 00 34 38 00 FF FF 41 9E 00 40 3D 20 ?? ?? 39 29 ?? ?? 2F 89 00 00 41 9E 00 50 39 20 00 A4 90 01 00 0C 38 61 00 08 91 21 00 08 90 81 00 10 90 01 00 14 4? ?? ?? ?? 80 01 00 34 38 21 00 30 7C 08 03 A6 4E 80 00 20 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 38 00 00 16 90 09 00 00 38 60 FF FF 4B FF FF D4 38 00 00 A4 38 60 FF FF 38 A0 FF FF 44 00 00 02 7C 00 00 26 74 09 10 00 41 82 FF B8 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 90 69 00 00 38 60 FF FF 4B FF FF 9C }
	condition:
		$1
}

rule file_88_0_0 {
	meta:
		name = "setlinebuf"
		size = 44
		refs = "0018 _IO_setvbuf"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 38 80 00 00 38 A0 00 01 90 01 00 14 38 C0 00 00 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_89_0_0 {
	meta:
		name = "__libc_init_secure"
		size = 144
		refs = "000a __libc_enable_secure_decided 003c __geteuid 0044 __getuid 0074 __getegid 007c __getgid"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 3D 20 ?? ?? 90 01 00 14 80 09 ?? ?? 93 C1 00 08 2F 80 00 00 93 E1 00 0C 41 9E 00 1C 80 01 00 14 83 C1 00 08 7C 08 03 A6 83 E1 00 0C 38 21 00 10 4E 80 00 20 4? ?? ?? ?? 7C 7F 1B 78 4? ?? ?? ?? 7F 9F 18 00 3B E0 00 01 41 9E 00 24 80 01 00 14 3D 20 ?? ?? 93 E9 ?? ?? 7C 08 03 A6 83 C1 00 08 83 E1 00 0C 38 21 00 10 4E 80 00 20 4? ?? ?? ?? 7C 7E 1B 78 4? ?? ?? ?? 7F 9E 18 00 40 9E FF D0 3B E0 00 00 4B FF FF C8 }
	condition:
		$1
}

rule file_90_0_0 {
	meta:
		name = "fchmodat"
		size = 472
		refs = "0042 __have_atfcts 009e _GLOBAL_OFFSET_TABLE_ 00a6 __libc_errno 00d8 strlen 011c __snprintf 014c __atfct_seterrno"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 90 01 00 24 54 C0 06 2D 93 61 00 0C 7C BB 2B 78 93 81 00 10 7C 7C 1B 78 93 C1 00 18 7C 9E 23 78 93 E1 00 1C 7C 3F 0B 78 93 A1 00 14 40 82 01 2C 70 C9 01 00 40 82 01 44 3F A0 ?? ?? 80 1D ?? ?? 2F 80 00 00 41 9C 00 74 38 00 01 29 44 00 00 02 7C 00 00 26 74 09 10 00 40 82 01 40 2F 83 FF FF 7C 60 1B 78 41 9E 00 30 39 7F 00 20 7C 03 03 78 80 0B 00 04 83 6B FF EC 7C 08 03 A6 83 8B FF F0 83 AB FF F4 83 CB FF F8 83 EB FF FC 7D 61 5B 78 4E 80 00 20 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 81 29 00 00 38 00 FF FF 2F 89 00 26 40 9E FF B8 90 1D ?? ?? 2F 9C FF 9C 41 9E 00 94 88 1E 00 00 2F 80 00 2F 41 9E 00 88 7F C3 F3 78 4? ?? ?? ?? 7C 64 1B 79 41 82 00 D8 38 04 00 3E 81 21 00 00 54 00 00 36 7C 00 00 D0 7D 21 01 6E 3C A0 ?? ?? 7F C7 F3 78 3B A1 00 17 57 BD 00 36 7F A3 EB 78 38 84 00 20 38 A5 ?? ?? 7F 86 E3 78 4C C6 31 82 4? ?? ?? ?? 7F BE EB 78 38 00 00 0F 7F C3 F3 78 7F 64 DB 78 44 00 00 02 7C 00 00 26 74 09 10 00 7C 60 1B 78 41 82 FF 30 7F 84 E3 78 7F A5 EB 78 4? ?? ?? ?? 38 00 FF FF 4B FF FF 1C 3B A0 00 00 4B FF FF C8 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 38 00 00 16 7D 29 12 14 90 09 00 00 38 00 FF FF 4B FF FE F4 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 38 00 00 5F 7D 29 12 14 90 09 00 00 38 00 FF FF 4B FF FE D4 3D 20 ?? ?? 39 29 ?? ?? 81 69 ?? ?? 7D 6B 12 14 90 6B 00 00 4B FF FE F0 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 38 00 00 02 7D 29 12 14 90 09 00 00 38 00 FF FF 4B FF FE 9C }
	condition:
		$1
}

rule file_91_0_0 {
	meta:
		name = "dlclose_doit"
		size = 32
		refs = "000c _dl_close"
		altNames = "do_dlclose"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_91_57_4 {
	meta:
		name = "_ZNKSbIwSt11char_traitsIwESaIwEE12find_last_ofEwj"
		size = 32
		refs = "000c _ZNKSbIwSt11char_traitsIwESaIwEE5rfindEwj"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_91_53_4 {
	meta:
		name = "_ZNKSbIwSt11char_traitsIwESaIwEE13find_first_ofEwj"
		size = 32
		refs = "000c _ZNKSbIwSt11char_traitsIwESaIwEE4findEwj"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_53_57_4 {
	meta:
		name = "_ZNKSs12find_last_ofEcj"
		size = 32
		refs = "000c _ZNKSs5rfindEcj"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_53_53_4 {
	meta:
		name = "_ZNKSs13find_first_ofEcj"
		size = 32
		refs = "000c _ZNKSs4findEcj"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_91_82_4 {
	meta:
		name = "_ZNSbIwSt11char_traitsIwESaIwEE18_S_construct_aux_2EjwRKS1_"
		size = 32
		refs = "000c _ZNSbIwSt11char_traitsIwESaIwEE12_S_constructEjwRKS1_"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_91_85_4 {
	meta:
		name = "_ZNSbIwSt11char_traitsIwESaIwEE4_Rep10_M_destroyERKS1_"
		size = 32
		refs = "000c _ZdlPv"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_91_141_4 {
	meta:
		name = "_ZNSbIwSt11char_traitsIwESaIwEEaSERKS2_"
		size = 32
		refs = "000c _ZNSbIwSt11char_traitsIwESaIwEE6assignERKS2_"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_91_136_4 {
	meta:
		name = "_ZNSbIwSt11char_traitsIwESaIwEEpLERKS2_"
		size = 32
		refs = "000c _ZNSbIwSt11char_traitsIwESaIwEE6appendERKS2_"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_95_74_4 {
	meta:
		name = "_ZNSirsERPv"
		size = 32
		refs = "000c _ZNSi10_M_extractIPvEERSiRT_"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_95_62_4 {
	meta:
		name = "_ZNSirsERb"
		size = 32
		refs = "000c _ZNSi10_M_extractIbEERSiRT_"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_95_70_4 {
	meta:
		name = "_ZNSirsERd"
		size = 32
		refs = "000c _ZNSi10_M_extractIdEERSiRT_"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_95_68_4 {
	meta:
		name = "_ZNSirsERf"
		size = 32
		refs = "000c _ZNSi10_M_extractIfEERSiRT_"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_95_72_4 {
	meta:
		name = "_ZNSirsERg"
		size = 32
		refs = "000c _ZNSi10_M_extractIgEERSiRT_"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_95_56_4 {
	meta:
		name = "_ZNSirsERj"
		size = 32
		refs = "000c _ZNSi10_M_extractIjEERSiRT_"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_95_58_4 {
	meta:
		name = "_ZNSirsERl"
		size = 32
		refs = "000c _ZNSi10_M_extractIlEERSiRT_"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_95_60_4 {
	meta:
		name = "_ZNSirsERm"
		size = 32
		refs = "000c _ZNSi10_M_extractImEERSiRT_"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_95_54_4 {
	meta:
		name = "_ZNSirsERt"
		size = 32
		refs = "000c _ZNSi10_M_extractItEERSiRT_"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_95_64_4 {
	meta:
		name = "_ZNSirsERx"
		size = 32
		refs = "000c _ZNSi10_M_extractIxEERSiRT_"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_95_66_4 {
	meta:
		name = "_ZNSirsERy"
		size = 32
		refs = "000c _ZNSi10_M_extractIyEERSiRT_"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_82_65_4 {
	meta:
		name = "_ZNSolsEPKv"
		size = 32
		refs = "000c _ZNSo9_M_insertIPKvEERSoT_"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_82_54_4 {
	meta:
		name = "_ZNSolsEb"
		size = 32
		refs = "000c _ZNSo9_M_insertIbEERSoT_"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_82_61_4 {
	meta:
		name = "_ZNSolsEd"
		size = 32
		refs = "000c _ZNSo9_M_insertIdEERSoT_"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_82_60_4 {
	meta:
		name = "_ZNSolsEf"
		size = 32
		refs = "000c _ZNSo9_M_insertIdEERSoT_"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_82_63_4 {
	meta:
		name = "_ZNSolsEg"
		size = 32
		refs = "000c _ZNSo9_M_insertIgEERSoT_"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_82_50_4 {
	meta:
		name = "_ZNSolsEj"
		size = 32
		refs = "000c _ZNSo9_M_insertImEERSoT_"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_82_48_4 {
	meta:
		name = "_ZNSolsEl"
		size = 32
		refs = "000c _ZNSo9_M_insertIlEERSoT_"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_82_52_4 {
	meta:
		name = "_ZNSolsEm"
		size = 32
		refs = "000c _ZNSo9_M_insertImEERSoT_"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_82_51_4 {
	meta:
		name = "_ZNSolsEt"
		size = 32
		refs = "000c _ZNSo9_M_insertImEERSoT_"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_82_56_4 {
	meta:
		name = "_ZNSolsEx"
		size = 32
		refs = "000c _ZNSo9_M_insertIxEERSoT_"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_82_58_4 {
	meta:
		name = "_ZNSolsEy"
		size = 32
		refs = "000c _ZNSo9_M_insertIyEERSoT_"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_53_82_4 {
	meta:
		name = "_ZNSs18_S_construct_aux_2EjcRKSaIcE"
		size = 32
		refs = "000c _ZNSs12_S_constructEjcRKSaIcE"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_53_85_4 {
	meta:
		name = "_ZNSs4_Rep10_M_destroyERKSaIcE"
		size = 32
		refs = "000c _ZdlPv"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_53_141_4 {
	meta:
		name = "_ZNSsaSERKSs"
		size = 32
		refs = "000c _ZNSs6assignERKSs"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_53_136_4 {
	meta:
		name = "_ZNSspLERKSs"
		size = 32
		refs = "000c _ZNSs6appendERKSs"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_95_136_4 {
	meta:
		name = "_ZNSt13basic_istreamIwSt11char_traitsIwEErsERPv"
		size = 32
		refs = "000c _ZNSt13basic_istreamIwSt11char_traitsIwEE10_M_extractIPvEERS2_RT_"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_95_124_4 {
	meta:
		name = "_ZNSt13basic_istreamIwSt11char_traitsIwEErsERb"
		size = 32
		refs = "000c _ZNSt13basic_istreamIwSt11char_traitsIwEE10_M_extractIbEERS2_RT_"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_95_132_4 {
	meta:
		name = "_ZNSt13basic_istreamIwSt11char_traitsIwEErsERd"
		size = 32
		refs = "000c _ZNSt13basic_istreamIwSt11char_traitsIwEE10_M_extractIdEERS2_RT_"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_95_130_4 {
	meta:
		name = "_ZNSt13basic_istreamIwSt11char_traitsIwEErsERf"
		size = 32
		refs = "000c _ZNSt13basic_istreamIwSt11char_traitsIwEE10_M_extractIfEERS2_RT_"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_95_134_4 {
	meta:
		name = "_ZNSt13basic_istreamIwSt11char_traitsIwEErsERg"
		size = 32
		refs = "000c _ZNSt13basic_istreamIwSt11char_traitsIwEE10_M_extractIgEERS2_RT_"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_95_118_4 {
	meta:
		name = "_ZNSt13basic_istreamIwSt11char_traitsIwEErsERj"
		size = 32
		refs = "000c _ZNSt13basic_istreamIwSt11char_traitsIwEE10_M_extractIjEERS2_RT_"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_95_120_4 {
	meta:
		name = "_ZNSt13basic_istreamIwSt11char_traitsIwEErsERl"
		size = 32
		refs = "000c _ZNSt13basic_istreamIwSt11char_traitsIwEE10_M_extractIlEERS2_RT_"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_95_122_4 {
	meta:
		name = "_ZNSt13basic_istreamIwSt11char_traitsIwEErsERm"
		size = 32
		refs = "000c _ZNSt13basic_istreamIwSt11char_traitsIwEE10_M_extractImEERS2_RT_"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_95_116_4 {
	meta:
		name = "_ZNSt13basic_istreamIwSt11char_traitsIwEErsERt"
		size = 32
		refs = "000c _ZNSt13basic_istreamIwSt11char_traitsIwEE10_M_extractItEERS2_RT_"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_95_126_4 {
	meta:
		name = "_ZNSt13basic_istreamIwSt11char_traitsIwEErsERx"
		size = 32
		refs = "000c _ZNSt13basic_istreamIwSt11char_traitsIwEE10_M_extractIxEERS2_RT_"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_95_128_4 {
	meta:
		name = "_ZNSt13basic_istreamIwSt11char_traitsIwEErsERy"
		size = 32
		refs = "000c _ZNSt13basic_istreamIwSt11char_traitsIwEE10_M_extractIyEERS2_RT_"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_82_119_4 {
	meta:
		name = "_ZNSt13basic_ostreamIwSt11char_traitsIwEElsEPKv"
		size = 32
		refs = "000c _ZNSt13basic_ostreamIwSt11char_traitsIwEE9_M_insertIPKvEERS2_T_"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_82_108_4 {
	meta:
		name = "_ZNSt13basic_ostreamIwSt11char_traitsIwEElsEb"
		size = 32
		refs = "000c _ZNSt13basic_ostreamIwSt11char_traitsIwEE9_M_insertIbEERS2_T_"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_82_115_4 {
	meta:
		name = "_ZNSt13basic_ostreamIwSt11char_traitsIwEElsEd"
		size = 32
		refs = "000c _ZNSt13basic_ostreamIwSt11char_traitsIwEE9_M_insertIdEERS2_T_"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_82_114_4 {
	meta:
		name = "_ZNSt13basic_ostreamIwSt11char_traitsIwEElsEf"
		size = 32
		refs = "000c _ZNSt13basic_ostreamIwSt11char_traitsIwEE9_M_insertIdEERS2_T_"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_82_117_4 {
	meta:
		name = "_ZNSt13basic_ostreamIwSt11char_traitsIwEElsEg"
		size = 32
		refs = "000c _ZNSt13basic_ostreamIwSt11char_traitsIwEE9_M_insertIgEERS2_T_"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_82_104_4 {
	meta:
		name = "_ZNSt13basic_ostreamIwSt11char_traitsIwEElsEj"
		size = 32
		refs = "000c _ZNSt13basic_ostreamIwSt11char_traitsIwEE9_M_insertImEERS2_T_"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_82_102_4 {
	meta:
		name = "_ZNSt13basic_ostreamIwSt11char_traitsIwEElsEl"
		size = 32
		refs = "000c _ZNSt13basic_ostreamIwSt11char_traitsIwEE9_M_insertIlEERS2_T_"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_82_106_4 {
	meta:
		name = "_ZNSt13basic_ostreamIwSt11char_traitsIwEElsEm"
		size = 32
		refs = "000c _ZNSt13basic_ostreamIwSt11char_traitsIwEE9_M_insertImEERS2_T_"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_82_105_4 {
	meta:
		name = "_ZNSt13basic_ostreamIwSt11char_traitsIwEElsEt"
		size = 32
		refs = "000c _ZNSt13basic_ostreamIwSt11char_traitsIwEE9_M_insertImEERS2_T_"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_82_110_4 {
	meta:
		name = "_ZNSt13basic_ostreamIwSt11char_traitsIwEElsEx"
		size = 32
		refs = "000c _ZNSt13basic_ostreamIwSt11char_traitsIwEE9_M_insertIxEERS2_T_"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_82_112_4 {
	meta:
		name = "_ZNSt13basic_ostreamIwSt11char_traitsIwEElsEy"
		size = 32
		refs = "000c _ZNSt13basic_ostreamIwSt11char_traitsIwEE9_M_insertIyEERS2_T_"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_20_1_4 {
	meta:
		name = "_ZNSt18condition_variableD2Ev"
		size = 32
		refs = "000c pthread_cond_destroy"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_82_31_4 {
	meta:
		name = "_ZSt5flushIcSt11char_traitsIcEERSt13basic_ostreamIT_T0_ES6_"
		size = 32
		refs = "000c _ZNSo5flushEv"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_82_87_4 {
	meta:
		name = "_ZSt5flushIwSt11char_traitsIwEERSt13basic_ostreamIT_T0_ES6_"
		size = 32
		refs = "000c _ZNSt13basic_ostreamIwSt11char_traitsIwEE5flushEv"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_95_46_4 {
	meta:
		name = "_ZStrsISt11char_traitsIcEERSt13basic_istreamIcT_ES5_Pa"
		size = 32
		refs = "000c _ZStrsIcSt11char_traitsIcEERSt13basic_istreamIT_T0_ES6_PS3_"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_95_45_4 {
	meta:
		name = "_ZStrsISt11char_traitsIcEERSt13basic_istreamIcT_ES5_Ph"
		size = 32
		refs = "000c _ZStrsIcSt11char_traitsIcEERSt13basic_istreamIT_T0_ES6_PS3_"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_95_44_4 {
	meta:
		name = "_ZStrsISt11char_traitsIcEERSt13basic_istreamIcT_ES5_Ra"
		size = 32
		refs = "000c _ZStrsIcSt11char_traitsIcEERSt13basic_istreamIT_T0_ES6_RS3_"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_95_43_4 {
	meta:
		name = "_ZStrsISt11char_traitsIcEERSt13basic_istreamIcT_ES5_Rh"
		size = 32
		refs = "000c _ZStrsIcSt11char_traitsIcEERSt13basic_istreamIT_T0_ES6_RS3_"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_1213_0_0 {
	meta:
		name = "__bsd_getpgrp"
		size = 32
		refs = "000c __getpgid"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_205_0_2 {
	meta:
		name = "__drem"
		size = 32
		refs = "000c __remainder"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_91_0_2 {
	meta:
		name = "__dremf"
		size = 32
		refs = "000c __remainderf"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_113_0_2 {
	meta:
		name = "__dreml"
		size = 32
		refs = "000c __remainderl"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_858_0_0 {
	meta:
		name = "__fcloseall"
		size = 32
		refs = "000c _IO_cleanup"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_148_0_3 {
	meta:
		name = "__fork"
		size = 32
		refs = "000c __libc_fork"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_1306_0_0 {
	meta:
		name = "__new_pclose"
		size = 32
		refs = "000c _IO_new_fclose"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_1037_0_0 {
	meta:
		name = "__sched_cpufree"
		size = 32
		refs = "000c free"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_1470_0_0 {
	meta:
		name = "endutxent"
		size = 32
		refs = "000c __endutent"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_329_7_0 {
	meta:
		name = "freeifaddrs"
		size = 32
		refs = "000c free"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_553_0_0 {
	meta:
		name = "getutxent"
		size = 32
		refs = "000c __getutent"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_524_0_0 {
	meta:
		name = "getutxid"
		size = 32
		refs = "000c __getutid"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_707_0_0 {
	meta:
		name = "getutxline"
		size = 32
		refs = "000c __getutline"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_184_0_3 {
	meta:
		name = "pthread_yield"
		size = 32
		refs = "000c sched_yield"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_168_0_0 {
	meta:
		name = "pututxline"
		size = 32
		refs = "000c __pututline"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_1087_0_0 {
	meta:
		name = "rand"
		size = 32
		refs = "000c __random"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_940_0_0 {
	meta:
		name = "setutxent"
		size = 32
		refs = "000c __setutent"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_37_0_3 {
	meta:
		name = "system"
		size = 32
		refs = "000c __libc_system"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_638_0_0 {
	meta:
		name = "updwtmpx"
		size = 32
		refs = "000c __updwtmp"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_871_0_0 {
	meta:
		name = "utmpxname"
		size = 32
		refs = "000c __utmpname"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_91_1_0 {
	meta:
		name = "__dlclose"
		size = 56
		refs = "0018 _dlerror_run"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 7C 64 1B 78 3C 60 ?? ?? 90 01 00 14 38 63 ?? ?? 4? ?? ?? ?? 80 01 00 14 7C 63 00 34 7C 08 03 A6 54 63 D9 7E 38 63 FF FF 38 21 00 10 4E 80 00 20 }
	condition:
		$1
}

rule file_92_0_0 {
	meta:
		name = "_savegpr1_all"
		size = 80
	strings:
		$1 = { 91 AC FF B4 91 CC FF B8 91 EC FF BC 92 0C FF C0 92 2C FF C4 92 4C FF C8 92 6C FF CC 92 8C FF D0 92 AC FF D4 92 CC FF D8 92 EC FF DC 93 0C FF E0 93 2C FF E4 93 4C FF E8 93 6C FF EC 93 8C FF F0 93 AC FF F4 93 CC FF F8 93 EC FF FC 4E 80 00 20 }
	condition:
		$1
}

rule file_93_0_0 {
	meta:
		name = "__ptsname_internal"
		size = 828
		refs = "0016 _GLOBAL_OFFSET_TABLE_ 0026 __libc_errno 0050 __isatty 00e0 __ioctl 0104 __xstat64 0174 _itoa_word 01b4 memcpy 0210 __fxstat64 02a2 __libc_ptyname1 02bc strlen 02d6 __libc_ptyname2"
	strings:
		$1 = { 94 21 FF B0 7C 08 02 A6 93 61 00 3C 7C 9B 23 79 93 C1 00 48 3F C0 ?? ?? 3B DE ?? ?? 90 01 00 54 93 E1 00 4C 83 FE ?? ?? 7F FF 12 14 93 21 00 34 93 41 00 38 7C BA 2B 78 93 81 00 40 7C 7C 1B 78 93 A1 00 44 7C DD 33 78 83 3F 00 00 41 82 00 48 4? ?? ?? ?? 2F 83 00 00 40 9E 00 74 38 00 00 19 90 1F 00 00 38 60 00 19 80 01 00 54 83 21 00 34 7C 08 03 A6 83 41 00 38 83 61 00 3C 83 81 00 40 83 A1 00 44 83 C1 00 48 83 E1 00 4C 38 21 00 50 4E 80 00 20 38 00 00 16 83 21 00 34 90 1F 00 00 38 60 00 16 80 01 00 54 83 41 00 38 7C 08 03 A6 83 61 00 3C 83 81 00 40 83 A1 00 44 83 C1 00 48 83 E1 00 4C 38 21 00 50 4E 80 00 20 3C 80 40 04 7F 83 E3 78 60 84 54 30 38 A1 00 08 4C C6 31 82 4? ?? ?? ?? 7C 60 1B 79 41 82 00 78 80 1F 00 00 2F 80 00 16 41 9E 00 44 38 60 00 03 7F 64 DB 78 7F A5 EB 78 4? ?? ?? ?? 2F 83 00 00 41 9C 00 44 80 1D 00 10 54 00 04 26 2F 80 20 00 41 9E 00 A0 83 DE ?? ?? 7F DE 12 14 38 00 00 19 90 1E 00 00 38 60 00 19 4B FF FF 34 2B 9A 00 0A 41 9D 00 C8 38 00 00 22 90 1F 00 00 38 60 00 22 4B FF FF 1C 81 3E ?? ?? 7D 29 12 14 80 69 00 00 4B FF FF 0C 80 61 00 08 38 81 00 20 38 A0 00 0A 98 01 00 20 38 C0 00 00 4? ?? ?? ?? 38 A1 00 21 7C A3 28 50 38 05 00 09 7F 80 D0 40 7C 64 1B 78 41 9D FF B4 3D 20 ?? ?? 39 69 ?? ?? 81 49 ?? ?? A0 0B 00 08 38 7B 00 09 81 2B 00 04 91 5B 00 00 91 3B 00 04 B0 1B 00 08 4? ?? ?? ?? 4B FF FF 40 81 7D 00 20 81 3D 00 24 55 6A 00 26 55 20 C5 3E 7D 40 03 78 2F 80 00 03 41 9E 00 1C 2F 80 00 04 41 9E 00 84 2B 80 00 87 40 9D FF 3C 2B 80 00 8F 41 9D FF 34 81 3E ?? ?? 7D 29 12 14 93 29 00 00 38 60 00 00 4B FF FE 68 38 60 00 03 7F 84 E3 78 7F A5 EB 78 4? ?? ?? ?? 2F 83 00 00 41 9C 00 F0 80 1D 00 20 83 FD 00 24 54 0B 00 26 57 E9 C5 3E 7D 69 4B 78 2F 89 00 02 41 9E 00 5C 2F 89 00 04 41 9E 00 D4 2B 89 00 7F 41 9D 00 44 81 3E ?? ?? 7D 29 12 14 38 00 00 19 90 09 00 00 38 60 00 19 4B FF FE 0C 55 20 A3 2E 55 6B A0 16 7C 00 5B 78 55 29 06 3E 7C 00 4B 78 2B 80 00 BF 40 BD FE A8 2B 80 00 FF 41 BD FE A0 4B FF FF 6C 2B 89 00 87 41 9D FF BC 57 E9 A3 3E 54 00 A0 16 57 FF 06 3E 7C 00 4B 78 3F 40 ?? ?? 54 00 00 2E 3B 5A ?? ?? 7C 1F FB 78 7F 43 D3 78 93 E1 00 08 57 FC E1 3E 4? ?? ?? ?? 7F 9C 18 40 40 9C FF 84 3D 20 ?? ?? 39 69 ?? ?? 81 09 ?? ?? 3D 20 ?? ?? 81 4B 00 04 57 FF 07 3E 7D 7A E0 AE 39 29 ?? ?? 91 1B 00 00 7C 09 F8 AE 91 5B 00 04 98 1B 00 09 38 00 00 00 99 7B 00 08 98 1B 00 0A 4B FF FD F4 80 7F 00 00 4B FF FD 5C 57 E9 A3 3E 54 00 A0 16 7C 0B 4B 78 55 6B 00 2E 57 FF 06 3E 7D 6B FB 78 2B 8B 00 7F 40 BD FF 1C 2B 8B 00 BF 41 BD FF 14 4B FF FF 64 }
	condition:
		$1
}

rule file_93_1_0 {
	meta:
		name = "__ptsname_r"
		size = 36
		refs = "0010 __ptsname_internal"
		altNames = "ptsname_r"
	strings:
		$1 = { 94 21 FF 80 7C 08 02 A6 38 C1 00 08 90 01 00 84 4? ?? ?? ?? 80 01 00 84 38 21 00 80 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_93_2_0 {
	meta:
		name = "ptsname"
		size = 72
		refs = "0020 __ptsname_r"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 38 A0 00 1E 93 E1 00 0C 3F E0 ?? ?? 3B FF ?? ?? 7F E4 FB 78 90 01 00 14 4? ?? ?? ?? 2F 83 00 00 38 60 00 00 40 9E 00 08 7F E3 FB 78 80 01 00 14 83 E1 00 0C 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_94_0_0 {
	meta:
		name = "common_crypt"
		size = 192
		refs = "0094 _des_crypt"
	strings:
		$1 = { 7C 08 02 A6 94 21 FF F0 7C 69 1B 78 90 01 00 14 70 A0 00 07 38 60 00 03 40 82 00 0C 2B 85 20 00 40 9D 00 14 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 54 C0 07 FE 90 07 00 08 38 69 00 01 39 09 00 02 88 09 00 00 98 07 00 00 88 09 00 01 98 07 00 01 88 03 00 01 7C 83 23 78 7C A4 2B 78 98 07 00 02 7C E5 3B 78 88 08 00 01 98 07 00 03 88 08 00 02 98 07 00 04 88 08 00 03 98 07 00 05 88 08 00 04 98 07 00 06 88 08 00 05 90 C1 00 08 98 07 00 07 4? ?? ?? ?? 80 C1 00 08 2F 83 00 00 38 60 00 02 41 BE FF 80 80 01 00 14 54 C6 FF FE 68 C3 00 01 7C 08 03 A6 38 21 00 10 4E 80 00 20 }
	condition:
		$1
}

rule file_94_1_0 {
	meta:
		name = "cbc_crypt"
		size = 260
	strings:
		$1 = { 94 21 FF A0 7C 08 02 A6 92 C1 00 38 3A C0 00 00 93 21 00 44 93 41 00 48 3B 47 00 01 93 61 00 4C 93 81 00 50 93 A1 00 54 93 C1 00 58 93 E1 00 5C 7C FF 3B 78 90 01 00 64 92 E1 00 3C 93 01 00 40 8A E7 00 00 8B 07 00 01 38 E1 00 08 89 1A 00 02 89 5A 00 03 89 7A 00 04 89 3A 00 05 88 1A 00 06 89 9A 00 01 92 C1 00 14 9A E1 00 18 9B 01 00 19 99 01 00 1B 99 41 00 1C 99 61 00 1D 99 21 00 1E 98 01 00 1F 99 81 00 1A 4B FF FE B9 88 01 00 1F 88 C1 00 19 88 E1 00 1A 89 01 00 1B 89 41 00 1C 89 61 00 1D 89 21 00 1E 88 A1 00 18 98 DF 00 01 98 BF 00 00 98 FA 00 01 99 1A 00 02 99 5A 00 03 99 7A 00 04 99 3A 00 05 98 1A 00 06 80 01 00 64 82 C1 00 38 7C 08 03 A6 82 E1 00 3C 83 01 00 40 83 21 00 44 83 41 00 48 83 61 00 4C 83 81 00 50 83 A1 00 54 83 C1 00 58 83 E1 00 5C 38 21 00 60 4E 80 00 20 }
	condition:
		$1
}

rule file_94_2_0 {
	meta:
		name = "ecb_crypt"
		size = 44
	strings:
		$1 = { 94 21 FF C0 7C 08 02 A6 38 E1 00 08 90 01 00 44 38 00 00 01 90 01 00 14 4B FF FE 25 80 01 00 44 38 21 00 40 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_95_0_0 {
	meta:
		name = "strxfrm"
		size = 52
		refs = "000a _GLOBAL_OFFSET_TABLE_ 0016 __libc_tsd_LOCALE 0020 __strxfrm_l"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 3D 20 ?? ?? 39 29 ?? ?? 90 01 00 14 81 29 ?? ?? 7D 29 12 14 80 C9 00 00 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_554_0_0 {
	meta:
		name = "____new_strtold_internal"
		size = 52
		refs = "000a _GLOBAL_OFFSET_TABLE_ 0016 __libc_tsd_LOCALE 0020 ____strtold_l_internal"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 3D 20 ?? ?? 39 29 ?? ?? 90 01 00 14 81 29 ?? ?? 7D 29 12 14 80 C9 00 00 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_933_0_0 {
	meta:
		name = "____new_wcstold_internal"
		size = 52
		refs = "000a _GLOBAL_OFFSET_TABLE_ 0016 __libc_tsd_LOCALE 0020 ____wcstold_l_internal"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 3D 20 ?? ?? 39 29 ?? ?? 90 01 00 14 81 29 ?? ?? 7D 29 12 14 80 C9 00 00 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_1086_0_0 {
	meta:
		name = "__strtod_internal"
		size = 52
		refs = "000a _GLOBAL_OFFSET_TABLE_ 0016 __libc_tsd_LOCALE 0020 ____strtod_l_internal"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 3D 20 ?? ?? 39 29 ?? ?? 90 01 00 14 81 29 ?? ?? 7D 29 12 14 80 C9 00 00 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_727_0_0 {
	meta:
		name = "__strtof_internal"
		size = 52
		refs = "000a _GLOBAL_OFFSET_TABLE_ 0016 __libc_tsd_LOCALE 0020 ____strtof_l_internal"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 3D 20 ?? ?? 39 29 ?? ?? 90 01 00 14 81 29 ?? ?? 7D 29 12 14 80 C9 00 00 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_554_2_0 {
	meta:
		name = "__strtold_internal"
		size = 52
		refs = "000a _GLOBAL_OFFSET_TABLE_ 0016 __libc_tsd_LOCALE 0020 ____strtold_l_internal"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 3D 20 ?? ?? 39 29 ?? ?? 90 01 00 14 81 29 ?? ?? 7D 29 12 14 80 C9 00 00 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_1076_0_0 {
	meta:
		name = "__wcstod_internal"
		size = 52
		refs = "000a _GLOBAL_OFFSET_TABLE_ 0016 __libc_tsd_LOCALE 0020 ____wcstod_l_internal"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 3D 20 ?? ?? 39 29 ?? ?? 90 01 00 14 81 29 ?? ?? 7D 29 12 14 80 C9 00 00 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_1010_0_0 {
	meta:
		name = "__wcstof_internal"
		size = 52
		refs = "000a _GLOBAL_OFFSET_TABLE_ 0016 __libc_tsd_LOCALE 0020 ____wcstof_l_internal"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 3D 20 ?? ?? 39 29 ?? ?? 90 01 00 14 81 29 ?? ?? 7D 29 12 14 80 C9 00 00 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_933_2_0 {
	meta:
		name = "__wcstold_internal"
		size = 52
		refs = "000a _GLOBAL_OFFSET_TABLE_ 0016 __libc_tsd_LOCALE 0020 ____wcstold_l_internal"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 3D 20 ?? ?? 39 29 ?? ?? 90 01 00 14 81 29 ?? ?? 7D 29 12 14 80 C9 00 00 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_230_0_0 {
	meta:
		name = "wcsxfrm"
		size = 52
		refs = "000a _GLOBAL_OFFSET_TABLE_ 0016 __libc_tsd_LOCALE 0020 __wcsxfrm_l"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 3D 20 ?? ?? 39 29 ?? ?? 90 01 00 14 81 29 ?? ?? 7D 29 12 14 80 C9 00 00 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_96_0_0 {
	meta:
		name = "endnetgrent_hook"
		size = 92
		refs = "0028 __nss_lookup_function"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 93 E1 00 0C 7C 7F 1B 78 80 63 00 28 2F 83 00 00 41 9E 00 2C 3C 80 ?? ?? 38 84 ?? ?? 4? ?? ?? ?? 7C 60 1B 79 41 82 00 10 7F E3 FB 78 7C 09 03 A6 4E 80 04 21 38 00 00 00 90 1F 00 28 80 01 00 14 83 E1 00 0C 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_96_1_0 {
	meta:
		name = "setup"
		size = 216
		refs = "0060 __nss_lookup 0090 __nss_netgroup_lookup"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 7C 66 1B 78 93 E1 00 1C 3F E0 ?? ?? 90 01 00 24 88 1F ?? ?? 93 A1 00 14 3B BF ?? ?? 2F 80 00 00 93 C1 00 18 7C 9E 23 78 41 9E 00 50 81 3D 00 04 38 60 00 01 80 02 8F F4 7D 20 02 78 2F 80 FF FF 41 9E 00 1C 90 04 00 00 7C 83 23 78 3C 80 ?? ?? 38 84 ?? ?? 38 A0 00 00 4? ?? ?? ?? 80 01 00 24 83 A1 00 14 7C 08 03 A6 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 7C 83 23 78 3C 80 ?? ?? 38 84 ?? ?? 7C C5 33 78 4? ?? ?? ?? 38 00 FF FF 2C 03 00 00 40 82 00 08 80 1E 00 00 81 22 8F F4 7C 00 4A 78 90 1D 00 04 7C 00 06 AC 38 00 00 01 83 A1 00 14 98 1F ?? ?? 80 01 00 24 83 C1 00 18 7C 08 03 A6 83 E1 00 1C 38 21 00 20 4E 80 00 20 }
	condition:
		$1
}

rule file_96_2_0 {
	meta:
		name = "__internal_setnetgrent_reuse"
		size = 472
		refs = "00c0 __nss_next2 00d8 strlen 00e4 malloc 0108 memcpy 0154 __nss_lookup_function 0170 __errno_location 01d4 __assert_fail"
	strings:
		$1 = { 94 21 FF C0 7C 08 02 A6 93 81 00 30 3B 84 00 28 93 A1 00 34 7C 7D 1B 78 7C 83 23 78 90 01 00 44 93 01 00 20 7C B8 2B 78 93 E1 00 3C 7C 9F 23 78 93 21 00 24 93 41 00 28 93 61 00 2C 93 C1 00 38 4B FF FE 8D 38 61 00 08 7F 84 E3 78 4B FF FE DD 2F 83 00 00 40 9E 01 5C 80 1F 00 10 2F 80 00 00 40 9E 01 58 3F 40 ?? ?? 3F 20 ?? ?? 3B 5A ?? ?? 3B 39 ?? ?? 48 00 00 18 2F 83 00 00 40 9E 00 58 80 1F 00 10 2F 80 00 00 40 9E 01 30 80 01 00 08 7F E4 FB 78 7F A3 EB 78 7C 09 03 A6 4E 80 04 21 7F 44 D3 78 7C 7E 1B 78 83 7F 00 28 7F 83 E3 78 38 A0 00 00 38 C1 00 08 7F C7 F3 78 39 00 00 00 4? ?? ?? ?? 2F 9E 00 01 40 9E FF B0 2F 83 00 00 41 9E 00 7C 7F A3 EB 78 4? ?? ?? ?? 7C 7B 1B 78 38 63 00 05 4? ?? ?? ?? 3B 7B 00 01 7C 7C 1B 79 41 82 00 80 80 1F 00 20 38 7C 00 04 7F A4 EB 78 90 1C 00 00 7F 65 DB 78 4? ?? ?? ?? 80 01 00 44 6B C3 00 01 93 9F 00 20 7C 08 03 A6 7C 63 00 34 54 63 D9 7E 83 01 00 20 83 21 00 24 83 41 00 28 83 61 00 2C 83 81 00 30 83 A1 00 34 83 C1 00 38 83 E1 00 3C 38 21 00 40 4E 80 00 20 7F 63 DB 78 7F 24 CB 78 4? ?? ?? ?? 7C 60 1B 79 41 A2 FF 24 7F E3 FB 78 7C 09 03 A6 4E 80 04 21 4B FF FF 14 4? ?? ?? ?? 83 21 00 24 80 03 00 00 38 60 00 00 83 41 00 28 90 18 00 00 80 01 00 44 83 01 00 20 7C 08 03 A6 83 61 00 2C 83 81 00 30 83 A1 00 34 83 C1 00 38 83 E1 00 3C 38 21 00 40 4E 80 00 20 3B C0 FF FF 4B FF FF 20 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 00 85 38 C6 ?? ?? 4? ?? ?? ?? }
	condition:
		$1
}

rule file_96_3_0 {
	meta:
		name = "free_memory.clone.0"
		size = 124
		refs = "0030 free"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 93 E1 00 0C 7C 7F 1B 78 80 63 00 00 93 C1 00 08 7C 9E 23 78 2F 83 00 00 41 9E 00 34 80 03 00 00 90 1F 00 00 4? ?? ?? ?? 80 7F 00 00 2F 83 00 00 40 9E FF EC 80 7E 00 00 2F 83 00 00 41 9E 00 1C 80 03 00 00 90 1E 00 00 4? ?? ?? ?? 80 7E 00 00 2F 83 00 00 40 9E FF EC 80 01 00 14 83 C1 00 08 7C 08 03 A6 83 E1 00 0C 38 21 00 10 4E 80 00 20 }
	condition:
		$1
}

rule file_96_4_0 {
	meta:
		name = "internal_setnetgrent"
		size = 80
		refs = "0028 __errno_location"
		altNames = "__internal_setnetgrent"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 93 E1 00 0C 7C 9F 23 78 38 84 00 24 93 C1 00 08 7C 7E 1B 78 38 7F 00 20 90 01 00 14 4B FF FF 61 4? ?? ?? ?? 7F E4 FB 78 80 01 00 14 7C 65 1B 78 83 E1 00 0C 7F C3 F3 78 7C 08 03 A6 83 C1 00 08 38 21 00 10 4B FF FD 60 }
	condition:
		$1
}

rule file_96_5_0 {
	meta:
		name = "setnetgrent"
		size = 204
		refs = "0058 internal_setnetgrent 00a0 __lll_lock_wait_private"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 39 60 00 01 93 A1 00 14 3F A0 ?? ?? 3B BD ?? ?? 93 C1 00 18 39 20 00 00 3B DD 00 08 93 E1 00 1C 7C 7F 1B 78 90 01 00 24 7C 00 F0 28 7C 00 48 00 40 82 00 0C 7D 60 F1 2D 40 A2 FF F0 4C 00 01 2C 2F 80 00 00 40 9E 00 50 7F E3 FB 78 38 9D 00 0C 4? ?? ?? ?? 38 00 00 00 7C 7F 1B 78 7C 00 04 AC 7D 20 F0 28 7C 00 F1 2D 40 A2 FF F8 2F 89 00 01 41 9D 00 30 80 01 00 24 7F E3 FB 78 83 A1 00 14 7C 08 03 A6 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 7F C3 F3 78 4? ?? ?? ?? 4B FF FF AC 80 82 8B 68 38 00 00 DD 7F C3 F3 78 60 84 00 01 38 A0 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF B4 }
	condition:
		$1
}

rule file_96_6_0 {
	meta:
		name = "internal_endnetgrent"
		size = 52
		altNames = "__internal_endnetgrent"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 93 E1 00 0C 7C 7F 1B 78 90 01 00 14 4B FF FB 49 38 7F 00 20 80 01 00 14 38 9F 00 24 83 E1 00 0C 38 21 00 10 7C 08 03 A6 4B FF FE 38 }
	condition:
		$1
}

rule file_96_7_0 {
	meta:
		name = "endnetgrent"
		size = 180
		refs = "004c internal_endnetgrent 0088 __lll_lock_wait_private"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 39 60 00 01 93 C1 00 08 3F C0 ?? ?? 3B DE ?? ?? 93 E1 00 0C 39 20 00 00 3B FE 00 08 90 01 00 14 7C 00 F8 28 7C 00 48 00 40 82 00 0C 7D 60 F9 2D 40 A2 FF F0 4C 00 01 2C 2F 80 00 00 40 9E 00 40 38 7E 00 0C 4? ?? ?? ?? 38 00 00 00 7C 00 04 AC 7D 20 F8 28 7C 00 F9 2D 40 A2 FF F8 2F 89 00 01 41 9D 00 28 80 01 00 14 83 C1 00 08 7C 08 03 A6 83 E1 00 0C 38 21 00 10 4E 80 00 20 7F E3 FB 78 4? ?? ?? ?? 4B FF FF BC 80 82 8B 68 38 00 00 DD 7F E3 FB 78 60 84 00 01 38 A0 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF BC }
	condition:
		$1
}

rule file_96_8_0 {
	meta:
		name = "internal_getnetgrent_r"
		size = 584
		refs = "007c __nss_lookup_function 008c __errno_location 00f4 strcmp 0108 strlen 0118 malloc 0138 memcpy"
		altNames = "__internal_getnetgrent_r"
	strings:
		$1 = { 94 21 FF C0 7C 08 02 A6 7D 80 00 26 90 01 00 44 80 06 00 28 93 01 00 20 3B 00 00 00 2F 80 00 00 93 21 00 24 7D 39 4B 78 93 41 00 28 7D 1A 43 78 93 61 00 2C 7C FB 3B 78 93 81 00 30 7C 7C 1B 78 93 A1 00 34 7C 9D 23 78 93 C1 00 38 7C BE 2B 78 93 E1 00 3C 7C DF 33 78 92 A1 00 14 92 C1 00 18 92 E1 00 1C 91 81 00 10 41 9E 01 70 3E E0 ?? ?? 3A F7 ?? ?? 7C 03 03 78 7E E4 BB 78 4? ?? ?? ?? 7C 60 1B 79 90 01 00 08 41 82 01 50 4? ?? ?? ?? 7C 78 1B 78 80 01 00 08 7F E3 FB 78 7F 64 DB 78 7F 45 D3 78 7C 09 03 A6 7F 06 C3 78 4E 80 04 21 2F 83 00 02 41 9E 00 B0 2F 83 00 01 40 9E 01 18 80 1F 00 00 2F 80 00 01 40 9E 01 58 82 DF 00 20 2E 16 00 00 41 92 01 6C 82 BF 00 04 48 00 00 10 82 D6 00 00 2E 16 00 00 41 92 00 1C 38 96 00 04 7E A3 AB 78 4? ?? ?? ?? 2F 83 00 00 40 9E FF E4 40 92 FF 94 7E A3 AB 78 4? ?? ?? ?? 7C 69 1B 78 38 63 00 05 3A A9 00 01 4? ?? ?? ?? 7C 76 1B 79 41 82 00 B4 80 1F 00 24 7E A5 AB 78 38 76 00 04 90 16 00 00 80 9F 00 04 4? ?? ?? ?? 80 01 00 08 92 DF 00 24 7F E3 FB 78 7F 64 DB 78 7C 09 03 A6 7F 45 D3 78 7F 06 C3 78 4E 80 04 21 2F 83 00 02 40 9E FF 58 81 3F 00 24 2F 89 00 00 40 BE 00 0C 48 00 00 64 40 9A 00 40 81 69 00 00 38 69 00 04 80 1F 00 20 7F E4 FB 78 91 7F 00 24 7F 25 CB 78 90 09 00 00 91 3F 00 20 4B FF FA 11 81 3F 00 24 2F 03 00 00 2F 89 00 00 40 9E FF CC 2F 83 00 00 41 9E 00 24 80 7F 00 28 2F 83 00 00 41 9E 00 18 7E E4 BB 78 4? ?? ?? ?? 7C 60 1B 79 90 01 00 08 40 82 FE C4 3B 00 00 00 80 01 00 44 7F 03 C3 78 81 81 00 10 7C 08 03 A6 82 A1 00 14 82 C1 00 18 7D 80 81 20 82 E1 00 1C 83 01 00 20 83 21 00 24 83 41 00 28 83 61 00 2C 83 81 00 30 83 A1 00 34 83 C1 00 38 83 E1 00 3C 38 21 00 40 4E 80 00 20 80 1F 00 04 3B 00 00 01 90 1C 00 00 80 1F 00 08 90 1D 00 00 80 1F 00 0C 90 1E 00 00 4B FF FF 9C 82 BF 00 04 4B FF FE C0 }
	condition:
		$1
}

rule file_96_9_0 {
	meta:
		name = "__getnetgrent_r"
		size = 276
		refs = "0070 __errno_location 0090 internal_getnetgrent_r 00e8 __lll_lock_wait_private"
		altNames = "getnetgrent_r"
	strings:
		$1 = { 94 21 FF D0 7C 08 02 A6 39 60 00 01 93 A1 00 24 3F A0 ?? ?? 3B BD ?? ?? 93 21 00 14 39 20 00 00 7C 99 23 78 93 41 00 18 7C BA 2B 78 93 61 00 1C 7C 7B 1B 78 93 81 00 20 7C DC 33 78 93 C1 00 28 3B DD 00 08 93 E1 00 2C 7C FF 3B 78 90 01 00 34 7C 00 F0 28 7C 00 48 00 40 82 00 0C 7D 60 F1 2D 40 A2 FF F0 4C 00 01 2C 2F 80 00 00 40 9E 00 78 4? ?? ?? ?? 7F E8 FB 78 7C 69 1B 78 7F 24 CB 78 7F 63 DB 78 7F 45 D3 78 38 DD 00 0C 7F 87 E3 78 4? ?? ?? ?? 38 00 00 00 7C 7F 1B 78 7C 00 04 AC 7D 20 F0 28 7C 00 F1 2D 40 A2 FF F8 2F 89 00 01 41 9D 00 40 80 01 00 34 7F E3 FB 78 83 21 00 14 7C 08 03 A6 83 41 00 18 83 61 00 1C 83 81 00 20 83 A1 00 24 83 C1 00 28 83 E1 00 2C 38 21 00 30 4E 80 00 20 7F C3 F3 78 4? ?? ?? ?? 4B FF FF 84 80 82 8B 68 38 00 00 DD 7F C3 F3 78 60 84 00 01 38 A0 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF A4 }
	condition:
		$1
}

rule file_96_10_0 {
	meta:
		name = "innetgr"
		size = 900
		refs = "0094 memset 00b8 __nss_lookup_function 00f0 __nss_next2 0144 __errno_location 0190 __strcasecmp 01b0 strcmp 0248 strlen 0254 malloc 0278 memcpy 0380 __assert_fail"
	strings:
		$1 = { 94 21 FB 80 7D 80 00 26 2F 86 00 00 7C 08 02 A6 93 A1 04 74 7C BD 2B 78 2D 1D 00 00 93 E1 04 7C 7C 9F 23 78 2D 9F 00 00 90 01 04 84 7C 00 00 26 54 00 E0 06 38 80 00 00 93 01 04 60 38 A0 00 2C 7C 78 1B 78 93 21 04 64 38 61 00 0C 3F 20 ?? ?? 93 61 04 6C 3F 60 ?? ?? 3B 39 ?? ?? 93 81 04 70 3F 80 ?? ?? 3B 9C ?? ?? 93 41 04 68 3B 7B ?? ?? 7C DA 33 78 93 C1 04 78 7F 1E C3 78 92 81 04 50 92 A1 04 54 92 C1 04 58 92 E1 04 5C 91 81 04 4C 90 01 04 3C 4? ?? ?? ?? 38 61 00 08 38 81 00 34 4B FF F6 D5 2F 83 00 00 41 BE 00 54 48 00 02 20 80 61 00 34 7F 84 E3 78 4? ?? ?? ?? 7C 60 1B 79 41 82 00 10 38 61 00 0C 7C 09 03 A6 4E 80 04 21 2F 96 00 00 40 9E 02 24 38 61 00 34 7F 64 DB 78 38 A0 00 00 38 C1 00 08 7E E7 BB 78 39 00 00 00 4? ?? ?? ?? 2F 83 00 00 40 9E 01 D4 80 01 00 1C 2F 80 00 00 40 9E 02 60 80 01 00 08 7F C3 F3 78 38 81 00 0C 7C 09 03 A6 3A C0 00 00 4E 80 04 21 2F 83 00 01 7C 77 1B 78 40 9E FF 88 80 61 00 34 7F 24 CB 78 4? ?? ?? ?? 7C 60 1B 79 90 01 04 38 41 A2 FF 70 4? ?? ?? ?? 7C 77 1B 78 80 01 04 38 38 61 00 0C 38 81 00 38 38 A0 04 00 7C 09 03 A6 7E E6 BB 78 4E 80 04 21 2F 83 00 01 40 9E 01 38 80 01 00 0C 2F 80 00 01 41 9E 00 80 80 61 00 10 2F 83 00 00 41 9E 00 18 41 8E 00 14 7F E4 FB 78 4? ?? ?? ?? 2F 83 00 00 40 BE FF B4 80 61 00 14 2F 83 00 00 41 9E 00 18 41 8A 00 14 7F A4 EB 78 4? ?? ?? ?? 2F 83 00 00 40 BE FF 94 80 61 00 18 2F 83 00 00 41 9E 00 28 80 01 04 3C 54 00 20 3E 7C 00 11 20 54 00 E0 3E 41 9E 00 14 7F 44 D3 78 4? ?? ?? ?? 2F 83 00 00 40 9E FF 64 3A E0 00 02 3A C0 00 01 4B FF FE BC 82 C1 00 2C 2E 16 00 00 41 92 00 B0 82 A1 00 10 48 00 00 10 82 D6 00 00 2E 16 00 00 41 92 00 1C 7E A3 AB 78 38 96 00 04 4? ?? ?? ?? 2F 83 00 00 40 9E FF E4 40 92 FF 20 7F 03 C3 78 7E A4 AB 78 4? ?? ?? ?? 2F 83 00 00 41 9E FF 0C 7E A3 AB 78 4? ?? ?? ?? 7C 74 1B 78 38 63 00 05 4? ?? ?? ?? 3A 94 00 01 7C 76 1B 79 41 82 00 F8 80 01 00 30 7E A4 AB 78 7E 85 A3 78 90 16 00 00 38 76 00 04 4? ?? ?? ?? 80 01 04 38 92 C1 00 30 38 61 00 0C 38 81 00 38 7C 09 03 A6 38 A0 04 00 7E E6 BB 78 4E 80 04 21 2F 83 00 01 41 9E FE D0 3A E0 00 02 3A C0 00 00 4B FF FE 04 82 A1 00 10 7F 03 C3 78 7E A4 AB 78 4? ?? ?? ?? 2F 83 00 00 41 9E FE 88 4B FF FF 7C 81 21 00 30 2F 89 00 00 41 9E 00 20 80 09 00 00 3B C9 00 04 90 01 00 30 80 01 00 2C 90 09 00 00 91 21 00 2C 4B FF FD A8 3A C0 00 00 38 61 00 2C 38 81 00 30 4B FF F7 25 80 01 04 84 6A C3 00 01 81 81 04 4C 7C 08 03 A6 7C 63 00 34 54 63 D9 7E 82 81 04 50 82 A1 04 54 7D 83 81 20 82 C1 04 58 82 E1 04 5C 83 01 04 60 83 21 04 64 83 41 04 68 83 61 04 6C 83 81 04 70 83 A1 04 74 83 C1 04 78 83 E1 04 7C 38 21 04 80 4E 80 00 20 3A E0 00 02 3A C0 FF FF 4B FF FD 50 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 01 6B 38 C6 ?? ?? 4? ?? ?? ?? }
	condition:
		$1
}

rule file_97_0_0 {
	meta:
		name = "__getsgnam_r"
		size = 584
		refs = "008a _GLOBAL_OFFSET_TABLE_ 0092 __libc_errno 00a4 _dl_mcount_wrapper_check 00f8 __nss_next2 01f8 __nss_gshadow_lookup2"
	strings:
		$1 = { 94 21 FF C0 7C 08 02 A6 93 E1 00 3C 3F E0 ?? ?? 90 01 00 44 88 1F ?? ?? 92 E1 00 1C 7C F7 3B 78 2F 80 00 00 93 41 00 28 7C DA 33 78 93 61 00 2C 7C BB 2B 78 93 81 00 30 7C 7C 1B 78 93 A1 00 34 7C 9D 23 78 93 C1 00 38 3B DF ?? ?? 93 01 00 20 93 21 00 24 41 9E 01 90 81 62 8F F4 81 3E 00 04 81 5E 00 08 7D 29 5A 78 38 09 00 01 91 21 00 08 7C 00 00 34 54 00 D9 7E 7D 4B 5A 78 2F 80 00 00 91 61 00 0C 40 9E 01 28 3F 00 ?? ?? 3B 18 ?? ?? 83 D8 ?? ?? 3F 20 ?? ?? 7F DE 12 14 3B 39 ?? ?? 80 61 00 0C 4? ?? ?? ?? 80 01 00 0C 7F A4 EB 78 7F 65 DB 78 7C 09 03 A6 7F 46 D3 78 7F C7 F3 78 7F 83 E3 78 4E 80 04 21 7F 24 CB 78 7C 7F 1B 78 2F 9F FF FE 38 61 00 08 38 A0 00 00 38 C1 00 0C 7F E7 FB 78 39 00 00 00 40 9E 00 10 80 1E 00 00 2F 80 00 22 41 9E 00 C4 4? ?? ?? ?? 2F 83 00 00 41 9E FF A0 2F 9F 00 01 41 9E 00 5C 2B 9F 00 01 38 00 00 00 90 17 00 00 40 9D 01 28 81 38 ?? ?? 7D 29 12 14 80 69 00 00 2F 83 00 22 41 9E 00 A8 80 01 00 44 82 E1 00 1C 7C 08 03 A6 83 01 00 20 83 21 00 24 83 41 00 28 83 61 00 2C 83 81 00 30 83 A1 00 34 83 C1 00 38 83 E1 00 3C 38 21 00 40 4E 80 00 20 93 B7 00 00 38 60 00 00 80 01 00 44 83 18 ?? ?? 7F 18 12 14 82 E1 00 1C 7C 08 03 A6 90 78 00 00 83 01 00 20 83 21 00 24 83 41 00 28 83 61 00 2C 83 81 00 30 83 A1 00 34 83 C1 00 38 83 E1 00 3C 38 21 00 40 4E 80 00 20 3F 00 ?? ?? 3B E0 FF FF 3B 18 ?? ?? 81 38 ?? ?? 7D 29 12 14 80 69 00 00 38 00 00 00 90 17 00 00 2F 83 00 22 40 9E FF 60 2F 9F FF FE 41 BE FF 58 38 60 00 16 4B FF FF 8C 3C 80 ?? ?? 38 61 00 08 38 84 ?? ?? 38 A0 00 00 38 C1 00 0C 4? ?? ?? ?? 2F 83 00 00 40 9E 00 30 80 02 8F F4 81 21 00 0C 81 61 00 08 7D 29 02 78 7D 60 02 78 91 3E 00 08 90 1E 00 04 7C 00 06 AC 38 00 00 01 98 1F ?? ?? 4B FF FE 58 80 02 8F F4 7C 00 00 F8 90 1E 00 04 4B FF FF E4 38 60 00 00 4B FF FF 28 }
	condition:
		$1
}

rule file_792_0_0 {
	meta:
		name = "__getaliasbyname_r"
		size = 584
		refs = "008a _GLOBAL_OFFSET_TABLE_ 0092 __libc_errno 00a4 _dl_mcount_wrapper_check 00f8 __nss_next2 01f8 __nss_aliases_lookup2"
	strings:
		$1 = { 94 21 FF C0 7C 08 02 A6 93 E1 00 3C 3F E0 ?? ?? 90 01 00 44 88 1F ?? ?? 92 E1 00 1C 7C F7 3B 78 2F 80 00 00 93 41 00 28 7C DA 33 78 93 61 00 2C 7C BB 2B 78 93 81 00 30 7C 7C 1B 78 93 A1 00 34 7C 9D 23 78 93 C1 00 38 3B DF ?? ?? 93 01 00 20 93 21 00 24 41 9E 01 90 81 62 8F F4 81 3E 00 04 81 5E 00 08 7D 29 5A 78 38 09 00 01 91 21 00 08 7C 00 00 34 54 00 D9 7E 7D 4B 5A 78 2F 80 00 00 91 61 00 0C 40 9E 01 28 3F 00 ?? ?? 3B 18 ?? ?? 83 D8 ?? ?? 3F 20 ?? ?? 7F DE 12 14 3B 39 ?? ?? 80 61 00 0C 4? ?? ?? ?? 80 01 00 0C 7F A4 EB 78 7F 65 DB 78 7C 09 03 A6 7F 46 D3 78 7F C7 F3 78 7F 83 E3 78 4E 80 04 21 7F 24 CB 78 7C 7F 1B 78 2F 9F FF FE 38 61 00 08 38 A0 00 00 38 C1 00 0C 7F E7 FB 78 39 00 00 00 40 9E 00 10 80 1E 00 00 2F 80 00 22 41 9E 00 C4 4? ?? ?? ?? 2F 83 00 00 41 9E FF A0 2F 9F 00 01 41 9E 00 5C 2B 9F 00 01 38 00 00 00 90 17 00 00 40 9D 01 28 81 38 ?? ?? 7D 29 12 14 80 69 00 00 2F 83 00 22 41 9E 00 A8 80 01 00 44 82 E1 00 1C 7C 08 03 A6 83 01 00 20 83 21 00 24 83 41 00 28 83 61 00 2C 83 81 00 30 83 A1 00 34 83 C1 00 38 83 E1 00 3C 38 21 00 40 4E 80 00 20 93 B7 00 00 38 60 00 00 80 01 00 44 83 18 ?? ?? 7F 18 12 14 82 E1 00 1C 7C 08 03 A6 90 78 00 00 83 01 00 20 83 21 00 24 83 41 00 28 83 61 00 2C 83 81 00 30 83 A1 00 34 83 C1 00 38 83 E1 00 3C 38 21 00 40 4E 80 00 20 3F 00 ?? ?? 3B E0 FF FF 3B 18 ?? ?? 81 38 ?? ?? 7D 29 12 14 80 69 00 00 38 00 00 00 90 17 00 00 2F 83 00 22 40 9E FF 60 2F 9F FF FE 41 BE FF 58 38 60 00 16 4B FF FF 8C 3C 80 ?? ?? 38 61 00 08 38 84 ?? ?? 38 A0 00 00 38 C1 00 0C 4? ?? ?? ?? 2F 83 00 00 40 9E 00 30 80 02 8F F4 81 21 00 0C 81 61 00 08 7D 29 02 78 7D 60 02 78 91 3E 00 08 90 1E 00 04 7C 00 06 AC 38 00 00 01 98 1F ?? ?? 4B FF FE 58 80 02 8F F4 7C 00 00 F8 90 1E 00 04 4B FF FF E4 38 60 00 00 4B FF FF 28 }
	condition:
		$1
}

rule file_371_0_0 {
	meta:
		name = "__getrpcbyname_r"
		size = 584
		refs = "008a _GLOBAL_OFFSET_TABLE_ 0092 __libc_errno 00a4 _dl_mcount_wrapper_check 00f8 __nss_next2 01f8 __nss_rpc_lookup2"
	strings:
		$1 = { 94 21 FF C0 7C 08 02 A6 93 E1 00 3C 3F E0 ?? ?? 90 01 00 44 88 1F ?? ?? 92 E1 00 1C 7C F7 3B 78 2F 80 00 00 93 41 00 28 7C DA 33 78 93 61 00 2C 7C BB 2B 78 93 81 00 30 7C 7C 1B 78 93 A1 00 34 7C 9D 23 78 93 C1 00 38 3B DF ?? ?? 93 01 00 20 93 21 00 24 41 9E 01 90 81 62 8F F4 81 3E 00 04 81 5E 00 08 7D 29 5A 78 38 09 00 01 91 21 00 08 7C 00 00 34 54 00 D9 7E 7D 4B 5A 78 2F 80 00 00 91 61 00 0C 40 9E 01 28 3F 00 ?? ?? 3B 18 ?? ?? 83 D8 ?? ?? 3F 20 ?? ?? 7F DE 12 14 3B 39 ?? ?? 80 61 00 0C 4? ?? ?? ?? 80 01 00 0C 7F A4 EB 78 7F 65 DB 78 7C 09 03 A6 7F 46 D3 78 7F C7 F3 78 7F 83 E3 78 4E 80 04 21 7F 24 CB 78 7C 7F 1B 78 2F 9F FF FE 38 61 00 08 38 A0 00 00 38 C1 00 0C 7F E7 FB 78 39 00 00 00 40 9E 00 10 80 1E 00 00 2F 80 00 22 41 9E 00 C4 4? ?? ?? ?? 2F 83 00 00 41 9E FF A0 2F 9F 00 01 41 9E 00 5C 2B 9F 00 01 38 00 00 00 90 17 00 00 40 9D 01 28 81 38 ?? ?? 7D 29 12 14 80 69 00 00 2F 83 00 22 41 9E 00 A8 80 01 00 44 82 E1 00 1C 7C 08 03 A6 83 01 00 20 83 21 00 24 83 41 00 28 83 61 00 2C 83 81 00 30 83 A1 00 34 83 C1 00 38 83 E1 00 3C 38 21 00 40 4E 80 00 20 93 B7 00 00 38 60 00 00 80 01 00 44 83 18 ?? ?? 7F 18 12 14 82 E1 00 1C 7C 08 03 A6 90 78 00 00 83 01 00 20 83 21 00 24 83 41 00 28 83 61 00 2C 83 81 00 30 83 A1 00 34 83 C1 00 38 83 E1 00 3C 38 21 00 40 4E 80 00 20 3F 00 ?? ?? 3B E0 FF FF 3B 18 ?? ?? 81 38 ?? ?? 7D 29 12 14 80 69 00 00 38 00 00 00 90 17 00 00 2F 83 00 22 40 9E FF 60 2F 9F FF FE 41 BE FF 58 38 60 00 16 4B FF FF 8C 3C 80 ?? ?? 38 61 00 08 38 84 ?? ?? 38 A0 00 00 38 C1 00 0C 4? ?? ?? ?? 2F 83 00 00 40 9E 00 30 80 02 8F F4 81 21 00 0C 81 61 00 08 7D 29 02 78 7D 60 02 78 91 3E 00 08 90 1E 00 04 7C 00 06 AC 38 00 00 01 98 1F ?? ?? 4B FF FE 58 80 02 8F F4 7C 00 00 F8 90 1E 00 04 4B FF FF E4 38 60 00 00 4B FF FF 28 }
	condition:
		$1
}

rule file_1477_0_0 {
	meta:
		name = "__getrpcbynumber_r"
		size = 584
		refs = "008a _GLOBAL_OFFSET_TABLE_ 0092 __libc_errno 00a4 _dl_mcount_wrapper_check 00f8 __nss_next2 01f8 __nss_rpc_lookup2"
	strings:
		$1 = { 94 21 FF C0 7C 08 02 A6 93 E1 00 3C 3F E0 ?? ?? 90 01 00 44 88 1F ?? ?? 92 E1 00 1C 7C F7 3B 78 2F 80 00 00 93 41 00 28 7C DA 33 78 93 61 00 2C 7C BB 2B 78 93 81 00 30 7C 7C 1B 78 93 A1 00 34 7C 9D 23 78 93 C1 00 38 3B DF ?? ?? 93 01 00 20 93 21 00 24 41 9E 01 90 81 62 8F F4 81 3E 00 04 81 5E 00 08 7D 29 5A 78 38 09 00 01 91 21 00 08 7C 00 00 34 54 00 D9 7E 7D 4B 5A 78 2F 80 00 00 91 61 00 0C 40 9E 01 28 3F 00 ?? ?? 3B 18 ?? ?? 83 D8 ?? ?? 3F 20 ?? ?? 7F DE 12 14 3B 39 ?? ?? 80 61 00 0C 4? ?? ?? ?? 80 01 00 0C 7F A4 EB 78 7F 65 DB 78 7C 09 03 A6 7F 46 D3 78 7F C7 F3 78 7F 83 E3 78 4E 80 04 21 7F 24 CB 78 7C 7F 1B 78 2F 9F FF FE 38 61 00 08 38 A0 00 00 38 C1 00 0C 7F E7 FB 78 39 00 00 00 40 9E 00 10 80 1E 00 00 2F 80 00 22 41 9E 00 C4 4? ?? ?? ?? 2F 83 00 00 41 9E FF A0 2F 9F 00 01 41 9E 00 5C 2B 9F 00 01 38 00 00 00 90 17 00 00 40 9D 01 28 81 38 ?? ?? 7D 29 12 14 80 69 00 00 2F 83 00 22 41 9E 00 A8 80 01 00 44 82 E1 00 1C 7C 08 03 A6 83 01 00 20 83 21 00 24 83 41 00 28 83 61 00 2C 83 81 00 30 83 A1 00 34 83 C1 00 38 83 E1 00 3C 38 21 00 40 4E 80 00 20 93 B7 00 00 38 60 00 00 80 01 00 44 83 18 ?? ?? 7F 18 12 14 82 E1 00 1C 7C 08 03 A6 90 78 00 00 83 01 00 20 83 21 00 24 83 41 00 28 83 61 00 2C 83 81 00 30 83 A1 00 34 83 C1 00 38 83 E1 00 3C 38 21 00 40 4E 80 00 20 3F 00 ?? ?? 3B E0 FF FF 3B 18 ?? ?? 81 38 ?? ?? 7D 29 12 14 80 69 00 00 38 00 00 00 90 17 00 00 2F 83 00 22 40 9E FF 60 2F 9F FF FE 41 BE FF 58 38 60 00 16 4B FF FF 8C 3C 80 ?? ?? 38 61 00 08 38 84 ?? ?? 38 A0 00 00 38 C1 00 0C 4? ?? ?? ?? 2F 83 00 00 40 9E 00 30 80 02 8F F4 81 21 00 0C 81 61 00 08 7D 29 02 78 7D 60 02 78 91 3E 00 08 90 1E 00 04 7C 00 06 AC 38 00 00 01 98 1F ?? ?? 4B FF FE 58 80 02 8F F4 7C 00 00 F8 90 1E 00 04 4B FF FF E4 38 60 00 00 4B FF FF 28 }
	condition:
		$1
}

rule file_833_0_0 {
	meta:
		name = "__getspnam_r"
		size = 584
		refs = "008a _GLOBAL_OFFSET_TABLE_ 0092 __libc_errno 00a4 _dl_mcount_wrapper_check 00f8 __nss_next2 01f8 __nss_shadow_lookup2"
	strings:
		$1 = { 94 21 FF C0 7C 08 02 A6 93 E1 00 3C 3F E0 ?? ?? 90 01 00 44 88 1F ?? ?? 92 E1 00 1C 7C F7 3B 78 2F 80 00 00 93 41 00 28 7C DA 33 78 93 61 00 2C 7C BB 2B 78 93 81 00 30 7C 7C 1B 78 93 A1 00 34 7C 9D 23 78 93 C1 00 38 3B DF ?? ?? 93 01 00 20 93 21 00 24 41 9E 01 90 81 62 8F F4 81 3E 00 04 81 5E 00 08 7D 29 5A 78 38 09 00 01 91 21 00 08 7C 00 00 34 54 00 D9 7E 7D 4B 5A 78 2F 80 00 00 91 61 00 0C 40 9E 01 28 3F 00 ?? ?? 3B 18 ?? ?? 83 D8 ?? ?? 3F 20 ?? ?? 7F DE 12 14 3B 39 ?? ?? 80 61 00 0C 4? ?? ?? ?? 80 01 00 0C 7F A4 EB 78 7F 65 DB 78 7C 09 03 A6 7F 46 D3 78 7F C7 F3 78 7F 83 E3 78 4E 80 04 21 7F 24 CB 78 7C 7F 1B 78 2F 9F FF FE 38 61 00 08 38 A0 00 00 38 C1 00 0C 7F E7 FB 78 39 00 00 00 40 9E 00 10 80 1E 00 00 2F 80 00 22 41 9E 00 C4 4? ?? ?? ?? 2F 83 00 00 41 9E FF A0 2F 9F 00 01 41 9E 00 5C 2B 9F 00 01 38 00 00 00 90 17 00 00 40 9D 01 28 81 38 ?? ?? 7D 29 12 14 80 69 00 00 2F 83 00 22 41 9E 00 A8 80 01 00 44 82 E1 00 1C 7C 08 03 A6 83 01 00 20 83 21 00 24 83 41 00 28 83 61 00 2C 83 81 00 30 83 A1 00 34 83 C1 00 38 83 E1 00 3C 38 21 00 40 4E 80 00 20 93 B7 00 00 38 60 00 00 80 01 00 44 83 18 ?? ?? 7F 18 12 14 82 E1 00 1C 7C 08 03 A6 90 78 00 00 83 01 00 20 83 21 00 24 83 41 00 28 83 61 00 2C 83 81 00 30 83 A1 00 34 83 C1 00 38 83 E1 00 3C 38 21 00 40 4E 80 00 20 3F 00 ?? ?? 3B E0 FF FF 3B 18 ?? ?? 81 38 ?? ?? 7D 29 12 14 80 69 00 00 38 00 00 00 90 17 00 00 2F 83 00 22 40 9E FF 60 2F 9F FF FE 41 BE FF 58 38 60 00 16 4B FF FF 8C 3C 80 ?? ?? 38 61 00 08 38 84 ?? ?? 38 A0 00 00 38 C1 00 0C 4? ?? ?? ?? 2F 83 00 00 40 9E 00 30 80 02 8F F4 81 21 00 0C 81 61 00 08 7D 29 02 78 7D 60 02 78 91 3E 00 08 90 1E 00 04 7C 00 06 AC 38 00 00 01 98 1F ?? ?? 4B FF FE 58 80 02 8F F4 7C 00 00 F8 90 1E 00 04 4B FF FF E4 38 60 00 00 4B FF FF 28 }
	condition:
		$1
}

rule file_98_0_0 {
	meta:
		name = "getsockname"
		size = 44
		refs = "0028 __syscall_error"
	strings:
		$1 = { 94 21 FF D0 90 61 00 14 90 81 00 18 90 A1 00 1C 38 60 00 06 38 81 00 14 38 00 00 66 44 00 00 02 38 21 00 30 4C A3 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_100_0_0 {
	meta:
		name = "__getlogin_r_chk"
		size = 44
		refs = "0014 getlogin_r 0028 __chk_fail"
	strings:
		$1 = { 7F 84 28 40 94 21 FF F0 7C 08 02 A6 90 01 00 14 41 9D 00 18 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_1424_0_0 {
	meta:
		name = "__getcwd_chk"
		size = 44
		refs = "0014 __getcwd 0028 __chk_fail"
	strings:
		$1 = { 7F 84 28 40 94 21 FF F0 7C 08 02 A6 90 01 00 14 41 9D 00 18 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_836_0_0 {
	meta:
		name = "__getdomainname_chk"
		size = 44
		refs = "0014 getdomainname 0028 __chk_fail"
	strings:
		$1 = { 7F 84 28 40 94 21 FF F0 7C 08 02 A6 90 01 00 14 41 9D 00 18 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_831_0_0 {
	meta:
		name = "__gethostname_chk"
		size = 44
		refs = "0014 __gethostname 0028 __chk_fail"
	strings:
		$1 = { 7F 84 28 40 94 21 FF F0 7C 08 02 A6 90 01 00 14 41 9D 00 18 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_101_0_0 {
	meta:
		name = "semtimedop"
		size = 72
		refs = "002e _GLOBAL_OFFSET_TABLE_ 0036 __libc_errno"
	strings:
		$1 = { 7C 69 1B 78 7C 87 23 78 7C C8 33 78 38 00 00 75 38 60 00 04 7D 24 4B 78 38 C0 00 00 44 00 00 02 7C 00 00 26 74 09 10 00 4D A2 00 20 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 90 69 00 00 38 60 FF FF 4E 80 00 20 }
	condition:
		$1
}

rule file_102_0_0 {
	meta:
		name = "__vswprintf_chk"
		size = 308
		refs = "005a _IO_wstrn_jumps 0070 _IO_no_init 007c _IO_fwide 00a8 _IO_wstr_init_static 00b8 _IO_vfwprintf 0130 __chk_fail"
	strings:
		$1 = { 7F 86 20 40 94 21 FD 70 7C 08 02 A6 93 41 02 78 7D 1A 43 78 93 81 02 80 7C BC 2B 78 93 A1 02 84 7C FD 3B 78 93 C1 02 88 7C 7E 1B 78 93 E1 02 8C 7C 9F 23 78 90 01 02 94 93 61 02 7C 41 9C 00 F4 2F 84 00 00 3B 60 00 00 93 61 01 10 38 60 FF FF 41 9E 00 8C 38 80 00 00 3C E0 ?? ?? 60 84 80 00 38 A0 00 00 38 C1 00 08 38 E7 ?? ?? 38 61 00 C8 4? ?? ?? ?? 38 61 00 C8 38 80 00 01 4? ?? ?? ?? 2F 9C 00 00 93 7E 00 00 40 9D 00 10 80 01 01 04 60 00 00 04 90 01 01 04 7F C4 F3 78 7F C6 F3 78 38 61 00 C8 38 BF FF FF 4? ?? ?? ?? 38 61 00 C8 7F A4 EB 78 7F 45 D3 78 4? ?? ?? ?? 81 21 01 24 38 01 01 70 81 69 00 18 7F 8B 00 00 41 9E 00 38 81 29 00 10 38 00 00 00 90 09 00 00 80 01 02 94 83 41 02 78 7C 08 03 A6 83 61 02 7C 83 81 02 80 83 A1 02 84 83 C1 02 88 83 E1 02 8C 38 21 02 90 4E 80 00 20 80 01 02 94 38 60 FF FF 83 41 02 78 7C 08 03 A6 83 61 02 7C 83 81 02 80 83 A1 02 84 83 C1 02 88 83 E1 02 8C 38 21 02 90 4E 80 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_103_0_0 {
	meta:
		name = "__swapoff"
		size = 16
		refs = "000c __syscall_error"
	strings:
		$1 = { 38 00 00 73 44 00 00 02 4C A3 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_104_0_0 {
	meta:
		name = "__gmtime_r"
		size = 40
		refs = "0014 __tz_convert"
		altNames = "gmtime_r"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 7C 85 23 78 38 80 00 00 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_104_1_0 {
	meta:
		name = "gmtime"
		size = 44
		refs = "000a _tmbuf 0018 __tz_convert"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 3C A0 ?? ?? 38 80 00 00 90 01 00 14 38 A5 ?? ?? 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_105_0_0 {
	meta:
		name = "__rmdir"
		size = 16
		refs = "000c __syscall_error"
	strings:
		$1 = { 38 00 00 28 44 00 00 02 4C A3 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_106_0_0 {
	meta:
		name = "__parse_one_specmb"
		size = 1896
		refs = "0182 __printf_modifier_table 01ba __printf_function_table 021c __strchrnul 06e8 __handle_registered_modifier_mb 0732 __printf_arginfo_table"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 3D 60 E0 4F 93 A1 00 14 61 6B FF FF 39 23 00 01 93 E1 00 1C 7C 9D 23 78 7C BF 2B 78 90 01 00 24 93 C1 00 18 80 05 00 0C 91 21 00 08 7C 00 58 38 39 60 FF FF 90 05 00 0C 91 65 00 24 39 60 00 20 91 65 00 10 89 63 00 01 39 0B FF D0 2B 88 00 09 41 9D 00 58 39 69 00 01 91 61 00 08 89 49 00 01 38 EA FF D0 2B 87 00 09 41 9D 00 28 39 6B 00 01 1D 08 00 0A 91 61 00 08 7D 08 52 14 89 4B 00 00 39 08 FF D0 38 EA FF D0 2B 87 00 09 40 9D FF E0 2F 88 00 00 41 9E 00 0C 2F 8A 00 24 41 9E 04 54 91 21 00 08 89 63 00 01 3D 40 ?? ?? 39 4A ?? ?? 39 00 00 01 38 E0 00 30 39 6B FF E0 55 6B 06 3E 2B 8B 00 29 40 9D 01 78 74 0B 04 00 41 82 00 0C 38 00 00 20 90 1F 00 10 38 00 FF FF 90 1F 00 20 38 00 00 00 90 1F 00 04 89 69 00 00 2F 8B 00 2A 41 9E 02 94 38 0B FF D0 2B 80 00 09 3B C0 00 00 41 9D 00 4C 39 69 00 01 91 61 00 08 89 29 00 01 39 49 FF D0 2B 8A 00 09 41 9D 00 28 39 6B 00 01 1C 00 00 0A 91 61 00 08 7D 40 4A 14 89 2B 00 00 38 0A FF D0 39 49 FF D0 2B 8A 00 09 40 9D FF E0 90 1F 00 04 3B C0 00 00 81 21 00 08 38 00 FF FF 90 1F 00 1C 90 1F 00 00 88 09 00 00 2F 80 00 2E 41 9E 01 BC 81 7F 00 0C 38 00 00 00 55 6B 00 FE 50 0B B2 52 91 7F 00 0C 3D 60 ?? ?? 81 4B ?? ?? B0 1F 00 0E 2F 8A 00 00 40 9E 05 3C 89 69 00 00 38 0B FF B4 54 00 06 3E 2B 80 00 2E 39 69 00 01 91 61 00 08 40 9D 01 2C 91 21 00 08 89 29 00 00 3D 40 ?? ?? 91 3F 00 08 80 0A ?? ?? 91 61 00 08 2F 80 00 00 38 00 FF FF 90 1F 00 30 40 9E 05 5C 39 29 FF BF 55 29 06 3E 2B 89 00 37 38 00 00 01 90 1F 00 2C 40 9D 00 D0 38 00 00 00 90 1F 00 2C 80 1F 00 24 2F 80 FF FF 41 9E 02 04 80 1F 00 08 2F 80 00 00 41 9E 00 E8 80 61 00 08 38 80 00 25 90 7F 00 14 4? ?? ?? ?? 80 01 00 24 90 7F 00 18 7F C3 F3 78 7C 08 03 A6 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 55 6B 10 3A 7D 6A 58 2E 7D 6B 52 14 7D 69 03 A6 4E 80 04 20 51 00 A2 D6 90 1F 00 0C 39 29 00 01 91 21 00 08 89 69 00 00 2F 8B 00 00 40 9E FE 50 4B FF FE 5C 90 FF 00 10 4B FF FF E4 51 00 D1 4A 90 1F 00 0C 4B FF FF D8 51 00 C9 8C 90 1F 00 0C 4B FF FF CC 51 00 C1 CE 90 1F 00 0C 4B FF FF C0 51 00 E0 C6 90 1F 00 0C 4B FF FF B4 51 00 D9 08 90 1F 00 0C 4B FF FF A8 3D 60 ?? ?? 39 6B ?? ?? 55 29 10 3A 7C 0B 48 2E 7D 60 5A 14 7D 69 03 A6 4E 80 04 20 3D 40 ?? ?? 39 4A ?? ?? 54 00 10 3A 7C 0A 00 2E 7D 40 52 14 7D 49 03 A6 4E 80 04 20 81 21 00 08 7F C3 F3 78 83 A1 00 14 38 09 FF FF 83 C1 00 18 90 1F 00 18 90 1F 00 14 80 01 00 24 83 E1 00 1C 38 21 00 20 7C 08 03 A6 4E 80 00 20 39 29 00 01 91 21 00 08 89 69 00 00 2F 8B 00 2A 41 9E 02 70 38 0B FF D0 2B 80 00 09 41 9D 00 DC 39 69 00 01 91 61 00 08 89 29 00 01 39 49 FF D0 2B 8A 00 09 41 9D 00 28 39 6B 00 01 1C 00 00 0A 91 61 00 08 7D 40 4A 14 89 2B 00 00 38 0A FF D0 39 49 FF D0 2B 8A 00 09 40 9D FF E0 90 1F 00 00 81 21 00 08 4B FF FD E4 39 29 00 01 91 21 00 08 89 09 00 00 39 08 FF D0 2B 88 00 09 41 9D 00 50 39 69 00 01 91 61 00 08 89 49 00 01 38 0A FF D0 2B 80 00 09 41 9D 00 28 39 6B 00 01 1D 08 00 0A 91 61 00 08 7D 08 52 14 89 4B 00 00 39 08 FF D0 38 0A FF D0 2B 80 00 09 40 9D FF E0 2F 88 00 00 41 9E 00 0C 2F 8A 00 24 41 9E 02 A4 93 BF 00 20 3B C0 00 01 3B BD 00 01 91 21 00 08 4B FF FD 54 80 1F 00 2C 2F 80 00 00 41 BE FD F8 93 BF 00 24 7F DE 02 14 4B FF FD EC 38 00 00 00 90 1F 00 00 4B FF FD 48 80 1F 00 0C 39 20 00 00 54 00 00 7E 51 20 E8 84 90 1F 00 0C 89 2B 00 00 39 6B 00 01 4B FF FD 74 88 0B 00 00 2F 80 00 68 41 9E 02 B4 80 1F 00 0C 39 20 00 01 51 20 F0 42 90 1F 00 0C 89 2B 00 00 39 6B 00 01 4B FF FD 4C 80 1F 00 0C 39 20 00 01 51 20 F8 00 51 20 E8 84 90 1F 00 0C 89 2B 00 00 39 6B 00 01 4B FF FD 2C 80 1F 00 0C 39 20 00 01 51 20 E8 84 90 1F 00 0C 89 2B 00 00 2F 89 00 6C 40 9E FF 98 39 6B 00 01 91 61 00 08 48 00 00 28 80 1F 00 0C 39 20 00 00 54 00 00 7E 51 20 E8 84 90 1F 00 0C 89 2B 00 00 39 6B 00 01 4B FF FC E4 80 1F 00 0C 39 20 00 01 51 20 F8 00 81 21 00 08 90 1F 00 0C 39 69 00 01 89 29 00 00 4B FF FC C4 38 08 FF FF 90 1F 00 24 39 2B 00 01 80 06 00 00 91 21 00 08 7F 88 00 40 41 9C 01 6C 91 06 00 00 89 69 00 00 80 1F 00 0C 4B FF FB 90 74 00 00 40 41 82 00 20 38 00 00 01 90 1F 00 28 4B FF FC C4 80 1F 00 0C 2F 80 00 00 40 9C 01 1C 38 00 01 07 90 1F 00 28 4B FF FC AC 38 00 00 02 90 1F 00 28 4B FF FC A0 38 00 00 05 90 1F 00 28 4B FF FC 94 38 00 00 03 90 1F 00 28 4B FF FC 88 80 1F 00 0C 2F 80 00 00 40 9C 00 C4 38 00 01 00 90 1F 00 28 4B FF FC 70 38 00 00 04 90 1F 00 28 4B FF FC 64 38 00 08 00 90 1F 00 28 4B FF FC 58 39 29 00 01 91 21 00 08 89 09 00 00 39 08 FF D0 2B 88 00 09 41 9D 00 B0 39 69 00 01 91 61 00 08 89 49 00 01 38 0A FF D0 2B 80 00 09 41 9D 00 28 39 6B 00 01 1D 08 00 0A 91 61 00 08 7D 08 52 14 89 4B 00 00 39 08 FF D0 38 0A FF D0 2B 80 00 09 40 9D FF E0 2F 88 00 00 41 9E 00 6C 2F 8A 00 24 40 BE 00 64 38 08 FF FF 90 1F 00 1C 80 06 00 00 7F 88 00 40 40 9C 00 08 7C 08 03 78 91 06 00 00 39 6B 00 01 80 1F 00 1C 91 61 00 08 2F 80 00 00 41 9C 00 34 7D 69 5B 78 4B FF FB 30 74 09 20 00 40 82 00 40 74 0B 40 00 41 A2 FE D8 38 00 04 00 90 1F 00 28 4B FF FB A0 38 00 00 07 90 1F 00 28 4B FF FB 94 93 BF 00 1C 3B DE 00 01 3B BD 00 01 91 21 00 08 4B FF FA F4 7C 08 03 78 4B FF FE 94 38 00 02 00 90 1F 00 28 4B FF FB 6C 38 08 FF FF 90 1F 00 20 80 06 00 00 7F 88 00 40 40 9C 00 08 7C 08 03 78 91 06 00 00 39 6B 00 01 80 1F 00 20 91 61 00 08 2F 80 00 00 41 BC FD 34 7D 69 5B 78 3B C0 00 00 4B FF FA 8C 89 69 00 00 55 60 15 BA 7C 0A 00 2E 2F 80 00 00 41 BE FA BC 38 61 00 08 7F E4 FB 78 4? ?? ?? ?? 2F 83 00 00 40 9E 00 38 81 61 00 08 89 2B 00 00 39 6B 00 01 4B FF FA B8 80 1F 00 0C 39 20 00 01 39 4B 00 01 51 20 B2 52 91 41 00 08 90 1F 00 0C 89 2B 00 01 39 6B 00 02 4B FF FA 94 81 21 00 08 4B FF FA 68 3D 60 ?? ?? 81 6B ?? ?? 55 20 10 3A 7C 0B 00 2E 2F 80 00 00 41 BE FA 94 7F E3 FB 78 7C 09 03 A6 38 80 00 01 38 BF 00 28 38 DF 00 30 4E 80 04 21 90 7F 00 2C 4B FF FA 94 }
	condition:
		$1
}

rule file_107_0_0 {
	meta:
		name = "__flock"
		size = 16
		refs = "000c __syscall_error"
	strings:
		$1 = { 38 00 00 8F 44 00 00 02 4C A3 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_108_0_0 {
	meta:
		name = "putgrent"
		size = 804
		refs = "00c4 fprintf 0286 _GLOBAL_OFFSET_TABLE_ 028e __libc_errno 02ac __overflow 031c __lll_lock_wait_private"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 93 E1 00 1C 7C 7F 1B 79 93 C1 00 18 7C 9E 23 78 90 01 00 24 93 61 00 0C 93 81 00 10 93 A1 00 14 41 82 02 5C 2F 84 00 00 41 9E 02 54 80 04 00 00 70 00 80 00 40 82 00 50 80 64 00 48 3B A2 8B 60 81 23 00 08 7F 89 E8 00 41 9E 00 30 39 60 00 01 7D 20 18 28 7C 09 00 00 40 82 00 0C 7D 60 19 2D 40 A2 FF F0 4C 00 01 2C 2F 89 00 00 40 9E 02 A8 80 7E 00 48 93 A3 00 08 81 23 00 04 38 09 00 01 90 03 00 04 80 BF 00 00 88 05 00 00 2F 80 00 2B 41 9E 01 B0 2F 80 00 2D 41 9E 01 A8 80 DF 00 04 2F 86 00 00 41 9E 01 C0 3C 80 ?? ?? 80 FF 00 08 7F C3 F3 78 38 84 ?? ?? 4C C6 31 82 4? ?? ?? ?? 2F 83 00 00 41 9C 01 EC 81 3F 00 0C 2F 89 00 00 41 9E 00 C0 80 A9 00 00 2F 85 00 00 41 9E 00 B4 3B A0 00 00 3F 60 ?? ?? 3F 80 ?? ?? 48 00 00 14 81 3F 00 0C 7C A9 00 2E 2F 85 00 00 41 9E 00 94 2F 9D 00 00 38 9C ?? ?? 41 9E 00 08 38 9B ?? ?? 7F C3 F3 78 4C C6 31 82 4? ?? ?? ?? 3B BD 00 01 2F 83 00 00 57 A0 10 3A 40 9C FF C8 80 1E 00 00 3B E0 FF FF 70 09 80 00 40 A2 00 8C 80 7E 00 48 80 03 00 04 30 00 FF FF 2F 80 00 00 90 03 00 04 40 BE 00 74 90 03 00 08 7C 00 04 AC 7D 20 18 28 7C 00 19 2D 40 A2 FF F8 2F 89 00 01 40 BD 00 58 80 82 8B 68 38 00 00 DD 38 A0 00 01 60 84 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 48 00 00 38 81 3E 00 14 80 1E 00 18 7F 89 00 40 40 9C 01 00 38 09 00 01 39 60 00 0A 99 69 00 00 3B E0 00 0A 90 1E 00 14 80 1E 00 00 70 09 80 00 41 82 00 30 7F FF FE 70 80 01 00 24 7F E3 FB 78 83 61 00 0C 7C 08 03 A6 83 81 00 10 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 80 7E 00 48 81 23 00 04 38 09 FF FF 2F 80 00 00 90 03 00 04 40 BE FF C0 90 03 00 08 7C 00 04 AC 7D 20 18 28 7C 00 19 2D 40 A2 FF F8 2F 89 00 01 40 9D FF A4 80 82 8B 68 38 00 00 DD 38 A0 00 01 60 84 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF 84 80 DF 00 04 2F 86 00 00 41 9E 00 28 3C 80 ?? ?? 7F C3 F3 78 38 84 ?? ?? 4C C6 31 82 4? ?? ?? ?? 4B FF FE 60 3C C0 ?? ?? 38 C6 ?? ?? 4B FF FE 3C 3C C0 ?? ?? 38 C6 ?? ?? 4B FF FF D4 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 38 00 00 16 90 09 00 00 3B E0 FF FF 4B FF FF 2C 7F C3 F3 78 38 80 00 0A 4? ?? ?? ?? 7C 7F 1B 78 4B FF FF 08 80 1E 00 00 3B E0 FF FF 70 09 80 00 40 82 FF 08 80 7E 00 48 80 03 00 04 30 00 FF FF 2F 80 00 00 90 03 00 04 40 9E FE F0 90 03 00 08 7C 00 04 AC 7D 20 18 28 7C 00 19 2D 40 A2 FF F8 2F 89 00 01 40 9D FE D4 80 82 8B 68 38 00 00 DD 38 A0 00 01 60 84 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FE B4 4? ?? ?? ?? 4B FF FD 58 }
	condition:
		$1
}

rule file_109_0_0 {
	meta:
		name = "svc_exit"
		size = 76
		refs = "0014 __rpc_thread_svc_pollfd 0024 free 002c __rpc_thread_svc_max_pollfd"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 93 C1 00 08 90 01 00 14 93 E1 00 0C 4? ?? ?? ?? 7C 7E 1B 78 80 63 00 00 3B E0 00 00 4? ?? ?? ?? 93 FE 00 00 4? ?? ?? ?? 80 01 00 14 93 E3 00 00 7C 08 03 A6 83 C1 00 08 83 E1 00 0C 38 21 00 10 4E 80 00 20 }
	condition:
		$1
}

rule file_109_1_0 {
	meta:
		name = "svc_run"
		size = 376
		refs = "0012 _GLOBAL_OFFSET_TABLE_ 001e __libc_errno 004c __rpc_thread_svc_max_pollfd 0060 __rpc_thread_svc_pollfd 0080 realloc 00dc __poll 00f8 svc_getreq_poll 011e _libc_intl_domainname 0128 __dcgettext 012c perror 0134 free"
	strings:
		$1 = { 94 21 FF D0 7C 08 02 A6 7D 80 00 26 93 61 00 1C 3F 60 ?? ?? 3B 7B ?? ?? 93 81 00 20 83 7B ?? ?? 7F 7B 12 14 93 A1 00 24 3B A0 00 00 93 C1 00 28 3B C0 00 00 93 E1 00 2C 3B E0 00 00 90 01 00 34 93 21 00 14 93 41 00 18 91 81 00 10 4? ?? ?? ?? 7C 7C 1B 78 83 5C 00 00 2E 1A 00 00 40 92 00 14 4? ?? ?? ?? 80 03 00 00 2F 80 00 00 41 9E 00 C4 7F 9D D0 00 41 9E 00 8C 7F E3 FB 78 57 44 18 38 4? ?? ?? ?? 7F 59 D3 78 2C 03 00 00 41 82 00 E0 7F 5D D3 78 7C 7F 1B 78 40 91 00 38 4? ?? ?? ?? 7F 49 03 A6 81 03 00 00 39 40 00 00 7D 0B 43 78 7C 0B 50 6E 7F E9 FB 78 7C 09 51 6E 39 4A 00 08 A0 0B 00 04 B3 C9 00 06 B0 09 00 04 42 00 FF E0 7F 24 CB 78 7F E3 FB 78 38 A0 FF FF 4? ?? ?? ?? 2F 83 FF FF 7C 64 1B 78 41 9E 00 20 2F 83 00 00 41 BE FF 64 7F E3 FB 78 4? ?? ?? ?? 4B FF FF 58 7F B9 EB 78 4B FF FF 94 80 1B 00 00 2F 80 00 04 41 9E FF 44 3C 80 ?? ?? 38 84 ?? ?? 3C 60 ?? ?? 38 A0 00 05 38 63 ?? ?? 4? ?? ?? ?? 4? ?? ?? ?? 7F E3 FB 78 4? ?? ?? ?? 80 01 00 34 81 81 00 10 7C 08 03 A6 83 21 00 14 83 41 00 18 7D 80 81 20 83 61 00 1C 83 81 00 20 83 A1 00 24 83 C1 00 28 83 E1 00 2C 38 21 00 30 4E 80 00 20 3C 80 ?? ?? 38 84 ?? ?? 4B FF FF A8 }
	condition:
		$1
}

rule file_110_0_0 {
	meta:
		name = "getchar_unlocked"
		size = 76
		refs = "000a _IO_stdin 0044 __uflow"
	strings:
		$1 = { 7C 08 02 A6 94 21 FF F0 3D 20 ?? ?? 90 01 00 14 81 29 ?? ?? 81 69 00 04 80 09 00 08 7F 8B 00 40 40 9C 00 20 38 0B 00 01 88 6B 00 00 90 09 00 04 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 7D 23 4B 78 4? ?? ?? ?? 4B FF FF E8 }
	condition:
		$1
}

rule file_111_0_0 {
	meta:
		name = "inotify_init"
		size = 16
		refs = "000c __syscall_error"
	strings:
		$1 = { 38 00 01 13 44 00 00 02 4C A3 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_112_0_0 {
	meta:
		name = "__mpn_mul"
		size = 924
		refs = "0080 __mpn_mul_1 00ac __mpn_addmul_1 00f4 __mpn_add_n 0190 __mpn_impn_mul_n 022c __mpn_mul"
	strings:
		$1 = { 2F 87 00 1F 94 21 FF B0 7C 08 02 A6 93 21 00 34 7C D9 33 78 93 41 00 38 7C 7A 1B 78 93 81 00 40 7C 9C 23 78 93 A1 00 44 7C BD 2B 78 93 C1 00 48 7C FE 3B 78 93 E1 00 4C 7C 3F 0B 78 90 01 00 54 92 21 00 14 92 41 00 18 92 61 00 1C 92 81 00 20 92 A1 00 24 92 C1 00 28 92 E1 00 2C 93 01 00 30 93 61 00 3C 41 9D 00 FC 2F 87 00 00 38 00 00 00 41 9E 00 9C 80 C6 00 00 2B 86 00 01 40 9D 01 48 4? ?? ?? ?? 7C 60 1B 78 2F 9E 00 01 57 BB 10 3A 7C 1A D9 2E 40 9D 00 78 38 1A FF FC 57 DE 10 3A 3B 5A 00 04 7F C0 F2 14 48 00 00 1C 4? ?? ?? ?? 7C 60 1B 78 7F 9A F0 00 7C 1A D9 2E 3B 5A 00 04 41 9E 00 4C 84 D9 00 04 7F 43 D3 78 7F 84 E3 78 2B 86 00 01 2F 06 00 01 7F A5 EB 78 41 BD FF D0 38 00 00 00 40 9A FF D0 7F 44 D3 78 7F 85 E3 78 7F A6 EB 78 4? ?? ?? ?? 7F 9A F0 00 7C 60 1B 78 7C 1A D9 2E 3B 5A 00 04 40 9E FF BC 39 7F 00 50 7C 03 03 78 80 0B 00 04 82 2B FF C4 7C 08 03 A6 82 4B FF C8 82 6B FF CC 82 8B FF D0 82 AB FF D4 82 CB FF D8 82 EB FF DC 83 0B FF E0 83 2B FF E4 83 4B FF E8 83 6B FF EC 83 8B FF F0 83 AB FF F4 83 CB FF F8 83 EB FF FC 7D 61 5B 78 4E 80 00 20 54 F8 18 38 80 01 00 00 3B 18 00 1E 57 18 00 36 7F 18 00 D0 7C 01 C1 6E 7C C5 33 78 7E FE E8 50 3A A1 00 17 56 B5 00 36 7C E6 3B 78 7E A7 AB 78 4? ?? ?? ?? 7F 9E B8 00 57 D6 10 3A 7F 7A B2 14 7F 9C B2 14 40 9D 01 1C 2F 97 00 00 40 9E 00 6C 7F DD F2 14 38 1E FF FF 54 00 10 3A 7C 1A 00 2E 4B FF FF 4C 2F 86 00 01 41 9E 00 28 2F 85 00 00 7C A9 03 A6 39 23 FF FC 39 60 00 00 40 BD FE AC 95 69 00 04 42 00 FF FC 38 00 00 00 4B FF FE 9C 2F 85 00 00 40 BD FE 94 7C A9 03 A6 39 64 FF FC 39 23 FF FC 84 0B 00 04 94 09 00 04 42 00 FF F8 38 00 00 00 4B FF FE 74 7E E7 BB 78 7F 24 CB 78 7F C5 F3 78 7F 86 E3 78 7E A3 AB 78 4? ?? ?? ?? 7F 63 DB 78 7F 64 DB 78 7E A5 AB 78 7F C6 F3 78 4? ?? ?? ?? 7C 15 B0 2E 7D 3B B2 14 7E E9 03 A6 7C 63 02 14 7F 80 18 40 7C 7B B1 2E 7D 75 B2 14 39 6B 00 04 39 29 00 04 41 9D 00 30 7F 89 58 00 41 BE FF 40 36 F7 FF FF 40 A1 FF 38 7E E9 03 A6 39 6B FF FC 39 29 FF FC 84 0B 00 04 94 09 00 04 42 00 FF F8 4B FF FF 1C 3A F7 FF FF 42 40 FF 14 81 4B 00 00 39 6B 00 04 38 0A 00 01 2F 80 00 00 90 09 00 00 39 29 00 04 41 9E FF E0 4B FF FF B0 80 01 00 00 7E 3E 00 D0 7C 01 C1 6E 7F 1E B8 50 3A 81 00 17 56 94 00 36 7E 54 B2 14 3A 72 00 04 7E A7 AB 78 7E 83 A3 78 7F 84 E3 78 7F 25 CB 78 7F C6 F3 78 4? ?? ?? ?? 7F 63 DB 78 7F 64 DB 78 7E 85 A3 78 7F C6 F3 78 4? ?? ?? ?? 80 12 00 00 7F C9 F3 78 7F C9 03 A6 7C 63 02 14 7F 80 18 40 7C 7B B1 6E 7E 6A 9B 78 39 7B 00 04 41 9D 00 64 7F 8B 50 00 41 9E 00 24 35 29 FF FF 40 81 00 1C 7D 29 03 A6 39 4A FF FC 39 6B FF FC 84 0A 00 04 94 0B 00 04 42 00 FF F8 7F 17 C3 78 7F 18 8A 14 7C 1E C2 14 7F 9E 00 00 7F 9C B2 14 40 9D FF 74 4B FF FE 38 81 0A 00 00 39 4A 00 04 38 08 00 01 2F 80 00 00 90 0B 00 00 39 6B 00 04 40 BE FF A4 39 29 FF FF 42 00 FF E0 4B FF FF C0 }
	condition:
		$1
}

rule file_113_0_0 {
	meta:
		name = "__dup"
		size = 16
		refs = "000c __syscall_error"
	strings:
		$1 = { 38 00 00 29 44 00 00 02 4C A3 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_114_0_0 {
	meta:
		name = "__gets_chk"
		size = 584
		refs = "0032 _IO_stdin 00e4 _IO_getline 0198 __uflow 01b0 __chk_fail 01b4 __lll_lock_wait_private 0224 _Unwind_Resume"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 93 61 00 0C 7C 9B 23 79 93 A1 00 14 7C 7D 1B 78 90 01 00 24 93 41 00 08 93 81 00 10 93 C1 00 18 93 E1 00 1C 41 82 01 84 3F C0 ?? ?? 83 FE ?? ?? 80 1F 00 00 7F E9 FB 78 70 00 80 00 40 82 00 54 80 7F 00 48 3B 82 8B 60 81 23 00 08 7F 89 E0 00 41 9E 00 30 39 60 00 01 7D 20 18 28 7C 09 00 00 40 82 00 0C 7D 60 19 2D 40 A2 FF F0 4C 00 01 2C 2F 89 00 00 40 9E 01 38 80 7F 00 48 93 83 00 08 81 63 00 04 81 3E ?? ?? 38 0B 00 01 90 03 00 04 81 69 00 04 80 09 00 08 7F 8B 00 40 40 9C 00 F0 39 4B 00 01 88 0B 00 00 91 49 00 04 2F 80 00 0A 41 9E 00 58 81 3E ?? ?? 38 9D 00 01 38 BB FF FF 83 49 00 00 38 C0 00 0A 38 E0 00 00 57 4B 06 F2 91 69 00 00 98 1D 00 00 80 7E ?? ?? 4? ?? ?? ?? 81 3E ?? ?? 3B 80 00 00 80 09 00 00 70 0B 00 20 40 82 00 30 57 5A 06 B4 7F 40 03 78 38 63 00 01 90 09 00 00 48 00 00 08 38 60 00 00 7F 83 D8 40 40 9C 00 A4 38 00 00 00 7C 1D 19 AE 7F BC EB 78 80 1F 00 00 70 09 80 00 40 82 00 38 80 7F 00 48 81 23 00 04 38 09 FF FF 2F 80 00 00 90 03 00 04 40 9E 00 20 90 03 00 08 7C 00 04 AC 7D 20 18 28 7C 00 19 2D 40 A2 FF F8 2F 89 00 01 41 9D 00 C4 80 01 00 24 7F 83 E3 78 83 41 00 08 7C 08 03 A6 83 61 00 0C 83 81 00 10 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 7D 23 4B 78 4? ?? ?? ?? 2F 83 FF FF 7C 60 1B 78 3B 80 00 00 41 9E FF 80 4B FF FF 08 4? ?? ?? ?? 4? ?? ?? ?? 4B FF FE C8 4? ?? ?? ?? 80 1F 00 00 7C 7E 1B 78 70 0B 80 00 40 82 00 54 80 7F 00 48 80 03 00 04 30 00 FF FF 2F 80 00 00 90 03 00 04 40 9E 00 3C 90 03 00 08 7C 00 04 AC 7D 20 18 28 7C 00 19 2D 40 A2 FF F8 2F 89 00 01 40 BD 00 20 80 82 8B 68 38 00 00 DD 38 A0 00 01 60 84 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 7F C3 F3 78 4? ?? ?? ?? 80 82 8B 68 38 00 00 DD 38 A0 00 01 60 84 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF 24 }
	condition:
		$1
}

rule file_115_0_0 {
	meta:
		name = "__ftruncate64"
		size = 52
		refs = "001a _GLOBAL_OFFSET_TABLE_ 0022 __libc_errno"
	strings:
		$1 = { 38 00 00 C2 38 80 00 00 44 00 00 02 7C 00 00 26 74 09 10 00 4D A2 00 20 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 90 69 00 00 38 60 FF FF 4E 80 00 20 }
	condition:
		$1
}

rule file_116_0_0 {
	meta:
		name = "__libc_fork"
		size = 804
		refs = "000a __fork_handlers 00cc _IO_list_lock 012a __fork_generation_pointer 014c _IO_iter_begin 015c _IO_iter_file 0174 _IO_iter_next 017c _IO_iter_end 0188 _IO_list_resetlock 0192 _dl_load_lock 01f2 __fork_lock 0226 _GLOBAL_OFFSET_TABLE_ 022e __libc_errno 0250 _IO_list_unlock 0300 __assert_fail"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 3D 60 ?? ?? 90 01 00 24 39 6B ?? ?? 93 61 00 0C 93 81 00 10 93 A1 00 14 93 C1 00 18 93 E1 00 1C 7C 3F 0B 78 83 AB 00 00 2F 9D 00 00 41 9E 02 A8 7C 00 04 AC 81 3D 00 14 2F 89 00 00 41 BE FF E8 81 4B 00 00 39 09 00 01 39 4A 00 14 7C 00 50 28 7C 09 00 51 40 82 00 0C 7D 00 51 2D 40 A2 FF F0 4C 00 01 2C 2F 80 00 00 40 BE FF BC 3B 80 00 00 48 00 00 1C 39 3D 00 14 7D 60 48 28 39 6B 00 01 7D 60 49 2D 40 A2 FF F4 7F DC F3 78 80 1D 00 04 2F 80 00 00 41 9E 00 0C 7C 09 03 A6 4E 80 04 21 80 01 00 00 94 01 FF E0 3B C1 00 17 57 DE 00 36 93 BE 00 00 83 BD 00 00 93 9E 00 04 2F 9D 00 00 40 9E FF B4 4? ?? ?? ?? 3C 60 01 20 83 A2 8B CC 60 63 00 11 83 62 8B C8 38 80 00 00 7C 1D 00 D0 90 02 8B CC 38 A0 00 00 38 00 00 78 38 C0 00 00 38 E2 8B C8 44 00 00 02 7C 00 00 26 74 09 10 00 7C 7C 1B 78 40 82 01 18 2F 83 00 00 40 9E 01 28 39 62 8B 60 80 0B 00 68 7F 80 D8 00 41 9E 01 C0 3D 20 ?? ?? 81 29 ?? ?? 2F 89 00 00 41 9E 00 10 81 49 00 00 39 4A 00 04 91 49 00 00 90 0B 00 6C 3B 60 00 00 4? ?? ?? ?? 7C 7D 1B 78 48 00 00 28 7F A3 EB 78 4? ?? ?? ?? 81 23 00 48 7F A3 EB 78 93 69 00 00 93 69 00 04 93 69 00 08 4? ?? ?? ?? 7C 7D 1B 78 4? ?? ?? ?? 7F 9D 18 00 40 9E FF D4 4? ?? ?? ?? 2F 9E 00 00 3D 60 ?? ?? 38 00 00 00 39 2B ?? ?? 90 0B ?? ?? 90 09 00 04 90 09 00 08 90 09 00 10 90 09 00 14 38 00 00 01 90 09 00 0C 41 9E 00 34 3B A0 00 01 81 3E 00 00 80 09 00 0C 2F 80 00 00 41 9E 00 10 7C 09 03 A6 4E 80 04 21 81 3E 00 00 83 DE 00 04 93 A9 00 14 2F 9E 00 00 40 9E FF D8 38 00 00 00 3D 20 ?? ?? 90 09 ?? ?? 39 7F 00 20 80 0B 00 04 7F 83 E3 78 83 6B FF EC 7C 08 03 A6 83 8B FF F0 83 AB FF F4 83 CB FF F8 83 EB FF FC 7D 61 5B 78 4E 80 00 20 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 90 69 00 00 3B 80 FF FF 39 22 8B 60 80 09 00 68 7F 80 D8 00 40 9E 00 BC 93 A9 00 6C 4? ?? ?? ?? 2F 9E 00 00 41 BE FF A0 3B A0 FF FF 48 00 00 10 83 DE 00 04 2F 9E 00 00 41 BE FF 8C 81 3E 00 00 80 09 00 08 2F 80 00 00 41 9E 00 10 7C 09 03 A6 4E 80 04 21 81 3E 00 00 39 69 00 14 7D 40 58 28 7C 0A EA 14 7C 00 59 2D 40 A2 FF F4 2F 8A 00 01 40 9E FF C0 81 3E 00 00 80 09 00 18 2F 80 00 00 41 BE FF B0 80 82 8B 68 38 00 00 DD 80 69 00 14 38 A0 00 01 60 84 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF 8C 3B C0 00 00 4B FF FD EC 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 00 8D 38 C6 ?? ?? 4? ?? ?? ?? 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 00 C1 38 C6 ?? ?? 4? ?? ?? ?? }
	condition:
		$1
}

rule file_117_0_0 {
	meta:
		name = "_IO_vasprintf"
		size = 384
		refs = "0034 malloc 0060 _IO_no_init 0066 _IO_str_jumps 0080 _IO_str_init_static_internal 009a free 00b4 _IO_vfprintf 00ec realloc 0150 memcpy"
	strings:
		$1 = { 94 21 FF 30 7C 08 02 A6 93 E1 00 CC 7C 7F 1B 78 38 60 00 64 93 61 00 BC 3B 60 FF FF 93 81 00 C0 93 A1 00 C4 7C 9D 23 78 93 C1 00 C8 7C BE 2B 78 90 01 00 D4 4? ?? ?? ?? 7C 7C 1B 79 41 82 00 CC 38 80 00 00 38 E0 00 00 38 00 00 00 38 61 00 08 90 01 00 50 60 84 80 00 38 A0 FF FF 38 C0 00 00 4? ?? ?? ?? 3D 20 ?? ?? 38 09 ?? ?? 7F 84 E3 78 90 01 00 A0 7F 86 E3 78 38 61 00 08 38 A0 00 64 4? ?? ?? ?? 80 01 00 08 3D 20 ?? ?? 54 00 00 3C 90 01 00 08 38 09 ?? ?? 3D 20 ?? ?? 90 01 00 A8 38 61 00 08 38 09 ?? ?? 7F A4 EB 78 90 01 00 AC 7F C5 F3 78 4? ?? ?? ?? 7C 7B 1B 79 41 80 00 B8 80 01 00 18 83 C1 00 1C 81 21 00 20 3B DE 00 01 7D 20 48 50 7F C0 F0 50 55 20 F8 7E 7F 9E 00 40 41 9C 00 50 80 61 00 24 7F C4 F3 78 4? ?? ?? ?? 2F 83 00 00 90 7F 00 00 41 9E 00 70 7F C3 F2 14 38 00 00 00 98 1E FF FF 80 01 00 D4 7F 63 DB 78 83 81 00 C0 7C 08 03 A6 83 61 00 BC 83 A1 00 C4 83 C1 00 C8 83 E1 00 CC 38 21 00 D0 4E 80 00 20 7F C3 F3 78 4? ?? ?? ?? 2F 83 00 00 90 7F 00 00 41 BE FF A4 83 A1 00 24 38 BE FF FF 7F A4 EB 78 4? ?? ?? ?? 7F A3 EB 78 4? ?? ?? ?? 80 7F 00 00 2F 83 00 00 40 9E FF 98 80 61 00 24 90 7F 00 00 4B FF FF 8C 80 61 00 24 4? ?? ?? ?? 4B FF FF 8C }
	condition:
		$1
}

rule file_118_0_0 {
	meta:
		name = "getservbyport"
		size = 444
		refs = "00a0 __getservbyport_r 00c4 realloc 00d8 free 00dc __errno_location 0164 malloc 0190 __lll_lock_wait_private"
	strings:
		$1 = { 94 21 FF C0 7C 08 02 A6 39 60 00 01 93 21 00 24 3F 20 ?? ?? 39 20 00 00 93 81 00 30 7C 9C 23 78 93 A1 00 34 7C 7D 1B 78 93 E1 00 3C 3B F9 ?? ?? 90 01 00 44 93 01 00 20 93 41 00 28 93 61 00 2C 93 C1 00 38 7C 00 F8 28 7C 00 48 00 40 82 00 0C 7D 60 F9 2D 40 A2 FF F0 4C 00 01 2C 2F 80 00 00 40 9E 01 2C 3F C0 ?? ?? 80 DE ?? ?? 2F 86 00 00 41 9E 00 E8 3F 40 ?? ?? 80 FF 00 04 3B 5A ?? ?? 3B 61 00 08 48 00 00 0C 90 DE ?? ?? 80 FF 00 04 7F 84 E3 78 7F 45 D3 78 7F 68 DB 78 7F A3 EB 78 4? ?? ?? ?? 3B 1E ?? ?? 2F 83 00 22 40 9E 00 9C 80 1F 00 04 80 7E ?? ?? 54 00 08 3C 90 1F 00 04 7C 04 03 78 4? ?? ?? ?? 7C 66 1B 79 40 82 FF BC 80 78 00 00 90 C1 00 18 4? ?? ?? ?? 4? ?? ?? ?? 80 C1 00 18 38 00 00 0C 90 03 00 00 90 D8 00 00 38 00 00 00 90 01 00 08 38 00 00 00 7C 00 04 AC 7D 20 F8 28 7C 00 F9 2D 40 A2 FF F8 2F 89 00 01 41 9D 00 88 80 01 00 44 80 61 00 08 7C 08 03 A6 83 01 00 20 83 21 00 24 83 41 00 28 83 61 00 2C 83 81 00 30 83 A1 00 34 83 C1 00 38 83 E1 00 3C 38 21 00 40 4E 80 00 20 80 1E ?? ?? 2F 80 00 00 40 9E FF A8 4B FF FF 9C 38 00 04 00 90 1F 00 04 38 60 04 00 4? ?? ?? ?? 2F 83 00 00 90 7E ?? ?? 7C 66 1B 78 41 9E FF 7C 3F 40 ?? ?? 38 E0 04 00 3B 5A ?? ?? 3B 61 00 08 4B FF FF 08 7F E3 FB 78 4? ?? ?? ?? 4B FF FE D0 80 82 8B 68 38 00 00 DD 7F E3 FB 78 60 84 00 01 38 A0 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF 5C }
	condition:
		$1
}

rule file_412_0_0 {
	meta:
		name = "getservbyname"
		size = 444
		refs = "00a0 __getservbyname_r 00c4 realloc 00d8 free 00dc __errno_location 0164 malloc 0190 __lll_lock_wait_private"
	strings:
		$1 = { 94 21 FF C0 7C 08 02 A6 39 60 00 01 93 21 00 24 3F 20 ?? ?? 39 20 00 00 93 81 00 30 7C 9C 23 78 93 A1 00 34 7C 7D 1B 78 93 E1 00 3C 3B F9 ?? ?? 90 01 00 44 93 01 00 20 93 41 00 28 93 61 00 2C 93 C1 00 38 7C 00 F8 28 7C 00 48 00 40 82 00 0C 7D 60 F9 2D 40 A2 FF F0 4C 00 01 2C 2F 80 00 00 40 9E 01 2C 3F C0 ?? ?? 80 DE ?? ?? 2F 86 00 00 41 9E 00 E8 3F 40 ?? ?? 80 FF 00 04 3B 5A ?? ?? 3B 61 00 08 48 00 00 0C 90 DE ?? ?? 80 FF 00 04 7F 84 E3 78 7F 45 D3 78 7F 68 DB 78 7F A3 EB 78 4? ?? ?? ?? 3B 1E ?? ?? 2F 83 00 22 40 9E 00 9C 80 1F 00 04 80 7E ?? ?? 54 00 08 3C 90 1F 00 04 7C 04 03 78 4? ?? ?? ?? 7C 66 1B 79 40 82 FF BC 80 78 00 00 90 C1 00 18 4? ?? ?? ?? 4? ?? ?? ?? 80 C1 00 18 38 00 00 0C 90 03 00 00 90 D8 00 00 38 00 00 00 90 01 00 08 38 00 00 00 7C 00 04 AC 7D 20 F8 28 7C 00 F9 2D 40 A2 FF F8 2F 89 00 01 41 9D 00 88 80 01 00 44 80 61 00 08 7C 08 03 A6 83 01 00 20 83 21 00 24 83 41 00 28 83 61 00 2C 83 81 00 30 83 A1 00 34 83 C1 00 38 83 E1 00 3C 38 21 00 40 4E 80 00 20 80 1E ?? ?? 2F 80 00 00 40 9E FF A8 4B FF FF 9C 38 00 04 00 90 1F 00 04 38 60 04 00 4? ?? ?? ?? 2F 83 00 00 90 7E ?? ?? 7C 66 1B 78 41 9E FF 7C 3F 40 ?? ?? 38 E0 04 00 3B 5A ?? ?? 3B 61 00 08 4B FF FF 08 7F E3 FB 78 4? ?? ?? ?? 4B FF FE D0 80 82 8B 68 38 00 00 DD 7F E3 FB 78 60 84 00 01 38 A0 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF 5C }
	condition:
		$1
}

rule file_119_0_0 {
	meta:
		name = "_IO_helper_overflow"
		size = 240
		refs = "00c4 __wmemmove 00e4 __woverflow"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 90 01 00 24 81 23 00 5C 93 A1 00 14 93 C1 00 18 7C 9E 23 78 83 A9 00 10 80 89 00 0C 93 E1 00 1C 7C 7F 1B 78 7F A4 E8 50 7F BD 16 71 93 81 00 10 80 63 01 5C 40 82 00 44 81 69 00 10 80 09 00 14 7F 8B 00 40 40 9C 00 90 38 0B 00 04 93 CB 00 00 90 09 00 10 80 01 00 24 7F C3 F3 78 83 81 00 10 7C 08 03 A6 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 81 23 00 98 7F A5 EB 78 80 09 00 1C 7C 09 03 A6 4E 80 04 21 38 00 FF FD 39 23 FF FF 7F 89 00 40 40 9D 00 0C 3B C0 FF FF 4B FF FF B4 81 3F 00 5C 54 7C 10 3A 7C A3 E8 50 80 09 00 0C 7C 80 E2 14 7C 03 03 78 4? ?? ?? ?? 81 3F 00 5C 80 09 00 10 7F 9C 00 50 93 89 00 10 4B FF FF 68 7F C4 F3 78 7F E3 FB 78 4? ?? ?? ?? 7C 7E 1B 78 4B FF FF 70 }
	condition:
		$1
}

rule file_119_1_0 {
	meta:
		name = "group_number"
		size = 308
		refs = "0098 mempcpy"
	strings:
		$1 = { 94 21 FF D0 7C 08 02 A6 93 81 00 20 7C 9C 23 78 90 01 00 34 93 C1 00 28 7C BE 2B 78 93 E1 00 2C 7C 3F 0B 78 93 61 00 1C 93 A1 00 24 8B A5 00 00 38 1D FF FF 54 00 06 3E 2B 80 00 FD 40 9D 00 2C 39 7F 00 30 80 0B 00 04 83 6B FF EC 7C 08 03 A6 83 8B FF F0 83 AB FF F4 83 CB FF F8 83 EB FF FC 7D 61 5B 78 4E 80 00 20 7C A3 20 50 81 21 00 00 54 A5 00 3A 90 DF 00 08 38 05 00 1E 54 00 00 36 7C 00 00 D0 7D 21 01 6E 7C 64 1B 78 3B 61 00 17 57 7B 00 36 7F 63 DB 78 4? ?? ?? ?? 80 DF 00 08 7F 9B 18 40 7C 69 1B 78 7F 83 E3 78 40 BC FF 94 7F A9 03 A6 3B DE 00 01 84 09 FF FC 7F 1B 48 40 94 03 FF FC 7F 9B 48 40 42 00 00 40 40 B8 FF 74 94 C3 FF FC 88 1E 00 00 2F 80 00 FF 7C 09 03 A6 2F 00 00 00 41 9E 00 2C 40 BA FF CC 88 1E FF FF 7C 09 03 A6 84 09 FF FC 7F 1B 48 40 94 03 FF FC 7F 9B 48 40 42 40 FF C8 41 9C FF B0 4B FF FF 34 84 09 FF FC 7F 9B 48 40 94 03 FF FC 40 BC FF 24 84 09 FF FC 7F 9B 48 40 94 03 FF FC 41 9C FF E4 4B FF FF 10 }
	condition:
		$1
}

rule file_119_2_0 {
	meta:
		name = "_i18n_number_rewrite"
		size = 468
		refs = "0044 __wctrans 0054 __towctrans 00a4 mempcpy 00aa _GLOBAL_OFFSET_TABLE_ 00ba _nl_current_LC_CTYPE 0124 free 01a4 __libc_alloca_cutoff 01bc malloc"
	strings:
		$1 = { 94 21 FF D0 7C 08 02 A6 93 C1 00 28 7C 7E 1B 78 3C 60 ?? ?? 93 E1 00 2C 38 63 ?? ?? 7C 3F 0B 78 90 01 00 34 93 01 00 10 93 21 00 14 93 41 00 18 7C BA 2B 78 93 81 00 20 93 A1 00 24 7C 9D 23 78 93 61 00 1C 4? ?? ?? ?? 7C 64 1B 78 7C 7C 1B 78 38 60 00 2E 4? ?? ?? ?? 7F 84 E3 78 7C 79 1B 78 38 60 00 2C 4? ?? ?? ?? 7C BE E8 50 54 A5 00 3A 2B 85 80 00 7C 78 1B 78 41 9D 01 24 38 05 00 1E 81 21 00 00 54 00 00 36 7C 00 00 D0 7D 21 01 6E 3B 60 00 01 3B A1 00 17 57 BD 00 36 7F C4 F3 78 7F A3 EB 78 4? ?? ?? ?? 3D 20 ?? ?? 38 63 FF FC 7F 9D 18 40 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 3B 5A FF FC 81 69 00 00 2F 1C 00 00 3B DA 00 04 41 9D 00 48 81 23 00 00 38 09 FF D0 2B 80 00 09 41 9D 00 80 39 29 00 03 80 0B 00 00 55 29 04 3E 39 29 00 08 55 29 10 3A 7D 20 4A 14 80 09 00 04 90 1A 00 00 3B 5A FF FC 38 63 FF FC 7F 9D 18 40 3B DA 00 04 40 9D FF C0 2F 9B 00 00 40 BE 00 0C 7F A3 EB 78 4? ?? ?? ?? 39 7F 00 30 80 0B 00 04 7F C3 F3 78 83 0B FF E0 7C 08 03 A6 83 2B FF E4 83 4B FF E8 83 6B FF EC 83 8B FF F0 83 AB FF F4 83 CB FF F8 83 EB FF FC 7D 61 5B 78 4E 80 00 20 40 9A 00 10 91 3A 00 00 3B 5A FF FC 4B FF FF 9C 2F 89 00 2E 41 9E 00 1C 2F 89 00 2C 40 9E FF E8 7F 00 C3 78 90 1A 00 00 3B 5A FF FC 4B FF FF 7C 7F 20 CB 78 90 1A 00 00 4B FF FF F0 7C A3 2B 78 90 BF 00 08 4? ?? ?? ?? 2F 83 00 00 80 BF 00 08 40 9E FE CC 7C A3 2B 78 90 BF 00 08 4? ?? ?? ?? 7C 7D 1B 79 80 BF 00 08 41 A2 FF 60 3B 60 00 00 4B FF FE CC }
	condition:
		$1
}

rule file_119_3_0 {
	meta:
		name = "buffered_vfprintf"
		size = 660
		refs = "0054 _IO_fwide 00fc _IO_vfwprintf 0102 _pthread_cleanup_push_defer 0122 _IO_funlockfile 0210 _pthread_cleanup_pop_restore 0264 __lll_lock_wait_private 026c _Unwind_Resume"
	strings:
		$1 = { 94 21 FE 50 7C 08 02 A6 7D 80 00 26 90 01 01 B4 3C 00 FF FF 60 00 7F F0 81 21 00 00 93 41 01 98 7C BA 2B 78 93 61 01 9C 7C 9B 23 78 38 80 00 01 93 81 01 A0 93 A1 01 A4 3B A0 FF FF 93 C1 01 A8 7C 7E 1B 78 93 E1 01 AC 7C 3F 0B 78 91 81 01 94 7D 21 01 6E 4? ?? ?? ?? 3B 81 00 17 2F 83 00 01 57 9C 00 36 7C 60 1B 78 41 9E 00 3C 39 7F 01 B0 80 0B 00 04 7F A3 EB 78 81 8B FF E4 7C 08 03 A6 83 4B FF E8 83 6B FF EC 7D 80 81 20 83 8B FF F0 83 AB FF F4 83 CB FF F8 83 EB FF FC 7D 61 5B 78 4E 80 00 20 81 3E 00 3C 39 7C 20 00 90 1F 00 84 3C 00 FB AD 60 00 80 04 91 3F 00 54 3D 20 ?? ?? 39 29 ?? ?? 90 1F 00 18 38 00 00 00 39 5F 00 B8 90 1F 00 60 38 7F 00 18 38 09 03 A4 7F 64 DB 78 93 DF 01 74 7F 45 D3 78 91 5F 00 74 93 9F 00 C8 93 9F 00 C4 91 7F 00 CC 90 1F 00 B0 4? ?? ?? ?? 3D 20 ?? ?? 38 09 ?? ?? 7C 00 00 34 54 00 D9 7E 68 00 00 01 2E 00 00 00 7C 7D 1B 78 40 92 01 30 3D 20 ?? ?? 93 DF 00 0C 38 09 ?? ?? 90 1F 00 08 80 1E 00 00 70 00 80 00 40 82 00 50 80 7E 00 48 3B 82 8B 60 81 23 00 08 7F 89 E0 00 41 9E 00 30 39 60 00 01 7D 20 18 28 7C 09 00 00 40 82 00 0C 7D 60 19 2D 40 A2 FF F0 4C 00 01 2C 2F 89 00 00 40 9E 00 F4 80 7E 00 48 93 83 00 08 81 23 00 04 38 09 00 01 90 03 00 04 81 3F 00 74 80 89 00 0C 83 89 00 10 7F 84 E0 50 7F 9C 16 71 40 81 00 28 81 3E 00 98 7F C3 F3 78 7F 85 E3 78 80 09 00 1C 7C 09 03 A6 4E 80 04 21 7F 83 E0 00 41 9E 00 08 3B A0 FF FF 80 1E 00 00 70 09 80 00 40 82 00 38 80 7E 00 48 81 23 00 04 38 09 FF FF 2F 80 00 00 90 03 00 04 40 9E 00 20 90 03 00 08 7C 00 04 AC 7D 20 18 28 7C 00 19 2D 40 A2 FF F8 2F 89 00 01 41 9D 00 70 41 92 FE 68 38 7F 00 08 38 80 00 00 4? ?? ?? ?? 39 7F 01 B0 80 0B 00 04 7F A3 EB 78 81 8B FF E4 7C 08 03 A6 83 4B FF E8 83 6B FF EC 7D 80 81 20 83 8B FF F0 83 AB FF F4 83 CB FF F8 83 EB FF FC 7D 61 5B 78 4E 80 00 20 3C 80 ?? ?? 38 7F 00 08 38 84 ?? ?? 7F C5 F3 78 4? ?? ?? ?? 4B FF FE D0 4? ?? ?? ?? 4B FF FF 0C 4? ?? ?? ?? 80 82 8B 68 38 00 00 DD 38 A0 00 01 60 84 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 41 92 FD E0 4B FF FF 78 }
	condition:
		$1
}

rule file_119_4_0 {
	meta:
		name = "_IO_vfwprintf"
		size = 19872
		refs = "0070 __errno_location 0084 _IO_fwide 0150 __wcschrnul 0162 _pthread_cleanup_push_defer 0172 _IO_funlockfile 026c _pthread_cleanup_pop_restore 0296 __printf_function_table 02a6 __printf_modifier_table 02b6 __printf_va_arg_table 0368 free 03da _GLOBAL_OFFSET_TABLE_ 03e2 _nl_current_LC_NUMERIC 0498 __parse_one_specwc 0514 memmove 05a0 memset 05f6 __printf_arginfo_table 06ea __no_long_double 08f0 __assert_fail 0914 __libc_fatal 0d6c __libc_alloca_cutoff 0d84 malloc 0e10 __lll_lock_wait_private 177c __woverflow 1978 _IO_wpadn 1eec _itowa 2032 _itowa_lower_digits 2162 _itowa_upper_digits 240c __wcslen 241c __readonly_area 24b0 __strnlen 2500 __mbsrtowcs 2690 strlen 26a8 __strerror_r 26dc __wcsnlen 2800 __printf_fp 2918 __printf_fphex 2a50 __btowc"
	strings:
		$1 = { 94 21 EE D0 7D 80 00 26 7C 08 02 A6 93 E1 11 2C 7C 3F 0B 78 90 01 11 34 93 01 11 10 93 21 11 14 7C B9 2B 78 93 41 11 18 7C 9A 23 78 93 61 11 1C 93 81 11 20 7C 7C 1B 78 93 C1 11 28 3B C0 FF FF 91 81 10 E4 91 C1 10 E8 91 E1 10 EC 92 01 10 F0 92 21 10 F4 92 41 10 F8 92 61 10 FC 92 81 11 00 92 A1 11 04 92 C1 11 08 92 E1 11 0C 93 A1 11 24 4? ?? ?? ?? 7C 7B 1B 78 38 80 00 01 83 1B 00 00 7F 83 E3 78 4? ?? ?? ?? 2F 83 00 01 41 9E 00 6C 39 7F 11 30 80 0B 00 04 7F C3 F3 78 81 8B FF B4 7C 08 03 A6 81 CB FF B8 81 EB FF BC 7D 81 81 20 82 0B FF C0 82 2B FF C4 82 4B FF C8 82 6B FF CC 82 8B FF D0 82 AB FF D4 82 CB FF D8 82 EB FF DC 83 0B FF E0 83 2B FF E4 83 4B FF E8 83 6B FF EC 83 8B FF F0 83 AB FF F4 83 CB FF F8 83 EB FF FC 7D 61 5B 78 4E 80 00 20 80 1C 00 00 70 05 00 08 40 82 02 88 2F 9A 00 00 41 9E 01 6C 7F 83 E3 78 38 80 00 01 4? ?? ?? ?? 2F 83 00 01 40 9E FF 74 83 DC 00 00 73 C6 00 02 40 82 02 48 81 79 00 00 7F 43 D3 78 81 39 00 04 38 80 00 25 80 19 00 08 3B A0 00 00 91 7F 00 24 91 3F 00 28 90 1F 00 2C 4? ?? ?? ?? 73 C7 80 00 7C 77 1B 78 40 82 00 74 3D 20 ?? ?? 38 09 ?? ?? 2F 80 00 00 40 9E 02 28 3D 20 ?? ?? 93 9F 00 34 38 09 ?? ?? 90 1F 00 30 80 7C 00 48 3B C2 8B 60 80 03 00 08 7F 80 F0 00 41 9E 00 34 39 60 00 01 39 20 00 00 7C 00 18 28 7C 00 48 00 40 82 00 0C 7D 60 19 2D 40 A2 FF F0 4C 00 01 2C 2F 80 00 00 40 9E 0C 58 80 7C 00 48 93 C3 00 08 81 23 00 04 38 09 00 01 90 03 00 04 81 3C 00 98 7F DA B8 50 7F DE 16 70 80 09 00 1C 7F 83 E3 78 7F 44 D3 78 7F C5 F3 78 7C 09 03 A6 4E 80 04 21 7F 9E 18 00 41 9E 00 88 3B C0 FF FF 80 1C 00 00 70 05 80 00 40 82 00 54 80 7C 00 48 81 23 00 04 38 09 FF FF 2F 80 00 00 90 03 00 04 40 9E 00 3C 90 03 00 08 7C 00 04 AC 7D 20 18 28 7C 00 19 2D 40 A2 FF F8 2F 89 00 01 40 BD 00 20 80 82 8B 68 38 00 00 DD 38 A0 00 01 60 84 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 2F 9D 00 00 41 9E FE 30 38 7F 00 30 38 80 00 00 4? ?? ?? ?? 4B FF FE 20 38 00 00 16 90 1B 00 00 4B FF FE 14 2F 9E 00 00 41 BC FF 78 80 17 00 00 2F 80 00 00 41 BE FF 70 3C A0 ?? ?? 80 05 ?? ?? 2F 80 00 00 40 9E 01 5C 3D 20 ?? ?? 80 09 ?? ?? 2F 80 00 00 40 9E 11 2C 3D 20 ?? ?? 80 09 ?? ?? 2F 80 00 00 40 9E 0B 2C 38 C0 00 00 38 E0 00 00 90 DF 10 94 7E F6 BB 78 90 FF 10 7C 39 E0 00 00 39 C0 FF FF 82 96 00 04 39 40 00 00 38 C0 00 00 91 5F 10 80 38 14 FF E0 2B 80 00 5A 90 DF 10 64 38 E0 00 00 39 00 00 00 90 FF 10 88 39 20 00 00 39 60 00 00 91 1F 10 84 38 A0 00 00 39 40 00 20 91 3F 10 70 3A D6 00 04 91 7F 10 9C 3A 20 00 00 3A 00 FF FF 90 BF 10 4C 90 DF 10 68 90 FF 10 58 91 1F 10 B0 91 3F 10 AC 91 5F 10 8C 40 9D 00 74 2F 94 00 00 40 9E 00 CC 80 1F 10 64 3B C0 FF FF 2F 80 00 00 41 9E FE A0 7C 03 03 78 4? ?? ?? ?? 4B FF FE 94 7F 83 E3 78 7F 44 D3 78 7F 25 CB 78 48 00 4A 25 7C 7E 1B 78 4B FF FD 0C 38 00 00 09 90 1B 00 00 4B FF FD 00 3C 80 ?? ?? 38 7F 00 30 38 84 ?? ?? 7F 85 E3 78 4? ?? ?? ?? 80 1C 00 00 3B A0 00 01 70 08 80 00 41 82 FD CC 4B FF FE 18 3D 20 ?? ?? 39 69 ?? ?? 7D 2B 02 14 88 09 00 78 3A BF 10 44 54 00 10 3A 7C 0B 00 2E 3D 20 ?? ?? 39 29 ?? ?? 81 49 ?? ?? 7D 4A 12 14 3D 20 ?? ?? 91 5F 10 50 39 29 ?? ?? 7C 09 03 A6 4E 80 04 20 38 00 00 00 38 A0 00 00 90 1F 10 94 38 C0 00 00 90 BF 10 64 39 E0 00 00 39 C0 FF FF 90 DF 10 7C 80 01 00 00 80 7F 10 64 94 01 F9 70 38 00 00 00 90 1F 00 08 4? ?? ?? ?? 2F 8E FF FF 3A 41 00 17 56 52 00 36 41 9E 07 C8 80 17 00 00 2F 80 00 00 41 9E 08 38 39 20 00 00 93 5F 10 48 38 00 00 20 93 3F 10 5C 7F 96 E3 78 7F 79 DB 78 3A 60 00 00 7F BB EB 78 3A A0 00 00 7D 3D 4B 78 7F DA F3 78 7E E9 BB 78 7C 1C 03 78 7F D2 EA 14 7D 23 4B 78 7E A4 AB 78 7F C5 F3 78 38 DF 00 08 4? ?? ?? ?? 81 3E 00 18 7E B5 1A 14 80 09 00 00 3A 73 00 01 2F 80 00 00 41 9E 00 7C 7F 9C 98 40 3B DD 00 34 40 9D 00 0C 7F DD F3 78 4B FF FF C0 57 8B 08 3C 81 41 00 00 38 0B 00 1E 54 00 00 36 7C 00 00 D0 7D 41 01 6E 7F 9C 5A 14 38 01 00 17 54 00 00 36 7D 40 5A 14 7F 92 50 00 41 9E 00 08 7D 7C 5B 78 3B DD 00 34 90 1F 10 D4 7E 44 93 78 7C 03 03 78 91 3F 10 D0 7F C5 F3 78 4? ?? ?? ?? 80 1F 10 D4 81 3F 10 D0 7F DD F3 78 7C 12 03 78 4B FF FF 5C 7F 7D DB 78 7F 5E D3 78 83 5F 10 48 7F 3B CB 78 83 3F 10 5C 7E DC B3 78 7D 36 4B 78 80 1F 00 08 7E A7 AB 78 7F 95 00 40 40 9C 00 08 7C 07 03 78 54 E5 10 3A 81 21 00 00 38 05 00 1E 54 00 00 36 7E A0 00 D0 80 1C 00 3C 7D 21 A9 6E 54 00 F7 FE 30 00 FF FF 7C 00 01 10 90 FF 10 DC 39 61 00 17 55 6B 00 36 54 04 07 EE 91 7F 10 D8 7D 63 5B 78 38 84 00 FF 4? ?? ?? ?? 80 FF 10 DC 81 21 00 00 2F 93 00 00 54 E0 20 36 81 7F 10 D8 20 00 FF F0 7D 21 01 6E 38 01 00 17 7D 21 A9 6E 54 05 00 36 39 81 00 17 90 BF 10 48 55 8C 00 36 90 BF 10 5C 41 9E 00 F8 39 20 00 00 91 FF 10 54 7E 55 93 78 92 5F 10 64 39 40 00 00 3D 00 ?? ?? 93 BF 10 50 7D 72 5B 78 7D 8F 63 78 90 FF 10 6C 7D 3D 4B 78 48 00 00 50 80 15 00 08 7E A3 AB 78 81 28 ?? ?? 80 D5 00 24 54 00 10 3A 7C 09 00 2E 54 C6 10 3A 91 1F 10 D0 7C B2 32 14 7C 09 03 A6 91 5F 10 D4 7C CF 32 14 4E 80 04 21 81 5F 10 D4 81 1F 10 D0 3B BD 00 01 7F 9D 98 00 3A B5 00 34 41 9E 00 64 80 15 00 20 2F 80 FF FF 41 9E 00 0C 54 00 10 3A 7D 52 01 2E 80 15 00 1C 2F 80 FF FF 41 9E 00 0C 54 00 10 3A 7D 52 01 2E 80 95 00 2C 2F 84 00 00 41 BE FF C0 2F 84 00 01 40 9E FF 7C 80 15 00 24 81 35 00 28 54 00 10 3A 7D 32 01 2E 80 15 00 24 81 35 00 30 54 00 10 3A 7D 2F 01 2E 4B FF FF 94 7E 4B 93 78 83 BF 10 50 7D EC 7B 78 80 FF 10 6C 82 5F 10 64 81 FF 10 54 2F 87 00 00 41 9E 03 38 3D 20 ?? ?? 93 3F 10 54 39 29 ?? ?? 81 09 ?? ?? 81 3F 10 48 7D 08 12 14 7F 59 D3 78 91 1F 10 48 7F 9A E3 78 3A A0 00 00 7F DC F3 78 39 40 00 00 7D 9E 63 78 48 00 00 50 2F 88 00 03 40 9C 00 0C 2F 88 00 01 40 9D 01 98 88 1F 00 24 2B 80 00 08 40 9C 00 98 54 08 10 3A 80 BF 00 2C 30 00 00 01 98 1F 00 24 7D 05 42 14 80 08 00 00 90 09 00 00 39 4A 00 01 7F 8A 38 00 3A B5 00 04 39 29 00 10 41 9E 04 98 7D 0B A8 2E 2F 88 00 05 40 BD FF AC 2F 88 01 00 41 9E 00 D4 41 9D 00 60 2F 88 00 07 40 9D 01 0C 71 00 08 00 40 A2 FF A0 3C C0 ?? ?? 80 A6 ?? ?? 2F 85 00 00 40 9E 05 3C 38 A0 00 00 38 C0 00 00 90 BF 10 C0 90 DF 10 C4 90 BF 10 C8 90 DF 10 CC C8 1F 10 C0 C8 3F 10 C8 D8 09 00 00 D8 29 00 08 4B FF FF 8C 81 1F 00 28 38 08 00 04 90 1F 00 28 4B FF FF 74 2F 88 02 00 41 BE FF 4C 2F 88 04 00 41 BE FF 44 2F 88 01 07 40 9E FF 98 80 BF 10 48 80 05 00 00 2F 80 00 00 40 9E 04 9C 89 1F 00 25 2B 88 00 07 40 9C 01 14 80 BF 00 2C 55 00 18 38 39 08 00 02 38 A5 00 20 99 1F 00 25 7C A5 02 14 80 C5 00 0C 80 65 00 00 80 85 00 04 80 A5 00 08 90 69 00 00 90 89 00 04 90 A9 00 08 90 C9 00 0C 4B FF FF 0C 88 1F 00 24 2B 80 00 06 54 08 07 FE 7C 00 42 14 54 00 06 3E 98 1F 00 24 41 9D 00 DC 54 08 10 3A 80 BF 00 2C 30 00 00 02 98 1F 00 24 7D 05 42 14 80 88 00 00 80 A8 00 04 90 89 00 00 90 A9 00 04 4B FF FE C8 89 1F 00 25 2B 88 00 08 40 9C 00 64 80 BF 00 2C 55 00 18 38 39 08 00 01 38 A5 00 20 99 1F 00 25 7C A5 02 14 C8 05 00 00 D8 09 00 00 4B FF FE 98 2F 88 00 00 40 9C FE 68 2F 88 FF FF 40 9E FE BC 80 1A 00 3C 70 05 00 04 40 82 00 3C 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 07 24 38 C6 ?? ?? 4? ?? ?? ?? 80 BF 00 28 38 A5 00 07 54 A5 00 38 38 05 00 08 90 1F 00 28 4B FF FF A4 3C 60 ?? ?? 38 63 ?? ?? 4? ?? ?? ?? 80 BF 00 28 38 C0 00 08 98 DF 00 25 38 A5 00 07 54 A5 00 38 38 05 00 10 90 1F 00 28 4B FF FE EC 81 1F 00 28 39 08 00 07 55 08 00 38 38 08 00 08 90 1F 00 28 4B FF FF 28 3C E0 ?? ?? 81 27 ?? ?? 7F 83 E3 78 7C 09 58 2E 7C 09 03 A6 4E 80 04 21 2F 83 FF FE 41 9E 02 E0 2F 83 00 00 41 BC F9 E0 3C 00 7F FF 60 00 FF FE 7F 9E 00 40 41 9D 0B 80 3C 00 7F FF 60 00 FF FF 7C 1E 00 50 7F 83 00 40 41 BD F9 BC 7F C3 F2 14 80 7F 10 64 4? ?? ?? ?? 2F 9E 00 00 41 9C 0B 38 1E AF 00 34 81 3C 00 98 7E B2 AA 14 80 09 00 1C 80 95 00 14 7F 83 E3 78 80 B5 00 18 7C 09 03 A6 7C A4 28 50 7C A5 16 70 4E 80 04 21 81 35 00 18 80 15 00 14 7C 00 48 50 7C 00 16 70 7F 83 00 00 40 9E F8 0C 3C 00 7F FF 60 00 FF FF 7C 1E 00 50 7F 83 00 40 41 BD F7 F8 7F DE 1A 14 39 EF 00 01 7F 93 78 40 40 BD F7 EC 1D 2F 00 34 7C 92 4A 14 7D 32 48 2E 81 64 00 20 80 04 00 0C 2F 8B FF FF 91 3F 10 54 54 07 2F FE 54 08 37 FE 90 FF 10 74 54 06 27 FE 54 05 47 FE 91 1F 10 A0 54 07 17 FE 54 08 57 FE 90 DF 10 98 54 0A 3F FE 54 06 0F FE 90 BF 10 B4 90 FF 10 90 91 1F 10 A8 80 A4 00 04 88 E4 00 13 81 04 00 08 91 5F 10 78 54 0A 1F FE 90 DF 10 60 54 06 67 FE 91 5F 10 B8 90 BF 10 48 90 DF 10 BC 90 FF 10 A4 91 1F 10 6C 41 9E 00 24 81 5F 10 5C 55 69 20 36 7D 6A 48 2E 2F 8B 00 00 91 64 00 04 41 9C 03 14 80 A4 00 04 90 BF 10 48 80 04 00 1C 2F 80 FF FF 41 9E 00 24 80 DF 10 5C 54 00 20 36 7C 06 00 2E 2F 80 00 00 90 04 00 00 41 9C 02 DC 80 E4 00 00 90 FF 10 54 81 1F 10 54 81 3F 10 48 7F 88 48 00 7D 09 43 78 40 9C 00 08 81 3F 10 48 2F 89 03 C8 39 40 00 00 3A BF 10 44 91 5F 10 64 40 9D 00 5C 3A A9 00 20 56 B5 10 3A 2B 95 80 00 41 9D 02 40 81 7F 10 48 3A B5 00 1E 80 BF 10 54 56 A0 00 36 81 21 00 00 7C 00 00 D0 7F 8B 28 00 7D 21 01 6E 3A AB 00 20 56 B5 10 3A 38 01 00 17 54 00 00 36 40 9C 00 0C 3A A5 00 20 56 B5 10 3A 38 C0 00 00 90 DF 10 64 7E A0 AA 14 81 1F 10 6C 2F 88 00 FF 41 9D 00 D4 3D 40 ?? ?? 81 2A ?? ?? 2F 89 00 00 41 9E 00 C4 55 0B 10 3A 7C 09 58 2E 2F 80 00 00 41 9E 00 B4 81 44 00 2C 81 21 00 00 55 40 10 3A 30 00 00 1E 54 00 00 36 7C 00 00 D0 39 4A 00 01 7D 21 01 6E 7D 49 03 A6 39 20 00 00 38 01 00 17 54 05 00 36 42 40 FD 84 81 44 00 24 55 20 10 3A 80 DF 10 5C 7D 49 52 14 55 4A 20 36 7D 46 52 14 7D 45 01 2E 39 29 00 01 4B FF FF DC 7F 9E E3 78 7F 5C D3 78 7F 3A CB 78 83 3F 10 54 4B FF FE 0C 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 81 29 00 00 81 29 00 00 81 C9 00 2C 81 29 00 34 91 3F 10 7C 88 0E 00 00 30 00 FF FF 54 00 06 3E 20 00 00 FD 7C 00 01 10 7C 00 03 B8 7D CE 00 38 4B FF F7 FC 80 BF 10 6C 3D 20 ?? ?? 38 09 ?? ?? 39 65 FF E0 2B 8B 00 5A 41 BD F7 78 3D 20 ?? ?? 38 09 ?? ?? 7D 20 5A 14 89 29 00 78 55 29 10 3A 7D 20 4A 14 80 09 03 2C 4B FF F7 58 7E F6 BB 78 3A A0 00 00 3A 60 00 00 4B FF F8 B8 89 1F 00 25 2B 88 00 08 40 9C 00 B0 80 BF 00 2C 55 00 18 38 39 08 00 01 38 A5 00 20 99 1F 00 25 7C A5 02 14 C8 05 00 00 D8 09 00 00 7C 0B A8 2E 54 00 06 2C 7C 0B A9 2E 4B FF FA 80 38 08 FF F8 54 00 10 3A 7C 05 00 2E 2F 80 00 00 41 BE FA B8 7C 1E A8 2E 38 9F 00 24 81 01 00 00 30 00 00 1E 54 00 00 36 7C 00 00 D0 7D 01 01 6E 38 61 00 17 54 63 00 36 90 69 00 00 7C 0B A8 2E 81 06 ?? ?? 30 00 FF F8 54 00 10 3A 7C 08 00 2E 90 FF 10 DC 7C 09 03 A6 91 3F 10 D0 91 5F 10 D4 91 7F 10 D8 4E 80 04 21 80 FF 10 DC 81 3F 10 D0 81 5F 10 D4 81 7F 10 D8 4B FF FA 04 80 BF 00 28 38 A5 00 07 54 A5 00 38 38 05 00 08 90 1F 00 28 4B FF FF 58 7E A3 AB 78 90 9F 10 D0 4? ?? ?? ?? 2F 83 00 00 80 9F 10 D0 40 9E FD B0 7E A3 AB 78 90 9F 10 D0 4? ?? ?? ?? 80 DF 10 54 80 BF 10 48 3A A6 00 20 90 7F 10 64 7F 85 30 00 56 B5 10 3A 80 9F 10 D0 41 9C 00 10 80 FF 10 48 3A A7 00 20 56 B5 10 3A 7E A3 AA 14 4B FF FD B8 38 00 FF FF 90 04 00 00 4B FF FD 20 7C 09 03 78 7D 6B 00 D0 38 00 00 01 91 64 00 04 50 09 D1 4A 39 60 00 01 91 7F 10 A0 91 24 00 0C 4B FF FC D0 39 40 00 00 39 60 00 00 91 5F 10 94 38 00 00 00 39 E0 00 00 91 7F 10 64 39 C0 FF FF 90 1F 10 7C 4B FF F6 10 4? ?? ?? ?? 4B FF F3 A8 81 1F 10 70 2F 88 00 00 40 9E 00 0C 39 40 00 30 91 5F 10 8C 86 96 00 04 38 14 FF E0 2B 80 00 5A 41 BD F5 14 7C 09 02 14 7C 0B 03 78 88 0B 00 78 54 00 10 3A 7C 09 00 2E 7C 09 03 A6 4E 80 04 20 2F 8E FF FF 41 9E 01 E0 86 96 00 04 38 14 FF E0 2B 80 00 5A 41 9D 01 C4 7C 09 02 14 7C 06 03 78 88 06 00 78 38 E0 00 01 90 FF 10 9C 54 00 10 3A 7C 09 00 2E 7C 09 03 A6 4E 80 04 20 86 96 00 04 38 14 FF E0 2B 80 00 5A 41 9D 01 70 7C 09 02 14 7C 08 03 78 88 08 00 78 39 40 00 01 91 5F 10 AC 54 00 10 3A 7C 09 00 2E 7C 09 03 A6 4E 80 04 20 85 76 00 04 39 6B FF D0 2B 8B 00 09 7E C8 B3 78 40 9D 01 18 89 79 00 00 2B 8B 00 08 40 9C 00 BC 39 4B 00 01 81 19 00 08 55 60 10 3A 99 59 00 00 7D 68 02 14 82 2B 00 00 2F 91 00 00 40 BC 00 18 39 60 00 20 38 00 00 01 91 7F 10 8C 7E 31 00 D0 90 1F 10 70 3C A0 3F FF 60 A5 FF DE 7F 91 28 40 41 9D 00 6C 2B 91 03 C7 40 9D 00 34 38 11 00 20 54 14 10 3A 2B 94 80 00 41 9D 00 70 38 14 00 1E 81 61 00 00 54 00 00 36 7C 00 00 D0 7D 61 01 6E 3A A1 00 17 56 B5 00 36 7E B5 A2 14 82 96 00 00 38 14 FF E0 2B 80 00 5A 41 BD F3 DC 7C 09 02 14 7C 07 03 78 89 67 00 78 55 6B 10 3A 7D 69 5A 14 80 0B 00 D4 7C 09 03 A6 4E 80 04 20 38 00 00 22 90 1B 00 00 4B FF F3 B8 81 79 00 04 38 0B 00 04 90 19 00 04 4B FF FF 50 7E 83 A3 78 91 3F 10 D0 4? ?? ?? ?? 2F 83 00 00 81 3F 10 D0 40 9E FF 80 7E 83 A3 78 91 3F 10 D0 4? ?? ?? ?? 7C 68 1B 79 81 3F 10 D0 91 1F 10 64 41 A2 F2 1C 80 DF 10 64 7E A6 A2 14 4B FF FF 78 85 48 00 04 38 0A FF D0 2B 80 00 09 41 9D 00 20 }
	condition:
		$1
}

rule file_120_0_0 {
	meta:
		name = "__sched_setparam"
		size = 16
		refs = "000c __syscall_error"
	strings:
		$1 = { 38 00 00 9A 44 00 00 02 4C A3 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_121_0_0 {
	meta:
		name = "__vswscanf"
		size = 156
		refs = "000a _IO_wstr_jumps 0048 _IO_no_init 0054 _IO_fwide 0068 _IO_wstr_init_static 007c _IO_vfwscanf"
	strings:
		$1 = { 94 21 FE 70 7C 08 02 A6 3C E0 ?? ?? 93 C1 01 88 7C 9E 23 78 38 80 00 00 38 C1 00 B0 90 01 01 94 38 E7 ?? ?? 38 00 00 00 93 A1 01 84 60 84 80 00 93 E1 01 8C 7C 7D 1B 78 7C BF 2B 78 38 61 00 08 90 01 00 50 38 A0 00 00 4? ?? ?? ?? 38 61 00 08 38 80 00 01 4? ?? ?? ?? 38 61 00 08 7F A4 EB 78 38 C0 00 00 38 A0 00 00 4? ?? ?? ?? 38 61 00 08 7F C4 F3 78 7F E5 FB 78 38 C0 00 00 4? ?? ?? ?? 80 01 01 94 83 A1 01 84 7C 08 03 A6 83 C1 01 88 83 E1 01 8C 38 21 01 90 4E 80 00 20 }
	condition:
		$1
}

rule file_122_0_0 {
	meta:
		name = "insque"
		size = 52
	strings:
		$1 = { 2C 04 00 00 41 82 00 24 81 24 00 00 90 64 00 00 2F 89 00 00 41 9E 00 08 90 69 00 04 91 23 00 00 90 83 00 04 4E 80 00 20 90 83 00 00 90 83 00 04 4E 80 00 20 }
	condition:
		$1
}

rule file_122_1_0 {
	meta:
		name = "remque"
		size = 36
	strings:
		$1 = { 81 63 00 00 81 23 00 04 2F 8B 00 00 41 9E 00 08 91 2B 00 04 2F 89 00 00 4D 9E 00 20 91 69 00 00 4E 80 00 20 }
	condition:
		$1
}

rule file_123_0_0 {
	meta:
		name = "strcat"
		size = 64
		refs = "0018 strlen 0024 strcpy"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 93 E1 00 1C 7C 7F 1B 78 90 01 00 24 90 81 00 08 4? ?? ?? ?? 7C 7F 1A 14 80 81 00 08 4? ?? ?? ?? 80 01 00 24 7F E3 FB 78 83 E1 00 1C 7C 08 03 A6 38 21 00 20 4E 80 00 20 }
	condition:
		$1
}

rule file_124_0_0 {
	meta:
		name = "__libc_tcdrain"
		size = 212
		refs = "005c __libc_enable_asynccancel 0090 __libc_disable_asynccancel 009e _GLOBAL_OFFSET_TABLE_ 00a6 __libc_errno"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 93 C1 00 08 7C 7E 1B 78 90 01 00 14 93 E1 00 0C 80 02 8B 60 2F 80 00 00 40 9E 00 3C 3C 80 20 00 38 00 00 36 60 84 74 1D 38 A0 00 01 44 00 00 02 7C 00 00 26 74 09 10 00 40 82 00 5C 80 01 00 14 83 C1 00 08 7C 08 03 A6 83 E1 00 0C 38 21 00 10 4E 80 00 20 4? ?? ?? ?? 3C 80 20 00 7C 7F 1B 78 38 00 00 36 7F C3 F3 78 60 84 74 1D 38 A0 00 01 44 00 00 02 7C 00 00 26 74 09 10 00 7C 7E 1B 78 40 82 00 30 7F E3 FB 78 4? ?? ?? ?? 7F C3 F3 78 4B FF FF AC 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 90 69 00 00 38 60 FF FF 4B FF FF 90 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 90 69 00 00 3B C0 FF FF 4B FF FF BC }
	condition:
		$1
}

rule file_72_0_3 {
	meta:
		name = "__libc_tcdrain"
		size = 212
		refs = "005c __pthread_enable_asynccancel 0090 __pthread_disable_asynccancel 009e _GLOBAL_OFFSET_TABLE_ 00a6 errno"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 93 C1 00 08 7C 7E 1B 78 90 01 00 14 93 E1 00 0C 80 02 8B 60 2F 80 00 00 40 9E 00 3C 3C 80 20 00 38 00 00 36 60 84 74 1D 38 A0 00 01 44 00 00 02 7C 00 00 26 74 09 10 00 40 82 00 5C 80 01 00 14 83 C1 00 08 7C 08 03 A6 83 E1 00 0C 38 21 00 10 4E 80 00 20 4? ?? ?? ?? 3C 80 20 00 7C 7F 1B 78 38 00 00 36 7F C3 F3 78 60 84 74 1D 38 A0 00 01 44 00 00 02 7C 00 00 26 74 09 10 00 7C 7E 1B 78 40 82 00 30 7F E3 FB 78 4? ?? ?? ?? 7F C3 F3 78 4B FF FF AC 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 90 69 00 00 38 60 FF FF 4B FF FF 90 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 90 69 00 00 3B C0 FF FF 4B FF FF BC }
	condition:
		$1
}

rule file_125_0_0 {
	meta:
		name = "__sched_rr_get_interval"
		size = 16
		refs = "000c __syscall_error"
	strings:
		$1 = { 38 00 00 A1 44 00 00 02 4C A3 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_126_0_0 {
	meta:
		name = "fileno"
		size = 56
		refs = "001a _GLOBAL_OFFSET_TABLE_ 0022 __libc_errno"
	strings:
		$1 = { 80 03 00 00 70 09 20 00 41 82 00 10 80 63 00 38 2F 83 00 00 4C BC 00 20 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 38 00 00 09 90 09 00 00 38 60 FF FF 4E 80 00 20 }
	condition:
		$1
}

rule file_127_0_0 {
	meta:
		name = "__default_morecore"
		size = 60
		refs = "000c __sbrk"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 4? ?? ?? ?? 2F 83 FF FF 41 9E 00 14 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 80 01 00 14 38 60 00 00 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_128_0_0 {
	meta:
		name = "setsgent"
		size = 260
		refs = "0052 __nss_gshadow_lookup2 0056 _GLOBAL_OFFSET_TABLE_ 007c __nss_setent 0082 __libc_errno 00d8 __lll_lock_wait_private"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 39 60 00 01 93 81 00 10 3F 80 ?? ?? 39 20 00 00 93 A1 00 14 3B BC ?? ?? 90 01 00 24 93 C1 00 18 93 E1 00 1C 7C 00 E8 28 7C 00 48 00 40 82 00 0C 7D 60 E9 2D 40 A2 FF F0 4C 00 01 2C 2F 80 00 00 40 9E 00 8C 3C 60 ?? ?? 3C 80 ?? ?? 3F E0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 BD 00 04 38 DD 00 08 38 FD 00 0C 39 00 00 00 39 20 00 00 39 40 00 00 3B FF ?? ?? 4? ?? ?? ?? 81 3F ?? ?? 7D 29 12 14 83 C9 00 00 38 00 00 00 7C 00 04 AC 7D 20 E8 28 7C 00 E9 2D 40 A2 FF F8 2F 89 00 01 41 9D 00 3C 80 01 00 24 83 FF ?? ?? 7F FF 12 14 83 81 00 10 7C 08 03 A6 93 DF 00 00 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 7F A3 EB 78 4? ?? ?? ?? 4B FF FF 70 80 82 8B 68 38 00 00 DD 7F A3 EB 78 60 84 00 01 38 A0 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF A8 }
	condition:
		$1
}

rule file_1055_0_0 {
	meta:
		name = "setaliasent"
		size = 260
		refs = "0052 __nss_aliases_lookup2 0056 _GLOBAL_OFFSET_TABLE_ 007c __nss_setent 0082 __libc_errno 00d8 __lll_lock_wait_private"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 39 60 00 01 93 81 00 10 3F 80 ?? ?? 39 20 00 00 93 A1 00 14 3B BC ?? ?? 90 01 00 24 93 C1 00 18 93 E1 00 1C 7C 00 E8 28 7C 00 48 00 40 82 00 0C 7D 60 E9 2D 40 A2 FF F0 4C 00 01 2C 2F 80 00 00 40 9E 00 8C 3C 60 ?? ?? 3C 80 ?? ?? 3F E0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 BD 00 04 38 DD 00 08 38 FD 00 0C 39 00 00 00 39 20 00 00 39 40 00 00 3B FF ?? ?? 4? ?? ?? ?? 81 3F ?? ?? 7D 29 12 14 83 C9 00 00 38 00 00 00 7C 00 04 AC 7D 20 E8 28 7C 00 E9 2D 40 A2 FF F8 2F 89 00 01 41 9D 00 3C 80 01 00 24 83 FF ?? ?? 7F FF 12 14 83 81 00 10 7C 08 03 A6 93 DF 00 00 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 7F A3 EB 78 4? ?? ?? ?? 4B FF FF 70 80 82 8B 68 38 00 00 DD 7F A3 EB 78 60 84 00 01 38 A0 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF A8 }
	condition:
		$1
}

rule file_1105_0_0 {
	meta:
		name = "setgrent"
		size = 260
		refs = "0052 __nss_group_lookup2 0056 _GLOBAL_OFFSET_TABLE_ 007c __nss_setent 0082 __libc_errno 00d8 __lll_lock_wait_private"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 39 60 00 01 93 81 00 10 3F 80 ?? ?? 39 20 00 00 93 A1 00 14 3B BC ?? ?? 90 01 00 24 93 C1 00 18 93 E1 00 1C 7C 00 E8 28 7C 00 48 00 40 82 00 0C 7D 60 E9 2D 40 A2 FF F0 4C 00 01 2C 2F 80 00 00 40 9E 00 8C 3C 60 ?? ?? 3C 80 ?? ?? 3F E0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 BD 00 04 38 DD 00 08 38 FD 00 0C 39 00 00 00 39 20 00 00 39 40 00 00 3B FF ?? ?? 4? ?? ?? ?? 81 3F ?? ?? 7D 29 12 14 83 C9 00 00 38 00 00 00 7C 00 04 AC 7D 20 E8 28 7C 00 E9 2D 40 A2 FF F8 2F 89 00 01 41 9D 00 3C 80 01 00 24 83 FF ?? ?? 7F FF 12 14 83 81 00 10 7C 08 03 A6 93 DF 00 00 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 7F A3 EB 78 4? ?? ?? ?? 4B FF FF 70 80 82 8B 68 38 00 00 DD 7F A3 EB 78 60 84 00 01 38 A0 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF A8 }
	condition:
		$1
}

rule file_719_0_0 {
	meta:
		name = "setpwent"
		size = 260
		refs = "0052 __nss_passwd_lookup2 0056 _GLOBAL_OFFSET_TABLE_ 007c __nss_setent 0082 __libc_errno 00d8 __lll_lock_wait_private"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 39 60 00 01 93 81 00 10 3F 80 ?? ?? 39 20 00 00 93 A1 00 14 3B BC ?? ?? 90 01 00 24 93 C1 00 18 93 E1 00 1C 7C 00 E8 28 7C 00 48 00 40 82 00 0C 7D 60 E9 2D 40 A2 FF F0 4C 00 01 2C 2F 80 00 00 40 9E 00 8C 3C 60 ?? ?? 3C 80 ?? ?? 3F E0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 BD 00 04 38 DD 00 08 38 FD 00 0C 39 00 00 00 39 20 00 00 39 40 00 00 3B FF ?? ?? 4? ?? ?? ?? 81 3F ?? ?? 7D 29 12 14 83 C9 00 00 38 00 00 00 7C 00 04 AC 7D 20 E8 28 7C 00 E9 2D 40 A2 FF F8 2F 89 00 01 41 9D 00 3C 80 01 00 24 83 FF ?? ?? 7F FF 12 14 83 81 00 10 7C 08 03 A6 93 DF 00 00 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 7F A3 EB 78 4? ?? ?? ?? 4B FF FF 70 80 82 8B 68 38 00 00 DD 7F A3 EB 78 60 84 00 01 38 A0 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF A8 }
	condition:
		$1
}

rule file_531_0_0 {
	meta:
		name = "setspent"
		size = 260
		refs = "0052 __nss_shadow_lookup2 0056 _GLOBAL_OFFSET_TABLE_ 007c __nss_setent 0082 __libc_errno 00d8 __lll_lock_wait_private"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 39 60 00 01 93 81 00 10 3F 80 ?? ?? 39 20 00 00 93 A1 00 14 3B BC ?? ?? 90 01 00 24 93 C1 00 18 93 E1 00 1C 7C 00 E8 28 7C 00 48 00 40 82 00 0C 7D 60 E9 2D 40 A2 FF F0 4C 00 01 2C 2F 80 00 00 40 9E 00 8C 3C 60 ?? ?? 3C 80 ?? ?? 3F E0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 BD 00 04 38 DD 00 08 38 FD 00 0C 39 00 00 00 39 20 00 00 39 40 00 00 3B FF ?? ?? 4? ?? ?? ?? 81 3F ?? ?? 7D 29 12 14 83 C9 00 00 38 00 00 00 7C 00 04 AC 7D 20 E8 28 7C 00 E9 2D 40 A2 FF F8 2F 89 00 01 41 9D 00 3C 80 01 00 24 83 FF ?? ?? 7F FF 12 14 83 81 00 10 7C 08 03 A6 93 DF 00 00 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 7F A3 EB 78 4? ?? ?? ?? 4B FF FF 70 80 82 8B 68 38 00 00 DD 7F A3 EB 78 60 84 00 01 38 A0 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF A8 }
	condition:
		$1
}

rule file_128_1_0 {
	meta:
		name = "endsgent"
		size = 264
		refs = "005e __nss_gshadow_lookup2 0062 _GLOBAL_OFFSET_TABLE_ 0080 __nss_endent 0086 __libc_errno 00dc __lll_lock_wait_private"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 93 81 00 10 3F 80 ?? ?? 93 A1 00 14 3B BC ?? ?? 90 01 00 24 80 1D 00 08 93 C1 00 18 2F 80 00 00 93 E1 00 1C 41 9E 00 8C 39 60 00 01 39 20 00 00 7C 00 E8 28 7C 00 48 00 40 82 00 0C 7D 60 E9 2D 40 A2 FF F0 4C 00 01 2C 2F 80 00 00 40 9E 00 84 3C 60 ?? ?? 3C 80 ?? ?? 3F E0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 BD 00 04 38 DD 00 08 38 FD 00 0C 39 00 00 00 3B FF ?? ?? 4? ?? ?? ?? 81 3F ?? ?? 7D 29 12 14 83 C9 00 00 38 00 00 00 7C 00 04 AC 7D 20 E8 28 7C 00 E9 2D 40 A2 FF F8 2F 89 00 01 41 9D 00 3C 83 FF ?? ?? 7F FF 12 14 93 DF 00 00 80 01 00 24 83 81 00 10 7C 08 03 A6 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 7F A3 EB 78 4? ?? ?? ?? 4B FF FF 78 80 82 8B 68 38 00 00 DD 7F A3 EB 78 60 84 00 01 38 A0 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF A8 }
	condition:
		$1
}

rule file_1055_1_0 {
	meta:
		name = "endaliasent"
		size = 264
		refs = "005e __nss_aliases_lookup2 0062 _GLOBAL_OFFSET_TABLE_ 0080 __nss_endent 0086 __libc_errno 00dc __lll_lock_wait_private"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 93 81 00 10 3F 80 ?? ?? 93 A1 00 14 3B BC ?? ?? 90 01 00 24 80 1D 00 08 93 C1 00 18 2F 80 00 00 93 E1 00 1C 41 9E 00 8C 39 60 00 01 39 20 00 00 7C 00 E8 28 7C 00 48 00 40 82 00 0C 7D 60 E9 2D 40 A2 FF F0 4C 00 01 2C 2F 80 00 00 40 9E 00 84 3C 60 ?? ?? 3C 80 ?? ?? 3F E0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 BD 00 04 38 DD 00 08 38 FD 00 0C 39 00 00 00 3B FF ?? ?? 4? ?? ?? ?? 81 3F ?? ?? 7D 29 12 14 83 C9 00 00 38 00 00 00 7C 00 04 AC 7D 20 E8 28 7C 00 E9 2D 40 A2 FF F8 2F 89 00 01 41 9D 00 3C 83 FF ?? ?? 7F FF 12 14 93 DF 00 00 80 01 00 24 83 81 00 10 7C 08 03 A6 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 7F A3 EB 78 4? ?? ?? ?? 4B FF FF 78 80 82 8B 68 38 00 00 DD 7F A3 EB 78 60 84 00 01 38 A0 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF A8 }
	condition:
		$1
}

rule file_1105_1_0 {
	meta:
		name = "endgrent"
		size = 264
		refs = "005e __nss_group_lookup2 0062 _GLOBAL_OFFSET_TABLE_ 0080 __nss_endent 0086 __libc_errno 00dc __lll_lock_wait_private"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 93 81 00 10 3F 80 ?? ?? 93 A1 00 14 3B BC ?? ?? 90 01 00 24 80 1D 00 08 93 C1 00 18 2F 80 00 00 93 E1 00 1C 41 9E 00 8C 39 60 00 01 39 20 00 00 7C 00 E8 28 7C 00 48 00 40 82 00 0C 7D 60 E9 2D 40 A2 FF F0 4C 00 01 2C 2F 80 00 00 40 9E 00 84 3C 60 ?? ?? 3C 80 ?? ?? 3F E0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 BD 00 04 38 DD 00 08 38 FD 00 0C 39 00 00 00 3B FF ?? ?? 4? ?? ?? ?? 81 3F ?? ?? 7D 29 12 14 83 C9 00 00 38 00 00 00 7C 00 04 AC 7D 20 E8 28 7C 00 E9 2D 40 A2 FF F8 2F 89 00 01 41 9D 00 3C 83 FF ?? ?? 7F FF 12 14 93 DF 00 00 80 01 00 24 83 81 00 10 7C 08 03 A6 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 7F A3 EB 78 4? ?? ?? ?? 4B FF FF 78 80 82 8B 68 38 00 00 DD 7F A3 EB 78 60 84 00 01 38 A0 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF A8 }
	condition:
		$1
}

rule file_719_1_0 {
	meta:
		name = "endpwent"
		size = 264
		refs = "005e __nss_passwd_lookup2 0062 _GLOBAL_OFFSET_TABLE_ 0080 __nss_endent 0086 __libc_errno 00dc __lll_lock_wait_private"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 93 81 00 10 3F 80 ?? ?? 93 A1 00 14 3B BC ?? ?? 90 01 00 24 80 1D 00 08 93 C1 00 18 2F 80 00 00 93 E1 00 1C 41 9E 00 8C 39 60 00 01 39 20 00 00 7C 00 E8 28 7C 00 48 00 40 82 00 0C 7D 60 E9 2D 40 A2 FF F0 4C 00 01 2C 2F 80 00 00 40 9E 00 84 3C 60 ?? ?? 3C 80 ?? ?? 3F E0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 BD 00 04 38 DD 00 08 38 FD 00 0C 39 00 00 00 3B FF ?? ?? 4? ?? ?? ?? 81 3F ?? ?? 7D 29 12 14 83 C9 00 00 38 00 00 00 7C 00 04 AC 7D 20 E8 28 7C 00 E9 2D 40 A2 FF F8 2F 89 00 01 41 9D 00 3C 83 FF ?? ?? 7F FF 12 14 93 DF 00 00 80 01 00 24 83 81 00 10 7C 08 03 A6 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 7F A3 EB 78 4? ?? ?? ?? 4B FF FF 78 80 82 8B 68 38 00 00 DD 7F A3 EB 78 60 84 00 01 38 A0 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF A8 }
	condition:
		$1
}

rule file_531_1_0 {
	meta:
		name = "endspent"
		size = 264
		refs = "005e __nss_shadow_lookup2 0062 _GLOBAL_OFFSET_TABLE_ 0080 __nss_endent 0086 __libc_errno 00dc __lll_lock_wait_private"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 93 81 00 10 3F 80 ?? ?? 93 A1 00 14 3B BC ?? ?? 90 01 00 24 80 1D 00 08 93 C1 00 18 2F 80 00 00 93 E1 00 1C 41 9E 00 8C 39 60 00 01 39 20 00 00 7C 00 E8 28 7C 00 48 00 40 82 00 0C 7D 60 E9 2D 40 A2 FF F0 4C 00 01 2C 2F 80 00 00 40 9E 00 84 3C 60 ?? ?? 3C 80 ?? ?? 3F E0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 BD 00 04 38 DD 00 08 38 FD 00 0C 39 00 00 00 3B FF ?? ?? 4? ?? ?? ?? 81 3F ?? ?? 7D 29 12 14 83 C9 00 00 38 00 00 00 7C 00 04 AC 7D 20 E8 28 7C 00 E9 2D 40 A2 FF F8 2F 89 00 01 41 9D 00 3C 83 FF ?? ?? 7F FF 12 14 93 DF 00 00 80 01 00 24 83 81 00 10 7C 08 03 A6 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 7F A3 EB 78 4? ?? ?? ?? 4B FF FF 78 80 82 8B 68 38 00 00 DD 7F A3 EB 78 60 84 00 01 38 A0 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF A8 }
	condition:
		$1
}

rule file_128_2_0 {
	meta:
		name = "__getsgent_r"
		size = 332
		refs = "0076 __nss_gshadow_lookup2 007e _GLOBAL_OFFSET_TABLE_ 00b4 __nss_getent_r 00ba __libc_errno 0120 __lll_lock_wait_private"
	strings:
		$1 = { 94 21 FF C0 7C 08 02 A6 39 60 00 01 93 61 00 2C 3F 60 ?? ?? 39 20 00 00 93 21 00 24 7C 79 1B 78 93 81 00 30 3B 9B ?? ?? 93 A1 00 34 7C 9D 23 78 93 C1 00 38 7C BE 2B 78 93 E1 00 3C 7C DF 33 78 90 01 00 44 93 41 00 28 7C 00 E0 28 7C 00 48 00 40 82 00 0C 7D 60 E1 2D 40 A2 FF F0 4C 00 01 2C 2F 80 00 00 40 9E 00 B8 93 E1 00 14 3C 60 ?? ?? 3C 80 ?? ?? 3C A0 ?? ?? 93 A1 00 0C 3F E0 ?? ?? 3B 40 00 00 93 C1 00 10 38 84 ?? ?? 38 A5 ?? ?? 93 21 00 08 38 DC 00 04 38 FC 00 08 93 41 00 18 39 1C 00 0C 39 20 00 00 39 40 00 00 3B FF ?? ?? 38 63 ?? ?? 4? ?? ?? ?? 81 3F ?? ?? 7D 29 12 14 7C 7E 1B 78 83 A9 00 00 7C 00 04 AC 7C 00 E0 28 7F 40 E1 2D 40 A2 FF F8 2F 80 00 01 41 9D 00 4C 80 01 00 44 83 FF ?? ?? 7F FF 12 14 83 21 00 24 7C 08 03 A6 93 BF 00 00 7F C3 F3 78 83 41 00 28 83 61 00 2C 83 81 00 30 83 A1 00 34 83 C1 00 38 83 E1 00 3C 38 21 00 40 4E 80 00 20 7F 83 E3 78 4? ?? ?? ?? 4B FF FF 44 80 82 8B 68 38 00 00 DD 7F 83 E3 78 60 84 00 01 38 A0 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF 98 }
	condition:
		$1
}

rule file_1055_2_0 {
	meta:
		name = "__getaliasent_r"
		size = 332
		refs = "0076 __nss_aliases_lookup2 007e _GLOBAL_OFFSET_TABLE_ 00b4 __nss_getent_r 00ba __libc_errno 0120 __lll_lock_wait_private"
	strings:
		$1 = { 94 21 FF C0 7C 08 02 A6 39 60 00 01 93 61 00 2C 3F 60 ?? ?? 39 20 00 00 93 21 00 24 7C 79 1B 78 93 81 00 30 3B 9B ?? ?? 93 A1 00 34 7C 9D 23 78 93 C1 00 38 7C BE 2B 78 93 E1 00 3C 7C DF 33 78 90 01 00 44 93 41 00 28 7C 00 E0 28 7C 00 48 00 40 82 00 0C 7D 60 E1 2D 40 A2 FF F0 4C 00 01 2C 2F 80 00 00 40 9E 00 B8 93 E1 00 14 3C 60 ?? ?? 3C 80 ?? ?? 3C A0 ?? ?? 93 A1 00 0C 3F E0 ?? ?? 3B 40 00 00 93 C1 00 10 38 84 ?? ?? 38 A5 ?? ?? 93 21 00 08 38 DC 00 04 38 FC 00 08 93 41 00 18 39 1C 00 0C 39 20 00 00 39 40 00 00 3B FF ?? ?? 38 63 ?? ?? 4? ?? ?? ?? 81 3F ?? ?? 7D 29 12 14 7C 7E 1B 78 83 A9 00 00 7C 00 04 AC 7C 00 E0 28 7F 40 E1 2D 40 A2 FF F8 2F 80 00 01 41 9D 00 4C 80 01 00 44 83 FF ?? ?? 7F FF 12 14 83 21 00 24 7C 08 03 A6 93 BF 00 00 7F C3 F3 78 83 41 00 28 83 61 00 2C 83 81 00 30 83 A1 00 34 83 C1 00 38 83 E1 00 3C 38 21 00 40 4E 80 00 20 7F 83 E3 78 4? ?? ?? ?? 4B FF FF 44 80 82 8B 68 38 00 00 DD 7F 83 E3 78 60 84 00 01 38 A0 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF 98 }
	condition:
		$1
}

rule file_1105_2_0 {
	meta:
		name = "__getgrent_r"
		size = 332
		refs = "0076 __nss_group_lookup2 007e _GLOBAL_OFFSET_TABLE_ 00b4 __nss_getent_r 00ba __libc_errno 0120 __lll_lock_wait_private"
	strings:
		$1 = { 94 21 FF C0 7C 08 02 A6 39 60 00 01 93 61 00 2C 3F 60 ?? ?? 39 20 00 00 93 21 00 24 7C 79 1B 78 93 81 00 30 3B 9B ?? ?? 93 A1 00 34 7C 9D 23 78 93 C1 00 38 7C BE 2B 78 93 E1 00 3C 7C DF 33 78 90 01 00 44 93 41 00 28 7C 00 E0 28 7C 00 48 00 40 82 00 0C 7D 60 E1 2D 40 A2 FF F0 4C 00 01 2C 2F 80 00 00 40 9E 00 B8 93 E1 00 14 3C 60 ?? ?? 3C 80 ?? ?? 3C A0 ?? ?? 93 A1 00 0C 3F E0 ?? ?? 3B 40 00 00 93 C1 00 10 38 84 ?? ?? 38 A5 ?? ?? 93 21 00 08 38 DC 00 04 38 FC 00 08 93 41 00 18 39 1C 00 0C 39 20 00 00 39 40 00 00 3B FF ?? ?? 38 63 ?? ?? 4? ?? ?? ?? 81 3F ?? ?? 7D 29 12 14 7C 7E 1B 78 83 A9 00 00 7C 00 04 AC 7C 00 E0 28 7F 40 E1 2D 40 A2 FF F8 2F 80 00 01 41 9D 00 4C 80 01 00 44 83 FF ?? ?? 7F FF 12 14 83 21 00 24 7C 08 03 A6 93 BF 00 00 7F C3 F3 78 83 41 00 28 83 61 00 2C 83 81 00 30 83 A1 00 34 83 C1 00 38 83 E1 00 3C 38 21 00 40 4E 80 00 20 7F 83 E3 78 4? ?? ?? ?? 4B FF FF 44 80 82 8B 68 38 00 00 DD 7F 83 E3 78 60 84 00 01 38 A0 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF 98 }
	condition:
		$1
}

rule file_719_2_0 {
	meta:
		name = "__getpwent_r"
		size = 332
		refs = "0076 __nss_passwd_lookup2 007e _GLOBAL_OFFSET_TABLE_ 00b4 __nss_getent_r 00ba __libc_errno 0120 __lll_lock_wait_private"
	strings:
		$1 = { 94 21 FF C0 7C 08 02 A6 39 60 00 01 93 61 00 2C 3F 60 ?? ?? 39 20 00 00 93 21 00 24 7C 79 1B 78 93 81 00 30 3B 9B ?? ?? 93 A1 00 34 7C 9D 23 78 93 C1 00 38 7C BE 2B 78 93 E1 00 3C 7C DF 33 78 90 01 00 44 93 41 00 28 7C 00 E0 28 7C 00 48 00 40 82 00 0C 7D 60 E1 2D 40 A2 FF F0 4C 00 01 2C 2F 80 00 00 40 9E 00 B8 93 E1 00 14 3C 60 ?? ?? 3C 80 ?? ?? 3C A0 ?? ?? 93 A1 00 0C 3F E0 ?? ?? 3B 40 00 00 93 C1 00 10 38 84 ?? ?? 38 A5 ?? ?? 93 21 00 08 38 DC 00 04 38 FC 00 08 93 41 00 18 39 1C 00 0C 39 20 00 00 39 40 00 00 3B FF ?? ?? 38 63 ?? ?? 4? ?? ?? ?? 81 3F ?? ?? 7D 29 12 14 7C 7E 1B 78 83 A9 00 00 7C 00 04 AC 7C 00 E0 28 7F 40 E1 2D 40 A2 FF F8 2F 80 00 01 41 9D 00 4C 80 01 00 44 83 FF ?? ?? 7F FF 12 14 83 21 00 24 7C 08 03 A6 93 BF 00 00 7F C3 F3 78 83 41 00 28 83 61 00 2C 83 81 00 30 83 A1 00 34 83 C1 00 38 83 E1 00 3C 38 21 00 40 4E 80 00 20 7F 83 E3 78 4? ?? ?? ?? 4B FF FF 44 80 82 8B 68 38 00 00 DD 7F 83 E3 78 60 84 00 01 38 A0 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF 98 }
	condition:
		$1
}

rule file_531_2_0 {
	meta:
		name = "__getspent_r"
		size = 332
		refs = "0076 __nss_shadow_lookup2 007e _GLOBAL_OFFSET_TABLE_ 00b4 __nss_getent_r 00ba __libc_errno 0120 __lll_lock_wait_private"
	strings:
		$1 = { 94 21 FF C0 7C 08 02 A6 39 60 00 01 93 61 00 2C 3F 60 ?? ?? 39 20 00 00 93 21 00 24 7C 79 1B 78 93 81 00 30 3B 9B ?? ?? 93 A1 00 34 7C 9D 23 78 93 C1 00 38 7C BE 2B 78 93 E1 00 3C 7C DF 33 78 90 01 00 44 93 41 00 28 7C 00 E0 28 7C 00 48 00 40 82 00 0C 7D 60 E1 2D 40 A2 FF F0 4C 00 01 2C 2F 80 00 00 40 9E 00 B8 93 E1 00 14 3C 60 ?? ?? 3C 80 ?? ?? 3C A0 ?? ?? 93 A1 00 0C 3F E0 ?? ?? 3B 40 00 00 93 C1 00 10 38 84 ?? ?? 38 A5 ?? ?? 93 21 00 08 38 DC 00 04 38 FC 00 08 93 41 00 18 39 1C 00 0C 39 20 00 00 39 40 00 00 3B FF ?? ?? 38 63 ?? ?? 4? ?? ?? ?? 81 3F ?? ?? 7D 29 12 14 7C 7E 1B 78 83 A9 00 00 7C 00 04 AC 7C 00 E0 28 7F 40 E1 2D 40 A2 FF F8 2F 80 00 01 41 9D 00 4C 80 01 00 44 83 FF ?? ?? 7F FF 12 14 83 21 00 24 7C 08 03 A6 93 BF 00 00 7F C3 F3 78 83 41 00 28 83 61 00 2C 83 81 00 30 83 A1 00 34 83 C1 00 38 83 E1 00 3C 38 21 00 40 4E 80 00 20 7F 83 E3 78 4? ?? ?? ?? 4B FF FF 44 80 82 8B 68 38 00 00 DD 7F 83 E3 78 60 84 00 01 38 A0 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF 98 }
	condition:
		$1
}

rule file_129_0_0 {
	meta:
		name = "__gethostname"
		size = 192
		refs = "0024 uname 0054 strlen 0070 memcpy 0082 _GLOBAL_OFFSET_TABLE_ 008a __libc_errno"
	strings:
		$1 = { 94 21 FE 50 7C 08 02 A6 93 A1 01 A4 7C 7D 1B 78 38 61 00 08 93 E1 01 AC 7C 9F 23 78 90 01 01 B4 93 C1 01 A8 4? ?? ?? ?? 2F 83 00 00 38 60 FF FF 41 9E 00 20 80 01 01 B4 83 A1 01 A4 7C 08 03 A6 83 C1 01 A8 83 E1 01 AC 38 21 01 B0 4E 80 00 20 38 61 00 49 4? ?? ?? ?? 3B C3 00 01 7F 9E F8 40 7F C5 F3 78 41 9D 00 3C 7F A3 EB 78 38 81 00 49 4? ?? ?? ?? 7F 9E F8 40 38 60 00 00 40 9D FF B8 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 38 00 00 24 90 09 00 00 38 60 FF FF 4B FF FF 98 7F E5 FB 78 7F A3 EB 78 38 81 00 49 4? ?? ?? ?? 7F 9E F8 40 38 60 00 00 40 9D FF 7C 4B FF FF C4 }
	condition:
		$1
}

rule file_130_0_0 {
	meta:
		name = "posix_spawnattr_setsigdefault"
		size = 44
		refs = "0014 memcpy"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 38 63 00 08 38 A0 00 80 90 01 00 14 4? ?? ?? ?? 38 60 00 00 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_131_0_0 {
	meta:
		name = "fchflags"
		size = 72
		refs = "000a _GLOBAL_OFFSET_TABLE_ 0012 __libc_errno"
	strings:
		$1 = { 2F 83 00 00 41 9C 00 24 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 38 00 00 26 90 09 00 00 38 60 FF FF 4E 80 00 20 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 38 00 00 16 90 09 00 00 38 60 FF FF 4E 80 00 20 }
	condition:
		$1
}

rule file_132_0_0 {
	meta:
		name = "__socket"
		size = 44
		refs = "0028 __syscall_error"
	strings:
		$1 = { 94 21 FF D0 90 61 00 14 90 81 00 18 90 A1 00 1C 38 60 00 01 38 81 00 14 38 00 00 66 44 00 00 02 38 21 00 30 4C A3 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_133_0_0 {
	meta:
		name = "open_translit"
		size = 288
		refs = "002c __libc_dlopen_mode 0048 __libc_dlsym 0078 __libc_dlclose"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 3C 80 80 00 90 01 00 24 60 84 00 01 93 E1 00 1C 7C 7F 1B 78 80 63 00 20 93 C1 00 18 3B C0 00 01 93 A1 00 14 4? ?? ?? ?? 2F 83 00 00 90 7F 00 24 41 9E 00 4C 3F A0 ?? ?? 3B BD ?? ?? 7F A4 EB 78 4? ?? ?? ?? 7C 60 1B 79 41 82 00 20 80 7F 00 00 38 9F 00 08 38 BF 00 0C 7C 09 03 A6 4E 80 04 21 2F 83 00 00 41 9E 00 38 80 7F 00 24 3B C0 00 01 4? ?? ?? ?? 38 00 00 00 90 1F 00 24 80 01 00 24 7F C3 F3 78 83 A1 00 14 7C 08 03 A6 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 80 7F 00 24 3C 80 ?? ?? 38 84 ?? ?? 4? ?? ?? ?? 2F 83 00 00 90 7F 00 10 41 BE FF B4 80 7F 00 24 3C 80 ?? ?? 38 84 ?? ?? 4? ?? ?? ?? 7F A4 EB 78 90 7F 00 18 80 7F 00 24 4? ?? ?? ?? 3C 80 ?? ?? 90 7F 00 14 38 84 ?? ?? 80 7F 00 24 4? ?? ?? ?? 80 01 00 24 93 DF 00 28 3B C0 00 00 7C 08 03 A6 90 7F 00 1C 7F C3 F3 78 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 }
	condition:
		$1
}

rule file_133_1_0 {
	meta:
		name = "trans_compare"
		size = 40
		refs = "0014 strcmp"
		altNames = "__gconv_alias_compare known_compare"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 80 63 00 00 80 84 00 00 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_1206_1_0 {
	meta:
		name = "alias_compare"
		size = 40
		refs = "0014 __strcasecmp"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 80 63 00 00 80 84 00 00 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_133_2_0 {
	meta:
		name = "__gconv_transliterate"
		size = 1060
		refs = "008a _GLOBAL_OFFSET_TABLE_ 0092 _nl_current_LC_CTYPE 01a8 _dl_mcount_wrapper_check"
	strings:
		$1 = { 94 21 FF 90 7C 08 02 A6 90 01 00 74 80 03 00 00 91 C1 00 28 7C EE 3B 78 2F 80 00 00 92 21 00 34 7C 91 23 78 92 41 00 38 7D 12 43 78 92 61 00 3C 7D 33 4B 78 92 81 00 40 92 C1 00 48 7C 76 1B 78 93 61 00 5C 91 E1 00 2C 92 01 00 30 92 A1 00 44 92 E1 00 4C 93 01 00 50 93 21 00 54 93 41 00 58 93 81 00 60 93 A1 00 64 93 C1 00 68 93 E1 00 6C 91 41 00 18 82 87 00 00 83 63 00 14 41 9E 00 0C 80 02 8F F4 7F 7B 02 78 3D 60 ?? ?? 39 6B ?? ?? 81 2B ?? ?? 7D 29 12 14 81 29 00 00 81 29 00 00 82 A9 01 18 2F 95 00 00 41 9E 01 98 38 14 00 04 81 69 01 24 7F 92 00 40 82 09 01 1C 83 09 01 20 91 61 00 1C 83 C9 01 28 41 9C 01 A8 39 32 00 03 7C 00 48 50 54 0F F0 BE 3B 20 00 00 39 EF 00 01 7F 55 CA 14 7D E9 03 A6 57 5A F8 7E 57 47 10 3A 7E F0 38 2E 7E 89 A3 78 3B A0 00 00 56 EB 10 3A 7C 18 58 2E 7D 78 5A 14 81 49 00 00 7D 28 4B 78 39 29 00 04 7F 8A 00 00 40 9E 01 6C 84 0B 00 04 3B BD 00 01 2F 80 00 00 41 9E 01 6C 42 00 FF DC 3B 80 00 07 80 01 00 74 7F 83 E3 78 81 C1 00 28 7C 08 03 A6 81 E1 00 2C 82 01 00 30 82 21 00 34 82 41 00 38 82 61 00 3C 82 81 00 40 82 A1 00 44 82 C1 00 48 82 E1 00 4C 83 01 00 50 83 21 00 54 83 41 00 58 83 61 00 5C 83 81 00 60 83 A1 00 64 83 C1 00 68 83 E1 00 6C 38 21 00 70 4E 80 00 20 7D 3C 4B 78 80 13 00 00 7D 3E 4A 14 7F 63 DB 78 91 21 00 0C 90 01 00 08 4? ?? ?? ?? 7C DE E2 14 7F 69 03 A6 7E C3 B3 78 7E 24 8B 78 38 A1 00 0C 38 E1 00 08 39 00 00 00 39 20 00 00 39 40 00 00 4E 80 04 21 2F 83 00 06 7C 7C 1B 78 40 9E 01 C0 3B FF 00 01 57 E9 10 3A 7C 1E 48 2E 2F 80 00 00 40 BE 00 B8 57 A8 10 3A 7D 14 42 14 7F 92 40 40 40 9D 00 D8 7F BD BA 14 80 08 00 00 57 BD 10 3A 7D 38 E8 2E 7F 89 00 40 41 9C 00 C0 7F 55 D3 78 7F 99 A8 40 41 9C FE BC 3D 60 ?? ?? 39 6B ?? ?? 81 2B ?? ?? 7D 29 12 14 81 29 00 00 81 29 00 00 80 09 01 34 2F 80 00 00 40 9E 00 98 83 A9 01 2C 3B 80 00 06 2F 9D 00 00 41 BE FE DC 38 14 00 04 83 C9 01 30 7F 92 00 40 93 C1 00 08 40 9C 00 D0 7F 94 90 00 3B 80 00 07 40 9E FE BC 3B 80 00 04 4B FF FE B4 2F 9D 00 00 41 9E FF 74 2F 80 00 00 40 BE FE A0 81 21 00 1C 7F E9 38 2E 57 E9 10 3A 7C 1E 48 2E 2F 80 00 00 41 BE FE E8 3B FF 00 01 57 FC 10 3A 48 00 00 0C 7C 1C 03 78 7D 7F 5B 78 7C 1E E0 2E 39 7F 00 01 2F 80 00 00 38 1C 00 04 40 9E FF E8 4B FF FE C0 3B 3A 00 01 4B FF FF 44 39 74 00 04 80 CE 00 00 7F 12 58 40 81 69 01 38 81 46 00 00 41 B8 FF 7C 40 BD FF 54 7C 09 03 A6 80 0B 00 00 7F 8A 00 40 41 BC FF 44 81 0B 00 04 7C 00 50 50 7F 8A 40 40 41 9D 00 18 81 0B 00 08 7C E0 43 96 7D 07 41 D6 7F 80 40 00 41 9E 00 8C 42 40 FF 1C 39 6B 00 0C 4B FF FF C8 80 13 00 00 7C 3F 0B 78 7F 63 DB 78 94 1F 00 0C 4? ?? ?? ?? 57 A6 10 3A 7E C3 B3 78 7F 69 03 A6 7E 24 8B 78 38 A1 00 08 7C DE 32 14 7F E7 FB 78 39 00 00 00 39 20 00 00 39 40 00 00 4E 80 04 21 2F 83 00 06 41 BE FD B4 2F 83 00 04 41 9E 00 78 80 01 00 0C 7C 7C 1B 78 90 13 00 00 4B FF FD 9C 2F 83 00 04 41 9E 00 38 2F 83 00 05 41 BE FD 8C 80 01 00 08 90 13 00 00 4B FF FD 80 81 21 00 18 38 C6 00 04 3B 80 00 00 80 09 00 00 90 CE 00 00 30 00 00 01 90 09 00 00 4B FF FD 60 81 61 00 18 57 BD 10 3A 81 2E 00 00 3B 80 00 00 80 0B 00 00 7D 29 EA 14 30 00 00 01 91 2E 00 00 90 0B 00 00 4B FF FF B0 81 61 00 18 38 60 00 00 80 0E 00 00 81 2B 00 00 30 00 00 04 39 29 00 01 91 2B 00 00 90 0E 00 00 4B FF FF 6C }
	condition:
		$1
}

rule file_133_3_0 {
	meta:
		name = "__gconv_translit_find"
		size = 776
		refs = "0094 __tfind 0126 __gconv_path_elem 0128 strlen 0160 memcmp 0172 __gconv_max_path_elem_len 0188 malloc 019c memset 01b0 mempcpy 01f8 stpcpy 022c __tsearch 02b0 __gconv_get_path 02e0 __lll_lock_wait_private 0304 __assert_fail"
	strings:
		$1 = { 94 21 FF C0 7C 08 02 A6 7D 80 00 26 90 01 00 44 80 03 00 00 93 81 00 30 7C 7C 1B 78 2F 80 00 00 92 C1 00 18 92 E1 00 1C 93 01 00 20 93 21 00 24 93 41 00 28 93 61 00 2C 93 A1 00 34 93 C1 00 38 93 E1 00 3C 91 81 00 14 41 9E 02 A0 3F A0 ?? ?? 3B DD ?? ?? 39 60 00 01 39 20 00 00 7C 00 F0 28 7C 00 48 00 40 82 00 0C 7D 60 F1 2D 40 A2 FF F0 4C 00 01 2C 2F 80 00 00 40 9E 02 64 3F 20 ?? ?? 3B 39 ?? ?? 3B 5E 00 04 7F 83 E3 78 7F 44 D3 78 7F 25 CB 78 4? ?? ?? ?? 7C 7B 1B 79 41 82 00 84 80 7B 00 00 3B E0 00 01 80 03 00 24 2F 80 00 00 41 9E 00 10 2F 80 FF FF 3B E0 00 00 41 9E 01 8C 38 00 00 00 7C 00 04 AC 7D 20 F0 28 7C 00 F1 2D 40 A2 FF F8 2F 89 00 01 41 9D 01 E0 80 01 00 44 7F E3 FB 78 81 81 00 14 7C 08 03 A6 82 C1 00 18 82 E1 00 1C 7D 80 81 20 83 01 00 20 83 21 00 24 83 41 00 28 83 61 00 2C 83 81 00 30 83 A1 00 34 83 C1 00 38 83 E1 00 3C 38 21 00 40 4E 80 00 20 80 7C 00 00 3E E0 ?? ?? 4? ?? ?? ?? 80 17 ?? ?? 3B 03 00 01 2F 80 00 00 41 9E 01 78 2B 98 00 04 3A C0 00 01 40 9D 00 2C 80 7C 00 00 38 18 FF FC 3C 80 ?? ?? 7C 63 02 14 38 84 ?? ?? 38 A0 00 03 4? ?? ?? ?? 7C 63 00 34 54 63 D9 7E 68 76 00 01 3D 20 ?? ?? 80 69 ?? ?? 3B E0 00 01 38 63 00 2F 7C 63 C2 14 7C 63 C2 14 4? ?? ?? ?? 7C 7B 1B 79 41 A2 FF 30 38 80 00 00 38 A0 00 2C 4? ?? ?? ?? 38 7B 00 2C 90 7B 00 00 7F 05 C3 78 80 9C 00 00 4? ?? ?? ?? 83 F7 ?? ?? 90 7B 00 20 80 9F 00 00 2F 84 00 00 41 9E 00 50 3E E0 2E 73 2E 16 00 00 62 F7 6F 00 48 00 00 24 7F 63 DB 78 4B FF F8 B9 2F 83 00 00 41 9E 00 5C 84 9F 00 08 2F 84 00 00 41 9E 00 24 80 7B 00 20 4? ?? ?? ?? 80 9C 00 00 7F 05 C3 78 4? ?? ?? ?? 41 92 FF D0 92 E3 00 00 4B FF FF C8 38 00 00 00 90 1B 00 20 3B E0 00 01 7F 63 DB 78 7F 44 D3 78 7F 25 CB 78 4? ?? ?? ?? 2F 83 00 00 40 9E FE 8C 3B E0 00 01 4B FF FE 84 3B E0 00 00 4B FF FF DC 4B FF F8 4D 3B E0 00 01 2F 83 00 00 40 BE FE 6C 81 3B 00 00 3B E0 00 00 81 09 00 00 81 49 00 04 81 69 00 08 80 09 00 0C 91 1C 00 00 91 5C 00 04 91 7C 00 08 90 1C 00 0C 81 69 00 18 80 09 00 1C 81 09 00 10 81 49 00 14 90 1C 00 1C 91 1C 00 10 91 5C 00 14 91 7C 00 18 81 69 00 28 38 0B 00 01 90 09 00 28 4B FF FE 14 4? ?? ?? ?? 4B FF FE 88 80 82 8B 68 38 00 00 DD 7F C3 F3 78 60 84 00 01 38 A0 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FE 04 7F C3 F3 78 4? ?? ?? ?? 4B FF FD 98 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 01 4D 38 C6 ?? ?? 4? ?? ?? ?? }
	condition:
		$1
}

rule file_134_0_0 {
	meta:
		name = "_itoa_word"
		size = 240
		refs = "0012 _itoa_upper_digits 00b2 _itoa_lower_digits"
	strings:
		$1 = { 2F 86 00 00 7C 60 1B 78 41 9E 00 A4 2F 85 00 0A 3D 20 ?? ?? 39 29 ?? ?? 41 9E 00 A4 2F 85 00 10 41 9E 00 34 2F 85 00 08 41 9E 00 58 7D 60 2B 96 7D 4B 29 D6 2F 8B 00 00 7D 4A 00 50 7D 60 5B 78 7D 69 50 AE 9D 64 FF FF 40 9E FF E4 7C 83 23 78 4E 80 00 20 54 0B 07 3E 54 00 E1 3F 7D 69 58 AE 9D 64 FF FF 41 A2 FF E8 54 0B 07 3E 54 00 E1 3F 7D 69 58 AE 9D 64 FF FF 40 82 FF DC 4B FF FF D0 54 0B 07 7E 54 00 E8 FF 7D 69 58 AE 9D 64 FF FF 41 A2 FF BC 54 0B 07 7E 54 00 E8 FF 7D 69 58 AE 9D 64 FF FF 40 82 FF DC 4B FF FF A4 2F 85 00 0A 3D 20 ?? ?? 39 29 ?? ?? 40 9E FF 64 3D 00 CC CC 61 08 CC CD 7D 60 40 16 55 6B E8 FE 1D 4B 00 0A 2F 8B 00 00 7D 4A 00 50 7D 60 5B 78 7D 69 50 AE 9D 64 FF FF 40 9E FF E0 7C 83 23 78 4E 80 00 20 }
	condition:
		$1
}

rule file_134_1_0 {
	meta:
		name = "_itoa"
		size = 1284
		refs = "0026 _itoa_upper_digits 0182 _itoa_lower_digits"
	strings:
		$1 = { 2F 87 00 00 94 21 FF D0 7C 60 1B 78 93 81 00 20 93 A1 00 24 93 C1 00 28 93 E1 00 2C 41 9E 01 60 2F 86 00 08 3D 60 ?? ?? 39 6B ?? ?? 41 9E 01 60 2F 86 00 10 41 9E 01 D4 2F 80 00 00 1D 26 00 14 3D 40 ?? ?? 39 29 FF D8 39 4A ?? ?? 7D 4A 4A 14 7C 1F 03 78 40 9E 02 14 90 81 00 08 3B C0 00 01 88 0A 00 04 3B DE FF FF 57 DE 10 3A 80 EA 00 00 2F 80 00 00 3B A1 00 08 7F DD F2 14 7C A3 2B 78 3B E0 00 30 40 9E 00 7C 2F 84 00 00 39 20 00 00 40 BE 00 0C 48 00 00 30 7C 04 03 78 88 0A 00 05 39 29 00 01 7D 04 38 16 7D 00 04 30 7D 00 31 D6 2F 80 00 00 7C 88 20 50 7D 0B 20 AE 9D 03 FF FF 40 9E FF D8 7F 9E E8 00 41 9E 00 8C 88 0A 00 09 7F 89 00 00 40 9C 00 18 9F E3 FF FF 39 29 00 01 88 0A 00 09 7F 80 48 00 41 9D FF F0 88 0A 00 04 84 9E FF FC 2F 80 00 00 80 EA 00 00 41 BE FF 8C 2F 84 00 00 39 20 00 00 40 BE 00 0C 4B FF FF B8 7C 04 03 78 7D 04 38 16 89 8A 00 05 7C 08 20 50 54 00 F8 7E 7D 00 42 14 39 8C FF FF 7D 00 64 30 7D 00 31 D6 2F 80 00 00 7C 88 20 50 7D 0B 20 AE 39 29 00 01 9D 03 FF FF 40 9E FF C8 7F 9E E8 00 40 BE FF 7C 7F 83 28 00 40 BE 00 0C 38 00 00 30 9C 03 FF FF 83 81 00 20 83 A1 00 24 83 C1 00 28 83 E1 00 2C 38 21 00 30 4E 80 00 20 2F 86 00 08 3D 60 ?? ?? 39 6B ?? ?? 40 9E FE A8 2F 80 00 00 7C 89 23 78 7C A3 2B 78 41 9E 00 44 39 40 00 0A 7D 49 03 A6 7C A9 2B 78 38 65 FF F6 54 8A 07 7E 7D 4B 50 AE 54 84 E8 FE 9D 49 FF FF 42 00 FF F0 54 09 F8 7F 54 00 17 7A 7C 84 03 78 41 82 02 1C 7C 0B 20 AE 38 65 FF F5 98 05 FF F5 55 20 07 7E 55 29 E8 FF 7C 0B 00 AE 9C 03 FF FF 41 A2 FF 78 55 20 07 7E 55 29 E8 FF 7C 0B 00 AE 9C 03 FF FF 40 82 FF DC 4B FF FF 60 2F 80 00 00 41 9E 00 28 3B E0 00 08 7F E9 03 A6 38 65 FF F8 54 89 07 3E 7D 2B 48 AE 54 84 E1 3E 9D 25 FF FF 42 00 FF F0 48 00 00 0C 7C 80 23 78 7C A3 2B 78 54 09 07 3E 54 00 E1 3F 7D 2B 48 AE 9D 23 FF FF 40 82 FF F0 83 81 00 20 83 A1 00 24 83 C1 00 28 83 E1 00 2C 38 21 00 30 4E 80 00 20 81 2A 00 0C 89 0A 00 08 7F 80 48 40 7D 29 40 30 41 9C 01 78 2F 88 00 00 41 9E 01 F0 20 E8 00 40 34 67 FF E0 41 80 02 60 7C 07 1C 30 23 A8 00 20 37 FD FF E0 7C FC 3B 78 41 80 02 34 7C 1F FC 30 83 CA 00 10 7C 67 F0 16 7C 63 3A 14 7D 83 49 D6 7C 03 48 16 7C EC F8 10 7F E0 E1 10 2F 1F 00 00 41 9A 00 2C 7C 09 38 10 7F FF 01 D4 2F 1F 00 00 7C 07 03 78 38 63 00 01 41 9A 00 14 7C 09 38 10 7F FF 01 D4 38 63 00 01 7C 07 03 78 7F 07 48 40 41 98 01 A8 7C E9 38 50 7F E7 F0 16 7F FF 3A 14 7F 9F 49 D6 7D 9F 48 16 38 63 00 01 7C 84 40 30 7C 1C 20 10 7C EC 39 10 2F 07 00 00 41 9A 00 2C 7C 89 00 10 7C E7 01 D4 2F 07 00 00 7C 80 23 78 3B FF 00 01 41 9A 00 14 7C 89 00 10 7C E7 01 D4 3B FF 00 01 7C 80 23 78 7F 00 48 40 41 98 00 0C 7C 09 00 50 3B FF 00 01 7C 04 44 30 90 81 00 10 41 9E 01 24 7F FD EC 30 7C 63 40 30 7F A3 1B 78 7C E3 F0 16 7C E7 1A 14 7F A7 49 D6 7F C7 48 16 7F FF 40 30 7C 1D F8 10 7C 7E 19 10 2F 83 00 00 41 9E 00 2C 7F E9 00 10 7C 63 01 D4 2F 83 00 00 7F E0 FB 78 38 E7 00 01 41 9E 00 14 7F E9 00 10 7C 63 01 D4 38 E7 00 01 7F E0 FB 78 7F 80 48 40 41 9C 00 0C 7C 09 00 50 38 E7 00 01 7C 00 44 30 90 E1 00 08 3B C0 00 03 90 01 00 0C 4B FF FC 7C 7C 89 23 78 4B FF FD F0 34 E8 FF E0 41 80 00 C4 7C 80 38 30 3B C0 00 00 80 EA 00 10 7C E0 38 16 7C E7 02 14 7F E7 49 D6 7C 67 48 16 7C 9F F0 10 7C 03 01 10 2F 80 00 00 41 9E 00 2C 7C 69 20 10 7C 00 01 D4 2F 80 00 00 7C 64 1B 78 38 E7 00 01 41 9E 00 14 7F E9 18 10 7C 00 01 D4 38 E7 00 01 7F E4 FB 78 7F 84 48 40 41 9C 00 0C 7C 89 20 50 38 E7 00 01 7C 84 44 30 90 E1 00 08 3B C0 00 02 90 81 00 0C 4B FF FB F4 83 CA 00 10 3B A0 00 20 7C 68 F0 16 3B 80 00 00 7D 83 49 D6 7C 03 48 16 4B FF FE 34 7C E3 F0 16 7C E7 1A 14 7F A7 49 D6 7F C7 48 16 4B FF FE F0 7F E7 F0 16 7F FF 3A 14 7F 9F 49 D6 7D 9F 48 16 7C 84 40 30 4B FF FE 64 54 83 F8 7E 20 E8 00 1F 7C 67 3C 30 7C 00 40 30 7C E0 03 78 7C 9E 40 30 4B FF FF 30 54 00 08 3C 20 7D 00 1F 7C 00 18 30 7C 9F EC 30 7C 1F FB 78 4B FF FD C0 20 67 00 1F 54 1F 08 3C 7F E3 18 30 7C 87 3C 30 7C 67 3B 78 4B FF FD 94 }
	condition:
		$1
}

rule file_134_2_0 {
	meta:
		name = "_fitoa_word"
		size = 116
		refs = "0020 _itoa_word"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 93 C1 00 18 3B C1 00 18 93 E1 00 1C 7C 9F 23 78 7F C4 F3 78 90 01 00 24 4? ?? ?? ?? 7F 83 F0 40 40 9C 00 30 39 23 FF FF 38 01 00 17 7C 09 00 50 7C 09 03 A6 39 7F FF FF 8C 09 00 01 9C 0B 00 01 42 00 FF F8 7C 63 08 50 38 63 00 18 7F FF 1A 14 80 01 00 24 7F E3 FB 78 83 C1 00 18 7C 08 03 A6 83 E1 00 1C 38 21 00 20 4E 80 00 20 }
	condition:
		$1
}

rule file_134_3_0 {
	meta:
		name = "_fitoa"
		size = 116
		refs = "0020 _itoa"
	strings:
		$1 = { 94 21 FF D0 7C 08 02 A6 93 C1 00 28 3B C1 00 28 93 E1 00 2C 7C BF 2B 78 7F C5 F3 78 90 01 00 34 4? ?? ?? ?? 7F 83 F0 40 40 9C 00 30 39 23 FF FF 38 01 00 27 7C 09 00 50 7C 09 03 A6 39 7F FF FF 8C 09 00 01 9C 0B 00 01 42 00 FF F8 7C 63 08 50 38 63 00 28 7F FF 1A 14 80 01 00 34 7F E3 FB 78 83 C1 00 28 7C 08 03 A6 83 E1 00 2C 38 21 00 30 4E 80 00 20 }
	condition:
		$1
}

rule file_135_0_0 {
	meta:
		name = "__setsid"
		size = 16
		refs = "000c __syscall_error"
	strings:
		$1 = { 38 00 00 42 44 00 00 02 4C A3 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_137_0_0 {
	meta:
		name = "__nscd_getgrouplist"
		size = 932
		refs = "001e __nss_not_use_nscd_group 0060 strlen 006a __gr_map_handle 0080 __nscd_get_map_ref 00ac __nscd_cache_search 00cc __nscd_open_socket 01b0 __nscd_unmap 01ec memcpy 02a8 realloc 02d8 __readall 031c __assert_fail"
	strings:
		$1 = { 94 21 FF B0 7D 80 00 26 7C 08 02 A6 92 C1 00 28 3A C0 00 01 90 01 00 54 92 E1 00 2C 3E E0 ?? ?? 93 01 00 30 93 21 00 34 7C 79 1B 78 93 41 00 38 7C BA 2B 78 93 61 00 3C 3B 60 00 00 93 81 00 40 7C DC 33 78 93 C1 00 48 7C 9E 23 78 93 E1 00 4C 91 81 00 1C 92 81 00 20 92 A1 00 24 93 A1 00 44 4? ?? ?? ?? 3C 80 ?? ?? 3C A0 ?? ?? 3B 03 00 01 38 84 ?? ?? 38 60 00 0C 38 A5 ?? ?? 38 C1 00 08 4? ?? ?? ?? 38 00 FF FF 2E 03 FF FF 2D 00 FF FF 7C 7F 1B 78 41 92 00 24 38 60 00 0F 7F 24 CB 78 7F 05 C3 78 7F E6 FB 78 38 E0 00 0C 4? ?? ?? ?? 2C 03 00 00 40 82 01 84 7F 23 CB 78 7F 04 C3 78 38 A0 00 0F 38 C1 00 0C 38 E0 00 0C 4? ?? ?? ?? 3A 80 00 00 2F 83 FF FF 7C 75 1B 78 41 9E 02 18 80 01 00 10 2F 80 00 01 41 9E 00 D0 2F 80 FF FF 41 9E 02 30 80 1A 00 00 2F 80 00 00 40 9D 02 88 81 5C 00 00 39 20 00 00 55 20 10 3A 7F CA 01 2E 3B A9 00 01 2F 95 FF FF 41 9E 00 14 38 00 00 06 7E A3 AB 78 44 00 00 02 7C 00 00 26 41 92 00 34 81 3F 00 00 80 01 00 08 81 29 00 08 7F 80 48 00 40 9E 01 EC 39 3F 00 0C 7D 60 48 28 39 6B FF FF 7D 60 49 2D 40 A2 FF F4 2F 8B 00 00 41 9E 00 50 80 01 00 54 7F A3 EB 78 81 81 00 1C 7C 08 03 A6 82 81 00 20 82 A1 00 24 7D 83 81 20 82 C1 00 28 82 E1 00 2C 83 01 00 30 83 21 00 34 83 41 00 38 83 61 00 3C 83 81 00 40 83 A1 00 44 83 C1 00 48 83 E1 00 4C 38 21 00 50 4E 80 00 20 7F E3 FB 78 4? ?? ?? ?? 4B FF FF AC 83 A1 00 14 2F 9D 00 00 41 9C 01 40 80 1A 00 00 38 9D 00 01 7F 80 20 00 41 9C 00 CC 2F 94 00 00 80 1C 00 00 41 9E 00 F0 7C 03 03 78 7E 84 A3 78 57 A5 10 3A 4? ?? ?? ?? 2F 9D 00 00 41 9C FF 20 41 BE FF 08 81 5C 00 00 80 0A 00 00 7F 80 F0 00 41 BE FF 0C 7F A9 03 A6 7D 4B 53 78 39 20 00 00 39 29 00 01 42 40 FE EC 84 0B 00 04 7F 80 F0 00 40 9E FF F0 7F 9D 48 00 40 9E FE E4 4B FF FE D4 81 3F 00 00 3B A0 FF FE 80 01 00 08 81 69 00 08 81 43 00 1C 7F 8B 00 00 81 03 00 18 81 63 00 20 91 41 00 10 91 01 00 0C 91 61 00 14 81 43 00 04 40 9E FE D0 39 03 00 18 3A 83 00 24 55 6B 10 3A 7D 48 52 14 7D 74 5A 14 7F 8A 58 40 3B A0 FF FF 41 BC FE B0 2F 94 00 00 3A A0 FF FF 40 9E FE 4C 4B FF FE 20 80 7C 00 00 54 84 10 3A 3B A0 FF FF 4? ?? ?? ?? 7C 60 1B 79 41 A2 FE 64 2F 94 00 00 83 A1 00 14 90 1C 00 00 39 3D 00 01 91 3A 00 00 40 9E FF 18 57 A5 10 3A 7C 04 03 78 7E A3 AB 78 4? ?? ?? ?? 83 A1 00 14 57 A0 10 3A 7F 83 00 00 41 BE FF 08 3B A0 FF FF 4B FF FE 24 92 D7 ?? ?? 3B A0 FF FF 4B FF FE 30 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 00 65 38 C6 ?? ?? 4? ?? ?? ?? 92 D7 ?? ?? 3B A0 FF FF 4B FF FD EC 71 20 00 01 91 21 00 08 2D 9D FF FF 40 82 00 14 2F 9B 00 04 3B 7B 00 01 41 9E 00 08 40 8E FD 4C 39 3F 00 0C 7D 60 48 28 39 6B FF FF 7D 60 49 2D 40 A2 FF F4 2F 8B 00 00 41 9E 00 14 41 AE FD F8 3B E0 FF FF 4E 08 00 00 4B FF FD 44 7F E3 FB 78 4? ?? ?? ?? 4B FF FF E8 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 00 90 38 C6 ?? ?? 4? ?? ?? ?? }
	condition:
		$1
}

rule file_138_0_0 {
	meta:
		name = "__uselocale"
		size = 536
		refs = "0006 _GLOBAL_OFFSET_TABLE_ 000e __libc_tsd_LOCALE 0026 _nl_global_locale 002e _nl_current_LC_COLLATE_used 004a _nl_current_LC_COLLATE 005a _nl_current_LC_CTYPE_used 006a _nl_current_LC_CTYPE 0076 _nl_current_LC_MONETARY_used 0086 _nl_current_LC_MONETARY 0096 _nl_current_LC_NUMERIC_used 00a6 _nl_current_LC_NUMERIC 00b6 _nl_current_LC_TIME_used 00c6 _nl_current_LC_TIME 00d6 _nl_current_LC_MESSAGES_used 00e6 _nl_current_LC_MESSAGES 00f6 _nl_current_LC_PAPER_used 0106 _nl_current_LC_PAPER 0116 _nl_current_LC_NAME_used 0126 _nl_current_LC_NAME 0136 _nl_current_LC_ADDRESS_used 0146 _nl_current_LC_ADDRESS 0156 _nl_current_LC_TELEPHONE_used 0166 _nl_current_LC_TELEPHONE 0176 _nl_current_LC_MEASUREMENT_used 0186 _nl_current_LC_MEASUREMENT 0196 _nl_current_LC_IDENTIFICATION_used 01a6 _nl_current_LC_IDENTIFICATION 01be __libc_tsd_CTYPE_B 01c6 __libc_tsd_CTYPE_TOLOWER 01ce __libc_tsd_CTYPE_TOUPPER"
	strings:
		$1 = { 7C 6B 1B 79 3D 20 ?? ?? 39 29 ?? ?? 81 49 ?? ?? 7D 4A 12 14 80 6A 00 00 41 82 01 DC 2F 8B FF FF 41 9E 01 E8 3D 40 ?? ?? 38 0A ?? ?? 3D 40 ?? ?? 39 4A ?? ?? 2F 8A 00 00 81 49 ?? ?? 7D 4A 12 14 91 6A 00 00 41 9E 00 14 81 49 ?? ?? 7D 4A 12 14 39 0B 00 0C 91 0A 00 00 3D 40 ?? ?? 39 4A ?? ?? 2F 8A 00 00 41 9E 00 10 81 49 ?? ?? 7D 4A 12 14 91 6A 00 00 3D 40 ?? ?? 39 4A ?? ?? 2F 8A 00 00 41 9E 00 14 81 49 ?? ?? 7D 4A 12 14 39 0B 00 10 91 0A 00 00 3D 40 ?? ?? 39 4A ?? ?? 2F 8A 00 00 41 9E 00 14 81 49 ?? ?? 7D 4A 12 14 39 0B 00 04 91 0A 00 00 3D 40 ?? ?? 39 4A ?? ?? 2F 8A 00 00 41 9E 00 14 81 49 ?? ?? 7D 4A 12 14 39 0B 00 08 91 0A 00 00 3D 40 ?? ?? 39 4A ?? ?? 2F 8A 00 00 41 9E 00 14 81 49 ?? ?? 7D 4A 12 14 39 0B 00 14 91 0A 00 00 3D 40 ?? ?? 39 4A ?? ?? 2F 8A 00 00 41 9E 00 14 81 49 ?? ?? 7D 4A 12 14 39 0B 00 1C 91 0A 00 00 3D 40 ?? ?? 39 4A ?? ?? 2F 8A 00 00 41 9E 00 14 81 49 ?? ?? 7D 4A 12 14 39 0B 00 20 91 0A 00 00 3D 40 ?? ?? 39 4A ?? ?? 2F 8A 00 00 41 9E 00 14 81 49 ?? ?? 7D 4A 12 14 39 0B 00 24 91 0A 00 00 3D 40 ?? ?? 39 4A ?? ?? 2F 8A 00 00 41 9E 00 14 81 49 ?? ?? 7D 4A 12 14 39 0B 00 28 91 0A 00 00 3D 40 ?? ?? 39 4A ?? ?? 2F 8A 00 00 41 9E 00 14 81 49 ?? ?? 7D 4A 12 14 39 0B 00 2C 91 0A 00 00 3D 40 ?? ?? 39 4A ?? ?? 2F 8A 00 00 41 9E 00 14 81 49 ?? ?? 7D 4A 12 14 39 0B 00 30 91 0A 00 00 7F 83 00 00 80 CB 00 34 80 E9 ?? ?? 81 0B 00 38 81 49 ?? ?? 81 6B 00 3C 81 29 ?? ?? 7C E7 12 14 7D 4A 12 14 90 C7 00 00 7D 29 12 14 91 0A 00 00 91 69 00 00 4C BE 00 20 38 60 FF FF 4E 80 00 20 3D 20 ?? ?? 38 09 ?? ?? 7F 83 00 00 4C BE 00 20 4B FF FF E8 3D 60 ?? ?? 38 0B ?? ?? 7C 0B 03 78 4B FF FE 18 }
	condition:
		$1
}

rule file_139_0_0 {
	meta:
		name = "xdr_int64_t"
		size = 272
		altNames = "xdr_quad_t"
	strings:
		$1 = { 94 21 FF D0 7C 08 02 A6 90 01 00 34 93 E1 00 2C 83 E3 00 00 93 A1 00 24 7C 9D 23 78 2F 9F 00 01 93 C1 00 28 7C 7E 1B 78 41 9E 00 90 2B 9F 00 01 41 9C 00 30 6B FF 00 02 7F FF 00 34 57 FF D9 7E 80 01 00 34 7F E3 FB 78 83 A1 00 24 7C 08 03 A6 83 C1 00 28 83 E1 00 2C 38 21 00 30 4E 80 00 20 80 04 00 04 3B E0 00 00 81 23 00 04 81 64 00 00 38 81 00 08 90 01 00 0C 80 09 00 24 91 61 00 08 7C 09 03 A6 4E 80 04 21 2F 83 00 00 41 9E FF B4 81 3E 00 04 7F C3 F3 78 38 81 00 0C 80 09 00 24 7C 09 03 A6 4E 80 04 21 7C 63 00 34 54 63 D9 7E 68 7F 00 01 4B FF FF 8C 81 23 00 04 38 81 00 08 3B E0 00 00 80 09 00 20 7C 09 03 A6 4E 80 04 21 2F 83 00 00 41 9E FF 6C 81 3E 00 04 7F C3 F3 78 38 81 00 0C 80 09 00 20 7C 09 03 A6 4E 80 04 21 2F 83 00 00 41 BE FF 4C 80 01 00 0C 3B E0 00 01 90 1D 00 04 80 01 00 08 90 1D 00 00 4B FF FF 34 }
	condition:
		$1
}

rule file_139_1_0 {
	meta:
		name = "xdr_uint64_t"
		size = 272
	strings:
		$1 = { 94 21 FF D0 7C 08 02 A6 90 01 00 34 93 E1 00 2C 83 E3 00 00 93 A1 00 24 7C 9D 23 78 2F 9F 00 01 93 C1 00 28 7C 7E 1B 78 41 9E 00 90 2B 9F 00 01 41 9C 00 30 6B FF 00 02 7F FF 00 34 57 FF D9 7E 80 01 00 34 7F E3 FB 78 83 A1 00 24 7C 08 03 A6 83 C1 00 28 83 E1 00 2C 38 21 00 30 4E 80 00 20 80 04 00 04 3B E0 00 00 81 23 00 04 81 64 00 00 38 81 00 08 90 01 00 0C 80 09 00 24 91 61 00 08 7C 09 03 A6 4E 80 04 21 2F 83 00 00 41 9E FF B4 81 3E 00 04 7F C3 F3 78 38 81 00 0C 80 09 00 24 7C 09 03 A6 4E 80 04 21 7C 63 00 34 54 63 D9 7E 68 7F 00 01 4B FF FF 8C 81 23 00 04 38 81 00 08 3B E0 00 00 80 09 00 20 7C 09 03 A6 4E 80 04 21 2F 83 00 00 41 9E FF 6C 81 3E 00 04 7F C3 F3 78 38 81 00 0C 80 09 00 20 7C 09 03 A6 4E 80 04 21 2F 83 00 00 41 BE FF 4C 80 01 00 08 3B E0 00 01 90 1D 00 00 80 01 00 0C 90 1D 00 04 4B FF FF 34 }
	condition:
		$1
}

rule file_139_2_0 {
	meta:
		name = "xdr_int32_t"
		size = 124
		altNames = "xdr_uint32_t"
	strings:
		$1 = { 7C 08 02 A6 94 21 FF F0 90 01 00 14 80 03 00 00 2F 80 00 01 41 9E 00 48 2B 80 00 01 41 9C 00 20 68 03 00 02 80 01 00 14 7C 63 00 34 7C 08 03 A6 54 63 D9 7E 38 21 00 10 4E 80 00 20 81 23 00 04 80 09 00 24 7C 09 03 A6 4E 80 04 21 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 81 23 00 04 80 09 00 20 7C 09 03 A6 4E 80 04 21 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_139_4_0 {
	meta:
		name = "xdr_int16_t"
		size = 184
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 90 01 00 24 80 03 00 00 93 E1 00 1C 7C 9F 23 78 2F 80 00 01 41 9E 00 5C 2B 80 00 01 41 9C 00 24 68 03 00 02 7C 63 00 34 54 63 D9 7E 80 01 00 24 83 E1 00 1C 38 21 00 20 7C 08 03 A6 4E 80 00 20 A8 04 00 00 7C 24 0B 78 81 23 00 04 94 04 00 08 80 09 00 24 7C 09 03 A6 4E 80 04 21 80 01 00 24 83 E1 00 1C 38 21 00 20 7C 08 03 A6 4E 80 00 20 81 23 00 04 38 81 00 08 80 09 00 20 7C 09 03 A6 4E 80 04 21 2F 83 00 00 38 60 00 00 41 BE FF A0 80 01 00 08 38 60 00 01 B0 1F 00 00 80 01 00 24 83 E1 00 1C 38 21 00 20 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_139_5_0 {
	meta:
		name = "xdr_uint16_t"
		size = 184
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 90 01 00 24 80 03 00 00 93 E1 00 1C 7C 9F 23 78 2F 80 00 01 41 9E 00 5C 2B 80 00 01 41 9C 00 24 68 03 00 02 7C 63 00 34 54 63 D9 7E 80 01 00 24 83 E1 00 1C 38 21 00 20 7C 08 03 A6 4E 80 00 20 A0 04 00 00 7C 24 0B 78 81 23 00 04 94 04 00 08 80 09 00 24 7C 09 03 A6 4E 80 04 21 80 01 00 24 83 E1 00 1C 38 21 00 20 7C 08 03 A6 4E 80 00 20 81 23 00 04 38 81 00 08 80 09 00 20 7C 09 03 A6 4E 80 04 21 2F 83 00 00 38 60 00 00 41 BE FF A0 80 01 00 08 38 60 00 01 B0 1F 00 00 80 01 00 24 83 E1 00 1C 38 21 00 20 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_139_6_0 {
	meta:
		name = "xdr_int8_t"
		size = 188
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 90 01 00 24 80 03 00 00 93 E1 00 1C 7C 9F 23 78 2F 80 00 01 41 9E 00 60 2B 80 00 01 41 9C 00 24 68 03 00 02 7C 63 00 34 54 63 D9 7E 80 01 00 24 83 E1 00 1C 38 21 00 20 7C 08 03 A6 4E 80 00 20 88 04 00 00 7C 24 0B 78 81 23 00 04 7C 00 07 74 94 04 00 08 80 09 00 24 7C 09 03 A6 4E 80 04 21 80 01 00 24 83 E1 00 1C 38 21 00 20 7C 08 03 A6 4E 80 00 20 81 23 00 04 38 81 00 08 80 09 00 20 7C 09 03 A6 4E 80 04 21 2F 83 00 00 38 60 00 00 41 BE FF 9C 80 01 00 08 38 60 00 01 98 1F 00 00 80 01 00 24 83 E1 00 1C 38 21 00 20 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_139_7_0 {
	meta:
		name = "xdr_uint8_t"
		size = 184
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 90 01 00 24 80 03 00 00 93 E1 00 1C 7C 9F 23 78 2F 80 00 01 41 9E 00 5C 2B 80 00 01 41 9C 00 24 68 03 00 02 7C 63 00 34 54 63 D9 7E 80 01 00 24 83 E1 00 1C 38 21 00 20 7C 08 03 A6 4E 80 00 20 88 04 00 00 7C 24 0B 78 81 23 00 04 94 04 00 08 80 09 00 24 7C 09 03 A6 4E 80 04 21 80 01 00 24 83 E1 00 1C 38 21 00 20 7C 08 03 A6 4E 80 00 20 81 23 00 04 38 81 00 08 80 09 00 20 7C 09 03 A6 4E 80 04 21 2F 83 00 00 38 60 00 00 41 BE FF A0 80 01 00 08 38 60 00 01 98 1F 00 00 80 01 00 24 83 E1 00 1C 38 21 00 20 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_140_0_0 {
	meta:
		name = "__remap_file_pages"
		size = 16
		refs = "000c __syscall_error"
	strings:
		$1 = { 38 00 00 EF 44 00 00 02 4C A3 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_141_0_0 {
	meta:
		name = "___vfprintf_chk"
		size = 488
		refs = "00b0 vfprintf 0168 __lll_lock_wait_private 01e4 _Unwind_Resume"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 7D 80 00 26 90 01 00 24 80 03 00 00 93 81 00 10 7C 9C 23 78 70 00 80 00 93 A1 00 14 7C BD 2B 78 93 C1 00 18 7C DE 33 78 93 E1 00 1C 7C 7F 1B 78 93 61 00 0C 91 81 00 08 40 82 00 50 80 63 00 48 3B 62 8B 60 81 23 00 08 7F 89 D8 00 41 9E 00 30 39 60 00 01 7D 20 18 28 7C 09 00 00 40 82 00 0C 7D 60 19 2D 40 A2 FF F0 4C 00 01 2C 2F 89 00 00 40 9E 00 F0 80 7F 00 48 93 63 00 08 81 23 00 04 38 09 00 01 90 03 00 04 2E 1C 00 00 40 91 00 10 80 1F 00 3C 60 00 00 04 90 1F 00 3C 7F E3 FB 78 7F A4 EB 78 7F C5 F3 78 4? ?? ?? ?? 7C 7E 1B 78 40 91 00 88 80 1F 00 3C 54 00 07 B8 81 3F 00 00 71 2B 80 00 39 20 FF EB 7C 00 48 38 90 1F 00 3C 40 82 00 38 80 7F 00 48 81 23 00 04 38 09 FF FF 2F 80 00 00 90 03 00 04 40 9E 00 20 90 03 00 08 7C 00 04 AC 7D 20 18 28 7C 00 19 2D 40 A2 FF F8 2F 89 00 01 41 9D 00 3C 80 01 00 24 7F C3 F3 78 81 81 00 08 7C 08 03 A6 83 61 00 0C 83 81 00 10 7D 80 81 20 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 80 1F 00 3C 4B FF FF 80 80 82 8B 68 38 00 00 DD 38 A0 00 01 60 84 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF AC 4? ?? ?? ?? 4B FF FF 10 80 1F 00 00 7C 7E 1B 78 81 3F 00 3C 70 0B 80 00 38 00 FF EB 7D 20 00 38 90 1F 00 3C 40 82 00 54 80 7F 00 48 80 03 00 04 30 00 FF FF 2F 80 00 00 90 03 00 04 40 9E 00 3C 90 03 00 08 7C 00 04 AC 7D 20 18 28 7C 00 19 2D 40 A2 FF F8 2F 89 00 01 40 BD 00 20 80 82 8B 68 38 00 00 DD 38 A0 00 01 60 84 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 7F C3 F3 78 4? ?? ?? ?? }
	condition:
		$1
}

rule file_1244_0_0 {
	meta:
		name = "__vfwprintf_chk"
		size = 488
		refs = "00b0 _IO_vfwprintf 0168 __lll_lock_wait_private 01e4 _Unwind_Resume"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 7D 80 00 26 90 01 00 24 80 03 00 00 93 81 00 10 7C 9C 23 78 70 00 80 00 93 A1 00 14 7C BD 2B 78 93 C1 00 18 7C DE 33 78 93 E1 00 1C 7C 7F 1B 78 93 61 00 0C 91 81 00 08 40 82 00 50 80 63 00 48 3B 62 8B 60 81 23 00 08 7F 89 D8 00 41 9E 00 30 39 60 00 01 7D 20 18 28 7C 09 00 00 40 82 00 0C 7D 60 19 2D 40 A2 FF F0 4C 00 01 2C 2F 89 00 00 40 9E 00 F0 80 7F 00 48 93 63 00 08 81 23 00 04 38 09 00 01 90 03 00 04 2E 1C 00 00 40 91 00 10 80 1F 00 3C 60 00 00 04 90 1F 00 3C 7F E3 FB 78 7F A4 EB 78 7F C5 F3 78 4? ?? ?? ?? 7C 7E 1B 78 40 91 00 88 80 1F 00 3C 54 00 07 B8 81 3F 00 00 71 2B 80 00 39 20 FF EB 7C 00 48 38 90 1F 00 3C 40 82 00 38 80 7F 00 48 81 23 00 04 38 09 FF FF 2F 80 00 00 90 03 00 04 40 9E 00 20 90 03 00 08 7C 00 04 AC 7D 20 18 28 7C 00 19 2D 40 A2 FF F8 2F 89 00 01 41 9D 00 3C 80 01 00 24 7F C3 F3 78 81 81 00 08 7C 08 03 A6 83 61 00 0C 83 81 00 10 7D 80 81 20 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 80 1F 00 3C 4B FF FF 80 80 82 8B 68 38 00 00 DD 38 A0 00 01 60 84 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF AC 4? ?? ?? ?? 4B FF FF 10 80 1F 00 00 7C 7E 1B 78 81 3F 00 3C 70 0B 80 00 38 00 FF EB 7D 20 00 38 90 1F 00 3C 40 82 00 54 80 7F 00 48 80 03 00 04 30 00 FF FF 2F 80 00 00 90 03 00 04 40 9E 00 3C 90 03 00 08 7C 00 04 AC 7D 20 18 28 7C 00 19 2D 40 A2 FF F8 2F 89 00 01 40 BD 00 20 80 82 8B 68 38 00 00 DD 38 A0 00 01 60 84 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 7F C3 F3 78 4? ?? ?? ?? }
	condition:
		$1
}

rule file_142_0_0 {
	meta:
		name = "sigemptyset"
		size = 84
		refs = "001c memset 0036 _GLOBAL_OFFSET_TABLE_ 003e __libc_errno"
	strings:
		$1 = { 2F 83 00 00 94 21 FF F0 7C 08 02 A6 90 01 00 14 41 9E 00 24 38 80 00 00 38 A0 00 80 4? ?? ?? ?? 38 60 00 00 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 38 00 00 16 90 09 00 00 38 60 FF FF 4B FF FF D4 }
	condition:
		$1
}

rule file_143_0_0 {
	meta:
		name = "w_addchar"
		size = 216
		refs = "008c realloc 00ac free 00d4 __assert_fail"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 90 01 00 24 93 E1 00 1C 7C 9F 23 78 80 05 00 00 80 84 00 00 93 C1 00 18 7C 7E 1B 78 7F 84 00 00 41 9E 00 40 2F 83 00 00 41 9E 00 1C 7C DE 21 AE 81 3F 00 00 38 09 00 01 39 20 00 00 90 1F 00 00 7D 3E 01 AE 80 01 00 24 7F C3 F3 78 83 E1 00 1C 7C 08 03 A6 83 C1 00 18 38 21 00 20 4E 80 00 20 2F 83 00 00 41 9E 00 0C 2F 84 00 00 41 9E 00 44 38 04 00 64 90 05 00 00 7F C3 F3 78 38 84 00 65 90 C1 00 08 4? ?? ?? ?? 2C 03 00 00 80 C1 00 08 41 82 00 10 80 9F 00 00 7C 7E 1B 78 4B FF FF 90 7F C3 F3 78 4? ?? ?? ?? 3B C0 00 00 4B FF FF 98 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 00 68 38 C6 ?? ?? 4? ?? ?? ?? }
	condition:
		$1
}

rule file_143_1_0 {
	meta:
		name = "parse_backslash"
		size = 148
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 90 01 00 24 81 27 00 00 93 E1 00 1C 7C 7F 1B 78 39 29 00 01 7C C6 48 AE 38 60 00 05 2F 86 00 00 41 9E 00 3C 2F 86 00 0A 41 9E 00 48 80 7F 00 00 90 E1 00 08 4B FF FE ED 2F 83 00 00 90 7F 00 00 38 60 00 01 80 E1 00 08 41 9E 00 14 81 27 00 00 38 60 00 00 38 09 00 01 90 07 00 00 80 01 00 24 83 E1 00 1C 38 21 00 20 7C 08 03 A6 4E 80 00 20 80 01 00 24 38 60 00 00 83 E1 00 1C 38 21 00 20 7C 08 03 A6 91 27 00 00 4E 80 00 20 }
	condition:
		$1
}

rule file_143_2_0 {
	meta:
		name = "parse_qtd_backslash"
		size = 396
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 81 27 00 00 90 01 00 24 38 09 00 01 93 41 00 08 7C 9A 23 78 93 61 00 0C 7C BB 2B 78 93 81 00 10 7C 7C 1B 78 93 C1 00 18 7C DE 33 78 93 E1 00 1C 7C FF 3B 78 93 A1 00 14 7C C6 00 AE 2F 86 00 24 41 9E 00 E8 2B 86 00 24 40 9D 00 88 2F 86 00 5C 41 9E 00 D8 2F 86 00 60 41 9E 00 D0 80 7C 00 00 7F 44 D3 78 7C DE 48 AE 7F 65 DB 78 3B A0 00 01 4B FF FE 1D 2F 83 00 00 90 7C 00 00 41 9E 00 28 80 1F 00 00 7F 44 D3 78 7F 65 DB 78 7F DE 02 14 88 DE 00 01 4B FF FD F9 2F 83 00 00 90 7C 00 00 40 BE 00 A8 80 01 00 24 7F A3 EB 78 83 41 00 08 7C 08 03 A6 83 61 00 0C 83 81 00 10 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 2F 86 00 22 41 9E 00 54 2B 86 00 22 41 BD FF 80 2F 86 00 00 3B A0 00 05 41 BE FF BC 2F 86 00 0A 40 9E FF 6C 90 07 00 00 3B A0 00 00 7F A3 EB 78 80 01 00 24 83 41 00 08 7C 08 03 A6 83 61 00 0C 83 81 00 10 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 80 7C 00 00 7F 44 D3 78 7F 65 DB 78 4B FF FD 59 3B A0 00 01 2F 83 00 00 90 7C 00 00 41 BE FF 60 81 3F 00 00 3B A0 00 00 7F A3 EB 78 83 41 00 08 38 09 00 01 83 61 00 0C 90 1F 00 00 80 01 00 24 83 81 00 10 7C 08 03 A6 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 }
	condition:
		$1
}

rule file_143_3_0 {
	meta:
		name = "w_addmem"
		size = 288
		refs = "006c realloc 0090 mempcpy 00f4 free 011c __assert_fail"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 90 01 00 24 80 04 00 00 81 25 00 00 7D 67 02 14 93 A1 00 14 7F 8B 48 40 93 C1 00 18 7C FD 3B 78 7C 7E 1B 78 93 E1 00 1C 7C 9F 23 78 40 9D 00 94 2F 83 00 00 41 9E 00 0C 2F 89 00 00 41 9E 00 BC 57 A0 08 3C 2B 80 00 64 40 9C 00 08 38 00 00 64 7D 20 4A 14 91 25 00 00 7F C3 F3 78 38 89 00 01 90 C1 00 08 4? ?? ?? ?? 2C 03 00 00 80 C1 00 08 41 82 00 78 80 1F 00 00 7C 7E 1B 78 7C 7E 02 14 7F A5 EB 78 7C C4 33 78 4? ?? ?? ?? 38 00 00 00 98 03 00 00 80 1F 00 00 7F A0 EA 14 93 BF 00 00 80 01 00 24 7F C3 F3 78 83 A1 00 14 7C 08 03 A6 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 2F 83 00 00 40 9E FF B8 80 01 00 24 7F C3 F3 78 83 A1 00 14 7C 08 03 A6 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 7F C3 F3 78 4? ?? ?? ?? 3B C0 00 00 4B FF FF AC 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 00 83 38 C6 ?? ?? 4? ?? ?? ?? }
	condition:
		$1
}

rule file_143_4_0 {
	meta:
		name = "eval_expr_val"
		size = 436
		refs = "003e _GLOBAL_OFFSET_TABLE_ 0046 __libc_tsd_CTYPE_B 004a _nl_current_LC_CTYPE 0108 strtol"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 90 01 00 24 81 23 00 00 93 A1 00 14 7C 9D 23 78 2F 89 00 00 93 C1 00 18 7C 7E 1B 78 93 E1 00 1C 7D 3F 4B 78 41 9E 01 68 88 09 00 00 70 06 00 FF 41 82 00 C4 3D 60 ?? ?? 39 6B ?? ?? 81 4B ?? ?? 81 6B ?? ?? 7D 4A 12 14 7D 0B 12 14 81 6A 00 00 80 E8 00 00 7D 48 53 78 7D 49 00 D0 7D 49 03 A6 48 00 00 18 3B FF 00 01 42 40 00 CC 88 1F 00 00 70 06 00 FF 41 82 00 80 2F 8B 00 00 41 9E 01 18 54 00 06 3E 54 0A 08 3C 7D 4B 52 2E 71 46 00 20 40 82 FF D4 2F 80 00 28 40 9E 00 5C 88 09 00 00 38 60 00 05 2F 80 00 00 41 9E 00 30 2F 80 00 29 40 BE 00 0C 48 00 00 90 41 9A 00 8C 39 29 00 01 91 3E 00 00 88 09 00 00 2F 80 00 00 2F 00 00 29 40 9E FF E8 38 60 00 05 80 01 00 24 83 A1 00 14 7C 08 03 A6 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 7F E3 FB 78 7F C4 F3 78 38 A0 00 00 4? ?? ?? ?? 80 1E 00 00 90 7D 00 00 38 60 00 00 7F 80 F8 00 41 BE FF C0 80 01 00 24 83 A1 00 14 7C 08 03 A6 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 88 1F 00 00 2F 80 00 28 41 9E FF 60 4B FF FF B4 38 09 00 01 39 60 00 00 99 69 00 00 38 7F 00 01 7F A4 EB 78 90 1E 00 00 48 00 01 E5 80 01 00 24 30 63 FF FF 7C 63 19 10 83 A1 00 14 7C 08 03 A6 83 C1 00 18 54 63 07 B8 83 E1 00 1C 38 63 00 05 38 21 00 20 4E 80 00 20 88 09 00 00 4B FF FF 04 81 67 00 00 81 6B 00 24 39 6B 01 00 91 68 00 00 88 1F 00 00 4B FF FE D8 }
	condition:
		$1
}

rule file_143_5_0 {
	meta:
		name = "eval_expr"
		size = 412
		refs = "003e _GLOBAL_OFFSET_TABLE_ 0046 __libc_tsd_CTYPE_B 004a _nl_current_LC_CTYPE"
	strings:
		$1 = { 94 21 FF D0 7C 08 02 A6 93 C1 00 28 7C 3E 0B 78 93 E1 00 2C 7C 9F 23 78 90 01 00 34 93 81 00 20 93 A1 00 24 94 7E 00 18 7F C3 F3 78 4B FF FE 41 2F 83 00 00 38 60 00 05 40 9E 00 C8 3D 20 ?? ?? 39 29 ?? ?? 83 A9 ?? ?? 81 29 ?? ?? 7F BD 12 14 7F 89 12 14 81 21 00 18 88 09 00 00 70 0B 00 FF 41 82 00 9C 7D 09 00 D0 81 7D 00 00 81 5C 00 00 7D 09 03 A6 48 00 00 18 91 21 00 18 42 40 00 A4 88 09 00 00 70 08 00 FF 41 82 00 74 2F 8B 00 00 41 9E 00 F4 54 00 0D FC 7C 0B 02 2E 39 29 00 01 70 08 00 20 40 82 FF D4 81 21 00 18 88 09 00 00 2F 80 00 2B 41 9E 00 7C 2F 80 00 2D 40 9E 00 40 38 09 00 01 7F C3 F3 78 90 01 00 18 38 81 00 08 4B FF FD 9D 2F 83 00 00 40 9E 00 88 81 3F 00 00 80 01 00 08 7C 00 48 50 81 21 00 18 90 1F 00 00 88 09 00 00 70 0B 00 FF 40 82 FF 6C 38 60 00 00 80 01 00 34 83 81 00 20 7C 08 03 A6 83 A1 00 24 83 C1 00 28 83 E1 00 2C 38 21 00 30 4E 80 00 20 88 09 00 00 39 20 00 00 2F 80 00 2B 40 9E FF 8C 38 09 00 01 7F C3 F3 78 90 01 00 18 38 81 00 08 4B FF FD 2D 2F 83 00 00 40 9E 00 18 81 3F 00 00 80 01 00 08 7C 09 02 14 90 1F 00 00 4B FF FE F8 80 01 00 34 38 60 00 05 83 81 00 20 7C 08 03 A6 83 A1 00 24 83 C1 00 28 83 E1 00 2C 38 21 00 30 4E 80 00 20 81 6A 00 00 81 6B 00 24 39 6B 01 00 91 7D 00 00 88 09 00 00 4B FF FE FC }
	condition:
		$1
}

rule file_143_6_0 {
	meta:
		name = "eval_expr_multdiv"
		size = 404
		refs = "0036 _GLOBAL_OFFSET_TABLE_ 003e __libc_tsd_CTYPE_B 0042 _nl_current_LC_CTYPE"
	strings:
		$1 = { 94 21 FF D0 7C 08 02 A6 93 C1 00 28 7C 9E 23 78 93 E1 00 2C 7C 7F 1B 78 90 01 00 34 93 81 00 20 93 A1 00 24 4B FF FE 29 2F 83 00 00 38 60 00 05 40 9E 00 C8 3D 20 ?? ?? 39 29 ?? ?? 83 A9 ?? ?? 81 29 ?? ?? 7F BD 12 14 7F 89 12 14 81 3F 00 00 88 09 00 00 70 0B 00 FF 41 82 00 9C 7D 09 00 D0 81 7D 00 00 81 5C 00 00 7D 09 03 A6 48 00 00 18 91 3F 00 00 42 40 00 A4 88 09 00 00 70 08 00 FF 41 82 00 74 2F 8B 00 00 41 9E 00 F4 54 00 0D FC 7C 0B 02 2E 39 29 00 01 70 08 00 20 40 82 FF D4 81 3F 00 00 88 09 00 00 2F 80 00 2A 41 9E 00 7C 2F 80 00 2F 40 9E 00 40 39 29 00 01 91 3F 00 00 7F E3 FB 78 38 81 00 08 4B FF FD 85 2F 83 00 00 40 9E 00 88 81 3E 00 00 80 01 00 08 7C 09 03 D6 81 3F 00 00 90 1E 00 00 88 09 00 00 70 0B 00 FF 40 82 FF 6C 38 60 00 00 80 01 00 34 83 81 00 20 7C 08 03 A6 83 A1 00 24 83 C1 00 28 83 E1 00 2C 38 21 00 30 4E 80 00 20 88 09 00 00 39 20 00 00 2F 80 00 2A 40 9E FF 8C 39 29 00 01 91 3F 00 00 7F E3 FB 78 38 81 00 08 4B FF FD 15 2F 83 00 00 40 9E 00 18 81 3E 00 00 80 01 00 08 7C 09 01 D6 90 1E 00 00 4B FF FE F8 80 01 00 34 38 60 00 05 83 81 00 20 7C 08 03 A6 83 A1 00 24 83 C1 00 28 83 E1 00 2C 38 21 00 30 4E 80 00 20 81 6A 00 00 81 6B 00 24 39 6B 01 00 91 7D 00 00 88 09 00 00 4B FF FE FC }
	condition:
		$1
}

rule file_143_7_0 {
	meta:
		name = "w_addstr"
		size = 124
		refs = "002c strlen 0078 __assert_fail"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 93 E1 00 1C 7C DF 33 79 93 C1 00 18 7C 7E 1B 78 90 01 00 24 41 82 00 40 7F E3 FB 78 90 81 00 08 90 A1 00 0C 4? ?? ?? ?? 7C 67 1B 78 80 01 00 24 7F C3 F3 78 80 81 00 08 7F E6 FB 78 7C 08 03 A6 80 A1 00 0C 83 C1 00 18 83 E1 00 1C 38 21 00 20 4B FF F9 A4 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 00 9D 38 C6 ?? ?? 4? ?? ?? ?? }
	condition:
		$1
}

rule file_143_8_0 {
	meta:
		name = "w_addword"
		size = 244
		refs = "0040 realloc 00a8 calloc 00ec free"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 93 C1 00 18 7C 9E 23 79 93 A1 00 14 3B A0 00 00 93 E1 00 1C 7C 7F 1B 78 90 01 00 24 41 82 00 7C 80 9F 00 00 80 1F 00 08 80 7F 00 04 7C 84 02 14 38 84 00 02 54 84 10 3A 4? ?? ?? ?? 2C 03 00 00 41 82 00 94 81 7F 00 00 3B A0 00 00 81 3F 00 08 38 0B 00 01 90 7F 00 04 7D 6B 4A 14 55 6B 10 3A 7D 20 4A 14 7F C3 59 2E 55 29 10 3A 90 1F 00 00 38 00 00 00 7C 03 49 2E 80 01 00 24 7F A3 EB 78 83 C1 00 18 7C 08 03 A6 83 A1 00 14 83 E1 00 1C 38 21 00 20 4E 80 00 20 38 60 00 01 38 80 00 01 4? ?? ?? ?? 3B A0 00 01 7C 7E 1B 79 41 A2 FF CC 80 9F 00 00 80 1F 00 08 80 7F 00 04 7C 84 02 14 38 84 00 02 54 84 10 3A 4? ?? ?? ?? 2C 03 00 00 40 82 FF 74 2F 9D 00 00 3B A0 00 01 41 9E FF 9C 7F C3 F3 78 4? ?? ?? ?? 4B FF FF 90 }
	condition:
		$1
}

rule file_143_9_0 {
	meta:
		name = "exec_comm"
		size = 1828
		refs = "0096 __have_sock_cloexec 00b4 __pipe2 0104 __fork 0120 __close 0140 __read 0168 strchr 0284 __errno_location 02a4 __waitpid 0334 free 040c __kill 0534 __pipe 05e4 __dup2 0610 __open 0640 __fxstat64 066c _exit 06dc __unsetenv 06ea __environ 06f8 __execve 06fc abort 071c __fcntl"
	strings:
		$1 = { 94 21 FE 90 7D 80 00 26 7C 08 02 A6 93 81 01 60 7C 7C 1B 79 90 01 01 74 38 00 00 00 92 81 01 40 7D 54 53 78 93 21 01 54 7D 39 4B 78 93 41 01 58 7D 1A 43 78 93 61 01 5C 7C FB 3B 78 93 A1 01 64 7C DD 33 78 93 C1 01 68 7C BE 2B 78 93 E1 01 6C 7C 9F 23 78 91 C1 01 28 91 E1 01 2C 92 01 01 30 92 21 01 34 92 41 01 38 92 61 01 3C 92 A1 01 44 92 C1 01 48 92 E1 01 4C 93 01 01 50 91 81 01 24 90 01 00 08 41 82 04 44 88 1C 00 00 2F 80 00 00 41 9E 04 38 3E 40 ?? ?? 80 12 ?? ?? 3B 01 00 0C 2F 80 00 00 41 9C 04 8C 3B 01 00 0C 7F 03 C3 78 3C 80 00 08 4? ?? ?? ?? 80 12 ?? ?? 7C 77 1B 78 2F 80 00 00 40 9E 00 18 2F 83 FF FF 38 00 00 01 41 9E 04 94 2F 80 00 00 90 12 ?? ?? 40 9D 04 50 2F 97 00 00 41 9C 04 5C 2E 1A 00 00 3A 60 00 00 3A E0 00 00 3A 20 FF FF 3A C0 00 00 3B 01 00 90 3A 00 00 00 4? ?? ?? ?? 7C 75 1B 79 41 80 04 84 41 82 04 98 2F 93 00 00 40 9E 05 58 80 61 00 10 4? ?? ?? ?? 92 21 00 10 41 92 00 F8 38 00 00 00 90 01 01 18 80 61 00 0C 7F 04 C3 78 38 A0 00 80 4? ?? ?? ?? 2F 83 FF FF 41 9E 02 1C 2F 83 00 00 7C 6F 1B 78 40 9D 02 20 3A 60 00 00 48 00 00 5C 7E 83 A3 78 7D C4 73 78 4? ?? ?? ?? 2F 83 00 00 40 9E 02 5C 81 21 01 18 2F 89 00 02 41 9E 02 CC 38 00 00 00 90 01 01 18 80 9F 00 00 7F 43 D3 78 4B FF FD 7D 2F 83 00 01 41 9E 02 6C 92 DD 00 00 3A E0 00 00 92 DE 00 00 92 DF 00 00 3A 73 00 01 7F 8F 98 00 40 BD FF 80 7D D8 98 AE 7F 23 CB 78 7D C4 73 78 4? ?? ?? ?? 7C 60 1B 79 40 A2 FF 94 81 21 01 18 2F 89 00 03 41 9E 02 94 80 7F 00 00 2F 8E 00 0A 3A F7 00 01 41 9E 00 08 3A E0 00 00 7F C4 F3 78 7F A5 EB 78 7D C6 73 78 4B FF F3 99 2F 83 00 00 90 7F 00 00 41 9E 01 FC 38 00 00 01 90 01 01 18 4B FF FF 98 2F 83 00 00 40 9E 00 A4 80 61 00 0C 7F 04 C3 78 38 A0 00 80 4? ?? ?? ?? 2F 83 FF FF 41 9E 00 50 2F 83 00 00 7C 73 1B 78 40 9D 00 54 80 7F 00 00 7F C4 F3 78 7F A5 EB 78 7F 06 C3 78 7E 67 9B 78 4B FF F6 35 2F 83 00 00 90 7F 00 00 41 9E 01 A0 80 61 00 0C 7F 04 C3 78 38 A0 00 80 4? ?? ?? ?? 7E F7 9A 14 2F 83 FF FF 40 9E FF B8 4? ?? ?? ?? 80 03 00 00 2F 80 00 04 41 BE FF 90 3A 61 00 08 7E A3 AB 78 7E 64 9B 78 38 A0 00 01 4? ?? ?? ?? 2F 83 FF FF 40 BE FF 6C 4? ?? ?? ?? 80 03 00 00 2F 80 00 04 41 9E FF DC 80 61 00 0C 7F 04 C3 78 38 A0 00 80 4? ?? ?? ?? 2F 83 FF FF 40 9E 02 74 4? ?? ?? ?? 80 03 00 00 2F 80 00 04 41 9E FF DC 39 37 00 01 7D 29 03 A6 3A F7 FF FF 42 40 00 50 81 3E 00 00 2F 89 00 00 41 9E 00 44 81 7F 00 00 7D 4B 4A 14 88 0A FF FF 2F 80 00 0A 40 9E 00 30 39 29 FF FF 91 3E 00 00 7E 0B 49 AE 82 BE 00 00 2F 95 00 00 40 9E FF C4 80 7F 00 00 4? ?? ?? ?? 92 BD 00 00 92 BE 00 00 92 BF 00 00 80 61 00 0C 4? ?? ?? ?? 80 01 00 08 92 21 00 0C 2F 80 00 00 41 9E 01 70 3A 60 00 01 4B FF FD A4 4? ?? ?? ?? 80 03 00 00 2F 80 00 04 41 BE FD C4 3A 61 00 08 7E A3 AB 78 7E 64 9B 78 38 A0 00 01 4? ?? ?? ?? 2F 83 FF FF 40 9E 01 CC 4? ?? ?? ?? 80 03 00 00 2F 80 00 04 41 9E FF DC 80 61 00 0C 7F 04 C3 78 38 A0 00 80 4? ?? ?? ?? 2F 83 FF FF 40 9E 01 CC 4? ?? ?? ?? 80 03 00 00 2F 80 00 04 41 9E FF DC 4B FF FF 20 2F 8E 00 0A 41 9E 00 84 80 01 01 18 2F 80 00 01 41 9E 00 C4 2F 80 00 03 40 9E FD C8 80 9F 00 00 39 20 00 02 7F 43 D3 78 91 21 01 18 4B FF FB 15 2F 83 00 01 40 9E FD 9C 7E A3 AB 78 38 80 00 09 4? ?? ?? ?? 7E A3 AB 78 38 80 00 00 38 A0 00 00 4? ?? ?? ?? 2F 83 FF FF 40 9E 00 14 4? ?? ?? ?? 80 03 00 00 2F 80 00 04 41 9E FF DC 80 61 00 0C 4? ?? ?? ?? 38 60 00 01 48 00 00 88 39 20 00 00 91 21 01 18 4B FF FD 5C 81 21 01 18 2F 89 00 01 40 9E FD 50 38 00 00 03 90 01 01 18 4B FF FD 44 80 9F 00 00 7F 43 D3 78 90 01 01 1C 4B FF FA 95 2F 83 00 01 80 01 01 1C 41 BE FF 80 90 1D 00 00 38 60 00 00 90 1E 00 00 7D D8 98 AE 90 1F 00 00 4B FF FD 44 38 00 00 02 90 01 01 18 4B FF FC E0 7F 83 A8 00 38 60 00 00 40 9E 00 18 80 01 00 08 38 60 00 05 2F 80 00 00 40 9E 00 08 38 60 00 00 80 01 01 74 81 81 01 24 7C 08 03 A6 81 C1 01 28 81 E1 01 2C 7D 80 81 20 82 01 01 30 82 21 01 34 82 41 01 38 82 61 01 3C 82 81 01 40 82 A1 01 44 82 C1 01 48 82 E1 01 4C 83 01 01 50 83 21 01 54 83 41 01 58 83 61 01 5C 83 81 01 60 83 A1 01 64 83 C1 01 68 83 E1 01 6C 38 21 01 70 4E 80 00 20 40 9C FB BC 7F 03 C3 78 4? ?? ?? ?? 2F 83 00 00 40 9C FB AC 38 60 00 01 4B FF FF 88 2F 83 00 00 40 BD FD 9C 7C 73 1B 78 4B FF FC F0 2F 83 00 00 41 9E FB D8 4B FF FE 40 4? ?? ?? ?? 80 03 00 00 68 00 00 26 30 00 FF FF 7C 00 01 10 60 00 00 01 4B FF FB 58 2F 83 00 00 40 BD FD 64 7C 6F 1B 78 4B FF FB CC 80 61 00 0C 4? ?? ?? ?? 80 61 00 10 4? ?? ?? ?? 38 60 00 01 4B FF FF 28 2F 93 00 00 40 9E 00 F4 3F E0 ?? ?? 93 81 00 1C 3D 20 ?? ?? 3B FF ?? ?? 92 61 00 20 38 09 ?? ?? 93 E1 00 14 57 7B 06 F6 90 01 00 18 80 61 00 10 2F 83 00 01 41 9E 01 24 38 80 00 01 4? ?? ?? ?? 80 61 00 10 4? ?? ?? ?? 2F 9B 00 00 40 9E 00 E0 38 60 00 02 4? ?? ?? ?? 3C 60 ?? ?? 38 63 ?? ?? 38 80 00 01 4C C6 31 82 4? ?? ?? ?? 7C 7E 1B 79 41 80 00 1C 2F 9E 00 02 41 9E 00 14 38 80 00 02 4? ?? ?? ?? 7F C3 F3 78 4? ?? ?? ?? 38 60 00 03 38 80 00 02 38 A1 00 28 4? ?? ?? ?? 2F 83 00 00 40 9E 00 20 80 01 00 38 54 00 04 26 2F 80 20 00 40 9E 00 10 80 01 00 48 2F 80 00 00 41 9E 00 64 38 60 00 5A 4? ?? ?? ?? 3A 61 00 08 7E A3 AB 78 7E 64 9B 78 38 A0 00 00 4? ?? ?? ?? 2F 83 FF FF 40 BE FE 24 4? ?? ?? ?? 80 03 00 00 2F 80 00 04 41 9E FF DC 4B FF FE 2C 3F E0 ?? ?? 93 81 00 1C 3D 20 ?? ?? 3B FF ?? ?? 92 A1 00 20 38 09 ?? ?? 93 E1 00 14 3B 60 00 00 90 01 00 18 4B FF FF 10 80 01 00 4C 2F 80 01 03 40 9E FF 98 3C 60 ?? ?? 38 63 ?? ?? 4? ?? ?? ?? 80 61 00 0C 4? ?? ?? ?? 3D 20 ?? ?? 80 A9 ?? ?? 38 81 00 14 7F E3 FB 78 4? ?? ?? ?? 4? ?? ?? ?? 80 12 ?? ?? 2F 80 00 00 40 BD FE E8 38 80 00 02 38 A0 00 00 38 60 00 01 4C C6 31 82 4? ?? ?? ?? 4B FF FE D0 }
	condition:
		$1
}

rule file_143_10_0 {
	meta:
		name = "parse_backtick"
		size = 440
		refs = "00cc free"
	strings:
		$1 = { 94 21 FF C0 7C 08 02 A6 90 01 00 44 38 00 00 00 81 67 00 00 93 01 00 20 7D 38 4B 78 93 21 00 24 7D 59 53 78 93 41 00 28 7D 1A 43 78 93 61 00 2C 7C 7B 1B 78 93 81 00 30 7C 9C 23 78 93 A1 00 34 7C BD 2B 78 93 C1 00 38 7C DE 33 78 93 E1 00 3C 7C FF 3B 78 92 C1 00 18 92 E1 00 1C 7C C6 58 AE 90 01 00 0C 2F 86 00 00 90 01 00 08 90 01 00 10 41 9E 01 40 3A E0 00 00 2F 86 00 5C 41 9E 00 C8 2F 86 00 60 41 9E 00 54 2F 86 00 27 40 BE 00 08 22 F7 00 01 80 61 00 10 38 81 00 08 38 A1 00 0C 4B FF ED D1 2F 83 00 00 90 61 00 10 41 9E 00 FC 81 7F 00 00 39 6B 00 01 91 7F 00 00 7C DE 58 AE 2F 86 00 00 40 9E FF B4 80 61 00 10 4? ?? ?? ?? 3A C0 00 05 48 00 00 34 80 61 00 10 7F 64 DB 78 81 41 00 48 7F 85 E3 78 7F A6 EB 78 7F 47 D3 78 7F 08 C3 78 7F 29 CB 78 4B FF F7 E5 7C 76 1B 78 80 61 00 10 4? ?? ?? ?? 80 01 00 44 7E C3 B3 78 82 E1 00 1C 7C 08 03 A6 82 C1 00 18 83 01 00 20 83 21 00 24 83 41 00 28 83 61 00 2C 83 81 00 30 83 A1 00 34 83 C1 00 38 83 E1 00 3C 38 21 00 40 4E 80 00 20 2F 97 00 00 41 9E 00 2C 38 61 00 10 38 81 00 08 38 A1 00 0C 7F C6 F3 78 7F E7 FB 78 4B FF EE 7D 7C 76 1B 79 40 82 00 34 3A E0 00 01 4B FF FF 40 39 6B 00 01 91 7F 00 00 38 61 00 10 38 81 00 08 38 A1 00 0C 7F C6 F3 78 7F E7 FB 78 4B FF ED B9 7C 76 1B 79 41 82 FF 18 80 61 00 10 4? ?? ?? ?? 4B FF FF 64 3A C0 00 01 4B FF FF 5C 38 60 00 00 4B FF FF 18 }
	condition:
		$1
}

rule file_143_11_0 {
	meta:
		name = "parse_tilde"
		size = 1000
		refs = "0088 strchr 00f0 __strnlen 0128 memcpy 0160 __getpwnam_r 0174 __errno_location 02e8 getenv 0318 __getuid 0350 __getpwuid_r"
	strings:
		$1 = { 94 21 FF A0 7C 08 02 A6 90 01 00 64 80 04 00 00 93 61 00 4C 7C FB 3B 78 2F 80 00 00 93 81 00 50 7C BC 2B 78 93 A1 00 54 7C 9D 23 78 93 C1 00 58 7C 7E 1B 78 93 E1 00 5C 7C 3F 0B 78 92 81 00 30 92 A1 00 34 92 C1 00 38 92 E1 00 3C 93 01 00 40 93 21 00 44 93 41 00 48 41 9E 00 4C 83 43 00 00 7D 3A 02 14 88 09 FF FF 2F 80 00 3D 41 9E 00 30 2F 80 00 3A 40 9E 01 CC 7F 43 D3 78 90 DF 00 28 38 80 00 3D 91 1F 00 2C 4? ?? ?? ?? 2F 83 00 00 80 DF 00 28 81 1F 00 2C 41 9E 01 A8 2F 88 00 00 40 9E 01 A0 81 3B 00 00 3B 49 00 01 7F 59 D3 78 7C 06 C8 AE 2F 80 00 20 2B 00 00 20 41 9E 00 1C 2C 00 00 00 2C 80 00 2F 2F 80 00 5C 41 99 01 58 2F 00 00 09 40 82 01 58 7F 9A C8 00 41 9E 02 04 7F 46 D2 14 7D 29 48 F8 7C 99 4A 14 7F 43 D3 78 4? ?? ?? ?? 81 61 00 00 38 03 00 1F 54 00 00 36 7C 00 00 D0 7D 61 01 6E 7C 69 1B 78 38 00 00 00 39 61 00 17 55 6B 00 36 7C 0B 49 AE 7F 44 D3 78 7D 63 5B 78 7D 25 4B 78 4? ?? ?? ?? 80 01 00 00 7C 74 1B 78 94 01 FC 00 3B 40 03 E8 3A DF 00 0C 3B 01 00 17 57 18 00 36 3A FF 00 08 7F 46 D3 78 7F 05 C3 78 7E C4 B3 78 7E E7 BB 78 7E 83 A3 78 4? ?? ?? ?? 7F 55 D3 78 2F 83 00 00 3B 5A 03 E8 41 9E 00 6C 4? ?? ?? ?? 38 1A 00 1E 81 23 00 00 54 00 00 36 7C 00 00 D0 2F 89 00 22 40 9E 01 1C 81 21 00 00 7D 21 01 6E 38 01 00 17 54 00 00 36 7D 20 D2 14 7F 98 48 00 7C 18 03 78 40 9E FF A0 7F 5A AA 14 7F 46 D3 78 7F 05 C3 78 7E C4 B3 78 7E E7 BB 78 7E 83 A3 78 4? ?? ?? ?? 7F 55 D3 78 2F 83 00 00 3B 5A 03 E8 40 9E FF 9C 80 1F 00 08 2F 80 00 00 41 9E 00 C4 80 DF 00 20 2F 86 00 00 41 9E 00 B8 80 7E 00 00 7F A4 EB 78 7F 85 E3 78 4B FF F3 B5 90 7E 00 00 80 7E 00 00 3B 39 FF FF 93 3B 00 00 2F 83 00 00 7C 60 00 26 54 63 FF FE 48 00 00 44 2F 00 00 3A 41 A6 FE B0 41 BA FE AC 3B 39 00 01 40 9E FE 7C 80 7E 00 00 48 00 00 08 7F 43 D3 78 7F A4 EB 78 7F 85 E3 78 38 C0 00 7E 4B FF EA 69 7C 60 1B 78 90 1E 00 00 7C 63 00 34 54 63 D9 7E 39 7F 00 60 80 0B 00 04 82 8B FF D0 7C 08 03 A6 82 AB FF D4 82 CB FF D8 82 EB FF DC 83 0B FF E0 83 2B FF E4 83 4B FF E8 83 6B FF EC 83 8B FF F0 83 AB FF F4 83 CB FF F8 83 EB FF FC 7D 61 5B 78 4E 80 00 20 80 7E 00 00 7F A4 EB 78 7F 85 E3 78 38 C0 00 7E 4B FF EA 01 2F 83 00 00 90 7E 00 00 41 BE FF 44 7F A4 EB 78 7F 85 E3 78 7E 86 A3 78 4B FF F2 E1 90 7E 00 00 4B FF FF 2C 3C 60 ?? ?? 38 63 ?? ?? 4? ?? ?? ?? 7C 66 1B 79 41 82 00 28 80 7E 00 00 7F A4 EB 78 7F 85 E3 78 4B FF F2 B5 2F 83 00 00 90 7E 00 00 38 60 00 01 40 9E FF 08 4B FF FF 50 4? ?? ?? ?? 80 01 00 00 7C 78 1B 78 94 01 FC 00 3B 60 03 E8 3A DF 00 0C 3B 41 00 17 57 5A 00 36 3A FF 00 08 7F 66 DB 78 7F 45 D3 78 7E C4 B3 78 7E E7 BB 78 7F 03 C3 78 4? ?? ?? ?? 7F 79 DB 78 2F 83 00 00 3B 7B 03 E8 41 9E 00 48 4? ?? ?? ?? 38 1B 00 1E 81 23 00 00 54 00 00 36 7C 00 00 D0 2F 89 00 22 40 9E 00 44 81 21 00 00 7D 21 01 6E 38 01 00 17 54 00 00 36 7D 20 DA 14 7F 9A 48 00 7C 1A 03 78 40 9E FF A0 7F 7B CA 14 4B FF FF 98 80 1F 00 08 2F 80 00 00 41 9E 00 10 80 DF 00 20 2F 86 00 00 40 9E FF 38 80 7E 00 00 7F A4 EB 78 7F 85 E3 78 38 C0 00 7E 4B FF E8 E9 2F 83 00 00 90 7E 00 00 38 60 00 01 40 9E FE 38 4B FF FE 80 }
	condition:
		$1
}

rule file_143_12_0 {
	meta:
		name = "parse_dollars"
		size = 5744
		refs = "00f6 _GLOBAL_OFFSET_TABLE_ 00fe __libc_tsd_CTYPE_B 0326 pthread_setcancelstate 037c free 0426 _nl_current_LC_CTYPE 0510 __assert_fail 0584 strchr 0668 strtol 066e __libc_argc 082c __strdup 086c strlen 087c _itoa_word 08e6 __libc_argv 09e8 fnmatch 0d80 getenv 0de4 strspn 0e08 strcspn 1044 __setenv 1100 malloc 1118 mempcpy 1234 stpcpy 131c __getpid 13c4 __fxprintf 1556 _libc_intl_domainname 1568 __dcgettext"
	strings:
		$1 = { 94 21 FF 30 7C 08 02 A6 7D 80 00 26 90 01 00 D4 93 61 00 BC 83 67 00 00 92 01 00 90 92 41 00 98 92 81 00 A0 7D 54 53 78 92 A1 00 A4 7D 35 4B 78 92 C1 00 A8 7C B6 2B 78 92 E1 00 AC 7C 97 23 78 93 01 00 B0 7D 18 43 78 93 21 00 B4 7C 79 1B 78 93 A1 00 C4 3B BB 00 01 7E 06 EA 14 93 C1 00 C8 7C DE 33 78 93 E1 00 CC 7C FF 3B 78 91 C1 00 88 91 E1 00 8C 92 21 00 94 92 61 00 9C 93 41 00 B8 93 81 00 C0 91 81 00 84 7C 06 E8 AE 82 41 00 D8 2F 80 00 27 41 9E 01 2C 2B 80 00 27 40 9D 01 1C 2F 80 00 28 41 9E 01 B8 2F 80 00 5B 41 9E 01 98 93 BF 00 00 39 20 00 00 88 10 00 00 91 21 00 14 68 00 00 7B 7C 00 00 34 91 21 00 10 54 00 D9 7E 2E 00 00 00 91 21 00 1C 91 21 00 18 40 92 02 E0 7E 09 83 78 88 09 00 00 3A 60 00 00 2F 80 00 23 41 9E 04 5C 3E 20 ?? ?? 3A 31 ?? ?? 81 51 ?? ?? 7D 4A 12 14 81 6A 00 00 2F 8B 00 00 41 9E 15 14 88 C9 00 00 54 C0 08 3C 7C 0B 02 2E 70 09 00 04 40 82 03 00 2F 86 00 5F 41 9E 02 F8 38 06 FF D0 2B 80 00 09 41 9D 04 40 3B 80 00 00 39 E1 00 10 3B 41 00 14 7F 83 E3 78 7D E4 7B 78 7F 45 D3 78 4B FF E7 81 7C 7C 1B 79 41 82 03 BC 41 92 11 88 83 BF 00 00 3B BD 00 01 93 BF 00 00 7C DE E8 AE 38 06 FF D0 2B 80 00 09 40 9D FF CC 39 20 00 01 91 21 00 68 2F 86 00 2D 41 9E 0F C8 2B 86 00 2D 41 9D 08 7C 2F 86 00 25 41 9E 10 00 2F 86 00 2B 41 9E 0F B0 2F 86 00 23 41 9E 0F C0 39 C0 00 05 3B 40 00 00 48 00 03 68 2F 80 00 00 40 9E 01 C8 80 79 00 00 7E E4 BB 78 7E C5 B3 78 38 C0 00 24 4B FF E7 01 7C 6E 00 34 90 79 00 00 55 CE D9 7E 80 01 00 D4 7D C3 73 78 81 81 00 84 7C 08 03 A6 81 C1 00 88 81 E1 00 8C 7D 80 81 20 82 01 00 90 82 21 00 94 82 41 00 98 82 61 00 9C 82 81 00 A0 82 A1 00 A4 82 C1 00 A8 82 E1 00 AC 83 01 00 B0 83 21 00 B4 83 41 00 B8 83 61 00 BC 83 81 00 C0 83 A1 00 C4 83 C1 00 C8 83 E1 00 CC 38 21 00 D0 4E 80 00 20 3B 7B 00 02 93 67 00 00 39 20 00 01 48 00 14 21 7C 6E 1B 78 4B FF FF 88 39 5B 00 02 7C 06 50 AE 2F 80 00 28 41 9E 03 70 73 00 00 04 39 C0 00 04 40 A2 FF 6C 91 5F 00 00 7C DE 50 AE 81 61 00 DC 2F 86 00 00 90 01 00 14 31 2B FF FF 7D 29 49 10 90 01 00 18 7E B5 48 38 41 9E 02 94 3B A0 00 00 3B 60 00 01 3B 80 00 00 48 00 00 3C 2F 86 00 22 41 9E 01 48 7F A3 EB 78 38 81 00 18 38 A1 00 14 4B FF E6 0D 7C 7D 1B 79 41 82 02 78 81 3F 00 00 38 09 00 01 90 1F 00 00 7C DE 00 AE 2F 86 00 00 41 9E 02 50 2F 86 00 27 41 9E 00 E0 2B 86 00 27 40 BD FF BC 2F 86 00 28 41 9E 00 F0 2F 86 00 29 40 9E FF B4 2F 9C 00 00 40 BE FF AC 37 7B FF FF 40 82 FF A4 2F 9D 00 00 39 C0 00 00 41 BE FE C0 3D 20 ?? ?? 91 C1 00 10 38 09 ?? ?? 2F 80 00 00 41 9E 12 88 38 81 00 10 38 60 00 01 4? ?? ?? ?? 7F 24 CB 78 7F A3 EB 78 7E E5 BB 78 7E C6 B3 78 7F 07 C3 78 7E A8 AB 78 7E 89 A3 78 7E 4A 93 78 4B FF EF D9 38 80 00 00 7C 6E 1B 78 80 61 00 10 4? ?? ?? ?? 7F A3 EB 78 4? ?? ?? ?? 4B FF FE 60 2F 80 00 22 41 BE FE 38 93 BF 00 00 39 20 00 00 88 10 00 00 91 21 00 14 68 00 00 7B 7C 00 00 34 91 21 00 10 54 00 D9 7E 2E 00 00 00 91 21 00 1C 91 21 00 18 41 B2 FD 28 3B BD 00 01 93 BF 00 00 7D 3E EA 14 4B FF FD 1C 2F 9C 00 00 41 9E 00 48 2F 9C 00 01 41 9E 00 0C 3B 80 00 02 4B FF FE D8 3B 80 00 00 4B FF FE D0 20 1C 00 00 7C 1B 01 94 7C 1B 03 78 4B FF FE C0 2F 9C 00 00 41 BE FF DC 6B 9C 00 02 7F 9C 00 34 57 9C D9 7E 23 9C 00 01 4B FF FE A4 3B 80 00 01 4B FF FE 9C 81 D1 ?? ?? 82 31 ?? ?? 3B 80 00 00 39 E1 00 10 3B 41 00 14 7D CE 12 14 7E 31 12 14 7F 83 E3 78 7D E4 7B 78 7F 45 D3 78 4B FF E4 89 7C 7C 1B 79 41 82 00 C4 81 2E 00 00 2F 89 00 00 41 9E 0F C4 83 BF 00 00 3B BD 00 01 93 BF 00 00 7C DE E8 AE 54 C0 08 3C 7C 09 02 2E 70 0B 08 00 40 A2 FF C0 2F 86 00 5F 41 9E FF B8 38 00 00 00 90 01 00 68 40 92 01 C4 39 60 00 00 91 61 00 6C 3A 20 00 00 3B 40 00 00 3B BD FF FF 93 BF 00 00 88 10 00 00 2F 80 00 7B 41 9E 01 88 2F 9C 00 00 41 9E 0A 38 89 3C 00 00 38 09 FF D0 2B 80 00 09 40 9D 01 90 81 61 00 68 2F 8B 00 00 41 9E 08 A4 2F 89 00 24 41 9E 0E 30 2F 89 00 2A 41 9E 08 24 2F 09 00 40 41 9A 08 1C 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 05 DA 38 C6 ?? ?? 4? ?? ?? ?? 39 C0 00 01 3B 40 00 00 7F 83 E3 78 4? ?? ?? ?? 7F 43 D3 78 4? ?? ?? ?? 4B FF FC B4 3B A0 00 00 7F A3 EB 78 4? ?? ?? ?? 39 C0 00 05 4B FF FC A0 39 C0 00 01 4B FF FC 98 40 92 00 78 39 60 00 00 38 00 00 00 91 61 00 68 3A 60 00 01 90 01 00 6C 3A 20 00 00 3B 40 00 00 3B 80 00 00 4B FF FF 3C 3C 60 ?? ?? 90 C1 00 70 7C C4 33 78 38 63 ?? ?? 4? ?? ?? ?? 80 C1 00 70 2F 83 00 00 41 9E 09 D4 38 60 00 00 38 81 00 10 38 A1 00 14 4B FF E3 31 7C 7C 1B 79 41 A2 FF 6C 83 BF 00 00 39 60 00 01 91 61 00 68 3B BD 00 01 93 BF 00 00 4B FF FE D0 3B BD 00 01 93 BF 00 00 7D 3E EA 14 3A 60 00 01 4B FF FB 20 3B 7B 00 03 7C 06 D8 AE 2F 80 00 00 41 BE FC 88 7F 69 DB 78 7F 68 DB 78 39 60 00 00 48 00 00 28 68 00 00 29 7C 00 00 34 54 00 D9 7E 7D 60 58 50 39 29 00 01 7C 1E 48 AE 7D 28 4B 78 2F 80 00 00 41 BE FC 54 2F 8B 00 00 40 9E 00 0C 2F 80 00 29 41 9E 09 00 2F 80 00 28 40 9E FF C8 39 6B 00 01 4B FF FF D0 80 1F 00 00 39 C0 00 05 7C 1E 00 AE 2F 80 00 7D 40 9E FE D0 4B FF FE 68 7C DE E8 AE 4B FF FB 2C 7F 83 E3 78 38 80 00 00 38 A0 00 0A 4? ?? ?? ?? 3D 20 ?? ?? 80 09 ?? ?? 7F 83 00 00 41 9C 09 10 73 09 00 20 39 C0 00 03 40 A2 FE 98 3B A0 00 00 3B C0 00 00 2F 91 00 00 41 9E 03 70 3B 71 FF DD 2B 9B 00 2F 40 9D 00 24 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 06 29 38 C6 ?? ?? 4? ?? ?? ?? 3D 20 ?? ?? 39 29 ?? ?? 57 60 10 3A 7C 09 00 2E 7D 20 4A 14 7D 29 03 A6 4E 80 04 20 2F 9E 00 00 41 9E 00 1C 88 1E 00 00 2F 80 00 00 40 9E 00 A8 80 01 00 6C 2F 80 00 00 41 9E 00 9C 2F 9A 00 00 38 00 00 00 90 01 00 28 90 01 00 24 90 01 00 20 41 9E 00 78 88 1A 00 00 2F 80 00 00 41 9E 00 6C 7F 5F D3 78 3A 00 00 00 39 E0 00 01 2F 80 00 2A 41 9E 02 68 2B 80 00 2A 41 9D 02 48 2F 80 00 24 41 9E 05 60 2F 80 00 27 41 9E 05 40 2F 80 00 22 41 9E 00 6C 80 61 00 20 88 DF 00 00 38 81 00 24 38 A1 00 28 4B FF E1 69 2F 83 00 00 90 61 00 20 41 9E 02 08 37 FF 00 01 41 82 00 10 88 1F 00 00 2F 80 00 00 40 9E FF A8 7F 43 D3 78 4? ?? ?? ?? 83 41 00 20 2B 9B 00 2F 40 9D 08 00 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 07 76 38 C6 ?? ?? 4? ?? ?? ?? 2F 90 00 02 41 9E 09 84 2F 90 00 00 40 BE FF 8C 3A 00 00 02 4B FF FF A4 2F 9E 00 00 41 BE FF BC 88 1E 00 00 70 09 00 FF 40 A2 FF 18 81 61 00 6C 2F 8B 00 00 41 BE FF 0C 54 00 06 3E 2F 80 00 00 40 9E 00 10 81 61 00 6C 2F 8B 00 00 40 9E 07 D0 2F 9D 00 00 41 BE 00 0C 7F C3 F3 78 4? ?? ?? ?? 2E 1A 00 00 41 92 0B F4 7F 43 D3 78 4? ?? ?? ?? 2E 03 00 00 7C 7E 1B 78 41 92 01 44 3B A0 00 01 7F 83 E3 78 4? ?? ?? ?? 7F 43 D3 78 4? ?? ?? ?? 2F 93 00 00 41 9E 05 44 38 00 00 00 98 01 00 5C 83 F9 00 00 41 92 0B 18 7F C3 F3 78 4? ?? ?? ?? 38 81 00 5C 38 A0 00 0A 38 C0 00 00 4? ?? ?? ?? 7E E4 BB 78 7C 66 1B 78 7E C5 B3 78 7F E3 FB 78 4B FF E9 3D 2F 9D 00 00 90 79 00 00 41 9E 00 14 41 92 0D A0 7F C3 F3 78 4? ?? ?? ?? 80 79 00 00 7C 6E 00 34 55 CE D9 7E 4B FF F9 28 2F 89 00 40 40 BE FC 34 80 01 00 DC 2F 80 00 00 41 9E 09 00 3D 20 ?? ?? 80 09 ?? ?? 2F 80 00 02 41 9E 0B 14 40 9D 0B 20 3F E0 ?? ?? 80 79 00 00 81 3F ?? ?? 7E E4 BB 78 7E C5 B3 78 80 C9 00 04 4B FF E8 D1 7C 64 1B 79 41 82 00 78 7E A3 AB 78 4B FF E9 3D 39 C0 00 01 2F 83 00 00 40 BE FC 04 81 3F ?? ?? 80 09 00 0C 2F 80 00 00 41 9E 0B 10 3B A0 00 10 38 00 00 02 3B C0 00 02 48 00 00 30 7E A3 AB 78 4B FF E9 09 2F 83 00 00 40 9E 00 34 81 3F ?? ?? 3B DE 00 01 7F C0 F3 78 7D 69 E8 2E 3B BD 00 04 2F 8B 00 00 41 9E 0A D8 54 00 10 3A 7C 69 00 2E 4? ?? ?? ?? 7C 64 1B 79 40 82 FF C4 39 C0 00 01 4B FF FB 9C 2F 80 00 5C 41 9E 02 D0 2F 80 00 7E 41 9E 02 78 2F 80 00 3F 40 9E FD C0 2F 90 00 00 40 9E 09 98 80 61 00 20 88 DF 00 00 4B FF FD B4 7F 9E F8 40 41 BD FE 8C 7F DB F3 78 3A 20 00 00 48 00 00 14 9B 1B 00 00 3B 7B 00 01 7F 9F D8 40 41 BC FE 70 8B 1B 00 00 7F 43 D3 78 9A 3B 00 00 7F C4 F3 78 38 A0 00 00 4? ?? ?? ?? 2F 83 00 01 41 9E FF D4 2F 9D 00 00 9B 1B 00 00 40 9E 0C 00 7F 7E DB 78 2E 1E 00 00 4B FF FE 38 2F 86 00 3D 41 9E 07 40 2B 86 00 3D 41 9D 08 98 2F 86 00 3A 40 9E F7 8C 3B 5D 00 01 7C 9E D0 AE 3C 60 ?? ?? 38 63 ?? ?? 4? ?? ?? ?? 2F 83 00 00 41 BE F7 70 93 5F 00 00 38 00 00 01 3B BD 00 02 7E 3E D0 AE 7D 3E EA 14 90 01 00 6C 93 BF 00 00 88 09 00 00 2F 80 00 00 41 9E 09 F4 39 20 00 00 39 60 00 00 91 21 00 64 3B 40 00 00 91 61 00 60 48 00 00 54 2F 80 00 22 41 9E 01 34 2F 80 00 27 41 9E 00 DC 39 C1 00 18 39 E1 00 1C 80 1F 00 00 7F 43 D3 78 7D C4 73 78 7C DE 00 AE 7D E5 7B 78 4B FF DE 25 7C 7A 1B 79 41 A2 FE C8 83 BF 00 00 3B BD 00 01 93 BF 00 00 7C 1E E8 AE 2F 80 00 00 41 BE F9 D8 2F 80 00 5C 41 9E 00 48 2B 80 00 5C 40 BD FF A4 2F 80 00 7B 41 9E 00 AC 2F 80 00 7D 40 9E FF A4 81 61 00 60 39 C1 00 18 39 E1 00 1C 2F 8B 00 00 40 BE FF 98 81 21 00 64 2F 89 00 00 41 BE F9 A0 39 29 FF FF 91 21 00 64 4B FF FF 80 81 61 00 60 39 C1 00 18 39 E1 00 1C 2F 8B 00 00 40 BE FF 6C 3B BD 00 01 93 BF 00 00 7C 1E E8 AE 2F 80 00 00 41 9E 08 58 7F 43 D3 78 7D C4 73 78 7D E5 7B 78 38 C0 00 5C 4B FF DD 7D 7C 7A 1B 79 40 82 FF 3C 39 C0 00 01 4B FF F9 B8 80 01 00 60 2F 80 00 00 41 9E 00 70 2F 80 00 01 41 9E 01 74 39 20 00 02 91 21 00 60 39 C1 00 18 39 E1 00 1C 4B FF FF 0C 80 01 00 60 39 C1 00 18 81 21 00 64 39 E1 00 1C 2F 80 00 00 7C 00 00 26 54 00 FF FE 7D 29 02 14 91 21 00 64 4B FF FE E4 81 61 00 60 2F 8B 00 00 41 9E 00 34 2F 8B 00 02 41 9E 01 38 38 00 00 01 90 01 00 60 39 C1 00 18 39 E1 00 1C 4B FF FE BC 39 20 00 01 91 21 00 60 39 C1 00 18 39 E1 00 1C 4B FF FE A8 38 00 00 02 90 01 00 60 39 C1 00 18 39 E1 00 1C 4B FF FE 94 2F 90 00 00 40 BE FB 4C 80 01 00 24 2F 80 00 00 40 9E FB 40 38 61 00 20 92 01 00 2C 38 81 00 24 38 A1 00 28 7F E6 FB 78 38 E1 00 2C 39 00 00 00 4B FF EF E1 7C 6E 1B 79 41 82 00 A0 2F 9D 00 00 40 9E 07 28 80 61 00 20 4? ?? ?? ?? 4B FF F8 C8 80 61 00 20 38 C0 00 5C 38 81 00 24 38 A1 00 28 4B FF DC 69 90 61 00 20 8C DF 00 01 2F 86 00 00 41 9E 08 FC 2F 83 00 00 40 9E FA E0 39 C0 00 01 4B FF F8 94 2F 90 00 01 41 9E 04 B8 2F 90 00 00 40 BE FD 0C 3A 00 00 01 4B FF FA D8 38 00 00 00 91 E1 00 0C 38 61 00 20 38 81 00 24 90 01 00 2C 38 A1 00 28 7F E6 FB 78 90 01 00 08 38 E1 00 2C 7F 08 C3 78 39 20 00 00 39 40 00 00 4B FF F3 2D 7C 6E 1B 79 40 A2 FF 68 80 01 00 2C 7F FF 02 14 4B FF FA 90 39 60 00 00 91 61 00 60 39 C1 00 18 39 E1 00 1C 4B FF FD 9C 39 20 00 00 91 21 00 60 4B FF FD 88 2F 13 00 00 41 9A 04 B8 3D 20 ?? ?? 81 29 ?? ?? 38 00 00 00 98 01 00 44 38 60 00 00 2F 89 00 00 40 9D 00 08 38 69 FF FF 38 81 00 44 38 A0 00 0A 38 C0 00 00 4? ?? ?? ?? 7E E4 BB 78 7C 66 1B 78 80 79 00 00 7E C5 B3 78 4B FF E4 79 90 79 00 00 7F 83 E3 78 4? ?? ?? ?? 7F 43 D3 78 4? ?? ?? ?? 81 D9 00 00 7D CE 00 34 55 CE D9 7E 4B FF F4 68 7F 83 E3 78 4? ?? ?? ?? 7C 7E 1B 78 2E 1E 00 00 3B A0 00 00 40 92 F9 00 4B FF F8 E8 41 92 05 F8 81 21 00 DC 2F 89 00 00 40 9E 04 E8 2F 95 00 00 41 9E 04 E0 7F C3 F3 78 4? ?? ?? ?? 2F 9D 00 00 7C 7B 1B 78 40 9E 05 C4 2F 9B 00 00 41 9E 06 18 7F 7F DB 78 3B A0 00 00 3B 80 00 00 3B 40 00 00 7F E3 FB 78 7E 44 93 78 4? ?? ?? ?? 2F 9D 00 00 7F DF 1A 14 40 9E 00 10 7C 1F 18 AE 2F 80 00 00 41 9E 05 64 7E 84 A3 78 7F C3 F3 78 4? ?? ?? ?? 7E 44 93 78 7F FE 1A 14 7C 78 1B 78 7F E3 FB 78 4? ?? ?? ?? 3B A0 00 00 7C 9F 18 AE 7F FF 1A 14 2F 84 00 00 41 9E 00 1C 7E 83 A3 78 4? ?? ?? ?? 2F 83 00 00 41 9E 00 0C 3B FF 00 01 3B A0 00 01 7F 5E C1 AE 7E E4 BB 78 7E C5 B3 78 80 79 00 00 7F C6 F3 78 4B FF E3 6D 2F 83 00 00 90 79 00 00 7C 64 1B 78 41 9E 00 60 2F 9D 00 00 40 9E 00 50 88 1F 00 00 2F 80 00 00 41 9E 04 DC 7F 9B F8 00 41 BE FF 50 7E A3 AB 78 4B FF E3 B5 2F 83 00 01 41 9E 00 40 93 96 00 00 7F E3 FB 78 7E 44 93 78 93 97 00 00 93 99 00 00 4? ?? ?? ?? 2F 9D 00 00 7F DF 1A 14 40 BE FF 40 4B FF FF 30 3B A0 00 01 4B FF FF BC 88 1E 00 00 2F 80 00 00 41 9E FF 9C 7F 63 DB 78 4? ?? ?? ?? 39 C0 00 01 3B 40 00 00 3B 80 00 00 4B FF F6 2C 2F 93 00 00 41 9E 04 08 3D 20 ?? ?? 7C 24 0B 78 80 69 ?? ?? 9F 84 00 44 38 A0 00 0A 38 63 FF FF 38 C0 00 00 4? ?? ?? ?? 3A 60 00 00 7C 7E 1B 78 4B FF FE 64 7D 1E 42 14 88 08 00 01 2F 80 00 29 40 9E F3 38 93 7F 00 00 7F 23 CB 78 7E E4 BB 78 7E C5 B3 78 7F C6 F3 78 7F E7 FB 78 7F 08 C3 78 39 20 00 00 48 00 07 19 7C 6E 1B 78 4B FF F2 80 40 92 03 70 38 00 00 00 39 20 00 00 90 01 00 68 3B 80 00 00 91 21 00 6C 3A 20 00 00 3B 40 00 00 4B FF F5 20 3D 20 ?? ?? 81 29 ?? ?? 54 63 10 3A 7F C9 18 2E 4B FF FD F0 3D 20 ?? ?? 39 29 ?? ?? 57 7B 10 3A 7C 09 D8 2E 7D 20 4A 14 7D 29 03 A6 4E 80 04 20 2E 1E 00 00 41 92 00 10 88 1E 00 00 2F 80 00 00 40 BE F8 78 80 01 00 6C 2F 80 00 00 40 9E 03 CC 41 92 03 C8 2F 9D 00 00 39 C0 00 00 41 9E F5 38 7F C3 F3 78 4? ?? ?? ?? 4B FF F5 2C 2E 1E 00 00 41 92 00 10 88 1E 00 00 }
	condition:
		$1
}

rule file_143_13_0 {
	meta:
		name = "parse_arith"
		size = 1004
		refs = "00b8 free 02f4 _itoa_word 038c _itoa"
	strings:
		$1 = { 94 21 FF 90 7C 08 02 A6 90 01 00 74 38 00 00 00 81 67 00 00 92 C1 00 48 7C 96 23 78 92 E1 00 4C 7C B7 2B 78 93 01 00 50 7C 78 1B 78 93 41 00 58 7D 3A 4B 78 93 81 00 60 7D 1C 43 78 93 C1 00 68 7C DE 33 78 93 E1 00 6C 7C FF 3B 78 92 A1 00 44 93 21 00 54 93 61 00 5C 93 A1 00 64 7C C6 58 AE 90 01 00 14 2F 86 00 00 90 01 00 10 90 01 00 18 41 9E 02 B8 3B A0 00 01 3B 60 00 00 3B 20 00 01 2F 86 00 5C 41 9E 02 08 2B 86 00 5C 41 9D 00 70 2F 86 00 28 41 9E 01 F0 2B 86 00 28 40 9D 00 D0 2F 86 00 29 41 9E 01 54 2F 86 00 3B 40 BE 00 68 80 61 00 18 3A A0 00 02 4? ?? ?? ?? 80 01 00 74 7E A3 AB 78 82 C1 00 48 7C 08 03 A6 82 A1 00 44 82 E1 00 4C 83 01 00 50 83 21 00 54 83 41 00 58 83 61 00 5C 83 81 00 60 83 A1 00 64 83 C1 00 68 83 E1 00 6C 38 21 00 70 4E 80 00 20 2F 86 00 60 41 9E 00 BC 2B 86 00 60 41 9D 00 50 2F 86 00 5D 41 9E 01 18 80 61 00 18 38 81 00 10 38 A1 00 14 4B FF D1 41 2F 83 00 00 90 61 00 18 41 9E 00 F4 81 7F 00 00 39 6B 00 01 91 7F 00 00 7C DE 58 AE 2F 86 00 00 40 9E FF 3C 80 61 00 18 4? ?? ?? ?? 3A A0 00 05 4B FF FF 68 2F 86 00 7B 41 BE FF 54 2F 86 00 7D 40 9E FF B0 4B FF FF 48 2F 86 00 0A 41 BE FF 40 2F 86 00 24 40 9E FF 9C 38 61 00 18 93 61 00 08 38 81 00 10 38 A1 00 14 93 21 00 0C 7F C6 F3 78 7F E7 FB 78 7F 88 E3 78 39 20 00 00 39 40 00 00 4B FF E7 ED 7C 75 1B 79 41 82 FF 84 80 61 00 18 4? ?? ?? ?? 4B FF FF 04 39 6B 00 01 91 7F 00 00 38 61 00 18 38 81 00 10 38 A1 00 14 93 61 00 08 7F C6 F3 78 7F E7 FB 78 7F 88 E3 78 39 20 00 00 39 40 00 00 4B FF E2 09 7C 75 1B 79 41 82 FF 40 4B FF FF BC 37 BD FF FF 41 82 01 34 80 61 00 18 38 81 00 10 38 A1 00 14 38 C0 00 29 4B FF D0 51 2F 83 00 00 90 61 00 18 40 9E FF 14 3A A0 00 01 4B FF FE 98 2F 9A 00 00 41 9E 00 0C 2F 9D 00 01 41 9E 00 7C 80 61 00 18 3A A0 00 05 4? ?? ?? ?? 80 01 00 74 7E A3 AB 78 82 C1 00 48 7C 08 03 A6 82 A1 00 44 82 E1 00 4C 83 01 00 50 83 21 00 54 83 41 00 58 83 61 00 5C 83 81 00 60 83 A1 00 64 83 C1 00 68 83 E1 00 6C 38 21 00 70 4E 80 00 20 3B BD 00 01 4B FF FE 8C 38 61 00 18 38 81 00 10 38 A1 00 14 7F C6 F3 78 7F E7 FB 78 4B FF D1 2D 7C 75 1B 79 41 82 FE 88 4B FF FF 04 38 00 00 00 80 61 00 18 90 01 00 1C 88 03 00 00 2F 80 00 00 41 9E 00 14 38 81 00 1C 4B FF D6 F5 2F 83 00 00 40 BE FF 64 80 61 00 1C 38 C0 00 00 83 F8 00 00 38 00 00 00 38 81 00 34 98 01 00 34 38 A0 00 0A 4? ?? ?? ?? 7C 66 1B 78 7F E3 FB 78 7E C4 B3 78 7E E5 BB 78 4B FF D8 55 90 78 00 00 80 61 00 18 4? ?? ?? ?? 82 B8 00 00 7E B5 00 34 56 B5 D9 7E 4B FF FD 98 38 60 00 00 4B FF FE 20 2F 9A 00 00 93 A1 00 1C 40 BE FF 00 39 6B 00 01 7C 1E 58 AE 2F 80 00 29 40 9E FE F0 91 7F 00 00 80 61 00 18 88 03 00 00 2F 80 00 00 40 9E 00 40 83 E1 00 1C 2F 9F 00 00 7F E3 FE 70 41 9C 00 44 7C 25 0B 78 38 00 00 00 9C 05 00 34 38 C0 00 0A 38 E0 00 00 83 D8 00 00 7F E4 FB 78 4? ?? ?? ?? 7C 66 1B 78 7F C3 F3 78 4B FF FF 68 38 81 00 1C 4B FF D6 21 2F 83 00 00 41 BE FF B8 4B FF FE 8C 80 78 00 00 7E C4 B3 78 7E E5 BB 78 38 C0 00 2D 4B FF CE A1 2F 83 00 00 90 78 00 00 41 9E 00 10 7F FF 00 D0 7F E3 FE 70 4B FF FF 98 80 61 00 18 3A A0 00 01 4? ?? ?? ?? 4B FF FC D4 }
	condition:
		$1
}

rule file_143_14_0 {
	meta:
		name = "wordfree"
		size = 124
		refs = "0040 free"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 93 C1 00 08 7C 7E 1B 79 90 01 00 14 93 E1 00 0C 41 82 00 4C 81 3E 00 04 2F 89 00 00 41 9E 00 40 83 FE 00 08 57 FF 10 3A 7C 69 F8 2E 7F E9 FA 14 2F 83 00 00 41 9E 00 18 4? ?? ?? ?? 84 7F 00 04 2F 83 00 00 40 9E FF F4 81 3E 00 04 7D 23 4B 78 4? ?? ?? ?? 38 00 00 00 90 1E 00 04 80 01 00 14 83 C1 00 08 7C 08 03 A6 83 E1 00 0C 38 21 00 10 4E 80 00 20 }
	condition:
		$1
}

rule file_143_15_0 {
	meta:
		name = "wordexp"
		size = 2592
		refs = "00ac calloc 00c8 getenv 01dc strchr 0344 glob 03f4 globfree 041c wordfree 04b4 free 0504 __strdup 0998 __assert_fail"
	strings:
		$1 = { 94 21 FF 60 7C 08 02 A6 7D 80 00 26 90 01 00 A4 70 A0 00 08 38 00 00 00 81 24 00 04 81 44 00 00 81 64 00 08 92 C1 00 78 7D 36 4B 78 93 21 00 84 7C B9 2B 78 93 C1 00 98 7C 9E 23 78 93 E1 00 9C 7C 7F 1B 78 92 41 00 68 92 61 00 6C 92 81 00 70 92 A1 00 74 92 E1 00 7C 93 01 00 80 93 41 00 88 93 61 00 8C 93 81 00 90 93 A1 00 94 91 81 00 64 90 01 00 18 90 01 00 14 90 01 00 1C 91 41 00 24 91 21 00 28 91 61 00 2C 40 82 09 20 57 20 07 BC 2D 80 00 00 40 8E 00 2C 73 3D 00 01 90 1E 00 00 40 82 08 8C 38 60 00 01 38 80 00 04 4? ?? ?? ?? 2F 83 00 00 90 7E 00 04 41 9E 05 8C 93 BE 00 08 3C 60 ?? ?? 38 63 ?? ?? 4? ?? ?? ?? 7C 7B 1B 79 41 82 08 8C 89 7B 00 00 3B A1 00 20 7F AA EB 78 2F 8B 00 00 41 9E 00 98 3B A1 00 20 7F 68 DB 78 7F AA EB 78 48 00 00 20 2F 8B 00 09 41 9E 00 20 2F 8B 00 0A 41 9E 00 18 8D 68 00 01 2F 8B 00 00 41 9E 00 6C 2F 8B 00 20 40 9E FF E0 7F 8A E8 40 7F A9 EB 78 40 9D 00 3C 88 01 00 20 7F 80 58 00 41 9E 00 30 38 1D 00 01 7F 8A 00 40 7C 1D 50 50 7C 09 03 A6 40 BC 00 14 48 00 08 AC 88 09 00 00 7F 80 58 00 41 9E 00 0C 39 29 00 01 42 00 FF F0 7F 89 50 00 40 9E FF A4 99 6A 00 00 39 4A 00 01 8D 68 00 01 2F 8B 00 00 40 9E FF 9C 38 00 00 00 98 0A 00 00 8B 9F 00 00 38 00 00 00 90 01 00 10 2F 9C 00 00 41 9E 02 A4 57 37 07 7A 3F 00 ?? ?? 3E A0 ?? ?? 2E 17 00 00 39 20 00 00 3B 40 00 00 3B 18 ?? ?? 3A B5 ?? ?? 48 00 00 70 2F 9C 00 24 41 9E 05 60 2B 9C 00 24 41 9D 04 24 2F 9C 00 22 41 9E 05 8C 7F 03 C3 78 7F 84 E3 78 4? ?? ?? ?? 2F 83 00 00 41 9E 04 2C 80 81 00 1C 2F 84 00 00 41 9E 00 14 7F C3 F3 78 4B FF D5 79 7C 74 1B 79 40 82 03 90 93 41 00 18 93 41 00 14 93 41 00 1C 81 21 00 10 39 29 00 01 7F 9F 48 AE 91 21 00 10 2F 9C 00 00 41 9E 02 14 2F 9C 00 3F 41 9E 00 24 2B 9C 00 3F 40 BD FF 88 2F 9C 00 5C 41 9E 05 E4 2B 9C 00 5C 41 9D 03 6C 2F 9C 00 5B 40 9E FF 88 82 41 00 10 93 41 00 30 7E 7F 90 AE 93 41 00 34 2F 93 00 00 93 41 00 38 41 9E 00 8C 3A 80 00 01 3B 80 00 00 7F 63 DB 78 7E 64 9B 78 4? ?? ?? ?? 2F 83 00 00 40 9E 00 70 2F 93 00 27 41 9E 02 C4 2F 93 00 22 41 9E 03 04 2F 9C 00 01 41 9E 00 0C 2F 93 00 24 41 9E 06 38 2F 93 00 5C 40 9E 02 B4 2F 9C 00 00 41 9E 05 F8 38 61 00 1C 38 81 00 14 38 A1 00 18 7F E6 FB 78 38 E1 00 10 4B FF CC 99 7C 74 1B 78 2F 94 00 00 40 9E 02 44 82 41 00 10 3A 52 00 01 7E 7F 90 AE 92 41 00 10 2F 93 00 00 40 9E FF 84 80 81 00 1C 3A 52 FF FF 38 61 00 30 92 41 00 10 4B FF D4 6D 7C 74 1B 79 93 41 00 18 93 41 00 14 93 41 00 1C 40 82 02 04 80 01 00 30 2F 80 00 00 41 9E 00 F4 3A 60 00 01 3A 80 00 00 81 21 00 34 38 80 00 10 38 A0 00 00 7C 69 A0 2E 38 C1 00 3C 4? ?? ?? ?? 7C 7C 1B 79 40 82 06 28 88 1B 00 00 2F 80 00 00 40 9E 01 50 81 21 00 40 80 C9 00 00 2F 86 00 00 41 9E 06 98 80 61 00 1C 38 81 00 14 38 A1 00 18 4B FF D3 7D 80 01 00 3C 90 61 00 1C 2B 80 00 01 40 9D 00 68 2F 83 00 00 41 9E 00 60 3B 80 00 01 48 00 00 10 80 61 00 1C 2F 83 00 00 41 9E 00 4C 38 81 00 14 38 A1 00 18 38 C0 00 20 4B FF CA 45 2F 83 00 00 90 61 00 1C 41 9E 00 20 81 21 00 40 57 80 10 3A 38 81 00 14 7C C9 00 2E 38 A1 00 18 4B FF D3 1D 90 61 00 1C 80 01 00 3C 3B 9C 00 01 7F 9C 00 40 41 9C FF B0 38 61 00 3C 4? ?? ?? ?? 80 01 00 1C 2F 80 00 00 41 9E 01 18 80 01 00 30 3A 94 00 04 7F 80 98 40 3A 73 00 01 41 9D FF 1C 38 61 00 30 4? ?? ?? ?? 81 21 00 10 39 29 00 01 7F 9F 48 AE 91 21 00 10 2F 9C 00 00 40 9E FD F4 80 81 00 1C 3A 80 00 00 2F 84 00 00 41 9E 00 10 7F C3 F3 78 4B FF D3 25 7C 74 1B 78 80 01 00 A4 7E 83 A3 78 81 81 00 64 7C 08 03 A6 82 41 00 68 82 61 00 6C 7D 81 81 20 82 81 00 70 82 A1 00 74 82 C1 00 78 82 E1 00 7C 83 01 00 80 83 21 00 84 83 41 00 88 83 61 00 8C 83 81 00 90 83 A1 00 94 83 C1 00 98 83 E1 00 9C 38 21 00 A0 4E 80 00 20 80 61 00 1C 2F 83 00 00 41 9E 00 14 4? ?? ?? ?? 93 81 00 18 93 81 00 14 93 81 00 1C 80 01 00 3C 2F 80 00 00 41 9E 04 D0 3B 80 00 00 48 00 00 24 7F C3 F3 78 4B FF D2 95 2F 83 00 00 40 9E 00 2C 80 01 00 3C 3B 9C 00 01 7F 9C 00 40 40 9C 04 A8 81 21 00 40 57 80 10 3A 7C 69 00 2E 4? ?? ?? ?? 7C 64 1B 79 40 82 FF CC 38 61 00 3C 4? ?? ?? ?? 3A 80 00 01 38 61 00 30 4? ?? ?? ?? 80 61 00 1C 4? ?? ?? ?? 2F 94 00 01 41 BE FF 24 41 8E 04 84 80 01 00 2C 81 21 00 24 92 DE 00 04 91 3E 00 00 90 1E 00 08 4B FF FF 08 2F 9C 00 00 41 9E 03 78 2F 9C 00 01 41 9E 00 4C 80 61 00 1C 38 81 00 14 38 A1 00 18 7E 66 9B 78 4B FF C8 89 2F 83 00 00 90 61 00 1C 40 9E FD 60 38 61 00 30 4? ?? ?? ?? 2F 94 00 00 41 9E FC 84 80 61 00 1C 4B FF FF 94 2F 9C 00 00 41 9E 03 38 2F 9C 00 02 40 9E FC F4 3B 80 00 00 4B FF FD 34 2F 9C 00 60 41 9E 00 A0 2F 9C 00 7E 40 9E FC 18 81 1E 00 00 38 61 00 1C 38 81 00 14 38 A1 00 18 7F E6 FB 78 38 E1 00 10 4B FF DB 69 7C 74 1B 79 41 82 FC 30 80 61 00 1C 4B FF FF 40 2F 9C 00 27 41 9E 00 A8 2F 9C 00 2A 41 BE FC 58 7F 03 C3 78 7F 84 E3 78 4? ?? ?? ?? 2F 83 00 00 40 9E FB DC 7E A3 AB 78 7F 84 E3 78 4? ?? ?? ?? 2F 83 00 00 40 9E 03 CC 80 61 00 1C 38 81 00 14 38 A1 00 18 7F 86 E3 78 4B FF C7 C5 2F 83 00 00 90 61 00 1C 40 9E FB D0 80 61 00 1C 3A 80 00 01 4? ?? ?? ?? 4B FF FE 04 40 92 03 70 38 09 00 01 93 A1 00 08 38 61 00 1C 38 81 00 14 90 01 00 10 38 A1 00 18 7F E6 FB 78 38 E1 00 10 7F 28 CB 78 7F C9 F3 78 7F 6A DB 78 4B FF D9 05 7C 74 1B 79 41 82 FB 84 80 61 00 1C 4B FF FE 94 39 29 00 01 7C DF 48 AE 91 21 00 10 2F 86 00 00 41 9E 02 78 2F 86 00 27 41 9E 00 4C 80 61 00 1C 48 00 00 24 81 21 00 10 38 09 00 01 7C DF 00 AE 90 01 00 10 2F 86 00 00 41 9E 02 54 2F 86 00 27 41 9E 00 24 38 81 00 14 38 A1 00 18 4B FF C7 15 2F 83 00 00 90 61 00 1C 40 9E FF CC 3A 80 00 01 4B FF FE 30 80 01 00 14 2F 80 00 00 40 9E FB 0C 7F C3 F3 78 38 80 00 00 4B FF D0 61 7C 74 1B 79 41 82 FA F8 4B FF FD 38 38 61 00 1C 93 A1 00 08 38 81 00 14 38 A1 00 18 93 41 00 0C 7F E6 FB 78 38 E1 00 10 7F 28 CB 78 7F C9 F3 78 7F 6A DB 78 4B FF DD E1 7C 74 1B 79 41 82 FA C0 80 61 00 1C 4B FF FD D0 39 29 00 01 7C DF 48 AE 91 21 00 10 2F 86 00 00 41 9E 00 54 3B 80 00 01 2F 86 00 24 41 9E 00 F8 2B 86 00 24 41 9D 00 4C 2F 86 00 22 41 BE FF 74 80 61 00 1C 38 81 00 14 38 A1 00 18 4B FF C6 61 2F 83 00 00 90 61 00 1C 41 9E 02 30 81 21 00 10 39 29 00 01 7C DF 48 AE 91 21 00 10 2F 86 00 00 40 9E FF B8 3A 80 00 05 80 61 00 1C 4B FF FD 60 2F 86 00 5C 41 9E 00 78 2F 86 00 60 40 9E FF B4 40 92 02 04 38 09 00 01 92 E1 00 08 38 61 00 1C 38 81 00 14 90 01 00 10 38 A1 00 18 7F E6 FB 78 38 E1 00 10 7F 28 CB 78 39 20 00 00 39 40 00 00 4B FF D7 7D 7C 74 1B 79 41 82 FF 94 80 61 00 1C 4B FF FD 0C 38 61 00 1C 38 81 00 14 38 A1 00 18 7F E6 FB 78 38 E1 00 10 4B FF C6 9D 7C 74 1B 79 41 82 F9 D4 80 61 00 1C 4B FF FC E4 38 61 00 1C 38 81 00 14 38 A1 00 18 7F E6 FB 78 38 E1 00 10 4B FF C7 09 7C 74 1B 79 41 82 FF 44 80 61 00 1C 4B FF FC BC 38 61 00 1C 93 A1 00 08 38 81 00 14 38 A1 00 18 93 81 00 0C 7F E6 FB 78 38 E1 00 10 7F 28 CB 78 7F C9 F3 78 7F 6A DB 78 4B FF DC 91 7C 74 1B 79 41 82 FF 08 80 61 00 1C 4B FF FC 80 38 61 00 1C 38 81 00 14 38 A1 00 18 7F E6 FB 78 38 E1 00 10 4B FF C6 11 7C 74 1B 78 4B FF FA 0C 3B 80 00 01 4B FF FA 10 3B 80 00 02 4B FF FA 08 6B 80 00 02 93 A1 00 08 7C 00 00 34 54 00 D9 7E 38 61 00 1C 90 01 00 0C 38 81 00 14 38 A1 00 18 7F E6 FB 78 38 E1 00 10 7F 28 CB 78 39 21 00 30 7F 6A DB 78 4B FF DC 19 7C 74 1B 79 41 82 F9 C4 4B FF FC 00 80 61 00 1C 3A 80 00 05 4B FF FC 00 80 7E 00 08 38 80 00 04 38 63 00 01 4? ?? ?? ?? 2F 83 00 00 90 7E 00 04 41 BE FD 00 3C 60 ?? ?? 38 63 ?? ?? 4? ?? ?? ?? 7C 7B 1B 79 40 82 F7 7C 3D 20 ?? ?? 80 09 ?? ?? 7C 3D 0B 78 94 1D 00 20 7F BB EB 78 4B FF F8 14 2F 9C 00 01 41 9E FB A0 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 01 8E 38 C6 ?? ?? 4? ?? ?? ?? 38 61 00 3C 4? ?? ?? ?? 4B FF FA 60 7C 83 23 78 4? ?? ?? ?? 3A C0 00 00 4B FF F6 D8 7F C3 F3 78 4? ?? ?? ?? 4B FF FB 78 3A 80 00 04 80 61 00 1C 4? ?? ?? ?? 4B FF FB 64 3A 80 00 01 80 61 00 1C 4B FF FB 4C 3A 80 00 04 80 61 00 1C 4B FF FB 40 3A 80 00 02 4B FF FF D8 38 00 00 01 7C 09 03 A6 4B FF F7 5C 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 01 95 38 C6 ?? ?? 4? ?? ?? ?? }
	condition:
		$1
}

rule file_144_0_0 {
	meta:
		name = "__wcrtomb_chk"
		size = 72
		refs = "000a _GLOBAL_OFFSET_TABLE_ 0016 _nl_current_LC_CTYPE 0030 __wcrtomb 0044 __chk_fail"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 3D 20 ?? ?? 39 29 ?? ?? 90 01 00 14 81 29 ?? ?? 7D 29 12 14 81 29 00 00 81 29 00 00 80 09 00 58 7F 80 30 40 41 9D 00 18 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_145_0_0 {
	meta:
		name = "critical_factorization"
		size = 324
	strings:
		$1 = { 94 21 FF F0 39 20 00 01 39 00 00 00 93 E1 00 0C 38 E0 FF FF 3B E0 00 01 7C 09 42 14 7F 80 20 40 7D 63 3A 14 40 9C 00 34 7D 6B 48 AE 7D 43 00 AE 7F 8A 58 40 7F 0A 58 00 40 9C 00 9C 7C 08 03 78 39 20 00 01 7F E7 00 50 7C 09 42 14 7F 80 20 40 7D 63 3A 14 41 9C FF D4 93 E5 00 00 39 80 00 01 39 20 00 01 39 00 00 00 38 C0 FF FF 7C 09 42 14 7F 84 00 40 7D 63 32 14 40 9D 00 34 7D 6B 48 AE 7D 43 00 AE 7F 8A 58 40 7F 0A 58 00 40 9D 00 60 7C 08 03 78 39 20 00 01 7D 86 00 50 7C 09 42 14 7F 84 00 40 7D 63 32 14 41 9D FF D4 38 66 00 01 38 E7 00 01 7F 83 38 40 40 BC 00 0C 7F EC FB 78 7C E3 3B 78 83 E1 00 0C 38 21 00 10 91 85 00 00 4E 80 00 20 41 9A 00 30 7D 07 43 78 3B E0 00 01 39 08 00 01 39 20 00 01 4B FF FF 30 41 9A 00 28 7D 06 43 78 39 80 00 01 39 08 00 01 39 20 00 01 4B FF FF 6C 7F 89 F8 00 41 9E 00 1C 39 29 00 01 4B FF FF 08 7F 89 60 00 41 9E 00 1C 39 29 00 01 4B FF FF 4C 7D 3F 4B 78 7C 08 03 78 39 20 00 01 4B FF FE E8 7D 2C 4B 78 7C 08 03 78 39 20 00 01 4B FF FF 2C }
	condition:
		$1
}

rule file_145_1_0 {
	meta:
		name = "two_way_long_needle"
		size = 1064
		refs = "00c8 memcmp 00e8 memchr"
	strings:
		$1 = { 94 21 FB A0 7C 08 02 A6 7D 80 00 26 93 61 04 4C 7C 9B 23 78 7C C4 33 78 93 A1 04 54 7C 7D 1B 78 7C A3 2B 78 93 E1 04 5C 7C BF 2B 78 38 A1 00 08 90 01 04 64 93 81 04 50 93 C1 04 58 7C DE 33 78 92 41 04 28 92 61 04 2C 92 81 04 30 92 A1 04 34 92 C1 04 38 92 E1 04 3C 93 01 04 40 93 21 04 44 93 41 04 48 91 81 04 24 4B FF FE 55 38 00 01 00 7C 09 03 A6 7C 7C 1B 78 39 21 00 08 97 C9 00 04 42 00 FF FC 2F 9E 00 00 41 9E 00 30 7F C9 03 A6 39 5E FF FF 39 20 00 00 7D 7F 48 AE 39 01 00 08 7C 09 50 50 55 6B 10 3A 7D 68 5A 14 90 0B 00 04 39 29 00 01 42 00 FF E4 82 81 00 08 7F E3 FB 78 7F 85 E3 78 7C 9F A2 14 4? ?? ?? ?? 2F 83 00 00 40 9E 01 E0 3B 40 00 00 7F 1A F2 14 7C 7D DA 14 38 80 00 00 7C BB C0 50 4? ?? ?? ?? 3A DC FF FF 2F 83 00 00 3B 20 00 00 3A FE FF FF 7E 74 F0 50 7E BF B2 14 22 5C 00 01 40 9E 01 1C 2F 98 00 00 41 9E 01 18 7D 3D C2 14 89 29 FF FF 38 01 00 08 55 29 10 3A 7D 20 4A 14 80 09 00 04 2F 80 00 00 40 9E 01 5C 7F 99 E0 40 7F 29 CB 78 40 9C 00 08 7F 89 E3 78 7F 89 B8 40 40 9C 00 50 7D 69 D2 14 7D 1F 48 AE 7C 1D 58 AE 7D 5F 4A 14 7D 7D 5A 14 7F 88 00 00 40 9E 01 14 38 09 00 01 7F 80 B8 40 7D 09 B8 50 7D 09 03 A6 40 BD 00 18 48 00 02 A0 8D 0A 00 01 8C 0B 00 01 7F 88 00 00 40 9E 00 EC 39 29 00 01 42 00 FF EC 7F 99 E0 40 7F 89 E3 78 40 9C 00 50 7D 7A B2 14 89 55 00 00 7C 1D 58 AE 7E C9 B3 78 7D 7D 5A 14 7F 8A 00 00 40 9E 02 34 38 19 FF FF 7C 00 B0 50 7E AA AB 78 7C 09 03 A6 48 00 00 18 8C EA FF FF 8D 0B FF FF 7F 87 40 00 40 9E 00 10 7C 09 03 78 38 09 FF FF 42 00 FF E8 3B 39 00 01 7F 89 C8 40 41 9C 02 08 7F 5A A2 14 7E 79 9B 78 7F 1B C3 78 7F 1A F2 14 7C 7D DA 14 38 80 00 00 7C BB C0 50 4? ?? ?? ?? 2F 83 00 00 41 9E FE EC 38 60 00 00 80 01 04 64 81 81 04 24 7C 08 03 A6 82 41 04 28 82 61 04 2C 7D 80 81 20 82 81 04 30 82 A1 04 34 82 C1 04 38 82 E1 04 3C 83 01 04 40 83 21 04 44 83 41 04 48 83 61 04 4C 83 81 04 50 83 A1 04 54 83 C1 04 58 83 E1 04 5C 38 21 04 60 4E 80 00 20 7F 52 D2 14 7F 5A 4A 14 3B 20 00 00 7F 1B C3 78 4B FF FF 80 2F 99 00 00 41 9E 00 10 7F 94 00 40 40 9D 00 08 7E 60 9B 78 7F 5A 02 14 3B 20 00 00 7F 1B C3 78 4B FF FF 5C 7E BC F0 50 7F 95 E0 40 41 9C 01 30 3A DC FF FF 3A B5 00 01 2E 16 FF FF 92 A1 00 08 7E FF B2 14 3B 20 00 00 3B 1E FF FF 7F FF E2 14 22 9C 00 01 7F 59 F2 14 7C 7D DA 14 38 80 00 00 7C BB D0 50 4? ?? ?? ?? 2F 83 00 00 40 BE FF 2C 2F 9A 00 00 41 BE FF 28 7D 3D D2 14 89 29 FF FF 39 01 00 08 55 29 10 3A 7D 28 4A 14 80 09 00 04 2F 80 00 00 40 9E 00 BC 7F 9C C0 40 40 9C 00 54 7D 79 E2 14 89 3F 00 00 7C 1D 58 AE 7D 7D 5A 14 7F 89 00 00 40 9E 00 88 38 1C 00 01 7F 80 C0 40 7C 1C C0 50 7F EA FB 78 7C 09 03 A6 7F 89 E3 78 40 BD 00 18 48 00 00 B0 8D 0A 00 01 8C 0B 00 01 7F 88 00 00 40 9E 00 5C 39 29 00 01 42 00 FF EC 41 92 00 8C 7D 39 B2 14 89 77 00 00 7C 1D 48 AE 7D 3D 4A 14 7F 8B 00 00 40 9E 00 28 7F 89 03 A6 7E EB BB 78 39 29 FF FF 42 40 00 64 88 09 00 00 39 29 FF FF 8D 4B FF FF 7F 8A 00 00 41 9E FF EC 7F 39 AA 14 7F 5B D3 78 4B FF FF 1C 7F 89 E3 78 7F 34 CA 14 7F 39 4A 14 7F 5B D3 78 4B FF FF 08 7F 39 02 14 7F 5B D3 78 4B FF FE FC 7F 95 E3 78 4B FF FE D0 7F 89 E3 78 3B 39 00 01 7F 89 C8 40 40 9C FE 00 7C 7D D2 14 4B FF FE 24 7C 7D CA 14 4B FF FE 1C 39 00 00 01 7D 09 03 A6 4B FF FF 5C 38 00 00 01 7C 09 03 A6 4B FF FD 6C }
	condition:
		$1
}

rule file_145_2_0 {
	meta:
		name = "strstr"
		size = 1072
		refs = "011c strchr 019c memcmp 0298 memchr"
	strings:
		$1 = { 94 21 FF A0 7C 08 02 A6 7D 80 00 26 93 21 00 44 7C 79 1B 78 93 E1 00 5C 7C 9F 23 78 90 01 00 64 92 41 00 28 92 61 00 2C 92 81 00 30 92 A1 00 34 92 C1 00 38 92 E1 00 3C 93 01 00 40 93 41 00 48 93 61 00 4C 93 81 00 50 93 A1 00 54 93 C1 00 58 91 81 00 24 88 03 00 00 2F 80 00 00 41 9E 02 94 89 24 00 00 2F 89 00 00 41 9E 00 50 7C 6A 1B 78 7C 9B 23 78 39 60 00 01 48 00 00 10 89 3B 00 00 2F 89 00 00 41 9E 00 88 7C 09 4A 78 8C 0A 00 01 7D 29 00 34 2F 80 00 00 55 29 D9 7E 3B 7B 00 01 7D 2B 58 38 40 9E FF D8 88 1B 00 00 2F 80 00 00 41 9E 00 5C 3B 20 00 00 80 01 00 64 7F 23 CB 78 81 81 00 24 7C 08 03 A6 82 41 00 28 82 61 00 2C 7D 80 81 20 82 81 00 30 82 A1 00 34 82 C1 00 38 82 E1 00 3C 83 01 00 40 83 21 00 44 83 41 00 48 83 61 00 4C 83 81 00 50 83 A1 00 54 83 C1 00 58 83 E1 00 5C 38 21 00 60 4E 80 00 20 2F 8B 00 00 40 BE FF A8 88 9F 00 00 38 79 00 01 4? ?? ?? ?? 7C 7E 1B 79 41 A2 FF 90 7F FF D8 50 2F 9F 00 01 41 9E 02 F8 7F 39 FA 14 7F 9E C8 40 7F 7F D8 50 3B A0 00 01 40 9D 00 28 2B 9F 00 1F 40 9D 00 2C 7F C3 F3 78 7F A4 EB 78 7F 65 DB 78 7F E6 FB 78 4B FF FA 79 7C 79 1B 78 4B FF FF 50 2B 9F 00 1F 7F BE C8 50 41 9D FF DC 7F E4 FB 78 38 A1 00 08 7F 63 DB 78 4B FF F9 11 82 C1 00 08 7C 7C 1B 78 7C 9B B2 14 7F 63 DB 78 7F 85 E3 78 4? ?? ?? ?? 2F 83 00 00 41 9E 01 60 7E 7C F8 50 7E DB E0 AE 7F 93 E0 40 7D 7E E2 14 40 9C 00 08 7F 93 E3 78 3A BC FF FF 3A 73 00 01 2E 15 FF FF 92 61 00 08 3B 5C 00 01 7D 74 58 F8 7E FB AA 14 7F 1B D2 14 22 5C 00 01 88 0B 00 00 39 6B 00 01 7F 96 00 00 40 9E 00 D8 7F 9F D0 40 7F 2B A2 14 7F 49 D3 78 40 9D 00 3C 88 0B 00 00 89 58 00 00 7F 8A 00 00 40 9E 00 C4 7C 1A F8 50 7F 0A C3 78 7C 09 03 A6 48 00 00 14 8C 0B 00 01 8D 0A 00 01 7F 88 00 00 40 9E 00 A4 39 29 00 01 42 00 FF EC 41 92 00 C0 7D 39 AA 14 89 77 00 00 7C 1E 48 AE 7D 3E 4A 14 7F 8B 00 00 40 9E 00 28 7F 89 03 A6 7E EB BB 78 39 29 FF FF 42 40 00 98 88 09 00 00 39 29 FF FF 8D 4B FF FF 7F 8A 00 00 41 9E FF EC 2F 80 00 00 41 BE FE 34 7F 39 9A 14 7F 79 FA 14 7C 7E EA 14 38 80 00 00 7C BD D8 50 4? ?? ?? ?? 2F 83 00 00 40 BE FE 14 2F 9B 00 00 41 BE FE 0C 7D 79 E2 14 7D 7E 5A 14 88 0B 00 00 7F 7D DB 78 39 6B 00 01 7F 96 00 00 41 9E FF 30 2F 80 00 00 40 9E FF 18 4B FF FD E4 2F 80 00 00 41 BE FD DC 7F 9F 48 40 40 9D FF 5C 7F 32 CA 14 7F 39 4A 14 4B FF FF 9C 7C 9B 23 78 39 60 00 01 4B FF FD B0 7F 3E CA 14 4B FF FD B8 3A FC FF FF 3B 40 00 00 3B 20 00 00 7E 96 F8 50 7E BB BA 14 22 7C 00 01 7F 19 FA 14 7C 7E EA 14 38 80 00 00 7C BD C0 50 4? ?? ?? ?? 2F 83 00 00 40 BE FD 80 2F 98 00 00 41 BE FD 78 7F 9A E0 40 7F 49 D3 78 40 9C 00 08 7F 89 E3 78 7F 9F 48 40 40 9D 00 44 7C 09 CA 14 7D 1B 48 AE 7D 7E 00 AE 7D 5B 4A 14 7F 88 58 00 7D 7E 02 14 40 9E 00 9C 7C 09 F8 50 7C 09 03 A6 48 00 00 14 8D 0A 00 01 8C 0B 00 01 7F 88 00 00 40 9E 00 80 39 29 00 01 42 00 FF EC 7F 9C D0 40 7F 89 E3 78 40 9D 00 50 7C 19 BA 14 89 55 00 00 7D 7E 00 AE 7E E9 BB 78 7F 8A 58 00 7D 7E 02 14 40 9E 00 64 38 1A FF FF 7C 00 B8 50 7E AA AB 78 7C 09 03 A6 48 00 00 18 8C EA FF FF 8D 0B FF FF 7F 87 40 00 40 9E 00 10 7C 09 03 78 38 09 FF FF 42 00 FF E8 3B 5A 00 01 7F 9A 48 40 41 BD FF 04 7F 39 B2 14 7E 9A A3 78 7F 1D C3 78 4B FF FF 14 7F 33 CA 14 7F 39 4A 14 3B 40 00 00 7F 1D C3 78 4B FF FF 00 7F 89 E3 78 4B FF FF CC 7F D9 F3 78 4B FF FC 8C }
	condition:
		$1
}

rule file_146_2_0 {
	meta:
		name = "__libc_allocate_rtsig"
		size = 84
		altNames = "__libc_allocate_rtsig_private"
	strings:
		$1 = { 3D 60 ?? ?? 81 2B ?? ?? 39 4B ?? ?? 2F 89 FF FF 40 9E 00 0C 7D 23 4B 78 4E 80 00 20 81 0A 00 04 7F 89 40 00 41 9D 00 28 2F 83 00 00 41 9E 00 10 38 09 00 01 90 0B ?? ?? 4B FF FF DC 38 08 FF FF 90 0A 00 04 7D 09 43 78 4B FF FF CC 39 20 FF FF 4B FF FF C4 }
	condition:
		$1
}

rule file_148_0_0 {
	meta:
		name = "_IO_ftell"
		size = 576
		refs = "0088 _IO_seekoff_unlocked 017e _GLOBAL_OFFSET_TABLE_ 0186 __libc_errno 01d0 __lll_lock_wait_private 023c _Unwind_Resume"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 90 01 00 24 80 03 00 00 93 A1 00 14 7C 7D 1B 78 70 00 80 00 93 C1 00 18 93 E1 00 1C 40 82 00 50 80 63 00 48 3B C2 8B 60 81 23 00 08 7F 89 F0 00 41 9E 00 30 39 60 00 01 7D 20 18 28 7C 09 00 00 40 82 00 0C 7D 60 19 2D 40 A2 FF F0 4C 00 01 2C 2F 89 00 00 40 9E 01 74 80 7D 00 48 93 C3 00 08 81 23 00 04 38 09 00 01 90 03 00 04 7F A3 EB 78 38 A0 00 00 38 C0 00 00 38 E0 00 01 39 00 00 00 4? ?? ?? ?? 80 1D 00 00 7C 7E 1B 78 7C 9F 23 78 70 09 01 00 2F 9E FF FF 41 82 00 14 41 9E 00 60 81 3D 00 6C 2F 09 00 00 40 99 00 A8 70 09 80 00 40 82 00 1C 80 7D 00 48 81 23 00 04 38 09 FF FF 2F 00 00 00 90 03 00 04 41 9A 00 4C 41 9E 00 C8 7F E0 FE 70 7F 80 F0 00 7F E3 FB 78 40 9E 00 98 80 01 00 24 83 A1 00 14 7C 08 03 A6 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 2F 04 FF FF 41 BA FF AC 81 3D 00 6C 2F 09 00 00 41 99 FF A0 48 00 00 40 90 03 00 08 7C 00 04 AC 7D 20 18 28 7C 00 19 2D 40 A2 FF F8 2F 09 00 01 40 99 FF A0 80 82 8B 68 38 00 00 DD 38 A0 00 01 60 84 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF 80 81 1D 00 2C 81 7D 00 24 7D 6B 40 50 7D 6A 5B 78 7D 69 FE 70 7F EA F8 10 7F C9 F1 10 2F 9E FF FF 4B FF FF 3C 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 38 00 00 4B 90 09 00 00 38 60 FF FF 4B FF FF 50 2F 9F FF FF 40 9E FF 38 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 80 09 00 00 38 60 FF FF 2F 80 00 00 40 9E FF 28 38 00 00 05 90 09 00 00 4B FF FF 1C 4? ?? ?? ?? 4B FF FE 8C 80 1D 00 00 7C 7E 1B 78 70 09 80 00 40 82 00 54 80 7D 00 48 80 03 00 04 30 00 FF FF 2F 80 00 00 90 03 00 04 40 9E 00 3C 90 03 00 08 7C 00 04 AC 7D 20 18 28 7C 00 19 2D 40 A2 FF F8 2F 89 00 01 40 BD 00 20 80 82 8B 68 38 00 00 DD 38 A0 00 01 60 84 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 7F C3 F3 78 4? ?? ?? ?? }
	condition:
		$1
}

rule file_150_0_0 {
	meta:
		name = "__new_exitfn"
		size = 524
		refs = "00fe __new_exitfn_called 0188 calloc 01d8 __assert_fail 01e0 __lll_lock_wait_private"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 39 60 00 01 93 81 00 10 3F 80 ?? ?? 39 20 00 00 93 61 00 0C 7C 7B 1B 78 93 C1 00 18 3B DC ?? ?? 90 01 00 24 93 A1 00 14 93 E1 00 1C 7C 00 F0 28 7C 00 48 00 40 82 00 0C 7D 60 F1 2D 40 A2 FF F0 4C 00 01 2C 2F 80 00 00 40 9E 01 8C 83 BB 00 00 2F 9D 00 00 41 9E 01 0C 7F A8 EB 78 38 60 00 00 38 E0 00 00 81 48 00 04 2F 8A 00 00 41 9E 00 50 39 2A FF FF 55 2B 20 36 7D 68 5A 14 80 0B 00 08 2F 80 00 00 40 9E 00 54 39 6A FF FE 7D 49 03 A6 55 6B 20 36 7D 68 5A 14 39 6B 00 08 48 00 00 18 80 0B 00 00 39 6B FF F0 2F 80 00 00 40 9E 00 2C 39 29 FF FF 7D 2A 4B 78 42 00 FF E8 80 08 00 00 90 E8 00 04 2F 80 00 00 41 9E 00 E0 7D 03 43 78 7C 08 03 78 4B FF FF 90 2F 8A 00 20 41 9E 00 8C 55 5F 20 36 39 4A 00 01 7F E8 FA 14 91 48 00 04 3B FF 00 08 3D 60 ?? ?? 39 6B ?? ?? 81 2B 00 00 38 00 00 01 81 4B 00 04 90 1F 00 00 31 4A 00 01 7D 29 01 94 91 2B 00 00 91 4B 00 04 38 00 00 00 7C 00 04 AC 7D 20 F0 28 7C 00 F1 2D 40 A2 FF F8 2F 89 00 01 41 9D 00 AC 80 01 00 24 7F E3 FB 78 83 61 00 0C 7C 08 03 A6 83 81 00 10 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 38 60 00 00 39 00 00 00 2F 83 00 00 40 9E 00 2C 2F 88 00 00 41 9E 00 40 38 60 00 01 38 80 02 08 4? ?? ?? ?? 3B E0 00 00 2C 03 00 00 41 A2 FF 90 93 A3 00 00 90 7B 00 00 38 00 00 01 3B E3 00 08 90 03 00 04 4B FF FF 50 7D 03 43 78 39 00 00 00 4B FF FF B8 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 00 64 38 C6 ?? ?? 4? ?? ?? ?? 7F C3 F3 78 4? ?? ?? ?? 4B FF FE 70 80 82 8B 68 38 00 00 DD 7F C3 F3 78 60 84 00 01 38 A0 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF 38 }
	condition:
		$1
}

rule file_150_1_0 {
	meta:
		name = "__internal_atexit"
		size = 120
		refs = "0028 __new_exitfn"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 93 E1 00 1C 7C 7F 1B 78 7C C3 33 78 93 A1 00 14 7C BD 2B 78 93 C1 00 18 7C 9E 23 78 90 01 00 24 4? ?? ?? ?? 7C 69 1B 79 38 60 FF FF 41 82 00 28 80 02 8F F4 93 C9 00 08 7F FF 02 78 93 E9 00 04 93 A9 00 0C 7C 00 06 AC 38 00 00 04 90 09 00 00 38 60 00 00 80 01 00 24 83 A1 00 14 7C 08 03 A6 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 }
	condition:
		$1
}

rule file_151_0_0 {
	meta:
		name = "__sched_getscheduler"
		size = 16
		refs = "000c __syscall_error"
	strings:
		$1 = { 38 00 00 9D 44 00 00 02 4C A3 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_152_0_0 {
	meta:
		name = "putmsg"
		size = 56
		refs = "001e _GLOBAL_OFFSET_TABLE_ 0026 __libc_errno"
	strings:
		$1 = { 7C C7 33 78 38 00 00 BC 38 C0 FF FF 44 00 00 02 7C 00 00 26 74 09 10 00 4D A2 00 20 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 90 69 00 00 38 60 FF FF 4E 80 00 20 }
	condition:
		$1
}

rule file_153_0_0 {
	meta:
		name = "__wcscat_chk"
		size = 112
		refs = "006c __chk_fail"
	strings:
		$1 = { 7C 08 02 A6 94 21 FF F0 7C 69 1B 78 90 01 00 14 38 05 00 01 7C 09 03 A6 48 00 00 08 7D 65 5B 78 39 65 FF FF 42 40 00 48 80 09 00 00 39 29 00 04 2F 80 00 00 40 9E FF E8 38 84 FF FC 7C A9 03 A6 39 29 FF F8 48 00 00 08 42 40 00 24 84 04 00 04 2F 80 00 00 94 09 00 04 40 9E FF F0 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_154_0_0 {
	meta:
		name = "__readlinkat_chk"
		size = 44
		refs = "0014 readlinkat 0028 __chk_fail"
	strings:
		$1 = { 7F 86 38 40 94 21 FF F0 7C 08 02 A6 90 01 00 14 41 9D 00 18 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_155_0_0 {
	meta:
		name = "_IO_wpadn"
		size = 292
	strings:
		$1 = { 2F 84 00 20 94 21 FF A0 7C 08 02 A6 93 A1 00 54 7C 7D 1B 78 90 01 00 64 93 81 00 50 93 C1 00 58 93 E1 00 5C 41 9E 00 E4 2F 84 00 30 41 9E 00 E8 38 00 00 10 7C 09 03 A6 39 21 00 48 94 89 FF FC 42 00 FF FC 3B 81 00 08 2F 85 00 0F 40 9D 00 68 7C BF 2B 78 3B C0 00 00 48 00 00 08 40 99 00 60 81 3D 00 98 7F A3 EB 78 7F 84 E3 78 80 09 00 1C 38 A0 00 10 3B FF FF F0 7C 09 03 A6 4E 80 04 21 2F 1F 00 0F 2F 83 00 10 7F DE 1A 14 41 9E FF D0 80 01 00 64 7F C3 F3 78 83 81 00 50 7C 08 03 A6 83 A1 00 54 83 C1 00 58 83 E1 00 5C 38 21 00 60 4E 80 00 20 7C BF 2B 78 3B C0 00 00 2F 9F 00 00 40 BD FF D0 81 3D 00 98 7F A3 EB 78 7F 84 E3 78 80 09 00 1C 7F E5 FB 78 7C 09 03 A6 4E 80 04 21 80 01 00 64 7F DE 1A 14 83 81 00 50 7C 08 03 A6 7F C3 F3 78 83 A1 00 54 83 C1 00 58 83 E1 00 5C 38 21 00 60 4E 80 00 20 3F 80 ?? ?? 3B 9C ?? ?? 4B FF FF 38 3F 80 ?? ?? 3B 9C ?? ?? 3B 9C 00 40 4B FF FF 28 }
	condition:
		$1
}

rule file_156_0_0 {
	meta:
		name = "mkostemps"
		size = 76
		refs = "0018 __gen_tempname 002e _GLOBAL_OFFSET_TABLE_ 0036 __libc_errno"
	strings:
		$1 = { 2F 84 00 00 94 21 FF F0 7C 08 02 A6 90 01 00 14 41 9C 00 1C 38 C0 00 00 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 38 00 00 16 90 09 00 00 38 60 FF FF 4B FF FF D4 }
	condition:
		$1
}

rule file_157_0_0 {
	meta:
		name = "fgets_unlocked"
		size = 260
		refs = "0054 _IO_getline 00a2 _GLOBAL_OFFSET_TABLE_ 00aa __libc_errno"
	strings:
		$1 = { 7C 89 23 79 94 21 FF E0 7C 08 02 A6 93 C1 00 18 7C 7E 1B 78 93 E1 00 1C 7C BF 2B 78 90 01 00 24 93 A1 00 14 40 81 00 B0 2F 89 00 01 41 9E 00 CC 80 05 00 00 7C A3 2B 78 7F C4 F3 78 54 0B 06 F2 91 65 00 00 38 C0 00 0A 38 A9 FF FF 38 E0 00 01 54 1D 06 B4 4? ?? ?? ?? 2C 03 00 00 40 82 00 38 80 1F 00 00 39 20 00 00 7C 00 EB 78 90 1F 00 00 7D 3E 4B 78 80 01 00 24 7F C3 F3 78 83 A1 00 14 7C 08 03 A6 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 80 1F 00 00 70 09 00 20 41 82 00 24 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 81 69 00 00 39 20 00 00 2F 8B 00 0B 40 9E FF AC 38 00 00 00 7C 1E 19 AE 7F C9 F3 78 80 1F 00 00 4B FF FF 98 80 01 00 24 3B C0 00 00 7F C3 F3 78 83 A1 00 14 7C 08 03 A6 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 38 00 00 00 98 03 00 00 4B FF FF 74 }
	condition:
		$1
}

rule file_158_0_0 {
	meta:
		name = "enlarge_userbuf"
		size = 616
		refs = "0104 __wmemcpy 012c _IO_wsetb 01c4 wmemset 0264 __assert_fail"
	strings:
		$1 = { 94 21 FF C0 7C 08 02 A6 90 01 00 44 81 23 00 20 80 03 00 1C 93 21 00 24 7C F9 3B 78 7C 00 48 50 7F 80 30 00 93 A1 00 34 7C BD 2B 78 93 C1 00 38 7C DE 33 78 93 E1 00 3C 7C 7F 1B 78 92 81 00 10 92 A1 00 14 92 C1 00 18 92 E1 00 1C 93 01 00 20 93 41 00 28 93 61 00 2C 93 81 00 30 40 9C 01 74 82 C3 00 3C 3A 80 00 01 83 83 00 5C 72 D6 00 08 82 FC 00 14 83 1C 00 0C 41 82 00 48 80 01 00 44 7E 83 A3 78 82 A1 00 14 7C 08 03 A6 82 81 00 10 82 C1 00 18 82 E1 00 1C 83 01 00 20 83 21 00 24 83 41 00 28 83 61 00 2C 83 81 00 30 83 A1 00 34 83 C1 00 38 83 E1 00 3C 38 21 00 40 4E 80 00 20 80 03 00 A0 3A A6 00 64 56 B5 10 3A 83 5C 00 18 7E A3 AB 78 7C 09 03 A6 4E 80 04 21 7C 7B 1B 79 41 A2 FF 9C 2F 9A 00 00 41 9E 00 34 81 3F 00 5C 7F 44 D3 78 80 09 00 18 80 A9 00 1C 7C A0 28 50 7C A5 16 70 4? ?? ?? ?? 80 1F 00 A4 7F 43 D3 78 7C 09 03 A6 4E 80 04 21 92 DC 00 18 7F E3 FB 78 7F 64 DB 78 7C BB AA 14 38 C0 00 01 4? ?? ?? ?? 2F 99 00 00 40 9E 00 A4 80 1C 00 10 81 5C 00 08 81 7C 00 00 81 3C 00 04 7D 5A 50 50 7D 7A 58 50 93 7C 00 0C 7D 3A 48 50 7F 5A 00 50 80 1C 00 1C 55 4A 00 3A 55 6B 00 3A 90 1C 00 14 55 29 00 3A 57 5A 00 3A 7D 5B 52 14 7D 7B 5A 14 91 5C 00 08 7D 3B 4A 14 7F 5B D2 14 91 7C 00 00 91 3C 00 04 93 5C 00 10 7F 18 B8 50 7F 00 FE 70 7F 00 E8 00 7F 05 16 70 41 99 00 A4 41 9A 00 98 40 9E 00 8C 80 7C 00 0C 54 A0 10 3A 7C 63 02 14 38 80 00 00 7C A5 F0 50 4? ?? ?? ?? 3A 80 00 00 4B FF FE B0 3A 80 00 00 4B FF FE A8 80 1C 00 00 81 5C 00 0C 81 7C 00 10 81 3C 00 14 7D 5A 50 50 7D 7A 58 50 93 7C 00 08 7D 3A 48 50 7F 5A 00 50 80 1C 00 1C 55 4A 00 3A 55 6B 00 3A 90 1C 00 04 55 29 00 3A 57 5A 00 3A 7D 5B 52 14 7D 7B 5A 14 91 5C 00 0C 7D 3B 4A 14 7F 5B D2 14 91 7C 00 10 91 3C 00 14 93 5C 00 00 4B FF FF 60 80 7C 00 08 4B FF FF 78 7F 05 F0 40 40 99 FF 68 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 00 E7 38 C6 ?? ?? 4? ?? ?? ?? }
	condition:
		$1
}

rule file_158_1_0 {
	meta:
		name = "_IO_wstr_underflow"
		size = 104
	strings:
		$1 = { 81 63 00 5C 81 2B 00 10 80 0B 00 04 7F 89 00 40 40 9D 00 0C 91 2B 00 04 7D 20 4B 78 81 43 00 00 55 48 05 2A 2F 88 0C 00 41 9E 00 1C 81 2B 00 00 38 60 FF FF 7F 89 00 40 4C 9C 00 20 80 69 00 00 4E 80 00 20 7F 89 00 40 81 0B 00 14 55 4A 05 66 91 43 00 00 38 60 FF FF 91 2B 00 00 91 0B 00 10 4C 9C 00 20 4B FF FF D8 }
	condition:
		$1
}

rule file_158_2_0 {
	meta:
		name = "_IO_wstr_finish"
		size = 104
		refs = "0050 _IO_wdefault_finish"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 81 23 00 5C 93 E1 00 0C 7C 7F 1B 78 80 69 00 18 2F 83 00 00 41 9E 00 20 80 1F 00 3C 70 0B 00 08 40 A2 00 14 80 1F 00 A4 7C 09 03 A6 4E 80 04 21 81 3F 00 5C 38 00 00 00 90 09 00 18 7F E3 FB 78 38 80 00 00 4? ?? ?? ?? 80 01 00 14 83 E1 00 0C 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_158_3_0 {
	meta:
		name = "_IO_wstr_pbackfail"
		size = 80
		refs = "003c _IO_wdefault_pbackfail"
	strings:
		$1 = { 7C 08 02 A6 94 21 FF F0 7C 69 1B 78 90 01 00 14 80 03 00 00 70 0B 00 08 41 82 00 20 2F 84 FF FF 38 60 FF FF 41 9E 00 14 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 7D 23 4B 78 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_158_4_0 {
	meta:
		name = "_IO_wstr_seekoff"
		size = 764
	strings:
		$1 = { 2C 08 00 00 94 21 FF D0 7C 08 02 A6 93 41 00 18 7C FA 3B 78 93 61 00 1C 7C 7B 1B 78 93 81 00 20 7C BC 2B 78 93 A1 00 24 7C DD 33 78 90 01 00 34 93 21 00 14 93 C1 00 28 93 E1 00 2C 41 82 00 74 81 63 00 5C 81 2B 00 10 83 2B 00 04 80 0B 00 08 7F 89 C8 40 41 9D 02 14 71 09 00 01 7F 20 C8 50 7F 39 16 70 40 82 01 A0 55 08 07 BC 3B C0 FF FF 3B E0 FF FF 2F 88 00 00 40 9E 00 70 80 01 00 34 7F C3 F3 78 7F E4 FB 78 83 21 00 14 7C 08 03 A6 83 41 00 18 83 61 00 1C 83 81 00 20 83 A1 00 24 83 C1 00 28 83 E1 00 2C 38 21 00 30 4E 80 00 20 80 03 00 00 70 09 04 00 41 82 00 84 70 09 08 00 41 82 01 1C 81 63 00 5C 81 2B 00 10 80 0B 00 04 7F 89 00 40 40 9D 00 08 7D 20 4B 78 83 2B 00 08 7F 39 00 50 7F 39 16 70 2F 9A 00 01 41 9E 01 A0 2F 9A 00 02 40 BE 00 14 7F 2A CB 78 7F 29 FE 70 7F BD 50 14 7F 9C 49 14 2F 9C 00 00 3B C0 FF FF 3B E0 FF FF 41 9C 00 48 7F 99 E8 00 41 9C 01 90 81 2B 00 0C 57 A0 10 3A 7F BF EB 78 7C 09 02 14 90 0B 00 10 7F 9E E3 78 48 00 00 24 70 09 00 08 40 82 00 50 81 3B 00 5C 81 69 00 10 80 09 00 0C 7C 00 58 50 7C 1F 16 70 7C 1E FE 70 80 01 00 34 7F C3 F3 78 7F E4 FB 78 83 21 00 14 7C 08 03 A6 83 41 00 18 83 61 00 1C 83 81 00 20 83 A1 00 24 83 C1 00 28 83 E1 00 2C 38 21 00 30 4E 80 00 20 81 3B 00 5C 83 21 00 14 81 69 00 00 80 09 00 08 83 41 00 18 7C 00 58 50 83 61 00 1C 7C 1F 16 70 83 81 00 20 7C 1E FE 70 80 01 00 34 7F C3 F3 78 83 A1 00 24 7C 08 03 A6 7F E4 FB 78 83 C1 00 28 83 E1 00 2C 38 21 00 30 4E 80 00 20 81 63 00 5C 81 2B 00 10 83 2B 00 04 80 0B 00 08 7F 89 C8 40 40 9D 00 08 7D 39 4B 78 7F 20 C8 50 7F 39 16 70 39 00 00 01 2F 9A 00 01 41 9E 00 68 2F 9A 00 02 40 BE 00 14 7F 2A CB 78 7F 29 FE 70 7F BD 50 14 7F 9C 49 14 2F 9C 00 00 3B C0 FF FF 3B E0 FF FF 41 BC FF 2C 7F 99 E8 00 41 9C 00 98 80 0B 00 08 57 A9 10 3A 57 2A 10 3A 7D 20 4A 14 7C 00 52 14 91 2B 00 00 55 08 07 BC 90 0B 00 04 7F BF EB 78 7F 9E E3 78 4B FF FE 10 7D 39 4B 78 4B FF FD EC 80 EB 00 00 7C 00 38 50 7C 0A 16 70 7C 09 FE 70 7F BD 50 14 7F 9C 49 14 4B FF FF 9C 81 0B 00 10 80 0B 00 0C 7C 00 40 50 7C 0A 16 70 7C 09 FE 70 7F BD 50 14 7F 9C 49 14 4B FF FE 60 7F 63 DB 78 7F 85 E3 78 7F A6 EB 78 38 E0 00 00 4B FF FA DD 2F 83 00 00 40 BE FE 98 81 7B 00 5C 4B FF FE 54 7F 63 DB 78 91 01 00 08 7F 85 E3 78 7F A6 EB 78 38 E0 00 01 4B FF FA B5 81 01 00 08 2F 83 00 00 40 BE FE 6C 81 7B 00 5C 4B FF FF 44 }
	condition:
		$1
}

rule file_158_5_0 {
	meta:
		name = "_IO_wstr_overflow"
		size = 676
		refs = "01b0 __wmemcpy 01dc wmemset 01f0 _IO_wsetb"
	strings:
		$1 = { 94 21 FF D0 7C 08 02 A6 90 01 00 34 80 03 00 00 93 E1 00 2C 3B E4 00 01 70 09 00 08 7F FF 00 34 93 A1 00 24 57 FF D9 7E 93 C1 00 28 7C 7D 1B 78 7C 9E 23 78 92 E1 00 0C 93 01 00 10 93 21 00 14 93 41 00 18 93 61 00 1C 93 81 00 20 41 82 00 44 33 DF FF FF 7F DE F1 10 80 01 00 34 7F C3 F3 78 82 E1 00 0C 7C 08 03 A6 83 01 00 10 83 21 00 14 83 41 00 18 83 61 00 1C 83 81 00 20 83 A1 00 24 83 C1 00 28 83 E1 00 2C 38 21 00 30 4E 80 00 20 54 09 05 2A 2F 89 04 00 41 9E 00 8C 81 23 00 5C 83 89 00 18 83 49 00 1C 81 69 00 10 81 49 00 0C 7F 5C D0 50 7F 5A 16 70 7D 4A 58 50 7D 4A 16 70 7C 1F D2 14 7F 8A 00 40 41 9C 00 A0 83 1D 00 3C 73 18 00 08 40 82 00 14 3A FA 00 32 56 F9 08 3C 7F 9A C8 40 40 9D 00 A0 80 01 00 34 3B C0 FF FF 7F C3 F3 78 82 E1 00 0C 7C 08 03 A6 83 01 00 10 83 21 00 14 83 41 00 18 83 61 00 1C 83 81 00 20 83 A1 00 24 83 C1 00 28 83 E1 00 2C 38 21 00 30 4E 80 00 20 81 23 00 5C 60 00 08 00 81 49 00 04 83 89 00 18 83 49 00 1C 81 69 00 00 90 03 00 00 7F 5C D0 50 7F 5A 16 70 91 49 00 00 7C 1F D2 14 81 49 00 0C 91 69 00 10 7D 4A 58 50 7D 4A 16 70 7F 8A 00 40 40 9C FF 68 2F 9F 00 00 81 49 00 04 40 9E 00 EC 38 0B 00 04 93 CB 00 00 90 09 00 10 48 00 00 E0 80 1D 00 A0 56 F7 18 38 7E E3 BB 78 7C 09 03 A6 4E 80 04 21 7C 7B 1B 79 41 A2 FF 4C 2F 9C 00 00 41 9E 00 28 7F 84 E3 78 7F 45 D3 78 4? ?? ?? ?? 80 1D 00 A4 7F 83 E3 78 7C 09 03 A6 4E 80 04 21 81 3D 00 5C 93 09 00 18 57 43 10 3A 7C BA C8 50 38 80 00 00 7C 7B 1A 14 4? ?? ?? ?? 7F A3 EB 78 7F 64 DB 78 7C BB BA 14 38 C0 00 01 4? ?? ?? ?? 81 3D 00 5C 2F 9F 00 00 80 E9 00 08 81 09 00 00 81 49 00 04 7C FC 38 50 81 69 00 10 7D 1C 40 50 7D 5C 50 50 80 09 00 1C 7D 7C 58 50 93 69 00 0C 54 E7 00 3A 55 08 00 3A 90 09 00 14 55 4A 00 3A 55 6B 00 3A 7C FB 3A 14 7D 1B 42 14 90 E9 00 08 7D 5B 52 14 7D 7B 5A 14 91 09 00 00 91 49 00 04 91 69 00 10 41 BE FF 1C 80 09 00 10 7F 80 50 40 40 BD FD F4 90 09 00 04 7F C3 F3 78 80 01 00 34 82 E1 00 0C 7C 08 03 A6 83 01 00 10 83 21 00 14 83 41 00 18 83 61 00 1C 83 81 00 20 83 A1 00 24 83 C1 00 28 83 E1 00 2C 38 21 00 30 4E 80 00 20 }
	condition:
		$1
}

rule file_158_6_0 {
	meta:
		name = "_IO_wstr_init_static"
		size = 284
		refs = "0034 __wcslen 0050 _IO_wsetb"
	strings:
		$1 = { 2C 05 00 00 94 21 FF E0 7C 08 02 A6 93 A1 00 14 7C DD 33 78 93 C1 00 18 7C 7E 1B 78 93 E1 00 1C 7C 9F 23 78 90 01 00 24 93 81 00 10 40 82 00 74 7C 83 23 78 4? ?? ?? ?? 54 63 10 3A 7F 9F 1A 14 7F C3 F3 78 7F E4 FB 78 7F 85 E3 78 38 C0 00 00 4? ?? ?? ?? 2F 9D 00 00 81 3E 00 5C 93 E9 00 0C 93 E9 00 08 93 E9 00 00 41 9E 00 80 38 00 00 00 93 A9 00 10 93 89 00 14 93 A9 00 04 90 1E 00 A0 80 01 00 24 83 81 00 10 7C 08 03 A6 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 54 BC 10 3A 7F 9C 22 14 7F 84 E0 40 41 BC FF 94 7C 9C 20 F8 57 9C 00 3A 7F 84 E2 14 7F C3 F3 78 7F E4 FB 78 7F 85 E3 78 38 C0 00 00 4? ?? ?? ?? 2F 9D 00 00 81 3E 00 5C 93 E9 00 0C 93 E9 00 08 93 E9 00 00 40 9E FF 88 38 00 00 00 93 E9 00 10 93 E9 00 14 93 89 00 04 90 1E 00 A0 80 01 00 24 83 81 00 10 7C 08 03 A6 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 }
	condition:
		$1
}

rule file_158_7_0 {
	meta:
		name = "_IO_wstr_count"
		size = 40
	strings:
		$1 = { 81 23 00 5C 81 69 00 10 80 09 00 04 7F 8B 00 40 40 9D 00 08 7D 60 5B 78 81 29 00 08 7C 09 00 50 7C 03 16 70 4E 80 00 20 }
	condition:
		$1
}

rule file_159_0_0 {
	meta:
		name = "_IO_ungetc"
		size = 420
		refs = "0088 _IO_sputbackc 0134 __lll_lock_wait_private 01a0 _Unwind_Resume"
	strings:
		$1 = { 2F 83 FF FF 94 21 FF E0 7C 08 02 A6 93 C1 00 18 7C 7E 1B 78 93 E1 00 1C 7C 9F 23 78 90 01 00 24 93 A1 00 14 41 9E 00 CC 80 04 00 00 70 00 80 00 40 82 00 50 80 64 00 48 3B A2 8B 60 81 23 00 08 7F 89 E8 00 41 9E 00 30 39 60 00 01 7D 20 18 28 7C 09 00 00 40 82 00 0C 7D 60 19 2D 40 A2 FF F0 4C 00 01 2C 2F 89 00 00 40 9E 00 CC 80 7F 00 48 93 A3 00 08 81 23 00 04 38 09 00 01 90 03 00 04 57 C4 06 3E 7F E3 FB 78 4? ?? ?? ?? 80 1F 00 00 7C 7E 1B 78 70 09 80 00 40 82 00 38 80 7F 00 48 81 23 00 04 38 09 FF FF 2F 80 00 00 90 03 00 04 40 9E 00 20 90 03 00 08 7C 00 04 AC 7D 20 18 28 7C 00 19 2D 40 A2 FF F8 2F 89 00 01 41 9D 00 48 80 01 00 24 7F C3 F3 78 83 A1 00 14 7C 08 03 A6 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 80 01 00 24 3B C0 FF FF 7F C3 F3 78 83 A1 00 14 7C 08 03 A6 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 80 82 8B 68 38 00 00 DD 38 A0 00 01 60 84 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF A0 4? ?? ?? ?? 4B FF FF 34 80 1F 00 00 7C 7E 1B 78 70 09 80 00 40 82 00 54 80 7F 00 48 80 03 00 04 30 00 FF FF 2F 80 00 00 90 03 00 04 40 9E 00 3C 90 03 00 08 7C 00 04 AC 7D 20 18 28 7C 00 19 2D 40 A2 FF F8 2F 89 00 01 40 BD 00 20 80 82 8B 68 38 00 00 DD 38 A0 00 01 60 84 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 7F C3 F3 78 4? ?? ?? ?? }
	condition:
		$1
}

rule file_160_0_0 {
	meta:
		name = "__dladdr1"
		size = 112
		refs = "0028 _dl_addr"
	strings:
		$1 = { 2F 86 00 01 7C 08 02 A6 94 21 FF F0 90 01 00 14 7C A0 2B 78 41 9E 00 28 2F 86 00 02 41 9E 00 3C 38 A0 00 00 38 C0 00 00 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 7C 06 03 78 38 A0 00 00 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 38 C0 00 00 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_161_0_0 {
	meta:
		name = "__fxprintf"
		size = 416
		refs = "009c strlen 010c __vfwprintf 014c _IO_vfprintf 0176 stderr 019c __assert_fail"
	strings:
		$1 = { 94 21 FF 80 7C 08 02 A6 93 E1 00 7C 7C 3F 0B 78 93 C1 00 78 7C 7E 1B 78 90 01 00 84 93 81 00 70 93 A1 00 74 90 BF 00 18 90 DF 00 1C 90 FF 00 20 91 1F 00 24 91 3F 00 28 91 5F 00 2C 40 86 00 24 D8 3F 00 30 D8 5F 00 38 D8 7F 00 40 D8 9F 00 48 D8 BF 00 50 D8 DF 00 58 D8 FF 00 60 D9 1F 00 68 2F 9E 00 00 7C 9C 23 78 41 9E 01 0C 38 00 00 02 98 1F 00 08 38 00 00 00 39 3F 00 88 98 1F 00 09 80 1E 00 6C 91 3F 00 0C 2F 80 00 00 38 1F 00 10 90 1F 00 10 40 9D 00 AC 7F 83 E3 78 4? ?? ?? ?? 7C 3D 0B 78 38 63 00 01 54 69 10 3A 38 09 00 1E 81 21 00 00 54 00 00 36 2F 83 00 00 7C 00 00 D0 7D 21 01 6E 38 81 00 17 54 84 00 36 41 9E 00 38 88 1C 00 00 70 09 00 80 40 82 00 A8 39 64 FF FC 7C 69 03 A6 39 20 00 00 48 00 00 10 7C 1C 48 AE 70 0A 00 80 40 82 00 8C 94 0B 00 04 39 29 00 01 42 00 FF EC 7F C3 F3 78 38 BF 00 08 4? ?? ?? ?? 80 01 00 00 39 7F 00 80 90 1D 00 00 80 0B 00 04 7F A1 EB 78 83 8B FF F0 7C 08 03 A6 83 AB FF F4 83 CB FF F8 83 EB FF FC 7D 61 5B 78 4E 80 00 20 7F C3 F3 78 7F 84 E3 78 38 BF 00 08 4? ?? ?? ?? 39 7F 00 80 80 0B 00 04 83 8B FF F0 7C 08 03 A6 83 AB FF F4 83 CB FF F8 83 EB FF FC 7D 61 5B 78 4E 80 00 20 3D 20 ?? ?? 83 C9 ?? ?? 4B FF FE F0 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 00 2F 38 C6 ?? ?? 4? ?? ?? ?? }
	condition:
		$1
}

rule file_162_0_0 {
	meta:
		name = "__vdprintf_chk"
		size = 264
		refs = "000a _IO_wfile_jumps 0050 _IO_no_init 0056 _IO_file_jumps 0064 _IO_file_init 0070 _IO_file_attach 00b4 _IO_vfprintf 00fc _IO_un_link"
	strings:
		$1 = { 94 21 FE 80 7C 08 02 A6 3C E0 ?? ?? 93 81 01 70 7C 9C 23 78 38 80 00 00 38 E7 ?? ?? 90 01 01 84 60 84 80 00 38 00 00 00 93 A1 01 74 7C BD 2B 78 93 C1 01 78 38 A0 00 00 7C DE 33 78 93 E1 01 7C 38 C1 00 A8 7C 7F 1B 78 38 61 00 08 90 01 00 50 4? ?? ?? ?? 3D 20 ?? ?? 38 09 ?? ?? 38 61 00 08 90 01 00 A0 4? ?? ?? ?? 38 61 00 08 7F E4 FB 78 4? ?? ?? ?? 2F 83 00 00 41 9E 00 80 80 01 00 08 2F 9C 00 00 39 20 EF F3 60 00 00 40 7C 00 48 38 60 00 00 04 90 01 00 08 40 9D 00 10 80 01 00 44 60 00 00 04 90 01 00 44 7F A4 EB 78 38 61 00 08 7F C5 F3 78 4? ?? ?? ?? 81 21 00 A0 7C 7F 1B 78 80 09 00 08 38 61 00 08 38 80 00 00 7C 09 03 A6 4E 80 04 21 80 01 01 84 7F E3 FB 78 83 81 01 70 7C 08 03 A6 83 A1 01 74 83 C1 01 78 83 E1 01 7C 38 21 01 80 4E 80 00 20 38 61 00 08 4? ?? ?? ?? 3B E0 FF FF 4B FF FF D0 }
	condition:
		$1
}

rule file_163_0_0 {
	meta:
		name = "__tcgetattr"
		size = 244
		refs = "00da _GLOBAL_OFFSET_TABLE_ 00e2 __libc_errno"
	strings:
		$1 = { 94 21 FF B0 38 00 00 36 93 E1 00 4C 7C 9F 23 78 3C 80 40 2C 93 61 00 3C 60 84 74 13 38 A1 00 08 93 81 00 40 93 A1 00 44 93 C1 00 48 44 00 00 02 7C 00 00 26 74 09 10 00 40 82 00 A0 2F 83 00 00 40 9E 00 7C 80 A1 00 08 80 C1 00 0C 80 E1 00 10 81 01 00 14 89 41 00 2B 81 61 00 2C 80 01 00 30 83 81 00 1C 83 A1 00 20 83 C1 00 24 A1 81 00 28 88 81 00 2A 83 61 00 18 90 7F 00 24 93 7F 00 11 93 9F 00 15 93 BF 00 19 93 DF 00 1D B1 9F 00 21 98 9F 00 23 90 BF 00 00 90 DF 00 04 90 FF 00 08 91 1F 00 0C 99 5F 00 10 91 7F 00 34 90 1F 00 38 90 7F 00 28 90 7F 00 2C 98 7F 00 30 83 61 00 3C 83 81 00 40 83 A1 00 44 83 C1 00 48 83 E1 00 4C 38 21 00 50 4E 80 00 20 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 90 69 00 00 38 60 FF FF 4B FF FF CC }
	condition:
		$1
}

rule file_164_0_0 {
	meta:
		name = "ptrace"
		size = 176
		refs = "0072 _GLOBAL_OFFSET_TABLE_ 007e __libc_errno"
	strings:
		$1 = { 38 03 FF FF 94 21 FF D0 2B 80 00 02 38 01 00 38 93 E1 00 2C 7C 7F 1B 78 90 01 00 10 38 01 00 18 90 01 00 14 38 00 00 04 90 81 00 1C 90 A1 00 20 90 C1 00 24 98 01 00 0C 41 9D 00 08 38 C1 00 08 38 00 00 1A 7F E3 FB 78 44 00 00 02 7C 00 00 26 74 00 10 00 40 82 00 40 2F 83 00 00 41 9C 00 2C 2F 9F 00 00 41 9E 00 24 2B 9F 00 03 41 9D 00 1C 3D 20 ?? ?? 80 61 00 08 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 90 09 00 00 83 E1 00 2C 38 21 00 30 4E 80 00 20 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 90 69 00 00 38 60 FF FF 4B FF FF DC }
	condition:
		$1
}

rule file_165_0_0 {
	meta:
		name = "__inet_aton"
		size = 416
		refs = "0030 __errno_location 0070 strtoul 0152 _GLOBAL_OFFSET_TABLE_ 015a __libc_tsd_CTYPE_B 0182 _nl_current_LC_CTYPE"
		altNames = "inet_aton"
	strings:
		$1 = { 94 21 FF C0 7C 08 02 A6 93 21 00 24 7C 99 23 78 90 01 00 44 93 61 00 2C 93 A1 00 34 93 C1 00 38 7C 7E 1B 78 93 41 00 28 93 81 00 30 93 E1 00 3C 4? ?? ?? ?? 38 00 00 00 83 63 00 00 7C 7D 1B 78 90 03 00 00 90 01 00 08 89 3E 00 00 38 09 FF D0 2B 80 00 09 41 9D 00 64 3B 41 00 08 3B 81 00 0B 7F 5F D3 78 7F C3 F3 78 38 81 00 0C 38 A0 00 00 4? ?? ?? ?? 7F 1F E0 00 2F 83 FF FF 28 83 00 FF 41 9E 00 6C 81 21 00 0C 88 09 00 00 2F 80 00 2E 40 9E 00 6C 41 9A 00 24 3B C9 00 01 41 85 00 1C 98 7F 00 00 3B FF 00 01 89 29 00 01 38 09 FF D0 2B 80 00 09 40 9D FF B0 93 7D 00 00 38 60 00 00 80 01 00 44 83 21 00 24 7C 08 03 A6 83 41 00 28 83 61 00 2C 83 81 00 30 83 A1 00 34 83 C1 00 38 83 E1 00 3C 38 21 00 40 4E 80 00 20 80 1D 00 00 2F 80 00 22 40 9E FF 90 4B FF FF C0 2F 80 00 00 40 9E 00 48 7F 89 F0 00 41 BE FF B0 7C 1A F8 50 3D 20 ?? ?? 54 00 10 3A 39 29 ?? ?? 7C 09 00 2E 7F 83 00 40 41 BD FF 94 2F 99 00 00 41 9E 00 10 80 01 00 08 7C 63 03 78 90 79 00 00 93 7D 00 00 38 60 00 01 4B FF FF 7C 70 0B 00 80 40 A2 FF 6C 3D 00 ?? ?? 39 08 ?? ?? 81 48 ?? ?? 7D 4A 12 14 81 6A 00 00 2F 8B 00 00 41 9E 00 18 54 00 08 3C 7C 0B 02 2E 70 0B 00 20 41 A2 FF 40 4B FF FF 88 81 68 ?? ?? 7D 6B 12 14 81 6B 00 00 81 6B 00 00 81 6B 00 24 39 6B 01 00 91 6A 00 00 4B FF FF D0 }
	condition:
		$1
}

rule file_165_1_0 {
	meta:
		name = "inet_addr"
		size = 52
		refs = "0010 __inet_aton"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 38 81 00 08 90 01 00 24 4? ?? ?? ?? 2F 83 00 00 38 60 FF FF 41 9E 00 08 80 61 00 08 80 01 00 24 38 21 00 20 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_166_1_0 {
	meta:
		name = "svcunix_getargs"
		size = 56
		altNames = "svctcp_getargs"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 7C 80 23 78 7C 09 03 A6 7C A4 2B 78 80 63 00 2C 38 63 00 08 4C C6 31 82 4E 80 04 21 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_166_2_0 {
	meta:
		name = "svcunix_freeargs"
		size = 60
		altNames = "svctcp_freeargs"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 38 00 00 02 80 63 00 2C 94 03 00 08 7C 80 23 78 7C 09 03 A6 7C A4 2B 78 4C C6 31 82 4E 80 04 21 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_166_3_0 {
	meta:
		name = "makefd_xprt"
		size = 312
		refs = "0034 malloc 0084 xdrrec_create 00b8 xprt_register 00ee _libc_intl_domainname 00fc __dcgettext 011c __fxprintf 0124 free"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 93 A1 00 14 7C 7D 1B 78 38 60 01 34 90 01 00 24 93 41 00 08 7C 9A 23 78 93 61 00 0C 7C BB 2B 78 93 81 00 10 93 C1 00 18 93 E1 00 1C 4? ?? ?? ?? 7C 7F 1B 78 38 60 01 B0 4? ?? ?? ?? 2F 9F 00 00 7F FC FB 78 7C 7E 1B 78 41 9E 00 98 2F 83 00 00 41 9E 00 90 3C E0 ?? ?? 3D 00 ?? ?? 38 00 00 02 38 63 00 08 90 1E 00 00 7F 44 D3 78 7F 65 DB 78 7F E6 FB 78 38 E7 ?? ?? 39 08 ?? ?? 4? ?? ?? ?? 39 3E 00 20 91 3F 00 24 3D 20 ?? ?? 38 00 00 00 39 29 ?? ?? 90 1F 00 30 7F E3 FB 78 93 DF 00 2C 90 1F 00 0C 91 3F 00 08 B0 1F 00 04 93 BF 00 00 4? ?? ?? ?? 80 01 00 24 7F E3 FB 78 83 41 00 08 7C 08 03 A6 83 61 00 0C 83 81 00 10 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 3C 80 ?? ?? 3C 60 ?? ?? 38 84 ?? ?? 38 A0 00 05 38 63 ?? ?? 4? ?? ?? ?? 3C 80 ?? ?? 3C A0 ?? ?? 7C 66 1B 78 38 84 ?? ?? 38 A5 ?? ?? 38 60 00 00 4C C6 31 82 4? ?? ?? ?? 7F 83 E3 78 4? ?? ?? ?? 7F C3 F3 78 4? ?? ?? ?? 3B E0 00 00 4B FF FF 88 }
	condition:
		$1
}

rule file_166_4_0 {
	meta:
		name = "readunix"
		size = 368
		refs = "004c __poll 00d8 __setsockopt 00f0 __recvmsg 00fc __errno_location"
	strings:
		$1 = { 94 21 FF B0 7C 08 02 A6 90 01 00 54 93 E1 00 4C 83 E3 00 00 93 61 00 3C 3B 60 00 01 93 81 00 40 7C 9C 23 78 93 A1 00 44 7C BD 2B 78 93 C1 00 48 7C 7E 1B 78 38 A0 00 00 93 E1 00 0C 38 80 00 01 60 A5 88 B8 B3 61 00 10 38 61 00 0C 4? ?? ?? ?? 2F 83 FF FF 2F 03 00 00 41 9E 00 E8 41 9A 00 B0 A1 21 00 12 55 2B DF FE 2F 8B 00 00 71 2B 00 18 7D 20 4B 78 40 82 00 98 40 9E 00 94 70 09 00 01 41 82 FF B4 39 20 00 01 93 81 00 14 7C 26 0B 78 95 26 00 08 38 00 00 00 39 61 00 14 91 21 00 28 3D 20 ?? ?? 39 29 ?? ?? 91 21 00 2C 7F E3 FB 78 39 20 00 1C 38 80 00 01 93 A1 00 18 38 A0 00 14 38 E0 00 04 91 61 00 24 90 01 00 1C 90 01 00 20 91 21 00 30 90 01 00 34 4? ?? ?? ?? 2F 83 00 00 40 9E 00 2C 38 81 00 1C 38 A0 00 00 7F E3 FB 78 4? ?? ?? ?? 2C 03 00 00 40 80 00 60 4? ?? ?? ?? 80 03 00 00 2F 80 00 04 41 9E FF DC 81 3E 00 2C 38 00 00 00 38 60 FF FF 90 09 00 00 80 01 00 54 83 61 00 3C 7C 08 03 A6 83 81 00 40 83 A1 00 44 83 C1 00 48 83 E1 00 4C 38 21 00 50 4E 80 00 20 4? ?? ?? ?? 80 03 00 00 2F 80 00 04 40 BE FF C0 A0 01 00 12 4B FF FF 28 80 01 00 34 54 0B EF FE 2F 8B 00 00 40 BE FF A8 41 A2 FF A4 4B FF FF B0 }
	condition:
		$1
}

rule file_166_5_0 {
	meta:
		name = "writeunix"
		size = 352
		refs = "007c __getpid 0084 __geteuid 008c __getegid 00d8 __sendmsg 00e4 __errno_location"
	strings:
		$1 = { 94 21 FF 90 7C 08 02 A6 92 81 00 40 7C B4 2B 79 92 E1 00 4C 7C 97 23 78 93 01 00 50 7C 78 1B 78 90 01 00 74 92 41 00 38 92 61 00 3C 92 A1 00 44 92 C1 00 48 93 21 00 54 93 41 00 58 93 61 00 5C 93 81 00 60 93 A1 00 64 93 C1 00 68 93 E1 00 6C 40 81 00 B4 3F C0 ?? ?? 3B DE ?? ?? 3B 9E 00 0C 7E 99 A3 78 3A A1 00 08 3B 40 00 01 3A C0 00 02 3B 60 00 18 3B A0 00 00 83 F8 00 00 4? ?? ?? ?? 7C 72 1B 78 4? ?? ?? ?? 7C 73 1B 78 4? ?? ?? ?? 90 7C 00 08 92 5C 00 00 92 7C 00 04 93 7E 00 00 93 5E 00 04 92 DE 00 08 92 E1 00 08 93 21 00 0C 92 A1 00 18 93 41 00 1C 93 A1 00 10 93 A1 00 14 93 C1 00 20 93 61 00 24 93 A1 00 28 38 81 00 10 38 A0 00 00 7F E3 FB 78 4? ?? ?? ?? 2C 03 00 00 40 80 00 70 4? ?? ?? ?? 80 03 00 00 2F 80 00 04 41 9E FF DC 81 38 00 2C 38 00 00 00 3A 80 FF FF 90 09 00 00 80 01 00 74 7E 83 A3 78 82 41 00 38 7C 08 03 A6 82 61 00 3C 82 81 00 40 82 A1 00 44 82 C1 00 48 82 E1 00 4C 83 01 00 50 83 21 00 54 83 41 00 58 83 61 00 5C 83 81 00 60 83 A1 00 64 83 C1 00 68 83 E1 00 6C 38 21 00 70 4E 80 00 20 7F 23 C8 51 40 A1 FF B0 7E F7 1A 14 4B FF FF 1C }
	condition:
		$1
}

rule file_166_6_0 {
	meta:
		name = "svcunix_destroy"
		size = 168
		refs = "001c xprt_unregister 0024 __close 0054 free"
		altNames = "svctcp_destroy"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 93 E1 00 0C 7C 7F 1B 78 93 C1 00 08 83 C3 00 2C 4? ?? ?? ?? 80 7F 00 00 4? ?? ?? ?? A0 1F 00 04 2F 80 00 00 40 9E 00 48 81 3E 00 0C 80 09 00 1C 2F 80 00 00 41 9E 00 10 38 7E 00 08 7C 09 03 A6 4E 80 04 21 7F C3 F3 78 4? ?? ?? ?? 7F E3 FB 78 4? ?? ?? ?? 80 01 00 14 83 C1 00 08 7C 08 03 A6 83 E1 00 0C 38 21 00 10 4E 80 00 20 38 00 00 00 B0 1F 00 04 7F C3 F3 78 4? ?? ?? ?? 7F E3 FB 78 4? ?? ?? ?? 80 01 00 14 83 C1 00 08 7C 08 03 A6 83 E1 00 0C 38 21 00 10 4E 80 00 20 }
	condition:
		$1
}

rule file_166_7_0 {
	meta:
		name = "svcunix_reply"
		size = 96
		refs = "0030 xdr_replymsg 0040 xdrrec_endofrecord"
		altNames = "svctcp_reply"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 39 60 00 00 90 01 00 14 81 23 00 2C 93 C1 00 08 80 09 00 04 93 E1 00 0C 3B E9 00 08 7F E3 FB 78 91 69 00 08 90 04 00 00 4? ?? ?? ?? 38 80 00 01 7C 7E 1B 78 7F E3 FB 78 4? ?? ?? ?? 80 01 00 14 7F C3 F3 78 83 E1 00 0C 7C 08 03 A6 83 C1 00 08 38 21 00 10 4E 80 00 20 }
	condition:
		$1
}

rule file_166_8_0 {
	meta:
		name = "svcunix_stat"
		size = 88
		refs = "0034 xdrrec_eof"
		altNames = "svctcp_stat"
	strings:
		$1 = { 7C 08 02 A6 94 21 FF F0 90 01 00 14 81 23 00 2C 38 60 00 00 80 09 00 00 2F 80 00 00 40 9E 00 14 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 38 69 00 08 4? ?? ?? ?? 2F 83 00 00 38 60 00 02 40 9E FF E0 80 01 00 14 38 60 00 01 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_166_9_0 {
	meta:
		name = "svcunix_recv"
		size = 184
		refs = "0034 xdrrec_skiprecord 0040 xdr_callmsg"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 90 01 00 24 93 E1 00 1C 83 E3 00 2C 93 81 00 10 3B 80 00 01 93 A1 00 14 3B BF 00 08 7F A3 EB 78 93 C1 00 18 7C 9E 23 78 93 9F 00 08 4? ?? ?? ?? 7F A3 EB 78 7F C4 F3 78 4? ?? ?? ?? 2C 03 00 00 40 82 00 2C 80 01 00 24 90 7F 00 00 38 60 00 00 7C 08 03 A6 83 81 00 10 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 80 1E 00 00 3D 20 ?? ?? 38 60 00 01 90 1F 00 04 38 09 ?? ?? 90 1E 00 28 38 00 00 1C 93 9E 00 24 90 1E 00 2C 80 01 00 24 83 81 00 10 7C 08 03 A6 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 }
	condition:
		$1
}

rule file_166_11_0 {
	meta:
		name = "rendezvous_request"
		size = 224
		refs = "0034 accept 0040 __errno_location"
	strings:
		$1 = { 94 21 FF 50 7C 08 02 A6 90 01 00 B4 93 A1 00 A4 83 A3 00 2C 93 C1 00 A8 3B C0 00 6E 93 E1 00 AC 7C 7F 1B 78 80 7F 00 00 38 81 00 1C 38 A1 00 08 93 C1 00 08 4? ?? ?? ?? 2F 83 00 00 40 9C 00 34 4? ?? ?? ?? 80 03 00 00 2F 80 00 04 41 9E FF D8 80 01 00 B4 38 60 00 00 83 A1 00 A4 7C 08 03 A6 83 C1 00 A8 83 E1 00 AC 38 21 00 B0 4E 80 00 20 38 00 00 00 80 9D 00 00 80 BD 00 04 90 01 00 0C 90 01 00 10 90 01 00 14 90 01 00 18 38 00 00 01 B0 01 00 0C 4B FF F9 3D 80 01 00 18 81 61 00 10 81 21 00 14 81 41 00 0C 91 63 00 14 91 43 00 10 91 23 00 18 90 03 00 1C 80 01 00 08 83 A1 00 A4 90 03 00 0C 38 60 00 00 80 01 00 B4 83 C1 00 A8 7C 08 03 A6 83 E1 00 AC 38 21 00 B0 4E 80 00 20 }
	condition:
		$1
}

rule file_166_12_0 {
	meta:
		name = "svcunix_create"
		size = 564
		refs = "0058 memset 0068 strlen 007c memcpy 0094 __bind 00a4 __getsockname 00b8 __listen 00c8 malloc 00f2 _null_auth 013c xprt_register 0176 _libc_intl_domainname 0184 __dcgettext 0188 perror 019c __close 01b0 __socket 0218 __fxprintf 0220 free"
	strings:
		$1 = { 2F 83 FF FF 94 21 FF 50 7C 08 02 A6 93 41 00 98 3B 40 00 00 90 01 00 B4 38 00 00 10 93 81 00 A0 7C 9C 23 78 93 A1 00 A4 7C BD 2B 78 93 C1 00 A8 7C DE 33 78 93 E1 00 AC 7C 7F 1B 78 93 21 00 94 93 61 00 9C 90 01 00 08 41 9E 01 5C 38 80 00 00 38 A0 00 6E 38 61 00 0C 4? ?? ?? ?? 38 00 00 01 7F C3 F3 78 B0 01 00 0C 4? ?? ?? ?? 7F C4 F3 78 38 A3 00 01 7C 7B 1B 78 38 61 00 0E 4? ?? ?? ?? 7C 3E 0B 78 38 BB 00 03 94 BE 00 08 38 81 00 0C 7F E3 FB 78 4? ?? ?? ?? 7F E3 FB 78 38 81 00 0C 7F C5 F3 78 4? ?? ?? ?? 2F 83 00 00 40 9E 00 C4 7F E3 FB 78 38 80 00 80 4? ?? ?? ?? 7C 79 1B 79 40 82 00 B0 38 60 00 08 4? ?? ?? ?? 7C 7E 1B 78 38 60 01 34 4? ?? ?? ?? 2F 9E 00 00 7C 7A 1B 78 7C 7B 1B 78 41 9E 01 00 2F 83 00 00 41 9E 00 F8 3D 60 ?? ?? 93 23 00 30 39 2B ?? ?? 80 09 00 08 81 4B ?? ?? 81 69 00 04 3D 20 ?? ?? 39 29 ?? ?? 90 03 00 28 38 09 00 18 90 03 00 08 38 00 FF FF 93 C3 00 2C 91 43 00 20 91 63 00 24 B0 03 00 04 93 E3 00 00 93 9E 00 00 93 BE 00 04 4? ?? ?? ?? 80 01 00 B4 7F 43 D3 78 83 21 00 94 7C 08 03 A6 83 41 00 98 83 61 00 9C 83 81 00 A0 83 A1 00 A4 83 C1 00 A8 83 E1 00 AC 38 21 00 B0 4E 80 00 20 3C 80 ?? ?? 3C 60 ?? ?? 38 84 ?? ?? 38 A0 00 05 38 63 ?? ?? 4? ?? ?? ?? 4? ?? ?? ?? 2F 9A 00 00 3B 40 00 00 41 9E FF AC 7F E3 FB 78 4? ?? ?? ?? 4B FF FF A0 38 60 00 01 38 80 00 01 38 A0 00 00 4? ?? ?? ?? 3B 40 00 01 7C 7F 1B 79 40 80 FE 90 3C 80 ?? ?? 3C 60 ?? ?? 38 84 ?? ?? 38 A0 00 05 38 63 ?? ?? 4? ?? ?? ?? 3B 40 00 00 4? ?? ?? ?? 4B FF FF 60 3C 80 ?? ?? 3C 60 ?? ?? 38 84 ?? ?? 38 A0 00 05 38 63 ?? ?? 4? ?? ?? ?? 3C 80 ?? ?? 3C A0 ?? ?? 7C 66 1B 78 38 84 ?? ?? 38 A5 ?? ?? 38 60 00 00 4C C6 31 82 4? ?? ?? ?? 7F C3 F3 78 4? ?? ?? ?? 7F 63 DB 78 4? ?? ?? ?? 3B 40 00 00 4B FF FF 10 }
	condition:
		$1
}

rule file_167_0_0 {
	meta:
		name = "strerror"
		size = 204
		refs = "0028 __strerror_r 005e _GLOBAL_OFFSET_TABLE_ 006a __libc_errno 00a4 malloc 00b2 _libc_intl_domainname 00c4 __dcgettext"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 38 80 00 00 38 A0 00 00 93 E1 00 1C 7C 7F 1B 78 90 01 00 24 93 81 00 10 93 A1 00 14 93 C1 00 18 4? ?? ?? ?? 2C 03 00 00 41 82 00 24 80 01 00 24 83 81 00 10 7C 08 03 A6 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 3F C0 ?? ?? 80 1E ?? ?? 3F A0 ?? ?? 3B BD ?? ?? 2F 80 00 00 81 3D ?? ?? 7D 29 12 14 83 89 00 00 41 9E 00 2C 80 9E ?? ?? 81 3D ?? ?? 7D 29 12 14 2F 84 00 00 93 89 00 00 41 9E 00 24 7F E3 FB 78 38 A0 04 00 4? ?? ?? ?? 4B FF FF 98 38 60 04 00 4? ?? ?? ?? 90 7E ?? ?? 4B FF FF CC 3C 60 ?? ?? 3C 80 ?? ?? 38 84 ?? ?? 38 A0 00 05 38 63 ?? ?? 4? ?? ?? ?? 4B FF FF 6C }
	condition:
		$1
}

rule file_169_0_0 {
	meta:
		name = "__syscall_error"
		size = 28
		refs = "0002 _GLOBAL_OFFSET_TABLE_ 000a __libc_errno"
	strings:
		$1 = { 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 90 69 00 00 38 60 FF FF 4E 80 00 20 }
	condition:
		$1
}

rule file_18_0_3 {
	meta:
		name = "__syscall_error"
		size = 28
		refs = "0002 _GLOBAL_OFFSET_TABLE_ 000a errno"
	strings:
		$1 = { 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 90 69 00 00 38 60 FF FF 4E 80 00 20 }
	condition:
		$1
}

rule file_170_0_0 {
	meta:
		name = "__chown"
		size = 48
		refs = "0016 _GLOBAL_OFFSET_TABLE_ 001e __libc_errno"
	strings:
		$1 = { 38 00 00 B5 44 00 00 02 7C 00 00 26 74 09 10 00 4D A2 00 20 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 90 69 00 00 38 60 FF FF 4E 80 00 20 }
	condition:
		$1
}

rule file_171_0_0 {
	meta:
		name = "___fprintf_chk"
		size = 564
		refs = "0100 vfprintf 01b4 __lll_lock_wait_private 0230 _Unwind_Resume"
	strings:
		$1 = { 94 21 FF 70 7C 08 02 A6 7D 80 00 26 93 A1 00 84 7C 9D 23 78 93 E1 00 8C 7C 7F 1B 78 90 01 00 94 93 81 00 80 93 C1 00 88 91 81 00 7C 90 C1 00 1C 90 E1 00 20 91 01 00 24 91 21 00 28 91 41 00 2C 40 86 00 24 D8 21 00 30 D8 41 00 38 D8 61 00 40 D8 81 00 48 D8 A1 00 50 D8 C1 00 58 D8 E1 00 60 D9 01 00 68 80 1F 00 00 7C BE 2B 78 70 00 80 00 40 82 00 50 80 7F 00 48 3B 82 8B 60 81 23 00 08 7F 89 E0 00 41 9E 00 30 39 60 00 01 7D 20 18 28 7C 09 00 00 40 82 00 0C 7D 60 19 2D 40 A2 FF F0 4C 00 01 2C 2F 89 00 00 40 9E 01 0C 80 7F 00 48 93 83 00 08 81 23 00 04 38 09 00 01 90 03 00 04 2E 1D 00 00 40 91 00 10 80 1F 00 3C 60 00 00 04 90 1F 00 3C 38 00 00 03 98 01 00 08 38 00 00 00 7F E3 FB 78 98 01 00 09 38 01 00 98 7F C4 F3 78 90 01 00 0C 38 A1 00 08 38 01 00 10 90 01 00 10 4? ?? ?? ?? 7C 7E 1B 78 40 91 00 84 80 1F 00 3C 54 00 07 B8 81 3F 00 00 71 2B 80 00 39 20 FF EB 7C 00 48 38 90 1F 00 3C 40 82 00 38 80 7F 00 48 81 23 00 04 38 09 FF FF 2F 80 00 00 90 03 00 04 40 9E 00 20 90 03 00 08 7C 00 04 AC 7D 20 18 28 7C 00 19 2D 40 A2 FF F8 2F 89 00 01 41 9D 00 38 80 01 00 94 7F C3 F3 78 81 81 00 7C 7C 08 03 A6 83 81 00 80 83 A1 00 84 7D 80 81 20 83 C1 00 88 83 E1 00 8C 38 21 00 90 4E 80 00 20 80 1F 00 3C 4B FF FF 84 80 82 8B 68 38 00 00 DD 38 A0 00 01 60 84 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF B0 4? ?? ?? ?? 4B FF FE F4 80 1F 00 00 7C 7E 1B 78 81 3F 00 3C 70 0B 80 00 38 00 FF EB 7D 20 00 38 90 1F 00 3C 40 82 00 54 80 7F 00 48 80 03 00 04 30 00 FF FF 2F 80 00 00 90 03 00 04 40 9E 00 3C 90 03 00 08 7C 00 04 AC 7D 20 18 28 7C 00 19 2D 40 A2 FF F8 2F 89 00 01 40 BD 00 20 80 82 8B 68 38 00 00 DD 38 A0 00 01 60 84 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 7F C3 F3 78 4? ?? ?? ?? }
	condition:
		$1
}

rule file_326_0_0 {
	meta:
		name = "__fwprintf_chk"
		size = 564
		refs = "0100 _IO_vfwprintf 01b4 __lll_lock_wait_private 0230 _Unwind_Resume"
	strings:
		$1 = { 94 21 FF 70 7C 08 02 A6 7D 80 00 26 93 A1 00 84 7C 9D 23 78 93 E1 00 8C 7C 7F 1B 78 90 01 00 94 93 81 00 80 93 C1 00 88 91 81 00 7C 90 C1 00 1C 90 E1 00 20 91 01 00 24 91 21 00 28 91 41 00 2C 40 86 00 24 D8 21 00 30 D8 41 00 38 D8 61 00 40 D8 81 00 48 D8 A1 00 50 D8 C1 00 58 D8 E1 00 60 D9 01 00 68 80 1F 00 00 7C BE 2B 78 70 00 80 00 40 82 00 50 80 7F 00 48 3B 82 8B 60 81 23 00 08 7F 89 E0 00 41 9E 00 30 39 60 00 01 7D 20 18 28 7C 09 00 00 40 82 00 0C 7D 60 19 2D 40 A2 FF F0 4C 00 01 2C 2F 89 00 00 40 9E 01 0C 80 7F 00 48 93 83 00 08 81 23 00 04 38 09 00 01 90 03 00 04 2E 1D 00 00 40 91 00 10 80 1F 00 3C 60 00 00 04 90 1F 00 3C 38 00 00 03 98 01 00 08 38 00 00 00 7F E3 FB 78 98 01 00 09 38 01 00 98 7F C4 F3 78 90 01 00 0C 38 A1 00 08 38 01 00 10 90 01 00 10 4? ?? ?? ?? 7C 7E 1B 78 40 91 00 84 80 1F 00 3C 54 00 07 B8 81 3F 00 00 71 2B 80 00 39 20 FF EB 7C 00 48 38 90 1F 00 3C 40 82 00 38 80 7F 00 48 81 23 00 04 38 09 FF FF 2F 80 00 00 90 03 00 04 40 9E 00 20 90 03 00 08 7C 00 04 AC 7D 20 18 28 7C 00 19 2D 40 A2 FF F8 2F 89 00 01 41 9D 00 38 80 01 00 94 7F C3 F3 78 81 81 00 7C 7C 08 03 A6 83 81 00 80 83 A1 00 84 7D 80 81 20 83 C1 00 88 83 E1 00 8C 38 21 00 90 4E 80 00 20 80 1F 00 3C 4B FF FF 84 80 82 8B 68 38 00 00 DD 38 A0 00 01 60 84 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF B0 4? ?? ?? ?? 4B FF FE F4 80 1F 00 00 7C 7E 1B 78 81 3F 00 3C 70 0B 80 00 38 00 FF EB 7D 20 00 38 90 1F 00 3C 40 82 00 54 80 7F 00 48 80 03 00 04 30 00 FF FF 2F 80 00 00 90 03 00 04 40 9E 00 3C 90 03 00 08 7C 00 04 AC 7D 20 18 28 7C 00 19 2D 40 A2 FF F8 2F 89 00 01 40 BD 00 20 80 82 8B 68 38 00 00 DD 38 A0 00 01 60 84 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 7F C3 F3 78 4? ?? ?? ?? }
	condition:
		$1
}

rule file_172_0_0 {
	meta:
		name = "gethostid"
		size = 480
		refs = "0034 __open_nocancel 0048 __read_nocancel 0070 __gethostname 00b6 _GLOBAL_OFFSET_TABLE_ 00c2 __libc_errno 00ec __gethostbyname_r 01c8 memcpy"
	strings:
		$1 = { 94 21 FF 70 7C 08 02 A6 3C 60 ?? ?? 93 E1 00 8C 38 63 ?? ?? 7C 3F 0B 78 3C 80 00 01 93 A1 00 84 38 A0 00 00 90 01 00 94 93 81 00 80 93 C1 00 88 4C C6 31 82 4? ?? ?? ?? 7C 7D 1B 79 41 80 00 2C 38 9F 00 0C 38 A0 00 04 4? ?? ?? ?? 38 00 00 06 7C 7E 1B 78 7F A3 EB 78 44 00 00 02 7C 00 00 26 2F 9E 00 04 41 9E 01 1C 38 7F 00 2C 38 80 00 40 4? ?? ?? ?? 2F 83 00 00 38 60 00 00 41 9C 00 10 88 1F 00 2C 2F 80 00 00 40 9E 00 28 39 7F 00 90 80 0B 00 04 83 8B FF F0 7C 08 03 A6 83 AB FF F4 83 CB FF F8 83 EB FF FC 7D 61 5B 78 4E 80 00 20 80 01 00 00 3F 80 ?? ?? 3B 9C ?? ?? 94 01 FB F0 83 9C ?? ?? 3B C0 04 00 3B A1 00 17 57 BD 00 36 7F 9C 12 14 7F C6 F3 78 7F A5 EB 78 38 7F 00 2C 38 9F 00 18 38 FF 00 08 39 1F 00 14 4? ?? ?? ?? 57 C9 08 3C 2C 03 00 00 38 09 00 1E 54 00 00 36 7C 00 00 D0 40 82 00 10 81 7F 00 08 2F 8B 00 00 40 9E 00 98 81 7F 00 14 2F 8B FF FF 40 9E 00 3C 81 7C 00 00 2F 8B 00 22 40 9E 00 30 81 61 00 00 7F DE 4A 14 7D 61 01 6E 38 01 00 17 54 00 00 36 7D 60 4A 14 7F 9D 58 00 41 9E 00 08 7D 3E 4B 78 7C 1D 03 78 4B FF FF 80 39 7F 00 90 80 0B 00 04 38 60 00 00 83 8B FF F0 7C 08 03 A6 83 AB FF F4 83 CB FF F8 83 EB FF FC 7D 61 5B 78 4E 80 00 20 39 7F 00 90 80 7F 00 0C 80 0B 00 04 83 8B FF F0 7C 08 03 A6 83 AB FF F4 83 CB FF F8 83 EB FF FC 7D 61 5B 78 4E 80 00 20 80 AB 00 0C 7F EA FB 78 94 6A 00 10 2F 85 00 04 41 9D 00 20 81 2B 00 10 7D 43 53 78 80 89 00 00 4? ?? ?? ?? 80 7F 00 10 54 63 80 3E 4B FF FE B8 38 A0 00 04 4B FF FF E0 }
	condition:
		$1
}

rule file_173_0_0 {
	meta:
		name = "__atomic_writev_replacement"
		size = 504
		refs = "0104 mempcpy 011c __write 0128 free 0176 _GLOBAL_OFFSET_TABLE_ 017e __libc_errno 01a8 __libc_alloca_cutoff 01b8 malloc 01dc _Unwind_Resume"
	strings:
		$1 = { 7D 80 00 26 2E 05 00 00 94 21 FF C0 7C 08 02 A6 93 61 00 2C 7C 7B 1B 78 93 81 00 30 7C BC 2B 78 93 A1 00 34 7C 9D 23 78 93 E1 00 3C 7C 3F 0B 78 90 01 00 44 92 C1 00 18 92 E1 00 1C 93 01 00 20 93 21 00 24 93 41 00 28 93 C1 00 38 91 81 00 14 40 91 01 44 80 04 00 04 3D 40 7F FF 61 4A FF FF 7F 80 50 40 41 9D 01 10 39 20 00 00 7C A9 03 A6 3B C0 00 00 48 00 00 1C 55 2B 18 38 7D 7D 5A 14 80 0B 00 04 7D 7E 50 50 7F 8B 00 40 41 9C 00 E8 7F DE 02 14 39 29 00 01 42 00 FF E0 2B 9E 80 00 41 9D 01 04 38 1E 00 1E 81 21 00 00 54 00 00 36 7C 00 00 D0 7D 21 01 6E 3A C1 00 17 56 D6 00 36 40 91 00 DC 3B 40 00 00 7E C3 B3 78 7F D9 F3 78 3A E0 00 00 48 00 00 14 3A F7 00 01 7F 97 E0 00 3B BD 00 08 41 9E 00 2C 80 1D 00 04 7F 38 CB 78 7F 99 00 40 40 9D 00 08 7C 18 03 78 80 9D 00 00 7F 05 C3 78 4? ?? ?? ?? 7F 38 C8 51 40 82 FF CC 7F 63 DB 78 7E C4 B3 78 7F C5 F3 78 4? ?? ?? ?? 7C 7E 1B 78 7F 43 D3 78 4? ?? ?? ?? 39 7F 00 40 80 0B 00 04 7F C3 F3 78 81 8B FF D4 7C 08 03 A6 82 CB FF D8 82 EB FF DC 7D 80 81 20 83 0B FF E0 83 2B FF E4 83 4B FF E8 83 6B FF EC 83 8B FF F0 83 AB FF F4 83 CB FF F8 83 EB FF FC 7D 61 5B 78 4E 80 00 20 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 38 00 00 16 90 09 00 00 3B C0 FF FF 4B FF FF 9C 3B C0 00 00 4B FF FF 0C 3B 40 00 00 4B FF FF 70 7F C3 F3 78 4? ?? ?? ?? 2F 83 00 00 40 9E FE F4 7F C3 F3 78 4? ?? ?? ?? 7C 76 1B 79 41 82 00 20 7E DA B3 78 4B FF FF 00 7C 7E 1B 78 7F 43 D3 78 4? ?? ?? ?? 7F C3 F3 78 4? ?? ?? ?? 3B 40 00 00 3B C0 FF FF 4B FF FF 3C 7C 7E 1B 78 3B 40 00 00 4B FF FF DC }
	condition:
		$1
}

rule file_173_1_0 {
	meta:
		name = "__libc_writev"
		size = 320
		refs = "007a _GLOBAL_OFFSET_TABLE_ 0082 __libc_errno 00cc __libc_enable_asynccancel 00fc __libc_disable_asynccancel"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 93 A1 00 14 7C 7D 1B 78 93 C1 00 18 7C 9E 23 78 93 E1 00 1C 7C BF 2B 78 90 01 00 24 93 61 00 0C 93 81 00 10 80 02 8B 60 2F 80 00 00 40 9E 00 98 38 00 00 92 44 00 00 02 7C 00 00 26 74 09 10 00 40 82 00 C0 2F 83 00 00 41 9C 00 28 80 01 00 24 83 61 00 0C 7C 08 03 A6 83 81 00 10 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 80 09 00 00 2F 80 00 16 40 9E FF C4 2F 9F 00 08 40 9D FF BC 80 01 00 24 7F A3 EB 78 7F C4 F3 78 83 61 00 0C 7C 08 03 A6 7F E5 FB 78 83 81 00 10 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4B FF FD 40 4? ?? ?? ?? 38 00 00 92 7C 7C 1B 78 7F C4 F3 78 7F A3 EB 78 7F E5 FB 78 44 00 00 02 7C 00 00 26 74 09 10 00 7C 7B 1B 78 40 82 00 30 7F 83 E3 78 4? ?? ?? ?? 7F 63 DB 78 4B FF FF 48 3D 20 ?? ?? 39 29 ?? ?? 81 69 ?? ?? 7D 6B 12 14 90 6B 00 00 38 60 FF FF 4B FF FF 60 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 90 69 00 00 3B 60 FF FF 4B FF FF BC }
	condition:
		$1
}

rule file_174_0_0 {
	meta:
		name = "fexecve"
		size = 264
		refs = "004c __snprintf 0056 _GLOBAL_OFFSET_TABLE_ 0064 __execve 006a __libc_errno 0084 __xstat"
	strings:
		$1 = { 7C 66 1B 79 94 21 FF 60 7C 08 02 A6 93 C1 00 98 7C BE 2B 78 93 E1 00 9C 7C 9F 23 78 90 01 00 A4 93 A1 00 94 41 80 00 AC 2F 84 00 00 41 9E 00 A4 2F 85 00 00 41 9E 00 9C 3C A0 ?? ?? 38 80 00 1B 38 A5 ?? ?? 38 61 00 08 4C C6 31 82 4? ?? ?? ?? 7F E4 FB 78 3F E0 ?? ?? 7F C5 F3 78 38 61 00 08 3B FF ?? ?? 4? ?? ?? ?? 83 DF ?? ?? 3C 80 ?? ?? 7F DE 12 14 38 60 00 03 83 BE 00 00 38 84 ?? ?? 38 A1 00 28 4? ?? ?? ?? 2F 83 00 00 40 9E 00 30 80 01 00 A4 83 FF ?? ?? 7F FF 12 14 83 C1 00 98 7C 08 03 A6 93 BF 00 00 38 60 FF FF 83 A1 00 94 83 E1 00 9C 38 21 00 A0 4E 80 00 20 80 1E 00 00 2F 80 00 02 40 9E FF CC 3B A0 00 26 4B FF FF C4 3D 20 ?? ?? 83 A1 00 94 39 29 ?? ?? 83 C1 00 98 81 29 ?? ?? 83 E1 00 9C 38 00 00 16 7D 29 12 14 90 09 00 00 38 60 FF FF 80 01 00 A4 38 21 00 A0 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_175_0_0 {
	meta:
		name = "__getdtablesize"
		size = 56
		refs = "0014 __getrlimit"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 38 60 00 07 38 81 00 08 90 01 00 24 4? ?? ?? ?? 2F 83 00 00 38 60 01 00 41 9C 00 08 80 61 00 08 80 01 00 24 38 21 00 20 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_176_0_0 {
	meta:
		name = "__frexp"
		size = 152
	strings:
		$1 = { 94 21 FF F0 3D 00 7F EF 61 08 FF FF D8 21 00 08 81 21 00 08 81 41 00 0C 55 20 00 7E 7F 80 40 00 7D 2B 4B 78 39 20 00 00 91 23 00 00 41 9D 00 64 7C 09 53 79 41 82 00 5C 3D 20 00 0F 61 29 FF FF 7F 80 48 00 39 00 FC 02 41 9D 00 20 3D 20 ?? ?? C0 09 ?? ?? 39 00 FB CC FC 21 00 32 D8 21 00 08 81 61 00 08 55 60 00 7E D8 21 00 08 55 6B 03 00 65 69 3F E0 81 41 00 0C 7C 00 A6 70 91 21 00 08 7D 00 42 14 91 41 00 0C 91 03 00 00 C8 21 00 08 38 21 00 10 4E 80 00 20 }
	condition:
		$1
}

rule file_177_0_0 {
	meta:
		name = "getgrent"
		size = 268
		refs = "0052 __getgrent_r 005a _GLOBAL_OFFSET_TABLE_ 0078 __nss_getent 007e __libc_errno 00e0 __lll_lock_wait_private"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 39 60 00 01 93 61 00 0C 3F 60 ?? ?? 39 20 00 00 93 81 00 10 3B 9B ?? ?? 90 01 00 24 93 A1 00 14 93 C1 00 18 93 E1 00 1C 7C 00 E0 28 7C 00 48 00 40 82 00 0C 7D 60 E1 2D 40 A2 FF F0 4C 00 01 2C 2F 80 00 00 40 9E 00 90 3C 60 ?? ?? 3C A0 ?? ?? 3F E0 ?? ?? 38 9C 00 04 38 A5 ?? ?? 38 C0 04 00 38 FC 00 14 39 00 00 00 3B FF ?? ?? 38 63 ?? ?? 4? ?? ?? ?? 81 3F ?? ?? 7D 29 12 14 7C 7E 1B 78 83 A9 00 00 38 00 00 00 7C 00 04 AC 7D 20 E0 28 7C 00 E1 2D 40 A2 FF F8 2F 89 00 01 41 9D 00 44 80 01 00 24 83 FF ?? ?? 7F FF 12 14 83 61 00 0C 7C 08 03 A6 93 BF 00 00 7F C3 F3 78 83 81 00 10 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 7F 83 E3 78 4? ?? ?? ?? 4B FF FF 6C 80 82 8B 68 38 00 00 DD 7F 83 E3 78 60 84 00 01 38 A0 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF A0 }
	condition:
		$1
}

rule file_273_0_0 {
	meta:
		name = "getaliasent"
		size = 268
		refs = "0052 __getaliasent_r 005a _GLOBAL_OFFSET_TABLE_ 0078 __nss_getent 007e __libc_errno 00e0 __lll_lock_wait_private"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 39 60 00 01 93 61 00 0C 3F 60 ?? ?? 39 20 00 00 93 81 00 10 3B 9B ?? ?? 90 01 00 24 93 A1 00 14 93 C1 00 18 93 E1 00 1C 7C 00 E0 28 7C 00 48 00 40 82 00 0C 7D 60 E1 2D 40 A2 FF F0 4C 00 01 2C 2F 80 00 00 40 9E 00 90 3C 60 ?? ?? 3C A0 ?? ?? 3F E0 ?? ?? 38 9C 00 04 38 A5 ?? ?? 38 C0 04 00 38 FC 00 14 39 00 00 00 3B FF ?? ?? 38 63 ?? ?? 4? ?? ?? ?? 81 3F ?? ?? 7D 29 12 14 7C 7E 1B 78 83 A9 00 00 38 00 00 00 7C 00 04 AC 7D 20 E0 28 7C 00 E1 2D 40 A2 FF F8 2F 89 00 01 41 9D 00 44 80 01 00 24 83 FF ?? ?? 7F FF 12 14 83 61 00 0C 7C 08 03 A6 93 BF 00 00 7F C3 F3 78 83 81 00 10 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 7F 83 E3 78 4? ?? ?? ?? 4B FF FF 6C 80 82 8B 68 38 00 00 DD 7F 83 E3 78 60 84 00 01 38 A0 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF A0 }
	condition:
		$1
}

rule file_1266_0_0 {
	meta:
		name = "getsgent"
		size = 268
		refs = "0052 __getsgent_r 005a _GLOBAL_OFFSET_TABLE_ 0078 __nss_getent 007e __libc_errno 00e0 __lll_lock_wait_private"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 39 60 00 01 93 61 00 0C 3F 60 ?? ?? 39 20 00 00 93 81 00 10 3B 9B ?? ?? 90 01 00 24 93 A1 00 14 93 C1 00 18 93 E1 00 1C 7C 00 E0 28 7C 00 48 00 40 82 00 0C 7D 60 E1 2D 40 A2 FF F0 4C 00 01 2C 2F 80 00 00 40 9E 00 90 3C 60 ?? ?? 3C A0 ?? ?? 3F E0 ?? ?? 38 9C 00 04 38 A5 ?? ?? 38 C0 04 00 38 FC 00 14 39 00 00 00 3B FF ?? ?? 38 63 ?? ?? 4? ?? ?? ?? 81 3F ?? ?? 7D 29 12 14 7C 7E 1B 78 83 A9 00 00 38 00 00 00 7C 00 04 AC 7D 20 E0 28 7C 00 E1 2D 40 A2 FF F8 2F 89 00 01 41 9D 00 44 80 01 00 24 83 FF ?? ?? 7F FF 12 14 83 61 00 0C 7C 08 03 A6 93 BF 00 00 7F C3 F3 78 83 81 00 10 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 7F 83 E3 78 4? ?? ?? ?? 4B FF FF 6C 80 82 8B 68 38 00 00 DD 7F 83 E3 78 60 84 00 01 38 A0 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF A0 }
	condition:
		$1
}

rule file_178_0_0 {
	meta:
		name = "shmat"
		size = 132
		refs = "003c __getpagesize 006a _GLOBAL_OFFSET_TABLE_ 0072 __libc_errno"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 7C 69 1B 78 90 01 00 24 7C 87 23 78 38 00 00 75 93 E1 00 1C 38 60 00 15 7D 24 4B 78 38 C1 00 08 44 00 00 02 7C 00 00 26 74 09 10 00 40 82 00 34 7C 7F 1B 78 4? ?? ?? ?? 7C 63 00 D0 7F 9F 18 40 41 9D 00 08 83 E1 00 08 80 01 00 24 7F E3 FB 78 83 E1 00 1C 38 21 00 20 7C 08 03 A6 4E 80 00 20 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 90 69 00 00 38 60 FF FF 4B FF FF B8 }
	condition:
		$1
}

rule file_179_0_0 {
	meta:
		name = "__posix_spawn_file_actions_realloc"
		size = 92
		refs = "0028 realloc"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 93 C1 00 08 83 C3 00 00 93 E1 00 0C 7C 7F 1B 78 3B DE 00 08 80 63 00 08 1C 9E 00 14 4? ?? ?? ?? 7C 60 1B 79 38 60 00 0C 41 82 00 10 90 1F 00 08 38 60 00 00 93 DF 00 00 80 01 00 14 83 C1 00 08 7C 08 03 A6 83 E1 00 0C 38 21 00 10 4E 80 00 20 }
	condition:
		$1
}

rule file_179_1_0 {
	meta:
		name = "posix_spawn_file_actions_init"
		size = 44
		refs = "0014 memset"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 38 80 00 00 38 A0 00 4C 90 01 00 14 4? ?? ?? ?? 38 60 00 00 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_180_0_0 {
	meta:
		name = "_IO_getwc"
		size = 404
		refs = "0118 __wuflow 0124 __lll_lock_wait_private 0190 _Unwind_Resume"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 80 03 00 00 93 E1 00 0C 7C 7F 1B 78 70 00 80 00 93 C1 00 08 40 82 00 50 80 63 00 48 3B C2 8B 60 81 23 00 08 7F 89 F0 00 41 9E 00 30 39 60 00 01 7D 20 18 28 7C 09 00 00 40 82 00 0C 7D 60 19 2D 40 A2 FF F0 4C 00 01 2C 2F 89 00 00 40 9E 00 CC 80 7F 00 48 93 C3 00 08 81 23 00 04 38 09 00 01 90 03 00 04 81 3F 00 5C 2F 89 00 00 41 9E 00 9C 81 69 00 00 80 09 00 04 7F 8B 00 40 40 9C 00 8C 38 0B 00 04 83 CB 00 00 90 09 00 00 80 1F 00 00 70 09 80 00 40 82 00 38 80 7F 00 48 81 23 00 04 38 09 FF FF 2F 80 00 00 90 03 00 04 40 9E 00 20 90 03 00 08 7C 00 04 AC 7D 20 18 28 7C 00 19 2D 40 A2 FF F8 2F 89 00 01 41 9D 00 20 80 01 00 14 7F C3 F3 78 83 E1 00 0C 7C 08 03 A6 83 C1 00 08 38 21 00 10 4E 80 00 20 80 82 8B 68 38 00 00 DD 38 A0 00 01 60 84 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF C8 7F E3 FB 78 4? ?? ?? ?? 7C 7E 1B 78 4B FF FF 78 4? ?? ?? ?? 4B FF FF 34 80 1F 00 00 7C 7E 1B 78 70 09 80 00 40 82 00 54 80 7F 00 48 80 03 00 04 30 00 FF FF 2F 80 00 00 90 03 00 04 40 9E 00 3C 90 03 00 08 7C 00 04 AC 7D 20 18 28 7C 00 19 2D 40 A2 FF F8 2F 89 00 01 40 BD 00 20 80 82 8B 68 38 00 00 DD 38 A0 00 01 60 84 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 7F C3 F3 78 4? ?? ?? ?? }
	condition:
		$1
}

rule file_181_0_0 {
	meta:
		name = "round_and_return"
		size = 724
		refs = "00d4 __mpn_rshift 00f4 __errno_location 015c __mpn_construct_double"
	strings:
		$1 = { 2F 84 FC 02 94 21 FF E0 7C 08 02 A6 93 81 00 10 7C BC 2B 78 93 A1 00 14 7C DD 33 78 93 C1 00 18 7C 7E 1B 78 93 E1 00 1C 7C 9F 23 78 90 01 00 24 40 9C 00 D8 23 E4 FC 02 2F 9F 00 35 41 9D 01 EC 38 00 00 01 7C 07 38 30 38 E7 FF FF 7C E0 30 39 7C 00 00 26 54 00 1F FE 68 00 00 01 7D 08 03 78 41 9E 02 38 2F 9F 00 1F 40 9D 02 04 38 FF FF FF 7C E0 2E 70 2F 80 00 01 54 00 10 3A 7F A3 00 2E 54 E7 06 FE 40 9E 00 18 80 03 00 00 7C 00 00 34 54 00 D9 7E 68 00 00 01 7D 08 03 78 39 20 00 01 90 E1 00 08 7D 29 38 30 38 09 FF FF 7F A9 00 39 7F C3 F3 78 38 9E 00 04 7C 00 00 26 54 00 1F FE 38 A0 00 01 57 E6 06 FE 68 00 00 01 7D 08 03 78 91 01 00 0C 4? ?? ?? ?? 38 00 00 00 90 1E 00 04 80 E1 00 08 81 01 00 0C 90 E1 00 08 3B E0 FC 01 91 01 00 0C 4? ?? ?? ?? 38 00 00 22 90 03 00 00 81 01 00 0C 80 E1 00 08 7F A0 3C 30 70 09 00 01 41 82 00 94 2F 88 00 00 41 9E 00 EC 81 3E 00 00 38 09 00 01 7F 80 48 40 90 1E 00 00 41 9C 01 30 81 3E 00 04 75 20 00 20 40 82 00 48 2F 9F FC 01 40 BE 00 64 75 20 00 10 41 82 00 08 3B E0 FC 02 7F C3 F3 78 7F E4 FB 78 7F 85 E3 78 4? ?? ?? ?? 80 01 00 24 83 81 00 10 7C 08 03 A6 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 7F C3 F3 78 7F C4 F3 78 38 A0 00 02 38 C0 00 01 4? ?? ?? ?? 80 1E 00 04 3B FF 00 01 64 00 00 10 90 1E 00 04 2F 9F 04 00 40 BD FF A8 2F 9C 00 00 40 9E 00 2C 80 01 00 24 3D 20 ?? ?? C0 29 ?? ?? 7C 08 03 A6 83 81 00 10 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 80 01 00 24 3D 20 ?? ?? C0 29 ?? ?? 7C 08 03 A6 83 81 00 10 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 81 3E 00 00 71 20 00 01 40 A2 FF 14 38 00 00 01 7C 07 38 30 38 E7 FF FF 7C E0 E8 39 41 A2 FF 84 4B FF FE FC 4? ?? ?? ?? 38 00 00 21 90 03 00 00 3D 20 ?? ?? 80 01 00 24 C8 29 ?? ?? 7C 08 03 A6 83 81 00 10 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 81 3E 00 04 39 29 00 01 91 3E 00 04 4B FF FE CC 38 FF FF FF 83 A3 00 00 7C 64 1B 78 90 E1 00 08 38 A0 00 02 7F E6 FB 78 91 01 00 0C 4? ?? ?? ?? 81 01 00 0C 80 E1 00 08 4B FF FE 54 83 A3 00 04 39 60 00 00 80 03 00 00 38 E0 00 14 7F A9 00 34 91 63 00 00 7C 00 00 34 55 29 D9 7E 91 63 00 04 54 00 D9 7E 69 29 00 01 68 00 00 01 7D 20 03 78 7D 08 03 78 4B FF FE 18 }
	condition:
		$1
}

rule file_181_1_0 {
	meta:
		name = "str_to_mpn.clone.0"
		size = 844
		refs = "0142 _tens_in_limb 01d0 __mpn_mul_1"
	strings:
		$1 = { 94 21 FF D0 7C 08 02 A6 7D 80 00 26 2E 09 00 00 90 01 00 34 38 00 00 00 39 60 00 00 92 E1 00 0C 3A E0 00 01 93 01 00 10 7D 38 4B 78 93 21 00 14 7D 19 43 78 93 41 00 18 3B 40 00 00 93 61 00 1C 7C FB 3B 78 93 81 00 20 7C BC 2B 78 38 A0 00 00 93 A1 00 24 7C DD 33 78 93 C1 00 28 7C 9E 23 78 93 E1 00 2C 7C 7F 1B 78 91 81 00 08 90 06 00 00 89 3F 00 00 38 09 FF D0 54 00 06 3E 2B 80 00 09 40 9D 00 18 41 92 00 10 88 18 00 00 7F 80 48 00 41 9E 00 34 7D 3F C8 EE 37 DE FF FF 1F 5A 00 0A 3B 5A FF D0 7F 5A 4A 14 3B FF 00 01 39 6B 00 01 40 81 00 74 2F 8B 00 09 41 9E 00 E8 80 BD 00 00 4B FF FF B0 88 18 00 01 2F 80 00 00 41 9E 02 74 89 3F 00 01 7F 89 00 00 40 BE FF BC 39 20 00 01 48 00 00 10 7D 5F 48 AE 7F 8A 00 00 40 BE FF A8 39 29 00 01 7C 18 48 AE 7D 2A 4B 78 2F 80 00 00 40 9E FF E4 7D 3F 50 EE 37 DE FF FF 1F 5A 00 0A 3B 5A FF D0 7F 5A 4A 14 3B FF 00 01 39 6B 00 01 41 81 FF 94 80 1B 00 00 2F 80 00 00 40 9D 00 10 7D 2B 02 14 2F 89 00 09 40 9D 01 0C 2F 85 00 00 3D 20 ?? ?? 55 6B 10 3A 39 29 ?? ?? 7C C9 58 2E 40 9E 01 20 38 00 00 01 93 5C 00 00 90 1D 00 00 80 01 00 34 7F E3 FB 78 81 81 00 08 7C 08 03 A6 82 E1 00 0C 83 01 00 10 7D 80 81 20 83 21 00 14 83 41 00 18 83 61 00 1C 83 81 00 20 83 A1 00 24 83 C1 00 28 83 E1 00 2C 38 21 00 30 4E 80 00 20 2F 85 00 00 40 9E 00 1C 93 5C 00 00 39 60 00 00 3B 40 00 00 92 FD 00 00 38 A0 00 01 4B FF FE B4 3C C0 3B 9A 7F 83 E3 78 7F 84 E3 78 60 C6 CA 00 4? ?? ?? ?? 80 1C 00 00 81 7D 00 00 7F 5A 02 14 7F 80 D0 40 93 5C 00 00 38 00 00 00 40 9D 00 2C 7D 69 03 A6 39 3C 00 04 42 40 01 38 81 69 00 00 39 29 00 04 38 0B 00 01 2F 80 00 00 90 09 FF FC 41 9E FF E8 38 00 00 00 7C 00 1A 15 41 82 00 D8 81 3D 00 00 3B 40 00 00 39 60 00 00 55 29 10 3A 7C 1C 49 2E 80 BD 00 00 38 A5 00 01 90 BD 00 00 4B FF FE 30 3D 60 ?? ?? 2F 85 00 00 39 6B ?? ?? 54 00 10 3A 7C 0B 00 2E 55 29 10 3A 7C CB 48 2E 7F 5A 01 D6 38 00 00 00 90 1B 00 00 41 9E FE E8 7F 83 E3 78 7F 84 E3 78 4? ?? ?? ?? 80 1C 00 00 81 7D 00 00 7F 5A 02 14 7F 80 D0 40 93 5C 00 00 38 00 00 00 41 9D 00 70 7C 00 1A 15 41 A2 FE C4 81 3D 00 00 7F E3 FB 78 81 81 00 08 55 2B 10 3A 82 E1 00 0C 7C 1C 59 2E 39 29 00 01 7D 80 81 20 80 01 00 34 91 3D 00 00 7C 08 03 A6 83 01 00 10 83 21 00 14 83 41 00 18 83 61 00 1C 83 81 00 20 83 A1 00 24 83 C1 00 28 83 E1 00 2C 38 21 00 30 4E 80 00 20 80 BD 00 00 3B 40 00 00 39 60 00 00 4B FF FD 70 7D 69 03 A6 39 3C 00 04 42 40 00 2C 81 69 00 00 39 29 00 04 38 0B 00 01 2F 80 00 00 90 09 FF FC 41 9E FF E8 38 00 00 00 4B FF FF 6C 38 00 00 01 4B FF FE E4 38 00 00 01 4B FF FF 5C 39 40 00 01 7D 3F 50 EE 4B FF FD C0 }
	condition:
		$1
}

rule file_181_2_0 {
	meta:
		name = "____strtod_l_internal"
		size = 7248
		refs = "0088 strlen 02ae _nl_C_locobj 0380 __errno_location 0526 _fpioconst_pow10 052a __tens 05a0 __mpn_mul 07a0 __correctly_grouped_prefixmb 088c memcpy 0960 __mpn_lshift 09c0 __mpn_cmp 0b6c __mpn_submul_1 0b8c __mpn_add_n 0e74 __strncasecmp_l 17e4 __mpn_rshift 18b4 ____strtoull_l_internal"
	strings:
		$1 = { 7D 80 00 26 2F 85 00 00 94 21 FE 40 7C 08 02 A6 90 01 01 C4 92 81 01 90 3A 80 00 00 92 A1 01 94 7C 75 1B 78 92 E1 01 9C 7C D7 33 78 93 81 01 B0 3B 80 00 00 93 C1 01 B8 7C 9E 23 78 91 C1 01 78 91 E1 01 7C 92 01 01 80 92 21 01 84 92 41 01 88 92 61 01 8C 92 C1 01 98 93 01 01 A0 93 21 01 A4 93 41 01 A8 93 61 01 AC 93 A1 01 B4 93 E1 01 BC 91 81 01 74 81 26 00 04 40 9E 1A 7C 83 A9 00 24 3B 35 FF FF 7F A3 EB 78 4? ?? ?? ?? 38 00 00 00 90 01 00 0C 7C 7B 1B 78 81 77 00 34 8C 19 00 01 54 1F 06 3E 57 E9 08 3C 7D 2B 4A 2E 71 28 00 20 40 82 FF EC 2F 9F 00 2D 41 9E 02 B8 2F 9F 00 2B 3B 40 00 00 41 9E 05 2C 89 5D 00 00 2F 0A 00 00 41 9A 10 2C 54 00 06 3E 7F 80 50 00 39 20 00 00 41 BE 00 14 48 00 01 B8 7D 79 48 AE 7F 8B 00 00 40 9E 01 AC 39 29 00 01 7C 1D 48 AE 7D 2B 4B 78 2F 80 00 00 40 9E FF E4 7C 19 58 AE 2B 80 00 2F 40 9D 01 8C 2B 80 00 39 41 9D 01 84 2F 9F 00 30 41 9E 04 DC 80 D7 00 38 38 00 00 0A 2C 9C 00 00 40 86 1A 8C 40 9E 0D E0 7F 33 CB 78 8F F3 00 01 2F 9F 00 30 41 9E FF F8 39 1F FF D0 55 09 06 3E 2B 89 00 09 57 E9 10 3A 7D 26 48 2E 7E 78 9B 78 2E 00 00 10 40 9D 00 48 55 27 06 3E 41 92 05 58 41 9A 00 34 88 13 00 00 39 20 00 00 7F 80 50 00 41 BE 00 14 48 00 06 00 7D 73 48 AE 7F 8B 00 00 40 9E 05 F4 39 29 00 01 7C 1D 48 AE 2F 80 00 00 40 9E FF E8 41 92 0E 04 7E 78 9B 78 3A C0 00 00 55 08 06 3E 2B 88 00 09 40 9D 01 A8 41 92 01 8C 40 86 1A 60 2F 94 00 00 40 9E 19 60 2F 96 00 00 38 E0 00 00 40 9E 00 08 38 E0 FF FF 41 9A 00 34 88 18 00 00 39 20 00 00 7F 80 50 00 41 BE 00 14 48 00 01 B0 7D 78 48 AE 7F 8B 00 00 40 9E 01 A4 39 29 00 01 7C 1D 48 AE 2F 80 00 00 40 9E FF E8 7D 38 D8 AE 7D 78 DA 14 7E DF B3 78 38 09 FF D0 54 00 06 3E 2B 80 00 09 39 40 00 00 55 28 10 3A 2F 07 FF FF 2C 89 00 30 7D 78 5B 78 40 9D 00 50 40 92 05 80 7D 26 40 2E 55 29 06 3E 38 09 FF 9F 54 00 06 3E 2B 80 00 05 41 9D 03 E0 41 9A 00 38 8D 2B 00 01 3B FF 00 01 39 4A 00 01 38 09 FF D0 54 00 06 3E 2B 80 00 09 55 28 10 3A 2F 07 FF FF 2C 89 00 30 7D 78 5B 78 41 BD FF B8 41 A6 FF D4 40 9A FF D0 7D 47 53 78 4B FF FF C8 38 1F FF D0 54 00 06 3E 2B 80 00 09 40 BD FE 74 3F A0 ?? ?? 3B BD ?? ?? 81 3D 00 38 57 FF 10 3A 7C 09 F8 2E 54 00 06 3E 2F 80 00 69 41 9E 0B 98 2F 80 00 6E 41 9E 0B FC 2F 9E 00 00 41 9E 00 BC 3D 20 ?? ?? 92 BE 00 00 C8 29 ?? ?? 80 01 01 C4 81 81 01 74 7C 08 03 A6 81 C1 01 78 81 E1 01 7C 7D 81 81 20 82 01 01 80 82 21 01 84 82 41 01 88 82 61 01 8C 82 81 01 90 82 A1 01 94 82 C1 01 98 82 E1 01 9C 83 01 01 A0 83 21 01 A4 83 41 01 A8 83 61 01 AC 83 81 01 B0 83 A1 01 B4 83 C1 01 B8 83 E1 01 BC 38 21 01 C0 4E 80 00 20 57 E0 10 3A 7D 26 00 2E 38 09 FF 9F 54 00 06 3E 2B 80 00 05 41 BD FE 64 3A D6 00 01 8F F8 00 01 39 1F FF D0 4B FF FE 44 8C 19 00 01 3B 40 00 01 54 1F 06 3E 4B FF FD 4C 4? ?? ?? ?? 2F 9A 00 00 38 00 00 22 90 03 00 00 40 9E 02 54 3D 20 ?? ?? C8 29 ?? ?? 4B FF FF 4C 57 FF 10 3A 7D 26 F8 2E 55 29 06 3E 41 92 02 88 7E DF B3 78 2F 89 00 65 7F 0B C3 78 41 9E 02 8C 7F 9F B0 00 40 9D 00 30 89 2B FF FF 38 0B FF FF 2F 09 00 30 40 9A 00 20 7C 0B 03 78 88 0B FF FF 3B FF FF FF 2F 80 00 30 38 0B FF FF 41 9E FF EC 7F 9F B0 00 41 9E 02 F4 2F 9F 00 00 2F 1E 00 00 41 9A 00 08 93 1E 00 00 41 9E 01 D4 2F 87 00 00 41 9E 02 1C 88 DD 00 00 39 53 00 01 88 13 00 00 39 0A FF FF 88 BD 00 01 7F 80 30 00 2F 05 00 00 41 9E 00 18 88 0A 00 00 39 4A 00 01 7F 80 30 00 39 0A FF FF 40 9E FF F0 41 9A 00 34 88 0A 00 00 39 20 00 01 7F 85 00 00 41 BE 00 14 4B FF FF DC 7D 68 48 AE 7F 8B 00 00 40 9E 02 74 39 29 00 01 7C 1D 48 AE 2F 80 00 00 40 9E FF E8 7E 67 DA 14 81 61 00 0C 7E 68 9A 14 41 92 10 F4 7C E0 3B 78 7D 60 58 50 91 61 00 0C 7F E7 F8 50 41 92 07 D4 2F 8B 00 00 41 9C 0C 40 7C 16 F8 50 7F 80 58 00 40 9D 00 08 7D 60 5B 78 7D 60 58 50 7E C0 B2 14 91 61 00 0C 7C 0B B2 14 2F 80 01 35 41 9D 12 CC 2F 8B FE BD 41 BC FE AC 2F 96 00 00 40 9D 03 30 3B C1 00 1C 3A A1 00 0C 3A E1 00 08 7E 63 9B 78 7F 89 E3 78 7E C4 B3 78 7F C5 F3 78 7E E6 BB 78 7E A7 AB 78 7F 68 DB 78 4B FF F7 AD 81 21 00 0C 7C 73 1B 78 2F 89 00 00 40 9D 10 B0 3B 21 00 B4 82 81 00 08 3F 00 ?? ?? 3D E0 ?? ?? 3B 18 ?? ?? 3B A0 00 01 7F 30 CB 78 7F D2 F3 78 39 EF ?? ?? 48 00 00 14 82 81 00 08 57 BD 08 3C 41 9E 08 38 3B 18 00 10 7D 2A E8 39 7D 20 EA 78 41 A2 FF E8 82 38 00 04 7E 46 93 78 7E 87 A3 78 90 01 00 0C 3A 31 FF FE 7F 91 A0 00 7E 03 83 78 7E 25 8B 78 7E 44 93 78 41 9D 02 68 80 D8 00 00 7E 85 A3 78 7E 27 8B 78 38 C6 00 02 54 C6 10 3A 7C CF 32 14 4? ?? ?? ?? 2F 83 00 00 82 81 00 08 7E 4B 93 78 7E 91 A2 14 92 81 00 08 41 9E 02 18 81 21 00 0C 7E 12 83 78 7D 70 5B 78 2F 89 00 00 4B FF FF 7C 2F 9E 00 00 41 9E 00 08 90 7E 00 00 2F 9A 00 00 41 9E FD B4 3D 20 ?? ?? C0 29 ?? ?? 4B FF FC FC 8C 19 00 01 54 1F 06 3E 4B FF FA D0 88 19 00 01 80 D7 00 38 54 00 10 3A 7D 26 00 2E 38 00 00 0A 2C 89 00 78 40 86 FB 18 8F F9 00 02 3A 80 00 00 38 00 00 10 2F 9F 00 30 4B FF FB 04 81 61 00 0C 4B FF FE 6C 7E DF B3 78 2F 89 00 70 7F 0B C3 78 40 9E FD 80 7F 0B C3 78 89 2B 00 01 3B 18 00 01 2F 89 00 2D 41 9E 0A D0 2F 89 00 2B 39 40 00 00 41 9E 0F 60 38 09 FF D0 54 00 06 3E 2B 80 00 09 41 9D 07 E8 41 92 09 98 2D 8A 00 00 41 8E 0F 54 39 16 01 68 80 01 00 0C 1C 00 00 0A 7D 20 4A 14 38 09 FF D0 7F 80 40 00 90 01 00 0C 41 9D 13 94 8D 38 00 01 39 49 FF D0 55 4A 06 3E 2B 8A 00 09 40 9D FF D8 41 AE FD 0C 7C 00 00 D0 90 01 00 0C 4B FF FD 00 2B 87 00 60 40 BD FA A8 2B 87 00 66 41 BD FA A0 7E 78 9B 78 4B FF FA D4 7C A0 2B 78 39 4A 00 01 4B FF FD 58 2F 9F 00 00 41 9E 0A 30 81 21 00 0C 7F F6 FB 78 2F 09 00 00 40 98 FD 00 39 6B FF FF 41 92 00 60 89 4B 00 00 55 48 06 3E 38 08 FF D0 20 00 00 09 7C 00 01 10 7C 00 00 D0 2F 00 00 00 40 BA FF DC 55 4A 06 3E 2F 0A 00 30 40 BA FC CC 3B FF FF FF 3A D6 FF FF 41 92 00 C8 38 00 00 01 2F 9F 00 00 7D 20 4A 14 91 21 00 0C 41 BE FC AC 2F 09 00 00 40 B8 FC A4 39 6B FF FF 40 92 FF A8 89 4B 00 00 81 17 00 34 55 40 0D FC 7C 08 02 2E 70 08 00 10 7C 00 00 26 54 00 1F FE 4B FF FF A0 41 92 09 80 2F 87 00 65 41 BE FA 1C 7F 23 CB 78 7E 64 9B 78 7F 85 E3 78 7E 86 A3 78 4? ?? ?? ?? 2F 9E 00 00 41 BE FE 34 7F 99 18 00 41 9E 10 08 7C 75 1B 78 92 BE 00 00 4B FF FE 20 55 29 10 3A 7D 26 48 2E 55 29 06 3E 4B FF FB E8 81 21 00 0C 3A 94 FF FF 7E 12 83 78 92 81 00 08 2F 89 00 00 7D 70 5B 78 4B FF FD 60 80 98 00 00 38 84 00 02 54 84 10 3A 7C 8F 22 14 4? ?? ?? ?? 4B FF FD A4 38 00 00 04 4B FF FF 3C 38 00 00 14 39 20 00 12 3B A0 00 00 3A E1 00 08 3B 01 00 14 3B C1 00 1C 3A A1 00 0C 7D D6 F8 50 7F 8E 00 00 3A 80 00 00 40 9D 00 0C 39 C9 00 02 3A 80 00 01 3B 21 00 B4 3E 40 ?? ?? 7E 2B 70 50 3A 52 ?? ?? 7F CF F3 78 7F 30 CB 78 3A C0 00 01 3B E0 00 00 48 00 00 40 80 92 00 00 3D 00 ?? ?? 83 F2 00 04 39 08 ?? ?? 38 84 00 02 3B FF FF FE 54 84 10 3A 7E 03 83 78 7C 88 22 14 57 E5 10 3A 4? ?? ?? ?? 2F 91 00 00 56 D6 08 3C 3A 52 00 10 41 9E 00 70 7E 20 B0 39 2F 9F 00 00 41 A2 FF E8 7E 06 83 78 7F E7 FB 78 7D E3 7B 78 7E 31 B2 78 41 BE FF A8 80 92 00 00 3D 20 ?? ?? 80 B2 00 04 39 29 ?? ?? 38 84 00 02 54 84 10 3A 7C 89 22 14 38 A5 FF FE 4? ?? ?? ?? 81 32 00 04 2F 83 00 00 38 09 FF FE 7E 0B 83 78 7F FF 02 14 40 9E 03 6C 7D F0 7B 78 3B FF FF FF 7D 6F 5B 78 4B FF FF 88 7F 90 F0 00 41 9E 0F 38 3A DF FF FF 7F 89 E3 78 7F 68 DB 78 7E 63 9B 78 7D C4 73 78 7F C5 F3 78 7E E6 BB 78 7E A7 AB 78 56 DC 10 3A 4B FF F3 7D 7D 37 E2 14 83 69 00 AC 7F 7B 00 34 2F 9B 00 00 40 9D 00 34 7F E5 FB 78 7F 66 DB 78 7F 24 CB 78 7F 23 CB 78 4? ?? ?? ?? 80 A1 00 08 7F C3 F3 78 7F C4 F3 78 7F 66 DB 78 4? ?? ?? ?? 2C 03 00 00 40 82 06 74 2F 9F 00 01 93 A1 00 0C 41 9E 0A 74 2F 9F 00 02 41 9E 07 A0 80 A1 00 08 3A 5F FF FE 56 52 10 3A 7C 85 F8 50 54 84 10 3A 7D 77 E2 14 7D 37 92 14 82 AB 00 AC 7F C3 F3 78 82 69 00 AC 7C 99 22 14 4? ?? ?? ?? 2F 83 00 00 40 9D 06 58 81 61 00 08 38 00 00 00 55 69 10 3A 3B 6B 00 01 7D 37 4A 14 93 61 00 08 7F 6B DB 78 90 09 00 14 7F 9B F8 00 41 9C 0C CC 2F 9B 00 00 57 69 10 3A 7D 3E 4A 14 40 9D 00 24 7D 7E 48 50 39 6B FF FC 55 6B F0 BE 39 6B 00 01 7D 69 03 A6 84 09 FF FC 90 09 00 04 42 00 FF F8 57 E0 10 3A 7D 37 02 14 90 01 01 5C 38 00 00 00 90 09 00 AC 39 E0 00 00 81 69 00 14 39 1F 00 01 81 21 01 5C 91 01 01 58 2E 16 00 00 56 B1 84 3E 56 AE 04 3E 7F 97 E2 14 7E 57 92 14 7E 17 4A 14 56 D6 10 3A 7F 8B A8 00 3B 60 FF FF 41 9E 00 EC 7F 6B 8B 96 80 FC 00 14 7D 3B 89 D6 7D 5B 71 D6 7D 29 58 50 55 29 80 1E 54 E0 84 3E 7D 29 03 78 7F 8A 48 40 40 9D 00 24 7D 29 AA 14 7F 95 48 40 3B 7B FF FF 41 9D 00 14 7F 8A 48 40 40 9D 00 0C 3B 7B FF FF 7D 29 AA 14 7D 4A 48 50 7D 2A 8B 96 7C 09 89 D6 7D 09 71 D6 7C 00 50 50 54 00 80 1E 54 E7 04 3E 7C 00 3B 78 7F 88 00 40 40 9D 00 24 7C 00 AA 14 7F 95 00 40 39 29 FF FF 41 9D 00 14 7F 88 00 40 40 9D 00 0C 39 29 FF FF 7C 00 AA 14 57 7B 80 1E 7D 3B DB 78 7D 5B 99 D6 7D 73 D8 16 7C 08 00 50 48 00 00 0C 7D 69 58 50 7D 53 50 50 7F 8B 00 40 7C 8B 00 00 7D 33 50 10 7D 29 49 10 7C 00 AA 14 7F 15 00 40 7D 29 00 D0 41 9D 00 14 40 86 00 18 81 12 00 14 7F 8A 40 40 40 9D 00 0C 3B 7B FF FF 40 99 FF C4 80 A1 01 58 7F C3 F3 78 7F 24 CB 78 7F 66 DB 78 4? ?? ?? ?? 80 10 00 14 7F 80 18 00 41 9E 00 1C 7F C3 F3 78 7F C4 F3 78 7F 25 CB 78 7F E6 FB 78 4? ?? ?? ?? 3B 7B FF FF 81 7C 00 14 91 70 00 14 40 91 00 18 7D 3E B2 14 84 09 FF FC 7F 89 F0 00 90 09 00 04 40 9E FF F4 2F 9D 00 00 40 9E 04 AC 2F 9B 00 00 41 9E 04 C0 7F 7D 00 34 20 1D 00 20 81 21 00 0C 2F 80 00 35 7C 9D 48 50 7C 89 23 78 90 81 00 0C 40 9D 0F 0C 39 FD 00 35 20 0F 00 20 7F 60 04 30 90 01 00 14 81 61 01 5C 7E F7 5A 14 80 17 00 14 2F 80 00 00 40 9E 00 30 2F 9F 00 00 41 9C 00 28 38 1F 00 01 7F DE 5A 14 7C 09 03 A6 48 00 00 08 42 40 00 14 84 1E FF FC 3B FF FF FF 2F 80 00 00 41 9E FF F0 2F 94 00 00 38 84 FF FF 20 EF 00 1F 39 00 00 01 40 9E 00 0C 7F E8 F8 F8 55 08 0F FE 7F 03 C3 78 7F 45 D3 78 7F 66 DB 78 4B FF ED 85 4B FF F6 88 7D F0 7B 78 7D 6F 5B 78 4B FF FC 24 89 33 00 00 80 B7 00 34 55 20 08 3C 7C 05 02 2E 70 0A 00 10 40 82 00 20 8D 33 00 01 55 20 08 3C 7C 05 02 2E 70 08 00 10 41 82 FF F0 48 00 00 08 8D 33 00 01 2F 89 00 30 41 9E FF F8 39 49 FF D0 2B 8A 00 09 40 9D 03 34 81 57 00 38 55 29 10 3A 3A 73 00 01 7D 4A 48 2E 39 4A FF A9 3D 20 ?? ?? 7F E9 03 A6 55 40 10 3A 39 29 ?? ?? 7C 09 00 2E 7F E9 FB 78 35 29 FF FF 56 C7 10 3A 21 20 00 14 38 E7 FF FB 39 09 00 01 7D 67 5A 14 7D 6B 02 14 7D 4A 40 30 91 61 00 0C 38 00 00 01 91 41 00 18 41 80 0D 0C 42 40 08 70 89 73 00 00 55 6A 08 3C 7D 45 52 2E 71 48 00 10 40 82 00 08 7D 73 D8 EE 38 CB FF D0 2B 86 00 09 55 6B 10 3A 41 9D 03 14 3A 73 00 01 2F 89 00 02 54 0B 10 3A 39 01 00 08 7C E8 5A 14 39 49 FF FD 21 69 00 03 2F 00 00 00 7C CA 50 30 7C CB 5C 30 38 89 00 1D 40 9D 02 C0 81 67 00 0C 39 29 FF FC 7D 4A 5B 78 91 47 00 0C 4B FF FF 94 7F 92 C8 00 41 9E 0B C4 38 14 FF FF 54 09 10 3A 7D 37 4A 14 56 9D 28 34 81 29 00 14 7D 29 00 34 7F A9 E8 50 2F 9D 04 00 41 9D 09 EC 2F 9D 00 35 41 9D 01 68 7F 9F B0 00 40 9E 08 20 3B BD FF FF 7F A6 2E 70 7C C6 01 94 54 C6 28 34 7C C6 E8 50 2F 86 00 14 41 9E 0B 88 2F 86 00 13 41 9D 09 E8 20 74 00 02 54 63 10 3A 3B 01 00 14 7C 78 1A 14 7F C4 F3 78 7E 85 A3 78 20 C6 00 14 4? ?? ?? ?? 80 01 00 08 20 00 00 02 2F 80 00 00 40 9D 00 28 54 0B 10 3A 39 6B FF FC 55 6B F0 BE 39 6B 00 01 7D 69 03 A6 39 21 00 10 38 00 00 00 94 09 00 04 42 00 FF FC 7F 03 C3 78 7F A4 EB 78 7F 45 D3 78 38 C0 00 00 38 E0 00 00 39 00 00 00 4B FF EB 91 4B FF F4 94 7D 78 5B 78 4B FF F5 64 3C 80 ?? ?? 7F 23 CB 78 38 84 ?? ?? 38 A0 00 03 7F A6 EB 78 4? ?? ?? ?? 2F 83 00 00 40 BE F4 58 2F 9E 00 00 41 9E 00 34 3C 80 ?? ?? 38 79 00 03 38 84 ?? ?? 38 A0 00 05 7F A6 EB 78 4? ?? ?? ?? 38 00 00 03 2F 83 00 00 40 9E 00 08 38 00 00 08 7C 19 02 14 90 1E 00 00 2F 9A 00 00 40 9E 08 F0 3D 20 ?? ?? C0 29 ?? ?? 4B FF F4 20 3C 80 ?? ?? 7F 23 CB 78 38 84 ?? ?? 38 A0 00 03 7F A6 EB 78 4? ?? ?? ?? 2F 83 00 00 40 BE F3 EC 88 19 00 03 38 79 00 03 2F 80 00 28 41 9E 09 64 3D 20 ?? ?? C0 29 ?? ?? 2F 9E 00 00 41 BE F3 E0 90 7E 00 00 4B FF F3 D8 7F 33 CB 78 4B FF F2 30 39 3D FF CB 71 28 00 1F 7D 29 2E 70 40 82 06 F8 55 20 10 3A 39 69 FF FF 7D 3E 00 2E 7D 5E 02 14 80 0A 00 04 55 6A 10 3A 3B 01 00 14 91 21 00 14 7E F7 52 14 90 18 00 04 38 E0 00 1F 80 D7 00 14 80 01 00 1C 39 20 00 00 2F 80 00 00 40 9E 00 14 84 1E 00 04 39 29 00 01 2F 80 00 00 41 9E FF F4 7F 9F B0 00 38 9D FF FF 39 00 00 01 41 9D 00 10 7F 89 58 00 7D 00 00 26 55 08 EF FE 7F 03 C3 78 7F 45 D3 78 4B FF EA 41 4B FF F3 44 7F 99 98 00 7E 78 9B 78 40 9E F1 FC 7D 39 D8 AE 7F 38 CB 78 38 09 FF D0 54 00 06 3E 2B 80 00 09 40 BD F1 E4 55 29 10 3A 7C 06 48 2E 30 00 FF 9F 54 00 06 3E 2B 80 00 05 41 BD F7 B0 4B FF F1 C8 3A 73 00 01 4B FF FC E0 81 21 00 08 55 2B 10 3A 7D 77 5A 14 39 29 00 01 }
	condition:
		$1
}

rule file_182_0_0 {
	meta:
		name = "__xpg_basename"
		size = 292
		refs = "0028 strrchr"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 93 E1 00 0C 7C 7F 1B 79 90 01 00 14 41 82 00 88 88 1F 00 00 2F 80 00 00 41 9E 00 7C 38 80 00 2F 4? ?? ?? ?? 7C 6B 1B 79 7F E3 FB 78 41 82 00 70 88 0B 00 01 38 6B 00 01 2F 80 00 00 40 9E 00 60 7F 9F 58 40 40 9C 00 C4 88 0B FF FF 38 6B FF FF 7D 3F 18 50 2F 80 00 2F 39 29 00 01 7D 29 03 A6 40 9E 00 50 42 40 00 1C 88 03 FF FF 39 23 FF FF 2F 80 00 2F 40 9E 00 44 7D 23 4B 78 42 00 FF EC 88 03 00 01 2F 80 00 00 41 9E 00 14 38 63 00 01 4B FF FF F0 3C 60 ?? ?? 38 63 ?? ?? 80 01 00 14 83 E1 00 0C 38 21 00 10 7C 08 03 A6 4E 80 00 20 7C 69 1B 78 7D 63 5B 78 7F 9F 48 40 38 00 00 00 98 03 00 00 40 9C 00 50 88 09 FF FF 39 69 FF FF 7D 23 4B 78 2F 80 00 2F 41 BE FF C4 7F FF 58 50 3B FF 00 01 7D 69 5B 78 7F E9 03 A6 48 00 00 10 8C 09 FF FF 2F 80 00 2F 41 BE FF A4 7D 23 4B 78 42 00 FF F0 4B FF FF 98 7D 63 5B 78 38 00 00 00 4B FF FF 74 7D 23 4B 78 4B FF FF 84 }
	condition:
		$1
}

rule file_183_0_0 {
	meta:
		name = "execl"
		size = 500
		refs = "00d0 realloc 011e __environ 012c __execve 0140 free 01cc memcpy"
	strings:
		$1 = { 94 21 EF B0 7C 08 02 A6 2F 84 00 00 90 01 10 54 38 00 00 02 98 01 00 08 38 01 10 58 90 01 00 0C 38 01 10 10 93 E1 10 4C 7C 7F 1B 78 93 21 10 34 93 41 10 38 93 61 10 3C 93 81 10 40 93 A1 10 44 93 C1 10 48 90 A1 10 18 90 C1 10 1C 90 E1 10 20 91 01 10 24 91 21 10 28 91 41 10 2C 90 81 00 14 90 01 00 10 41 9E 01 78 3B 81 00 14 3B C0 00 01 7F 9D E3 78 3B 20 04 00 89 21 00 08 57 CA 10 3A 7D 5D 52 14 2B 89 00 08 40 9C 00 78 55 20 10 3A 81 61 00 10 39 29 00 01 99 21 00 08 7D 6B 02 14 80 0B 00 00 2F 80 00 00 90 0A 00 00 41 9E 00 70 3B DE 00 01 7F 99 F0 00 40 9E FF C0 7F 9D E0 00 57 3B 08 3C 7F A3 EB 78 41 9E 00 AC 57 24 18 38 4? ?? ?? ?? 7C 7A 1B 79 41 82 00 B0 7F 9D E0 00 41 9E 00 E4 89 21 00 08 7F 5D D3 78 57 CA 10 3A 2B 89 00 08 7F 79 DB 78 7D 5D 52 14 41 BC FF 90 81 61 00 0C 38 0B 00 04 90 01 00 0C 80 0B 00 00 2F 80 00 00 90 0A 00 00 40 9E FF 98 3D 20 ?? ?? 80 A9 ?? ?? 7F E3 FB 78 7F A4 EB 78 4? ?? ?? ?? 7F 9D E0 00 7C 7F 1B 78 41 9E 00 0C 7F A3 EB 78 4? ?? ?? ?? 80 01 10 54 7F E3 FB 78 83 21 10 34 7C 08 03 A6 83 41 10 38 83 61 10 3C 83 81 10 40 83 A1 10 44 83 C1 10 48 83 E1 10 4C 38 21 10 50 4E 80 00 20 38 60 00 00 57 24 18 38 4? ?? ?? ?? 7C 7A 1B 79 40 82 FF 58 7F 9D E0 00 3B E0 FF FF 40 BE FF AC 80 01 10 54 7F E3 FB 78 83 21 10 34 7C 08 03 A6 83 41 10 38 83 61 10 3C 83 81 10 40 83 A1 10 44 83 C1 10 48 83 E1 10 4C 38 21 10 50 4E 80 00 20 7F A4 EB 78 57 25 10 3A 4? ?? ?? ?? 7F 5D D3 78 7F 79 DB 78 4B FF FE A0 3D 20 ?? ?? 80 A9 ?? ?? 38 81 00 14 4? ?? ?? ?? 7C 7F 1B 78 4B FF FF 54 }
	condition:
		$1
}

rule file_184_0_0 {
	meta:
		name = "_rpc_dtablesize"
		size = 60
		refs = "0020 __getdtablesize"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 93 E1 00 0C 3F E0 ?? ?? 80 7F ?? ?? 90 01 00 14 2F 83 00 00 40 BE 00 0C 4? ?? ?? ?? 90 7F ?? ?? 80 01 00 14 83 E1 00 0C 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_185_0_0 {
	meta:
		name = "__mpn_mod_1"
		size = 1404
	strings:
		$1 = { 2C 04 00 00 94 21 FF E0 7C 69 1B 78 93 A1 00 14 38 60 00 00 93 C1 00 18 93 E1 00 1C 41 82 01 74 1C 04 00 54 2F 80 00 78 40 9D 01 7C 7C A3 00 34 2F 83 00 00 41 9E 02 50 7C A5 18 30 54 A0 08 3D 3B E0 FF FF 41 82 00 74 54 A0 84 3E 7D 65 00 D0 7D 4B 03 96 7C CA 01 D6 54 A7 04 3E 7D 0A 39 D6 7D 66 58 50 55 6B 80 1E 7F 88 58 40 40 9D 00 24 7D 6B 2A 14 7F 85 58 40 39 4A FF FF 41 9D 00 14 7F 88 58 40 40 9D 00 0C 39 4A FF FF 7D 6B 2A 14 7D 68 58 50 7F EB 03 96 7C 1F 01 D6 7C FF 39 D6 7D 60 58 50 55 6B 80 1E 7F 87 58 40 41 9D 04 6C 55 4A 80 1E 7F FF 53 78 35 44 FF FE 38 04 FF FF 54 00 10 3A 7C E9 00 2E 23 C3 00 20 7D 29 02 14 7C EB F4 30 41 80 00 74 38 84 FF FF 7C 89 03 A6 85 49 FF FC 7C E7 18 30 7C CB F8 16 7D 40 F4 30 7C CB 32 14 7C E7 03 78 7D 06 28 16 7C C6 29 D6 7C 06 38 10 7D 68 59 10 2F 8B 00 00 7D 47 53 78 41 9E 00 24 7D 45 00 10 7D 6B 01 D4 2F 8B 00 00 7D 40 53 78 41 9E 00 10 7D 45 00 10 7D 6B 01 D4 7D 40 53 78 7F 80 28 40 41 9C 00 08 7C 05 00 50 7C 0B 03 78 42 00 FF 9C 7F EB F8 16 7F EB FA 14 7C E7 18 30 7D 3F 28 16 7F FF 29 D6 7C 1F 38 10 7D 69 59 10 2F 8B 00 00 41 9E 00 18 7D 25 00 10 7D 6B 01 D4 2F 8B 00 00 7D 20 4B 78 40 9E 03 8C 7F 80 28 40 41 9C 00 08 7C 05 00 50 7C 03 1C 30 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 7C BD 00 34 2F 9D 00 00 40 9E 01 F0 38 84 FF FF 54 80 10 3A 7C 69 00 2E 7F 85 18 40 40 9D 03 40 38 84 FF FF 2F 84 00 00 41 BC FF C4 38 84 00 01 7C 89 03 A6 54 80 10 3A 54 AB 84 3E 54 A7 04 3E 7D 29 02 14 7D 43 5B 96 85 09 FF FC 7C 0A 59 D6 7D 4A 39 D6 7C 00 18 50 55 06 84 3E 54 00 80 1E 7C 00 33 78 7F 8A 00 40 55 08 04 3E 40 9D 00 1C 7C 00 2A 14 7F 85 00 40 7F 0A 00 40 41 9D 00 0C 40 99 00 08 7C 00 2A 14 7C 0A 00 50 7D 40 5B 96 7C 6A 59 D6 7D 4A 39 D6 7C 03 00 50 54 03 80 1E 7C 63 43 78 7F 8A 18 40 40 9D 00 1C 7C 63 2A 14 7F 85 18 40 7F 0A 18 40 41 9D 00 0C 40 99 00 08 7C 63 2A 14 7C 6A 18 50 42 00 FF 7C 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 54 AB 08 3D 38 E0 FF FF 41 82 00 74 54 A0 84 3E 7D 65 00 D0 7D 4B 03 96 7C EA 01 D6 54 A6 04 3E 7D 0A 31 D6 7D 67 58 50 55 6B 80 1E 7F 88 58 40 40 9D 00 24 7D 6B 2A 14 7F 85 58 40 39 4A FF FF 41 9D 00 14 7F 88 58 40 40 9D 00 0C 39 4A FF FF 7D 6B 2A 14 7D 68 58 50 7C EB 03 96 7C 07 01 D6 7C C7 31 D6 7D 60 58 50 55 6B 80 1E 7F 86 58 40 41 9D 02 48 55 4A 80 1E 7C E7 53 78 38 84 FF FF 54 80 10 3A 7C 69 00 2E 7F 85 18 40 40 9D 01 E8 38 84 FF FF 2F 84 00 00 41 BC FE 74 38 84 00 01 7C 89 03 A6 54 80 10 3A 7D 29 02 14 7D 03 38 16 7D 08 1A 14 85 49 FF FC 7D 68 28 16 7D 08 29 D6 7C 08 50 10 7C 6B 19 10 2F 83 00 00 41 9E 00 24 7D 45 00 10 7C 63 01 D4 2F 83 00 00 7D 40 53 78 41 9E 00 10 7D 65 50 10 7C 63 01 D4 7D 60 5B 78 7F 80 28 40 41 9C 00 08 7C 05 00 50 7C 03 03 78 42 00 FF AC 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 34 04 FF FE 38 04 FF FF 54 00 10 3A 7D 89 00 2E 20 7D 00 20 7C A5 E8 30 7D 29 02 14 7D 88 1C 30 41 80 01 B4 38 84 FF FF 7C 89 03 A6 54 AA 84 3E 54 BF 04 3E 7C E8 53 96 84 C9 FF FC 7C 07 51 D6 7D 84 E8 30 7C DE 1C 30 7C 84 F3 78 7C E7 F9 D6 7D 00 40 50 54 8B 84 3E 55 08 80 1E 7D 6B 43 78 7F 87 58 40 54 84 04 3E 7C CC 33 78 40 9D 00 1C 7D 6B 2A 14 7F 85 58 40 7F 07 58 40 41 9D 00 0C 40 99 00 08 7D 6B 2A 14 7D 67 58 50 7D 0B 53 96 7C 08 51 D6 7D 08 F9 D6 7D 60 58 50 55 60 80 1E 7C 00 23 78 7F 88 00 40 40 9D 00 1C 7C 00 2A 14 7F 85 00 40 7F 08 00 40 41 9D 00 0C 40 99 00 08 7C 00 2A 14 7D 08 00 50 42 00 FF 6C 7D 28 53 96 7C 09 51 D6 7D 84 E8 30 7D 00 40 50 7D 29 F9 D6 55 08 80 1E 54 80 84 3E 7C 08 43 78 7F 89 40 40 40 9D 00 10 7D 08 2A 14 7F 85 40 40 40 9D 00 C8 7D 09 40 50 7C 68 53 96 7D 43 51 D6 7F E3 F9 D6 7D 0A 40 50 55 0C 80 1E 54 84 04 3E 7D 8C 23 78 7F 9F 60 40 40 9D 00 1C 7D 8C 2A 14 7F 85 60 40 41 9D 00 10 7F 9F 60 40 40 9D 00 08 7D 8C 2A 14 7F FF 60 50 83 C1 00 18 7F E3 EC 30 83 A1 00 14 83 E1 00 1C 38 21 00 20 4E 80 00 20 38 60 00 00 4B FF FE 1C 38 60 00 00 4B FF FC C4 7D 45 48 10 7D 6B 01 D4 7D 40 53 78 4B FF FC 6C 7D 6B 2A 14 7F 85 58 40 3B FF FF FF 41 BD FB 8C 7D 67 58 10 7D 6B 59 10 7D 6B 00 D0 7F EB F8 50 4B FF FB 78 7D 6B 2A 14 7F 85 58 40 38 E7 FF FF 41 BD FD B0 7D 66 58 10 7D 6B 59 10 7D 6B 00 D0 7C EB 38 50 4B FF FD 9C 7F 89 40 40 40 BD FF 38 7D 08 2A 14 4B FF FF 30 54 AA 84 3E 54 BF 04 3E 4B FF FE F0 }
	condition:
		$1
}

rule file_186_0_0 {
	meta:
		name = "fputc"
		size = 412
		refs = "0120 __overflow 012c __lll_lock_wait_private 0198 _Unwind_Resume"
		altNames = "_IO_putc"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 90 01 00 24 80 04 00 00 93 C1 00 18 7C 7E 1B 78 70 00 80 00 93 E1 00 1C 7C 9F 23 78 93 A1 00 14 40 82 00 50 80 64 00 48 3B A2 8B 60 81 23 00 08 7F 89 E8 00 41 9E 00 30 39 60 00 01 7D 20 18 28 7C 09 00 00 40 82 00 0C 7D 60 19 2D 40 A2 FF F0 4C 00 01 2C 2F 89 00 00 40 9E 00 CC 80 7F 00 48 93 A3 00 08 81 23 00 04 38 09 00 01 90 03 00 04 81 3F 00 14 80 1F 00 18 7F 89 00 40 40 9C 00 94 57 DE 06 3E 38 09 00 01 9B C9 00 00 90 1F 00 14 80 1F 00 00 70 09 80 00 40 82 00 38 80 7F 00 48 81 23 00 04 38 09 FF FF 2F 80 00 00 90 03 00 04 40 9E 00 20 90 03 00 08 7C 00 04 AC 7D 20 18 28 7C 00 19 2D 40 A2 FF F8 2F 89 00 01 41 9D 00 24 80 01 00 24 7F C3 F3 78 83 A1 00 14 7C 08 03 A6 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 80 82 8B 68 38 00 00 DD 38 A0 00 01 60 84 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF C4 7F E3 FB 78 57 C4 06 3E 4? ?? ?? ?? 7C 7E 1B 78 4B FF FF 70 4? ?? ?? ?? 4B FF FF 34 80 1F 00 00 7C 7E 1B 78 70 09 80 00 40 82 00 54 80 7F 00 48 80 03 00 04 30 00 FF FF 2F 80 00 00 90 03 00 04 40 9E 00 3C 90 03 00 08 7C 00 04 AC 7D 20 18 28 7C 00 19 2D 40 A2 FF F8 2F 89 00 01 40 BD 00 20 80 82 8B 68 38 00 00 DD 38 A0 00 01 60 84 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 7F C3 F3 78 4? ?? ?? ?? }
	condition:
		$1
}

rule file_187_0_0 {
	meta:
		name = "__finite"
		size = 32
	strings:
		$1 = { 94 21 FF F0 D8 21 00 08 80 01 00 08 38 21 00 10 54 03 00 7E 3C 63 80 10 54 63 0F FE 4E 80 00 20 }
	condition:
		$1
}

rule file_188_0_0 {
	meta:
		name = "siggetmask"
		size = 36
		refs = "0010 __sigblock"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 38 60 00 00 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_189_0_0 {
	meta:
		name = "_nl_intern_locale_data"
		size = 932
		refs = "0098 malloc 0150 free 0156 _GLOBAL_OFFSET_TABLE_ 015e __libc_errno 01d0 __assert_fail"
	strings:
		$1 = { 2B 85 00 07 94 21 FF E0 7C 08 02 A6 93 A1 00 14 7C 9D 23 78 93 C1 00 18 7C BE 2B 78 93 E1 00 1C 7C 7F 1B 78 90 01 00 24 93 41 00 08 93 61 00 0C 93 81 00 10 40 9D 01 20 2F 83 00 03 81 24 00 00 3C 00 20 05 60 00 10 17 41 9E 00 14 2F 83 00 00 3C 00 20 09 60 00 07 20 40 9E 03 0C 7F 80 48 00 40 9E 00 F4 3F 40 ?? ?? 83 9D 00 04 3B 5A ?? ?? 57 FB 10 3A 7C 1A D8 2E 7F 9C 00 40 41 9C 00 D8 38 1C 00 02 54 00 10 3A 7F 9E 00 40 40 9D 00 C8 38 7C 00 09 54 63 10 3A 4? ?? ?? ?? 2F 83 00 00 7C 65 1B 78 41 9E 00 CC 2F 9C 00 00 93 A3 00 04 38 00 00 00 93 C3 00 08 90 03 00 14 90 03 00 10 90 03 00 18 90 03 00 1C 93 83 00 20 41 9E 00 A4 80 1D 00 08 7F 9E 00 40 41 9C 00 78 7F 88 03 A6 2F 1F 00 00 3C C0 ?? ?? 39 5D 00 08 7C 6B 1B 78 39 20 00 00 7F 5A DA 14 38 C6 ?? ?? 2B 9F 00 0C 40 9D 00 9C 40 9A 02 80 2B 89 00 46 41 9D 00 18 80 FA 00 34 55 28 10 3A 7D 07 40 2E 2F 88 00 05 41 9E 02 50 7C 1D 02 14 90 0B 00 24 7C 08 02 A6 39 29 00 01 34 00 FF FF 7C 08 03 A6 41 82 00 34 84 0A 00 04 39 6B 00 04 7F 9E 00 40 40 9C FF B0 4? ?? ?? ?? 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 38 00 00 16 90 09 00 00 38 A0 00 00 80 01 00 24 7C A3 2B 78 83 41 00 08 7C 08 03 A6 83 61 00 0C 83 81 00 10 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 7D 06 D8 2E 7D 08 32 14 7D 09 03 A6 4E 80 04 20 2B 89 00 0F 40 9D FF 60 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 00 8B 38 C6 ?? ?? 4? ?? ?? ?? 2B 89 00 01 40 9D FF 38 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 00 8A 38 C6 ?? ?? 4? ?? ?? ?? 2B 89 00 04 40 9D FF 10 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 00 89 38 C6 ?? ?? 4? ?? ?? ?? 2B 89 00 0C 40 9D FE E8 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 00 88 38 C6 ?? ?? 4? ?? ?? ?? 2B 89 00 06 40 9D FE C0 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 00 87 38 C6 ?? ?? 4? ?? ?? ?? 2B 89 00 02 40 9D FE 98 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 00 86 38 C6 ?? ?? 4? ?? ?? ?? 2B 89 00 04 40 9D FE 70 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 00 85 38 C6 ?? ?? 4? ?? ?? ?? 2B 89 00 2D 40 9D FE 48 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 00 84 38 C6 ?? ?? 4? ?? ?? ?? 2B 89 00 12 40 9D FE 20 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 00 83 38 C6 ?? ?? 4? ?? ?? ?? 2B 89 00 6E 40 9D FD F8 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 00 82 38 C6 ?? ?? 4? ?? ?? ?? 2B 89 00 05 40 9D FD D0 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 00 81 38 C6 ?? ?? 4? ?? ?? ?? 6C 60 20 03 68 00 11 15 4B FF FC F0 70 08 00 03 40 A2 FD DC 7C 1D 00 2E 90 0B 00 24 4B FF FD AC 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 00 8D 38 C6 ?? ?? 4? ?? ?? ?? }
	condition:
		$1
}

rule file_189_1_0 {
	meta:
		name = "_nl_load_locale"
		size = 724
		refs = "0060 __open_nocancel 0078 __fxstat64 0096 _GLOBAL_OFFSET_TABLE_ 00a2 __libc_errno 00c0 __mmap 00f8 _nl_intern_locale_data 0158 free 0194 __munmap 01b0 malloc 01d8 __read_nocancel 021c strlen 0222 _nl_category_name_sizes 0258 mempcpy 026e _nl_category_name_idxs 027a _nl_category_names 0288 memcpy"
	strings:
		$1 = { 94 21 FF 60 7C 08 02 A6 7D 80 00 26 90 01 00 A4 38 00 00 01 93 41 00 88 93 61 00 8C 7C 9B 23 78 38 80 00 00 93 C1 00 98 7C 7E 1B 78 93 E1 00 9C 7C 3F 0B 78 92 E1 00 7C 93 01 00 80 93 21 00 84 93 81 00 90 93 A1 00 94 91 81 00 78 90 03 00 04 38 00 00 00 90 03 00 08 80 63 00 00 4C C6 31 82 4? ?? ?? ?? 7C 7A 1B 79 41 80 00 AC 38 60 00 03 7F 44 D3 78 38 BF 00 08 4? ?? ?? ?? 2F 83 00 00 41 9C 00 F0 80 1F 00 18 54 00 04 26 2F 80 40 00 41 9E 01 74 3F 20 ?? ?? 80 9F 00 3C 3B 39 ?? ?? 83 19 ?? ?? 7F 18 12 14 38 60 00 00 82 F8 00 00 38 A0 00 01 38 C0 00 02 7F 47 D3 78 39 00 00 00 4? ?? ?? ?? 3B 80 00 01 2F 83 FF FF 7C 7D 1B 78 2E 03 00 00 41 9E 00 C8 38 00 00 06 7F 43 D3 78 44 00 00 02 7C 00 00 26 41 92 00 2C 80 BF 00 3C 7F 63 DB 78 7F A4 EB 78 4? ?? ?? ?? 2C 03 00 00 41 82 00 84 38 00 00 00 93 83 00 0C 90 03 00 00 90 7E 00 08 39 7F 00 A0 80 0B 00 04 81 8B FF D8 7C 08 03 A6 82 EB FF DC 83 0B FF E0 7D 81 81 20 83 2B FF E4 83 4B FF E8 83 6B FF EC 83 8B FF F0 83 AB FF F4 83 CB FF F8 83 EB FF FC 7D 61 5B 78 4E 80 00 20 7F A3 EB 78 4? ?? ?? ?? 40 8E 00 14 81 39 ?? ?? 7D 29 12 14 38 00 00 16 90 09 00 00 38 00 00 06 7F 43 D3 78 44 00 00 02 7C 00 00 26 4B FF FF 94 2F 9C 00 01 40 9E FF 8C 80 9F 00 3C 7F A3 EB 78 4? ?? ?? ?? 4B FF FF 7C 80 18 00 00 2F 80 00 26 40 9E 01 24 83 9F 00 3C 7F 83 E3 78 4? ?? ?? ?? 2E 03 00 00 7C 7D 1B 78 41 92 01 04 2F 9C 00 00 40 9D 00 2C 7C 78 1B 78 7F 04 C3 78 7F 85 E3 78 7F 43 D3 78 4? ?? ?? ?? 2D 83 00 00 7F 83 E0 51 7F 18 1A 14 40 AD FF 6C 41 81 FF E0 81 39 ?? ?? 7D 29 12 14 92 E9 00 00 3B 80 00 00 4B FF FE D8 38 00 00 06 7F 43 D3 78 44 00 00 02 7C 00 00 26 83 BE 00 00 7F A3 EB 78 4? ?? ?? ?? 3D 20 ?? ?? 39 29 ?? ?? 7F 89 D8 AE 7F A4 EB 78 81 21 00 00 7C 65 1B 78 7C 1C 1A 14 30 00 00 24 54 00 00 36 7C 00 00 D0 7D 21 01 6E 3B A1 00 17 57 BD 00 36 7F A3 EB 78 4? ?? ?? ?? 3C 80 ?? ?? 38 84 ?? ?? 38 A0 00 05 4? ?? ?? ?? 3D 20 ?? ?? 39 29 ?? ?? 7C 09 D8 AE 3C 80 ?? ?? 38 84 ?? ?? 7C 84 02 14 38 BC 00 01 4? ?? ?? ?? 7F A3 EB 78 38 80 00 00 4C C6 31 82 4? ?? ?? ?? 7C 7A 1B 79 41 A0 FE 74 38 60 00 03 7F 44 D3 78 38 BF 00 08 4? ?? ?? ?? 2F 83 00 00 40 9C FD DC 4B FF FE B4 3B 80 00 00 4B FF FE 14 3B A0 00 00 2E 1D 00 00 4B FF FE 08 }
	condition:
		$1
}

rule file_189_2_0 {
	meta:
		name = "_nl_unload_locale"
		size = 136
		refs = "0038 free 007c __munmap"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 80 03 00 10 93 E1 00 0C 7C 7F 1B 78 2F 80 00 00 41 9E 00 0C 7C 09 03 A6 4E 80 04 21 80 1F 00 0C 2F 80 00 00 40 9E 00 3C 80 7F 00 04 4? ?? ?? ?? 80 1F 00 0C 2F 80 00 02 41 9E 00 0C 80 7F 00 00 4? ?? ?? ?? 7F E3 FB 78 4? ?? ?? ?? 80 01 00 14 83 E1 00 0C 38 21 00 10 7C 08 03 A6 4E 80 00 20 2F 80 00 01 40 9E FF D0 80 7F 00 04 80 9F 00 08 4? ?? ?? ?? 80 1F 00 0C 4B FF FF BC }
	condition:
		$1
}

rule file_190_0_0 {
	meta:
		name = "round_and_return"
		size = 916
		refs = "010c __mpn_rshift 0148 __errno_location 025c __mpn_construct_long_double"
	strings:
		$1 = { 2F 84 FC 37 94 21 FF B0 7C 08 02 A6 93 01 00 30 7C B8 2B 78 93 21 00 34 7C D9 33 78 93 41 00 38 7C 9A 23 78 93 61 00 3C 7C 7B 1B 78 90 01 00 54 92 C1 00 28 92 E1 00 2C 93 81 00 40 93 A1 00 44 93 C1 00 48 93 E1 00 4C 40 9C 01 14 23 44 FC 37 2F 9A 00 6A 41 9D 02 4C 38 00 00 01 7C 07 38 30 38 E7 FF FF 7C E0 30 39 7C 00 00 26 54 00 1F FE 68 00 00 01 7D 08 03 78 41 9E 02 C8 2F 9A 00 1F 40 9D 02 40 38 FA FF FF 7C E0 2E 70 2F 80 00 00 54 09 10 3A 7F 23 48 2E 54 E7 06 FE 41 9E 00 24 7C 09 03 A6 39 23 FF FC 84 09 00 04 7C 00 00 34 54 00 D9 7E 68 00 00 01 7D 08 03 78 42 00 FF EC 39 20 00 01 90 E1 00 08 7D 29 38 30 38 09 FF FF 7F 29 00 39 7F 56 2E 70 7F 57 2E 70 7E F7 01 94 7C 00 00 26 54 00 1F FE 7E F7 00 D0 68 00 00 01 56 C4 10 3A 7D 08 03 78 7F 63 DB 78 91 01 00 0C 7C 9B 22 14 38 B7 00 04 57 46 06 FE 4? ?? ?? ?? 2F 96 00 00 39 37 00 03 7E C9 03 A6 55 29 10 3A 80 E1 00 08 7D 3B 4A 14 81 01 00 0C 38 00 00 00 40 9D 02 58 94 09 00 04 42 00 FF FC 90 E1 00 08 3B 40 FC 36 91 01 00 0C 4? ?? ?? ?? 38 00 00 22 90 03 00 00 81 01 00 0C 80 E1 00 08 7F 20 3C 30 70 09 00 01 41 82 00 5C 2F 88 00 00 41 9E 01 10 81 3B 00 00 38 09 00 01 7F 89 00 40 90 1B 00 00 40 9D 00 2C 39 60 00 03 7D 69 03 A6 39 3B 00 04 81 69 00 00 39 29 00 04 38 0B 00 01 2F 80 00 00 90 09 FF FC 40 9E 00 08 42 00 FF E8 80 1B 00 0C 70 09 04 00 40 82 01 64 2F 9A FC 36 41 9E 00 88 2F 9A 04 00 40 9D 00 8C 2F 98 00 00 40 9E 00 64 3B C0 00 00 3B E0 00 00 3F 80 7F F0 3B A0 00 00 80 01 00 54 93 81 00 10 7C 08 03 A6 93 A1 00 14 93 C1 00 18 93 E1 00 1C C8 21 00 10 C8 41 00 18 82 C1 00 28 82 E1 00 2C 83 01 00 30 83 21 00 34 83 41 00 38 83 61 00 3C 83 81 00 40 83 A1 00 44 83 C1 00 48 83 E1 00 4C 38 21 00 50 4E 80 00 20 3B C0 00 00 3B E0 00 00 3F 80 FF F0 3B A0 00 00 4B FF FF A0 70 0B 02 00 41 82 00 08 3B 40 FC 37 7F 63 DB 78 7F 44 D3 78 7F 05 C3 78 4? ?? ?? ?? D8 21 00 10 D8 41 00 18 83 81 00 10 83 A1 00 14 83 C1 00 18 83 E1 00 1C 4B FF FF 68 81 3B 00 00 71 2B 00 01 40 A2 FE F0 38 00 00 01 7C 07 38 30 38 E7 FF FF 7C E0 C8 39 41 A2 FF 28 4B FF FE D8 4? ?? ?? ?? 38 00 00 21 3B 80 00 00 90 03 00 00 3B A0 00 00 3B C0 00 00 3B E0 00 00 4B FF FF 24 38 FA FF FF 83 23 00 00 7C 64 1B 78 90 E1 00 08 38 A0 00 04 7F 46 D3 78 91 01 00 0C 4? ?? ?? ?? 81 01 00 0C 80 E1 00 08 90 E1 00 08 3B 40 FC 36 91 01 00 0C 4? ?? ?? ?? 38 00 00 22 80 E1 00 08 90 03 00 00 7F 20 3C 30 70 09 00 01 81 01 00 0C 41 A2 FE B0 4B FF FE 54 7F 63 DB 78 7F 64 DB 78 38 A0 00 04 38 C0 00 01 4? ?? ?? ?? 80 1B 00 0C 3B 5A 00 01 60 00 02 00 90 1B 00 0C 4B FF FE 84 39 60 00 04 83 23 00 0C 7D 69 03 A6 39 20 00 00 7C 1B 48 2E 39 29 00 04 7C 00 00 34 54 00 D9 7E 68 00 00 01 7D 08 03 78 42 00 FF E8 38 00 00 00 90 1B 00 00 38 E0 00 09 90 1B 00 04 90 1B 00 08 90 1B 00 0C 4B FF FF 64 39 60 00 01 7D 69 03 A6 4B FF FD A4 }
	condition:
		$1
}

rule file_190_2_0 {
	meta:
		name = "____strtold_l_internal"
		size = 7764
		refs = "0090 strlen 02be _nl_C_locobj 0526 _fpioconst_pow10 0586 __tens 05a4 __mpn_mul 0744 __correctly_grouped_prefixmb 08c8 memcpy 0994 __mpn_lshift 09f4 __mpn_cmp 0ba0 __mpn_submul_1 0bc0 __mpn_add_n 0e98 __strncasecmp_l 1938 __mpn_rshift 1a0c ____strtoull_l_internal 1b6c __errno_location"
	strings:
		$1 = { 7D 80 00 26 2F 85 00 00 94 21 FD F0 7C 08 02 A6 38 E0 00 00 90 01 02 14 7C 6B 1B 78 91 C1 01 C8 7C CE 33 78 93 21 01 F4 3B 20 00 00 93 41 01 F8 7C 9A 23 78 91 E1 01 CC 92 01 01 D0 92 21 01 D4 92 41 01 D8 92 61 01 DC 92 81 01 E0 92 A1 01 E4 92 C1 01 E8 92 E1 01 EC 93 01 01 F0 93 61 01 FC 93 81 02 00 93 A1 02 04 93 C1 02 08 93 E1 02 0C 91 81 01 C4 81 26 00 04 90 E1 01 88 40 9E 1C 60 82 C9 00 24 3A 2B FF FF 91 61 01 A4 7E C3 B3 78 4? ?? ?? ?? 38 00 00 00 90 01 00 0C 7C 78 1B 78 81 4E 00 34 81 61 01 A4 8C 11 00 01 54 1B 06 3E 57 69 08 3C 7D 2A 4A 2E 71 28 00 20 40 82 FF EC 2F 9B 00 2D 41 9E 02 DC 2F 9B 00 2B 3A E0 00 00 41 9E 05 38 89 16 00 00 2F 08 00 00 41 9A 11 10 54 00 06 3E 7F 80 40 00 39 20 00 00 41 BE 00 14 48 00 01 BC 7D 51 48 AE 7F 8A 00 00 40 9E 01 B0 39 29 00 01 7C 16 48 AE 7D 2A 4B 78 2F 80 00 00 40 9E FF E4 7C 11 50 AE 2B 80 00 2F 40 9D 01 90 2B 80 00 39 41 9D 01 88 2F 9B 00 30 41 9E 04 E8 80 CE 00 38 38 00 00 0A 2C 99 00 00 40 86 1C 84 40 9E 0E 14 7E 30 8B 78 8F 70 00 01 2F 9B 00 30 41 9E FF F8 38 FB FF D0 54 E9 06 3E 2B 89 00 09 57 69 10 3A 7D 26 48 2E 7E 0F 83 78 2E 00 00 10 40 9D 00 48 55 25 06 3E 41 92 04 F0 41 9A 00 34 88 10 00 00 39 20 00 00 7F 80 40 00 41 BE 00 14 48 00 05 94 7D 50 48 AE 7F 8A 00 00 40 9E 05 88 39 29 00 01 7C 16 48 AE 2F 80 00 00 40 9E FF E8 41 92 0E 60 7E 0F 83 78 39 20 00 00 54 E7 06 3E 2B 87 00 09 40 9D 01 CC 41 92 01 B0 40 86 1C 58 81 41 01 88 2F 8A 00 00 40 9E 1B 40 2F 89 00 00 38 E0 00 00 40 9E 00 08 38 E0 FF FF 41 9A 00 34 88 0F 00 00 39 60 00 00 7F 80 40 00 41 BE 00 14 48 00 01 B0 7D 4F 58 AE 7F 8A 00 00 40 9E 01 A4 39 6B 00 01 7C 16 58 AE 2F 80 00 00 40 9E FF E8 7D 6F C0 AE 7D 4F C2 14 7D 3B 4B 78 38 0B FF D0 54 00 06 3E 2B 80 00 09 39 00 00 00 55 65 10 3A 2F 07 FF FF 2C 8B 00 30 7D 4F 53 78 40 9D 00 50 40 92 05 98 7D 66 28 2E 55 6B 06 3E 38 0B FF 9F 54 00 06 3E 2B 80 00 05 41 9D 03 F0 41 9A 00 38 8D 6A 00 01 3B 7B 00 01 39 08 00 01 38 0B FF D0 54 00 06 3E 2B 80 00 09 55 65 10 3A 2F 07 FF FF 2C 8B 00 30 7D 4F 53 78 41 BD FF B8 41 A6 FF D4 40 9A FF D0 7D 07 43 78 4B FF FF C8 38 1B FF D0 54 00 06 3E 2B 80 00 09 40 BD FE 70 3F 20 ?? ?? 3B 39 ?? ?? 81 39 00 38 57 7B 10 3A 7C 09 D8 2E 54 00 06 3E 2F 80 00 69 41 9E 0B A8 2F 80 00 6E 41 9E 0C 1C 2F 9A 00 00 3B 80 00 00 3B A0 00 00 3B C0 00 00 3B E0 00 00 41 9E 00 08 91 7A 00 00 80 01 02 14 93 81 01 B0 7C 08 03 A6 93 A1 01 B4 93 C1 01 B8 93 E1 01 BC 81 81 01 C4 C8 21 01 B0 C8 41 01 B8 7D 81 81 20 81 C1 01 C8 81 E1 01 CC 82 01 01 D0 82 21 01 D4 82 41 01 D8 82 61 01 DC 82 81 01 E0 82 A1 01 E4 82 C1 01 E8 82 E1 01 EC 83 01 01 F0 83 21 01 F4 83 41 01 F8 83 61 01 FC 83 81 02 00 83 A1 02 04 83 C1 02 08 83 E1 02 0C 38 21 02 10 4E 80 00 20 57 60 10 3A 7D 46 00 2E 38 0A FF 9F 54 00 06 3E 2B 80 00 05 41 BD FE 40 39 29 00 01 8F 6F 00 01 38 FB FF D0 4B FF FE 20 8C 11 00 01 3A E0 00 01 54 1B 06 3E 4B FF FD 28 57 7B 10 3A 7D 66 D8 2E 55 6B 06 3E 41 92 02 98 7D 3B 4B 78 2F 8B 00 65 7D EB 7B 78 41 9E 03 A0 7F 9B 48 00 40 9D 00 30 89 4B FF FF 38 0B FF FF 2F 0A 00 30 40 9A 00 20 7C 0B 03 78 88 0B FF FF 3B 7B FF FF 2F 80 00 30 38 0B FF FF 41 9E FF EC 7F 9B 48 00 41 9E 02 84 2F 9B 00 00 7D 34 4B 78 2F 1A 00 00 41 9A 00 08 91 FA 00 00 41 9E 01 C8 2F 87 00 00 41 9E 02 24 88 B6 00 01 88 D6 00 00 2F 05 00 00 88 10 00 00 7F 80 30 00 3A 10 00 01 39 10 FF FF 40 9E FF F0 41 9A 00 34 88 10 00 00 39 60 00 01 7F 85 00 00 41 BE 00 14 4B FF FF DC 7D 48 58 AE 7F 8A 00 00 40 9E 02 18 39 6B 00 01 7C 16 58 AE 2F 80 00 00 40 9E FF E8 7E 67 C2 14 81 41 00 0C 7E 68 9A 14 41 92 12 10 7C E0 3B 78 7D 40 50 50 91 41 00 0C 7F 67 D8 50 41 92 08 04 2F 8A 00 00 41 9C 0D 30 7C 14 D8 50 7F 80 50 00 40 9D 00 08 7D 40 53 78 7D 40 50 50 7E 80 A2 14 91 41 00 0C 7C 0A A2 14 2F 80 01 35 41 9D 16 A0 2F 8A FE BD 41 9C 17 58 2F 94 00 00 40 9D 03 68 3B 41 00 40 3A A1 00 08 38 E1 00 0C 7E 63 9B 78 90 E1 01 88 7E 84 A3 78 7F 45 D3 78 7E A6 AB 78 7F 08 C3 78 7F 29 CB 78 4B FF F7 AD 81 61 00 0C 7C 73 1B 78 2F 8B 00 00 40 9D 11 A0 3A C1 00 E4 82 41 00 08 3E 00 ?? ?? 3A 10 ?? ?? 3A 20 00 01 7E C0 B3 78 7F 4F D3 78 48 00 00 14 82 41 00 08 56 31 08 3C 41 9E 08 64 3A 10 00 10 7D 68 88 39 7D 69 8A 78 41 A2 FF E8 81 D0 00 04 7D E6 7B 78 7E 47 93 78 91 21 00 0C 39 CE FF FE 7F 8E 90 00 7C 03 03 78 7D C5 73 78 7D E4 7B 78 41 9D 02 98 80 D0 00 00 3D 20 ?? ?? 39 29 ?? ?? 90 01 01 A0 38 C6 00 02 54 C6 10 3A 7E 45 93 78 7C C9 32 14 7D C7 73 78 4? ?? ?? ?? 80 01 01 A0 2F 83 00 00 82 41 00 08 7D EA 7B 78 7E 4E 92 14 92 41 00 08 41 9E 02 38 81 61 00 0C 7C 0F 03 78 7D 40 53 78 2F 8B 00 00 4B FF FF 6C 2F 9A 00 00 41 9E 00 08 90 7A 00 00 2F 97 00 00 3B 80 00 00 3B A0 00 00 3B C0 00 00 3B E0 00 00 41 9E FD 08 3F 80 80 00 3B A0 00 00 4B FF FC FC 8C 11 00 01 54 1B 06 3E 4B FF FA C4 88 11 00 01 80 CE 00 38 54 00 10 3A 7D 26 00 2E 38 00 00 0A 2C 89 00 78 40 86 FB 0C 8F 71 00 02 38 E0 00 00 90 E1 01 88 38 00 00 10 2F 9B 00 30 4B FF FA F4 81 41 00 0C 7E 13 83 78 4B FF FE 4C 7D 3B 4B 78 2F 8B 00 70 41 9E 01 0C 7D EB 7B 78 4B FF FD 6C 2B 85 00 60 40 BD FB 10 2B 85 00 66 41 BD FB 08 7E 0F 83 78 4B FF FB 3C 7C A0 2B 78 4B FF FD B4 2F 9B 00 00 41 9E 0B 80 81 21 00 0C 7F 74 DB 78 2F 09 00 00 40 98 FD 74 39 6B FF FF 41 92 00 60 89 4B 00 00 55 48 06 3E 38 08 FF D0 20 00 00 09 7C 00 01 10 7C 00 00 D0 2F 00 00 00 40 BA FF DC 55 4A 06 3E 2F 0A 00 30 40 BA FD 40 3B 7B FF FF 3A 94 FF FF 41 92 01 60 38 00 00 01 2F 9B 00 00 7D 20 4A 14 91 21 00 0C 41 BE FD 20 2F 09 00 00 40 B8 FD 18 39 6B FF FF 40 92 FF A8 89 4B 00 00 81 0E 00 34 55 40 0D FC 7C 08 02 2E 70 08 00 10 7C 00 00 26 54 00 1F FE 4B FF FF A0 41 92 0A D0 2F 85 00 65 41 BE FA 88 80 C1 01 88 7E 23 8B 78 7E 04 83 78 91 61 01 A4 7F 25 CB 78 4? ?? ?? ?? 2F 9A 00 00 81 61 01 A4 41 BE FE 94 7F 91 18 00 41 9E 11 B4 7C 6B 1B 78 91 7A 00 00 4B FF FE 80 7D EB 7B 78 89 4B 00 01 39 EF 00 01 2F 8A 00 2D 41 9E 0A 9C 2F 8A 00 2B 39 00 00 00 41 9E 0F 2C 38 0A FF D0 54 00 06 3E 2B 80 00 09 41 9D 06 E4 41 92 08 E0 2D 88 00 00 41 8E 10 20 38 C9 01 8D 80 01 00 0C 1C 00 00 0A 7D 40 52 14 38 0A FF D0 7F 80 30 00 90 01 00 0C 41 9D 13 DC 8D 4F 00 01 39 0A FF D0 55 08 06 3E 2B 88 00 09 40 9D FF D8 41 AE FB F8 7C 00 00 D0 90 01 00 0C 4B FF FB EC 55 6B 10 3A 7D 66 58 2E 55 6B 06 3E 4B FF FB D0 81 61 00 0C 3A 52 FF FF 7C 0F 03 78 92 41 00 08 2F 8B 00 00 7D 40 53 78 4B FF FD 30 80 90 00 00 3D 40 ?? ?? 39 4A ?? ?? 90 01 01 A0 38 84 00 02 54 84 10 3A 7C 8A 22 14 4? ?? ?? ?? 80 01 01 A0 4B FF FD 74 38 00 00 04 4B FF FE A4 39 61 00 0C 91 61 01 88 38 00 00 26 39 20 00 24 3A 20 00 00 3A A1 00 08 3A 01 00 14 3B 41 00 40 7F 74 D8 50 7F 9B 00 00 39 E0 00 00 40 9D 00 0C 3B 69 00 02 39 E0 00 01 3A C1 00 E4 3F C0 ?? ?? 3E 80 ?? ?? 7F AA D8 50 3B DE ?? ?? 7F 4E D3 78 7E D2 B3 78 3B E0 00 01 3B 80 00 00 3A 94 ?? ?? 48 00 00 38 80 9E 00 00 7E 43 93 78 83 9E 00 04 38 84 00 02 3B 9C FF FE 54 84 10 3A 7C 94 22 14 57 85 10 3A 4? ?? ?? ?? 2F 9D 00 00 57 FF 08 3C 3B DE 00 10 41 9E 00 68 7F A0 F8 39 2F 9C 00 00 41 A2 FF E8 7E 46 93 78 7F 87 E3 78 7D C3 73 78 7F BD FA 78 41 BE FF B0 80 9E 00 00 80 BE 00 04 38 84 00 02 54 84 10 3A 7C 94 22 14 38 A5 FF FE 4? ?? ?? ?? 81 3E 00 04 2F 83 00 00 38 09 FF FE 7E 4B 93 78 7F 9C 02 14 40 9E 03 68 7D D2 73 78 3B 9C FF FF 7D 6E 5B 78 4B FF FF 90 7F 92 D0 00 41 9E 10 4C 3A 5C FF FF 80 E1 01 88 7F 64 DB 78 7F 29 CB 78 7E 63 9B 78 7F 45 D3 78 7E A6 AB 78 7F 08 C3 78 56 5B 10 3A 4B FF F3 49 7D 35 DA 14 83 E9 00 DC 7F FF 00 34 2F 9F 00 00 40 9D 00 34 7F 85 E3 78 7F E6 FB 78 7E C4 B3 78 7E C3 B3 78 4? ?? ?? ?? 80 A1 00 08 7F 43 D3 78 7F 44 D3 78 7F E6 FB 78 4? ?? ?? ?? 2C 03 00 00 40 82 06 AC 2F 9C 00 01 92 21 00 0C 41 9E 0B 4C 2F 9C 00 02 41 9E 08 5C 80 A1 00 08 3A 7C FF FE 56 73 10 3A 7C 85 E0 50 54 84 10 3A 7D 75 DA 14 7D 35 9A 14 83 0B 00 DC 7F 43 D3 78 82 89 00 DC 7C 96 22 14 4? ?? ?? ?? 2F 83 00 00 40 9D 06 90 81 61 00 08 38 00 00 00 55 69 10 3A 3B CB 00 01 7D 35 4A 14 93 C1 00 08 7F CB F3 78 90 09 00 38 7F 9C F0 00 41 9D 0D A8 2F 9E 00 00 57 C9 10 3A 7D 3A 4A 14 40 9D 00 24 7D 7A 48 50 39 6B FF FC 55 6B F0 BE 39 6B 00 01 7D 69 03 A6 84 09 FF FC 90 09 00 04 42 00 FF F8 57 89 10 3A 91 21 01 90 38 00 00 00 7D 35 4A 14 90 09 00 DC 3B E0 00 00 81 69 00 38 38 FC 00 01 81 01 01 90 90 E1 01 88 2E 12 00 00 7F D5 DA 14 57 0E 84 3E 57 1D 04 3E 7E 75 9A 14 7F 75 42 14 56 52 10 3A 7F 8B C0 00 3B 20 FF FF 41 9E 00 EC 7F 2B 73 96 80 FE 00 38 7D 39 71 D6 7D 59 E9 D6 7D 29 58 50 55 29 80 1E 54 E0 84 3E 7D 29 03 78 7F 8A 48 40 40 9D 00 24 7D 29 C2 14 7F 98 48 40 3B 39 FF FF 41 9D 00 14 7F 8A 48 40 40 9D 00 0C 3B 39 FF FF 7D 29 C2 14 7D 4A 48 50 7D 2A 73 96 7C 09 71 D6 7D 09 E9 D6 7C 00 50 50 54 00 80 1E 54 E7 04 3E 7C 00 3B 78 7F 88 00 40 40 9D 00 24 7C 00 C2 14 7F 98 00 40 39 29 FF FF 41 9D 00 14 7F 88 00 40 40 9D 00 0C 39 29 FF FF 7C 00 C2 14 57 39 80 1E 7D 39 CB 78 7D 59 A1 D6 7D 74 C8 16 7C 08 00 50 48 00 00 0C 7D 69 58 50 7D 54 50 50 7F 8B 00 40 7C 8B 00 00 7D 34 50 10 7D 29 49 10 7C 00 C2 14 7F 18 00 40 7D 29 00 D0 41 9D 00 14 40 86 00 18 81 13 00 38 7F 8A 40 40 40 9D 00 0C 3B 39 FF FF 40 99 FF C4 80 A1 01 88 7F 43 D3 78 7E C4 B3 78 7F 26 CB 78 4? ?? ?? ?? 80 1B 00 38 7F 80 18 00 41 9E 00 1C 7F 43 D3 78 7F 44 D3 78 7E C5 B3 78 7F 86 E3 78 4? ?? ?? ?? 3B 39 FF FF 81 7E 00 38 91 7B 00 38 40 91 00 18 7D 3A 92 14 84 09 FF FC 7F 89 D0 00 90 09 00 04 40 9E FF F4 2F 91 00 00 40 9E 05 14 2F 99 00 00 41 9E 05 38 7F 31 00 34 20 11 00 20 81 21 00 0C 2F 80 00 6A 7C 91 48 50 7C 89 23 78 90 81 00 0C 40 9D 10 4C 3B F1 00 6A 20 1F 00 20 7F 20 04 30 90 01 00 14 81 61 01 90 7E B5 5A 14 80 15 00 38 2F 80 00 00 40 9E 00 30 2F 9C 00 00 41 9C 00 28 38 1C 00 01 7F 5A 5A 14 7C 09 03 A6 48 00 00 08 42 40 00 14 84 1A FF FC 3B 9C FF FF 2F 80 00 00 41 9E FF F0 2F 8F 00 00 38 84 FF FF 20 FF 00 1F 39 00 00 01 40 9E 00 0C 7F 88 E0 F8 55 08 0F FE 7E 03 83 78 7E E5 BB 78 7F 26 CB 78 48 00 03 60 7D D2 73 78 7D 6E 5B 78 4B FF FC 30 89 73 00 00 81 0E 00 34 55 60 08 3C 7C 08 02 2E 70 09 00 10 40 82 00 20 8D 73 00 01 55 60 08 3C 7C 08 02 2E 70 07 00 10 41 82 FF F0 48 00 00 08 8D 73 00 01 2F 8B 00 30 41 9E FF F8 38 0B FF D0 2B 80 00 09 40 9D 03 6C 81 2E 00 38 55 6B 10 3A 3A 73 00 01 7D 69 58 2E 39 6B FF A9 3D 20 ?? ?? 7F 69 03 A6 55 60 10 3A 39 29 ?? ?? 7C 09 00 2E 7F 69 DB 78 35 29 FF FF 56 86 10 3A 21 20 00 09 38 C6 FF FB 7D 46 52 14 38 E9 00 01 7C 0A 02 14 7D 6B 38 30 90 01 00 0C 39 40 00 03 91 61 00 20 2F 0A 00 00 41 80 0F 10 42 40 04 48 41 98 04 6C 89 73 00 00 55 60 08 3C 7C 08 02 2E 70 07 00 10 40 82 00 08 7D 73 C0 EE 38 CB FF D0 2B 86 00 09 41 9D 03 78 3A 73 00 01 2F 89 00 02 40 9D 03 1C 38 01 00 08 55 4B 10 3A 7D 60 5A 14 38 E9 FF FD 80 0B 00 0C 7C C6 38 30 7C C6 03 78 90 CB 00 0C 39 29 FF FC 4B FF FF A4 7F 8F B0 00 41 9E 0C CC 38 72 FF FF 54 76 10 3A 7D 35 B2 14 56 51 28 34 80 09 00 38 7C 00 00 34 7E 20 88 50 2F 91 04 00 41 9D 0D 9C 2F 91 00 6A 41 9D 01 84 7F 9B A0 00 40 9E 09 7C 3A 31 FF FF 7E 26 2E 70 7C C6 01 94 54 C6 28 34 7C C6 88 50 2F 86 00 09 41 9E 0C 90 2F 86 00 08 41 9D 0B 18 20 72 00 04 54 63 10 3A 3A 01 00 14 7C 70 1A 14 7F 44 D3 78 7E 45 93 78 20 C6 00 09 4? ?? ?? ?? 80 01 00 08 20 00 00 04 2F 80 00 00 40 9D 00 28 54 0B 10 3A 39 6B FF FC 55 6B F0 BE 39 6B 00 01 7D 69 03 A6 39 21 00 10 38 00 00 00 94 09 00 04 42 00 FF FC 7E 03 83 78 7E 24 8B 78 7E E5 BB 78 38 C0 00 00 38 E0 00 00 39 00 00 00 48 00 01 7C 7D 6F 5B 78 4B FF F5 54 3C 80 ?? ?? 91 61 01 A4 7E 23 8B 78 38 84 ?? ?? 38 A0 00 03 7F 26 CB 78 4? ?? ?? ?? 81 61 01 A4 2F 83 00 00 40 BE F4 40 2F 9A 00 00 41 9E 00 34 3C 80 ?? ?? 38 71 00 03 38 84 ?? ?? 38 A0 00 05 7F 26 CB 78 4? ?? ?? ?? 38 00 00 03 2F 83 00 00 40 9E 00 08 38 00 00 08 7C 11 02 14 90 1A 00 00 2F 97 00 00 40 9E 0A 14 3B C0 00 00 3B E0 00 00 3F 80 7F F0 3B A0 00 00 4B FF F4 08 3C 80 ?? ?? 91 61 01 A4 7E 23 8B 78 38 84 ?? ?? 38 A0 00 03 7F 26 CB 78 4? ?? ?? ?? 81 61 01 A4 2F 83 00 00 40 BE F3 C4 88 11 00 03 38 71 00 03 2F 80 00 28 41 9E 0A 74 3B C0 00 00 3B E0 00 00 3F 80 7F F8 3B A0 00 00 2F 9A 00 00 41 BE F3 B8 90 7A 00 00 4B FF F3 B0 7E 30 8B 78 4B FF F1 FC 38 91 FF 96 70 85 00 1F 7C 84 2E 70 40 82 07 58 54 80 10 3A 7D 3A 02 14 7C FA 00 2E 39 64 FF FF 81 09 00 04 81 49 00 08 3A 01 00 14 80 09 00 0C 55 69 10 3A 7E B5 4A 14 91 10 00 04 91 50 00 08 90 10 00 0C 80 D5 00 38 90 E1 00 14 38 E0 00 1F 80 01 00 40 39 20 00 00 2F 80 00 00 40 9E 00 14 84 1A 00 04 39 29 00 01 2F 80 00 00 41 9E FF F4 7F 9B A0 00 38 91 FF FF 39 00 00 01 41 9D 00 10 7F 8B 48 00 7D 00 00 26 55 08 F7 FE 7E 03 83 78 7E E5 BB 78 4B FF E9 31 D8 21 01 B0 D8 41 01 B8 83 81 01 B0 }
	condition:
		$1
}

rule file_191_0_0 {
	meta:
		name = "getutmp"
		size = 48
		refs = "001c memcpy"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 38 A0 01 80 90 01 00 14 7C 60 1B 78 7C 83 23 78 7C 04 03 78 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_192_0_0 {
	meta:
		name = "__sysv_signal"
		size = 176
		refs = "0032 _GLOBAL_OFFSET_TABLE_ 003a __libc_errno 0070 memset 0088 __sigaction"
	strings:
		$1 = { 2F 84 FF FF 94 21 FE D0 7C 08 02 A6 93 E1 01 2C 7C 7F 1B 78 90 01 01 34 7C 80 23 78 41 9E 00 14 2F 83 00 00 40 9D 00 0C 2F 83 00 40 40 9D 00 34 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 38 00 00 16 90 09 00 00 38 60 FF FF 80 01 01 34 83 E1 01 2C 38 21 01 30 7C 08 03 A6 4E 80 00 20 38 80 00 00 90 01 00 08 38 A0 00 80 38 61 00 0C 4? ?? ?? ?? 3C 00 E0 00 7F E3 FB 78 90 01 00 8C 38 81 00 08 38 A1 00 94 4? ?? ?? ?? 2F 83 00 00 38 60 FF FF 41 BC FF B8 80 01 01 34 80 61 00 94 7C 08 03 A6 83 E1 01 2C 38 21 01 30 4E 80 00 20 }
	condition:
		$1
}

rule file_194_0_0 {
	meta:
		name = "__getsockopt"
		size = 52
		refs = "0030 __syscall_error"
	strings:
		$1 = { 94 21 FF D0 90 61 00 14 90 81 00 18 90 A1 00 1C 90 C1 00 20 90 E1 00 24 38 60 00 0F 38 81 00 14 38 00 00 66 44 00 00 02 38 21 00 30 4C A3 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_195_0_0 {
	meta:
		name = "posix_spawnattr_setschedpolicy"
		size = 28
	strings:
		$1 = { 2B 84 00 02 38 00 00 16 41 9D 00 0C 90 83 01 0C 38 00 00 00 7C 03 03 78 4E 80 00 20 }
	condition:
		$1
}

rule file_197_0_0 {
	meta:
		name = "erand48"
		size = 48
		refs = "000a __libc_drand48_data 0018 __erand48_r"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 3C 80 ?? ?? 38 A1 00 08 90 01 00 24 38 84 ?? ?? 4? ?? ?? ?? 80 01 00 24 C8 21 00 08 38 21 00 20 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_198_0_0 {
	meta:
		name = "__fstat"
		size = 48
		refs = "001c __fxstat"
		altNames = "fstat64"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 7C 85 23 78 90 01 00 14 7C 60 1B 78 7C 04 03 78 38 60 00 03 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_790_0_0 {
	meta:
		name = "__lstat"
		size = 48
		refs = "001c __lxstat"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 7C 85 23 78 90 01 00 14 7C 60 1B 78 7C 04 03 78 38 60 00 03 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_937_0_0 {
	meta:
		name = "__stat"
		size = 48
		refs = "001c __xstat"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 7C 85 23 78 90 01 00 14 7C 60 1B 78 7C 04 03 78 38 60 00 03 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_585_0_0 {
	meta:
		name = "lstat64"
		size = 48
		refs = "001c __lxstat64"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 7C 85 23 78 90 01 00 14 7C 60 1B 78 7C 04 03 78 38 60 00 03 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_596_0_0 {
	meta:
		name = "stat64"
		size = 48
		refs = "001c __xstat64"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 7C 85 23 78 90 01 00 14 7C 60 1B 78 7C 04 03 78 38 60 00 03 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_199_0_0 {
	meta:
		name = "revoke"
		size = 32
		refs = "0002 _GLOBAL_OFFSET_TABLE_ 000a __libc_errno"
		altNames = "__sigreturn fattach fdetach lchmod setlogin sstk"
	strings:
		$1 = { 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 38 00 00 26 90 09 00 00 38 60 FF FF 4E 80 00 20 }
	condition:
		$1
}

rule file_200_0_0 {
	meta:
		name = "_IO_obstack_xsputn"
		size = 240
		refs = "0068 memcpy 00b8 _obstack_newchunk 00c4 mempcpy"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 90 01 00 24 93 C1 00 18 7C 7E 1B 78 80 63 00 14 80 1E 00 18 7D 23 2A 14 93 81 00 10 7F 80 48 40 93 A1 00 14 7C 9C 23 78 7C BD 2B 78 93 E1 00 1C 83 FE 00 A0 40 9C 00 88 81 3F 00 0C 7C 60 18 50 7C 69 1A 14 81 3F 00 10 7C 03 2A 14 90 7F 00 0C 7F 89 00 40 41 9C 00 54 7F 84 E3 78 7F A5 EB 78 4? ?? ?? ?? 81 3F 00 0C 80 1F 00 10 7F A3 EB 78 81 7F 00 08 7D 29 EA 14 90 1E 00 18 91 7E 00 10 91 3E 00 14 90 1F 00 0C 80 01 00 24 83 81 00 10 7C 08 03 A6 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 7F E3 FB 78 7C A4 2B 78 4? ?? ?? ?? 80 7F 00 0C 4B FF FF A0 4? ?? ?? ?? 80 01 00 24 90 7E 00 14 7F A3 EB 78 7C 08 03 A6 83 81 00 10 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 }
	condition:
		$1
}

rule file_200_1_0 {
	meta:
		name = "_IO_obstack_overflow"
		size = 176
		refs = "0048 _obstack_newchunk 00ac __assert_fail"
	strings:
		$1 = { 2F 84 FF FF 94 21 FF E0 7C 08 02 A6 93 A1 00 14 7C 9D 23 78 90 01 00 24 93 C1 00 18 7C 7E 1B 78 93 E1 00 1C 83 E3 00 A0 41 9E 00 68 81 3F 00 0C 81 7F 00 10 38 09 00 01 7F 80 58 40 40 BD 00 18 7F E3 FB 78 38 80 00 01 4? ?? ?? ?? 81 3F 00 0C 38 09 00 01 9B A9 00 00 7F A3 EB 78 81 3F 00 10 81 7F 00 08 90 1E 00 14 80 01 00 24 91 7E 00 10 7C 08 03 A6 91 3E 00 18 83 A1 00 14 91 3F 00 0C 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 00 33 38 C6 ?? ?? 4? ?? ?? ?? }
	condition:
		$1
}

rule file_200_2_0 {
	meta:
		name = "_IO_obstack_vprintf"
		size = 408
		refs = "004c _IO_no_init 0088 _IO_str_init_static_internal 00d4 _IO_vfprintf 011c _obstack_newchunk 0154 __assert_fail"
		altNames = "obstack_vprintf"
	strings:
		$1 = { 94 21 FF 30 7C 08 02 A6 38 C0 00 00 93 A1 00 C4 7C 9D 23 78 38 80 00 00 90 01 00 D4 60 84 80 00 38 00 00 00 93 C1 00 C8 38 E0 00 00 7C BE 2B 78 93 E1 00 CC 38 A0 FF FF 7C 7F 1B 78 38 61 00 08 93 61 00 BC 93 81 00 C0 90 01 00 50 4? ?? ?? ?? 3D 20 ?? ?? 83 7F 00 10 38 09 ?? ?? 80 9F 00 08 80 DF 00 0C 7F 84 D8 51 90 01 00 A0 7F 66 D8 50 40 82 00 10 2F 9B 00 3F 40 9D 00 9C 7F 7C DB 78 38 61 00 08 7F 85 E3 78 4? ?? ?? ?? 80 01 00 18 81 21 00 20 7D 20 48 50 7F 89 E0 00 40 9E 00 BC 81 3F 00 0C 81 7F 00 08 7D 6B 48 50 7C 00 5A 14 81 61 00 1C 7F 8B 00 00 40 9E 00 80 7F 69 DA 14 93 E1 00 A8 38 61 00 08 93 7F 00 0C 7F A4 EB 78 7F C5 F3 78 4? ?? ?? ?? 80 01 00 20 81 61 00 1C 81 3F 00 0C 7C 00 58 50 83 61 00 BC 7C 09 02 14 83 81 00 C0 90 1F 00 0C 80 01 00 D4 83 A1 00 C4 7C 08 03 A6 83 C1 00 C8 83 E1 00 CC 38 21 00 D0 4E 80 00 20 7F E3 FB 78 38 80 00 40 4? ?? ?? ?? 80 DF 00 0C 83 7F 00 10 7F 66 D8 51 41 82 00 4C 80 9F 00 08 4B FF FF 48 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 00 A6 38 C6 ?? ?? 4? ?? ?? ?? 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 00 A3 38 C6 ?? ?? 4? ?? ?? ?? 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 00 9B 38 C6 ?? ?? 4? ?? ?? ?? }
	condition:
		$1
}

rule file_201_0_0 {
	meta:
		name = "skip"
		size = 300
	strings:
		$1 = { 88 03 00 00 7C 6B 1B 78 70 09 00 FF 41 82 00 5C 3C E0 C0 00 39 40 00 00 60 E7 01 00 2F 89 00 22 41 9E 00 54 2F 8A 00 01 41 9E 00 58 2F 89 00 23 98 0B 00 00 39 6B 00 01 41 9E 00 D8 38 09 FF F7 54 08 06 3E 2B 88 00 17 41 9D 00 10 7C 00 07 74 7C E8 00 31 41 80 00 6C 38 63 00 01 88 03 00 00 70 09 00 FF 40 82 FF B8 38 00 00 00 98 0B FF FF 4E 80 00 20 69 4A 00 01 38 63 00 01 4B FF FF E0 2F 89 00 5C 41 9E 00 18 7C 09 03 78 38 63 00 01 99 2B 00 00 39 6B 00 01 4B FF FF C4 89 23 00 01 39 03 00 01 38 63 00 02 2F 89 00 22 39 20 00 22 41 BE FF E0 7C 09 03 78 7D 03 43 78 4B FF FF D4 3D 40 ?? ?? 99 2A ?? ?? 38 00 00 00 3D 40 C0 00 98 03 00 00 61 4A 01 00 38 63 00 01 48 00 00 0C 40 A0 FF 88 38 63 00 01 89 23 00 00 38 09 FF F7 54 09 06 3E 2B 89 00 17 7C 00 07 74 7D 49 00 31 40 9D FF E0 38 00 00 00 98 0B FF FF 4E 80 00 20 3D 40 ?? ?? 38 00 00 00 99 2A ?? ?? 98 03 00 00 38 00 00 00 98 0B FF FF 4E 80 00 20 }
	condition:
		$1
}

rule file_201_1_0 {
	meta:
		name = "setttyent"
		size = 140
		refs = "0024 rewind 0050 _IO_new_fopen"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 93 E1 00 0C 3F E0 ?? ?? 3B FF ?? ?? 90 01 00 14 80 7F 00 04 2F 83 00 00 41 9E 00 20 4? ?? ?? ?? 38 60 00 01 80 01 00 14 83 E1 00 0C 38 21 00 10 7C 08 03 A6 4E 80 00 20 3C 60 ?? ?? 3C 80 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 4? ?? ?? ?? 2F 83 00 00 90 7F 00 04 7C 69 1B 78 38 60 00 00 41 BE FF C8 80 09 00 00 38 60 00 01 83 E1 00 0C 60 00 80 00 90 09 00 00 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_201_2_0 {
	meta:
		name = "getttyent"
		size = 1112
		refs = "0050 fgets_unlocked 0056 _GLOBAL_OFFSET_TABLE_ 0062 __libc_tsd_CTYPE_B 0066 _nl_current_LC_CTYPE 007c strchr 01e4 strncmp 03c8 setttyent 044c __uflow"
	strings:
		$1 = { 94 21 FF D0 7C 08 02 A6 93 01 00 10 3F 00 ?? ?? 93 C1 00 28 3B D8 ?? ?? 80 BE 00 04 93 E1 00 2C 3B FE 00 08 2F 85 00 00 90 01 00 34 92 E1 00 0C 93 21 00 14 93 41 00 18 93 61 00 1C 93 81 00 20 93 A1 00 24 41 9E 03 84 7F E3 FB 78 38 80 00 64 4? ?? ?? ?? 3F A0 ?? ?? 2F 83 00 00 3B BD ?? ?? 83 9D ?? ?? 83 7D ?? ?? 7F 9C 12 14 7F 7B 12 14 41 9E 00 74 7F E3 FB 78 38 80 00 0A 4? ?? ?? ?? 2F 83 00 00 41 9E 02 EC 7F BA EB 78 81 5C 00 00 81 1B 00 00 7F E9 FB 78 48 00 00 08 39 29 00 01 2F 8A 00 00 41 9E 03 3C 89 69 00 00 55 60 08 3C 7C 0A 02 2E 70 00 00 20 40 82 FF E4 2F 8B 00 00 41 9E 00 0C 2F 8B 00 23 40 9E 00 54 80 BE 00 04 7F E3 FB 78 38 80 00 64 4? ?? ?? ?? 2F 83 00 00 40 9E FF 94 38 60 00 00 80 01 00 34 82 E1 00 0C 7C 08 03 A6 83 01 00 10 83 21 00 14 83 41 00 18 83 61 00 1C 83 81 00 20 83 A1 00 24 83 C1 00 28 83 E1 00 2C 38 21 00 30 4E 80 00 20 7D 23 4B 78 98 18 ?? ?? 91 3E 00 6C 4B FF FD 21 7C 7F 1B 78 90 7E 00 70 88 03 00 00 2F 80 00 00 40 9E 02 6C 90 1E 00 74 90 1E 00 70 38 00 00 00 90 1E 00 78 90 1E 00 7C 88 1F 00 00 2F 80 00 00 41 9E 00 F0 83 BA ?? ?? 82 FA ?? ?? 3F 80 ?? ?? 3F 60 ?? ?? 3F 40 ?? ?? 3F 20 ?? ?? 3B 9C ?? ?? 3B 7B ?? ?? 3B 5A ?? ?? 3B 39 ?? ?? 7F BD 12 14 7E F7 12 14 48 00 00 48 81 3D 00 00 2F 89 00 00 41 9E 02 64 88 1F 00 03 54 00 08 3C 7C 09 02 2E 70 09 00 20 41 82 00 40 80 1E 00 78 54 00 00 3C 90 1E 00 78 7F E3 FB 78 4B FF FC 85 88 03 00 00 7C 7F 1B 78 2F 80 00 00 41 9E 00 78 7F E3 FB 78 7F 84 E3 78 38 A0 00 03 4? ?? ?? ?? 2F 83 00 00 41 BE FF A8 7F E3 FB 78 7F 64 DB 78 38 A0 00 02 4? ?? ?? ?? 2F 83 00 00 40 9E 00 C8 81 3D 00 00 2F 89 00 00 41 9E 02 08 88 1F 00 02 54 00 08 3C 7C 09 02 2E 70 09 00 20 41 82 00 A8 80 1E 00 78 7F E3 FB 78 60 00 00 01 90 1E 00 78 4B FF FC 11 7C 7F 1B 78 88 03 00 00 2F 80 00 00 40 9E FF 90 88 18 ?? ?? 2F 80 00 23 41 9E 01 04 88 1F 00 00 2F 80 00 23 41 9E 00 F8 93 FE 00 80 88 1F 00 00 2F 80 00 00 40 9E 00 08 90 1E 00 80 7F E3 FB 78 38 80 00 0A 4? ?? ?? ?? 7C 69 1B 79 38 7E 00 6C 41 A2 FE 5C 38 00 00 00 98 09 00 00 80 01 00 34 82 E1 00 0C 7C 08 03 A6 83 01 00 10 83 21 00 14 83 41 00 18 83 61 00 1C 83 81 00 20 83 A1 00 24 83 C1 00 28 83 E1 00 2C 38 21 00 30 4E 80 00 20 7F E3 FB 78 7F 44 D3 78 38 A0 00 06 4? ?? ?? ?? 2F 83 00 00 40 9E 00 34 81 3D 00 00 2F 89 00 00 41 9E 01 44 88 1F 00 06 54 00 08 3C 7C 09 02 2E 70 09 00 20 41 82 00 14 80 1E 00 78 60 00 00 02 90 1E 00 78 4B FF FE B0 7F E3 FB 78 7F 24 CB 78 38 A0 00 06 4? ?? ?? ?? 2F 83 00 00 40 BE FF 24 88 1F 00 06 2F 80 00 3D 40 BE FF 18 7F E3 FB 78 38 80 00 3D 4? ?? ?? ?? 2C 03 00 00 41 82 00 08 38 63 00 01 90 7E 00 7C 4B FF FE 6C 8C 1F 00 01 2F 80 00 20 2F 00 00 09 41 BE FF F4 41 9A FF F0 4B FF FE F8 81 7E 00 04 81 2B 00 04 81 4B 00 08 38 09 00 01 7F 89 50 40 40 9C 00 C4 88 69 00 00 90 0B 00 04 2F 03 00 0A 2F 83 FF FF 41 BA FD 34 40 9E FF D8 80 BE 00 04 4B FF FD 2C 4B FF FA A1 90 7E 00 74 7C 7F 1B 78 88 03 00 00 2F 80 00 00 40 9E 00 38 90 1E 00 74 4B FF FD 84 4? ?? ?? ?? 2F 83 00 00 38 60 00 00 41 9E FD 14 80 BE 00 04 4B FF FC 6C 81 68 00 00 81 4B 00 24 39 4A 01 00 91 5C 00 00 4B FF FC B8 4B FF FA 55 7C 7F 1B 78 4B FF FD 4C 81 37 00 00 81 29 00 00 81 29 00 24 39 29 01 00 91 3D 00 00 4B FF FD 8C 81 37 00 00 81 29 00 00 81 29 00 24 39 29 01 00 91 3D 00 00 4B FF FD E8 81 37 00 00 81 29 00 00 81 29 00 24 39 29 01 00 91 3D 00 00 4B FF FE AC 7D 63 5B 78 4? ?? ?? ?? 81 7E 00 04 4B FF FF 3C }
	condition:
		$1
}

rule file_201_3_0 {
	meta:
		name = "endttyent"
		size = 92
		refs = "002c _IO_new_fclose"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 38 60 00 01 90 01 00 14 93 E1 00 0C 3F E0 ?? ?? 3B FF ?? ?? 80 1F 00 04 2F 80 00 00 41 9E 00 24 7C 03 03 78 4? ?? ?? ?? 38 00 00 00 38 63 00 01 90 1F 00 04 7C 63 00 34 54 63 D9 7E 68 63 00 01 80 01 00 14 83 E1 00 0C 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_201_4_0 {
	meta:
		name = "getttynam"
		size = 96
		refs = "0018 setttyent 0024 strcmp 0030 getttyent 0040 endttyent"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 93 C1 00 08 7C 7E 1B 78 90 01 00 14 93 E1 00 0C 4? ?? ?? ?? 48 00 00 14 80 9F 00 00 4? ?? ?? ?? 2F 83 00 00 41 9E 00 14 4? ?? ?? ?? 7C 7F 1B 79 7F C3 F3 78 40 82 FF E4 4? ?? ?? ?? 80 01 00 14 7F E3 FB 78 83 C1 00 08 7C 08 03 A6 83 E1 00 0C 38 21 00 10 4E 80 00 20 }
	condition:
		$1
}

rule file_202_0_0 {
	meta:
		name = "quotactl"
		size = 16
		refs = "000c __syscall_error"
	strings:
		$1 = { 38 00 00 83 44 00 00 02 4C A3 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_203_0_0 {
	meta:
		name = "__strchrnul"
		size = 272
	strings:
		$1 = { 70 60 00 03 54 84 06 3E 41 82 00 3C 88 03 00 00 7F 80 20 00 4D 9E 00 20 2F 80 00 00 40 BE 00 1C 4E 80 00 20 88 03 00 00 7F 80 20 00 2F 00 00 00 4D 9E 00 20 4D 9A 00 20 38 63 00 01 70 60 00 03 40 82 FF E4 54 80 40 2E 7C 00 23 78 54 05 80 1E 3C C0 81 01 7C A5 03 78 39 23 FF FC 60 C6 01 00 85 69 00 04 7C AA 5A 78 3D 0A 7E FF 3C EB 7E FF 38 07 FE FF 39 08 FE FF 7D 6B 58 F8 7D 6B 02 78 7D 4A 42 78 7D 6A 53 38 7D 40 30 39 39 69 00 02 39 49 00 01 41 A2 FF CC 88 09 00 00 38 69 00 03 7F 80 20 00 2F 00 00 00 41 9E 00 48 41 9A 00 44 88 09 00 01 7F 80 20 00 2F 00 00 00 41 9E 00 3C 41 9A 00 38 88 09 00 02 7F 80 20 00 2F 00 00 00 41 9E 00 30 41 9A 00 34 88 09 00 03 7F 80 20 00 2F 00 00 00 4D 9E 00 20 40 9A FF 78 4E 80 00 20 7D 23 4B 78 4E 80 00 20 7D 43 53 78 4E 80 00 20 7D 63 5B 78 4E 80 00 20 7D 63 5B 78 4E 80 00 20 }
	condition:
		$1
}

rule file_204_0_0 {
	meta:
		name = "do_waitid"
		size = 748
		refs = "00ce _GLOBAL_OFFSET_TABLE_ 00d6 __libc_errno 0198 __waitpid 02e8 __assert_fail"
	strings:
		$1 = { 94 21 FF D0 7C 08 02 A6 93 E1 00 2C 3F E0 ?? ?? 90 01 00 34 80 1F ?? ?? 93 61 00 1C 7C 9B 23 78 2F 80 00 00 93 81 00 20 7C BC 2B 78 93 A1 00 24 7C 7D 1B 78 93 C1 00 28 7C DE 33 78 40 9D 00 40 38 00 01 10 38 E0 00 00 44 00 00 02 7C 00 00 26 74 09 10 00 40 82 02 28 80 01 00 34 83 61 00 1C 7C 08 03 A6 83 81 00 20 83 A1 00 24 83 C1 00 28 83 E1 00 2C 38 21 00 30 4E 80 00 20 40 9E 00 74 38 00 01 10 38 E0 00 00 44 00 00 02 7C 00 00 26 74 0A 10 00 40 82 02 1C 2F 83 00 00 41 9C 00 30 38 00 00 01 83 61 00 1C 90 1F ?? ?? 80 01 00 34 83 81 00 20 7C 08 03 A6 83 A1 00 24 83 C1 00 28 83 E1 00 2C 38 21 00 30 4E 80 00 20 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 80 09 00 00 2F 80 00 26 40 9E FF BC 38 00 FF FF 90 1F ?? ?? 2F 9D 00 01 41 9E 00 7C 2B 9D 00 01 38 60 FF FF 40 9C 00 48 2F 9C 00 00 41 9E 01 54 77 DF 01 00 40 82 00 18 57 C0 07 BC 57 C9 07 3C 60 00 00 04 7F 89 00 00 41 9E 00 6C 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 38 00 00 5F 90 09 00 00 38 60 FF FF 4B FF FF 14 2F 9D 00 02 41 9E 00 34 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 38 00 00 16 90 09 00 00 38 60 FF FF 4B FF FE EC 2F 9B 00 00 7F 63 DB 78 40 9E FF 8C 4B FF FF D4 2F 9B 00 01 7C 7B 00 D0 40 9E FF 7C 4B FF FF C4 38 81 00 08 57 C5 07 B8 4? ?? ?? ?? 2F 83 FF FF 7C 60 1B 78 41 9E 00 68 2F 83 00 00 41 9E 00 50 81 21 00 08 39 40 00 11 91 5C 00 00 71 2B 00 7F 90 7C 00 0C 93 FC 00 04 41 82 00 4C 38 0B 00 01 7C 00 07 74 7C 0A 0E 71 40 81 00 54 71 20 00 80 91 7C 00 14 38 60 00 00 7C 00 00 26 54 00 1F FE 20 00 00 03 90 1C 00 08 4B FF FE 60 90 7C 00 00 38 60 00 00 90 1C 00 08 4B FF FE 50 38 60 FF FF 4B FF FE 48 55 29 C6 3E 38 00 00 01 91 3C 00 14 38 60 00 00 90 1C 00 08 4B FF FE 30 55 20 06 3E 2F 80 00 7F 41 9E 00 64 6D 20 FF FF 2F 80 FF FF 40 9E 00 8C 38 00 00 06 90 1C 00 08 38 00 00 12 38 60 00 00 90 1C 00 14 4B FF FE 00 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 38 00 00 0E 90 09 00 00 38 60 FF FF 4B FF FD E0 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 90 69 00 00 38 60 FF FF 4B FF FD C4 55 29 C6 3E 38 00 00 05 91 3C 00 14 38 60 00 00 90 1C 00 08 4B FF FD AC 3D 20 ?? ?? 39 29 ?? ?? 81 69 ?? ?? 7D 6B 12 14 90 6B 00 00 38 60 FF FF 4B FF FE 0C 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 00 91 38 C6 ?? ?? 4? ?? ?? ?? }
	condition:
		$1
}

rule file_204_1_0 {
	meta:
		name = "__waitid"
		size = 176
		refs = "0060 __libc_enable_asynccancel 0084 __libc_disable_asynccancel"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 93 81 00 10 7C 7C 1B 78 93 A1 00 14 7C 9D 23 78 93 C1 00 18 7C BE 2B 78 93 E1 00 1C 7C DF 33 78 90 01 00 24 93 61 00 0C 80 02 8B 60 2F 80 00 00 40 9E 00 28 80 01 00 24 83 61 00 0C 7C 08 03 A6 83 81 00 10 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4B FF FC B8 4? ?? ?? ?? 7F A4 EB 78 7C 7B 1B 78 7F C5 F3 78 7F E6 FB 78 7F 83 E3 78 4B FF FC 9D 7C 7F 1B 78 7F 63 DB 78 4? ?? ?? ?? 80 01 00 24 7F E3 FB 78 83 61 00 0C 7C 08 03 A6 83 81 00 10 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 }
	condition:
		$1
}

rule file_205_0_0 {
	meta:
		name = "__snprintf"
		size = 124
		refs = "0068 _IO_vsnprintf"
	strings:
		$1 = { 94 21 FF 90 7C 08 02 A6 90 C1 00 1C 90 01 00 74 90 E1 00 20 91 01 00 24 91 21 00 28 91 41 00 2C 40 86 00 24 D8 21 00 30 D8 41 00 38 D8 61 00 40 D8 81 00 48 D8 A1 00 50 D8 C1 00 58 D8 E1 00 60 D9 01 00 68 38 00 00 03 98 01 00 08 38 00 00 00 38 C1 00 08 98 01 00 09 38 01 00 78 90 01 00 0C 38 01 00 10 90 01 00 10 4? ?? ?? ?? 80 01 00 74 38 21 00 70 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_212_0_0 {
	meta:
		name = "__asprintf_chk"
		size = 124
		refs = "0068 __vasprintf_chk"
	strings:
		$1 = { 94 21 FF 90 7C 08 02 A6 90 C1 00 1C 90 01 00 74 90 E1 00 20 91 01 00 24 91 21 00 28 91 41 00 2C 40 86 00 24 D8 21 00 30 D8 41 00 38 D8 61 00 40 D8 81 00 48 D8 A1 00 50 D8 C1 00 58 D8 E1 00 60 D9 01 00 68 38 00 00 03 98 01 00 08 38 00 00 00 38 C1 00 08 98 01 00 09 38 01 00 78 90 01 00 0C 38 01 00 10 90 01 00 10 4? ?? ?? ?? 80 01 00 74 38 21 00 70 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_1048_0_0 {
	meta:
		name = "__dprintf_chk"
		size = 124
		refs = "0068 __vdprintf_chk"
	strings:
		$1 = { 94 21 FF 90 7C 08 02 A6 90 C1 00 1C 90 01 00 74 90 E1 00 20 91 01 00 24 91 21 00 28 91 41 00 2C 40 86 00 24 D8 21 00 30 D8 41 00 38 D8 61 00 40 D8 81 00 48 D8 A1 00 50 D8 C1 00 58 D8 E1 00 60 D9 01 00 68 38 00 00 03 98 01 00 08 38 00 00 00 38 C1 00 08 98 01 00 09 38 01 00 78 90 01 00 0C 38 01 00 10 90 01 00 10 4? ?? ?? ?? 80 01 00 74 38 21 00 70 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_1249_51_0 {
	meta:
		name = "__nldbl___asprintf_chk"
		size = 124
		refs = "0068 __nldbl___vasprintf_chk"
	strings:
		$1 = { 94 21 FF 90 7C 08 02 A6 90 C1 00 1C 90 01 00 74 90 E1 00 20 91 01 00 24 91 21 00 28 91 41 00 2C 40 86 00 24 D8 21 00 30 D8 41 00 38 D8 61 00 40 D8 81 00 48 D8 A1 00 50 D8 C1 00 58 D8 E1 00 60 D9 01 00 68 38 00 00 03 98 01 00 08 38 00 00 00 38 C1 00 08 98 01 00 09 38 01 00 78 90 01 00 0C 38 01 00 10 90 01 00 10 4? ?? ?? ?? 80 01 00 74 38 21 00 70 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_1249_53_0 {
	meta:
		name = "__nldbl___dprintf_chk"
		size = 124
		refs = "0068 __nldbl___vdprintf_chk"
	strings:
		$1 = { 94 21 FF 90 7C 08 02 A6 90 C1 00 1C 90 01 00 74 90 E1 00 20 91 01 00 24 91 21 00 28 91 41 00 2C 40 86 00 24 D8 21 00 30 D8 41 00 38 D8 61 00 40 D8 81 00 48 D8 A1 00 50 D8 C1 00 58 D8 E1 00 60 D9 01 00 68 38 00 00 03 98 01 00 08 38 00 00 00 38 C1 00 08 98 01 00 09 38 01 00 78 90 01 00 0C 38 01 00 10 90 01 00 10 4? ?? ?? ?? 80 01 00 74 38 21 00 70 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_1249_38_0 {
	meta:
		name = "__nldbl___fprintf_chk"
		size = 124
		refs = "0068 __nldbl___vfprintf_chk"
	strings:
		$1 = { 94 21 FF 90 7C 08 02 A6 90 C1 00 1C 90 01 00 74 90 E1 00 20 91 01 00 24 91 21 00 28 91 41 00 2C 40 86 00 24 D8 21 00 30 D8 41 00 38 D8 61 00 40 D8 81 00 48 D8 A1 00 50 D8 C1 00 58 D8 E1 00 60 D9 01 00 68 38 00 00 03 98 01 00 08 38 00 00 00 38 C1 00 08 98 01 00 09 38 01 00 78 90 01 00 0C 38 01 00 10 90 01 00 10 4? ?? ?? ?? 80 01 00 74 38 21 00 70 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_1249_40_0 {
	meta:
		name = "__nldbl___fwprintf_chk"
		size = 124
		refs = "0068 __nldbl___vfwprintf_chk"
	strings:
		$1 = { 94 21 FF 90 7C 08 02 A6 90 C1 00 1C 90 01 00 74 90 E1 00 20 91 01 00 24 91 21 00 28 91 41 00 2C 40 86 00 24 D8 21 00 30 D8 41 00 38 D8 61 00 40 D8 81 00 48 D8 A1 00 50 D8 C1 00 58 D8 E1 00 60 D9 01 00 68 38 00 00 03 98 01 00 08 38 00 00 00 38 C1 00 08 98 01 00 09 38 01 00 78 90 01 00 0C 38 01 00 10 90 01 00 10 4? ?? ?? ?? 80 01 00 74 38 21 00 70 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_1249_55_0 {
	meta:
		name = "__nldbl___obstack_printf_chk"
		size = 124
		refs = "0068 __nldbl___obstack_vprintf_chk"
	strings:
		$1 = { 94 21 FF 90 7C 08 02 A6 90 C1 00 1C 90 01 00 74 90 E1 00 20 91 01 00 24 91 21 00 28 91 41 00 2C 40 86 00 24 D8 21 00 30 D8 41 00 38 D8 61 00 40 D8 81 00 48 D8 A1 00 50 D8 C1 00 58 D8 E1 00 60 D9 01 00 68 38 00 00 03 98 01 00 08 38 00 00 00 38 C1 00 08 98 01 00 09 38 01 00 78 90 01 00 0C 38 01 00 10 90 01 00 10 4? ?? ?? ?? 80 01 00 74 38 21 00 70 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_1249_63_0 {
	meta:
		name = "__nldbl___syslog_chk"
		size = 124
		refs = "0068 __nldbl___vsyslog_chk"
	strings:
		$1 = { 94 21 FF 90 7C 08 02 A6 90 C1 00 1C 90 01 00 74 90 E1 00 20 91 01 00 24 91 21 00 28 91 41 00 2C 40 86 00 24 D8 21 00 30 D8 41 00 38 D8 61 00 40 D8 81 00 48 D8 A1 00 50 D8 C1 00 58 D8 E1 00 60 D9 01 00 68 38 00 00 03 98 01 00 08 38 00 00 00 38 C1 00 08 98 01 00 09 38 01 00 78 90 01 00 0C 38 01 00 10 90 01 00 10 4? ?? ?? ?? 80 01 00 74 38 21 00 70 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_1249_17_0 {
	meta:
		name = "__nldbl_snprintf"
		size = 124
		refs = "0068 __nldbl_vsnprintf"
	strings:
		$1 = { 94 21 FF 90 7C 08 02 A6 90 C1 00 1C 90 01 00 74 90 E1 00 20 91 01 00 24 91 21 00 28 91 41 00 2C 40 86 00 24 D8 21 00 30 D8 41 00 38 D8 61 00 40 D8 81 00 48 D8 A1 00 50 D8 C1 00 58 D8 E1 00 60 D9 01 00 68 38 00 00 03 98 01 00 08 38 00 00 00 38 C1 00 08 98 01 00 09 38 01 00 78 90 01 00 0C 38 01 00 10 90 01 00 10 4? ?? ?? ?? 80 01 00 74 38 21 00 70 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_1249_59_0 {
	meta:
		name = "__nldbl_strfmon"
		size = 124
		refs = "0068 __nldbl___vstrfmon"
	strings:
		$1 = { 94 21 FF 90 7C 08 02 A6 90 C1 00 1C 90 01 00 74 90 E1 00 20 91 01 00 24 91 21 00 28 91 41 00 2C 40 86 00 24 D8 21 00 30 D8 41 00 38 D8 61 00 40 D8 81 00 48 D8 A1 00 50 D8 C1 00 58 D8 E1 00 60 D9 01 00 68 38 00 00 03 98 01 00 08 38 00 00 00 38 C1 00 08 98 01 00 09 38 01 00 78 90 01 00 0C 38 01 00 10 90 01 00 10 4? ?? ?? ?? 80 01 00 74 38 21 00 70 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_1249_19_0 {
	meta:
		name = "__nldbl_swprintf"
		size = 124
		refs = "0068 __nldbl_vswprintf"
	strings:
		$1 = { 94 21 FF 90 7C 08 02 A6 90 C1 00 1C 90 01 00 74 90 E1 00 20 91 01 00 24 91 21 00 28 91 41 00 2C 40 86 00 24 D8 21 00 30 D8 41 00 38 D8 61 00 40 D8 81 00 48 D8 A1 00 50 D8 C1 00 58 D8 E1 00 60 D9 01 00 68 38 00 00 03 98 01 00 08 38 00 00 00 38 C1 00 08 98 01 00 09 38 01 00 78 90 01 00 0C 38 01 00 10 90 01 00 10 4? ?? ?? ?? 80 01 00 74 38 21 00 70 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_1372_1_0 {
	meta:
		name = "__obstack_printf_chk"
		size = 124
		refs = "0068 __obstack_vprintf_chk"
	strings:
		$1 = { 94 21 FF 90 7C 08 02 A6 90 C1 00 1C 90 01 00 74 90 E1 00 20 91 01 00 24 91 21 00 28 91 41 00 2C 40 86 00 24 D8 21 00 30 D8 41 00 38 D8 61 00 40 D8 81 00 48 D8 A1 00 50 D8 C1 00 58 D8 E1 00 60 D9 01 00 68 38 00 00 03 98 01 00 08 38 00 00 00 38 C1 00 08 98 01 00 09 38 01 00 78 90 01 00 0C 38 01 00 10 90 01 00 10 4? ?? ?? ?? 80 01 00 74 38 21 00 70 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_1409_0_0 {
	meta:
		name = "__swprintf"
		size = 124
		refs = "0068 __vswprintf"
	strings:
		$1 = { 94 21 FF 90 7C 08 02 A6 90 C1 00 1C 90 01 00 74 90 E1 00 20 91 01 00 24 91 21 00 28 91 41 00 2C 40 86 00 24 D8 21 00 30 D8 41 00 38 D8 61 00 40 D8 81 00 48 D8 A1 00 50 D8 C1 00 58 D8 E1 00 60 D9 01 00 68 38 00 00 03 98 01 00 08 38 00 00 00 38 C1 00 08 98 01 00 09 38 01 00 78 90 01 00 0C 38 01 00 10 90 01 00 10 4? ?? ?? ?? 80 01 00 74 38 21 00 70 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_877_5_0 {
	meta:
		name = "__syslog_chk"
		size = 124
		refs = "0068 __vsyslog_chk"
	strings:
		$1 = { 94 21 FF 90 7C 08 02 A6 90 C1 00 1C 90 01 00 74 90 E1 00 20 91 01 00 24 91 21 00 28 91 41 00 2C 40 86 00 24 D8 21 00 30 D8 41 00 38 D8 61 00 40 D8 81 00 48 D8 A1 00 50 D8 C1 00 58 D8 E1 00 60 D9 01 00 68 38 00 00 03 98 01 00 08 38 00 00 00 38 C1 00 08 98 01 00 09 38 01 00 78 90 01 00 0C 38 01 00 10 90 01 00 10 4? ?? ?? ?? 80 01 00 74 38 21 00 70 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_206_0_0 {
	meta:
		name = "wcwidth"
		size = 144
		refs = "0002 _GLOBAL_OFFSET_TABLE_ 000a _nl_current_LC_CTYPE"
	strings:
		$1 = { 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 81 29 00 00 38 00 FF FF 81 29 00 00 81 29 00 54 81 69 00 00 81 49 00 04 7C 6B 5C 30 7F 8B 50 40 40 9C 00 58 39 6B 00 05 55 6B 10 3A 7D 69 58 2E 2F 8B 00 00 41 9E 00 44 81 49 00 08 81 09 00 0C 7C 6A 54 30 7D 4A 40 38 55 4A 10 3A 7D 6A 5A 14 7D 69 58 2E 2F 8B 00 00 41 9E 00 20 81 49 00 10 7D 29 5A 14 7C 63 50 38 7D 29 18 AE 2F 89 00 FF 41 9E 00 08 7D 20 4B 78 7C 03 03 78 4E 80 00 20 }
	condition:
		$1
}

rule file_208_0_0 {
	meta:
		name = "__fcvt"
		size = 196
		refs = "0058 __fcvt_r 00ac malloc"
		altNames = "fcvt"
	strings:
		$1 = { 94 21 FF D0 7C 08 02 A6 93 E1 00 24 3F E0 ?? ?? 80 DF ?? ?? DB E1 00 28 FF E0 08 90 2F 86 00 00 93 81 00 18 7C 7C 1B 78 93 A1 00 1C 7C 9D 23 78 93 C1 00 20 7C BE 2B 78 90 01 00 34 93 61 00 14 41 9E 00 4C FC 20 F8 90 7F 83 E3 78 7F A4 EB 78 7F C5 F3 78 38 E0 01 48 4? ?? ?? ?? 83 7F ?? ?? 80 01 00 34 7F 63 DB 78 83 81 00 18 7C 08 03 A6 83 61 00 14 83 A1 00 1C 83 C1 00 20 83 E1 00 24 CB E1 00 28 38 21 00 30 4E 80 00 20 3F 60 ?? ?? 3B 7B ?? ?? 7F 66 DB 78 38 E0 00 14 4? ?? ?? ?? 2F 83 FF FF 40 9E FF BC 38 60 01 48 4? ?? ?? ?? 2F 83 00 00 90 7F ?? ?? 7C 66 1B 78 40 9E FF 88 4B FF FF A0 }
	condition:
		$1
}

rule file_208_1_0 {
	meta:
		name = "__ecvt"
		size = 64
		refs = "0024 __ecvt_r"
		altNames = "ecvt"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 38 E0 00 14 93 E1 00 0C 3F E0 ?? ?? 3B FF ?? ?? 3B FF 00 14 90 01 00 14 7F E6 FB 78 4? ?? ?? ?? 80 01 00 14 7F E3 FB 78 83 E1 00 0C 7C 08 03 A6 38 21 00 10 4E 80 00 20 }
	condition:
		$1
}

rule file_208_2_0 {
	meta:
		name = "__gcvt"
		size = 80
		refs = "0034 sprintf"
		altNames = "gcvt"
	strings:
		$1 = { 2F 83 00 11 94 21 FF F0 7C 08 02 A6 7C 65 1B 78 93 E1 00 0C 7C 9F 23 78 90 01 00 14 40 9D 00 08 38 A0 00 11 3C 80 ?? ?? 7F E3 FB 78 38 84 ?? ?? 4C C6 32 42 4? ?? ?? ?? 80 01 00 14 7F E3 FB 78 83 E1 00 0C 7C 08 03 A6 38 21 00 10 4E 80 00 20 }
	condition:
		$1
}

rule file_209_0_0 {
	meta:
		name = "ualarm"
		size = 116
		refs = "002c __setitimer"
	strings:
		$1 = { 94 21 FF D0 7C 08 02 A6 90 61 00 14 38 A1 00 18 38 60 00 00 90 01 00 34 38 00 00 00 90 81 00 0C 38 81 00 08 90 01 00 10 90 01 00 08 4? ?? ?? ?? 2F 83 00 00 38 60 FF FF 41 9C 00 2C 80 01 00 20 54 0B 40 2E 54 09 18 38 7D 29 58 50 81 61 00 24 55 23 30 32 7C 69 18 50 7C 63 02 14 54 63 30 32 7C 63 5A 14 80 01 00 34 38 21 00 30 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_210_2_0 {
	meta:
		name = "svcraw_freeargs"
		size = 100
		refs = "001c __rpc_thread_variables"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 93 C1 00 08 7C BE 2B 78 90 01 00 14 93 E1 00 0C 7C 9F 23 78 4? ?? ?? ?? 80 03 00 B8 38 60 00 00 2F 80 00 00 41 9E 00 20 7C 03 03 78 7F E9 03 A6 38 00 00 02 94 03 23 94 7F C4 F3 78 4C C6 31 82 4E 80 04 21 80 01 00 14 83 C1 00 08 7C 08 03 A6 83 E1 00 0C 38 21 00 10 4E 80 00 20 }
	condition:
		$1
}

rule file_210_3_0 {
	meta:
		name = "svcraw_getargs"
		size = 92
		refs = "001c __rpc_thread_variables"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 93 C1 00 08 7C BE 2B 78 93 E1 00 0C 7C 9F 23 78 90 01 00 14 4? ?? ?? ?? 81 23 00 B8 38 60 00 00 2F 89 00 00 41 9E 00 18 38 69 23 94 7F E9 03 A6 7F C4 F3 78 4C C6 31 82 4E 80 04 21 80 01 00 14 83 C1 00 08 7C 08 03 A6 83 E1 00 0C 38 21 00 10 4E 80 00 20 }
	condition:
		$1
}

rule file_210_4_0 {
	meta:
		name = "svcraw_reply"
		size = 200
		refs = "0024 __rpc_thread_variables 005c xdr_replymsg"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 93 81 00 10 7C 9C 23 78 93 C1 00 18 3B C0 00 00 93 E1 00 1C 90 01 00 24 93 A1 00 14 4? ?? ?? ?? 83 E3 00 B8 2F 9F 00 00 41 9E 00 38 81 3F 23 98 3B BF 23 94 38 80 00 00 80 09 00 14 7F A3 EB 78 93 DF 23 94 7C 09 03 A6 4E 80 04 21 7F A3 EB 78 7F 84 E3 78 4? ?? ?? ?? 2F 83 00 00 40 9E 00 28 80 01 00 24 7F C3 F3 78 83 81 00 10 7C 08 03 A6 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 81 3F 23 98 7F A3 EB 78 3B C0 00 01 80 09 00 10 7C 09 03 A6 4E 80 04 21 80 01 00 24 7F C3 F3 78 83 81 00 10 7C 08 03 A6 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 }
	condition:
		$1
}

rule file_210_5_0 {
	meta:
		name = "svcraw_recv"
		size = 128
		refs = "0018 __rpc_thread_variables 0058 xdr_callmsg"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 93 C1 00 08 7C 9E 23 78 90 01 00 14 93 E1 00 0C 4? ?? ?? ?? 81 23 00 B8 38 60 00 00 2F 89 00 00 41 9E 00 40 81 69 23 98 3B E9 23 94 38 80 00 00 80 0B 00 14 39 60 00 01 91 69 23 94 7F E3 FB 78 7C 09 03 A6 4E 80 04 21 7F E3 FB 78 7F C4 F3 78 4? ?? ?? ?? 7C 63 00 34 54 63 D9 7E 68 63 00 01 80 01 00 14 83 C1 00 08 7C 08 03 A6 83 E1 00 0C 38 21 00 10 4E 80 00 20 }
	condition:
		$1
}

rule file_210_6_0 {
	meta:
		name = "svcraw_create"
		size = 136
		refs = "0010 __rpc_thread_variables 0050 xdrmem_create 0074 calloc"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 93 E1 00 0C 90 01 00 14 4? ?? ?? ?? 83 E3 00 B8 2F 9F 00 00 41 9E 00 50 39 20 00 00 91 3F 22 60 38 1F 23 AC 38 7F 23 94 B1 3F 22 64 3D 20 ?? ?? 39 29 ?? ?? 91 3F 22 68 7F E4 FB 78 38 A0 22 60 90 1F 22 84 38 C0 00 02 4? ?? ?? ?? 38 7F 22 60 80 01 00 14 83 E1 00 0C 38 21 00 10 7C 08 03 A6 4E 80 00 20 38 60 00 01 38 80 25 3C 4? ?? ?? ?? 7C 7F 1B 79 38 60 00 00 40 82 FF A0 4B FF FF D4 }
	condition:
		$1
}

rule file_211_0_0 {
	meta:
		name = "raise"
		size = 144
		refs = "006e _GLOBAL_OFFSET_TABLE_ 0076 __libc_errno"
	strings:
		$1 = { 80 82 8B C8 94 21 FF F0 2F 84 00 00 93 E1 00 0C 7C 7F 1B 78 80 62 8B CC 40 9E 00 3C 38 00 00 CF 44 00 00 02 7C 00 00 26 90 62 8B C8 7C 64 1B 78 38 00 00 FA 7F E5 FB 78 44 00 00 02 7C 00 00 26 74 09 10 00 40 82 00 28 83 E1 00 0C 38 21 00 10 4E 80 00 20 2F 83 00 00 41 9D FF D8 54 60 00 7F 41 82 00 28 7C 63 00 D0 4B FF FF C8 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 90 69 00 00 38 60 FF FF 4B FF FF C4 7C 83 23 78 4B FF FF A4 }
	condition:
		$1
}

rule file_213_0_0 {
	meta:
		name = "plural_eval"
		size = 540
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 90 01 00 24 93 C1 00 18 7C 7E 1B 78 80 1E 00 00 93 E1 00 1C 7C 9F 23 78 2F 80 00 01 93 81 00 10 93 A1 00 14 41 9E 00 B8 40 9D 00 FC 2F 80 00 02 41 9E 00 34 2F 80 00 03 41 9E 00 74 3B E0 00 00 80 01 00 24 7F E3 FB 78 83 81 00 10 7C 08 03 A6 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 80 7E 00 08 7F E4 FB 78 4B FF FF 8D 83 BE 00 04 7C 7C 1B 78 2F 9D 00 0F 41 9E 00 98 2F 9D 00 0E 40 9E 00 C4 2F 83 00 00 41 9E FF B0 80 7E 00 0C 7F E4 FB 78 4B FF FF 61 7C 63 00 34 54 63 D9 7E 68 7F 00 01 4B FF FF 98 80 7E 00 08 7F E4 FB 78 4B FF FF 45 7C 63 00 34 54 63 D9 7E 38 63 00 01 54 63 10 3A 7F DE 1A 14 83 DE 00 08 80 1E 00 00 2F 80 00 01 40 9E FF 50 80 7E 00 08 7F E4 FB 78 4B FF FF 15 80 01 00 24 7C 7F 00 34 83 81 00 10 7C 08 03 A6 57 FF D9 7E 7F E3 FB 78 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 2F 83 00 00 41 BE FF 78 3B E0 00 01 4B FF FF 20 2F 80 00 00 40 BE FF 14 80 1E 00 04 2F 80 00 00 41 BE FF 0C 2F 80 00 01 40 9E FF 00 83 FE 00 08 4B FF FE FC 80 7E 00 0C 7F E4 FB 78 3B BD FF FD 4B FF FE A5 2B 9D 00 0A 3B E0 00 00 41 BD FE E0 3D 20 ?? ?? 39 29 ?? ?? 57 BD 10 3A 7C 09 E8 2E 7D 20 4A 14 7D 29 03 A6 4E 80 04 20 7F 9F 1A 78 7F FF 00 34 57 FF D9 7E 4B FF FE B4 7F E3 E0 10 3B E0 00 00 7F FF F9 14 4B FF FE A4 7F FC 18 10 3B E0 00 00 7F FF F9 14 4B FF FE 94 7F FC 18 10 7F FF F9 10 7F FF 00 D0 4B FF FE 84 7F E3 E0 10 7F FF F9 10 7F FF 00 D0 4B FF FE 74 7F E3 E0 50 4B FF FE 6C 7F E3 E2 14 4B FF FE 64 7C 1C 1B 96 7C 60 19 D6 7F E3 E0 50 4B FF FE 54 7F FC 1B 96 4B FF FE 4C 7F E3 E1 D6 4B FF FE 44 7F 83 1A 78 7C 63 00 34 54 63 D9 7E 68 7F 00 01 4B FF FE 30 }
	condition:
		$1
}

rule file_213_1_0 {
	meta:
		name = "transcmp"
		size = 164
		refs = "003c strcmp"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 80 03 00 10 93 C1 00 08 7C 7E 1B 78 2F 80 00 00 93 E1 00 0C 38 63 00 1C 7C 9F 23 78 41 9E 00 74 80 1F 00 10 38 9F 00 1C 2F 80 00 00 41 9E 00 5C 4? ?? ?? ?? 2C 03 00 00 40 82 00 38 80 7E 00 00 80 9F 00 00 4? ?? ?? ?? 2C 03 00 00 40 82 00 24 80 7E 00 08 80 9F 00 08 4? ?? ?? ?? 2C 03 00 00 40 82 00 10 80 7E 00 04 80 1F 00 04 7C 60 18 50 80 01 00 14 83 C1 00 08 7C 08 03 A6 83 E1 00 0C 38 21 00 10 4E 80 00 20 80 9F 00 1C 4B FF FF A4 80 7E 00 1C 4B FF FF 8C }
	condition:
		$1
}

rule file_213_2_0 {
	meta:
		name = "plural_lookup.clone.1"
		size = 184
		refs = "005c __rawmemchr"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 90 01 00 24 93 E1 00 1C 7C 7F 1B 78 80 63 00 60 93 81 00 10 7C DC 33 78 93 A1 00 14 93 C1 00 18 7C BE 2B 78 4B FF FD 15 7F C0 F3 78 81 3F 00 64 7F FE E2 14 7D 29 18 10 7D 29 49 10 7C 7D 48 38 2F 9D 00 00 7C 03 03 78 38 80 00 00 3B BD FF FF 41 9E 00 38 4? ?? ?? ?? 38 03 00 01 7F 80 F8 40 41 9C FF E0 80 01 00 24 7F C3 F3 78 83 81 00 10 7C 08 03 A6 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 7C 1E 03 78 80 01 00 24 7F C3 F3 78 83 81 00 10 7C 08 03 A6 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 }
	condition:
		$1
}

rule file_213_3_0 {
	meta:
		name = "_nl_find_msg"
		size = 2880
		refs = "00a0 strlen 00ac __hash_string 0144 strcmp 0332 __pthread_rwlock_rdlock 0396 __pthread_rwlock_unlock 0436 _GLOBAL_OFFSET_TABLE_ 043e _nl_current_LC_CTYPE 0454 _nl_load_domain 0464 getenv 0492 __pthread_rwlock_wrlock 0580 realloc 05e4 __gconv 0614 malloc 063c free 075c __strdup 0794 _nl_find_msg 07a8 strstr 0830 mempcpy 089a _nl_C_locobj 0970 __gconv_open 09b4 memcpy 0a44 __lll_lock_wait_private 0aa4 calloc"
	strings:
		$1 = { 94 21 FF A0 7C 08 02 A6 7D 80 00 26 90 01 00 64 80 03 00 04 92 A1 00 34 7C 95 23 78 2F 80 00 00 93 01 00 40 7C D8 33 78 93 21 00 44 7C 79 1B 78 93 41 00 48 7C FA 3B 78 93 A1 00 54 7C BD 2B 78 93 E1 00 5C 7C 3F 0B 78 92 01 00 20 92 21 00 24 92 41 00 28 92 61 00 2C 92 81 00 30 92 C1 00 38 92 E1 00 3C 93 61 00 4C 93 81 00 50 93 C1 00 58 91 81 00 1C 40 9D 03 E0 82 F9 00 08 3B 80 00 00 2F 97 00 00 41 9E 00 F8 80 17 00 30 82 D7 00 14 2F 80 00 00 7E D4 B3 78 41 9E 01 68 7F A3 EB 78 4? ?? ?? ?? 7C 73 1B 78 7F A3 EB 78 4? ?? ?? ?? 82 17 00 2C 81 37 00 34 38 10 FF FE 82 97 00 30 7E 23 03 96 7F 83 83 96 7E 31 01 D6 7F 9C 81 D6 7E 31 18 50 2E 09 00 00 3A 31 00 01 7E 51 80 50 7F 9C 18 50 7E 10 88 50 41 92 00 80 57 80 10 3A 7F D4 04 2C 2F 9E 00 00 41 9E 00 80 3B DE FF FF 7F 96 F0 40 40 9D 01 54 80 17 00 0C 2F 80 00 00 41 9E 01 D0 83 77 00 18 57 C0 18 38 7D 3B 04 2C 7F 09 98 40 41 98 00 34 80 97 00 00 41 9E 01 C4 7F 7B 02 14 3B 7B 00 04 7C 00 DC 2C 7F A3 EB 78 7C 84 02 14 4? ?? ?? ?? 7C 63 00 34 54 63 D9 7E 2F 83 00 00 40 9E 01 3C 7F 9C 90 40 41 9C 01 7C 7F 9C 82 14 40 B2 FF 88 57 80 10 3A 7F D4 00 2E 2F 9E 00 00 40 9E FF 88 3B 80 00 00 39 7F 00 60 80 0B 00 04 7F 83 E3 78 81 8B FF BC 7C 08 03 A6 82 0B FF C0 82 2B FF C4 7D 80 81 20 82 4B FF C8 82 6B FF CC 82 8B FF D0 82 AB FF D4 82 CB FF D8 82 EB FF DC 83 0B FF E0 83 2B FF E4 83 4B FF E8 83 6B FF EC 83 8B FF F0 83 AB FF F4 83 CB FF F8 83 EB FF FC 7D 61 5B 78 4E 80 00 20 39 69 00 04 7C 80 5C 2C 7F A3 EB 78 7C 93 22 14 4? ?? ?? ?? 2F 83 00 00 41 9C 00 50 41 9E 00 98 3B 9E 00 01 7F 94 E0 40 40 BD FF 74 80 17 00 0C 82 77 00 00 2E 00 00 00 83 77 00 18 7F D4 E2 14 57 DE F8 7E 57 C9 18 38 7D 3B 4A 14 40 B2 FF B4 80 89 00 04 7F A3 EB 78 7C 93 22 14 4? ?? ?? ?? 2F 83 00 00 40 9C FF B8 7F 9C F0 40 7F D4 F3 78 41 9C FF CC 3B 80 00 00 4B FF FF 28 81 37 00 24 7C 16 F0 50 54 00 18 38 7D 69 00 2E 7D 29 02 14 7F 93 58 40 40 BC FE E8 80 89 00 04 7F A3 EB 78 4? ?? ?? ?? 7C 63 00 34 54 63 D9 7E 2F 83 00 00 41 9E FE CC 7F 9E B0 40 40 9C 00 68 81 37 00 0C 80 17 00 00 2F 89 00 00 41 9E 01 50 81 77 00 1C 57 C9 18 38 2F 98 00 00 7D 4B 4A 14 7F 6B 4C 2C 39 4A 00 04 7F 80 54 2C 3B 7B 00 01 7F 80 E2 14 40 9E 00 50 93 7A 00 00 4B FF FE A8 7F 9C 8A 14 4B FF FE 0C 83 77 00 18 57 C0 18 38 7D 3B 00 2E 4B FF FE 34 7F 7B 02 14 80 1B 00 04 4B FF FE 44 81 37 00 28 7C 16 F0 50 54 00 18 38 7D 69 02 14 7F 69 00 2E 83 8B 00 04 2F 98 00 00 41 BE FF B8 2F 95 00 00 41 9E 00 F4 82 95 00 08 2F 94 00 00 41 9E 00 E8 3D 20 ?? ?? 38 09 ?? ?? 2F 80 00 00 41 9E 00 0C 38 77 00 40 4? ?? ?? ?? 83 17 00 3C 3B A0 00 00 2F 98 00 00 41 9E 00 40 1D 38 00 0C 82 37 00 38 38 09 FF F4 7E 31 02 14 48 00 00 08 41 9A 01 1C 80 71 00 00 7E 84 A3 78 3B 18 FF FF 4? ?? ?? ?? 7E 3D 8B 78 2F 83 00 00 2F 18 00 00 3A 31 FF F4 40 9E FF DC 3F 00 ?? ?? 3B 18 ?? ?? 2F 98 00 00 41 9E 00 0C 38 77 00 40 4? ?? ?? ?? 2F 9D 00 00 41 9E 00 E0 80 1D 00 04 2F 80 FF FF 41 BE FF 14 81 3D 00 08 2F 89 00 00 41 9E 06 48 2F 89 FF FF 41 9E 07 68 57 C0 10 3A 7D 29 00 2E 2F 89 00 00 41 9E 01 28 83 69 00 00 3B 89 00 04 93 7A 00 00 4B FF FD 8C 81 77 00 1C 57 C9 18 38 7D 4B 4A 14 7F 6B 48 2E 83 8A 00 04 3B 7B 00 01 7F 80 E2 14 4B FF FF 04 3F 00 ?? ?? 3B 18 ?? ?? 80 18 00 08 2F 80 00 00 41 9E 00 38 82 98 00 0C 2F 94 00 00 40 9E FF 00 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 81 29 00 00 81 29 00 00 82 89 00 5C 4B FF FE E0 4? ?? ?? ?? 4B FF FC 20 3C 60 ?? ?? 38 63 ?? ?? 4? ?? ?? ?? 7C 73 1B 79 41 82 00 10 88 13 00 00 2F 80 00 00 40 9E 05 1C 38 00 00 01 90 18 00 08 4B FF FF A4 3B A0 00 00 4B FF FF 08 3D 20 ?? ?? 38 09 ?? ?? 2F 80 00 00 41 9E 00 0C 38 77 00 40 4? ?? ?? ?? 82 17 00 3C 2F 90 00 00 41 9E 02 88 1E 70 00 0C 82 37 00 38 3A 73 FF F4 7E 71 9A 14 7E 12 83 78 48 00 00 08 41 9A 02 70 80 73 00 00 7E 84 A3 78 3A 52 FF FF 4? ?? ?? ?? 7E 7D 9B 78 2F 83 00 00 2F 12 00 00 3A 73 FF F4 40 9E FF DC 2F 98 00 00 41 BE FE BC 38 77 00 40 4? ?? ?? ?? 4B FF FE B0 3F 00 ?? ?? 3B 18 ?? ?? 3B 38 00 10 39 60 00 01 7C 00 C8 28 7C 00 48 00 40 82 00 0C 7D 60 C9 2D 40 A2 FF F0 4C 00 01 2C 2F 80 00 00 40 9E 05 F8 81 38 00 14 7F F6 FB 78 93 9F 00 08 3A E0 00 00 38 09 00 04 94 16 00 0C 3A A0 0F F0 81 38 00 18 48 00 00 60 2F 97 00 00 41 9E 00 AC 3A F7 00 01 80 78 00 04 56 E9 60 26 56 E0 20 36 7C 00 48 50 90 18 00 18 7C 04 03 78 4? ?? ?? ?? 2C 03 00 00 41 82 00 A8 81 78 00 04 81 38 00 18 81 4B 00 00 39 29 FF FC 39 63 00 04 91 43 00 00 38 03 00 08 90 78 00 04 91 78 00 14 91 38 00 18 90 1F 00 0C 2B 89 00 03 40 9D FF A0 80 BF 00 08 38 09 FF FC 80 FF 00 0C 38 9F 00 08 80 7D 00 04 7C A5 DA 14 7E C6 B3 78 7C E7 02 14 39 1F 00 10 4? ?? ?? ?? 2C 03 00 00 41 82 00 A0 2F 83 00 04 41 9E 00 98 2F 83 00 05 40 9E 00 F8 2F 97 00 00 93 9F 00 08 40 9E FF 5C 92 B8 00 18 38 60 0F F0 4? ?? ?? ?? 2C 03 00 00 41 82 00 24 81 58 00 04 39 20 0F EC 3A E0 00 01 4B FF FF 70 80 78 00 04 80 03 00 00 90 18 00 04 4? ?? ?? ?? 38 00 00 00 90 18 00 14 90 18 00 18 7C 00 04 AC 7D 20 C8 28 7C 00 C9 2D 40 A2 FF F8 2F 89 00 01 3B 80 FF FF 40 9D FB 18 80 82 8B 68 38 00 00 DD 7F 23 CB 78 60 84 00 01 38 A0 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FA F4 81 38 00 14 57 DE 10 3A 80 1F 00 0C 81 5D 00 08 7D 69 00 50 39 6B FF FC 91 69 00 00 7D 00 48 50 81 78 00 18 7D 2A F1 2E 7D 68 5A 14 55 68 07 BE 7C 00 42 14 55 6B 00 3A 90 18 00 14 38 00 00 00 91 78 00 18 7C 00 04 AC 7D 20 C8 28 7C 00 C9 2D 40 A2 FF F8 2F 89 00 01 41 9D 03 F4 81 3D 00 08 7D 29 F0 2E 4B FF FC F4 38 00 00 00 7C 00 04 AC 7D 20 C8 28 7C 00 C9 2D 40 A2 FF F8 2F 89 00 01 3B 80 00 00 40 9D FA 6C 80 82 8B 68 38 00 00 DD 7F 23 CB 78 60 84 00 01 38 A0 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FA 48 82 37 00 38 38 90 00 01 1C 84 00 0C 7E 23 8B 78 4? ?? ?? ?? 7C 73 1B 79 41 82 03 70 92 77 00 38 7E 83 A3 78 4? ?? ?? ?? 7C 74 1B 79 41 82 03 5C 1E 10 00 0C 38 00 FF FF 7E 93 81 2E 7F B3 82 14 90 1D 00 04 3C A0 ?? ?? 7F 23 CB 78 7E A4 AB 78 38 A5 ?? ?? 38 C0 00 00 38 FF 00 10 4? ?? ?? ?? 2F 83 00 00 41 9E 01 E0 3C 80 ?? ?? 38 84 ?? ?? 4? ?? ?? ?? 7C 64 1B 79 41 82 01 CC 88 04 00 08 38 A0 00 00 38 84 00 08 2F 80 00 00 41 9E 00 4C 2F 80 00 20 41 9E 00 44 2F 80 00 09 41 9E 00 3C 2F 80 00 0A 41 9E 00 34 7C 89 23 78 48 00 00 10 41 82 00 28 41 86 00 24 41 9A 00 20 8C 09 00 01 38 A5 00 01 2F 80 00 00 2C 00 00 20 2C 80 00 09 2F 00 00 0A 40 9E FF DC 38 05 00 1F 81 21 00 00 54 00 00 36 7C 00 00 D0 7D 21 01 6E 3B 21 00 17 57 39 00 36 7F 23 CB 78 4? ?? ?? ?? 38 00 00 00 98 03 00 00 7E 89 A3 78 39 60 00 00 48 00 00 18 68 0A 00 2F 21 4A 00 00 7D 4B 01 94 39 29 00 01 7D 4B 53 78 88 09 00 00 2F 80 00 00 40 9E FF E4 7D 34 48 50 38 09 00 29 81 21 00 00 54 00 00 36 7C 00 00 D0 7D 21 01 6E 88 14 00 00 3A A1 00 17 56 B5 00 36 2F 80 00 00 7E A3 AB 78 41 9E 00 2C 3D 20 ?? ?? 81 49 ?? ?? 7E 89 A3 78 54 00 10 3A 7C 0A 00 2E 98 03 00 00 38 63 00 01 8C 09 00 01 2F 80 00 00 40 9E FF E8 2B 8B 00 01 40 9D 00 FC 38 00 00 00 98 03 00 00 7F 29 CB 78 39 60 00 00 48 00 00 18 68 0A 00 2F 21 4A 00 00 7D 4B 01 94 39 29 00 01 7D 4B 53 78 88 09 00 00 2F 80 00 00 40 9E FF E4 7D 39 48 50 38 09 00 21 81 21 00 00 54 00 00 36 7C 00 00 D0 7D 21 01 6E 88 19 00 00 38 81 00 17 54 84 00 36 2F 80 00 00 7C 89 23 78 41 9E 00 2C 3D 20 ?? ?? 81 49 ?? ?? 7C 89 23 78 54 00 10 3A 7C 0A 00 2E 98 09 00 00 39 29 00 01 8C 19 00 01 2F 80 00 00 40 9E FF E8 2B 8B 00 01 40 9D 00 98 38 00 00 00 98 09 00 00 7E A3 AB 78 38 BD 00 04 38 C0 00 01 4? ?? ?? ?? 2C 03 00 00 40 82 01 84 80 17 00 3C 39 20 00 00 91 3D 00 08 30 00 00 01 90 17 00 3C 4B FF FB 64 4? ?? ?? ?? 3A 83 00 01 7E 83 A3 78 4? ?? ?? ?? 7C 7D 1B 79 41 82 00 10 7E 64 9B 78 7E 85 A3 78 4? ?? ?? ?? 93 B8 00 0C 4B FF FA C0 2F 8B 00 00 38 00 00 2F 98 03 00 00 38 63 00 01 40 9E FE F8 98 03 00 00 3C 80 ?? ?? 38 84 ?? ?? 38 A0 00 08 38 63 00 01 4? ?? ?? ?? 4B FF FE DC 2F 8B 00 00 38 00 00 2F 98 09 00 00 39 29 00 01 40 BE FF 5C 98 09 00 00 39 29 00 01 4B FF FF 50 3F 00 ?? ?? 3B 18 ?? ?? 3B 38 00 10 39 60 00 01 7C 00 C8 28 7C 00 48 00 40 82 00 0C 7D 60 C9 2D 40 A2 FF F0 4C 00 01 2C 2F 80 00 00 41 BE 00 0C 7F 23 CB 78 4? ?? ?? ?? 80 1D 00 08 2F 80 00 00 41 9E 00 48 38 00 00 00 7C 00 04 AC 7D 20 C8 28 7C 00 C9 2D 40 A2 FF F8 2F 89 00 01 40 BD 00 24 80 82 8B 68 38 00 00 DD 7F 23 CB 78 60 84 00 01 38 A0 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 81 3D 00 08 4B FF F9 38 80 77 00 20 38 80 00 04 7C 76 1A 14 4? ?? ?? ?? 2F 83 00 00 90 7D 00 08 40 9E FA 88 38 00 FF FF 90 1D 00 08 4B FF FF 98 2F 98 00 00 3B 80 FF FF 41 BE F6 B4 38 77 00 40 4? ?? ?? ?? 4B FF F6 A8 80 82 8B 68 38 00 00 DD 7F 23 CB 78 60 84 00 01 38 A0 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FB F0 2F 83 FF FF 41 9E 00 24 2F 98 00 00 41 9E 00 0C 38 77 00 40 4? ?? ?? ?? 7E 83 A3 78 4? ?? ?? ?? 3B 80 00 00 4B FF F6 5C 90 7D 00 04 4B FF FE 54 7F 23 CB 78 4? ?? ?? ?? 4B FF FA 04 3B 80 FF FF 4B FF F6 40 }
	condition:
		$1
}

rule file_213_4_0 {
	meta:
		name = "__dcigettext"
		size = 2016
		refs = "008e __pthread_rwlock_rdlock 009e __libc_setlocale_lock 00dc __current_locale_name 00e4 strlen 0110 memcpy 0140 __tfind 0146 __pthread_rwlock_unlock 0176 _nl_msg_cat_cntr 018a _nl_domain_bindings 0192 _GLOBAL_OFFSET_TABLE_ 019e __libc_errno 01cc strcmp 024c __getcwd 026c __rawmemchr 0280 strcpy 0286 _nl_category_name_idxs 0296 _nl_category_names 02a4 getenv 02f2 __libc_enable_secure 031c stpcpy 0334 mempcpy 03c4 _nl_find_domain 03e0 _nl_find_msg 0524 strchr 05e6 _nl_default_dirname 068c malloc 06d6 __pthread_rwlock_wrlock 0734 __tsearch 077c free 078a _nl_current_default_domain"
	strings:
		$1 = { 94 21 FF 50 7D 80 00 26 7C 08 02 A6 93 C1 00 A8 7C 9E 23 79 93 E1 00 AC 7C 3F 0B 78 92 21 00 74 7D 11 43 78 93 61 00 9C 7C FB 3B 78 93 81 00 A0 7C DC 33 78 93 A1 00 A4 7C 7D 1B 78 90 01 00 B4 91 C1 00 68 91 E1 00 6C 92 01 00 70 92 41 00 78 92 61 00 7C 92 81 00 80 92 A1 00 84 92 C1 00 88 92 E1 00 8C 93 01 00 90 93 21 00 94 93 41 00 98 91 81 00 64 90 BF 00 3C 41 82 03 F8 2B 88 00 0C 41 9D 04 58 2F 88 00 06 41 9E 04 50 3F 40 ?? ?? 3B 5A ?? ?? 2F 9A 00 00 41 9E 07 38 3C 60 ?? ?? 38 63 ?? ?? 4? ?? ?? ?? 3D 20 ?? ?? 39 29 ?? ?? 38 69 00 1C 91 3F 00 38 4? ?? ?? ?? 2F 9D 00 00 41 9E 06 C8 38 00 00 00 93 DF 00 28 7E 23 8B 78 90 1F 00 1C 93 BF 00 0C 92 3F 00 10 4? ?? ?? ?? 7C 79 1B 78 4? ?? ?? ?? 38 03 00 1F 81 21 00 00 54 00 00 36 7C 00 00 D0 7D 21 01 6E 7C 65 1B 78 7F 24 CB 78 38 61 00 17 54 63 00 36 38 A5 00 01 4? ?? ?? ?? 2F 9A 00 00 90 7F 00 44 90 7F 00 14 41 9E 00 10 81 3F 00 38 38 69 00 3C 4? ?? ?? ?? 3D 60 ?? ?? 80 9F 00 38 80 AB ?? ?? 38 7F 00 0C 4? ?? ?? ?? 3D 20 ?? ?? 39 29 ?? ?? 90 7F 00 40 2F 89 00 00 41 9E 00 10 81 7F 00 38 38 6B 00 3C 4? ?? ?? ?? 81 3F 00 40 2D 89 00 00 41 8E 00 1C 81 29 00 00 3D 40 ?? ?? 80 0A ?? ?? 81 69 00 0C 7F 8B 00 00 41 9E 04 A8 3D 20 ?? ?? 83 09 ?? ?? 3D 60 ?? ?? 39 6B ?? ?? 2E 18 00 00 81 2B ?? ?? 7D 29 12 14 81 29 00 00 91 3F 00 4C 40 B2 00 18 48 00 04 34 41 9C 04 68 83 18 00 00 2E 18 00 00 41 92 04 24 38 98 00 0C 7F A3 EB 78 4? ?? ?? ?? 2F 83 00 00 40 9E FF E0 41 92 04 0C 82 F8 00 04 88 17 00 00 2F 80 00 2F 41 9E 00 9C 7E E3 BB 78 4? ?? ?? ?? 3D 20 ?? ?? 39 29 ?? ?? 83 29 ?? ?? 3A A3 00 01 3B 40 10 02 7F 39 12 14 3A C0 00 00 48 00 00 10 80 19 00 00 2F 80 00 22 40 9E 03 7C 7D 3A AA 14 38 09 00 1E 81 21 00 00 54 00 00 36 7C 00 00 D0 7D 21 01 6E 7F 44 D3 78 3A E1 00 17 92 D9 00 00 56 F7 00 36 7E E3 BB 78 4? ?? ?? ?? 57 49 F8 7E 2F 83 00 00 38 09 00 20 7F 5A 02 14 41 9E FF B4 38 80 00 00 7E E3 BB 78 4? ?? ?? ?? 38 00 2F 00 B0 03 00 00 38 63 00 01 80 98 00 04 4? ?? ?? ?? 3D 20 ?? ?? 39 29 ?? ?? 7F 29 88 AE 3C 60 ?? ?? 3D 20 ?? ?? 38 09 ?? ?? 38 63 ?? ?? 7F 39 02 14 4? ?? ?? ?? 7C 76 1B 79 41 82 00 10 88 16 00 00 2F 80 00 00 40 9E 03 38 7E 23 8B 78 4? ?? ?? ?? 7C 7A 1B 78 7F A3 EB 78 4? ?? ?? ?? 3E 40 ?? ?? 90 7F 00 48 7F 23 CB 78 4? ?? ?? ?? 7F 24 CB 78 81 7F 00 48 39 C0 00 00 81 21 00 00 3D E0 ?? ?? 7C 6B 1A 14 38 03 00 23 54 00 00 36 7C 00 00 D0 7D 21 01 6E 3A 52 ?? ?? 3A 00 00 43 3A 61 00 17 56 73 00 36 7E 63 9B 78 4? ?? ?? ?? 38 00 2F 00 B0 03 00 00 7F A4 EB 78 38 63 00 01 80 BF 00 48 4? ?? ?? ?? 3C 00 2E 6D 60 00 6F 00 90 03 00 00 7F 43 D3 78 4? ?? ?? ?? 81 21 00 00 38 03 00 1F 54 00 00 36 7C 00 00 D0 7D 21 01 6E 3B 21 00 17 57 39 00 36 88 1A 00 00 2F 80 00 3A 41 9E 01 CC 2F 80 00 00 7F 29 CB 78 40 9E 01 78 9A 19 00 00 98 19 00 01 88 19 00 00 2F 80 00 43 40 9E 00 10 88 19 00 01 2F 80 00 00 41 9E 01 FC 7F 23 CB 78 7E 44 93 78 4? ?? ?? ?? 2F 83 00 00 41 9E 01 E8 7E E3 BB 78 7F 24 CB 78 7E 65 9B 78 7F 06 C3 78 4? ?? ?? ?? 7C 74 1B 79 41 A2 FF 9C 7F 04 C3 78 7F C5 F3 78 38 C0 00 01 38 FF 00 08 4? ?? ?? ?? 2C 03 00 00 41 82 01 5C 2F 83 FF FF 41 9E 01 A8 41 82 FF 74 7C 60 1B 78 41 8E 02 68 81 7F 00 40 81 2B 00 00 3D 60 ?? ?? 81 6B ?? ?? 92 89 00 10 91 69 00 0C 81 7F 00 08 90 69 00 14 91 69 00 18 2F 9C 00 00 3D 60 ?? ?? 39 6B ?? ?? 81 2B ?? ?? 81 7F 00 4C 7D 29 12 14 91 69 00 00 40 9E 03 74 3D 20 ?? ?? 39 29 ?? ?? 2F 89 00 00 7C 1E 03 78 41 9E 00 1C 3C 60 ?? ?? 38 63 ?? ?? 4? ?? ?? ?? 81 7F 00 38 38 6B 00 1C 4? ?? ?? ?? 39 7F 00 B0 80 0B 00 04 7F C3 F3 78 81 8B FF B4 7C 08 03 A6 81 CB FF B8 81 EB FF BC 7D 81 81 20 82 0B FF C0 82 2B FF C4 82 4B FF C8 82 6B FF CC 82 8B FF D0 82 AB FF D4 82 CB FF D8 82 EB FF DC 83 0B FF E0 83 2B FF E4 83 4B FF E8 83 6B FF EC 83 8B FF F0 83 AB FF F4 83 CB FF F8 83 EB FF FC 7D 61 5B 78 4E 80 00 20 2F 9C 00 00 41 BE FF 94 2F 9B 00 01 41 BE FF 8C 83 DF 00 3C 4B FF FF 84 41 9A 00 1C 98 09 00 00 39 29 00 01 8C 1A 00 01 2F 80 00 00 2F 00 00 3A 40 9E FF E8 80 0F ?? ?? 99 C9 00 00 2F 80 00 00 41 BE FE 70 7F 23 CB 78 38 80 00 2F 4? ?? ?? ?? 2F 83 00 00 41 BE FE 5C 88 1A 00 00 2F 80 00 3A 40 9E FE 3C 3B 5A 00 01 4B FF FE 28 80 74 00 10 2F 83 00 00 41 BE FE 1C 3A B4 00 10 3A C0 00 00 48 00 00 14 84 75 00 04 3A D6 00 01 2F 83 00 00 41 BE FE 00 7F 04 C3 78 7F C5 F3 78 38 C0 00 01 38 FF 00 08 4? ?? ?? ?? 2C 03 00 00 41 82 FF D8 38 16 00 04 54 00 10 3A 7E 94 00 2E 4B FF FE 58 3D 20 ?? ?? 39 29 ?? ?? 2F 89 00 00 41 9E 00 1C 3C 60 ?? ?? 38 63 ?? ?? 4? ?? ?? ?? 81 7F 00 38 38 6B 00 1C 4? ?? ?? ?? 2F 9C 00 00 80 1F 00 4C 3D 60 ?? ?? 39 6B ?? ?? 81 2B ?? ?? 7D 29 12 14 90 09 00 00 40 9E FF 04 4B FF FE 90 3E E0 ?? ?? 3A F7 ?? ?? 4B FF FC 98 7E 23 8B 78 4? ?? ?? ?? 88 03 00 00 7C 7A 1B 78 2F 80 00 43 40 9E 00 10 88 1A 00 01 2F 80 00 00 41 9E FC B8 7E DA B3 78 4B FF FC B0 3E E0 ?? ?? 3B 00 00 00 3A F7 ?? ?? 4B FF FC 5C 2F 9C 00 00 40 9E 01 64 83 C9 00 14 3D 60 ?? ?? 39 6B ?? ?? 2F 8B 00 00 41 BE FE 2C 3C 60 ?? ?? 38 63 ?? ?? 4? ?? ?? ?? 81 3F 00 38 38 69 00 1C 4? ?? ?? ?? 4B FF FE 10 7F C3 F3 78 90 1F 00 50 4? ?? ?? ?? 3B 23 00 01 80 7F 00 44 4? ?? ?? ?? 81 7F 00 48 39 2B 00 1E 7C 69 1A 14 7C 63 CA 14 4? ?? ?? ?? 80 1F 00 50 7C 7A 1B 79 41 A2 FD 8C 7F C4 F3 78 7F 25 CB 78 38 7A 00 1C 4? ?? ?? ?? 81 3F 00 48 7F A4 EB 78 3B C9 00 01 7F C5 F3 78 7C 79 1B 78 7F C3 F2 14 4? ?? ?? ?? 80 9F 00 44 7F C3 F3 78 4? ?? ?? ?? 3D 20 ?? ?? 39 29 ?? ?? 80 1F 00 50 2F 89 00 00 93 3A 00 00 3D 20 ?? ?? 81 29 ?? ?? 92 3A 00 04 91 3A 00 0C 81 3F 00 08 93 DA 00 08 92 9A 00 10 90 1A 00 14 91 3A 00 18 41 9E 00 14 81 7F 00 38 38 6B 00 3C 4? ?? ?? ?? 80 1F 00 50 3D 20 ?? ?? 80 9F 00 38 80 A9 ?? ?? 7F 43 D3 78 90 1F 00 50 4? ?? ?? ?? 3D 60 ?? ?? 39 6B ?? ?? 80 1F 00 50 2F 8B 00 00 7C 7E 1B 78 41 9E 00 14 81 3F 00 38 38 69 00 3C 4? ?? ?? ?? 80 1F 00 50 2F 9E 00 00 41 9E 00 10 81 3E 00 00 7F 9A 48 00 41 9E FC B4 7F 43 D3 78 90 1F 00 50 4? ?? ?? ?? 80 1F 00 50 4B FF FC A0 3D 20 ?? ?? 83 A9 ?? ?? 4B FF F9 34 81 69 00 10 7F 64 DB 78 80 A9 00 14 80 6B 00 08 80 C9 00 18 4B FF EC 61 7C 7E 1B 78 4B FF FE 88 80 74 00 08 7C 05 03 78 80 DF 00 08 7F 64 DB 78 4B FF EC 45 7C 60 1B 78 4B FF FC 78 3D 20 ?? ?? 39 29 ?? ?? 91 3F 00 38 4B FF F8 E0 }
	condition:
		$1
}

rule file_213_5_0 {
	meta:
		name = "free_mem"
		size = 228
		refs = "000e _nl_domain_bindings 002a _nl_default_dirname 0048 free 006a _nl_current_default_domain 0072 _nl_default_default_domain 0098 __tdestroy"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 93 C1 00 18 3F C0 ?? ?? 93 E1 00 1C 83 FE ?? ?? 90 01 00 24 2F 9F 00 00 93 A1 00 14 41 9E 00 44 3F A0 ?? ?? 3B DE ?? ?? 3B BD ?? ?? 80 7F 00 04 80 1F 00 00 7F 83 E8 00 90 1E 00 00 41 9E 00 08 4? ?? ?? ?? 80 7F 00 08 4? ?? ?? ?? 7F E3 FB 78 4? ?? ?? ?? 83 FE 00 00 2F 9F 00 00 40 9E FF D0 3D 20 ?? ?? 80 69 ?? ?? 3D 20 ?? ?? 38 09 ?? ?? 7F 83 00 00 41 9E 00 08 4? ?? ?? ?? 3F C0 ?? ?? 80 7E ?? ?? 3C 80 ?? ?? 3B FE ?? ?? 38 84 ?? ?? 4? ?? ?? ?? 80 7F 00 04 38 00 00 00 2F 83 00 00 90 1E ?? ?? 41 9E 00 1C 83 C3 00 00 93 DF 00 04 4? ?? ?? ?? 2F 9E 00 00 7F C3 F3 78 40 9E FF EC 80 01 00 24 83 A1 00 14 7C 08 03 A6 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 }
	condition:
		$1
}

rule file_215_0_0 {
	meta:
		name = "__gconv"
		size = 640
		refs = "00d8 _dl_mcount_wrapper_check 025c __assert_fail"
	strings:
		$1 = { 7D 80 00 26 2F 83 FF FF 94 21 FF D0 7C 08 02 A6 93 21 00 14 7C D9 33 78 93 41 00 18 7D 1A 43 78 93 61 00 1C 7C BB 2B 78 93 A1 00 24 7C 9D 23 78 93 E1 00 2C 7C 7F 1B 78 90 01 00 34 92 E1 00 0C 93 01 00 10 93 81 00 20 93 C1 00 28 91 81 00 08 41 9E 01 A8 2F 88 00 00 83 03 00 00 41 9E 02 04 2E 06 00 00 38 00 00 00 90 08 00 00 41 92 01 84 80 06 00 00 81 3F 00 04 3B 18 FF FF 1E F8 00 24 81 69 00 00 83 C9 00 14 7D 3F BA 14 2F 8B 00 00 90 09 00 08 90 E9 00 0C 41 9E 00 0C 80 02 8F F4 7F DE 02 78 2F 9D 00 00 41 9E 00 D8 83 9D 00 00 2F 9C 00 00 41 9E 00 CC 41 92 01 88 80 19 00 00 3B 1F 00 08 2F 80 00 00 40 BE 00 0C 48 00 01 74 7C 1C 03 78 7F C3 F3 78 4? ?? ?? ?? 80 7F 00 04 7F 04 C3 78 7F C9 03 A6 7F A5 EB 78 7F 66 DB 78 38 E0 00 00 7F 48 D3 78 39 20 00 00 39 40 00 00 4E 80 04 21 2F 83 00 04 40 9E 00 24 80 1D 00 00 7F 9C 00 00 41 9E 00 18 81 3F 00 04 81 29 00 24 7D 20 4A 14 7F 9B 48 40 40 9C FF A8 80 19 00 00 2F 80 00 00 41 9E 00 10 7F FF BA 14 80 1F 00 08 90 19 00 00 80 01 00 34 81 81 00 08 7C 08 03 A6 82 E1 00 0C 83 01 00 10 7D 80 81 20 83 21 00 14 83 41 00 18 83 61 00 1C 83 81 00 20 83 A1 00 24 83 C1 00 28 83 E1 00 2C 38 21 00 30 4E 80 00 20 7F C3 F3 78 4? ?? ?? ?? 7D 3F BA 14 80 09 00 08 38 9F 00 08 80 7F 00 04 39 20 00 01 2F 80 00 00 41 9E 00 98 38 A0 00 00 7F C9 03 A6 38 C0 00 00 38 E0 00 00 7F 48 D3 78 39 40 00 00 4E 80 04 21 2C 03 00 00 40 82 00 24 7F EB FB 78 39 20 00 00 38 00 00 00 39 29 00 01 90 0B 00 14 7F 98 48 40 39 6B 00 24 40 9C FF F0 40 B2 FF 44 4B FF FF 58 38 00 00 00 4B FF FE 80 80 01 00 34 38 60 00 08 81 81 00 08 7C 08 03 A6 82 E1 00 0C 83 01 00 10 7D 80 81 20 83 21 00 14 83 41 00 18 83 61 00 1C 83 81 00 20 83 A1 00 24 83 C1 00 28 83 E1 00 2C 38 21 00 30 4E 80 00 20 39 20 00 02 4B FF FF 68 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 00 4B 38 C6 ?? ?? 4? ?? ?? ?? 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 00 2D 38 C6 ?? ?? 4? ?? ?? ?? }
	condition:
		$1
}

rule file_216_0_0 {
	meta:
		name = "_IO_getdelim"
		size = 872
		refs = "00e4 malloc 0128 realloc 014c memcpy 0164 __underflow 018c memchr 0296 _GLOBAL_OFFSET_TABLE_ 029e __libc_errno 033c _Unwind_Resume 0360 __lll_lock_wait_private"
	strings:
		$1 = { 94 21 FF D0 7D 80 00 26 7C 08 02 A6 93 81 00 20 7C 7C 1B 79 93 61 00 1C 7C BB 2B 78 93 A1 00 24 7C 9D 23 78 93 E1 00 2C 7C DF 33 78 90 01 00 34 93 01 00 10 93 21 00 14 93 41 00 18 93 C1 00 28 91 81 00 0C 41 82 02 50 2F 84 00 00 41 9E 02 48 80 06 00 00 70 0B 80 00 7C 09 03 78 40 82 00 58 80 66 00 48 3B C2 8B 60 81 23 00 08 7F 89 F0 00 41 9E 00 34 39 20 00 01 7C 00 18 28 7C 00 58 00 40 82 00 0C 7D 20 19 2D 40 A2 FF F0 4C 00 01 2C 2F 80 00 00 40 9E 02 CC 80 7F 00 48 80 1F 00 00 93 C3 00 08 81 63 00 04 7C 09 03 78 39 6B 00 01 91 63 00 04 70 0B 00 20 3B C0 FF FF 40 82 01 34 80 1C 00 00 2F 80 00 00 41 9E 00 10 80 1D 00 00 2F 80 00 00 40 9E 00 20 38 00 00 78 90 1D 00 00 38 60 00 78 4? ?? ?? ?? 2F 83 00 00 90 7C 00 00 41 9E 01 98 83 3F 00 04 83 5F 00 08 7F 59 D0 51 40 81 01 68 3B 00 00 00 48 00 00 78 55 29 08 3C 7F 80 48 40 7C 19 03 78 40 9C 00 08 7D 39 4B 78 80 7C 00 00 7F 24 CB 78 4? ?? ?? ?? 2C 03 00 00 41 82 01 58 90 7C 00 00 7F 45 D3 78 7C 63 C2 14 93 3D 00 00 83 3F 00 04 7F 24 CB 78 4? ?? ?? ?? 80 1F 00 04 7F 40 D2 14 93 5F 00 04 40 92 00 84 7F E3 FB 78 4? ?? ?? ?? 2F 83 FF FF 41 9E 00 74 83 3F 00 04 7F D8 F3 78 83 5F 00 08 7F 59 D0 50 7F 23 CB 78 7F 64 DB 78 7F 45 D3 78 4? ?? ?? ?? 2E 03 00 00 41 92 00 0C 7F 59 18 50 3B 5A 00 01 7F DA C2 14 2F 9E FF FF 41 9C 01 0C 81 3D 00 00 38 1E 00 01 7F 80 48 40 41 9D FF 54 80 7C 00 00 7F 45 D3 78 7F 24 CB 78 7C 63 C2 14 4? ?? ?? ?? 80 1F 00 04 7F 40 D2 14 93 5F 00 04 41 92 FF 84 81 3C 00 00 38 00 00 00 7C 09 F1 AE 81 3F 00 00 71 20 80 00 40 82 00 38 80 7F 00 48 81 23 00 04 38 09 FF FF 2F 80 00 00 90 03 00 04 40 9E 00 20 90 03 00 08 7C 00 04 AC 7D 20 18 28 7C 00 19 2D 40 A2 FF F8 2F 89 00 01 41 9D 01 18 80 01 00 34 7F C3 F3 78 81 81 00 0C 7C 08 03 A6 83 01 00 10 83 21 00 14 7D 80 81 20 83 41 00 18 83 61 00 1C 83 81 00 20 83 A1 00 24 83 C1 00 28 83 E1 00 2C 38 21 00 30 4E 80 00 20 7F E3 FB 78 4? ?? ?? ?? 2F 83 FF FF 41 9E 00 14 83 3F 00 04 83 5F 00 08 7F 59 D0 50 4B FF FE 80 81 3F 00 00 3B C0 FF FF 4B FF FF 60 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 38 00 00 16 90 09 00 00 3B C0 FF FF 4B FF FF 7C 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 38 00 00 4B 90 09 00 00 3B C0 FF FF 81 3F 00 00 4B FF FF 1C 80 1F 00 00 7C 7E 1B 78 70 09 80 00 40 82 00 54 80 7F 00 48 80 03 00 04 30 00 FF FF 2F 80 00 00 90 03 00 04 40 9E 00 3C 90 03 00 08 7C 00 04 AC 7D 20 18 28 7C 00 19 2D 40 A2 FF F8 2F 89 00 01 40 BD 00 20 80 82 8B 68 38 00 00 DD 38 A0 00 01 60 84 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 7F C3 F3 78 4? ?? ?? ?? 80 82 8B 68 38 00 00 DD 38 A0 00 01 60 84 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FE D0 4? ?? ?? ?? 4B FF FD 34 }
	condition:
		$1
}

rule file_217_0_0 {
	meta:
		name = "enter.8812"
		size = 212
	strings:
		$1 = { 38 04 FF FE 94 21 FF F0 7D 45 03 96 93 E1 00 0C 7D 25 23 96 7C 0A 01 D6 7D 29 21 D6 7D 40 28 50 38 0A 00 01 7D 29 28 50 54 1F 20 36 55 2A 20 36 7D 43 52 14 7D 20 4A 14 48 00 00 10 7D 4A FA 14 40 98 00 58 7D 89 63 78 81 8A 00 04 7F 09 20 40 2F 8C 00 00 7D 89 02 14 40 9E FF E4 80 0B 00 28 90 AA 00 00 70 09 00 02 90 CA 00 04 40 82 00 34 90 EA 00 08 3C 00 80 00 91 0A 00 0C 81 28 01 98 55 29 00 02 7F 89 00 00 41 9E 00 34 83 E1 00 0C 38 21 00 10 4E 80 00 20 7D 24 48 50 4B FF FF 90 81 2B 00 24 80 0B 00 00 83 E1 00 0C 38 21 00 10 91 2A 00 08 90 0A 00 0C 4E 80 00 20 80 08 02 0C 83 E1 00 0C 38 21 00 10 60 00 00 08 90 08 02 0C 4E 80 00 20 }
	condition:
		$1
}

rule file_217_1_0 {
	meta:
		name = "check_match.8764"
		size = 476
		refs = "00b4 strcmp 01b0 _dl_name_match_p 01d8 __assert_fail"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 90 01 00 24 81 23 00 04 93 E1 00 1C 7C 7F 1B 78 2F 89 00 00 93 81 00 10 93 A1 00 14 93 C1 00 18 88 03 00 0C 54 00 07 3E 41 9E 01 64 A1 3F 00 0E 81 4B 00 28 7D 29 00 34 55 29 D9 7E 7D 28 50 39 40 82 00 C0 39 20 04 67 7D 20 06 30 70 08 00 01 41 82 00 B0 80 0B 00 24 7F 9F 00 00 40 9E 00 80 83 CB 00 14 80 8B 00 18 2F 9E 00 00 81 24 01 A8 41 9E 00 C0 2F 89 00 00 41 9E 01 24 80 0B 00 10 81 64 01 74 54 00 08 3C 7F 89 02 2E 81 3E 00 04 57 80 23 76 7D 4B 02 14 83 AA 00 04 7F 9D 48 00 40 9E 00 68 7C 6B 00 2E 80 9E 00 00 4? ?? ?? ?? 2F 83 00 00 40 9E 00 54 80 01 00 24 7F E3 FB 78 83 81 00 10 7C 08 03 A6 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 80 6B 00 20 80 1F 00 00 80 8B 00 1C 7C 63 02 14 91 61 00 08 4? ?? ?? ?? 2F 83 00 00 81 61 00 08 41 9E FF 64 3B E0 00 00 4B FF FF B4 80 1E 00 08 2F 80 00 00 40 9E FF F0 2F 9D 00 00 40 9E FF E8 7F 80 07 34 7C 00 00 F8 7C 00 FE 70 7F FF 00 38 4B FF FF 8C 2F 89 00 00 41 BE FF 84 81 4B 00 0C 80 0B 00 10 71 48 00 02 54 00 08 3C 7C 09 02 2E 7D 40 00 26 55 4A 1F FE 54 09 04 7E 39 4A 00 02 7F 8A 48 00 41 9D FF 58 70 09 80 00 40 82 FF 98 81 2B 00 08 2F 89 00 00 39 29 00 01 91 2B 00 08 40 9E FF 84 93 EB 00 04 3B E0 00 00 4B FF FF 30 2F 80 00 06 41 9E FE 9C 3B E0 00 00 4B FF FF 20 80 7E 00 0C 2F 83 00 00 41 BE FF 14 4? ?? ?? ?? 2F 83 00 00 41 9E FF 08 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 00 A9 38 C6 ?? ?? 4? ?? ?? ?? }
	condition:
		$1
}

rule file_217_2_0 {
	meta:
		name = "do_lookup_x"
		size = 1808
		refs = "00a6 _dl_debug_mask 00aa _dl_dynamic_weak 00b6 _dl_argv 0272 __pthread_mutex_lock 028e _dl_ns 0320 strcmp 032e __pthread_mutex_unlock 03e8 _dl_name_match_p 0498 _dl_higher_prime_number 04a8 calloc 051a free 0598 _dl_debug_printf 06fc _dl_dprintf 0704 _exit"
	strings:
		$1 = { 94 21 FF 80 7C 08 02 A6 81 61 00 88 90 01 00 84 91 61 00 14 81 61 00 90 93 A1 00 74 7C 3D 0B 78 91 61 00 30 81 61 00 94 93 41 00 68 93 81 00 70 7C BC 2B 78 93 C1 00 78 7C FE 3B 78 93 E1 00 7C 7C 9F 23 78 92 01 00 40 92 21 00 44 92 41 00 48 92 61 00 4C 92 81 00 50 92 A1 00 54 92 C1 00 58 92 E1 00 5C 93 01 00 60 93 21 00 64 93 61 00 6C 80 08 00 04 83 41 00 8C 90 61 00 24 90 C1 00 2C 91 41 00 1C 95 7D 00 08 3B 09 FF FF 81 68 00 00 57 18 10 3A 3E 40 ?? ?? 54 95 D9 7E 7F 0B C2 14 3B 20 00 00 3E E0 ?? ?? 3E 80 ?? ?? 54 96 06 FE 3A 52 ?? ?? 3E 60 ?? ?? 85 78 00 04 93 21 00 10 81 6B 00 14 93 21 00 0C 7F 8B D0 00 91 61 00 20 41 9E 00 B8 81 41 00 30 71 47 00 02 40 82 01 10 81 4B 01 98 75 47 00 04 40 82 00 A0 81 57 ?? ?? 71 48 00 08 40 82 04 74 81 4B 01 7C 2F 8A 00 00 41 9E 00 88 81 0B 01 88 80 EB 00 34 2F 88 00 00 80 CB 00 38 80 E7 00 04 82 26 00 04 90 E1 00 28 41 9E 04 8C 80 CB 01 80 80 EB 01 84 7E A6 30 38 54 C6 10 3A 7D 08 30 2E 7F E7 3C 30 54 E7 06 FE 7D 07 3C 30 7D 08 B4 30 7C E8 40 38 71 07 00 01 40 82 02 B4 93 21 00 18 81 61 00 10 2F 8B 00 01 41 9E 00 A8 81 61 00 18 2F 8B 00 00 40 9E 00 1C 81 61 00 1C 2F 8B 00 00 41 9E 00 10 80 6B 00 0C 2F 83 00 00 40 9E 02 58 39 29 00 01 7F 80 48 40 41 9D FF 28 3B E0 00 00 80 01 00 84 7F E3 FB 78 82 01 00 40 7C 08 03 A6 82 21 00 44 82 41 00 48 82 61 00 4C 82 81 00 50 82 A1 00 54 82 C1 00 58 82 E1 00 5C 83 01 00 60 83 21 00 64 83 41 00 68 83 61 00 6C 83 81 00 70 83 A1 00 74 83 C1 00 78 83 E1 00 7C 38 21 00 80 4E 80 00 20 81 4B 01 98 75 48 C0 00 40 A2 FE F0 39 29 00 01 7F 80 48 40 41 9D FE B8 4B FF FF 90 83 61 00 0C 2F 9B 00 00 41 BE FF 54 89 7B 00 0C 55 6B E1 3E 2F 8B 00 02 41 9E 00 28 2F 8B 00 0A 41 9E 00 48 2F 8B 00 01 40 9E FF 34 80 01 00 20 3B E0 00 01 93 7E 00 00 90 1E 00 04 4B FF FF 54 81 74 ?? ?? 2F 8B 00 00 41 9E FF E4 81 7E 00 00 2F 8B 00 00 40 9E FF 08 81 61 00 20 93 7E 00 00 91 7E 00 04 4B FF FE F8 3D 20 ?? ?? 38 09 ?? ?? 81 21 00 20 2F 80 00 00 82 E9 00 18 41 9E 04 3C 1E F7 00 4C 3F 00 ?? ?? 38 77 00 10 3B 18 ?? ?? 7C 78 1A 14 4? ?? ?? ?? 7F 98 BA 14 83 5C 00 28 83 BC 00 2C 2F 9A 00 00 41 9E 02 80 38 1D FF FE 7E BF 03 96 7F 3F EB 96 7E B5 01 D6 7F 39 E9 D6 7E B5 F8 50 3A B5 00 01 7F 39 F8 50 56 B4 20 36 57 3C 20 36 7F 9A E2 14 7F 35 CA 14 48 00 00 24 82 DC 00 04 2F 96 00 00 41 9E 00 78 7F 99 E8 40 7F 9C A2 14 7C 19 AA 14 40 9C 00 60 7C 19 03 78 80 1C 00 00 7F 80 F8 00 40 9E FF D8 82 DC 00 04 80 81 00 24 7E C3 B3 78 4? ?? ?? ?? 2F 83 00 00 40 9E FF C4 3D 20 ?? ?? 38 09 ?? ?? 81 3C 00 08 2F 80 00 00 80 1C 00 0C 3B E0 00 01 91 3E 00 00 90 1E 00 04 41 BE FE 4C 38 77 00 10 7C 78 1A 14 4? ?? ?? ?? 4B FF FE 3C 7F 3D C8 50 4B FF FF 74 7D 38 BA 14 80 09 00 30 1D 3D 00 03 54 00 10 3A 7F 89 00 40 3A C1 00 08 40 9D 01 14 80 1B 00 00 7E CB B3 78 80 C1 00 28 7F 43 D3 78 81 01 00 20 7F A4 EB 78 7C C6 02 14 7F E5 FB 78 7F 67 DB 78 4B FF F9 A9 3D 20 ?? ?? 38 09 ?? ?? 2F 80 00 00 7D 38 BA 14 81 69 00 30 38 0B 00 01 90 09 00 30 41 BE FE 6C 38 77 00 10 7C 78 1A 14 4? ?? ?? ?? 4B FF FE 5C 80 81 00 20 90 01 00 3C 91 21 00 38 4? ?? ?? ?? 2F 83 00 00 80 01 00 3C 81 21 00 38 41 9E FD 90 3B E0 FF FF 4B FF FD 98 7C FF 53 96 81 0B 01 8C 7D 47 51 D6 7D 4A F8 50 55 4A 10 3A 7D 48 50 2E 2F 8A 00 00 41 BE FD 34 82 0B 01 90 55 4A 10 3A 7E 10 52 14 48 00 00 10 71 6A 00 01 40 A2 FD 1C 3A 10 00 04 81 70 00 00 7F EA 5A 78 55 48 F8 7F 40 82 FF E8 81 41 00 20 7F AB EB 78 81 4A 01 90 90 01 00 3C 7D 4A 80 50 7D 4A 16 70 91 21 00 38 55 43 20 36 7C 71 1A 14 91 41 00 18 4B FF F9 AD 7C 7B 1B 79 80 01 00 3C 81 21 00 38 40 A2 FD 8C 81 70 00 00 4B FF FF A4 38 7D 00 01 4? ?? ?? ?? 7C 64 1B 78 7C 75 1B 78 38 60 00 10 4? ?? ?? ?? 7C 74 1B 79 41 82 02 20 2F 9D 00 00 7F 5C D3 78 3B 20 00 00 41 9E 00 3C 80 DC 00 04 2F 86 00 00 41 9E 00 20 80 BC 00 00 7E CB B3 78 80 FC 00 08 7E 83 A3 78 81 1C 00 0C 7E A4 AB 78 4B FF F8 69 3B 39 00 01 7F 99 E8 00 3B 9C 00 10 40 9E FF CC 7F 98 BA 14 80 1C 00 34 7F 43 D3 78 7E BD AB 78 7C 09 03 A6 7E 9A A3 78 4E 80 04 21 3D 20 ?? ?? 38 09 ?? ?? 92 BC 00 2C 92 9C 00 28 90 1C 00 34 4B FF FE 58 38 60 00 10 38 80 00 1F 4? ?? ?? ?? 7C 7A 1B 79 41 82 01 90 38 00 00 1F 93 5C 00 28 3D 20 ?? ?? 90 1C 00 2C 38 09 ?? ?? 3B A0 00 1F 3A C1 00 08 90 1C 00 34 4B FF FE 20 80 AB 00 04 89 45 00 00 2F 8A 00 00 40 9E 00 0C 81 53 ?? ?? 80 AA 00 00 80 CB 00 18 7E 43 93 78 80 81 00 24 90 01 00 3C 91 21 00 38 4C C6 31 82 4? ?? ?? ?? 81 61 00 20 81 21 00 38 80 01 00 3C 4B FF FB 50 81 1C 00 00 2F 88 FF FF 41 9E 00 70 7C C8 53 96 80 EB 01 90 7D 66 51 D6 7D 6B 40 50 55 6B 10 3A 7C 67 58 2E 90 61 00 18 48 00 00 44 54 63 20 36 90 01 00 3C 7F AB EB 78 7C 71 1A 14 91 21 00 38 4B FF F8 39 7C 7B 1B 79 80 01 00 3C 81 21 00 38 40 A2 FC 18 81 61 00 20 80 61 00 18 81 6B 01 8C 54 63 10 3A 7C 6B 18 2E 90 61 00 18 2F 83 00 00 40 9E FF BC 4B FF FB 38 80 E1 00 24 39 00 00 00 88 C7 00 00 2F 86 00 00 41 9E 00 D4 88 A7 00 01 7C C8 33 78 2F 85 00 00 41 9E 00 C4 88 87 00 02 54 C8 20 36 7D 05 42 14 2F 84 00 00 38 C7 00 02 41 9E 00 AC 88 A6 00 01 55 08 20 36 7D 08 22 14 2F 85 00 00 38 C6 00 01 41 9E 00 94 88 C6 00 01 55 08 20 36 7D 08 2A 14 2F 86 00 00 41 9E 00 80 55 08 20 36 7D 08 32 14 38 E7 00 04 8C C7 00 01 2F 86 00 00 41 9E 00 68 55 08 20 36 7C C8 32 14 54 C5 00 06 7C A8 32 78 54 A5 46 3E 7D 08 2A 78 4B FF FF DC 3F 00 ?? ?? 1E F7 00 4C 3B 18 ?? ?? 4B FF FB D4 3D 20 ?? ?? 38 09 ?? ?? 2F 80 00 00 41 9E 00 10 38 77 00 10 7C 78 1A 14 4? ?? ?? ?? 3C 80 ?? ?? 38 60 00 02 38 84 ?? ?? 4C C6 31 82 4? ?? ?? ?? 38 60 00 7F 4? ?? ?? ?? 91 1C 00 00 4B FF FE AC }
	condition:
		$1
}

rule file_217_3_0 {
	meta:
		name = "_dl_lookup_symbol_x"
		size = 2672
		refs = "018e _dl_debug_mask 02f2 _dl_argv 0374 strlen 03b0 stpcpy 03d4 _dl_signal_cerror 0404 __assert_fail 04c4 _dl_debug_printf 04dc _dl_debug_printf_c 0722 __pthread_mutex_lock 0732 _dl_load_lock 0742 _dl_ns 082a __pthread_mutex_unlock 08cc _dl_lookup_symbol_x 0994 malloc 09bc memcpy 09e8 _dl_scope_free"
	strings:
		$1 = { 94 21 FF 60 7C 08 02 A6 7D 80 00 26 92 C1 00 78 7C D6 33 78 92 E1 00 7C 3A E0 15 05 93 01 00 80 7D 18 43 78 93 21 00 84 7C 99 23 78 93 41 00 88 7D 3A 4B 78 93 61 00 8C 7D 5B 53 78 93 81 00 90 7C FC 3B 78 93 A1 00 94 7C 7D 1B 78 93 C1 00 98 7C BE 2B 78 93 E1 00 9C 7C 3F 0B 78 90 01 00 A4 91 E1 00 5C 92 01 00 60 92 21 00 64 92 41 00 68 92 61 00 6C 92 81 00 70 92 A1 00 74 91 81 00 58 88 03 00 00 2F 80 00 00 41 9E 00 1C 7C 69 1B 78 1E F7 00 21 7E E0 BA 14 8C 09 00 01 2F 80 00 00 40 9E FF F0 2E 1C 00 00 38 00 00 00 39 20 FF FF 90 1F 00 1C 91 3F 00 18 90 1F 00 20 41 92 00 10 38 00 FF FA 7F 49 00 39 40 82 03 64 2D 9B 00 00 40 8E 03 38 81 16 00 00 3A A0 00 00 2F 88 00 00 7E D4 B3 78 7E A9 AB 78 40 BE 00 1C 48 00 04 38 40 82 01 DC 85 14 00 04 2F 88 00 00 41 9E 00 3C 39 20 00 00 80 DE 00 00 7F A3 EB 78 7E E4 BB 78 93 41 00 08 38 BF 00 18 38 FF 00 1C 93 61 00 0C 7F 8A E3 78 93 01 00 10 93 21 00 14 4B FF F7 C5 2C 03 00 00 40 81 FF BC 80 1F 00 1C 2F 80 00 00 41 9E 03 E4 81 3E 00 00 2F 89 00 00 41 9E 00 14 88 09 00 0D 54 00 07 BE 2F 80 00 03 41 9E 00 AC 82 FF 00 20 3A A0 00 00 81 37 01 98 3C 00 80 00 7E EF BB 78 55 29 00 02 7F 89 00 00 41 9E 04 F0 80 0F 02 04 2F 80 00 00 41 9E 03 60 3D 20 ?? ?? 80 09 ?? ?? 70 09 04 04 40 82 02 B4 80 1F 00 1C 90 1E 00 00 39 7F 00 A0 80 0B 00 04 7D E3 7B 78 81 8B FF B8 7C 08 03 A6 81 EB FF BC 82 0B FF C0 7D 81 81 20 82 2B FF C4 82 4B FF C8 82 6B FF CC 82 8B FF D0 82 AB FF D4 82 CB FF D8 82 EB FF DC 83 0B FF E0 83 2B FF E4 83 4B FF E8 83 6B FF EC 83 8B FF F0 83 AB FF F4 83 CB FF F8 83 EB FF FC 7D 61 5B 78 4E 80 00 20 2F 98 00 01 41 9E 00 9C 38 00 00 00 90 1F 00 24 7E D4 B3 78 3A 60 00 01 90 1F 00 28 3A 40 00 00 48 00 00 44 80 DE 00 00 7F A3 EB 78 7E E4 BB 78 93 41 00 08 38 BF 00 18 38 FF 00 24 93 61 00 0C 7E A9 AB 78 7F 8A E3 78 92 61 00 10 92 41 00 14 4B FF F6 99 2F 83 00 00 40 9E 00 18 3A 94 00 04 3A A0 00 00 81 14 00 00 2F 88 00 00 40 9E FF B8 80 1F 00 24 2F 80 00 00 41 9E 04 44 80 1F 00 28 7F 80 C8 00 41 9E 03 D4 80 1E 00 00 3A A0 00 01 93 3F 00 20 7F 37 CB 78 90 1F 00 1C 4B FF FE C4 82 FF 00 20 3A A0 00 01 7F 97 C8 00 41 BE FE B4 91 3F 00 1C 7F 15 C3 78 7F 37 CB 78 93 3F 00 20 4B FF FE A0 40 8E FE 28 41 92 01 18 2F 99 00 00 3B 60 00 00 41 9E 00 08 83 79 00 04 88 1B 00 00 2F 80 00 00 40 9E 00 20 3D 20 ?? ?? 81 29 ?? ?? 83 69 00 00 2F 9B 00 00 40 BE 00 0C 3F 60 ?? ?? 3B 7B ?? ?? 2F 83 FF FE 81 7C 00 00 81 3C 00 0C 41 9E 02 00 3D 40 ?? ?? 38 0A ?? ?? 3D 40 ?? ?? 91 7F 00 38 39 4A ?? ?? 91 5F 00 2C 3D 60 ?? ?? 3D 40 ?? ?? 91 3F 00 40 3D 20 ?? ?? 39 4A ?? ?? 39 6B ?? ?? 91 5F 00 34 39 29 ?? ?? 91 7F 00 3C 3B 40 00 00 3B 9F 00 2C 91 3F 00 44 90 1F 00 48 93 BF 00 30 3B A0 00 01 7C 7C D0 2E 4? ?? ?? ?? 2F 9A 00 1C 7F BD 1A 14 3B 5A 00 04 40 9E FF EC 38 1D 00 1E 81 21 00 00 54 00 00 36 7C 00 00 D0 7D 21 01 6E 3B 40 00 00 3B A1 00 27 57 BD 00 36 7F A3 EB 78 7C 9C D0 2E 4? ?? ?? ?? 2F 9A 00 1C 3B 5A 00 04 40 9E FF F0 3C A0 ?? ?? 38 60 00 00 7F 64 DB 78 38 A5 ?? ?? 7F A6 EB 78 4? ?? ?? ?? 38 00 00 00 90 1E 00 00 39 E0 00 00 4B FF FD C0 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 02 EB 38 C6 ?? ?? 4? ?? ?? ?? 81 16 00 00 3A A0 00 00 81 28 00 00 56 A0 10 3A 7C 09 00 2E 7F 80 D8 00 41 BE FC BC 3A B5 00 01 4B FF FF EC 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 02 D5 38 C6 ?? ?? 4? ?? ?? ?? 70 09 00 04 80 99 00 04 41 A2 FD 48 88 04 00 00 2F 80 00 00 40 9E 00 20 3D 20 ?? ?? 81 29 ?? ?? 80 89 00 00 2F 84 00 00 40 BE 00 0C 3C 80 ?? ?? 38 84 ?? ?? 80 CF 00 04 80 B9 00 18 88 06 00 00 2F 80 00 00 40 9E 00 10 3D 20 ?? ?? 81 29 ?? ?? 80 C9 00 00 2F 95 00 00 80 EF 00 18 41 9E 00 64 3D 00 ?? ?? 39 08 ?? ?? 3C 60 ?? ?? 38 63 ?? ?? 7F A9 EB 78 4C C6 31 82 4? ?? ?? ?? 41 92 00 2C 80 9C 00 00 3C 60 ?? ?? 38 63 ?? ?? 4C C6 31 82 4? ?? ?? ?? 81 FF 00 20 4B FF FC B8 38 00 00 01 90 0F 02 04 4B FF FC 9C 3C 60 ?? ?? 38 63 ?? ?? 4C C6 31 82 4? ?? ?? ?? 81 FF 00 20 4B FF FC 94 3D 00 ?? ?? 39 08 ?? ?? 4B FF FF A0 3D 40 ?? ?? 38 0A ?? ?? 4B FF FE 04 81 3E 00 00 2F 89 00 00 41 9E 00 14 88 09 00 0C 54 00 E1 3E 2F 80 00 02 41 9E 00 08 41 8E 00 14 38 00 00 00 90 1E 00 00 39 E0 00 00 4B FF FC 54 2F 99 00 00 41 9E 00 FC 83 79 00 04 41 92 00 E4 80 1C 00 00 2F 80 00 00 41 9E 00 C4 3D 20 ?? ?? 39 29 ?? ?? 89 7B 00 00 2F 8B 00 00 40 9E 00 20 3D 60 ?? ?? 81 6B ?? ?? 83 6B 00 00 2F 9B 00 00 40 BE 00 0C 3F 60 ?? ?? 3B 7B ?? ?? 3D 60 ?? ?? 91 3F 00 34 39 6B ?? ?? 91 7F 00 2C 3B 40 00 00 3B 9F 00 2C 90 1F 00 38 93 BF 00 30 3B A0 00 01 7C 7C D0 2E 4? ?? ?? ?? 2F 9A 00 0C 7F BD 1A 14 3B 5A 00 04 40 9E FF EC 38 1D 00 1E 81 21 00 00 54 00 00 36 7C 00 00 D0 7D 21 01 6E 3B 40 00 00 3B A1 00 27 57 BD 00 36 7F A3 EB 78 7C 9C D0 2E 4? ?? ?? ?? 2F 9A 00 0C 3B 5A 00 04 40 9E FF F0 3C A0 ?? ?? 38 60 00 00 7F 64 DB 78 38 A5 ?? ?? 7F A6 EB 78 4? ?? ?? ?? 4B FF FF 18 3D 20 ?? ?? 3D 60 ?? ?? 39 29 ?? ?? 38 0B ?? ?? 4B FF FF 38 3D 20 ?? ?? 39 29 ?? ?? 7D 20 4B 78 4B FF FF 28 3F 60 ?? ?? 3B 7B ?? ?? 4B FF FF 04 82 FF 00 20 3A A0 00 01 4B FF FB 00 73 40 00 01 41 82 FB 10 7F 99 B8 00 41 9E 00 44 80 17 02 0C 70 09 00 08 40 82 00 38 82 79 01 FC 7C 00 04 AC 82 59 01 F8 2F 92 00 00 7E 49 93 78 41 9E 00 34 80 09 00 00 2F 80 00 00 41 9E 00 28 7F 97 00 00 39 29 00 04 40 9E FF EC 82 FF 00 20 7E EF BB 78 4B FF FA C0 3A A0 00 01 82 FF 00 20 4B FF FA 9C 2F 93 00 00 41 9E 00 34 82 93 00 00 39 20 00 00 38 14 00 01 7C 09 03 A6 42 40 00 24 55 2B 10 3A 7D 73 5A 14 80 0B 00 04 7F 97 00 00 41 BE FF BC 39 29 00 01 4B FF FF E4 3A 80 00 00 57 49 F7 FE 82 37 02 50 2D 89 00 00 82 17 02 54 40 8E 00 4C 3D 20 ?? ?? 38 09 ?? ?? 2F 80 00 00 41 9E 00 10 3C 60 ?? ?? 38 63 ?? ?? 4? ?? ?? ?? 80 19 00 18 3D 20 ?? ?? 39 29 ?? ?? 1C 00 00 4C 7D 29 00 2E 2F 89 00 00 41 9E 00 D0 7F 89 78 00 41 9E 00 BC 81 29 00 0C 4B FF FF EC 39 22 8B 60 39 62 8B 64 38 00 00 00 7C 00 04 AC 7D 40 58 28 7C 00 59 2D 40 A2 FF F8 2F 8A 00 02 40 BE 00 24 80 89 00 08 38 00 00 DD 7D 63 5B 78 60 84 00 01 38 A0 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 3D 20 ?? ?? 38 09 ?? ?? 2F 80 00 00 41 9E 00 10 3C 60 ?? ?? 38 63 ?? ?? 4? ?? ?? ?? 81 39 01 F8 7E EF BB 78 7F 92 48 00 41 9E 02 1C 2F 89 00 00 41 9E 02 14 80 09 00 00 2F 80 00 00 41 9E 02 08 7F 8F 00 00 39 29 00 04 40 9E FF EC 80 0F 02 50 7F 80 88 00 40 BE 00 24 80 0F 02 54 3A E0 00 00 7F 80 80 00 40 BE 00 14 48 00 00 14 80 0F 02 50 7F 80 88 00 41 9E 00 44 3A E0 FF FF 3D 20 ?? ?? 38 09 ?? ?? 2F 80 00 00 41 9E 00 10 3C 60 ?? ?? 38 63 ?? ?? 4? ?? ?? ?? 41 AE 00 10 38 00 00 01 90 02 8B 64 7C 00 06 AC 2F 97 FF FF 41 9E 00 4C 81 FF 00 20 4B FF F9 20 80 0F 02 54 7F 80 80 00 40 9E FF B8 82 4F 02 0C 3A E0 00 00 72 49 00 08 40 A2 FF AC 81 39 01 98 3C 00 80 00 55 29 00 02 7F 89 00 00 41 9E 00 48 62 52 00 08 92 4F 02 0C 3A E0 00 00 4B FF FF 88 41 8E 00 08 82 D9 01 D0 7F A3 EB 78 7F 24 CB 78 7F C5 F3 78 7E C6 B3 78 7F 87 E3 78 7F 08 C3 78 7F 49 D3 78 7F 6A DB 78 4? ?? ?? ?? 7C 6F 1B 78 4B FF F8 D0 80 19 02 0C 70 09 00 08 40 A2 FF B4 80 19 02 00 7F 80 A0 40 40 9D 00 90 81 39 01 FC 56 80 10 3A 7D 29 02 14 91 E9 00 04 7C 00 06 AC 81 39 01 FC 3A 94 00 01 92 89 00 00 3D 20 ?? ?? 80 09 ?? ?? 3A E0 00 00 70 09 00 40 41 82 FF 08 80 8F 00 04 88 04 00 00 2F 80 00 00 40 9E 00 10 3D 20 ?? ?? 81 29 ?? ?? 80 89 00 00 80 D9 00 04 80 AF 00 18 88 06 00 00 2F 80 00 00 40 9E 00 10 3D 20 ?? ?? 81 29 ?? ?? 80 C9 00 00 80 F9 00 18 3C 60 ?? ?? 38 63 ?? ?? 4C C6 31 82 4? ?? ?? ?? 3A E0 00 00 4B FF FE B0 2F 80 00 00 3A 60 00 0A 41 9E 00 08 54 13 08 3C 38 73 00 01 54 63 10 3A 4? ?? ?? ?? 7C 77 1B 79 41 A2 FE F8 2F 94 00 00 56 92 10 3A 41 BE 00 18 80 99 01 FC 38 77 00 04 7E 45 93 78 38 84 00 04 4? ?? ?? ?? 7E 57 92 14 3A 94 00 01 91 F2 00 04 92 97 00 00 7C 00 06 AC 80 79 01 FC 92 79 02 00 2F 83 00 00 92 F9 01 FC 41 BE FF 2C 4? ?? ?? ?? 4B FF FF 24 81 39 01 FC 2F 89 00 00 41 BE FD 44 7F 93 48 00 41 9E 00 34 82 89 00 00 39 60 00 00 38 14 00 01 7C 09 03 A6 42 40 FD 28 55 6A 10 3A 7D 49 52 14 80 0A 00 04 7F 8F 00 00 41 BE FD D0 39 6B 00 01 4B FF FF E4 80 13 00 00 7F 80 A0 40 40 BD FD 00 7C 14 00 50 39 34 FF FF 7C 09 03 A6 55 29 10 3A 7D 33 4A 14 39 29 00 04 84 09 00 04 7F 8F 00 00 41 BE FD 98 3A 94 00 01 42 00 FF F0 4B FF FC D0 }
	condition:
		$1
}

rule file_217_4_0 {
	meta:
		name = "_dl_setup_hash"
		size = 208
		refs = "00cc __assert_fail"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 81 23 01 50 2F 89 00 00 41 9E 00 6C 81 69 00 04 81 0B 00 00 39 4B 00 08 91 03 01 7C 81 2B 00 08 80 EB 00 04 39 69 FF FF 7D 60 48 39 40 82 00 78 38 0A 00 08 91 63 01 80 55 29 10 3A 7D 20 4A 14 81 6A 00 04 55 08 10 3A 90 03 01 88 7D 09 42 14 54 EA 10 3A 91 63 01 84 7D 0A 40 50 91 23 01 8C 91 03 01 90 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 81 23 00 30 2F 89 00 00 41 BE FF E8 81 69 00 04 81 2B 00 00 38 0B 00 08 90 03 01 90 55 2B 10 3A 7D 60 5A 14 91 23 01 7C 91 63 01 8C 4B FF FF C4 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 03 6A 38 C6 ?? ?? 4? ?? ?? ?? }
	condition:
		$1
}

rule file_218_0_0 {
	meta:
		name = "capset"
		size = 16
		refs = "000c __syscall_error"
	strings:
		$1 = { 38 00 00 B8 44 00 00 02 4C A3 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_220_0_0 {
	meta:
		name = "__strftime_internal"
		size = 7152
		refs = "0230 memset 03c4 memcpy 051c strlen 07da __tzname 12c4 mktime 13b8 _nl_get_alt_digit 18e0 _nl_get_era_entry 1a50 __tzset"
	strings:
		$1 = { 94 21 FF 50 7C 08 02 A6 7D 80 00 26 90 01 00 B4 92 A1 00 84 82 A6 00 08 92 21 00 74 2F 95 00 0C 92 41 00 78 7C F2 3B 78 92 61 00 7C 92 C1 00 88 7C D6 33 78 93 41 00 98 7C 9A 23 78 93 61 00 9C 7D 1B 43 78 91 C1 00 68 91 E1 00 6C 92 01 00 70 92 81 00 80 92 E1 00 8C 93 01 00 90 93 21 00 94 93 81 00 A0 93 A1 00 A4 93 C1 00 A8 93 E1 00 AC 91 81 00 64 82 68 00 08 82 26 00 28 40 9D 02 D0 3A B5 FF F4 88 05 00 00 2F 80 00 00 41 9E 15 3C 3E 80 ?? ?? 3D E0 88 88 3E 00 92 49 3F 00 CC CC 7C BF 2B 78 7C 7E 1B 78 3B 80 00 00 3A 94 ?? ?? 61 EF 88 89 62 10 24 93 63 18 CC CD 3D C0 ?? ?? 2F 80 00 25 41 9E 00 4C 7D 3C D0 50 2B 89 00 01 40 9D 01 D8 2C 1E 00 00 41 82 00 0C 98 1E 00 00 3B DE 00 01 3B 9C 00 01 8C 1F 00 01 2F 80 00 00 40 9E FF D0 2F 9E 00 00 41 9E 01 B4 2F 9A 00 00 41 9E 01 AC 38 00 00 00 98 1E 00 00 48 00 01 A0 39 00 00 00 3A E0 00 00 3B 20 00 00 8D 5F 00 01 55 49 06 3E 2F 89 00 30 41 9E 01 68 2B 89 00 30 41 9D 01 50 2F 89 00 23 41 9E 01 60 2F 89 00 2D 41 9E 01 50 38 09 FF D0 2B 80 00 09 3B A0 FF FF 41 9D 00 60 3D 60 0C CC 3B A0 00 00 61 6B CC CC 48 00 00 2C 41 9E 01 AC 55 4A 06 3E 1F BD 00 0A 3B BD FF D0 7F BD 52 14 8D 5F 00 01 55 49 06 3E 38 09 FF D0 2B 80 00 09 41 9D 00 28 7F 9D 58 00 40 BD FF D4 3F A0 7F FF 63 BD FF FF 8D 5F 00 01 55 49 06 3E 38 09 FF D0 2B 80 00 09 40 9D FF E0 2F 89 00 45 41 9E 01 88 2F 89 00 4F 38 00 00 00 41 9E 01 7C 2B 89 00 7A 40 9D 01 60 2F 89 00 25 40 9E 01 8C 7F EB FB 78 39 20 00 01 7F A9 E8 50 7F A0 E8 F8 7C 00 FE 70 7F A0 00 38 7D 5C D0 50 7C 00 4A 14 7F 80 50 40 2F 1D 00 00 40 9C 00 AC 2C 1E 00 00 41 82 00 74 40 99 00 38 2F 99 00 30 41 9E 01 70 7F C3 F3 78 90 01 00 5C 38 80 00 20 7F A5 EB 78 91 21 00 58 7F DE EA 14 91 61 00 50 4? ?? ?? ?? 81 61 00 50 81 21 00 58 80 01 00 5C 2F 97 00 00 41 9E 01 6C 2F 89 00 00 41 9E 00 28 7D 29 03 A6 39 49 FF FF 7D 0B 50 AE 80 FB 00 3C 55 08 10 3A 7D 07 40 2E 7D 1E 51 AE 39 4A FF FF 42 00 FF E8 7F DE 4A 14 7F 9C 02 14 4B FF FE 6C 2F 89 00 5E 41 9E 00 1C 2F 89 00 5F 40 9E FE B8 7D 39 4B 78 4B FF FE 88 39 00 00 01 4B FF FE 80 3A E0 00 01 4B FF FE 78 3B 80 00 00 80 01 00 B4 7F 83 E3 78 81 81 00 64 7C 08 03 A6 81 C1 00 68 81 E1 00 6C 7D 80 81 20 82 01 00 70 82 21 00 74 82 41 00 78 82 61 00 7C 82 81 00 80 82 A1 00 84 82 C1 00 88 82 E1 00 8C 83 01 00 90 83 21 00 94 83 41 00 98 83 61 00 9C 83 81 00 A0 83 A1 00 A4 83 C1 00 A8 83 E1 00 AC 38 21 00 B0 4E 80 00 20 55 4A 06 3E 2F 8A 00 37 40 BD FE 54 3F A0 7F FF 63 BD FF FF 4B FF FE 78 55 2B 10 3A 7D 74 58 2E 7D 6B A2 14 7D 69 03 A6 4E 80 04 20 8D 5F 00 01 7D 20 4B 78 55 49 06 3E 4B FF FE 7C 2F 95 00 00 40 BE FD 34 3A A0 00 0C 4B FF FD 2C 7F EA FB 78 39 20 00 01 39 4A FF FF 88 0A 00 00 39 29 00 01 7D 4B 53 78 2F 80 00 25 40 9E FF EC 4B FF FE 60 7F C3 F3 78 90 01 00 5C 38 80 00 30 7F A5 EB 78 91 21 00 58 7F DE EA 14 91 61 00 50 4? ?? ?? ?? 80 01 00 5C 81 21 00 58 81 61 00 50 4B FF FE 94 7F C3 F3 78 7D 64 5B 78 7D 25 4B 78 90 01 00 5C 91 21 00 58 4? ?? ?? ?? 81 21 00 58 80 01 00 5C 7F DE 4A 14 4B FF FE A4 3D 00 ?? ?? 39 08 ?? ?? 91 01 00 48 80 A1 00 48 38 60 00 00 38 80 FF FF 7E C6 B3 78 7E 47 93 78 7F 68 DB 78 4B FF FC 05 7D 7C D0 50 7F A3 E8 51 7C 60 1B 78 7F A9 E8 F8 7D 29 FE 70 7F A9 48 38 7D 29 1A 14 7F 89 58 40 40 BC FE 88 2F 9E 00 00 39 40 00 00 41 9E 00 74 40 81 11 24 2F 99 00 30 7F C3 F3 78 38 80 00 30 41 9E 00 0C 7F C3 F3 78 38 80 00 20 7F A5 EB 78 90 01 00 5C 7F BE EA 14 91 21 00 58 91 61 00 50 4? ?? ?? ?? 80 01 00 5C 81 21 00 58 81 61 00 50 80 A1 00 48 7F A3 EB 78 7D 64 5B 78 90 01 00 5C 7E C6 B3 78 7E 47 93 78 91 21 00 58 7F 68 DB 78 4B FF FB 71 80 01 00 5C 81 21 00 58 7D 5D 02 14 2F 97 00 00 7F 9C 4A 14 41 9E 00 30 7F 8A F0 40 40 9D 00 28 39 3E FF FF 7F DE 50 50 7F C9 03 A6 8C 09 00 01 81 7B 00 3C 54 00 10 3A 7C 0B 00 2E 98 09 00 00 42 00 FF EC 7D 5E 53 78 4B FF FC 0C 38 00 00 00 90 01 00 48 2F 88 00 00 41 9E 00 10 39 00 00 01 91 01 00 48 3A E0 00 00 81 76 00 08 2E 0B 00 0B 7D 20 00 26 55 29 97 FE 39 29 00 2E 55 29 10 3A 7D 33 4A 14 80 69 00 04 4? ?? ?? ?? 7D 7C D0 50 7F A3 E8 50 7F A0 E8 F8 7C 00 FE 70 7F A0 00 38 7C 00 1A 14 7F 80 58 40 7C 69 1B 78 2F 1D 00 00 40 BC FD 64 2C 1E 00 00 41 A2 FD 2C 40 99 00 38 2F 99 00 30 41 9E 10 E0 7F C3 F3 78 90 01 00 5C 38 80 00 20 7F A5 EB 78 91 21 00 58 4? ?? ?? ?? 7F DE EA 14 81 76 00 08 81 21 00 58 2E 0B 00 0B 80 01 00 5C 81 61 00 48 2F 8B 00 00 41 9E 0F D4 40 91 10 40 39 60 00 27 2F 89 00 00 39 6B 00 08 55 6B 10 3A 7D 73 5A 14 80 EB 00 04 41 BE FC C4 7D 29 03 A6 39 69 FF FF 7D 47 58 AE 81 1B 00 38 55 4A 10 3A 7D 48 50 2E 7D 5E 59 AE 39 6B FF FF 42 00 FF E8 7F DE 4A 14 4B FF FC 9C 38 00 00 01 90 01 00 48 4B FF FF 00 39 0E ?? ?? 91 01 00 48 4B FF FD F0 8D 3F FF FF 4B FF FB D0 2F 80 00 45 41 BE FD 58 2F 9D 00 02 7F AA EB 78 41 9C 12 B4 81 76 00 1C 81 36 00 18 39 6B 00 07 7D 29 58 50 7D 09 80 96 7D 2B FE 70 7D 28 4A 14 7D 28 16 70 7D 0B 40 50 2F 80 00 4F 7D 00 43 78 41 9E 0D 5C 55 09 0F FF 41 82 00 08 7C 08 00 D0 39 61 00 14 7D 69 5B 78 7D 00 C0 16 55 08 E8 FE 2F 88 00 00 1C E8 00 0A 7C E7 00 50 7D 00 43 78 39 07 00 30 9D 09 FF FF 40 9E FF E0 41 82 00 0C 38 00 00 2D 9C 09 FF FF 2F 99 00 2D 41 9E 00 68 7C 0B 50 50 7C 00 4A 14 2F 80 00 00 40 9D 00 58 2F 99 00 5F 41 9E 0E 5C 7D 1C D0 50 7F 8A 40 40 40 BC FB F8 40 82 0D FC 2C 1E 00 00 41 82 00 30 7F C3 F3 78 90 01 00 5C 7C 05 03 78 38 80 00 30 91 21 00 58 91 61 00 50 4? ?? ?? ?? 80 01 00 5C 81 61 00 50 81 21 00 58 7F DE 02 14 7F 9C 02 14 3B A0 00 00 7D 69 58 50 7F AB E8 50 7F A0 E8 F8 7C 00 FE 70 7F A0 00 38 7D 5C D0 50 7C 00 5A 14 7F 80 50 40 2F 1D 00 00 40 BC FB 90 2C 1E 00 00 41 A2 FB 58 40 99 00 38 2F 99 00 30 41 9E 0D A4 7F C3 F3 78 90 01 00 5C 38 80 00 20 7F A5 EB 78 91 21 00 58 7F DE EA 14 91 61 00 50 4? ?? ?? ?? 81 61 00 50 81 21 00 58 80 01 00 5C 2F 97 00 00 41 9E 0D 28 2F 8B 00 00 41 9E 00 28 7D 69 03 A6 80 FB 00 3C 39 4B FF FF 7D 09 50 AE 55 08 10 3A 7D 07 40 2E 7D 1E 51 AE 39 4A FF FF 42 00 FF EC 7F DE 5A 14 7F 9C 02 14 4B FF F9 50 2F 88 00 00 40 9E 0E 18 38 00 00 00 90 01 00 48 2F 91 00 00 41 9E 00 10 88 11 00 00 2F 00 00 00 40 9A 00 34 80 16 00 20 2F 00 00 00 41 98 00 24 89 32 00 00 2F 89 00 00 41 9E 12 7C 3D 20 ?? ?? 54 00 10 3A 39 29 ?? ?? 7E 29 00 2E 2F 91 00 00 41 9E 10 CC 7E 23 8B 78 4? ?? ?? ?? 7D 7C D0 50 7F A3 E8 50 7F A0 E8 F8 7C 00 FE 70 7F A0 00 38 7C 00 1A 14 7F 80 58 40 7C 69 1B 78 2F 1D 00 00 40 BC FA 8C 2C 1E 00 00 41 A2 FA 54 40 99 00 30 2F 99 00 30 41 9E 10 1C 7F C3 F3 78 90 01 00 5C 38 80 00 20 7F A5 EB 78 91 21 00 58 4? ?? ?? ?? 7F DE EA 14 81 21 00 58 80 01 00 5C 81 01 00 48 2F 88 00 00 41 9E 0D 9C 2F 89 00 00 41 BE FA 0C 7D 29 03 A6 39 69 FF FF 7D 51 58 AE 81 1B 00 38 55 4A 10 3A 7D 48 50 2E 7D 5E 59 AE 39 6B FF FF 42 00 FF E8 7F DE 4A 14 4B FF F9 E4 2F 80 00 45 41 9E 11 68 2F 80 00 4F 41 BE FA B8 2F 9D 00 00 7F AA EB 78 40 9D 11 80 81 16 00 14 39 08 07 6C 7D 00 43 78 4B FF FD 84 2F 80 00 4F 41 BE FA 94 2F 80 00 45 41 9E 0E 18 81 13 00 CC 91 01 00 48 4B FF FB 08 2F 80 00 45 41 BE FA 78 2F 9D 00 02 7F AA EB 78 41 9C 11 0C 81 36 00 18 81 76 00 1C 39 29 00 06 7C E9 80 96 7D 28 FE 70 7C E7 4A 14 7C E7 16 70 7D 08 38 50 1D 08 00 07 39 6B 00 07 7D 28 48 50 4B FF FD 00 2F 80 00 45 41 BE FA 34 2F 9D 00 02 7F AA EB 78 41 9C 0A 24 7E A8 AB 78 2F 99 00 30 41 BE FC F8 2F 99 00 2D 41 BE FC F0 3B 20 00 5F 4B FF FC E8 2F 80 00 45 41 BE FA 04 2F 9D 00 02 7F AA EB 78 41 9C 09 DC 81 16 00 08 4B FF FF D0 3B BD FF FF 7F B7 E8 F8 7E F7 FE 70 7F B7 B8 38 7C 1C D0 50 3A F7 00 01 7F 97 00 40 2F 1D 00 00 40 BC F9 18 2C 1E 00 00 41 82 00 30 40 99 00 20 2F 99 00 30 41 9E 0E D0 7F C3 F3 78 38 80 00 20 7F A5 EB 78 4? ?? ?? ?? 7F DE EA 14 38 00 00 0A 98 1E 00 00 3B DE 00 01 7F 9C BA 14 4B FF F7 1C 2F 80 00 4F 41 BE F9 88 2F 80 00 45 41 9E 0C EC 81 73 00 C4 91 61 00 48 4B FF F9 FC 2F 88 00 00 41 9E 00 08 3A E0 00 01 2F 80 00 00 40 BE F9 60 81 76 00 10 39 2B 00 0E 55 29 04 3E 39 29 00 08 55 29 10 3A 7D 33 4A 14 80 69 00 04 91 61 00 50 4? ?? ?? ?? 7D 5C D0 50 7F A3 E8 50 81 61 00 50 7F A0 E8 F8 7C 00 FE 70 7F A0 00 38 7C 00 1A 14 7F 80 50 40 7C 69 1B 78 2F 1D 00 00 40 BC F8 5C 2C 1E 00 00 41 A2 F8 24 40 99 00 34 2F 99 00 30 41 9E 10 DC 7F C3 F3 78 90 01 00 5C 38 80 00 20 7F A5 EB 78 91 21 00 58 4? ?? ?? ?? 7F DE EA 14 81 76 00 10 81 21 00 58 80 01 00 5C 2F 97 00 00 41 9E 0F A8 39 6B 00 0E 2F 89 00 00 55 6B 04 3E 39 6B 00 08 55 6B 10 3A 7D 73 5A 14 80 EB 00 04 41 BE F7 C4 7D 29 03 A6 39 69 FF FF 7D 47 58 AE 81 1B 00 3C 55 4A 10 3A 7D 48 50 2E 7D 5E 59 AE 39 6B FF FF 42 00 FF E8 7F DE 4A 14 4B FF F7 9C 2F 80 00 00 40 BE F8 78 3D 60 ?? ?? 39 6B ?? ?? 91 61 00 48 4B FF F8 F0 2F 80 00 45 41 BE F8 60 2F 9D 00 02 7F AA EB 78 41 9C 08 70 81 16 00 0C 4B FF FE 2C 2F 80 00 45 41 BE F8 44 2F 9D 00 02 7F AA EB 78 41 9C 08 28 81 16 00 00 4B FF FB 0C 2F 80 00 00 40 BE F8 28 2F 88 00 00 41 9E 00 08 3A E0 00 01 81 76 00 18 55 69 04 3E 39 29 00 08 55 29 10 3A 7D 33 4A 14 80 69 00 04 91 61 00 50 4? ?? ?? ?? 7D 5C D0 50 7F A3 E8 50 81 61 00 50 7F A0 E8 F8 7C 00 FE 70 7F A0 00 38 7C 00 1A 14 7F 80 50 40 7C 69 1B 78 2F 1D 00 00 40 BC F7 1C 2C 1E 00 00 41 A2 F6 E4 40 99 00 34 2F 99 00 30 41 9E 0F 44 7F C3 F3 78 90 01 00 5C 38 80 00 20 7F A5 EB 78 91 21 00 58 4? ?? ?? ?? 7F DE EA 14 81 76 00 18 81 21 00 58 80 01 00 5C 2F 97 00 00 41 9E 0A 9C 2F 89 00 00 55 6B 04 3E 39 6B 00 08 55 6B 10 3A 7D 73 5A 14 80 EB 00 04 41 BE F6 88 7D 29 03 A6 39 69 FF FF 7D 47 58 AE 81 1B 00 3C 55 4A 10 3A 7D 48 50 2E 7D 5E 59 AE 39 6B FF FF 42 00 FF E8 7F DE 4A 14 4B FF F6 60 2F 80 00 45 41 9E 0C B4 2F 9D 00 00 81 36 00 14 7F AA EB 78 39 29 07 6C 40 9D 0B F0 3D 00 51 EB 61 08 85 1F 7D 09 40 96 7D 2B FE 70 7D 08 2E 70 7D 6B 40 50 1D 0B 00 64 7D 28 48 50 55 28 0F FE 7D 08 58 50 4B FF F9 D8 2F 80 00 45 41 BE F6 F4 2F 9D 00 03 7F AA EB 78 40 9C 00 08 39 40 00 03 81 16 00 1C 39 08 00 01 4B FF F9 B4 2F 80 00 45 41 BE F6 D0 2F 9D 00 02 7F AA EB 78 41 9C 0C 34 81 16 00 10 39 08 00 01 4B FF F9 94 2F 80 00 45 41 BE F6 B0 81 56 00 1C 80 F6 00 18 39 6A 01 7E 80 B6 00 14 7D 67 58 50 7C CB 80 96 7D 68 FE 70 7C C6 5A 14 7C C6 16 70 7C C8 30 50 1C C6 00 07 39 0A 00 03 7D 66 58 50 7C CB 40 51 39 05 07 6C 41 80 0A B0 71 0B 00 03 39 60 00 00 40 82 00 44 3C 80 51 EB 60 84 85 1F 7C 88 20 96 7D 05 FE 70 7C 8B 2E 70 7D 65 58 50 1D 6B 00 64 7F 88 58 00 39 60 00 01 40 9E 00 1C 7C 8B 3E 70 7D 65 58 50 1D 6B 01 90 7D 0B 5A 78 7D 6B 00 34 55 6B D9 7E 39 4A FE 93 7D 4B 50 50 21 67 01 7E 7D 6B 52 14 7C AB 80 96 7D 67 FE 70 7C A5 5A 14 7C A5 16 70 7C E7 28 50 1C E7 00 07 39 4A 00 03 7D 67 58 50 7D 6B 50 51 41 80 00 0C 39 08 00 01 7D 66 5B 78 2F 89 00 47 41 9E 09 24 2F 89 00 67 41 9E 08 EC 2F 9D 00 02 7F AA EB 78 41 9C 0D DC 7D 06 80 96 7C C9 FE 70 7D 08 32 14 7D 08 16 70 7D 09 40 50 39 08 00 01 4B FF F8 88 81 13 00 D0 91 01 00 48 88 08 00 00 2F 80 00 00 40 BE F6 20 3D 20 ?? ?? 39 29 ?? ?? 91 21 00 48 4B FF F6 10 2F 80 00 00 40 BE F5 80 3D 60 ?? ?? 39 6B ?? ?? 91 61 00 48 4B FF F5 F8 2F 80 00 45 41 BE F5 68 2F 9D 00 02 7F AA EB 78 41 9C 05 34 7E A8 AB 78 4B FF F8 30 2F 80 00 45 41 BE F5 4C 2F 9D 00 02 7F AA EB 78 41 9C 05 68 81 16 00 0C 4B FF F8 14 2F 80 00 45 41 BE F5 30 2F 9D 00 02 7F AA EB 78 41 9C 05 28 81 16 00 08 4B FF F7 F8 2F 80 00 45 41 BE F5 14 2F 9D 00 02 7F AA EB 78 41 9C 05 18 81 16 00 04 4B FF F7 DC 2F 80 00 45 41 BE F4 F8 2F 9D 00 00 7F AA EB 78 40 9D 05 20 81 16 00 18 4B FF F7 C0 2F 9D 00 00 7F AA EB 78 40 9D 08 5C 81 36 00 18 39 29 00 06 7D 09 80 96 7D 2B FE 70 7D 08 4A 14 7D 08 16 70 7D 6B 40 50 1D 6B 00 07 7D 2B 48 50 39 09 00 01 4B FF F7 88 3B BD FF FF 7F B7 E8 F8 7E F7 FE 70 7F B7 B8 38 7C 1C D0 50 3A F7 00 01 7F 97 00 40 2F 1D 00 00 40 BC F3 D4 2C 1E 00 00 41 A2 FA EC 40 99 00 20 2F 99 00 30 41 9E 09 4C 7F C3 F3 78 38 80 00 20 7F A5 EB 78 4? ?? ?? ?? 7F DE EA 14 38 00 00 09 98 1E 00 00 7F 9C BA 14 3B DE 00 01 4B FF F1 D8 81 36 00 20 2F 89 00 00 41 BC F1 CC 81 36 00 24 2F 89 00 00 41 9C 07 F0 39 7D FF FF 7D 6A 58 F8 7D 4A FE 70 7D 6A 50 38 7D 1C D0 50 39 4A 00 01 7F 8A 40 40 2F 0B 00 00 40 BC F3 5C 2C 1E 00 00 41 82 00 50 40 99 00 40 2F 99 00 30 41 9E 0B 04 7F C3 F3 78 90 01 00 5C 7D 65 5B 78 38 80 00 20 91 21 00 58 91 41 00 54 91 61 00 50 4? ?? ?? ?? 81 61 00 50 81 41 00 54 81 21 00 58 7F DE 5A 14 80 01 00 5C 39 60 00 2B 99 7E 00 00 3B DE 00 01 7F 9C 52 14 7D 69 78 96 2F 9D 00 04 7D 6B 4A 14 7D 6B 2E 70 7D 29 FE 70 7D 29 58 50 7F AA EB 78 40 9C 00 08 39 40 00 04 7D 09 78 96 7D 2B FE 70 7D 08 4A 14 7D 08 2E 70 7D 6B 40 50 1D 0B 00 3C 1D 6B 00 64 7D 28 48 50 7D 0B 4A 14 4B FF F6 48 2F 80 00 00 40 BE F3 64 2F 88 00 00 }
	condition:
		$1
}

rule file_220_1_0 {
	meta:
		name = "__strftime_l"
		size = 52
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 7C E8 3B 78 90 01 00 24 7C 29 0B 78 38 00 00 00 9C 09 00 08 7D 27 4B 78 4B FF E3 F1 80 01 00 24 38 21 00 20 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_221_0_0 {
	meta:
		name = "__atomic_preadv64_replacement"
		size = 512
		refs = "00c8 __libc_pread64 0110 memcpy 0128 free 0172 _GLOBAL_OFFSET_TABLE_ 017a __libc_errno 01b0 __libc_alloca_cutoff 01e0 malloc"
	strings:
		$1 = { 7D 80 00 26 2E 05 00 00 94 21 FF C0 7C 08 02 A6 93 41 00 28 7C 7A 1B 78 93 81 00 30 7C BC 2B 78 93 C1 00 38 7C 9E 23 78 93 E1 00 3C 7C 3F 0B 78 90 01 00 44 92 E1 00 1C 93 01 00 20 93 21 00 24 93 61 00 2C 93 A1 00 34 91 81 00 18 40 91 01 4C 80 04 00 04 3C C0 7F FF 60 C6 FF FF 7F 80 30 40 41 9D 01 10 39 20 00 00 7F 89 03 A6 38 A0 00 00 48 00 00 10 80 0B 00 04 7F 8A 00 40 41 9C 00 F4 39 29 00 01 7C A5 02 14 55 20 18 38 7D 45 30 50 7D 7E 02 14 42 00 FF E0 2B 85 80 00 41 9D 01 04 38 05 00 1E 81 21 00 00 54 00 00 36 7C 00 00 D0 7D 21 01 6E 3B 60 00 00 3B A1 00 17 57 BD 00 36 7F 43 D3 78 7F A4 EB 78 4? ?? ?? ?? 7C 77 1B 79 41 80 00 C0 40 91 00 50 7E F9 BB 78 3B 00 00 00 48 00 00 08 41 9E 00 40 80 1E 00 04 3B 18 00 01 7F A4 EB 78 7F 99 00 40 7F 3A CB 78 40 9D 00 08 7C 1A 03 78 80 7E 00 00 7F 45 D3 78 7F BD D2 14 4? ?? ?? ?? 7F 3A C8 51 7F 98 E0 00 3B DE 00 08 40 82 FF C4 7F 63 DB 78 4? ?? ?? ?? 39 7F 00 40 80 0B 00 04 7E E3 BB 78 81 8B FF D8 7C 08 03 A6 82 EB FF DC 83 0B FF E0 7D 80 81 20 83 2B FF E4 83 4B FF E8 83 6B FF EC 83 8B FF F0 83 AB FF F4 83 CB FF F8 83 EB FF FC 7D 61 5B 78 4E 80 00 20 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 38 00 00 16 90 09 00 00 3A E0 FF FF 4B FF FF A0 3A E0 FF FF 4B FF FF 90 38 A0 00 00 4B FF FF 04 7C A3 2B 78 90 BF 00 08 90 FF 00 0C 91 1F 00 10 4? ?? ?? ?? 2F 83 00 00 80 BF 00 08 80 FF 00 0C 81 1F 00 10 40 9E FE DC 7C A3 2B 78 90 BF 00 08 3B 60 00 00 90 FF 00 0C 3A E0 FF FF 91 1F 00 10 4? ?? ?? ?? 7C 7D 1B 79 80 BF 00 08 80 FF 00 0C 81 1F 00 10 41 A2 FF 30 7F BB EB 78 4B FF FE C4 }
	condition:
		$1
}

rule file_221_1_0 {
	meta:
		name = "preadv64"
		size = 364
		refs = "0096 _GLOBAL_OFFSET_TABLE_ 009e __libc_errno 00f0 __libc_enable_asynccancel 0128 __libc_disable_asynccancel"
	strings:
		$1 = { 94 21 FF D0 7C 08 02 A6 93 61 00 1C 7C 7B 1B 78 93 81 00 20 7C 9C 23 78 93 A1 00 24 7C BD 2B 78 93 C1 00 28 7C FE 3B 78 93 E1 00 2C 7D 1F 43 78 90 01 00 34 93 21 00 14 93 41 00 18 80 02 8B 60 2F 80 00 00 40 9E 00 AC 38 00 01 40 7D 06 43 78 44 00 00 02 7C 00 00 26 74 09 10 00 40 82 00 D8 2F 83 00 00 41 9C 00 30 80 01 00 34 83 21 00 14 7C 08 03 A6 83 41 00 18 83 61 00 1C 83 81 00 20 83 A1 00 24 83 C1 00 28 83 E1 00 2C 38 21 00 30 4E 80 00 20 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 80 09 00 00 2F 80 00 26 40 9E FF BC 80 01 00 34 7F 63 DB 78 7F 84 E3 78 83 21 00 14 7C 08 03 A6 7F A5 EB 78 7F C7 F3 78 83 41 00 18 7F E8 FB 78 83 61 00 1C 83 81 00 20 83 A1 00 24 83 C1 00 28 83 E1 00 2C 38 21 00 30 4B FF FD 14 4? ?? ?? ?? 38 00 01 40 7C 7A 1B 78 7F 84 E3 78 7F 63 DB 78 7F A5 EB 78 7F E6 FB 78 7F C7 F3 78 44 00 00 02 7C 00 00 26 74 09 10 00 7C 79 1B 78 40 82 00 30 7F 43 D3 78 4? ?? ?? ?? 7F 23 CB 78 4B FF FF 30 3D 20 ?? ?? 39 29 ?? ?? 81 69 ?? ?? 7D 6B 12 14 90 6B 00 00 38 60 FF FF 4B FF FF 50 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 90 69 00 00 3B 20 FF FF 4B FF FF BC }
	condition:
		$1
}

rule file_222_0_0 {
	meta:
		name = "__wcsncpy"
		size = 208
	strings:
		$1 = { 2B 85 00 03 39 23 FF FC 40 9D 00 60 54 A0 F0 BE 7C 09 03 A6 80 04 00 00 39 69 00 04 39 09 00 08 2F 80 00 00 90 09 00 04 39 49 00 0C 41 9E 00 78 80 04 00 04 2F 80 00 00 90 09 00 08 41 9E 00 84 80 04 00 08 2F 80 00 00 90 09 00 0C 41 9E 00 7C 80 04 00 0C 38 84 00 10 2F 80 00 00 94 09 00 10 41 9E 00 48 42 00 FF B0 70 A5 00 03 4D 82 00 20 7C A9 03 A6 38 84 FF FC 84 04 00 04 38 A5 FF FF 2F 80 00 00 94 09 00 04 42 40 00 18 40 9E FF EC 7C A9 03 A6 38 00 00 00 94 09 00 04 42 00 FF FC 4E 80 00 20 7D 69 5B 78 7C 03 48 50 38 A5 FF FF 7C 00 16 70 7C A0 28 51 40 82 FF D8 4E 80 00 20 7D 09 43 78 4B FF FF E4 7D 49 53 78 4B FF FF DC }
	condition:
		$1
}

rule file_223_0_0 {
	meta:
		name = "__wcschrnul"
		size = 48
	strings:
		$1 = { 80 03 00 00 2F 80 00 00 4D 9E 00 20 7F 80 20 00 40 BE 00 0C 4E 80 00 20 4D 9A 00 20 84 03 00 04 2F 80 00 00 7F 00 20 00 40 9E FF F0 4E 80 00 20 }
	condition:
		$1
}

rule file_224_0_0 {
	meta:
		name = "timerfd_create"
		size = 16
		refs = "000c __syscall_error"
	strings:
		$1 = { 38 00 01 32 44 00 00 02 4C A3 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_226_0_0 {
	meta:
		name = "lrand48_r"
		size = 60
		refs = "0020 __nrand48_r"
	strings:
		$1 = { 7C 08 02 A6 94 21 FF F0 7C 85 23 78 90 01 00 14 7C 60 1B 79 39 20 FF FF 41 82 00 10 7C 04 03 78 4? ?? ?? ?? 7C 69 1B 78 80 01 00 14 7D 23 4B 78 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_1006_0_0 {
	meta:
		name = "mrand48_r"
		size = 60
		refs = "0020 __jrand48_r"
	strings:
		$1 = { 7C 08 02 A6 94 21 FF F0 7C 85 23 78 90 01 00 14 7C 60 1B 79 39 20 FF FF 41 82 00 10 7C 04 03 78 4? ?? ?? ?? 7C 69 1B 78 80 01 00 14 7D 23 4B 78 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_227_0_0 {
	meta:
		name = "getw"
		size = 64
		refs = "001c _IO_fread"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 7C 66 1B 78 38 80 00 04 90 01 00 24 38 61 00 08 38 A0 00 01 4? ?? ?? ?? 2F 83 00 01 38 60 FF FF 40 BE 00 08 80 61 00 08 80 01 00 24 38 21 00 20 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_228_0_0 {
	meta:
		name = "__dcgettext"
		size = 48
		refs = "001c __dcigettext"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 7C A8 2B 78 38 C0 00 00 90 01 00 14 38 A0 00 00 38 E0 00 00 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_229_0_0 {
	meta:
		name = "tcsendbreak"
		size = 112
		refs = "0038 __ioctl"
	strings:
		$1 = { 2C 04 00 00 94 21 FF F0 7C 08 02 A6 90 01 00 14 40 81 00 3C 3C A0 51 EB 38 04 00 63 60 A5 85 1F 7C A0 28 96 7C 00 FE 70 7C A5 2E 70 7C A0 28 50 38 80 54 25 4C C6 31 82 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 3C 80 20 00 60 84 74 1D 38 A0 00 00 4C C6 31 82 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_232_0_0 {
	meta:
		name = "_IO_mem_sync"
		size = 124
		refs = "0068 _IO_str_overflow"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 81 23 00 14 80 03 00 18 93 E1 00 0C 7C 7F 1B 78 7F 89 00 00 41 9E 00 44 38 00 00 00 98 09 00 00 81 7F 00 A8 38 60 00 00 80 1F 00 10 81 3F 00 AC 90 0B 00 00 81 7F 00 14 80 1F 00 10 83 E1 00 0C 7C 00 58 50 90 09 00 00 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 38 80 00 00 4? ?? ?? ?? 81 3F 00 14 38 09 FF FF 90 1F 00 14 4B FF FF B4 }
	condition:
		$1
}

rule file_232_1_0 {
	meta:
		name = "_IO_mem_finish"
		size = 152
		refs = "002c realloc 007c _IO_str_finish"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 93 E1 00 0C 7C 7F 1B 78 80 9F 00 14 80 63 00 10 38 84 00 01 93 C1 00 08 7C 83 20 50 83 DF 00 A8 4? ?? ?? ?? 81 3F 00 A8 90 7E 00 00 81 29 00 00 2F 89 00 00 41 9E 00 34 81 7F 00 14 80 1F 00 10 7C 00 58 50 39 60 00 00 7D 69 01 AE 81 7F 00 14 80 1F 00 10 81 3F 00 AC 7C 00 58 50 90 09 00 00 38 00 00 00 90 1F 00 1C 7F E3 FB 78 38 80 00 00 4? ?? ?? ?? 80 01 00 14 83 C1 00 08 7C 08 03 A6 83 E1 00 0C 38 21 00 10 4E 80 00 20 }
	condition:
		$1
}

rule file_232_2_0 {
	meta:
		name = "open_memstream"
		size = 260
		refs = "0030 malloc 0074 calloc 0088 _IO_init 00a8 _IO_str_init_static_internal 00c6 free"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 93 A1 00 14 7C 7D 1B 78 38 60 01 78 93 81 00 10 93 C1 00 18 7C 9E 23 78 93 E1 00 1C 3B E0 00 00 90 01 00 24 93 61 00 0C 4? ?? ?? ?? 7C 7C 1B 79 40 82 00 2C 80 01 00 24 7F E3 FB 78 83 61 00 0C 7C 08 03 A6 83 81 00 10 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 38 1C 00 B0 90 1C 00 48 38 60 00 01 38 80 20 00 4? ?? ?? ?? 7C 7B 1B 79 41 A2 FF C0 7F 83 E3 78 38 80 00 00 4? ?? ?? ?? 3D 20 ?? ?? 38 09 ?? ?? 90 1C 00 98 7F 83 E3 78 7F 64 DB 78 7F 66 DB 78 38 A0 20 00 4? ?? ?? ?? 80 1C 00 00 3D 20 ?? ?? 93 BC 00 A8 54 00 00 3C 90 1C 00 00 38 09 ?? ?? 3D 20 ?? ?? 90 1C 00 A0 38 09 ?? ?? 7F 9F E3 78 90 1C 00 A4 7F E3 FB 78 80 01 00 24 93 DC 00 AC 7C 08 03 A6 83 61 00 0C 83 81 00 10 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 }
	condition:
		$1
}

rule file_233_0_0 {
	meta:
		name = "__getrusage"
		size = 16
		refs = "000c __syscall_error"
	strings:
		$1 = { 38 00 00 4D 44 00 00 02 4C A3 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_234_0_0 {
	meta:
		name = "profil_count"
		size = 332
	strings:
		$1 = { 3D 40 ?? ?? 39 6A ?? ?? 81 2B 00 08 80 09 00 10 7F 83 00 40 41 9C 00 14 80 09 00 14 7D 28 4B 78 7F 83 00 40 41 9C 00 5C 81 0A ?? ?? 38 00 00 00 80 CB 00 04 39 08 FF FF 48 00 00 1C 80 E9 00 14 38 0A 00 01 7F 83 38 40 41 9C 00 E0 7F 80 40 40 41 9D 00 2C 7D 40 42 14 55 4A F8 7E 1D 2A 00 18 7D 26 4A 14 80 E9 00 10 7F 83 38 40 40 BC FF D0 39 0A FF FF 7F 80 40 40 40 9D FF DC 81 0B 00 0C 80 E8 00 00 31 44 FF FF 7D 4A 51 10 80 08 00 08 55 4A 00 3C 80 C9 00 04 7C 67 18 50 39 4A 00 04 7D 43 53 96 7C EA 00 16 7D 0A 01 D6 54 EA 80 1E 55 00 84 3E 7D 40 03 78 7F 06 00 40 2F 84 00 00 40 99 00 28 41 9E 00 40 81 29 00 0C 54 00 10 3A 7D 69 00 2E 2F 8B FF FF 4D 9E 00 20 39 6B 00 01 7D 69 01 2E 4E 80 00 20 40 9E 00 4C 81 2B 00 0C 81 29 00 0C A1 69 00 00 38 0B 00 01 B0 09 00 00 4E 80 00 20 81 29 00 0C 54 00 08 3C 7D 69 02 2E 6D 6A FF FF 2F 8A FF FF 4D 9E 00 20 39 6B 00 01 7D 69 03 2E 4E 80 00 20 91 2B 00 08 81 0B 00 0C 4B FF FF 50 81 2B 00 0C 81 29 00 0C 81 69 00 00 38 0B 00 01 90 09 00 00 4E 80 00 20 }
	condition:
		$1
}

rule file_234_1_0 {
	meta:
		name = "profil_counter_ushort"
		size = 44
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 81 24 00 1C 38 80 00 00 80 69 00 80 4B FF FE 9D 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_234_2_0 {
	meta:
		name = "profil_counter_uint"
		size = 44
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 81 24 00 1C 38 80 00 01 80 69 00 80 4B FF FE 71 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_234_3_0 {
	meta:
		name = "pcmp"
		size = 48
	strings:
		$1 = { 81 23 00 00 38 60 00 01 81 64 00 00 81 29 00 08 80 0B 00 08 7F 89 00 40 4D BC 00 20 41 9D 00 0C 38 60 00 00 4E 80 00 20 38 60 FF FF 4E 80 00 20 }
	condition:
		$1
}

rule file_234_4_0 {
	meta:
		name = "insert"
		size = 376
		refs = "0084 malloc 0130 realloc 0168 memmove"
	strings:
		$1 = { 7F 84 28 40 94 21 FF D0 7C 08 02 A6 93 A1 00 24 7C 7D 1B 78 38 60 00 00 93 C1 00 28 7C 9E 23 78 93 E1 00 2C 7C BF 2B 78 90 01 00 34 93 41 00 18 93 61 00 1C 93 81 00 20 41 9C 00 2C 80 01 00 34 83 41 00 18 7C 08 03 A6 83 61 00 1C 83 81 00 20 83 A1 00 24 83 C1 00 28 83 E1 00 2C 38 21 00 30 4E 80 00 20 3F 80 ?? ?? 80 9C ?? ?? 3B 5C ?? ?? 2F 84 00 00 40 9E 00 A8 38 60 00 18 90 C1 00 08 90 E1 00 0C 4? ?? ?? ?? 7C 7B 1B 78 80 C1 00 08 80 E1 00 0C 2F 9B 00 00 38 60 FF FF 41 BE FF A0 80 1C ?? ?? 7C 1D 00 51 40 82 00 9C 1F BD 00 18 7F BB EA 14 30 E7 FF FF 7C E7 39 10 80 06 00 04 81 7C ?? ?? 54 E7 00 3C 81 46 00 00 38 E7 00 04 81 26 00 0C 7C E0 3B 96 80 06 00 08 91 3D 00 08 90 1D 00 00 91 5D 00 0C 93 DD 00 10 93 FD 00 14 2F 80 00 00 90 FD 00 04 38 0B 00 01 38 60 00 00 93 7A 00 04 90 1C ?? ?? 40 BE FF 34 2F 89 00 02 40 9E FF 2C 93 7A 00 0C 4B FF FF 24 38 84 00 01 80 7A 00 04 1C 84 00 18 90 C1 00 08 90 E1 00 0C 4? ?? ?? ?? 7C 7B 1B 78 80 E1 00 0C 80 C1 00 08 4B FF FF 54 1D 3D 00 18 90 C1 00 08 38 7D 00 01 90 E1 00 0C 1C 63 00 18 7F BB 4A 14 1C A0 00 18 7C 7B 1A 14 7F A4 EB 78 4? ?? ?? ?? 80 E1 00 0C 80 C1 00 08 4B FF FF 40 }
	condition:
		$1
}

rule file_234_5_0 {
	meta:
		name = "__sprofil"
		size = 1136
		refs = "0080 __profile_frequency 012c qsort 0164 __udivdi3 033c free 03b4 __sigaction 03f0 __setitimer 046c __assert_fail"
	strings:
		$1 = { 94 21 FF 20 7C 08 02 A6 54 89 10 3A 7D 80 00 26 39 29 00 1E 90 01 00 E4 55 29 00 36 93 C1 00 D8 7C BE 2B 79 7D 29 00 D0 80 01 00 00 92 81 00 B0 7C D4 33 78 92 C1 00 B8 7C 96 23 78 93 61 00 CC 93 A1 00 D4 7C 7D 1B 78 93 E1 00 DC 7C 3F 0B 78 92 61 00 AC 92 A1 00 B4 92 E1 00 BC 93 01 00 C0 93 21 00 C4 93 41 00 C8 93 81 00 D0 91 81 00 A8 7C 01 49 6E 3B 61 00 17 57 7B 00 36 41 82 00 4C 4? ?? ?? ?? 3C 00 00 0F 60 00 42 40 7C 00 1B D6 3D 20 43 1B 61 29 DE 83 7D 20 48 16 55 29 74 BE 55 2A 40 2E 91 3E 00 00 55 2B 18 38 7D 6B 50 50 55 6A 30 32 7D 6B 50 50 7D 6B 4A 14 55 6B 30 32 7C 0B 00 50 90 1E 00 04 3E A0 ?? ?? 80 15 ?? ?? 3B 95 ?? ?? 2F 80 00 00 40 9E 03 34 2F 96 00 00 90 15 ?? ?? 3D 20 ?? ?? 90 1C 00 04 38 09 ?? ?? 90 1C 00 0C 40 9D 02 5C 7E C9 03 A6 3A FB FF FC 7E E9 BB 78 97 A9 00 04 3B BD 00 10 42 00 FF F8 56 99 07 FE 3C C0 ?? ?? 2E 19 00 00 7F 63 DB 78 7E C4 B3 78 38 A0 00 04 38 C6 ?? ?? 4? ?? ?? ?? 3B 00 00 00 87 57 00 04 83 DA 00 0C 2B 9E 00 01 40 9D 01 48 80 7A 00 04 41 92 01 C0 54 7D F0 BE 82 7A 00 08 54 63 84 3E 57 A4 90 1A 38 A0 00 00 7F C6 F3 78 4? ?? ?? ?? 38 00 00 04 7F 73 22 14 7D 33 D8 50 7C 09 03 96 7D 20 F0 16 7D 40 F1 D6 55 28 80 1E 55 40 84 3E 7D 00 03 78 7D 3D 00 10 7D 29 49 10 7D 29 D8 50 7E 6B 98 F8 7D 3B 4B 78 7D 2B 4A 14 41 92 01 5C 38 00 00 04 7C 09 03 96 7D 20 F0 16 7D 40 F1 D6 55 2B 80 1E 55 40 84 3E 7D 60 03 78 7F 9D 00 40 40 9D 02 88 7D 33 D8 50 41 92 01 28 38 00 00 04 7C 09 03 96 7D 20 F0 16 7D 40 F1 D6 55 2B 80 1E 55 40 84 3E 7D 60 03 78 7F 9D 00 40 41 9D 02 5C 80 1C 00 00 38 60 00 00 2F 80 00 00 41 9E 00 68 80 1C 00 04 3B A0 00 00 3B C0 00 00 7D 20 EA 14 80 A9 00 10 7F 85 98 40 40 9D 00 30 7F 9B 28 40 41 9C 00 40 7F C3 F3 78 7E 64 9B 78 7F 46 D3 78 7F 27 CB 78 4B FF FC 4D 2F 83 00 00 41 9C 00 F0 80 1C 00 04 7D 20 EA 14 81 7C 00 00 3B DE 00 01 82 69 00 14 3B BD 00 18 7F 9E 58 40 41 9C FF B0 7F C3 F3 78 7E 64 9B 78 7F 65 DB 78 7F 46 D3 78 7F 27 CB 78 4B FF FC 0D 2F 83 00 00 41 9C 00 B0 3B 18 00 01 7F 98 B0 00 40 9E FE A4 80 15 ?? ?? 3B C0 00 00 2F 80 00 00 40 9E 00 CC 39 7F 00 E0 80 0B 00 04 7F C3 F3 78 81 8B FF C8 7C 08 03 A6 82 6B FF CC 82 8B FF D0 7D 80 81 20 82 AB FF D4 82 CB FF D8 82 EB FF DC 83 0B FF E0 83 2B FF E4 83 4B FF E8 83 6B FF EC 83 8B FF F0 83 AB FF F4 83 CB FF F8 83 EB FF FC 7D 61 5B 78 4E 80 00 20 38 00 00 02 4B FF FE DC 38 00 00 02 4B FF FE A8 54 7D F8 7E 82 7A 00 08 54 63 84 3E 57 A4 88 1C 38 A0 00 00 7F C6 F3 78 4? ?? ?? ?? 38 00 00 02 7F 73 22 14 7D 33 D8 50 4B FF FE 44 80 7C 00 04 3B C0 FF FF 4? ?? ?? ?? 38 00 00 00 90 15 ?? ?? 90 1C 00 04 4B FF FF 58 3C C0 ?? ?? 7F 63 DB 78 7E C4 B3 78 38 A0 00 04 38 C6 ?? ?? 4? ?? ?? ?? 4B FF FF 2C 72 8B 00 01 80 1C 00 04 90 1C 00 08 41 82 00 84 3D 20 ?? ?? 38 09 ?? ?? 90 1F 00 18 39 60 00 20 7D 69 03 A6 3C 00 10 00 7F E9 FB 78 94 09 00 9C 38 00 FF FF 94 09 FF FC 42 00 FF FC 38 60 00 1B 38 9F 00 18 38 BC 00 20 4? ?? ?? ?? 3B C0 FF FF 2F 83 00 00 41 BC FE E4 38 00 00 00 90 1F 00 10 38 00 00 01 7F E4 FB 78 90 1F 00 14 38 60 00 02 38 BC 00 10 81 3F 00 10 81 5F 00 14 95 24 00 08 91 44 00 04 4? ?? ?? ?? 7C 7E 1B 78 4B FF FE AC 3D 20 ?? ?? 38 09 ?? ?? 90 1F 00 18 4B FF FF 80 38 60 00 02 38 9C 00 10 38 A0 00 00 4? ?? ?? ?? 3B C0 FF FF 2F 83 00 00 41 9C FE 80 38 60 00 1B 38 9C 00 20 38 A0 00 00 4? ?? ?? ?? 2F 83 00 00 41 BC FE 68 80 7C 00 04 3B C0 00 00 4? ?? ?? ?? 4B FF FE 58 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 00 66 38 C6 ?? ?? 4? ?? ?? ?? }
	condition:
		$1
}

rule file_235_0_0 {
	meta:
		name = "__memrchr"
		size = 292
	strings:
		$1 = { 2F 85 00 00 54 84 06 3E 7D 23 2A 14 41 9E 00 40 71 20 00 03 41 82 00 5C 8C 09 FF FF 7F 80 20 00 7D 23 4B 78 4D 9E 00 20 7C A9 03 A6 48 00 00 14 41 82 00 40 8C 09 FF FF 7F 80 20 00 41 9E 00 C0 71 20 00 03 38 A5 FF FF 42 00 FF E8 38 A0 00 00 38 A5 00 01 7C A9 03 A6 42 40 00 C4 8C 09 FF FF 7F 80 20 00 40 9E FF F4 7D 23 4B 78 4E 80 00 20 2B 85 00 03 54 80 40 2E 7C 00 23 78 54 07 80 1E 7C E7 03 78 40 BD FF CC 39 65 FF FC 55 6B F0 BE 39 6B 00 01 7D 69 03 A6 3D 00 81 01 61 08 01 00 85 69 FF FC 38 A5 FF FC 7C EB 5A 78 3D 4B 7E FF 38 0A FE FF 7D 6B 02 78 7D 00 58 79 38 69 00 03 39 69 00 02 38 09 00 01 41 82 00 3C 89 49 00 03 7F 8A 20 00 4D 9E 00 20 89 49 00 02 7F 8A 20 00 41 9E 00 2C 89 69 00 01 7F 8B 20 00 41 9E 00 28 88 09 00 00 7F 80 20 00 40 BE 00 0C 7D 23 4B 78 4E 80 00 20 42 00 FF 9C 4B FF FF 48 7D 63 5B 78 4E 80 00 20 7C 03 03 78 4E 80 00 20 38 60 00 00 4E 80 00 20 }
	condition:
		$1
}

rule file_236_0_0 {
	meta:
		name = "rewinddir"
		size = 196
		refs = "0050 __lseek 0098 __lll_lock_wait_private"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 39 60 00 01 93 C1 00 08 39 20 00 00 7C 7E 1B 78 93 E1 00 0C 3B E3 00 04 90 01 00 14 7C 00 F8 28 7C 00 48 00 40 82 00 0C 7D 60 F9 2D 40 A2 FF F0 4C 00 01 2C 2F 80 00 00 40 9E 00 54 80 7E 00 00 38 80 00 00 38 A0 00 00 4? ?? ?? ?? 38 00 00 00 90 1E 00 14 90 1E 00 10 90 1E 00 0C 7C 00 04 AC 7D 20 F8 28 7C 00 F9 2D 40 A2 FF F8 2F 89 00 01 41 9D 00 28 80 01 00 14 83 C1 00 08 7C 08 03 A6 83 E1 00 0C 38 21 00 10 4E 80 00 20 7F E3 FB 78 4? ?? ?? ?? 4B FF FF A8 80 82 8B 68 38 00 00 DD 7F E3 FB 78 60 84 00 01 38 A0 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF BC }
	condition:
		$1
}

rule file_237_0_0 {
	meta:
		name = "__fgets_unlocked_chk"
		size = 292
		refs = "0058 _IO_getline 00fe _GLOBAL_OFFSET_TABLE_ 0106 __libc_errno 0120 __chk_fail"
	strings:
		$1 = { 2C 05 00 00 94 21 FF E0 7C 08 02 A6 93 A1 00 14 7C 7D 1B 78 93 C1 00 18 7C 9E 23 78 93 E1 00 1C 7C DF 33 78 90 01 00 24 93 81 00 10 40 81 00 AC 38 A5 FF FF 83 86 00 00 7F 85 20 40 57 80 06 F2 90 06 00 00 41 9D 00 50 7F E3 FB 78 7F A4 EB 78 38 C0 00 0A 38 E0 00 01 4? ?? ?? ?? 7C 69 1B 79 40 82 00 54 80 1F 00 00 57 9C 06 B4 83 A1 00 14 7C 00 E3 78 83 C1 00 18 90 1F 00 00 80 01 00 24 83 81 00 10 7C 08 03 A6 83 E1 00 1C 38 21 00 20 4E 80 00 20 7C 85 23 78 7F E3 FB 78 7F A4 EB 78 38 C0 00 0A 38 E0 00 01 4? ?? ?? ?? 7C 69 1B 79 41 A2 FF B4 80 1F 00 00 70 0B 00 20 40 82 00 40 7F 9E 48 40 40 9D 00 5C 38 00 00 00 7C 1D 49 AE 7F A3 EB 78 4B FF FF 90 80 01 00 24 38 60 00 00 83 81 00 10 7C 08 03 A6 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 3D 60 ?? ?? 39 6B ?? ?? 81 6B ?? ?? 7D 6B 12 14 81 6B 00 00 38 60 00 00 2F 8B 00 0B 40 9E FF 50 4B FF FF A4 4? ?? ?? ?? }
	condition:
		$1
}

rule file_238_0_0 {
	meta:
		name = "ntp_gettimex"
		size = 124
		refs = "0028 __adjtimex"
	strings:
		$1 = { 94 21 FF 70 7C 08 02 A6 7C 29 0B 78 93 C1 00 88 3B C0 00 00 90 01 00 94 93 E1 00 8C 7C 7F 1B 78 97 C9 00 08 7D 23 4B 78 4? ?? ?? ?? 80 01 00 14 81 21 00 2C 90 1F 00 08 80 01 00 18 81 41 00 30 90 1F 00 0C 80 01 00 58 93 DF 00 14 90 1F 00 10 80 01 00 94 93 DF 00 18 7C 08 03 A6 93 DF 00 1C 93 DF 00 20 91 3F 00 00 91 5F 00 04 83 C1 00 88 83 E1 00 8C 38 21 00 90 4E 80 00 20 }
	condition:
		$1
}

rule file_239_0_0 {
	meta:
		name = "__stpcpy"
		size = 216
	strings:
		$1 = { 7C 80 1B 78 54 00 07 BF 38 63 FF FC 40 82 00 88 3C E0 FE FF 3D 00 7F 7F 80 C4 00 00 38 E7 FE FF 39 08 7F 7F 48 00 00 24 85 44 00 04 94 C3 00 04 7C 07 52 14 7D 09 50 F8 7C 00 48 39 40 82 00 20 84 C4 00 04 95 43 00 04 7C 07 32 14 7D 09 30 F8 7C 00 48 39 41 82 FF D4 7C CA 33 78 55 40 46 3F 9C 03 00 04 4D 82 00 20 55 40 86 3F 9C 03 00 01 4D 82 00 20 55 40 C6 3F 9C 03 00 01 4D 82 00 20 9D 43 00 01 4E 80 00 20 60 00 00 00 60 00 00 00 60 00 00 00 88 C4 00 00 38 63 00 03 2C 06 00 00 41 82 00 28 8D 44 00 01 9C C3 00 01 2C 0A 00 00 41 82 00 20 60 00 00 00 8C C4 00 01 9D 43 00 01 2C 06 00 00 40 82 FF E0 9C C3 00 01 4E 80 00 20 9D 43 00 01 4E 80 00 20 }
	condition:
		$1
}

rule file_240_0_0 {
	meta:
		name = "_dl_build_local_scope"
		size = 172
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 39 20 00 01 90 01 00 24 93 E1 00 1C 83 E4 01 F8 93 A1 00 14 7C 7D 1B 78 2F 9F 00 00 93 C1 00 18 3B C3 00 04 90 83 00 00 80 04 01 98 51 20 C9 4C 90 04 01 98 41 9E 00 4C 80 9F 00 04 3B FF 00 04 2F 84 00 00 40 BE 00 14 48 00 00 38 84 9F 00 04 2F 84 00 00 41 9E 00 2C 80 04 01 98 74 09 06 00 40 82 FF EC 7F C3 F3 78 4B FF FF 91 84 9F 00 04 54 63 10 3A 2F 84 00 00 7F DE 1A 14 40 9E FF DC 80 01 00 24 7F DD F0 50 7F C3 16 70 83 A1 00 14 7C 08 03 A6 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 }
	condition:
		$1
}

rule file_240_1_0 {
	meta:
		name = "openaux"
		size = 88
		refs = "003c _dl_map_object"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 38 A0 00 01 90 01 00 14 93 E1 00 0C 7C 7F 1B 78 80 63 00 00 80 9F 00 10 80 03 01 98 74 09 C0 00 41 82 00 08 54 05 17 BE 80 DF 00 04 80 FF 00 08 81 03 00 18 4? ?? ?? ?? 80 01 00 14 90 7F 00 14 7C 08 03 A6 83 E1 00 0C 38 21 00 10 4E 80 00 20 }
	condition:
		$1
}

rule file_240_2_0 {
	meta:
		name = "_dl_map_object_deps"
		size = 3880
		refs = "0116 _dl_debug_mask 0118 __errno_location 0126 __libc_enable_secure 012e _dl_platformlen 01d8 strchr 0200 _dl_catch_error 0298 malloc 02b8 memcpy 057c memset 0620 memmove 0658 _dl_scope_free 06e8 __assert_fail 085c strlen 08f0 _dl_dst_count 0994 _dl_dst_substitute 09c4 _dl_debug_printf 09dc _dl_get_origin 0a10 _dl_signal_error 0a50 free 0af2 _dl_argv 0d9e _dl_ns"
	strings:
		$1 = { 94 21 FF 60 7C 08 02 A6 2F 85 00 00 90 01 00 A4 1C 05 00 0C 30 00 00 36 81 21 00 00 54 00 00 36 91 C1 00 58 7C 00 00 D0 91 E1 00 5C 39 60 00 01 7C CE 33 78 92 21 00 64 7C 71 1B 78 92 41 00 68 92 A1 00 74 3A A0 00 01 93 E1 00 9C 7C 3F 0B 78 92 01 00 60 92 61 00 6C 92 81 00 70 92 C1 00 78 92 E1 00 7C 93 01 00 80 93 21 00 84 93 41 00 88 93 61 00 8C 93 81 00 90 93 A1 00 94 93 C1 00 98 7D 21 01 6E 80 03 01 98 3A 41 00 17 56 52 00 36 90 FF 00 40 51 60 C9 4C 39 32 00 0C 90 72 00 04 39 60 00 00 91 72 00 00 7E 4F 93 78 91 32 00 08 90 03 01 98 41 9E 00 48 7C A9 03 A6 38 84 FF FC 39 32 00 18 3A A0 00 00 39 00 00 00 39 40 00 01 85 64 00 04 3A B5 00 01 91 09 FF F4 91 69 FF F8 91 29 FF FC 39 29 00 0C 80 0B 01 98 51 40 C9 4C 90 0B 01 98 42 00 FF DC 3A B5 00 01 3A 95 FF FF 1E 94 00 0C 3B C0 00 00 7E 92 A2 14 93 D4 00 08 3E E0 ?? ?? 3E 60 ?? ?? 4? ?? ?? ?? 3A F7 ?? ?? 80 03 00 00 3F 00 ?? ?? 90 7F 00 44 3E C0 ?? ?? 90 1F 00 48 93 DF 00 0C 93 C3 00 00 83 92 00 04 39 20 00 01 3B 40 00 00 80 1C 01 60 91 32 00 00 2F 80 00 00 41 9E 03 74 80 1C 00 24 2F 80 00 00 41 9E 00 FC 83 BC 00 08 81 3C 00 34 80 1D 00 00 83 29 00 04 2F 80 00 00 81 1F 00 40 93 3F 00 20 93 9F 00 14 91 DF 00 18 91 1F 00 1C 41 9E 00 E8 7E 50 93 78 3B 60 00 00 48 00 00 24 2F 9A 00 00 41 9E 00 10 57 60 10 3A 7D 3A 01 2E 3B 7B 00 01 84 1D 00 08 2F 80 00 00 41 9E 00 C0 2F 80 00 01 40 9E 05 44 80 1D 00 04 38 80 00 24 7C 19 02 14 7C 03 03 78 90 1F 00 38 4? ?? ?? ?? 2F 83 00 00 83 DF 00 38 40 9E 07 08 38 9F 00 0C 93 DF 00 24 38 7F 00 10 38 BF 00 08 7E E6 BB 78 38 FF 00 14 4? ?? ?? ?? 80 9F 00 0C 2F 84 00 00 40 9E 06 44 81 3F 00 28 80 09 01 98 74 00 06 00 40 82 FF 80 81 61 00 00 3A B5 00 01 95 61 FF E0 39 61 00 17 55 6B 00 36 90 0B 00 08 91 2B 00 04 91 74 00 08 7D 74 5B 78 90 0B 00 00 39 60 00 01 80 09 01 98 51 60 C9 4C 90 09 01 98 4B FF FF 44 80 1C 00 F4 2F 80 00 00 40 9E FF 00 80 1C 00 EC 2F 80 00 00 40 9E FE F4 3B 60 00 00 2F 9A 00 00 41 9E 00 60 57 60 10 3A 39 20 00 00 3B 7B 00 01 7D 3A 01 2E 57 63 18 38 38 63 00 04 4? ?? ?? ?? 7C 7E 1B 79 41 82 07 74 57 7D 10 3A 93 9E 00 00 7F 44 D3 78 7F A5 EB 78 38 7E 00 04 4? ?? ?? ?? 38 7B 00 01 54 63 10 3A 7C 7E 1A 14 7F C4 F3 78 7F A5 EB 78 4? ?? ?? ?? 7C 00 06 AC 93 DC 01 F8 80 12 00 00 2F 80 00 00 41 BE FE 58 82 52 00 08 2F 92 00 00 40 9E FF EC 3B C0 00 00 81 1F 00 44 80 08 00 00 2F 80 00 00 40 9E 00 14 81 3F 00 48 2F 89 00 00 41 9E 00 08 91 28 00 00 82 51 01 F8 2F 92 00 00 41 9E 00 1C 81 31 01 98 3C 00 80 00 55 29 00 02 7F 89 00 00 41 9E 03 8C 3A 40 00 00 56 A3 18 38 38 63 00 04 4? ?? ?? ?? 7C 77 1B 79 41 82 0A C8 39 75 00 01 92 B1 01 64 55 6B 10 3A 7D 77 5A 14 2F 0E 00 00 91 71 01 60 3B 20 00 00 39 40 00 00 40 9A 0A 84 81 2F 00 04 57 20 10 3A 7D 2B 01 2E 3B 39 00 01 81 2F 00 04 80 09 01 98 51 40 C9 4C 90 09 01 98 81 EF 00 08 2F 8F 00 00 40 9E FF D4 3D 20 ?? ?? 80 09 ?? ?? 70 08 04 00 40 82 09 F0 80 91 01 60 82 64 00 00 7F 93 88 00 40 9E 09 C0 83 71 01 FC 2F 9B 00 00 41 9E 09 98 2B 99 00 01 40 9D 00 24 39 39 FF FF 7D 29 03 A6 39 60 00 01 85 24 00 04 80 09 01 98 51 60 C9 4C 90 09 01 98 42 00 FF F0 80 F1 01 FC 3B 5B 00 04 80 07 00 00 2F 80 00 00 41 9E 01 10 3B A0 00 00 48 00 00 14 80 07 00 00 3B BD 00 01 7F 80 E8 40 40 9D 00 F8 57 B6 10 3A 7F 1B B2 14 81 38 00 04 3B 18 00 04 80 09 01 98 74 0A 06 00 41 82 FF D8 80 71 02 00 38 63 00 01 54 63 10 3A 4? ?? ?? ?? 7C 7C 1B 79 41 82 00 BC 38 7C 00 04 7F 44 D3 78 7E C5 B3 78 4? ?? ?? ?? 80 F1 01 FC 39 1D 00 01 80 07 00 00 7F AA EB 78 7F 80 40 40 40 9D 00 44 7C 08 00 50 7C 09 03 A6 7D 09 43 78 85 78 00 04 80 0B 01 98 74 06 06 00 40 82 00 14 55 46 10 3A 7C DC 32 14 91 66 00 04 39 4A 00 01 39 29 00 01 42 00 FF DC 39 29 FF FF 7F BD 48 50 7D 08 EA 14 91 5C 00 00 7D 1D 43 78 4B FF FF 4C 80 1C 01 F8 2F 80 00 00 40 9E FC 88 7F 9C 88 00 41 BE FC 80 A0 1C 01 5E 2F 80 00 00 41 9E FC 74 54 00 10 3A 81 21 00 00 30 00 00 1E 54 00 03 76 7C 00 00 D0 7D 21 01 6E 3B 41 00 17 57 5A 00 36 4B FF FC 50 80 F1 01 FC 4B FF FF 00 2B 99 00 01 40 9D 08 18 39 19 FF FF 81 31 01 60 7D 09 03 A6 39 40 00 00 85 69 00 04 80 0B 01 98 51 40 C9 4C 90 0B 01 98 42 00 FF F0 57 35 10 3A 80 93 01 60 7E E3 BB 78 7E A5 AB 78 4? ?? ?? ?? 38 19 00 1E 81 21 00 00 54 00 00 36 7C 00 00 D0 7D 21 01 6E 38 80 00 00 7F 25 CB 78 3A C1 00 17 56 D6 00 36 7E C3 B3 78 4? ?? ?? ?? 3A 39 FF FF 3B 40 00 01 3A 80 00 04 3B 00 00 02 3A 00 00 01 7F 9A 88 40 7E 16 D1 AE 7C 77 A2 14 7F B7 A0 2E 40 9C 00 44 7F 77 AA 14 7E 3C 8B 78 85 3B FF FC 81 29 01 F8 2F 89 00 00 39 29 FF FC 40 BE 00 10 48 00 00 18 7F 9D 00 00 41 9E 00 44 84 09 00 04 2F 80 00 00 40 9E FF F0 3B 9C FF FF 7F 9C D0 00 40 9E FF CC 7F 99 C0 00 7F 1A C3 78 41 9E 00 4C 7C 76 C2 14 7C B8 C8 50 38 80 00 00 57 14 10 3A 4? ?? ?? ?? 3B 18 00 01 4B FF FF 88 7D FA E0 50 57 04 10 3A 7C 97 22 14 55 E5 10 3A 4? ?? ?? ?? 7C 16 C0 AE 93 BB 00 00 2F 80 00 00 41 9E 00 BC 7F 1A C3 78 4B FF FF BC 38 00 00 00 7C 17 A9 2E 7C 00 06 AC 2F 92 00 00 92 F3 01 F8 41 9E 00 0C 7E 43 93 78 4? ?? ?? ?? 2F 9E 00 00 40 9E 06 B0 39 7F 00 A0 80 0B 00 04 81 CB FF B8 7C 08 03 A6 81 EB FF BC 82 0B FF C0 82 2B FF C4 82 4B FF C8 82 6B FF CC 82 8B FF D0 82 AB FF D4 82 CB FF D8 82 EB FF DC 83 0B FF E0 83 2B FF E4 83 4B FF E8 83 6B FF EC 83 8B FF F0 83 AB FF F4 83 CB FF F8 83 EB FF FC 7D 61 5B 78 4E 80 00 20 80 11 01 60 2F 80 00 00 41 9E FC 74 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 01 F3 38 C6 ?? ?? 4? ?? ?? ?? 7C 76 D2 14 7C 96 C2 14 7D E5 7B 78 4? ?? ?? ?? 7E 16 E1 AE 4B FF FE 94 6C 08 80 00 2F 88 FF FD 41 9E 00 10 6C 09 80 00 2F 89 FF FF 40 9E FA 98 83 DD 00 04 38 80 00 24 7F D9 F2 14 7F C3 F3 78 4? ?? ?? ?? 7F C9 F3 78 2F 83 00 00 40 9E 04 20 80 1D 00 00 91 3F 00 24 6C 06 80 00 2F 86 FF FD 41 9E 03 C8 80 13 ?? ?? 70 06 00 01 40 82 03 88 38 9F 00 0C 38 7F 00 10 38 BF 00 08 7E E6 BB 78 38 FF 00 14 4? ?? ?? ?? 80 9F 00 0C 2F 84 00 00 40 9E 00 D4 80 01 00 00 2F 9A 00 00 81 3F 00 28 94 01 FF E0 80 10 00 08 39 61 00 17 81 10 00 00 55 6B 00 36 81 50 00 04 90 0B 00 08 38 00 00 00 91 0B 00 00 91 4B 00 04 90 10 00 00 91 30 00 04 41 9E 00 14 57 60 10 3A 7D 3A 01 2E 3B 7B 00 01 81 3F 00 28 80 09 01 98 7D 6A 5B 78 74 06 06 00 40 82 02 8C 81 49 00 10 39 00 00 01 91 70 00 08 3A B5 00 01 2F 8A 00 00 80 09 01 98 51 00 C9 4C 90 09 01 98 41 9E 00 0C 80 09 00 0C 90 0A 00 0C 81 09 00 0C 2F 88 00 00 41 9E 00 08 91 48 00 10 81 4B 00 04 80 0A 00 10 90 09 00 10 91 2A 00 10 81 09 00 10 2F 88 00 00 41 9E 00 08 91 28 00 0C 7F 90 A0 00 91 49 00 0C 41 9E 02 4C 7D 70 5B 78 4B FF F9 64 7C 7E 1B 78 90 9F 00 4C 7C 83 23 78 4? ?? ?? ?? 81 21 00 00 38 03 00 1F 80 9F 00 4C 54 00 00 36 7C 00 00 D0 7D 21 01 6E 7C 65 1B 78 38 A5 00 01 38 61 00 17 54 63 00 36 4? ?? ?? ?? 83 9F 00 10 7C 7D 1B 78 7F 83 E3 78 4? ?? ?? ?? 81 21 00 00 38 03 00 1F 54 00 00 36 7C 00 00 D0 7D 21 01 6E 7C 65 1B 78 7F 84 E3 78 38 61 00 17 54 63 00 36 38 A5 00 01 4? ?? ?? ?? 88 1F 00 08 90 7F 00 10 2F 80 00 00 40 9E 01 78 2F 9E 00 00 93 BF 00 0C 40 BE FA 18 3B C0 FF FF 4B FF FA 10 38 80 00 00 4? ?? ?? ?? 7C 69 1B 79 91 3F 00 3C 41 A2 F8 EC 80 18 ?? ?? 2F 80 00 00 40 9E 00 F4 80 7F 00 38 4? ?? ?? ?? 7C 7E 1B 78 80 7C 01 AC 2F 83 00 00 41 9E 00 AC 2F 83 FF FF 38 00 00 00 41 9E 00 0C 4? ?? ?? ?? 7C 60 1B 78 81 36 ?? ?? 2B 89 00 03 40 9C 00 08 39 20 00 03 7F 89 00 40 40 9C 00 08 7C 09 03 78 2B 89 00 04 40 9D 00 14 81 5F 00 3C 39 29 FF FC 7D 29 51 D6 7F DE 4A 14 3B DE 00 1E 80 01 00 00 57 DE 00 36 80 9F 00 38 7F DE 00 D0 7C 01 F1 6E 7F 83 E3 78 38 C0 00 00 38 A1 00 17 54 A5 00 36 4? ?? ?? ?? 88 03 00 00 7C 7E 1B 78 2F 80 00 00 40 BE F8 44 80 13 ?? ?? 70 0B 00 01 41 82 F8 00 3C C0 ?? ?? 80 9F 00 38 80 66 ?? ?? 4C C6 31 82 4? ?? ?? ?? 4B FF F7 E8 81 3C 00 04 88 09 00 00 2F 80 00 00 40 9E 00 54 4? ?? ?? ?? 38 00 FF FD 39 63 FF FF 90 7C 01 AC 7F 8B 00 40 38 00 00 00 41 BD FF 44 4B FF FF 38 3C C0 ?? ?? 80 9F 00 38 38 60 00 00 38 A0 00 00 38 C6 ?? ?? 4? ?? ?? ?? 3C C0 ?? ?? 80 91 00 04 38 60 00 0C 38 A0 00 00 38 C6 ?? ?? 4? ?? ?? ?? 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 00 F2 38 C6 ?? ?? 4? ?? ?? ?? 80 7F 00 0C 4? ?? ?? ?? 4B FF FE 84 80 08 00 04 7F 89 00 00 41 9E 00 3C 7D 0A 43 78 81 0A 00 08 2F 88 00 00 40 9E FF E8 81 4B 00 00 81 2B 00 04 80 0B 00 08 91 50 00 00 91 30 00 04 90 10 00 08 4B FF F7 24 7D 70 5B 78 7D 74 5B 78 4B FF F7 18 91 70 00 08 80 EA 00 08 7F 87 A0 00 40 BE 00 08 7D 54 53 78 81 09 00 10 80 07 00 08 2F 88 00 00 90 0A 00 08 41 9E 00 0C 80 09 00 0C 90 08 00 0C 81 49 00 0C 2F 8A 00 00 41 BE FD 48 91 0A 00 10 4B FF FD 40 80 BC 00 04 88 05 00 00 2F 80 00 00 40 9E 00 10 3D 00 ?? ?? 81 68 ?? ?? 80 AB 00 00 3D 40 ?? ?? 80 6A ?? ?? 7D 24 4B 78 4C C6 31 82 4? ?? ?? ?? 4B FF FC 4C 80 13 ?? ?? 70 08 00 01 40 82 01 C0 38 7F 00 10 38 9F 00 0C 38 BF 00 08 7E E6 BB 78 38 FF 00 14 4? ?? ?? ?? 80 7F 00 0C 2F 83 00 00 41 9E FC 40 88 1F 00 08 2F 80 00 00 41 9E F6 64 4? ?? ?? ?? 4B FF F6 5C 38 80 00 00 93 DF 00 4C 4? ?? ?? ?? 7C 6A 1B 79 81 3F 00 4C 91 5F 00 3C 41 A2 FB CC 80 18 ?? ?? 2F 80 00 00 40 9E 01 48 7F C3 F3 78 4? ?? ?? ?? 90 7F 00 38 80 7C 01 AC 2F 83 00 00 41 9E 00 C8 2F 83 FF FF 38 00 00 00 41 9E 00 0C 4? ?? ?? ?? 7C 60 1B 78 81 36 ?? ?? 2B 89 00 03 40 9C 00 08 39 20 00 03 7F 89 00 40 40 9C 00 08 7C 09 03 78 2B 89 00 04 40 9D 00 1C 81 7F 00 3C 38 09 FF FC 80 DF 00 38 7C 00 59 D6 7C C6 02 14 90 DF 00 38 81 1F 00 38 7F 83 E3 78 81 21 00 00 7F C4 F3 78 38 08 00 1E 54 00 00 36 7C 00 00 D0 7D 21 01 6E 38 C0 00 00 38 A1 00 17 54 A5 00 36 4? ?? ?? ?? 88 03 00 00 7C 69 1B 78 2F 80 00 00 40 BE FB 18 80 1D 00 00 6C 09 80 00 2F 89 FF FD 41 9E 00 58 80 13 ?? ?? 70 0A 00 01 41 82 F5 70 3D 60 ?? ?? 80 6B ?? ?? 7F C4 F3 78 4C C6 31 82 4? ?? ?? ?? 4B FF F5 58 81 3C 00 04 88 09 00 00 2F 80 00 00 40 9E 00 3C 4? ?? ?? ?? 38 00 FF FD 39 63 FF FF 90 7C 01 AC 7F 8B 00 40 38 00 00 00 41 BD FF 28 4B FF FF 1C 3C C0 ?? ?? 38 60 00 00 7F C4 F3 78 38 A0 00 00 38 C6 ?? ?? 4? ?? ?? ?? 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 01 26 38 C6 ?? ?? 4? ?? ?? ?? 3C C0 ?? ?? 38 60 00 00 7F C4 F3 78 38 A0 00 00 38 C6 ?? ?? 4? ?? ?? ?? 80 BC 00 04 88 05 00 00 2F 80 00 00 40 9E 00 10 3D 40 ?? ?? 81 6A ?? ?? 80 AB 00 00 3D 60 ?? ?? 80 6B ?? ?? 7D 24 4B 78 4C C6 31 82 4? ?? ?? ?? 4B FF FE 14 2F 9E FF FF 40 BE 00 08 3B C0 00 00 80 9F 00 10 7F C3 F3 78 80 DF 00 0C 38 A0 00 00 4? ?? ?? ?? 80 93 01 60 7E E3 BB 78 57 25 10 3A 4? ?? ?? ?? 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 02 6E 38 C6 ?? ?? 4? ?? ?? ?? 57 35 10 3A 7E E3 BB 78 7E A5 AB 78 4? ?? ?? ?? 2B 99 00 01 40 9D FF CC 4B FF F7 DC 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 02 44 38 C6 ?? ?? 4? ?? ?? ?? 3D 20 ?? ?? 83 89 ?? ?? 7F 9C 88 00 40 9E F6 08 3B 60 00 00 3B 00 00 00 3B 40 00 01 7F 9B C8 00 41 BE F5 F4 81 3C 01 60 57 60 10 3A 7E C9 00 2E 7F 9C B0 00 41 9E 00 1C 81 36 01 D4 2F 89 00 00 41 9E 00 50 80 09 00 04 2F 80 00 00 41 9E 00 44 3B 7B 00 01 4B FF FF C8 81 2F 00 04 80 09 01 98 74 06 00 40 41 A2 F5 78 80 11 01 64 30 00 FF FF 90 11 01 64 4B FF F5 78 80 91 00 04 3C C0 ?? ?? 38 60 00 0C 38 A0 00 00 38 C6 ?? ?? 4? ?? ?? ?? 80 16 00 F4 2F 80 00 00 40 9E 00 D4 80 16 00 EC 2F 80 00 00 40 9E 00 C8 7E E3 BB 78 7E C4 B3 78 4B FF F0 B1 7F 99 18 40 41 9C 00 94 38 63 00 01 7C 69 03 A6 7E E9 BB 78 3B A0 00 00 42 40 00 44 81 69 00 00 2F 9D 00 00 80 0B 01 98 53 00 C9 4C 90 0B 01 98 41 9E 00 20 81 69 00 00 80 0B 00 60 2F 80 00 00 41 BE 00 10 80 16 01 98 53 40 83 DE 90 16 01 98 3B BD 00 01 39 29 00 04 4B FF FF C0 38 7D 00 02 54 63 10 3A 4? ?? ?? ?? 2F 83 00 00 90 76 01 D4 7C 69 1B 78 41 9E 00 5C 38 03 00 08 93 A9 00 04 7C 03 03 78 90 09 00 00 7E E4 BB 78 57 A5 10 3A 4? ?? ?? ?? 4B FF FF 08 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 02 2B 38 C6 ?? ?? 4? ?? ?? ?? 3C C0 ?? ?? 80 96 00 04 38 60 00 16 38 A0 00 00 38 C6 ?? ?? 4? ?? ?? ?? 80 9C 00 04 4B FF FE F4 }
	condition:
		$1
}

rule file_241_0_0 {
	meta:
		name = "dlinfo_doit"
		size = 348
		refs = "0038 _dl_signal_error 00cc _dl_rtld_di_serinfo 0110 strcpy 0154 _dl_tls_get_addr_soft"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 80 03 00 08 93 E1 00 0C 7C 7F 1B 78 2B 80 00 0A 81 23 00 04 40 9D 00 1C 3C C0 ?? ?? 38 60 00 00 38 80 00 00 38 A0 00 00 38 C6 ?? ?? 4? ?? ?? ?? 3D 60 ?? ?? 39 6B ?? ?? 54 00 10 3A 7C 0B 00 2E 7D 60 5A 14 7D 69 03 A6 4E 80 04 20 80 09 02 40 38 60 00 00 2F 80 00 00 40 9E 00 EC 80 01 00 14 81 3F 00 0C 7C 08 03 A6 83 E1 00 0C 90 69 00 00 38 21 00 10 4E 80 00 20 80 09 00 18 81 63 00 0C 90 0B 00 00 80 01 00 14 83 E1 00 0C 38 21 00 10 7C 08 03 A6 4E 80 00 20 80 01 00 14 81 63 00 0C 7C 08 03 A6 83 E1 00 0C 91 2B 00 00 38 21 00 10 4E 80 00 20 80 83 00 0C 38 A0 00 00 7D 23 4B 78 4? ?? ?? ?? 80 01 00 14 83 E1 00 0C 38 21 00 10 7C 08 03 A6 4E 80 00 20 80 83 00 0C 38 A0 00 01 7D 23 4B 78 4? ?? ?? ?? 80 01 00 14 83 E1 00 0C 38 21 00 10 7C 08 03 A6 4E 80 00 20 80 63 00 0C 80 89 01 AC 4? ?? ?? ?? 80 01 00 14 83 E1 00 0C 38 21 00 10 7C 08 03 A6 4E 80 00 20 81 63 00 0C 38 00 00 00 90 0B 00 00 80 09 02 40 90 0B 00 00 80 01 00 14 83 E1 00 0C 38 21 00 10 7C 08 03 A6 4E 80 00 20 7D 23 4B 78 4? ?? ?? ?? 4B FF FF 10 }
	condition:
		$1
}

rule file_241_1_0 {
	meta:
		name = "__dlinfo"
		size = 72
		refs = "0028 _dlerror_run"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 90 61 00 0C 3C 60 ?? ?? 38 63 ?? ?? 90 81 00 10 38 81 00 08 90 01 00 24 90 C1 00 08 90 A1 00 14 4? ?? ?? ?? 7C 63 00 34 80 01 00 24 54 63 D9 7E 38 63 FF FF 7C 08 03 A6 38 21 00 20 4E 80 00 20 }
	condition:
		$1
}

rule file_242_0_0 {
	meta:
		name = "abs"
		size = 16
		altNames = "labs"
	strings:
		$1 = { 7C 60 FE 70 7C 03 1A 78 7C 60 18 50 4E 80 00 20 }
	condition:
		$1
}

rule file_243_0_0 {
	meta:
		name = "_nl_init_alt_digit"
		size = 224
		refs = "004c malloc 0070 __rawmemchr 00b2 _nl_cleanup_time"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 93 C1 00 18 7C 7E 1B 78 90 01 00 24 93 A1 00 14 93 E1 00 1C 83 E3 00 14 2F 9F 00 00 41 9E 00 78 80 1F 00 14 2F 80 00 00 40 9E 00 50 83 BE 00 E0 38 00 00 01 90 1F 00 14 2F 9D 00 00 41 9E 00 3C 38 60 01 90 4? ?? ?? ?? 2F 83 00 00 90 7F 00 0C 41 9E 00 28 3B E3 FF FC 3B C3 01 8C 97 BF 00 04 7F A3 EB 78 38 80 00 00 4? ?? ?? ?? 7F 9F F0 00 3B A3 00 01 40 9E FF E8 80 01 00 24 83 A1 00 14 7C 08 03 A6 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 38 60 00 1C 4? ?? ?? ?? 2F 83 00 00 90 7E 00 14 41 BE FF D4 3D 20 ?? ?? 38 09 ?? ?? 90 1E 00 10 93 E3 00 00 93 E3 00 04 93 E3 00 08 93 E3 00 0C 93 E3 00 10 93 E3 00 14 93 E3 00 18 7C 7F 1B 78 4B FF FF 4C }
	condition:
		$1
}

rule file_243_1_0 {
	meta:
		name = "_nl_get_alt_digit"
		size = 228
		refs = "0052 __pthread_rwlock_wrlock 0062 __libc_setlocale_lock 00c6 __pthread_rwlock_unlock"
	strings:
		$1 = { 2B 83 00 63 94 21 FF E0 7C 08 02 A6 93 C1 00 18 3B C0 00 00 93 E1 00 1C 7C 7F 1B 78 90 01 00 24 40 9D 00 20 80 01 00 24 7F C3 F3 78 83 E1 00 1C 7C 08 03 A6 83 C1 00 18 38 21 00 20 4E 80 00 20 81 24 00 E0 88 09 00 00 2F 80 00 00 41 BE FF D8 3D 20 ?? ?? 38 09 ?? ?? 2F 80 00 00 41 9E 00 18 3C 60 ?? ?? 90 81 00 08 38 63 ?? ?? 4? ?? ?? ?? 80 81 00 08 81 24 00 14 2F 89 00 00 41 9E 00 10 80 09 00 14 2F 80 00 00 40 9E 00 24 7C 83 23 78 90 81 00 08 4B FF FE 8D 3B C0 00 00 80 81 00 08 81 24 00 14 2F 89 00 00 41 9E 00 1C 81 29 00 0C 3B C0 00 00 2F 89 00 00 41 9E 00 0C 57 FF 10 3A 7F C9 F8 2E 3D 20 ?? ?? 38 09 ?? ?? 2F 80 00 00 41 BE FF 54 3C 60 ?? ?? 38 63 ?? ?? 4? ?? ?? ?? 4B FF FF 44 }
	condition:
		$1
}

rule file_243_2_0 {
	meta:
		name = "_nl_get_walt_digit"
		size = 388
		refs = "006a __pthread_rwlock_wrlock 007a __libc_setlocale_lock 00bc malloc 00e8 wcschr 0116 __pthread_rwlock_unlock 0156 _nl_cleanup_time"
	strings:
		$1 = { 2B 83 00 63 94 21 FF D0 7C 08 02 A6 93 C1 00 28 7C 7E 1B 78 93 E1 00 2C 3B E0 00 00 90 01 00 34 93 61 00 1C 93 81 00 20 93 A1 00 24 40 9D 00 2C 80 01 00 34 7F E3 FB 78 83 61 00 1C 7C 08 03 A6 83 81 00 20 83 A1 00 24 83 C1 00 28 83 E1 00 2C 38 21 00 30 4E 80 00 20 81 24 01 AC 80 09 00 00 2F 80 00 00 41 BE FF CC 3D 20 ?? ?? 38 09 ?? ?? 2F 80 00 00 41 9E 00 18 3C 60 ?? ?? 90 81 00 08 38 63 ?? ?? 4? ?? ?? ?? 80 81 00 08 83 A4 00 14 2F 9D 00 00 41 9E 00 A0 80 1D 00 18 2F 80 00 00 40 9E 00 5C 83 64 01 AC 38 00 00 01 90 1D 00 18 2F 9B 00 00 41 9E 00 48 38 60 01 90 4? ?? ?? ?? 3B E0 00 00 2F 83 00 00 90 7D 00 10 7C 7C 1B 78 41 9E 00 44 3B E3 FF FC 3B A3 01 8C 97 7F 00 04 7F 63 DB 78 38 80 00 00 4? ?? ?? ?? 7F 9F E8 00 3B 63 00 04 40 9E FF E8 48 00 00 14 83 9D 00 10 3B E0 00 00 2F 9C 00 00 41 9E 00 0C 57 DE 10 3A 7F FC F0 2E 3D 20 ?? ?? 38 09 ?? ?? 2F 80 00 00 41 BE FF 10 3C 60 ?? ?? 38 63 ?? ?? 4? ?? ?? ?? 4B FF FF 00 38 60 00 1C 90 81 00 08 4? ?? ?? ?? 3B E0 00 00 2F 83 00 00 80 81 00 08 90 64 00 14 41 BE FF C4 3D 20 ?? ?? 38 09 ?? ?? 90 04 00 10 93 A3 00 00 93 A3 00 04 93 A3 00 08 93 A3 00 0C 93 A3 00 10 93 A3 00 14 93 A3 00 18 7C 7D 1B 78 4B FF FF 18 }
	condition:
		$1
}

rule file_243_3_0 {
	meta:
		name = "_nl_parse_alt_digit"
		size = 352
		refs = "004e __pthread_rwlock_wrlock 005e __libc_setlocale_lock 00c0 strlen 00dc strncmp 00fe __pthread_rwlock_unlock"
	strings:
		$1 = { 94 21 FF D0 7C 08 02 A6 93 21 00 14 7C 79 1B 78 90 01 00 34 93 41 00 18 3B 40 FF FF 93 61 00 1C 93 E1 00 2C 7C 9F 23 78 93 01 00 10 93 81 00 20 93 A1 00 24 93 C1 00 28 81 24 01 AC 83 63 00 00 80 09 00 00 2F 80 00 00 41 9E 00 E4 3D 20 ?? ?? 38 09 ?? ?? 2F 80 00 00 41 9E 00 10 3C 60 ?? ?? 38 63 ?? ?? 4? ?? ?? ?? 81 3F 00 14 2F 89 00 00 41 9E 00 10 80 09 00 14 2F 80 00 00 40 9E 00 20 7F E3 FB 78 4B FF FC 35 81 3F 00 14 3B 80 00 00 2F 89 00 00 3B 40 FF FF 41 9E 00 64 83 A9 00 0C 3B 80 00 00 3B 40 FF FF 2F 9D 00 00 41 9E 00 50 3B BD FF FC 3B E0 00 00 87 1D 00 04 7F 03 C3 78 4? ?? ?? ?? 7F 64 DB 78 7C 7E 1B 78 7F 9E E0 40 7F 03 C3 78 7F C5 F3 78 40 9D 00 18 4? ?? ?? ?? 2F 83 00 00 40 9E 00 0C 7F FA FB 78 7F DC F3 78 2F 9F 00 63 3B FF 00 01 40 9E FF C0 3D 20 ?? ?? 38 09 ?? ?? 2F 80 00 00 41 9E 00 10 3C 60 ?? ?? 38 63 ?? ?? 4? ?? ?? ?? 2F 9A FF FF 41 9E 00 10 80 19 00 00 7F 80 E2 14 93 99 00 00 80 01 00 34 7F 43 D3 78 83 01 00 10 7C 08 03 A6 83 21 00 14 83 41 00 18 83 61 00 1C 83 81 00 20 83 A1 00 24 83 C1 00 28 83 E1 00 2C 38 21 00 30 4E 80 00 20 }
	condition:
		$1
}

rule file_245_0_0 {
	meta:
		name = "is_dst"
		size = 244
	strings:
		$1 = { 88 04 00 00 7C 69 1B 78 39 40 00 00 2F 80 00 7B 41 9E 00 D0 89 65 00 00 38 60 00 00 7F 8B 00 00 40 9E 00 2C 2F 80 00 00 40 BE 00 0C 48 00 00 20 41 9A 00 1C 38 63 00 01 7C 04 18 AE 7D 65 18 AE 2F 00 00 00 7F 8B 00 00 41 9E FF E8 2F 8A 00 00 41 9E 00 1C 2F 80 00 7D 38 84 FF FF 38 63 00 02 41 9E 00 14 38 60 00 00 4E 80 00 20 2F 80 00 00 40 9E 00 54 2F 87 00 00 4D BE 00 20 7C 04 18 AE 2F 80 00 00 41 9E 00 14 2F 86 00 00 41 BE FF D8 2F 80 00 3A 40 9E FF D0 39 29 00 01 7F 84 48 00 4D 9E 00 20 2F 86 00 00 41 9E 00 44 88 04 FF FE 68 00 00 3A 30 00 FF FF 7C 00 01 10 7C 63 00 38 4E 80 00 20 2F 80 00 2F 41 BE FF AC 2F 86 00 00 41 BE FF 94 2F 80 00 3A 40 9E FF 8C 4B FF FF 98 8C 04 00 01 39 40 00 01 4B FF FF 2C 38 60 00 00 4E 80 00 20 }
	condition:
		$1
}

rule file_245_1_0 {
	meta:
		name = "local_strdup"
		size = 96
		refs = "0018 strlen 0024 malloc 003c memcpy"
		altNames = "__strdup"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 93 C1 00 08 7C 7E 1B 78 90 01 00 14 93 E1 00 0C 4? ?? ?? ?? 3B E3 00 01 7F E3 FB 78 4? ?? ?? ?? 38 00 00 00 2F 83 00 00 41 9E 00 14 7F C4 F3 78 7F E5 FB 78 4? ?? ?? ?? 7C 60 1B 78 7C 03 03 78 80 01 00 14 83 C1 00 08 7C 08 03 A6 83 E1 00 0C 38 21 00 10 4E 80 00 20 }
	condition:
		$1
}

rule file_245_2_0 {
	meta:
		name = "fillin_rpath"
		size = 924
		refs = "003a _dl_all_dirs 00a4 __strsep_g 00b0 strlen 0144 memcmp 0264 malloc 0284 mempcpy 02ec memcpy 037c _dl_signal_error"
	strings:
		$1 = { 94 21 FF A0 7D 80 00 26 7C 08 02 A6 2E 06 00 00 93 C1 00 58 2D 88 00 00 7C 3E 0B 78 91 C1 00 18 39 C0 00 00 91 E1 00 1C 3D E0 ?? ?? 92 01 00 20 7D 10 43 78 92 E1 00 3C 3E E0 ?? ?? 93 01 00 40 7C F8 3B 78 93 21 00 44 3B 20 00 2F 93 41 00 48 3F 40 ?? ?? 93 61 00 4C 3B 60 00 00 93 81 00 50 3F 80 ?? ?? 3B 9C ?? ?? 93 A1 00 54 7C BD 2B 78 93 E1 00 5C 7C 9F 23 78 90 01 00 64 92 21 00 24 92 41 00 28 92 61 00 2C 92 81 00 30 92 A1 00 34 92 C1 00 38 91 81 00 14 94 7E 00 08 7F C3 F3 78 7F A4 EB 78 4? ?? ?? ?? 7C 74 1B 79 41 82 00 FC 4? ?? ?? ?? 7C 75 1B 79 41 82 01 5C 2B 95 00 01 40 9D 00 38 39 35 FF FF 7C 14 48 AE 7D 74 4A 14 2F 80 00 2F 40 9E 01 54 7D 29 03 A6 48 00 00 14 8C 0B FF FF 2F 80 00 2F 40 9E 01 40 39 29 FF FF 7D 35 4B 78 42 00 FF EC 88 14 00 00 3A A0 00 01 2F 80 00 2F 40 9E 01 24 40 92 02 1C 82 77 ?? ?? 2F 93 00 00 41 9E 01 20 7E 76 9B 78 48 00 00 10 82 D6 00 00 2F 96 00 00 41 9E 01 0C 80 16 00 10 7F 80 A8 00 40 9E FF EC 80 96 00 0C 7E 83 A3 78 7E A5 AB 78 4? ?? ?? ?? 2F 83 00 00 40 9E FF D4 2F 9B 00 00 41 9E 01 C0 80 1F 00 00 7F 80 B0 00 41 BE FF 3C 7F EB FB 78 7F 69 03 A6 39 20 00 00 48 00 00 10 84 0B 00 04 7F 80 B0 00 41 9E 00 A0 39 29 00 01 42 00 FF F0 55 20 10 3A 7E DF 01 2E 3B 69 00 01 7F C3 F3 78 7F A4 EB 78 4? ?? ?? ?? 7C 74 1B 79 40 82 FF 0C 80 01 00 64 57 7B 10 3A 81 81 00 14 7F E3 FB 78 7C 08 03 A6 7E 9F D9 2E 7D 81 81 20 81 C1 00 18 81 E1 00 1C 82 01 00 20 82 21 00 24 82 41 00 28 82 61 00 2C 82 81 00 30 82 A1 00 34 82 C1 00 38 82 E1 00 3C 83 01 00 40 83 21 00 44 83 41 00 48 83 61 00 4C 83 81 00 50 83 A1 00 54 83 C1 00 58 83 E1 00 5C 38 21 00 60 4E 80 00 20 3A 9A ?? ?? 4B FF FE F0 7F 9B 48 00 40 9E FE 7C 4B FF FF 64 7F 34 A9 AE 3A B5 00 01 4B FF FE D8 41 8E 00 D8 7E 03 83 78 4? ?? ?? ?? 3A 23 00 01 3D 20 ?? ?? 82 49 ?? ?? 39 32 00 05 55 29 10 3A 38 69 00 01 91 21 00 0C 7C 63 AA 14 7C 63 8A 14 4? ?? ?? ?? 81 21 00 0C 7C 76 1B 79 41 82 00 F8 7C 76 4A 14 90 76 00 0C 7E 84 A3 78 7E A5 AB 78 4? ?? ?? ?? 99 C3 00 00 80 0F ?? ?? 92 B6 00 10 7F 95 00 40 40 9D 00 08 92 AF ?? ?? 89 34 00 00 38 00 00 00 2F 89 00 2F 41 9E 00 08 38 00 00 02 2F 92 00 00 41 9E 00 14 7E 49 03 A6 39 36 00 10 94 09 00 04 42 00 FF FC 93 16 00 04 41 8E 00 90 56 43 10 3A 38 63 00 15 7C 63 AA 14 7C 76 1A 14 7E 04 83 78 7E 25 8B 78 4? ?? ?? ?? 90 76 00 08 57 60 10 3A 92 76 00 00 3B 7B 00 01 92 D7 ?? ?? 7E DF 01 2E 4B FF FE 8C 3A 20 00 00 4B FF FF 34 38 00 00 00 3B 60 00 01 7E DF 01 2E 4B FF FE 74 88 14 00 00 2F 80 00 2F 40 9E FD 70 2F 95 00 05 41 9E 00 4C 2F 95 00 09 40 9E FD 60 3D 20 ?? ?? 80 69 ?? ?? 7E 84 A3 78 38 A0 00 09 4? ?? ?? ?? 2F 83 00 00 40 9E FD 44 4B FF FD B0 92 16 00 08 4B FF FF 90 3C C0 ?? ?? 38 60 00 0C 38 80 00 00 38 A0 00 00 38 C6 ?? ?? 4? ?? ?? ?? 7F 83 E3 78 7E 84 A3 78 38 A0 00 05 4? ?? ?? ?? 2F 83 00 00 40 9E FD 08 4B FF FD 74 }
	condition:
		$1
}

rule file_245_3_0 {
	meta:
		name = "print_search_path"
		size = 564
		refs = "008c _dl_debug_printf 00d0 mempcpy 0148 _dl_debug_printf_c 018e _dl_argv"
	strings:
		$1 = { 94 21 FF C0 7C 08 02 A6 3D 20 ?? ?? 93 A1 00 34 3F A0 ?? ?? 3B BD ?? ?? 90 01 00 44 81 7D 00 04 80 09 ?? ?? 81 21 00 00 7D 6B 02 14 92 41 00 08 38 0B 00 1E 54 00 00 36 92 61 00 0C 7C 00 00 D0 93 61 00 2C 7C 92 23 78 7C B3 2B 78 93 81 00 30 7C 7C 1B 78 3C 60 ?? ?? 93 E1 00 3C 7C 3F 0B 78 38 63 ?? ?? 92 81 00 10 92 A1 00 14 92 C1 00 18 92 E1 00 1C 93 01 00 20 93 21 00 24 93 41 00 28 93 C1 00 38 7D 21 01 6E 4C C6 31 82 4? ?? ?? ?? 81 3C 00 00 3B 61 00 17 2F 89 00 00 57 7B 00 36 41 9E 00 D8 82 89 00 04 7F 94 90 00 40 9E 00 CC 3B 40 00 01 3E A0 ?? ?? 3E C0 ?? ?? 3B 00 00 00 3A FB 00 01 80 89 00 0C 7F 63 DB 78 80 A9 00 10 4? ?? ?? ?? 80 1D 00 00 7C 79 1B 78 2F 80 00 00 41 9E 00 80 3B C0 00 00 80 1C 00 00 39 3E 00 04 55 29 10 3A 7D 20 4A 14 80 09 00 04 2F 80 00 01 41 9E 00 50 81 7D 00 08 57 C0 18 38 7F 23 CB 78 7D 2B 02 14 7C 8B 00 2E 80 A9 00 04 4? ?? ?? ?? 7F 9B 18 00 41 9E 00 E4 7F 83 B8 00 41 9E 00 D0 2F 9A 00 00 9B 03 FF FF 41 9E 00 DC 38 76 ?? ?? 7F 64 DB 78 4C C6 31 82 4? ?? ?? ?? 3B 40 00 00 80 1D 00 00 3B DE 00 01 7F 80 F0 40 41 9D FF 8C 85 3C 00 04 2F 89 00 00 41 9E 00 10 80 09 00 04 7F 80 A0 00 41 9E FF 50 2F 93 00 00 41 9E 00 A0 88 13 00 00 2F 80 00 00 40 9E 00 10 3D 20 ?? ?? 81 29 ?? ?? 82 69 00 00 3C 60 ?? ?? 38 63 ?? ?? 7E 44 93 78 7E 65 9B 78 4C C6 31 82 4? ?? ?? ?? 39 7F 00 40 80 0B 00 04 82 4B FF C8 7C 08 03 A6 82 6B FF CC 82 8B FF D0 82 AB FF D4 82 CB FF D8 82 EB FF DC 83 0B FF E0 83 2B FF E4 83 4B FF E8 83 6B FF EC 83 8B FF F0 83 AB FF F4 83 CB FF F8 83 EB FF FC 7D 61 5B 78 4E 80 00 20 88 1B 00 00 2F 80 00 2F 40 9E FF 2C 2F 9A 00 00 9B 03 00 00 40 BE FF 2C 38 75 ?? ?? 4B FF FF 28 3C 60 ?? ?? 38 63 ?? ?? 7E 44 93 78 4C C6 31 82 4? ?? ?? ?? 4B FF FF 80 }
	condition:
		$1
}

rule file_245_4_0 {
	meta:
		name = "lose"
		size = 132
		refs = "0048 __close 0050 free 006c _dl_debug_state 0080 _dl_signal_error"
	strings:
		$1 = { 2F 84 FF FF 94 21 FF E0 7C 08 02 A6 93 41 00 08 7D 3A 4B 78 93 61 00 0C 7C FB 3B 78 93 81 00 10 7C DC 33 78 93 A1 00 14 7D 1D 43 78 93 C1 00 18 7C BE 2B 78 93 E1 00 1C 7C 7F 1B 78 90 01 00 24 41 9E 00 0C 7C 83 23 78 4? ?? ?? ?? 7F 63 DB 78 4? ?? ?? ?? 7F 83 E3 78 4? ?? ?? ?? 2F 9A 00 00 41 9E 00 10 38 00 00 00 90 1A 00 0C 4? ?? ?? ?? 7F E3 FB 78 7F C4 F3 78 38 A0 00 00 7F A6 EB 78 4? ?? ?? ?? }
	condition:
		$1
}

rule file_245_5_0 {
	meta:
		name = "add_name_to_object.clone.2"
		size = 276
		refs = "0044 strcmp 0074 strlen 0080 malloc 00a4 memcpy 00f0 _dl_signal_error 0110 __assert_fail"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 93 E1 00 1C 7C 7F 1B 79 93 A1 00 14 7C 9D 23 78 90 01 00 24 93 81 00 10 93 C1 00 18 40 A2 00 18 48 00 00 48 80 1F 00 04 2F 80 00 00 41 9E 00 3C 7C 1F 03 78 80 9F 00 00 7F A3 EB 78 4? ?? ?? ?? 2F 83 00 00 40 9E FF E0 80 01 00 24 83 81 00 10 7C 08 03 A6 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 7F A3 EB 78 4? ?? ?? ?? 7C 7C 1B 78 38 63 00 0D 4? ?? ?? ?? 3B 9C 00 01 7C 7E 1B 79 41 82 00 50 2F 9F 00 00 41 9E 00 60 38 7E 00 0C 7F A4 EB 78 7F 85 E3 78 4? ?? ?? ?? 38 00 00 00 90 1E 00 04 90 1E 00 08 80 01 00 24 93 DF 00 04 7C 08 03 A6 90 7E 00 00 83 81 00 10 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 3C C0 ?? ?? 38 60 00 0C 7F A4 EB 78 38 A0 00 00 38 C6 ?? ?? 4? ?? ?? ?? 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 01 70 38 C6 ?? ?? 4? ?? ?? ?? }
	condition:
		$1
}

rule file_245_6_0 {
	meta:
		name = "_dl_map_object_from_fd"
		size = 3656
		refs = "008c _dl_debug_initialize 00a0 __fxstat64 00b2 _dl_ns 0124 __close 012c free 014a _dl_debug_mask 018c _dl_new_object 0232 _dl_pagesize 02ec _dl_next_tls_modid 0342 _dl_use_load_bias 0354 __elf_preferred_address 036c __mmap 041c memset 0816 _dl_stack_flags 0884 _dl_setup_hash 08aa _dl_profile 08e0 _dl_add_to_namespace_list 0960 __mprotect 0970 _dl_debug_state 09a0 __lseek 09b4 __libc_read 09ce _dl_initfirst 0a16 _GLOBAL_OFFSET_TABLE_ 0a1e __libc_errno 0b24 malloc 0b38 memcpy 0bb2 _dl_tls_dtv_slotinfo_list 0bc4 _dl_tls_setup 0bd0 _dl_allocate_tls 0be2 _dl_tls_max_dtv_idx 0c54 memmove 0c84 __assert_fail 0cc2 _dl_make_stack_executable_hook 0d50 _dl_debug_printf 0d98 __munmap"
	strings:
		$1 = { 94 21 FF 00 7C 08 02 A6 7D 80 00 26 90 01 01 04 93 E1 00 FC 7C 3F 0B 78 93 A1 00 F4 83 BF 01 08 92 21 00 C4 93 01 00 E0 7D 18 43 78 93 21 00 E4 7C B9 2B 78 93 41 00 E8 7C FA 3B 78 93 61 00 EC 7D 3B 4B 78 93 81 00 F0 7C 9C 23 78 7F A4 EB 78 91 81 00 B4 91 C1 00 B8 91 E1 00 BC 92 01 00 C0 92 41 00 C8 92 61 00 CC 92 81 00 D0 92 A1 00 D4 92 C1 00 D8 92 E1 00 DC 93 C1 00 F8 90 7F 00 90 38 60 00 00 90 DF 00 94 91 5F 00 A0 4? ?? ?? ?? 7C 71 1B 78 7F 84 E3 78 38 60 00 03 38 BF 00 20 4? ?? ?? ?? 2F 83 00 00 41 9C 0C 7C 1C 1D 00 4C 3D 20 ?? ?? 39 29 ?? ?? 7F C9 00 2E 2F 9E 00 00 41 9E 00 80 81 3F 00 28 81 5F 00 2C 81 7F 00 20 81 1F 00 24 48 00 00 10 83 DE 00 0C 2F 9E 00 00 41 9E 00 60 80 1E 01 98 74 07 00 04 40 A2 FF EC 80 1E 01 E8 7F 80 48 00 40 9E FF E0 80 1E 01 EC 7F 80 50 00 40 9E FF D4 80 1E 01 E0 7F 80 58 00 40 9E FF C8 80 1E 01 E4 7F 80 40 00 40 9E FF BC 7F 83 E3 78 4? ?? ?? ?? 80 7F 00 94 4? ?? ?? ?? 80 7E 00 1C 80 9F 00 90 4B FF FD B5 48 00 07 A8 73 68 00 04 40 82 09 A4 3D E0 ?? ?? 80 0F ?? ?? 70 09 00 40 40 82 0B E8 80 11 00 0C 2F 80 00 00 41 9E 08 08 2F 80 00 01 38 00 00 00 90 1F 00 A4 40 9E 0B E8 80 7F 00 94 7F 05 C3 78 80 9F 00 90 7F 46 D3 78 7F 67 DB 78 7F A8 EB 78 4? ?? ?? ?? 7C 7E 1B 79 41 82 0B E4 3A 99 00 04 81 39 00 00 A0 14 00 2C 80 94 00 1C 54 18 28 34 A0 F4 00 10 7D 78 22 14 7F 8B 48 40 81 34 00 18 90 FF 00 98 91 3E 01 58 B0 1E 01 5C 41 9D 07 B8 7F 34 22 14 A1 3E 01 5C 81 61 00 00 55 20 04 3E 90 3F 00 9C 1D 00 00 18 54 0A 28 34 7D 59 52 14 38 08 00 1E 54 00 02 B6 7F 99 50 40 7C 00 00 D0 7D 61 01 6E 3B 01 00 2F 57 18 00 36 40 9C 08 F0 3E 40 64 74 3E 00 64 74 3C 00 73 51 7F 36 CB 78 3A 60 00 00 3A E0 00 00 3A A0 00 07 62 52 E5 51 62 10 E5 52 3D C0 ?? ?? 60 00 62 40 48 00 00 3C 2F 8B 00 01 41 9E 02 68 2F 8B 00 02 40 BE 00 18 81 76 00 14 81 56 00 08 55 6B E8 FE 91 5E 00 08 B1 7E 01 5E 55 2B 2A F4 3A D6 00 20 7D 79 5A 14 7F 96 58 40 40 9C 00 A0 81 76 00 00 2F 8B 00 06 41 9E 02 D0 2B 8B 00 06 40 BD FF B8 7F 8B 90 00 41 9E 02 14 7F 8B 80 00 41 9E 01 F8 2F 8B 00 07 40 9E FF C4 81 76 00 14 2F 8B 00 00 41 BE FF B8 91 7E 02 30 81 36 00 1C 2F 89 00 00 91 3E 02 34 40 9E 02 9C 91 3E 02 38 81 76 00 08 81 5E 01 98 3C E0 40 00 81 36 00 10 55 4A 00 02 91 7E 02 28 7F 8A 38 00 91 3E 02 2C 40 9E 08 CC 90 1F 00 A8 4? ?? ?? ?? 3A D6 00 20 A1 3E 01 5C 90 7E 02 40 55 2B 2A F4 7D 79 5A 14 80 1F 00 A8 7F 96 58 40 41 9C FF 68 2F 97 00 00 41 9E 07 E4 80 9F 00 98 3A 17 FF FF 1E 10 00 18 80 18 00 00 2E 04 00 03 7D 38 82 14 82 49 00 0C 7F 16 C3 78 7E 40 90 50 40 92 08 44 3D 20 ?? ?? 80 A9 ?? ?? 7E 44 93 78 7F 43 D3 78 7C 05 28 38 4? ?? ?? ?? 80 B8 00 14 81 18 00 10 7E 44 93 78 38 C0 08 02 7F 87 E3 78 4? ?? ?? ?? 2F 83 FF FF 90 7E 01 B0 41 9E 01 08 2F 93 00 00 81 38 00 00 7C 03 92 14 7C 69 18 50 90 1E 01 B4 90 7E 00 00 40 9E 05 B8 80 1E 01 98 39 20 00 01 51 20 8B 9C 90 1E 01 98 80 B6 00 14 70 A8 00 04 40 82 01 BC 80 1E 01 54 2F 80 00 00 41 9E 01 CC 80 16 00 0C 82 76 00 08 7F 80 98 40 40 9D 00 68 3D C0 ?? ?? 82 1E 00 00 80 8E ?? ?? 7E 70 9A 14 3B 44 FF FF 7C 64 00 D0 7F 5A 9A 14 7E 10 02 14 7F 5A 18 38 7F 9A 80 40 40 9D 00 08 7E 1A 83 78 7F 93 D0 40 40 9C 00 28 70 A9 00 02 41 82 08 E4 7C B3 D0 50 7E 63 9B 78 38 80 00 00 4? ?? ?? ?? 80 B6 00 14 70 AB 00 02 41 82 08 E8 7F 90 D0 40 41 9D 05 A8 3A D6 00 18 1C 17 00 18 7C 18 02 14 7F 96 00 40 40 9C 01 88 80 96 00 04 80 16 00 00 7F 84 00 40 40 9D FF 54 80 7E 00 00 7C 80 20 50 80 B6 00 14 38 C0 08 12 81 16 00 10 7C 60 1A 14 7F 87 E3 78 4? ?? ?? ?? 2F 83 FF FF 40 9E FF 2C 3D 00 ?? ?? 39 08 ?? ?? 48 00 05 7C 81 76 00 08 91 7E 02 44 81 76 00 14 91 7E 02 48 4B FF FD C4 82 B6 00 18 4B FF FD BC 80 EE ?? ?? 81 16 00 1C 38 A7 FF FF 7C AB 40 39 40 82 06 9C 81 56 00 08 39 08 FF FF 80 D6 00 04 7D 66 50 50 7D 04 58 39 40 82 06 94 7C E7 00 D0 1D 17 00 18 7C E4 50 38 7C 98 41 2E 7D 78 42 14 3A F7 00 01 80 76 00 10 2B 97 00 01 7C 6A 1A 14 7C A3 2A 14 90 6B 00 08 7C A5 38 38 90 AB 00 04 7C E7 30 38 80 B6 00 14 90 EB 00 10 7D 45 52 14 91 4B 00 0C 40 9D 00 14 81 6B FF EC 7F 8B 20 00 41 9E 00 08 3A 60 00 01 81 76 00 18 7D 18 42 14 55 6B 16 FA 7C 0B 5E 30 55 6B 07 3E 91 68 00 14 4B FF FD 18 81 76 00 08 91 7E 01 54 4B FF FD 0C 81 76 00 08 39 29 FF FF 7D 29 58 38 91 3E 02 38 4B FF FD 60 81 36 00 04 80 1E 00 00 7C 09 02 14 90 1E 01 B8 80 1E 01 54 2F 80 00 00 40 9E FE 3C 80 16 00 10 81 34 00 1C 7F 80 48 40 41 BD FE 2C 81 76 00 00 A1 54 00 2C 81 16 00 04 7C EB 00 50 55 4A 28 34 7D 07 42 14 7D 4A 4A 14 7F 88 50 40 41 BC FE 08 7D 2B 4A 14 7C 00 48 50 90 1E 01 54 4B FF FD F8 81 3E 00 08 80 01 00 00 2F 89 00 00 80 9F 00 9C 90 04 00 00 7C 81 23 78 41 9E 04 CC 81 5E 00 00 7D 69 52 14 2F 8B 00 00 91 7E 00 08 41 9E 01 F8 7D 29 50 2E 38 9E 00 20 2F 89 00 00 41 9E 00 80 3C E0 6F FF 3C 60 6F FF 3F 40 6F FF 3C C0 70 00 3D 00 70 00 60 E7 FF FF 38 A0 FF FC 60 63 FD FF 63 5A FE FF 60 C6 00 22 48 00 00 1C 39 29 00 08 55 29 10 3A 7D 7E 49 2E 85 2B 00 08 2F 89 00 00 41 9E 00 3C 2B 89 00 21 40 BD FF E4 7F 89 40 00 41 9E 04 0C 7C 09 38 50 2B 80 00 0F 41 9D 03 DC 7D 29 30 50 38 09 00 08 54 00 10 3A 7D 7E 01 2E 85 2B 00 08 2F 89 00 00 40 9E FF CC 2F 8A 00 00 41 9E 00 C4 81 3E 00 30 2F 89 00 00 41 9E 00 10 80 09 00 04 7C 00 52 14 90 09 00 04 81 3E 00 2C 2F 89 00 00 41 9E 00 10 80 09 00 04 7C 00 52 14 90 09 00 04 81 3E 00 34 2F 89 00 00 41 9E 00 10 80 09 00 04 7C 00 52 14 90 09 00 04 81 3E 00 38 2F 89 00 00 41 9E 00 10 80 09 00 04 7C 00 52 14 90 09 00 04 81 3E 00 3C 2F 89 00 00 41 9E 00 10 80 09 00 04 7C 00 52 14 90 09 00 04 81 3E 00 7C 2F 89 00 00 41 9E 00 10 80 09 00 04 7C 00 52 14 90 09 00 04 81 3E 00 E8 2F 89 00 00 41 9E 00 10 80 09 00 04 7C 00 52 14 90 09 00 04 81 3E 01 50 2F 89 00 00 41 9E 00 10 80 09 00 04 7D 40 52 14 91 49 00 04 81 3E 00 70 2F 89 00 00 41 9E 00 10 80 09 00 04 2F 80 00 07 40 9E 05 04 80 1E 00 3C 2F 80 00 00 41 9E 00 14 81 3E 00 44 80 09 00 04 2F 80 00 0C 40 9E 05 08 81 3E 00 98 2F 89 00 00 41 9E 00 30 80 09 00 04 70 0B 00 02 90 1E 02 10 41 82 00 08 91 3E 00 60 70 04 00 04 41 82 00 08 91 3E 00 78 70 07 00 08 41 82 00 08 91 3E 00 80 81 3E 00 BC 2F 89 00 00 41 9E 00 18 80 09 00 04 70 08 00 01 90 1E 02 0C 41 82 00 08 91 3E 00 80 80 1E 00 94 2F 80 00 00 41 9E 00 0C 38 00 00 00 90 1E 00 5C 80 1E 02 0C 70 09 00 40 40 82 05 8C 80 1E 01 54 2F 80 00 00 41 9E 03 14 81 3E 00 00 7C 00 4A 14 90 1E 01 54 3D 20 ?? ?? 80 09 ?? ?? 7E B5 00 78 72 A0 00 01 40 82 04 84 80 1E 02 28 2F 80 00 00 41 9E 00 10 81 3E 00 00 7C 00 4A 14 90 1E 02 28 7F 83 E3 78 4? ?? ?? ?? 2C 03 00 00 40 82 04 98 80 1E 01 98 3D 20 40 00 54 0B 00 02 7F 8B 48 00 41 9E 01 CC 81 2F ?? ?? 80 1E 01 58 71 27 00 40 80 FE 00 00 7C 07 02 14 90 1E 01 58 40 82 05 58 7F C3 F3 78 4? ?? ?? ?? 73 68 00 08 40 82 00 10 80 1E 00 60 2F 80 00 00 40 9E 03 88 80 1E 02 0C 70 09 00 20 40 82 01 28 3D 20 ?? ?? 81 5F 00 24 80 09 ?? ?? 81 3F 00 20 2F 80 00 00 91 5E 01 E4 91 3E 01 E0 81 5F 00 2C 81 3F 00 28 91 5E 01 EC 91 3E 01 E8 40 9E 05 4C 7F C3 F3 78 7F A4 EB 78 4? ?? ?? ?? 39 7F 01 00 80 0B 00 04 7F C3 F3 78 81 8B FF B4 7C 08 03 A6 81 CB FF B8 81 EB FF BC 7D 80 81 20 82 0B FF C0 82 2B FF C4 82 4B FF C8 82 6B FF CC 82 8B FF D0 82 AB FF D4 82 CB FF D8 82 EB FF DC 83 0B FF E0 83 2B FF E4 83 4B FF E8 83 6B FF EC 83 8B FF F0 83 AB FF F4 83 CB FF F8 83 EB FF FC 7D 61 5B 78 4E 80 00 20 80 18 00 04 38 A0 00 00 7C 98 80 2E 7C 63 02 14 7C 80 20 50 4? ?? ?? ?? 4B FF FA 34 38 00 00 01 90 11 00 0C 4? ?? ?? ?? 39 60 00 01 91 7F 00 A4 4B FF F7 F8 38 18 00 1E 81 21 00 00 54 00 02 B6 7C 00 00 D0 7D 21 01 6E 38 A0 00 00 7F 83 E3 78 3B 21 00 2F 4? ?? ?? ?? 57 39 00 36 7F 83 E3 78 7F 24 CB 78 7F 05 C3 78 4? ?? ?? ?? 7F 83 C0 00 41 9E F8 14 3D 00 ?? ?? 39 08 ?? ?? 48 00 00 4C 3D 20 ?? ?? 93 C9 ?? ?? 4B FF FE D4 80 B6 00 14 7F 43 D3 78 7C 9A 80 50 38 C0 00 32 38 E0 FF FF 39 00 00 00 4? ?? ?? ?? 2F 83 FF FF 40 9E FA 3C 3D 00 ?? ?? 39 08 ?? ?? 80 01 00 00 81 3F 00 9C 90 09 00 00 7D 21 4B 78 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 80 69 00 00 48 00 00 98 80 9F 00 98 2F 84 00 02 40 9E FE 30 50 60 F0 02 90 1E 01 98 4B FF FE 24 55 38 08 3C 7F 18 0E 70 7F 98 28 40 40 9D 00 20 39 38 00 01 1D 29 FF FC 7D 24 4A 14 91 69 00 CC 4B FF FB E0 91 7E 00 A8 4B FF FB D8 7C 09 18 50 2B 80 00 0B 41 9D 00 18 3D 29 10 00 38 09 01 CB 1C 00 FF FC 7D 64 01 2E 4B FF FB B8 7C 09 D0 50 2B 80 00 0A 41 BD FB AC 3D 29 10 00 38 09 00 BF 1C 00 FF FC 7D 64 01 2E 4B FF FB 98 40 92 FD 40 3D 00 ?? ?? 38 60 00 00 39 08 ?? ?? 80 9F 00 A4 2F 84 00 00 40 9E 00 08 3A 20 00 00 80 BF 00 90 7F 84 E3 78 80 DF 00 94 7F C7 F3 78 7E 29 8B 78 4B FF F3 85 7F 83 E3 78 4? ?? ?? ?? 3B C0 00 00 4B FF FD F0 3D 00 ?? ?? 38 60 00 00 39 08 ?? ?? 80 01 00 00 80 FF 00 9C 90 07 00 00 7C E1 3B 78 4B FF FF AC A3 54 00 2C 57 5A 28 34 7F 43 D3 78 4? ?? ?? ?? 2F 83 00 00 41 9E 00 48 7F 24 CB 78 7F 45 D3 78 4? ?? ?? ?? 80 1E 01 98 39 20 00 01 90 7E 01 54 51 20 C1 CE 90 1E 01 98 4B FF FC C4 3D 00 ?? ?? 38 60 00 00 39 08 ?? ?? 4B FF FF A4 3D 00 ?? ?? 38 60 00 00 39 08 ?? ?? 4B FF FF 94 3D 00 ?? ?? 39 08 ?? ?? 4B FF FE 98 77 67 20 00 41 82 00 7C 81 7E 00 00 6A 73 00 01 81 3E 01 98 7C 00 5A 14 7D 60 92 14 90 1E 01 B0 52 69 8B 9C 91 7E 01 B4 91 3E 01 98 4B FF F8 8C 3D 00 ?? ?? 81 28 ?? ?? 2F 89 00 00 40 9E F7 2C 90 1F 00 A8 4? ?? ?? ?? 2F 83 00 00 40 9E 00 44 4? ?? ?? ?? 80 1F 00 A8 2C 03 00 00 41 82 00 34 3D 60 ?? ?? 81 2B ?? ?? 38 43 70 00 39 29 00 01 91 2B ?? ?? 91 3E 02 40 A1 3E 01 5C 4B FF F6 64 3D 00 ?? ?? 38 60 00 00 39 08 ?? ?? 4B FF FE F8 3D 00 ?? ?? 38 60 00 0C 39 08 ?? ?? 4B FF FE E8 80 9E 01 D0 38 1E 01 60 81 24 00 00 7F 89 00 00 41 BE FC 6C 81 3E 01 68 38 00 00 01 80 BE 01 CC 38 64 00 04 93 C9 00 00 54 A5 10 3A 90 1E 01 6C 38 A5 FF FC 4? ?? ?? ?? 81 3E 01 D0 38 1E 01 68 90 09 00 00 4B FF FC 38 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 00 BB 38 C6 ?? ?? 4? ?? ?? ?? 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 00 C3 38 C6 ?? ?? 4? ?? ?? ?? 3D 20 ?? ?? 80 7F 00 A0 39 29 ?? ?? 80 09 00 0C 60 00 00 07 90 09 00 0C 3D 20 ?? ?? 80 09 ?? ?? 7C 09 03 A6 4E 80 04 21 2C 03 00 00 41 82 FB 54 3D 00 ?? ?? 39 08 ?? ?? 4B FF FD E0 3D 00 ?? ?? 39 08 ?? ?? 4B FF FD 28 7C 63 98 38 60 A5 00 02 4? ?? ?? ?? 2F 83 00 00 40 9C F7 10 3D 00 ?? ?? 39 08 ?? ?? 4B FF FC F8 80 8E ?? ?? 7C 64 00 D0 7C 63 98 38 4? ?? ?? ?? 4B FF F7 0C 38 00 00 00 3D 00 ?? ?? 90 1F 00 A4 39 08 ?? ?? 3B C0 00 00 4B FF FC DC 3C 60 ?? ?? 80 9F 00 90 38 63 ?? ?? 7F A5 EB 78 4C C6 31 82 4? ?? ?? ?? 4B FF F4 04 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 03 BA 38 C6 ?? ?? 4? ?? ?? ?? 3D 00 ?? ?? 39 08 ?? ?? 4B FF FC 94 2F 9B 00 00 40 9C FA 74 80 7E 01 B0 80 9E 01 B4 7C 83 20 50 4? ?? ?? ?? 80 7E 00 1C 80 03 00 08 2F 80 00 00 40 BE 00 08 4? ?? ?? ?? 80 1E 01 98 74 0B 01 00 41 A2 00 0C 80 7E 01 54 4? ?? ?? ?? 3D 00 ?? ?? 38 60 00 00 39 08 ?? ?? 4B FF FC F0 39 20 00 08 80 BE 00 08 91 21 00 0C 3C 60 ?? ?? 38 63 ?? ?? 90 01 00 08 38 80 00 08 38 C0 00 08 80 1E 01 54 39 00 00 08 91 21 00 14 39 40 00 08 7E 49 93 78 90 01 00 10 A0 1E 01 5C 90 01 00 18 4C C6 31 82 4? ?? ?? ?? 4B FF FA 64 81 3E 00 58 2F 89 00 00 41 BE FA B0 81 7E 00 34 80 09 00 04 80 8B 00 04 80 7E 00 1C 7C 84 02 14 4B FF F0 AD 4B FF FA 94 }
	condition:
		$1
}

rule file_245_7_0 {
	meta:
		name = "open_verify.clone.3"
		size = 1340
		refs = "005c __open 006e _GLOBAL_OFFSET_TABLE_ 0076 __libc_errno 0090 __libc_read 00b8 memcmp 0212 _dl_osversion 02cc __close 030c __lseek 046c strlen 0498 memcpy 04a4 free"
	strings:
		$1 = { 94 21 FF B0 7C 08 02 A6 93 C1 00 48 7C 9E 23 78 38 80 00 00 93 E1 00 4C 7C 3F 0B 78 92 81 00 20 7C D4 33 78 92 C1 00 28 93 81 00 40 7C 7C 1B 78 93 A1 00 44 7C BD 2B 78 90 01 00 54 92 61 00 1C 92 A1 00 24 92 E1 00 2C 93 01 00 30 93 21 00 34 93 41 00 38 93 61 00 3C 4C C6 31 82 4? ?? ?? ?? 2F 83 FF FF 7C 76 1B 78 41 9E 01 D8 3E A0 ?? ?? 3A B5 ?? ?? 83 55 ?? ?? 38 00 00 00 7F 5A 12 14 90 1A 00 00 3B 1E 00 04 7F 04 C3 78 38 A0 02 00 4? ?? ?? ?? 2F 83 00 33 90 7E 00 00 7C 7B 1B 78 40 9D 02 F4 3F 40 ?? ?? 3B 5A ?? ?? 7F 03 C3 78 38 9A 00 10 38 A0 00 08 4? ?? ?? ?? 2F 83 00 00 40 9E 02 B8 88 18 00 08 2F 80 00 00 40 9E 01 C0 38 78 00 09 38 9A 00 19 38 A0 00 07 4? ?? ?? ?? 2F 83 00 00 40 9E 01 BC 80 18 00 14 2F 80 00 01 40 9E 02 F4 A0 18 00 12 2F 80 00 14 40 9E 01 C8 A0 18 00 10 2F 80 00 03 40 9E 02 EC A0 18 00 2A 2F 80 00 20 40 9E 03 14 A1 38 00 2C 80 98 00 1C 55 3D 2A F4 7C 1D 22 14 7F 80 D8 40 7F 38 22 14 41 9D 02 04 7F B9 EA 14 7F 99 E8 40 40 9C 01 04 7F 3D CB 78 3E 60 ?? ?? 48 00 00 18 55 20 2A F4 3B BD 00 20 7C 19 02 14 7F 9D 00 40 40 9C 00 E4 80 1D 00 00 2F 80 00 04 40 9E FF E4 83 5D 00 10 2B 9A 00 1F 40 BD FF D8 80 1D 00 1C 2B 80 00 03 40 BD FF CC 80 9D 00 04 80 1E 00 00 7D 24 D2 14 7F 89 00 40 41 9D 01 58 7F 78 22 14 3A F3 ?? ?? 48 00 00 38 81 3B 00 00 81 7B 00 04 39 29 00 03 55 29 00 3A 38 0B 00 03 39 29 00 0C 54 00 00 3A 7C 09 02 14 39 3A FF E0 7F 80 48 40 41 9D 01 18 7F 40 D0 50 7F 7B 02 14 7F 63 DB 78 7E E4 BB 78 38 A0 00 10 4? ?? ?? ?? 2F 83 00 00 40 9E FF B8 2F 9A 00 00 41 9E 00 F0 80 1B 00 10 81 1B 00 14 2F 80 00 00 81 5B 00 18 81 7B 00 1C 40 9E 00 B8 3D 20 ?? ?? 80 09 ?? ?? 2F 80 00 00 41 9E 00 24 55 09 44 2E 55 4A 06 3E 7D 29 52 14 55 29 40 2E 55 6B 06 3E 7D 69 5A 14 7F 8B 00 40 41 9D 00 88 39 7F 00 50 80 0B 00 04 7E C3 B3 78 82 6B FF CC 7C 08 03 A6 82 8B FF D0 82 AB FF D4 82 CB FF D8 82 EB FF DC 83 0B FF E0 83 2B FF E4 83 4B FF E8 83 6B FF EC 83 8B FF F0 83 AB FF F4 83 CB FF F8 83 EB FF FC 7D 61 5B 78 4E 80 00 20 89 38 00 07 2F 89 00 03 40 9E 00 0C 2B 80 00 02 40 9D FE 34 81 3E 00 04 6D 20 7F 45 2F 80 4C 46 40 9E 01 A8 88 18 00 04 2F 80 00 01 41 9E 01 54 38 00 00 01 98 1D 00 00 7E C3 B3 78 82 B5 ?? ?? 4? ?? ?? ?? 7E B5 12 14 38 00 00 02 90 15 00 00 3A C0 FF FF 4B FF FF 60 A1 38 00 2C 4B FF FE 64 38 1A 00 1E 81 21 00 00 54 00 00 36 7C 00 00 D0 7D 21 01 6E 38 A0 00 00 7E C3 B3 78 3B 61 00 17 4? ?? ?? ?? 57 7B 00 36 7E C3 B3 78 7F 64 DB 78 7F 45 D3 78 4? ?? ?? ?? 7F 9A 18 00 40 9E 00 A4 3A F3 ?? ?? 4B FF FE A8 81 21 00 00 20 1D FF F0 38 A0 00 00 7D 21 01 6E 7E C3 B3 78 3B 21 00 17 4? ?? ?? ?? 57 39 00 36 7E C3 B3 78 7F 24 CB 78 7F A5 EB 78 4? ?? ?? ?? 7F 9D 18 00 40 9E 00 64 A1 38 00 2C 55 3D 2A F4 4B FF FD C0 7F 03 C3 78 38 9A 00 20 38 A0 00 08 4? ?? ?? ?? 2F 83 00 00 41 9E FD 38 4B FF FF 10 83 DA 00 00 2F 9E 00 00 40 9E 00 3C 3D 00 ?? ?? 39 08 ?? ?? 2F 94 00 00 40 9E 00 B8 7F C3 F3 78 7E C4 B3 78 7F 85 E3 78 38 C0 00 00 38 E0 00 00 39 20 00 00 4B FF EC 59 81 35 ?? ?? 7D 29 12 14 83 C9 00 00 3D 00 ?? ?? 39 08 ?? ?? 4B FF FF C8 3D 00 ?? ?? 3B C0 00 00 39 08 ?? ?? 4B FF FF B8 2F 80 00 02 41 9E FD 14 3D 00 ?? ?? 3B C0 00 00 39 08 ?? ?? 4B FF FF A0 88 18 00 05 2F 80 00 02 41 9E 00 24 3D 00 ?? ?? 3B C0 00 00 39 08 ?? ?? 4B FF FF 84 3D 00 ?? ?? 3B C0 00 00 39 08 ?? ?? 4B FF FF 74 88 18 00 06 2F 80 00 01 41 9E 00 74 3D 00 ?? ?? 3B C0 00 00 39 08 ?? ?? 4B FF FF 58 3D 00 ?? ?? 3B C0 00 00 39 08 ?? ?? 4B FF FF 48 7F 83 E3 78 91 1F 00 08 4? ?? ?? ?? 7F 84 E3 78 38 03 00 1F 81 21 00 00 54 00 00 36 7C 00 00 D0 7D 21 01 6E 7C 65 1B 78 38 A5 00 01 38 61 00 17 54 63 00 36 4? ?? ?? ?? 7C 7D 1B 78 7F 83 E3 78 4? ?? ?? ?? 7F BC EB 78 81 1F 00 08 4B FF FF 00 88 18 00 07 2F 80 00 00 41 9E 00 1C 2F 80 00 03 41 9E 00 14 3D 00 ?? ?? 3B C0 00 00 39 08 ?? ?? 4B FF FE D4 89 38 00 08 2F 89 00 00 41 9E 00 24 2F 80 00 03 41 9E 00 14 3D 00 ?? ?? 3B C0 00 00 39 08 ?? ?? 4B FF FE B0 2B 89 00 02 41 BD FF EC 38 78 00 09 38 9A 00 19 38 A0 00 07 4? ?? ?? ?? 2F 83 00 00 41 9E 00 14 3D 00 ?? ?? 3B C0 00 00 39 08 ?? ?? 4B FF FE 80 3D 00 ?? ?? 3B C0 00 00 39 08 ?? ?? 4B FF FE 70 }
	condition:
		$1
}

rule file_245_8_0 {
	meta:
		name = "open_path.clone.4"
		size = 1104
		refs = "00ca _GLOBAL_OFFSET_TABLE_ 00d2 __libc_errno 00ee _dl_debug_mask 0118 mempcpy 0206 _dl_ns 0240 __xstat64 0324 malloc 0340 memcpy 037a __libc_enable_secure 0398 __fxstat64 03b8 __close 03dc _dl_debug_printf 03f8 free"
	strings:
		$1 = { 94 21 FF 20 7C 08 02 A6 7D 80 00 26 90 01 00 E4 38 00 FF FF 91 C1 00 98 81 C6 00 00 93 E1 00 DC 7C 3F 0B 78 2F 8E 00 00 92 01 00 A0 7D 50 53 78 93 41 00 C8 7D 3A 4B 78 93 61 00 CC 7D 1B 43 78 93 81 00 D0 7C FC 3B 78 93 A1 00 D4 7C 7D 1B 78 93 C1 00 D8 7C 9E 23 78 91 E1 00 9C 92 21 00 A4 92 41 00 A8 92 61 00 AC 92 81 00 B0 92 A1 00 B4 92 C1 00 B8 92 E1 00 BC 93 01 00 C0 93 21 00 C4 91 81 00 94 90 DF 00 80 41 9E 02 2C 3E C0 ?? ?? 82 EE 00 00 3D 20 ?? ?? 3A D6 ?? ?? 80 09 ?? ?? 81 76 00 04 2D 85 00 00 81 21 00 00 2D 1A 00 00 7D 6B 02 14 7D 6B 22 14 38 0B 00 1E 54 00 00 36 7C 00 00 D0 7D 21 01 6E 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 38 00 00 00 91 3F 00 78 7C 89 20 F8 3A 81 00 17 90 1F 00 84 3E 60 ?? ?? 91 3F 00 7C 56 94 00 36 39 E0 00 00 3A 73 ?? ?? 80 13 00 00 70 0B 00 01 40 82 03 10 80 97 00 0C 7E 83 A3 78 80 B7 00 10 4? ?? ?? ?? 80 16 00 00 7C 72 1B 78 2F 80 00 00 41 9E 02 48 3A F7 00 10 3B 20 00 00 3B 00 00 01 3A A0 00 00 84 17 00 04 2F 80 00 01 41 9E 00 78 81 76 00 08 7E 43 93 78 7D 2B CA 14 7C 8B C8 2E 80 A9 00 04 4? ?? ?? ?? 7F A4 EB 78 7F C5 F3 78 4? ?? ?? ?? 80 13 00 00 7E 34 18 50 70 09 00 01 40 82 02 54 7E 83 A3 78 7F 64 DB 78 7E 05 83 78 38 C0 00 00 4B FF F9 39 81 37 00 00 7C 60 1B 78 2F 89 00 00 40 9E 00 3C 2E 03 FF FF 41 92 00 58 39 20 00 02 91 37 00 00 62 B5 00 01 40 8E 01 C4 40 92 01 64 80 16 00 00 39 38 00 01 3B 39 00 08 7F 98 00 40 40 9C 00 B4 7D 38 4B 78 4B FF FF 68 2E 03 FF FF 69 29 00 01 7D 29 00 34 55 29 D9 7E 69 29 00 01 7E B5 4B 78 41 B2 FF CC 41 8E FF C4 48 00 01 80 41 8A 00 28 81 3A 00 18 3D 60 ?? ?? 39 6B ?? ?? 1D 29 00 4C 7D 2B 48 2E 38 00 00 01 81 29 01 98 75 2B 00 10 40 82 00 48 81 3F 00 7C 38 00 00 00 7E 34 8A 14 7C 11 49 AE 38 60 00 03 7E 84 A3 78 38 BF 00 08 4? ?? ?? ?? 2F 83 00 00 40 9E 00 14 80 1F 00 18 54 00 04 26 2F 80 40 00 41 9E 00 F4 38 00 00 01 90 17 00 00 38 00 00 00 7E B5 03 78 80 16 00 00 39 38 00 01 3B 39 00 08 7F 98 00 40 41 9C FF 54 2F 95 00 00 41 9E 00 14 81 7F 00 78 80 0B 00 00 2F 80 00 02 40 9E 00 CC 86 EE 00 04 7D EF AB 78 2F 97 00 00 40 9E FE 5C 2F 8F 00 00 38 00 FF FF 41 9E 01 34 39 7F 00 E0 7C 03 03 78 80 0B 00 04 81 8B FF B4 7C 08 03 A6 81 CB FF B8 81 EB FF BC 7D 83 81 20 82 0B FF C0 82 2B FF C4 82 4B FF C8 82 6B FF CC 82 8B FF D0 82 AB FF D4 82 CB FF D8 82 EB FF DC 83 0B FF E0 83 2B FF E4 83 4B FF E8 83 6B FF EC 83 8B FF F0 83 AB FF F4 83 CB FF F8 83 EB FF FC 7D 61 5B 78 4E 80 00 20 7E 23 8B 78 90 1F 00 88 4? ?? ?? ?? 2F 83 00 00 90 7C 00 00 80 1F 00 88 41 9E 01 0C 7E 84 A3 78 7E 25 8B 78 4? ?? ?? ?? 80 1F 00 88 4B FF FF 6C 38 00 00 02 90 17 00 00 38 00 00 01 7E B5 03 78 4B FF FF 10 2F 80 00 0D 41 9E FF 34 38 00 FF FF 4B FF FF 48 3A A0 00 00 4B FF FF 24 3D 60 ?? ?? 81 2B ?? ?? 2F 89 00 00 41 9E FE 34 7C 04 03 78 90 1F 00 88 38 60 00 03 38 BF 00 08 4? ?? ?? ?? 80 1F 00 88 2F 83 00 00 40 9E 00 10 81 3F 00 18 71 2B 08 00 40 A2 FE 08 7C 03 03 78 4? ?? ?? ?? 81 3F 00 78 38 00 00 02 90 09 00 00 4B FF FD F4 3D 60 ?? ?? 80 6B ?? ?? 7E 84 A3 78 4C C6 31 82 4? ?? ?? ?? 4B FF FD 9C 81 3F 00 80 80 09 00 04 2F 80 00 00 41 BE 00 0C 80 69 00 00 4? ?? ?? ?? 81 7F 00 80 3A D6 00 10 38 00 FF FF 7F 8B B0 00 41 9E FE A8 90 0B 00 00 4B FF FE A0 83 37 00 04 80 1F 00 84 7F 99 00 00 41 BE FC E8 80 B7 00 08 7D C3 73 78 7F 24 CB 78 4B FF E4 7D 93 3F 00 84 4B FF FC D0 7C 03 03 78 4? ?? ?? ?? 38 00 FF FF 4B FF FE 68 }
	condition:
		$1
}

rule file_245_9_0 {
	meta:
		name = "add_path.8951.clone.1.clone.5"
		size = 308
		refs = "00cc mempcpy"
	strings:
		$1 = { 2F 83 FF FF 94 21 FF E0 7C 08 02 A6 93 E1 00 1C 7D 7F 5B 78 90 01 00 24 93 41 00 08 93 61 00 0C 93 81 00 10 93 A1 00 14 93 C1 00 18 41 9E 00 CC 81 23 00 00 7C 7E 1B 78 3B 40 00 00 3B 60 00 00 48 00 00 3C 80 09 00 10 81 3F 00 08 2B 80 00 02 81 69 00 04 39 6B 00 01 91 69 00 04 40 9C 00 08 38 00 00 02 81 69 00 00 7C 0B 02 14 90 09 00 00 85 3E 00 04 2F 89 00 00 41 9E 00 80 88 1F 00 0C 2F 80 00 00 40 BE FF C0 80 A9 00 10 81 5F 00 04 2B 85 00 01 83 9F 00 08 7C A0 00 34 81 7F 00 00 55 5D 18 38 54 00 D9 7E 39 4A 00 01 7D 1C EA 14 91 5F 00 04 20 00 00 2F 38 A5 FF FF 91 68 00 08 7D 63 5B 78 40 9D 00 5C 80 89 00 0C 4? ?? ?? ?? 90 7F 00 00 9B 43 00 00 7F BC EA 14 81 3F 00 00 38 09 00 01 85 3E 00 04 90 1F 00 00 2F 89 00 00 93 7D 00 0C 40 9E FF 88 80 01 00 24 83 41 00 08 7C 08 03 A6 83 61 00 0C 83 81 00 10 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 98 0B 00 00 80 7F 00 00 38 63 00 01 90 7F 00 00 4B FF FF A4 }
	condition:
		$1
}

rule file_245_10_0 {
	meta:
		name = "expand_dynamic_string_token"
		size = 412
		refs = "002c strchr 0060 _dl_dst_count 0070 strlen 009c _dl_get_origin 00c2 _dl_platformlen 00f8 malloc 012c _dl_dst_substitute 017c __assert_fail"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 93 E1 00 1C 7C 9F 23 78 38 80 00 24 93 C1 00 18 7C 7E 1B 78 7F E3 FB 78 90 01 00 24 93 81 00 10 93 A1 00 14 4? ?? ?? ?? 2F 83 00 00 40 9E 00 28 80 01 00 24 7F E3 FB 78 83 81 00 10 7C 08 03 A6 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4B FF DB 84 38 80 00 01 4? ?? ?? ?? 7C 7C 1B 79 41 A2 FF D0 7F E3 FB 78 4? ?? ?? ?? 2F 9E 00 00 7C 7D 1B 78 41 9E 01 04 80 7E 01 AC 2F 83 00 00 40 9E 00 A8 81 3E 00 04 88 09 00 00 2F 80 00 00 40 9E 00 C8 4? ?? ?? ?? 38 00 FF FD 39 63 FF FF 90 7E 01 AC 7F 8B 00 40 38 00 00 00 41 9D 00 0C 4? ?? ?? ?? 7C 60 1B 78 3D 20 ?? ?? 81 29 ?? ?? 2B 89 00 03 40 9C 00 08 39 20 00 03 7F 89 00 40 40 9C 00 08 7C 09 03 78 2B 89 00 04 40 9D 00 10 39 29 FF FC 7F 89 E1 D6 7F BD E2 14 38 7D 00 01 4? ?? ?? ?? 7C 65 1B 79 41 82 00 40 80 01 00 24 7F C3 F3 78 7F E4 FB 78 83 81 00 10 7C 08 03 A6 83 A1 00 14 83 C1 00 18 38 C0 00 01 83 E1 00 1C 38 21 00 20 4? ?? ?? ?? 2F 83 FF FF 38 00 00 00 40 9E FF 80 4B FF FF 84 80 01 00 24 83 81 00 10 7C 08 03 A6 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 01 4B 38 C6 ?? ?? 4? ?? ?? ?? 4? ?? ?? ?? 38 00 FF FD 39 23 FF FF 7F 89 00 40 38 00 00 00 41 BD FF 2C 4B FF FF 20 }
	condition:
		$1
}

rule file_245_11_0 {
	meta:
		name = "cache_rpath"
		size = 576
		refs = "007e _dl_inhibit_rpath 00e8 malloc 0118 free 01bc _dl_signal_error 01ce __libc_enable_secure"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 90 01 00 24 80 04 00 00 93 61 00 0C 7C DB 33 78 2F 80 FF FF 93 E1 00 1C 7C 9F 23 78 93 81 00 10 93 A1 00 14 93 C1 00 18 41 9E 01 24 2F 80 00 00 38 00 00 01 41 9E 00 2C 7C 03 03 78 80 01 00 24 83 61 00 0C 7C 08 03 A6 83 81 00 10 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 38 A5 00 08 54 A5 10 3A 7D 23 28 2E 2F 89 00 00 41 9E 01 18 3D 60 ?? ?? 81 43 00 34 81 6B ?? ?? 80 0A 00 04 2F 8B 00 00 80 89 00 04 83 83 00 04 40 9E 01 34 7C 84 02 14 4B FF FD C5 7C 7E 1B 79 41 82 01 18 88 1E 00 00 38 60 00 08 2F 80 00 00 41 9E 00 30 7F CB F3 78 39 20 00 00 68 0A 00 3A 21 4A 00 00 7D 49 01 94 8C 0B 00 01 2F 80 00 00 7D 49 53 78 40 9E FF E8 39 2A 00 02 55 23 10 3A 4? ?? ?? ?? 7C 7D 1B 79 41 82 00 B0 3C A0 ?? ?? 7F A4 EB 78 7F 67 DB 78 7F 88 E3 78 38 A5 ?? ?? 38 C0 00 00 7F C3 F3 78 4B FF D9 91 7F C3 F3 78 4? ?? ?? ?? 38 00 00 01 7C 03 03 78 80 01 00 24 39 20 00 01 93 BF 00 00 7C 08 03 A6 91 3F 00 04 83 61 00 0C 83 81 00 10 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 38 00 00 00 83 61 00 0C 7C 03 03 78 80 01 00 24 83 81 00 10 7C 08 03 A6 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 2F 88 00 00 41 9E 00 0C 2F 88 00 3A 40 BE 00 8C 38 00 FF FF 90 1F 00 00 38 00 00 00 4B FF FE A4 7F C3 F3 78 4? ?? ?? ?? 3C C0 ?? ?? 38 C6 ?? ?? 38 60 00 0C 38 80 00 00 38 A0 00 00 4? ?? ?? ?? 3C C0 ?? ?? 38 C6 ?? ?? 4B FF FF E8 3D 20 ?? ?? 81 29 ?? ?? 2F 89 00 00 40 BE FE C4 7F 8A E3 78 89 2B 00 00 48 00 00 14 2F 88 00 00 41 BE FF A4 8D 2B 00 01 39 4A 00 01 88 EA 00 00 55 28 06 3E 7F 88 38 00 41 9E FF E4 2F 87 00 00 40 BE 00 0C 4B FF FF 70 89 2B 00 00 71 29 00 FF 41 A2 FE 80 2F 89 00 3A 39 6B 00 01 40 9E FF EC 89 2B 00 00 71 2A 00 FF 41 A2 FE 68 7F 8A E3 78 4B FF FF BC }
	condition:
		$1
}

rule file_245_12_0 {
	meta:
		name = "_dl_dst_count"
		size = 268
		refs = "000a __libc_enable_secure 0088 strchr"
	strings:
		$1 = { 94 21 FF D0 7C 08 02 A6 3D 20 ?? ?? 93 01 00 10 3F 00 ?? ?? 3B 18 ?? ?? 93 21 00 14 3F 20 ?? ?? 3B 39 ?? ?? 93 41 00 18 93 61 00 1C 3F 60 ?? ?? 3B 7B ?? ?? 90 01 00 34 93 E1 00 2C 83 49 ?? ?? 93 81 00 20 7C 9C 23 78 93 A1 00 24 7C 7D 1B 78 93 C1 00 28 3B C0 00 00 3B E3 00 01 7F E4 FB 78 7F 65 DB 78 7F 86 E3 78 7F 47 D3 78 7F A3 EB 78 4B FF DD CD 2C 03 00 00 41 82 00 50 3B DE 00 01 7C 7F 1A 14 38 80 00 24 4? ?? ?? ?? 2C 03 00 00 40 82 FF C8 80 01 00 34 7F C3 F3 78 83 01 00 10 7C 08 03 A6 83 21 00 14 83 41 00 18 83 61 00 1C 83 81 00 20 83 A1 00 24 83 C1 00 28 83 E1 00 2C 38 21 00 30 4E 80 00 20 7F E4 FB 78 7F 25 CB 78 7F 86 E3 78 38 E0 00 00 7F A3 EB 78 4B FF DD 61 2C 03 00 00 40 82 FF 98 7F E4 FB 78 7F 05 C3 78 7F 86 E3 78 38 E0 00 00 7F A3 EB 78 4B FF DD 41 2C 03 00 00 41 A2 FF 7C 4B FF FF 74 }
	condition:
		$1
}

rule file_245_13_0 {
	meta:
		name = "_dl_dst_substitute"
		size = 584
		refs = "0026 __libc_enable_secure 005e _dl_platform 01dc stpcpy 0214 _dl_get_origin"
	strings:
		$1 = { 94 21 FF B0 7D 80 00 26 7C 08 02 A6 2E 06 00 00 92 21 00 14 2D 83 00 00 3E 20 ?? ?? 92 41 00 18 3A 31 ?? ?? 3E 40 ?? ?? 92 61 00 1C 3A 60 00 24 92 81 00 20 3A 80 FF FD 92 A1 00 24 3E A0 ?? ?? 3A B5 ?? ?? 92 C1 00 28 3E C0 ?? ?? 3A D6 ?? ?? 92 E1 00 2C 3E E0 ?? ?? 93 01 00 30 3F 00 ?? ?? 93 21 00 34 7C 79 1B 78 93 41 00 38 7C DA 33 78 93 61 00 3C 7C BB 2B 78 93 81 00 40 7C 9C 23 78 93 A1 00 44 7C BD 2B 78 93 C1 00 48 7C 9E 23 78 93 E1 00 4C 7C BF 2B 78 90 01 00 54 92 01 00 10 91 81 00 0C 88 04 00 00 2F 80 00 24 41 9E 00 98 98 1F 00 00 3B DE 00 01 3B FF 00 01 40 92 00 74 88 1E 00 00 2F 80 00 00 40 9E FF E0 38 00 00 00 98 1F 00 00 7F A3 EB 78 80 01 00 54 81 81 00 0C 7C 08 03 A6 82 01 00 10 82 21 00 14 7D 81 81 20 82 41 00 18 82 61 00 1C 82 81 00 20 82 A1 00 24 82 C1 00 28 82 E1 00 2C 83 01 00 30 83 21 00 34 83 41 00 38 83 61 00 3C 83 81 00 40 83 A1 00 44 83 C1 00 48 83 E1 00 4C 38 21 00 50 4E 80 00 20 88 1E 00 00 2F 80 00 3A 40 9E FF 8C 7F FB FB 78 4B FF FF 70 3B DE 00 01 80 F2 ?? ?? 7F 83 E3 78 7F C4 F3 78 7E 25 8B 78 7F 46 D3 78 4B FF DB D5 7C 70 1B 79 41 82 00 88 41 8E 00 AC 80 99 01 AC 38 04 FF FF 7F 80 A0 40 40 9D 00 60 2B 90 00 01 40 9D 00 48 7C 1E 80 AE 7D 3E 82 14 2F 80 00 00 40 BE 00 14 48 00 00 2C 8C 09 00 01 2F 80 00 00 41 9E 00 20 2F 80 00 3A 7D 3E 4B 78 41 B2 FF EC 40 9E FF E8 88 09 00 00 7F 7F DB 78 4B FF FF 08 7F 7F DB 78 4B FF FF 08 9A 7F 00 00 3B FF 00 01 88 1E 00 00 4B FF FE F0 7F E3 FB 78 4? ?? ?? ?? 7C 1E 80 EE 7C 7F 1B 78 4B FF FE DC 7F 83 E3 78 7F C4 F3 78 7E A5 AB 78 7F 46 D3 78 38 E0 00 00 4B FF DB 31 7C 70 1B 79 41 82 00 18 80 98 ?? ?? 4B FF FF 60 4? ?? ?? ?? 7C 64 1B 78 4B FF FF 54 7F 83 E3 78 7F C4 F3 78 7E C5 B3 78 7F 46 D3 78 38 E0 00 00 4B FF DA FD 7C 70 1B 79 41 A2 FF 8C 38 97 ?? ?? 4B FF FF 2C }
	condition:
		$1
}

rule file_245_14_0 {
	meta:
		name = "_dl_init_paths"
		size = 728
		refs = "0006 _dl_platformlen 0012 _dl_platform 004c _dl_important_hwcaps 0058 malloc 00b6 _dl_all_dirs 0198 strlen 01c4 memcpy 021e __libc_enable_secure 0284 free 02b0 __assert_fail 02c8 _dl_signal_error"
	strings:
		$1 = { 94 21 FF E0 3D 20 ?? ?? 7C 08 02 A6 80 89 ?? ?? 3D 20 ?? ?? 93 81 00 10 3F 80 ?? ?? 93 A1 00 14 7C 7D 1B 78 93 C1 00 18 3B DC ?? ?? 7F C5 F3 78 80 69 ?? ?? 38 DE 00 04 93 E1 00 1C 7C 3F 0B 78 90 01 00 24 93 61 00 0C 93 41 00 08 4? ?? ?? ?? 90 7E 00 08 38 60 00 0C 4? ?? ?? ?? 2F 83 00 00 90 7E 00 10 7C 7B 1B 78 41 9E 02 64 83 9C ?? ?? 3C 00 CC CC 60 00 CC CD 57 9A 10 3A 3B 5A 00 27 7F 5A 00 16 57 5A E1 3E 57 40 40 2E 57 43 30 32 7C 63 02 14 4? ?? ?? ?? 2F 83 00 00 90 7B 00 00 41 9E 02 14 1F 5A 00 14 38 00 00 00 3D 20 ?? ?? 90 1E 00 14 3D 60 ?? ?? 2F 1C 00 00 90 6B ?? ?? 39 29 ?? ?? 3C E0 ?? ?? 39 49 00 38 38 DB 00 08 38 E7 ?? ?? 7C BA 00 D0 85 6A 00 04 90 7B 00 00 39 0B 00 01 90 E3 00 04 7D 09 42 14 90 03 00 08 91 23 00 0C 91 63 00 10 89 29 00 00 2F 89 00 2F 40 9E 01 94 39 23 00 10 41 9A 00 10 7F 89 03 A6 94 09 00 04 42 00 FF FC 3B 7B 00 04 7F 9B 30 00 41 9E 00 14 7C 63 D2 14 7C 63 29 2E 7D 09 43 78 4B FF FF A8 2F 9D 00 00 38 00 00 00 39 60 00 09 90 03 00 00 3D 20 ?? ?? 91 69 ?? ?? 90 1B 00 00 41 9E 00 10 88 1D 00 00 2F 80 00 00 40 9E 00 38 39 7F 00 20 38 00 FF FF 83 4B FF E8 90 1E 00 18 80 0B 00 04 83 6B FF EC 7C 08 03 A6 83 8B FF F0 83 AB FF F4 83 CB FF F8 83 EB FF FC 7D 61 5B 78 4E 80 00 20 7F A3 EB 78 4? ?? ?? ?? 81 21 00 00 38 03 00 1F 54 00 00 36 7C 00 00 D0 7D 21 01 6E 7C 65 1B 78 7F A4 EB 78 38 61 00 17 54 63 00 36 38 A5 00 01 4? ?? ?? ?? 89 3D 00 00 7C 7C 1B 78 2F 89 00 00 38 60 00 08 41 9E 00 30 39 60 00 01 38 09 FF C6 8D 3D 00 01 54 00 06 3E 2F 89 00 00 21 40 00 01 7D 4B 01 94 7D 4B 53 78 40 9E FF E4 39 6A 00 01 55 63 10 3A 4? ?? ?? ?? 2F 83 00 00 90 7E 00 18 7C 64 1B 78 41 9E 00 9C 3D 20 ?? ?? 80 C9 ?? ?? 3C A0 ?? ?? 3C E0 ?? ?? 7F 83 E3 78 38 A5 ?? ?? 38 E7 ?? ?? 39 00 00 00 4B FF D6 25 80 7E 00 18 80 03 00 00 2F 80 00 00 41 9E 00 38 39 7F 00 20 38 00 00 00 83 4B FF E8 90 1E 00 1C 80 0B 00 04 83 6B FF EC 7C 08 03 A6 83 8B FF F0 83 AB FF F4 83 CB FF F8 83 EB FF FC 7D 61 5B 78 4E 80 00 20 4? ?? ?? ?? 38 00 FF FF 90 1E 00 18 4B FF FF C0 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 02 AA 38 C6 ?? ?? 4? ?? ?? ?? 3C C0 ?? ?? 38 C6 ?? ?? 38 60 00 0C 38 80 00 00 38 A0 00 00 4? ?? ?? ?? 3C C0 ?? ?? 38 C6 ?? ?? 4B FF FF E8 }
	condition:
		$1
}

rule file_245_15_0 {
	meta:
		name = "_dl_map_object"
		size = 1840
		refs = "0076 _dl_nns 0086 _dl_ns 00d4 _dl_name_match_p 0142 _dl_debug_mask 0164 strchr 01c6 __libc_stack_end 0200 strlen 02a4 _dl_load_cache_lookup 0318 _dl_debug_printf 03b4 __close 04e0 strcmp 0552 __libc_enable_secure 0578 memcmp 05d8 _dl_new_object 060c _dl_add_to_namespace_list 062a _dl_argv 0658 free 0670 _dl_signal_error 06d0 __assert_fail 070a _GLOBAL_OFFSET_TABLE_ 0712 __libc_errno"
	strings:
		$1 = { 94 21 FD 90 7D 80 00 26 7C 08 02 A6 93 A1 02 64 7D 1D 43 79 92 A1 02 44 7C D5 33 78 92 E1 02 4C 7C B7 2B 78 93 81 02 60 7C FC 3B 78 93 C1 02 68 7C 7E 1B 78 93 E1 02 6C 7C 9F 23 78 90 01 02 74 91 E1 02 2C 92 01 02 30 92 21 02 34 92 41 02 38 92 61 02 3C 92 81 02 40 92 C1 02 48 93 01 02 50 93 21 02 54 93 41 02 58 93 61 02 5C 91 81 02 28 41 80 06 44 3D 20 ?? ?? 80 09 ?? ?? 7F 9D 00 40 40 9C 06 68 3F 60 ?? ?? 1F 3D 00 4C 3B 5B ?? ?? 7F 1A C8 2E 2F 98 00 00 40 BE 00 20 48 00 00 A4 80 18 01 98 74 09 00 80 41 82 04 14 83 18 00 0C 2F 98 00 00 41 9E 00 8C 80 18 01 98 74 09 00 40 40 A2 FF EC 74 0B 00 04 40 A2 FF E4 7F E3 FB 78 7F 04 C3 78 4? ?? ?? ?? 2F 83 00 00 41 9E FF C4 80 01 02 74 7F 03 C3 78 81 81 02 28 7C 08 03 A6 81 E1 02 2C 82 01 02 30 7D 81 81 20 82 21 02 34 82 41 02 38 82 61 02 3C 82 81 02 40 82 A1 02 44 82 C1 02 48 82 E1 02 4C 83 01 02 50 83 21 02 54 83 41 02 58 83 61 02 5C 83 81 02 60 83 A1 02 64 83 C1 02 68 83 E1 02 6C 38 21 02 70 4E 80 00 20 3E C0 ?? ?? 80 16 ?? ?? 2D 9E 00 00 70 0B 00 40 40 82 04 C4 38 00 00 00 7F E3 FB 78 98 01 00 10 38 80 00 2F 4? ?? ?? ?? 2F 83 00 00 41 9E 00 90 41 8E 01 B4 7F C3 F3 78 7F E4 FB 78 4B FF F7 D1 2F 83 00 00 90 61 00 14 38 80 FF FF 2E 04 FF FF 41 9E 00 20 38 81 00 1C 38 A1 00 10 38 C0 00 01 4B FF E9 99 2E 03 FF FF 7C 64 1B 78 41 92 05 28 57 80 27 FE 30 00 FF FF 7C 00 01 10 7F DE 00 38 41 92 03 E0 3D 20 ?? ?? 80 C1 00 14 80 09 ?? ?? 7F E3 FB 78 38 A1 00 1C 93 A1 00 08 7F C7 F3 78 7E E8 BB 78 90 01 00 18 7F 89 E3 78 39 41 00 18 4B FF DB 01 7C 78 1B 78 4B FF FE E8 7F E3 FB 78 4? ?? ?? ?? 80 16 ?? ?? 3A 43 00 01 70 09 00 01 40 82 04 88 41 8E 01 1C 80 1E 00 94 57 93 01 4A 2F 80 00 00 41 9E 02 00 3F 00 ?? ?? 3B 18 ?? ?? 80 18 00 18 2F 80 FF FF 41 9E 00 38 41 8E 03 04 7F C9 F3 78 7E 44 93 78 7F E3 FB 78 7E 65 9B 78 38 D8 00 18 38 E1 00 14 39 01 00 1C 39 41 00 10 4B FF EE 15 2E 03 FF FF 7C 64 1B 78 40 92 00 90 41 8E 00 28 3B 7E 01 F0 3C C0 ?? ?? 7F C3 F3 78 7F 64 DB 78 38 A0 00 1D 38 C6 ?? ?? 4B FF F8 5D 2F 83 00 00 40 9E 02 78 2F 93 00 00 40 9E 02 B4 7F E3 FB 78 4? ?? ?? ?? 7C 7B 1B 79 41 82 01 0C 41 8E 00 10 80 1E 02 0C 70 0B 08 00 40 82 02 AC 38 81 00 1C 7F 63 DB 78 38 A1 00 10 38 C0 00 00 4B FF E8 69 2E 03 FF FF 7C 64 1B 78 41 92 00 DC 7F 63 DB 78 90 81 02 20 4B FF D2 41 2F 83 00 00 90 61 00 14 80 81 02 20 41 9E 00 B8 80 16 ?? ?? 70 09 00 01 41 82 FE AC 3C 60 ?? ?? 90 81 02 20 38 63 ?? ?? 4C C6 31 82 4? ?? ?? ?? 80 81 02 20 4B FF FE 90 7F E3 FB 78 4B FF D2 01 4B FF FE 54 82 3B ?? ?? 57 93 01 4A 2F 91 00 00 41 BE FE EC 81 31 01 98 3C 00 80 00 55 29 00 02 7F 89 00 00 41 BE FE D8 3B 11 01 9C 3C C0 ?? ?? 7E 23 8B 78 7F 04 C3 78 38 A0 00 0F 38 C6 ?? ?? 4B FF F7 7D 2F 83 00 00 41 BE FE B4 41 8E 01 D0 7F C9 F3 78 7E 44 93 78 7F E3 FB 78 7E 65 9B 78 7F 06 C3 78 38 E1 00 14 39 01 00 1C 39 41 00 10 4B FF EC D9 2E 03 FF FF 7C 64 1B 78 40 92 FF 54 4B FF FE 7C 7C 83 23 78 4? ?? ?? ?? 41 8E 00 5C 7F C9 F3 78 80 09 02 0C 38 80 FF FF 2E 04 FF FF 70 0B 08 00 40 A2 FF 2C 80 18 00 10 38 80 FF FF 2E 04 FF FF 2F 80 FF FF 41 BE FF 18 7E 44 93 78 7F E3 FB 78 7E 65 9B 78 38 D8 00 10 38 E1 00 14 39 01 00 1C 39 41 00 10 4B FF EC 71 7C 64 1B 78 2E 03 FF FF 4B FF FE EC 7D 3A C8 2E 2F 89 00 00 40 9E FF A4 4B FF FF B4 3E 80 ?? ?? 82 3B ?? ?? 57 93 01 4A 7F D8 F3 78 3A 00 00 00 3A 94 ?? ?? 48 00 00 10 83 18 01 70 2F 98 00 00 41 9E 00 68 39 F8 01 9C 7F 03 C3 78 7D E4 7B 78 38 A0 00 0F 7E 86 A3 78 4B FF F6 89 2F 83 00 00 41 9E FF D8 7E 44 93 78 7F E3 FB 78 7E 65 9B 78 7D E6 7B 78 38 E1 00 14 39 01 00 1C 7F C9 F3 78 39 41 00 10 4B FF EB E9 2E 03 FF FF 7C 64 1B 78 40 B2 FE 64 7F 00 8A 78 7C 00 00 34 54 00 D9 7E 7C 10 83 78 4B FF FF 94 2F 90 00 00 41 BE FE 84 4B FF FD 70 81 38 00 58 2F 89 00 00 41 BE FB E8 81 78 00 34 7F E3 FB 78 80 09 00 04 82 CB 00 04 7E D6 02 14 7E C4 B3 78 4? ?? ?? ?? 2F 83 00 00 40 9E FB C4 80 78 00 1C 7E C4 B3 78 4B FF D6 E9 80 18 01 98 39 20 00 01 51 20 BA 10 90 18 01 98 4B FF FB D8 7E 44 93 78 7F E3 FB 78 7E 65 9B 78 7F 66 DB 78 38 E1 00 14 39 01 00 1C 7F C9 F3 78 39 41 00 10 4B FF EB 49 2E 03 FF FF 7C 64 1B 78 41 92 FD 60 4B FF FD C0 81 3B ?? ?? 4B FF FD 00 7E 29 8B 78 4B FF FE 34 3D 20 ?? ?? 80 09 ?? ?? 2F 80 00 00 41 BE FD 44 40 8E FE 5C 4B FF FE B0 3E 80 ?? ?? 3A 94 ?? ?? 7E 84 A3 78 38 A0 00 05 4? ?? ?? ?? 2F 83 00 00 41 BE FE 3C 7F 63 DB 78 38 94 00 06 38 A0 00 09 4? ?? ?? ?? 2F 83 00 00 40 9E FD 28 4B FF FE 20 2F 95 00 00 41 9E 00 D0 80 16 ?? ?? 70 0B 04 00 40 82 00 C4 7F E3 FB 78 4B FF CF 71 7C 7B 1B 79 41 82 00 94 7F E4 FB 78 7E E5 BB 78 7F C6 F3 78 7F 87 E3 78 7F A8 EB 78 4? ?? ?? ?? 7C 78 1B 79 41 82 00 74 80 18 01 98 39 20 00 01 3D 60 ?? ?? 91 38 01 7C 64 00 00 40 51 20 E8 84 39 6B ?? ?? 90 18 01 98 7F A4 EB 78 91 78 01 90 4? ?? ?? ?? 4B FF FA D0 41 AE FB 40 80 DE 00 04 88 06 00 00 2F 80 00 00 40 9E 00 10 3D 20 ?? ?? 81 29 ?? ?? 80 C9 00 00 80 FE 00 18 3C 60 ?? ?? 38 63 ?? ?? 7F E4 FB 78 7F A5 EB 78 4C C6 31 82 4? ?? ?? ?? 4B FF FB 04 7F 63 DB 78 4? ?? ?? ?? 3C C0 ?? ?? 38 60 00 0C 7F E4 FB 78 38 A0 00 00 38 C6 ?? ?? 4? ?? ?? ?? 88 01 00 10 2F 80 00 00 41 9E 00 8C 3C C0 ?? ?? 38 60 00 00 7F E4 FB 78 38 A0 00 00 38 C6 ?? ?? 4? ?? ?? ?? 3C 60 ?? ?? 38 63 ?? ?? 7F E4 FB 78 7F A5 EB 78 4C C6 31 82 4? ?? ?? ?? 4B FF FB 64 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 07 B0 38 C6 ?? ?? 4? ?? ?? ?? 80 61 00 14 90 81 02 20 4? ?? ?? ?? 80 81 02 20 4B FF FA CC 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 07 B1 38 C6 ?? ?? 4? ?? ?? ?? 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 3C C0 ?? ?? 80 69 00 00 7F E4 FB 78 38 A0 00 00 38 C6 ?? ?? 4? ?? ?? ?? }
	condition:
		$1
}

rule file_245_16_0 {
	meta:
		name = "_dl_rtld_di_serinfo"
		size = 500
		refs = "0176 _dl_ns"
	strings:
		$1 = { 2F 85 00 00 94 21 FF D0 7C 08 02 A6 93 C1 00 28 7C 7E 1B 78 90 01 00 34 93 81 00 20 93 A1 00 24 93 E1 00 2C 90 81 00 10 98 A1 00 14 40 9E 00 B8 80 1E 00 94 7C 3D 0B 78 81 24 00 04 38 84 00 08 2F 80 00 00 55 29 18 38 7C 84 4A 14 38 00 00 00 94 9D 00 08 90 01 00 0C 41 9E 00 C0 3F E0 ?? ?? 3B FF ?? ?? 80 7F 00 18 7F AB EB 78 4B FF ED 29 3C C0 ?? ?? 7F C3 F3 78 38 9E 01 F0 38 A0 00 1D 38 C6 ?? ?? 4B FF F3 35 2F 83 00 00 40 9E 01 40 80 1E 02 0C 70 09 08 00 41 82 01 4C 88 01 00 14 2F 80 00 00 41 9E 00 20 81 21 00 10 81 49 00 04 81 69 00 00 38 0A 00 01 54 00 18 38 7C 0B 02 14 90 09 00 00 80 01 00 34 83 81 00 20 7C 08 03 A6 83 A1 00 24 83 C1 00 28 83 E1 00 2C 38 21 00 30 4E 80 00 20 38 00 00 00 90 04 00 04 39 20 00 00 7C 3D 0B 78 90 04 00 00 38 84 00 08 7C 84 4A 14 80 1E 00 94 94 9D 00 08 2F 80 00 00 38 00 00 00 90 01 00 0C 40 9E FF 48 3F 80 ?? ?? 7F DF F3 78 3B 9C ?? ?? 48 00 00 10 83 FF 01 70 2F 9F 00 00 41 9E 00 38 38 9F 01 9C 7F E3 FB 78 38 A0 00 0F 7F 86 E3 78 4B FF F2 75 2F 83 00 00 41 9E FF DC 80 7F 01 9C 7F AB EB 78 4B FF EC 3D 83 FF 01 70 2F 9F 00 00 40 9E FF D0 80 1E 00 18 2F 80 00 00 40 BE FE EC 3D 20 ?? ?? 83 E9 ?? ?? 2F 9F 00 00 41 BE FE DC 81 3F 01 98 3C 00 80 00 55 29 00 02 7F 89 00 00 41 BE FE C8 7F 9F F0 00 41 BE FE C0 7F E3 FB 78 38 9F 01 9C 38 A0 00 0F 7F 86 E3 78 4B FF F2 09 2F 83 00 00 41 9E FE A4 80 7F 01 9C 7F AB EB 78 4B FF EB D1 4B FF FE 94 80 7E 01 F0 7F AB EB 78 4B FF EB C1 80 1E 02 0C 70 09 08 00 40 82 FE BC 80 7F 00 10 7F AB EB 78 4B FF EB A9 4B FF FE AC }
	condition:
		$1
}

rule file_246_0_0 {
	meta:
		name = "ppoll"
		size = 596
		refs = "00be _GLOBAL_OFFSET_TABLE_ 00c6 __libc_errno 0160 __sigprocmask 0170 __poll 01f4 __libc_enable_asynccancel 022c __libc_disable_asynccancel"
	strings:
		$1 = { 94 21 FF 40 7C 08 02 A6 93 E1 00 BC 7C BF 2B 79 38 A0 00 00 93 81 00 B0 7C 7C 1B 78 93 A1 00 B4 7C 9D 23 78 93 C1 00 B8 7C DE 33 78 90 01 00 C4 93 41 00 A8 93 61 00 AC 41 82 00 1C 81 3F 00 00 81 5F 00 04 7C 3F 0B 78 95 3F 00 08 91 5F 00 04 7F E5 FB 78 80 02 8B 60 2F 80 00 00 40 9E 01 94 38 00 01 19 7F 83 E3 78 7F A4 EB 78 7F C6 F3 78 38 E0 00 08 44 00 00 02 7C 00 00 26 74 09 10 00 7C 7B 1B 78 40 82 01 54 2F 9B FF FF 41 9E 00 30 80 01 00 C4 7F 63 DB 78 83 41 00 A8 7C 08 03 A6 83 61 00 AC 83 81 00 B0 83 A1 00 B4 83 C1 00 B8 83 E1 00 BC 38 21 00 C0 4E 80 00 20 3D 20 ?? ?? 39 29 ?? ?? 81 69 ?? ?? 7D 6B 12 14 80 0B 00 00 3B 60 FF FF 2F 80 00 26 40 9E FF B8 2F 9F 00 00 41 9E 00 C4 80 1F 00 00 2F 80 00 00 41 9C 00 A0 81 7F 00 04 2F 8B 00 00 41 9C 00 94 3D 40 3B 9A 61 4A C9 FF 7F 8B 50 00 41 9D 00 84 3D 20 00 20 61 29 C4 9B 7F 80 48 00 3B E0 FF FF 41 9D 00 30 41 9E 00 A4 3D 2B 00 0F 3F E0 43 1B 39 29 42 3F 63 FF DE 83 7F E9 F8 96 1C 00 03 E8 7D 29 FE 70 7F FF 96 70 7F E9 F8 50 7F FF 02 14 2F 9E 00 00 41 9E 00 5C 7F C4 F3 78 38 A1 00 10 38 60 00 02 4? ?? ?? ?? 7F A4 EB 78 7F E5 FB 78 7F 83 E3 78 4? ?? ?? ?? 38 81 00 10 7C 7B 1B 78 38 A0 00 00 38 60 00 02 4? ?? ?? ?? 4B FF FF 08 81 29 ?? ?? 7D 29 12 14 38 00 00 16 90 09 00 00 3B 60 FF FF 4B FF FE F0 3B E0 FF FF 4B FF FF A4 7F 83 E3 78 7F A4 EB 78 7F E5 FB 78 4? ?? ?? ?? 7C 7B 1B 78 4B FF FE D0 3D 20 26 90 61 29 6F C0 7F 8B 48 00 41 BD FF 7C 4B FF FF 50 3D 20 ?? ?? 39 29 ?? ?? 81 69 ?? ?? 7D 6B 12 14 90 6B 00 00 4B FF FE D8 90 A1 00 98 4? ?? ?? ?? 7C 7B 1B 78 38 00 01 19 80 A1 00 98 7F 83 E3 78 7F A4 EB 78 7F C6 F3 78 38 E0 00 08 44 00 00 02 7C 00 00 26 74 09 10 00 7C 7A 1B 78 40 82 00 14 7F 63 DB 78 4? ?? ?? ?? 7F 5B D3 78 4B FF FE 54 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 90 69 00 00 3B 40 FF FF 4B FF FF D8 }
	condition:
		$1
}

rule file_247_0_0 {
	meta:
		name = "__atomic_readv_replacement"
		size = 496
		refs = "00cc __read 0118 memcpy 012c free 0176 _GLOBAL_OFFSET_TABLE_ 017e __libc_errno 01ac __libc_alloca_cutoff 01bc malloc 01e0 _Unwind_Resume"
	strings:
		$1 = { 7D 80 00 26 2E 05 00 00 94 21 FF D0 7C 08 02 A6 93 41 00 18 7C 7A 1B 78 93 61 00 1C 7C BB 2B 78 93 81 00 20 7C 9C 23 78 93 E1 00 2C 7C 3F 0B 78 90 01 00 34 92 E1 00 0C 93 01 00 10 93 21 00 14 93 A1 00 24 93 C1 00 28 91 81 00 08 40 91 01 54 80 04 00 04 3D 40 7F FF 61 4A FF FF 7F 80 50 40 41 9D 01 14 39 20 00 00 7C A9 03 A6 3B C0 00 00 48 00 00 1C 55 2B 18 38 7D 7C 5A 14 80 0B 00 04 7D 7E 50 50 7F 8B 00 40 41 9C 00 EC 7F DE 02 14 39 29 00 01 42 00 FF E0 2B 9E 80 00 41 9D 01 0C 38 1E 00 1E 81 21 00 00 54 00 00 36 7C 00 00 D0 7D 21 01 6E 3B 20 00 00 3B A1 00 17 57 BD 00 36 7F 43 D3 78 7F A4 EB 78 7F C5 F3 78 4? ?? ?? ?? 7C 77 1B 79 41 80 00 C4 40 91 00 50 7E FA BB 78 3B 00 00 00 48 00 00 14 3B 18 00 01 7F 98 D8 00 3B 9C 00 08 41 9E 00 34 80 1C 00 04 7F 5E D3 78 7F 9A 00 40 40 9D 00 08 7C 1E 03 78 80 7C 00 00 7F A4 EB 78 7F C5 F3 78 4? ?? ?? ?? 7F 5E D0 51 7F BD F2 14 40 82 FF C4 7F 23 CB 78 4? ?? ?? ?? 39 7F 00 30 80 0B 00 04 7E E3 BB 78 81 8B FF D8 7C 08 03 A6 82 EB FF DC 83 0B FF E0 7D 80 81 20 83 2B FF E4 83 4B FF E8 83 6B FF EC 83 8B FF F0 83 AB FF F4 83 CB FF F8 83 EB FF FC 7D 61 5B 78 4E 80 00 20 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 38 00 00 16 90 09 00 00 3A E0 FF FF 4B FF FF A0 3B 20 00 00 3A E0 FF FF 4B FF FF 8C 3B C0 00 00 4B FF FE FC 7F C3 F3 78 4? ?? ?? ?? 2F 83 00 00 40 9E FE EC 7F C3 F3 78 4? ?? ?? ?? 7C 7D 1B 79 41 A2 FF D0 7F B9 EB 78 4B FF FE F4 7C 7E 1B 78 7F 23 CB 78 4? ?? ?? ?? 7F C3 F3 78 4? ?? ?? ?? 7C 7E 1B 78 3B 20 00 00 4B FF FF E8 }
	condition:
		$1
}

rule file_247_1_0 {
	meta:
		name = "__libc_readv"
		size = 320
		refs = "007a _GLOBAL_OFFSET_TABLE_ 0082 __libc_errno 00cc __libc_enable_asynccancel 00fc __libc_disable_asynccancel"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 93 A1 00 14 7C 7D 1B 78 93 C1 00 18 7C 9E 23 78 93 E1 00 1C 7C BF 2B 78 90 01 00 24 93 61 00 0C 93 81 00 10 80 02 8B 60 2F 80 00 00 40 9E 00 98 38 00 00 91 44 00 00 02 7C 00 00 26 74 09 10 00 40 82 00 C0 2F 83 00 00 41 9C 00 28 80 01 00 24 83 61 00 0C 7C 08 03 A6 83 81 00 10 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 80 09 00 00 2F 80 00 16 40 9E FF C4 2F 9F 00 08 40 9D FF BC 80 01 00 24 7F A3 EB 78 7F C4 F3 78 83 61 00 0C 7C 08 03 A6 7F E5 FB 78 83 81 00 10 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4B FF FD 48 4? ?? ?? ?? 38 00 00 91 7C 7C 1B 78 7F C4 F3 78 7F A3 EB 78 7F E5 FB 78 44 00 00 02 7C 00 00 26 74 09 10 00 7C 7B 1B 78 40 82 00 30 7F 83 E3 78 4? ?? ?? ?? 7F 63 DB 78 4B FF FF 48 3D 20 ?? ?? 39 29 ?? ?? 81 69 ?? ?? 7D 6B 12 14 90 6B 00 00 38 60 FF FF 4B FF FF 60 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 90 69 00 00 3B 60 FF FF 4B FF FF BC }
	condition:
		$1
}

rule file_249_0_0 {
	meta:
		name = "__seed48_r"
		size = 88
	strings:
		$1 = { 81 24 00 00 3D 40 DE EC A0 04 00 04 61 4A E6 6D 91 24 00 06 7C 69 1B 78 B0 04 00 0A A0 03 00 04 B0 04 00 04 A0 03 00 02 38 60 00 00 B0 04 00 02 A0 09 00 00 39 20 00 05 91 24 00 10 B0 04 00 00 38 00 00 0B B0 04 00 0C 38 00 00 01 91 44 00 14 B0 04 00 0E 4E 80 00 20 }
	condition:
		$1
}

rule file_250_0_0 {
	meta:
		name = "sethostname"
		size = 16
		refs = "000c __syscall_error"
	strings:
		$1 = { 38 00 00 4A 44 00 00 02 4C A3 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_251_0_0 {
	meta:
		name = "__validuser2_sa"
		size = 1460
		refs = "000a _GLOBAL_OFFSET_TABLE_ 0026 _nl_current_LC_CTYPE 007a __libc_tsd_CTYPE_B 007e __libc_tsd_CTYPE_TOLOWER 00b0 __getline 0230 strncmp 02e8 free 034c strcmp 03a8 innetgr 03e4 getnameinfo 043c getaddrinfo 0488 memcmp 04a0 freeaddrinfo"
	strings:
		$1 = { 94 21 FF 50 7C 08 02 A6 3D 20 ?? ?? 39 29 ?? ?? 90 01 00 B4 38 00 00 00 93 41 00 98 7C 3A 0B 78 93 61 00 9C 83 69 ?? ?? 7F 7B 12 14 92 21 00 74 7F 71 DB 78 92 41 00 78 7D 12 43 78 92 61 00 7C 7C B3 2B 78 92 81 00 80 7C D4 33 78 92 A1 00 84 7C F5 3B 78 92 C1 00 88 7C 96 23 78 92 E1 00 8C 3E E0 ?? ?? 3A F7 ?? ?? 93 21 00 94 7C 79 1B 78 93 C1 00 A8 93 E1 00 AC 83 E9 ?? ?? 81 29 ?? ?? 91 E1 00 6C 7F FF 12 14 7F C9 12 14 92 01 00 70 93 01 00 90 93 81 00 A0 93 A1 00 A4 90 01 00 08 94 1A 00 0C 38 61 00 08 7F 44 D3 78 7F 25 CB 78 4? ?? ?? ?? 2F 83 00 00 40 9D 02 AC 80 01 00 0C 81 21 00 08 7D 29 02 14 38 00 00 00 98 09 FF FF 81 41 00 08 88 0A 00 00 2F 80 00 00 41 BE FF C8 81 3F 00 00 7D 4B 53 78 80 FB 00 00 48 00 00 10 8C 0B 00 01 2F 80 00 00 41 BE FF AC 2F 89 00 00 41 9E 04 3C 88 0B 00 00 54 08 08 3C 7D 09 42 2E 71 06 00 20 40 82 FF DC 2F 80 00 00 41 BE FF 88 2F 80 00 23 41 BE FF 80 88 0A 00 00 7D 5D 53 78 70 07 00 FF 40 A2 00 30 48 00 00 E0 81 3E 00 00 2F 89 00 00 41 9E 04 0C 54 00 10 3A 7C 09 00 2E 98 0A 00 00 8C 0A 00 01 70 09 00 FF 41 82 02 14 81 3F 00 00 2F 89 00 00 41 9E 04 04 54 00 06 3E 54 0B 08 3C 7D 29 5A 2E 71 2B 00 20 41 82 FF C0 2F 80 00 20 40 9E 03 24 88 0A 00 01 39 20 00 00 99 2A 00 00 39 6A 00 01 70 06 00 FF 41 82 01 D0 81 3F 00 00 81 1B 00 00 48 00 00 10 8C 0B 00 01 70 07 00 FF 41 82 01 B8 2F 89 00 00 41 9E 03 CC 54 00 06 3E 54 0A 08 3C 7D 49 52 2E 71 46 00 20 40 82 FF DC 2F 80 00 00 7D 6A 5B 78 7D 7D 5B 78 41 9E 00 38 81 1B 00 00 48 00 00 10 8C 0A 00 01 2F 80 00 00 41 9E 00 20 2F 89 00 00 41 9E 03 A4 88 0A 00 00 54 00 08 3C 7C 09 02 2E 70 07 00 20 41 82 FF DC 7D 7D 5B 78 38 00 00 00 98 0A 00 00 7E E3 BB 78 38 A0 00 02 83 81 00 08 7F 84 E3 78 4? ?? ?? ?? 2F 83 00 00 41 9E 01 60 3C 60 ?? ?? 38 63 ?? ?? 7F 84 E3 78 38 A0 00 02 4? ?? ?? ?? 2F 83 00 00 41 9E 02 7C 88 1C 00 00 2F 80 00 2D 41 9E 01 60 2F 80 00 2B 3B 00 00 01 40 9E 01 5C 88 1C 00 01 2F 80 00 00 40 9E 01 50 88 1D 00 00 2F 80 00 00 40 9E 00 08 7E 9D A3 78 7E E3 BB 78 7F A4 EB 78 38 A0 00 02 4? ?? ?? ?? 2F 83 00 00 41 9E 02 18 3C 60 ?? ?? 38 63 ?? ?? 7F A4 EB 78 38 A0 00 02 4? ?? ?? ?? 2F 83 00 00 41 9E 02 30 88 1D 00 00 2F 80 00 2D 41 9E 02 54 2F 80 00 2B 40 9E 00 74 88 1D 00 01 2F 80 00 00 40 9E 00 68 3B E0 00 00 80 61 00 08 4? ?? ?? ?? 80 01 00 B4 7F E3 FB 78 81 E1 00 6C 7C 08 03 A6 82 01 00 70 82 21 00 74 82 41 00 78 82 61 00 7C 82 81 00 80 82 A1 00 84 82 C1 00 88 82 E1 00 8C 83 01 00 90 83 21 00 94 83 41 00 98 83 61 00 9C 83 81 00 A0 83 A1 00 A4 83 C1 00 A8 83 E1 00 AC 38 21 00 B0 4E 80 00 20 7E A3 AB 78 7F A4 EB 78 4? ?? ?? ?? 7C 63 00 34 54 63 D9 7E 2F 83 00 00 41 BD FF 84 41 9E FD 44 3B E0 FF FF 4B FF FF 7C 7D 6A 5B 78 38 00 00 00 98 0A 00 00 7E E3 BB 78 38 A0 00 02 83 81 00 08 7D 5D 53 78 7F 84 E3 78 4? ?? ?? ?? 2F 83 00 00 40 9E FE A8 38 7C 00 02 7E 44 93 78 38 A0 00 00 38 C0 00 00 4? ?? ?? ?? 7C 78 1B 78 2F 98 00 00 41 BC FF B0 40 9E FE C4 4B FF FC E8 3B 9C 00 01 3B 00 FF FF 7E C3 B3 78 7E 64 9B 78 38 A1 00 34 38 C0 00 2E 38 E0 00 00 39 00 00 00 39 20 00 01 4? ?? ?? ?? 2F 83 00 00 40 9E 00 18 38 61 00 34 7F 84 E3 78 4? ?? ?? ?? 2F 83 00 00 41 BE FF B0 A1 36 00 00 38 00 00 00 7F 83 E3 78 90 01 00 14 38 80 00 00 38 A1 00 14 90 01 00 1C 38 C1 00 10 90 01 00 20 90 01 00 24 90 01 00 28 90 01 00 2C 90 01 00 30 91 21 00 18 4? ?? ?? ?? 2F 83 00 00 40 BE FC 60 81 E1 00 10 38 00 00 00 2F 8F 00 00 41 9E 00 44 A2 16 00 00 7D FC 7B 78 48 00 00 10 83 9C 00 1C 2F 9C 00 00 41 9E 00 9C 80 1C 00 04 7F 80 80 00 40 9E FF EC 80 7C 00 14 7E C4 B3 78 80 BC 00 10 4? ?? ?? ?? 2F 83 00 00 40 9E FF D4 38 00 00 01 7D E3 7B 78 7F 18 01 D6 4? ?? ?? ?? 4B FF FF 0C 2F 80 00 09 7D 5D 53 78 41 9E FC D8 4B FF FD 64 38 7D 00 02 38 80 00 00 7E A5 AB 78 38 C0 00 00 4? ?? ?? ?? 4B FF FE 8C 38 7C 00 02 7E 44 93 78 38 A0 00 00 38 C0 00 00 4? ?? ?? ?? 7F 03 00 D0 4B FF FE C8 38 7D 00 02 38 80 00 00 7E A5 AB 78 38 C0 00 00 4? ?? ?? ?? 7C 63 00 D0 4B FF FE 54 38 00 00 00 7D E3 7B 78 7F 18 01 D6 4? ?? ?? ?? 4B FF FE 98 38 7D 00 01 7E A4 AB 78 4? ?? ?? ?? 30 63 FF FF 7C 63 19 10 2F 83 00 00 41 9E FB 70 4B FF FE 2C 81 27 00 00 81 29 00 24 39 29 01 00 91 3F 00 00 4B FF FB B8 81 31 00 00 81 29 00 00 81 29 00 30 39 29 02 00 91 3E 00 00 88 0A 00 00 4B FF FB E0 81 3B 00 00 81 29 00 00 81 29 00 24 39 29 01 00 91 3F 00 00 88 0A 00 00 4B FF FB E8 81 28 00 00 81 29 00 24 39 29 01 00 91 3F 00 00 88 0B 00 00 4B FF FC 24 81 28 00 00 81 29 00 24 39 29 01 00 91 3F 00 00 4B FF FC 50 }
	condition:
		$1
}

rule file_251_1_0 {
	meta:
		name = "iruserfopen"
		size = 448
		refs = "0028 __lxstat64 004a _libc_intl_domainname 005c __dcgettext 009a __rcmd_errstr 00a8 _IO_new_fclose 00e0 _IO_new_fopen 00ec fileno 00fc __fxstat64"
	strings:
		$1 = { 94 21 FF 80 7C 08 02 A6 93 E1 00 7C 7C 7F 1B 78 38 A1 00 08 93 C1 00 78 38 60 00 03 7C 9E 23 78 7F E4 FB 78 90 01 00 84 4? ?? ?? ?? 2F 83 00 00 40 9E 00 84 81 21 00 18 55 29 04 26 6D 20 FF FF 2F 80 80 00 41 9E 00 90 3C 60 ?? ?? 3C 80 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 00 05 4? ?? ?? ?? 3B E0 00 00 2F 83 00 00 40 9E 00 2C 80 1F 00 00 60 00 80 00 90 1F 00 00 80 01 00 84 7F E3 FB 78 83 C1 00 78 7C 08 03 A6 83 E1 00 7C 38 21 00 80 4E 80 00 20 2F 9F 00 00 3D 20 ?? ?? 90 69 ?? ?? 41 9E FF D8 7F E3 FB 78 4? ?? ?? ?? 3B E0 00 00 4B FF FF C8 3C 60 ?? ?? 3C 80 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 00 05 4? ?? ?? ?? 3B E0 00 00 4B FF FF 94 3C 80 ?? ?? 7F E3 FB 78 38 84 ?? ?? 4? ?? ?? ?? 7C 7F 1B 79 41 82 00 A0 4? ?? ?? ?? 38 A1 00 08 7C 64 1B 78 38 60 00 03 4? ?? ?? ?? 2F 83 00 00 41 9C 00 A0 80 01 00 20 2F 80 00 00 41 9E 00 28 7F 80 F0 00 41 9E 00 20 3C 60 ?? ?? 3C 80 ?? ?? 38 84 ?? ?? 38 A0 00 05 38 63 ?? ?? 4? ?? ?? ?? 4B FF FF 30 80 01 00 18 70 09 00 12 40 82 00 2C 80 01 00 1C 2B 80 00 01 40 BD FF 20 3C 60 ?? ?? 3C 80 ?? ?? 38 84 ?? ?? 38 A0 00 05 38 63 ?? ?? 4? ?? ?? ?? 4B FF FE FC 3C 60 ?? ?? 3C 80 ?? ?? 38 84 ?? ?? 38 A0 00 05 38 63 ?? ?? 4? ?? ?? ?? 4B FF FE E0 3C 60 ?? ?? 3C 80 ?? ?? 38 84 ?? ?? 38 A0 00 05 38 63 ?? ?? 4? ?? ?? ?? 4B FF FE C4 3C 60 ?? ?? 3C 80 ?? ?? 38 84 ?? ?? 38 A0 00 05 38 63 ?? ?? 4? ?? ?? ?? 4B FF FE A8 }
	condition:
		$1
}

rule file_251_2_0 {
	meta:
		name = "ruserok2_sa"
		size = 492
		refs = "0056 __check_rhosts_file 00a4 _IO_new_fclose 00f0 __sysconf 0120 __getpwnam_r 0140 strlen 016c mempcpy 0190 __geteuid 01a0 seteuid"
	strings:
		$1 = { 94 21 FF B0 7C 08 02 A6 93 01 00 30 7C B8 2B 79 92 E1 00 2C 3A E0 FF FF 93 41 00 38 7C 7A 1B 78 93 61 00 3C 7C 9B 23 78 93 81 00 40 7C DC 33 78 93 A1 00 44 7D 1D 43 78 93 C1 00 48 7C FE 3B 78 93 E1 00 4C 7C 3F 0B 78 90 01 00 54 93 21 00 34 41 82 00 1C 3D 20 ?? ?? 80 09 ?? ?? 7F 09 03 79 40 82 00 8C 3A E0 FF FF 48 00 00 48 3C 60 ?? ?? 38 63 ?? ?? 38 80 00 00 4B FF FD C9 7C 79 1B 79 41 A2 FF D4 7F 44 D3 78 7F 65 DB 78 7F C6 F3 78 7F 87 E3 78 7F A8 EB 78 4B FF F7 F5 7C 77 1B 78 7F 23 CB 78 4? ?? ?? ?? 2F 97 00 00 40 BE FF A8 39 7F 00 50 80 0B 00 04 7E E3 BB 78 83 0B FF E0 7C 08 03 A6 82 EB FF DC 83 2B FF E4 83 4B FF E8 83 6B FF EC 83 8B FF F0 83 AB FF F4 83 CB FF F8 83 EB FF FC 7D 61 5B 78 4E 80 00 20 38 60 00 46 4? ?? ?? ?? 81 21 00 00 38 03 00 1E 54 00 00 36 7C 00 00 D0 7D 21 01 6E 7C 66 1B 78 38 9F 00 0C 38 A1 00 17 7F C3 F3 78 54 A5 00 36 38 FF 00 08 4? ?? ?? ?? 2F 83 00 00 40 9E FF 3C 81 3F 00 08 2F 89 00 00 41 BE FF 30 83 29 00 14 7F 23 CB 78 4? ?? ?? ?? 81 21 00 00 38 03 00 27 54 00 00 36 7C 00 00 D0 7D 21 01 6E 7C 65 1B 78 7F 24 CB 78 3B 01 00 17 57 18 00 36 7F 03 C3 78 4? ?? ?? ?? 3D 60 ?? ?? 39 2B ?? ?? 81 4B ?? ?? 88 09 00 08 81 69 00 04 91 43 00 00 91 63 00 04 98 03 00 08 4? ?? ?? ?? 81 3F 00 08 7C 79 1B 78 80 69 00 08 4? ?? ?? ?? 81 3F 00 08 7F 03 C3 78 80 89 00 08 4B FF FC 91 7C 78 1B 79 41 82 00 28 7F 44 D3 78 7F 65 DB 78 7F C6 F3 78 7F 87 E3 78 7F A8 EB 78 4B FF F6 BD 7C 77 1B 78 7F 03 C3 78 4? ?? ?? ?? 7F 23 CB 78 4? ?? ?? ?? 4B FF FE C8 }
	condition:
		$1
}

rule file_251_3_0 {
	meta:
		name = "rresvport_af"
		size = 464
		refs = "003c __errno_location 0084 __socket 00a4 memset 00d8 __bind 011c __close"
	strings:
		$1 = { 2F 84 00 02 94 21 FF 60 7C 08 02 A6 93 81 00 90 7C 9C 23 78 93 E1 00 9C 7C 7F 1B 78 90 01 00 A4 93 41 00 88 93 61 00 8C 93 A1 00 94 93 C1 00 98 41 9E 00 48 2F 84 00 0A 41 9E 01 20 4? ?? ?? ?? 38 00 00 61 90 03 00 00 3B C0 FF FF 80 01 00 A4 7F C3 F3 78 83 41 00 88 7C 08 03 A6 83 61 00 8C 83 81 00 90 83 A1 00 94 83 C1 00 98 83 E1 00 9C 38 21 00 A0 4E 80 00 20 7F 83 E3 78 38 80 00 01 38 A0 00 00 4? ?? ?? ?? 3B 41 00 0A 7C 7E 1B 79 3B 60 00 10 41 80 00 E4 38 61 00 08 38 80 00 00 38 A0 00 80 4? ?? ?? ?? 83 BF 00 00 B3 81 00 08 2F 9D 01 FF 41 9D 00 F4 38 00 02 00 90 1F 00 00 3B A0 02 00 7F A0 EB 78 38 81 00 08 B0 1A 00 00 7F 65 DB 78 7F C3 F3 78 4? ?? ?? ?? 2F 83 00 00 40 BC FF 6C 4? ?? ?? ?? 38 00 03 FF 81 23 00 00 7C 7C 1B 78 2F 89 00 62 40 9E 00 C8 81 3F 00 00 2F 89 02 00 41 9E 00 08 38 09 FF FF 7F 9D 00 00 90 1F 00 00 40 9E FF B4 7F C3 F3 78 4? ?? ?? ?? 38 00 00 0B 90 1C 00 00 3B C0 FF FF 7F C3 F3 78 80 01 00 A4 83 41 00 88 7C 08 03 A6 83 61 00 8C 83 81 00 90 83 A1 00 94 83 C1 00 98 83 E1 00 9C 38 21 00 A0 4E 80 00 20 7F 83 E3 78 38 80 00 01 38 A0 00 00 4? ?? ?? ?? 3B 41 00 0A 7C 7E 1B 79 3B 60 00 1C 40 80 FF 24 80 01 00 A4 3B C0 FF FF 7F C3 F3 78 83 41 00 88 7C 08 03 A6 83 61 00 8C 83 81 00 90 83 A1 00 94 83 C1 00 98 83 E1 00 9C 38 21 00 A0 4E 80 00 20 2F 9D 03 FF 40 BD FF 18 38 00 03 FF 90 1F 00 00 3B A0 03 FF 4B FF FF 08 7F C3 F3 78 4? ?? ?? ?? 3B C0 FF FF 4B FF FE 80 }
	condition:
		$1
}

rule file_251_4_0 {
	meta:
		name = "rcmd_af"
		size = 2348
		refs = "008c __getpid 00d8 __snprintf 00ec getaddrinfo 0118 free 0124 __strdup 0140 __sigblock 0152 _libc_intl_domainname 0188 rresvport_af 01a0 __fcntl 01b0 __connect 01c0 __close 01c4 __errno_location 020c getnameinfo 021c __dcgettext 0230 __asprintf 024c __fxprintf 0260 perror 0310 __sigsetmask 0318 freeaddrinfo 03cc __sleep 0404 __strerror_r 0430 gai_strerror 0488 __listen 04a8 strlen 04b8 __write 04f8 __poll 051c accept 05c4 __writev 05f0 __read"
	strings:
		$1 = { 2B 89 00 0A 94 21 FD C0 7C 08 02 A6 91 C1 01 F8 7C EE 3B 78 91 E1 01 FC 7C CF 33 78 92 01 02 00 7C B0 2B 78 92 21 02 04 7D 11 43 78 92 61 02 0C 7C 73 1B 78 93 C1 02 38 7C 9E 23 78 93 E1 02 3C 7D 3F 4B 78 90 01 02 44 92 41 02 08 92 81 02 10 92 A1 02 14 92 C1 02 18 92 E1 02 1C 93 01 02 20 93 21 02 24 93 41 02 28 93 61 02 2C 93 81 02 30 93 A1 02 34 41 9D 06 00 7D 20 07 34 3D 20 A0 20 7D 2B 00 31 40 80 05 F0 3E 40 ?? ?? 4? ?? ?? ?? 3A 52 ?? ?? 93 E1 00 50 38 00 00 00 38 80 00 08 90 01 00 58 7E 45 93 78 7F C6 F3 78 90 01 00 5C 7C 7B 1B 78 90 01 00 60 3B A0 00 01 38 61 00 1C 90 01 00 64 90 01 00 68 38 00 00 02 90 01 00 4C 93 A1 00 54 4C C6 31 82 4? ?? ?? ?? 38 81 00 1C 80 73 00 00 38 A1 00 4C 38 C1 00 0C 4? ?? ?? ?? 2C 03 00 00 40 82 02 2C 83 E1 00 0C B3 A1 00 28 80 1F 00 18 B3 A1 00 30 2F 80 00 00 41 9E 05 60 3F E0 ?? ?? 80 7F ?? ?? 4? ?? ?? ?? 81 21 00 0C 80 69 00 18 4? ?? ?? ?? 2F 83 00 00 90 7F ?? ?? 41 9E 07 5C 90 73 00 00 83 E1 00 0C 3C 60 00 40 4? ?? ?? ?? 7C 3C 0B 78 38 00 03 FF 90 61 01 E8 3F 40 ?? ?? 3E A0 ?? ?? 94 1C 00 10 3E C0 ?? ?? 3E E0 ?? ?? 3B 00 00 00 3B 20 00 01 3A 80 00 00 3B 5A ?? ?? 3A B5 ?? ?? 3A D6 ?? ?? 3A F7 ?? ?? A0 9F 00 06 7F 83 E3 78 4? ?? ?? ?? 7C 7E 1B 79 41 80 01 54 38 80 00 08 7F 65 DB 78 4C C6 31 82 4? ?? ?? ?? 80 9F 00 14 80 BF 00 10 7F C3 F3 78 4? ?? ?? ?? 2F 83 00 00 40 9C 02 9C 7F C3 F3 78 4? ?? ?? ?? 4? ?? ?? ?? 83 C3 00 00 7C 7D 1B 78 2F 9E 00 62 41 9E 01 D4 2F 9E 00 6F 41 9E 02 04 80 1F 00 1C 2F 80 00 00 41 9E 01 D0 80 9F 00 10 38 C0 00 2E 80 7F 00 14 38 E0 00 00 39 00 00 00 92 81 00 18 39 20 00 01 38 A1 00 6C 4? ?? ?? ?? 7E A4 AB 78 38 A0 00 05 7F 43 D3 78 4? ?? ?? ?? 38 A1 00 6C 7C 64 1B 78 38 61 00 18 4C C6 31 82 4? ?? ?? ?? 2F 83 00 00 41 9C 00 20 80 A1 00 18 38 60 00 00 7E E4 BB 78 4C C6 31 82 4? ?? ?? ?? 80 61 00 18 4? ?? ?? ?? 93 DD 00 00 38 60 00 00 4? ?? ?? ?? 83 FF 00 1C 38 C0 00 2E 80 9F 00 10 38 E0 00 00 80 7F 00 14 39 00 00 00 39 20 00 01 38 A1 00 6C 4? ?? ?? ?? 7E C4 B3 78 38 A0 00 05 7F 43 D3 78 4? ?? ?? ?? 38 A1 00 6C 7C 64 1B 78 38 61 00 18 4C C6 31 82 4? ?? ?? ?? 2F 83 00 00 41 BC FE D0 80 A1 00 18 7E E4 BB 78 38 60 00 00 4C C6 31 82 4? ?? ?? ?? 80 61 00 18 4? ?? ?? ?? A0 9F 00 06 7F 83 E3 78 4? ?? ?? ?? 7C 7E 1B 79 40 80 FE B4 4? ?? ?? ?? 80 03 00 00 2F 80 00 0B 41 9E 03 A0 3C 80 ?? ?? 38 60 00 00 38 84 ?? ?? 4C C6 31 82 4? ?? ?? ?? 80 61 01 E8 3B C0 FF FF 4? ?? ?? ?? 80 61 00 0C 4? ?? ?? ?? 48 00 00 30 2F 83 FF FE 40 9E 01 0C 80 B3 00 00 2F 85 00 00 41 9E 01 00 3C 80 ?? ?? 38 60 00 00 38 84 ?? ?? 4C C6 31 82 4? ?? ?? ?? 3B C0 FF FF 80 01 02 44 7F C3 F3 78 81 C1 01 F8 7C 08 03 A6 81 E1 01 FC 82 01 02 00 82 21 02 04 82 41 02 08 82 61 02 0C 82 81 02 10 82 A1 02 14 82 C1 02 18 82 E1 02 1C 83 01 02 20 83 21 02 24 83 41 02 28 83 61 02 2C 83 81 02 30 83 A1 02 34 83 C1 02 38 83 E1 02 3C 38 21 02 40 4E 80 00 20 81 21 00 10 38 09 FF FF 90 01 00 10 4B FF FD CC 2F 98 00 00 41 9E 00 2C 2F 99 00 10 41 9D 00 24 7F 23 CB 78 4? ?? ?? ?? 57 39 08 3C 83 E1 00 0C 3B 00 00 00 4B FF FD A4 3B 00 00 01 4B FF FD FC 80 61 00 0C 3B C0 FF FF 4? ?? ?? ?? 80 7D 00 00 83 F3 00 00 38 81 01 1C 38 A0 00 C8 4? ?? ?? ?? 3C 80 ?? ?? 7C 66 1B 78 38 84 ?? ?? 7F E5 FB 78 38 60 00 00 4C C6 31 82 4? ?? ?? ?? 80 61 01 E8 4? ?? ?? ?? 4B FF FF 20 4? ?? ?? ?? 3C 80 ?? ?? 7C 65 1B 78 38 84 ?? ?? 38 60 00 00 4C C6 31 82 4? ?? ?? ?? 3B C0 FF FF 4B FF FE FC 2F 91 00 00 81 21 00 10 38 09 FF FF 90 01 00 10 41 9E 02 C0 A0 9F 00 06 7F 83 E3 78 4? ?? ?? ?? 80 1F 00 10 7C 7D 1B 79 90 01 00 14 41 80 01 E0 38 80 00 01 4? ?? ?? ?? 80 C1 00 10 38 80 00 08 7E 45 93 78 38 61 01 1C 4C C6 31 82 4? ?? ?? ?? 38 61 01 1C 4? ?? ?? ?? 38 81 01 1C 38 A3 00 01 7F C3 F3 78 4? ?? ?? ?? 7C 7F 1B 78 38 61 01 1C 4? ?? ?? ?? 38 63 00 01 7F 9F 18 00 40 9E 02 70 93 C1 00 24 93 A1 00 2C 4? ?? ?? ?? 38 00 00 00 90 03 00 00 7C 7F 1B 78 38 80 00 02 38 61 00 24 38 A0 FF FF 4? ?? ?? ?? 2F 83 00 00 40 9D 02 B4 A0 01 00 32 70 09 00 01 41 82 02 A8 7F A3 EB 78 38 81 00 9C 38 A1 00 14 4? ?? ?? ?? 2F 83 FF FF 7C 7C 1B 78 40 9E 00 10 80 1F 00 00 2F 80 00 04 41 9E FF DC A0 01 00 9C 2F 80 00 02 41 9E 01 48 2F 80 00 0A 3B E0 00 00 41 9E 01 3C 7F A3 EB 78 4? ?? ?? ?? 2F 9C 00 00 41 9C 03 68 38 1F FE 00 93 91 00 00 54 00 04 3E 2B 80 01 FF 41 9D 02 94 7E 03 83 78 4? ?? ?? ?? 7C 7D 1B 78 7D E3 7B 78 4? ?? ?? ?? 3B BD 00 01 7C 7F 1B 78 7D C3 73 78 4? ?? ?? ?? 3B FF 00 01 38 63 00 01 92 01 00 34 93 A1 00 38 91 E1 00 3C 93 E1 00 40 91 C1 00 44 90 61 00 48 38 81 00 34 38 A0 00 03 7F C3 F3 78 4? ?? ?? ?? 2F 83 FF FF 40 9E 00 14 4? ?? ?? ?? 80 03 00 00 2F 80 00 04 41 9E FF DC 3B E1 00 08 7F E4 FB 78 38 A0 00 01 7F C3 F3 78 4? ?? ?? ?? 2F 83 FF FF 40 9E 00 CC 4? ?? ?? ?? 80 03 00 00 2F 80 00 04 41 9E FF DC 38 00 00 00 90 01 00 18 80 B3 00 00 3C 80 ?? ?? 38 61 00 18 38 84 ?? ?? 4C C6 31 82 4? ?? ?? ?? 2F 83 00 00 41 9C 00 24 80 A1 00 18 3C 80 ?? ?? 38 84 ?? ?? 38 60 00 00 4C C6 31 82 4? ?? ?? ?? 80 61 00 18 4? ?? ?? ?? 80 01 00 10 2F 80 00 00 40 9E 01 4C 7F C3 F3 78 4? ?? ?? ?? 4B FF FC A0 90 13 00 00 4B FF FA CC 4? ?? ?? ?? 38 00 00 61 90 03 00 00 3B C0 FF FF 4B FF FC C8 A3 E1 00 9E 4B FF FE C4 3C 80 ?? ?? 3C 60 ?? ?? 38 84 ?? ?? 38 A0 00 05 38 63 ?? ?? 4? ?? ?? ?? 3C 80 ?? ?? 7C 65 1B 78 38 84 ?? ?? 38 60 00 00 4C C6 31 82 4? ?? ?? ?? 4B FF FC 48 2F 83 00 01 40 9E 02 1C 88 01 00 08 2F 80 00 00 40 9E 00 18 80 61 01 E8 4? ?? ?? ?? 80 61 00 0C 4? ?? ?? ?? 4B FF FC 64 7F E4 FB 78 38 A0 00 01 7F C3 F3 78 4? ?? ?? ?? 7F E4 FB 78 2F 83 00 01 38 A0 00 01 38 60 00 02 40 BE FF 48 4? ?? ?? ?? 88 01 00 08 2F 80 00 0A 40 9E FF D0 4B FF FF 34 3C 80 ?? ?? 7F C3 F3 78 38 84 ?? ?? 38 A0 00 01 4? ?? ?? ?? 92 21 00 10 4B FF FE 38 38 00 00 00 7C 3F 0B 78 94 1F 00 18 3C 60 ?? ?? 3C 80 ?? ?? 38 A0 00 05 38 84 ?? ?? 38 63 ?? ?? 4? ?? ?? ?? 7C 64 1B 78 7F E3 FB 78 4C C6 31 82 4? ?? ?? ?? 2F 83 00 00 41 9C 00 24 80 A1 00 18 3C 80 ?? ?? 38 60 00 00 38 84 ?? ?? 4C C6 31 82 4? ?? ?? ?? 80 61 00 18 4? ?? ?? ?? 7F A3 EB 78 4? ?? ?? ?? 4B FF FE BC 80 71 00 00 4? ?? ?? ?? 4B FF FE B0 80 1F 00 00 2F 80 00 00 38 00 00 00 90 01 00 18 40 9E 00 80 3F 60 ?? ?? 3B 7B ?? ?? 3B 81 00 18 3C 80 ?? ?? 38 A0 00 05 38 84 ?? ?? 7F 63 DB 78 4? ?? ?? ?? 7C 64 1B 78 7F 83 E3 78 4C C6 31 82 4? ?? ?? ?? 2F 83 00 00 40 9C FF 80 4B FF FF 9C 38 00 00 00 7C 3F 0B 78 94 1F 00 18 3C 60 ?? ?? 3C 80 ?? ?? 38 A0 00 05 38 84 ?? ?? 38 63 ?? ?? 4? ?? ?? ?? 7C 64 1B 78 7F E3 FB 78 4C C6 31 82 4? ?? ?? ?? 2F 83 00 00 40 BC FD F8 4B FF FE 14 3F 60 ?? ?? 3B 7B ?? ?? 3C 80 ?? ?? 38 84 ?? ?? 38 A0 00 05 7F 63 DB 78 4? ?? ?? ?? 3B 81 00 18 7C 64 1B 78 7F 83 E3 78 4C C6 31 82 4? ?? ?? ?? 2F 83 00 00 40 9C FF 04 80 1F 00 00 2F 80 00 00 40 9E FF 18 4B FF FF 4C 3C 80 ?? ?? 3C 60 ?? ?? 38 84 ?? ?? 38 A0 00 05 38 63 ?? ?? 4? ?? ?? ?? 3C 80 ?? ?? 7C 65 1B 78 38 84 ?? ?? 38 60 00 00 4C C6 31 82 4? ?? ?? ?? 3B C0 FF FF 4B FF FA 8C 3C 80 ?? ?? 38 60 00 00 38 84 ?? ?? 4C C6 31 82 4? ?? ?? ?? 38 00 00 00 90 01 00 10 4B FF FD 80 2F 83 00 00 38 00 00 00 90 01 00 18 40 BE FD 24 3C 80 ?? ?? 3C 60 ?? ?? 38 84 ?? ?? 38 A0 00 05 38 63 ?? ?? 4? ?? ?? ?? 80 B3 00 00 7C 64 1B 78 38 61 00 18 4C C6 31 82 4? ?? ?? ?? 2F 83 00 00 40 9C FD 10 4B FF FD 2C }
	condition:
		$1
}

rule file_251_7_0 {
	meta:
		name = "ruserok_af"
		size = 252
		refs = "0068 getaddrinfo 00bc freeaddrinfo"
	strings:
		$1 = { 94 21 FF B0 7C 08 02 A6 93 61 00 3C 7C DB 33 78 38 C1 00 08 90 01 00 54 38 00 00 00 93 81 00 40 7C BC 2B 78 38 A1 00 0C 93 A1 00 44 7C 9D 23 78 38 80 00 00 93 41 00 38 3B 40 FF FF 93 C1 00 48 7C 7E 1B 78 93 E1 00 4C 90 01 00 0C 90 01 00 14 90 01 00 18 90 01 00 1C 90 01 00 20 90 01 00 24 90 01 00 28 90 E1 00 10 4? ?? ?? ?? 2F 83 00 00 40 9E 00 50 83 E1 00 08 2F 9F 00 00 40 BE 00 14 48 00 00 3C 83 FF 00 1C 2F 9F 00 00 41 9E 00 60 80 7F 00 14 7F A5 EB 78 80 9F 00 10 7F 86 E3 78 7F 67 DB 78 7F C8 F3 78 4B FF F2 61 2F 83 00 00 40 9E FF D4 80 61 00 08 3B 40 00 00 4? ?? ?? ?? 80 01 00 54 7F 43 D3 78 83 61 00 3C 7C 08 03 A6 83 41 00 38 83 81 00 40 83 A1 00 44 83 C1 00 48 83 E1 00 4C 38 21 00 50 4E 80 00 20 80 61 00 08 3B 40 FF FF 4? ?? ?? ?? 4B FF FF C8 }
	condition:
		$1
}

rule file_251_9_0 {
	meta:
		name = "iruserok_af"
		size = 248
		refs = "0040 memset"
	strings:
		$1 = { 94 21 FF 60 7C 08 02 A6 93 81 00 90 7C FC 3B 78 93 A1 00 94 7C 9D 23 78 38 80 00 00 93 C1 00 98 7C BE 2B 78 38 A0 00 80 93 E1 00 9C 7C 7F 1B 78 38 61 00 08 93 61 00 8C 7C DB 33 78 90 01 00 A4 4? ?? ?? ?? 2F 9C 00 02 41 9E 00 34 2F 9C 00 0A 38 60 00 00 41 9E 00 78 80 01 00 A4 83 61 00 8C 7C 08 03 A6 83 81 00 90 83 A1 00 94 83 C1 00 98 83 E1 00 9C 38 21 00 A0 4E 80 00 20 80 1F 00 00 38 80 00 10 B3 81 00 08 90 01 00 0C 3D 00 ?? ?? 38 61 00 08 7F A5 EB 78 7F C6 F3 78 7F 67 DB 78 39 08 ?? ?? 4B FF F1 61 80 01 00 A4 83 61 00 8C 7C 08 03 A6 83 81 00 90 83 A1 00 94 83 C1 00 98 83 E1 00 9C 38 21 00 A0 4E 80 00 20 81 5F 00 00 38 80 00 1C 81 7F 00 04 81 3F 00 08 80 1F 00 0C B3 81 00 08 91 41 00 10 91 61 00 14 91 21 00 18 90 01 00 1C 4B FF FF 98 }
	condition:
		$1
}

rule file_251_10_0 {
	meta:
		name = "iruserok"
		size = 48
		refs = "001c iruserok_af"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 38 E0 00 02 7C 29 0B 78 90 01 00 14 94 69 00 08 7D 23 4B 78 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_251_11_0 {
	meta:
		name = "__ivaliduser"
		size = 88
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 7C A9 2B 78 90 01 00 24 3D 00 ?? ?? 38 00 00 00 90 01 00 08 7C C7 33 78 38 A0 00 10 90 81 00 0C 7D 26 4B 78 38 81 00 08 90 01 00 10 39 08 ?? ?? 90 01 00 14 38 00 00 02 B0 01 00 08 4B FF E9 25 80 01 00 24 38 21 00 20 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_252_0_0 {
	meta:
		name = "__hdestroy"
		size = 40
		refs = "0014 hdestroy_r"
		altNames = "hdestroy"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 3C 60 ?? ?? 38 63 ?? ?? 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_697_0_0 {
	meta:
		name = "__chk_fail"
		size = 24
		refs = "0014 __fortify_fail"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 3C 60 ?? ?? 38 63 ?? ?? 90 01 00 14 4? ?? ?? ?? }
	condition:
		$1
}

rule file_1230_0_0 {
	meta:
		name = "__stack_chk_fail"
		size = 24
		refs = "0014 __fortify_fail"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 3C 60 ?? ?? 38 63 ?? ?? 90 01 00 14 4? ?? ?? ?? }
	condition:
		$1
}

rule file_252_1_0 {
	meta:
		name = "hsearch"
		size = 68
		refs = "002c hsearch_r"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 3C C0 ?? ?? 90 01 00 24 38 A1 00 08 38 C6 ?? ?? 81 23 00 00 81 43 00 04 38 61 00 18 91 21 00 18 91 41 00 1C 4? ?? ?? ?? 80 01 00 24 80 61 00 08 38 21 00 20 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_252_2_0 {
	meta:
		name = "hcreate"
		size = 40
		refs = "0014 hcreate_r"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 3C 80 ?? ?? 38 84 ?? ?? 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_700_0_0 {
	meta:
		name = "ether_aton"
		size = 40
		refs = "0014 ether_aton_r"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 3C 80 ?? ?? 38 84 ?? ?? 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_1339_0_0 {
	meta:
		name = "ether_ntoa"
		size = 40
		refs = "0014 ether_ntoa_r"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 3C 80 ?? ?? 38 84 ?? ?? 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_385_0_0 {
	meta:
		name = "lcong48"
		size = 40
		refs = "000a __libc_drand48_data 0014 __lcong48_r"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 3C 80 ?? ?? 38 84 ?? ?? 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_1273_0_0 {
	meta:
		name = "srand48"
		size = 40
		refs = "000a __libc_drand48_data 0014 __srand48_r"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 3C 80 ?? ?? 38 84 ?? ?? 90 01 00 14 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_253_0_0 {
	meta:
		name = "psiginfo"
		size = 1128
		refs = "0038 fmemopen 0066 _sys_siglist 007e _libc_intl_domainname 0088 __dcgettext 00a0 fprintf 01c0 _IO_new_fclose 01c8 strlen 01d8 __write_nocancel 02a4 __fxprintf 0330 __libc_current_sigrtmin 0340 __libc_current_sigrtmax 0444 fwrite"
	strings:
		$1 = { 94 21 FD E0 7C 08 02 A6 3C A0 ?? ?? 93 A1 02 14 38 A5 ?? ?? 7C 9D 23 78 93 C1 02 18 38 80 02 00 7C 7E 1B 78 38 61 00 08 93 E1 02 1C 90 01 02 24 93 61 02 0C 93 81 02 10 4? ?? ?? ?? 7C 7F 1B 79 41 82 02 30 2F 9D 00 00 41 9E 00 10 88 1D 00 00 2F 80 00 00 40 9E 01 AC 83 BE 00 00 2B 9D 00 40 41 9D 01 30 3D 20 ?? ?? 57 A0 10 3A 39 29 ?? ?? 7C 89 00 2E 2F 84 00 00 41 9E 02 B8 3C 60 ?? ?? 38 A0 00 05 38 63 ?? ?? 4? ?? ?? ?? 3C 80 ?? ?? 7C 65 1B 78 38 84 ?? ?? 7F E3 FB 78 4C C6 31 82 4? ?? ?? ?? 81 3E 00 00 38 09 FF FC 2B 80 00 19 40 9D 00 3C 80 BE 00 08 2F 85 FF FD 41 9E 03 14 40 9D 01 58 2F 85 FF FF 41 9E 03 14 41 9C 02 3C 2F 85 00 00 41 9E 03 14 2F 85 00 80 40 BE 01 F0 3C 80 ?? ?? 38 84 ?? ?? 48 00 00 4C 3D 60 ?? ?? 54 00 10 3A 39 6B ?? ?? 7D 2B 02 14 7D 6B 00 2E 81 49 00 68 80 09 00 D0 2F 8A 00 00 41 BE FF A8 80 BE 00 08 2F 85 00 00 40 BD FF A0 7F 80 28 40 41 BC FF 98 7D 4A 2A 14 88 8A FF FF 7C 8B 22 15 41 82 01 9C 3C 60 ?? ?? 38 A0 00 05 38 63 ?? ?? 4? ?? ?? ?? 3C 80 ?? ?? 7C 65 1B 78 38 84 ?? ?? 7F E3 FB 78 4C C6 31 82 4? ?? ?? ?? 80 1E 00 00 2B 80 00 0B 41 9D 00 DC 3D 20 09 90 7D 2B 00 31 40 80 00 D0 80 BE 00 0C 3C 80 ?? ?? 7F E3 FB 78 38 84 ?? ?? 4C C6 31 82 4? ?? ?? ?? 48 00 00 30 3C 60 ?? ?? 3C 80 ?? ?? 38 A0 00 05 38 84 ?? ?? 38 63 ?? ?? 4? ?? ?? ?? 80 BE 00 00 7C 64 1B 78 7F E3 FB 78 4C C6 31 82 4? ?? ?? ?? 7F E3 FB 78 4? ?? ?? ?? 38 61 00 08 4? ?? ?? ?? 38 81 00 08 7C 65 1B 78 38 60 00 02 4? ?? ?? ?? 80 01 02 24 83 61 02 0C 7C 08 03 A6 83 81 02 10 83 A1 02 14 83 C1 02 18 83 E1 02 1C 38 21 02 20 4E 80 00 20 3C 80 ?? ?? 38 84 ?? ?? 7F A5 EB 78 4C C6 31 82 4? ?? ?? ?? 4B FF FE 44 2F 85 FF FA 41 9E 01 D8 40 9D 00 D4 2F 85 FF FB 41 9E 01 D8 2F 85 FF FC 40 BE 00 9C 3C 80 ?? ?? 38 84 ?? ?? 4B FF FE F8 2F 80 00 11 41 9E 01 C8 2F 80 00 1D 41 9E 00 C8 80 BE 00 0C 3C 80 ?? ?? 80 DE 00 10 7F E3 FB 78 38 84 ?? ?? 4C C6 31 82 4? ?? ?? ?? 4B FF FF 50 2F 9D 00 00 41 9E 00 70 88 1D 00 00 2F 80 00 00 41 9E 00 64 3C C0 ?? ?? 38 C6 ?? ?? 80 FE 00 00 3C 80 ?? ?? 7F A5 EB 78 38 84 ?? ?? 38 60 00 00 4C C6 31 82 4? ?? ?? ?? 80 01 02 24 83 61 02 0C 7C 08 03 A6 83 81 02 10 83 A1 02 14 83 C1 02 18 83 E1 02 1C 38 21 02 20 4E 80 00 20 3C 80 ?? ?? 7F E3 FB 78 38 84 ?? ?? 4C C6 31 82 4? ?? ?? ?? 4B FF FE 7C 3C C0 ?? ?? 38 C6 ?? ?? 7C DD 33 78 4B FF FF 9C 2F 85 FF C4 40 9E FF D4 3C 80 ?? ?? 38 84 ?? ?? 4B FF FE 30 3C 80 ?? ?? 38 84 ?? ?? 4B FF FE 24 80 BE 00 0C 3C 80 ?? ?? 7F E3 FB 78 38 84 ?? ?? 4C C6 31 82 4? ?? ?? ?? 4B FF FE 90 4? ?? ?? ?? 7F 9D 18 00 41 9C FE 58 83 BE 00 00 4? ?? ?? ?? 7F 9D 18 00 40 BC FE 48 83 7E 00 00 4? ?? ?? ?? 7C 7C 1B 78 4? ?? ?? ?? 83 BE 00 00 7C 1C D8 50 7C 7D 18 50 7F 80 18 00 40 9C 00 34 4? ?? ?? ?? 7F 9D 18 00 41 9E 00 B8 83 BE 00 00 4? ?? ?? ?? 3C 80 ?? ?? 7C A3 E8 50 38 84 ?? ?? 7F E3 FB 78 4C C6 31 82 4? ?? ?? ?? 4B FF FD 08 4? ?? ?? ?? 7F 9D 18 00 41 9E 00 A4 4? ?? ?? ?? 80 BE 00 00 3C 80 ?? ?? 7C A5 18 50 38 84 ?? ?? 7F E3 FB 78 4C C6 31 82 4? ?? ?? ?? 4B FF FC D8 3C 80 ?? ?? 38 84 ?? ?? 4B FF FD 5C 3C 80 ?? ?? 38 84 ?? ?? 4B FF FD 50 3C 80 ?? ?? 38 84 ?? ?? 4B FF FD 44 3C 80 ?? ?? 38 84 ?? ?? 4B FF FD 38 3C 80 ?? ?? 38 84 ?? ?? 4B FF FD 2C 80 BE 00 0C 3C 80 ?? ?? 80 DE 00 14 7F E3 FB 78 80 FE 00 10 38 84 ?? ?? 4C C6 31 82 4? ?? ?? ?? 4B FF FD 90 3C 60 ?? ?? 38 80 00 01 38 A0 00 0A 7F E6 FB 78 38 63 ?? ?? 4? ?? ?? ?? 4B FF FC 5C 3C 60 ?? ?? 38 80 00 01 38 A0 00 0A 7F E6 FB 78 38 63 ?? ?? 4? ?? ?? ?? 4B FF FC 40 }
	condition:
		$1
}

rule file_254_0_0 {
	meta:
		name = "__strndup"
		size = 100
		refs = "0018 __strnlen 0024 malloc 0040 memcpy"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 93 C1 00 08 7C 7E 1B 78 90 01 00 14 93 E1 00 0C 4? ?? ?? ?? 7C 7F 1B 78 38 63 00 01 4? ?? ?? ?? 38 00 00 00 7C 69 1B 79 41 82 00 18 7C 09 F9 AE 7F C4 F3 78 7F E5 FB 78 4? ?? ?? ?? 7C 60 1B 78 7C 03 03 78 80 01 00 14 83 C1 00 08 7C 08 03 A6 83 E1 00 0C 38 21 00 10 4E 80 00 20 }
	condition:
		$1
}

rule file_255_0_0 {
	meta:
		name = "__libc_init_first"
		size = 180
		refs = "000a _dl_starting_up 0042 __fpu_control 004e __libc_multiple_libcs 0054 __setfpucw 005a __libc_argc 0062 __libc_argv 006a __environ 0070 __libc_init_secure 0074 _dl_non_dynamic_init 0084 __init_misc"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 3D 20 ?? ?? 90 01 00 24 38 09 ?? ?? 2F 80 00 00 93 A1 00 14 7C BD 2B 78 93 C1 00 18 7C 9E 23 78 93 E1 00 1C 7C 7F 1B 78 41 9E 00 10 80 09 ?? ?? 2F 80 00 00 41 9E 00 68 3D 20 ?? ?? 80 69 ?? ?? 38 00 00 00 3D 20 ?? ?? 90 09 ?? ?? 4? ?? ?? ?? 3D 20 ?? ?? 93 E9 ?? ?? 3D 20 ?? ?? 93 C9 ?? ?? 3D 20 ?? ?? 93 A9 ?? ?? 4? ?? ?? ?? 4? ?? ?? ?? 7F E3 FB 78 7F C4 F3 78 7F A5 EB 78 4? ?? ?? ?? 80 01 00 24 83 A1 00 14 7C 08 03 A6 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 38 00 00 01 3D 20 ?? ?? 90 09 ?? ?? 4B FF FF A8 }
	condition:
		$1
}

rule file_256_0_0 {
	meta:
		name = "getspnam"
		size = 440
		refs = "0094 __getspnam_r 00b8 realloc 00cc free 00d2 _GLOBAL_OFFSET_TABLE_ 00de __libc_errno 0160 malloc 018c __lll_lock_wait_private"
	strings:
		$1 = { 94 21 FF C0 7C 08 02 A6 39 60 00 01 93 41 00 28 3F 40 ?? ?? 39 20 00 00 93 A1 00 34 7C 7D 1B 78 93 E1 00 3C 3B FA ?? ?? 90 01 00 44 93 21 00 24 93 61 00 2C 93 81 00 30 93 C1 00 38 7C 00 F8 28 7C 00 48 00 40 82 00 0C 7D 60 F9 2D 40 A2 FF F0 4C 00 01 2C 2F 80 00 00 40 9E 01 30 3F C0 ?? ?? 80 BE ?? ?? 2F 85 00 00 41 9E 00 EC 3F 60 ?? ?? 80 DF 00 04 3B 7B ?? ?? 3B 81 00 08 48 00 00 0C 90 BE ?? ?? 80 DF 00 04 7F 64 DB 78 7F 87 E3 78 7F A3 EB 78 4? ?? ?? ?? 3B 3E ?? ?? 2F 83 00 22 40 9E 00 A4 80 1F 00 04 80 7E ?? ?? 54 00 08 3C 90 1F 00 04 7C 04 03 78 4? ?? ?? ?? 7C 65 1B 79 40 82 FF C0 80 79 00 00 90 A1 00 18 4? ?? ?? ?? 3D 20 ?? ?? 39 29 ?? ?? 80 A1 00 18 81 29 ?? ?? 7D 29 12 14 90 B9 00 00 38 00 00 0C 90 09 00 00 38 00 00 00 90 01 00 08 38 00 00 00 7C 00 04 AC 7D 20 F8 28 7C 00 F9 2D 40 A2 FF F8 2F 89 00 01 41 9D 00 84 80 01 00 44 80 61 00 08 7C 08 03 A6 83 21 00 24 83 41 00 28 83 61 00 2C 83 81 00 30 83 A1 00 34 83 C1 00 38 83 E1 00 3C 38 21 00 40 4E 80 00 20 80 1E ?? ?? 2F 80 00 00 40 9E FF AC 4B FF FF A0 38 00 04 00 90 1F 00 04 38 60 04 00 4? ?? ?? ?? 2F 83 00 00 90 7E ?? ?? 7C 65 1B 78 41 9E FF 80 3F 60 ?? ?? 38 C0 04 00 3B 7B ?? ?? 3B 81 00 08 4B FF FF 04 7F E3 FB 78 4? ?? ?? ?? 4B FF FE CC 80 82 8B 68 38 00 00 DD 7F E3 FB 78 60 84 00 01 38 A0 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF 60 }
	condition:
		$1
}

rule file_1333_0_0 {
	meta:
		name = "getaliasbyname"
		size = 440
		refs = "0094 __getaliasbyname_r 00b8 realloc 00cc free 00d2 _GLOBAL_OFFSET_TABLE_ 00de __libc_errno 0160 malloc 018c __lll_lock_wait_private"
	strings:
		$1 = { 94 21 FF C0 7C 08 02 A6 39 60 00 01 93 41 00 28 3F 40 ?? ?? 39 20 00 00 93 A1 00 34 7C 7D 1B 78 93 E1 00 3C 3B FA ?? ?? 90 01 00 44 93 21 00 24 93 61 00 2C 93 81 00 30 93 C1 00 38 7C 00 F8 28 7C 00 48 00 40 82 00 0C 7D 60 F9 2D 40 A2 FF F0 4C 00 01 2C 2F 80 00 00 40 9E 01 30 3F C0 ?? ?? 80 BE ?? ?? 2F 85 00 00 41 9E 00 EC 3F 60 ?? ?? 80 DF 00 04 3B 7B ?? ?? 3B 81 00 08 48 00 00 0C 90 BE ?? ?? 80 DF 00 04 7F 64 DB 78 7F 87 E3 78 7F A3 EB 78 4? ?? ?? ?? 3B 3E ?? ?? 2F 83 00 22 40 9E 00 A4 80 1F 00 04 80 7E ?? ?? 54 00 08 3C 90 1F 00 04 7C 04 03 78 4? ?? ?? ?? 7C 65 1B 79 40 82 FF C0 80 79 00 00 90 A1 00 18 4? ?? ?? ?? 3D 20 ?? ?? 39 29 ?? ?? 80 A1 00 18 81 29 ?? ?? 7D 29 12 14 90 B9 00 00 38 00 00 0C 90 09 00 00 38 00 00 00 90 01 00 08 38 00 00 00 7C 00 04 AC 7D 20 F8 28 7C 00 F9 2D 40 A2 FF F8 2F 89 00 01 41 9D 00 84 80 01 00 44 80 61 00 08 7C 08 03 A6 83 21 00 24 83 41 00 28 83 61 00 2C 83 81 00 30 83 A1 00 34 83 C1 00 38 83 E1 00 3C 38 21 00 40 4E 80 00 20 80 1E ?? ?? 2F 80 00 00 40 9E FF AC 4B FF FF A0 38 00 04 00 90 1F 00 04 38 60 04 00 4? ?? ?? ?? 2F 83 00 00 90 7E ?? ?? 7C 65 1B 78 41 9E FF 80 3F 60 ?? ?? 38 C0 04 00 3B 7B ?? ?? 3B 81 00 08 4B FF FF 04 7F E3 FB 78 4? ?? ?? ?? 4B FF FE CC 80 82 8B 68 38 00 00 DD 7F E3 FB 78 60 84 00 01 38 A0 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF 60 }
	condition:
		$1
}

rule file_1012_0_0 {
	meta:
		name = "getgrgid"
		size = 440
		refs = "0094 __getgrgid_r 00b8 realloc 00cc free 00d2 _GLOBAL_OFFSET_TABLE_ 00de __libc_errno 0160 malloc 018c __lll_lock_wait_private"
	strings:
		$1 = { 94 21 FF C0 7C 08 02 A6 39 60 00 01 93 41 00 28 3F 40 ?? ?? 39 20 00 00 93 A1 00 34 7C 7D 1B 78 93 E1 00 3C 3B FA ?? ?? 90 01 00 44 93 21 00 24 93 61 00 2C 93 81 00 30 93 C1 00 38 7C 00 F8 28 7C 00 48 00 40 82 00 0C 7D 60 F9 2D 40 A2 FF F0 4C 00 01 2C 2F 80 00 00 40 9E 01 30 3F C0 ?? ?? 80 BE ?? ?? 2F 85 00 00 41 9E 00 EC 3F 60 ?? ?? 80 DF 00 04 3B 7B ?? ?? 3B 81 00 08 48 00 00 0C 90 BE ?? ?? 80 DF 00 04 7F 64 DB 78 7F 87 E3 78 7F A3 EB 78 4? ?? ?? ?? 3B 3E ?? ?? 2F 83 00 22 40 9E 00 A4 80 1F 00 04 80 7E ?? ?? 54 00 08 3C 90 1F 00 04 7C 04 03 78 4? ?? ?? ?? 7C 65 1B 79 40 82 FF C0 80 79 00 00 90 A1 00 18 4? ?? ?? ?? 3D 20 ?? ?? 39 29 ?? ?? 80 A1 00 18 81 29 ?? ?? 7D 29 12 14 90 B9 00 00 38 00 00 0C 90 09 00 00 38 00 00 00 90 01 00 08 38 00 00 00 7C 00 04 AC 7D 20 F8 28 7C 00 F9 2D 40 A2 FF F8 2F 89 00 01 41 9D 00 84 80 01 00 44 80 61 00 08 7C 08 03 A6 83 21 00 24 83 41 00 28 83 61 00 2C 83 81 00 30 83 A1 00 34 83 C1 00 38 83 E1 00 3C 38 21 00 40 4E 80 00 20 80 1E ?? ?? 2F 80 00 00 40 9E FF AC 4B FF FF A0 38 00 04 00 90 1F 00 04 38 60 04 00 4? ?? ?? ?? 2F 83 00 00 90 7E ?? ?? 7C 65 1B 78 41 9E FF 80 3F 60 ?? ?? 38 C0 04 00 3B 7B ?? ?? 3B 81 00 08 4B FF FF 04 7F E3 FB 78 4? ?? ?? ?? 4B FF FE CC 80 82 8B 68 38 00 00 DD 7F E3 FB 78 60 84 00 01 38 A0 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF 60 }
	condition:
		$1
}

rule file_514_0_0 {
	meta:
		name = "getgrnam"
		size = 440
		refs = "0094 __getgrnam_r 00b8 realloc 00cc free 00d2 _GLOBAL_OFFSET_TABLE_ 00de __libc_errno 0160 malloc 018c __lll_lock_wait_private"
	strings:
		$1 = { 94 21 FF C0 7C 08 02 A6 39 60 00 01 93 41 00 28 3F 40 ?? ?? 39 20 00 00 93 A1 00 34 7C 7D 1B 78 93 E1 00 3C 3B FA ?? ?? 90 01 00 44 93 21 00 24 93 61 00 2C 93 81 00 30 93 C1 00 38 7C 00 F8 28 7C 00 48 00 40 82 00 0C 7D 60 F9 2D 40 A2 FF F0 4C 00 01 2C 2F 80 00 00 40 9E 01 30 3F C0 ?? ?? 80 BE ?? ?? 2F 85 00 00 41 9E 00 EC 3F 60 ?? ?? 80 DF 00 04 3B 7B ?? ?? 3B 81 00 08 48 00 00 0C 90 BE ?? ?? 80 DF 00 04 7F 64 DB 78 7F 87 E3 78 7F A3 EB 78 4? ?? ?? ?? 3B 3E ?? ?? 2F 83 00 22 40 9E 00 A4 80 1F 00 04 80 7E ?? ?? 54 00 08 3C 90 1F 00 04 7C 04 03 78 4? ?? ?? ?? 7C 65 1B 79 40 82 FF C0 80 79 00 00 90 A1 00 18 4? ?? ?? ?? 3D 20 ?? ?? 39 29 ?? ?? 80 A1 00 18 81 29 ?? ?? 7D 29 12 14 90 B9 00 00 38 00 00 0C 90 09 00 00 38 00 00 00 90 01 00 08 38 00 00 00 7C 00 04 AC 7D 20 F8 28 7C 00 F9 2D 40 A2 FF F8 2F 89 00 01 41 9D 00 84 80 01 00 44 80 61 00 08 7C 08 03 A6 83 21 00 24 83 41 00 28 83 61 00 2C 83 81 00 30 83 A1 00 34 83 C1 00 38 83 E1 00 3C 38 21 00 40 4E 80 00 20 80 1E ?? ?? 2F 80 00 00 40 9E FF AC 4B FF FF A0 38 00 04 00 90 1F 00 04 38 60 04 00 4? ?? ?? ?? 2F 83 00 00 90 7E ?? ?? 7C 65 1B 78 41 9E FF 80 3F 60 ?? ?? 38 C0 04 00 3B 7B ?? ?? 3B 81 00 08 4B FF FF 04 7F E3 FB 78 4? ?? ?? ?? 4B FF FE CC 80 82 8B 68 38 00 00 DD 7F E3 FB 78 60 84 00 01 38 A0 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF 60 }
	condition:
		$1
}

rule file_300_0_0 {
	meta:
		name = "getpwnam"
		size = 440
		refs = "0094 __getpwnam_r 00b8 realloc 00cc free 00d2 _GLOBAL_OFFSET_TABLE_ 00de __libc_errno 0160 malloc 018c __lll_lock_wait_private"
	strings:
		$1 = { 94 21 FF C0 7C 08 02 A6 39 60 00 01 93 41 00 28 3F 40 ?? ?? 39 20 00 00 93 A1 00 34 7C 7D 1B 78 93 E1 00 3C 3B FA ?? ?? 90 01 00 44 93 21 00 24 93 61 00 2C 93 81 00 30 93 C1 00 38 7C 00 F8 28 7C 00 48 00 40 82 00 0C 7D 60 F9 2D 40 A2 FF F0 4C 00 01 2C 2F 80 00 00 40 9E 01 30 3F C0 ?? ?? 80 BE ?? ?? 2F 85 00 00 41 9E 00 EC 3F 60 ?? ?? 80 DF 00 04 3B 7B ?? ?? 3B 81 00 08 48 00 00 0C 90 BE ?? ?? 80 DF 00 04 7F 64 DB 78 7F 87 E3 78 7F A3 EB 78 4? ?? ?? ?? 3B 3E ?? ?? 2F 83 00 22 40 9E 00 A4 80 1F 00 04 80 7E ?? ?? 54 00 08 3C 90 1F 00 04 7C 04 03 78 4? ?? ?? ?? 7C 65 1B 79 40 82 FF C0 80 79 00 00 90 A1 00 18 4? ?? ?? ?? 3D 20 ?? ?? 39 29 ?? ?? 80 A1 00 18 81 29 ?? ?? 7D 29 12 14 90 B9 00 00 38 00 00 0C 90 09 00 00 38 00 00 00 90 01 00 08 38 00 00 00 7C 00 04 AC 7D 20 F8 28 7C 00 F9 2D 40 A2 FF F8 2F 89 00 01 41 9D 00 84 80 01 00 44 80 61 00 08 7C 08 03 A6 83 21 00 24 83 41 00 28 83 61 00 2C 83 81 00 30 83 A1 00 34 83 C1 00 38 83 E1 00 3C 38 21 00 40 4E 80 00 20 80 1E ?? ?? 2F 80 00 00 40 9E FF AC 4B FF FF A0 38 00 04 00 90 1F 00 04 38 60 04 00 4? ?? ?? ?? 2F 83 00 00 90 7E ?? ?? 7C 65 1B 78 41 9E FF 80 3F 60 ?? ?? 38 C0 04 00 3B 7B ?? ?? 3B 81 00 08 4B FF FF 04 7F E3 FB 78 4? ?? ?? ?? 4B FF FE CC 80 82 8B 68 38 00 00 DD 7F E3 FB 78 60 84 00 01 38 A0 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF 60 }
	condition:
		$1
}

rule file_1061_0_0 {
	meta:
		name = "getpwuid"
		size = 440
		refs = "0094 __getpwuid_r 00b8 realloc 00cc free 00d2 _GLOBAL_OFFSET_TABLE_ 00de __libc_errno 0160 malloc 018c __lll_lock_wait_private"
	strings:
		$1 = { 94 21 FF C0 7C 08 02 A6 39 60 00 01 93 41 00 28 3F 40 ?? ?? 39 20 00 00 93 A1 00 34 7C 7D 1B 78 93 E1 00 3C 3B FA ?? ?? 90 01 00 44 93 21 00 24 93 61 00 2C 93 81 00 30 93 C1 00 38 7C 00 F8 28 7C 00 48 00 40 82 00 0C 7D 60 F9 2D 40 A2 FF F0 4C 00 01 2C 2F 80 00 00 40 9E 01 30 3F C0 ?? ?? 80 BE ?? ?? 2F 85 00 00 41 9E 00 EC 3F 60 ?? ?? 80 DF 00 04 3B 7B ?? ?? 3B 81 00 08 48 00 00 0C 90 BE ?? ?? 80 DF 00 04 7F 64 DB 78 7F 87 E3 78 7F A3 EB 78 4? ?? ?? ?? 3B 3E ?? ?? 2F 83 00 22 40 9E 00 A4 80 1F 00 04 80 7E ?? ?? 54 00 08 3C 90 1F 00 04 7C 04 03 78 4? ?? ?? ?? 7C 65 1B 79 40 82 FF C0 80 79 00 00 90 A1 00 18 4? ?? ?? ?? 3D 20 ?? ?? 39 29 ?? ?? 80 A1 00 18 81 29 ?? ?? 7D 29 12 14 90 B9 00 00 38 00 00 0C 90 09 00 00 38 00 00 00 90 01 00 08 38 00 00 00 7C 00 04 AC 7D 20 F8 28 7C 00 F9 2D 40 A2 FF F8 2F 89 00 01 41 9D 00 84 80 01 00 44 80 61 00 08 7C 08 03 A6 83 21 00 24 83 41 00 28 83 61 00 2C 83 81 00 30 83 A1 00 34 83 C1 00 38 83 E1 00 3C 38 21 00 40 4E 80 00 20 80 1E ?? ?? 2F 80 00 00 40 9E FF AC 4B FF FF A0 38 00 04 00 90 1F 00 04 38 60 04 00 4? ?? ?? ?? 2F 83 00 00 90 7E ?? ?? 7C 65 1B 78 41 9E FF 80 3F 60 ?? ?? 38 C0 04 00 3B 7B ?? ?? 3B 81 00 08 4B FF FF 04 7F E3 FB 78 4? ?? ?? ?? 4B FF FE CC 80 82 8B 68 38 00 00 DD 7F E3 FB 78 60 84 00 01 38 A0 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF 60 }
	condition:
		$1
}

rule file_350_0_0 {
	meta:
		name = "getrpcbyname"
		size = 440
		refs = "0094 __getrpcbyname_r 00b8 realloc 00cc free 00d2 _GLOBAL_OFFSET_TABLE_ 00de __libc_errno 0160 malloc 018c __lll_lock_wait_private"
	strings:
		$1 = { 94 21 FF C0 7C 08 02 A6 39 60 00 01 93 41 00 28 3F 40 ?? ?? 39 20 00 00 93 A1 00 34 7C 7D 1B 78 93 E1 00 3C 3B FA ?? ?? 90 01 00 44 93 21 00 24 93 61 00 2C 93 81 00 30 93 C1 00 38 7C 00 F8 28 7C 00 48 00 40 82 00 0C 7D 60 F9 2D 40 A2 FF F0 4C 00 01 2C 2F 80 00 00 40 9E 01 30 3F C0 ?? ?? 80 BE ?? ?? 2F 85 00 00 41 9E 00 EC 3F 60 ?? ?? 80 DF 00 04 3B 7B ?? ?? 3B 81 00 08 48 00 00 0C 90 BE ?? ?? 80 DF 00 04 7F 64 DB 78 7F 87 E3 78 7F A3 EB 78 4? ?? ?? ?? 3B 3E ?? ?? 2F 83 00 22 40 9E 00 A4 80 1F 00 04 80 7E ?? ?? 54 00 08 3C 90 1F 00 04 7C 04 03 78 4? ?? ?? ?? 7C 65 1B 79 40 82 FF C0 80 79 00 00 90 A1 00 18 4? ?? ?? ?? 3D 20 ?? ?? 39 29 ?? ?? 80 A1 00 18 81 29 ?? ?? 7D 29 12 14 90 B9 00 00 38 00 00 0C 90 09 00 00 38 00 00 00 90 01 00 08 38 00 00 00 7C 00 04 AC 7D 20 F8 28 7C 00 F9 2D 40 A2 FF F8 2F 89 00 01 41 9D 00 84 80 01 00 44 80 61 00 08 7C 08 03 A6 83 21 00 24 83 41 00 28 83 61 00 2C 83 81 00 30 83 A1 00 34 83 C1 00 38 83 E1 00 3C 38 21 00 40 4E 80 00 20 80 1E ?? ?? 2F 80 00 00 40 9E FF AC 4B FF FF A0 38 00 04 00 90 1F 00 04 38 60 04 00 4? ?? ?? ?? 2F 83 00 00 90 7E ?? ?? 7C 65 1B 78 41 9E FF 80 3F 60 ?? ?? 38 C0 04 00 3B 7B ?? ?? 3B 81 00 08 4B FF FF 04 7F E3 FB 78 4? ?? ?? ?? 4B FF FE CC 80 82 8B 68 38 00 00 DD 7F E3 FB 78 60 84 00 01 38 A0 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF 60 }
	condition:
		$1
}

rule file_527_0_0 {
	meta:
		name = "getrpcbynumber"
		size = 440
		refs = "0094 __getrpcbynumber_r 00b8 realloc 00cc free 00d2 _GLOBAL_OFFSET_TABLE_ 00de __libc_errno 0160 malloc 018c __lll_lock_wait_private"
	strings:
		$1 = { 94 21 FF C0 7C 08 02 A6 39 60 00 01 93 41 00 28 3F 40 ?? ?? 39 20 00 00 93 A1 00 34 7C 7D 1B 78 93 E1 00 3C 3B FA ?? ?? 90 01 00 44 93 21 00 24 93 61 00 2C 93 81 00 30 93 C1 00 38 7C 00 F8 28 7C 00 48 00 40 82 00 0C 7D 60 F9 2D 40 A2 FF F0 4C 00 01 2C 2F 80 00 00 40 9E 01 30 3F C0 ?? ?? 80 BE ?? ?? 2F 85 00 00 41 9E 00 EC 3F 60 ?? ?? 80 DF 00 04 3B 7B ?? ?? 3B 81 00 08 48 00 00 0C 90 BE ?? ?? 80 DF 00 04 7F 64 DB 78 7F 87 E3 78 7F A3 EB 78 4? ?? ?? ?? 3B 3E ?? ?? 2F 83 00 22 40 9E 00 A4 80 1F 00 04 80 7E ?? ?? 54 00 08 3C 90 1F 00 04 7C 04 03 78 4? ?? ?? ?? 7C 65 1B 79 40 82 FF C0 80 79 00 00 90 A1 00 18 4? ?? ?? ?? 3D 20 ?? ?? 39 29 ?? ?? 80 A1 00 18 81 29 ?? ?? 7D 29 12 14 90 B9 00 00 38 00 00 0C 90 09 00 00 38 00 00 00 90 01 00 08 38 00 00 00 7C 00 04 AC 7D 20 F8 28 7C 00 F9 2D 40 A2 FF F8 2F 89 00 01 41 9D 00 84 80 01 00 44 80 61 00 08 7C 08 03 A6 83 21 00 24 83 41 00 28 83 61 00 2C 83 81 00 30 83 A1 00 34 83 C1 00 38 83 E1 00 3C 38 21 00 40 4E 80 00 20 80 1E ?? ?? 2F 80 00 00 40 9E FF AC 4B FF FF A0 38 00 04 00 90 1F 00 04 38 60 04 00 4? ?? ?? ?? 2F 83 00 00 90 7E ?? ?? 7C 65 1B 78 41 9E FF 80 3F 60 ?? ?? 38 C0 04 00 3B 7B ?? ?? 3B 81 00 08 4B FF FF 04 7F E3 FB 78 4? ?? ?? ?? 4B FF FE CC 80 82 8B 68 38 00 00 DD 7F E3 FB 78 60 84 00 01 38 A0 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF 60 }
	condition:
		$1
}

rule file_495_0_0 {
	meta:
		name = "getsgnam"
		size = 440
		refs = "0094 __getsgnam_r 00b8 realloc 00cc free 00d2 _GLOBAL_OFFSET_TABLE_ 00de __libc_errno 0160 malloc 018c __lll_lock_wait_private"
	strings:
		$1 = { 94 21 FF C0 7C 08 02 A6 39 60 00 01 93 41 00 28 3F 40 ?? ?? 39 20 00 00 93 A1 00 34 7C 7D 1B 78 93 E1 00 3C 3B FA ?? ?? 90 01 00 44 93 21 00 24 93 61 00 2C 93 81 00 30 93 C1 00 38 7C 00 F8 28 7C 00 48 00 40 82 00 0C 7D 60 F9 2D 40 A2 FF F0 4C 00 01 2C 2F 80 00 00 40 9E 01 30 3F C0 ?? ?? 80 BE ?? ?? 2F 85 00 00 41 9E 00 EC 3F 60 ?? ?? 80 DF 00 04 3B 7B ?? ?? 3B 81 00 08 48 00 00 0C 90 BE ?? ?? 80 DF 00 04 7F 64 DB 78 7F 87 E3 78 7F A3 EB 78 4? ?? ?? ?? 3B 3E ?? ?? 2F 83 00 22 40 9E 00 A4 80 1F 00 04 80 7E ?? ?? 54 00 08 3C 90 1F 00 04 7C 04 03 78 4? ?? ?? ?? 7C 65 1B 79 40 82 FF C0 80 79 00 00 90 A1 00 18 4? ?? ?? ?? 3D 20 ?? ?? 39 29 ?? ?? 80 A1 00 18 81 29 ?? ?? 7D 29 12 14 90 B9 00 00 38 00 00 0C 90 09 00 00 38 00 00 00 90 01 00 08 38 00 00 00 7C 00 04 AC 7D 20 F8 28 7C 00 F9 2D 40 A2 FF F8 2F 89 00 01 41 9D 00 84 80 01 00 44 80 61 00 08 7C 08 03 A6 83 21 00 24 83 41 00 28 83 61 00 2C 83 81 00 30 83 A1 00 34 83 C1 00 38 83 E1 00 3C 38 21 00 40 4E 80 00 20 80 1E ?? ?? 2F 80 00 00 40 9E FF AC 4B FF FF A0 38 00 04 00 90 1F 00 04 38 60 04 00 4? ?? ?? ?? 2F 83 00 00 90 7E ?? ?? 7C 65 1B 78 41 9E FF 80 3F 60 ?? ?? 38 C0 04 00 3B 7B ?? ?? 3B 81 00 08 4B FF FF 04 7F E3 FB 78 4? ?? ?? ?? 4B FF FE CC 80 82 8B 68 38 00 00 DD 7F E3 FB 78 60 84 00 01 38 A0 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF 60 }
	condition:
		$1
}

rule file_257_0_0 {
	meta:
		name = "timerfd_settime"
		size = 16
		refs = "000c __syscall_error"
	strings:
		$1 = { 38 00 01 37 44 00 00 02 4C A3 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_258_0_0 {
	meta:
		name = "init_module"
		size = 16
		refs = "000c __syscall_error"
	strings:
		$1 = { 38 00 00 80 44 00 00 02 4C A3 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_259_0_0 {
	meta:
		name = "print_errno_message"
		size = 64
		refs = "0014 __strerror_r 002c __fxprintf"
	strings:
		$1 = { 94 21 FB F0 7C 08 02 A6 38 A0 04 00 38 81 00 08 90 01 04 14 4? ?? ?? ?? 3C 80 ?? ?? 7C 65 1B 78 38 84 ?? ?? 38 60 00 00 4C C6 31 82 4? ?? ?? ?? 80 01 04 14 38 21 04 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_259_1_0 {
	meta:
		name = "error_tail"
		size = 644
		refs = "000e stderr 0064 strlen 00d4 __mbsrtowcs 00f4 __vfwprintf 0104 free 010e error_message_count 0130 __fxprintf 0138 _IO_fflush 01d0 vfprintf 01ec __libc_alloca_cutoff 020c realloc 0238 fputws_unlocked 0280 exit"
	strings:
		$1 = { 94 21 FF B0 7C 08 02 A6 93 01 00 30 3F 00 ?? ?? 90 01 00 54 81 38 ?? ?? 92 A1 00 24 7C D5 33 78 80 09 00 6C 92 C1 00 28 7C 76 1B 78 2F 80 00 00 92 E1 00 2C 7C 97 23 78 93 61 00 3C 7C BB 2B 78 93 E1 00 4C 7C 3F 0B 78 93 21 00 34 93 41 00 38 93 81 00 40 93 A1 00 44 93 C1 00 48 40 9D 01 68 7C A3 2B 78 4? ?? ?? ?? 3F 40 7F FF 3B C3 00 01 3B 20 00 00 3B A0 00 00 3B 80 00 00 63 5A FF FE 48 00 00 10 7F 9E D0 40 41 9D 00 FC 57 DE 08 3C 57 C4 10 3A 2B 84 80 00 41 9D 01 4C 38 84 00 1E 80 01 00 00 54 84 00 36 7C 84 00 D0 7C 01 21 6E 3B A1 00 17 57 BD 00 36 7F A3 EB 78 93 9F 00 0C 38 9F 00 08 7F C5 F3 78 93 9F 00 10 38 DF 00 0C 93 7F 00 08 4? ?? ?? ?? 7F 9E 18 00 41 9E FF A8 2F 83 FF FF 41 9E 00 A0 80 78 ?? ?? 7F A4 EB 78 7E A5 AB 78 4? ?? ?? ?? 2F 99 00 00 41 BE 00 0C 7F A3 EB 78 4? ?? ?? ?? 2F 97 00 00 3D 20 ?? ?? 81 69 ?? ?? 38 0B 00 01 90 09 ?? ?? 40 9E 00 9C 3C 80 ?? ?? 38 84 ?? ?? 38 60 00 00 4C C6 31 82 4? ?? ?? ?? 80 78 ?? ?? 4? ?? ?? ?? 2F 96 00 00 40 9E 01 3C 39 7F 00 50 80 0B 00 04 82 AB FF D4 7C 08 03 A6 82 CB FF D8 82 EB FF DC 83 0B FF E0 83 2B FF E4 83 4B FF E8 83 6B FF EC 83 8B FF F0 83 AB FF F4 83 CB FF F8 83 EB FF FC 7D 61 5B 78 4E 80 00 20 2F 99 00 00 40 9E 00 50 80 78 ?? ?? 3C 80 ?? ?? 38 84 ?? ?? 7E A5 AB 78 4? ?? ?? ?? 2F 97 00 00 3D 20 ?? ?? 81 69 ?? ?? 38 0B 00 01 90 09 ?? ?? 41 9E FF 6C 7E E3 BB 78 4B FF FE 05 4B FF FF 60 7C A4 2B 78 7D 23 4B 78 7C C5 33 78 4? ?? ?? ?? 4B FF FF 34 7F A3 EB 78 4? ?? ?? ?? 4B FF FF AC 7C 83 23 78 90 9F 00 18 4? ?? ?? ?? 2F 83 00 00 80 9F 00 18 40 9E FE A4 2F 99 00 00 40 9E 00 08 3B A0 00 00 7F A3 EB 78 4? ?? ?? ?? 2C 03 00 00 41 82 00 10 7C 7D 1B 78 3B 20 00 01 4B FF FE 98 7F A3 EB 78 4? ?? ?? ?? 80 98 ?? ?? 3C 60 ?? ?? 38 63 ?? ?? 4? ?? ?? ?? 39 7F 00 50 80 0B 00 04 82 AB FF D4 7C 08 03 A6 82 CB FF D8 82 EB FF DC 83 0B FF E0 83 2B FF E4 83 4B FF E8 83 6B FF EC 83 8B FF F0 83 AB FF F4 83 CB FF F8 83 EB FF FC 7D 61 5B 78 4E 80 00 20 7E C3 B3 78 4? ?? ?? ?? }
	condition:
		$1
}

rule file_259_2_0 {
	meta:
		name = "__error"
		size = 304
		refs = "005e pthread_setcancelstate 0086 stdout 008c _IO_fflush 0092 error_print_progname 0112 program_invocation_name 0128 __fxprintf"
		altNames = "error"
	strings:
		$1 = { 94 21 FF 80 7C 08 02 A6 93 C1 00 78 7C 7E 1B 78 93 E1 00 7C 7C 9F 23 78 90 01 00 84 93 81 00 70 93 A1 00 74 90 C1 00 1C 90 E1 00 20 91 01 00 24 91 21 00 28 91 41 00 2C 40 86 00 24 D8 21 00 30 D8 41 00 38 D8 61 00 40 D8 81 00 48 D8 A1 00 50 D8 C1 00 58 D8 E1 00 60 D9 01 00 68 3F A0 ?? ?? 3B BD ?? ?? 2F 9D 00 00 38 00 00 00 7C BC 2B 78 90 01 00 08 41 9E 00 10 38 60 00 01 38 81 00 08 4? ?? ?? ?? 3D 20 ?? ?? 80 69 ?? ?? 4? ?? ?? ?? 3D 20 ?? ?? 80 09 ?? ?? 2F 80 00 00 41 9E 00 74 7C 09 03 A6 4E 80 04 21 7C 29 0B 78 38 01 00 88 94 09 00 10 38 00 00 03 7F C3 F3 78 98 01 00 0C 7F E4 FB 78 38 00 00 00 7F 85 E3 78 98 01 00 0D 38 C1 00 0C 91 21 00 14 4B FF FC A5 2F 9D 00 00 41 9E 00 10 80 61 00 08 38 80 00 00 4? ?? ?? ?? 80 01 00 84 83 81 00 70 7C 08 03 A6 83 A1 00 74 83 C1 00 78 83 E1 00 7C 38 21 00 80 4E 80 00 20 3D 20 ?? ?? 80 A9 ?? ?? 3C 80 ?? ?? 38 84 ?? ?? 38 60 00 00 4C C6 31 82 4? ?? ?? ?? 4B FF FF 7C }
	condition:
		$1
}

rule file_259_3_0 {
	meta:
		name = "__error_at_line"
		size = 452
		refs = "006a error_one_per_line 009a pthread_setcancelstate 00c2 stdout 00c8 _IO_fflush 00ce error_print_progname 0104 __fxprintf 0188 strcmp 01a6 program_invocation_name"
		altNames = "error_at_line"
	strings:
		$1 = { 94 21 FF 70 7C 08 02 A6 93 81 00 80 7C DC 33 78 93 A1 00 84 7C 7D 1B 78 93 C1 00 88 7C 9E 23 78 93 E1 00 8C 7C BF 2B 78 90 01 00 94 93 21 00 74 93 41 00 78 93 61 00 7C 91 01 00 1C 91 21 00 20 91 41 00 24 40 86 00 24 D8 21 00 28 D8 41 00 30 D8 61 00 38 D8 81 00 40 D8 A1 00 48 D8 C1 00 50 D8 E1 00 58 D9 01 00 60 3D 20 ?? ?? 80 09 ?? ?? 7C F9 3B 78 2F 80 00 00 41 9E 00 20 3F 60 ?? ?? 80 1B ?? ?? 3B 5B ?? ?? 7F 80 E0 00 41 9E 00 EC 93 FA 00 04 93 9B ?? ?? 3F 40 ?? ?? 3B 5A ?? ?? 2F 9A 00 00 7C 3B 0B 78 38 00 00 00 94 1B 00 08 41 9E 00 10 38 60 00 01 7F 64 DB 78 4? ?? ?? ?? 3D 20 ?? ?? 80 69 ?? ?? 4? ?? ?? ?? 3D 20 ?? ?? 80 09 ?? ?? 2F 80 00 00 41 9E 00 CC 7C 09 03 A6 4E 80 04 21 2F 9F 00 00 41 9E 00 B0 3C 80 ?? ?? 38 84 ?? ?? 7F E5 FB 78 7F 86 E3 78 38 60 00 00 4C C6 31 82 4? ?? ?? ?? 38 00 00 05 98 01 00 0C 38 00 00 00 7F A3 EB 78 98 01 00 0D 7F C4 F3 78 38 01 00 98 7F 25 CB 78 90 01 00 10 38 C1 00 0C 93 61 00 14 4B FF FB 19 2F 9A 00 00 41 9E 00 10 80 61 00 08 38 80 00 00 4? ?? ?? ?? 80 01 00 94 83 21 00 74 7C 08 03 A6 83 41 00 78 83 61 00 7C 83 81 00 80 83 A1 00 84 83 C1 00 88 83 E1 00 8C 38 21 00 90 4E 80 00 20 80 7A 00 04 7F 9F 18 00 41 BE FF CC 7F E4 FB 78 4? ?? ?? ?? 2F 83 00 00 40 9E FF 00 4B FF FF B8 3C 80 ?? ?? 38 84 ?? ?? 4B FF FF 54 3D 20 ?? ?? 80 A9 ?? ?? 3C 80 ?? ?? 38 84 ?? ?? 38 60 00 00 4C C6 31 82 4? ?? ?? ?? 4B FF FF 24 }
	condition:
		$1
}

rule file_260_0_0 {
	meta:
		name = "__sched_getparam"
		size = 16
		refs = "000c __syscall_error"
	strings:
		$1 = { 38 00 00 9B 44 00 00 02 4C A3 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_261_0_0 {
	meta:
		name = "object_compare"
		size = 160
	strings:
		$1 = { 81 63 00 08 7C 69 1B 78 80 04 00 08 7F 8B 00 40 7C 60 00 26 54 63 F7 FE 7C 00 00 26 54 00 EF FE 7C 60 18 51 4C 82 00 20 81 69 00 00 38 60 00 01 81 44 00 00 81 29 00 04 7F 8B 50 40 81 04 00 04 40 9D 00 2C 7F 8A 58 40 38 00 00 01 40 9D 00 0C 7C 60 18 50 4E 80 00 20 7F 8A 58 00 41 9E 00 38 38 00 00 00 7C 60 18 50 4E 80 00 20 7F 8B 50 00 41 9E 00 18 7F 8A 58 40 38 60 00 00 38 00 00 01 41 BD FF D0 4B FF FF D4 7F 89 40 40 41 BD FF B8 4B FF FF E4 7F 88 48 40 41 BD FF B8 4B FF FF C4 }
	condition:
		$1
}

rule file_261_1_0 {
	meta:
		name = "add_object.clone.0"
		size = 136
		refs = "0028 malloc 005c __tsearch"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 93 E1 00 1C 7C 7F 1B 78 38 60 00 10 90 01 00 24 93 A1 00 14 7C BD 2B 78 93 C1 00 18 7C 9E 23 78 4? ?? ?? ?? 38 00 FF FF 7C 6B 1B 79 41 82 00 34 80 1D 00 00 3C A0 ?? ?? 81 3E 00 00 38 9F 00 30 81 5E 00 04 38 A5 ?? ?? 90 0B 00 08 91 2B 00 00 91 4B 00 04 4? ?? ?? ?? 30 03 FF FF 7C 00 01 10 7C 03 03 78 80 01 00 24 83 A1 00 14 7C 08 03 A6 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 }
	condition:
		$1
}

rule file_261_2_0 {
	meta:
		name = "process_entry"
		size = 872
		refs = "0064 mempcpy 009c __fxstatat 016c __lxstat 0178 __errno_location 0218 __tfind 024c __xstat 0334 realloc"
	strings:
		$1 = { 94 21 FF 60 7C 08 02 A6 93 61 00 8C 7C FB 3B 78 93 81 00 90 7C 9C 23 78 93 C1 00 98 7C BE 2B 78 93 E1 00 9C 7C 7F 1B 78 90 01 00 A4 93 A1 00 94 88 05 00 00 2F 80 00 2E 41 9E 00 E4 81 3F 00 14 80 1F 00 10 38 89 00 02 7C 84 32 14 7F 84 00 40 41 9D 02 D4 80 1F 00 0C 7C 60 4A 14 7F C4 F3 78 7C C5 33 78 4? ?? ?? ?? 38 00 00 00 98 03 00 00 80 9C 00 04 2F 84 FF FF 41 9E 00 CC 80 1F 00 1C 38 E0 00 00 70 09 00 01 40 82 00 8C 3B A1 00 18 38 60 00 03 7F C5 F3 78 7F A6 EB 78 4? ?? ?? ?? 2F 83 00 00 41 9C 00 D4 80 01 00 28 54 00 04 26 2F 80 40 00 41 9E 01 7C 6C 09 FF FF 2F 89 A0 00 41 9E 02 20 80 1F 00 1C 39 20 00 00 70 0B 00 02 41 82 01 10 81 7F 00 28 81 41 00 18 7F 8A 58 00 41 9E 00 F0 70 09 00 10 38 60 00 00 40 82 00 B4 80 01 00 A4 83 61 00 8C 7C 08 03 A6 83 81 00 90 83 A1 00 94 83 C1 00 98 83 E1 00 9C 38 21 00 A0 4E 80 00 20 38 E0 01 00 4B FF FF 74 88 05 00 01 38 60 00 00 2F 80 00 00 41 BE FF C8 2F 80 00 2E 40 9E FF 0C 88 05 00 02 2F 80 00 00 40 9E FF 00 4B FF FF B0 80 1F 00 1C 70 0B 00 04 40 82 00 08 83 DF 00 0C 70 09 00 01 41 82 00 E4 3B A1 00 18 38 60 00 03 7F C4 F3 78 7F A5 EB 78 4? ?? ?? ?? 2F 83 00 00 40 9C FF 34 4? ?? ?? ?? 80 03 00 00 2F 80 00 0D 41 9E 00 D0 2F 80 00 02 41 9E 00 C8 80 1F 00 1C 38 60 FF FF 70 09 00 10 41 A2 FF 54 2F 83 00 02 40 9E FF 4C 80 01 00 A4 38 60 00 00 83 61 00 8C 7C 08 03 A6 83 81 00 90 83 A1 00 94 83 C1 00 98 83 E1 00 9C 38 21 00 A0 4E 80 00 20 81 7F 00 2C 81 41 00 1C 7F 8A 58 00 40 9E FF 08 2F 89 00 01 40 9E 00 D0 70 09 00 01 40 82 01 18 81 21 00 18 3C A0 ?? ?? 81 41 00 1C 38 61 00 08 80 01 00 24 38 9F 00 30 38 A5 ?? ?? 91 21 00 08 91 41 00 0C 90 01 00 10 4? ?? ?? ?? 2F 83 00 00 41 9E 00 CC 80 1F 00 1C 38 60 00 00 4B FF FF 6C 80 1F 00 1C 39 20 00 01 4B FF FE 94 3B A1 00 18 7F C4 F3 78 7F A5 EB 78 38 60 00 03 4? ?? ?? ?? 4B FF FE 50 80 1F 00 1C 70 0B 00 01 40 82 00 54 2F 9B 00 0A 41 9E 00 B8 80 9C 00 04 2F 84 FF FF 41 9E 00 E4 38 60 00 03 7F C5 F3 78 7F A6 EB 78 38 E0 01 00 4? ?? ?? ?? 2F 83 00 00 40 9E 00 24 81 21 00 28 55 29 04 26 6D 20 FF FF 2F 80 A0 00 40 9E 00 10 80 1F 00 1C 39 20 00 06 4B FF FE 20 39 20 00 03 80 1F 00 24 55 29 10 3A 81 7F 00 20 7F A4 EB 78 7C 09 03 A6 80 7F 00 0C 7C AB 48 2E 38 DF 00 14 4E 80 04 21 80 1F 00 1C 4B FF FE BC 80 1F 00 1C 39 20 00 04 4B FF FD E4 7F E3 FB 78 7F A4 EB 78 38 A1 00 24 4B FF FC 81 2C 03 00 00 40 82 00 14 7F E3 FB 78 7F A4 EB 78 7F 85 E3 78 48 00 00 59 80 1F 00 1C 4B FF FE 80 39 20 00 06 4B FF FD AC 54 84 08 3C 80 7F 00 0C 90 9F 00 10 90 C1 00 78 4? ?? ?? ?? 7C 60 1B 79 80 C1 00 78 38 60 FF FF 41 A2 FD AC 90 1F 00 0C 81 3F 00 14 4B FF FD 08 7F C4 F3 78 7F A5 EB 78 38 60 00 03 4? ?? ?? ?? 4B FF FF 24 }
	condition:
		$1
}

rule file_261_3_0 {
	meta:
		name = "ftw_dir"
		size = 1728
		refs = "0080 malloc 00a8 strlen 00dc realloc 00f8 mempcpy 0108 __readdir64 0158 __closedir 01a4 __openat64_nocancel 01bc __fdopendir 0230 __rawmemchr 02b0 __errno_location 038c __fchdir 03ac __chdir 0418 __opendir 04ec free 0688 __assert_fail"
	strings:
		$1 = { 7D 80 00 26 2E 05 00 00 94 21 FF B0 7C 08 02 A6 90 01 00 54 93 81 00 40 7C 9C 23 78 93 A1 00 44 93 C1 00 48 7C BE 2B 78 93 E1 00 4C 7C 7F 1B 78 92 61 00 1C 92 81 00 20 92 A1 00 24 92 C1 00 28 92 E1 00 2C 93 01 00 30 93 21 00 34 93 41 00 38 93 61 00 3C 91 81 00 18 83 A3 00 14 41 92 04 9C 3A C5 00 04 80 1F 00 04 81 3F 00 00 54 00 10 3A 7F 69 00 2E 2F 9B 00 00 41 9E 01 04 38 60 04 00 4? ?? ?? ?? 7C 79 1B 79 41 82 03 A0 83 1B 00 00 3A 80 00 00 3B 40 04 00 3A E0 00 00 48 00 00 68 3A 73 00 13 7E 63 9B 78 4? ?? ?? ?? 7F 63 A2 14 38 1B 00 02 7F 80 D0 40 7C 75 1B 78 41 9C 00 30 54 60 08 3C 2B 80 04 00 40 9C 00 08 38 00 04 00 7F 5A 02 14 7F 23 CB 78 7F 44 D3 78 4? ?? ?? ?? 2C 03 00 00 41 82 03 F8 7C 79 1B 78 7C 79 A2 14 7E 64 9B 78 7E A5 AB 78 4? ?? ?? ?? 3A 9B 00 01 9A E3 00 00 7F 03 C3 78 4? ?? ?? ?? 7C 73 1B 79 40 82 FF 90 7E 79 A1 AE 7F 23 CB 78 38 94 00 01 80 1F 00 04 81 3F 00 00 54 00 10 3A 7F 69 00 2E 4? ?? ?? ?? 80 1F 00 04 81 3F 00 00 54 00 10 3A 90 7B 00 08 7D 29 00 2E 80 09 00 08 2F 80 00 00 41 9E 04 C4 7F 03 C3 78 4? ?? ?? ?? 80 1F 00 04 81 3F 00 00 39 40 FF FF 54 00 10 3A 7D 69 00 2E 92 6B 00 00 91 4B 00 04 7E 69 01 2E 2F 96 00 00 41 9E 02 88 80 76 00 00 2F 83 FF FF 41 9E 02 7C 80 1F 00 14 38 A0 48 00 80 9F 00 0C 38 C0 00 00 7C 84 02 14 4? ?? ?? ?? 38 00 00 00 2F 83 FF FF 90 01 00 08 7C 7B 1B 78 41 9E 02 70 4? ?? ?? ?? 2F 83 00 00 90 61 00 08 41 9E 04 8C 81 3F 00 04 3B 61 00 08 81 7F 00 08 38 09 00 01 81 03 00 00 7F 80 58 00 81 5F 00 00 39 60 00 00 91 01 00 0C 55 29 10 3A 91 61 00 10 7F 6A 49 2E 90 1F 00 04 41 9E 03 90 80 1F 00 1C 70 09 00 08 41 82 02 F4 70 09 00 04 40 82 03 18 81 3F 00 18 38 80 00 00 83 5F 00 0C 38 09 00 01 90 1F 00 18 7F 43 D3 78 4? ?? ?? ?? 7F 9A 18 00 41 9E 04 34 88 03 FF FF 2F 80 00 2F 41 9E 00 14 38 00 00 2F 98 03 00 00 38 63 00 01 83 5F 00 0C 7C 7A 18 50 90 7F 00 14 80 61 00 08 2F 83 00 00 41 9E 03 30 4? ?? ?? ?? 7C 7A 1B 79 41 82 03 BC 3B 3A 00 13 7F 23 CB 78 4? ?? ?? ?? 88 FA 00 12 7C 66 1B 78 7F 64 DB 78 7F E3 FB 78 7F 25 CB 78 4B FF FA 01 7C 78 1B 79 41 82 FF C0 83 41 00 08 2F 9A 00 00 41 9E 04 00 4? ?? ?? ?? 80 01 00 10 7C 7B 1B 78 83 23 00 00 2F 80 00 00 40 9E 03 C8 7F 43 D3 78 4? ?? ?? ?? 38 00 FF FF 90 01 00 0C 93 3B 00 00 81 3F 00 04 2F 89 00 00 38 09 FF FF 90 1F 00 04 40 9E 00 10 81 3F 00 08 38 09 FF FF 90 1F 00 04 81 3F 00 00 54 00 10 3A 39 60 00 00 7D 69 01 2E 80 1F 00 1C 70 09 00 10 41 82 00 0C 2F 98 00 03 41 9E 01 44 80 1F 00 14 2F 98 00 00 81 3F 00 0C 7D 29 02 14 38 00 00 00 98 09 FF FF 81 3F 00 18 93 BF 00 14 38 09 FF FF 90 1F 00 18 41 9E 01 3C 41 92 00 6C 80 1F 00 1C 70 09 00 04 41 82 00 60 2F 98 00 00 41 9E 00 1C 70 09 00 10 41 82 00 50 2F 98 FF FF 41 9E 00 48 2F 98 00 01 41 9E 00 40 81 3E 00 00 2F 89 00 00 41 9E 00 14 80 69 00 00 4? ?? ?? ?? 2F 83 00 00 41 9E 00 24 80 1F 00 14 2F 80 00 01 41 9E 02 98 3C 60 ?? ?? 38 63 ?? ?? 4? ?? ?? ?? 2F 83 00 00 41 9C 02 98 80 01 00 54 7F 03 C3 78 81 81 00 18 7C 08 03 A6 82 61 00 1C 82 81 00 20 7D 80 81 20 82 A1 00 24 82 C1 00 28 82 E1 00 2C 83 01 00 30 83 21 00 34 83 41 00 38 83 61 00 3C 83 81 00 40 83 A1 00 44 83 C1 00 48 83 E1 00 4C 38 21 00 50 4E 80 00 20 80 1F 00 1C 70 09 00 04 40 82 00 A8 80 7F 00 0C 4? ?? ?? ?? 90 61 00 08 2F 83 00 00 40 9E FD A8 4? ?? ?? ?? 83 C3 00 00 2F 9E 00 0D 3B 00 FF FF 40 9E FF 80 80 1F 00 24 7F 84 E3 78 80 7F 00 0C 38 A0 00 02 38 DF 00 14 7C 09 03 A6 4E 80 04 21 7C 78 1B 78 4B FF FF 5C 80 1F 00 14 81 3F 00 0C 7D 29 02 14 38 00 00 00 98 09 FF FF 81 3F 00 18 93 BF 00 14 38 09 FF FF 90 1F 00 18 80 1F 00 1C 3B 00 00 00 70 09 00 08 41 82 FE BC 80 1F 00 24 7F 84 E3 78 80 7F 00 0C 38 A0 00 05 38 DF 00 14 7C 09 03 A6 4E 80 04 21 7C 78 1B 78 4B FF FE 98 80 7F 00 0C 80 1F 00 14 7D 23 00 AE 7C 63 02 14 2F 89 00 00 40 BE FF 4C 3C 60 ?? ?? 38 63 ?? ?? 4B FF FF 40 4? ?? ?? ?? 83 C3 00 00 7C 7D 1B 78 7F 23 CB 78 4? ?? ?? ?? 93 DD 00 00 4B FF FF 3C 3A C0 00 00 4B FF FB 68 80 1F 00 24 7F 84 E3 78 80 7F 00 0C 38 A0 00 01 38 DF 00 14 7C 09 03 A6 4E 80 04 21 7C 78 1B 79 40 82 00 24 80 1F 00 1C 4B FF FC E8 81 21 00 08 80 69 00 00 4? ?? ?? ?? 2F 83 00 00 40 9C FC DC 3B 00 FF FF 4? ?? ?? ?? 83 A3 00 00 7C 7E 1B 78 80 61 00 08 4? ?? ?? ?? 93 BE 00 00 81 3F 00 04 2F 89 00 00 38 09 FF FF 90 1F 00 04 40 9E 00 10 81 3F 00 08 38 09 FF FF 90 1F 00 04 81 3F 00 00 54 00 10 3A 39 60 00 00 7D 69 01 2E 4B FF FE 2C 91 7F 00 04 4B FF FC 70 83 41 00 10 7F 59 D3 78 88 1A 00 00 3B 00 00 00 2F 80 00 00 40 BE 00 18 48 00 00 48 88 1A 00 01 3B 3A 00 01 2F 80 00 00 41 9E 00 34 38 80 00 00 7F 23 CB 78 4? ?? ?? ?? 7F 64 DB 78 7C 7A 1B 78 7F 25 CB 78 7F E3 FB 78 7C D9 D0 50 38 E0 00 00 4B FF F6 B1 7C 78 1B 79 41 82 FF C4 83 41 00 10 4? ?? ?? ?? 83 23 00 00 7C 7B 1B 78 7F 43 D3 78 4? ?? ?? ?? 93 3B 00 00 4B FF FC FC 4? ?? ?? ?? 83 A3 00 00 7C 7E 1B 78 7F 23 CB 78 4? ?? ?? ?? 93 BE 00 00 4B FF FD FC 3B 00 00 00 4B FF FC 70 3C 60 ?? ?? 38 63 ?? ?? 4? ?? ?? ?? 2F 83 00 00 40 9C FD 70 3B 00 FF FF 4B FF FD 68 38 00 00 06 7F 63 DB 78 44 00 00 02 7C 00 00 26 80 61 00 08 4B FF FD B8 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 02 1B 38 C6 ?? ?? 4? ?? ?? ?? 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 02 2D 38 C6 ?? ?? 4? ?? ?? ?? 2F 98 00 00 83 41 00 10 7F 59 D3 78 40 9E FF 40 4B FF FE E4 }
	condition:
		$1
}

rule file_261_4_0 {
	meta:
		name = "ftw_startup"
		size = 1332
		refs = "0058 __errno_location 00ec memset 00f4 strlen 010c malloc 012c stpcpy 0214 __lxstat 02b8 __open 0314 __chdir 0340 __fchdir 035e free 0364 __tdestroy 0390 __xstat 045c __getcwd"
	strings:
		$1 = { 94 21 FF 40 7C 08 02 A6 7D 80 00 26 93 41 00 A8 7C FA 3B 78 93 61 00 AC 7C 9B 23 78 93 81 00 B0 7C BC 2B 78 93 A1 00 B4 7C 7D 1B 78 93 E1 00 BC 7C 3F 0B 78 90 01 00 C4 92 E1 00 9C 93 01 00 A0 93 21 00 A4 93 C1 00 B8 91 81 00 98 88 03 00 00 2F 80 00 00 40 9E 00 58 4? ?? ?? ?? 38 00 00 02 90 03 00 00 3B C0 FF FF 39 7F 00 C0 80 0B 00 04 7F C3 F3 78 81 8B FF D8 7C 08 03 A6 82 EB FF DC 83 0B FF E0 7D 81 81 20 83 2B FF E4 83 4B FF E8 83 6B FF EC 83 8B FF F0 83 AB FF F4 83 CB FF F8 83 EB FF FC 7D 61 5B 78 4E 80 00 20 2F 86 00 00 40 9D 02 C8 54 C5 10 3A 81 21 00 00 38 05 00 1E 90 DF 00 10 54 00 00 36 7C 00 00 D0 7D 21 01 6E 38 80 00 00 39 20 00 00 38 01 00 17 91 3F 00 0C 54 00 00 36 7C 03 03 78 90 1F 00 08 4? ?? ?? ?? 7F A3 EB 78 4? ?? ?? ?? 54 60 08 3C 2B 80 10 00 41 9C 01 90 7C 03 03 78 90 1F 00 18 4? ?? ?? ?? 3B C0 FF FF 2F 83 00 00 90 7F 00 14 7C 79 1B 78 7C 78 1B 78 41 BE FF 44 7F A4 EB 78 4? ?? ?? ?? 38 19 00 01 7F 80 18 40 7C 19 18 50 7C 09 03 A6 41 9D 03 DC 2F 99 FF FE 40 BE 00 14 48 00 03 D0 8C 03 FF FF 2F 80 00 2F 40 9E 00 0C 7C 6B 1B 78 42 00 FF F0 7F 99 58 40 38 00 00 00 7D 59 58 50 98 0B 00 00 39 4A 00 01 38 00 00 00 7D 49 03 A6 7D 69 5B 78 90 1F 00 20 41 9D 03 A0 2F 99 FF FF 40 BE 00 14 48 00 03 94 8C 09 FF FF 2F 80 00 2F 41 9E 00 0C 7D 2B 4B 78 42 00 FF F0 2F 9B 00 00 93 5F 00 24 7F 39 58 50 93 3F 00 1C 93 9F 00 2C 40 9E 00 D8 3D 20 ?? ?? 39 29 ?? ?? 38 09 00 1C 73 49 00 04 90 1F 00 28 38 00 00 00 90 1F 00 38 40 82 00 C4 3B 60 FF FF 4? ?? ?? ?? 2E 1B FF FF 7C 7D 1B 78 3B 20 00 00 57 40 07 FE 2D 80 00 00 41 8E 01 80 3A FF 00 40 38 60 00 03 7F 04 C3 78 7E E5 BB 78 4? ?? ?? ?? 54 63 0F FE 2F 83 00 00 41 9E 01 7C 40 8E 02 04 83 9D 00 00 3B C0 FF FF 2F 9C 00 02 40 BE 01 B8 38 60 00 03 7F 04 C3 78 7E E5 BB 78 4? ?? ?? ?? 2F 83 00 00 40 9E 01 9C 81 3F 00 50 55 29 04 26 6D 20 FF FF 2F 80 A0 00 40 9E 01 88 81 3F 00 28 7E E4 BB 78 80 1F 00 2C 38 DF 00 1C 80 7F 00 14 80 A9 00 18 7C 09 03 A6 4E 80 04 21 83 9D 00 00 7C 7E 1B 78 48 00 01 60 38 00 10 00 4B FF FE 70 3D 20 ?? ?? 38 09 ?? ?? 4B FF FF 30 3E E0 ?? ?? 3A F7 ?? ?? 7E E3 BB 78 38 80 40 00 4C C6 31 82 4? ?? ?? ?? 2E 03 FF FF 7C 7B 1B 78 41 92 01 78 81 3F 00 10 2B 89 00 01 40 9D 00 0C 39 29 FF FF 91 3F 00 10 4? ?? ?? ?? 3B 20 00 00 7C 7D 1B 78 81 3F 00 1C 2F 89 00 00 40 9D 01 CC 2F 89 00 01 41 9E 01 F0 81 7F 00 14 39 29 FF FF 38 00 00 00 7F 8B 48 AE 7C 0B 49 AE 80 7F 00 14 4? ?? ?? ?? 80 1F 00 1C 81 3F 00 14 7C 7E 1B 78 7D 29 02 14 9B 89 FF FF 2F 9E 00 00 41 9E 01 8C 83 9D 00 00 41 92 00 D0 7F 63 DB 78 4? ?? ?? ?? 38 00 00 06 7F 63 DB 78 44 00 00 02 7C 00 00 26 93 9D 00 00 80 7F 00 38 3C 80 ?? ?? 38 84 ?? ?? 4? ?? ?? ?? 80 7F 00 14 4? ?? ?? ?? 93 9D 00 00 4B FF FC F4 38 C0 00 01 4B FF FD 38 3A FF 00 40 38 60 00 03 7F 04 C3 78 7E E5 BB 78 4? ?? ?? ?? 54 63 0F FE 4B FF FE 84 80 1F 00 50 54 00 04 26 2F 80 40 00 41 9E 00 C8 68 00 A0 00 81 3F 00 28 7C 00 00 34 80 7F 00 14 54 00 D9 7E 54 00 20 36 7C A9 00 2E 7E E4 BB 78 80 1F 00 2C 38 DF 00 1C 7C 09 03 A6 4E 80 04 21 7C 7E 1B 78 4? ?? ?? ?? 7C 7D 1B 78 83 9D 00 00 73 40 00 10 41 A2 FF 48 38 1E FF FE 20 00 00 01 7C 00 01 10 7F DE 00 38 40 B2 FF 38 2F 99 00 00 41 9E 00 A0 7F 23 CB 78 4? ?? ?? ?? 7F 23 CB 78 4? ?? ?? ?? 93 9D 00 00 4B FF FF 34 4? ?? ?? ?? 3B C0 FF FF 7C 7D 1B 78 83 83 00 00 4B FF FF B4 4? ?? ?? ?? 3B C0 00 00 83 83 00 00 7C 7D 1B 78 2F 9C 00 0D 40 9E FF 08 38 60 00 00 38 80 00 00 4? ?? ?? ?? 7C 79 1B 79 40 82 FE 84 83 9D 00 00 4B FF FE EC 81 3F 00 40 81 5F 00 44 91 3F 00 30 91 5F 00 34 41 8E 00 7C 3B BF 00 08 7E E4 BB 78 38 A0 00 00 7F A3 EB 78 4B FF F4 AD 7C 7E 1B 78 4? ?? ?? ?? 7C 7D 1B 78 83 83 00 00 4B FF FF 44 4? ?? ?? ?? 7C 7D 1B 78 83 9D 00 00 4B FF FE A0 80 1F 00 24 83 1F 00 14 54 00 07 7A 2F 80 00 00 41 BE FD 2C 80 1F 00 1C 7C 18 00 EE 2F 80 00 00 40 BE FD 1C 7E F8 BB 78 4B FF FD 14 3C 60 ?? ?? 38 63 ?? ?? 4? ?? ?? ?? 7C 7E 1B 78 4B FF FE 34 3B BF 00 08 7F A3 EB 78 7E E4 BB 78 38 BF 00 4C 4B FF F0 45 7C 7E 1B 79 40 82 FE CC 4B FF FF 70 39 20 00 01 7D 29 03 A6 4B FF FC 38 38 00 00 01 7C 09 03 A6 4B FF FC 74 }
	condition:
		$1
}

rule file_261_5_0 {
	meta:
		name = "ftw"
		size = 24
		altNames = "ftw64"
	strings:
		$1 = { 7C 80 23 78 7C A6 2B 78 38 80 00 00 7C 05 03 78 38 E0 00 00 4B FF FA B8 }
	condition:
		$1
}

rule file_261_6_0 {
	meta:
		name = "__new_nftw"
		size = 88
		refs = "0038 __errno_location"
		altNames = "__new_nftw64"
	strings:
		$1 = { 7C 08 02 A6 94 21 FF F0 7C C7 33 78 90 01 00 14 54 C0 00 35 7C 80 23 78 7C A6 2B 78 40 82 00 1C 7C 05 03 78 80 01 00 14 38 80 00 01 7C 08 03 A6 38 21 00 10 4B FF FA 80 4? ?? ?? ?? 38 00 00 16 90 03 00 00 38 60 FF FF 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_262_0_0 {
	meta:
		name = "pmap_getmaps"
		size = 288
		refs = "0030 __get_socket 0058 clnttcp_create 0072 xdr_void 0076 xdr_pmaplist 00c8 __close 00fa _libc_intl_domainname 010c __dcgettext 0118 clnt_perror"
	strings:
		$1 = { 94 21 FF D0 7C 08 02 A6 90 01 00 34 38 00 00 6F 93 81 00 20 3B 80 00 00 93 A1 00 24 93 C1 00 28 93 E1 00 2C 7C 7F 1B 78 B0 03 00 02 93 81 00 08 4? ?? ?? ?? 7C 26 0B 78 94 66 00 0C 3C 80 00 01 7C 7D 1B 78 60 84 86 A0 7F E3 FB 78 38 A0 00 02 38 E0 00 32 39 00 01 F4 4? ?? ?? ?? 7C 7E 1B 79 41 82 00 5C 81 3E 00 04 38 00 00 3C 90 01 00 18 3C A0 ?? ?? 3C E0 ?? ?? 80 09 00 00 38 80 00 04 93 81 00 1C 38 A5 ?? ?? 38 C0 00 00 7C 09 03 A6 38 E7 ?? ?? 39 01 00 08 39 21 00 18 4E 80 04 21 2F 83 00 00 40 9E 00 54 81 3E 00 04 7F C3 F3 78 80 09 00 10 7C 09 03 A6 4E 80 04 21 2F 9D FF FF 41 BE 00 0C 80 61 00 0C 4? ?? ?? ?? 38 00 00 00 80 61 00 08 B0 1F 00 02 80 01 00 34 83 81 00 20 7C 08 03 A6 83 A1 00 24 83 C1 00 28 83 E1 00 2C 38 21 00 30 4E 80 00 20 3C 60 ?? ?? 3C 80 ?? ?? 38 84 ?? ?? 38 A0 00 05 38 63 ?? ?? 4? ?? ?? ?? 7C 64 1B 78 7F C3 F3 78 4? ?? ?? ?? 4B FF FF 8C }
	condition:
		$1
}

rule file_263_0_0 {
	meta:
		name = "fputws_unlocked"
		size = 140
		refs = "0020 __wcslen 0030 _IO_fwide"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 93 A1 00 14 7C 7D 1B 78 90 01 00 24 93 C1 00 18 7C 9E 23 78 93 E1 00 1C 4? ?? ?? ?? 7C 7F 1B 78 38 80 00 01 7F C3 F3 78 4? ?? ?? ?? 2F 83 00 01 38 60 FF FF 41 9E 00 20 80 01 00 24 83 A1 00 14 7C 08 03 A6 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 81 3E 00 98 7F C3 F3 78 7F A4 EB 78 80 09 00 1C 7F E5 FB 78 7C 09 03 A6 4E 80 04 21 7F 83 F8 00 38 60 00 01 41 BE FF C0 38 60 FF FF 4B FF FF B8 }
	condition:
		$1
}

rule file_264_1_0 {
	meta:
		name = "updwtmp_file"
		size = 528
		refs = "003c __open_nocancel 004c alarm 0070 memset 0088 __sigaction 00c0 __fcntl_nocancel 00dc __lseek64 00f0 __moddi3 0110 __write_nocancel 012c __ftruncate64"
	strings:
		$1 = { 94 21 FE A0 7C 08 02 A6 93 21 01 44 7C 99 23 78 3C 80 00 01 60 84 00 01 93 C1 01 58 93 E1 01 5C 3B E0 FF FF 90 01 01 64 93 41 01 48 93 61 01 4C 93 81 01 50 93 A1 01 54 4C C6 31 82 4? ?? ?? ?? 7C 7E 1B 79 41 80 01 3C 38 60 00 00 4? ?? ?? ?? 3D 20 ?? ?? 38 09 ?? ?? 7C 3B 0B 78 94 1B 00 18 38 80 00 00 38 A0 00 80 7C 7A 1B 78 38 61 00 1C 4? ?? ?? ?? 3B 80 00 00 7F 64 DB 78 93 81 00 9C 38 A1 00 A4 38 60 00 0E 4? ?? ?? ?? 38 60 00 0A 4? ?? ?? ?? 7C 3B 0B 78 38 00 00 01 93 81 00 08 7F C3 F3 78 B4 1B 00 08 38 80 00 07 7F 65 DB 78 93 81 00 0C 93 81 00 10 93 81 00 14 4C C6 31 82 4? ?? ?? ?? 2F 83 00 00 41 9C 00 88 38 A0 00 00 38 C0 00 00 38 E0 00 02 7F C3 F3 78 4? ?? ?? ?? 38 A0 00 00 38 C0 01 80 7C 9D 23 78 7C 7C 1B 78 4? ?? ?? ?? 7C 69 1B 78 7D 20 23 79 7C 8A 23 78 40 82 00 BC 7F C3 F3 78 7F 24 CB 78 38 A0 01 80 4? ?? ?? ?? 3B E0 00 00 2F 83 01 80 41 9E 00 18 7F C3 F3 78 7F 85 E3 78 7F A6 EB 78 4? ?? ?? ?? 3B E0 FF FF 38 00 00 02 7F C3 F3 78 B0 01 00 08 38 80 00 07 7F 65 DB 78 4C C6 31 82 4? ?? ?? ?? 38 60 00 00 4? ?? ?? ?? 38 60 00 0E 38 81 00 A4 38 A0 00 00 4? ?? ?? ?? 2F 9A 00 00 40 9E 00 44 38 00 00 06 7F C3 F3 78 44 00 00 02 7C 00 00 26 80 01 01 64 7F E3 FB 78 83 21 01 44 7C 08 03 A6 83 41 01 48 83 61 01 4C 83 81 01 50 83 A1 01 54 83 C1 01 58 83 E1 01 5C 38 21 01 60 4E 80 00 20 7F 43 D3 78 4? ?? ?? ?? 4B FF FF B8 7F AA E8 10 7F 89 E1 10 7F 85 E3 78 7F A6 EB 78 7F C3 F3 78 4? ?? ?? ?? 7F C3 F3 78 38 A0 00 00 38 C0 00 00 38 E0 00 02 4? ?? ?? ?? 2F 83 00 00 41 BC FF 48 7F C3 F3 78 7F 24 CB 78 38 A0 01 80 4? ?? ?? ?? 3B E0 00 00 2F 83 01 80 40 BE FF 18 4B FF FF 28 }
	condition:
		$1
}

rule file_264_2_0 {
	meta:
		name = "endutent_file"
		size = 104
		refs = "0064 __assert_fail"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 93 E1 00 0C 3F E0 ?? ?? 80 7F ?? ?? 90 01 00 14 2F 83 00 00 41 9C 00 2C 38 00 00 06 44 00 00 02 7C 00 00 26 38 00 FF FF 90 1F ?? ?? 80 01 00 14 83 E1 00 0C 38 21 00 10 7C 08 03 A6 4E 80 00 20 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 02 11 38 C6 ?? ?? 4? ?? ?? ?? }
	condition:
		$1
}

rule file_264_3_0 {
	meta:
		name = "setutent_file"
		size = 600
		refs = "0048 __lseek64 009a __libc_utmp_file_name 00b0 strcmp 0128 __open_nocancel 0142 __have_o_cloexec 015c __fcntl_nocancel 01a8 __access"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 93 C1 00 18 3F C0 ?? ?? 90 01 00 24 80 1E ?? ?? 93 E1 00 1C 3F E0 ?? ?? 2F 80 00 00 93 41 00 08 93 61 00 0C 93 81 00 10 93 A1 00 14 41 9C 00 64 7C 03 03 78 38 A0 00 00 38 C0 00 00 38 E0 00 00 4? ?? ?? ?? 3B FF ?? ?? 39 40 00 00 38 00 FF FF 91 5F 00 0C 39 20 00 00 B0 1F 00 10 91 3F 00 08 39 20 00 01 80 01 00 24 7D 23 4B 78 83 41 00 08 7C 08 03 A6 83 61 00 0C 83 81 00 10 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 3F E0 ?? ?? 83 BF ?? ?? 3F 80 ?? ?? 3B 9C ?? ?? 7F A3 EB 78 7F 84 E3 78 4? ?? ?? ?? 2F 83 00 00 41 9E 00 E0 3F 60 ?? ?? 3B 7B ?? ?? 7F A3 EB 78 7F 64 DB 78 4? ?? ?? ?? 2F 83 00 00 41 9E 00 E8 3F 40 ?? ?? 3B 5A ?? ?? 7F A3 EB 78 7F 44 D3 78 4? ?? ?? ?? 2F 83 00 00 41 9E 00 F0 3F 80 ?? ?? 3B 9C ?? ?? 7F A3 EB 78 7F 84 E3 78 4? ?? ?? ?? 2F 83 00 00 41 9E 00 F4 38 00 00 00 3F E0 ?? ?? 7F A3 EB 78 98 1F ?? ?? 3C 80 00 09 4C C6 31 82 4? ?? ?? ?? 39 20 00 00 2F 83 FF FF 90 7E ?? ?? 7C 60 1B 78 41 BE FF 30 3F A0 ?? ?? 81 3D ?? ?? 2F 89 00 00 41 9D FE EC 38 A0 00 00 38 80 00 01 4C C6 31 82 4? ?? ?? ?? 7C 65 1B 79 41 80 00 D4 80 1D ?? ?? 2F 80 00 00 40 9E 00 1C 54 A0 07 FE 30 00 FF FF 7C 00 01 10 60 00 00 01 2F 80 00 00 90 1D ?? ?? 41 9C 00 94 80 1E ?? ?? 4B FF FE A4 3F A0 ?? ?? 3B BD ?? ?? 7F A3 EB 78 38 80 00 00 4? ?? ?? ?? 2F 83 00 00 41 BE FF 60 83 BF ?? ?? 4B FF FF 04 3F A0 ?? ?? 3B BD ?? ?? 7F A3 EB 78 38 80 00 00 4? ?? ?? ?? 2F 83 00 00 41 BE FF 3C 83 BF ?? ?? 4B FF FE FC 7F 43 D3 78 38 80 00 00 4? ?? ?? ?? 7F 9D E3 78 2F 83 00 00 40 BE FF 1C 83 BF ?? ?? 4B FF FE F8 7F 83 E3 78 38 80 00 00 4? ?? ?? ?? 7F 7D DB 78 2F 83 00 00 40 BE FE FC 83 BF ?? ?? 4B FF FE F4 80 7E ?? ?? 60 A5 00 01 38 80 00 02 4C C6 31 82 4? ?? ?? ?? 7C 65 1B 78 2F 85 FF FF 40 BE FF 54 38 00 00 06 80 7E ?? ?? 44 00 00 02 7C 00 00 26 39 20 00 00 4B FF FE 18 }
	condition:
		$1
}

rule file_264_4_0 {
	meta:
		name = "__utmp_equal"
		size = 164
		refs = "0060 strncmp"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 7C 69 1B 78 90 01 00 14 A1 63 00 00 38 60 00 00 39 6B FF FB 55 6B 04 3E 2B 8B 00 03 41 9D 00 48 A1 64 00 00 38 0B FF FB 54 00 04 3E 2B 80 00 03 41 9D 00 34 88 09 00 28 2F 80 00 00 41 9E 00 38 88 04 00 28 2F 80 00 00 41 9E 00 2C 38 69 00 28 38 84 00 28 38 A0 00 04 4? ?? ?? ?? 7C 63 00 34 54 63 D9 7E 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 38 69 00 08 38 84 00 08 38 A0 00 20 4? ?? ?? ?? 80 01 00 14 7C 63 00 34 7C 08 03 A6 54 63 D9 7E 38 21 00 10 4E 80 00 20 }
	condition:
		$1
}

rule file_264_5_0 {
	meta:
		name = "internal_getut_r"
		size = 580
		refs = "0044 alarm 0064 memset 0078 __sigaction 00a4 __fcntl_nocancel 00f0 __read_nocancel 0206 _GLOBAL_OFFSET_TABLE_ 020e __libc_errno"
	strings:
		$1 = { 94 21 FE A0 7C 08 02 A6 93 A1 01 54 7C 7D 1B 78 38 60 00 00 90 01 01 64 93 21 01 44 7C B9 2B 78 93 41 01 48 93 61 01 4C 3F 60 ?? ?? 93 81 01 50 7C 3C 0B 78 93 C1 01 58 3B C0 00 00 93 E1 01 5C 7C 9F 23 78 4? ?? ?? ?? 3D 20 ?? ?? 38 09 ?? ?? 94 1C 00 18 38 80 00 00 38 A0 00 80 7C 7A 1B 78 38 61 00 1C 4? ?? ?? ?? 7F 84 E3 78 38 A1 00 A4 93 C1 00 9C 38 60 00 0E 4? ?? ?? ?? 38 60 00 0A 4? ?? ?? ?? 80 7B ?? ?? 38 80 00 07 93 C1 00 08 38 A1 00 08 93 C1 00 0C 93 C1 00 10 93 C1 00 14 4C C6 31 82 4? ?? ?? ?? 2F 83 00 00 41 9C 01 88 A1 3D 00 00 38 09 FF FF 54 00 04 3E 2B 80 00 01 7D 29 07 34 40 9D 00 DC 2F 89 00 04 41 9E 00 D4 2F 89 00 03 41 9E 00 CC 3F C0 ?? ?? 3B 9B ?? ?? 3B DE ?? ?? 80 7C 00 00 7F E4 FB 78 38 A0 01 80 4? ?? ?? ?? 7F A4 EB 78 2F 83 01 80 7F E3 FB 78 40 9E 01 04 81 3E 00 08 81 5E 00 0C 31 4A 01 80 7D 29 01 94 91 3E 00 08 91 5E 00 0C 4B FF FE 41 2F 83 00 00 41 9E FF C0 3B E0 00 00 80 7B ?? ?? 38 00 00 02 38 80 00 07 B0 01 00 08 38 A1 00 08 4C C6 31 82 4? ?? ?? ?? 38 60 00 00 4? ?? ?? ?? 38 60 00 0E 38 81 00 A4 38 A0 00 00 4? ?? ?? ?? 2F 9A 00 00 41 BE 00 0C 7F 43 D3 78 4? ?? ?? ?? 80 01 01 64 7F E3 FB 78 83 21 01 44 7C 08 03 A6 83 41 01 48 83 61 01 4C 83 81 01 50 83 A1 01 54 83 C1 01 58 83 E1 01 5C 38 21 01 60 4E 80 00 20 3B 9B ?? ?? 80 7C 00 00 7F E4 FB 78 38 A0 01 80 4? ?? ?? ?? 3F C0 ?? ?? 2F 83 01 80 3B DE ?? ?? 40 9E 00 44 A9 7D 00 00 A8 1F 00 00 81 3E 00 08 7F 8B 00 00 81 5E 00 0C 31 4A 01 80 7D 29 01 94 91 3E 00 08 91 5E 00 0C 41 BE FF 40 80 7C 00 00 7F E4 FB 78 38 A0 01 80 4? ?? ?? ?? 2F 83 01 80 41 9E FF C4 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 38 00 00 03 90 09 00 00 39 40 FF FF 39 20 FF FF 3B E0 FF FF 91 3E 00 08 91 5E 00 0C 4B FF FE FC 38 00 00 01 98 19 00 00 3B E0 FF FF 4B FF FF 08 }
	condition:
		$1
}

rule file_264_6_0 {
	meta:
		name = "pututline_file"
		size = 1400
		refs = "0098 alarm 00bc memset 00d4 __sigaction 010c __fcntl_nocancel 0148 __lseek64 0158 __write_nocancel 0226 _GLOBAL_OFFSET_TABLE_ 022e __libc_errno 02b8 __moddi3 02e8 __ftruncate64 030e __libc_utmp_file_name 0324 strcmp 0394 __open_nocancel 03aa __have_o_cloexec 03f0 __dup2 043c __access 0574 __assert_fail"
	strings:
		$1 = { 94 21 FD 20 7C 08 02 A6 7D 80 00 26 93 E1 02 DC 3F E0 ?? ?? 90 01 02 E4 80 1F ?? ?? 93 C1 02 D8 7C 7E 1B 78 2F 80 00 00 93 01 02 C0 93 21 02 C4 93 41 02 C8 93 61 02 CC 93 81 02 D0 93 A1 02 D4 91 81 02 BC 41 9C 05 14 3F A0 ?? ?? 88 1D ?? ?? 2F 80 00 00 41 9E 02 B8 3B BD ?? ?? 80 1D 00 08 2F 80 00 00 40 9D 01 88 A1 3E 00 00 A9 7D 00 10 7D 20 07 34 7F 80 58 00 41 9E 01 CC 38 7D 00 10 7F C4 F3 78 4B FF FC 95 3B 00 00 01 2F 83 00 00 41 9E 01 6C 38 60 00 00 4? ?? ?? ?? 3D 20 ?? ?? 38 09 ?? ?? 7C 3A 0B 78 94 1A 00 1C 38 80 00 00 38 A0 00 80 7C 7C 1B 78 38 61 00 20 4? ?? ?? ?? 3B 60 00 00 7F 44 D3 78 93 61 00 A0 38 A1 00 A8 38 60 00 0E 4? ?? ?? ?? 38 60 00 0A 4? ?? ?? ?? 80 7F ?? ?? 38 00 00 01 93 61 00 0C 38 80 00 07 38 A1 00 0C 93 61 00 10 3F 40 ?? ?? 93 61 00 14 93 61 00 18 B0 01 00 0C 4C C6 31 82 4? ?? ?? ?? 2F 83 00 00 41 9C 00 74 2E 18 00 00 41 90 01 70 81 3D 00 08 38 E0 00 00 81 5D 00 0C 80 7A ?? ?? 31 4A FE 80 7D 29 01 D4 91 3D 00 08 7D 25 4B 78 7D 46 53 78 91 5D 00 0C 4? ?? ?? ?? 80 7F ?? ?? 7F C4 F3 78 38 A0 01 80 4? ?? ?? ?? 2F 83 01 80 41 9E 01 0C 41 90 02 B4 3B 60 00 00 80 7F ?? ?? 38 00 00 02 38 80 00 07 B0 01 00 0C 38 A1 00 0C 4C C6 31 82 4? ?? ?? ?? 38 60 00 00 4? ?? ?? ?? 38 60 00 0E 38 81 00 A8 38 A0 00 00 4? ?? ?? ?? 2F 9C 00 00 41 BE 00 0C 7F 83 E3 78 4? ?? ?? ?? 80 01 02 E4 7F 63 DB 78 81 81 02 BC 7C 08 03 A6 83 01 02 C0 83 21 02 C4 7D 80 81 20 83 41 02 C8 83 61 02 CC 83 81 02 D0 83 A1 02 D4 83 C1 02 D8 83 E1 02 DC 38 21 02 E0 4E 80 00 20 40 9E 00 10 80 1D 00 0C 2F 80 00 00 40 9E FE 70 38 00 00 00 7F C3 F3 78 98 01 00 08 38 81 01 34 38 A1 00 08 4B FF FB AD 88 01 00 08 7C 78 1B 78 2F 80 00 00 41 9E FE 74 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 38 00 00 0B 90 09 00 00 3B 60 00 00 4B FF FF 70 39 29 FF FF 55 29 04 3E 2B 89 00 01 40 9D 00 14 2F 80 00 04 41 9E 00 0C 2F 80 00 03 40 9E FE 1C 3B 00 00 01 4B FF FE 2C 81 3D 00 08 7F DB F3 78 81 5D 00 0C 31 4A 01 80 7D 29 01 94 91 3D 00 08 91 5D 00 0C 4B FF FE E4 80 7A ?? ?? 38 A0 00 00 38 C0 00 00 38 E0 00 02 4? ?? ?? ?? 38 A0 00 00 7C 78 1B 78 90 9D 00 0C 38 C0 01 80 7C 99 23 78 93 1D 00 08 4? ?? ?? ?? 7C 69 1B 78 7D 20 23 79 7C 8A 23 78 41 82 FE 84 7F 2A C8 10 7F 09 C1 10 80 7A ?? ?? 93 1D 00 08 7F 05 C3 78 7F 26 CB 78 93 3D 00 0C 4? ?? ?? ?? 38 A0 00 00 80 7A ?? ?? 38 C0 00 00 38 E0 00 02 4? ?? ?? ?? 2F 83 00 00 40 9C FE 48 4B FF FE 64 3F 60 ?? ?? 83 9B ?? ?? 3F 40 ?? ?? 3B 5A ?? ?? 7F 83 E3 78 7F 44 D3 78 4? ?? ?? ?? 2F 83 00 00 41 9E 01 28 3F 00 ?? ?? 3B 18 ?? ?? 7F 83 E3 78 7F 04 C3 78 4? ?? ?? ?? 2F 83 00 00 41 9E 01 30 3F 20 ?? ?? 3B 39 ?? ?? 7F 83 E3 78 7F 24 CB 78 4? ?? ?? ?? 2F 83 00 00 41 9E 01 B4 3F 40 ?? ?? 3B 5A ?? ?? 7F 83 E3 78 7F 44 D3 78 4? ?? ?? ?? 2F 83 00 00 41 9E 00 B4 3C 80 00 09 7F 83 E3 78 60 84 00 02 4C C6 31 82 4? ?? ?? ?? 3B 60 00 00 2F 83 FF FF 7C 7C 1B 78 41 BE FE 0C 3F 60 ?? ?? 80 1B ?? ?? 2F 80 00 00 40 9D 00 E8 80 7F ?? ?? 38 E0 00 01 38 A0 00 00 38 C0 00 00 4? ?? ?? ?? 38 E0 00 00 7C 65 1B 78 7C 86 23 78 7F 83 E3 78 4? ?? ?? ?? 2F 83 FF FF 41 9E 01 54 80 9F ?? ?? 7F 83 E3 78 4? ?? ?? ?? 2F 83 00 00 41 9C 01 48 38 00 00 06 7F 83 E3 78 44 00 00 02 7C 00 00 26 38 00 00 01 98 1D ?? ?? 4B FF FC 44 3D 20 ?? ?? 80 BD 00 08 80 69 ?? ?? 3B 60 00 00 80 DD 00 0C 4? ?? ?? ?? 4B FF FD 3C 7F 43 D3 78 38 80 00 00 4? ?? ?? ?? 7F 1C C3 78 2F 83 00 00 40 BE FF 3C 83 9B ?? ?? 4B FF FF 34 3F 80 ?? ?? 3B 9C ?? ?? 7F 83 E3 78 38 80 00 00 4? ?? ?? ?? 2F 83 00 00 41 BE FF 18 83 9B ?? ?? 4B FF FE BC 3F 80 ?? ?? 3B 9C ?? ?? 7F 83 E3 78 38 80 00 00 4? ?? ?? ?? 2F 83 00 00 41 BE FE F4 83 9B ?? ?? 4B FF FE B4 80 7F ?? ?? 38 A0 00 00 38 80 00 01 4C C6 31 82 4? ?? ?? ?? 7C 65 1B 79 41 80 00 44 80 1B ?? ?? 2F 80 00 00 40 9E 00 1C 54 A0 07 FE 30 00 FF FF 7C 00 01 10 60 00 00 01 2F 80 00 00 90 1B ?? ?? 40 9C FE DC 80 7F ?? ?? 60 A5 00 01 38 80 00 02 4C C6 31 82 4? ?? ?? ?? 7C 65 1B 78 2F 85 FF FF 40 9E FE BC 38 00 00 06 80 7F ?? ?? 44 00 00 02 7C 00 00 26 3B 60 00 00 4B FF FC 9C 7F 23 CB 78 38 80 00 00 4? ?? ?? ?? 7F 5C D3 78 2F 83 00 00 40 BE FE 58 83 9B ?? ?? 4B FF FE 34 2F 84 FF FF 40 9E FE AC 38 00 00 06 7F 83 E3 78 44 00 00 02 7C 00 00 26 3B 60 00 00 4B FF FC 5C 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 01 91 38 C6 ?? ?? 4? ?? ?? ?? }
	condition:
		$1
}

rule file_264_7_0 {
	meta:
		name = "getutid_r_file"
		size = 212
		refs = "0070 memcpy 00d0 __assert_fail"
	strings:
		$1 = { 94 21 FF D0 7C 08 02 A6 3D 20 ?? ?? 90 01 00 34 80 09 ?? ?? 93 A1 00 24 7C BD 2B 78 2F 80 00 00 93 E1 00 2C 7C 9F 23 78 93 C1 00 28 41 9C 00 88 3F C0 ?? ?? 3B DE ?? ?? 80 1E 00 08 2F 80 FF FF 41 9E 00 58 7C 25 0B 78 38 00 00 00 9C 05 00 08 3B DE 00 10 7F C4 F3 78 4B FF F7 ED 2F 83 00 00 41 9C 00 44 7F E3 FB 78 7F C4 F3 78 38 A0 01 80 4? ?? ?? ?? 93 FD 00 00 38 60 00 00 80 01 00 34 83 A1 00 24 7C 08 03 A6 83 C1 00 28 83 E1 00 2C 38 21 00 30 4E 80 00 20 80 1E 00 0C 2F 80 FF FF 40 9E FF A4 38 00 00 00 90 1D 00 00 38 60 FF FF 4B FF FF CC 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 01 3C 38 C6 ?? ?? 4? ?? ?? ?? }
	condition:
		$1
}

rule file_264_8_0 {
	meta:
		name = "getutline_r_file"
		size = 680
		refs = "0064 alarm 0088 memset 00a0 __sigaction 00cc __fcntl_nocancel 00fc __read_nocancel 0140 strncmp 0158 memcpy 0166 _GLOBAL_OFFSET_TABLE_ 016e __libc_errno 02a4 __assert_fail"
	strings:
		$1 = { 94 21 FE A0 7C 08 02 A6 93 41 01 48 3F 40 ?? ?? 90 01 01 64 80 1A ?? ?? 92 E1 01 3C 7C 97 23 78 2F 80 00 00 93 21 01 44 7C B9 2B 78 93 61 01 4C 7C 7B 1B 78 93 01 01 40 93 81 01 50 93 A1 01 54 93 C1 01 58 93 E1 01 5C 41 9C 02 40 3F E0 ?? ?? 3B FF ?? ?? 80 1F 00 08 2F 80 FF FF 41 9E 02 10 38 60 00 00 4? ?? ?? ?? 3D 20 ?? ?? 38 09 ?? ?? 7C 3D 0B 78 94 1D 00 18 38 80 00 00 38 A0 00 80 7C 78 1B 78 38 61 00 1C 4? ?? ?? ?? 3B C0 00 00 7F A4 EB 78 93 C1 00 9C 38 A1 00 A4 38 60 00 0E 4? ?? ?? ?? 38 60 00 0A 4? ?? ?? ?? 80 7A ?? ?? 38 80 00 07 93 C1 00 08 38 A1 00 08 93 C1 00 0C 93 C1 00 10 93 C1 00 14 4C C6 31 82 4? ?? ?? ?? 2F 83 00 00 41 9C 01 90 3F A0 ?? ?? 3F C0 ?? ?? 3B BD ?? ?? 3B DE ?? ?? 3B 7B 00 08 3B 9F 00 18 80 7D 00 00 7F C4 F3 78 38 A0 01 80 4? ?? ?? ?? 2F 83 01 80 40 9E 00 60 A1 7F 00 10 81 3F 00 08 38 0B FF FA 81 5F 00 0C 54 00 04 3E 2B 80 00 01 31 4A 01 80 7D 29 01 94 91 3F 00 08 91 5F 00 0C 41 9D FF C0 7F 63 DB 78 7F 84 E3 78 38 A0 00 20 4? ?? ?? ?? 2F 83 00 00 40 9E FF A8 7E E3 BB 78 7F C4 F3 78 38 A0 01 80 4? ?? ?? ?? 92 F9 00 00 48 00 00 34 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 38 00 00 03 90 09 00 00 39 40 FF FF 39 20 FF FF 38 00 00 00 91 3F 00 08 91 5F 00 0C 90 19 00 00 80 7A ?? ?? 38 00 00 02 38 80 00 07 B0 01 00 08 38 A1 00 08 4C C6 31 82 4? ?? ?? ?? 38 60 00 00 4? ?? ?? ?? 38 60 00 0E 38 81 00 A4 38 A0 00 00 4? ?? ?? ?? 2F 98 00 00 40 9E 00 48 80 19 00 00 38 60 00 00 2F 80 00 00 41 9E 00 50 80 01 01 64 82 E1 01 3C 7C 08 03 A6 83 01 01 40 83 21 01 44 83 41 01 48 83 61 01 4C 83 81 01 50 83 A1 01 54 83 C1 01 58 83 E1 01 5C 38 21 01 60 4E 80 00 20 7F 03 C3 78 4? ?? ?? ?? 80 19 00 00 38 60 00 00 2F 80 00 00 40 9E FF B8 80 01 01 64 38 60 FF FF 82 E1 01 3C 7C 08 03 A6 83 01 01 40 83 21 01 44 83 41 01 48 83 61 01 4C 83 81 01 50 83 A1 01 54 83 C1 01 58 83 E1 01 5C 38 21 01 60 4E 80 00 20 93 D9 00 00 4B FF FF 48 80 1F 00 0C 2F 80 FF FF 40 9E FD EC 38 00 00 00 90 05 00 00 38 60 FF FF 4B FF FF 5C 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 01 5A 38 C6 ?? ?? 4? ?? ?? ?? }
	condition:
		$1
}

rule file_264_9_0 {
	meta:
		name = "getutent_r_file"
		size = 528
		refs = "0058 alarm 007c memset 0094 __sigaction 00c4 __fcntl_nocancel 00dc __read_nocancel 014c memcpy 020c __assert_fail"
	strings:
		$1 = { 94 21 FE A0 7C 08 02 A6 93 81 01 50 3F 80 ?? ?? 90 01 01 64 80 1C ?? ?? 93 21 01 44 7C 99 23 78 2F 80 00 00 93 61 01 4C 7C 7B 1B 78 93 41 01 48 93 A1 01 54 93 C1 01 58 93 E1 01 5C 41 9C 01 B4 3F C0 ?? ?? 3B DE ?? ?? 80 1E 00 08 2F 80 FF FF 41 9E 01 90 38 60 00 00 4? ?? ?? ?? 3D 20 ?? ?? 38 09 ?? ?? 7C 3D 0B 78 94 1D 00 18 38 80 00 00 38 A0 00 80 7C 7A 1B 78 38 61 00 1C 4? ?? ?? ?? 3B E0 00 00 7F A4 EB 78 93 E1 00 9C 38 A1 00 A4 38 60 00 0E 4? ?? ?? ?? 38 60 00 0A 4? ?? ?? ?? 80 7C ?? ?? 38 80 00 07 93 E1 00 08 38 A1 00 08 93 E1 00 0C 3F A0 ?? ?? 93 E1 00 10 93 E1 00 14 4C C6 31 82 4? ?? ?? ?? 2F 83 00 00 41 9C 00 34 80 7D ?? ?? 38 9E 00 10 38 A0 01 80 4? ?? ?? ?? 38 00 00 02 7C 7F 1B 78 80 7D ?? ?? 38 80 00 07 B0 01 00 08 38 A1 00 08 4C C6 31 82 4? ?? ?? ?? 38 60 00 00 4? ?? ?? ?? 38 60 00 0E 38 81 00 A4 38 A0 00 00 4? ?? ?? ?? 2F 9A 00 00 40 9E 00 68 2F 9F 01 80 40 9E 00 6C 81 3E 00 08 7F 63 DB 78 81 5E 00 0C 38 9E 00 10 38 A0 01 80 31 4A 01 80 7D 29 01 94 91 3E 00 08 91 5E 00 0C 4? ?? ?? ?? 38 60 00 00 80 01 01 64 93 79 00 00 7C 08 03 A6 83 21 01 44 83 41 01 48 83 61 01 4C 83 81 01 50 83 A1 01 54 83 C1 01 58 83 E1 01 5C 38 21 01 60 4E 80 00 20 7F 43 D3 78 4? ?? ?? ?? 4B FF FF 94 2F 9F 00 00 41 9E 00 14 39 20 FF FF 39 40 FF FF 91 3E 00 08 91 5E 00 0C 38 00 00 00 83 41 01 48 90 19 00 00 38 60 FF FF 80 01 01 64 83 21 01 44 7C 08 03 A6 83 61 01 4C 83 81 01 50 83 A1 01 54 83 C1 01 58 83 E1 01 5C 38 21 01 60 4E 80 00 20 80 1E 00 0C 2F 80 FF FF 40 9E FE 6C 4B FF FF BC 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 00 CD 38 C6 ?? ?? 4? ?? ?? ?? }
	condition:
		$1
}

rule file_265_0_0 {
	meta:
		name = "cfsetspeed"
		size = 252
		refs = "0056 _GLOBAL_OFFSET_TABLE_ 0066 __libc_errno 0094 cfsetispeed 00a0 cfsetospeed"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 3D 20 ?? ?? 90 01 00 24 38 00 00 20 7C 09 03 A6 39 29 ?? ?? 93 C1 00 18 39 29 00 04 93 A1 00 14 7C 7D 1B 78 93 E1 00 1C 7C 9F 23 78 83 C9 00 00 7F 9E F8 00 41 9E 00 50 80 09 FF FC 39 29 00 08 7F 80 F8 00 41 9E 00 78 42 00 FF E4 3D 20 ?? ?? 83 A1 00 14 39 29 ?? ?? 83 C1 00 18 81 29 ?? ?? 83 E1 00 1C 38 00 00 16 7D 29 12 14 90 09 00 00 38 60 FF FF 80 01 00 24 38 21 00 20 7C 08 03 A6 4E 80 00 20 7F E4 FB 78 7F A3 EB 78 4? ?? ?? ?? 7F A3 EB 78 7F E4 FB 78 4? ?? ?? ?? 80 01 00 24 38 60 00 00 83 A1 00 14 7C 08 03 A6 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 7F C4 F3 78 7F A3 EB 78 4? ?? ?? ?? 7F A3 EB 78 7F C4 F3 78 4? ?? ?? ?? 80 01 00 24 38 60 00 00 83 A1 00 14 7C 08 03 A6 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 }
	condition:
		$1
}

rule file_266_0_0 {
	meta:
		name = "strcpy"
		size = 216
	strings:
		$1 = { 7C 80 1B 78 54 00 07 BF 38 A3 FF FC 40 82 00 88 3C E0 FE FF 3D 00 7F 7F 80 C4 00 00 38 E7 FE FF 39 08 7F 7F 48 00 00 24 85 44 00 04 94 C5 00 04 7C 07 52 14 7D 09 50 F8 7C 00 48 39 40 82 00 20 84 C4 00 04 95 45 00 04 7C 07 32 14 7D 09 30 F8 7C 00 48 39 41 82 FF D4 7C CA 33 78 55 40 46 3F 98 05 00 04 4D 82 00 20 55 40 86 3F 98 05 00 05 4D 82 00 20 55 40 C6 3F 98 05 00 06 4D 82 00 20 99 45 00 07 4E 80 00 20 60 00 00 00 60 00 00 00 60 00 00 00 88 C4 00 00 38 A3 FF FF 2C 06 00 00 41 82 00 28 8D 44 00 01 9C C5 00 01 2C 0A 00 00 41 82 00 20 60 00 00 00 8C C4 00 01 9D 45 00 01 2C 06 00 00 40 82 FF E0 98 C5 00 01 4E 80 00 20 99 45 00 01 4E 80 00 20 }
	condition:
		$1
}

rule file_267_0_0 {
	meta:
		name = "_IO_fflush"
		size = 396
		refs = "0110 _IO_flush_all 011c __lll_lock_wait_private 0188 _Unwind_Resume"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 93 E1 00 0C 7C 7F 1B 79 90 01 00 14 93 C1 00 08 41 82 00 F8 80 1F 00 00 70 00 80 00 40 82 00 50 80 7F 00 48 3B C2 8B 60 81 23 00 08 7F 89 F0 00 41 9E 00 30 39 60 00 01 7D 20 18 28 7C 09 00 00 40 82 00 0C 7D 60 19 2D 40 A2 FF F0 4C 00 01 2C 2F 89 00 00 40 9E 00 C0 80 7F 00 48 93 C3 00 08 81 23 00 04 38 09 00 01 90 03 00 04 81 3F 00 98 7F E3 FB 78 80 09 00 30 7C 09 03 A6 4E 80 04 21 80 1F 00 00 7C 63 00 34 54 63 D9 7E 70 09 80 00 3B C3 FF FF 40 82 00 38 80 7F 00 48 81 23 00 04 38 09 FF FF 2F 80 00 00 90 03 00 04 40 9E 00 20 90 03 00 08 7C 00 04 AC 7D 20 18 28 7C 00 19 2D 40 A2 FF F8 2F 89 00 01 41 9D 00 20 80 01 00 14 7F C3 F3 78 83 E1 00 0C 7C 08 03 A6 83 C1 00 08 38 21 00 10 4E 80 00 20 80 82 8B 68 38 00 00 DD 38 A0 00 01 60 84 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF C8 4? ?? ?? ?? 7C 7E 1B 78 4B FF FF BC 4? ?? ?? ?? 4B FF FF 40 80 1F 00 00 7C 7E 1B 78 70 09 80 00 40 82 00 54 80 7F 00 48 80 03 00 04 30 00 FF FF 2F 80 00 00 90 03 00 04 40 9E 00 3C 90 03 00 08 7C 00 04 AC 7D 20 18 28 7C 00 19 2D 40 A2 FF F8 2F 89 00 01 40 BD 00 20 80 82 8B 68 38 00 00 DD 38 A0 00 01 60 84 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 7F C3 F3 78 4? ?? ?? ?? }
	condition:
		$1
}

rule file_268_0_0 {
	meta:
		name = "__setgid"
		size = 116
		refs = "000a __nptl_setxid 005a _GLOBAL_OFFSET_TABLE_ 0062 __libc_errno"
	strings:
		$1 = { 7C 08 02 A6 94 21 FF D0 3D 20 ?? ?? 90 01 00 34 38 09 ?? ?? 2F 80 00 00 7C 60 1B 78 41 9E 00 28 39 20 00 2E 90 01 00 0C 38 61 00 08 91 21 00 08 4? ?? ?? ?? 80 01 00 34 38 21 00 30 7C 08 03 A6 4E 80 00 20 38 00 00 2E 44 00 00 02 7C 00 00 26 74 09 10 00 41 82 FF E0 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 90 69 00 00 38 60 FF FF 4B FF FF C4 }
	condition:
		$1
}

rule file_269_0_0 {
	meta:
		name = "msort_with_tmp"
		size = 964
		refs = "00d0 memcpy 01dc mempcpy"
	strings:
		$1 = { 7D 80 00 26 2B 85 00 01 94 21 FF B0 7C 08 02 A6 92 81 00 20 7C 94 23 78 92 A1 00 24 7C B5 2B 78 93 01 00 30 7C 78 1B 78 90 01 00 54 92 21 00 14 92 41 00 18 92 61 00 1C 92 C1 00 28 92 E1 00 2C 93 21 00 34 93 41 00 38 93 61 00 3C 93 81 00 40 93 A1 00 44 93 C1 00 48 93 E1 00 4C 91 81 00 10 40 9D 00 8C 83 E3 00 00 54 BB F8 7E 7F BB 28 50 7F FB F9 D6 7F 65 DB 78 7F E4 FA 14 7C 9C 23 78 4B FF FF 81 7F 03 C3 78 7F E4 FB 78 7F A5 EB 78 4B FF FF 71 80 18 00 04 81 38 00 08 2F 80 00 01 83 D8 00 10 83 58 00 00 91 21 00 08 83 38 00 0C 41 9E 01 8C 2B 80 00 01 40 9C 00 DC 2E 1D 00 00 40 B2 00 9C 7C BB D1 D6 7F C3 F3 78 7F 84 E3 78 4? ?? ?? ?? 3B A0 00 00 7F BD A8 50 80 98 00 10 7C BD D1 D6 7E 83 A3 78 4? ?? ?? ?? 80 01 00 54 81 81 00 10 7C 08 03 A6 82 21 00 14 82 41 00 18 7D 80 81 20 82 61 00 1C 82 81 00 20 82 A1 00 24 82 C1 00 28 82 E1 00 2C 83 01 00 30 83 21 00 34 83 41 00 38 83 61 00 3C 83 81 00 40 83 A1 00 44 83 C1 00 48 83 E1 00 4C 38 21 00 50 4E 80 00 20 80 1F 00 00 3B BD FF FF 2E 1D 00 00 90 1E 00 00 3B FF 00 04 3B DE 00 04 41 B2 FF 6C 80 01 00 08 7F 83 E3 78 7F E4 FB 78 7F 25 CB 78 7C 09 03 A6 4E 80 04 21 2F 83 00 00 41 9D FF C8 37 7B FF FF 80 1C 00 00 3B 9C 00 04 90 1E 00 00 40 82 FF C8 4B FF FF 48 2F 80 00 02 41 9E 01 14 2F 80 00 03 41 9E 01 C4 2E 1D 00 00 41 B2 FF 1C 80 01 00 08 7F E4 FB 78 7F 25 CB 78 7F 83 E3 78 7C 09 03 A6 4E 80 04 21 7F E4 FB 78 2F 83 00 00 7F 45 D3 78 7F C3 F3 78 40 9D 00 48 3B BD FF FF 4? ?? ?? ?? 2E 1D 00 00 7C 7E 1B 78 7F FF D2 14 41 B2 FE D8 80 01 00 08 7F E4 FB 78 7F 25 CB 78 7F 83 E3 78 7C 09 03 A6 4E 80 04 21 7F E4 FB 78 2F 83 00 00 7F 45 D3 78 7F C3 F3 78 41 9D FF C0 7F 84 E3 78 4? ?? ?? ?? 37 7B FF FF 7C 7E 1B 78 7F 9C D2 14 41 A2 FE A8 40 92 FF BC 4B FF FE 8C 2E 1D 00 00 40 B2 00 2C 4B FF FE 80 81 3F 00 00 3B BD FF FF 81 5F 00 04 2E 1D 00 00 91 3E 00 00 3B FF 00 08 91 5E 00 04 3B DE 00 08 41 B2 FE 5C 80 01 00 08 7F 83 E3 78 7F E4 FB 78 7F 25 CB 78 7C 09 03 A6 4E 80 04 21 2F 83 00 00 41 9D FF C0 37 7B FF FF 81 3C 00 00 81 5C 00 04 3B 9C 00 08 91 3E 00 00 91 5E 00 04 40 82 FF C0 4B FF FE 30 2F 9D 00 00 7E FE D2 14 7E F6 BB 78 22 3A FF FC 22 5A 00 04 40 BE 00 34 4B FF FE 00 7F 93 B0 40 7F E9 FB 78 3B BD FF FF 7F FF D2 14 41 9C 00 58 2F 9B 00 00 41 BE FD F8 2F 9D 00 00 7E D6 D2 14 41 BE FD D8 7E F7 D2 14 80 01 00 08 7F 83 E3 78 7F E4 FB 78 7F 25 CB 78 7C 09 03 A6 7F D3 F3 78 7E FE BB 78 4E 80 04 21 2F 83 00 00 41 9D FF B0 7F 93 B0 40 7F 89 E3 78 3B 7B FF FF 7F 9C D2 14 40 9C FF B0 7C 17 92 14 39 56 00 03 7D 40 50 50 55 4A 00 3A 7C 1A B8 50 39 29 FF FC 7D 77 8A 14 7D 40 52 14 84 09 00 04 94 0B 00 04 7F 8B 50 00 41 9E FF 80 4B FF FF F0 2E 1D 00 00 40 B2 00 24 4B FF FD 58 80 1F 00 00 3B BD FF FF 2E 1D 00 00 90 1E 00 00 3B FF 00 04 3B DE 00 04 41 B2 FD 3C 80 01 00 08 7F 25 CB 78 80 7C 00 00 80 9F 00 00 7C 09 03 A6 4E 80 04 21 2F 83 00 00 41 9D FF C8 37 7B FF FF 80 1C 00 00 3B 9C 00 04 90 1E 00 00 40 82 FF C8 4B FF FD 18 }
	condition:
		$1
}

rule file_269_1_0 {
	meta:
		name = "qsort_r"
		size = 736
		refs = "0096 _GLOBAL_OFFSET_TABLE_ 009e __libc_errno 00ac malloc 015c memcpy 01e0 _quicksort 026c free 02a0 __sysconf"
	strings:
		$1 = { 2B 85 00 20 94 21 FF A0 7C 08 02 A6 93 21 00 44 90 01 00 64 54 80 18 38 7F 20 2A 14 93 41 00 48 7C DA 33 78 93 61 00 4C 7C FB 3B 78 93 81 00 50 7C 9C 23 78 93 A1 00 54 7C 7D 1B 78 93 C1 00 58 7C BE 2B 78 93 E1 00 5C 7C 3F 0B 78 92 81 00 30 92 A1 00 34 92 C1 00 38 92 E1 00 3C 93 01 00 40 41 9D 00 08 7F 25 21 D6 2B 99 03 FF 40 9D 02 08 3F 00 ?? ?? 80 78 ?? ?? 3A F8 ?? ?? 2F 83 00 00 41 9E 02 1C 7C 79 1B 96 80 17 00 04 7F 83 00 40 41 9D 01 3C 3F 00 ?? ?? 3B 18 ?? ?? 83 18 ?? ?? 7F 18 12 14 7F 23 CB 78 83 38 00 00 4? ?? ?? ?? 7C 74 1B 79 93 38 00 00 41 82 01 14 92 9F 00 18 2B 9E 00 20 93 DF 00 08 38 00 00 04 90 1F 00 0C 93 5F 00 10 93 7F 00 14 40 9D 01 50 83 5F 00 18 57 96 10 3A 7F B8 EB 78 7F 5A B2 14 7E DA B2 14 7F 9A B0 40 40 9C 00 20 7F 49 D3 78 7F A0 EB 78 90 09 00 00 39 29 00 04 7F 96 48 40 7C 00 F2 14 41 9D FF F0 38 00 00 04 90 1F 00 08 38 7F 00 08 38 00 00 03 7F 44 D3 78 90 1F 00 0C 7F 85 E3 78 4B FF FB 0D 2F 9C 00 00 41 9E 01 30 3A BA FF FC 3A E0 00 00 87 75 00 04 7F 9B C0 00 41 9E 00 6C 7E C3 B3 78 7F 04 C3 78 7F C5 F3 78 4? ?? ?? ?? 7F 03 C3 78 7E EB BB 78 48 00 00 08 7C 1B 03 78 7F 3D D8 50 7F 39 F3 96 55 6B 10 3A 7C 7A 59 2E 7F 64 DB 78 7F C5 F3 78 4? ?? ?? ?? 57 29 10 3A 7C 1A 48 2E 7F 63 DB 78 7D 3A 4A 14 7F 80 C0 00 7F 2B CB 78 40 9E FF C8 93 69 00 00 7E C4 B3 78 7F C5 F3 78 4? ?? ?? ?? 3A F7 00 01 7F 97 E0 00 41 9E 00 A8 7F 18 F2 14 4B FF FF 7C 7F A3 EB 78 7F 84 E3 78 7F C5 F3 78 7F 46 D3 78 7F 67 DB 78 4? ?? ?? ?? 39 7F 00 60 80 0B 00 04 82 8B FF D0 7C 08 03 A6 82 AB FF D4 82 CB FF D8 82 EB FF DC 83 0B FF E0 83 2B FF E4 83 4B FF E8 83 6B FF EC 83 8B FF F0 83 AB FF F4 83 CB FF F8 83 EB FF FC 7D 61 5B 78 4E 80 00 20 73 C0 00 03 40 82 00 2C 73 A0 00 03 40 82 00 24 2F 9E 00 04 41 9E 00 9C 2F 9E 00 08 40 BE 00 90 73 A0 00 07 40 82 00 88 38 00 00 01 90 1F 00 0C 38 7F 00 08 7F A4 EB 78 7F 85 E3 78 4B FF F9 D9 7E 83 A3 78 4? ?? ?? ?? 4B FF FF 74 38 19 00 1E 81 21 00 00 54 00 00 36 7C 00 00 D0 7D 21 01 6E 3A 80 00 00 38 01 00 17 54 00 00 36 90 1F 00 18 4B FF FE 28 38 60 00 55 4? ?? ?? ?? 3C 00 1F FF 2F 83 FF FF 60 00 FF FF 41 9E 00 0C 7C 60 16 70 7C 00 01 94 90 17 00 04 7C 00 06 AC 38 60 00 1E 4? ?? ?? ?? 90 78 ?? ?? 4B FF FD B4 38 00 00 02 90 1F 00 0C 4B FF FF 7C }
	condition:
		$1
}

rule file_270_0_0 {
	meta:
		name = "__nrand48_r"
		size = 96
		refs = "001c __drand48_iterate"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 93 C1 00 08 7C BE 2B 78 93 E1 00 0C 7C 7F 1B 78 90 01 00 14 4? ?? ?? ?? 2F 83 00 00 38 60 FF FF 41 9C 00 20 A1 3F 00 02 38 60 00 00 A0 1F 00 04 55 29 F8 7E 54 00 78 20 7D 20 03 78 90 1E 00 00 80 01 00 14 83 C1 00 08 7C 08 03 A6 83 E1 00 0C 38 21 00 10 4E 80 00 20 }
	condition:
		$1
}

rule file_271_0_0 {
	meta:
		name = "__get_sol"
		size = 160
		refs = "009c __assert_fail"
	strings:
		$1 = { 7C 08 02 A6 94 21 FF F0 3D 20 ?? ?? 39 60 00 07 90 01 00 14 39 29 ?? ?? 7D 69 03 A6 7C 60 1B 78 38 60 FF FF 48 00 00 0C 39 29 00 0C 42 40 00 3C 81 69 00 00 2F 8B FF FF 41 9E 00 48 81 49 00 08 7F 8A 20 00 40 9E FF E4 81 49 00 04 7F 8A 00 00 41 9E 00 28 2F 83 FF FF 40 9E FF D0 7D 63 5B 78 39 29 00 0C 42 00 FF CC 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 7D 63 5B 78 4B FF FF EC 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 00 45 38 C6 ?? ?? 4? ?? ?? ?? }
	condition:
		$1
}

rule file_271_1_0 {
	meta:
		name = "getsourcefilter"
		size = 444
		refs = "0098 memcpy 00ac __get_sol 00cc __getsockopt 00e4 free 012a _GLOBAL_OFFSET_TABLE_ 0132 __libc_errno 0188 __libc_alloca_cutoff 01a0 malloc"
	strings:
		$1 = { 94 21 FF B0 7C 08 02 A6 93 C1 00 48 83 C8 00 00 93 E1 00 4C 7C 3F 0B 78 57 DE 38 30 3B DE 00 8C 92 E1 00 2C 2B 9E 80 00 93 21 00 34 7D 37 4B 78 7C D9 33 78 93 41 00 38 7C FA 3B 78 93 61 00 3C 7C 7B 1B 78 93 81 00 40 7C BC 2B 78 93 A1 00 44 7D 1D 43 78 90 01 00 54 92 C1 00 28 93 01 00 30 93 DF 00 08 41 9D 01 1C 3B DE 00 1E 80 01 00 00 57 DE 00 36 7F DE 00 D0 7C 01 F1 6E 3B 00 00 01 3B C1 00 17 57 DE 00 36 90 9E 00 00 7F 25 CB 78 7F 84 E3 78 38 7E 00 04 4? ?? ?? ?? 80 1D 00 00 A0 7C 00 00 7F 24 CB 78 90 1E 00 88 4? ?? ?? ?? 2F 83 FF FF 7C 64 1B 78 41 9E 00 70 7F 63 DB 78 38 A0 00 30 7F C6 F3 78 38 FF 00 08 4? ?? ?? ?? 7C 76 1B 79 41 82 00 74 2F 98 00 00 40 BE 00 0C 7F C3 F3 78 4? ?? ?? ?? 39 7F 00 50 80 0B 00 04 7E C3 B3 78 82 EB FF DC 7C 08 03 A6 82 CB FF D8 83 0B FF E0 83 2B FF E4 83 4B FF E8 83 6B FF EC 83 8B FF F0 83 AB FF F4 83 CB FF F8 83 EB FF FC 7D 61 5B 78 4E 80 00 20 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 38 00 00 16 90 09 00 00 3A C0 FF FF 4B FF FF 94 80 1E 00 84 90 1A 00 00 80 1E 00 88 80 BD 00 00 7F 85 00 40 40 9D 00 08 7C 05 03 78 7E E3 BB 78 38 9E 00 8C 54 A5 38 30 4? ?? ?? ?? 80 1E 00 88 90 1D 00 00 4B FF FF 5C 7F C3 F3 78 90 9F 00 18 4? ?? ?? ?? 2F 83 00 00 80 9F 00 18 40 9E FE D4 7F C3 F3 78 90 9F 00 18 4? ?? ?? ?? 3A C0 FF FF 7C 7E 1B 79 80 9F 00 18 41 A2 FF 38 3B 00 00 00 4B FF FE D0 }
	condition:
		$1
}

rule file_272_0_0 {
	meta:
		name = "__strfmon"
		size = 148
		refs = "004a _GLOBAL_OFFSET_TABLE_ 005e __libc_tsd_LOCALE 0080 __vstrfmon_l"
	strings:
		$1 = { 94 21 FF 90 7C 08 02 A6 90 C1 00 1C 90 01 00 74 90 E1 00 20 91 01 00 24 91 21 00 28 91 41 00 2C 40 86 00 24 D8 21 00 30 D8 41 00 38 D8 61 00 40 D8 81 00 48 D8 A1 00 50 D8 C1 00 58 D8 E1 00 60 D9 01 00 68 38 00 00 03 3D 20 ?? ?? 98 01 00 08 39 29 ?? ?? 38 00 00 00 98 01 00 09 81 29 ?? ?? 7D 29 12 14 38 01 00 78 7C A6 2B 78 80 A9 00 00 90 01 00 0C 38 E1 00 08 38 01 00 10 90 01 00 10 4? ?? ?? ?? 80 01 00 74 38 21 00 70 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_274_0_0 {
	meta:
		name = "mknodat"
		size = 72
		refs = "0034 __xmknodat"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 7C 6B 1B 78 7C 29 0B 78 90 01 00 14 7C 80 23 78 94 E9 00 08 7C A6 2B 78 38 60 00 01 91 09 00 04 7C 05 03 78 7D 64 5B 78 7D 27 4B 78 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_275_0_0 {
	meta:
		name = "__libc_msync"
		size = 132
		refs = "0018 __syscall_error 0034 __libc_enable_asynccancel 0060 __libc_disable_asynccancel"
		altNames = "msync"
	strings:
		$1 = { 81 42 8B 60 2C 0A 00 00 40 82 00 14 38 00 00 90 44 00 00 02 4C A3 00 20 4? ?? ?? ?? 94 21 FF D0 7D 28 02 A6 91 21 00 34 90 A1 00 1C 90 81 00 18 90 61 00 14 4? ?? ?? ?? 90 61 00 10 80 A1 00 1C 80 81 00 18 80 61 00 14 38 00 00 90 44 00 00 02 7C 00 00 26 90 61 00 08 90 01 00 0C 80 61 00 10 4? ?? ?? ?? 80 81 00 34 80 01 00 0C 80 61 00 08 7C 88 03 A6 7C 0F F1 20 38 21 00 30 4C A3 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_78_0_3 {
	meta:
		name = "__libc_msync"
		size = 132
		refs = "0018 __syscall_error 0034 __pthread_enable_asynccancel 0060 __pthread_disable_asynccancel"
	strings:
		$1 = { 81 42 8B 60 2C 0A 00 00 40 82 00 14 38 00 00 90 44 00 00 02 4C A3 00 20 4? ?? ?? ?? 94 21 FF D0 7D 28 02 A6 91 21 00 34 90 A1 00 1C 90 81 00 18 90 61 00 14 4? ?? ?? ?? 90 61 00 10 80 A1 00 1C 80 81 00 18 80 61 00 14 38 00 00 90 44 00 00 02 7C 00 00 26 90 61 00 08 90 01 00 0C 80 61 00 10 4? ?? ?? ?? 80 81 00 34 80 01 00 0C 80 61 00 08 7C 88 03 A6 7C 0F F1 20 38 21 00 30 4C A3 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_78_2_3 {
	meta:
		name = "msync"
		size = 132
		refs = "0018 __syscall_error 0034 __pthread_enable_asynccancel 0060 __pthread_disable_asynccancel"
	strings:
		$1 = { 81 42 8B 60 2C 0A 00 00 40 82 00 14 38 00 00 90 44 00 00 02 4C A3 00 20 4? ?? ?? ?? 94 21 FF D0 7D 28 02 A6 91 21 00 34 90 A1 00 1C 90 81 00 18 90 61 00 14 4? ?? ?? ?? 90 61 00 10 80 A1 00 1C 80 81 00 18 80 61 00 14 38 00 00 90 44 00 00 02 7C 00 00 26 90 61 00 08 90 01 00 0C 80 61 00 10 4? ?? ?? ?? 80 81 00 34 80 01 00 0C 80 61 00 08 7C 88 03 A6 7C 0F F1 20 38 21 00 30 4C A3 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_275_1_0 {
	meta:
		name = "__msync_nocancel"
		size = 16
		refs = "000c __syscall_error"
	strings:
		$1 = { 38 00 00 90 44 00 00 02 4C A3 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_276_0_0 {
	meta:
		name = "__libc_sendmsg"
		size = 140
		refs = "0034 __syscall_error 0040 __libc_enable_asynccancel 0068 __libc_disable_asynccancel"
	strings:
		$1 = { 94 21 FF D0 90 61 00 14 90 81 00 18 90 A1 00 1C 81 42 8B 60 2C 0A 00 00 40 82 00 20 38 60 00 10 38 81 00 14 38 00 00 66 44 00 00 02 38 21 00 30 4C A3 00 20 4? ?? ?? ?? 7D 28 02 A6 91 21 00 34 4? ?? ?? ?? 90 61 00 10 38 60 00 10 38 81 00 14 38 00 00 66 44 00 00 02 7C 00 00 26 90 61 00 08 90 01 00 0C 80 61 00 10 4? ?? ?? ?? 80 81 00 34 80 01 00 0C 80 61 00 08 7C 88 03 A6 7C 0F F1 20 38 21 00 30 4C A3 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_73_0_3 {
	meta:
		name = "__libc_sendmsg"
		size = 140
		refs = "0034 __syscall_error 0040 __pthread_enable_asynccancel 0068 __pthread_disable_asynccancel"
	strings:
		$1 = { 94 21 FF D0 90 61 00 14 90 81 00 18 90 A1 00 1C 81 42 8B 60 2C 0A 00 00 40 82 00 20 38 60 00 10 38 81 00 14 38 00 00 66 44 00 00 02 38 21 00 30 4C A3 00 20 4? ?? ?? ?? 7D 28 02 A6 91 21 00 34 4? ?? ?? ?? 90 61 00 10 38 60 00 10 38 81 00 14 38 00 00 66 44 00 00 02 7C 00 00 26 90 61 00 08 90 01 00 0C 80 61 00 10 4? ?? ?? ?? 80 81 00 34 80 01 00 0C 80 61 00 08 7C 88 03 A6 7C 0F F1 20 38 21 00 30 4C A3 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_277_0_0 {
	meta:
		name = "mkostemps64"
		size = 80
		refs = "001c __gen_tempname 0032 _GLOBAL_OFFSET_TABLE_ 003a __libc_errno"
	strings:
		$1 = { 2F 84 00 00 94 21 FF F0 7C 08 02 A6 90 01 00 14 41 9C 00 20 64 A5 00 01 38 C0 00 00 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 38 00 00 16 90 09 00 00 38 60 FF FF 4B FF FF D4 }
	condition:
		$1
}

rule file_279_0_0 {
	meta:
		name = "posix_spawnattr_setflags"
		size = 28
	strings:
		$1 = { 54 80 00 31 38 00 00 16 40 82 00 0C B0 83 00 00 38 00 00 00 7C 03 03 78 4E 80 00 20 }
	condition:
		$1
}

rule file_280_0_0 {
	meta:
		name = "__wmemcpy_chk"
		size = 48
		refs = "0018 memcpy 002c __chk_fail"
	strings:
		$1 = { 7F 86 28 40 94 21 FF F0 7C 08 02 A6 90 01 00 14 41 9C 00 1C 54 A5 10 3A 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_989_0_0 {
	meta:
		name = "__wmemmove_chk"
		size = 48
		refs = "0018 memmove 002c __chk_fail"
	strings:
		$1 = { 7F 86 28 40 94 21 FF F0 7C 08 02 A6 90 01 00 14 41 9C 00 1C 54 A5 10 3A 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_1040_0_0 {
	meta:
		name = "__wmempcpy_chk"
		size = 48
		refs = "0018 mempcpy 002c __chk_fail"
	strings:
		$1 = { 7F 86 28 40 94 21 FF F0 7C 08 02 A6 90 01 00 14 41 9C 00 1C 54 A5 10 3A 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_281_0_0 {
	meta:
		name = "strcspn"
		size = 120
		refs = "004c strchr"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 93 A1 00 14 7C 9D 23 78 93 C1 00 18 7C 7E 1B 78 93 E1 00 1C 3B E0 00 00 90 01 00 24 88 03 00 00 2F 80 00 00 40 BE 00 18 48 00 00 28 3B FF 00 01 7C 1E F8 AE 2F 80 00 00 41 9E 00 18 7C 04 03 78 7F A3 EB 78 4? ?? ?? ?? 2F 83 00 00 41 9E FF E0 80 01 00 24 7F E3 FB 78 83 A1 00 14 7C 08 03 A6 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 }
	condition:
		$1
}

rule file_282_0_0 {
	meta:
		name = "__vwprintf_chk"
		size = 508
		refs = "0012 stdout 00bc _IO_vfwprintf 017c __lll_lock_wait_private 01f8 _Unwind_Resume"
	strings:
		$1 = { 94 21 FF D0 7C 08 02 A6 7D 80 00 26 93 C1 00 28 3F C0 ?? ?? 90 01 00 34 93 E1 00 2C 83 FE ?? ?? 93 61 00 1C 7C 7B 1B 78 80 1F 00 00 93 81 00 20 7C 9C 23 78 70 00 80 00 93 A1 00 24 7C BD 2B 78 93 41 00 18 91 81 00 14 40 82 00 50 80 7F 00 48 3B 42 8B 60 81 23 00 08 7F 89 D0 00 41 9E 00 30 39 60 00 01 7D 20 18 28 7C 09 00 00 40 82 00 0C 7D 60 19 2D 40 A2 FF F0 4C 00 01 2C 2F 89 00 00 40 9E 00 FC 80 7F 00 48 93 43 00 08 81 23 00 04 38 09 00 01 90 03 00 04 2E 1B 00 00 40 91 00 14 81 3E ?? ?? 80 09 00 3C 60 00 00 04 90 09 00 3C 80 7E ?? ?? 7F 84 E3 78 7F A5 EB 78 4? ?? ?? ?? 7C 7D 1B 78 40 91 00 14 81 3E ?? ?? 80 09 00 3C 54 00 07 B8 90 09 00 3C 80 1F 00 00 81 3F 00 3C 70 0B 80 00 38 00 FF EB 7D 20 00 38 90 1F 00 3C 40 82 00 38 80 7F 00 48 81 23 00 04 38 09 FF FF 2F 80 00 00 90 03 00 04 40 9E 00 20 90 03 00 08 7C 00 04 AC 7D 20 18 28 7C 00 19 2D 40 A2 FF F8 2F 89 00 01 41 9D 00 38 80 01 00 34 7F A3 EB 78 81 81 00 14 7C 08 03 A6 83 41 00 18 83 61 00 1C 7D 80 81 20 83 81 00 20 83 A1 00 24 83 C1 00 28 83 E1 00 2C 38 21 00 30 4E 80 00 20 80 82 8B 68 38 00 00 DD 38 A0 00 01 60 84 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF B0 4? ?? ?? ?? 4B FF FF 04 80 1F 00 00 7C 7E 1B 78 81 3F 00 3C 70 0B 80 00 38 00 FF EB 7D 20 00 38 90 1F 00 3C 40 82 00 54 80 7F 00 48 80 03 00 04 30 00 FF FF 2F 80 00 00 90 03 00 04 40 9E 00 3C 90 03 00 08 7C 00 04 AC 7D 20 18 28 7C 00 19 2D 40 A2 FF F8 2F 89 00 01 40 BD 00 20 80 82 8B 68 38 00 00 DD 38 A0 00 01 60 84 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 7F C3 F3 78 4? ?? ?? ?? }
	condition:
		$1
}

rule file_449_0_0 {
	meta:
		name = "___vprintf_chk"
		size = 508
		refs = "0012 stdout 00bc vfprintf 017c __lll_lock_wait_private 01f8 _Unwind_Resume"
	strings:
		$1 = { 94 21 FF D0 7C 08 02 A6 7D 80 00 26 93 C1 00 28 3F C0 ?? ?? 90 01 00 34 93 E1 00 2C 83 FE ?? ?? 93 61 00 1C 7C 7B 1B 78 80 1F 00 00 93 81 00 20 7C 9C 23 78 70 00 80 00 93 A1 00 24 7C BD 2B 78 93 41 00 18 91 81 00 14 40 82 00 50 80 7F 00 48 3B 42 8B 60 81 23 00 08 7F 89 D0 00 41 9E 00 30 39 60 00 01 7D 20 18 28 7C 09 00 00 40 82 00 0C 7D 60 19 2D 40 A2 FF F0 4C 00 01 2C 2F 89 00 00 40 9E 00 FC 80 7F 00 48 93 43 00 08 81 23 00 04 38 09 00 01 90 03 00 04 2E 1B 00 00 40 91 00 14 81 3E ?? ?? 80 09 00 3C 60 00 00 04 90 09 00 3C 80 7E ?? ?? 7F 84 E3 78 7F A5 EB 78 4? ?? ?? ?? 7C 7D 1B 78 40 91 00 14 81 3E ?? ?? 80 09 00 3C 54 00 07 B8 90 09 00 3C 80 1F 00 00 81 3F 00 3C 70 0B 80 00 38 00 FF EB 7D 20 00 38 90 1F 00 3C 40 82 00 38 80 7F 00 48 81 23 00 04 38 09 FF FF 2F 80 00 00 90 03 00 04 40 9E 00 20 90 03 00 08 7C 00 04 AC 7D 20 18 28 7C 00 19 2D 40 A2 FF F8 2F 89 00 01 41 9D 00 38 80 01 00 34 7F A3 EB 78 81 81 00 14 7C 08 03 A6 83 41 00 18 83 61 00 1C 7D 80 81 20 83 81 00 20 83 A1 00 24 83 C1 00 28 83 E1 00 2C 38 21 00 30 4E 80 00 20 80 82 8B 68 38 00 00 DD 38 A0 00 01 60 84 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF B0 4? ?? ?? ?? 4B FF FF 04 80 1F 00 00 7C 7E 1B 78 81 3F 00 3C 70 0B 80 00 38 00 FF EB 7D 20 00 38 90 1F 00 3C 40 82 00 54 80 7F 00 48 80 03 00 04 30 00 FF FF 2F 80 00 00 90 03 00 04 40 9E 00 3C 90 03 00 08 7C 00 04 AC 7D 20 18 28 7C 00 19 2D 40 A2 FF F8 2F 89 00 01 40 BD 00 20 80 82 8B 68 38 00 00 DD 38 A0 00 01 60 84 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 7F C3 F3 78 4? ?? ?? ?? }
	condition:
		$1
}

rule file_283_0_0 {
	meta:
		name = "getprotoent"
		size = 252
		refs = "0056 __getprotoent_r 0070 __nss_getent 0078 __errno_location 00d0 __lll_lock_wait_private"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 39 60 00 01 93 61 00 0C 3F 60 ?? ?? 39 20 00 00 93 81 00 10 3B 9B ?? ?? 90 01 00 24 93 A1 00 14 93 C1 00 18 93 E1 00 1C 7C 00 E0 28 7C 00 48 00 40 82 00 0C 7D 60 E1 2D 40 A2 FF F0 4C 00 01 2C 2F 80 00 00 40 9E 00 80 3C A0 ?? ?? 3C 60 ?? ?? 38 9C 00 04 38 A5 ?? ?? 38 C0 04 00 38 FC 00 10 39 00 00 00 38 63 ?? ?? 4? ?? ?? ?? 7C 7E 1B 78 4? ?? ?? ?? 7C 7F 1B 78 83 A3 00 00 38 00 00 00 7C 00 04 AC 7D 20 E0 28 7C 00 E1 2D 40 A2 FF F8 2F 89 00 01 41 9D 00 3C 80 01 00 24 7F C3 F3 78 93 BF 00 00 7C 08 03 A6 83 61 00 0C 83 81 00 10 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 7F 83 E3 78 4? ?? ?? ?? 4B FF FF 7C 80 82 8B 68 38 00 00 DD 7F 83 E3 78 60 84 00 01 38 A0 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF A8 }
	condition:
		$1
}

rule file_285_0_0 {
	meta:
		name = "__alloc_dir"
		size = 352
		refs = "0032 __have_o_cloexec 006c malloc 00d0 __fcntl 0132 _GLOBAL_OFFSET_TABLE_ 013a __libc_errno"
	strings:
		$1 = { 7D 80 00 26 2E 04 00 00 94 21 FF E0 7C 08 02 A6 93 A1 00 14 7C 7D 1B 78 93 E1 00 1C 7C BF 2B 78 90 01 00 24 93 C1 00 18 91 81 00 10 41 92 00 C4 3F C0 ?? ?? 80 1E ?? ?? 2F 80 00 00 41 9E 00 88 40 9D 00 B0 2F 9F 00 00 38 60 00 00 3B C0 00 00 60 63 80 18 63 DE 80 00 41 9E 00 14 83 DF 00 38 2B 9E 80 00 41 9C 00 54 38 7E 00 18 4? ?? ?? ?? 2C 03 00 00 41 82 00 A4 38 00 00 00 93 A3 00 00 90 03 00 04 93 C3 00 08 90 03 00 0C 90 03 00 10 90 03 00 14 80 01 00 24 81 81 00 10 7C 08 03 A6 83 A1 00 14 83 C1 00 18 7D 80 81 20 83 E1 00 1C 38 21 00 20 4E 80 00 20 3B C0 00 00 63 DE 80 00 4B FF FF A8 38 80 00 01 38 A0 00 00 4C C6 31 82 4? ?? ?? ?? 54 60 07 FE 30 00 FF FF 7C 00 01 10 60 00 00 01 2F 80 00 00 90 1E ?? ?? 41 9D FF 58 7F A3 EB 78 38 80 00 02 38 A0 00 01 4C C6 31 82 4? ?? ?? ?? 2F 83 00 00 40 9C FF 3C 40 92 00 24 38 60 00 00 4B FF FF 80 38 60 20 18 4? ?? ?? ?? 3B C0 20 00 2C 03 00 00 40 82 FF 50 4B FF FF E0 3F E0 ?? ?? 3B FF ?? ?? 83 FF ?? ?? 7F FF 12 14 83 DF 00 00 38 00 00 06 7F A3 EB 78 44 00 00 02 7C 00 00 26 38 60 00 00 93 DF 00 00 4B FF FF 38 }
	condition:
		$1
}

rule file_285_1_0 {
	meta:
		name = "__opendir"
		size = 116
		refs = "0024 __open_nocancel 0044 __alloc_dir 004a _GLOBAL_OFFSET_TABLE_ 0052 __libc_errno"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 88 03 00 00 2F 80 00 00 41 9E 00 34 3C 80 00 09 60 84 48 00 4C C6 31 82 4? ?? ?? ?? 2F 83 00 00 41 9C 00 34 80 01 00 14 38 80 00 01 38 A0 00 00 7C 08 03 A6 38 21 00 10 4? ?? ?? ?? 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 38 00 00 02 90 09 00 00 80 01 00 14 38 60 00 00 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_286_0_0 {
	meta:
		name = "__updwtmp"
		size = 408
		refs = "0034 strcmp 009a __libc_utmp_file_functions 00e4 __access"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 93 A1 00 14 3F A0 ?? ?? 3B BD ?? ?? 93 81 00 10 7C 9C 23 78 7F A4 EB 78 93 E1 00 1C 7C 7F 1B 78 90 01 00 24 93 61 00 0C 93 C1 00 18 4? ?? ?? ?? 2F 83 00 00 41 9E 00 98 3F 60 ?? ?? 3B 7B ?? ?? 7F E3 FB 78 7F 64 DB 78 4? ?? ?? ?? 2F 83 00 00 41 9E 00 B4 3F C0 ?? ?? 3B DE ?? ?? 7F E3 FB 78 7F C4 F3 78 4? ?? ?? ?? 2F 83 00 00 41 9E 00 D0 3F A0 ?? ?? 3B BD ?? ?? 7F E3 FB 78 7F A4 EB 78 4? ?? ?? ?? 7F FE FB 78 2F 83 00 00 41 9E 00 E8 3D 20 ?? ?? 80 09 ?? ?? 7F C3 F3 78 7F 84 E3 78 7C 09 03 A6 4E 80 04 21 80 01 00 24 83 61 00 0C 7C 08 03 A6 83 81 00 10 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 3F C0 ?? ?? 3B DE ?? ?? 7F C3 F3 78 38 80 00 00 4? ?? ?? ?? 2F 83 00 00 41 BE FF AC 3F 60 ?? ?? 3B 7B ?? ?? 7F E3 FB 78 7F 64 DB 78 4? ?? ?? ?? 2F 83 00 00 40 9E FF 54 3F C0 ?? ?? 3B DE ?? ?? 7F C3 F3 78 38 80 00 00 4? ?? ?? ?? 2F 83 00 00 41 BE FF 74 3F C0 ?? ?? 3B DE ?? ?? 7F E3 FB 78 7F C4 F3 78 4? ?? ?? ?? 2F 83 00 00 40 9E FF 38 7F C3 F3 78 38 80 00 00 4? ?? ?? ?? 7F BE EB 78 2F 83 00 00 40 BE FF 40 3F A0 ?? ?? 3B BD ?? ?? 7F E3 FB 78 7F A4 EB 78 4? ?? ?? ?? 7F FE FB 78 2F 83 00 00 40 9E FF 20 7F A3 EB 78 38 80 00 00 4? ?? ?? ?? 2F 83 00 00 41 BE FF 0C 7F 7E DB 78 4B FF FF 04 }
	condition:
		$1
}

rule file_287_0_0 {
	meta:
		name = "__fchdir"
		size = 16
		refs = "000c __syscall_error"
	strings:
		$1 = { 38 00 00 85 44 00 00 02 4C A3 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_288_0_0 {
	meta:
		name = "__assert_fail"
		size = 344
		refs = "000a pthread_setcancelstate 004a _libc_intl_domainname 005c __dcgettext 0062 __progname 00a8 __asprintf 00c8 __fxprintf 00ce stderr 00d4 _IO_fflush 00da __abort_msg 00f8 free 00fc abort 0150 __libc_write"
	strings:
		$1 = { 94 21 FF D0 7C 08 02 A6 3D 20 ?? ?? 90 01 00 34 38 09 ?? ?? 2F 80 00 00 93 81 00 20 7C 9C 23 78 93 A1 00 24 7C BD 2B 78 93 C1 00 28 7C DE 33 78 93 E1 00 2C 7C 7F 1B 78 41 9E 00 10 38 60 00 01 38 80 00 00 4? ?? ?? ?? 3C 60 ?? ?? 3C 80 ?? ?? 38 84 ?? ?? 38 A0 00 05 38 63 ?? ?? 4? ?? ?? ?? 3D 20 ?? ?? 80 A9 ?? ?? 7C 64 1B 78 88 05 00 00 2F 80 00 00 41 9E 00 8C 2F 9E 00 00 3C C0 ?? ?? 38 C6 ?? ?? 41 9E 00 8C 3D 40 ?? ?? 93 E1 00 08 39 4A ?? ?? 38 61 00 10 7F 87 E3 78 7F A8 EB 78 7F C9 F3 78 4C C6 31 82 4? ?? ?? ?? 2F 83 00 00 41 9C 00 90 80 A1 00 10 3C 80 ?? ?? 38 84 ?? ?? 38 60 00 00 4C C6 31 82 4? ?? ?? ?? 3D 20 ?? ?? 80 69 ?? ?? 4? ?? ?? ?? 3D 20 ?? ?? 39 69 ?? ?? 80 61 00 10 7C 00 58 28 7C 60 59 2D 40 A2 FF F8 4C 00 01 2C 7C 03 03 78 4? ?? ?? ?? 4? ?? ?? ?? 2F 9E 00 00 3C C0 ?? ?? 38 C6 ?? ?? 40 9E FF 7C 3F C0 ?? ?? 93 E1 00 08 3B DE ?? ?? 7F CA F3 78 38 61 00 10 7F 87 E3 78 7F A8 EB 78 7F C9 F3 78 4C C6 31 82 4? ?? ?? ?? 2F 83 00 00 40 9C FF 78 3C 80 ?? ?? 38 84 ?? ?? 38 A0 00 12 38 60 00 02 4? ?? ?? ?? 4? ?? ?? ?? }
	condition:
		$1
}

rule file_292_0_0 {
	meta:
		name = "__lll_lock_wait_private"
		size = 124
	strings:
		$1 = { 80 03 00 00 94 21 FF F0 2F 80 00 02 93 E1 00 0C 7C 7F 1B 78 40 BE 00 24 48 00 00 48 80 82 8B 68 38 00 00 DD 7F E3 FB 78 38 A0 00 02 38 C0 00 00 44 00 00 02 7C 00 00 26 38 00 00 02 7D 20 F8 28 7C 00 F9 2D 40 A2 FF F8 4C 00 01 2C 2F 89 00 00 40 9E FF CC 83 E1 00 0C 38 21 00 10 4E 80 00 20 38 00 00 DD 80 82 8B 68 38 A0 00 02 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF C0 }
	condition:
		$1
}

rule file_293_0_0 {
	meta:
		name = "setegid"
		size = 176
		refs = "001e __nptl_setxid 005a _GLOBAL_OFFSET_TABLE_ 0062 __libc_errno"
	strings:
		$1 = { 2F 83 FF FF 7C 08 02 A6 94 21 FF D0 7C 64 1B 78 90 01 00 34 38 00 FF FF 41 9E 00 40 3D 20 ?? ?? 39 29 ?? ?? 2F 89 00 00 41 9E 00 50 39 20 00 A9 90 01 00 0C 38 61 00 08 91 21 00 08 90 81 00 10 90 01 00 14 4? ?? ?? ?? 80 01 00 34 38 21 00 30 7C 08 03 A6 4E 80 00 20 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 38 00 00 16 90 09 00 00 38 60 FF FF 4B FF FF D4 38 00 00 A9 38 60 FF FF 38 A0 FF FF 44 00 00 02 7C 00 00 26 74 09 10 00 41 82 FF B8 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 90 69 00 00 38 60 FF FF 4B FF FF 9C }
	condition:
		$1
}

rule file_294_0_0 {
	meta:
		name = "creat64"
		size = 44
		refs = "0018 __open64"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 7C 85 23 78 38 80 02 41 90 01 00 14 4C C6 31 82 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_295_0_0 {
	meta:
		name = "__printf_fphex"
		size = 5980
		refs = "0082 _GLOBAL_OFFSET_TABLE_ 008a _nl_current_LC_NUMERIC 00e0 __isnanl 00ee __libc_tsd_CTYPE_B 0262 _nl_current_LC_MONETARY 0290 __isnan 0340 __isinf 0450 __isinfl 04b0 __overflow 05b4 _itoa 05dc _itowa 0778 _itoa_word 077e _itowa_lower_digits 07f0 strlen 090c _IO_wpadn 0c2a __libc_tsd_CTYPE_TOLOWER 0c32 _nl_current_LC_CTYPE 0e3c _IO_padn 1090 __assert_fail 1248 __woverflow"
	strings:
		$1 = { 94 21 FE 80 7C 08 02 A6 7D 80 00 26 90 01 01 84 92 C1 01 48 93 01 01 50 93 41 01 58 93 81 01 60 7C 7C 1B 78 93 A1 01 64 7C 9D 23 78 DB C1 01 70 DB E1 01 78 91 E1 01 2C 92 01 01 30 92 21 01 34 92 41 01 38 92 61 01 3C 92 81 01 40 92 A1 01 44 92 E1 01 4C 93 21 01 54 93 61 01 5C 93 C1 01 68 93 E1 01 6C 91 81 01 28 83 E4 00 0C 82 C4 00 00 77 E0 00 80 83 44 00 04 57 F8 5F FE 40 82 01 DC 3F 60 ?? ?? 3B 7B ?? ?? 81 3B ?? ?? 7D 29 12 14 81 29 00 00 81 29 00 00 80 09 00 30 83 29 00 24 90 01 00 08 88 19 00 00 2F 80 00 00 41 9E 0F C8 80 01 00 08 2F 80 00 00 41 9E 0F BC 2F 9F 00 00 40 9C 01 C0 81 25 00 00 CB C9 00 00 CB E9 00 08 FC 20 F0 90 DB C1 00 20 FC 40 F8 90 DB E1 00 28 4? ?? ?? ?? 2F 83 00 00 41 9E 03 58 81 7B ?? ?? 82 E1 00 20 7D 6B 12 14 81 2B 00 00 56 F7 00 00 7E F7 00 34 2F 89 00 00 56 F7 D9 7E 6A F7 00 01 41 9E 11 CC 80 1D 00 08 54 00 08 3C 7C 09 02 2E 70 07 00 01 40 82 01 B4 3E A0 ?? ?? 3F C0 ?? ?? 3A B5 ?? ?? 3B DE ?? ?? 2E 17 00 00 7F 5B D3 78 40 92 01 B4 77 E9 0A 00 40 82 01 AC 77 E0 04 00 3B 7B FF FD 3B E0 00 00 2D 98 00 00 40 82 00 10 2F 9B 00 00 7C 1F 03 78 41 9D 09 24 40 92 0C 54 80 1D 00 0C 74 0B 02 00 40 82 0C 80 74 07 08 00 40 82 09 AC 41 8E 01 78 3A B5 FF FC 3B DF 00 03 81 3C 00 5C 84 95 00 04 2F 89 00 00 41 9E 10 A8 81 69 00 10 80 09 00 14 7F 8B 00 40 40 9C 10 98 38 64 00 01 90 8B 00 00 38 0B 00 04 7C 63 00 34 90 09 00 10 54 63 D9 7E 2F 83 00 00 40 9E 02 FC 3B FF 00 01 7F 9F F0 00 40 9E FF B8 80 1D 00 0C 74 09 04 00 41 82 00 0C 2F 9B 00 00 41 9D 0B A0 80 01 01 84 7F E3 FB 78 81 81 01 28 7C 08 03 A6 81 E1 01 2C 82 01 01 30 7D 83 81 20 82 21 01 34 82 41 01 38 82 61 01 3C 82 81 01 40 82 A1 01 44 82 C1 01 48 82 E1 01 4C 83 01 01 50 83 21 01 54 83 41 01 58 83 61 01 5C 83 81 01 60 83 A1 01 64 83 C1 01 68 83 E1 01 6C CB C1 01 70 CB E1 01 78 38 21 01 80 4E 80 00 20 3F 60 ?? ?? 3B 7B ?? ?? 81 3B ?? ?? 7D 29 12 14 81 29 00 00 81 29 00 00 80 09 00 D0 83 29 00 2C 90 01 00 08 4B FF FE 28 81 25 00 00 CB C9 00 00 FC 20 F0 90 DB C1 00 20 4? ?? ?? ?? 2F 83 00 00 41 9E 00 9C 81 7B ?? ?? 82 E1 00 20 7D 6B 12 14 81 2B 00 00 56 F7 00 00 7E F7 00 34 2F 89 00 00 56 F7 D9 7E 6A F7 00 01 41 9E 0F F8 80 1D 00 08 54 00 08 3C 7C 09 02 2E 70 0B 00 01 41 A2 FE 54 2E 17 00 00 3E A0 ?? ?? 3F C0 ?? ?? 3A B5 ?? ?? 3B DE ?? ?? 7F 5B D3 78 41 B2 FE 54 3B 7A FF FF 4B FF FE 54 3B DE FF FF 3B 5F 00 03 81 3C 00 14 80 1C 00 18 8C 9E 00 01 7F 89 00 40 40 9C 0F 8C 38 09 00 01 98 89 00 00 90 1C 00 14 3B FF 00 01 7F 9F D0 00 40 9E FF D8 4B FF FE AC FC 20 F0 90 3A A0 00 00 3B C0 00 00 4? ?? ?? ?? 2F 83 00 00 41 9E 00 3C 81 7B ?? ?? 7D 6B 12 14 81 2B 00 00 2F 89 00 00 41 9E 11 54 80 1D 00 08 54 00 08 3C 7C 09 02 2E 70 07 00 01 41 82 01 74 3E A0 ?? ?? 3F C0 ?? ?? 3A B5 ?? ?? 3B DE ?? ?? DB C1 01 10 81 21 01 10 55 37 0F FE 2F 9E 00 00 40 9E FD A4 2F 9F 00 00 40 9C 09 10 81 61 00 28 81 81 00 2C 91 61 00 38 81 21 00 20 80 01 00 38 91 81 00 3C 54 0B 39 70 91 21 00 30 74 09 7F F0 81 41 00 24 80 E1 00 3C 91 41 00 34 54 E6 3E 7E 81 01 00 30 7C CB 5B 78 81 41 00 34 54 E6 38 30 55 09 03 3E 41 82 06 90 65 7E 08 00 7C DF 33 78 55 07 65 7E 54 0B 65 7E 7D 6B 38 50 2F 8B 00 74 7C F0 3B 78 41 9D 00 F0 2F 8B 00 35 41 9D 07 80 40 82 00 EC 41 9E 00 E8 21 6B 00 35 38 CB FF E0 2F 86 00 00 41 9C 0C 10 7F E6 30 30 39 60 00 00 7C DE 33 78 7D 7F 5B 78 48 00 00 C4 FC 20 F0 90 3A A0 00 00 FC 40 F8 90 3B C0 00 00 4? ?? ?? ?? 2F 83 00 00 41 9E 00 3C 81 7B ?? ?? 7D 6B 12 14 81 2B 00 00 2F 89 00 00 41 9E 10 20 80 1D 00 08 54 00 08 3C 7C 09 02 2E 70 09 00 01 41 82 00 50 3E A0 ?? ?? 3F C0 ?? ?? 3A B5 ?? ?? 3B DE ?? ?? DB C1 00 40 82 E1 00 40 DB E1 00 48 56 F7 0F FE 4B FF FE EC 7F 83 E3 78 38 80 00 20 4? ?? ?? ?? 38 63 00 01 7C 63 00 34 54 63 D9 7E 2F 83 00 00 41 9E 06 98 3B E0 FF FF 4B FF FD 24 3E A0 ?? ?? 3F C0 ?? ?? 3A B5 ?? ?? 3B DE ?? ?? 4B FF FF B4 3E A0 ?? ?? 3F C0 ?? ?? 3A B5 ?? ?? 3B DE ?? ?? 4B FF FE 90 3B C0 00 00 3B E0 00 00 55 0B 0F FE 54 00 0F FE 7F 8B 00 00 41 9E 00 58 41 82 05 A4 7D 20 53 79 3D 60 10 00 39 80 00 00 7F FF 60 10 7F DE 59 10 40 82 06 3C 3A 07 07 FF 56 10 05 7E 57 E7 0F FE 57 C6 09 3C 52 08 A0 56 57 CB 2E FE 91 01 00 30 57 E0 08 3C 3C A0 00 0F 7C DE 3B 78 38 E0 FF FE 60 A9 FF FF 7C EA 5B 78 7C 1F 03 78 55 52 E0 06 80 FD 00 08 55 20 E0 06 55 54 E1 3E 7E 52 F3 78 7C 14 A3 78 55 33 E1 3E 7E 80 FB 78 7E 49 9B 78 7D 2B 03 79 68 E7 00 41 3A 21 00 84 7C E7 00 34 7D E0 00 26 55 EF 1F FE 7F E4 FB 78 7E 25 8B 78 38 C0 00 10 54 E7 D9 7E 7E 43 93 78 4? ?? ?? ?? 80 FD 00 08 7C 75 1B 78 68 E7 00 41 7C E7 00 34 7F E4 FB 78 7E 43 93 78 38 A1 01 04 38 C0 00 10 54 E7 D9 7E 4? ?? ?? ?? 39 01 00 74 7F 95 40 40 7C 7F 1B 78 40 9D 00 54 38 15 FF FF 7F 88 00 40 7C E8 A8 50 7E AB AB 78 7C E9 03 A6 7C 69 1B 78 38 00 00 30 39 40 00 30 41 9D 0F 84 9C 0B FF FF 95 49 FF FC 42 00 FF F8 38 15 FF FF 7D 08 00 50 1D 08 FF FC 39 21 00 73 7C 00 48 50 39 08 FF FC 7E B5 02 14 7F FF 42 14 80 FD 00 08 7E A5 AB 78 7E 84 A3 78 68 E7 00 41 7C E7 00 34 38 C0 00 10 54 E7 D9 7E 7E 63 9B 78 4? ?? ?? ?? 80 FD 00 08 7C 7E 1B 78 68 E7 00 41 7C E7 00 34 7E 63 9B 78 7E 84 A3 78 7F E5 FB 78 38 C0 00 10 54 E7 D9 7E 4? ?? ?? ?? 39 01 00 68 7F 9E 40 40 7C 75 1B 78 40 9D 00 54 38 1E FF FF 7F 88 00 40 7C E8 F0 50 7F C9 F3 78 7C E9 03 A6 7C 6B 1B 78 38 00 00 30 39 40 00 30 41 9D 0E CC 9C 09 FF FF 95 4B FF FC 42 00 FF F8 38 1E FF FF 7D 08 00 50 1D 08 FF FC 39 21 00 67 7C 00 48 50 39 08 FF FC 7F DE 02 14 7E B5 42 14 80 01 00 30 3A 80 00 31 74 09 7F F0 40 82 00 08 3A 80 00 30 2F 90 00 00 41 9E 03 3C 2F 90 03 FE 21 10 03 FF 3A 60 00 01 40 9D 00 0C 39 10 FC 01 3A 60 00 00 2F 8F 00 00 40 9E 03 9C 80 01 01 00 2F 80 00 30 40 9E 00 18 39 21 01 00 84 09 FF FC 3A 31 FF FF 2F 80 00 30 41 9E FF F4 2F 96 FF FF 41 9E 07 0C 7C 1E 88 50 7F 96 00 00 7D 1F 43 78 2D 16 00 00 41 9C 04 10 3B 61 00 11 7F E3 FB 78 7F 64 DB 78 38 A0 00 0A 38 C0 00 00 4? ?? ?? ?? 3D 40 ?? ?? 3D 60 CC CC 7C 70 1B 78 3A 41 00 64 39 4A ?? ?? 61 6B CC CD 7C 1F 58 16 54 00 E8 FE 1D 20 00 0A 2F 80 00 00 7D 29 F8 50 7C 1F 03 78 55 20 10 3A 7C 0A 00 2E 94 12 FF FC 40 9E FF DC 2E 17 00 00 41 92 02 64 83 FD 00 0C 38 00 FF FC 3B 5A FF FE 7F 5B D0 50 7F 56 D0 50 7F 50 D2 14 7F 5A 02 14 40 89 05 D0 2D 98 00 00 40 8E 02 88 7F 23 CB 78 4? ?? ?? ?? 7F 43 D0 50 77 FF 04 00 3B 00 00 00 40 82 00 1C 80 1D 00 10 2F 80 00 30 41 9E 00 10 2F 9A 00 00 7F F8 FB 78 41 9D 03 9C 40 92 06 C0 80 1D 00 0C 74 09 02 00 40 82 07 28 74 0B 08 00 41 82 00 38 41 8E 02 D0 81 3C 00 5C 2F 89 00 00 41 9E 0B F4 81 69 00 10 80 09 00 14 7F 8B 00 40 40 9C 0B E4 38 0B 00 04 39 40 00 20 91 4B 00 00 90 09 00 10 3B 18 00 01 40 8E 02 6C 81 3C 00 14 80 1C 00 18 7F 89 00 40 40 9C 0C F4 38 09 00 01 39 60 00 30 99 69 00 00 90 1C 00 14 80 9D 00 08 38 84 00 17 41 8E 07 C0 81 3C 00 5C 2F 89 00 00 41 9E 0B 04 81 69 00 10 80 09 00 14 7F 8B 00 40 40 9C 0A F4 38 64 00 01 90 8B 00 00 38 0B 00 04 7C 63 00 34 90 09 00 10 54 63 D9 7E 2F 83 00 00 3B E0 FF FF 40 9E F9 1C 80 1D 00 0C 3B 18 00 02 74 07 04 00 40 82 00 3C 80 1D 00 10 2F 80 00 30 40 9E 00 30 2F 9A 00 00 40 9D 00 28 41 8E 09 34 7F 83 E3 78 38 80 00 30 7F 45 D3 78 4? ?? ?? ?? 7F 83 D0 00 3B E0 FF FF 40 9E F8 D8 7F 18 D2 14 41 8E 09 48 81 3C 00 5C 2F 89 00 00 41 9E 0A A8 81 69 00 10 80 09 00 14 7F 8B 00 40 40 9C 0A 98 38 0B 00 04 92 8B 00 00 90 09 00 10 3A F8 00 01 7E F8 BB 78 40 89 07 98 40 8E 08 8C 7F 23 CB 78 4? ?? ?? ?? 3B 39 FF FF 2F 83 00 00 7E F7 1A 14 41 9E 00 30 81 3C 00 14 80 1C 00 18 8C 99 00 01 7F 89 00 40 40 9C 0C 54 38 09 00 01 98 89 00 00 90 1C 00 14 3B 18 00 01 7F 98 B8 00 40 9E FF D8 40 89 07 58 7F FE 88 50 7F 9F B0 00 40 9D 00 08 7E DF B3 78 40 8E 07 28 3B 20 00 00 48 00 00 2C 81 3C 00 14 80 1C 00 18 7C 9E C8 AE 7F 89 00 40 40 9C 09 84 38 09 00 01 98 89 00 00 90 1C 00 14 3B 18 00 01 3B 39 00 01 7F 9F C8 00 40 9E FF D4 7F DE B2 14 7E 31 F0 51 40 81 07 00 41 8E 09 1C 7F 83 E3 78 38 80 00 30 7E 25 8B 78 4? ?? ?? ?? 7F 83 88 00 3B E0 FF FF 40 9E F7 D8 7F 18 1A 14 48 00 06 D8 83 FD 00 0C 77 E0 0A 00 7C 00 00 26 54 00 1F FE 68 00 00 01 20 00 FF FD 4B FF FD 90 2F 8F 00 00 3B E0 00 00 3A 60 00 00 41 9E 00 7C 2F 96 FF FF 7F D1 F3 78 2D 16 00 00 40 9E FD 08 3A C0 00 00 2D 16 00 00 7F D1 F3 78 4B FF FC F8 38 60 00 01 4B FF FD 80 54 C6 0F FE 55 7E 08 3C 7C DE F3 78 54 FF 40 2E 4B FF F9 6C 41 8E 03 A4 7F 83 E3 78 38 80 00 20 7F 65 DB 78 4? ?? ?? ?? 7F 83 D8 00 3B E0 FF FF 40 9E F7 48 7F 7F DB 78 4B FF F6 BC 7F CB FB 79 41 A2 FA AC 4B FF FA 58 7D 1F 43 78 4B FF FF 8C 39 00 03 FE 3A 60 00 01 4B FF FC 58 81 3C 00 5C 2F 89 00 00 41 9E 09 F8 81 69 00 10 80 09 00 14 7F 8B 00 40 40 9C 09 E8 38 0B 00 04 39 40 00 30 91 4B 00 00 90 09 00 10 4B FF FD 8C 81 3C 00 14 80 1C 00 18 7F 89 00 40 40 9C 09 08 38 09 00 01 39 60 00 20 99 69 00 00 3B 18 00 01 90 1C 00 14 4B FF FD 40 41 8E 03 8C 81 3C 00 5C 2F 89 00 00 41 9E 0A 68 81 69 00 10 80 09 00 14 7F 8B 00 40 40 9C 0A 58 38 0B 00 04 39 40 00 20 91 4B 00 00 90 09 00 10 3B FF 00 01 4B FF F6 24 31 4A FF FF 7D 29 01 D4 4B FF F9 F8 7D 3E B0 AE 2D 16 00 00 2B 89 00 38 41 9D 00 94 2F 89 00 38 41 9E 00 58 7D 1F 43 78 4B FF FB D8 38 CB FF AB 2F 86 00 00 39 6B FF CB 41 9C 03 E8 7F C6 34 30 39 60 00 00 7D 7E 5B 78 7C DF 33 78 4B FF F9 50 41 8E 04 2C 7F 83 E3 78 38 80 00 20 7F 45 D3 78 4? ?? ?? ?? 7F 83 D0 00 3B E0 FF FF 40 9E F6 20 7F 58 D3 78 4B FF FC 44 39 36 00 01 7F 80 48 00 41 9D 00 2C 40 89 03 28 7D 3E B2 14 89 29 FF FF 38 09 FF D0 20 00 00 09 7C 00 01 10 7C 00 00 D0 55 29 07 FE 7F 80 48 00 41 BE FF 7C 35 36 FF FF 41 80 03 08 7C 1E 48 AE 7D 5E 4A 14 2F 80 00 39 41 9E 03 7C 80 FB ?? ?? 7E C9 03 A6 81 7B ?? ?? 7C E7 12 14 7C 8B 12 14 38 A0 00 30 38 C0 00 30 48 00 00 28 55 20 10 3A 98 AA 00 00 39 29 FF FF 7C D5 01 2E 42 40 02 C4 7C 1E 48 AE 7D 5E 4A 14 2F 80 00 39 41 9E 03 38 81 67 00 00 2F 8B 00 00 41 9E 06 14 54 00 10 3A 7C 0B 00 2E 2F 80 00 65 41 9D FF C4 89 6A 00 00 55 29 10 3A 7D 1F 43 78 38 0B 00 01 98 0A 00 00 7D 75 48 2E 38 0B 00 01 7C 15 49 2E 4B FF FA BC 82 A1 00 20 38 A1 01 04 83 C1 00 24 38 C0 00 10 80 FD 00 08 56 B5 03 3E 7E AB F3 79 68 E7 00 41 7C E7 00 34 7F C4 F3 78 7D E0 00 26 55 EF 1F FE 54 E7 D9 7E 7E A3 AB 78 4? ?? ?? ?? 80 FD 00 08 3A 21 00 84 68 E7 00 41 7C E7 00 34 7C 7F 1B 78 7F C4 F3 78 7E A3 AB 78 7E 25 8B 78 38 C0 00 10 54 E7 D9 7E 4? ?? ?? ?? 39 61 00 D0 7F 9F 58 40 7C 7E 1B 78 7F F5 FB 78 40 9D 00 30 7C 69 1B 78 38 00 00 30 94 15 FF FC 7F 95 58 40 9C 09 FF FF 41 9D FF F4 7D 60 58 F8 7C 00 FA 14 54 00 F0 BE 7C 00 00 F8 7F DE 02 14 80 01 00 20 3A 80 00 31 74 07 7F F0 40 82 00 08 3A 80 00 30 54 09 65 7F 41 A2 FC D4 2F 89 03 FE 21 09 03 FF 3A 60 00 01 40 BD F9 A4 39 09 FC 01 3A 60 00 00 4B FF F9 98 41 8E 00 B8 7F 83 E3 78 38 80 00 20 7F 65 DB 78 4? ?? ?? ?? 7F 83 D8 00 40 9E F7 24 7F FF 1A 14 4B FF F4 44 77 E7 10 00 2D 98 00 00 41 A2 FA 40 4B FF FA 28 41 8E 00 A8 81 3C 00 5C 2F 89 00 00 41 9E 05 A0 81 69 00 10 80 09 00 14 7F 8B 00 40 40 9C 05 90 38 0B 00 04 39 40 00 2D 91 4B 00 00 3B FF 00 01 90 09 00 10 4B FF F3 90 41 8E 00 98 81 3C 00 5C 2F 89 00 00 41 9E 07 14 81 69 00 10 80 09 00 14 7F 8B 00 40 40 9C 07 04 38 0B 00 04 39 40 00 2B 91 4B 00 00 3B FF 00 01 90 09 00 10 4B FF F3 58 7F 83 E3 78 38 80 00 20 7F 65 DB 78 4? ?? ?? ?? 4B FF FC 60 7F 83 E3 78 38 80 00 20 7F 65 DB 78 4? ?? ?? ?? 4B FF FF 4C 7E DE 88 50 7D 1F 43 78 2D 16 00 00 4B FF F9 00 81 3C 00 14 80 1C 00 18 7F 89 00 40 40 9C 06 C0 38 09 00 01 39 60 00 2D 99 69 00 00 3B FF 00 01 90 1C 00 14 4B FF F2 F8 81 3C 00 14 80 1C 00 18 7F 89 00 40 40 9C 07 20 38 09 00 01 39 60 00 2B 99 69 00 00 3B FF 00 01 90 1C 00 14 4B FF F2 D0 81 3C 00 14 80 1C 00 18 7F 89 00 40 40 BC F5 E4 38 09 00 01 39 60 00 20 99 69 00 00 90 1C 00 14 4B FF FC 84 41 8E 00 E0 81 3C 00 5C 2F 89 00 00 41 9E 04 A0 81 69 00 10 80 09 00 14 7F 8B 00 40 40 9C 04 90 38 0B 00 04 39 40 00 2D 91 4B 00 00 90 09 00 10 4B FF F9 58 40 AA FC 78 72 8B 00 01 41 A2 FC 70 81 7B ?? ?? 7D 6B 12 14 81 2B 00 00 2F 89 00 00 41 9E 05 24 56 80 10 3A 7C 09 00 2E 2F 80 00 65 41 9D 00 DC 3A 94 00 01 56 94 06 3E 7D 1F 43 78 4B FF F8 18 41 8E 00 A4 81 3C 00 5C 2F 89 00 00 41 9E 05 F4 81 69 00 10 80 09 00 14 7F 8B 00 40 40 9C 05 E4 38 0B 00 04 39 40 00 2B 91 4B 00 00 90 09 00 10 4B FF F8 E4 20 CB 00 1F 57 C5 08 3C 7C A5 30 30 7F E6 5C 30 7C A6 33 78 7F CB 5C 30 4B FF FC 0C 80 1D 00 08 55 29 10 3A 7D 1F 43 78 7C 15 49 2E 80 1D 00 08 98 0A 00 00 4B FF F7 AC 81 3C 00 14 80 1C 00 18 7F 89 00 40 40 9C 03 64 38 09 00 01 39 60 00 2D 99 69 00 00 90 1C 00 14 4B FF F8 88 7F 83 E3 78 38 80 00 20 7F 45 D3 78 4? ?? ?? ?? 4B FF FB D8 81 3C 00 14 80 1C 00 18 7F 89 00 40 }
	condition:
		$1
}

rule file_296_0_0 {
	meta:
		name = "__sched_setscheduler"
		size = 16
		refs = "000c __syscall_error"
	strings:
		$1 = { 38 00 00 9C 44 00 00 02 4C A3 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_297_0_0 {
	meta:
		name = "_dl_runtime_resolve"
		size = 132
		refs = "0040 _dl_fixup"
	strings:
		$1 = { 94 21 FF C0 90 01 00 0C 90 61 00 10 90 81 00 14 7D 83 63 78 90 A1 00 18 7D 64 5B 78 90 C1 00 1C 7C 08 02 A6 90 E1 00 20 90 01 00 30 91 01 00 24 7C 00 00 26 91 21 00 28 91 41 00 2C 90 01 00 08 4? ?? ?? ?? 7C 69 03 A6 80 01 00 30 81 41 00 2C 81 21 00 28 7C 08 03 A6 81 01 00 24 80 01 00 08 80 E1 00 20 80 C1 00 1C 7C 0F F1 20 80 A1 00 18 80 81 00 14 80 61 00 10 80 01 00 0C 38 21 00 40 4E 80 04 20 }
	condition:
		$1
}

rule file_297_1_0 {
	meta:
		name = "_dl_prof_resolve"
		size = 212
		refs = "0070 _dl_profile_fixup"
	strings:
		$1 = { 94 21 FE C0 90 01 00 0C 90 61 00 10 90 81 00 14 7D 83 63 78 90 A1 00 18 7D 64 5B 78 90 C1 00 1C 7C A8 02 A6 90 E1 00 20 90 A1 01 34 91 01 00 24 7C 00 00 26 91 21 00 28 91 41 00 2C 90 01 00 08 D8 21 00 30 D8 41 00 38 D8 61 00 40 D8 81 00 48 D8 A1 00 50 D8 C1 00 58 D8 E1 00 60 D9 01 00 68 38 C1 00 10 38 E1 01 38 38 00 FF FF 90 07 00 00 4? ?? ?? ?? 7C 69 03 A6 80 01 01 34 81 41 00 2C 81 21 00 28 7C 08 03 A6 81 01 00 24 80 01 00 08 80 E1 00 20 80 C1 00 1C 7C 0F F1 20 80 A1 00 18 80 81 00 14 80 61 00 10 80 01 00 0C C8 21 00 30 C8 41 00 38 C8 61 00 40 C8 81 00 48 C8 A1 00 50 C8 C1 00 58 C8 E1 00 60 C9 01 00 68 38 21 01 40 4E 80 04 20 }
	condition:
		$1
}

rule file_298_0_0 {
	meta:
		name = "__difftime"
		size = 68
	strings:
		$1 = { 94 21 FF E0 3C 00 43 30 6C 63 80 00 6C 84 80 00 90 61 00 0C 3D 20 ?? ?? 90 01 00 08 90 81 00 14 90 01 00 10 C0 09 ?? ?? C8 21 00 08 C9 A1 00 10 38 21 00 20 FC 21 00 28 FC 0D 00 28 FC 21 00 28 4E 80 00 20 }
	condition:
		$1
}

rule file_299_0_0 {
	meta:
		name = "__correctly_grouped_prefixmb"
		size = 668
		refs = "0048 strlen"
	strings:
		$1 = { 2C 06 00 00 94 21 FF C0 7C 08 02 A6 93 E1 00 3C 7C 7F 1B 78 90 01 00 44 93 01 00 20 93 21 00 24 93 41 00 28 93 61 00 2C 93 81 00 30 93 A1 00 34 93 C1 00 38 41 82 00 E0 7C A3 2B 78 90 81 00 08 90 A1 00 0C 90 C1 00 10 4? ?? ?? ?? 80 81 00 08 80 A1 00 0C 7F 84 F8 40 80 C1 00 10 40 9D 00 AC 3B A3 FF FF 3B 83 FF FD 3B C5 00 01 39 04 FF FF 7F 9F 40 40 41 9D 00 A0 88 65 00 00 7C E4 E2 14 48 00 00 14 39 08 FF FF 7F 9F 40 40 38 E7 FF FF 41 9D 00 84 88 07 00 01 7F 80 18 00 40 9E FF E8 89 9E 00 00 2F 8C 00 00 41 9E 00 34 88 07 00 00 7F C9 F3 78 7C EB 3B 78 7F 80 60 00 41 BE 00 14 4B FF FF C4 8D 4B FF FF 7F 8A 00 00 40 BE FF B8 8C 09 00 01 2F 80 00 00 40 9E FF EC 7F 9F 40 40 41 9D 00 34 88 06 00 00 7D 28 20 50 30 00 00 01 7F 89 00 00 41 9E 00 5C 40 9D 00 50 7C 88 02 14 7F 9F 20 40 41 9C FF 68 7F 84 F8 40 40 9C 00 08 7F E4 FB 78 80 01 00 44 7C 83 23 78 83 01 00 20 7C 08 03 A6 83 21 00 24 83 41 00 28 83 61 00 2C 83 81 00 30 83 A1 00 34 83 C1 00 38 83 E1 00 3C 38 21 00 40 4E 80 00 20 7D 04 43 78 4B FF FF B4 2F 03 00 00 3B 68 FF FF 7F 78 DB 78 7C D9 33 78 8B 59 00 01 38 19 00 01 2F 9A 00 00 40 9E 00 84 8B 59 00 00 7F 67 DB 78 2F 9A 00 FF 41 9E 00 84 7F 9F D8 40 41 9D 01 10 7D 08 EA 14 41 9A 01 00 8C 08 FF FF 7F 80 18 00 40 9E 00 C0 7F CB F3 78 7D 09 43 78 7D 80 63 78 48 00 00 14 8D 49 FF FF 7F 8A 00 00 40 9E 00 A4 8C 0B 00 01 2F 80 00 00 40 9E FF EC 7C E8 3B 78 7F 9F 38 40 41 9D 00 9C 7C E7 D8 50 7F 87 D0 00 40 9E 00 9C 8B 59 00 01 3B 68 FF FF 38 19 00 01 2F 9A 00 00 41 BE FF 84 2F 9A 00 FF 7C 19 03 78 7F 67 DB 78 40 9E FF 84 7F 9F D8 40 41 BD FF 10 7D 08 EA 14 41 9A 00 38 8C 08 FF FF 7F 80 18 00 40 9E 00 64 7F CB F3 78 7D 09 43 78 7D 80 63 78 48 00 00 14 8D 49 FF FF 7F 8A 00 00 40 9E 00 48 8C 0B 00 01 2F 80 00 00 40 9E FF EC 7F 9F 38 40 7C E8 3B 78 41 BD FE C8 3B 67 FF FF 4B FF FF 0C 38 E7 FF FF 7F 9F 38 40 40 9D FF 30 7C E8 3B 78 7D 08 D8 50 7F 88 D0 00 40 BD FE A4 7F 04 C3 78 4B FF FE 88 38 E7 FF FF 7F 9F 38 40 40 9D FF 8C 4B FF FE 8C 7F 68 DB 78 4B FF FF 38 7F 67 DB 78 4B FF FF CC }
	condition:
		$1
}

rule file_301_0_0 {
	meta:
		name = "get_opt_end"
		size = 88
	strings:
		$1 = { 7F 84 28 40 38 00 FF FF 40 9C 00 1C 89 24 00 00 2F 89 00 00 40 9E 00 18 38 84 00 01 90 83 00 00 38 00 00 00 7C 03 03 78 4E 80 00 20 39 24 00 02 7F 85 48 40 41 9C FF F0 89 24 00 01 39 29 00 02 7C 84 4A 14 7F 85 20 40 41 BC FF DC 90 83 00 00 38 00 00 00 4B FF FF D0 }
	condition:
		$1
}

rule file_301_1_0 {
	meta:
		name = "add_pad"
		size = 196
		refs = "0070 memset"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 2F 84 00 01 90 01 00 14 81 63 00 00 93 C1 00 08 7C 7E 1B 78 39 2B FF F4 93 E1 00 0C 7C 9F 23 78 41 9E 00 70 2F 84 00 00 40 9E 00 24 80 01 00 14 7F EB FA 14 93 FE 00 00 7C 08 03 A6 83 C1 00 08 83 E1 00 0C 38 21 00 10 4E 80 00 20 7D 23 4A 14 38 A4 FF FE 38 00 00 01 98 A9 00 0D 38 69 00 0E 98 09 00 0C 38 80 00 00 4? ?? ?? ?? 80 01 00 14 81 7E 00 00 7C 08 03 A6 7F EB FA 14 93 FE 00 00 83 C1 00 08 83 E1 00 0C 38 21 00 10 4E 80 00 20 38 00 00 00 7D 23 4A 14 98 09 00 0C 7F EB FA 14 80 01 00 14 93 FE 00 00 7C 08 03 A6 83 C1 00 08 83 E1 00 0C 38 21 00 10 4E 80 00 20 }
	condition:
		$1
}

rule file_301_2_0 {
	meta:
		name = "option_alloc"
		size = 316
		refs = "0128 __assert_fail"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 90 01 00 24 38 05 FF FF 2B 80 00 01 93 C1 00 18 7C 9E 23 78 93 E1 00 1C 7C 7F 1B 78 93 A1 00 14 40 9D 00 34 2F 85 00 04 41 9E 00 2C 2F 85 00 08 38 60 00 00 41 9E 00 20 80 01 00 24 83 A1 00 14 7C 08 03 A6 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 2B 86 00 07 41 9D 00 8C 81 3F 00 00 35 69 FF F4 41 82 00 C0 7D 6B 00 38 7C AB 28 50 7C A0 00 38 7C 80 32 14 7F E3 FB 78 4B FF FE B9 83 BF 00 00 7F E3 FB 78 7F DE EA 14 20 9E 00 0C 93 DF 00 00 54 84 07 7E 4B FF FE 9D 81 3F 00 00 38 09 FF F4 70 09 00 07 40 82 00 5C 54 09 E8 FE 38 09 FF FF 2F 80 00 FF 38 60 00 00 41 BD FF 7C 98 1F 00 0D 7C 7F EA 14 80 01 00 24 83 A1 00 14 7C 08 03 A6 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 80 01 00 24 38 60 00 00 83 A1 00 14 7C 08 03 A6 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 00 D5 38 C6 ?? ?? 4? ?? ?? ?? 39 29 00 02 91 3F 00 00 39 60 00 02 4B FF FF 38 }
	condition:
		$1
}

rule file_301_3_0 {
	meta:
		name = "inet6_option_space"
		size = 16
	strings:
		$1 = { 38 63 00 09 54 63 00 38 38 63 00 0C 4E 80 00 20 }
	condition:
		$1
}

rule file_301_4_0 {
	meta:
		name = "inet6_option_init"
		size = 60
	strings:
		$1 = { 2F 85 00 36 7C 69 1B 78 40 9E 00 24 38 00 00 0C 90 A9 00 08 38 60 00 00 90 09 00 00 38 00 00 29 90 09 00 04 91 24 00 00 4E 80 00 20 2F 85 00 3B 38 60 FF FF 4C BE 00 20 4B FF FF D4 }
	condition:
		$1
}

rule file_301_5_0 {
	meta:
		name = "inet6_option_append"
		size = 112
		refs = "004c memcpy"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 93 C1 00 08 7C 9E 23 78 93 E1 00 0C 3B E0 00 01 90 01 00 14 88 04 00 00 2F 80 00 00 41 9E 00 0C 8B E4 00 01 3B FF 00 02 7F E4 FB 78 4B FF FE 45 38 00 FF FF 2F 83 00 00 41 9E 00 14 7F C4 F3 78 7F E5 FB 78 4? ?? ?? ?? 38 00 00 00 7C 03 03 78 80 01 00 14 83 C1 00 08 7C 08 03 A6 83 E1 00 0C 38 21 00 10 4E 80 00 20 }
	condition:
		$1
}

rule file_301_7_0 {
	meta:
		name = "inet6_option_next"
		size = 244
	strings:
		$1 = { 94 21 FF D0 7C 08 02 A6 90 01 00 34 80 03 00 04 93 C1 00 28 7C 9E 23 78 2F 80 00 29 93 E1 00 2C 3B E0 FF FF 93 81 00 20 93 A1 00 24 41 9E 00 28 80 01 00 34 7F E3 FB 78 83 81 00 20 7C 08 03 A6 83 A1 00 24 83 C1 00 28 83 E1 00 2C 38 21 00 30 4E 80 00 20 80 03 00 08 2F 80 00 36 41 9E 00 0C 2F 80 00 3B 40 9E FF CC 80 03 00 00 3B E0 FF FF 2B 80 00 0D 40 9D FF BC 89 23 00 0D 39 29 00 01 55 29 18 38 39 69 00 0C 7F 80 58 40 41 BC FF A4 80 9E 00 00 7D 23 4A 14 3B 89 00 0C 2F 84 00 00 40 9E 00 28 38 83 00 0E 7C 3D 0B 78 94 9D 00 08 90 9E 00 00 7F A3 EB 78 7F 85 E3 78 4B FF FC 2D 7C 7F 1B 78 4B FF FF 6C 38 63 00 0E 7F 84 18 40 41 9C FF 60 3B A1 00 08 7F A3 EB 78 7F 85 E3 78 4B FF FC 09 2F 83 00 00 40 BE FF 48 80 81 00 08 4B FF FF C0 }
	condition:
		$1
}

rule file_301_8_0 {
	meta:
		name = "inet6_option_find"
		size = 292
	strings:
		$1 = { 94 21 FF D0 7C 08 02 A6 90 01 00 34 80 03 00 04 93 A1 00 24 7C 9D 23 78 2F 80 00 29 93 C1 00 28 7C BE 2B 78 93 E1 00 2C 3B E0 FF FF 93 61 00 1C 93 81 00 20 41 9E 00 2C 80 01 00 34 7F E3 FB 78 83 61 00 1C 7C 08 03 A6 83 81 00 20 83 A1 00 24 83 C1 00 28 83 E1 00 2C 38 21 00 30 4E 80 00 20 80 03 00 08 2F 80 00 36 41 9E 00 0C 2F 80 00 3B 40 9E FF C8 80 03 00 00 3B E0 FF FF 2B 80 00 0D 40 9D FF B8 89 23 00 0D 39 29 00 01 55 29 18 38 39 69 00 0C 7F 80 58 40 41 BC FF A0 80 9D 00 00 7D 23 4A 14 3B 69 00 0C 2F 84 00 00 41 9E 00 5C 38 63 00 0E 7F 84 18 40 41 9C FF 80 3B 81 00 08 7F 83 E3 78 7F 65 DB 78 4B FF FB 2D 2F 83 00 00 40 9E FF 68 48 00 00 10 88 1F 00 00 7F 80 F0 00 41 9E 00 38 83 E1 00 08 7F 83 E3 78 7F 65 DB 78 7F E4 FB 78 4B FF FB 01 2F 83 00 00 41 9E FF DC 3B E0 FF FF 4B FF FF 34 38 63 00 0E 7C 3C 0B 78 94 7C 00 08 4B FF FF D0 93 FD 00 00 3B E0 00 00 4B FF FF 18 }
	condition:
		$1
}

rule file_302_0_0 {
	meta:
		name = "wcsrchr"
		size = 60
	strings:
		$1 = { 7C 69 1B 78 80 09 00 00 38 60 00 00 7F 00 20 00 2F 80 00 00 41 9A 00 1C 4D 9E 00 20 39 29 00 04 80 09 00 00 7F 00 20 00 2F 80 00 00 40 9A FF EC 7D 23 4B 78 4D 9E 00 20 4B FF FF E4 }
	condition:
		$1
}

rule file_303_0_0 {
	meta:
		name = "__getcontext"
		size = 32
		refs = "001c __syscall_error"
	strings:
		$1 = { 38 80 00 00 38 A0 04 A0 38 00 00 F9 44 00 00 02 41 83 00 0C 38 60 00 00 4E 80 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_304_0_0 {
	meta:
		name = "splice"
		size = 156
		refs = "0018 __syscall_error 0040 __libc_enable_asynccancel 0078 __libc_disable_asynccancel"
	strings:
		$1 = { 81 42 8B 60 2C 0A 00 00 40 82 00 14 38 00 01 1B 44 00 00 02 4C A3 00 20 4? ?? ?? ?? 94 21 FF D0 7D 28 02 A6 91 21 00 34 91 01 00 28 90 E1 00 24 90 C1 00 20 90 A1 00 1C 90 81 00 18 90 61 00 14 4? ?? ?? ?? 90 61 00 10 81 01 00 28 80 E1 00 24 80 C1 00 20 80 A1 00 1C 80 81 00 18 80 61 00 14 38 00 01 1B 44 00 00 02 7C 00 00 26 90 61 00 08 90 01 00 0C 80 61 00 10 4? ?? ?? ?? 80 81 00 34 80 01 00 0C 80 61 00 08 7C 88 03 A6 7C 0F F1 20 38 21 00 30 4C A3 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_304_1_0 {
	meta:
		name = "__splice_nocancel"
		size = 16
		refs = "000c __syscall_error"
	strings:
		$1 = { 38 00 01 1B 44 00 00 02 4C A3 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_305_0_0 {
	meta:
		name = "__wcsrtombs"
		size = 800
		refs = "0052 _GLOBAL_OFFSET_TABLE_ 005a _nl_current_LC_CTYPE 00b8 __wcsnlen 00cc _dl_mcount_wrapper_check 0168 __errno_location 01c0 __wcslen 0278 __assert_fail 02b6 _nl_C_LC_CTYPE 02c8 __wcsmbs_load_conv 02f6 __wcsmbs_gconv_fcts_c"
	strings:
		$1 = { 2C 06 00 00 94 21 FE 90 7C 08 02 A6 39 20 00 00 93 41 01 58 7C BA 2B 78 90 01 01 74 38 00 00 01 93 61 01 5C 7C 9B 23 78 93 81 01 60 7C 7C 1B 78 93 21 01 54 93 A1 01 64 93 C1 01 68 93 E1 01 6C 91 21 00 24 90 01 00 28 90 01 00 20 41 82 02 3C 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 81 29 00 00 83 E9 00 00 39 20 00 00 90 C1 00 2C 80 1F 00 14 91 21 00 38 2F 80 00 00 41 9E 02 38 7C 09 03 78 83 A9 00 08 80 1D 00 00 83 FD 00 14 2F 80 00 00 41 9E 00 0C 80 02 8F F4 7F FF 02 78 2F 9C 00 00 41 9E 01 10 83 DB 00 00 7F 44 D3 78 7F 5C D2 14 7F C3 F3 78 4? ?? ?? ?? 93 81 00 18 7C 79 1B 78 7F E3 FB 78 93 41 00 1C 4? ?? ?? ?? 38 D9 00 01 54 C6 10 3A 7F E9 03 A6 7C DE 32 14 39 20 00 00 7F A3 EB 78 38 81 00 18 7F 65 DB 78 38 E0 00 00 39 01 00 0C 39 40 00 01 4E 80 04 21 81 21 00 18 2C 03 00 00 7F DC 48 50 40 82 00 9C 88 09 FF FF 2F 80 00 00 40 9E 00 24 7F 9C 48 00 41 9E 01 E0 81 21 00 2C 80 09 00 00 2F 80 00 00 40 9E 01 A4 90 1B 00 00 3B DE FF FF 2B 83 00 07 41 9D 01 54 3C 00 8F 00 7C 09 18 30 2F 89 00 00 40 9C 01 44 41 82 00 24 2F 83 00 05 41 9E 00 1C 2F 83 00 04 41 9E 00 14 4? ?? ?? ?? 38 00 00 54 90 03 00 00 3B C0 FF FF 80 01 01 74 7F C3 F3 78 83 21 01 54 7C 08 03 A6 83 41 01 58 83 61 01 5C 83 81 01 60 83 A1 01 64 83 C1 01 68 83 E1 01 6C 38 21 01 70 4E 80 00 20 2F 83 00 04 40 9E FF 90 4B FF FF 60 83 DB 00 00 3B 81 00 3C 7F C3 F3 78 4? ?? ?? ?? 81 21 00 2C 38 01 00 10 81 49 00 04 3B 63 00 01 81 29 00 00 57 7B 10 3A 90 01 00 2C 38 01 01 3C 7F 7E DA 14 91 21 00 10 91 41 00 14 90 01 00 1C 93 C1 00 08 3B C0 00 00 7F E3 FB 78 93 81 00 18 4? ?? ?? ?? 39 20 00 00 7F A3 EB 78 7F E9 03 A6 38 81 00 18 38 A1 00 08 7F 66 DB 78 38 E0 00 00 39 01 00 0C 39 40 00 01 4E 80 04 21 81 21 00 18 2F 83 00 05 7C 1C 48 50 7F DE 02 14 41 9E FF BC 2C 03 00 00 40 82 00 34 88 09 FF FF 3B DE FF FF 2F 80 00 00 41 9E FE E4 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 00 64 38 C6 ?? ?? 4? ?? ?? ?? 2F 83 00 04 40 9E FE BC 4B FF FF C8 3C C0 ?? ?? 38 C6 ?? ?? 4B FF FD C0 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 00 8C 38 C6 ?? ?? 4? ?? ?? ?? 3D 20 ?? ?? 38 09 ?? ?? 7F 9F 00 00 41 9E 00 34 7F E3 FB 78 4? ?? ?? ?? 80 1F 00 14 4B FF FD B0 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 00 81 38 C6 ?? ?? 4? ?? ?? ?? 3D 20 ?? ?? 38 09 ?? ?? 4B FF FD 84 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 00 80 38 C6 ?? ?? 4? ?? ?? ?? }
	condition:
		$1
}

rule file_306_0_0 {
	meta:
		name = "__brk"
		size = 68
		refs = "001e __curbrk 0040 __syscall_error"
	strings:
		$1 = { 7C 08 02 A6 94 21 FF F0 90 61 00 08 90 01 00 14 38 00 00 2D 44 00 00 02 80 C1 00 08 3C 80 ?? ?? 90 64 ?? ?? 80 01 00 14 7C 06 18 40 38 21 00 10 7C 08 03 A6 38 60 00 00 4C A1 00 20 38 60 00 0C 4? ?? ?? ?? }
	condition:
		$1
}

rule file_307_0_0 {
	meta:
		name = "gethostent"
		size = 264
		refs = "0052 _GLOBAL_OFFSET_TABLE_ 005a __libc_h_errno 0062 __gethostent_r 007c __nss_getent 0084 __errno_location 00dc __lll_lock_wait_private"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 39 60 00 01 93 61 00 0C 3F 60 ?? ?? 39 20 00 00 93 81 00 10 3B 9B ?? ?? 90 01 00 24 93 A1 00 14 93 C1 00 18 93 E1 00 1C 7C 00 E0 28 7C 00 48 00 40 82 00 0C 7D 60 E1 2D 40 A2 FF F0 4C 00 01 2C 2F 80 00 00 40 9E 00 8C 3D 00 ?? ?? 39 08 ?? ?? 81 08 ?? ?? 3C A0 ?? ?? 3C 60 ?? ?? 38 9C 00 04 38 A5 ?? ?? 38 C0 04 00 38 FC 00 18 7D 08 12 14 38 63 ?? ?? 4? ?? ?? ?? 7C 7E 1B 78 4? ?? ?? ?? 7C 7F 1B 78 83 A3 00 00 38 00 00 00 7C 00 04 AC 7D 20 E0 28 7C 00 E1 2D 40 A2 FF F8 2F 89 00 01 41 9D 00 3C 80 01 00 24 7F C3 F3 78 93 BF 00 00 7C 08 03 A6 83 61 00 0C 83 81 00 10 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 7F 83 E3 78 4? ?? ?? ?? 4B FF FF 70 80 82 8B 68 38 00 00 DD 7F 83 E3 78 60 84 00 01 38 A0 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF A8 }
	condition:
		$1
}

rule file_308_0_0 {
	meta:
		name = "putw"
		size = 72
		refs = "0024 _IO_fwrite"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 7C 86 23 78 7C 29 0B 78 90 01 00 14 38 80 00 04 94 69 00 08 38 A0 00 01 7D 23 4B 78 4? ?? ?? ?? 2F 83 00 00 38 60 00 00 40 BE 00 08 38 60 FF FF 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_309_0_0 {
	meta:
		name = "__wctype_l"
		size = 240
		refs = "0030 strlen 0078 memcmp"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 93 E1 00 1C 7C 9F 23 78 93 41 00 08 93 61 00 0C 7C 7B 1B 78 93 81 00 10 93 A1 00 14 3B A0 00 00 90 01 00 24 93 C1 00 18 4? ?? ?? ?? 7C 7C 1B 78 83 5F 00 00 83 FA 00 4C 48 00 00 18 3B DE 00 01 7C 1F F0 EE 3B BD 00 01 2F 80 00 00 41 9E 00 70 7F E3 FB 78 4? ?? ?? ?? 7F 9C 18 00 7C 7E 1B 78 40 9E FF DC 7F E4 FB 78 7F 63 DB 78 7F 85 E3 78 4? ?? ?? ?? 2F 83 00 00 40 9E FF C4 80 1A 00 68 83 61 00 0C 7F BD 02 14 83 81 00 10 38 1D 00 08 83 C1 00 18 54 00 10 3A 83 A1 00 14 7F 5A 02 14 80 01 00 24 80 7A 00 04 7C 08 03 A6 83 41 00 08 83 E1 00 1C 38 21 00 20 4E 80 00 20 80 01 00 24 38 60 00 00 83 41 00 08 7C 08 03 A6 83 61 00 0C 83 81 00 10 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 }
	condition:
		$1
}

rule file_310_0_0 {
	meta:
		name = "known_compare"
		size = 56
		refs = "0024 strcmp"
	strings:
		$1 = { 7F 83 20 00 94 21 FF F0 7C 08 02 A6 7C 69 1B 78 38 60 00 00 90 01 00 14 41 9E 00 10 80 69 00 00 80 84 00 00 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_310_1_0 {
	meta:
		name = "nss_parse_service_list"
		size = 1428
		refs = "0012 _GLOBAL_OFFSET_TABLE_ 001e __libc_tsd_CTYPE_B 007e _nl_current_LC_CTYPE 0124 malloc 0140 mempcpy 029c __strncasecmp"
	strings:
		$1 = { 94 21 FF A0 7C 08 02 A6 7D 80 00 26 93 21 00 44 3F 20 ?? ?? 3B 39 ?? ?? 90 01 00 64 81 39 ?? ?? 7D 29 12 14 92 E1 00 3C 38 00 00 00 7C 37 0B 78 92 21 00 24 3E 20 ?? ?? 3A 31 ?? ?? 92 41 00 28 3E 40 ?? ?? 3A 52 ?? ?? 92 61 00 2C 3E 60 ?? ?? 3A 73 ?? ?? 92 81 00 30 3E 80 ?? ?? 3A 94 ?? ?? 92 A1 00 34 3E A0 ?? ?? 3A B5 ?? ?? 92 C1 00 38 3E C0 ?? ?? 3A D6 ?? ?? 93 01 00 40 83 19 ?? ?? 93 81 00 50 7C 7C 1B 78 93 41 00 48 93 61 00 4C 93 A1 00 54 93 C1 00 58 93 E1 00 5C 91 81 00 20 81 29 00 00 94 17 00 08 2F 89 00 00 41 9E 04 AC 88 1C 00 00 54 0B 08 3C 7D 69 5A 2E 71 67 00 20 40 82 01 08 2F 80 00 00 41 9E 03 A8 7D 58 12 14 81 79 ?? ?? 81 0A 00 00 7F 9E E3 78 7D 4B 12 14 48 00 00 14 41 9E 00 30 8C 1E 00 01 2F 80 00 00 41 9E 00 24 2F 89 00 00 41 9E 04 38 88 1E 00 00 54 0B 08 3C 7D 69 5A 2E 2F 80 00 5B 71 60 00 20 41 82 FF D4 7F 9C F0 00 41 9E 03 58 7F FC F0 50 38 7F 00 25 4? ?? ?? ?? 7C 7D 1B 79 41 82 03 44 38 7D 00 24 90 7D 00 20 7F 84 E3 78 7F E5 FB 78 4? ?? ?? ?? 38 00 00 00 98 03 00 00 81 39 ?? ?? 38 00 00 00 39 60 00 01 90 1D 00 04 7D 29 12 14 7D 58 12 14 90 1D 00 08 7D 28 4B 78 90 1D 00 0C 91 7D 00 10 91 7D 00 14 90 1D 00 18 90 1D 00 1C 90 1D 00 00 81 29 00 00 81 4A 00 00 48 00 00 08 3B DE 00 01 2F 89 00 00 41 9E 03 84 88 1E 00 00 54 0B 08 3C 7D 69 5A 2E 71 67 00 20 40 82 FF E4 2F 80 00 5B 41 9E 00 1C 93 B7 00 00 7F DC F3 78 7F B7 EB 78 4B FF FE E4 3B 9C 00 01 4B FF FE DC 7D 38 12 14 81 59 ?? ?? 81 09 00 00 7D 4A 12 14 8C 1E 00 01 2F 80 00 00 41 9E 00 20 81 2A 00 00 2F 89 00 00 41 9E 03 88 54 0B 08 3C 7D 29 5A 2E 71 2B 00 20 40 82 FF DC 83 79 ?? ?? 7F 7B 12 14 7F 98 12 14 68 09 00 21 7D 29 00 34 55 29 D9 7E 2E 09 00 00 41 92 00 08 8C 1E 00 01 2F 80 00 00 41 9E 02 40 81 3B 00 00 7F DF F3 78 81 5C 00 00 48 00 00 18 41 9E 00 38 41 9A 00 34 8C 1F 00 01 2F 80 00 00 41 9E 00 28 2F 89 00 00 41 9E 02 6C 88 1F 00 00 54 0B 08 3C 7D 69 5A 2E 2F 80 00 3D 2F 00 00 5D 71 67 00 20 41 82 FF CC 7C 1E F8 50 2F 80 00 07 41 9E 01 94 2F 80 00 08 40 9E 01 E4 7F C3 F3 78 7E A4 AB 78 38 A0 00 08 4? ?? ?? ?? 3B 40 00 00 2F 83 00 00 41 9E 00 20 7F C3 F3 78 7E 84 A3 78 38 A0 00 08 4? ?? ?? ?? 2F 83 00 00 40 9E 01 B0 3B 40 FF FE 81 3B 00 00 81 5C 00 00 48 00 00 08 3B FF 00 01 2F 89 00 00 41 9E 02 2C 88 1F 00 00 54 0B 08 3C 7D 69 5A 2E 71 68 00 20 40 82 FF E4 2F 80 00 3D 40 9E 01 78 81 1C 00 00 2F 89 00 00 3B FF 00 01 41 9E 02 3C 88 1F 00 00 54 0B 06 3E 55 6A 08 3C 7D 49 52 2E 71 47 00 20 40 82 FF E0 2F 8B 00 00 7F E3 FB 78 41 9E 01 44 81 5C 00 00 48 00 00 18 41 9E 00 38 41 9A 00 34 8C 1F 00 01 70 08 00 FF 41 82 00 28 2F 89 00 00 41 9E 01 A0 54 00 06 3E 54 0B 08 3C 7D 69 5A 2E 2F 80 00 3D 2F 00 00 5D 71 67 00 20 41 82 FF CC 7C 03 F8 50 2F 80 00 06 7F FE FB 78 41 9E 00 D8 2F 80 00 08 40 9E 00 EC 7E C4 B3 78 38 A0 00 08 4? ?? ?? ?? 2F 83 00 00 40 9E 00 D8 38 00 00 00 41 92 00 64 39 3A 00 02 55 29 10 3A 7D 3D 4A 14 81 69 00 04 90 1D 00 04 90 1D 00 08 90 1D 00 0C 90 1D 00 10 91 69 00 04 81 3B 00 00 81 5C 00 00 48 00 00 08 3B DE 00 01 2F 89 00 00 41 9E 01 00 88 1E 00 00 54 0B 08 3C 7D 69 5A 2E 71 68 00 20 40 82 FF E4 2F 80 00 5D 40 9E FE 1C 3B DE 00 01 4B FF FD B8 39 3A 00 02 55 29 10 3A 7D 3D 4A 14 90 09 00 04 4B FF FF B4 7F C3 F3 78 7E 64 9B 78 38 A0 00 07 4? ?? ?? ?? 3B 40 00 01 2F 83 00 00 41 BE FE 98 7F C3 F3 78 7E 24 8B 78 38 A0 00 07 4? ?? ?? ?? 2F 83 00 00 40 9E 00 28 3B 40 FF FF 4B FF FE 78 7E 44 93 78 38 A0 00 06 4? ?? ?? ?? 2F 83 00 00 40 9E 00 0C 38 00 00 01 4B FF FF 34 80 01 00 64 81 81 00 20 7C 08 03 A6 80 61 00 08 82 21 00 24 7D 80 81 20 82 41 00 28 82 61 00 2C 82 81 00 30 82 A1 00 34 82 C1 00 38 82 E1 00 3C 83 01 00 40 83 21 00 44 83 41 00 48 83 61 00 4C 83 81 00 50 83 A1 00 54 83 C1 00 58 83 E1 00 5C 38 21 00 60 4E 80 00 20 81 2A 00 00 81 29 00 24 39 29 01 00 91 3B 00 00 4B FF FD 88 81 2A 00 00 81 29 00 24 39 29 01 00 91 3B 00 00 4B FF FE F4 81 2A 00 00 81 29 00 24 39 29 01 00 91 3B 00 00 88 1F 00 00 4B FF FE 50 81 2A 00 00 81 29 00 24 39 29 01 00 91 3B 00 00 4B FF FD C8 81 2A 00 00 81 29 00 24 39 29 01 00 91 28 00 00 4B FF FC 70 81 28 00 00 81 29 00 24 39 29 01 00 91 2A 00 00 4B FF FB BC 81 28 00 00 81 29 00 24 39 29 01 00 91 3B 00 00 4B FF FD B8 7D 38 12 14 81 29 00 00 81 79 ?? ?? 7D 6B 12 14 81 29 00 00 81 29 00 24 39 29 01 00 91 2B 00 00 4B FF FB 38 81 28 00 00 81 29 00 24 39 29 01 00 91 2A 00 00 88 1E 00 00 4B FF FC 68 }
	condition:
		$1
}

rule file_310_2_0 {
	meta:
		name = "__nss_database_lookup"
		size = 1152
		refs = "0150 strcmp 0224 _IO_new_fopen 0258 malloc 026e _GLOBAL_OFFSET_TABLE_ 027a __libc_tsd_CTYPE_B 0286 _nl_current_LC_CTYPE 02ac __strchrnul 02dc __getline 03ac strlen 03dc memcpy 0408 free 0410 _IO_new_fclose 0420 __lll_lock_wait_private"
	strings:
		$1 = { 94 21 FF 90 7C 08 02 A6 7D 80 00 26 39 60 00 01 93 81 00 60 3F 80 ?? ?? 39 20 00 00 93 E1 00 6C 3B FC ?? ?? 93 21 00 54 7C D9 33 78 93 41 00 58 7C BA 2B 78 93 61 00 5C 7C 9B 23 78 93 A1 00 64 7C 7D 1B 78 93 C1 00 68 3B DF 00 04 90 01 00 74 91 C1 00 28 91 E1 00 2C 92 01 00 30 92 21 00 34 92 41 00 38 92 61 00 3C 92 81 00 40 92 A1 00 44 92 C1 00 48 92 E1 00 4C 93 01 00 50 91 81 00 24 7C 00 F0 28 7C 00 48 00 40 82 00 0C 7D 60 F1 2D 40 A2 FF F0 4C 00 01 2C 2F 80 00 00 40 9E 03 80 82 F9 00 00 2F 97 00 00 41 9E 00 84 38 00 00 00 7C 00 04 AC 7D 20 F0 28 7C 00 F1 2D 40 A2 FF F8 2F 89 00 01 41 9D 03 70 80 01 00 74 38 60 00 00 81 81 00 24 7C 08 03 A6 81 C1 00 28 81 E1 00 2C 7D 80 81 20 82 01 00 30 82 21 00 34 82 41 00 38 82 61 00 3C 82 81 00 40 82 A1 00 44 82 C1 00 48 82 E1 00 4C 83 01 00 50 83 21 00 54 83 41 00 58 83 61 00 5C 83 81 00 60 83 A1 00 64 83 C1 00 68 83 E1 00 6C 38 21 00 70 4E 80 00 20 83 1C ?? ?? 2F 98 00 00 41 9E 00 E0 83 18 00 00 2E 18 00 00 41 92 00 30 7F 1C C3 78 80 9C 00 08 7F A3 EB 78 4? ?? ?? ?? 2F 83 00 00 40 9E 00 0C 80 1C 00 04 90 19 00 00 83 9C 00 00 2F 9C 00 00 40 9E FF DC 80 19 00 00 2F 80 00 00 41 9E 00 44 38 00 00 00 7C 00 04 AC 7D 20 F0 28 7C 00 F1 2D 40 A2 FF F8 2F 89 00 01 40 9D FF 34 80 82 8B 68 38 00 00 DD 7F C3 F3 78 60 84 00 01 38 A0 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF 10 2F 9B 00 00 41 9E 00 3C 41 92 00 38 80 98 00 08 7F 63 DB 78 4? ?? ?? ?? 2F 83 00 00 40 9E 00 0C 80 18 00 04 90 19 00 00 83 18 00 00 2F 98 00 00 40 9E FF DC 80 19 00 00 2F 80 00 00 40 BE FF 84 2F 9A 00 00 41 9E 00 3C 7F 43 D3 78 4B FF F8 65 90 79 00 00 4B FF FF 6C 3C 60 ?? ?? 3C 80 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 4? ?? ?? ?? 7C 76 1B 79 40 82 00 1C 38 00 00 00 90 1C ?? ?? 4B FF FF B8 3F 40 ?? ?? 3B 5A ?? ?? 4B FF FF C0 80 16 00 00 38 60 00 08 60 00 80 00 90 16 00 00 4? ?? ?? ?? 2F 83 00 00 7C 72 1B 78 7C 78 1B 78 41 BE FF C8 3D 20 ?? ?? 92 E3 00 00 39 29 ?? ?? 82 29 ?? ?? 92 E3 00 04 7C 34 0B 78 81 29 ?? ?? 92 E1 00 08 3A 00 00 00 3A A0 00 00 96 F4 00 0C 7E 31 12 14 7D E9 12 14 39 C0 00 00 48 00 00 2C 38 80 00 23 4? ?? ?? ?? 9A A3 00 00 82 E1 00 08 88 17 00 00 2F 80 00 00 40 9E 00 48 80 16 00 00 70 07 00 10 40 82 01 38 38 61 00 08 7E 84 A3 78 7E C5 B3 78 4? ?? ?? ?? 7C 69 1B 79 41 80 01 20 80 61 00 08 38 09 FF FF 7D 23 00 AE 2F 89 00 0A 40 9E FF B0 7E A3 01 AE 80 61 00 08 4B FF FF A4 81 31 00 00 81 0F 00 00 48 00 00 08 3A F7 00 01 2F 89 00 00 41 9E 01 50 88 17 00 00 54 0B 06 3E 55 6A 08 3C 7D 49 52 2E 71 47 00 20 40 82 FF E0 2F 8B 00 00 7E E4 BB 78 41 9E 00 4C 80 EF 00 00 7E EB BB 78 48 00 00 14 41 9E 00 48 8C 0B 00 01 2F 80 00 00 41 BE FF 68 2F 89 00 00 7D 77 5B 78 41 9E 00 F0 89 4B 00 00 55 40 06 3E 54 08 08 3C 7D 09 42 2E 2F 80 00 3A 71 00 00 20 41 82 FF CC 7D 40 53 78 54 00 06 3E 2F 80 00 00 41 9E FF 30 7F 97 20 00 41 9E FF 28 9A B7 00 00 7C 83 23 78 90 81 00 1C 4? ?? ?? ?? 7C 65 1B 78 38 A5 00 01 38 63 00 0D 90 A1 00 18 4? ?? ?? ?? 7C 73 1B 79 80 81 00 1C 80 A1 00 18 41 A2 FE F4 38 73 00 0C 90 73 00 08 4? ?? ?? ?? 38 77 00 01 4B FF F6 89 2F 90 00 00 90 73 00 04 91 D3 00 00 41 9E 00 34 92 70 00 00 7E 70 9B 78 4B FF FE C4 80 61 00 08 4? ?? ?? ?? 7E C3 B3 78 4? ?? ?? ?? 92 5C ?? ?? 4B FF FD 20 7F C3 F3 78 4? ?? ?? ?? 4B FF FC 7C 92 72 00 00 7E 70 9B 78 4B FF FE 94 80 82 8B 68 38 00 00 DD 7F C3 F3 78 60 84 00 01 38 A0 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FC 74 81 27 00 00 81 29 00 24 39 29 01 00 91 31 00 00 4B FF FF 04 81 28 00 00 81 29 00 24 39 29 01 00 91 31 00 00 4B FF FE A4 }
	condition:
		$1
}

rule file_310_3_0 {
	meta:
		name = "__nss_configure_lookup"
		size = 356
		refs = "004c strcmp 0068 __errno_location 010a __nss_database_custom 015c __lll_lock_wait_private"
	strings:
		$1 = { 94 21 FF D0 7C 08 02 A6 93 81 00 20 3F 80 ?? ?? 3B 9C ?? ?? 90 01 00 34 93 21 00 14 93 A1 00 24 93 E1 00 2C 93 41 00 18 7C 9A 23 78 93 61 00 1C 7C 7B 1B 78 93 C1 00 28 3B C0 00 00 57 DD 20 36 7F FC EA 14 7F 63 DB 78 7F E4 FB 78 4? ?? ?? ?? 2F 9E 00 0B 7C 79 1B 79 41 82 00 50 41 80 00 0C 3B DE 00 01 40 9E FF D8 4? ?? ?? ?? 38 00 00 16 90 03 00 00 3B E0 FF FF 80 01 00 34 7F E3 FB 78 83 21 00 14 7C 08 03 A6 83 41 00 18 83 61 00 1C 83 81 00 20 83 A1 00 24 83 C1 00 28 83 E1 00 2C 38 21 00 30 4E 80 00 20 80 1F 00 0C 3B E0 00 00 2F 80 00 00 41 BE FF C4 7F 43 D3 78 4B FF F5 31 7C 7A 1B 79 41 A2 FF A4 3F E0 ?? ?? 3B FF ?? ?? 3B 7F 00 04 39 20 00 01 7C 00 D8 28 7C 00 C8 00 40 82 00 0C 7D 20 D9 2D 40 A2 FF F0 4C 00 01 2C 2F 80 00 00 40 9E 00 64 7F BC EA 14 81 3D 00 0C 38 00 00 01 93 49 00 00 3D 20 ?? ?? 39 29 ?? ?? 7C 09 F1 AE 38 00 00 00 7C 00 04 AC 7D 20 D8 28 7C 00 D9 2D 40 A2 FF F8 2F 89 00 01 3B E0 00 00 40 9D FF 48 80 82 8B 68 38 00 00 DD 7F 63 DB 78 60 84 00 01 38 A0 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF 24 7F 63 DB 78 4? ?? ?? ?? 4B FF FF 98 }
	condition:
		$1
}

rule file_310_4_0 {
	meta:
		name = "__nss_lookup_function"
		size = 984
		refs = "009c __tsearch 0128 malloc 0174 strlen 01c8 stpcpy 01dc strcpy 01ec __libc_dlsym 0250 strcmp 0268 free 0278 __tdelete 02dc __errno_location 0358 __libc_dlopen_mode 03ac __lll_lock_wait_private"
	strings:
		$1 = { 94 21 FF C0 7C 08 02 A6 7D 80 00 26 39 60 00 01 93 41 00 28 3F 40 ?? ?? 39 20 00 00 93 81 00 30 3B 9A ?? ?? 93 E1 00 3C 7C 3F 0B 78 93 61 00 2C 7C 7B 1B 78 93 A1 00 34 3B BC 00 04 90 01 00 44 92 A1 00 14 92 C1 00 18 92 E1 00 1C 93 01 00 20 93 21 00 24 93 C1 00 38 91 81 00 10 90 9F 00 08 7C 00 E8 28 7C 00 48 00 40 82 00 0C 7D 60 E9 2D 40 A2 FF F0 4C 00 01 2C 2F 80 00 00 40 9E 03 2C 3F 00 ?? ?? 3B DF 00 08 3B 18 ?? ?? 3B 3B 00 1C 7F C3 F3 78 7F 24 CB 78 7F 05 C3 78 4? ?? ?? ?? 81 23 00 00 7C 75 1B 78 7F 89 F0 00 41 9E 00 78 83 C9 00 04 80 02 8F F4 7F DE 02 78 38 00 00 00 7C 00 04 AC 7D 20 E8 28 7C 00 E9 2D 40 A2 FF F8 2F 89 00 01 41 9D 02 E0 39 7F 00 40 80 0B 00 04 7F C3 F3 78 81 8B FF D0 7C 08 03 A6 82 AB FF D4 82 CB FF D8 7D 80 81 20 82 EB FF DC 83 0B FF E0 83 2B FF E4 83 4B FF E8 83 6B FF EC 83 8B FF F0 83 AB FF F4 83 CB FF F8 83 EB FF FC 7D 61 5B 78 4E 80 00 20 38 60 00 08 4? ?? ?? ?? 7C 76 1B 79 41 82 01 3C 82 FB 00 18 80 1F 00 08 2F 97 00 00 92 D5 00 00 90 16 00 00 41 9E 00 CC 80 17 00 04 2F 80 00 00 41 9E 01 60 2F 80 FF FF 3B C0 00 00 38 00 00 00 41 9E 00 A0 81 3B 00 18 7C 3A 0B 78 80 69 00 00 4? ?? ?? ?? 7C 7E 1B 78 80 7F 00 08 4? ?? ?? ?? 81 21 00 00 7C 7E 1A 14 38 03 00 25 54 00 00 36 7C 00 00 D0 7D 21 01 6E 3D 20 ?? ?? 39 69 ?? ?? A0 0B 00 04 3B C1 00 17 81 29 ?? ?? 57 DE 00 36 B0 1E 00 04 38 7E 00 05 91 3E 00 00 81 3B 00 18 80 89 00 00 4? ?? ?? ?? 38 00 5F 00 B0 03 00 00 38 63 00 01 80 9F 00 08 4? ?? ?? ?? 81 3B 00 18 7F C4 F3 78 80 69 00 04 4? ?? ?? ?? 81 21 00 00 7C 7E 1B 78 91 3A 00 00 7C 60 1B 78 7F 41 D3 78 81 22 8F F4 7C 00 4A 78 90 16 00 04 4B FF FE AC 82 BA ?? ?? 2F 95 00 00 41 9E 01 6C 82 F5 00 04 3A B5 00 04 83 5B 00 20 2E 17 00 00 40 B2 00 14 48 00 00 50 82 F7 00 08 2E 17 00 00 41 92 00 44 80 77 00 00 7F 44 D3 78 3A B7 00 08 4? ?? ?? ?? 2F 83 00 00 40 9E FF E0 92 FB 00 18 40 92 FE EC 7E C3 B3 78 4? ?? ?? ?? 7F C3 F3 78 7F 24 CB 78 7F 05 C3 78 4? ?? ?? ?? 3B C0 00 00 4B FF FE 3C 38 60 00 0C 4? ?? ?? ?? 2F 83 00 00 90 75 00 00 41 9E 00 FC 38 00 00 00 90 03 00 08 82 F5 00 00 93 43 00 00 2E 17 00 00 90 03 00 04 4B FF FF AC 81 3B 00 18 7C 3A 0B 78 80 69 00 00 4? ?? ?? ?? 3D 20 ?? ?? 83 29 ?? ?? 7C 77 1B 78 7F 23 CB 78 4? ?? ?? ?? 7C 7E 1B 78 4? ?? ?? ?? 7F D7 F2 14 81 61 00 00 38 1E 00 29 82 E3 00 00 54 00 00 36 7C 00 00 D0 7D 61 01 6E 3D 20 ?? ?? 39 69 ?? ?? 80 0B 00 04 3B C1 00 17 81 29 ?? ?? 57 DE 00 36 90 1E 00 04 7C 78 1B 78 38 7E 00 07 91 3E 00 00 81 3B 00 18 80 89 00 00 4? ?? ?? ?? 3C 00 2E 73 60 00 6F 00 90 03 00 00 7F 24 CB 78 38 63 00 03 4? ?? ?? ?? 3C 80 80 00 83 3B 00 18 7F C3 F3 78 60 84 00 01 4? ?? ?? ?? 81 3B 00 18 90 79 00 04 80 09 00 04 2F 80 00 00 41 9E 00 2C 80 01 00 00 81 3B 00 18 90 1A 00 00 80 09 00 04 7F 41 D3 78 4B FF FD D4 3A BC 00 08 4B FF FE 94 90 7B 00 18 4B FF FE D0 38 00 FF FF 90 09 00 04 92 F8 00 00 4B FF FF CC 7F A3 EB 78 4? ?? ?? ?? 4B FF FC D0 80 82 8B 68 38 00 00 DD 7F A3 EB 78 60 84 00 01 38 A0 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FD 04 }
	condition:
		$1
}

rule file_310_5_0 {
	meta:
		name = "__nss_next2"
		size = 404
		refs = "008c __nss_lookup_function 0190 __libc_fatal"
	strings:
		$1 = { 7D 80 00 26 2F 88 00 00 94 21 FF E0 7C 08 02 A6 93 81 00 10 7C DC 33 78 93 A1 00 14 7C BD 2B 78 93 C1 00 18 7C 9E 23 78 93 E1 00 1C 7C 7F 1B 78 90 01 00 24 91 81 00 0C 41 9E 00 94 81 23 00 00 80 09 00 04 2F 80 00 01 40 9E 00 28 80 09 00 08 2F 80 00 01 40 9E 00 1C 80 09 00 0C 2F 80 00 01 40 9E 00 10 81 69 00 10 2F 8B 00 01 41 BE 00 88 80 69 00 00 38 00 FF FF 2F 83 00 00 41 9E 00 78 2E 1D 00 00 90 7F 00 00 7F C4 F3 78 4? ?? ?? ?? 2F 83 00 00 90 7C 00 00 41 9E 00 88 38 00 00 00 81 81 00 0C 7C 03 03 78 80 01 00 24 83 81 00 10 7D 80 81 20 7C 08 03 A6 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 38 E7 00 02 2B 87 00 04 41 9D 00 B4 81 23 00 00 54 E7 10 3A 38 00 00 01 7C E9 3A 14 81 67 00 04 2F 8B 00 01 40 BE FF 80 7C 03 03 78 80 01 00 24 81 81 00 0C 7C 08 03 A6 83 81 00 10 83 A1 00 14 7D 80 81 20 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 41 92 00 1C 80 7F 00 00 7F A4 EB 78 4? ?? ?? ?? 2F 83 00 00 90 7C 00 00 40 BE FF 64 81 3F 00 00 80 09 00 08 2F 80 00 00 40 9E 00 10 80 69 00 00 2F 83 00 00 40 9E FF 30 38 00 FF FF 81 81 00 0C 7C 03 03 78 80 01 00 24 83 81 00 10 7D 80 81 20 7C 08 03 A6 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 3C 60 ?? ?? 38 63 ?? ?? 4? ?? ?? ?? }
	condition:
		$1
}

rule file_310_6_0 {
	meta:
		name = "__nss_lookup"
		size = 272
		refs = "0038 __nss_lookup_function"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 7D 80 00 26 90 01 00 24 93 E1 00 1C 7C 7F 1B 78 80 63 00 00 93 81 00 10 7C BC 2B 78 93 A1 00 14 7C 9D 23 78 93 C1 00 18 7C DE 33 78 91 81 00 0C 4? ?? ?? ?? 2F 83 00 00 90 7E 00 00 41 9E 00 AC 2E 1C 00 00 48 00 00 0C 80 7E 00 00 2F 83 00 00 7F A4 EB 78 40 9E 00 50 81 3F 00 00 80 09 00 08 2F 80 00 00 40 9E 00 6C 80 09 00 00 2F 80 00 00 7C 03 03 78 41 9E 00 6C 90 1F 00 00 4? ?? ?? ?? 2F 83 00 00 90 7E 00 00 40 9E FF C0 7F 84 E3 78 41 B2 FF B8 80 7F 00 00 4? ?? ?? ?? 90 7E 00 00 4B FF FF A8 38 60 00 00 80 01 00 24 81 81 00 0C 7C 08 03 A6 83 81 00 10 83 A1 00 14 7D 80 81 20 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 80 09 00 00 38 60 FF FF 2F 80 00 00 40 9E FF CC 38 60 00 01 4B FF FF C4 2F 1C 00 00 41 BA FF 54 80 7F 00 00 7F 84 E3 78 4? ?? ?? ?? 90 7E 00 00 2F 83 00 00 4B FF FF 3C }
	condition:
		$1
}

rule file_310_7_0 {
	meta:
		name = "__nss_disable_nscd"
		size = 40
		refs = "0006 __nss_not_use_nscd_passwd 000e __nss_not_use_nscd_group 0016 __nss_not_use_nscd_hosts 001e __nss_not_use_nscd_services"
	strings:
		$1 = { 38 00 FF FF 3D 20 ?? ?? 90 09 ?? ?? 3D 20 ?? ?? 90 09 ?? ?? 3D 20 ?? ?? 90 09 ?? ?? 3D 20 ?? ?? 90 09 ?? ?? 4E 80 00 20 }
	condition:
		$1
}

rule file_310_8_0 {
	meta:
		name = "free_mem"
		size = 272
		refs = "0046 free 0068 __tdestroy 0108 __libc_dlclose"
	strings:
		$1 = { 94 21 FF E0 3D 20 ?? ?? 7C 08 02 A6 93 81 00 10 83 89 ?? ?? 90 01 00 24 2F 9C 00 00 93 61 00 0C 93 A1 00 14 93 C1 00 18 93 E1 00 1C 41 9E 00 7C 83 BC 00 00 38 00 00 00 90 09 ?? ?? 2F 9D 00 00 41 9E 00 8C 3F C0 ?? ?? 3B DE ?? ?? 83 FD 00 04 2F 9F 00 00 41 9E 00 30 80 7F 00 1C 7F C4 F3 78 2F 83 00 00 41 9E 00 08 4? ?? ?? ?? 83 7F 00 00 7F E3 FB 78 4? ?? ?? ?? 2F 9B 00 00 7F 7F DB 78 40 9E FF D8 83 FD 00 00 7F A3 EB 78 4? ?? ?? ?? 2F 9F 00 00 41 9E 00 38 7F FD FB 78 4B FF FF B0 7F 83 E3 78 4? ?? ?? ?? 80 01 00 24 83 61 00 0C 7C 08 03 A6 83 81 00 10 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 83 FC 00 04 2F 9F 00 00 41 BE FF CC 3B A0 FF FD 48 00 00 1C 83 DF 00 08 7F E3 FB 78 4? ?? ?? ?? 2F 9E 00 00 7F DF F3 78 41 BE FF AC 80 7F 00 04 38 03 FF FF 7F 80 E8 40 41 9D FF DC 4? ?? ?? ?? 4B FF FF D4 }
	condition:
		$1
}

rule file_310_9_0 {
	meta:
		name = "__nss_next"
		size = 28
		refs = "0018 __nss_next2"
	strings:
		$1 = { 7C A9 2B 78 7C C0 33 78 7C E8 3B 78 38 A0 00 00 7D 26 4B 78 7C 07 03 78 4? ?? ?? ?? }
	condition:
		$1
}

rule file_311_0_0 {
	meta:
		name = "__sleep"
		size = 680
		refs = "0070 memset 0084 __sigprocmask 00c0 __sigaction 00f0 __nanosleep 0180 __errno_location 029c __pthread_unwind"
	strings:
		$1 = { 94 21 FE 40 7D 80 00 26 7C 08 02 A6 93 E1 01 BC 7C 7F 1B 79 90 01 01 C4 93 81 01 B0 93 A1 01 B4 93 C1 01 B8 91 81 01 AC 41 82 02 24 38 00 00 00 3F 80 7F FF 90 01 00 0C 63 9C FF FF 3F A0 00 01 48 00 00 08 80 01 00 08 7F 9F E0 40 7F FE FB 78 40 9D 00 0C 3F C0 7F FF 63 DE FF FF 7F DE 02 14 38 80 00 00 93 C1 00 08 38 A0 00 80 38 61 00 10 4? ?? ?? ?? 38 60 00 00 38 81 00 10 93 A1 00 10 38 A1 00 90 4? ?? ?? ?? 2F 83 00 00 40 9E 01 68 80 01 00 90 7F FE F8 50 74 09 00 01 40 82 00 4C 38 80 00 00 38 A0 00 80 38 61 00 10 4? ?? ?? ?? 38 60 00 11 38 80 00 00 93 A1 00 10 38 A1 01 10 4? ?? ?? ?? 2F 83 00 00 41 9C 01 5C 80 01 01 10 2F 80 00 01 41 9E 00 60 38 60 00 02 38 81 00 90 38 A0 00 00 4? ?? ?? ?? 38 61 00 08 7C 64 1B 78 4? ?? ?? ?? 2F 83 00 00 40 9E 00 AC 2F 9F 00 00 40 9E FF 44 3B C0 00 00 80 01 01 C4 7F C3 F3 78 81 81 01 AC 7C 08 03 A6 83 81 01 B0 83 A1 01 B4 7D 80 81 20 83 C1 01 B8 83 E1 01 BC 38 21 01 C0 4E 80 00 20 3F A0 7F FF 63 BD FF FE 48 00 00 2C 2F 9F 00 00 41 9E 00 3C 7F 9F E8 40 3C 00 7F FF 60 00 FF FF 41 9D 00 08 7F E0 FB 78 90 01 00 08 80 01 00 0C 7F E0 F8 50 38 61 00 08 7C 64 1B 78 4? ?? ?? ?? 2E 03 00 00 7C 7E 1B 78 41 92 FF C4 4? ?? ?? ?? 38 81 00 90 83 83 00 00 7C 7D 1B 78 38 A0 00 00 38 60 00 02 4? ?? ?? ?? 93 9D 00 00 41 B2 FF 68 81 21 00 0C 3C 00 1D CD 60 00 64 FF 81 81 01 AC 7F 89 00 00 80 01 00 08 83 81 01 B0 7D 80 81 20 83 A1 01 B4 7F C0 00 26 57 DE F7 FE 7F DE 02 14 80 01 01 C4 7F DE FA 14 83 E1 01 BC 7C 08 03 A6 7F C3 F3 78 83 C1 01 B8 38 21 01 C0 4E 80 00 20 80 01 01 C4 3B C0 FF FF 81 81 01 AC 7F C3 F3 78 7C 08 03 A6 83 81 01 B0 83 A1 01 B4 7D 80 81 20 83 C1 01 B8 83 E1 01 BC 38 21 01 C0 4E 80 00 20 4? ?? ?? ?? 38 81 00 90 83 C3 00 00 7C 7F 1B 78 38 A0 00 00 38 60 00 02 4? ?? ?? ?? 93 DF 00 00 3B C0 FF FF 4B FF FE C0 39 22 8B 60 80 09 00 84 39 60 FF B9 3B C0 00 00 7D 6B 00 38 2F 8B 00 08 40 9E FE A4 39 60 FF FF 91 69 02 20 39 69 00 84 60 08 00 10 7D 40 58 28 7D 40 50 51 40 82 00 0C 7D 00 59 2D 40 A2 FF F0 4C 00 01 2C 2F 8A 00 00 40 9E 00 0C 80 62 8B E0 4? ?? ?? ?? 80 09 00 84 4B FF FF D0 }
	condition:
		$1
}

rule file_312_0_0 {
	meta:
		name = "posix_spawnattr_getschedparam"
		size = 16
	strings:
		$1 = { 80 03 01 08 38 60 00 00 90 04 00 00 4E 80 00 20 }
	condition:
		$1
}

rule file_313_0_0 {
	meta:
		name = "skip_string"
		size = 136
		refs = "000e _GLOBAL_OFFSET_TABLE_ 0016 __libc_tsd_CTYPE_B 001a _nl_current_LC_CTYPE"
	strings:
		$1 = { 88 03 00 00 70 07 00 FF 4D 82 00 20 3D 20 ?? ?? 39 29 ?? ?? 81 69 ?? ?? 81 29 ?? ?? 7D 49 12 14 7D 6B 12 14 81 0A 00 00 81 2B 00 00 7D 6A 5B 78 48 00 00 10 8C 03 00 01 70 0B 00 FF 4D 82 00 20 2F 89 00 00 41 9E 00 2C 54 00 06 3E 54 0B 08 3C 7D 69 5A 2E 2F 80 00 23 2F 00 00 2C 71 67 00 20 4C 82 00 20 4D 9E 00 20 40 9A FF CC 4E 80 00 20 81 28 00 00 81 29 00 24 39 29 01 00 91 2A 00 00 88 03 00 00 4B FF FF C4 }
	condition:
		$1
}

rule file_313_1_0 {
	meta:
		name = "skip_ws"
		size = 92
		refs = "0002 _GLOBAL_OFFSET_TABLE_ 000a __libc_tsd_CTYPE_B 000e _nl_current_LC_CTYPE"
	strings:
		$1 = { 3D 60 ?? ?? 39 6B ?? ?? 81 2B ?? ?? 81 6B ?? ?? 7D 29 12 14 7D 6B 12 14 81 49 00 00 81 6B 00 00 48 00 00 08 38 63 00 01 2F 8A 00 00 41 9E 00 1C 88 03 00 00 54 00 08 3C 7C 0A 02 2E 70 08 00 20 40 82 FF E4 4E 80 00 20 81 4B 00 00 81 4A 00 24 39 4A 01 00 91 49 00 00 4B FF FF D8 }
	condition:
		$1
}

rule file_313_2_0 {
	meta:
		name = "arg_bool"
		size = 320
		refs = "003c __strncasecmp 004a _res_hconf 00e2 _libc_intl_domainname 00f0 __dcgettext 010c __asprintf 0130 __fxprintf 0138 free"
	strings:
		$1 = { 94 21 FF D0 7C 08 02 A6 93 C1 00 28 7C 9E 23 78 3C 80 ?? ?? 93 A1 00 24 38 84 ?? ?? 7C 7D 1B 78 93 E1 00 2C 7C A3 2B 78 7C BF 2B 78 38 A0 00 02 93 81 00 20 7C DC 33 78 90 01 00 34 4? ?? ?? ?? 2F 83 00 00 40 9E 00 40 3D 20 ?? ?? 39 29 ?? ?? 80 09 00 2C 3B FF 00 02 7F 9C 03 78 93 89 00 2C 80 01 00 34 7F E3 FB 78 83 81 00 20 7C 08 03 A6 83 A1 00 24 83 C1 00 28 83 E1 00 2C 38 21 00 30 4E 80 00 20 3C 80 ?? ?? 7F E3 FB 78 38 84 ?? ?? 38 A0 00 03 4? ?? ?? ?? 2F 83 00 00 40 9E 00 40 3D 20 ?? ?? 83 A1 00 24 39 29 ?? ?? 83 C1 00 28 80 09 00 2C 3B FF 00 03 7F E3 FB 78 83 E1 00 2C 7C 1C E0 78 80 01 00 34 93 89 00 2C 7C 08 03 A6 83 81 00 20 38 21 00 30 4E 80 00 20 3C 80 ?? ?? 3C 60 ?? ?? 38 84 ?? ?? 38 A0 00 05 38 63 ?? ?? 4? ?? ?? ?? 7F E7 FB 78 7C 64 1B 78 7F A5 EB 78 38 61 00 08 7F C6 F3 78 4C C6 31 82 4? ?? ?? ?? 3B E0 00 00 2F 83 00 00 41 9C FF 48 80 A1 00 08 3C 80 ?? ?? 38 84 ?? ?? 38 60 00 00 4C C6 31 82 4? ?? ?? ?? 80 61 00 08 4? ?? ?? ?? 4B FF FF 24 }
	condition:
		$1
}

rule file_313_3_0 {
	meta:
		name = "arg_trimdomain_list"
		size = 432
		refs = "000e _res_hconf 0064 __strndup 0112 _libc_intl_domainname 0120 __dcgettext 0138 __asprintf 015c __fxprintf 0164 free"
	strings:
		$1 = { 94 21 FF C0 7C 08 02 A6 93 C1 00 38 3F C0 ?? ?? 3B DE ?? ?? 90 01 00 44 93 61 00 2C 93 21 00 24 3F 20 80 03 93 41 00 28 7F DA F3 78 93 81 00 30 7C 7C 1B 78 93 A1 00 34 7C 9D 23 78 93 E1 00 3C 7C BF 2B 78 7F E3 FB 78 4B FF FD 95 7C 7B 1B 78 7C 9F D8 50 7F E3 FB 78 83 FE 00 18 2F 9F 00 03 41 9D 01 0C 4? ?? ?? ?? 39 3F 00 04 55 29 10 3A 7D 3A 4A 14 3B FF 00 01 90 69 00 0C 7F 63 DB 78 93 FA 00 18 4B FF FD E1 89 23 00 00 7C 7F 1B 78 38 09 FF D4 54 0B 06 3E 2B 8B 00 0F 7C 00 07 74 2F 09 00 00 2C 89 00 23 7F 29 00 31 41 9D 00 0C 38 63 00 01 41 80 00 3C 41 9A 00 08 40 86 FF 88 80 01 00 44 7F E3 FB 78 83 21 00 24 7C 08 03 A6 83 41 00 28 83 61 00 2C 83 81 00 30 83 A1 00 34 83 C1 00 38 83 E1 00 3C 38 21 00 40 4E 80 00 20 4B FF FD 75 88 03 00 00 7C 7F 1B 78 2F 80 00 00 2F 00 00 23 41 9E 00 08 40 9A FF 3C 3C 80 ?? ?? 3C 60 ?? ?? 38 84 ?? ?? 38 A0 00 05 38 63 ?? ?? 4? ?? ?? ?? 7F 85 E3 78 7C 64 1B 78 7F A6 EB 78 38 61 00 08 4C C6 31 82 4? ?? ?? ?? 3B E0 00 00 2F 83 00 00 41 9C FF 7C 80 A1 00 08 3C 80 ?? ?? 38 84 ?? ?? 38 60 00 00 4C C6 31 82 4? ?? ?? ?? 80 61 00 08 4? ?? ?? ?? 4B FF FF 58 3C 80 ?? ?? 3C 60 ?? ?? 38 84 ?? ?? 38 A0 00 05 38 63 ?? ?? 4? ?? ?? ?? 7F 85 E3 78 7C 64 1B 78 7F A6 EB 78 38 61 00 08 38 E0 00 04 4C C6 31 82 4? ?? ?? ?? 3B E0 00 00 2F 83 00 00 41 9C FF 18 4B FF FF 9C }
	condition:
		$1
}

rule file_313_4_0 {
	meta:
		name = "arg_spoof.clone.1"
		size = 264
		refs = "0036 _res_hconf 0068 __strncasecmp"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 93 81 00 10 7C 7C 1B 78 90 01 00 24 93 C1 00 18 93 A1 00 14 93 E1 00 1C 4B FF FC 0D 7C 1C 18 50 2F 80 00 03 7C 7E 1B 78 41 9E 00 70 3F E0 ?? ?? 2F 80 00 06 3B FF ?? ?? 83 BF 00 2C 63 BD 00 06 93 BF 00 2C 41 9E 00 28 2F 80 00 04 40 9E 00 20 3C 80 ?? ?? 7F 83 E3 78 38 84 ?? ?? 38 A0 00 04 4? ?? ?? ?? 2F 83 00 00 41 9E 00 0C 57 BD 07 B8 93 BF 00 2C 80 01 00 24 7F C3 F3 78 83 81 00 10 7C 08 03 A6 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 3C 80 ?? ?? 7F 83 E3 78 38 84 ?? ?? 38 A0 00 03 4? ?? ?? ?? 2F 83 00 00 41 9E 00 18 3F E0 ?? ?? 3B FF ?? ?? 83 BF 00 2C 63 BD 00 06 4B FF FF A8 3D 20 ?? ?? 83 81 00 10 39 29 ?? ?? 83 A1 00 14 80 09 00 2C 7F C3 F3 78 83 E1 00 1C 54 00 07 F8 83 C1 00 18 90 09 00 2C 80 01 00 24 38 21 00 20 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_313_5_0 {
	meta:
		name = "do_init"
		size = 960
		refs = "0012 _res_hconf 0060 memset 006c getenv 0084 _IO_new_fopen 0096 _GLOBAL_OFFSET_TABLE_ 00a2 __libc_tsd_CTYPE_B 00aa _nl_current_LC_CTYPE 00b2 _libc_intl_domainname 00e0 fgets_unlocked 00f4 __strchrnul 0148 __strncasecmp 0158 strlen 017c __dcgettext 0198 __asprintf 01b4 __fxprintf 01bc free 01dc _IO_new_fclose"
	strings:
		$1 = { 94 21 FE A0 7C 08 02 A6 38 80 00 00 93 61 01 4C 3F 60 ?? ?? 38 A0 00 30 93 41 01 48 3B 5B ?? ?? 7F 43 D3 78 90 01 01 64 93 81 01 50 92 01 01 20 92 21 01 24 92 41 01 28 92 61 01 2C 92 81 01 30 92 A1 01 34 92 C1 01 38 92 E1 01 3C 93 01 01 40 93 21 01 44 93 A1 01 54 93 C1 01 58 93 E1 01 5C 4? ?? ?? ?? 3C 60 ?? ?? 38 63 ?? ?? 4? ?? ?? ?? 7C 7C 1B 79 41 82 03 2C 3C 80 ?? ?? 7F 83 E3 78 38 84 ?? ?? 4? ?? ?? ?? 7C 7D 1B 79 41 82 01 54 80 1D 00 00 3F 00 ?? ?? 3B 18 ?? ?? 60 00 80 00 83 38 ?? ?? 90 1D 00 00 83 18 ?? ?? 3F E0 ?? ?? 3E E0 ?? ?? 3E C0 ?? ?? 3B C0 00 00 3B FF ?? ?? 3A F7 ?? ?? 3A D6 ?? ?? 3E A0 ?? ?? 7F 39 12 14 7F 18 12 14 38 61 00 0C 38 80 01 00 7F A5 EB 78 4? ?? ?? ?? 2F 83 00 00 41 9E 00 F0 38 80 00 0A 38 61 00 0C 4? ?? ?? ?? 38 00 00 00 98 03 00 00 38 61 00 0C 3B DE 00 01 4B FF FA A5 88 03 00 00 7C 74 1B 78 2F 80 00 00 41 BE FF BC 2F 80 00 23 41 BE FF B4 4B FF FA 01 3A 60 00 00 7C 70 1B 78 7E 34 18 50 56 72 20 36 7E 5F 92 14 7E 44 93 78 7E 25 8B 78 7E 83 A3 78 4? ?? ?? ?? 2F 83 00 00 7E 43 93 78 40 9E 00 10 4? ?? ?? ?? 7F 91 18 00 41 9E 01 90 2F 93 00 06 3A 73 00 01 40 9E FF C8 7E C4 B3 78 38 A0 00 05 7E E3 BB 78 4? ?? ?? ?? 7F 85 E3 78 7C 64 1B 78 7F C6 F3 78 38 61 00 08 7E 87 A3 78 4C C6 31 82 4? ?? ?? ?? 2F 83 00 00 41 BC FF 34 80 A1 00 08 38 95 ?? ?? 38 60 00 00 4C C6 31 82 4? ?? ?? ?? 80 61 00 08 4? ?? ?? ?? 38 61 00 0C 38 80 01 00 7F A5 EB 78 4? ?? ?? ?? 2F 83 00 00 40 9E FF 18 7F A3 EB 78 4? ?? ?? ?? 3C 60 ?? ?? 38 63 ?? ?? 4? ?? ?? ?? 2F 83 00 00 41 9E 00 08 4B FF FD 05 3F E0 ?? ?? 3B FF ?? ?? 7F E3 FB 78 4? ?? ?? ?? 7C 65 1B 79 41 82 00 14 7F E3 FB 78 38 80 00 01 38 C0 00 10 4B FF F9 ED 3F E0 ?? ?? 3B FF ?? ?? 7F E3 FB 78 4? ?? ?? ?? 7C 65 1B 79 41 82 00 14 7F E3 FB 78 38 80 00 01 38 C0 00 08 4B FF F9 C5 3F E0 ?? ?? 3B FF ?? ?? 7F E3 FB 78 4? ?? ?? ?? 7C 65 1B 79 41 82 00 10 7F E3 FB 78 38 80 00 01 4B FF FA E1 3F E0 ?? ?? 3B FF ?? ?? 7F E3 FB 78 4? ?? ?? ?? 7C 65 1B 79 41 82 00 18 38 00 00 00 7F E3 FB 78 90 1A 00 18 38 80 00 01 4B FF FA B5 38 00 00 01 82 01 01 20 90 1B ?? ?? 80 01 01 64 82 21 01 24 7C 08 03 A6 82 41 01 28 82 61 01 2C 82 81 01 30 82 A1 01 34 82 C1 01 38 82 E1 01 3C 83 01 01 40 83 21 01 44 83 41 01 48 83 61 01 4C 83 81 01 50 83 A1 01 54 83 C1 01 58 83 E1 01 5C 38 21 01 60 4E 80 00 20 7E 03 83 78 4B FF F8 B9 88 12 00 0B 7C 65 1B 78 2F 80 00 01 41 9E 00 84 2F 80 00 02 41 9E 00 8C 2F 80 00 03 40 9E FD C0 80 D2 00 0C 7F 83 E3 78 7F C4 F3 78 4B FF F8 E5 2F 83 00 00 41 BE FD A8 88 03 00 00 2F 80 00 00 41 BE FD 9C 81 39 00 00 7C 74 1B 78 81 58 00 00 48 00 00 10 8C 14 00 01 2F 80 00 00 41 BE FD 80 2F 89 00 00 41 9E 00 50 88 14 00 00 54 0B 08 3C 7D 69 5A 2E 71 68 00 20 40 82 FF DC 2F 80 00 23 41 BE FD 5C 3C 80 ?? ?? 38 84 ?? ?? 4B FF FD F0 7F 83 E3 78 7F C4 F3 78 4B FF F9 B9 4B FF FF 94 4B FF FB 61 4B FF FF 8C 3F 80 ?? ?? 3B 9C ?? ?? 4B FF FC D0 81 2A 00 00 81 29 00 24 39 29 01 00 91 39 00 00 4B FF FF A4 }
	condition:
		$1
}

rule file_313_6_0 {
	meta:
		name = "_res_hconf_init"
		size = 108
		refs = "000a __pthread_once"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 3D 20 ?? ?? 90 01 00 14 38 09 ?? ?? 2F 80 00 00 93 E1 00 0C 41 9E 00 2C 3C 60 ?? ?? 3C 80 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 4? ?? ?? ?? 80 01 00 14 83 E1 00 0C 38 21 00 10 7C 08 03 A6 4E 80 00 20 3F E0 ?? ?? 80 1F ?? ?? 2F 80 00 00 40 9E FF E0 4B FF FB E9 80 1F ?? ?? 60 00 00 02 90 1F ?? ?? 4B FF FF CC }
	condition:
		$1
}

rule file_313_7_0 {
	meta:
		name = "_res_hconf_reorder_addrs"
		size = 840
		refs = "000a _res_hconf 0170 __socket 01c0 __close 01e0 __ifreq 01fc malloc 0274 __ioctl 02a4 realloc 02b8 free 0320 __lll_lock_wait_private 0344 __assert_fail"
	strings:
		$1 = { 94 21 FF B0 7C 08 02 A6 3D 20 ?? ?? 90 01 00 54 80 09 ?? ?? 93 E1 00 4C 7C 7F 1B 78 70 09 00 08 92 A1 00 24 92 C1 00 28 92 E1 00 2C 93 01 00 30 93 21 00 34 93 41 00 38 93 61 00 3C 93 81 00 40 93 A1 00 44 93 C1 00 48 41 82 00 10 80 03 00 08 2F 80 00 02 41 9E 00 40 80 01 00 54 82 A1 00 24 7C 08 03 A6 82 C1 00 28 82 E1 00 2C 83 01 00 30 83 21 00 34 83 41 00 38 83 61 00 3C 83 81 00 40 83 A1 00 44 83 C1 00 48 83 E1 00 4C 38 21 00 50 4E 80 00 20 3F C0 ?? ?? 80 BE ?? ?? 2F 85 00 00 40 9D 00 C4 80 9F 00 10 83 E4 00 00 2F 1F 00 00 41 BA FF A8 3D 20 ?? ?? 80 E9 ?? ?? 7C 83 23 78 7F E6 FB 78 7C 9E 23 78 40 9D 00 84 81 06 00 00 81 27 00 04 80 07 00 08 7D 09 4A 78 7D 2A 00 39 41 82 00 28 7C A9 03 A6 7C E9 3B 78 42 40 00 60 81 49 00 10 80 09 00 14 39 29 00 0C 7D 0B 52 78 7D 6A 00 39 40 82 FF E8 80 01 00 54 93 FE 00 00 7C 08 03 A6 82 A1 00 24 82 C1 00 28 82 E1 00 2C 83 01 00 30 83 21 00 34 83 41 00 38 83 61 00 3C 83 81 00 40 83 A1 00 44 83 C1 00 48 83 E1 00 4C 38 21 00 50 90 C4 00 00 4E 80 00 20 38 63 00 04 80 C3 00 00 7C 7E 1B 78 2F 06 00 00 40 9A FF 6C 4B FF FE F8 38 60 00 02 38 80 00 02 38 A0 00 00 4? ?? ?? ?? 7C 7D 1B 79 41 A0 FE E0 3F 00 ?? ?? 3B 18 ?? ?? 3B 98 00 04 39 60 00 01 39 20 00 00 7C 00 E0 28 7C 00 48 00 40 82 00 0C 7D 60 E1 2D 40 A2 FF F0 4C 00 01 2C 2F 80 00 00 40 9E 01 70 80 1E ?? ?? 2F 80 00 00 40 9D 00 1C 7F A3 EB 78 4? ?? ?? ?? 80 BE ?? ?? 2F 85 00 00 41 9E FE 8C 4B FF FE D4 38 61 00 08 38 81 00 0C 7F A5 EB 78 4? ?? ?? ?? 83 61 00 08 2F 9B 00 00 41 9E 01 14 80 61 00 0C 3E A0 ?? ?? 1C 63 00 0C 4? ?? ?? ?? 2F 83 00 00 90 75 ?? ?? 41 9E 01 0C 80 01 00 0C 3A E0 00 00 3A C0 00 00 2F 80 00 00 40 9D 00 84 3B 40 00 00 3B 35 ?? ?? 48 00 00 1C 80 79 00 00 3B 5A 00 01 7F 80 D0 00 40 9D 00 68 80 79 00 00 3B 7B 00 20 A1 7B 00 10 2F 8B 00 02 40 9E FF E0 80 1B 00 14 7D 23 B2 14 7D 63 B1 2E 38 80 00 00 7F A3 EB 78 90 09 00 04 60 84 89 1B 7F 65 DB 78 4C C6 31 82 4? ?? ?? ?? 2F 83 00 00 41 9C 00 8C 80 79 00 00 3A F7 00 01 80 1B 00 14 7E C3 B2 14 90 16 00 08 1E D7 00 0C 80 01 00 0C 4B FF FF 94 7E C4 B3 78 4? ?? ?? ?? 2F 83 00 00 90 75 ?? ?? 41 9E 00 78 80 61 00 08 4? ?? ?? ?? 92 FE ?? ?? 38 00 00 00 7C 00 04 AC 7D 20 E0 28 7C 00 E1 2D 40 A2 FF F8 2F 89 00 01 40 9D FE E4 80 82 8B 68 38 00 00 DD 7F 83 E3 78 60 84 00 01 38 A0 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FE C0 3A E0 00 00 4B FF FF B8 80 79 00 00 80 01 00 0C 4B FF FF 20 3A E0 00 00 4B FF FF 9C 7F 83 E3 78 4? ?? ?? ?? 4B FF FE 8C 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 01 C9 38 C6 ?? ?? 4? ?? ?? ?? }
	condition:
		$1
}

rule file_313_8_0 {
	meta:
		name = "_res_hconf_trim_domain"
		size = 236
		refs = "000e _res_hconf 0034 strlen 007c __strcasecmp"
	strings:
		$1 = { 94 21 FF D0 7C 08 02 A6 93 A1 00 24 3F A0 ?? ?? 3B BD ?? ?? 93 41 00 18 7C 7A 1B 78 93 61 00 1C 93 C1 00 28 90 01 00 34 93 21 00 14 93 81 00 20 93 E1 00 2C 4? ?? ?? ?? 7C 7E 1B 78 83 7D 00 18 2F 9B 00 00 40 9D 00 4C 3B BD 00 18 3B E0 00 00 87 3D 00 04 3B FF 00 01 7F 23 CB 78 4? ?? ?? ?? 7F 24 CB 78 7C 60 1B 78 7F 9E 00 40 7F 83 F0 50 7F 9A E2 14 7F 83 E3 78 40 9D 00 10 4? ?? ?? ?? 2C 03 00 00 41 82 00 38 7F 9F D8 00 40 9E FF C4 80 01 00 34 83 21 00 14 7C 08 03 A6 83 41 00 18 83 61 00 1C 83 81 00 20 83 A1 00 24 83 C1 00 28 83 E1 00 2C 38 21 00 30 4E 80 00 20 98 7C 00 00 80 01 00 34 83 21 00 14 7C 08 03 A6 83 41 00 18 83 61 00 1C 83 81 00 20 83 A1 00 24 83 C1 00 28 83 E1 00 2C 38 21 00 30 4E 80 00 20 }
	condition:
		$1
}

rule file_313_9_0 {
	meta:
		name = "_res_hconf_trim_domains"
		size = 140
		refs = "000a _res_hconf 0044 _res_hconf_trim_domain"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 3D 20 ?? ?? 90 01 00 14 80 09 ?? ?? 93 C1 00 08 7C 7E 1B 78 2F 80 00 00 93 E1 00 0C 40 9E 00 1C 80 01 00 14 83 C1 00 08 7C 08 03 A6 83 E1 00 0C 38 21 00 10 4E 80 00 20 80 63 00 00 4? ?? ?? ?? 81 3E 00 04 80 69 00 00 2F 83 00 00 41 BE FF D4 3B E0 00 04 4? ?? ?? ?? 81 3E 00 04 7C 69 F8 2E 3B FF 00 04 2F 83 00 00 40 9E FF EC 80 01 00 14 83 C1 00 08 7C 08 03 A6 83 E1 00 0C 38 21 00 10 4E 80 00 20 }
	condition:
		$1
}

rule file_314_0_0 {
	meta:
		name = "__isoc99_vswscanf"
		size = 168
		refs = "000a _IO_wstr_jumps 0048 _IO_no_init 0054 _IO_fwide 0068 _IO_wstr_init_static 0088 _IO_vfwscanf"
	strings:
		$1 = { 94 21 FE 70 7C 08 02 A6 3C E0 ?? ?? 93 C1 01 88 7C 9E 23 78 38 80 00 00 38 C1 00 B0 90 01 01 94 38 E7 ?? ?? 38 00 00 00 93 A1 01 84 60 84 80 00 93 E1 01 8C 7C 7D 1B 78 7C BF 2B 78 38 61 00 08 90 01 00 50 38 A0 00 00 4? ?? ?? ?? 38 61 00 08 38 80 00 01 4? ?? ?? ?? 38 61 00 08 7F A4 EB 78 38 A0 00 00 38 C0 00 00 4? ?? ?? ?? 80 01 00 44 38 61 00 08 60 00 00 10 7F C4 F3 78 90 01 00 44 7F E5 FB 78 38 C0 00 00 4? ?? ?? ?? 80 01 01 94 83 A1 01 84 7C 08 03 A6 83 C1 01 88 83 E1 01 8C 38 21 01 90 4E 80 00 20 }
	condition:
		$1
}

rule file_316_0_0 {
	meta:
		name = "flush_cleanup"
		size = 220
	strings:
		$1 = { 94 21 FF F0 93 E1 00 0C 3F E0 ?? ?? 3B FF ?? ?? 81 3F 00 08 2F 89 00 00 41 9E 00 10 80 09 00 00 70 0B 80 00 41 82 00 44 81 3F 00 10 38 09 FF FF 2F 80 00 00 90 1F 00 10 40 9E 00 24 90 1F 00 14 38 7F 00 0C 7C 00 04 AC 7D 20 18 28 7C 00 19 2D 40 A2 FF F8 2F 89 00 01 41 9D 00 64 83 E1 00 0C 38 21 00 10 4E 80 00 20 80 69 00 48 81 23 00 04 38 09 FF FF 2F 80 00 00 90 03 00 04 40 BE FF AC 90 03 00 08 7C 00 04 AC 7D 20 18 28 7C 00 19 2D 40 A2 FF F8 2F 89 00 01 40 9D FF 90 80 82 8B 68 38 00 00 DD 38 A0 00 01 60 84 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF 70 80 82 8B 68 38 00 00 DD 38 A0 00 01 60 84 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF 84 }
	condition:
		$1
}

rule file_316_1_0 {
	meta:
		name = "save_for_backup"
		size = 500
		refs = "00f0 memcpy 0118 memmove 0178 malloc 01b0 free 01e0 mempcpy"
	strings:
		$1 = { 94 21 FF D0 7C 08 02 A6 90 01 00 34 81 23 00 30 93 21 00 14 2F 09 00 00 83 23 00 0C 93 A1 00 24 7C 9D 23 78 7D 59 20 50 93 C1 00 28 7C 7E 1B 78 93 41 00 18 93 61 00 1C 93 81 00 20 93 E1 00 2C 41 9A 01 10 7D 5F 53 78 7D 2B 4B 78 80 0B 00 08 7F 9F 00 00 40 9D 00 08 7C 1F 03 78 81 6B 00 00 2F 8B 00 00 40 9E FF E8 80 9E 00 2C 7C BF 50 50 80 7E 00 24 7F 83 20 50 7F 85 E0 40 41 9D 00 EC 2F 9F 00 00 7F 85 E0 50 41 9C 00 84 2F 85 00 00 40 9E 00 58 7F 83 E2 14 93 9E 00 28 41 9A 00 1C 80 09 00 08 7C 0A 00 50 90 09 00 08 81 29 00 00 2F 89 00 00 40 9E FF EC 38 60 00 00 80 01 00 34 83 21 00 14 7C 08 03 A6 83 41 00 18 83 61 00 1C 83 81 00 20 83 A1 00 24 83 C1 00 28 83 E1 00 2C 38 21 00 30 4E 80 00 20 7C 63 E2 14 7C 99 FA 14 4? ?? ?? ?? 81 3E 00 30 81 5E 00 0C 80 7E 00 24 2F 09 00 00 7D 4A E8 50 4B FF FF 8C 7C 84 FA 14 7C BF 00 D0 7C 63 E2 14 4? ?? ?? ?? 80 9E 00 0C 80 7E 00 24 7F FF E0 50 7C A4 E8 50 7C 63 FA 14 4? ?? ?? ?? 81 5E 00 0C 81 3E 00 30 80 1E 00 24 7D 4A E8 50 2F 09 00 00 7F 80 E2 14 4B FF FF 4C 80 83 00 2C 7D 5F 53 78 80 63 00 24 38 A0 00 00 7F 83 20 50 4B FF FF 1C 3B 45 00 64 90 81 00 0C 7F 43 D3 78 90 A1 00 08 4? ?? ?? ?? 7C 7B 1B 79 80 81 00 0C 38 60 FF FF 80 A1 00 08 41 A2 FF 30 2F 9F 00 00 41 9C 00 3C 3B 9B 00 64 7F 83 E3 78 7C 99 FA 14 4? ?? ?? ?? 80 7E 00 24 7F 5B D2 14 4? ?? ?? ?? 81 5E 00 0C 81 3E 00 30 93 7E 00 24 7D 4A E8 50 2F 09 00 00 93 5E 00 2C 4B FF FE CC 3B 9B 00 64 7C 84 FA 14 7C BF 00 D0 7F 83 E3 78 4? ?? ?? ?? 80 9E 00 0C 7C A4 E8 50 4? ?? ?? ?? 4B FF FF B8 }
	condition:
		$1
}

rule file_316_2_0 {
	meta:
		name = "_IO_un_link"
		size = 680
		refs = "0032 _pthread_cleanup_push_defer 010e _IO_list_all 01cc _pthread_cleanup_pop_restore 0298 __lll_lock_wait_private"
	strings:
		$1 = { 94 21 FF D0 7C 08 02 A6 7D 80 00 26 90 01 00 34 80 03 00 00 93 C1 00 28 7C 7E 1B 78 70 09 00 80 93 A1 00 24 93 E1 00 2C 91 81 00 20 41 82 01 A4 3D 20 ?? ?? 38 09 ?? ?? 7C 00 00 34 54 00 D9 7E 68 00 00 01 2E 00 00 00 40 92 01 C4 3D 20 ?? ?? 90 01 00 0C 39 29 ?? ?? 91 21 00 08 3F E0 ?? ?? 3B FF ?? ?? 80 1F 00 14 3B A2 8B 60 7F 80 E8 00 41 9E 00 34 38 7F 00 0C 39 60 00 01 39 20 00 00 7C 00 18 28 7C 00 48 00 40 82 00 0C 7D 60 19 2D 40 A2 FF F0 4C 00 01 2C 2F 80 00 00 40 9E 01 FC 93 BF 00 14 80 1E 00 00 81 3F 00 10 70 00 80 00 93 DF 00 08 39 29 00 01 91 3F 00 10 40 82 00 50 80 7E 00 48 3B A2 8B 60 81 23 00 08 7F 89 E8 00 41 9E 00 30 39 60 00 01 7D 20 18 28 7C 09 00 00 40 82 00 0C 7D 60 19 2D 40 A2 FF F0 4C 00 01 2C 2F 89 00 00 40 9E 01 AC 80 7E 00 48 93 A3 00 08 81 23 00 04 38 09 00 01 90 03 00 04 3D 20 ?? ?? 81 69 ?? ?? 2F 8B 00 00 41 9E 00 40 7F 9E 58 00 41 9E 01 40 81 2B 00 34 2F 89 00 00 41 9E 00 2C 7F 9E 48 00 39 6B 00 34 40 BE 00 0C 48 00 00 B8 41 9A 00 B4 39 69 00 34 81 29 00 34 2F 89 00 00 7F 1E 48 00 40 9E FF EC 80 1E 00 00 70 09 80 00 54 00 06 6E 90 1E 00 00 40 82 00 1C 80 7E 00 48 81 23 00 04 38 09 FF FF 2F 80 00 00 90 03 00 04 41 9E 00 A4 81 3F 00 10 38 09 FF FF 2F 80 00 00 90 1F 00 10 39 20 00 00 91 3F 00 08 40 9E 00 24 90 1F 00 14 38 7F 00 0C 7C 00 04 AC 7D 20 18 28 7C 00 19 2D 40 A2 FF F8 2F 89 00 01 41 9D 00 BC 41 B2 00 10 38 61 00 08 38 80 00 00 4? ?? ?? ?? 80 01 00 34 81 81 00 20 7C 08 03 A6 83 A1 00 24 83 C1 00 28 7D 80 81 20 83 E1 00 2C 38 21 00 30 4E 80 00 20 81 5F 00 18 81 3E 00 34 38 0A 00 01 91 2B 00 00 90 1F 00 18 4B FF FF 50 3C 80 ?? ?? 38 61 00 08 38 84 ?? ?? 38 A0 00 00 4? ?? ?? ?? 4B FF FE 3C 90 03 00 08 7C 00 04 AC 7D 20 18 28 7C 00 19 2D 40 A2 FF F8 2F 89 00 01 40 9D FF 48 80 82 8B 68 38 00 00 DD 38 A0 00 01 60 84 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF 28 81 5F 00 18 81 7E 00 34 38 0A 00 01 91 69 ?? ?? 90 1F 00 18 4B FF FE E4 80 82 8B 68 38 00 00 DD 38 A0 00 01 60 84 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF 2C 4? ?? ?? ?? 4B FF FE 04 4? ?? ?? ?? 4B FF FE 54 }
	condition:
		$1
}

rule file_316_3_0 {
	meta:
		name = "_IO_link_in"
		size = 604
		refs = "0032 _pthread_cleanup_push_defer 011a _IO_list_all 0190 _pthread_cleanup_pop_restore 022c __lll_lock_wait_private"
	strings:
		$1 = { 94 21 FF D0 7C 08 02 A6 7D 80 00 26 90 01 00 34 80 03 00 00 93 C1 00 28 7C 7E 1B 78 70 09 00 80 93 A1 00 24 93 E1 00 2C 91 81 00 20 40 82 01 68 3D 20 ?? ?? 39 29 ?? ?? 7D 29 00 34 55 29 D9 7E 69 29 00 01 2E 09 00 00 60 00 00 80 90 03 00 00 40 92 01 88 3D 60 ?? ?? 91 21 00 0C 38 0B ?? ?? 90 01 00 08 3F E0 ?? ?? 3B FF ?? ?? 80 1F 00 14 3B A2 8B 60 7F 80 E8 00 41 9E 00 34 38 7F 00 0C 39 60 00 01 39 20 00 00 7C 00 18 28 7C 00 48 00 40 82 00 0C 7D 60 19 2D 40 A2 FF F0 4C 00 01 2C 2F 80 00 00 40 9E 01 88 93 BF 00 14 80 1E 00 00 81 3F 00 10 70 0B 80 00 93 DF 00 08 39 29 00 01 91 3F 00 10 40 82 00 F4 80 7E 00 48 3B A2 8B 60 81 23 00 08 7F 89 E8 00 41 9E 00 34 39 20 00 01 7C 00 18 28 7C 00 58 00 40 82 00 0C 7D 20 19 2D 40 A2 FF F0 4C 00 01 2C 2F 80 00 00 40 9E 01 58 80 7E 00 48 80 1E 00 00 93 A3 00 08 70 09 80 00 80 FF 00 18 81 23 00 04 3D 60 ?? ?? 81 4B ?? ?? 38 07 00 01 39 09 00 01 93 CB ?? ?? 91 03 00 04 90 1F 00 18 91 5E 00 34 40 82 00 10 2F 89 00 00 91 23 00 04 41 9E 00 AC 81 3F 00 10 38 09 FF FF 2F 80 00 00 90 1F 00 10 39 20 00 00 91 3F 00 08 40 9E 00 24 90 1F 00 14 38 7F 00 0C 7C 00 04 AC 7D 20 18 28 7C 00 19 2D 40 A2 FF F8 2F 89 00 01 41 9D 00 B4 41 B2 00 10 38 61 00 08 38 80 00 00 4? ?? ?? ?? 80 01 00 34 81 81 00 20 7C 08 03 A6 83 A1 00 24 83 C1 00 28 7D 80 81 20 83 E1 00 2C 38 21 00 30 4E 80 00 20 3D 20 ?? ?? 81 5F 00 18 81 69 ?? ?? 38 0A 00 01 93 C9 ?? ?? 91 7E 00 34 90 1F 00 18 4B FF FF 74 3C 80 ?? ?? 38 61 00 08 38 84 ?? ?? 38 A0 00 00 4? ?? ?? ?? 4B FF FE 78 91 23 00 08 7C 00 04 AC 7C 00 18 28 7D 20 19 2D 40 A2 FF F8 2F 80 00 01 40 9D FF 40 80 82 8B 68 38 00 00 DD 38 A0 00 01 60 84 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF 20 4? ?? ?? ?? 4B FF FE 78 80 82 8B 68 38 00 00 DD 38 A0 00 01 60 84 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF 34 4? ?? ?? ?? 4B FF FE A8 }
	condition:
		$1
}

rule file_316_4_0 {
	meta:
		name = "_IO_least_marker"
		size = 52
	strings:
		$1 = { 81 23 00 30 80 03 00 0C 2F 89 00 00 7C 60 20 50 4D 9E 00 20 81 69 00 08 7F 83 58 00 40 9D 00 08 7D 63 5B 78 81 29 00 00 2F 89 00 00 40 9E FF E8 4E 80 00 20 }
	condition:
		$1
}

rule file_316_5_0 {
	meta:
		name = "_IO_switch_to_main_get_area"
		size = 52
	strings:
		$1 = { 81 03 00 00 80 03 00 24 81 63 00 08 55 08 06 2C 81 43 00 2C 81 23 00 0C 91 03 00 00 91 43 00 08 91 63 00 2C 90 03 00 0C 91 23 00 24 90 03 00 04 4E 80 00 20 }
	condition:
		$1
}

rule file_316_6_0 {
	meta:
		name = "_IO_switch_to_backup_area"
		size = 52
	strings:
		$1 = { 81 03 00 00 80 03 00 2C 81 43 00 08 61 08 01 00 81 23 00 0C 81 63 00 24 91 03 00 00 90 03 00 08 91 43 00 2C 91 63 00 0C 91 23 00 24 90 03 00 04 4E 80 00 20 }
	condition:
		$1
}

rule file_316_7_0 {
	meta:
		name = "_IO_switch_to_get_mode"
		size = 168
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 80 03 00 14 81 23 00 10 93 E1 00 0C 7C 7F 1B 78 7F 80 48 40 41 9D 00 60 81 3F 00 00 71 2B 01 00 40 82 00 48 81 5F 00 08 81 7F 00 1C 7F 8A 00 40 91 7F 00 0C 40 9C 00 08 90 1F 00 08 55 29 05 66 90 1F 00 04 38 60 00 00 90 1F 00 18 90 1F 00 10 91 3F 00 00 80 01 00 14 83 E1 00 0C 38 21 00 10 7C 08 03 A6 4E 80 00 20 81 7F 00 28 91 7F 00 0C 4B FF FF CC 81 23 00 98 38 80 FF FF 80 09 00 0C 7C 09 03 A6 4E 80 04 21 2F 83 FF FF 38 60 FF FF 41 BE FF C4 80 1F 00 14 4B FF FF 80 }
	condition:
		$1
}

rule file_316_8_0 {
	meta:
		name = "_IO_free_backup_area"
		size = 160
		refs = "004c free"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 80 03 00 00 93 E1 00 0C 7C 7F 1B 78 70 09 01 00 41 82 00 58 81 23 00 24 54 00 06 2C 81 63 00 08 81 43 00 2C 80 63 00 0C 90 1F 00 00 91 5F 00 08 91 7F 00 2C 91 3F 00 0C 90 7F 00 24 91 3F 00 04 4? ?? ?? ?? 38 00 00 00 90 1F 00 24 90 1F 00 2C 90 1F 00 28 80 01 00 14 83 E1 00 0C 38 21 00 10 7C 08 03 A6 4E 80 00 20 80 63 00 24 4? ?? ?? ?? 38 00 00 00 90 1F 00 24 90 1F 00 2C 90 1F 00 28 80 01 00 14 83 E1 00 0C 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_316_9_0 {
	meta:
		name = "__overflow"
		size = 64
	strings:
		$1 = { 7C 08 02 A6 94 21 FF F0 90 01 00 14 80 03 00 6C 2F 80 00 00 40 9E 00 0C 38 00 FF FF 90 03 00 6C 81 23 00 98 80 09 00 0C 7C 09 03 A6 4E 80 04 21 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_316_10_0 {
	meta:
		name = "__underflow"
		size = 316
		refs = "006c _IO_free_backup_area 010c _IO_switch_to_get_mode"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 80 03 00 6C 93 E1 00 0C 7C 7F 1B 78 2F 80 00 00 40 9E 00 7C 38 00 FF FF 90 03 00 6C 80 1F 00 00 70 09 08 00 40 82 00 D8 81 3F 00 04 80 1F 00 08 7F 89 00 40 41 9C 00 B0 81 3F 00 00 71 2B 01 00 40 82 00 6C 80 1F 00 30 2F 80 00 00 40 9E 00 C8 80 1F 00 24 2F 80 00 00 41 9E 00 0C 7F E3 FB 78 4? ?? ?? ?? 81 3F 00 98 7F E3 FB 78 80 09 00 10 7C 09 03 A6 4E 80 04 21 80 01 00 14 83 E1 00 0C 38 21 00 10 7C 08 03 A6 4E 80 00 20 2F 80 FF FF 38 60 FF FF 41 BE FF 88 80 01 00 14 83 E1 00 0C 38 21 00 10 7C 08 03 A6 4E 80 00 20 81 7F 00 24 55 29 06 2C 81 5F 00 2C 81 1F 00 0C 7F 8A 58 40 91 3F 00 00 91 5F 00 08 90 1F 00 2C 91 7F 00 0C 91 1F 00 24 91 7F 00 04 40 9D FF 6C 88 6B 00 00 4B FF FF B8 80 01 00 14 88 69 00 00 7C 08 03 A6 83 E1 00 0C 38 21 00 10 4E 80 00 20 7F E3 FB 78 4? ?? ?? ?? 2F 83 FF FF 38 60 FF FF 40 9E FF 1C 4B FF FF 88 80 9F 00 08 7F E3 FB 78 4B FF F5 BD 2F 83 00 00 38 60 FF FF 41 9E FF 3C 4B FF FF 6C }
	condition:
		$1
}

rule file_316_11_0 {
	meta:
		name = "__uflow"
		size = 332
		refs = "006c _IO_free_backup_area 011c _IO_switch_to_get_mode"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 80 03 00 6C 93 E1 00 0C 7C 7F 1B 78 2F 80 00 00 40 9E 00 7C 38 00 FF FF 90 03 00 6C 80 1F 00 00 70 09 08 00 40 82 00 E8 81 3F 00 04 80 1F 00 08 7F 89 00 40 41 9C 00 B8 81 3F 00 00 71 2B 01 00 40 82 00 6C 80 1F 00 30 2F 80 00 00 40 9E 00 D8 80 1F 00 24 2F 80 00 00 41 9E 00 0C 7F E3 FB 78 4? ?? ?? ?? 81 3F 00 98 7F E3 FB 78 80 09 00 14 7C 09 03 A6 4E 80 04 21 80 01 00 14 83 E1 00 0C 38 21 00 10 7C 08 03 A6 4E 80 00 20 2F 80 FF FF 38 60 FF FF 41 BE FF 88 80 01 00 14 83 E1 00 0C 38 21 00 10 7C 08 03 A6 4E 80 00 20 81 7F 00 24 55 29 06 2C 81 5F 00 2C 81 1F 00 0C 7F 8A 58 40 91 3F 00 00 91 5F 00 08 90 1F 00 2C 91 7F 00 0C 91 1F 00 24 91 7F 00 04 40 9D FF 6C 38 0B 00 01 88 6B 00 00 90 1F 00 04 4B FF FF B0 38 09 00 01 88 69 00 00 90 1F 00 04 80 01 00 14 83 E1 00 0C 38 21 00 10 7C 08 03 A6 4E 80 00 20 7F E3 FB 78 4? ?? ?? ?? 2F 83 FF FF 38 60 FF FF 40 9E FF 0C 4B FF FF 78 80 9F 00 08 7F E3 FB 78 4B FF F4 71 2F 83 00 00 38 60 FF FF 41 9E FF 2C 4B FF FF 5C }
	condition:
		$1
}

rule file_316_12_0 {
	meta:
		name = "_IO_setb"
		size = 188
		refs = "00a0 __munmap"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 90 01 00 24 80 03 00 1C 93 C1 00 18 7C 9E 23 78 2F 80 00 00 93 E1 00 1C 7C 7F 1B 78 41 9E 00 90 81 23 00 00 71 2B 00 01 41 82 00 54 2F 86 00 00 93 DF 00 1C 90 BF 00 20 40 9E 00 24 80 01 00 24 61 29 00 01 91 3F 00 00 7C 08 03 A6 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 80 01 00 24 55 29 00 3C 91 3F 00 00 7C 08 03 A6 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 81 23 00 20 7C 03 03 78 90 A1 00 08 39 29 0F FF 7C 00 48 50 90 C1 00 0C 54 04 00 26 4? ?? ?? ?? 81 3F 00 00 80 C1 00 0C 80 A1 00 08 4B FF FF 84 81 23 00 00 4B FF FF 7C }
	condition:
		$1
}

rule file_316_13_0 {
	meta:
		name = "_IO_doallocbuf"
		size = 140
		refs = "0088 _IO_setb"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 80 03 00 1C 93 E1 00 0C 7C 7F 1B 78 2F 80 00 00 41 9E 00 18 80 01 00 14 83 E1 00 0C 38 21 00 10 7C 08 03 A6 4E 80 00 20 80 03 00 00 70 09 00 02 41 82 00 10 80 03 00 6C 2F 80 00 00 40 9D 00 20 81 3F 00 98 7F E3 FB 78 80 09 00 34 7C 09 03 A6 4E 80 04 21 2F 83 FF FF 40 9E FF BC 80 01 00 14 7F E3 FB 78 38 9F 00 47 7C 08 03 A6 38 BF 00 48 38 C0 00 00 83 E1 00 0C 38 21 00 10 4? ?? ?? ?? }
	condition:
		$1
}

rule file_316_15_0 {
	meta:
		name = "_IO_default_uflow"
		size = 84
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 81 23 00 98 93 E1 00 0C 7C 7F 1B 78 80 09 00 10 7C 09 03 A6 4E 80 04 21 2F 83 FF FF 38 60 FF FF 41 9E 00 14 81 3F 00 04 38 09 00 01 88 69 00 00 90 1F 00 04 80 01 00 14 83 E1 00 0C 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_316_16_0 {
	meta:
		name = "_IO_default_xsputn"
		size = 264
		refs = "00d0 mempcpy"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 93 61 00 0C 7C BB 2B 79 93 C1 00 18 7C 7E 1B 78 38 60 00 00 90 01 00 24 93 81 00 10 93 A1 00 14 93 E1 00 1C 41 82 00 B8 7C 9D 23 78 7F 7F DB 78 80 7E 00 14 80 1E 00 18 7F 83 00 40 40 9C 00 50 7C 03 00 50 7F 9F 00 40 7F FC FB 78 40 9D 00 08 7C 1C 03 78 2B 9C 00 14 41 9D 00 68 2F 9C 00 00 41 9E 00 28 7F 89 03 A6 39 7D FF FF 39 23 FF FF 8C 0B 00 01 9C 09 00 01 42 00 FF F8 7C 63 E2 14 90 7E 00 14 7F BD E2 14 7F FC F8 50 2F 9F 00 00 41 9E 00 48 81 3E 00 98 7F C3 F3 78 88 9D 00 00 80 09 00 0C 7C 09 03 A6 4E 80 04 21 2F 83 FF FF 41 9E 00 28 3B BD 00 01 3B FF FF FF 4B FF FF 74 7F A4 EB 78 7F 85 E3 78 4? ?? ?? ?? 7F BD E2 14 90 7E 00 14 4B FF FF B4 7C 7F D8 50 80 01 00 24 83 61 00 0C 7C 08 03 A6 83 81 00 10 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 }
	condition:
		$1
}

rule file_316_17_0 {
	meta:
		name = "_IO_sgetn"
		size = 44
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 81 23 00 98 80 09 00 20 7C 09 03 A6 4E 80 04 21 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_316_18_0 {
	meta:
		name = "_IO_default_xsgetn"
		size = 240
		refs = "0098 __underflow 00d8 mempcpy"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 93 A1 00 14 90 01 00 24 93 61 00 0C 7C 9B 23 78 93 81 00 10 7C BC 2B 78 93 C1 00 18 7C BE 2B 78 93 E1 00 1C 7C 7F 1B 78 81 3F 00 04 80 1F 00 08 7F 89 00 40 40 9C 00 50 7C 09 00 50 7F 9E 00 40 7F DD F3 78 40 9D 00 08 7C 1D 03 78 2B 9D 00 14 41 9D 00 74 2F 9D 00 00 41 9E 00 28 7F A9 03 A6 39 49 FF FF 39 7B FF FF 8C 0A 00 01 9C 0B 00 01 42 00 FF F8 7D 29 EA 14 91 3F 00 04 7F 7B EA 14 7F DD F0 50 2F 9E 00 00 41 9E 00 14 7F E3 FB 78 4? ?? ?? ?? 2F 83 FF FF 40 9E FF 90 80 01 00 24 7C 7E E0 50 83 61 00 0C 7C 08 03 A6 83 81 00 10 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 7F 63 DB 78 7D 24 4B 78 7F A5 EB 78 4? ?? ?? ?? 80 1F 00 04 7C 7B 1B 78 7C 00 EA 14 90 1F 00 04 4B FF FF 9C }
	condition:
		$1
}

rule file_316_19_0 {
	meta:
		name = "_IO_default_setbuf"
		size = 240
		refs = "0068 _IO_setb"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 90 01 00 24 81 23 00 98 93 A1 00 14 7C BD 2B 78 80 09 00 30 93 C1 00 18 7C 9E 23 78 7C 09 03 A6 93 E1 00 1C 7C 7F 1B 78 4E 80 04 21 2F 83 FF FF 41 9E 00 94 2F 9E 00 00 41 9E 00 0C 2F 9D 00 00 40 9E 00 60 80 1F 00 00 7F E3 FB 78 38 9F 00 47 60 00 00 02 90 1F 00 00 38 BF 00 48 38 C0 00 00 4? ?? ?? ?? 38 00 00 00 83 A1 00 14 90 1F 00 18 7F E3 FB 78 90 1F 00 14 90 1F 00 10 90 1F 00 08 90 1F 00 04 90 1F 00 0C 80 01 00 24 83 C1 00 18 7C 08 03 A6 83 E1 00 1C 38 21 00 20 4E 80 00 20 80 1F 00 00 7F C4 F3 78 7F E3 FB 78 54 00 07 FA 90 1F 00 00 7C BE EA 14 38 C0 00 00 4? ?? ?? ?? 4B FF FF A4 80 01 00 24 3B E0 00 00 7F E3 FB 78 83 A1 00 14 7C 08 03 A6 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 }
	condition:
		$1
}

rule file_316_20_0 {
	meta:
		name = "_IO_default_seekpos"
		size = 52
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 7C E8 3B 78 90 01 00 14 38 E0 00 00 81 23 00 98 80 09 00 24 7C 09 03 A6 4E 80 04 21 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_316_21_0 {
	meta:
		name = "_IO_default_doallocate"
		size = 108
		refs = "002c __mmap 004c _IO_setb"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 38 80 20 00 93 E1 00 0C 38 A0 00 03 7C 7F 1B 78 38 C0 00 22 90 01 00 14 38 60 00 00 38 E0 FF FF 39 00 00 00 4? ?? ?? ?? 38 00 FF FF 2F 83 FF FF 41 9E 00 1C 7C 64 1B 78 38 A4 20 00 7F E3 FB 78 38 C0 00 01 4? ?? ?? ?? 38 00 00 01 7C 03 03 78 80 01 00 14 83 E1 00 0C 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_316_22_0 {
	meta:
		name = "_IO_old_init"
		size = 100
	strings:
		$1 = { 81 23 00 48 38 00 00 00 64 84 FB AD 90 03 00 3C 2F 89 00 00 90 83 00 00 90 03 00 1C 90 03 00 20 90 03 00 0C 90 03 00 04 90 03 00 08 90 03 00 10 90 03 00 14 90 03 00 18 90 03 00 34 90 03 00 24 90 03 00 28 90 03 00 2C 90 03 00 30 B0 03 00 44 4D 9E 00 20 90 09 00 00 90 09 00 04 90 09 00 08 4E 80 00 20 }
	condition:
		$1
}

rule file_316_23_0 {
	meta:
		name = "_IO_no_init"
		size = 176
	strings:
		$1 = { 81 23 00 48 38 00 00 00 64 84 FB AD 90 03 00 3C 2F 89 00 00 90 83 00 00 90 03 00 1C 90 03 00 20 90 03 00 0C 90 03 00 04 90 03 00 08 90 03 00 10 90 03 00 14 90 03 00 18 90 03 00 34 90 03 00 24 90 03 00 28 90 03 00 2C 90 03 00 30 B0 03 00 44 41 9E 00 10 90 09 00 00 90 09 00 04 90 09 00 08 2F 85 00 00 90 A3 00 6C 41 9C 00 3C 38 00 00 00 90 C3 00 5C 90 06 00 18 90 06 00 1C 90 06 00 08 90 06 00 00 90 06 00 04 90 06 00 0C 90 06 00 10 90 06 00 14 90 06 00 20 90 06 00 24 90 06 00 28 90 E6 00 B8 38 00 00 00 90 03 00 60 4E 80 00 20 }
	condition:
		$1
}

rule file_316_24_0 {
	meta:
		name = "_IO_init"
		size = 16
		refs = "000c _IO_no_init"
	strings:
		$1 = { 38 A0 FF FF 38 C0 00 00 38 E0 00 00 4? ?? ?? ?? }
	condition:
		$1
}

rule file_316_26_0 {
	meta:
		name = "_IO_default_finish"
		size = 168
		refs = "005c free 0080 _IO_un_link 0098 __munmap"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 80 03 00 1C 93 E1 00 0C 7C 7F 1B 78 2F 80 00 00 93 C1 00 08 41 9E 00 10 83 C3 00 00 73 DE 00 01 41 82 00 58 81 3F 00 30 2F 89 00 00 41 9E 00 18 38 00 00 00 90 09 00 04 81 29 00 00 2F 89 00 00 40 9E FF F4 80 7F 00 24 2F 83 00 00 41 9E 00 10 4? ?? ?? ?? 38 00 00 00 90 1F 00 24 80 01 00 14 7F E3 FB 78 83 C1 00 08 7C 08 03 A6 83 E1 00 0C 38 21 00 10 4? ?? ?? ?? 81 23 00 20 7C 03 03 78 39 29 0F FF 7C 00 48 50 54 04 00 26 4? ?? ?? ?? 93 DF 00 20 93 DF 00 1C 4B FF FF 8C }
	condition:
		$1
}

rule file_316_28_0 {
	meta:
		name = "_IO_sputbackc"
		size = 124
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 81 23 00 04 80 03 00 0C 93 E1 00 0C 7C 7F 1B 78 7F 89 00 40 40 9D 00 18 88 69 FF FF 54 80 06 3E 39 29 FF FF 7F 83 00 00 41 9E 00 40 81 3F 00 98 7F E3 FB 78 80 09 00 18 7C 09 03 A6 4E 80 04 21 2F 83 FF FF 41 9E 00 10 80 1F 00 00 54 00 07 34 90 1F 00 00 80 01 00 14 83 E1 00 0C 38 21 00 10 7C 08 03 A6 4E 80 00 20 91 3F 00 04 4B FF FF DC }
	condition:
		$1
}

rule file_316_29_0 {
	meta:
		name = "_IO_sungetc"
		size = 128
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 81 23 00 04 80 03 00 0C 93 E1 00 0C 7C 7F 1B 78 7F 89 00 40 40 9D 00 30 38 09 FF FF 90 03 00 04 88 69 FF FF 80 1F 00 00 54 00 07 34 90 1F 00 00 80 01 00 14 83 E1 00 0C 38 21 00 10 7C 08 03 A6 4E 80 00 20 81 23 00 98 38 80 FF FF 80 09 00 18 7C 09 03 A6 4E 80 04 21 2F 83 FF FF 40 BE FF C8 80 01 00 14 83 E1 00 0C 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_316_30_0 {
	meta:
		name = "_IO_adjust_column"
		size = 76
	strings:
		$1 = { 7D 24 2A 14 7F 84 48 40 40 9C 00 3C 88 09 FF FF 39 29 FF FF 7D 2B 4B 78 2F 80 00 0A 41 9E 00 20 7C 84 48 50 38 84 00 01 7C 89 03 A6 42 40 00 18 8C 0B FF FF 2F 80 00 0A 40 9E FF F4 7C 6B 48 50 4E 80 00 20 7C 65 1A 14 4E 80 00 20 }
	condition:
		$1
}

rule file_316_31_0 {
	meta:
		name = "_IO_flush_all_lockp"
		size = 760
		refs = "000a _pthread_cleanup_push_defer 0072 _IO_list_all 01b4 _pthread_cleanup_pop_restore 02c4 __lll_lock_wait_private"
	strings:
		$1 = { 94 21 FF C0 7C 08 02 A6 3D 20 ?? ?? 7D 80 00 26 90 01 00 44 38 09 ?? ?? 7C 00 00 34 54 00 D9 7E 93 E1 00 3C 68 00 00 01 2D 80 00 00 93 21 00 24 7C 7F 1B 78 93 41 00 28 93 61 00 2C 93 81 00 30 93 A1 00 34 93 C1 00 38 91 81 00 20 40 8E 02 60 3D 20 ?? ?? 90 01 00 0C 39 29 ?? ?? 91 21 00 08 2E 1F 00 00 40 92 01 B0 3F C0 ?? ?? 3B DE ?? ?? 3F 80 ?? ?? 83 BE 00 18 83 FC ?? ?? 3B 60 00 00 2F 9F 00 00 41 9E 01 0C 3B 40 00 01 93 FE 00 08 41 92 00 58 80 1F 00 00 70 00 80 00 40 82 00 4C 80 7F 00 48 3B 22 8B 60 81 23 00 08 7F 89 C8 00 41 9E 00 2C 7D 20 18 28 7C 09 00 00 40 82 00 0C 7F 40 19 2D 40 A2 FF F0 4C 00 01 2C 2F 89 00 00 40 9E 01 F4 80 7F 00 48 93 23 00 08 81 23 00 04 38 09 00 01 90 03 00 04 80 1F 00 6C 2F 80 00 00 40 9D 01 10 81 3F 00 5C 81 69 00 10 80 09 00 0C 7F 8B 00 40 40 9D 00 24 81 3F 00 98 7F E3 FB 78 38 80 FF FF 80 09 00 0C 7C 09 03 A6 4E 80 04 21 2F 83 FF FF 41 9E 00 CC 41 92 00 44 80 1F 00 00 70 09 80 00 40 82 00 38 80 7F 00 48 81 23 00 04 38 09 FF FF 2F 80 00 00 90 03 00 04 40 9E 00 20 90 03 00 08 7C 00 04 AC 7D 20 18 28 7C 00 19 2D 40 A2 FF F8 2F 89 00 01 41 9D 01 64 80 1E 00 18 39 20 00 00 91 3E 00 08 7F 9D 00 00 41 9E 00 7C 83 FC ?? ?? 7C 1D 03 78 2F 9F 00 00 40 9E FF 00 41 92 00 18 81 3E 00 10 38 09 FF FF 2F 80 00 00 90 1E 00 10 41 9E 00 C8 41 AE 00 10 38 61 00 08 38 80 00 00 4? ?? ?? ?? 80 01 00 44 7F 63 DB 78 81 81 00 20 7C 08 03 A6 83 21 00 24 83 41 00 28 7D 81 81 20 83 61 00 2C 83 81 00 30 83 A1 00 34 83 C1 00 38 83 E1 00 3C 38 21 00 40 4E 80 00 20 3B 60 FF FF 4B FF FF 34 83 FF 00 34 4B FF FF 8C 81 3F 00 14 80 1F 00 10 7F 89 00 40 41 BD FE FC 4B FF FF 18 3F C0 ?? ?? 3B DE ?? ?? 80 1E 00 14 3B E2 8B 60 7F 80 F8 00 41 9E 00 34 38 7E 00 0C 39 60 00 01 39 20 00 00 7C 00 18 28 7C 00 48 00 40 82 00 0C 7D 60 19 2D 40 A2 FF F0 4C 00 01 2C 2F 80 00 00 40 9E 00 98 93 FE 00 14 81 3E 00 10 38 09 00 01 90 1E 00 10 4B FF FE 08 90 1E 00 14 38 7E 00 0C 7C 00 04 AC 7D 20 18 28 7C 00 19 2D 40 A2 FF F8 2F 89 00 01 40 9D FF 20 80 82 8B 68 38 00 00 DD 38 A0 00 01 60 84 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF 00 3C 80 ?? ?? 38 61 00 08 38 84 ?? ?? 38 A0 00 00 4? ?? ?? ?? 4B FF FD A0 4? ?? ?? ?? 4B FF FE 0C 80 82 8B 68 38 00 00 DD 38 A0 00 01 60 84 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FE 84 4? ?? ?? ?? 93 FE 00 14 4B FF FF 68 }
	condition:
		$1
}

rule file_316_32_0 {
	meta:
		name = "_IO_cleanup"
		size = 528
		refs = "002c _IO_flush_all_lockp 0032 _IO_list_all 013c __sched_yield"
	strings:
		$1 = { 94 21 FF D0 7C 08 02 A6 38 60 00 00 93 41 00 18 93 E1 00 2C 90 01 00 34 93 21 00 14 93 61 00 1C 93 81 00 20 93 A1 00 24 93 C1 00 28 4? ?? ?? ?? 3D 20 ?? ?? 83 E9 ?? ?? 7C 7A 1B 78 2F 9F 00 00 41 9E 00 CC 3B A0 00 01 3F 80 ?? ?? 3B 60 00 01 3B C0 FF FF 80 1F 00 00 70 09 00 02 40 82 00 A0 70 00 10 08 2F 80 00 08 41 9E 00 94 80 1F 00 6C 2F 80 00 00 41 9E 00 88 81 3F 00 48 38 02 8B 60 3B 20 00 00 81 69 00 08 7F 80 58 00 41 9E 00 D4 7D 60 48 28 2C 0B 00 00 40 82 00 0C 7F A0 49 2D 40 A2 FF F0 4C 00 01 2C 2F 8B 00 00 40 9E 00 90 81 3F 00 48 90 09 00 08 93 69 00 04 88 1C ?? ?? 39 3C ?? ?? 2F 80 00 00 40 9E 00 10 80 1F 00 00 70 0B 00 01 41 82 00 9C 81 3F 00 98 7F E3 FB 78 38 80 00 00 80 09 00 2C 38 A0 00 00 7C 09 03 A6 4E 80 04 21 2F 99 00 01 40 9D 00 C4 93 DF 00 6C 83 FF 00 34 2F 9F 00 00 40 9E FF 4C 80 01 00 34 7F 43 D3 78 83 21 00 14 7C 08 03 A6 83 41 00 18 83 61 00 1C 83 81 00 20 83 A1 00 24 83 C1 00 28 83 E1 00 2C 38 21 00 30 4E 80 00 20 4? ?? ?? ?? 2F 99 00 01 3B 39 00 01 41 BE FF 74 81 3F 00 48 38 02 8B 60 81 69 00 08 7F 80 58 00 40 9E FF 34 81 69 00 04 38 0B 00 01 90 09 00 04 4B FF FF 50 81 09 00 04 60 00 00 01 93 E9 00 04 7F E3 FB 78 38 80 00 00 81 3F 00 98 38 A0 00 00 81 7F 00 1C 81 5F 00 20 90 1F 00 00 7D 4B 50 50 80 09 00 2C 91 1F 00 60 7C 09 03 A6 91 7F 00 64 91 5F 00 68 4E 80 04 21 2F 99 00 01 41 9D FF 44 80 7F 00 48 81 23 00 04 38 09 FF FF 2F 80 00 00 90 03 00 04 40 BE FF 2C 90 03 00 08 7C 00 04 AC 7D 20 18 28 7C 00 19 2D 40 A2 FF F8 2F 89 00 01 40 9D FF 10 80 82 8B 68 38 00 00 DD 38 A0 00 01 60 84 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FE F0 }
	condition:
		$1
}

rule file_316_34_0 {
	meta:
		name = "_IO_flush_all_linebuffered"
		size = 664
		refs = "000a _pthread_cleanup_push_defer 00a2 _IO_list_all 01e0 _pthread_cleanup_pop_restore 0248 __lll_lock_wait_private"
		altNames = "_flushlbf"
	strings:
		$1 = { 94 21 FF C0 7C 08 02 A6 3D 20 ?? ?? 7D 80 00 26 90 01 00 44 38 09 ?? ?? 7C 00 00 34 54 00 D9 7E 93 41 00 28 68 00 00 01 2E 00 00 00 93 61 00 2C 93 81 00 30 93 A1 00 34 93 C1 00 38 93 E1 00 3C 91 81 00 24 40 92 01 EC 3D 20 ?? ?? 90 01 00 0C 39 29 ?? ?? 91 21 00 08 3F C0 ?? ?? 3B DE ?? ?? 80 1E 00 14 3B E2 8B 60 7F 80 F8 00 41 9E 00 34 38 7E 00 0C 39 60 00 01 39 20 00 00 7C 00 18 28 7C 00 48 00 40 82 00 0C 7D 60 19 2D 40 A2 FF F0 4C 00 01 2C 2F 80 00 00 40 9E 01 F8 93 FE 00 14 3F 80 ?? ?? 81 3E 00 10 83 FC ?? ?? 39 29 00 01 83 BE 00 18 2F 9F 00 00 91 3E 00 10 41 9E 00 E8 3B 60 00 01 48 00 00 14 83 FC ?? ?? 7C 1D 03 78 2F 9F 00 00 41 9E 00 CC 80 1F 00 00 93 FE 00 08 70 00 80 00 40 82 00 4C 80 7F 00 48 3B 42 8B 60 81 23 00 08 7F 89 D0 00 41 9E 00 2C 7D 20 18 28 7C 09 00 00 40 82 00 0C 7F 60 19 2D 40 A2 FF F0 4C 00 01 2C 2F 89 00 00 40 9E 01 30 80 7F 00 48 93 43 00 08 81 23 00 04 38 09 00 01 90 03 00 04 80 1F 00 00 70 00 02 08 2F 80 02 00 41 9E 00 D8 80 1F 00 00 70 09 80 00 40 82 00 38 80 7F 00 48 81 23 00 04 38 09 FF FF 2F 80 00 00 90 03 00 04 40 9E 00 20 90 03 00 08 7C 00 04 AC 7D 20 18 28 7C 00 19 2D 40 A2 FF F8 2F 89 00 01 41 9D 00 D4 80 1E 00 18 39 20 00 00 91 3E 00 08 7F 9D 00 00 40 9E FF 38 83 FF 00 34 2F 9F 00 00 40 9E FF 3C 81 3E 00 10 38 09 FF FF 2F 80 00 00 90 1E 00 10 40 9E 00 24 90 1E 00 14 38 7E 00 0C 7C 00 04 AC 7D 20 18 28 7C 00 19 2D 40 A2 FF F8 2F 89 00 01 41 9D 00 A0 41 B2 00 10 38 61 00 08 38 80 00 00 4? ?? ?? ?? 80 01 00 44 81 81 00 24 7C 08 03 A6 83 41 00 28 83 61 00 2C 7D 80 81 20 83 81 00 30 83 A1 00 34 83 C1 00 38 83 E1 00 3C 38 21 00 40 4E 80 00 20 81 3F 00 98 7F E3 FB 78 38 80 FF FF 80 09 00 0C 7C 09 03 A6 4E 80 04 21 4B FF FF 14 3C 80 ?? ?? 38 61 00 08 38 84 ?? ?? 38 A0 00 00 4? ?? ?? ?? 4B FF FE 14 4? ?? ?? ?? 4B FF FE D0 80 82 8B 68 38 00 00 DD 38 A0 00 01 60 84 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF 14 80 82 8B 68 38 00 00 DD 38 A0 00 01 60 84 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF 48 4? ?? ?? ?? 4B FF FE 08 }
	condition:
		$1
}

rule file_316_35_0 {
	meta:
		name = "_IO_init_marker"
		size = 164
		refs = "0094 _IO_switch_to_get_mode"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 90 01 00 24 80 04 00 00 93 E1 00 1C 7C 7F 1B 78 70 09 08 00 90 83 00 04 40 82 00 6C 70 09 01 00 40 82 00 34 81 24 00 04 80 04 00 0C 7C 00 48 50 90 1F 00 08 80 04 00 30 90 1F 00 00 80 01 00 24 93 E4 00 30 7C 08 03 A6 83 E1 00 1C 38 21 00 20 4E 80 00 20 81 24 00 04 80 04 00 08 7C 00 48 50 90 1F 00 08 80 04 00 30 90 1F 00 00 80 01 00 24 93 E4 00 30 7C 08 03 A6 83 E1 00 1C 38 21 00 20 4E 80 00 20 7C 83 23 78 90 81 00 08 4? ?? ?? ?? 80 81 00 08 80 04 00 00 4B FF FF 84 }
	condition:
		$1
}

rule file_316_36_0 {
	meta:
		name = "_IO_remove_marker"
		size = 72
	strings:
		$1 = { 81 63 00 04 81 2B 00 30 2F 89 00 00 4D 9E 00 20 7F 83 48 00 39 6B 00 30 40 BE 00 0C 48 00 00 20 41 9A 00 1C 7D 2B 4B 78 81 29 00 00 2F 89 00 00 7F 03 48 00 40 9E FF EC 4E 80 00 20 80 03 00 00 90 0B 00 00 4E 80 00 20 }
	condition:
		$1
}

rule file_316_37_0 {
	meta:
		name = "_IO_marker_difference"
		size = 16
	strings:
		$1 = { 80 03 00 08 80 64 00 08 7C 63 00 50 4E 80 00 20 }
	condition:
		$1
}

rule file_316_38_0 {
	meta:
		name = "_IO_marker_delta"
		size = 80
	strings:
		$1 = { 81 23 00 04 7C 6B 1B 78 38 60 FF FF 2F 89 00 00 4D 9E 00 20 80 09 00 00 70 0A 01 00 40 82 00 1C 80 09 00 0C 80 69 00 04 7C 60 18 50 80 0B 00 08 7C 63 00 50 4E 80 00 20 80 09 00 08 80 69 00 04 7C 60 18 50 80 0B 00 08 7C 63 00 50 4E 80 00 20 }
	condition:
		$1
}

rule file_316_39_0 {
	meta:
		name = "_IO_seekmark"
		size = 180
	strings:
		$1 = { 81 24 00 04 38 00 FF FF 7F 89 18 00 41 9E 00 0C 7C 03 03 78 4E 80 00 20 80 04 00 08 2F 80 00 00 41 9C 00 4C 81 49 00 00 71 4B 01 00 41 82 00 78 80 E9 00 08 55 4A 06 2C 80 C9 00 2C 81 09 00 0C 81 69 00 24 91 49 00 00 90 C9 00 08 90 E9 00 2C 91 69 00 0C 91 09 00 24 7C 0B 02 14 90 09 00 04 38 00 00 00 7C 03 03 78 4E 80 00 20 81 49 00 00 71 4B 01 00 40 82 00 38 80 C9 00 08 61 4A 01 00 81 69 00 2C 81 09 00 0C 80 E9 00 24 91 49 00 00 91 69 00 08 90 C9 00 2C 90 E9 00 0C 91 09 00 24 4B FF FF B8 81 69 00 0C 4B FF FF B0 81 69 00 08 4B FF FF A8 }
	condition:
		$1
}

rule file_316_40_0 {
	meta:
		name = "_IO_unsave_markers"
		size = 36
		refs = "0020 _IO_free_backup_area"
	strings:
		$1 = { 80 03 00 30 2F 80 00 00 41 9E 00 0C 38 00 00 00 90 03 00 30 80 03 00 24 2F 80 00 00 4D 9E 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_1100_23_0 {
	meta:
		name = "_IO_unsave_wmarkers"
		size = 36
		refs = "0020 _IO_free_wbackup_area"
	strings:
		$1 = { 80 03 00 30 2F 80 00 00 41 9E 00 0C 38 00 00 00 90 03 00 30 80 03 00 24 2F 80 00 00 4D 9E 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_316_41_0 {
	meta:
		name = "_IO_default_pbackfail"
		size = 404
		refs = "00e8 malloc 014c memcpy 0158 free"
	strings:
		$1 = { 94 21 FF D0 7C 08 02 A6 90 01 00 34 93 41 00 18 93 61 00 1C 83 43 00 0C 83 63 00 04 93 C1 00 28 7C 9E 23 78 7F 9B D0 40 93 E1 00 2C 7C 7F 1B 78 93 21 00 14 93 81 00 20 93 A1 00 24 40 9D 00 4C 80 03 00 00 70 09 01 00 41 82 00 80 38 1B FF FF 57 C3 06 3E 90 1F 00 04 98 7B FF FF 80 01 00 34 83 21 00 14 7C 08 03 A6 83 41 00 18 83 61 00 1C 83 81 00 20 83 A1 00 24 83 C1 00 28 83 E1 00 2C 38 21 00 30 4E 80 00 20 80 03 00 00 70 09 01 00 40 82 00 8C 81 23 00 24 2F 89 00 00 41 9E 00 48 7F 6A DB 78 83 63 00 2C 81 7F 00 08 60 00 01 00 90 1F 00 00 93 7F 00 08 91 7F 00 2C 91 3F 00 0C 91 5F 00 24 4B FF FF 88 88 1B FF FF 39 3B FF FF 7F 80 20 00 41 9E 00 3C 80 03 00 24 2F 80 00 00 40 9E 00 8C 38 60 00 80 4? ?? ?? ?? 7C 69 1B 79 38 60 FF FF 41 A2 FF 68 39 69 00 80 80 1F 00 00 7F 6A DB 78 91 7F 00 28 7D 7B 5B 78 4B FF FF 9C 91 23 00 04 54 03 06 3E 4B FF FF 44 83 23 00 08 7F 3A C8 50 57 3C 08 3C 7F 83 E3 78 4? ?? ?? ?? 7C 7D 1B 79 38 60 FF FF 41 A2 FF 24 7F 7D CA 14 7F 44 D3 78 7F 25 CB 78 7F 63 DB 78 4? ?? ?? ?? 80 7F 00 0C 7F 9D E2 14 4? ?? ?? ?? 93 BF 00 0C 93 9F 00 08 93 7F 00 28 4B FF FE E4 7F 64 DB 78 4B FF E0 A1 2F 83 00 00 38 60 FF FF 40 BE FE E0 81 5F 00 04 83 7F 00 2C 81 3F 00 24 80 1F 00 00 4B FF FF 18 }
	condition:
		$1
}

rule file_316_52_0 {
	meta:
		name = "_IO_list_lock"
		size = 136
		refs = "0080 __lll_lock_wait_private"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 93 E1 00 0C 3F E0 ?? ?? 3B FF ?? ?? 90 01 00 14 80 1F 00 14 93 C1 00 08 3B C2 8B 60 7F 80 F0 00 41 9E 00 34 38 7F 00 0C 39 60 00 01 39 20 00 00 7C 00 18 28 7C 00 48 00 40 82 00 0C 7D 60 19 2D 40 A2 FF F0 4C 00 01 2C 2F 80 00 00 40 9E 00 2C 93 DF 00 14 81 3F 00 10 83 C1 00 08 38 09 00 01 90 1F 00 10 80 01 00 14 83 E1 00 0C 38 21 00 10 7C 08 03 A6 4E 80 00 20 4? ?? ?? ?? 4B FF FF D4 }
	condition:
		$1
}

rule file_316_53_0 {
	meta:
		name = "_IO_list_unlock"
		size = 92
	strings:
		$1 = { 3D 20 ?? ?? 39 29 ?? ?? 81 69 00 10 38 0B FF FF 2F 80 00 00 90 09 00 10 4C 9E 00 20 90 09 00 14 38 69 00 0C 7C 00 04 AC 7D 60 18 28 7C 00 19 2D 40 A2 FF F8 2F 8B 00 01 4C BD 00 20 80 82 8B 68 38 00 00 DD 38 A0 00 01 60 84 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4E 80 00 20 }
	condition:
		$1
}

rule file_316_54_0 {
	meta:
		name = "_IO_list_resetlock"
		size = 28
	strings:
		$1 = { 3D 20 ?? ?? 39 29 ?? ?? 38 00 00 00 90 09 00 0C 90 09 00 10 90 09 00 14 4E 80 00 20 }
	condition:
		$1
}

rule file_316_56_0 {
	meta:
		name = "buffer_free"
		size = 104
		refs = "003c __munmap"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 3D 60 ?? ?? 90 01 00 14 38 00 00 01 93 E1 00 0C 3B EB ?? ?? 81 3F 00 04 98 0B ?? ?? 2F 89 00 00 41 9E 00 2C 80 89 00 68 80 69 00 64 38 84 0F FF 54 84 00 26 4? ?? ?? ?? 81 3F 00 04 81 29 00 60 2F 89 00 00 91 3F 00 04 40 9E FF DC 80 01 00 14 83 E1 00 0C 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_317_0_0 {
	meta:
		name = "truncate64"
		size = 52
		refs = "001a _GLOBAL_OFFSET_TABLE_ 0022 __libc_errno"
	strings:
		$1 = { 38 00 00 C1 38 80 00 00 44 00 00 02 7C 00 00 26 74 09 10 00 4D A2 00 20 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 90 69 00 00 38 60 FF FF 4E 80 00 20 }
	condition:
		$1
}

rule file_318_0_0 {
	meta:
		name = "__libc_write"
		size = 132
		refs = "0018 __syscall_error 0034 __libc_enable_asynccancel 0060 __libc_disable_asynccancel"
		altNames = "__write"
	strings:
		$1 = { 81 42 8B 60 2C 0A 00 00 40 82 00 14 38 00 00 04 44 00 00 02 4C A3 00 20 4? ?? ?? ?? 94 21 FF D0 7D 28 02 A6 91 21 00 34 90 A1 00 1C 90 81 00 18 90 61 00 14 4? ?? ?? ?? 90 61 00 10 80 A1 00 1C 80 81 00 18 80 61 00 14 38 00 00 04 44 00 00 02 7C 00 00 26 90 61 00 08 90 01 00 0C 80 61 00 10 4? ?? ?? ?? 80 81 00 34 80 01 00 0C 80 61 00 08 7C 88 03 A6 7C 0F F1 20 38 21 00 30 4C A3 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_142_0_3 {
	meta:
		name = "__libc_write"
		size = 132
		refs = "0018 __syscall_error 0034 __pthread_enable_asynccancel 0060 __pthread_disable_asynccancel"
	strings:
		$1 = { 81 42 8B 60 2C 0A 00 00 40 82 00 14 38 00 00 04 44 00 00 02 4C A3 00 20 4? ?? ?? ?? 94 21 FF D0 7D 28 02 A6 91 21 00 34 90 A1 00 1C 90 81 00 18 90 61 00 14 4? ?? ?? ?? 90 61 00 10 80 A1 00 1C 80 81 00 18 80 61 00 14 38 00 00 04 44 00 00 02 7C 00 00 26 90 61 00 08 90 01 00 0C 80 61 00 10 4? ?? ?? ?? 80 81 00 34 80 01 00 0C 80 61 00 08 7C 88 03 A6 7C 0F F1 20 38 21 00 30 4C A3 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_142_2_3 {
	meta:
		name = "__write"
		size = 132
		refs = "0018 __syscall_error 0034 __pthread_enable_asynccancel 0060 __pthread_disable_asynccancel"
	strings:
		$1 = { 81 42 8B 60 2C 0A 00 00 40 82 00 14 38 00 00 04 44 00 00 02 4C A3 00 20 4? ?? ?? ?? 94 21 FF D0 7D 28 02 A6 91 21 00 34 90 A1 00 1C 90 81 00 18 90 61 00 14 4? ?? ?? ?? 90 61 00 10 80 A1 00 1C 80 81 00 18 80 61 00 14 38 00 00 04 44 00 00 02 7C 00 00 26 90 61 00 08 90 01 00 0C 80 61 00 10 4? ?? ?? ?? 80 81 00 34 80 01 00 0C 80 61 00 08 7C 88 03 A6 7C 0F F1 20 38 21 00 30 4C A3 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_318_1_0 {
	meta:
		name = "__write_nocancel"
		size = 16
		refs = "000c __syscall_error"
	strings:
		$1 = { 38 00 00 04 44 00 00 02 4C A3 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_319_0_0 {
	meta:
		name = "wctomb"
		size = 184
		refs = "001a __wctomb_state 0020 __wcrtomb 003a _GLOBAL_OFFSET_TABLE_ 0042 _nl_current_LC_CTYPE 008e _nl_C_LC_CTYPE 00a0 __wcsmbs_load_conv 00ae __wcsmbs_gconv_fcts_c"
	strings:
		$1 = { 2F 83 00 00 94 21 FF F0 7C 08 02 A6 93 E1 00 0C 90 01 00 14 41 9E 00 24 3C A0 ?? ?? 38 A5 ?? ?? 4? ?? ?? ?? 80 01 00 14 83 E1 00 0C 38 21 00 10 7C 08 03 A6 4E 80 00 20 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 81 29 00 00 83 E9 00 00 81 3F 00 14 2F 89 00 00 41 9E 00 34 3D 60 ?? ?? 38 00 00 00 39 4B ?? ?? 90 0B ?? ?? 90 0A 00 04 80 01 00 14 81 29 00 08 7C 08 03 A6 83 E1 00 0C 80 69 00 34 38 21 00 10 4E 80 00 20 3D 20 ?? ?? 38 09 ?? ?? 7F 9F 00 00 41 9E 00 14 7F E3 FB 78 4? ?? ?? ?? 81 3F 00 14 4B FF FF B4 3D 20 ?? ?? 39 29 ?? ?? 4B FF FF A8 }
	condition:
		$1
}

rule file_321_0_0 {
	meta:
		name = "sigrelse"
		size = 124
		refs = "0028 __sigprocmask 0058 sigdelset"
	strings:
		$1 = { 94 21 FF 70 7C 08 02 A6 38 80 00 00 93 E1 00 8C 38 A1 00 08 7C 7F 1B 78 38 60 00 02 93 C1 00 88 3B C0 FF FF 90 01 00 94 4? ?? ?? ?? 2F 83 00 00 40 9C 00 20 80 01 00 94 7F C3 F3 78 83 E1 00 8C 7C 08 03 A6 83 C1 00 88 38 21 00 90 4E 80 00 20 38 61 00 08 7F E4 FB 78 4? ?? ?? ?? 2F 83 00 00 41 BC FF D4 38 60 00 02 38 81 00 08 38 A0 00 00 4? ?? ?? ?? 7C 7E 1B 78 4B FF FF BC }
	condition:
		$1
}

rule file_660_0_0 {
	meta:
		name = "sighold"
		size = 124
		refs = "0028 __sigprocmask 0058 sigaddset"
	strings:
		$1 = { 94 21 FF 70 7C 08 02 A6 38 80 00 00 93 E1 00 8C 38 A1 00 08 7C 7F 1B 78 38 60 00 02 93 C1 00 88 3B C0 FF FF 90 01 00 94 4? ?? ?? ?? 2F 83 00 00 40 9C 00 20 80 01 00 94 7F C3 F3 78 83 E1 00 8C 7C 08 03 A6 83 C1 00 88 38 21 00 90 4E 80 00 20 38 61 00 08 7F E4 FB 78 4? ?? ?? ?? 2F 83 00 00 41 BC FF D4 38 60 00 02 38 81 00 08 38 A0 00 00 4? ?? ?? ?? 7C 7E 1B 78 4B FF FF BC }
	condition:
		$1
}

rule file_322_0_0 {
	meta:
		name = "__mempcpy"
		size = 232
		refs = "0074 _wordcopy_fwd_dest_aligned 00e0 _wordcopy_fwd_aligned"
	strings:
		$1 = { 2B 85 00 0F 94 21 FF E0 7C 08 02 A6 93 A1 00 14 7C BD 2B 78 93 C1 00 18 7C 9E 23 78 93 E1 00 1C 7C 7F 1B 78 90 01 00 24 40 9D 00 60 7C 03 00 D0 54 00 07 BE 2F 80 00 00 7F A0 28 50 41 9E 00 24 7C 09 03 A6 3B E0 00 00 7C 04 F8 AE 7C 03 F9 AE 3B FF 00 01 42 00 FF F4 7F C4 FA 14 7F E3 FA 14 73 C0 00 03 41 82 00 70 7F E3 FB 78 7F C4 F3 78 57 A5 F0 BE 4? ?? ?? ?? 57 A0 00 3A 7F DE 02 14 7F FF 02 14 57 BD 07 BE 2F 9D 00 00 41 9E 00 28 39 3F FF FF 7F FF EA 14 38 1F FF FF 7C 09 00 50 7C 09 03 A6 3B DE FF FF 8C 1E 00 01 9C 09 00 01 42 00 FF F8 80 01 00 24 7F E3 FB 78 83 A1 00 14 7C 08 03 A6 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 7F E3 FB 78 7F C4 F3 78 57 A5 F0 BE 4? ?? ?? ?? 4B FF FF 94 }
	condition:
		$1
}

rule file_324_0_0 {
	meta:
		name = "l64a"
		size = 72
	strings:
		$1 = { 7C 60 1B 79 41 82 00 38 3C 60 ?? ?? 3D 40 ?? ?? 39 20 00 00 38 63 ?? ?? 39 4A ?? ?? 54 0B 06 BE 54 00 D1 BF 7D 6A 58 AE 7D 63 49 AE 39 29 00 01 40 82 FF EC 7C 03 49 AE 4E 80 00 20 3C 60 ?? ?? 38 63 ?? ?? 4E 80 00 20 }
	condition:
		$1
}

rule file_325_0_0 {
	meta:
		name = "rexec_af"
		size = 1320
		refs = "0078 __snprintf 00c0 getaddrinfo 00e4 free 00f0 __strdup 0118 ruserpass 0134 __socket 014c __connect 0158 __errno_location 017c __close 0184 __sleep 01b0 perror 0270 __listen 0288 __getsockname 0298 __libc_sa_len 02c4 getnameinfo 02e8 sprintf 02f0 strlen 0300 __write 0318 accept 035c freeaddrinfo 0380 strtol 03fc __writev 0444 __read"
	strings:
		$1 = { 94 21 FE 20 7C 08 02 A6 93 41 01 C8 7C BA 2B 78 90 01 01 E4 7C 80 23 78 38 80 00 20 90 A1 01 98 3C A0 ?? ?? 38 A5 ?? ?? 93 61 01 CC 7C DB 33 78 93 C1 01 D8 7C 7E 1B 78 38 61 00 50 90 C1 01 9C 7C 06 03 78 93 21 01 C4 3B 20 00 02 93 81 01 D0 7C FC 3B 78 93 A1 01 D4 7D 1D 43 78 93 E1 01 DC 7D 3F 4B 78 92 A1 01 B4 92 C1 01 B8 92 E1 01 BC 93 01 01 C0 4C C6 31 82 4? ?? ?? ?? 38 00 00 00 80 7E 00 00 39 20 00 00 90 01 00 3C 38 81 00 50 38 A1 00 30 90 01 00 40 38 C1 00 0C 90 01 00 44 90 01 00 48 90 01 00 4C 38 00 00 01 93 E1 00 34 3B E0 FF FF 99 21 00 6F 90 01 00 38 93 21 00 30 4? ?? ?? ?? 2F 83 00 00 40 9E 00 F0 81 21 00 0C 80 09 00 18 2F 80 00 00 41 9E 03 D8 3F 20 ?? ?? 80 79 ?? ?? 4? ?? ?? ?? 81 21 00 0C 80 69 00 18 4? ?? ?? ?? 2F 83 00 00 90 79 ?? ?? 41 9E 03 F8 81 21 00 0C 38 81 01 98 90 7E 00 00 38 A1 01 9C 3B 20 00 01 80 69 00 18 4? ?? ?? ?? 81 21 00 0C 38 00 00 06 80 89 00 08 38 A0 00 00 80 69 00 04 90 01 01 A0 4? ?? ?? ?? 7C 7F 1B 79 41 80 00 6C 81 21 00 0C 80 89 00 14 80 A9 00 10 4? ?? ?? ?? 2F 83 00 00 40 9C 00 F4 4? ?? ?? ?? 80 03 00 00 7F E3 FB 78 2F 80 00 6F 40 9E 00 90 80 01 01 A0 35 20 FF FF 91 21 01 A0 41 82 00 80 4? ?? ?? ?? 7F 23 CB 78 4? ?? ?? ?? 81 21 00 0C 38 A0 00 00 80 89 00 08 57 39 08 3C 80 69 00 04 4? ?? ?? ?? 7C 7F 1B 79 40 80 FF 9C 3C 60 ?? ?? 38 63 ?? ?? 4? ?? ?? ?? 3B E0 FF FF 80 01 01 E4 7F E3 FB 78 82 A1 01 B4 7C 08 03 A6 82 C1 01 B8 82 E1 01 BC 83 01 01 C0 83 21 01 C4 83 41 01 C8 83 61 01 CC 83 81 01 D0 83 A1 01 D4 83 C1 01 D8 83 E1 01 DC 38 21 01 E0 4E 80 00 20 81 21 00 0C 3B E0 FF FF 80 69 00 18 4? ?? ?? ?? 80 01 01 E4 7F E3 FB 78 82 A1 01 B4 7C 08 03 A6 82 C1 01 B8 82 E1 01 BC 83 01 01 C0 83 21 01 C4 83 41 01 C8 83 61 01 CC 83 81 01 D0 83 A1 01 D4 83 C1 01 D8 83 E1 01 DC 38 21 01 E0 4E 80 00 20 2F 9D 00 00 41 9E 02 74 81 21 00 0C 38 A0 00 00 80 69 00 04 80 89 00 08 4? ?? ?? ?? 7C 79 1B 79 41 80 00 FC 38 80 00 01 4? ?? ?? ?? 38 00 00 80 7F 23 CB 78 90 01 00 10 38 81 01 10 38 A1 00 10 4? ?? ?? ?? 2F 83 00 00 41 9C 02 80 A0 61 01 10 4? ?? ?? ?? 80 01 00 10 7C 64 1B 78 7F 83 00 00 40 9E 02 34 38 A0 00 00 38 61 01 10 38 C0 00 00 38 E1 00 50 39 00 00 20 39 20 00 02 4? ?? ?? ?? 3B 00 00 00 2F 83 00 00 38 A0 00 00 41 9E 00 A0 3C 80 ?? ?? 38 84 ?? ?? 38 61 00 70 4C C6 31 82 4? ?? ?? ?? 38 61 00 70 4? ?? ?? ?? 38 81 00 70 38 A3 00 01 7F E3 FB 78 4? ?? ?? ?? 38 00 00 80 90 01 00 14 38 81 00 90 38 A1 00 14 7F 23 CB 78 4? ?? ?? ?? 2F 83 FF FF 7C 77 1B 78 40 9E 00 6C 4? ?? ?? ?? 80 03 00 00 2F 80 00 04 41 9E FF D8 7F 23 CB 78 4? ?? ?? ?? 3C 60 ?? ?? 38 63 ?? ?? 4? ?? ?? ?? 7F E3 FB 78 4? ?? ?? ?? 80 61 00 0C 3B E0 FF FF 4? ?? ?? ?? 4B FF FE 58 7F E3 FB 78 4? ?? ?? ?? 3B E0 FF FF 4B FF FE 48 38 A0 00 0A 38 61 00 50 38 80 00 00 4? ?? ?? ?? 54 78 04 3E 7F 05 C3 78 4B FF FF 4C 7F 23 CB 78 4? ?? ?? ?? 2F 97 00 00 41 BC FF A4 92 FD 00 00 82 E1 01 98 7E E3 BB 78 4? ?? ?? ?? 83 21 01 9C 7C 75 1B 78 7F 23 CB 78 4? ?? ?? ?? 3A B5 00 01 7C 76 1B 78 7F 83 E3 78 4? ?? ?? ?? 3A D6 00 01 38 63 00 01 92 E1 00 18 92 A1 00 1C 93 21 00 20 92 C1 00 24 93 81 00 28 90 61 00 2C 38 81 00 18 38 A0 00 03 7F E3 FB 78 4? ?? ?? ?? 2F 83 FF FF 40 9E 00 14 4? ?? ?? ?? 80 03 00 00 2F 80 00 04 41 9E FF DC 80 61 01 98 7F 83 D0 00 41 9E 00 08 4? ?? ?? ?? 80 61 01 9C 7F 83 D8 00 41 9E 00 08 4? ?? ?? ?? 7F E3 FB 78 38 81 00 08 38 A0 00 01 4? ?? ?? ?? 2F 83 00 01 40 9E 00 B8 88 01 00 08 2F 80 00 00 40 9E 00 10 80 61 00 0C 4? ?? ?? ?? 4B FF FD 54 38 81 00 08 38 A0 00 01 7F E3 FB 78 4? ?? ?? ?? 38 81 00 08 2F 83 00 01 38 A0 00 01 38 60 00 02 40 9E 00 14 4? ?? ?? ?? 88 01 00 08 2F 80 00 0A 40 9E FF D0 2F 98 00 00 41 BE FE AC 80 7D 00 00 4? ?? ?? ?? 4B FF FE A0 90 1E 00 00 4? ?? ?? ?? 93 23 00 00 4B FF FC FC 3C 80 ?? ?? 7F E3 FB 78 38 84 ?? ?? 38 A0 00 01 4? ?? ?? ?? 3B 00 00 00 4B FF FE CC 4? ?? ?? ?? 38 00 00 16 90 03 00 00 7F 23 CB 78 4? ?? ?? ?? 4B FF FE 5C 3C 60 ?? ?? 38 63 ?? ?? 4? ?? ?? ?? 4B FF FC B8 80 7E 00 00 4? ?? ?? ?? 4B FF FF 90 3C 60 ?? ?? 38 63 ?? ?? 4? ?? ?? ?? 7F 23 CB 78 4? ?? ?? ?? 4B FF FE 28 }
	condition:
		$1
}

rule file_327_0_0 {
	meta:
		name = "__posix_fadvise64_l64"
		size = 32
	strings:
		$1 = { 38 00 00 FE 7D 24 4B 78 44 00 00 02 7C 00 00 26 74 09 10 00 4C 82 00 20 38 60 00 00 4E 80 00 20 }
	condition:
		$1
}

rule file_328_0_0 {
	meta:
		name = "__ctype_get_mb_cur_max"
		size = 32
		refs = "0002 _GLOBAL_OFFSET_TABLE_ 000a _nl_current_LC_CTYPE"
	strings:
		$1 = { 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 81 29 00 00 81 29 00 00 80 69 00 58 4E 80 00 20 }
	condition:
		$1
}

rule file_329_0_0 {
	meta:
		name = "map_newlink"
		size = 124
	strings:
		$1 = { 2C 06 00 00 7C 60 1B 78 38 60 FF FF 4C 81 00 20 81 25 00 00 2F 89 FF FF 41 9E 00 58 7F 89 00 00 38 60 00 00 4D 9E 00 20 7C C9 03 A6 48 00 00 18 85 25 00 04 2F 89 FF FF 7F 09 00 00 41 9E 00 18 4D 9A 00 20 38 63 00 01 42 00 FF E8 38 60 FF FF 4E 80 00 20 39 63 FF FF 90 05 00 00 1D 23 00 9C 1C 0B 00 9C 7D 24 4A 14 7D 24 01 2E 4E 80 00 20 90 05 00 00 38 60 00 00 4E 80 00 20 }
	condition:
		$1
}

rule file_329_1_0 {
	meta:
		name = "getifaddrs_internal"
		size = 2784
		refs = "007c __netlink_open 0090 __netlink_request 01b0 calloc 01e8 memset 0408 memcpy 0560 __netlink_free_handle 0688 mempcpy 0aac abort 0acc __assert_fail 0ad4 free"
	strings:
		$1 = { 94 21 FF 70 7C 08 02 A6 90 01 00 94 38 00 00 00 92 C1 00 68 7C 76 1B 78 93 E1 00 8C 7C 3F 0B 78 91 C1 00 48 91 E1 00 4C 92 01 00 50 92 21 00 54 92 41 00 58 92 61 00 5C 92 81 00 60 92 A1 00 64 92 E1 00 6C 93 01 00 70 93 21 00 74 93 41 00 78 93 61 00 7C 93 81 00 80 93 A1 00 84 93 C1 00 88 90 03 00 00 38 7F 00 08 90 1F 00 08 90 1F 00 0C 90 1F 00 10 90 1F 00 14 90 1F 00 18 4? ?? ?? ?? 2F 83 00 00 41 9C 05 C8 38 7F 00 08 38 80 00 12 4? ?? ?? ?? 2F 83 00 00 41 9C 04 C0 81 3F 00 10 38 7F 00 08 38 80 00 16 38 09 00 01 90 1F 00 10 4? ?? ?? ?? 2F 83 00 00 41 9C 04 A0 80 DF 00 14 2F 86 00 00 41 9E 09 A4 81 1F 00 0C 3B A0 00 00 3B C0 00 00 3B 20 00 00 81 66 00 04 80 06 00 08 2F 8B 00 00 41 9E 00 A0 2B 80 00 0F 40 9D 00 98 81 2B 00 00 2B 89 00 0F 40 9D 00 8C 7F 80 48 40 40 BC 00 30 48 00 00 80 39 29 00 03 55 29 00 3A 7C 09 00 50 2B 80 00 0F 40 9D 00 6C 7D 2B 48 6E 2B 89 00 0F 40 9D 00 60 7F 89 00 40 41 9D 00 58 81 4B 00 0C 7F 8A 40 00 40 9E FF D0 80 EB 00 08 81 46 00 0C 7F 87 50 00 40 9E FF C0 A1 4B 00 04 2F 8A 00 03 41 9E 00 30 2F 8A 00 10 41 9E 04 78 39 29 00 03 55 29 00 3A 7C 09 00 50 2B 80 00 0F 69 47 00 14 20 E7 00 00 7C FE 01 94 7C FE 3B 78 41 9D FF 9C 80 C6 00 00 2F 86 00 00 40 9E FF 4C 7F 1E CA 15 3B C0 00 00 41 A2 03 C4 1F 18 00 9C 7F B8 EA 14 38 60 00 01 93 BF 00 3C 7F A4 EB 78 4? ?? ?? ?? 7C 77 1B 79 41 82 03 A0 57 25 10 3A 81 21 00 00 38 05 00 1E 54 00 00 36 7C 00 00 D0 7D 21 01 6E 38 80 00 FF 7F 17 C2 14 3A 41 00 17 56 52 00 36 7E 43 93 78 4? ?? ?? ?? 83 9F 00 14 2F 9C 00 00 41 9E 08 B0 92 DF 00 40 3A 80 00 00 3A 60 FF FF 3A A0 00 00 3A 20 00 11 83 DC 00 04 83 BC 00 08 2F 9E 00 00 41 9E 02 DC 2B 9D 00 0F 40 9D 02 D4 82 DE 00 00 2B 96 00 0F 40 9D 02 C8 7F 9D B0 40 40 BC 00 34 48 00 02 BC 81 3E 00 00 38 09 00 03 54 00 00 3A 7F A0 E8 50 2B 9D 00 0F 40 9D 02 A4 7E DE 00 6E 2B 96 00 0F 40 9D 02 98 7F 96 E8 40 41 9D 02 90 81 3E 00 0C 80 1F 00 0C 7F 89 00 00 40 9E FF C8 81 3E 00 08 80 1C 00 0C 7F 89 00 00 40 9E FF B8 A0 1E 00 04 2F 80 00 03 41 9E 02 64 2F 80 00 10 41 9E 04 B8 2F 80 00 14 40 9E FF 9C 3B 5E 00 10 80 7A 00 04 7E E4 BB 78 7E 45 93 78 38 63 FF FF 7F 26 CB 78 4B FF F7 DD 2F 83 FF FF 41 9E 08 0C 7D 34 CA 14 1D 63 00 9C 2F 89 00 00 1F 69 00 9C 7D 77 5A 14 80 0B 00 08 7F 77 DA 14 90 1B 00 08 40 9D 00 10 38 09 FF FF 1C 00 00 9C 7F 77 01 2E 3A 16 FF E8 2B 90 00 03 3A 94 00 01 40 9D 01 30 A1 3A 00 08 3A DA 00 08 2B 89 00 03 40 9D 01 20 7F 90 48 40 41 9C 01 18 39 7B 00 88 93 BF 00 28 39 5B 00 66 38 1B 00 1C 92 5F 00 30 38 FB 00 1E 7F 92 E3 78 91 5F 00 34 7D 7C 5B 78 90 FF 00 38 7C 1D 03 78 93 DF 00 2C 48 00 00 38 2F 80 00 01 41 9E 03 AC A1 36 00 00 38 09 00 03 54 00 00 3A 7E 00 80 50 2B 90 00 03 40 9D 00 B4 7D 36 02 6E 2B 89 00 03 40 9D 00 A8 7F 89 80 40 41 9D 00 A0 A0 16 00 02 39 D6 00 04 39 E9 FF FC 2F 80 00 02 41 9E 02 FC 2B 80 00 02 40 BD FF B4 2F 80 00 03 41 9E 02 C4 2F 80 00 04 40 9E FF AC 80 1B 00 14 3B DB 00 64 2F 80 00 00 41 9E 00 14 7F C3 F3 78 38 80 00 00 38 A0 00 24 4? ?? ?? ?? 93 DB 00 14 88 1A 00 00 B0 1B 00 64 88 1A 00 00 2F 80 00 02 41 9E 05 D0 2F 80 00 0A 41 9E 05 64 2B 8F 00 24 41 9D FF 64 80 7F 00 34 7D C4 73 78 7D E5 7B 78 4? ?? ?? ?? A1 36 00 00 38 09 00 03 54 00 00 3A 7E 00 80 50 2B 90 00 03 41 9D FF 54 7E 5C 93 78 83 BF 00 28 83 DF 00 2C 82 5F 00 30 80 1B 00 04 2F 80 00 00 41 9E 06 34 81 3B 00 0C 2F 89 00 00 41 BE FD F4 A0 09 00 00 2F 80 00 00 41 BE FD E8 2F 80 00 11 41 BE FD E0 2F 80 00 02 39 3B 00 40 91 3B 00 10 39 7B 00 44 39 20 00 20 41 9E 00 1C 2F 80 00 0A 39 7B 00 48 39 20 00 80 41 9E 00 0C 39 60 00 00 39 20 00 00 2F 8B 00 00 B0 1B 00 40 41 BE FD A4 2F 89 00 00 40 9E 05 B0 89 5A 00 01 55 40 06 3E 54 0A E8 FF 41 82 00 18 7D 49 03 A6 39 2B FF FF 9E 69 00 01 42 00 FF FC 7D 6B 52 14 54 00 07 7E 39 20 00 FF 20 00 00 08 7D 20 00 30 98 0B 00 00 81 3E 00 00 38 09 00 03 54 00 00 3A 7F A0 E8 50 2B 9D 00 0F 41 9D FD 64 83 9C 00 00 2F 9C 00 00 40 9E FD 10 82 DF 00 40 81 5F 00 3C 7C 17 52 14 7F 98 00 40 41 9D 05 A0 2F 94 00 00 41 9E 01 48 2F 99 00 00 41 9E 01 40 1D 79 00 9C 7F 29 03 A6 3A 52 FF FC 7D 77 5A 14 7E E9 BB 78 48 00 00 0C 39 29 00 9C 42 40 01 20 84 12 00 04 2F 80 FF FF 40 9E FF F0 91 69 FF 64 4B FF FF E8 3B C0 FF FF 38 7F 00 08 4? ?? ?? ?? 38 00 00 06 80 7F 00 08 44 00 00 02 7C 00 00 26 39 7F 00 90 80 0B 00 04 7F C3 F3 78 81 CB FF B8 7C 08 03 A6 81 EB FF BC 82 0B FF C0 82 2B FF C4 82 4B FF C8 82 6B FF CC 82 8B FF D0 82 AB FF D4 82 CB FF D8 82 EB FF DC 83 0B FF E0 83 2B FF E4 83 4B FF E8 83 6B FF EC 83 8B FF F0 83 AB FF F4 83 CB FF F8 83 EB FF FC 7D 61 5B 78 4E 80 00 20 38 E9 FF E0 2B 87 00 03 40 9D 00 68 A1 4B 00 20 38 AB 00 20 2B 8A 00 03 40 9D 00 58 7F 87 50 40 41 9C 00 50 A0 85 00 02 38 6A FF FC 2F 84 00 07 40 BE 00 2C 48 00 00 4C 7D 45 52 6E 2B 8A 00 03 40 9D 00 30 7F 8A 38 40 41 9D 00 28 A0 85 00 02 38 6A FF FC 2F 84 00 07 41 9E 00 28 39 4A 00 03 55 4A 00 3A 7C EA 38 50 2B 87 00 03 41 9D FF CC 3B 39 00 01 4B FF FA C0 3B C0 FF FF 4B FF FF 24 7F BD 1A 14 3B 39 00 01 4B FF FA AC 92 F6 00 00 3B C0 00 00 4B FF FE F4 39 29 FF FD 2B 89 00 11 41 9D 04 38 93 9B 00 04 7F 83 E3 78 7D C4 73 78 7D E5 7B 78 4? ?? ?? ?? 9A A3 00 00 4B FF FC CC 80 1B 00 0C 2F 80 00 00 41 9E 00 2C 3B DB 00 64 7F A4 EB 78 38 A0 00 24 7F C3 F3 78 4? ?? ?? ?? 93 DB 00 14 7F A3 EB 78 38 80 00 00 38 A0 00 24 4? ?? ?? ?? 93 BB 00 0C 88 1A 00 00 B0 1B 00 1C 88 1A 00 00 2F 80 00 02 41 9E 03 54 2F 80 00 0A 41 9E 02 E8 2B 8F 00 24 41 9D FC 70 80 7F 00 38 7D C4 73 78 7D E5 7B 78 4? ?? ?? ?? 4B FF FC 5C 80 1B 00 0C 2F 80 00 00 41 9E 03 38 38 7B 00 64 90 7B 00 14 88 1A 00 00 B0 03 00 00 88 1A 00 00 2F 80 00 02 41 9E 02 18 2F 80 00 0A 41 9E 01 AC 2B 8F 00 24 41 9D FC 24 7D C4 73 78 7D E5 7B 78 38 63 00 02 4? ?? ?? ?? 4B FF FC 10 3B 7E 00 10 80 7B 00 04 7E E4 BB 78 7E 45 93 78 38 63 FF FF 7F 26 CB 78 4B FF F3 31 2F 83 FF FF 41 9E 03 60 3A D6 FF E0 80 1B 00 08 2B 96 00 03 1C 63 00 9C 7D F7 1A 14 90 0F 00 08 40 BD FA B0 A1 3B 00 10 3B 5B 00 10 2B 89 00 03 40 BD FA A0 7F 96 48 40 41 BC FA 98 39 4F 00 28 91 5F 00 28 38 0F 00 1C 38 EF 00 70 39 4F 00 64 90 1F 00 2C 39 CF 00 88 90 FF 00 30 91 5F 00 34 48 00 00 38 2F 80 00 01 41 9E 00 AC A1 3A 00 00 38 09 00 03 54 00 00 3A 7E C0 B0 50 2B 96 00 03 40 BD FA 50 7D 3A 02 6E 2B 89 00 03 40 BD FA 44 7F 89 B0 40 41 BD FA 3C A0 1A 00 02 38 9A 00 04 3A 09 FF FC 2F 80 00 02 41 9E 00 34 2B 80 00 02 40 BD FF B4 2F 80 00 03 41 9E 00 94 2F 80 00 07 40 9E FF AC 93 0F 00 18 7F 03 C3 78 7E 05 83 78 7F 18 82 14 4? ?? ?? ?? 4B FF FF 94 2B 90 00 24 41 9D FF 8C B2 2F 00 64 7E 05 83 78 80 7F 00 30 4? ?? ?? ?? 9A 0F 00 6F 80 1B 00 04 81 3F 00 34 90 0F 00 68 A0 1B 00 02 91 2F 00 14 B0 0F 00 6C 4B FF FF 5C 2B 90 00 24 41 9D FF 54 B2 2F 00 1C 7E 05 83 78 80 7F 00 28 4? ?? ?? ?? 9A 0F 00 27 80 1B 00 04 80 FF 00 2C 90 0F 00 20 A0 1B 00 02 90 EF 00 0C B0 0F 00 24 4B FF FF 24 39 29 FF FD 2B 89 00 11 41 9D FF 18 91 CF 00 04 7D C3 73 78 7E 05 83 78 4? ?? ?? ?? 9A A3 00 00 4B FF FF 00 2F 8F 00 10 40 9E FA 7C 80 0E 00 0C 3D 20 FE 80 81 0E 00 00 81 4E 00 04 81 6E 00 08 91 03 00 08 91 43 00 0C 91 63 00 10 90 03 00 14 80 0E 00 00 54 00 00 12 7F 80 48 00 41 9E 00 20 88 0E 00 00 2F 80 00 FF 40 9E FA 3C 88 0E 00 01 54 00 07 3E 2F 80 00 02 40 9E FA 2C 80 1A 00 04 90 03 00 18 4B FF FA 20 2F 8F 00 04 40 9E FA 18 80 0E 00 00 90 03 00 04 4B FF FA 0C 2F 8F 00 10 40 9E FA 04 80 0E 00 0C 3C E0 FE 80 81 0E 00 00 81 4E 00 04 81 6E 00 08 91 1B 00 6C 91 5B 00 70 91 7B 00 74 90 1B 00 78 80 0E 00 00 54 00 00 12 7F 80 38 00 41 9E 00 20 88 0E 00 00 2F 80 00 FF 40 9E F9 C4 88 0E 00 01 54 00 07 3E 2F 80 00 02 40 9E F9 B4 80 1A 00 04 90 1B 00 7C 4B FF F9 A8 2F 8F 00 04 40 9E F9 A0 80 0E 00 00 90 1B 00 68 4B FF F9 94 2F 8F 00 10 40 9E F9 8C 81 4E 00 04 80 0E 00 0C 81 0E 00 00 81 6E 00 08 91 5B 00 28 3D 40 FE 80 91 1B 00 24 91 7B 00 2C 90 1B 00 30 80 0E 00 00 54 00 00 12 7F 80 50 00 41 9E 00 20 88 0E 00 00 2F 80 00 FF 40 9E F9 4C 88 0E 00 01 54 00 07 3E 2F 80 00 02 40 9E F9 3C 80 1A 00 04 90 1B 00 34 4B FF F9 30 2F 8F 00 04 40 9E F9 28 80 0E 00 00 90 1B 00 20 4B FF F9 1C 93 BB 00 0C 7F A3 EB 78 4B FF FC CC 89 5A 00 01 7D 20 4B 78 55 49 06 3E 7F 80 48 40 41 BC FA 4C 4B FF FA 44 3B C0 00 00 4B FF FA F0 80 7A 00 04 7E E4 BB 78 7E 45 93 78 38 63 FF FF 7F 26 CB 78 4B FF F0 15 2F 83 FF FF 41 9E 00 44 1D 23 00 9C 7D 37 4A 14 80 09 00 04 90 1B 00 04 4B FF F9 A0 3A 80 00 00 4B FF FA 5C 4? ?? ?? ?? 3C 60 ?? ?? 3C 80 ?? ?? 3C C0 ?? ?? 38 63 ?? ?? 38 84 ?? ?? 38 A0 03 32 38 C6 ?? ?? 4? ?? ?? ?? 7E E3 BB 78 4? ?? ?? ?? 3B C0 FF F5 4B FF FA 80 }
	condition:
		$1
}

rule file_329_2_0 {
	meta:
		name = "__netlink_free_handle"
		size = 116
		refs = "0016 _GLOBAL_OFFSET_TABLE_ 0026 __libc_errno 003c free"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 90 01 00 24 80 63 00 0C 93 C1 00 18 3F C0 ?? ?? 2F 83 00 00 3B DE ?? ?? 93 A1 00 14 81 3E ?? ?? 7D 29 12 14 93 E1 00 1C 83 A9 00 00 41 9E 00 18 83 E3 00 00 4? ?? ?? ?? 2F 9F 00 00 7F E3 FB 78 40 9E FF F0 80 01 00 24 83 DE ?? ?? 7F DE 12 14 83 E1 00 1C 7C 08 03 A6 93 BE 00 00 83 A1 00 14 83 C1 00 18 38 21 00 20 4E 80 00 20 }
	condition:
		$1
}

rule file_329_3_0 {
	meta:
		name = "__netlink_request"
		size = 936
		refs = "004c __getpagesize 009e _GLOBAL_OFFSET_TABLE_ 00b2 __libc_errno 00fc __sendto 016c time 01cc __recvmsg 02a8 free 0300 malloc 031c memcpy 0380 __libc_alloca_cutoff"
	strings:
		$1 = { 94 21 FF 70 7C 08 02 A6 93 E1 00 8C 7C 3F 0B 78 93 41 00 78 7C 9A 23 78 93 81 00 80 93 C1 00 88 7C 7E 1B 78 90 01 00 94 92 61 00 5C 92 81 00 60 92 A1 00 64 92 C1 00 68 92 E1 00 6C 93 01 00 70 93 21 00 74 93 61 00 7C 93 A1 00 84 4? ?? ?? ?? 2B 83 80 00 7C 7C 1B 78 41 9D 03 28 38 1C 00 1E 81 21 00 00 54 00 00 36 7C 00 00 D0 7D 21 01 6E 3B 60 00 00 3B A1 00 17 57 BD 00 36 80 7E 00 08 93 BF 00 08 2F 83 00 00 93 9F 00 0C 41 9E 00 E0 39 20 00 14 B3 5F 00 2C 38 00 00 00 3F 80 ?? ?? 91 3F 00 28 39 20 03 01 90 1F 00 1C 3B 9C ?? ?? 83 9C ?? ?? B1 3F 00 2E 39 20 00 00 7F 9C 12 14 90 1F 00 34 98 1F 00 38 B0 1F 00 39 90 1F 00 20 90 1F 00 24 38 00 00 10 90 7F 00 30 99 3F 00 3B B0 1F 00 1C 80 7E 00 00 38 9F 00 28 38 A0 00 14 38 C0 00 00 38 FF 00 1C 39 00 00 0C 4? ?? ?? ?? 2F 83 FF FF 40 9E 00 74 80 1C 00 00 2F 80 00 04 41 9E FF D4 2F 9B 00 00 3B C0 FF FF 40 9E 01 88 39 7F 00 90 80 0B 00 04 7F C3 F3 78 82 6B FF CC 7C 08 03 A6 82 8B FF D0 82 AB FF D4 82 CB FF D8 82 EB FF DC 83 0B FF E0 83 2B FF E4 83 4B FF E8 83 6B FF EC 83 8B FF F0 83 AB FF F4 83 CB FF F8 83 EB FF FC 7D 61 5B 78 4E 80 00 20 4? ?? ?? ?? 90 7E 00 08 4B FF FF 1C 2F 83 00 00 41 BC FF 98 3F 40 ?? ?? 3B 5A ?? ?? 83 5A ?? ?? 3A 9F 00 10 3A BF 00 08 3A C0 00 0C 3A E0 00 01 3B 20 00 00 7F 5A 12 14 80 7E 00 00 38 9F 00 3C 38 A0 00 00 92 9F 00 3C 92 DF 00 40 92 BF 00 44 92 FF 00 48 93 3F 00 4C 93 3F 00 50 93 3F 00 54 4? ?? ?? ?? 2F 83 FF FF 7C 7C 1B 78 40 9E 00 2C 80 1A 00 00 2F 80 00 04 40 BE FF 30 80 7E 00 00 38 9F 00 3C 38 A0 00 00 4? ?? ?? ?? 2F 83 FF FF 7C 7C 1B 78 41 9E FF DC 2F 83 00 00 41 BC FF 0C 80 1F 00 14 2F 80 00 00 40 BE FF 90 80 1F 00 54 70 09 00 20 40 A2 FE F4 2B 83 00 0F 40 BD FF 7C 81 3D 00 00 7F AB EB 78 2B 89 00 0F 40 BD FF 6C 7F 83 48 40 41 BC FF 64 80 FE 00 04 7C 60 1B 78 38 A0 00 00 81 0B 00 0C 39 49 00 03 55 4A 00 3A 7F 88 38 00 7C 0A 00 50 2B 00 00 0F 41 9E 00 48 40 99 00 18 7D 2B 50 6E 2B 89 00 0F 7F 09 00 40 40 9D 00 08 40 99 FF D0 3A 60 00 00 2F 85 00 00 40 9E 00 70 2F 93 00 00 41 9E FF 10 2F 9B 00 00 3B C0 00 00 41 9E FE 80 7F A3 EB 78 4? ?? ?? ?? 4B FF FE 74 80 CB 00 08 81 1E 00 08 7F 86 40 00 40 9E FF B0 A1 0B 00 04 38 A5 00 01 2F 88 00 03 2C 88 00 02 41 9E 00 88 40 86 FF 98 2B 89 00 23 41 9D 00 84 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 38 00 00 05 90 09 00 00 4B FF FE 1C 38 7C 00 10 4? ?? ?? ?? 7C 78 1B 79 41 A2 FE 0C 93 38 00 00 38 78 00 10 7F A4 EB 78 7F 85 E3 78 4? ?? ?? ?? 81 3E 00 0C 80 1E 00 08 2F 89 00 00 90 78 00 04 93 98 00 08 90 18 00 0C 41 9E 00 14 81 3E 00 10 93 09 00 00 93 1E 00 10 4B FF FF 48 93 1E 00 0C 93 1E 00 10 4B FF FF 3C 3A 60 00 01 4B FF FF 2C 3D 20 ?? ?? 80 0B 00 10 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 7C 00 00 D0 90 09 00 00 4B FF FD 98 4? ?? ?? ?? 2F 83 00 00 40 9E FC D4 7F 83 E3 78 4? ?? ?? ?? 3B 60 00 01 7C 7D 1B 79 40 82 FC E0 3B C0 FF FF 4B FF FD 7C }
	condition:
		$1
}

rule file_329_4_0 {
	meta:
		name = "__netlink_close"
		size = 20
	strings:
		$1 = { 38 00 00 06 80 63 00 00 44 00 00 02 7C 00 00 26 4E 80 00 20 }
	condition:
		$1
}

rule file_329_5_0 {
	meta:
		name = "__netlink_open"
		size = 188
		refs = "0020 __socket 0054 __bind 0074 __getsockname"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 38 80 00 03 93 E1 00 1C 38 A0 00 00 7C 7F 1B 78 38 60 00 10 90 01 00 24 4? ?? ?? ?? 38 00 FF FF 2F 83 00 00 90 7F 00 00 41 9C 00 5C 38 00 00 00 90 01 00 0C 38 81 00 0C 38 A0 00 0C 90 01 00 10 90 01 00 14 38 00 00 10 B0 01 00 0C 4? ?? ?? ?? 2F 83 00 00 41 9C 00 48 7C 25 0B 78 80 7F 00 00 38 00 00 0C 94 05 00 08 38 81 00 0C 4? ?? ?? ?? 2F 83 00 00 41 9C 00 28 81 21 00 10 38 00 00 00 91 3F 00 04 7C 03 03 78 80 01 00 24 83 E1 00 1C 38 21 00 20 7C 08 03 A6 4E 80 00 20 38 00 00 06 80 7F 00 00 44 00 00 02 7C 00 00 26 38 00 FF FF 4B FF FF D4 }
	condition:
		$1
}

rule file_329_6_0 {
	meta:
		name = "getifaddrs"
		size = 56
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 90 01 00 14 93 E1 00 0C 7C 7F 1B 78 7F E3 FB 78 4B FF F5 09 2F 83 FF F5 41 9E FF F4 80 01 00 14 83 E1 00 0C 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_330_0_0 {
	meta:
		name = "putwchar"
		size = 440
		refs = "000e _IO_stdout 0138 __woverflow 0148 __lll_lock_wait_private 01b4 _Unwind_Resume"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 93 A1 00 14 3F A0 ?? ?? 90 01 00 24 93 E1 00 1C 83 FD ?? ?? 93 C1 00 18 7C 7E 1B 78 7F E3 FB 78 80 1F 00 00 93 81 00 10 70 00 80 00 40 82 00 54 81 3F 00 48 3B 82 8B 60 81 69 00 08 7F 8B E0 00 41 9E 00 30 39 40 00 01 7D 60 48 28 7C 0B 00 00 40 82 00 0C 7D 40 49 2D 40 A2 FF F0 4C 00 01 2C 2F 8B 00 00 40 9E 00 D8 81 3F 00 48 93 89 00 08 81 69 00 04 80 7D ?? ?? 38 0B 00 01 90 09 00 04 81 23 00 5C 2F 89 00 00 41 9E 00 A4 81 69 00 10 80 09 00 14 7F 8B 00 40 40 9C 00 94 38 0B 00 04 93 CB 00 00 90 09 00 10 80 1F 00 00 70 09 80 00 40 82 00 38 80 7F 00 48 81 23 00 04 38 09 FF FF 2F 80 00 00 90 03 00 04 40 9E 00 20 90 03 00 08 7C 00 04 AC 7D 20 18 28 7C 00 19 2D 40 A2 FF F8 2F 89 00 01 41 9D 00 28 80 01 00 24 7F C3 F3 78 83 81 00 10 7C 08 03 A6 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 80 82 8B 68 38 00 00 DD 38 A0 00 01 60 84 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF C0 7F C4 F3 78 4? ?? ?? ?? 7C 7E 1B 78 4B FF FF 70 7D 23 4B 78 4? ?? ?? ?? 4B FF FF 24 80 1F 00 00 7C 7E 1B 78 70 09 80 00 40 82 00 54 80 7F 00 48 80 03 00 04 30 00 FF FF 2F 80 00 00 90 03 00 04 40 9E 00 3C 90 03 00 08 7C 00 04 AC 7D 20 18 28 7C 00 19 2D 40 A2 FF F8 2F 89 00 01 40 BD 00 20 80 82 8B 68 38 00 00 DD 38 A0 00 01 60 84 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 7F C3 F3 78 4? ?? ?? ?? }
	condition:
		$1
}

rule file_331_0_0 {
	meta:
		name = "futimesat"
		size = 480
		refs = "000e __have_atfcts 0096 _GLOBAL_OFFSET_TABLE_ 009e __libc_errno 00dc strlen 0120 __snprintf 0150 __atfct_seterrno 0168 __futimes"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 93 A1 00 14 3F A0 ?? ?? 90 01 00 24 80 1D ?? ?? 93 61 00 0C 7C BB 2B 78 2F 80 00 00 93 81 00 10 7C 7C 1B 78 93 C1 00 18 7C 9E 23 78 93 E1 00 1C 7C 3F 0B 78 41 9C 00 80 2F 84 00 00 41 9E 01 20 38 00 01 22 44 00 00 02 7C 00 00 26 74 09 10 00 40 82 01 50 2F 83 FF FF 7C 60 1B 78 41 9E 00 30 39 7F 00 20 7C 03 03 78 80 0B 00 04 83 6B FF EC 7C 08 03 A6 83 8B FF F0 83 AB FF F4 83 CB FF F8 83 EB FF FC 7D 61 5B 78 4E 80 00 20 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 81 29 00 00 38 00 FF FF 2F 89 00 26 40 9E FF B8 90 1D ?? ?? 48 00 00 0C 2F 84 00 00 41 9E 00 B4 2F 9C FF 9C 41 9E 00 94 88 1E 00 00 2F 80 00 2F 41 9E 00 88 7F C3 F3 78 4? ?? ?? ?? 7C 64 1B 79 41 82 00 DC 38 04 00 3E 81 21 00 00 54 00 00 36 7C 00 00 D0 7D 21 01 6E 3C A0 ?? ?? 7F C7 F3 78 3B A1 00 17 57 BD 00 36 7F A3 EB 78 38 84 00 20 38 A5 ?? ?? 7F 86 E3 78 4C C6 31 82 4? ?? ?? ?? 7F BE EB 78 38 00 00 FB 7F C3 F3 78 7F 64 DB 78 44 00 00 02 7C 00 00 26 74 09 10 00 7C 60 1B 78 41 82 FF 24 7F 84 E3 78 7F A5 EB 78 4? ?? ?? ?? 38 00 FF FF 4B FF FF 10 3B A0 00 00 4B FF FF C8 7C A4 2B 78 4? ?? ?? ?? 7C 60 1B 78 4B FF FE F8 80 01 00 00 3C A0 ?? ?? 38 80 00 1D 94 01 FF D0 38 A5 ?? ?? 7F 86 E3 78 3B A1 00 17 57 BD 00 36 7F A3 EB 78 4C C6 31 82 4? ?? ?? ?? 7F BE EB 78 4B FF FF 84 3D 20 ?? ?? 39 29 ?? ?? 81 69 ?? ?? 7D 6B 12 14 90 6B 00 00 4B FF FE E0 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 38 00 00 02 7D 29 12 14 90 09 00 00 38 00 FF FF 4B FF FE 8C }
	condition:
		$1
}

rule file_332_0_0 {
	meta:
		name = "__getpeername"
		size = 44
		refs = "0028 __syscall_error"
	strings:
		$1 = { 94 21 FF D0 90 61 00 14 90 81 00 18 90 A1 00 1C 38 60 00 07 38 81 00 14 38 00 00 66 44 00 00 02 38 21 00 30 4C A3 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_333_0_0 {
	meta:
		name = "__lxstat"
		size = 192
		refs = "007e _GLOBAL_OFFSET_TABLE_ 0086 __libc_errno 00a4 __xstat32_conv"
	strings:
		$1 = { 2F 83 00 01 94 21 FF 80 7C 08 02 A6 93 C1 00 78 7C BE 2B 78 93 E1 00 7C 7C 7F 1B 78 90 01 00 84 41 9E 00 40 7C 83 23 78 38 00 00 C4 38 81 00 08 44 00 00 02 7C 00 00 26 74 09 10 00 40 82 00 40 2F 83 00 00 41 9E 00 54 80 01 00 84 83 C1 00 78 7C 08 03 A6 83 E1 00 7C 38 21 00 80 4E 80 00 20 7C 83 23 78 38 00 00 6B 7C A4 2B 78 44 00 00 02 7C 00 00 26 74 09 10 00 41 82 FF D0 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 90 69 00 00 38 60 FF FF 4B FF FF B4 7F E3 FB 78 38 81 00 08 7F C5 F3 78 4? ?? ?? ?? 80 01 00 84 83 C1 00 78 7C 08 03 A6 83 E1 00 7C 38 21 00 80 4E 80 00 20 }
	condition:
		$1
}

rule file_334_0_0 {
	meta:
		name = "do_sigpause"
		size = 168
		refs = "0048 __sigsuspend 0080 __sigprocmask 0098 sigdelset"
	strings:
		$1 = { 2F 84 00 00 94 21 FF 60 7C 08 02 A6 93 C1 00 98 7C 7E 1B 78 90 01 00 A4 93 A1 00 94 93 E1 00 9C 40 9E 00 50 39 60 00 1F 7C 3F 0B 78 7D 69 03 A6 94 7F 00 08 38 00 00 00 7F E9 FB 78 94 09 00 04 42 00 FF FC 7F E3 FB 78 4? ?? ?? ?? 7C 7D 1B 78 80 01 00 A4 7F A3 EB 78 83 C1 00 98 7C 08 03 A6 83 A1 00 94 83 E1 00 9C 38 21 00 A0 4E 80 00 20 3B E1 00 08 38 60 00 00 38 80 00 00 7F E5 FB 78 4? ?? ?? ?? 3B A0 FF FF 2F 83 00 00 41 9C FF C4 7F E3 FB 78 7F C4 F3 78 4? ?? ?? ?? 2F 83 00 00 40 9C FF A4 4B FF FF AC }
	condition:
		$1
}

rule file_334_1_0 {
	meta:
		name = "__sigpause"
		size = 136
		refs = "0048 __libc_enable_asynccancel 0064 __libc_disable_asynccancel"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 93 C1 00 18 7C 7E 1B 78 93 E1 00 1C 7C 9F 23 78 90 01 00 24 93 A1 00 14 80 02 8B 60 2F 80 00 00 40 9E 00 20 80 01 00 24 83 A1 00 14 7C 08 03 A6 83 C1 00 18 83 E1 00 1C 38 21 00 20 4B FF FF 14 4? ?? ?? ?? 7F E4 FB 78 7C 7D 1B 78 7F C3 F3 78 4B FF FF 01 7C 7F 1B 78 7F A3 EB 78 4? ?? ?? ?? 80 01 00 24 7F E3 FB 78 83 A1 00 14 7C 08 03 A6 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 }
	condition:
		$1
}

rule file_335_0_0 {
	meta:
		name = "_nl_explode_name"
		size = 668
		refs = "0104 __rawmemchr 0210 _nl_normalize_codeset 0234 strcmp 0274 free"
	strings:
		$1 = { 94 21 FF D0 7C 08 02 A6 7C 69 1B 78 90 01 00 34 38 00 00 00 93 A1 00 24 93 C1 00 28 93 E1 00 2C 90 05 00 00 90 06 00 00 90 07 00 00 90 08 00 00 90 64 00 00 88 09 00 00 2F 80 00 40 2B 00 00 40 41 9E 00 18 2C 00 00 00 2C 80 00 5F 41 99 00 88 2F 00 00 2E 40 82 00 8C 7F 03 48 00 41 9A 00 90 41 9E 00 C4 2F 00 00 5F 41 9A 00 E4 2F 00 00 2E 3B E0 00 00 41 9A 01 34 41 9E 00 B0 81 26 00 00 2F 89 00 00 41 9E 00 14 88 09 00 00 2F 80 00 00 40 9E 00 08 57 FF 07 B8 81 27 00 00 2F 89 00 00 41 9E 00 14 88 09 00 00 2F 80 00 00 40 9E 00 08 57 FF 07 FA 80 01 00 34 7F E3 FB 78 83 A1 00 24 7C 08 03 A6 83 C1 00 28 83 E1 00 2C 38 21 00 30 4E 80 00 20 41 A6 FF 84 39 29 00 01 4B FF FF 58 41 BA FF 78 39 29 00 01 4B FF FF 4C 7D 23 4B 78 90 A1 00 0C 38 80 00 00 90 C1 00 10 3B E0 00 00 90 E1 00 14 4? ?? ?? ?? 7C 69 1B 78 88 03 00 00 80 A1 00 0C 2F 80 00 40 80 C1 00 10 80 E1 00 14 4B FF FF 58 3B E0 00 00 38 09 00 01 39 60 00 00 99 69 00 00 90 05 00 00 88 09 00 01 2F 80 00 00 41 BE FF 3C 63 FF 00 08 4B FF FF 34 38 00 00 00 98 09 00 00 39 29 00 01 91 26 00 00 88 09 00 00 70 0B 00 FF 41 82 00 34 2F 8B 00 2E 41 9E 00 FC 2F 8B 00 40 40 BE 00 10 48 00 00 20 41 9E 00 EC 41 9A 00 18 8C 09 00 01 70 0B 00 FF 2F 8B 00 2E 2F 0B 00 40 40 82 FF E8 54 00 06 3E 3B E0 00 04 2F 80 00 40 4B FF FE D4 3B E0 00 02 38 00 00 00 98 09 00 00 39 29 00 01 91 27 00 00 88 09 00 00 2F 80 00 00 41 BE FE B8 2F 80 00 40 41 BE FF 5C 7D 3E 4B 78 48 00 00 08 41 9A 00 88 8C 1E 00 01 2F 80 00 00 2F 00 00 40 40 9E FF F0 38 00 00 00 7F 89 F0 00 41 BE FF AC 7D 23 4B 78 90 E1 00 14 7C 89 F0 50 91 01 00 08 90 A1 00 0C 90 C1 00 10 4? ?? ?? ?? 2F 83 00 00 81 01 00 08 7C 7D 1B 78 80 E1 00 14 90 68 00 00 41 9E 00 6C 80 67 00 00 7F A4 EB 78 4? ?? ?? ?? 80 A1 00 0C 2F 83 00 00 80 C1 00 10 80 E1 00 14 41 9E 00 28 88 1E 00 00 63 FF 00 01 7F C9 F3 78 2F 80 00 40 4B FF FE 1C 38 00 00 40 4B FF FF 8C 3B E0 00 06 4B FF FF 40 7F A3 EB 78 4? ?? ?? ?? 88 1E 00 00 7F C9 F3 78 80 A1 00 0C 2F 80 00 40 80 C1 00 10 80 E1 00 14 4B FF FD E8 3B E0 FF FF 4B FF FE 1C }
	condition:
		$1
}

rule file_336_0_0 {
	meta:
		name = "fseeko"
		size = 424
		refs = "0094 _IO_seekoff_unlocked 0138 __lll_lock_wait_private 01a4 _Unwind_Resume"
		altNames = "fseek"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 90 01 00 24 80 03 00 00 93 81 00 10 7C BC 2B 78 70 00 80 00 93 C1 00 18 7C 9E 23 78 93 E1 00 1C 7C 7F 1B 78 93 A1 00 14 40 82 00 50 80 63 00 48 3B A2 8B 60 81 23 00 08 7F 89 E8 00 41 9E 00 30 39 60 00 01 7D 20 18 28 7C 09 00 00 40 82 00 0C 7D 60 19 2D 40 A2 FF F0 4C 00 01 2C 2F 89 00 00 40 9E 00 D0 80 7F 00 48 93 A3 00 08 81 23 00 04 38 09 00 01 90 03 00 04 7F E3 FB 78 7F C5 FE 70 7F C6 F3 78 7F 87 E3 78 39 00 00 03 4? ?? ?? ?? 2F 83 FF FF 41 9E 00 6C 3B C0 00 00 80 1F 00 00 70 09 80 00 40 82 00 38 80 7F 00 48 81 23 00 04 38 09 FF FF 2F 80 00 00 90 03 00 04 40 9E 00 20 90 03 00 08 7C 00 04 AC 7D 20 18 28 7C 00 19 2D 40 A2 FF F8 2F 89 00 01 41 9D 00 38 80 01 00 24 7F C3 F3 78 83 81 00 10 7C 08 03 A6 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 2F 84 FF FF 3B C0 FF FF 40 9E FF 90 4B FF FF 90 80 82 8B 68 38 00 00 DD 38 A0 00 01 60 84 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 4B FF FF B0 4? ?? ?? ?? 4B FF FF 30 80 1F 00 00 7C 7E 1B 78 70 09 80 00 40 82 00 54 80 7F 00 48 80 03 00 04 30 00 FF FF 2F 80 00 00 90 03 00 04 40 9E 00 3C 90 03 00 08 7C 00 04 AC 7D 20 18 28 7C 00 19 2D 40 A2 FF F8 2F 89 00 01 40 BD 00 20 80 82 8B 68 38 00 00 DD 38 A0 00 01 60 84 00 01 38 C0 00 00 44 00 00 02 7C 00 00 26 7F C3 F3 78 4? ?? ?? ?? }
	condition:
		$1
}

rule file_337_0_0 {
	meta:
		name = "_dl_discover_osversion"
		size = 312
		refs = "001c __uname 00e8 __open 0100 __read 010c __close"
	strings:
		$1 = { 94 21 FE 10 7C 08 02 A6 38 61 00 48 90 01 01 F4 93 A1 01 E4 93 C1 01 E8 93 E1 01 EC 4? ?? ?? ?? 2F 83 00 00 39 61 00 CA 40 9E 00 B0 39 00 00 00 3B E0 00 00 89 2B 00 00 38 09 FF D0 54 09 06 3E 2B 89 00 09 41 9D 00 60 89 2B 00 01 39 6B 00 01 39 49 FF D0 55 4A 06 3E 2B 8A 00 09 41 9D 00 24 1C 00 00 0A 7D 40 4A 14 8D 2B 00 01 38 0A FF D0 39 49 FF D0 55 4A 06 3E 2B 8A 00 09 40 9D FF E4 2F 89 00 2E 57 FF 40 2E 39 08 00 01 7C 1F FB 78 40 9E 00 14 2F 88 00 03 41 9E 00 20 39 6B 00 01 4B FF FF 94 2F 88 00 02 41 9D 00 10 21 08 00 03 55 08 18 38 7F FF 40 30 80 01 01 F4 7F E3 FB 78 83 A1 01 E4 7C 08 03 A6 83 C1 01 E8 83 E1 01 EC 38 21 01 F0 4E 80 00 20 3C 60 ?? ?? 38 63 ?? ?? 38 80 00 00 4C C6 31 82 4? ?? ?? ?? 3B E0 FF FF 7C 7E 1B 79 41 80 FF C4 38 81 00 08 38 A0 00 40 4? ?? ?? ?? 7C 7D 1B 78 7F C3 F3 78 4? ?? ?? ?? 2F 9D 00 00 40 BD FF A4 2F 9D 00 3F 40 9D 00 08 3B A0 00 3F 7F A1 EA 14 38 00 00 00 98 1D 00 08 39 61 00 08 4B FF FE F8 }
	condition:
		$1
}

rule file_338_0_0 {
	meta:
		name = "__gconv_open"
		size = 2312
		refs = "0078 strchr 0106 _GLOBAL_OFFSET_TABLE_ 010e _nl_current_LC_CTYPE 0124 strlen 0150 mempcpy 0198 __gconv_find_transform 01c8 __gconv_translit_find 01f0 malloc 021c memset 0232 _nl_C_locobj 02a8 __strcasecmp_l 048a __libc_errno 04a4 __gconv_close_transform 050c free 0574 memcpy 064e __gconv_transliterate"
	strings:
		$1 = { 94 21 FF A0 7D 80 00 26 7C 08 02 A6 93 61 00 4C 7C 9B 23 78 38 80 00 2F 93 E1 00 5C 7C 3F 0B 78 93 21 00 44 7C D9 33 78 93 41 00 48 7C 7A 1B 78 93 81 00 50 7C BC 2B 78 93 A1 00 54 3B A0 00 00 93 C1 00 58 3B C0 00 00 90 01 00 64 91 E1 00 1C 92 01 00 20 92 21 00 24 92 41 00 28 92 61 00 2C 92 81 00 30 92 A1 00 34 92 C1 00 38 92 E1 00 3C 93 01 00 40 91 81 00 18 4? ?? ?? ?? 2C 03 00 00 41 82 00 28 38 63 00 01 38 80 00 2F 4? ?? ?? ?? 2C 03 00 00 41 82 00 14 88 03 00 01 3B 03 00 01 2F 80 00 00 40 9E 04 A0 7F 63 DB 78 38 80 00 2F 4? ?? ?? ?? 2C 03 00 00 41 82 00 28 38 63 00 01 38 80 00 2F 4? ?? ?? ?? 2C 03 00 00 41 82 00 14 88 03 00 01 39 23 00 01 2F 80 00 00 40 9E 07 08 88 1A 00 00 2F 80 00 2F 40 9E 00 84 88 1A 00 01 2F 80 00 2F 40 9E 00 78 88 1A 00 02 2F 80 00 00 40 9E 00 6C 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 81 29 00 00 81 29 00 00 83 49 00 5C 7F 43 D3 78 4? ?? ?? ?? 81 21 00 00 38 03 00 21 54 00 00 36 7C 00 00 D0 7D 21 01 6E 7F 44 D3 78 7C 65 1B 78 3B 41 00 17 57 5A 00 36 7F 43 D3 78 4? ?? ?? ?? 3D 20 ?? ?? 39 69 ?? ?? A1 29 ?? ?? 88 0B 00 02 B1 23 00 00 98 03 00 02 88 1B 00 00 2F 80 00 2F 40 9E 00 10 88 1B 00 01 2F 80 00 2F 41 9E 02 88 7F 43 D3 78 7F 64 DB 78 38 BF 00 08 38 DF 00 0C 7F 27 CB 78 4? ?? ?? ?? 3A 40 00 00 7C 71 1B 79 40 82 01 FC 2E 1E 00 00 41 92 00 38 7F DB F3 78 3B 40 00 00 80 1B 00 00 7F 63 DB 78 2F 80 00 00 41 9E 00 10 4? ?? ?? ?? 2F 83 00 00 40 9E 07 14 7F 7A DB 78 83 7B 00 04 2F 9B 00 00 40 9E FF D8 83 7F 00 0C 1F 5B 00 24 38 7A 00 08 4? ?? ?? ?? 2F 83 00 00 7C 74 1B 78 7C 72 1B 78 41 9E 02 80 80 1F 00 08 38 63 00 08 93 74 00 00 38 80 00 00 7F 45 D3 78 90 14 00 04 4? ?? ?? ?? 80 1F 00 0C 2F 80 00 00 41 9E 01 78 2E 1E 00 00 3F 00 ?? ?? 7E 97 A3 78 3B 20 00 00 3A C0 00 00 3A A0 00 00 3B 18 ?? ?? 1E 76 00 24 7D 34 9A 14 38 09 00 20 90 17 00 1C 41 92 00 EC 3A 13 00 20 7F DA F3 78 7E 14 82 14 80 1A 00 0C 3B 60 00 00 2F 80 00 00 40 BE 00 14 48 00 00 C0 80 1A 00 0C 7F 80 D8 40 40 9D 00 B4 81 7F 00 08 57 60 10 3A 81 3A 00 08 7F 05 C3 78 7D 6B CA 14 80 6B 00 0C 3B 7B 00 01 7C 89 00 2E 4? ?? ?? ?? 2C 03 00 00 40 82 FF CC 80 1A 00 18 90 7F 00 10 2F 80 00 00 41 9E 00 24 81 3F 00 08 38 7F 00 10 7C 09 03 A6 7D 29 CA 14 80 89 00 10 4E 80 04 21 2F 83 00 00 40 9E 00 58 38 60 00 14 4? ?? ?? ?? 2C 03 00 00 41 82 01 D0 80 1A 00 1C 81 5A 00 10 81 7A 00 14 92 A3 00 10 81 37 00 28 90 03 00 08 2F 89 00 00 80 1F 00 10 91 43 00 00 91 63 00 04 90 03 00 0C 41 9E 01 98 39 69 00 10 81 29 00 10 2F 89 00 00 40 9E FF F4 90 6B 00 00 83 5A 00 04 2F 9A 00 00 40 9E FF 28 83 5F 00 0C 38 1A FF FF 7F 80 B0 40 40 9D 05 7C 81 3F 00 08 93 B7 00 10 7D 29 CA 14 80 09 00 30 54 09 28 34 54 00 68 24 7F 69 00 50 7F 63 DB 78 4? ?? ?? ?? 2F 83 00 00 90 77 00 08 41 9E 01 40 3A D6 00 01 7F 9A B0 40 7C 63 DA 14 90 77 00 0C 3B 39 00 3C 3A F7 00 24 41 9D FE AC 39 7F 00 60 92 5C 00 00 7E 23 8B 78 80 0B 00 04 81 8B FF B8 7C 08 03 A6 81 EB FF BC 82 0B FF C0 7D 80 81 20 82 2B FF C4 82 4B FF C8 82 6B FF CC 82 8B FF D0 82 AB FF D4 82 CB FF D8 82 EB FF DC 83 0B FF E0 83 2B FF E4 83 4B FF E8 83 6B FF EC 83 8B FF F0 83 AB FF F4 83 CB FF F8 83 EB FF FC 7D 61 5B 78 4E 80 00 20 88 1B 00 02 2F 80 00 00 40 BE FD 74 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 81 29 00 00 81 29 00 00 83 69 00 5C 7F 63 DB 78 4? ?? ?? ?? 81 21 00 00 38 03 00 21 54 00 00 36 7C 00 00 D0 7D 21 01 6E 7F 64 DB 78 7C 65 1B 78 3B 61 00 17 57 7B 00 36 7F 63 DB 78 4? ?? ?? ?? 3D 20 ?? ?? 39 69 ?? ?? A1 29 ?? ?? 88 0B 00 02 B1 23 00 00 98 03 00 02 4B FF FD 08 3F C0 ?? ?? 3B DE ?? ?? 81 3E ?? ?? 7D 29 12 14 83 A9 00 00 80 7F 00 08 3A 20 00 03 80 9F 00 0C 3A 40 00 00 4? ?? ?? ?? 81 3E ?? ?? 7D 29 12 14 93 A9 00 00 4B FF FE EC 39 70 00 08 4B FF FE 78 2F 96 00 00 3F C0 ?? ?? 3B DE ?? ?? 81 3E ?? ?? 7D 29 12 14 83 A9 00 00 41 9E 00 60 3A D6 FF FF 1F 36 00 24 7F 34 CA 14 3B 39 00 28 83 79 00 00 2F 9B 00 00 41 9E 00 28 80 1B 00 08 83 5B 00 10 2F 80 00 00 40 9E 03 B8 7F 63 DB 78 4? ?? ?? ?? 2F 9A 00 00 7F 5B D3 78 40 9E FF E0 80 79 FF E0 3B 39 FF DC 4? ?? ?? ?? 2F 96 00 00 41 9E 00 0C 3A D6 FF FF 4B FF FF B8 7E 83 A3 78 4? ?? ?? ?? 4B FF FF 54 7D 3A C0 50 81 61 00 00 38 09 00 1F 54 00 00 36 7C 00 00 D0 7D 61 01 6E 7F 44 D3 78 7D 25 4B 78 39 61 00 17 55 6B 00 36 7F CB 49 AE 7D 63 5B 78 4? ?? ?? ?? 7C 7A 1B 78 7F 03 C3 78 4? ?? ?? ?? 81 21 00 00 38 03 00 1F 54 00 00 36 7C 00 00 D0 7D 21 01 6E 7C 65 1B 78 7F 04 C3 78 38 61 00 17 54 63 00 36 38 A5 00 01 4? ?? ?? ?? 88 03 00 00 7C 78 1B 78 2F 80 00 2C 40 9E 00 10 8C 18 00 01 2F 80 00 2C 41 9E FF F8 2F 80 00 00 3A 98 00 01 3B C0 00 00 3B A0 00 00 41 BE FA CC 89 34 00 00 38 14 00 01 2F 89 00 00 2F 09 00 2C 41 9E 00 20 41 9A 02 78 7C 14 03 78 89 34 00 00 38 14 00 01 2F 89 00 00 2F 09 00 2C 40 9E FF E8 2F 98 00 00 3B C0 00 00 3B A0 00 00 41 BE FA 8C 3E 60 ?? ?? 3E A0 ?? ?? 3A 73 ?? ?? 3A B5 ?? ?? 7F 03 C3 78 7E 64 9B 78 7E A5 AB 78 4? ?? ?? ?? 3D E0 ?? ?? 2F 83 00 00 3E 20 ?? ?? 3E E0 ?? ?? 39 EF ?? ?? 3A 31 ?? ?? 3A 40 00 01 3A F7 ?? ?? 3A 00 00 00 40 9E 00 E4 2F 9E 00 00 41 9E 01 C8 80 1E 00 10 7F CB F3 78 7F 80 B8 00 40 BE 00 18 48 00 00 5C 80 09 00 10 7D 2B 4B 78 7F 80 B8 00 41 9E 00 4C 81 2B 00 04 2F 89 00 00 40 9E FF E8 80 01 00 00 2F 8B 00 00 94 01 FF D0 39 41 00 17 55 4A 00 36 91 2A 00 00 91 2A 00 04 91 2A 00 14 91 2A 00 18 91 2A 00 1C 92 2A 00 08 92 4A 00 0C 92 EA 00 10 41 9E 01 A8 91 4B 00 04 88 14 00 00 7E 98 A3 78 2F 80 00 2C 40 9E 00 10 8C 18 00 01 2F 80 00 2C 41 9E FF F8 2F 80 00 00 41 BE F9 AC 39 38 00 01 48 00 00 08 7E 89 A3 78 88 09 00 00 3A 89 00 01 2F 80 00 00 2F 00 00 2C 41 9E 01 10 40 9A FF E8 9A 09 00 00 2F 98 00 00 41 BE F9 7C 7F 03 C3 78 7E 64 9B 78 7E A5 AB 78 4? ?? ?? ?? 2F 83 00 00 41 9E FF 24 7F 03 C3 78 7D E4 7B 78 7E A5 AB 78 4? ?? ?? ?? 2F 83 00 00 41 9E 00 C8 2F 9E 00 00 7F D6 F3 78 40 BE 00 0C 48 00 01 18 7C 16 03 78 80 16 00 00 7F 03 C3 78 7E A5 AB 78 2F 80 00 00 7C 04 03 78 41 9E 00 10 4? ?? ?? ?? 2F 83 00 00 41 BE FF 48 80 16 00 04 2F 80 00 00 40 9E FF D0 81 21 00 00 2F 96 00 00 95 21 FF D0 39 21 00 17 55 29 00 36 90 09 00 04 90 09 00 08 90 09 00 0C 90 09 00 10 90 09 00 14 90 09 00 18 90 09 00 1C 93 09 00 00 41 9E 01 04 91 36 00 04 4B FF FE FC 7D 3B 48 50 81 61 00 00 38 09 00 1F 54 00 00 36 7C 00 00 D0 7D 61 01 6E 38 00 00 00 7F 64 DB 78 39 61 00 17 55 6B 00 36 7C 0B 49 AE 7D 63 5B 78 7D 25 4B 78 4? ?? ?? ?? 7C 7B 1B 78 4B FF F8 C0 63 BD 00 02 4B FF FE B4 7D 34 4B 78 4B FF FE F8 80 01 00 00 94 01 FF D0 39 21 00 17 55 29 00 36 93 C9 00 00 93 C9 00 04 93 C9 00 14 93 C9 00 18 93 C9 00 1C 7D 3E 4B 78 92 29 00 08 92 49 00 0C 92 E9 00 10 4B FF FE 74 39 20 00 00 99 34 00 00 7C 14 03 78 4B FF FD 98 7D 5E 53 78 4B FF FE 5C 80 01 00 00 94 01 FF D0 39 21 00 17 55 29 00 36 93 C9 00 04 93 C9 00 08 93 C9 00 0C 93 C9 00 10 93 C9 00 14 93 C9 00 18 93 C9 00 1C 7D 3E 4B 78 93 09 00 00 4B FF FE 24 80 7B 00 0C 7C 09 03 A6 4E 80 04 21 4B FF FC 40 7E 94 9A 14 63 BD 00 01 93 B4 00 10 4B FF FA C8 7D 3E 4B 78 4B FF FD FC 2F 9A 00 00 41 9E 00 14 80 1B 00 04 90 1A 00 04 83 7B 00 04 4B FF F8 E4 83 DB 00 04 7F DB F3 78 4B FF F8 D8 }
	condition:
		$1
}

rule file_340_0_0 {
	meta:
		name = "__scalbnl"
		size = 1020
		refs = "01f0 __gcc_qadd 0230 __gcc_qmul"
		altNames = "__scalblnl"
	strings:
		$1 = { 94 21 FF 60 7C 08 02 A6 39 20 00 00 D8 21 00 60 D8 41 00 68 80 A1 00 60 80 C1 00 64 80 E1 00 68 81 01 00 6C 7C C4 33 78 90 A1 00 10 90 C1 00 14 90 E1 00 18 91 01 00 1C 93 C1 00 98 7C FE 3B 78 93 E1 00 9C 7D 1F 43 78 80 E1 00 10 81 01 00 14 80 C1 00 1C 7C EB FE 70 7C EC A6 70 90 01 00 A4 55 8A 05 7E 93 81 00 90 7D 2B 53 79 7C A0 2B 78 80 A1 00 18 93 A1 00 94 7C CC 33 78 7C AB 2B 78 93 61 00 8C 7C DD 33 78 7C BC 2B 78 40 82 01 24 7C AA 3B 78 7C C9 43 78 55 4A 00 7E 7D 5B 4B 79 41 82 00 D4 90 E1 00 70 3C 80 ?? ?? 39 20 00 00 91 01 00 74 C0 04 ?? ?? C9 A1 00 70 FC 00 03 72 D8 01 00 70 80 E1 00 70 81 01 00 74 7C FE FE 70 7C FF A6 70 57 EA 05 7E 31 4A FF CA 7D 29 01 D4 38 80 00 00 60 84 C3 50 7F 83 20 00 41 9D 01 14 7C 7F 1B 78 7C 7E FE 70 7D 4A F8 14 7D 29 F1 14 2F 89 00 00 41 9D 00 FC 41 9E 00 F0 3C 80 FF FF 60 84 3C B0 7F 03 20 00 41 98 01 8C 40 9D 02 00 54 A0 00 7E 7C 04 33 79 55 49 A0 16 54 E0 03 00 7D 20 03 78 7D 04 43 78 41 82 01 D8 7D 67 FE 70 7D 68 A6 70 39 20 00 00 55 0A 05 7E 7D 28 53 79 41 82 01 80 7F FF 50 14 7F DE 49 14 2F 9E 00 00 40 9D 02 28 57 FE A0 16 57 89 03 00 7F DE 4B 78 7F BF EB 78 90 01 00 60 80 01 00 A4 93 C1 00 68 7C 08 03 A6 93 E1 00 6C 90 81 00 64 C8 41 00 68 C8 21 00 60 83 61 00 8C 83 81 00 90 83 A1 00 94 83 C1 00 98 83 E1 00 9C 38 21 00 A0 4E 80 00 20 2F 89 00 00 40 9E FF 2C 2F 8A 07 FF 40 9E FF 24 90 01 00 60 90 81 00 64 93 C1 00 68 93 E1 00 6C C8 21 00 60 C8 41 00 68 90 01 00 60 90 81 00 64 93 C1 00 68 93 E1 00 6C C8 61 00 60 C8 81 00 68 4? ?? ?? ?? 48 00 00 40 2B 0A 07 FE 40 99 FF 10 2F 80 00 00 3D 20 ?? ?? 39 29 ?? ?? C8 29 00 00 C8 49 00 08 40 9C 00 14 3D 60 ?? ?? 39 6B ?? ?? C8 2B 00 00 C8 4B 00 08 C8 69 00 00 C8 89 00 08 4? ?? ?? ?? D8 21 00 60 81 21 00 60 D8 41 00 68 7D 20 4B 78 90 01 00 60 80 01 00 A4 81 41 00 64 81 61 00 68 7C 08 03 A6 81 81 00 6C 7D 44 53 78 7D 7E 5B 78 90 81 00 64 7D 9F 63 78 93 C1 00 68 93 E1 00 6C C8 21 00 60 C8 41 00 68 83 61 00 8C 83 81 00 90 83 A1 00 94 83 C1 00 98 83 E1 00 9C 38 21 00 A0 4E 80 00 20 38 C0 FF CB 7F 8A 30 40 40 BC 00 94 2F 80 00 00 3D 20 ?? ?? 39 29 ?? ?? C8 29 00 00 C8 49 00 08 40 BC FF 70 3D 60 ?? ?? 39 6B ?? ?? C8 2B 00 00 C8 4B 00 08 4B FF FF 5C 91 61 00 70 3D 00 ?? ?? 39 20 00 00 91 81 00 74 C0 08 ?? ?? C9 A1 00 70 FC 00 03 72 D8 01 00 70 83 81 00 70 83 A1 00 74 7F 8B FE 70 7F 8C A6 70 55 8A 05 7E 31 4A FF CA 7D 29 01 D4 4B FF FE 48 7C BE 2B 78 7C DF 33 78 4B FF FE 5C 40 9E 00 0C 2F 8A 00 00 40 9E FD FC 2F 89 FF FF 41 BC FF 78 41 BE FF 68 31 4A 00 36 7D 29 01 94 91 01 00 44 55 40 A0 16 54 E7 03 00 7C 07 3B 78 55 6B 00 00 90 E1 00 40 38 00 00 00 91 61 00 48 3C 80 ?? ?? 3D 00 ?? ?? 90 01 00 4C 38 84 ?? ?? 39 08 ?? ?? C8 64 00 00 C8 88 00 00 C8 21 00 40 C8 41 00 48 4? ?? ?? ?? 4B FF FE B0 40 9E 00 0C 2F 9F 00 00 40 9E FD D4 2F 9E FF FF 41 9C 00 14 40 9E 00 1C 39 20 FF CB 7F 9F 48 40 40 9C 00 10 57 9E 00 00 3B E0 00 00 4B FF FD C0 33 FF 00 36 7F DE 01 94 93 A1 00 74 57 E8 A0 16 57 8B 03 00 7D 09 5B 78 91 21 00 70 3D 60 ?? ?? C9 A1 00 70 C0 0B ?? ?? FC 0D 00 32 D8 01 00 70 81 21 00 70 81 41 00 74 7D 3E 4B 78 7D 5F 53 78 4B FF FD 7C }
	condition:
		$1
}

rule file_342_0_0 {
	meta:
		name = "atexit"
		size = 60
		refs = "000a __dso_handle 0028 __cxa_atexit"
	strings:
		$1 = { 7C 08 02 A6 94 21 FF F0 3D 20 ?? ?? 90 01 00 14 38 09 ?? ?? 2F 80 00 00 38 A0 00 00 41 9E 00 08 80 A9 ?? ?? 38 80 00 00 4? ?? ?? ?? 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 }
	condition:
		$1
}

rule file_343_0_0 {
	meta:
		name = "utime"
		size = 16
		refs = "000c __syscall_error"
	strings:
		$1 = { 38 00 00 1E 44 00 00 02 4C A3 00 20 4? ?? ?? ?? }
	condition:
		$1
}

rule file_344_0_0 {
	meta:
		name = "strchr"
		size = 216
	strings:
		$1 = { 50 84 44 2E 39 60 FF FF 50 84 80 1E 54 6A 1E F8 3C C0 FE FF 3C E0 7F 7F 54 68 00 3A 38 C6 FE FF 38 E7 7F 7F 80 A8 00 00 7D 6B 54 30 7C A5 5B 38 7C 06 2A 14 7C E9 28 F8 7C 00 48 39 7C 8C 2A 78 7D 8C 5B 38 48 00 00 20 84 A8 00 04 7C 00 48 39 7C 06 2A 14 7C E9 28 F8 40 82 00 5C 7C 00 48 39 7C 8C 2A 78 7C 06 62 14 7C E9 60 F8 41 82 FF DC 7C 00 48 39 38 60 00 00 4D 82 00 20 7C E6 28 38 7C EB 2B 78 7C E0 60 38 7C EA 63 78 7C C6 3A 14 7C 00 3A 14 7D 65 30 F8 7D 49 00 F8 7C 05 48 40 4D 81 00 20 7D 24 00 34 54 84 E8 FE 7C 68 22 14 4E 80 00 20 7C E0 60 38 7C EA 63 78 7C 00 3A 14 7D 49 00 F8 7D 24 00 34 39 08 FF FC 54 84 E8 FE 7C 68 22 14 4E 80 00 20 }
	condition:
		$1
}

rule file_345_0_0 {
	meta:
		name = "__posix_openpt"
		size = 328
		refs = "003c __open 008c __statfs 00cc __close 00d2 _GLOBAL_OFFSET_TABLE_ 00de __libc_errno"
		altNames = "posix_openpt"
	strings:
		$1 = { 94 21 FF A0 7C 08 02 A6 7C 64 1B 78 93 E1 00 5C 3F E0 ?? ?? 90 01 00 64 80 1F ?? ?? 93 A1 00 54 3B BF ?? ?? 2F 80 00 00 93 C1 00 58 40 9E 00 FC 3C 60 ?? ?? 38 63 ?? ?? 4C C6 31 82 4? ?? ?? ?? 2F 83 FF FF 7C 7E 1B 78 41 9E 00 B0 80 1D 00 04 2F 80 00 00 41 9E 00 2C 38 00 00 01 90 1D 00 04 80 01 00 64 7F C3 F3 78 83 A1 00 54 7C 08 03 A6 83 C1 00 58 83 E1 00 5C 38 21 00 60 4E 80 00 20 3C 60 ?? ?? 38 63 ?? ?? 38 81 00 08 4? ?? ?? ?? 2F 83 00 00 40 9E 00 10 80 01 00 08 2F 80 1C D1 41 BE FF B8 3C 60 ?? ?? 38 63 ?? ?? 38 81 00 08 4? ?? ?? ?? 2F 83 00 00 40 9E 00 10 80 01 00 08 2F 80 13 73 41 9E FF 94 7F C3 F3 78 4? ?? ?? ?? 3D 20 ?? ?? 39 29 ?? ?? 38 00 00 01 81 29 ?? ?? 90 1F ?? ?? 7D 29 12 14 38 00 00 02 3B C0 FF FF 90 09 00 00 4B FF FF 6C 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 80 09 00 00 2F 80 00 02 41 9E 00 0C 2F 80 00 13 40 9E FF 48 38 00 00 01 90 1F ?? ?? 4B FF FF 3C 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 38 00 00 02 90 09 00 00 3B C0 FF FF 4B FF FF 1C }
	condition:
		$1
}

rule file_345_1_0 {
	meta:
		name = "__bsd_getpt"
		size = 240
		refs = "0012 _GLOBAL_OFFSET_TABLE_ 002e __libc_errno 0036 __libc_ptyname1 003a __libc_ptyname2 0054 mempcpy 00a4 __open"
	strings:
		$1 = { 94 21 FF D0 7C 08 02 A6 3C 80 ?? ?? 93 A1 00 24 3F A0 ?? ?? 38 61 00 08 38 84 ?? ?? 90 01 00 34 38 A0 00 08 3B BD ?? ?? 93 41 00 18 83 BD ?? ?? 93 61 00 1C 3F 40 ?? ?? 3F 60 ?? ?? 93 81 00 20 3B 5A ?? ?? 3B 7B ?? ?? 93 C1 00 28 7F BD 12 14 93 E1 00 2C 4? ?? ?? ?? 38 00 00 00 98 03 00 02 7C 7C 1B 78 3B C3 00 01 38 00 00 70 98 1C 00 00 7F 7F DB 78 38 00 00 30 48 00 00 1C 80 1D 00 00 2F 80 00 02 41 9E 00 2C 8C 1F 00 01 2F 80 00 00 41 9E 00 48 98 1E 00 00 38 61 00 08 38 80 00 02 4C C6 31 82 4? ?? ?? ?? 2F 83 FF FF 41 9E FF D0 80 01 00 34 83 41 00 18 7C 08 03 A6 83 61 00 1C 83 81 00 20 83 A1 00 24 83 C1 00 28 83 E1 00 2C 38 21 00 30 4E 80 00 20 8C 1A 00 01 2F 80 00 00 40 9E FF 8C 38 00 00 02 90 1D 00 00 4B FF FF C4 }
	condition:
		$1
}

rule file_345_2_0 {
	meta:
		name = "__getpt"
		size = 60
		refs = "0010 __posix_openpt 0038 __bsd_getpt"
		altNames = "getpt"
	strings:
		$1 = { 94 21 FF F0 7C 08 02 A6 38 60 00 02 90 01 00 14 4? ?? ?? ?? 2F 83 FF FF 41 9E 00 14 80 01 00 14 38 21 00 10 7C 08 03 A6 4E 80 00 20 80 01 00 14 38 21 00 10 7C 08 03 A6 4? ?? ?? ?? }
	condition:
		$1
}

rule file_346_0_0 {
	meta:
		name = "__bb_exit_func"
		size = 616
		refs = "003c _IO_new_fopen 0078 fwrite_unlocked 007e __bb_head 0100 __overflow 01f4 _IO_new_fclose 0228 perror"
	strings:
		$1 = { 94 21 FF B0 7C 08 02 A6 3C 80 ?? ?? 93 C1 00 48 3F C0 ?? ?? 3B DE ?? ?? 7F C3 F3 78 93 E1 00 4C 38 84 ?? ?? 90 01 00 54 93 21 00 34 93 41 00 38 93 61 00 3C 93 81 00 40 93 A1 00 44 4? ?? ?? ?? 7C 7F 1B 79 41 82 01 E0 80 1F 00 00 3D 20 ?? ?? 38 61 00 0C 60 00 80 00 90 1F 00 00 38 80 00 14 38 A0 00 01 80 09 ?? ?? 7F E6 FB 78 90 01 00 0C 38 00 00 01 90 01 00 10 4? ?? ?? ?? 3D 20 ?? ?? 83 69 ?? ?? 2F 9B 00 00 41 9E 01 68 3B 41 00 0D 3B 20 00 02 81 7F 00 14 81 3F 00 18 80 1B 00 0C 7F 8B 48 40 90 01 00 08 40 9C 01 AC 39 2B 00 01 9B 2B 00 00 91 3F 00 14 81 7F 00 18 3B C1 00 09 38 09 00 01 7F 8B 48 40 40 9D 00 30 89 7E FF FF 99 69 00 00 90 1F 00 14 3B DE 00 01 7F 9E D0 00 41 9E 00 2C 81 3F 00 14 81 7F 00 18 38 09 00 01 7F 8B 48 40 41 9D FF D8 88 9E FF FF 7F E3 FB 78 4? ?? ?? ?? 2F 83 FF FF 40 BE FF D0 80 01 00 08 3B 80 00 00 2F 80 00 00 41 9E 00 CC 83 BB 00 14 57 9E 10 3A 38 00 00 04 81 3F 00 14 7F BD F2 14 90 01 00 28 3B BD 00 01 80 1F 00 18 7F 80 48 40 40 9D 00 F0 88 1D FF FF 98 09 00 00 39 29 00 01 91 3F 00 14 80 01 00 28 3B BD 00 01 35 60 FF FF 91 61 00 28 40 82 FF D4 80 1B 00 08 39 60 00 04 91 61 00 28 39 69 00 01 7F C0 F2 14 80 1F 00 18 3B DE 00 01 7F 80 48 40 40 9D 00 38 88 1E FF FF 98 09 00 00 91 7F 00 14 80 01 00 28 3B DE 00 01 35 20 FF FF 91 21 00 28 41 82 00 2C 81 3F 00 14 80 1F 00 18 39 69 00 01 7F 80 48 40 41 9D FF D0 88 9E FF FF 7F E3 FB 78 4? ?? ?? ?? 2F 83 FF FF 40 BE FF C8 80 01 00 08 3B 9C 00 01 7F 80 E0 40 41 9D FF 3C 83 7B 00 10 2F 9B 00 00 40 9E FE A8 7F E3 FB 78 4? ?? ?? ?? 80 01 00 54 83 21 00 34 7C 08 03 A6 83 41 00 38 83 61 00 3C 83 81 00 40 83 A1 00 44 83 C1 00 48 83 E1 00 4C 38 21 00 50 4E 80 00 20 7F C3 F3 78 4? ?? ?? ?? 4B FF FF CC 88 9D FF FF 7F E3 FB 78 4? ?? ?? ?? 2F 83 FF FF 40 9E 00 0C 81 3F 00 14 4B FF FF 20 81 3F 00 14 4B FF FF 04 7F E3 FB 78 38 80 00 02 4? ?? ?? ?? 81 3F 00 14 4B FF FE 54 }
	condition:
		$1
}

rule file_347_0_0 {
	meta:
		name = "accept4"
		size = 236
		refs = "0074 __libc_enable_asynccancel 00a8 __libc_disable_asynccancel 00b6 _GLOBAL_OFFSET_TABLE_ 00be __libc_errno"
	strings:
		$1 = { 94 21 FF E0 7C 08 02 A6 93 61 00 0C 7C 7B 1B 78 93 81 00 10 7C 9C 23 78 93 A1 00 14 7C BD 2B 78 93 C1 00 18 7C DE 33 78 90 01 00 24 93 E1 00 1C 80 02 8B 60 2F 80 00 00 40 9E 00 3C 38 00 01 58 44 00 00 02 7C 00 00 26 74 09 10 00 40 82 00 68 80 01 00 24 83 61 00 0C 7C 08 03 A6 83 81 00 10 83 A1 00 14 83 C1 00 18 83 E1 00 1C 38 21 00 20 4E 80 00 20 4? ?? ?? ?? 38 00 01 58 7C 7F 1B 78 7F 84 E3 78 7F 63 DB 78 7F A5 EB 78 7F C6 F3 78 44 00 00 02 7C 00 00 26 74 09 10 00 7C 7E 1B 78 40 82 00 30 7F E3 FB 78 4? ?? ?? ?? 7F C3 F3 78 4B FF FF A0 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 90 69 00 00 38 60 FF FF 4B FF FF 84 3D 20 ?? ?? 39 29 ?? ?? 81 29 ?? ?? 7D 29 12 14 90 69 00 00 3B C0 FF FF 4B FF FF BC }
	condition:
		$1
}

rule file_348_0_0 {
	meta:
		name = "dysize"
		size = 88
	strings:
		$1 = { 70 69 00 03 7C 60 1B 78 38 60 01 6D 4C 82 00 20 3D 60 51 EB 61 6B 85 1F 7D 60 58 96 7C 09 FE 70 7D 6A 2E 70 7D 49 50 50 1D 4A 00 64 7F 80 50 00 38 60 01 6E 4C 9E 00 20 7D 63 3E 70 7C 69 18 50 1C 63 01 90 7C 03 1A 78 7C 63 00 34 54 63 D9 7E 38 63 01 6D 4E 80 00 20 }
	condition:
		$1
}

rule file_349_0_0 {
	meta:
		name = "__statvfs64"
		size = 160
		refs = "0024 __statfs64 005c __xstat64 007c __internal_statvfs64"
	strings:
		$1 = { 94 21 FF 20 7C 08 02 A6 93 A1 00 D4 7C 9D 23 78 38 81 00 08 93 C1 00 D8 7C 7E 1B 78 93 E1 00 DC 90 01 00 E4 4? ?? ?? ?? 7C 7F 1B 79 41 82 00 24 80 01 00 E4 7F E3 FB 78 83 A1 00 D4 7C 08 03 A6 83 C1 00 D8 83 E1 00 DC 38 21 00 E0 4E 80 00 20 38 60 00 03 7F C4 F3 78 38 A1 00 60 4? ?? ?? ?? 38 C0 00 00 2F 83 FF FF 41 9E 00 08 38 C1 00 60 7F C3 F3 78 7F A4 EB 78 38 A1 00 08 4? ?? ?? ?? 80 01 00 E4 7F E3 FB 78 83 A1 00 D4 7C 08 03 A6 83 C1 00 D8 83 E1 00 DC 38 21 00 E0 4E 80 00 20 }
	condition:
		$1
}

rule file_351_0_0 {
	meta:
		name = "__scalbn"
		size = 380
		altNames = "__scalbln"
	strings:
		$1 = { 94 21 FF E0 D8 21 00 08 81 21 00 08 81 41 00 0C 55 2B 65 7F 7D 20 4B 78 40 82 00 88 55 20 00 7E 7C 09 53 79 41 82 00 70 3D 20 ?? ?? C0 09 ?? ?? FD A1 00 32 D9 A1 00 08 81 21 00 08 55 2B 65 7E 7D 20 4B 78 39 6B FF CA 39 20 00 00 61 29 C3 50 7F 83 48 00 41 9D 00 6C 7D 2B 1A 14 2F 89 07 FE 41 9D 00 60 3D 60 FF FF 61 6B 3C B0 7F 83 58 00 41 9C 00 84 2F 89 00 00 40 9D 00 A8 81 81 00 0C 55 29 A0 16 54 00 03 00 7D 2B 03 78 91 81 00 0C 91 61 00 08 C8 21 00 08 38 21 00 20 4E 80 00 20 2F 8B 07 FF 40 9E FF A4 C8 01 00 08 FC 00 00 2A D8 01 00 08 C8 21 00 08 38 21 00 20 4E 80 00 20 80 01 00 08 3D 20 ?? ?? C8 09 ?? ?? 2F 80 00 00 40 9C 00 0C 3D 60 ?? ?? C8 0B ?? ?? C9 A9 ?? ?? FD A0 03 72 D9 A1 00 08 C8 21 00 08 38 21 00 20 4E 80 00 20 81 21 00 08 2F 89 00 00 3D 20 ?? ?? C8 09 ?? ?? 41 9C 00 38 C9 A9 ?? ?? FD A0 03 72 D9 A1 00 08 C8 21 00 08 38 21 00 20 4E 80 00 20 2F 89 FF C