private rule architecture {
	meta:
		bits = 32
		endianness = "little"
		architecture = "MIPS"
	condition:
		true
}

rule file_0_0_0 {
	meta:
		name = "gfx_card_getter"
		size = 68
		refs = "000c .bss"
	strings:
		$1 = { 08 00 80 04 90 00 02 24 18 00 82 00 ?? ?? 04 3C ?? ?? 83 8C 12 10 00 00 21 18 62 00 08 00 E0 03 04 00 62 24 03 00 A0 54 ?? ?? 02 3C 08 00 E0 03 21 10 00 00 ?? ?? 43 8C 21 10 00 00 08 00 E0 03 00 00 A3 AC }
	condition:
		$1
}

rule file_0_1_0 {
	meta:
		name = "gfx_mode_getter"
		size = 212
		refs = "0000 .bss 0024 $LC0 0040 uconvert 0084 uszprintf 00cc .text"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 43 8C D0 FF BD 27 28 00 B1 AF 24 00 B0 AF 2C 00 BF AF 21 80 80 00 21 00 80 04 3C 01 71 8C ?? ?? 04 3C 53 41 05 3C 75 63 07 3C ?? ?? 84 24 38 43 A5 34 2E 72 E7 34 21 30 A0 03 ?? ?? ?? 0? 20 00 08 24 90 00 08 24 18 00 28 02 ?? ?? 03 3C ?? ?? 67 8C 21 30 40 00 00 49 10 00 ?? ?? 10 3C ?? ?? 04 26 40 00 05 24 ?? ?? 10 26 12 40 00 00 21 38 E8 00 88 00 E2 8C 21 10 49 00 04 00 48 8C ?? ?? ?? 0? 00 00 47 8C 2C 00 BF 8F 21 10 00 02 28 00 B1 8F 24 00 B0 8F 08 00 E0 03 30 00 BD 27 E0 FF A0 10 ?? ?? 04 3C 90 00 04 24 18 00 24 02 ?? ?? 03 3C ?? ?? 62 8C 21 80 00 00 12 20 00 00 21 10 44 00 8C 00 43 8C ?? ?? ?? 0? 00 00 A3 AC }
	condition:
		$1
}

rule file_0_2_0 {
	meta:
		name = "gfx_depth_getter"
		size = 528
		refs = "0000 .bss 0080 $LC1 0094 uconvert 009c .rodata 00bc uszprintf 00c8 get_config_text 00c4 $LC2 00d8 ustrzcat 00e0 $LC3 0140 $LC4 016c $LC5 0188 $LC6 0208 .text"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 48 8C ?? ?? 02 3C ?? ?? 43 8C 3C 01 07 8D 90 00 02 24 74 01 06 8D 18 00 E2 00 68 FF BD 27 94 00 BF AF 00 31 06 00 90 00 B3 AF 8C 00 B2 AF 88 00 B1 AF 84 00 B0 AF 12 38 00 00 21 18 67 00 88 00 62 8C 62 00 80 04 21 30 46 00 FF FF 11 24 FF FF 05 24 01 00 31 26 21 10 D1 00 08 00 43 80 01 00 60 54 01 00 A5 24 2A 10 A4 00 FA FF 40 54 01 00 31 26 53 41 12 3C 75 63 13 3C ?? ?? 04 3C 80 00 08 24 ?? ?? 84 24 38 43 45 36 21 30 A0 03 ?? ?? ?? 0? 2E 72 67 36 ?? ?? 03 3C 80 88 11 00 ?? ?? 63 24 21 18 23 02 00 00 67 8C ?? ?? 10 3C 21 30 40 00 40 00 05 24 ?? ?? ?? 0? ?? ?? 04 26 ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 84 24 21 30 40 00 ?? ?? 04 26 ?? ?? ?? 0? 40 00 05 24 ?? ?? 04 3C 2E 72 67 36 80 00 08 24 ?? ?? 84 24 38 43 45 36 ?? ?? ?? 0? 21 30 A0 03 21 30 40 00 ?? ?? 04 26 ?? ?? ?? 0? 40 00 05 24 ?? ?? 03 3C ?? ?? 63 24 21 88 23 02 00 00 24 8E 2E 72 67 36 80 00 08 24 38 43 45 36 ?? ?? ?? 0? 21 30 A0 03 21 30 40 00 ?? ?? 04 26 ?? ?? ?? 0? 40 00 05 24 ?? ?? 04 3C 2E 72 67 36 80 00 08 24 ?? ?? 84 24 38 43 45 36 ?? ?? ?? 0? 21 30 A0 03 21 30 40 00 40 00 05 24 ?? ?? ?? 0? ?? ?? 04 26 ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 84 24 21 30 40 00 ?? ?? 04 26 ?? ?? ?? 0? 40 00 05 24 ?? ?? 04 3C ?? ?? 84 24 38 43 45 36 2E 72 67 36 21 30 A0 03 ?? ?? ?? 0? 80 00 08 24 21 30 40 00 ?? ?? 04 26 ?? ?? ?? 0? 40 00 05 24 ?? ?? 02 26 94 00 BF 8F 90 00 B3 8F 8C 00 B2 8F 88 00 B1 8F 84 00 B0 8F 08 00 E0 03 98 00 BD 27 A8 FF A0 10 FF FF 11 24 21 20 00 00 21 38 00 00 05 00 08 24 21 10 C4 00 08 00 43 80 02 00 60 10 01 00 84 24 01 00 E7 24 FB FF 88 54 21 10 C4 00 00 00 A7 AC ?? ?? ?? 0? 21 10 00 00 }
	condition:
		$1
}

rule file_0_3_0 {
	meta:
		name = "change_proc"
		size = 648
		refs = "0014 .bss 00f0 .text 0128 object_message 0134 .data 0174 .rodata"
	strings:
		$1 = { 24 00 A6 8C 90 00 02 24 E8 FF BD 27 18 00 C2 00 10 00 B3 AF ?? ?? 13 3C ?? ?? 6F 8E 28 00 AC 8C 08 00 B1 AF ?? ?? 11 3C ?? ?? 2B 8E 04 00 B0 AF 21 80 A0 00 00 29 0C 00 AC 01 6A 8D 14 00 BF AF 0C 00 B2 AF 21 38 00 00 FF FF 08 24 05 00 09 24 12 10 00 00 21 10 E2 01 88 00 43 8C 21 28 65 00 00 00 AD 8C 04 00 AE 8C 21 10 A7 00 08 00 43 80 05 00 60 50 01 00 E7 24 01 00 08 25 59 00 48 11 ?? ?? 02 3C 01 00 E7 24 F8 FF E9 14 21 10 A7 00 FF FF 12 24 0F 00 02 24 09 00 82 50 3C 01 62 8D 14 00 BF 8F 21 10 00 00 10 00 B3 8F 0C 00 B2 8F 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 18 00 BD 27 21 00 C2 10 50 01 64 25 24 00 02 AE 24 00 80 AC 24 00 02 8E 90 00 03 24 18 00 43 00 12 10 00 00 21 10 E2 01 8C 00 46 8C 0D 00 C0 18 21 28 00 00 ?? ?? ?? 0? 88 00 43 8C 2A 10 A6 00 08 00 40 10 10 00 63 24 00 00 62 8C FB FF 4D 54 01 00 A5 24 04 00 62 8C F8 FF 4E 54 01 00 A5 24 24 00 85 AC 28 00 80 AC 03 00 05 24 ?? ?? ?? 0? 21 30 00 00 ?? ?? 23 8E ?? ?? 02 3C ?? ?? 48 24 74 01 6C 8C 2D 00 68 10 28 00 0C AE ?? ?? 23 8E 74 01 66 8C D3 FF 86 11 ?? ?? 02 3C ?? ?? 48 24 D0 FF 68 14 28 00 06 AE 24 00 04 8E 90 00 02 24 ?? ?? 65 8E 18 00 82 00 ?? ?? 02 3C ?? ?? 47 24 00 31 06 00 ?? ?? 03 3C ?? ?? 63 24 FF FF 09 24 12 20 00 00 21 28 A4 00 88 00 A2 8C 21 28 46 00 08 00 A2 80 04 00 40 10 01 00 A5 24 00 00 E2 8C 32 00 42 12 01 00 29 25 04 00 E7 24 F9 FF E3 54 08 00 A2 80 AC 01 00 AD ?? ?? 04 3C ?? ?? 84 24 03 00 05 24 21 30 00 00 ?? ?? ?? 0? B0 01 00 AD ?? ?? ?? 0? 14 00 BF 8F 80 18 07 00 ?? ?? 42 24 21 18 62 00 ?? ?? ?? 0? 00 00 72 8C 24 00 04 8E 90 00 02 24 ?? ?? 65 8E 18 00 82 00 ?? ?? 02 3C ?? ?? 47 24 00 31 0C 00 ?? ?? 03 3C ?? ?? 63 24 FF FF 09 24 12 20 00 00 21 28 A4 00 88 00 A2 8C 21 28 46 00 08 00 A2 80 04 00 40 10 01 00 A5 24 00 00 E2 8C 0F 00 42 12 01 00 29 25 04 00 E7 24 F9 FF E3 54 08 00 A2 80 AC 01 00 AD ?? ?? 04 3C ?? ?? 84 24 03 00 05 24 21 30 00 00 ?? ?? ?? 0? B0 01 00 AD ?? ?? ?? 0? 28 00 0C 8E ?? ?? ?? 0? AC 01 09 AD ?? ?? ?? 0? AC 01 09 AD }
	condition:
		$1
}

rule file_0_4_0 {
	meta:
		name = "add_mode"
		size = 336
		refs = "0040 .text 0068 .rodata 00d0 _al_sane_realloc"
	strings:
		$1 = { E8 FF BD 27 08 00 B2 AF 21 90 A0 00 00 00 A5 8C 10 00 B4 AF 0C 00 B3 AF 04 00 B1 AF 00 00 B0 AF 14 00 BF AF 21 88 80 00 21 80 C0 00 21 98 E0 00 24 00 A0 18 21 A0 00 01 00 00 84 8C 21 30 00 00 ?? ?? ?? 0? 21 18 80 00 1F 00 E0 10 10 00 63 24 00 00 62 8C 01 00 C6 24 FB FF 50 14 2A 38 C5 00 04 00 62 8C F8 FF 53 14 ?? ?? 02 3C ?? ?? 44 24 21 28 00 00 05 00 06 24 00 00 82 8C 05 00 82 12 04 00 84 24 01 00 A5 24 FC FF A6 54 00 00 82 8C FF FF 05 24 FF FF 02 24 21 18 65 00 08 00 62 A0 14 00 BF 8F 21 10 00 00 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 18 00 BD 27 00 00 84 8C 01 00 A5 24 00 00 45 AE ?? ?? ?? 0? 00 29 05 00 00 00 43 8E 00 00 22 AE 21 20 00 00 FF FF 63 24 00 29 03 00 21 10 45 00 04 00 53 AC 00 00 50 AC ?? ?? 02 3C ?? ?? 46 24 05 00 07 24 00 00 23 8E 00 00 C2 8C 04 00 C6 24 21 18 65 00 26 10 82 02 21 18 64 00 01 00 42 2C 01 00 84 24 F7 FF 87 14 08 00 62 A0 14 00 BF 8F 21 10 00 00 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_0_5_0 {
	meta:
		name = "create_mode_list"
		size = 716
		refs = "0048 .data 005c .rodata 00c4 _al_sane_realloc 0138 get_gfx_mode_list 0194 .text 01ec destroy_gfx_mode_list"
	strings:
		$1 = { C8 FF BD 27 24 00 B5 AF 21 A8 80 00 00 00 84 8C 28 00 B6 AF 34 00 BF AF 30 00 BE AF 2C 00 B7 AF 20 00 B4 AF 1C 00 B3 AF 18 00 B2 AF 14 00 B1 AF 10 00 B0 AF 21 B0 A0 00 3A 00 80 14 00 00 A0 AF 8C 00 A0 AE 8F 00 C0 12 ?? ?? 02 3C ?? ?? 52 8C 18 00 40 12 ?? ?? 02 3C ?? ?? 54 24 ?? ?? 02 3C ?? ?? 03 3C ?? ?? 57 24 8C 00 A2 26 ?? ?? 7E 24 08 00 A2 AF 00 00 93 8E 21 80 C0 03 00 00 11 8E 00 00 A4 8E 21 28 40 02 21 30 60 02 21 38 20 02 09 F8 C0 02 04 00 10 26 63 00 40 10 08 00 A5 8F F7 FF 17 56 00 00 11 8E 0C 00 92 8E F1 FF 40 16 10 00 94 26 8C 00 B0 8E 09 00 00 1A 00 00 A4 8F 01 00 05 26 ?? ?? ?? 0? 00 29 05 00 00 19 10 00 21 18 43 00 04 00 60 AC 00 00 A2 AF 00 00 60 AC 00 00 A3 8F 34 00 BF 8F FF FF 02 24 84 00 A2 AE 88 00 A3 AE 21 10 00 00 30 00 BE 8F 2C 00 B7 8F 28 00 B6 8F 24 00 B5 8F 20 00 B4 8F 1C 00 B3 8F 18 00 B2 8F 14 00 B1 8F 10 00 B0 8F 08 00 E0 03 38 00 BD 27 02 00 02 24 C5 FF 82 10 01 00 02 24 C4 FF 82 50 8C 00 A0 AE ?? ?? ?? 0? 8C 00 A0 AE C0 FF 40 10 21 B8 40 00 04 00 F1 8E 00 00 30 8E 17 00 00 12 8C 00 B4 26 04 00 33 8E 08 00 32 8E 21 28 00 02 0C 00 31 26 21 30 60 02 05 00 C0 12 21 38 40 02 09 F8 C0 02 00 00 A4 8E 0A 00 40 54 00 00 30 8E 21 30 00 02 21 38 60 02 21 40 40 02 21 20 A0 03 ?? ?? ?? 0? 21 28 80 02 35 00 40 14 00 00 00 00 00 00 30 8E EC FF 00 56 04 00 33 8E 8C 00 B0 8E 09 00 00 1A 00 00 A4 8F 01 00 05 26 ?? ?? ?? 0? 00 29 05 00 00 19 10 00 21 18 43 00 04 00 60 AC 00 00 A2 AF 00 00 60 AC 00 00 A3 8F FF FF 02 24 84 00 A2 AE 88 00 A3 AE ?? ?? ?? 0? 21 20 E0 02 34 00 BF 8F 21 10 00 00 30 00 BE 8F 2C 00 B7 8F 28 00 B6 8F 24 00 B5 8F 20 00 B4 8F 1C 00 B3 8F 18 00 B2 8F 14 00 B1 8F 10 00 B0 8F 08 00 E0 03 38 00 BD 27 21 40 20 02 21 20 A0 03 21 30 40 02 ?? ?? ?? 0? 21 38 60 02 98 FF 40 10 FF FF 02 24 34 00 BF 8F 30 00 BE 8F 2C 00 B7 8F 28 00 B6 8F 24 00 B5 8F 20 00 B4 8F 1C 00 B3 8F 18 00 B2 8F 14 00 B1 8F 10 00 B0 8F 08 00 E0 03 38 00 BD 27 ?? ?? ?? 0? 21 20 E0 02 ?? ?? ?? 0? FF FF 02 24 34 00 BF 8F ?? ?? 42 24 21 00 03 24 88 00 A2 AE 8C 00 A3 AE 84 00 A0 AE 21 10 00 00 30 00 BE 8F 2C 00 B7 8F 28 00 B6 8F 24 00 B5 8F 20 00 B4 8F 1C 00 B3 8F 18 00 B2 8F 14 00 B1 8F 10 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_0_6_0 {
	meta:
		name = "gfx_mode_select_filter"
		size = 1660
		refs = "003c clear_keybuf 004c gui_mouse_b 0078 .data 0080 $LC7 008c get_config_text 0090 .bss 009c $LC8 00b0 $LC9 00c8 system_driver 00f0 _al_malloc 0104 $LC10 0120 ustrzcpy 0130 .text 013c $LC11 01b0 $LC12 0234 do_uconvert 0278 _al_sane_realloc 03fc .rodata 044c centre_dialog 0454 gui_bg_color 0468 set_dialog_color 0458 gui_fg_color 0478 popup_dialog 0570 _al_free 00e0 _gfx_driver_list"
	strings:
		$1 = { C0 FF BD 27 38 00 BE AF 18 00 B0 AF 3C 00 BF AF 34 00 B7 AF 30 00 B6 AF 2C 00 B5 AF 28 00 B4 AF 24 00 B3 AF 20 00 B2 AF 1C 00 B1 AF 10 00 A7 AF 04 00 A4 AF 08 00 A5 AF 0C 00 A6 AF ?? ?? ?? 0? 21 F0 00 01 10 00 A3 8F FF FF 02 24 ?? ?? 10 3C 0A 10 03 00 00 00 A2 AF ?? ?? 03 8E 09 F8 60 00 00 00 00 00 FD FF 40 14 ?? ?? 03 8E 00 00 A2 8F 9D 00 40 14 ?? ?? 02 3C ?? ?? 02 3C ?? ?? 51 24 ?? ?? 04 3C ?? ?? 03 3C ?? ?? 84 24 ?? ?? ?? 0? ?? ?? 71 AC ?? ?? 03 3C ?? ?? 70 8C ?? ?? 04 3C 9C 00 22 AE ?? ?? ?? 0? ?? ?? 84 24 A8 00 10 26 ?? ?? 04 3C ?? ?? 03 3C ?? ?? 84 24 2C 00 02 AE ?? ?? ?? 0? ?? ?? 71 8C ?? ?? 03 3C ?? ?? 64 8C E0 00 31 26 2C 00 22 AE 80 00 82 8C 57 01 40 50 ?? ?? 02 3C 09 F8 40 00 00 00 00 00 21 A0 40 00 ?? ?? ?? 0? B0 01 04 24 ?? ?? 16 3C 68 00 40 10 ?? ?? C2 AE ?? ?? 04 3C ?? ?? 84 24 00 00 40 AC ?? ?? ?? 0? 04 00 50 24 21 30 40 00 21 20 00 02 ?? ?? ?? 0? 80 00 05 24 ?? ?? C4 8E 21 28 C0 03 ?? ?? ?? 0? 90 00 13 24 ?? ?? D0 8E ?? ?? 04 3C ?? ?? 84 24 8C 00 02 8E 2A 90 02 00 18 00 53 02 01 00 02 24 12 88 00 00 21 80 11 02 ?? ?? ?? 0? 00 00 02 AE 04 00 10 26 21 20 00 02 21 30 40 00 ?? ?? ?? 0? 80 00 05 24 ?? ?? C4 8E 21 28 C0 03 ?? ?? ?? 0? 21 20 91 00 ?? ?? C4 8E 21 18 91 00 8C 00 62 8C 05 00 40 18 ?? ?? D0 8E 01 00 52 26 18 00 53 02 12 88 00 00 21 18 91 00 02 00 02 24 ?? ?? 04 3C 00 00 62 AC ?? ?? 84 24 ?? ?? ?? 0? 21 80 11 02 04 00 10 26 21 20 00 02 21 30 40 00 ?? ?? ?? 0? 80 00 05 24 ?? ?? C4 8E 21 28 C0 03 ?? ?? ?? 0? 21 20 91 00 ?? ?? C3 8E 21 18 71 00 8C 00 62 8C 01 00 40 5C 01 00 52 26 04 00 82 8E 3B 00 40 10 0C 00 91 26 ?? ?? 17 3C ?? ?? ?? 0? 90 00 15 24 18 00 55 02 04 00 82 8E 00 00 83 8E 21 A0 20 02 0C 00 44 8C 12 80 00 00 21 30 D0 00 00 00 C3 AC ?? ?? ?? 0? 04 00 C6 24 ?? ?? E4 8E 21 28 C0 03 ?? ?? ?? 0? 21 20 90 00 ?? ?? E3 8E 04 00 24 8E 0C 00 31 26 21 18 70 00 8C 00 62 8C 01 00 42 28 22 00 80 10 0A 90 62 02 01 00 53 26 18 00 75 02 ?? ?? C4 8E ?? ?? ?? 0? 12 28 00 00 53 41 05 3C 75 63 07 3C 21 30 40 00 38 43 A5 34 2E 72 E7 34 80 00 08 24 DE FF 40 14 ?? ?? C2 AE 04 00 A3 8F 4F 4E 02 3C 45 4E 42 34 00 00 62 AC 21 18 00 00 3C 00 BF 8F 21 10 60 00 38 00 BE 8F 34 00 B7 8F 30 00 B6 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 40 00 BD 27 ?? ?? ?? 0? ?? ?? 51 24 ?? ?? 13 3C D6 00 40 12 ?? ?? 72 AE 04 00 A2 8F 00 00 46 8C 01 00 C2 24 02 00 42 2C CD 00 40 14 ?? ?? C4 8E 21 18 00 00 21 28 00 00 00 00 82 8C 26 10 C2 00 0A 28 62 00 01 00 63 24 2A 10 72 00 FA FF 40 14 90 00 84 24 90 00 02 24 18 00 A2 00 12 40 00 00 ?? ?? 03 3C ?? ?? 62 8C ?? ?? C3 8E 5C 00 45 AC 3C 01 45 AC 08 00 A2 8F 21 18 68 00 00 00 46 8C 01 00 C2 24 02 00 42 2C 9A 00 40 14 88 00 64 8C 0C 00 A2 8F 00 00 47 8C 01 00 E2 24 02 00 42 2C 95 00 40 54 ?? ?? 03 3C 8C 00 63 8C 91 00 60 18 21 28 00 00 ?? ?? ?? 0? 00 00 82 8C 2A 10 A3 00 8C 00 40 10 10 00 84 24 00 00 82 8C FB FF C2 54 01 00 A5 24 04 00 82 8C F8 FF E2 54 01 00 A5 24 ?? ?? 03 3C ?? ?? 64 8C 00 00 A2 8F 21 80 60 00 74 01 85 AC 87 00 40 10 60 00 85 AC 10 00 A3 8F 00 00 67 8C 01 00 E2 24 02 00 42 2C 13 00 40 14 ?? ?? C2 8E 00 29 05 00 ?? ?? 03 3C 21 10 48 00 88 00 44 8C ?? ?? 02 3C ?? ?? 63 24 21 20 85 00 ?? ?? 46 24 FF FF 05 24 08 00 82 80 04 00 40 10 01 00 84 24 00 00 62 8C 05 00 E2 10 01 00 A5 24 04 00 63 24 F9 FF 66 54 08 00 82 80 21 28 00 00 ?? ?? 02 3C ?? ?? 44 8C ?? ?? ?? 0? AC 01 85 AC ?? ?? 03 3C ?? ?? 02 3C ?? ?? 66 8C ?? ?? 03 3C ?? ?? 64 8C ?? ?? ?? 0? ?? ?? 45 8C ?? ?? 02 3C ?? ?? 44 8C ?? ?? ?? 0? 05 00 05 24 ?? ?? 03 3C 21 90 40 00 ?? ?? 62 8C AC 01 48 8C 3C 01 44 8C 74 01 45 8C 04 00 02 24 24 00 42 12 90 00 03 24 18 00 83 00 ?? ?? C2 8E 00 29 05 00 12 18 00 00 21 10 43 00 00 00 43 8C 88 00 44 8C 04 00 A2 8F 21 20 85 00 00 00 43 AC 00 00 82 8C 08 00 A3 8F 00 00 62 AC 04 00 83 8C 0C 00 A2 8F 00 00 43 AC 00 00 A3 8F 12 00 60 10 ?? ?? 62 8E 21 30 00 00 FF FF 07 24 05 00 05 24 21 10 86 00 08 00 43 80 05 00 60 50 01 00 C6 24 01 00 E7 24 55 00 07 11 ?? ?? 02 3C 01 00 C6 24 F8 FF C5 14 21 10 86 00 FF FF 03 24 10 00 A2 8F 00 00 43 AC ?? ?? 62 8E 14 00 40 18 21 80 00 00 ?? ?? ?? 0? 90 00 11 24 ?? ?? 62 8E 2A 10 02 02 0E 00 40 10 00 00 00 00 18 00 11 02 ?? ?? C3 8E 12 20 00 00 21 18 64 00 84 00 62 8C F6 FF 40 10 01 00 10 26 ?? ?? ?? 0? 88 00 64 8C ?? ?? 62 8E 2A 10 02 02 F5 FF 40 14 18 00 11 02 ?? ?? ?? 0? ?? ?? C4 8E 3C 00 BF 8F 04 00 42 3A FF FF 03 24 0A 18 02 00 ?? ?? C0 AE ?? ?? 60 AE 21 10 60 00 38 00 BE 8F 34 00 B7 8F 30 00 B6 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 40 00 BD 27 ?? ?? 03 3C ?? ?? 64 8C 00 00 A2 8F 21 28 00 00 21 80 60 00 74 01 85 AC 7B FF 40 14 60 00 85 AC ?? ?? ?? 0? 00 00 00 00 ?? ?? 02 3C ?? ?? 03 3C ?? ?? 45 8C ?? ?? 66 8C ?? ?? ?? 0? ?? ?? 04 8E ?? ?? 04 8E ?? ?? ?? 0? 05 00 05 24 21 90 40 00 ?? ?? 02 8E 21 40 00 00 74 01 45 8C ?? ?? ?? 0? 3C 01 44 8C ?? ?? ?? 0? ?? ?? 54 24 21 28 00 00 ?? ?? ?? 0? 21 40 00 00 04 00 A3 8F 4F 4E 02 3C 45 4E 42 34 00 00 62 AC ?? ?? ?? 0? FF FF 03 24 80 18 06 00 ?? ?? 42 24 21 18 62 00 ?? ?? ?? 0? 00 00 63 8C }
	condition:
		$1
}

rule file_1_0_0 {
	meta:
		name = "save_bmp_pf"
		size = 1052
		refs = "0078 allegro_errno 00a8 pack_iputw 00b4 pack_iputl 0180 .text 01a0 getb_depth 01ac pack_putc 01b8 getg_depth 01d0 getr_depth 0394 _rgb_scale_6 0408 get_palette"
	strings:
		$1 = { 1C 00 A2 8C D0 FB BD 27 1C 04 B5 AF 00 00 55 8C 00 00 A7 8C FF FF 02 24 14 04 B3 AF FD FF 03 24 21 98 A0 00 08 00 A5 3A 0A 18 45 00 18 00 67 00 24 04 B7 AF 08 00 02 24 18 00 17 24 20 04 B6 AF 10 04 B2 AF 0C 04 B1 AF 2C 04 BF AF 28 04 BE AF 18 04 B4 AF 08 04 B0 AF 21 88 C0 00 0A B8 45 00 21 90 80 00 12 18 00 00 E7 00 C0 10 03 00 76 30 08 00 02 24 8C 00 E2 12 ?? ?? 02 3C 03 00 10 24 18 00 F0 00 04 00 63 8E 00 04 A2 AF ?? ?? 42 8C 21 28 40 02 42 4D 04 24 00 00 40 AC 12 80 00 00 21 80 16 02 18 00 03 02 ?? ?? ?? 0? 12 80 00 00 21 28 40 02 ?? ?? ?? 0? 36 00 04 26 21 28 40 02 ?? ?? ?? 0? 21 20 00 00 21 28 40 02 ?? ?? ?? 0? 21 20 00 00 21 28 40 02 ?? ?? ?? 0? 36 00 04 24 21 28 40 02 ?? ?? ?? 0? 28 00 04 24 00 00 64 8E ?? ?? ?? 0? 21 28 40 02 04 00 64 8E ?? ?? ?? 0? 21 28 40 02 21 28 40 02 ?? ?? ?? 0? 01 00 04 24 21 20 E0 02 ?? ?? ?? 0? 21 28 40 02 21 28 40 02 ?? ?? ?? 0? 21 20 00 00 21 20 00 02 ?? ?? ?? 0? 21 28 40 02 21 28 40 02 ?? ?? ?? 0? 12 0B 04 24 21 28 40 02 ?? ?? ?? 0? 12 0B 04 24 21 28 40 02 ?? ?? ?? 0? 21 20 00 00 21 20 00 00 ?? ?? ?? 0? 21 28 40 02 04 00 62 8E FF FF 54 24 3D 00 80 06 08 00 1E 24 00 00 62 8E 2D 00 40 18 00 00 00 00 ?? ?? ?? 0? 21 88 00 00 1C 00 62 8E 20 00 43 8C 09 F8 60 00 01 00 31 26 21 28 40 00 21 20 A0 02 ?? ?? ?? 0? 21 80 40 00 21 20 40 00 ?? ?? ?? 0? 21 28 40 02 21 20 A0 02 ?? ?? ?? 0? 21 28 00 02 21 20 40 00 ?? ?? ?? 0? 21 28 40 02 21 20 A0 02 ?? ?? ?? 0? 21 28 00 02 21 20 40 00 ?? ?? ?? 0? 21 28 40 02 00 00 62 8E 2A 10 22 02 10 00 40 10 00 00 00 00 21 30 80 02 21 28 20 02 E2 FF FE 16 21 20 60 02 1C 00 62 8E 20 00 43 8C 09 F8 60 00 01 00 31 26 21 20 40 00 ?? ?? ?? 0? 21 28 40 02 00 00 62 8E 2A 10 22 02 F3 FF 40 14 21 30 80 02 0A 00 C0 52 FF FF 94 26 21 80 00 00 01 00 10 26 21 20 00 00 ?? ?? ?? 0? 21 28 40 02 2A 18 16 02 FB FF 60 54 01 00 10 26 FF FF 94 26 C6 FF 83 06 00 00 62 8E 00 04 A3 8F 2C 04 BF 8F 28 04 BE 8F ?? ?? 62 8C 24 04 B7 8F 20 04 B6 8F 00 00 43 8C FF FF 02 24 1C 04 B5 8F 0A 10 03 00 18 04 B4 8F 14 04 B3 8F 10 04 B2 8F 0C 04 B1 8F 08 04 B0 8F 08 00 E0 03 30 04 BD 27 04 00 62 8E 21 80 F6 00 ?? ?? 03 3C 18 00 02 02 00 04 A3 AF ?? ?? 63 8C 42 4D 04 24 21 28 40 02 00 00 60 AC 02 00 31 26 21 A0 00 00 00 01 1E 24 ?? ?? ?? 0? 12 80 00 00 36 04 04 26 ?? ?? ?? 0? 21 28 40 02 21 20 00 00 ?? ?? ?? 0? 21 28 40 02 21 20 00 00 ?? ?? ?? 0? 21 28 40 02 36 04 04 24 ?? ?? ?? 0? 21 28 40 02 28 00 04 24 ?? ?? ?? 0? 21 28 40 02 00 00 64 8E ?? ?? ?? 0? 21 28 40 02 04 00 64 8E ?? ?? ?? 0? 21 28 40 02 01 00 04 24 ?? ?? ?? 0? 21 28 40 02 08 00 04 24 ?? ?? ?? 0? 21 28 40 02 21 20 00 00 ?? ?? ?? 0? 21 28 40 02 21 20 00 02 ?? ?? ?? 0? 21 28 40 02 12 0B 04 24 ?? ?? ?? 0? 21 28 40 02 12 0B 04 24 ?? ?? ?? 0? 21 28 40 02 00 01 04 24 ?? ?? ?? 0? 21 28 40 02 00 01 04 24 ?? ?? ?? 0? 21 28 40 02 ?? ?? 03 3C ?? ?? 70 24 00 00 22 92 21 28 40 02 01 00 94 26 80 10 02 00 21 10 02 02 ?? ?? ?? 0? 00 00 44 8C FF FF 23 92 21 28 40 02 80 18 03 00 21 18 03 02 ?? ?? ?? 0? 00 00 64 8C FE FF 23 92 21 28 40 02 04 00 31 26 80 18 03 00 21 18 03 02 ?? ?? ?? 0? 00 00 64 8C 21 20 00 00 ?? ?? ?? 0? 21 28 40 02 E9 FF 9E 56 00 00 22 92 ?? ?? ?? 0? 04 00 62 8E ?? ?? ?? 0? 21 20 A0 03 21 88 A0 03 ?? ?? ?? 0? 00 00 67 8E }
	condition:
		$1
}

rule file_1_1_0 {
	meta:
		name = "save_bmp"
		size = 136
		refs = "000c $LC0 0020 pack_fopen 0038 save_bmp_pf 0044 pack_fclose"
	strings:
		$1 = { F0 FF BD 27 08 00 B2 AF 21 90 A0 00 ?? ?? 05 3C ?? ?? A5 24 04 00 B1 AF 00 00 B0 AF 0C 00 BF AF ?? ?? ?? 0? 21 88 C0 00 0F 00 40 10 21 80 40 00 21 28 40 02 21 30 20 02 ?? ?? ?? 0? 21 20 40 00 21 20 00 02 ?? ?? ?? 0? 21 88 40 00 0C 00 BF 8F 21 10 20 02 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 10 00 BD 27 0C 00 BF 8F FF FF 11 24 21 10 20 02 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 10 00 BD 27 }
	condition:
		$1
}

rule file_4_1_0 {
	meta:
		name = "save_pcx"
		size = 136
		refs = "000c $LC0 0020 pack_fopen 0038 save_pcx_pf 0044 pack_fclose"
	strings:
		$1 = { F0 FF BD 27 08 00 B2 AF 21 90 A0 00 ?? ?? 05 3C ?? ?? A5 24 04 00 B1 AF 00 00 B0 AF 0C 00 BF AF ?? ?? ?? 0? 21 88 C0 00 0F 00 40 10 21 80 40 00 21 28 40 02 21 30 20 02 ?? ?? ?? 0? 21 20 40 00 21 20 00 02 ?? ?? ?? 0? 21 88 40 00 0C 00 BF 8F 21 10 20 02 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 10 00 BD 27 0C 00 BF 8F FF FF 11 24 21 10 20 02 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 10 00 BD 27 }
	condition:
		$1
}

rule file_23_1_0 {
	meta:
		name = "save_tga"
		size = 136
		refs = "000c $LC0 0020 pack_fopen 0038 save_tga_pf 0044 pack_fclose"
	strings:
		$1 = { F0 FF BD 27 08 00 B2 AF 21 90 A0 00 ?? ?? 05 3C ?? ?? A5 24 04 00 B1 AF 00 00 B0 AF 0C 00 BF AF ?? ?? ?? 0? 21 88 C0 00 0F 00 40 10 21 80 40 00 21 28 40 02 21 30 20 02 ?? ?? ?? 0? 21 20 40 00 21 20 00 02 ?? ?? ?? 0? 21 88 40 00 0C 00 BF 8F 21 10 20 02 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 10 00 BD 27 0C 00 BF 8F FF FF 11 24 21 10 20 02 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 10 00 BD 27 }
	condition:
		$1
}

rule file_1_2_0 {
	meta:
		name = "read_bmicolors"
		size = 336
		refs = "004c .text 006c pack_getc"
	strings:
		$1 = { D8 FF BD 27 03 00 82 28 1C 00 B6 AF 18 00 B5 AF 14 00 B4 AF 24 00 BF AF 20 00 B7 AF 10 00 B3 AF 0C 00 B2 AF 08 00 B1 AF 04 00 B0 AF 21 A8 80 00 21 A0 C0 00 44 00 40 14 21 B0 E0 00 02 00 B1 24 21 80 00 00 21 98 00 00 04 00 12 24 ?? ?? ?? 0? 00 01 17 24 02 00 02 26 2A 10 55 00 27 00 40 10 2A 10 15 02 25 00 77 12 2A 10 15 02 ?? ?? ?? 0? 21 20 80 02 02 00 40 16 1A 00 52 00 CD 01 00 00 21 20 80 02 03 00 10 26 01 00 73 26 12 10 00 00 ?? ?? ?? 0? 00 00 22 A2 02 00 40 16 1A 00 52 00 CD 01 00 00 21 20 80 02 12 10 00 00 ?? ?? ?? 0? FF FF 22 A2 02 00 40 16 1A 00 52 00 CD 01 00 00 2A 18 15 02 12 10 00 00 FE FF 22 A2 E1 FF C0 12 04 00 31 26 E0 FF 60 10 02 00 02 26 21 20 80 02 ?? ?? ?? 0? 01 00 10 26 02 00 02 26 2A 10 55 00 DC FF 40 14 00 00 00 00 2A 10 15 02 08 00 40 10 24 00 BF 8F 01 00 10 26 ?? ?? ?? 0? 21 20 80 02 2A 18 15 02 FC FF 60 14 01 00 10 26 24 00 BF 8F 20 00 B7 8F 1C 00 B6 8F 18 00 B5 8F 14 00 B4 8F 10 00 B3 8F 0C 00 B2 8F 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 28 00 BD 27 ?? ?? ?? 0? 21 80 00 00 }
	condition:
		$1
}

rule file_1_3_0 {
	meta:
		name = "load_bmp_pf"
		size = 3504
		refs = "0040 pack_igetw 004c pack_igetl 011c .text 01ac _color_load_depth 01d4 create_bitmap_ex 01e4 clear_bitmap 0244 .rodata 0344 _rgb_scale_5 0378 _rgb_r_shift_16 0388 _rgb_g_shift_16 0390 _rgb_b_shift_16 0404 pack_getc 0468 _fixup_loaded_bitmap 0498 generate_332_palette 05b0 _rgb_g_shift_32 05b4 _rgb_r_shift_32 05c0 _rgb_b_shift_32 05c8 _rgb_a_shift_32 06ec _rgb_g_shift_24 06f0 _rgb_r_shift_24 06fc _rgb_b_shift_24 0840 pack_mgetl 089c destroy_bitmap 0acc memcpy 0ae8 pack_fread 0b00 _rgb_r_shift_15 0b04 _rgb_g_shift_15 0b0c _rgb_b_shift_15"
	strings:
		$1 = { 60 FB BD 27 88 04 B4 AF 9C 04 BF AF 98 04 BE AF 94 04 B7 AF 90 04 B6 AF 8C 04 B5 AF 84 04 B3 AF 80 04 B2 AF 7C 04 B1 AF 78 04 B0 AF 60 04 A5 AF 93 00 A0 10 21 A0 80 00 FF FF 03 24 5C 04 A3 AF ?? ?? ?? 0? 21 20 80 02 21 20 80 02 ?? ?? ?? 0? 21 80 40 00 ?? ?? ?? 0? 21 20 80 02 ?? ?? ?? 0? 21 20 80 02 ?? ?? ?? 0? 21 20 80 02 21 A8 40 00 42 4D 02 24 0E 00 02 12 21 B8 00 00 9C 04 BF 8F 21 10 E0 02 98 04 BE 8F 94 04 B7 8F 90 04 B6 8F 8C 04 B5 8F 88 04 B4 8F 84 04 B3 8F 80 04 B2 8F 7C 04 B1 8F 78 04 B0 8F 08 00 E0 03 A0 04 BD 27 ?? ?? ?? 0? 21 20 80 02 21 18 40 00 28 00 02 24 73 00 62 10 0C 00 02 24 EC FF 62 14 21 B8 00 00 ?? ?? ?? 0? 21 20 80 02 21 20 80 02 ?? ?? ?? 0? 21 88 40 00 21 20 80 02 ?? ?? ?? 0? 21 80 40 00 ?? ?? ?? 0? 21 20 80 02 60 04 A5 8F FF FF 31 32 FF FF 10 32 E6 FF A4 26 21 30 80 02 21 38 00 00 10 00 B1 AF 14 00 B0 AF 18 00 A2 A7 ?? ?? ?? 0? 1C 00 A0 AF 18 00 B2 97 18 00 02 24 08 00 42 52 58 04 A2 AF 10 00 02 24 7A 00 42 12 08 00 04 24 20 00 43 3A 20 00 02 24 0A 20 43 00 58 04 A4 AF 1C 00 B1 8F 03 00 02 24 14 00 22 56 58 04 A4 8F ?? ?? ?? 0? 21 20 80 02 21 20 80 02 ?? ?? ?? 0? 21 80 40 00 ?? ?? ?? 0? 21 20 80 02 21 18 40 00 1F 00 02 24 B9 01 62 10 FF 00 02 24 BB FF 62 14 21 B8 00 00 FF 00 02 3C B9 FF 02 16 9C 04 BF 8F 20 00 07 24 58 04 A7 AF 58 04 A4 8F ?? ?? ?? 0? 21 28 00 00 14 00 B0 8F 10 00 BE 8F 54 04 A2 AF 58 04 A4 8F 23 10 10 00 2C 10 02 02 21 28 C0 03 21 30 40 00 ?? ?? ?? 0? 44 04 A2 AF A7 FF 40 10 21 B8 40 00 ?? ?? ?? 0? 21 20 40 00 01 00 02 24 B1 01 22 12 FF FF 16 26 A4 01 20 16 02 00 02 24 E7 02 00 06 01 00 07 24 FF FF 02 26 FF FF 07 24 44 04 A3 8F 88 00 60 10 03 00 03 24 18 00 C3 03 80 20 12 00 80 38 07 00 21 00 52 2E 48 04 A7 AF 50 04 A0 AF 64 04 B2 AF 12 18 00 00 6C 04 A3 AF 10 00 43 24 ?? ?? 02 3C ?? ?? 42 24 21 10 44 00 80 18 03 00 04 00 A4 27 68 04 A2 AF 21 A8 E3 02 70 04 A4 AF 64 04 A5 8F 6C 00 A0 10 50 04 A7 8F 68 04 A6 8F 00 00 C2 8C 08 00 40 00 00 00 00 00 40 00 A2 27 60 04 A2 AF ?? ?? ?? 0? 5C 04 A0 AF ?? ?? ?? 0? 21 20 80 02 21 20 80 02 ?? ?? ?? 0? 21 98 40 00 21 20 80 02 ?? ?? ?? 0? 21 90 40 00 ?? ?? ?? 0? 21 20 80 02 21 20 80 02 ?? ?? ?? 0? 21 88 40 00 21 20 80 02 ?? ?? ?? 0? 21 80 40 00 ?? ?? ?? 0? 21 20 80 02 ?? ?? ?? 0? 21 20 80 02 ?? ?? ?? 0? 21 20 80 02 ?? ?? ?? 0? 21 20 80 02 03 00 02 24 10 00 B3 AF 14 00 B2 AF 18 00 B1 A7 88 FF 02 12 1C 00 B0 AF 60 04 A5 8F CA FF A4 26 21 30 80 02 ?? ?? ?? 0? 01 00 07 24 ?? ?? ?? 0? 18 00 B2 97 ?? ?? ?? 0? 58 04 A2 AF 3B 00 C0 1B 50 04 A7 8F 21 80 00 00 ?? ?? ?? 0? 21 20 80 02 40 21 44 7C ?? ?? 05 3C ?? ?? A5 24 80 22 43 7C 80 20 04 00 1F 00 42 30 ?? ?? 07 3C 21 20 A4 00 ?? ?? E7 24 80 18 03 00 80 10 02 00 21 10 E2 00 21 18 A3 00 00 00 86 8C ?? ?? 04 3C 00 00 65 8C 00 00 43 8C ?? ?? 82 8C ?? ?? 04 3C ?? ?? 87 8C ?? ?? 04 3C ?? ?? 88 8C C3 28 05 00 83 30 06 00 00 00 A4 8E 04 28 45 00 04 30 E6 00 C3 18 03 00 40 10 10 00 25 28 A6 00 04 18 03 01 01 00 10 26 21 20 82 00 25 28 A3 00 2A 10 1E 02 DA FF 40 14 00 00 85 A4 40 18 1E 00 04 00 02 24 02 00 40 14 1A 00 62 00 CD 01 00 00 10 18 00 00 0A 00 60 10 04 00 62 28 09 00 40 10 50 04 A7 8F 21 80 60 00 01 00 10 26 ?? ?? ?? 0? 21 20 80 02 04 00 03 2A FC FF 60 54 01 00 10 26 50 04 A7 8F 44 04 A3 8F 48 04 A4 8F 01 00 E7 24 2A 10 E3 00 50 04 A7 AF 8C FF 40 14 21 A8 A4 02 58 04 A5 8F 54 04 A6 8F 0C 00 A6 10 08 00 02 24 04 00 A2 10 60 04 A7 8F 5C 04 A2 8F 0A 38 02 00 60 04 A7 AF 05 00 E0 12 60 04 A5 8F 54 04 A6 8F ?? ?? ?? 0? 21 20 E0 02 21 B8 40 00 58 04 A3 8F 08 00 02 24 00 FF 62 10 9C 04 BF 8F 54 04 A4 8F FD FE 82 10 5C 04 A5 8F FC FE A0 10 21 10 E0 02 ?? ?? ?? 0? 60 04 A4 8F ?? ?? ?? 0? 9C 04 BF 8F DB FF C0 1B 21 90 A0 03 ?? ?? ?? 0? 21 80 00 00 21 10 B1 03 00 00 44 90 21 18 70 00 01 00 10 26 2A 10 1E 02 D2 FF 40 10 00 00 64 A0 03 00 11 32 F7 FF 20 56 00 00 A3 8E ?? ?? ?? 0? 21 20 80 02 21 18 40 02 00 00 62 A0 70 04 A7 8F 01 00 63 24 FC FF E3 14 02 12 02 00 ?? ?? ?? 0? 00 00 A3 8E C3 FF C0 1B 09 00 B3 27 21 80 00 00 ?? ?? ?? 0? 11 00 B2 27 21 10 B1 03 08 00 44 90 21 18 70 00 01 00 10 26 2A 10 1E 02 B9 FF 40 10 00 00 64 A0 07 00 11 32 F7 FF 20 56 00 00 A3 8E ?? ?? ?? 0? 21 20 80 02 21 28 40 00 21 20 60 02 0F 00 A2 30 00 19 A3 7C 00 00 82 A0 FF FF 83 A0 02 00 84 24 FA FF 44 16 02 2A 05 00 ?? ?? ?? 0? 00 00 A3 8E A7 FF C0 1B 21 B0 00 00 01 00 13 24 ?? ?? ?? 0? 21 20 80 02 21 20 80 02 ?? ?? ?? 0? 21 90 40 00 21 20 80 02 ?? ?? ?? 0? 21 80 40 00 21 20 80 02 ?? ?? ?? 0? 21 88 40 00 ?? ?? 05 3C ?? ?? 06 3C ?? ?? A4 8C ?? ?? C3 8C ?? ?? 07 3C ?? ?? E6 8C ?? ?? 05 3C ?? ?? A7 8C FF 00 31 32 FF 00 10 32 00 00 A5 8E FF 00 52 32 04 18 71 00 04 20 90 00 20 14 02 7C 04 30 D2 00 25 20 83 00 04 38 E2 00 80 18 16 00 25 20 86 00 21 28 A3 00 25 20 87 00 00 00 A4 A0 ?? ?? 06 3C ?? ?? 07 3C ?? ?? C3 8C ?? ?? E4 8C ?? ?? 06 3C ?? ?? C5 8C ?? ?? 07 3C ?? ?? E6 8C 04 20 91 00 04 18 70 00 04 28 B2 00 25 18 64 00 00 00 A4 8E 04 30 C2 00 25 18 65 00 25 18 66 00 21 20 93 00 03 1A 03 00 00 00 83 A0 ?? ?? 03 3C ?? ?? 04 3C ?? ?? 65 8C ?? ?? 06 3C ?? ?? 83 8C ?? ?? C4 8C ?? ?? E6 8C 04 88 71 00 04 80 B0 00 00 00 A3 8E 25 80 11 02 04 90 92 00 04 10 C2 00 25 80 12 02 25 80 02 02 01 00 D6 26 21 18 73 00 03 84 10 00 2A 10 DE 02 01 00 70 A0 B6 FF 40 14 04 00 73 26 ?? ?? ?? 0? 50 04 A7 8F 57 FF C0 1B 21 98 00 00 01 00 12 24 ?? ?? ?? 0? 21 20 80 02 21 20 80 02 ?? ?? ?? 0? 21 88 40 00 21 20 80 02 ?? ?? ?? 0? 21 80 40 00 03 00 03 24 18 00 63 02 ?? ?? 05 3C ?? ?? 06 3C ?? ?? A4 8C ?? ?? C3 8C ?? ?? 06 3C ?? ?? C5 8C FF 00 42 30 00 00 A6 8E FF 00 10 32 FF 00 31 32 04 18 62 00 04 20 90 00 04 28 B1 00 25 20 83 00 25 20 85 00 ?? ?? 05 3C 01 00 73 26 12 38 00 00 2A 40 7E 02 21 30 C7 00 00 00 C4 A0 ?? ?? 07 3C ?? ?? E3 8C ?? ?? A4 8C ?? ?? 06 3C ?? ?? C5 8C 04 20 82 00 00 00 A6 8E 04 18 70 00 04 28 B1 00 25 18 64 00 25 18 65 00 21 30 D2 00 03 1A 03 00 00 00 C3 A0 ?? ?? E4 8C ?? ?? 07 3C ?? ?? E5 8C ?? ?? 03 3C ?? ?? 66 8C 04 80 90 00 00 00 A3 8E 04 10 A2 00 25 80 02 02 04 88 D1 00 25 80 11 02 21 18 72 00 03 84 10 00 01 00 70 A0 C4 FF 00 15 03 00 52 26 6C 04 A4 8F 04 00 02 24 02 00 40 14 1A 00 82 00 CD 01 00 00 10 18 00 00 11 FF 60 10 04 00 62 28 10 FF 40 10 50 04 A7 8F 21 80 60 00 01 00 10 26 ?? ?? ?? 0? 21 20 80 02 04 00 03 2A FC FF 60 54 01 00 10 26 ?? ?? ?? 0? 50 04 A7 8F 04 FF C0 1B 3F 00 B3 27 21 80 00 00 ?? ?? ?? 0? 1F 00 B1 27 21 10 B2 03 20 00 44 90 21 18 70 00 01 00 10 26 2A 10 1E 02 FA FE 40 10 00 00 64 A0 1F 00 12 32 F7 FF 40 56 00 00 A3 8E ?? ?? ?? 0? 21 20 80 02 21 20 40 00 21 18 60 02 01 00 82 30 00 00 62 A0 FF FF 63 24 FC FF 23 16 42 20 04 00 ?? ?? ?? 0? 00 00 A3 8E 00 7C 02 24 0E 00 02 12 00 F8 02 34 00 FE 02 16 21 B8 00 00 10 00 06 24 ?? ?? ?? 0? 58 04 A6 AF D1 00 22 12 03 00 02 24 61 00 22 12 00 00 00 00 ?? ?? ?? 0? 21 20 E0 02 ?? ?? ?? 0? 21 B8 00 00 0F 00 05 24 ?? ?? ?? 0? 58 04 A5 AF 21 98 00 00 ?? ?? ?? 0? 21 20 80 02 21 20 80 02 ?? ?? ?? 0? FF 00 51 30 19 00 20 12 FF 00 50 30 10 00 C2 26 80 10 02 00 21 28 E2 02 21 18 60 02 21 20 33 02 00 00 A2 8C 21 10 43 00 01 00 63 24 FC FF 64 14 00 00 50 A0 21 98 71 02 21 18 00 00 21 20 00 00 FF FF 62 26 2A 10 C2 03 10 00 40 10 00 00 00 00 FF FF D6 26 C6 FE C0 06 58 04 A5 8F E4 FF 60 50 21 98 00 00 ?? ?? ?? 0? 54 04 A6 8F 01 00 05 24 35 00 05 12 01 00 03 24 0A 00 00 16 02 00 06 24 21 18 00 00 ?? ?? ?? 0? 01 00 04 24 F1 FF 80 54 FF FF D6 26 D6 FF 60 10 01 00 03 24 ?? ?? ?? 0? FF FF D6 26 1C 00 06 12 00 00 00 00 12 00 00 12 10 00 C2 26 80 10 02 00 21 A8 E2 02 21 90 60 02 21 88 00 00 ?? ?? ?? 0? 21 20 80 02 00 00 A3 8E 01 00 31 26 2A 20 30 02 21 18 72 00 00 00 62 A0 F8 FF 80 14 01 00 52 26 01 00 02 32 01 00 07 24 04 00 47 10 21 98 70 02 21 18 00 00 ?? ?? ?? 0? 21 20 00 00 ?? ?? ?? 0? 21 20 80 02 21 18 00 00 ?? ?? ?? 0? 21 20 00 00 ?? ?? ?? 0? 21 20 80 02 21 20 80 02 ?? ?? ?? 0? 21 80 40 00 FF 00 42 30 FF 00 10 32 21 98 70 02 23 B0 C2 02 21 18 00 00 ?? ?? ?? 0? 21 20 00 00 ?? ?? ?? 0? 21 20 00 00 E2 00 00 06 01 00 05 24 FF FF 04 26 FF FF 05 24 1C 00 E2 8E 00 00 53 8C 09 00 63 2A D2 00 60 10 11 00 62 2A 01 00 12 24 44 04 A6 8F 7B FE C0 10 10 00 82 24 80 10 02 00 80 28 05 00 40 04 A5 AF 21 A8 E2 02 4C 04 A0 AF 04 00 B6 27 50 00 C0 1B 21 88 00 00 ?? ?? ?? 0? 21 80 00 00 31 00 63 12 04 00 A3 8F ?? ?? 04 3C ?? ?? 07 3C ?? ?? 85 8C ?? ?? E6 8C ?? ?? 02 3C ?? ?? 47 8C 00 3A 64 7C 00 3C 62 7C 04 10 A2 00 04 20 C4 00 FF 00 63 30 25 10 44 00 04 18 E3 00 25 10 43 00 04 00 A2 AF 00 00 A4 8E 01 00 31 26 21 28 C0 02 21 20 90 00 ?? ?? ?? 0? 21 30 40 02 2A 18 3E 02 22 00 60 10 21 80 12 02 21 20 C0 02 21 28 40 02 ?? ?? ?? 0? 21 30 80 02 0F 00 07 24 E0 FF 67 16 10 00 03 24 04 00 A3 8F ?? ?? 02 3C ?? ?? 04 3C ?? ?? 45 8C ?? ?? 02 3C ?? ?? 86 8C ?? ?? 47 8C 40 21 64 7C 80 22 62 7C 04 10 A2 00 04 20 C4 00 1F 00 63 30 25 10 44 00 04 18 E3 00 25 10 43 00 ?? ?? ?? 0? 04 00 A2 AF ?? ?? 04 3C ?? ?? 07 3C ?? ?? 02 3C ?? ?? 85 8C ?? ?? E6 8C 40 29 64 7C ?? ?? 47 8C ?? ?? ?? 0? C0 22 62 7C 18 00 D2 03 04 00 02 24 12 18 00 00 02 00 40 14 1A 00 62 00 CD 01 00 00 10 18 00 00 0A 00 60 18 04 00 62 28 09 00 40 10 4C 04 A2 8F 21 80 60 00 01 00 10 26 ?? ?? ?? 0? 21 20 80 02 04 00 03 2A FC FF 60 54 01 00 10 26 4C 04 A2 8F 44 04 A3 8F 40 04 A4 8F 01 00 42 24 4C 04 A2 AF 2A 10 43 00 A8 FF 40 14 21 A8 A4 02 ?? ?? ?? 0? 58 04 A5 8F FF FF 16 26 21 98 00 00 ?? ?? ?? 0? 21 20 80 02 21 20 80 02 ?? ?? ?? 0? FF 00 50 30 22 00 00 12 FF FF 51 30 10 00 C4 26 00 19 22 7E 80 20 04 00 0F 00 23 32 09 00 A3 A3 08 00 A2 A3 21 40 E4 02 21 38 60 02 21 30 00 00 01 00 C2 30 21 20 A2 03 00 00 03 8D 08 00 85 90 01 00 C6 24 21 18 67 00 2A 10 D0 00 00 00 65 A0 F7 FF 40 14 01 00 E7 24 21 98 70 02 21 18 00 00 21 20 00 00 FF FF 62 26 2A 10 C2 03 10 00 40 10 00 00 00 00 FF FF D6 26 F5 FD C0 06 58 04 A5 8F DB FF 60 50 21 98 00 00 ?? ?? ?? 0? 54 04 A6 8F 01 00 02 24 3E 00 22 12 01 00 03 24 0A 00 20 56 02 00 03 24 21 18 00 00 ?? ?? ?? 0? 01 00 04 24 F1 FF 80 54 FF FF D6 26 CD FF 60 10 01 00 03 24 ?? ?? ?? 0? FF FF D6 26 25 00 23 12 00 00 00 00 20 00 20 12 21 80 00 00 10 00 C4 26 80 10 04 00 ?? ?? ?? 0? 21 A8 E2 02 00 00 A3 8E 21 10 B2 03 08 00 44 90 21 18 73 00 21 18 70 00 01 00 10 26 2A 10 11 02 12 00 40 10 00 00 64 A0 03 00 12 32 F6 FF 40 56 00 00 A3 8E ?? ?? ?? 0? 21 20 80 02 FF FF 42 30 02 19 02 00 02 21 03 00 02 29 04 00 0F 00 42 30 0F 00 63 30 0F 00 84 30 09 00 A2 A3 08 00 A3 A3 0B 00 A4 A3 ?? ?? ?? 0? 0A 00 A5 A3 21 98 71 02 21 18 00 00 ?? ?? ?? 0? 21 20 00 00 ?? ?? ?? 0? 21 20 80 02 21 20 80 02 ?? ?? ?? 0? 21 80 40 00 FF FF 42 30 FF 00 10 32 21 98 70 02 23 B0 C2 02 21 18 00 00 ?? ?? ?? 0? 21 20 00 00 ?? ?? ?? 0? 21 20 00 00 2F FF 40 54 02 00 12 24 19 00 63 2A 04 00 12 24 03 00 02 24 ?? ?? ?? 0? 0B 90 43 00 ?? ?? ?? 0? 21 10 00 00 ?? ?? ?? 0? 21 20 00 00 }
	condition:
		$1
}

rule file_1_4_0 {
	meta:
		name = "load_bmp"
		size = 116
		refs = "0018 pack_fopen 000c $LC1 002c load_bmp_pf 0038 pack_fclose"
	strings:
		$1 = { F0 FF BD 27 08 00 B1 AF 21 88 A0 00 ?? ?? 05 3C 04 00 B0 AF 0C 00 BF AF ?? ?? ?? 0? ?? ?? A5 24 0D 00 40 10 21 80 40 00 21 28 20 02 ?? ?? ?? 0? 21 20 40 00 21 20 00 02 ?? ?? ?? 0? 21 88 40 00 0C 00 BF 8F 21 10 20 02 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 10 00 BD 27 0C 00 BF 8F 21 88 00 00 21 10 20 02 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 10 00 BD 27 }
	condition:
		$1
}

rule file_4_3_0 {
	meta:
		name = "load_pcx"
		size = 116
		refs = "0018 pack_fopen 000c $LC1 002c load_pcx_pf 0038 pack_fclose"
	strings:
		$1 = { F0 FF BD 27 08 00 B1 AF 21 88 A0 00 ?? ?? 05 3C 04 00 B0 AF 0C 00 BF AF ?? ?? ?? 0? ?? ?? A5 24 0D 00 40 10 21 80 40 00 21 28 20 02 ?? ?? ?? 0? 21 20 40 00 21 20 00 02 ?? ?? ?? 0? 21 88 40 00 0C 00 BF 8F 21 10 20 02 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 10 00 BD 27 0C 00 BF 8F 21 88 00 00 21 10 20 02 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 10 00 BD 27 }
	condition:
		$1
}

rule file_2_6_26 {
	meta:
		name = "load_png"
		size = 116
		refs = "0018 pack_fopen 000c $LC7 002c load_png_pf 0038 pack_fclose"
	strings:
		$1 = { F0 FF BD 27 08 00 B1 AF 21 88 A0 00 ?? ?? 05 3C 04 00 B0 AF 0C 00 BF AF ?? ?? ?? 0? ?? ?? A5 24 0D 00 40 10 21 80 40 00 21 28 20 02 ?? ?? ?? 0? 21 20 40 00 21 20 00 02 ?? ?? ?? 0? 21 88 40 00 0C 00 BF 8F 21 10 20 02 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 10 00 BD 27 0C 00 BF 8F 21 88 00 00 21 10 20 02 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 10 00 BD 27 }
	condition:
		$1
}

rule file_23_5_0 {
	meta:
		name = "load_tga"
		size = 116
		refs = "0018 pack_fopen 000c $LC1 002c load_tga_pf 0038 pack_fclose"
	strings:
		$1 = { F0 FF BD 27 08 00 B1 AF 21 88 A0 00 ?? ?? 05 3C 04 00 B0 AF 0C 00 BF AF ?? ?? ?? 0? ?? ?? A5 24 0D 00 40 10 21 80 40 00 21 28 20 02 ?? ?? ?? 0? 21 20 40 00 21 20 00 02 ?? ?? ?? 0? 21 88 40 00 0C 00 BF 8F 21 10 20 02 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 10 00 BD 27 0C 00 BF 8F 21 88 00 00 21 10 20 02 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 10 00 BD 27 }
	condition:
		$1
}

rule file_2_0_0 {
	meta:
		name = "load_bios_font"
		size = 360
		refs = "0030 _al_malloc 0050 $LC0 005c pack_fopen 00bc pack_fread 00c8 font_vtable_mono 00f4 pack_fclose"
	strings:
		$1 = { D0 FF BD 27 08 00 B0 AF 21 80 80 00 0C 00 04 24 2C 00 BF AF 28 00 BE AF 24 00 B7 AF 1C 00 B5 AF 20 00 B6 AF 18 00 B4 AF 14 00 B3 AF 10 00 B2 AF ?? ?? ?? 0? 0C 00 B1 AF 10 00 04 24 ?? ?? ?? 0? 00 00 A2 AF 00 04 04 24 ?? ?? ?? 0? 21 B8 40 00 ?? ?? 05 3C 21 20 00 02 ?? ?? A5 24 ?? ?? ?? 0? 21 F0 40 00 32 00 40 10 21 A8 40 00 1C 00 42 8C 08 00 03 24 10 00 12 24 00 08 42 38 0A 90 62 00 14 00 11 24 0C 00 03 24 0A 88 62 00 21 A0 40 02 21 80 C0 03 00 04 D3 27 08 00 16 24 ?? ?? ?? 0? 21 20 20 02 00 00 02 AE 00 00 56 A4 04 00 10 26 02 00 54 A4 04 00 44 24 21 28 40 02 ?? ?? ?? 0? 21 30 A0 02 F5 FF 70 16 ?? ?? 02 3C 00 00 B0 8F ?? ?? 43 8C 00 01 02 24 04 00 12 AE 08 00 FE AE 00 00 17 AE 08 00 03 AE 04 00 E2 AE 0C 00 E0 AE 00 00 E0 AE ?? ?? ?? 0? 21 20 A0 02 2C 00 BF 8F 21 10 00 02 28 00 BE 8F 24 00 B7 8F 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 E0 03 30 00 BD 27 2C 00 BF 8F 21 80 00 00 21 10 00 02 28 00 BE 8F 24 00 B7 8F 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_3_0_0 {
	meta:
		name = "get_datafile_property"
		size = 108
		refs = "0024 .text 0044 empty_string"
	strings:
		$1 = { 0C 00 83 8C 10 00 60 10 ?? ?? 02 3C 04 00 64 8C FF FF 02 24 0C 00 82 10 ?? ?? 02 3C 0D 00 85 10 FF FF 04 24 ?? ?? ?? 0? 08 00 63 24 0A 00 45 50 00 00 62 8C 08 00 63 24 04 00 62 8C FB FF 44 14 00 00 00 00 ?? ?? 02 3C ?? ?? 42 24 08 00 E0 03 00 00 00 00 00 00 62 8C FC FF 40 14 00 00 00 00 ?? ?? 02 3C 08 00 E0 03 ?? ?? 42 24 }
	condition:
		$1
}

rule file_3_1_0 {
	meta:
		name = "initialise_datafile"
		size = 512
		refs = "0048 _stub_bank_switch 0050 _vtable_list 0118 .text 0068 font_vtable_mono 01c4 font_vtable_color"
	strings:
		$1 = { 04 00 85 8C D8 FF BD 27 FF FF 02 24 24 00 BF AF 20 00 BE AF 1C 00 B7 AF 18 00 B6 AF 14 00 B5 AF 10 00 B4 AF 0C 00 B3 AF 08 00 B2 AF 04 00 B1 AF 1A 00 A2 10 00 00 B0 AF 49 46 02 3C 4F 46 03 3C 45 4C 54 34 54 4E 75 34 ?? ?? 02 3C 4D 42 03 3C ?? ?? 13 3C ?? ?? 11 3C ?? ?? 52 24 20 50 76 34 10 00 90 24 01 00 17 24 ?? ?? 1E 3C ?? ?? 73 26 30 00 B4 10 00 00 00 00 29 00 B5 50 00 00 84 8C 12 00 B6 10 ?? ?? 02 3C 04 00 05 8E FF FF 02 24 21 20 00 02 F6 FF A2 14 10 00 10 26 24 00 BF 8F 20 00 BE 8F 1C 00 B7 8F 18 00 B6 8F 14 00 B5 8F 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 28 00 BD 27 ?? ?? 42 24 04 00 45 8C EC FF A0 10 00 00 84 8C 1C 00 86 8C ?? ?? 22 8E 0A 00 46 50 1C 00 85 AC ?? ?? 03 3C ?? ?? 63 24 00 00 65 8C E4 FF A0 50 04 00 05 8E FC FF 62 8C FB FF 46 14 08 00 63 24 1C 00 85 AC 3C 00 80 AC 20 00 92 AC ?? ?? ?? 0? 24 00 92 AC 08 00 82 8C 07 00 57 10 ?? ?? C2 8F ?? ?? ?? 0? 08 00 82 AC ?? ?? ?? 0? 00 00 84 8C ?? ?? ?? 0? 04 00 05 8E 00 00 8A 8C 1F 00 40 11 ?? ?? 03 3C 00 00 49 8D 04 00 4C 8D 2A 10 2C 01 17 00 40 50 0C 00 4A 8D ?? ?? 03 3C ?? ?? 63 24 04 00 6B 8C 08 00 48 8D 0C 00 60 11 00 00 07 8D 1C 00 E6 8C ?? ?? 22 8E 13 00 46 10 21 18 60 02 ?? ?? ?? 0? 00 00 65 8C 10 00 46 10 08 00 63 24 00 00 65 8C FC FF A0 54 FC FF 62 8C 01 00 29 25 2A 10 2C 01 F0 FF 40 14 04 00 08 25 0C 00 4A 8D E5 FF 40 55 00 00 49 8D ?? ?? 03 3C ?? ?? 62 8C ?? ?? ?? 0? 08 00 82 AC 21 28 60 01 01 00 29 25 2A 10 2C 01 1C 00 E5 AC 3C 00 E0 AC 20 00 F2 AC 24 00 F2 AC E0 FF 40 14 04 00 08 25 ?? ?? ?? 0? 0C 00 4A 8D }
	condition:
		$1
}

rule file_3_2_0 {
	meta:
		name = "_construct_datafile"
		size = 16
		refs = "0008 .text 0004 .bss"
	strings:
		$1 = { FF FF 03 24 ?? ?? 02 3C ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_2_8_10 {
	meta:
		name = "_ZN7Texture10clearLocksEv"
		size = 16
		refs = "0004 _ZN7Texture8tex_lockE"
	strings:
		$1 = { FF FF 03 24 ?? ?? 02 3C 08 00 E0 03 ?? ?? 43 AC }
	condition:
		$1
}

rule file_66_11_0 {
	meta:
		name = "allegro_exit_stub"
		size = 16
		refs = "0008 allegro_exit 0004 _allegro_in_exit"
	strings:
		$1 = { FF FF 03 24 ?? ?? 02 3C ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_3_3_0 {
	meta:
		name = "_initialize_datafile_types"
		size = 248
		refs = "0004 .text 0008 unload_datafile 0020 register_datafile_object 0030 destroy_font 0084 destroy_bitmap 00a0 destroy_rle_sprite 00b4 destroy_compiled_sprite"
	strings:
		$1 = { 49 46 04 3C ?? ?? 05 3C ?? ?? 06 3C F8 FF BD 27 45 4C 84 34 ?? ?? A5 24 ?? ?? C6 24 04 00 BF AF ?? ?? ?? 0? 00 00 B0 AF 4F 46 04 3C ?? ?? 05 3C ?? ?? 06 3C 54 4E 84 34 ?? ?? A5 24 ?? ?? ?? 0? ?? ?? C6 24 41 53 04 3C ?? ?? 05 3C ?? ?? 06 3C 50 4D 84 34 ?? ?? A5 24 ?? ?? ?? 0? ?? ?? C6 24 49 4D 04 3C ?? ?? 05 3C ?? ?? 06 3C 49 44 84 34 ?? ?? A5 24 ?? ?? ?? 0? ?? ?? C6 24 4D 42 04 3C ?? ?? 05 3C ?? ?? 06 3C 20 50 84 34 ?? ?? A5 24 ?? ?? ?? 0? ?? ?? C6 24 4C 52 04 3C ?? ?? 05 3C ?? ?? 06 3C 20 45 84 34 ?? ?? A5 24 ?? ?? C6 24 ?? ?? ?? 0? ?? ?? 10 3C ?? ?? 10 26 4D 43 04 3C ?? ?? 05 3C 21 30 00 02 20 50 84 34 ?? ?? ?? 0? ?? ?? A5 24 43 58 04 3C ?? ?? 05 3C 21 30 00 02 04 00 BF 8F 00 00 B0 8F 50 4D 84 34 ?? ?? A5 24 ?? ?? ?? 0? 08 00 BD 27 }
	condition:
		$1
}

rule file_3_4_0 {
	meta:
		name = "load_file_object"
		size = 448
		refs = "0028 pack_mgetl 0038 _al_malloc 0060 .text 005c .bss 00c4 _load_property 00d8 _add_property 0160 _destroy_property_list 0170 unload_datafile 0178 _al_free 01a8 allegro_errno"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 24 00 B4 AF 20 00 B3 AF 1C 00 B2 AF 30 00 B7 AF 21 90 80 00 2C 00 B6 AF 28 00 B5 AF 18 00 B1 AF ?? ?? ?? 0? 14 00 B0 AF 01 00 44 24 00 21 04 00 ?? ?? ?? 0? 21 A0 40 00 59 00 40 10 21 98 40 00 53 00 80 1A 00 00 A0 AF 72 70 02 3C 70 6F 55 34 21 88 00 00 ?? ?? 16 3C ?? ?? ?? 0? 04 00 B7 27 ?? ?? ?? 0? 00 00 00 00 45 00 40 14 21 20 00 02 00 00 A2 8F ?? ?? C3 8E 01 00 31 26 0C 00 02 AE 03 00 60 10 00 00 A0 AF 09 F8 60 00 00 00 00 00 2A 10 34 02 29 00 40 10 00 11 11 00 ?? ?? ?? 0? 21 20 40 02 00 19 11 00 21 80 63 02 21 30 40 00 21 20 00 02 EA FF 55 14 21 28 40 02 ?? ?? ?? 0? 21 20 E0 02 21 20 A0 03 2F 00 40 14 21 28 E0 02 ?? ?? ?? 0? 00 00 00 00 EE FF 40 10 2A 10 34 02 00 00 A4 8F 00 11 11 00 21 80 62 02 FF FF 02 24 FF FF 11 24 04 00 02 AE 17 00 80 14 00 00 00 AE 19 00 20 16 00 00 00 00 21 20 60 02 34 00 BF 8F 21 10 80 00 30 00 B7 8F 2C 00 B6 8F 28 00 B5 8F 24 00 B4 8F 20 00 B3 8F 1C 00 B2 8F 18 00 B1 8F 14 00 B0 8F 08 00 E0 03 38 00 BD 27 21 80 62 02 21 88 00 00 00 00 A4 8F FF FF 02 24 04 00 02 AE EB FF 80 10 00 00 00 AE ?? ?? ?? 0? 00 00 00 00 EA FF 20 12 21 20 60 02 ?? ?? ?? 0? 21 20 60 02 ?? ?? ?? 0? 21 20 60 02 ?? ?? ?? 0? 21 98 00 00 ?? ?? ?? 0? FF FF 11 24 ?? ?? ?? 0? FF FF 11 24 FF FF 02 24 04 00 62 AE ?? ?? ?? 0? 00 00 60 AE ?? ?? 02 3C ?? ?? 43 8C 0C 00 02 24 21 20 00 00 ?? ?? ?? 0? 00 00 62 AC }
	condition:
		$1
}

rule file_3_5_0 {
	meta:
		name = "unload_datafile"
		size = 124
		refs = "0030 _unload_datafile_object 005c _al_free"
	strings:
		$1 = { F0 FF BD 27 04 00 B1 AF 0C 00 BF AF 08 00 B2 AF 00 00 B0 AF 13 00 80 10 21 88 80 00 04 00 83 8C FF FF 02 24 08 00 62 10 10 00 90 24 FF FF 12 24 ?? ?? ?? 0? 00 00 00 00 04 00 02 8E 21 20 00 02 FB FF 52 14 10 00 10 26 21 20 20 02 0C 00 BF 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F ?? ?? ?? 0? 10 00 BD 27 0C 00 BF 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 10 00 BD 27 }
	condition:
		$1
}

rule file_3_6_0 {
	meta:
		name = "load_font_object"
		size = 1056
		refs = "002c pack_mgetw 0048 _al_malloc 007c pack_getc 0098 font_vtable_color 00cc pack_mgetl 0118 .text 0164 destroy_bitmap 0174 _al_free 0188 allegro_errno 0198 destroy_font 01d8 font_vtable_mono 0254 pack_fread"
	strings:
		$1 = { C8 FF BD 27 24 00 B5 AF 34 00 BF AF 30 00 BE AF 2C 00 B7 AF 28 00 B6 AF 20 00 B4 AF 1C 00 B3 AF 18 00 B2 AF 14 00 B1 AF 10 00 B0 AF ?? ?? ?? 0? 21 A8 80 00 20 2E 02 7C D7 00 A0 1C 21 20 A0 02 E4 00 A0 14 34 00 BF 8F ?? ?? ?? 0? 0C 00 04 24 EC 00 40 10 0C 00 A2 AF 0C 00 A2 8F 21 20 A0 02 21 B8 00 00 ?? ?? ?? 0? 00 00 40 AC 04 00 A2 AF 04 00 A3 8F AF 00 60 10 0C 00 A2 8F ?? ?? ?? 0? 21 20 A0 02 01 00 03 24 53 00 43 10 21 90 40 00 FF 00 02 24 50 00 42 12 ?? ?? 03 3C ?? ?? 62 8C 0C 00 A3 8F 10 00 04 24 00 00 63 8C 00 00 A3 AF 0C 00 A3 8F ?? ?? ?? 0? 08 00 62 AC 21 B0 40 00 08 00 02 24 30 00 C0 12 0A 90 52 00 ?? ?? ?? 0? 21 20 A0 02 00 00 C2 AE ?? ?? ?? 0? 21 20 A0 02 00 00 C3 8E 01 00 42 24 04 00 C2 AE 23 98 43 00 0C 00 C0 AE ?? ?? ?? 0? 80 20 13 00 21 F0 40 00 1E 00 40 10 08 00 C2 AE 7C 00 60 1A 08 00 42 3A 2B A0 02 00 21 80 C0 03 ?? ?? ?? 0? 21 88 00 00 04 00 43 8C 01 00 31 26 2A 10 33 02 73 00 40 10 2C B8 E3 02 21 20 A0 02 21 28 40 02 ?? ?? ?? 0? 21 30 80 02 00 00 02 AE F5 FF 40 14 04 00 10 26 08 00 20 12 FF FF 31 26 80 10 11 00 21 80 C2 03 00 00 04 8E ?? ?? ?? 0? FC FF 10 26 FC FF 20 16 FF FF 31 26 ?? ?? ?? 0? 21 20 C0 03 21 20 C0 02 ?? ?? ?? 0? 00 00 00 00 ?? ?? 02 3C ?? ?? 44 8C 0C 00 03 24 00 00 83 AC ?? ?? ?? 0? 0C 00 A4 8F 0C 00 A0 AF 34 00 BF 8F 0C 00 A2 8F 30 00 BE 8F 2C 00 B7 8F 28 00 B6 8F 24 00 B5 8F 20 00 B4 8F 1C 00 B3 8F 18 00 B2 8F 14 00 B1 8F 10 00 B0 8F 08 00 E0 03 38 00 BD 27 ?? ?? 03 3C ?? ?? 62 8C 0C 00 A3 8F 10 00 04 24 00 00 63 8C 08 00 A3 AF 0C 00 A3 8F ?? ?? ?? 0? 08 00 62 AC E2 FF 40 10 21 F0 40 00 ?? ?? ?? 0? 21 20 A0 02 00 00 C2 AF ?? ?? ?? 0? 21 20 A0 02 00 00 C3 8F 01 00 42 24 04 00 C2 AF 23 B0 43 00 0C 00 C0 AF ?? ?? ?? 0? 80 20 16 00 78 00 40 10 08 00 C2 AF 4B 00 C0 1A 21 90 40 00 ?? ?? ?? 0? 21 98 00 00 00 00 54 A4 02 00 51 A4 ?? ?? ?? 0? 01 00 73 26 2A 18 76 02 43 00 60 10 08 00 A2 8F ?? ?? ?? 0? 21 20 A0 02 21 20 A0 02 ?? ?? ?? 0? 21 A0 40 00 21 88 40 00 07 00 90 26 08 00 02 24 02 00 40 14 1A 00 02 02 CD 01 00 00 2C B8 F1 02 12 80 00 00 18 00 11 02 12 80 00 00 ?? ?? ?? 0? 04 00 04 26 00 00 42 AE 04 00 44 24 21 28 00 02 21 30 A0 02 E3 FF 40 14 04 00 52 26 09 00 60 12 FF FF 71 26 80 80 11 00 08 00 C2 8F 21 10 50 00 00 00 44 8C ?? ?? ?? 0? FC FF 10 26 FA FF 20 16 FF FF 31 26 ?? ?? ?? 0? 21 20 C0 03 ?? ?? ?? 0? 08 00 C4 8F 00 00 A2 8F 23 00 40 10 0C 00 A3 8F 21 18 40 00 0C 00 42 8C FE FF 40 54 21 18 40 00 0C 00 76 AC 04 00 A2 8F FF FF 42 24 04 00 A2 AF 04 00 A3 8F 53 FF 60 14 0C 00 A2 8F 34 00 BF 8F 30 00 BE 8F 04 00 57 AC 28 00 B6 8F 0C 00 A2 8F 2C 00 B7 8F 24 00 B5 8F 20 00 B4 8F 1C 00 B3 8F 18 00 B2 8F 14 00 B1 8F 10 00 B0 8F 08 00 E0 03 38 00 BD 27 08 00 A2 8F 16 00 40 50 0C 00 A2 8F 21 18 40 00 0C 00 42 8C FE FF 40 54 21 18 40 00 ?? ?? ?? 0? 0C 00 7E AC ?? ?? ?? 0? 00 00 76 AC 34 00 BF 8F 30 00 BE 8F 2C 00 B7 8F 28 00 B6 8F 24 00 B5 8F 20 00 B4 8F 1C 00 B3 8F 18 00 B2 8F 14 00 B1 8F 10 00 B0 8F E0 00 06 24 ?? ?? ?? 0? 38 00 BD 27 ?? ?? ?? 0? 00 00 5E AC 30 00 BE 8F 2C 00 B7 8F 28 00 B6 8F 24 00 B5 8F 20 00 B4 8F 1C 00 B3 8F 18 00 B2 8F 14 00 B1 8F 10 00 B0 8F E0 00 05 24 ?? ?? ?? 0? 38 00 BD 27 ?? ?? 02 3C ?? ?? 44 8C 0C 00 03 24 ?? ?? ?? 0? 00 00 83 AC ?? ?? ?? 0? 21 20 C0 03 }
	condition:
		$1
}

rule file_3_8_0 {
	meta:
		name = "unload_sample"
		size = 76
		refs = "0020 _al_free"
	strings:
		$1 = { F8 FF BD 27 00 00 B0 AF 04 00 BF AF 0B 00 80 10 21 80 80 00 20 00 84 8C 04 00 80 50 21 20 00 02 ?? ?? ?? 0? 00 00 00 00 21 20 00 02 04 00 BF 8F 00 00 B0 8F ?? ?? ?? 0? 08 00 BD 27 04 00 BF 8F 00 00 B0 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_3_10_0 {
	meta:
		name = "unload_midi"
		size = 124
		refs = "0038 _al_free"
	strings:
		$1 = { F0 FF BD 27 04 00 B1 AF 0C 00 BF AF 08 00 B2 AF 00 00 B0 AF 13 00 80 10 21 88 80 00 21 80 00 00 00 01 12 24 21 10 30 02 04 00 43 8C 08 00 10 26 03 00 60 10 21 20 60 00 ?? ?? ?? 0? 00 00 00 00 F9 FF 12 16 21 10 30 02 21 20 20 02 0C 00 BF 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F ?? ?? ?? 0? 10 00 BD 27 0C 00 BF 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 10 00 BD 27 }
	condition:
		$1
}

rule file_3_11_0 {
	meta:
		name = "load_bitmap_object"
		size = 48
		refs = "000c pack_mgetw 0028 .text"
	strings:
		$1 = { F8 FF BD 27 04 00 BF AF 00 00 B0 AF ?? ?? ?? 0? 21 80 80 00 20 2E 02 7C 21 20 00 02 04 00 BF 8F 00 00 B0 8F FF FF 06 24 ?? ?? ?? 0? 08 00 BD 27 }
	condition:
		$1
}

rule file_3_12_0 {
	meta:
		name = "load_rle_sprite_object"
		size = 44
		refs = "000c pack_mgetw 0024 .text"
	strings:
		$1 = { F8 FF BD 27 04 00 BF AF 00 00 B0 AF ?? ?? ?? 0? 21 80 80 00 20 2E 02 7C 21 20 00 02 04 00 BF 8F 00 00 B0 8F ?? ?? ?? 0? 08 00 BD 27 }
	condition:
		$1
}

rule file_3_13_0 {
	meta:
		name = "load_compiled_sprite_object"
		size = 48
		refs = "000c pack_mgetw 0028 .text"
	strings:
		$1 = { F8 FF BD 27 04 00 BF AF 00 00 B0 AF ?? ?? ?? 0? 21 80 80 00 20 36 02 7C 21 20 00 02 04 00 BF 8F 00 00 B0 8F 21 28 00 00 ?? ?? ?? 0? 08 00 BD 27 }
	condition:
		$1
}

rule file_3_14_0 {
	meta:
		name = "load_xcompiled_sprite_object"
		size = 48
		refs = "000c pack_mgetw 0028 .text"
	strings:
		$1 = { F8 FF BD 27 04 00 BF AF 00 00 B0 AF ?? ?? ?? 0? 21 80 80 00 20 36 02 7C 21 20 00 02 04 00 BF 8F 00 00 B0 8F FF FF 05 24 ?? ?? ?? 0? 08 00 BD 27 }
	condition:
		$1
}

rule file_3_15_0 {
	meta:
		name = "read_bitmap"
		size = 1672
		refs = "0048 pack_mgetw 0070 create_bitmap_ex 00d8 blit 00e0 destroy_bitmap 0150 .rodata 016c _color_load_depth 0174 .text 01c0 _rgb_g_shift_32 01c4 _rgb_r_shift_32 01d0 _rgb_b_shift_32 01d8 _rgb_a_shift_32 0210 pack_getc 0270 _rgb_g_shift_24 027c _rgb_r_shift_24 0280 _rgb_b_shift_24 0320 _rgb_scale_5 0344 pack_igetw 0354 _rgb_scale_6 032c _rgb_g_shift_16 0380 _rgb_r_shift_16 0330 _rgb_b_shift_16 040c _rgb_g_shift_15 0460 _rgb_r_shift_15 0410 _rgb_b_shift_15 04e8 pack_fread 065c allegro_errno"
	strings:
		$1 = { C0 FF BD 27 28 00 B4 AF 3C 00 BF AF 38 00 BE AF 34 00 B7 AF 30 00 B6 AF 2C 00 B5 AF 24 00 B3 AF 20 00 B2 AF 1C 00 B1 AF 18 00 B0 AF 14 00 A5 AF 52 00 A0 04 21 A0 80 00 21 F0 00 00 4A 00 C0 14 08 00 03 24 0C 00 A3 AF ?? ?? ?? 0? 21 20 80 02 21 20 80 02 ?? ?? ?? 0? 21 B8 40 00 14 00 A5 8F 08 00 04 24 21 30 40 00 2C 20 A4 00 21 28 E0 02 ?? ?? ?? 0? 10 00 A2 AF 7D 01 40 10 04 00 A2 AF 14 00 A6 8F FC FF C3 24 1D 00 62 2C 30 00 40 14 80 10 03 00 14 00 A5 8F 0C 00 A6 8F 1F 00 A6 10 04 00 B0 8F 0C 00 A4 8F 10 00 A6 8F ?? ?? ?? 0? 21 28 E0 02 69 01 40 10 21 80 40 00 00 00 4A 8C 04 00 4B 8C 04 00 A4 8F 21 28 40 00 21 30 00 00 21 38 00 00 21 40 00 00 ?? ?? ?? 0? 21 48 00 00 ?? ?? ?? 0? 04 00 A4 8F 3C 00 BF 8F 21 10 00 02 38 00 BE 8F 34 00 B7 8F 30 00 B6 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 40 00 BD 27 3C 00 BF 8F 21 10 00 02 38 00 BE 8F 34 00 B7 8F 30 00 B6 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 40 00 BD 27 ?? ?? 03 3C ?? ?? 63 24 21 18 62 00 00 00 64 8C 08 00 80 00 00 00 00 00 14 00 A4 8F ?? ?? ?? 0? 21 28 C0 03 ?? ?? ?? 0? 0C 00 A2 AF 14 00 A2 8F FF FF 1E 24 23 10 02 00 ?? ?? ?? 0? 14 00 A2 AF 10 00 A7 8F BF FF E0 18 04 00 A4 8F 21 B0 00 00 08 00 A4 AF 08 00 A5 8F 1F 01 E0 1A 40 00 A2 8C 21 88 40 00 ?? ?? ?? 0? 21 80 00 00 21 30 00 00 ?? ?? 07 3C ?? ?? 04 3C ?? ?? E2 8C ?? ?? 83 8C ?? ?? 05 3C ?? ?? A4 8C ?? ?? 07 3C ?? ?? E5 8C 04 18 75 00 04 10 53 00 25 10 43 00 04 20 92 00 25 10 44 00 04 28 A6 00 01 00 10 26 25 10 45 00 2A 18 17 02 00 00 22 AE 07 01 60 10 04 00 31 26 ?? ?? ?? 0? 21 20 80 02 21 20 80 02 ?? ?? ?? 0? 21 A8 40 00 21 20 80 02 ?? ?? ?? 0? 21 98 40 00 E2 FF C0 13 21 90 40 00 ?? ?? ?? 0? 21 20 80 02 ?? ?? ?? 0? 21 30 40 00 10 00 A2 8F 91 FF 40 18 04 00 B5 8F 00 00 A0 AF E6 00 E0 1A 21 88 00 00 ?? ?? ?? 0? 01 00 10 24 03 00 02 24 18 00 22 02 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 83 8C ?? ?? A2 8C ?? ?? 06 3C ?? ?? C4 8C 40 00 A5 8E 04 10 56 00 04 18 73 00 25 18 62 00 04 20 92 00 25 18 64 00 03 32 03 00 03 24 03 00 01 00 31 26 2A 38 37 02 12 40 00 00 21 28 A8 00 00 00 A3 A0 40 00 A2 8E 21 10 50 00 00 00 46 A0 40 00 A3 8E 21 18 70 00 01 00 64 A0 C7 00 E0 10 03 00 10 26 ?? ?? ?? 0? 21 20 80 02 21 20 80 02 ?? ?? ?? 0? 21 B0 40 00 21 20 80 02 ?? ?? ?? 0? 21 98 40 00 DA FF C0 13 21 90 40 00 ?? ?? ?? 0? 21 20 80 02 ?? ?? ?? 0? 03 00 02 24 10 00 A3 8F 5E FF 60 18 04 00 B5 8F ?? ?? 02 3C ?? ?? 52 24 21 98 00 00 ?? ?? 1E 3C ?? ?? 16 3C 24 00 E0 1A 40 00 A2 8E 21 88 40 00 21 80 00 00 ?? ?? ?? 0? 21 20 80 02 C0 22 44 7C 40 29 45 7C ?? ?? 06 3C ?? ?? C6 24 80 20 04 00 80 28 05 00 1F 00 42 30 21 20 44 02 21 28 C5 00 80 10 02 00 00 00 83 8C 00 00 A6 8C 21 10 42 02 ?? ?? 07 3C 00 00 44 8C ?? ?? C5 8F ?? ?? E2 8C ?? ?? C7 8E C3 18 03 00 83 30 06 00 04 18 43 00 04 30 A6 00 C3 20 04 00 25 18 66 00 04 20 E4 00 01 00 10 26 25 18 64 00 2A 10 17 02 00 00 23 A6 E0 FF 40 14 02 00 31 26 10 00 A3 8F 01 00 73 26 2A 10 63 02 D7 FF 40 14 04 00 B5 26 14 00 A5 8F 0C 00 A6 8F 30 FF A6 14 0C 00 A4 8F ?? ?? ?? 0? 04 00 B0 8F 10 00 A4 8F 26 FF 80 18 04 00 B5 8F ?? ?? 02 3C ?? ?? 52 24 21 98 00 00 ?? ?? 1E 3C ?? ?? 16 3C 24 00 E0 1A 40 00 A2 8E 21 88 40 00 21 80 00 00 ?? ?? ?? 0? 21 20 80 02 C0 22 44 7C 40 29 45 7C ?? ?? 06 3C ?? ?? C6 24 80 20 04 00 80 28 05 00 1F 00 42 30 21 20 44 02 21 28 C5 00 80 10 02 00 00 00 83 8C 00 00 A6 8C 21 10 42 02 ?? ?? 07 3C 00 00 44 8C ?? ?? C5 8F ?? ?? E2 8C ?? ?? C7 8E C3 18 03 00 C3 30 06 00 04 18 43 00 04 30 A6 00 C3 20 04 00 25 18 66 00 04 20 E4 00 01 00 10 26 25 18 64 00 2A 10 17 02 00 00 23 A6 E0 FF 40 14 02 00 31 26 10 00 A3 8F 01 00 73 26 2A 10 63 02 D7 FF 40 14 04 00 B5 26 14 00 A5 8F 0C 00 A6 8F F8 FE A6 14 0C 00 A4 8F ?? ?? ?? 0? 04 00 B0 8F 10 00 A2 8F 04 00 A3 8F 21 30 80 02 18 00 57 00 28 00 64 8C ?? ?? ?? 0? 12 28 00 00 14 00 A5 8F 0C 00 A6 8F EB FE A6 14 0C 00 A4 8F ?? ?? ?? 0? 04 00 B0 8F 10 00 A3 8F 08 00 04 24 04 00 A6 8F 18 00 77 00 02 00 03 24 12 10 00 00 02 00 60 14 1A 00 43 00 CD 01 00 00 12 10 00 00 02 00 80 14 1A 00 44 00 CD 01 00 00 12 B0 00 00 D4 FE C0 12 28 00 C5 8C 21 A8 A0 00 10 00 13 24 ?? ?? ?? 0? 21 20 80 02 21 20 80 02 ?? ?? ?? 0? 21 90 40 00 21 20 80 02 ?? ?? ?? 0? 21 88 40 00 21 20 80 02 ?? ?? ?? 0? 21 80 40 00 21 38 40 00 21 30 A0 02 21 28 00 00 00 80 22 32 C0 03 43 7E 00 80 04 32 82 13 02 00 21 10 43 00 42 23 04 00 00 80 E3 30 21 10 44 00 02 1B 03 00 21 10 43 00 01 00 A5 24 00 00 C2 A0 40 90 12 00 01 00 C6 24 40 88 11 00 40 80 10 00 EF FF B3 14 40 38 07 00 FF FF D6 26 DE FF C0 16 10 00 B5 26 14 00 A5 8F 0C 00 A6 8F B0 FE A6 14 0C 00 A4 8F ?? ?? ?? 0? 04 00 B0 8F 00 00 A7 8F 10 00 A3 8F 04 00 B5 26 01 00 E7 24 2A 10 E3 00 13 FF 40 14 00 00 A7 AF 14 00 A5 8F 0C 00 A6 8F A3 FE A6 14 0C 00 A4 8F ?? ?? ?? 0? 04 00 B0 8F 08 00 A4 8F 10 00 A3 8F 01 00 D6 26 04 00 84 24 2A 10 C3 02 D9 FE 40 14 08 00 A4 AF 14 00 A5 8F 0C 00 A6 8F 96 FE A6 54 0C 00 A4 8F ?? ?? ?? 0? 04 00 B0 8F ?? ?? 02 3C ?? ?? 44 8C 0C 00 03 24 ?? ?? ?? 0? 00 00 83 AC ?? ?? 02 3C ?? ?? 43 8C 0C 00 02 24 21 80 00 00 ?? ?? ?? 0? 00 00 62 AC }
	condition:
		$1
}

rule file_3_16_0 {
	meta:
		name = "read_compiled_sprite"
		size = 180
		refs = "0018 .text 0028 _compile_sprites 0054 get_compiled_sprite 0064 destroy_bitmap 00a0 allegro_errno"
	strings:
		$1 = { F0 FF BD 27 08 00 B1 AF 21 88 A0 00 21 28 C0 00 04 00 B0 AF 0C 00 BF AF ?? ?? ?? 0? FF FF 06 24 18 00 40 10 21 80 40 00 ?? ?? 02 3C ?? ?? 43 8C 07 00 60 14 0C 00 BF 8F 21 88 00 02 21 10 20 02 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 10 00 BD 27 21 28 20 02 ?? ?? ?? 0? 21 20 00 02 10 00 40 10 21 88 40 00 ?? ?? ?? 0? 21 20 00 02 0C 00 BF 8F 21 10 20 02 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 10 00 BD 27 0C 00 BF 8F 21 88 00 00 21 10 20 02 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 10 00 BD 27 ?? ?? 02 3C ?? ?? 44 8C 0C 00 03 24 ?? ?? ?? 0? 00 00 83 AC }
	condition:
		$1
}

rule file_3_17_0 {
	meta:
		name = "read_palette"
		size = 268
		refs = "0024 _al_malloc 0044 pack_getc 00f8 allegro_errno 0104 .text"
	strings:
		$1 = { E8 FF BD 27 08 00 B2 AF 21 90 80 00 00 04 04 24 10 00 B4 AF 0C 00 B3 AF 14 00 BF AF 04 00 B1 AF 00 00 B0 AF ?? ?? ?? 0? 21 98 A0 00 32 00 40 10 21 A0 40 00 17 00 60 1A 21 38 00 00 21 80 40 00 21 88 00 00 ?? ?? ?? 0? 21 20 40 02 83 10 02 00 00 00 02 A2 ?? ?? ?? 0? 21 20 40 02 83 10 02 00 01 00 02 A2 ?? ?? ?? 0? 21 20 40 02 01 00 31 26 83 10 02 00 2A 18 33 02 02 00 02 A2 F1 FF 60 14 04 00 10 26 00 01 62 2A 13 00 40 10 14 00 BF 8F 21 38 60 02 80 10 07 00 21 28 82 02 21 30 00 00 80 10 06 00 21 10 82 02 03 00 43 88 01 00 C6 24 01 00 E7 24 00 00 43 98 2A 20 D3 00 00 01 E2 28 03 00 A3 A8 00 00 A3 B8 0A 30 04 00 F4 FF 40 14 04 00 A5 24 14 00 BF 8F 21 10 80 02 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 18 00 BD 27 ?? ?? 02 3C ?? ?? 44 8C 0C 00 03 24 ?? ?? ?? 0? 00 00 83 AC }
	condition:
		$1
}

rule file_3_18_0 {
	meta:
		name = "read_rle_sprite"
		size = 1124
		refs = "0460 allegro_errno 003c pack_mgetw 0054 pack_mgetl 0060 _al_malloc 0098 .rodata 00bc pack_fread 00c8 _color_load_depth 00e4 create_bitmap_ex 0160 blit 0168 destroy_rle_sprite 0170 get_rle_sprite 017c destroy_bitmap 01d4 pack_igetl 0204 .text 0220 makeacol_depth 0238 pack_getc 0300 _rgb_scale_5 030c _rgb_scale_6 031c pack_igetw 0388 makecol_depth"
	strings:
		$1 = { C0 FF BD 27 38 00 BE AF 2C 00 B5 AF 3C 00 BF AF 34 00 B7 AF 30 00 B6 AF 28 00 B4 AF 24 00 B3 AF 20 00 B2 AF 1C 00 B1 AF 18 00 B0 AF 21 F0 A0 00 F5 00 A0 04 21 A8 80 00 0C 00 A0 AF ?? ?? ?? 0? 21 20 A0 02 21 20 A0 02 ?? ?? ?? 0? 21 88 40 00 21 20 A0 02 ?? ?? ?? 0? 10 00 A2 AF 10 00 44 24 ?? ?? ?? 0? 21 80 40 00 EB 00 40 10 08 00 A2 AF 08 00 A4 8F 10 00 A5 8F F8 FF C3 27 19 00 62 2C 00 00 91 AC 04 00 85 AC 08 00 9E AC 0D 00 40 10 0C 00 90 AC 80 10 03 00 ?? ?? 03 3C ?? ?? 63 24 21 18 62 00 00 00 64 8C 08 00 80 00 00 00 00 00 08 00 A2 8F 21 28 00 02 21 30 A0 02 ?? ?? ?? 0? 10 00 44 24 0C 00 A5 8F ?? ?? ?? 0? 21 20 C0 03 2E 00 C2 13 21 88 40 00 08 00 A2 8F 21 20 C0 03 00 00 45 8C ?? ?? ?? 0? 04 00 46 8C D9 00 40 10 21 80 40 00 1C 00 43 8C 21 20 40 00 A0 00 62 8C 09 F8 40 00 04 00 65 8C 1C 00 03 8E 08 00 A5 8F 21 30 00 00 64 00 62 8C 21 38 00 00 09 F8 40 00 21 20 00 02 08 00 A3 8F 21 20 20 02 00 00 65 8C ?? ?? ?? 0? 04 00 66 8C BC 00 40 10 21 88 40 00 08 00 A4 8F 21 28 40 00 21 30 00 00 00 00 8A 8C 04 00 8B 8C 21 38 00 00 21 40 00 00 21 48 00 00 ?? ?? ?? 0? 21 20 00 02 ?? ?? ?? 0? 08 00 A4 8F ?? ?? ?? 0? 21 20 20 02 21 20 00 02 ?? ?? ?? 0? 08 00 A2 AF ?? ?? ?? 0? 21 20 20 02 3C 00 BF 8F 08 00 A2 8F 38 00 BE 8F 34 00 B7 8F 30 00 B6 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 40 00 BD 27 10 00 A4 8F BF FF 80 18 08 00 A5 8F 00 00 A0 AF 10 00 B7 24 ?? ?? ?? 0? 21 20 A0 02 21 B0 40 00 FF 00 02 3C FF 00 42 34 32 00 C2 12 00 00 A5 8F 7A 00 C0 06 00 00 F6 AE 27 00 C0 12 04 00 F7 26 FF FF D1 26 ?? ?? ?? 0? 21 80 E0 02 21 10 00 00 21 28 80 02 21 30 60 02 21 38 40 02 21 40 40 00 ?? ?? ?? 0? 21 20 C0 03 00 00 02 AE 18 00 20 12 04 00 10 26 FF FF 31 26 ?? ?? ?? 0? 21 20 A0 02 21 20 A0 02 ?? ?? ?? 0? 21 A0 40 00 21 20 A0 02 ?? ?? ?? 0? 21 98 40 00 0C 00 A3 8F EB FF 60 10 21 90 40 00 ?? ?? ?? 0? 21 20 A0 02 21 40 40 00 21 28 80 02 21 30 60 02 21 38 40 02 ?? ?? ?? 0? 21 20 C0 03 00 00 02 AE EA FF 20 16 04 00 10 26 80 10 16 00 21 B8 E2 02 ?? ?? ?? 0? 21 20 A0 02 FF 00 04 3C FF 00 84 34 D1 FF 44 14 21 B0 40 00 00 00 A5 8F 10 00 A3 8F FF 00 04 3C 01 00 A5 24 FF 00 84 34 2A 10 A3 00 00 00 A5 AF 7D FF 40 10 00 00 E4 AE ?? ?? ?? 0? 04 00 F7 26 1F F8 03 34 04 00 A3 AF 04 00 A4 8F 10 00 A5 8F 0F 00 C3 3B 1F 7C 02 24 0A 20 43 00 72 FF A0 18 04 00 A4 AF ?? ?? 02 3C ?? ?? 54 24 08 00 A2 8F ?? ?? 03 3C ?? ?? 76 24 10 00 53 24 21 B8 00 00 ?? ?? ?? 0? 21 20 A0 02 20 96 02 7C 1F F8 03 24 24 00 43 12 10 00 A5 8F 32 00 40 06 00 00 72 A6 1A 00 40 12 02 00 73 26 21 88 60 02 21 80 00 00 ?? ?? ?? 0? 21 20 A0 02 1F 00 44 30 C0 22 43 7C 40 29 42 7C 80 18 03 00 80 10 02 00 80 20 04 00 21 18 83 02 21 10 C2 02 21 20 84 02 00 00 65 8C 00 00 87 8C 00 00 46 8C 01 00 10 26 ?? ?? ?? 0? 21 20 C0 03 23 18 50 02 00 00 22 A6 EC FF 60 1C 02 00 31 26 40 10 12 00 21 98 62 02 ?? ?? ?? 0? 21 20 A0 02 20 96 02 7C 1F F8 04 24 DE FF 44 16 10 00 A5 8F 04 00 A3 8F 01 00 F7 26 2A 10 E5 02 3D FF 40 10 00 00 63 A6 ?? ?? ?? 0? 02 00 73 26 ?? ?? ?? 0? 21 20 A0 02 FF 00 04 3C FF 00 84 34 04 00 F7 26 7F FF 44 14 21 B0 40 00 ?? ?? ?? 0? 00 00 A5 8F ?? ?? ?? 0? 02 00 73 26 FF FF 02 24 23 F0 05 00 ?? ?? ?? 0? 0C 00 A2 AF ?? ?? 02 3C ?? ?? 44 8C 0C 00 03 24 ?? ?? ?? 0? 00 00 83 AC ?? ?? ?? 0? 08 00 A4 8F ?? ?? ?? 0? 21 20 00 02 ?? ?? 02 3C ?? ?? 43 8C 0C 00 02 24 08 00 A0 AF ?? ?? ?? 0? 00 00 62 AC ?? ?? ?? 0? 08 00 A4 8F ?? ?? ?? 0? ?? ?? 02 3C }
	condition:
		$1
}

rule file_3_19_0 {
	meta:
		name = "read_block"
		size = 140
		refs = "001c _al_malloc 0034 pack_fread 003c pack_ferror 0068 _al_free 0070 .text 0078 allegro_errno"
	strings:
		$1 = { F0 FF BD 27 08 00 B2 AF 21 90 80 00 2C 20 C5 00 04 00 B1 AF 00 00 B0 AF 0C 00 BF AF ?? ?? ?? 0? 21 88 A0 00 14 00 40 10 21 80 40 00 21 20 40 00 21 28 20 02 ?? ?? ?? 0? 21 30 40 02 ?? ?? ?? 0? 21 20 40 02 08 00 40 14 00 00 00 00 0C 00 BF 8F 21 10 00 02 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 10 00 BD 27 ?? ?? ?? 0? 21 20 00 02 ?? ?? ?? 0? 21 80 00 00 ?? ?? 02 3C ?? ?? 44 8C 0C 00 03 24 ?? ?? ?? 0? 00 00 83 AC }
	condition:
		$1
}

rule file_3_20_0 {
	meta:
		name = "read_midi"
		size = 264
		refs = "0020 _al_malloc 0054 pack_mgetw 0068 pack_mgetl 0088 .text 00f4 allegro_errno"
	strings:
		$1 = { E8 FF BD 27 08 00 B2 AF 21 90 80 00 04 01 04 24 10 00 B4 AF 14 00 BF AF 0C 00 B3 AF 04 00 B1 AF ?? ?? ?? 0? 00 00 B0 AF 32 00 40 10 21 A0 40 00 08 00 51 24 21 10 20 02 21 18 00 00 20 00 04 24 01 00 63 24 00 00 40 AC FC FF 40 AC FC FF 64 14 08 00 42 24 ?? ?? ?? 0? 21 20 40 02 00 00 82 AE 21 80 00 00 20 00 13 24 ?? ?? ?? 0? 21 20 40 02 01 00 10 26 21 28 40 00 21 20 40 02 21 30 00 00 05 00 40 18 00 00 22 AE ?? ?? ?? 0? 00 00 00 00 0C 00 40 10 FC FF 22 AE F3 FF 13 16 08 00 31 26 14 00 BF 8F 21 10 80 02 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 18 00 BD 27 ?? ?? ?? 0? 21 20 80 02 14 00 BF 8F 21 A0 00 00 21 10 80 02 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 18 00 BD 27 ?? ?? 02 3C ?? ?? 44 8C 0C 00 03 24 ?? ?? ?? 0? 00 00 83 AC }
	condition:
		$1
}

rule file_3_21_0 {
	meta:
		name = "read_sample"
		size = 432
		refs = "0024 _al_malloc 0034 pack_mgetw 005c pack_mgetl 00bc .text 00c8 pack_igetw 0100 pack_ferror 0180 _al_free 019c allegro_errno"
	strings:
		$1 = { E0 FF BD 27 10 00 B3 AF 21 98 80 00 24 00 04 24 0C 00 B2 AF 1C 00 BF AF 18 00 B5 AF 14 00 B4 AF 08 00 B1 AF ?? ?? ?? 0? 04 00 B0 AF 5B 00 40 10 21 90 40 00 ?? ?? ?? 0? 21 20 60 02 20 16 02 7C 4B 00 42 04 23 10 02 00 00 00 42 AE 04 00 40 AE ?? ?? ?? 0? 21 20 60 02 08 00 42 AE ?? ?? ?? 0? 21 20 60 02 21 30 40 00 00 00 42 8E 80 00 03 24 0C 00 43 AE 08 00 03 24 10 00 46 AE 14 00 40 AE 18 00 46 AE 2F 00 43 10 1C 00 40 AE 04 00 45 8E 02 00 02 24 01 00 04 24 0B 20 45 00 40 18 06 00 18 00 64 00 ?? ?? ?? 0? 12 20 00 00 37 00 40 10 20 00 42 AE 21 88 00 00 02 00 15 24 ?? ?? ?? 0? 01 00 14 24 20 00 50 8E ?? ?? ?? 0? 21 80 05 02 00 00 02 A6 04 00 42 8E 10 00 44 8E 21 18 80 02 0B 18 A2 02 18 00 64 00 40 28 11 00 21 20 60 02 12 18 00 00 2A 18 23 02 F2 FF 60 14 01 00 31 26 ?? ?? ?? 0? 00 00 00 00 1D 00 40 14 00 00 00 00 20 00 42 8E 1D 00 40 10 00 00 00 00 1C 00 BF 8F 21 10 40 02 18 00 B5 8F 14 00 B4 8F 10 00 B3 8F 0C 00 B2 8F 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 20 00 BD 27 04 00 42 8E 02 00 03 24 01 00 05 24 0B 28 62 00 18 00 A6 00 21 20 60 02 21 30 00 00 ?? ?? ?? 0? 12 28 00 00 ?? ?? ?? 0? 20 00 42 AE FF FF 03 24 00 00 42 AE ?? ?? ?? 0? 04 00 43 AE ?? ?? ?? 0? 20 00 44 8E 20 00 40 AE ?? ?? ?? 0? 21 20 40 02 ?? ?? ?? 0? 21 90 00 00 ?? ?? 02 3C ?? ?? 44 8C 0C 00 03 24 ?? ?? ?? 0? 00 00 83 AC }
	condition:
		$1
}

rule file_3_22_0 {
	meta:
		name = "destroy_datafile_index"
		size = 72
		refs = "0014 _al_free"
	strings:
		$1 = { F8 FF BD 27 00 00 B0 AF 04 00 BF AF 0A 00 80 10 21 80 80 00 ?? ?? ?? 0? 00 00 84 8C ?? ?? ?? 0? 04 00 04 8E 21 20 00 02 04 00 BF 8F 00 00 B0 8F ?? ?? ?? 0? 08 00 BD 27 04 00 BF 8F 00 00 B0 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_3_23_0 {
	meta:
		name = "_destroy_property_list"
		size = 112
		refs = "003c _al_free"
	strings:
		$1 = { 04 00 83 8C F0 FF BD 27 FF FF 02 24 08 00 B2 AF 0C 00 BF AF 04 00 B1 AF 00 00 B0 AF 0D 00 62 10 21 90 80 00 08 00 90 24 21 18 80 00 FF FF 11 24 00 00 62 8C 03 00 40 10 21 20 40 00 ?? ?? ?? 0? 00 00 00 00 04 00 02 8E 21 18 00 02 F8 FF 51 14 08 00 10 26 21 20 40 02 0C 00 BF 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F ?? ?? ?? 0? 10 00 BD 27 }
	condition:
		$1
}

rule file_3_24_0 {
	meta:
		name = "_unload_datafile_object"
		size = 172
		refs = "0018 _destroy_property_list 0020 _datafile_type 0064 _al_free"
	strings:
		$1 = { F8 FF BD 27 00 00 B0 AF 21 80 80 00 0C 00 84 8C 03 00 80 10 04 00 BF AF ?? ?? ?? 0? 00 00 00 00 ?? ?? 02 3C 04 00 04 8E ?? ?? 47 24 21 18 E0 00 21 28 00 00 20 00 06 24 00 00 62 8C 0B 00 82 10 0C 00 63 24 01 00 A5 24 FC FF A6 54 00 00 62 8C 00 00 04 8E 12 00 80 10 04 00 BF 8F 04 00 BF 8F 00 00 B0 8F ?? ?? ?? 0? 08 00 BD 27 00 00 04 8E 0A 00 80 10 0C 00 02 24 18 00 A2 00 12 10 00 00 21 10 E2 00 08 00 59 8C F4 FF 20 13 04 00 BF 8F 00 00 B0 8F 08 00 20 03 08 00 BD 27 04 00 BF 8F 00 00 B0 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_3_25_0 {
	meta:
		name = "unload_datafile_object"
		size = 64
		refs = "0014 _unload_datafile_object 0028 _al_free"
	strings:
		$1 = { F8 FF BD 27 00 00 B0 AF 04 00 BF AF 08 00 80 10 21 80 80 00 ?? ?? ?? 0? 00 00 00 00 21 20 00 02 04 00 BF 8F 00 00 B0 8F ?? ?? ?? 0? 08 00 BD 27 04 00 BF 8F 00 00 B0 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_13_173_9 {
	meta:
		name = "CalCoreModel_Delete"
		size = 64
		refs = "0014 _ZN12CalCoreModelD1Ev 0028 _ZdlPv"
	strings:
		$1 = { F8 FF BD 27 00 00 B0 AF 04 00 BF AF 08 00 80 10 21 80 80 00 ?? ?? ?? 0? 00 00 00 00 21 20 00 02 04 00 BF 8F 00 00 B0 8F ?? ?? ?? 0? 08 00 BD 27 04 00 BF 8F 00 00 B0 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_13_153_9 {
	meta:
		name = "CalCoreSubmesh_Delete"
		size = 64
		refs = "0014 _ZN14CalCoreSubmeshD1Ev 0028 _ZdlPv"
	strings:
		$1 = { F8 FF BD 27 00 00 B0 AF 04 00 BF AF 08 00 80 10 21 80 80 00 ?? ?? ?? 0? 00 00 00 00 21 20 00 02 04 00 BF 8F 00 00 B0 8F ?? ?? ?? 0? 08 00 BD 27 04 00 BF 8F 00 00 B0 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_13_136_9 {
	meta:
		name = "CalMesh_Delete"
		size = 64
		refs = "0014 _ZN7CalMeshD1Ev 0028 _ZdlPv"
	strings:
		$1 = { F8 FF BD 27 00 00 B0 AF 04 00 BF AF 08 00 80 10 21 80 80 00 ?? ?? ?? 0? 00 00 00 00 21 20 00 02 04 00 BF 8F 00 00 B0 8F ?? ?? ?? 0? 08 00 BD 27 04 00 BF 8F 00 00 B0 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_13_117_9 {
	meta:
		name = "CalModel_Delete"
		size = 64
		refs = "0014 _ZN8CalModelD1Ev 0028 _ZdlPv"
	strings:
		$1 = { F8 FF BD 27 00 00 B0 AF 04 00 BF AF 08 00 80 10 21 80 80 00 ?? ?? ?? 0? 00 00 00 00 21 20 00 02 04 00 BF 8F 00 00 B0 8F ?? ?? ?? 0? 08 00 BD 27 04 00 BF 8F 00 00 B0 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_13_69_9 {
	meta:
		name = "CalSkeleton_Delete"
		size = 64
		refs = "0014 _ZN11CalSkeletonD1Ev 0028 _ZdlPv"
	strings:
		$1 = { F8 FF BD 27 00 00 B0 AF 04 00 BF AF 08 00 80 10 21 80 80 00 ?? ?? ?? 0? 00 00 00 00 21 20 00 02 04 00 BF 8F 00 00 B0 8F ?? ?? ?? 0? 08 00 BD 27 04 00 BF 8F 00 00 B0 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_23_8_30 {
	meta:
		name = "MikMod_FreeSong"
		size = 64
		refs = "0014 Player_Exit 0028 .text"
	strings:
		$1 = { F8 FF BD 27 00 00 B0 AF 04 00 BF AF 08 00 80 10 21 80 80 00 ?? ?? ?? 0? 00 00 00 00 21 20 00 02 04 00 BF 8F 00 00 B0 8F ?? ?? ?? 0? 08 00 BD 27 04 00 BF 8F 00 00 B0 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_43_26_119 {
	meta:
		name = "sqlite3SelectDelete"
		size = 64
		refs = "0014 .text 0028 sqlite3FreeX"
	strings:
		$1 = { F8 FF BD 27 00 00 B0 AF 04 00 BF AF 08 00 80 10 21 80 80 00 ?? ?? ?? 0? 00 00 00 00 21 20 00 02 04 00 BF 8F 00 00 B0 8F ?? ?? ?? 0? 08 00 BD 27 04 00 BF 8F 00 00 B0 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_3_26_0 {
	meta:
		name = "read_font_fixed"
		size = 352
		refs = "015c allegro_errno 0038 _al_malloc 0070 font_vtable_mono 00a0 memset 00b4 .text 00c4 pack_fread 00f4 destroy_font 0140 _al_free"
	strings:
		$1 = { D8 FF BD 27 20 00 B7 AF 21 B8 80 00 0C 00 04 24 24 00 BF AF 18 00 B5 AF 14 00 B4 AF 10 00 B3 AF 21 A0 C0 00 80 98 06 00 0C 00 B2 AF 08 00 B1 AF 21 90 A0 00 04 00 B0 AF ?? ?? ?? 0? 1C 00 B6 AF 10 00 04 24 ?? ?? ?? 0? 21 A8 40 00 21 20 60 02 ?? ?? ?? 0? 21 80 40 00 39 00 A0 12 21 88 40 00 37 00 00 12 00 00 00 00 35 00 40 10 21 30 60 02 ?? ?? 02 3C ?? ?? 43 8C 20 00 84 26 20 00 02 24 04 00 B2 AE 08 00 A3 AE 04 00 04 AE 08 00 11 AE 00 00 02 AE 00 00 B0 AE 0C 00 00 AE 21 20 20 02 ?? ?? ?? 0? 21 28 00 00 19 00 80 1A 04 00 53 26 21 80 00 00 ?? ?? ?? 0? 08 00 16 24 00 00 22 AE 00 00 56 A4 ?? ?? ?? 0? 02 00 52 A4 2A 18 14 02 0F 00 60 10 04 00 31 26 ?? ?? ?? 0? 21 20 60 02 01 00 10 26 04 00 44 24 21 28 40 02 F3 FF 40 14 21 30 E0 02 ?? ?? ?? 0? 21 20 A0 02 ?? ?? 02 3C ?? ?? 43 8C 0C 00 02 24 21 A8 00 00 00 00 62 AC 24 00 BF 8F 21 10 A0 02 20 00 B7 8F 1C 00 B6 8F 18 00 B5 8F 14 00 B4 8F 10 00 B3 8F 0C 00 B2 8F 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 28 00 BD 27 ?? ?? ?? 0? 21 20 A0 02 ?? ?? ?? 0? 21 20 00 02 ?? ?? ?? 0? 21 20 20 02 ?? ?? ?? 0? ?? ?? 02 3C }
	condition:
		$1
}

rule file_3_27_0 {
	meta:
		name = "read_font_prop"
		size = 524
		refs = "0030 _al_malloc 0068 font_vtable_color 0094 memset 00a8 .text 00d4 pack_feof 0100 clear_bitmap 011c create_bitmap_ex 0138 destroy_font 0140 allegro_errno 0180 _al_free"
	strings:
		$1 = { E0 FF BD 27 10 00 B4 AF 0C 00 B3 AF 21 A0 80 00 21 98 A0 00 0C 00 04 24 1C 00 BF AF 18 00 B6 AF 14 00 B5 AF 04 00 B1 AF 00 00 B0 AF 08 00 B2 AF ?? ?? ?? 0? 80 88 13 00 10 00 04 24 ?? ?? ?? 0? 21 A8 40 00 21 20 20 02 ?? ?? ?? 0? 21 80 40 00 4B 00 A0 12 21 B0 40 00 49 00 00 12 00 00 00 00 47 00 40 10 21 30 20 02 ?? ?? 02 3C ?? ?? 43 8C 20 00 64 26 20 00 02 24 04 00 04 AE 08 00 A3 AE 00 00 02 AE 08 00 16 AE 00 00 B0 AE 0C 00 00 AE 21 20 C0 02 ?? ?? ?? 0? 21 28 00 00 40 00 60 1A 21 88 C0 02 21 80 00 00 ?? ?? ?? 0? 21 90 00 00 ?? ?? ?? 0? 01 00 10 26 00 00 22 AE 2A 18 13 02 44 00 40 10 04 00 31 26 04 00 42 8C 35 00 60 10 2C 90 42 02 ?? ?? ?? 0? 21 20 80 02 21 20 80 02 08 00 05 24 F2 FF 40 10 21 30 00 00 2A 10 13 02 2C 00 40 10 80 10 10 00 ?? ?? ?? 0? 21 88 C2 02 ?? ?? ?? 0? 00 00 00 00 2A 10 13 02 26 00 40 10 1C 00 BF 8F 08 00 04 24 08 00 05 24 ?? ?? ?? 0? 21 30 40 02 00 00 22 AE 01 00 10 26 21 20 40 00 F3 FF 40 14 04 00 31 26 ?? ?? ?? 0? 21 20 A0 02 ?? ?? 02 3C ?? ?? 43 8C 1C 00 BF 8F 21 A8 00 00 0C 00 02 24 00 00 62 AC 18 00 B6 8F 21 10 A0 02 14 00 B5 8F 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 20 00 BD 27 ?? ?? ?? 0? 21 20 A0 02 ?? ?? ?? 0? 21 20 00 02 ?? ?? ?? 0? 21 20 C0 02 ?? ?? ?? 0? ?? ?? 02 3C 21 90 00 00 1C 00 BF 8F 04 00 B2 AE 21 10 A0 02 18 00 B6 8F 14 00 B5 8F 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 20 00 BD 27 ?? ?? ?? 0? 21 20 A0 02 1C 00 BF 8F 21 A8 00 00 21 10 A0 02 18 00 B6 8F 14 00 B5 8F 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_3_28_0 {
	meta:
		name = "load_object"
		size = 248
		refs = "0024 pack_fopen_chunk 0058 _datafile_type 0068 .text 00ac pack_fclose_chunk"
	strings:
		$1 = { E8 FF BD 27 0C 00 B2 AF 21 90 80 00 21 20 A0 00 21 28 00 00 08 00 B1 AF 04 00 B0 AF 14 00 BF AF 10 00 B3 AF ?? ?? ?? 0? 21 88 C0 00 09 00 40 14 21 80 40 00 14 00 BF 8F FF FF 02 24 10 00 B3 8F 0C 00 B2 8F 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 18 00 BD 27 1C 00 53 8C ?? ?? 02 3C ?? ?? 46 24 21 18 C0 00 21 20 00 00 ?? ?? ?? 0? 20 00 05 24 01 00 84 24 1B 00 85 50 21 20 00 02 00 00 62 8C FB FF 51 14 0C 00 63 24 0C 00 02 24 18 00 82 00 21 28 60 02 12 10 00 00 21 10 C2 00 04 00 43 8C 09 F8 60 00 21 20 00 02 00 00 42 AE ?? ?? ?? 0? 21 20 00 02 00 00 43 8E DE FF 60 10 14 00 BF 8F 08 00 53 AE 04 00 51 AE 21 10 00 00 10 00 B3 8F 0C 00 B2 8F 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 18 00 BD 27 21 28 60 02 ?? ?? ?? 0? 21 30 00 00 ?? ?? ?? 0? 00 00 42 AE }
	condition:
		$1
}

rule file_3_29_0 {
	meta:
		name = "fixup_datafile"
		size = 2216
		refs = "0000 .bss 0048 _rgb_scale_5 0058 .text 00c4 _color_depth 0134 makecol_depth 0318 _rgb_g_shift_24 0314 _rgb_b_shift_24 0320 _rgb_r_shift_24 0360 _rgb_g_shift_32 0364 _rgb_b_shift_32 02ec _rgb_r_shift_32 02f0 _rgb_a_shift_32 05ec _rgb_scale_6 074c _color_conv 0878 _get_vtable"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 43 8C C8 FF BD 27 10 00 B0 AF 34 00 BF AF 30 00 BE AF 2C 00 B7 AF 28 00 B6 AF 24 00 B5 AF 20 00 B4 AF 1C 00 B3 AF 18 00 B2 AF 14 00 B1 AF FA 01 60 10 21 80 80 00 04 00 04 8E FF FF 02 24 4E 00 82 10 ?? ?? 02 3C ?? ?? 55 24 10 00 02 26 04 00 A2 AF ?? ?? ?? 0? ?? ?? 1E 3C 20 45 42 34 52 00 82 50 00 00 10 8E 04 00 AC 8F FF FF 02 24 04 00 84 8D 21 80 80 01 10 00 8C 25 3F 00 82 10 04 00 AC AF 4D 42 02 3C 20 50 42 34 F3 FF 82 14 4C 52 02 3C 00 00 12 8E 10 00 04 24 1C 00 42 8E 00 00 43 8C 9D 01 64 10 11 00 62 28 CA 00 40 10 18 00 02 24 0F 00 02 24 EC FF 62 54 04 00 AC 8F ?? ?? 02 3C ?? ?? 43 8C F0 01 64 10 00 00 00 00 0F 00 13 24 04 00 44 8E E3 FF 80 18 21 B0 40 02 00 00 43 8E 21 A0 00 00 19 00 60 18 40 00 C2 8E 21 80 40 00 21 88 00 00 00 00 02 96 21 20 60 02 01 00 31 26 80 22 48 7C 1F 00 43 30 40 21 42 7C 80 18 03 00 80 10 02 00 80 40 08 00 21 18 A3 02 21 10 A2 02 21 40 A8 02 00 00 65 8C 00 00 46 8C ?? ?? ?? 0? 00 00 07 8D 00 00 43 8E 00 00 02 A6 2A 10 23 02 EC FF 40 14 02 00 10 26 04 00 44 8E 01 00 94 26 2A 10 84 02 E3 FF 40 14 04 00 D6 26 04 00 AC 8F FF FF 02 24 04 00 84 8D 21 80 80 01 10 00 8C 25 C3 FF 82 14 04 00 AC AF 34 00 BF 8F 30 00 BE 8F 2C 00 B7 8F 28 00 B6 8F 24 00 B5 8F 20 00 B4 8F 1C 00 B3 8F 18 00 B2 8F 14 00 B1 8F 10 00 B0 8F 08 00 E0 03 38 00 BD 27 10 00 04 24 08 00 03 8E F7 00 64 10 0C 00 B0 AF 11 00 62 28 38 00 40 50 18 00 04 24 0F 00 02 24 A7 FF 62 14 04 00 AC 8F ?? ?? 02 3C ?? ?? 42 8C 9F 01 44 10 1F 7C 04 24 0F 00 13 24 08 00 A4 AF 0C 00 A7 8F 04 00 E2 8C 9C FF 40 18 10 00 E3 24 21 B0 00 00 1F 7C 17 24 00 00 72 84 1E 00 57 12 0C 00 AC 8F 22 00 40 1A 02 00 74 24 21 80 80 02 21 88 00 00 00 00 02 86 01 00 31 26 21 20 60 02 80 22 48 7C 1F 00 43 30 40 21 42 7C 80 18 03 00 80 10 02 00 80 40 08 00 21 18 A3 02 21 10 A2 02 21 40 A8 02 00 00 65 8C 00 00 46 8C ?? ?? ?? 0? 00 00 07 8D 23 18 51 02 00 00 02 A6 ED FF 60 1C 02 00 10 26 40 10 12 00 21 18 82 02 00 00 72 84 E4 FF 57 16 0C 00 AC 8F 08 00 A4 8F 01 00 D6 26 04 00 82 8D 2A 10 C2 02 74 FF 40 10 00 00 64 A4 ?? ?? ?? 0? 02 00 63 24 F2 00 64 10 20 00 02 24 6F FF 62 14 04 00 AC 8F ?? ?? 02 3C ?? ?? 42 8C 64 01 44 10 0C 00 A5 8F 20 00 0D 24 0C 00 A6 8F 04 00 C2 8C 65 FF 40 18 FF 00 02 3C FF 00 52 34 10 00 C3 24 21 98 00 00 20 00 0E 24 ?? ?? 11 3C ?? ?? 10 3C 00 00 6C 8C 30 00 92 11 0C 00 A7 8F 34 00 80 19 04 00 6F 24 21 38 E0 01 ?? ?? ?? 0? 21 40 00 00 ?? ?? 05 3C ?? ?? C2 8F ?? ?? A3 8C ?? ?? 06 3C ?? ?? C4 8C 04 10 49 00 04 18 6A 00 25 10 43 00 04 20 8B 00 25 10 44 00 01 00 08 25 00 00 E2 AC 18 00 0C 11 04 00 E7 24 00 00 E6 8C FF 00 CB 30 00 3A C9 7C EE FF AE 15 00 3C CA 7C ?? ?? 02 3C ?? ?? 04 3C ?? ?? 43 8C ?? ?? 82 8C ?? ?? 24 8E ?? ?? 05 8E 04 10 4A 00 04 18 69 00 25 18 62 00 04 20 8B 00 02 16 06 00 25 18 64 00 04 10 A2 00 25 18 62 00 01 00 08 25 00 00 E3 AC EA FF 0C 15 04 00 E7 24 80 10 08 00 21 18 E2 01 00 00 6C 8C D2 FF 92 15 0C 00 A7 8F 00 00 72 AC 01 00 73 26 04 00 E2 8C 2A 10 62 02 28 FF 40 10 04 00 AC 8F ?? ?? ?? 0? 04 00 63 24 2D 00 62 10 20 00 02 24 22 FF 62 14 04 00 AC 8F 04 00 44 8E 1E FF 80 18 21 60 40 02 00 00 43 8E 21 58 00 00 ?? ?? 0E 3C ?? ?? 0D 3C 1C 00 60 18 40 00 85 8D 21 48 A0 00 21 50 00 00 00 00 25 8D ?? ?? C4 8D ?? ?? A6 8D ?? ?? 02 3C ?? ?? 47 8C ?? ?? 03 3C ?? ?? 68 8C 02 16 05 00 FF 00 A3 30 04 10 82 00 04 18 C3 00 00 3A A4 7C 25 10 43 00 04 20 E4 00 00 3C A5 7C 25 10 44 00 04 28 05 01 25 10 45 00 00 00 22 AD 00 00 43 8E 01 00 4A 25 2A 10 43 01 E9 FF 40 14 04 00 29 25 04 00 44 8E 01 00 6B 25 2A 10 64 01 E0 FF 40 14 04 00 8C 25 ?? ?? ?? 0? 04 00 AC 8F 04 00 44 8E F4 FE 80 18 21 58 40 02 00 00 43 8E 21 50 00 00 35 00 60 18 40 00 62 8D 21 40 40 00 21 48 00 00 01 00 04 91 02 00 02 91 00 00 06 91 00 22 04 00 00 14 02 00 25 20 82 00 ?? ?? 05 3C ?? ?? A2 8C ?? ?? C3 8F 25 20 86 00 ?? ?? 06 3C ?? ?? C5 8C 02 3C 04 00 00 3A 86 7C 04 10 47 00 FF 00 84 30 04 18 66 00 04 28 A4 00 25 18 62 00 25 18 65 00 00 00 03 A1 ?? ?? 0C 3C ?? ?? 83 8D ?? ?? C2 8F ?? ?? 0C 3C ?? ?? 85 8D 04 18 67 00 04 10 46 00 04 28 A4 00 25 10 43 00 25 10 45 00 03 12 02 00 01 00 02 A1 ?? ?? 05 3C ?? ?? A2 8C ?? ?? C3 8F ?? ?? 85 8D 04 38 47 00 04 30 66 00 25 30 C7 00 04 20 A4 00 25 30 C4 00 03 34 06 00 02 00 06 A1 00 00 43 8E 01 00 29 25 2A 10 23 01 D0 FF 40 14 03 00 08 25 04 00 44 8E 01 00 4A 25 2A 10 44 01 C7 FF 40 14 04 00 6B 25 ?? ?? ?? 0? 04 00 AC 8F ?? ?? 02 3C ?? ?? 42 8C 0F 00 03 24 A5 00 43 10 1F F8 05 34 10 00 13 24 00 00 A5 AF 0C 00 AC 8F 04 00 82 8D AB FE 40 18 10 00 83 25 21 B0 00 00 1F F8 17 24 00 00 72 84 20 00 57 12 0C 00 A6 8F 24 00 40 1A 02 00 74 24 21 80 80 02 21 88 00 00 00 00 02 86 ?? ?? 05 3C ?? ?? A5 24 C0 22 48 7C 1F 00 43 30 40 29 42 7C 80 18 03 00 80 10 02 00 80 40 08 00 21 18 A3 02 21 10 A2 00 21 40 A8 02 00 00 65 8C 00 00 46 8C 00 00 07 8D 01 00 31 26 ?? ?? ?? 0? 21 20 60 02 23 18 51 02 00 00 02 A6 EB FF 60 1C 02 00 10 26 40 10 12 00 21 18 82 02 00 00 72 84 E2 FF 57 16 0C 00 A6 8F 00 00 A7 8F 01 00 D6 26 04 00 C2 8C 2A 10 C2 02 81 FE 40 10 00 00 67 A4 ?? ?? ?? 0? 02 00 63 24 ?? ?? 02 3C ?? ?? 42 8C 20 00 03 24 6B 00 43 10 0C 00 AC 8F 18 00 13 24 0C 00 A3 8F 04 00 62 8C 75 FE 40 18 FF 00 02 3C FF 00 57 34 10 00 63 24 21 B0 00 00 00 00 72 8C 14 00 57 12 0C 00 A4 8F 18 00 40 1A 04 00 74 24 21 80 80 02 21 88 40 02 00 00 06 8E 21 20 60 02 FF FF 31 26 00 3C C7 7C FF 00 C5 30 ?? ?? ?? 0? 00 3A C6 7C 00 00 02 AE F7 FF 20 1E 04 00 10 26 80 10 12 00 21 18 82 02 00 00 72 8C EE FF 57 16 0C 00 A4 8F 00 00 77 AC 01 00 D6 26 04 00 82 8C 2A 10 C2 02 57 FE 40 10 04 00 AC 8F ?? ?? ?? 0? 04 00 63 24 ?? ?? 02 3C ?? ?? 44 8C 0F 00 03 24 52 00 83 10 00 00 00 00 10 00 13 24 04 00 44 8E 4B FE 80 18 21 B0 40 02 00 00 43 8E 21 A0 00 00 ?? ?? 17 3C 2D 00 60 18 40 00 C2 8E 21 80 40 00 ?? ?? ?? 0? 21 88 00 00 ?? ?? ?? 0? 21 30 00 01 00 00 43 8E 00 00 02 A6 2A 10 23 02 22 00 40 10 02 00 10 26 00 00 09 96 ?? ?? E6 8E ?? ?? 07 3C 1F 00 25 31 40 29 22 7D C2 1A 09 00 ?? ?? E7 24 80 28 05 00 80 10 02 00 80 18 03 00 00 04 0C 3C 21 10 E2 00 21 28 A5 02 21 18 A3 02 24 30 CC 00 21 20 60 02 01 00 31 26 00 00 48 8C 00 00 A5 8C E5 FF C0 10 00 00 67 8C 0F 00 02 24 E2 FF 62 16 08 00 03 24 3F F8 22 39 0A 40 62 00 ?? ?? ?? 0? 21 30 00 01 00 00 43 8E 00 00 02 A6 2A 10 23 02 E0 FF 40 14 02 00 10 26 04 00 44 8E 01 00 94 26 2A 10 84 02 CF FF 40 14 04 00 D6 26 ?? ?? ?? 0? 04 00 AC 8F ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 04 00 04 8E 20 00 13 24 ?? ?? ?? 0? 08 00 82 AD 0C 00 A6 8F 1F 7C 07 24 0F 00 13 24 08 00 C2 AC ?? ?? ?? 0? 00 00 A7 AF 18 00 0D 24 ?? ?? ?? 0? 08 00 A2 AC 0C 00 A5 8F 1F F8 06 34 10 00 13 24 08 00 A2 AC ?? ?? ?? 0? 08 00 A6 AF ?? ?? ?? 0? 0F 00 04 24 AC FF 40 10 0F 00 13 24 ?? ?? ?? 0? 1C 00 42 AE ?? ?? ?? 0? 10 00 04 24 0E FE 40 10 10 00 13 24 ?? ?? ?? 0? 1C 00 42 AE }
	condition:
		$1
}

rule file_3_30_0 {
	meta:
		name = "find_datafile_object"
		size = 464
		refs = "0048 .text 005c usetc 003c ugetxc 00a4 empty_string 00f4 ustricmp 01c0 find_datafile_object"
	strings:
		$1 = { D0 FD BD 27 24 02 B7 AF 1C 02 B5 AF 18 02 B4 AF 14 02 B3 AF 10 02 B2 AF 0C 02 B1 AF 08 02 B0 AF 2C 02 BF AF 28 02 BE AF 20 02 B6 AF 00 02 A5 AF 21 B8 80 00 21 80 00 00 ?? ?? 15 3C ?? ?? 14 3C 00 02 B3 27 23 00 12 24 ?? ?? ?? 0? 2F 00 11 24 0D 00 52 10 FF FF 1E 24 0B 00 51 10 ?? ?? A3 8E 09 F8 60 00 00 00 00 00 21 80 02 02 ?? ?? 83 8E 09 F8 60 00 21 20 60 02 21 28 40 00 F4 FF 40 14 21 20 B0 03 21 F0 00 00 ?? ?? A6 8E 21 20 B0 03 09 F8 C0 00 21 28 00 00 04 00 E3 8E FF FF 02 24 34 00 62 10 ?? ?? 02 3C 41 4E 03 3C ?? ?? 56 24 45 4D 73 34 10 00 F1 26 21 A0 E0 02 21 A8 00 00 10 00 12 24 FF FF 10 24 0C 00 82 8E 07 00 40 54 04 00 43 8C ?? ?? ?? 0? 21 28 C0 02 11 00 73 50 00 00 42 8C 08 00 42 24 04 00 43 8C FB FF 70 14 21 28 C0 02 ?? ?? ?? 0? 21 20 A0 03 0F 00 40 10 00 00 00 00 04 00 22 8E 21 A0 20 02 10 00 43 26 18 00 50 10 10 00 31 26 21 A8 40 02 ?? ?? ?? 0? 21 90 60 00 21 28 C0 02 21 20 A0 03 ?? ?? ?? 0? 0B 28 42 00 F4 FF 40 54 04 00 22 8E 1A 00 C0 17 2C 02 BF 8F 21 10 F5 02 28 02 BE 8F 24 02 B7 8F 20 02 B6 8F 1C 02 B5 8F 18 02 B4 8F 14 02 B3 8F 10 02 B2 8F 0C 02 B1 8F 08 02 B0 8F 08 00 E0 03 30 02 BD 27 21 10 00 00 2C 02 BF 8F 28 02 BE 8F 24 02 B7 8F 20 02 B6 8F 1C 02 B5 8F 18 02 B4 8F 14 02 B3 8F 10 02 B2 8F 0C 02 B1 8F 08 02 B0 8F 08 00 E0 03 30 02 BD 27 04 00 83 8E 49 46 02 3C 45 4C 42 34 F0 FF 62 54 21 10 00 00 00 00 84 8E ?? ?? ?? 0? 00 02 A5 8F ?? ?? ?? 0? 2C 02 BF 8F }
	condition:
		$1
}

rule file_3_31_0 {
	meta:
		name = "create_datafile_index"
		size = 492
		refs = "0000 $LC0 002c pack_fopen 007c _packfile_type 0098 pack_mgetl 00a4 _al_malloc 00b4 _al_ustrdup 00f0 .text 00f8 pack_fseek 0180 pack_fclose 0198 allegro_errno 01b4 _al_free"
	strings:
		$1 = { ?? ?? 05 3C E0 FF BD 27 ?? ?? A5 24 04 00 B1 AF 00 00 B0 AF 1C 00 BF AF 18 00 B6 AF 14 00 B5 AF 10 00 B4 AF 0C 00 B3 AF 08 00 B2 AF ?? ?? ?? 0? 21 80 80 00 0D 00 40 14 21 88 40 00 21 98 00 00 1C 00 BF 8F 21 10 60 02 18 00 B6 8F 14 00 B5 8F 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 20 00 BD 27 10 00 42 8C 04 00 03 24 44 00 42 30 39 00 43 14 ?? ?? 02 3C ?? ?? 44 8C 49 46 03 3C 45 4C 63 34 EC FF 83 14 21 98 00 00 08 00 12 24 ?? ?? ?? 0? 21 20 20 02 08 00 04 24 ?? ?? ?? 0? 21 B0 40 00 38 00 40 10 21 98 40 00 ?? ?? ?? 0? 21 20 00 02 3B 00 40 10 00 00 62 AE ?? ?? ?? 0? 80 20 16 00 41 00 40 10 04 00 62 AE 2A 00 C0 1A 72 70 02 3C 70 6F 55 34 21 A0 00 00 04 00 62 8E 80 18 14 00 21 10 43 00 ?? ?? ?? 0? 00 00 52 AC ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 21 20 20 02 21 28 40 00 21 20 20 02 ?? ?? ?? 0? 21 80 40 00 0C 00 43 26 21 90 70 00 ?? ?? ?? 0? 21 20 20 02 04 00 05 24 F2 FF 55 10 21 20 20 02 ?? ?? ?? 0? 01 00 94 26 04 00 50 24 21 20 20 02 ?? ?? ?? 0? 21 28 00 02 2A 18 96 02 0B 00 60 10 08 00 42 26 ?? ?? ?? 0? 21 90 50 00 ?? ?? ?? 0? 21 20 20 02 4C 41 03 3C 2E 4C 63 34 B3 FF 43 14 21 98 00 00 ?? ?? ?? 0? 0C 00 12 24 ?? ?? ?? 0? 21 20 20 02 ?? ?? ?? 0? 1C 00 BF 8F ?? ?? ?? 0? 21 20 20 02 ?? ?? 03 3C ?? ?? 64 8C 0C 00 02 24 ?? ?? ?? 0? 00 00 82 AC ?? ?? ?? 0? 21 20 20 02 ?? ?? ?? 0? 21 20 60 02 ?? ?? 02 3C ?? ?? 43 8C 0C 00 02 24 21 98 00 00 ?? ?? ?? 0? 00 00 62 AC ?? ?? ?? 0? 21 20 20 02 ?? ?? ?? 0? 00 00 64 8E ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_3_32_0 {
	meta:
		name = "_add_property"
		size = 220
		refs = "0054 _al_sane_realloc 00bc .text 00c4 allegro_errno"
	strings:
		$1 = { F0 FF BD 27 04 00 B1 AF 21 88 80 00 00 00 84 8C 08 00 B2 AF 0C 00 BF AF 00 00 B0 AF 26 00 80 10 21 90 A0 00 04 00 83 8C FF FF 02 24 22 00 62 10 21 18 80 00 21 80 00 00 FF FF 05 24 08 00 63 24 04 00 62 8C FD FF 45 14 01 00 10 26 02 00 02 26 C0 28 02 00 ?? ?? ?? 0? 00 00 00 00 21 30 40 00 18 00 40 10 00 00 22 AE 04 00 43 8E 00 00 45 8E 01 00 04 26 C0 10 10 00 21 10 C2 00 C0 20 04 00 21 20 C4 00 04 00 43 AC FF FF 03 24 00 00 45 AC 04 00 83 AC 00 00 80 AC 21 20 00 00 0C 00 BF 8F 21 10 80 00 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 10 00 BD 27 21 80 00 00 ?? ?? ?? 0? 10 00 05 24 ?? ?? 02 3C ?? ?? 43 8C 0C 00 02 24 FF FF 04 24 ?? ?? ?? 0? 00 00 62 AC }
	condition:
		$1
}

rule file_3_33_0 {
	meta:
		name = "_load_property"
		size = 312
		refs = "0024 pack_mgetl 0040 _al_malloc 0058 pack_fread 007c need_uconvert 00b8 uconvert_size 00e4 do_uconvert 00ec _al_free 00f4 .text 00fc allegro_errno 0110 pack_fseek"
	strings:
		$1 = { E8 FF BD 27 08 00 B2 AF 04 00 B1 AF 21 90 A0 00 21 88 80 00 21 20 A0 00 14 00 BF AF 0C 00 B3 AF 00 00 B0 AF ?? ?? ?? 0? 10 00 B4 AF 21 20 40 02 ?? ?? ?? 0? 21 80 40 00 01 00 44 24 04 00 30 AE ?? ?? ?? 0? 21 98 40 00 2C 00 40 10 00 00 22 AE 21 30 40 02 21 20 40 00 ?? ?? ?? 0? 21 28 60 02 00 00 23 8E 54 55 12 3C 75 63 14 3C 21 18 73 00 00 00 60 A0 00 00 24 8E 38 46 45 36 ?? ?? ?? 0? 2E 72 86 36 0B 00 40 54 00 00 24 8E 21 20 00 00 14 00 BF 8F 21 10 80 00 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 18 00 BD 27 38 46 45 36 ?? ?? ?? 0? 2E 72 86 36 21 20 40 00 ?? ?? ?? 0? 21 98 40 00 14 00 40 10 21 80 40 00 00 00 24 8E 38 46 45 36 2E 72 87 36 21 40 60 02 ?? ?? ?? 0? 21 30 40 00 ?? ?? ?? 0? 00 00 24 8E ?? ?? ?? 0? 00 00 30 AE ?? ?? 02 3C ?? ?? 43 8C 0C 00 02 24 21 20 40 02 00 00 62 AC ?? ?? ?? 0? 21 28 60 02 ?? ?? ?? 0? FF FF 04 24 ?? ?? 02 3C ?? ?? 43 8C 0C 00 02 24 FF FF 04 24 ?? ?? ?? 0? 00 00 62 AC }
	condition:
		$1
}

rule file_3_34_0 {
	meta:
		name = "load_datafile_callback"
		size = 1144
		refs = "000c $LC0 0034 pack_fopen 0054 _packfile_type 0080 pack_fclose 00bc pack_mgetl 00f4 .text 0078 .bss 0108 pack_mgetw 0120 _al_malloc 0164 allegro_errno 0174 .rodata 042c unload_datafile"
	strings:
		$1 = { D8 FF BD 27 14 00 B5 AF 21 A8 A0 00 ?? ?? 05 3C ?? ?? A5 24 04 00 B1 AF 24 00 BF AF 20 00 BE AF 1C 00 B7 AF 18 00 B6 AF 10 00 B4 AF 0C 00 B3 AF 08 00 B2 AF ?? ?? ?? 0? 00 00 B0 AF E9 00 40 10 21 88 40 00 10 00 42 8C 04 00 03 24 44 00 42 30 1A 00 43 14 ?? ?? 02 3C ?? ?? 44 8C 49 46 03 3C 45 4C 63 34 DD 00 83 10 4C 41 02 3C 21 18 00 00 2E 4C 42 34 1D 00 62 10 ?? ?? 10 3C 21 A0 00 00 ?? ?? ?? 0? 21 20 20 02 24 00 BF 8F 21 10 80 02 20 00 BE 8F 1C 00 B7 8F 18 00 B6 8F 14 00 B5 8F 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 28 00 BD 27 ?? ?? ?? 0? 21 20 20 02 21 18 40 00 6C 61 02 3C 2E 6C 42 34 0D 00 62 10 00 00 00 00 4C 41 02 3C 2E 4C 42 34 E7 FF 62 54 21 A0 00 00 ?? ?? 10 3C 21 20 20 02 21 28 00 00 ?? ?? ?? 0? ?? ?? 15 AE 21 A0 40 00 ?? ?? ?? 0? ?? ?? 00 AE ?? ?? ?? 0? 21 20 20 02 21 98 40 00 FF FF 02 24 C6 00 62 12 01 00 64 26 ?? ?? ?? 0? 00 21 04 00 CC 00 40 10 21 A0 40 00 C4 00 60 06 21 80 40 00 21 18 40 00 21 20 00 00 FF FF 05 24 01 00 84 24 2A 10 64 02 04 00 65 AC 00 00 60 AC 08 00 60 AC 0C 00 60 AC F9 FF 40 10 10 00 63 24 ?? ?? 16 3C ?? ?? C2 8E C4 FF 60 1A 00 00 40 AC ?? ?? 03 3C ?? ?? 7E 24 21 20 20 02 4D 42 03 3C ?? ?? ?? 0? 20 50 77 34 21 18 40 00 12 00 42 2C 1E 00 40 14 21 90 00 00 41 44 02 3C 41 54 42 34 21 20 20 02 ?? ?? ?? 0? 04 00 02 AE 08 00 02 AE 21 28 40 00 21 20 20 02 ?? ?? ?? 0? 21 30 00 00 00 00 02 AE ?? ?? C2 8E 00 00 43 8C 92 00 60 14 00 11 12 00 04 00 A0 52 01 00 52 26 09 F8 A0 02 21 20 00 02 01 00 52 26 2A 10 53 02 A3 FF 40 10 10 00 10 26 ?? ?? ?? 0? 21 20 20 02 21 18 40 00 12 00 42 2C E5 FF 40 10 41 44 02 3C 80 10 03 00 21 10 C2 03 00 00 43 8C 08 00 60 00 00 00 00 00 43 58 02 3C 50 4D 42 34 04 00 02 AE 21 20 20 02 FF FF 05 24 ?? ?? ?? 0? 08 00 06 24 00 00 02 AE ?? ?? ?? 0? 08 00 00 AE 4D 43 02 3C 20 50 42 34 04 00 02 AE 21 20 20 02 21 28 00 00 ?? ?? ?? 0? 08 00 06 24 00 00 02 AE ?? ?? ?? 0? 08 00 00 AE 4C 46 02 3C ?? ?? ?? 0? 43 49 42 34 4C 52 02 3C 20 45 42 34 04 00 02 AE 21 20 20 02 ?? ?? ?? 0? 08 00 05 24 00 00 02 AE ?? ?? ?? 0? 08 00 00 AE 49 4D 02 3C 49 44 42 34 04 00 02 AE ?? ?? ?? 0? 21 20 20 02 00 00 02 AE ?? ?? ?? 0? 08 00 00 AE 41 53 02 3C 50 4D 42 34 04 00 02 AE ?? ?? ?? 0? 21 20 20 02 00 00 02 AE ?? ?? ?? 0? 08 00 00 AE 4F 46 02 3C 54 4E 42 34 04 00 02 AE 21 20 20 02 ?? ?? ?? 0? 5F 00 05 24 00 00 02 AE ?? ?? ?? 0? 08 00 00 AE 41 50 02 3C 20 4C 42 34 04 00 02 AE 21 20 20 02 ?? ?? ?? 0? 00 01 05 24 00 00 02 AE 00 04 02 24 ?? ?? ?? 0? 08 00 02 AE 41 50 02 3C 20 4C 42 34 04 00 02 AE 21 20 20 02 ?? ?? ?? 0? 10 00 05 24 00 00 02 AE ?? ?? ?? 0? 08 00 00 AE 04 00 17 AE ?? ?? ?? 0? 21 20 20 02 21 20 20 02 08 00 05 24 ?? ?? ?? 0? FF FF 06 24 00 00 02 AE ?? ?? ?? 0? 08 00 00 AE 04 00 17 AE ?? ?? ?? 0? 21 20 20 02 21 20 20 02 04 00 05 24 ?? ?? ?? 0? 21 30 00 00 00 00 02 AE ?? ?? ?? 0? 08 00 00 AE ?? ?? ?? 0? 04 00 17 AE ?? ?? ?? 0? 04 00 17 AE 4F 46 02 3C 54 4E 42 34 04 00 02 AE 21 20 20 02 08 00 05 24 ?? ?? ?? 0? 5F 00 06 24 00 00 02 AE ?? ?? ?? 0? 08 00 00 AE ?? ?? ?? 0? 2E 4C 43 34 24 00 BF 8F 21 A0 00 00 21 10 80 02 20 00 BE 8F 1C 00 B7 8F 18 00 B6 8F 14 00 B5 8F 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 28 00 BD 27 21 20 82 02 00 00 83 8C 0B 00 60 10 FF FF 02 24 ?? ?? ?? 0? 21 20 80 02 ?? ?? ?? 0? 21 20 20 02 ?? ?? ?? 0? 21 A0 00 00 ?? ?? 02 3C ?? ?? 43 8C ?? ?? ?? 0? 00 00 60 AC ?? ?? ?? 0? 04 00 82 AC ?? ?? ?? 0? 21 20 20 02 ?? ?? 03 3C ?? ?? 64 8C 0C 00 02 24 ?? ?? ?? 0? 00 00 82 AC }
	condition:
		$1
}

rule file_3_36_0 {
	meta:
		name = "load_datafile_object_indexed"
		size = 356
		refs = "0018 $LC0 0030 pack_fopen 0040 _al_malloc 0068 pack_fseek 0078 pack_mgetl 0090 _load_property 00a4 _add_property 00bc .text 00d0 pack_fclose 012c _al_free 0138 _destroy_property_list 0150 allegro_errno"
	strings:
		$1 = { D8 FF BD 27 14 00 B1 AF 21 88 80 00 00 00 84 8C 1C 00 B3 AF 21 98 A0 00 ?? ?? 05 3C ?? ?? A5 24 10 00 B0 AF 24 00 BF AF 20 00 B4 AF 18 00 B2 AF ?? ?? ?? 0? 00 00 A0 AF 30 00 40 10 21 80 40 00 ?? ?? ?? 0? 10 00 04 24 3F 00 40 10 21 90 40 00 04 00 22 8E 80 18 13 00 21 20 00 02 21 10 43 00 00 00 45 8C 04 00 B3 27 ?? ?? ?? 0? FC FF A5 24 72 70 03 3C 70 6F 74 34 ?? ?? ?? 0? 21 20 00 02 21 88 40 00 21 20 60 02 0A 00 54 14 21 28 00 02 ?? ?? ?? 0? 00 00 00 00 21 20 A0 03 05 00 40 14 21 28 60 02 ?? ?? ?? 0? 00 00 00 00 F2 FF 40 10 00 00 00 00 21 30 20 02 21 20 40 02 ?? ?? ?? 0? 21 28 00 02 17 00 40 14 00 00 A2 8F 21 20 00 02 ?? ?? ?? 0? 0C 00 42 AE 24 00 BF 8F 21 10 40 02 20 00 B4 8F 1C 00 B3 8F 18 00 B2 8F 14 00 B1 8F 10 00 B0 8F 08 00 E0 03 28 00 BD 27 24 00 BF 8F 21 90 00 00 21 10 40 02 20 00 B4 8F 1C 00 B3 8F 18 00 B2 8F 14 00 B1 8F 10 00 B0 8F 08 00 E0 03 28 00 BD 27 ?? ?? ?? 0? 21 20 00 02 ?? ?? ?? 0? 21 20 40 02 00 00 A4 8F ?? ?? ?? 0? 21 90 00 00 ?? ?? ?? 0? 24 00 BF 8F ?? ?? ?? 0? 21 20 00 02 ?? ?? 03 3C ?? ?? 64 8C 0C 00 02 24 ?? ?? ?? 0? 00 00 82 AC }
	condition:
		$1
}

rule file_3_37_0 {
	meta:
		name = "load_datafile_object"
		size = 916
		refs = "0120 $LC0 004c ustrzcpy 0054 $LC1 0064 uconvert 0070 ustrcmp 008c ustrzcat 0090 ugetx 00e8 uwidth 010c usetc 0128 pack_fopen 014c pack_mgetl 0190 .text 01ac pack_fseek 01c0 _destroy_property_list 01f0 _load_property 0204 _add_property 0220 ustricmp 024c pack_fclose 0148 _packfile_type 0310 _al_malloc 0344 _al_free 0378 allegro_errno"
	strings:
		$1 = { C0 F7 BD 27 34 08 B7 AF 18 00 B7 27 21 30 80 00 28 08 B4 AF 24 08 B3 AF 20 08 B2 AF 1C 08 B1 AF 18 08 B0 AF 21 20 E0 02 21 90 A0 00 10 00 B3 27 00 04 05 24 ?? ?? 14 3C 53 41 10 3C 75 63 11 3C 3C 08 BF AF 38 08 BE AF 30 08 B6 AF ?? ?? ?? 0? 2C 08 B5 AF ?? ?? 84 26 38 43 05 36 21 30 60 02 2E 72 27 36 ?? ?? ?? 0? 08 00 08 24 21 28 40 00 ?? ?? ?? 0? 21 20 E0 02 9A 00 40 14 38 43 05 36 21 30 40 02 21 20 E0 02 00 04 05 24 ?? ?? ?? 0? ?? ?? 15 3C ?? ?? A3 8E 04 00 B3 27 04 00 B7 AF 09 F8 60 00 21 20 60 02 21 80 E0 02 21 88 00 00 23 00 14 24 2F 00 16 24 0B 00 40 10 21 90 40 00 71 00 54 52 21 88 00 02 6F 00 56 52 21 88 00 02 04 00 B0 8F ?? ?? A3 8E 09 F8 60 00 21 20 60 02 F7 FF 40 14 21 90 40 00 ?? ?? 10 3C ?? ?? 03 8E 09 F8 60 00 21 20 20 02 21 30 22 02 18 04 A4 27 ?? ?? ?? 0? 00 04 05 24 92 00 37 12 ?? ?? 02 3C ?? ?? 43 8C 21 20 20 02 09 F8 60 00 21 28 00 00 ?? ?? 05 3C 21 20 E0 02 ?? ?? ?? 0? ?? ?? A5 24 5E 00 40 10 21 88 40 00 10 00 42 8C 04 00 03 24 44 00 42 30 52 00 43 10 ?? ?? 02 3C ?? ?? ?? 0? 21 20 20 02 4C 41 03 3C 2E 4C 63 34 51 00 43 14 00 00 00 00 ?? ?? ?? 0? 21 20 20 02 21 A0 40 00 86 00 40 18 00 00 A0 AF 72 70 02 3C 41 4E 03 3C 70 6F 55 34 45 4D 77 34 21 98 00 00 08 00 B6 27 ?? ?? ?? 0? FF FF 1E 24 5D 00 60 16 00 00 00 00 ?? ?? ?? 0? 01 00 52 26 04 00 45 24 ?? ?? ?? 0? 21 20 20 02 00 00 A3 8F 04 00 60 10 21 20 60 00 ?? ?? ?? 0? 00 00 00 00 00 00 A0 AF 2A 10 54 02 1A 00 40 10 00 00 A4 8F ?? ?? ?? 0? 21 20 20 02 21 80 40 00 EC FF 55 14 21 20 20 02 21 20 C0 02 ?? ?? ?? 0? 21 28 20 02 21 20 A0 03 0E 00 40 14 21 28 C0 02 ?? ?? ?? 0? 00 00 00 00 0A 00 40 14 0C 00 A2 8F EE FF 57 14 2A 10 54 02 08 00 A4 8F ?? ?? ?? 0? 18 04 A5 27 0A 98 C2 03 2A 10 54 02 E9 FF 40 14 00 00 00 00 00 00 A4 8F 03 00 80 10 21 90 00 00 ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 21 20 20 02 3C 08 BF 8F 21 10 40 02 38 08 BE 8F 34 08 B7 8F 30 08 B6 8F 2C 08 B5 8F 28 08 B4 8F 24 08 B3 8F 20 08 B2 8F 1C 08 B1 8F 18 08 B0 8F 08 00 E0 03 40 08 BD 27 ?? ?? ?? 0? 04 00 B0 8F ?? ?? 44 8C 49 46 03 3C 45 4C 63 34 B1 FF 83 10 00 00 00 00 ?? ?? ?? 0? 21 20 20 02 3C 08 BF 8F 21 90 00 00 21 10 40 02 38 08 BE 8F 34 08 B7 8F 30 08 B6 8F 2C 08 B5 8F 28 08 B4 8F 24 08 B3 8F 20 08 B2 8F 1C 08 B1 8F 18 08 B0 8F 08 00 E0 03 40 08 BD 27 21 30 60 02 ?? ?? 84 26 2E 72 27 36 ?? ?? ?? 0? 08 00 08 24 21 30 40 00 21 20 E0 02 ?? ?? ?? 0? 00 04 05 24 ?? ?? ?? 0? 21 30 40 02 ?? ?? ?? 0? 10 00 04 24 17 00 40 10 21 90 40 00 21 30 00 02 21 20 40 00 ?? ?? ?? 0? 21 28 20 02 04 00 40 14 00 00 A2 8F 0C 00 42 AE ?? ?? ?? 0? 00 00 A0 AF ?? ?? ?? 0? 21 20 40 02 ?? ?? ?? 0? 00 00 A4 8F ?? ?? 03 8E 21 20 E0 02 09 F8 60 00 ?? ?? 50 8C 21 20 E2 02 09 F8 00 02 21 28 00 00 ?? ?? ?? 0? ?? ?? 05 3C ?? ?? 02 3C ?? ?? 44 8C 0C 00 03 24 ?? ?? ?? 0? 00 00 83 AC ?? ?? ?? 0? 21 90 00 00 }
	condition:
		$1
}

rule file_4_0_0 {
	meta:
		name = "save_pcx_pf"
		size = 1152
		refs = "0040 allegro_errno 0064 pack_putc 0094 pack_iputw 00f4 _rgb_scale_6 0230 getg_depth 0338 getb_depth 0340 .text 0374 getr_depth 0470 get_palette"
	strings:
		$1 = { D0 FB BD 27 1C 04 B5 AF 18 04 B4 AF 08 04 B0 AF 2C 04 BF AF 28 04 BE AF 24 04 B7 AF 20 04 B6 AF 14 04 B3 AF 10 04 B2 AF 0C 04 B1 AF 21 80 C0 00 21 A8 80 00 0E 01 C0 10 21 A0 A0 00 1C 00 82 8E ?? ?? 04 3C ?? ?? 83 8C 00 00 57 8C 0A 00 04 24 00 00 60 AC 21 28 A0 02 08 00 E3 3A 01 00 02 24 03 00 1E 24 ?? ?? ?? 0? 0A F0 43 00 05 00 04 24 ?? ?? ?? 0? 21 28 A0 02 01 00 04 24 ?? ?? ?? 0? 21 28 A0 02 08 00 04 24 ?? ?? ?? 0? 21 28 A0 02 21 20 00 00 ?? ?? ?? 0? 21 28 A0 02 21 20 00 00 ?? ?? ?? 0? 21 28 A0 02 00 00 84 8E 21 28 A0 02 00 04 B0 AF ?? ?? ?? 0? FF FF 84 24 04 00 84 8E 21 28 A0 02 00 04 B0 8F ?? ?? ?? 0? FF FF 84 24 40 01 04 24 ?? ?? ?? 0? 21 28 A0 02 C8 00 04 24 ?? ?? ?? 0? 21 28 A0 02 21 88 00 00 10 00 12 24 00 00 02 92 ?? ?? 03 3C ?? ?? 63 24 80 10 02 00 21 10 62 00 00 00 44 8C 21 28 A0 02 ?? ?? ?? 0? 01 00 31 26 01 00 03 92 ?? ?? 04 3C ?? ?? 84 24 80 18 03 00 21 18 83 00 00 00 64 8C ?? ?? ?? 0? 21 28 A0 02 02 00 03 92 ?? ?? 02 3C ?? ?? 42 24 80 18 03 00 21 18 43 00 00 00 64 8C 21 28 A0 02 ?? ?? ?? 0? 04 00 10 26 E6 FF 32 56 00 00 02 92 21 20 00 00 ?? ?? ?? 0? 21 28 A0 02 21 20 C0 03 ?? ?? ?? 0? 21 28 A0 02 00 00 84 8E 21 28 A0 02 ?? ?? ?? 0? 21 80 00 00 01 00 04 24 ?? ?? ?? 0? 21 28 A0 02 00 00 84 8E 21 28 A0 02 ?? ?? ?? 0? 36 00 11 24 04 00 84 8E ?? ?? ?? 0? 21 28 A0 02 01 00 10 26 21 20 00 00 ?? ?? ?? 0? 21 28 A0 02 FC FF 11 56 01 00 10 26 04 00 82 8E 3F 00 40 18 08 00 02 24 21 B0 00 00 00 00 85 8E 18 00 C5 03 12 10 00 00 79 00 40 18 21 90 00 00 21 80 00 00 21 98 00 00 08 00 03 24 62 00 E3 12 2A 10 05 02 55 00 40 14 40 10 05 00 2A 10 02 02 41 00 40 10 FE FF 02 24 1C 00 82 8E 23 28 05 02 21 30 C0 02 20 00 43 8C 09 F8 60 00 21 20 80 02 21 28 40 00 ?? ?? ?? 0? 21 20 E0 02 20 8C 02 7C 0E 00 40 52 01 00 12 24 57 00 33 12 3F 00 42 2A 01 00 03 24 3D 00 43 16 C0 00 44 36 C0 00 62 32 C0 00 04 24 39 00 44 10 C0 00 44 36 21 20 60 02 ?? ?? ?? 0? 21 28 A0 02 01 00 12 24 00 00 85 8E 01 00 10 26 18 00 C5 03 12 10 00 00 2A 10 02 02 D9 FF 40 14 21 98 20 02 01 00 02 24 46 00 42 12 C0 00 44 36 ?? ?? ?? 0? 21 28 A0 02 21 20 20 02 ?? ?? ?? 0? 21 28 A0 02 04 00 83 8E 01 00 D6 26 2A 18 C3 02 C6 FF 60 54 00 00 85 8E 08 00 02 24 41 00 E2 12 ?? ?? 03 3C ?? ?? 62 8C 2C 04 BF 8F 28 04 BE 8F 00 00 43 8C FF FF 02 24 24 04 B7 8F 0A 10 03 00 20 04 B6 8F 1C 04 B5 8F 18 04 B4 8F 14 04 B3 8F 10 04 B2 8F 0C 04 B1 8F 08 04 B0 8F 08 00 E0 03 30 04 BD 27 18 00 A2 00 1C 00 82 8E 21 30 C0 02 21 20 80 02 20 00 43 8C 12 28 00 00 09 F8 60 00 21 28 B0 00 21 28 40 00 ?? ?? ?? 0? 21 20 E0 02 ?? ?? ?? 0? 20 8C 02 7C ?? ?? ?? 0? 21 28 A0 02 ?? ?? ?? 0? 21 20 60 02 1C 00 82 8E 21 30 C0 02 21 20 80 02 20 00 43 8C 09 F8 60 00 21 28 00 02 21 28 40 00 ?? ?? ?? 0? 21 20 E0 02 ?? ?? ?? 0? 20 8C 02 7C 1C 00 82 8E 21 20 80 02 21 28 00 02 20 00 43 8C 09 F8 60 00 21 30 C0 02 ?? ?? ?? 0? 20 8C 02 7C AA FF 40 10 01 00 03 24 ?? ?? ?? 0? 01 00 52 26 C0 00 22 32 C0 00 03 24 BB FF 43 14 21 20 20 02 ?? ?? ?? 0? C0 00 44 36 ?? ?? ?? 0? 21 20 00 00 0C 00 04 24 ?? ?? ?? 0? 21 28 A0 02 21 80 00 00 00 01 11 24 00 04 A3 8F ?? ?? 04 3C ?? ?? 84 24 00 00 62 90 21 28 A0 02 01 00 10 26 80 10 02 00 21 10 82 00 ?? ?? ?? 0? 00 00 44 8C 00 04 A2 8F ?? ?? 04 3C ?? ?? 84 24 01 00 43 90 21 28 A0 02 80 18 03 00 21 18 83 00 ?? ?? ?? 0? 00 00 64 8C 00 04 A2 8F ?? ?? 04 3C ?? ?? 84 24 02 00 43 90 21 28 A0 02 04 00 42 24 80 18 03 00 21 18 83 00 00 00 64 8C ?? ?? ?? 0? 00 04 A2 AF E2 FF 11 56 00 04 A3 8F ?? ?? ?? 0? ?? ?? 03 3C ?? ?? ?? 0? 21 20 A0 03 ?? ?? ?? 0? 21 80 A0 03 }
	condition:
		$1
}

rule file_4_2_0 {
	meta:
		name = "load_pcx_pf"
		size = 1312
		refs = "050c allegro_errno 0040 pack_getc 00a0 pack_igetw 00d0 pack_igetl 0188 _color_load_depth 01d4 create_bitmap_ex 0238 _rgb_r_shift_24 02f0 _rgb_b_shift_24 0394 _fixup_loaded_bitmap 03c4 generate_332_palette 03cc .text 03d4 _rgb_g_shift_24 0510 destroy_bitmap"
	strings:
		$1 = { A0 FB BD 27 58 04 BE AF 5C 04 BF AF 54 04 B7 AF 50 04 B6 AF 4C 04 B5 AF 48 04 B4 AF 44 04 B3 AF 40 04 B2 AF 3C 04 B1 AF 38 04 B0 AF 20 04 A5 AF 0D 01 A0 10 21 F0 80 00 FF FF 02 24 18 04 A2 AF ?? ?? ?? 0? 21 20 C0 03 ?? ?? ?? 0? 21 20 C0 03 ?? ?? ?? 0? 21 20 C0 03 ?? ?? ?? 0? 21 20 C0 03 08 00 03 24 0E 00 43 10 21 98 00 00 5C 04 BF 8F 21 10 60 02 58 04 BE 8F 54 04 B7 8F 50 04 B6 8F 4C 04 B5 8F 48 04 B4 8F 44 04 B3 8F 40 04 B2 8F 3C 04 B1 8F 38 04 B0 8F 08 00 E0 03 60 04 BD 27 ?? ?? ?? 0? 21 20 C0 03 21 20 C0 03 ?? ?? ?? 0? 1C 04 A2 AF 21 20 C0 03 ?? ?? ?? 0? 21 B8 40 00 21 20 C0 03 ?? ?? ?? 0? 21 B0 40 00 21 20 C0 03 ?? ?? ?? 0? 21 A0 40 00 20 04 A3 8F 21 90 00 00 04 00 11 24 00 04 A3 AF 21 80 60 00 10 00 13 24 ?? ?? ?? 0? 21 20 C0 03 02 00 20 16 1A 00 51 00 CD 01 00 00 21 20 C0 03 01 00 52 26 12 10 00 00 ?? ?? ?? 0? 00 00 02 A2 02 00 20 16 1A 00 51 00 CD 01 00 00 21 20 C0 03 12 10 00 00 ?? ?? ?? 0? 01 00 02 A2 02 00 20 16 1A 00 51 00 CD 01 00 00 12 10 00 00 02 00 02 A2 E9 FF 53 16 04 00 10 26 ?? ?? ?? 0? 21 20 C0 03 ?? ?? ?? 0? 21 20 C0 03 C0 10 02 00 14 04 A2 AF 14 04 A3 8F 08 00 02 24 03 00 62 10 18 00 02 24 BC FF 62 54 21 98 00 00 14 04 A4 8F 21 28 00 00 ?? ?? ?? 0? 21 80 00 00 21 20 C0 03 ?? ?? ?? 0? 08 04 A2 AF 21 A8 40 00 3C 00 11 24 01 00 10 26 ?? ?? ?? 0? 21 20 C0 03 FD FF 11 56 01 00 10 26 1C 04 A4 8F 01 00 C5 26 01 00 82 26 23 28 A4 00 14 04 A4 8F 23 10 57 00 21 30 40 00 ?? ?? ?? 0? 04 04 A2 AF A3 FF 40 10 21 98 40 00 ?? ?? 03 3C ?? ?? 62 8C 04 04 A4 8F 54 00 80 18 00 00 40 AC 14 04 A3 8F 40 38 15 00 21 B8 60 02 18 00 A3 02 08 00 03 24 0C 04 A0 AF 08 00 16 24 FF FF 08 24 12 10 00 00 02 00 60 14 1A 00 43 00 CD 01 00 00 12 20 00 00 2A 10 04 00 24 04 A4 AF 28 04 A2 AF ?? ?? 03 3C ?? ?? 62 8C 28 04 B4 8F 21 90 00 00 02 00 C0 16 1A 00 56 00 CD 01 00 00 21 80 00 00 12 18 00 00 10 04 A3 AF 32 00 80 12 0C 04 A2 8F 21 20 C0 03 2C 04 A7 AF ?? ?? ?? 0? 30 04 A8 AF 20 2C 02 7C C0 00 A2 30 C0 00 04 24 2C 04 A7 8F 6D 00 44 10 30 04 A8 8F 01 00 11 24 21 30 00 00 14 04 A2 8F 57 00 56 10 00 00 00 00 FF FF 31 26 1C 00 28 12 24 04 A4 8F 00 00 62 8E 2A 10 42 02 09 00 40 10 01 00 10 26 03 00 03 24 18 00 43 02 10 04 A4 8F 40 00 E3 8E 12 10 00 00 21 10 44 00 21 18 62 00 00 00 65 A0 3C 00 B0 12 01 00 52 26 EF FF F0 14 FF FF 31 26 ?? ?? 04 3C ?? ?? 82 8C 21 80 E0 00 02 00 C0 16 1A 00 56 00 CD 01 00 00 21 90 00 00 12 18 00 00 E7 FF 28 16 10 04 A3 AF 24 04 A4 8F 2A A0 04 02 D2 FF 80 16 21 20 C0 03 0C 04 A2 8F 04 04 A3 8F 01 00 42 24 0C 04 A2 AF 2A 10 43 00 BE FF 40 14 04 00 F7 26 14 04 A4 8F 08 00 02 24 49 00 82 50 FF FF 10 24 ?? ?? 04 3C ?? ?? 82 8C 00 00 43 8C 6B 00 60 14 14 04 A2 8F 08 04 A3 8F 0C 00 43 10 14 04 A4 8F 08 00 02 24 04 00 82 10 20 04 A2 8F 18 04 A3 8F 0A 10 03 00 20 04 A2 AF 20 04 A5 8F 08 04 A6 8F ?? ?? ?? 0? 21 20 60 02 21 98 40 00 14 04 A4 8F 08 00 02 24 30 FF 82 10 08 04 A3 8F 2F FF 62 10 5C 04 BF 8F 18 04 A4 8F 2D FF 80 10 21 10 60 02 ?? ?? ?? 0? 20 04 A4 8F ?? ?? ?? 0? 5C 04 BF 8F ?? ?? 03 3C ?? ?? 62 8C 21 80 A0 02 21 90 00 00 02 00 C0 16 1A 00 56 00 CD 01 00 00 12 18 00 00 ?? ?? ?? 0? 10 04 A3 AF 98 FF 20 12 21 18 00 02 21 20 06 02 00 00 62 8E 2A 10 62 00 04 00 40 10 00 00 00 00 40 00 E2 8E 21 10 43 00 00 00 45 A0 F8 FF 64 14 01 00 63 24 24 04 A3 8F 01 00 02 26 21 80 46 00 ?? ?? ?? 0? 2A A0 03 02 21 20 C0 03 3F 00 B1 30 2C 04 A7 AF ?? ?? ?? 0? 30 04 A8 AF 20 2C 02 7C FF FF 26 26 30 04 A8 8F ?? ?? ?? 0? 2C 04 A7 8F 20 04 BD AF ?? ?? ?? 0? 18 04 A0 AF 0C 00 11 24 ?? ?? ?? 0? 21 20 C0 03 B5 FF 50 10 ?? ?? 04 3C FB FF 51 14 00 01 12 24 21 88 00 00 04 00 10 24 ?? ?? ?? 0? 21 20 C0 03 02 00 00 16 1A 00 50 00 CD 01 00 00 00 04 A3 8F 21 20 C0 03 01 00 31 26 12 10 00 00 ?? ?? ?? 0? 00 00 62 A0 02 00 00 16 1A 00 50 00 CD 01 00 00 00 04 A3 8F 21 20 C0 03 12 10 00 00 ?? ?? ?? 0? 01 00 62 A0 02 00 00 16 1A 00 50 00 CD 01 00 00 00 04 A3 8F 12 10 00 00 02 00 62 A0 04 00 63 24 E5 FF 32 16 00 04 A3 AF ?? ?? ?? 0? ?? ?? 04 3C ?? ?? ?? 0? 21 20 60 02 ?? ?? ?? 0? 21 98 00 00 }
	condition:
		$1
}

rule file_5_0_0 {
	meta:
		name = "free_config_entries"
		size = 48
		refs = "0014 _al_free"
	strings:
		$1 = { F8 FF BD 27 00 00 B0 AF 21 80 80 00 00 00 84 8C 04 00 BF AF ?? ?? ?? 0? 00 00 00 00 04 00 BF 8F 00 00 00 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_5_1_0 {
	meta:
		name = "find_config_string"
		size = 368
		refs = "007c ugetc 012c ustricmp 013c .text 0144 ugetat"
	strings:
		$1 = { D8 FF BD 27 14 00 B4 AF 10 00 B3 AF 08 00 B1 AF 24 00 BF AF 20 00 B7 AF 1C 00 B6 AF 18 00 B5 AF 0C 00 B2 AF 04 00 B0 AF 21 98 A0 00 21 A0 C0 00 0E 00 80 14 21 88 E0 00 21 80 00 00 24 00 BF 8F 21 10 00 02 20 00 B7 8F 1C 00 B6 8F 18 00 B5 8F 14 00 B4 8F 10 00 B3 8F 0C 00 B2 8F 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 28 00 BD 27 02 00 E0 10 00 00 90 8C 00 00 E0 AC 3B 00 60 12 ?? ?? 02 3C ?? ?? 43 8C 09 F8 60 00 21 20 60 02 02 00 40 10 FF FF 12 24 21 90 00 00 E8 FF 00 12 ?? ?? 16 3C 5B 00 15 24 5D 00 17 24 00 00 04 8E 0E 00 80 10 00 00 00 00 05 00 60 12 ?? ?? C3 8E 09 F8 60 00 00 00 00 00 1F 00 55 50 00 00 04 8E 17 00 40 56 00 00 04 8E ?? ?? C3 8E 09 F8 60 00 21 20 80 02 12 00 55 50 00 00 04 8E 01 00 20 56 00 00 30 AE 08 00 10 8E ED FF 00 56 00 00 04 8E 24 00 BF 8F 21 10 00 02 20 00 B7 8F 1C 00 B6 8F 18 00 B5 8F 14 00 B4 8F 10 00 B3 8F 0C 00 B2 8F 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 28 00 BD 27 ?? ?? ?? 0? 21 28 80 02 EC FF 40 14 24 00 BF 8F ?? ?? ?? 0? 21 10 00 02 ?? ?? ?? 0? FF FF 05 24 DF FF 57 14 00 00 00 00 00 00 05 8E ?? ?? ?? 0? 21 20 60 02 ?? ?? ?? 0? 01 00 52 2C ?? ?? ?? 0? FF FF 12 24 }
	condition:
		$1
}

rule file_5_2_0 {
	meta:
		name = "prettify_section_name"
		size = 368
		refs = "002c ustrlen 003c usetc 006c ugetc 00a4 ucwidth 00bc ustrzcat 00c8 uoffset 00ec uwidth 014c .text"
	strings:
		$1 = { E8 FF BD 27 0C 00 B3 AF 04 00 B1 AF 00 00 B0 AF 14 00 BF AF 10 00 B4 AF 08 00 B2 AF 21 88 80 00 21 80 A0 00 05 00 80 10 21 98 C0 00 ?? ?? ?? 0? 00 00 00 00 0D 00 40 14 ?? ?? 14 3C ?? ?? 02 3C ?? ?? 59 8C 21 20 00 02 14 00 BF 8F 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 21 28 00 00 08 00 20 03 18 00 BD 27 ?? ?? 85 8E 09 F8 A0 00 21 20 20 02 5B 00 03 24 2F 00 43 10 ?? ?? 12 3C ?? ?? 43 8E 21 20 00 02 09 F8 60 00 5B 00 05 24 ?? ?? 46 8E 21 20 02 02 09 F8 C0 00 21 28 00 00 ?? ?? 02 3C ?? ?? 43 8C 09 F8 60 00 5D 00 04 24 23 28 62 02 21 20 00 02 ?? ?? ?? 0? 21 30 20 02 21 20 00 02 ?? ?? ?? 0? FF FF 05 24 ?? ?? 85 8E 21 80 02 02 09 F8 A0 00 21 20 00 02 5D 00 03 24 1B 00 43 10 14 00 BF 8F ?? ?? 02 3C ?? ?? 43 8C 09 F8 60 00 21 20 00 02 ?? ?? 46 8E 21 80 02 02 21 20 00 02 09 F8 C0 00 5D 00 05 24 ?? ?? 59 8E 21 20 02 02 14 00 BF 8F 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 21 28 00 00 08 00 20 03 18 00 BD 27 ?? ?? 43 8E 21 20 00 02 09 F8 60 00 21 28 00 00 ?? ?? ?? 0? ?? ?? 02 3C 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_5_3_0 {
	meta:
		name = "config_is_hooked"
		size = 112
		refs = "0004 .bss 0018 .text 003c ustricmp"
	strings:
		$1 = { F8 FE BD 27 ?? ?? 02 3C 00 01 B0 AF ?? ?? 50 8C 21 28 A0 03 04 01 BF AF ?? ?? ?? 0? 00 01 06 24 06 00 00 56 00 00 05 8E ?? ?? ?? 0? 04 01 BF 8F 0B 00 00 12 04 01 BF 8F 00 00 05 8E ?? ?? ?? 0? 21 20 A0 03 FA FF 40 54 10 00 10 8E 04 01 BF 8F FF FF 02 24 00 01 B0 8F 08 00 E0 03 08 01 BD 27 21 10 00 00 00 01 B0 8F 08 00 E0 03 08 01 BD 27 }
	condition:
		$1
}

rule file_5_4_0 {
	meta:
		name = "add_unique_name"
		size = 192
		refs = "0028 .text 004c ustrcmp 0088 _al_sane_realloc"
	strings:
		$1 = { E8 FF BD 27 10 00 B3 AF 0C 00 B2 AF 08 00 B1 AF 14 00 BF AF 04 00 B0 AF 21 88 A0 00 21 90 80 00 17 00 A0 18 21 98 C0 00 ?? ?? ?? 0? 21 80 00 00 14 00 60 50 00 00 44 8E 00 00 42 8E 80 18 10 00 21 28 60 02 21 10 43 00 00 00 44 8C ?? ?? ?? 0? 01 00 10 26 F6 FF 40 14 2A 18 11 02 14 00 BF 8F 21 80 20 02 21 10 00 02 10 00 B3 8F 0C 00 B2 8F 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 18 00 BD 27 00 00 44 8E 01 00 30 26 ?? ?? ?? 0? 80 28 10 00 14 00 BF 8F 80 18 11 00 21 18 43 00 00 00 42 AE 00 00 73 AC 21 10 00 02 10 00 B3 8F 0C 00 B2 8F 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_5_5_0 {
	meta:
		name = "attach_config_entries"
		size = 312
		refs = "0040 .text 004c ugetc 00e4 ugetat 0100 ustricmp"
	strings:
		$1 = { D8 FE BD 27 0C 01 B2 AF 04 01 B0 AF 21 90 C0 00 21 80 80 00 00 01 06 24 21 20 A0 00 21 28 A0 03 1C 01 B6 AF 14 01 B4 AF 24 01 BF AF 20 01 B7 AF 18 01 B5 AF 10 01 B3 AF 08 01 B1 AF 21 B0 E0 00 ?? ?? ?? 0? 21 A0 00 01 1A 00 00 12 ?? ?? 15 3C ?? ?? A5 8E 00 00 10 8E 09 F8 A0 00 21 20 A0 03 21 88 00 00 FF FF 03 24 12 00 00 12 0A 88 62 00 5B 00 13 24 5D 00 17 24 00 00 02 8E 0A 00 40 10 21 20 40 00 ?? ?? A3 8E 09 F8 60 00 00 00 00 00 14 00 53 50 00 00 04 8E 04 00 20 52 08 00 10 8E 1B 00 80 52 00 00 06 8E 08 00 10 8E F3 FF 00 56 00 00 02 8E 24 01 BF 8F 21 10 40 02 20 01 B7 8F 1C 01 B6 8F 18 01 B5 8F 14 01 B4 8F 10 01 B3 8F 0C 01 B2 8F 08 01 B1 8F 04 01 B0 8F 08 00 E0 03 28 01 BD 27 ?? ?? ?? 0? FF FF 05 24 EA FF 57 14 00 00 00 00 0B 00 80 56 00 00 06 8E 00 00 05 8E ?? ?? ?? 0? 21 20 A0 03 ?? ?? ?? 0? 01 00 51 2C 21 28 40 02 ?? ?? ?? 0? 21 20 C0 02 ?? ?? ?? 0? 21 90 40 00 21 28 40 02 ?? ?? ?? 0? 21 20 C0 02 ?? ?? ?? 0? 21 90 40 00 }
	condition:
		$1
}

rule file_5_6_0 {
	meta:
		name = "list_config_sections"
		size = 84
		refs = "0004 .bss 0024 .text"
	strings:
		$1 = { F8 FF BD 27 ?? ?? 02 3C 00 00 B0 AF 21 80 80 00 ?? ?? 44 8C 21 38 00 02 21 28 00 00 21 30 00 00 04 00 BF AF ?? ?? ?? 0? 01 00 08 24 ?? ?? 03 3C ?? ?? 64 8C 21 38 00 02 04 00 BF 8F 00 00 B0 8F 21 30 40 00 21 28 00 00 01 00 08 24 ?? ?? ?? 0? 08 00 BD 27 }
	condition:
		$1
}

rule file_5_7_0 {
	meta:
		name = "list_config_entries"
		size = 96
		refs = "0004 .bss 002c .text"
	strings:
		$1 = { F0 FF BD 27 ?? ?? 02 3C 08 00 B1 AF 21 88 80 00 ?? ?? 44 8C 04 00 B0 AF 21 80 A0 00 21 38 00 02 21 28 20 02 21 30 00 00 0C 00 BF AF ?? ?? ?? 0? 21 40 00 00 ?? ?? 03 3C ?? ?? 64 8C 21 28 20 02 21 38 00 02 0C 00 BF 8F 08 00 B1 8F 04 00 B0 8F 21 30 40 00 21 40 00 00 ?? ?? ?? 0? 10 00 BD 27 }
	condition:
		$1
}

rule file_5_8_0 {
	meta:
		name = "flush_config"
		size = 332
		refs = "0004 usetc 0080 pack_fopen 005c $LC0 00b0 pack_fputs 00b8 ugetc 00d0 pack_putc 0120 pack_fclose"
	strings:
		$1 = { D8 FF BD 27 ?? ?? 02 3C 10 00 B0 AF ?? ?? 50 8C 18 00 B2 AF 0A 00 05 24 21 90 80 00 24 00 BF AF 21 20 A0 03 20 00 B4 AF 1C 00 B3 AF 09 F8 00 02 14 00 B1 AF 21 20 A2 03 09 F8 00 02 21 28 00 00 08 00 40 12 24 00 BF 8F 04 00 44 8E 06 00 80 10 20 00 B4 8F 08 00 42 8E 09 00 40 54 ?? ?? 05 3C 24 00 BF 8F 20 00 B4 8F 1C 00 B3 8F 18 00 B2 8F 14 00 B1 8F 10 00 B0 8F 08 00 E0 03 28 00 BD 27 ?? ?? ?? 0? ?? ?? A5 24 F5 FF 40 10 21 88 40 00 00 00 50 8E 22 00 00 12 ?? ?? 14 3C 5B 00 13 24 00 00 02 8E 21 28 20 02 11 00 40 10 21 20 40 00 ?? ?? ?? 0? 00 00 00 00 ?? ?? 83 8E 09 F8 60 00 00 00 04 8E 20 00 04 24 09 00 53 10 21 28 20 02 ?? ?? ?? 0? 00 00 00 00 3D 00 04 24 ?? ?? ?? 0? 21 28 20 02 20 00 04 24 ?? ?? ?? 0? 21 28 20 02 04 00 02 8E 21 28 20 02 03 00 40 10 21 20 40 00 ?? ?? ?? 0? 00 00 00 00 21 20 A0 03 ?? ?? ?? 0? 21 28 20 02 08 00 10 8E E2 FF 00 56 00 00 02 8E ?? ?? ?? 0? 21 20 20 02 24 00 BF 8F 08 00 40 AE 20 00 B4 8F 1C 00 B3 8F 18 00 B2 8F 14 00 B1 8F 10 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_5_9_0 {
	meta:
		name = "destroy_config"
		size = 184
		refs = "001c .text 0030 _al_free"
	strings:
		$1 = { F0 FF BD 27 08 00 B2 AF 0C 00 BF AF 04 00 B1 AF 00 00 B0 AF 22 00 80 10 21 90 80 00 ?? ?? ?? 0? 00 00 00 00 04 00 44 8E 04 00 80 50 00 00 50 8E ?? ?? ?? 0? 00 00 00 00 00 00 50 8E 12 00 00 52 21 20 40 02 00 00 02 8E 08 00 11 8E 03 00 40 10 21 20 40 00 ?? ?? ?? 0? 00 00 00 00 04 00 02 8E 03 00 40 10 21 20 40 00 ?? ?? ?? 0? 00 00 00 00 21 20 00 02 ?? ?? ?? 0? 21 80 20 02 F2 FF 20 56 00 00 02 8E 21 20 40 02 0C 00 BF 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F ?? ?? ?? 0? 10 00 BD 27 0C 00 BF 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 10 00 BD 27 }
	condition:
		$1
}

rule file_5_10_0 {
	meta:
		name = "config_cleanup"
		size = 296
		refs = "0004 .bss 0030 .text 00b4 _al_free 0100 _remove_exit_func"
	strings:
		$1 = { F0 FF BD 27 ?? ?? 02 3C ?? ?? 03 3C 04 00 B1 AF 00 00 B0 AF 0C 00 BF AF 08 00 B2 AF ?? ?? 50 24 ?? ?? 71 24 00 00 02 8E 04 00 40 10 21 20 40 00 ?? ?? ?? 0? 00 00 00 00 00 00 00 AE 04 00 10 26 F9 FF 30 56 00 00 02 8E ?? ?? 10 3C ?? ?? 04 8E 05 00 80 50 ?? ?? 10 3C ?? ?? ?? 0? 00 00 00 00 ?? ?? 00 AE ?? ?? 10 3C ?? ?? 04 8E 05 00 80 50 ?? ?? 10 3C ?? ?? ?? 0? 00 00 00 00 ?? ?? 00 AE ?? ?? 10 3C ?? ?? 04 8E 04 00 80 10 ?? ?? 12 3C ?? ?? ?? 0? 00 00 00 00 ?? ?? 00 AE ?? ?? 51 8E 0D 00 20 12 ?? ?? 10 3C 00 00 22 8E 03 00 40 10 21 20 40 00 ?? ?? ?? 0? 00 00 00 00 10 00 30 8E ?? ?? ?? 0? 21 20 20 02 F7 FF 00 16 21 88 00 02 ?? ?? 40 AE ?? ?? 10 3C ?? ?? 04 8E ?? ?? ?? 0? ?? ?? 11 3C ?? ?? 24 8E ?? ?? ?? 0? ?? ?? 00 AE ?? ?? 04 3C ?? ?? 02 3C ?? ?? 84 24 ?? ?? 20 AE ?? ?? ?? 0? ?? ?? 40 AC 0C 00 BF 8F ?? ?? 02 3C 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F ?? ?? 40 AC 08 00 E0 03 10 00 BD 27 }
	condition:
		$1
}

rule file_5_11_0 {
	meta:
		name = "pop_config_state"
		size = 80
		refs = "0008 .bss 0018 .text"
	strings:
		$1 = { F8 FF BD 27 00 00 B0 AF ?? ?? 10 3C ?? ?? 04 8E 03 00 80 10 04 00 BF AF ?? ?? ?? 0? 00 00 00 00 ?? ?? 02 26 04 00 43 8C 08 00 44 8C 0C 00 45 8C 04 00 BF 8F ?? ?? 03 AE 04 00 44 AC 00 00 B0 8F 08 00 45 AC 0C 00 40 AC 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_5_12_0 {
	meta:
		name = "push_config_state"
		size = 88
		refs = "0008 .bss 0020 .text"
	strings:
		$1 = { F0 FF BD 27 08 00 B1 AF ?? ?? 11 3C 04 00 B0 AF ?? ?? 30 26 0C 00 04 8E 03 00 80 10 0C 00 BF AF ?? ?? ?? 0? 00 00 00 00 08 00 02 8E 04 00 03 8E ?? ?? 24 8E 0C 00 BF 8F 0C 00 02 AE 08 00 03 AE 04 00 04 AE ?? ?? 20 AE 04 00 B0 8F 08 00 B1 8F 08 00 E0 03 10 00 BD 27 }
	condition:
		$1
}

rule file_5_14_0 {
	meta:
		name = "insert_variable"
		size = 208
		refs = "002c _al_malloc 0044 _al_ustrdup"
	strings:
		$1 = { E8 FF BD 27 10 00 B4 AF 21 A0 80 00 0C 00 04 24 0C 00 B3 AF 08 00 B2 AF 04 00 B1 AF 00 00 B0 AF 14 00 BF AF 21 90 A0 00 21 88 C0 00 ?? ?? ?? 0? 21 98 E0 00 0E 00 40 10 21 80 40 00 15 00 20 12 00 00 00 00 ?? ?? ?? 0? 21 20 20 02 13 00 60 12 00 00 02 AE ?? ?? ?? 0? 21 20 60 02 11 00 40 12 04 00 02 AE 08 00 42 8E 08 00 02 AE 08 00 50 AE 14 00 BF 8F 21 10 00 02 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 18 00 BD 27 EF FF 60 16 00 00 40 AC F1 FF 40 16 04 00 00 AE 14 00 BF 8F 08 00 00 AE 21 10 00 02 00 00 90 AE 0C 00 B3 8F 10 00 B4 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_5_15_0 {
	meta:
		name = "set_config"
		size = 1540
		refs = "011c uwidth 0124 usetc 003c .text 0064 _al_malloc 0088 _al_ustrdup 00bc ucwidth 012c _al_sane_realloc 0178 ugetc 0228 uisspace 02d0 ustrzcpy 0340 ustrlen 035c usetat 036c ugetat 0394 _al_free 0488 allegro_errno"
	strings:
		$1 = { B0 FF BD 27 18 00 A4 AF 21 20 00 00 2C 00 B1 AF 4C 00 BF AF 48 00 BE AF 44 00 B7 AF 40 00 B6 AF 3C 00 B5 AF 38 00 B4 AF 34 00 B3 AF 30 00 B2 AF 28 00 B0 AF 1C 00 A5 AF 20 00 A6 AF ?? ?? ?? 0? 21 88 E0 00 18 00 A2 8F 00 00 44 8C 05 00 80 10 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 18 00 A3 8F 00 00 60 AC ?? ?? ?? 0? 0C 00 04 24 18 00 A5 8F 21 80 40 00 40 01 40 10 00 00 A2 AC 00 00 40 AC 36 01 20 12 08 00 40 AC ?? ?? ?? 0? 21 20 20 02 04 00 02 AE 18 00 A2 8F 00 00 50 8C 04 00 02 8E 45 01 40 10 00 00 00 00 20 00 A5 8F 00 01 A0 18 4C 00 BF 8F 10 00 B0 AF 0C 00 A0 AF ?? ?? 02 3C ?? ?? 43 8C 1C 00 A5 8F 0C 00 A2 8F 21 20 00 00 21 28 A2 00 09 F8 60 00 14 00 A5 AF 00 01 04 24 ?? ?? ?? 0? 08 00 A2 AF E7 00 40 10 21 A0 40 00 20 00 A3 8F 0C 00 A5 8F 23 B8 65 00 19 01 E0 1A 21 90 00 00 21 B0 00 00 00 01 13 24 ?? ?? ?? 0? ?? ?? 1E 3C 0A 00 03 24 25 00 03 12 ?? ?? 05 3C 07 00 40 14 ?? ?? 05 3C 40 98 13 00 ?? ?? ?? 0? 21 28 60 02 D4 00 40 10 21 A0 40 00 ?? ?? 05 3C ?? ?? A3 8C 21 20 92 02 09 F8 60 00 21 28 00 02 ?? ?? 03 3C ?? ?? 65 8C 21 20 20 02 09 F8 A0 00 21 90 42 02 21 B0 C2 02 2A 10 D7 02 19 00 40 10 21 10 40 02 14 00 A5 8F ?? ?? 02 3C ?? ?? 43 8C 21 88 B6 00 09 F8 60 00 21 20 20 02 08 00 A3 8F 21 80 40 00 0D 00 05 24 23 10 63 02 21 20 80 02 2A 10 42 02 DB FF 05 16 ?? ?? 15 3C ?? ?? 05 3C ?? ?? A3 8C 09 F8 60 00 21 20 20 02 21 B0 C2 02 2A 10 D7 02 8A 00 40 14 14 00 A5 8F 21 10 40 02 ?? ?? 15 3C ?? ?? A6 8E 21 20 82 02 09 F8 C0 00 21 28 00 00 ?? ?? C3 8F 09 F8 60 00 21 20 80 02 9C 00 40 10 21 80 40 00 ?? ?? ?? 0? 21 88 00 00 ?? ?? 05 3C ?? ?? A3 8C 09 F8 60 00 00 00 00 00 ?? ?? C5 8F 21 88 22 02 09 F8 A0 00 21 20 91 02 90 00 40 10 21 80 40 00 ?? ?? ?? 0? 21 20 00 02 F3 FF 40 14 21 20 91 02 8A 00 00 12 21 90 00 00 ?? ?? ?? 0? 00 00 00 00 3D 00 05 24 15 00 05 12 23 00 02 24 13 00 02 12 ?? ?? 02 3C ?? ?? 43 8C 09 F8 60 00 00 00 00 00 ?? ?? 03 3C ?? ?? 65 8C 21 20 91 02 09 F8 A0 00 21 90 42 02 ?? ?? C3 8F 21 88 22 02 09 F8 60 00 21 20 91 02 05 00 40 10 21 80 40 00 ?? ?? ?? 0? 21 20 00 02 EA FF 40 10 21 20 00 02 6F 00 40 12 21 98 20 02 08 00 A3 8F 21 A8 43 02 ?? ?? ?? 0? 21 20 A0 02 C3 00 40 10 00 00 A2 AF 23 30 32 02 21 20 40 00 21 28 A0 02 ?? ?? ?? 0? 21 30 86 02 15 00 00 52 21 20 91 02 21 88 91 02 ?? ?? ?? 0? 21 20 00 02 04 00 40 14 21 20 20 02 3D 00 02 24 0D 00 02 16 00 00 00 00 ?? ?? 05 3C ?? ?? A3 8C 09 F8 60 00 00 00 00 00 21 98 62 02 ?? ?? C3 8F 21 88 93 02 09 F8 60 00 21 20 20 02 21 80 40 00 EE FF 40 14 21 20 20 02 ?? ?? ?? 0? 00 00 00 00 AC 00 40 10 21 90 40 00 ?? ?? ?? 0? 21 20 40 00 FF FF 50 24 07 00 01 06 21 28 00 02 ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 0B 00 20 06 21 28 00 02 ?? ?? ?? 0? 21 20 40 02 ?? ?? ?? 0? 21 20 40 00 FF FF 11 26 21 28 00 02 21 20 40 02 21 30 00 00 F3 FF 40 14 21 80 20 02 ?? ?? ?? 0? 21 20 80 02 3F 00 C0 06 18 00 A3 8F ?? ?? ?? 0? 0C 00 04 24 56 00 40 10 21 20 40 00 0C 00 A5 8F 20 00 A2 8F 08 00 80 AC 21 28 B6 00 2A 18 A2 00 0C 00 A5 AF 00 00 A2 8F 10 00 A5 8F 04 00 92 AC 00 00 82 AC 33 00 60 10 00 00 A4 AC 08 00 84 24 ?? ?? ?? 0? 10 00 A4 AF ?? ?? 02 3C ?? ?? 43 8C 21 88 B6 00 09 F8 60 00 21 20 20 02 0D 00 03 24 34 00 03 12 0A 00 03 24 6F FF 03 56 21 10 40 02 0D 00 05 24 6C FF 45 14 21 10 40 02 ?? ?? 02 3C ?? ?? 43 8C 21 20 20 02 09 F8 60 00 ?? ?? 15 3C 21 B0 C2 02 21 10 40 02 ?? ?? A6 8E 21 20 82 02 09 F8 C0 00 21 28 00 00 ?? ?? C3 8F 09 F8 60 00 21 20 80 02 66 FF 40 14 21 80 40 00 21 20 80 02 ?? ?? ?? 0? 00 00 A0 AF C8 FF 40 14 21 90 40 00 ?? ?? ?? 0? 21 20 80 02 ?? ?? ?? 0? 18 00 A3 8F ?? ?? 02 3C ?? ?? 44 8C 0C 00 03 24 00 00 83 AC 18 00 A3 8F ?? ?? ?? 0? 00 00 64 8C 18 00 A5 8F 00 00 A0 AC 4C 00 BF 8F 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 50 00 BD 27 0A 00 05 24 3B FF 45 54 21 10 40 02 ?? ?? 02 3C ?? ?? 43 8C 21 20 20 02 09 F8 60 00 ?? ?? 15 3C 21 B0 C2 02 ?? ?? ?? 0? 21 10 40 02 ?? ?? 02 3C ?? ?? 43 8C 18 00 A2 8F 00 00 44 8C 0C 00 02 24 ?? ?? ?? 0? 00 00 62 AC 18 00 A3 8F 4C 00 BF 8F 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 00 00 60 AC 08 00 E0 03 50 00 BD 27 ?? ?? ?? 0? 04 00 40 AC 21 B0 00 00 21 10 00 00 ?? ?? 1E 3C ?? ?? ?? 0? ?? ?? 15 3C ?? ?? 02 3C ?? ?? 44 8C 4C 00 BF 8F 0C 00 03 24 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 00 00 83 AC 08 00 E0 03 50 00 BD 27 ?? ?? ?? 0? 21 20 00 02 18 00 A3 8F ?? ?? ?? 0? 00 00 60 AC ?? ?? 02 3C ?? ?? 43 8C 0C 00 02 24 21 20 80 02 ?? ?? ?? 0? 00 00 62 AC ?? ?? ?? 0? 18 00 A3 8F ?? ?? ?? 0? 21 20 A0 03 ?? ?? ?? 0? 21 20 80 02 ?? ?? ?? 0? 18 00 A3 8F }
	condition:
		$1
}

rule file_5_16_0 {
	meta:
		name = "init_config"
		size = 320
		refs = "0028 .bss 0060 .text 006c _add_exit_func 0064 $LC2 0080 _al_malloc 0038 $LC3 00b8 uconvert 00e4 find_allegro_resource 00f4 set_config_file 0104 get_executable_name 010c usetc 0114 get_filename 0130 ustrzcat"
	strings:
		$1 = { 70 FB BD 27 84 04 B1 AF ?? ?? 11 3C ?? ?? 22 8E 80 04 B0 AF 8C 04 BF AF 88 04 B2 AF 10 00 40 10 21 80 80 00 05 00 00 12 ?? ?? 10 3C ?? ?? 02 3C ?? ?? 43 8C 1A 00 60 50 ?? ?? 04 3C ?? ?? 02 8E 0F 00 40 10 00 00 00 00 8C 04 BF 8F 88 04 B2 8F 84 04 B1 8F 80 04 B0 8F 08 00 E0 03 90 04 BD 27 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 84 24 ?? ?? ?? 0? ?? ?? A5 24 FF FF 02 24 ?? ?? ?? 0? ?? ?? 22 AE ?? ?? ?? 0? 0C 00 04 24 EF FF 40 10 ?? ?? 02 AE 08 00 40 AC 00 00 40 AC ?? ?? ?? 0? 04 00 40 AC 53 41 05 3C 75 63 07 3C ?? ?? 84 24 38 43 A5 34 2E 72 E7 34 21 30 A0 03 ?? ?? ?? 0? 80 00 08 24 80 00 B1 27 21 20 20 02 21 28 40 00 21 30 00 00 21 38 00 00 21 40 00 00 21 48 00 00 21 50 00 00 00 04 0B 24 ?? ?? ?? 0? 21 90 40 00 05 00 40 14 00 04 05 24 ?? ?? ?? 0? 21 20 20 02 ?? ?? ?? 0? ?? ?? 10 3C ?? ?? ?? 0? 21 20 20 02 ?? ?? 02 3C ?? ?? 50 8C ?? ?? ?? 0? 21 20 20 02 21 20 40 00 09 F8 00 02 21 28 00 00 21 20 20 02 21 30 40 02 ?? ?? ?? 0? 00 04 05 24 ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_5_17_0 {
	meta:
		name = "load_config_file"
		size = 508
		refs = "003c .text 0048 system_driver 0058 file_size_ex 0074 pack_fopen 006c $LC1 0084 _al_malloc 009c pack_fread 00bc need_uconvert 00dc _al_free 010c pack_fclose 0158 uconvert_size 0184 do_uconvert 018c ucwidth"
	strings:
		$1 = { D8 FF BD 27 08 00 B1 AF 21 88 80 00 00 00 84 8C 10 00 B3 AF 0C 00 B2 AF 24 00 BF AF 20 00 B7 AF 1C 00 B6 AF 18 00 B5 AF 14 00 B4 AF 04 00 B0 AF 21 90 A0 00 04 00 80 10 21 98 C0 00 ?? ?? ?? 0? 00 00 00 00 00 00 20 AE ?? ?? 02 3C ?? ?? 43 8C 31 00 60 10 21 20 20 02 ?? ?? ?? 0? 21 20 40 02 25 18 43 00 2B 00 60 10 21 80 40 00 ?? ?? 05 3C 21 20 40 02 ?? ?? ?? 0? ?? ?? A5 24 25 00 40 10 21 A8 40 00 ?? ?? ?? 0? 01 00 04 26 4E 00 40 10 21 90 40 00 21 20 40 00 21 28 00 02 ?? ?? ?? 0? 21 30 A0 02 54 55 16 3C 21 10 50 02 75 63 14 3C 00 00 40 A0 21 20 40 02 38 46 C5 36 ?? ?? ?? 0? 2E 72 86 36 22 00 40 14 21 20 20 02 21 30 00 02 21 38 60 02 ?? ?? ?? 0? 21 28 40 02 ?? ?? ?? 0? 21 20 40 02 21 20 A0 02 24 00 BF 8F 20 00 B7 8F 1C 00 B6 8F 18 00 B5 8F 14 00 B4 8F 10 00 B3 8F 0C 00 B2 8F 08 00 B1 8F 04 00 B0 8F ?? ?? ?? 0? 28 00 BD 27 21 20 20 02 21 38 60 02 24 00 BF 8F 20 00 B7 8F 1C 00 B6 8F 18 00 B5 8F 14 00 B4 8F 10 00 B3 8F 0C 00 B2 8F 08 00 B1 8F 04 00 B0 8F 21 28 00 00 21 30 00 00 ?? ?? ?? 0? 28 00 BD 27 38 46 C5 36 2E 72 86 36 ?? ?? ?? 0? 21 20 40 02 21 20 40 00 ?? ?? ?? 0? 21 B8 40 00 1D 00 40 10 21 80 40 00 21 30 40 00 2E 72 87 36 38 46 C5 36 21 20 40 02 ?? ?? ?? 0? 21 40 E0 02 ?? ?? 02 3C ?? ?? 43 8C 09 F8 60 00 21 20 00 00 23 30 E2 02 21 20 20 02 21 28 00 02 ?? ?? ?? 0? 21 38 60 02 CA FF 50 12 00 00 00 00 ?? ?? ?? 0? 21 20 00 02 ?? ?? ?? 0? 00 00 00 00 21 20 20 02 21 38 60 02 21 28 00 00 ?? ?? ?? 0? 21 30 00 00 ?? ?? ?? 0? 21 20 A0 02 ?? ?? 02 3C ?? ?? 43 8C 09 F8 60 00 21 20 00 00 ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_5_18_0 {
	meta:
		name = "override_config_file"
		size = 92
		refs = "0014 .bss 0028 .text"
	strings:
		$1 = { F8 FF BD 27 04 00 BF AF 09 00 80 10 00 00 B0 AF 21 28 80 00 ?? ?? 04 3C 04 00 BF 8F 00 00 B0 8F ?? ?? 84 24 21 30 A0 00 ?? ?? ?? 0? 08 00 BD 27 ?? ?? 10 3C ?? ?? 04 8E 05 00 80 10 04 00 BF 8F ?? ?? ?? 0? 00 00 00 00 ?? ?? 00 AE 04 00 BF 8F 00 00 B0 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_5_19_0 {
	meta:
		name = "set_config_file"
		size = 20
		refs = "0004 .bss 000c .text"
	strings:
		$1 = { 21 28 80 00 ?? ?? 04 3C ?? ?? 84 24 ?? ?? ?? 0? 21 30 A0 00 }
	condition:
		$1
}

rule file_5_20_0 {
	meta:
		name = "get_config_text"
		size = 812
		refs = "0290 .bss 0000 _allegro_count 0070 .text 0080 $LC4 0094 uconvert 00a8 need_uconvert 00b8 ustrsizez 00c0 _al_malloc 00e0 ugetxc 0100 uisspace 0120 usetc 0170 ustricmp 01d0 _al_free 021c uconvert_size 0258 do_uconvert 029c allegro_errno 01c0 empty_string"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 43 8C D0 FE BD 27 1C 01 B5 AF 2C 01 BF AF 28 01 BE AF 24 01 B7 AF 20 01 B6 AF 18 01 B4 AF 14 01 B3 AF 10 01 B2 AF 0C 01 B1 AF 08 01 B0 AF 0E 00 60 14 21 A8 80 00 2C 01 BF 8F 21 10 A0 02 28 01 BE 8F 24 01 B7 8F 20 01 B6 8F 1C 01 B5 8F 18 01 B4 8F 14 01 B3 8F 10 01 B2 8F 0C 01 B1 8F 08 01 B0 8F 08 00 E0 03 30 01 BD 27 ?? ?? ?? 0? FF FF 04 24 53 41 11 3C 75 63 13 3C ?? ?? 04 3C ?? ?? 84 24 38 43 25 36 04 00 A6 27 2E 72 67 36 ?? ?? ?? 0? 00 01 08 24 21 20 A0 02 38 43 25 36 2E 72 66 36 ?? ?? ?? 0? 21 A0 40 00 59 00 40 14 38 43 25 36 ?? ?? ?? 0? 21 20 A0 02 ?? ?? ?? 0? 21 20 40 00 74 00 40 10 21 90 40 00 21 F0 A0 02 00 00 BE AF 21 88 00 00 ?? ?? 13 3C ?? ?? 16 3C 3D 00 17 24 ?? ?? C3 8E 09 F8 60 00 21 20 A0 03 21 80 40 00 14 00 40 10 21 20 40 00 ?? ?? ?? 0? 00 00 00 00 21 20 51 02 56 00 40 14 5F 00 05 24 54 00 17 12 23 00 02 24 53 00 02 12 ?? ?? 63 8E 21 28 00 02 09 F8 60 00 21 20 51 02 ?? ?? C3 8E 21 20 A0 03 09 F8 60 00 21 88 22 02 21 80 40 00 EE FF 40 14 21 20 40 00 ?? ?? 66 8E 21 20 51 02 09 F8 C0 00 21 28 00 00 ?? ?? 03 3C ?? ?? 70 8C 0D 00 00 12 ?? ?? 02 3C 00 00 05 8E ?? ?? ?? 0? 21 20 80 02 05 00 40 54 10 00 10 8E 08 00 02 8E 3D 00 40 14 21 20 40 02 10 00 10 8E F7 FF 00 56 00 00 05 8E ?? ?? 02 3C ?? ?? 44 8C 21 28 80 02 21 30 40 02 ?? ?? ?? 0? 21 38 00 00 43 00 40 50 ?? ?? 02 3C 04 00 42 8C 3E 00 40 50 ?? ?? 02 3C 21 80 40 00 03 00 D5 13 00 00 00 00 ?? ?? ?? 0? 21 20 C0 03 ?? ?? ?? 0? 21 20 40 02 2C 01 BF 8F 21 A8 00 02 21 10 A0 02 28 01 BE 8F 24 01 B7 8F 20 01 B6 8F 1C 01 B5 8F 18 01 B4 8F 14 01 B3 8F 10 01 B2 8F 0C 01 B1 8F 08 01 B0 8F 08 00 E0 03 30 01 BD 27 2E 72 66 36 ?? ?? ?? 0? 21 20 A0 02 21 20 40 00 ?? ?? ?? 0? 21 80 40 00 1A 00 40 10 21 F0 40 00 ?? ?? ?? 0? 21 20 00 02 14 00 40 10 21 90 40 00 38 43 25 36 2E 72 67 36 21 40 00 02 21 20 A0 02 ?? ?? ?? 0? 21 30 C0 03 ?? ?? ?? 0? 00 00 BE AF ?? ?? 63 8E 09 F8 60 00 00 00 00 00 ?? ?? ?? 0? 21 88 22 02 09 F8 40 00 21 28 C0 03 D0 FF 40 14 21 80 40 00 ?? ?? ?? 0? ?? ?? 02 3C ?? ?? ?? 0? 21 20 C0 03 ?? ?? 02 3C ?? ?? 44 8C 0C 00 03 24 ?? ?? 02 3C 00 00 83 AC ?? ?? ?? 0? ?? ?? 55 24 ?? ?? ?? 0? ?? ?? 50 24 ?? ?? 44 8C 21 28 80 02 21 30 40 02 ?? ?? ?? 0? 21 38 00 00 B9 FF 40 54 04 00 42 8C ?? ?? 11 3C ?? ?? 24 8E 21 28 80 02 21 30 40 02 ?? ?? ?? 0? 21 38 00 00 B0 FF 40 14 21 28 00 00 ?? ?? 22 8E 21 30 40 02 21 20 40 00 21 38 C0 03 ?? ?? ?? 0? 00 00 50 8C ?? ?? 24 8E 00 00 82 8C 08 00 50 AC 00 00 83 8C ?? ?? ?? 0? 04 00 70 8C }
	condition:
		$1
}

rule file_5_21_0 {
	meta:
		name = "set_config_string"
		size = 900
		refs = "0180 .bss 0030 .text 006c ustricmp 00b4 ugetc 0134 _al_free 013c _al_ustrdup 0174 ugetat"
	strings:
		$1 = { D8 FE BD 27 10 01 B1 AF 0C 01 B0 AF 04 00 B1 27 21 80 80 00 FF FF 04 24 24 01 BF AF 1C 01 B4 AF 18 01 B3 AF 21 A0 A0 00 21 98 C0 00 20 01 B5 AF ?? ?? ?? 0? 14 01 B2 AF 21 20 00 02 21 28 20 02 ?? ?? ?? 0? 00 01 06 24 ?? ?? 02 3C ?? ?? 50 8C 06 00 00 56 00 00 05 8E ?? ?? ?? 0? ?? ?? 15 3C 14 00 00 12 ?? ?? 15 3C 00 00 05 8E ?? ?? ?? 0? 21 20 20 02 FA FF 40 54 10 00 10 8E 0C 00 02 8E 03 00 40 10 21 20 80 02 09 F8 40 00 21 28 60 02 24 01 BF 8F 20 01 B5 8F 1C 01 B4 8F 18 01 B3 8F 14 01 B2 8F 10 01 B1 8F 0C 01 B0 8F 08 00 E0 03 28 01 BD 27 ?? ?? A3 8E 21 20 80 02 09 F8 60 00 23 00 10 24 30 00 50 10 ?? ?? 02 3C ?? ?? A5 8E 09 F8 A0 00 21 20 20 02 5B 00 03 24 25 00 43 50 21 20 20 02 ?? ?? 02 3C ?? ?? 52 8C 7A 00 40 12 ?? ?? 02 3C 21 20 40 02 21 28 20 02 21 30 80 02 ?? ?? ?? 0? 21 38 A0 03 3E 00 40 10 21 80 40 00 29 00 60 12 ?? ?? A3 8E 09 F8 60 00 21 20 60 02 26 00 40 50 00 00 04 8E 04 00 04 8E 03 00 80 10 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 21 20 60 02 04 00 02 AE FF FF 02 24 08 00 42 AE 24 01 BF 8F 20 01 B5 8F 1C 01 B4 8F 18 01 B3 8F 14 01 B2 8F 10 01 B1 8F 0C 01 B0 8F 08 00 E0 03 28 01 BD 27 ?? ?? ?? 0? 01 00 05 24 DA FF 50 14 ?? ?? 02 3C ?? ?? 02 3C ?? ?? 52 8C DA FF 40 16 21 20 40 02 24 01 BF 8F 20 01 B5 8F 1C 01 B4 8F 18 01 B3 8F 14 01 B2 8F 10 01 B1 8F 0C 01 B0 8F 08 00 E0 03 28 01 BD 27 00 00 04 8E 04 00 80 50 04 00 04 8E ?? ?? ?? 0? 00 00 00 00 04 00 04 8E 04 00 80 10 00 00 A3 8F ?? ?? ?? 0? 00 00 00 00 00 00 A3 8F 3A 00 60 10 08 00 02 8E 08 00 62 AC ?? ?? ?? 0? 21 20 00 02 FF FF 02 24 ?? ?? ?? 0? 08 00 42 AE D0 FF 60 12 ?? ?? A3 8E 09 F8 60 00 21 20 60 02 CD FF 40 10 FF FF 02 24 ?? ?? 02 3C ?? ?? 43 8C 09 F8 60 00 21 20 20 02 2F 00 40 10 21 30 80 02 21 20 40 02 21 28 00 00 21 30 20 02 ?? ?? ?? 0? 21 38 A0 03 16 00 40 14 21 80 40 00 ?? ?? ?? 0? 00 00 50 8E 07 00 40 10 21 20 40 00 ?? ?? A3 8E 09 F8 60 00 00 00 00 00 0B 00 40 54 08 00 10 8E 08 00 03 8E 04 00 62 8C 0C 00 40 10 21 20 40 00 ?? ?? A3 8E 09 F8 60 00 00 00 00 00 08 00 40 10 21 28 00 02 08 00 10 8E 05 00 00 12 21 28 00 02 08 00 03 8E EB FF 60 54 00 00 62 8C 21 28 00 02 21 30 80 02 21 38 60 02 ?? ?? ?? 0? 21 20 40 02 FF FF 02 24 ?? ?? ?? 0? 08 00 42 AE ?? ?? ?? 0? 00 00 42 AE ?? ?? 52 8C 86 FF 40 16 21 20 40 02 ?? ?? ?? 0? 24 01 BF 8F 21 38 60 02 21 20 40 02 21 28 00 00 ?? ?? ?? 0? 00 00 50 8E 00 00 43 8E FF FF 02 24 08 00 42 AE ?? ?? ?? 0? 08 00 70 AC 04 00 00 56 08 00 02 8E ?? ?? ?? 0? 21 28 00 02 08 00 02 8E FE FF 40 54 21 80 40 00 04 00 04 8E 0A 00 80 10 ?? ?? A3 8E 09 F8 60 00 00 00 00 00 07 00 40 10 21 28 00 02 21 20 40 02 21 30 00 00 ?? ?? ?? 0? 21 38 00 00 21 80 40 00 21 28 00 02 21 30 20 02 21 20 40 02 ?? ?? ?? 0? 21 38 00 00 CE FF 40 10 21 80 40 00 ?? ?? ?? 0? 08 00 03 8E }
	condition:
		$1
}

rule file_5_22_0 {
	meta:
		name = "get_config_string"
		size = 372
		refs = "0050 .bss 0024 .text 0060 ustricmp 00d0 ustrlen 0100 ugetc 0158 ugetat"
	strings:
		$1 = { E8 FE BD 27 04 01 B0 AF 21 80 80 00 FF FF 04 24 14 01 BF AF 0C 01 B2 AF 08 01 B1 AF 21 90 A0 00 21 88 C0 00 ?? ?? ?? 0? 10 01 B3 AF 21 20 00 02 21 28 A0 03 ?? ?? ?? 0? 00 01 06 24 ?? ?? 02 3C ?? ?? 50 8C 06 00 00 56 00 00 05 8E ?? ?? ?? 0? ?? ?? 02 3C 14 00 00 12 ?? ?? 02 3C 00 00 05 8E ?? ?? ?? 0? 21 20 A0 03 FA FF 40 54 10 00 10 8E 08 00 02 8E 04 00 40 10 21 28 20 02 09 F8 40 00 21 20 40 02 21 88 40 00 14 01 BF 8F 21 10 20 02 10 01 B3 8F 0C 01 B2 8F 08 01 B1 8F 04 01 B0 8F 08 00 E0 03 18 01 BD 27 ?? ?? 44 8C 21 28 A0 03 21 30 40 02 ?? ?? ?? 0? 21 38 00 00 10 00 40 10 21 80 40 00 04 00 04 8E F0 FF 80 10 14 01 BF 8F ?? ?? ?? 0? 00 00 00 00 EB FF 40 10 14 01 BF 8F 04 00 11 8E 10 01 B3 8F 21 10 20 02 0C 01 B2 8F 08 01 B1 8F 04 01 B0 8F 08 00 E0 03 18 01 BD 27 ?? ?? 10 3C ?? ?? 03 8E 21 20 40 02 09 F8 60 00 23 00 13 24 14 00 53 10 ?? ?? 05 8E 09 F8 A0 00 21 20 A0 03 5B 00 03 24 0B 00 43 10 21 20 A0 03 ?? ?? 02 3C ?? ?? 44 8C 21 30 40 02 21 28 A0 03 ?? ?? ?? 0? 21 38 00 00 CF FF 40 10 21 80 40 00 ?? ?? ?? 0? 04 00 04 8E ?? ?? ?? 0? 01 00 05 24 F4 FF 53 14 ?? ?? 02 3C ?? ?? 02 3C ?? ?? ?? 0? ?? ?? 44 8C }
	condition:
		$1
}

rule file_5_23_0 {
	meta:
		name = "hook_config_section"
		size = 340
		refs = "0034 .text 004c .bss 0070 ustricmp 00b8 _al_malloc 00c8 _al_ustrdup 012c _al_free"
	strings:
		$1 = { E0 FE BD 27 04 01 B0 AF 21 80 80 00 21 20 00 00 1C 01 BF AF 18 01 B5 AF 14 01 B4 AF 10 01 B3 AF 0C 01 B2 AF 21 A0 C0 00 21 A8 E0 00 21 90 A0 00 08 01 B1 AF ?? ?? ?? 0? ?? ?? 13 3C 21 20 00 02 21 28 A0 03 ?? ?? ?? 0? 00 01 06 24 ?? ?? 70 8E 19 00 00 12 ?? ?? 71 26 ?? ?? ?? 0? 00 00 05 8E 10 00 11 26 14 00 40 10 21 80 40 00 00 00 05 8E ?? ?? ?? 0? 21 20 A0 03 F9 FF 40 54 10 00 02 8E 24 00 40 12 00 00 00 00 0C 00 15 AE 04 00 12 AE 08 00 14 AE 1C 01 BF 8F 18 01 B5 8F 14 01 B4 8F 10 01 B3 8F 0C 01 B2 8F 08 01 B1 8F 04 01 B0 8F 08 00 E0 03 20 01 BD 27 ?? ?? ?? 0? 14 00 04 24 F4 FF 40 10 21 80 40 00 ?? ?? ?? 0? 21 20 A0 03 1C 00 40 10 00 00 02 AE ?? ?? 62 8E 1C 01 BF 8F 04 00 12 AE 08 00 14 AE 10 00 02 AE 0C 00 15 AE ?? ?? 70 AE 18 01 B5 8F 14 01 B4 8F 10 01 B3 8F 0C 01 B2 8F 08 01 B1 8F 04 01 B0 8F 08 00 E0 03 20 01 BD 27 DD FF 80 56 0C 00 15 AE DB FF A0 56 0C 00 15 AE 10 00 02 8E 00 00 04 8E ?? ?? ?? 0? 00 00 22 AE ?? ?? ?? 0? 21 20 00 02 ?? ?? ?? 0? 1C 01 BF 8F ?? ?? ?? 0? 21 20 00 02 ?? ?? ?? 0? 1C 01 BF 8F }
	condition:
		$1
}

rule file_5_24_0 {
	meta:
		name = "_reload_config"
		size = 80
		refs = "0000 .bss 0018 _al_ustrdup 0024 set_config_file 0038 _al_free"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 8C F8 FF BD 27 04 00 BF AF 0B 00 40 10 00 00 B0 AF ?? ?? ?? 0? 04 00 44 8C 21 80 40 00 ?? ?? ?? 0? 21 20 40 00 21 20 00 02 04 00 BF 8F 00 00 B0 8F ?? ?? ?? 0? 08 00 BD 27 04 00 BF 8F 00 00 B0 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_5_25_0 {
	meta:
		name = "reload_config_texts"
		size = 620
		refs = "0008 .bss 0034 .text 0044 $LC5 0054 set_config_string 0048 $LC6 0078 uconvert 00a4 get_config_string 00b4 ugetc 00cc _al_malloc 0118 _al_ustrdup 0124 ustrlwr 012c ustrlen 0140 $LC8 0168 $LC10 01ac find_allegro_resource 01bc _al_free 01cc uoffset 01d4 $LC7 01f8 ustricmp 0208 $LC9"
	strings:
		$1 = { E0 FA BD 27 14 05 B5 AF ?? ?? 15 3C ?? ?? A2 8E 04 05 B1 AF 1C 05 BF AF 18 05 B6 AF 10 05 B4 AF 0C 05 B3 AF 08 05 B2 AF 00 05 B0 AF 04 00 40 10 21 88 80 00 ?? ?? ?? 0? 21 20 40 00 ?? ?? A0 AE 33 00 20 12 ?? ?? 10 3C ?? ?? 12 3C 21 30 20 02 ?? ?? 04 26 ?? ?? ?? 0? ?? ?? 45 26 53 41 13 3C 75 63 14 3C ?? ?? 04 26 38 43 65 36 21 30 A0 03 2E 72 87 36 80 00 08 24 ?? ?? ?? 0? 80 00 B6 27 ?? ?? 44 26 21 30 C0 02 2E 72 87 36 80 00 08 24 38 43 65 36 ?? ?? ?? 0? 21 80 40 00 21 28 40 00 21 20 00 02 ?? ?? ?? 0? 21 30 00 00 07 00 40 10 21 80 40 00 ?? ?? 02 3C ?? ?? 43 8C 09 F8 60 00 21 20 00 02 14 00 40 14 00 00 00 00 ?? ?? ?? 0? 0C 00 04 24 04 00 40 10 ?? ?? A2 AE 08 00 40 AC 00 00 40 AC 04 00 40 AC 1C 05 BF 8F 18 05 B6 8F 14 05 B5 8F 10 05 B4 8F 0C 05 B3 8F 08 05 B2 8F 04 05 B1 8F 00 05 B0 8F 08 00 E0 03 20 05 BD 27 ?? ?? ?? 0? ?? ?? 12 3C ?? ?? ?? 0? 21 20 00 02 21 88 40 00 ?? ?? ?? 0? 21 20 40 00 ?? ?? ?? 0? 21 20 20 02 04 00 42 28 24 00 40 10 21 20 20 02 ?? ?? 04 3C 53 41 05 3C 75 63 07 3C ?? ?? 84 24 38 43 A5 34 2E 72 E7 34 21 30 A0 03 ?? ?? ?? 0? 80 00 08 24 21 80 40 00 ?? ?? 04 3C 53 41 05 3C 75 63 07 3C ?? ?? 84 24 38 43 A5 34 21 30 C0 02 2E 72 E7 34 ?? ?? ?? 0? 80 00 08 24 00 01 B2 27 21 30 00 02 21 38 40 00 21 20 40 02 21 28 20 02 21 40 00 00 21 48 00 00 21 50 00 00 ?? ?? ?? 0? 00 04 0B 24 1D 00 40 10 00 00 00 00 ?? ?? ?? 0? 21 20 20 02 ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? FC FF 05 24 ?? ?? 04 3C ?? ?? 84 24 38 43 65 36 21 30 A0 03 2E 72 87 36 80 00 08 24 ?? ?? ?? 0? 21 80 40 00 21 28 40 00 ?? ?? ?? 0? 21 20 30 02 D0 FF 40 14 ?? ?? 04 3C ?? ?? 04 3C ?? ?? 84 24 38 43 65 36 2E 72 87 36 21 30 A0 03 ?? ?? ?? 0? 80 00 08 24 ?? ?? ?? 0? 21 80 40 00 ?? ?? ?? 0? 21 20 20 02 ?? ?? A4 26 21 28 40 02 ?? ?? ?? 0? 21 30 00 00 1C 05 BF 8F 18 05 B6 8F 14 05 B5 8F 10 05 B4 8F 0C 05 B3 8F 08 05 B2 8F 04 05 B1 8F 00 05 B0 8F 08 00 E0 03 20 05 BD 27 }
	condition:
		$1
}

rule file_5_26_0 {
	meta:
		name = "override_config_data"
		size = 28
		refs = "0004 .bss 0014 .text"
		altNames = "set_config_data"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C 21 30 A0 00 ?? ?? 84 24 21 28 40 00 ?? ?? ?? 0? 21 38 00 00 }
	condition:
		$1
}

rule file_5_28_0 {
	meta:
		name = "get_config_argv"
		size = 764
		refs = "0030 get_config_string 0040 .bss 0048 _al_free 0054 ustrsizez 007c ustrzcpy 0080 ugetc 00b0 uisspace 00c8 usetat 00d0 ucwidth 0100 _al_malloc 026c .text 02bc _al_sane_realloc 02cc allegro_errno"
	strings:
		$1 = { D0 FF BD 27 00 00 A6 AF 21 30 00 00 08 00 B0 AF 2C 00 BF AF 28 00 BE AF 24 00 B7 AF 20 00 B6 AF 1C 00 B5 AF 18 00 B4 AF 14 00 B3 AF 10 00 B2 AF ?? ?? ?? 0? 0C 00 B1 AF AC 00 40 10 21 80 40 00 ?? ?? 1E 3C ?? ?? C4 8F ?? ?? ?? 0? ?? ?? 11 3C 21 20 00 02 ?? ?? ?? 0? ?? ?? C0 AF 21 18 40 00 ?? ?? 22 8E 2A 10 43 00 92 00 40 14 ?? ?? 12 3C ?? ?? 25 8E ?? ?? 44 8E 21 30 00 02 ?? ?? ?? 0? ?? ?? 14 3C ?? ?? 83 8E 09 F8 60 00 ?? ?? 44 8E 96 00 40 10 21 80 40 00 23 00 02 24 93 00 02 12 21 88 00 00 21 B0 00 00 ?? ?? 15 3C 23 00 17 24 ?? ?? ?? 0? 21 20 00 02 4A 00 40 10 ?? ?? 44 8E 21 28 00 00 21 30 00 00 ?? ?? ?? 0? 21 20 91 00 ?? ?? A3 8E 09 F8 60 00 21 20 00 00 ?? ?? 44 8E ?? ?? 83 8E 21 88 22 02 09 F8 60 00 21 20 91 00 EF FF 40 14 21 80 40 00 7D 00 C0 12 00 00 A2 8F ?? ?? ?? 0? 80 20 16 00 ?? ?? 83 8E ?? ?? 44 8E ?? ?? C2 AF 09 F8 60 00 21 80 00 00 21 28 40 00 21 98 00 00 0B 00 40 14 ?? ?? 11 3C ?? ?? 23 8E 09 F8 60 00 21 20 00 00 ?? ?? 44 8E ?? ?? 83 8E 21 80 02 02 09 F8 60 00 21 20 90 00 F7 FF 40 10 21 28 40 00 ?? ?? 42 8E ?? ?? C3 8F 80 20 13 00 21 10 50 00 21 18 64 00 00 00 62 AC ?? ?? 23 8E 09 F8 60 00 21 20 A0 00 ?? ?? 44 8E ?? ?? 83 8E 21 80 02 02 09 F8 60 00 21 20 90 00 F7 FF 40 14 21 28 40 00 01 00 73 26 2A 10 76 02 E4 FF 40 14 ?? ?? 23 8E 00 00 A2 8F ?? ?? C4 8F 00 00 56 AC 2C 00 BF 8F 21 10 80 00 28 00 BE 8F 24 00 B7 8F 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 E0 03 30 00 BD 27 1D 00 17 12 27 00 02 24 21 00 02 12 01 00 D6 26 22 00 02 24 1F 00 02 12 ?? ?? 44 8E 21 10 00 02 21 98 00 00 BB FF 40 10 00 00 00 00 0E 00 60 12 21 80 40 00 12 00 13 12 ?? ?? A3 8E 09 F8 60 00 21 20 00 02 ?? ?? 44 8E ?? ?? 83 8E 21 88 22 02 09 F8 60 00 21 20 91 00 AE FF 40 10 21 80 40 00 F4 FF 60 16 00 00 00 00 ?? ?? ?? 0? 21 20 00 02 F2 FF 40 10 ?? ?? A3 8E A6 FF 00 12 00 00 00 00 92 FF 17 16 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 ?? ?? 44 8E 21 28 00 00 21 30 00 00 ?? ?? ?? 0? 21 20 91 00 ?? ?? A3 8E 21 20 00 00 09 F8 60 00 21 98 00 02 ?? ?? 44 8E ?? ?? 83 8E 21 88 51 00 09 F8 60 00 21 20 91 00 ?? ?? ?? 0? 00 00 00 00 ?? ?? 44 8E 21 28 60 00 ?? ?? ?? 0? ?? ?? 23 AE 6A FF 40 14 ?? ?? 42 AE ?? ?? 02 3C ?? ?? 43 8C 0C 00 02 24 21 20 00 00 00 00 62 AC 00 00 A2 8F ?? ?? ?? 0? 00 00 40 AC 00 00 A2 8F 21 20 00 00 ?? ?? ?? 0? 00 00 40 AC }
	condition:
		$1
}

rule file_5_29_0 {
	meta:
		name = "set_config_id"
		size = 340
		refs = "0084 usetc 00b0 set_config_string 00e0 $LC11 00fc uconvert 0114 uszprintf"
	strings:
		$1 = { 90 FF BD 27 00 01 C2 28 68 00 B6 AF 64 00 B5 AF 50 00 B0 AF 6C 00 BF AF 60 00 B4 AF 5C 00 B3 AF 58 00 B2 AF 54 00 B1 AF 21 80 C0 00 21 A8 80 00 2B 00 40 14 21 B0 A0 00 FF 00 C5 30 02 16 06 00 00 3C C3 7C 00 3A C4 7C 00 00 A2 AF 04 00 A3 AF 08 00 A4 AF 0C 00 A5 AF 21 80 A0 03 21 88 00 00 10 00 B2 27 ?? ?? 13 3C 20 00 14 24 00 00 02 8E 21 20 51 02 04 00 10 26 07 00 40 10 21 28 40 00 05 00 54 10 ?? ?? 63 8E 09 F8 60 00 00 00 00 00 F6 FF 50 16 21 88 22 02 ?? ?? 63 8E 21 20 51 02 09 F8 60 00 21 28 00 00 21 20 A0 02 21 28 C0 02 ?? ?? ?? 0? 21 30 40 02 6C 00 BF 8F 68 00 B6 8F 64 00 B5 8F 60 00 B4 8F 5C 00 B3 8F 58 00 B2 8F 54 00 B1 8F 50 00 B0 8F 08 00 E0 03 70 00 BD 27 ?? ?? 04 3C 53 41 05 3C 75 63 07 3C 30 00 A6 27 20 00 08 24 ?? ?? 84 24 38 43 A5 34 ?? ?? ?? 0? 2E 72 E7 34 10 00 B2 27 21 38 00 02 21 20 40 02 21 30 40 00 ?? ?? ?? 0? 20 00 05 24 21 20 A0 02 21 28 C0 02 ?? ?? ?? 0? 21 30 40 02 6C 00 BF 8F 68 00 B6 8F 64 00 B5 8F 60 00 B4 8F 5C 00 B3 8F 58 00 B2 8F 54 00 B1 8F 50 00 B0 8F 08 00 E0 03 70 00 BD 27 }
	condition:
		$1
}

rule file_5_30_0 {
	meta:
		name = "set_config_float"
		size = 152
		refs = "0020 $LC12 0040 uconvert 004c __extendsfdf2 0064 uszprintf 0074 set_config_string"
	strings:
		$1 = { A8 FF BD 27 48 00 B2 AF 44 00 B1 AF 54 00 B4 E7 21 88 80 00 06 65 00 46 21 90 A0 00 75 63 07 3C ?? ?? 04 3C 53 41 05 3C 2E 72 E7 34 20 00 A6 27 ?? ?? 84 24 38 43 A5 34 20 00 08 24 4C 00 BF AF ?? ?? ?? 0? 40 00 B0 AF 06 A3 00 46 ?? ?? ?? 0? 21 80 40 00 21 40 40 00 21 20 A0 03 21 30 00 02 21 48 60 00 ?? ?? ?? 0? 20 00 05 24 21 20 20 02 21 28 40 02 ?? ?? ?? 0? 21 30 A0 03 4C 00 BF 8F 48 00 B2 8F 44 00 B1 8F 40 00 B0 8F 54 00 B4 C7 08 00 E0 03 58 00 BD 27 }
	condition:
		$1
}

rule file_5_31_0 {
	meta:
		name = "set_config_hex"
		size = 208
		refs = "0040 uconvert 002c $LC13 0054 uszprintf 0064 set_config_string 0084 $LC14"
	strings:
		$1 = { B0 FF BD 27 48 00 B2 AF 44 00 B1 AF 40 00 B0 AF 4C 00 BF AF 21 80 C0 00 21 88 80 00 19 00 C0 04 21 90 A0 00 53 41 05 3C 75 63 07 3C ?? ?? 04 3C 20 00 A6 27 20 00 08 24 38 43 A5 34 2E 72 E7 34 ?? ?? ?? 0? ?? ?? 84 24 21 30 40 00 21 20 A0 03 21 38 00 02 ?? ?? ?? 0? 20 00 05 24 21 20 20 02 21 28 40 02 ?? ?? ?? 0? 21 30 A0 03 4C 00 BF 8F 48 00 B2 8F 44 00 B1 8F 40 00 B0 8F 08 00 E0 03 50 00 BD 27 ?? ?? 04 3C 53 41 05 3C 75 63 07 3C 21 30 A0 03 ?? ?? 84 24 38 43 A5 34 2E 72 E7 34 ?? ?? ?? 0? 20 00 08 24 21 30 40 00 21 20 20 02 ?? ?? ?? 0? 21 28 40 02 4C 00 BF 8F 48 00 B2 8F 44 00 B1 8F 40 00 B0 8F 08 00 E0 03 50 00 BD 27 }
	condition:
		$1
}

rule file_5_32_0 {
	meta:
		name = "set_config_int"
		size = 128
		refs = "003c uconvert 001c $LC11 0050 uszprintf 0060 set_config_string"
	strings:
		$1 = { B0 FF BD 27 48 00 B2 AF 44 00 B1 AF 21 90 A0 00 21 88 80 00 53 41 05 3C 75 63 07 3C ?? ?? 04 3C 40 00 B0 AF 20 00 08 24 21 80 C0 00 38 43 A5 34 20 00 A6 27 2E 72 E7 34 4C 00 BF AF ?? ?? ?? 0? ?? ?? 84 24 21 30 40 00 21 20 A0 03 21 38 00 02 ?? ?? ?? 0? 20 00 05 24 21 20 20 02 21 28 40 02 ?? ?? ?? 0? 21 30 A0 03 4C 00 BF 8F 48 00 B2 8F 44 00 B1 8F 40 00 B0 8F 08 00 E0 03 50 00 BD 27 }
	condition:
		$1
}

rule file_5_33_0 {
	meta:
		name = "get_config_hex"
		size = 176
		refs = "0014 get_config_string 0024 ugetc 0058 ustrtol 0078 $LC15 0090 uconvert 009c ustricmp 00a8 .text"
	strings:
		$1 = { B0 FF BD 27 48 00 B1 AF 21 88 C0 00 44 00 B0 AF 4C 00 BF AF ?? ?? ?? 0? 21 30 00 00 07 00 40 10 21 80 40 00 ?? ?? 02 3C ?? ?? 43 8C 09 F8 60 00 21 20 00 02 07 00 40 54 21 20 00 02 4C 00 BF 8F 21 10 20 02 48 00 B1 8F 44 00 B0 8F 08 00 E0 03 50 00 BD 27 21 28 00 00 ?? ?? ?? 0? 10 00 06 24 21 88 40 00 FF 7F 02 3C FF FF 42 34 F4 FF 22 16 4C 00 BF 8F 75 63 07 3C ?? ?? 04 3C 53 41 05 3C 2E 72 E7 34 ?? ?? 84 24 38 43 A5 34 21 30 A0 03 ?? ?? ?? 0? 40 00 08 24 21 28 40 00 ?? ?? ?? 0? 21 20 00 02 FF FF 03 24 ?? ?? ?? 0? 0B 88 62 00 }
	condition:
		$1
}

rule file_5_34_0 {
	meta:
		name = "get_config_int"
		size = 276
		refs = "0020 .text 0028 .bss 004c ustricmp 0094 get_config_string 00a4 ugetc 00c4 ustrtol"
	strings:
		$1 = { F0 FE BD 27 08 01 B2 AF 04 01 B1 AF 21 90 C0 00 21 88 A0 00 00 01 06 24 00 01 B0 AF 0C 01 BF AF ?? ?? ?? 0? 21 28 A0 03 ?? ?? 02 3C ?? ?? 50 8C 06 00 00 56 00 00 05 8E ?? ?? ?? 0? 21 28 20 02 13 00 00 12 21 28 20 02 00 00 05 8E ?? ?? ?? 0? 21 20 A0 03 FA FF 40 54 10 00 10 8E 04 00 02 8E 22 00 40 10 21 28 40 02 09 F8 40 00 21 20 20 02 21 90 40 00 0C 01 BF 8F 21 10 40 02 08 01 B2 8F 04 01 B1 8F 00 01 B0 8F 08 00 E0 03 10 01 BD 27 21 20 A0 03 ?? ?? ?? 0? 21 30 00 00 F5 FF 40 10 21 80 40 00 ?? ?? 02 3C ?? ?? 43 8C 09 F8 60 00 21 20 00 02 F0 FF 40 10 0C 01 BF 8F 21 20 00 02 21 28 00 00 ?? ?? ?? 0? 21 30 00 00 0C 01 BF 8F 21 90 40 00 21 10 40 02 08 01 B2 8F 04 01 B1 8F 00 01 B0 8F 08 00 E0 03 10 01 BD 27 08 00 02 8E E1 FF 40 10 0C 01 BF 8F 21 20 20 02 09 F8 40 00 21 28 00 00 E7 FF 40 14 21 80 40 00 ?? ?? ?? 0? 0C 01 BF 8F }
	condition:
		$1
}

rule file_5_35_0 {
	meta:
		name = "get_config_id"
		size = 276
		refs = "0018 get_config_string 0028 ugetc 0060 ustrtol 009c ugetat 00b8 utoupper"
	strings:
		$1 = { E8 FF BD 27 08 00 B0 AF 21 80 C0 00 21 30 00 00 0C 00 B1 AF 14 00 BF AF ?? ?? ?? 0? 10 00 B2 AF 07 00 40 10 21 88 40 00 ?? ?? 12 3C ?? ?? 43 8E 09 F8 60 00 21 20 40 00 08 00 40 54 21 20 20 02 14 00 BF 8F 21 10 00 02 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 E0 03 18 00 BD 27 04 00 A5 27 ?? ?? ?? 0? 21 30 00 00 ?? ?? 43 8E 04 00 A4 8F 09 F8 60 00 21 80 40 00 F1 FF 40 10 20 00 02 24 00 00 A2 A3 03 00 A2 A3 02 00 A2 A3 01 00 A2 A3 21 80 00 00 04 00 12 24 21 28 00 02 ?? ?? ?? 0? 21 20 20 02 21 28 00 02 09 00 40 10 21 20 20 02 ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 21 20 40 00 21 18 B0 03 01 00 10 26 F3 FF 12 16 00 00 62 A0 00 00 A2 83 01 00 A3 83 03 00 A5 83 02 00 A4 83 00 16 02 00 00 1C 03 00 25 10 43 00 14 00 BF 8F 25 10 45 00 00 22 04 00 25 80 44 00 21 10 00 02 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_5_36_0 {
	meta:
		name = "get_config_float"
		size = 132
		refs = "0014 get_config_string 0024 ugetc 0054 uatof 0060 __truncdfsf2"
	strings:
		$1 = { F0 FF BD 27 21 30 00 00 00 00 B0 AF 0C 00 B4 E7 04 00 BF AF ?? ?? ?? 0? 06 65 00 46 07 00 40 10 21 80 40 00 ?? ?? 02 3C ?? ?? 43 8C 09 F8 60 00 21 20 00 02 07 00 40 14 00 00 00 00 04 00 BF 8F 06 A0 00 46 00 00 B0 8F 0C 00 B4 C7 08 00 E0 03 10 00 BD 27 ?? ?? ?? 0? 21 20 00 02 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 04 00 BF 8F 06 05 00 46 00 00 B0 8F 06 A0 00 46 0C 00 B4 C7 08 00 E0 03 10 00 BD 27 }
	condition:
		$1
}

rule file_6_0_0 {
	meta:
		name = "set_mixer_quality"
		size = 40
		refs = "0000 .bss 001c _sound_hq"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 43 8C 03 00 85 2C 02 00 02 24 0A 20 45 00 01 00 63 38 0A 20 03 00 ?? ?? 02 3C 08 00 E0 03 ?? ?? 44 AC }
	condition:
		$1
}

rule file_6_7_0 {
	meta:
		name = "update_mixer_volume"
		size = 224
		refs = "001c .data 0024 _sound_hq"
	strings:
		$1 = { 14 00 A6 8C 08 00 A7 8C FF 00 05 24 03 33 06 00 03 3B 07 00 18 00 C7 00 23 28 A6 00 ?? ?? 02 3C ?? ?? 49 8C ?? ?? 02 3C ?? ?? 4A 8C FF FF 08 34 21 58 80 00 12 30 00 00 C3 19 06 00 21 18 66 00 18 00 A7 00 40 18 03 00 07 18 23 01 27 10 03 00 C3 17 02 00 24 10 43 00 23 10 48 00 C3 1F 02 00 24 18 62 00 21 30 68 00 28 00 86 AC FF FF 03 3C 01 00 63 34 12 28 00 00 C3 11 05 00 21 10 45 00 40 10 02 00 07 10 22 01 27 20 02 00 C3 27 04 00 24 20 82 00 21 20 83 00 C3 17 04 00 24 10 44 00 21 20 48 00 0C 00 40 15 24 00 64 AD 00 08 02 24 02 00 40 14 1A 00 C2 00 CD 01 00 00 12 18 00 00 28 00 63 AD 02 00 40 14 1A 00 82 00 CD 01 00 00 12 10 00 00 24 00 62 AD 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_6_8_0 {
	meta:
		name = "set_volume_per_voice"
		size = 192
		refs = "0020 .bss 0028 .data 0038 _phys_voice 0054 .text"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF 10 00 B4 AF 0C 00 B3 AF 08 00 B2 AF 04 00 B1 AF 1B 00 80 04 00 00 B0 AF ?? ?? 06 3C ?? ?? D2 8C ?? ?? 02 3C 0E 00 40 1A ?? ?? 44 AC ?? ?? 02 3C ?? ?? 03 3C ?? ?? 54 24 ?? ?? 73 24 21 88 00 00 21 80 00 00 21 20 90 02 21 28 70 02 ?? ?? ?? 0? 01 00 31 26 2A 10 32 02 FA FF 40 14 2C 00 10 26 14 00 BF 8F 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 18 00 BD 27 ?? ?? 06 3C ?? ?? C5 8C 02 00 A2 28 08 00 40 14 01 00 03 24 01 00 04 24 40 18 03 00 2A 10 65 00 FD FF 40 14 01 00 84 24 ?? ?? ?? 0? ?? ?? D2 8C ?? ?? ?? 0? 02 00 04 24 }
	condition:
		$1
}

rule file_6_9_0 {
	meta:
		name = "update_mixer"
		size = 392
		refs = "012c .bss 0058 .text"
	strings:
		$1 = { 0C 00 A3 8C F0 FF BD 27 08 00 B1 AF 04 00 B0 AF 0C 00 BF AF 21 80 A0 00 2E 00 60 10 21 88 80 00 08 00 A2 8C 21 10 62 00 45 00 60 18 08 00 A2 AC 10 00 A3 8C 2A 10 43 00 04 00 40 54 18 00 03 8E 08 00 03 AE 0C 00 00 AE 18 00 03 8E 25 00 60 54 14 00 02 8E 21 20 20 02 ?? ?? ?? 0? 21 28 00 02 24 00 02 8E 17 00 40 10 0C 00 BF 8F 20 00 03 8E 21 18 43 00 28 00 40 18 20 00 03 AE 28 00 04 8E 2A 10 64 00 2B 00 40 50 20 00 04 AE ?? ?? 02 3C ?? ?? 44 8C 03 19 03 00 04 00 02 8E 02 00 80 14 1A 00 64 00 CD 01 00 00 02 00 42 30 12 18 00 00 03 00 40 10 14 00 23 AE 23 10 03 00 14 00 22 AE 0C 00 BF 8F 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 10 00 BD 27 18 00 A3 8C E2 FF 60 50 24 00 02 8E 14 00 02 8E 21 10 62 00 1E 00 60 18 14 00 02 AE 1C 00 03 8E 2A 10 43 00 D7 FF 40 14 21 20 20 02 14 00 03 AE 18 00 00 AE ?? ?? ?? 0? 21 28 00 02 ?? ?? ?? 0? 24 00 02 8E DD FF 40 10 ?? ?? 02 3C 28 00 04 8E 2A 10 83 00 D9 FF 40 14 ?? ?? 02 3C 20 00 04 AE 24 00 00 AE ?? ?? ?? 0? 21 18 80 00 C2 FF 60 50 18 00 03 8E 10 00 A3 8C 2A 10 62 00 BE FF 40 54 18 00 03 8E 08 00 03 AE ?? ?? ?? 0? 0C 00 00 AE BC FF 60 10 21 20 20 02 1C 00 03 8E 2A 10 62 00 B8 FF 40 14 00 00 00 00 14 00 03 AE ?? ?? ?? 0? 18 00 00 AE }
	condition:
		$1
}

rule file_6_10_0 {
	meta:
		name = "update_silent_mixer"
		size = 244
		refs = "00ac .bss 00c8 .text"
	strings:
		$1 = { 18 00 A7 8C 21 40 80 00 0B 00 E0 10 03 31 06 00 18 00 C7 00 14 00 A2 8C 12 18 00 00 21 10 62 00 2B 00 E0 18 14 00 A2 AC 1C 00 A4 8C 2A 10 44 00 2E 00 40 50 14 00 A4 AC 24 00 A2 8C 18 00 40 10 00 00 00 00 20 00 A3 8C 13 00 60 00 1C 00 C2 00 12 18 00 00 14 00 40 18 20 00 A3 AC 28 00 A4 8C 2A 10 64 00 17 00 40 50 20 00 A4 AC ?? ?? 02 3C ?? ?? 44 8C 03 19 03 00 04 00 A2 8C 02 00 80 14 1A 00 64 00 CD 01 00 00 02 00 42 30 12 18 00 00 03 00 40 10 14 00 03 AD 23 10 03 00 14 00 02 AD 08 00 E0 03 00 00 00 00 F1 FF 40 10 ?? ?? 02 3C 28 00 A4 8C 2A 10 83 00 ED FF 40 14 ?? ?? 02 3C 20 00 A4 AC 24 00 A0 AC ?? ?? ?? 0? 21 18 80 00 DA FF E0 50 24 00 A2 8C 1C 00 A4 8C 2A 10 82 00 D6 FF 40 54 24 00 A2 8C 14 00 A4 AC ?? ?? ?? 0? 18 00 A0 AC }
	condition:
		$1
}

rule file_6_11_0 {
	meta:
		name = "mix_hq2_8x2_samples"
		size = 1816
		refs = "01e4 .text"
	strings:
		$1 = { C0 FF BD 27 30 00 B6 AF 21 B0 A0 00 04 00 A5 8C 20 00 B2 AF 1C 00 B1 AF 01 00 A2 30 18 00 B0 AF 24 00 83 8C 21 80 80 00 3C 00 BF AF 38 00 BE AF 34 00 B7 AF 2C 00 B5 AF 28 00 B4 AF 24 00 B3 AF 21 88 C0 00 21 90 E0 00 06 00 40 10 28 00 84 8C 1C 00 0C 8E 20 00 0B 8E 2A 10 8B 01 86 00 40 14 02 00 A2 30 00 A3 03 00 00 9B 04 00 C3 F7 14 00 C3 BF 13 00 4E 00 40 12 80 FF 15 3C 10 00 0A 8E 18 00 0C 8E 0C 00 04 8E 03 12 0A 00 40 10 02 00 00 FF 83 25 21 10 82 00 2A 18 43 01 00 00 46 90 54 00 60 14 01 00 47 90 04 00 C2 8E 01 00 03 24 05 00 42 30 5B 00 43 50 1C 00 05 8E FF 00 45 31 21 58 00 00 21 18 00 00 00 14 06 00 00 01 06 24 23 20 C5 00 21 10 55 00 18 00 82 00 00 3C 07 00 21 38 F5 00 14 00 06 8E 00 00 28 8E 04 00 29 8E 21 30 CA 00 2B 50 CC 00 10 00 06 AE 12 10 00 00 21 10 4B 00 03 11 02 00 18 00 87 00 C3 37 02 00 12 20 00 00 21 20 83 00 03 21 04 00 18 00 D4 00 C3 37 04 00 12 18 00 00 10 00 A3 AF 18 00 D3 00 12 18 00 00 08 00 A3 AF 10 00 A3 8F 08 00 A5 8F 13 00 60 00 1C 00 C2 03 12 18 00 00 10 00 A3 AF 10 00 A6 8F 19 00 54 00 10 18 00 00 21 30 C3 00 21 40 06 01 13 00 A0 00 00 00 28 AE 1C 00 E4 02 12 28 00 00 08 00 A5 AF 08 00 A2 8F 19 00 93 00 10 28 00 00 21 10 45 00 21 48 22 01 99 00 40 11 04 00 29 AE FF FF 52 26 0F 00 42 32 10 00 40 10 21 20 00 02 08 00 31 26 B5 FF 40 56 10 00 0A 8E 3C 00 BF 8F 38 00 BE 8F 34 00 B7 8F 30 00 B6 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 40 00 BD 27 21 28 C0 02 ?? ?? ?? 0? 21 30 40 02 ?? ?? ?? 0? 08 00 31 26 03 00 43 90 02 00 42 90 FF 00 45 31 00 1C 03 00 00 14 02 00 21 10 55 00 18 00 45 00 21 18 75 00 12 58 00 00 18 00 65 00 ?? ?? ?? 0? 12 18 00 00 20 00 03 8E 2A 10 A3 00 A4 FF 40 50 FF 00 45 31 A2 FF 83 55 FF 00 45 31 03 12 05 00 40 10 02 00 21 10 82 00 00 00 43 90 FF 00 45 31 01 00 44 90 00 1C 03 00 21 18 75 00 18 00 65 00 00 24 04 00 21 20 95 00 12 58 00 00 18 00 85 00 ?? ?? ?? 0? 12 18 00 00 6B 00 40 10 00 9B 03 00 00 A3 04 00 C3 BF 13 00 C3 F7 14 00 80 FF 15 3C C8 FF 40 12 3C 00 BF 8F 10 00 0A 8E 18 00 04 8E 0C 00 05 8E 03 12 0A 00 40 10 02 00 00 FF 83 24 21 10 A2 00 2A 18 43 01 00 00 47 90 C2 00 60 14 01 00 46 90 04 00 C2 8E 01 00 03 24 05 00 42 30 DF 00 43 10 21 58 00 00 1C 00 0C 8E FF 00 45 31 21 18 00 00 00 14 07 00 00 01 07 24 23 20 E5 00 21 10 55 00 18 00 82 00 00 34 06 00 21 30 D5 00 14 00 0D 8E 00 00 27 8E 04 00 28 8E 21 50 AA 01 2A 48 4C 01 10 00 0A AE 12 10 00 00 21 10 4B 00 03 11 02 00 18 00 86 00 C3 37 02 00 12 20 00 00 21 20 83 00 03 21 04 00 18 00 D3 00 C3 37 04 00 12 18 00 00 10 00 A3 AF 18 00 D4 00 12 18 00 00 00 00 A3 AF 10 00 A3 8F 00 00 A5 8F 13 00 60 00 1C 00 E2 02 12 18 00 00 10 00 A3 AF 10 00 A6 8F 19 00 53 00 10 18 00 00 21 30 C3 00 21 38 E6 00 13 00 A0 00 00 00 27 AE 1C 00 C4 03 12 28 00 00 00 00 A5 AF 00 00 A2 8F 19 00 94 00 10 28 00 00 21 10 45 00 21 40 02 01 0C 00 20 11 04 00 28 AE 04 00 C4 8E 04 00 82 30 A1 00 40 50 20 00 03 8E 40 10 0C 00 23 10 4A 00 23 18 0D 00 02 00 84 38 14 00 03 AE 10 00 02 AE 04 00 C4 AE FF FF 52 26 0F 00 42 32 73 00 40 10 21 20 00 02 ?? ?? ?? 0? 08 00 31 26 3C 00 BF 8F 00 00 00 AE 38 00 BE 8F 34 00 B7 8F 30 00 B6 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 40 00 BD 27 00 A3 04 00 C3 BF 13 00 C3 F7 14 00 80 FF 15 3C 5E FF 40 12 3C 00 BF 8F 10 00 0A 8E 18 00 04 8E 0C 00 05 8E 03 12 0A 00 40 10 02 00 00 FF 83 24 21 10 A2 00 2A 18 43 01 00 00 47 90 65 00 60 14 01 00 46 90 04 00 C2 8E 01 00 03 24 05 00 42 30 80 00 43 10 21 60 00 00 20 00 0B 8E FF 00 45 31 21 18 00 00 00 14 07 00 00 01 07 24 23 20 E5 00 21 10 55 00 18 00 82 00 00 34 06 00 21 30 D5 00 14 00 0D 8E 00 00 27 8E 04 00 28 8E 21 50 AA 01 2A 48 4B 01 10 00 0A AE 12 10 00 00 21 10 4C 00 03 11 02 00 18 00 86 00 C3 37 02 00 12 20 00 00 21 20 83 00 03 21 04 00 18 00 D3 00 C3 37 04 00 12 18 00 00 10 00 A3 AF 18 00 D4 00 12 18 00 00 04 00 A3 AF 10 00 A3 8F 04 00 A5 8F 13 00 60 00 1C 00 E2 02 12 18 00 00 10 00 A3 AF 10 00 A6 8F 19 00 53 00 10 18 00 00 21 30 C3 00 21 38 E6 00 13 00 A0 00 00 00 27 AE 1C 00 C4 03 12 28 00 00 04 00 A5 AF 04 00 A2 8F 19 00 94 00 10 28 00 00 21 10 45 00 21 40 02 01 0D 00 20 15 04 00 28 AE 04 00 C4 8E 04 00 82 30 33 00 40 50 1C 00 03 8E FF FF 62 25 40 10 02 00 23 10 4A 00 23 18 0D 00 02 00 84 38 14 00 03 AE 10 00 02 AE 04 00 C4 AE FF FF 52 26 0F 00 42 32 03 00 40 10 21 20 00 02 ?? ?? ?? 0? 08 00 31 26 21 28 C0 02 ?? ?? ?? 0? 21 30 40 02 ?? ?? ?? 0? 08 00 31 26 21 28 C0 02 ?? ?? ?? 0? 21 30 40 02 ?? ?? ?? 0? 08 00 31 26 03 00 43 90 02 00 42 90 FF 00 45 31 00 1C 03 00 00 14 02 00 21 10 55 00 18 00 45 00 21 18 75 00 1C 00 0C 8E 12 58 00 00 18 00 65 00 ?? ?? ?? 0? 12 18 00 00 03 00 43 90 02 00 42 90 FF 00 45 31 00 1C 03 00 00 14 02 00 21 10 55 00 18 00 45 00 21 18 75 00 20 00 0B 8E 12 60 00 00 18 00 65 00 ?? ?? ?? 0? 12 18 00 00 23 10 4B 01 21 10 43 00 ?? ?? ?? 0? 10 00 02 AE 23 10 4C 01 21 10 43 00 ?? ?? ?? 0? 10 00 02 AE 1C 00 0C 8E 20 00 03 8E 2A 10 83 01 04 00 40 50 FF 00 45 31 10 00 83 10 03 12 0C 00 FF 00 45 31 21 58 00 00 ?? ?? ?? 0? 21 18 00 00 1C 00 03 8E 20 00 0B 8E 2A 10 6B 00 04 00 40 50 FF 00 45 31 13 00 8B 10 03 12 03 00 FF 00 45 31 21 60 00 00 ?? ?? ?? 0? 21 18 00 00 40 10 02 00 21 10 A2 00 00 00 43 90 FF 00 45 31 01 00 44 90 00 1C 03 00 21 18 75 00 18 00 65 00 00 24 04 00 21 20 95 00 12 58 00 00 18 00 85 00 ?? ?? ?? 0? 12 18 00 00 40 10 02 00 21 10 A2 00 00 00 43 90 FF 00 45 31 01 00 44 90 00 1C 03 00 21 18 75 00 18 00 65 00 00 24 04 00 21 20 95 00 12 60 00 00 18 00 85 00 ?? ?? ?? 0? 12 18 00 00 }
	condition:
		$1
}

rule file_6_12_0 {
	meta:
		name = "mix_hq2_16x1_samples"
		size = 1580
		refs = "01c0 .text"
	strings:
		$1 = { C0 FF BD 27 30 00 B6 AF 21 B0 A0 00 04 00 A5 8C 20 00 B2 AF 1C 00 B1 AF 01 00 A2 30 18 00 B0 AF 24 00 83 8C 21 80 80 00 3C 00 BF AF 38 00 BE AF 34 00 B7 AF 2C 00 B5 AF 28 00 B4 AF 24 00 B3 AF 21 88 C0 00 21 90 E0 00 06 00 40 10 28 00 84 8C 1C 00 0C 8E 20 00 0B 8E 2A 10 8B 01 6E 00 40 14 02 00 A2 30 00 A3 03 00 00 9B 04 00 C3 F7 14 00 C3 BF 13 00 45 00 40 12 80 FF 15 3C 10 00 07 8E 18 00 0A 8E 0C 00 06 8E 03 2A 07 00 40 10 05 00 00 FF 43 25 21 10 C2 00 2A 18 E3 00 54 00 60 14 00 00 44 94 04 00 C2 8E 01 00 03 24 05 00 42 30 47 00 43 50 1C 00 05 8E FF 00 E5 30 21 18 00 00 00 22 04 00 00 01 06 24 23 10 C5 00 21 20 95 00 18 00 44 00 14 00 05 8E 04 00 28 8E 00 00 29 8E 21 28 A7 00 2B 50 AA 00 10 00 05 AE 12 10 00 00 21 10 43 00 03 11 02 00 19 00 53 00 C3 27 02 00 10 38 00 00 18 00 93 00 12 18 00 00 10 00 A3 AF 18 00 94 00 12 18 00 00 08 00 A3 AF 10 00 A3 8F 13 00 60 00 1C 00 E2 02 12 18 00 00 10 00 A3 AF 08 00 A3 8F 10 00 A4 8F 13 00 60 00 21 20 87 00 21 40 04 01 1C 00 C2 03 04 00 28 AE 12 18 00 00 08 00 A3 AF 08 00 A4 8F 19 00 54 00 10 18 00 00 21 20 83 00 21 48 24 01 82 00 40 11 00 00 29 AE FF FF 52 26 0F 00 42 32 10 00 40 10 21 20 00 02 08 00 31 26 BE FF 40 56 10 00 07 8E 3C 00 BF 8F 38 00 BE 8F 34 00 B7 8F 30 00 B6 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 40 00 BD 27 21 28 C0 02 ?? ?? ?? 0? 21 30 40 02 ?? ?? ?? 0? 08 00 31 26 20 00 03 8E 2A 10 A3 00 B8 FF 40 50 FF 00 E5 30 B6 FF 43 55 FF 00 E5 30 ?? ?? ?? 0? 03 12 05 00 01 00 A2 24 40 10 02 00 21 10 C2 00 00 00 43 94 FF 00 E5 30 00 1A 03 00 21 18 75 00 18 00 65 00 ?? ?? ?? 0? 12 18 00 00 63 00 40 10 00 A3 03 00 00 9B 03 00 00 A3 04 00 C3 F7 13 00 C3 BF 14 00 80 FF 15 3C D6 FF 40 12 3C 00 BF 8F 10 00 07 8E 18 00 08 8E 0C 00 06 8E 03 2A 07 00 40 10 05 00 00 FF 03 25 21 10 C2 00 2A 18 E3 00 B1 00 60 14 00 00 44 94 04 00 C2 8E 01 00 03 24 05 00 42 30 CA 00 43 10 FF 00 E5 30 1C 00 0C 8E 21 18 00 00 00 22 04 00 00 01 06 24 23 10 C5 00 21 20 95 00 18 00 44 00 14 00 0B 8E 04 00 25 8E 00 00 28 8E 21 50 67 01 2A 48 4C 01 10 00 0A AE 12 10 00 00 21 10 43 00 03 11 02 00 19 00 54 00 C3 27 02 00 10 38 00 00 18 00 94 00 12 18 00 00 10 00 A3 AF 18 00 93 00 12 18 00 00 00 00 A3 AF 10 00 A3 8F 13 00 60 00 1C 00 E2 02 12 18 00 00 10 00 A3 AF 00 00 A3 8F 10 00 A4 8F 13 00 60 00 21 20 87 00 21 28 A4 00 1C 00 C2 03 04 00 25 AE 12 18 00 00 00 00 A3 AF 00 00 A4 8F 19 00 53 00 10 18 00 00 21 20 83 00 21 40 04 01 0C 00 20 11 00 00 28 AE 04 00 C4 8E 04 00 82 30 94 00 40 50 20 00 03 8E 40 10 0C 00 23 10 4A 00 23 18 0B 00 02 00 84 38 14 00 03 AE 10 00 02 AE 04 00 C4 AE FF FF 52 26 0F 00 42 32 6A 00 40 10 21 20 00 02 ?? ?? ?? 0? 08 00 31 26 3C 00 BF 8F 00 00 00 AE 38 00 BE 8F 34 00 B7 8F 30 00 B6 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 40 00 BD 27 00 9B 04 00 C3 BF 14 00 C3 F7 13 00 80 FF 15 3C 75 FF 40 12 3C 00 BF 8F 10 00 07 8E 18 00 08 8E 0C 00 06 8E 03 2A 07 00 40 10 05 00 00 FF 03 25 21 10 C2 00 2A 18 E3 00 5B 00 60 14 00 00 44 94 04 00 C2 8E 01 00 03 24 05 00 42 30 72 00 43 10 FF 00 E5 30 20 00 0B 8E 21 18 00 00 00 22 04 00 00 01 06 24 23 10 C5 00 21 20 95 00 18 00 44 00 14 00 0C 8E 04 00 25 8E 00 00 28 8E 21 50 87 01 2A 48 4B 01 10 00 0A AE 12 10 00 00 21 10 43 00 03 11 02 00 19 00 53 00 C3 27 02 00 10 38 00 00 18 00 93 00 12 18 00 00 10 00 A3 AF 18 00 94 00 12 18 00 00 04 00 A3 AF 10 00 A3 8F 13 00 60 00 1C 00 C2 03 12 18 00 00 10 00 A3 AF 04 00 A3 8F 10 00 A4 8F 13 00 60 00 21 20 87 00 21 28 A4 00 1C 00 E2 02 04 00 25 AE 12 18 00 00 04 00 A3 AF 04 00 A4 8F 19 00 54 00 10 18 00 00 21 20 83 00 21 40 04 01 0D 00 20 15 00 00 28 AE 04 00 C4 8E 04 00 82 30 2F 00 40 50 1C 00 03 8E FF FF 62 25 40 10 02 00 23 10 4A 00 23 18 0C 00 02 00 84 38 14 00 03 AE 10 00 02 AE 04 00 C4 AE FF FF 52 26 0F 00 42 32 03 00 40 10 21 20 00 02 ?? ?? ?? 0? 08 00 31 26 21 28 C0 02 ?? ?? ?? 0? 21 30 40 02 ?? ?? ?? 0? 08 00 31 26 21 28 C0 02 ?? ?? ?? 0? 21 30 40 02 ?? ?? ?? 0? 08 00 31 26 01 00 A2 24 40 10 02 00 21 10 C2 00 00 00 43 94 FF 00 E5 30 1C 00 0C 8E 00 1A 03 00 21 18 75 00 18 00 65 00 ?? ?? ?? 0? 12 18 00 00 01 00 A2 24 40 10 02 00 21 10 C2 00 00 00 43 94 FF 00 E5 30 20 00 0B 8E 00 1A 03 00 21 18 75 00 18 00 65 00 ?? ?? ?? 0? 12 18 00 00 23 10 4B 01 21 10 43 00 ?? ?? ?? 0? 10 00 02 AE 23 10 4C 01 21 10 43 00 ?? ?? ?? 0? 10 00 02 AE 1C 00 0C 8E 20 00 03 8E 2A 10 83 01 35 FF 40 50 21 18 00 00 15 00 03 11 03 12 0C 00 ?? ?? ?? 0? 21 18 00 00 1C 00 03 8E 20 00 0B 8E 2A 10 6B 00 8D FF 40 50 21 18 00 00 03 00 0B 11 03 12 03 00 ?? ?? ?? 0? 21 18 00 00 40 10 02 00 21 10 C2 00 00 00 43 94 FF 00 E5 30 00 1A 03 00 21 18 75 00 18 00 65 00 ?? ?? ?? 0? 12 18 00 00 40 10 02 00 21 10 C2 00 00 00 43 94 FF 00 E5 30 00 1A 03 00 21 18 75 00 18 00 65 00 ?? ?? ?? 0? 12 18 00 00 }
	condition:
		$1
}

rule file_6_13_0 {
	meta:
		name = "mix_hq2_16x2_samples"
		size = 1936
		refs = "01f4 .text"
	strings:
		$1 = { C0 FF BD 27 30 00 B6 AF 21 B0 A0 00 04 00 A5 8C 20 00 B2 AF 1C 00 B1 AF 01 00 A2 30 18 00 B0 AF 24 00 83 8C 21 80 80 00 3C 00 BF AF 38 00 BE AF 34 00 B7 AF 2C 00 B5 AF 28 00 B4 AF 24 00 B3 AF 21 88 C0 00 21 90 E0 00 06 00 40 10 28 00 84 8C 1C 00 0C 8E 20 00 0B 8E 2A 10 8B 01 90 00 40 14 02 00 A2 30 00 A3 03 00 00 9B 04 00 C3 BF 14 00 C3 F7 13 00 52 00 40 12 80 FF 15 3C 10 00 0A 8E 18 00 0B 8E 0C 00 06 8E 03 12 0A 00 40 28 02 00 01 00 A3 24 80 10 02 00 40 18 03 00 00 FF 64 25 21 10 C2 00 21 18 C3 00 2A 20 44 01 00 00 48 94 54 00 80 14 00 00 67 94 04 00 C2 8E 01 00 03 24 05 00 42 30 61 00 43 50 1C 00 04 8E FF 00 46 31 21 18 00 00 21 28 00 00 00 12 08 00 00 01 08 24 23 20 06 01 21 10 55 00 18 00 82 00 00 3A 07 00 21 38 F5 00 14 00 06 8E 00 00 28 8E 04 00 29 8E 21 30 CA 00 2B 50 CB 00 10 00 06 AE 12 10 00 00 21 10 43 00 03 11 02 00 18 00 87 00 C3 37 02 00 12 20 00 00 21 20 85 00 03 21 04 00 18 00 D4 00 C3 37 04 00 12 18 00 00 10 00 A3 AF 18 00 D3 00 12 18 00 00 08 00 A3 AF 10 00 A3 8F 08 00 A5 8F 13 00 60 00 1C 00 E2 02 12 18 00 00 10 00 A3 AF 19 00 54 00 10 18 00 00 13 00 A0 00 1C 00 C4 03 12 28 00 00 08 00 A5 AF 10 00 A5 8F 19 00 93 00 08 00 A2 8F 21 28 A3 00 21 40 05 01 00 00 28 AE 10 28 00 00 21 10 45 00 21 48 22 01 A3 00 40 11 04 00 29 AE FF FF 52 26 0F 00 42 32 10 00 40 10 21 20 00 02 08 00 31 26 B1 FF 40 56 10 00 0A 8E 3C 00 BF 8F 38 00 BE 8F 34 00 B7 8F 30 00 B6 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 40 00 BD 27 21 28 C0 02 ?? ?? ?? 0? 21 30 40 02 ?? ?? ?? 0? 08 00 31 26 02 00 A2 24 40 10 02 00 21 10 C2 00 00 00 44 94 03 00 A3 24 40 18 03 00 00 22 04 00 21 18 C3 00 21 20 95 00 FF 00 46 31 18 00 86 00 00 00 65 94 00 2A 05 00 21 28 B5 00 12 18 00 00 18 00 A6 00 ?? ?? ?? 0? 12 28 00 00 20 00 03 8E 2A 10 83 00 9E FF 40 50 FF 00 46 31 9C FF 63 55 FF 00 46 31 03 12 04 00 80 28 02 00 21 28 C5 00 00 00 A3 94 FF 00 46 31 02 00 A4 94 00 1A 03 00 21 18 75 00 18 00 66 00 00 22 04 00 21 20 95 00 12 18 00 00 18 00 86 00 ?? ?? ?? 0? 12 28 00 00 6F 00 40 10 00 9B 03 00 00 A3 04 00 C3 BF 13 00 C3 F7 14 00 80 FF 15 3C C2 FF 40 12 3C 00 BF 8F 10 00 0A 8E 18 00 08 8E 0C 00 07 8E 03 12 0A 00 40 28 02 00 01 00 A3 24 80 10 02 00 40 18 03 00 00 FF 04 25 21 10 E2 00 21 18 E3 00 2A 20 44 01 00 00 49 94 C6 00 80 14 00 00 66 94 04 00 C2 8E 01 00 03 24 05 00 42 30 EF 00 43 10 21 18 00 00 1C 00 0C 8E FF 00 47 31 21 28 00 00 00 12 09 00 00 01 08 24 23 20 07 01 21 10 55 00 18 00 82 00 00 32 06 00 21 30 D5 00 00 00 27 8E 14 00 0B 8E 04 00 28 8E 21 50 6A 01 2A 48 4C 01 10 00 0A AE 12 10 00 00 21 10 43 00 03 11 02 00 18 00 86 00 C3 37 02 00 12 20 00 00 21 20 85 00 03 21 04 00 18 00 D3 00 C3 37 04 00 12 18 00 00 10 00 A3 AF 18 00 D4 00 12 18 00 00 00 00 A3 AF 10 00 A3 8F 00 00 A5 8F 13 00 60 00 1C 00 E2 02 12 18 00 00 10 00 A3 AF 19 00 53 00 10 18 00 00 13 00 A0 00 1C 00 C4 03 12 28 00 00 00 00 A5 AF 10 00 A5 8F 19 00 94 00 00 00 A2 8F 21 28 A3 00 21 38 E5 00 00 00 27 AE 10 28 00 00 21 10 45 00 21 40 02 01 0C 00 20 11 04 00 28 AE 04 00 C4 8E 04 00 82 30 B1 00 40 50 20 00 03 8E 40 10 0C 00 23 10 4A 00 23 18 0B 00 02 00 84 38 14 00 03 AE 10 00 02 AE 04 00 C4 AE FF FF 52 26 0F 00 42 32 77 00 40 10 21 20 00 02 ?? ?? ?? 0? 08 00 31 26 3C 00 BF 8F 00 00 00 AE 38 00 BE 8F 34 00 B7 8F 30 00 B6 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 40 00 BD 27 00 A3 04 00 C3 BF 13 00 C3 F7 14 00 80 FF 15 3C 54 FF 40 12 3C 00 BF 8F 10 00 0A 8E 18 00 08 8E 0C 00 07 8E 03 12 0A 00 40 28 02 00 01 00 A3 24 80 10 02 00 40 18 03 00 00 FF 04 25 21 10 E2 00 21 18 E3 00 2A 20 44 01 00 00 49 94 6B 00 80 14 00 00 66 94 04 00 C2 8E 01 00 03 24 05 00 42 30 8C 00 43 10 21 18 00 00 20 00 0B 8E FF 00 47 31 21 28 00 00 00 12 09 00 00 01 08 24 23 20 07 01 21 10 55 00 18 00 82 00 00 32 06 00 21 30 D5 00 00 00 27 8E 14 00 0C 8E 04 00 28 8E 21 50 8A 01 2A 48 4B 01 10 00 0A AE 12 10 00 00 21 10 43 00 03 11 02 00 18 00 86 00 C3 37 02 00 12 20 00 00 21 20 85 00 03 21 04 00 18 00 D3 00 C3 37 04 00 12 18 00 00 10 00 A3 AF 18 00 D4 00 12 18 00 00 04 00 A3 AF 10 00 A3 8F 04 00 A5 8F 13 00 60 00 1C 00 E2 02 12 18 00 00 10 00 A3 AF 19 00 53 00 10 18 00 00 13 00 A0 00 1C 00 C4 03 12 28 00 00 04 00 A5 AF 10 00 A5 8F 19 00 94 00 04 00 A2 8F 21 28 A3 00 21 38 E5 00 00 00 27 AE 10 28 00 00 21 10 45 00 21 40 02 01 0D 00 20 15 04 00 28 AE 04 00 C4 8E 04 00 82 30 3F 00 40 50 1C 00 03 8E FF FF 62 25 40 10 02 00 23 10 4A 00 23 18 0C 00 02 00 84 38 14 00 03 AE 10 00 02 AE 04 00 C4 AE FF FF 52 26 0F 00 42 32 03 00 40 10 21 20 00 02 ?? ?? ?? 0? 08 00 31 26 21 28 C0 02 ?? ?? ?? 0? 21 30 40 02 ?? ?? ?? 0? 08 00 31 26 21 28 C0 02 ?? ?? ?? 0? 21 30 40 02 ?? ?? ?? 0? 08 00 31 26 02 00 A2 24 40 10 02 00 21 10 E2 00 00 00 44 94 03 00 A3 24 40 18 03 00 00 22 04 00 21 18 E3 00 21 20 95 00 FF 00 47 31 18 00 87 00 00 00 65 94 1C 00 0C 8E 00 2A 05 00 21 28 B5 00 12 18 00 00 18 00 A7 00 ?? ?? ?? 0? 12 28 00 00 02 00 A2 24 40 10 02 00 21 10 E2 00 00 00 44 94 03 00 A3 24 40 18 03 00 00 22 04 00 21 18 E3 00 21 20 95 00 FF 00 47 31 18 00 87 00 00 00 65 94 20 00 0B 8E 00 2A 05 00 21 28 B5 00 12 18 00 00 18 00 A7 00 ?? ?? ?? 0? 12 28 00 00 23 10 4B 01 21 10 43 00 ?? ?? ?? 0? 10 00 02 AE 23 10 4C 01 21 10 43 00 ?? ?? ?? 0? 10 00 02 AE 1C 00 0C 8E 20 00 03 8E 2A 10 83 01 04 00 40 50 FF 00 47 31 10 00 03 11 03 12 0C 00 FF 00 47 31 21 18 00 00 ?? ?? ?? 0? 21 28 00 00 1C 00 03 8E 20 00 0B 8E 2A 10 6B 00 04 00 40 50 FF 00 47 31 13 00 0B 11 03 12 03 00 FF 00 47 31 21 18 00 00 ?? ?? ?? 0? 21 28 00 00 80 28 02 00 21 28 E5 00 00 00 A3 94 FF 00 47 31 02 00 A4 94 00 1A 03 00 21 18 75 00 18 00 67 00 00 22 04 00 21 20 95 00 12 18 00 00 18 00 87 00 ?? ?? ?? 0? 12 28 00 00 80 28 02 00 21 28 E5 00 00 00 A3 94 FF 00 47 31 02 00 A4 94 00 1A 03 00 21 18 75 00 18 00 67 00 00 22 04 00 21 20 95 00 12 18 00 00 18 00 87 00 ?? ?? ?? 0? 12 28 00 00 }
	condition:
		$1
}

rule file_6_14_0 {
	meta:
		name = "_mixer_init_voice"
		size = 220
		refs = "0008 .bss 0024 _phys_voice 0088 .text"
	strings:
		$1 = { 2C 00 02 24 18 00 82 00 ?? ?? 02 3C F0 FF BD 27 ?? ?? 42 24 08 00 B1 AF 01 00 06 24 04 00 B0 AF 20 00 A8 8C ?? ?? 10 3C ?? ?? 10 26 0C 00 BF AF 12 20 00 00 21 88 44 00 10 00 20 AE 10 00 A2 8C 00 00 20 AE 04 00 A7 8C 00 12 02 00 18 00 22 AE 14 00 A3 8C 02 00 02 24 0B 30 47 00 00 1A 03 00 1C 00 23 AE 18 00 A2 8C 04 00 26 AE 00 00 A3 8C 21 80 04 02 00 12 02 00 21 20 20 02 08 00 23 AE 20 00 22 AE 21 28 00 02 ?? ?? ?? 0? 0C 00 28 AE ?? ?? 03 3C 20 00 02 8E ?? ?? 64 8C 04 00 03 8E 03 11 02 00 02 00 80 14 1A 00 44 00 CD 01 00 00 02 00 63 30 12 10 00 00 03 00 60 10 14 00 22 AE 23 10 02 00 14 00 22 AE 0C 00 BF 8F 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 10 00 BD 27 }
	condition:
		$1
}

rule file_6_15_0 {
	meta:
		name = "_mixer_release_voice"
		size = 36
		refs = "0008 .bss"
	strings:
		$1 = { 2C 00 02 24 18 00 82 00 ?? ?? 03 3C ?? ?? 63 24 12 20 00 00 21 20 83 00 0C 00 80 AC 08 00 E0 03 00 00 80 AC }
	condition:
		$1
}

rule file_6_16_0 {
	meta:
		name = "_mixer_start_voice"
		size = 72
		refs = "0008 .bss"
	strings:
		$1 = { 2C 00 03 24 18 00 83 00 ?? ?? 02 3C ?? ?? 46 24 12 18 00 00 21 28 C3 00 10 00 A2 8C 18 00 A3 8C 2A 10 43 00 01 00 40 50 10 00 A0 AC 2C 00 02 24 18 00 82 00 FF FF 03 24 12 10 00 00 21 10 C2 00 08 00 E0 03 00 00 43 AC }
	condition:
		$1
}

rule file_6_17_0 {
	meta:
		name = "_mixer_stop_voice"
		size = 32
		refs = "0008 .bss"
	strings:
		$1 = { 2C 00 02 24 18 00 82 00 ?? ?? 03 3C ?? ?? 63 24 12 20 00 00 21 20 83 00 08 00 E0 03 00 00 80 AC }
	condition:
		$1
}

rule file_6_18_0 {
	meta:
		name = "_mixer_loop_voice"
		size = 100
		refs = "0008 _phys_voice 0010 .bss"
		altNames = "_mixer_set_frequency"
	strings:
		$1 = { 2C 00 02 24 18 00 82 00 ?? ?? 03 3C ?? ?? 63 24 ?? ?? 05 3C ?? ?? A7 8C ?? ?? 02 3C ?? ?? 42 24 12 20 00 00 21 18 64 00 20 00 65 8C 04 00 66 8C 21 18 44 00 03 29 05 00 02 00 E0 14 1A 00 A7 00 CD 01 00 00 02 00 C6 30 12 10 00 00 03 00 C0 10 14 00 62 AC 23 10 02 00 14 00 62 AC 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_6_19_0 {
	meta:
		name = "_mixer_get_position"
		size = 68
		refs = "0008 .bss"
	strings:
		$1 = { 2C 00 03 24 18 00 83 00 ?? ?? 02 3C ?? ?? 42 24 12 20 00 00 21 20 82 00 00 00 83 8C 03 00 60 54 18 00 82 8C 08 00 E0 03 FF FF 02 24 10 00 83 8C 2A 10 62 00 FB FF 40 10 00 00 00 00 08 00 E0 03 03 12 03 00 }
	condition:
		$1
}

rule file_6_20_0 {
	meta:
		name = "_mixer_set_position"
		size = 64
		refs = "0008 .bss"
	strings:
		$1 = { 2C 00 02 24 18 00 82 00 ?? ?? 02 3C ?? ?? 42 24 21 18 00 00 2C 28 A3 00 00 2A 05 00 12 20 00 00 21 20 82 00 18 00 83 8C 10 00 85 AC 2A 28 A3 00 01 00 A0 50 00 00 80 AC 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_6_21_0 {
	meta:
		name = "_mixer_get_volume"
		size = 36
		refs = "0008 _phys_voice"
	strings:
		$1 = { 2C 00 03 24 18 00 83 00 ?? ?? 02 3C ?? ?? 42 24 12 20 00 00 21 20 82 00 08 00 82 8C 08 00 E0 03 03 13 02 00 }
	condition:
		$1
}

rule file_6_22_0 {
	meta:
		name = "_mixer_set_volume"
		size = 40
		refs = "0008 _phys_voice 000c .bss 0020 .text"
		altNames = "_mixer_set_pan"
	strings:
		$1 = { 2C 00 02 24 18 00 82 00 ?? ?? 05 3C ?? ?? 04 3C ?? ?? A5 24 ?? ?? 84 24 12 18 00 00 21 28 A3 00 ?? ?? ?? 0? 21 20 83 00 }
	condition:
		$1
}

rule file_6_23_0 {
	meta:
		name = "_mixer_ramp_volume"
		size = 196
		refs = "0000 .bss 000c _phys_voice"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 47 8C 10 00 03 24 ?? ?? 02 3C 02 00 60 14 1A 00 E3 00 CD 01 00 00 ?? ?? 48 24 2C 00 02 24 00 33 06 00 12 38 00 00 18 00 A7 00 12 28 00 00 D0 07 A3 28 18 00 82 00 12 10 00 00 21 10 02 01 12 00 60 14 08 00 47 8C E8 03 02 24 02 00 40 14 1A 00 A2 00 CD 01 00 00 23 18 C7 00 2C 00 02 24 12 28 00 00 02 00 A0 14 1A 00 65 00 CD 01 00 00 12 18 00 00 18 00 82 00 12 10 00 00 21 10 02 01 0C 00 43 AC 08 00 E0 03 10 00 46 AC 23 18 C7 00 01 00 05 24 02 00 A0 14 1A 00 65 00 CD 01 00 00 2C 00 02 24 12 18 00 00 18 00 82 00 12 10 00 00 21 10 02 01 0C 00 43 AC 08 00 E0 03 10 00 46 AC }
	condition:
		$1
}

rule file_6_24_0 {
	meta:
		name = "_mixer_stop_volume_ramp"
		size = 32
		refs = "0008 _phys_voice"
	strings:
		$1 = { 2C 00 02 24 18 00 82 00 ?? ?? 03 3C ?? ?? 63 24 12 20 00 00 21 18 64 00 08 00 E0 03 0C 00 60 AC }
	condition:
		$1
}

rule file_6_25_0 {
	meta:
		name = "_mixer_get_frequency"
		size = 36
		refs = "0008 _phys_voice"
	strings:
		$1 = { 2C 00 03 24 18 00 83 00 ?? ?? 02 3C ?? ?? 42 24 12 20 00 00 21 20 82 00 20 00 82 8C 08 00 E0 03 03 13 02 00 }
	condition:
		$1
}

rule file_6_27_0 {
	meta:
		name = "_mixer_sweep_frequency"
		size = 196
		refs = "0000 .bss 000c _phys_voice"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 47 8C 10 00 03 24 ?? ?? 02 3C 02 00 60 14 1A 00 E3 00 CD 01 00 00 ?? ?? 48 24 2C 00 02 24 00 33 06 00 12 38 00 00 18 00 A7 00 12 28 00 00 D0 07 A3 28 18 00 82 00 12 10 00 00 21 10 02 01 12 00 60 14 20 00 47 8C E8 03 02 24 02 00 40 14 1A 00 A2 00 CD 01 00 00 23 18 C7 00 2C 00 02 24 12 28 00 00 02 00 A0 14 1A 00 65 00 CD 01 00 00 12 18 00 00 18 00 82 00 12 10 00 00 21 10 02 01 24 00 43 AC 08 00 E0 03 28 00 46 AC 23 18 C7 00 01 00 05 24 02 00 A0 14 1A 00 65 00 CD 01 00 00 2C 00 02 24 12 18 00 00 18 00 82 00 12 10 00 00 21 10 02 01 24 00 43 AC 08 00 E0 03 28 00 46 AC }
	condition:
		$1
}

rule file_6_28_0 {
	meta:
		name = "_mixer_stop_frequency_sweep"
		size = 32
		refs = "0008 _phys_voice"
	strings:
		$1 = { 2C 00 02 24 18 00 82 00 ?? ?? 03 3C ?? ?? 63 24 12 20 00 00 21 18 64 00 08 00 E0 03 24 00 60 AC }
	condition:
		$1
}

rule file_6_29_0 {
	meta:
		name = "_mixer_get_pan"
		size = 36
		refs = "0008 _phys_voice"
	strings:
		$1 = { 2C 00 02 24 18 00 82 00 ?? ?? 03 3C ?? ?? 63 24 12 20 00 00 21 18 64 00 14 00 62 8C 08 00 E0 03 03 13 02 00 }
	condition:
		$1
}

rule file_6_31_0 {
	meta:
		name = "_mixer_sweep_pan"
		size = 196
		refs = "0000 .bss 000c _phys_voice"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 47 8C 10 00 03 24 ?? ?? 02 3C 02 00 60 14 1A 00 E3 00 CD 01 00 00 ?? ?? 48 24 2C 00 02 24 00 33 06 00 12 38 00 00 18 00 A7 00 12 28 00 00 D0 07 A3 28 18 00 82 00 12 10 00 00 21 10 02 01 12 00 60 14 14 00 47 8C E8 03 02 24 02 00 40 14 1A 00 A2 00 CD 01 00 00 23 18 C7 00 2C 00 02 24 12 28 00 00 02 00 A0 14 1A 00 65 00 CD 01 00 00 12 18 00 00 18 00 82 00 12 10 00 00 21 10 02 01 18 00 43 AC 08 00 E0 03 1C 00 46 AC 23 18 C7 00 01 00 05 24 02 00 A0 14 1A 00 65 00 CD 01 00 00 2C 00 02 24 12 18 00 00 18 00 82 00 12 10 00 00 21 10 02 01 18 00 43 AC 08 00 E0 03 1C 00 46 AC }
	condition:
		$1
}

rule file_6_32_0 {
	meta:
		name = "_mixer_stop_pan_sweep"
		size = 32
		refs = "0008 _phys_voice"
	strings:
		$1 = { 2C 00 02 24 18 00 82 00 ?? ?? 03 3C ?? ?? 63 24 12 20 00 00 21 20 83 00 08 00 E0 03 18 00 80 AC }
	condition:
		$1
}

rule file_6_36_0 {
	meta:
		name = "_mix_some_samples"
		size = 11592
		refs = "0074 .bss 0060 memset 0078 .text 012c _sound_hq 00bc _phys_voice"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 07 3C ?? ?? 43 8C ?? ?? E5 8C ?? ?? 02 3C ?? ?? 42 8C 18 00 65 00 B8 FF BD 27 04 00 A4 AF 08 00 A6 AF 21 20 40 00 21 28 00 00 44 00 BF AF 40 00 BE AF 3C 00 B7 AF 38 00 B6 AF 34 00 B5 AF 30 00 B4 AF 2C 00 B3 AF 28 00 B2 AF 24 00 B1 AF 20 00 B0 AF 00 00 A2 AF 12 18 00 00 ?? ?? ?? 0? 80 30 03 00 ?? ?? 02 3C ?? ?? 43 8C 4D 00 60 18 ?? ?? 02 3C ?? ?? ?? 0? 21 A8 00 00 ?? ?? A3 8C 02 00 62 28 79 00 40 14 2C 00 02 24 18 00 A2 02 ?? ?? 03 3C ?? ?? 63 24 01 00 04 24 12 28 00 00 21 80 65 00 04 00 02 8E C5 00 44 10 08 00 06 24 08 00 02 8E 1C 01 46 10 ?? ?? 06 3C ?? ?? C6 24 ?? ?? 03 3C 21 28 C5 00 ?? ?? 67 8C 00 00 A6 8F ?? ?? ?? 0? 21 20 00 02 ?? ?? 03 3C ?? ?? 62 8C 01 00 B5 26 2A 10 A2 02 2E 00 40 10 ?? ?? 02 3C 2C 00 02 24 18 00 A2 02 ?? ?? 03 3C ?? ?? 63 24 12 28 00 00 21 38 65 00 00 00 E2 8C F3 FF 40 50 ?? ?? 03 3C ?? ?? 04 3C ?? ?? 84 24 21 40 85 00 08 00 02 8D D5 FF 40 5C ?? ?? 05 3C 0C 00 02 8D D2 FF 40 5C ?? ?? 05 3C 04 00 03 8D ?? ?? 02 3C ?? ?? 46 8C 01 00 62 30 07 00 40 50 14 00 E2 8C 1C 00 EC 8C 20 00 EB 8C 2A 10 8B 01 54 03 40 14 02 00 62 30 14 00 E2 8C 10 00 E4 8C 18 00 E3 8C 18 00 C2 00 12 10 00 00 21 10 44 00 2B 18 43 00 55 03 60 14 10 00 E2 AC ?? ?? 03 3C ?? ?? 62 8C 01 00 B5 26 2A 10 A2 02 D5 FF 40 14 00 00 E0 AC ?? ?? 02 3C ?? ?? 44 8C 10 00 03 24 4A 06 83 10 08 00 A2 8F BD 03 40 10 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 83 8C ?? ?? A2 8C 18 00 62 00 12 18 00 00 1A 00 60 18 00 FF 02 3C 04 00 A4 8F 01 00 48 34 21 28 64 00 FF 00 03 3C FF FF 69 34 80 00 07 3C 80 FF 06 24 00 00 A3 8F 00 00 62 8C 04 00 63 24 00 00 A3 AF 21 10 47 00 27 18 02 00 C3 1F 03 00 24 18 62 00 21 18 68 00 C3 17 03 00 24 10 43 00 21 10 49 00 03 14 02 00 26 10 46 00 00 00 82 A0 01 00 84 24 F0 FF 85 14 00 00 A3 8F 44 00 BF 8F 40 00 BE 8F 3C 00 B7 8F 38 00 B6 8F 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 48 00 BD 27 61 00 60 10 ?? ?? 03 3C 2C 00 02 24 18 00 A2 02 ?? ?? 03 3C ?? ?? 63 24 01 00 04 24 12 28 00 00 21 88 65 00 04 00 22 8E ED 01 44 10 08 00 06 24 08 00 22 8E 5C 02 46 10 ?? ?? 02 3C ?? ?? 42 24 21 B0 45 00 04 00 C4 8E ?? ?? 03 3C ?? ?? 72 8C 01 00 82 30 24 00 33 8E 0A 01 40 10 28 00 34 8E 1C 00 22 8E 20 00 23 8E 2A 10 43 00 06 01 40 10 00 00 B0 8F 02 00 82 30 50 04 40 10 00 00 00 00 7B FF 40 12 ?? ?? 03 3C 10 00 27 8E 0C 00 24 8E 00 00 06 8E 03 2A 07 00 80 18 05 00 21 20 83 00 00 00 82 94 21 28 60 00 14 00 2A 8E 00 80 42 24 18 00 53 00 04 00 04 8E 1C 00 29 8E 21 40 47 01 10 00 28 AE 2A 38 09 01 12 10 00 00 03 12 02 00 21 30 C2 00 00 00 06 AE 0C 00 23 8E 21 18 65 00 02 00 62 94 00 80 42 24 18 00 54 00 12 10 00 00 03 12 02 00 21 20 82 00 0C 00 E0 10 04 00 04 AE 04 00 C3 8E 40 10 09 00 23 30 09 01 02 00 65 38 04 00 63 30 23 10 48 00 D2 04 60 10 23 20 0A 00 14 00 24 AE 10 00 22 AE 04 00 C5 AE FF FF 52 26 0F 00 42 32 D2 FF 40 14 08 00 10 26 21 20 20 02 21 28 C0 02 ?? ?? ?? 0? 21 30 40 02 ?? ?? ?? 0? 00 00 00 00 08 00 02 8E 08 00 07 24 63 00 47 10 ?? ?? 06 3C ?? ?? C7 8C ?? ?? 08 3C 00 00 A6 8F ?? ?? 08 25 21 20 00 02 ?? ?? ?? 0? 21 28 05 01 ?? ?? ?? 0? ?? ?? 03 3C ?? ?? 62 8C 01 00 04 24 4D 01 44 10 2C 00 02 24 18 00 A2 02 ?? ?? 03 3C ?? ?? 63 24 12 28 00 00 21 88 65 00 04 00 22 8E 68 02 44 10 08 00 04 24 08 00 22 8E B2 02 44 10 ?? ?? 02 3C ?? ?? 42 24 21 B0 45 00 28 00 23 8E 24 00 22 8E 04 00 C5 8E ?? ?? 06 3C ?? ?? C6 24 80 12 02 00 80 1A 03 00 ?? ?? 07 3C 01 00 A4 30 21 98 C2 00 21 A0 C3 00 06 00 80 10 ?? ?? F2 8C 1C 00 22 8E 20 00 23 8E 2A 10 43 00 D5 02 40 14 02 00 A2 30 00 00 B0 8F 14 FF 40 12 FF FF 52 26 10 00 29 8E 0C 00 24 8E 00 00 06 8E 03 2A 09 00 80 18 05 00 21 20 83 00 00 00 82 94 21 28 60 00 14 00 24 8E 02 12 02 00 80 10 02 00 21 10 62 02 00 00 43 8C 04 00 07 8E 18 00 28 8E 21 30 C3 00 00 00 06 AE 0C 00 23 8E 21 20 89 00 21 18 65 00 02 00 62 94 2B 40 88 00 0F 00 45 32 02 12 02 00 80 10 02 00 21 10 82 02 00 00 43 8C 10 00 24 AE 21 38 E3 00 04 00 07 AE 12 00 00 11 08 00 10 26 DD FF A0 14 21 20 20 02 21 28 C0 02 ?? ?? ?? 0? 21 30 40 02 ?? ?? ?? 0? 00 00 00 00 ?? ?? 08 3C ?? ?? 07 8D ?? ?? 02 3C 00 00 A6 8F ?? ?? 42 24 21 20 00 02 ?? ?? ?? 0? 21 28 45 00 ?? ?? ?? 0? ?? ?? 03 3C ?? ?? ?? 0? 00 00 20 AE ?? ?? 08 3C ?? ?? 08 25 21 B0 05 01 04 00 C5 8E ?? ?? 02 3C ?? ?? 52 8C 01 00 A2 30 24 00 03 8E 87 00 40 10 28 00 04 8E 1C 00 0C 8E 20 00 0B 8E 2A 10 8B 01 83 00 40 10 00 00 B1 8F 02 00 A2 30 DE 03 40 10 00 9B 03 00 00 00 B1 8F 00 A3 04 00 C3 BF 13 00 C3 F7 14 00 CA FE 40 12 ?? ?? 03 3C 10 00 06 8E 18 00 05 8E 0C 00 07 8E 03 1A 06 00 00 FF A2 24 21 18 E3 00 2A 10 C2 00 31 04 40 14 00 00 64 90 04 00 C2 8E 01 00 03 24 05 00 42 30 31 05 43 10 21 18 00 00 1C 00 0C 8E FF 00 C5 30 00 01 07 24 80 FF 08 3C 00 24 04 00 23 10 E5 00 21 20 88 00 18 00 44 00 04 00 25 8E 14 00 0B 8E 00 00 28 8E 21 50 66 01 2A 48 4C 01 10 00 0A AE 12 10 00 00 21 10 43 00 03 11 02 00 19 00 54 00 C3 27 02 00 10 38 00 00 18 00 94 00 12 18 00 00 18 00 A3 AF 18 00 93 00 12 18 00 00 0C 00 A3 AF 18 00 A3 8F 13 00 60 00 1C 00 C2 03 12 18 00 00 18 00 A3 AF 0C 00 A3 8F 18 00 A4 8F 13 00 60 00 21 20 87 00 21 28 A4 00 1C 00 E2 02 04 00 25 AE 12 18 00 00 0C 00 A3 AF 0C 00 A4 8F 19 00 53 00 10 18 00 00 21 20 83 00 21 40 04 01 0C 00 20 11 00 00 28 AE 04 00 C4 8E 04 00 82 30 0E 04 40 50 20 00 03 8E 40 10 0C 00 23 10 4A 00 23 18 0B 00 02 00 84 38 14 00 03 AE 10 00 02 AE 04 00 C4 AE FF FF 52 26 0F 00 42 32 87 03 40 10 21 20 00 02 ?? ?? ?? 0? 08 00 31 26 00 00 B0 8F 78 FE 40 12 FF FF 52 26 10 00 28 8E 0C 00 24 8E 00 00 06 8E 03 2A 08 00 80 10 05 00 21 20 82 00 00 00 83 94 21 28 40 00 14 00 22 8E 00 80 63 24 18 00 73 00 18 00 27 8E 21 10 48 00 10 00 22 AE 2B 38 47 00 04 00 04 8E 0F 00 48 32 12 18 00 00 03 1A 03 00 21 30 C3 00 00 00 06 AE 0C 00 23 8E 21 18 65 00 02 00 62 94 00 80 42 24 18 00 54 00 12 10 00 00 03 12 02 00 21 20 82 00 04 00 04 AE 76 FF E0 10 08 00 10 26 DD FF 00 15 21 20 20 02 21 28 C0 02 ?? ?? ?? 0? 21 30 40 02 ?? ?? ?? 0? 00 00 00 00 00 00 B1 8F 00 A3 03 00 00 9B 04 00 C3 F7 14 00 C3 BF 13 00 4B FE 40 12 ?? ?? 03 3C 10 00 06 8E 18 00 07 8E 0C 00 05 8E 03 1A 06 00 00 FF E2 24 21 18 A3 00 2A 10 C2 00 50 00 40 14 00 00 64 90 04 00 C2 8E 01 00 08 24 05 00 42 30 3B 00 48 50 1C 00 08 8E FF 00 C5 30 21 18 00 00 00 01 08 24 23 10 05 01 00 24 04 00 80 FF 05 3C 21 20 85 00 18 00 44 00 14 00 05 8E 04 00 28 8E 00 00 29 8E 21 28 A6 00 2B 50 A7 00 10 00 05 AE 12 10 00 00 21 10 43 00 03 11 02 00 19 00 53 00 C3 27 02 00 10 38 00 00 18 00 93 00 12 18 00 00 18 00 A3 AF 18 00 94 00 12 18 00 00 14 00 A3 AF 18 00 A3 8F 13 00 60 00 1C 00 E2 02 12 18 00 00 18 00 A3 AF 14 00 A3 8F 18 00 A4 8F 13 00 60 00 21 20 87 00 21 40 04 01 1C 00 C2 03 04 00 28 AE 12 18 00 00 14 00 A3 AF 14 00 A4 8F 19 00 54 00 10 18 00 00 21 20 83 00 21 48 24 01 92 01 40 11 00 00 29 AE FF FF 52 26 0F 00 42 32 03 00 40 10 21 20 00 02 ?? ?? ?? 0? 08 00 31 26 21 28 C0 02 ?? ?? ?? 0? 21 30 40 02 ?? ?? ?? 0? 08 00 31 26 20 00 03 8E 2A 10 03 01 C4 FF 40 50 FF 00 C5 30 C2 FF E3 54 FF 00 C5 30 03 12 08 00 21 10 A2 00 00 00 43 90 80 FF 02 3C FF 00 C5 30 00 1C 03 00 21 18 62 00 18 00 65 00 ?? ?? ?? 0? 12 18 00 00 01 00 62 90 80 FF 03 3C FF 00 C5 30 00 14 02 00 21 10 43 00 18 00 45 00 ?? ?? ?? 0? 12 18 00 00 18 00 A2 02 ?? ?? 03 3C ?? ?? 63 24 01 00 04 24 12 28 00 00 21 88 65 00 04 00 22 8E D5 03 44 10 08 00 06 24 08 00 22 8E FD 04 46 10 ?? ?? 03 3C ?? ?? 63 24 21 B0 65 00 24 00 22 8E 28 00 23 8E 04 00 C5 8E 43 10 02 00 43 18 03 00 ?? ?? 06 3C ?? ?? C6 24 80 12 02 00 80 1A 03 00 ?? ?? 07 3C 01 00 A4 30 21 A0 C2 00 21 98 C3 00 29 02 80 14 ?? ?? F2 8C 00 00 B0 8F CA FD 40 12 FF FF 52 26 10 00 28 8E 0C 00 24 8E 00 00 09 8E 03 32 08 00 80 18 06 00 21 20 83 00 00 00 82 94 21 30 60 00 14 00 24 8E 02 12 02 00 80 10 02 00 21 10 82 02 00 00 45 8C 18 00 27 8E 21 20 88 00 21 28 A9 00 00 00 05 AE 0C 00 23 8E 2B 38 87 00 21 18 66 00 02 00 62 94 0F 00 46 32 10 00 24 AE 02 12 02 00 80 10 02 00 21 10 62 02 00 00 43 8C 21 18 65 00 00 00 03 AE C9 FE E0 10 04 00 10 26 DE FF C0 14 21 20 20 02 21 28 C0 02 ?? ?? ?? 0? 21 30 40 02 ?? ?? ?? 0? 00 00 00 00 08 00 22 8E 08 00 03 24 2A 03 43 10 ?? ?? 02 3C ?? ?? 42 24 21 B0 45 00 04 00 C4 8E ?? ?? 03 3C ?? ?? 72 8C 01 00 82 30 24 00 33 8E 3D 00 40 10 28 00 34 8E 1C 00 22 8E 20 00 23 8E 2A 10 43 00 39 00 40 10 00 00 B0 8F 02 00 82 30 A1 05 40 10 00 00 00 00 8E FD 40 12 ?? ?? 03 3C 10 00 27 8E 0C 00 23 8E 00 00 05 8E 03 22 07 00 40 20 04 00 21 18 64 00 00 00 62 94 14 00 2A 8E 04 00 06 8E 00 80 42 24 18 00 53 00 1C 00 29 8E 21 40 47 01 10 00 28 AE 2A 38 09 01 12 10 00 00 03 12 02 00 21 28 A2 00 00 00 05 AE 0C 00 23 8E 21 18 64 00 00 00 62 94 00 80 42 24 18 00 54 00 12 10 00 00 03 12 02 00 21 30 C2 00 0C 00 E0 10 04 00 06 AE 04 00 C3 8E 40 10 09 00 23 30 09 01 02 00 65 38 04 00 63 30 23 10 48 00 34 06 60 10 23 20 0A 00 14 00 24 AE 10 00 22 AE 04 00 C5 AE FF FF 52 26 0F 00 42 32 D3 FF 40 14 08 00 10 26 21 20 20 02 21 28 C0 02 ?? ?? ?? 0? 21 30 40 02 ?? ?? ?? 0? 00 00 00 00 00 00 B0 8F 58 FD 40 12 FF FF 52 26 10 00 29 8E 0C 00 23 8E 00 00 06 8E 03 2A 09 00 40 28 05 00 21 18 65 00 00 00 62 94 14 00 24 8E 04 00 08 8E 00 80 42 24 18 00 53 00 18 00 27 8E 21 20 89 00 2B 38 87 00 0F 00 49 32 10 00 24 AE 12 10 00 00 03 12 02 00 21 30 C2 00 00 00 06 AE 0C 00 23 8E 21 18 65 00 00 00 62 94 00 80 42 24 18 00 54 00 12 10 00 00 03 12 02 00 21 40 02 01 04 00 08 AE 57 FE E0 10 08 00 10 26 DE FF 20 15 21 20 20 02 21 28 C0 02 ?? ?? ?? 0? 21 30 40 02 ?? ?? ?? 0? 00 00 00 00 ?? ?? 07 3C ?? ?? E7 24 21 B0 E5 00 04 00 C4 8E ?? ?? 08 3C ?? ?? 12 8D 01 00 82 30 24 00 33 8E 3B 00 40 10 28 00 34 8E 1C 00 22 8E 20 00 23 8E 2A 10 43 00 37 00 40 10 00 00 B0 8F 02 00 82 30 67 05 40 10 00 00 00 00 1F FD 40 12 ?? ?? 03 3C 10 00 27 8E 0C 00 22 8E 00 00 05 8E 03 22 07 00 40 20 04 00 21 10 44 00 00 00 43 90 14 00 2A 8E 04 00 06 8E 80 FF 63 24 18 00 73 00 1C 00 29 8E 21 38 47 01 2A 40 E9 00 12 18 00 00 21 28 A3 00 00 00 05 AE 0C 00 22 8E 21 10 44 00 01 00 43 90 10 00 27 AE 80 FF 63 24 18 00 74 00 12 18 00 00 21 30 C3 00 0C 00 00 11 04 00 06 AE 04 00 C3 8E 40 10 09 00 23 30 E9 00 02 00 65 38 04 00 63 30 23 10 47 00 CF 05 60 10 23 20 0A 00 14 00 24 AE 10 00 22 AE 04 00 C5 AE FF FF 52 26 0F 00 42 32 D5 FF 40 14 08 00 10 26 21 20 20 02 21 28 C0 02 ?? ?? ?? 0? 21 30 40 02 ?? ?? ?? 0? 00 00 00 00 00 00 B0 8F EB FC 40 12 FF FF 52 26 10 00 29 8E 0C 00 22 8E 00 00 06 8E 03 2A 09 00 40 28 05 00 21 10 45 00 00 00 43 90 14 00 24 8E 04 00 08 8E 80 FF 63 24 18 00 73 00 18 00 27 8E 21 20 89 00 2B 38 87 00 0F 00 49 32 12 18 00 00 21 30 C3 00 00 00 06 AE 0C 00 22 8E 21 10 45 00 01 00 43 90 10 00 24 AE 80 FF 63 24 18 00 74 00 12 18 00 00 21 40 03 01 04 00 08 AE EC FD E0 10 08 00 10 26 E0 FF 20 15 21 20 20 02 21 28 C0 02 ?? ?? ?? 0? 21 30 40 02 ?? ?? ?? 0? 00 00 00 00 08 00 22 8E 08 00 08 24 73 03 48 10 ?? ?? 08 3C ?? ?? 08 25 21 B0 05 01 24 00 22 8E 28 00 23 8E 04 00 C5 8E ?? ?? 06 3C ?? ?? C6 24 80 12 02 00 80 1A 03 00 ?? ?? 07 3C 01 00 A4 30 21 A0 C2 00 21 98 C3 00 D3 00 80 14 ?? ?? F2 8C 00 00 B0 8F B1 FC 40 12 FF FF 52 26 10 00 29 8E 0C 00 23 8E 00 00 06 8E 03 2A 09 00 40 28 05 00 21 18 65 00 00 00 62 94 14 00 24 8E 04 00 08 8E 02 12 02 00 80 10 02 00 21 10 82 02 00 00 43 8C 18 00 27 8E 21 20 89 00 21 30 C3 00 00 00 06 AE 0C 00 23 8E 2B 38 87 00 21 18 65 00 00 00 62 94 0F 00 45 32 10 00 24 AE 02 12 02 00 80 10 02 00 21 10 62 02 00 00 43 8C 21 40 03 01 04 00 08 AE B0 FD E0 10 08 00 10 26 DE FF A0 14 21 20 20 02 21 28 C0 02 ?? ?? ?? 0? 21 30 40 02 ?? ?? ?? 0? 00 00 00 00 19 04 40 10 10 00 E9 8C 14 00 ED 8C 21 20 80 01 13 00 20 01 1C 00 CD 00 12 48 00 00 2A 10 2C 01 08 05 40 14 10 00 E9 AC 21 20 E0 00 ?? ?? ?? 0? 21 28 00 01 ?? ?? ?? 0? ?? ?? 03 3C ?? ?? ?? 0? 00 00 00 AE ?? ?? 06 3C ?? ?? C6 24 21 B0 C5 00 24 00 22 8E 28 00 23 8E 04 00 C5 8E ?? ?? 07 3C ?? ?? E7 24 80 12 02 00 80 1A 03 00 ?? ?? 08 3C 01 00 A4 30 21 98 E2 00 21 A0 E3 00 03 01 80 14 ?? ?? 12 8D 00 00 B0 8F 67 FC 40 12 FF FF 52 26 10 00 29 8E 0C 00 23 8E 00 00 06 8E 03 2A 09 00 40 28 05 00 21 18 65 00 00 00 62 90 14 00 24 8E 04 00 08 8E 80 10 02 00 21 10 62 02 00 00 43 8C 18 00 27 8E 21 20 89 00 21 30 C3 00 00 00 06 AE 0C 00 23 8E 2B 38 87 00 21 18 65 00 01 00 62 90 0F 00 45 32 10 00 24 AE 80 10 02 00 21 10 82 02 00 00 43 8C 21 40 03 01 04 00 08 AE 68 FD E0 10 08 00 10 26 E0 FF A0 14 21 20 20 02 21 28 C0 02 ?? ?? ?? 0? 21 30 40 02 ?? ?? ?? 0? 00 00 00 00 F3 03 40 10 00 00 B0 8F 40 FC 40 12 ?? ?? 03 3C 10 00 27 8E 0C 00 24 8E 00 00 06 8E 03 2A 07 00 80 18 05 00 21 20 83 00 00 00 82 94 }
	condition:
		$1
}

rule file_6_37_0 {
	meta:
		name = "_mixer_exit"
		size = 92
		refs = "0008 .bss 0018 _al_free"
	strings:
		$1 = { F8 FF BD 27 00 00 B0 AF ?? ?? 10 3C ?? ?? 04 8E 03 00 80 10 04 00 BF AF ?? ?? ?? 0? 00 00 00 00 ?? ?? 02 3C 04 00 BF 8F ?? ?? 03 3C ?? ?? 40 AC ?? ?? 02 3C ?? ?? 60 AC ?? ?? 40 AC ?? ?? 03 3C ?? ?? 02 3C ?? ?? 00 AE ?? ?? 60 AC 00 00 B0 8F ?? ?? 40 AC 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_6_38_0 {
	meta:
		name = "_mixer_init"
		size = 380
		refs = "0000 _sound_hq 0044 .bss 00c8 _al_malloc 0174 .text"
	strings:
		$1 = { ?? ?? 03 3C ?? ?? 62 8C E8 FF BD 27 14 00 BF AF 03 00 42 2C 10 00 B3 AF 0C 00 B2 AF 08 00 B1 AF 04 00 B0 AF 03 00 40 14 21 50 80 00 02 00 02 24 ?? ?? 62 AC 00 00 02 8D ?? ?? 09 3C 41 00 43 28 04 00 60 14 ?? ?? 22 AD 40 00 02 24 ?? ?? 22 AD 00 00 02 AD 02 00 02 24 01 00 04 24 0B 20 46 00 02 00 80 14 1A 00 44 01 CD 01 00 00 10 00 02 24 08 00 03 24 0B 18 47 00 ?? ?? 10 3C ?? ?? 12 3C ?? ?? 13 3C ?? ?? 11 3C ?? ?? 03 AE ?? ?? 02 3C ?? ?? 03 3C ?? ?? 45 AE ?? ?? 64 AE ?? ?? 42 24 ?? ?? 63 24 12 30 00 00 ?? ?? 26 AE 00 00 40 AC 0C 00 40 AC 2C 00 42 24 FD FF 62 54 00 00 40 AC 18 00 C4 00 12 20 00 00 ?? ?? ?? 0? 80 20 04 00 ?? ?? 03 3C 23 00 40 10 ?? ?? 62 AC ?? ?? 02 3C ?? ?? 4B 24 21 48 00 00 00 80 0C 24 20 00 07 24 00 01 08 24 20 00 0A 24 18 00 2C 01 80 12 09 00 21 28 62 01 00 32 09 00 21 20 00 00 12 18 00 00 02 00 E0 14 1A 00 67 00 CD 01 00 00 01 00 84 24 21 18 66 00 12 10 00 00 00 12 02 00 00 00 A2 AC F7 FF 88 14 04 00 A5 24 01 00 29 25 EF FF 2A 15 18 00 2C 01 21 10 00 00 14 00 BF 8F 10 00 B3 8F 0C 00 B2 8F 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 18 00 BD 27 ?? ?? 20 AE ?? ?? 40 AE ?? ?? 60 AE ?? ?? 00 AE ?? ?? ?? 0? FF FF 02 24 }
	condition:
		$1
}

rule file_7_0_0 {
	meta:
		name = "_poly_zbuf_flat16"
		size = 80
		refs = "0010 .text"
		altNames = "_poly_zbuf_flat15"
	strings:
		$1 = { 30 00 C1 C4 10 00 C7 8C 0F 00 A0 18 5C 00 C2 8C ?? ?? ?? 0? 21 18 00 00 40 08 00 46 00 00 40 C4 3C 00 01 46 00 00 00 00 03 00 00 45 01 00 63 24 00 00 41 E4 00 00 87 A4 04 00 42 24 02 00 84 24 F5 FF 65 14 34 00 C0 C4 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_7_1_0 {
	meta:
		name = "_poly_zbuf_grgb16"
		size = 184
		refs = "0030 _rgb_r_shift_16 0038 _rgb_g_shift_16 003c _rgb_b_shift_16 004c .text"
	strings:
		$1 = { F8 FF BD 27 04 00 B0 AF 21 80 A0 00 18 00 CC 8C 1C 00 CB 8C 20 00 CA 8C 24 00 C5 8C 28 00 D9 8C 2C 00 D8 8C 30 00 C1 C4 20 00 00 1A 5C 00 C7 8C ?? ?? 02 3C ?? ?? 4F 8C ?? ?? 03 3C ?? ?? 02 3C ?? ?? 6E 8C ?? ?? 4D 8C 21 48 80 00 ?? ?? ?? 0? 21 40 00 00 40 08 00 46 00 00 E0 C4 83 24 0B 00 C3 1C 0C 00 3C 00 01 46 C3 14 0A 00 04 20 C4 01 04 18 E3 01 25 20 83 00 04 10 A2 01 25 20 82 00 01 00 08 25 21 60 85 01 21 58 79 01 03 00 00 45 21 50 58 01 00 00 24 A5 00 00 E1 E4 04 00 E7 24 02 00 29 25 EB FF 10 15 34 00 C0 C4 04 00 B0 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_7_2_0 {
	meta:
		name = "_poly_zbuf_atex16"
		size = 164
		refs = "0040 .text"
		altNames = "_poly_zbuf_atex15"
	strings:
		$1 = { 21 58 C0 00 54 00 C2 8C 50 00 C6 8C 10 00 03 24 23 C0 62 00 04 30 46 00 4C 00 6F 8D 00 00 6A 8D 04 00 69 8D 08 00 6E 8D 0C 00 6D 8D 48 00 6C 8D 30 00 61 C5 19 00 A0 18 5C 00 62 8D 21 38 40 00 ?? ?? ?? 0? 21 40 00 00 40 08 00 46 00 00 E0 C4 03 14 0A 00 07 18 09 03 24 10 4F 00 24 18 66 00 3C 00 01 46 21 10 43 00 40 10 02 00 21 10 82 01 01 00 08 25 21 50 4E 01 04 00 00 45 21 48 2D 01 00 00 42 94 00 00 E1 E4 00 00 82 A4 04 00 E7 24 02 00 84 24 EC FF 05 15 34 00 60 C5 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_7_3_0 {
	meta:
		name = "_poly_zbuf_atex_mask16"
		size = 176
		refs = "0044 .text"
	strings:
		$1 = { 21 58 C0 00 54 00 C2 8C 50 00 C6 8C 10 00 03 24 23 C0 62 00 04 30 46 00 4C 00 6F 8D 00 00 6A 8D 04 00 69 8D 08 00 6E 8D 0C 00 6D 8D 48 00 6C 8D 30 00 61 C5 1C 00 A0 18 5C 00 62 8D 21 38 40 00 21 40 00 00 ?? ?? ?? 0? 1F F8 19 34 40 08 00 46 00 00 E0 C4 03 14 0A 00 07 18 09 03 24 10 4F 00 24 18 66 00 3C 00 01 46 21 10 43 00 40 10 02 00 21 10 82 01 01 00 08 25 21 50 4E 01 06 00 00 45 21 48 2D 01 00 00 42 94 04 00 59 50 04 00 E7 24 00 00 82 A4 00 00 E1 E4 04 00 E7 24 02 00 84 24 EA FF 05 15 34 00 60 C5 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_7_4_0 {
	meta:
		name = "_poly_zbuf_atex_lit16"
		size = 392
		refs = "0014 _blender_func16 00a0 .text 0120 _blender_col_16"
	strings:
		$1 = { 54 00 C3 8C 10 00 02 24 B0 FF BD 27 23 10 43 00 10 00 A2 AF ?? ?? 02 3C ?? ?? 42 8C 2C 00 B3 AF 21 98 C0 00 00 00 A2 AF 50 00 C6 8C 4C 00 62 8E 40 00 BE AF 04 30 66 00 0C 00 A2 AF 08 00 63 8E 48 00 62 8E 3C 00 B7 AF 38 00 B6 AF 34 00 B5 AF 30 00 B4 AF 4C 00 B4 E7 04 00 A2 AF 44 00 BF AF 28 00 B2 AF 24 00 B1 AF 20 00 B0 AF 18 00 A5 AF 14 00 A6 AF 00 00 76 8E 04 00 75 8E 10 00 74 8E 08 00 A3 AF 0C 00 7E 8E 14 00 77 8E 30 00 74 C6 30 00 A0 18 5C 00 62 8E 21 90 80 00 21 80 40 00 ?? ?? ?? 0? 21 88 00 00 08 00 A4 8F 18 00 A2 8F 21 A8 BE 02 21 B0 C4 02 21 A0 97 02 04 00 10 26 02 00 52 26 23 00 22 12 34 00 60 C6 00 A5 00 46 00 00 00 C6 3C 00 14 46 00 00 00 00 F2 FF 00 45 01 00 31 26 10 00 A4 8F 03 14 16 00 03 34 14 00 07 18 95 00 0C 00 A4 8F 21 A8 BE 02 21 A0 97 02 24 10 44 00 14 00 A4 8F 24 18 64 00 21 10 43 00 04 00 A3 8F 40 10 02 00 21 10 62 00 00 00 44 94 ?? ?? 02 3C 00 00 A3 8F 09 F8 60 00 ?? ?? 45 8C 00 00 42 A6 08 00 A4 8F 18 00 A2 8F 00 00 14 E6 21 B0 C4 02 04 00 10 26 02 00 52 26 DF FF 22 16 34 00 60 C6 44 00 BF 8F 40 00 BE 8F 3C 00 B7 8F 38 00 B6 8F 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 4C 00 B4 C7 08 00 E0 03 50 00 BD 27 }
	condition:
		$1
}

rule file_39_4_0 {
	meta:
		name = "_poly_zbuf_atex_lit15"
		size = 392
		refs = "0014 _blender_func15 00a0 .text 0120 _blender_col_15"
	strings:
		$1 = { 54 00 C3 8C 10 00 02 24 B0 FF BD 27 23 10 43 00 10 00 A2 AF ?? ?? 02 3C ?? ?? 42 8C 2C 00 B3 AF 21 98 C0 00 00 00 A2 AF 50 00 C6 8C 4C 00 62 8E 40 00 BE AF 04 30 66 00 0C 00 A2 AF 08 00 63 8E 48 00 62 8E 3C 00 B7 AF 38 00 B6 AF 34 00 B5 AF 30 00 B4 AF 4C 00 B4 E7 04 00 A2 AF 44 00 BF AF 28 00 B2 AF 24 00 B1 AF 20 00 B0 AF 18 00 A5 AF 14 00 A6 AF 00 00 76 8E 04 00 75 8E 10 00 74 8E 08 00 A3 AF 0C 00 7E 8E 14 00 77 8E 30 00 74 C6 30 00 A0 18 5C 00 62 8E 21 90 80 00 21 80 40 00 ?? ?? ?? 0? 21 88 00 00 08 00 A4 8F 18 00 A2 8F 21 A8 BE 02 21 B0 C4 02 21 A0 97 02 04 00 10 26 02 00 52 26 23 00 22 12 34 00 60 C6 00 A5 00 46 00 00 00 C6 3C 00 14 46 00 00 00 00 F2 FF 00 45 01 00 31 26 10 00 A4 8F 03 14 16 00 03 34 14 00 07 18 95 00 0C 00 A4 8F 21 A8 BE 02 21 A0 97 02 24 10 44 00 14 00 A4 8F 24 18 64 00 21 10 43 00 04 00 A3 8F 40 10 02 00 21 10 62 00 00 00 44 94 ?? ?? 02 3C 00 00 A3 8F 09 F8 60 00 ?? ?? 45 8C 00 00 42 A6 08 00 A4 8F 18 00 A2 8F 00 00 14 E6 21 B0 C4 02 04 00 10 26 02 00 52 26 DF FF 22 16 34 00 60 C6 44 00 BF 8F 40 00 BE 8F 3C 00 B7 8F 38 00 B6 8F 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 4C 00 B4 C7 08 00 E0 03 50 00 BD 27 }
	condition:
		$1
}

rule file_7_5_0 {
	meta:
		name = "_poly_zbuf_atex_mask_lit16"
		size = 368
		refs = "0010 _blender_func16 008c .text 00e0 _blender_col_16"
	strings:
		$1 = { 54 00 C3 8C 10 00 02 24 B0 FF BD 27 23 60 43 00 ?? ?? 02 3C ?? ?? 42 8C 34 00 B5 AF 21 A8 C0 00 50 00 C6 8C 40 00 BE AF 3C 00 B7 AF 38 00 B6 AF 2C 00 B3 AF 28 00 B2 AF 4C 00 B4 E7 00 00 A2 AF 44 00 BF AF 30 00 B4 AF 24 00 B1 AF 20 00 B0 AF 21 58 A0 00 04 50 66 00 4C 00 A9 8E 00 00 B3 8E 04 00 B2 8E 10 00 B6 8E 08 00 A8 8E 0C 00 A7 8E 14 00 BE 8E 48 00 B7 8E 30 00 B4 C6 2F 00 A0 18 5C 00 A2 8E 21 A0 80 00 21 80 40 00 ?? ?? ?? 0? 21 88 00 00 00 A5 00 46 00 00 00 C6 03 14 13 00 07 18 92 01 24 10 49 00 24 18 6A 00 3C 00 14 46 21 10 43 00 40 10 02 00 21 10 E2 02 01 00 31 26 21 98 68 02 18 00 00 45 21 90 47 02 00 00 42 94 1F F8 03 34 03 34 16 00 13 00 43 10 21 20 40 00 ?? ?? 02 3C ?? ?? 45 8C 00 00 A3 8F 04 00 A7 AF 08 00 A8 AF 0C 00 A9 AF 10 00 AA AF 14 00 AB AF 09 F8 60 00 18 00 AC AF 18 00 AC 8F 14 00 AB 8F 10 00 AA 8F 0C 00 A9 8F 08 00 A8 8F 04 00 A7 8F 00 00 82 A6 00 00 14 E6 21 B0 DE 02 04 00 10 26 02 00 94 26 D7 FF 2B 16 34 00 A0 C6 44 00 BF 8F 40 00 BE 8F 3C 00 B7 8F 38 00 B6 8F 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 4C 00 B4 C7 08 00 E0 03 50 00 BD 27 }
	condition:
		$1
}

rule file_7_6_0 {
	meta:
		name = "_poly_zbuf_ptex16"
		size = 592
		refs = "0060 __extendsfdf2 00ec .text 00f4 __adddf3 0154 __ltdf2 0170 __divdf3 017c __fixdfsi 01e0 __truncdfsf2"
		altNames = "_poly_zbuf_ptex15"
	strings:
		$1 = { 98 FF BD 27 54 00 C3 8C 40 00 CC C4 30 00 B0 AF 21 80 C0 00 50 00 C6 8C 10 00 02 24 23 10 43 00 04 30 66 00 54 00 BF AF 2C 00 A5 AF 28 00 A6 AF 38 00 B2 AF 34 00 B1 AF 21 90 80 00 64 00 B6 E7 60 00 B5 E7 5C 00 B4 E7 50 00 BE AF 4C 00 B7 AF 48 00 B6 AF 44 00 B5 AF 40 00 B4 AF 3C 00 B3 AF ?? ?? ?? 0? 24 00 A2 AF 18 00 A2 AF 44 00 0C C6 4C 00 02 8E 1C 00 A3 AF 38 00 15 C6 ?? ?? ?? 0? 20 00 A2 AF 34 00 0C C6 10 00 A2 AF ?? ?? ?? 0? 14 00 A3 AF 3C 00 14 C6 30 00 16 C6 0C 00 A3 AF 5C 00 11 8E 2C 00 A3 8F 48 00 10 8E 08 00 A2 AF 58 00 60 18 04 00 B0 AF 06 AB 00 46 ?? ?? ?? 0? 00 00 B2 AF 06 A3 00 46 21 A0 40 00 ?? ?? ?? 0? 21 A8 60 00 06 B3 00 46 21 B0 40 00 ?? ?? ?? 0? 21 B8 60 00 21 F0 00 00 21 90 40 00 ?? ?? ?? 0? 21 98 60 00 ?? ?? ?? 0? 00 00 00 00 10 00 A6 8F 14 00 A7 8F 21 20 C0 02 21 28 E0 02 21 A0 40 00 ?? ?? ?? 0? 21 A8 60 00 08 00 A6 8F 0C 00 A7 8F 21 20 40 02 21 28 60 02 21 B0 40 00 ?? ?? ?? 0? 21 B8 60 00 21 90 40 00 21 98 60 00 00 00 2C C6 ?? ?? ?? 0? 01 00 DE 27 21 20 40 00 21 28 60 00 21 30 40 02 ?? ?? ?? 0? 21 38 60 02 21 30 40 02 21 38 60 02 21 20 80 02 20 00 41 04 21 28 A0 02 ?? ?? ?? 0? 00 00 00 00 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 03 84 02 00 20 00 A2 8F 21 30 40 02 21 38 60 02 21 20 C0 02 21 28 E0 02 ?? ?? ?? 0? 24 80 02 02 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 24 00 A3 8F 21 20 40 02 21 28 60 02 07 10 62 00 28 00 A3 8F 24 10 43 00 21 80 02 02 04 00 A2 8F 40 80 10 00 00 00 A3 8F 21 80 50 00 00 00 02 96 ?? ?? ?? 0? 00 00 62 A4 00 00 20 E6 00 00 A2 8F 2C 00 A3 8F 21 20 80 02 02 00 42 24 21 28 A0 02 18 00 A6 8F 1C 00 A7 8F 04 00 31 26 B9 FF C3 17 00 00 A2 AF 54 00 BF 8F 50 00 BE 8F 4C 00 B7 8F 48 00 B6 8F 44 00 B5 8F 40 00 B4 8F 3C 00 B3 8F 38 00 B2 8F 34 00 B1 8F 30 00 B0 8F 64 00 B6 C7 60 00 B5 C7 5C 00 B4 C7 08 00 E0 03 68 00 BD 27 }
	condition:
		$1
}

rule file_7_7_0 {
	meta:
		name = "_poly_zbuf_ptex_mask16"
		size = 600
		refs = "0060 __extendsfdf2 00ec .text 00f4 __adddf3 0154 __ltdf2 0170 __divdf3 017c __fixdfsi 01e8 __truncdfsf2"
	strings:
		$1 = { 98 FF BD 27 54 00 C3 8C 40 00 CC C4 30 00 B0 AF 21 80 C0 00 50 00 C6 8C 10 00 02 24 23 10 43 00 04 30 66 00 54 00 BF AF 2C 00 A5 AF 28 00 A6 AF 38 00 B2 AF 34 00 B1 AF 21 90 80 00 64 00 B6 E7 60 00 B5 E7 5C 00 B4 E7 50 00 BE AF 4C 00 B7 AF 48 00 B6 AF 44 00 B5 AF 40 00 B4 AF 3C 00 B3 AF ?? ?? ?? 0? 24 00 A2 AF 18 00 A2 AF 44 00 0C C6 4C 00 02 8E 1C 00 A3 AF 38 00 15 C6 ?? ?? ?? 0? 20 00 A2 AF 34 00 0C C6 10 00 A2 AF ?? ?? ?? 0? 14 00 A3 AF 3C 00 14 C6 30 00 16 C6 0C 00 A3 AF 5C 00 11 8E 2C 00 A3 8F 48 00 10 8E 08 00 A2 AF 5A 00 60 18 04 00 B0 AF 06 AB 00 46 ?? ?? ?? 0? 00 00 B2 AF 06 A3 00 46 21 A0 40 00 ?? ?? ?? 0? 21 A8 60 00 06 B3 00 46 21 B0 40 00 ?? ?? ?? 0? 21 B8 60 00 21 F0 00 00 21 90 40 00 ?? ?? ?? 0? 21 98 60 00 ?? ?? ?? 0? 00 00 00 00 10 00 A6 8F 14 00 A7 8F 21 20 C0 02 21 28 E0 02 21 A0 40 00 ?? ?? ?? 0? 21 A8 60 00 08 00 A6 8F 0C 00 A7 8F 21 20 40 02 21 28 60 02 21 B0 40 00 ?? ?? ?? 0? 21 B8 60 00 21 90 40 00 21 98 60 00 00 00 2C C6 ?? ?? ?? 0? 01 00 DE 27 21 20 40 00 21 28 60 00 21 30 40 02 ?? ?? ?? 0? 21 38 60 02 21 30 40 02 21 38 60 02 21 20 80 02 22 00 41 04 21 28 A0 02 ?? ?? ?? 0? 00 00 00 00 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 03 84 02 00 20 00 A2 8F 21 30 40 02 21 38 60 02 21 20 C0 02 21 28 E0 02 ?? ?? ?? 0? 24 80 02 02 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 24 00 A3 8F 21 20 40 02 07 10 62 00 28 00 A3 8F 24 10 43 00 21 80 02 02 04 00 A2 8F 40 80 10 00 1F F8 03 34 21 80 50 00 00 00 02 96 05 00 43 10 21 28 60 02 00 00 A3 8F ?? ?? ?? 0? 00 00 62 A4 00 00 20 E6 00 00 A2 8F 2C 00 A3 8F 21 20 80 02 02 00 42 24 21 28 A0 02 18 00 A6 8F 1C 00 A7 8F 04 00 31 26 B7 FF C3 17 00 00 A2 AF 54 00 BF 8F 50 00 BE 8F 4C 00 B7 8F 48 00 B6 8F 44 00 B5 8F 40 00 B4 8F 3C 00 B3 8F 38 00 B2 8F 34 00 B1 8F 30 00 B0 8F 64 00 B6 C7 60 00 B5 C7 5C 00 B4 C7 08 00 E0 03 68 00 BD 27 }
	condition:
		$1
}

rule file_7_8_0 {
	meta:
		name = "_poly_zbuf_ptex_lit16"
		size = 712
		refs = "0060 __extendsfdf2 00a8 _blender_func16 0108 .text 0144 __adddf3 01a4 __ltdf2 01c0 __divdf3 01cc __fixdfsi 021c _blender_col_16 0248 __truncdfsf2"
	strings:
		$1 = { 88 FF BD 27 54 00 C3 8C 40 00 CC C4 40 00 B0 AF 21 80 C0 00 50 00 C6 8C 10 00 02 24 23 10 43 00 04 30 66 00 64 00 BF AF 3C 00 A5 AF 38 00 A6 AF 48 00 B2 AF 44 00 B1 AF 21 90 80 00 74 00 B6 E7 70 00 B5 E7 6C 00 B4 E7 60 00 BE AF 5C 00 B7 AF 58 00 B6 AF 54 00 B5 AF 50 00 B4 AF 4C 00 B3 AF ?? ?? ?? 0? 34 00 A2 AF 20 00 A2 AF 44 00 0C C6 4C 00 02 8E 24 00 A3 AF 10 00 03 8E 30 00 A2 AF ?? ?? ?? 0? 2C 00 A3 AF 18 00 A2 AF 34 00 0C C6 14 00 02 8E 1C 00 A3 AF 38 00 15 C6 ?? ?? ?? 0? 28 00 A2 AF 10 00 A2 AF ?? ?? 02 3C 14 00 A3 AF ?? ?? 42 8C 5C 00 11 8E 3C 00 14 C6 30 00 16 C6 3C 00 A3 8F 48 00 10 8E 08 00 A2 AF 6F 00 60 18 04 00 B0 AF 06 AB 00 46 ?? ?? ?? 0? 00 00 B2 AF 06 A3 00 46 21 A0 40 00 ?? ?? ?? 0? 21 A8 60 00 06 B3 00 46 21 B0 40 00 ?? ?? ?? 0? 21 B8 60 00 21 F0 00 00 21 90 40 00 ?? ?? ?? 0? 21 98 60 00 28 00 A3 8F 21 20 80 02 21 28 A0 02 21 10 43 00 2C 00 A2 AF 00 00 A2 8F 3C 00 A3 8F 20 00 A6 8F 02 00 42 24 24 00 A7 8F 04 00 31 26 53 00 C3 13 00 00 A2 AF ?? ?? ?? 0? 00 00 00 00 18 00 A6 8F 1C 00 A7 8F 21 20 C0 02 21 28 E0 02 21 A0 40 00 ?? ?? ?? 0? 21 A8 60 00 10 00 A6 8F 14 00 A7 8F 21 20 40 02 21 28 60 02 21 B0 40 00 ?? ?? ?? 0? 21 B8 60 00 21 90 40 00 21 98 60 00 00 00 2C C6 ?? ?? ?? 0? 01 00 DE 27 21 20 40 00 21 28 60 00 21 30 40 02 ?? ?? ?? 0? 21 38 60 02 D8 FF 41 04 2C 00 A2 8F 21 30 40 02 21 38 60 02 21 20 80 02 ?? ?? ?? 0? 21 28 A0 02 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 03 84 02 00 30 00 A2 8F 21 38 60 02 21 30 40 02 21 20 C0 02 21 28 E0 02 ?? ?? ?? 0? 24 80 02 02 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 34 00 A3 8F 07 10 62 00 38 00 A3 8F 24 10 43 00 21 80 02 02 04 00 A2 8F 40 80 10 00 ?? ?? 03 3C 21 80 50 00 2C 00 A2 8F ?? ?? 65 8C 00 00 04 96 08 00 A3 8F 09 F8 60 00 03 34 02 00 00 00 A3 8F 21 20 40 02 21 28 60 02 ?? ?? ?? 0? 00 00 62 A4 2C 00 A2 8F 28 00 A3 8F 00 00 20 E6 21 20 80 02 21 10 43 00 2C 00 A2 AF 00 00 A2 8F 3C 00 A3 8F 21 28 A0 02 02 00 42 24 20 00 A6 8F 24 00 A7 8F 04 00 31 26 AF FF C3 17 00 00 A2 AF 64 00 BF 8F 60 00 BE 8F 5C 00 B7 8F 58 00 B6 8F 54 00 B5 8F 50 00 B4 8F 4C 00 B3 8F 48 00 B2 8F 44 00 B1 8F 40 00 B0 8F 74 00 B6 C7 70 00 B5 C7 6C 00 B4 C7 08 00 E0 03 78 00 BD 27 }
	condition:
		$1
}

rule file_39_8_0 {
	meta:
		name = "_poly_zbuf_ptex_lit15"
		size = 712
		refs = "0060 __extendsfdf2 00a8 _blender_func15 0108 .text 0144 __adddf3 01a4 __ltdf2 01c0 __divdf3 01cc __fixdfsi 021c _blender_col_15 0248 __truncdfsf2"
	strings:
		$1 = { 88 FF BD 27 54 00 C3 8C 40 00 CC C4 40 00 B0 AF 21 80 C0 00 50 00 C6 8C 10 00 02 24 23 10 43 00 04 30 66 00 64 00 BF AF 3C 00 A5 AF 38 00 A6 AF 48 00 B2 AF 44 00 B1 AF 21 90 80 00 74 00 B6 E7 70 00 B5 E7 6C 00 B4 E7 60 00 BE AF 5C 00 B7 AF 58 00 B6 AF 54 00 B5 AF 50 00 B4 AF 4C 00 B3 AF ?? ?? ?? 0? 34 00 A2 AF 20 00 A2 AF 44 00 0C C6 4C 00 02 8E 24 00 A3 AF 10 00 03 8E 30 00 A2 AF ?? ?? ?? 0? 2C 00 A3 AF 18 00 A2 AF 34 00 0C C6 14 00 02 8E 1C 00 A3 AF 38 00 15 C6 ?? ?? ?? 0? 28 00 A2 AF 10 00 A2 AF ?? ?? 02 3C 14 00 A3 AF ?? ?? 42 8C 5C 00 11 8E 3C 00 14 C6 30 00 16 C6 3C 00 A3 8F 48 00 10 8E 08 00 A2 AF 6F 00 60 18 04 00 B0 AF 06 AB 00 46 ?? ?? ?? 0? 00 00 B2 AF 06 A3 00 46 21 A0 40 00 ?? ?? ?? 0? 21 A8 60 00 06 B3 00 46 21 B0 40 00 ?? ?? ?? 0? 21 B8 60 00 21 F0 00 00 21 90 40 00 ?? ?? ?? 0? 21 98 60 00 28 00 A3 8F 21 20 80 02 21 28 A0 02 21 10 43 00 2C 00 A2 AF 00 00 A2 8F 3C 00 A3 8F 20 00 A6 8F 02 00 42 24 24 00 A7 8F 04 00 31 26 53 00 C3 13 00 00 A2 AF ?? ?? ?? 0? 00 00 00 00 18 00 A6 8F 1C 00 A7 8F 21 20 C0 02 21 28 E0 02 21 A0 40 00 ?? ?? ?? 0? 21 A8 60 00 10 00 A6 8F 14 00 A7 8F 21 20 40 02 21 28 60 02 21 B0 40 00 ?? ?? ?? 0? 21 B8 60 00 21 90 40 00 21 98 60 00 00 00 2C C6 ?? ?? ?? 0? 01 00 DE 27 21 20 40 00 21 28 60 00 21 30 40 02 ?? ?? ?? 0? 21 38 60 02 D8 FF 41 04 2C 00 A2 8F 21 30 40 02 21 38 60 02 21 20 80 02 ?? ?? ?? 0? 21 28 A0 02 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 03 84 02 00 30 00 A2 8F 21 38 60 02 21 30 40 02 21 20 C0 02 21 28 E0 02 ?? ?? ?? 0? 24 80 02 02 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 34 00 A3 8F 07 10 62 00 38 00 A3 8F 24 10 43 00 21 80 02 02 04 00 A2 8F 40 80 10 00 ?? ?? 03 3C 21 80 50 00 2C 00 A2 8F ?? ?? 65 8C 00 00 04 96 08 00 A3 8F 09 F8 60 00 03 34 02 00 00 00 A3 8F 21 20 40 02 21 28 60 02 ?? ?? ?? 0? 00 00 62 A4 2C 00 A2 8F 28 00 A3 8F 00 00 20 E6 21 20 80 02 21 10 43 00 2C 00 A2 AF 00 00 A2 8F 3C 00 A3 8F 21 28 A0 02 02 00 42 24 20 00 A6 8F 24 00 A7 8F 04 00 31 26 AF FF C3 17 00 00 A2 AF 64 00 BF 8F 60 00 BE 8F 5C 00 B7 8F 58 00 B6 8F 54 00 B5 8F 50 00 B4 8F 4C 00 B3 8F 48 00 B2 8F 44 00 B1 8F 40 00 B0 8F 74 00 B6 C7 70 00 B5 C7 6C 00 B4 C7 08 00 E0 03 78 00 BD 27 }
	condition:
		$1
}

rule file_7_9_0 {
	meta:
		name = "_poly_zbuf_ptex_mask_lit16"
		size = 672
		refs = "0060 __extendsfdf2 00a8 _blender_func16 0108 .text 0110 __adddf3 0170 __ltdf2 018c __divdf3 0198 __fixdfsi 0204 _blender_col_16 0220 __truncdfsf2"
	strings:
		$1 = { 88 FF BD 27 54 00 C3 8C 40 00 CC C4 40 00 B0 AF 21 80 C0 00 50 00 C6 8C 10 00 02 24 23 10 43 00 04 30 66 00 64 00 BF AF 3C 00 A5 AF 38 00 A6 AF 48 00 B2 AF 44 00 B1 AF 21 90 80 00 74 00 B6 E7 70 00 B5 E7 6C 00 B4 E7 60 00 BE AF 5C 00 B7 AF 58 00 B6 AF 54 00 B5 AF 50 00 B4 AF 4C 00 B3 AF ?? ?? ?? 0? 34 00 A2 AF 20 00 A2 AF 44 00 0C C6 4C 00 02 8E 24 00 A3 AF 10 00 03 8E 30 00 A2 AF ?? ?? ?? 0? 2C 00 A3 AF 18 00 A2 AF 34 00 0C C6 14 00 02 8E 1C 00 A3 AF 38 00 15 C6 ?? ?? ?? 0? 28 00 A2 AF 10 00 A2 AF ?? ?? 02 3C 14 00 A3 AF ?? ?? 42 8C 5C 00 11 8E 3C 00 14 C6 30 00 16 C6 3C 00 A3 8F 48 00 10 8E 08 00 A2 AF 65 00 60 18 04 00 B0 AF 06 AB 00 46 ?? ?? ?? 0? 00 00 B2 AF 06 A3 00 46 21 A0 40 00 ?? ?? ?? 0? 21 A8 60 00 06 B3 00 46 21 B0 40 00 ?? ?? ?? 0? 21 B8 60 00 21 F0 00 00 21 90 40 00 ?? ?? ?? 0? 21 98 60 00 ?? ?? ?? 0? 00 00 00 00 18 00 A6 8F 1C 00 A7 8F 21 20 C0 02 21 28 E0 02 21 A0 40 00 ?? ?? ?? 0? 21 A8 60 00 10 00 A6 8F 14 00 A7 8F 21 20 40 02 21 28 60 02 21 B0 40 00 ?? ?? ?? 0? 21 B8 60 00 21 90 40 00 21 98 60 00 00 00 2C C6 ?? ?? ?? 0? 01 00 DE 27 21 20 40 00 21 28 60 00 21 30 40 02 ?? ?? ?? 0? 21 38 60 02 21 30 40 02 21 38 60 02 21 20 80 02 29 00 41 04 21 28 A0 02 ?? ?? ?? 0? 00 00 00 00 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 03 84 02 00 30 00 A2 8F 21 30 40 02 21 38 60 02 21 20 C0 02 21 28 E0 02 ?? ?? ?? 0? 24 80 02 02 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 34 00 A3 8F 07 10 62 00 38 00 A3 8F 24 10 43 00 21 80 02 02 04 00 A2 8F 40 80 10 00 2C 00 A3 8F 21 80 50 00 00 00 02 96 03 34 03 00 1F F8 03 34 0B 00 43 10 21 20 40 00 ?? ?? 02 3C 08 00 A3 8F 09 F8 60 00 ?? ?? 45 8C 00 00 A3 8F 21 20 40 02 21 28 60 02 ?? ?? ?? 0? 00 00 62 A4 00 00 20 E6 2C 00 A2 8F 28 00 A3 8F 21 20 80 02 21 28 A0 02 21 10 43 00 2C 00 A2 AF 00 00 A2 8F 3C 00 A3 8F 20 00 A6 8F 02 00 42 24 24 00 A7 8F 04 00 31 26 AC FF C3 17 00 00 A2 AF 64 00 BF 8F 60 00 BE 8F 5C 00 B7 8F 58 00 B6 8F 54 00 B5 8F 50 00 B4 8F 4C 00 B3 8F 48 00 B2 8F 44 00 B1 8F 40 00 B0 8F 74 00 B6 C7 70 00 B5 C7 6C 00 B4 C7 08 00 E0 03 78 00 BD 27 }
	condition:
		$1
}

rule file_7_10_0 {
	meta:
		name = "_poly_zbuf_atex_trans16"
		size = 380
		refs = "0014 _blender_func16 009c .text 010c _blender_alpha"
	strings:
		$1 = { 54 00 C3 8C 10 00 02 24 B8 FF BD 27 23 10 43 00 0C 00 A2 AF ?? ?? 02 3C ?? ?? 42 8C 28 00 B4 AF 21 A0 C0 00 50 00 C6 8C 04 00 A2 AF 4C 00 82 8E 04 30 66 00 48 00 83 8E 38 00 BE AF 34 00 B7 AF 30 00 B6 AF 2C 00 B5 AF 44 00 B4 E7 08 00 A2 AF 00 00 A3 AF 3C 00 BF AF 24 00 B3 AF 20 00 B2 AF 1C 00 B1 AF 18 00 B0 AF 14 00 A5 AF 10 00 A6 AF 00 00 96 8E 04 00 95 8E 08 00 9E 8E 0C 00 97 8E 60 00 83 8E 30 00 94 C6 2F 00 A0 18 5C 00 82 8E 21 98 80 00 21 90 60 00 21 80 40 00 ?? ?? ?? 0? 21 88 00 00 14 00 A4 8F 21 B0 DE 02 21 A8 B7 02 04 00 10 26 02 00 73 26 02 00 52 26 22 00 24 12 34 00 80 C6 00 A5 00 46 00 00 00 C6 3C 00 14 46 00 00 00 00 F3 FF 00 45 01 00 31 26 0C 00 A4 8F 08 00 A5 8F 03 14 16 00 07 18 95 00 10 00 A4 8F 24 10 45 00 00 00 A5 8F 24 18 64 00 21 10 43 00 40 10 02 00 21 10 A2 00 00 00 44 94 ?? ?? 02 3C 00 00 45 96 ?? ?? 46 8C 04 00 A3 8F 21 B0 DE 02 09 F8 60 00 21 A8 B7 02 14 00 A4 8F 00 00 14 E6 00 00 62 A6 04 00 10 26 02 00 73 26 02 00 52 26 E0 FF 24 16 34 00 80 C6 3C 00 BF 8F 38 00 BE 8F 34 00 B7 8F 30 00 B6 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 44 00 B4 C7 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_39_10_0 {
	meta:
		name = "_poly_zbuf_atex_trans15"
		size = 380
		refs = "0014 _blender_func15 009c .text 010c _blender_alpha"
	strings:
		$1 = { 54 00 C3 8C 10 00 02 24 B8 FF BD 27 23 10 43 00 0C 00 A2 AF ?? ?? 02 3C ?? ?? 42 8C 28 00 B4 AF 21 A0 C0 00 50 00 C6 8C 04 00 A2 AF 4C 00 82 8E 04 30 66 00 48 00 83 8E 38 00 BE AF 34 00 B7 AF 30 00 B6 AF 2C 00 B5 AF 44 00 B4 E7 08 00 A2 AF 00 00 A3 AF 3C 00 BF AF 24 00 B3 AF 20 00 B2 AF 1C 00 B1 AF 18 00 B0 AF 14 00 A5 AF 10 00 A6 AF 00 00 96 8E 04 00 95 8E 08 00 9E 8E 0C 00 97 8E 60 00 83 8E 30 00 94 C6 2F 00 A0 18 5C 00 82 8E 21 98 80 00 21 90 60 00 21 80 40 00 ?? ?? ?? 0? 21 88 00 00 14 00 A4 8F 21 B0 DE 02 21 A8 B7 02 04 00 10 26 02 00 73 26 02 00 52 26 22 00 24 12 34 00 80 C6 00 A5 00 46 00 00 00 C6 3C 00 14 46 00 00 00 00 F3 FF 00 45 01 00 31 26 0C 00 A4 8F 08 00 A5 8F 03 14 16 00 07 18 95 00 10 00 A4 8F 24 10 45 00 00 00 A5 8F 24 18 64 00 21 10 43 00 40 10 02 00 21 10 A2 00 00 00 44 94 ?? ?? 02 3C 00 00 45 96 ?? ?? 46 8C 04 00 A3 8F 21 B0 DE 02 09 F8 60 00 21 A8 B7 02 14 00 A4 8F 00 00 14 E6 00 00 62 A6 04 00 10 26 02 00 73 26 02 00 52 26 E0 FF 24 16 34 00 80 C6 3C 00 BF 8F 38 00 BE 8F 34 00 B7 8F 30 00 B6 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 44 00 B4 C7 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_7_11_0 {
	meta:
		name = "_poly_zbuf_atex_mask_trans16"
		size = 360
		refs = "0010 _blender_func16 008c .text 00dc _blender_alpha"
	strings:
		$1 = { 54 00 C3 8C 10 00 02 24 B8 FF BD 27 23 58 43 00 ?? ?? 02 3C ?? ?? 42 8C 30 00 B6 AF 21 B0 C0 00 50 00 C6 8C 38 00 BE AF 34 00 B7 AF 24 00 B3 AF 20 00 B2 AF 44 00 B4 E7 04 48 66 00 00 00 A2 AF 3C 00 BF AF 2C 00 B5 AF 28 00 B4 AF 1C 00 B1 AF 18 00 B0 AF 21 50 A0 00 4C 00 C8 8E 00 00 D3 8E 04 00 D2 8E 08 00 C7 8E 0C 00 DE 8E 48 00 D7 8E 60 00 C3 8E 30 00 D4 C6 2E 00 A0 18 5C 00 C2 8E 21 A8 80 00 21 A0 60 00 21 80 40 00 ?? ?? ?? 0? 21 88 00 00 00 A5 00 46 00 00 00 C6 03 14 13 00 07 18 72 01 24 10 48 00 24 18 69 00 3C 00 14 46 21 10 43 00 40 10 02 00 21 10 E2 02 01 00 31 26 21 98 67 02 16 00 00 45 21 90 5E 02 00 00 42 94 1F F8 03 34 12 00 43 10 21 20 40 00 ?? ?? 02 3C 00 00 85 96 ?? ?? 46 8C 00 00 A3 8F 04 00 A7 AF 08 00 A8 AF 0C 00 A9 AF 10 00 AA AF 09 F8 60 00 14 00 AB AF 14 00 AB 8F 10 00 AA 8F 0C 00 A9 8F 08 00 A8 8F 04 00 A7 8F 00 00 A2 A6 00 00 14 E6 04 00 10 26 02 00 B5 26 02 00 94 26 D9 FF 2A 16 34 00 C0 C6 3C 00 BF 8F 38 00 BE 8F 34 00 B7 8F 30 00 B6 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 44 00 B4 C7 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_7_12_0 {
	meta:
		name = "_poly_zbuf_ptex_trans16"
		size = 696
		refs = "0060 __extendsfdf2 0098 _blender_func16 0100 .text 0138 __adddf3 0198 __ltdf2 01b4 __divdf3 01c0 __fixdfsi 0210 _blender_alpha 023c __truncdfsf2"
	strings:
		$1 = { 90 FF BD 27 54 00 C3 8C 40 00 CC C4 38 00 B0 AF 21 80 C0 00 50 00 C6 8C 10 00 02 24 23 10 43 00 04 30 66 00 5C 00 BF AF 34 00 A5 AF 30 00 A6 AF 40 00 B2 AF 3C 00 B1 AF 21 90 80 00 6C 00 B6 E7 68 00 B5 E7 64 00 B4 E7 58 00 BE AF 54 00 B7 AF 50 00 B6 AF 4C 00 B5 AF 48 00 B4 AF 44 00 B3 AF ?? ?? ?? 0? 2C 00 A2 AF 20 00 A2 AF 44 00 0C C6 4C 00 02 8E 24 00 A3 AF 38 00 15 C6 ?? ?? ?? 0? 28 00 A2 AF 34 00 0C C6 18 00 A2 AF ?? ?? ?? 0? 1C 00 A3 AF 10 00 A2 AF ?? ?? 02 3C ?? ?? 42 8C 14 00 A3 AF 48 00 03 8E 0C 00 A2 AF 34 00 A2 8F 3C 00 14 C6 30 00 16 C6 5C 00 11 8E 08 00 A3 AF 6E 00 40 18 60 00 10 8E 06 AB 00 46 ?? ?? ?? 0? 04 00 B2 AF 06 A3 00 46 21 A0 40 00 21 A8 60 00 ?? ?? ?? 0? 00 00 B0 AF 06 B3 00 46 21 B0 40 00 ?? ?? ?? 0? 21 B8 60 00 21 90 40 00 21 98 60 00 ?? ?? ?? 0? 21 F0 00 00 00 00 A3 8F 21 20 80 02 02 00 42 24 04 00 A2 AF 34 00 A2 8F 02 00 63 24 21 28 A0 02 20 00 A6 8F 24 00 A7 8F 04 00 31 26 52 00 C2 13 00 00 A3 AF ?? ?? ?? 0? 00 00 00 00 18 00 A6 8F 1C 00 A7 8F 21 20 C0 02 21 28 E0 02 21 A0 40 00 ?? ?? ?? 0? 21 A8 60 00 10 00 A6 8F 14 00 A7 8F 21 20 40 02 21 28 60 02 21 B0 40 00 ?? ?? ?? 0? 21 B8 60 00 21 90 40 00 21 98 60 00 00 00 2C C6 ?? ?? ?? 0? 01 00 DE 27 21 20 40 00 21 28 60 00 21 30 40 02 ?? ?? ?? 0? 21 38 60 02 D9 FF 41 04 04 00 A2 8F 21 30 40 02 21 38 60 02 21 20 80 02 ?? ?? ?? 0? 21 28 A0 02 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 28 00 A3 8F 21 38 60 02 21 30 40 02 03 84 02 00 21 20 C0 02 21 28 E0 02 ?? ?? ?? 0? 24 80 03 02 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 2C 00 A3 8F 07 10 62 00 30 00 A3 8F 24 10 43 00 21 80 02 02 08 00 A2 8F 40 80 10 00 ?? ?? 03 3C 21 80 50 00 00 00 A2 8F ?? ?? 66 8C 00 00 04 96 0C 00 A3 8F 09 F8 60 00 00 00 45 94 04 00 A3 8F 21 20 40 02 21 28 60 02 ?? ?? ?? 0? 00 00 62 A4 04 00 A2 8F 00 00 A3 8F 00 00 20 E6 02 00 42 24 04 00 A2 AF 34 00 A2 8F 02 00 63 24 21 20 80 02 21 28 A0 02 20 00 A6 8F 24 00 A7 8F 04 00 31 26 B0 FF C2 17 00 00 A3 AF 5C 00 BF 8F 58 00 BE 8F 54 00 B7 8F 50 00 B6 8F 4C 00 B5 8F 48 00 B4 8F 44 00 B3 8F 40 00 B2 8F 3C 00 B1 8F 38 00 B0 8F 6C 00 B6 C7 68 00 B5 C7 64 00 B4 C7 08 00 E0 03 70 00 BD 27 }
	condition:
		$1
}

rule file_39_12_0 {
	meta:
		name = "_poly_zbuf_ptex_trans15"
		size = 696
		refs = "0060 __extendsfdf2 0098 _blender_func15 0100 .text 0138 __adddf3 0198 __ltdf2 01b4 __divdf3 01c0 __fixdfsi 0210 _blender_alpha 023c __truncdfsf2"
	strings:
		$1 = { 90 FF BD 27 54 00 C3 8C 40 00 CC C4 38 00 B0 AF 21 80 C0 00 50 00 C6 8C 10 00 02 24 23 10 43 00 04 30 66 00 5C 00 BF AF 34 00 A5 AF 30 00 A6 AF 40 00 B2 AF 3C 00 B1 AF 21 90 80 00 6C 00 B6 E7 68 00 B5 E7 64 00 B4 E7 58 00 BE AF 54 00 B7 AF 50 00 B6 AF 4C 00 B5 AF 48 00 B4 AF 44 00 B3 AF ?? ?? ?? 0? 2C 00 A2 AF 20 00 A2 AF 44 00 0C C6 4C 00 02 8E 24 00 A3 AF 38 00 15 C6 ?? ?? ?? 0? 28 00 A2 AF 34 00 0C C6 18 00 A2 AF ?? ?? ?? 0? 1C 00 A3 AF 10 00 A2 AF ?? ?? 02 3C ?? ?? 42 8C 14 00 A3 AF 48 00 03 8E 0C 00 A2 AF 34 00 A2 8F 3C 00 14 C6 30 00 16 C6 5C 00 11 8E 08 00 A3 AF 6E 00 40 18 60 00 10 8E 06 AB 00 46 ?? ?? ?? 0? 04 00 B2 AF 06 A3 00 46 21 A0 40 00 21 A8 60 00 ?? ?? ?? 0? 00 00 B0 AF 06 B3 00 46 21 B0 40 00 ?? ?? ?? 0? 21 B8 60 00 21 90 40 00 21 98 60 00 ?? ?? ?? 0? 21 F0 00 00 00 00 A3 8F 21 20 80 02 02 00 42 24 04 00 A2 AF 34 00 A2 8F 02 00 63 24 21 28 A0 02 20 00 A6 8F 24 00 A7 8F 04 00 31 26 52 00 C2 13 00 00 A3 AF ?? ?? ?? 0? 00 00 00 00 18 00 A6 8F 1C 00 A7 8F 21 20 C0 02 21 28 E0 02 21 A0 40 00 ?? ?? ?? 0? 21 A8 60 00 10 00 A6 8F 14 00 A7 8F 21 20 40 02 21 28 60 02 21 B0 40 00 ?? ?? ?? 0? 21 B8 60 00 21 90 40 00 21 98 60 00 00 00 2C C6 ?? ?? ?? 0? 01 00 DE 27 21 20 40 00 21 28 60 00 21 30 40 02 ?? ?? ?? 0? 21 38 60 02 D9 FF 41 04 04 00 A2 8F 21 30 40 02 21 38 60 02 21 20 80 02 ?? ?? ?? 0? 21 28 A0 02 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 28 00 A3 8F 21 38 60 02 21 30 40 02 03 84 02 00 21 20 C0 02 21 28 E0 02 ?? ?? ?? 0? 24 80 03 02 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 2C 00 A3 8F 07 10 62 00 30 00 A3 8F 24 10 43 00 21 80 02 02 08 00 A2 8F 40 80 10 00 ?? ?? 03 3C 21 80 50 00 00 00 A2 8F ?? ?? 66 8C 00 00 04 96 0C 00 A3 8F 09 F8 60 00 00 00 45 94 04 00 A3 8F 21 20 40 02 21 28 60 02 ?? ?? ?? 0? 00 00 62 A4 04 00 A2 8F 00 00 A3 8F 00 00 20 E6 02 00 42 24 04 00 A2 AF 34 00 A2 8F 02 00 63 24 21 20 80 02 21 28 A0 02 20 00 A6 8F 24 00 A7 8F 04 00 31 26 B0 FF C2 17 00 00 A3 AF 5C 00 BF 8F 58 00 BE 8F 54 00 B7 8F 50 00 B6 8F 4C 00 B5 8F 48 00 B4 8F 44 00 B3 8F 40 00 B2 8F 3C 00 B1 8F 38 00 B0 8F 6C 00 B6 C7 68 00 B5 C7 64 00 B4 C7 08 00 E0 03 70 00 BD 27 }
	condition:
		$1
}

rule file_7_13_0 {
	meta:
		name = "_poly_zbuf_ptex_mask_trans16"
		size = 660
		refs = "0060 __extendsfdf2 0098 _blender_func16 0100 .text 0108 __adddf3 0168 __ltdf2 0184 __divdf3 0190 __fixdfsi 01f8 _blender_alpha 0218 __truncdfsf2"
	strings:
		$1 = { 90 FF BD 27 54 00 C3 8C 40 00 CC C4 38 00 B0 AF 21 80 C0 00 50 00 C6 8C 10 00 02 24 23 10 43 00 04 30 66 00 5C 00 BF AF 34 00 A5 AF 30 00 A6 AF 40 00 B2 AF 3C 00 B1 AF 21 90 80 00 6C 00 B6 E7 68 00 B5 E7 64 00 B4 E7 58 00 BE AF 54 00 B7 AF 50 00 B6 AF 4C 00 B5 AF 48 00 B4 AF 44 00 B3 AF ?? ?? ?? 0? 2C 00 A2 AF 20 00 A2 AF 44 00 0C C6 4C 00 02 8E 24 00 A3 AF 38 00 15 C6 ?? ?? ?? 0? 28 00 A2 AF 34 00 0C C6 18 00 A2 AF ?? ?? ?? 0? 1C 00 A3 AF 10 00 A2 AF ?? ?? 02 3C ?? ?? 42 8C 14 00 A3 AF 48 00 03 8E 0C 00 A2 AF 34 00 A2 8F 3C 00 14 C6 30 00 16 C6 5C 00 11 8E 08 00 A3 AF 65 00 40 18 60 00 10 8E 06 AB 00 46 ?? ?? ?? 0? 04 00 B2 AF 06 A3 00 46 21 A0 40 00 21 A8 60 00 ?? ?? ?? 0? 00 00 B0 AF 06 B3 00 46 21 B0 40 00 ?? ?? ?? 0? 21 B8 60 00 21 90 40 00 21 98 60 00 ?? ?? ?? 0? 21 F0 00 00 ?? ?? ?? 0? 00 00 00 00 18 00 A6 8F 1C 00 A7 8F 21 20 C0 02 21 28 E0 02 21 A0 40 00 ?? ?? ?? 0? 21 A8 60 00 10 00 A6 8F 14 00 A7 8F 21 20 40 02 21 28 60 02 21 B0 40 00 ?? ?? ?? 0? 21 B8 60 00 21 90 40 00 21 98 60 00 00 00 2C C6 ?? ?? ?? 0? 01 00 DE 27 21 20 40 00 21 28 60 00 21 30 40 02 ?? ?? ?? 0? 21 38 60 02 21 30 40 02 21 38 60 02 21 20 80 02 29 00 41 04 21 28 A0 02 ?? ?? ?? 0? 00 00 00 00 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 28 00 A3 8F 03 84 02 00 21 30 40 02 21 38 60 02 21 20 C0 02 21 28 E0 02 ?? ?? ?? 0? 24 80 03 02 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 2C 00 A3 8F 07 10 62 00 30 00 A3 8F 24 10 43 00 21 80 02 02 08 00 A2 8F 40 80 10 00 1F F8 03 34 21 80 50 00 00 00 02 96 0D 00 43 10 21 20 40 00 00 00 A3 8F ?? ?? 02 3C 00 00 65 94 0C 00 A3 8F 09 F8 60 00 ?? ?? 46 8C 04 00 A3 8F 21 20 40 02 21 28 60 02 ?? ?? ?? 0? 00 00 62 A4 00 00 20 E6 04 00 A2 8F 00 00 A3 8F 21 20 80 02 02 00 42 24 04 00 A2 AF 34 00 A2 8F 02 00 63 24 21 28 A0 02 20 00 A6 8F 24 00 A7 8F 04 00 31 26 AD FF C2 17 00 00 A3 AF 5C 00 BF 8F 58 00 BE 8F 54 00 B7 8F 50 00 B6 8F 4C 00 B5 8F 48 00 B4 8F 44 00 B3 8F 40 00 B2 8F 3C 00 B1 8F 38 00 B0 8F 6C 00 B6 C7 68 00 B5 C7 64 00 B4 C7 08 00 E0 03 70 00 BD 27 }
	condition:
		$1
}

rule file_8_0_0 {
	meta:
		name = "_poly_zbuf_flat8"
		size = 80
		refs = "0010 .text"
	strings:
		$1 = { 30 00 C1 C4 10 00 C3 8C 0F 00 A0 18 5C 00 C2 8C ?? ?? ?? 0? 21 28 A4 00 40 08 00 46 00 00 40 C4 3C 00 01 46 00 00 00 00 04 00 02 45 01 00 84 24 00 00 83 A0 00 00 41 E4 01 00 84 24 04 00 42 24 F5 FF 85 14 34 00 C0 C4 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_8_1_0 {
	meta:
		name = "_poly_zbuf_gcol8"
		size = 88
		refs = "0014 .text"
	strings:
		$1 = { 30 00 C1 C4 10 00 C7 8C 14 00 C8 8C 10 00 A0 18 5C 00 C2 8C ?? ?? ?? 0? 21 28 A4 00 40 08 00 46 00 00 40 C4 03 1C 07 00 3C 00 01 46 00 00 00 00 03 00 00 45 21 38 E8 00 00 00 83 A0 00 00 41 E4 01 00 84 24 04 00 42 24 F4 FF 85 14 34 00 C0 C4 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_8_2_0 {
	meta:
		name = "_poly_zbuf_atex8"
		size = 156
		refs = "0040 .text"
	strings:
		$1 = { 21 50 C0 00 54 00 C2 8C 50 00 C6 8C 10 00 03 24 23 78 62 00 04 30 46 00 4C 00 4E 8D 00 00 49 8D 04 00 48 8D 08 00 4D 8D 0C 00 4C 8D 48 00 4B 8D 30 00 41 C5 17 00 A0 18 5C 00 42 8D 21 38 40 00 ?? ?? ?? 0? 21 28 A4 00 40 08 00 46 00 00 E0 C4 03 14 09 00 07 18 E8 01 3C 00 01 46 24 10 4E 00 24 18 66 00 21 10 62 01 21 10 43 00 21 48 2D 01 04 00 00 45 21 40 0C 01 00 00 42 90 00 00 82 A0 00 00 E1 E4 01 00 84 24 04 00 E7 24 EE FF 85 14 34 00 40 C5 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_8_3_0 {
	meta:
		name = "_poly_zbuf_atex_mask8"
		size = 164
		refs = "0040 .text"
	strings:
		$1 = { 21 50 C0 00 54 00 C2 8C 50 00 C6 8C 10 00 03 24 23 78 62 00 04 30 46 00 4C 00 4E 8D 00 00 49 8D 04 00 48 8D 08 00 4D 8D 0C 00 4C 8D 48 00 4B 8D 30 00 41 C5 19 00 A0 18 5C 00 42 8D 21 38 40 00 ?? ?? ?? 0? 21 28 A4 00 40 08 00 46 00 00 E0 C4 03 14 09 00 07 18 E8 01 3C 00 01 46 24 10 4E 00 24 18 66 00 21 10 62 01 21 10 43 00 21 48 2D 01 06 00 00 45 21 40 0C 01 00 00 42 90 04 00 40 50 01 00 84 24 00 00 82 A0 00 00 E1 E4 01 00 84 24 04 00 E7 24 EC FF 85 14 34 00 40 C5 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_8_4_0 {
	meta:
		name = "_poly_zbuf_atex_lit8"
		size = 220
		refs = "001c color_map 0060 .text"
	strings:
		$1 = { 54 00 C3 8C 21 60 C0 00 50 00 C6 8C F8 FF BD 27 10 00 02 24 00 00 B0 AF 23 80 43 00 ?? ?? 02 3C 04 00 B1 AF 04 30 66 00 ?? ?? 51 8C 4C 00 99 8D 00 00 8B 8D 04 00 8A 8D 10 00 89 8D 08 00 98 8D 0C 00 8F 8D 14 00 8E 8D 48 00 8D 8D 30 00 81 C5 1E 00 A0 18 5C 00 82 8D 21 40 80 00 21 38 40 00 ?? ?? ?? 0? 21 28 A4 00 40 08 00 46 00 00 E0 C4 03 1C 0B 00 07 10 0A 02 3C 00 01 46 24 18 79 00 00 3C 24 7D 24 10 46 00 21 18 A3 01 21 18 62 00 00 22 04 00 21 58 78 01 21 50 4F 01 07 00 00 45 21 48 2E 01 00 00 62 90 21 10 82 00 21 10 22 02 00 00 43 90 00 00 03 A1 00 00 E1 E4 01 00 08 25 04 00 E7 24 E8 FF 05 15 34 00 80 C5 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_8_5_0 {
	meta:
		name = "_poly_zbuf_atex_mask_lit8"
		size = 212
		refs = "0018 color_map 0058 .text"
	strings:
		$1 = { 54 00 C3 8C 21 50 C0 00 50 00 C6 8C 10 00 02 24 F8 FF BD 27 23 C8 43 00 ?? ?? 02 3C 04 00 B0 AF 04 30 66 00 ?? ?? 50 8C 4C 00 58 8D 00 00 49 8D 04 00 48 8D 10 00 4B 8D 08 00 4F 8D 0C 00 4E 8D 14 00 4D 8D 48 00 4C 8D 30 00 41 C5 1E 00 A0 18 5C 00 42 8D 21 38 40 00 ?? ?? ?? 0? 21 28 A4 00 40 08 00 46 00 00 E0 C4 03 14 09 00 07 18 28 03 3C 00 01 46 24 10 58 00 24 18 66 00 21 10 82 01 21 18 43 00 21 48 2F 01 0A 00 00 45 21 40 0E 01 00 00 63 90 00 3C 62 7D 00 12 02 00 21 10 43 00 04 00 60 10 21 10 02 02 00 00 42 90 00 00 82 A0 00 00 E1 E4 01 00 84 24 21 58 6D 01 04 00 E7 24 E7 FF 85 14 34 00 40 C5 04 00 B0 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_8_6_0 {
	meta:
		name = "_poly_zbuf_ptex8"
		size = 572
		refs = "0060 __extendsfdf2 00ec .text 00f4 __adddf3 0150 __ltdf2 016c __divdf3 0178 __fixdfsi 01d4 __truncdfsf2"
	strings:
		$1 = { 98 FF BD 27 54 00 C3 8C 40 00 CC C4 30 00 B0 AF 21 80 C0 00 50 00 C6 8C 10 00 02 24 23 10 43 00 04 30 66 00 54 00 BF AF 28 00 A6 AF 3C 00 B3 AF 38 00 B2 AF 21 98 80 00 21 90 A0 00 34 00 B1 AF 64 00 B6 E7 60 00 B5 E7 5C 00 B4 E7 50 00 BE AF 4C 00 B7 AF 48 00 B6 AF 44 00 B5 AF 40 00 B4 AF ?? ?? ?? 0? 24 00 A2 AF 18 00 A2 AF 44 00 0C C6 4C 00 02 8E 1C 00 A3 AF 38 00 15 C6 ?? ?? ?? 0? 20 00 A2 AF 34 00 0C C6 10 00 A2 AF 14 00 A3 AF ?? ?? ?? 0? 3C 00 14 C6 30 00 16 C6 5C 00 11 8E 48 00 10 8E 08 00 A2 AF 0C 00 A3 AF 54 00 40 1A 00 00 B0 AF 06 AB 00 46 ?? ?? ?? 0? 21 90 53 02 06 A3 00 46 21 A0 40 00 ?? ?? ?? 0? 21 A8 60 00 06 B3 00 46 2C 00 B2 AF 21 B0 40 00 ?? ?? ?? 0? 21 B8 60 00 21 F0 60 02 21 90 40 00 ?? ?? ?? 0? 21 98 60 00 ?? ?? ?? 0? 00 00 00 00 10 00 A6 8F 14 00 A7 8F 21 20 C0 02 21 28 E0 02 21 A0 40 00 ?? ?? ?? 0? 21 A8 60 00 08 00 A6 8F 0C 00 A7 8F 21 20 40 02 21 28 60 02 21 B0 40 00 ?? ?? ?? 0? 21 B8 60 00 21 90 40 00 21 98 60 00 ?? ?? ?? 0? 00 00 2C C6 21 20 40 00 21 28 60 00 21 30 40 02 ?? ?? ?? 0? 21 38 60 02 21 30 40 02 21 38 60 02 21 20 80 02 1E 00 41 04 21 28 A0 02 ?? ?? ?? 0? 00 00 00 00 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 20 00 A3 8F 21 30 40 02 21 38 60 02 03 84 02 00 21 20 C0 02 21 28 E0 02 ?? ?? ?? 0? 24 80 03 02 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 24 00 A3 8F 21 20 40 02 21 28 60 02 07 10 62 00 28 00 A3 8F 24 10 43 00 00 00 A3 8F 21 80 70 00 21 80 02 02 00 00 02 92 ?? ?? ?? 0? 00 00 C2 A3 00 00 20 E6 2C 00 A2 8F 01 00 DE 27 21 20 80 02 21 28 A0 02 18 00 A6 8F 1C 00 A7 8F BE FF C2 17 04 00 31 26 54 00 BF 8F 50 00 BE 8F 4C 00 B7 8F 48 00 B6 8F 44 00 B5 8F 40 00 B4 8F 3C 00 B3 8F 38 00 B2 8F 34 00 B1 8F 30 00 B0 8F 64 00 B6 C7 60 00 B5 C7 5C 00 B4 C7 08 00 E0 03 68 00 BD 27 }
	condition:
		$1
}

rule file_8_7_0 {
	meta:
		name = "_poly_zbuf_ptex_mask8"
		size = 576
		refs = "0060 __extendsfdf2 00ec .text 00f4 __adddf3 0150 __ltdf2 016c __divdf3 0178 __fixdfsi 01d8 __truncdfsf2"
	strings:
		$1 = { 98 FF BD 27 54 00 C3 8C 40 00 CC C4 30 00 B0 AF 21 80 C0 00 50 00 C6 8C 10 00 02 24 23 10 43 00 04 30 66 00 54 00 BF AF 28 00 A6 AF 3C 00 B3 AF 38 00 B2 AF 21 98 80 00 21 90 A0 00 34 00 B1 AF 64 00 B6 E7 60 00 B5 E7 5C 00 B4 E7 50 00 BE AF 4C 00 B7 AF 48 00 B6 AF 44 00 B5 AF 40 00 B4 AF ?? ?? ?? 0? 24 00 A2 AF 18 00 A2 AF 44 00 0C C6 4C 00 02 8E 1C 00 A3 AF 38 00 15 C6 ?? ?? ?? 0? 20 00 A2 AF 34 00 0C C6 10 00 A2 AF 14 00 A3 AF ?? ?? ?? 0? 3C 00 14 C6 30 00 16 C6 5C 00 11 8E 48 00 10 8E 08 00 A2 AF 0C 00 A3 AF 55 00 40 1A 00 00 B0 AF 06 AB 00 46 ?? ?? ?? 0? 21 90 53 02 06 A3 00 46 21 A0 40 00 ?? ?? ?? 0? 21 A8 60 00 06 B3 00 46 2C 00 B2 AF 21 B0 40 00 ?? ?? ?? 0? 21 B8 60 00 21 F0 60 02 21 90 40 00 ?? ?? ?? 0? 21 98 60 00 ?? ?? ?? 0? 00 00 00 00 10 00 A6 8F 14 00 A7 8F 21 20 C0 02 21 28 E0 02 21 A0 40 00 ?? ?? ?? 0? 21 A8 60 00 08 00 A6 8F 0C 00 A7 8F 21 20 40 02 21 28 60 02 21 B0 40 00 ?? ?? ?? 0? 21 B8 60 00 21 90 40 00 21 98 60 00 ?? ?? ?? 0? 00 00 2C C6 21 20 40 00 21 28 60 00 21 30 40 02 ?? ?? ?? 0? 21 38 60 02 21 30 40 02 21 38 60 02 21 20 80 02 1F 00 41 04 21 28 A0 02 ?? ?? ?? 0? 00 00 00 00 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 20 00 A3 8F 03 84 02 00 21 30 40 02 21 38 60 02 21 20 C0 02 21 28 E0 02 ?? ?? ?? 0? 24 80 03 02 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 24 00 A3 8F 21 20 40 02 07 10 62 00 28 00 A3 8F 24 10 43 00 00 00 A3 8F 21 80 70 00 21 80 02 02 00 00 02 92 04 00 40 10 21 28 60 02 ?? ?? ?? 0? 00 00 C2 A3 00 00 20 E6 2C 00 A2 8F 01 00 DE 27 21 20 80 02 21 28 A0 02 18 00 A6 8F 1C 00 A7 8F BD FF C2 17 04 00 31 26 54 00 BF 8F 50 00 BE 8F 4C 00 B7 8F 48 00 B6 8F 44 00 B5 8F 40 00 B4 8F 3C 00 B3 8F 38 00 B2 8F 34 00 B1 8F 30 00 B0 8F 64 00 B6 C7 60 00 B5 C7 5C 00 B4 C7 08 00 E0 03 68 00 BD 27 }
	condition:
		$1
}

rule file_8_8_0 {
	meta:
		name = "_poly_zbuf_ptex_lit8"
		size = 644
		refs = "0060 __extendsfdf2 00a4 color_map 0108 .text 0110 __adddf3 016c __ltdf2 0188 __divdf3 0194 __fixdfsi 020c __truncdfsf2"
	strings:
		$1 = { 90 FF BD 27 54 00 C3 8C 40 00 CC C4 38 00 B0 AF 21 80 C0 00 50 00 C6 8C 10 00 02 24 23 10 43 00 04 30 66 00 5C 00 BF AF 30 00 A6 AF 44 00 B3 AF 40 00 B2 AF 21 98 80 00 21 90 A0 00 3C 00 B1 AF 6C 00 B6 E7 68 00 B5 E7 64 00 B4 E7 58 00 BE AF 54 00 B7 AF 50 00 B6 AF 4C 00 B5 AF 48 00 B4 AF ?? ?? ?? 0? 2C 00 A2 AF 18 00 A2 AF 44 00 0C C6 4C 00 02 8E 1C 00 A3 AF 10 00 03 8E 28 00 A2 AF ?? ?? ?? 0? 24 00 A3 AF 14 00 04 8E 34 00 0C C6 10 00 A2 AF 14 00 A3 AF ?? ?? ?? 0? 20 00 A4 AF 08 00 A2 AF ?? ?? 02 3C 38 00 15 C6 ?? ?? 42 8C 5C 00 11 8E 3C 00 14 C6 30 00 16 C6 48 00 10 8E 0C 00 A3 AF 04 00 A2 AF 5F 00 40 1A 00 00 B0 AF 06 AB 00 46 ?? ?? ?? 0? 21 90 53 02 06 A3 00 46 21 A0 40 00 ?? ?? ?? 0? 21 A8 60 00 06 B3 00 46 34 00 B2 AF 21 B0 40 00 ?? ?? ?? 0? 21 B8 60 00 21 F0 60 02 21 90 40 00 ?? ?? ?? 0? 21 98 60 00 ?? ?? ?? 0? 00 00 00 00 10 00 A6 8F 14 00 A7 8F 21 20 C0 02 21 28 E0 02 21 A0 40 00 ?? ?? ?? 0? 21 A8 60 00 08 00 A6 8F 0C 00 A7 8F 21 20 40 02 21 28 60 02 21 B0 40 00 ?? ?? ?? 0? 21 B8 60 00 21 90 40 00 21 98 60 00 ?? ?? ?? 0? 00 00 2C C6 21 20 40 00 21 28 60 00 21 30 40 02 ?? ?? ?? 0? 21 38 60 02 21 30 40 02 21 38 60 02 21 20 80 02 25 00 41 04 21 28 A0 02 ?? ?? ?? 0? 00 00 00 00 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 03 84 02 00 28 00 A2 8F 21 30 40 02 21 38 60 02 21 20 C0 02 21 28 E0 02 ?? ?? ?? 0? 24 80 02 02 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 2C 00 A3 8F 30 00 A4 8F 21 28 60 02 07 10 62 00 00 00 A3 8F 24 10 44 00 24 00 A4 8F 21 80 70 00 21 80 02 02 00 00 03 92 00 3C 82 7C 00 12 02 00 21 10 43 00 04 00 A3 8F 21 20 40 02 21 10 62 00 00 00 43 90 ?? ?? ?? 0? 00 00 C3 A3 00 00 20 E6 24 00 A2 8F 20 00 A3 8F 01 00 DE 27 21 20 80 02 21 10 43 00 24 00 A2 AF 34 00 A2 8F 21 28 A0 02 18 00 A6 8F 1C 00 A7 8F B3 FF C2 17 04 00 31 26 5C 00 BF 8F 58 00 BE 8F 54 00 B7 8F 50 00 B6 8F 4C 00 B5 8F 48 00 B4 8F 44 00 B3 8F 40 00 B2 8F 3C 00 B1 8F 38 00 B0 8F 6C 00 B6 C7 68 00 B5 C7 64 00 B4 C7 08 00 E0 03 70 00 BD 27 }
	condition:
		$1
}

rule file_8_9_0 {
	meta:
		name = "_poly_zbuf_ptex_mask_lit8"
		size = 648
		refs = "0060 __extendsfdf2 00a4 color_map 0108 .text 0110 __adddf3 016c __ltdf2 0188 __divdf3 0194 __fixdfsi 0210 __truncdfsf2"
	strings:
		$1 = { 90 FF BD 27 54 00 C3 8C 40 00 CC C4 38 00 B0 AF 21 80 C0 00 50 00 C6 8C 10 00 02 24 23 10 43 00 04 30 66 00 5C 00 BF AF 30 00 A6 AF 44 00 B3 AF 40 00 B2 AF 21 98 80 00 21 90 A0 00 3C 00 B1 AF 6C 00 B6 E7 68 00 B5 E7 64 00 B4 E7 58 00 BE AF 54 00 B7 AF 50 00 B6 AF 4C 00 B5 AF 48 00 B4 AF ?? ?? ?? 0? 2C 00 A2 AF 18 00 A2 AF 44 00 0C C6 4C 00 02 8E 1C 00 A3 AF 10 00 03 8E 28 00 A2 AF ?? ?? ?? 0? 24 00 A3 AF 14 00 04 8E 34 00 0C C6 10 00 A2 AF 14 00 A3 AF ?? ?? ?? 0? 20 00 A4 AF 08 00 A2 AF ?? ?? 02 3C 38 00 15 C6 ?? ?? 42 8C 5C 00 11 8E 3C 00 14 C6 30 00 16 C6 48 00 10 8E 0C 00 A3 AF 04 00 A2 AF 60 00 40 1A 00 00 B0 AF 06 AB 00 46 ?? ?? ?? 0? 21 90 53 02 06 A3 00 46 21 A0 40 00 ?? ?? ?? 0? 21 A8 60 00 06 B3 00 46 34 00 B2 AF 21 B0 40 00 ?? ?? ?? 0? 21 B8 60 00 21 F0 60 02 21 90 40 00 ?? ?? ?? 0? 21 98 60 00 ?? ?? ?? 0? 00 00 00 00 10 00 A6 8F 14 00 A7 8F 21 20 C0 02 21 28 E0 02 21 A0 40 00 ?? ?? ?? 0? 21 A8 60 00 08 00 A6 8F 0C 00 A7 8F 21 20 40 02 21 28 60 02 21 B0 40 00 ?? ?? ?? 0? 21 B8 60 00 21 90 40 00 21 98 60 00 ?? ?? ?? 0? 00 00 2C C6 21 20 40 00 21 28 60 00 21 30 40 02 ?? ?? ?? 0? 21 38 60 02 21 30 40 02 21 38 60 02 21 20 80 02 26 00 41 04 21 28 A0 02 ?? ?? ?? 0? 00 00 00 00 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 03 84 02 00 28 00 A2 8F 21 30 40 02 21 38 60 02 21 20 C0 02 21 28 E0 02 ?? ?? ?? 0? 24 80 02 02 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 24 00 A4 8F 2C 00 A6 8F 21 28 60 02 00 3C 83 7C 07 10 C2 00 30 00 A4 8F 00 00 A6 8F 00 1A 03 00 24 10 44 00 21 80 D0 00 21 80 02 02 00 00 02 92 04 00 A6 8F 21 20 40 02 21 18 62 00 05 00 40 10 21 18 C3 00 00 00 62 90 ?? ?? ?? 0? 00 00 C2 A3 00 00 20 E6 24 00 A2 8F 20 00 A3 8F 01 00 DE 27 21 20 80 02 21 10 43 00 24 00 A2 AF 34 00 A2 8F 21 28 A0 02 18 00 A6 8F 1C 00 A7 8F B2 FF C2 17 04 00 31 26 5C 00 BF 8F 58 00 BE 8F 54 00 B7 8F 50 00 B6 8F 4C 00 B5 8F 48 00 B4 8F 44 00 B3 8F 40 00 B2 8F 3C 00 B1 8F 38 00 B0 8F 6C 00 B6 C7 68 00 B5 C7 64 00 B4 C7 08 00 E0 03 70 00 BD 27 }
	condition:
		$1
}

rule file_8_10_0 {
	meta:
		name = "_poly_zbuf_atex_trans8"
		size = 216
		refs = "001c color_map 0058 .text"
	strings:
		$1 = { 54 00 C3 8C 21 60 C0 00 50 00 C6 8C F8 FF BD 27 10 00 02 24 00 00 B0 AF 23 80 43 00 ?? ?? 02 3C 04 00 B1 AF 04 30 66 00 ?? ?? 51 8C 4C 00 99 8D 00 00 8A 8D 04 00 89 8D 08 00 98 8D 0C 00 8F 8D 48 00 8E 8D 60 00 8D 8D 30 00 81 C5 1E 00 A0 18 5C 00 82 8D 21 40 40 00 ?? ?? ?? 0? 21 38 00 00 40 08 00 46 00 00 00 C5 03 14 0A 00 07 18 09 02 3C 00 01 46 24 10 59 00 24 18 66 00 21 10 C2 01 21 10 43 00 21 58 E4 00 21 18 ED 00 21 50 58 01 21 48 2F 01 09 00 00 45 01 00 E7 24 00 00 42 90 00 00 63 90 00 12 02 00 21 10 43 00 21 10 22 02 00 00 43 90 00 00 63 A1 00 00 01 E5 04 00 08 25 E7 FF E5 14 34 00 80 C5 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_8_11_0 {
	meta:
		name = "_poly_zbuf_atex_mask_trans8"
		size = 232
		refs = "001c color_map 0060 .text"
	strings:
		$1 = { 54 00 C3 8C 21 58 C0 00 50 00 C6 8C F0 FF BD 27 10 00 02 24 04 00 B0 AF 23 80 43 00 ?? ?? 02 3C 0C 00 B2 AF 08 00 B1 AF ?? ?? 52 8C 21 88 80 00 04 30 66 00 4C 00 79 8D 00 00 6A 8D 04 00 69 8D 08 00 78 8D 0C 00 6F 8D 48 00 6E 8D 60 00 64 8D 30 00 61 C5 1F 00 A0 18 5C 00 62 8D 21 40 40 00 ?? ?? ?? 0? 21 38 00 00 40 08 00 46 00 00 00 C5 03 14 0A 00 07 18 09 02 3C 00 01 46 24 10 59 00 24 18 66 00 21 10 C2 01 21 10 43 00 21 50 58 01 0C 00 00 45 21 48 2F 01 00 00 42 90 21 60 E4 00 21 68 F1 00 07 00 40 10 00 1A 02 00 00 00 82 91 21 10 62 00 21 10 42 02 00 00 43 90 00 00 A3 A1 00 00 01 E5 01 00 E7 24 04 00 08 25 E6 FF E5 14 34 00 60 C5 0C 00 B2 8F 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 10 00 BD 27 }
	condition:
		$1
}

rule file_8_12_0 {
	meta:
		name = "_poly_zbuf_ptex_trans8"
		size = 644
		refs = "0060 __extendsfdf2 0098 color_map 0100 .text 0108 __adddf3 0170 __ltdf2 019c __divdf3 01a8 __fixdfsi 0220 __truncdfsf2"
	strings:
		$1 = { 88 FF BD 27 54 00 C3 8C 40 00 CC C4 40 00 B0 AF 21 80 C0 00 50 00 C6 8C 10 00 02 24 23 10 43 00 04 30 66 00 30 00 A4 AF 64 00 BF AF 34 00 A5 AF 28 00 A6 AF 74 00 B6 E7 70 00 B5 E7 6C 00 B4 E7 60 00 BE AF 5C 00 B7 AF 58 00 B6 AF 54 00 B5 AF 50 00 B4 AF 4C 00 B3 AF 48 00 B2 AF 44 00 B1 AF ?? ?? ?? 0? 24 00 A2 AF 18 00 A2 AF 44 00 0C C6 4C 00 02 8E 1C 00 A3 AF 38 00 15 C6 ?? ?? ?? 0? 20 00 A2 AF 34 00 0C C6 10 00 A2 AF ?? ?? ?? 0? 14 00 A3 AF 08 00 A2 AF ?? ?? 02 3C ?? ?? 42 8C 3C 00 14 C6 30 00 16 C6 0C 00 A3 AF 04 00 A2 AF 48 00 03 8E 5C 00 02 8E 34 00 A4 8F 60 00 10 8E 00 00 A3 AF 60 00 80 18 2C 00 B0 AF 06 AB 00 46 ?? ?? ?? 0? 21 88 40 00 06 A3 00 46 21 A0 40 00 ?? ?? ?? 0? 21 A8 60 00 06 B3 00 46 21 B0 40 00 ?? ?? ?? 0? 21 B8 60 00 21 F0 00 00 21 90 40 00 ?? ?? ?? 0? 21 98 60 00 ?? ?? ?? 0? 00 00 00 00 10 00 A6 8F 14 00 A7 8F 21 20 C0 02 21 28 E0 02 21 A0 40 00 ?? ?? ?? 0? 21 A8 60 00 08 00 A6 8F 0C 00 A7 8F 21 20 40 02 21 28 60 02 21 B0 40 00 ?? ?? ?? 0? 21 B8 60 00 21 90 40 00 21 98 60 00 30 00 A2 8F 00 00 2C C6 21 10 C2 03 ?? ?? ?? 0? 38 00 A2 AF 21 28 60 00 21 20 40 00 21 30 40 02 ?? ?? ?? 0? 21 38 60 02 2C 00 A4 8F 21 30 40 02 21 38 60 02 21 18 C4 03 21 28 A0 02 21 20 80 02 26 00 41 04 01 00 DE 27 00 00 63 90 ?? ?? ?? 0? 3C 00 A3 AF 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 03 84 02 00 20 00 A2 8F 21 30 40 02 21 38 60 02 21 20 C0 02 21 28 E0 02 ?? ?? ?? 0? 24 80 02 02 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 24 00 A3 8F 28 00 A4 8F 21 28 60 02 07 10 62 00 00 00 A3 8F 24 10 44 00 21 20 40 02 21 80 70 00 21 80 02 02 00 00 02 92 3C 00 A3 8F 00 12 02 00 21 10 43 00 04 00 A3 8F 21 10 62 00 00 00 43 90 38 00 A2 8F ?? ?? ?? 0? 00 00 43 A0 00 00 20 E6 34 00 A3 8F 21 20 80 02 21 28 A0 02 18 00 A6 8F 1C 00 A7 8F B1 FF C3 17 04 00 31 26 64 00 BF 8F 60 00 BE 8F 5C 00 B7 8F 58 00 B6 8F 54 00 B5 8F 50 00 B4 8F 4C 00 B3 8F 48 00 B2 8F 44 00 B1 8F 40 00 B0 8F 74 00 B6 C7 70 00 B5 C7 6C 00 B4 C7 08 00 E0 03 78 00 BD 27 }
	condition:
		$1
}

rule file_8_13_0 {
	meta:
		name = "_poly_zbuf_ptex_mask_trans8"
		size = 636
		refs = "0060 __extendsfdf2 0098 color_map 0100 .text 0108 __adddf3 0164 __ltdf2 0180 __divdf3 018c __fixdfsi 0214 __truncdfsf2"
	strings:
		$1 = { 90 FF BD 27 54 00 C3 8C 40 00 CC C4 38 00 B0 AF 21 80 C0 00 50 00 C6 8C 10 00 02 24 23 10 43 00 04 30 66 00 5C 00 BF AF 30 00 A4 AF 34 00 A5 AF 28 00 A6 AF 6C 00 B6 E7 68 00 B5 E7 64 00 B4 E7 58 00 BE AF 54 00 B7 AF 50 00 B6 AF 4C 00 B5 AF 48 00 B4 AF 44 00 B3 AF 40 00 B2 AF 3C 00 B1 AF ?? ?? ?? 0? 24 00 A2 AF 18 00 A2 AF 44 00 0C C6 4C 00 02 8E 1C 00 A3 AF 38 00 15 C6 ?? ?? ?? 0? 20 00 A2 AF 34 00 0C C6 10 00 A2 AF ?? ?? ?? 0? 14 00 A3 AF 08 00 A2 AF ?? ?? 02 3C ?? ?? 42 8C 0C 00 A3 AF 48 00 03 8E 3C 00 14 C6 30 00 16 C6 04 00 A2 AF 00 00 A3 AF 5C 00 02 8E 34 00 A3 8F 60 00 10 8E 5E 00 60 18 2C 00 B0 AF 06 AB 00 46 ?? ?? ?? 0? 21 F0 40 00 06 A3 00 46 21 A0 40 00 ?? ?? ?? 0? 21 A8 60 00 06 B3 00 46 21 B0 40 00 ?? ?? ?? 0? 21 B8 60 00 21 88 00 00 21 90 40 00 ?? ?? ?? 0? 21 98 60 00 ?? ?? ?? 0? 00 00 00 00 10 00 A6 8F 14 00 A7 8F 21 20 C0 02 21 28 E0 02 21 A0 40 00 ?? ?? ?? 0? 21 A8 60 00 08 00 A6 8F 0C 00 A7 8F 21 20 40 02 21 28 60 02 21 B0 40 00 ?? ?? ?? 0? 21 B8 60 00 21 90 40 00 21 98 60 00 ?? ?? ?? 0? 00 00 CC C7 21 20 40 00 21 28 60 00 21 30 40 02 ?? ?? ?? 0? 21 38 60 02 21 30 40 02 21 38 60 02 21 20 80 02 29 00 41 04 21 28 A0 02 ?? ?? ?? 0? 00 00 00 00 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 03 84 02 00 20 00 A2 8F 21 30 40 02 21 38 60 02 21 20 C0 02 21 28 E0 02 ?? ?? ?? 0? 24 80 02 02 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 2C 00 A3 8F 21 20 40 02 21 28 60 02 21 38 23 02 24 00 A3 8F 07 10 62 00 28 00 A3 8F 24 10 43 00 00 00 A3 8F 21 80 70 00 21 80 02 02 30 00 A3 8F 00 00 02 92 21 30 23 02 09 00 40 10 00 1A 02 00 00 00 E2 90 21 10 62 00 04 00 A3 8F 21 10 62 00 00 00 43 90 ?? ?? ?? 0? 00 00 C3 A0 00 00 C0 E7 34 00 A2 8F 01 00 31 26 21 20 80 02 21 28 A0 02 18 00 A6 8F 1C 00 A7 8F B3 FF 22 16 04 00 DE 27 5C 00 BF 8F 58 00 BE 8F 54 00 B7 8F 50 00 B6 8F 4C 00 B5 8F 48 00 B4 8F 44 00 B3 8F 40 00 B2 8F 3C 00 B1 8F 38 00 B0 8F 6C 00 B6 C7 68 00 B5 C7 64 00 B4 C7 08 00 E0 03 70 00 BD 27 }
	condition:
		$1
}

rule file_8_14_0 {
	meta:
		name = "_poly_zbuf_grgb8"
		size = 268
		refs = "0064 .text 00a8 makecol8"
	strings:
		$1 = { 24 00 C2 8C C8 FF BD 27 28 00 BE AF 24 00 B7 AF 1C 00 B5 AF 18 00 B4 AF 14 00 B3 AF 10 00 B2 AF 34 00 B4 E7 00 00 A2 AF 2C 00 BF AF 20 00 B6 AF 0C 00 B1 AF 08 00 B0 AF 21 90 C0 00 18 00 D5 8C 1C 00 D4 8C 20 00 D3 8C 28 00 DE 8C 2C 00 D7 8C 30 00 D4 C4 20 00 A0 18 5C 00 C2 8C 21 88 80 00 21 80 40 00 ?? ?? ?? 0? 21 B0 A4 00 01 00 31 26 21 A0 9E 02 21 A8 A2 02 21 98 77 02 04 00 10 26 15 00 36 12 34 00 40 C6 00 A5 00 46 00 00 00 C6 3C 00 14 46 00 00 00 00 F4 FF 00 45 00 00 A2 8F 03 24 15 00 03 2C 14 00 ?? ?? ?? 0? 03 34 13 00 00 00 22 A2 00 00 A2 8F 00 00 14 E6 01 00 31 26 21 A8 A2 02 21 A0 9E 02 21 98 77 02 04 00 10 26 ED FF 36 16 34 00 40 C6 2C 00 BF 8F 28 00 BE 8F 24 00 B7 8F 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 34 00 B4 C7 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_9_0_0 {
	meta:
		name = "quat_mul"
		size = 292
		refs = "00f4 .text"
	strings:
		$1 = { F0 FF BD 27 21 40 80 00 3C 00 86 10 21 38 A0 00 31 00 A6 50 00 00 E2 8C 04 00 08 C5 04 00 E3 C4 00 00 E1 C4 00 00 00 C5 42 42 03 46 08 00 04 C5 02 00 01 46 08 00 E2 C4 0C 00 05 C5 0C 00 E6 C4 C2 21 02 46 C2 2A 02 46 42 28 06 46 01 00 09 46 82 22 06 46 10 00 BD 27 01 00 07 46 01 00 01 46 00 00 C0 E4 00 00 01 C5 00 00 E0 C4 C2 08 03 46 02 42 00 46 02 21 00 46 82 08 02 46 02 28 00 46 42 08 06 46 C0 18 08 46 80 10 04 46 C0 18 0A 46 40 08 00 46 C1 18 0B 46 04 00 C3 E4 04 00 E7 C4 04 00 03 C5 42 29 07 46 82 19 06 46 80 10 05 46 81 10 06 46 08 00 C2 E4 08 00 E4 C4 08 00 00 C5 C2 18 04 46 02 00 07 46 40 08 03 46 41 08 00 46 08 00 E0 03 0C 00 C1 E4 04 00 E3 8C 08 00 E4 8C 0C 00 A5 8C 21 38 A0 03 00 00 A2 AF 04 00 A3 AF 08 00 A4 AF ?? ?? ?? 0? 0C 00 A5 AF 0C 00 85 8C 00 00 82 8C 04 00 83 8C 08 00 84 8C 21 40 A0 03 00 00 A2 AF 04 00 A3 AF 08 00 A4 AF ?? ?? ?? 0? 0C 00 A5 AF }
	condition:
		$1
}

rule file_9_1_0 {
	meta:
		name = "quat_to_matrix"
		size = 188
	strings:
		$1 = { 00 00 82 C4 04 00 81 C4 08 00 80 C4 02 11 02 46 C2 0A 01 46 0C 00 83 C4 02 02 00 46 42 12 01 46 82 12 03 46 42 09 03 46 82 01 03 46 82 10 00 46 42 08 00 46 C1 21 0B 46 00 21 0B 46 C2 18 03 46 80 52 0A 46 01 38 08 46 40 4A 09 46 80 10 02 46 40 08 01 46 40 29 05 46 80 31 06 46 01 21 08 46 C0 39 08 46 C0 0A 0A 46 01 2A 02 46 00 33 09 46 00 00 03 46 01 21 03 46 C1 39 03 46 41 08 0A 46 40 29 02 46 81 31 09 46 00 00 A4 E4 0C 00 A1 E4 18 00 A5 E4 04 00 AB E4 10 00 A7 E4 1C 00 A6 E4 08 00 A8 E4 14 00 AC E4 20 00 A0 E4 2C 00 A0 AC 24 00 A0 AC 08 00 E0 03 28 00 A0 AC }
	condition:
		$1
}

rule file_9_2_0 {
	meta:
		name = "apply_quat"
		size = 280
		refs = "00c8 quat_mul"
	strings:
		$1 = { 00 00 81 C4 04 00 83 C4 08 00 84 C4 02 08 01 46 82 18 03 46 04 00 83 8C C2 20 04 46 0C 00 85 C4 00 80 02 3C A8 FF BD 27 26 18 62 00 30 00 A3 AF 00 00 02 46 0C 00 83 8C 02 29 05 46 44 00 B1 AF 26 18 62 00 38 00 A3 AF 00 00 03 46 08 00 83 8C 38 00 A2 C7 20 00 B1 27 26 18 62 00 00 00 04 46 34 00 A3 AF 30 00 A4 C7 34 00 A5 C7 C3 10 00 46 43 08 00 46 83 20 00 46 03 28 00 46 50 00 B4 AF 4C 00 B3 AF 40 00 B0 AF 21 A0 A0 00 21 80 80 00 21 98 C0 00 10 00 A4 27 21 28 A0 03 21 30 20 02 54 00 BF AF 48 00 B2 AF 04 00 AC E7 21 90 E0 00 08 00 AD E7 0C 00 AE E7 00 00 A0 AF 1C 00 A3 E7 10 00 A1 E7 14 00 A2 E7 ?? ?? ?? 0? 18 00 A0 E7 21 20 20 02 21 28 00 02 ?? ?? ?? 0? 21 30 A0 03 08 00 A1 C7 0C 00 A2 C7 04 00 A0 C7 54 00 BF 8F 44 00 B1 8F 00 00 80 E6 40 00 B0 8F 00 00 61 E6 50 00 B4 8F 00 00 42 E6 4C 00 B3 8F 48 00 B2 8F 08 00 E0 03 58 00 BD 27 }
	condition:
		$1
}

rule file_9_3_0 {
	meta:
		name = "quat_slerp"
		size = 1312
		refs = "0098 __extendsfdf2 00b8 __ltdf2 00f4 __gedf2 0100 $LC0 0114 __adddf3 011c .text 0138 __gtdf2 01d0 __subdf3 01d8 $LC1 0244 __muldf3 0288 __truncdfsf2 0434 acos 0448 sin 04a8 __divdf3"
	strings:
		$1 = { 08 00 A1 C4 0C 00 A3 C4 98 FF BD 27 04 00 A0 C4 20 00 A1 E7 1C 00 A3 E7 08 00 82 C4 20 00 A3 C7 24 00 A0 E7 24 00 A1 C7 04 00 80 C4 82 18 02 46 00 00 A3 C4 02 08 00 46 0C 00 81 C4 18 00 A3 E7 1C 00 A3 C7 60 00 B4 E7 00 00 94 C4 42 18 01 46 18 00 A3 C7 00 00 02 46 64 00 B5 E7 46 65 00 46 02 A3 03 46 58 00 BE AF 00 00 01 46 4C 00 B5 AF 44 00 B2 AF 40 00 B1 AF 3C 00 B0 AF 00 03 0C 46 5C 00 BF AF 54 00 B7 AF 50 00 B6 AF 48 00 B3 AF 21 F0 80 00 21 90 E0 00 ?? ?? ?? 0? 21 A8 C0 00 21 80 40 00 1F 00 40 16 21 88 60 00 21 20 40 00 21 28 60 00 21 30 00 00 ?? ?? ?? 0? 21 38 00 00 22 00 40 04 1C 00 A4 8F 18 00 A1 C7 24 00 A3 C7 20 00 A0 C7 00 00 A1 E7 1C 00 A1 C7 04 00 A3 E7 08 00 A0 E7 0C 00 A1 E7 21 20 00 02 21 28 20 02 21 30 00 00 ?? ?? ?? 0? 21 38 00 00 30 00 41 04 ?? ?? 16 3C ?? ?? C6 8E ?? ?? C7 8E 21 20 00 02 21 28 20 02 ?? ?? ?? 0? 00 00 12 24 ?? ?? ?? 0? ?? ?? 04 3C 01 00 02 24 B2 00 42 16 21 20 00 02 21 28 60 00 21 30 00 00 ?? ?? ?? 0? 21 38 00 00 E2 FF 40 18 18 00 A1 C7 1C 00 A4 8F 00 80 08 3C 26 28 11 01 26 20 88 00 34 00 A4 AF 18 00 A4 8F 21 88 A0 00 21 28 20 02 26 20 88 00 28 00 A4 AF 24 00 A4 8F 21 30 00 00 21 38 00 00 26 20 88 00 2C 00 A4 AF 20 00 A4 8F 26 40 88 00 28 00 A4 8F 30 00 A8 AF 00 00 A4 AF 2C 00 A4 8F 04 00 A4 AF 30 00 A4 8F 08 00 A4 AF 34 00 A4 8F 0C 00 A4 AF ?? ?? ?? 0? 21 20 00 02 D2 FF 40 04 ?? ?? 16 3C ?? ?? C4 8E ?? ?? C5 8E 21 30 00 02 21 38 20 02 ?? ?? ?? 0? 00 00 12 24 ?? ?? 04 3C ?? ?? 86 8C ?? ?? 87 8C 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 01 00 40 5C 01 00 12 24 FF 00 42 32 8D 00 40 14 21 20 00 02 ?? ?? ?? 0? 06 AB 00 46 ?? ?? C4 8E ?? ?? C5 8E 21 30 40 00 21 38 60 00 21 90 40 00 ?? ?? ?? 0? 21 98 60 00 21 B0 40 00 21 B8 60 00 ?? ?? ?? 0? 06 A3 00 46 21 20 40 00 21 30 C0 02 21 38 E0 02 ?? ?? ?? 0? 21 28 60 00 00 00 AC C7 21 80 40 00 ?? ?? ?? 0? 21 88 60 00 21 20 40 00 21 30 40 02 21 38 60 02 ?? ?? ?? 0? 21 28 60 00 21 30 40 00 21 38 60 00 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 04 00 CC C7 ?? ?? ?? 0? 00 00 A0 E6 21 20 40 00 21 30 C0 02 21 38 E0 02 ?? ?? ?? 0? 21 28 60 00 04 00 AC C7 21 80 40 00 ?? ?? ?? 0? 21 88 60 00 21 20 40 00 21 30 40 02 21 38 60 02 ?? ?? ?? 0? 21 28 60 00 21 30 40 00 21 38 60 00 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 08 00 CC C7 ?? ?? ?? 0? 04 00 A0 E6 21 20 40 00 21 30 C0 02 21 38 E0 02 ?? ?? ?? 0? 21 28 60 00 08 00 AC C7 21 80 40 00 ?? ?? ?? 0? 21 88 60 00 21 20 40 00 21 30 40 02 21 38 60 02 ?? ?? ?? 0? 21 28 60 00 21 30 40 00 21 38 60 00 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 0C 00 CC C7 ?? ?? ?? 0? 08 00 A0 E6 21 20 40 00 21 30 C0 02 21 38 E0 02 ?? ?? ?? 0? 21 28 60 00 0C 00 AC C7 21 80 40 00 ?? ?? ?? 0? 21 88 60 00 21 20 40 00 21 30 40 02 21 38 60 02 ?? ?? ?? 0? 21 28 60 00 21 30 40 00 21 20 00 02 21 28 20 02 ?? ?? ?? 0? 21 38 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 5C 00 BF 8F 0C 00 A0 E6 58 00 BE 8F 54 00 B7 8F 50 00 B6 8F 4C 00 B5 8F 48 00 B3 8F 44 00 B2 8F 40 00 B1 8F 3C 00 B0 8F 64 00 B5 C7 60 00 B4 C7 08 00 E0 03 68 00 BD 27 02 00 02 24 40 00 42 16 18 00 A0 C7 3C 00 14 46 00 00 00 00 50 FF 01 45 1C 00 A4 8F 18 00 A1 C7 24 00 A3 C7 20 00 A0 C7 00 00 A1 E7 1C 00 A1 C7 04 00 A3 E7 08 00 A0 E7 ?? ?? ?? 0? 0C 00 A1 E7 ?? ?? ?? 0? 21 28 20 02 21 20 40 00 21 28 60 00 21 80 40 00 ?? ?? ?? 0? 21 88 60 00 06 AB 00 46 10 00 A2 AF ?? ?? ?? 0? 14 00 A3 AF ?? ?? C4 8E ?? ?? C5 8E 21 30 40 00 21 38 60 00 21 90 40 00 ?? ?? ?? 0? 21 98 60 00 21 30 40 00 21 38 60 00 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 10 00 A6 8F 14 00 A7 8F 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 30 40 02 21 38 60 02 21 20 00 02 21 28 20 02 21 B0 40 00 ?? ?? ?? 0? 21 B8 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 10 00 A6 8F 14 00 A7 8F 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 90 40 00 21 98 60 00 ?? ?? ?? 0? 00 00 D4 C7 03 00 02 24 F1 FE 42 16 18 00 A1 C7 3C A0 01 46 00 00 00 00 EF FE 00 45 24 00 A3 C7 ?? ?? ?? 0? 1C 00 A4 8F }
	condition:
		$1
}

rule file_9_4_0 {
	meta:
		name = "matrix_to_quat"
		size = 832
		refs = "0024 $LC2 0050 __extendsfdf2 005c $LC1 0070 __gtdf2 00c4 sqrt 00d0 __truncdfsf2 00e4 $LC4 0214 $LC3"
	strings:
		$1 = { D8 FF BD 27 1C 00 B5 E7 18 00 B4 E7 00 00 95 C4 10 00 94 C4 20 00 B6 E7 20 00 96 C4 00 AB 14 46 10 00 B4 AF ?? ?? 14 3C 24 00 B7 E7 00 63 16 46 ?? ?? 97 C6 0C 00 B3 AF 08 00 B2 AF 00 63 17 46 04 00 B1 AF 00 00 B0 AF 21 90 80 00 14 00 BF AF ?? ?? ?? 0? 21 98 A0 00 21 80 40 00 ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 21 28 60 00 ?? ?? ?? 0? 21 88 60 00 61 00 40 1C 21 20 00 02 3C A0 15 46 00 00 00 00 05 00 00 45 00 00 00 00 3C B0 15 46 00 00 00 00 80 00 03 45 00 AB 17 46 3C B0 14 46 00 00 00 00 2B 00 01 45 ?? ?? 8C C6 00 B3 0C 46 01 63 15 46 ?? ?? ?? 0? 01 63 14 46 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 18 00 41 C6 08 00 43 C6 00 00 00 46 ?? ?? 02 3C C0 18 01 46 ?? ?? 42 C4 14 00 BF 8F 10 00 B4 8F C3 18 00 46 82 00 02 46 04 00 B1 8F 00 00 B0 8F 24 00 B7 C7 20 00 B6 C7 1C 00 B5 C7 18 00 B4 C7 04 00 63 E6 14 00 41 C6 1C 00 43 C6 0C 00 62 E6 40 08 03 46 43 08 00 46 08 00 61 E6 0C 00 42 C6 04 00 41 C6 08 00 B2 8F 41 08 02 46 43 08 00 46 00 00 61 E6 0C 00 B3 8F 08 00 E0 03 28 00 BD 27 00 A3 0C 46 01 63 15 46 ?? ?? ?? 0? 01 63 16 46 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 0C 00 41 C6 04 00 42 C6 00 00 00 46 ?? ?? 02 3C 80 10 01 46 ?? ?? 41 C4 14 00 BF 8F 10 00 B4 8F 83 10 00 46 42 00 01 46 04 00 B1 8F 00 00 B0 8F 24 00 B7 C7 20 00 B6 C7 1C 00 B5 C7 18 00 B4 C7 08 00 61 E6 04 00 62 E6 1C 00 42 C6 14 00 41 C6 40 08 02 46 43 08 00 46 0C 00 61 E6 18 00 42 C6 08 00 41 C6 08 00 B2 8F 41 08 02 46 43 08 00 46 00 00 61 E6 0C 00 B3 8F 08 00 E0 03 28 00 BD 27 ?? ?? ?? 0? 21 28 20 02 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 ?? ?? 02 3C ?? ?? 42 C4 ?? ?? 02 3C 14 00 BF 8F 83 10 00 46 ?? ?? 40 C4 10 00 B4 8F 04 00 B1 8F 00 00 B0 8F 24 00 B7 C7 20 00 B6 C7 1C 00 B5 C7 18 00 B4 C7 03 00 02 46 00 00 60 E6 14 00 40 C6 1C 00 41 C6 41 08 00 46 42 08 02 46 04 00 61 E6 18 00 41 C6 08 00 40 C6 01 00 01 46 02 00 02 46 08 00 60 E6 04 00 41 C6 0C 00 40 C6 08 00 B2 8F 01 00 01 46 02 00 02 46 0C 00 60 E6 0C 00 B3 8F 08 00 E0 03 28 00 BD 27 01 63 14 46 ?? ?? ?? 0? 01 63 16 46 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 00 00 00 46 ?? ?? 02 3C ?? ?? 41 C4 14 00 BF 8F 10 00 B4 8F 42 00 01 46 04 00 B1 8F 00 00 B0 8F 24 00 B7 C7 20 00 B6 C7 1C 00 B5 C7 18 00 B4 C7 04 00 61 E6 0C 00 41 C6 04 00 42 C6 80 10 01 46 83 10 00 46 08 00 62 E6 18 00 42 C6 08 00 41 C6 40 08 02 46 43 08 00 46 0C 00 61 E6 1C 00 42 C6 14 00 41 C6 08 00 B2 8F 41 08 02 46 43 08 00 46 00 00 61 E6 0C 00 B3 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_9_5_0 {
	meta:
		name = "get_vector_rotation_quat"
		size = 272
		refs = "0038 vector_length_f 0040 $LC3 0058 __extendsfdf2 0060 $LC5 0070 __muldf3 0078 $LC6 009c cos 00a8 __truncdfsf2 00b8 sin"
	strings:
		$1 = { D8 FF BD 27 0C 00 BF AF 08 00 B2 AF 04 00 B1 AF 21 90 80 00 00 00 B0 AF 24 00 B8 E7 20 00 B7 E7 06 6E 00 46 1C 00 B6 E7 18 00 B5 E7 86 7D 00 46 14 00 B4 E7 46 65 00 46 ?? ?? ?? 0? 06 75 00 46 ?? ?? 02 3C ?? ?? 4C C4 C6 05 00 46 02 B3 0C 46 03 C6 17 46 03 A5 17 46 ?? ?? ?? 0? 43 AD 17 46 ?? ?? 04 3C ?? ?? 86 8C ?? ?? 87 8C 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 ?? ?? 04 3C ?? ?? 86 8C ?? ?? 87 8C 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 21 20 40 00 21 28 60 00 21 80 40 00 ?? ?? ?? 0? 21 88 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 00 00 40 E6 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 02 05 14 46 42 05 15 46 02 00 18 46 0C 00 BF 8F 04 00 B1 8F 00 00 B0 8F 24 00 B8 C7 0C 00 54 E6 04 00 55 E6 08 00 40 E6 20 00 B7 C7 08 00 B2 8F 1C 00 B6 C7 18 00 B5 C7 14 00 B4 C7 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_9_6_0 {
	meta:
		name = "get_rotation_quat"
		size = 556
		refs = "0004 $LC3 004c __extendsfdf2 0054 $LC5 0064 __muldf3 006c $LC6 008c cos 0098 __truncdfsf2 00a8 sin"
	strings:
		$1 = { D0 FF BD 27 ?? ?? 02 3C 20 00 B6 E7 ?? ?? 56 C4 0C 00 B3 AF ?? ?? 13 3C 02 63 16 46 14 00 BF AF 10 00 B4 AF 08 00 B2 AF 21 A0 80 00 04 00 B1 AF 00 00 B0 AF 2C 00 B9 E7 28 00 B8 E7 46 76 00 46 24 00 B7 E7 1C 00 B5 E7 18 00 B4 E7 ?? ?? ?? 0? 06 6D 00 46 ?? ?? 66 8E ?? ?? 67 8E ?? ?? 12 3C 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 ?? ?? 46 8E ?? ?? 47 8E 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 40 00 21 28 60 00 21 80 40 00 ?? ?? ?? 0? 21 88 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 00 02 21 28 20 02 ?? ?? ?? 0? C6 05 00 46 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 02 A3 16 46 ?? ?? ?? 0? 06 06 00 46 ?? ?? 66 8E ?? ?? 67 8E 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 ?? ?? 46 8E ?? ?? 47 8E 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 40 00 21 28 60 00 21 80 40 00 ?? ?? ?? 0? 21 88 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 00 02 21 28 20 02 ?? ?? ?? 0? 46 05 00 46 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 02 CB 16 46 ?? ?? ?? 0? 06 05 00 46 ?? ?? 66 8E ?? ?? 67 8E 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 ?? ?? 46 8E ?? ?? 47 8E 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 40 00 21 28 60 00 21 80 40 00 ?? ?? ?? 0? 21 88 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 00 02 21 28 20 02 ?? ?? ?? 0? 86 05 00 46 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 82 B8 15 46 C2 C0 14 46 02 A9 16 46 82 A1 00 46 42 C5 15 46 02 BD 14 46 82 10 00 46 C2 18 16 46 42 C0 04 46 42 B9 06 46 42 AD 00 46 02 A5 16 46 02 C6 06 46 C2 BD 04 46 81 10 03 46 41 08 05 46 00 A5 15 46 0C 00 82 E6 C0 BD 18 46 14 00 BF 8F 08 00 94 E6 04 00 81 E6 00 00 97 E6 0C 00 B3 8F 10 00 B4 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 2C 00 B9 C7 28 00 B8 C7 24 00 B7 C7 20 00 B6 C7 1C 00 B5 C7 18 00 B4 C7 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_9_7_0 {
	meta:
		name = "get_z_rotate_quat"
		size = 184
		refs = "0000 $LC3 0020 __extendsfdf2 0028 $LC5 0038 __muldf3 0040 $LC6 0064 cos 0070 __truncdfsf2 0080 sin"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 40 C4 F0 FF BD 27 0C 00 BF AF 02 63 00 46 08 00 B2 AF 04 00 B1 AF 21 90 80 00 ?? ?? ?? 0? 00 00 B0 AF ?? ?? 04 3C ?? ?? 86 8C ?? ?? 87 8C 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 ?? ?? 04 3C ?? ?? 86 8C ?? ?? 87 8C 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 21 20 40 00 21 28 60 00 21 80 40 00 ?? ?? ?? 0? 21 88 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 00 00 40 E6 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 0C 00 BF 8F 0C 00 40 E6 08 00 40 AE 04 00 40 AE 04 00 B1 8F 08 00 B2 8F 00 00 B0 8F 08 00 E0 03 10 00 BD 27 }
	condition:
		$1
}

rule file_9_8_0 {
	meta:
		name = "get_y_rotate_quat"
		size = 184
		refs = "0000 $LC3 0020 __extendsfdf2 0028 $LC5 0038 __muldf3 0040 $LC6 0064 cos 0070 __truncdfsf2 0080 sin"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 40 C4 F0 FF BD 27 0C 00 BF AF 02 63 00 46 08 00 B2 AF 04 00 B1 AF 21 90 80 00 ?? ?? ?? 0? 00 00 B0 AF ?? ?? 04 3C ?? ?? 86 8C ?? ?? 87 8C 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 ?? ?? 04 3C ?? ?? 86 8C ?? ?? 87 8C 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 21 20 40 00 21 28 60 00 21 80 40 00 ?? ?? ?? 0? 21 88 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 00 00 40 E6 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 0C 00 BF 8F 08 00 40 E6 0C 00 40 AE 04 00 40 AE 04 00 B1 8F 08 00 B2 8F 00 00 B0 8F 08 00 E0 03 10 00 BD 27 }
	condition:
		$1
}

rule file_9_9_0 {
	meta:
		name = "get_x_rotate_quat"
		size = 184
		refs = "0000 $LC3 0020 __extendsfdf2 0028 $LC5 0038 __muldf3 0040 $LC6 0064 cos 0070 __truncdfsf2 0080 sin"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 40 C4 F0 FF BD 27 0C 00 BF AF 02 63 00 46 08 00 B2 AF 04 00 B1 AF 21 90 80 00 ?? ?? ?? 0? 00 00 B0 AF ?? ?? 04 3C ?? ?? 86 8C ?? ?? 87 8C 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 ?? ?? 04 3C ?? ?? 86 8C ?? ?? 87 8C 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 21 20 40 00 21 28 60 00 21 80 40 00 ?? ?? ?? 0? 21 88 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 00 00 40 E6 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 0C 00 BF 8F 04 00 40 E6 0C 00 40 AE 08 00 40 AE 04 00 B1 8F 08 00 B2 8F 00 00 B0 8F 08 00 E0 03 10 00 BD 27 }
	condition:
		$1
}

rule file_10_0_0 {
	meta:
		name = "_linear_putpixel32"
		size = 604
		refs = "0078 _drawing_mode 0094 _drawing_y_anchor 009c _drawing_y_mask 00a4 _drawing_pattern 00b0 _drawing_x_anchor 00c0 _drawing_x_mask 0130 .text 01d8 _blender_func32 01e4 _blender_alpha"
	strings:
		$1 = { 08 00 82 8C E0 FF BD 27 18 00 B5 AF 14 00 B4 AF 10 00 B3 AF 08 00 B1 AF 1C 00 BF AF 0C 00 B2 AF 04 00 B0 AF 21 98 80 00 21 88 A0 00 21 A0 C0 00 11 00 40 10 21 A8 E0 00 0C 00 82 8C 2A 10 A2 00 3D 00 40 54 1C 00 BF 8F 10 00 82 8C 2A 10 A2 00 39 00 40 10 1C 00 BF 8F 14 00 82 8C 2A 10 C2 00 35 00 40 14 00 00 00 00 18 00 82 8C 2A 10 C2 00 32 00 40 50 18 00 B5 8F ?? ?? 12 3C ?? ?? 43 8E 35 00 60 10 01 00 02 24 5E 00 62 10 05 00 02 24 46 00 62 10 ?? ?? 02 3C ?? ?? 43 8C ?? ?? 04 3C ?? ?? 85 8C ?? ?? 02 3C 23 18 83 02 24 18 65 00 ?? ?? 04 3C ?? ?? 45 8C 10 00 63 24 ?? ?? 82 8C ?? ?? 04 3C ?? ?? 86 8C 80 18 03 00 21 28 A3 00 00 00 A3 8C 23 10 22 02 24 10 46 00 20 00 67 8E 80 10 02 00 21 18 62 00 21 20 60 02 21 28 80 02 09 F8 E0 00 00 00 70 8C ?? ?? 44 8E 80 18 11 00 21 18 43 00 02 00 02 24 26 00 82 10 03 00 02 24 4C 00 82 10 04 00 02 24 17 00 82 54 1C 00 62 8E FF 00 02 3C FF 00 42 34 12 00 02 56 00 00 75 AC ?? ?? ?? 0? 1C 00 62 8E 18 00 B5 8F 14 00 B4 8F 10 00 B3 8F 0C 00 B2 8F 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 20 00 BD 27 20 00 66 8E 21 28 80 02 09 F8 C0 00 21 20 60 02 80 18 11 00 21 18 62 00 00 00 75 AC 1C 00 62 8E 21 20 60 02 1C 00 BF 8F 08 00 59 8C 18 00 B5 8F 14 00 B4 8F 10 00 B3 8F 0C 00 B2 8F 08 00 B1 8F 04 00 B0 8F 08 00 20 03 20 00 BD 27 ?? ?? ?? 0? 00 00 70 AC 24 00 63 8E 21 20 60 02 09 F8 60 00 21 28 80 02 20 00 63 8E 21 28 80 02 21 20 60 02 09 F8 60 00 21 80 40 00 80 90 11 00 21 88 40 00 ?? ?? 02 3C ?? ?? 43 8C 21 80 12 02 ?? ?? 02 3C 00 00 05 8E ?? ?? 46 8C 21 20 A0 02 09 F8 60 00 21 88 32 02 ?? ?? ?? 0? 00 00 22 AE 24 00 63 8E 21 20 60 02 09 F8 60 00 21 28 80 02 20 00 63 8E 21 80 40 00 80 88 11 00 21 28 80 02 21 20 60 02 09 F8 60 00 21 80 11 02 00 00 03 8E 21 10 51 00 26 18 75 00 ?? ?? ?? 0? 00 00 43 AC FF 00 02 3C FF 00 42 34 26 10 02 02 0A A8 02 02 ?? ?? ?? 0? 00 00 75 AC }
	condition:
		$1
}

rule file_10_1_0 {
	meta:
		name = "_linear_getpixel32"
		size = 144
		refs = "0088 .text"
	strings:
		$1 = { F0 FF BD 27 04 00 B0 AF 21 80 A0 00 08 00 B1 AF 0C 00 BF AF 21 28 C0 00 07 00 01 06 21 88 80 00 FF FF 02 24 0C 00 BF 8F 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 10 00 BD 27 00 00 82 8C 2A 10 02 02 F8 FF 40 10 FF FF 02 24 F7 FF C0 04 0C 00 BF 8F 04 00 82 8C 2A 10 C2 00 F3 FF 40 50 FF FF 02 24 24 00 83 8C 09 F8 60 00 00 00 00 00 1C 00 24 8E 80 18 10 00 21 18 62 00 00 00 70 8C 08 00 82 8C 09 F8 40 00 21 20 20 02 ?? ?? ?? 0? 21 10 00 02 }
	condition:
		$1
}

rule file_10_2_0 {
	meta:
		name = "_linear_hline32"
		size = 948
		refs = "0050 _drawing_mode 00b4 _drawing_y_anchor 00bc _drawing_y_mask 00c8 _drawing_pattern 00f4 _drawing_x_anchor 00fc _drawing_x_mask 01b4 .text 0264 _blender_func32 0270 _blender_alpha"
	strings:
		$1 = { E0 FF BD 27 2A 10 E5 00 10 00 B4 AF 0C 00 B3 AF 08 00 B2 AF 00 00 B0 AF 1C 00 BF AF 18 00 B6 AF 14 00 B5 AF 04 00 B1 AF 21 80 A0 00 21 98 80 00 21 90 C0 00 04 00 40 10 21 A0 00 01 21 10 E0 00 21 80 40 00 21 38 A0 00 08 00 62 8E 12 00 40 10 ?? ?? 15 3C 10 00 64 8E 0C 00 62 8E 2A 18 E4 00 02 00 60 14 2C 80 02 02 FF FF 87 24 2A 10 F0 00 52 00 40 14 1C 00 BF 8F 14 00 62 8E 2A 10 42 02 4F 00 40 14 18 00 B6 8F 18 00 62 8E 2A 10 42 02 4B 00 40 10 ?? ?? 15 3C ?? ?? A3 8E 50 00 60 10 23 88 F0 00 01 00 02 24 88 00 62 10 05 00 02 24 62 00 62 10 ?? ?? 03 3C ?? ?? 62 8C ?? ?? 04 3C ?? ?? 85 8C 23 10 42 02 ?? ?? 03 3C ?? ?? 66 8C 24 10 45 00 20 00 63 8E 10 00 42 24 80 10 02 00 21 30 C2 00 21 28 40 02 21 20 60 02 09 F8 60 00 00 00 D2 8C ?? ?? 04 3C ?? ?? 83 8C ?? ?? 09 3C ?? ?? 24 8D 23 18 03 02 ?? ?? A8 8E 24 18 64 00 80 28 10 00 01 00 84 24 23 20 83 00 01 00 27 26 80 18 03 00 21 28 45 00 02 00 02 24 21 30 43 02 19 00 02 11 2D 20 87 00 03 00 02 24 89 00 02 11 04 00 02 24 75 00 02 11 FF 00 02 3C 1C 00 62 8E 21 20 60 02 1C 00 BF 8F 08 00 59 8C 18 00 B6 8F 14 00 B5 8F 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 20 03 20 00 BD 27 2A 10 87 00 02 00 40 14 01 00 84 24 21 20 E0 00 EE FF 80 18 21 30 40 02 23 38 E4 00 00 00 C2 8C FF FF 84 24 04 00 C6 24 00 00 A2 AC FB FF 80 1C 04 00 A5 24 ?? ?? ?? 0? ?? ?? 24 8D 18 00 B6 8F 14 00 B5 8F 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 20 00 BD 27 20 00 66 8E 21 28 40 02 09 F8 C0 00 21 20 60 02 80 18 10 00 21 10 43 00 FF FF 31 26 00 00 54 AC FD FF 21 06 04 00 42 24 1C 00 62 8E 21 20 60 02 1C 00 BF 8F 08 00 59 8C 18 00 B6 8F 14 00 B5 8F 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 20 03 20 00 BD 27 24 00 63 8E 21 28 40 02 09 F8 60 00 21 20 60 02 20 00 66 8E 80 80 10 00 21 28 40 02 21 20 60 02 09 F8 C0 00 21 90 50 00 ?? ?? 03 3C ?? ?? 75 8C 21 80 50 00 ?? ?? 16 3C 00 00 45 8E ?? ?? C6 8E 21 20 80 02 09 F8 A0 02 FF FF 31 26 00 00 02 AE 04 00 52 26 F8 FF 21 06 04 00 10 26 1C 00 62 8E 21 20 60 02 1C 00 BF 8F 08 00 59 8C 18 00 B6 8F 14 00 B5 8F 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 20 03 20 00 BD 27 24 00 63 8E 21 28 40 02 09 F8 60 00 21 20 60 02 20 00 66 8E 80 80 10 00 21 28 40 02 21 20 60 02 09 F8 C0 00 21 90 50 00 21 18 50 00 00 00 42 8E FF FF 31 26 04 00 52 26 26 10 82 02 00 00 62 AC FA FF 21 06 04 00 63 24 ?? ?? ?? 0? 1C 00 62 8E FF 00 43 34 23 38 E4 00 00 00 C2 8C FF FF 84 24 02 00 43 10 04 00 C6 24 00 00 B4 AC FA FF 80 1C 04 00 A5 24 ?? ?? 24 8D 2A 10 87 00 02 00 40 14 01 00 84 24 21 20 E0 00 F2 FF 80 1C 21 30 40 02 ?? ?? ?? 0? 1C 00 62 8E FF 00 02 3C FF 00 48 34 23 38 E4 00 00 00 C2 8C FF FF 84 24 04 00 C6 24 26 18 48 00 0B 10 83 02 00 00 A2 AC F9 FF 80 1C 04 00 A5 24 ?? ?? 24 8D 2A 10 87 00 02 00 40 14 01 00 84 24 21 20 E0 00 F1 FF 80 1C 21 30 40 02 ?? ?? ?? 0? 1C 00 62 8E }
	condition:
		$1
}

rule file_10_3_0 {
	meta:
		name = "_linear_vline32"
		size = 336
		refs = "0048 _drawing_mode 0114 _linear_putpixel32"
	strings:
		$1 = { E0 FF BD 27 2A 10 E6 00 14 00 B4 AF 10 00 B3 AF 0C 00 B2 AF 08 00 B1 AF 1C 00 BF AF 18 00 B5 AF 04 00 B0 AF 21 90 E0 00 21 88 80 00 21 98 A0 00 03 00 40 10 21 A0 00 01 21 90 C0 00 21 30 E0 00 08 00 35 8E 11 00 A0 12 ?? ?? 02 3C 18 00 23 8E 2A 10 43 02 02 00 40 14 14 00 24 8E FF FF 72 24 0C 00 22 8E 2A 10 62 02 31 00 40 14 1C 00 BF 8F 10 00 22 8E 2A 10 62 02 2D 00 40 10 2C 30 C4 00 2A 10 46 02 2A 00 40 14 ?? ?? 02 3C ?? ?? 43 8C 19 00 60 14 2A 10 46 02 0B 00 40 14 80 98 13 00 21 80 C0 00 20 00 23 8E 21 28 00 02 09 F8 60 00 21 20 20 02 01 00 10 26 21 10 53 00 2A 18 50 02 F8 FF 60 10 00 00 54 AC 1C 00 22 8E 21 20 20 02 1C 00 BF 8F 08 00 59 8C 18 00 B5 8F 14 00 B4 8F 10 00 B3 8F 0C 00 B2 8F 08 00 B1 8F 04 00 B0 8F 08 00 20 03 20 00 BD 27 0B 00 40 14 08 00 20 AE 21 80 C0 00 21 30 00 02 21 20 20 02 01 00 10 26 21 28 60 02 ?? ?? ?? 0? 21 38 80 02 2A 10 50 02 F9 FF 40 10 21 30 00 02 08 00 35 AE 1C 00 BF 8F 18 00 B5 8F 14 00 B4 8F 10 00 B3 8F 0C 00 B2 8F 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_11_0_0 {
	meta:
		name = "destroy_rle_sprite"
		size = 24
		refs = "0008 _al_free"
		altNames = "free_packfile"
	strings:
		$1 = { 03 00 80 10 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_13_45_9 {
	meta:
		name = "CalBone_Delete"
		size = 24
		refs = "0008 _ZdlPv"
	strings:
		$1 = { 03 00 80 10 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_13_43_9 {
	meta:
		name = "CalPhysique_Delete"
		size = 24
		refs = "0008 _ZdlPv"
	strings:
		$1 = { 03 00 80 10 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_13_42_9 {
	meta:
		name = "CalQuaternion_Delete"
		size = 24
		refs = "0008 _ZdlPv"
	strings:
		$1 = { 03 00 80 10 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_13_41_9 {
	meta:
		name = "CalRenderer_Delete"
		size = 24
		refs = "0008 _ZdlPv"
	strings:
		$1 = { 03 00 80 10 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_13_39_9 {
	meta:
		name = "CalSpringSystem_Delete"
		size = 24
		refs = "0008 _ZdlPv"
	strings:
		$1 = { 03 00 80 10 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_13_38_9 {
	meta:
		name = "CalVector_Delete"
		size = 24
		refs = "0008 _ZdlPv"
	strings:
		$1 = { 03 00 80 10 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_23_2_112 {
	meta:
		name = "SDL_FreeWAV"
		size = 24
		refs = "0008 free"
	strings:
		$1 = { 03 00 80 10 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_22_3_68 {
	meta:
		name = "_ZdlPv"
		size = 24
		refs = "0008 free"
	strings:
		$1 = { 03 00 80 10 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_22_0_122 {
	meta:
		name = "_ZdlPvRKSt9nothrow_t"
		size = 24
		refs = "0008 free"
	strings:
		$1 = { 03 00 80 10 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_4_2_25 {
	meta:
		name = "destroy_datafile_jpg"
		size = 24
		refs = "0008 destroy_bitmap"
	strings:
		$1 = { 03 00 80 10 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_0_2_26 {
	meta:
		name = "destroy_datafile_png"
		size = 24
		refs = "0008 destroy_bitmap"
	strings:
		$1 = { 03 00 80 10 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_18_21_119 {
	meta:
		name = "sqlite3FreeX"
		size = 24
		refs = "0008 sqlite3GenericFree"
	strings:
		$1 = { 03 00 80 10 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_15_41_119 {
	meta:
		name = "sqlite3_free"
		size = 24
		refs = "0008 sqlite3GenericFree"
	strings:
		$1 = { 03 00 80 10 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_449_1_8 {
	meta:
		name = "tdestroy"
		size = 24
		refs = "0008 .text"
	strings:
		$1 = { 03 00 80 10 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_9_2_125 {
	meta:
		name = "triArchiveClose"
		size = 24
		refs = "0008 free"
	strings:
		$1 = { 03 00 80 10 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_9_1_125 {
	meta:
		name = "triArchiveFileFree"
		size = 24
		refs = "0008 free"
	strings:
		$1 = { 03 00 80 10 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_14_1_125 {
	meta:
		name = "triTimerFree"
		size = 24
		refs = "0008 free"
	strings:
		$1 = { 03 00 80 10 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_11_1_0 {
	meta:
		name = "get_rle_sprite"
		size = 2184
		refs = "0054 _al_malloc 0068 _scratch_mem 008c memcpy 00cc .rodata 0110 .text 0134 _scratch_mem_size 05d0 _al_realloc"
	strings:
		$1 = { 1C 00 85 8C D0 FF BD 27 10 00 B2 AF 00 00 A2 8C 2C 00 BF AF 28 00 BE AF F8 FF 43 24 00 00 A2 AF 19 00 62 2C 24 00 B7 AF 20 00 B6 AF 1C 00 B5 AF 18 00 B4 AF 14 00 B3 AF 0C 00 B1 AF 08 00 B0 AF 21 00 40 14 21 90 80 00 21 98 00 00 21 88 00 00 10 00 04 24 ?? ?? ?? 0? 00 00 00 00 0D 00 40 10 21 80 40 00 00 00 42 8E ?? ?? 03 3C 00 00 A4 8F 00 00 02 AE ?? ?? 65 8C 04 00 43 8E 21 30 20 02 08 00 04 AE 0C 00 13 AE 04 00 03 AE ?? ?? ?? 0? 10 00 04 26 2C 00 BF 8F 21 10 00 02 28 00 BE 8F 24 00 B7 8F 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 E0 03 30 00 BD 27 80 10 03 00 ?? ?? 03 3C ?? ?? 63 24 21 18 62 00 00 00 64 8C 08 00 80 00 00 00 00 00 04 00 42 8E ?? ?? 15 3C E2 01 40 18 ?? ?? A3 8E ?? ?? 17 3C 21 80 60 00 21 88 00 00 21 F0 00 00 00 00 42 8E 48 00 40 18 21 98 00 00 ?? ?? ?? 0? FF FF 16 24 33 01 C2 12 80 10 16 00 21 18 02 02 00 00 64 8C 2F 01 80 18 7F 00 82 28 2E 01 40 10 ?? ?? E2 8E 01 00 82 24 00 00 62 AC ?? ?? E2 8E 01 00 34 26 80 80 14 00 2A 10 50 00 39 01 40 14 00 FC 02 24 1C 00 42 8E ?? ?? B0 8E 21 20 40 02 20 00 47 8C 21 28 60 02 09 F8 E0 00 21 30 C0 03 80 18 11 00 21 18 03 02 00 00 62 AC 21 88 80 02 00 00 42 8E 01 00 73 26 2A 10 62 02 27 00 40 10 ?? ?? E2 8E 1C 00 45 8E 20 00 A3 8C 21 20 40 02 21 28 60 02 09 F8 60 00 21 30 C0 03 1C 00 45 8E FF 00 04 3C FF FF 84 34 04 00 A3 8C 24 10 44 00 D4 FF 62 14 FF FF 02 24 FF FF 04 24 05 00 C4 12 80 10 16 00 21 20 02 02 00 00 83 8C 77 01 60 04 81 FF 62 28 ?? ?? E2 8E 01 00 34 26 80 80 14 00 2A 10 50 00 4D 01 40 14 00 FC 02 24 ?? ?? B0 8E 80 10 11 00 FF FF 04 24 21 10 02 02 00 00 44 AC 00 00 42 8E 01 00 73 26 21 B0 20 02 2A 10 62 02 DC FF 40 14 21 88 80 02 ?? ?? E2 8E 01 00 34 26 80 98 14 00 2A 10 53 00 65 01 40 14 ?? ?? B0 8E 1C 00 45 8E 80 10 11 00 04 00 A4 8C 21 10 02 02 01 00 DE 27 00 00 44 AC 04 00 43 8E 2A 18 C3 03 70 01 60 50 21 88 60 02 ?? ?? ?? 0? 21 88 80 02 04 00 42 8E ?? ?? 15 3C 7E 01 40 18 ?? ?? A3 8E ?? ?? 17 3C 21 80 60 00 21 88 00 00 21 F0 00 00 00 00 42 8E 48 00 40 18 21 98 00 00 ?? ?? ?? 0? FF FF 16 24 B2 00 C2 12 40 10 16 00 21 18 02 02 00 00 64 84 AE 00 80 18 7F 00 82 28 AD 00 40 10 ?? ?? E2 8E 01 00 82 24 00 00 62 A4 ?? ?? E2 8E 01 00 34 26 40 80 14 00 2A 10 50 00 B8 00 40 14 00 FC 02 24 1C 00 42 8E ?? ?? B0 8E 21 20 40 02 20 00 47 8C 21 28 60 02 09 F8 E0 00 21 30 C0 03 40 18 11 00 21 18 03 02 00 00 62 A4 21 88 80 02 00 00 42 8E 01 00 73 26 2A 10 62 02 27 00 40 10 ?? ?? E2 8E 1C 00 45 8E 20 00 A3 8C 21 20 40 02 21 28 60 02 09 F8 60 00 21 30 C0 03 1C 00 45 8E FF 00 04 3C FF FF 84 34 04 00 A3 8C 24 10 44 00 D4 FF 62 14 FF FF 02 24 FF FF 04 24 05 00 C4 12 40 10 16 00 21 20 02 02 00 00 83 84 0A 01 60 04 81 FF 62 28 ?? ?? E2 8E 01 00 34 26 40 80 14 00 2A 10 50 00 F2 00 40 14 00 FC 02 24 ?? ?? B0 8E 40 10 11 00 FF FF 04 24 21 10 02 02 00 00 44 A4 00 00 42 8E 01 00 73 26 21 B0 20 02 2A 10 62 02 DC FF 40 14 21 88 80 02 ?? ?? E2 8E 01 00 34 26 40 98 14 00 2A 10 53 00 21 01 40 14 00 FC 02 24 1C 00 45 8E ?? ?? B0 8E 04 00 42 8E 04 00 A4 8C 40 18 11 00 01 00 DE 27 21 18 03 02 2A 10 C2 03 0B 01 40 10 00 00 64 A4 ?? ?? ?? 0? 21 88 80 02 04 00 42 8E ?? ?? 15 3C 0E FF 40 18 ?? ?? A3 8E ?? ?? 17 3C 21 80 60 00 21 88 00 00 21 F0 00 00 00 00 42 8E 41 00 40 18 21 98 00 00 ?? ?? ?? 0? FF FF 16 24 88 00 C4 12 21 18 16 02 00 00 62 80 85 00 40 18 7F 00 04 24 83 00 44 10 01 00 42 24 00 00 62 A0 ?? ?? E2 8E 01 00 34 26 2A 10 54 00 8E 00 40 14 00 FC 02 24 1C 00 42 8E ?? ?? B0 8E 21 20 40 02 20 00 47 8C 21 28 60 02 09 F8 E0 00 21 30 C0 03 21 18 11 02 00 00 62 A0 21 88 80 02 00 00 42 8E 01 00 73 26 2A 10 62 02 24 00 40 10 ?? ?? E2 8E 1C 00 42 8E 21 20 40 02 21 28 60 02 20 00 43 8C 09 F8 60 00 21 30 C0 03 1C 00 44 8E FF 00 03 3C FF FF 63 34 24 10 43 00 04 00 83 8C D8 FF 62 14 FF FF 04 24 06 00 C4 12 ?? ?? E2 8E 21 18 16 02 00 00 62 80 B0 00 40 04 80 FF 04 24 ?? ?? E2 8E 01 00 34 26 2A 10 54 00 9D 00 40 14 00 FC 02 24 ?? ?? B0 8E FF FF 04 24 01 00 73 26 21 10 11 02 00 00 44 A0 00 00 42 8E 21 B0 20 02 2A 10 62 02 DF FF 40 14 21 88 80 02 ?? ?? E2 8E 01 00 33 26 2A 10 53 00 BC 00 40 14 00 FC 02 24 1C 00 42 8E ?? ?? B0 8E 01 00 DE 27 04 00 44 8C 21 18 11 02 00 00 64 A0 04 00 42 8E 2A 10 C2 03 B0 00 40 10 21 88 60 02 ?? ?? ?? 0? 00 00 42 8E ?? ?? E2 8E 01 00 34 26 40 80 14 00 2A 10 50 00 58 00 40 14 ?? ?? A4 8E ?? ?? A2 8E 40 18 11 00 21 B0 20 02 21 10 43 00 01 00 03 24 00 00 43 A4 21 88 80 02 ?? ?? E2 8E 01 00 34 26 40 80 14 00 2A 10 50 00 4C FF 40 50 1C 00 42 8E 00 FC 02 24 FF 03 10 26 ?? ?? A4 8E 24 80 02 02 ?? ?? ?? 0? 21 28 00 02 ?? ?? 03 3C ?? ?? A2 AE ?? ?? ?? 0? ?? ?? 70 AC ?? ?? E2 8E 01 00 34 26 80 80 14 00 2A 10 50 00 32 00 40 14 ?? ?? A4 8E ?? ?? A2 8E 80 18 11 00 21 B0 20 02 21 10 43 00 01 00 03 24 00 00 43 AC 21 88 80 02 ?? ?? E2 8E 01 00 34 26 80 80 14 00 2A 10 50 00 CB FE 40 50 1C 00 42 8E 00 FC 02 24 FF 03 10 26 ?? ?? A4 8E 24 80 02 02 ?? ?? ?? 0? 21 28 00 02 ?? ?? 03 3C ?? ?? A2 AE ?? ?? ?? 0? ?? ?? 70 AC ?? ?? E2 8E 01 00 34 26 2A 10 54 00 28 00 40 14 00 FC 02 24 ?? ?? A2 8E 01 00 04 24 21 B0 20 02 21 10 51 00 00 00 44 A0 ?? ?? E2 8E 21 88 80 02 01 00 34 26 2A 10 54 00 76 FF 40 50 1C 00 42 8E 00 FC 02 24 00 04 30 26 ?? ?? A4 8E 24 80 02 02 ?? ?? ?? 0? 21 28 00 02 ?? ?? 03 3C ?? ?? A2 AE ?? ?? ?? 0? ?? ?? 70 AC 00 FC 03 24 FF 03 10 26 24 80 03 02 ?? ?? ?? 0? 21 28 00 02 ?? ?? 04 3C ?? ?? A2 AE ?? ?? ?? 0? ?? ?? 90 AC 00 FC 03 24 FF 03 10 26 24 80 03 02 ?? ?? ?? 0? 21 28 00 02 ?? ?? 04 3C ?? ?? A2 AE ?? ?? ?? 0? ?? ?? 90 AC 00 04 30 26 ?? ?? A4 8E 24 80 02 02 ?? ?? ?? 0? 21 28 00 02 ?? ?? 03 3C ?? ?? A2 AE ?? ?? ?? 0? ?? ?? 70 AC FF 03 10 26 ?? ?? A4 8E 24 80 02 02 ?? ?? ?? 0? 21 28 00 02 ?? ?? 03 3C ?? ?? A2 AE ?? ?? ?? 0? ?? ?? 70 AC FF 03 10 26 ?? ?? A4 8E 24 80 02 02 ?? ?? ?? 0? 21 28 00 02 ?? ?? 03 3C ?? ?? A2 AE ?? ?? ?? 0? ?? ?? 70 AC 00 04 30 26 ?? ?? A4 8E 24 80 02 02 ?? ?? ?? 0? 21 28 00 02 ?? ?? 03 3C ?? ?? A2 AE ?? ?? ?? 0? ?? ?? 70 AC F7 FE 40 14 ?? ?? E2 8E FF FF 62 24 ?? ?? ?? 0? 00 00 82 A4 50 FF 44 10 FF FF 42 24 ?? ?? ?? 0? 00 00 62 A0 8A FE 40 14 ?? ?? E2 8E FF FF 62 24 ?? ?? ?? 0? 00 00 82 AC ?? ?? A4 8E 00 FC 02 24 FF 03 70 26 24 80 02 02 ?? ?? ?? 0? 21 28 00 02 1C 00 45 8E ?? ?? A2 AE ?? ?? 03 3C ?? ?? 70 AC ?? ?? B0 8E 04 00 A4 8C 80 10 11 00 21 10 02 02 00 00 44 AC 04 00 43 8E 01 00 DE 27 2A 18 C3 03 39 FE 60 54 21 88 80 02 21 88 60 02 ?? ?? ?? 0? 10 00 64 26 00 04 30 26 ?? ?? A4 8E 24 80 02 02 ?? ?? ?? 0? 21 28 00 02 ?? ?? 03 3C ?? ?? A2 AE ?? ?? ?? 0? ?? ?? 70 AC FF 03 70 26 ?? ?? A4 8E 24 80 02 02 ?? ?? ?? 0? 21 28 00 02 ?? ?? 03 3C ?? ?? A2 AE ?? ?? ?? 0? ?? ?? 70 AC 21 98 00 00 21 88 60 02 ?? ?? ?? 0? 10 00 64 26 }
	condition:
		$1
}

rule file_12_0_0 {
	meta:
		name = "_linear_draw_sprite_ex32"
		size = 1080
		refs = "00f4 _blender_func32 018c _blender_alpha 036c .text 0374 _blender_col_32"
	strings:
		$1 = { B0 FF BD 27 02 00 02 24 38 00 B4 AF 4C 00 BF AF 48 00 BE AF 44 00 B7 AF 40 00 B6 AF 3C 00 B5 AF 34 00 B3 AF 30 00 B2 AF 2C 00 B1 AF 28 00 B0 AF 20 00 A4 AF 21 60 A0 00 E4 00 22 11 21 A0 00 01 01 00 03 24 6C 00 23 11 FF FF 0B 24 03 00 22 39 0B 58 62 00 18 00 AB AF 20 00 A3 8F 08 00 62 8C 6B 00 40 50 04 00 82 8D 0C 00 62 8C 10 00 63 8C 00 00 84 8D 23 50 46 00 23 18 66 00 21 10 00 00 2C 50 42 01 2D 18 64 00 23 98 6A 00 4E 00 60 1A 01 00 02 24 E3 00 22 11 21 30 46 01 03 00 02 24 E1 00 22 11 23 10 8A 00 20 00 A4 8F 14 00 82 8C 18 00 83 8C 04 00 84 8D 23 40 47 00 23 18 67 00 21 10 00 00 2C 40 02 01 2D 18 64 00 23 18 68 00 3D 00 60 18 1C 00 A3 AF FE FF 22 25 02 00 42 2C CA 00 40 14 21 28 07 01 20 00 A4 8F 00 C0 03 3C 2C 00 82 8C ?? ?? 04 3C 24 10 43 00 58 00 40 14 ?? ?? 96 8C 1C 00 A2 8F 2F 00 40 18 10 00 02 25 80 10 02 00 21 10 82 01 80 50 0A 00 80 30 06 00 0C 00 A2 AF 04 00 AA AF 00 00 A6 AF 80 A8 0B 00 21 F0 A0 00 21 B8 00 00 20 00 A2 8F 21 28 C0 03 20 00 43 8C 21 20 40 00 0C 00 A2 8F 09 F8 60 00 00 00 50 8C 13 00 60 1A 04 00 A3 8F 00 00 A4 8F 21 90 03 02 21 88 44 00 21 80 00 00 00 00 42 8E FF 00 03 3C FF 00 63 34 06 00 43 10 01 00 04 24 7C 00 84 12 02 00 03 24 74 00 83 12 ?? ?? 04 3C 00 00 22 AE 01 00 10 26 04 00 52 26 F3 FF 13 16 21 88 35 02 1C 00 A3 8F 0C 00 A4 8F 01 00 F7 26 2A 10 E3 02 18 00 A3 8F 04 00 84 24 0C 00 A4 AF DD FF 40 14 21 F0 C3 03 4C 00 BF 8F 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 50 00 BD 27 18 00 A3 AF 20 00 A3 8F 08 00 62 8C 99 FF 40 54 0C 00 62 8C 04 00 82 8D 00 00 93 8D 1C 00 A2 AF 01 00 02 24 6F 00 22 11 03 00 02 24 6D 00 22 11 FE FF 22 25 02 00 42 2C 71 00 40 14 1C 00 A3 8F 20 00 A4 8F 00 C0 03 3C 21 28 E0 00 2C 00 82 8C ?? ?? 04 3C 21 50 00 00 24 10 43 00 21 40 00 00 AA FF 40 10 ?? ?? 96 8C 1C 00 A3 8F 2E 00 60 18 10 00 02 25 80 10 02 00 21 10 82 01 80 50 0A 00 80 30 06 00 10 00 A2 AF 14 00 AA AF 08 00 A6 AF 80 A8 0B 00 21 F0 A0 00 21 B8 00 00 20 00 A4 8F 10 00 A2 8F 21 28 C0 03 20 00 83 8C 09 F8 60 00 00 00 50 8C 13 00 60 1A 14 00 A3 8F 08 00 A4 8F 21 90 03 02 21 88 44 00 21 80 00 00 00 00 42 8E FF 00 03 3C FF 00 63 34 06 00 43 10 01 00 04 24 34 00 84 12 02 00 03 24 2C 00 83 12 ?? ?? 04 3C 00 00 22 AE 01 00 10 26 04 00 52 26 F3 FF 13 16 21 88 35 02 1C 00 A3 8F 10 00 A4 8F 01 00 F7 26 2A 10 E3 02 18 00 A3 8F 04 00 84 24 10 00 A4 AF DE FF 40 14 21 F0 C3 03 20 00 A4 8F 4C 00 BF 8F 48 00 BE 8F 1C 00 82 8C 44 00 B7 8F 40 00 B6 8F 08 00 59 8C 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 20 03 50 00 BD 27 ?? ?? 86 8C 00 00 25 8E 09 F8 C0 02 21 20 40 00 ?? ?? ?? 0? 00 00 22 AE ?? ?? 03 3C ?? ?? 64 8C ?? ?? 03 3C ?? ?? 66 8C 09 F8 C0 02 21 28 40 00 ?? ?? ?? 0? 00 00 22 AE ?? ?? 86 8C 00 00 25 8E 09 F8 C0 02 21 20 40 00 ?? ?? ?? 0? 00 00 22 AE ?? ?? 03 3C ?? ?? 64 8C ?? ?? 03 3C ?? ?? 66 8C 09 F8 C0 02 21 28 40 00 ?? ?? ?? 0? 00 00 22 AE FF FF 02 24 01 00 0B 24 ?? ?? ?? 0? 18 00 A2 AF FF FF 62 26 21 30 46 00 FE FF 22 25 02 00 42 2C 93 FF 40 10 20 00 A4 8F 1C 00 A3 8F 21 50 00 00 21 40 00 00 FF FF 62 24 ?? ?? ?? 0? 21 28 47 00 23 10 88 00 1C 00 A4 8F 21 18 A3 00 FF FF 65 24 ?? ?? ?? 0? 23 40 44 00 23 10 8A 00 21 18 D3 00 23 50 53 00 ?? ?? ?? 0? FF FF 66 24 }
	condition:
		$1
}

rule file_12_1_0 {
	meta:
		name = "_linear_draw_sprite32"
		size = 552
	strings:
		$1 = { 08 00 82 8C D0 FF BD 27 1C 00 B5 AF 2C 00 BF AF 28 00 BE AF 24 00 B7 AF 20 00 B6 AF 18 00 B4 AF 14 00 B3 AF 10 00 B2 AF 0C 00 B1 AF 08 00 B0 AF 4A 00 40 10 21 A8 80 00 0C 00 82 8C 10 00 83 8C 00 00 A4 8C 23 48 46 00 23 18 66 00 21 50 00 00 2D 18 64 00 2C 48 2A 01 23 80 69 00 67 00 00 5A 2C 00 BF 8F 14 00 A2 8E 18 00 A3 8E 04 00 A4 8C 23 40 47 00 23 18 67 00 2C 40 0A 01 2D 18 64 00 23 B0 68 00 5D 00 C0 5A 2C 00 BF 8F 2C 00 A2 8E 00 C0 03 3C 21 30 26 01 24 10 43 00 38 00 40 10 21 B8 07 01 1E 00 C0 1A 10 00 02 25 80 10 02 00 21 98 A2 00 80 48 09 00 FF 00 02 3C 00 00 A9 AF 80 F0 06 00 FF 00 54 34 21 90 00 00 20 00 A3 8E 21 20 A0 02 21 28 57 02 09 F8 60 00 00 00 71 8E 0B 00 00 1A 00 00 A3 8F 21 10 5E 00 21 28 23 02 21 18 00 00 00 00 A4 8C 01 00 63 24 02 00 94 10 04 00 A5 24 00 00 44 AC FA FF 70 14 04 00 42 24 01 00 52 26 2A 10 56 02 EC FF 40 14 04 00 73 26 1C 00 A2 8E 21 20 A0 02 2C 00 BF 8F 08 00 59 8C 28 00 BE 8F 24 00 B7 8F 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 20 03 30 00 BD 27 2C 00 A2 8E 00 C0 03 3C 00 00 B0 8C 24 10 43 00 04 00 B6 8C 21 B8 E0 00 21 48 00 00 CA FF 40 14 21 40 00 00 1D 00 C0 1A 10 00 02 25 80 10 02 00 10 00 E3 26 21 20 A2 00 80 18 03 00 FF 00 02 3C 21 18 A3 02 80 28 09 00 80 30 06 00 FF 00 47 34 21 58 00 00 00 00 82 8C 0B 00 00 1A 00 00 68 8C 21 48 45 00 21 50 06 01 21 10 00 00 00 00 28 8D 01 00 42 24 02 00 07 11 04 00 29 25 00 00 48 AD FA FF 50 14 04 00 4A 25 01 00 6B 25 2A 10 76 01 04 00 84 24 EF FF 40 14 04 00 63 24 2C 00 BF 8F 28 00 BE 8F 24 00 B7 8F 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_12_3_0 {
	meta:
		name = "_linear_draw_256_sprite32"
		size = 620
		refs = "008c _palette_expansion_table"
	strings:
		$1 = { 08 00 82 8C D0 FF BD 27 1C 00 B5 AF 14 00 B3 AF 2C 00 BF AF 28 00 BE AF 24 00 B7 AF 20 00 B6 AF 18 00 B4 AF 10 00 B2 AF 0C 00 B1 AF 08 00 B0 AF 21 A8 80 00 52 00 40 10 21 98 A0 00 0C 00 82 8C 10 00 83 8C 00 00 A4 8C 23 B0 46 00 23 18 66 00 21 28 00 00 2D 18 64 00 2C B0 C5 02 23 80 76 00 77 00 00 1A 2C 00 BF 8F 14 00 A2 8E 18 00 A3 8E 04 00 64 8E 23 88 47 00 23 18 67 00 2C 88 25 02 2D 18 64 00 23 B8 71 00 6D 00 E0 1A ?? ?? 02 3C 1C 00 A5 8E ?? ?? 43 8C 00 00 A4 8C 21 30 C6 02 04 00 A6 AF 09 F8 60 00 21 F0 27 02 21 90 40 00 2C 00 A2 8E 00 C0 03 3C 24 10 43 00 40 00 40 10 00 00 00 00 1F 00 E0 1A 10 00 22 26 80 10 02 00 21 A0 62 02 04 00 A2 8F 21 98 00 00 80 10 02 00 00 00 A2 AF 20 00 A3 8E 21 20 A0 02 21 28 7E 02 09 F8 60 00 00 00 91 8E 0E 00 00 1A 00 00 A3 8F 21 28 36 02 21 20 00 00 21 30 43 00 00 00 A3 90 01 00 84 24 01 00 A5 24 80 10 03 00 03 00 60 10 21 10 42 02 00 00 42 8C 00 00 C2 AC F7 FF 90 14 04 00 C6 24 01 00 73 26 2A 10 77 02 E9 FF 40 14 04 00 94 26 1C 00 A2 8E 21 20 A0 02 2C 00 BF 8F 08 00 59 8C 28 00 BE 8F 24 00 B7 8F 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 20 03 30 00 BD 27 00 00 B0 8C 04 00 B7 8C 1C 00 A5 8E ?? ?? 02 3C ?? ?? 43 8C 00 00 A4 8C 04 00 A6 AF 09 F8 60 00 21 F0 E0 00 21 90 40 00 2C 00 A2 8E 00 C0 03 3C 21 B0 00 00 24 10 43 00 C2 FF 40 14 21 88 00 00 1E 00 E0 1A 10 00 22 26 80 10 02 00 21 28 62 02 04 00 A2 8F 10 00 C3 27 80 18 03 00 21 20 A3 02 80 30 02 00 21 58 00 00 00 00 A2 8C 0E 00 00 1A 00 00 83 8C 21 48 56 00 21 50 66 00 21 40 00 00 00 00 23 91 01 00 08 25 01 00 29 25 80 10 03 00 03 00 60 10 21 10 42 02 00 00 42 8C 00 00 42 AD F7 FF 10 15 04 00 4A 25 01 00 6B 25 2A 10 77 01 04 00 A5 24 EC FF 40 14 04 00 84 24 2C 00 BF 8F 28 00 BE 8F 24 00 B7 8F 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_12_4_0 {
	meta:
		name = "_linear_draw_sprite_v_flip32"
		size = 568
	strings:
		$1 = { 08 00 82 8C D0 FF BD 27 1C 00 B5 AF 2C 00 BF AF 28 00 BE AF 24 00 B7 AF 20 00 B6 AF 18 00 B4 AF 14 00 B3 AF 10 00 B2 AF 0C 00 B1 AF 08 00 B0 AF 4D 00 40 10 21 A8 80 00 0C 00 82 8C 10 00 83 8C 00 00 A4 8C 23 40 46 00 23 18 66 00 21 48 00 00 2D 18 64 00 2C 40 09 01 23 80 68 00 6B 00 00 5A 2C 00 BF 8F 14 00 A3 8E 18 00 A2 8E 04 00 A4 8C 23 18 67 00 23 10 47 00 2C 18 69 00 2D 10 44 00 23 B0 43 00 60 00 C0 1A FF FF E2 24 21 10 43 00 21 B8 56 00 2C 00 A2 8E 23 18 83 00 23 20 76 00 00 C0 03 3C 24 10 43 00 39 00 40 10 21 30 06 01 1E 00 C0 1A 10 00 82 24 80 10 02 00 21 98 A2 00 80 40 08 00 FF 00 02 3C 00 00 A8 AF 80 F0 06 00 FF 00 54 34 21 90 00 00 20 00 A3 8E 21 20 A0 02 23 28 F2 02 09 F8 60 00 00 00 71 8E 0B 00 00 1A 00 00 A3 8F 21 10 5E 00 21 28 23 02 21 18 00 00 00 00 A4 8C 01 00 63 24 02 00 94 10 04 00 A5 24 00 00 44 AC FA FF 70 14 04 00 42 24 01 00 52 26 2A 10 56 02 EC FF 40 14 04 00 73 26 1C 00 A2 8E 21 20 A0 02 2C 00 BF 8F 08 00 59 8C 28 00 BE 8F 24 00 B7 8F 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 20 03 30 00 BD 27 04 00 B6 8C 00 C0 03 3C 00 00 B0 8C FF FF C2 26 21 B8 47 00 2C 00 A2 8E 21 40 00 00 24 10 43 00 C9 FF 40 14 21 20 00 00 1D 00 C0 1A 10 00 82 24 80 10 02 00 10 00 E3 26 21 20 A2 00 80 18 03 00 FF 00 02 3C 21 18 A3 02 80 28 08 00 80 30 06 00 FF 00 47 34 21 58 00 00 00 00 82 8C 0B 00 00 1A 00 00 68 8C 21 48 45 00 21 50 06 01 21 10 00 00 00 00 28 8D 01 00 42 24 02 00 07 11 04 00 29 25 00 00 48 AD FA FF 50 14 04 00 4A 25 01 00 6B 25 2A 10 76 01 04 00 84 24 EF FF 40 14 FC FF 63 24 2C 00 BF 8F 28 00 BE 8F 24 00 B7 8F 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_12_5_0 {
	meta:
		name = "_linear_draw_sprite_h_flip32"
		size = 572
	strings:
		$1 = { 08 00 82 8C D0 FF BD 27 1C 00 B5 AF 2C 00 BF AF 28 00 BE AF 24 00 B7 AF 20 00 B6 AF 18 00 B4 AF 14 00 B3 AF 10 00 B2 AF 0C 00 B1 AF 08 00 B0 AF 4D 00 40 10 21 A8 80 00 0C 00 83 8C 10 00 82 8C 00 00 AA 8C 23 48 66 00 23 10 46 00 21 58 00 00 2C 48 2B 01 2D 10 4A 00 23 80 49 00 6C 00 00 5A 2C 00 BF 8F 14 00 82 8C 18 00 83 8C 04 00 A4 8C 23 40 47 00 23 18 67 00 2C 40 0B 01 2D 18 64 00 23 B0 68 00 61 00 C0 1A FF FF C2 24 21 10 49 00 21 30 50 00 2C 00 A2 8E 23 18 49 01 23 20 70 00 00 C0 03 3C 24 10 43 00 3A 00 40 10 21 B8 07 01 1E 00 C0 1A 10 00 02 25 80 10 02 00 21 98 A2 00 80 20 04 00 FF 00 02 3C 00 00 A4 AF 80 F0 06 00 FF 00 54 34 21 90 00 00 20 00 A3 8E 21 20 A0 02 21 28 57 02 09 F8 60 00 00 00 71 8E 0B 00 00 1A 00 00 A3 8F 21 10 5E 00 21 28 23 02 21 18 00 00 00 00 A4 8C 01 00 63 24 02 00 94 10 04 00 A5 24 00 00 44 AC FA FF 70 14 FC FF 42 24 01 00 52 26 2A 10 56 02 EC FF 40 14 04 00 73 26 1C 00 A2 8E 21 20 A0 02 2C 00 BF 8F 08 00 59 8C 28 00 BE 8F 24 00 B7 8F 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 20 03 30 00 BD 27 00 00 B0 8C 00 C0 03 3C 04 00 B6 8C FF FF 02 26 21 30 46 00 2C 00 A2 8E 21 B8 E0 00 21 20 00 00 24 10 43 00 C8 FF 40 14 21 40 00 00 1D 00 C0 1A 10 00 02 25 80 10 02 00 10 00 E3 26 80 18 03 00 21 28 A2 00 FF 00 02 3C 80 38 04 00 21 18 A3 02 80 30 06 00 FF 00 44 34 21 58 00 00 00 00 A2 8C 0B 00 00 1A 00 00 68 8C 21 48 47 00 21 50 06 01 21 10 00 00 00 00 28 8D 01 00 42 24 02 00 04 11 04 00 29 25 00 00 48 AD FA FF 50 14 FC FF 4A 25 01 00 6B 25 2A 10 76 01 04 00 A5 24 EF FF 40 14 04 00 63 24 2C 00 BF 8F 28 00 BE 8F 24 00 B7 8F 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_12_6_0 {
	meta:
		name = "_linear_draw_sprite_vh_flip32"
		size = 596
	strings:
		$1 = { 08 00 82 8C D0 FF BD 27 1C 00 B5 AF 2C 00 BF AF 28 00 BE AF 24 00 B7 AF 20 00 B6 AF 18 00 B4 AF 14 00 B3 AF 10 00 B2 AF 0C 00 B1 AF 08 00 B0 AF 21 A8 80 00 51 00 40 10 21 40 A0 00 10 00 82 8C 0C 00 83 8C 00 00 AB 8C 23 10 46 00 23 20 66 00 21 50 00 00 2C 20 8A 00 2D 10 4B 00 23 80 44 00 71 00 00 5A 2C 00 BF 8F 14 00 A3 8E 18 00 A2 8E 04 00 A9 8C 23 28 67 00 23 10 47 00 2C 28 AA 00 2D 10 49 00 23 B0 45 00 66 00 C0 1A FF FF C2 24 21 10 44 00 FF FF E3 24 21 30 50 00 2C 00 A2 8E 21 18 65 00 21 B8 76 00 00 C0 03 3C 23 20 64 01 23 28 25 01 24 10 43 00 23 20 90 00 3B 00 40 10 23 28 B6 00 1E 00 C0 1A 10 00 A2 24 80 10 02 00 21 98 02 01 80 20 04 00 FF 00 02 3C 00 00 A4 AF 80 F0 06 00 FF 00 54 34 21 90 00 00 20 00 A3 8E 21 20 A0 02 23 28 F2 02 09 F8 60 00 00 00 71 8E 0B 00 00 1A 00 00 A3 8F 21 10 5E 00 21 28 23 02 21 18 00 00 00 00 A4 8C 01 00 63 24 02 00 94 10 04 00 A5 24 00 00 44 AC FA FF 70 14 FC FF 42 24 01 00 52 26 2A 10 56 02 EC FF 40 14 04 00 73 26 1C 00 A2 8E 21 20 A0 02 2C 00 BF 8F 08 00 59 8C 28 00 BE 8F 24 00 B7 8F 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 20 03 30 00 BD 27 00 00 B0 8C 04 00 B6 8C 21 20 00 00 FF FF 02 26 21 30 46 00 2C 00 A2 8E FF FF C3 26 21 B8 67 00 00 C0 03 3C 24 10 43 00 C7 FF 40 14 21 28 00 00 1D 00 C0 1A 10 00 A2 24 80 10 02 00 10 00 E3 26 80 18 03 00 21 28 02 01 FF 00 02 3C 21 18 A3 02 80 20 04 00 80 30 06 00 FF 00 47 34 21 58 00 00 00 00 A2 8C 0B 00 00 1A 00 00 68 8C 21 48 44 00 21 50 06 01 21 10 00 00 00 00 28 8D 01 00 42 24 02 00 07 11 04 00 29 25 00 00 48 AD FA FF 50 14 FC FF 4A 25 01 00 6B 25 2A 10 76 01 04 00 A5 24 EF FF 40 14 FC FF 63 24 2C 00 BF 8F 28 00 BE 8F 24 00 B7 8F 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_12_7_0 {
	meta:
		name = "_linear_draw_trans_sprite32"
		size = 984
		refs = "0094 _blender_func32 00ec _blender_alpha"
	strings:
		$1 = { 08 00 82 8C B0 FF BD 27 40 00 B6 AF 4C 00 BF AF 48 00 BE AF 44 00 B7 AF 3C 00 B5 AF 38 00 B4 AF 34 00 B3 AF 30 00 B2 AF 2C 00 B1 AF 28 00 B0 AF 61 00 40 10 21 B0 80 00 0C 00 82 8C 10 00 83 8C 00 00 A4 8C 23 10 46 00 23 18 66 00 21 48 00 00 2C 10 49 00 2D 18 64 00 23 A0 62 00 92 00 80 1A 18 00 A2 AF 14 00 C2 8E 18 00 C3 8E 04 00 A4 8C 23 40 47 00 23 18 67 00 2C 40 09 01 2D 18 64 00 23 18 68 00 88 00 60 18 20 00 A3 AF 18 00 A2 8F 21 38 07 01 ?? ?? 03 3C 21 30 46 00 1C 00 A2 8C 1C 00 A7 AF 00 00 44 8C 08 00 02 24 4E 00 82 14 ?? ?? 75 8C 1C 00 C3 8E 00 00 62 8C 4B 00 44 50 2C 00 C2 8E 20 00 A4 8F 2D 00 80 18 10 00 02 25 FF FF 94 26 80 10 02 00 80 30 06 00 10 00 B4 AF 21 B8 A2 00 08 00 A6 AF 21 A0 00 00 ?? ?? 1E 3C 1C 00 A2 8F 24 00 C3 8E 21 20 C0 02 21 80 82 02 21 28 00 02 09 F8 60 00 00 00 F2 8E 20 00 C3 8E 21 28 00 02 21 20 C0 02 09 F8 60 00 21 88 40 00 10 00 A3 8F 10 00 60 04 08 00 A3 8F 18 00 A4 8F 10 00 B0 8F 21 98 44 02 21 90 23 02 21 88 43 00 00 00 64 92 00 00 45 8E ?? ?? C6 8F FF FF 10 26 09 F8 A0 02 01 00 73 26 00 00 22 AE 04 00 52 26 F7 FF 01 06 04 00 31 26 20 00 A4 8F 01 00 94 26 2A 10 84 02 DE FF 40 14 04 00 F7 26 1C 00 C3 8E 08 00 79 8C 21 20 C0 02 4C 00 BF 8F 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 20 03 50 00 BD 27 1C 00 A2 8C 04 00 A3 8C 00 00 B4 8C 00 00 44 8C 20 00 A3 AF 08 00 02 24 ?? ?? 03 3C 1C 00 A7 AF 18 00 A0 AF 21 40 00 00 B4 FF 82 10 ?? ?? 75 8C 2C 00 C2 8E 00 C0 03 3C 24 10 43 00 38 00 40 14 20 00 A3 8F 20 00 A2 8F 29 00 40 18 10 00 02 25 80 10 02 00 1C 00 A4 8F 21 B8 A2 00 18 00 A2 8F 10 00 83 24 80 18 03 00 80 10 02 00 80 30 06 00 14 00 A2 AF FF 00 02 3C 21 B0 C3 02 0C 00 A6 AF FF 00 5E 34 21 98 00 00 00 00 E2 8E 12 00 80 1A 00 00 C5 8E 14 00 A3 8F 0C 00 A4 8F 21 80 00 00 21 90 43 00 21 88 A4 00 00 00 42 8E 01 00 10 26 04 00 52 26 06 00 5E 10 21 20 40 00 ?? ?? 02 3C 00 00 25 8E 09 F8 A0 02 ?? ?? 46 8C 00 00 22 AE F5 FF 14 16 04 00 31 26 20 00 A3 8F 01 00 73 26 04 00 F7 26 2A 10 63 02 E7 FF 40 14 04 00 D6 26 4C 00 BF 8F 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 50 00 BD 27 30 00 60 18 18 00 A4 8F 10 00 02 25 80 10 02 00 80 30 06 00 80 20 04 00 21 F0 A2 00 04 00 A6 AF 00 00 A4 AF 21 B8 00 00 1C 00 A2 8F 24 00 C3 8E 21 20 C0 02 21 80 E2 02 21 28 00 02 09 F8 60 00 00 00 D1 8F 20 00 C3 8E 21 28 00 02 21 20 C0 02 09 F8 60 00 21 90 40 00 15 00 80 1A 04 00 A4 8F 00 00 A3 8F 21 80 00 00 21 98 44 02 21 88 23 02 21 90 44 00 00 00 22 8E FF 00 03 3C FF 00 63 34 01 00 10 26 04 00 31 26 06 00 43 10 21 20 40 00 ?? ?? 02 3C 00 00 65 8E 09 F8 A0 02 ?? ?? 46 8C 00 00 42 AE 04 00 73 26 F2 FF 14 16 04 00 52 26 20 00 A3 8F 01 00 F7 26 2A 10 E3 02 DA FF 40 14 04 00 DE 27 1C 00 C2 8E 21 20 C0 02 4C 00 BF 8F 08 00 59 8C 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 20 03 50 00 BD 27 }
	condition:
		$1
}

rule file_12_8_0 {
	meta:
		name = "_linear_draw_lit_sprite32"
		size = 688
		refs = "0094 _blender_func32 0130 _blender_col_32"
	strings:
		$1 = { 08 00 82 8C B8 FF BD 27 40 00 BE AF 3C 00 B7 AF 44 00 BF AF 38 00 B6 AF 34 00 B5 AF 30 00 B4 AF 2C 00 B3 AF 28 00 B2 AF 24 00 B1 AF 20 00 B0 AF 21 B8 80 00 59 00 40 10 21 F0 00 01 0C 00 82 8C 10 00 83 8C 00 00 A4 8C 23 48 46 00 23 18 66 00 21 50 00 00 2D 18 64 00 2C 48 2A 01 23 98 69 00 88 00 60 5A 44 00 BF 8F 14 00 E2 8E 18 00 E3 8E 04 00 A4 8C 23 40 47 00 23 18 67 00 2C 40 0A 01 2D 18 64 00 23 18 68 00 7D 00 60 18 18 00 A3 AF 2C 00 E2 8E ?? ?? 04 3C ?? ?? 84 8C 00 C0 03 3C 21 38 07 01 24 10 43 00 21 30 26 01 14 00 A7 AF 47 00 40 10 10 00 A4 AF 18 00 A4 8F 28 00 80 18 10 00 02 25 80 10 02 00 21 A8 A2 00 80 48 09 00 80 30 06 00 FF 00 02 3C 0C 00 A9 AF 00 00 A6 AF FF 00 56 34 21 A0 00 00 14 00 A2 8F 20 00 E3 8E 21 20 E0 02 21 28 82 02 09 F8 60 00 00 00 B0 8E 12 00 60 1A 0C 00 A3 8F 00 00 A4 8F 21 88 03 02 21 90 44 00 21 80 00 00 00 00 22 8E 21 30 C0 03 01 00 10 26 21 28 40 00 06 00 56 10 04 00 31 26 ?? ?? 02 3C 10 00 A3 8F 09 F8 60 00 ?? ?? 44 8C 00 00 42 AE F4 FF 13 16 04 00 52 26 18 00 A4 8F 01 00 94 26 2A 10 84 02 E3 FF 40 14 04 00 B5 26 1C 00 E2 8E 21 20 E0 02 44 00 BF 8F 08 00 59 8C 40 00 BE 8F 3C 00 B7 8F 38 00 B6 8F 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 20 03 48 00 BD 27 04 00 A2 8C ?? ?? 04 3C ?? ?? 84 8C 18 00 A2 AF 2C 00 E2 8E 00 C0 03 3C 00 00 B3 8C 24 10 43 00 14 00 A7 AF 21 40 00 00 21 48 00 00 BB FF 40 14 10 00 A4 AF 18 00 A3 8F 2A 00 60 18 14 00 A4 8F 10 00 02 25 80 10 02 00 10 00 83 24 80 18 03 00 21 B0 A2 00 80 48 09 00 80 30 06 00 FF 00 02 3C 21 A8 E3 02 08 00 A9 AF 04 00 A6 AF FF 00 57 34 21 A0 00 00 00 00 C2 8E 14 00 60 1A 00 00 A3 8E 08 00 A4 8F 21 80 00 00 21 88 44 00 04 00 A2 8F 21 90 62 00 00 00 22 8E 21 30 C0 03 01 00 10 26 21 28 40 00 07 00 57 10 04 00 31 26 ?? ?? 03 3C ?? ?? 64 8C 10 00 A3 8F 09 F8 60 00 00 00 00 00 00 00 42 AE F3 FF 13 16 04 00 52 26 18 00 A4 8F 01 00 94 26 04 00 D6 26 2A 10 84 02 E5 FF 40 14 04 00 B5 26 44 00 BF 8F 40 00 BE 8F 3C 00 B7 8F 38 00 B6 8F 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_12_9_0 {
	meta:
		name = "_linear_draw_character32"
		size = 580
	strings:
		$1 = { 08 00 82 8C D0 FF BD 27 20 00 B6 AF 1C 00 B5 AF 18 00 B4 AF 2C 00 BF AF 28 00 BE AF 24 00 B7 AF 14 00 B3 AF 10 00 B2 AF 0C 00 B1 AF 08 00 B0 AF 21 B0 80 00 21 A8 00 01 46 00 40 10 21 A0 20 01 0C 00 82 8C 10 00 83 8C 00 00 A4 8C 23 B8 46 00 23 18 66 00 21 40 00 00 2D 18 64 00 2C B8 E8 02 23 80 77 00 6C 00 00 5A 2C 00 BF 8F 14 00 C2 8E 18 00 C3 8E 04 00 A4 8C 23 10 47 00 23 18 67 00 2C 10 48 00 2D 18 64 00 23 F0 62 00 61 00 C0 1B 21 38 47 00 21 30 E6 02 34 00 80 06 04 00 A7 AF 1D 00 C0 1B 80 30 06 00 10 00 42 24 80 10 02 00 21 98 A2 00 00 00 A6 AF 21 90 00 00 04 00 A2 8F 20 00 C3 8E 21 20 C0 02 21 28 42 02 09 F8 60 00 00 00 71 8E 0C 00 00 1A 00 00 A3 8F 21 30 37 02 21 20 00 00 21 28 43 00 00 00 C3 90 21 10 A0 02 01 00 84 24 0A 10 83 02 00 00 A2 AC 01 00 C6 24 F9 FF 90 14 04 00 A5 24 01 00 52 26 2A 10 5E 02 EA FF 40 14 04 00 73 26 1C 00 C2 8E 21 20 C0 02 2C 00 BF 8F 08 00 59 8C 28 00 BE 8F 24 00 B7 8F 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 20 03 30 00 BD 27 00 00 B0 8C 04 00 BE 8C 04 00 A7 AF 21 B8 00 00 CE FF 81 06 21 10 00 00 EA FF C0 1B 80 A0 06 00 10 00 42 24 80 10 02 00 21 98 A2 00 21 90 00 00 04 00 A2 8F 20 00 C3 8E 21 20 C0 02 21 28 42 02 09 F8 60 00 00 00 71 8E 0A 00 00 1A 21 20 37 02 21 28 54 00 21 18 00 00 00 00 82 90 01 00 63 24 02 00 40 10 01 00 84 24 00 00 B5 AC FA FF 70 14 04 00 A5 24 01 00 52 26 2A 10 5E 02 EC FF 40 14 04 00 73 26 1C 00 C2 8E 21 20 C0 02 2C 00 BF 8F 08 00 59 8C 28 00 BE 8F 24 00 B7 8F 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 20 03 30 00 BD 27 2C 00 BF 8F 28 00 BE 8F 24 00 B7 8F 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_12_10_0 {
	meta:
		name = "_linear_draw_rle_sprite32"
		size = 1104
		refs = "0118 .text"
	strings:
		$1 = { 08 00 82 8C D0 FF BD 27 18 00 B4 AF 2C 00 BF AF 28 00 BE AF 24 00 B7 AF 20 00 B6 AF 1C 00 B5 AF 14 00 B3 AF 10 00 B2 AF 0C 00 B1 AF 08 00 B0 AF 8C 00 40 10 21 A0 80 00 0C 00 82 8C 10 00 8C 8C 00 00 A9 8C 23 98 46 00 21 58 00 00 23 10 86 01 2C 98 6B 02 2D 10 49 00 23 B0 53 00 D1 00 C0 1A 21 50 66 02 14 00 82 8C 18 00 83 8C 04 00 A4 8C 23 40 47 00 23 18 67 00 2C 40 0B 01 2D 18 64 00 23 A8 68 00 C7 00 A0 1A 21 B8 07 01 10 00 00 11 10 00 B0 24 FF 00 02 3C FF 00 42 34 21 28 00 00 00 00 03 8E 07 00 62 10 04 00 10 26 FC FF 60 18 80 20 03 00 21 80 04 02 00 00 03 8E FB FF 62 14 04 00 10 26 01 00 A5 24 F6 FF A8 54 00 00 03 8E 6D 00 60 12 21 10 C9 00 80 50 0A 00 FF 00 02 3C 00 00 AA AF FF 00 51 34 21 90 00 00 FC FF 1E 24 20 00 83 8E 21 28 57 02 09 F8 60 00 21 20 80 02 21 28 40 00 00 00 06 8E 18 00 60 12 04 00 10 26 41 00 D1 10 21 20 60 02 ?? ?? ?? 0? 80 18 06 00 AC 00 42 04 80 10 04 00 21 80 03 02 00 00 06 8E 21 20 40 00 0D 00 40 10 04 00 10 26 37 00 D1 50 01 00 52 26 80 18 06 00 F5 FF C0 1C 23 10 86 00 21 30 C4 00 05 00 C0 04 21 10 C0 00 21 20 40 00 00 00 06 8E F5 FF 40 14 04 00 10 26 22 00 C0 1A 00 00 00 00 28 00 D1 10 00 00 A2 8F 21 18 C0 02 16 00 C0 18 21 40 A2 00 23 38 66 00 94 00 E0 04 21 28 00 01 21 20 00 02 21 18 00 00 00 00 82 8C 01 00 63 24 04 00 84 24 00 00 A2 AC FB FF 66 14 04 00 A5 24 80 10 03 00 21 80 02 02 00 00 06 8E 21 40 02 01 0C 00 E0 18 04 00 10 26 13 00 D1 50 01 00 52 26 EC FF C0 1C 21 18 E0 00 13 00 00 01 21 38 66 00 1C 00 DE 00 00 00 06 8E 04 00 10 26 F6 FF E0 1C 12 40 00 00 08 00 D1 50 01 00 52 26 02 00 C0 18 80 10 06 00 21 80 02 02 00 00 06 8E FB FF D1 14 04 00 10 26 01 00 52 26 2A 10 55 02 B4 FF 40 54 20 00 83 8E 1C 00 82 8E 21 20 80 02 2C 00 BF 8F 08 00 59 8C 28 00 BE 8F 24 00 B7 8F 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 20 03 30 00 BD 27 00 00 A9 8C 04 00 B5 8C 10 00 8C 8C 10 00 B0 24 21 B8 E0 00 21 B0 20 01 21 50 C0 00 21 98 00 00 21 10 C9 00 2A 10 4C 00 41 00 40 10 00 00 00 00 E4 FF A0 1A FF 00 02 3C 80 F0 0A 00 FF 00 52 34 21 88 00 00 FC FF 13 24 20 00 83 8E 21 20 80 02 09 F8 60 00 21 28 37 02 00 00 06 8E 21 00 C0 1A 04 00 10 26 1F 00 D2 10 21 40 5E 00 16 00 C0 18 21 18 C0 02 23 38 66 00 4C 00 E0 04 21 28 00 01 21 20 00 02 21 18 00 00 00 00 82 8C 01 00 63 24 04 00 84 24 00 00 A2 AC FB FF 66 14 04 00 A5 24 80 10 03 00 21 80 02 02 00 00 06 8E 21 40 02 01 0C 00 E0 18 04 00 10 26 0B 00 D2 50 01 00 31 26 EC FF C0 1C 21 18 E0 00 13 00 00 01 21 38 66 00 1C 00 D3 00 00 00 06 8E 04 00 10 26 F6 FF E0 1C 12 40 00 00 01 00 31 26 2A 10 35 02 D7 FF 40 54 20 00 83 8E 1C 00 82 8E 21 20 80 02 2C 00 BF 8F 08 00 59 8C 28 00 BE 8F 24 00 B7 8F 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 20 03 30 00 BD 27 51 FF A0 1E 80 50 0A 00 ?? ?? ?? 0? 1C 00 82 8E 2C 00 BF 8F 28 00 BE 8F 24 00 B7 8F 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 E0 03 30 00 BD 27 21 80 02 02 ?? ?? ?? 0? 23 30 C4 00 21 28 00 02 21 20 00 00 00 00 02 8E 01 00 84 24 04 00 10 26 00 00 02 AD FB FF 83 14 04 00 08 25 80 10 04 00 21 80 A2 00 ?? ?? ?? 0? 23 30 C4 00 21 28 00 02 21 20 00 00 00 00 02 8E 01 00 84 24 04 00 10 26 00 00 02 AD FB FF 83 14 04 00 08 25 80 10 04 00 01 00 31 26 21 80 A2 00 2A 10 35 02 9B FF 40 54 20 00 83 8E ?? ?? ?? 0? 1C 00 82 8E }
	condition:
		$1
}

rule file_12_11_0 {
	meta:
		name = "_linear_draw_trans_rle_sprite32"
		size = 1448
		refs = "00a4 _blender_func32 0164 .text 0200 _blender_alpha"
	strings:
		$1 = { 08 00 82 8C B0 FF BD 27 4C 00 BF AF 48 00 BE AF 44 00 B7 AF 40 00 B6 AF 3C 00 B5 AF 38 00 B4 AF 34 00 B3 AF 30 00 B2 AF 2C 00 B1 AF 28 00 B0 AF B8 00 40 10 24 00 A4 AF 0C 00 82 8C 10 00 8C 8C 00 00 AB 8C 23 10 46 00 10 00 A2 AF 10 00 A3 8F 21 50 00 00 23 10 86 01 2C 18 6A 00 2D 10 4B 00 23 10 43 00 10 00 A3 AF 1C 00 A2 AF 19 01 40 18 21 48 66 00 14 00 82 8C 18 00 83 8C 04 00 A4 8C 23 40 47 00 23 18 67 00 2C 40 0A 01 2D 18 64 00 23 18 68 00 21 38 07 01 18 00 A3 AF 0D 01 60 18 14 00 A7 AF ?? ?? 02 3C ?? ?? 42 8C 10 00 B5 24 10 00 00 11 0C 00 A2 AF FF 00 02 3C FF 00 42 34 21 28 00 00 00 00 A3 8E 07 00 62 10 04 00 B5 26 FC FF 60 18 80 20 03 00 21 A8 A4 02 00 00 A3 8E FB FF 62 14 04 00 B5 26 01 00 A5 24 F6 FF A8 54 00 00 A3 8E 10 00 A2 8F 94 00 40 10 21 10 CB 00 80 48 09 00 04 00 A9 AF 20 00 A0 AF 24 00 A2 8F 20 00 A4 8F 24 00 43 8C 14 00 A2 8F 21 80 82 00 24 00 A4 8F 09 F8 60 00 21 28 00 02 24 00 A4 8F 21 28 00 02 20 00 83 8C 09 F8 60 00 21 88 40 00 21 28 40 00 10 00 A2 8F 00 00 B4 8E 1C 00 40 10 04 00 B5 26 FF 00 03 3C FF 00 63 34 57 00 83 12 21 20 40 00 ?? ?? ?? 0? 80 18 14 00 E5 00 42 04 80 10 04 00 21 A8 A3 02 00 00 B4 8E 21 20 40 00 0F 00 40 10 04 00 B5 26 FF 00 02 3C FF 00 42 34 4B 00 82 12 20 00 A3 8F 80 18 14 00 F3 FF 80 1E 23 10 94 00 21 A0 84 02 05 00 80 06 21 10 80 02 21 20 40 00 00 00 B4 8E F3 FF 40 14 04 00 B5 26 1C 00 A3 8F 31 00 60 18 FF 00 04 3C FF 00 84 34 3A 00 84 12 04 00 A2 8F 21 80 60 00 21 F0 22 02 21 00 80 1A 21 B8 A2 00 23 B0 14 02 C8 00 C0 06 FF FF 93 26 21 90 A0 02 21 88 C0 03 21 80 E0 02 ?? ?? 02 3C 00 00 44 8E 00 00 25 8E ?? ?? 46 8C 0C 00 A3 8F FF FF 73 26 09 F8 60 00 04 00 52 26 FF FF 04 24 00 00 02 AE 04 00 31 26 F4 FF 64 16 04 00 10 26 80 10 14 00 21 A8 A2 02 00 00 B4 8E 21 B8 E2 02 21 F0 C2 03 10 00 C0 1A 04 00 B5 26 FF 00 03 3C FF 00 63 34 19 00 83 12 20 00 A3 8F E1 FF 80 1E 21 80 C0 02 FC FF 03 24 18 00 83 02 21 B0 90 02 00 00 B4 8E 04 00 B5 26 12 10 00 00 21 B8 E2 02 F2 FF C0 1E 21 F0 C2 03 FF 00 04 3C FF 00 84 34 0A 00 84 12 20 00 A3 8F 02 00 80 1A 80 10 14 00 21 A8 A2 02 00 00 B4 8E FF 00 02 3C FF 00 42 34 F9 FF 82 16 04 00 B5 26 20 00 A3 8F 18 00 A4 8F 01 00 63 24 2A 10 64 00 8F FF 40 14 20 00 A3 AF 24 00 A3 8F 4C 00 BF 8F 48 00 BE 8F 1C 00 62 8C 44 00 B7 8F 40 00 B6 8F 08 00 59 8C 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 21 20 60 00 08 00 20 03 50 00 BD 27 24 00 A4 8F ?? ?? 02 3C 00 00 AB 8C ?? ?? 42 8C 10 00 B5 24 04 00 A5 8C 10 00 8C 8C 0C 00 A2 AF 14 00 A7 AF 1C 00 AB AF 18 00 A5 AF 21 48 C0 00 10 00 A0 AF 21 10 CB 00 2A 10 4C 00 5C 00 40 10 18 00 A3 8F 18 00 A4 8F DD FF 80 18 80 48 09 00 08 00 A9 AF 00 00 A0 AF 24 00 A2 8F 00 00 A4 8F 24 00 43 8C 14 00 A2 8F 21 80 82 00 24 00 A4 8F 09 F8 60 00 21 28 00 02 24 00 A4 8F 21 28 00 02 20 00 83 8C 09 F8 60 00 21 88 40 00 1C 00 A3 8F 00 00 B4 8E 32 00 60 18 04 00 B5 26 FF 00 04 3C FF 00 84 34 3A 00 84 12 08 00 A3 8F 1C 00 B0 8F 21 F0 23 02 21 00 80 1A 21 B8 43 00 23 B0 14 02 61 00 C0 06 FF FF 93 26 21 90 A0 02 21 88 C0 03 21 80 E0 02 ?? ?? 02 3C 00 00 44 8E 00 00 25 8E ?? ?? 46 8C 0C 00 A3 8F FF FF 73 26 09 F8 60 00 04 00 52 26 FF FF 04 24 00 00 02 AE 04 00 31 26 F4 FF 64 16 04 00 10 26 80 10 14 00 21 A8 A2 02 00 00 B4 8E 21 B8 E2 02 21 F0 C2 03 10 00 C0 1A 04 00 B5 26 FF 00 04 3C FF 00 84 34 19 00 84 12 00 00 A3 8F E1 FF 80 1E 21 80 C0 02 FC FF 03 24 18 00 83 02 21 B0 14 02 00 00 B4 8E 04 00 B5 26 12 10 00 00 21 B8 E2 02 F2 FF C0 1E 21 F0 C2 03 FF 00 04 3C FF 00 84 34 0A 00 84 12 00 00 A3 8F 02 00 80 1A 80 10 14 00 21 A8 A2 02 00 00 B4 8E FF 00 02 3C FF 00 42 34 F9 FF 82 16 04 00 B5 26 00 00 A3 8F 18 00 A4 8F 01 00 63 24 2A 10 64 00 AD FF 40 14 00 00 A3 AF ?? ?? ?? 0? 24 00 A3 8F 0F FF 60 1C 80 48 09 00 ?? ?? ?? 0? 24 00 A3 8F 4C 00 BF 8F 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 50 00 BD 27 21 A8 A2 02 ?? ?? ?? 0? 23 A0 84 02 21 90 A0 02 FF FF 11 26 ?? ?? 02 3C 00 00 A4 8E 00 00 C5 8F ?? ?? 46 8C 0C 00 A3 8F FF FF 31 26 09 F8 60 00 04 00 B5 26 FF FF 04 24 00 00 E2 AE 04 00 DE 27 F4 FF 24 16 04 00 F7 26 80 10 10 00 21 A8 42 02 ?? ?? ?? 0? 23 A0 90 02 21 90 A0 02 FF FF 11 26 ?? ?? 02 3C 00 00 A4 8E 00 00 C5 8F ?? ?? 46 8C 0C 00 A3 8F FF FF 31 26 09 F8 60 00 04 00 B5 26 FF FF 04 24 00 00 E2 AE 04 00 DE 27 F4 FF 24 16 04 00 F7 26 80 10 10 00 21 A8 42 02 ?? ?? ?? 0? 23 A0 90 02 }
	condition:
		$1
}

rule file_12_12_0 {
	meta:
		name = "_linear_draw_lit_rle_sprite32"
		size = 1304
		refs = "00a8 _blender_func32 014c .text 01e0 _blender_col_32"
	strings:
		$1 = { 08 00 82 8C B0 FF BD 27 48 00 BE AF 4C 00 BF AF 44 00 B7 AF 40 00 B6 AF 3C 00 B5 AF 38 00 B4 AF 34 00 B3 AF 30 00 B2 AF 2C 00 B1 AF 28 00 B0 AF 20 00 A4 AF AB 00 40 10 21 F0 00 01 0C 00 82 8C 10 00 8B 8C 00 00 AC 8C 23 10 46 00 0C 00 A2 AF 0C 00 A3 8F 21 50 00 00 23 10 66 01 2C 18 6A 00 2D 10 4C 00 23 10 43 00 0C 00 A3 AF 18 00 A2 AF F2 00 40 18 21 48 66 00 14 00 82 8C 18 00 83 8C 04 00 A4 8C 23 40 47 00 23 18 67 00 2C 40 0A 01 2D 18 64 00 23 18 68 00 21 38 07 01 14 00 A3 AF E6 00 60 18 10 00 A7 AF ?? ?? 02 3C ?? ?? 57 8C 10 00 00 11 10 00 B4 24 FF 00 02 3C FF 00 42 34 21 28 00 00 00 00 83 8E 07 00 62 10 04 00 94 26 FC FF 60 18 80 20 03 00 21 A0 84 02 00 00 83 8E FB FF 62 14 04 00 94 26 01 00 A5 24 F6 FF A8 54 00 00 83 8E 0C 00 A2 8F 87 00 40 10 21 10 CC 00 80 48 09 00 00 00 A9 AF 1C 00 A0 AF 20 00 A6 8F 1C 00 A2 8F 20 00 C3 8C 21 20 C0 00 10 00 A6 8F 09 F8 60 00 21 28 46 00 21 28 40 00 0C 00 A2 8F 00 00 93 8E 1C 00 40 10 04 00 94 26 FF 00 03 3C FF 00 63 34 51 00 63 12 21 20 40 00 ?? ?? ?? 0? 80 18 13 00 C5 00 42 04 80 10 04 00 21 A0 83 02 00 00 93 8E 21 20 40 00 0F 00 40 10 04 00 94 26 FF 00 06 3C FF 00 C6 34 45 00 66 12 1C 00 A6 8F 80 18 13 00 F3 FF 60 1E 23 10 93 00 21 98 64 02 05 00 60 06 21 10 60 02 21 20 40 00 00 00 93 8E F3 FF 40 14 04 00 94 26 18 00 A2 8F 2B 00 40 18 FF 00 03 3C FF 00 63 34 34 00 63 12 00 00 A4 8F 21 80 40 00 1D 00 60 1A 21 B0 A4 00 23 A8 13 02 A9 00 A0 06 FF FF 72 26 21 88 80 02 21 80 C0 02 ?? ?? 02 3C 00 00 25 8E ?? ?? 44 8C 21 30 C0 03 09 F8 E0 02 FF FF 52 26 FF FF 03 24 00 00 02 AE 04 00 31 26 F6 FF 43 16 04 00 10 26 80 10 13 00 21 A0 82 02 00 00 93 8E 21 B0 C2 02 0F 00 A0 1A 04 00 94 26 FF 00 06 3C FF 00 C6 34 18 00 66 52 1C 00 A6 8F E5 FF 60 1E 21 80 A0 02 13 00 C0 02 FC FF 02 24 21 A8 70 02 1C 00 62 02 00 00 93 8E 04 00 94 26 F3 FF A0 1E 12 B0 00 00 FF 00 03 3C FF 00 63 34 0A 00 63 12 1C 00 A6 8F 02 00 60 1A 80 10 13 00 21 A0 82 02 00 00 93 8E FF 00 04 3C FF 00 84 34 F9 FF 64 16 04 00 94 26 1C 00 A6 8F 14 00 A3 8F 01 00 C6 24 2A 10 C3 00 9B FF 40 14 1C 00 A6 AF 20 00 A6 8F 4C 00 BF 8F 48 00 BE 8F 1C 00 C2 8C 44 00 B7 8F 40 00 B6 8F 08 00 59 8C 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 21 20 C0 00 08 00 20 03 50 00 BD 27 20 00 A4 8F 00 00 AC 8C ?? ?? 02 3C 10 00 B4 24 04 00 A5 8C ?? ?? 57 8C 10 00 8B 8C 10 00 A7 AF 18 00 AC AF 14 00 A5 AF 21 48 C0 00 0C 00 A0 AF 21 10 CC 00 2A 10 4B 00 43 00 40 10 14 00 A3 8F 14 00 A4 8F DE FF 80 18 80 48 09 00 08 00 A9 AF 04 00 A0 AF 20 00 A4 8F 04 00 A6 8F 10 00 A2 8F 20 00 83 8C 09 F8 60 00 21 28 C2 00 18 00 A3 8F 00 00 93 8E 2C 00 60 18 04 00 94 26 FF 00 04 3C FF 00 84 34 28 00 64 12 08 00 A6 8F 21 80 60 00 1D 00 60 1A 21 B0 46 00 23 A8 13 02 4E 00 A0 06 FF FF 72 26 21 88 80 02 21 80 C0 02 ?? ?? 03 3C 00 00 25 8E ?? ?? 64 8C 21 30 C0 03 09 F8 E0 02 FF FF 52 26 FF FF 04 24 00 00 02 AE 04 00 31 26 F6 FF 44 16 04 00 10 26 80 10 13 00 21 A0 82 02 00 00 93 8E 21 B0 C2 02 0F 00 A0 1A 04 00 94 26 FF 00 02 3C FF 00 42 34 0C 00 62 12 04 00 A3 8F E5 FF 60 1E 21 80 A0 02 13 00 C0 02 FC FF 02 24 21 A8 13 02 1C 00 62 02 00 00 93 8E 04 00 94 26 F3 FF A0 1E 12 B0 00 00 04 00 A3 8F 14 00 A4 8F 01 00 63 24 2A 10 64 00 C6 FF 40 14 04 00 A3 AF ?? ?? ?? 0? 20 00 A6 8F 35 FF 60 1C 80 48 09 00 ?? ?? ?? 0? 20 00 A6 8F 4C 00 BF 8F 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 50 00 BD 27 21 A0 82 02 ?? ?? ?? 0? 23 98 64 02 21 90 80 02 FF FF 11 26 ?? ?? 06 3C 00 00 85 8E ?? ?? C4 8C 21 30 C0 03 09 F8 E0 02 FF FF 31 26 00 00 C2 AE FF FF 02 24 04 00 94 26 F6 FF 22 16 04 00 D6 26 80 10 10 00 21 A0 42 02 ?? ?? ?? 0? 23 98 70 02 21 90 80 02 FF FF 11 26 ?? ?? 06 3C 00 00 85 8E ?? ?? C4 8C 21 30 C0 03 09 F8 E0 02 FF FF 31 26 00 00 C2 AE FF FF 02 24 04 00 94 26 F6 FF 22 16 04 00 D6 26 04 00 A3 8F 14 00 A4 8F 80 10 10 00 01 00 63 24 21 A0 42 02 2A 10 64 00 8B FF 40 14 04 00 A3 AF ?? ?? ?? 0? 20 00 A6 8F }
	condition:
		$1
}

rule file_13_0_0 {
	meta:
		name = "fs_flist_getter"
		size = 72
		refs = "0004 .bss 002c .text"
	strings:
		$1 = { 08 00 80 04 ?? ?? 02 3C ?? ?? 43 8C 80 20 04 00 08 04 62 8C 21 10 44 00 00 00 44 8C 08 00 E0 03 21 10 80 00 03 00 A0 54 ?? ?? 02 3C ?? ?? ?? 0? 21 20 00 00 ?? ?? 43 8C 21 20 00 00 00 04 62 8C ?? ?? ?? 0? 00 00 A2 AC }
	condition:
		$1
}

rule file_13_1_0 {
	meta:
		name = "fs_flist_proc"
		size = 1452
		refs = "0000 .data 0050 uwidth_max 0074 .bss 008c _gui_text_list_proc 0160 _al_free 01a4 $LC0 01c0 uconvert 01d4 replace_filename 01f4 .rodata 025c .text 0268 for_each_file_ex 0278 get_filename 027c usetc 0364 $LC1 0394 ustrncmp 03cc object_message 0420 _al_sane_realloc 0434 allegro_errno 04e4 ustrlen 050c ugetat 0530 uinsert 056c _al_malloc"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 24 B0 FF BD 27 04 01 43 8C 3C 00 B5 AF 21 A8 80 00 75 63 04 3C 2E 72 84 34 48 00 BE AF 44 00 B7 AF 40 00 B6 AF 38 00 B4 AF 34 00 B3 AF 21 A0 A0 00 4C 00 BF AF 30 00 B2 AF 2C 00 B1 AF 28 00 B0 AF 21 B0 C0 00 20 00 A3 AF ?? ?? ?? 0? 0C 01 57 8C 21 F0 40 00 01 00 02 24 30 00 A2 12 24 00 93 8E 02 00 02 24 8D 00 A2 12 ?? ?? 12 3C ?? ?? 10 3C ?? ?? 02 8E 21 20 A0 02 21 30 C0 02 01 00 42 24 21 28 80 02 ?? ?? ?? 0? ?? ?? 02 AE 21 88 40 00 ?? ?? 02 8E 24 00 83 8E FF FF 44 24 10 00 73 10 ?? ?? 04 AE 9D 00 80 10 20 00 A2 8F 4C 00 BF 8F 21 10 20 02 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 50 00 BD 27 01 00 02 24 EF FF 22 12 4C 00 BF 8F 21 10 20 02 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 50 00 BD 27 ?? ?? 12 3C ?? ?? 50 8E 0F 01 00 12 00 00 00 00 00 04 02 8E 15 00 40 58 04 04 02 8E 21 88 00 00 08 04 02 8E 80 80 11 00 01 00 31 26 21 10 50 00 00 00 43 8C 07 00 60 10 21 20 60 00 ?? ?? ?? 0? 00 00 00 00 ?? ?? 43 8E 08 04 62 8C 21 10 50 00 00 00 40 AC ?? ?? 50 8E 00 04 02 8E 2A 10 22 02 F0 FF 40 54 08 04 02 8E 04 04 02 8E 01 08 42 28 A0 00 40 50 08 04 04 8E ?? ?? 50 8E 75 63 07 3C ?? ?? 04 3C 53 41 05 3C 20 00 08 24 2E 72 E7 34 ?? ?? 84 24 38 43 A5 34 21 30 A0 03 ?? ?? ?? 0? 00 04 00 AE 21 30 40 00 21 20 00 02 21 28 E0 02 ?? ?? ?? 0? 00 04 07 24 ?? ?? 03 3C ?? ?? 68 24 0C 00 02 8D B0 00 40 10 ?? ?? 04 3C ?? ?? 84 8C ?? ?? 02 3C ?? ?? 4A 24 21 28 00 00 21 30 00 00 02 00 09 24 14 00 07 24 21 10 06 01 00 00 43 8C 40 00 69 10 21 10 46 01 04 00 C6 24 FB FF C7 14 21 10 06 01 ?? ?? 02 3C ?? ?? 4B 24 21 30 00 00 21 38 00 00 01 00 0A 24 14 00 09 24 21 10 07 01 00 00 43 8C 30 00 6A 10 21 10 67 01 04 00 E7 24 FB FF E9 14 21 10 07 01 ?? ?? 07 3C 08 00 C6 34 ?? ?? E7 24 ?? ?? ?? 0? 21 40 00 00 ?? ?? 44 8E ?? ?? 02 3C ?? ?? ?? 0? ?? ?? 50 8C 21 20 40 00 09 F8 00 02 21 28 00 00 02 00 02 24 28 00 80 AE 24 00 80 AE 76 FF A2 16 21 98 00 00 ?? ?? 12 3C ?? ?? 43 8E 73 FF 60 10 ?? ?? 10 3C 00 04 62 8C 0F 00 40 18 21 80 00 00 08 04 62 8C 80 20 10 00 01 00 10 26 21 10 44 00 00 00 43 8C 03 00 60 10 21 20 60 00 ?? ?? ?? 0? 00 00 00 00 ?? ?? 43 8E 00 04 62 8C 2A 10 02 02 F4 FF 40 54 08 04 62 8C ?? ?? ?? 0? 08 04 64 8C ?? ?? ?? 0? ?? ?? 44 8E ?? ?? ?? 0? ?? ?? 40 AE 00 00 43 8C ?? ?? ?? 0? 25 30 C3 00 00 00 43 8C ?? ?? ?? 0? 25 28 A3 00 ?? ?? 12 3C ?? ?? 45 8E 01 00 47 24 18 00 C7 03 80 18 03 00 08 04 A2 8C 21 20 E0 02 21 10 43 00 00 00 46 8C ?? ?? ?? 0? 12 38 00 00 ?? ?? 44 8E 24 00 82 8E 53 41 05 3C 08 04 83 8C 80 10 02 00 ?? ?? 04 3C 21 18 62 00 00 00 70 8C 75 63 07 3C ?? ?? 84 24 38 43 A5 34 21 30 A0 03 2E 72 E7 34 ?? ?? ?? 0? 20 00 08 24 21 28 40 00 21 20 00 02 ?? ?? ?? 0? 02 00 06 24 2B 00 40 14 01 00 02 24 4A 00 22 12 ?? ?? 02 3C ?? ?? 43 8C ?? ?? 04 3C ?? ?? 10 3C ?? ?? 84 24 09 F8 60 00 21 28 00 00 ?? ?? 04 26 01 00 05 24 ?? ?? ?? 0? 21 30 00 00 ?? ?? 04 26 03 00 05 24 ?? ?? ?? 0? 21 30 00 00 4C 00 BF 8F 21 10 20 02 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 50 00 BD 27 00 08 02 24 04 04 02 AE ?? ?? ?? 0? 00 20 05 24 ?? ?? 43 8E 5B FF 60 14 08 04 02 AE ?? ?? 02 3C ?? ?? 43 8C 0C 00 02 24 01 00 11 24 ?? ?? ?? 0? 00 00 62 AC ?? ?? 02 3C ?? ?? 43 8C ?? ?? 04 3C ?? ?? 84 24 21 28 00 00 09 F8 60 00 ?? ?? 10 3C ?? ?? 04 26 01 00 05 24 ?? ?? ?? 0? 21 30 00 00 ?? ?? 04 26 03 00 05 24 ?? ?? ?? 0? 21 30 00 00 01 00 03 24 0A FF 23 16 4C 00 BF 8F ?? ?? 04 26 06 00 05 24 ?? ?? ?? 0? 21 30 00 00 ?? ?? ?? 0? 21 88 40 00 ?? ?? 84 8C ?? ?? 07 3C ?? ?? E7 24 21 28 00 00 08 00 06 24 ?? ?? ?? 0? 01 00 08 24 ?? ?? ?? 0? ?? ?? 44 8E ?? ?? 43 8C ?? ?? 11 3C ?? ?? 24 26 09 F8 60 00 21 28 00 00 ?? ?? ?? 0? ?? ?? 44 8E 14 00 40 18 21 80 40 00 ?? ?? 34 26 2F 00 13 24 21 88 00 00 01 00 15 24 ?? ?? 44 8E 21 28 00 02 ?? ?? ?? 0? FF FF 10 26 21 30 40 00 21 20 80 02 04 00 53 14 21 28 00 00 07 00 35 52 ?? ?? 10 3C 01 00 11 24 ?? ?? ?? 0? 00 00 00 00 F3 FF 00 5E ?? ?? 44 8E ?? ?? 10 3C ?? ?? 04 26 01 00 05 24 ?? ?? ?? 0? 21 30 00 00 ?? ?? 04 26 03 00 05 24 ?? ?? ?? 0? 21 30 00 00 ?? ?? ?? 0? ?? ?? 04 26 ?? ?? ?? 0? 0C 04 04 24 21 80 40 00 AE FF 40 10 ?? ?? 42 AE 80 00 02 24 04 04 02 AE ?? ?? ?? 0? 00 02 04 24 ?? ?? 43 8E 08 04 02 AE 08 04 62 8C 00 FF 40 14 ?? ?? 50 8E ?? ?? ?? 0? ?? ?? 02 3C }
	condition:
		$1
}

rule file_13_2_0 {
	meta:
		name = "fs_flist_putter"
		size = 924
		refs = "0030 get_filename 003c fix_filename_case 004c .bss 005c get_extension 0078 .text 00a0 ustricmp 00b4 .data 00bc .rodata 00f0 ugetc 010c ugetat 011c ustrsizez 0134 _al_malloc 014c ustrzcpy 02ec ucwidth 0344 put_backslash 035c _al_sane_realloc 037c allegro_errno"
	strings:
		$1 = { D8 FF BD 27 20 00 B7 AF 1C 00 B6 AF 18 00 B5 AF 14 00 B4 AF 24 00 BF AF 10 00 B4 30 10 00 B3 AF 0C 00 B2 AF 08 00 B1 AF 04 00 B0 AF 21 B0 A0 00 ?? ?? ?? 0? 21 B8 C0 00 21 20 40 00 ?? ?? ?? 0? 21 A8 40 00 2B 00 80 16 ?? ?? 02 3C ?? ?? 13 3C ?? ?? 62 8E 16 00 40 10 00 00 00 00 ?? ?? ?? 0? 21 20 A0 02 ?? ?? 12 3C 21 88 40 00 ?? ?? 42 8E 8B 00 40 18 21 80 00 00 ?? ?? ?? 0? ?? ?? 62 8E 2A 10 02 02 87 00 40 10 21 20 00 00 ?? ?? 62 8E 80 18 10 00 21 20 20 02 21 10 43 00 00 00 45 8C ?? ?? ?? 0? 01 00 10 26 F5 FF 40 14 ?? ?? 42 8E 0F 00 E0 12 ?? ?? 02 3C ?? ?? 44 24 ?? ?? 03 3C ?? ?? 02 3C ?? ?? 63 24 ?? ?? 46 24 02 00 05 24 01 00 07 24 00 00 82 8C 7E 00 45 10 04 00 84 24 6C 00 47 50 00 00 62 8C FA FF 86 14 04 00 63 24 ?? ?? 02 3C ?? ?? 45 8C 09 F8 A0 00 21 20 A0 02 2E 00 03 24 05 00 43 14 21 20 A0 02 ?? ?? ?? 0? 01 00 05 24 63 00 40 10 21 20 00 00 ?? ?? ?? 0? 21 20 A0 02 71 00 80 16 21 80 40 00 21 10 00 00 21 80 50 00 ?? ?? ?? 0? 21 20 00 02 74 00 40 10 21 98 40 00 21 28 00 02 21 30 A0 02 ?? ?? ?? 0? 21 20 40 00 7B 00 80 16 00 00 00 00 ?? ?? 12 3C ?? ?? 43 8E 00 04 62 8C 21 00 40 18 21 88 00 00 ?? ?? ?? 0? 2F 00 15 24 1E 00 80 56 ?? ?? 50 8E ?? ?? 43 8E 08 04 62 8C 21 10 50 00 ?? ?? ?? 0? 00 00 45 8C 17 00 40 04 ?? ?? 50 8E ?? ?? 43 8E 01 00 31 26 00 04 62 8C 2A 10 22 02 12 00 40 50 00 04 05 8E 08 04 62 8C 80 80 11 00 FF FF 05 24 21 10 50 00 ?? ?? ?? 0? 00 00 44 8C EA FF 55 14 21 20 60 02 EA FF 80 16 ?? ?? 43 8E 01 00 31 26 00 04 62 8C 2A 10 22 02 F3 FF 40 54 08 04 62 8C ?? ?? 50 8E 00 04 05 8E 04 04 02 8E 55 00 A2 50 08 04 04 8E ?? ?? 49 8E 00 04 27 8D 2A 10 27 02 60 00 40 10 FF FF E2 24 08 04 28 8D 80 10 02 00 80 18 07 00 21 30 02 01 21 28 03 01 21 20 E0 00 00 00 C2 8C FF FF 84 24 2A 18 24 02 00 00 A2 AC FC FF C6 24 FA FF 60 14 FC FF A5 24 24 00 BF 8F 80 10 11 00 21 10 02 01 01 00 E3 24 21 20 00 00 00 00 53 AC 20 00 B7 8F 21 10 80 00 1C 00 B6 8F 18 00 B5 8F 14 00 B4 8F 10 00 B3 8F 0C 00 B2 8F 08 00 B1 8F 04 00 B0 8F 00 04 23 AD 08 00 E0 03 28 00 BD 27 24 10 C2 02 93 FF 40 10 00 00 00 00 21 20 00 00 24 00 BF 8F 21 10 80 00 20 00 B7 8F 1C 00 B6 8F 18 00 B5 8F 14 00 B4 8F 10 00 B3 8F 0C 00 B2 8F 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 28 00 BD 27 00 00 62 8C 24 10 C2 02 82 FF 40 14 00 00 00 00 ?? ?? ?? 0? 21 20 00 00 ?? ?? 02 3C ?? ?? 43 8C 09 F8 60 00 2F 00 04 24 21 80 50 00 ?? ?? ?? 0? 21 20 00 02 8E FF 40 14 21 98 40 00 24 00 BF 8F FF FF 04 24 21 10 80 00 20 00 B7 8F 1C 00 B6 8F 18 00 B5 8F 14 00 B4 8F 10 00 B3 8F 0C 00 B2 8F 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 28 00 BD 27 ?? ?? ?? 0? 21 20 60 02 ?? ?? ?? 0? ?? ?? 12 3C 40 10 05 00 04 04 02 AE ?? ?? ?? 0? C0 28 05 00 ?? ?? 03 3C ?? ?? 64 8C 08 04 02 AE 08 04 82 8C A4 FF 40 14 ?? ?? 49 8E ?? ?? 02 3C ?? ?? 43 8C 0C 00 02 24 FF FF 04 24 ?? ?? ?? 0? 00 00 62 AC ?? ?? ?? 0? 08 04 28 8D }
	condition:
		$1
}

rule file_13_3_0 {
	meta:
		name = "ustrfilecmp"
		size = 404
		refs = "0034 ugetxc 0054 utolower 0094 ucwidth 00f0 ustrtol 014c .text"
	strings:
		$1 = { C8 FF BD 27 30 00 BE AF 2C 00 B7 AF 28 00 B6 AF 24 00 B5 AF 1C 00 B3 AF 34 00 BF AF 20 00 B4 AF 18 00 B2 AF 14 00 B1 AF 10 00 B0 AF 08 00 A4 AF 0C 00 A5 AF ?? ?? 13 3C 08 00 B6 27 0C 00 B5 27 ?? ?? 17 3C 04 00 BE 27 ?? ?? 63 8E 09 F8 60 00 21 20 C0 02 ?? ?? ?? 0? 21 20 40 00 ?? ?? 63 8E 21 20 A0 02 09 F8 60 00 21 90 40 00 ?? ?? ?? 0? 21 20 40 00 21 88 40 00 D0 FF 42 26 0A 00 42 2C 05 00 40 10 30 00 23 2A 03 00 60 14 3A 00 22 2A 12 00 40 14 ?? ?? E3 8E 2E 00 51 16 00 00 00 00 EA FF 40 16 ?? ?? 63 8E 21 10 00 00 34 00 BF 8F 30 00 BE 8F 2C 00 B7 8F 28 00 B6 8F 24 00 B5 8F 20 00 B4 8F 1C 00 B3 8F 18 00 B2 8F 14 00 B1 8F 10 00 B0 8F 08 00 E0 03 38 00 BD 27 08 00 B0 8F 09 F8 60 00 21 20 40 02 23 20 02 02 21 28 A0 03 ?? ?? ?? 0? 0A 00 06 24 ?? ?? E3 8E 0C 00 B0 8F 21 20 20 02 09 F8 60 00 21 A0 40 00 23 20 02 02 21 28 C0 03 ?? ?? ?? 0? 0A 00 06 24 19 00 82 16 08 00 A6 8F 00 00 A4 8F 04 00 A5 8F 0C 00 A2 8F 23 18 86 00 23 10 A2 00 14 00 62 14 21 10 46 00 08 00 A4 AF C0 FF 40 16 0C 00 A5 AF ?? ?? ?? 0? 21 10 00 00 D5 FF 40 12 FF FF 02 24 03 00 20 56 2E 00 02 24 ?? ?? ?? 0? 01 00 02 24 CF FF 42 52 FF FF 02 24 CD FF 22 52 01 00 02 24 ?? ?? ?? 0? 23 10 51 02 ?? ?? ?? 0? 23 10 82 02 ?? ?? ?? 0? 23 10 44 00 }
	condition:
		$1
}

rule file_13_4_0 {
	meta:
		name = "fs_edit_proc"
		size = 728
		refs = "0220 .data 0038 uwidth_max 0094 _gui_edit_proc 00c8 canonicalize_filename 00d8 ustrzcpy 00e0 .text 00e8 ugetc 0104 ugetat 0128 ucwidth 0168 file_exists 0110 $LC2 01a8 uconvert 01b8 ustrzcat 01c8 put_backslash 01e0 object_message 01e8 ustrlen 01ec .bss 0234 ustrcmp 024c font 025c text_height"
	strings:
		$1 = { C8 FB BD 27 20 04 B0 AF 24 00 B0 8C 24 04 B1 AF 21 88 80 00 75 63 04 3C 2E 72 84 34 30 04 B4 AF 2C 04 B3 AF 28 04 B2 AF 34 04 BF AF 21 A0 A0 00 01 00 10 26 21 90 C0 00 ?? ?? ?? 0? 2C 00 B3 8C 18 00 50 00 01 00 02 24 12 18 00 00 1B 00 22 12 18 04 A3 AF 06 00 02 24 23 00 22 12 08 00 02 24 0A 00 22 16 9F FF 42 26 1A 00 42 2C 08 00 40 14 21 20 20 02 2F 00 02 24 05 00 42 12 E0 FF 42 26 60 00 42 2C 06 00 40 10 34 04 BF 8F 21 20 20 02 21 28 80 02 ?? ?? ?? 0? 21 30 40 02 34 04 BF 8F 30 04 B4 8F 2C 04 B3 8F 28 04 B2 8F 24 04 B1 8F 20 04 B0 8F 08 00 E0 03 38 04 BD 27 14 00 B0 27 21 20 00 02 21 28 60 02 ?? ?? ?? 0? 00 04 06 24 18 04 A5 8F 21 20 60 02 ?? ?? ?? 0? 21 30 00 02 ?? ?? ?? 0? 21 20 20 02 ?? ?? 02 3C ?? ?? 43 8C 09 F8 60 00 21 20 60 02 25 00 40 10 ?? ?? 04 3C 21 20 60 02 ?? ?? ?? 0? FF FF 05 24 20 00 40 10 ?? ?? 04 3C 14 00 B0 27 00 04 06 24 21 28 60 02 ?? ?? ?? 0? 21 20 00 02 ?? ?? 03 3C ?? ?? 65 8C 09 F8 A0 00 2F 00 04 24 18 04 A3 8F 21 20 60 02 21 30 00 02 ?? ?? ?? 0? 23 28 62 00 21 20 60 02 ?? ?? ?? 0? FF FF 05 24 2F 00 03 24 1C 00 43 10 13 00 05 24 21 20 60 02 ?? ?? ?? 0? 21 30 A0 03 CA FF 40 10 01 00 02 24 00 00 A2 8F 10 00 42 30 11 00 40 14 01 00 02 24 ?? ?? ?? 0? 34 04 BF 8F 53 41 05 3C 75 63 07 3C 04 00 A6 27 ?? ?? 84 24 38 43 A5 34 2E 72 E7 34 ?? ?? ?? 0? 10 00 08 24 18 04 A5 8F 21 20 60 02 ?? ?? ?? 0? 21 30 40 00 ?? ?? ?? 0? 14 00 B0 27 ?? ?? ?? 0? 21 20 60 02 ?? ?? 13 3C ?? ?? 64 26 01 00 05 24 21 30 00 00 ?? ?? ?? 0? ?? ?? 10 3C ?? ?? ?? 0? ?? ?? 04 26 26 00 40 10 ?? ?? 12 3C ?? ?? 43 8E 00 04 62 8C 30 00 40 18 ?? ?? 10 26 ?? ?? ?? 0? 21 88 00 00 01 00 31 26 00 04 62 8C 2A 10 22 02 2A 00 40 10 ?? ?? 02 3C 08 04 62 8C 80 18 11 00 21 20 00 02 21 10 43 00 ?? ?? ?? 0? 00 00 45 8C F4 FF 40 14 ?? ?? 43 8E ?? ?? 02 3C ?? ?? 52 24 ?? ?? 03 3C 28 01 50 8E ?? ?? 64 8C 3C 01 51 AE ?? ?? ?? 0? FC FF 10 26 02 00 40 14 1A 00 02 02 CD 01 00 00 12 80 00 00 FF FF 10 26 2A 10 11 02 03 00 40 50 40 01 40 AE 23 10 30 02 40 01 42 AE ?? ?? 64 26 03 00 05 24 ?? ?? ?? 0? 21 30 00 00 21 20 80 02 01 00 05 24 ?? ?? ?? 0? 21 30 00 00 21 20 80 02 03 00 05 24 ?? ?? ?? 0? 21 30 00 00 ?? ?? ?? 0? 21 10 00 00 ?? ?? 02 3C ?? ?? 42 24 40 01 40 AC ?? ?? ?? 0? 3C 01 40 AC }
	condition:
		$1
}

rule file_13_5_0 {
	meta:
		name = "file_select_ex"
		size = 2612
		refs = "0044 _al_ustrdup 0054 usetc 005c .bss 0084 .data 0094 uwidth_max 00a4 $LC3 00c4 get_config_text 00cc $LC4 0120 ugetc 0160 clear_keybuf 0164 gui_mouse_b 017c font 0188 $LC5 01a0 uconvert 01ac text_length 01bc __floatsidf 01c4 $LC6 01d4 __muldf3 01dc $LC7 01f0 __adddf3 01fc __fixdfsi 02a0 text_height 02b0 gfx_driver 02cc $LC8 02f0 __subdf3 0310 $LC9 0358 $LC10 0424 centre_dialog 042c gui_fg_color 0430 gui_bg_color 043c set_dialog_color 0448 popup_dialog 0464 _al_free 04a8 ustrzcpy 0570 .text 05b0 ucwidth 05c8 _al_getdcwd 05d0 fix_filename_case 05d8 fix_filename_slashes 05e0 put_backslash 0690 ustrtok_r 06e0 _al_sane_realloc 0850 ugetx 0864 utolower 08b4 get_filename 02bc $LC11 090c get_extension 094c $LC12 0970 ustrpbrk"
	strings:
		$1 = { 38 FF BD 27 A0 00 B0 AF 21 80 80 00 21 20 A0 00 C0 00 BE AF A8 00 B2 AF C4 00 BF AF BC 00 B7 AF B8 00 B6 AF B4 00 B5 AF B0 00 B4 AF AC 00 B3 AF A4 00 B1 AF 88 00 A5 AF 8C 00 A6 AF 90 00 A7 AF 21 90 00 01 ?? ?? ?? 0? 21 F0 20 01 1B 01 40 10 84 00 A2 AF ?? ?? 02 3C ?? ?? 48 8C ?? ?? 04 3C 27 30 12 00 27 38 1E 00 21 28 00 00 BD 00 03 24 ?? ?? 84 24 31 01 02 24 0A F0 67 00 09 F8 00 01 0A 90 46 00 ?? ?? 03 3C 75 63 04 3C ?? ?? 75 24 2E 72 84 34 ?? ?? ?? 0? 64 00 B0 AE 90 00 A3 8F 88 00 A5 8F ?? ?? 04 3C 02 00 40 14 1A 00 62 00 CD 01 00 00 ?? ?? 84 24 0C 01 A5 AE 12 10 00 00 FF FF 42 24 ?? ?? ?? 0? 04 01 A2 AE ?? ?? 04 3C ?? ?? 84 24 ?? ?? ?? 0? 9C 00 A2 AE ?? ?? 04 3C ?? ?? 83 24 ?? ?? 85 8C 10 00 69 8C 04 00 66 8C 08 00 67 8C 0C 00 68 8C D4 00 A2 AE 8C 00 A2 8F ?? ?? 04 3C ?? ?? 96 24 ?? ?? 85 AC 04 00 C6 AE 08 00 C7 AE 0C 00 C8 AE 35 01 40 10 10 00 C9 AE ?? ?? 02 3C ?? ?? 43 8C 8C 00 A4 8F 09 F8 60 00 94 00 A2 AF 35 01 40 14 ?? ?? 03 3C ?? ?? 04 3C 98 00 A3 AF 9C 00 A4 AF 94 00 A2 8F ?? ?? 43 8C 09 F8 60 00 88 00 A4 8F 15 01 40 10 ?? ?? 02 3C ?? ?? ?? 0? ?? ?? 10 3C ?? ?? 03 8E 09 F8 60 00 00 00 00 00 FD FF 40 14 ?? ?? 03 8E ?? ?? 13 3C ?? ?? 70 8E 75 63 07 3C ?? ?? 04 3C 53 41 05 3C 2E 72 E7 34 ?? ?? 84 24 38 43 A5 34 0C 00 A6 27 ?? ?? ?? 0? 10 00 08 24 21 28 40 00 ?? ?? ?? 0? 21 20 00 02 CD 00 40 12 21 88 40 00 ?? ?? ?? 0? 21 20 40 02 ?? ?? 04 3C ?? ?? 86 8C ?? ?? 87 8C 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 ?? ?? 04 3C ?? ?? 86 8C ?? ?? 87 8C 21 28 60 00 21 20 40 00 ?? ?? ?? 0? 00 00 00 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 48 40 00 FE FF 02 24 18 00 22 01 FE FF 42 26 12 38 00 00 0A 00 06 24 18 00 26 02 44 00 A2 AE 01 00 02 24 3C 00 A2 AE FE FF 02 24 01 00 45 26 02 00 08 24 ?? ?? 64 8E FF FF 43 26 21 18 67 00 21 38 F2 00 EC 00 A3 AE 24 01 A7 AE 0C 00 B2 AE 04 00 A0 AE E4 00 A9 AE 1C 01 A9 AE 54 01 A0 AE 12 30 00 00 01 00 C6 24 7C 00 A6 AE 18 00 C2 00 B4 00 A6 AE 12 10 00 00 21 28 A2 00 23 28 A9 00 02 00 00 15 1A 00 A8 00 CD 01 00 00 12 28 00 00 23 10 45 02 23 10 46 00 AC 00 A2 AE ?? ?? ?? 0? 74 00 A5 AE B3 00 C0 17 21 B0 40 00 ?? ?? 02 3C ?? ?? 42 8C 86 01 40 50 ?? ?? 02 3C 70 00 44 8C ?? ?? ?? 0? ?? ?? 10 3C ?? ?? 04 3C ?? ?? 86 8C ?? ?? 87 8C 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 ?? ?? 06 8E ?? ?? 07 8E 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 21 20 40 00 ?? ?? ?? 0? 21 F0 40 00 ?? ?? 04 3C ?? ?? 86 8C ?? ?? 87 8C 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 ?? ?? 06 8E ?? ?? 07 8E 21 20 40 00 21 28 60 00 ?? ?? ?? 0? 00 00 00 00 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 21 20 40 00 ?? ?? ?? 0? 21 A0 40 00 ?? ?? 04 3C ?? ?? 86 8C ?? ?? 87 8C 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 21 80 40 00 FA FF 02 24 40 98 14 00 21 88 60 00 23 B8 54 00 04 00 D2 26 21 90 53 02 21 20 C0 03 09 00 D3 26 E8 00 B2 AE 10 00 BE AE 08 00 A0 AE 48 00 B6 AE 40 00 B4 AE F0 00 B6 AE ?? ?? ?? 0? 80 00 B3 AE 21 28 60 00 21 30 00 02 21 38 20 02 ?? ?? ?? 0? 21 20 40 00 21 20 60 02 21 80 40 00 ?? ?? ?? 0? 21 88 60 00 21 38 60 00 21 30 40 00 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 21 28 60 00 21 20 40 00 ?? ?? ?? 0? 21 90 56 02 02 00 52 26 21 18 E2 02 21 90 54 02 23 18 72 00 21 20 A0 02 28 01 A3 AE 78 00 A2 AE B0 00 A2 AE B8 00 B3 AE 20 01 B2 AE ?? ?? ?? 0? 58 01 A0 AE ?? ?? 02 3C ?? ?? 03 3C ?? ?? 45 8C ?? ?? 66 8C ?? ?? ?? 0? 21 20 A0 02 21 20 A0 02 ?? ?? ?? 0? 04 00 05 24 21 80 40 00 98 00 A2 8F ?? ?? 44 8C 06 00 80 10 9C 00 A3 8F ?? ?? ?? 0? 00 00 00 00 ?? ?? 02 3C ?? ?? 40 AC 9C 00 A3 8F ?? ?? 64 8C 06 00 80 10 03 00 02 24 ?? ?? ?? 0? 00 00 00 00 ?? ?? 02 3C ?? ?? 40 AC 03 00 02 24 01 01 02 16 84 00 A6 8F 88 00 A4 8F FF 7F 05 3C ?? ?? ?? 0? FF FF A5 34 ?? ?? ?? 0? 84 00 A4 8F 21 10 00 00 C4 00 BF 8F C0 00 BE 8F BC 00 B7 8F B8 00 B6 8F B4 00 B5 8F B0 00 B4 8F AC 00 B3 8F A8 00 B2 8F A4 00 B1 8F A0 00 B0 8F 08 00 E0 03 C8 00 BD 27 ?? ?? 02 3C ?? ?? 42 8C 01 01 40 50 01 00 12 24 6C 00 44 8C ?? ?? ?? 0? ?? ?? 10 3C ?? ?? 04 3C ?? ?? 86 8C ?? ?? 87 8C 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 ?? ?? 06 8E ?? ?? 07 8E 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 21 20 40 00 ?? ?? ?? 0? 21 90 40 00 ?? ?? 04 3C ?? ?? 86 8C ?? ?? 87 8C 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 21 20 40 00 21 28 60 00 ?? ?? 06 8E ?? ?? ?? 0? ?? ?? 07 8E ?? ?? ?? 0? 21 20 C0 03 ?? ?? 04 3C ?? ?? 86 8C ?? ?? 87 8C 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 ?? ?? 04 3C ?? ?? 86 8C ?? ?? 87 8C 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 ?? ?? 43 8C 09 F8 60 00 2F 00 04 24 90 00 A3 8F 88 00 A5 8F 21 20 00 00 ?? ?? ?? 0? 23 30 62 00 ?? ?? ?? 0? 88 00 A4 8F ?? ?? ?? 0? 88 00 A4 8F ?? ?? ?? 0? 88 00 A4 8F ?? ?? ?? 0? 00 00 00 00 ?? ?? 03 3C ?? ?? 04 3C ?? ?? 05 3C 94 00 A3 AF 98 00 A4 AF ?? ?? ?? 0? 9C 00 A5 AF ?? ?? ?? 0? 8C 00 A4 8F ?? ?? 05 3C 98 00 A5 AF F6 00 40 10 ?? ?? A2 AC ?? ?? 04 3C ?? ?? 83 8C 3C 00 B4 27 21 20 80 02 09 F8 60 00 20 00 05 24 ?? ?? 05 3C ?? ?? A3 8C 21 20 82 02 2C 00 05 24 09 F8 60 00 21 88 40 00 ?? ?? 03 3C ?? ?? 66 8C 21 80 51 00 21 20 90 02 09 F8 C0 00 3B 00 05 24 ?? ?? 04 3C ?? ?? 83 8C 21 80 02 02 21 20 90 02 09 F8 60 00 21 28 00 00 98 00 A5 8F 21 30 A0 03 ?? ?? A4 8C ?? ?? ?? 0? 21 28 80 02 94 00 A4 8F 04 00 A2 AF ?? ?? 83 8C 09 F8 60 00 21 20 40 00 90 00 40 10 ?? ?? 02 3C ?? ?? 13 3C 9C 00 A2 AF ?? ?? 60 AE ?? ?? 40 AC 08 00 A0 AF 21 88 00 00 ?? ?? ?? 0? 2F 00 17 24 08 00 05 24 9C 00 A3 8F ?? ?? 62 AE ?? ?? ?? 0? ?? ?? 64 8C 9C 00 A4 8F ?? ?? 82 AC 9C 00 A5 8F 80 18 11 00 01 00 31 26 ?? ?? A2 8C 21 10 43 00 04 00 A3 8F 00 00 43 AC 21 20 00 00 21 28 80 02 ?? ?? ?? 0? 21 30 A0 03 17 00 40 10 04 00 A2 AF 94 00 A5 8F ?? ?? A3 8C 09 F8 60 00 04 00 A4 8F 09 00 57 10 ?? ?? 63 8E 2A 10 23 02 EC FF 40 14 9C 00 A5 8F E2 FF 60 50 02 00 02 24 C0 28 03 00 ?? ?? ?? 0? 40 10 03 00 ?? ?? 02 3C ?? ?? 43 8C 04 00 B0 8F 09 F8 60 00 2F 00 04 24 21 80 02 02 ?? ?? ?? 0? 08 00 B0 AF 08 00 A2 8F 71 FE 40 10 ?? ?? 71 AE ?? ?? 02 3C ?? ?? 43 8C 5C 00 B4 27 21 20 80 02 09 F8 60 00 72 00 05 24 ?? ?? 04 3C ?? ?? 83 8C 68 00 05 24 21 20 82 02 09 F8 60 00 21 88 40 00 ?? ?? 05 3C ?? ?? A6 8C 21 80 51 00 21 20 90 02 09 F8 C0 00 73 00 05 24 ?? ?? 04 3C ?? ?? 83 8C 21 80 02 02 21 20 90 02 09 F8 60 00 64 00 05 24 ?? ?? 05 3C ?? ?? A6 8C 21 80 02 02 21 20 90 02 09 F8 C0 00 61 00 05 24 ?? ?? 04 3C ?? ?? 83 8C 21 80 02 02 21 20 90 02 09 F8 60 00 2B 00 05 24 ?? ?? 05 3C ?? ?? A6 8C 21 80 02 02 21 20 90 02 09 F8 C0 00 2D 00 05 24 ?? ?? 04 3C ?? ?? 83 8C 21 80 02 02 21 28 00 00 09 F8 60 00 21 20 90 02 02 00 05 24 80 00 A5 AF ?? ?? 13 3C 04 00 B7 27 ?? ?? 63 8E 09 F8 60 00 08 00 A4 27 ?? ?? ?? 0? 21 20 40 00 36 FE 40 10 21 88 40 00 04 00 B4 AF 21 80 00 00 ?? ?? 63 8E 09 F8 60 00 21 20 E0 02 F4 FF 40 10 ?? ?? 63 8E 5C 00 22 12 05 00 02 2A ?? ?? ?? 0? 01 00 10 26 84 00 A4 8F ?? ?? ?? 0? ?? ?? 11 3C 94 00 A4 8F ?? ?? 90 8C ?? ?? ?? 0? 88 00 A4 8F 09 F8 00 02 21 20 40 00 11 00 40 14 FF FF 02 24 ?? ?? ?? 0? 00 00 00 00 ?? ?? 50 8C ?? ?? 51 8C FF FF 1E 24 21 A0 00 00 21 98 00 00 ?? ?? ?? 0? FA FF 17 24 ?? ?? 05 3C ?? ?? ?? 0? 9C 00 A5 AF 01 00 09 24 FF FF 02 24 ?? ?? ?? 0? FE FF 07 24 ?? ?? ?? 0? 88 00 A4 8F ?? ?? 23 8E 21 20 40 00 09 F8 60 00 21 98 40 00 E5 FE 40 14 FF FF 02 24 8C 00 A5 8F E2 FE A0 10 ?? ?? 23 8E 09 F8 60 00 21 20 A0 00 DE FE 40 10 FF FF 02 24 75 63 10 3C ?? ?? 04 3C 53 41 05 3C ?? ?? 84 24 38 43 A5 34 1C 00 A6 27 2E 72 07 36 ?? ?? ?? 0? 20 00 08 24 8C 00 A4 8F ?? ?? ?? 0? 21 28 40 00 D0 FE 40 14 FF FF 02 24 ?? ?? 11 3C ?? ?? 25 8E 09 F8 A0 00 2E 00 04 24 88 00 A4 8F 90 00 A5 8F 21 18 85 00 23 18 73 00 2E 72 04 36 ?? ?? ?? 0? 23 90 62 00 ?? ?? 23 8E 21 20 00 00 09 F8 60 00 21 80 40 00 21 10 50 00 2A 10 42 02 BD FE 40 54 FF FF 02 24 ?? ?? 02 3C ?? ?? 43 8C 21 20 60 02 09 F8 60 00 2E 00 05 24 8C 00 A6 8F 21 20 62 02 ?? ?? ?? 0? 21 28 40 02 ?? ?? ?? 0? FF FF 02 24 ?? ?? 02 3C ?? ?? ?? 0? 9C 00 A2 AF 06 00 40 10 05 00 02 3A 80 00 A3 8F 80 10 10 00 21 10 C2 02 ?? ?? ?? 0? 00 00 43 AC 01 00 04 24 02 00 05 24 0A 20 A2 00 ?? ?? ?? 0? 80 00 A4 AF }
	condition:
		$1
}

rule file_14_1_0 {
	meta:
		name = "_al_rand"
		size = 44
		refs = "0000 .bss"
	strings:
		$1 = { ?? ?? 04 3C ?? ?? 82 8C C6 41 03 3C 6D 4E 63 34 01 00 42 24 18 00 43 00 12 10 00 00 39 30 42 24 ?? ?? 82 AC 08 00 E0 03 02 14 02 00 }
	condition:
		$1
}

rule file_14_2_0 {
	meta:
		name = "_al_sane_strncpy"
		size = 52
		refs = "0018 strncat"
	strings:
		$1 = { F8 FF BD 27 00 00 B0 AF 04 00 BF AF 04 00 C0 10 21 80 80 00 00 00 80 A0 ?? ?? ?? 0? FF FF C6 24 04 00 BF 8F 21 10 00 02 00 00 B0 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_14_3_0 {
	meta:
		name = "_al_sane_realloc"
		size = 132
		refs = "0020 _al_free 0028 .text 0030 _al_realloc 006c _al_malloc"
	strings:
		$1 = { F0 FF BD 27 08 00 B1 AF 0C 00 BF AF 04 00 B0 AF 11 00 80 10 21 88 80 00 05 00 A0 14 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 21 80 00 00 ?? ?? ?? 0? 00 00 00 00 0E 00 40 10 21 80 40 00 0C 00 BF 8F 21 10 00 02 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 10 00 BD 27 F3 FF A0 10 0C 00 BF 8F 08 00 B1 8F 04 00 B0 8F 21 20 A0 00 ?? ?? ?? 0? 10 00 BD 27 ?? ?? ?? 0? 21 20 20 02 ?? ?? ?? 0? 0C 00 BF 8F }
	condition:
		$1
}

rule file_15_0_0 {
	meta:
		name = "_handle_timer_tick"
		size = 512
		refs = "0008 .bss 005c _vsync_speed 0060 retrace_proc 007c retrace_count 009c .text 0078 _timer_queue"
	strings:
		$1 = { E0 FF BD 27 14 00 B5 AF ?? ?? 15 3C ?? ?? A2 8E 18 00 B6 AF ?? ?? 16 3C ?? ?? C3 8E 21 20 82 00 1C 00 BF AF 10 00 B4 AF 0C 00 B3 AF 08 00 B2 AF 04 00 B1 AF 00 00 B0 AF ?? ?? A4 AE 64 00 60 14 ?? ?? 11 3C ?? ?? 23 8E ?? ?? B2 8E FF FF 02 24 ?? ?? C2 AE 23 18 72 00 ?? ?? 23 AE ?? ?? 14 3C ?? ?? 13 3C ?? ?? 10 3C ?? ?? 85 8E ?? ?? 64 8E ?? ?? 23 8E 0B 00 60 1C ?? ?? 02 3C ?? ?? 02 8E 21 18 65 00 01 00 42 24 ?? ?? 02 AE F9 FF 80 10 00 00 00 00 09 F8 80 00 ?? ?? 23 AE ?? ?? ?? 0? ?? ?? 85 8E ?? ?? 50 24 00 00 04 8E ?? ?? 23 AE ?? ?? 03 3C ?? ?? 73 24 22 00 80 10 00 80 11 34 0C 00 02 8E 23 00 40 18 21 28 20 02 10 00 03 8E 23 18 72 00 10 00 03 AE 0F 00 60 1C 21 28 60 00 2E 00 80 50 04 00 02 8E 0C 00 02 8E 18 00 40 18 21 18 43 00 04 00 02 8E 2C 00 40 10 10 00 03 AE 09 F8 40 00 08 00 04 8E 10 00 03 8E 00 00 04 8E F3 FF 60 18 21 28 60 00 29 00 80 50 04 00 02 8E 2A 10 71 00 0B 00 40 50 21 28 20 02 14 00 10 26 0B 00 70 12 00 00 00 00 00 00 04 8E E0 FF 80 14 21 88 A0 00 04 00 02 8E DE FF 40 54 0C 00 02 8E 21 28 20 02 14 00 10 26 F8 FF 70 56 00 00 04 8E ?? ?? A2 8E 1C 00 BF 8F ?? ?? C0 AE 23 10 52 00 ?? ?? A2 AE 18 00 B6 8F 21 10 A0 00 14 00 B5 8F 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 20 00 BD 27 D3 FF 40 54 0C 00 02 8E ?? ?? ?? 0? 21 28 20 02 09 F8 80 00 00 00 00 00 00 00 04 8E ?? ?? ?? 0? 10 00 03 8E D8 FF 40 14 2A 10 71 00 ?? ?? ?? 0? 21 28 20 02 1C 00 BF 8F 00 20 05 24 21 10 A0 00 18 00 B6 8F 14 00 B5 8F 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_15_1_0 {
	meta:
		name = "rest_int"
		size = 24
		refs = "0000 .bss"
	strings:
		$1 = { ?? ?? 03 3C ?? ?? 62 8C FF FF 42 24 ?? ?? 62 AC 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_15_2_0 {
	meta:
		name = "timer_can_simulate_retrace"
		size = 44
		refs = "0000 timer_driver"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 8C 06 00 40 10 00 00 00 00 28 00 59 8C 03 00 20 13 00 00 00 00 08 00 20 03 00 00 00 00 08 00 E0 03 21 10 00 00 }
	condition:
		$1
}

rule file_15_3_0 {
	meta:
		name = "timer_simulate_retrace"
		size = 68
		refs = "000c timer_can_simulate_retrace 0028 timer_driver"
	strings:
		$1 = { F8 FF BD 27 00 00 B0 AF 04 00 BF AF ?? ?? ?? 0? 21 80 80 00 04 00 40 14 04 00 BF 8F 00 00 B0 8F 08 00 E0 03 08 00 BD 27 ?? ?? 02 3C ?? ?? 43 8C 21 20 00 02 2C 00 79 8C 00 00 B0 8F 08 00 20 03 08 00 BD 27 }
	condition:
		$1
}

rule file_15_5_0 {
	meta:
		name = "remove_timer_int"
		size = 228
		refs = "003c _timer_queue 000c timer_driver 005c .text"
	strings:
		$1 = { 21 38 80 00 0A 00 C0 10 21 40 A0 00 ?? ?? 02 3C ?? ?? 42 8C 0F 00 40 50 ?? ?? 02 3C 24 00 59 8C 0C 00 20 13 ?? ?? 02 3C 08 00 20 03 00 00 00 00 ?? ?? 02 3C ?? ?? 42 8C 1E 00 40 50 ?? ?? 02 3C 1C 00 59 8C 1B 00 20 53 ?? ?? 02 3C 08 00 20 03 00 00 00 00 ?? ?? 44 24 21 18 00 00 ?? ?? ?? 0? 10 00 05 24 1D 00 65 10 14 00 84 24 00 00 82 8C FC FF E2 54 01 00 63 24 04 00 82 8C F9 FF 02 55 01 00 63 24 ?? ?? 02 3C ?? ?? 46 24 14 00 02 24 18 00 62 00 12 10 00 00 21 10 C2 00 10 00 40 AC 00 00 40 AC 04 00 40 AC 08 00 40 AC 08 00 E0 03 0C 00 40 AC ?? ?? 46 24 21 20 C0 00 21 18 00 00 10 00 05 24 00 00 82 8C F0 FF E2 10 14 00 84 24 01 00 63 24 FC FF 65 54 00 00 82 8C 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_15_8_0 {
	meta:
		name = "remove_timer"
		size = 128
		refs = "0008 timer_driver 001c _timer_use_retrace 0028 _timer_queue 0060 _remove_exit_func 005c remove_timer 0068 _timer_installed"
	strings:
		$1 = { F8 FF BD 27 00 00 B0 AF ?? ?? 10 3C ?? ?? 02 8E 17 00 40 10 04 00 BF AF 14 00 43 8C ?? ?? 02 3C 09 F8 60 00 ?? ?? 40 AC ?? ?? 02 3C ?? ?? 03 3C ?? ?? 00 AE ?? ?? 42 24 ?? ?? 63 24 00 00 40 AC 04 00 40 AC 08 00 40 AC 0C 00 40 AC 10 00 40 AC 14 00 42 24 FA FF 62 54 00 00 40 AC ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 84 24 ?? ?? 02 3C ?? ?? 40 AC 04 00 BF 8F 00 00 B0 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_15_9_0 {
	meta:
		name = "install_timer"
		size = 336
		refs = "0008 timer_driver 0044 _timer_queue 0074 system_driver 0080 _retrace_hpp_value 0090 .bss 008c retrace_proc 00a0 _timer_use_retrace 00d0 .text 00e8 get_config_text 0118 remove_timer 0124 _add_exit_func 011c $LC0 0130 _timer_installed 00b4 _timer_driver_list"
	strings:
		$1 = { E8 FF BD 27 10 00 B3 AF ?? ?? 13 3C ?? ?? 62 8E 14 00 BF AF 0C 00 B2 AF 08 00 B1 AF 09 00 40 10 04 00 B0 AF 21 10 00 00 14 00 BF 8F 10 00 B3 8F 0C 00 B2 8F 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 18 00 BD 27 ?? ?? 02 3C ?? ?? 03 3C ?? ?? 42 24 ?? ?? 63 24 00 00 40 AC 04 00 40 AC 08 00 40 AC 0C 00 40 AC 10 00 40 AC 14 00 42 24 FA FF 62 54 00 00 40 AC ?? ?? 02 3C ?? ?? 43 8C FF FF 04 24 ?? ?? 02 3C 98 00 66 8C ?? ?? 44 AC ?? ?? 03 3C ?? ?? 02 3C 95 42 05 24 ?? ?? 45 AC ?? ?? 60 AC ?? ?? 02 3C ?? ?? 03 3C ?? ?? 40 AC ?? ?? 60 AC 22 00 C0 10 ?? ?? 02 3C 09 F8 C0 00 00 00 00 00 21 90 40 00 04 00 50 8E 1E 00 00 12 0C 00 51 26 ?? ?? ?? 0? 0C 00 04 8E 21 90 20 02 19 00 00 12 0C 00 31 26 0C 00 04 8E ?? ?? ?? 0? ?? ?? 70 AE ?? ?? 64 8E 04 00 02 AE 08 00 02 AE 10 00 83 8C 09 F8 60 00 00 00 00 00 F3 FF 40 54 04 00 30 8E 04 00 42 8E 0B 00 40 10 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 84 24 ?? ?? ?? 0? ?? ?? A5 24 FF FF 03 24 ?? ?? 02 3C ?? ?? ?? 0? ?? ?? 43 AC ?? ?? ?? 0? ?? ?? 52 24 ?? ?? 60 AE ?? ?? ?? 0? FF FF 02 24 }
	condition:
		$1
}

rule file_15_10_0 {
	meta:
		name = "install_timer_int"
		size = 564
		refs = "0008 timer_driver 00a4 _timer_queue 00b0 .text 01d0 install_timer"
	strings:
		$1 = { E8 FF BD 27 04 00 B1 AF ?? ?? 11 3C ?? ?? 22 8E 10 00 B4 AF 0C 00 B3 AF 08 00 B2 AF 00 00 B0 AF 14 00 BF AF 21 80 80 00 21 90 A0 00 21 98 C0 00 67 00 40 10 21 A0 E0 00 0E 00 80 12 ?? ?? 22 8E 20 00 59 8C 17 00 20 13 21 30 60 02 21 20 00 02 21 28 40 02 14 00 BF 8F 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 20 03 18 00 BD 27 18 00 59 8C 39 00 20 13 21 20 00 02 21 28 60 02 14 00 BF 8F 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 20 03 18 00 BD 27 ?? ?? 02 3C ?? ?? 43 24 21 28 00 00 ?? ?? ?? 0? 10 00 04 24 42 00 A4 10 14 00 63 24 00 00 62 8C FC FF 02 56 01 00 A5 24 04 00 62 8C F9 FF 42 56 01 00 A5 24 ?? ?? 02 3C ?? ?? 46 24 14 00 02 24 18 00 A2 00 12 10 00 00 21 10 C2 00 00 00 42 8C 46 00 50 10 14 00 02 24 18 00 A2 00 12 10 00 00 21 10 C2 00 04 00 43 8C 40 00 70 50 14 00 02 24 3C 00 80 12 10 00 53 AC 04 00 50 AC 08 00 52 AC 14 00 02 24 18 00 A2 00 14 00 BF 8F 21 18 00 00 10 00 B4 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 12 10 00 00 21 10 C2 00 0C 00 53 AC 21 10 60 00 0C 00 B3 8F 08 00 E0 03 18 00 BD 27 ?? ?? 02 3C ?? ?? 46 24 21 18 C0 00 21 28 00 00 10 00 04 24 00 00 62 8C D9 FF 02 12 14 00 63 24 01 00 A5 24 FC FF A4 54 00 00 62 8C 21 18 C0 00 21 28 00 00 ?? ?? ?? 0? 10 00 04 24 10 00 A4 10 14 00 63 24 00 00 62 8C FC FF 40 54 01 00 A5 24 04 00 62 8C F9 FF 40 54 01 00 A5 24 ?? ?? ?? 0? 21 10 00 00 ?? ?? 02 3C ?? ?? ?? 0? ?? ?? 46 24 ?? ?? ?? 0? 00 00 00 00 97 FF 40 10 00 00 00 00 14 00 BF 8F FF FF 03 24 21 10 60 00 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 18 00 BD 27 ?? ?? ?? 0? 00 00 50 AC 18 00 A2 00 12 10 00 00 21 10 C2 00 10 00 43 8C 0C 00 44 8C 23 18 64 00 21 18 63 02 ?? ?? ?? 0? 10 00 43 AC }
	condition:
		$1
}

rule file_15_12_0 {
	meta:
		name = "install_param_int"
		size = 20
		refs = "000c .text"
	strings:
		$1 = { A9 04 02 24 18 00 C2 00 FF FF 07 24 ?? ?? ?? 0? 12 30 00 00 }
	condition:
		$1
}

rule file_15_13_0 {
	meta:
		name = "install_int_ex"
		size = 16
		refs = "0008 .text"
	strings:
		$1 = { 21 30 A0 00 21 38 00 00 ?? ?? ?? 0? 21 28 00 00 }
	condition:
		$1
}

rule file_427_0_8 {
	meta:
		name = "on_exit"
		size = 20
		refs = "000c __register_exitproc"
	strings:
		$1 = { 21 30 A0 00 21 38 00 00 21 28 80 00 ?? ?? ?? 0? 01 00 04 24 }
	condition:
		$1
}

rule file_15_14_0 {
	meta:
		name = "install_int"
		size = 24
		refs = "0010 .text"
	strings:
		$1 = { A9 04 02 24 18 00 A2 00 21 38 00 00 21 28 00 00 ?? ?? ?? 0? 12 30 00 00 }
	condition:
		$1
}

rule file_15_15_0 {
	meta:
		name = "rest_callback"
		size = 372
		refs = "0024 system_driver 0050 timer_driver 0084 .text 0094 .bss 0098 install_int 00f4 remove_int 00fc rest 010c clock"
	strings:
		$1 = { E8 FF BD 27 08 00 B1 AF 04 00 B0 AF 14 00 BF AF 10 00 B3 AF 0C 00 B2 AF 21 80 80 00 0C 00 80 14 21 88 A0 00 ?? ?? 02 3C ?? ?? 43 8C 6C 00 79 8C 1D 00 20 13 14 00 BF 8F 10 00 B3 8F 0C 00 B2 8F 08 00 B1 8F 04 00 B0 8F 08 00 20 03 18 00 BD 27 ?? ?? 02 3C ?? ?? 42 8C 2C 00 40 10 00 00 00 00 30 00 59 8C 07 00 20 13 14 00 BF 8F 10 00 B3 8F 0C 00 B2 8F 08 00 B1 8F 04 00 B0 8F 08 00 20 03 18 00 BD 27 ?? ?? 13 3C ?? ?? 12 3C ?? ?? 64 26 01 00 05 24 ?? ?? 50 AE ?? ?? ?? 0? 00 00 00 00 08 00 41 04 00 00 00 00 14 00 BF 8F 10 00 B3 8F 0C 00 B2 8F 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 18 00 BD 27 0D 00 20 12 00 00 00 00 09 F8 20 02 00 00 00 00 ?? ?? 42 8E FA FF 40 1C ?? ?? 64 26 14 00 BF 8F 10 00 B3 8F 0C 00 B2 8F 08 00 B1 8F 04 00 B0 8F ?? ?? ?? 0? 18 00 BD 27 ?? ?? ?? 0? 21 20 00 00 ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 21 28 40 00 0F 00 02 3C 40 42 42 34 18 00 02 02 12 20 00 00 D0 07 83 2C 0C 00 60 14 E8 03 02 24 02 00 02 24 21 80 45 00 ?? ?? ?? 0? 21 20 00 00 ?? ?? ?? 0? 00 00 00 00 2B 10 50 00 FA FF 40 14 14 00 BF 8F ?? ?? ?? 0? 10 00 B3 8F 02 00 40 14 1B 00 82 00 CD 01 00 00 ?? ?? ?? 0? 12 10 00 00 }
	condition:
		$1
}

rule file_17_0_0 {
	meta:
		name = "set_display_switch_mode"
		size = 184
		refs = "0000 system_driver 0038 .bss 0068 .data"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 8C F8 FF BD 27 00 00 B0 AF 04 00 BF AF 22 00 40 10 21 80 80 00 58 00 42 8C 18 00 40 10 00 00 00 00 09 F8 40 00 00 00 00 00 0F 00 40 14 21 28 40 00 ?? ?? 02 3C ?? ?? 03 3C ?? ?? 48 24 ?? ?? 67 24 21 20 00 00 20 00 06 24 21 10 04 01 21 18 E4 00 04 00 84 24 00 00 40 AC FB FF 86 14 00 00 60 AC ?? ?? 02 3C ?? ?? 50 AC 04 00 BF 8F 21 10 A0 00 00 00 B0 8F 08 00 E0 03 08 00 BD 27 06 00 80 14 04 00 BF 8F 21 28 00 00 21 10 A0 00 00 00 B0 8F 08 00 E0 03 08 00 BD 27 04 00 BF 8F FF FF 05 24 21 10 A0 00 00 00 B0 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_17_2_0 {
	meta:
		name = "set_display_switch_callback"
		size = 160
		refs = "0008 system_driver 002c .bss 006c .text"
	strings:
		$1 = { 02 00 82 2C 03 00 40 54 ?? ?? 02 3C 08 00 E0 03 FF FF 02 24 ?? ?? 42 8C FC FF 40 10 00 00 00 00 58 00 42 8C F9 FF 40 10 ?? ?? 03 3C ?? ?? 02 3C ?? ?? 4A 24 ?? ?? 63 24 21 40 40 01 21 38 60 00 21 30 00 00 08 00 09 24 0A 00 80 54 00 00 E2 8C 00 00 02 8D 0E 00 40 10 80 10 06 00 01 00 C6 24 04 00 08 25 F8 FF C9 14 04 00 E7 24 ?? ?? ?? 0? 00 00 00 00 FA FF 40 54 01 00 C6 24 80 10 06 00 21 10 62 00 00 00 45 AC 08 00 E0 03 21 10 00 00 21 10 42 01 00 00 45 AC 08 00 E0 03 21 10 00 00 }
	condition:
		$1
}

rule file_17_3_0 {
	meta:
		name = "remove_display_switch_callback"
		size = 88
		refs = "0000 .bss 0014 .text"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 45 24 ?? ?? 03 3C ?? ?? 02 3C ?? ?? 63 24 ?? ?? ?? 0? ?? ?? 46 24 09 00 44 10 04 00 A5 24 0A 00 C5 10 04 00 63 24 00 00 A2 8C FA FF 44 14 00 00 62 8C 00 00 A0 AC F9 FF 44 14 04 00 A5 24 00 00 60 AC F8 FF C5 14 04 00 63 24 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_17_4_0 {
	meta:
		name = "_switch_in"
		size = 80
		refs = "0004 .bss"
		altNames = "_switch_out"
	strings:
		$1 = { F0 FF BD 27 ?? ?? 02 3C ?? ?? 03 3C 08 00 B1 AF 04 00 B0 AF 0C 00 BF AF ?? ?? 50 24 ?? ?? 71 24 00 00 02 8E 03 00 40 10 04 00 10 26 09 F8 40 00 00 00 00 00 FB FF 30 56 00 00 02 8E 0C 00 BF 8F 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 10 00 BD 27 }
	condition:
		$1
}

rule file_17_6_0 {
	meta:
		name = "find_switch_bitmap"
		size = 164
		refs = "0024 .text"
	strings:
		$1 = { F0 FF BD 27 00 00 B0 AF 00 00 90 8C 08 00 B2 AF 04 00 B1 AF 0C 00 BF AF 21 88 A0 00 0F 00 00 16 21 90 C0 00 ?? ?? ?? 0? 0C 00 BF 8F 0C 00 04 26 21 28 20 02 05 00 40 10 21 30 40 02 ?? ?? ?? 0? 00 00 00 00 10 00 40 14 0C 00 BF 8F 08 00 04 26 08 00 10 8E 06 00 00 12 0C 00 BF 8F 00 00 02 8E F2 FF 51 54 0C 00 02 8E 00 00 44 AE 0C 00 BF 8F 21 10 00 02 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 10 00 BD 27 21 80 40 00 21 10 00 02 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 10 00 BD 27 }
	condition:
		$1
}

rule file_17_7_0 {
	meta:
		name = "reconstruct_kids"
		size = 340
		refs = "00fc .text"
	strings:
		$1 = { E0 FF BD 27 08 00 B1 AF 04 00 B0 AF 1C 00 BF AF 18 00 B5 AF 14 00 B4 AF 10 00 B3 AF 0C 00 B2 AF 21 88 A0 00 3A 00 A0 10 21 80 80 00 00 20 13 3C 00 10 14 3C 04 00 12 24 03 00 15 24 00 00 2C 8E 2C 00 02 8E 1C 00 07 8E 20 00 08 8E 24 00 09 8E 3C 00 0A 8E 34 00 8B 8D 34 00 05 8E 38 00 86 8D 38 00 03 8E 25 10 53 00 24 20 54 00 1C 00 87 AD 20 00 88 AD 24 00 89 AD 3C 00 8A AD 23 58 65 01 23 30 C3 00 05 00 80 10 2C 00 82 AD 02 00 40 16 1A 00 72 01 CD 01 00 00 12 58 00 00 1C 00 82 8D 00 00 44 8C 09 00 83 28 22 00 60 10 11 00 82 28 01 00 02 24 04 00 87 8D 0F 00 E0 18 18 00 4B 00 10 00 C2 24 80 10 02 00 21 30 02 02 21 28 80 01 21 20 00 00 12 58 00 00 00 00 C2 8C 01 00 84 24 2A 18 87 00 21 10 4B 00 40 00 A2 AC 04 00 C6 24 F9 FF 60 14 04 00 A5 24 0C 00 25 8E ?? ?? ?? 0? 21 20 80 01 08 00 31 8E CD FF 20 56 00 00 2C 8E 1C 00 BF 8F 18 00 B5 8F 14 00 B4 8F 10 00 B3 8F 0C 00 B2 8F 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 20 00 BD 27 03 00 40 50 19 00 82 28 ?? ?? ?? 0? 02 00 02 24 21 18 40 02 0B 18 A2 02 ?? ?? ?? 0? 21 10 60 00 }
	condition:
		$1
}

rule file_17_8_0 {
	meta:
		name = "_restore_switch_state"
		size = 632
		refs = "0008 screen 003c .bss 0040 _al_linker_mouse 0090 _timer_installed 013c set_clip_rect 0148 destroy_bitmap 0158 .text 0170 _dispsw_status 01e4 blit 01f4 clear_bitmap 0188 _got_prev_current_palette 0220 gfx_driver 0228 _current_palette 0254 _prev_current_palette"
	strings:
		$1 = { D8 FF BD 27 14 00 B5 AF ?? ?? 15 3C ?? ?? A4 8E ?? ?? 02 3C 04 00 B1 AF 24 00 BF AF 20 00 BE AF 1C 00 B7 AF 18 00 B6 AF 10 00 B4 AF 0C 00 B3 AF 08 00 B2 AF 00 00 B0 AF 57 00 80 10 ?? ?? 51 8C ?? ?? 1E 3C ?? ?? C5 8F 11 00 A0 50 21 B8 00 00 08 00 A2 8C 00 00 42 8C 0D 00 40 50 21 B8 00 00 80 00 82 50 04 00 A2 8C 2C 00 43 8C FF 01 02 3C FF FF 46 34 24 18 66 00 04 00 60 10 2C 00 82 8C 24 10 46 00 77 00 62 50 04 00 A2 8C 21 B8 00 00 ?? ?? 14 3C ?? ?? 96 8E 34 00 20 12 ?? ?? 80 AE 00 1E 13 3C 04 00 30 8E 52 00 00 12 00 00 00 00 04 00 02 8E 10 00 42 24 80 10 02 00 0D 00 40 18 00 00 32 8E 21 20 00 02 21 28 40 02 21 30 02 02 00 00 A2 90 00 00 83 90 00 00 82 A0 01 00 84 24 00 00 A3 A0 FA FF 86 14 01 00 A5 24 04 00 30 8E 00 00 32 8E 2C 00 02 8E 1C 00 04 8E 10 00 25 8E 14 00 23 8E 18 00 26 8E 24 10 53 00 14 00 83 AC 10 00 85 AC 2C 00 02 AE 2B 00 C0 14 08 00 40 AE 10 00 07 8E 18 00 08 8E 14 00 06 8E 0C 00 05 8E FF FF E7 24 FF FF 08 25 08 00 10 8E ?? ?? ?? 0? 21 20 40 02 04 00 24 8E ?? ?? ?? 0? 08 00 50 AE 04 00 20 AE 00 00 24 8E ?? ?? ?? 0? 0C 00 25 8E 08 00 31 8E D0 FF 20 56 04 00 30 8E ?? ?? A2 8E ?? ?? 03 3C ?? ?? 60 AC 1C 00 45 8C 08 00 02 24 00 00 A4 8C 24 00 82 50 ?? ?? 02 3C 1D 00 E0 16 ?? ?? C3 8F ?? ?? 96 AE 24 00 BF 8F 20 00 BE 8F 1C 00 B7 8F 18 00 B6 8F 14 00 B5 8F 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 28 00 BD 27 00 00 0A 8E 04 00 0B 8E 21 20 00 02 21 28 40 02 21 30 00 00 21 38 00 00 21 40 00 00 ?? ?? ?? 0? 21 48 00 00 ?? ?? ?? 0? 10 00 07 8E ?? ?? ?? 0? 00 00 24 8E ?? ?? ?? 0? 00 00 24 8E 04 00 62 8C 09 F8 40 00 ?? ?? A4 8E ?? ?? ?? 0? ?? ?? 96 AE ?? ?? 43 8C 0D 00 60 14 ?? ?? 02 3C ?? ?? 43 8C ?? ?? 04 3C ?? ?? 84 24 20 00 62 8C 21 28 00 00 FF 00 06 24 09 F8 40 00 21 38 00 00 D4 FF E0 52 ?? ?? 96 AE ?? ?? ?? 0? ?? ?? C3 8F ?? ?? 04 3C ?? ?? 43 8C ?? ?? ?? 0? ?? ?? 84 24 21 20 00 00 09 F8 40 00 FF FF 17 24 ?? ?? ?? 0? ?? ?? 14 3C }
	condition:
		$1
}

rule file_17_9_0 {
	meta:
		name = "_save_switch_state"
		size = 640
		refs = "0000 screen 0040 .bss 0044 _al_linker_mouse 00bc create_bitmap_ex 0100 blit 0128 set_clip_rect 01c0 .text 01d4 _dispsw_status"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 45 8C D0 FF BD 27 ?? ?? 02 3C 18 00 B4 AF 10 00 B2 AF 2C 00 BF AF 28 00 BE AF 24 00 B7 AF 20 00 B6 AF 1C 00 B5 AF 14 00 B3 AF 0C 00 B1 AF 08 00 B0 AF 21 A0 80 00 6A 00 A0 10 ?? ?? 52 8C ?? ?? 03 3C ?? ?? 64 8C 11 00 80 50 00 00 A0 AF 08 00 82 8C 00 00 42 8C 0D 00 40 50 00 00 A0 AF 80 00 A2 50 04 00 82 8C 2C 00 43 8C FF 01 02 3C FF FF 46 34 24 18 66 00 04 00 60 10 2C 00 A2 8C 24 10 46 00 77 00 62 50 04 00 82 8C 00 00 A0 AF 4F 00 40 12 FF E1 02 3C FF FF 57 34 02 00 15 24 00 1E 16 3C 04 00 1E 24 00 00 42 8E 1C 00 43 8C 04 00 46 8C 00 00 45 8C ?? ?? ?? 0? 00 00 64 8C 21 88 40 00 3B 00 40 10 04 00 42 AE 52 00 95 52 08 00 20 AE 4F 00 9E 12 21 28 40 00 00 00 50 8E 08 00 40 AC 00 00 0A 8E 04 00 0B 8E 21 20 00 02 21 30 00 00 21 38 00 00 21 40 00 00 ?? ?? ?? 0? 21 48 00 00 01 00 13 24 10 00 07 8E 18 00 08 8E 14 00 06 8E 0C 00 05 8E FF FF E7 24 FF FF 08 25 21 20 20 02 ?? ?? ?? 0? 08 00 10 8E 04 00 4C 8E 00 00 4B 8E 08 00 30 AE 1C 00 85 8D 1C 00 66 8D 18 00 53 AE 2C 00 84 8D 2C 00 62 8D 04 00 63 8D 10 00 A8 8C 14 00 A9 8C 14 00 C7 8C 10 00 CA 8C 24 20 96 00 24 10 57 00 10 00 63 24 25 20 82 00 80 18 03 00 14 00 A7 AC 10 00 48 AE 14 00 49 AE 10 00 AA AC 0C 00 60 18 2C 00 84 AD 21 20 60 01 21 28 80 01 21 30 63 01 00 00 A2 90 00 00 83 90 00 00 82 A0 01 00 84 24 00 00 A3 A0 FA FF 86 14 01 00 A5 24 00 00 4B 8E 0C 00 45 8E ?? ?? ?? 0? 21 20 60 01 08 00 52 8E B8 FF 40 56 00 00 42 8E ?? ?? 02 3C ?? ?? 54 AC 00 00 A2 8F 11 00 40 14 ?? ?? 03 3C 2C 00 BF 8F 28 00 BE 8F 24 00 B7 8F 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 E0 03 30 00 BD 27 08 00 20 AE 00 00 50 8E ?? ?? ?? 0? 21 98 00 00 ?? ?? 62 8C ?? ?? 03 3C ?? ?? 64 8C 04 00 59 8C 2C 00 BF 8F 28 00 BE 8F 24 00 B7 8F 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 20 03 30 00 BD 27 FF FF 03 24 21 20 00 00 09 F8 40 00 00 00 A3 AF ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_17_10_0 {
	meta:
		name = "_unregister_switch_bitmap"
		size = 136
		refs = "0008 system_driver 0030 .bss 003c .text 0054 _al_free"
	strings:
		$1 = { E8 FF BD 27 10 00 B1 AF ?? ?? 11 3C ?? ?? 22 8E 0C 00 B0 AF 14 00 BF AF 5C 00 42 8C 04 00 40 10 21 80 80 00 FF FF 04 24 09 F8 40 00 21 28 00 00 ?? ?? 04 3C ?? ?? 84 24 21 28 00 02 ?? ?? ?? 0? 21 30 A0 03 05 00 40 10 21 20 40 00 08 00 43 8C 00 00 A2 8F ?? ?? ?? 0? 00 00 43 AC ?? ?? 22 8E 5C 00 42 8C 03 00 40 10 21 20 00 00 09 F8 40 00 21 28 00 00 14 00 BF 8F 10 00 B1 8F 0C 00 B0 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_17_11_0 {
	meta:
		name = "_register_switch_bitmap"
		size = 248
		refs = "0008 system_driver 003c .bss 0048 .text 0058 _al_malloc"
	strings:
		$1 = { E8 FF BD 27 10 00 B2 AF ?? ?? 12 3C ?? ?? 42 8E 0C 00 B1 AF 08 00 B0 AF 5C 00 42 8C 14 00 BF AF 21 88 80 00 04 00 40 10 21 80 A0 00 FF FF 04 24 09 F8 40 00 21 28 00 00 20 00 00 12 ?? ?? 04 3C 21 28 00 02 ?? ?? 84 24 ?? ?? ?? 0? 21 30 A0 03 0E 00 40 10 21 80 40 00 ?? ?? ?? 0? 1C 00 04 24 0A 00 40 10 21 18 40 00 0C 00 02 8E 00 00 71 AC 0C 00 60 AC 08 00 62 AC 0C 00 03 AE 04 00 60 AC 10 00 60 AC 14 00 60 AC 18 00 60 AC ?? ?? 42 8E 5C 00 42 8C 03 00 40 10 21 20 00 00 09 F8 40 00 21 28 00 00 14 00 BF 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 E0 03 18 00 BD 27 ?? ?? ?? 0? 1C 00 04 24 F1 FF 40 10 21 20 40 00 ?? ?? 03 3C ?? ?? 62 8C 00 00 91 AC 0C 00 80 AC 08 00 82 AC 04 00 80 AC ?? ?? 64 AC 10 00 80 AC 14 00 80 AC ?? ?? ?? 0? 18 00 80 AC }
	condition:
		$1
}

rule file_18_0_0 {
	meta:
		name = "get_translation_matrix"
		size = 84
		refs = "0000 identity_matrix"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 48 24 21 50 80 00 21 60 A0 00 21 48 80 00 30 00 0B 25 00 00 02 8D 04 00 03 8D 08 00 04 8D 0C 00 05 8D 10 00 08 25 00 00 22 AD 04 00 23 AD 08 00 24 AD 0C 00 25 AD F6 FF 0B 15 10 00 29 25 2C 00 47 AD 24 00 4C AD 08 00 E0 03 28 00 46 AD }
	condition:
		$1
}

rule file_18_1_0 {
	meta:
		name = "get_translation_matrix_f"
		size = 80
		refs = "0000 identity_matrix_f"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 46 24 21 40 80 00 21 38 80 00 30 00 C9 24 00 00 C2 8C 04 00 C3 8C 08 00 C4 8C 0C 00 C5 8C 10 00 C6 24 00 00 E2 AC 04 00 E3 AC 08 00 E4 AC 0C 00 E5 AC F6 FF C9 14 10 00 E7 24 2C 00 0E E5 24 00 0C E5 08 00 E0 03 28 00 0D E5 }
	condition:
		$1
}

rule file_18_2_0 {
	meta:
		name = "get_scaling_matrix"
		size = 84
		refs = "0000 identity_matrix"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 48 24 21 50 80 00 21 60 A0 00 21 48 80 00 30 00 0B 25 00 00 02 8D 04 00 03 8D 08 00 04 8D 0C 00 05 8D 10 00 08 25 00 00 22 AD 04 00 23 AD 08 00 24 AD 0C 00 25 AD F6 FF 0B 15 10 00 29 25 20 00 47 AD 00 00 4C AD 08 00 E0 03 10 00 46 AD }
	condition:
		$1
}

rule file_18_3_0 {
	meta:
		name = "get_scaling_matrix_f"
		size = 80
		refs = "0000 identity_matrix_f"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 46 24 21 40 80 00 21 38 80 00 30 00 C9 24 00 00 C2 8C 04 00 C3 8C 08 00 C4 8C 0C 00 C5 8C 10 00 C6 24 00 00 E2 AC 04 00 E3 AC 08 00 E4 AC 0C 00 E5 AC F6 FF C9 14 10 00 E7 24 20 00 0E E5 00 00 0C E5 08 00 E0 03 10 00 0D E5 }
	condition:
		$1
}

rule file_18_4_0 {
	meta:
		name = "get_x_rotate_matrix"
		size = 144
		refs = "0018 _cos_tbl 0038 identity_matrix"
	strings:
		$1 = { C0 FF 02 3C 00 40 42 34 21 10 A2 00 00 40 A5 24 C0 43 A5 7C C0 43 42 7C ?? ?? 03 3C ?? ?? 63 24 80 28 05 00 80 10 02 00 21 10 43 00 21 28 A3 00 00 00 4A 8C 00 00 AB 8C ?? ?? 02 3C ?? ?? 46 24 21 40 80 00 21 38 80 00 30 00 C9 24 00 00 C2 8C 04 00 C3 8C 08 00 C4 8C 0C 00 C5 8C 10 00 C6 24 00 00 E2 AC 04 00 E3 AC 08 00 E4 AC 0C 00 E5 AC F6 FF C9 14 10 00 E7 24 23 10 0A 00 20 00 0B AD 14 00 02 AD 1C 00 0A AD 08 00 E0 03 10 00 0B AD }
	condition:
		$1
}

rule file_18_5_0 {
	meta:
		name = "get_y_rotate_matrix"
		size = 144
		refs = "0018 _cos_tbl 0038 identity_matrix"
	strings:
		$1 = { C0 FF 02 3C 00 40 42 34 21 10 A2 00 00 40 A5 24 C0 43 A5 7C C0 43 42 7C ?? ?? 03 3C ?? ?? 63 24 80 28 05 00 80 10 02 00 21 10 43 00 21 28 A3 00 00 00 4A 8C 00 00 AB 8C ?? ?? 02 3C ?? ?? 46 24 21 40 80 00 21 38 80 00 30 00 C9 24 00 00 C2 8C 04 00 C3 8C 08 00 C4 8C 0C 00 C5 8C 10 00 C6 24 00 00 E2 AC 04 00 E3 AC 08 00 E4 AC 0C 00 E5 AC F6 FF C9 14 10 00 E7 24 23 10 0A 00 20 00 0B AD 18 00 02 AD 00 00 0B AD 08 00 E0 03 08 00 0A AD }
	condition:
		$1
}

rule file_18_6_0 {
	meta:
		name = "get_z_rotate_matrix"
		size = 144
		refs = "0018 _cos_tbl 0038 identity_matrix"
	strings:
		$1 = { C0 FF 02 3C 00 40 42 34 21 10 A2 00 00 40 A5 24 C0 43 A5 7C C0 43 42 7C ?? ?? 03 3C ?? ?? 63 24 80 28 05 00 80 10 02 00 21 10 43 00 21 28 A3 00 00 00 4A 8C 00 00 AB 8C ?? ?? 02 3C ?? ?? 46 24 21 40 80 00 21 38 80 00 30 00 C9 24 00 00 C2 8C 04 00 C3 8C 08 00 C4 8C 0C 00 C5 8C 10 00 C6 24 00 00 E2 AC 04 00 E3 AC 08 00 E4 AC 0C 00 E5 AC F6 FF C9 14 10 00 E7 24 23 10 0A 00 10 00 0B AD 04 00 02 AD 0C 00 0A AD 08 00 E0 03 00 00 0B AD }
	condition:
		$1
}

rule file_18_7_0 {
	meta:
		name = "get_rotation_matrix"
		size = 3456
		refs = "0014 _cos_tbl 00f4 allegro_errno 09f8 .text"
	strings:
		$1 = { C0 FF 09 3C 00 40 29 35 21 10 C9 00 21 18 A9 00 C0 43 42 7C ?? ?? 08 3C ?? ?? 08 25 80 10 02 00 C0 43 63 7C 21 10 48 00 80 18 03 00 00 00 4E 8C 21 18 68 00 00 00 79 8C C3 67 0E 00 E0 FF BD 27 18 00 99 01 1C 00 B4 AF C3 A7 19 00 00 40 E2 24 C0 43 42 7C 21 38 E9 00 00 40 C6 24 00 40 A5 24 80 10 02 00 21 10 48 00 C0 43 A5 7C C0 43 C6 7C C0 43 E7 7C 80 28 05 00 80 30 06 00 80 38 07 00 00 00 4F 8C 00 80 02 34 1C 00 8E 02 21 28 A8 00 21 30 C8 00 21 38 E8 00 0C 00 B0 AF 18 00 B3 AF 00 00 B0 8C 14 00 B2 AF 10 00 B1 AF 21 C0 80 00 00 00 C5 8C 00 00 E7 8C 12 18 00 00 19 00 D9 01 10 48 00 00 21 48 69 00 2A 10 22 01 1E 01 40 10 12 40 00 00 FF 7F 02 24 17 01 22 11 FF FF 02 3C 00 80 22 29 8A 02 40 10 00 80 02 24 18 00 90 01 C3 9F 10 00 ?? ?? 02 3C ?? ?? 43 8C 22 00 02 24 00 80 0A 3C 00 00 62 AC FF FF 0B 24 1C 00 6E 02 12 10 00 00 19 00 D0 01 10 48 00 00 21 48 49 00 00 80 02 34 2A 10 22 01 19 01 40 14 12 40 00 00 ?? ?? 02 3C ?? ?? 43 8C FF 7F 0C 3C 22 00 02 24 FF FF 8C 35 21 68 00 00 00 00 62 AC 19 00 E5 01 C3 8F 0F 00 C3 97 05 00 10 48 00 00 12 40 00 00 18 00 25 02 1C 00 4F 02 12 10 00 00 21 48 49 00 00 80 02 34 2A 10 22 01 1E 01 40 10 ?? ?? 02 3C FF 7F 02 24 7C 02 22 11 FF FF 02 3C 00 80 22 29 59 02 40 10 00 80 02 24 19 00 E5 00 C3 37 07 00 ?? ?? 02 3C ?? ?? 43 8C 22 00 02 24 00 80 04 3C 00 00 62 AC 10 48 00 00 12 40 00 00 18 00 C5 00 1C 00 47 02 12 10 00 00 21 48 49 00 00 80 02 34 2A 10 22 01 18 01 40 14 00 00 04 AF ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 44 34 18 00 EB 01 23 10 0E 00 08 00 02 AF 04 00 04 AF 1C 00 2A 02 12 10 00 00 19 00 4F 01 10 48 00 00 21 48 49 00 00 80 02 34 2A 10 22 01 1D 01 40 10 12 40 00 00 FF 7F 02 24 88 02 22 11 FF FF 02 3C 00 80 22 29 03 02 40 10 00 80 02 24 18 00 D0 00 ?? ?? 02 3C ?? ?? 43 8C 22 00 02 24 00 80 0E 3C 00 00 62 AC 1C 00 67 02 12 10 00 00 19 00 F0 00 10 48 00 00 21 48 49 00 00 80 02 34 2A 10 22 01 18 01 40 14 12 40 00 00 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 44 34 18 00 EB 00 23 10 C4 01 0C 00 02 AF 1C 00 CA 00 12 10 00 00 19 00 47 01 10 48 00 00 21 48 49 00 00 80 02 34 2A 10 22 01 1D 01 40 10 12 40 00 00 FF 7F 02 24 31 02 22 11 FF FF 02 3C 00 80 22 29 E8 01 40 10 00 80 02 24 18 00 30 02 ?? ?? 02 3C ?? ?? 43 8C 22 00 02 24 00 80 0A 3C 00 00 62 AC 1C 00 6F 02 12 10 00 00 19 00 F0 01 10 48 00 00 21 48 49 00 00 80 02 34 2A 10 22 01 18 01 40 14 12 40 00 00 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 44 34 18 00 59 02 21 10 8A 00 10 00 02 AF 1C 00 85 02 12 10 00 00 19 00 B9 00 10 48 00 00 21 48 49 00 00 80 02 34 2A 10 22 01 1D 01 40 10 12 40 00 00 FF 7F 02 24 16 02 22 11 FF FF 02 3C 00 80 22 29 D5 01 40 10 00 80 02 24 18 00 ED 01 ?? ?? 02 3C ?? ?? 43 8C 22 00 02 24 00 80 04 3C 00 00 62 AC 14 00 04 AF 1C 00 2C 02 12 10 00 00 19 00 8F 01 10 48 00 00 21 48 49 00 00 80 02 34 2A 10 22 01 18 01 40 14 12 40 00 00 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 4A 34 18 00 D9 00 1C 00 87 02 12 10 00 00 19 00 F9 00 10 48 00 00 21 48 49 00 00 80 02 34 2A 10 22 01 1D 01 40 10 12 40 00 00 FF 7F 02 24 FC 01 22 11 FF FF 02 3C 00 80 22 29 83 01 40 10 00 80 02 24 18 00 ED 00 ?? ?? 02 3C ?? ?? 43 8C 00 80 04 3C 22 00 02 24 00 00 62 AC 21 10 8A 00 18 00 02 AF 1C 00 CC 00 12 10 00 00 19 00 87 01 10 48 00 00 21 48 49 00 00 80 02 34 2A 10 22 01 18 01 40 14 12 40 00 00 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 4A 34 18 00 39 02 1C 00 8F 02 12 10 00 00 19 00 F9 01 10 48 00 00 21 48 49 00 00 80 02 34 2A 10 22 01 1D 01 40 10 12 40 00 00 FF 7F 02 24 DB 01 22 11 FF FF 02 3C 00 80 22 29 50 01 40 10 00 80 02 24 18 00 50 02 ?? ?? 02 3C ?? ?? 43 8C 00 80 07 3C 22 00 02 24 00 00 62 AC 23 10 47 01 1C 00 02 AF 1C 00 65 02 12 10 00 00 00 00 A2 AF 19 00 B0 00 10 38 00 00 21 38 47 00 00 80 02 34 2A 10 E2 00 18 01 40 14 12 30 00 00 ?? ?? 02 3C ?? ?? 44 8C FF 7F 02 3C 22 00 03 24 FF FF 45 34 00 00 83 AC 1C 00 B4 8F 18 00 B3 8F 14 00 B2 8F 10 00 B1 8F 0C 00 B0 8F 20 00 05 AF 24 00 00 AF 2C 00 00 AF 28 00 00 AF 08 00 E0 03 20 00 BD 27 01 00 42 34 2B 10 02 01 E8 FE 40 14 00 80 22 29 ?? ?? 02 3C ?? ?? 43 8C FF 7F 0A 3C 22 00 02 24 FF FF 4A 35 21 58 00 00 00 00 62 AC 18 00 90 01 C3 9F 10 00 1C 00 6E 02 12 10 00 00 19 00 D0 01 10 48 00 00 21 48 49 00 00 80 02 34 2A 10 22 01 E9 FE 40 10 12 40 00 00 FF 7F 02 24 84 01 22 11 FF FF 02 3C 00 80 22 29 41 01 40 10 00 80 02 24 19 00 E5 01 C3 8F 0F 00 C3 97 05 00 ?? ?? 02 3C ?? ?? 43 8C 22 00 02 24 00 80 0C 3C 00 00 62 AC 10 48 00 00 12 40 00 00 18 00 25 02 1C 00 4F 02 12 10 00 00 21 48 49 00 00 80 02 34 2A 10 22 01 E5 FE 40 14 FF FF 0D 24 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 44 34 19 00 E5 00 C3 37 07 00 10 48 00 00 12 40 00 00 18 00 C5 00 1C 00 47 02 12 10 00 00 21 48 49 00 00 80 02 34 2A 10 22 01 EA FE 40 10 00 00 04 AF FF 7F 02 24 3C 01 22 11 FF FF 02 3C 00 80 22 29 05 01 40 10 00 80 02 24 18 00 EB 01 ?? ?? 02 3C ?? ?? 43 8C 22 00 02 24 00 80 04 3C 00 00 62 AC 23 10 0E 00 08 00 02 AF 04 00 04 AF 1C 00 2A 02 12 10 00 00 19 00 4F 01 10 48 00 00 21 48 49 00 00 80 02 34 2A 10 22 01 E5 FE 40 14 12 40 00 00 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 4E 34 18 00 D0 00 1C 00 67 02 12 10 00 00 19 00 F0 00 10 48 00 00 21 48 49 00 00 80 02 34 2A 10 22 01 EA FE 40 10 12 40 00 00 FF 7F 02 24 1A 01 22 11 FF FF 02 3C 00 80 22 29 E9 00 40 10 00 80 02 24 18 00 EB 00 ?? ?? 02 3C ?? ?? 43 8C 00 80 04 3C 22 00 02 24 00 00 62 AC 23 10 C4 01 0C 00 02 AF 1C 00 CA 00 12 10 00 00 19 00 47 01 10 48 00 00 21 48 49 00 00 80 02 34 2A 10 22 01 E5 FE 40 14 12 40 00 00 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 4A 34 18 00 30 02 1C 00 6F 02 12 10 00 00 19 00 F0 01 10 48 00 00 21 48 49 00 00 80 02 34 2A 10 22 01 EA FE 40 10 12 40 00 00 FF 7F 02 24 F9 00 22 11 FF FF 02 3C 00 80 22 29 D6 00 40 10 00 80 02 24 18 00 59 02 ?? ?? 02 3C ?? ?? 43 8C 00 80 04 3C 22 00 02 24 00 00 62 AC 21 10 8A 00 10 00 02 AF 1C 00 85 02 12 10 00 00 19 00 B9 00 10 48 00 00 21 48 49 00 00 80 02 34 2A 10 22 01 E5 FE 40 14 12 40 00 00 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 44 34 18 00 ED 01 14 00 04 AF 1C 00 2C 02 12 10 00 00 19 00 8F 01 10 48 00 00 21 48 49 00 00 80 02 34 2A 10 22 01 EA FE 40 10 12 40 00 00 FF 7F 02 24 EF 00 22 11 FF FF 02 3C 00 80 22 29 82 00 40 10 00 80 02 24 18 00 D9 00 ?? ?? 02 3C ?? ?? 43 8C 22 00 02 24 00 80 0A 3C 00 00 62 AC 1C 00 87 02 12 10 00 00 19 00 F9 00 10 48 00 00 21 48 49 00 00 80 02 34 2A 10 22 01 E5 FE 40 14 12 40 00 00 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 44 34 18 00 ED 00 21 10 8A 00 18 00 02 AF 1C 00 CC 00 12 10 00 00 19 00 87 01 10 48 00 00 21 48 49 00 00 80 02 34 2A 10 22 01 EA FE 40 10 12 40 00 00 FF 7F 02 24 E0 00 22 11 FF FF 02 3C 00 80 22 29 4F 00 40 10 00 80 02 24 18 00 39 02 ?? ?? 02 3C ?? ?? 43 8C 22 00 02 24 00 80 0A 3C 00 00 62 AC 1C 00 8F 02 12 10 00 00 19 00 F9 01 10 48 00 00 21 48 49 00 00 80 02 34 2A 10 22 01 E5 FE 40 14 12 40 00 00 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 47 34 18 00 50 02 23 10 47 01 1C 00 02 AF 1C 00 65 02 12 10 00 00 00 00 A2 AF 19 00 B0 00 10 38 00 00 21 38 47 00 00 80 02 34 2A 10 E2 00 EA FE 40 10 12 30 00 00 FF 7F 02 24 B2 00 E2 10 FF FF 02 3C 00 80 E2 28 11 00 40 10 00 80 02 24 ?? ?? 02 3C ?? ?? 43 8C 00 80 05 3C 22 00 02 24 00 00 62 AC 1C 00 B4 8F 18 00 B3 8F 14 00 B2 8F 10 00 B1 8F 0C 00 B0 8F 20 00 05 AF 24 00 00 AF 2C 00 00 AF 28 00 00 AF 08 00 E0 03 20 00 BD 27 AF 00 E2 10 01 00 02 3C 02 1C 06 00 00 14 07 00 25 28 43 00 1C 00 B4 8F 18 00 B3 8F 14 00 B2 8F 10 00 B1 8F 0C 00 B0 8F 20 00 05 AF 24 00 00 AF 2C 00 00 AF 28 00 00 AF 08 00 E0 03 20 00 BD 27 B8 00 22 11 01 00 02 3C 02 1C 08 00 00 14 09 00 ?? ?? ?? 0? 25 38 43 00 AD 00 22 11 01 00 02 3C 02 1C 08 00 00 14 09 00 ?? ?? ?? 0? 25 50 43 00 D4 00 22 11 01 00 02 3C 02 1C 08 00 00 14 09 00 ?? ?? ?? 0? 25 20 43 00 C9 00 22 11 01 00 02 3C 02 1C 08 00 00 14 09 00 ?? ?? ?? 0? 25 50 43 00 BE 00 22 11 01 00 02 3C 02 1C 08 00 00 14 09 00 ?? ?? ?? 0? 25 70 43 00 B3 00 22 11 01 00 02 3C 02 1C 08 00 00 14 09 00 ?? ?? ?? 0? 25 20 43 00 A8 00 22 11 01 00 02 3C 02 1C 08 00 00 14 09 00 ?? ?? ?? 0? 25 50 43 00 9D 00 22 11 01 00 02 3C 02 1C 08 00 00 14 09 00 ?? ?? ?? 0? 25 20 43 00 92 00 22 11 01 00 02 3C 02 14 08 00 00 1C 09 00 25 10 62 00 21 60 40 00 ?? ?? ?? 0? C3 6F 02 00 85 00 22 11 01 00 02 3C 02 1C 08 00 00 14 09 00 ?? ?? ?? 0? 25 20 43 00 70 00 22 11 01 00 02 3C 02 1C 08 00 00 14 09 00 ?? ?? ?? 0? 25 20 43 00 65 00 22 11 01 00 02 3C 02 1C 08 00 00 14 09 00 ?? ?? ?? 0? 25 20 43 00 5A 00 22 11 01 00 02 3C 02 14 08 00 00 1C 09 00 25 10 62 00 21 50 40 00 ?? ?? ?? 0? C3 5F 02 00 01 00 42 34 2B 10 02 01 C3 FE 40 54 00 80 22 29 ?? ?? ?? 0? ?? ?? 02 3C 01 00 42 34 2B 10 02 01 E5 FE 40 54 00 80 22 29 ?? ?? ?? 0? ?? ?? 02 3C 01 00 42 34 2B 10 02 01 06 FF 40 54 00 80 22 29 ?? ?? ?? 0? ?? ?? 02 3C 01 00 42 34 2B 10 02 01 83 FD 40 54 00 80 22 29 ?? ?? ?? 0? ?? ?? 02 3C 01 00 42 34 2B 10 02 01 CE FD 40 54 00 80 22 29 ?? ?? ?? 0? ?? ?? 02 3C 01 00 42 34 2B 10 02 01 7B FE 40 54 00 80 22 29 ?? ?? ?? 0? ?? ?? 02 3C 01 00 42 34 2B 10 02 01 E9 FD 40 54 00 80 22 29 ?? ?? ?? 0? ?? ?? 02 3C 01 00 42 34 2B 10 02 01 10 FF 40 54 00 80 22 29 ?? ?? ?? 0? ?? ?? 02 3C 01 00 42 34 2B 10 02 01 03 FE 40 54 00 80 22 29 ?? ?? ?? 0? ?? ?? 02 3C 01 00 42 34 2B 10 02 01 24 FE 40 54 00 80 22 29 ?? ?? ?? 0? ?? ?? 02 3C 01 00 42 34 2B 10 C2 00 4D FF 40 54 00 80 E2 28 ?? ?? ?? 0? ?? ?? 02 3C 01 00 42 34 2B 10 02 01 1F FF 40 54 00 80 22 29 ?? ?? ?? 0? ?? ?? 02 3C 01 00 42 34 2B 10 02 01 77 FD 40 54 00 80 22 29 ?? ?? ?? 0? ?? ?? 02 3C 2B 10 C2 00 51 FF 40 10 02 1C 06 00 ?? ?? ?? 0? ?? ?? 02 3C 2B 10 02 01 A6 FF 40 10 02 14 08 00 ?? ?? ?? 0? 18 00 90 01 2B 10 02 01 9B FF 40 10 02 1C 08 00 ?? ?? ?? 0? 19 00 E5 00 2B 10 02 01 90 FF 40 10 02 1C 08 00 ?? ?? ?? 0? 18 00 59 02 2B 10 02 01 53 FF 40 10 02 1C 08 00 ?? ?? ?? 0? 18 00 39 02 2B 10 02 01 48 FF 40 10 02 1C 08 00 ?? ?? ?? 0? 18 00 50 02 2B 10 02 01 7B FF 40 10 02 1C 08 00 ?? ?? ?? 0? 18 00 ED 01 2B 10 02 01 6E FF 40 10 02 14 08 00 ?? ?? ?? 0? 19 00 E5 01 2B 10 02 01 63 FF 40 10 02 1C 08 00 ?? ?? ?? 0? 18 00 EB 00 2B 10 02 01 58 FF 40 10 02 1C 08 00 ?? ?? ?? 0? 18 00 30 02 2B 10 02 01 4D FF 40 10 02 1C 08 00 ?? ?? ?? 0? 18 00 EB 01 2B 10 02 01 42 FF 40 10 02 1C 08 00 ?? ?? ?? 0? 18 00 D0 00 2B 10 02 01 37 FF 40 10 02 1C 08 00 ?? ?? ?? 0? 18 00 D9 00 2B 10 02 01 2C FF 40 10 02 1C 08 00 ?? ?? ?? 0? 18 00 ED 00 }
	condition:
		$1
}

rule file_18_8_0 {
	meta:
		name = "get_transformation_matrix"
		size = 5556
		refs = "159c allegro_errno 0014 _cos_tbl 0f78 .text"
	strings:
		$1 = { C0 FF 0D 3C 00 40 AD 35 21 10 ED 00 21 18 CD 00 C0 43 42 7C ?? ?? 0C 3C ?? ?? 8C 25 80 10 02 00 C0 43 63 7C C0 FF BD 27 21 10 4C 00 80 18 03 00 21 18 6C 00 20 00 B1 AF 00 00 51 8C 28 00 B3 AF 00 00 73 8C C3 77 11 00 3C 00 BE AF 18 00 D3 01 C3 F7 13 00 00 40 02 25 00 40 E7 24 C0 43 E7 7C C0 43 42 7C 21 40 0D 01 00 40 C6 24 80 38 07 00 80 10 02 00 21 38 EC 00 21 10 4C 00 C0 43 C6 7C C0 43 08 7D 80 30 06 00 80 40 08 00 08 00 AB AF 00 00 EB 8C 1C 00 D1 03 00 00 47 8C 00 80 02 34 21 30 CC 00 21 40 0C 01 2C 00 B4 AF 24 00 B2 AF 1C 00 B0 AF 00 00 D4 8C 38 00 B7 AF 34 00 B6 AF 30 00 B5 AF 21 90 80 00 21 80 A0 00 00 00 A9 AF 04 00 AA AF 00 00 06 8D 12 18 00 00 19 00 33 02 10 68 00 00 21 68 6D 00 2A 10 A2 01 E0 01 40 10 12 60 00 00 FF 7F 02 24 D9 01 A2 11 FF FF 02 3C 00 80 A2 29 1E 04 40 10 00 80 02 24 18 00 D4 01 ?? ?? 02 3C ?? ?? 43 8C 22 00 02 24 00 80 18 3C 00 00 62 AC C3 1F 14 00 FF FF 19 24 0C 00 A3 AF 1C 00 71 00 12 10 00 00 19 00 34 02 10 68 00 00 21 68 4D 00 00 80 02 34 2A 10 A2 01 DB 01 40 14 12 60 00 00 ?? ?? 02 3C ?? ?? 43 8C FF 7F 08 3C 22 00 02 24 FF FF 08 35 21 48 00 00 00 00 62 AC 19 00 EB 00 C3 B7 07 00 C3 BF 0B 00 10 78 00 00 12 70 00 00 18 00 CB 02 1C 00 E7 02 12 10 00 00 21 78 4F 00 00 80 02 34 2A 10 E2 01 E0 01 40 10 ?? ?? 02 3C FF 7F 02 24 1D 04 E2 11 FF FF 02 3C 00 80 E2 29 00 04 40 10 00 80 02 24 FF FF 0D 24 18 00 0D 02 00 80 0C 3C C3 57 10 00 ?? ?? 02 3C ?? ?? 43 8C 22 00 02 24 00 00 62 AC 1C 00 4C 01 12 10 00 00 19 00 90 01 10 68 00 00 21 68 4D 00 00 80 02 34 2A 10 A2 01 DA 01 40 14 12 60 00 00 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 44 34 19 00 CB 00 C3 AF 06 00 10 78 00 00 12 70 00 00 18 00 AB 02 1C 00 E6 02 12 10 00 00 21 78 4F 00 00 80 02 34 2A 10 E2 01 DF 01 40 10 00 00 44 AE FF 7F 02 24 E8 03 E2 11 FF FF 02 3C 00 80 E2 29 A1 03 40 10 00 80 02 24 FF FF 0D 24 18 00 0D 02 00 80 0C 3C ?? ?? 02 3C ?? ?? 43 8C 22 00 02 24 00 00 62 AC 1C 00 4C 01 12 10 00 00 19 00 90 01 10 68 00 00 21 68 4D 00 00 80 02 34 2A 10 A2 01 DA 01 40 14 12 60 00 00 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 44 34 23 10 11 00 19 00 50 00 C3 1F 02 00 10 68 00 00 12 60 00 00 18 00 70 00 1C 00 42 01 12 10 00 00 21 68 4D 00 00 80 02 34 2A 10 A2 01 DF 01 40 10 04 00 44 AE FF 7F 02 24 19 04 A2 11 FF FF 02 3C 00 80 A2 29 9A 03 40 10 00 80 02 24 18 00 F9 00 ?? ?? 02 3C ?? ?? 43 8C 22 00 02 24 00 80 04 3C 00 00 62 AC 08 00 44 AE 1C 00 D8 02 12 10 00 00 19 00 07 03 10 68 00 00 21 68 4D 00 00 80 02 34 2A 10 A2 01 DA 01 40 14 12 60 00 00 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 45 34 18 00 B4 02 0C 00 A2 8F 1C 00 46 00 12 10 00 00 19 00 D4 00 10 68 00 00 21 68 4D 00 00 80 02 34 2A 10 A2 01 DF 01 40 10 12 60 00 00 FF 7F 02 24 04 04 A2 11 FF FF 02 3C 00 80 A2 29 61 03 40 10 00 80 02 24 ?? ?? 02 3C ?? ?? 43 8C 00 80 04 3C 22 00 02 24 00 00 62 AC 23 10 A4 00 19 00 50 00 C3 1F 02 00 10 68 00 00 12 60 00 00 18 00 70 00 1C 00 42 01 12 10 00 00 21 68 4D 00 00 80 02 34 2A 10 A2 01 DB 01 40 14 FF 7F 02 24 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 44 34 18 00 D9 00 0C 00 44 AE 1C 00 B8 02 12 10 00 00 19 00 06 03 10 68 00 00 21 68 4D 00 00 80 02 34 2A 10 A2 01 DF 01 40 10 12 60 00 00 FF 7F 02 24 B1 03 A2 11 FF FF 02 3C 00 80 A2 29 0A 03 40 10 00 80 02 24 18 00 D4 02 ?? ?? 02 3C ?? ?? 43 8C 22 00 02 24 00 80 05 3C 00 00 62 AC 0C 00 A2 8F 1C 00 47 00 12 10 00 00 19 00 F4 00 10 68 00 00 21 68 4D 00 00 80 02 34 2A 10 A2 01 DA 01 40 14 12 60 00 00 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 44 34 21 10 85 00 19 00 50 00 C3 1F 02 00 10 68 00 00 12 60 00 00 18 00 70 00 1C 00 42 01 12 10 00 00 21 68 4D 00 00 80 02 34 2A 10 A2 01 E0 01 40 10 ?? ?? 02 3C FF 7F 02 24 AC 03 A2 11 FF FF 02 3C 00 80 A2 29 D5 02 40 10 00 80 02 24 18 00 F3 02 ?? ?? 02 3C ?? ?? 43 8C 22 00 02 24 00 80 04 3C 00 00 62 AC 10 00 44 AE 1C 00 CB 03 12 10 00 00 19 00 73 01 10 78 00 00 21 78 4F 00 00 80 02 34 2A 10 E2 01 DA 01 40 14 12 70 00 00 ?? ?? 02 3C ?? ?? 43 8C FF 7F 0C 3C 22 00 02 24 FF FF 8C 35 21 68 00 00 00 00 62 AC 18 00 0D 02 1C 00 4C 01 12 10 00 00 19 00 90 01 10 68 00 00 21 68 4D 00 00 80 02 34 2A 10 A2 01 DF 01 40 10 12 60 00 00 FF 7F 02 24 6D 03 A2 11 FF FF 02 3C 00 80 A2 29 A0 02 40 10 00 80 02 24 18 00 E9 00 ?? ?? 02 3C ?? ?? 43 8C 22 00 02 24 00 80 04 3C 00 00 62 AC 14 00 44 AE 1C 00 C8 02 12 10 00 00 19 00 07 01 10 68 00 00 21 68 4D 00 00 80 02 34 2A 10 A2 01 DA 01 40 14 12 60 00 00 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 45 34 18 00 B3 02 1C 00 C6 03 12 10 00 00 19 00 D3 00 10 68 00 00 21 68 4D 00 00 80 02 34 2A 10 A2 01 DF 01 40 10 12 60 00 00 FF 7F 02 24 0B 03 A2 11 FF FF 02 3C 00 80 A2 29 A6 02 40 10 00 80 02 24 ?? ?? 02 3C ?? ?? 43 8C 00 80 04 3C 22 00 02 24 00 00 62 AC 21 10 85 00 19 00 50 00 C3 1F 02 00 10 68 00 00 12 60 00 00 18 00 70 00 1C 00 42 01 12 10 00 00 21 68 4D 00 00 80 02 34 2A 10 A2 01 DB 01 40 14 FF 7F 02 24 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 44 34 18 00 C9 00 18 00 44 AE 1C 00 A8 02 12 10 00 00 19 00 06 01 10 68 00 00 21 68 4D 00 00 80 02 34 2A 10 A2 01 DF 01 40 10 12 60 00 00 FF 7F 02 24 24 03 A2 11 FF FF 02 3C 00 80 A2 29 77 02 40 10 00 80 02 24 18 00 D3 02 ?? ?? 02 3C ?? ?? 43 8C 22 00 02 24 00 80 05 3C 00 00 62 AC 1C 00 C7 03 12 10 00 00 19 00 F3 00 10 68 00 00 21 68 4D 00 00 80 02 34 2A 10 A2 01 DA 01 40 14 12 60 00 00 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 48 34 23 10 A8 00 19 00 50 00 C3 1F 02 00 10 68 00 00 12 60 00 00 18 00 70 00 1C 00 42 01 12 10 00 00 21 68 4D 00 00 80 02 34 2A 10 A2 01 E0 01 40 10 ?? ?? 02 3C FF 7F 02 24 A2 02 A2 11 FF FF 02 3C 00 80 A2 29 17 02 40 10 00 80 02 24 18 00 F4 02 ?? ?? 02 3C ?? ?? 43 8C 22 00 02 24 00 80 04 3C 00 00 62 AC 0C 00 A2 8F 1C 00 44 AE 1C 00 4B 00 12 10 00 00 19 00 74 01 10 38 00 00 21 38 47 00 00 80 02 34 2A 10 E2 00 DA 01 40 14 12 30 00 00 ?? ?? 02 3C ?? ?? 43 8C FF 7F 04 3C 22 00 02 24 FF FF 84 34 21 28 00 00 00 00 62 AC 18 00 05 02 1C 00 44 01 12 10 00 00 10 00 A2 AF 19 00 90 00 10 28 00 00 21 28 45 00 00 80 02 34 2A 10 A2 00 DF 01 40 10 12 20 00 00 FF 7F 02 24 A9 02 A2 10 FF FF 02 3C 00 80 A2 28 E0 01 40 10 00 80 02 24 ?? ?? 02 3C ?? ?? 43 8C 22 00 02 24 00 80 05 3C 00 00 62 AC 08 00 A2 8F 00 00 A3 8F 20 00 45 AE 2C 00 42 AE 04 00 A2 8F 24 00 43 AE 3C 00 BE 8F 28 00 42 AE 38 00 B7 8F 34 00 B6 8F 30 00 B5 8F 2C 00 B4 8F 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 40 00 BD 27 01 00 42 34 2B 10 82 01 26 FE 40 14 00 80 A2 29 ?? ?? 02 3C ?? ?? 43 8C FF 7F 18 3C 22 00 02 24 FF FF 18 37 21 C8 00 00 00 00 62 AC 18 00 D4 01 C3 1F 14 00 0C 00 A3 AF 1C 00 71 00 12 10 00 00 19 00 34 02 10 68 00 00 21 68 4D 00 00 80 02 34 2A 10 A2 01 27 FE 40 10 12 60 00 00 FF 7F 02 24 63 02 A2 11 FF FF 02 3C 00 80 A2 29 0C 02 40 10 00 80 02 24 19 00 EB 00 C3 B7 07 00 C3 BF 0B 00 ?? ?? 02 3C ?? ?? 43 8C 22 00 02 24 00 80 08 3C 00 00 62 AC 10 78 00 00 12 70 00 00 18 00 CB 02 1C 00 E7 02 12 10 00 00 21 78 4F 00 00 80 02 34 2A 10 E2 01 23 FE 40 14 FF FF 09 24 ?? ?? 02 3C ?? ?? 43 8C FF 7F 0C 3C 22 00 02 24 FF FF 8C 35 21 68 00 00 00 00 62 AC 18 00 0D 02 C3 57 10 00 1C 00 4C 01 12 10 00 00 19 00 90 01 10 68 00 00 21 68 4D 00 00 80 02 34 2A 10 A2 01 28 FE 40 10 12 60 00 00 FF 7F 02 24 27 02 A2 11 FF FF 02 3C 00 80 A2 29 0A 02 40 10 00 80 02 24 19 00 CB 00 C3 AF 06 00 ?? ?? 02 3C ?? ?? 43 8C 22 00 02 24 00 80 04 3C 00 00 62 AC 10 78 00 00 12 70 00 00 18 00 AB 02 1C 00 E6 02 12 10 00 00 21 78 4F 00 00 80 02 34 2A 10 E2 01 23 FE 40 14 00 00 44 AE ?? ?? 02 3C ?? ?? 43 8C FF 7F 0C 3C 22 00 02 24 FF FF 8C 35 21 68 00 00 00 00 62 AC 18 00 0D 02 1C 00 4C 01 12 10 00 00 19 00 90 01 10 68 00 00 21 68 4D 00 00 80 02 34 2A 10 A2 01 28 FE 40 10 12 60 00 00 FF 7F 02 24 59 02 A2 11 FF FF 02 3C 00 80 A2 29 CE 01 40 10 00 80 02 24 ?? ?? 02 3C ?? ?? 43 8C 22 00 02 24 00 80 04 3C 00 00 62 AC 23 10 11 00 19 00 50 00 C3 1F 02 00 10 68 00 00 12 60 00 00 18 00 70 00 1C 00 42 01 12 10 00 00 21 68 4D 00 00 80 02 34 2A 10 A2 01 23 FE 40 14 04 00 44 AE ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 44 34 18 00 F9 00 08 00 44 AE 1C 00 D8 02 12 10 00 00 19 00 07 03 10 68 00 00 21 68 4D 00 00 80 02 34 2A 10 A2 01 28 FE 40 10 12 60 00 00 FF 7F 02 24 EE 01 A2 11 FF FF 02 3C 00 80 A2 29 9F 01 40 10 00 80 02 24 18 00 B4 02 ?? ?? 02 3C ?? ?? 43 8C 22 00 02 24 00 80 05 3C 00 00 62 AC 0C 00 A2 8F 1C 00 46 00 12 10 00 00 19 00 D4 00 10 68 00 00 21 68 4D 00 00 80 02 34 2A 10 A2 01 23 FE 40 14 12 60 00 00 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 44 34 23 10 A4 00 19 00 50 00 C3 1F 02 00 10 68 00 00 12 60 00 00 18 00 70 00 1C 00 42 01 12 10 00 00 21 68 4D 00 00 80 02 34 2A 10 A2 01 29 FE 40 10 ?? ?? 02 3C FF 7F 02 24 1F 02 A2 11 FF FF 02 3C 00 80 A2 29 22 01 40 10 00 80 02 24 18 00 D9 00 ?? ?? 02 3C ?? ?? 43 8C 22 00 02 24 00 80 04 3C 00 00 62 AC 0C 00 44 AE 1C 00 B8 02 12 10 00 00 19 00 06 03 10 68 00 00 21 68 4D 00 00 80 02 34 2A 10 A2 01 23 FE 40 14 12 60 00 00 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 45 34 18 00 D4 02 0C 00 A2 8F 1C 00 47 00 12 10 00 00 19 00 F4 00 10 68 00 00 21 68 4D 00 00 80 02 34 2A 10 A2 01 28 FE 40 10 12 60 00 00 FF 7F 02 24 B6 01 A2 11 FF FF 02 3C 00 80 A2 29 15 01 40 10 00 80 02 24 ?? ?? 02 3C ?? ?? 43 8C 00 80 04 3C 22 00 02 24 00 00 62 AC 21 10 85 00 19 00 50 00 C3 1F 02 00 10 68 00 00 12 60 00 00 18 00 70 00 1C 00 42 01 12 10 00 00 21 68 4D 00 00 80 02 34 2A 10 A2 01 24 FE 40 14 FF 7F 02 24 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 44 34 18 00 F3 02 10 00 44 AE 1C 00 CB 03 12 10 00 00 19 00 73 01 10 78 00 00 21 78 4F 00 00 80 02 34 2A 10 E2 01 28 FE 40 10 12 70 00 00 FF 7F 02 24 9F 01 E2 11 FF FF 02 3C 00 80 E2 29 DE 00 40 10 00 80 02 24 FF FF 0D 24 18 00 0D 02 00 80 0C 3C ?? ?? 02 3C ?? ?? 43 8C 22 00 02 24 00 00 62 AC 1C 00 4C 01 12 10 00 00 19 00 90 01 10 68 00 00 21 68 4D 00 00 80 02 34 2A 10 A2 01 23 FE 40 14 12 60 00 00 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 44 34 18 00 E9 00 14 00 44 AE 1C 00 C8 02 12 10 00 00 19 00 07 01 10 68 00 00 21 68 4D 00 00 80 02 34 2A 10 A2 01 28 FE 40 10 12 60 00 00 FF 7F 02 24 6C 01 A2 11 FF FF 02 3C 00 80 A2 29 E3 00 40 10 00 80 02 24 18 00 B3 02 ?? ?? 02 3C ?? ?? 43 8C 22 00 02 24 00 80 05 3C 00 00 62 AC 1C 00 C6 03 12 10 00 00 19 00 D3 00 10 68 00 00 21 68 4D 00 00 80 02 34 2A 10 A2 01 23 FE 40 14 12 60 00 00 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 44 34 21 10 85 00 19 00 50 00 C3 1F 02 00 10 68 00 00 12 60 00 00 18 00 70 00 1C 00 42 01 12 10 00 00 21 68 4D 00 00 80 02 34 2A 10 A2 01 29 FE 40 10 ?? ?? 02 3C FF 7F 02 24 7A 01 A2 11 FF FF 02 3C 00 80 A2 29 A9 00 40 10 00 80 02 24 18 00 C9 00 ?? ?? 02 3C ?? ?? 43 8C 22 00 02 24 00 80 04 3C 00 00 62 AC 18 00 44 AE 1C 00 A8 02 12 10 00 00 19 00 06 01 10 68 00 00 21 68 4D 00 00 80 02 34 2A 10 A2 01 23 FE 40 14 12 60 00 00 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 45 34 18 00 D3 02 1C 00 C7 03 12 10 00 00 19 00 F3 00 10 68 00 00 21 68 4D 00 00 80 02 34 2A 10 A2 01 28 FE 40 10 12 60 00 00 FF 7F 02 24 12 01 A2 11 FF FF 02 3C 00 80 A2 29 57 00 40 10 00 80 02 24 ?? ?? 02 3C ?? ?? 43 8C 00 80 08 3C 22 00 02 24 00 00 62 AC 23 10 A8 00 19 00 50 00 C3 1F 02 00 10 68 00 00 12 60 00 00 18 00 70 00 1C 00 42 01 12 10 00 00 21 68 4D 00 00 80 02 34 2A 10 A2 01 24 FE 40 14 FF 7F 02 24 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 44 34 18 00 F4 02 0C 00 A2 8F 1C 00 44 AE 1C 00 4B 00 12 10 00 00 19 00 74 01 10 38 00 00 21 38 47 00 00 80 02 34 2A 10 E2 00 28 FE 40 10 12 30 00 00 FF 7F 02 24 DC 00 E2 10 FF FF 02 3C 00 80 E2 28 1F 00 40 10 00 80 02 24 FF FF 05 24 18 00 05 02 00 80 04 3C ?? ?? 02 3C ?? ?? 43 8C 22 00 02 24 00 00 62 AC 1C 00 44 01 12 10 00 00 10 00 A2 AF 19 00 90 00 10 28 00 00 21 28 45 00 00 80 02 34 2A 10 A2 00 23 FE 40 14 12 20 00 00 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC ?? ?? ?? 0? FF FF 45 34 19 01 A2 10 01 00 02 3C 02 1C 04 00 00 14 05 00 ?? ?? ?? 0? 25 28 43 00 1D 01 E2 10 01 00 02 3C 02 14 06 00 00 1C 07 00 25 10 62 00 21 20 40 00 ?? ?? ?? 0? C3 2F 02 00 79 01 A2 11 01 00 02 3C 02 1C 0C 00 00 14 0D 00 ?? ?? ?? 0? 25 20 43 00 6E 01 A2 11 01 00 02 3C 02 1C 0C 00 00 14 0D 00 ?? ?? ?? 0? 25 40 43 00 63 01 A2 11 01 00 02 3C 02 1C 0C 00 00 14 0D 00 ?? ?? ?? 0? 25 20 43 00 }
	condition:
		$1
}

rule file_18_9_0 {
	meta:
		name = "qtranslate_matrix"
		size = 40
	strings:
		$1 = { 24 00 83 8C 28 00 88 8C 2C 00 82 8C 21 18 65 00 21 40 06 01 21 10 47 00 2C 00 82 AC 24 00 83 AC 08 00 E0 03 28 00 88 AC }
	condition:
		$1
}

rule file_18_10_0 {
	meta:
		name = "qtranslate_matrix_f"
		size = 40
	strings:
		$1 = { 24 00 80 C4 28 00 81 C4 2C 00 82 C4 00 00 0C 46 40 08 0D 46 80 10 0E 46 24 00 80 E4 28 00 81 E4 08 00 E0 03 2C 00 82 E4 }
	condition:
		$1
}

rule file_18_11_0 {
	meta:
		name = "qscale_matrix"
		size = 284
		refs = "0000 allegro_errno 00fc .text"
	strings:
		$1 = { ?? ?? 02 3C E0 FF BD 27 ?? ?? 4D 8C FF FF 03 3C FF 7F 02 3C 1C 00 B4 AF 18 00 B3 AF 14 00 B2 AF 10 00 B1 AF 0C 00 B0 AF 01 00 73 34 FF FF 58 34 C3 67 05 00 21 58 00 00 0C 00 11 24 00 80 0F 34 22 00 19 24 FF 7F 10 24 00 80 12 24 01 00 14 3C 03 00 0E 24 18 00 71 01 21 50 00 00 12 10 00 00 21 40 82 00 00 00 03 8D 21 48 00 03 18 00 83 01 C3 17 03 00 1C 00 45 00 12 30 00 00 00 00 A6 AF 00 00 A2 8F 19 00 A3 00 10 38 00 00 21 38 47 00 2A 10 EF 00 12 30 00 00 18 00 40 10 00 80 E3 28 14 00 F0 10 2B 10 D3 00 02 4C 06 00 18 00 60 14 00 14 07 00 13 00 F2 10 25 48 49 00 01 00 4A 25 00 00 09 AD E7 FF 4E 15 04 00 08 25 01 00 6B 25 E1 FF 6A 15 18 00 71 01 1C 00 B4 8F 18 00 B3 8F 14 00 B2 8F 10 00 B1 8F 0C 00 B0 8F 08 00 E0 03 20 00 BD 27 ED FF 40 54 02 4C 06 00 ?? ?? ?? 0? 00 00 B9 AD 2B 10 D4 00 ED FF 40 50 01 00 4A 25 00 00 B9 AD ?? ?? ?? 0? 00 80 09 3C }
	condition:
		$1
}

rule file_18_12_0 {
	meta:
		name = "qscale_matrix_f"
		size = 64
	strings:
		$1 = { 21 10 00 00 03 00 03 24 00 00 80 C4 04 00 81 C4 08 00 82 C4 02 00 0C 46 42 08 0C 46 82 10 0C 46 01 00 42 24 00 00 80 E4 04 00 81 E4 08 00 82 E4 F5 FF 43 14 0C 00 84 24 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_18_13_0 {
	meta:
		name = "matrix_mul"
		size = 1060
		refs = "0040 allegro_errno 02ac .text"
	strings:
		$1 = { A8 FF BD 27 40 00 B3 AF 34 00 B0 AF 54 00 BE AF 50 00 B7 AF 4C 00 B6 AF 48 00 B5 AF 44 00 B4 AF 3C 00 B2 AF 38 00 B1 AF 21 80 80 00 21 98 C0 00 DD 00 86 10 21 38 A0 00 EB 00 A6 50 21 38 C0 00 ?? ?? 03 3C FF 7F 02 3C ?? ?? 6F 8C FF FF 57 34 FF FF 02 3C 21 30 E0 00 01 00 5E 34 21 88 60 02 21 68 E0 00 21 28 00 00 00 80 19 34 22 00 18 24 FF 7F 12 24 00 80 15 24 03 00 16 24 21 A0 E0 02 0C 00 03 24 18 00 A3 00 21 50 00 02 21 60 00 00 12 10 00 00 21 58 62 02 00 00 A2 8D 00 00 43 8D 18 00 43 00 10 48 00 00 2A 20 39 01 88 00 80 10 12 40 00 00 84 00 32 11 2B 10 1E 01 00 80 22 29 8A 00 40 54 00 00 F8 AD 84 00 35 11 01 00 03 3C 02 1C 08 00 00 14 09 00 25 70 43 00 04 00 A2 8D 0C 00 43 8D 18 00 43 00 10 48 00 00 2A 20 39 01 72 00 80 10 12 40 00 00 6E 00 32 11 2B 10 1E 01 00 80 22 29 7F 00 40 54 00 00 F8 AD 79 00 35 11 01 00 03 3C 02 1C 08 00 00 14 09 00 25 38 43 00 08 00 A2 8D 18 00 43 8D 18 00 43 00 10 48 00 00 2A 20 39 01 5C 00 80 10 12 40 00 00 58 00 32 11 2B 10 1E 01 00 80 22 29 74 00 40 54 00 00 F8 AD 6E 00 35 11 01 00 03 3C 02 1C 08 00 00 14 09 00 25 18 43 00 21 10 EE 00 21 10 43 00 01 00 8C 25 00 00 62 AD 04 00 4A 25 C7 FF 96 15 04 00 6B 25 00 00 A2 8D 24 00 03 8E 18 00 43 00 10 48 00 00 2A 20 39 01 6F 00 80 10 12 40 00 00 6B 00 32 11 2B 10 1E 01 00 80 22 29 71 00 40 54 00 00 F8 AD 6B 00 35 11 01 00 03 3C 02 1C 08 00 00 14 09 00 25 50 43 00 04 00 A2 8D 28 00 03 8E 18 00 43 00 10 48 00 00 2A 20 39 01 59 00 80 10 12 40 00 00 55 00 32 11 2B 10 1E 01 00 80 22 29 6C 00 40 54 00 00 F8 AD 66 00 35 11 01 00 03 3C 02 1C 08 00 00 14 09 00 25 38 43 00 08 00 A2 8D 2C 00 03 8E 18 00 43 00 10 48 00 00 2A 20 39 01 43 00 80 10 12 40 00 00 3F 00 32 11 2B 10 1E 01 00 80 22 29 55 00 40 54 00 00 F8 AD 4F 00 35 11 01 00 03 3C 02 1C 08 00 00 14 09 00 25 18 43 00 24 00 C2 8C 01 00 A5 24 04 00 C6 24 21 10 42 01 21 10 47 00 21 10 43 00 24 00 22 AE 0C 00 AD 25 84 FF B6 14 04 00 31 26 54 00 BE 8F 50 00 B7 8F 4C 00 B6 8F 48 00 B5 8F 44 00 B4 8F 40 00 B3 8F 3C 00 B2 8F 38 00 B1 8F 34 00 B0 8F 08 00 E0 03 58 00 BD 27 A9 FF 40 14 00 80 22 29 00 00 F8 AD ?? ?? ?? 0? 21 18 80 02 93 FF 40 14 00 80 22 29 00 00 F8 AD ?? ?? ?? 0? 21 38 80 02 7D FF 40 14 00 80 22 29 00 00 F8 AD ?? ?? ?? 0? 21 70 80 02 2B 10 03 01 7C FF 40 10 02 1C 08 00 00 00 F8 AD ?? ?? ?? 0? 00 80 0E 3C 2B 10 03 01 87 FF 40 10 02 1C 08 00 00 00 F8 AD ?? ?? ?? 0? 00 80 07 3C 2B 10 03 01 92 FF 40 50 02 1C 08 00 00 00 F8 AD ?? ?? ?? 0? 00 80 03 3C C2 FF 40 14 00 80 22 29 00 00 F8 AD ?? ?? ?? 0? 21 18 E0 02 AC FF 40 14 00 80 22 29 00 00 F8 AD ?? ?? ?? 0? 21 38 E0 02 96 FF 40 14 00 80 22 29 00 00 F8 AD ?? ?? ?? 0? 21 50 E0 02 2B 10 03 01 95 FF 40 10 02 1C 08 00 00 00 F8 AD ?? ?? ?? 0? 00 80 0A 3C 2B 10 03 01 B1 FF 40 50 02 1C 08 00 00 00 F8 AD ?? ?? ?? 0? 00 80 03 3C 2B 10 03 01 9A FF 40 10 02 1C 08 00 00 00 F8 AD ?? ?? ?? 0? 00 80 07 3C 21 40 C0 00 21 48 A0 03 30 00 C6 24 00 00 02 8D 04 00 03 8D 08 00 04 8D 0C 00 05 8D 10 00 08 25 00 00 22 AD 04 00 23 AD 08 00 24 AD 0C 00 25 AD F6 FF 06 15 10 00 29 25 ?? ?? ?? 0? 21 80 A0 03 21 40 A0 03 30 00 C6 24 00 00 E2 8C 04 00 E3 8C 08 00 E4 8C 0C 00 E5 8C 10 00 E7 24 00 00 02 AD 04 00 03 AD 08 00 04 AD 0C 00 05 AD F6 FF E6 14 10 00 08 25 ?? ?? ?? 0? 21 38 A0 03 }
	condition:
		$1
}

rule file_18_14_0 {
	meta:
		name = "matrix_mul_f"
		size = 340
		refs = "0110 .text"
	strings:
		$1 = { D0 FF BD 27 21 50 80 00 33 00 86 10 21 38 A0 00 41 00 A6 50 21 38 C0 00 21 28 E0 00 21 48 C0 00 21 20 E0 00 21 40 00 00 0C 00 0C 24 03 00 0B 24 18 00 0C 01 21 18 40 01 21 38 00 00 12 10 00 00 21 10 C2 00 00 00 60 C4 0C 00 62 C4 00 00 83 C4 04 00 84 C4 18 00 61 C4 02 00 03 46 82 10 04 46 08 00 83 C4 01 00 E7 24 04 00 63 24 42 08 03 46 00 00 02 46 00 00 01 46 00 00 40 E4 F1 FF EB 14 04 00 42 24 00 00 83 C4 04 00 84 C4 24 00 40 C5 28 00 42 C5 2C 00 41 C5 02 00 03 46 82 10 04 46 08 00 83 C4 24 00 A4 C4 01 00 08 25 42 08 03 46 0C 00 84 24 04 00 A5 24 00 00 02 46 00 00 01 46 00 00 04 46 24 00 20 E5 D9 FF 07 15 04 00 29 25 08 00 E0 03 30 00 BD 27 21 40 C0 00 21 48 A0 03 30 00 CA 24 00 00 02 8D 04 00 03 8D 08 00 04 8D 0C 00 05 8D 10 00 08 25 00 00 22 AD 04 00 23 AD 08 00 24 AD 0C 00 25 AD F6 FF 0A 15 10 00 29 25 ?? ?? ?? 0? 21 50 A0 03 21 40 A0 03 30 00 C9 24 00 00 E2 8C 04 00 E3 8C 08 00 E4 8C 0C 00 E5 8C 10 00 E7 24 00 00 02 AD 04 00 03 AD 08 00 04 AD 0C 00 05 AD F6 FF E9 14 10 00 08 25 ?? ?? ?? 0? 21 38 A0 03 }
	condition:
		$1
}

rule file_18_15_0 {
	meta:
		name = "cross_product"
		size = 1456
		refs = "0548 allegro_errno 0458 .text"
	strings:
		$1 = { 19 00 25 01 E8 FF BD 27 0C 00 B0 AF C3 87 09 00 10 00 B1 AF C3 8F 05 00 14 00 B2 AF 21 78 80 00 10 68 00 00 12 60 00 00 18 00 05 02 1C 00 29 02 12 10 00 00 21 68 4D 00 00 80 02 34 2A 10 A2 01 7C 00 40 10 21 90 60 01 FF 7F 02 24 75 00 A2 11 FF FF 02 3C 00 80 A2 29 0D 01 40 10 00 80 02 24 19 00 06 01 C3 CF 08 00 C3 C7 06 00 ?? ?? 02 3C ?? ?? 43 8C 22 00 02 24 00 00 62 AC 10 68 00 00 12 60 00 00 18 00 26 03 1C 00 08 03 12 10 00 00 21 68 4D 00 00 80 02 34 2A 10 A2 01 78 00 40 14 00 80 0E 3C ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 44 34 19 00 E6 00 C3 5F 07 00 23 10 C4 01 00 00 42 AD 10 68 00 00 12 60 00 00 18 00 66 01 1C 00 07 03 12 10 00 00 21 68 4D 00 00 80 02 34 2A 10 A2 01 7E 00 40 10 ?? ?? 02 3C FF 7F 02 24 FD 00 A2 11 FF FF 02 3C 00 80 A2 29 E8 00 40 10 00 80 02 24 18 00 0F 02 C3 57 0F 00 ?? ?? 02 3C ?? ?? 43 8C 22 00 02 24 00 80 06 3C 00 00 62 AC 1C 00 49 01 12 10 00 00 19 00 2F 01 10 68 00 00 21 68 4D 00 00 80 02 34 2A 10 A2 01 78 00 40 14 12 60 00 00 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 49 34 18 00 2F 03 23 10 C9 00 00 00 42 AE 1C 00 48 01 12 10 00 00 19 00 0F 01 10 48 00 00 21 48 49 00 00 80 02 34 2A 10 22 01 7D 00 40 10 12 40 00 00 FF 7F 02 24 E1 00 22 11 FF FF 02 3C 00 80 22 29 A8 00 40 10 00 80 02 24 18 00 65 01 ?? ?? 02 3C ?? ?? 43 8C 22 00 02 24 00 80 08 3C 00 00 62 AC 1C 00 27 02 12 10 00 00 00 00 A2 AF 19 00 E5 00 10 28 00 00 21 28 45 00 00 80 02 34 2A 10 A2 00 78 00 40 14 12 20 00 00 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 44 34 18 00 A2 8F 23 18 04 01 14 00 B2 8F 10 00 B1 8F 0C 00 B0 8F 00 00 43 AC 08 00 E0 03 18 00 BD 27 01 00 42 34 2B 10 82 01 8A FF 40 14 00 80 A2 29 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 4E 34 19 00 06 01 C3 CF 08 00 C3 C7 06 00 10 68 00 00 12 60 00 00 18 00 26 03 1C 00 08 03 12 10 00 00 21 68 4D 00 00 80 02 34 2A 10 A2 01 8B FF 40 10 ?? ?? 02 3C FF 7F 02 24 A0 00 A2 11 FF FF 02 3C 00 80 A2 29 79 00 40 10 00 80 02 24 19 00 E6 00 C3 5F 07 00 ?? ?? 02 3C ?? ?? 43 8C 00 80 04 3C 22 00 02 24 00 00 62 AC 23 10 C4 01 00 00 42 AD 10 68 00 00 12 60 00 00 18 00 66 01 1C 00 07 03 12 10 00 00 21 68 4D 00 00 80 02 34 2A 10 A2 01 86 FF 40 14 FF 7F 02 24 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 46 34 18 00 0F 02 C3 57 0F 00 1C 00 49 01 12 10 00 00 19 00 2F 01 10 68 00 00 21 68 4D 00 00 80 02 34 2A 10 A2 01 8A FF 40 10 12 60 00 00 FF 7F 02 24 64 00 A2 11 FF FF 02 3C 00 80 A2 29 49 00 40 10 00 80 02 24 18 00 2F 03 ?? ?? 02 3C ?? ?? 43 8C 00 80 09 3C 22 00 02 24 00 00 62 AC 23 10 C9 00 00 00 42 AE 1C 00 48 01 12 10 00 00 19 00 0F 01 10 48 00 00 21 48 49 00 00 80 02 34 2A 10 22 01 85 FF 40 14 12 40 00 00 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 48 34 18 00 65 01 1C 00 27 02 12 10 00 00 00 00 A2 AF 19 00 E5 00 10 28 00 00 21 28 45 00 00 80 02 34 2A 10 A2 00 8A FF 40 10 12 20 00 00 FF 7F 02 24 42 00 A2 10 FF FF 02 3C 00 80 A2 28 0E 00 40 10 00 80 02 24 ?? ?? 02 3C ?? ?? 43 8C 22 00 02 24 00 80 04 3C 00 00 62 AC 18 00 A2 8F 23 18 04 01 14 00 B2 8F 10 00 B1 8F 0C 00 B0 8F 00 00 43 AC 08 00 E0 03 18 00 BD 27 48 00 A2 10 01 00 02 3C 02 1C 04 00 00 14 05 00 25 20 43 00 18 00 A2 8F 23 18 04 01 14 00 B2 8F 10 00 B1 8F 0C 00 B0 8F 00 00 43 AC 08 00 E0 03 18 00 BD 27 54 00 22 11 01 00 02 3C 02 1C 08 00 00 14 09 00 ?? ?? ?? 0? 25 40 43 00 49 00 A2 11 01 00 02 3C 02 1C 0C 00 00 14 0D 00 ?? ?? ?? 0? 25 48 43 00 3E 00 A2 11 01 00 02 3C 02 1C 0C 00 00 14 0D 00 ?? ?? ?? 0? 25 20 43 00 33 00 A2 11 01 00 02 3C 02 1C 0C 00 00 14 0D 00 ?? ?? ?? 0? 25 70 43 00 28 00 A2 11 01 00 02 3C 02 1C 0C 00 00 14 0D 00 ?? ?? ?? 0? 25 30 43 00 01 00 42 34 2B 10 82 01 9B FF 40 54 00 80 A2 29 ?? ?? ?? 0? ?? ?? 02 3C 01 00 42 34 2B 10 82 00 BD FF 40 54 00 80 A2 28 ?? ?? ?? 0? ?? ?? 02 3C 01 00 42 34 2B 10 82 01 02 FF 40 54 00 80 A2 29 ?? ?? ?? 0? ?? ?? 02 3C 01 00 42 34 2B 10 82 01 5F FF 40 54 00 80 A2 29 ?? ?? ?? 0? ?? ?? 02 3C 01 00 42 34 2B 10 02 01 1E FF 40 54 00 80 22 29 ?? ?? ?? 0? ?? ?? 02 3C 2B 10 82 00 B8 FF 40 10 02 1C 04 00 ?? ?? ?? 0? ?? ?? 02 3C 2B 10 82 01 D8 FF 40 10 02 1C 0C 00 ?? ?? ?? 0? 18 00 0F 02 2B 10 82 01 CD FF 40 10 02 1C 0C 00 ?? ?? ?? 0? 19 00 06 01 2B 10 82 01 C2 FF 40 10 02 1C 0C 00 ?? ?? ?? 0? 19 00 E6 00 2B 10 82 01 B7 FF 40 10 02 1C 0C 00 ?? ?? ?? 0? 18 00 2F 03 2B 10 02 01 AC FF 40 10 02 1C 08 00 ?? ?? ?? 0? 18 00 65 01 }
	condition:
		$1
}

rule file_18_16_0 {
	meta:
		name = "cross_product_f"
		size = 52
	strings:
		$1 = { 42 68 0F 46 02 60 10 46 C2 73 0F 46 02 63 11 46 42 6B 11 46 82 73 10 46 01 00 01 46 C1 7B 0C 46 41 6B 0E 46 00 00 8D E4 00 00 AF E4 08 00 E0 03 00 00 C0 E4 }
	condition:
		$1
}

rule file_18_17_0 {
	meta:
		name = "polygon_z_normal"
		size = 436
		refs = "01b0 allegro_errno 016c .text"
	strings:
		$1 = { 21 50 80 00 21 58 C0 00 04 00 A7 8C 00 00 A6 8C 04 00 64 8D 00 00 43 8D 00 80 02 34 23 20 87 00 23 18 C3 00 18 00 83 00 10 48 00 00 2A 10 22 01 24 00 40 10 12 40 00 00 FF 7F 02 24 1D 00 22 11 FF FF 02 3C 00 80 22 29 44 00 40 10 00 80 02 24 ?? ?? 02 3C ?? ?? 43 8C 22 00 02 24 00 80 08 3C 00 00 62 AC 04 00 A7 8C 00 00 A6 8C 04 00 44 8D 00 00 63 8D 00 80 02 34 23 20 E4 00 23 18 66 00 18 00 83 00 10 28 00 00 2A 10 A2 00 1F 00 40 14 12 20 00 00 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 44 34 08 00 E0 03 23 10 04 01 01 00 42 34 2B 10 02 01 E2 FF 40 14 00 80 22 29 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC 04 00 A7 8C 00 00 A6 8C FF FF 48 34 04 00 44 8D 00 00 63 8D 00 80 02 34 23 20 E4 00 23 18 66 00 18 00 83 00 10 28 00 00 2A 10 A2 00 E3 FF 40 10 12 20 00 00 FF 7F 02 24 18 00 A2 10 FF FF 02 3C 00 80 A2 28 08 00 40 50 00 80 02 24 ?? ?? 02 3C ?? ?? 43 8C 00 80 04 3C 22 00 02 24 00 00 62 AC 08 00 E0 03 23 10 04 01 12 00 A2 50 01 00 02 3C 00 14 05 00 02 1C 04 00 25 20 43 00 08 00 E0 03 23 10 04 01 10 00 22 11 01 00 02 3C 02 1C 08 00 00 14 09 00 ?? ?? ?? 0? 25 40 43 00 01 00 42 34 2B 10 82 00 E7 FF 40 54 00 80 A2 28 ?? ?? ?? 0? ?? ?? 02 3C 2B 10 82 00 EE FF 40 50 00 14 05 00 ?? ?? ?? 0? ?? ?? 02 3C 2B 10 02 01 F0 FF 40 10 02 1C 08 00 ?? ?? ?? 0? ?? ?? 02 3C }
	condition:
		$1
}

rule file_18_18_0 {
	meta:
		name = "polygon_z_normal_f"
		size = 56
	strings:
		$1 = { 04 00 A5 C4 00 00 A0 C4 00 00 C2 C4 04 00 83 C4 00 00 84 C4 04 00 C1 C4 81 10 00 46 C1 28 03 46 01 00 04 46 41 08 05 46 82 10 03 46 02 00 01 46 08 00 E0 03 01 00 02 46 }
	condition:
		$1
}

rule file_18_19_0 {
	meta:
		name = "set_projection_viewport"
		size = 184
		refs = "0038 _persp_yscale 0044 _persp_yscale_f 0064 _persp_yoffset 0070 _persp_yoffset_f 0088 _persp_xscale 0084 _persp_xoffset 00a0 _persp_xscale_f 00a4 _persp_xoffset_f"
	strings:
		$1 = { 02 00 02 24 02 00 40 14 1A 00 E2 00 CD 01 00 00 F0 FF BD 27 12 18 00 00 0C 00 A3 AF 02 00 40 14 1A 00 C2 00 CD 01 00 00 0C 00 A2 8F 00 08 82 44 21 28 45 00 00 3C 02 00 ?? ?? 02 3C 20 08 80 46 ?? ?? 47 AC ?? ?? 02 3C ?? ?? 40 E4 00 10 85 44 00 2C 05 00 60 10 80 46 12 18 00 00 08 00 A3 AF 08 00 A2 8F ?? ?? 03 3C ?? ?? 65 AC 21 20 44 00 ?? ?? 03 3C ?? ?? 61 E4 00 10 84 44 00 08 82 44 00 34 02 00 ?? ?? 03 3C ?? ?? 02 3C 00 24 04 00 20 08 80 46 ?? ?? 46 AC 60 10 80 46 ?? ?? 64 AC ?? ?? 02 3C ?? ?? 03 3C ?? ?? 40 E4 ?? ?? 61 E4 08 00 E0 03 10 00 BD 27 }
	condition:
		$1
}

rule file_18_20_0 {
	meta:
		name = "vector_length_f"
		size = 68
		refs = "0018 __extendsfdf2 0024 sqrt 0030 __truncdfsf2"
	strings:
		$1 = { 42 6B 0D 46 02 63 0C 46 82 73 0E 46 F8 FF BD 27 04 00 BF AF 00 63 0D 46 ?? ?? ?? 0? 00 63 0E 46 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 04 00 BF 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_18_21_0 {
	meta:
		name = "normalize_vector_f"
		size = 120
		refs = "0028 vector_length_f 0030 $LC0"
	strings:
		$1 = { 00 00 8C C4 00 00 AD C4 00 00 CE C4 F0 FF BD 27 0C 00 BF AF 08 00 B2 AF 04 00 B1 AF 21 90 C0 00 21 88 A0 00 00 00 B0 AF ?? ?? ?? 0? 21 80 80 00 ?? ?? 02 3C ?? ?? 42 C4 00 00 01 C6 0C 00 BF 8F 83 10 00 46 42 08 02 46 00 00 01 E6 00 00 20 C6 00 00 B0 8F 02 00 02 46 00 00 20 E6 00 00 41 C6 04 00 B1 8F 42 08 02 46 00 00 41 E6 08 00 B2 8F 08 00 E0 03 10 00 BD 27 }
	condition:
		$1
}

rule file_18_22_0 {
	meta:
		name = "get_align_matrix_f"
		size = 344
		refs = "007c normalize_vector_f"
	strings:
		$1 = { C0 FF BD 27 18 00 AE E7 18 00 A3 8F 00 80 02 3C 10 00 AC E7 26 18 62 00 24 00 A3 AF 10 00 A3 8F 14 00 AD E7 28 00 B0 AF 26 18 62 00 1C 00 A3 AF 14 00 A3 8F 21 80 80 00 14 00 A5 27 26 18 62 00 1C 00 A2 8F 20 00 A3 AF 10 00 A4 27 10 00 A2 AF 20 00 A2 8F 18 00 A6 27 2C 00 BF AF 14 00 A2 AF 24 00 A2 8F 3C 00 B6 E7 38 00 B5 E7 86 8D 00 46 46 85 00 46 34 00 B4 E7 18 00 A2 AF ?? ?? ?? 0? 06 7D 00 46 10 00 A1 C7 14 00 A2 C7 18 00 A0 C7 02 09 15 46 C2 10 14 46 42 08 16 46 82 10 16 46 02 05 14 46 02 00 15 46 21 20 A0 03 04 00 A5 27 C1 18 04 46 08 00 A6 27 41 08 14 46 01 00 02 46 08 00 A3 E7 04 00 A1 E7 ?? ?? ?? 0? 00 00 A0 E7 10 00 A7 C7 14 00 A8 C7 18 00 A1 C7 00 00 A5 C7 04 00 A6 C7 08 00 A0 C7 C2 42 05 46 82 38 06 46 C2 40 00 46 42 0A 06 46 02 09 05 46 82 3A 00 46 2C 00 BF 8F 18 00 00 E6 81 10 0B 46 20 00 01 E6 C1 18 09 46 24 00 00 AE 01 21 0A 46 00 00 05 E6 1C 00 02 E6 04 00 03 E6 08 00 07 E6 10 00 04 E6 0C 00 06 E6 14 00 08 E6 2C 00 00 AE 28 00 00 AE 3C 00 B6 C7 28 00 B0 8F 38 00 B5 C7 34 00 B4 C7 08 00 E0 03 40 00 BD 27 }
	condition:
		$1
}

rule file_18_23_0 {
	meta:
		name = "vector_length"
		size = 728
		refs = "02d4 allegro_errno 010c fixsqrt 024c .text"
	strings:
		$1 = { C3 1F 04 00 03 22 04 00 18 00 64 00 00 80 02 34 F8 FF BD 27 04 00 BF AF 12 18 00 00 40 18 03 00 19 00 84 00 10 48 00 00 21 48 69 00 2A 10 22 01 40 00 40 10 12 40 00 00 FF 7F 02 24 39 00 22 11 FF FF 02 3C 00 80 22 29 82 00 40 10 00 80 02 24 ?? ?? 02 3C ?? ?? 43 8C 22 00 02 24 00 80 0A 3C 00 00 62 AC 03 1A 05 00 C3 17 05 00 18 00 43 00 12 10 00 00 40 10 02 00 19 00 63 00 00 80 03 34 10 48 00 00 21 48 49 00 2A 18 23 01 3B 00 60 14 12 40 00 00 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 45 34 03 1A 06 00 C3 17 06 00 18 00 43 00 12 10 00 00 40 10 02 00 19 00 63 00 00 80 03 34 10 38 00 00 21 38 47 00 2A 18 E3 00 40 00 60 10 12 30 00 00 FF 7F 02 24 62 00 E2 10 FF FF 02 3C 00 80 E2 28 47 00 40 10 00 80 02 24 ?? ?? 02 3C ?? ?? 43 8C 00 80 06 3C 22 00 02 24 21 20 AA 00 00 00 62 AC ?? ?? ?? 0? 21 20 86 00 04 00 BF 8F 00 12 02 00 08 00 E0 03 08 00 BD 27 01 00 42 34 2B 10 02 01 C6 FF 40 14 00 80 22 29 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 4A 34 03 1A 05 00 C3 17 05 00 18 00 43 00 12 10 00 00 40 10 02 00 19 00 63 00 00 80 03 34 10 48 00 00 21 48 49 00 2A 18 23 01 C7 FF 60 10 12 40 00 00 FF 7F 02 24 40 00 22 11 FF FF 02 3C 00 80 22 29 2B 00 40 10 00 80 02 24 ?? ?? 02 3C ?? ?? 43 8C 22 00 02 24 00 80 05 3C 00 00 62 AC 03 1A 06 00 C3 17 06 00 18 00 43 00 12 10 00 00 40 10 02 00 19 00 63 00 00 80 03 34 10 38 00 00 21 38 47 00 2A 18 E3 00 C2 FF 60 14 12 30 00 00 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 46 34 21 20 AA 00 ?? ?? ?? 0? 21 20 86 00 04 00 BF 8F 00 12 02 00 08 00 E0 03 08 00 BD 27 23 00 E2 10 01 00 02 3C 02 1C 06 00 00 14 07 00 25 30 43 00 21 20 AA 00 ?? ?? ?? 0? 21 20 86 00 04 00 BF 8F 00 12 02 00 08 00 E0 03 08 00 BD 27 21 00 22 11 01 00 02 3C 02 1C 08 00 00 14 09 00 ?? ?? ?? 0? 25 28 43 00 16 00 22 11 01 00 02 3C 02 1C 08 00 00 14 09 00 ?? ?? ?? 0? 25 50 43 00 01 00 42 34 2B 10 C2 00 9D FF 40 54 00 80 E2 28 ?? ?? ?? 0? ?? ?? 02 3C 01 00 42 34 2B 10 02 01 BF FF 40 54 00 80 22 29 ?? ?? ?? 0? ?? ?? 02 3C 2B 10 C2 00 DD FF 40 10 02 1C 06 00 ?? ?? ?? 0? ?? ?? 02 3C 2B 10 02 01 EA FF 40 10 02 1C 08 00 ?? ?? ?? 0? ?? ?? 02 3C 2B 10 02 01 DF FF 40 10 02 1C 08 00 ?? ?? ?? 0? ?? ?? 02 3C }
	condition:
		$1
}

rule file_18_24_0 {
	meta:
		name = "normalize_vector"
		size = 1264
		refs = "0040 vector_length 0050 allegro_errno 00e0 __floatsidf 00e8 $LC1 00f8 __muldf3 0134 __divdf3 0140 $LC2 0154 __gtdf2 0254 $LC3 0264 __ltdf2 0288 $LC4 0294 $LC6 02b8 __adddf3 02c4 __fixdfsi 037c .text 04c0 $LC5"
	strings:
		$1 = { D0 FF BD 27 28 00 BE AF 10 00 B2 AF 00 00 A6 AF 21 90 80 00 21 F0 A0 00 00 00 84 8C 00 00 A5 8C 00 00 C6 8C 08 00 B0 AF 2C 00 BF AF 24 00 B7 AF 20 00 B6 AF 1C 00 B5 AF 18 00 B4 AF 14 00 B3 AF ?? ?? ?? 0? 0C 00 B1 AF 25 00 40 14 00 00 50 8E ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 02 01 00 06 00 00 83 AC FF 7F 02 3C FF FF 42 34 00 00 42 AE 00 00 C3 8F 22 00 02 24 02 01 60 04 00 00 82 AC FF 7F 02 3C FF FF 42 34 00 00 C2 AF 00 00 A2 8F 00 00 43 8C 22 00 02 24 BE 00 60 04 00 00 82 AC 00 00 A3 8F 2C 00 BF 8F FF 7F 02 3C FF FF 42 34 28 00 BE 8F 24 00 B7 8F 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 00 00 62 AC 08 00 E0 03 30 00 BD 27 ?? ?? ?? 0? 21 20 40 00 ?? ?? 04 3C ?? ?? 86 8C ?? ?? 87 8C 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 21 20 00 02 21 A0 40 00 ?? ?? ?? 0? 21 A8 60 00 21 20 40 00 ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C ?? ?? ?? 0? 21 28 60 00 21 20 40 00 21 28 60 00 21 30 80 02 ?? ?? ?? 0? 21 38 A0 02 21 88 60 00 ?? ?? 03 3C ?? ?? 66 8C ?? ?? 67 8C 21 80 40 00 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 69 00 40 18 ?? ?? 02 3C ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 42 34 00 00 42 AE ?? ?? ?? 0? 00 00 C4 8F 21 20 40 00 ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C ?? ?? ?? 0? 21 28 60 00 21 20 40 00 21 28 60 00 21 30 80 02 ?? ?? ?? 0? 21 38 A0 02 21 88 60 00 21 28 60 00 ?? ?? 03 3C ?? ?? 66 8C ?? ?? 67 8C 21 20 40 00 ?? ?? ?? 0? 21 80 40 00 7F 00 40 18 ?? ?? 02 3C ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 42 34 00 00 C2 AF 00 00 A2 8F ?? ?? ?? 0? 00 00 44 8C 21 28 60 00 ?? ?? 03 3C ?? ?? 66 8C ?? ?? 67 8C ?? ?? ?? 0? 21 20 40 00 21 20 40 00 21 28 60 00 21 30 80 02 ?? ?? ?? 0? 21 38 A0 02 21 80 40 00 21 20 40 00 ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 28 60 00 ?? ?? ?? 0? 21 88 60 00 80 00 40 1C ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 45 00 40 04 21 20 00 02 21 28 20 02 21 30 00 00 ?? ?? ?? 0? 21 38 00 00 8E 00 40 04 ?? ?? 02 3C ?? ?? 54 8C ?? ?? 55 8C ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 21 20 40 00 21 30 80 02 21 38 A0 02 ?? ?? ?? 0? 21 28 60 00 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 00 00 A3 8F 2C 00 BF 8F 28 00 BE 8F 24 00 B7 8F 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 00 00 62 AC 08 00 E0 03 30 00 BD 27 ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 5D 00 40 04 ?? ?? 02 3C 21 20 00 02 21 28 20 02 21 30 00 00 ?? ?? ?? 0? 21 38 00 00 6A 00 40 04 ?? ?? 02 3C ?? ?? 56 8C ?? ?? 57 8C ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 21 20 40 00 21 28 60 00 21 30 C0 02 ?? ?? ?? 0? 21 38 E0 02 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 ?? ?? ?? 0? 00 00 42 AE ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 00 00 83 AC 00 00 A3 8F 2C 00 BF 8F 00 80 02 3C 01 00 42 34 28 00 BE 8F 24 00 B7 8F 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 00 00 62 AC 08 00 E0 03 30 00 BD 27 ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 2F 00 40 04 ?? ?? 02 3C 21 20 00 02 21 28 20 02 21 30 00 00 ?? ?? ?? 0? 21 38 00 00 32 00 40 04 ?? ?? 02 3C ?? ?? 52 8C ?? ?? 53 8C ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 21 20 40 00 21 28 60 00 21 30 40 02 ?? ?? ?? 0? 21 38 60 02 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 ?? ?? ?? 0? 00 00 C2 AF ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 ?? ?? ?? 0? 00 00 83 AC 00 80 02 3C 01 00 42 34 00 00 42 AE 00 00 C3 8F 22 00 02 24 00 FF 61 04 00 00 82 AC 00 80 02 3C ?? ?? ?? 0? 01 00 42 34 ?? ?? 44 8C 22 00 03 24 00 80 02 3C 00 00 83 AC ?? ?? ?? 0? 01 00 42 34 ?? ?? 44 8C 22 00 03 24 00 80 02 3C 00 00 83 AC ?? ?? ?? 0? 01 00 42 34 ?? ?? 02 3C ?? ?? 54 8C ?? ?? ?? 0? ?? ?? 55 8C ?? ?? 02 3C ?? ?? 52 8C ?? ?? ?? 0? ?? ?? 53 8C ?? ?? 02 3C ?? ?? 56 8C ?? ?? ?? 0? ?? ?? 57 8C }
	condition:
		$1
}

rule file_18_25_0 {
	meta:
		name = "get_align_matrix"
		size = 304
		refs = "0048 normalize_vector 007c cross_product"
	strings:
		$1 = { B8 FF BD 27 23 18 06 00 23 10 05 00 34 00 B0 AF 23 38 07 00 21 80 80 00 1C 00 A5 27 18 00 A4 27 20 00 A6 27 44 00 BF AF 1C 00 A3 AF 18 00 A2 AF 40 00 B3 AF 3C 00 B2 AF 38 00 B1 AF 24 00 A8 AF 28 00 A9 AF 2C 00 AA AF ?? ?? ?? 0? 20 00 A7 AF 18 00 A7 8F 1C 00 A8 8F 20 00 A9 8F 24 00 A4 8F 28 00 A5 8F 2C 00 A6 8F 0C 00 B3 27 08 00 B2 27 21 50 40 02 21 58 60 02 10 00 B1 27 ?? ?? ?? 0? 00 00 B1 AF 21 20 40 02 21 28 60 02 ?? ?? ?? 0? 21 30 20 02 18 00 A4 8F 1C 00 A5 8F 20 00 A6 8F 08 00 A7 8F 0C 00 A8 8F 10 00 A9 8F 2C 00 A2 27 24 00 AA 27 28 00 AB 27 ?? ?? ?? 0? 00 00 A2 AF 08 00 A2 8F 44 00 BF 8F 40 00 B3 8F 00 00 02 AE 24 00 A3 8F 3C 00 B2 8F 38 00 B1 8F 04 00 03 AE 18 00 A2 8F 08 00 02 AE 0C 00 A3 8F 0C 00 03 AE 28 00 A2 8F 10 00 02 AE 1C 00 A3 8F 14 00 03 AE 10 00 A2 8F 18 00 02 AE 2C 00 A3 8F 1C 00 03 AE 20 00 A2 8F 24 00 00 AE 2C 00 00 AE 20 00 02 AE 28 00 00 AE 34 00 B0 8F 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_18_26_0 {
	meta:
		name = "get_camera_matrix_f"
		size = 744
		refs = "0048 normalize_vector_f 0154 $LC7 01e0 __extendsfdf2 01e8 $LC8 01f8 __adddf3 0200 $LC9 0210 __muldf3 0218 $LC10 0234 tan 0240 __truncdfsf2 0248 identity_matrix_f 02a4 $LC11 02c0 matrix_mul_f"
	strings:
		$1 = { 40 FF BD 27 A8 00 B1 AF 64 00 A5 27 68 00 A6 27 21 88 80 00 60 00 A4 27 AC 00 BF AF 64 00 B0 E7 68 00 B1 E7 6C 00 B2 E7 70 00 B3 E7 60 00 AF E7 A4 00 B0 AF BC 00 B6 E7 B8 00 B5 E7 86 65 00 46 46 75 00 46 B4 00 B4 E7 ?? ?? ?? 0? 06 6D 00 46 60 00 A2 8F 64 00 A3 8F 00 80 10 3C 26 10 50 00 26 18 70 00 7C 00 A2 AF 78 00 A3 AF 68 00 A2 8F 6C 00 A2 C7 70 00 A3 C7 78 00 A6 C7 7C 00 A1 C7 26 10 50 00 42 31 03 46 02 08 02 46 74 00 A2 AF 74 00 A7 C7 C0 00 A1 C7 64 00 A6 E7 68 00 A7 E7 02 39 01 46 00 00 05 46 7C 00 A5 C7 6C 00 A4 27 70 00 A5 27 60 00 A5 E7 C0 00 A6 27 00 00 04 46 02 39 00 46 7C 00 A7 C7 82 39 00 46 78 00 A7 C7 41 08 04 46 42 39 00 46 81 10 06 46 C0 00 A1 E7 C1 18 05 46 6C 00 A2 E7 ?? ?? ?? 0? 70 00 A3 E7 6C 00 A6 C7 70 00 A7 C7 C0 00 A8 C7 60 00 A9 C7 64 00 AA C7 68 00 AB C7 02 39 09 46 42 41 0A 46 02 30 0B 46 C2 40 09 46 42 38 0B 46 82 30 0A 46 82 33 16 46 02 53 14 46 42 5B 15 46 C2 4B 16 46 C1 18 00 46 41 08 05 46 81 10 04 46 42 39 14 46 02 A5 03 46 02 B0 01 46 02 A9 02 46 42 45 15 46 C0 7B 0C 46 ?? ?? 02 3C 80 73 05 46 C4 00 AC C7 40 01 14 46 ?? ?? 40 C4 40 75 15 46 40 7B 0D 46 00 29 04 46 02 63 00 46 88 00 B5 E7 88 00 A2 8F 80 00 A4 E7 90 00 AD E7 26 10 50 00 8C 00 A2 AF 80 00 A2 8F 08 00 A2 E7 00 00 A1 E7 26 10 50 00 84 00 A2 AF 90 00 A2 8F 04 00 A3 E7 0C 00 A6 E7 26 80 50 00 84 00 A2 8F 94 00 B0 AF 10 00 A7 E7 24 00 A2 AF 8C 00 A2 8F 14 00 A8 E7 18 00 A9 E7 28 00 A2 AF 94 00 A2 8F 1C 00 AA E7 20 00 AB E7 ?? ?? ?? 0? 2C 00 A2 AF ?? ?? 04 3C ?? ?? 86 8C ?? ?? 87 8C 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 ?? ?? 04 3C ?? ?? 86 8C ?? ?? 87 8C 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 ?? ?? 04 3C ?? ?? 86 8C ?? ?? 87 8C 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 ?? ?? 02 3C ?? ?? 46 24 30 00 A9 27 86 00 00 46 21 38 20 01 30 00 C8 24 00 00 C2 8C 04 00 C3 8C 08 00 C4 8C 0C 00 C5 8C 10 00 C6 24 00 00 E2 AC 04 00 E3 AC 08 00 E4 AC 0C 00 E5 AC F6 FF C8 14 10 00 E7 24 C8 00 A3 8F 00 80 02 3C 21 30 20 02 26 10 62 00 98 00 A2 AF 98 00 A5 C7 ?? ?? 02 3C ?? ?? 40 C4 42 28 02 46 21 20 A0 03 21 28 20 01 50 00 A0 E7 30 00 A2 E7 ?? ?? ?? 0? 40 00 A1 E7 AC 00 BF 8F A8 00 B1 8F A4 00 B0 8F BC 00 B6 C7 B8 00 B5 C7 B4 00 B4 C7 08 00 E0 03 C0 00 BD 27 }
	condition:
		$1
}

rule file_18_27_0 {
	meta:
		name = "get_camera_matrix"
		size = 1424
		refs = "006c __floatsidf 0074 $LC1 0080 __muldf3 008c __truncdfsf2 0284 get_camera_matrix_f 0290 $LC2 02a0 $LC3 02b0 $LC6 02c0 $LC5 02d0 $LC4 02d4 allegro_errno 035c __extendsfdf2 0378 __gtdf2 0474 __ltdf2 049c .text 04dc __adddf3 04e8 __fixdfsi"
	strings:
		$1 = { 18 FF BD 27 A0 00 B0 AF 48 00 A4 AF ?? ?? 10 3C 21 20 A0 00 C4 00 BF AF C0 00 BE AF BC 00 B7 AF B8 00 B6 AF B4 00 B5 AF 21 B0 60 01 21 A8 40 01 B0 00 B4 AF AC 00 B3 AF 21 A0 20 01 21 98 00 01 A8 00 B2 AF A4 00 B1 AF 21 90 E0 00 21 88 C0 00 E4 00 BB E7 E0 00 BA E7 DC 00 B9 E7 D8 00 B8 E7 D4 00 B7 E7 D0 00 B6 E7 CC 00 B5 E7 ?? ?? ?? 0? C8 00 B4 E7 ?? ?? 06 8E ?? ?? 07 8E 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 20 02 ?? ?? ?? 0? C6 06 00 46 ?? ?? 06 8E ?? ?? 07 8E 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 40 02 ?? ?? ?? 0? 86 06 00 46 ?? ?? 06 8E ?? ?? 07 8E 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 60 02 ?? ?? ?? 0? 46 06 00 46 21 20 40 00 ?? ?? 06 8E ?? ?? 07 8E 48 00 A2 8F 21 28 60 00 34 00 A3 27 44 00 A2 AF ?? ?? ?? 0? 40 00 A3 AF 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 80 02 ?? ?? ?? 0? 06 06 00 46 ?? ?? 06 8E ?? ?? 07 8E 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 A0 02 ?? ?? ?? 0? C6 05 00 46 ?? ?? 06 8E ?? ?? 07 8E 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 C0 02 ?? ?? ?? 0? 86 05 00 46 ?? ?? 06 8E ?? ?? 07 8E 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 E8 00 A4 8F 46 05 00 46 ?? ?? ?? 0? 21 F0 00 00 ?? ?? 06 8E ?? ?? 07 8E 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 EC 00 A4 8F ?? ?? ?? 0? 06 05 00 46 ?? ?? 06 8E ?? ?? 07 8E 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 F0 00 A4 8F ?? ?? ?? 0? 00 00 A0 E7 ?? ?? 06 8E ?? ?? 07 8E 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 F4 00 A4 8F ?? ?? ?? 0? 04 00 A0 E7 ?? ?? 06 8E ?? ?? 07 8E 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 06 DB 00 46 46 D3 00 46 86 CB 00 46 C6 C3 00 46 06 BC 00 46 46 B4 00 46 86 AC 00 46 C6 A4 00 46 10 00 A4 27 ?? ?? ?? 0? 08 00 A0 E7 ?? ?? 02 3C ?? ?? 47 8C ?? ?? 03 3C ?? ?? 04 3C 50 00 A7 AF ?? ?? 67 8C ?? ?? 05 3C ?? ?? 42 8C 58 00 A7 AF ?? ?? 87 8C ?? ?? 63 8C ?? ?? 06 3C 60 00 A7 AF ?? ?? A7 8C 4C 00 A2 AF 54 00 A3 AF 68 00 A7 AF ?? ?? C7 8C ?? ?? 02 3C 50 00 A3 8F 70 00 A7 AF ?? ?? 57 8C 54 00 A7 8F 4C 00 A2 8F ?? ?? 84 8C ?? ?? A5 8C ?? ?? C6 8C 74 00 A2 AF 78 00 A3 AF 58 00 A2 8F 7C 00 A7 AF 60 00 A3 8F 68 00 A7 8F 80 00 A2 AF 5C 00 A4 AF 64 00 A5 AF 6C 00 A6 AF 84 00 A4 AF 88 00 A3 AF 8C 00 A5 AF 90 00 A7 AF 70 00 A2 8F 94 00 A6 AF 98 00 A2 AF 0C 00 02 24 18 00 C2 03 48 00 A3 8F 10 00 A7 27 21 A0 00 00 12 10 00 00 21 98 62 00 21 90 E2 00 ?? ?? ?? 0? 00 00 4C C6 4C 00 A6 8F 50 00 A7 8F 21 20 40 00 21 28 60 00 21 80 40 00 ?? ?? ?? 0? 21 88 60 00 54 00 A6 8F 58 00 A7 8F 21 20 00 02 39 00 40 18 21 28 20 02 22 00 03 24 FF 7F 02 3C 00 00 E3 AE FF FF 42 34 00 00 62 AE 01 00 94 26 03 00 02 24 04 00 52 26 E9 FF 82 16 04 00 73 26 40 00 A3 8F ?? ?? ?? 0? 00 00 6C C4 74 00 A6 8F 78 00 A7 8F 21 20 40 00 21 28 60 00 21 80 40 00 ?? ?? ?? 0? 21 88 60 00 44 00 40 18 7C 00 A6 8F 22 00 07 24 FF 7F 02 3C 00 00 E7 AE FF FF 42 34 44 00 A3 8F 40 00 A7 8F 01 00 DE 27 24 00 62 AC 04 00 E7 24 04 00 63 24 03 00 02 24 40 00 A7 AF C7 FF C2 17 44 00 A3 AF C4 00 BF 8F C0 00 BE 8F BC 00 B7 8F B8 00 B6 8F B4 00 B5 8F B0 00 B4 8F AC 00 B3 8F A8 00 B2 8F A4 00 B1 8F A0 00 B0 8F E4 00 BB C7 E0 00 BA C7 DC 00 B9 C7 D8 00 B8 C7 D4 00 B7 C7 D0 00 B6 C7 CC 00 B5 C7 C8 00 B4 C7 08 00 E0 03 E8 00 BD 27 ?? ?? ?? 0? 00 00 00 00 21 20 00 02 21 28 20 02 21 30 00 00 06 00 41 04 21 38 00 00 22 00 07 24 00 80 02 3C 00 00 E7 AE ?? ?? ?? 0? 01 00 42 34 ?? ?? ?? 0? 00 00 00 00 34 00 40 04 64 00 B6 8F 6C 00 B6 8F 70 00 B5 8F 5C 00 A6 8F 60 00 A7 8F 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 21 20 40 00 21 28 60 00 21 30 C0 02 ?? ?? ?? 0? 21 38 A0 02 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 ?? ?? ?? 0? 00 00 62 AE 80 00 A7 8F 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 06 00 41 04 21 20 00 02 22 00 02 24 00 00 E2 AE 00 80 02 3C ?? ?? ?? 0? 01 00 42 34 21 28 20 02 21 30 00 00 ?? ?? ?? 0? 21 38 00 00 14 00 40 04 8C 00 B3 8F 94 00 B3 8F 98 00 B2 8F 84 00 A6 8F 88 00 A7 8F 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 21 20 40 00 21 28 60 00 21 30 60 02 ?? ?? ?? 0? 21 38 40 02 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 ?? ?? ?? 0? 44 00 A3 8F ?? ?? ?? 0? 68 00 B5 8F ?? ?? ?? 0? 90 00 B2 8F }
	condition:
		$1
}

rule file_18_28_0 {
	meta:
		name = "get_transformation_matrix_f"
		size = 680
		refs = "0060 __extendsfdf2 0068 $LC9 0078 __muldf3 0080 $LC10 00a0 cos 00ac __truncdfsf2 00bc sin"
	strings:
		$1 = { B8 FF BD 27 30 00 B7 E7 C6 65 00 46 06 6B 00 46 18 00 B4 AF ?? ?? 14 3C 1C 00 BF AF 14 00 B3 AF 10 00 B2 AF 0C 00 B1 AF 21 90 80 00 08 00 B0 AF 44 00 BC E7 40 00 BB E7 06 8F 00 46 C6 86 00 46 3C 00 BA E7 38 00 B9 E7 86 96 00 46 46 7E 00 46 34 00 B8 E7 2C 00 B6 E7 28 00 B5 E7 24 00 B4 E7 ?? ?? ?? 0? 06 75 00 46 ?? ?? 86 8E ?? ?? 87 8E ?? ?? 13 3C 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 ?? ?? 66 8E ?? ?? 67 8E 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 40 00 21 28 60 00 21 80 40 00 ?? ?? ?? 0? 21 88 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 00 02 21 28 20 02 ?? ?? ?? 0? 86 05 00 46 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 06 A3 00 46 ?? ?? ?? 0? 46 05 00 46 ?? ?? 86 8E ?? ?? 87 8E 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 ?? ?? 66 8E ?? ?? 67 8E 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 40 00 21 28 60 00 21 80 40 00 ?? ?? ?? 0? 21 88 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 00 02 21 28 20 02 ?? ?? ?? 0? 06 06 00 46 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 06 CB 00 46 ?? ?? ?? 0? 00 00 A0 E7 ?? ?? 86 8E ?? ?? 87 8E 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 ?? ?? 66 8E ?? ?? 67 8E 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 40 00 21 28 60 00 21 80 40 00 ?? ?? ?? 0? 21 88 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 00 02 21 28 20 02 ?? ?? ?? 0? 06 05 00 46 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 00 00 A2 C7 42 B1 14 46 82 A9 00 46 42 A8 02 46 82 B0 02 46 C2 A9 14 46 02 B2 00 46 00 00 A3 8F 82 B5 18 46 42 AD 18 46 C2 08 00 46 02 11 00 46 42 08 14 46 82 10 14 46 02 C0 00 46 02 C5 14 46 00 80 02 3C C0 18 05 46 01 21 07 46 41 08 08 46 80 10 06 46 26 18 62 00 04 00 A3 AF 04 00 A6 C7 82 B5 17 46 02 A5 17 46 42 AD 17 46 02 00 17 46 42 31 17 46 42 08 17 46 C2 18 17 46 82 10 17 46 02 21 17 46 1C 00 BF 8F 00 00 54 E6 14 00 55 E6 2C 00 5A E6 20 00 56 E6 24 00 5B E6 28 00 5C E6 04 00 40 E6 08 00 45 E6 0C 00 41 E6 10 00 43 E6 18 00 42 E6 1C 00 44 E6 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 44 00 BC C7 40 00 BB C7 3C 00 BA C7 38 00 B9 C7 34 00 B8 C7 30 00 B7 C7 2C 00 B6 C7 28 00 B5 C7 24 00 B4 C7 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_18_29_0 {
	meta:
		name = "get_vector_rotation_matrix_f"
		size = 380
		refs = "0030 __extendsfdf2 0038 $LC9 0048 __muldf3 0050 $LC10 0074 cos 0080 __truncdfsf2 0090 sin 00a4 $LC0 00bc normalize_vector_f"
	strings:
		$1 = { D0 FF BD 27 00 00 AC E7 06 7B 00 46 1C 00 BF AF 04 00 AD E7 08 00 AE E7 18 00 B2 AF 14 00 B1 AF 21 90 80 00 10 00 B0 AF 2C 00 B6 E7 28 00 B5 E7 ?? ?? ?? 0? 24 00 B4 E7 ?? ?? 04 3C ?? ?? 86 8C ?? ?? 87 8C 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 ?? ?? 04 3C ?? ?? 86 8C ?? ?? 87 8C 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 21 20 40 00 21 28 60 00 21 80 40 00 ?? ?? ?? 0? 21 88 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 00 02 21 28 20 02 ?? ?? ?? 0? 86 05 00 46 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 ?? ?? 02 3C ?? ?? 54 C4 21 20 A0 03 04 00 A5 27 01 A5 16 46 08 00 A6 27 ?? ?? ?? 0? 46 05 00 46 04 00 A1 C7 08 00 A0 C7 00 00 A2 C7 C2 A1 01 46 02 A1 00 46 02 A5 02 46 02 AA 02 46 42 02 15 46 42 AD 01 46 1C 00 BF 8F 42 01 07 46 82 01 04 46 C2 A0 01 46 02 A0 00 46 02 09 04 46 82 10 14 46 42 08 07 46 41 29 08 46 80 31 16 46 C1 19 09 46 80 02 15 46 00 21 08 46 80 10 16 46 40 08 16 46 01 00 15 46 C0 18 09 46 24 00 40 AE 00 00 42 E6 0C 00 47 E6 04 00 43 E6 08 00 40 E6 10 00 41 E6 14 00 44 E6 18 00 4A E6 1C 00 45 E6 20 00 46 E6 2C 00 40 AE 28 00 40 AE 14 00 B1 8F 18 00 B2 8F 10 00 B0 8F 2C 00 B6 C7 28 00 B5 C7 24 00 B4 C7 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_18_30_0 {
	meta:
		name = "get_vector_rotation_matrix"
		size = 700
		refs = "004c __floatsidf 0054 $LC1 0060 __muldf3 006c __truncdfsf2 0108 get_vector_rotation_matrix_f 011c $LC4 0118 allegro_errno 0128 $LC5 0160 __extendsfdf2 0170 $LC2 0184 __gtdf2 018c $LC3 0228 __ltdf2 0250 .text 0270 $LC6 0298 __adddf3 02a4 __fixdfsi"
	strings:
		$1 = { 80 FF BD 27 48 00 B0 AF 30 00 A4 AF ?? ?? 10 3C 21 20 A0 00 6C 00 BF AF 68 00 BE AF 64 00 B7 AF 54 00 B3 AF 50 00 B2 AF 21 98 00 01 21 90 E0 00 4C 00 B1 AF 7C 00 B6 E7 21 88 C0 00 78 00 B5 E7 74 00 B4 E7 60 00 B6 AF 5C 00 B5 AF ?? ?? ?? 0? 58 00 B4 AF ?? ?? 06 8E ?? ?? 07 8E 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 20 02 ?? ?? ?? 0? 86 05 00 46 ?? ?? 06 8E ?? ?? 07 8E 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 40 02 ?? ?? ?? 0? 46 05 00 46 ?? ?? 06 8E ?? ?? 07 8E 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 60 02 ?? ?? ?? 0? 06 05 00 46 ?? ?? 06 8E ?? ?? 07 8E 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 C6 03 00 46 06 B3 00 46 46 AB 00 46 86 A3 00 46 ?? ?? ?? 0? 21 20 A0 03 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 02 3C ?? ?? A3 8C ?? ?? 5E 8C ?? ?? A5 8C ?? ?? 82 8C ?? ?? 84 8C 21 B8 00 00 38 00 A2 AF 40 00 A3 AF 34 00 A4 AF 3C 00 A5 AF 0C 00 03 24 18 00 E3 02 30 00 A6 8F 21 90 00 00 12 10 00 00 21 A0 C2 00 21 98 A2 03 ?? ?? ?? 0? 00 00 6C C6 21 20 40 00 21 80 40 00 ?? ?? 02 3C ?? ?? 42 24 00 00 46 8C 04 00 47 8C 21 28 60 00 ?? ?? ?? 0? 21 88 60 00 ?? ?? 03 3C ?? ?? 63 24 21 20 00 02 21 28 20 02 00 00 66 8C 21 00 40 18 04 00 67 8C 22 00 06 24 FF 7F 02 3C 00 00 C6 AF FF FF 42 34 01 00 52 26 03 00 03 24 00 00 82 AE 04 00 73 26 E5 FF 43 16 04 00 94 26 01 00 F7 26 DC FF F2 56 0C 00 03 24 30 00 A7 8F 6C 00 BF 8F 68 00 BE 8F 64 00 B7 8F 60 00 B6 8F 5C 00 B5 8F 58 00 B4 8F 54 00 B3 8F 50 00 B2 8F 4C 00 B1 8F 48 00 B0 8F 7C 00 B6 C7 78 00 B5 C7 74 00 B4 C7 24 00 E0 AC 2C 00 E0 AC 28 00 E0 AC 08 00 E0 03 80 00 BD 27 ?? ?? ?? 0? 00 00 00 00 21 20 00 02 21 28 20 02 21 30 00 00 06 00 41 04 21 38 00 00 22 00 07 24 00 80 02 3C 00 00 C7 AF ?? ?? ?? 0? 01 00 42 34 ?? ?? ?? 0? 00 00 00 00 14 00 40 04 34 00 B6 8F 3C 00 B6 8F 40 00 B5 8F ?? ?? 02 3C ?? ?? 42 24 00 00 46 8C 04 00 47 8C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 21 20 40 00 21 28 60 00 21 30 C0 02 ?? ?? ?? 0? 21 38 A0 02 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 ?? ?? ?? 0? 01 00 52 26 ?? ?? ?? 0? 38 00 B5 8F }
	condition:
		$1
}

rule file_18_31_0 {
	meta:
		name = "get_rotation_matrix_f"
		size = 592
		refs = "003c __extendsfdf2 0044 $LC9 0054 __muldf3 005c $LC10 007c cos 0088 __truncdfsf2 0098 sin"
	strings:
		$1 = { C8 FF BD 27 18 00 B4 AF ?? ?? 14 3C 1C 00 BF AF 14 00 B3 AF 10 00 B2 AF 0C 00 B1 AF 21 90 80 00 08 00 B0 AF 34 00 B8 E7 30 00 B7 E7 06 76 00 46 2C 00 B6 E7 28 00 B5 E7 24 00 B4 E7 ?? ?? ?? 0? 06 6D 00 46 ?? ?? 86 8E ?? ?? 87 8E ?? ?? 13 3C 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 ?? ?? 66 8E ?? ?? 67 8E 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 40 00 21 28 60 00 21 80 40 00 ?? ?? ?? 0? 21 88 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 00 02 21 28 20 02 ?? ?? ?? 0? C6 05 00 46 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 06 A3 00 46 ?? ?? ?? 0? 86 05 00 46 ?? ?? 86 8E ?? ?? 87 8E 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 ?? ?? 66 8E ?? ?? 67 8E 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 40 00 21 28 60 00 21 80 40 00 ?? ?? ?? 0? 21 88 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 00 02 21 28 20 02 ?? ?? ?? 0? 46 05 00 46 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 06 C3 00 46 ?? ?? ?? 0? 00 00 A0 E7 ?? ?? 86 8E ?? ?? 87 8E 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 ?? ?? 66 8E ?? ?? 67 8E 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 40 00 21 28 60 00 21 80 40 00 ?? ?? ?? 0? 21 88 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 00 02 21 28 20 02 ?? ?? ?? 0? 06 05 00 46 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 00 00 A2 C7 C2 B1 14 46 02 BA 00 46 42 B0 02 46 82 B8 02 46 42 B9 14 46 82 B1 00 46 C2 BD 15 46 82 B5 15 46 00 00 A3 8F C2 08 00 46 02 11 00 46 42 08 14 46 82 10 14 46 02 A8 00 46 02 AD 14 46 00 80 02 3C 26 10 62 00 C0 18 05 46 01 21 07 46 41 08 08 46 80 10 06 46 04 00 A2 AF 04 00 A2 8F 1C 00 BF 8F 00 00 54 E6 14 00 56 E6 20 00 57 E6 04 00 40 E6 08 00 42 AE 0C 00 41 E6 10 00 43 E6 18 00 42 E6 1C 00 44 E6 24 00 40 AE 2C 00 40 AE 28 00 40 AE 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 34 00 B8 C7 30 00 B7 C7 2C 00 B6 C7 28 00 B5 C7 24 00 B4 C7 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_18_32_0 {
	meta:
		name = "get_z_rotate_matrix_f"
		size = 272
		refs = "0018 __extendsfdf2 0020 $LC9 0030 __muldf3 0038 $LC10 005c cos 0068 __truncdfsf2 0078 sin 008c identity_matrix_f"
	strings:
		$1 = { E0 FF BD 27 14 00 BF AF 10 00 B2 AF 0C 00 B1 AF 21 90 80 00 08 00 B0 AF ?? ?? ?? 0? 1C 00 B4 E7 ?? ?? 04 3C ?? ?? 86 8C ?? ?? 87 8C 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 ?? ?? 04 3C ?? ?? 86 8C ?? ?? 87 8C 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 21 20 40 00 21 28 60 00 21 80 40 00 ?? ?? ?? 0? 21 88 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 00 02 21 28 20 02 ?? ?? ?? 0? 06 05 00 46 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 ?? ?? 02 3C ?? ?? 46 24 00 00 A0 E7 21 38 40 02 30 00 C8 24 00 00 C2 8C 04 00 C3 8C 08 00 C4 8C 0C 00 C5 8C 10 00 C6 24 00 00 E2 AC 04 00 E3 AC 08 00 E4 AC 0C 00 E5 AC F6 FF C8 14 10 00 E7 24 00 00 A3 8F 00 80 02 3C 00 00 A0 C7 26 10 62 00 04 00 A2 AF 04 00 A2 8F 14 00 BF 8F 10 00 54 E6 00 00 54 E6 04 00 42 AE 0C 00 40 E6 0C 00 B1 8F 10 00 B2 8F 08 00 B0 8F 1C 00 B4 C7 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_18_33_0 {
	meta:
		name = "get_y_rotate_matrix_f"
		size = 272
		refs = "0018 __extendsfdf2 0020 $LC9 0030 __muldf3 0038 $LC10 005c cos 0068 __truncdfsf2 0078 sin 008c identity_matrix_f"
	strings:
		$1 = { E0 FF BD 27 14 00 BF AF 10 00 B2 AF 0C 00 B1 AF 21 90 80 00 08 00 B0 AF ?? ?? ?? 0? 1C 00 B4 E7 ?? ?? 04 3C ?? ?? 86 8C ?? ?? 87 8C 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 ?? ?? 04 3C ?? ?? 86 8C ?? ?? 87 8C 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 21 20 40 00 21 28 60 00 21 80 40 00 ?? ?? ?? 0? 21 88 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 00 02 21 28 20 02 ?? ?? ?? 0? 06 05 00 46 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 ?? ?? 02 3C ?? ?? 46 24 00 00 A0 E7 21 38 40 02 30 00 C8 24 00 00 C2 8C 04 00 C3 8C 08 00 C4 8C 0C 00 C5 8C 10 00 C6 24 00 00 E2 AC 04 00 E3 AC 08 00 E4 AC 0C 00 E5 AC F6 FF C8 14 10 00 E7 24 00 00 A3 8F 00 80 02 3C 00 00 A0 C7 26 10 62 00 04 00 A2 AF 04 00 A2 8F 14 00 BF 8F 20 00 54 E6 00 00 54 E6 18 00 42 AE 08 00 40 E6 0C 00 B1 8F 10 00 B2 8F 08 00 B0 8F 1C 00 B4 C7 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_18_34_0 {
	meta:
		name = "get_x_rotate_matrix_f"
		size = 272
		refs = "0018 __extendsfdf2 0020 $LC9 0030 __muldf3 0038 $LC10 005c cos 0068 __truncdfsf2 0078 sin 008c identity_matrix_f"
	strings:
		$1 = { E0 FF BD 27 14 00 BF AF 10 00 B2 AF 0C 00 B1 AF 21 90 80 00 08 00 B0 AF ?? ?? ?? 0? 1C 00 B4 E7 ?? ?? 04 3C ?? ?? 86 8C ?? ?? 87 8C 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 ?? ?? 04 3C ?? ?? 86 8C ?? ?? 87 8C 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 21 20 40 00 21 28 60 00 21 80 40 00 ?? ?? ?? 0? 21 88 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 00 02 21 28 20 02 ?? ?? ?? 0? 06 05 00 46 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 ?? ?? 02 3C ?? ?? 46 24 00 00 A0 E7 21 38 40 02 30 00 C8 24 00 00 C2 8C 04 00 C3 8C 08 00 C4 8C 0C 00 C5 8C 10 00 C6 24 00 00 E2 AC 04 00 E3 AC 08 00 E4 AC 0C 00 E5 AC F6 FF C8 14 10 00 E7 24 00 00 A3 8F 00 80 02 3C 00 00 A0 C7 26 10 62 00 04 00 A2 AF 04 00 A2 8F 14 00 BF 8F 20 00 54 E6 10 00 54 E6 14 00 42 AE 1C 00 40 E6 0C 00 B1 8F 10 00 B2 8F 08 00 B0 8F 1C 00 B4 C7 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_19_0_0 {
	meta:
		name = "fli_timer_callback"
		size = 24
		refs = "0000 fli_timer"
	strings:
		$1 = { ?? ?? 03 3C ?? ?? 62 8C 01 00 42 24 ?? ?? 62 AC 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_19_1_0 {
	meta:
		name = "reset_fli_variables"
		size = 48
		refs = "000c fli_pal_dirty_from 0018 fli_pal_dirty_to 001c fli_bmp_dirty_from 002c fli_bmp_dirty_to"
	strings:
		$1 = { FF 7F 04 3C FF FF 84 34 00 80 05 3C ?? ?? 02 3C ?? ?? 03 3C ?? ?? 44 AC ?? ?? 65 AC ?? ?? 02 3C ?? ?? 03 3C ?? ?? 44 AC 08 00 E0 03 ?? ?? 65 AC }
	condition:
		$1
}

rule file_19_2_0 {
	meta:
		name = "fli_read"
		size = 232
		refs = "0000 .bss 003c memcpy 0078 .text 0094 pack_fread 00a8 _scratch_mem_size 00bc _scratch_mem 00d0 _al_realloc"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 43 8C E8 FF BD 27 0C 00 B2 AF 08 00 B1 AF 14 00 BF AF 10 00 B3 AF 04 00 B0 AF 21 90 A0 00 16 00 60 10 21 88 80 00 10 00 80 10 21 30 40 02 ?? ?? 10 3C ?? ?? 05 8E ?? ?? ?? 0? 21 28 65 00 ?? ?? 02 8E 21 10 42 02 ?? ?? 02 AE 14 00 BF 8F 21 10 20 02 10 00 B3 8F 0C 00 B2 8F 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 18 00 BD 27 ?? ?? 10 3C ?? ?? 02 8E ?? ?? ?? 0? 21 88 62 00 09 00 80 10 ?? ?? 13 3C ?? ?? 02 3C ?? ?? 46 8C 21 20 20 02 ?? ?? ?? 0? 21 28 40 02 26 10 42 02 ?? ?? ?? 0? 0B 88 02 00 ?? ?? 62 8E 2A 10 45 00 03 00 40 14 ?? ?? 11 3C ?? ?? ?? 0? ?? ?? 31 8E FF 03 B0 24 ?? ?? 24 8E 00 FC 02 24 24 80 02 02 ?? ?? ?? 0? 21 28 00 02 ?? ?? 22 AE ?? ?? 70 AE ?? ?? ?? 0? ?? ?? 31 8E }
	condition:
		$1
}

rule file_19_3_0 {
	meta:
		name = "next_fli_frame"
		size = 4364
		refs = "0008 .data 003c .bss 0044 fli_timer 0054 fli_frame 00bc .text 01ec pack_fseek 01fc clear_bitmap 04f8 fli_bitmap 0208 fli_bmp_dirty_from 0220 fli_bmp_dirty_to 0228 pack_fclose 023c pack_fopen 0238 $LC0 0360 .rodata 03c8 memcpy 0544 memset 07a8 fli_pal_dirty_from 07b4 fli_pal_dirty_to 07e0 fli_palette"
	strings:
		$1 = { 90 FF BD 27 68 00 BE AF ?? ?? 1E 3C ?? ?? C2 8F 6C 00 BF AF 64 00 B7 AF 60 00 B6 AF 5C 00 B5 AF 58 00 B4 AF 54 00 B3 AF 50 00 B2 AF 4C 00 B1 AF 48 00 B0 AF 4E 00 40 14 21 30 80 00 ?? ?? 02 3C ?? ?? 54 24 ?? ?? 05 3C ?? ?? 16 3C ?? ?? A2 8C 06 00 83 96 ?? ?? C4 8E FF FF 42 24 ?? ?? A2 AC 2A 18 83 00 0A 00 60 14 ?? ?? C2 8F 50 00 C0 10 ?? ?? 02 3C ?? ?? 43 8C 6A 00 60 10 80 00 03 24 ?? ?? 02 3C ?? ?? 43 AC ?? ?? C0 AE ?? ?? C2 8F 36 00 40 14 ?? ?? C2 8E 58 00 40 10 ?? ?? 10 3C ?? ?? 12 3C ?? ?? 50 26 00 F1 17 34 A1 00 15 24 ?? ?? 13 3C ?? ?? 11 3C 21 20 00 00 ?? ?? ?? 0? 10 00 05 24 36 00 40 10 21 30 40 00 01 00 42 90 02 00 C3 90 00 00 C5 90 03 00 C4 90 00 1C 03 00 00 12 02 00 25 10 43 00 25 10 45 00 00 26 04 00 25 28 44 00 ?? ?? 45 AE 05 00 C2 90 04 00 C3 90 10 00 A4 2C 00 12 02 00 25 10 43 00 04 00 02 A6 07 00 C3 90 06 00 C2 90 21 48 00 02 00 1A 03 00 25 18 62 00 1E 00 80 14 06 00 03 A6 04 00 03 96 03 00 77 10 ?? ?? 62 8E 49 00 75 54 FA F1 02 34 29 00 40 10 F0 FF A5 24 ?? ?? 22 8E 21 10 A2 00 ?? ?? 22 AE ?? ?? C2 8E 06 00 83 96 01 00 42 24 2A 18 43 00 D4 FF 60 14 ?? ?? C2 AE ?? ?? C2 8F 6C 00 BF 8F 68 00 BE 8F 64 00 B7 8F 60 00 B6 8F 5C 00 B5 8F 58 00 B4 8F 54 00 B3 8F 50 00 B2 8F 4C 00 B1 8F 48 00 B0 8F 08 00 E0 03 70 00 BD 27 FE FF 02 24 ?? ?? C2 AF ?? ?? ?? 0? ?? ?? C2 8F 6C 00 BF 8F FF FF 02 24 ?? ?? C2 AF 64 00 B7 8F 68 00 BE 8F 60 00 B6 8F 5C 00 B5 8F 58 00 B4 8F 54 00 B3 8F 50 00 B2 8F 4C 00 B1 8F 48 00 B0 8F 08 00 E0 03 70 00 BD 27 ?? ?? 02 3C ?? ?? ?? 0? ?? ?? 44 8C ?? ?? ?? 0? ?? ?? C2 8E ?? ?? ?? 0? ?? ?? 04 8E ?? ?? 02 8E ?? ?? 03 3C 04 00 44 8C ?? ?? 02 3C ?? ?? 60 AC FF FF 84 24 ?? ?? ?? 0? ?? ?? 44 AC ?? ?? 10 3C ?? ?? ?? 0? ?? ?? 04 8E ?? ?? 03 3C ?? ?? 64 8C ?? ?? 05 3C ?? ?? ?? 0? ?? ?? A5 24 10 00 40 10 ?? ?? 02 AE 21 20 40 00 ?? ?? ?? 0? 80 00 05 24 ?? ?? ?? 0? ?? ?? C0 AE D0 FF 62 54 FE FF 02 24 F0 FF B1 24 0A 00 20 16 21 20 00 00 ?? ?? C2 8E 01 00 42 24 ?? ?? C2 AE ?? ?? ?? 0? ?? ?? C2 8F FE FF 02 24 ?? ?? C2 AF ?? ?? ?? 0? ?? ?? C0 AE 21 28 20 02 ?? ?? ?? 0? 40 00 A9 AF 21 30 40 00 BD FF 40 10 40 00 A9 8F 06 00 07 96 F0 FF E0 10 ?? ?? C2 8E 06 00 22 2E ED FF 40 14 ?? ?? C2 8E 38 00 A0 AF 01 00 C2 90 02 00 C3 90 00 00 C5 90 03 00 C4 90 00 1C 03 00 00 12 02 00 25 10 43 00 25 10 45 00 00 26 04 00 25 20 44 00 06 00 83 2C 04 00 C8 90 DD FF 60 14 05 00 C5 90 2B 10 24 02 DB FF 40 14 ?? ?? C2 8E 38 00 A3 8F 23 88 24 02 06 00 C6 24 FA FF 84 24 FF FF E2 24 00 00 B1 AF 34 00 A6 AF 05 00 43 14 18 00 A4 AF 18 00 A3 8F 00 00 A4 8F 21 18 64 00 18 00 A3 AF 00 12 05 00 25 10 48 00 FC FF 42 24 FF FF 42 30 0D 00 43 2C 2F 00 60 10 18 00 A4 8F ?? ?? 05 3C 80 10 02 00 ?? ?? A5 24 21 10 A2 00 00 00 43 8C 08 00 60 00 00 00 00 00 ?? ?? 06 3C ?? ?? C3 8C 18 00 A5 8F 00 00 66 8C 04 00 64 8C 18 00 86 00 12 10 00 00 23 10 A2 00 1E 00 42 04 18 00 A4 8F 14 00 80 18 ?? ?? 07 3C 34 00 B1 8F 21 80 00 00 10 00 02 26 80 10 02 00 21 10 62 00 00 00 44 8C 21 28 20 02 ?? ?? ?? 0? 40 00 A9 AF ?? ?? 06 3C ?? ?? C3 8C 01 00 10 26 40 00 A9 8F 04 00 62 8C 00 00 66 8C 2A 10 02 02 F1 FF 40 14 21 88 26 02 ?? ?? 07 3C ?? ?? E3 8C ?? ?? 08 3C ?? ?? 00 AD 04 00 62 8C ?? ?? 03 3C FF FF 42 24 ?? ?? 62 AC 18 00 A4 8F 34 00 A5 8F 01 00 82 30 05 00 40 10 21 30 A4 00 00 00 A7 8F 01 00 C6 24 FF FF E7 24 00 00 A7 AF 38 00 A8 8F 06 00 27 95 01 00 08 25 2A 10 07 01 8A FF 40 10 38 00 A8 AF 00 00 B1 8F 06 00 22 2E 87 FF 40 54 ?? ?? C2 8E ?? ?? ?? 0? 01 00 C2 90 ?? ?? 02 3C ?? ?? 43 8C 04 00 64 8C 00 00 66 8C 21 38 60 00 0F 00 82 24 80 10 02 00 21 18 62 00 00 00 65 8C FF FF 82 24 ?? ?? 03 3C 21 30 A6 00 ?? ?? 05 3C ?? ?? 62 AC 14 00 A6 AF DB FF 80 18 ?? ?? A0 AC 18 00 A6 8F FF FF D1 24 D8 FF 20 06 18 00 A4 8F 34 00 B0 8F 10 00 A0 AF 10 00 A3 8F 00 00 08 92 01 00 10 26 10 00 62 24 80 10 02 00 21 10 E2 00 0C 00 A8 AF E8 01 00 11 00 00 52 8C 21 A8 00 00 0C 00 A3 8F 23 10 75 00 43 02 40 18 ?? ?? 04 3C FF FF 31 26 C5 FF 20 06 18 00 A4 8F 00 00 06 82 62 01 C0 04 01 00 10 26 7C 01 C0 10 21 98 46 02 14 00 A7 8F 2B 10 F3 00 BC FF 40 14 FF FF 08 24 FF FF 31 26 A1 02 28 12 ?? ?? 02 3C 00 00 05 92 21 20 40 02 40 00 A9 AF ?? ?? ?? 0? 01 00 10 26 01 00 B5 26 40 00 A9 8F ?? ?? ?? 0? 21 90 60 02 ?? ?? 05 3C ?? ?? A4 8C ?? ?? ?? 0? 40 00 A9 AF ?? ?? 06 3C ?? ?? C3 8C ?? ?? 07 3C ?? ?? 08 3C 04 00 62 8C ?? ?? E0 AC 40 00 A9 8F FF FF 42 24 ?? ?? ?? 0? ?? ?? 02 AD ?? ?? 05 3C ?? ?? A4 8C 18 00 A7 8F 04 00 88 8C 00 00 85 8C FC FF E6 24 0F 00 02 25 80 10 02 00 21 20 82 00 00 00 83 8C 21 28 65 00 94 FF C0 04 24 00 A5 AF 34 00 A2 8F 34 00 A3 8F 34 00 A7 8F 02 00 4A 24 01 00 42 91 02 00 64 90 01 00 63 90 00 00 E5 90 00 12 02 00 25 10 44 00 00 1A 03 00 25 28 65 00 20 26 02 7C 9A 02 80 04 28 00 A5 AF 28 00 A3 8F 2A 10 68 00 81 FF 40 10 21 28 83 00 2A 10 05 01 03 00 40 10 21 38 80 00 23 38 03 01 21 28 E3 00 ?? ?? 04 3C ?? ?? 08 3C ?? ?? 82 8C 28 00 A3 8F ?? ?? 04 8D ?? ?? 08 3C 2D 10 62 00 2A 18 85 00 02 00 60 10 ?? ?? 02 AD FF FF A4 24 ?? ?? 02 3C 6E FF E0 18 ?? ?? 44 AC FF FF D2 24 FF FF 03 24 6A FF 43 12 FF FF E7 24 02 00 51 25 20 00 A7 AF 04 00 A0 AF 04 00 A7 8F 28 00 A8 8F ?? ?? 06 3C ?? ?? C3 8C 21 10 E8 00 10 00 42 24 80 10 02 00 21 18 62 00 00 00 22 92 00 00 77 8C 01 00 31 26 1C 00 A2 AF 21 A8 00 00 1C 00 A3 8F 23 10 75 00 61 02 40 58 20 00 A4 8F FE FF 52 26 54 FF 42 06 18 00 A4 8F 00 00 22 92 01 00 30 82 02 00 31 26 07 01 00 1A 21 A0 E2 02 24 00 A3 8F 21 B8 90 02 2B 10 77 00 49 FF 40 14 23 90 50 02 30 01 40 06 21 98 50 02 21 28 20 02 21 20 80 02 21 30 00 02 40 00 A9 AF ?? ?? ?? 0? 21 88 30 02 01 00 B5 26 ?? ?? ?? 0? 40 00 A9 8F 18 00 A6 8F FE FF D3 24 3A FF 60 06 34 00 A7 8F 01 00 E2 90 00 00 E3 90 00 12 02 00 25 10 43 00 20 AE 02 7C 4D 02 A0 06 23 10 15 00 34 00 A8 8F 21 88 00 00 21 A0 00 00 02 00 05 25 00 01 17 24 23 10 B4 02 2B FF 40 18 FE FF 63 26 2A FF 60 04 18 00 A4 8F 00 00 A2 90 01 00 A6 90 21 88 22 02 0A 30 E6 02 21 80 D1 00 01 01 02 2A 21 FF 40 10 FD FF 04 24 18 00 C4 00 12 10 00 00 21 98 43 00 DD 00 60 06 02 00 A5 24 ?? ?? 04 3C ?? ?? 06 3C ?? ?? 82 8C ?? ?? C4 8C ?? ?? 07 3C 2D 10 22 02 2A 18 90 00 02 00 60 10 ?? ?? E2 AC FF FF 04 26 ?? ?? 08 3C 2A 10 30 02 1B 00 40 10 ?? ?? 04 AD ?? ?? 06 3C ?? ?? C6 24 80 10 11 00 80 18 10 00 21 20 C2 00 21 38 C3 00 21 30 A0 00 00 00 C2 90 00 00 82 A0 01 00 C3 90 01 00 83 A0 02 00 C2 90 02 00 82 A0 04 00 84 24 F8 FF 87 14 03 00 C6 24 27 10 11 00 13 00 A0 00 01 00 43 24 03 00 04 24 21 18 70 00 1C 00 64 00 21 10 02 02 01 00 24 26 21 88 82 00 12 28 00 00 ?? ?? ?? 0? 01 00 94 26 ?? ?? 05 3C ?? ?? A4 8C 18 00 A7 8F 04 00 82 8C 00 00 85 8C FE FF E6 24 0F 00 42 24 80 10 02 00 21 20 82 00 00 00 83 8C 21 28 65 00 E5 FE C0 04 30 00 A5 AF 34 00 A8 8F 01 00 02 91 00 00 03 91 00 12 02 00 25 10 43 00 20 16 02 7C 7A 00 42 04 23 10 02 00 DB FE 40 18 FE FF D2 24 D9 FE 40 06 FF FF 42 24 3C 00 A2 AF 34 00 A2 8F 2C 00 A0 AF 08 00 A0 AF ?? ?? ?? 0? 02 00 50 24 23 30 C5 00 2C 00 A6 AF FE FF 52 26 CF FE 40 06 18 00 A4 8F 01 00 02 92 00 00 03 92 00 12 02 00 25 10 43 00 20 16 02 7C 7B 00 40 04 02 00 10 26 4D 01 41 04 21 28 40 00 00 40 42 30 F0 FF 40 14 2C 00 A6 8F ?? ?? 07 3C ?? ?? E4 8C 2C 00 A8 8F 04 00 82 8C 2A 10 02 01 EC FF 40 50 FE FF 52 26 10 00 02 25 80 10 02 00 21 10 82 00 00 00 43 8C 00 00 84 8C 21 18 64 00 ?? ?? ?? 0? FF FF 65 A0 18 00 A6 8F FE FF D3 24 AF FE 60 06 34 00 A7 8F 01 00 E2 90 00 00 E3 90 00 12 02 00 25 10 43 00 20 AE 02 7C AF 01 A0 06 23 10 15 00 34 00 A8 8F 21 88 00 00 21 A0 00 00 02 00 05 25 00 01 17 24 23 10 B4 02 A0 FE 40 18 FE FF 63 26 9F FE 60 04 18 00 A4 8F 00 00 A2 90 01 00 A6 90 21 88 22 02 0A 30 E6 02 21 80 D1 00 01 01 02 2A 96 FE 40 10 FD FF 04 24 18 00 C4 00 12 10 00 00 21 98 43 00 66 00 60 06 02 00 A5 24 ?? ?? 04 3C ?? ?? 06 3C ?? ?? 82 8C ?? ?? C4 8C ?? ?? 07 3C 2D 10 22 02 2A 18 90 00 02 00 60 10 ?? ?? E2 AC FF FF 04 26 ?? ?? 08 3C 2A 10 30 02 1E 00 40 10 ?? ?? 04 AD ?? ?? 06 3C ?? ?? C6 24 80 10 11 00 80 18 10 00 21 20 C2 00 21 38 C3 00 21 30 A0 00 00 00 C2 90 82 10 02 00 00 00 82 A0 01 00 C3 90 82 18 03 00 01 00 83 A0 02 00 C2 90 82 10 02 00 02 00 82 A0 04 00 84 24 F5 FF 87 14 03 00 C6 24 27 10 11 00 13 00 A0 00 01 00 43 24 03 00 04 24 21 18 70 00 1C 00 64 00 21 10 02 02 01 00 24 26 21 88 82 00 12 28 00 00 ?? ?? ?? 0? 01 00 94 26 FF 7F 42 30 23 10 02 00 ?? ?? ?? 0? 20 16 02 7C 14 00 A3 8F 23 A0 06 00 21 98 54 02 2B 10 73 00 5B FE 40 14 18 00 A4 8F 23 88 34 02 51 00 20 06 21 B8 34 02 21 20 40 02 21 28 00 02 21 30 80 02 40 00 A9 AF ?? ?? ?? 0? 21 80 14 02 01 00 B5 26 40 00 A9 8F ?? ?? ?? 0? 21 90 60 02 23 10 02 00 FF 7F 42 30 23 10 02 00 ?? ?? ?? 0? 20 16 02 7C 51 00 00 16 21 B8 80 02 ?? ?? ?? 0? 01 00 B5 26 21 98 40 02 01 00 B5 26 ?? ?? ?? 0? 21 90 60 02 03 00 02 24 18 00 C2 00 12 30 00 00 21 90 66 02 A4 00 40 1A ?? ?? 04 3C ?? ?? 84 24 21 30 40 02 ?? ?? ?? 0? 40 00 A9 AF ?? ?? 03 3C ?? ?? 63 24 21 28 00 00 21 20 72 00 ?? ?? ?? 0? 23 30 13 00 ?? ?? 05 3C ?? ?? A5 24 ?? ?? ?? 0? 40 00 A9 8F 03 00 02 24 18 00 C2 00 12 30 00 00 21 90 66 02 88 00 40 1A ?? ?? 04 3C ?? ?? 84 24 21 30 40 02 ?? ?? ?? 0? 40 00 A9 AF ?? ?? 03 3C ?? ?? 63 24 21 28 00 00 21 20 72 00 ?? ?? ?? 0? 23 30 13 00 ?? ?? 05 3C ?? ?? A5 24 ?? ?? ?? 0? 40 00 A9 8F 88 00 60 1A 21 28 20 02 ?? ?? 04 3C ?? ?? 84 24 21 30 60 02 ?? ?? ?? 0? 40 00 A9 AF ?? ?? 05 3C ?? ?? A5 24 21 20 B3 00 23 30 12 00 21 28 00 00 ?? ?? ?? 0? ?? ?? 11 3C ?? ?? 31 26 ?? ?? ?? 0? 40 00 A9 8F FA 00 E0 1A ?? ?? 04 3C 21 28 00 02 ?? ?? 84 24 21 30 E0 02 ?? ?? ?? 0? 40 00 A9 AF ?? ?? 05 3C ?? ?? A5 24 21 20 B7 00 23 30 11 00 21 28 00 00 ?? ?? ?? 0? ?? ?? 10 3C ?? ?? 10 26 ?? ?? ?? 0? 40 00 A9 8F 24 00 A7 8F 23 30 10 00 21 B8 86 02 2B 10 F7 00 F0 FD 40 14 FF FF 52 26 FF FF 08 24 24 01 48 12 ?? ?? 02 3C 00 00 25 92 21 20 80 02 40 00 A9 AF ?? ?? ?? 0? 01 00 31 26 01 00 B5 26 ?? ?? ?? 0? 40 00 A9 8F 00 00 E2 8C 21 B8 42 02 2B 18 57 02 5C 00 60 10 ?? ?? 04 3C FF FF 31 26 19 00 23 06 00 00 06 82 ?? ?? ?? 0? 18 00 A4 8F 28 00 C0 10 14 00 A7 8F 21 98 46 02 2B 10 F3 00 D5 FD 40 14 FF FF 08 24 FF FF 31 26 B8 00 28 12 ?? ?? 02 3C 00 00 05 92 21 20 40 02 ?? ?? ?? 0? 40 00 A9 AF 40 00 A9 8F 01 00 10 26 2B 10 77 02 45 00 40 10 ?? ?? 04 3C FF FF 31 26 C6 FD 20 06 21 90 60 02 00 00 06 82 E9 FF C1 04 01 00 10 26 14 00 A4 8F 23 A0 06 00 21 98 54 02 2B 10 93 00 BE FD 40 14 18 00 A4 8F 23 88 34 02 0B 00 20 06 21 A8 34 02 21 28 00 02 21 20 40 02 21 30 80 02 40 00 A9 AF ?? ?? ?? 0? 21 80 14 02 ?? ?? ?? 0? 40 00 A9 8F ?? ?? ?? 0? 21 98 40 02 AC 00 A0 1A ?? ?? 04 3C 21 28 00 02 ?? ?? 84 24 21 30 A0 02 ?? ?? ?? 0? 40 00 A9 AF ?? ?? 05 3C ?? ?? A5 24 21 20 B5 00 23 30 11 00 21 28 00 00 ?? ?? ?? 0? ?? ?? 10 3C ?? ?? 10 26 ?? ?? ?? 0? 40 00 A9 8F 21 28 00 00 ?? ?? 84 24 ?? ?? ?? 0? 40 00 A9 AF ?? ?? 05 3C ?? ?? A5 24 ?? ?? ?? 0? 40 00 A9 8F 21 28 00 00 ?? ?? 84 24 ?? ?? ?? 0? 40 00 A9 AF ?? ?? 05 3C ?? ?? A5 24 ?? ?? ?? 0? 40 00 A9 8F ?? ?? 04 3C ?? ?? 84 24 21 28 00 00 21 30 00 02 ?? ?? 11 3C 40 00 A9 AF ?? ?? ?? 0? ?? ?? 31 26 ?? ?? ?? 0? 40 00 A9 8F ?? ?? 87 8C 10 00 A5 8F 04 00 E2 8C 01 00 A5 24 2A 10 A2 00 7E FD 40 10 10 00 A5 AF FF FF 31 26 A8 FD 21 06 10 00 A3 8F ?? ?? ?? 0? 18 00 A4 8F ?? ?? 02 3C ?? ?? 46 8C 2C 00 A3 8F 04 00 C2 8C 2A 10 62 00 72 FD 40 10 ?? ?? 04 3C ?? ?? 07 3C 10 00 63 24 ?? ?? 82 8C 2C 00 A8 8F ?? ?? E4 8C 80 18 03 00 21 18 C3 00 00 00 77 8C 2D 10 02 01 2C 20 04 01 ?? ?? 06 3C ?? ?? C2 AC ?? ?? E4 AC 21 A8 A0 00 8C 00 A0 1A FE FF 46 26 61 FD C0 04 18 00 A4 8F 00 00 02 92 01 00 03 82 02 00 10 26 15 00 60 18 21 88 E2 02 30 00 A7 8F 40 98 03 00 21 B8 33 02 2B 10 F7 00 55 FD 40 14 FE FF 04 24 18 00 64 00 12 10 00 00 21 90 46 00 0F 00 40 06 21 A0 53 02 21 28 00 02 21 20 20 02 21 30 60 02 40 00 A9 AF ?? ?? ?? 0? 21 80 13 02 FF FF B5 26 ?? ?? ?? 0? 40 00 A9 8F 15 00 60 14 21 B8 20 02 21 90 C0 00 ?? ?? ?? 0? FF FF B5 26 2C 00 80 1A ?? ?? 04 3C 21 28 00 02 ?? ?? 84 24 21 30 80 02 ?? ?? ?? 0? 40 00 A9 AF ?? ?? 05 3C ?? ?? A5 24 21 20 B4 00 23 30 12 00 21 28 00 00 ?? ?? ?? 0? ?? ?? 10 3C ?? ?? 10 26 ?? ?? ?? 0? 40 00 A9 8F 23 98 03 00 30 00 A7 8F 40 10 13 00 21 B8 22 02 2B 18 F7 00 2A FD 60 14 FC FF 52 26 46 00 40 06 FE FF 08 24 01 00 06 92 00 00 04 92 01 00 05 26 21 18 00 00 01 00 63 24 2A 10 73 00 00 00 24 A2 01 00 26 A2 FB FF 40 14 02 00 31 26 01 00 B0 24 ?? ?? ?? 0? FF FF B5 26 ?? ?? 40 A0 ?? ?? ?? 0? ?? ?? 50 24 ?? ?? 40 A0 ?? ?? ?? 0? ?? ?? 50 24 ?? ?? 84 24 21 28 00 00 21 30 60 02 ?? ?? 10 3C 40 00 A9 AF ?? ?? ?? 0? ?? ?? 10 26 ?? ?? ?? 0? 40 00 A9 8F ?? ?? 84 24 21 28 00 00 21 30 80 02 ?? ?? 10 3C 40 00 A9 AF ?? ?? ?? 0? }
	condition:
		$1
}

rule file_19_4_0 {
	meta:
		name = "close_fli"
		size = 196
		refs = "0004 .text 0014 remove_int 0018 .bss 0028 pack_fclose 0044 _al_free 0050 fli_bitmap 0060 destroy_bitmap 0074 fli_pal_dirty_from 0090 fli_pal_dirty_to 0094 .data 00a8 fli_bmp_dirty_from 00b8 fli_bmp_dirty_to"
	strings:
		$1 = { F8 FF BD 27 ?? ?? 04 3C 00 00 B0 AF ?? ?? 84 24 04 00 BF AF ?? ?? ?? 0? ?? ?? 10 3C ?? ?? 04 8E 05 00 80 50 ?? ?? 10 3C ?? ?? ?? 0? 00 00 00 00 ?? ?? 00 AE ?? ?? 10 3C ?? ?? 04 8E 05 00 80 50 ?? ?? 10 3C ?? ?? ?? 0? 00 00 00 00 ?? ?? 00 AE ?? ?? 10 3C ?? ?? 04 8E 05 00 80 10 FF 7F 05 3C ?? ?? ?? 0? 00 00 00 00 ?? ?? 00 AE FF 7F 05 3C FF FF A5 34 ?? ?? 02 3C 00 80 06 3C ?? ?? 03 3C ?? ?? 45 AC FD FF 04 24 ?? ?? 02 3C 04 00 BF 8F ?? ?? 66 AC ?? ?? 44 AC ?? ?? 03 3C ?? ?? 02 3C ?? ?? 60 AC ?? ?? 40 AC ?? ?? 03 3C ?? ?? 02 3C 00 00 B0 8F ?? ?? 65 AC ?? ?? 46 AC 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_19_5_0 {
	meta:
		name = "do_open_fli"
		size = 708
		refs = "0014 .text 0054 .bss 01a0 create_bitmap_ex 01a8 fli_bitmap 01bc fli_pal_dirty_from 01d8 fli_pal_dirty_to 01d0 fli_timer 01e0 fli_bmp_dirty_from 01f0 fli_bmp_dirty_to 01f4 fli_frame 0204 .data 0224 install_int_ex 0244 close_fli"
	strings:
		$1 = { F0 FF BD 27 21 20 00 00 80 00 05 24 0C 00 BF AF 08 00 B1 AF ?? ?? ?? 0? 04 00 B0 AF 89 00 40 10 21 30 40 00 01 00 42 90 02 00 C3 90 00 00 C5 90 03 00 C4 90 00 12 02 00 00 1C 03 00 25 10 43 00 25 10 45 00 00 26 04 00 25 50 44 00 90 00 40 05 04 00 C7 24 ?? ?? 03 3C ?? ?? 6A AC 01 00 E2 90 04 00 C4 90 ?? ?? 70 24 00 12 02 00 25 58 44 00 04 00 0B A6 03 00 E2 90 02 00 E3 90 0E 00 E6 24 00 12 02 00 25 10 43 00 06 00 02 A6 05 00 E3 90 04 00 E2 90 00 1A 03 00 25 68 62 00 08 00 0D A6 07 00 E2 90 06 00 E3 90 00 12 02 00 25 60 43 00 0A 00 0C A6 09 00 E2 90 08 00 E3 90 00 12 02 00 25 48 43 00 0C 00 09 A6 0B 00 E2 90 0A 00 E3 90 00 12 02 00 25 10 43 00 0E 00 02 A6 0D 00 E3 90 0C 00 E2 90 00 1A 03 00 25 18 62 00 10 00 03 A6 01 00 C2 90 02 00 C3 90 03 00 C4 90 0E 00 E5 90 00 12 02 00 00 1C 03 00 25 10 43 00 25 10 45 00 00 26 04 00 25 10 44 00 57 00 40 04 12 00 E8 24 14 00 02 AE 01 00 02 91 02 00 03 91 12 00 E5 90 03 00 04 91 00 1C 03 00 00 12 02 00 25 10 43 00 25 10 45 00 00 26 04 00 25 18 44 00 45 00 60 04 FF 7F 02 3C 80 00 42 29 3A 00 40 14 18 00 03 AE 08 00 02 24 03 00 22 11 EF 50 62 25 35 00 20 15 00 00 00 00 FF FF 42 30 02 00 42 2C 31 00 40 10 00 00 00 00 02 00 A0 15 40 01 02 24 08 00 02 A6 45 00 80 11 C8 00 02 24 08 00 05 96 0A 00 06 96 ?? ?? ?? 0? 08 00 04 24 ?? ?? 03 3C 25 00 40 10 ?? ?? 62 AC FF 7F 05 3C FF FF A5 34 ?? ?? 02 3C 00 80 06 3C ?? ?? 03 3C ?? ?? 45 AC 02 00 04 24 ?? ?? 02 3C 04 00 07 96 ?? ?? 66 AC ?? ?? 44 AC ?? ?? 03 3C ?? ?? 02 3C ?? ?? 11 3C ?? ?? 65 AC ?? ?? 46 AC ?? ?? 03 3C 11 AF 02 34 ?? ?? 60 AC 2B 00 E2 10 ?? ?? 20 AE 10 00 03 96 A9 04 02 24 18 00 62 00 12 18 00 00 95 42 05 24 ?? ?? 04 3C 0B 28 63 00 ?? ?? ?? 0? ?? ?? 84 24 0C 00 BF 8F ?? ?? 22 8E 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 10 00 BD 27 ?? ?? ?? 0? 00 00 00 00 0C 00 BF 8F FE FF 02 24 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 10 00 BD 27 23 18 03 00 FF FF 42 34 24 18 62 00 ?? ?? ?? 0? 23 18 03 00 23 18 02 00 FF 7F 02 3C FF FF 42 34 24 18 62 00 ?? ?? ?? 0? 23 10 03 00 FF 7F 02 3C 23 18 0A 00 FF FF 42 34 24 18 62 00 ?? ?? ?? 0? 23 50 03 00 ?? ?? ?? 0? 0A 00 02 A6 10 00 03 96 95 42 02 24 18 00 62 00 ?? ?? ?? 0? 12 18 00 00 }
	condition:
		$1
}

rule file_19_6_0 {
	meta:
		name = "open_memory_fli"
		size = 48
		refs = "0000 .data 001c .bss 0028 .text"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 43 8C FD FF 02 24 03 00 62 10 FE FF 02 24 08 00 E0 03 00 00 00 00 ?? ?? 02 3C ?? ?? 03 3C ?? ?? 44 AC ?? ?? ?? 0? ?? ?? 60 AC }
	condition:
		$1
}

rule file_19_7_0 {
	meta:
		name = "open_fli"
		size = 152
		refs = "0000 .data 003c .bss 004c _al_free 0058 _al_ustrdup 0070 pack_fopen 0068 $LC0 0090 .text"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 43 8C F0 FF BD 27 FD FF 02 24 04 00 B0 AF 0C 00 BF AF 08 00 B1 AF 07 00 62 10 21 80 80 00 0C 00 BF 8F FE FF 02 24 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 10 00 BD 27 ?? ?? 11 3C ?? ?? 24 8E 04 00 80 10 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 ?? ?? 20 AE ?? ?? ?? 0? 21 20 00 02 F0 FF 40 10 ?? ?? 22 AE ?? ?? 05 3C 21 20 40 00 ?? ?? ?? 0? ?? ?? A5 24 ?? ?? 03 3C E9 FF 40 10 ?? ?? 62 AC 0C 00 BF 8F 08 00 B1 8F 04 00 B0 8F ?? ?? ?? 0? 10 00 BD 27 }
	condition:
		$1
}

rule file_19_8_0 {
	meta:
		name = "do_play_fli"
		size = 424
		refs = "0038 next_fli_frame 0058 fli_pal_dirty_from 0068 fli_pal_dirty_to 0074 fli_bmp_dirty_from 0078 fli_bmp_dirty_to 00b4 fli_timer 00d0 close_fli 0114 rest 0134 .text 013c fli_palette 0144 set_palette_range 0160 vsync 0168 fli_bitmap 0198 blit"
	strings:
		$1 = { D0 FF BD 27 00 00 A4 AF 21 20 A0 00 28 00 BE AF 14 00 B3 AF 08 00 B0 AF 2C 00 BF AF 24 00 B7 AF 20 00 B6 AF 1C 00 B5 AF 18 00 B4 AF 10 00 B2 AF 0C 00 B1 AF 21 F0 A0 00 ?? ?? ?? 0? 21 98 C0 00 23 00 40 14 21 80 40 00 FF 7F 03 3C ?? ?? 12 3C ?? ?? 11 3C FF FF 77 34 ?? ?? 16 3C ?? ?? 15 3C 00 80 14 3C ?? ?? C5 8E ?? ?? A6 8E 2A 10 C5 00 32 00 40 10 ?? ?? 42 8E ?? ?? 23 8E 2A 10 62 00 37 00 40 10 00 00 00 00 ?? ?? 57 AE ?? ?? 34 AE ?? ?? D7 AE 05 00 60 12 ?? ?? B4 AE 09 F8 60 02 00 00 00 00 0A 00 40 14 21 80 40 00 ?? ?? ?? 0? 21 20 C0 03 ?? ?? 03 3C 21 80 40 00 ?? ?? 62 8C 14 00 40 18 00 00 00 00 E7 FF 00 12 ?? ?? C5 8E ?? ?? ?? 0? 00 00 00 00 2C 00 BF 8F 27 18 10 00 21 10 00 00 0B 10 03 02 28 00 BE 8F 24 00 B7 8F 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 E0 03 30 00 BD 27 ?? ?? ?? 0? 21 20 00 00 ?? ?? 03 3C ?? ?? 62 8C FB FF 40 18 00 00 00 00 CE FF 00 12 ?? ?? C5 8E ?? ?? ?? 0? 00 00 00 00 ?? ?? 04 3C ?? ?? 84 24 ?? ?? ?? 0? FF FF 07 24 ?? ?? 42 8E ?? ?? 23 8E 2A 10 62 00 CC FF 40 54 ?? ?? 57 AE ?? ?? ?? 0? 00 00 00 00 ?? ?? 02 3C ?? ?? 44 8C ?? ?? 02 3C ?? ?? 03 3C ?? ?? 4B 8C ?? ?? 67 8C 00 00 8A 8C 00 00 A5 8F 01 00 6B 25 23 58 67 01 21 30 00 00 21 40 00 00 ?? ?? ?? 0? 21 48 E0 00 ?? ?? ?? 0? ?? ?? 57 AE }
	condition:
		$1
}

rule file_19_9_0 {
	meta:
		name = "play_memory_fli"
		size = 100
		refs = "001c open_memory_fli 005c .text"
	strings:
		$1 = { F0 FF BD 27 08 00 B2 AF 04 00 B1 AF 00 00 B0 AF 0C 00 BF AF 21 80 A0 00 21 88 C0 00 ?? ?? ?? 0? 21 90 E0 00 07 00 40 10 0C 00 BF 8F FE FF 02 24 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 10 00 BD 27 21 20 00 02 21 28 20 02 21 30 40 02 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F ?? ?? ?? 0? 10 00 BD 27 }
	condition:
		$1
}

rule file_19_10_0 {
	meta:
		name = "play_fli"
		size = 100
		refs = "001c open_fli 005c .text"
	strings:
		$1 = { F0 FF BD 27 08 00 B2 AF 04 00 B1 AF 00 00 B0 AF 0C 00 BF AF 21 80 A0 00 21 88 C0 00 ?? ?? ?? 0? 21 90 E0 00 07 00 40 10 0C 00 BF 8F FE FF 02 24 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 10 00 BD 27 21 20 00 02 21 28 20 02 21 30 40 02 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F ?? ?? ?? 0? 10 00 BD 27 }
	condition:
		$1
}

rule file_20_0_0 {
	meta:
		name = "qsort_helper_ITEM"
		size = 16
	strings:
		$1 = { 04 00 A3 8C 04 00 82 8C 08 00 E0 03 23 10 62 00 }
	condition:
		$1
}

rule file_20_1_0 {
	meta:
		name = "insert_node"
		size = 208
		refs = "0018 .bss 003c .text 00bc _al_malloc"
	strings:
		$1 = { 07 04 02 24 02 00 40 14 1A 00 82 00 CD 01 00 00 0C 00 02 24 F0 FF BD 27 ?? ?? 03 3C 04 00 B0 AF 21 80 80 00 ?? ?? 64 8C 0C 00 BF AF 08 00 B1 AF 10 28 00 00 18 00 A2 00 12 10 00 00 ?? ?? ?? 0? 21 28 82 00 0D 00 40 50 08 00 A2 8C 21 28 40 00 04 00 A2 8C FB FF 50 54 00 00 A2 8C 08 00 A2 8C 01 00 42 24 08 00 A2 AC 0C 00 BF 8F 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 10 00 BD 27 0F 00 40 14 21 88 A0 00 F8 FF A0 10 ?? ?? 04 3C ?? ?? 83 8C 0C 00 BF 8F 01 00 02 24 01 00 63 24 04 00 B0 AC 08 00 A2 AC 08 00 B1 8F 04 00 B0 8F ?? ?? 83 AC 00 00 A0 AC 08 00 E0 03 10 00 BD 27 ?? ?? ?? 0? 0C 00 04 24 21 28 40 00 ?? ?? ?? 0? 00 00 22 AE }
	condition:
		$1
}

rule file_20_2_0 {
	meta:
		name = "generate_optimized_palette"
		size = 2408
		refs = "0324 .bss 0058 _al_malloc 0174 .text 0200 _al_free 0318 qsort 034c _rgb_r_shift_15 0354 _rgb_g_shift_15 0358 _rgb_b_shift_15 08a8 _rgb_r_shift_32 08b0 _rgb_g_shift_32 08b4 _rgb_b_shift_32 08e0 _rgb_g_shift_16 08e8 _rgb_r_shift_16 08ec _rgb_b_shift_16 0900 _rgb_r_shift_24 0908 _rgb_g_shift_24 090c _rgb_b_shift_24"
	strings:
		$1 = { 1C 00 82 8C C8 FE BD 27 30 01 BE AF 00 00 42 8C 14 01 B1 AF 34 01 BF AF 04 01 A2 AF 04 01 A3 8F ?? ?? 02 3C ?? ?? 40 AC 08 00 02 24 2C 01 B7 AF 28 01 B6 AF 24 01 B5 AF 20 01 B4 AF 1C 01 B3 AF 18 01 B2 AF 10 01 B0 AF 21 88 80 00 08 01 A5 AF 06 00 62 10 21 F0 C0 00 ?? ?? ?? 0? 54 30 04 24 ?? ?? 13 3C 0E 00 40 14 ?? ?? 62 AE 21 10 00 00 34 01 BF 8F 30 01 BE 8F 2C 01 B7 8F 28 01 B6 8F 24 01 B5 8F 20 01 B4 8F 1C 01 B3 8F 18 01 B2 8F 14 01 B1 8F 10 01 B0 8F 08 00 E0 03 38 01 BD 27 21 18 00 00 FF FF 05 24 54 30 04 24 ?? ?? 62 8E 21 10 43 00 0C 00 63 24 08 00 40 AC 00 00 40 AC FA FF 64 14 04 00 45 AC 1A 01 C0 13 21 18 00 00 21 A0 00 00 21 A8 00 00 00 01 04 24 21 10 C3 03 00 00 42 80 04 00 40 10 01 00 63 24 02 00 40 18 01 00 94 26 01 00 B5 26 F9 FF 64 14 21 10 C3 03 08 01 A2 8F 21 30 00 00 00 01 07 24 00 01 A2 AF 21 28 40 00 00 00 A2 90 01 00 A3 90 02 00 A4 90 3F 00 42 30 3F 00 63 30 3F 00 84 30 01 00 C6 24 00 00 A2 A0 01 00 A3 A0 02 00 A4 A0 F5 FF C7 14 04 00 A5 24 04 01 A3 8F 10 00 02 24 DF 00 62 10 11 00 62 28 09 00 40 14 0F 00 02 24 04 01 A5 8F 18 00 02 24 B5 00 A2 10 20 00 02 24 28 00 A2 50 04 00 24 8E ?? ?? ?? 0? FF FF 02 24 BC FF 62 54 FF FF 02 24 04 00 24 8E 16 00 80 18 21 90 20 02 00 00 23 8E 21 B0 00 00 0F 00 60 58 01 00 D6 26 21 80 00 00 40 00 42 8E 40 18 10 00 01 00 10 26 21 10 43 00 00 00 44 94 ?? ?? ?? 0? DE 7B 84 30 00 00 23 8E 2A 10 03 02 F7 FF 40 54 40 00 42 8E 04 00 24 8E 01 00 D6 26 2A 10 C4 02 EE FF 40 14 04 00 52 26 ?? ?? 03 3C ?? ?? 64 8C 21 20 A4 02 ?? ?? ?? 0? C0 20 04 00 20 00 40 14 21 B8 40 00 ?? ?? ?? 0? ?? ?? 64 8E ?? ?? ?? 0? 21 10 00 00 F4 FF 80 18 F0 00 02 3C 00 00 23 8E F0 F0 57 34 21 90 20 02 21 B0 00 00 0F 00 60 58 01 00 D6 26 21 80 00 00 40 00 42 8E 80 18 10 00 01 00 10 26 21 10 43 00 00 00 44 8C ?? ?? ?? 0? 24 20 97 00 00 00 23 8E 2A 10 03 02 F7 FF 40 54 40 00 42 8E 04 00 24 8E 01 00 D6 26 2A 10 C4 02 EE FF 40 14 04 00 52 26 ?? ?? ?? 0? ?? ?? 03 3C 21 88 A0 02 21 90 00 00 54 30 16 24 ?? ?? 62 8E 21 28 52 00 08 00 A3 8C 15 00 60 50 0C 00 52 26 C0 10 11 00 21 20 E2 02 04 00 A2 8C 01 00 31 26 00 00 82 AC 08 00 A3 8C 00 00 A5 8C 04 00 83 AC F9 FF A0 14 08 00 84 24 ?? ?? 62 8E 21 10 52 00 00 00 44 8C 06 00 80 50 0C 00 52 26 ?? ?? ?? 0? 00 00 90 8C FD FF 00 16 21 20 00 02 0C 00 52 26 E7 FF 56 16 ?? ?? 62 8E ?? ?? 64 8E ?? ?? ?? 0? ?? ?? 16 3C ?? ?? 03 3C C0 10 15 00 ?? ?? 65 8C 21 80 E2 02 08 00 06 24 21 20 00 02 ?? ?? ?? 0? ?? ?? C7 26 04 01 A3 8F ?? ?? 05 3C 10 00 02 24 6C 01 62 10 ?? ?? A6 8C 11 00 62 28 56 01 40 50 04 01 A5 8F 0F 00 02 24 4A FF 62 14 FF FF 02 24 ?? ?? 02 3C ?? ?? 4A 8C ?? ?? 03 3C ?? ?? 02 3C ?? ?? 69 8C ?? ?? 48 8C 21 58 A6 02 2A 60 AB 02 15 00 80 11 00 01 A2 26 21 30 00 02 21 38 A0 02 00 00 C3 8C 01 00 E7 24 2A 28 EB 00 07 10 23 01 07 20 43 01 1F 00 42 30 1F 00 84 30 07 18 03 01 40 12 02 00 40 20 04 00 1F 00 63 30 25 10 44 00 40 1C 03 00 25 10 43 00 00 00 C2 AC F0 FF A0 14 08 00 C6 24 00 01 A2 26 23 A0 54 00 2A 18 8B 02 6A 00 60 14 21 90 60 01 2A 10 B2 02 13 00 40 10 21 30 C0 03 00 00 C3 80 C0 10 15 00 21 10 E2 02 09 00 60 14 01 00 C6 24 00 00 42 8C 00 01 A5 8F 01 00 B5 26 03 24 02 00 03 1A 02 00 01 00 A3 A0 02 00 A4 A0 00 00 A2 A0 00 01 A3 8F 2A 10 B2 02 04 00 63 24 EF FF 40 14 00 01 A3 AF ?? ?? ?? 0? 21 20 E0 02 ?? ?? 05 3C ?? ?? ?? 0? ?? ?? A2 8C 04 00 24 8E 68 FF 80 18 21 90 20 02 00 00 23 8E 21 B0 00 00 03 00 17 24 18 00 60 58 01 00 D6 26 21 80 00 00 18 00 17 02 40 00 42 8E 01 00 10 26 12 18 00 00 21 10 43 00 01 00 44 90 02 00 43 90 00 00 45 90 00 22 04 00 00 1C 03 00 25 20 83 00 F0 00 02 3C F0 F0 42 34 25 20 85 00 ?? ?? ?? 0? 24 20 82 00 00 00 23 8E 2A 10 03 02 EE FF 40 14 18 00 17 02 04 00 24 8E 01 00 D6 26 2A 10 C4 02 E5 FF 40 14 04 00 52 26 ?? ?? ?? 0? ?? ?? 03 3C 04 00 24 8E 44 FF 80 18 21 90 20 02 00 00 23 8E 21 B0 00 00 0F 00 60 58 01 00 D6 26 21 80 00 00 40 00 42 8E 40 18 10 00 01 00 10 26 21 10 43 00 00 00 44 94 ?? ?? ?? 0? 9E F7 84 30 00 00 23 8E 2A 10 03 02 F7 FF 40 54 40 00 42 8E 04 00 24 8E 01 00 D6 26 2A 10 C4 02 EE FF 40 14 04 00 52 26 ?? ?? ?? 0? ?? ?? 03 3C 08 01 A5 8F 3F 00 03 24 01 00 02 24 02 00 A3 A0 00 00 A2 A3 00 00 A3 A0 01 00 A0 A0 01 00 A2 27 00 01 A3 27 00 00 40 A0 01 00 42 24 FE FF 62 54 00 00 40 A0 01 00 15 24 01 00 14 24 ?? ?? ?? 0? 21 F0 A0 03 EB 00 A0 12 21 30 00 00 08 01 A5 8F 21 38 C0 03 00 00 E3 80 C0 10 06 00 01 00 E7 24 0A 00 60 18 21 40 E2 02 01 00 A2 90 02 00 A3 90 00 00 A4 90 00 12 02 00 00 1C 03 00 25 10 43 00 25 10 44 00 00 00 02 AD 01 00 C6 24 2A 10 D5 00 F0 FF 40 14 04 00 A5 24 E2 00 80 11 3C 00 02 3C 21 20 00 02 3C 3C 48 34 21 38 A0 02 21 90 A0 02 0F 00 A0 1A 00 00 86 8C 00 00 E2 8E 24 10 48 00 10 00 C2 50 01 00 E7 24 21 28 E0 02 ?? ?? ?? 0? 21 18 00 00 24 10 48 00 09 00 C2 10 08 00 A5 24 01 00 63 24 2A 10 75 00 FA FF 40 54 08 00 A2 8C C0 10 12 00 21 10 E2 02 00 00 46 AC 01 00 52 26 01 00 E7 24 2A 10 EB 00 E9 FF 40 14 08 00 84 24 2A 10 92 02 63 FF 40 10 2A 10 B2 02 05 00 02 24 02 00 40 14 1A 00 82 02 CD 01 00 00 F0 FF 84 26 F7 FF 83 26 12 10 00 00 23 10 82 02 2C 88 44 00 2A 18 23 02 02 00 60 14 2C 88 35 02 21 88 A0 02 2A 10 32 02 A9 00 40 10 21 70 20 02 C0 98 11 00 21 80 F3 02 21 68 00 02 23 00 20 1A E8 03 03 24 00 00 A2 8D 21 48 E0 02 21 40 00 00 FF 00 4C 30 00 3C 4B 7C 00 3A 4A 7C ?? ?? ?? 0? E8 03 07 24 21 18 E0 00 01 00 08 25 2A 10 11 01 16 00 40 10 08 00 29 25 21 38 60 00 00 00 22 8D 00 3A 43 7C 00 3C 44 7C 23 18 43 01 23 20 64 01 FF 00 42 30 23 10 82 01 23 28 03 00 23 30 04 00 2C 18 65 00 2C 20 86 00 23 28 02 00 21 18 64 00 2C 10 45 00 21 18 62 00 2A 20 67 00 E9 FF 80 10 09 00 62 28 E9 FF 40 50 01 00 08 25 01 00 CE 25 2A 10 D2 01 04 00 A3 AD D8 FF 40 14 08 00 AD 25 21 20 00 02 ?? ?? C7 26 23 28 51 02 ?? ?? ?? 0? 08 00 06 24 04 00 04 8E 09 00 82 28 80 00 40 14 01 00 22 26 C0 10 02 00 21 10 E2 02 04 00 43 24 ?? ?? ?? 0? 21 60 20 02 09 00 42 28 06 00 40 14 08 00 63 24 01 00 8C 25 2A 10 92 01 FA FF 40 54 00 00 62 8C 21 60 40 02 2A 10 34 02 4E 00 40 10 09 00 82 28 0B FF 40 14 21 90 80 02 01 00 30 26 C0 10 10 00 21 90 F3 02 21 58 20 02 21 98 E2 02 C0 10 0B 00 21 10 E2 02 00 00 44 8E 00 00 46 8C 04 00 43 8E 2A 28 0C 02 00 00 44 AC 04 00 43 AC 3B 00 A0 10 00 00 46 AE FF 00 CF 30 21 40 60 02 21 48 00 02 FF FF 0A 24 00 3A CE 7C 00 3C CD 7C 00 00 02 8D 04 00 07 8D 00 3A 43 7C 00 3C 44 7C 23 18 C3 01 23 20 A4 01 FF 00 42 30 23 10 E2 01 23 28 03 00 23 30 04 00 2C 18 65 00 2C 20 86 00 23 28 02 00 21 18 64 00 2C 10 45 00 21 18 62 00 2A 20 67 00 04 00 80 10 2A 10 47 01 04 00 03 AD 21 38 60 00 2A 10 47 01 0B 58 22 01 01 00 29 25 0A 38 42 01 2A 18 2C 01 21 50 E0 00 E4 FF 60 14 08 00 08 25 2A 10 14 02 17 00 40 10 09 00 E2 28 08 00 52 26 14 00 40 14 08 00 73 26 ?? ?? ?? 0? 01 00 10 26 18 00 02 24 19 00 A2 10 20 00 02 24 F3 FD A2 14 FF FF 02 24 ?? ?? 02 3C ?? ?? 44 8C ?? ?? 03 3C ?? ?? 02 3C ?? ?? 65 8C ?? ?? 43 8C 03 00 8A 24 03 00 A9 24 ?? ?? ?? 0? 03 00 68 24 ?? ?? ?? 0? FF FF 07 24 ?? ?? ?? 0? 21 90 80 02 ?? ?? 02 3C ?? ?? 44 8C ?? ?? 03 3C ?? ?? 02 3C ?? ?? 6A 8C 01 00 89 24 ?? ?? ?? 0? ?? ?? 48 8C ?? ?? 02 3C ?? ?? 44 8C ?? ?? 03 3C ?? ?? 02 3C ?? ?? 65 8C ?? ?? 43 8C 03 00 8A 24 03 00 A9 24 ?? ?? ?? 0? 03 00 68 24 ?? ?? ?? 0? 21 90 60 01 C0 98 11 00 21 80 F3 02 21 20 00 02 ?? ?? C7 26 23 28 51 02 ?? ?? ?? 0? 08 00 06 24 04 00 04 8E ?? ?? ?? 0? 21 60 40 02 ?? ?? ?? 0? 21 90 A0 02 ?? ?? ?? 0? 21 60 20 02 }
	condition:
		$1
}

rule file_21_0_0 {
	meta:
		name = "font_find_character"
		size = 676
		refs = "0030 _bitmap_has_alpha 0058 .text 0218 makecol_depth"
	strings:
		$1 = { E0 FF BD 27 18 00 B5 AF 14 00 B4 AF 10 00 B3 AF 08 00 B1 AF 04 00 B0 AF 1C 00 BF AF 0C 00 B2 AF 21 88 A0 00 21 98 C0 00 21 A0 E0 00 21 A8 00 01 ?? ?? ?? 0? 21 80 80 00 90 00 40 14 08 00 02 24 1C 00 03 8E 00 00 64 8C 72 00 82 54 FF 00 06 24 00 00 66 8E FF 00 12 24 ?? ?? ?? 0? 00 00 25 8E 01 00 45 24 00 00 25 AE 00 00 02 8E 2A 10 A2 00 6F 00 40 50 00 00 20 AE 00 00 66 8E 1C 00 03 8E 20 00 63 8C 09 F8 60 00 21 20 00 02 F4 FF 52 54 00 00 22 8E 1C 00 02 8E 00 00 25 8E 00 00 66 8E 20 00 43 8C 01 00 A5 24 09 F8 60 00 21 20 00 02 EB FF 52 54 00 00 22 8E 1C 00 02 8E 00 00 66 8E 00 00 25 8E 20 00 43 8C 01 00 C6 24 09 F8 60 00 21 20 00 02 E2 FF 52 54 00 00 22 8E 1C 00 02 8E 00 00 25 8E 00 00 66 8E 20 00 43 8C 01 00 A5 24 01 00 C6 24 09 F8 60 00 21 20 00 02 D8 FF 52 50 00 00 22 8E 00 00 80 AE ?? ?? ?? 0? 21 38 00 00 1C 00 02 8E 00 00 25 8E 00 00 83 8E 00 00 66 8E 20 00 47 8C 01 00 A5 24 21 28 A3 00 09 F8 E0 00 01 00 C6 24 15 00 52 50 00 00 A0 AE 00 00 82 8E 00 00 23 8E 00 00 04 8E 01 00 47 24 21 10 43 00 2A 10 44 00 0D 00 40 50 00 00 A0 AE 00 00 87 AE 1C 00 02 8E 00 00 25 8E 00 00 66 8E 20 00 43 8C 01 00 A5 24 21 20 00 02 09 F8 60 00 21 28 A7 00 E3 FF 52 10 21 20 00 02 00 00 A0 AE ?? ?? ?? 0? 21 38 00 00 1C 00 03 8E 00 00 66 8E 00 00 25 8E 00 00 A2 8E 20 00 67 8C 01 00 C6 24 21 30 C2 00 09 F8 E0 00 01 00 A5 24 28 00 52 10 1C 00 BF 8F 00 00 A2 8E 00 00 63 8E 04 00 04 8E 01 00 47 24 21 10 43 00 2A 10 44 00 21 00 40 50 18 00 B5 8F 00 00 A7 AE 1C 00 02 8E 00 00 66 8E 00 00 25 8E 20 00 43 8C 01 00 C6 24 21 20 00 02 09 F8 60 00 21 30 C7 00 E3 FF 52 10 21 20 00 02 ?? ?? ?? 0? 1C 00 BF 8F FF 00 05 24 ?? ?? ?? 0? 21 38 00 00 21 90 40 00 1C 00 03 8E ?? ?? ?? 0? 00 00 66 8E 00 00 62 8E 01 00 46 24 00 00 66 AE 04 00 02 8E 2A 10 C2 00 03 00 40 50 00 00 80 AE ?? ?? ?? 0? 1C 00 03 8E 00 00 A0 AE 1C 00 BF 8F 18 00 B5 8F 14 00 B4 8F 10 00 B3 8F 0C 00 B2 8F 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 20 00 BD 27 1C 00 02 8E 21 30 00 00 21 20 00 02 20 00 43 8C 09 F8 60 00 21 28 00 00 21 90 40 00 1C 00 03 8E ?? ?? ?? 0? 00 00 66 8E }
	condition:
		$1
}

rule file_21_1_0 {
	meta:
		name = "grab_font_from_bitmap"
		size = 1392
		refs = "0010 .bss 0044 _al_malloc 0060 .text 02d4 font_vtable_mono 039c create_bitmap_ex 044c blit 047c font_vtable_color 04e4 _al_free"
	strings:
		$1 = { B0 FF BD 27 40 00 B6 AF 3C 00 B5 AF 34 00 B3 AF ?? ?? 15 3C 21 98 80 00 ?? ?? 16 3C 0C 00 04 24 28 00 B0 AF 4C 00 BF AF 48 00 BE AF 44 00 B7 AF 38 00 B4 AF 30 00 B2 AF 2C 00 B1 AF ?? ?? A0 AE ?? ?? C0 AE ?? ?? ?? 0? 14 00 A0 AF 1C 00 A2 AF 00 00 A0 AF 04 00 A0 AF 08 00 A0 AF 0C 00 A0 AF ?? ?? ?? 0? 04 00 B0 27 0F 00 40 18 14 00 A2 8F 01 00 42 24 14 00 A2 AF 00 00 A2 8F 21 10 43 00 00 00 A2 AF 21 20 60 02 21 28 A0 03 21 30 00 02 08 00 A7 27 ?? ?? ?? 0? 0C 00 A8 27 08 00 A3 8F F1 FF 60 1C 0C 00 A2 8F 14 00 A3 8F 04 00 64 8E 20 00 63 24 20 00 80 18 20 00 A3 AF 00 00 63 8E FF FF 12 24 21 88 00 00 FF 00 14 24 17 00 60 58 01 00 31 26 21 80 00 00 1C 00 62 8E 21 28 00 02 21 20 60 02 20 00 43 8C 21 30 20 02 09 F8 60 00 01 00 10 26 08 00 40 50 00 00 63 8E 06 00 54 50 00 00 63 8E 03 00 40 5A 21 90 40 00 8D 00 52 14 21 90 40 00 00 00 63 8E 2A 10 03 02 EF FF 40 54 1C 00 62 8E 04 00 64 8E 01 00 31 26 2A 10 24 02 E6 FF 40 14 00 00 00 00 ?? ?? ?? 0? 10 00 04 24 18 00 A2 AF 14 00 A2 8F ?? ?? ?? 0? 80 20 02 00 18 00 A4 8F 21 18 40 00 08 00 82 AC 14 00 A2 8F 5B 00 40 10 01 00 02 24 08 00 A2 AF 0C 00 A2 AF 21 A0 60 00 10 00 A0 AF 80 00 17 24 0C 00 A2 8F EC 00 40 18 08 00 A2 8F EA 00 40 18 ?? ?? 05 3C ?? ?? 06 3C 21 20 60 02 ?? ?? A5 24 ?? ?? C6 24 0C 00 A7 27 ?? ?? ?? 0? 08 00 A8 27 0C 00 A2 8F E0 00 40 18 08 00 A3 8F DE 00 60 18 07 00 42 24 C3 F0 02 00 18 00 C3 03 12 20 00 00 ?? ?? ?? 0? 04 00 84 24 08 00 A6 8F 0C 00 A3 8F 00 00 82 AE 18 00 C6 03 02 00 46 A4 12 28 00 00 09 00 A0 18 00 00 43 A4 21 20 00 00 00 00 82 8E 21 10 44 00 01 00 84 24 2A 18 85 00 FB FF 60 14 04 00 40 A0 0C 00 A3 8F 25 00 C0 18 ?? ?? A2 8E 21 88 00 00 21 90 00 00 1C 00 60 18 08 00 A2 8F 21 80 00 00 1C 00 62 8E ?? ?? A5 8E ?? ?? C6 8E 20 00 47 8C 01 00 A5 24 01 00 C6 24 21 28 B0 00 21 20 60 02 09 F8 E0 00 21 30 D1 00 C3 18 10 00 07 00 04 32 21 28 72 00 01 00 10 26 06 00 40 10 07 20 97 00 00 00 83 8E 21 18 65 00 04 00 62 90 25 10 44 00 04 00 62 A0 0C 00 A3 8F 2A 10 03 02 E9 FF 40 54 1C 00 62 8E 08 00 A2 8F 01 00 31 26 2A 10 22 02 E0 FF 40 14 21 90 5E 02 ?? ?? A2 8E 21 10 62 00 ?? ?? A2 AE 10 00 A2 8F 14 00 A3 8F 01 00 42 24 10 00 A2 AF 2A 10 43 00 AC FF 40 14 04 00 94 26 18 00 A4 8F ?? ?? 02 3C ?? ?? 43 8C 08 00 85 8C 1C 00 A2 8F 4C 00 BF 8F 00 00 A4 8C 08 00 43 AC 18 00 A3 8F 02 00 85 84 20 00 A4 8F 00 00 43 AC 04 00 45 AC 20 00 02 24 00 00 62 AC 48 00 BE 8F 1C 00 A2 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 0C 00 60 AC 04 00 64 AC 08 00 E0 03 50 00 BD 27 ?? ?? ?? 0? 10 00 04 24 21 90 40 00 14 00 A2 8F ?? ?? ?? 0? 80 20 02 00 14 00 A4 8F 01 00 03 24 08 00 42 AE 43 00 80 10 08 00 A3 AF ?? ?? B4 26 0C 00 A3 AF ?? ?? D5 26 21 88 40 00 21 80 00 00 ?? ?? 16 3C ?? ?? ?? 0? ?? ?? 17 3C 1C 00 62 8E 08 00 05 24 08 00 06 24 ?? ?? ?? 0? 00 00 44 8C 21 20 40 00 FF 00 05 24 4D 00 40 10 00 00 22 AE 1C 00 42 8C 01 00 10 26 A0 00 43 8C 09 F8 60 00 04 00 31 26 14 00 A3 8F 2A 10 03 02 2A 00 40 50 08 00 45 8E 08 00 A2 8F EC FF 40 18 0C 00 A2 8F 08 00 A7 27 0C 00 A8 27 21 20 60 02 21 28 80 02 E6 FF 40 18 21 30 A0 02 ?? ?? ?? 0? 00 00 00 00 08 00 A5 8F E1 FF A0 18 0C 00 A6 8F E0 FF C0 18 1C 00 62 8E ?? ?? ?? 0? 00 00 44 8C 21 28 40 00 21 20 60 02 21 40 00 00 21 48 00 00 2C 00 40 10 00 00 22 AE ?? ?? C6 8E ?? ?? E7 8E 08 00 AA 8F 0C 00 AB 8F 01 00 C6 24 ?? ?? ?? 0? 01 00 E7 24 ?? ?? C3 8E 08 00 A2 8F 01 00 10 26 21 10 43 00 14 00 A3 8F ?? ?? C2 AE 2A 10 03 02 D9 FF 40 14 04 00 31 26 08 00 45 8E ?? ?? 02 3C ?? ?? 43 8C 00 00 A4 8C 1C 00 A2 8F 4C 00 BF 8F 04 00 85 8C 08 00 43 AC 20 00 A3 8F 04 00 45 AC 00 00 52 AC 20 00 02 24 00 00 42 AE 0C 00 40 AE 1C 00 A2 8F 04 00 43 AE 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 50 00 BD 27 ?? ?? ?? 0? 08 00 44 8E ?? ?? ?? 0? 21 20 40 02 ?? ?? ?? 0? 1C 00 A4 8F 4C 00 BF 8F 1C 00 A0 AF 1C 00 A2 8F 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 50 00 BD 27 ?? ?? ?? 0? 0C 00 04 24 08 00 03 24 02 00 43 A4 00 00 43 A4 00 00 82 AE 21 18 00 00 00 00 82 8E 08 00 04 24 21 10 43 00 01 00 63 24 FB FF 64 14 04 00 40 A0 ?? ?? ?? 0? 10 00 A2 8F }
	condition:
		$1
}

rule file_21_2_0 {
	meta:
		name = "load_bitmap_font"
		size = 156
		refs = "0018 get_color_conversion 0028 set_color_conversion 0034 load_bitmap 0050 grab_font_from_bitmap 005c destroy_bitmap"
	strings:
		$1 = { F0 FF BD 27 0C 00 BF AF 08 00 B2 AF 04 00 B1 AF 00 00 B0 AF 21 88 A0 00 ?? ?? ?? 0? 21 80 80 00 0E 04 04 3C E0 EE 84 34 ?? ?? ?? 0? 21 90 40 00 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 21 80 40 00 ?? ?? ?? 0? 21 20 40 02 0D 00 00 12 0C 00 BF 8F ?? ?? ?? 0? 21 20 00 02 21 20 00 02 ?? ?? ?? 0? 21 88 40 00 0C 00 BF 8F 21 10 20 02 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 10 00 BD 27 21 88 00 00 21 10 20 02 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 10 00 BD 27 }
	condition:
		$1
}

rule file_22_0_0 {
	meta:
		name = "_stub_bank_switch"
		size = 20
	strings:
		$1 = { 10 00 A5 24 80 28 05 00 21 20 85 00 08 00 E0 03 00 00 82 8C }
	condition:
		$1
}

rule file_22_3_0 {
	meta:
		name = "apply_matrix_f"
		size = 136
	strings:
		$1 = { 00 00 81 C4 04 00 82 C4 08 00 80 C4 42 60 01 46 82 68 02 46 02 70 00 46 24 00 83 C4 40 08 02 46 40 08 00 46 40 08 03 46 00 00 A1 E4 0C 00 80 C4 10 00 81 C4 14 00 82 C4 02 60 00 46 42 68 01 46 82 70 02 46 28 00 83 C4 00 00 01 46 00 00 02 46 00 00 03 46 00 00 C0 E4 1C 00 80 C4 18 00 81 C4 20 00 82 C4 42 6B 00 46 02 63 01 46 82 73 02 46 2C 00 80 C4 00 63 0D 46 00 63 0E 46 00 63 00 46 08 00 E0 03 00 00 EC E4 }
	condition:
		$1
}

rule file_23_0_0 {
	meta:
		name = "save_tga_pf"
		size = 1608
		refs = "004c allegro_errno 0060 pack_putc 0094 pack_iputw 00f4 _bitmap_has_alpha 0130 .rodata 0168 .text 0110 _rgb_scale_6 021c pack_fwrite 0268 _rgb_b_shift_32 026c _rgb_g_shift_32 0270 _rgb_r_shift_32 0278 _rgb_a_shift_32 0340 _rgb_b_shift_24 0344 _rgb_g_shift_24 034c _rgb_r_shift_24 03f0 _rgb_scale_5 040c _rgb_g_shift_16 0414 _rgb_r_shift_16 0408 _rgb_b_shift_16 0500 _rgb_g_shift_15 0508 _rgb_r_shift_15 04fc _rgb_b_shift_15 0638 get_palette"
	strings:
		$1 = { C8 F8 BD 27 20 07 B4 AF 1C 07 B3 AF 18 07 B2 AF 34 07 BF AF 30 07 BE AF 2C 07 B7 AF 28 07 B6 AF 24 07 B5 AF 14 07 B1 AF 10 07 B0 AF 21 A0 C0 00 21 98 80 00 7F 01 C0 10 21 90 A0 00 1C 00 42 8E 0F 00 03 24 00 00 51 8C 78 00 23 12 ?? ?? 02 3C 08 07 A2 AF ?? ?? 42 8C 21 20 00 00 21 28 60 02 ?? ?? ?? 0? 00 00 40 AC 08 00 24 3A 01 00 84 2C ?? ?? ?? 0? 21 28 60 02 08 00 03 24 32 00 23 52 01 00 04 24 02 00 04 24 ?? ?? ?? 0? 21 28 60 02 21 20 00 00 ?? ?? ?? 0? 21 28 60 02 21 20 00 00 ?? ?? ?? 0? 21 28 60 02 21 20 00 00 ?? ?? ?? 0? 21 28 60 02 21 20 00 00 ?? ?? ?? 0? 21 28 60 02 21 20 00 00 ?? ?? ?? 0? 21 28 60 02 00 00 44 8E 21 28 60 02 ?? ?? ?? 0? 08 00 10 24 04 00 44 8E ?? ?? ?? 0? 21 28 60 02 21 28 60 02 ?? ?? ?? 0? 21 20 20 02 ?? ?? ?? 0? 21 20 40 02 21 20 00 00 0B 20 02 02 ?? ?? ?? 0? 21 28 60 02 2B 00 30 12 ?? ?? 02 3C 1C 00 42 8E 00 00 43 8C F8 FF 63 24 19 00 62 2C 15 00 40 50 08 07 A3 8F 80 10 03 00 ?? ?? 03 3C ?? ?? 63 24 21 18 62 00 00 00 64 8C 08 00 80 00 00 00 00 00 ?? ?? ?? 0? 21 28 60 02 21 20 00 00 ?? ?? ?? 0? 21 28 60 02 00 01 04 24 ?? ?? ?? 0? 21 28 60 02 ?? ?? ?? 0? 18 00 04 24 1B 01 80 16 FF FF 31 26 08 07 A3 8F 34 07 BF 8F 30 07 BE 8F ?? ?? 62 8C 2C 07 B7 8F 28 07 B6 8F 00 00 43 8C FF FF 02 24 24 07 B5 8F 0A 10 03 00 20 07 B4 8F 1C 07 B3 8F 18 07 B2 8F 14 07 B1 8F 10 07 B0 8F 08 00 E0 03 38 07 BD 27 21 30 80 02 ?? ?? 45 24 02 00 A4 27 02 03 A7 27 00 00 C2 90 80 10 02 00 21 10 A2 00 00 00 43 8C 00 00 83 A0 01 00 C2 90 80 10 02 00 21 10 A2 00 00 00 43 8C FF FF 83 A0 02 00 C2 90 80 10 02 00 21 10 A2 00 00 00 43 8C FE FF 83 A0 03 00 84 24 EF FF E4 14 04 00 C6 24 21 20 A0 03 00 03 05 24 ?? ?? ?? 0? 21 30 60 02 ?? ?? ?? 0? 1C 00 42 8E 08 07 A2 AF ?? ?? 42 8C 21 20 00 00 21 28 60 02 ?? ?? ?? 0? 00 00 40 AC 21 20 00 00 ?? ?? ?? 0? 21 28 60 02 ?? ?? ?? 0? 10 00 11 24 04 00 46 8E C6 FF C0 10 FF FF D4 24 00 00 43 8E ?? ?? 1E 3C ?? ?? 17 3C ?? ?? 16 3C 28 00 60 18 ?? ?? 15 3C 04 07 B4 AF 21 88 00 00 1C 00 42 8E 21 30 80 02 21 28 20 02 20 00 43 8C 21 20 40 02 09 F8 60 00 01 00 31 26 ?? ?? C4 8F 21 28 60 02 21 80 40 00 07 20 82 00 ?? ?? ?? 0? FF 00 84 30 ?? ?? E4 8E 21 28 60 02 07 20 90 00 ?? ?? ?? 0? FF 00 84 30 ?? ?? C4 8E 21 28 60 02 07 20 90 00 ?? ?? ?? 0? FF 00 84 30 ?? ?? A3 8E 21 28 60 02 07 80 70 00 ?? ?? ?? 0? FF 00 04 32 00 00 43 8E 2A 10 23 02 E2 FF 40 54 1C 00 42 8E 04 07 A2 8F 9B FF 40 10 FF FF 94 26 DB FF 60 5C 04 07 B4 AF 04 07 B4 AF 04 07 A2 8F FB FF 40 14 FF FF 94 26 ?? ?? ?? 0? 08 07 A3 8F 04 00 46 8E 90 FF C0 10 FF FF D4 24 00 00 43 8E ?? ?? 17 3C ?? ?? 16 3C 22 00 60 18 ?? ?? 15 3C 21 F0 80 02 21 88 00 00 1C 00 42 8E 21 30 80 02 21 28 20 02 20 00 43 8C 21 20 40 02 09 F8 60 00 01 00 31 26 ?? ?? E4 8E 21 28 60 02 21 80 40 00 07 20 82 00 ?? ?? ?? 0? FF 00 84 30 ?? ?? C4 8E 21 28 60 02 07 20 90 00 ?? ?? ?? 0? FF 00 84 30 ?? ?? A3 8E 21 28 60 02 07 80 70 00 ?? ?? ?? 0? FF 00 04 32 00 00 43 8E 2A 10 23 02 E7 FF 40 54 1C 00 42 8E 6C FF C0 13 FF FF 94 26 E1 FF 60 1C 21 F0 80 02 21 F0 80 02 FC FF C0 17 FF FF 94 26 ?? ?? ?? 0? 08 07 A3 8F 04 00 46 8E 62 FF C0 10 ?? ?? 03 3C ?? ?? 74 24 00 00 43 8E ?? ?? 02 3C FF FF D1 24 ?? ?? 5E 24 ?? ?? 17 3C ?? ?? 16 3C 2E 00 60 18 ?? ?? 15 3C 00 07 B1 AF 21 80 00 00 1C 00 42 8E 21 28 00 02 21 20 40 02 20 00 43 8C 21 30 20 02 09 F8 60 00 01 00 10 26 ?? ?? C3 8E ?? ?? A5 8E ?? ?? E4 8E 07 18 62 00 07 28 A2 00 3F 00 63 30 1F 00 A5 30 07 10 82 00 80 18 03 00 80 28 05 00 21 18 C3 03 21 28 85 02 1F 00 42 30 00 00 64 8C 00 00 A6 8C 80 10 02 00 21 10 82 02 00 00 43 8C 80 20 04 00 C0 31 06 00 00 7C C6 30 E0 03 84 30 C0 20 63 7C 25 20 86 00 25 20 83 00 ?? ?? ?? 0? 21 28 60 02 00 00 43 8E 2A 10 03 02 DC FF 40 54 1C 00 42 8E 00 07 A2 8F 2E FF 40 10 FF FF 31 26 D5 FF 60 5C 00 07 B1 AF 00 07 B1 AF 00 07 A2 8F FB FF 40 14 FF FF 31 26 ?? ?? ?? 0? 08 07 A3 8F 04 00 46 8E 23 FF C0 10 ?? ?? 02 3C 00 00 43 8E FF FF D4 24 ?? ?? 51 24 ?? ?? 17 3C ?? ?? 16 3C 2D 00 60 18 ?? ?? 15 3C 21 F0 80 02 21 80 00 00 1C 00 42 8E 21 28 00 02 21 20 40 02 20 00 43 8C 21 30 80 02 09 F8 60 00 01 00 10 26 ?? ?? C3 8E ?? ?? A5 8E ?? ?? E4 8E 07 18 62 00 07 28 A2 00 1F 00 63 30 1F 00 A5 30 07 10 82 00 80 18 03 00 80 28 05 00 21 18 23 02 21 28 25 02 1F 00 42 30 00 00 64 8C 00 00 A6 8C 80 10 02 00 21 10 22 02 00 00 43 8C 80 20 04 00 C0 31 06 00 00 7C C6 30 E0 03 84 30 C0 20 63 7C 25 20 86 00 25 20 83 00 ?? ?? ?? 0? 21 28 60 02 00 00 43 8E 2A 10 03 02 DC FF 40 54 1C 00 42 8E F2 FE C0 13 FF FF 94 26 D6 FF 60 1C 21 F0 80 02 21 F0 80 02 FC FF C0 17 FF FF 94 26 ?? ?? ?? 0? 08 07 A3 8F 04 00 46 8E E8 FE C0 10 FF FF D1 24 00 00 43 8E E3 FE 60 18 21 A0 20 02 21 80 00 00 1C 00 42 8E 21 28 00 02 21 30 20 02 20 00 43 8C 21 20 40 02 09 F8 60 00 01 00 10 26 21 20 40 00 ?? ?? ?? 0? 21 28 60 02 00 00 43 8E 2A 10 03 02 F4 FF 40 54 1C 00 42 8E EE FF 80 16 FF FF 31 26 ?? ?? ?? 0? 08 07 A3 8F 00 03 B0 27 ?? ?? ?? 0? 21 20 00 02 ?? ?? ?? 0? 21 A0 00 02 }
	condition:
		$1
}

rule file_23_2_0 {
	meta:
		name = "single_tga_read32"
		size = 168
		refs = "0018 pack_getc 0044 _rgb_r_shift_32 0048 _rgb_g_shift_32 0054 _rgb_a_shift_32 005c _rgb_b_shift_32"
	strings:
		$1 = { E8 FF BD 27 08 00 B1 AF 21 88 80 00 14 00 BF AF 10 00 B3 AF 0C 00 B2 AF ?? ?? ?? 0? 04 00 B0 AF 21 20 20 02 ?? ?? ?? 0? 21 98 40 00 21 20 20 02 ?? ?? ?? 0? 21 90 40 00 21 20 20 02 ?? ?? ?? 0? 21 80 40 00 ?? ?? 03 3C ?? ?? 04 3C ?? ?? 67 8C ?? ?? 86 8C ?? ?? 03 3C ?? ?? 64 8C ?? ?? 03 3C FF 00 10 32 FF 00 52 32 ?? ?? 65 8C 04 90 D2 00 04 80 F0 00 14 00 BF 8F 04 10 82 00 25 80 12 02 FF 00 73 32 25 80 02 02 04 98 B3 00 25 10 13 02 10 00 B3 8F 0C 00 B2 8F 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_23_3_0 {
	meta:
		name = "single_tga_read24"
		size = 132
		refs = "0014 pack_getc 0034 _rgb_g_shift_24 0038 _rgb_r_shift_24 0044 _rgb_b_shift_24"
	strings:
		$1 = { F0 FF BD 27 08 00 B2 AF 21 90 80 00 0C 00 BF AF 04 00 B1 AF ?? ?? ?? 0? 00 00 B0 AF 21 20 40 02 ?? ?? ?? 0? 21 88 40 00 21 20 40 02 ?? ?? ?? 0? 21 80 40 00 ?? ?? 03 3C ?? ?? 04 3C ?? ?? 66 8C ?? ?? 85 8C ?? ?? 03 3C ?? ?? 64 8C FF 00 42 30 FF 00 10 32 0C 00 BF 8F 04 10 A2 00 04 80 D0 00 FF 00 31 32 25 80 02 02 04 88 91 00 25 10 11 02 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 10 00 BD 27 }
	condition:
		$1
}

rule file_23_4_0 {
	meta:
		name = "load_tga_pf"
		size = 2352
		refs = "0040 pack_getc 0064 pack_igetw 00cc pack_fread 0158 .text 0288 _color_load_depth 0300 create_bitmap_ex 0310 allegro_errno 0480 _rgb_r_shift_15 0484 _rgb_g_shift_15 0490 _rgb_b_shift_15 086c _fixup_loaded_bitmap 0898 generate_332_palette 08a8 destroy_bitmap"
	strings:
		$1 = { 98 F7 BD 27 4C 08 B3 AF 64 08 BF AF 60 08 BE AF 5C 08 B7 AF 58 08 B6 AF 54 08 B5 AF 50 08 B4 AF 48 08 B2 AF 44 08 B1 AF 40 08 B0 AF 34 08 A5 AF 6D 00 A0 10 21 98 80 00 FF FF 03 24 10 08 A3 AF ?? ?? ?? 0? 21 20 60 02 21 20 60 02 ?? ?? ?? 0? 21 80 40 00 21 20 60 02 ?? ?? ?? 0? FF 00 5E 30 21 20 60 02 ?? ?? ?? 0? 30 08 A2 AF ?? ?? ?? 0? 21 20 60 02 21 20 60 02 ?? ?? ?? 0? FF FF 54 30 21 20 60 02 ?? ?? ?? 0? FF 00 52 30 ?? ?? ?? 0? 21 20 60 02 ?? ?? ?? 0? 21 20 60 02 21 20 60 02 ?? ?? ?? 0? 2C 08 A2 AF 21 20 60 02 ?? ?? ?? 0? 28 08 A2 AF 21 20 60 02 ?? ?? ?? 0? 24 08 A2 AF 21 20 A0 03 FF 00 05 32 21 30 60 02 ?? ?? ?? 0? 20 08 A2 AF 01 00 03 24 1A 00 C3 13 00 00 00 00 0B 00 C0 57 21 90 00 00 30 08 A4 8F FF 00 83 30 07 00 75 30 FF FF A2 26 FF 00 42 30 08 00 63 30 03 00 42 2C 3C 00 40 14 14 08 A3 AF 21 90 00 00 64 08 BF 8F 21 10 40 02 60 08 BE 8F 5C 08 B7 8F 58 08 B6 8F 54 08 B5 8F 50 08 B4 8F 4C 08 B3 8F 48 08 B2 8F 44 08 B1 8F 40 08 B0 8F 08 00 E0 03 68 08 BD 27 E8 FF 80 12 00 01 B0 27 21 88 00 00 18 00 16 24 20 00 15 24 ?? ?? ?? 0? 10 00 17 24 13 00 55 12 00 00 00 00 0C 00 57 56 01 00 31 26 ?? ?? ?? 0? 21 20 60 02 82 22 02 00 42 19 02 00 C0 18 03 00 C0 20 04 00 C0 10 02 00 00 00 02 A2 01 00 03 A2 02 00 04 A2 01 00 31 26 2B 10 34 02 D1 FF 40 10 03 00 10 26 ED FF 56 16 21 20 60 02 ?? ?? ?? 0? 00 00 00 00 00 00 02 A2 ?? ?? ?? 0? 21 20 60 02 01 00 02 A2 ?? ?? ?? 0? 21 20 60 02 F1 FF 55 16 02 00 02 A2 ?? ?? ?? 0? 21 20 60 02 ?? ?? ?? 0? 01 00 31 26 00 04 A2 27 34 08 A2 AF ?? ?? ?? 0? 10 08 A0 AF 24 08 A5 8F 02 00 02 24 FF 00 A5 30 26 00 A2 12 1C 08 A5 AF 03 00 03 24 D2 00 A3 12 01 00 02 24 BD FF A2 16 21 90 00 00 BC FF D5 17 64 08 BF 8F 1C 08 A7 8F 08 00 02 24 B9 FF E2 14 21 10 40 02 12 00 80 12 18 00 83 02 34 08 A5 8F 02 01 A4 27 12 18 00 00 21 10 A3 03 02 01 46 24 00 00 82 90 82 10 02 00 00 00 A2 A0 FF FF 83 90 82 18 03 00 01 00 A3 A0 FE FF 82 90 03 00 84 24 82 10 02 00 02 00 A2 A0 F5 FF 86 14 04 00 A5 24 08 00 04 24 ?? ?? ?? 0? 21 28 00 00 18 08 A2 AF 08 00 02 24 ?? ?? ?? 0? 0C 08 A2 AF 9B FF C0 17 21 90 00 00 1C 08 A3 8F F1 FF 62 24 FF 00 42 30 02 00 42 2C 95 01 40 14 1C 08 A5 8F 18 00 02 24 8D 01 A2 14 1C 08 A7 8F 20 00 E5 38 01 00 A5 2C ?? ?? ?? 0? 21 20 E0 00 18 08 A2 AF 1C 08 A2 8F 0C 08 A2 AF 28 08 A5 8F 2C 08 A7 8F 0C 08 A4 8F FF FF B0 30 FF FF FE 30 21 28 C0 03 ?? ?? ?? 0? 21 30 00 02 81 FF 40 10 21 90 40 00 ?? ?? 03 3C ?? ?? 62 8C 21 30 00 02 43 01 00 12 00 00 40 AC 20 08 A4 8F 04 08 A0 AF 20 00 84 30 ?? ?? ?? 0? 00 08 A4 AF FF FF C6 24 38 08 A6 AF 02 00 07 24 37 00 A7 12 03 00 03 24 0F 00 A3 12 01 00 04 24 0E 00 A4 12 14 08 A5 8F 04 08 A5 8F 38 08 A6 8F 01 00 A5 24 30 01 C0 10 04 08 A5 AF 00 08 A5 8F F0 FF A0 54 04 08 A2 8F FF FF C6 24 38 08 A6 AF ?? ?? ?? 0? 21 10 C0 00 14 08 A5 8F 1D 01 A0 10 21 A0 00 00 10 00 42 24 80 10 02 00 21 10 42 02 00 00 51 8C ?? ?? ?? 0? 21 20 60 02 21 80 40 00 80 00 42 30 13 00 40 10 01 00 02 26 21 20 60 02 ?? ?? ?? 0? 7F 00 10 32 01 00 04 26 21 A0 84 02 FF 00 42 30 21 18 20 02 FF FF 10 26 FF FF 07 24 00 00 62 A0 FC FF 07 16 01 00 63 24 21 88 24 02 2A 10 9E 02 EB FF 40 14 04 08 A5 8F ?? ?? ?? 0? 38 08 A6 8F 21 20 20 02 21 28 40 00 21 30 60 02 ?? ?? ?? 0? 21 A0 82 02 ?? ?? ?? 0? 21 88 22 02 1C 08 A3 8F 20 00 04 24 BC 00 64 10 18 00 04 24 7C 00 64 10 14 08 A3 8F 5E 00 60 10 10 00 42 24 80 10 02 00 21 10 42 02 00 00 56 8C 21 B8 00 00 ?? ?? ?? 0? 21 20 60 02 21 80 40 00 80 00 42 30 20 00 40 14 01 00 14 26 19 00 80 12 21 B8 F4 02 21 88 C0 02 ?? ?? ?? 0? 21 20 60 02 ?? ?? 07 3C ?? ?? 03 3C ?? ?? E5 8C ?? ?? 66 8C ?? ?? 04 3C ?? ?? 87 8C 80 22 43 7C 40 21 44 7C 04 18 A3 00 04 20 C4 00 1F 00 42 30 25 18 64 00 04 10 E2 00 25 18 62 00 FF FF 10 26 FF FF 05 24 00 00 23 A6 EC FF 05 16 02 00 31 26 40 10 14 00 21 B0 C2 02 2A 10 FE 02 DE FF 40 14 04 08 A5 8F ?? ?? ?? 0? 38 08 A6 8F ?? ?? ?? 0? 21 20 60 02 ?? ?? 04 3C ?? ?? 07 3C ?? ?? 85 8C ?? ?? E6 8C ?? ?? 03 3C ?? ?? 67 8C 40 21 44 7C 80 22 43 7C 04 20 C4 00 04 18 A3 00 1F 00 42 30 25 18 64 00 04 10 E2 00 7F 00 10 32 25 18 62 00 01 00 02 26 21 B8 E2 02 FF FF 63 30 21 20 C0 02 FF FF 10 26 FF FF 05 24 00 00 83 A4 FC FF 05 16 02 00 84 24 40 10 02 00 ?? ?? ?? 0? 21 B0 C2 02 EC FE C0 17 21 90 00 00 1C 08 A3 8F 08 00 02 24 E9 FE 62 14 64 08 BF 8F 34 08 A4 8F 21 18 00 00 00 01 05 24 80 38 62 7C 01 00 63 24 02 00 82 A0 00 00 82 A0 01 00 82 A0 FA FF 65 14 04 00 84 24 08 00 04 24 ?? ?? ?? 0? 21 28 00 00 08 00 04 24 18 08 A2 AF ?? ?? ?? 0? 0C 08 A4 AF 80 10 02 00 21 10 42 02 66 FF C0 13 00 00 42 8C 21 88 40 00 21 80 00 00 ?? ?? ?? 0? 21 20 60 02 ?? ?? 07 3C ?? ?? 03 3C ?? ?? E5 8C ?? ?? 66 8C ?? ?? 04 3C ?? ?? 87 8C 80 22 43 7C 40 21 44 7C 04 18 A3 00 04 20 C4 00 1F 00 42 30 25 18 64 00 04 10 E2 00 25 18 62 00 01 00 10 26 00 00 23 A6 ED FF 1E 16 02 00 31 26 ?? ?? ?? 0? 04 08 A5 8F 14 08 A5 8F A2 00 A0 10 10 00 42 24 80 10 02 00 21 10 42 02 00 00 42 8C 21 B0 00 00 08 08 A2 AF ?? ?? ?? 0? 21 20 60 02 21 80 40 00 80 00 42 30 1A 00 40 14 01 00 14 26 13 00 80 12 21 B0 D4 02 08 08 B1 8F ?? ?? ?? 0? 21 20 60 02 03 1A 02 00 01 00 23 A2 03 24 02 00 FF FF 10 26 FF FF 03 24 02 00 24 A2 00 00 22 A2 F6 FF 03 16 03 00 31 26 08 08 A2 8F 13 00 40 00 03 00 02 24 1C 00 82 02 12 10 00 00 08 08 A2 AF 2A 10 DE 02 E4 FF 40 14 04 08 A5 8F ?? ?? ?? 0? 38 08 A6 8F ?? ?? ?? 0? 21 20 60 02 7F 00 10 32 08 08 A3 8F 01 00 05 26 00 3C 46 7C FF 00 44 30 21 B0 C5 02 00 3A 42 7C FF FF 10 26 FF FF 07 24 00 00 64 A0 01 00 62 A0 02 00 66 A0 FA FF 07 16 03 00 63 24 08 08 A2 8F 13 00 40 00 03 00 02 24 1C 00 A2 00 12 10 00 00 ?? ?? ?? 0? 08 08 A2 AF 14 08 A5 8F 2A 00 A0 10 10 00 42 24 80 10 02 00 21 10 42 02 00 00 56 8C 21 B8 00 00 ?? ?? ?? 0? 21 20 60 02 21 80 40 00 80 00 42 30 12 00 40 14 01 00 14 26 0B 00 80 12 21 B8 F4 02 21 88 C0 02 ?? ?? ?? 0? 21 20 60 02 00 00 22 AE FF FF 10 26 FF FF 02 24 FA FF 02 16 04 00 31 26 80 10 14 00 21 B0 C2 02 2A 10 FE 02 EC FF 40 14 04 08 A5 8F ?? ?? ?? 0? 38 08 A6 8F 7F 00 10 32 01 00 11 26 ?? ?? ?? 0? 21 20 60 02 21 B8 F1 02 21 18 C0 02 FF FF 10 26 FF FF 07 24 00 00 62 AC FC FF 07 16 04 00 63 24 80 10 11 00 ?? ?? ?? 0? 21 B0 C2 02 80 10 02 00 21 10 42 02 E0 FE C0 13 00 00 42 8C 21 88 40 00 21 80 00 00 ?? ?? ?? 0? 21 20 60 02 01 00 10 26 00 00 22 AE FB FF 1E 16 04 00 31 26 ?? ?? ?? 0? 04 08 A5 8F 10 00 42 24 80 10 02 00 21 10 42 02 00 00 44 8C 21 28 C0 03 ?? ?? ?? 0? 21 30 60 02 ?? ?? ?? 0? 04 08 A5 8F ?? ?? 07 3C ?? ?? E2 8C 00 00 43 8C 1B 00 60 14 18 08 A2 8F 0C 08 A3 8F 0C 00 43 10 08 00 02 24 1C 08 A4 8F 04 00 82 10 34 08 A5 8F 10 08 A7 8F 0A 28 07 00 34 08 A5 AF 34 08 A5 8F 18 08 A6 8F ?? ?? ?? 0? 21 20 40 02 21 90 40 00 1C 08 A3 8F 08 00 02 24 23 FE 62 10 18 08 A4 8F 21 FE 82 10 10 08 A5 8F 20 FE A0 50 64 08 BF 8F ?? ?? ?? 0? 34 08 A4 8F ?? ?? ?? 0? 64 08 BF 8F ?? ?? ?? 0? 21 20 40 02 ?? ?? ?? 0? 21 90 00 00 80 10 02 00 21 10 42 02 A6 FE C0 13 00 00 50 8C 21 88 00 00 ?? ?? ?? 0? 21 20 60 02 03 24 02 00 03 1A 02 00 01 00 31 26 01 00 03 A2 02 00 04 A2 00 00 02 A2 F7 FF 3E 16 03 00 10 26 ?? ?? ?? 0? 04 08 A5 8F 20 00 02 24 03 FE A2 14 21 90 00 00 ?? ?? ?? 0? 1C 08 A7 8F 0F 00 04 24 ?? ?? ?? 0? 21 28 00 00 0F 00 04 24 18 08 A2 AF 1C 08 A4 AF ?? ?? ?? 0? 0C 08 A4 AF }
	condition:
		$1
}

rule file_24_0_0 {
	meta:
		name = "_linear_draw_sprite_ex8"
		size = 956
		refs = "00f8 color_map 0320 .text"
	strings:
		$1 = { C0 FF BD 27 02 00 02 24 38 00 BE AF 24 00 B3 AF 3C 00 BF AF 34 00 B7 AF 30 00 B6 AF 2C 00 B5 AF 28 00 B4 AF 20 00 B2 AF 1C 00 B1 AF 18 00 B0 AF 21 F0 80 00 21 50 A0 00 C0 00 22 11 21 98 00 01 01 00 03 24 64 00 23 11 FF FF 11 24 03 00 22 39 0B 88 62 00 08 00 B1 AF 08 00 C2 8F 62 00 40 50 04 00 42 8D 0C 00 C2 8F 10 00 C3 8F 00 00 44 8D 23 10 46 00 00 00 A2 AF 00 00 A5 8F 23 18 66 00 21 10 00 00 2C 28 A2 00 2D 18 64 00 23 80 65 00 45 00 00 1A 00 00 A5 AF 21 30 A6 00 01 00 02 24 BD 00 22 11 04 00 A6 AF 03 00 02 24 BB 00 22 11 00 00 A3 8F 14 00 C2 8F 18 00 C3 8F 04 00 44 8D 23 30 47 00 23 18 67 00 21 10 00 00 2C 30 C2 00 2D 18 64 00 23 18 66 00 33 00 60 18 0C 00 A3 AF FE FF 22 25 02 00 42 2C A5 00 40 14 21 28 C7 00 2C 00 C2 8F 00 C0 03 3C ?? ?? 04 3C 24 10 43 00 4C 00 40 14 ?? ?? 95 8C 0C 00 A4 8F 26 00 80 18 10 00 C2 24 80 10 02 00 21 B8 42 01 21 B0 A0 00 21 A0 00 00 01 00 07 24 20 00 C3 8F 10 00 A7 AF 21 20 C0 03 21 28 C0 02 09 F8 60 00 00 00 F2 8E 12 00 00 1A 10 00 A7 8F 04 00 A4 8F 00 00 A3 8F 21 30 44 00 21 28 43 02 21 20 00 00 00 00 A2 90 07 00 40 50 01 00 84 24 6C 00 67 12 02 00 03 24 68 00 63 52 00 00 C3 90 00 00 C2 A0 01 00 84 24 01 00 A5 24 F5 FF 90 14 21 30 D1 00 0C 00 A4 8F 08 00 A5 8F 01 00 94 26 2A 10 84 02 04 00 F7 26 E1 FF 40 14 21 B0 C5 02 3C 00 BF 8F 38 00 BE 8F 34 00 B7 8F 30 00 B6 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 40 00 BD 27 08 00 C2 8F A1 FF 40 14 08 00 A3 AF 04 00 42 8D 00 00 50 8D 0C 00 A2 AF 01 00 02 24 55 00 22 11 03 00 02 24 53 00 22 11 FE FF 22 25 02 00 42 2C 57 00 40 14 04 00 A6 AF 2C 00 C2 8F 00 C0 03 3C ?? ?? 04 3C 24 10 43 00 21 28 E0 00 00 00 A0 AF 21 30 00 00 B6 FF 40 10 ?? ?? 95 8C 0C 00 A2 8F 28 00 40 58 1C 00 C2 8F 10 00 C2 24 80 10 02 00 21 B8 42 01 21 B0 A0 00 21 A0 00 00 01 00 07 24 20 00 C3 8F 10 00 A7 AF 21 20 C0 03 21 28 C0 02 09 F8 60 00 00 00 F2 8E 12 00 00 1A 10 00 A7 8F 04 00 A4 8F 00 00 A3 8F 21 30 44 00 21 28 43 02 21 20 00 00 00 00 A2 90 07 00 40 50 01 00 84 24 25 00 67 12 02 00 03 24 21 00 63 52 00 00 C3 90 00 00 C2 A0 01 00 84 24 01 00 A5 24 F5 FF 90 14 21 30 D1 00 0C 00 A4 8F 08 00 A5 8F 01 00 94 26 2A 10 84 02 04 00 F7 26 E1 FF 40 14 21 B0 C5 02 1C 00 C2 8F 21 20 C0 03 3C 00 BF 8F 08 00 59 8C 38 00 BE 8F 34 00 B7 8F 30 00 B6 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 20 03 40 00 BD 27 00 12 02 00 21 10 43 00 21 10 A2 02 ?? ?? ?? 0? 00 00 42 90 00 12 02 00 21 10 43 00 21 10 A2 02 ?? ?? ?? 0? 00 00 42 90 FF FF 02 24 01 00 11 24 ?? ?? ?? 0? 08 00 A2 AF FF FF 02 26 21 10 46 00 04 00 A2 AF FE FF 22 25 02 00 42 2C AC FF 40 50 2C 00 C2 8F 0C 00 A3 8F 00 00 A0 AF 21 30 00 00 FF FF 62 24 ?? ?? ?? 0? 21 28 47 00 21 18 A3 00 0C 00 A5 8F 23 10 86 00 23 30 45 00 ?? ?? ?? 0? FF FF 65 24 00 00 A3 8F 23 10 83 00 04 00 A4 8F 23 10 50 00 00 00 A2 AF 21 18 90 00 FF FF 63 24 ?? ?? ?? 0? 04 00 A3 AF }
	condition:
		$1
}

rule file_24_1_0 {
	meta:
		name = "_linear_draw_sprite8"
		size = 512
	strings:
		$1 = { 08 00 82 8C D8 FF BD 27 10 00 B4 AF 24 00 BF AF 20 00 BE AF 1C 00 B7 AF 18 00 B6 AF 14 00 B5 AF 0C 00 B3 AF 08 00 B2 AF 04 00 B1 AF 00 00 B0 AF 43 00 40 10 21 A0 80 00 0C 00 82 8C 10 00 83 8C 00 00 A4 8C 23 A8 46 00 23 18 66 00 21 48 00 00 2D 18 64 00 2C A8 A9 02 23 88 75 00 5D 00 20 5A 24 00 BF 8F 14 00 82 8E 18 00 83 8E 04 00 A4 8C 23 40 47 00 23 18 67 00 2C 40 09 01 2D 18 64 00 23 B0 68 00 52 00 C0 1A 21 F0 A6 02 2C 00 82 8E 00 C0 03 3C 24 10 43 00 33 00 40 10 21 B8 07 01 18 00 C0 1A 10 00 02 25 80 10 02 00 21 98 A2 00 21 80 00 00 20 00 83 8E 21 20 80 02 21 28 17 02 09 F8 60 00 00 00 72 8E 0A 00 20 1A 21 10 5E 00 21 20 55 02 21 28 51 00 00 00 83 90 02 00 60 10 01 00 84 24 00 00 43 A0 01 00 42 24 FB FF 45 54 00 00 83 90 01 00 10 26 2A 10 16 02 ED FF 40 14 04 00 73 26 1C 00 82 8E 21 20 80 02 24 00 BF 8F 08 00 59 8C 20 00 BE 8F 1C 00 B7 8F 18 00 B6 8F 14 00 B5 8F 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 20 03 28 00 BD 27 2C 00 82 8E 00 C0 03 3C 00 00 B1 8C 24 10 43 00 04 00 B6 8C 21 F0 C0 00 21 B8 E0 00 21 A8 00 00 CF FF 40 14 21 40 00 00 19 00 C0 1A 10 00 02 25 10 00 E3 26 80 10 02 00 80 18 03 00 21 20 A2 00 21 18 83 02 21 50 00 00 00 00 82 8C 0B 00 20 1A 00 00 68 8C 21 30 55 00 21 48 1E 01 21 10 00 00 00 00 C8 90 01 00 42 24 02 00 00 11 01 00 C6 24 00 00 28 A1 FA FF 51 14 01 00 29 25 01 00 4A 25 2A 10 56 01 04 00 84 24 EF FF 40 14 04 00 63 24 24 00 BF 8F 20 00 BE 8F 1C 00 B7 8F 18 00 B6 8F 14 00 B5 8F 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_24_3_0 {
	meta:
		name = "_linear_draw_256_sprite8"
		size = 604
		refs = "008c _palette_expansion_table"
	strings:
		$1 = { 08 00 82 8C D0 FF BD 27 1C 00 B5 AF 10 00 B2 AF 2C 00 BF AF 28 00 BE AF 24 00 B7 AF 20 00 B6 AF 18 00 B4 AF 14 00 B3 AF 0C 00 B1 AF 08 00 B0 AF 21 A8 80 00 4F 00 40 10 21 90 A0 00 0C 00 82 8C 10 00 83 8C 00 00 A4 8C 23 B0 46 00 23 18 66 00 21 28 00 00 2D 18 64 00 2C B0 C5 02 23 98 76 00 73 00 60 1A 2C 00 BF 8F 14 00 A2 8E 18 00 A3 8E 04 00 44 8E 23 88 47 00 23 18 67 00 2C 88 25 02 2D 18 64 00 23 B8 71 00 69 00 E0 1A ?? ?? 02 3C 1C 00 A5 8E ?? ?? 43 8C 00 00 A4 8C 21 30 C6 02 00 00 A6 AF 09 F8 60 00 21 F0 27 02 21 80 40 00 2C 00 A2 8E 00 C0 03 3C 24 10 43 00 3D 00 40 10 00 00 00 00 1C 00 E0 1A 10 00 22 26 80 10 02 00 21 A0 42 02 21 90 00 00 20 00 A3 8E 21 20 A0 02 21 28 5E 02 09 F8 60 00 00 00 91 8E 0E 00 60 1A 00 00 A3 8F 21 28 36 02 21 20 43 00 21 30 93 00 00 00 A3 90 01 00 A5 24 80 10 03 00 03 00 60 10 21 10 02 02 00 00 42 8C 00 00 82 A0 01 00 84 24 F8 FF 86 54 00 00 A3 90 01 00 52 26 2A 10 57 02 E9 FF 40 14 04 00 94 26 1C 00 A2 8E 21 20 A0 02 2C 00 BF 8F 08 00 59 8C 28 00 BE 8F 24 00 B7 8F 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 20 03 30 00 BD 27 00 00 B3 8C 04 00 B7 8C 1C 00 A5 8E ?? ?? 02 3C ?? ?? 43 8C 00 00 A4 8C 00 00 A6 AF 09 F8 60 00 21 F0 E0 00 21 80 40 00 2C 00 A2 8E 00 C0 03 3C 21 B0 00 00 24 10 43 00 C5 FF 40 14 21 88 00 00 1D 00 E0 1A 10 00 22 26 10 00 C3 27 80 10 02 00 80 18 03 00 21 28 42 02 21 20 A3 02 21 50 00 00 00 00 A2 8C 0F 00 60 1A 00 00 83 8C 21 40 56 00 00 00 A2 8F 21 30 00 00 21 48 62 00 00 00 03 91 01 00 C6 24 01 00 08 25 80 10 03 00 03 00 60 10 21 10 02 02 00 00 42 8C 00 00 22 A1 F7 FF D3 14 01 00 29 25 01 00 4A 25 2A 10 57 01 04 00 A5 24 EB FF 40 14 04 00 84 24 2C 00 BF 8F 28 00 BE 8F 24 00 B7 8F 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_24_4_0 {
	meta:
		name = "_linear_draw_sprite_v_flip8"
		size = 532
	strings:
		$1 = { 08 00 82 8C D8 FF BD 27 10 00 B4 AF 24 00 BF AF 20 00 BE AF 1C 00 B7 AF 18 00 B6 AF 14 00 B5 AF 0C 00 B3 AF 08 00 B2 AF 04 00 B1 AF 00 00 B0 AF 47 00 40 10 21 A0 80 00 0C 00 82 8C 10 00 83 8C 00 00 A4 8C 23 B0 46 00 23 18 66 00 21 40 00 00 2D 18 64 00 2C B0 C8 02 23 88 76 00 62 00 20 5A 24 00 BF 8F 14 00 83 8E 18 00 82 8E 04 00 A4 8C 23 18 67 00 23 10 47 00 2C 18 68 00 2D 10 44 00 23 A8 43 00 57 00 A0 1A FF FF E2 24 21 10 43 00 21 B8 55 00 2C 00 82 8E 23 18 83 00 23 20 75 00 00 C0 03 3C 24 10 43 00 34 00 40 10 21 F0 C6 02 18 00 A0 1A 10 00 82 24 80 10 02 00 21 98 A2 00 21 80 00 00 20 00 83 8E 21 20 80 02 23 28 F0 02 09 F8 60 00 00 00 72 8E 0A 00 20 1A 21 10 5E 00 21 20 56 02 21 28 51 00 00 00 83 90 02 00 60 10 01 00 84 24 00 00 43 A0 01 00 42 24 FB FF 45 54 00 00 83 90 01 00 10 26 2A 10 15 02 ED FF 40 14 04 00 73 26 1C 00 82 8E 21 20 80 02 24 00 BF 8F 08 00 59 8C 20 00 BE 8F 1C 00 B7 8F 18 00 B6 8F 14 00 B5 8F 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 20 03 28 00 BD 27 04 00 B5 8C 00 C0 03 3C 00 00 B1 8C FF FF A2 26 21 B8 47 00 2C 00 82 8E 21 F0 C0 00 21 B0 00 00 24 10 43 00 CE FF 40 14 21 20 00 00 19 00 A0 1A 10 00 82 24 10 00 E3 26 80 10 02 00 80 18 03 00 21 20 A2 00 21 18 83 02 21 50 00 00 00 00 82 8C 0B 00 20 1A 00 00 68 8C 21 30 56 00 21 48 1E 01 21 10 00 00 00 00 C8 90 01 00 42 24 02 00 00 11 01 00 C6 24 00 00 28 A1 FA FF 51 14 01 00 29 25 01 00 4A 25 2A 10 55 01 04 00 84 24 EF FF 40 14 FC FF 63 24 24 00 BF 8F 20 00 BE 8F 1C 00 B7 8F 18 00 B6 8F 14 00 B5 8F 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_24_5_0 {
	meta:
		name = "_linear_draw_sprite_h_flip8"
		size = 532
	strings:
		$1 = { 08 00 82 8C D8 FF BD 27 10 00 B4 AF 24 00 BF AF 20 00 BE AF 1C 00 B7 AF 18 00 B6 AF 14 00 B5 AF 0C 00 B3 AF 08 00 B2 AF 04 00 B1 AF 00 00 B0 AF 47 00 40 10 21 A0 80 00 0C 00 83 8C 10 00 82 8C 00 00 AA 8C 23 48 66 00 23 10 46 00 21 58 00 00 2C 48 2B 01 2D 10 4A 00 23 80 49 00 62 00 00 5A 24 00 BF 8F 14 00 82 8C 18 00 83 8C 04 00 A4 8C 23 40 47 00 23 18 67 00 2C 40 0B 01 2D 18 64 00 23 A8 68 00 57 00 A0 1A FF FF C2 24 21 10 49 00 21 F0 50 00 2C 00 82 8E 23 18 49 01 23 B8 70 00 00 C0 03 3C 24 10 43 00 34 00 40 10 21 B0 07 01 18 00 A0 1A 10 00 02 25 80 10 02 00 21 98 A2 00 21 88 00 00 20 00 83 8E 21 20 80 02 21 28 36 02 09 F8 60 00 00 00 72 8E 0A 00 00 1A 21 10 5E 00 21 20 57 02 23 28 50 00 00 00 83 90 02 00 60 10 01 00 84 24 00 00 43 A0 FF FF 42 24 FB FF 45 54 00 00 83 90 01 00 31 26 2A 10 35 02 ED FF 40 14 04 00 73 26 1C 00 82 8E 21 20 80 02 24 00 BF 8F 08 00 59 8C 20 00 BE 8F 1C 00 B7 8F 18 00 B6 8F 14 00 B5 8F 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 20 03 28 00 BD 27 00 00 B0 8C 00 C0 03 3C 04 00 B5 8C FF FF 02 26 21 F0 46 00 2C 00 82 8E 21 B0 E0 00 21 B8 00 00 24 10 43 00 CE FF 40 14 21 40 00 00 19 00 A0 1A 10 00 02 25 10 00 C3 26 80 10 02 00 80 18 03 00 21 28 A2 00 21 18 83 02 21 50 00 00 00 00 A2 8C 0B 00 00 1A 00 00 68 8C 21 30 57 00 21 48 1E 01 21 10 00 00 00 00 C8 90 01 00 42 24 02 00 00 11 01 00 C6 24 00 00 28 A1 FA FF 50 14 FF FF 29 25 01 00 4A 25 2A 10 55 01 04 00 A5 24 EF FF 40 14 04 00 63 24 24 00 BF 8F 20 00 BE 8F 1C 00 B7 8F 18 00 B6 8F 14 00 B5 8F 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_24_6_0 {
	meta:
		name = "_linear_draw_sprite_vh_flip8"
		size = 556
	strings:
		$1 = { 08 00 82 8C D8 FF BD 27 10 00 B4 AF 24 00 BF AF 20 00 BE AF 1C 00 B7 AF 18 00 B6 AF 14 00 B5 AF 0C 00 B3 AF 08 00 B2 AF 04 00 B1 AF 00 00 B0 AF 21 A0 80 00 4B 00 40 10 21 40 A0 00 10 00 82 8C 0C 00 83 8C 00 00 AB 8C 23 10 46 00 23 20 66 00 21 50 00 00 2C 20 8A 00 2D 10 4B 00 23 80 44 00 67 00 00 5A 24 00 BF 8F 14 00 83 8E 18 00 82 8E 04 00 A9 8C 23 28 67 00 23 10 47 00 2C 28 AA 00 2D 10 49 00 23 A8 45 00 5C 00 A0 1A FF FF C2 24 21 10 44 00 FF FF E3 24 21 B8 50 00 2C 00 82 8E 21 18 65 00 21 B0 75 00 00 C0 03 3C 23 20 64 01 23 28 25 01 24 10 43 00 23 F0 90 00 35 00 40 10 23 28 B5 00 18 00 A0 1A 10 00 A2 24 80 10 02 00 21 98 02 01 21 88 00 00 20 00 83 8E 21 20 80 02 23 28 D1 02 09 F8 60 00 00 00 72 8E 0A 00 00 1A 21 10 57 00 21 20 5E 02 23 28 50 00 00 00 83 90 02 00 60 10 01 00 84 24 00 00 43 A0 FF FF 42 24 FB FF 45 54 00 00 83 90 01 00 31 26 2A 10 35 02 ED FF 40 14 04 00 73 26 1C 00 82 8E 21 20 80 02 24 00 BF 8F 08 00 59 8C 20 00 BE 8F 1C 00 B7 8F 18 00 B6 8F 14 00 B5 8F 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 20 03 28 00 BD 27 00 00 B0 8C 04 00 B5 8C 21 F0 00 00 FF FF 02 26 21 B8 46 00 2C 00 82 8E FF FF A3 26 21 B0 67 00 00 C0 03 3C 24 10 43 00 CD FF 40 14 21 28 00 00 19 00 A0 1A 10 00 A2 24 10 00 C3 26 80 10 02 00 80 18 03 00 21 28 02 01 21 18 83 02 21 50 00 00 00 00 A2 8C 0B 00 00 1A 00 00 68 8C 21 30 5E 00 21 48 17 01 21 10 00 00 00 00 C8 90 01 00 42 24 02 00 00 11 01 00 C6 24 00 00 28 A1 FA FF 50 14 FF FF 29 25 01 00 4A 25 2A 10 55 01 04 00 A5 24 EF FF 40 14 FC FF 63 24 24 00 BF 8F 20 00 BE 8F 1C 00 B7 8F 18 00 B6 8F 14 00 B5 8F 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_24_7_0 {
	meta:
		name = "_linear_draw_trans_sprite8"
		size = 884
		refs = "0090 color_map"
	strings:
		$1 = { 08 00 82 8C C8 FF BD 27 20 00 B4 AF 34 00 BF AF 30 00 BE AF 2C 00 B7 AF 28 00 B6 AF 24 00 B5 AF 1C 00 B3 AF 18 00 B2 AF 14 00 B1 AF 10 00 B0 AF 5B 00 40 10 21 A0 80 00 0C 00 82 8C 10 00 83 8C 00 00 A4 8C 23 10 46 00 23 18 66 00 21 48 00 00 2C 10 49 00 2D 18 64 00 23 90 62 00 82 00 40 1A 00 00 A2 AF 14 00 82 8E 18 00 83 8E 04 00 A4 8C 23 40 47 00 23 18 67 00 2C 40 09 01 2D 18 64 00 23 F0 68 00 78 00 C0 1B 00 00 A2 8F 21 38 07 01 ?? ?? 03 3C 21 30 46 00 1C 00 A2 8C 08 00 A6 AF 04 00 A7 AF 00 00 44 8C 08 00 02 24 48 00 82 14 ?? ?? 71 8C 1C 00 83 8E 00 00 62 8C 45 00 44 50 2C 00 82 8E 28 00 C0 1B 10 00 02 25 80 10 02 00 21 B0 A2 00 21 98 00 00 04 00 A4 8F 24 00 83 8E 00 00 D7 8E 21 80 64 02 21 28 00 02 09 F8 60 00 21 20 80 02 20 00 83 8E 21 28 00 02 21 20 80 02 09 F8 60 00 21 A8 40 00 12 00 40 1A 08 00 A6 8F 00 00 A3 8F 21 20 A6 02 21 30 E3 02 08 00 A3 8F 21 38 92 00 21 28 43 00 00 00 C2 90 00 00 83 90 01 00 84 24 00 12 02 00 21 10 43 00 21 10 22 02 00 00 43 90 01 00 C6 24 00 00 A3 A0 F6 FF 87 14 01 00 A5 24 01 00 73 26 2A 10 7E 02 DE FF 40 14 04 00 D6 26 1C 00 83 8E 08 00 79 8C 21 20 80 02 34 00 BF 8F 30 00 BE 8F 2C 00 B7 8F 28 00 B6 8F 24 00 B5 8F 20 00 B4 8F 1C 00 B3 8F 18 00 B2 8F 14 00 B1 8F 10 00 B0 8F 08 00 20 03 38 00 BD 27 1C 00 A2 8C ?? ?? 03 3C 00 00 B2 8C 00 00 44 8C 08 00 02 24 04 00 BE 8C 08 00 A6 AF 04 00 A7 AF 00 00 A0 AF 21 40 00 00 BA FF 82 10 ?? ?? 71 8C 2C 00 82 8E 00 C0 03 3C 24 10 43 00 2E 00 40 14 00 00 00 00 20 00 C0 1B 10 00 02 25 04 00 A4 8F 80 10 02 00 10 00 83 24 80 18 03 00 21 28 A2 00 21 20 83 02 21 50 00 00 00 00 A2 8C 11 00 40 1A 00 00 83 8C 00 00 A6 8F 21 40 00 00 21 48 46 00 08 00 A2 8F 21 30 62 00 00 00 22 91 00 00 C3 90 01 00 08 25 00 12 02 00 21 10 43 00 21 10 22 02 00 00 43 90 01 00 29 25 00 00 C3 A0 F6 FF 12 15 01 00 C6 24 01 00 4A 25 2A 10 5E 01 04 00 A5 24 E9 FF 40 14 04 00 84 24 34 00 BF 8F 30 00 BE 8F 2C 00 B7 8F 28 00 B6 8F 24 00 B5 8F 20 00 B4 8F 1C 00 B3 8F 18 00 B2 8F 14 00 B1 8F 10 00 B0 8F 08 00 E0 03 38 00 BD 27 27 00 C0 1B 10 00 02 25 80 10 02 00 21 B0 A2 00 21 98 00 00 04 00 A4 8F 24 00 83 8E 00 00 D7 8E 21 80 64 02 21 28 00 02 09 F8 60 00 21 20 80 02 20 00 83 8E 21 28 00 02 21 20 80 02 09 F8 60 00 21 A8 40 00 12 00 40 1A 08 00 A6 8F 08 00 A3 8F 21 20 46 00 00 00 A2 8F 21 28 A3 02 21 38 92 00 21 30 E2 02 00 00 C2 90 00 00 A3 90 01 00 C6 24 00 12 02 00 21 10 43 00 21 10 22 02 00 00 43 90 00 00 83 A0 01 00 84 24 F6 FF 87 14 01 00 A5 24 01 00 73 26 2A 10 7E 02 DE FF 40 14 04 00 D6 26 1C 00 82 8E 21 20 80 02 34 00 BF 8F 08 00 59 8C 30 00 BE 8F 2C 00 B7 8F 28 00 B6 8F 24 00 B5 8F 20 00 B4 8F 1C 00 B3 8F 18 00 B2 8F 14 00 B1 8F 10 00 B0 8F 08 00 20 03 38 00 BD 27 }
	condition:
		$1
}

rule file_24_8_0 {
	meta:
		name = "_linear_draw_lit_sprite8"
		size = 584
		refs = "008c color_map"
	strings:
		$1 = { 08 00 82 8C D0 FF BD 27 1C 00 B5 AF 2C 00 BF AF 28 00 BE AF 24 00 B7 AF 20 00 B6 AF 18 00 B4 AF 14 00 B3 AF 10 00 B2 AF 0C 00 B1 AF 08 00 B0 AF 21 A8 80 00 4C 00 40 10 21 50 A0 00 0C 00 82 8C 10 00 83 8C 00 00 A4 8C 23 B0 46 00 23 18 66 00 21 28 00 00 2D 18 64 00 2C B0 C5 02 23 98 76 00 6E 00 60 5A 2C 00 BF 8F 14 00 A2 8E 18 00 A3 8E 04 00 44 8D 23 48 47 00 23 18 67 00 2C 48 25 01 2D 18 64 00 23 B8 69 00 63 00 E0 1A ?? ?? 02 3C 2C 00 A4 8E ?? ?? 45 8C FF 00 03 31 00 C0 02 3C 21 30 C6 02 00 1A 03 00 24 20 82 00 00 00 A6 AF 21 F0 27 01 3B 00 80 10 21 80 A3 00 1B 00 E0 1A 10 00 22 25 80 10 02 00 21 A0 42 01 21 88 00 00 20 00 A3 8E 21 20 A0 02 21 28 3E 02 09 F8 60 00 00 00 92 8E 0D 00 60 1A 00 00 A4 8F 21 18 44 00 21 30 73 00 21 20 56 02 00 00 82 90 01 00 84 24 03 00 40 10 21 28 02 02 00 00 A2 90 00 00 62 A0 01 00 63 24 F9 FF 66 54 00 00 82 90 01 00 31 26 2A 10 37 02 EA FF 40 14 04 00 94 26 1C 00 A2 8E 21 20 A0 02 2C 00 BF 8F 08 00 59 8C 28 00 BE 8F 24 00 B7 8F 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 20 03 30 00 BD 27 ?? ?? 02 3C 2C 00 A4 8E 00 00 B3 8C 04 00 B7 8C ?? ?? 45 8C FF 00 03 31 00 C0 02 3C 00 1A 03 00 24 20 82 00 00 00 A6 AF 21 F0 E0 00 21 B0 00 00 21 48 00 00 C7 FF 80 14 21 80 A3 00 1C 00 E0 1A 10 00 22 25 10 00 C3 27 80 10 02 00 80 18 03 00 21 20 42 01 21 18 A3 02 21 58 00 00 00 00 82 8C 0E 00 60 1A 00 00 66 8C 21 48 56 00 00 00 A2 8F 21 50 C2 00 21 30 00 00 00 00 22 91 01 00 C6 24 01 00 29 25 03 00 40 10 21 40 02 02 00 00 02 91 00 00 42 A1 F8 FF D3 14 01 00 4A 25 01 00 6B 25 2A 10 77 01 04 00 84 24 EC FF 40 14 04 00 63 24 2C 00 BF 8F 28 00 BE 8F 24 00 B7 8F 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_24_9_0 {
	meta:
		name = "_linear_draw_character8"
		size = 592
		refs = "00e0 .text"
	strings:
		$1 = { 08 00 82 8C D0 FF BD 27 1C 00 B5 AF 18 00 B4 AF 14 00 B3 AF 2C 00 BF AF 28 00 BE AF 24 00 B7 AF 20 00 B6 AF 10 00 B2 AF 0C 00 B1 AF 08 00 B0 AF 21 98 80 00 21 A8 00 01 48 00 40 10 21 A0 20 01 0C 00 82 8C 10 00 83 8C 00 00 A4 8C 23 B8 46 00 23 18 66 00 21 40 00 00 2D 18 64 00 2C B8 E8 02 23 B0 77 00 6F 00 C0 5A 2C 00 BF 8F 14 00 62 8E 18 00 63 8E 04 00 A4 8C 23 10 47 00 23 18 67 00 2C 10 48 00 2D 18 64 00 23 F0 62 00 64 00 C0 1B 21 30 E6 02 21 38 47 00 04 00 A6 AF 36 00 80 06 00 00 A7 AF 1E 00 C0 1B 21 80 00 00 10 00 42 24 80 10 02 00 21 90 A2 00 00 00 A2 8F 20 00 63 8E 21 20 60 02 21 28 02 02 09 F8 60 00 00 00 51 8E 0F 00 C0 1A 04 00 A4 8F 21 18 44 00 21 28 76 00 ?? ?? ?? 0? 21 20 37 02 01 00 63 24 08 00 65 10 01 00 84 24 00 00 82 90 FB FF 40 54 00 00 75 A0 00 00 74 A0 01 00 63 24 FA FF 65 14 01 00 84 24 01 00 10 26 2A 10 1E 02 E7 FF 40 14 04 00 52 26 1C 00 62 8E 21 20 60 02 2C 00 BF 8F 08 00 59 8C 28 00 BE 8F 24 00 B7 8F 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 20 03 30 00 BD 27 00 00 B6 8C 04 00 BE 8C 04 00 A6 AF 00 00 A7 AF 21 B8 00 00 CC FF 81 06 21 10 00 00 E9 FF C0 1B 21 80 00 00 10 00 42 24 80 10 02 00 21 90 A2 00 00 00 A2 8F 20 00 63 8E 21 20 60 02 21 28 02 02 09 F8 60 00 00 00 51 8E 0B 00 C0 1A 04 00 A4 8F 21 18 44 00 21 28 76 00 21 20 37 02 00 00 82 90 02 00 40 10 01 00 84 24 00 00 75 A0 01 00 63 24 FB FF 65 54 00 00 82 90 01 00 10 26 2A 10 1E 02 EB FF 40 14 04 00 52 26 1C 00 62 8E 21 20 60 02 2C 00 BF 8F 08 00 59 8C 28 00 BE 8F 24 00 B7 8F 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 20 03 30 00 BD 27 2C 00 BF 8F 28 00 BE 8F 24 00 B7 8F 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_24_10_0 {
	meta:
		name = "_linear_draw_rle_sprite8"
		size = 984
		refs = "00f4 .text"
	strings:
		$1 = { 08 00 82 8C D8 FF BD 27 10 00 B3 AF 24 00 BF AF 20 00 B7 AF 1C 00 B6 AF 18 00 B5 AF 14 00 B4 AF 0C 00 B2 AF 08 00 B1 AF 04 00 B0 AF 7D 00 40 10 21 98 80 00 0C 00 82 8C 10 00 89 8C 00 00 A8 8C 23 90 46 00 21 50 00 00 23 10 26 01 2C 90 4A 02 2D 10 48 00 23 A0 52 00 BB 00 80 1A 21 B8 46 02 14 00 82 8C 18 00 83 8C 04 00 A4 8C 23 10 47 00 23 18 67 00 2C 10 4A 00 2D 18 64 00 23 A8 62 00 B1 00 A0 1A 21 B0 47 00 0E 00 40 10 10 00 B0 24 21 20 00 00 00 00 03 82 07 00 60 10 01 00 10 26 FD FF 60 58 00 00 03 82 21 80 03 02 00 00 03 82 FB FF 60 14 01 00 10 26 01 00 84 24 F6 FF 82 54 00 00 03 82 60 00 40 12 21 10 C8 00 21 88 00 00 20 00 63 8E 21 20 60 02 09 F8 60 00 21 28 36 02 00 00 06 82 17 00 40 12 01 00 10 26 3B 00 C0 10 21 20 40 02 ?? ?? ?? 0? 00 00 00 00 9D 00 62 04 21 80 04 02 21 80 06 02 00 00 06 82 21 20 60 00 0C 00 60 10 01 00 10 26 31 00 C0 50 01 00 31 26 F6 FF C0 1C 23 18 86 00 21 30 C4 00 05 00 C0 04 21 18 C0 00 21 20 60 00 00 00 06 82 F6 FF 60 14 01 00 10 26 1E 00 80 1A 00 00 00 00 23 00 C0 10 21 40 57 00 15 00 C0 18 21 18 80 02 23 38 66 00 86 00 E0 04 21 28 00 02 21 18 00 01 21 20 00 00 00 00 A2 80 01 00 84 24 01 00 A5 24 00 00 62 A0 FB FF 86 14 01 00 63 24 21 80 04 02 00 00 06 82 21 40 04 01 0A 00 E0 18 01 00 10 26 10 00 C0 50 01 00 31 26 ED FF C0 1C 21 18 E0 00 21 38 C3 00 23 40 06 01 00 00 06 82 F8 FF E0 1C 01 00 10 26 07 00 C0 50 01 00 31 26 01 00 C0 5C 21 80 06 02 00 00 06 82 FC FF C0 14 01 00 10 26 01 00 31 26 2A 10 35 02 BB FF 40 54 20 00 63 8E 1C 00 62 8E 21 20 60 02 24 00 BF 8F 08 00 59 8C 20 00 B7 8F 1C 00 B6 8F 18 00 B5 8F 14 00 B4 8F 10 00 B3 8F 0C 00 B2 8F 08 00 B1 8F 04 00 B0 8F 08 00 20 03 28 00 BD 27 00 00 A8 8C 04 00 B5 8C 10 00 89 8C 10 00 B0 24 21 B0 E0 00 21 A0 00 01 21 B8 C0 00 21 90 00 00 21 10 C8 00 2A 10 49 00 3A 00 40 10 00 00 00 00 E5 FF A0 1A 21 88 00 00 20 00 63 8E 21 20 60 02 09 F8 60 00 21 28 36 02 00 00 03 82 1F 00 80 1A 01 00 10 26 1D 00 60 10 21 30 60 00 21 40 57 00 15 00 C0 18 21 18 80 02 23 38 66 00 44 00 E0 04 21 28 00 02 21 18 00 01 21 20 00 00 00 00 A2 80 01 00 84 24 01 00 A5 24 00 00 62 A0 FB FF 86 14 01 00 63 24 21 80 04 02 00 00 02 82 21 40 04 01 0A 00 E0 18 01 00 10 26 08 00 40 10 21 30 40 00 ED FF C0 1C 21 18 E0 00 21 38 C3 00 00 00 02 82 23 40 06 01 F8 FF E0 1C 01 00 10 26 01 00 31 26 2A 10 35 02 D9 FF 40 54 20 00 63 8E 1C 00 62 8E 21 20 60 02 24 00 BF 8F 08 00 59 8C 20 00 B7 8F 1C 00 B6 8F 18 00 B5 8F 14 00 B4 8F 10 00 B3 8F 0C 00 B2 8F 08 00 B1 8F 04 00 B0 8F 08 00 20 03 28 00 BD 27 65 FF A0 1E 21 88 00 00 ?? ?? ?? 0? 1C 00 62 8E 24 00 BF 8F 20 00 B7 8F 1C 00 B6 8F 18 00 B5 8F 14 00 B4 8F 10 00 B3 8F 0C 00 B2 8F 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 28 00 BD 27 ?? ?? ?? 0? 23 30 C4 00 21 20 00 00 00 00 02 82 01 00 84 24 01 00 10 26 00 00 02 A1 FB FF 83 14 01 00 08 25 23 30 C4 00 ?? ?? ?? 0? 21 80 A4 00 21 20 00 00 00 00 02 82 01 00 84 24 01 00 10 26 00 00 02 A1 FB FF 83 14 01 00 08 25 01 00 31 26 2A 10 35 02 A4 FF 40 14 21 80 A4 00 ?? ?? ?? 0? 1C 00 62 8E }
	condition:
		$1
}

rule file_24_11_0 {
	meta:
		name = "_linear_draw_trans_rle_sprite8"
		size = 1252
		refs = "0094 color_map 0120 .text"
	strings:
		$1 = { 08 00 82 8C D0 FF BD 27 14 00 B3 AF 2C 00 BF AF 28 00 BE AF 24 00 B7 AF 20 00 B6 AF 1C 00 B5 AF 18 00 B4 AF 10 00 B2 AF 0C 00 B1 AF 08 00 B0 AF 95 00 40 10 21 98 80 00 0C 00 82 8C 10 00 8B 8C 00 00 A9 8C 23 B0 46 00 21 50 00 00 23 10 66 01 2C B0 CA 02 2D 10 49 00 23 B8 56 00 21 10 C6 02 F0 00 E0 1A 00 00 A2 AF 14 00 82 8C 18 00 83 8C 04 00 A4 8C 23 40 47 00 23 18 67 00 2C 40 0A 01 2D 18 64 00 23 18 68 00 04 00 A3 AF E5 00 60 18 21 F0 07 01 ?? ?? 02 3C ?? ?? 52 8C 0E 00 00 11 10 00 B1 24 21 18 00 00 00 00 22 82 07 00 40 10 01 00 31 26 FD FF 40 58 00 00 22 82 21 88 22 02 00 00 22 82 FB FF 40 14 01 00 31 26 01 00 63 24 F6 FF 68 54 00 00 22 82 77 00 C0 12 21 10 C9 00 21 A0 00 00 24 00 63 8E 21 80 9E 02 21 20 60 02 09 F8 60 00 21 28 00 02 20 00 63 8E 21 28 00 02 21 20 60 02 09 F8 60 00 21 A8 40 00 00 00 28 82 17 00 C0 12 01 00 31 26 47 00 00 11 21 20 C0 02 ?? ?? ?? 0? 00 00 00 00 CA 00 62 04 21 88 24 02 21 88 28 02 00 00 28 82 21 20 60 00 0C 00 60 10 01 00 31 26 3D 00 00 11 04 00 A3 8F F6 FF 00 1D 23 18 88 00 21 40 04 01 05 00 00 05 21 18 00 01 21 20 60 00 00 00 28 82 F6 FF 60 14 01 00 31 26 2A 00 E0 1A 00 00 00 00 2F 00 00 11 00 00 A3 8F 21 20 E0 02 21 58 A3 02 1D 00 00 19 21 50 43 00 23 48 88 00 B1 00 20 05 21 38 20 02 21 30 60 01 21 20 40 01 21 28 00 00 00 00 E2 90 00 00 C3 90 01 00 A5 24 00 12 02 00 21 10 43 00 21 10 42 02 00 00 43 90 01 00 E7 24 01 00 C6 24 00 00 83 A0 F5 FF A8 14 01 00 84 24 21 88 25 02 00 00 28 82 21 50 45 01 21 58 65 01 0C 00 20 19 01 00 31 26 12 00 00 11 04 00 A3 8F E5 FF 00 1D 21 20 20 01 23 10 08 00 21 48 04 01 21 50 42 01 00 00 28 82 21 58 62 01 F6 FF 20 1D 01 00 31 26 07 00 00 11 04 00 A3 8F 01 00 00 5D 21 88 28 02 00 00 28 82 FC FF 00 15 01 00 31 26 04 00 A3 8F 01 00 94 26 2A 10 83 02 A8 FF 40 54 24 00 63 8E 1C 00 62 8E 21 20 60 02 2C 00 BF 8F 08 00 59 8C 28 00 BE 8F 24 00 B7 8F 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 20 03 30 00 BD 27 00 00 A9 8C ?? ?? 02 3C 10 00 B1 24 04 00 A5 8C ?? ?? 52 8C 10 00 8B 8C 21 F0 E0 00 21 B8 20 01 04 00 A5 AF 00 00 A6 AF 21 B0 00 00 21 10 C9 00 2A 10 4B 00 55 00 40 10 04 00 A3 8F 04 00 A2 8F E0 FF 40 18 21 A8 00 00 24 00 63 8E 21 80 BE 02 21 20 60 02 09 F8 60 00 21 28 00 02 20 00 63 8E 21 28 00 02 21 20 60 02 09 F8 60 00 21 A0 40 00 00 00 28 82 2A 00 E0 1A 01 00 31 26 2F 00 00 11 00 00 A3 8F 21 20 E0 02 21 58 83 02 1D 00 00 19 21 50 43 00 23 48 88 00 5F 00 20 05 21 38 60 01 21 30 40 01 21 20 20 02 21 28 00 00 00 00 82 90 00 00 E3 90 01 00 A5 24 00 12 02 00 21 10 43 00 21 10 42 02 00 00 43 90 01 00 84 24 01 00 E7 24 00 00 C3 A0 F5 FF A8 14 01 00 C6 24 21 88 25 02 00 00 28 82 21 50 45 01 21 58 65 01 0C 00 20 19 01 00 31 26 12 00 00 11 04 00 A3 8F E5 FF 00 1D 21 20 20 01 23 10 08 00 21 48 88 00 21 50 42 01 00 00 28 82 21 58 62 01 F6 FF 20 1D 01 00 31 26 07 00 00 11 04 00 A3 8F 01 00 00 5D 21 88 28 02 00 00 28 82 FC FF 00 15 01 00 31 26 04 00 A3 8F 01 00 B5 26 2A 10 A3 02 C0 FF 40 54 24 00 63 8E 1C 00 62 8E 21 20 60 02 2C 00 BF 8F 08 00 59 8C 28 00 BE 8F 24 00 B7 8F 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 20 03 30 00 BD 27 33 FF 60 1C 21 A0 00 00 ?? ?? ?? 0? 1C 00 62 8E 2C 00 BF 8F 28 00 BE 8F 24 00 B7 8F 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 E0 03 30 00 BD 27 ?? ?? ?? 0? 23 40 04 01 21 30 20 02 21 28 00 00 00 00 22 92 00 00 63 91 01 00 A5 24 00 12 02 00 21 10 43 00 21 10 42 02 00 00 43 90 01 00 31 26 01 00 6B 25 00 00 43 A1 F5 FF A4 14 01 00 4A 25 23 40 05 01 ?? ?? ?? 0? 21 88 C5 00 21 30 20 02 21 28 00 00 00 00 22 92 00 00 63 91 01 00 A5 24 00 12 02 00 21 10 43 00 21 10 42 02 00 00 43 90 01 00 31 26 01 00 6B 25 00 00 43 A1 F5 FF A4 14 01 00 4A 25 23 40 05 01 ?? ?? ?? 0? 21 88 C5 00 }
	condition:
		$1
}

rule file_24_12_0 {
	meta:
		name = "_linear_draw_lit_rle_sprite8"
		size = 1100
		refs = "0088 color_map 00e8 .text"
	strings:
		$1 = { 08 00 82 8C D8 FF BD 27 10 00 B4 AF 24 00 BF AF 20 00 BE AF 1C 00 B7 AF 18 00 B6 AF 14 00 B5 AF 0C 00 B3 AF 08 00 B2 AF 04 00 B1 AF 00 00 B0 AF 7C 00 40 10 21 A0 80 00 0C 00 83 8C 10 00 82 8C 00 00 A9 8C 23 98 66 00 23 10 46 00 21 50 00 00 2C 98 6A 02 2D 10 49 00 23 B0 53 00 E0 00 C0 5A 24 00 BF 8F 14 00 82 8C 18 00 83 8C 04 00 A4 8C 23 10 47 00 23 18 67 00 2C 10 4A 00 2D 18 64 00 23 A8 62 00 D5 00 A0 1A ?? ?? 03 3C ?? ?? 64 8C 21 B8 47 00 FF FF 47 24 FF 00 02 31 00 12 02 00 21 88 82 00 FF FF 02 24 21 F0 66 02 6C 00 E2 14 10 00 B0 24 89 00 60 52 10 00 83 8E 4A 00 A0 1A 21 90 00 00 20 00 83 8E 21 20 80 02 09 F8 60 00 21 28 57 02 00 00 07 82 17 00 60 12 01 00 10 26 3D 00 E0 10 21 20 60 02 ?? ?? ?? 0? 00 00 00 00 6C 00 62 04 21 80 04 02 21 80 07 02 00 00 07 82 21 20 60 00 0C 00 60 10 01 00 10 26 33 00 E0 50 01 00 52 26 F6 FF E0 1C 23 18 87 00 21 38 E4 00 05 00 E0 04 21 18 E0 00 21 20 60 00 00 00 07 82 F6 FF 60 14 01 00 10 26 20 00 C0 1A 00 00 00 00 25 00 E0 10 21 48 5E 00 17 00 E0 18 21 20 C0 02 23 40 87 00 55 00 00 05 21 30 00 02 21 20 20 01 21 28 00 00 00 00 C2 90 01 00 A5 24 01 00 C6 24 21 10 22 02 00 00 43 90 00 00 83 A0 F9 FF A7 14 01 00 84 24 21 80 05 02 00 00 07 82 21 48 25 01 0A 00 00 19 01 00 10 26 10 00 E0 50 01 00 52 26 EB FF E0 1C 21 20 00 01 21 40 87 00 23 48 27 01 00 00 07 82 F8 FF 00 1D 01 00 10 26 07 00 E0 50 01 00 52 26 01 00 E0 5C 21 80 07 02 00 00 07 82 FC FF E0 14 01 00 10 26 01 00 52 26 2A 10 55 02 B9 FF 40 54 20 00 83 8E 1C 00 82 8E 21 20 80 02 24 00 BF 8F 08 00 59 8C 20 00 BE 8F 1C 00 B7 8F 18 00 B6 8F 14 00 B5 8F 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 20 03 28 00 BD 27 ?? ?? 03 3C ?? ?? 64 8C 00 00 A9 8C FF 00 02 31 00 12 02 00 21 B8 E0 00 21 88 82 00 FF FF 07 24 FF FF 02 24 04 00 B5 8C 21 B0 20 01 21 F0 C0 00 21 98 00 00 96 FF E2 10 10 00 B0 24 FF FF 03 24 00 00 02 82 07 00 40 10 01 00 10 26 FD FF 40 58 00 00 02 82 21 80 02 02 00 00 02 82 FB FF 40 14 01 00 10 26 FF FF E7 24 F6 FF E3 54 00 00 02 82 11 00 60 52 10 00 83 8E ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 23 38 E4 00 21 28 00 00 00 00 02 92 01 00 A5 24 01 00 10 26 21 10 22 02 00 00 43 90 00 00 23 A1 F9 FF A4 14 01 00 29 25 23 38 E5 00 ?? ?? ?? 0? 21 80 C5 00 21 10 C9 00 2A 10 43 00 75 FF 40 10 00 00 00 00 BE FF A0 1A 21 90 00 00 20 00 83 8E 21 20 80 02 09 F8 60 00 21 28 57 02 00 00 03 82 21 00 C0 1A 01 00 10 26 1F 00 60 10 21 38 60 00 21 48 5E 00 17 00 E0 18 21 20 C0 02 23 40 87 00 38 00 00 05 21 30 20 01 21 20 00 02 21 28 00 00 00 00 82 90 01 00 A5 24 01 00 84 24 21 10 22 02 00 00 43 90 00 00 C3 A0 F9 FF A7 14 01 00 C6 24 21 80 05 02 00 00 02 82 21 48 25 01 0A 00 00 19 01 00 10 26 08 00 40 10 21 38 40 00 EB FF E0 1C 21 20 00 01 21 40 E4 00 00 00 02 82 23 48 27 01 F8 FF 00 1D 01 00 10 26 01 00 52 26 2A 10 55 02 D7 FF 40 54 20 00 83 8E 1C 00 82 8E 21 20 80 02 24 00 BF 8F 08 00 59 8C 20 00 BE 8F 1C 00 B7 8F 18 00 B6 8F 14 00 B5 8F 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 20 03 28 00 BD 27 24 00 BF 8F 20 00 BE 8F 1C 00 B7 8F 18 00 B6 8F 14 00 B5 8F 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 28 00 BD 27 21 30 00 02 21 28 00 00 00 00 02 92 01 00 A5 24 01 00 10 26 21 10 22 02 00 00 43 90 00 00 23 A1 F9 FF A4 14 01 00 29 25 01 00 52 26 2A 10 55 02 AD FF 40 14 21 80 C5 00 ?? ?? ?? 0? 1C 00 82 8E }
	condition:
		$1
}

rule file_25_0_0 {
	meta:
		name = "_linear_putpixel15"
		size = 588
		refs = "0078 _drawing_mode 0094 _drawing_y_anchor 009c _drawing_y_mask 00a4 _drawing_pattern 00b0 _drawing_x_anchor 00c0 _drawing_x_mask 012c .text 01e0 _blender_func15 01ec _blender_alpha"
	strings:
		$1 = { 08 00 82 8C E0 FF BD 27 18 00 B5 AF 14 00 B4 AF 10 00 B3 AF 08 00 B1 AF 1C 00 BF AF 0C 00 B2 AF 04 00 B0 AF 21 98 80 00 21 88 A0 00 21 A0 C0 00 11 00 40 10 21 A8 E0 00 0C 00 82 8C 2A 10 A2 00 3C 00 40 54 1C 00 BF 8F 10 00 82 8C 2A 10 A2 00 38 00 40 10 1C 00 BF 8F 14 00 82 8C 2A 10 C2 00 34 00 40 14 00 00 00 00 18 00 82 8C 2A 10 C2 00 31 00 40 50 18 00 B5 8F ?? ?? 12 3C ?? ?? 43 8E 34 00 60 10 01 00 02 24 60 00 62 10 05 00 02 24 48 00 62 10 ?? ?? 02 3C ?? ?? 43 8C ?? ?? 04 3C ?? ?? 85 8C ?? ?? 02 3C 23 18 83 02 24 18 65 00 ?? ?? 04 3C ?? ?? 45 8C 10 00 63 24 ?? ?? 82 8C ?? ?? 04 3C ?? ?? 86 8C 80 18 03 00 21 28 A3 00 00 00 A3 8C 23 10 22 02 24 10 46 00 20 00 67 8E 40 10 02 00 21 18 62 00 21 20 60 02 21 28 80 02 09 F8 E0 00 00 00 70 94 ?? ?? 44 8E 40 18 11 00 21 18 43 00 02 00 02 24 28 00 82 10 03 00 02 24 23 00 82 10 04 00 02 24 16 00 82 54 1C 00 62 8E 1F 7C 02 24 13 00 02 52 1C 00 62 8E ?? ?? ?? 0? 00 00 75 A4 18 00 B5 8F 14 00 B4 8F 10 00 B3 8F 0C 00 B2 8F 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 20 00 BD 27 20 00 66 8E 21 28 80 02 09 F8 C0 00 21 20 60 02 40 18 11 00 21 18 62 00 00 00 75 A4 1C 00 62 8E 21 20 60 02 1C 00 BF 8F 08 00 59 8C 18 00 B5 8F 14 00 B4 8F 10 00 B3 8F 0C 00 B2 8F 08 00 B1 8F 04 00 B0 8F 08 00 20 03 20 00 BD 27 1F 7C 02 24 F2 FF 02 56 00 00 75 A4 ?? ?? ?? 0? 00 00 70 A4 24 00 63 8E 21 20 60 02 09 F8 60 00 21 28 80 02 20 00 63 8E 21 28 80 02 21 20 60 02 09 F8 60 00 21 80 40 00 40 90 11 00 21 88 40 00 ?? ?? 02 3C ?? ?? 43 8C 21 80 12 02 ?? ?? 02 3C 00 00 05 96 ?? ?? 46 8C 21 20 A0 02 09 F8 60 00 21 88 32 02 ?? ?? ?? 0? 00 00 22 A6 24 00 63 8E 21 20 60 02 09 F8 60 00 21 28 80 02 20 00 63 8E 21 80 40 00 40 88 11 00 21 28 80 02 21 20 60 02 09 F8 60 00 21 80 11 02 00 00 03 96 21 10 51 00 26 18 75 00 ?? ?? ?? 0? 00 00 43 A4 }
	condition:
		$1
}

rule file_25_1_0 {
	meta:
		name = "_linear_getpixel15"
		size = 144
		refs = "0088 .text"
		altNames = "_linear_getpixel16"
	strings:
		$1 = { F0 FF BD 27 04 00 B0 AF 21 80 A0 00 08 00 B1 AF 0C 00 BF AF 21 28 C0 00 07 00 01 06 21 88 80 00 FF FF 02 24 0C 00 BF 8F 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 10 00 BD 27 00 00 82 8C 2A 10 02 02 F8 FF 40 10 FF FF 02 24 F7 FF C0 04 0C 00 BF 8F 04 00 82 8C 2A 10 C2 00 F3 FF 40 50 FF FF 02 24 24 00 83 8C 09 F8 60 00 00 00 00 00 1C 00 24 8E 40 18 10 00 21 18 62 00 00 00 70 94 08 00 82 8C 09 F8 40 00 21 20 20 02 ?? ?? ?? 0? 21 10 00 02 }
	condition:
		$1
}

rule file_25_2_0 {
	meta:
		name = "_linear_hline15"
		size = 936
		refs = "0050 _drawing_mode 00b4 _drawing_y_anchor 00bc _drawing_y_mask 00c8 _drawing_pattern 00f4 _drawing_x_anchor 00fc _drawing_x_mask 01ac .text 0260 _blender_func15 026c _blender_alpha"
	strings:
		$1 = { E0 FF BD 27 2A 10 E5 00 10 00 B4 AF 0C 00 B3 AF 08 00 B2 AF 00 00 B0 AF 1C 00 BF AF 18 00 B6 AF 14 00 B5 AF 04 00 B1 AF 21 80 A0 00 21 98 80 00 21 90 C0 00 04 00 40 10 21 A0 00 01 21 10 E0 00 21 80 40 00 21 38 A0 00 08 00 62 8E 12 00 40 10 ?? ?? 15 3C 10 00 64 8E 0C 00 62 8E 2A 18 E4 00 02 00 60 14 2C 80 02 02 FF FF 87 24 2A 10 F0 00 50 00 40 14 1C 00 BF 8F 14 00 62 8E 2A 10 42 02 4D 00 40 14 18 00 B6 8F 18 00 62 8E 2A 10 42 02 49 00 40 10 ?? ?? 15 3C ?? ?? A3 8E 4E 00 60 10 23 88 F0 00 01 00 02 24 87 00 62 10 05 00 02 24 61 00 62 10 ?? ?? 03 3C ?? ?? 62 8C ?? ?? 04 3C ?? ?? 85 8C 23 10 42 02 ?? ?? 03 3C ?? ?? 66 8C 24 10 45 00 20 00 63 8E 10 00 42 24 80 10 02 00 21 30 C2 00 21 28 40 02 21 20 60 02 09 F8 60 00 00 00 D2 8C ?? ?? 04 3C ?? ?? 83 8C ?? ?? 05 3C ?? ?? A8 8C 23 18 03 02 ?? ?? A6 8E 24 18 68 00 01 00 09 25 40 20 10 00 23 28 23 01 01 00 27 26 40 18 03 00 21 20 44 00 02 00 02 24 21 18 43 02 17 00 C2 10 2D 28 A7 00 03 00 02 24 85 00 C2 10 04 00 02 24 74 00 C2 10 1F 7C 06 24 1C 00 62 8E 21 20 60 02 1C 00 BF 8F 08 00 59 8C 18 00 B6 8F 14 00 B5 8F 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 20 03 20 00 BD 27 21 28 E0 00 0B 28 22 01 F0 FF A0 18 21 18 40 02 23 38 E5 00 00 00 62 94 FF FF A5 24 02 00 63 24 00 00 82 A4 FB FF A0 1C 02 00 84 24 ?? ?? ?? 0? 2A 10 07 01 18 00 B6 8F 14 00 B5 8F 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 20 00 BD 27 20 00 66 8E 21 20 60 02 09 F8 C0 00 21 28 40 02 40 18 10 00 21 10 43 00 FF FF 84 32 FF FF 31 26 00 00 44 A4 FD FF 21 06 02 00 42 24 1C 00 62 8E 21 20 60 02 1C 00 BF 8F 08 00 59 8C 18 00 B6 8F 14 00 B5 8F 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 20 03 20 00 BD 27 24 00 63 8E 21 28 40 02 09 F8 60 00 21 20 60 02 20 00 66 8E 40 80 10 00 21 28 40 02 21 20 60 02 09 F8 C0 00 21 90 50 00 ?? ?? 03 3C ?? ?? 75 8C 21 80 50 00 ?? ?? 16 3C 00 00 45 96 ?? ?? C6 8E 21 20 80 02 09 F8 A0 02 FF FF 31 26 00 00 02 A6 02 00 52 26 F8 FF 21 06 02 00 10 26 1C 00 62 8E 21 20 60 02 1C 00 BF 8F 08 00 59 8C 18 00 B6 8F 14 00 B5 8F 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 20 03 20 00 BD 27 24 00 63 8E 21 28 40 02 09 F8 60 00 21 20 60 02 20 00 66 8E 40 80 10 00 21 28 40 02 21 20 60 02 09 F8 C0 00 21 90 50 00 21 18 50 00 00 00 42 96 FF FF 31 26 02 00 52 26 26 10 82 02 00 00 62 A4 FA FF 21 06 02 00 63 24 ?? ?? ?? 0? 1C 00 62 8E 23 38 E5 00 00 00 62 94 FF FF A5 24 02 00 46 10 02 00 63 24 00 00 94 A4 FA FF A0 1C 02 00 84 24 2A 10 07 01 21 28 E0 00 0B 28 22 01 F4 FF A0 1C 21 18 40 02 ?? ?? ?? 0? 1C 00 62 8E 1F 7C 06 24 ?? ?? ?? 0? 23 38 E5 00 00 00 94 A4 02 00 63 24 08 00 A0 18 02 00 84 24 00 00 62 94 FA FF 46 14 FF FF A5 24 00 00 86 A4 02 00 63 24 FA FF A0 1C 02 00 84 24 2A 10 07 01 21 28 E0 00 0B 28 22 01 EF FF A0 1C 21 18 40 02 ?? ?? ?? 0? 1C 00 62 8E }
	condition:
		$1
}

rule file_25_3_0 {
	meta:
		name = "_linear_vline15"
		size = 340
		refs = "0048 _drawing_mode 0118 _linear_putpixel15"
	strings:
		$1 = { E0 FF BD 27 2A 10 E6 00 18 00 B5 AF 10 00 B3 AF 0C 00 B2 AF 08 00 B1 AF 1C 00 BF AF 14 00 B4 AF 04 00 B0 AF 21 90 E0 00 21 88 80 00 21 98 A0 00 03 00 40 10 21 A8 00 01 21 90 C0 00 21 30 E0 00 08 00 34 8E 11 00 80 12 ?? ?? 02 3C 18 00 23 8E 2A 10 43 02 02 00 40 14 14 00 24 8E FF FF 72 24 0C 00 22 8E 2A 10 62 02 32 00 40 14 1C 00 BF 8F 10 00 22 8E 2A 10 62 02 2E 00 40 10 2C 30 C4 00 2A 10 46 02 2B 00 40 14 ?? ?? 02 3C ?? ?? 43 8C 1A 00 60 14 2A 10 46 02 0C 00 40 14 40 A0 13 00 21 80 C0 00 FF FF B3 32 20 00 23 8E 21 28 00 02 09 F8 60 00 21 20 20 02 01 00 10 26 21 10 54 00 2A 18 50 02 F8 FF 60 10 00 00 53 A4 1C 00 22 8E 21 20 20 02 1C 00 BF 8F 08 00 59 8C 18 00 B5 8F 14 00 B4 8F 10 00 B3 8F 0C 00 B2 8F 08 00 B1 8F 04 00 B0 8F 08 00 20 03 20 00 BD 27 0B 00 40 14 08 00 20 AE 21 80 C0 00 21 30 00 02 21 20 20 02 01 00 10 26 21 28 60 02 ?? ?? ?? 0? 21 38 A0 02 2A 10 50 02 F9 FF 40 10 21 30 00 02 08 00 34 AE 1C 00 BF 8F 18 00 B5 8F 14 00 B4 8F 10 00 B3 8F 0C 00 B2 8F 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_78_3_0 {
	meta:
		name = "_linear_vline16"
		size = 340
		refs = "0048 _drawing_mode 0118 _linear_putpixel16"
	strings:
		$1 = { E0 FF BD 27 2A 10 E6 00 18 00 B5 AF 10 00 B3 AF 0C 00 B2 AF 08 00 B1 AF 1C 00 BF AF 14 00 B4 AF 04 00 B0 AF 21 90 E0 00 21 88 80 00 21 98 A0 00 03 00 40 10 21 A8 00 01 21 90 C0 00 21 30 E0 00 08 00 34 8E 11 00 80 12 ?? ?? 02 3C 18 00 23 8E 2A 10 43 02 02 00 40 14 14 00 24 8E FF FF 72 24 0C 00 22 8E 2A 10 62 02 32 00 40 14 1C 00 BF 8F 10 00 22 8E 2A 10 62 02 2E 00 40 10 2C 30 C4 00 2A 10 46 02 2B 00 40 14 ?? ?? 02 3C ?? ?? 43 8C 1A 00 60 14 2A 10 46 02 0C 00 40 14 40 A0 13 00 21 80 C0 00 FF FF B3 32 20 00 23 8E 21 28 00 02 09 F8 60 00 21 20 20 02 01 00 10 26 21 10 54 00 2A 18 50 02 F8 FF 60 10 00 00 53 A4 1C 00 22 8E 21 20 20 02 1C 00 BF 8F 08 00 59 8C 18 00 B5 8F 14 00 B4 8F 10 00 B3 8F 0C 00 B2 8F 08 00 B1 8F 04 00 B0 8F 08 00 20 03 20 00 BD 27 0B 00 40 14 08 00 20 AE 21 80 C0 00 21 30 00 02 21 20 20 02 01 00 10 26 21 28 60 02 ?? ?? ?? 0? 21 38 A0 02 2A 10 50 02 F9 FF 40 10 21 30 00 02 08 00 34 AE 1C 00 BF 8F 18 00 B5 8F 14 00 B4 8F 10 00 B3 8F 0C 00 B2 8F 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_26_0_0 {
	meta:
		name = "register_datafile_object"
		size = 180
		refs = "0000 _datafile_type 0014 .text"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 48 24 21 50 00 01 21 18 00 01 21 38 00 00 ?? ?? ?? 0? 20 00 09 24 01 00 E7 24 13 00 E9 50 21 18 00 00 00 00 62 8C FB FF 44 14 0C 00 63 24 05 00 A0 10 0C 00 02 24 18 00 E2 00 12 10 00 00 21 10 42 01 04 00 45 AC 06 00 C0 10 0C 00 02 24 18 00 E2 00 12 10 00 00 21 10 42 01 08 00 E0 03 08 00 46 AC 08 00 E0 03 00 00 00 00 FF FF 09 24 ?? ?? ?? 0? 20 00 07 24 01 00 63 24 F9 FF 67 10 00 00 00 00 00 00 02 8D FB FF 49 14 0C 00 08 25 0C 00 02 24 18 00 62 00 12 10 00 00 21 10 42 01 08 00 46 AC 00 00 44 AC 08 00 E0 03 04 00 45 AC }
	condition:
		$1
}

rule file_27_0_0 {
	meta:
		name = "load_grx_font"
		size = 644
		refs = "0000 $LC0 0030 pack_fopen 0040 pack_igetl 0060 _al_malloc 0078 font_vtable_mono 0090 pack_igetw 0100 pack_getc 0144 .text 01d4 pack_fread 01e8 pack_fclose 01f8 _al_free"
	strings:
		$1 = { ?? ?? 05 3C C8 FF BD 27 ?? ?? A5 24 18 00 B2 AF 34 00 BF AF 30 00 BE AF 2C 00 B7 AF 28 00 B6 AF 24 00 B5 AF 20 00 B4 AF 1C 00 B3 AF 14 00 B1 AF ?? ?? ?? 0? 10 00 B0 AF 80 00 40 10 21 90 40 00 ?? ?? ?? 0? 21 20 40 00 59 19 03 3C 14 02 63 34 78 00 43 14 00 00 00 00 ?? ?? ?? 0? 21 20 40 02 ?? ?? ?? 0? 0C 00 04 24 10 00 04 24 ?? ?? ?? 0? 04 00 A2 AF 21 80 40 00 ?? ?? 02 3C ?? ?? 43 8C 04 00 A2 8F 21 20 40 02 0C 00 00 AE 08 00 43 AC ?? ?? ?? 0? 00 00 50 AC 21 20 40 02 ?? ?? ?? 0? 21 A8 40 00 04 00 A3 8F 21 20 40 02 00 00 A2 AF ?? ?? ?? 0? 04 00 62 AC 00 00 02 AE ?? ?? ?? 0? 21 20 40 02 00 00 03 8E 01 00 42 24 04 00 02 AE 23 B0 43 00 80 98 16 00 ?? ?? ?? 0? 21 20 60 02 08 00 02 AE 21 20 40 02 ?? ?? ?? 0? 08 00 A2 AF 16 00 40 14 21 80 00 00 26 00 11 24 01 00 10 26 ?? ?? ?? 0? 21 20 40 02 FD FF 11 56 01 00 10 26 ?? ?? ?? 0? 21 20 60 02 33 00 C0 1A 21 A0 40 00 21 88 40 00 21 80 00 00 01 00 10 26 ?? ?? ?? 0? 21 20 40 02 2A 18 16 02 00 00 22 AE FA FF 60 14 04 00 31 26 ?? ?? ?? 0? 00 00 A2 8F 26 00 11 24 01 00 10 26 ?? ?? ?? 0? 21 20 40 02 FD FF 11 56 01 00 10 26 43 00 C0 1A 21 A0 00 00 00 00 A2 8F 21 98 00 00 21 88 00 00 20 F6 02 7C 08 00 17 24 01 00 73 26 02 00 80 12 21 10 91 02 00 00 55 8C 07 00 B0 26 02 00 E0 16 1A 00 17 02 CD 01 00 00 00 00 A2 8F 12 80 00 00 18 00 02 02 12 80 00 00 ?? ?? ?? 0? 04 00 04 26 08 00 A4 8F 00 00 55 A4 02 00 5E A4 21 18 91 00 00 00 62 AC 04 00 44 24 21 28 00 02 ?? ?? ?? 0? 21 30 40 02 2A 18 76 02 E7 FF 60 14 04 00 31 26 ?? ?? ?? 0? 21 20 40 02 04 00 80 12 34 00 BF 8F ?? ?? ?? 0? 21 20 80 02 34 00 BF 8F 04 00 A2 8F 30 00 BE 8F 2C 00 B7 8F 28 00 B6 8F 24 00 B5 8F 20 00 B4 8F 1C 00 B3 8F 18 00 B2 8F 14 00 B1 8F 10 00 B0 8F 08 00 E0 03 38 00 BD 27 ?? ?? ?? 0? 21 20 40 02 34 00 BF 8F 04 00 A0 AF 04 00 A2 8F 30 00 BE 8F 2C 00 B7 8F 28 00 B6 8F 24 00 B5 8F 20 00 B4 8F 1C 00 B3 8F 18 00 B2 8F 14 00 B1 8F 10 00 B0 8F 08 00 E0 03 38 00 BD 27 ?? ?? ?? 0? 21 20 40 02 ?? ?? ?? 0? 34 00 BF 8F }
	condition:
		$1
}

rule file_27_1_0 {
	meta:
		name = "load_grx_or_bios_font"
		size = 236
		refs = "0024 get_extension 002c $LC1 004c uconvert 0058 ustricmp 0064 $LC0 0090 pack_fopen 00a0 pack_igetl 00ac pack_fclose 00c8 load_bios_font 00d0 .text 00dc load_grx_font"
	strings:
		$1 = { D8 FF BD 27 24 00 BF AF 1C 00 B3 AF 18 00 B2 AF 14 00 B1 AF 10 00 B0 AF 21 90 A0 00 21 98 C0 00 21 88 80 00 ?? ?? ?? 0? 20 00 B4 AF ?? ?? 04 3C 53 41 05 3C 75 63 07 3C ?? ?? 84 24 38 43 A5 34 2E 72 E7 34 21 30 A0 03 10 00 08 24 ?? ?? ?? 0? 21 80 40 00 21 28 40 00 ?? ?? ?? 0? 21 20 00 02 0A 00 40 10 ?? ?? 05 3C 21 10 00 00 24 00 BF 8F 20 00 B4 8F 1C 00 B3 8F 18 00 B2 8F 14 00 B1 8F 10 00 B0 8F 08 00 E0 03 28 00 BD 27 ?? ?? A5 24 ?? ?? ?? 0? 21 20 20 02 F3 FF 40 10 21 A0 40 00 ?? ?? ?? 0? 21 20 40 00 21 20 80 02 ?? ?? ?? 0? 21 80 40 00 59 19 03 3C 14 02 63 34 06 00 03 12 21 28 40 02 21 20 20 02 ?? ?? ?? 0? 21 30 60 02 ?? ?? ?? 0? 24 00 BF 8F 21 20 20 02 ?? ?? ?? 0? 21 30 60 02 ?? ?? ?? 0? 24 00 BF 8F }
	condition:
		$1
}

rule file_28_1_0 {
	meta:
		name = "psp_poll_keyboard"
		size = 224
		refs = "0024 sceCtrlPeekBufferPositive 002c .rodata 003c .text 0040 .bss 0044 scancode_to_ascii 0050 _handle_key_press 0090 _handle_key_release"
	strings:
		$1 = { D8 FF BD 27 21 20 A0 03 01 00 05 24 20 00 B4 AF 1C 00 B3 AF 18 00 B2 AF 14 00 B1 AF 24 00 BF AF 10 00 B0 AF ?? ?? ?? 0? ?? ?? 14 3C ?? ?? 02 3C ?? ?? 03 3C ?? ?? 51 24 ?? ?? 73 24 ?? ?? ?? 0? ?? ?? 92 26 ?? ?? ?? 0? 21 20 00 02 21 20 40 00 ?? ?? ?? 0? 21 28 00 02 08 00 31 26 11 00 71 12 00 00 A2 8F 04 00 A4 8F 04 00 43 8E FC FF 22 8E 26 18 83 00 24 20 44 00 24 10 43 00 F7 FF 40 50 08 00 31 26 EF FF 80 54 00 00 30 8E 00 00 24 8E ?? ?? ?? 0? 08 00 31 26 F3 FF 71 16 04 00 A4 8F 00 00 A2 8F 04 00 A3 8F 24 00 BF 8F ?? ?? 82 AE 04 00 43 AE 0C 00 A2 8F 08 00 A3 8F 20 00 B4 8F 0C 00 42 AE 08 00 43 AE 1C 00 B3 8F 18 00 B2 8F 14 00 B1 8F 10 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_28_2_0 {
	meta:
		name = "psp_keyboard_init"
		size = 36
		refs = "000c _psp_init_controller"
	strings:
		$1 = { F8 FF BD 27 21 20 00 00 04 00 BF AF ?? ?? ?? 0? 21 28 00 00 04 00 BF 8F 21 10 00 00 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_29_0_0 {
	meta:
		name = "psp_timer_exit"
		size = 20
		refs = "0000 .bss 000c sceKernelDeleteThread"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 44 8C ?? ?? 03 3C ?? ?? ?? 0? ?? ?? 60 AC }
	condition:
		$1
}

rule file_29_1_0 {
	meta:
		name = "psp_timer_init"
		size = 180
		refs = "0008 sceRtcGetTickResolution 0014 $LC0 0010 .bss 0018 .text 0040 sceKernelCreateThread 005c sceKernelStartThread 0068 $LC2 007c get_config_text 0084 allegro_error 0090 ustrzcpy 00a8 $LC1"
	strings:
		$1 = { F8 FF BD 27 04 00 BF AF ?? ?? ?? 0? 00 00 00 00 ?? ?? 03 3C ?? ?? 04 3C ?? ?? 05 3C ?? ?? 84 24 ?? ?? 62 AC FF FF 0A 24 ?? ?? 02 3C ?? ?? A5 24 18 00 06 24 01 00 07 3C 21 40 00 00 21 48 00 00 ?? ?? ?? 0? ?? ?? 4A AC 21 20 40 00 ?? ?? 02 3C 15 00 80 04 ?? ?? 44 AC 21 28 00 00 ?? ?? ?? 0? 21 30 00 00 04 00 40 14 ?? ?? 04 3C 04 00 BF 8F 08 00 E0 03 08 00 BD 27 ?? ?? 84 24 ?? ?? ?? 0? 00 00 00 00 ?? ?? 04 3C ?? ?? 84 24 21 30 40 00 ?? ?? ?? 0? 00 01 05 24 ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? FF FF 02 24 ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 84 24 }
	condition:
		$1
}

rule file_37_6_20 {
	meta:
		name = "_D3std8typeinfo7ti_void10TypeInfo_v7getHashMFPvZk"
		size = 16
		refs = "0008 abort"
	strings:
		$1 = { F8 FF BD 27 04 00 BF AF ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_29_89_20 {
	meta:
		name = "_D6object14TypeInfo_Tuple4swapMFPvPvZv"
		size = 16
		refs = "0008 abort"
	strings:
		$1 = { F8 FF BD 27 04 00 BF AF ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_29_90_20 {
	meta:
		name = "_D6object14TypeInfo_Tuple5tsizeMFZk"
		size = 16
		refs = "0008 abort"
	strings:
		$1 = { F8 FF BD 27 04 00 BF AF ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_29_92_20 {
	meta:
		name = "_D6object14TypeInfo_Tuple6equalsMFPvPvZi"
		size = 16
		refs = "0008 abort"
	strings:
		$1 = { F8 FF BD 27 04 00 BF AF ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_29_91_20 {
	meta:
		name = "_D6object14TypeInfo_Tuple7compareMFPvPvZi"
		size = 16
		refs = "0008 abort"
	strings:
		$1 = { F8 FF BD 27 04 00 BF AF ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_29_93_20 {
	meta:
		name = "_D6object14TypeInfo_Tuple7getHashMFPvZk"
		size = 16
		refs = "0008 abort"
	strings:
		$1 = { F8 FF BD 27 04 00 BF AF ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_577_0_8 {
	meta:
		name = "_Exit"
		size = 16
		refs = "0008 _exit"
	strings:
		$1 = { F8 FF BD 27 04 00 BF AF ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_22_0_68 {
	meta:
		name = "__cxa_pure_virtual"
		size = 16
		refs = "0008 abort"
	strings:
		$1 = { F8 FF BD 27 04 00 BF AF ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_29_2_0 {
	meta:
		name = "psp_timer_thread"
		size = 408
		refs = "0030 sceRtcGetCurrentTick 0038 .bss 0040 $LC3 0048 $LC4 004c $LC5 0060 .text 006c sceKernelDelayThreadCB 00a4 __floatundisf 00dc _handle_timer_tick 0134 sceKernelExitThread"
	strings:
		$1 = { B0 FF BD 27 34 00 B4 AF 21 20 A0 03 ?? ?? 14 3C 3C 00 BF AF 38 00 B5 AF 30 00 B3 AF 2C 00 B2 AF 28 00 B1 AF 24 00 B0 AF 4C 00 B6 E7 48 00 B5 E7 ?? ?? ?? 0? 44 00 B4 E7 ?? ?? 83 8E 3D 00 60 10 ?? ?? 02 3C ?? ?? 54 C4 ?? ?? 03 3C ?? ?? 02 3C ?? ?? 76 C4 ?? ?? 55 C4 08 00 B3 27 ?? ?? 12 3C ?? ?? ?? 0? 00 80 15 3C 18 00 A0 E7 ?? ?? ?? 0? 18 00 A4 8F ?? ?? 83 8E 2E 00 60 10 00 00 00 00 ?? ?? ?? 0? 21 20 60 02 08 00 B0 8F 00 00 A2 8F 0C 00 B1 8F 23 20 02 02 04 00 A2 8F 2B 18 04 02 23 28 22 02 ?? ?? ?? 0? 23 28 A3 00 ?? ?? 42 8E 46 00 00 46 2E 00 40 04 10 00 A2 AF 00 10 82 44 00 00 00 00 20 10 80 46 03 A0 00 46 00 00 B0 AF 02 08 00 46 0D 00 00 46 00 00 04 44 ?? ?? ?? 0? 04 00 B1 AF 00 08 82 44 00 00 00 00 20 08 80 46 03 00 14 46 02 00 16 46 3E A8 00 46 00 00 00 00 D9 FF 02 45 0D 00 00 46 01 00 15 46 0D 00 00 46 00 00 02 44 00 00 00 00 25 10 55 00 18 00 A2 AF ?? ?? ?? 0? 18 00 A4 8F ?? ?? 83 8E D4 FF 60 14 00 00 00 00 ?? ?? ?? 0? 21 20 00 00 3C 00 BF 8F 21 10 00 00 38 00 B5 8F 34 00 B4 8F 30 00 B3 8F 2C 00 B2 8F 28 00 B1 8F 24 00 B0 8F 4C 00 B6 C7 48 00 B5 C7 44 00 B4 C7 08 00 E0 03 50 00 BD 27 10 00 A3 8F 42 10 03 00 01 00 63 30 14 00 A3 AF 25 18 62 00 00 10 83 44 00 00 00 00 20 10 80 46 ?? ?? ?? 0? 00 00 00 46 }
	condition:
		$1
}

rule file_30_0_0 {
	meta:
		name = "vmm_init"
		size = 80
		refs = "0018 _al_malloc 0034 .bss"
	strings:
		$1 = { F0 FF BD 27 08 00 B1 AF 21 88 80 00 0C 00 04 24 04 00 B0 AF 0C 00 BF AF ?? ?? ?? 0? 21 80 A0 00 06 00 40 10 21 18 40 00 08 00 40 AC 00 00 51 AC 04 00 50 AC ?? ?? 02 3C ?? ?? 43 AC 0C 00 BF 8F 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 10 00 BD 27 }
	condition:
		$1
}

rule file_30_1_0 {
	meta:
		name = "vmm_merge"
		size = 220
		refs = "0068 .bss 008c _al_free 00b4 .text"
	strings:
		$1 = { F8 FF BD 27 00 00 B0 AF 21 80 80 00 08 00 84 8C 11 00 80 10 04 00 BF AF 04 00 05 8E 00 00 02 8E 00 00 83 8C 21 10 A2 00 1A 00 43 50 04 00 82 8C 21 80 80 00 08 00 04 8E 08 00 80 50 04 00 BF 8F 04 00 05 8E 00 00 02 8E 00 00 83 8C 21 10 A2 00 05 00 43 50 04 00 82 8C 04 00 BF 8F 00 00 B0 8F 08 00 E0 03 08 00 BD 27 ?? ?? 06 3C ?? ?? C3 8C 21 10 45 00 16 00 83 10 04 00 02 AE 08 00 82 8C 08 00 02 AE 04 00 BF 8F 00 00 B0 8F ?? ?? ?? 0? 08 00 BD 27 ?? ?? 06 3C ?? ?? C3 8C 21 10 45 00 06 00 83 10 04 00 02 AE 08 00 82 8C ?? ?? ?? 0? 08 00 02 AE ?? ?? ?? 0? 08 00 04 8E 08 00 82 8C ?? ?? ?? 0? ?? ?? C2 AC ?? ?? ?? 0? 08 00 04 8E 08 00 82 8C ?? ?? ?? 0? ?? ?? C2 AC }
	condition:
		$1
}

rule file_30_2_0 {
	meta:
		name = "vmm_free_mem"
		size = 184
		refs = "0018 _al_malloc 0028 .bss 0064 .text"
	strings:
		$1 = { F0 FF BD 27 04 00 B0 AF 21 80 80 00 0C 00 04 24 08 00 B1 AF 0C 00 BF AF ?? ?? ?? 0? 21 88 A0 00 20 00 40 10 21 28 40 00 ?? ?? 03 3C ?? ?? 64 8C 04 00 51 AC 05 00 80 10 00 00 50 AC 00 00 82 8C 2B 10 50 00 0E 00 40 54 08 00 83 8C 08 00 A4 AC 0C 00 BF 8F 08 00 B1 8F 04 00 B0 8F 21 20 A0 00 10 00 BD 27 ?? ?? ?? 0? ?? ?? 65 AC 2B 10 50 00 06 00 40 50 08 00 A3 AC 21 20 60 00 08 00 83 8C FA FF 60 54 00 00 62 8C 08 00 A3 AC 0C 00 BF 8F 08 00 B1 8F 04 00 B0 8F 08 00 85 AC ?? ?? ?? 0? 10 00 BD 27 0C 00 BF 8F 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 10 00 BD 27 }
	condition:
		$1
}

rule file_30_3_0 {
	meta:
		name = "vmm_alloc_mem"
		size = 188
		refs = "0000 .bss 002c .text 0090 _al_free"
	strings:
		$1 = { ?? ?? 08 3C ?? ?? 07 8D F8 FF BD 27 04 00 BF AF 00 00 B0 AF 0E 00 E0 10 21 30 80 00 04 00 E3 8C 2B 10 64 00 10 00 40 10 21 28 E0 00 ?? ?? ?? 0? 08 00 A4 8C 2B 10 66 00 0E 00 40 50 00 00 90 8C 21 28 80 00 08 00 A4 8C FA FF 80 54 04 00 83 8C 21 80 00 00 04 00 BF 8F 21 10 00 02 00 00 B0 8F 08 00 E0 03 08 00 BD 27 21 20 E0 00 21 28 00 00 00 00 90 8C 23 18 66 00 04 00 83 AC 21 10 D0 00 F4 FF 60 14 00 00 82 AC 08 00 87 10 08 00 82 8C ?? ?? ?? 0? 08 00 A2 AC 04 00 BF 8F 21 10 00 02 00 00 B0 8F 08 00 E0 03 08 00 BD 27 ?? ?? ?? 0? ?? ?? 02 AD ?? ?? ?? 0? 04 00 BF 8F }
	condition:
		$1
}

rule file_31_0_0 {
	meta:
		name = "load_lbm"
		size = 2552
		refs = "0038 _color_load_depth 0040 $LC0 004c pack_fopen 0068 pack_igetl 00dc pack_mgetl 00f0 pack_mgetw 0108 pack_igetw 0118 pack_getc 0160 allegro_errno 0258 pack_feof 0268 pack_fclose 02c8 create_bitmap_ex 02f4 memset 0308 _al_malloc 03c8 .text 03d0 pack_fread 0674 _fixup_loaded_bitmap 0764 memcpy 0780 _al_free 09d8 destroy_bitmap"
	strings:
		$1 = { 70 FB BD 27 68 04 B0 AF 44 04 A5 AF 21 80 80 00 21 28 00 00 08 00 04 24 8C 04 BF AF 74 04 B3 AF 88 04 BE AF 84 04 B7 AF 80 04 B6 AF 7C 04 B5 AF 78 04 B4 AF 70 04 B2 AF ?? ?? ?? 0? 6C 04 B1 AF ?? ?? 05 3C 21 20 00 02 ?? ?? A5 24 ?? ?? ?? 0? 0C 04 A2 AF 21 98 40 00 44 04 A2 8F 0A 10 A2 03 87 00 60 12 44 04 A2 AF ?? ?? ?? 0? 21 20 60 02 52 4D 03 3C 46 4F 63 34 C7 01 43 14 00 00 00 00 ?? ?? ?? 0? 21 20 60 02 ?? ?? ?? 0? 21 20 60 02 21 18 40 00 42 4D 02 3C 49 4C 42 34 04 00 62 10 4D 20 02 3C 50 42 42 34 BB 01 62 14 00 00 00 00 B2 DF 02 3C B0 BD 42 34 21 10 62 00 01 00 42 2C 21 20 60 02 ?? ?? ?? 0? 1C 04 A2 AF 48 44 03 3C 42 4D 63 34 B0 01 43 14 00 00 00 00 ?? ?? ?? 0? 21 20 60 02 14 00 03 24 AB 01 43 14 00 00 00 00 ?? ?? ?? 0? 21 20 60 02 21 20 60 02 ?? ?? ?? 0? 24 04 A2 AF 21 20 60 02 ?? ?? ?? 0? 20 04 A2 AF ?? ?? ?? 0? 21 20 60 02 ?? ?? ?? 0? 21 20 60 02 20 14 02 7C 14 04 A2 AF 09 00 42 28 9A 01 40 10 00 00 00 00 ?? ?? ?? 0? 21 20 60 02 ?? ?? ?? 0? 21 20 60 02 20 14 02 7C 18 04 A2 AF FF 00 42 30 02 00 42 2C 90 01 40 10 24 04 A3 8F 20 04 A2 8F ?? ?? 04 3C 07 00 65 30 18 00 43 00 4C 04 A5 AF 12 10 00 00 40 04 A2 AF ?? ?? 82 8C 21 20 60 02 ?? ?? ?? 0? 00 00 40 AC ?? ?? ?? 0? 21 20 60 02 ?? ?? ?? 0? 21 20 60 02 ?? ?? ?? 0? 21 20 60 02 ?? ?? ?? 0? 21 20 60 02 ?? ?? ?? 0? 21 20 60 02 24 04 A6 8F 4C 04 A3 8F 28 04 A0 AF C3 20 06 00 01 00 82 24 0B 20 43 00 60 04 A4 AF 05 00 65 28 06 00 64 28 04 00 66 28 03 00 62 28 10 04 A0 AF 50 04 A4 AF 54 04 A5 AF 58 04 A6 AF 5C 04 A2 AF ?? ?? ?? 0? 21 20 60 02 41 50 03 3C 43 4D 63 34 EB 00 43 10 44 04 A4 8F 44 59 04 3C 42 4F 84 34 29 00 44 10 00 00 00 00 ?? ?? ?? 0? 21 20 60 02 21 18 40 00 01 00 42 30 01 00 40 54 01 00 63 24 43 88 03 00 08 00 20 1A 00 00 00 00 21 80 00 00 01 00 10 26 ?? ?? ?? 0? 21 20 60 02 2A 18 11 02 FC FF 60 54 01 00 10 26 ?? ?? ?? 0? 21 20 60 02 E3 FF 40 10 00 00 00 00 ?? ?? ?? 0? 21 20 60 02 10 04 A2 8F 02 00 43 30 D7 01 60 14 00 00 00 00 28 04 A0 AF 8C 04 BF 8F 28 04 A2 8F 88 04 BE 8F 84 04 B7 8F 80 04 B6 8F 7C 04 B5 8F 78 04 B4 8F 74 04 B3 8F 70 04 B2 8F 6C 04 B1 8F 68 04 B0 8F 08 00 E0 03 90 04 BD 27 ?? ?? ?? 0? 21 20 60 02 24 04 A5 8F 20 04 A6 8F ?? ?? ?? 0? 08 00 04 24 C5 01 40 10 28 04 A2 AF 28 04 A3 8F 24 04 B5 8F 1C 04 A2 8F 40 00 64 8C 60 04 A3 8F 40 04 A6 8F 21 28 00 00 ?? ?? ?? 0? 0A A8 62 00 01 00 A3 32 01 00 60 54 01 00 B5 26 ?? ?? ?? 0? 21 20 A0 02 21 01 40 10 21 A0 40 00 1C 04 A4 8F E5 00 80 14 20 04 A2 8F 20 04 A5 8F 15 01 A0 18 FF FF A2 26 C0 30 02 00 3C 04 A6 AF 21 18 C0 00 21 20 C0 00 4C 04 A6 8F 21 28 A0 02 02 00 63 24 0B 28 46 00 04 00 84 24 48 04 A5 AF 04 04 A3 AF 34 04 A4 AF 21 F0 82 02 3C 04 A3 8F 3C 04 A2 8F 3C 04 A4 8F 3C 04 A5 8F 48 04 A6 8F 28 04 B2 8F 01 00 42 24 03 00 63 24 05 00 84 24 06 00 A5 24 08 04 A2 AF 38 04 A3 AF 30 04 A4 AF 2C 04 A5 AF 00 04 A0 AF 21 B0 86 02 14 04 A4 8F 65 01 80 18 00 04 A6 8F 21 B8 00 00 18 04 A6 8F 6D 01 C0 10 21 20 80 02 22 00 A0 1A 48 04 A4 8F ?? ?? ?? 0? 21 88 00 00 ?? ?? ?? 0? 21 88 30 02 2A 10 35 02 1B 00 40 10 48 04 A4 8F ?? ?? ?? 0? 21 20 60 02 FF 00 47 30 01 00 E2 24 FF 00 50 30 20 1C 07 7C 21 20 91 02 21 28 00 02 21 30 60 02 F1 FF 61 04 81 00 E2 2C F2 FF 40 14 2A 10 35 02 01 00 02 24 23 80 47 00 ?? ?? ?? 0? 21 20 60 02 FF 00 10 32 21 20 91 02 20 2C 02 7C 21 30 00 02 ?? ?? ?? 0? 21 88 30 02 2A 10 35 02 E7 FF 40 14 48 04 A4 8F 01 00 03 24 04 10 E3 02 E0 00 80 18 FF 00 47 30 21 28 80 02 ?? ?? ?? 0? 21 30 00 00 40 00 62 30 09 00 40 10 20 00 62 30 40 00 42 8E 01 00 C4 24 21 10 44 00 00 00 43 90 25 18 E3 00 00 00 43 A0 00 00 A3 90 20 00 62 30 09 00 40 10 10 00 62 30 40 00 42 8E 02 00 C4 24 21 10 44 00 00 00 43 90 25 18 E3 00 00 00 43 A0 00 00 A3 90 10 00 62 30 09 00 40 10 08 00 62 30 40 00 42 8E 03 00 C4 24 21 10 44 00 00 00 43 90 25 18 E3 00 00 00 43 A0 00 00 A3 90 08 00 62 30 09 00 40 10 04 00 62 30 40 00 42 8E 04 00 C4 24 21 10 44 00 00 00 43 90 25 18 E3 00 00 00 43 A0 00 00 A3 90 04 00 62 30 09 00 40 10 02 00 62 30 40 00 42 8E 05 00 C4 24 21 10 44 00 00 00 43 90 25 18 E3 00 00 00 43 A0 00 00 A3 90 02 00 62 30 09 00 40 10 01 00 62 30 40 00 42 8E 06 00 C4 24 21 10 44 00 00 00 43 90 25 18 E3 00 00 00 43 A0 00 00 A3 90 01 00 62 30 07 00 40 10 01 00 A5 24 40 00 42 8E 07 00 C4 24 21 10 44 00 00 00 43 90 25 18 E3 00 00 00 43 A0 96 00 B6 10 08 00 C6 24 00 00 A3 90 20 14 03 7C B7 FF 41 04 40 00 62 30 40 00 43 8E 21 18 66 00 00 00 62 90 25 10 E2 00 00 00 62 A0 ?? ?? ?? 0? 00 00 A3 90 21 28 00 00 ?? ?? ?? 0? 00 03 06 24 ?? ?? ?? 0? 21 20 60 02 03 00 03 24 02 00 60 14 1A 00 43 00 CD 01 00 00 12 90 00 00 14 00 40 1A 10 04 A2 8F 44 04 B0 8F 21 88 00 00 ?? ?? ?? 0? 21 20 60 02 83 10 02 00 00 00 02 A2 ?? ?? ?? 0? 21 20 60 02 83 10 02 00 01 00 02 A2 ?? ?? ?? 0? 21 20 60 02 01 00 31 26 83 10 02 00 2A 18 32 02 02 00 02 A2 F1 FF 60 14 04 00 10 26 10 04 A2 8F 01 00 42 34 10 04 A2 AF 10 04 A6 8F 03 00 02 24 06 FF C2 14 00 00 00 00 ?? ?? ?? 0? 21 20 60 02 ?? ?? 04 3C ?? ?? 83 8C 00 00 62 8C DF 00 40 14 0C 04 A3 8F 08 00 02 24 08 FF 62 10 8C 04 BF 8F 28 04 A4 8F 44 04 A5 8F ?? ?? ?? 0? 21 30 60 00 8C 04 BF 8F 28 04 A2 AF 28 04 A2 8F 88 04 BE 8F 84 04 B7 8F 80 04 B6 8F 7C 04 B5 8F 78 04 B4 8F 74 04 B3 8F 70 04 B2 8F 6C 04 B1 8F 68 04 B0 8F 08 00 E0 03 90 04 BD 27 32 00 40 18 00 00 00 00 28 04 B2 8F 21 B0 00 00 18 04 A3 8F B5 00 60 10 21 20 80 02 23 00 A0 5A 40 00 44 8E ?? ?? ?? 0? 21 88 00 00 ?? ?? ?? 0? 21 88 30 02 2A 10 35 02 1C 00 40 50 40 00 44 8E ?? ?? ?? 0? 21 20 60 02 FF 00 47 30 01 00 E2 24 FF 00 50 30 20 1C 07 7C 21 20 91 02 21 28 00 02 21 30 60 02 F1 FF 61 04 81 00 E2 2C F2 FF 40 14 2A 10 35 02 01 00 04 24 23 80 87 00 ?? ?? ?? 0? 21 20 60 02 FF 00 10 32 21 20 91 02 20 2C 02 7C 21 30 00 02 ?? ?? ?? 0? 21 88 30 02 2A 10 35 02 E7 FF 40 14 00 00 00 00 40 00 44 8E 21 28 80 02 ?? ?? ?? 0? 21 30 A0 02 20 04 A5 8F 01 00 D6 26 2A 18 C5 02 D2 FF 60 14 04 00 52 26 ?? ?? ?? 0? 21 20 80 02 10 04 A5 8F 02 00 A5 34 ?? ?? ?? 0? 10 04 A5 AF ?? ?? ?? 0? 21 20 60 02 8C 04 BF 8F 28 04 A0 AF 28 04 A2 8F 88 04 BE 8F 84 04 B7 8F 80 04 B6 8F 7C 04 B5 8F 78 04 B4 8F 74 04 B3 8F 70 04 B2 8F 6C 04 B1 8F 68 04 B0 8F 08 00 E0 03 90 04 BD 27 4C 04 A5 8F 52 00 A0 50 14 04 A5 8F 00 00 C3 93 20 14 03 7C 65 00 42 04 40 00 43 8E 40 00 62 30 0C 00 40 10 20 00 62 30 4C 04 A2 8F 01 00 04 24 07 00 44 10 08 04 A5 8F 40 00 43 8E 21 18 65 00 00 00 62 90 25 10 E2 00 00 00 62 A0 00 00 C3 93 20 00 62 30 0C 00 40 10 10 00 62 30 5C 04 A6 8F 09 00 C0 14 00 00 00 00 04 04 A2 8F 40 00 43 8E 21 18 62 00 00 00 62 90 25 10 E2 00 00 00 62 A0 00 00 C3 93 10 00 62 30 0B 00 40 10 08 00 62 30 58 04 A4 8F 08 00 80 14 38 04 A5 8F 40 00 43 8E 21 18 65 00 00 00 62 90 25 10 E2 00 00 00 62 A0 00 00 C3 93 08 00 62 30 0C 00 40 10 04 00 62 30 54 04 A6 8F 09 00 C0 14 00 00 00 00 34 04 A2 8F 40 00 43 8E 21 18 62 00 00 00 62 90 25 10 E2 00 00 00 62 A0 00 00 C3 93 04 00 62 30 0B 00 40 10 02 00 62 30 50 04 A4 8F 08 00 80 14 30 04 A5 8F 40 00 43 8E 21 18 65 00 00 00 62 90 25 10 E2 00 00 00 62 A0 00 00 C3 93 02 00 62 30 0C 00 40 10 14 04 A5 8F 4C 04 A6 8F 07 00 02 24 09 00 C2 54 01 00 F7 26 40 00 43 8E 2C 04 A4 8F 21 18 64 00 00 00 62 90 25 10 E2 00 00 00 62 A0 14 04 A5 8F 01 00 F7 26 20 14 17 7C 2A 10 45 00 A0 FE 40 14 18 04 A6 8F 00 04 A6 8F 20 04 A3 8F 04 00 52 26 01 00 C6 24 2A 10 C3 00 94 FE 40 14 00 04 A6 AF ?? ?? ?? 0? 21 20 80 02 10 04 A5 8F 02 00 A5 34 ?? ?? ?? 0? 10 04 A5 AF 21 28 A0 02 ?? ?? ?? 0? 21 30 60 02 ?? ?? ?? 0? 48 04 A4 8F 3C 04 A6 8F 21 18 66 00 00 00 62 90 25 10 E2 00 00 00 62 A0 ?? ?? ?? 0? 00 00 C3 93 21 28 A0 02 ?? ?? ?? 0? 21 30 60 02 40 00 44 8E 21 28 80 02 ?? ?? ?? 0? 21 30 A0 02 20 04 A5 8F 01 00 D6 26 2A 18 C5 02 3E FF 60 14 04 00 52 26 ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 28 04 A4 8F ?? ?? ?? 0? 28 04 A0 AF ?? ?? ?? 0? 21 20 60 02 ?? ?? ?? 0? 8C 04 BF 8F }
	condition:
		$1
}

rule file_32_0_0 {
	meta:
		name = "makecol15_dither"
		size = 208
		refs = "0000 .rodata 0074 _rgb_b_shift_15 0078 _rgb_r_shift_15 0090 _rgb_g_shift_15"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 24 07 00 08 31 21 40 02 01 00 00 0B 91 ?? ?? 02 3C ?? ?? 42 24 07 00 83 30 21 18 62 00 21 58 67 01 07 00 C9 30 07 00 6B 31 00 00 6A 90 21 48 22 01 07 00 A8 30 21 40 02 01 03 00 67 25 00 00 22 91 07 00 E7 30 00 00 09 91 07 00 E3 24 07 50 6A 01 07 10 E2 00 07 00 63 30 C3 20 04 00 01 00 4A 31 21 50 44 01 07 48 69 00 C3 30 06 00 ?? ?? 03 3C ?? ?? 04 3C 01 00 42 30 21 10 46 00 ?? ?? 67 8C ?? ?? 86 8C C3 28 05 00 ?? ?? 03 3C 01 00 29 31 21 48 25 01 43 21 0A 00 ?? ?? 65 8C 43 19 02 00 23 10 43 00 23 50 44 01 43 19 09 00 04 10 E2 00 04 50 CA 00 23 48 23 01 25 10 4A 00 04 48 A9 00 08 00 E0 03 25 10 49 00 }
	condition:
		$1
}

rule file_32_1_0 {
	meta:
		name = "makecol16_dither"
		size = 212
		refs = "0000 .rodata 0078 _rgb_b_shift_16 007c _rgb_r_shift_16 0094 _rgb_g_shift_16"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 24 07 00 08 31 21 40 02 01 00 00 0B 91 ?? ?? 02 3C ?? ?? 42 24 07 00 83 30 21 18 62 00 21 58 67 01 07 00 C8 30 03 00 A9 30 07 00 6B 31 00 00 6A 90 21 40 02 01 40 48 09 00 21 48 22 01 03 00 67 25 00 00 02 91 07 00 E7 30 00 00 28 91 07 00 E3 24 07 50 6A 01 07 10 E2 00 07 00 63 30 C3 20 04 00 01 00 4A 31 21 50 44 01 07 40 68 00 C3 30 06 00 ?? ?? 03 3C ?? ?? 04 3C 01 00 42 30 21 10 46 00 ?? ?? 67 8C ?? ?? 86 8C 83 28 05 00 ?? ?? 03 3C 01 00 08 31 21 40 05 01 43 21 0A 00 ?? ?? 65 8C 43 19 02 00 23 10 43 00 23 50 44 01 83 19 08 00 04 10 E2 00 04 50 CA 00 23 40 03 01 25 10 4A 00 04 40 A8 00 08 00 E0 03 25 10 48 00 }
	condition:
		$1
}

rule file_34_0_0 {
	meta:
		name = "_poly_zbuf_flat24"
		size = 108
		refs = "0024 .text"
	strings:
		$1 = { 30 00 C1 C4 10 00 C7 8C 16 00 A0 18 5C 00 C3 8C 03 00 02 24 18 00 A2 00 00 3A E9 7C 00 3C E8 7C 12 10 00 00 ?? ?? ?? 0? 21 10 44 00 40 08 00 46 00 00 60 C4 3C 00 01 46 00 00 00 00 06 00 02 45 03 00 84 24 00 00 87 A0 01 00 89 A0 02 00 88 A0 00 00 61 E4 03 00 84 24 04 00 63 24 F3 FF 82 14 34 00 C0 C4 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_34_1_0 {
	meta:
		name = "_poly_zbuf_grgb24"
		size = 224
		refs = "0054 .text 0044 _rgb_g_shift_24 0048 _rgb_r_shift_24 004c _rgb_b_shift_24"
	strings:
		$1 = { F0 FF BD 27 0C 00 B2 AF 08 00 B1 AF 04 00 B0 AF 18 00 CB 8C 1C 00 CA 8C 20 00 C9 8C 24 00 D9 8C 28 00 D8 8C 2C 00 CF 8C 30 00 C1 C4 27 00 A0 18 5C 00 C8 8C 03 00 02 24 18 00 A2 00 FD FF 83 24 21 38 80 00 ?? ?? 12 3C ?? ?? 11 3C ?? ?? 10 3C 12 10 00 00 ?? ?? ?? 0? 21 70 62 00 40 08 00 46 03 00 E7 24 00 00 00 C5 03 2C 0A 00 03 64 0B 00 3C 00 01 46 03 6C 09 00 21 58 79 01 21 50 58 01 0F 00 00 45 21 48 2F 01 ?? ?? 42 8E ?? ?? 23 8E ?? ?? 04 8E 04 10 45 00 04 18 6C 00 25 10 43 00 04 20 8D 00 25 10 44 00 03 2C 02 00 03 1A 02 00 01 00 E3 A0 02 00 E5 A0 00 00 E2 A0 00 00 01 E5 04 00 08 25 E5 FF EE 14 34 00 C0 C4 0C 00 B2 8F 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 10 00 BD 27 }
	condition:
		$1
}

rule file_34_2_0 {
	meta:
		name = "_poly_zbuf_atex24"
		size = 232
		refs = "0058 .text"
	strings:
		$1 = { 21 58 C0 00 54 00 C2 8C 50 00 C6 8C F8 FF BD 27 10 00 03 24 04 00 B0 AF 23 C0 62 00 04 30 46 00 4C 00 6F 8D 00 00 6A 8D 04 00 69 8D 08 00 6E 8D 0C 00 6D 8D 48 00 79 8D 30 00 61 C5 27 00 A0 18 5C 00 68 8D 03 00 10 24 18 00 B0 00 FD FF 82 24 21 38 80 00 12 18 00 00 ?? ?? ?? 0? 21 60 43 00 40 08 00 46 03 00 E7 24 00 00 00 C5 03 14 0A 00 07 18 09 03 3C 00 01 46 24 10 4F 00 24 18 66 00 21 10 43 00 21 50 4E 01 11 00 00 45 21 48 2D 01 18 00 50 00 12 10 00 00 21 10 22 03 01 00 43 90 02 00 44 90 00 00 45 90 00 1A 03 00 00 24 04 00 25 18 64 00 25 18 65 00 03 24 03 00 03 12 03 00 01 00 E2 A0 02 00 E4 A0 00 00 E3 A0 00 00 01 E5 04 00 08 25 E2 FF EC 14 34 00 60 C5 04 00 B0 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_34_3_0 {
	meta:
		name = "_poly_zbuf_atex_mask24"
		size = 260
		refs = "006c .text"
	strings:
		$1 = { 21 58 C0 00 54 00 C2 8C 50 00 C6 8C F8 FF BD 27 10 00 03 24 23 C0 62 00 04 30 46 00 04 00 B1 AF 00 00 B0 AF 21 18 80 00 4C 00 6F 8D 00 00 6A 8D 04 00 69 8D 08 00 6E 8D 0C 00 6D 8D 48 00 79 8D 30 00 61 C5 2B 00 A0 18 5C 00 62 8D 03 00 11 24 18 00 B1 00 21 38 60 00 21 40 40 00 FD FF 63 24 FF 00 02 3C FF 00 50 34 12 20 00 00 ?? ?? ?? 0? 21 60 64 00 40 08 00 46 03 00 E7 24 00 00 00 C5 03 14 0A 00 07 18 09 03 3C 00 01 46 24 10 4F 00 24 18 66 00 21 10 43 00 21 50 4E 01 12 00 00 45 21 48 2D 01 18 00 51 00 12 10 00 00 21 10 22 03 01 00 43 90 02 00 44 90 00 00 45 90 00 1A 03 00 00 24 04 00 25 18 64 00 25 10 65 00 03 24 02 00 05 00 50 10 03 1A 02 00 01 00 E3 A0 02 00 E4 A0 00 00 E2 A0 00 00 01 E5 04 00 08 25 E1 FF EC 14 34 00 60 C5 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_34_4_0 {
	meta:
		name = "_poly_zbuf_atex_lit24"
		size = 436
		refs = "0014 _blender_func24 00ac .text 0120 _blender_col_24"
	strings:
		$1 = { 54 00 C3 8C 10 00 02 24 B8 FF BD 27 23 10 43 00 10 00 A2 AF ?? ?? 02 3C ?? ?? 42 8C 20 00 B2 AF 21 90 C0 00 00 00 A2 AF 50 00 C6 8C 4C 00 42 8E 38 00 BE AF 04 30 66 00 0C 00 A2 AF 08 00 43 8E 48 00 42 8E 34 00 B7 AF 2C 00 B5 AF 28 00 B4 AF 24 00 B3 AF 44 00 B4 E7 14 00 A6 AF 3C 00 BF AF 30 00 B6 AF 1C 00 B1 AF 18 00 B0 AF 00 00 55 8E 04 00 54 8E 10 00 53 8E 08 00 A3 AF 0C 00 5E 8E 14 00 57 8E 04 00 A2 AF 30 00 54 C6 3C 00 A0 18 5C 00 46 8E 03 00 02 24 18 00 A2 00 FD FF 82 24 21 80 80 00 21 88 C0 00 12 18 00 00 ?? ?? ?? 0? 21 B0 43 00 21 A0 9E 02 21 98 77 02 21 A8 A4 02 04 00 31 26 2E 00 16 12 34 00 40 C6 00 A5 00 46 03 00 10 26 00 00 20 C6 3C 00 14 46 00 00 00 00 F4 FF 02 45 08 00 A4 8F 10 00 A4 8F 03 14 15 00 03 34 13 00 07 18 94 00 0C 00 A4 8F 21 A0 9E 02 21 98 77 02 24 10 44 00 14 00 A4 8F 24 18 64 00 21 10 43 00 03 00 03 24 18 00 43 00 04 00 A3 8F ?? ?? 04 3C ?? ?? 85 8C 12 10 00 00 21 10 62 00 01 00 44 90 02 00 43 90 00 00 47 90 00 22 04 00 00 1C 03 00 25 20 83 00 00 00 A3 8F 09 F8 60 00 25 20 87 00 03 24 02 00 03 1A 02 00 01 00 03 A2 02 00 04 A2 00 00 02 A2 08 00 A4 8F 00 00 34 E6 34 00 40 C6 21 A8 A4 02 D4 FF 16 16 04 00 31 26 3C 00 BF 8F 38 00 BE 8F 34 00 B7 8F 30 00 B6 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 44 00 B4 C7 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_34_5_0 {
	meta:
		name = "_poly_zbuf_atex_mask_lit24"
		size = 424
		refs = "0010 _blender_func24 00a0 .text 011c _blender_col_24"
	strings:
		$1 = { 54 00 C3 8C 10 00 02 24 B8 FF BD 27 23 50 43 00 ?? ?? 02 3C ?? ?? 42 8C 28 00 B4 AF 21 A0 C0 00 00 00 A2 AF 50 00 C6 8C 48 00 82 8E 38 00 BE AF 34 00 B7 AF 2C 00 B5 AF 24 00 B3 AF 20 00 B2 AF 44 00 B4 E7 04 00 A2 AF 3C 00 BF AF 30 00 B6 AF 1C 00 B1 AF 18 00 B0 AF 21 58 80 00 04 48 66 00 4C 00 88 8E 00 00 93 8E 04 00 92 8E 10 00 95 8E 08 00 87 8E 0C 00 9E 8E 14 00 97 8E 30 00 94 C6 3C 00 A0 18 5C 00 82 8E 03 00 03 24 18 00 A3 00 FD FF 63 25 21 80 60 01 21 88 40 00 12 20 00 00 ?? ?? ?? 0? 21 B0 64 00 00 A5 00 46 03 00 10 26 00 00 20 C6 03 14 13 00 07 18 52 01 3C 00 14 46 24 10 48 00 24 18 69 00 21 10 43 00 21 98 67 02 24 00 00 45 21 90 5E 02 03 00 04 24 18 00 44 00 04 00 A2 8F 03 34 15 00 12 18 00 00 21 18 43 00 01 00 62 90 02 00 64 90 00 00 65 90 00 12 02 00 00 24 04 00 25 10 44 00 FF 00 03 3C 25 10 45 00 FF 00 63 34 13 00 43 10 21 20 40 00 ?? ?? 02 3C 00 00 A3 8F ?? ?? 45 8C 08 00 A7 AF 0C 00 A8 AF 10 00 A9 AF 09 F8 60 00 14 00 AA AF 03 24 02 00 03 1A 02 00 01 00 03 A2 02 00 04 A2 00 00 02 A2 14 00 AA 8F 10 00 A9 8F 0C 00 A8 8F 08 00 A7 8F 00 00 34 E6 21 A8 B7 02 04 00 31 26 CE FF 16 16 34 00 80 C6 3C 00 BF 8F 38 00 BE 8F 34 00 B7 8F 30 00 B6 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 44 00 B4 C7 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_34_6_0 {
	meta:
		name = "_poly_zbuf_ptex24"
		size = 644
		refs = "0060 __extendsfdf2 0100 .text 0108 __adddf3 0164 __ltdf2 0180 __divdf3 018c __fixdfsi 021c __truncdfsf2"
	strings:
		$1 = { 90 FF BD 27 54 00 C3 8C 40 00 CC C4 38 00 B0 AF 21 80 C0 00 50 00 C6 8C 10 00 02 24 23 10 43 00 04 30 66 00 5C 00 BF AF 2C 00 A5 AF 28 00 A6 AF 40 00 B2 AF 3C 00 B1 AF 6C 00 B6 E7 21 88 80 00 68 00 B5 E7 64 00 B4 E7 58 00 BE AF 54 00 B7 AF 50 00 B6 AF 4C 00 B5 AF 48 00 B4 AF 44 00 B3 AF ?? ?? ?? 0? 24 00 A2 AF 18 00 A2 AF 44 00 0C C6 4C 00 02 8E 1C 00 A3 AF 38 00 15 C6 ?? ?? ?? 0? 20 00 A2 AF 34 00 0C C6 10 00 A2 AF ?? ?? ?? 0? 14 00 A3 AF 3C 00 14 C6 30 00 16 C6 0C 00 A3 AF 5C 00 12 8E 2C 00 A3 8F 48 00 10 8E 08 00 A2 AF 65 00 60 18 00 00 B0 AF 06 AB 00 46 ?? ?? ?? 0? 21 F0 40 02 06 A3 00 46 21 A0 40 00 ?? ?? ?? 0? 21 A8 60 00 06 B3 00 46 21 B0 40 00 ?? ?? ?? 0? 21 B8 60 00 21 98 60 00 2C 00 A3 8F 03 00 04 24 21 90 40 00 18 00 64 00 12 10 00 00 21 10 51 00 ?? ?? ?? 0? 30 00 A2 AF ?? ?? ?? 0? 00 00 00 00 10 00 A6 8F 14 00 A7 8F 21 20 C0 02 21 28 E0 02 21 A0 40 00 ?? ?? ?? 0? 21 A8 60 00 08 00 A6 8F 0C 00 A7 8F 21 20 40 02 21 28 60 02 21 B0 40 00 ?? ?? ?? 0? 21 B8 60 00 21 90 40 00 21 98 60 00 ?? ?? ?? 0? 00 00 CC C7 21 20 40 00 21 28 60 00 21 30 40 02 ?? ?? ?? 0? 21 38 60 02 21 30 40 02 21 38 60 02 21 20 80 02 2B 00 41 04 21 28 A0 02 ?? ?? ?? 0? 00 00 00 00 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 03 84 02 00 20 00 A2 8F 21 30 40 02 21 38 60 02 21 20 C0 02 21 28 E0 02 ?? ?? ?? 0? 24 80 02 02 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 24 00 A3 8F 28 00 A4 8F 21 28 60 02 07 10 62 00 24 10 44 00 21 80 02 02 03 00 02 24 18 00 02 02 00 00 A3 8F 21 20 40 02 12 80 00 00 21 80 70 00 01 00 02 92 02 00 03 92 00 00 07 92 00 12 02 00 00 1C 03 00 25 10 43 00 25 10 47 00 03 34 02 00 03 1A 02 00 01 00 23 A2 02 00 26 A2 ?? ?? ?? 0? 00 00 22 A2 00 00 C0 E7 30 00 A2 8F 03 00 31 26 21 20 80 02 21 28 A0 02 18 00 A6 8F 1C 00 A7 8F B1 FF 22 16 04 00 DE 27 5C 00 BF 8F 58 00 BE 8F 54 00 B7 8F 50 00 B6 8F 4C 00 B5 8F 48 00 B4 8F 44 00 B3 8F 40 00 B2 8F 3C 00 B1 8F 38 00 B0 8F 6C 00 B6 C7 68 00 B5 C7 64 00 B4 C7 08 00 E0 03 70 00 BD 27 }
	condition:
		$1
}

rule file_34_7_0 {
	meta:
		name = "_poly_zbuf_ptex_mask24"
		size = 656
		refs = "0060 __extendsfdf2 0100 .text 0108 __adddf3 0164 __ltdf2 0180 __divdf3 018c __fixdfsi 0228 __truncdfsf2"
	strings:
		$1 = { 90 FF BD 27 54 00 C3 8C 40 00 CC C4 38 00 B0 AF 21 80 C0 00 50 00 C6 8C 10 00 02 24 23 10 43 00 04 30 66 00 5C 00 BF AF 2C 00 A5 AF 28 00 A6 AF 40 00 B2 AF 3C 00 B1 AF 6C 00 B6 E7 21 88 80 00 68 00 B5 E7 64 00 B4 E7 58 00 BE AF 54 00 B7 AF 50 00 B6 AF 4C 00 B5 AF 48 00 B4 AF 44 00 B3 AF ?? ?? ?? 0? 24 00 A2 AF 18 00 A2 AF 44 00 0C C6 4C 00 02 8E 1C 00 A3 AF 38 00 15 C6 ?? ?? ?? 0? 20 00 A2 AF 34 00 0C C6 10 00 A2 AF ?? ?? ?? 0? 14 00 A3 AF 3C 00 14 C6 30 00 16 C6 0C 00 A3 AF 5C 00 12 8E 2C 00 A3 8F 48 00 10 8E 08 00 A2 AF 68 00 60 18 00 00 B0 AF 06 AB 00 46 ?? ?? ?? 0? 21 F0 40 02 06 A3 00 46 21 A0 40 00 ?? ?? ?? 0? 21 A8 60 00 06 B3 00 46 21 B0 40 00 ?? ?? ?? 0? 21 B8 60 00 21 90 40 00 2C 00 A2 8F 03 00 04 24 21 98 60 00 18 00 44 00 12 18 00 00 21 18 71 00 ?? ?? ?? 0? 30 00 A3 AF ?? ?? ?? 0? 00 00 00 00 10 00 A6 8F 14 00 A7 8F 21 20 C0 02 21 28 E0 02 21 A0 40 00 ?? ?? ?? 0? 21 A8 60 00 08 00 A6 8F 0C 00 A7 8F 21 20 40 02 21 28 60 02 21 B0 40 00 ?? ?? ?? 0? 21 B8 60 00 21 90 40 00 21 98 60 00 ?? ?? ?? 0? 00 00 CC C7 21 20 40 00 21 28 60 00 21 30 40 02 ?? ?? ?? 0? 21 38 60 02 21 30 40 02 21 38 60 02 21 20 80 02 2E 00 41 04 21 28 A0 02 ?? ?? ?? 0? 00 00 00 00 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 03 84 02 00 20 00 A2 8F 21 30 40 02 21 38 60 02 21 20 C0 02 21 28 E0 02 ?? ?? ?? 0? 24 80 02 02 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 24 00 A3 8F 28 00 A4 8F FF 00 07 3C 07 10 62 00 24 10 44 00 21 80 02 02 03 00 02 24 18 00 02 02 00 00 A3 8F FF 00 E7 34 21 20 40 02 21 28 60 02 12 80 00 00 21 80 70 00 01 00 02 92 02 00 03 92 00 00 06 92 00 12 02 00 00 1C 03 00 25 10 43 00 25 10 46 00 03 34 02 00 06 00 47 10 03 1A 02 00 01 00 23 A2 02 00 26 A2 ?? ?? ?? 0? 00 00 22 A2 00 00 C0 E7 30 00 A2 8F 03 00 31 26 21 20 80 02 21 28 A0 02 18 00 A6 8F 1C 00 A7 8F AE FF 22 16 04 00 DE 27 5C 00 BF 8F 58 00 BE 8F 54 00 B7 8F 50 00 B6 8F 4C 00 B5 8F 48 00 B4 8F 44 00 B3 8F 40 00 B2 8F 3C 00 B1 8F 38 00 B0 8F 6C 00 B6 C7 68 00 B5 C7 64 00 B4 C7 08 00 E0 03 70 00 BD 27 }
	condition:
		$1
}

rule file_34_8_0 {
	meta:
		name = "_poly_zbuf_ptex_lit24"
		size = 756
		refs = "0060 __extendsfdf2 00a4 _blender_func24 0120 .text 0150 __adddf3 01ac __ltdf2 01c8 __divdf3 01d4 __fixdfsi 022c _blender_col_24 0280 __truncdfsf2"
	strings:
		$1 = { 88 FF BD 27 54 00 C3 8C 40 00 CC C4 40 00 B0 AF 21 80 C0 00 50 00 C6 8C 10 00 02 24 23 10 43 00 04 30 66 00 64 00 BF AF 34 00 A5 AF 30 00 A6 AF 48 00 B2 AF 44 00 B1 AF 74 00 B6 E7 21 88 80 00 70 00 B5 E7 6C 00 B4 E7 60 00 BE AF 5C 00 B7 AF 58 00 B6 AF 54 00 B5 AF 50 00 B4 AF 4C 00 B3 AF ?? ?? ?? 0? 2C 00 A2 AF 18 00 A2 AF 44 00 0C C6 4C 00 02 8E 1C 00 A3 AF 10 00 03 8E 28 00 A2 AF ?? ?? ?? 0? 24 00 A3 AF 14 00 04 8E 34 00 0C C6 10 00 A2 AF 14 00 A3 AF ?? ?? ?? 0? 20 00 A4 AF 08 00 A2 AF ?? ?? 02 3C ?? ?? 42 8C 38 00 15 C6 5C 00 12 8E 04 00 A2 AF 3C 00 14 C6 30 00 16 C6 34 00 A2 8F 48 00 10 8E 0C 00 A3 AF 7A 00 40 18 00 00 B0 AF 06 AB 00 46 ?? ?? ?? 0? 21 F0 40 02 06 A3 00 46 21 A0 40 00 ?? ?? ?? 0? 21 A8 60 00 06 B3 00 46 21 B0 40 00 ?? ?? ?? 0? 21 B8 60 00 21 90 40 00 34 00 A2 8F 03 00 04 24 21 98 60 00 18 00 44 00 FD FF 22 26 12 18 00 00 21 18 43 00 ?? ?? ?? 0? 38 00 A3 AF 20 00 A3 8F 21 20 80 02 21 28 A0 02 21 10 43 00 24 00 A2 AF 38 00 A2 8F 18 00 A6 8F 1C 00 A7 8F 5B 00 22 12 04 00 DE 27 ?? ?? ?? 0? 03 00 31 26 10 00 A6 8F 14 00 A7 8F 21 20 C0 02 21 28 E0 02 21 A0 40 00 ?? ?? ?? 0? 21 A8 60 00 08 00 A6 8F 0C 00 A7 8F 21 20 40 02 21 28 60 02 21 B0 40 00 ?? ?? ?? 0? 21 B8 60 00 21 90 40 00 21 98 60 00 ?? ?? ?? 0? 00 00 CC C7 21 20 40 00 21 28 60 00 21 30 40 02 ?? ?? ?? 0? 21 38 60 02 DC FF 41 04 24 00 A2 8F 21 30 40 02 21 38 60 02 21 20 80 02 ?? ?? ?? 0? 21 28 A0 02 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 03 84 02 00 28 00 A2 8F 21 38 60 02 21 30 40 02 21 20 C0 02 21 28 E0 02 ?? ?? ?? 0? 24 80 02 02 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 2C 00 A3 8F 30 00 A4 8F 07 10 62 00 24 10 44 00 21 80 02 02 03 00 02 24 18 00 02 02 00 00 A2 8F 24 00 A4 8F ?? ?? 03 3C ?? ?? 65 8C 03 34 04 00 12 80 00 00 21 80 50 00 01 00 04 92 02 00 02 92 00 00 03 92 00 22 04 00 00 14 02 00 25 20 82 00 25 20 83 00 04 00 A3 8F 09 F8 60 00 00 00 00 00 03 24 02 00 03 1A 02 00 01 00 23 A2 02 00 24 A2 00 00 22 A2 21 20 40 02 ?? ?? ?? 0? 21 28 60 02 24 00 A2 8F 20 00 A3 8F 00 00 C0 E7 21 20 80 02 21 10 43 00 24 00 A2 AF 38 00 A2 8F 21 28 A0 02 18 00 A6 8F 1C 00 A7 8F A7 FF 22 16 04 00 DE 27 64 00 BF 8F 60 00 BE 8F 5C 00 B7 8F 58 00 B6 8F 54 00 B5 8F 50 00 B4 8F 4C 00 B3 8F 48 00 B2 8F 44 00 B1 8F 40 00 B0 8F 74 00 B6 C7 70 00 B5 C7 6C 00 B4 C7 08 00 E0 03 78 00 BD 27 }
	condition:
		$1
}

rule file_34_9_0 {
	meta:
		name = "_poly_zbuf_ptex_mask_lit24"
		size = 728
		refs = "0060 __extendsfdf2 00a8 _blender_func24 0120 .text 0128 __adddf3 0184 __ltdf2 01a0 __divdf3 01ac __fixdfsi 023c _blender_col_24 0264 __truncdfsf2"
	strings:
		$1 = { 88 FF BD 27 54 00 C3 8C 40 00 CC C4 40 00 B0 AF 21 80 C0 00 50 00 C6 8C 10 00 02 24 23 10 43 00 04 30 66 00 64 00 BF AF 34 00 A5 AF 30 00 A6 AF 48 00 B2 AF 44 00 B1 AF 74 00 B6 E7 21 88 80 00 70 00 B5 E7 6C 00 B4 E7 60 00 BE AF 5C 00 B7 AF 58 00 B6 AF 54 00 B5 AF 50 00 B4 AF 4C 00 B3 AF ?? ?? ?? 0? 2C 00 A2 AF 18 00 A2 AF 44 00 0C C6 4C 00 02 8E 1C 00 A3 AF 10 00 03 8E 28 00 A2 AF ?? ?? ?? 0? 24 00 A3 AF 10 00 A2 AF 34 00 0C C6 14 00 02 8E 14 00 A3 AF 38 00 15 C6 ?? ?? ?? 0? 20 00 A2 AF 08 00 A2 AF ?? ?? 02 3C 0C 00 A3 AF ?? ?? 42 8C 5C 00 12 8E 3C 00 14 C6 30 00 16 C6 34 00 A3 8F 48 00 10 8E 04 00 A2 AF 73 00 60 18 00 00 B0 AF 06 AB 00 46 ?? ?? ?? 0? 21 F0 40 02 06 A3 00 46 21 A0 40 00 ?? ?? ?? 0? 21 A8 60 00 06 B3 00 46 21 B0 40 00 ?? ?? ?? 0? 21 B8 60 00 21 90 40 00 34 00 A2 8F 21 98 60 00 03 00 03 24 18 00 43 00 FD FF 23 26 12 20 00 00 21 20 64 00 ?? ?? ?? 0? 38 00 A4 AF ?? ?? ?? 0? 03 00 31 26 10 00 A6 8F 14 00 A7 8F 21 20 C0 02 21 28 E0 02 21 A0 40 00 ?? ?? ?? 0? 21 A8 60 00 08 00 A6 8F 0C 00 A7 8F 21 20 40 02 21 28 60 02 21 B0 40 00 ?? ?? ?? 0? 21 B8 60 00 21 90 40 00 21 98 60 00 ?? ?? ?? 0? 00 00 CC C7 21 20 40 00 21 28 60 00 21 30 40 02 ?? ?? ?? 0? 21 38 60 02 21 30 40 02 21 38 60 02 21 20 80 02 35 00 41 04 21 28 A0 02 ?? ?? ?? 0? 00 00 00 00 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 03 84 02 00 28 00 A2 8F 21 30 40 02 21 38 60 02 21 20 C0 02 21 28 E0 02 ?? ?? ?? 0? 24 80 02 02 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 2C 00 A3 8F 07 10 62 00 30 00 A3 8F 24 10 43 00 21 80 02 02 03 00 02 24 18 00 02 02 00 00 A2 8F 24 00 A3 8F 03 34 03 00 12 80 00 00 21 80 50 00 01 00 02 92 02 00 03 92 00 00 04 92 00 12 02 00 00 1C 03 00 25 10 43 00 FF 00 03 3C 25 10 44 00 FF 00 63 34 0E 00 43 10 21 20 40 00 ?? ?? 02 3C 04 00 A3 8F 09 F8 60 00 ?? ?? 45 8C 03 24 02 00 03 1A 02 00 02 00 24 A2 01 00 23 A2 00 00 22 A2 21 20 40 02 ?? ?? ?? 0? 21 28 60 02 00 00 C0 E7 24 00 A2 8F 20 00 A3 8F 21 20 80 02 21 28 A0 02 21 10 43 00 24 00 A2 AF 38 00 A2 8F 18 00 A6 8F 1C 00 A7 8F A4 FF 22 16 04 00 DE 27 64 00 BF 8F 60 00 BE 8F 5C 00 B7 8F 58 00 B6 8F 54 00 B5 8F 50 00 B4 8F 4C 00 B3 8F 48 00 B2 8F 44 00 B1 8F 40 00 B0 8F 74 00 B6 C7 70 00 B5 C7 6C 00 B4 C7 08 00 E0 03 78 00 BD 27 }
	condition:
		$1
}

rule file_34_10_0 {
	meta:
		name = "_poly_zbuf_atex_trans24"
		size = 448
		refs = "0014 _blender_func24 00a8 .text 0128 _blender_alpha"
	strings:
		$1 = { 54 00 C3 8C 10 00 02 24 B8 FF BD 27 23 10 43 00 0C 00 A2 AF ?? ?? 02 3C ?? ?? 42 8C 24 00 B3 AF 21 98 C0 00 50 00 C6 8C 04 00 A2 AF 4C 00 62 8E 04 30 66 00 48 00 63 8E 38 00 BE AF 34 00 B7 AF 2C 00 B5 AF 28 00 B4 AF 44 00 B4 E7 10 00 A6 AF 3C 00 BF AF 30 00 B6 AF 20 00 B2 AF 1C 00 B1 AF 18 00 B0 AF 08 00 A2 AF 00 00 75 8E 04 00 74 8E 08 00 7E 8E 0C 00 77 8E 00 00 A3 AF 60 00 67 8E 30 00 74 C6 41 00 A0 18 5C 00 66 8E 03 00 02 24 18 00 A2 00 FD FF 82 24 21 80 80 00 21 90 E0 00 21 88 C0 00 12 18 00 00 ?? ?? ?? 0? 21 B0 43 00 21 A0 97 02 04 00 31 26 03 00 52 26 33 00 16 12 34 00 60 C6 00 A5 00 46 03 00 10 26 00 00 20 C6 3C 00 14 46 00 00 00 00 F5 FF 02 45 21 A8 BE 02 0C 00 A4 8F 08 00 A7 8F 03 1C 15 00 07 10 94 00 10 00 A4 8F 24 18 67 00 01 00 45 92 24 10 44 00 21 18 62 00 03 00 02 24 18 00 62 00 02 00 42 92 00 2A 05 00 00 00 44 92 00 14 02 00 25 28 A2 00 00 00 A2 8F 25 28 A4 00 ?? ?? 07 3C ?? ?? E6 8C 21 A8 BE 02 21 A0 97 02 03 00 52 26 12 18 00 00 21 18 43 00 01 00 64 90 02 00 62 90 00 00 67 90 00 22 04 00 00 14 02 00 04 00 A3 8F 25 20 82 00 09 F8 60 00 25 20 87 00 03 24 02 00 03 1A 02 00 01 00 03 A2 02 00 04 A2 00 00 02 A2 00 00 34 E6 34 00 60 C6 CF FF 16 16 04 00 31 26 3C 00 BF 8F 38 00 BE 8F 34 00 B7 8F 30 00 B6 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 44 00 B4 C7 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_34_11_0 {
	meta:
		name = "_poly_zbuf_atex_mask_trans24"
		size = 440
		refs = "0010 _blender_func24 00a0 .text 012c _blender_alpha"
	strings:
		$1 = { 54 00 C3 8C 10 00 02 24 B8 FF BD 27 23 48 43 00 ?? ?? 02 3C ?? ?? 42 8C 2C 00 B5 AF 21 A8 C0 00 04 00 A2 AF 50 00 C6 8C 48 00 A2 8E 38 00 BE AF 34 00 B7 AF 28 00 B4 AF 24 00 B3 AF 44 00 B4 E7 04 40 66 00 00 00 A2 AF 3C 00 BF AF 30 00 B6 AF 20 00 B2 AF 1C 00 B1 AF 18 00 B0 AF 21 50 80 00 4C 00 A7 8E 00 00 B4 8E 04 00 B3 8E 08 00 BE 8E 0C 00 B7 8E 60 00 A6 8E 30 00 B4 C6 41 00 A0 18 5C 00 A2 8E 03 00 03 24 18 00 A3 00 FD FF 43 25 21 80 40 01 21 90 C0 00 21 88 40 00 12 20 00 00 ?? ?? ?? 0? 21 B0 64 00 00 A5 00 46 03 00 10 26 00 00 20 C6 03 14 14 00 07 18 33 01 3C 00 14 46 24 10 47 00 24 18 68 00 21 10 43 00 21 A0 9E 02 28 00 00 45 21 98 77 02 03 00 04 24 18 00 44 00 00 00 AA 8F 12 18 00 00 21 18 43 01 01 00 62 90 02 00 64 90 00 00 65 90 00 12 02 00 00 24 04 00 25 10 44 00 FF 00 03 3C 25 10 45 00 FF 00 63 34 18 00 43 10 21 20 40 00 01 00 45 92 02 00 42 92 00 00 43 92 00 2A 05 00 00 14 02 00 ?? ?? 0A 3C 25 28 A2 00 25 28 A3 00 ?? ?? 46 8D 04 00 A3 8F 08 00 A7 AF 0C 00 A8 AF 09 F8 60 00 10 00 A9 AF 03 24 02 00 03 1A 02 00 01 00 03 A2 02 00 04 A2 00 00 02 A2 10 00 A9 8F 0C 00 A8 8F 08 00 A7 8F 00 00 34 E6 04 00 31 26 03 00 52 26 CA FF 16 16 34 00 A0 C6 3C 00 BF 8F 38 00 BE 8F 34 00 B7 8F 30 00 B6 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 44 00 B4 C7 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_34_12_0 {
	meta:
		name = "_poly_zbuf_ptex_trans24"
		size = 760
		refs = "0060 __extendsfdf2 0098 _blender_func24 0114 .text 0140 __adddf3 019c __ltdf2 01b8 __divdf3 01c4 __fixdfsi 0218 _blender_alpha 0288 __truncdfsf2"
	strings:
		$1 = { 88 FF BD 27 54 00 C3 8C 40 00 CC C4 40 00 B0 AF 21 80 C0 00 50 00 C6 8C 10 00 02 24 23 10 43 00 04 30 66 00 64 00 BF AF 34 00 A5 AF 30 00 A6 AF 60 00 BE AF 44 00 B1 AF 74 00 B6 E7 21 88 80 00 70 00 B5 E7 6C 00 B4 E7 5C 00 B7 AF 58 00 B6 AF 54 00 B5 AF 50 00 B4 AF 4C 00 B3 AF 48 00 B2 AF ?? ?? ?? 0? 2C 00 A2 AF 20 00 A2 AF 44 00 0C C6 4C 00 02 8E 24 00 A3 AF 38 00 15 C6 ?? ?? ?? 0? 28 00 A2 AF 34 00 0C C6 18 00 A2 AF ?? ?? ?? 0? 1C 00 A3 AF 10 00 A2 AF ?? ?? 02 3C 14 00 A3 AF ?? ?? 42 8C 48 00 03 8E 34 00 A4 8F 3C 00 14 C6 30 00 16 C6 5C 00 1E 8E 08 00 A2 AF 04 00 A3 AF 7E 00 80 18 60 00 10 8E ?? ?? ?? 0? 06 AB 00 46 06 A3 00 46 21 A0 40 00 ?? ?? ?? 0? 21 A8 60 00 06 B3 00 46 21 B0 40 00 21 B8 60 00 ?? ?? ?? 0? 00 00 B0 AF 21 90 40 00 34 00 A2 8F 03 00 04 24 21 98 60 00 18 00 44 00 FD FF 22 26 12 18 00 00 21 18 43 00 ?? ?? ?? 0? 38 00 A3 AF 38 00 A3 8F 21 20 80 02 03 00 42 24 21 28 A0 02 20 00 A6 8F 24 00 A7 8F 04 00 DE 27 60 00 23 12 00 00 A2 AF ?? ?? ?? 0? 03 00 31 26 18 00 A6 8F 1C 00 A7 8F 21 20 C0 02 21 28 E0 02 21 A0 40 00 ?? ?? ?? 0? 21 A8 60 00 10 00 A6 8F 14 00 A7 8F 21 20 40 02 21 28 60 02 21 B0 40 00 ?? ?? ?? 0? 21 B8 60 00 21 90 40 00 21 98 60 00 ?? ?? ?? 0? 00 00 CC C7 21 20 40 00 21 28 60 00 21 30 40 02 ?? ?? ?? 0? 21 38 60 02 DD FF 41 04 00 00 A2 8F 21 30 40 02 21 38 60 02 21 20 80 02 ?? ?? ?? 0? 21 28 A0 02 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 03 84 02 00 28 00 A2 8F 21 38 60 02 21 30 40 02 21 20 C0 02 21 28 E0 02 ?? ?? ?? 0? 24 80 02 02 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 2C 00 A3 8F 30 00 A4 8F 07 10 62 00 24 10 44 00 21 80 02 02 03 00 02 24 18 00 02 02 00 00 A3 8F ?? ?? 04 3C ?? ?? 86 8C 01 00 65 90 02 00 62 90 00 00 63 90 00 2A 05 00 00 14 02 00 25 28 A2 00 04 00 A2 8F 25 28 A3 00 12 80 00 00 21 80 50 00 01 00 04 92 02 00 02 92 00 00 03 92 00 22 04 00 00 14 02 00 25 20 82 00 25 20 83 00 08 00 A3 8F 09 F8 60 00 00 00 00 00 03 24 02 00 03 1A 02 00 01 00 23 A2 02 00 24 A2 00 00 22 A2 21 20 40 02 ?? ?? ?? 0? 21 28 60 02 00 00 A2 8F 38 00 A3 8F 00 00 C0 E7 03 00 42 24 21 20 80 02 21 28 A0 02 20 00 A6 8F 24 00 A7 8F 04 00 DE 27 A2 FF 23 16 00 00 A2 AF 64 00 BF 8F 60 00 BE 8F 5C 00 B7 8F 58 00 B6 8F 54 00 B5 8F 50 00 B4 8F 4C 00 B3 8F 48 00 B2 8F 44 00 B1 8F 40 00 B0 8F 74 00 B6 C7 70 00 B5 C7 6C 00 B4 C7 08 00 E0 03 78 00 BD 27 }
	condition:
		$1
}

rule file_34_13_0 {
	meta:
		name = "_poly_zbuf_ptex_mask_trans24"
		size = 736
		refs = "0060 __extendsfdf2 0098 _blender_func24 0114 .text 011c __adddf3 0178 __ltdf2 0194 __divdf3 01a0 __fixdfsi 0240 _blender_alpha 0270 __truncdfsf2"
	strings:
		$1 = { 88 FF BD 27 54 00 C3 8C 40 00 CC C4 40 00 B0 AF 21 80 C0 00 50 00 C6 8C 10 00 02 24 23 10 43 00 04 30 66 00 30 00 A6 AF 64 00 BF AF 34 00 A5 AF 60 00 BE AF 44 00 B1 AF 74 00 B6 E7 21 88 80 00 70 00 B5 E7 6C 00 B4 E7 5C 00 B7 AF 58 00 B6 AF 54 00 B5 AF 50 00 B4 AF 4C 00 B3 AF 48 00 B2 AF ?? ?? ?? 0? 2C 00 A2 AF 20 00 A2 AF 44 00 0C C6 4C 00 02 8E 24 00 A3 AF 38 00 15 C6 ?? ?? ?? 0? 28 00 A2 AF 34 00 0C C6 18 00 A2 AF ?? ?? ?? 0? 1C 00 A3 AF 10 00 A2 AF ?? ?? 02 3C 14 00 A3 AF ?? ?? 42 8C 48 00 03 8E 34 00 A6 8F 3C 00 14 C6 30 00 16 C6 5C 00 1E 8E 08 00 A2 AF 04 00 A3 AF 78 00 C0 18 60 00 10 8E ?? ?? ?? 0? 06 AB 00 46 06 A3 00 46 21 A0 40 00 ?? ?? ?? 0? 21 A8 60 00 06 B3 00 46 21 B0 40 00 21 B8 60 00 ?? ?? ?? 0? 00 00 B0 AF 21 90 40 00 34 00 A2 8F 21 98 60 00 03 00 03 24 18 00 43 00 FD FF 23 26 12 20 00 00 21 20 64 00 ?? ?? ?? 0? 38 00 A4 AF ?? ?? ?? 0? 03 00 31 26 18 00 A6 8F 1C 00 A7 8F 21 20 C0 02 21 28 E0 02 21 A0 40 00 ?? ?? ?? 0? 21 A8 60 00 10 00 A6 8F 14 00 A7 8F 21 20 40 02 21 28 60 02 21 B0 40 00 ?? ?? ?? 0? 21 B8 60 00 21 90 40 00 21 98 60 00 ?? ?? ?? 0? 00 00 CC C7 21 20 40 00 21 28 60 00 21 30 40 02 ?? ?? ?? 0? 21 38 60 02 21 30 40 02 21 38 60 02 21 20 80 02 3B 00 41 04 21 28 A0 02 ?? ?? ?? 0? 00 00 00 00 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 03 84 02 00 28 00 A2 8F 21 30 40 02 21 38 60 02 21 20 C0 02 21 28 E0 02 ?? ?? ?? 0? 24 80 02 02 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 2C 00 A3 8F 30 00 A6 8F 07 10 62 00 24 10 46 00 21 80 02 02 03 00 02 24 18 00 02 02 04 00 A3 8F FF 00 06 3C FF 00 C6 34 12 80 00 00 21 80 70 00 01 00 02 92 02 00 03 92 00 00 04 92 00 12 02 00 00 1C 03 00 25 10 43 00 25 10 44 00 16 00 46 10 21 20 40 00 00 00 A7 8F 01 00 E5 90 02 00 E2 90 00 00 E3 90 00 2A 05 00 00 14 02 00 ?? ?? 07 3C 25 28 A2 00 25 28 A3 00 08 00 A3 8F 09 F8 60 00 ?? ?? E6 8C 03 24 02 00 03 1A 02 00 02 00 24 A2 01 00 23 A2 00 00 22 A2 21 20 40 02 ?? ?? ?? 0? 21 28 60 02 00 00 C0 E7 00 00 A2 8F 38 00 A3 8F 21 20 80 02 03 00 42 24 21 28 A0 02 20 00 A6 8F 24 00 A7 8F 04 00 DE 27 9F FF 23 16 00 00 A2 AF 64 00 BF 8F 60 00 BE 8F 5C 00 B7 8F 58 00 B6 8F 54 00 B5 8F 50 00 B4 8F 4C 00 B3 8F 48 00 B2 8F 44 00 B1 8F 40 00 B0 8F 74 00 B6 C7 70 00 B5 C7 6C 00 B4 C7 08 00 E0 03 78 00 BD 27 }
	condition:
		$1
}

rule file_35_0_0 {
	meta:
		name = "masked_blit"
		size = 272
		refs = "00e4 .text"
	strings:
		$1 = { 00 00 83 8C 2A 10 C3 00 33 00 40 10 00 00 00 00 04 00 8C 8C 2A 10 EC 00 2F 00 40 10 00 00 00 00 10 00 AD 8C 2A 10 0D 01 2B 00 40 10 00 00 00 00 18 00 AE 8C 2A 10 2E 01 27 00 40 10 00 00 00 00 2A 00 C2 04 23 40 06 01 2E 00 E2 04 23 48 27 01 21 10 46 01 2A 10 62 00 01 00 40 54 23 50 66 00 21 10 67 01 2A 10 82 01 01 00 40 54 23 58 87 01 0C 00 AC 8C 2A 10 0C 01 19 00 40 14 23 10 0C 01 21 60 00 01 14 00 A3 8C 2A 10 23 01 1A 00 40 14 23 10 23 01 21 18 20 01 21 10 4C 01 2A 10 A2 01 01 00 40 54 23 50 AC 01 21 10 63 01 2A 10 C2 01 01 00 40 54 23 58 C3 01 07 00 40 19 00 00 00 00 05 00 60 19 21 40 80 01 1C 00 A2 8C 9C 00 59 8C 08 00 20 03 21 48 60 00 08 00 E0 03 00 00 00 00 23 30 C2 00 ?? ?? ?? 0? 21 50 42 01 21 50 46 01 ?? ?? ?? 0? 21 30 00 00 23 38 E2 00 ?? ?? ?? 0? 21 58 62 01 21 58 67 01 ?? ?? ?? 0? 21 38 00 00 }
	condition:
		$1
}

rule file_35_1_0 {
	meta:
		name = "blit"
		size = 912
		refs = "026c .text 02ec create_bitmap 0380 destroy_bitmap"
	strings:
		$1 = { 00 00 83 8C D8 FF BD 27 14 00 B5 AF 2A 10 C3 00 10 00 B4 AF 0C 00 B3 AF 08 00 B2 AF 04 00 B1 AF 00 00 B0 AF 24 00 BF AF 20 00 BE AF 1C 00 B7 AF 18 00 B6 AF 21 80 80 00 21 88 C0 00 21 98 A0 00 21 90 E0 00 21 A0 40 01 7B 00 40 10 21 A8 60 01 04 00 84 8C 2A 10 E4 00 78 00 40 50 24 00 BF 8F 10 00 A5 8C 2A 10 05 01 74 00 40 50 24 00 BF 8F 18 00 66 8E 2A 10 26 01 70 00 40 50 24 00 BF 8F 7C 00 22 06 23 40 11 01 89 00 42 06 23 48 32 01 21 10 91 02 2A 10 62 00 01 00 40 54 23 A0 71 00 21 10 B2 02 2A 10 82 00 01 00 40 54 23 A8 92 00 0C 00 76 8E 2A 10 16 01 6B 00 40 14 23 10 16 01 21 B0 00 01 14 00 77 8E 2A 10 37 01 75 00 40 14 23 10 37 01 21 B8 20 01 21 10 96 02 2A 10 A2 00 01 00 40 54 23 A0 B6 00 21 10 B7 02 2A 10 C2 00 01 00 40 54 23 A8 D7 00 50 00 80 1A 24 00 BF 8F 4F 00 A0 1A 20 00 BE 8F 1C 00 05 8E 1C 00 67 8E 00 00 A3 8C 00 00 E2 8C 12 00 62 54 98 00 F9 8C 24 00 13 12 FF 01 02 3C 2C 00 04 8E FF FF 42 34 24 30 82 00 52 00 C0 14 2C 00 63 8E 65 00 60 04 00 40 06 3C 24 10 66 00 5C 00 40 10 00 00 00 00 8D 00 80 04 24 10 86 00 02 00 40 50 7C 00 F9 8C 8C 00 F9 8C 21 20 00 02 21 28 60 02 21 30 20 02 21 38 40 02 21 40 C0 02 21 48 E0 02 21 50 80 02 21 58 A0 02 24 00 BF 8F 20 00 BE 8F 1C 00 B7 8F 18 00 B6 8F 14 00 B5 8F 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 20 03 28 00 BD 27 2C 00 03 8E C0 06 62 7C 4B 00 40 14 21 20 80 02 34 00 02 8E 34 00 63 8E 38 00 05 8E 21 20 22 02 21 18 C3 02 21 10 84 02 2B 10 62 00 DF FF 40 10 38 00 66 8E 21 10 83 02 2B 10 82 00 DB FF 40 10 21 28 45 02 21 30 E6 02 21 10 A5 02 2B 10 C2 00 D6 FF 40 10 21 10 A6 02 2B 10 A2 00 D3 FF 40 10 2B 10 C5 00 D2 FF 40 54 90 00 F9 8C 1C 00 A6 10 2B 10 64 00 CE FF 83 54 94 00 F9 8C CC FF A6 54 94 00 F9 8C 24 00 BF 8F 20 00 BE 8F 1C 00 B7 8F 18 00 B6 8F 14 00 B5 8F 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 28 00 BD 27 23 88 22 02 ?? ?? ?? 0? 21 A0 82 02 21 A0 51 01 ?? ?? ?? 0? 21 88 00 00 24 10 62 00 AD FF C2 14 00 00 00 00 ?? ?? ?? 0? C0 06 62 7C E4 FF 40 10 00 00 00 00 ?? ?? ?? 0? 90 00 F9 8C 23 90 42 02 ?? ?? ?? 0? 21 A8 A2 02 21 A8 B2 02 ?? ?? ?? 0? 21 90 00 00 03 00 80 04 24 10 86 00 A7 FF 40 50 8C 00 F9 8C ?? ?? ?? 0? 80 00 B9 8C A2 FF 80 04 80 07 82 7C A1 FF 40 50 7C 00 F9 8C ?? ?? ?? 0? 84 00 F9 8C ?? ?? ?? 0? 21 28 A0 02 D0 FF 40 10 21 F0 40 00 1C 00 02 8E 21 20 00 02 21 30 20 02 80 00 43 8C 21 38 40 02 21 28 C0 03 21 50 80 02 21 58 A0 02 21 40 00 00 09 F8 60 00 21 48 00 00 1C 00 62 8E 21 20 C0 03 21 28 60 02 7C 00 43 8C 21 40 C0 02 21 48 E0 02 21 50 80 02 21 58 A0 02 21 30 00 00 09 F8 60 00 21 38 00 00 21 20 C0 03 24 00 BF 8F 20 00 BE 8F 1C 00 B7 8F 18 00 B6 8F 14 00 B5 8F 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F ?? ?? ?? 0? 28 00 BD 27 ?? ?? ?? 0? 88 00 B9 8C }
	condition:
		$1
}

rule file_35_2_0 {
	meta:
		name = "get_replacement_mask_color"
		size = 200
		refs = "003c makecol_depth 0074 rgb_map 00a0 _current_palette 00c0 bestfit_color"
	strings:
		$1 = { 1C 00 82 8C F0 FF BD 27 04 00 B1 AF 00 00 51 8C 08 00 03 24 08 00 B2 AF 0C 00 BF AF 00 00 B0 AF 14 00 23 12 21 90 80 00 21 80 00 00 01 00 10 26 21 20 20 02 FF 00 05 24 21 30 00 02 ?? ?? ?? 0? FF 00 07 24 21 20 40 00 1C 00 42 8E 04 00 43 8C F7 FF 83 10 01 00 10 26 0C 00 BF 8F 21 10 80 00 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 10 00 BD 27 ?? ?? 02 3C ?? ?? 42 8C 08 00 40 10 0C 00 BF 8F 3F 7C 44 90 08 00 B2 8F 21 10 80 00 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 10 00 BD 27 ?? ?? 04 3C 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F ?? ?? 84 24 3F 00 05 24 01 00 06 24 3F 00 07 24 ?? ?? ?? 0? 10 00 BD 27 }
	condition:
		$1
}

rule file_35_3_0 {
	meta:
		name = "dither_blit"
		size = 1376
		refs = "0438 _current_palette 0000 _drawing_mode 0060 _al_malloc 00f8 memset 015c .text 01e0 getr_depth 01f4 getg_depth 0208 getb_depth 0274 makecol8 027c _color_conv 02e4 _rgb_scale_6 0444 memcpy 04e8 _al_free"
	strings:
		$1 = { ?? ?? 03 3C ?? ?? 63 8C 50 FF BD 27 80 10 0A 00 98 00 B4 AF 21 A0 80 00 21 20 40 00 AC 00 BF AF 7C 00 AA AF 70 00 A6 AF 74 00 A7 AF 78 00 A8 AF 80 00 AB AF 64 00 A3 AF A4 00 B7 AF 88 00 B0 AF 21 B8 A0 00 21 80 20 01 A8 00 BE AF A0 00 B6 AF 9C 00 B5 AF 94 00 B3 AF 90 00 B2 AF 8C 00 B1 AF ?? ?? ?? 0? 58 00 A2 AF 58 00 A4 8F ?? ?? ?? 0? 00 00 A2 AF 58 00 A4 8F ?? ?? ?? 0? 0C 00 A2 AF 58 00 A4 8F ?? ?? ?? 0? 04 00 A2 AF 58 00 A4 8F ?? ?? ?? 0? 10 00 A2 AF 58 00 A4 8F 6C 00 A2 AF ?? ?? ?? 0? 08 00 A2 AF 00 00 A4 8F 68 00 A2 AF 14 00 A2 AF 23 01 80 10 4C 00 A4 AF 0C 00 A2 8F 20 01 40 10 48 00 A2 AF 04 00 A3 8F 1D 01 60 10 44 00 A3 AF 10 00 A4 8F 1A 01 80 10 40 00 A4 AF 6C 00 A2 8F 17 01 40 10 68 00 A3 8F 15 01 60 10 58 00 A6 8F 4C 00 A4 8F ?? ?? ?? 0? 21 28 00 00 48 00 A4 8F 58 00 A6 8F ?? ?? ?? 0? 21 28 00 00 58 00 A6 8F 44 00 A4 8F 21 28 00 00 ?? ?? ?? 0? 18 00 A0 AF 40 00 A4 8F 58 00 A6 8F ?? ?? ?? 0? 21 28 00 00 58 00 A6 8F 6C 00 A4 8F 21 28 00 00 ?? ?? ?? 0? 1C 00 A0 AF 68 00 A4 8F 58 00 A6 8F ?? ?? ?? 0? 21 28 00 00 21 20 E0 02 ?? ?? ?? 0? 20 00 A0 AF 5C 00 A2 AF 80 00 A2 8F ?? ?? 04 3C F6 00 40 18 ?? ?? 80 AC 7C 00 A3 8F 50 00 B0 AF 60 00 A0 AF FF FF 63 24 0C 00 B5 27 84 00 A3 AF 7C 00 A2 8F A9 00 40 18 60 00 A3 8F 74 00 A4 8F 78 00 B6 8F 21 98 00 00 21 18 64 00 54 00 A3 AF 21 90 00 00 18 00 BE 27 1C 00 82 8E 54 00 A6 8F 21 20 80 02 20 00 43 8C 70 00 A2 8F 09 F8 60 00 21 28 62 02 21 80 40 00 1C 00 82 8E 21 28 00 02 ?? ?? ?? 0? 00 00 44 8C 1C 00 83 8E 24 00 A2 AF 21 28 00 02 ?? ?? ?? 0? 00 00 64 8C 1C 00 83 8E 28 00 A2 AF 21 28 00 02 ?? ?? ?? 0? 00 00 64 8C 2C 00 A2 AF 30 00 A8 27 21 38 00 00 21 10 A7 03 00 00 43 8C 24 00 A2 27 21 20 C7 03 21 28 47 00 21 18 72 00 00 00 82 8C 00 00 A6 8C 00 00 64 8C 21 10 46 00 21 10 44 00 00 01 43 28 60 00 60 14 00 00 02 AD FF 00 03 24 00 00 03 AD 04 00 E7 24 0C 00 04 24 ED FF E4 14 04 00 08 25 30 00 A4 8F 34 00 A5 8F ?? ?? ?? 0? 38 00 A6 8F ?? ?? 03 3C 21 88 40 00 ?? ?? 62 8C 00 04 04 3C 24 10 44 00 53 00 40 50 1C 00 E2 8E 1C 00 82 8E 04 00 43 8C 5E 00 03 12 1C 00 E3 8E 04 00 62 8C 54 00 22 12 50 00 A6 8F 24 00 62 8C 21 20 E0 02 21 28 C0 02 09 F8 40 00 21 38 20 02 ?? ?? 03 3C ?? ?? 63 24 80 10 11 00 21 10 62 00 02 00 45 90 00 00 43 90 01 00 44 90 ?? ?? 02 3C ?? ?? 42 24 80 28 05 00 80 18 03 00 80 20 04 00 21 18 43 00 21 20 44 00 21 28 45 00 00 00 86 8C 00 00 62 8C 00 00 A3 8C 28 00 A6 AF 24 00 A2 AF 2C 00 A3 AF 04 00 49 26 21 38 00 00 30 00 A3 27 24 00 A4 27 21 10 67 00 21 18 87 00 00 00 45 8C 00 00 64 8C 21 10 A7 02 00 00 46 8C 23 40 A4 00 03 00 02 24 18 00 02 01 08 00 02 24 21 28 C7 03 21 20 D2 00 04 00 E7 24 21 30 C9 00 12 18 00 00 02 00 40 14 1A 00 62 00 CD 01 00 00 12 18 00 00 00 00 A3 AC 00 00 82 8C 21 10 43 00 84 00 A3 8F 07 00 63 12 00 00 82 AC 04 00 03 24 02 00 60 14 1A 00 03 01 CD 01 00 00 12 10 00 00 00 00 C2 AC 0C 00 04 24 DE FF E4 14 30 00 A3 27 7C 00 A3 8F 01 00 73 26 2A 10 63 02 1E 00 40 10 01 00 D6 26 ?? ?? ?? 0? 21 90 20 01 A2 FF 42 04 00 00 00 AD ?? ?? ?? 0? 04 00 E7 24 50 00 A6 8F 21 20 E0 02 24 00 43 8C 21 28 C0 02 09 F8 60 00 21 38 20 02 ?? ?? ?? 0? ?? ?? 03 3C 24 00 62 8C 5C 00 A7 8F 21 20 E0 02 09 F8 40 00 21 28 C0 02 ?? ?? ?? 0? ?? ?? 03 3C 50 00 A6 8F 21 20 E0 02 04 00 67 8C 24 00 62 8C 09 F8 40 00 21 28 C0 02 ?? ?? ?? 0? ?? ?? 03 3C 48 00 A5 8F 58 00 A6 8F ?? ?? ?? 0? 4C 00 A4 8F 48 00 A4 8F 58 00 A6 8F ?? ?? ?? 0? 21 28 00 00 44 00 A4 8F 40 00 A5 8F ?? ?? ?? 0? 58 00 A6 8F 40 00 A4 8F 58 00 A6 8F ?? ?? ?? 0? 21 28 00 00 6C 00 A4 8F 68 00 A5 8F ?? ?? ?? 0? 58 00 A6 8F 60 00 A2 8F 68 00 A4 8F 58 00 A6 8F 01 00 42 24 21 28 00 00 ?? ?? ?? 0? 60 00 A2 AF 80 00 A4 8F 60 00 A2 8F 2A 18 44 00 50 00 A4 8F 01 00 84 24 34 FF 60 14 50 00 A4 AF 64 00 A3 8F ?? ?? 02 3C ?? ?? 43 AC 21 80 00 00 0C 00 11 24 21 10 B0 03 00 00 43 8C 03 00 60 10 21 20 60 00 ?? ?? ?? 0? 00 00 00 00 21 10 B0 02 00 00 43 8C 04 00 10 26 03 00 60 10 21 20 60 00 ?? ?? ?? 0? 00 00 00 00 F3 FF 11 16 21 10 B0 03 AC 00 BF 8F A8 00 BE 8F A4 00 B7 8F A0 00 B6 8F 9C 00 B5 8F 98 00 B4 8F 94 00 B3 8F 90 00 B2 8F 8C 00 B1 8F 88 00 B0 8F 08 00 E0 03 B0 00 BD 27 ?? ?? ?? 0? 0C 00 B5 27 64 00 A3 8F ?? ?? 02 3C 0C 00 B5 27 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_35_4_0 {
	meta:
		name = "blit_from_24"
		size = 4104
		refs = "007c _color_conv 00ac _rgb_g_shift_24 00a8 _rgb_r_shift_24 00b0 _rgb_b_shift_24 00b8 _rgb_g_shift_32 00bc _rgb_r_shift_32 00b4 _rgb_b_shift_32 02fc makecol16_dither 0450 makecol15_dither 0480 .text 054c makecol8 05b0 _rgb_g_shift_15 05b4 _rgb_r_shift_15 05ac _rgb_b_shift_15 06d8 _rgb_g_shift_16 06dc _rgb_r_shift_16 06d4 _rgb_b_shift_16"
	strings:
		$1 = { 1C 00 A2 8C 60 FF BD 27 98 00 BE AF 00 00 43 8C 0F 00 02 24 88 00 B4 AF 78 00 B0 AF 9C 00 BF AF 94 00 B7 AF 90 00 B6 AF 8C 00 B5 AF 84 00 B3 AF 80 00 B2 AF 7C 00 B1 AF 54 00 A5 AF 50 00 A4 AF 21 80 C0 00 58 00 A7 AF 21 F0 00 01 5C 00 A9 AF 21 A0 40 01 CA 00 62 10 60 00 AB AF 10 00 62 28 65 00 40 14 08 00 02 24 10 00 02 24 6F 00 62 10 20 00 02 24 62 00 62 54 9C 00 BF 8F ?? ?? 03 3C ?? ?? 62 8C 80 06 42 7C D1 01 40 14 60 00 A3 8F 28 02 60 18 80 F0 08 00 03 00 02 24 18 00 C2 00 08 00 BE AF 21 88 00 00 ?? ?? 1E 3C ?? ?? 17 3C ?? ?? 16 3C ?? ?? 15 3C ?? ?? 13 3C ?? ?? 12 3C 12 18 00 00 4C 00 A3 AF 18 00 42 01 12 18 00 00 70 00 A3 AF 50 00 A4 8F 58 00 A6 8F 24 00 83 8C 09 F8 60 00 21 28 26 02 54 00 AC 8F 21 80 40 00 5C 00 A2 8F 20 00 83 8D 21 20 80 01 09 F8 60 00 21 28 51 00 22 00 80 1A 4C 00 A3 8F 08 00 A4 8F 70 00 A5 8F 21 48 03 02 21 50 44 00 21 58 25 01 01 00 22 91 02 00 25 91 00 00 26 91 ?? ?? E3 8E 00 2C 05 00 ?? ?? C4 8F 00 12 02 00 25 10 45 00 ?? ?? C7 8E 25 10 46 00 ?? ?? 65 8E ?? ?? 46 8E 07 18 62 00 07 20 82 00 ?? ?? A8 8E 07 10 E2 00 FF 00 63 30 FF 00 84 30 04 18 A3 00 04 20 C4 00 FF 00 42 30 25 18 64 00 04 10 02 01 25 18 62 00 03 00 29 25 00 00 43 AD E5 FF 2B 15 04 00 4A 25 60 00 A6 8F 01 00 31 26 2A 10 26 02 CE FF 40 14 50 00 A4 8F 50 00 AC 8F 1C 00 83 8D 08 00 62 8C 09 F8 40 00 50 00 A4 8F 54 00 A2 8F 9C 00 BF 8F 98 00 BE 8F 1C 00 43 8C 94 00 B7 8F 90 00 B6 8F 08 00 79 8C 8C 00 B5 8F 88 00 B4 8F 84 00 B3 8F 80 00 B2 8F 7C 00 B1 8F 78 00 B0 8F 21 20 40 00 08 00 20 03 A0 00 BD 27 A3 00 62 10 9C 00 BF 8F 98 00 BE 8F 94 00 B7 8F 90 00 B6 8F 8C 00 B5 8F 88 00 B4 8F 84 00 B3 8F 80 00 B2 8F 7C 00 B1 8F 78 00 B0 8F 08 00 E0 03 A0 00 BD 27 ?? ?? 02 3C ?? ?? 42 8C 40 06 43 7C 1C 01 60 10 80 06 42 7C 26 02 40 14 60 00 A3 8F CE 01 60 18 03 00 02 24 18 00 C2 00 40 F0 08 00 21 98 00 00 ?? ?? 17 3C ?? ?? 16 3C ?? ?? 15 3C 12 18 00 00 38 00 A3 AF 50 00 A4 8F 58 00 A6 8F 24 00 83 8C 09 F8 60 00 21 28 66 02 54 00 AC 8F 21 80 40 00 5C 00 A2 8F 20 00 83 8D 21 20 80 01 09 F8 60 00 21 28 62 02 1D 00 80 1A 38 00 A3 8F 21 90 5E 00 21 88 00 00 21 80 03 02 01 00 05 92 02 00 02 92 00 00 07 92 ?? ?? C3 8E 00 14 02 00 ?? ?? E4 8E ?? ?? A6 8E 00 2A 05 00 25 28 A2 00 25 28 A7 00 07 30 C5 00 07 20 85 00 07 28 65 00 21 38 20 02 FF 00 84 30 FF 00 A5 30 FF 00 C6 30 01 00 31 26 ?? ?? ?? 0? 21 40 60 02 2A 18 34 02 00 00 42 A6 03 00 10 26 E8 FF 60 14 02 00 52 26 60 00 A4 8F 01 00 73 26 2A 10 64 02 D3 FF 40 14 50 00 A4 8F 50 00 A5 8F 1C 00 A3 8C 08 00 62 8C 09 F8 40 00 50 00 A4 8F 54 00 A6 8F 9C 00 BF 8F 98 00 BE 8F 1C 00 C3 8C 94 00 B7 8F 90 00 B6 8F 08 00 79 8C 8C 00 B5 8F 88 00 B4 8F 84 00 B3 8F 80 00 B2 8F 7C 00 B1 8F 78 00 B0 8F 21 20 C0 00 08 00 20 03 A0 00 BD 27 ?? ?? 02 3C ?? ?? 42 8C 40 06 43 7C 7D 00 60 10 80 06 42 7C 6A 02 40 14 60 00 AC 8F 17 03 80 19 03 00 02 24 18 00 C2 00 40 F0 08 00 21 98 00 00 ?? ?? 17 3C ?? ?? 16 3C ?? ?? 15 3C 12 18 00 00 20 00 A3 AF 50 00 A4 8F 58 00 A6 8F 24 00 83 8C 09 F8 60 00 21 28 66 02 54 00 AC 8F 21 80 40 00 5C 00 A2 8F 20 00 83 8D 21 20 80 01 09 F8 60 00 21 28 53 00 1D 00 80 1A 20 00 A3 8F 21 90 5E 00 21 88 00 00 21 80 03 02 01 00 05 92 02 00 02 92 00 00 07 92 ?? ?? C3 8E 00 14 02 00 ?? ?? E4 8E ?? ?? A6 8E 00 2A 05 00 25 28 A2 00 25 28 A7 00 07 30 C5 00 07 20 85 00 07 28 65 00 21 38 20 02 FF 00 84 30 FF 00 A5 30 FF 00 C6 30 01 00 31 26 ?? ?? ?? 0? 21 40 60 02 2A 18 34 02 00 00 42 A6 03 00 10 26 E8 FF 60 14 02 00 52 26 60 00 A4 8F 01 00 73 26 2A 10 64 02 D3 FF 40 14 50 00 A4 8F ?? ?? ?? 0? 50 00 A5 8F ?? ?? 02 3C ?? ?? 42 8C 00 06 43 7C 2A 01 60 14 80 06 42 7C 45 01 40 14 60 00 A2 8F 37 01 40 18 03 00 02 24 18 00 C2 00 21 98 00 00 ?? ?? 17 3C ?? ?? 16 3C ?? ?? 15 3C 12 18 00 00 18 00 A3 AF 50 00 A4 8F 58 00 A6 8F 24 00 83 8C 09 F8 60 00 21 28 66 02 54 00 AC 8F 21 80 40 00 5C 00 A2 8F 20 00 83 8D 21 20 80 01 09 F8 60 00 21 28 53 00 1B 00 80 1A 18 00 A3 8F 21 90 5E 00 21 88 00 00 21 80 03 02 01 00 05 92 02 00 02 92 00 00 07 92 ?? ?? C3 8E 00 14 02 00 ?? ?? E4 8E ?? ?? A6 8E 00 2A 05 00 25 28 A2 00 25 28 A7 00 07 30 C5 00 07 20 85 00 07 28 65 00 FF 00 84 30 FF 00 A5 30 FF 00 C6 30 ?? ?? ?? 0? 01 00 31 26 2A 18 34 02 00 00 42 A2 03 00 10 26 EA FF 60 14 01 00 52 26 60 00 A4 8F 01 00 73 26 2A 10 64 02 D5 FF 40 14 50 00 A4 8F ?? ?? ?? 0? 50 00 A5 8F 41 02 40 14 60 00 AC 8F 05 01 80 19 40 F0 08 00 03 00 02 24 18 00 C2 00 10 00 BE AF 21 88 00 00 ?? ?? 16 3C ?? ?? 17 3C ?? ?? 15 3C ?? ?? 13 3C ?? ?? 12 3C 12 18 00 00 2C 00 A3 AF 18 00 42 01 12 F0 00 00 50 00 A2 8F 58 00 A6 8F 24 00 43 8C 21 20 40 00 09 F8 60 00 21 28 26 02 54 00 AC 8F 21 80 40 00 5C 00 A2 8F 20 00 83 8D 21 20 80 01 09 F8 60 00 21 28 51 00 22 00 80 1A 2C 00 A4 8F ?? ?? 03 3C 10 00 A5 8F ?? ?? 6B 8C 21 40 04 02 21 48 45 00 21 50 1E 01 01 00 02 91 02 00 05 91 00 00 06 91 00 12 02 00 00 2C 05 00 ?? ?? E3 8E ?? ?? C4 8E 25 10 45 00 25 10 46 00 ?? ?? 65 8E ?? ?? 46 8E 07 18 62 00 07 20 82 00 ?? ?? A7 8E C0 20 63 7C C0 20 84 7C 07 10 62 01 04 18 A3 00 04 20 C4 00 C0 20 42 7C 25 18 64 00 04 10 E2 00 25 18 62 00 03 00 08 25 00 00 23 A5 E6 FF 0A 15 02 00 29 25 60 00 A6 8F 01 00 31 26 2A 10 26 02 CD FF 40 54 50 00 A2 8F 50 00 AC 8F 1C 00 84 8D ?? ?? ?? 0? 08 00 82 8C 52 01 40 14 60 00 AC 8F BB 00 80 19 40 F0 08 00 03 00 02 24 18 00 C2 00 00 00 BE AF 21 88 00 00 ?? ?? 16 3C ?? ?? 17 3C ?? ?? 15 3C ?? ?? 13 3C ?? ?? 12 3C 12 18 00 00 40 00 A3 AF 18 00 42 01 12 F0 00 00 50 00 A2 8F 58 00 A6 8F 24 00 43 8C 21 20 40 00 09 F8 60 00 21 28 26 02 54 00 AC 8F 21 80 40 00 5C 00 A2 8F 20 00 83 8D 21 20 80 01 09 F8 60 00 21 28 51 00 22 00 80 1A 40 00 A4 8F ?? ?? 03 3C 00 00 A5 8F ?? ?? 6B 8C 21 40 04 02 21 48 45 00 21 50 1E 01 01 00 02 91 02 00 05 91 00 00 06 91 00 12 02 00 00 2C 05 00 ?? ?? E3 8E ?? ?? C4 8E 25 10 45 00 25 10 46 00 ?? ?? 65 8E ?? ?? 46 8E 07 18 62 00 07 20 82 00 ?? ?? A7 8E 80 28 63 7C C0 20 84 7C 07 10 62 01 04 18 A3 00 04 20 C4 00 C0 20 42 7C 25 18 64 00 04 10 E2 00 25 18 62 00 03 00 08 25 00 00 23 A5 E6 FF 0A 15 02 00 29 25 60 00 A6 8F 01 00 31 26 2A 10 26 02 CD FF 40 54 50 00 A2 8F 50 00 AC 8F ?? ?? ?? 0? 1C 00 84 8D ?? ?? ?? 0? 54 00 A4 8F 50 00 A5 8F 54 00 A6 8F 21 A8 40 00 1C 00 A3 8C 1C 00 C2 8C 60 00 AC 8F 04 00 73 8C 6D FE 80 19 04 00 52 8C 03 00 02 24 18 00 82 02 80 F0 1E 00 44 00 BE AF 21 88 00 00 ?? ?? 17 3C ?? ?? 1E 3C ?? ?? 16 3C 12 18 00 00 FD FF 63 24 6C 00 A3 AF 18 00 02 02 12 20 00 00 48 00 A4 AF 50 00 A5 8F 58 00 A6 8F 24 00 A3 8C 21 20 A0 00 09 F8 60 00 21 28 26 02 54 00 AC 8F 21 80 40 00 5C 00 A2 8F 20 00 83 8D 21 20 80 01 09 F8 60 00 21 28 51 00 2D 00 80 1A 48 00 A3 8F 44 00 A4 8F 6C 00 A5 8F 21 48 03 02 21 50 44 00 ?? ?? ?? 0? 21 58 A9 00 ?? ?? C2 8C ?? ?? E3 8E ?? ?? 0C 3C ?? ?? 84 8D ?? ?? C6 8F ?? ?? C7 8E ?? ?? 0C 3C ?? ?? 85 8D 07 10 48 00 07 18 68 00 07 20 88 00 FF 00 63 30 FF 00 42 30 04 10 E2 00 04 18 C3 00 FF 00 84 30 25 18 62 00 04 20 A4 00 25 18 64 00 26 10 43 02 0A 18 A2 02 00 00 43 AD 0F 00 2B 11 04 00 4A 25 03 00 29 25 01 00 22 91 02 00 23 91 00 00 24 91 00 12 02 00 00 1C 03 00 25 10 43 00 25 40 44 00 DF FF 68 16 ?? ?? 06 3C 21 18 40 02 00 00 43 AD F3 FF 2B 15 04 00 4A 25 60 00 A3 8F 01 00 31 26 2A 10 23 02 C2 FF 40 14 50 00 A5 8F 50 00 A4 8F ?? ?? ?? 0? 1C 00 83 8C 9C 00 BF 8F 98 00 BE 8F 94 00 B7 8F 90 00 B6 8F 8C 00 B5 8F 88 00 B4 8F 84 00 B3 8F 80 00 B2 8F 7C 00 B1 8F 78 00 B0 8F ?? ?? ?? 0? A0 00 BD 27 60 00 A3 8F 01 00 73 26 2A 10 63 02 6B 00 40 54 50 00 A4 8F 50 00 A4 8F ?? ?? ?? 0? 1C 00 83 8C 60 00 AC 8F 01 00 31 26 2A 10 2C 02 B0 00 40 14 50 00 A5 8F 50 00 A2 8F 1C 00 44 8C ?? ?? ?? 0? 08 00 82 8C ?? ?? ?? 0? 54 00 A4 8F 50 00 A5 8F 54 00 A6 8F 21 B8 40 00 1C 00 A3 8C 1C 00 C2 8C 60 00 AC 8F 04 00 76 8C 56 FE 80 19 04 00 55 8C 03 00 02 24 18 00 02 02 21 98 00 00 12 18 00 00 04 00 A3 AF 50 00 A4 8F 58 00 A6 8F 24 00 83 8C 09 F8 60 00 21 28 66 02 54 00 AC 8F 21 80 40 00 5C 00 A2 8F 20 00 83 8D 21 20 80 01 09 F8 60 00 21 28 53 00 26 00 80 1A 04 00 A3 8F 21 88 5E 00 21 90 34 02 ?? ?? ?? 0? 21 80 03 02 00 00 23 A2 01 00 31 26 1E 00 32 12 03 00 10 26 01 00 02 92 02 00 03 92 00 00 04 92 00 12 02 00 00 1C 03 00 25 10 43 00 25 10 44 00 F4 FF C2 12 21 18 A0 02 ?? ?? 05 3C ?? ?? 06 3C ?? ?? 0C 3C ?? ?? A4 8C ?? ?? C5 8C ?? ?? 86 8D 07 20 82 00 07 28 A2 00 07 30 C2 00 FF 00 84 30 FF 00 A5 30 ?? ?? ?? 0? FF 00 C6 30 21 18 40 00 26 10 55 00 0A 18 E2 02 00 00 23 A2 01 00 31 26 E4 FF 32 16 03 00 10 26 60 00 A3 8F 01 00 73 26 2A 10 63 02 CA FF 40 14 50 00 A4 8F ?? ?? ?? 0? 1C 00 83 8C ?? ?? ?? 0? 54 00 A4 8F 50 00 A5 8F 54 00 A6 8F 21 B8 40 00 1C 00 A3 8C 1C 00 C2 8C 60 00 AC 8F 04 00 76 8C 0C FE 80 19 04 00 55 8C 03 00 02 24 18 00 02 02 40 F0 1E 00 30 00 BE AF 21 98 00 00 ?? ?? 1E 3C 12 18 00 00 34 00 A3 AF 50 00 A4 8F 58 00 A6 8F 24 00 83 8C 09 F8 60 00 21 28 66 02 54 00 AC 8F 21 80 40 00 5C 00 A2 8F 20 00 83 8D 21 20 80 01 09 F8 60 00 21 28 53 00 85 FF 80 1A 34 00 A3 8F 30 00 A4 8F 21 88 00 00 21 80 03 02 ?? ?? ?? 0? 21 90 44 00 21 18 A0 02 01 00 31 26 2A 10 34 02 00 00 43 A6 03 00 10 26 79 FF 40 10 02 00 52 26 01 00 02 92 02 00 03 92 00 00 04 92 00 12 02 00 00 1C 03 00 25 10 43 00 25 10 44 00 21 38 20 02 F0 FF C2 12 21 40 60 02 ?? ?? 05 3C ?? ?? 0C 3C ?? ?? A4 8C ?? ?? 86 8D ?? ?? C5 8F 07 20 82 00 07 30 C2 00 07 28 A2 00 FF 00 84 30 FF 00 A5 30 ?? ?? ?? 0? FF 00 C6 30 21 18 40 00 26 10 55 00 ?? ?? ?? 0? 0A 18 E2 02 ?? ?? ?? 0? 54 00 A4 8F 50 00 A3 8F 54 00 A5 8F 21 A8 40 00 1C 00 64 8C 1C 00 A2 8C 60 00 A6 8F 04 00 93 8C A1 FE C0 18 04 00 52 8C 03 00 02 24 18 00 82 02 40 F0 1E 00 14 00 BE AF 21 88 00 00 ?? ?? 17 3C ?? ?? 1E 3C ?? ?? 16 3C 12 18 00 00 FD FF 63 24 68 00 A3 AF 18 00 02 02 12 20 00 00 3C 00 A4 AF 50 00 A5 8F 58 00 A6 8F 24 00 A3 8C 21 20 A0 00 09 F8 60 00 21 28 26 02 54 00 AC 8F 21 80 40 00 5C 00 A2 8F 20 00 83 8D 21 20 80 01 09 F8 60 00 21 28 51 00 3F FF 80 1A 3C 00 A4 8F 14 00 A5 8F 68 00 A6 8F ?? ?? 03 3C 21 38 04 02 ?? ?? 6B 8C 21 40 45 00 ?? ?? ?? 0? 21 50 C7 00 ?? ?? 0C 3C ?? ?? C2 8F ?? ?? 83 8D ?? ?? 06 3C ?? ?? C5 8C ?? ?? C6 8E 07 18 64 00 07 10 44 00 ?? ?? E4 8E 80 28 42 7C C0 20 63 7C 04 18 C3 00 04 10 A2 00 25 10 43 00 04 20 89 00 25 10 44 00 26 18 42 02 0A 10 A3 02 00 00 02 A5 22 FF EA 10 02 00 08 25 03 00 E7 24 01 00 E2 90 02 00 E3 90 00 00 E4 90 00 12 02 00 00 1C 03 00 25 10 43 00 25 20 44 00 07 18 64 01 E1 FF 64 16 C0 20 69 7C ?? ?? ?? 0? 21 10 40 02 ?? ?? ?? 0? 54 00 A4 8F 50 00 A4 8F 54 00 A5 8F 21 B8 40 00 1C 00 83 8C 1C 00 A2 8C 60 00 A6 8F 04 00 76 8C 73 FD C0 18 04 00 55 8C 03 00 02 24 18 00 02 02 40 F0 1E 00 0C 00 BE AF 21 98 00 00 ?? ?? 1E 3C 12 18 00 00 1C 00 A3 AF 50 00 A4 8F 58 00 A6 8F 24 00 83 8C 09 F8 60 00 21 28 66 02 54 00 AC 8F 21 80 40 00 5C 00 A2 8F 20 00 83 8D 21 20 80 01 09 F8 60 00 21 28 53 00 2C 00 80 1A 1C 00 A3 8F 0C 00 A4 8F 21 88 00 00 21 80 03 02 ?? ?? ?? 0? 21 90 44 00 01 00 31 26 21 18 A0 02 2A 10 34 02 00 00 43 A6 03 00 10 26 20 00 40 10 02 00 52 26 01 00 02 92 02 00 03 92 00 00 04 92 00 12 02 00 00 1C 03 00 25 10 43 00 25 10 44 00 21 38 20 02 F0 FF C2 12 21 40 60 02 ?? ?? 05 3C ?? ?? 0C 3C ?? ?? A4 8C ?? ?? 86 8D ?? ?? C5 8F 07 20 82 00 07 30 C2 00 07 28 A2 00 FF 00 84 30 FF 00 A5 30 ?? ?? ?? 0? FF 00 C6 30 21 18 40 00 01 00 31 26 26 10 55 00 0A 18 E2 02 2A 10 34 02 00 00 43 A6 03 00 10 26 E2 FF 40 14 02 00 52 26 60 00 A3 8F 01 00 73 26 2A 10 63 02 C4 FF 40 14 50 00 A4 8F ?? ?? ?? 0? 1C 00 83 8C ?? ?? ?? 0? 54 00 A4 8F 50 00 A3 8F 54 00 A5 8F 21 A8 40 00 1C 00 64 8C 1C 00 A2 8C 60 00 A6 8F 04 00 93 8C FC FD C0 18 04 00 52 8C 03 00 02 24 18 00 82 02 40 F0 1E 00 24 00 BE AF 21 88 00 00 ?? ?? 17 3C ?? ?? 1E 3C ?? ?? 16 3C 12 18 00 00 FD FF 63 24 64 00 A3 AF 18 00 02 02 12 20 00 00 28 00 A4 AF 50 00 A5 8F 58 00 A6 8F 24 00 A3 8C 21 20 A0 00 09 F8 60 00 21 28 26 02 54 00 AC 8F 21 80 40 00 5C 00 A2 8F 20 00 83 8D 21 20 80 01 09 F8 60 00 21 28 51 00 2D 00 80 1A 24 00 A5 8F 28 00 A4 8F 64 00 A6 8F ?? ?? 03 3C 21 38 04 02 ?? ?? 6B 8C 21 40 45 00 ?? ?? ?? 0? 21 50 C7 00 ?? ?? 0C 3C ?? ?? C2 8F ?? ?? 83 8D ?? ?? 06 3C ?? ?? C5 8C ?? ?? C6 8E 07 18 64 00 07 10 44 00 ?? ?? E4 8E C0 20 42 7C C0 20 63 7C 04 18 C3 00 04 10 A2 00 25 10 43 00 04 20 89 00 25 10 44 00 26 18 42 02 0A 10 A3 02 00 00 02 A5 10 00 EA 10 02 00 08 25 03 00 E7 24 01 00 E2 90 02 00 E3 90 00 00 E4 90 00 12 02 00 00 1C 03 00 25 10 43 00 25 20 44 00 07 18 64 01 E1 FF 64 16 C0 20 69 7C 21 10 40 02 00 00 02 A5 F2 FF EA 14 02 00 08 25 60 00 AC 8F 01 00 31 26 2A 10 2C 02 C2 FF 40 14 50 00 A5 8F 50 00 A2 8F ?? ?? ?? 0? 1C 00 44 8C 50 00 A2 8F }
	condition:
		$1
}

rule file_35_5_0 {
	meta:
		name = "blit_from_32"
		size = 3828
		refs = "007c _color_conv 00ac _rgb_g_shift_32 00a8 _rgb_r_shift_32 00b0 _rgb_b_shift_32 00b8 _rgb_g_shift_24 00bc _rgb_r_shift_24 00b4 _rgb_b_shift_24 02d8 makecol16_dither 040c makecol15_dither 043c .text 04ec makecol8 0544 _rgb_g_shift_15 0548 _rgb_r_shift_15 0540 _rgb_b_shift_15 0680 _rgb_g_shift_16 0684 _rgb_r_shift_16 067c _rgb_b_shift_16"
	strings:
		$1 = { 1C 00 A2 8C 80 FF BD 27 78 00 BE AF 00 00 43 8C 0F 00 02 24 68 00 B4 AF 58 00 B0 AF 7C 00 BF AF 74 00 B7 AF 70 00 B6 AF 6C 00 B5 AF 64 00 B3 AF 60 00 B2 AF 5C 00 B1 AF 40 00 A5 AF 3C 00 A4 AF 21 80 C0 00 44 00 A7 AF 21 F0 00 01 48 00 A9 AF 21 A0 40 01 C0 00 62 10 4C 00 AB AF 10 00 62 28 63 00 40 14 08 00 02 24 10 00 02 24 6D 00 62 10 18 00 02 24 60 00 62 54 7C 00 BF 8F ?? ?? 03 3C ?? ?? 62 8C 80 06 42 7C B1 01 40 14 4C 00 A2 8F 8F 03 40 18 80 80 06 00 03 00 02 24 18 00 02 01 14 00 B0 AF 21 88 00 00 ?? ?? 1E 3C ?? ?? 17 3C ?? ?? 16 3C ?? ?? 15 3C ?? ?? 13 3C ?? ?? 12 3C 12 18 00 00 38 00 A3 AF 18 00 42 01 12 18 00 00 54 00 A3 AF 3C 00 A4 8F 44 00 AC 8F 24 00 83 8C 09 F8 60 00 21 28 2C 02 40 00 AD 8F 21 80 40 00 48 00 A2 8F 20 00 A3 8D 21 20 A0 01 09 F8 60 00 21 28 51 00 20 00 80 1A 38 00 A3 8F 14 00 A4 8F 54 00 A5 8F 21 48 43 00 21 50 04 02 21 58 25 01 00 00 44 8D ?? ?? E2 8E ?? ?? C3 8F ?? ?? C5 8E ?? ?? 66 8E ?? ?? 47 8E ?? ?? A8 8E 07 10 44 00 07 18 64 00 FF 00 42 30 07 20 A4 00 FF 00 63 30 04 18 E3 00 04 10 C2 00 FF 00 84 30 25 10 43 00 04 20 04 01 25 10 44 00 03 2C 02 00 03 1A 02 00 01 00 23 A1 02 00 25 A1 00 00 22 A1 03 00 29 25 E7 FF 2B 15 04 00 4A 25 4C 00 AC 8F 01 00 31 26 2A 10 2C 02 D0 FF 40 14 3C 00 A4 8F 3C 00 AD 8F 1C 00 A3 8D 08 00 62 8C 09 F8 40 00 3C 00 A4 8F 40 00 A2 8F 7C 00 BF 8F 78 00 BE 8F 1C 00 43 8C 74 00 B7 8F 70 00 B6 8F 08 00 79 8C 6C 00 B5 8F 68 00 B4 8F 64 00 B3 8F 60 00 B2 8F 5C 00 B1 8F 58 00 B0 8F 21 20 40 00 08 00 20 03 80 00 BD 27 94 00 62 10 7C 00 BF 8F 78 00 BE 8F 74 00 B7 8F 70 00 B6 8F 6C 00 B5 8F 68 00 B4 8F 64 00 B3 8F 60 00 B2 8F 5C 00 B1 8F 58 00 B0 8F 08 00 E0 03 80 00 BD 27 ?? ?? 02 3C ?? ?? 42 8C 40 06 43 7C 0B 01 60 10 80 06 42 7C F3 01 40 14 4C 00 A2 8F AF 01 40 18 80 80 06 00 10 00 B0 AF 40 F0 08 00 21 98 00 00 ?? ?? 17 3C ?? ?? 16 3C ?? ?? 15 3C 3C 00 A5 8F 44 00 AC 8F 24 00 A3 8C 21 20 A0 00 09 F8 60 00 21 28 6C 02 40 00 AD 8F 21 80 40 00 48 00 A2 8F 20 00 A3 8D 21 20 A0 01 09 F8 60 00 21 28 62 02 17 00 80 1A 10 00 A3 8F 21 88 5E 00 21 90 03 02 21 80 00 00 00 00 46 8E ?? ?? E4 8E ?? ?? C5 8E ?? ?? A2 8E 07 20 86 00 07 28 A6 00 07 30 46 00 21 38 00 02 FF 00 84 30 FF 00 A5 30 FF 00 C6 30 01 00 10 26 ?? ?? ?? 0? 21 40 60 02 2A 18 14 02 00 00 22 A6 04 00 52 26 EE FF 60 14 02 00 31 26 4C 00 A4 8F 01 00 73 26 2A 10 64 02 D8 FF 40 14 3C 00 A5 8F 1C 00 A3 8C 08 00 62 8C 09 F8 40 00 3C 00 A4 8F 40 00 AC 8F 7C 00 BF 8F 78 00 BE 8F 1C 00 83 8D 74 00 B7 8F 70 00 B6 8F 08 00 79 8C 6C 00 B5 8F 68 00 B4 8F 64 00 B3 8F 60 00 B2 8F 5C 00 B1 8F 58 00 B0 8F 21 20 80 01 08 00 20 03 80 00 BD 27 ?? ?? 02 3C ?? ?? 42 8C 40 06 43 7C 6F 00 60 10 80 06 42 7C 39 02 40 14 4C 00 AD 8F DC 02 A0 19 80 80 06 00 18 00 B0 AF 40 F0 08 00 21 98 00 00 ?? ?? 17 3C ?? ?? 16 3C ?? ?? 15 3C 3C 00 A5 8F 44 00 AC 8F 24 00 A3 8C 21 20 A0 00 09 F8 60 00 21 28 6C 02 40 00 AD 8F 21 80 40 00 48 00 A2 8F 20 00 A3 8D 21 20 A0 01 09 F8 60 00 21 28 53 00 17 00 80 1A 18 00 A3 8F 21 88 5E 00 21 90 03 02 21 80 00 00 00 00 46 8E ?? ?? E4 8E ?? ?? C5 8E ?? ?? A2 8E 07 20 86 00 07 28 A6 00 07 30 46 00 21 38 00 02 FF 00 84 30 FF 00 A5 30 FF 00 C6 30 01 00 10 26 ?? ?? ?? 0? 21 40 60 02 2A 18 14 02 00 00 22 A6 04 00 52 26 EE FF 60 14 02 00 31 26 4C 00 A4 8F 01 00 73 26 2A 10 64 02 D8 FF 40 14 3C 00 A5 8F ?? ?? ?? 0? 1C 00 A3 8C ?? ?? 02 3C ?? ?? 42 8C 00 06 43 7C 1A 01 60 14 80 06 42 7C 2C 01 40 14 4C 00 A2 8F 27 01 40 18 80 80 06 00 24 00 B0 AF 21 98 00 00 ?? ?? 17 3C ?? ?? 16 3C ?? ?? 15 3C 3C 00 A5 8F 44 00 AC 8F 24 00 A3 8C 21 20 A0 00 09 F8 60 00 21 28 6C 02 40 00 AD 8F 21 80 40 00 48 00 A2 8F 20 00 A3 8D 21 20 A0 01 09 F8 60 00 21 28 62 02 15 00 80 1A 24 00 A3 8F 21 88 5E 00 21 90 03 02 21 80 00 00 00 00 46 8E ?? ?? E4 8E ?? ?? C5 8E ?? ?? A2 8E 07 20 86 00 07 28 A6 00 07 30 46 00 FF 00 84 30 FF 00 A5 30 FF 00 C6 30 ?? ?? ?? 0? 01 00 10 26 2A 18 14 02 00 00 22 A2 04 00 52 26 F0 FF 60 14 01 00 31 26 4C 00 A4 8F 01 00 73 26 2A 10 64 02 DA FF 40 14 3C 00 A5 8F ?? ?? ?? 0? 1C 00 A3 8C 17 02 40 14 4C 00 AD 8F 6B 02 A0 19 80 B8 06 00 40 F0 08 00 21 80 00 00 ?? ?? 16 3C ?? ?? 15 3C ?? ?? 13 3C ?? ?? 12 3C 3C 00 A5 8F 44 00 AC 8F 24 00 A3 8C 21 20 A0 00 09 F8 60 00 21 28 0C 02 40 00 AD 8F 21 88 40 00 48 00 A2 8F 20 00 A3 8D 21 20 A0 01 09 F8 60 00 21 28 50 00 1D 00 80 1A ?? ?? 03 3C ?? ?? 04 3C ?? ?? 6C 8C ?? ?? 8B 8C 21 50 37 02 21 48 5E 00 21 40 00 00 00 00 44 8D ?? ?? C3 8E ?? ?? 65 8E ?? ?? 46 8E 07 18 64 00 07 10 84 01 ?? ?? A7 8E C0 20 42 7C C0 20 63 7C 07 20 64 01 04 18 C3 00 04 10 A2 00 C0 20 84 7C 25 10 43 00 04 20 E4 00 01 00 08 25 25 10 44 00 2A 18 14 01 00 00 22 A5 04 00 4A 25 EB FF 60 14 02 00 29 25 4C 00 A5 8F 01 00 10 26 2A 10 05 02 D2 FF 40 14 3C 00 A5 8F 3C 00 AC 8F 1C 00 83 8D 08 00 62 8C 09 F8 40 00 3C 00 A4 8F 40 00 AD 8F 7C 00 BF 8F 78 00 BE 8F 1C 00 A3 8D 74 00 B7 8F 70 00 B6 8F 08 00 79 8C 6C 00 B5 8F 68 00 B4 8F 64 00 B3 8F 60 00 B2 8F 5C 00 B1 8F 58 00 B0 8F 21 20 A0 01 08 00 20 03 80 00 BD 27 29 01 40 14 4C 00 AD 8F 1C 02 A0 19 80 B8 06 00 40 F0 08 00 21 80 00 00 ?? ?? 16 3C ?? ?? 15 3C ?? ?? 13 3C ?? ?? 12 3C 3C 00 A5 8F 44 00 AC 8F 24 00 A3 8C 21 20 A0 00 09 F8 60 00 21 28 0C 02 40 00 AD 8F 21 88 40 00 48 00 A2 8F 20 00 A3 8D 21 20 A0 01 09 F8 60 00 21 28 02 02 1D 00 80 1A ?? ?? 03 3C ?? ?? 04 3C ?? ?? 6C 8C ?? ?? 8B 8C 21 50 37 02 21 48 5E 00 21 40 00 00 00 00 44 8D ?? ?? C3 8E ?? ?? 65 8E ?? ?? 46 8E 07 18 64 00 07 10 84 01 ?? ?? A7 8E 80 28 42 7C C0 20 63 7C 07 20 64 01 04 18 C3 00 04 10 A2 00 C0 20 84 7C 25 10 43 00 04 20 E4 00 01 00 08 25 25 10 44 00 2A 18 14 01 00 00 22 A5 04 00 4A 25 EB FF 60 14 02 00 29 25 4C 00 A5 8F 01 00 10 26 2A 10 05 02 D2 FF 40 14 3C 00 A5 8F ?? ?? ?? 0? 3C 00 AC 8F ?? ?? ?? 0? 40 00 A4 8F 3C 00 A5 8F 40 00 AC 8F 21 A8 40 00 1C 00 A3 8C 1C 00 82 8D 4C 00 AD 8F 04 00 73 8C 8B FE A0 19 04 00 52 8C 03 00 02 24 18 00 82 02 80 80 10 00 34 00 B0 AF 21 88 00 00 ?? ?? 17 3C ?? ?? 16 3C 12 18 00 00 FD FF 63 24 50 00 A3 AF 18 00 C2 03 12 F0 00 00 3C 00 A2 8F 44 00 AC 8F 24 00 43 8C 21 20 40 00 09 F8 60 00 21 28 2C 02 40 00 AD 8F 21 80 40 00 48 00 A2 8F 20 00 A3 8D 21 20 A0 01 09 F8 60 00 21 28 51 00 2F 00 80 1A 34 00 A3 8F 50 00 A4 8F 21 48 5E 00 21 50 03 02 ?? ?? ?? 0? 21 58 89 00 ?? ?? 0C 3C ?? ?? A3 8C ?? ?? 82 8D ?? ?? 0D 3C ?? ?? A4 8D ?? ?? E6 8E ?? ?? C7 8E ?? ?? 0C 3C ?? ?? 85 8D 07 10 48 00 07 18 68 00 07 20 88 00 FF 00 63 30 FF 00 42 30 04 10 E2 00 04 18 C3 00 FF 00 84 30 25 18 62 00 04 20 A4 00 25 20 64 00 26 10 44 02 0A 20 A2 02 03 1C 04 00 03 12 04 00 04 00 4A 25 01 00 22 A1 02 00 23 A1 0D 00 2B 11 00 00 24 A1 03 00 29 25 00 00 48 8D E0 FF 13 15 ?? ?? 05 3C 21 20 40 02 03 1C 04 00 03 12 04 00 04 00 4A 25 01 00 22 A1 02 00 23 A1 F5 FF 2B 15 00 00 24 A1 4C 00 AD 8F 01 00 31 26 2A 10 2D 02 C0 FF 40 14 3C 00 A2 8F ?? ?? ?? 0? 1C 00 43 8C 7C 00 BF 8F 78 00 BE 8F 74 00 B7 8F 70 00 B6 8F 6C 00 B5 8F 68 00 B4 8F 64 00 B3 8F 60 00 B2 8F 5C 00 B1 8F 58 00 B0 8F ?? ?? ?? 0? 80 00 BD 27 4C 00 A3 8F 01 00 73 26 2A 10 63 02 55 00 40 14 3C 00 A2 8F 3C 00 A4 8F ?? ?? ?? 0? 1C 00 83 8C ?? ?? ?? 0? 40 00 A4 8F 3C 00 A5 8F 40 00 AC 8F 21 B8 40 00 1C 00 A3 8C 1C 00 82 8D 4C 00 AD 8F 04 00 76 8C 76 FE A0 19 04 00 53 8C 80 80 10 00 20 00 B0 AF 21 A8 00 00 3C 00 A2 8F 44 00 AC 8F 24 00 43 8C 21 20 40 00 09 F8 60 00 21 28 AC 02 40 00 AD 8F 21 88 40 00 48 00 A2 8F 20 00 A3 8D 21 20 A0 01 09 F8 60 00 21 28 55 00 1B 00 80 1A 20 00 A3 8F 21 80 5E 00 21 90 14 02 21 88 23 02 00 00 22 8E 11 00 56 10 21 18 60 02 ?? ?? 05 3C ?? ?? 0C 3C ?? ?? 0D 3C ?? ?? A4 8C ?? ?? A6 8D ?? ?? 85 8D 07 20 82 00 07 30 C2 00 07 28 A2 00 FF 00 84 30 FF 00 A5 30 ?? ?? ?? 0? FF 00 C6 30 21 18 40 00 26 10 53 00 0A 18 E2 02 00 00 03 A2 01 00 10 26 EA FF 12 16 04 00 31 26 4C 00 A3 8F 01 00 B5 26 2A 10 A3 02 D4 FF 40 14 3C 00 A2 8F 3C 00 A4 8F ?? ?? ?? 0? 1C 00 83 8C ?? ?? ?? 0? 40 00 A4 8F 3C 00 A5 8F 40 00 AC 8F 21 B8 40 00 1C 00 A3 8C 1C 00 82 8D 4C 00 AD 8F 04 00 76 8C 37 FE A0 19 04 00 55 8C 40 F0 1E 00 80 80 10 00 2C 00 BE AF 04 00 B0 AF 21 98 00 00 ?? ?? 1E 3C 3C 00 A2 8F 44 00 AC 8F 24 00 43 8C 21 20 40 00 09 F8 60 00 21 28 6C 02 40 00 AD 8F 21 80 40 00 48 00 A2 8F 20 00 A3 8D 21 20 A0 01 09 F8 60 00 21 28 62 02 9A FF 80 1A 04 00 A3 8F 2C 00 A4 8F 21 90 03 02 21 88 44 00 ?? ?? ?? 0? 21 80 00 00 21 18 A0 02 01 00 10 26 2A 10 14 02 00 00 23 A6 04 00 52 26 8E FF 40 10 02 00 31 26 00 00 42 8E 21 38 00 02 F6 FF 56 10 21 40 60 02 ?? ?? 0C 3C ?? ?? 0D 3C ?? ?? C4 8F ?? ?? 85 8D ?? ?? A6 8D 07 20 82 00 07 28 A2 00 07 30 C2 00 FF 00 84 30 FF 00 A5 30 ?? ?? ?? 0? FF 00 C6 30 21 18 40 00 26 10 55 00 ?? ?? ?? 0? 0A 18 E2 02 ?? ?? ?? 0? 40 00 A4 8F 3C 00 A4 8F 40 00 A5 8F 21 A8 40 00 1C 00 83 8C 1C 00 A2 8C 4C 00 AC 8F 04 00 73 8C B9 FE 80 19 04 00 52 8C 40 F0 1E 00 80 80 10 00 30 00 BE AF 00 00 B0 AF 21 88 00 00 ?? ?? 16 3C ?? ?? 17 3C ?? ?? 1E 3C 3C 00 AD 8F 44 00 A2 8F 24 00 A3 8D 21 20 A0 01 09 F8 60 00 21 28 22 02 40 00 A4 8F 48 00 AC 8F 21 80 40 00 20 00 83 8C 09 F8 60 00 21 28 2C 02 2B 00 80 1A 30 00 A5 8F 00 00 A4 8F ?? ?? 0D 3C ?? ?? 03 3C ?? ?? AC 8D ?? ?? 6B 8C 21 40 04 02 21 38 45 00 ?? ?? ?? 0? 21 30 00 00 ?? ?? E2 8E ?? ?? C3 8E ?? ?? C5 8F ?? ?? 0D 3C 07 10 44 00 ?? ?? A4 8D C0 20 42 7C 04 10 A2 00 04 18 6A 00 25 18 62 00 04 20 89 00 25 18 64 00 26 10 43 02 01 00 C6 24 0A 18 A2 02 2A 10 D4 00 00 00 E3 A4 04 00 08 25 0E 00 40 10 02 00 E7 24 00 00 04 8D 07 10 84 01 07 18 64 01 80 28 4A 7C E7 FF 93 14 C0 20 69 7C 01 00 C6 24 21 18 40 02 2A 10 D4 00 00 00 E3 A4 04 00 08 25 F4 FF 40 14 02 00 E7 24 4C 00 A3 8F 01 00 31 26 2A 10 23 02 C5 FF 40 14 3C 00 AD 8F 3C 00 A4 8F ?? ?? ?? 0? 1C 00 83 8C ?? ?? ?? 0? 40 00 A4 8F 3C 00 A4 8F 40 00 A5 8F 21 B8 40 00 1C 00 83 8C 1C 00 A2 8C 4C 00 AC 8F 04 00 76 8C A4 FD 80 19 04 00 55 8C 40 F0 1E 00 80 80 10 00 1C 00 BE AF 28 00 B0 AF 21 98 00 00 ?? ?? 1E 3C 3C 00 AD 8F 44 00 A2 8F 24 00 A3 8D 21 20 A0 01 09 F8 60 00 21 28 62 02 40 00 A4 8F 48 00 AC 8F 21 80 40 00 20 00 83 8C 09 F8 60 00 21 28 93 01 26 00 80 1A 28 00 AD 8F 1C 00 A3 8F 21 90 0D 02 21 88 43 00 ?? ?? ?? 0? 21 80 00 00 01 00 10 26 21 18 A0 02 2A 10 14 02 00 00 23 A6 04 00 52 26 1A 00 40 10 02 00 31 26 00 00 42 8E 21 38 00 02 F6 FF 56 10 21 40 60 02 ?? ?? 0C 3C ?? ?? 0D 3C ?? ?? C4 8F ?? ?? 85 8D ?? ?? A6 8D 07 20 82 00 07 28 A2 00 07 30 C2 00 FF 00 84 30 FF 00 A5 30 ?? ?? ?? 0? FF 00 C6 30 21 18 40 00 01 00 10 26 26 10 55 00 0A 18 E2 02 2A 10 14 02 00 00 23 A6 04 00 52 26 E8 FF 40 14 02 00 31 26 4C 00 A3 8F 01 00 73 26 2A 10 63 02 CA FF 40 14 3C 00 AD 8F 3C 00 A4 8F ?? ?? ?? 0? 1C 00 83 8C ?? ?? ?? 0? 40 00 A4 8F 3C 00 A4 8F 40 00 A5 8F 21 A8 40 00 1C 00 83 8C 1C 00 A2 8C 4C 00 AC 8F 04 00 73 8C 1A FE 80 19 04 00 52 8C 40 F0 1E 00 80 80 10 00 08 00 BE AF 0C 00 B0 AF 21 88 00 00 ?? ?? 16 3C ?? ?? 17 3C ?? ?? 1E 3C 3C 00 AD 8F 44 00 A2 8F 24 00 A3 8D 21 20 A0 01 09 F8 60 00 21 28 22 02 40 00 A4 8F 48 00 AC 8F 21 80 40 00 20 00 83 8C 09 F8 60 00 21 28 2C 02 2B 00 80 1A 08 00 A5 8F 0C 00 A4 8F ?? ?? 0D 3C ?? ?? 03 3C ?? ?? AC 8D ?? ?? 6B 8C 21 40 04 02 21 38 45 00 ?? ?? ?? 0? 21 30 00 00 ?? ?? E2 8E ?? ?? C3 8E ?? ?? C5 8F ?? ?? 0D 3C 07 10 44 00 ?? ?? A4 8D C0 20 42 7C 04 10 A2 00 04 18 6A 00 25 18 62 00 04 20 89 00 25 18 64 00 26 10 43 02 01 00 C6 24 0A 18 A2 02 2A 10 D4 00 00 00 E3 A4 04 00 08 25 0E 00 40 10 02 00 E7 24 00 00 04 8D 07 10 84 01 07 18 64 01 C0 20 4A 7C E7 FF 93 14 C0 20 69 7C 01 00 C6 24 21 18 40 02 2A 10 D4 00 00 00 E3 A4 04 00 08 25 F4 FF 40 14 02 00 E7 24 4C 00 A3 8F 01 00 31 26 2A 10 23 02 C5 FF 40 14 3C 00 AD 8F 3C 00 A4 8F ?? ?? ?? 0? 1C 00 83 8C 3C 00 A4 8F ?? ?? ?? 0? 1C 00 83 8C 3C 00 A2 8F ?? ?? ?? 0? 1C 00 43 8C 3C 00 A2 8F ?? ?? ?? 0? 1C 00 43 8C }
	condition:
		$1
}

rule file_35_6_0 {
	meta:
		name = "_blit_between_formats"
		size = 7336
		refs = "1034 _color_conv 0080 .rodata 0108 .text 01a0 _rgb_scale_5 01f0 _rgb_r_shift_16 01f4 _rgb_g_shift_16 01f8 _rgb_b_shift_16 0224 _rgb_scale_6 0254 makecol8 0368 _rgb_r_shift_15 036c _rgb_g_shift_15 0370 _rgb_b_shift_15 040c _al_malloc 041c _palette_expansion_table 05cc _al_free 06ec _rgb_r_shift_32 06e8 _rgb_g_shift_32 06e4 _rgb_b_shift_32 0ba4 _rgb_r_shift_24 0ba0 _rgb_g_shift_24 0b9c _rgb_b_shift_24"
	strings:
		$1 = { 2C 00 82 8C 00 10 03 3C 10 FF BD 27 24 10 43 00 E8 00 BE AF E4 00 B7 AF E0 00 B6 AF DC 00 B5 AF D4 00 B3 AF EC 00 BF AF D8 00 B4 AF D0 00 B2 AF CC 00 B1 AF C8 00 B0 AF 21 A8 80 00 21 B0 A0 00 21 B8 C0 00 98 00 A7 AF 21 F0 00 01 9C 00 A9 AF 21 98 40 01 0B 00 40 14 A0 00 AB AF 2C 00 A2 8C 24 10 43 00 08 00 40 14 EC 00 BF 8F 1C 00 85 8C 00 00 A2 8C F8 FF 42 24 19 00 43 2C 0D 00 60 14 ?? ?? 03 3C EC 00 BF 8F E8 00 BE 8F E4 00 B7 8F E0 00 B6 8F DC 00 B5 8F D8 00 B4 8F D4 00 B3 8F D0 00 B2 8F CC 00 B1 8F C8 00 B0 8F 08 00 E0 03 F0 00 BD 27 80 10 02 00 ?? ?? 63 24 21 18 62 00 00 00 64 8C 08 00 80 00 00 00 00 00 98 00 A7 8F 9C 00 A9 8F A0 00 AB 8F 21 20 A0 02 21 28 C0 02 EC 00 BF 8F E8 00 BE 8F E4 00 B7 8F E0 00 B6 8F DC 00 B5 8F D8 00 B4 8F D4 00 B3 8F D0 00 B2 8F CC 00 B1 8F C8 00 B0 8F ?? ?? ?? 0? F0 00 BD 27 98 00 A7 8F 9C 00 A9 8F A0 00 AB 8F 21 20 A0 02 21 28 C0 02 EC 00 BF 8F E8 00 BE 8F E4 00 B7 8F E0 00 B6 8F DC 00 B5 8F D8 00 B4 8F D4 00 B3 8F D0 00 B2 8F CC 00 B1 8F C8 00 B0 8F ?? ?? ?? 0? F0 00 BD 27 1C 00 C2 8E 0F 00 03 24 00 00 44 8C 36 03 83 10 10 00 82 28 A0 01 40 10 18 00 02 24 08 00 02 24 C4 FF 82 14 EC 00 BF 8F ?? ?? 02 3C ?? ?? 42 8C 00 06 43 7C F5 03 60 14 80 06 42 7C 2B 06 40 14 A0 00 A6 8F 3A 00 C0 18 40 B8 17 00 ?? ?? 02 3C 44 00 B7 AF 21 A0 00 00 ?? ?? 57 24 98 00 A6 8F 24 00 A3 8E 21 20 A0 02 09 F8 60 00 21 28 86 02 9C 00 AB 8F 20 00 C3 8E 21 20 C0 02 21 28 8B 02 09 F8 60 00 21 80 40 00 23 00 60 1A 44 00 AC 8F 21 88 5E 00 21 90 0C 02 21 80 00 00 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 0B 3C 00 00 42 96 ?? ?? 83 8C ?? ?? A6 8C ?? ?? 64 8D 07 18 62 00 07 30 C2 00 07 10 82 00 1F 00 63 30 3F 00 C6 30 1F 00 42 30 ?? ?? 0C 3C ?? ?? 8C 25 80 18 03 00 80 30 06 00 80 10 02 00 21 18 E3 02 21 30 86 01 21 10 E2 02 00 00 64 8C 00 00 C5 8C 00 00 46 8C 01 00 10 26 ?? ?? ?? 0? 02 00 52 26 2A 18 13 02 00 00 22 A2 E2 FF 60 14 01 00 31 26 A0 00 A3 8F 01 00 94 26 2A 10 83 02 CE FF 40 14 98 00 A6 8F 1C 00 A5 8E 08 00 A2 8C 09 F8 40 00 21 20 A0 02 1C 00 C3 8E 21 20 C0 02 EC 00 BF 8F 08 00 79 8C E8 00 BE 8F E4 00 B7 8F E0 00 B6 8F DC 00 B5 8F D8 00 B4 8F D4 00 B3 8F D0 00 B2 8F CC 00 B1 8F C8 00 B0 8F 08 00 20 03 F0 00 BD 27 1C 00 C2 8E 10 00 03 24 00 00 44 8C CB 01 83 10 11 00 82 28 EC 00 40 10 18 00 02 24 08 00 02 24 66 FF 82 14 EC 00 BF 8F ?? ?? 02 3C ?? ?? 42 8C 00 06 43 7C 97 03 60 14 80 06 42 7C 1B 06 40 14 A0 00 A6 8F DC FF C0 18 40 B8 17 00 ?? ?? 02 3C 1C 00 B7 AF ?? ?? 54 24 21 B8 00 00 98 00 A6 8F 24 00 A3 8E 21 20 A0 02 09 F8 60 00 21 28 E6 02 9C 00 AB 8F 20 00 C3 8E 21 20 C0 02 21 28 77 01 09 F8 60 00 21 80 40 00 21 00 60 1A 1C 00 AC 8F 21 88 5E 00 21 90 0C 02 21 80 00 00 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 0B 3C 00 00 42 96 ?? ?? 83 8C ?? ?? A6 8C ?? ?? 64 8D 07 18 62 00 07 30 C2 00 07 10 82 00 1F 00 63 30 1F 00 C6 30 1F 00 42 30 80 18 03 00 80 30 06 00 80 10 02 00 21 18 83 02 21 30 86 02 21 10 82 02 00 00 64 8C 00 00 C5 8C 00 00 46 8C 01 00 10 26 ?? ?? ?? 0? 02 00 52 26 2A 18 13 02 00 00 22 A2 E4 FF 60 14 01 00 31 26 A0 00 AC 8F 01 00 F7 26 2A 10 EC 02 D0 FF 40 14 98 00 A6 8F ?? ?? ?? 0? 1C 00 A5 8E ?? ?? 03 3C ?? ?? 62 8C 80 06 42 7C 73 00 40 50 1C 00 C2 8E ?? ?? ?? 0? 00 04 04 24 21 80 40 00 1C 00 C2 8E ?? ?? 03 3C ?? ?? 65 8C 09 F8 A0 00 00 00 44 8C 21 30 40 00 21 38 00 02 00 04 48 24 00 00 C2 8C 04 00 C3 8C 08 00 C4 8C 0C 00 C5 8C 10 00 C6 24 00 00 E2 AC 04 00 E3 AC 08 00 E4 AC 0C 00 E5 AC F6 FF C8 14 10 00 E7 24 ?? ?? ?? 0? 21 20 C0 02 1C 00 C6 8E 21 40 40 00 21 20 00 00 04 00 C2 8C 01 00 07 24 00 00 02 AE 0A 20 E4 00 80 10 04 00 21 28 02 02 00 00 A3 8C 04 00 C2 8C 01 00 62 50 00 00 A8 AC 01 00 84 24 00 01 82 28 F7 FF 40 14 0A 20 E4 00 00 00 C3 8C 18 00 02 24 26 01 62 10 21 20 C0 00 19 00 62 28 4A 00 40 10 20 00 02 24 F1 FF 62 24 02 00 42 2C 2F 00 40 50 ?? ?? 04 3C 2C 00 A2 8E 00 C0 03 3C 24 10 43 00 D3 02 40 10 A0 00 A5 8F A0 00 A4 8F 1E 00 80 18 40 A0 1E 00 21 88 00 00 98 00 A2 8F 24 00 A3 8E 21 20 A0 02 09 F8 60 00 21 28 22 02 9C 00 A6 8F 20 00 C3 8E 21 20 C0 02 21 28 26 02 09 F8 60 00 21 90 40 00 0B 00 60 1A 21 20 57 02 21 28 54 00 21 30 93 00 00 00 82 90 01 00 84 24 80 10 02 00 21 10 02 02 00 00 43 8C 00 00 A3 A4 F9 FF 86 14 02 00 A5 24 A0 00 AB 8F 01 00 31 26 2A 10 2B 02 E6 FF 40 14 98 00 A2 8F 1C 00 A3 8E 08 00 62 8C 09 F8 40 00 21 20 A0 02 1C 00 C3 8E 08 00 62 8C 09 F8 40 00 21 20 C0 02 ?? ?? 04 3C ?? ?? 82 8C 80 06 42 7C BA FE 40 10 EC 00 BF 8F 21 20 00 02 E8 00 BE 8F E4 00 B7 8F E0 00 B6 8F DC 00 B5 8F D8 00 B4 8F D4 00 B3 8F D0 00 B2 8F CC 00 B1 8F C8 00 B0 8F ?? ?? ?? 0? F0 00 BD 27 ?? ?? 03 3C ?? ?? 65 8C 09 F8 A0 00 00 00 44 8C 21 80 40 00 ?? ?? ?? 0? 1C 00 C6 8E E8 FF 62 54 ?? ?? 04 3C 2C 00 A2 8E 00 C0 03 3C 24 10 43 00 66 02 40 10 A0 00 A2 8F A0 00 AC 8F D7 FF 80 19 80 A0 1E 00 21 88 00 00 98 00 AC 8F 24 00 A3 8E 21 20 A0 02 09 F8 60 00 21 28 2C 02 21 90 40 00 9C 00 A2 8F 20 00 C3 8E 21 20 C0 02 09 F8 60 00 21 28 22 02 0B 00 60 1A 21 20 57 02 21 28 54 00 21 30 93 00 00 00 82 90 01 00 84 24 80 10 02 00 21 10 02 02 00 00 43 8C 00 00 A3 AC F9 FF 86 14 04 00 A5 24 A0 00 A3 8F 01 00 31 26 2A 10 23 02 E6 FF 40 14 98 00 AC 8F ?? ?? ?? 0? 1C 00 A3 8E 8F 01 82 10 20 00 02 24 7A FE 82 14 EC 00 BF 8F ?? ?? 03 3C ?? ?? 62 8C 80 06 42 7C 75 03 40 14 A0 00 AB 8F F2 FE 60 19 80 F0 08 00 40 B8 06 00 ?? ?? 02 3C 10 00 BE AF 14 00 B7 AF ?? ?? 50 24 21 90 00 00 ?? ?? 0D 3C ?? ?? 0E 3C ?? ?? 1E 3C ?? ?? 0C 3C ?? ?? 14 3C ?? ?? 17 3C 98 00 A6 8F 24 00 A3 8E B8 00 AC AF 21 28 46 02 BC 00 AD AF C0 00 AE AF 09 F8 60 00 21 20 A0 02 9C 00 AB 8F 20 00 C3 8E 21 20 C0 02 21 28 4B 02 09 F8 60 00 21 88 40 00 B8 00 AC 8F BC 00 AD 8F 27 00 60 1A C0 00 AE 8F 14 00 A3 8F 10 00 A4 8F 21 48 00 00 21 58 23 02 21 50 44 00 00 00 64 95 ?? ?? C2 8D ?? ?? A3 8D ?? ?? C5 8F 07 10 44 00 07 18 64 00 1F 00 42 30 07 20 A4 00 1F 00 63 30 80 10 02 00 80 18 03 00 1F 00 84 30 21 10 02 02 21 18 03 02 80 20 04 00 00 00 45 8C 00 00 66 8C ?? ?? E7 8E ?? ?? 83 8E 21 20 04 02 00 00 82 8C ?? ?? 88 8D 04 28 65 00 04 30 E6 00 25 28 A6 00 04 10 02 01 01 00 29 25 25 28 A2 00 2A 18 33 01 00 00 45 AD 02 00 6B 25 E0 FF 60 14 04 00 4A 25 A0 00 A5 8F 01 00 52 26 2A 10 45 02 C5 FF 40 14 98 00 A6 8F ?? ?? ?? 0? 1C 00 A5 8E DB 00 82 10 20 00 02 24 24 FE 82 14 EC 00 BF 8F ?? ?? 03 3C ?? ?? 62 8C 80 06 42 7C 35 04 40 14 A0 00 AB 8F 9C FE 60 19 80 F0 08 00 40 B8 06 00 ?? ?? 02 3C ?? ?? 03 3C 34 00 BE AF 04 00 B7 AF ?? ?? 52 24 ?? ?? 6F 24 21 88 00 00 ?? ?? 0D 3C ?? ?? 0E 3C ?? ?? 1E 3C ?? ?? 0C 3C ?? ?? 14 3C ?? ?? 17 3C 98 00 AB 8F 24 00 A3 8E B8 00 AC AF 21 28 2B 02 BC 00 AD AF C0 00 AE AF C4 00 AF AF 09 F8 60 00 21 20 A0 02 21 80 40 00 9C 00 A2 8F 20 00 C3 8E 21 20 C0 02 09 F8 60 00 21 28 22 02 B8 00 AC 8F BC 00 AD 8F C0 00 AE 8F 27 00 60 1A C4 00 AF 8F 04 00 A3 8F 34 00 A4 8F 21 48 00 00 21 58 03 02 21 50 44 00 00 00 64 95 ?? ?? C2 8D ?? ?? C3 8F ?? ?? A5 8D 07 10 44 00 07 18 64 00 3F 00 42 30 07 20 A4 00 1F 00 63 30 80 10 02 00 80 18 03 00 1F 00 84 30 21 10 E2 01 21 18 43 02 80 20 04 00 00 00 45 8C 00 00 66 8C ?? ?? E7 8E ?? ?? 83 8E 21 20 44 02 00 00 82 8C ?? ?? 88 8D 04 28 65 00 04 30 E6 00 25 28 A6 00 04 10 02 01 01 00 29 25 25 28 A2 00 2A 18 33 01 00 00 45 AD 02 00 6B 25 E0 FF 60 14 04 00 4A 25 A0 00 A5 8F 01 00 31 26 2A 10 25 02 C3 FF 40 14 98 00 AB 8F ?? ?? ?? 0? 1C 00 A5 8E 2C 00 A2 8E 00 C0 03 3C 24 10 43 00 D7 01 40 10 A0 00 A2 8F A0 00 AC 8F 00 FF 80 19 03 00 02 24 18 00 C2 03 21 88 00 00 12 A0 00 00 98 00 A2 8F 24 00 A3 8E 21 20 A0 02 09 F8 60 00 21 28 22 02 9C 00 A6 8F 20 00 C3 8E 21 20 C0 02 21 28 D1 00 09 F8 60 00 21 90 40 00 0F 00 60 1A 21 30 57 02 21 28 54 00 21 38 D3 00 00 00 C2 90 01 00 C6 24 80 10 02 00 21 10 02 02 00 00 43 8C 03 24 03 00 03 12 03 00 01 00 A2 A0 02 00 A4 A0 00 00 A3 A0 F5 FF C7 14 03 00 A5 24 A0 00 AB 8F 01 00 31 26 2A 10 2B 02 E2 FF 40 14 98 00 A2 8F ?? ?? ?? 0? 1C 00 A3 8E ?? ?? 03 3C ?? ?? 62 8C 80 06 42 7C E6 01 40 14 A0 00 A2 8F 19 FE 40 18 40 F0 08 00 40 B8 06 00 ?? ?? 02 3C 18 00 BE AF 68 00 B7 AF ?? ?? 50 24 21 90 00 00 ?? ?? 0B 3C ?? ?? 0C 3C ?? ?? 0D 3C ?? ?? 17 3C ?? ?? 1E 3C ?? ?? 14 3C 98 00 A6 8F 24 00 A3 8E B4 00 AB AF 21 28 46 02 B8 00 AC AF BC 00 AD AF 09 F8 60 00 21 20 A0 02 21 88 40 00 9C 00 A2 8F 20 00 C3 8E 21 20 C0 02 09 F8 60 00 21 28 52 00 B4 00 AB 8F B8 00 AC 8F 2A 00 60 1A BC 00 AD 8F 68 00 A3 8F 18 00 A4 8F 21 40 00 00 21 50 23 02 21 48 44 00 00 00 44 95 ?? ?? 82 8D ?? ?? 63 8D ?? ?? A5 8D 07 10 44 00 07 18 64 00 1F 00 42 30 07 20 A4 00 1F 00 63 30 80 10 02 00 80 18 03 00 1F 00 84 30 21 10 02 02 21 18 03 02 80 20 04 00 00 00 45 8C 00 00 66 8C 21 20 04 02 00 00 82 8C ?? ?? C3 8F ?? ?? 84 8E ?? ?? E7 8E 83 28 05 00 C3 30 06 00 04 28 65 00 04 30 86 00 C3 10 02 00 25 28 A6 00 04 10 E2 00 01 00 08 25 25 28 A2 00 2A 18 13 01 00 00 25 A5 02 00 4A 25 DD FF 60 14 02 00 29 25 A0 00 A5 8F 01 00 52 26 2A 10 45 02 C2 FF 40 14 98 00 A6 8F ?? ?? ?? 0? 1C 00 A5 8E ?? ?? 03 3C ?? ?? 62 8C 80 06 42 7C FE 02 40 14 A0 00 A6 8F C4 FD C0 18 03 00 02 24 18 00 02 01 40 B8 17 00 ?? ?? 04 3C 24 00 B7 AF ?? ?? 8F 24 21 90 00 00 ?? ?? 0C 3C ?? ?? 0D 3C ?? ?? 0E 3C ?? ?? 17 3C ?? ?? 1E 3C ?? ?? 14 3C 12 18 00 00 80 00 A3 AF ?? ?? 03 3C 18 00 42 01 ?? ?? 71 24 12 18 00 00 B0 00 A3 AF 98 00 A6 8F 24 00 A3 8E B8 00 AC AF 21 28 46 02 BC 00 AD AF C0 00 AE AF C4 00 AF AF 09 F8 60 00 21 20 A0 02 9C 00 AB 8F 20 00 C3 8E 21 20 C0 02 21 28 72 01 09 F8 60 00 21 80 40 00 B8 00 AC 8F BC 00 AD 8F C0 00 AE 8F 2A 00 60 1A C4 00 AF 8F 80 00 A3 8F 24 00 A4 8F B0 00 A5 8F 21 48 43 00 21 50 04 02 21 58 25 01 00 00 45 95 ?? ?? A2 8D ?? ?? C3 8D ?? ?? 84 8D 07 10 45 00 07 18 65 00 3F 00 42 30 07 28 85 00 1F 00 63 30 80 10 02 00 80 18 03 00 1F 00 A5 30 21 10 E2 01 21 18 23 02 80 28 05 00 00 00 44 8C 00 00 66 8C ?? ?? 87 8E ?? ?? C3 8F 21 28 25 02 00 00 A2 8C ?? ?? E8 8E 04 20 64 00 04 30 E6 00 04 10 02 01 25 20 86 00 25 20 82 00 03 1C 04 00 03 12 04 00 01 00 22 A1 02 00 23 A1 00 00 24 A1 03 00 29 25 DE FF 2B 15 02 00 4A 25 A0 00 A6 8F 01 00 52 26 2A 10 46 02 C0 FF 40 14 98 00 A6 8F ?? ?? ?? 0? 1C 00 A5 8E ?? ?? 03 3C ?? ?? 62 8C 80 06 42 7C 41 02 40 14 A0 00 A6 8F 66 FD C0 18 03 00 03 24 18 00 03 01 40 B8 17 00 70 00 B7 AF 21 90 00 00 ?? ?? 0C 3C ?? ?? 0D 3C ?? ?? 0E 3C ?? ?? 17 3C ?? ?? 1E 3C ?? ?? 14 3C 12 10 00 00 74 00 A2 AF ?? ?? 02 3C 18 00 43 01 ?? ?? 50 24 12 10 00 00 A8 00 A2 AF 98 00 A6 8F 24 00 A3 8E B8 00 AC AF 21 28 46 02 BC 00 AD AF C0 00 AE AF 09 F8 60 00 21 20 A0 02 9C 00 AB 8F 20 00 C3 8E 21 20 C0 02 21 28 72 01 09 F8 60 00 21 88 40 00 B8 00 AC 8F BC 00 AD 8F 2A 00 60 1A C0 00 AE 8F 74 00 A3 8F 70 00 A4 8F A8 00 A5 8F 21 48 43 00 21 50 24 02 21 58 25 01 00 00 45 95 ?? ?? A2 8D ?? ?? 83 8D ?? ?? C4 8D 07 10 45 00 07 18 65 00 1F 00 42 30 07 28 85 00 1F 00 63 30 80 10 02 00 80 18 03 00 1F 00 A5 30 21 10 02 02 21 18 03 02 80 28 05 00 00 00 44 8C 00 00 66 8C ?? ?? 87 8E ?? ?? C3 8F 21 28 05 02 00 00 A2 8C ?? ?? E8 8E 04 20 64 00 04 30 E6 00 04 10 02 01 25 20 86 00 25 20 82 00 03 1C 04 00 03 12 04 00 01 00 22 A1 02 00 23 A1 00 00 24 A1 03 00 29 25 DE FF 2B 15 02 00 4A 25 A0 00 A6 8F 01 00 52 26 2A 10 46 02 C2 FF 40 14 98 00 A6 8F ?? ?? ?? 0? 1C 00 A5 8E ?? ?? 03 3C ?? ?? 62 8C 80 06 42 7C 34 01 40 14 A0 00 A4 8F 0C FD 80 18 40 F0 08 00 40 B8 06 00 ?? ?? 02 3C ?? ?? 03 3C 08 00 BE AF 0C 00 B7 AF ?? ?? 51 24 ?? ?? 6E 24 21 90 00 00 ?? ?? 0B 3C ?? ?? 0C 3C ?? ?? 0D 3C ?? ?? 17 3C ?? ?? 1E 3C ?? ?? 14 3C 98 00 A6 8F 24 00 A3 8E B4 00 AB AF 21 28 46 02 B8 00 AC AF BC 00 AD AF C0 00 AE AF 09 F8 60 00 21 20 A0 02 21 80 40 00 9C 00 A2 8F 20 00 C3 8E 21 20 C0 02 09 F8 60 00 21 28 42 02 B4 00 AB 8F B8 00 AC 8F BC 00 AD 8F 2A 00 60 1A C0 00 AE 8F 0C 00 A3 8F 08 00 A4 8F 21 40 00 00 21 50 03 02 21 48 44 00 00 00 44 95 ?? ?? C2 8F ?? ?? 83 8E ?? ?? E5 8E 07 10 44 00 07 18 64 00 3F 00 42 30 07 20 A4 00 1F 00 63 30 80 10 02 00 80 18 03 00 1F 00 84 30 21 10 C2 01 21 18 23 02 80 20 04 00 00 00 45 8C 00 00 66 8C 21 20 24 02 00 00 82 8C ?? ?? 83 8D ?? ?? 64 8D ?? ?? A7 8D C3 28 05 00 C3 30 06 00 04 28 65 00 04 30 86 00 C3 10 02 00 25 28 A6 00 04 10 E2 00 01 00 08 25 25 28 A2 00 2A 18 13 01 00 00 25 A5 02 00 4A 25 DD FF 60 14 02 00 29 25 A0 00 A5 8F 01 00 52 26 2A 10 45 02 C0 FF 40 14 98 00 A6 8F ?? ?? ?? 0? 1C 00 A5 8E 20 00 40 18 98 00 A3 8F 21 90 00 00 10 00 62 24 80 10 02 00 21 A0 A2 02 80 A8 1E 00 9C 00 A6 8F 20 00 C3 8E 21 20 C0 02 21 28 46 02 09 F8 60 00 00 00 91 8E 0D 00 60 1A 21 38 37 02 21 30 55 00 21 28 00 00 00 00 E2 90 01 00 A5 24 2A 20 B3 00 80 10 02 00 21 10 02 02 00 00 43 8C 01 00 E7 24 }
	condition:
		$1
}

rule file_36_0_0 {
	meta:
		name = "_linear_clear_to_color16"
		size = 188
		refs = "0088 .text"
	strings:
		$1 = { E8 FF BD 27 10 00 B4 AF 18 00 82 8C 14 00 94 8C 0C 00 B3 AF 08 00 B2 AF 2A 10 82 02 14 00 BF AF 04 00 B1 AF 00 00 B0 AF 21 90 80 00 10 00 83 8C 17 00 40 10 0C 00 93 8C 23 80 73 00 FF FF B1 30 20 00 43 8E 21 20 40 02 09 F8 60 00 21 28 80 02 08 00 00 1A 21 18 40 00 40 10 13 00 21 10 43 00 21 18 00 00 01 00 63 24 00 00 51 A4 FD FF 70 14 02 00 42 24 18 00 42 8E 01 00 94 26 2A 10 82 02 04 00 40 50 1C 00 42 8E ?? ?? ?? 0? 0C 00 53 8E 1C 00 42 8E 21 20 40 02 14 00 BF 8F 08 00 59 8C 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 20 03 18 00 BD 27 }
	condition:
		$1
}

rule file_36_2_0 {
	meta:
		name = "_linear_masked_blit16"
		size = 276
	strings:
		$1 = { 1C 00 A2 8C D0 FF BD 27 28 00 BE AF 1C 00 B5 AF 18 00 B4 AF 10 00 B2 AF 0C 00 B1 AF 2C 00 BF AF 24 00 B7 AF 20 00 B6 AF 14 00 B3 AF 08 00 B0 AF 21 A8 A0 00 04 00 AB AF 21 A0 80 00 00 00 A7 AF 21 F0 20 01 21 88 40 01 1F 00 60 19 04 00 52 8C 40 B8 06 00 40 B0 08 00 21 80 00 00 00 00 A2 8F 24 00 83 8E 21 20 80 02 09 F8 60 00 21 28 02 02 20 00 A3 8E 21 20 A0 02 21 28 1E 02 09 F8 60 00 21 98 40 00 0B 00 20 1A 21 18 40 00 21 28 76 00 21 10 77 02 21 18 00 00 00 00 44 94 01 00 63 24 02 00 92 10 02 00 42 24 00 00 A4 A4 FA FF 71 14 02 00 A5 24 04 00 A3 8F 01 00 10 26 2A 10 03 02 E7 FF 40 14 00 00 A2 8F 1C 00 83 8E 08 00 62 8C 09 F8 40 00 21 20 80 02 1C 00 A3 8E 21 20 A0 02 2C 00 BF 8F 08 00 79 8C 28 00 BE 8F 24 00 B7 8F 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 20 03 30 00 BD 27 }
	condition:
		$1
}

rule file_36_3_0 {
	meta:
		name = "_linear_blit_backward16"
		size = 232
		refs = "0088 memmove"
	strings:
		$1 = { D8 FF BD 27 0C 00 B3 AF FF FF 73 25 14 00 B5 AF 10 00 B4 AF 24 00 BF AF 20 00 BE AF 1C 00 B7 AF 18 00 B6 AF 08 00 B2 AF 04 00 B1 AF 00 00 B0 AF 21 A0 80 00 19 00 60 06 21 A8 A0 00 FF FF E3 24 FF FF 22 25 21 90 4B 00 40 F0 06 00 40 B8 08 00 40 B0 0A 00 21 88 6B 00 24 00 83 8E 21 28 20 02 09 F8 60 00 21 20 80 02 20 00 A3 8E 21 28 40 02 21 20 A0 02 09 F8 60 00 21 80 40 00 21 20 57 00 21 28 1E 02 21 30 C0 02 ?? ?? ?? 0? FF FF 73 26 FF FF 31 26 F0 FF 61 06 FF FF 52 26 1C 00 83 8E 08 00 62 8C 09 F8 40 00 21 20 80 02 1C 00 A3 8E 21 20 A0 02 24 00 BF 8F 08 00 79 8C 20 00 BE 8F 1C 00 B7 8F 18 00 B6 8F 14 00 B5 8F 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 20 03 28 00 BD 27 }
	condition:
		$1
}

rule file_36_4_0 {
	meta:
		name = "_linear_blit16"
		size = 232
		refs = "0080 memmove"
	strings:
		$1 = { D0 FF BD 27 28 00 BE AF 24 00 B7 AF 14 00 B3 AF 10 00 B2 AF 2C 00 BF AF 20 00 B6 AF 1C 00 B5 AF 18 00 B4 AF 0C 00 B1 AF 08 00 B0 AF 00 00 AB AF 21 90 80 00 21 98 A0 00 21 F0 E0 00 17 00 60 19 21 B8 20 01 40 B0 06 00 40 A8 08 00 40 A0 0A 00 21 88 00 00 24 00 43 8E 21 28 3E 02 09 F8 60 00 21 20 40 02 20 00 63 8E 21 28 37 02 21 20 60 02 09 F8 60 00 21 80 40 00 21 20 55 00 21 28 16 02 ?? ?? ?? 0? 21 30 80 02 00 00 A2 8F 01 00 31 26 2A 18 22 02 F0 FF 60 54 24 00 43 8E 1C 00 43 8E 08 00 62 8C 09 F8 40 00 21 20 40 02 1C 00 63 8E 21 20 60 02 2C 00 BF 8F 08 00 79 8C 28 00 BE 8F 24 00 B7 8F 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 20 03 30 00 BD 27 }
	condition:
		$1
}

rule file_37_0_0 {
	meta:
		name = "bmp_read24"
		size = 32
	strings:
		$1 = { 01 00 82 90 02 00 83 90 00 00 85 90 00 12 02 00 00 1C 03 00 25 10 43 00 08 00 E0 03 25 10 45 00 }
	condition:
		$1
}

rule file_37_1_0 {
	meta:
		name = "bmp_write24"
		size = 24
	strings:
		$1 = { 03 14 05 00 03 1A 05 00 02 00 82 A0 01 00 83 A0 08 00 E0 03 00 00 85 A0 }
	condition:
		$1
}

rule file_37_2_0 {
	meta:
		name = "set_window_title"
		size = 36
		refs = "0000 system_driver"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 43 8C 20 00 79 8C 03 00 20 13 00 00 00 00 08 00 20 03 00 00 00 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_37_3_0 {
	meta:
		name = "desktop_color_depth"
		size = 36
		refs = "0000 system_driver"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 43 8C 60 00 79 8C 03 00 20 13 00 00 00 00 08 00 20 03 00 00 00 00 08 00 E0 03 21 10 00 00 }
	condition:
		$1
}

rule file_37_4_0 {
	meta:
		name = "get_desktop_resolution"
		size = 36
		refs = "0000 system_driver"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 43 8C 64 00 79 8C 03 00 20 13 00 00 00 00 08 00 20 03 00 00 00 00 08 00 E0 03 FF FF 02 24 }
	condition:
		$1
}

rule file_37_8_0 {
	meta:
		name = "bmp_unwrite_line"
		size = 16
	strings:
		$1 = { 1C 00 82 8C 08 00 59 8C 08 00 20 03 00 00 00 00 }
	condition:
		$1
}

rule file_37_9_0 {
	meta:
		name = "is_windowed_mode"
		size = 16
		refs = "0000 gfx_driver"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 43 8C 08 00 E0 03 88 00 62 8C }
	condition:
		$1
}

rule file_37_10_0 {
	meta:
		name = "clear_to_color"
		size = 16
	strings:
		$1 = { 1C 00 82 8C A0 00 59 8C 08 00 20 03 00 00 00 00 }
	condition:
		$1
}

rule file_37_13_0 {
	meta:
		name = "is_same_bitmap"
		size = 80
	strings:
		$1 = { 03 00 80 10 00 00 00 00 03 00 A0 14 00 00 00 00 08 00 E0 03 21 10 00 00 0B 00 85 10 00 00 00 00 2C 00 83 8C FF 01 02 3C FF FF 44 34 24 18 64 00 F7 FF 60 10 2C 00 A2 8C 24 10 44 00 26 10 62 00 08 00 E0 03 01 00 42 2C 08 00 E0 03 FF FF 02 24 }
	condition:
		$1
}

rule file_37_14_0 {
	meta:
		name = "is_linear_bitmap"
		size = 20
	strings:
		$1 = { 2C 00 82 8C 02 17 02 00 01 00 42 38 08 00 E0 03 01 00 42 30 }
	condition:
		$1
}

rule file_37_16_0 {
	meta:
		name = "is_memory_bitmap"
		size = 20
	strings:
		$1 = { 2C 00 82 8C 00 C0 03 3C 24 10 43 00 08 00 E0 03 01 00 42 2C }
	condition:
		$1
}

rule file_37_17_0 {
	meta:
		name = "is_screen_bitmap"
		size = 84
		refs = "0000 screen"
	strings:
		$1 = { ?? ?? 02 3C 03 00 80 10 ?? ?? 45 8C 03 00 A0 14 00 00 00 00 08 00 E0 03 21 10 00 00 0B 00 A4 10 00 00 00 00 2C 00 83 8C FF 01 02 3C FF FF 44 34 24 18 64 00 F7 FF 60 10 2C 00 A2 8C 24 10 44 00 26 10 62 00 08 00 E0 03 01 00 42 2C 08 00 E0 03 FF FF 02 24 }
	condition:
		$1
}

rule file_37_21_0 {
	meta:
		name = "acquire_bitmap"
		size = 32
	strings:
		$1 = { 1C 00 82 8C 10 00 59 8C 03 00 20 13 00 00 00 00 08 00 20 03 00 00 00 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_37_22_0 {
	meta:
		name = "release_bitmap"
		size = 32
	strings:
		$1 = { 1C 00 82 8C 14 00 59 8C 03 00 20 13 00 00 00 00 08 00 20 03 00 00 00 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_37_25_0 {
	meta:
		name = "is_inside_bitmap"
		size = 116
	strings:
		$1 = { 09 00 E0 54 08 00 82 8C 00 00 82 8C 2B 10 A2 00 03 00 40 54 04 00 82 8C 08 00 E0 03 21 10 00 00 08 00 E0 03 2B 10 C2 00 10 00 40 10 00 00 00 00 0C 00 82 8C 2A 10 A2 00 F7 FF 40 14 00 00 00 00 14 00 82 8C 2A 10 C2 00 F3 FF 40 14 00 00 00 00 10 00 82 8C 2A 10 A2 00 EF FF 40 10 00 00 00 00 18 00 82 8C 08 00 E0 03 2A 10 C2 00 08 00 E0 03 FF FF 02 24 }
	condition:
		$1
}

rule file_37_26_0 {
	meta:
		name = "get_clip_rect"
		size = 44
	strings:
		$1 = { 0C 00 82 8C 00 00 A2 AC 14 00 83 8C 00 00 C3 AC 10 00 82 8C FF FF 42 24 00 00 E2 AC 18 00 83 8C FF FF 63 24 08 00 E0 03 00 00 03 AD }
	condition:
		$1
}

rule file_37_29_0 {
	meta:
		name = "makecol15"
		size = 60
		refs = "0000 _rgb_g_shift_15 0004 _rgb_r_shift_15 0010 _rgb_b_shift_15"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 03 3C ?? ?? 48 8C ?? ?? 67 8C ?? ?? 02 3C ?? ?? 43 8C C3 28 05 00 C3 20 04 00 04 28 05 01 04 20 E4 00 C3 10 06 00 25 28 A4 00 04 10 62 00 08 00 E0 03 25 10 A2 00 }
	condition:
		$1
}

rule file_37_30_0 {
	meta:
		name = "makecol16"
		size = 60
		refs = "0000 _rgb_g_shift_16 0004 _rgb_r_shift_16 0010 _rgb_b_shift_16"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 03 3C ?? ?? 48 8C ?? ?? 67 8C ?? ?? 02 3C ?? ?? 43 8C 83 28 05 00 C3 20 04 00 04 28 05 01 04 20 E4 00 C3 10 06 00 25 28 A4 00 04 10 62 00 08 00 E0 03 25 10 A2 00 }
	condition:
		$1
}

rule file_37_31_0 {
	meta:
		name = "makecol24"
		size = 48
		refs = "0000 _rgb_g_shift_24 0004 _rgb_r_shift_24 0010 _rgb_b_shift_24"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 03 3C ?? ?? 48 8C ?? ?? 67 8C ?? ?? 02 3C ?? ?? 43 8C 04 20 E4 00 04 10 05 01 25 10 44 00 04 30 66 00 08 00 E0 03 25 10 46 00 }
	condition:
		$1
}

rule file_37_32_0 {
	meta:
		name = "makecol32"
		size = 48
		refs = "0000 _rgb_g_shift_32 0004 _rgb_r_shift_32 0010 _rgb_b_shift_32"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 03 3C ?? ?? 48 8C ?? ?? 67 8C ?? ?? 02 3C ?? ?? 43 8C 04 20 E4 00 04 10 05 01 25 10 44 00 04 30 66 00 08 00 E0 03 25 10 46 00 }
	condition:
		$1
}

rule file_37_33_0 {
	meta:
		name = "makeacol32"
		size = 64
		refs = "0000 _rgb_g_shift_32 0004 _rgb_r_shift_32 0010 _rgb_b_shift_32 0018 _rgb_a_shift_32"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 03 3C ?? ?? 4B 8C ?? ?? 68 8C ?? ?? 02 3C ?? ?? 49 8C ?? ?? 03 3C ?? ?? 6A 8C 04 10 65 01 04 20 04 01 25 10 44 00 04 30 26 01 25 10 46 00 04 38 47 01 08 00 E0 03 25 10 47 00 }
	condition:
		$1
}

rule file_37_34_0 {
	meta:
		name = "getr8"
		size = 44
		refs = "0000 _current_palette 0014 _rgb_scale_6"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 24 80 20 04 00 21 20 82 00 00 00 83 90 ?? ?? 02 3C ?? ?? 42 24 80 18 03 00 21 18 62 00 08 00 E0 03 00 00 62 8C }
	condition:
		$1
}

rule file_37_35_0 {
	meta:
		name = "getg8"
		size = 44
		refs = "0000 _current_palette 0014 _rgb_scale_6"
	strings:
		$1 = { ?? ?? 02 3C 80 20 04 00 ?? ?? 42 24 21 10 44 00 01 00 43 90 ?? ?? 02 3C ?? ?? 42 24 80 18 03 00 21 18 62 00 08 00 E0 03 00 00 62 8C }
	condition:
		$1
}

rule file_37_36_0 {
	meta:
		name = "getb8"
		size = 44
		refs = "0000 _current_palette 0014 _rgb_scale_6"
	strings:
		$1 = { ?? ?? 02 3C 80 20 04 00 ?? ?? 42 24 21 10 44 00 02 00 43 90 ?? ?? 02 3C ?? ?? 42 24 80 18 03 00 21 18 62 00 08 00 E0 03 00 00 62 8C }
	condition:
		$1
}

rule file_37_37_0 {
	meta:
		name = "getr15"
		size = 40
		refs = "0000 _rgb_r_shift_15 0008 _rgb_scale_5"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 43 8C ?? ?? 02 3C ?? ?? 42 24 07 20 64 00 1F 00 84 30 80 20 04 00 21 20 82 00 08 00 E0 03 00 00 82 8C }
	condition:
		$1
}

rule file_37_39_0 {
	meta:
		name = "getb15"
		size = 40
		refs = "0000 _rgb_b_shift_15 0008 _rgb_scale_5"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 43 8C ?? ?? 02 3C ?? ?? 42 24 07 20 64 00 1F 00 84 30 80 20 04 00 21 20 82 00 08 00 E0 03 00 00 82 8C }
	condition:
		$1
}

rule file_37_42_0 {
	meta:
		name = "getb16"
		size = 40
		refs = "0000 _rgb_b_shift_16 0008 _rgb_scale_5"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 43 8C ?? ?? 02 3C ?? ?? 42 24 07 20 64 00 1F 00 84 30 80 20 04 00 21 20 82 00 08 00 E0 03 00 00 82 8C }
	condition:
		$1
}

rule file_37_38_0 {
	meta:
		name = "getg15"
		size = 40
		refs = "0000 _rgb_g_shift_15 0008 _rgb_scale_5"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 43 8C ?? ?? 02 3C ?? ?? 42 24 07 20 64 00 1F 00 84 30 80 20 04 00 21 20 82 00 08 00 E0 03 00 00 82 8C }
	condition:
		$1
}

rule file_37_40_0 {
	meta:
		name = "getr16"
		size = 40
		refs = "0000 _rgb_r_shift_16 0008 _rgb_scale_5"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 43 8C ?? ?? 02 3C ?? ?? 42 24 07 20 64 00 1F 00 84 30 80 20 04 00 21 20 82 00 08 00 E0 03 00 00 82 8C }
	condition:
		$1
}

rule file_37_41_0 {
	meta:
		name = "getg16"
		size = 40
		refs = "0000 _rgb_g_shift_16 0008 _rgb_scale_6"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 43 8C ?? ?? 02 3C ?? ?? 42 24 07 20 64 00 3F 00 84 30 80 20 04 00 21 20 82 00 08 00 E0 03 00 00 82 8C }
	condition:
		$1
}

rule file_37_43_0 {
	meta:
		name = "getr24"
		size = 20
		refs = "0000 _rgb_r_shift_24"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 43 8C 07 10 64 00 08 00 E0 03 FF 00 42 30 }
	condition:
		$1
}

rule file_37_49_0 {
	meta:
		name = "geta32"
		size = 20
		refs = "0000 _rgb_a_shift_32"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 43 8C 07 10 64 00 08 00 E0 03 FF 00 42 30 }
	condition:
		$1
}

rule file_37_45_0 {
	meta:
		name = "getb24"
		size = 20
		refs = "0000 _rgb_b_shift_24"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 43 8C 07 10 64 00 08 00 E0 03 FF 00 42 30 }
	condition:
		$1
}

rule file_37_48_0 {
	meta:
		name = "getb32"
		size = 20
		refs = "0000 _rgb_b_shift_32"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 43 8C 07 10 64 00 08 00 E0 03 FF 00 42 30 }
	condition:
		$1
}

rule file_37_44_0 {
	meta:
		name = "getg24"
		size = 20
		refs = "0000 _rgb_g_shift_24"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 43 8C 07 10 64 00 08 00 E0 03 FF 00 42 30 }
	condition:
		$1
}

rule file_37_47_0 {
	meta:
		name = "getg32"
		size = 20
		refs = "0000 _rgb_g_shift_32"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 43 8C 07 10 64 00 08 00 E0 03 FF 00 42 30 }
	condition:
		$1
}

rule file_37_46_0 {
	meta:
		name = "getr32"
		size = 20
		refs = "0000 _rgb_r_shift_32"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 43 8C 07 10 64 00 08 00 E0 03 FF 00 42 30 }
	condition:
		$1
}

rule file_37_50_0 {
	meta:
		name = "getpixel"
		size = 16
	strings:
		$1 = { 1C 00 82 8C 20 00 59 8C 08 00 20 03 00 00 00 00 }
	condition:
		$1
}

rule file_37_51_0 {
	meta:
		name = "putpixel"
		size = 16
	strings:
		$1 = { 1C 00 82 8C 24 00 59 8C 08 00 20 03 00 00 00 00 }
	condition:
		$1
}

rule file_37_52_0 {
	meta:
		name = "_allegro_vline"
		size = 16
	strings:
		$1 = { 1C 00 82 8C 28 00 59 8C 08 00 20 03 00 00 00 00 }
	condition:
		$1
}

rule file_37_53_0 {
	meta:
		name = "_allegro_hline"
		size = 16
	strings:
		$1 = { 1C 00 82 8C 2C 00 59 8C 08 00 20 03 00 00 00 00 }
	condition:
		$1
}

rule file_37_54_0 {
	meta:
		name = "line"
		size = 16
	strings:
		$1 = { 1C 00 82 8C 34 00 59 8C 08 00 20 03 00 00 00 00 }
	condition:
		$1
}

rule file_37_55_0 {
	meta:
		name = "fastline"
		size = 16
	strings:
		$1 = { 1C 00 82 8C 38 00 59 8C 08 00 20 03 00 00 00 00 }
	condition:
		$1
}

rule file_37_56_0 {
	meta:
		name = "rectfill"
		size = 16
	strings:
		$1 = { 1C 00 82 8C 3C 00 59 8C 08 00 20 03 00 00 00 00 }
	condition:
		$1
}

rule file_37_57_0 {
	meta:
		name = "triangle"
		size = 16
	strings:
		$1 = { 1C 00 82 8C 40 00 59 8C 08 00 20 03 00 00 00 00 }
	condition:
		$1
}

rule file_37_58_0 {
	meta:
		name = "polygon"
		size = 16
	strings:
		$1 = { 1C 00 82 8C B8 00 59 8C 08 00 20 03 00 00 00 00 }
	condition:
		$1
}

rule file_37_59_0 {
	meta:
		name = "rect"
		size = 16
	strings:
		$1 = { 1C 00 82 8C BC 00 59 8C 08 00 20 03 00 00 00 00 }
	condition:
		$1
}

rule file_37_60_0 {
	meta:
		name = "circle"
		size = 16
	strings:
		$1 = { 1C 00 82 8C C0 00 59 8C 08 00 20 03 00 00 00 00 }
	condition:
		$1
}

rule file_37_61_0 {
	meta:
		name = "circlefill"
		size = 16
	strings:
		$1 = { 1C 00 82 8C C4 00 59 8C 08 00 20 03 00 00 00 00 }
	condition:
		$1
}

rule file_37_62_0 {
	meta:
		name = "ellipse"
		size = 16
	strings:
		$1 = { 1C 00 82 8C C8 00 59 8C 08 00 20 03 00 00 00 00 }
	condition:
		$1
}

rule file_37_63_0 {
	meta:
		name = "ellipsefill"
		size = 16
	strings:
		$1 = { 1C 00 82 8C CC 00 59 8C 08 00 20 03 00 00 00 00 }
	condition:
		$1
}

rule file_37_64_0 {
	meta:
		name = "arc"
		size = 16
	strings:
		$1 = { 1C 00 82 8C D0 00 59 8C 08 00 20 03 00 00 00 00 }
	condition:
		$1
}

rule file_37_65_0 {
	meta:
		name = "spline"
		size = 16
	strings:
		$1 = { 1C 00 82 8C D4 00 59 8C 08 00 20 03 00 00 00 00 }
	condition:
		$1
}

rule file_37_66_0 {
	meta:
		name = "floodfill"
		size = 16
	strings:
		$1 = { 1C 00 82 8C D8 00 59 8C 08 00 20 03 00 00 00 00 }
	condition:
		$1
}

rule file_37_67_0 {
	meta:
		name = "polygon3d"
		size = 16
	strings:
		$1 = { 1C 00 82 8C DC 00 59 8C 08 00 20 03 00 00 00 00 }
	condition:
		$1
}

rule file_37_68_0 {
	meta:
		name = "polygon3d_f"
		size = 16
	strings:
		$1 = { 1C 00 82 8C E0 00 59 8C 08 00 20 03 00 00 00 00 }
	condition:
		$1
}

rule file_37_69_0 {
	meta:
		name = "triangle3d"
		size = 16
	strings:
		$1 = { 1C 00 82 8C E4 00 59 8C 08 00 20 03 00 00 00 00 }
	condition:
		$1
}

rule file_37_70_0 {
	meta:
		name = "triangle3d_f"
		size = 16
	strings:
		$1 = { 1C 00 82 8C E8 00 59 8C 08 00 20 03 00 00 00 00 }
	condition:
		$1
}

rule file_37_71_0 {
	meta:
		name = "quad3d"
		size = 16
	strings:
		$1 = { 1C 00 82 8C EC 00 59 8C 08 00 20 03 00 00 00 00 }
	condition:
		$1
}

rule file_37_72_0 {
	meta:
		name = "quad3d_f"
		size = 16
	strings:
		$1 = { 1C 00 82 8C F0 00 59 8C 08 00 20 03 00 00 00 00 }
	condition:
		$1
}

rule file_37_73_0 {
	meta:
		name = "draw_sprite"
		size = 44
	strings:
		$1 = { 1C 00 A2 8C 08 00 03 24 00 00 48 8C 04 00 03 11 1C 00 82 8C 44 00 59 8C 08 00 20 03 00 00 00 00 48 00 59 8C 08 00 20 03 00 00 00 00 }
	condition:
		$1
}

rule file_37_74_0 {
	meta:
		name = "draw_sprite_ex"
		size = 16
	strings:
		$1 = { 1C 00 82 8C F4 00 59 8C 08 00 20 03 00 00 00 00 }
	condition:
		$1
}

rule file_37_75_0 {
	meta:
		name = "draw_sprite_v_flip"
		size = 16
	strings:
		$1 = { 1C 00 82 8C 4C 00 59 8C 08 00 20 03 00 00 00 00 }
	condition:
		$1
}

rule file_37_76_0 {
	meta:
		name = "draw_sprite_h_flip"
		size = 16
	strings:
		$1 = { 1C 00 82 8C 50 00 59 8C 08 00 20 03 00 00 00 00 }
	condition:
		$1
}

rule file_37_77_0 {
	meta:
		name = "draw_sprite_vh_flip"
		size = 16
	strings:
		$1 = { 1C 00 82 8C 54 00 59 8C 08 00 20 03 00 00 00 00 }
	condition:
		$1
}

rule file_37_78_0 {
	meta:
		name = "draw_trans_sprite"
		size = 44
	strings:
		$1 = { 1C 00 A2 8C 20 00 03 24 00 00 48 8C 04 00 03 11 1C 00 82 8C 58 00 59 8C 08 00 20 03 00 00 00 00 5C 00 59 8C 08 00 20 03 00 00 00 00 }
	condition:
		$1
}

rule file_37_79_0 {
	meta:
		name = "draw_lit_sprite"
		size = 16
	strings:
		$1 = { 1C 00 82 8C 60 00 59 8C 08 00 20 03 00 00 00 00 }
	condition:
		$1
}

rule file_37_80_0 {
	meta:
		name = "draw_gouraud_sprite"
		size = 16
	strings:
		$1 = { 1C 00 82 8C AC 00 59 8C 08 00 20 03 00 00 00 00 }
	condition:
		$1
}

rule file_37_81_0 {
	meta:
		name = "draw_character_ex"
		size = 16
	strings:
		$1 = { 1C 00 82 8C 74 00 59 8C 08 00 20 03 00 00 00 00 }
	condition:
		$1
}

rule file_37_82_0 {
	meta:
		name = "rotate_sprite"
		size = 80
	strings:
		$1 = { 1C 00 8A 8C F0 FF BD 27 04 00 A9 8C 00 00 A3 8C 00 00 A0 AF A4 00 42 8D C0 1B 03 00 C0 4B 09 00 00 34 06 00 00 3C 07 00 0C 00 BF AF 21 50 00 01 21 30 C3 00 21 38 E9 00 21 40 60 00 09 F8 40 00 01 00 0B 3C 0C 00 BF 8F 08 00 E0 03 10 00 BD 27 }
	condition:
		$1
}

rule file_37_83_0 {
	meta:
		name = "rotate_sprite_v_flip"
		size = 84
	strings:
		$1 = { 1C 00 8A 8C F0 FF BD 27 04 00 A9 8C 00 00 AB 8C FF FF 02 24 00 00 A2 AF A4 00 43 8D C0 5B 0B 00 C0 4B 09 00 00 34 06 00 00 3C 07 00 0C 00 BF AF 21 50 00 01 21 30 CB 00 21 40 60 01 21 38 E9 00 09 F8 60 00 01 00 0B 3C 0C 00 BF 8F 08 00 E0 03 10 00 BD 27 }
	condition:
		$1
}

rule file_37_84_0 {
	meta:
		name = "rotate_scaled_sprite"
		size = 132
	strings:
		$1 = { 04 00 AB 8C 00 00 AD 8C 21 10 20 01 18 00 2B 01 1C 00 89 8C F0 FF BD 27 02 00 03 24 00 00 A0 AF A4 00 2E 8D C0 4B 0B 00 21 58 40 00 00 34 06 00 00 3C 07 00 0C 00 BF AF 21 50 00 01 C0 43 0D 00 12 60 00 00 18 00 4D 00 12 10 00 00 02 00 60 14 1A 00 83 01 CD 01 00 00 12 60 00 00 21 38 87 01 02 00 60 14 1A 00 43 00 CD 01 00 00 12 10 00 00 09 F8 C0 01 21 30 46 00 0C 00 BF 8F 08 00 E0 03 10 00 BD 27 }
	condition:
		$1
}

rule file_37_85_0 {
	meta:
		name = "rotate_scaled_sprite_v_flip"
		size = 136
	strings:
		$1 = { 04 00 AB 8C 00 00 AE 8C 21 18 20 01 18 00 2B 01 1C 00 89 8C F0 FF BD 27 FF FF 02 24 02 00 0C 24 00 00 A2 AF A4 00 2F 8D C0 4B 0B 00 21 58 60 00 00 34 06 00 00 3C 07 00 0C 00 BF AF 21 50 00 01 C0 43 0E 00 12 68 00 00 18 00 6E 00 12 18 00 00 02 00 80 15 1A 00 AC 01 CD 01 00 00 12 68 00 00 21 38 A7 01 02 00 80 15 1A 00 6C 00 CD 01 00 00 12 18 00 00 09 F8 E0 01 21 30 66 00 0C 00 BF 8F 08 00 E0 03 10 00 BD 27 }
	condition:
		$1
}

rule file_37_86_0 {
	meta:
		name = "pivot_sprite"
		size = 56
	strings:
		$1 = { 1C 00 82 8C F0 FF BD 27 00 00 A0 AF A4 00 43 8C 0C 00 BF AF 00 34 06 00 00 3C 07 00 00 44 08 00 00 4C 09 00 09 F8 60 00 01 00 0B 3C 0C 00 BF 8F 08 00 E0 03 10 00 BD 27 }
	condition:
		$1
}

rule file_37_87_0 {
	meta:
		name = "pivot_sprite_v_flip"
		size = 60
	strings:
		$1 = { 1C 00 82 8C F0 FF BD 27 FF FF 03 24 00 00 A3 AF A4 00 4C 8C 0C 00 BF AF 00 34 06 00 00 3C 07 00 00 44 08 00 00 4C 09 00 09 F8 80 01 01 00 0B 3C 0C 00 BF 8F 08 00 E0 03 10 00 BD 27 }
	condition:
		$1
}

rule file_37_88_0 {
	meta:
		name = "pivot_scaled_sprite"
		size = 52
	strings:
		$1 = { 1C 00 82 8C F0 FF BD 27 00 00 A0 AF A4 00 43 8C 0C 00 BF AF 00 34 06 00 00 3C 07 00 00 44 08 00 09 F8 60 00 00 4C 09 00 0C 00 BF 8F 08 00 E0 03 10 00 BD 27 }
	condition:
		$1
}

rule file_37_89_0 {
	meta:
		name = "pivot_scaled_sprite_v_flip"
		size = 56
	strings:
		$1 = { 1C 00 82 8C F0 FF BD 27 FF FF 03 24 00 00 A3 AF A4 00 4C 8C 0C 00 BF AF 00 34 06 00 00 3C 07 00 00 44 08 00 09 F8 80 01 00 4C 09 00 0C 00 BF 8F 08 00 E0 03 10 00 BD 27 }
	condition:
		$1
}

rule file_37_90_0 {
	meta:
		name = "_putpixel"
		size = 88
	strings:
		$1 = { 20 00 83 8C F0 FF BD 27 0C 00 BF AF 08 00 B2 AF 04 00 B1 AF 00 00 B0 AF 21 90 A0 00 21 28 C0 00 21 80 80 00 09 F8 60 00 21 88 E0 00 21 10 52 00 00 00 51 A0 1C 00 02 8E 21 20 00 02 0C 00 BF 8F 08 00 59 8C 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 20 03 10 00 BD 27 }
	condition:
		$1
}

rule file_37_91_0 {
	meta:
		name = "_getpixel"
		size = 92
	strings:
		$1 = { 24 00 83 8C F0 FF BD 27 0C 00 BF AF 08 00 B2 AF 04 00 B1 AF 00 00 B0 AF 21 88 A0 00 21 80 80 00 09 F8 60 00 21 28 C0 00 1C 00 04 8E 21 10 51 00 00 00 52 90 08 00 82 8C 09 F8 40 00 21 20 00 02 0C 00 BF 8F 21 10 40 02 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 10 00 BD 27 }
	condition:
		$1
}

rule file_37_92_0 {
	meta:
		name = "_putpixel15"
		size = 92
		altNames = "_putpixel16"
	strings:
		$1 = { 20 00 88 8C F0 FF BD 27 0C 00 BF AF 08 00 B2 AF 04 00 B1 AF 00 00 B0 AF 21 88 80 00 21 80 A0 00 21 28 C0 00 09 F8 00 01 21 90 E0 00 1C 00 23 8E 40 80 10 00 21 80 02 02 08 00 79 8C 00 00 12 A6 21 20 20 02 0C 00 BF 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 20 03 10 00 BD 27 }
	condition:
		$1
}

rule file_37_93_0 {
	meta:
		name = "_getpixel15"
		size = 96
		altNames = "_getpixel16"
	strings:
		$1 = { 24 00 83 8C F0 FF BD 27 0C 00 BF AF 08 00 B2 AF 04 00 B1 AF 00 00 B0 AF 21 88 80 00 21 80 A0 00 09 F8 60 00 21 28 C0 00 1C 00 24 8E 40 80 10 00 21 80 02 02 08 00 82 8C 21 20 20 02 09 F8 40 00 00 00 12 96 0C 00 BF 8F 21 10 40 02 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 10 00 BD 27 }
	condition:
		$1
}

rule file_37_96_0 {
	meta:
		name = "_putpixel24"
		size = 116
	strings:
		$1 = { 20 00 88 8C F0 FF BD 27 0C 00 BF AF 08 00 B2 AF 04 00 B1 AF 00 00 B0 AF 21 80 A0 00 21 28 C0 00 21 88 E0 00 09 F8 00 01 21 90 80 00 03 00 03 24 18 00 03 02 03 2C 11 00 03 1A 11 00 21 20 40 02 12 80 00 00 21 10 50 00 02 00 45 A0 01 00 43 A0 00 00 51 A0 1C 00 42 8E 0C 00 BF 8F 08 00 B2 8F 08 00 59 8C 04 00 B1 8F 00 00 B0 8F 08 00 20 03 10 00 BD 27 }
	condition:
		$1
}

rule file_37_97_0 {
	meta:
		name = "_getpixel24"
		size = 120
	strings:
		$1 = { 24 00 87 8C F0 FF BD 27 0C 00 BF AF 08 00 B1 AF 04 00 B0 AF 21 88 A0 00 21 28 C0 00 09 F8 E0 00 21 80 80 00 03 00 03 24 18 00 23 02 1C 00 05 8E 21 20 00 02 08 00 A6 8C 12 88 00 00 21 10 51 00 01 00 50 90 02 00 43 90 00 00 45 90 00 82 10 00 00 1C 03 00 25 80 03 02 09 F8 C0 00 25 80 05 02 0C 00 BF 8F 21 10 00 02 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 10 00 BD 27 }
	condition:
		$1
}

rule file_37_98_0 {
	meta:
		name = "_putpixel32"
		size = 92
	strings:
		$1 = { 20 00 88 8C F0 FF BD 27 0C 00 BF AF 08 00 B2 AF 04 00 B1 AF 00 00 B0 AF 21 88 80 00 21 80 A0 00 21 28 C0 00 09 F8 00 01 21 90 E0 00 1C 00 23 8E 80 80 10 00 21 80 02 02 08 00 79 8C 00 00 12 AE 21 20 20 02 0C 00 BF 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 20 03 10 00 BD 27 }
	condition:
		$1
}

rule file_37_99_0 {
	meta:
		name = "_getpixel32"
		size = 96
	strings:
		$1 = { 24 00 83 8C F0 FF BD 27 0C 00 BF AF 08 00 B2 AF 04 00 B1 AF 00 00 B0 AF 21 88 80 00 21 80 A0 00 09 F8 60 00 21 28 C0 00 1C 00 24 8E 80 80 10 00 21 80 02 02 08 00 82 8C 21 20 20 02 09 F8 40 00 00 00 12 8E 0C 00 BF 8F 21 10 40 02 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 10 00 BD 27 }
	condition:
		$1
}

rule file_37_100_0 {
	meta:
		name = "draw_rle_sprite"
		size = 16
		altNames = "draw_compiled_sprite"
	strings:
		$1 = { 1C 00 82 8C 64 00 59 8C 08 00 20 03 00 00 00 00 }
	condition:
		$1
}

rule file_37_101_0 {
	meta:
		name = "draw_trans_rle_sprite"
		size = 40
	strings:
		$1 = { 08 00 A3 8C 20 00 02 24 04 00 62 10 1C 00 82 8C 68 00 59 8C 08 00 20 03 00 00 00 00 6C 00 59 8C 08 00 20 03 00 00 00 00 }
	condition:
		$1
}

rule file_37_102_0 {
	meta:
		name = "draw_lit_rle_sprite"
		size = 16
	strings:
		$1 = { 1C 00 82 8C 70 00 59 8C 08 00 20 03 00 00 00 00 }
	condition:
		$1
}

rule file_37_103_0 {
	meta:
		name = "ftofix"
		size = 296
		refs = "0000 $LC0 0028 __gtdf2 0034 allegro_errno 0068 $LC1 0078 __ltdf2 009c $LC2 00a8 $LC4 00b8 __muldf3 00cc __adddf3 00d8 __fixdfsi 00fc $LC3 0104 .text"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C E8 FF BD 27 08 00 B1 AF 04 00 B0 AF 14 00 BF AF 10 00 B3 AF 0C 00 B2 AF 21 80 80 00 ?? ?? ?? 0? 21 88 A0 00 0D 00 40 18 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 42 34 14 00 BF 8F 10 00 B3 8F 0C 00 B2 8F 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 18 00 BD 27 ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 22 00 40 04 21 20 00 02 21 28 20 02 21 30 00 00 ?? ?? ?? 0? 21 38 00 00 18 00 40 04 ?? ?? 02 3C ?? ?? 52 8C ?? ?? 53 8C ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 21 20 40 00 21 30 40 02 21 38 60 02 ?? ?? ?? 0? 21 28 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 14 00 BF 8F 10 00 B3 8F 0C 00 B2 8F 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 18 00 BD 27 ?? ?? 02 3C ?? ?? 52 8C ?? ?? ?? 0? ?? ?? 53 8C ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 00 80 02 3C 00 00 83 AC ?? ?? ?? 0? 01 00 42 34 }
	condition:
		$1
}

rule file_37_104_0 {
	meta:
		name = "fixtof"
		size = 52
		refs = "0008 __floatsidf 0010 $LC5 0020 __muldf3"
	strings:
		$1 = { F8 FF BD 27 04 00 BF AF ?? ?? ?? 0? 00 00 00 00 ?? ?? 04 3C ?? ?? 86 8C ?? ?? 87 8C 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 04 00 BF 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_1520_0_15 {
	meta:
		name = "__fractdadf"
		size = 52
		refs = "0008 __floatdidf 0010 $LC0 0020 __muldf3"
	strings:
		$1 = { F8 FF BD 27 04 00 BF AF ?? ?? ?? 0? 00 00 00 00 ?? ?? 04 3C ?? ?? 86 8C ?? ?? 87 8C 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 04 00 BF 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_1076_0_15 {
	meta:
		name = "__fractdqdf"
		size = 52
		refs = "0008 __floatdidf 0010 $LC0 0020 __muldf3"
	strings:
		$1 = { F8 FF BD 27 04 00 BF AF ?? ?? ?? 0? 00 00 00 00 ?? ?? 04 3C ?? ?? 86 8C ?? ?? 87 8C 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 04 00 BF 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_1305_0_15 {
	meta:
		name = "__fractsadf"
		size = 52
		refs = "0008 __floatsidf 0010 $LC0 0020 __muldf3"
	strings:
		$1 = { F8 FF BD 27 04 00 BF AF ?? ?? ?? 0? 00 00 00 00 ?? ?? 04 3C ?? ?? 86 8C ?? ?? 87 8C 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 04 00 BF 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_141_0_15 {
	meta:
		name = "__fractsqdf"
		size = 52
		refs = "0008 __floatsidf 0010 $LC0 0020 __muldf3"
	strings:
		$1 = { F8 FF BD 27 04 00 BF AF ?? ?? ?? 0? 00 00 00 00 ?? ?? 04 3C ?? ?? 86 8C ?? ?? 87 8C 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 04 00 BF 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_1325_0_15 {
	meta:
		name = "__fractudadf"
		size = 52
		refs = "0008 __floatundidf 0010 $LC0 0020 __muldf3"
	strings:
		$1 = { F8 FF BD 27 04 00 BF AF ?? ?? ?? 0? 00 00 00 00 ?? ?? 04 3C ?? ?? 86 8C ?? ?? 87 8C 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 04 00 BF 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_1256_0_15 {
	meta:
		name = "__fractudqdf"
		size = 52
		refs = "0008 __floatundidf 0010 $LC0 0020 __muldf3"
	strings:
		$1 = { F8 FF BD 27 04 00 BF AF ?? ?? ?? 0? 00 00 00 00 ?? ?? 04 3C ?? ?? 86 8C ?? ?? 87 8C 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 04 00 BF 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_873_0_15 {
	meta:
		name = "__fractusadf"
		size = 52
		refs = "0008 __floatunsidf 0010 $LC0 0020 __muldf3"
	strings:
		$1 = { F8 FF BD 27 04 00 BF AF ?? ?? ?? 0? 00 00 00 00 ?? ?? 04 3C ?? ?? 86 8C ?? ?? 87 8C 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 04 00 BF 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_932_0_15 {
	meta:
		name = "__fractusqdf"
		size = 52
		refs = "0008 __floatunsidf 0010 $LC0 0020 __muldf3"
	strings:
		$1 = { F8 FF BD 27 04 00 BF AF ?? ?? ?? 0? 00 00 00 00 ?? ?? 04 3C ?? ?? 86 8C ?? ?? 87 8C 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 04 00 BF 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_37_105_0 {
	meta:
		name = "fixadd"
		size = 100
		refs = "0024 allegro_errno"
	strings:
		$1 = { 21 10 A4 00 0D 00 40 04 00 00 00 00 03 00 80 04 00 00 00 00 08 00 E0 03 00 00 00 00 FD FF A1 04 22 00 03 24 ?? ?? 02 3C ?? ?? 44 8C 00 80 02 3C 00 00 83 AC 08 00 E0 03 01 00 42 34 F5 FF 80 18 00 00 00 00 F3 FF A0 18 22 00 03 24 ?? ?? 02 3C ?? ?? 44 8C FF 7F 02 3C 00 00 83 AC 08 00 E0 03 FF FF 42 34 }
	condition:
		$1
}

rule file_37_106_0 {
	meta:
		name = "fixsub"
		size = 100
		refs = "0024 allegro_errno"
	strings:
		$1 = { 23 10 85 00 0D 00 40 04 00 00 00 00 03 00 80 04 00 00 00 00 08 00 E0 03 00 00 00 00 FD FF A0 18 22 00 03 24 ?? ?? 02 3C ?? ?? 44 8C 00 80 02 3C 00 00 83 AC 08 00 E0 03 01 00 42 34 F5 FF 80 18 00 00 00 00 F3 FF A1 04 22 00 03 24 ?? ?? 02 3C ?? ?? 44 8C FF 7F 02 3C 00 00 83 AC 08 00 E0 03 FF FF 42 34 }
	condition:
		$1
}

rule file_37_107_0 {
	meta:
		name = "fixmul"
		size = 164
		refs = "002c allegro_errno 009c .text"
	strings:
		$1 = { 18 00 A4 00 00 80 02 34 10 28 00 00 2A 10 A2 00 13 00 40 10 12 20 00 00 FF 7F 02 24 0C 00 A2 10 FF FF 02 3C 00 80 A2 28 19 00 40 14 ?? ?? 02 3C 00 80 02 24 12 00 A2 50 01 00 02 3C 00 14 05 00 02 1C 04 00 25 20 43 00 08 00 E0 03 21 10 80 00 01 00 42 34 2B 10 82 00 F3 FF 40 54 00 80 A2 28 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 44 34 08 00 E0 03 21 10 80 00 2B 10 82 00 EE FF 40 50 00 14 05 00 ?? ?? 02 3C ?? ?? 43 8C 22 00 02 24 00 80 04 3C ?? ?? ?? 0? 00 00 62 AC }
	condition:
		$1
}

rule file_37_108_0 {
	meta:
		name = "fixdiv"
		size = 448
		refs = "0104 allegro_errno 005c __floatsidf 0060 $LC5 0070 __muldf3 00a8 __divdf3 00b4 $LC0 00c8 __gtdf2 00e4 .text 00d4 $LC1 00f8 __ltdf2 0120 $LC2 012c $LC4 0150 __adddf3 015c __fixdfsi 01b0 $LC3"
	strings:
		$1 = { E8 FF BD 27 10 00 B3 AF 21 98 A0 00 14 00 BF AF 0C 00 B2 AF 08 00 B1 AF 04 00 B0 AF 0F 00 60 16 21 28 80 00 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 56 00 A0 04 00 00 83 AC 14 00 BF 8F FF 7F 02 3C FF FF 42 34 10 00 B3 8F 0C 00 B2 8F 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 18 00 BD 27 ?? ?? ?? 0? ?? ?? 12 3C ?? ?? 46 8E ?? ?? 47 8E 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 21 20 60 02 21 80 40 00 ?? ?? ?? 0? 21 88 60 00 ?? ?? 46 8E ?? ?? 47 8E 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 30 40 00 21 20 00 02 21 28 20 02 ?? ?? ?? 0? 21 38 60 00 21 80 40 00 ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 21 28 60 00 ?? ?? ?? 0? 21 88 60 00 06 00 40 18 ?? ?? 02 3C ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 ?? ?? ?? 0? 00 00 83 AC ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 1F 00 40 04 ?? ?? 02 3C 21 20 00 02 21 28 20 02 21 30 00 00 ?? ?? ?? 0? 21 38 00 00 24 00 40 04 ?? ?? 02 3C ?? ?? 52 8C ?? ?? 53 8C ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 21 20 40 00 21 30 40 02 21 38 60 02 ?? ?? ?? 0? 21 28 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 14 00 BF 8F 10 00 B3 8F 0C 00 B2 8F 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 18 00 BD 27 ?? ?? 44 8C 22 00 03 24 00 00 83 AC 14 00 BF 8F 00 80 02 3C 01 00 42 34 10 00 B3 8F 0C 00 B2 8F 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 18 00 BD 27 ?? ?? 02 3C ?? ?? 52 8C ?? ?? ?? 0? ?? ?? 53 8C }
	condition:
		$1
}

rule file_37_109_0 {
	meta:
		name = "fixfloor"
		size = 28
	strings:
		$1 = { 03 00 82 04 27 10 04 00 08 00 E0 03 03 14 04 00 03 14 02 00 08 00 E0 03 27 10 02 00 }
	condition:
		$1
}

rule file_37_110_0 {
	meta:
		name = "fixceil"
		size = 84
		refs = "0010 allegro_errno 004c .text"
	strings:
		$1 = { FF 7F 02 3C 01 00 42 34 2A 10 82 00 07 00 40 14 ?? ?? 02 3C ?? ?? 43 8C 22 00 02 24 FF 7F 04 24 00 00 62 AC 08 00 E0 03 21 10 80 00 FF FF 02 34 21 10 82 00 04 00 42 04 27 10 02 00 03 24 02 00 08 00 E0 03 21 10 80 00 03 14 02 00 ?? ?? ?? 0? 27 20 02 00 }
	condition:
		$1
}

rule file_37_112_0 {
	meta:
		name = "fixtoi"
		size = 44
	strings:
		$1 = { 04 00 80 04 03 1C 04 00 C0 03 82 7C 08 00 E0 03 21 10 62 00 27 10 04 00 03 14 02 00 27 18 02 00 C0 03 82 7C 08 00 E0 03 21 10 62 00 }
	condition:
		$1
}

rule file_37_113_0 {
	meta:
		name = "fixcos"
		size = 32
		refs = "0008 _cos_tbl"
	strings:
		$1 = { 00 40 84 24 C0 43 84 7C ?? ?? 02 3C ?? ?? 42 24 80 20 04 00 21 20 82 00 08 00 E0 03 00 00 82 8C }
	condition:
		$1
}

rule file_37_114_0 {
	meta:
		name = "fixsin"
		size = 40
		refs = "0010 _cos_tbl"
	strings:
		$1 = { C0 FF 02 3C 00 40 42 34 21 20 82 00 C0 43 84 7C ?? ?? 02 3C ?? ?? 42 24 80 20 04 00 21 20 82 00 08 00 E0 03 00 00 82 8C }
	condition:
		$1
}

rule file_37_115_0 {
	meta:
		name = "fixtan"
		size = 32
		refs = "0008 _tan_tbl"
	strings:
		$1 = { 00 40 84 24 C0 3B 84 7C ?? ?? 02 3C ?? ?? 42 24 80 20 04 00 21 20 82 00 08 00 E0 03 00 00 82 8C }
	condition:
		$1
}

rule file_37_116_0 {
	meta:
		name = "fixacos"
		size = 92
		refs = "0018 _acos_tbl 0040 allegro_errno"
	strings:
		$1 = { 01 00 05 3C 02 00 02 3C 21 18 85 00 01 00 42 34 2B 18 62 00 0A 00 60 10 ?? ?? 03 3C 7F 00 A2 34 21 10 82 00 03 12 02 00 ?? ?? 63 24 80 10 02 00 21 10 43 00 00 00 44 8C 08 00 E0 03 21 10 80 00 ?? ?? 02 3C ?? ?? 43 8C 21 20 00 00 21 00 02 24 00 00 62 AC 08 00 E0 03 21 10 80 00 }
	condition:
		$1
}

rule file_37_117_0 {
	meta:
		name = "fixasin"
		size = 100
		refs = "0018 _acos_tbl 0048 allegro_errno"
	strings:
		$1 = { 01 00 05 3C 02 00 02 3C 21 18 85 00 01 00 42 34 2B 18 62 00 0C 00 60 10 ?? ?? 03 3C 7F 00 A2 34 21 10 82 00 03 12 02 00 ?? ?? 63 24 80 10 02 00 21 10 43 00 00 00 44 8C 40 00 03 3C 23 20 64 00 08 00 E0 03 21 10 80 00 ?? ?? 02 3C ?? ?? 43 8C 21 20 00 00 21 00 02 24 00 00 62 AC 08 00 E0 03 21 10 80 00 }
	condition:
		$1
}

rule file_37_118_0 {
	meta:
		name = "apply_matrix"
		size = 2108
		refs = "0838 allegro_errno 0114 .text"
	strings:
		$1 = { 00 00 82 8C F0 FF BD 27 0C 00 B0 AF C3 87 05 00 18 00 02 02 C3 1F 02 00 21 58 80 00 1C 00 65 00 12 20 00 00 19 00 A2 00 00 80 02 34 10 68 00 00 21 68 8D 00 2A 10 A2 01 3C 00 40 10 12 60 00 00 FF 7F 02 24 35 00 A2 11 FF FF 02 3C 00 80 A2 29 A3 01 40 10 00 80 02 24 ?? ?? 02 3C ?? ?? 43 8C 22 00 02 24 C3 CF 06 00 00 00 62 AC 04 00 63 8D 00 80 0F 3C 18 00 23 03 C3 17 03 00 1C 00 46 00 00 80 02 34 12 20 00 00 19 00 C3 00 10 68 00 00 21 68 8D 00 2A 10 A2 01 37 00 40 14 12 60 00 00 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 4E 34 08 00 63 8D C3 C7 07 00 18 00 03 03 C3 17 03 00 1C 00 47 00 00 80 02 34 12 20 00 00 19 00 E3 00 10 68 00 00 21 68 8D 00 2A 10 A2 01 3C 00 40 10 12 60 00 00 FF 7F 02 24 81 01 A2 11 FF FF 02 3C 00 80 A2 29 6C 01 40 10 00 80 02 24 ?? ?? 02 3C ?? ?? 43 8C 22 00 02 24 00 80 04 3C ?? ?? ?? 0? 00 00 62 AC 01 00 42 34 2B 10 82 01 CA FF 40 14 00 80 A2 29 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 4F 34 04 00 63 8D C3 CF 06 00 18 00 23 03 C3 17 03 00 1C 00 46 00 00 80 02 34 12 20 00 00 19 00 C3 00 10 68 00 00 21 68 8D 00 2A 10 A2 01 CB FF 40 10 12 60 00 00 FF 7F 02 24 7C 01 A2 11 FF FF 02 3C 00 80 A2 29 4F 01 40 10 00 80 02 24 ?? ?? 02 3C ?? ?? 43 8C 22 00 02 24 C3 C7 07 00 00 00 62 AC 08 00 63 8D 00 80 0E 3C 18 00 03 03 C3 17 03 00 1C 00 47 00 00 80 02 34 12 20 00 00 19 00 E3 00 10 68 00 00 21 68 8D 00 2A 10 A2 01 C6 FF 40 14 12 60 00 00 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 44 34 24 00 62 8D 21 10 E2 01 21 10 4E 00 21 10 44 00 00 00 02 AD 0C 00 63 8D 18 00 03 02 C3 17 03 00 1C 00 45 00 00 80 02 34 12 20 00 00 19 00 A3 00 10 68 00 00 21 68 8D 00 2A 10 A2 01 3A 00 40 10 12 60 00 00 FF 7F 02 24 33 00 A2 11 FF FF 02 3C 00 80 A2 29 14 01 40 10 00 80 02 24 ?? ?? 02 3C ?? ?? 43 8C 22 00 02 24 00 80 0E 3C 00 00 62 AC 10 00 62 8D 18 00 22 03 C3 1F 02 00 1C 00 66 00 12 20 00 00 19 00 C2 00 00 80 02 34 10 68 00 00 21 68 8D 00 2A 10 A2 01 35 00 40 14 12 60 00 00 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 48 34 14 00 62 8D 18 00 02 03 C3 1F 02 00 1C 00 67 00 12 20 00 00 19 00 E2 00 00 80 02 34 10 68 00 00 21 68 8D 00 2A 10 A2 01 3A 00 40 10 12 60 00 00 FF 7F 02 24 18 01 A2 11 FF FF 02 3C 00 80 A2 29 D9 00 40 10 00 80 02 24 ?? ?? 02 3C ?? ?? 43 8C 22 00 02 24 00 80 04 3C ?? ?? ?? 0? 00 00 62 AC 01 00 42 34 2B 10 82 01 CC FF 40 14 00 80 A2 29 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 4E 34 10 00 62 8D 18 00 22 03 C3 1F 02 00 1C 00 66 00 12 20 00 00 19 00 C2 00 00 80 02 34 10 68 00 00 21 68 8D 00 2A 10 A2 01 CD FF 40 10 12 60 00 00 FF 7F 02 24 F0 00 A2 11 FF FF 02 3C 00 80 A2 29 C3 00 40 10 00 80 02 24 ?? ?? 02 3C ?? ?? 43 8C 22 00 02 24 00 80 08 3C 00 00 62 AC 14 00 62 8D 18 00 02 03 C3 1F 02 00 1C 00 67 00 12 20 00 00 19 00 E2 00 00 80 02 34 10 68 00 00 21 68 8D 00 2A 10 A2 01 C8 FF 40 14 12 60 00 00 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 44 34 28 00 62 8D 21 10 C2 01 21 10 48 00 21 10 44 00 00 00 22 AD 18 00 63 8D 18 00 03 02 C3 17 03 00 1C 00 45 00 12 20 00 00 00 00 A4 AF 00 00 A2 8F 19 00 A3 00 10 28 00 00 21 28 45 00 00 80 02 34 2A 10 A2 00 42 00 40 10 12 20 00 00 FF 7F 02 24 3B 00 A2 10 FF FF 02 3C 00 80 A2 28 8D 00 40 10 00 80 02 24 ?? ?? 02 3C ?? ?? 43 8C 22 00 02 24 00 80 0C 3C 00 00 62 AC 1C 00 62 8D 18 00 22 03 C3 1F 02 00 1C 00 66 00 12 20 00 00 19 00 C2 00 00 80 02 34 10 48 00 00 21 48 89 00 2A 10 22 01 3D 00 40 14 12 40 00 00 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 45 34 20 00 62 8D 18 00 02 03 C3 1F 02 00 1C 00 67 00 12 20 00 00 00 00 A4 AF 19 00 E2 00 00 80 02 34 10 48 00 00 21 48 89 00 2A 10 22 01 42 00 40 10 12 40 00 00 FF 7F 02 24 A2 00 22 11 FF FF 02 3C 00 80 22 29 4A 00 40 10 00 80 02 24 ?? ?? 02 3C ?? ?? 43 8C 22 00 02 24 00 80 04 3C 00 00 62 AC 2C 00 62 8D 0C 00 B0 8F 10 00 BD 27 21 10 82 01 21 10 45 00 21 10 44 00 08 00 E0 03 00 00 42 AD 01 00 42 34 2B 10 82 00 C4 FF 40 14 00 80 A2 28 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 4C 34 1C 00 62 8D 18 00 22 03 C3 1F 02 00 1C 00 66 00 12 20 00 00 19 00 C2 00 00 80 02 34 10 48 00 00 21 48 89 00 2A 10 22 01 C5 FF 40 10 12 40 00 00 FF 7F 02 24 67 00 22 11 FF FF 02 3C 00 80 22 29 2E 00 40 10 00 80 02 24 ?? ?? 02 3C ?? ?? 43 8C 22 00 02 24 00 80 05 3C 00 00 62 AC 20 00 62 8D 18 00 02 03 C3 1F 02 00 1C 00 67 00 12 20 00 00 00 00 A4 AF 19 00 E2 00 00 80 02 34 10 48 00 00 21 48 89 00 2A 10 22 01 C0 FF 40 14 12 40 00 00 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 44 34 2C 00 62 8D 0C 00 B0 8F 10 00 BD 27 21 10 82 01 21 10 45 00 21 10 44 00 08 00 E0 03 00 00 42 AD 60 00 22 11 01 00 02 3C 00 14 09 00 02 1C 08 00 25 20 43 00 2C 00 62 8D 0C 00 B0 8F 10 00 BD 27 21 10 82 01 21 10 45 00 21 10 44 00 08 00 E0 03 00 00 42 AD 5D 00 22 11 01 00 02 3C 02 1C 08 00 00 14 09 00 ?? ?? ?? 0? 25 28 43 00 61 00 A2 11 01 00 02 3C 02 1C 0C 00 00 14 0D 00 ?? ?? ?? 0? 25 20 43 00 56 00 A2 10 01 00 02 3C 02 1C 04 00 00 14 05 00 ?? ?? ?? 0? 25 60 43 00 69 00 A2 11 01 00 02 3C 02 1C 0C 00 00 14 0D 00 ?? ?? ?? 0? 25 40 43 00 5E 00 A2 11 01 00 02 3C 02 1C 0C 00 00 14 0D 00 ?? ?? ?? 0? 25 70 43 00 53 00 A2 11 01 00 02 3C 02 1C 0C 00 00 14 0D 00 ?? ?? ?? 0? 25 20 43 00 48 00 A2 11 01 00 02 3C 02 1C 0C 00 00 14 0D 00 ?? ?? ?? 0? 25 70 43 00 2E 00 A2 11 01 00 02 3C 02 1C 0C 00 00 14 0D 00 ?? ?? ?? 0? 25 78 43 00 01 00 42 34 2B 10 82 01 7E FE 40 54 00 80 A2 29 ?? ?? ?? 0? ?? ?? 02 3C 01 00 42 34 2B 10 02 01 98 FF 40 54 00 80 22 29 ?? ?? ?? 0? ?? ?? 02 3C 01 00 42 34 2B 10 82 01 0F FF 40 54 00 80 A2 29 ?? ?? ?? 0? ?? ?? 02 3C 01 00 42 34 2B 10 82 01 E7 FE 40 54 00 80 A2 29 ?? ?? ?? 0? ?? ?? 02 3C 01 00 42 34 2B 10 02 01 5D FF 40 54 00 80 22 29 ?? ?? ?? 0? ?? ?? 02 3C 01 00 42 34 2B 10 82 01 83 FE 40 54 00 80 A2 29 ?? ?? ?? 0? ?? ?? 02 3C 2B 10 02 01 A0 FF 40 50 00 14 09 00 ?? ?? ?? 0? ?? ?? 02 3C 2B 10 82 01 D2 FF 40 10 02 1C 0C 00 ?? ?? ?? 0? ?? ?? 02 3C 2B 10 02 01 A3 FF 40 10 02 1C 08 00 ?? ?? ?? 0? ?? ?? 02 3C 2B 10 82 00 AA FF 40 10 02 1C 04 00 ?? ?? ?? 0? ?? ?? 02 3C 2B 10 82 01 9F FF 40 10 02 1C 0C 00 ?? ?? ?? 0? ?? ?? 02 3C 2B 10 82 01 B8 FF 40 10 02 1C 0C 00 ?? ?? ?? 0? ?? ?? 02 3C 2B 10 82 01 AD FF 40 10 02 1C 0C 00 ?? ?? ?? 0? ?? ?? 02 3C 2B 10 82 01 A2 FF 40 10 02 1C 0C 00 ?? ?? ?? 0? ?? ?? 02 3C 2B 10 82 01 97 FF 40 10 02 1C 0C 00 ?? ?? ?? 0? ?? ?? 02 3C }
	condition:
		$1
}

rule file_37_119_0 {
	meta:
		name = "dot_product"
		size = 552
		refs = "01fc allegro_errno 019c .text"
	strings:
		$1 = { 18 00 E4 00 00 80 02 34 10 58 00 00 2A 10 62 01 30 00 40 10 12 50 00 00 FF 7F 02 24 29 00 62 11 FF FF 02 3C 00 80 62 29 5E 00 40 10 00 80 02 24 18 00 05 01 ?? ?? 02 3C ?? ?? 43 8C 22 00 02 24 00 80 0A 3C 00 00 62 AC 00 80 02 34 10 28 00 00 2A 10 A2 00 2B 00 40 14 12 20 00 00 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 45 34 18 00 26 01 00 80 02 34 10 38 00 00 2A 10 E2 00 30 00 40 10 12 30 00 00 FF 7F 02 24 4A 00 E2 10 FF FF 02 3C 00 80 E2 28 33 00 40 50 00 80 02 24 ?? ?? 02 3C ?? ?? 43 8C 22 00 02 24 00 80 06 3C 00 00 62 AC 21 10 AA 00 08 00 E0 03 21 10 46 00 01 00 42 34 2B 10 42 01 D6 FF 40 14 00 80 62 29 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 4A 34 18 00 05 01 00 80 02 34 10 28 00 00 2A 10 A2 00 D7 FF 40 10 12 20 00 00 FF 7F 02 24 32 00 A2 10 FF FF 02 3C 00 80 A2 28 1D 00 40 10 00 80 02 24 18 00 26 01 ?? ?? 02 3C ?? ?? 43 8C 22 00 02 24 00 80 05 3C 00 00 62 AC 00 80 02 34 10 38 00 00 2A 10 E2 00 D2 FF 40 14 12 30 00 00 ?? ?? 02 3C ?? ?? 44 8C FF 7F 02 3C FF FF 46 34 22 00 03 24 21 10 AA 00 00 00 83 AC 08 00 E0 03 21 10 46 00 1F 00 E2 50 01 00 02 3C 00 14 07 00 02 1C 06 00 25 30 43 00 21 10 AA 00 08 00 E0 03 21 10 46 00 21 00 A2 10 01 00 02 3C 02 1C 04 00 00 14 05 00 ?? ?? ?? 0? 25 28 43 00 16 00 62 11 01 00 02 3C 02 1C 0A 00 00 14 0B 00 ?? ?? ?? 0? 25 50 43 00 01 00 42 34 2B 10 C2 00 B5 FF 40 54 00 80 E2 28 ?? ?? ?? 0? ?? ?? 02 3C 01 00 42 34 2B 10 82 00 CD FF 40 54 00 80 A2 28 ?? ?? ?? 0? ?? ?? 02 3C 2B 10 C2 00 E1 FF 40 50 00 14 07 00 ?? ?? ?? 0? ?? ?? 02 3C 2B 10 42 01 EA FF 40 10 02 1C 0A 00 ?? ?? ?? 0? 18 00 05 01 2B 10 82 00 DF FF 40 10 02 1C 04 00 ?? ?? ?? 0? 18 00 26 01 }
	condition:
		$1
}

rule file_37_120_0 {
	meta:
		name = "dot_product_f"
		size = 24
	strings:
		$1 = { 02 60 0F 46 42 6B 10 46 82 73 11 46 00 00 0D 46 08 00 E0 03 00 00 0E 46 }
	condition:
		$1
}

rule file_37_121_0 {
	meta:
		name = "persp_project"
		size = 528
		refs = "01f8 allegro_errno 0028 fixdiv 0030 _persp_xscale 0078 .text 00a8 _persp_xoffset 00c4 _persp_yscale 0110 _persp_yoffset"
	strings:
		$1 = { E8 FF BD 27 08 00 B1 AF 21 88 A0 00 21 28 C0 00 10 00 B3 AF 0C 00 B2 AF 04 00 B0 AF 14 00 BF AF 21 80 C0 00 21 90 E0 00 ?? ?? ?? 0? 21 98 00 01 ?? ?? 03 3C ?? ?? 64 8C 18 00 44 00 00 80 02 34 10 28 00 00 2A 10 A2 00 11 00 40 10 12 20 00 00 FF 7F 02 24 0A 00 A2 10 FF FF 02 3C 00 80 A2 28 46 00 40 10 00 80 02 24 ?? ?? 02 3C ?? ?? 43 8C 22 00 02 24 00 80 06 3C ?? ?? ?? 0? 00 00 62 AC 01 00 42 34 2B 10 82 00 F5 FF 40 14 00 80 A2 28 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 46 34 ?? ?? 02 3C ?? ?? 43 8C 21 20 20 02 21 28 00 02 21 18 C3 00 ?? ?? ?? 0? 00 00 43 AE ?? ?? 03 3C ?? ?? 64 8C 18 00 44 00 00 80 02 34 10 28 00 00 2A 10 A2 00 31 00 40 10 12 20 00 00 FF 7F 02 24 2A 00 A2 10 FF FF 02 3C 00 80 A2 28 11 00 40 10 00 80 02 24 ?? ?? 02 3C ?? ?? 43 8C 22 00 02 24 14 00 BF 8F 00 00 62 AC ?? ?? 03 3C ?? ?? 62 8C 00 80 04 3C 0C 00 B2 8F 21 10 82 00 00 00 62 AE 08 00 B1 8F 10 00 B3 8F 04 00 B0 8F 08 00 E0 03 18 00 BD 27 2A 00 A2 10 01 00 02 3C 02 1C 04 00 00 14 05 00 25 20 43 00 ?? ?? 03 3C ?? ?? 62 8C 14 00 BF 8F 0C 00 B2 8F 21 10 82 00 00 00 62 AE 08 00 B1 8F 10 00 B3 8F 04 00 B0 8F 08 00 E0 03 18 00 BD 27 1F 00 A2 10 01 00 02 3C 02 1C 04 00 00 14 05 00 ?? ?? ?? 0? 25 30 43 00 01 00 42 34 2B 10 82 00 D5 FF 40 14 00 80 A2 28 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC ?? ?? 03 3C FF FF 44 34 ?? ?? 62 8C 14 00 BF 8F 0C 00 B2 8F 21 10 82 00 00 00 62 AE 08 00 B1 8F 10 00 B3 8F 04 00 B0 8F 08 00 E0 03 18 00 BD 27 2B 10 82 00 D6 FF 40 10 02 1C 04 00 ?? ?? ?? 0? ?? ?? 02 3C 2B 10 82 00 E1 FF 40 10 02 1C 04 00 ?? ?? ?? 0? ?? ?? 02 3C }
	condition:
		$1
}

rule file_37_122_0 {
	meta:
		name = "persp_project_f"
		size = 80
		refs = "0000 $LC6 0008 _persp_xscale_f 0014 _persp_xoffset_f 001c _persp_yscale_f 0020 _persp_yoffset_f"
	strings:
		$1 = { ?? ?? 03 3C ?? ?? 60 C4 ?? ?? 02 3C ?? ?? 42 C4 03 00 0E 46 ?? ?? 02 3C ?? ?? 41 C4 ?? ?? 02 3C ?? ?? 03 3C 02 63 00 46 42 6B 00 46 02 63 02 46 00 63 01 46 00 00 8C E4 ?? ?? 41 C4 ?? ?? 60 C4 42 6B 01 46 40 6B 00 46 08 00 E0 03 00 00 AD E4 }
	condition:
		$1
}

rule file_37_123_0 {
	meta:
		name = "draw_character"
		size = 20
		refs = "0004 _textmode"
	strings:
		$1 = { 1C 00 82 8C ?? ?? 03 3C 74 00 59 8C 08 00 20 03 ?? ?? 69 8C }
	condition:
		$1
}

rule file_37_125_0 {
	meta:
		name = "yield_timeslice"
		size = 36
		refs = "0000 system_driver"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 43 8C 6C 00 79 8C 03 00 20 13 00 00 00 00 08 00 20 03 00 00 00 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_37_126_0 {
	meta:
		name = "_grow_scratch_mem"
		size = 96
		refs = "0008 _scratch_mem_size 0024 _scratch_mem 0038 _al_realloc"
	strings:
		$1 = { F0 FF BD 27 08 00 B2 AF ?? ?? 12 3C ?? ?? 42 8E 0C 00 BF AF 04 00 B1 AF 2A 10 44 00 0A 00 40 10 00 00 B0 AF ?? ?? 11 3C FF 03 90 24 00 FC 02 24 ?? ?? 24 8E 24 80 02 02 ?? ?? ?? 0? 21 28 00 02 ?? ?? 22 AE ?? ?? 50 AE 0C 00 BF 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 10 00 BD 27 }
	condition:
		$1
}

rule file_37_130_0 {
	meta:
		name = "gui_textout"
		size = 16
		refs = "0008 gui_textout_ex 0000 _textmode"
	strings:
		$1 = { ?? ?? 02 3C 21 50 20 01 ?? ?? ?? 0? ?? ?? 49 8C }
	condition:
		$1
}

rule file_37_131_0 {
	meta:
		name = "textout_justify"
		size = 36
		refs = "0000 _textmode 0010 textout_justify_ex"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 43 8C F0 FF BD 27 0C 00 BF AF ?? ?? ?? 0? 00 00 A3 AF 0C 00 BF 8F 08 00 E0 03 10 00 BD 27 }
	condition:
		$1
}

rule file_37_135_0 {
	meta:
		name = "file_select"
		size = 16
		refs = "0008 file_select_ex"
	strings:
		$1 = { 00 04 07 24 FF FF 08 24 ?? ?? ?? 0? FF FF 09 24 }
	condition:
		$1
}

rule file_38_0_0 {
	meta:
		name = "_linear_clear_to_color32"
		size = 188
		refs = "0088 .text"
	strings:
		$1 = { E8 FF BD 27 10 00 B4 AF 18 00 82 8C 14 00 94 8C 0C 00 B3 AF 08 00 B2 AF 2A 10 82 02 04 00 B1 AF 14 00 BF AF 00 00 B0 AF 21 88 80 00 21 90 A0 00 10 00 83 8C 16 00 40 10 0C 00 93 8C 23 80 73 00 20 00 23 8E 21 20 20 02 09 F8 60 00 21 28 80 02 08 00 00 1A 21 18 40 00 80 10 13 00 21 10 43 00 21 18 00 00 01 00 63 24 00 00 52 AC FD FF 70 14 04 00 42 24 18 00 22 8E 01 00 94 26 2A 10 82 02 04 00 40 50 1C 00 22 8E ?? ?? ?? 0? 0C 00 33 8E 1C 00 22 8E 21 20 20 02 14 00 BF 8F 08 00 59 8C 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 20 03 18 00 BD 27 }
	condition:
		$1
}

rule file_38_2_0 {
	meta:
		name = "_linear_masked_blit32"
		size = 276
	strings:
		$1 = { 1C 00 A2 8C D0 FF BD 27 28 00 BE AF 1C 00 B5 AF 18 00 B4 AF 10 00 B2 AF 0C 00 B1 AF 2C 00 BF AF 24 00 B7 AF 20 00 B6 AF 14 00 B3 AF 08 00 B0 AF 21 A8 A0 00 04 00 AB AF 21 A0 80 00 00 00 A7 AF 21 F0 20 01 21 88 40 01 1F 00 60 19 04 00 52 8C 80 B8 06 00 80 B0 08 00 21 80 00 00 00 00 A2 8F 24 00 83 8E 21 20 80 02 09 F8 60 00 21 28 02 02 20 00 A3 8E 21 20 A0 02 21 28 1E 02 09 F8 60 00 21 98 40 00 0B 00 20 1A 21 18 40 00 21 28 76 00 21 10 77 02 21 18 00 00 00 00 44 8C 01 00 63 24 02 00 92 10 04 00 42 24 00 00 A4 AC FA FF 71 14 04 00 A5 24 04 00 A3 8F 01 00 10 26 2A 10 03 02 E7 FF 40 14 00 00 A2 8F 1C 00 83 8E 08 00 62 8C 09 F8 40 00 21 20 80 02 1C 00 A3 8E 21 20 A0 02 2C 00 BF 8F 08 00 79 8C 28 00 BE 8F 24 00 B7 8F 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 20 03 30 00 BD 27 }
	condition:
		$1
}

rule file_38_3_0 {
	meta:
		name = "_linear_blit_backward32"
		size = 232
		refs = "0088 memmove"
	strings:
		$1 = { D8 FF BD 27 0C 00 B3 AF FF FF 73 25 14 00 B5 AF 10 00 B4 AF 24 00 BF AF 20 00 BE AF 1C 00 B7 AF 18 00 B6 AF 08 00 B2 AF 04 00 B1 AF 00 00 B0 AF 21 A0 80 00 19 00 60 06 21 A8 A0 00 FF FF E3 24 FF FF 22 25 21 90 4B 00 80 F0 06 00 80 B8 08 00 80 B0 0A 00 21 88 6B 00 24 00 83 8E 21 28 20 02 09 F8 60 00 21 20 80 02 20 00 A3 8E 21 28 40 02 21 20 A0 02 09 F8 60 00 21 80 40 00 21 20 57 00 21 28 1E 02 21 30 C0 02 ?? ?? ?? 0? FF FF 73 26 FF FF 31 26 F0 FF 61 06 FF FF 52 26 1C 00 83 8E 08 00 62 8C 09 F8 40 00 21 20 80 02 1C 00 A3 8E 21 20 A0 02 24 00 BF 8F 08 00 79 8C 20 00 BE 8F 1C 00 B7 8F 18 00 B6 8F 14 00 B5 8F 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 20 03 28 00 BD 27 }
	condition:
		$1
}

rule file_38_4_0 {
	meta:
		name = "_linear_blit32"
		size = 232
		refs = "0080 memmove"
	strings:
		$1 = { D0 FF BD 27 28 00 BE AF 24 00 B7 AF 14 00 B3 AF 10 00 B2 AF 2C 00 BF AF 20 00 B6 AF 1C 00 B5 AF 18 00 B4 AF 0C 00 B1 AF 08 00 B0 AF 00 00 AB AF 21 90 80 00 21 98 A0 00 21 F0 E0 00 17 00 60 19 21 B8 20 01 80 B0 06 00 80 A8 08 00 80 A0 0A 00 21 88 00 00 24 00 43 8E 21 28 3E 02 09 F8 60 00 21 20 40 02 20 00 63 8E 21 28 37 02 21 20 60 02 09 F8 60 00 21 80 40 00 21 20 55 00 21 28 16 02 ?? ?? ?? 0? 21 30 80 02 00 00 A2 8F 01 00 31 26 2A 18 22 02 F0 FF 60 54 24 00 43 8E 1C 00 43 8E 08 00 62 8C 09 F8 40 00 21 20 40 02 1C 00 63 8E 21 20 60 02 2C 00 BF 8F 08 00 79 8C 28 00 BE 8F 24 00 B7 8F 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 20 03 30 00 BD 27 }
	condition:
		$1
}

rule file_39_1_0 {
	meta:
		name = "_poly_zbuf_grgb15"
		size = 184
		refs = "0030 _rgb_r_shift_15 0038 _rgb_g_shift_15 003c _rgb_b_shift_15 004c .text"
	strings:
		$1 = { F8 FF BD 27 04 00 B0 AF 21 80 A0 00 18 00 CC 8C 1C 00 CB 8C 20 00 CA 8C 24 00 C5 8C 28 00 D9 8C 2C 00 D8 8C 30 00 C1 C4 20 00 00 1A 5C 00 C7 8C ?? ?? 02 3C ?? ?? 4F 8C ?? ?? 03 3C ?? ?? 02 3C ?? ?? 6E 8C ?? ?? 4D 8C 21 48 80 00 ?? ?? ?? 0? 21 40 00 00 40 08 00 46 00 00 E0 C4 C3 24 0B 00 C3 1C 0C 00 3C 00 01 46 C3 14 0A 00 04 20 C4 01 04 18 E3 01 25 20 83 00 04 10 A2 01 25 20 82 00 01 00 08 25 21 60 85 01 21 58 79 01 03 00 00 45 21 50 58 01 00 00 24 A5 00 00 E1 E4 04 00 E7 24 02 00 29 25 EB FF 10 15 34 00 C0 C4 04 00 B0 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_39_3_0 {
	meta:
		name = "_poly_zbuf_atex_mask15"
		size = 176
		refs = "0044 .text"
	strings:
		$1 = { 21 58 C0 00 54 00 C2 8C 50 00 C6 8C 10 00 03 24 23 C0 62 00 04 30 46 00 4C 00 6F 8D 00 00 6A 8D 04 00 69 8D 08 00 6E 8D 0C 00 6D 8D 48 00 6C 8D 30 00 61 C5 1C 00 A0 18 5C 00 62 8D 21 38 40 00 21 40 00 00 ?? ?? ?? 0? 1F 7C 19 24 40 08 00 46 00 00 E0 C4 03 14 0A 00 07 18 09 03 24 10 4F 00 24 18 66 00 3C 00 01 46 21 10 43 00 40 10 02 00 21 10 82 01 01 00 08 25 21 50 4E 01 06 00 00 45 21 48 2D 01 00 00 42 94 04 00 59 50 04 00 E7 24 00 00 82 A4 00 00 E1 E4 04 00 E7 24 02 00 84 24 EA FF 05 15 34 00 60 C5 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_39_5_0 {
	meta:
		name = "_poly_zbuf_atex_mask_lit15"
		size = 368
		refs = "0010 _blender_func15 008c .text 00e0 _blender_col_15"
	strings:
		$1 = { 54 00 C3 8C 10 00 02 24 B0 FF BD 27 23 60 43 00 ?? ?? 02 3C ?? ?? 42 8C 34 00 B5 AF 21 A8 C0 00 50 00 C6 8C 40 00 BE AF 3C 00 B7 AF 38 00 B6 AF 2C 00 B3 AF 28 00 B2 AF 4C 00 B4 E7 00 00 A2 AF 44 00 BF AF 30 00 B4 AF 24 00 B1 AF 20 00 B0 AF 21 58 A0 00 04 50 66 00 4C 00 A9 8E 00 00 B3 8E 04 00 B2 8E 10 00 B6 8E 08 00 A8 8E 0C 00 A7 8E 14 00 BE 8E 48 00 B7 8E 30 00 B4 C6 2F 00 A0 18 5C 00 A2 8E 21 A0 80 00 21 80 40 00 ?? ?? ?? 0? 21 88 00 00 00 A5 00 46 00 00 00 C6 03 14 13 00 07 18 92 01 24 10 49 00 24 18 6A 00 3C 00 14 46 21 10 43 00 40 10 02 00 21 10 E2 02 01 00 31 26 21 98 68 02 18 00 00 45 21 90 47 02 00 00 42 94 1F 7C 03 24 03 34 16 00 13 00 43 10 21 20 40 00 ?? ?? 02 3C ?? ?? 45 8C 00 00 A3 8F 04 00 A7 AF 08 00 A8 AF 0C 00 A9 AF 10 00 AA AF 14 00 AB AF 09 F8 60 00 18 00 AC AF 18 00 AC 8F 14 00 AB 8F 10 00 AA 8F 0C 00 A9 8F 08 00 A8 8F 04 00 A7 8F 00 00 82 A6 00 00 14 E6 21 B0 DE 02 04 00 10 26 02 00 94 26 D7 FF 2B 16 34 00 A0 C6 44 00 BF 8F 40 00 BE 8F 3C 00 B7 8F 38 00 B6 8F 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 4C 00 B4 C7 08 00 E0 03 50 00 BD 27 }
	condition:
		$1
}

rule file_39_7_0 {
	meta:
		name = "_poly_zbuf_ptex_mask15"
		size = 600
		refs = "0060 __extendsfdf2 00ec .text 00f4 __adddf3 0154 __ltdf2 0170 __divdf3 017c __fixdfsi 01e8 __truncdfsf2"
	strings:
		$1 = { 98 FF BD 27 54 00 C3 8C 40 00 CC C4 30 00 B0 AF 21 80 C0 00 50 00 C6 8C 10 00 02 24 23 10 43 00 04 30 66 00 54 00 BF AF 2C 00 A5 AF 28 00 A6 AF 38 00 B2 AF 34 00 B1 AF 21 90 80 00 64 00 B6 E7 60 00 B5 E7 5C 00 B4 E7 50 00 BE AF 4C 00 B7 AF 48 00 B6 AF 44 00 B5 AF 40 00 B4 AF 3C 00 B3 AF ?? ?? ?? 0? 24 00 A2 AF 18 00 A2 AF 44 00 0C C6 4C 00 02 8E 1C 00 A3 AF 38 00 15 C6 ?? ?? ?? 0? 20 00 A2 AF 34 00 0C C6 10 00 A2 AF ?? ?? ?? 0? 14 00 A3 AF 3C 00 14 C6 30 00 16 C6 0C 00 A3 AF 5C 00 11 8E 2C 00 A3 8F 48 00 10 8E 08 00 A2 AF 5A 00 60 18 04 00 B0 AF 06 AB 00 46 ?? ?? ?? 0? 00 00 B2 AF 06 A3 00 46 21 A0 40 00 ?? ?? ?? 0? 21 A8 60 00 06 B3 00 46 21 B0 40 00 ?? ?? ?? 0? 21 B8 60 00 21 F0 00 00 21 90 40 00 ?? ?? ?? 0? 21 98 60 00 ?? ?? ?? 0? 00 00 00 00 10 00 A6 8F 14 00 A7 8F 21 20 C0 02 21 28 E0 02 21 A0 40 00 ?? ?? ?? 0? 21 A8 60 00 08 00 A6 8F 0C 00 A7 8F 21 20 40 02 21 28 60 02 21 B0 40 00 ?? ?? ?? 0? 21 B8 60 00 21 90 40 00 21 98 60 00 00 00 2C C6 ?? ?? ?? 0? 01 00 DE 27 21 20 40 00 21 28 60 00 21 30 40 02 ?? ?? ?? 0? 21 38 60 02 21 30 40 02 21 38 60 02 21 20 80 02 22 00 41 04 21 28 A0 02 ?? ?? ?? 0? 00 00 00 00 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 03 84 02 00 20 00 A2 8F 21 30 40 02 21 38 60 02 21 20 C0 02 21 28 E0 02 ?? ?? ?? 0? 24 80 02 02 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 24 00 A3 8F 21 20 40 02 07 10 62 00 28 00 A3 8F 24 10 43 00 21 80 02 02 04 00 A2 8F 40 80 10 00 1F 7C 03 24 21 80 50 00 00 00 02 96 05 00 43 10 21 28 60 02 00 00 A3 8F ?? ?? ?? 0? 00 00 62 A4 00 00 20 E6 00 00 A2 8F 2C 00 A3 8F 21 20 80 02 02 00 42 24 21 28 A0 02 18 00 A6 8F 1C 00 A7 8F 04 00 31 26 B7 FF C3 17 00 00 A2 AF 54 00 BF 8F 50 00 BE 8F 4C 00 B7 8F 48 00 B6 8F 44 00 B5 8F 40 00 B4 8F 3C 00 B3 8F 38 00 B2 8F 34 00 B1 8F 30 00 B0 8F 64 00 B6 C7 60 00 B5 C7 5C 00 B4 C7 08 00 E0 03 68 00 BD 27 }
	condition:
		$1
}

rule file_39_9_0 {
	meta:
		name = "_poly_zbuf_ptex_mask_lit15"
		size = 672
		refs = "0060 __extendsfdf2 00a8 _blender_func15 0108 .text 0110 __adddf3 0170 __ltdf2 018c __divdf3 0198 __fixdfsi 0204 _blender_col_15 0220 __truncdfsf2"
	strings:
		$1 = { 88 FF BD 27 54 00 C3 8C 40 00 CC C4 40 00 B0 AF 21 80 C0 00 50 00 C6 8C 10 00 02 24 23 10 43 00 04 30 66 00 64 00 BF AF 3C 00 A5 AF 38 00 A6 AF 48 00 B2 AF 44 00 B1 AF 21 90 80 00 74 00 B6 E7 70 00 B5 E7 6C 00 B4 E7 60 00 BE AF 5C 00 B7 AF 58 00 B6 AF 54 00 B5 AF 50 00 B4 AF 4C 00 B3 AF ?? ?? ?? 0? 34 00 A2 AF 20 00 A2 AF 44 00 0C C6 4C 00 02 8E 24 00 A3 AF 10 00 03 8E 30 00 A2 AF ?? ?? ?? 0? 2C 00 A3 AF 18 00 A2 AF 34 00 0C C6 14 00 02 8E 1C 00 A3 AF 38 00 15 C6 ?? ?? ?? 0? 28 00 A2 AF 10 00 A2 AF ?? ?? 02 3C 14 00 A3 AF ?? ?? 42 8C 5C 00 11 8E 3C 00 14 C6 30 00 16 C6 3C 00 A3 8F 48 00 10 8E 08 00 A2 AF 65 00 60 18 04 00 B0 AF 06 AB 00 46 ?? ?? ?? 0? 00 00 B2 AF 06 A3 00 46 21 A0 40 00 ?? ?? ?? 0? 21 A8 60 00 06 B3 00 46 21 B0 40 00 ?? ?? ?? 0? 21 B8 60 00 21 F0 00 00 21 90 40 00 ?? ?? ?? 0? 21 98 60 00 ?? ?? ?? 0? 00 00 00 00 18 00 A6 8F 1C 00 A7 8F 21 20 C0 02 21 28 E0 02 21 A0 40 00 ?? ?? ?? 0? 21 A8 60 00 10 00 A6 8F 14 00 A7 8F 21 20 40 02 21 28 60 02 21 B0 40 00 ?? ?? ?? 0? 21 B8 60 00 21 90 40 00 21 98 60 00 00 00 2C C6 ?? ?? ?? 0? 01 00 DE 27 21 20 40 00 21 28 60 00 21 30 40 02 ?? ?? ?? 0? 21 38 60 02 21 30 40 02 21 38 60 02 21 20 80 02 29 00 41 04 21 28 A0 02 ?? ?? ?? 0? 00 00 00 00 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 03 84 02 00 30 00 A2 8F 21 30 40 02 21 38 60 02 21 20 C0 02 21 28 E0 02 ?? ?? ?? 0? 24 80 02 02 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 34 00 A3 8F 07 10 62 00 38 00 A3 8F 24 10 43 00 21 80 02 02 04 00 A2 8F 40 80 10 00 2C 00 A3 8F 21 80 50 00 00 00 02 96 03 34 03 00 1F 7C 03 24 0B 00 43 10 21 20 40 00 ?? ?? 02 3C 08 00 A3 8F 09 F8 60 00 ?? ?? 45 8C 00 00 A3 8F 21 20 40 02 21 28 60 02 ?? ?? ?? 0? 00 00 62 A4 00 00 20 E6 2C 00 A2 8F 28 00 A3 8F 21 20 80 02 21 28 A0 02 21 10 43 00 2C 00 A2 AF 00 00 A2 8F 3C 00 A3 8F 20 00 A6 8F 02 00 42 24 24 00 A7 8F 04 00 31 26 AC FF C3 17 00 00 A2 AF 64 00 BF 8F 60 00 BE 8F 5C 00 B7 8F 58 00 B6 8F 54 00 B5 8F 50 00 B4 8F 4C 00 B3 8F 48 00 B2 8F 44 00 B1 8F 40 00 B0 8F 74 00 B6 C7 70 00 B5 C7 6C 00 B4 C7 08 00 E0 03 78 00 BD 27 }
	condition:
		$1
}

rule file_39_11_0 {
	meta:
		name = "_poly_zbuf_atex_mask_trans15"
		size = 360
		refs = "0010 _blender_func15 008c .text 00dc _blender_alpha"
	strings:
		$1 = { 54 00 C3 8C 10 00 02 24 B8 FF BD 27 23 58 43 00 ?? ?? 02 3C ?? ?? 42 8C 30 00 B6 AF 21 B0 C0 00 50 00 C6 8C 38 00 BE AF 34 00 B7 AF 24 00 B3 AF 20 00 B2 AF 44 00 B4 E7 04 48 66 00 00 00 A2 AF 3C 00 BF AF 2C 00 B5 AF 28 00 B4 AF 1C 00 B1 AF 18 00 B0 AF 21 50 A0 00 4C 00 C8 8E 00 00 D3 8E 04 00 D2 8E 08 00 C7 8E 0C 00 DE 8E 48 00 D7 8E 60 00 C3 8E 30 00 D4 C6 2E 00 A0 18 5C 00 C2 8E 21 A8 80 00 21 A0 60 00 21 80 40 00 ?? ?? ?? 0? 21 88 00 00 00 A5 00 46 00 00 00 C6 03 14 13 00 07 18 72 01 24 10 48 00 24 18 69 00 3C 00 14 46 21 10 43 00 40 10 02 00 21 10 E2 02 01 00 31 26 21 98 67 02 16 00 00 45 21 90 5E 02 00 00 42 94 1F 7C 03 24 12 00 43 10 21 20 40 00 ?? ?? 02 3C 00 00 85 96 ?? ?? 46 8C 00 00 A3 8F 04 00 A7 AF 08 00 A8 AF 0C 00 A9 AF 10 00 AA AF 09 F8 60 00 14 00 AB AF 14 00 AB 8F 10 00 AA 8F 0C 00 A9 8F 08 00 A8 8F 04 00 A7 8F 00 00 A2 A6 00 00 14 E6 04 00 10 26 02 00 B5 26 02 00 94 26 D9 FF 2A 16 34 00 C0 C6 3C 00 BF 8F 38 00 BE 8F 34 00 B7 8F 30 00 B6 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 44 00 B4 C7 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_39_13_0 {
	meta:
		name = "_poly_zbuf_ptex_mask_trans15"
		size = 660
		refs = "0060 __extendsfdf2 0098 _blender_func15 0100 .text 0108 __adddf3 0168 __ltdf2 0184 __divdf3 0190 __fixdfsi 01f8 _blender_alpha 0218 __truncdfsf2"
	strings:
		$1 = { 90 FF BD 27 54 00 C3 8C 40 00 CC C4 38 00 B0 AF 21 80 C0 00 50 00 C6 8C 10 00 02 24 23 10 43 00 04 30 66 00 5C 00 BF AF 34 00 A5 AF 30 00 A6 AF 40 00 B2 AF 3C 00 B1 AF 21 90 80 00 6C 00 B6 E7 68 00 B5 E7 64 00 B4 E7 58 00 BE AF 54 00 B7 AF 50 00 B6 AF 4C 00 B5 AF 48 00 B4 AF 44 00 B3 AF ?? ?? ?? 0? 2C 00 A2 AF 20 00 A2 AF 44 00 0C C6 4C 00 02 8E 24 00 A3 AF 38 00 15 C6 ?? ?? ?? 0? 28 00 A2 AF 34 00 0C C6 18 00 A2 AF ?? ?? ?? 0? 1C 00 A3 AF 10 00 A2 AF ?? ?? 02 3C ?? ?? 42 8C 14 00 A3 AF 48 00 03 8E 0C 00 A2 AF 34 00 A2 8F 3C 00 14 C6 30 00 16 C6 5C 00 11 8E 08 00 A3 AF 65 00 40 18 60 00 10 8E 06 AB 00 46 ?? ?? ?? 0? 04 00 B2 AF 06 A3 00 46 21 A0 40 00 21 A8 60 00 ?? ?? ?? 0? 00 00 B0 AF 06 B3 00 46 21 B0 40 00 ?? ?? ?? 0? 21 B8 60 00 21 90 40 00 21 98 60 00 ?? ?? ?? 0? 21 F0 00 00 ?? ?? ?? 0? 00 00 00 00 18 00 A6 8F 1C 00 A7 8F 21 20 C0 02 21 28 E0 02 21 A0 40 00 ?? ?? ?? 0? 21 A8 60 00 10 00 A6 8F 14 00 A7 8F 21 20 40 02 21 28 60 02 21 B0 40 00 ?? ?? ?? 0? 21 B8 60 00 21 90 40 00 21 98 60 00 00 00 2C C6 ?? ?? ?? 0? 01 00 DE 27 21 20 40 00 21 28 60 00 21 30 40 02 ?? ?? ?? 0? 21 38 60 02 21 30 40 02 21 38 60 02 21 20 80 02 29 00 41 04 21 28 A0 02 ?? ?? ?? 0? 00 00 00 00 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 28 00 A3 8F 03 84 02 00 21 30 40 02 21 38 60 02 21 20 C0 02 21 28 E0 02 ?? ?? ?? 0? 24 80 03 02 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 2C 00 A3 8F 07 10 62 00 30 00 A3 8F 24 10 43 00 21 80 02 02 08 00 A2 8F 40 80 10 00 1F 7C 03 24 21 80 50 00 00 00 02 96 0D 00 43 10 21 20 40 00 00 00 A3 8F ?? ?? 02 3C 00 00 65 94 0C 00 A3 8F 09 F8 60 00 ?? ?? 46 8C 04 00 A3 8F 21 20 40 02 21 28 60 02 ?? ?? ?? 0? 00 00 62 A4 00 00 20 E6 04 00 A2 8F 00 00 A3 8F 21 20 80 02 02 00 42 24 04 00 A2 AF 34 00 A2 8F 02 00 63 24 21 28 A0 02 20 00 A6 8F 24 00 A7 8F 04 00 31 26 AD FF C2 17 00 00 A3 AF 5C 00 BF 8F 58 00 BE 8F 54 00 B7 8F 50 00 B6 8F 4C 00 B5 8F 48 00 B4 8F 44 00 B3 8F 40 00 B2 8F 3C 00 B1 8F 38 00 B0 8F 6C 00 B6 C7 68 00 B5 C7 64 00 B4 C7 08 00 E0 03 70 00 BD 27 }
	condition:
		$1
}

rule file_41_1_0 {
	meta:
		name = "ascii_getx"
		size = 20
	strings:
		$1 = { 00 00 83 8C 00 00 62 90 01 00 63 24 08 00 E0 03 00 00 83 AC }
	condition:
		$1
}

rule file_41_6_0 {
	meta:
		name = "ascii_cp_getc"
		size = 28
		refs = "0004 .data"
	strings:
		$1 = { 00 00 82 90 ?? ?? 04 3C ?? ?? 83 8C 40 10 02 00 21 18 62 00 08 00 E0 03 00 00 62 94 }
	condition:
		$1
}

rule file_41_7_0 {
	meta:
		name = "ascii_cp_getx"
		size = 40
		refs = "0004 .data"
	strings:
		$1 = { 00 00 82 8C ?? ?? 03 3C ?? ?? 66 8C 00 00 45 90 01 00 42 24 00 00 82 AC 40 28 05 00 21 30 C5 00 08 00 E0 03 00 00 C2 94 }
	condition:
		$1
}

rule file_41_8_0 {
	meta:
		name = "ascii_cp_setc"
		size = 168
		refs = "0000 .data 000c .text"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 46 8C 21 18 00 00 ?? ?? ?? 0? 00 01 07 24 01 00 63 24 07 00 67 10 ?? ?? 02 3C 00 00 C2 94 FB FF 45 14 02 00 C6 24 00 00 83 A0 08 00 E0 03 01 00 02 24 ?? ?? 47 8C 10 00 E0 10 5E 00 02 24 00 00 E2 94 0D 00 40 50 5E 00 02 24 12 00 45 50 02 00 02 24 21 18 E0 00 ?? ?? ?? 0? 21 10 00 00 09 00 C5 50 01 00 42 24 04 00 66 94 02 00 42 24 FB FF C0 14 04 00 63 24 5E 00 02 24 00 00 82 A0 08 00 E0 03 01 00 02 24 40 10 02 00 21 10 E2 00 ?? ?? ?? 0? 00 00 43 94 21 10 E2 00 ?? ?? ?? 0? 00 00 43 94 }
	condition:
		$1
}

rule file_41_9_0 {
	meta:
		name = "ascii_cp_isok"
		size = 104
		refs = "0000 .data 000c .text"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 46 8C 21 28 00 00 ?? ?? ?? 0? 00 02 07 24 07 00 A7 10 ?? ?? 02 3C 21 10 C5 00 00 00 43 94 FB FF 64 14 02 00 A5 24 08 00 E0 03 FF FF 02 24 ?? ?? 42 8C 09 00 40 10 00 00 00 00 00 00 43 94 06 00 60 10 00 00 00 00 F7 FF 64 10 00 00 00 00 04 00 43 94 FC FF 60 14 04 00 42 24 08 00 E0 03 21 10 00 00 }
	condition:
		$1
}

rule file_41_11_0 {
	meta:
		name = "unicode_getx"
		size = 20
	strings:
		$1 = { 00 00 83 8C 00 00 62 94 02 00 63 24 08 00 E0 03 00 00 83 AC }
	condition:
		$1
}

rule file_41_16_0 {
	meta:
		name = "utf8_getc"
		size = 168
		refs = "0060 .text"
	strings:
		$1 = { 00 00 87 90 80 00 E2 30 20 00 40 10 21 40 80 00 40 00 E2 30 22 00 40 10 01 00 06 24 80 00 04 24 01 00 C3 24 07 10 64 00 24 10 47 00 FC FF 40 54 21 30 60 00 01 00 05 91 08 00 02 24 23 10 43 00 01 00 03 24 04 18 43 00 FF FF 63 24 C0 00 A4 30 80 00 02 24 0F 00 82 14 24 38 E3 00 02 00 04 25 ?? ?? ?? 0? 80 00 08 24 00 00 85 90 C0 00 A2 30 08 00 48 14 01 00 84 24 3F 00 A3 30 80 11 07 00 FF FF C6 24 F8 FF C0 1C 25 38 62 00 08 00 E0 03 21 10 E0 00 5E 00 07 24 08 00 E0 03 21 10 E0 00 ?? ?? ?? 0? 7F 00 E7 30 }
	condition:
		$1
}

rule file_41_17_0 {
	meta:
		name = "utf8_getx"
		size = 196
		refs = "0070 .text"
	strings:
		$1 = { 00 00 83 8C 21 50 80 00 00 00 68 90 01 00 69 24 80 00 02 31 23 00 40 10 00 00 89 AC 40 00 02 31 26 00 40 10 01 00 07 24 80 00 05 24 01 00 E4 24 07 10 85 00 24 10 48 00 FC FF 40 54 21 38 80 00 01 00 66 90 08 00 02 24 23 10 44 00 01 00 03 24 04 18 43 00 FF FF 63 24 01 00 24 25 C0 00 C5 30 80 00 02 24 24 40 03 01 10 00 A2 14 00 00 44 AD ?? ?? ?? 0? 80 00 04 24 00 00 49 8D 00 00 26 91 01 00 22 25 C0 00 C3 30 08 00 64 14 00 00 42 AD 3F 00 C3 30 80 11 08 00 FF FF E7 24 F6 FF E0 1C 25 40 62 00 08 00 E0 03 21 10 00 01 5E 00 08 24 00 00 49 AD 08 00 E0 03 21 10 00 01 ?? ?? ?? 0? 7F 00 08 31 }
	condition:
		$1
}

rule file_41_18_0 {
	meta:
		name = "utf8_setc"
		size = 212
		refs = "00cc .text"
	strings:
		$1 = { 80 00 A2 28 2C 00 40 14 21 50 80 00 07 00 04 24 01 00 03 24 01 00 84 24 04 10 83 00 2A 10 A2 00 FD FF 40 50 01 00 84 24 0C 00 82 28 26 00 40 14 02 00 07 24 0B 00 03 24 05 00 63 24 2A 10 64 00 FD FF 40 14 01 00 E7 24 21 58 E0 00 21 10 E3 00 F9 FF 48 24 07 18 05 01 20 34 03 7C 00 00 46 A1 21 20 00 00 80 00 09 24 07 10 89 00 01 00 84 24 25 10 C2 00 2A 18 87 00 FB FF 60 14 20 34 02 7C 00 00 46 A1 80 FF 09 24 01 00 06 24 FA FF 08 25 07 10 05 01 21 20 46 01 3F 00 42 30 01 00 C6 24 25 10 49 00 2A 18 C7 00 F8 FF 60 14 00 00 82 A0 08 00 E0 03 21 10 60 01 01 00 0B 24 00 00 85 A0 08 00 E0 03 21 10 60 01 0B 00 03 24 ?? ?? ?? 0? 02 00 0B 24 }
	condition:
		$1
}

rule file_41_19_0 {
	meta:
		name = "utf8_width"
		size = 64
	strings:
		$1 = { 00 00 84 90 80 00 82 30 0B 00 40 10 01 00 03 24 40 00 82 30 08 00 40 10 80 00 05 24 01 00 63 24 07 10 65 00 24 10 44 00 FD FF 40 54 01 00 63 24 08 00 E0 03 21 10 60 00 08 00 E0 03 21 10 60 00 }
	condition:
		$1
}

rule file_41_20_0 {
	meta:
		name = "utf8_cwidth"
		size = 96
		refs = "0058 .text"
	strings:
		$1 = { 80 00 82 28 11 00 40 14 07 00 05 24 01 00 03 24 01 00 A5 24 04 10 A3 00 2A 10 82 00 FD FF 40 50 01 00 A5 24 0C 00 A2 28 0B 00 40 14 0B 00 03 24 02 00 04 24 05 00 63 24 2A 10 65 00 FD FF 40 14 01 00 84 24 08 00 E0 03 21 10 80 00 01 00 04 24 08 00 E0 03 21 10 80 00 ?? ?? ?? 0? 02 00 04 24 }
	condition:
		$1
}

rule file_41_22_0 {
	meta:
		name = "_find_utype"
		size = 88
		refs = "0010 .data 0044 .text"
	strings:
		$1 = { 75 63 02 3C 2E 72 42 34 0E 00 82 10 ?? ?? 02 3C ?? ?? 02 3C ?? ?? 47 24 21 18 E0 00 21 28 00 00 08 00 06 24 00 00 62 8C 08 00 44 10 20 00 63 24 01 00 A5 24 FC FF A6 54 00 00 62 8C 08 00 E0 03 21 10 00 00 ?? ?? ?? 0? ?? ?? 44 8C 40 11 05 00 08 00 E0 03 21 10 E2 00 }
	condition:
		$1
}

rule file_41_23_0 {
	meta:
		name = "set_uformat"
		size = 184
		refs = "0010 .data 0044 .text 0080 ugetc 0084 ugetxc 0090 usetc 0094 uwidth 00a0 ucwidth 00a4 uisok 00b4 ugetx"
	strings:
		$1 = { 75 63 02 3C 2E 72 42 34 0E 00 82 10 ?? ?? 02 3C ?? ?? 02 3C ?? ?? 47 24 21 18 E0 00 21 28 00 00 08 00 06 24 00 00 62 8C 08 00 44 10 20 00 63 24 01 00 A5 24 FC FF A6 54 00 00 62 8C 08 00 E0 03 00 00 00 00 ?? ?? ?? 0? ?? ?? 44 8C 40 11 05 00 21 10 E2 00 F9 FF 40 10 ?? ?? 03 3C 04 00 45 8C 00 00 44 8C 08 00 49 8C 0C 00 46 8C 18 00 4A 8C 10 00 47 8C 14 00 48 8C ?? ?? 02 3C ?? ?? 44 AC ?? ?? 65 AC ?? ?? 02 3C ?? ?? 03 3C ?? ?? 49 AC ?? ?? 66 AC ?? ?? 02 3C ?? ?? 03 3C ?? ?? 47 AC ?? ?? 68 AC ?? ?? 02 3C ?? ?? 03 3C ?? ?? 4A AC 08 00 E0 03 ?? ?? 69 AC }
	condition:
		$1
}

rule file_41_25_0 {
	meta:
		name = "register_uformat"
		size = 192
		refs = "0014 .data 006c .text"
	strings:
		$1 = { 75 63 02 3C 2E 72 42 34 18 00 82 10 ?? ?? 02 3C 21 78 80 00 ?? ?? 02 3C ?? ?? 4E 24 21 C0 C0 01 21 18 C0 01 21 60 00 00 08 00 0D 24 00 00 62 8C 10 00 4F 10 20 00 63 24 01 00 8C 25 FC FF 8D 55 00 00 62 8C 21 18 00 00 08 00 0C 24 00 00 C2 8D 15 00 40 10 20 00 CE 25 01 00 63 24 FC FF 6C 54 00 00 C2 8D 08 00 E0 03 00 00 00 00 ?? ?? ?? 0? ?? ?? 4F 8C 40 11 0C 00 21 10 02 03 F2 FF 40 10 21 18 00 00 1C 00 4B AC 00 00 44 AC 04 00 45 AC 08 00 46 AC 0C 00 47 AC 10 00 48 AC 14 00 49 AC 08 00 E0 03 18 00 4A AC 40 11 03 00 21 10 02 03 F5 FF 40 54 1C 00 4B AC 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_41_26_0 {
	meta:
		name = "set_ucodepage"
		size = 20
		refs = "0000 .data"
		altNames = "__gnat_install_locks reserve_voices"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 03 3C ?? ?? 44 AC 08 00 E0 03 ?? ?? 65 AC }
	condition:
		$1
}

rule file_4_0_32 {
	meta:
		name = "mpeg2_malloc_hooks"
		size = 20
		refs = "0000 .bss"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 03 3C ?? ?? 44 AC 08 00 E0 03 ?? ?? 65 AC }
	condition:
		$1
}

rule file_41_27_0 {
	meta:
		name = "need_uconvert"
		size = 172
		refs = "000c .data 0078 .text"
	strings:
		$1 = { 75 63 02 3C 2E 72 42 34 1B 00 A2 10 ?? ?? 02 3C 75 63 02 3C 2E 72 42 34 12 00 C2 10 ?? ?? 02 3C 13 00 A6 10 00 00 00 00 53 41 02 3C 38 43 42 34 13 00 A2 14 53 41 02 3C 38 43 42 34 16 00 C2 14 54 55 02 3C 00 00 82 90 01 00 84 24 08 00 40 10 80 00 43 28 FC FF 60 54 00 00 82 90 08 00 E0 03 FF FF 02 24 ?? ?? 46 8C F0 FF A6 54 53 41 02 3C 08 00 E0 03 21 10 00 00 ?? ?? ?? 0? ?? ?? 45 8C 54 55 02 3C 38 46 42 34 F4 FF A2 14 00 00 00 00 ?? ?? ?? 0? 53 41 02 3C 38 46 42 34 EF FF C2 14 00 00 00 00 ?? ?? ?? 0? 00 00 82 90 }
	condition:
		$1
}

rule file_41_28_0 {
	meta:
		name = "uconvert_size"
		size = 316
		refs = "0028 .data 007c .text"
	strings:
		$1 = { 75 63 02 3C E0 FF BD 27 2E 72 42 34 1C 00 BF AF 18 00 B3 AF 14 00 B2 AF 10 00 B1 AF 0C 00 B0 AF 15 00 A2 10 00 00 A4 AF ?? ?? 02 3C ?? ?? 47 24 21 48 E0 00 21 18 E0 00 21 20 00 00 08 00 08 24 00 00 62 8C 0F 00 45 10 20 00 63 24 01 00 84 24 FC FF 88 54 00 00 62 8C 1C 00 BF 8F 21 10 00 00 18 00 B3 8F 14 00 B2 8F 10 00 B1 8F 0C 00 B0 8F 08 00 E0 03 20 00 BD 27 ?? ?? 02 3C ?? ?? ?? 0? ?? ?? 45 8C 40 11 04 00 21 98 22 01 F2 FF 60 12 75 63 02 3C 2E 72 42 34 26 00 C2 10 ?? ?? 02 3C 00 00 E2 8C 21 18 00 00 08 00 04 24 07 00 46 10 20 00 E7 24 01 00 63 24 E8 FF 64 10 1C 00 BF 8F 00 00 E2 8C FB FF 46 14 20 00 E7 24 40 11 03 00 21 88 22 01 E0 FF 20 12 21 90 A0 03 ?? ?? ?? 0? 21 80 00 00 14 00 23 8E 09 F8 60 00 00 00 00 00 21 80 02 02 08 00 63 8E 09 F8 60 00 21 20 40 02 F8 FF 40 14 21 20 40 00 14 00 23 8E 09 F8 60 00 21 20 00 00 1C 00 BF 8F 21 10 02 02 18 00 B3 8F 14 00 B2 8F 10 00 B1 8F 0C 00 B0 8F 08 00 E0 03 20 00 BD 27 ?? ?? ?? 0? ?? ?? 46 8C }
	condition:
		$1
}

rule file_41_29_0 {
	meta:
		name = "do_uconvert"
		size = 440
		refs = "0040 .data 00a0 .text"
	strings:
		$1 = { 75 63 02 3C D0 FF BD 27 2E 72 42 34 28 00 B7 AF 0C 00 B0 AF 2C 00 BF AF 24 00 B6 AF 20 00 B5 AF 1C 00 B4 AF 18 00 B3 AF 14 00 B2 AF 10 00 B1 AF 00 00 A4 AF 21 B8 C0 00 18 00 A2 10 21 80 00 01 ?? ?? 02 3C ?? ?? 46 24 21 48 C0 00 21 18 C0 00 21 20 00 00 08 00 08 24 00 00 62 8C 12 00 45 10 20 00 63 24 01 00 84 24 FC FF 88 54 00 00 62 8C 2C 00 BF 8F 28 00 B7 8F 24 00 B6 8F 20 00 B5 8F 1C 00 B4 8F 18 00 B3 8F 14 00 B2 8F 10 00 B1 8F 0C 00 B0 8F 08 00 E0 03 30 00 BD 27 ?? ?? 02 3C ?? ?? ?? 0? ?? ?? 45 8C 40 11 04 00 21 A8 22 01 EF FF A0 12 75 63 02 3C 2E 72 42 34 3C 00 E2 10 ?? ?? 02 3C 00 00 C2 8C 21 18 00 00 08 00 04 24 07 00 47 10 20 00 C6 24 01 00 63 24 E5 FF 64 10 2C 00 BF 8F 00 00 C2 8C FB FF 47 14 20 00 C6 24 40 11 03 00 21 98 22 01 DE FF 60 12 2C 00 BF 8F 14 00 63 8E 21 20 00 00 09 F8 60 00 21 B0 A0 03 23 88 02 02 21 90 00 00 ?? ?? ?? 0? 5E 00 14 24 18 00 63 8E 09 F8 60 00 00 00 00 00 14 00 65 8E 0A 80 82 02 09 F8 A0 00 21 20 00 02 23 88 22 02 21 28 00 02 0B 00 20 06 21 20 F2 02 0C 00 63 8E 09 F8 60 00 00 00 00 00 21 90 42 02 08 00 A3 8E 09 F8 60 00 21 20 C0 02 21 80 40 00 EC FF 40 14 21 20 40 00 0C 00 63 8E 21 20 F2 02 09 F8 60 00 21 28 00 00 2C 00 BF 8F 28 00 B7 8F 24 00 B6 8F 20 00 B5 8F 1C 00 B4 8F 18 00 B3 8F 14 00 B2 8F 10 00 B1 8F 0C 00 B0 8F 08 00 E0 03 30 00 BD 27 ?? ?? ?? 0? ?? ?? 47 8C }
	condition:
		$1
}

rule file_41_30_0 {
	meta:
		name = "uconvert"
		size = 180
		refs = "0030 need_uconvert 0058 do_uconvert 0044 .bss 00ac .text"
	strings:
		$1 = { E8 FF BD 27 00 00 B0 AF 21 80 C0 00 21 30 E0 00 10 00 B4 AF 0C 00 B3 AF 08 00 B2 AF 04 00 B1 AF 14 00 BF AF 21 98 E0 00 21 A0 00 01 21 88 80 00 ?? ?? ?? 0? 21 90 A0 00 12 00 40 10 14 00 BF 8F 19 00 00 12 ?? ?? 02 3C 21 20 20 02 21 28 40 02 21 38 60 02 21 40 80 02 ?? ?? ?? 0? 21 30 00 02 14 00 BF 8F 21 10 00 02 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 18 00 BD 27 21 80 20 02 21 10 00 02 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 18 00 BD 27 ?? ?? 50 24 ?? ?? ?? 0? 00 04 14 24 }
	condition:
		$1
}

rule file_41_31_0 {
	meta:
		name = "uwidth_max"
		size = 100
		refs = "0010 .data 0044 .text"
	strings:
		$1 = { 75 63 02 3C 2E 72 42 34 0E 00 82 10 ?? ?? 02 3C ?? ?? 02 3C ?? ?? 47 24 21 18 E0 00 21 28 00 00 08 00 06 24 00 00 62 8C 08 00 44 10 20 00 63 24 01 00 A5 24 FC FF A6 54 00 00 62 8C 08 00 E0 03 21 10 00 00 ?? ?? ?? 0? ?? ?? 44 8C 40 11 05 00 21 10 E2 00 F9 FF 40 10 00 00 00 00 08 00 E0 03 1C 00 42 8C }
	condition:
		$1
}

rule file_41_32_0 {
	meta:
		name = "utolower"
		size = 6588
		refs = "02f4 .text"
	strings:
		$1 = { BF FF 82 24 1A 00 42 2C B3 00 40 54 20 00 84 24 40 FF 82 24 17 00 42 2C AF 00 40 54 20 00 84 24 28 FF 82 24 07 00 42 2C AB 00 40 54 20 00 84 24 6F FC 82 24 11 00 42 2C A7 00 40 54 20 00 84 24 5D FC 82 24 09 00 42 2C A3 00 40 54 20 00 84 24 F0 FB 82 24 20 00 42 2C 9F 00 40 54 20 00 84 24 77 FE 82 24 02 00 42 2C 9B 00 40 54 CD 00 84 24 4F FE 82 24 02 00 42 2C 97 00 40 54 D9 00 84 24 78 FC 82 24 03 00 42 2C 93 00 40 54 25 00 84 24 72 FC 82 24 02 00 42 2C 8F 00 40 54 3F 00 84 24 FF FB 82 24 0C 00 42 2C 8B 00 40 54 50 00 84 24 F2 FB 82 24 02 00 42 2C 87 00 40 54 50 00 84 24 CF FA 82 24 26 00 42 2C 83 00 40 54 30 00 84 24 60 EF 82 24 26 00 42 2C 7F 00 40 54 30 00 84 24 F8 E0 82 24 08 00 42 2C 7B 00 40 54 F8 FF 84 24 E8 E0 82 24 06 00 42 2C 77 00 40 54 F8 FF 84 24 D8 E0 82 24 08 00 42 2C 73 00 40 54 F8 FF 84 24 C8 E0 82 24 08 00 42 2C 6F 00 40 54 F8 FF 84 24 B8 E0 82 24 06 00 42 2C 6B 00 40 54 F8 FF 84 24 98 E0 82 24 08 00 42 2C 67 00 40 54 F8 FF 84 24 78 E0 82 24 08 00 42 2C 63 00 40 54 F8 FF 84 24 68 E0 82 24 08 00 42 2C 5F 00 40 54 F8 FF 84 24 58 E0 82 24 08 00 42 2C 5B 00 40 54 F8 FF 84 24 48 E0 82 24 02 00 42 2C 57 00 40 54 F8 FF 84 24 28 E0 82 24 02 00 42 2C 53 00 40 54 F8 FF 84 24 18 E0 82 24 02 00 42 2C 4F 00 40 54 F8 FF 84 24 46 E0 82 24 02 00 42 2C 4B 00 40 54 B6 FF 84 24 38 E0 82 24 04 00 42 2C 47 00 40 54 AA FF 84 24 26 E0 82 24 02 00 42 2C 43 00 40 54 9C FF 84 24 16 E0 82 24 02 00 42 2C 3F 00 40 54 90 FF 84 24 08 E0 82 24 02 00 42 2C 3B 00 40 54 80 FF 84 24 06 E0 82 24 02 00 42 2C 37 00 40 54 82 FF 84 24 A0 DE 82 24 10 00 42 2C 33 00 40 54 10 00 84 24 4A DB 82 24 1A 00 42 2C 2F 00 40 54 1A 00 84 24 9C 04 02 24 2C 00 82 50 01 00 84 24 9D 04 82 28 FC 00 40 10 56 1E 02 24 A4 01 02 24 26 00 82 50 01 00 84 24 A5 01 82 28 77 00 40 10 02 02 02 24 54 01 02 24 20 00 82 50 01 00 84 24 55 01 82 28 7D 03 40 10 7D 01 02 24 28 01 02 24 1A 00 82 50 01 00 84 24 29 01 82 28 55 00 40 10 3D 01 02 24 12 01 02 24 14 00 82 50 01 00 84 24 13 01 82 28 24 00 40 10 1C 01 02 24 08 01 02 24 0E 00 82 50 01 00 84 24 09 01 82 28 14 00 40 10 0C 01 02 24 02 01 02 24 08 00 82 50 01 00 84 24 03 01 82 28 07 00 40 10 04 01 02 24 00 01 02 24 02 00 82 14 00 00 00 00 01 00 84 24 08 00 E0 03 21 10 80 00 FD FF 82 50 01 00 84 24 06 01 02 24 FA FF 82 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 F6 FF 82 50 01 00 84 24 0D 01 82 28 16 00 40 10 0E 01 02 24 0A 01 02 24 F0 FF 82 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 EC FF 82 50 01 00 84 24 1D 01 82 28 1A 00 40 10 22 01 02 24 16 01 02 24 E6 FF 82 50 01 00 84 24 17 01 82 28 0D 00 40 10 18 01 02 24 14 01 02 24 E0 FF 82 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 DC FF 82 50 01 00 84 24 10 01 02 24 D9 FF 82 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 D5 FF 82 50 01 00 84 24 1A 01 02 24 D2 FF 82 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 CE FF 82 50 01 00 84 24 23 01 82 28 47 03 40 10 24 01 02 24 1E 01 02 24 C8 FF 82 50 01 00 84 24 20 01 02 24 C5 FF 82 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 C1 FF 82 50 01 00 84 24 3E 01 82 28 F2 03 40 10 47 01 02 24 32 01 02 24 BB FF 82 50 01 00 84 24 33 01 82 28 E2 03 40 10 36 01 02 24 2C 01 02 24 B5 FF 82 50 01 00 84 24 2D 01 82 28 AD 00 40 10 2E 01 02 24 2A 01 02 24 AF FF 82 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 AB FF 82 50 01 00 84 24 03 02 82 28 44 00 40 10 62 04 02 24 D3 01 02 24 A5 FF 82 50 01 00 84 24 D4 01 82 28 28 00 40 10 E8 01 02 24 B8 01 02 24 9F FF 82 50 01 00 84 24 B9 01 82 28 12 00 40 10 C8 01 02 24 AE 01 02 24 99 FF 82 50 DA 00 84 24 AF 01 82 28 94 04 40 10 B3 01 02 24 A7 01 02 24 93 FF 82 50 01 00 84 24 A8 01 82 28 48 04 40 10 A9 01 02 24 A6 01 02 24 8D FF 82 14 00 00 00 00 ?? ?? ?? 0? DA 00 84 24 89 FF 82 50 01 00 84 24 C9 01 82 28 45 00 40 10 CD 01 02 24 C4 01 02 24 83 FF 82 50 02 00 84 24 C5 01 82 28 38 00 40 10 C5 01 02 24 BC 01 02 24 7D FF 82 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 79 FF 82 50 01 00 84 24 E9 01 82 28 AF 04 40 10 F2 01 02 24 DE 01 02 24 73 FF 82 50 01 00 84 24 DF 01 82 28 9F 04 40 10 E2 01 02 24 D7 01 02 24 6D FF 82 50 01 00 84 24 D8 01 82 28 C3 02 40 10 D9 01 02 24 D5 01 02 24 67 FF 82 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 63 FF 82 50 01 00 84 24 63 04 82 28 13 03 40 10 78 04 02 24 16 02 02 24 5D FF 82 50 01 00 84 24 17 02 82 28 FE 02 40 10 E6 03 02 24 0C 02 02 24 57 FF 82 50 01 00 84 24 0D 02 82 28 DA 04 40 10 10 02 02 24 06 02 02 24 51 FF 82 50 01 00 84 24 07 02 82 28 1A 00 40 10 08 02 02 24 04 02 02 24 4B FF 82 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 47 FF 82 50 01 00 84 24 C7 01 02 24 44 FF 82 14 00 00 00 00 ?? ?? ?? 0? 02 00 84 24 40 FF 82 50 01 00 84 24 CE 01 82 28 CD 04 40 10 CF 01 02 24 CA 01 02 24 3A FF 82 50 02 00 84 24 CB 01 02 24 37 FF 82 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 33 FF 82 50 01 00 84 24 0A 02 02 24 30 FF 82 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 2C FF 82 50 01 00 84 24 57 1E 82 28 E1 00 40 10 B4 1E 02 24 02 1E 02 24 26 FF 82 50 01 00 84 24 03 1E 82 28 BF 00 40 10 2C 1E 02 24 CB 04 02 24 20 FF 82 50 01 00 84 24 CC 04 82 28 3E 00 40 10 E2 04 02 24 B0 04 02 24 1A FF 82 50 01 00 84 24 B1 04 82 28 28 00 40 10 BA 04 02 24 A6 04 02 24 14 FF 82 50 01 00 84 24 A7 04 82 28 18 00 40 10 AA 04 02 24 A0 04 02 24 0E FF 82 50 01 00 84 24 A1 04 82 28 0B 00 40 10 A2 04 02 24 9E 04 02 24 08 FF 82 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 03 FF 82 10 30 01 83 38 69 00 02 24 ?? ?? ?? 0? 0A 20 43 00 FF FE 82 50 01 00 84 24 A4 04 02 24 FC FE 82 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 F8 FE 82 50 01 00 84 24 AB 04 82 28 2C 00 40 10 AC 04 02 24 A8 04 02 24 F2 FE 82 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 EE FE 82 50 01 00 84 24 BB 04 82 28 6C 00 40 10 C1 04 02 24 B4 04 02 24 E8 FE 82 50 01 00 84 24 B5 04 82 28 5F 00 40 10 B6 04 02 24 B2 04 02 24 E2 FE 82 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 DE FE 82 50 01 00 84 24 E3 04 82 28 2A 00 40 10 EE 04 02 24 D8 04 02 24 D8 FE 82 50 01 00 84 24 D9 04 82 28 1A 00 40 10 DC 04 02 24 D2 04 02 24 D2 FE 82 50 01 00 84 24 D3 04 82 28 0D 00 40 10 D4 04 02 24 D0 04 02 24 CC FE 82 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 C8 FE 82 50 01 00 84 24 AE 04 02 24 C5 FE 82 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 C1 FE 82 50 01 00 84 24 D6 04 02 24 BE FE 82 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 BA FE 82 50 01 00 84 24 DD 04 82 28 16 00 40 10 DE 04 02 24 DA 04 02 24 B4 FE 82 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 B0 FE 82 50 01 00 84 24 EF 04 82 28 1A 00 40 10 F4 04 02 24 E6 04 02 24 AA FE 82 50 01 00 84 24 E7 04 82 28 0D 00 40 10 E8 04 02 24 E4 04 02 24 A4 FE 82 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 A0 FE 82 50 01 00 84 24 E0 04 02 24 9D FE 82 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 99 FE 82 50 01 00 84 24 EA 04 02 24 96 FE 82 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 92 FE 82 50 01 00 84 24 F5 04 82 28 1D 00 40 10 F8 04 02 24 F0 04 02 24 8C FE 82 50 01 00 84 24 F2 04 02 24 89 FE 82 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 85 FE 82 50 01 00 84 24 B8 04 02 24 82 FE 82 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 7E FE 82 50 01 00 84 24 C2 04 82 28 10 00 40 10 C3 04 02 24 BC 04 02 24 78 FE 82 50 01 00 84 24 BE 04 02 24 75 FE 82 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 71 FE 82 50 01 00 84 24 00 1E 02 24 6E FE 82 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 6A FE 82 50 01 00 84 24 C7 04 02 24 67 FE 82 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 63 FE 82 50 01 00 84 24 2D 1E 82 28 BF 02 40 10 40 1E 02 24 16 1E 02 24 5D FE 82 50 01 00 84 24 17 1E 82 28 A3 01 40 10 20 1E 02 24 0C 1E 02 24 57 FE 82 50 01 00 84 24 0D 1E 82 28 35 00 40 10 10 1E 02 24 06 1E 02 24 51 FE 82 50 01 00 84 24 07 1E 82 28 28 00 40 10 08 1E 02 24 04 1E 02 24 4B FE 82 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 47 FE 82 50 01 00 84 24 B5 1E 82 28 88 00 40 10 DE 1E 02 24 80 1E 02 24 41 FE 82 50 01 00 84 24 81 1E 82 28 6C 00 40 10 94 1E 02 24 6A 1E 02 24 3B FE 82 50 01 00 84 24 6B 1E 82 28 3B 00 40 10 74 1E 02 24 60 1E 02 24 35 FE 82 50 01 00 84 24 61 1E 82 28 2B 00 40 10 64 1E 02 24 5A 1E 02 24 2F FE 82 50 01 00 84 24 5B 1E 82 28 17 00 40 10 5C 1E 02 24 58 1E 02 24 29 FE 82 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 25 FE 82 50 01 00 84 24 0A 1E 02 24 22 FE 82 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 1E FE 82 50 01 00 84 24 11 1E 82 28 0D 00 40 10 12 1E 02 24 0E 1E 02 24 18 FE 82 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 14 FE 82 50 01 00 84 24 5E 1E 02 24 11 FE 82 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 0D FE 82 50 01 00 84 24 14 1E 02 24 0A FE 82 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 06 FE 82 50 01 00 84 24 65 1E 82 28 16 00 40 10 66 1E 02 24 62 1E 02 24 00 FE 82 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 FC FD 82 50 01 00 84 24 75 1E 82 28 1A 00 40 10 7A 1E 02 24 6E 1E 02 24 F6 FD 82 50 01 00 84 24 6F 1E 82 28 0D 00 40 10 70 1E 02 24 6C 1E 02 24 F0 FD 82 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 EC FD 82 50 01 00 84 24 68 1E 02 24 E9 FD 82 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 E5 FD 82 50 01 00 84 24 72 1E 02 24 E2 FD 82 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 DE FD 82 50 01 00 84 24 7B 1E 82 28 3B 00 40 10 7C 1E 02 24 76 1E 02 24 D8 FD 82 50 01 00 84 24 78 1E 02 24 D5 FD 82 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 D1 FD 82 50 01 00 84 24 95 1E 82 28 46 00 40 10 A8 1E 02 24 8A 1E 02 24 CB FD 82 50 01 00 84 24 8B 1E 82 28 36 00 40 10 8E 1E 02 24 84 1E 02 24 C5 FD 82 50 01 00 84 24 85 1E 82 28 29 00 40 10 86 1E 02 24 82 1E 02 24 BF FD 82 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 BB FD 82 50 01 00 84 24 DF 1E 82 28 72 00 40 10 F4 1E 02 24 C8 1E 02 24 B5 FD 82 50 01 00 84 24 C9 1E 82 28 5C 00 40 10 D2 1E 02 24 BE 1E 02 24 AF FD 82 50 01 00 84 24 BF 1E 82 28 83 00 40 10 C2 1E 02 24 B8 1E 02 24 A9 FD 82 50 01 00 84 24 B9 1E 82 28 49 00 40 10 BA 1E 02 24 B6 1E 02 24 A3 FD 82 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 9F FD 82 50 01 00 84 24 7E 1E 02 24 9C FD 82 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 98 FD 82 50 01 00 84 24 88 1E 02 24 95 FD 82 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 91 FD 82 50 01 00 84 24 8F 1E 82 28 16 00 40 10 90 1E 02 24 8C 1E 02 24 8B FD 82 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 87 FD 82 50 01 00 84 24 A9 1E 82 28 1A 00 40 10 AE 1E 02 24 A2 1E 02 24 81 FD 82 50 01 00 84 24 A3 1E 82 28 0D 00 40 10 A4 1E 02 24 A0 1E 02 24 7B FD 82 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 77 FD 82 50 01 00 84 24 92 1E 02 24 74 FD 82 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 70 FD 82 50 01 00 84 24 A6 1E 02 24 6D FD 82 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 69 FD 82 50 01 00 84 24 AF 1E 82 28 47 00 40 10 B0 1E 02 24 AA 1E 02 24 63 FD 82 50 01 00 84 24 AC 1E 02 24 60 FD 82 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 5C FD 82 50 01 00 84 24 BC 1E 02 24 59 FD 82 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 55 FD 82 50 01 00 84 24 D3 1E 82 28 41 00 40 10 D8 1E 02 24 CC 1E 02 24 4F FD 82 50 01 00 84 24 CD 1E 82 28 1C 00 40 10 CE 1E 02 24 CA 1E 02 24 49 FD 82 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 45 FD 82 50 01 00 84 24 F5 1E 82 28 59 00 40 10 5D 1F 02 24 E8 1E 02 24 3F FD 82 50 01 00 84 24 E9 1E 82 28 46 00 40 10 EE 1E 02 24 E2 1E 02 24 39 FD 82 50 01 00 84 24 E3 1E 82 28 32 00 40 10 E4 1E 02 24 E0 1E 02 24 33 FD 82 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 2F FD 82 50 01 00 84 24 D0 1E 02 24 2C FD 82 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 28 FD 82 50 01 00 84 24 C3 1E 82 28 0D 00 40 10 C4 1E 02 24 C0 1E 02 24 22 FD 82 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 1E FD 82 50 01 00 84 24 B2 1E 02 24 1B FD 82 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 17 FD 82 50 01 00 84 24 C6 1E 02 24 14 FD 82 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 10 FD 82 50 01 00 84 24 D9 1E 82 28 10 00 40 10 DA 1E 02 24 D4 1E 02 24 0A FD 82 50 01 00 84 24 D6 1E 02 24 07 FD 82 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 03 FD 82 50 01 00 84 24 E6 1E 02 24 00 FD 82 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 FC FC 82 50 01 00 84 24 DC 1E 02 24 F9 FC 82 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 F5 FC 82 50 01 00 84 24 EF 1E 82 28 19 00 40 10 F0 1E 02 24 EA 1E 02 24 EF FC 82 50 01 00 84 24 EC 1E 02 24 EC FC 82 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 E8 FC 82 50 F8 FF 84 24 5E 1F 82 28 1A 00 40 10 CC 1F 02 24 F8 1E 02 24 E2 FC 82 50 01 00 84 24 F9 1E 82 28 0D 00 40 10 59 1F 02 24 F6 1E 02 24 DC FC 82 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 D8 FC 82 50 01 00 84 24 F2 1E 02 24 D5 FC 82 14 00 00 00 00 ?? ?? ?? 0? 01 00 84 24 D1 FC 82 50 F8 FF 84 24 5B 1F 02 24 CE FC 82 14 00 00 00 00 ?? ?? ?? 0? F8 FF 84 24 CA FC 82 50 F7 FF 84 24 CD 1F 82 28 09 00 40 10 EC 1F 02 24 5F 1F 02 24 C4 FC 82 50 F8 FF 84 24 BC 1F 02 24 C1 FC 82 14 00 00 00 00 ?? ?? ?? 0? F7 FF 84 24 BD FC 82 50 E5 1F 04 24 FC 1F 02 24 BA FC 82 14 00 00 00 00 ?? ?? ?? 0? F7 FF 84 24 B6 FC 82 50 }
	condition:
		$1
}

rule file_41_33_0 {
	meta:
		name = "utoupper"
		size = 6724
		refs = "02e0 .text"
	strings:
		$1 = { 9F FF 82 24 1A 00 42 2C AE 00 40 54 E0 FF 84 24 20 FF 82 24 17 00 42 2C AA 00 40 54 E0 FF 84 24 08 FF 82 24 07 00 42 2C A6 00 40 54 E0 FF 84 24 4F FC 82 24 11 00 42 2C A2 00 40 54 E0 FF 84 24 3D FC 82 24 09 00 42 2C 9E 00 40 54 E0 FF 84 24 D0 FB 82 24 20 00 42 2C 9A 00 40 54 E0 FF 84 24 AA FD 82 24 02 00 42 2C 96 00 40 54 33 FF 84 24 76 FD 82 24 02 00 42 2C 92 00 40 54 27 FF 84 24 53 FC 82 24 03 00 42 2C 8E 00 40 54 DB FF 84 24 33 FC 82 24 02 00 42 2C 8A 00 40 54 C1 FF 84 24 AF FB 82 24 0C 00 42 2C 86 00 40 54 B0 FF 84 24 A2 FB 82 24 02 00 42 2C 82 00 40 54 B0 FF 84 24 9F FA 82 24 26 00 42 2C 7E 00 40 54 D0 FF 84 24 00 E1 82 24 08 00 42 2C 7A 00 40 54 08 00 84 24 F0 E0 82 24 06 00 42 2C 76 00 40 54 08 00 84 24 E0 E0 82 24 08 00 42 2C 72 00 40 54 08 00 84 24 D0 E0 82 24 08 00 42 2C 6E 00 40 54 08 00 84 24 C0 E0 82 24 06 00 42 2C 6A 00 40 54 08 00 84 24 A0 E0 82 24 08 00 42 2C 66 00 40 54 08 00 84 24 80 E0 82 24 08 00 42 2C 62 00 40 54 08 00 84 24 70 E0 82 24 08 00 42 2C 5E 00 40 54 08 00 84 24 60 E0 82 24 08 00 42 2C 5A 00 40 54 08 00 84 24 50 E0 82 24 02 00 42 2C 56 00 40 54 08 00 84 24 30 E0 82 24 02 00 42 2C 52 00 40 54 08 00 84 24 20 E0 82 24 02 00 42 2C 4E 00 40 54 08 00 84 24 90 E0 82 24 02 00 42 2C 4A 00 40 54 4A 00 84 24 8E E0 82 24 04 00 42 2C 46 00 40 54 56 00 84 24 8A E0 82 24 02 00 42 2C 42 00 40 54 64 00 84 24 88 E0 82 24 02 00 42 2C 3E 00 40 54 80 00 84 24 86 E0 82 24 02 00 42 2C 3A 00 40 54 70 00 84 24 84 E0 82 24 02 00 42 2C 36 00 40 54 7E 00 84 24 90 DE 82 24 10 00 42 2C 32 00 40 54 F0 FF 84 24 30 DB 82 24 1A 00 42 2C 2E 00 40 54 E6 FF 84 24 95 04 02 24 2B 00 82 50 FF FF 84 24 96 04 82 28 42 00 40 10 55 1E 02 24 CE 01 02 24 25 00 82 50 FF FF 84 24 CF 01 82 28 9E 01 40 10 6F 02 02 24 55 01 02 24 1F 00 82 50 FF FF 84 24 56 01 82 28 7C 01 40 10 83 01 02 24 27 01 02 24 19 00 82 50 FF FF 84 24 28 01 82 28 4C 01 40 10 3E 01 02 24 11 01 02 24 13 00 82 50 FF FF 84 24 12 01 82 28 36 01 40 10 1B 01 02 24 07 01 02 24 0D 00 82 50 FF FF 84 24 08 01 82 28 13 00 40 10 0B 01 02 24 01 01 02 24 07 00 82 50 FF FF 84 24 02 01 82 28 06 00 40 50 03 01 02 24 FF 00 83 38 78 01 02 24 0A 20 43 00 08 00 E0 03 21 10 80 00 FD FF 82 50 FF FF 84 24 05 01 02 24 FA FF 82 14 00 00 00 00 ?? ?? ?? 0? FF FF 84 24 F6 FF 82 50 FF FF 84 24 0C 01 82 28 06 00 40 10 0D 01 02 24 09 01 02 24 F0 FF 82 14 00 00 00 00 ?? ?? ?? 0? FF FF 84 24 EC FF 82 50 FF FF 84 24 0F 01 02 24 E9 FF 82 14 00 00 00 00 ?? ?? ?? 0? FF FF 84 24 E5 FF 82 50 FF FF 84 24 56 1E 82 28 61 00 40 10 B5 1E 02 24 F5 04 02 24 DF FF 82 50 FF FF 84 24 F6 04 82 28 3F 00 40 10 29 1E 02 24 BF 04 02 24 D9 FF 82 50 FF FF 84 24 C0 04 82 28 7E 00 40 10 DD 04 02 24 A9 04 02 24 D3 FF 82 50 FF FF 84 24 AA 04 82 28 23 00 40 10 B3 04 02 24 9F 04 02 24 CD FF 82 50 FF FF 84 24 A0 04 82 28 13 00 40 10 A3 04 02 24 99 04 02 24 C7 FF 82 50 FF FF 84 24 9A 04 82 28 06 00 40 10 9B 04 02 24 97 04 02 24 C1 FF 82 14 00 00 00 00 ?? ?? ?? 0? FF FF 84 24 BD FF 82 50 FF FF 84 24 9D 04 02 24 BA FF 82 14 00 00 00 00 ?? ?? ?? 0? FF FF 84 24 B6 FF 82 50 FF FF 84 24 A4 04 82 28 71 00 40 10 A5 04 02 24 A1 04 02 24 B0 FF 82 14 00 00 00 00 ?? ?? ?? 0? FF FF 84 24 AC FF 82 50 FF FF 84 24 B4 04 82 28 B4 00 40 10 B9 04 02 24 AD 04 02 24 A6 FF 82 50 FF FF 84 24 AE 04 82 28 A7 00 40 10 AF 04 02 24 AB 04 02 24 A0 FF 82 14 00 00 00 00 ?? ?? ?? 0? FF FF 84 24 9C FF 82 50 FF FF 84 24 2A 1E 82 28 A7 04 40 10 3F 1E 02 24 13 1E 02 24 96 FF 82 50 FF FF 84 24 14 1E 82 28 32 03 40 10 1D 1E 02 24 07 1E 02 24 90 FF 82 50 FF FF 84 24 08 1E 82 28 8E 04 40 10 0D 1E 02 24 01 1E 02 24 8A FF 82 50 FF FF 84 24 02 1E 82 28 28 00 40 10 03 1E 02 24 F9 04 02 24 84 FF 82 14 00 00 00 00 ?? ?? ?? 0? FF FF 84 24 80 FF 82 50 FF FF 84 24 B6 1E 82 28 7A 03 40 10 E1 1E 02 24 81 1E 02 24 7A FF 82 50 FF FF 84 24 82 1E 82 28 5E 03 40 10 9B 1E 02 24 6B 1E 02 24 74 FF 82 50 FF FF 84 24 6C 1E 82 28 2D 03 40 10 75 1E 02 24 5F 1E 02 24 6E FF 82 50 FF FF 84 24 60 1E 82 28 1A 03 40 10 65 1E 02 24 59 1E 02 24 68 FF 82 50 FF FF 84 24 5A 1E 82 28 89 04 40 10 5B 1E 02 24 57 1E 02 24 62 FF 82 14 00 00 00 00 ?? ?? ?? 0? FF FF 84 24 5E FF 82 50 FF FF 84 24 05 1E 02 24 5B FF 82 14 00 00 00 00 ?? ?? ?? 0? FF FF 84 24 57 FF 82 50 FF FF 84 24 DE 04 82 28 2D 00 40 10 E7 04 02 24 D1 04 02 24 51 FF 82 50 FF FF 84 24 D2 04 82 28 1A 00 40 10 D7 04 02 24 C4 04 02 24 4B FF 82 50 FF FF 84 24 C5 04 82 28 0D 00 40 10 C8 04 02 24 C2 04 02 24 45 FF 82 14 00 00 00 00 ?? ?? ?? 0? FF FF 84 24 41 FF 82 50 FF FF 84 24 A7 04 02 24 3E FF 82 14 00 00 00 00 ?? ?? ?? 0? FF FF 84 24 3A FF 82 50 FF FF 84 24 CC 04 02 24 37 FF 82 14 00 00 00 00 ?? ?? ?? 0? FF FF 84 24 33 FF 82 50 FF FF 84 24 D8 04 82 28 19 00 40 10 D9 04 02 24 D3 04 02 24 2D FF 82 50 FF FF 84 24 D5 04 02 24 2A FF 82 14 00 00 00 00 ?? ?? ?? 0? FF FF 84 24 26 FF 82 50 FF FF 84 24 E8 04 82 28 1A 00 40 10 EF 04 02 24 E1 04 02 24 20 FF 82 50 FF FF 84 24 E2 04 82 28 0D 00 40 10 E3 04 02 24 DF 04 02 24 1A FF 82 14 00 00 00 00 ?? ?? ?? 0? FF FF 84 24 16 FF 82 50 FF FF 84 24 DB 04 02 24 13 FF 82 14 00 00 00 00 ?? ?? ?? 0? FF FF 84 24 0F FF 82 50 FF FF 84 24 E5 04 02 24 0C FF 82 14 00 00 00 00 ?? ?? ?? 0? FF FF 84 24 08 FF 82 50 FF FF 84 24 F0 04 82 28 1D 00 40 10 F1 04 02 24 E9 04 02 24 02 FF 82 50 FF FF 84 24 EB 04 02 24 FF FE 82 14 00 00 00 00 ?? ?? ?? 0? FF FF 84 24 FB FE 82 50 FF FF 84 24 B1 04 02 24 F8 FE 82 14 00 00 00 00 ?? ?? ?? 0? FF FF 84 24 F4 FE 82 50 FF FF 84 24 BA 04 82 28 10 00 40 10 BB 04 02 24 B5 04 02 24 EE FE 82 50 FF FF 84 24 B7 04 02 24 EB FE 82 14 00 00 00 00 ?? ?? ?? 0? FF FF 84 24 E7 FE 82 50 FF FF 84 24 F3 04 02 24 E4 FE 82 14 00 00 00 00 ?? ?? ?? 0? FF FF 84 24 E0 FE 82 50 FF FF 84 24 BD 04 02 24 DD FE 82 14 00 00 00 00 ?? ?? ?? 0? FF FF 84 24 D9 FE 82 50 FF FF 84 24 1C 01 82 28 29 00 40 10 21 01 02 24 15 01 02 24 D3 FE 82 50 FF FF 84 24 16 01 82 28 1C 00 40 10 17 01 02 24 13 01 02 24 CD FE 82 14 00 00 00 00 ?? ?? ?? 0? FF FF 84 24 C9 FE 82 50 FF FF 84 24 3F 01 82 28 74 04 40 10 48 01 02 24 31 01 02 24 C3 FE 82 50 49 00 04 24 32 01 82 28 53 04 40 10 37 01 02 24 2B 01 02 24 BD FE 82 50 FF FF 84 24 2C 01 82 28 32 04 40 10 2D 01 02 24 29 01 02 24 B7 FE 82 14 00 00 00 00 ?? ?? ?? 0? FF FF 84 24 B3 FE 82 50 FF FF 84 24 19 01 02 24 B0 FE 82 14 00 00 00 00 ?? ?? ?? 0? FF FF 84 24 AC FE 82 50 FF FF 84 24 22 01 82 28 47 00 40 10 23 01 02 24 1D 01 02 24 A6 FE 82 50 FF FF 84 24 1F 01 02 24 A3 FE 82 14 00 00 00 00 ?? ?? ?? 0? FF FF 84 24 9F FE 82 50 FF FF 84 24 84 01 82 28 5A 01 40 10 B0 01 02 24 6B 01 02 24 99 FE 82 50 FF FF 84 24 6C 01 82 28 44 01 40 10 75 01 02 24 5F 01 02 24 93 FE 82 50 FF FF 84 24 60 01 82 28 DE 00 40 10 65 01 02 24 59 01 02 24 8D FE 82 50 FF FF 84 24 5A 01 82 28 D1 00 40 10 5B 01 02 24 57 01 02 24 87 FE 82 14 00 00 00 00 ?? ?? ?? 0? FF FF 84 24 83 FE 82 50 2D FF 84 24 70 02 82 28 DB 00 40 10 F0 03 02 24 FD 01 02 24 7D FE 82 50 FF FF 84 24 FE 01 82 28 43 00 40 10 13 02 02 24 E3 01 02 24 77 FE 82 50 FF FF 84 24 E4 01 82 28 2D 00 40 10 ED 01 02 24 D8 01 02 24 71 FE 82 50 FF FF 84 24 D9 01 82 28 1A 00 40 10 DD 01 02 24 D2 01 02 24 6B FE 82 50 FF FF 84 24 D3 01 82 28 0D 00 40 10 D4 01 02 24 D0 01 02 24 65 FE 82 14 00 00 00 00 ?? ?? ?? 0? FF FF 84 24 61 FE 82 50 FF FF 84 24 25 01 02 24 5E FE 82 14 00 00 00 00 ?? ?? ?? 0? FF FF 84 24 5A FE 82 50 FF FF 84 24 D6 01 02 24 57 FE 82 14 00 00 00 00 ?? ?? ?? 0? FF FF 84 24 53 FE 82 50 B1 FF 84 24 DE 01 82 28 2B 01 40 10 DF 01 02 24 DA 01 02 24 4D FE 82 50 FF FF 84 24 DC 01 02 24 4A FE 82 14 00 00 00 00 ?? ?? ?? 0? FF FF 84 24 46 FE 82 50 FF FF 84 24 EE 01 82 28 29 00 40 10 F3 01 02 24 E7 01 02 24 40 FE 82 50 FF FF 84 24 E8 01 82 28 1C 00 40 10 E9 01 02 24 E5 01 02 24 3A FE 82 14 00 00 00 00 ?? ?? ?? 0? FF FF 84 24 36 FE 82 50 FF FF 84 24 14 02 82 28 48 00 40 10 59 02 02 24 07 02 02 24 30 FE 82 50 FF FF 84 24 08 02 82 28 35 00 40 10 0D 02 02 24 01 02 02 24 2A FE 82 50 FF FF 84 24 02 02 82 28 1A 00 40 10 03 02 02 24 FF 01 02 24 24 FE 82 14 00 00 00 00 ?? ?? ?? 0? FF FF 84 24 20 FE 82 50 FF FF 84 24 EB 01 02 24 1D FE 82 14 00 00 00 00 ?? ?? ?? 0? FF FF 84 24 19 FE 82 50 FE FF 84 24 F4 01 82 28 10 00 40 10 F5 01 02 24 EF 01 02 24 13 FE 82 50 FF FF 84 24 F2 01 02 24 10 FE 82 14 00 00 00 00 ?? ?? ?? 0? FF FF 84 24 0C FE 82 50 FF FF 84 24 05 02 02 24 09 FE 82 14 00 00 00 00 ?? ?? ?? 0? FF FF 84 24 05 FE 82 50 FF FF 84 24 FB 01 02 24 02 FE 82 14 00 00 00 00 ?? ?? ?? 0? FF FF 84 24 FE FD 82 50 FF FF 84 24 CC 01 02 24 FB FD 82 14 00 00 00 00 ?? ?? ?? 0? FE FF 84 24 F7 FD 82 50 FF FF 84 24 0E 02 82 28 19 00 40 10 0F 02 02 24 09 02 02 24 F1 FD 82 50 FF FF 84 24 0B 02 02 24 EE FD 82 14 00 00 00 00 ?? ?? ?? 0? FF FF 84 24 EA FD 82 50 8F 01 04 24 5A 02 82 28 18 00 40 10 63 02 02 24 17 02 02 24 E4 FD 82 50 FF FF 84 24 18 02 82 28 0D 00 40 10 53 02 02 24 15 02 02 24 DE FD 82 14 00 00 00 00 ?? ?? ?? 0? FF FF 84 24 DA FD 82 50 FF FF 84 24 11 02 02 24 D7 FD 82 14 00 00 00 00 ?? ?? ?? 0? FF FF 84 24 0F 00 82 10 54 02 83 38 86 01 02 24 ?? ?? ?? 0? 0A 20 43 00 CE FD 82 50 94 01 04 24 64 02 82 28 0B 00 40 10 68 02 02 24 5B 02 02 24 06 00 82 10 60 02 83 38 93 01 02 24 ?? ?? ?? 0? 0A 20 43 00 ?? ?? ?? 0? 81 01 04 24 ?? ?? ?? 0? 90 01 04 24 BF FD 82 50 97 01 04 24 69 02 02 24 BC FD 82 14 00 00 00 00 ?? ?? ?? 0? 2D FF 84 24 B8 FD 82 50 FF FF 84 24 5D 01 02 24 B5 FD 82 14 00 00 00 00 ?? ?? ?? 0? FF FF 84 24 B1 FD 82 50 FF FF 84 24 66 01 82 28 24 00 40 10 67 01 02 24 61 01 02 24 AB FD 82 50 FF FF 84 24 63 01 02 24 A8 FD 82 14 00 00 00 00 ?? ?? ?? 0? FF FF 84 24 A4 FD 82 50 9A 03 04 24 F1 03 82 28 83 00 40 10 71 04 02 24 D0 03 02 24 9E FD 82 50 92 03 04 24 D1 03 82 28 33 00 40 10 E5 03 02 24 88 02 02 24 98 FD 82 50 26 FF 84 24 89 02 82 28 19 00 40 10 AC 03 02 24 75 02 02 24 92 FD 82 50 9F 01 04 24 76 02 82 28 0C 00 40 50 80 02 02 24 72 02 83 38 9D 01 02 24 ?? ?? ?? 0? 0A 20 43 00 89 FD 82 50 FF FF 84 24 69 01 02 24 86 FD 82 14 00 00 00 00 ?? ?? ?? 0? FF FF 84 24 82 FD 82 50 26 FF 84 24 83 02 02 24 7F FD 82 14 00 00 00 00 ?? ?? ?? 0? 26 FF 84 24 7B FD 82 50 86 03 04 24 AD 03 82 28 09 00 40 10 C2 03 02 24 92 02 02 24 75 FD 82 50 B7 01 04 24 45 03 02 24 72 FD 82 14 00 00 00 00 ?? ?? ?? 0? 99 03 04 24 04 00 82 10 CC 03 83 38 8C 03 02 24 ?? ?? ?? 0? 0A 20 43 00 ?? ?? ?? 0? A3 03 04 24 67 FD 82 50 FF FF 84 24 E6 03 82 28 97 00 40 10 EB 03 02 24 D5 03 02 24 61 FD 82 50 A6 03 04 24 D6 03 82 28 05 00 40 50 D6 03 02 24 D1 03 83 38 98 03 02 24 ?? ?? ?? 0? 0A 20 43 00 58 FD 82 50 A0 03 04 24 E3 03 02 24 55 FD 82 14 00 00 00 00 ?? ?? ?? 0? FF FF 84 24 51 FD 82 50 FF FF 84 24 76 01 82 28 9C 00 40 10 7C 01 02 24 6F 01 02 24 4B FD 82 50 FF FF 84 24 70 01 82 28 1C 00 40 10 71 01 02 24 6D 01 02 24 45 FD 82 14 00 00 00 00 ?? ?? ?? 0? FF FF 84 24 41 FD 82 50 FF FF 84 24 B1 01 82 28 B2 00 40 10 C5 01 02 24 99 01 02 24 3B FD 82 50 FF FF 84 24 9A 01 82 28 9F 00 40 10 A5 01 02 24 88 01 02 24 35 FD 82 50 FF FF 84 24 89 01 82 28 8D 00 40 10 8C 01 02 24 85 01 02 24 2F FD 82 14 00 00 00 00 ?? ?? ?? 0? FF FF 84 24 2B FD 82 50 FF FF 84 24 73 01 02 24 28 FD 82 14 00 00 00 00 ?? ?? ?? 0? FF FF 84 24 24 FD 82 50 FF FF 84 24 E1 01 02 24 21 FD 82 14 00 00 00 00 ?? ?? ?? 0? FF FF 84 24 1D FD 82 50 FF FF 84 24 72 04 82 28 22 00 40 10 7B 04 02 24 65 04 02 24 17 FD 82 50 FF FF 84 24 66 04 82 28 0F 00 40 10 6B 04 02 24 F2 03 02 24 11 FD 82 50 B1 FF 84 24 F2 03 82 28 0E FD 40 54 A1 03 04 24 61 04 02 24 0B FD 82 50 FF FF 84 24 63 04 02 24 08 FD 82 14 00 00 00 00 ?? ?? ?? 0? FF FF 84 24 04 FD 82 50 FF FF 84 24 6C 04 82 28 19 00 40 10 6D 04 02 24 67 04 02 24 FE FC 82 50 FF FF 84 24 69 04 02 24 FB FC 82 14 00 00 00 00 ?? ?? ?? 0? FF FF 84 24 F7 FC 82 50 FF FF 84 24 7C 04 82 28 1A 00 40 10 81 04 02 24 75 04 02 24 F1 FC 82 50 FF FF 84 24 76 04 82 28 0D 00 40 10 77 04 02 24 73 04 02 24 EB FC 82 14 00 00 00 00 ?? ?? ?? 0? FF FF 84 24 E7 FC 82 50 FF FF 84 24 6F 04 02 24 E4 FC 82 14 00 00 00 00 ?? ?? ?? 0? FF FF 84 24 E0 FC 82 50 FF FF 84 24 79 04 02 24 DD FC 82 14 00 00 00 00 ?? ?? ?? 0? FF FF 84 24 D9 FC 82 50 FF FF 84 24 82 04 82 28 16 00 40 10 91 04 02 24 7D 04 02 24 D3 FC 82 50 FF FF 84 24 7F 04 02 24 D0 FC 82 14 00 00 00 00 ?? ?? ?? 0? FF FF 84 24 CC FC 82 50 FF FF 84 24 EC 03 82 28 10 00 40 10 ED 03 02 24 E7 03 02 24 C6 FC 82 50 FF FF 84 24 E9 03 02 24 C3 FC 82 14 00 00 00 00 ?? ?? ?? 0? FF FF 84 24 BF FC 82 50 FF FF 84 24 93 04 02 24 BC FC 82 14 00 00 00 00 ?? ?? ?? 0? FF FF 84 24 B8 FC 82 50 FF FF 84 24 EF 03 02 24 B5 FC 82 14 00 00 00 00 ?? ?? ?? 0? FF FF 84 24 B1 FC 82 50 }
	condition:
		$1
}

rule file_41_34_0 {
	meta:
		name = "uisspace"
		size = 144
	strings:
		$1 = { 20 00 02 24 20 00 82 10 00 00 00 00 09 00 02 24 1D 00 82 10 00 00 00 00 0D 00 02 24 1A 00 82 10 00 00 00 00 0A 00 02 24 17 00 82 10 00 00 00 00 0C 00 02 24 14 00 82 10 00 00 00 00 0B 00 02 24 11 00 82 10 00 00 00 00 80 16 02 24 0E 00 82 10 00 00 00 00 00 E0 82 24 0B 00 42 2C 0A 00 40 14 00 00 00 00 28 20 02 24 07 00 82 10 00 00 00 00 2F 20 02 24 04 00 82 10 00 00 00 00 00 30 82 38 08 00 E0 03 01 00 42 2C 08 00 E0 03 01 00 02 24 }
	condition:
		$1
}

rule file_41_36_0 {
	meta:
		name = "ustrsize"
		size = 84
		refs = "001c ugetxc"
	strings:
		$1 = { E8 FF BD 27 10 00 B2 AF 0C 00 B1 AF 14 00 BF AF 08 00 B0 AF 00 00 A4 AF 21 90 80 00 ?? ?? 11 3C ?? ?? 23 8E 21 20 A0 03 09 F8 60 00 00 00 B0 8F FC FF 40 14 ?? ?? 23 8E 14 00 BF 8F 23 10 12 02 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_41_37_0 {
	meta:
		name = "ustrsizez"
		size = 76
		refs = "0018 ugetxc"
	strings:
		$1 = { E8 FF BD 27 10 00 B1 AF 0C 00 B0 AF 14 00 BF AF 00 00 A4 AF 21 88 80 00 ?? ?? 10 3C ?? ?? 03 8E 09 F8 60 00 21 20 A0 03 FD FF 40 14 ?? ?? 03 8E 00 00 A2 8F 14 00 BF 8F 0C 00 B0 8F 23 10 51 00 10 00 B1 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_41_38_0 {
	meta:
		name = "ustrzcpy"
		size = 212
		refs = "0008 ucwidth 004c .text 0070 usetc 0080 ugetxc"
	strings:
		$1 = { D8 FF BD 27 20 00 B6 AF ?? ?? 16 3C ?? ?? C3 8E 1C 00 B5 AF 18 00 B4 AF 14 00 B3 AF 10 00 B2 AF 0C 00 B1 AF 08 00 B0 AF 24 00 BF AF 00 00 A6 AF 21 98 80 00 21 20 00 00 09 F8 60 00 21 80 A0 00 23 88 02 02 21 90 00 00 ?? ?? 15 3C ?? ?? ?? 0? ?? ?? 14 3C ?? ?? C3 8E 09 F8 60 00 00 00 00 00 23 88 22 02 21 28 00 02 0B 00 20 06 21 20 72 02 ?? ?? A3 8E 09 F8 60 00 00 00 00 00 21 90 42 02 ?? ?? 83 8E 09 F8 60 00 21 20 A0 03 21 80 40 00 F0 FF 40 14 21 20 40 00 ?? ?? A3 8E 21 20 72 02 09 F8 60 00 21 28 00 00 24 00 BF 8F 21 10 60 02 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_41_39_0 {
	meta:
		name = "_ustrdup"
		size = 140
		refs = "0018 ustrsizez 003c ustrzcpy 0060 allegro_errno"
	strings:
		$1 = { F0 FF BD 27 0C 00 BF AF 08 00 B2 AF 04 00 B1 AF 00 00 B0 AF 21 90 80 00 ?? ?? ?? 0? 21 80 A0 00 21 20 40 00 09 F8 00 02 21 88 40 00 0C 00 40 10 21 80 40 00 21 28 20 02 21 30 40 02 ?? ?? ?? 0? 21 20 40 00 0C 00 BF 8F 21 10 00 02 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 10 00 BD 27 ?? ?? 02 3C ?? ?? 44 8C 0C 00 BF 8F 0C 00 03 24 21 10 00 02 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 00 00 83 AC 08 00 E0 03 10 00 BD 27 }
	condition:
		$1
}

rule file_41_40_0 {
	meta:
		name = "ustrzcat"
		size = 220
		refs = "0030 ustrsize 0038 ucwidth 0054 .text 0078 usetc 0088 ugetxc"
	strings:
		$1 = { D8 FF BD 27 20 00 B6 AF ?? ?? 16 3C 24 00 BF AF 1C 00 B5 AF 18 00 B4 AF 14 00 B3 AF 10 00 B2 AF 0C 00 B1 AF 08 00 B0 AF 00 00 A6 AF 21 80 A0 00 ?? ?? ?? 0? 21 98 80 00 ?? ?? C3 8E 21 90 40 00 09 F8 60 00 21 20 00 00 23 80 12 02 ?? ?? 15 3C 23 88 02 02 ?? ?? ?? 0? ?? ?? 14 3C ?? ?? C3 8E 09 F8 60 00 00 00 00 00 23 88 22 02 21 28 00 02 0B 00 20 06 21 20 72 02 ?? ?? A3 8E 09 F8 60 00 00 00 00 00 21 90 42 02 ?? ?? 83 8E 09 F8 60 00 21 20 A0 03 21 80 40 00 F0 FF 40 14 21 20 40 00 ?? ?? A3 8E 21 20 72 02 09 F8 60 00 21 28 00 00 24 00 BF 8F 21 10 60 02 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_41_41_0 {
	meta:
		name = "ustrlen"
		size = 72
		refs = "0018 ugetxc"
	strings:
		$1 = { E8 FF BD 27 10 00 B1 AF 0C 00 B0 AF 14 00 BF AF 00 00 A4 AF 21 80 00 00 ?? ?? 11 3C ?? ?? 23 8E 09 F8 60 00 21 20 A0 03 FC FF 40 54 01 00 10 26 14 00 BF 8F 21 10 00 02 10 00 B1 8F 0C 00 B0 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_41_42_0 {
	meta:
		name = "uoffset"
		size = 132
		refs = "0034 ugetxc 0074 ustrlen 007c .text"
	strings:
		$1 = { E0 FF BD 27 18 00 B3 AF 0C 00 B0 AF 1C 00 BF AF 14 00 B2 AF 10 00 B1 AF 21 80 A0 00 00 00 A4 AF 14 00 A0 04 21 98 80 00 ?? ?? 12 3C 08 00 00 1A 21 20 A0 03 ?? ?? 43 8E 00 00 B1 8F 09 F8 60 00 FF FF 10 26 F9 FF 40 14 00 00 00 00 00 00 B1 AF 00 00 A2 8F 1C 00 BF 8F 14 00 B2 8F 23 10 53 00 18 00 B3 8F 10 00 B1 8F 0C 00 B0 8F 08 00 E0 03 20 00 BD 27 ?? ?? ?? 0? ?? ?? 12 3C ?? ?? ?? 0? 21 80 02 02 }
	condition:
		$1
}

rule file_41_43_0 {
	meta:
		name = "ugetat"
		size = 56
		refs = "0000 ugetc 0018 uoffset"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 8C F0 FF BD 27 0C 00 BF AF 08 00 B0 AF 00 00 A2 AF ?? ?? ?? 0? 21 80 80 00 00 00 B9 8F 21 20 02 02 0C 00 BF 8F 08 00 B0 8F 08 00 20 03 10 00 BD 27 }
	condition:
		$1
}

rule file_41_44_0 {
	meta:
		name = "ustrcmp"
		size = 132
		refs = "001c ugetxc"
	strings:
		$1 = { E8 FF BD 27 10 00 B2 AF 0C 00 B1 AF 14 00 BF AF 08 00 B0 AF 00 00 A4 AF 04 00 A5 AF ?? ?? 11 3C 04 00 B2 27 ?? ?? 23 8E 09 F8 60 00 21 20 A0 03 ?? ?? 23 8E 21 20 40 02 09 F8 60 00 21 80 40 00 0A 00 02 16 14 00 BF 8F F7 FF 00 16 ?? ?? 23 8E 14 00 BF 8F 21 10 00 00 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 E0 03 18 00 BD 27 23 10 02 02 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_41_45_0 {
	meta:
		name = "ustrzncpy"
		size = 368
		refs = "0030 ucwidth 007c .text 00a4 usetc 00b4 ugetxc"
	strings:
		$1 = { D0 FF BD 27 1C 00 B5 AF FF 7F 02 3C 21 A8 80 00 FF FF 04 24 04 00 A4 AF FF FF 42 34 26 10 A2 00 08 00 B0 AF 21 80 A0 00 04 00 A5 8F 20 00 B6 AF ?? ?? 16 3C ?? ?? C3 8E 0B 28 02 00 28 00 BE AF 24 00 B7 AF 18 00 B4 AF 14 00 B3 AF 10 00 B2 AF 0C 00 B1 AF 2C 00 BF AF 00 00 A6 AF 21 20 00 00 04 00 A5 AF 09 F8 60 00 21 A0 E0 00 23 98 02 02 21 90 00 00 21 88 00 00 ?? ?? 17 3C ?? ?? ?? 0? ?? ?? 1E 3C 25 00 40 10 ?? ?? C3 8E 09 F8 60 00 00 00 00 00 23 98 62 02 21 28 00 02 0F 00 60 06 21 20 B2 02 ?? ?? C3 8F 09 F8 60 00 01 00 31 26 21 90 42 02 ?? ?? E3 8E 09 F8 60 00 21 20 A0 03 21 80 40 00 21 20 40 00 EE FF 00 16 2A 10 34 02 2A 10 34 02 12 00 40 10 04 00 A2 8F ?? ?? ?? 0? ?? ?? 10 3C ?? ?? 03 8E 09 F8 60 00 00 00 00 00 2A 20 34 02 09 00 80 10 21 90 42 02 ?? ?? C3 8E 21 20 00 00 09 F8 60 00 01 00 31 26 23 98 62 02 21 20 B2 02 F3 FF 61 06 21 28 00 00 04 00 A2 8F 07 00 40 14 2C 00 BF 8F ?? ?? 02 3C ?? ?? 43 8C 21 20 B2 02 09 F8 60 00 21 28 00 00 2C 00 BF 8F 21 10 A0 02 28 00 BE 8F 24 00 B7 8F 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_41_46_0 {
	meta:
		name = "ustrzncat"
		size = 256
		refs = "0008 ucwidth 003c ustrsize 0064 .text 008c usetc 009c ugetxc"
	strings:
		$1 = { D0 FF BD 27 28 00 BE AF ?? ?? 1E 3C 2C 00 BF AF 24 00 B7 AF 20 00 B6 AF 1C 00 B5 AF 18 00 B4 AF 14 00 B3 AF 10 00 B2 AF 0C 00 B1 AF 08 00 B0 AF 00 00 A6 AF 21 80 A0 00 21 A8 E0 00 ?? ?? ?? 0? 21 A0 80 00 ?? ?? C3 8F 21 98 40 00 09 F8 60 00 21 20 00 00 23 80 13 02 21 90 00 00 23 88 02 02 ?? ?? 17 3C ?? ?? ?? 0? ?? ?? 16 3C 13 00 40 10 ?? ?? C3 8F 09 F8 60 00 00 00 00 00 23 88 22 02 21 28 00 02 0D 00 20 06 21 20 93 02 ?? ?? E3 8E 09 F8 60 00 00 00 00 00 21 98 62 02 ?? ?? C3 8E 09 F8 60 00 21 20 A0 03 21 80 40 00 21 20 40 00 2A 10 55 02 ED FF 00 16 01 00 52 26 ?? ?? E3 8E 21 20 93 02 09 F8 60 00 21 28 00 00 2C 00 BF 8F 21 10 80 02 28 00 BE 8F 24 00 B7 8F 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_41_47_0 {
	meta:
		name = "ustrncmp"
		size = 164
		refs = "0028 ugetxc"
	strings:
		$1 = { E0 FF BD 27 10 00 B1 AF 1C 00 BF AF 18 00 B3 AF 14 00 B2 AF 0C 00 B0 AF 21 88 C0 00 00 00 A4 AF 11 00 C0 18 04 00 A5 AF ?? ?? 12 3C 04 00 B3 27 ?? ?? 43 8E 21 20 A0 03 09 F8 60 00 FF FF 31 26 ?? ?? 43 8E 21 20 60 02 09 F8 60 00 21 80 40 00 0D 00 02 16 1C 00 BF 8F 05 00 00 12 21 10 00 00 F4 FF 20 1E ?? ?? 43 8E 1C 00 BF 8F 21 10 00 00 18 00 B3 8F 14 00 B2 8F 10 00 B1 8F 0C 00 B0 8F 08 00 E0 03 20 00 BD 27 23 10 02 02 18 00 B3 8F 14 00 B2 8F 10 00 B1 8F 0C 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_41_48_0 {
	meta:
		name = "ustricmp"
		size = 148
		refs = "001c ugetxc 0030 utolower"
	strings:
		$1 = { E8 FF BD 27 10 00 B2 AF 0C 00 B1 AF 14 00 BF AF 08 00 B0 AF 00 00 A4 AF 04 00 A5 AF ?? ?? 11 3C 04 00 B2 27 ?? ?? 23 8E 09 F8 60 00 21 20 A0 03 ?? ?? ?? 0? 21 20 40 00 ?? ?? 23 8E 21 20 40 02 09 F8 60 00 21 80 40 00 ?? ?? ?? 0? 21 20 40 00 0A 00 02 16 14 00 BF 8F F3 FF 00 16 ?? ?? 23 8E 14 00 BF 8F 21 10 00 00 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 E0 03 18 00 BD 27 23 10 02 02 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_41_49_0 {
	meta:
		name = "ustrnicmp"
		size = 180
		refs = "0028 ugetxc 0040 utolower"
	strings:
		$1 = { E0 FF BD 27 10 00 B1 AF 1C 00 BF AF 18 00 B3 AF 14 00 B2 AF 0C 00 B0 AF 21 88 C0 00 00 00 A4 AF 15 00 C0 18 04 00 A5 AF ?? ?? 12 3C 04 00 B3 27 ?? ?? 43 8E 21 20 A0 03 09 F8 60 00 FF FF 31 26 ?? ?? ?? 0? 21 20 40 00 ?? ?? 43 8E 21 20 60 02 09 F8 60 00 21 80 40 00 ?? ?? ?? 0? 21 20 40 00 0D 00 02 16 1C 00 BF 8F 05 00 00 12 21 10 00 00 F0 FF 20 1E ?? ?? 43 8E 1C 00 BF 8F 21 10 00 00 18 00 B3 8F 14 00 B2 8F 10 00 B1 8F 0C 00 B0 8F 08 00 E0 03 20 00 BD 27 23 10 02 02 18 00 B3 8F 14 00 B2 8F 10 00 B1 8F 0C 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_41_50_0 {
	meta:
		name = "ustrchr"
		size = 148
		refs = "0028 uwidth 0024 .text 0040 ugetc"
	strings:
		$1 = { E8 FF BD 27 10 00 B3 AF 0C 00 B2 AF 08 00 B1 AF 04 00 B0 AF 14 00 BF AF 21 80 80 00 21 88 A0 00 ?? ?? 12 3C ?? ?? ?? 0? ?? ?? 13 3C 11 00 51 10 ?? ?? 63 8E 09 F8 60 00 00 00 00 00 21 80 02 02 ?? ?? 43 8E 09 F8 60 00 21 20 00 02 F7 FF 40 14 21 20 00 02 14 00 BF 8F 0A 10 11 02 10 00 B3 8F 0C 00 B2 8F 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 18 00 BD 27 14 00 BF 8F 21 10 00 02 10 00 B3 8F 0C 00 B2 8F 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_41_51_0 {
	meta:
		name = "ustrrchr"
		size = 188
		refs = "0044 ucwidth 0008 ugetc 0040 .text"
	strings:
		$1 = { E0 FF BD 27 18 00 B5 AF ?? ?? 15 3C ?? ?? A3 8E 0C 00 B2 AF 08 00 B1 AF 1C 00 BF AF 14 00 B4 AF 10 00 B3 AF 04 00 B0 AF 21 90 A0 00 09 F8 60 00 21 88 80 00 18 00 40 10 21 80 00 00 21 A0 00 00 ?? ?? ?? 0? ?? ?? 13 3C 09 F8 60 00 00 00 00 00 ?? ?? A3 8E 21 80 02 02 09 F8 60 00 21 20 30 02 0D 00 40 50 21 10 80 02 ?? ?? 63 8E F6 FF 52 14 21 20 40 00 09 F8 60 00 21 A0 30 02 ?? ?? A3 8E 21 80 02 02 09 F8 60 00 21 20 30 02 F7 FF 40 14 ?? ?? 63 8E 21 10 80 02 1C 00 BF 8F 18 00 B5 8F 14 00 B4 8F 10 00 B3 8F 0C 00 B2 8F 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_41_52_0 {
	meta:
		name = "ustrstr"
		size = 188
		refs = "0038 uwidth 0024 ustrlen 0034 .text 003c ustrncmp 0030 ugetc"
	strings:
		$1 = { E8 FF BD 27 00 00 B0 AF 21 80 80 00 21 20 A0 00 10 00 B4 AF 0C 00 B3 AF 08 00 B2 AF 04 00 B1 AF 14 00 BF AF ?? ?? ?? 0? 21 90 A0 00 21 88 40 00 ?? ?? 13 3C ?? ?? ?? 0? ?? ?? 14 3C ?? ?? ?? 0? 00 00 00 00 14 00 40 10 21 20 00 02 ?? ?? 83 8E 09 F8 60 00 00 00 00 00 21 80 02 02 ?? ?? 63 8E 09 F8 60 00 21 20 00 02 21 20 00 02 21 28 40 02 F2 FF 40 14 21 30 20 02 14 00 BF 8F 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 18 00 BD 27 14 00 BF 8F 21 10 00 02 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_41_53_0 {
	meta:
		name = "ustrpbrk"
		size = 168
		refs = "0030 uwidth 0028 ugetc 004c ugetxc 0098 .text"
	strings:
		$1 = { D8 FF BD 27 20 00 B5 AF 1C 00 B4 AF 18 00 B3 AF 14 00 B2 AF 10 00 B1 AF 24 00 BF AF 0C 00 B0 AF 21 88 80 00 21 98 A0 00 ?? ?? 14 3C ?? ?? 12 3C ?? ?? 15 3C ?? ?? 83 8E 09 F8 60 00 21 20 20 02 17 00 40 10 21 80 40 00 00 00 B3 AF ?? ?? 43 8E 09 F8 60 00 21 20 A0 03 0D 00 40 10 ?? ?? A3 8E FB FF 02 16 ?? ?? 43 8E 21 10 20 02 24 00 BF 8F 20 00 B5 8F 1C 00 B4 8F 18 00 B3 8F 14 00 B2 8F 10 00 B1 8F 0C 00 B0 8F 08 00 E0 03 28 00 BD 27 09 F8 60 00 21 20 20 02 ?? ?? ?? 0? 21 88 22 02 ?? ?? ?? 0? 21 10 00 00 }
	condition:
		$1
}

rule file_41_54_0 {
	meta:
		name = "sprint_i"
		size = 320
		refs = "004c __umoddi3 0068 __udivdi3 0090 usetc 00bc .text"
	strings:
		$1 = { C0 FF BD 27 28 00 B3 AF 04 00 93 8C 38 00 B7 AF 34 00 B6 AF 24 00 B2 AF 20 00 B1 AF 1C 00 B0 AF 3C 00 BF AF 30 00 B5 AF 2C 00 B4 AF 21 B0 80 00 21 80 C0 00 21 88 E0 00 21 B8 00 01 21 90 00 00 21 20 00 02 21 28 20 02 0A 00 06 24 ?? ?? ?? 0? 21 38 00 00 21 18 B2 03 21 20 00 02 21 28 20 02 0A 00 06 24 21 38 00 00 ?? ?? ?? 0? 00 00 62 A0 21 80 40 00 25 10 43 00 21 88 60 00 F0 FF 40 14 01 00 52 26 2A 10 57 02 2B 00 40 10 21 A8 40 02 ?? ?? 14 3C 00 00 C4 8E ?? ?? 86 8E 01 00 B5 26 21 20 93 00 09 F8 C0 00 30 00 05 24 2A 18 B7 02 F8 FF 60 14 21 98 62 02 FF FF 51 26 ?? ?? ?? 0? 21 80 B1 03 FF FF 31 26 00 00 05 82 00 00 C4 8E ?? ?? 83 8E 30 00 A5 24 09 F8 60 00 21 20 93 00 21 98 62 02 F7 FF 20 16 FF FF 10 26 00 00 C4 8E ?? ?? 02 3C ?? ?? 43 8C 04 00 D3 AE 21 20 93 00 09 F8 60 00 21 28 00 00 3C 00 BF 8F 21 10 A0 02 38 00 B7 8F 34 00 B6 8F 30 00 B5 8F 2C 00 B4 8F 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 40 00 BD 27 ?? ?? ?? 0? ?? ?? 14 3C }
	condition:
		$1
}

rule file_41_55_0 {
	meta:
		name = "sprint_int"
		size = 396
		refs = "00c4 ucwidth 0000 .data 0078 _al_malloc 008c usetc 00b0 .text"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 48 8C ?? ?? 02 3C E8 FF BD 27 ?? ?? 4A 24 10 00 B4 AF 0C 00 B3 AF 08 00 B2 AF 04 00 B1 AF 04 00 A9 8C 21 88 A0 00 21 90 80 00 14 00 BF AF 00 00 B0 AF 21 A0 C0 00 21 98 E0 00 21 18 40 01 21 20 00 00 08 00 05 24 00 00 62 8C 19 00 02 11 20 00 63 24 01 00 84 24 FC FF 85 54 00 00 62 8C ?? ?? 02 3C ?? ?? 43 8C 21 20 00 00 09 F8 60 00 21 80 00 00 ?? ?? ?? 0? 21 20 02 02 21 20 40 00 1E 00 61 06 00 00 42 AE ?? ?? 02 3C ?? ?? 47 8C 23 18 14 00 2B 10 03 00 23 30 13 00 2D 00 05 24 21 A0 60 00 09 F8 E0 00 23 98 C2 00 ?? ?? ?? 0? 01 00 03 24 40 11 04 00 21 10 42 01 E9 FF 40 50 ?? ?? 02 3C 1C 00 43 8C 18 00 02 24 2C 10 22 01 18 00 43 00 ?? ?? 02 3C ?? ?? 43 8C 21 20 00 00 09 F8 60 00 12 80 00 00 ?? ?? ?? 0? 21 20 02 02 21 20 40 00 E4 FF 60 06 00 00 42 AE 00 00 23 8E 02 00 62 30 16 00 40 14 ?? ?? 02 3C 04 00 62 30 18 00 40 54 ?? ?? 02 3C 21 18 00 00 0C 00 23 AE 04 00 42 AE 08 00 28 8E 21 20 40 02 21 30 80 02 ?? ?? ?? 0? 21 38 60 02 0C 00 23 8E 14 00 BF 8F 10 00 B4 8F 21 10 43 00 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 18 00 BD 27 ?? ?? 43 8C 09 F8 60 00 2B 00 05 24 ?? ?? ?? 0? 01 00 03 24 ?? ?? 43 8C 09 F8 60 00 20 00 05 24 ?? ?? ?? 0? 01 00 03 24 }
	condition:
		$1
}

rule file_41_56_0 {
	meta:
		name = "sprint_unsigned"
		size = 364
		refs = "00cc ucwidth 0000 .data 0078 _al_malloc 0098 usetc 00b8 .text"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 48 8C ?? ?? 02 3C E8 FF BD 27 ?? ?? 4A 24 10 00 B5 AF 0C 00 B4 AF 08 00 B2 AF 00 00 B0 AF 04 00 A9 8C 21 80 A0 00 21 90 80 00 14 00 BF AF 04 00 B1 AF 21 A0 C0 00 21 A8 E0 00 21 18 40 01 21 20 00 00 08 00 05 24 00 00 62 8C 1B 00 02 11 20 00 63 24 01 00 84 24 FC FF 85 54 00 00 62 8C ?? ?? 02 3C ?? ?? 43 8C 21 20 00 00 09 F8 60 00 21 88 00 00 ?? ?? ?? 0? 21 20 22 02 00 00 03 8E 21 20 40 00 00 00 42 AE 02 00 62 30 20 00 40 10 04 00 62 30 ?? ?? 02 3C ?? ?? 43 8C 2B 00 05 24 09 F8 60 00 00 00 00 00 21 18 40 00 0C 00 02 8E 01 00 42 24 ?? ?? ?? 0? 0C 00 02 AE 40 11 04 00 21 10 42 01 E7 FF 40 50 ?? ?? 02 3C 1C 00 43 8C 18 00 02 24 2C 10 22 01 18 00 43 00 ?? ?? 02 3C ?? ?? 43 8C 21 20 00 00 09 F8 60 00 12 88 00 00 ?? ?? ?? 0? 21 20 22 02 00 00 03 8E 21 20 40 00 00 00 42 AE 02 00 62 30 E2 FF 40 14 04 00 62 30 12 00 40 14 ?? ?? 02 3C 21 18 00 00 04 00 43 AE 08 00 08 8E 21 20 40 02 21 30 80 02 ?? ?? ?? 0? 21 38 A0 02 0C 00 03 8E 14 00 BF 8F 10 00 B5 8F 21 10 43 00 0C 00 B4 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 18 00 BD 27 ?? ?? 43 8C ?? ?? ?? 0? 20 00 05 24 }
	condition:
		$1
}

rule file_41_57_0 {
	meta:
		name = "sprint_hex"
		size = 672
		refs = "01ec ucwidth 0000 .data 008c _al_malloc 00ac usetc 0158 .text"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 47 8C ?? ?? 02 3C C0 FF BD 27 ?? ?? 4B 24 38 00 BE AF 34 00 B7 AF 30 00 B6 AF 28 00 B4 AF 24 00 B3 AF 21 B8 A0 00 04 00 AA 8C 21 B0 80 00 3C 00 BF AF 2C 00 B5 AF 20 00 B2 AF 1C 00 B1 AF 18 00 B0 AF 21 F0 C0 00 21 98 00 01 21 A0 20 01 21 18 60 01 21 20 00 00 08 00 05 24 00 00 62 8C 5E 00 E2 10 20 00 63 24 01 00 84 24 FC FF 85 54 00 00 62 8C ?? ?? 02 3C ?? ?? 43 8C 21 20 00 00 09 F8 60 00 21 80 00 00 ?? ?? ?? 0? 21 20 02 02 00 00 E3 8E 21 20 40 00 00 00 C2 AE 02 00 62 30 63 00 40 10 04 00 62 30 ?? ?? 15 3C ?? ?? A3 8E 2B 00 05 24 09 F8 60 00 00 00 00 00 21 90 40 00 0C 00 E2 8E 00 00 E3 8E 01 00 42 24 0C 00 E2 AE 08 00 62 30 5C 00 40 54 00 00 C4 8E 21 88 00 00 00 1F 14 00 02 21 13 00 0F 00 65 32 02 A1 14 00 25 98 64 00 21 10 B1 03 25 18 74 02 00 00 45 A0 F7 FF 60 14 01 00 31 26 08 00 E2 8E 2A 10 22 02 0B 00 40 10 21 98 20 02 00 00 C4 8E ?? ?? A6 8E 30 00 05 24 09 F8 C0 00 21 20 92 00 08 00 E3 8E 01 00 73 26 2A 18 63 02 F7 FF 60 14 21 90 42 02 50 00 C0 17 ?? ?? 02 3C ?? ?? 02 3C ?? ?? 54 24 FF FF 31 26 ?? ?? ?? 0? 21 80 B1 03 FF FF 31 26 00 00 02 82 00 00 C4 8E ?? ?? A3 8E 21 10 82 02 00 00 45 80 21 20 92 00 09 F8 60 00 FF FF 10 26 F6 FF 20 16 21 90 42 02 00 00 C4 8E ?? ?? 02 3C ?? ?? 43 8C 04 00 D2 AE 21 20 92 00 09 F8 60 00 21 28 00 00 0C 00 E2 8E 3C 00 BF 8F 38 00 BE 8F 21 10 62 02 34 00 B7 8F 30 00 B6 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 40 00 BD 27 40 11 04 00 21 10 62 01 A4 FF 40 50 ?? ?? 02 3C 1C 00 43 8C 18 00 02 24 2C 10 42 01 18 00 43 00 ?? ?? 02 3C ?? ?? 43 8C 21 20 00 00 09 F8 60 00 12 80 00 00 ?? ?? ?? 0? 21 20 02 02 00 00 E3 8E 21 20 40 00 00 00 C2 AE 02 00 62 30 9F FF 40 14 04 00 62 30 16 00 40 14 08 00 62 30 21 90 00 00 A7 FF 40 10 ?? ?? 15 3C 00 00 C4 8E ?? ?? A3 8E 30 00 05 24 09 F8 60 00 21 20 92 00 00 00 C4 8E ?? ?? A6 8E 21 80 52 00 21 20 90 00 09 F8 C0 00 78 00 05 24 0C 00 E3 8E 21 90 02 02 02 00 63 24 ?? ?? ?? 0? 0C 00 E3 AE ?? ?? ?? 0? ?? ?? 54 24 ?? ?? 15 3C ?? ?? A3 8E ?? ?? ?? 0? 20 00 05 24 }
	condition:
		$1
}

rule file_41_58_0 {
	meta:
		name = "_al_ustrdup"
		size = 92
		refs = "0014 ustrsizez 0020 _al_malloc 0038 ustrzcpy"
	strings:
		$1 = { F0 FF BD 27 0C 00 BF AF 08 00 B2 AF 04 00 B1 AF 00 00 B0 AF ?? ?? ?? 0? 21 90 80 00 21 20 40 00 ?? ?? ?? 0? 21 88 40 00 05 00 40 10 21 80 40 00 21 28 20 02 21 30 40 02 ?? ?? ?? 0? 21 20 40 00 0C 00 BF 8F 21 10 00 02 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 10 00 BD 27 }
	condition:
		$1
}

rule file_41_59_0 {
	meta:
		name = "uremove"
		size = 108
		refs = "0014 uoffset 001c uwidth 0038 ustrsizez 0048 memmove"
	strings:
		$1 = { F0 FF BD 27 0C 00 BF AF 08 00 B2 AF 04 00 B1 AF 00 00 B0 AF ?? ?? ?? 0? 21 80 80 00 ?? ?? 03 3C ?? ?? 65 8C 21 80 02 02 09 F8 A0 00 21 20 00 02 21 88 02 02 21 20 20 02 ?? ?? ?? 0? 21 90 40 00 21 30 40 00 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 0C 00 BF 8F 23 10 12 00 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 10 00 BD 27 }
	condition:
		$1
}

rule file_41_60_0 {
	meta:
		name = "uinsert"
		size = 148
		refs = "0000 ucwidth 003c uoffset 0048 ustrsizez 0058 memmove 0060 usetc"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 43 8C E8 FF BD 27 14 00 BF AF 10 00 B3 AF 0C 00 B2 AF 08 00 B1 AF 04 00 B0 AF 21 88 A0 00 21 80 80 00 21 20 C0 00 09 F8 60 00 21 98 C0 00 21 28 20 02 21 20 00 02 ?? ?? ?? 0? 21 90 40 00 21 80 02 02 ?? ?? ?? 0? 21 20 00 02 21 30 40 00 21 20 12 02 ?? ?? ?? 0? 21 28 00 02 ?? ?? 03 3C ?? ?? 66 8C 21 20 00 02 09 F8 C0 00 21 28 60 02 14 00 BF 8F 21 10 40 02 10 00 B3 8F 0C 00 B2 8F 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_41_61_0 {
	meta:
		name = "usetat"
		size = 172
		refs = "0020 uoffset 0028 uwidth 0040 ucwidth 005c ustrsizez 006c memmove 0074 usetc"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF 10 00 B4 AF 0C 00 B3 AF 21 A0 C0 00 08 00 B2 AF 04 00 B1 AF 00 00 B0 AF ?? ?? ?? 0? 21 80 80 00 ?? ?? 03 3C ?? ?? 65 8C 21 90 02 02 09 F8 A0 00 21 20 40 02 21 98 40 00 ?? ?? 02 3C ?? ?? 43 8C 09 F8 60 00 21 20 80 02 08 00 62 12 21 88 40 00 21 80 53 02 ?? ?? ?? 0? 21 20 00 02 21 30 40 00 21 28 00 02 ?? ?? ?? 0? 21 20 51 02 ?? ?? 02 3C ?? ?? 43 8C 21 20 40 02 09 F8 60 00 21 28 80 02 14 00 BF 8F 23 10 33 02 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_41_62_0 {
	meta:
		name = "ustrtok_r"
		size = 340
		refs = "0038 ugetx 0058 .text 0068 ugetxc 0100 usetat"
	strings:
		$1 = { C8 FF BD 27 30 00 B7 AF 28 00 B5 AF 34 00 BF AF 2C 00 B6 AF 24 00 B4 AF 20 00 B3 AF 1C 00 B2 AF 18 00 B1 AF 14 00 B0 AF 08 00 A4 AF 21 A8 A0 00 43 00 80 10 21 B8 C0 00 ?? ?? 13 3C 08 00 B2 27 ?? ?? 10 3C ?? ?? 63 8E 21 20 40 02 09 F8 60 00 08 00 B6 8F 21 88 40 00 ?? ?? ?? 0? 00 00 B5 AF F9 FF 22 12 ?? ?? 63 8E ?? ?? 03 8E 09 F8 60 00 21 20 A0 03 FA FF 40 14 00 00 00 00 12 00 20 52 00 00 E0 AE ?? ?? 63 8E 21 20 40 02 09 F8 60 00 08 00 B4 8F 21 88 40 00 ?? ?? ?? 0? 00 00 B5 AF F9 FF 40 10 ?? ?? 63 8E ?? ?? 03 8E 09 F8 60 00 21 20 A0 03 FA FF 22 16 00 00 00 00 0D 00 20 16 21 10 C0 02 00 00 E0 AE 34 00 BF 8F 30 00 B7 8F 2C 00 B6 8F 28 00 B5 8F 24 00 B4 8F 20 00 B3 8F 1C 00 B2 8F 18 00 B1 8F 14 00 B0 8F 08 00 E0 03 38 00 BD 27 08 00 B0 8F 21 20 80 02 21 28 00 00 ?? ?? ?? 0? 21 30 00 00 34 00 BF 8F 21 80 02 02 00 00 F0 AE 21 10 C0 02 30 00 B7 8F 2C 00 B6 8F 28 00 B5 8F 24 00 B4 8F 20 00 B3 8F 1C 00 B2 8F 18 00 B1 8F 14 00 B0 8F 08 00 E0 03 38 00 BD 27 00 00 C2 8C E0 FF 40 50 21 10 00 00 ?? ?? ?? 0? 08 00 A2 AF }
	condition:
		$1
}

rule file_41_64_0 {
	meta:
		name = "ustrupr"
		size = 168
		refs = "0030 uwidth 002c .text 0034 utoupper 004c usetat 0028 ugetc"
	strings:
		$1 = { E0 FF BD 27 18 00 B5 AF 14 00 B4 AF 10 00 B3 AF 0C 00 B2 AF 1C 00 BF AF 08 00 B1 AF 04 00 B0 AF 21 98 80 00 21 90 00 00 ?? ?? 14 3C ?? ?? ?? 0? ?? ?? 15 3C ?? ?? ?? 0? 00 00 00 00 21 30 40 00 21 20 20 02 03 00 02 12 21 28 00 00 ?? ?? ?? 0? 00 00 00 00 ?? ?? A3 8E 09 F8 60 00 21 20 20 02 21 90 42 02 ?? ?? 83 8E 21 88 72 02 09 F8 60 00 21 20 20 02 21 80 40 00 EE FF 40 14 21 20 40 00 1C 00 BF 8F 21 10 60 02 18 00 B5 8F 14 00 B4 8F 10 00 B3 8F 0C 00 B2 8F 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_41_65_0 {
	meta:
		name = "ustrlwr"
		size = 168
		refs = "0030 uwidth 002c .text 0034 utolower 004c usetat 0028 ugetc"
	strings:
		$1 = { E0 FF BD 27 18 00 B5 AF 14 00 B4 AF 10 00 B3 AF 0C 00 B2 AF 1C 00 BF AF 08 00 B1 AF 04 00 B0 AF 21 98 80 00 21 90 00 00 ?? ?? 14 3C ?? ?? ?? 0? ?? ?? 15 3C ?? ?? ?? 0? 00 00 00 00 21 30 40 00 21 20 20 02 03 00 02 12 21 28 00 00 ?? ?? ?? 0? 00 00 00 00 ?? ?? A3 8E 09 F8 60 00 21 20 20 02 21 90 42 02 ?? ?? 83 8E 21 88 72 02 09 F8 60 00 21 20 20 02 21 80 40 00 EE FF 40 14 21 20 40 00 1C 00 BF 8F 21 10 60 02 18 00 B5 8F 14 00 B4 8F 10 00 B3 8F 0C 00 B2 8F 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_41_66_0 {
	meta:
		name = "sprint_float"
		size = 516
		refs = "00d0 sprintf 00cc $LC0 00e4 $LC1 0120 .data 0154 .text 0188 ucwidth 019c _al_malloc 01c0 do_uconvert 01cc ustrsize"
	strings:
		$1 = { E0 FD BD 27 04 02 B1 AF 21 88 A0 00 00 00 A5 8C 25 00 02 24 14 02 B5 AF 01 00 A3 30 10 02 B4 AF 0C 02 B3 AF 08 02 B2 AF 1C 02 BF AF 18 02 B6 AF 00 02 B0 AF 00 00 A2 A3 21 90 80 00 21 A0 C0 00 21 A8 E0 00 45 00 60 14 21 98 00 01 01 00 10 24 02 00 A2 30 06 00 40 10 04 00 A2 30 21 18 B0 03 2B 00 02 24 00 00 62 A0 01 00 10 26 04 00 A2 30 06 00 40 10 08 00 A2 30 21 18 B0 03 20 00 02 24 00 00 62 A0 01 00 10 26 08 00 A2 30 06 00 40 10 10 00 A2 30 21 18 B0 03 23 00 02 24 00 00 62 A0 01 00 10 26 10 00 A2 30 06 00 40 50 04 00 26 8E 21 18 B0 03 30 00 02 24 00 00 62 A0 01 00 10 26 04 00 26 8E 05 00 C0 18 21 20 B0 03 ?? ?? 05 3C ?? ?? ?? 0? ?? ?? A5 24 21 80 02 02 08 00 26 8E 05 00 C0 04 ?? ?? 05 3C 21 20 B0 03 ?? ?? ?? 0? ?? ?? A5 24 21 80 02 02 21 10 B0 03 00 01 B6 27 21 30 80 02 21 38 A0 02 21 20 C0 02 21 28 A0 03 00 00 53 A0 ?? ?? ?? 0? 01 00 40 A0 21 A0 40 00 ?? ?? 02 3C ?? ?? 03 3C ?? ?? 46 8C ?? ?? 63 24 21 20 60 00 21 28 00 00 08 00 07 24 00 00 82 8C 0A 00 C2 10 20 00 84 24 01 00 A5 24 FC FF A7 54 00 00 82 8C ?? ?? ?? 0? 21 80 00 00 2D 00 02 24 01 00 A2 A3 ?? ?? ?? 0? 02 00 10 24 40 11 05 00 21 10 62 00 04 00 40 10 21 80 00 00 1C 00 42 8C 18 00 82 02 12 80 00 00 ?? ?? 02 3C ?? ?? 43 8C 09 F8 60 00 21 20 00 00 21 80 02 02 ?? ?? ?? 0? 21 20 00 02 53 41 05 3C 75 63 07 3C 21 20 C0 02 21 40 00 02 00 00 42 AE 38 43 A5 34 21 30 40 00 ?? ?? ?? 0? 2E 72 E7 34 00 00 44 8E ?? ?? ?? 0? 04 00 20 AE 1C 02 BF 8F 04 00 42 AE 18 02 B6 8F 21 10 80 02 14 02 B5 8F 10 02 B4 8F 0C 02 B3 8F 08 02 B2 8F 04 02 B1 8F 00 02 B0 8F 08 00 E0 03 20 02 BD 27 }
	condition:
		$1
}

rule file_41_67_0 {
	meta:
		name = "uvszprintf"
		size = 3976
		refs = "02d0 uwidth 06ec usetc 003c ustrsizez 0044 _al_malloc 0064 ugetxc 00fc ucwidth 0124 ugetx 01ac .text 01b8 _al_free 0220 ugetc 0398 .rodata 055c ustrzcpy 0824 .data 0930 ustrlen 0b3c memmove"
	strings:
		$1 = { 80 FF BD 27 4C 00 A4 AF 21 20 C0 00 7C 00 BF AF 50 00 A5 AF 54 00 A7 AF 70 00 B6 AF 58 00 B0 AF 78 00 BE AF 21 80 C0 00 74 00 B7 AF 6C 00 B5 AF 68 00 B4 AF 64 00 B3 AF 60 00 B2 AF ?? ?? ?? 0? 5C 00 B1 AF ?? ?? ?? 0? 21 20 40 00 0C 00 04 24 48 00 A2 AF ?? ?? ?? 0? 00 00 A2 AF 44 00 A2 AF 08 00 40 AC ?? ?? 05 3C 00 00 A2 8F ?? ?? A3 8C 04 00 B0 AF 38 00 A2 AF 40 00 A0 AF 04 00 A4 27 09 F8 60 00 44 00 B6 8F 16 00 40 10 21 80 40 00 25 00 02 24 62 00 02 12 ?? ?? 02 3C ?? ?? 43 8C 38 00 A4 8F 09 F8 60 00 21 28 00 02 38 00 A3 8F 40 00 A4 8F 21 18 62 00 01 00 84 24 21 10 C0 02 38 00 A3 AF 40 00 A4 AF 21 B0 40 00 ?? ?? 05 3C ?? ?? A3 8C 09 F8 60 00 04 00 A4 27 EC FF 40 14 21 80 40 00 ?? ?? 02 3C ?? ?? 43 8C 38 00 A4 8F 21 28 00 00 09 F8 60 00 ?? ?? 13 3C ?? ?? 03 3C ?? ?? 65 8C 21 20 00 00 09 F8 A0 00 21 A8 60 02 50 00 A4 8F 44 00 B4 8F 25 00 12 24 23 88 82 00 73 00 16 24 ?? ?? 63 8E 09 F8 60 00 21 20 A0 03 15 00 40 10 21 80 40 00 FB 00 12 12 ?? ?? 02 3C ?? ?? 43 8C 09 F8 60 00 21 20 00 02 23 88 22 02 0D 00 20 06 ?? ?? 04 3C ?? ?? 83 8C 4C 00 A4 8F 09 F8 60 00 21 28 00 02 4C 00 A5 8F ?? ?? 63 8E 21 20 A0 03 21 28 A2 00 09 F8 60 00 4C 00 A5 AF ED FF 40 14 21 80 40 00 ?? ?? 02 3C 4C 00 A4 8F ?? ?? 46 8C 09 F8 C0 00 21 28 00 00 44 00 A4 8F 08 00 83 8C 04 00 60 14 44 00 A5 8F ?? ?? ?? 0? 00 00 00 00 44 00 A5 8F ?? ?? ?? 0? 00 00 A4 8C 44 00 A2 8F 08 00 50 8C ?? ?? ?? 0? 21 20 40 00 08 00 02 8E F7 FF 40 14 44 00 B0 AF ?? ?? ?? 0? 44 00 A4 8F ?? ?? ?? 0? 48 00 A4 8F 7C 00 BF 8F 40 00 A2 8F 78 00 BE 8F 74 00 B7 8F 70 00 B6 8F 6C 00 B5 8F 68 00 B4 8F 64 00 B3 8F 60 00 B2 8F 5C 00 B1 8F 58 00 B0 8F 08 00 E0 03 80 00 BD 27 ?? ?? 04 3C ?? ?? 83 8C 09 F8 60 00 04 00 A4 8F E2 00 50 10 21 40 40 00 FF FF 02 24 14 00 A2 AF 0C 00 A0 AF 10 00 A0 AF 18 00 A0 AF E0 FF 03 25 11 00 62 2C 56 00 40 14 80 10 03 00 2A 00 02 24 0A 02 02 11 D0 FF 02 25 0A 00 42 2C 1A 00 40 10 54 00 B2 8F 10 00 A0 AF 0A 00 11 24 ?? ?? 02 3C ?? ?? 45 8C 10 00 A2 8F 04 00 B0 8F 18 00 51 00 21 20 00 02 12 10 00 00 D0 FF 42 24 21 10 48 00 09 F8 A0 00 10 00 A2 AF ?? ?? 04 3C ?? ?? 83 8C 21 80 02 02 04 00 B0 AF 09 F8 60 00 21 20 00 02 21 40 40 00 D0 FF 42 24 0A 00 42 2C EC FF 40 14 ?? ?? 02 3C 54 00 B2 8F 2E 00 02 24 DF 01 02 51 04 00 B0 8F 2A 00 02 24 CA 01 02 11 D0 FF 02 25 0A 00 42 2C 1A 00 40 10 21 88 40 02 14 00 A0 AF 0A 00 11 24 14 00 A2 8F 04 00 B0 8F ?? ?? 04 3C 18 00 51 00 ?? ?? 85 8C 21 20 00 02 12 10 00 00 D0 FF 42 24 21 10 48 00 09 F8 A0 00 14 00 A2 AF ?? ?? 04 3C ?? ?? 83 8C 21 80 02 02 04 00 B0 AF 09 F8 60 00 21 20 00 02 21 40 40 00 D0 FF 42 24 0A 00 42 2C EC FF 40 14 14 00 A2 8F 21 88 40 02 68 00 05 24 45 00 05 11 6C 00 02 24 59 00 02 11 4C 00 03 24 51 00 03 11 BC FF 03 25 35 00 62 2C 05 00 40 14 80 10 03 00 54 00 B1 AF 21 10 C0 02 ?? ?? ?? 0? 21 B0 40 00 ?? ?? 03 3C ?? ?? 63 24 21 10 62 00 00 00 43 8C 08 00 60 00 00 00 00 00 ?? ?? 03 3C ?? ?? 63 24 21 10 62 00 00 00 43 8C 08 00 60 00 00 00 00 00 ?? ?? 02 3C ?? ?? 45 8C 0C 00 A2 8F 04 00 B0 8F 10 00 42 34 21 20 00 02 09 F8 A0 00 0C 00 A2 AF ?? ?? 04 3C ?? ?? 83 8C 21 80 02 02 04 00 B0 AF 09 F8 60 00 21 20 00 02 ?? ?? ?? 0? 21 40 40 00 0C 00 A2 8F 04 00 B0 8F ?? ?? 04 3C ?? ?? 85 8C 01 00 42 34 0C 00 A2 AF 09 F8 A0 00 21 20 00 02 ?? ?? 05 3C ?? ?? ?? 0? ?? ?? A3 8C ?? ?? 02 3C ?? ?? 45 8C 0C 00 A2 8F 04 00 B0 8F ?? ?? ?? 0? 02 00 42 34 ?? ?? 02 3C ?? ?? 45 8C 0C 00 A2 8F 04 00 B0 8F ?? ?? ?? 0? 08 00 42 34 ?? ?? 02 3C ?? ?? 45 8C 0C 00 A2 8F 04 00 B0 8F ?? ?? ?? 0? 04 00 42 34 ?? ?? 04 3C 0C 00 A2 8F 04 00 B0 8F ?? ?? 85 8C 20 00 42 34 21 20 00 02 09 F8 A0 00 0C 00 A2 AF ?? ?? 05 3C ?? ?? A3 8C 21 80 02 02 04 00 B0 AF 09 F8 60 00 21 20 00 02 ?? ?? ?? 0? 21 40 40 00 0C 00 A2 8F ?? ?? 04 3C 04 00 B0 8F ?? ?? 85 8C ?? ?? ?? 0? 80 01 42 34 0C 00 A3 8F 40 00 62 30 10 00 40 10 40 00 62 34 00 01 62 34 0C 00 A2 AF 04 00 B0 8F ?? ?? 02 3C ?? ?? 43 8C 09 F8 60 00 21 20 00 02 ?? ?? 03 3C ?? ?? 65 8C 21 80 02 02 04 00 B0 AF 09 F8 A0 00 21 20 00 02 ?? ?? ?? 0? 21 40 40 00 ?? ?? ?? 0? 0C 00 A2 AF ?? ?? A3 8E 09 F8 60 00 21 20 A0 03 13 00 52 10 ?? ?? 05 3C FA FE 56 14 ?? ?? 63 8E ?? ?? 04 3C ?? ?? 83 8C 09 F8 60 00 21 20 00 00 4C 00 A4 8F 00 00 86 8E ?? ?? ?? 0? 21 28 51 00 04 00 83 8E 4C 00 A5 8F 23 88 23 02 21 28 A3 00 7D 02 20 06 4C 00 A5 AF ?? ?? ?? 0? 08 00 94 8E ?? ?? A3 8C 09 F8 60 00 25 00 04 24 23 88 22 02 FC FE 20 06 ?? ?? 02 3C ?? ?? 43 8C 4C 00 A4 8F 09 F8 60 00 25 00 05 24 4C 00 A3 8F 21 18 62 00 ?? ?? ?? 0? 4C 00 A3 AF 40 00 A2 8F 04 00 B0 8F ?? ?? 05 3C ?? ?? A3 8C 01 00 42 24 21 20 00 02 09 F8 60 00 40 00 A2 AF ?? ?? 03 3C ?? ?? 66 8C 38 00 A4 8F 21 80 02 02 04 00 B0 AF 09 F8 C0 00 25 00 05 24 38 00 A5 8F ?? ?? 04 3C ?? ?? 83 8C 21 80 A2 00 21 20 00 02 09 F8 60 00 25 00 05 24 21 80 02 02 21 10 C0 02 38 00 B0 AF ?? ?? ?? 0? 21 B0 40 00 0C 00 A3 8F 20 00 62 30 05 00 40 54 00 00 26 8E 00 01 62 30 6B 01 40 54 07 00 22 26 00 00 26 8E 04 00 31 26 54 00 B1 AF 21 38 00 00 21 20 C0 02 ?? ?? ?? 0? 0C 00 A5 27 ?? ?? ?? 0? ?? ?? 05 3C 0C 00 A3 8F 20 00 62 30 05 00 40 54 00 00 22 8E 00 01 62 30 54 01 40 14 07 00 22 26 00 00 22 8E 04 00 31 26 54 00 B1 AF C3 3F 02 00 21 30 40 00 21 20 C0 02 ?? ?? ?? 0? 0C 00 A5 27 ?? ?? 05 3C 04 00 B0 8F ?? ?? A3 8C 21 A8 40 00 21 88 A0 00 09 F8 60 00 21 20 00 02 ?? ?? 03 3C ?? ?? 65 8C 21 80 02 02 04 00 B0 AF 09 F8 A0 00 21 20 00 02 2D FF A0 06 21 10 C0 02 10 00 A3 8F 2A 10 A3 02 19 00 40 10 ?? ?? 02 3C 0C 00 A4 8F 01 00 82 30 B1 00 40 10 23 F0 75 00 04 00 D0 8E 00 00 C4 8E ?? ?? 05 3C ?? ?? A3 8C 21 20 90 00 09 F8 60 00 20 00 05 24 21 80 02 02 10 00 A2 8F 01 00 B5 26 2A 10 A2 02 F6 FF 40 14 00 00 C4 8E ?? ?? 02 3C ?? ?? 43 8C 04 00 D0 AE 21 20 90 00 09 F8 60 00 21 28 00 00 ?? ?? 02 3C ?? ?? 43 8C 38 00 A4 8F 09 F8 60 00 25 00 05 24 38 00 A4 8F ?? ?? 03 3C ?? ?? 66 8C 21 80 82 00 21 20 00 02 09 F8 C0 00 73 00 05 24 21 80 02 02 0C 00 04 24 ?? ?? ?? 0? 38 00 B0 AF 40 00 A5 8F 08 00 C2 AE 08 00 40 AC 21 28 B5 00 40 00 A5 AF ?? ?? ?? 0? 21 B0 40 00 00 00 28 8E 21 20 C0 02 0C 00 A5 27 21 30 00 00 ?? ?? ?? 0? 21 48 00 00 04 00 B0 8F ?? ?? 04 3C 04 00 31 26 ?? ?? 83 8C 21 A8 40 00 54 00 B1 AF 21 20 00 02 09 F8 60 00 ?? ?? 11 3C ?? ?? 03 3C ?? ?? 65 8C 21 80 02 02 04 00 B0 AF 09 F8 A0 00 21 20 00 02 ?? ?? ?? 0? 00 00 00 00 0C 00 A3 8F 20 00 62 30 DC 00 40 10 00 01 62 30 00 00 33 8E 04 00 31 26 54 00 B1 AF 21 88 00 00 ?? ?? 02 3C 10 00 A7 8F ?? ?? 45 8C ?? ?? 03 3C ?? ?? 63 24 21 20 00 00 08 00 06 24 00 00 62 8C 5D 01 A2 50 ?? ?? 03 3C 01 00 84 24 FB FF 86 14 20 00 63 24 ?? ?? ?? 0? 21 80 00 00 00 00 22 8E 04 00 B0 8F 40 00 A5 8F ?? ?? 04 3C ?? ?? 83 8C 00 00 45 AC 09 F8 60 00 21 20 00 02 ?? ?? 03 3C ?? ?? 65 8C 21 80 02 02 04 00 31 26 04 00 B0 AF 21 20 00 02 09 F8 A0 00 54 00 B1 AF ?? ?? ?? 0? 21 10 C0 02 00 00 32 8E 10 00 A7 8F ?? ?? 04 3C ?? ?? 03 3C ?? ?? 85 8C ?? ?? 63 24 21 20 00 00 08 00 06 24 00 00 62 8C D2 00 A2 50 ?? ?? 05 3C 01 00 84 24 FB FF 86 14 20 00 63 24 ?? ?? ?? 0? 21 80 00 00 07 00 23 26 F8 FF 02 24 24 18 62 00 00 00 66 8C 04 00 67 8C 21 20 C0 02 08 00 63 24 0C 00 A5 27 ?? ?? ?? 0? 54 00 A3 AF ?? ?? 04 3C 21 A8 40 00 04 00 B0 8F ?? ?? 83 8C ?? ?? ?? 0? 21 88 80 00 00 00 22 8E 21 20 40 00 ?? ?? ?? 0? 08 00 A2 AF 10 00 A7 8F 2A 10 E2 00 B1 00 40 14 00 00 00 00 ?? ?? 04 3C ?? ?? 03 3C ?? ?? 85 8C ?? ?? 63 24 21 20 00 00 08 00 06 24 00 00 62 8C D9 00 A2 50 ?? ?? 05 3C 01 00 84 24 FB FF 86 14 20 00 63 24 ?? ?? ?? 0? 21 80 00 00 0C 00 A3 8F 20 00 62 30 87 00 40 50 00 01 62 30 00 00 22 8E 04 00 31 26 54 00 B1 AF 21 48 00 00 58 00 06 39 01 00 C6 2C 21 40 40 00 21 20 C0 02 ?? ?? ?? 0? 0C 00 A5 27 ?? ?? ?? 0? ?? ?? 05 3C 62 FF C0 1B 10 00 82 30 48 00 40 10 20 00 17 24 18 00 A2 8F 68 01 40 18 21 80 00 00 21 98 00 00 00 00 C4 8E ?? ?? 23 8E 01 00 10 26 09 F8 60 00 21 20 93 00 21 98 62 02 18 00 A2 8F 2A 10 02 02 F8 FF 40 54 00 00 C4 8E 3C 00 B3 AF ?? ?? ?? 0? 30 00 17 24 04 00 B0 8F ?? ?? 04 3C ?? ?? 83 8C 21 20 00 02 09 F8 60 00 04 00 51 26 ?? ?? 03 3C ?? ?? 65 8C 21 80 02 02 04 00 B0 AF 09 F8 A0 00 21 20 00 02 21 40 40 00 00 00 42 8E 21 18 00 00 2C 10 43 00 ?? ?? ?? 0? 14 00 A2 AF ?? ?? 05 3C ?? ?? A3 8C 09 F8 60 00 21 20 00 02 ?? ?? 03 3C ?? ?? 65 8C 21 80 02 02 04 00 B0 AF 09 F8 A0 00 21 20 00 02 ?? ?? ?? 0? 21 40 40 00 04 00 B0 8F ?? ?? 05 3C ?? ?? A3 8C 54 00 A2 8F 21 20 00 02 09 F8 60 00 04 00 52 24 ?? ?? 03 3C ?? ?? 65 8C 21 80 02 02 21 20 00 02 09 F8 A0 00 04 00 B0 AF 54 00 A4 8F 21 40 40 00 00 00 82 8C 02 FE 41 04 10 00 A2 AF 23 18 02 00 0C 00 A2 8F 10 00 A3 AF 01 00 42 34 ?? ?? ?? 0? 0C 00 A2 AF 21 98 00 00 3C 00 A0 AF ?? ?? 04 3C ?? ?? 83 8C 21 20 E0 02 09 F8 60 00 21 A0 00 00 18 00 5E 00 ?? ?? 02 3C ?? ?? 43 8C 21 20 00 00 00 00 D1 8E 04 00 D0 8E 09 F8 60 00 12 90 00 00 3C 00 A3 8F 21 10 50 00 23 30 53 00 21 20 43 02 21 28 23 02 ?? ?? ?? 0? 21 20 24 02 04 00 C3 8E 21 18 72 00 04 00 C3 AE 00 00 C4 8E ?? ?? 05 3C ?? ?? A6 8C 21 20 93 00 01 00 94 26 09 F8 C0 00 21 28 E0 02 2A 18 9E 02 F7 FF 60 14 21 98 62 02 ?? ?? ?? 0? 21 A8 BE 02 25 FF 40 50 00 00 33 8E 07 00 22 26 F8 FF 03 24 24 10 43 00 08 00 44 24 04 00 51 8C 54 00 A4 AF ?? ?? ?? 0? 00 00 53 8C 7A FF 40 50 00 00 22 8E 07 00 22 26 F8 FF 03 24 24 10 43 00 08 00 44 24 04 00 49 8C 54 00 A4 AF ?? ?? ?? 0? 00 00 42 8C F8 FF 03 24 24 10 43 00 08 00 44 24 04 00 47 8C 54 00 A4 AF ?? ?? ?? 0? 00 00 42 8C F8 FF 03 24 24 10 43 00 08 00 44 24 04 00 47 8C 54 00 A4 AF ?? ?? ?? 0? 00 00 46 8C ?? ?? ?? 0? 08 00 A4 8F ?? ?? ?? 0? 21 38 40 00 40 11 04 00 ?? ?? A5 24 21 10 A2 00 06 00 40 50 21 80 00 00 1C 00 43 8C 01 00 02 24 2C 10 E2 00 18 00 43 00 12 80 00 00 ?? ?? 02 3C ?? ?? 43 8C 04 00 31 26 21 20 00 00 09 F8 60 00 54 00 B1 AF ?? ?? ?? 0? 21 20 50 00 ?? ?? 04 3C ?? ?? 83 8C 21 28 40 02 21 20 40 00 09 F8 60 00 00 00 C2 AE 00 00 C4 8E ?? ?? 05 3C ?? ?? A3 8C 21 20 82 00 21 28 00 00 09 F8 60 00 04 00 C2 AE 04 00 B0 8F ?? ?? 02 3C ?? ?? 43 8C 21 20 00 02 09 F8 60 00 21 88 40 00 ?? ?? 03 3C ?? ?? 65 8C 21 80 02 02 04 00 B0 AF 09 F8 A0 00 21 20 00 02 ?? ?? ?? 0? 01 00 15 24 40 11 04 00 ?? ?? A5 24 21 10 A2 00 04 00 40 50 21 80 00 00 1C 00 42 8C 18 00 E2 00 12 80 00 00 ?? ?? 02 3C ?? ?? 43 8C 21 20 00 00 09 F8 60 00 21 A8 00 00 ?? ?? ?? 0? 21 20 50 00 00 00 C2 AE 21 80 00 00 ?? ?? ?? 0? 08 00 B2 27 14 00 A2 8F 03 00 40 04 2A 10 A2 02 0F 00 40 50 00 00 C4 8E 00 00 C4 8E ?? ?? 02 3C ?? ?? 43 8C 21 20 90 00 09 F8 60 00 01 00 B5 26 21 80 02 02 ?? ?? 04 3C ?? ?? 83 8C 09 F8 60 00 21 20 40 02 EF FF 40 14 21 28 40 00 00 00 C4 8E ?? ?? 05 3C ?? ?? A3 8C 04 00 D0 AE 21 20 90 00 09 F8 60 00 21 28 00 00 04 00 B0 8F ?? ?? 02 3C ?? ?? 43 8C 04 00 31 26 54 00 B1 AF 09 F8 60 00 21 20 00 02 ?? ?? 03 3C ?? ?? 65 8C 21 80 02 02 04 00 B0 AF 21 20 00 02 09 F8 A0 00 ?? ?? 11 3C ?? ?? ?? 0? 10 00 A3 8F 40 11 04 00 ?? ?? 63 24 21 10 62 00 06 00 40 10 21 80 00 00 1C 00 43 8C 18 00 02 24 2C 10 E2 00 18 00 43 00 12 80 00 00 ?? ?? 02 3C ?? ?? 43 8C 09 F8 60 00 21 20 00 00 ?? ?? ?? 0? 21 20 50 00 0C 00 A3 8F 21 20 40 00 00 00 C2 AE 02 00 62 30 49 00 40 14 04 00 62 30 52 00 40 14 ?? ?? 02 3C 21 90 00 00 08 00 62 30 39 00 40 54 00 00 C4 8E 21 80 00 00 1C 00 B4 27 40 1F 11 00 C2 20 13 00 07 00 65 32 C2 88 11 00 25 98 64 00 21 10 90 02 25 18 71 02 00 00 45 A0 F7 FF 60 14 01 00 10 26 14 00 A2 8F 2A 10 02 02 0D 00 40 10 21 98 00 02 00 00 C4 8E ?? ?? 02 3C ?? ?? 43 8C 21 20 92 00 09 F8 60 00 30 00 05 24 21 90 42 02 14 00 A2 8F 01 00 73 26 2A 10 62 02 F6 FF 40 54 00 00 C4 8E FF FF 11 26 ?? ?? ?? 0? 21 80 91 02 FF FF 31 26 00 00 05 82 00 00 C4 8E ?? ?? 02 3C ?? ?? 43 8C 21 20 92 00 09 F8 60 00 30 00 A5 24 21 90 42 02 F6 FF 20 16 FF FF 10 26 00 00 C4 8E ?? ?? 05 3C ?? ?? A3 8C 21 20 92 00 04 00 D2 AE 09 F8 60 00 21 28 00 00 ?? ?? 02 3C 04 00 B0 8F ?? ?? 43 8C 18 00 A2 8F 21 20 00 02 ?? ?? ?? 0? 21 A8 62 02 ?? ?? 05 3C ?? ?? A3 8C 21 20 92 00 09 F8 60 00 30 00 05 24 21 90 42 02 18 00 A2 8F 01 00 42 24 ?? ?? ?? 0? 18 00 A2 AF ?? ?? 05 3C ?? ?? A3 8C 2B 00 05 24 09 F8 60 00 00 00 00 00 21 90 40 00 18 00 A2 8F 0C 00 A3 8F 01 00 42 24 ?? ?? ?? 0? 18 00 A2 AF ?? ?? 43 8C ?? ?? ?? 0? 20 00 05 24 21 28 B1 00 ?? ?? ?? 0? 4C 00 A5 AF 30 00 17 24 21 98 00 00 ?? ?? ?? 0? 3C 00 A0 AF }
	condition:
		$1
}

rule file_41_68_0 {
	meta:
		name = "uszprintf"
		size = 56
		refs = "0024 uvszprintf"
	strings:
		$1 = { D8 FF BD 27 14 00 A2 27 14 00 A7 AF 21 38 40 00 0C 00 BF AF 18 00 A8 AF 1C 00 A9 AF 20 00 AA AF 24 00 AB AF ?? ?? ?? 0? 00 00 A2 AF 0C 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_303_1_8 {
	meta:
		name = "_diprintf_r"
		size = 56
		refs = "0024 _vdiprintf_r"
	strings:
		$1 = { D8 FF BD 27 14 00 A2 27 14 00 A7 AF 21 38 40 00 0C 00 BF AF 18 00 A8 AF 1C 00 A9 AF 20 00 AA AF 24 00 AB AF ?? ?? ?? 0? 00 00 A2 AF 0C 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_121_1_8 {
	meta:
		name = "_dprintf_r"
		size = 56
		refs = "0024 _vdprintf_r"
	strings:
		$1 = { D8 FF BD 27 14 00 A2 27 14 00 A7 AF 21 38 40 00 0C 00 BF AF 18 00 A8 AF 1C 00 A9 AF 20 00 AA AF 24 00 AB AF ?? ?? ?? 0? 00 00 A2 AF 0C 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_198_1_8 {
	meta:
		name = "_fiprintf_r"
		size = 56
		refs = "0024 _vfiprintf_r"
	strings:
		$1 = { D8 FF BD 27 14 00 A2 27 14 00 A7 AF 21 38 40 00 0C 00 BF AF 18 00 A8 AF 1C 00 A9 AF 20 00 AA AF 24 00 AB AF ?? ?? ?? 0? 00 00 A2 AF 0C 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_572_0_14 {
	meta:
		name = "_fiscanf_r"
		size = 56
		refs = "0024 __svfiscanf_r"
	strings:
		$1 = { D8 FF BD 27 14 00 A2 27 14 00 A7 AF 21 38 40 00 0C 00 BF AF 18 00 A8 AF 1C 00 A9 AF 20 00 AA AF 24 00 AB AF ?? ?? ?? 0? 00 00 A2 AF 0C 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_293_1_8 {
	meta:
		name = "_fprintf_r"
		size = 56
		refs = "0024 _vfprintf_r"
	strings:
		$1 = { D8 FF BD 27 14 00 A2 27 14 00 A7 AF 21 38 40 00 0C 00 BF AF 18 00 A8 AF 1C 00 A9 AF 20 00 AA AF 24 00 AB AF ?? ?? ?? 0? 00 00 A2 AF 0C 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_14_0_8 {
	meta:
		name = "_fscanf_r"
		size = 56
		refs = "0024 __svfscanf_r"
	strings:
		$1 = { D8 FF BD 27 14 00 A2 27 14 00 A7 AF 21 38 40 00 0C 00 BF AF 18 00 A8 AF 1C 00 A9 AF 20 00 AA AF 24 00 AB AF ?? ?? ?? 0? 00 00 A2 AF 0C 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_7_1_14 {
	meta:
		name = "_fwprintf_r"
		size = 56
		refs = "0024 _vfwprintf_r"
	strings:
		$1 = { D8 FF BD 27 14 00 A2 27 14 00 A7 AF 21 38 40 00 0C 00 BF AF 18 00 A8 AF 1C 00 A9 AF 20 00 AA AF 24 00 AB AF ?? ?? ?? 0? 00 00 A2 AF 0C 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_54_0_14 {
	meta:
		name = "_fwscanf_r"
		size = 56
		refs = "0024 __svfwscanf_r"
	strings:
		$1 = { D8 FF BD 27 14 00 A2 27 14 00 A7 AF 21 38 40 00 0C 00 BF AF 18 00 A8 AF 1C 00 A9 AF 20 00 AA AF 24 00 AB AF ?? ?? ?? 0? 00 00 A2 AF 0C 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_424_0_8 {
	meta:
		name = "xprintf"
		size = 56
		refs = "0024 vxprintf"
	strings:
		$1 = { D8 FF BD 27 14 00 A2 27 14 00 A7 AF 21 38 40 00 0C 00 BF AF 18 00 A8 AF 1C 00 A9 AF 20 00 AA AF 24 00 AB AF ?? ?? ?? 0? 00 00 A2 AF 0C 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_41_69_0 {
	meta:
		name = "usprintf"
		size = 76
		refs = "0038 uvszprintf"
	strings:
		$1 = { D8 FF BD 27 10 00 A3 27 21 10 A0 00 FF 7F 05 3C 10 00 A6 AF 14 00 A7 AF FF FF A5 34 21 30 40 00 21 38 60 00 0C 00 BF AF 18 00 A8 AF 1C 00 A9 AF 20 00 AA AF 24 00 AB AF ?? ?? ?? 0? 00 00 A3 AF 0C 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_41_70_0 {
	meta:
		name = "ustrerror"
		size = 60
		refs = "0008 strerror 0014 .bss 0034 uconvert"
	strings:
		$1 = { F8 FF BD 27 04 00 BF AF ?? ?? ?? 0? 00 00 00 00 53 41 05 3C ?? ?? 06 3C 75 63 07 3C 04 00 BF 8F 21 20 40 00 38 43 A5 34 ?? ?? C6 24 2E 72 E7 34 00 04 08 24 ?? ?? ?? 0? 08 00 BD 27 }
	condition:
		$1
}

rule file_41_71_0 {
	meta:
		name = "ustrtod"
		size = 148
		refs = "0034 uconvert 0044 strtod 0060 uoffset"
	strings:
		$1 = { 98 FF BD 27 60 00 B3 AF 53 41 07 3C 21 98 A0 00 75 63 05 3C 38 43 E7 34 2E 72 A5 34 04 00 A6 27 40 00 08 24 64 00 BF AF 5C 00 B2 AF 58 00 B1 AF 54 00 B0 AF ?? ?? ?? 0? 21 90 80 00 21 20 40 00 21 28 A0 03 ?? ?? ?? 0? 21 80 40 00 21 88 40 00 07 00 60 12 48 00 A3 AF 00 00 A5 8F 21 20 40 02 ?? ?? ?? 0? 23 28 B0 00 21 10 42 02 00 00 62 AE 64 00 BF 8F 48 00 A3 8F 21 10 20 02 60 00 B3 8F 5C 00 B2 8F 58 00 B1 8F 54 00 B0 8F 08 00 E0 03 68 00 BD 27 }
	condition:
		$1
}

rule file_41_72_0 {
	meta:
		name = "ustrtol"
		size = 148
		refs = "0038 uconvert 004c strtol 0064 uoffset"
	strings:
		$1 = { A0 FF BD 27 58 00 B3 AF 53 41 07 3C 21 98 A0 00 75 63 05 3C 4C 00 B0 AF 38 43 E7 34 21 80 C0 00 2E 72 A5 34 40 00 08 24 04 00 A6 27 5C 00 BF AF 54 00 B2 AF 50 00 B1 AF ?? ?? ?? 0? 21 90 80 00 21 20 40 00 21 30 00 02 21 28 A0 03 ?? ?? ?? 0? 21 88 40 00 07 00 60 12 21 80 40 00 00 00 A5 8F 21 20 40 02 ?? ?? ?? 0? 23 28 B1 00 21 10 42 02 00 00 62 AE 5C 00 BF 8F 21 10 00 02 58 00 B3 8F 54 00 B2 8F 50 00 B1 8F 4C 00 B0 8F 08 00 E0 03 60 00 BD 27 }
	condition:
		$1
}

rule file_41_73_0 {
	meta:
		name = "uatof"
		size = 56
		refs = "001c uconvert 0024 atof"
	strings:
		$1 = { B0 FF BD 27 75 63 05 3C 53 41 07 3C 21 30 A0 03 2E 72 A5 34 38 43 E7 34 4C 00 BF AF ?? ?? ?? 0? 40 00 08 24 ?? ?? ?? 0? 21 20 40 00 4C 00 BF 8F 08 00 E0 03 50 00 BD 27 }
	condition:
		$1
}

rule file_44_3_0 {
	meta:
		name = "_set_current_refresh_rate"
		size = 80
		refs = "0014 .bss 002c _vsync_speed"
	strings:
		$1 = { D8 FF 82 24 A1 00 42 2C 0C 00 40 10 ?? ?? 02 3C 0B 00 80 10 ?? ?? 44 AC 12 00 02 3C DD 34 42 34 02 00 80 14 1A 00 44 00 CD 01 00 00 ?? ?? 02 3C 12 20 00 00 08 00 E0 03 ?? ?? 44 AC ?? ?? 40 AC 95 42 04 24 ?? ?? 02 3C 08 00 E0 03 ?? ?? 44 AC }
	condition:
		$1
}

rule file_44_4_0 {
	meta:
		name = "sort_gfx_mode_list"
		size = 116
	strings:
		$1 = { 00 00 86 8C 00 00 A3 8C 2A 10 66 00 03 00 40 50 2A 10 C3 00 08 00 E0 03 01 00 02 24 13 00 40 14 00 00 00 00 04 00 86 8C 04 00 A3 8C 2A 10 66 00 F8 FF 40 14 00 00 00 00 2A 10 C3 00 0B 00 40 14 00 00 00 00 08 00 83 8C 08 00 A4 8C 2A 10 83 00 F0 FF 40 14 00 00 00 00 2A 10 64 00 03 00 40 14 00 00 00 00 08 00 E0 03 21 10 00 00 08 00 E0 03 FF FF 02 24 }
	condition:
		$1
}

rule file_44_5_0 {
	meta:
		name = "set_color_depth"
		size = 152
		refs = "0004 _color_depth 0014 .rodata 0030 _palette_color32 0038 palette_color 0048 _palette_color8 005c _palette_color15 0070 _palette_color16 0084 _palette_color24"
	strings:
		$1 = { F8 FF 85 24 ?? ?? 02 3C 19 00 A3 2C 0C 00 60 10 ?? ?? 44 AC ?? ?? 03 3C 80 10 05 00 ?? ?? 63 24 21 18 62 00 00 00 64 8C 08 00 80 00 00 00 00 00 ?? ?? 02 3C ?? ?? 42 24 ?? ?? 03 3C ?? ?? 62 AC 08 00 E0 03 00 00 00 00 ?? ?? 02 3C ?? ?? 42 24 ?? ?? 03 3C 08 00 E0 03 ?? ?? 62 AC ?? ?? 02 3C ?? ?? 42 24 ?? ?? 03 3C 08 00 E0 03 ?? ?? 62 AC ?? ?? 02 3C ?? ?? 42 24 ?? ?? 03 3C 08 00 E0 03 ?? ?? 62 AC ?? ?? 02 3C ?? ?? 42 24 ?? ?? 03 3C 08 00 E0 03 ?? ?? 62 AC }
	condition:
		$1
}

rule file_44_7_0 {
	meta:
		name = "set_color_conversion"
		size = 24
		refs = "0000 _color_conv 000c .bss"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 44 AC FF FF 03 24 ?? ?? 02 3C 08 00 E0 03 ?? ?? 43 AC }
	condition:
		$1
}

rule file_44_9_0 {
	meta:
		name = "_color_load_depth"
		size = 152
		refs = "0000 _color_depth 0010 .rodata 0020 .text 0068 _color_conv"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 47 8C 1D 00 87 10 21 30 80 00 ?? ?? 02 3C 2B 40 05 00 ?? ?? 43 24 21 28 00 00 ?? ?? ?? 0? 18 00 04 24 18 00 A4 10 10 00 63 24 FC FF 62 8C FC FF 46 54 01 00 A5 24 00 00 62 8C F9 FF E2 54 01 00 A5 24 04 00 62 8C 01 00 42 2C F5 FF 48 50 01 00 A5 24 ?? ?? 02 3C ?? ?? 42 24 00 29 05 00 21 28 A2 00 ?? ?? 03 3C ?? ?? 62 8C 00 00 A4 8C 24 10 44 00 05 00 40 14 00 00 00 00 21 38 C0 00 08 00 E0 03 21 10 E0 00 21 38 00 00 08 00 E0 03 21 10 E0 00 }
	condition:
		$1
}

rule file_44_10_0 {
	meta:
		name = "_get_vtable"
		size = 132
		refs = "0000 system_driver 0044 _vtable_list 0060 .text"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 43 8C F8 FF BD 27 00 00 B0 AF 54 00 62 8C 04 00 BF AF 0A 00 40 10 21 80 80 00 09 F8 40 00 00 00 00 00 06 00 40 10 21 20 40 00 04 00 BF 8F 21 10 80 00 00 00 B0 8F 08 00 E0 03 08 00 BD 27 ?? ?? 03 3C ?? ?? 62 24 04 00 44 8C F7 FF 80 10 ?? ?? 62 8C F5 FF 50 10 ?? ?? 02 3C ?? ?? ?? 0? ?? ?? 43 24 F1 FF 50 10 08 00 63 24 00 00 64 8C FC FF 80 54 FC FF 62 8C ?? ?? ?? 0? 04 00 BF 8F }
	condition:
		$1
}

rule file_44_11_0 {
	meta:
		name = "_sort_out_virtual_width"
		size = 96
	strings:
		$1 = { 74 00 A2 8C 14 00 40 14 00 00 83 8C 7C 00 A2 8C 78 00 A5 8C 2A 10 45 00 0F 00 40 14 00 00 00 00 02 00 60 14 1A 00 A3 00 CD 01 00 00 12 10 00 00 18 00 43 00 12 10 00 00 07 00 A2 50 00 00 83 AC 01 00 63 24 2A 10 A3 00 F5 FF 40 10 00 00 00 00 08 00 E0 03 00 00 83 AC 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_44_12_0 {
	meta:
		name = "set_clip_rect"
		size = 104
	strings:
		$1 = { 1C 00 89 8C 00 00 8A 8C 04 00 8B 8C 01 00 E7 24 FF FF 42 25 01 00 08 25 0C 00 39 8D FF FF 69 25 2D 28 A2 00 2D 30 C9 00 21 10 00 00 2D 38 EA 00 2D 40 0B 01 2C 40 02 01 2C 28 A2 00 2C 30 C2 00 2C 38 E2 00 0C 00 85 AC 14 00 86 AC 10 00 87 AC 03 00 20 13 18 00 88 AC 08 00 20 03 00 00 00 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_44_13_0 {
	meta:
		name = "add_clip_rect"
		size = 44
		refs = "0024 set_clip_rect"
	strings:
		$1 = { 18 00 89 8C 10 00 83 8C 0C 00 8A 8C 14 00 8B 8C FF FF 63 24 FF FF 29 25 2C 28 AA 00 2C 30 CB 00 2D 38 E3 00 ?? ?? ?? 0? 2D 40 09 01 }
	condition:
		$1
}

rule file_44_14_0 {
	meta:
		name = "set_clip"
		size = 176
		refs = "0048 set_clip_rect 0090 .text"
	strings:
		$1 = { F8 FF BD 27 00 00 B0 AF 04 00 BF AF 21 48 A0 00 21 80 80 00 14 00 A0 14 21 18 C0 00 13 00 C0 14 2A 10 E9 00 11 00 E0 14 00 00 00 00 1A 00 00 51 00 00 87 8C 2A 10 03 01 14 00 40 14 21 10 00 01 21 28 20 01 21 30 60 00 ?? ?? ?? 0? 21 20 00 02 FF FF 02 24 08 00 02 AE 04 00 BF 8F 00 00 B0 8F 08 00 E0 03 08 00 BD 27 2A 10 E9 00 F1 FF 40 10 21 10 E0 00 21 38 20 01 21 48 40 00 2A 10 03 01 F0 FF 40 10 21 28 20 01 21 10 00 01 21 40 60 00 ?? ?? ?? 0? 21 18 40 00 04 00 88 8C FF FF E7 24 ?? ?? ?? 0? FF FF 08 25 ?? ?? ?? 0? 08 00 00 AE }
	condition:
		$1
}

rule file_44_15_0 {
	meta:
		name = "scroll_screen"
		size = 268
		refs = "0000 gfx_driver 0034 _dispsw_status 0048 screen 0088 _screen_split_position 00e0 .text"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 46 8C F8 FF BD 27 04 00 BF AF 18 00 C7 8C 07 00 E0 14 00 00 B0 AF FF FF 10 24 04 00 BF 8F 21 10 00 02 00 00 B0 8F 08 00 E0 03 08 00 BD 27 ?? ?? 02 3C ?? ?? 43 8C F8 FF 60 14 FF FF 10 24 2B 00 80 04 ?? ?? 02 3C ?? ?? 43 8C 02 00 60 10 21 10 00 00 00 00 62 8C 6C 00 C8 8C 23 10 48 00 2A 10 44 00 06 00 40 10 21 80 00 00 23 00 60 10 21 10 00 00 00 00 62 8C FF FF 10 24 23 20 48 00 18 00 A0 04 ?? ?? 02 3C ?? ?? 48 8C 01 00 00 59 70 00 C8 8C ?? ?? 02 3C ?? ?? 43 8C 02 00 60 10 21 10 00 00 04 00 62 8C 23 10 48 00 2A 10 45 00 06 00 40 10 00 00 00 00 02 00 60 10 21 10 00 00 04 00 62 8C 23 28 48 00 FF FF 10 24 09 F8 E0 00 00 00 00 00 D2 FF 40 10 04 00 BF 8F ?? ?? ?? 0? FF FF 10 24 21 28 00 00 ?? ?? ?? 0? FF FF 10 24 21 20 00 00 ?? ?? ?? 0? FF FF 10 24 23 20 48 00 ?? ?? ?? 0? FF FF 10 24 }
	condition:
		$1
}

rule file_44_16_0 {
	meta:
		name = "request_scroll"
		size = 296
		refs = "0000 gfx_driver 001c _dispsw_status 0030 screen 0074 _screen_split_position 00e0 scroll_screen 0108 .text"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 47 8C F8 FF BD 27 04 00 BF AF 24 00 E8 8C 32 00 00 11 00 00 B0 AF ?? ?? 02 3C ?? ?? 43 8C 2E 00 60 14 00 00 00 00 38 00 80 04 ?? ?? 02 3C ?? ?? 43 8C 02 00 60 10 21 10 00 00 00 00 62 8C 6C 00 E6 8C 23 10 46 00 2A 10 44 00 2A 00 40 10 00 00 00 00 30 00 60 10 21 10 00 00 00 00 62 8C FF FF 10 24 23 20 46 00 26 00 A2 04 21 28 00 00 ?? ?? 02 3C ?? ?? 46 8C 01 00 C0 58 70 00 E6 8C ?? ?? 02 3C ?? ?? 43 8C 02 00 60 10 21 10 00 00 04 00 62 8C 23 10 46 00 2A 10 45 00 06 00 40 10 00 00 00 00 02 00 60 10 21 10 00 00 04 00 62 8C 23 28 46 00 FF FF 10 24 09 F8 00 01 00 00 00 00 04 00 BF 8F FF FF 03 24 0B 80 62 00 21 10 00 02 00 00 B0 8F 08 00 E0 03 08 00 BD 27 ?? ?? ?? 0? FF FF 10 24 04 00 BF 8F 21 10 00 02 00 00 B0 8F 08 00 E0 03 08 00 BD 27 DD FF A1 04 21 80 00 00 21 28 00 00 ?? ?? ?? 0? FF FF 10 24 21 20 00 00 ?? ?? ?? 0? FF FF 10 24 23 20 46 00 ?? ?? ?? 0? FF FF 10 24 }
	condition:
		$1
}

rule file_44_17_0 {
	meta:
		name = "poll_scroll"
		size = 52
		refs = "0000 gfx_driver 0014 _dispsw_status"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 43 8C 28 00 79 8C 05 00 20 13 00 00 00 00 ?? ?? 02 3C ?? ?? 43 8C 03 00 60 10 00 00 00 00 08 00 E0 03 21 10 00 00 08 00 20 03 00 00 00 00 }
	condition:
		$1
}

rule file_44_18_0 {
	meta:
		name = "show_video_bitmap"
		size = 124
		refs = "0008 gfx_driver 0040 _dispsw_status 0064 .text 0074 scroll_screen"
	strings:
		$1 = { 2C 00 82 8C 03 00 42 04 ?? ?? 02 3C 08 00 E0 03 FF FF 02 24 ?? ?? 45 8C 12 00 A0 10 00 00 83 8C 6C 00 A2 8C F9 FF 62 14 00 00 00 00 0F 00 A0 10 04 00 83 8C 70 00 A2 8C F4 FF 62 14 00 00 00 00 ?? ?? 02 3C ?? ?? 43 8C F0 FF 60 14 00 00 00 00 38 00 B9 8C 07 00 20 53 38 00 85 8C 08 00 20 03 00 00 00 00 ?? ?? ?? 0? 21 10 00 00 ?? ?? ?? 0? 21 10 00 00 ?? ?? ?? 0? 34 00 84 8C }
	condition:
		$1
}

rule file_44_19_0 {
	meta:
		name = "request_video_bitmap"
		size = 124
		refs = "0008 gfx_driver 0040 _dispsw_status 0064 .text 0074 request_scroll"
	strings:
		$1 = { 2C 00 82 8C 03 00 42 04 ?? ?? 02 3C 08 00 E0 03 FF FF 02 24 ?? ?? 45 8C 12 00 A0 10 00 00 83 8C 6C 00 A2 8C F9 FF 62 14 00 00 00 00 0F 00 A0 10 04 00 83 8C 70 00 A2 8C F4 FF 62 14 00 00 00 00 ?? ?? 02 3C ?? ?? 43 8C F0 FF 60 14 00 00 00 00 3C 00 B9 8C 07 00 20 53 38 00 85 8C 08 00 20 03 00 00 00 00 ?? ?? ?? 0? 21 10 00 00 ?? ?? ?? 0? 21 10 00 00 ?? ?? ?? 0? 34 00 84 8C }
	condition:
		$1
}

rule file_44_20_0 {
	meta:
		name = "enable_triple_buffer"
		size = 160
		refs = "0008 gfx_capabilities 003c _dispsw_status 004c .text 0054 gfx_driver"
	strings:
		$1 = { F0 FF BD 27 04 00 B0 AF ?? ?? 10 3C ?? ?? 02 8E 0C 00 BF AF 02 00 42 30 08 00 40 10 08 00 B1 AF 21 18 00 00 0C 00 BF 8F 21 10 60 00 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 10 00 BD 27 ?? ?? 02 3C ?? ?? 43 8C 03 00 60 10 ?? ?? 11 3C ?? ?? ?? 0? FF FF 03 24 ?? ?? 22 8E 2C 00 42 8C F1 FF 40 10 FF FF 03 24 09 F8 40 00 00 00 00 00 ?? ?? 23 8E 24 00 62 8C 06 00 40 50 3C 00 62 8C ?? ?? 02 8E 21 18 00 00 02 00 42 34 ?? ?? ?? 0? ?? ?? 02 AE FB FF 40 14 ?? ?? 02 8E ?? ?? ?? 0? FF FF 03 24 }
	condition:
		$1
}

rule file_44_21_0 {
	meta:
		name = "get_gfx_mode_type"
		size = 260
		refs = "0000 system_driver 0028 .text 00e0 _gfx_driver_list"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 43 8C F8 FF BD 27 00 00 B0 AF 80 00 62 8C 04 00 BF AF 31 00 40 10 21 80 80 00 09 F8 40 00 00 00 00 00 ?? ?? ?? 0? 21 18 40 00 1E 00 50 10 0C 00 63 24 04 00 64 8C FC FF 80 54 00 00 62 8C 01 00 02 24 1F 00 02 12 21 20 00 00 02 00 02 2A 0A 00 40 14 02 00 02 24 23 00 02 12 41 53 02 3C 45 46 42 34 0B 00 02 12 04 00 BF 8F 21 10 80 00 00 00 B0 8F 08 00 E0 03 08 00 BD 27 FF FF 02 24 04 00 02 12 04 00 BF 8F F9 FF 00 16 21 10 80 00 04 00 BF 8F 08 00 84 34 21 10 80 00 00 00 B0 8F 08 00 E0 03 08 00 BD 27 88 00 83 8C 05 00 02 24 06 00 04 24 0B 20 43 00 01 00 02 24 E4 FF 02 16 02 00 02 2A 04 00 BF 8F 0E 00 84 34 21 10 80 00 00 00 B0 8F 08 00 E0 03 08 00 BD 27 ?? ?? 02 3C ?? ?? ?? 0? ?? ?? 43 24 04 00 BF 8F 0D 00 84 34 21 10 80 00 00 00 B0 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_44_22_0 {
	meta:
		name = "get_gfx_mode"
		size = 32
		refs = "0000 gfx_driver"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 8C 03 00 40 50 4F 4E 02 3C 08 00 E0 03 00 00 42 8C 08 00 E0 03 45 4E 42 34 }
	condition:
		$1
}

rule file_44_23_0 {
	meta:
		name = "destroy_gfx_mode_list"
		size = 76
		refs = "0020 _al_free"
	strings:
		$1 = { F8 FF BD 27 00 00 B0 AF 04 00 BF AF 0B 00 80 10 21 80 80 00 04 00 84 8C 04 00 80 50 21 20 00 02 ?? ?? ?? 0? 00 00 00 00 21 20 00 02 04 00 BF 8F 00 00 B0 8F ?? ?? ?? 0? 08 00 BD 27 04 00 BF 8F 00 00 B0 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_11_2_118 {
	meta:
		name = "filter_destroy"
		size = 76
		refs = "0020 free"
	strings:
		$1 = { F8 FF BD 27 00 00 B0 AF 04 00 BF AF 0B 00 80 10 21 80 80 00 04 00 84 8C 04 00 80 50 21 20 00 02 ?? ?? ?? 0? 00 00 00 00 21 20 00 02 04 00 BF 8F 00 00 B0 8F ?? ?? ?? 0? 08 00 BD 27 04 00 BF 8F 00 00 B0 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_44_24_0 {
	meta:
		name = "destroy_bitmap"
		size = 424
		refs = "002c gfx_driver 0060 .data 00c4 _al_free 00cc _unregister_switch_bitmap 00d4 system_driver 0138 .bss 0154 .text"
	strings:
		$1 = { F0 FF BD 27 08 00 B1 AF 0C 00 BF AF 04 00 B0 AF 44 00 80 10 21 88 80 00 2C 00 82 8C 46 00 40 04 80 07 42 7C 2C 00 40 10 ?? ?? 02 3C ?? ?? 02 3C ?? ?? 43 8C 44 00 79 8C 26 00 20 13 0C 00 BF 8F 08 00 B1 8F 04 00 B0 8F 08 00 20 03 10 00 BD 27 21 28 20 02 18 00 62 AC 00 00 02 8E 4B 00 40 04 ?? ?? 06 3C 00 00 A2 8C ?? ?? C4 8C F0 FF 03 24 0F 00 42 24 24 10 43 00 40 20 04 00 21 10 44 00 05 B5 03 34 2A 18 43 00 03 00 60 14 ?? ?? C2 AC 04 B5 02 34 ?? ?? C2 AC ?? ?? 06 3C ?? ?? C2 8C 04 00 A4 8C 05 B5 03 34 40 10 02 00 21 10 44 00 2A 18 43 00 03 00 60 14 ?? ?? C2 AC 04 B5 02 34 ?? ?? C2 AC ?? ?? ?? 0? 21 20 00 02 ?? ?? ?? 0? 21 20 20 02 ?? ?? 02 3C ?? ?? 43 8C 48 00 62 8C 06 00 40 50 28 00 24 8E 09 F8 40 00 21 20 20 02 0D 00 40 14 0C 00 BF 8F 28 00 24 8E 04 00 80 50 21 20 20 02 ?? ?? ?? 0? 00 00 00 00 21 20 20 02 0C 00 BF 8F 08 00 B1 8F 04 00 B0 8F ?? ?? ?? 0? 10 00 BD 27 0C 00 BF 8F 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 10 00 BD 27 ?? ?? 03 3C ?? ?? 70 8C E2 FF 00 12 00 00 00 00 10 00 05 8E 06 00 A4 54 21 18 00 02 ?? ?? ?? 0? 18 00 02 8E BC FF 51 50 18 00 02 8E 21 18 00 02 18 00 10 8E FB FF 00 56 10 00 02 8E ?? ?? ?? 0? 21 20 20 02 ?? ?? ?? 0? ?? ?? 02 3C ?? ?? ?? 0? ?? ?? 62 AC ?? ?? 02 3C ?? ?? 43 8C 34 00 62 8C 09 F8 40 00 21 20 A0 00 ?? ?? ?? 0? 21 20 00 02 }
	condition:
		$1
}

rule file_44_25_0 {
	meta:
		name = "create_bitmap_ex"
		size = 504
		refs = "0008 system_driver 0068 _get_vtable 00b4 _al_malloc 0100 _stub_bank_switch 01c0 .text 01e8 _al_free"
	strings:
		$1 = { E0 FF BD 27 0C 00 B3 AF ?? ?? 13 3C ?? ?? 62 8E 08 00 B2 AF 04 00 B1 AF 38 00 59 8C 00 00 B0 AF 1C 00 BF AF 18 00 B6 AF 14 00 B5 AF 10 00 B4 AF 21 88 80 00 21 90 A0 00 0B 00 20 13 21 80 C0 00 1C 00 BF 8F 18 00 B6 8F 14 00 B5 8F 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 20 03 20 00 BD 27 ?? ?? ?? 0? 00 00 00 00 0D 00 40 14 21 A8 40 00 21 A0 00 00 1C 00 BF 8F 21 10 80 02 18 00 B6 8F 14 00 B5 8F 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 20 00 BD 27 02 00 04 24 2C 20 04 02 10 00 84 24 ?? ?? ?? 0? 80 20 04 00 EF FF 40 10 21 A0 40 00 09 00 36 2A 3F 00 C0 12 11 00 22 2A 01 00 05 24 18 00 12 02 18 00 24 3A 01 00 84 2C 12 10 00 00 18 00 45 00 12 10 00 00 ?? ?? ?? 0? 21 20 44 00 21 20 40 00 3B 00 40 10 28 00 82 AE ?? ?? 03 3C ?? ?? 63 24 FF FF 02 24 08 00 82 AE 1C 00 95 AE 20 00 83 AE 10 00 92 AE 00 00 92 AE 18 00 90 AE 04 00 90 AE 14 00 80 AE 0C 00 80 AE 24 00 83 AE 2C 00 80 AE 30 00 80 AE 34 00 80 AE 38 00 80 AE 18 00 00 1A 3C 00 80 AE 01 00 02 24 15 00 02 12 40 00 84 AE 19 00 23 2A 04 00 08 24 03 00 02 24 0B 40 43 00 21 28 80 02 01 00 06 24 11 00 24 2A 02 00 02 24 0A 10 04 01 02 00 C0 12 40 00 A7 8C 01 00 02 24 18 00 52 00 01 00 C6 24 2A 18 D0 00 12 10 00 00 21 10 E2 00 44 00 A2 AC F4 FF 60 14 04 00 A5 24 ?? ?? 62 8E 3C 00 42 8C B3 FF 40 50 1C 00 BF 8F 09 F8 40 00 21 20 80 02 ?? ?? ?? 0? 1C 00 BF 8F 03 00 40 10 19 00 23 2A ?? ?? ?? 0? 02 00 05 24 04 00 05 24 03 00 02 24 ?? ?? ?? 0? 0B 28 43 00 ?? ?? ?? 0? 21 20 80 02 ?? ?? ?? 0? 21 A0 00 00 }
	condition:
		$1
}

rule file_44_26_0 {
	meta:
		name = "create_bitmap"
		size = 24
		refs = "0000 _color_depth 0010 create_bitmap_ex"
	strings:
		$1 = { ?? ?? 03 3C 21 10 80 00 ?? ?? 64 8C 21 30 A0 00 ?? ?? ?? 0? 21 28 40 00 }
	condition:
		$1
}

rule file_44_27_0 {
	meta:
		name = "create_system_bitmap"
		size = 72
		refs = "0000 gfx_driver 0024 create_bitmap"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 43 8C F8 FF BD 27 04 00 BF AF 40 00 79 8C 03 00 20 13 04 00 BF 8F 08 00 20 03 08 00 BD 27 ?? ?? ?? 0? 00 00 00 00 2C 00 44 8C 04 00 BF 8F 00 40 05 3C 25 20 85 00 2C 00 44 AC 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_44_28_0 {
	meta:
		name = "create_sub_bitmap"
		size = 720
		refs = "006c system_driver 00c8 _al_malloc 0164 _sub_bitmap_id_count 02a8 .text 02c0 _register_switch_bitmap"
	strings:
		$1 = { 00 00 83 8C 21 10 E5 00 E0 FF BD 27 2A 10 62 00 10 00 B4 AF 0C 00 B3 AF 08 00 B2 AF 04 00 B1 AF 00 00 B0 AF 1C 00 BF AF 18 00 B6 AF 14 00 B5 AF 21 80 80 00 21 90 A0 00 21 88 E0 00 21 A0 C0 00 02 00 40 10 21 98 00 01 23 88 65 00 04 00 03 8E 21 10 74 02 2A 10 62 00 01 00 40 54 23 98 74 00 1C 00 02 8E 18 00 59 8C 10 00 20 13 ?? ?? 15 3C 21 20 00 02 21 28 40 02 21 30 80 02 21 38 20 02 21 40 60 02 1C 00 BF 8F 18 00 B6 8F 14 00 B5 8F 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 20 03 20 00 BD 27 ?? ?? A2 8E 40 00 59 8C EF FF 20 57 21 20 00 02 02 00 04 24 2C 20 64 02 10 00 84 24 ?? ?? ?? 0? 80 20 04 00 68 00 40 10 21 B0 40 00 1C 00 09 8E 10 00 22 8D 05 00 40 50 34 00 03 8E 09 F8 40 00 21 20 00 02 1C 00 09 8E 34 00 03 8E 38 00 04 8E 2C 00 0A 8E FF 01 02 3C 20 00 05 8E 24 00 06 8E 3C 00 07 8E FF FF 4B 34 21 18 43 02 21 20 84 02 FF FF 02 24 24 40 4B 01 00 00 D1 AE 08 00 C2 AE 1C 00 C9 AE 20 00 C5 AE 24 00 C6 AE 34 00 C3 AE 38 00 C4 AE 3C 00 C7 AE 10 00 D1 AE 18 00 D3 AE 04 00 D3 AE 14 00 C0 AE 0C 00 C0 AE 28 00 C0 AE 08 00 00 15 30 00 C0 AE ?? ?? 04 3C ?? ?? 83 8C 01 00 62 24 24 10 4B 00 25 50 43 01 ?? ?? 82 AC 2C 00 0A AE 00 20 02 3C FF FB 03 3C 25 10 42 01 FF FF 63 34 24 10 43 00 00 07 44 7C 06 00 80 10 2C 00 C2 AE 04 00 02 24 02 00 40 14 1A 00 42 02 CD 01 00 00 12 90 00 00 1C 00 C6 8E 00 00 C3 8C 09 00 62 28 37 00 40 10 11 00 62 28 01 00 05 24 0F 00 60 1A 18 00 B2 00 10 00 82 26 80 10 02 00 21 20 02 02 21 40 C0 02 21 38 00 00 12 28 00 00 00 00 82 8C 01 00 E7 24 2A 18 F3 00 21 10 45 00 40 00 02 AD 04 00 84 24 F9 FF 60 14 04 00 08 25 0C 00 C2 8C 04 00 40 50 1C 00 02 8E 09 F8 40 00 21 20 C0 02 1C 00 02 8E 1C 00 42 8C 03 00 40 10 21 20 C0 02 09 F8 40 00 21 28 00 02 ?? ?? A2 8E 44 00 42 8C 03 00 40 10 21 20 C0 02 09 F8 40 00 21 28 00 02 2C 00 02 8E 1A 00 40 04 21 20 C0 02 1C 00 02 8E 14 00 42 8C 04 00 40 10 1C 00 BF 8F 09 F8 40 00 21 20 00 02 1C 00 BF 8F 21 10 C0 02 18 00 B6 8F 14 00 B5 8F 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 20 00 BD 27 03 00 40 50 19 00 63 28 ?? ?? ?? 0? 02 00 05 24 04 00 05 24 03 00 02 24 ?? ?? ?? 0? 0B 28 43 00 ?? ?? ?? 0? 21 28 00 02 ?? ?? ?? 0? 1C 00 02 8E }
	condition:
		$1
}

rule file_44_29_0 {
	meta:
		name = "add_vram_block"
		size = 272
		refs = "002c _al_malloc 003c screen 0060 create_sub_bitmap 0070 .bss 0094 .text 00e4 _al_free"
	strings:
		$1 = { E8 FF BD 27 10 00 B4 AF 21 A0 80 00 1C 00 04 24 0C 00 B3 AF 08 00 B2 AF 04 00 B1 AF 00 00 B0 AF 14 00 BF AF 21 88 A0 00 21 90 C0 00 ?? ?? ?? 0? 21 98 E0 00 2D 00 40 10 21 80 40 00 ?? ?? 02 3C ?? ?? 44 8C 00 00 14 AE 04 00 11 AE 08 00 12 AE 0C 00 13 AE 21 28 80 02 21 30 20 02 21 38 40 02 ?? ?? ?? 0? 21 40 60 02 1E 00 40 10 10 00 02 AE ?? ?? 04 3C ?? ?? 83 8C 0F 00 60 50 ?? ?? 84 24 04 00 05 8E 04 00 62 8C 2A 10 45 00 07 00 40 54 18 00 64 24 ?? ?? ?? 0? ?? ?? 84 24 2A 10 45 00 06 00 40 10 14 00 BF 8F 18 00 64 24 18 00 63 8C FA FF 60 54 04 00 62 8C 14 00 BF 8F 10 00 02 8E 00 00 90 AC 10 00 B4 8F 18 00 03 AE 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 18 00 BD 27 ?? ?? ?? 0? 21 20 00 02 14 00 BF 8F 21 10 00 00 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_44_30_0 {
	meta:
		name = "create_video_bitmap"
		size = 712
		refs = "0000 _dispsw_status 0020 gfx_driver 0044 _al_malloc 004c .bss 0088 screen 00dc .data 013c .text"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 43 8C F0 FF BD 27 0C 00 BF AF 08 00 B0 AF 21 30 80 00 22 00 60 14 21 38 A0 00 ?? ?? 02 3C ?? ?? 43 8C 30 00 62 8C 16 00 40 50 ?? ?? 02 3C 09 F8 40 00 00 00 00 00 1A 00 40 10 21 80 40 00 ?? ?? ?? 0? 1C 00 04 24 ?? ?? 05 3C ?? ?? A4 8C 0C 00 BF 8F FF FF 03 24 18 00 44 AC 10 00 50 AC 04 00 43 AC ?? ?? A2 AC 00 00 43 AC 08 00 40 AC 0C 00 40 AC 21 10 00 02 08 00 B0 8F 08 00 E0 03 10 00 BD 27 ?? ?? 48 8C 02 00 00 11 21 10 00 00 00 00 02 8D 2A 10 46 00 07 00 40 10 00 00 00 00 21 80 00 00 0C 00 BF 8F 21 10 00 02 08 00 B0 8F 08 00 E0 03 10 00 BD 27 01 00 00 55 04 00 02 8D 2A 10 47 00 F7 FF 40 14 21 80 00 00 F6 FF C0 04 0C 00 BF 8F F4 FF E0 04 ?? ?? 0E 3C ?? ?? CD 8D 2A 10 CD 00 30 00 40 10 ?? ?? 03 3C ?? ?? 02 3C ?? ?? 4B 8C 00 00 A0 AF 21 28 00 00 21 78 A0 03 F0 FF 10 24 05 00 60 11 21 18 A7 00 04 00 62 8D 2A 10 43 00 2A 00 40 14 00 00 A3 8F 00 00 AA 8F 1D 00 40 11 21 20 00 00 00 00 43 8D 2A 10 66 00 19 00 40 10 21 48 40 01 ?? ?? ?? 0? 08 00 22 8D 00 00 03 8D 21 10 86 00 2A 10 62 00 30 00 40 54 04 00 43 8D 14 00 29 8D 0F 00 20 11 21 10 86 00 00 00 23 8D 2A 10 62 00 0B 00 40 10 00 00 00 00 08 00 22 8D 21 10 62 00 0F 00 43 24 2A 10 82 00 F5 FF 40 50 14 00 29 8D ED FF 00 15 24 20 70 00 ?? ?? ?? 0? 21 18 00 00 ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 21 80 40 00 ?? ?? 62 8C 2A 10 E2 00 CF FF 40 14 ?? ?? 02 3C ?? ?? ?? 0? 21 80 00 00 0F 00 60 10 21 20 E0 01 00 00 69 8D 00 00 62 8C 2A 10 49 00 07 00 40 54 14 00 64 24 ?? ?? ?? 0? 00 00 8B AC 2A 10 49 00 06 00 40 50 00 00 8B AC 14 00 64 24 14 00 63 8C FA FF 60 54 00 00 62 8C 00 00 8B AC 14 00 63 AD ?? ?? ?? 0? 18 00 6B 8D 0C 00 42 8D 14 00 49 8D 21 28 43 00 08 00 20 11 21 60 A0 00 21 20 20 01 0C 00 82 8C 04 00 83 8C 14 00 84 8C 21 10 43 00 FB FF 80 14 2D 28 A2 00 02 00 00 11 21 18 00 00 04 00 03 8D 21 10 A7 00 2A 10 62 00 0F 00 40 14 21 20 E0 01 ?? ?? ?? 0? 2A 10 AC 00 14 00 49 8D A6 FF 20 11 21 50 20 01 04 00 23 8D 0C 00 22 8D 14 00 29 8D 21 60 43 00 2A 10 AC 00 F7 FF 40 50 00 00 89 AC ?? ?? ?? 0? 14 00 44 25 18 00 E6 00 ?? ?? 04 3C ?? ?? 82 8C 12 18 00 00 18 00 A2 01 12 10 00 00 2A 18 62 00 7C FF 60 10 21 80 00 00 ?? ?? C6 AD ?? ?? ?? 0? ?? ?? 87 AC }
	condition:
		$1
}

rule file_44_31_0 {
	meta:
		name = "_make_bitmap"
		size = 592
		refs = "003c _get_vtable 0084 _al_malloc 0094 _gfx_bank 009c _al_realloc 00b0 _screen_vtable 00b4 _stub_bank_switch 014c _last_bank_1 0158 _last_bank_2 01f8 .text 0240 _al_free"
	strings:
		$1 = { D8 FF BD 27 10 00 B3 AF 21 98 80 00 21 20 00 01 1C 00 B6 AF 18 00 B5 AF 14 00 B4 AF 0C 00 B2 AF 08 00 B1 AF 24 00 BF AF 20 00 B7 AF 04 00 B0 AF 21 90 A0 00 21 B0 C0 00 21 A8 E0 00 ?? ?? ?? 0? 21 A0 20 01 0E 00 40 14 21 88 40 00 21 80 00 00 24 00 BF 8F 21 10 00 02 20 00 B7 8F 1C 00 B6 8F 18 00 B5 8F 14 00 B4 8F 10 00 B3 8F 0C 00 B2 8F 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 28 00 BD 27 10 00 44 26 ?? ?? ?? 0? 80 20 04 00 F0 FF 40 10 21 80 40 00 ?? ?? 17 3C ?? ?? E4 8E ?? ?? ?? 0? 80 28 12 00 66 00 40 10 ?? ?? E2 AE FF FF 02 24 ?? ?? 04 3C ?? ?? 03 3C ?? ?? 84 24 ?? ?? 63 24 08 00 02 AE 00 80 02 3C 21 38 20 02 00 00 13 AE 20 00 03 AE 2C 00 02 AE 10 00 13 AE 18 00 12 AE 04 00 12 AE 14 00 00 AE 0C 00 00 AE 1C 00 04 AE 24 00 03 AE 28 00 00 AE 30 00 00 AE 34 00 00 AE 38 00 00 AE 3C 00 00 AE 21 30 80 00 F0 00 28 26 00 00 E2 8C 04 00 E3 8C 08 00 E4 8C 0C 00 E5 8C 10 00 E7 24 00 00 C2 AC 04 00 C3 AC 08 00 C4 AC 0C 00 C5 AC F6 FF E8 14 10 00 C6 24 04 00 E3 8C 00 00 E5 8C ?? ?? E8 8E FF FF 04 24 ?? ?? 02 3C 04 00 C3 AC ?? ?? 44 AC ?? ?? 02 3C 00 00 C5 AC ?? ?? 44 AC 00 00 00 AD 74 00 A2 8E 84 00 B6 AE 23 00 40 14 40 00 16 AE 02 00 42 2A B4 FF 40 14 21 48 00 01 78 00 A2 8E FF FF 8B 26 21 50 C2 02 21 38 00 02 01 00 08 24 21 28 00 00 40 00 E3 8C 21 18 74 00 21 10 6B 00 2B 10 4A 00 0C 00 40 14 44 00 E3 AC 7C 00 A6 8E 21 20 C6 02 2B 10 64 00 08 00 40 54 01 00 08 25 23 30 06 00 21 18 66 00 2B 10 64 00 44 00 E3 AC FC FF 40 10 01 00 A5 24 01 00 08 25 2A 10 12 01 04 00 25 AD 04 00 E7 24 EA FF 40 14 04 00 29 25 ?? ?? ?? 0? 24 00 BF 8F 02 00 42 2A 92 FF 40 14 21 30 00 01 21 20 00 02 01 00 05 24 40 00 82 8C 01 00 A5 24 2A 18 B2 00 21 10 54 00 44 00 82 AC 04 00 C0 AC 04 00 84 24 F8 FF 60 14 04 00 C6 24 ?? ?? ?? 0? 24 00 BF 8F ?? ?? ?? 0? 21 20 00 02 ?? ?? ?? 0? 21 80 00 00 }
	condition:
		$1
}

rule file_44_32_0 {
	meta:
		name = "init_gfx_driver"
		size = 132
		refs = "0030 get_config_text 0038 _color_depth 0044 gfx_driver"
	strings:
		$1 = { E8 FF BD 27 00 00 B0 AF 21 80 80 00 0C 00 84 8C 14 00 BF AF 10 00 B4 AF 0C 00 B3 AF 21 A0 00 01 21 98 E0 00 08 00 B2 AF 04 00 B1 AF 21 90 C0 00 ?? ?? ?? 0? 21 88 A0 00 ?? ?? 03 3C 10 00 19 8E ?? ?? 68 8C ?? ?? 03 3C 04 00 02 AE ?? ?? 70 AC 08 00 02 AE 21 20 20 02 21 28 40 02 21 30 60 02 21 38 80 02 14 00 BF 8F 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 20 03 18 00 BD 27 }
	condition:
		$1
}

rule file_44_33_0 {
	meta:
		name = "get_config_gfx_driver"
		size = 688
		refs = "0084 $LC2 0098 uconvert 00ac uszprintf 00b4 $LC4 00d8 get_config_id 0100 .text 0188 $LC3 0078 $LC1 01d8 _color_depth 01fc $LC0 028c screen"
	strings:
		$1 = { 80 FD BD 27 75 63 02 3C 6C 02 B5 AF 53 41 03 3C 2E 72 55 34 02 00 22 31 01 00 29 31 78 02 BE AF 74 02 B7 AF 70 02 B6 AF 68 02 B4 AF 64 02 B3 AF 60 02 B2 AF 5C 02 B1 AF 58 02 B0 AF 7C 02 BF AF 21 98 80 00 21 F0 A0 00 40 02 A6 AF 44 02 A7 AF 48 02 A8 AF 21 88 40 01 38 43 74 34 50 02 A2 AF 21 B0 00 00 FE FF 10 24 40 00 B2 27 FF FF 17 24 4C 02 A9 AF 52 00 17 12 ?? ?? 04 3C 40 00 00 16 FE FF 03 24 ?? ?? 04 3C 21 28 80 02 21 30 A0 03 21 38 A0 02 ?? ?? 84 24 ?? ?? ?? 0? 40 00 08 24 21 30 40 00 21 20 40 02 00 02 05 24 ?? ?? ?? 0? 21 38 60 02 ?? ?? 04 3C 21 30 A0 03 21 38 A0 02 40 00 08 24 ?? ?? 84 24 ?? ?? ?? 0? 21 28 80 02 21 20 40 00 21 28 40 02 ?? ?? ?? 0? 21 30 00 00 1F 00 40 10 21 28 40 00 04 00 24 8E 0C 00 80 50 01 00 10 26 00 00 22 8E 51 00 A2 10 21 18 20 02 ?? ?? ?? 0? 10 00 64 8C 4D 00 A2 10 0C 00 63 24 10 00 64 8C FC FF 80 54 0C 00 62 8C 01 00 10 26 FF 00 02 24 D3 FF 02 16 00 00 00 00 7C 02 BF 8F 21 10 C0 02 78 02 BE 8F 74 02 B7 8F 70 02 B6 8F 6C 02 B5 8F 68 02 B4 8F 64 02 B3 8F 60 02 B2 8F 5C 02 B1 8F 58 02 B0 8F 08 00 E0 03 80 02 BD 27 02 00 02 2A F1 FF 40 10 01 00 10 26 FF 00 02 24 C0 FF 02 16 7C 02 BF 8F ?? ?? ?? 0? 21 10 C0 02 1E 00 03 12 21 38 A0 02 ?? ?? 04 3C 21 28 80 02 21 30 A0 03 40 00 08 24 ?? ?? ?? 0? ?? ?? 84 24 21 30 40 00 21 20 40 02 00 02 05 24 21 38 60 02 ?? ?? ?? 0? 21 40 00 02 ?? ?? ?? 0? ?? ?? 04 3C 21 28 80 02 21 30 A0 03 21 38 A0 02 ?? ?? 84 24 ?? ?? ?? 0? 40 00 08 24 ?? ?? 03 3C ?? ?? 68 8C 21 20 40 02 21 30 40 00 00 02 05 24 ?? ?? ?? 0? 21 38 60 02 ?? ?? ?? 0? ?? ?? 04 3C ?? ?? 04 3C 21 28 80 02 21 30 A0 03 ?? ?? 84 24 ?? ?? ?? 0? 40 00 08 24 ?? ?? 03 3C ?? ?? 6A 8C 40 02 A9 8F 21 20 40 02 21 30 40 00 00 02 05 24 21 38 60 02 ?? ?? ?? 0? 21 40 C0 03 ?? ?? ?? 0? ?? ?? 04 3C 4C 02 A2 8F 05 00 40 10 50 02 A3 8F 88 00 82 8C B3 FF 40 54 01 00 10 26 50 02 A3 8F 05 00 60 10 40 02 A6 8F 88 00 82 8C AD FF 40 50 01 00 10 26 40 02 A6 8F 44 02 A7 8F 48 02 A8 8F ?? ?? ?? 0? 21 28 C0 03 ?? ?? 03 3C 07 00 40 14 ?? ?? 62 AC 01 00 10 26 FF 00 02 24 76 FF 02 16 FF FF 16 24 ?? ?? ?? 0? 7C 02 BF 8F ?? ?? ?? 0? FF FF 16 24 }
	condition:
		$1
}

rule file_44_34_0 {
	meta:
		name = "_set_gfx_mode"
		size = 1704
		refs = "0008 .data 0054 timer_simulate_retrace 0058 gfx_driver 0060 _screen_split_position 0070 _al_linker_mouse 008c .bss 009c destroy_bitmap 00ac screen 0128 gfx_capabilities 0130 _set_current_refresh_rate 0144 system_driver 0150 _gfx_bank 0168 _al_free 01d8 $LC7 01f4 uconvert 0214 .text 02a0 $LC4 02bc $LC9 02e4 get_config_string 02f4 ugetc 032c _wait_for_vsync 0344 _dispsw_status 0354 clear_bitmap 035c _palette_color8 0380 set_palette 037c default_palette 0388 _color_depth 039c gui_fg_color 03a8 gui_mg_color 03ac gui_bg_color 03d8 _register_switch_bitmap 0140 usetc 0418 allegro_error 04c4 _add_exit_func 04bc $LC5 04f8 makecol 0434 _gfx_driver_list 01bc $LC6 0684 get_config_text 0680 $LC8 0698 ustrzcpy"
	strings:
		$1 = { 50 FF BD 27 88 00 B0 AF ?? ?? 10 3C ?? ?? 02 8E A8 00 BE AF A4 00 B7 AF 9C 00 B5 AF 90 00 B2 AF AC 00 BF AF A0 00 B6 AF 98 00 B4 AF 94 00 B3 AF 8C 00 B1 AF 21 90 80 00 21 B8 A0 00 21 F0 C0 00 80 00 A7 AF 84 00 A8 AF 14 01 40 14 21 A8 20 01 21 20 00 00 ?? ?? ?? 0? ?? ?? 16 3C ?? ?? C3 8E ?? ?? 02 3C ?? ?? 11 3C 20 01 60 10 ?? ?? 40 AC ?? ?? 02 3C ?? ?? 42 8C 05 00 40 10 ?? ?? 10 3C 04 00 42 8C 09 F8 40 00 21 20 00 00 ?? ?? 10 3C ?? ?? 02 8E 06 00 40 10 ?? ?? 13 3C ?? ?? ?? 0? 10 00 44 8C ?? ?? 02 8E FC FF 40 14 ?? ?? 13 3C ?? ?? 64 8E 24 00 83 8C 09 F8 60 00 21 28 00 00 ?? ?? 64 8E 20 00 83 8C 09 F8 60 00 21 28 00 00 ?? ?? 64 8E 1C 00 83 8C 08 00 62 8C 09 F8 40 00 00 00 00 00 ?? ?? C3 8E 18 00 62 8C 03 00 40 10 21 20 00 00 09 F8 40 00 21 28 00 00 ?? ?? C2 8E 14 00 42 8C 04 00 40 10 ?? ?? 64 8E 09 F8 40 00 ?? ?? 64 8E ?? ?? 64 8E ?? ?? ?? 0? ?? ?? 14 3C ?? ?? 60 AE ?? ?? C0 AE ?? ?? 80 AE 21 20 00 00 ?? ?? ?? 0? ?? ?? 80 AE FF FF 02 24 B5 00 42 16 ?? ?? 02 3C ?? ?? 22 8E 34 00 42 8C 03 00 40 10 ?? ?? 10 3C 09 F8 40 00 00 00 00 00 ?? ?? 04 8E A0 00 80 10 21 10 00 00 ?? ?? ?? 0? 00 00 00 00 AC 00 BF 8F ?? ?? 00 AE 21 10 00 00 A8 00 BE 8F A4 00 B7 8F A0 00 B6 8F 9C 00 B5 8F 98 00 B4 8F 94 00 B3 8F 90 00 B2 8F 8C 00 B1 8F 88 00 B0 8F 08 00 E0 03 B0 00 BD 27 01 00 12 24 EC 00 A0 12 00 00 A0 A3 02 00 42 32 18 01 40 10 ?? ?? 04 3C 21 18 00 00 01 00 42 32 15 00 40 14 00 00 00 00 16 00 60 14 ?? ?? 13 3C ?? ?? 04 3C 53 41 05 3C 75 63 07 3C ?? ?? 84 24 38 43 A5 34 2E 72 E7 34 21 30 A0 03 ?? ?? ?? 0? 40 00 08 24 80 00 A7 8F 84 00 A8 8F 21 20 40 00 21 28 E0 02 21 30 C0 03 21 48 40 02 ?? ?? ?? 0? 21 50 20 02 21 18 40 00 D0 00 60 50 04 00 23 8E ?? ?? 13 3C ?? ?? 63 8E 0C 01 60 10 ?? ?? 02 3C ?? ?? C4 8E F1 00 80 10 00 00 65 8C 6C 00 82 8C 2A 10 45 00 08 00 40 54 18 00 82 8C 02 00 80 10 04 00 63 8C 70 00 82 8C 2A 10 43 00 0D 00 40 50 53 41 12 3C 18 00 82 8C 03 00 40 10 ?? ?? 82 8E 01 00 42 34 ?? ?? 82 AE 24 00 82 8C E1 00 40 50 3C 00 82 8C ?? ?? 82 8E 02 00 42 34 ?? ?? 82 AE 53 41 12 3C 75 63 10 3C ?? ?? 04 3C ?? ?? 84 24 38 43 45 36 21 30 A0 03 2E 72 07 36 ?? ?? ?? 0? 40 00 08 24 ?? ?? 04 3C 2E 72 07 36 ?? ?? 84 24 38 43 45 36 40 00 A6 27 40 00 08 24 ?? ?? ?? 0? 21 88 40 00 21 28 40 00 21 20 20 02 ?? ?? ?? 0? 21 30 00 00 0E 00 40 10 21 20 40 00 ?? ?? 02 3C ?? ?? 43 8C 09 F8 60 00 00 00 00 00 08 00 40 10 21 18 40 00 79 00 02 24 8C 00 62 10 59 00 02 24 8A 00 62 10 31 00 02 24 89 00 62 10 ?? ?? 02 3C FF FF 03 24 ?? ?? 02 3C ?? ?? 43 AC ?? ?? C2 8E 58 00 44 8C 05 00 80 10 00 00 00 00 ?? ?? 02 3C ?? ?? 43 8C 80 00 60 10 00 00 00 00 ?? ?? ?? 0? ?? ?? 64 8E ?? ?? 02 3C ?? ?? 42 24 21 18 00 00 00 01 04 24 00 00 43 AC 01 00 63 24 FD FF 64 14 04 00 42 24 ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 84 24 ?? ?? 02 3C ?? ?? 45 8C 08 00 03 24 57 00 A3 14 21 20 00 00 ?? ?? 02 3C FF 00 04 24 ?? ?? 44 AC ?? ?? 03 3C ?? ?? 02 3C ?? ?? 65 AC ?? ?? 40 AC ?? ?? 02 3C ?? ?? 42 8C 05 00 40 10 ?? ?? 64 8E 00 00 42 8C 09 F8 40 00 00 00 00 00 ?? ?? 64 8E ?? ?? ?? 0? 21 28 00 00 21 10 00 00 AC 00 BF 8F A8 00 BE 8F A4 00 B7 8F A0 00 B6 8F 9C 00 B5 8F 98 00 B4 8F 94 00 B3 8F 90 00 B2 8F 8C 00 B1 8F 88 00 B0 8F 08 00 E0 03 B0 00 BD 27 ?? ?? 46 8C ?? ?? 02 3C ?? ?? 44 24 09 F8 C0 00 21 28 00 00 ?? ?? 23 8E 80 00 62 8C 42 00 40 50 ?? ?? 02 3C 09 F8 40 00 00 00 00 00 21 88 40 00 01 00 02 24 57 FF 42 12 02 00 02 24 56 FF 42 52 02 00 12 24 54 FF 40 52 21 90 00 00 04 00 24 8E 71 FF 80 10 ?? ?? 13 3C 00 00 22 8E 5D 00 42 12 80 00 A7 8F ?? ?? ?? 0? 21 50 20 02 58 00 42 12 0C 00 4A 25 10 00 44 8D FC FF 80 54 0C 00 42 8D ?? ?? ?? 0? ?? ?? 13 3C ?? ?? 11 3C ?? ?? 22 8E 30 00 42 8C 04 00 40 10 ?? ?? 04 3C 09 F8 40 00 00 00 00 00 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 84 24 ?? ?? ?? 0? ?? ?? A5 24 ?? ?? 16 3C 21 20 00 00 ?? ?? ?? 0? ?? ?? 00 AE ?? ?? C3 8E ?? ?? 02 3C E2 FE 60 14 ?? ?? 40 AC ?? ?? ?? 0? ?? ?? 14 3C 21 28 00 00 ?? ?? ?? 0? 21 30 00 00 ?? ?? 03 3C 80 00 04 24 80 00 05 24 80 00 06 24 ?? ?? ?? 0? ?? ?? 62 AC ?? ?? 03 3C FF 00 04 24 FF 00 05 24 FF 00 06 24 ?? ?? ?? 0? ?? ?? 62 AC ?? ?? 03 3C ?? ?? ?? 0? ?? ?? 62 AC ?? ?? ?? 0? ?? ?? 51 24 ?? ?? 02 3C ?? ?? ?? 0? ?? ?? 40 AC 09 F8 80 00 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 04 00 23 8E 30 FF 60 10 02 00 55 32 0C 00 30 26 ?? ?? 13 3C 01 00 52 32 08 00 22 8E 14 00 40 10 21 88 00 02 21 20 60 00 21 28 E0 02 21 30 C0 03 80 00 A7 8F 04 00 40 12 84 00 A8 8F 88 00 62 8C 0C 00 40 54 04 00 03 8E 04 00 A0 12 00 00 00 00 88 00 62 8C 07 00 40 50 04 00 03 8E ?? ?? ?? 0? 00 00 00 00 21 18 40 00 1B FF 40 14 ?? ?? 62 AE 04 00 03 8E E8 FF 60 14 0C 00 10 26 ?? ?? ?? 0? ?? ?? 63 8E 80 00 A7 8F 84 00 A8 8F 21 28 E0 02 ?? ?? ?? 0? 21 30 C0 03 ?? ?? 13 3C ?? ?? ?? 0? ?? ?? 62 AE ?? ?? ?? 0? 21 10 00 00 20 FF 40 14 ?? ?? 82 8E ?? ?? ?? 0? 53 41 12 3C 53 41 05 3C 75 63 07 3C ?? ?? 84 24 38 43 A5 34 2E 72 E7 34 21 30 A0 03 ?? ?? ?? 0? 40 00 08 24 80 00 A7 8F 84 00 A8 8F 21 20 40 00 21 28 E0 02 21 30 C0 03 21 48 40 02 ?? ?? ?? 0? 21 50 20 02 ?? ?? ?? 0? 21 18 40 00 ?? ?? 43 8C ?? ?? 02 3C ?? ?? C0 AE 09 F8 60 00 ?? ?? 44 24 5A FF 40 54 FF FF 02 24 ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 84 24 ?? ?? 04 3C 21 30 40 00 ?? ?? 84 24 ?? ?? ?? 0? 00 01 05 24 ?? ?? ?? 0? FF FF 02 24 }
	condition:
		$1
}

rule file_44_35_0 {
	meta:
		name = "shutdown_gfx"
		size = 108
		refs = "003c .text 0000 gfx_driver 0024 set_gfx_mode 002c system_driver 004c _remove_exit_func 005c .data"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 43 8C F8 FF BD 27 07 00 60 10 04 00 BF AF FF FF 04 24 21 28 00 00 21 30 00 00 21 38 00 00 ?? ?? ?? 0? 21 40 00 00 ?? ?? 02 3C ?? ?? 43 8C 34 00 62 8C 04 00 40 50 ?? ?? 04 3C 09 F8 40 00 00 00 00 00 ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 84 24 04 00 BF 8F FF FF 03 24 ?? ?? 02 3C ?? ?? 43 AC 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_44_36_0 {
	meta:
		name = "_set_gfx_mode_safe"
		size = 400
		refs = "0008 system_driver 0038 allegro_error 0044 ustrzcpy 0074 .text 00b4 set_color_depth 0118 uconvert 0100 $LC10 0120 $LC11 0128 get_config_text 0134 allegro_message 017c _safe_gfx_mode_change"
	strings:
		$1 = { 98 FE BD 27 50 01 B0 AF ?? ?? 10 3C ?? ?? 03 8E 58 01 B2 AF 54 01 B1 AF 68 00 62 8C 64 01 BF AF 60 01 B4 AF 5C 01 B3 AF 21 88 A0 00 4C 00 40 10 21 90 C0 00 50 00 B3 27 ?? ?? 14 3C ?? ?? 86 26 21 20 60 02 ?? ?? ?? 0? 00 01 05 24 ?? ?? 03 8E 21 20 A0 03 68 00 62 8C 09 F8 40 00 04 00 A5 27 00 00 A4 8F 21 28 20 02 21 30 40 02 21 38 00 00 21 40 00 00 ?? ?? ?? 0? FF FF 09 24 0A 00 40 14 21 30 60 02 64 01 BF 8F 21 10 00 00 60 01 B4 8F 5C 01 B3 8F 58 01 B2 8F 54 01 B1 8F 50 01 B0 8F 08 00 E0 03 68 01 BD 27 00 01 05 24 ?? ?? ?? 0? ?? ?? 84 26 ?? ?? ?? 0? 0C 00 A4 8F 00 00 A4 8F 04 00 A5 8F 08 00 A6 8F 21 38 00 00 21 40 00 00 ?? ?? ?? 0? FF FF 09 24 EB FF 40 10 64 01 BF 8F FF FF 09 24 FF FF 04 24 21 28 00 00 21 30 00 00 21 38 00 00 ?? ?? ?? 0? 21 40 00 00 75 63 07 3C ?? ?? 04 3C 53 41 05 3C 10 00 A6 27 2E 72 E7 34 38 43 A5 34 40 00 08 24 ?? ?? ?? 0? ?? ?? 84 24 ?? ?? 04 3C ?? ?? 84 24 ?? ?? ?? 0? 21 80 40 00 21 28 40 00 ?? ?? ?? 0? 21 20 00 02 64 01 BF 8F FF FF 02 24 60 01 B4 8F 5C 01 B3 8F 58 01 B2 8F 54 01 B1 8F 50 01 B0 8F 08 00 E0 03 68 01 BD 27 ?? ?? 10 3C 01 00 02 24 21 20 00 00 21 38 00 00 21 40 00 00 FF FF 09 24 ?? ?? ?? 0? ?? ?? 02 AE D7 FF 40 14 ?? ?? 00 AE ?? ?? ?? 0? 64 01 BF 8F }
	condition:
		$1
}

rule file_44_37_0 {
	meta:
		name = "set_gfx_mode"
		size = 44
		refs = "0000 _gfx_mode_set_count 001c .text"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 43 8C 41 53 09 3C 45 46 29 35 01 00 63 24 03 00 89 10 ?? ?? 43 AC ?? ?? ?? 0? FF FF 09 24 ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_44_38_0 {
	meta:
		name = "get_gfx_mode_list"
		size = 192
		refs = "0000 system_driver 0038 .text 0078 _gfx_driver_list 00a4 qsort"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 43 8C F8 FF BD 27 00 00 B0 AF 80 00 62 8C 04 00 BF AF 17 00 40 10 21 80 80 00 09 F8 40 00 00 00 00 00 21 18 40 00 04 00 64 8C 07 00 80 54 00 00 62 8C ?? ?? ?? 0? 21 80 00 00 04 00 64 8C 07 00 80 50 21 80 00 00 00 00 62 8C FB FF 50 54 0C 00 63 24 68 00 82 8C 09 00 40 14 21 80 00 00 04 00 BF 8F 21 10 00 02 00 00 B0 8F 08 00 E0 03 08 00 BD 27 ?? ?? 02 3C ?? ?? ?? 0? ?? ?? 43 24 09 F8 40 00 00 00 00 00 F5 FF 40 10 21 80 40 00 04 00 44 8C 00 00 45 8C ?? ?? 07 3C ?? ?? E7 24 ?? ?? ?? 0? 0C 00 06 24 04 00 BF 8F 21 10 00 02 00 00 B0 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_45_1_0 {
	meta:
		name = "_get_scanline_filler"
		size = 480
		refs = "0028 .rodata 0040 .data 00f0 _optim_alternative_drawer 01a0 .text"
	strings:
		$1 = { 1C 00 02 8D 21 68 80 00 00 00 43 8C F8 FF 63 24 19 00 62 2C 03 00 40 14 21 50 A0 00 08 00 E0 03 21 10 00 00 80 10 03 00 ?? ?? 03 3C ?? ?? 63 24 21 18 62 00 00 00 64 8C 08 00 80 00 00 00 00 00 ?? ?? 02 3C ?? ?? 45 24 ?? ?? 03 3C ?? ?? 02 3C ?? ?? 6C 24 ?? ?? 4B 24 EF FF 03 24 0E 00 02 24 24 18 A3 01 2D 18 62 00 21 20 00 00 2C 48 64 00 80 10 09 00 21 10 A2 00 00 00 43 8C 31 00 E0 10 00 00 43 AD 00 00 E2 8C 40 00 E4 8C FF FF 42 24 4C 00 C2 AC 04 00 E3 8C 54 00 C0 AC 48 00 C4 AC FF FF 63 24 50 00 C3 AC 00 00 E2 8C 02 00 42 28 08 00 40 14 01 00 04 24 01 00 05 24 54 00 C4 AC 00 00 E3 8C 04 10 85 00 2A 10 43 00 FB FF 40 14 01 00 84 24 3C 00 02 8D 10 00 A3 31 21 00 60 14 58 00 C2 AC C0 10 09 00 21 10 82 01 04 00 44 8C ?? ?? 03 3C 00 00 42 8C 08 00 E0 03 ?? ?? 64 AC ?? ?? 02 3C ?? ?? 03 3C ?? ?? 45 24 ?? ?? 6C 24 ?? ?? 02 3C EF FF 03 24 ?? ?? 4B 24 24 18 A3 01 0E 00 02 24 2D 18 62 00 21 20 00 00 2C 48 64 00 80 10 09 00 21 10 A2 00 00 00 43 8C D1 FF E0 14 00 00 43 AD 54 00 C0 AC 50 00 C0 AC 4C 00 C0 AC 3C 00 02 8D 10 00 A3 31 48 00 C0 AC E1 FF 60 10 58 00 C2 AC C0 20 09 00 21 20 64 01 00 00 42 8D 04 00 85 8C ?? ?? 03 3C 10 01 42 34 00 00 42 AD ?? ?? 65 AC 08 00 E0 03 00 00 82 8C ?? ?? 02 3C ?? ?? 45 24 ?? ?? 03 3C ?? ?? 02 3C ?? ?? 6C 24 ?? ?? ?? 0? ?? ?? 4B 24 ?? ?? 02 3C ?? ?? 45 24 ?? ?? 03 3C ?? ?? 02 3C ?? ?? 6C 24 ?? ?? ?? 0? ?? ?? 4B 24 ?? ?? 02 3C ?? ?? 45 24 ?? ?? 03 3C ?? ?? 02 3C ?? ?? 6C 24 ?? ?? ?? 0? ?? ?? 4B 24 }
	condition:
		$1
}

rule file_45_2_0 {
	meta:
		name = "_clip_polygon_segment_f"
		size = 300
	strings:
		$1 = { F8 FF BD 27 02 00 C2 30 21 48 C0 00 21 40 80 00 07 00 40 10 00 00 A5 AF 14 00 82 8C 10 00 83 8C 18 00 A2 00 12 10 00 00 21 18 62 00 10 00 83 AC 04 00 22 31 16 00 40 10 08 00 22 31 24 00 04 8D 00 00 A2 8F 28 00 06 8D 00 00 AA 8F 18 00 44 00 2C 00 07 8D 18 00 02 8D 1C 00 03 8D 20 00 05 8D 12 20 00 00 21 10 44 00 18 00 02 AD 18 00 46 01 12 30 00 00 21 18 66 00 1C 00 03 AD 18 00 47 01 12 38 00 00 21 28 A7 00 20 00 05 AD 08 00 22 31 10 00 40 10 10 00 22 31 08 00 04 8D 00 00 A3 8F 0C 00 05 8D 00 00 A6 8F 18 00 64 00 00 00 02 8D 04 00 03 8D 12 20 00 00 21 10 44 00 00 00 02 AD 18 00 C5 00 12 28 00 00 21 18 65 00 04 00 03 AD 10 00 22 31 13 00 40 10 00 00 A1 C7 34 00 00 C5 20 00 22 31 20 09 80 46 02 20 00 46 30 00 01 C5 40 08 00 46 0B 00 40 10 30 00 01 E5 40 00 01 C5 44 00 02 C5 38 00 03 C5 42 20 01 46 82 20 02 46 3C 00 00 C5 C0 18 01 46 00 00 02 46 38 00 03 E5 3C 00 00 E5 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_45_3_0 {
	meta:
		name = "do_polygon3d"
		size = 5324
		refs = "008c $LC6 00a4 $LC4 00ac $LC3 0174 .text 0bdc allegro_errno 01c4 _poly_scanline_dummy 020c __floatsidf 0218 $LC0 0224 __muldf3 0260 __divdf3 0270 $LC1 0280 __gtdf2 0950 __truncdfsf2 0964 $LC5 0ad8 _optim_alternative_drawer 0d3c _zbuffer 0f00 _clip_polygon_segment_f 0470 $LC2 0f88 __ltdf2 119c __adddf3 11a8 __fixdfsi"
	strings:
		$1 = { 1C 00 82 8C 38 FF BD 27 A8 00 B4 AF 10 00 42 8C 9C 00 B1 AF 98 00 B0 AF BC 00 BF AF B8 00 BE AF B4 00 B7 AF B0 00 B6 AF AC 00 B5 AF A4 00 B3 AF A0 00 B2 AF C4 00 B5 E7 C0 00 B4 E7 40 00 A4 AF 21 88 A0 00 44 00 A6 AF 21 80 E0 00 48 00 A8 AF 4C 00 A9 AF 50 00 AA AF 03 00 40 10 21 A0 60 01 09 F8 40 00 00 00 00 00 78 00 02 8E 7C 00 03 8E 04 00 A2 AF 04 00 43 10 00 00 A3 AF 00 00 42 8C 02 05 51 10 04 00 A4 8F 04 00 B0 AF ?? ?? 02 3C 00 00 A6 8F ?? ?? 55 C4 04 00 A2 8F ?? ?? 04 3C 04 00 C5 8C ?? ?? 84 8C 04 00 46 8C ?? ?? 02 3C ?? ?? 42 8C ?? ?? 03 3C ?? ?? 63 8C 80 00 A4 AF 4C 00 A4 8F 84 00 A2 AF 00 00 A2 8F 01 00 84 30 7C 00 A3 AF ?? ?? 03 3C ?? ?? 63 8C 10 00 A4 AF 08 00 44 8C 04 00 A2 8F 88 00 A3 AF 2D 28 C5 00 08 00 43 8C 3C 00 B1 AF 2A 10 83 00 00 03 40 14 38 00 A5 AF 01 03 83 10 00 00 A3 8F 00 00 B3 8F 04 00 B2 8F 10 00 A5 8F 04 00 A0 10 3C 00 A3 8F 50 00 A6 8F 10 00 86 AE 3C 00 A3 8F 38 00 A4 8F 2A 10 83 00 D0 02 40 14 ?? ?? 05 3C ?? ?? 06 3C ?? ?? 02 3C ?? ?? 03 3C ?? ?? A5 8C ?? ?? C6 8C ?? ?? 42 8C ?? ?? 63 8C 5C 00 A5 AF 60 00 A6 AF 64 00 A2 AF 68 00 A3 AF 6C 00 A5 AF 70 00 A6 AF 74 00 A2 AF ?? ?? ?? 0? 78 00 A3 AF ?? ?? 83 8C FF 7F 05 24 22 00 02 24 14 00 A5 AF 00 00 62 AC 08 00 63 8E FF 7F 02 3C 01 00 42 34 2A 10 62 00 90 02 40 14 FF FF 02 34 ?? ?? 06 3C ?? ?? C3 8C 22 00 02 24 FF 7F 05 24 00 00 62 AC 14 00 A2 8F 48 00 A3 8F ?? ?? 04 3C 23 28 A2 00 ?? ?? 84 24 8E 02 64 10 18 00 A5 AF 08 00 44 8E 08 00 62 8E 14 00 A6 8F 23 F0 44 00 4C 00 A2 8F 00 2C 06 00 23 A8 A4 00 02 00 43 30 FF FF 02 3C 56 00 60 10 0A F0 5E 00 24 00 64 8E 24 00 56 8E ?? ?? ?? 0? 23 20 96 00 21 28 60 00 ?? ?? 03 3C ?? ?? 66 8C ?? ?? 67 8C ?? ?? ?? 0? 21 20 40 00 21 20 C0 03 21 80 40 00 ?? ?? ?? 0? 21 88 60 00 21 20 40 00 ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C ?? ?? ?? 0? 21 28 60 00 21 30 40 00 21 20 00 02 21 28 20 02 ?? ?? ?? 0? 21 38 60 00 21 88 60 00 21 28 60 00 ?? ?? 03 3C ?? ?? 66 8C ?? ?? 67 8C 21 20 40 00 ?? ?? ?? 0? 21 80 40 00 79 03 40 18 ?? ?? 03 3C ?? ?? 04 3C ?? ?? 82 8C 22 00 03 24 FF 7F 04 3C 00 00 43 AC 24 00 56 8E FF 7F 02 3C FF FF 42 34 21 18 00 00 FF FF 84 34 08 00 A2 AF 0C 00 A3 AF 0C 00 A2 8F 08 00 A3 8F 14 00 84 AE 18 00 55 00 C3 17 15 00 1C 00 43 00 08 00 A2 8F 12 18 00 00 90 00 A3 AF 19 00 55 00 00 80 02 34 10 38 00 00 21 38 67 00 2A 10 E2 00 D2 02 40 10 12 30 00 00 FF 7F 02 24 CB 02 E2 10 FF FF 02 3C 00 80 E2 28 52 03 40 14 ?? ?? 04 3C 00 80 02 24 4B 03 E2 10 01 00 02 3C 02 1C 06 00 00 14 07 00 25 20 43 00 21 10 96 00 10 00 82 AE 24 00 43 8E 28 00 42 8E 28 00 64 8E 21 18 62 00 24 00 43 AE 24 00 62 8E 21 10 44 00 24 00 62 AE 4C 00 A5 8F 04 00 A2 30 D8 00 40 10 08 00 A2 30 ?? ?? ?? 0? 21 20 C0 03 21 20 40 00 ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C ?? ?? ?? 0? 21 28 60 00 21 B0 40 00 2C 00 44 8E 2C 00 62 8E 21 B8 60 00 ?? ?? ?? 0? 23 20 44 00 21 28 60 00 ?? ?? 03 3C ?? ?? 66 8C ?? ?? 67 8C ?? ?? ?? 0? 21 20 40 00 21 20 40 00 21 28 60 00 21 30 C0 02 ?? ?? ?? 0? 21 38 E0 02 21 80 40 00 21 20 40 00 ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 28 60 00 ?? ?? ?? 0? 21 88 60 00 42 03 40 58 ?? ?? 04 3C ?? ?? 03 3C ?? ?? 62 8C FF 7F 04 3C 22 00 03 24 00 00 43 AC FF FF 83 34 30 00 62 8E 30 00 44 8E 24 00 83 AE ?? ?? ?? 0? 23 20 44 00 21 28 60 00 ?? ?? 03 3C ?? ?? 66 8C ?? ?? 67 8C ?? ?? ?? 0? 21 20 40 00 21 20 40 00 21 28 60 00 21 30 C0 02 ?? ?? ?? 0? 21 38 E0 02 21 80 40 00 21 20 40 00 ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 28 60 00 ?? ?? ?? 0? 21 88 60 00 D1 02 40 58 ?? ?? 04 3C ?? ?? 03 3C ?? ?? 62 8C FF 7F 04 3C 22 00 03 24 00 00 43 AC FF FF 83 34 34 00 62 8E 34 00 44 8E 28 00 83 AE ?? ?? ?? 0? 23 20 44 00 21 28 60 00 ?? ?? 03 3C ?? ?? 66 8C ?? ?? 67 8C ?? ?? ?? 0? 21 20 40 00 21 20 40 00 21 28 60 00 21 30 C0 02 ?? ?? ?? 0? 21 38 E0 02 21 80 40 00 21 20 40 00 ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 28 60 00 ?? ?? ?? 0? 21 88 60 00 A3 02 40 18 ?? ?? 04 3C ?? ?? 03 3C ?? ?? 62 8C FF 7F 04 3C 22 00 03 24 00 00 43 AC FF FF 84 34 24 00 82 8E C3 2F 15 00 2C 00 84 AE 18 00 A2 00 C3 1F 02 00 2C 00 48 8E 1C 00 75 00 12 20 00 00 19 00 A2 02 00 80 02 34 10 38 00 00 21 38 87 00 2A 10 E2 00 56 02 40 10 12 30 00 00 FF 7F 02 24 4F 02 E2 10 FF FF 02 3C 00 80 E2 28 B7 02 40 14 ?? ?? 04 3C 00 80 02 24 B0 02 E2 10 01 00 02 3C 02 1C 06 00 00 14 07 00 25 20 43 00 28 00 82 8E 21 18 88 00 18 00 83 AE 18 00 A2 00 C3 27 02 00 30 00 48 8E 1C 00 95 00 12 18 00 00 19 00 A2 02 00 80 02 34 10 38 00 00 21 38 67 00 2A 10 E2 00 30 02 40 10 12 30 00 00 FF 7F 02 24 29 02 E2 10 FF FF 02 3C 00 80 E2 28 5F 02 40 14 ?? ?? 04 3C 00 80 02 24 58 02 E2 10 01 00 02 3C 02 1C 06 00 00 14 07 00 25 20 43 00 2C 00 82 8E 21 18 88 00 1C 00 83 AE 18 00 A2 00 C3 27 02 00 34 00 45 8E 1C 00 95 00 12 18 00 00 90 00 A3 AF 19 00 A2 02 00 80 02 34 10 38 00 00 21 38 67 00 2A 10 E2 00 E8 01 40 10 12 30 00 00 FF 7F 02 24 E1 01 E2 10 FF FF 02 3C 00 80 E2 28 4C 02 40 14 ?? ?? 04 3C 00 80 02 24 45 02 E2 10 01 00 02 3C 02 1C 06 00 00 14 07 00 25 20 43 00 21 10 85 00 20 00 82 AE 2C 00 43 8E 30 00 42 8E 34 00 44 8E 38 00 45 8E 3C 00 46 8E 40 00 47 8E 21 18 65 00 21 10 46 00 21 20 87 00 2C 00 43 AE 30 00 42 AE 34 00 44 AE 2C 00 62 8E 30 00 63 8E 34 00 64 8E 38 00 65 8E 3C 00 66 8E 40 00 67 8E 21 10 45 00 21 18 66 00 21 20 87 00 2C 00 62 AE 30 00 63 AE 34 00 64 AE 4C 00 A5 8F 08 00 A2 30 95 00 40 50 4C 00 A5 8F ?? ?? ?? 0? 21 20 C0 03 21 20 40 00 ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C ?? ?? ?? 0? 21 28 60 00 21 B0 40 00 14 00 44 8E 14 00 62 8E 21 B8 60 00 ?? ?? ?? 0? 23 20 44 00 21 28 60 00 ?? ?? 03 3C ?? ?? 66 8C ?? ?? 67 8C ?? ?? ?? 0? 21 20 40 00 21 20 40 00 21 28 60 00 21 30 C0 02 ?? ?? ?? 0? 21 38 E0 02 21 80 40 00 21 20 40 00 ?? ?? 02 3C ?? ?? 42 24 00 00 46 8C 04 00 47 8C 21 28 60 00 ?? ?? ?? 0? 21 88 60 00 5A 02 40 58 ?? ?? 04 3C ?? ?? 03 3C ?? ?? 62 8C FF 7F 04 3C 22 00 03 24 00 00 43 AC FF FF 83 34 18 00 62 8E 18 00 44 8E 08 00 83 AE ?? ?? ?? 0? 23 20 44 00 21 20 40 00 ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C ?? ?? ?? 0? 21 28 60 00 21 20 40 00 21 28 60 00 21 30 C0 02 ?? ?? ?? 0? 21 38 E0 02 21 88 60 00 21 28 60 00 ?? ?? 03 3C ?? ?? 66 8C ?? ?? 67 8C 21 20 40 00 ?? ?? ?? 0? 21 80 40 00 05 02 40 18 ?? ?? 02 3C ?? ?? 04 3C ?? ?? 82 8C 22 00 03 24 FF 7F 04 3C 00 00 43 AC FF FF 84 34 08 00 82 8E C3 2F 15 00 0C 00 84 AE 18 00 A2 00 C3 1F 02 00 14 00 48 8E 1C 00 75 00 12 20 00 00 19 00 A2 02 00 80 02 34 10 38 00 00 21 38 87 00 2A 10 E2 00 7B 01 40 10 12 30 00 00 FF 7F 02 24 74 01 E2 10 FF FF 02 3C 00 80 E2 28 3F 02 40 54 ?? ?? 04 3C 00 80 02 24 38 02 E2 10 01 00 02 3C 02 1C 06 00 00 14 07 00 25 20 43 00 0C 00 82 8E 21 18 88 00 00 00 83 AE 18 00 A2 00 C3 27 02 00 18 00 45 8E 1C 00 95 00 12 18 00 00 90 00 A3 AF 19 00 A2 02 00 80 02 34 10 38 00 00 21 38 67 00 2A 10 E2 00 54 01 40 10 12 30 00 00 FF 7F 02 24 4D 01 E2 10 FF FF 02 3C 00 80 E2 28 9B 01 40 54 ?? ?? 04 3C 00 80 02 24 94 01 E2 10 01 00 02 3C 02 1C 06 00 00 14 07 00 25 20 43 00 21 10 85 00 04 00 82 AE 14 00 43 8E 18 00 44 8E 1C 00 42 8E 20 00 45 8E 1C 00 66 8E 21 18 62 00 21 20 85 00 14 00 43 AE 18 00 44 AE 14 00 62 8E 18 00 63 8E 20 00 64 8E 21 10 46 00 14 00 62 AE 21 18 64 00 18 00 63 AE 4C 00 A5 8F 10 00 A2 30 4E 00 40 10 40 00 A4 8F ?? ?? ?? 0? 21 20 A0 02 21 20 40 00 ?? ?? 02 3C ?? ?? 42 24 00 00 46 8C 04 00 47 8C ?? ?? ?? 0? 21 28 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 C0 03 ?? ?? ?? 0? 06 05 00 46 ?? ?? 06 3C ?? ?? C4 8C ?? ?? C5 8C 21 38 60 00 ?? ?? ?? 0? 21 30 40 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 46 01 00 46 44 00 41 C6 44 00 60 C6 4C 00 A3 8F 01 00 01 46 20 00 62 30 02 28 00 46 82 A0 00 46 34 00 80 E6 48 00 43 C6 48 00 64 C6 40 08 02 46 30 00 81 E6 44 00 40 C6 00 00 03 46 44 00 40 E6 44 00 61 C6 40 08 04 46 21 00 40 10 44 00 61 E6 4C 00 42 C6 50 00 43 C6 4C 00 60 C6 50 00 61 C6 01 00 02 46 41 08 03 46 02 28 00 46 42 28 01 46 02 A1 00 46 42 A1 01 46 40 00 80 E6 44 00 81 E6 54 00 46 C6 58 00 47 C6 54 00 68 C6 80 10 04 46 C0 18 05 46 58 00 64 C6 38 00 82 E6 3C 00 83 E6 4C 00 40 C6 50 00 41 C6 00 00 06 46 40 08 07 46 4C 00 40 E6 50 00 41 E6 4C 00 60 C6 50 00 61 C6 00 00 08 46 40 08 04 46 4C 00 60 E6 50 00 61 E6 40 00 A4 8F 08 00 82 8C BF 00 40 54 40 00 A5 8F 14 00 B0 8F 18 00 A6 8F 3B 00 C0 18 40 00 A3 8F 1C 00 62 8C 00 00 44 8C 09 00 83 28 C6 00 60 10 11 00 82 28 01 00 11 24 4C 00 A4 8F 40 00 82 30 A5 00 40 10 4C 00 A6 8F 34 00 81 C6 00 00 80 44 00 00 00 00 32 08 00 46 00 00 00 00 9F 00 00 45 00 01 C2 30 30 00 80 C6 38 00 82 C6 3C 00 83 C6 03 A8 00 46 40 00 84 C6 44 00 81 C6 4C 00 A6 8F ?? ?? 05 3C ?? ?? B5 8C 00 01 C2 30 42 00 01 46 82 00 02 46 C2 00 03 46 02 00 04 46 4D 08 00 46 8D 10 00 46 CD 18 00 46 0D 00 00 46 0C 00 81 E6 00 00 82 E6 04 00 83 E6 8A 00 40 14 08 00 80 E6 18 00 30 02 40 00 A2 8F 3C 00 A5 8F 24 00 43 8C 21 20 40 00 09 F8 60 00 12 80 00 00 40 00 A3 8F 3C 00 A5 8F 21 10 50 00 20 00 66 8C 21 20 60 00 09 F8 C0 00 60 00 82 AE 18 00 A5 8F 21 20 50 00 09 F8 A0 02 21 30 80 02 08 00 43 8E 0C 00 42 8E 3C 00 A5 8F 0C 00 64 8E 21 18 62 00 08 00 43 AE 08 00 62 8E 38 00 A6 8F 01 00 A5 24 21 10 44 00 2A 18 C5 00 3C 00 A5 AF 39 00 60 14 08 00 62 AE 08 00 43 8E FF 7F 02 3C 01 00 42 34 2A 10 62 00 74 FD 40 50 ?? ?? 04 3C FF FF 02 34 21 10 62 00 C3 00 42 04 27 10 02 00 03 14 02 00 08 00 63 8E 14 00 A2 AF FF 7F 02 3C 01 00 42 34 2A 10 62 00 74 FD 40 50 ?? ?? 06 3C FF FF 02 34 21 10 62 00 B3 00 40 04 48 00 A3 8F 03 2C 02 00 14 00 A2 8F ?? ?? 04 3C 23 28 A2 00 ?? ?? 84 24 74 FD 64 14 18 00 A5 AF D4 FF A0 18 40 00 A5 8F 14 00 A6 8F 18 00 A3 8F 1C 00 A2 8C FF FF C7 24 21 28 C0 00 21 38 E3 00 40 00 A4 8F 30 00 43 8C 3C 00 A6 8F 09 F8 60 00 50 00 A8 8F 08 00 43 8E 0C 00 42 8E 3C 00 A5 8F 0C 00 64 8E 21 18 62 00 08 00 43 AE 08 00 62 8E 38 00 A6 8F 01 00 A5 24 21 10 44 00 2A 18 C5 00 3C 00 A5 AF C9 FF 60 10 08 00 62 AE 44 00 A3 8F 38 00 A4 8F 2A 10 83 00 E9 01 40 10 04 00 A5 8F 04 00 A6 8C 2A 10 86 00 05 00 40 14 00 00 A2 8F 78 00 A6 8C 04 00 A6 AF 04 00 C6 8C 00 00 A2 8F 38 00 A3 8F 04 00 45 8C 2A 10 65 00 06 00 40 14 38 00 A2 8F 00 00 A4 8F 7C 00 84 8C 04 00 85 8C 00 00 A4 AF 38 00 A2 8F 2D 28 C5 00 38 00 A5 AF 01 00 42 24 3C 00 A2 AF 00 00 A2 8F 08 00 44 8C 04 00 A2 8F 08 00 43 8C 2A 10 83 00 02 FD 40 10 00 00 00 00 04 00 B3 8F ?? ?? ?? 0? 00 00 B2 8F 04 00 A4 8F 0C 00 62 8C 0C 00 83 8C 2A 10 43 00 FC FC 40 50 00 00 B3 8F 04 00 B3 8F ?? ?? ?? 0? 00 00 B2 8F 00 01 C2 30 78 FF 40 10 48 00 B5 8F ?? ?? 02 3C ?? ?? 44 8C 20 00 86 8C 09 F8 C0 00 3C 00 A5 8F 80 18 10 00 21 10 43 00 ?? ?? ?? 0? 5C 00 82 AE 14 00 A6 8F 0C 00 B0 8C 2A 10 D0 00 5E 00 40 14 14 00 A3 8F 21 80 C0 00 40 00 A4 8F 18 00 A5 8F 10 00 83 8C 21 10 B0 00 2A 10 62 00 38 FF 40 10 18 00 A6 8F 23 18 70 00 ?? ?? ?? 0? 18 00 A3 AF 4D 00 40 50 19 00 83 28 ?? ?? ?? 0? 02 00 11 24 01 00 42 34 2B 10 C2 00 1E FE 40 14 00 80 E2 28 ?? ?? 03 3C ?? ?? 62 8C FF 7F 04 3C 22 00 03 24 00 00 43 AC ?? ?? ?? 0? FF FF 84 34 01 00 42 34 2B 10 C2 00 B2 FE 40 14 00 80 E2 28 ?? ?? 03 3C ?? ?? 62 8C FF 7F 04 3C 22 00 03 24 00 00 43 AC ?? ?? ?? 0? FF FF 84 34 01 00 42 34 2B 10 C2 00 8B FE 40 14 00 80 E2 28 ?? ?? 03 3C ?? ?? 62 8C FF 7F 04 3C 22 00 03 24 00 00 43 AC ?? ?? ?? 0? FF FF 84 34 01 00 42 34 2B 10 C2 00 34 FD 40 14 00 80 E2 28 ?? ?? 03 3C ?? ?? 62 8C FF 7F 04 3C 22 00 03 24 00 00 43 AC ?? ?? ?? 0? FF FF 84 34 01 00 42 34 2B 10 C2 00 D6 FD 40 14 00 80 E2 28 ?? ?? 03 3C ?? ?? 62 8C FF 7F 04 3C 22 00 03 24 00 00 43 AC ?? ?? ?? 0? FF FF 84 34 01 00 42 34 2B 10 C2 00 B0 FD 40 14 00 80 E2 28 ?? ?? 03 3C ?? ?? 62 8C FF 7F 04 3C 22 00 03 24 00 00 43 AC ?? ?? ?? 0? FF FF 84 34 27 10 02 00 03 14 02 00 ?? ?? ?? 0? 27 28 02 00 03 14 02 00 27 10 02 00 ?? ?? ?? 0? 14 00 A2 AF 04 00 11 24 03 00 02 24 ?? ?? ?? 0? 0B 88 43 00 4C 00 A6 8F 21 20 80 02 23 10 03 02 18 00 A3 8F 21 28 40 00 23 18 62 00 ?? ?? ?? 0? 18 00 A3 AF ?? ?? ?? 0? 40 00 A4 8F 2B 10 C2 00 6C FE 40 10 02 1C 06 00 ?? ?? 04 3C ?? ?? 83 8C 22 00 02 24 00 80 04 3C ?? ?? ?? 0? 00 00 62 AC 2B 10 C2 00 A8 FD 40 10 02 1C 06 00 ?? ?? 04 3C ?? ?? 83 8C 22 00 02 24 00 80 04 3C ?? ?? ?? 0? 00 00 62 AC 2B 10 C2 00 BB FD 40 10 02 1C 06 00 ?? ?? 04 3C ?? ?? 83 8C 22 00 02 24 00 80 04 3C ?? ?? ?? 0? 00 00 62 AC ?? ?? 86 8C ?? ?? 87 8C 21 28 20 02 ?? ?? ?? 0? 21 20 00 02 DD 00 43 04 21 20 00 02 ?? ?? 05 3C ?? ?? A2 8C 22 00 03 24 00 80 04 3C 00 00 43 AC ?? ?? ?? 0? 01 00 84 34 ?? ?? 86 8C ?? ?? 87 8C 21 28 20 02 ?? ?? ?? 0? 21 20 00 02 7B 00 43 04 21 20 00 02 ?? ?? 05 3C ?? ?? A2 8C 22 00 03 24 00 80 04 3C 00 00 43 AC ?? ?? ?? 0? 01 00 83 34 ?? ?? 42 24 00 00 46 8C 04 00 47 8C 21 20 00 02 ?? ?? ?? 0? }
	condition:
		$1
}

rule file_45_4_0 {
	meta:
		name = "draw_triangle_part"
		size = 2444
		refs = "00d8 allegro_errno 00a0 $LC6 0150 _poly_scanline_dummy 0484 __floatsidf 0490 $LC0 04a0 __muldf3 04ac __truncdfsf2 0580 _optim_alternative_drawer 06bc .text 0808 _zbuffer 0864 _clip_polygon_segment_f"
	strings:
		$1 = { 98 FF BD 27 40 00 42 31 54 00 B7 AF 4C 00 B5 AF 44 00 B3 AF 3C 00 B1 AF 5C 00 BF AF 58 00 BE AF 50 00 B6 AF 48 00 B4 AF 40 00 B2 AF 38 00 B0 AF 64 00 B4 E7 0C 00 AA AF 21 A8 80 00 04 00 A6 AF 21 88 E0 00 21 B8 00 01 08 00 A9 AF 10 00 AB AF 40 02 40 14 68 00 B3 8F 00 00 A0 AF 08 00 E4 8E 08 00 23 8E 2A 10 83 00 37 02 40 14 21 10 E0 02 30 02 83 50 0C 00 E2 8E 0C 00 A3 8F 01 00 62 30 04 00 40 10 04 00 A6 8F 10 00 A4 8F 10 00 64 AE 04 00 A6 8F 2A 10 C5 00 68 01 40 14 21 A0 A0 00 ?? ?? 02 3C ?? ?? 54 C4 0C 00 A7 8F 0C 00 A2 8F 0C 00 A3 8F 0C 00 A4 8F 0C 00 A5 8F 0C 00 A6 8F 02 00 E7 30 04 00 42 30 08 00 63 30 10 00 84 30 00 01 A5 30 20 00 C6 30 ?? ?? 1E 3C 14 00 A7 AF 18 00 A2 AF 1C 00 A3 AF 20 00 A4 AF 24 00 A5 AF 28 00 A6 AF 08 00 23 8E FF 7F 07 3C 01 00 E7 34 2A 10 67 00 6F 01 40 14 FF FF 04 34 ?? ?? C2 8F 22 00 03 24 FF 7F 12 24 FF 7F 04 3C 00 00 43 AC 08 00 E3 8E FF 7F 05 3C 01 00 A5 34 2A 10 65 00 4F 01 40 14 FF FF 07 34 ?? ?? C2 8F 22 00 06 24 FF 7F 05 24 00 00 46 AC 08 00 A3 8F 23 B0 B2 00 ?? ?? 05 3C ?? ?? A5 24 4E 01 65 10 08 00 22 8E 14 00 A6 8F 1B 00 C0 10 23 40 82 00 14 00 63 8E 00 80 02 34 24 00 26 8E 18 00 03 01 10 28 00 00 2A 10 A2 00 9A 01 40 10 12 20 00 00 FF 7F 02 24 93 01 A2 10 FF FF 03 3C 00 80 A2 28 C1 01 40 14 ?? ?? C2 8F 00 80 02 24 BA 01 A2 10 01 00 02 3C 02 1C 04 00 00 14 05 00 25 18 43 00 21 10 66 00 10 00 62 AE 24 00 23 8E 28 00 22 8E 21 18 62 00 24 00 23 AE 18 00 A6 8F 63 00 C0 10 1C 00 A6 8F 24 00 62 8E C3 37 08 00 2C 00 27 8E 18 00 C2 00 C3 1F 02 00 1C 00 68 00 12 20 00 00 30 00 A4 AF 19 00 02 01 30 00 A2 8F 10 28 00 00 21 28 45 00 00 80 02 34 2A 10 A2 00 6B 01 40 10 12 20 00 00 FF 7F 03 24 64 01 A3 10 FF FF 03 3C 00 80 A2 28 BC 01 40 14 ?? ?? C2 8F 00 80 02 24 B5 01 A2 10 01 00 02 3C 02 1C 04 00 00 14 05 00 25 18 43 00 28 00 62 8E 21 18 67 00 18 00 63 AE 18 00 C2 00 C3 27 02 00 30 00 27 8E 1C 00 88 00 12 18 00 00 19 00 02 01 00 80 02 34 10 28 00 00 21 28 65 00 2A 10 A2 00 46 01 40 10 12 20 00 00 FF 7F 02 24 3F 01 A2 10 FF FF 03 3C 00 80 A2 28 99 01 40 14 ?? ?? C2 8F 00 80 02 24 92 01 A2 10 01 00 02 3C 02 1C 04 00 00 14 05 00 25 18 43 00 2C 00 62 8E 21 18 67 00 1C 00 63 AE 18 00 C2 00 C3 27 02 00 34 00 26 8E 1C 00 88 00 12 18 00 00 30 00 A3 AF 19 00 02 01 00 80 02 34 10 28 00 00 21 28 65 00 2A 10 A2 00 20 01 40 10 12 20 00 00 FF 7F 02 24 19 01 A2 10 FF FF 03 3C 00 80 A2 28 6D 01 40 14 ?? ?? C2 8F 00 80 02 24 66 01 A2 10 01 00 02 3C 02 1C 04 00 00 14 05 00 25 18 43 00 21 10 66 00 20 00 62 AE 2C 00 23 8E 30 00 22 8E 34 00 24 8E 38 00 25 8E 3C 00 26 8E 40 00 27 8E 21 18 65 00 21 10 46 00 21 20 87 00 2C 00 23 AE 30 00 22 AE 34 00 24 AE 1C 00 A6 8F 44 00 C0 10 20 00 A6 8F 08 00 62 8E C3 37 08 00 14 00 27 8E 18 00 C2 00 C3 1F 02 00 1C 00 68 00 12 20 00 00 30 00 A4 AF 19 00 02 01 30 00 A2 8F 10 28 00 00 21 28 45 00 00 80 02 34 2A 10 A2 00 E9 00 40 10 12 20 00 00 FF 7F 03 24 E2 00 A3 10 FF FF 03 3C 00 80 A2 28 30 01 40 14 ?? ?? C2 8F 00 80 02 24 29 01 A2 10 01 00 02 3C 02 1C 04 00 00 14 05 00 25 18 43 00 0C 00 62 8E 21 18 67 00 00 00 63 AE 18 00 C2 00 C3 27 02 00 18 00 26 8E 1C 00 88 00 12 18 00 00 30 00 A3 AF 19 00 02 01 00 80 02 34 10 28 00 00 21 28 65 00 2A 10 A2 00 C3 00 40 10 12 20 00 00 FF 7F 02 24 BC 00 A2 10 FF FF 03 3C 00 80 A2 28 2C 01 40 14 ?? ?? C2 8F 00 80 02 24 25 01 A2 10 01 00 02 3C 02 1C 04 00 00 14 05 00 25 18 43 00 21 10 66 00 04 00 62 AE 14 00 23 8E 18 00 22 8E 1C 00 24 8E 20 00 25 8E 21 18 64 00 21 10 45 00 14 00 23 AE 18 00 22 AE 20 00 A6 8F 2C 00 C0 50 08 00 A2 8E ?? ?? ?? 0? 21 20 00 01 21 20 40 00 ?? ?? 02 3C ?? ?? 42 24 00 00 46 8C 04 00 47 8C ?? ?? ?? 0? 21 28 60 00 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 06 01 00 46 34 00 60 C6 44 00 21 C6 48 00 22 C6 02 20 00 46 28 00 A3 8F 40 08 00 46 30 00 61 E6 44 00 20 C6 00 00 02 46 13 00 60 10 44 00 20 E6 40 00 60 C6 44 00 62 C6 4C 00 23 C6 02 20 00 46 82 20 02 46 50 00 21 C6 54 00 24 C6 58 00 25 C6 C0 18 00 46 40 08 02 46 38 00 63 E6 3C 00 61 E6 4C 00 20 C6 50 00 21 C6 00 00 04 46 40 08 05 46 4C 00 20 E6 50 00 21 E6 08 00 A2 8E 6A 00 40 54 0C 00 B0 8E 21 80 40 02 34 00 C0 5A 08 00 22 8E 1C 00 A2 8E 00 00 44 8C 09 00 83 28 6D 00 60 50 11 00 82 28 01 00 12 24 00 00 A5 8F 17 00 A0 10 24 00 A7 8F 30 00 60 C6 38 00 62 C6 3C 00 63 C6 03 A0 00 46 40 00 64 C6 44 00 61 C6 ?? ?? 06 3C ?? ?? C6 8C 08 00 A6 AF 42 00 01 46 82 00 02 46 C2 00 03 46 02 00 04 46 4D 08 00 46 8D 10 00 46 CD 18 00 46 0D 00 00 46 0C 00 61 E6 00 00 62 E6 04 00 63 E6 08 00 60 E6 24 00 A7 8F 91 00 E0 14 ?? ?? 02 3C 18 00 50 02 24 00 A3 8E 21 20 A0 02 21 28 80 02 09 F8 60 00 12 80 00 00 20 00 A6 8E 21 10 50 00 21 20 A0 02 21 28 80 02 09 F8 C0 00 60 00 62 AE 21 20 50 00 08 00 A2 8F 21 28 C0 02 09 F8 40 00 21 30 60 02 08 00 22 8E 0C 00 23 8E 0C 00 E4 8E 04 00 A5 8F 21 18 43 00 08 00 23 AE 08 00 E2 8E 01 00 94 26 2A 18 B4 00 21 10 44 00 AF FE 60 10 08 00 E2 AE 5C 00 BF 8F 58 00 BE 8F 54 00 B7 8F 50 00 B6 8F 4C 00 B5 8F 48 00 B4 8F 44 00 B3 8F 40 00 B2 8F 3C 00 B1 8F 38 00 B0 8F 64 00 B4 C7 08 00 E0 03 68 00 BD 27 21 10 67 00 70 00 40 04 08 00 A3 8F 03 2C 02 00 23 B0 B2 00 ?? ?? 05 3C ?? ?? A5 24 B4 FE 65 14 08 00 22 8E DE FF C0 1A 21 28 40 02 1C 00 A2 8E 10 00 A8 8F FF FF 47 26 30 00 43 8C 21 38 F6 00 21 20 A0 02 09 F8 60 00 21 30 80 02 ?? ?? ?? 0? 08 00 22 8E 21 10 64 00 57 00 42 04 27 10 02 00 03 94 02 00 ?? ?? ?? 0? 00 24 12 00 2A 10 50 02 5D 00 40 14 0C 00 A6 8F 21 80 40 02 10 00 A3 8E 21 10 D0 02 2A 10 62 00 90 FF 40 54 23 B0 70 00 ?? ?? ?? 0? 00 00 00 00 4F 00 40 50 19 00 82 28 ?? ?? ?? 0? 02 00 12 24 01 00 63 34 2B 10 83 00 43 FF 40 14 00 80 A2 28 ?? ?? C2 8F FF 7F 03 3C 22 00 04 24 FF FF 63 34 ?? ?? ?? 0? 00 00 44 AC 01 00 63 34 2B 10 83 00 1D FF 40 14 00 80 A2 28 ?? ?? C2 8F FF 7F 03 3C 22 00 04 24 FF FF 63 34 ?? ?? ?? 0? 00 00 44 AC 01 00 63 34 2B 10 83 00 E6 FE 40 14 00 80 A2 28 ?? ?? C2 8F FF 7F 03 3C 22 00 04 24 FF FF 63 34 ?? ?? ?? 0? 00 00 44 AC 01 00 63 34 2B 10 83 00 C0 FE 40 14 00 80 A2 28 ?? ?? C2 8F FF 7F 03 3C 22 00 04 24 FF FF 63 34 ?? ?? ?? 0? 00 00 44 AC 01 00 63 34 2B 10 83 00 9B FE 40 14 00 80 A2 28 ?? ?? C2 8F FF 7F 03 3C 22 00 04 24 FF FF 63 34 ?? ?? ?? 0? 00 00 44 AC 01 00 63 34 2B 10 83 00 6C FE 40 14 00 80 A2 28 ?? ?? C2 8F FF 7F 03 3C 22 00 04 24 FF FF 63 34 ?? ?? ?? 0? 00 00 44 AC ?? ?? 44 8C 20 00 86 8C 09 F8 C0 00 21 28 80 02 80 18 10 00 21 10 43 00 ?? ?? ?? 0? 5C 00 62 AE 03 14 02 00 27 90 02 00 ?? ?? ?? 0? 00 24 12 00 27 10 02 00 03 14 02 00 ?? ?? ?? 0? 27 28 02 00 04 00 12 24 03 00 04 24 ?? ?? ?? 0? 0B 90 82 00 23 10 12 02 21 28 40 00 21 20 60 02 ?? ?? ?? 0? 23 B0 C2 02 ?? ?? ?? 0? 10 00 A3 8E 2B 10 82 00 D7 FE 40 50 02 1C 04 00 ?? ?? C2 8F 22 00 05 24 00 80 03 3C ?? ?? ?? 0? 00 00 45 AC 2B 10 82 00 46 FE 40 50 02 1C 04 00 ?? ?? C2 8F 22 00 05 24 00 80 03 3C ?? ?? ?? 0? 00 00 45 AC 2B 10 82 00 9A FE 40 50 02 1C 04 00 ?? ?? C2 8F 22 00 05 24 00 80 03 3C ?? ?? ?? 0? 00 00 45 AC 2B 10 82 00 DB FE 40 50 02 1C 04 00 ?? ?? C2 8F 22 00 05 24 00 80 03 3C ?? ?? ?? 0? 00 00 45 AC 2B 10 82 00 6E FE 40 50 02 1C 04 00 ?? ?? C2 8F 22 00 05 24 00 80 03 3C ?? ?? ?? 0? 00 00 45 AC 2B 10 82 00 4B FE 40 50 02 1C 04 00 ?? ?? C2 8F 22 00 05 24 00 80 03 3C ?? ?? ?? 0? 00 00 45 AC 0C 00 23 8E 2A 10 43 00 CF FD 40 10 0C 00 A3 8F 21 10 E0 02 21 B8 20 02 ?? ?? ?? 0? 21 88 40 00 34 00 61 C6 00 00 80 44 00 00 00 00 32 08 00 46 00 00 00 00 04 00 00 45 01 00 02 24 01 00 42 30 ?? ?? ?? 0? 00 00 A2 AF 00 00 02 24 01 00 42 30 ?? ?? ?? 0? 00 00 A2 AF }
	condition:
		$1
}

rule file_45_5_0 {
	meta:
		name = "_clip_polygon_segment"
		size = 1400
		refs = "055c allegro_errno 0124 .text 02ac __floatsidf 02b4 $LC0 02c4 __muldf3 02d0 __truncdfsf2"
	strings:
		$1 = { E8 FF BD 27 02 00 C2 30 10 00 B1 AF 0C 00 B0 AF 14 00 BF AF 21 88 C0 00 11 00 40 10 21 80 80 00 14 00 83 8C 00 80 02 34 10 00 88 8C 18 00 A3 00 10 38 00 00 2A 10 E2 00 D8 00 40 14 12 30 00 00 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 44 34 21 10 88 00 10 00 02 AE 04 00 22 32 5A 00 40 10 08 00 22 32 24 00 02 8E C3 47 05 00 18 00 09 8E 18 00 02 01 C3 1F 02 00 1C 00 65 00 12 20 00 00 19 00 A2 00 00 80 02 34 10 38 00 00 21 38 87 00 2A 10 E2 00 B2 00 40 14 12 30 00 00 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 44 34 28 00 02 8E 21 18 89 00 18 00 03 AE 18 00 02 01 C3 27 02 00 1C 00 09 8E 1C 00 85 00 12 18 00 00 19 00 A2 00 00 80 02 34 10 38 00 00 21 38 67 00 2A 10 E2 00 12 00 40 10 12 30 00 00 FF 7F 02 24 0B 00 E2 10 FF FF 02 3C 00 80 E2 28 DC 00 40 14 ?? ?? 02 3C 00 80 02 24 D5 00 E2 10 01 00 02 3C 02 1C 06 00 00 14 07 00 ?? ?? ?? 0? 25 20 43 00 01 00 42 34 2B 10 C2 00 F4 FF 40 14 00 80 E2 28 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 44 34 2C 00 02 8E 21 18 89 00 1C 00 03 AE 18 00 02 01 C3 27 02 00 20 00 08 8E 1C 00 85 00 12 18 00 00 00 00 A3 AF 19 00 A2 00 00 80 02 34 10 38 00 00 21 38 67 00 2A 10 E2 00 A3 00 40 10 12 30 00 00 FF 7F 02 24 9C 00 E2 10 FF FF 02 3C 00 80 E2 28 AA 00 40 14 ?? ?? 02 3C 00 80 02 24 A3 00 E2 10 01 00 02 3C 00 14 07 00 02 1C 06 00 25 20 43 00 21 10 88 00 20 00 02 AE 08 00 22 32 34 00 40 10 10 00 22 32 08 00 02 8E C3 47 05 00 00 00 09 8E 18 00 02 01 C3 1F 02 00 1C 00 65 00 12 20 00 00 19 00 A2 00 00 80 02 34 10 38 00 00 21 38 87 00 2A 10 E2 00 4A 00 40 14 12 30 00 00 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 44 34 0C 00 02 8E 21 18 89 00 00 00 03 AE 18 00 02 01 C3 27 02 00 04 00 08 8E 1C 00 85 00 12 18 00 00 00 00 A3 AF 19 00 A2 00 00 80 02 34 10 38 00 00 21 38 67 00 2A 10 E2 00 61 00 40 10 12 30 00 00 FF 7F 02 24 5A 00 E2 10 FF FF 02 3C 00 80 E2 28 89 00 40 14 ?? ?? 02 3C 00 80 02 24 82 00 E2 10 01 00 02 3C 00 14 07 00 02 1C 06 00 25 20 43 00 21 10 88 00 04 00 02 AE 10 00 22 32 1F 00 40 10 14 00 BF 8F ?? ?? ?? 0? 21 20 A0 00 ?? ?? 04 3C ?? ?? 86 8C ?? ?? 87 8C 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 06 01 00 46 34 00 00 C6 30 00 01 C6 20 00 22 32 02 20 00 46 40 08 00 46 0B 00 40 10 30 00 01 E6 40 00 01 C6 44 00 02 C6 38 00 03 C6 42 20 01 46 82 20 02 46 3C 00 00 C6 C0 18 01 46 00 00 02 46 38 00 03 E6 3C 00 00 E6 14 00 BF 8F 10 00 B1 8F 0C 00 B0 8F 08 00 E0 03 18 00 BD 27 FF 7F 02 24 89 00 E2 10 FF FF 02 3C 00 80 E2 28 6A 00 40 14 ?? ?? 02 3C 00 80 02 24 63 00 E2 10 01 00 02 3C 02 1C 06 00 00 14 07 00 ?? ?? ?? 0? 25 20 43 00 FF 7F 02 24 76 00 E2 10 FF FF 02 3C 00 80 E2 28 54 00 40 14 ?? ?? 02 3C 00 80 02 24 4D 00 E2 10 01 00 02 3C 02 1C 06 00 00 14 07 00 ?? ?? ?? 0? 25 20 43 00 FF 7F 02 24 63 00 E2 10 FF FF 02 3C 00 80 E2 28 59 00 40 14 ?? ?? 02 3C 00 80 02 24 52 00 E2 10 01 00 02 3C 00 14 07 00 02 1C 06 00 25 20 43 00 21 10 88 00 ?? ?? ?? 0? 10 00 02 AE 01 00 42 34 2B 10 C2 00 A5 FF 40 14 00 80 E2 28 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 44 34 21 10 88 00 ?? ?? ?? 0? 04 00 02 AE 01 00 42 34 2B 10 C2 00 63 FF 40 14 00 80 E2 28 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 44 34 21 10 88 00 ?? ?? ?? 0? 20 00 02 AE 2B 10 C2 00 5D FF 40 10 00 14 07 00 ?? ?? 02 3C ?? ?? 43 8C 00 80 04 3C 22 00 02 24 00 00 62 AC 21 10 88 00 ?? ?? ?? 0? 20 00 02 AE 2B 10 C2 00 2B FF 40 10 02 1C 06 00 ?? ?? 02 3C ?? ?? 43 8C 22 00 02 24 00 80 04 3C ?? ?? ?? 0? 00 00 62 AC 2B 10 C2 00 7E FF 40 10 00 14 07 00 ?? ?? 02 3C ?? ?? 43 8C 00 80 04 3C 22 00 02 24 00 00 62 AC 21 10 88 00 ?? ?? ?? 0? 04 00 02 AE 2B 10 C2 00 B3 FF 40 10 02 1C 06 00 ?? ?? 02 3C ?? ?? 43 8C 22 00 02 24 00 80 04 3C ?? ?? ?? 0? 00 00 62 AC 2B 10 C2 00 9D FF 40 10 02 1C 06 00 ?? ?? 02 3C ?? ?? 43 8C 22 00 02 24 00 80 04 3C ?? ?? ?? 0? 00 00 62 AC 2B 10 C2 00 AE FF 40 10 00 14 07 00 ?? ?? 02 3C ?? ?? 43 8C 00 80 04 3C 22 00 02 24 00 00 62 AC 21 10 88 00 ?? ?? ?? 0? 10 00 02 AE 01 00 42 34 2B 10 C2 00 9C FF 40 54 00 80 E2 28 ?? ?? ?? 0? ?? ?? 02 3C 01 00 42 34 2B 10 C2 00 89 FF 40 54 00 80 E2 28 ?? ?? ?? 0? ?? ?? 02 3C 01 00 42 34 2B 10 C2 00 76 FF 40 54 00 80 E2 28 ?? ?? ?? 0? ?? ?? 02 3C }
	condition:
		$1
}

rule file_45_6_0 {
	meta:
		name = "_soft_quad3d"
		size = 56
	strings:
		$1 = { 1C 00 82 8C E8 FF BD 27 14 00 BF AF DC 00 43 8C 00 00 A7 AF 04 00 A8 AF 08 00 A9 AF 0C 00 AA AF 21 40 A0 03 09 F8 60 00 04 00 07 24 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_45_7_0 {
	meta:
		name = "_soft_quad3d_f"
		size = 56
	strings:
		$1 = { 1C 00 82 8C E8 FF BD 27 14 00 BF AF E0 00 43 8C 00 00 A7 AF 04 00 A8 AF 08 00 A9 AF 0C 00 AA AF 21 40 A0 03 09 F8 60 00 04 00 07 24 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_45_8_0 {
	meta:
		name = "clear_zbuffer"
		size = 28
	strings:
		$1 = { 1C 00 82 8C F8 FF BD 27 00 00 AC E7 00 00 A5 8F A0 00 59 8C 08 00 20 03 08 00 BD 27 }
	condition:
		$1
}

rule file_45_11_0 {
	meta:
		name = "destroy_zbuffer"
		size = 44
		refs = "0004 _zbuffer 0014 destroy_bitmap"
	strings:
		$1 = { 08 00 80 10 ?? ?? 03 3C ?? ?? 62 8C 03 00 82 10 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? ?? ?? 60 AC 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_45_12_0 {
	meta:
		name = "create_zbuffer"
		size = 16
		refs = "0008 create_bitmap_ex"
	strings:
		$1 = { 04 00 86 8C 00 00 85 8C ?? ?? ?? 0? 20 00 04 24 }
	condition:
		$1
}

rule file_45_13_0 {
	meta:
		name = "_fill_3d_edge_structure_f"
		size = 6644
		refs = "0090 $LC2 02c0 allegro_errno 0064 __extendsfdf2 0070 $LC1 0084 __gtdf2 0120 $LC6 03c8 __ltdf2 04d8 $LC3 04e4 $LC5 04f4 __muldf3 0508 __adddf3 0514 __fixdfsi 05cc .text 0728 __floatsidf 0730 $LC0 074c __truncdfsf2 07b4 $LC7 0914 __divdf3 1118 $LC4 15f8 getr_depth 1618 getg_depth 1638 getb_depth 1678 _clip_polygon_segment_f"
	strings:
		$1 = { 04 00 C0 C4 04 00 AC C4 98 FF BD 27 58 00 BE AF 3C 00 0C 46 54 00 B7 AF 50 00 B6 AF 5C 00 BF AF 4C 00 B5 AF 48 00 B4 AF 44 00 B3 AF 40 00 B2 AF 3C 00 B1 AF 38 00 B0 AF 64 00 B5 E7 60 00 B4 E7 21 F0 A0 00 21 B8 C0 00 21 B0 80 00 28 00 A7 AF 04 00 00 45 2C 00 A8 AF 06 03 00 46 21 B8 A0 00 21 F0 C0 00 ?? ?? ?? 0? 00 00 00 00 21 80 40 00 ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 21 28 60 00 ?? ?? ?? 0? 21 88 60 00 CB 00 40 18 ?? ?? 02 3C ?? ?? 05 3C ?? ?? A3 8C 22 00 02 24 00 00 62 AC ?? ?? A3 8C 22 00 02 24 FF 7F 04 24 00 00 62 AC 04 00 EC C6 ?? ?? ?? 0? 00 00 C4 AE 21 88 60 00 21 28 60 00 ?? ?? 03 3C ?? ?? 66 8C ?? ?? 67 8C 21 20 40 00 ?? ?? ?? 0? 21 80 40 00 D0 00 40 18 ?? ?? 02 3C ?? ?? 05 3C ?? ?? A3 8C 22 00 02 24 00 00 62 AC ?? ?? A3 8C 22 00 02 24 FE 7F 04 24 00 00 62 AC 00 00 D2 8E 2A 10 92 00 D5 00 40 14 04 00 C4 AE 04 00 D4 C7 04 00 E0 C6 ?? ?? 04 3C ?? ?? 81 C4 01 00 14 46 06 03 00 46 ?? ?? ?? 0? 43 0D 00 46 21 80 40 00 21 20 40 00 ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 28 60 00 ?? ?? ?? 0? 21 88 60 00 D2 00 40 18 ?? ?? 02 3C ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC 00 00 D2 8E FF FF 42 34 10 00 A2 AF ?? ?? ?? 0? 06 A3 00 46 21 88 60 00 21 28 60 00 ?? ?? 03 3C ?? ?? 66 8C ?? ?? 67 8C 21 20 40 00 ?? ?? ?? 0? 21 80 40 00 EA 00 40 18 ?? ?? 02 3C ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 44 34 00 00 C0 C7 00 00 EC C6 00 14 12 00 23 A0 44 00 01 63 00 46 ?? ?? ?? 0? 02 63 15 46 21 80 40 00 21 20 40 00 ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 28 60 00 ?? ?? ?? 0? 21 88 60 00 72 03 40 18 ?? ?? 02 3C ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 42 34 00 00 CC C7 ?? ?? ?? 0? 0C 00 C2 AE 21 88 60 00 21 28 60 00 ?? ?? 03 3C ?? ?? 66 8C ?? ?? 67 8C 21 20 40 00 ?? ?? ?? 0? 21 80 40 00 3F 03 40 18 ?? ?? 02 3C ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 46 34 0C 00 C3 8E C3 AF 14 00 18 00 A3 02 C3 17 03 00 1C 00 54 00 12 20 00 00 30 00 A4 AF 30 00 A2 8F 19 00 83 02 10 28 00 00 21 28 45 00 00 80 02 34 2A 10 A2 00 12 01 40 10 12 20 00 00 FF 7F 02 24 0B 01 A2 10 FF FF 02 3C 00 80 A2 28 91 03 40 14 ?? ?? 02 3C 00 80 02 24 8A 03 A2 10 01 00 02 3C 02 1C 04 00 00 14 05 00 25 20 43 00 21 10 86 00 28 00 A4 8F 08 00 C2 AE 78 00 C0 AE 10 00 83 30 7C 00 C0 AE 0C 01 60 14 10 00 C0 AE 28 00 A7 8F 01 00 E2 30 41 01 40 10 28 00 A5 8F 2C 00 A3 8F 08 00 62 8C C6 02 40 10 00 00 D2 8E 2C 00 A4 8F 14 00 83 8C 2A 10 43 02 0E 00 40 50 04 00 C3 8E 0C 00 C4 8E 23 10 72 00 08 00 C3 8E 18 00 44 00 12 10 00 00 21 18 62 00 08 00 C3 AE 2C 00 A3 8F 14 00 62 8C 00 00 C2 AE 21 90 40 00 2C 00 A4 8F 04 00 C3 8E 18 00 88 8C 2A 10 68 00 04 00 40 14 2A 10 72 00 FF FF 03 25 04 00 C3 AE 2A 10 72 00 01 00 42 38 5C 00 BF 8F 58 00 BE 8F 54 00 B7 8F 50 00 B6 8F 4C 00 B5 8F 48 00 B4 8F 44 00 B3 8F 40 00 B2 8F 3C 00 B1 8F 38 00 B0 8F 64 00 B5 C7 60 00 B4 C7 08 00 E0 03 68 00 BD 27 ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 A2 00 41 04 21 20 00 02 ?? ?? 05 3C ?? ?? A3 8C 04 00 EC C6 01 80 04 24 22 00 02 24 00 00 62 AC ?? ?? ?? 0? 00 00 C4 AE 21 88 60 00 21 28 60 00 ?? ?? 03 3C ?? ?? 66 8C ?? ?? 67 8C 21 20 40 00 ?? ?? ?? 0? 21 80 40 00 34 FF 40 5C ?? ?? 05 3C ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 66 00 41 04 21 20 00 02 ?? ?? 02 3C ?? ?? 43 8C 01 80 04 24 22 00 02 24 00 00 62 AC FF FF 84 24 00 00 D2 8E 2A 10 92 00 2D FF 40 10 04 00 C4 AE 5C 00 BF 8F 21 10 00 00 58 00 BE 8F 54 00 B7 8F 50 00 B6 8F 4C 00 B5 8F 48 00 B4 8F 44 00 B3 8F 40 00 B2 8F 3C 00 B1 8F 38 00 B0 8F 64 00 B5 C7 60 00 B4 C7 08 00 E0 03 68 00 BD 27 ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 E6 02 40 04 ?? ?? 02 3C 21 20 00 02 21 28 20 02 21 30 00 00 ?? ?? ?? 0? 21 38 00 00 77 04 40 04 ?? ?? 02 3C ?? ?? 54 8C ?? ?? 55 8C ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 21 20 40 00 21 30 80 02 21 38 A0 02 ?? ?? ?? 0? 21 28 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 06 A3 00 46 ?? ?? ?? 0? 10 00 A2 AF 21 88 60 00 21 28 60 00 ?? ?? 03 3C ?? ?? 66 8C ?? ?? 67 8C 21 20 40 00 ?? ?? ?? 0? 21 80 40 00 1A FF 40 1C ?? ?? 02 3C ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 C2 02 40 04 ?? ?? 02 3C 21 20 00 02 21 28 20 02 21 30 00 00 ?? ?? ?? 0? 21 38 00 00 47 04 40 04 ?? ?? 02 3C ?? ?? 54 8C ?? ?? 55 8C ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 21 20 40 00 21 28 60 00 21 30 80 02 ?? ?? ?? 0? 21 38 A0 02 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 21 28 20 02 21 30 00 00 ?? ?? ?? 0? 21 38 00 00 D0 02 40 04 ?? ?? 02 3C ?? ?? 52 8C ?? ?? 53 8C ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 21 20 40 00 21 28 60 00 21 30 40 02 ?? ?? ?? 0? 21 38 60 02 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 21 18 40 00 FF 7F 02 3C 01 00 42 34 2A 10 62 00 E6 04 40 10 FF FF 02 34 21 10 62 00 DF 04 42 04 27 10 02 00 03 14 02 00 ?? ?? ?? 0? FF FF 44 24 21 28 20 02 21 30 00 00 ?? ?? ?? 0? 21 38 00 00 AA 02 40 04 ?? ?? 02 3C ?? ?? 52 8C ?? ?? 53 8C ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 21 20 40 00 21 28 60 00 21 30 40 02 ?? ?? ?? 0? 21 38 60 02 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 21 18 40 00 FF 7F 02 3C 01 00 42 34 2A 10 62 00 C9 04 40 10 FF FF 02 34 21 10 62 00 C3 04 42 04 27 10 02 00 ?? ?? ?? 0? 03 24 02 00 01 00 42 34 2B 10 82 00 F4 FE 40 14 00 80 A2 28 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 44 34 21 10 86 00 28 00 A4 8F 08 00 C2 AE 78 00 C0 AE 10 00 83 30 7C 00 C0 AE F6 FE 60 10 10 00 C0 AE ?? ?? ?? 0? 21 20 80 02 ?? ?? 04 3C ?? ?? 86 8C ?? ?? 87 8C 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 ?? ?? 05 3C 08 00 E1 C6 C6 01 00 46 ?? ?? A2 C4 08 00 C0 C7 28 00 A6 8F 83 11 01 46 C3 10 00 46 20 00 C2 30 01 30 03 46 02 00 15 46 42 38 00 46 48 00 C0 E6 40 08 03 46 DB FE 40 10 44 00 C1 E6 0C 00 C4 C7 10 00 C5 C7 10 00 E2 C6 0C 00 E1 C6 42 19 05 46 02 19 04 46 42 30 01 46 82 30 02 46 ?? ?? 02 3C ?? ?? 40 C4 28 00 A7 8F 02 21 00 46 42 29 00 46 42 08 00 46 82 10 00 46 01 00 E2 30 41 08 04 46 81 10 05 46 42 08 15 46 82 10 15 46 C2 38 01 46 02 38 02 46 54 00 C1 E6 58 00 C2 E6 C0 18 04 46 00 00 05 46 4C 00 C3 E6 C2 FE 40 14 50 00 C0 E6 28 00 A5 8F 02 00 A2 30 99 01 40 10 28 00 A3 8F 14 00 E2 8E 14 00 C3 8F 10 00 A6 8F 23 10 43 00 4C 02 C0 14 00 2C 02 00 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 73 02 A0 04 00 00 83 AC FF 7F 02 3C FF 7F 10 3C FF FF 42 34 FF FF 10 36 21 88 00 00 18 00 91 02 28 00 C2 AE 14 00 C6 8F 1C 00 B0 02 12 10 00 00 30 00 A2 AF 19 00 14 02 10 28 00 00 21 28 45 00 00 80 02 34 2A 10 A2 00 72 01 40 10 12 20 00 00 FF 7F 02 24 6B 01 A2 10 FF FF 02 3C 00 80 A2 28 15 03 40 14 ?? ?? 02 3C 00 80 02 24 0E 03 A2 10 01 00 02 3C 02 1C 04 00 00 14 05 00 ?? ?? ?? 0? 25 20 43 00 ?? ?? ?? 0? 10 00 A4 8F ?? ?? 05 3C ?? ?? A6 8C ?? ?? A7 8C 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 00 02 21 90 40 00 ?? ?? ?? 0? 21 98 60 00 21 20 40 00 ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C ?? ?? ?? 0? 21 28 60 00 21 20 40 00 21 28 60 00 21 30 40 02 ?? ?? ?? 0? 21 38 60 02 21 88 60 00 21 28 60 00 ?? ?? 03 3C ?? ?? 66 8C ?? ?? 67 8C 21 20 40 00 ?? ?? ?? 0? 21 80 40 00 FB 02 40 1C ?? ?? 02 3C ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 AB 03 43 04 21 20 00 02 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 00 80 02 3C 00 00 83 AC 01 00 42 34 20 00 A5 8F 1C 00 A3 8F 38 00 C2 AE 23 20 65 00 ?? ?? ?? 0? 00 24 04 00 21 20 40 00 ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C ?? ?? ?? 0? 21 28 60 00 21 20 40 00 21 28 60 00 21 30 40 02 ?? ?? ?? 0? 21 38 60 02 21 88 60 00 21 28 60 00 ?? ?? 03 3C ?? ?? 66 8C ?? ?? 67 8C 21 20 40 00 ?? ?? ?? 0? 21 80 40 00 61 03 40 18 ?? ?? 02 3C ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 42 34 14 00 A5 8F 18 00 A6 8F 3C 00 C2 AE 23 20 A6 00 ?? ?? ?? 0? 00 24 04 00 21 20 40 00 ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C ?? ?? ?? 0? 21 28 60 00 21 20 40 00 21 28 60 00 21 30 40 02 ?? ?? ?? 0? 21 38 60 02 21 88 60 00 21 28 60 00 ?? ?? 03 3C ?? ?? 66 8C ?? ?? 67 8C 21 20 40 00 ?? ?? ?? 0? 21 80 40 00 32 03 40 18 ?? ?? 02 3C ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 00 00 83 AC FF 7F 02 3C FF FF 42 34 38 00 C3 8E 40 00 C2 AE 18 00 A3 02 C3 17 03 00 1C 00 54 00 12 20 00 00 30 00 A4 AF 30 00 A2 8F 19 00 83 02 10 28 00 00 21 28 45 00 00 80 02 34 2A 10 A2 00 C5 02 40 10 12 20 00 00 FF 7F 02 24 BE 02 A2 10 FF FF 02 3C 00 80 A2 28 09 03 40 14 ?? ?? 02 3C 00 80 02 24 02 03 A2 10 01 00 02 3C 02 1C 04 00 00 14 05 00 25 28 43 00 3C 00 C3 8E 24 00 A4 8F 18 00 A3 02 00 14 04 00 C3 27 03 00 21 10 A2 00 2C 00 C2 AE 1C 00 94 00 12 10 00 00 19 00 83 02 10 28 00 00 21 28 45 00 00 80 02 34 2A 10 A2 00 9E 02 40 10 12 20 00 00 FF 7F 02 24 97 02 A2 10 FF FF 02 3C 00 80 A2 28 F6 02 40 14 ?? ?? 02 3C 00 80 02 24 EF 02 A2 10 01 00 02 3C 02 1C 04 00 00 14 05 00 25 28 43 00 40 00 C3 8E 20 00 A4 8F 18 00 A3 02 00 14 04 00 C3 27 03 00 21 10 A2 00 30 00 C2 AE 1C 00 94 00 12 10 00 00 30 00 A2 AF 19 00 83 02 10 28 00 00 21 28 45 00 00 80 02 34 2A 10 A2 00 76 02 40 10 12 20 00 00 FF 7F 02 24 6F 02 A2 10 FF FF 02 3C 00 80 A2 28 C7 02 40 14 ?? ?? 02 3C 00 80 02 24 C0 02 A2 10 01 00 02 3C 02 1C 04 00 00 14 05 00 25 20 43 00 18 00 A3 8F 00 14 03 00 21 10 82 00 34 00 C2 AE 28 00 A4 8F 08 00 82 30 8C 00 40 10 2C 00 A3 8F 0C 00 C0 C7 0C 00 EC C6 01 63 00 46 ?? ?? ?? 0? 02 63 15 46 21 80 40 00 21 20 40 00 ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 28 60 00 ?? ?? ?? 0? 21 88 60 00 EC 01 40 18 ?? ?? 02 3C ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 42 34 10 00 C0 C7 10 00 EC C6 1C 00 C2 AE 01 63 00 46 ?? ?? ?? 0? 02 63 15 46 21 88 60 00 21 28 60 00 ?? ?? 03 3C ?? ?? 66 8C ?? ?? 67 8C 21 20 40 00 ?? ?? ?? 0? 21 80 40 00 B5 01 40 18 ?? ?? 02 3C ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 42 34 0C 00 CC C7 ?? ?? ?? 0? 20 00 C2 AE 21 80 40 00 21 20 40 00 ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 28 60 00 ?? ?? ?? 0? 21 88 60 00 82 01 40 18 ?? ?? 02 3C ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 46 34 1C 00 C2 8E 18 00 A2 02 C3 1F 02 00 1C 00 74 00 12 20 00 00 30 00 A4 AF 19 00 82 02 30 00 A2 8F 10 28 00 00 21 28 45 00 00 80 02 34 2A 10 A2 00 09 00 40 10 12 20 00 00 FF 7F 02 24 03 01 A2 14 00 80 A2 28 FF FF 02 3C 01 00 42 34 2B 10 82 00 FE 00 40 14 00 80 A2 28 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 44 34 10 00 CC C7 21 10 86 00 ?? ?? ?? 0? 14 00 C2 AE 21 88 60 00 21 28 60 00 ?? ?? 03 3C ?? ?? 66 8C ?? ?? 67 8C 21 20 40 00 ?? ?? ?? 0? 21 80 40 00 32 01 40 18 ?? ?? 02 3C ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 46 34 20 00 C2 8E 18 00 A2 02 C3 1F 02 00 1C 00 74 00 12 20 00 00 30 00 A4 AF 19 00 82 02 30 00 A2 8F 10 28 00 00 21 28 45 00 00 80 02 34 2A 10 A2 00 15 01 40 10 12 20 00 00 FF 7F 02 24 0E 01 A2 10 FF FF 02 3C 00 80 A2 28 B4 01 40 14 ?? ?? 02 3C 00 80 02 24 AD 01 A2 10 01 00 02 3C 00 14 05 00 02 1C 04 00 25 20 43 00 21 10 86 00 18 00 C2 AE 2C 00 A3 8F 08 00 62 8C A5 00 40 54 2C 00 A5 8F 00 00 D2 8E 04 00 C3 8E 2A 10 72 00 ?? ?? ?? 0? 01 00 42 38 01 00 42 34 2B 10 82 00 94 FE 40 14 00 80 A2 28 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 44 34 00 14 06 00 21 10 82 00 24 00 C2 AE 28 00 A3 8F 04 00 62 30 5A FF 40 10 28 00 A4 8F 80 00 62 30 D8 01 40 14 2C 00 A4 8F 14 00 C2 8F 14 00 E3 8E FF 00 45 30 FF 00 66 30 00 3C 47 7C 00 3C 71 7C 00 3A 42 7C 00 3A 63 7C 18 00 A5 AF 14 00 A6 AF 24 00 A7 AF 20 00 A2 AF 1C 00 A3 AF 24 00 A3 8F 10 00 A4 8F 23 10 23 02 7B FE 80 14 00 84 02 00 ?? ?? 05 3C ?? ?? A3 8C 22 00 02 24 9D 01 00 06 00 00 62 AC FF 7F 02 3C FF FF 42 34 1C 00 A7 8F 20 00 A6 8F ?? ?? A4 8C 38 00 C2 AE 23 18 E6 00 22 00 02 24 00 1C 03 00 8C 02 60 04 00 00 82 AC FF 7F 02 3C FF FF 42 34 ?? ?? A4 8C 14 00 A7 8F 18 00 A5 8F 3C 00 C2 AE 22 00 02 24 23 18 E5 00 00 1C 03 00 CF FE 61 04 00 00 82 AC 00 80 02 3C ?? ?? ?? 0? 01 00 42 34 ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 4F 00 40 04 ?? ?? 02 3C 21 20 00 02 21 28 20 02 21 30 00 00 ?? ?? ?? 0? 21 38 00 00 C1 01 40 04 ?? ?? 02 3C ?? ?? 52 8C ?? ?? 53 8C ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 21 20 40 00 21 30 40 02 21 28 60 00 ?? ?? ?? 0? 21 38 60 02 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 ?? ?? ?? 0? 21 30 40 00 ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 29 00 40 04 ?? ?? 02 3C 21 20 00 02 21 28 20 02 21 30 00 00 ?? ?? ?? 0? 21 38 00 00 }
	condition:
		$1
}

rule file_45_14_0 {
	meta:
		name = "_soft_triangle3d_f"
		size = 4032
		refs = "01e8 allegro_errno 0054 _get_scanline_filler 00d4 _fill_3d_edge_structure_f 0100 _poly_scanline_dummy 0150 __extendsfdf2 0158 $LC1 0170 __gtdf2 01ac _clip_polygon_segment 027c __floatsidf 0284 $LC0 0290 __muldf3 02c8 __divdf3 02f8 $LC2 0308 __ltdf2 070c $LC5 0728 __truncdfsf2 0730 $LC6 0768 $LC7 0854 .text 0994 $LC3 09c4 __adddf3 09d0 __fixdfsi 0a7c getr_depth 0a8c getg_depth 0a9c getb_depth 0990 $LC4"
	strings:
		$1 = { B8 FD BD 27 20 02 B0 AF 21 80 E0 00 14 00 02 8E 34 02 B5 AF 21 A8 80 00 28 02 B2 AF 21 20 A0 00 21 38 C0 00 21 90 00 01 08 00 A5 27 0C 00 A6 27 21 40 A0 02 24 02 B1 AF 44 02 BF AF 40 02 BE AF 3C 02 B7 AF 38 02 B6 AF 30 02 B4 AF 2C 02 B3 AF 21 88 20 01 ?? ?? ?? 0? 18 02 A2 AF EB 01 40 10 10 02 A2 AF 04 00 02 C6 04 00 41 C6 3C 08 02 46 00 00 00 00 F1 01 03 45 04 00 20 C6 06 10 00 46 86 08 00 46 46 00 00 46 04 00 20 C6 21 F0 00 02 3C 00 01 46 00 00 00 00 ED 01 01 45 21 B0 40 02 46 00 00 46 14 02 B1 AF 3C 08 02 46 00 00 00 00 05 00 00 45 08 00 A7 8F 14 02 A2 8F 14 02 B6 AF 21 B0 40 00 08 00 A7 8F 14 02 A6 8F D4 00 A4 27 21 28 C0 03 ?? ?? ?? 0? 21 40 A0 02 CC 01 40 10 44 02 BF 8F 1C 00 A2 8E 10 00 42 8C 04 00 40 10 10 02 A3 8F 09 F8 40 00 21 20 A0 02 10 02 A3 8F ?? ?? 02 3C ?? ?? 42 24 A5 01 62 10 E8 00 A6 27 70 00 B4 27 21 38 80 02 48 01 A8 27 00 00 C2 8C 04 00 C3 8C 08 00 C4 8C 0C 00 C5 8C 10 00 C6 24 00 00 E2 AC 04 00 E3 AC 08 00 E4 AC 0C 00 E5 AC F6 FF C8 14 10 00 E7 24 00 00 C2 8C 00 00 E2 AC ?? ?? ?? 0? 04 00 CC C6 ?? ?? 04 3C ?? ?? 86 8C ?? ?? 87 8C 21 28 60 00 21 20 40 00 21 80 40 00 ?? ?? ?? 0? 21 88 60 00 B8 01 40 18 ?? ?? 02 3C ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 42 34 D4 00 B0 8F 08 00 A6 8F 21 20 80 02 00 84 10 00 23 80 50 00 ?? ?? ?? 0? 21 28 00 02 E0 00 A3 8F 00 80 02 34 DC 00 B7 8F 18 00 03 02 10 28 00 00 2A 10 A2 00 C3 01 40 10 12 20 00 00 FF 7F 02 24 BC 01 A2 10 FF FF 02 3C 00 80 A2 28 E0 01 40 14 ?? ?? 02 3C 00 80 02 24 D9 01 A2 10 01 00 02 3C 02 1C 04 00 00 14 05 00 25 A0 43 00 ?? ?? ?? 0? 00 00 CC C6 21 80 40 00 21 20 40 00 ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 28 60 00 ?? ?? ?? 0? 21 88 60 00 99 01 40 18 ?? ?? 02 3C ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 43 34 21 10 97 02 23 B8 43 00 53 01 E0 12 08 00 A7 8F 08 00 A3 8F 02 00 62 30 33 00 40 10 E0 01 A3 AF 14 00 C4 8E 80 00 A2 8F ?? ?? 12 3C 00 24 04 00 ?? ?? ?? 0? 23 20 44 00 ?? ?? 46 8E ?? ?? 47 8E 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 21 20 E0 02 21 80 40 00 ?? ?? ?? 0? 21 88 60 00 ?? ?? 46 8E ?? ?? 47 8E 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 30 40 00 21 20 00 02 21 28 20 02 ?? ?? ?? 0? 21 38 60 00 21 80 40 00 21 20 40 00 ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 28 60 00 ?? ?? ?? 0? 21 88 60 00 D9 01 40 1C ?? ?? 02 3C ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 8E 02 41 04 21 20 00 02 ?? ?? 02 3C ?? ?? 44 8C 00 80 02 3C 22 00 03 24 01 00 42 34 00 00 83 AC 20 00 A2 AF E0 01 A3 8F 04 00 62 30 75 00 40 10 08 00 62 30 80 00 62 30 CA 01 40 54 1C 00 A2 8E 14 00 C2 8E FF 00 44 30 00 3C 51 7C 00 3A 42 7C F0 01 A4 AF EC 01 A2 AF ?? ?? 14 3C ?? ?? ?? 0? 21 20 E0 02 ?? ?? 86 8E ?? ?? 87 8E 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 88 00 A4 8F 21 90 40 00 00 14 11 00 23 20 82 00 ?? ?? ?? 0? 21 98 60 00 ?? ?? 86 8E ?? ?? 87 8E 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 40 00 21 28 60 00 21 30 40 02 ?? ?? ?? 0? 21 38 60 02 21 80 40 00 21 20 40 00 ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 28 60 00 ?? ?? ?? 0? 21 88 60 00 D3 01 40 18 ?? ?? 02 3C ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 43 34 EC 01 A5 8F 8C 00 A4 8F 30 00 A3 AF 00 14 05 00 ?? ?? ?? 0? 23 20 82 00 ?? ?? 86 8E ?? ?? 87 8E 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 40 00 21 28 60 00 21 30 40 02 ?? ?? ?? 0? 21 38 60 02 21 80 40 00 21 20 40 00 ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 28 60 00 ?? ?? ?? 0? 21 88 60 00 A5 01 40 18 ?? ?? 02 3C ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 43 34 F0 01 A5 8F 90 00 A4 8F 34 00 A3 AF 00 14 05 00 ?? ?? ?? 0? 23 20 82 00 ?? ?? 86 8E ?? ?? 87 8E 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 40 00 21 28 60 00 21 30 40 02 ?? ?? ?? 0? 21 38 60 02 21 80 40 00 21 20 40 00 ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 28 60 00 ?? ?? ?? 0? 21 88 60 00 BA 01 40 18 ?? ?? 02 3C ?? ?? 02 3C ?? ?? 44 8C FF 7F 02 3C 22 00 03 24 FF FF 42 34 00 00 83 AC 38 00 A2 AF E0 01 A3 8F 08 00 62 30 78 00 40 10 E0 01 A3 8F 70 00 A4 8F 0C 00 CC C6 ?? ?? ?? 0? E4 01 A4 AF 21 80 40 00 21 20 40 00 ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 28 60 00 ?? ?? ?? 0? 21 88 60 00 3C 01 40 1C ?? ?? 02 3C ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 C5 01 43 04 21 20 00 02 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 00 80 02 3C 00 00 83 AC 01 00 50 34 ?? ?? 14 3C ?? ?? ?? 0? 21 20 E0 02 ?? ?? 86 8E ?? ?? 87 8E 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 0C 02 A3 AF E4 01 A3 8F 08 02 A2 AF ?? ?? ?? 0? 23 20 70 00 ?? ?? 86 8E ?? ?? 87 8E 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 08 02 A6 8F 0C 02 A7 8F 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 80 40 00 21 20 40 00 ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 28 60 00 ?? ?? ?? 0? 21 88 60 00 81 01 40 18 ?? ?? 02 3C ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 42 34 74 00 A3 8F 10 00 CC C6 14 00 A2 AF ?? ?? ?? 0? E8 01 A3 AF 21 80 40 00 21 20 40 00 ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 28 60 00 ?? ?? ?? 0? 21 88 60 00 13 01 40 18 ?? ?? 02 3C ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 42 34 E8 01 A3 8F ?? ?? ?? 0? 23 20 62 00 ?? ?? 86 8E ?? ?? 87 8E 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 08 02 A6 8F 0C 02 A7 8F 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 80 40 00 21 20 40 00 ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 28 60 00 ?? ?? ?? 0? 21 88 60 00 5D 01 40 18 ?? ?? 02 3C ?? ?? 02 3C ?? ?? 44 8C FF 7F 02 3C 22 00 03 24 FF FF 42 34 00 00 83 AC 18 00 A2 AF E0 01 A3 8F 10 00 62 30 29 00 40 10 08 00 A7 8F ?? ?? ?? 0? 21 20 E0 02 ?? ?? 06 3C ?? ?? C4 8C ?? ?? C5 8C 21 38 60 00 ?? ?? ?? 0? 21 30 40 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 ?? ?? 02 3C 08 00 C2 C6 ?? ?? 41 C4 06 01 00 46 A0 00 A0 C7 43 08 02 46 E0 01 A4 8F 20 00 83 30 01 00 01 46 02 20 00 46 11 00 60 10 40 00 A0 E7 10 00 C2 C6 0C 00 C3 C6 ?? ?? 02 3C 82 08 02 46 C2 08 03 46 ?? ?? 40 C4 AC 00 A1 C7 82 10 00 46 C2 18 00 46 A8 00 A0 C7 41 08 02 46 01 00 03 46 42 20 01 46 02 20 00 46 50 00 A1 E7 4C 00 A0 E7 08 00 A7 8F 58 01 B0 27 21 28 C0 03 21 20 00 02 21 30 C0 02 ?? ?? ?? 0? 21 40 A0 02 5A 00 40 14 58 01 A5 8F 08 00 A7 8F 14 02 A6 8F 21 28 C0 02 21 20 00 02 ?? ?? ?? 0? 21 40 A0 02 46 00 40 14 58 01 A5 8F 1C 00 A2 8E 08 00 43 8C 09 F8 60 00 21 20 A0 02 1C 00 A2 8E 14 00 42 8C 04 00 40 10 44 02 BF 8F 09 F8 40 00 21 20 A0 02 44 02 BF 8F 40 02 BE 8F 3C 02 B7 8F 38 02 B6 8F 34 02 B5 8F 30 02 B4 8F 2C 02 B3 8F 28 02 B2 8F 24 02 B1 8F 20 02 B0 8F 08 00 E0 03 48 02 BD 27 21 F0 40 02 3C 00 01 46 00 00 00 00 15 FE 00 45 21 B0 00 02 14 02 BE AF ?? ?? ?? 0? 21 F0 20 02 ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 42 00 43 04 21 20 00 02 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 00 80 02 3C 00 00 83 AC ?? ?? ?? 0? 01 00 42 34 ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 4D 00 41 04 21 20 00 02 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 00 80 02 3C 00 00 83 AC ?? ?? ?? 0? 01 00 43 34 01 00 42 34 2B 10 82 00 43 FE 40 14 00 80 A2 28 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC ?? ?? ?? 0? FF FF 54 34 5C 01 A6 8F 10 02 A9 8F 08 00 AA 8F 18 02 AB 8F 0C 00 A3 27 D4 00 A7 27 21 40 00 02 21 20 A0 02 ?? ?? ?? 0? 00 00 A3 AF ?? ?? ?? 0? 1C 00 A2 8E 5C 01 A6 8F 08 00 AA 8F 10 02 A9 8F 18 02 AB 8F 0C 00 A2 27 21 20 A0 02 D4 00 A7 27 21 40 00 02 ?? ?? ?? 0? 00 00 A2 AF ?? ?? ?? 0? 08 00 A7 8F 2B 10 82 00 27 FE 40 10 02 1C 04 00 ?? ?? 02 3C ?? ?? 43 8C 22 00 02 24 00 80 14 3C ?? ?? ?? 0? 00 00 62 AC 21 28 20 02 21 30 00 00 ?? ?? ?? 0? 21 38 00 00 55 00 42 04 ?? ?? 02 3C ?? ?? 02 3C ?? ?? 52 8C ?? ?? 53 8C ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 21 20 40 00 21 28 60 00 21 30 40 02 ?? ?? ?? 0? 21 38 60 02 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 ?? ?? ?? 0? D4 00 B0 8F 21 28 20 02 21 30 00 00 ?? ?? ?? 0? 21 38 00 00 3F 00 40 04 ?? ?? 02 3C ?? ?? 52 8C ?? ?? 53 8C ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 21 20 40 00 21 28 60 00 21 30 40 02 ?? ?? ?? 0? 21 38 60 02 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 ?? ?? ?? 0? 21 18 40 00 ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC ?? ?? ?? 0? FF FF 50 34 ?? ?? 44 8C FF 7F 02 3C 22 00 03 24 FF FF 42 34 00 00 83 AC ?? ?? ?? 0? 20 00 A2 AF 14 00 C5 8E 00 00 50 8C ?? ?? ?? 0? 21 20 00 02 14 00 C5 8E 21 20 00 02 ?? ?? ?? 0? 21 88 40 00 14 00 C5 8E 21 20 00 02 ?? ?? ?? 0? EC 01 A2 AF ?? ?? ?? 0? F0 01 A2 AF ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 2B 00 43 04 21 20 00 02 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 00 80 02 3C 00 00 83 AC ?? ?? ?? 0? 01 00 42 34 ?? ?? 52 8C ?? ?? ?? 0? ?? ?? 53 8C ?? ?? 02 3C ?? ?? 52 8C ?? ?? ?? 0? ?? ?? 53 8C ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 73 00 43 04 21 20 00 02 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 00 80 02 3C 00 00 83 AC ?? ?? ?? 0? 01 00 43 34 ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 97 00 43 04 21 20 00 02 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 00 80 02 3C 00 00 83 AC ?? ?? ?? 0? 01 00 43 34 21 28 20 02 21 30 00 00 ?? ?? ?? 0? 21 38 00 00 F1 00 42 04 ?? ?? 02 3C ?? ?? 02 3C ?? ?? 52 8C ?? ?? 53 8C ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 21 20 40 00 21 28 60 00 21 30 40 02 ?? ?? ?? 0? 21 38 60 02 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 ?? ?? ?? 0? E8 01 A3 8F ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 A3 00 41 04 21 20 00 02 ?? ?? 02 3C ?? ?? 44 8C 00 80 02 3C 22 00 03 24 01 00 42 34 00 00 83 AC ?? ?? ?? 0? 38 00 A2 AF ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 7B 00 41 04 21 20 00 02 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 00 80 02 3C 00 00 83 AC ?? ?? ?? 0? 01 00 42 34 ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 9E 00 41 04 21 20 00 02 ?? ?? 02 3C ?? ?? 44 8C 00 80 02 3C 22 00 03 24 01 00 42 34 00 00 83 AC ?? ?? ?? 0? 18 00 A2 AF 21 28 20 02 21 30 00 00 ?? ?? ?? 0? 21 38 00 00 A8 00 40 04 ?? ?? 02 3C ?? ?? 52 8C ?? ?? 53 8C ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 21 20 40 00 21 28 60 00 21 30 40 02 ?? ?? ?? 0? 21 38 60 02 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 ?? ?? ?? 0? 21 80 40 00 21 28 20 02 21 30 00 00 ?? ?? ?? 0? 21 38 00 00 97 00 40 04 ?? ?? 02 3C ?? ?? 44 8C ?? ?? 45 8C 00 02 A4 AF 04 02 A5 AF ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 00 02 A6 8F 04 02 A7 8F 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 ?? ?? ?? 0? 21 18 40 00 21 28 20 02 21 30 00 00 ?? ?? ?? 0? 21 38 00 00 83 00 40 04 ?? ?? 02 3C ?? ?? 52 8C ?? ?? 53 8C ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 21 20 40 00 21 28 60 00 21 30 40 02 ?? ?? ?? 0? 21 38 60 02 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 ?? ?? ?? 0? 20 00 A2 AF 21 28 20 02 21 30 00 00 ?? ?? ?? 0? 21 38 00 00 73 00 40 04 ?? ?? 02 3C ?? ?? 44 8C ?? ?? 45 8C F8 01 A4 AF FC 01 A5 AF ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 F8 01 A6 8F FC 01 A7 8F 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 ?? ?? ?? 0? 21 18 40 00 21 28 20 02 21 30 00 00 ?? ?? ?? 0? 21 38 00 00 5F 00 42 04 ?? ?? 02 3C ?? ?? 02 3C ?? ?? 52 8C ?? ?? 53 8C ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 21 20 40 00 21 28 60 00 21 30 40 02 ?? ?? ?? 0? 21 38 60 02 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 ?? ?? ?? 0? 74 00 A3 8F 21 28 20 02 21 30 00 00 ?? ?? ?? 0? 21 38 00 00 49 00 40 04 ?? ?? 02 3C ?? ?? 52 8C ?? ?? 53 8C ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 21 20 40 00 21 28 60 00 21 30 40 02 ?? ?? ?? 0? 21 38 60 02 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 ?? ?? ?? 0? 38 00 A2 AF 21 28 20 02 21 30 00 00 ?? ?? ?? 0? 21 38 00 00 24 00 40 04 ?? ?? 02 3C ?? ?? 52 8C ?? ?? 53 8C ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 21 20 40 00 21 28 60 00 21 30 40 02 ?? ?? ?? 0? 21 38 60 02 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 ?? ?? ?? 0? 18 00 A2 AF ?? ?? 02 3C ?? ?? 52 8C ?? ?? ?? 0? ?? ?? 53 8C ?? ?? 52 8C ?? ?? ?? 0? ?? ?? 53 8C ?? ?? 02 3C ?? ?? 44 8C ?? ?? 45 8C 00 02 A4 AF ?? ?? ?? 0? 04 02 A5 AF ?? ?? 02 3C ?? ?? 52 8C ?? ?? ?? 0? ?? ?? 53 8C ?? ?? 02 3C ?? ?? 52 8C ?? ?? ?? 0? ?? ?? 53 8C ?? ?? 02 3C ?? ?? 44 8C ?? ?? 45 8C F8 01 A4 AF ?? ?? ?? 0? FC 01 A5 AF ?? ?? 52 8C ?? ?? ?? 0? ?? ?? 53 8C ?? ?? 02 3C ?? ?? 52 8C ?? ?? ?? 0? ?? ?? 53 8C }
	condition:
		$1
}

rule file_45_15_0 {
	meta:
		name = "_fill_3d_edge_structure"
		size = 5412
		refs = "0168 allegro_errno 0318 __floatsidf 0320 $LC0 032c __muldf3 0364 __divdf3 0370 $LC1 0384 __gtdf2 0394 $LC2 03a4 __ltdf2 0454 $LC5 0470 __truncdfsf2 0648 .text 0be4 _clip_polygon_segment 0cec $LC3 0d1c __adddf3 0d28 __fixdfsi 0ce8 $LC4 10c8 getr_depth 10e8 getg_depth 1108 getb_depth"
	strings:
		$1 = { 80 FF BD 27 5C 00 B5 AF 04 00 C3 8C 21 A8 A0 00 04 00 A5 8C 58 00 B4 AF 54 00 B3 AF 2A 10 65 00 6C 00 BF AF 68 00 BE AF 64 00 B7 AF 60 00 B6 AF 50 00 B2 AF 4C 00 B1 AF 48 00 B0 AF 7C 00 B6 E7 78 00 B5 E7 74 00 B4 E7 21 A0 C0 00 21 98 80 00 30 00 A7 AF 83 00 40 14 34 00 A8 AF FF 7F 02 3C 21 18 A0 00 01 00 42 34 2A 10 62 00 84 00 40 14 FF FF 02 34 ?? ?? 02 3C ?? ?? 43 8C 22 00 02 24 FF 7F 04 24 00 00 62 AC 00 00 64 AE 04 00 83 8E FF 7F 02 3C 01 00 42 34 2A 10 62 00 84 00 40 14 FF FF 02 34 ?? ?? 02 3C ?? ?? 43 8C 22 00 02 24 FE 7F 04 24 00 00 62 AC 00 00 67 8E 2A 10 87 00 84 00 40 14 04 00 64 AE 04 00 A3 8E 04 00 84 8E 00 00 86 8E 00 00 A5 8E 00 14 07 00 23 20 83 00 18 00 A4 AF 23 F0 43 00 8A 00 80 14 23 30 C5 00 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 B1 00 C0 04 00 00 83 AC FF 7F 02 3C FF 7F 10 3C FF FF 42 34 FF FF 10 36 21 88 00 00 18 00 3E 02 C3 27 1E 00 0C 00 62 AE 38 00 A4 AF 00 00 A6 8E 1C 00 90 00 12 10 00 00 40 00 A2 AF 19 00 1E 02 10 28 00 00 21 28 45 00 00 80 02 34 2A 10 A2 00 B1 00 40 10 12 20 00 00 FF 7F 02 24 A6 02 A2 10 FF FF 02 3C 00 80 A2 28 87 02 40 14 ?? ?? 02 3C 00 80 02 24 80 02 A2 10 01 00 02 3C 02 1C 04 00 00 14 05 00 25 20 43 00 21 10 86 00 30 00 A4 8F 08 00 62 AE 78 00 60 AE 10 00 83 30 7C 00 60 AE AB 00 60 14 10 00 60 AE 30 00 A3 8F 01 00 62 30 FB 00 40 10 02 00 62 30 34 00 A4 8F 08 00 82 8C AB 01 40 10 34 00 A5 8F 00 00 67 8E 14 00 A3 8C 2A 10 E3 00 0C 00 40 10 34 00 A2 8F 0C 00 64 8E 23 10 67 00 08 00 63 8E 18 00 44 00 12 10 00 00 21 18 62 00 08 00 63 AE 14 00 A2 8C 00 00 62 AE 21 38 40 00 34 00 A2 8F 04 00 63 8E 18 00 48 8C 2A 10 68 00 04 00 40 14 2A 10 67 00 FF FF 03 25 04 00 63 AE 2A 10 67 00 01 00 42 38 6C 00 BF 8F 68 00 BE 8F 64 00 B7 8F 60 00 B6 8F 5C 00 B5 8F 58 00 B4 8F 54 00 B3 8F 50 00 B2 8F 4C 00 B1 8F 48 00 B0 8F 7C 00 B6 C7 78 00 B5 C7 74 00 B4 C7 08 00 E0 03 80 00 BD 27 FF 7F 02 3C 01 00 42 34 2A 10 62 00 21 A0 A0 02 7F FF 40 10 21 A8 C0 00 FF FF 02 34 21 10 62 00 38 02 42 04 27 10 02 00 03 24 02 00 00 00 64 AE 04 00 83 8E FF 7F 02 3C 01 00 42 34 2A 10 62 00 80 FF 40 10 ?? ?? 02 3C FF FF 02 34 21 10 62 00 28 02 42 04 27 10 02 00 00 00 67 8E 03 14 02 00 FF FF 44 24 2A 10 87 00 7E FF 40 10 04 00 64 AE 6C 00 BF 8F 21 10 00 00 68 00 BE 8F 64 00 B7 8F 60 00 B6 8F 5C 00 B5 8F 58 00 B4 8F 54 00 B3 8F 50 00 B2 8F 4C 00 B1 8F 48 00 B0 8F 7C 00 B6 C7 78 00 B5 C7 74 00 B4 C7 08 00 E0 03 80 00 BD 27 ?? ?? 12 3C ?? ?? ?? 0? 21 20 C0 00 ?? ?? 46 8E ?? ?? 47 8E 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 18 00 A4 8F 21 80 40 00 ?? ?? ?? 0? 21 88 60 00 ?? ?? 46 8E ?? ?? 47 8E 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 30 40 00 21 20 00 02 21 28 20 02 ?? ?? ?? 0? 21 38 60 00 21 80 40 00 ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 21 28 60 00 ?? ?? ?? 0? 21 88 60 00 02 02 40 1C ?? ?? 02 3C ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 49 02 43 04 21 20 00 02 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 00 00 83 AC FF FF 11 24 18 00 3E 02 00 80 10 3C C3 27 1E 00 01 00 10 36 00 80 02 3C 01 00 42 34 0C 00 62 AE 38 00 A4 AF 00 00 A6 8E 1C 00 90 00 12 10 00 00 40 00 A2 AF 19 00 1E 02 10 28 00 00 21 28 45 00 00 80 02 34 2A 10 A2 00 51 FF 40 14 12 20 00 00 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 44 34 21 10 86 00 30 00 A4 8F 08 00 62 AE 78 00 60 AE 10 00 83 30 7C 00 60 AE 57 FF 60 10 10 00 60 AE 18 00 A4 8F ?? ?? ?? 0? ?? ?? 10 3C ?? ?? 04 8E ?? ?? 05 8E 21 30 40 00 ?? ?? ?? 0? 21 38 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 C0 03 ?? ?? ?? 0? 86 05 00 46 ?? ?? 04 3C ?? ?? 86 8C ?? ?? 87 8C 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 08 00 A4 8E ?? ?? ?? 0? 46 05 00 46 ?? ?? 04 8E ?? ?? 05 8E 21 30 40 00 ?? ?? ?? 0? 21 38 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 08 00 84 8E ?? ?? ?? 0? 06 05 00 46 ?? ?? 04 8E ?? ?? 05 8E 21 30 40 00 ?? ?? ?? 0? 21 38 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 86 00 00 46 01 00 14 46 30 00 A5 8F 02 00 16 46 20 00 A2 30 42 A8 00 46 48 00 60 E6 40 08 14 46 20 FF 40 10 44 00 61 E6 0C 00 A0 C6 10 00 A3 C6 30 00 A3 8F 20 01 80 46 60 19 80 46 10 00 80 C6 0C 00 83 C6 42 29 14 46 60 00 80 46 20 18 80 46 02 00 02 46 02 21 14 46 42 08 02 46 01 00 62 30 01 00 04 46 41 08 05 46 02 00 16 46 42 08 16 46 82 A8 00 46 C2 A8 01 46 54 00 60 E6 58 00 61 E6 80 10 04 46 C0 18 05 46 4C 00 62 E6 09 FF 40 14 50 00 63 E6 30 00 A3 8F 02 00 62 30 C6 00 40 10 30 00 A3 8F 14 00 82 8E 14 00 A3 8E 18 00 A4 8F 23 10 43 00 95 01 80 14 00 2C 02 00 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 BC 01 A0 04 00 00 83 AC FF 7F 02 3C FF 7F 10 3C FF FF 42 34 FF FF 10 36 21 88 00 00 18 00 D1 03 28 00 62 AE 38 00 A2 8F 14 00 A6 8E 1C 00 50 00 12 10 00 00 40 00 A2 AF 19 00 1E 02 10 28 00 00 21 28 45 00 00 80 02 34 2A 10 A2 00 9E 00 40 10 12 20 00 00 FF 7F 02 24 97 00 A2 10 FF FF 02 3C 00 80 A2 28 4E 02 40 14 ?? ?? 02 3C 00 80 02 24 47 02 A2 10 01 00 02 3C 02 1C 04 00 00 14 05 00 ?? ?? ?? 0? 25 20 43 00 18 00 A4 8F ?? ?? ?? 0? ?? ?? 12 3C ?? ?? 46 8E ?? ?? 47 8E 21 20 40 00 21 28 60 00 ?? ?? 02 3C ?? ?? ?? 0? 3C 00 A2 AF 21 20 00 02 00 00 A2 AF ?? ?? ?? 0? 04 00 A3 AF ?? ?? 46 8E ?? ?? 47 8E 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 00 00 A6 8F 04 00 A7 8F 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 88 60 00 3C 00 A3 8F 21 80 40 00 21 20 00 02 ?? ?? 66 8C ?? ?? 67 8C ?? ?? ?? 0? 21 28 20 02 0D 02 40 18 ?? ?? 02 3C ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 42 34 1C 00 62 AE 10 00 82 8E 10 00 A4 8E ?? ?? ?? 0? 23 20 44 00 ?? ?? 46 8E ?? ?? 47 8E 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 00 00 A6 8F 04 00 A7 8F 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 88 60 00 21 28 60 00 3C 00 A3 8F 21 20 40 00 21 80 40 00 ?? ?? 66 8C ?? ?? ?? 0? ?? ?? 67 8C 84 02 40 18 ?? ?? 02 3C ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 00 00 83 AC FF 7F 02 3C FF FF 43 34 1C 00 62 8E 20 00 63 AE 38 00 A3 8F 0C 00 A6 8E 18 00 62 00 C3 1F 02 00 1C 00 7E 00 12 20 00 00 40 00 A4 AF 19 00 C2 03 40 00 A2 8F 10 28 00 00 21 28 45 00 00 80 02 34 2A 10 A2 00 0F 02 40 10 12 20 00 00 FF 7F 02 24 08 02 A2 10 FF FF 02 3C 00 80 A2 28 79 02 40 14 ?? ?? 02 3C 00 80 02 24 72 02 A2 10 01 00 02 3C 02 1C 04 00 00 14 05 00 25 20 43 00 20 00 62 8E 21 18 86 00 38 00 A4 8F 14 00 63 AE 10 00 A5 8E 18 00 82 00 C3 27 02 00 1C 00 9E 00 12 18 00 00 40 00 A3 AF 19 00 C2 03 00 80 02 34 10 38 00 00 21 38 67 00 2A 10 E2 00 FD 01 40 10 12 30 00 00 FF 7F 02 24 F6 01 E2 10 FF FF 02 3C 00 80 E2 28 65 02 40 14 ?? ?? 02 3C 00 80 02 24 5E 02 E2 10 01 00 02 3C 00 14 07 00 02 1C 06 00 25 20 43 00 21 10 85 00 18 00 62 AE 34 00 A3 8F 08 00 62 8C D0 00 40 14 34 00 A5 8F 00 00 67 8E 04 00 63 8E 2A 10 67 00 ?? ?? ?? 0? 01 00 42 38 01 00 42 34 2B 10 82 00 68 FF 40 14 00 80 A2 28 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 44 34 00 14 06 00 21 10 82 00 24 00 62 AE 30 00 A3 8F 04 00 62 30 8D 00 40 10 30 00 A4 8F 80 00 62 30 FC 01 40 14 34 00 A4 8F 14 00 A2 8E 14 00 83 8E FF 00 45 30 FF 00 66 30 00 3C 44 7C 00 3C 71 7C 00 3A 42 7C 00 3A 63 7C 20 00 A5 AF 1C 00 A6 AF 2C 00 A4 AF 28 00 A2 AF 24 00 A3 AF 2C 00 A5 8F 18 00 A6 8F 23 10 25 02 0A 01 C0 14 00 84 02 00 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 98 01 00 06 00 00 83 AC FF 7F 02 3C FF FF 42 34 24 00 A5 8F 28 00 A6 8F 38 00 62 AE 22 00 02 24 23 18 A6 00 00 1C 03 00 DA 02 60 04 00 00 82 AC FF 7F 02 3C FF FF 42 34 1C 00 A5 8F 20 00 A6 8F 3C 00 62 AE 22 00 02 24 23 18 A6 00 00 1C 03 00 95 01 60 04 00 00 82 AC FF 7F 02 3C FF FF 42 34 38 00 63 8E 40 00 62 AE 38 00 A2 8F 18 00 43 00 C3 17 03 00 1C 00 5E 00 12 20 00 00 40 00 A4 AF 40 00 A2 8F 19 00 C3 03 10 28 00 00 21 28 45 00 00 80 02 34 2A 10 A2 00 B8 01 40 10 12 20 00 00 FF 7F 02 24 B1 01 A2 10 FF FF 02 3C 00 80 A2 28 11 02 40 14 ?? ?? 02 3C 00 80 02 24 0A 02 A2 10 01 00 02 3C 02 1C 04 00 00 14 05 00 25 28 43 00 2C 00 A4 8F 3C 00 63 8E 00 14 04 00 38 00 A4 8F 21 10 A2 00 2C 00 62 AE 18 00 83 00 C3 27 03 00 1C 00 9E 00 12 10 00 00 19 00 C3 03 10 28 00 00 21 28 45 00 00 80 02 34 2A 10 A2 00 90 01 40 10 12 20 00 00 FF 7F 02 24 89 01 A2 10 FF FF 02 3C 00 80 A2 28 FD 01 40 14 ?? ?? 02 3C 00 80 02 24 F6 01 A2 10 01 00 02 3C 02 1C 04 00 00 14 05 00 25 28 43 00 28 00 A4 8F 40 00 63 8E 00 14 04 00 38 00 A4 8F 21 10 A2 00 30 00 62 AE 18 00 83 00 C3 27 03 00 1C 00 9E 00 12 10 00 00 40 00 A2 AF 19 00 C3 03 10 28 00 00 21 28 45 00 00 80 02 34 2A 10 A2 00 67 01 40 10 12 20 00 00 FF 7F 02 24 60 01 A2 10 FF FF 02 3C 00 80 A2 28 CD 01 40 14 ?? ?? 02 3C 00 80 02 24 C6 01 A2 10 01 00 02 3C 02 1C 04 00 00 14 05 00 25 20 43 00 20 00 A3 8F 00 14 03 00 21 10 82 00 34 00 62 AE 30 00 A4 8F 08 00 82 30 59 FF 40 10 34 00 A3 8F 0C 00 83 8E 0C 00 A2 8E 18 00 A5 8F D0 FE A0 14 23 80 62 00 ?? ?? 02 3C ?? ?? 45 8C 22 00 03 24 1C 01 00 06 00 00 A3 AC FF 7F 02 3C FF FF 42 34 1C 00 62 AE 10 00 82 8E 10 00 A4 8E 22 00 03 24 23 10 44 00 07 FF 41 04 00 00 A3 AC 00 80 02 3C ?? ?? ?? 0? 01 00 43 34 03 14 02 00 27 10 02 00 ?? ?? ?? 0? FF FF 44 24 03 14 02 00 ?? ?? ?? 0? 27 20 02 00 2B 10 82 00 80 FD 40 10 02 1C 04 00 ?? ?? 02 3C ?? ?? 43 8C 22 00 02 24 00 80 04 3C ?? ?? ?? 0? 00 00 62 AC ?? ?? 44 8C 22 00 03 24 ?? ?? ?? 0? 00 00 83 AC 00 00 67 8E 14 00 A4 8C 2A 10 E4 00 93 FD 40 10 34 00 A2 8F 0C 00 62 8E 23 28 87 00 08 00 63 8E 18 00 A2 00 30 00 A6 8F 00 00 64 AE 00 2C 05 00 14 00 64 26 12 10 00 00 21 18 62 00 ?? ?? ?? 0? 08 00 63 AE ?? ?? ?? 0? 00 00 67 8E 01 00 42 34 2B 10 82 00 59 FD 40 54 00 80 A2 28 ?? ?? ?? 0? ?? ?? 02 3C ?? ?? 12 3C ?? ?? ?? 0? 21 20 A0 00 ?? ?? 46 8E ?? ?? 47 8E 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 18 00 A4 8F 21 80 40 00 ?? ?? ?? 0? 21 88 60 00 ?? ?? 46 8E ?? ?? 47 8E 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 30 40 00 21 20 00 02 21 28 20 02 ?? ?? ?? 0? 21 38 60 00 21 80 40 00 ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 21 28 60 00 ?? ?? ?? 0? 21 88 60 00 9C 00 40 1C ?? ?? 02 3C ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 EA 01 43 04 21 20 00 02 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 00 00 83 AC 00 80 02 3C 00 80 10 3C 01 00 42 34 01 00 10 36 ?? ?? ?? 0? FF FF 11 24 21 28 20 02 21 30 00 00 ?? ?? ?? 0? 21 38 00 00 A5 00 42 04 ?? ?? 02 3C ?? ?? 02 3C ?? ?? 56 8C ?? ?? 57 8C ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 21 20 40 00 21 28 60 00 21 30 C0 02 ?? ?? ?? 0? 21 38 E0 02 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 80 40 00 ?? ?? ?? 0? C3 8F 02 00 18 00 A4 8F ?? ?? ?? 0? ?? ?? 12 3C ?? ?? 46 8E ?? ?? 47 8E 21 20 40 00 21 28 60 00 ?? ?? 02 3C ?? ?? ?? 0? 3C 00 A2 AF 21 20 00 02 21 B0 40 00 ?? ?? ?? 0? 21 B8 60 00 ?? ?? 46 8E ?? ?? 47 8E 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 40 00 21 28 60 00 21 30 C0 02 ?? ?? ?? 0? 21 38 E0 02 21 88 60 00 3C 00 A3 8F 21 80 40 00 21 20 00 02 ?? ?? 66 8C ?? ?? 67 8C ?? ?? ?? 0? 21 28 20 02 60 00 40 1C ?? ?? 02 3C ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 1D 01 43 04 21 20 00 02 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 00 80 02 3C 00 00 83 AC 01 00 42 34 28 00 A5 8F 24 00 A3 8F 38 00 62 AE 23 20 65 00 ?? ?? ?? 0? 00 24 04 00 ?? ?? 46 8E ?? ?? 47 8E 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 40 00 21 28 60 00 21 30 C0 02 ?? ?? ?? 0? 21 38 E0 02 21 80 40 00 21 20 40 00 3C 00 A2 8F 21 28 60 00 21 88 60 00 ?? ?? 46 8C ?? ?? ?? 0? ?? ?? 47 8C B2 00 40 18 ?? ?? 02 3C ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 42 34 20 00 A5 8F 1C 00 A3 8F 3C 00 62 AE 23 20 65 00 ?? ?? ?? 0? 00 24 04 00 ?? ?? 46 8E ?? ?? 47 8E 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 40 00 21 28 60 00 21 30 C0 02 ?? ?? ?? 0? 21 38 E0 02 21 80 40 00 21 20 40 00 3C 00 A2 8F 21 28 60 00 21 88 60 00 ?? ?? 46 8C ?? ?? ?? 0? ?? ?? 47 8C 30 00 40 18 ?? ?? 02 3C ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 ?? ?? ?? 0? 00 00 83 AC ?? ?? 44 8C 22 00 03 24 ?? ?? ?? 0? 00 00 83 AC ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 34 01 43 04 21 20 00 02 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 00 80 02 3C 00 00 83 AC ?? ?? ?? 0? 01 00 42 34 ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC ?? ?? ?? 0? FF FF 42 34 2B 10 82 00 B9 FD 40 10 02 1C 04 00 ?? ?? 02 3C ?? ?? 43 8C 22 00 02 24 00 80 04 3C ?? ?? ?? 0? 00 00 62 AC ?? ?? 56 8C ?? ?? ?? 0? ?? ?? 57 8C 00 80 02 3C ?? ?? ?? 0? 01 00 42 34 00 80 02 3C ?? ?? ?? 0? 01 00 42 34 ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 F5 00 43 04 21 20 00 02 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 00 00 83 AC 00 80 02 3C ?? ?? ?? 0? 01 00 42 34 01 00 42 34 2B 10 82 00 F7 FD 40 14 00 80 A2 28 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC ?? ?? ?? 0? }
	condition:
		$1
}

rule file_45_16_0 {
	meta:
		name = "_soft_triangle3d"
		size = 3160
		refs = "00d8 _poly_scanline_dummy 023c allegro_errno 0058 _get_scanline_filler 00bc _fill_3d_edge_structure 014c _clip_polygon_segment 01c4 __floatsidf 01cc $LC0 01d8 __muldf3 0210 __divdf3 021c $LC1 0230 __gtdf2 0240 $LC2 0250 __ltdf2 05cc $LC5 05e4 __truncdfsf2 072c .text 0804 getr_depth 0814 getg_depth 0824 getb_depth 096c $LC3 09a4 __adddf3 09b0 __fixdfsi 0bc8 $LC4"
	strings:
		$1 = { 98 FD BD 27 38 02 B0 AF 21 80 E0 00 14 00 02 8E 44 02 B3 AF 21 98 80 00 40 02 B2 AF 21 20 A0 00 21 38 C0 00 21 90 00 01 08 00 A5 27 0C 00 A6 27 21 40 60 02 54 02 B7 AF 3C 02 B1 AF 5C 02 BF AF 58 02 BE AF 50 02 B6 AF 4C 02 B5 AF 48 02 B4 AF 64 02 B4 E7 21 88 20 01 ?? ?? ?? 0? 30 02 A2 AF 9E 01 40 10 21 B8 40 00 04 00 04 8E 04 00 45 8E 2A 10 A4 00 A6 01 40 14 04 00 23 8E 21 A8 00 02 2A 10 64 00 A9 01 40 10 21 A0 40 02 21 B0 A0 02 21 18 80 00 21 A8 20 02 2A 10 65 00 04 00 40 10 08 00 A7 8F 21 10 C0 02 21 B0 80 02 21 A0 40 00 D4 00 A4 27 21 28 A0 02 21 30 C0 02 ?? ?? ?? 0? 21 40 60 02 86 01 40 10 5C 02 BF 8F 1C 00 62 8E 10 00 42 8C 04 00 40 50 ?? ?? 02 3C 09 F8 40 00 21 20 60 02 ?? ?? 02 3C ?? ?? 42 24 60 01 E2 12 70 00 A9 27 E8 00 A6 27 21 38 20 01 48 01 A8 27 00 00 C2 8C 04 00 C3 8C 08 00 C4 8C 0C 00 C5 8C 10 00 C6 24 00 00 E2 AC 04 00 E3 AC 08 00 E4 AC 0C 00 E5 AC F6 FF C8 14 10 00 E7 24 00 00 C2 8C 08 00 A6 8F 21 20 20 01 00 00 E2 AC D4 00 A2 8F 04 00 90 8E 00 14 02 00 23 80 02 02 ?? ?? ?? 0? 21 28 00 02 E0 00 A3 8F 00 80 02 34 DC 00 A6 8F 18 00 03 02 10 28 00 00 2A 10 A2 00 89 01 40 14 12 20 00 00 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 44 34 00 00 82 8E 23 10 C2 00 21 F0 44 00 36 01 C0 13 08 00 A7 8F 08 00 A2 8F E0 01 A2 AF 02 00 42 30 34 00 40 50 E0 01 A5 8F 14 00 84 8E 80 00 A2 8F ?? ?? 12 3C 00 24 04 00 ?? ?? ?? 0? 23 20 44 00 ?? ?? 46 8E ?? ?? 47 8E 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 21 20 C0 03 21 80 40 00 ?? ?? ?? 0? 21 88 60 00 ?? ?? 46 8E ?? ?? 47 8E 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 30 40 00 21 20 00 02 21 28 20 02 ?? ?? ?? 0? 21 38 60 00 21 80 40 00 ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 21 28 60 00 ?? ?? ?? 0? 21 88 60 00 69 01 40 1C ?? ?? 02 3C ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 BF 01 41 04 21 20 00 02 ?? ?? 02 3C ?? ?? 44 8C 00 80 02 3C 22 00 03 24 01 00 42 34 00 00 83 AC 20 00 A2 AF E0 01 A5 8F 04 00 A2 30 76 00 40 50 E0 01 A5 8F 80 00 A2 30 5A 01 40 54 1C 00 62 8E 14 00 82 8E FF 00 43 30 00 3C 51 7C 00 3A 42 7C E8 01 A3 AF E4 01 A2 AF ?? ?? 12 3C ?? ?? ?? 0? 21 20 C0 03 ?? ?? 46 8E ?? ?? 47 8E 21 20 40 00 21 28 60 00 ?? ?? 02 3C ?? ?? ?? 0? 34 02 A2 AF 88 00 A4 8F 08 02 A2 AF 00 14 11 00 23 20 82 00 ?? ?? ?? 0? 0C 02 A3 AF ?? ?? 46 8E ?? ?? 47 8E 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 08 02 A6 8F 0C 02 A7 8F 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 88 60 00 34 02 A3 8F 21 80 40 00 21 20 00 02 ?? ?? 66 8C ?? ?? 67 8C ?? ?? ?? 0? 21 28 20 02 79 01 40 18 ?? ?? 02 3C ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 43 34 E4 01 A5 8F 8C 00 A4 8F 30 00 A3 AF 00 14 05 00 ?? ?? ?? 0? 23 20 82 00 ?? ?? 46 8E ?? ?? 47 8E 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 08 02 A6 8F 0C 02 A7 8F 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 80 40 00 21 20 40 00 34 02 A2 8F 21 28 60 00 21 88 60 00 ?? ?? 46 8C ?? ?? ?? 0? ?? ?? 47 8C 4B 01 40 18 ?? ?? 02 3C ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC FF FF 43 34 E8 01 A5 8F 90 00 A4 8F 34 00 A3 AF 00 14 05 00 ?? ?? ?? 0? 23 20 82 00 ?? ?? 46 8E ?? ?? 47 8E 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 08 02 A6 8F 0C 02 A7 8F 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 80 40 00 21 20 40 00 34 02 A2 8F 21 28 60 00 21 88 60 00 ?? ?? 46 8C ?? ?? ?? 0? ?? ?? 47 8C 0D 01 40 18 ?? ?? 02 3C ?? ?? 02 3C ?? ?? 44 8C FF 7F 02 3C 22 00 03 24 FF FF 42 34 00 00 83 AC 38 00 A2 AF E0 01 A5 8F 08 00 A2 30 54 00 40 50 E0 01 A5 8F ?? ?? 12 3C ?? ?? ?? 0? 21 20 C0 03 ?? ?? 46 8E ?? ?? 47 8E 21 20 40 00 21 28 60 00 ?? ?? 02 3C ?? ?? ?? 0? 34 02 A2 AF 28 02 A2 AF 70 00 A4 8F 0C 00 82 8E 2C 02 A3 AF ?? ?? ?? 0? 23 20 82 00 ?? ?? 46 8E ?? ?? 47 8E 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 28 02 A6 8F 2C 02 A7 8F 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 88 60 00 34 02 A3 8F 21 80 40 00 21 20 00 02 ?? ?? 66 8C ?? ?? 67 8C ?? ?? ?? 0? 21 28 20 02 B4 00 40 1C ?? ?? 02 3C ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 44 01 43 04 21 20 00 02 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 00 80 02 3C 00 00 83 AC 01 00 42 34 14 00 A2 AF 10 00 82 8E 74 00 A4 8F ?? ?? ?? 0? 23 20 82 00 ?? ?? 46 8E ?? ?? 47 8E 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 28 02 A6 8F 2C 02 A7 8F 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 80 40 00 21 20 40 00 34 02 A2 8F 21 28 60 00 21 88 60 00 ?? ?? 46 8C ?? ?? ?? 0? ?? ?? 47 8C C6 00 40 18 ?? ?? 02 3C ?? ?? 02 3C ?? ?? 44 8C FF 7F 02 3C 22 00 03 24 FF FF 42 34 00 00 83 AC 18 00 A2 AF E0 01 A5 8F 10 00 A2 30 2C 00 40 10 ?? ?? 10 3C ?? ?? ?? 0? 21 20 C0 03 ?? ?? 04 8E ?? ?? 05 8E 21 30 40 00 ?? ?? ?? 0? 21 38 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 08 00 84 8E ?? ?? ?? 0? 06 05 00 46 ?? ?? 04 8E ?? ?? 05 8E 21 30 40 00 ?? ?? ?? 0? 21 38 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 86 00 00 46 A0 00 A0 C7 E0 01 A3 8F 01 00 02 46 20 00 62 30 02 A0 00 46 0F 00 40 10 40 00 A0 E7 10 00 80 C6 E0 00 80 46 0C 00 80 C6 C2 10 03 46 60 00 80 46 42 10 01 46 AC 00 A0 C7 A8 00 A2 C7 01 00 03 46 81 10 01 46 02 A0 00 46 82 A0 02 46 50 00 A0 E7 4C 00 A2 E7 08 00 A7 8F 58 01 B0 27 21 28 A0 02 21 20 00 02 21 30 80 02 ?? ?? ?? 0? 21 40 60 02 35 00 40 14 58 01 A5 8F 08 00 A7 8F 21 28 80 02 21 30 C0 02 21 20 00 02 ?? ?? ?? 0? 21 40 60 02 21 00 40 14 58 01 A5 8F 1C 00 62 8E 08 00 43 8C 09 F8 60 00 21 20 60 02 1C 00 62 8E 14 00 42 8C 04 00 40 10 5C 02 BF 8F 09 F8 40 00 21 20 60 02 5C 02 BF 8F 58 02 BE 8F 54 02 B7 8F 50 02 B6 8F 4C 02 B5 8F 48 02 B4 8F 44 02 B3 8F 40 02 B2 8F 3C 02 B1 8F 38 02 B0 8F 64 02 B4 C7 08 00 E0 03 68 02 BD 27 21 10 A0 00 21 28 80 00 21 20 40 00 2A 10 64 00 21 A8 40 02 59 FE 40 14 21 A0 00 02 ?? ?? ?? 0? 21 B0 20 02 5C 01 A6 8F 08 00 AA 8F 30 02 AB 8F 0C 00 A3 27 D4 00 A7 27 21 40 00 02 21 48 E0 02 21 20 60 02 ?? ?? ?? 0? 00 00 A3 AF ?? ?? ?? 0? 1C 00 62 8E 5C 01 A6 8F 08 00 AA 8F 30 02 AB 8F 0C 00 A2 27 21 20 60 02 D4 00 A7 27 21 40 00 02 21 48 E0 02 ?? ?? ?? 0? 00 00 A2 AF ?? ?? ?? 0? 08 00 A7 8F FF 7F 02 24 2F 00 A2 10 FF FF 02 3C 00 80 A2 28 27 00 40 14 ?? ?? 02 3C 00 80 02 24 20 00 A2 10 01 00 02 3C 02 1C 04 00 00 14 05 00 ?? ?? ?? 0? 25 20 43 00 ?? ?? 44 8C 22 00 03 24 FF 7F 02 3C 00 00 83 AC ?? ?? ?? 0? FF FF 42 34 ?? ?? 44 8C FF 7F 02 3C 22 00 03 24 FF FF 42 34 00 00 83 AC ?? ?? ?? 0? 20 00 A2 AF 14 00 85 8E 00 00 50 8C ?? ?? ?? 0? 21 20 00 02 14 00 85 8E 21 20 00 02 ?? ?? ?? 0? 21 88 40 00 14 00 85 8E 21 20 00 02 ?? ?? ?? 0? E4 01 A2 AF ?? ?? ?? 0? E8 01 A2 AF 2B 10 82 00 E0 FF 40 10 02 1C 04 00 ?? ?? 02 3C ?? ?? 43 8C 22 00 02 24 00 80 04 3C ?? ?? ?? 0? 00 00 62 AC 01 00 42 34 2B 10 82 00 D0 FF 40 54 00 80 A2 28 ?? ?? ?? 0? ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 9C 00 41 04 21 20 00 02 ?? ?? 02 3C ?? ?? 44 8C 00 80 02 3C 22 00 03 24 01 00 42 34 00 00 83 AC ?? ?? ?? 0? 38 00 A2 AF ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 73 00 41 04 21 20 00 02 ?? ?? 02 3C ?? ?? 44 8C 00 80 02 3C 22 00 03 24 01 00 42 34 00 00 83 AC ?? ?? ?? 0? 18 00 A2 AF ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 98 00 43 04 21 20 00 02 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 00 80 02 3C 00 00 83 AC ?? ?? ?? 0? 01 00 43 34 ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 22 00 43 04 21 20 00 02 ?? ?? 02 3C ?? ?? 44 8C 22 00 03 24 00 80 02 3C 00 00 83 AC ?? ?? ?? 0? 01 00 43 34 21 28 20 02 21 30 00 00 ?? ?? ?? 0? 21 38 00 00 97 00 40 04 ?? ?? 02 3C ?? ?? 44 8C ?? ?? 45 8C F0 01 A4 AF F4 01 A5 AF ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 F0 01 A6 8F F4 01 A7 8F 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 ?? ?? ?? 0? 20 00 A2 AF 21 28 20 02 21 30 00 00 ?? ?? ?? 0? 21 38 00 00 89 00 40 04 ?? ?? 02 3C ?? ?? 44 8C ?? ?? 45 8C F8 01 A4 AF FC 01 A5 AF ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 F8 01 A6 8F FC 01 A7 8F 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 ?? ?? ?? 0? 21 18 40 00 21 28 20 02 21 30 00 00 ?? ?? ?? 0? 21 38 00 00 7B 00 40 04 ?? ?? 02 3C ?? ?? 44 8C ?? ?? 45 8C 18 02 A4 AF 1C 02 A5 AF ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 18 02 A6 8F 1C 02 A7 8F 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 ?? ?? ?? 0? 14 00 A2 AF 21 28 20 02 21 30 00 00 ?? ?? ?? 0? 21 38 00 00 5B 00 40 04 ?? ?? 02 3C ?? ?? 44 8C ?? ?? 45 8C 20 02 A4 AF 24 02 A5 AF ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 20 02 A6 8F 24 02 A7 8F 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 ?? ?? ?? 0? 18 00 A2 AF 21 28 20 02 21 30 00 00 ?? ?? ?? 0? 21 38 00 00 4D 00 40 04 ?? ?? 02 3C ?? ?? 44 8C ?? ?? 45 8C 10 02 A4 AF 14 02 A5 AF ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 10 02 A6 8F 14 02 A7 8F 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 ?? ?? ?? 0? 38 00 A2 AF 21 28 20 02 21 30 00 00 ?? ?? ?? 0? 21 38 00 00 1B 00 40 04 ?? ?? 02 3C ?? ?? 44 8C ?? ?? 45 8C 00 02 A4 AF 04 02 A5 AF ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 00 02 A6 8F 04 02 A7 8F 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 ?? ?? ?? 0? 21 18 40 00 ?? ?? 02 3C ?? ?? 44 8C ?? ?? 45 8C F0 01 A4 AF ?? ?? ?? 0? F4 01 A5 AF ?? ?? 02 3C ?? ?? 44 8C ?? ?? 45 8C 00 02 A4 AF ?? ?? ?? 0? 04 02 A5 AF ?? ?? 02 3C ?? ?? 44 8C ?? ?? 45 8C F8 01 A4 AF ?? ?? ?? 0? FC 01 A5 AF ?? ?? 02 3C ?? ?? 44 8C ?? ?? 45 8C 20 02 A4 AF ?? ?? ?? 0? 24 02 A5 AF ?? ?? 02 3C ?? ?? 44 8C ?? ?? 45 8C 18 02 A4 AF ?? ?? ?? 0? 1C 02 A5 AF ?? ?? 02 3C ?? ?? 44 8C ?? ?? 45 8C 10 02 A4 AF ?? ?? ?? 0? 14 02 A5 AF }
	condition:
		$1
}

rule file_45_17_0 {
	meta:
		name = "_soft_polygon3d_f"
		size = 524
		refs = "0080 _get_scanline_filler 0098 _scratch_mem_size 00ac _scratch_mem 00e8 .text 0124 _fill_3d_edge_structure_f 01f8 _al_realloc"
	strings:
		$1 = { 60 FF BD 27 03 00 E2 28 98 00 BE AF 70 00 A4 AF 9C 00 BF AF 94 00 B7 AF 90 00 B6 AF 8C 00 B5 AF 88 00 B4 AF 84 00 B3 AF 80 00 B2 AF 7C 00 B1 AF 78 00 B0 AF 21 F0 E0 00 21 20 A0 00 0D 00 40 10 74 00 A8 AF 9C 00 BF 8F 98 00 BE 8F 94 00 B7 8F 90 00 B6 8F 8C 00 B5 8F 88 00 B4 8F 84 00 B3 8F 80 00 B2 8F 7C 00 B1 8F 78 00 B0 8F 08 00 E0 03 A0 00 BD 27 70 00 A8 8F 21 38 C0 00 21 28 A0 03 ?? ?? ?? 0? 04 00 A6 27 EE FF 40 10 6C 00 A2 AF 84 00 02 24 18 00 C2 03 ?? ?? 12 3C ?? ?? 42 8E 12 80 00 00 2A 10 50 00 4F 00 40 14 ?? ?? 11 3C ?? ?? 31 8E 74 00 A3 8F FF FF C2 27 68 00 B1 AF 68 00 B0 8F 80 10 02 00 21 10 62 00 FF 7F 03 3C 00 00 46 8C FF FF 71 34 74 00 B3 8F 21 B8 00 02 21 90 00 00 00 80 16 3C ?? ?? ?? 0? 21 A0 00 00 21 28 20 02 21 20 00 02 2A 10 5E 02 21 88 A0 00 21 30 A0 02 21 80 80 00 1C 00 40 10 04 00 73 26 00 00 75 8E 00 00 A7 8F 70 00 A8 8F 21 28 C0 00 21 20 00 02 ?? ?? ?? 0? 21 30 A0 02 F0 FF 40 50 01 00 52 26 00 00 05 8E 04 00 03 8E 84 00 04 26 2A 10 B1 00 0A 28 22 02 0B B8 02 02 03 00 80 12 2C B0 C3 02 78 00 14 AE 7C 00 90 AE 01 00 52 26 2A 10 5E 02 21 A0 00 02 21 88 A0 00 21 30 A0 02 21 80 80 00 E6 FF 40 14 04 00 73 26 B1 FF 80 12 74 00 A2 8F 00 00 A9 8F 6C 00 A8 8F 00 00 43 8C 7C FF 82 24 70 00 A4 8F 14 00 6A 8C 68 00 A3 8F 21 30 C0 02 21 38 E0 02 04 00 AB 27 7C 00 43 AC ?? ?? ?? 0? 78 00 62 AC 9C 00 BF 8F 98 00 BE 8F 94 00 B7 8F 90 00 B6 8F 8C 00 B5 8F 88 00 B4 8F 84 00 B3 8F 80 00 B2 8F 7C 00 B1 8F 78 00 B0 8F 08 00 E0 03 A0 00 BD 27 00 FC 02 24 FF 03 10 26 ?? ?? 24 8E 24 80 02 02 ?? ?? ?? 0? 21 28 00 02 ?? ?? 22 AE ?? ?? ?? 0? ?? ?? 50 AE }
	condition:
		$1
}

rule file_45_18_0 {
	meta:
		name = "_soft_polygon3d"
		size = 524
		refs = "0080 _get_scanline_filler 0098 _scratch_mem_size 00ac _scratch_mem 00e8 .text 0124 _fill_3d_edge_structure 01f8 _al_realloc"
	strings:
		$1 = { 60 FF BD 27 03 00 E2 28 98 00 BE AF 70 00 A4 AF 9C 00 BF AF 94 00 B7 AF 90 00 B6 AF 8C 00 B5 AF 88 00 B4 AF 84 00 B3 AF 80 00 B2 AF 7C 00 B1 AF 78 00 B0 AF 21 F0 E0 00 21 20 A0 00 0D 00 40 10 74 00 A8 AF 9C 00 BF 8F 98 00 BE 8F 94 00 B7 8F 90 00 B6 8F 8C 00 B5 8F 88 00 B4 8F 84 00 B3 8F 80 00 B2 8F 7C 00 B1 8F 78 00 B0 8F 08 00 E0 03 A0 00 BD 27 70 00 A8 8F 21 38 C0 00 21 28 A0 03 ?? ?? ?? 0? 04 00 A6 27 EE FF 40 10 6C 00 A2 AF 84 00 02 24 18 00 C2 03 ?? ?? 12 3C ?? ?? 42 8E 12 80 00 00 2A 10 50 00 4F 00 40 14 ?? ?? 11 3C ?? ?? 31 8E 74 00 A3 8F FF FF C2 27 68 00 B1 AF 68 00 B0 8F 80 10 02 00 21 10 62 00 FF 7F 03 3C 00 00 46 8C FF FF 71 34 74 00 B3 8F 21 B8 00 02 21 90 00 00 00 80 16 3C ?? ?? ?? 0? 21 A0 00 00 21 28 20 02 21 20 00 02 2A 10 5E 02 21 88 A0 00 21 30 A0 02 21 80 80 00 1C 00 40 10 04 00 73 26 00 00 75 8E 00 00 A7 8F 70 00 A8 8F 21 28 C0 00 21 20 00 02 ?? ?? ?? 0? 21 30 A0 02 F0 FF 40 50 01 00 52 26 00 00 05 8E 04 00 03 8E 84 00 04 26 2A 10 B1 00 0A 28 22 02 0B B8 02 02 03 00 80 12 2C B0 C3 02 78 00 14 AE 7C 00 90 AE 01 00 52 26 2A 10 5E 02 21 A0 00 02 21 88 A0 00 21 30 A0 02 21 80 80 00 E6 FF 40 14 04 00 73 26 B1 FF 80 12 74 00 A2 8F 00 00 A9 8F 6C 00 A8 8F 00 00 43 8C 7C FF 82 24 70 00 A4 8F 14 00 6A 8C 68 00 A3 8F 21 30 C0 02 21 38 E0 02 04 00 AB 27 7C 00 43 AC ?? ?? ?? 0? 78 00 62 AC 9C 00 BF 8F 98 00 BE 8F 94 00 B7 8F 90 00 B6 8F 8C 00 B5 8F 88 00 B4 8F 84 00 B3 8F 80 00 B2 8F 7C 00 B1 8F 78 00 B0 8F 08 00 E0 03 A0 00 BD 27 00 FC 02 24 FF 03 10 26 ?? ?? 24 8E 24 80 02 02 ?? ?? ?? 0? 21 28 00 02 ?? ?? 22 AE ?? ?? ?? 0? ?? ?? 50 AE }
	condition:
		$1
}

rule file_46_1_0 {
	meta:
		name = "digi_psp_exit"
		size = 68
		refs = "0018 .bss 0024 sceKernelDeleteThread 0030 sceAudioChRelease 003c _mixer_exit"
	strings:
		$1 = { F8 FF BD 27 04 00 80 10 04 00 BF AF 04 00 BF 8F 08 00 E0 03 08 00 BD 27 ?? ?? 02 3C ?? ?? 44 8C ?? ?? 03 3C ?? ?? ?? 0? ?? ?? 60 AC ?? ?? 03 3C ?? ?? ?? 0? ?? ?? 64 8C 04 00 BF 8F ?? ?? ?? 0? 08 00 BD 27 }
	condition:
		$1
}

rule file_46_2_0 {
	meta:
		name = "digi_psp_detect"
		size = 76
		refs = "0020 get_config_text 001c $LC0 0028 allegro_error 0034 ustrzcpy"
	strings:
		$1 = { F8 FF BD 27 05 00 80 14 04 00 BF AF 04 00 BF 8F FF FF 02 24 08 00 E0 03 08 00 BD 27 ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 84 24 ?? ?? 04 3C ?? ?? 84 24 21 30 40 00 ?? ?? ?? 0? 00 01 05 24 04 00 BF 8F 21 10 00 00 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_46_3_0 {
	meta:
		name = "digi_psp_init"
		size = 544
		refs = "0000 .rodata 003c memset 0050 sceAudioChReserve 0058 .bss 0064 $LC3 0068 .text 008c sceKernelCreateThread 00a8 sceKernelStartThread 00b8 digi_psp 00c4 _sound_bits 00ec _sound_stereo 00f0 _sound_freq 00f4 _mixer_init 0108 get_config_text 0104 $LC7 0124 $LC8 0140 uconvert 0160 uszprintf 0194 $LC9 01a0 $LC0 01b0 allegro_error 01bc ustrzcpy 01cc $LC5 0100 $LC6 0208 $LC2 0214 $LC4"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 43 8C E0 FC BD 27 14 03 B4 AF 04 03 B0 AF 21 A0 A0 00 21 80 80 00 21 28 00 00 04 01 A4 27 FC 01 06 24 1C 03 BF AF 18 03 B5 AF 10 03 B3 AF 0C 03 B2 AF 08 03 B1 AF ?? ?? ?? 0? 00 01 A3 AF 56 00 00 16 FF FF 04 24 00 04 05 24 ?? ?? ?? 0? 21 30 00 00 ?? ?? 03 3C 6A 00 40 04 ?? ?? 62 AC ?? ?? 04 3C ?? ?? 05 3C ?? ?? 84 24 ?? ?? 02 3C ?? ?? A5 24 FF FF 13 24 19 00 06 24 01 00 07 3C 21 40 00 00 21 48 00 00 ?? ?? ?? 0? ?? ?? 53 AC 21 20 40 00 ?? ?? 02 3C 5D 00 80 04 ?? ?? 44 AC 21 28 00 00 ?? ?? ?? 0? 21 30 00 00 46 00 40 14 ?? ?? 08 3C ?? ?? 02 3C ?? ?? 55 24 10 00 02 24 ?? ?? 11 3C ?? ?? 10 3C ?? ?? 12 3C ?? ?? 22 AE ?? ?? 08 25 44 AC 02 34 00 08 04 24 44 AC 05 34 FF FF 06 24 01 00 07 24 ?? ?? 13 AE ?? ?? 42 AE ?? ?? ?? 0? 10 00 B4 AE 40 00 40 54 ?? ?? 04 3C ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 84 24 21 98 40 00 ?? ?? 02 8E ?? ?? 31 8E 1D 00 40 14 ?? ?? 52 8E ?? ?? 02 3C ?? ?? 44 24 53 41 05 3C 75 63 07 3C 38 43 A5 34 2E 72 E7 34 21 30 A0 03 ?? ?? ?? 0? 00 01 08 24 00 01 B0 27 21 30 60 02 21 38 20 02 21 40 40 02 21 48 40 00 21 20 00 02 ?? ?? ?? 0? 00 02 05 24 08 00 B0 AE 21 10 00 00 1C 03 BF 8F 18 03 B5 8F 14 03 B4 8F 10 03 B3 8F 0C 03 B2 8F 08 03 B1 8F 04 03 B0 8F 08 00 E0 03 20 03 BD 27 ?? ?? 02 3C ?? ?? ?? 0? ?? ?? 44 24 ?? ?? 04 3C ?? ?? 84 24 ?? ?? ?? 0? 00 00 00 00 ?? ?? 04 3C ?? ?? 84 24 21 30 40 00 ?? ?? ?? 0? 00 01 05 24 ?? ?? ?? 0? FF FF 02 24 ?? ?? 04 3C ?? ?? 84 24 ?? ?? ?? 0? 00 00 00 00 ?? ?? 04 3C ?? ?? 84 24 21 30 40 00 ?? ?? ?? 0? 00 01 05 24 ?? ?? ?? 0? 21 20 00 00 ?? ?? ?? 0? FF FF 02 24 ?? ?? ?? 0? ?? ?? 84 24 ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 84 24 ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 84 24 }
	condition:
		$1
}

rule file_46_4_0 {
	meta:
		name = "psp_audio_channel_thread"
		size = 168
		refs = "0008 .bss 0030 curr_buffer 004c _mix_some_samples 0060 sceAudioOutputPannedBlocking 007c sceKernelExitThread"
	strings:
		$1 = { E8 FF BD 27 10 00 B4 AF ?? ?? 14 3C ?? ?? 82 8E 14 00 BF AF 0C 00 B3 AF 08 00 B2 AF 04 00 B1 AF 16 00 40 10 00 00 B0 AF ?? ?? 02 3C ?? ?? 53 24 ?? ?? 11 3C ?? ?? 12 3C ?? ?? 30 8E 21 28 00 00 FF FF 06 24 00 83 10 00 21 80 70 02 ?? ?? ?? 0? 21 20 00 02 ?? ?? 44 8E 21 38 00 02 00 80 05 34 ?? ?? ?? 0? 00 80 06 34 ?? ?? 23 8E ?? ?? 82 8E 01 00 63 2C F0 FF 40 14 ?? ?? 23 AE ?? ?? ?? 0? 21 20 00 00 14 00 BF 8F 21 10 00 00 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_47_0_0 {
	meta:
		name = "_poly_zbuf_flat32"
		size = 80
		refs = "0010 .text"
	strings:
		$1 = { 30 00 C1 C4 10 00 C7 8C 0F 00 A0 18 5C 00 C2 8C ?? ?? ?? 0? 21 18 00 00 40 08 00 46 00 00 40 C4 3C 00 01 46 00 00 00 00 03 00 00 45 01 00 63 24 00 00 41 E4 00 00 87 AC 04 00 42 24 04 00 84 24 F5 FF 65 14 34 00 C0 C4 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_47_1_0 {
	meta:
		name = "_poly_zbuf_grgb32"
		size = 212
		refs = "0050 .text 0048 _rgb_g_shift_32 004c _rgb_r_shift_32 0054 _rgb_b_shift_32"
	strings:
		$1 = { F0 FF BD 27 00 00 B0 AF 21 80 A0 00 0C 00 B3 AF 08 00 B2 AF 04 00 B1 AF 18 00 CC 8C 1C 00 CB 8C 20 00 CA 8C 24 00 C5 8C 28 00 D9 8C 2C 00 D8 8C 30 00 C1 C4 21 00 00 1A 5C 00 C2 8C 21 48 80 00 21 38 40 00 21 40 00 00 ?? ?? 13 3C ?? ?? 12 3C ?? ?? ?? 0? ?? ?? 11 3C 40 08 00 46 00 00 E0 C4 03 6C 0B 00 03 74 0C 00 3C 00 01 46 03 7C 0A 00 01 00 08 25 21 60 85 01 21 58 79 01 0B 00 00 45 21 50 58 01 ?? ?? 62 8E ?? ?? 43 8E ?? ?? 24 8E 04 10 4D 00 04 18 6E 00 25 10 43 00 04 20 8F 00 25 10 44 00 00 00 22 AD 00 00 E1 E4 04 00 E7 24 04 00 29 25 E8 FF 10 15 34 00 C0 C4 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 10 00 BD 27 }
	condition:
		$1
}

rule file_47_2_0 {
	meta:
		name = "_poly_zbuf_atex32"
		size = 164
		refs = "0040 .text"
	strings:
		$1 = { 21 58 C0 00 54 00 C2 8C 50 00 C6 8C 10 00 03 24 23 C0 62 00 04 30 46 00 4C 00 6F 8D 00 00 6A 8D 04 00 69 8D 08 00 6E 8D 0C 00 6D 8D 48 00 6C 8D 30 00 61 C5 19 00 A0 18 5C 00 62 8D 21 38 40 00 ?? ?? ?? 0? 21 40 00 00 40 08 00 46 00 00 E0 C4 03 14 0A 00 07 18 09 03 24 10 4F 00 24 18 66 00 3C 00 01 46 21 10 43 00 80 10 02 00 21 10 82 01 01 00 08 25 21 50 4E 01 04 00 00 45 21 48 2D 01 00 00 42 8C 00 00 E1 E4 00 00 82 AC 04 00 E7 24 04 00 84 24 EC FF 05 15 34 00 60 C5 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_47_3_0 {
	meta:
		name = "_poly_zbuf_atex_mask32"
		size = 180
		refs = "0048 .text"
	strings:
		$1 = { 21 58 C0 00 54 00 C2 8C 50 00 C6 8C 10 00 03 24 23 C0 62 00 04 30 46 00 4C 00 6F 8D 00 00 6A 8D 04 00 69 8D 08 00 6E 8D 0C 00 6D 8D 48 00 6C 8D 30 00 61 C5 1D 00 A0 18 5C 00 62 8D 21 38 40 00 FF 00 02 3C FF 00 59 34 ?? ?? ?? 0? 21 40 00 00 40 08 00 46 00 00 E0 C4 03 14 0A 00 07 18 09 03 24 10 4F 00 24 18 66 00 3C 00 01 46 21 10 43 00 80 10 02 00 21 10 82 01 01 00 08 25 21 50 4E 01 06 00 00 45 21 48 2D 01 00 00 42 8C 04 00 59 50 04 00 E7 24 00 00 82 AC 00 00 E1 E4 04 00 E7 24 04 00 84 24 EA FF 05 15 34 00 60 C5 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_47_4_0 {
	meta:
		name = "_poly_zbuf_atex_lit32"
		size = 392
		refs = "0014 _blender_func32 00a0 .text 0120 _blender_col_32"
	strings:
		$1 = { 54 00 C3 8C 10 00 02 24 B0 FF BD 27 23 10 43 00 10 00 A2 AF ?? ?? 02 3C ?? ?? 42 8C 2C 00 B3 AF 21 98 C0 00 00 00 A2 AF 50 00 C6 8C 4C 00 62 8E 40 00 BE AF 04 30 66 00 0C 00 A2 AF 08 00 63 8E 48 00 62 8E 3C 00 B7 AF 38 00 B6 AF 34 00 B5 AF 30 00 B4 AF 4C 00 B4 E7 04 00 A2 AF 44 00 BF AF 28 00 B2 AF 24 00 B1 AF 20 00 B0 AF 18 00 A5 AF 14 00 A6 AF 00 00 76 8E 04 00 75 8E 10 00 74 8E 08 00 A3 AF 0C 00 7E 8E 14 00 77 8E 30 00 74 C6 30 00 A0 18 5C 00 62 8E 21 90 80 00 21 80 40 00 ?? ?? ?? 0? 21 88 00 00 08 00 A4 8F 18 00 A2 8F 21 A8 BE 02 21 B0 C4 02 21 A0 97 02 04 00 10 26 04 00 52 26 23 00 22 12 34 00 60 C6 00 A5 00 46 00 00 00 C6 3C 00 14 46 00 00 00 00 F2 FF 00 45 01 00 31 26 10 00 A4 8F 03 14 16 00 03 34 14 00 07 18 95 00 0C 00 A4 8F 21 A8 BE 02 21 A0 97 02 24 10 44 00 14 00 A4 8F 24 18 64 00 21 10 43 00 04 00 A3 8F 80 10 02 00 21 10 62 00 00 00 44 8C ?? ?? 02 3C 00 00 A3 8F 09 F8 60 00 ?? ?? 45 8C 00 00 42 AE 08 00 A4 8F 18 00 A2 8F 00 00 14 E6 21 B0 C4 02 04 00 10 26 04 00 52 26 DF FF 22 16 34 00 60 C6 44 00 BF 8F 40 00 BE 8F 3C 00 B7 8F 38 00 B6 8F 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 4C 00 B4 C7 08 00 E0 03 50 00 BD 27 }
	condition:
		$1
}

rule file_47_5_0 {
	meta:
		name = "_poly_zbuf_atex_mask_lit32"
		size = 372
		refs = "0010 _blender_func32 008c .text 00e4 _blender_col_32"
	strings:
		$1 = { 54 00 C3 8C 10 00 02 24 B0 FF BD 27 23 60 43 00 ?? ?? 02 3C ?? ?? 42 8C 34 00 B5 AF 21 A8 C0 00 50 00 C6 8C 40 00 BE AF 3C 00 B7 AF 38 00 B6 AF 2C 00 B3 AF 28 00 B2 AF 4C 00 B4 E7 00 00 A2 AF 44 00 BF AF 30 00 B4 AF 24 00 B1 AF 20 00 B0 AF 21 58 A0 00 04 50 66 00 4C 00 A9 8E 00 00 B3 8E 04 00 B2 8E 10 00 B6 8E 08 00 A8 8E 0C 00 A7 8E 14 00 BE 8E 48 00 B7 8E 30 00 B4 C6 30 00 A0 18 5C 00 A2 8E 21 A0 80 00 21 80 40 00 ?? ?? ?? 0? 21 88 00 00 00 A5 00 46 00 00 00 C6 03 14 13 00 07 18 92 01 24 10 49 00 24 18 6A 00 3C 00 14 46 21 10 43 00 80 10 02 00 21 10 E2 02 01 00 31 26 21 98 68 02 19 00 00 45 21 90 47 02 00 00 42 8C FF 00 03 3C FF 00 63 34 03 34 16 00 13 00 43 10 21 20 40 00 ?? ?? 02 3C ?? ?? 45 8C 00 00 A3 8F 04 00 A7 AF 08 00 A8 AF 0C 00 A9 AF 10 00 AA AF 14 00 AB AF 09 F8 60 00 18 00 AC AF 18 00 AC 8F 14 00 AB 8F 10 00 AA 8F 0C 00 A9 8F 08 00 A8 8F 04 00 A7 8F 00 00 82 AE 00 00 14 E6 21 B0 DE 02 04 00 10 26 04 00 94 26 D6 FF 2B 16 34 00 A0 C6 44 00 BF 8F 40 00 BE 8F 3C 00 B7 8F 38 00 B6 8F 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 4C 00 B4 C7 08 00 E0 03 50 00 BD 27 }
	condition:
		$1
}

rule file_47_6_0 {
	meta:
		name = "_poly_zbuf_ptex32"
		size = 592
		refs = "0060 __extendsfdf2 00ec .text 00f4 __adddf3 0154 __ltdf2 0170 __divdf3 017c __fixdfsi 01e0 __truncdfsf2"
	strings:
		$1 = { 98 FF BD 27 54 00 C3 8C 40 00 CC C4 30 00 B0 AF 21 80 C0 00 50 00 C6 8C 10 00 02 24 23 10 43 00 04 30 66 00 54 00 BF AF 2C 00 A5 AF 28 00 A6 AF 38 00 B2 AF 34 00 B1 AF 21 90 80 00 64 00 B6 E7 60 00 B5 E7 5C 00 B4 E7 50 00 BE AF 4C 00 B7 AF 48 00 B6 AF 44 00 B5 AF 40 00 B4 AF 3C 00 B3 AF ?? ?? ?? 0? 24 00 A2 AF 18 00 A2 AF 44 00 0C C6 4C 00 02 8E 1C 00 A3 AF 38 00 15 C6 ?? ?? ?? 0? 20 00 A2 AF 34 00 0C C6 10 00 A2 AF ?? ?? ?? 0? 14 00 A3 AF 3C 00 14 C6 30 00 16 C6 0C 00 A3 AF 5C 00 11 8E 2C 00 A3 8F 48 00 10 8E 08 00 A2 AF 58 00 60 18 04 00 B0 AF 06 AB 00 46 ?? ?? ?? 0? 00 00 B2 AF 06 A3 00 46 21 A0 40 00 ?? ?? ?? 0? 21 A8 60 00 06 B3 00 46 21 B0 40 00 ?? ?? ?? 0? 21 B8 60 00 21 F0 00 00 21 90 40 00 ?? ?? ?? 0? 21 98 60 00 ?? ?? ?? 0? 00 00 00 00 10 00 A6 8F 14 00 A7 8F 21 20 C0 02 21 28 E0 02 21 A0 40 00 ?? ?? ?? 0? 21 A8 60 00 08 00 A6 8F 0C 00 A7 8F 21 20 40 02 21 28 60 02 21 B0 40 00 ?? ?? ?? 0? 21 B8 60 00 21 90 40 00 21 98 60 00 00 00 2C C6 ?? ?? ?? 0? 01 00 DE 27 21 20 40 00 21 28 60 00 21 30 40 02 ?? ?? ?? 0? 21 38 60 02 21 30 40 02 21 38 60 02 21 20 80 02 20 00 41 04 21 28 A0 02 ?? ?? ?? 0? 00 00 00 00 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 03 84 02 00 20 00 A2 8F 21 30 40 02 21 38 60 02 21 20 C0 02 21 28 E0 02 ?? ?? ?? 0? 24 80 02 02 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 24 00 A3 8F 21 20 40 02 21 28 60 02 07 10 62 00 28 00 A3 8F 24 10 43 00 21 80 02 02 04 00 A2 8F 80 80 10 00 00 00 A3 8F 21 80 50 00 00 00 02 8E ?? ?? ?? 0? 00 00 62 AC 00 00 20 E6 00 00 A2 8F 2C 00 A3 8F 21 20 80 02 04 00 42 24 21 28 A0 02 18 00 A6 8F 1C 00 A7 8F 04 00 31 26 B9 FF C3 17 00 00 A2 AF 54 00 BF 8F 50 00 BE 8F 4C 00 B7 8F 48 00 B6 8F 44 00 B5 8F 40 00 B4 8F 3C 00 B3 8F 38 00 B2 8F 34 00 B1 8F 30 00 B0 8F 64 00 B6 C7 60 00 B5 C7 5C 00 B4 C7 08 00 E0 03 68 00 BD 27 }
	condition:
		$1
}

rule file_47_7_0 {
	meta:
		name = "_poly_zbuf_ptex_mask32"
		size = 604
		refs = "0060 __extendsfdf2 00ec .text 00f4 __adddf3 0154 __ltdf2 0170 __divdf3 017c __fixdfsi 01ec __truncdfsf2"
	strings:
		$1 = { 98 FF BD 27 54 00 C3 8C 40 00 CC C4 30 00 B0 AF 21 80 C0 00 50 00 C6 8C 10 00 02 24 23 10 43 00 04 30 66 00 54 00 BF AF 2C 00 A5 AF 28 00 A6 AF 38 00 B2 AF 34 00 B1 AF 21 90 80 00 64 00 B6 E7 60 00 B5 E7 5C 00 B4 E7 50 00 BE AF 4C 00 B7 AF 48 00 B6 AF 44 00 B5 AF 40 00 B4 AF 3C 00 B3 AF ?? ?? ?? 0? 24 00 A2 AF 18 00 A2 AF 44 00 0C C6 4C 00 02 8E 1C 00 A3 AF 38 00 15 C6 ?? ?? ?? 0? 20 00 A2 AF 34 00 0C C6 10 00 A2 AF ?? ?? ?? 0? 14 00 A3 AF 3C 00 14 C6 30 00 16 C6 0C 00 A3 AF 5C 00 11 8E 2C 00 A3 8F 48 00 10 8E 08 00 A2 AF 5B 00 60 18 04 00 B0 AF 06 AB 00 46 ?? ?? ?? 0? 00 00 B2 AF 06 A3 00 46 21 A0 40 00 ?? ?? ?? 0? 21 A8 60 00 06 B3 00 46 21 B0 40 00 ?? ?? ?? 0? 21 B8 60 00 21 F0 00 00 21 90 40 00 ?? ?? ?? 0? 21 98 60 00 ?? ?? ?? 0? 00 00 00 00 10 00 A6 8F 14 00 A7 8F 21 20 C0 02 21 28 E0 02 21 A0 40 00 ?? ?? ?? 0? 21 A8 60 00 08 00 A6 8F 0C 00 A7 8F 21 20 40 02 21 28 60 02 21 B0 40 00 ?? ?? ?? 0? 21 B8 60 00 21 90 40 00 21 98 60 00 00 00 2C C6 ?? ?? ?? 0? 01 00 DE 27 21 20 40 00 21 28 60 00 21 30 40 02 ?? ?? ?? 0? 21 38 60 02 21 30 40 02 21 38 60 02 21 20 80 02 23 00 41 04 21 28 A0 02 ?? ?? ?? 0? 00 00 00 00 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 03 84 02 00 20 00 A2 8F 21 30 40 02 21 38 60 02 21 20 C0 02 21 28 E0 02 ?? ?? ?? 0? 24 80 02 02 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 24 00 A3 8F 21 20 40 02 07 10 62 00 28 00 A3 8F 24 10 43 00 21 80 02 02 04 00 A2 8F 80 80 10 00 FF 00 03 3C 21 80 50 00 00 00 10 8E FF 00 63 34 05 00 03 12 21 28 60 02 00 00 A2 8F ?? ?? ?? 0? 00 00 50 AC 00 00 20 E6 00 00 A3 8F 2C 00 A2 8F 21 20 80 02 04 00 63 24 21 28 A0 02 18 00 A6 8F 1C 00 A7 8F 04 00 31 26 B6 FF C2 17 00 00 A3 AF 54 00 BF 8F 50 00 BE 8F 4C 00 B7 8F 48 00 B6 8F 44 00 B5 8F 40 00 B4 8F 3C 00 B3 8F 38 00 B2 8F 34 00 B1 8F 30 00 B0 8F 64 00 B6 C7 60 00 B5 C7 5C 00 B4 C7 08 00 E0 03 68 00 BD 27 }
	condition:
		$1
}

rule file_47_8_0 {
	meta:
		name = "_poly_zbuf_ptex_lit32"
		size = 712
		refs = "0060 __extendsfdf2 00a8 _blender_func32 0108 .text 0144 __adddf3 01a4 __ltdf2 01c0 __divdf3 01cc __fixdfsi 021c _blender_col_32 0248 __truncdfsf2"
	strings:
		$1 = { 88 FF BD 27 54 00 C3 8C 40 00 CC C4 40 00 B0 AF 21 80 C0 00 50 00 C6 8C 10 00 02 24 23 10 43 00 04 30 66 00 64 00 BF AF 3C 00 A5 AF 38 00 A6 AF 48 00 B2 AF 44 00 B1 AF 21 90 80 00 74 00 B6 E7 70 00 B5 E7 6C 00 B4 E7 60 00 BE AF 5C 00 B7 AF 58 00 B6 AF 54 00 B5 AF 50 00 B4 AF 4C 00 B3 AF ?? ?? ?? 0? 34 00 A2 AF 20 00 A2 AF 44 00 0C C6 4C 00 02 8E 24 00 A3 AF 10 00 03 8E 30 00 A2 AF ?? ?? ?? 0? 2C 00 A3 AF 18 00 A2 AF 34 00 0C C6 14 00 02 8E 1C 00 A3 AF 38 00 15 C6 ?? ?? ?? 0? 28 00 A2 AF 10 00 A2 AF ?? ?? 02 3C 14 00 A3 AF ?? ?? 42 8C 5C 00 11 8E 3C 00 14 C6 30 00 16 C6 3C 00 A3 8F 48 00 10 8E 08 00 A2 AF 6F 00 60 18 04 00 B0 AF 06 AB 00 46 ?? ?? ?? 0? 00 00 B2 AF 06 A3 00 46 21 A0 40 00 ?? ?? ?? 0? 21 A8 60 00 06 B3 00 46 21 B0 40 00 ?? ?? ?? 0? 21 B8 60 00 21 F0 00 00 21 90 40 00 ?? ?? ?? 0? 21 98 60 00 28 00 A3 8F 21 20 80 02 21 28 A0 02 21 10 43 00 2C 00 A2 AF 00 00 A2 8F 3C 00 A3 8F 20 00 A6 8F 04 00 42 24 24 00 A7 8F 04 00 31 26 53 00 C3 13 00 00 A2 AF ?? ?? ?? 0? 00 00 00 00 18 00 A6 8F 1C 00 A7 8F 21 20 C0 02 21 28 E0 02 21 A0 40 00 ?? ?? ?? 0? 21 A8 60 00 10 00 A6 8F 14 00 A7 8F 21 20 40 02 21 28 60 02 21 B0 40 00 ?? ?? ?? 0? 21 B8 60 00 21 90 40 00 21 98 60 00 00 00 2C C6 ?? ?? ?? 0? 01 00 DE 27 21 20 40 00 21 28 60 00 21 30 40 02 ?? ?? ?? 0? 21 38 60 02 D8 FF 41 04 2C 00 A2 8F 21 30 40 02 21 38 60 02 21 20 80 02 ?? ?? ?? 0? 21 28 A0 02 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 03 84 02 00 30 00 A2 8F 21 38 60 02 21 30 40 02 21 20 C0 02 21 28 E0 02 ?? ?? ?? 0? 24 80 02 02 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 34 00 A3 8F 07 10 62 00 38 00 A3 8F 24 10 43 00 21 80 02 02 04 00 A2 8F 80 80 10 00 ?? ?? 03 3C 21 80 50 00 2C 00 A2 8F ?? ?? 65 8C 00 00 04 8E 08 00 A3 8F 09 F8 60 00 03 34 02 00 00 00 A3 8F 21 20 40 02 21 28 60 02 ?? ?? ?? 0? 00 00 62 AC 2C 00 A2 8F 28 00 A3 8F 00 00 20 E6 21 20 80 02 21 10 43 00 2C 00 A2 AF 00 00 A2 8F 3C 00 A3 8F 21 28 A0 02 04 00 42 24 20 00 A6 8F 24 00 A7 8F 04 00 31 26 AF FF C3 17 00 00 A2 AF 64 00 BF 8F 60 00 BE 8F 5C 00 B7 8F 58 00 B6 8F 54 00 B5 8F 50 00 B4 8F 4C 00 B3 8F 48 00 B2 8F 44 00 B1 8F 40 00 B0 8F 74 00 B6 C7 70 00 B5 C7 6C 00 B4 C7 08 00 E0 03 78 00 BD 27 }
	condition:
		$1
}

rule file_47_9_0 {
	meta:
		name = "_poly_zbuf_ptex_mask_lit32"
		size = 676
		refs = "0060 __extendsfdf2 00a8 _blender_func32 0108 .text 0110 __adddf3 0170 __ltdf2 018c __divdf3 0198 __fixdfsi 0208 _blender_col_32 0224 __truncdfsf2"
	strings:
		$1 = { 88 FF BD 27 54 00 C3 8C 40 00 CC C4 40 00 B0 AF 21 80 C0 00 50 00 C6 8C 10 00 02 24 23 10 43 00 04 30 66 00 64 00 BF AF 3C 00 A5 AF 38 00 A6 AF 48 00 B2 AF 44 00 B1 AF 21 90 80 00 74 00 B6 E7 70 00 B5 E7 6C 00 B4 E7 60 00 BE AF 5C 00 B7 AF 58 00 B6 AF 54 00 B5 AF 50 00 B4 AF 4C 00 B3 AF ?? ?? ?? 0? 34 00 A2 AF 20 00 A2 AF 44 00 0C C6 4C 00 02 8E 24 00 A3 AF 10 00 03 8E 30 00 A2 AF ?? ?? ?? 0? 2C 00 A3 AF 18 00 A2 AF 34 00 0C C6 14 00 02 8E 1C 00 A3 AF 38 00 15 C6 ?? ?? ?? 0? 28 00 A2 AF 10 00 A2 AF ?? ?? 02 3C 14 00 A3 AF ?? ?? 42 8C 5C 00 11 8E 3C 00 14 C6 30 00 16 C6 3C 00 A3 8F 48 00 10 8E 08 00 A2 AF 66 00 60 18 04 00 B0 AF 06 AB 00 46 ?? ?? ?? 0? 00 00 B2 AF 06 A3 00 46 21 A0 40 00 ?? ?? ?? 0? 21 A8 60 00 06 B3 00 46 21 B0 40 00 ?? ?? ?? 0? 21 B8 60 00 21 F0 00 00 21 90 40 00 ?? ?? ?? 0? 21 98 60 00 ?? ?? ?? 0? 00 00 00 00 18 00 A6 8F 1C 00 A7 8F 21 20 C0 02 21 28 E0 02 21 A0 40 00 ?? ?? ?? 0? 21 A8 60 00 10 00 A6 8F 14 00 A7 8F 21 20 40 02 21 28 60 02 21 B0 40 00 ?? ?? ?? 0? 21 B8 60 00 21 90 40 00 21 98 60 00 00 00 2C C6 ?? ?? ?? 0? 01 00 DE 27 21 20 40 00 21 28 60 00 21 30 40 02 ?? ?? ?? 0? 21 38 60 02 21 30 40 02 21 38 60 02 21 20 80 02 2A 00 41 04 21 28 A0 02 ?? ?? ?? 0? 00 00 00 00 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 03 84 02 00 30 00 A2 8F 21 30 40 02 21 38 60 02 21 20 C0 02 21 28 E0 02 ?? ?? ?? 0? 24 80 02 02 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 34 00 A3 8F 07 10 62 00 38 00 A3 8F 24 10 43 00 21 80 02 02 04 00 A2 8F 2C 00 A3 8F 80 80 10 00 21 80 50 00 00 00 02 8E 03 34 03 00 FF 00 03 3C FF 00 63 34 0B 00 43 10 21 20 40 00 ?? ?? 02 3C 08 00 A3 8F 09 F8 60 00 ?? ?? 45 8C 00 00 A3 8F 21 20 40 02 21 28 60 02 ?? ?? ?? 0? 00 00 62 AC 00 00 20 E6 2C 00 A2 8F 28 00 A3 8F 21 20 80 02 21 28 A0 02 21 10 43 00 2C 00 A2 AF 00 00 A2 8F 3C 00 A3 8F 20 00 A6 8F 04 00 42 24 24 00 A7 8F 04 00 31 26 AB FF C3 17 00 00 A2 AF 64 00 BF 8F 60 00 BE 8F 5C 00 B7 8F 58 00 B6 8F 54 00 B5 8F 50 00 B4 8F 4C 00 B3 8F 48 00 B2 8F 44 00 B1 8F 40 00 B0 8F 74 00 B6 C7 70 00 B5 C7 6C 00 B4 C7 08 00 E0 03 78 00 BD 27 }
	condition:
		$1
}

rule file_47_10_0 {
	meta:
		name = "_poly_zbuf_atex_trans32"
		size = 384
		refs = "0020 _blender_func32 00a0 .text 0120 _blender_alpha"
	strings:
		$1 = { 54 00 C3 8C B8 FF BD 27 28 00 B4 AF 10 00 02 24 21 A0 C0 00 50 00 C6 8C 23 10 43 00 0C 00 A2 AF ?? ?? 02 3C 04 30 66 00 ?? ?? 42 8C 48 00 83 8E 14 00 A5 AF 04 00 A2 AF 00 00 A3 AF 4C 00 82 8E 14 00 A3 8F 38 00 BE AF 34 00 B7 AF 30 00 B6 AF 2C 00 B5 AF 44 00 B4 E7 08 00 A2 AF 3C 00 BF AF 24 00 B3 AF 20 00 B2 AF 1C 00 B1 AF 18 00 B0 AF 10 00 A6 AF 00 00 96 8E 04 00 95 8E 08 00 9E 8E 0C 00 97 8E 60 00 85 8E 30 00 94 C6 2F 00 60 18 5C 00 82 8E 21 98 80 00 21 90 A0 00 21 80 40 00 ?? ?? ?? 0? 21 88 00 00 14 00 A4 8F 21 B0 DE 02 21 A8 B7 02 04 00 10 26 04 00 73 26 04 00 52 26 22 00 24 12 34 00 80 C6 00 A5 00 46 00 00 00 C6 3C 00 14 46 00 00 00 00 F3 FF 00 45 01 00 31 26 0C 00 A4 8F 03 14 16 00 00 00 45 8E 07 18 95 00 08 00 A4 8F 21 B0 DE 02 21 A8 B7 02 24 10 44 00 10 00 A4 8F 04 00 52 26 24 18 64 00 21 10 43 00 00 00 A3 8F 80 10 02 00 21 10 62 00 00 00 44 8C ?? ?? 02 3C 04 00 A3 8F 09 F8 60 00 ?? ?? 46 8C 14 00 A4 8F 00 00 14 E6 00 00 62 AE 04 00 10 26 04 00 73 26 E0 FF 24 16 34 00 80 C6 3C 00 BF 8F 38 00 BE 8F 34 00 B7 8F 30 00 B6 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 44 00 B4 C7 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_47_11_0 {
	meta:
		name = "_poly_zbuf_atex_mask_trans32"
		size = 364
		refs = "0010 _blender_func32 008c .text 00e0 _blender_alpha"
	strings:
		$1 = { 54 00 C3 8C 10 00 02 24 B8 FF BD 27 23 58 43 00 ?? ?? 02 3C ?? ?? 42 8C 30 00 B6 AF 21 B0 C0 00 50 00 C6 8C 21 50 A0 00 38 00 BE AF 34 00 B7 AF 24 00 B3 AF 20 00 B2 AF 44 00 B4 E7 00 00 A2 AF 3C 00 BF AF 2C 00 B5 AF 28 00 B4 AF 1C 00 B1 AF 18 00 B0 AF 04 48 66 00 4C 00 C8 8E 00 00 D3 8E 04 00 D2 8E 08 00 C7 8E 0C 00 DE 8E 48 00 D7 8E 60 00 C5 8E 30 00 D4 C6 2F 00 40 19 5C 00 C2 8E 21 A8 80 00 21 A0 A0 00 21 80 40 00 ?? ?? ?? 0? 21 88 00 00 00 A5 00 46 00 00 00 C6 03 14 13 00 07 18 72 01 24 10 48 00 24 18 69 00 3C 00 14 46 21 10 43 00 80 10 02 00 21 10 E2 02 01 00 31 26 21 98 67 02 17 00 00 45 21 90 5E 02 00 00 42 8C FF 00 03 3C FF 00 63 34 12 00 43 10 21 20 40 00 ?? ?? 02 3C 00 00 85 8E ?? ?? 46 8C 00 00 A3 8F 04 00 A7 AF 08 00 A8 AF 0C 00 A9 AF 10 00 AA AF 09 F8 60 00 14 00 AB AF 14 00 AB 8F 10 00 AA 8F 0C 00 A9 8F 08 00 A8 8F 04 00 A7 8F 00 00 A2 AE 00 00 14 E6 04 00 10 26 04 00 B5 26 04 00 94 26 D8 FF 2A 16 34 00 C0 C6 3C 00 BF 8F 38 00 BE 8F 34 00 B7 8F 30 00 B6 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 44 00 B4 C7 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_47_12_0 {
	meta:
		name = "_poly_zbuf_ptex_trans32"
		size = 696
		refs = "0060 __extendsfdf2 0098 _blender_func32 0100 .text 0138 __adddf3 0198 __ltdf2 01b4 __divdf3 01c0 __fixdfsi 0210 _blender_alpha 023c __truncdfsf2"
	strings:
		$1 = { 90 FF BD 27 54 00 C3 8C 40 00 CC C4 38 00 B0 AF 21 80 C0 00 50 00 C6 8C 10 00 02 24 23 10 43 00 04 30 66 00 5C 00 BF AF 34 00 A5 AF 30 00 A6 AF 40 00 B2 AF 3C 00 B1 AF 21 90 80 00 6C 00 B6 E7 68 00 B5 E7 64 00 B4 E7 58 00 BE AF 54 00 B7 AF 50 00 B6 AF 4C 00 B5 AF 48 00 B4 AF 44 00 B3 AF ?? ?? ?? 0? 2C 00 A2 AF 20 00 A2 AF 44 00 0C C6 4C 00 02 8E 24 00 A3 AF 38 00 15 C6 ?? ?? ?? 0? 28 00 A2 AF 34 00 0C C6 18 00 A2 AF ?? ?? ?? 0? 1C 00 A3 AF 10 00 A2 AF ?? ?? 02 3C ?? ?? 42 8C 14 00 A3 AF 48 00 03 8E 0C 00 A2 AF 34 00 A2 8F 3C 00 14 C6 30 00 16 C6 5C 00 11 8E 08 00 A3 AF 6E 00 40 18 60 00 10 8E 06 AB 00 46 ?? ?? ?? 0? 04 00 B2 AF 06 A3 00 46 21 A0 40 00 21 A8 60 00 ?? ?? ?? 0? 00 00 B0 AF 06 B3 00 46 21 B0 40 00 ?? ?? ?? 0? 21 B8 60 00 21 90 40 00 21 98 60 00 ?? ?? ?? 0? 21 F0 00 00 00 00 A3 8F 21 20 80 02 04 00 42 24 04 00 A2 AF 34 00 A2 8F 04 00 63 24 21 28 A0 02 20 00 A6 8F 24 00 A7 8F 04 00 31 26 52 00 C2 13 00 00 A3 AF ?? ?? ?? 0? 00 00 00 00 18 00 A6 8F 1C 00 A7 8F 21 20 C0 02 21 28 E0 02 21 A0 40 00 ?? ?? ?? 0? 21 A8 60 00 10 00 A6 8F 14 00 A7 8F 21 20 40 02 21 28 60 02 21 B0 40 00 ?? ?? ?? 0? 21 B8 60 00 21 90 40 00 21 98 60 00 00 00 2C C6 ?? ?? ?? 0? 01 00 DE 27 21 20 40 00 21 28 60 00 21 30 40 02 ?? ?? ?? 0? 21 38 60 02 D9 FF 41 04 04 00 A2 8F 21 30 40 02 21 38 60 02 21 20 80 02 ?? ?? ?? 0? 21 28 A0 02 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 28 00 A3 8F 21 38 60 02 21 30 40 02 03 84 02 00 21 20 C0 02 21 28 E0 02 ?? ?? ?? 0? 24 80 03 02 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 2C 00 A3 8F 07 10 62 00 30 00 A3 8F 24 10 43 00 21 80 02 02 08 00 A2 8F 80 80 10 00 ?? ?? 03 3C 21 80 50 00 00 00 A2 8F ?? ?? 66 8C 00 00 04 8E 0C 00 A3 8F 09 F8 60 00 00 00 45 8C 04 00 A3 8F 21 20 40 02 21 28 60 02 ?? ?? ?? 0? 00 00 62 AC 04 00 A2 8F 00 00 A3 8F 00 00 20 E6 04 00 42 24 04 00 A2 AF 34 00 A2 8F 04 00 63 24 21 20 80 02 21 28 A0 02 20 00 A6 8F 24 00 A7 8F 04 00 31 26 B0 FF C2 17 00 00 A3 AF 5C 00 BF 8F 58 00 BE 8F 54 00 B7 8F 50 00 B6 8F 4C 00 B5 8F 48 00 B4 8F 44 00 B3 8F 40 00 B2 8F 3C 00 B1 8F 38 00 B0 8F 6C 00 B6 C7 68 00 B5 C7 64 00 B4 C7 08 00 E0 03 70 00 BD 27 }
	condition:
		$1
}

rule file_47_13_0 {
	meta:
		name = "_poly_zbuf_ptex_mask_trans32"
		size = 668
		refs = "0060 __extendsfdf2 0098 _blender_func32 0104 .text 010c __adddf3 016c __ltdf2 0188 __divdf3 0194 __fixdfsi 0200 _blender_alpha 0220 __truncdfsf2"
	strings:
		$1 = { 90 FF BD 27 54 00 C3 8C 40 00 CC C4 38 00 B0 AF 21 80 C0 00 50 00 C6 8C 10 00 02 24 23 10 43 00 04 30 66 00 5C 00 BF AF 34 00 A5 AF 30 00 A6 AF 40 00 B2 AF 3C 00 B1 AF 21 90 80 00 6C 00 B6 E7 68 00 B5 E7 64 00 B4 E7 58 00 BE AF 54 00 B7 AF 50 00 B6 AF 4C 00 B5 AF 48 00 B4 AF 44 00 B3 AF ?? ?? ?? 0? 2C 00 A2 AF 20 00 A2 AF 44 00 0C C6 4C 00 02 8E 24 00 A3 AF 38 00 15 C6 ?? ?? ?? 0? 28 00 A2 AF 34 00 0C C6 18 00 A2 AF ?? ?? ?? 0? 1C 00 A3 AF 10 00 A2 AF ?? ?? 02 3C ?? ?? 42 8C 14 00 A3 AF 48 00 03 8E 0C 00 A2 AF 34 00 A2 8F 3C 00 14 C6 30 00 16 C6 5C 00 11 8E 08 00 A3 AF 67 00 40 18 60 00 10 8E 06 AB 00 46 ?? ?? ?? 0? 04 00 B2 AF 06 A3 00 46 21 A0 40 00 21 A8 60 00 ?? ?? ?? 0? 00 00 B0 AF 06 B3 00 46 21 B0 40 00 ?? ?? ?? 0? 21 B8 60 00 21 F0 20 02 21 90 40 00 21 98 60 00 ?? ?? ?? 0? 21 88 00 00 ?? ?? ?? 0? 00 00 00 00 18 00 A6 8F 1C 00 A7 8F 21 20 C0 02 21 28 E0 02 21 A0 40 00 ?? ?? ?? 0? 21 A8 60 00 10 00 A6 8F 14 00 A7 8F 21 20 40 02 21 28 60 02 21 B0 40 00 ?? ?? ?? 0? 21 B8 60 00 21 90 40 00 21 98 60 00 00 00 CC C7 ?? ?? ?? 0? 01 00 31 26 21 20 40 00 21 28 60 00 21 30 40 02 ?? ?? ?? 0? 21 38 60 02 21 30 40 02 21 38 60 02 21 20 80 02 2A 00 41 04 21 28 A0 02 ?? ?? ?? 0? 00 00 00 00 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 28 00 A3 8F 03 84 02 00 21 30 40 02 21 38 60 02 21 20 C0 02 21 28 E0 02 ?? ?? ?? 0? 24 80 03 02 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 2C 00 A3 8F 07 10 62 00 30 00 A3 8F 24 10 43 00 21 80 02 02 08 00 A2 8F 80 80 10 00 FF 00 03 3C 21 80 50 00 00 00 02 8E FF 00 63 34 0D 00 43 10 21 20 40 00 00 00 A3 8F ?? ?? 02 3C 00 00 65 8C 0C 00 A3 8F 09 F8 60 00 ?? ?? 46 8C 04 00 A3 8F 21 20 40 02 21 28 60 02 ?? ?? ?? 0? 00 00 62 AC 00 00 C0 E7 04 00 A2 8F 00 00 A3 8F 21 20 80 02 04 00 42 24 04 00 A2 AF 34 00 A2 8F 04 00 63 24 21 28 A0 02 20 00 A6 8F 24 00 A7 8F 04 00 DE 27 AC FF 22 16 00 00 A3 AF 5C 00 BF 8F 58 00 BE 8F 54 00 B7 8F 50 00 B6 8F 4C 00 B5 8F 48 00 B4 8F 44 00 B3 8F 40 00 B2 8F 3C 00 B1 8F 38 00 B0 8F 6C 00 B6 C7 68 00 B5 C7 64 00 B4 C7 08 00 E0 03 70 00 BD 27 }
	condition:
		$1
}

rule file_48_0_0 {
	meta:
		name = "psp_do_stretch_blit8"
		size = 192
		refs = "002c stretch_blit 0034 displayed_video_bitmap 006c psp_do_stretch_blit8 0094 psp_draw_to_screen"
	strings:
		$1 = { 1C 00 82 8C E8 FF BD 27 18 00 A3 8F A8 00 40 AC 1C 00 A2 8F 10 00 B1 AF 0C 00 B0 AF 21 88 80 00 04 00 A2 AF 14 00 BF AF 00 00 A3 AF ?? ?? ?? 0? 21 80 A0 00 ?? ?? 02 3C 0A 00 00 12 ?? ?? 44 8C 09 00 80 50 1C 00 23 8E 12 00 04 12 FF 01 02 3C 2C 00 03 8E FF FF 45 34 24 18 65 00 0A 00 60 14 2C 00 82 8C 1C 00 23 8E 14 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 10 00 B1 8F 0C 00 B0 8F A8 00 62 AC 08 00 E0 03 18 00 BD 27 24 10 45 00 F6 FF 62 54 1C 00 23 8E ?? ?? ?? 0? 00 00 00 00 1C 00 23 8E 14 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 10 00 B1 8F 0C 00 B0 8F A8 00 62 AC 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_48_1_0 {
	meta:
		name = "psp_floodfill8"
		size = 156
		refs = "0000 __linear_vtable8 0024 displayed_video_bitmap 0054 psp_vtable8 0078 psp_draw_to_screen"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 24 D8 00 43 8C F8 FF BD 27 1C 00 82 AC 00 00 B0 AF 04 00 BF AF 09 F8 60 00 21 80 80 00 ?? ?? 02 3C ?? ?? 44 8C 09 00 80 10 04 00 BF 8F 10 00 04 12 FF 01 02 3C 2C 00 03 8E FF FF 45 34 24 18 65 00 08 00 60 14 2C 00 82 8C 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 24 10 45 00 F8 FF 62 14 04 00 BF 8F ?? ?? ?? 0? 00 00 00 00 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_48_2_0 {
	meta:
		name = "psp_spline8"
		size = 156
		refs = "0000 __linear_vtable8 0024 displayed_video_bitmap 0054 psp_vtable8 0078 psp_draw_to_screen"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 24 D4 00 43 8C F8 FF BD 27 1C 00 82 AC 00 00 B0 AF 04 00 BF AF 09 F8 60 00 21 80 80 00 ?? ?? 02 3C ?? ?? 44 8C 09 00 80 10 04 00 BF 8F 10 00 04 12 FF 01 02 3C 2C 00 03 8E FF FF 45 34 24 18 65 00 08 00 60 14 2C 00 82 8C 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 24 10 45 00 F8 FF 62 14 04 00 BF 8F ?? ?? ?? 0? 00 00 00 00 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_48_3_0 {
	meta:
		name = "psp_arc8"
		size = 156
		refs = "0000 __linear_vtable8 0024 displayed_video_bitmap 0054 psp_vtable8 0078 psp_draw_to_screen"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 24 D0 00 43 8C F8 FF BD 27 1C 00 82 AC 00 00 B0 AF 04 00 BF AF 09 F8 60 00 21 80 80 00 ?? ?? 02 3C ?? ?? 44 8C 09 00 80 10 04 00 BF 8F 10 00 04 12 FF 01 02 3C 2C 00 03 8E FF FF 45 34 24 18 65 00 08 00 60 14 2C 00 82 8C 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 24 10 45 00 F8 FF 62 14 04 00 BF 8F ?? ?? ?? 0? 00 00 00 00 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_48_4_0 {
	meta:
		name = "psp_ellipsefill8"
		size = 156
		refs = "0000 __linear_vtable8 0024 displayed_video_bitmap 0054 psp_vtable8 0078 psp_draw_to_screen"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 24 CC 00 43 8C F8 FF BD 27 1C 00 82 AC 00 00 B0 AF 04 00 BF AF 09 F8 60 00 21 80 80 00 ?? ?? 02 3C ?? ?? 44 8C 09 00 80 10 04 00 BF 8F 10 00 04 12 FF 01 02 3C 2C 00 03 8E FF FF 45 34 24 18 65 00 08 00 60 14 2C 00 82 8C 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 24 10 45 00 F8 FF 62 14 04 00 BF 8F ?? ?? ?? 0? 00 00 00 00 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_48_5_0 {
	meta:
		name = "psp_ellipse8"
		size = 156
		refs = "0000 __linear_vtable8 0024 displayed_video_bitmap 0054 psp_vtable8 0078 psp_draw_to_screen"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 24 C8 00 43 8C F8 FF BD 27 1C 00 82 AC 00 00 B0 AF 04 00 BF AF 09 F8 60 00 21 80 80 00 ?? ?? 02 3C ?? ?? 44 8C 09 00 80 10 04 00 BF 8F 10 00 04 12 FF 01 02 3C 2C 00 03 8E FF FF 45 34 24 18 65 00 08 00 60 14 2C 00 82 8C 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 24 10 45 00 F8 FF 62 14 04 00 BF 8F ?? ?? ?? 0? 00 00 00 00 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_48_6_0 {
	meta:
		name = "psp_circlefill8"
		size = 156
		refs = "0000 __linear_vtable8 0024 displayed_video_bitmap 0054 psp_vtable8 0078 psp_draw_to_screen"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 24 C4 00 43 8C F8 FF BD 27 1C 00 82 AC 00 00 B0 AF 04 00 BF AF 09 F8 60 00 21 80 80 00 ?? ?? 02 3C ?? ?? 44 8C 09 00 80 10 04 00 BF 8F 10 00 04 12 FF 01 02 3C 2C 00 03 8E FF FF 45 34 24 18 65 00 08 00 60 14 2C 00 82 8C 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 24 10 45 00 F8 FF 62 14 04 00 BF 8F ?? ?? ?? 0? 00 00 00 00 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_48_7_0 {
	meta:
		name = "psp_circle8"
		size = 156
		refs = "0000 __linear_vtable8 0024 displayed_video_bitmap 0054 psp_vtable8 0078 psp_draw_to_screen"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 24 C0 00 43 8C F8 FF BD 27 1C 00 82 AC 00 00 B0 AF 04 00 BF AF 09 F8 60 00 21 80 80 00 ?? ?? 02 3C ?? ?? 44 8C 09 00 80 10 04 00 BF 8F 10 00 04 12 FF 01 02 3C 2C 00 03 8E FF FF 45 34 24 18 65 00 08 00 60 14 2C 00 82 8C 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 24 10 45 00 F8 FF 62 14 04 00 BF 8F ?? ?? ?? 0? 00 00 00 00 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_48_8_0 {
	meta:
		name = "psp_rect8"
		size = 156
		refs = "0000 __linear_vtable8 0024 displayed_video_bitmap 0054 psp_vtable8 0078 psp_draw_to_screen"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 24 BC 00 43 8C F8 FF BD 27 1C 00 82 AC 00 00 B0 AF 04 00 BF AF 09 F8 60 00 21 80 80 00 ?? ?? 02 3C ?? ?? 44 8C 09 00 80 10 04 00 BF 8F 10 00 04 12 FF 01 02 3C 2C 00 03 8E FF FF 45 34 24 18 65 00 08 00 60 14 2C 00 82 8C 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 24 10 45 00 F8 FF 62 14 04 00 BF 8F ?? ?? ?? 0? 00 00 00 00 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_48_9_0 {
	meta:
		name = "psp_polygon8"
		size = 156
		refs = "0000 __linear_vtable8 0024 displayed_video_bitmap 0054 psp_vtable8 0078 psp_draw_to_screen"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 24 B8 00 43 8C F8 FF BD 27 1C 00 82 AC 00 00 B0 AF 04 00 BF AF 09 F8 60 00 21 80 80 00 ?? ?? 02 3C ?? ?? 44 8C 09 00 80 10 04 00 BF 8F 10 00 04 12 FF 01 02 3C 2C 00 03 8E FF FF 45 34 24 18 65 00 08 00 60 14 2C 00 82 8C 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 24 10 45 00 F8 FF 62 14 04 00 BF 8F ?? ?? ?? 0? 00 00 00 00 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_48_10_0 {
	meta:
		name = "psp_pivot_scaled_sprite_flip8"
		size = 164
		refs = "0004 __linear_vtable8 002c displayed_video_bitmap 005c psp_vtable8 0080 psp_draw_to_screen"
	strings:
		$1 = { F0 FF BD 27 ?? ?? 03 3C ?? ?? 63 24 10 00 A2 8F A4 00 6C 8C 08 00 B0 AF 00 00 A2 AF 0C 00 BF AF 1C 00 83 AC 09 F8 80 01 21 80 80 00 ?? ?? 02 3C ?? ?? 44 8C 09 00 80 10 0C 00 BF 8F 10 00 04 12 FF 01 02 3C 2C 00 03 8E FF FF 45 34 24 18 65 00 08 00 60 14 2C 00 82 8C 0C 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 08 00 B0 8F 08 00 E0 03 10 00 BD 27 24 10 45 00 F8 FF 62 14 0C 00 BF 8F ?? ?? ?? 0? 00 00 00 00 0C 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 08 00 B0 8F 08 00 E0 03 10 00 BD 27 }
	condition:
		$1
}

rule file_48_11_0 {
	meta:
		name = "psp_clear_to_color8"
		size = 156
		refs = "0000 __linear_vtable8 0024 displayed_video_bitmap 0054 psp_vtable8 0078 psp_draw_to_screen"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 24 A0 00 43 8C F8 FF BD 27 1C 00 82 AC 00 00 B0 AF 04 00 BF AF 09 F8 60 00 21 80 80 00 ?? ?? 02 3C ?? ?? 44 8C 09 00 80 10 04 00 BF 8F 10 00 04 12 FF 01 02 3C 2C 00 03 8E FF FF 45 34 24 18 65 00 08 00 60 14 2C 00 82 8C 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 24 10 45 00 F8 FF 62 14 04 00 BF 8F ?? ?? ?? 0? 00 00 00 00 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_48_12_0 {
	meta:
		name = "psp_blit_to_self8"
		size = 156
		refs = "0000 __linear_vtable8 0024 displayed_video_bitmap 0054 psp_vtable8 0078 psp_draw_to_screen"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 24 8C 00 43 8C F8 FF BD 27 00 00 B0 AF 1C 00 A2 AC 04 00 BF AF 09 F8 60 00 21 80 A0 00 ?? ?? 02 3C ?? ?? 44 8C 09 00 80 10 04 00 BF 8F 10 00 04 12 FF 01 02 3C 2C 00 03 8E FF FF 45 34 24 18 65 00 08 00 60 14 2C 00 82 8C 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 24 10 45 00 F8 FF 62 14 04 00 BF 8F ?? ?? ?? 0? 00 00 00 00 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_48_13_0 {
	meta:
		name = "psp_blit_from_system8"
		size = 156
		refs = "0000 __linear_vtable8 0024 displayed_video_bitmap 0054 psp_vtable8 0078 psp_draw_to_screen"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 24 84 00 43 8C F8 FF BD 27 00 00 B0 AF 1C 00 A2 AC 04 00 BF AF 09 F8 60 00 21 80 A0 00 ?? ?? 02 3C ?? ?? 44 8C 09 00 80 10 04 00 BF 8F 10 00 04 12 FF 01 02 3C 2C 00 03 8E FF FF 45 34 24 18 65 00 08 00 60 14 2C 00 82 8C 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 24 10 45 00 F8 FF 62 14 04 00 BF 8F ?? ?? ?? 0? 00 00 00 00 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_48_14_0 {
	meta:
		name = "psp_blit_from_memory8"
		size = 156
		refs = "0000 __linear_vtable8 0024 displayed_video_bitmap 0054 psp_vtable8 0078 psp_draw_to_screen"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 24 7C 00 43 8C F8 FF BD 27 00 00 B0 AF 1C 00 A2 AC 04 00 BF AF 09 F8 60 00 21 80 A0 00 ?? ?? 02 3C ?? ?? 44 8C 09 00 80 10 04 00 BF 8F 10 00 04 12 FF 01 02 3C 2C 00 03 8E FF FF 45 34 24 18 65 00 08 00 60 14 2C 00 82 8C 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 24 10 45 00 F8 FF 62 14 04 00 BF 8F ?? ?? ?? 0? 00 00 00 00 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_48_15_0 {
	meta:
		name = "psp_draw_glyph8"
		size = 156
		refs = "0000 __linear_vtable8 0024 displayed_video_bitmap 0054 psp_vtable8 0078 psp_draw_to_screen"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 24 78 00 43 8C F8 FF BD 27 1C 00 82 AC 00 00 B0 AF 04 00 BF AF 09 F8 60 00 21 80 80 00 ?? ?? 02 3C ?? ?? 44 8C 09 00 80 10 04 00 BF 8F 10 00 04 12 FF 01 02 3C 2C 00 03 8E FF FF 45 34 24 18 65 00 08 00 60 14 2C 00 82 8C 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 24 10 45 00 F8 FF 62 14 04 00 BF 8F ?? ?? ?? 0? 00 00 00 00 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_48_16_0 {
	meta:
		name = "psp_draw_character8"
		size = 156
		refs = "0000 __linear_vtable8 0024 displayed_video_bitmap 0054 psp_vtable8 0078 psp_draw_to_screen"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 24 74 00 43 8C F8 FF BD 27 1C 00 82 AC 00 00 B0 AF 04 00 BF AF 09 F8 60 00 21 80 80 00 ?? ?? 02 3C ?? ?? 44 8C 09 00 80 10 04 00 BF 8F 10 00 04 12 FF 01 02 3C 2C 00 03 8E FF FF 45 34 24 18 65 00 08 00 60 14 2C 00 82 8C 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 24 10 45 00 F8 FF 62 14 04 00 BF 8F ?? ?? ?? 0? 00 00 00 00 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_48_17_0 {
	meta:
		name = "psp_draw_lit_rle_sprite8"
		size = 156
		refs = "0000 __linear_vtable8 0024 displayed_video_bitmap 0054 psp_vtable8 0078 psp_draw_to_screen"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 24 70 00 43 8C F8 FF BD 27 1C 00 82 AC 00 00 B0 AF 04 00 BF AF 09 F8 60 00 21 80 80 00 ?? ?? 02 3C ?? ?? 44 8C 09 00 80 10 04 00 BF 8F 10 00 04 12 FF 01 02 3C 2C 00 03 8E FF FF 45 34 24 18 65 00 08 00 60 14 2C 00 82 8C 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 24 10 45 00 F8 FF 62 14 04 00 BF 8F ?? ?? ?? 0? 00 00 00 00 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_48_18_0 {
	meta:
		name = "psp_draw_trans_rle_sprite8"
		size = 156
		refs = "0000 __linear_vtable8 0024 displayed_video_bitmap 0054 psp_vtable8 0078 psp_draw_to_screen"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 24 68 00 43 8C F8 FF BD 27 1C 00 82 AC 00 00 B0 AF 04 00 BF AF 09 F8 60 00 21 80 80 00 ?? ?? 02 3C ?? ?? 44 8C 09 00 80 10 04 00 BF 8F 10 00 04 12 FF 01 02 3C 2C 00 03 8E FF FF 45 34 24 18 65 00 08 00 60 14 2C 00 82 8C 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 24 10 45 00 F8 FF 62 14 04 00 BF 8F ?? ?? ?? 0? 00 00 00 00 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_48_19_0 {
	meta:
		name = "psp_draw_rle_sprite8"
		size = 156
		refs = "0000 __linear_vtable8 0024 displayed_video_bitmap 0054 psp_vtable8 0078 psp_draw_to_screen"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 24 64 00 43 8C F8 FF BD 27 1C 00 82 AC 00 00 B0 AF 04 00 BF AF 09 F8 60 00 21 80 80 00 ?? ?? 02 3C ?? ?? 44 8C 09 00 80 10 04 00 BF 8F 10 00 04 12 FF 01 02 3C 2C 00 03 8E FF FF 45 34 24 18 65 00 08 00 60 14 2C 00 82 8C 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 24 10 45 00 F8 FF 62 14 04 00 BF 8F ?? ?? ?? 0? 00 00 00 00 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_48_20_0 {
	meta:
		name = "psp_draw_lit_sprite8"
		size = 156
		refs = "0000 __linear_vtable8 0024 displayed_video_bitmap 0054 psp_vtable8 0078 psp_draw_to_screen"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 24 60 00 43 8C F8 FF BD 27 1C 00 82 AC 00 00 B0 AF 04 00 BF AF 09 F8 60 00 21 80 80 00 ?? ?? 02 3C ?? ?? 44 8C 09 00 80 10 04 00 BF 8F 10 00 04 12 FF 01 02 3C 2C 00 03 8E FF FF 45 34 24 18 65 00 08 00 60 14 2C 00 82 8C 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 24 10 45 00 F8 FF 62 14 04 00 BF 8F ?? ?? ?? 0? 00 00 00 00 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_48_21_0 {
	meta:
		name = "psp_draw_trans_sprite8"
		size = 156
		refs = "0000 __linear_vtable8 0024 displayed_video_bitmap 0054 psp_vtable8 0078 psp_draw_to_screen"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 24 58 00 43 8C F8 FF BD 27 1C 00 82 AC 00 00 B0 AF 04 00 BF AF 09 F8 60 00 21 80 80 00 ?? ?? 02 3C ?? ?? 44 8C 09 00 80 10 04 00 BF 8F 10 00 04 12 FF 01 02 3C 2C 00 03 8E FF FF 45 34 24 18 65 00 08 00 60 14 2C 00 82 8C 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 24 10 45 00 F8 FF 62 14 04 00 BF 8F ?? ?? ?? 0? 00 00 00 00 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_48_22_0 {
	meta:
		name = "psp_draw_sprite_vh_flip8"
		size = 156
		refs = "0000 __linear_vtable8 0024 displayed_video_bitmap 0054 psp_vtable8 0078 psp_draw_to_screen"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 24 54 00 43 8C F8 FF BD 27 1C 00 82 AC 00 00 B0 AF 04 00 BF AF 09 F8 60 00 21 80 80 00 ?? ?? 02 3C ?? ?? 44 8C 09 00 80 10 04 00 BF 8F 10 00 04 12 FF 01 02 3C 2C 00 03 8E FF FF 45 34 24 18 65 00 08 00 60 14 2C 00 82 8C 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 24 10 45 00 F8 FF 62 14 04 00 BF 8F ?? ?? ?? 0? 00 00 00 00 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_48_23_0 {
	meta:
		name = "psp_draw_sprite_h_flip8"
		size = 156
		refs = "0000 __linear_vtable8 0024 displayed_video_bitmap 0054 psp_vtable8 0078 psp_draw_to_screen"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 24 50 00 43 8C F8 FF BD 27 1C 00 82 AC 00 00 B0 AF 04 00 BF AF 09 F8 60 00 21 80 80 00 ?? ?? 02 3C ?? ?? 44 8C 09 00 80 10 04 00 BF 8F 10 00 04 12 FF 01 02 3C 2C 00 03 8E FF FF 45 34 24 18 65 00 08 00 60 14 2C 00 82 8C 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 24 10 45 00 F8 FF 62 14 04 00 BF 8F ?? ?? ?? 0? 00 00 00 00 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_48_24_0 {
	meta:
		name = "psp_draw_sprite_v_flip8"
		size = 156
		refs = "0000 __linear_vtable8 0024 displayed_video_bitmap 0054 psp_vtable8 0078 psp_draw_to_screen"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 24 4C 00 43 8C F8 FF BD 27 1C 00 82 AC 00 00 B0 AF 04 00 BF AF 09 F8 60 00 21 80 80 00 ?? ?? 02 3C ?? ?? 44 8C 09 00 80 10 04 00 BF 8F 10 00 04 12 FF 01 02 3C 2C 00 03 8E FF FF 45 34 24 18 65 00 08 00 60 14 2C 00 82 8C 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 24 10 45 00 F8 FF 62 14 04 00 BF 8F ?? ?? ?? 0? 00 00 00 00 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_48_25_0 {
	meta:
		name = "psp_draw_256_sprite8"
		size = 156
		refs = "0000 __linear_vtable8 0024 displayed_video_bitmap 0054 psp_vtable8 0078 psp_draw_to_screen"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 24 48 00 43 8C F8 FF BD 27 1C 00 82 AC 00 00 B0 AF 04 00 BF AF 09 F8 60 00 21 80 80 00 ?? ?? 02 3C ?? ?? 44 8C 09 00 80 10 04 00 BF 8F 10 00 04 12 FF 01 02 3C 2C 00 03 8E FF FF 45 34 24 18 65 00 08 00 60 14 2C 00 82 8C 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 24 10 45 00 F8 FF 62 14 04 00 BF 8F ?? ?? ?? 0? 00 00 00 00 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_48_26_0 {
	meta:
		name = "psp_draw_sprite8"
		size = 156
		refs = "0000 __linear_vtable8 0024 displayed_video_bitmap 0054 psp_vtable8 0078 psp_draw_to_screen"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 24 44 00 43 8C F8 FF BD 27 1C 00 82 AC 00 00 B0 AF 04 00 BF AF 09 F8 60 00 21 80 80 00 ?? ?? 02 3C ?? ?? 44 8C 09 00 80 10 04 00 BF 8F 10 00 04 12 FF 01 02 3C 2C 00 03 8E FF FF 45 34 24 18 65 00 08 00 60 14 2C 00 82 8C 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 24 10 45 00 F8 FF 62 14 04 00 BF 8F ?? ?? ?? 0? 00 00 00 00 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_48_27_0 {
	meta:
		name = "psp_triangle8"
		size = 156
		refs = "0000 __linear_vtable8 0024 displayed_video_bitmap 0054 psp_vtable8 0078 psp_draw_to_screen"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 24 40 00 43 8C F8 FF BD 27 1C 00 82 AC 00 00 B0 AF 04 00 BF AF 09 F8 60 00 21 80 80 00 ?? ?? 02 3C ?? ?? 44 8C 09 00 80 10 04 00 BF 8F 10 00 04 12 FF 01 02 3C 2C 00 03 8E FF FF 45 34 24 18 65 00 08 00 60 14 2C 00 82 8C 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 24 10 45 00 F8 FF 62 14 04 00 BF 8F ?? ?? ?? 0? 00 00 00 00 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_48_28_0 {
	meta:
		name = "psp_rectfill8"
		size = 156
		refs = "0000 __linear_vtable8 0024 displayed_video_bitmap 0054 psp_vtable8 0078 psp_draw_to_screen"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 24 3C 00 43 8C F8 FF BD 27 1C 00 82 AC 00 00 B0 AF 04 00 BF AF 09 F8 60 00 21 80 80 00 ?? ?? 02 3C ?? ?? 44 8C 09 00 80 10 04 00 BF 8F 10 00 04 12 FF 01 02 3C 2C 00 03 8E FF FF 45 34 24 18 65 00 08 00 60 14 2C 00 82 8C 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 24 10 45 00 F8 FF 62 14 04 00 BF 8F ?? ?? ?? 0? 00 00 00 00 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_48_29_0 {
	meta:
		name = "psp_fastline8"
		size = 156
		refs = "0000 __linear_vtable8 0024 displayed_video_bitmap 0054 psp_vtable8 0078 psp_draw_to_screen"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 24 38 00 43 8C F8 FF BD 27 1C 00 82 AC 00 00 B0 AF 04 00 BF AF 09 F8 60 00 21 80 80 00 ?? ?? 02 3C ?? ?? 44 8C 09 00 80 10 04 00 BF 8F 10 00 04 12 FF 01 02 3C 2C 00 03 8E FF FF 45 34 24 18 65 00 08 00 60 14 2C 00 82 8C 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 24 10 45 00 F8 FF 62 14 04 00 BF 8F ?? ?? ?? 0? 00 00 00 00 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_48_30_0 {
	meta:
		name = "psp_line8"
		size = 156
		refs = "0000 __linear_vtable8 0024 displayed_video_bitmap 0054 psp_vtable8 0078 psp_draw_to_screen"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 24 34 00 43 8C F8 FF BD 27 1C 00 82 AC 00 00 B0 AF 04 00 BF AF 09 F8 60 00 21 80 80 00 ?? ?? 02 3C ?? ?? 44 8C 09 00 80 10 04 00 BF 8F 10 00 04 12 FF 01 02 3C 2C 00 03 8E FF FF 45 34 24 18 65 00 08 00 60 14 2C 00 82 8C 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 24 10 45 00 F8 FF 62 14 04 00 BF 8F ?? ?? ?? 0? 00 00 00 00 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_48_31_0 {
	meta:
		name = "psp_hfill8"
		size = 156
		refs = "0000 __linear_vtable8 0024 displayed_video_bitmap 0054 psp_vtable8 0078 psp_draw_to_screen"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 24 30 00 43 8C F8 FF BD 27 1C 00 82 AC 00 00 B0 AF 04 00 BF AF 09 F8 60 00 21 80 80 00 ?? ?? 02 3C ?? ?? 44 8C 09 00 80 10 04 00 BF 8F 10 00 04 12 FF 01 02 3C 2C 00 03 8E FF FF 45 34 24 18 65 00 08 00 60 14 2C 00 82 8C 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 24 10 45 00 F8 FF 62 14 04 00 BF 8F ?? ?? ?? 0? 00 00 00 00 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_48_32_0 {
	meta:
		name = "psp_hline8"
		size = 156
		refs = "0000 __linear_vtable8 0024 displayed_video_bitmap 0054 psp_vtable8 0078 psp_draw_to_screen"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 24 2C 00 43 8C F8 FF BD 27 1C 00 82 AC 00 00 B0 AF 04 00 BF AF 09 F8 60 00 21 80 80 00 ?? ?? 02 3C ?? ?? 44 8C 09 00 80 10 04 00 BF 8F 10 00 04 12 FF 01 02 3C 2C 00 03 8E FF FF 45 34 24 18 65 00 08 00 60 14 2C 00 82 8C 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 24 10 45 00 F8 FF 62 14 04 00 BF 8F ?? ?? ?? 0? 00 00 00 00 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_48_33_0 {
	meta:
		name = "psp_vline8"
		size = 156
		refs = "0000 __linear_vtable8 0024 displayed_video_bitmap 0054 psp_vtable8 0078 psp_draw_to_screen"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 24 28 00 43 8C F8 FF BD 27 1C 00 82 AC 00 00 B0 AF 04 00 BF AF 09 F8 60 00 21 80 80 00 ?? ?? 02 3C ?? ?? 44 8C 09 00 80 10 04 00 BF 8F 10 00 04 12 FF 01 02 3C 2C 00 03 8E FF FF 45 34 24 18 65 00 08 00 60 14 2C 00 82 8C 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 24 10 45 00 F8 FF 62 14 04 00 BF 8F ?? ?? ?? 0? 00 00 00 00 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_48_34_0 {
	meta:
		name = "psp_putpixel8"
		size = 156
		refs = "0000 __linear_vtable8 0024 displayed_video_bitmap 0054 psp_vtable8 0078 psp_draw_to_screen"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 24 24 00 43 8C F8 FF BD 27 1C 00 82 AC 00 00 B0 AF 04 00 BF AF 09 F8 60 00 21 80 80 00 ?? ?? 02 3C ?? ?? 44 8C 09 00 80 10 04 00 BF 8F 10 00 04 12 FF 01 02 3C 2C 00 03 8E FF FF 45 34 24 18 65 00 08 00 60 14 2C 00 82 8C 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 24 10 45 00 F8 FF 62 14 04 00 BF 8F ?? ?? ?? 0? 00 00 00 00 04 00 BF 8F ?? ?? 02 3C ?? ?? 42 24 1C 00 02 AE 00 00 B0 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_50_0_0 {
	meta:
		name = "clip3d_f"
		size = 7592
		refs = "0014 .rodata 0110 .text 1500 screen 1524 getr_depth 1554 getg_depth 1584 getb_depth 1650 makecol_depth"
	strings:
		$1 = { EF FF 02 24 00 FD BD 27 24 10 82 00 80 18 02 00 40 00 A2 AF ?? ?? 02 3C ?? ?? 42 24 21 18 62 00 00 00 63 8C 3C 60 0D 46 D4 02 B3 AF D0 02 B2 AF FC 02 B6 E7 F8 02 B5 E7 EC 02 BF AF E8 02 BE AF E4 02 B7 AF E0 02 B6 AF DC 02 B5 AF D8 02 B4 AF CC 02 B1 AF C8 02 B0 AF F4 02 B4 E7 86 65 00 46 46 6D 00 46 21 50 A0 00 08 01 A6 AF 21 90 E0 00 0C 01 A8 AF 21 98 20 01 4E 04 01 45 50 00 A3 AF 21 58 A0 00 4C 00 A6 AF E8 06 60 19 4C 00 AA 8F 30 00 B3 AF 21 20 60 02 21 28 40 01 21 18 00 00 00 00 A2 8C 01 00 63 24 2A 30 6B 00 08 00 40 C4 04 00 A5 24 3C 00 16 46 00 00 00 00 02 00 01 45 01 00 02 24 21 10 00 00 00 00 82 AC F4 FF C0 14 04 00 84 24 50 00 A5 8F 50 00 A6 8F 50 00 A2 8F 50 00 A3 8F 01 00 A5 30 08 00 C6 30 04 00 42 30 02 00 63 30 FF FF 64 25 21 40 60 02 21 48 00 00 21 F0 00 00 98 02 A5 AF 9C 02 A6 AF A0 02 A2 AF ?? ?? ?? 0? A4 02 A3 AF 00 00 80 C6 04 00 81 C6 08 00 82 C6 0C 00 83 C6 10 00 84 C6 14 00 A2 AE 00 00 A0 E6 04 00 A1 E6 08 00 A2 E6 0C 00 A3 E6 10 00 A4 E6 01 00 DE 27 01 00 23 25 2A 10 6B 00 04 00 4A 25 04 00 08 25 5B 00 40 10 21 20 20 01 21 48 60 00 80 10 04 00 21 B8 62 02 4C 00 A4 8F 00 00 E6 8E 00 00 05 8D 80 18 1E 00 21 10 82 00 21 18 43 02 24 20 C5 00 00 00 56 8C 00 00 75 8C ED FF 80 14 00 00 54 8D 25 10 C5 00 DE FF 40 50 14 00 82 8E 08 00 C5 C6 08 00 82 C6 00 00 C4 C6 81 B1 05 46 81 10 05 46 04 00 C3 C6 00 00 80 C6 04 00 81 C6 03 35 02 46 01 00 04 46 41 08 03 46 98 02 A5 8F 02 00 14 46 42 08 14 46 82 10 14 46 00 21 00 46 C0 18 01 46 40 29 02 46 00 00 A4 E6 04 00 A3 E6 B9 02 A0 10 08 00 A5 E6 14 00 C0 C6 14 00 82 8E 00 00 03 44 60 00 80 46 23 10 43 00 00 10 82 44 00 00 00 00 20 10 80 46 02 00 14 46 00 00 01 46 0D 00 00 46 14 00 A0 E6 00 00 E6 8E 9C 02 A2 8F 0D 00 40 10 01 00 DE 27 10 00 C3 C6 0C 00 C2 C6 0C 00 80 C6 10 00 81 C6 01 00 02 46 41 08 03 46 02 00 14 46 42 08 14 46 80 10 00 46 C0 18 01 46 0C 00 A2 E6 10 00 A3 E6 80 10 1E 00 21 10 42 02 B4 FF C0 10 00 00 43 8C 14 00 82 8E 00 00 80 C6 04 00 81 C6 08 00 82 C6 0C 00 83 C6 10 00 84 C6 14 00 62 AC 00 00 60 E4 04 00 61 E4 08 00 62 E4 0C 00 63 E4 10 00 64 E4 01 00 23 25 2A 10 6B 00 01 00 DE 27 04 00 4A 25 04 00 08 25 A7 FF 40 14 21 20 20 01 58 06 C0 13 21 30 40 02 44 00 B2 AF 21 28 60 02 21 20 00 00 00 80 08 3C 00 00 C2 8C 01 00 84 24 2A 38 9E 00 08 00 43 8C 00 00 40 C4 04 00 C6 24 26 18 68 00 78 01 A3 AF 78 01 A1 C7 3C 00 01 46 00 00 00 00 02 00 01 45 01 00 02 24 21 10 00 00 00 00 A2 AC F0 FF E0 14 04 00 A5 24 50 00 A2 8F 50 00 A3 8F 50 00 A5 8F 50 00 A6 8F 01 00 42 30 08 00 63 30 04 00 A5 30 02 00 C6 30 FF FF C4 27 21 50 40 02 21 48 60 02 21 58 00 00 21 B8 00 00 88 02 A2 AF 8C 02 A3 AF 90 02 A5 AF ?? ?? ?? 0? 94 02 A6 AF 00 00 80 C6 04 00 81 C6 08 00 82 C6 0C 00 83 C6 10 00 84 C6 14 00 A2 AE 00 00 A0 E6 04 00 A1 E6 08 00 A2 E6 0C 00 A3 E6 10 00 A4 E6 01 00 F7 26 01 00 63 25 2A 10 7E 00 04 00 4A 25 04 00 29 25 64 00 40 10 21 20 60 01 21 58 60 00 80 10 04 00 21 40 62 02 0C 01 A4 8F 00 00 06 8D 00 00 25 8D 80 18 17 00 21 18 83 00 21 10 42 02 24 20 C5 00 00 00 56 8C 00 00 75 8C ED FF 80 14 00 00 54 8D 25 10 C5 00 DE FF 40 50 14 00 82 8E 08 00 C5 8E 00 00 C5 C6 00 00 82 C6 00 80 02 3C 26 28 A2 00 81 10 05 46 7C 01 A5 AF 08 00 83 C6 7C 01 A0 C7 08 00 C7 C6 04 00 C4 C6 81 01 05 46 00 10 03 46 04 00 81 C6 C1 18 07 46 88 02 A2 8F 01 00 07 46 41 08 04 46 03 35 00 46 82 10 14 46 42 08 14 46 C2 18 14 46 40 29 02 46 00 21 01 46 00 38 03 46 00 00 A5 E6 04 00 A4 E6 5B 02 40 10 08 00 A0 E6 14 00 C0 C6 14 00 82 8E 00 00 03 44 60 00 80 46 23 10 43 00 00 10 82 44 00 00 00 00 20 10 80 46 02 00 14 46 00 00 01 46 0D 00 00 46 14 00 A0 E6 00 00 06 8D 8C 02 A2 8F 0E 00 40 50 0C 01 A3 8F 10 00 C3 C6 0C 00 C2 C6 0C 00 80 C6 10 00 81 C6 01 00 02 46 41 08 03 46 02 00 14 46 42 08 14 46 80 10 00 46 C0 18 01 46 0C 00 A2 E6 10 00 A3 E6 0C 01 A3 8F 01 00 F7 26 80 10 17 00 21 10 62 00 AB FF C0 10 00 00 43 8C 14 00 82 8E 00 00 80 C6 04 00 81 C6 08 00 82 C6 0C 00 83 C6 10 00 84 C6 14 00 62 AC 00 00 60 E4 04 00 61 E4 08 00 62 E4 0C 00 63 E4 10 00 64 E4 01 00 63 25 2A 10 7E 00 01 00 F7 26 04 00 4A 25 04 00 29 25 9E FF 40 14 21 20 60 01 CF 01 E0 52 21 B8 00 00 0C 01 A4 8F 21 18 00 00 48 00 A4 AF 21 28 80 00 21 20 60 02 00 00 A2 8C 01 00 63 24 2A 30 77 00 08 00 41 C4 00 00 40 C4 04 00 A5 24 3C 08 00 46 00 00 00 00 02 00 01 45 01 00 02 24 21 10 00 00 00 00 82 AC F3 FF C0 14 04 00 84 24 50 00 A5 8F 50 00 A6 8F 50 00 A2 8F 50 00 A3 8F 01 00 A5 30 08 00 C6 30 04 00 42 30 02 00 63 30 FF FF E4 26 0C 01 AA 8F 21 40 60 02 21 58 00 00 21 48 00 00 78 02 A5 AF 7C 02 A6 AF 80 02 A2 AF ?? ?? ?? 0? 84 02 A3 AF 00 00 80 C6 04 00 81 C6 08 00 82 C6 0C 00 83 C6 10 00 84 C6 14 00 A2 AE 00 00 A0 E6 04 00 A1 E6 08 00 A2 E6 0C 00 A3 E6 10 00 A4 E6 01 00 29 25 01 00 63 25 2A 10 77 00 04 00 4A 25 04 00 08 25 5D 00 40 10 21 20 60 01 21 58 60 00 80 10 04 00 21 F0 62 02 0C 01 A4 8F 00 00 C6 8F 00 00 05 8D 80 18 09 00 21 10 82 00 21 18 43 02 24 20 C5 00 00 00 56 8C 00 00 75 8C ED FF 80 14 00 00 54 8D 25 10 C5 00 DE FF 40 50 14 00 82 8E 00 00 C6 C6 00 00 82 C6 08 00 83 C6 08 00 C4 C6 81 10 06 46 04 00 C5 C6 C1 21 06 46 04 00 81 C6 01 10 03 46 C1 18 04 46 41 08 05 46 78 02 A5 8F 00 20 00 46 03 3D 00 46 82 10 14 46 42 08 14 46 C2 18 14 46 80 31 02 46 40 29 01 46 00 21 03 46 00 00 A6 E6 04 00 A5 E6 02 02 A0 10 08 00 A4 E6 14 00 C0 C6 14 00 82 8E 00 00 03 44 60 00 80 46 23 10 43 00 00 10 82 44 00 00 00 00 20 10 80 46 02 00 14 46 00 00 01 46 0D 00 00 46 14 00 A0 E6 00 00 C6 8F 7C 02 A2 8F 0D 00 40 10 01 00 29 25 10 00 C3 C6 0C 00 C2 C6 0C 00 80 C6 10 00 81 C6 01 00 02 46 41 08 03 46 02 00 14 46 42 08 14 46 80 10 00 46 C0 18 01 46 0C 00 A2 E6 10 00 A3 E6 80 10 09 00 21 10 42 02 B2 FF C0 10 00 00 43 8C 14 00 82 8E 00 00 80 C6 04 00 81 C6 08 00 82 C6 0C 00 83 C6 10 00 84 C6 14 00 62 AC 00 00 60 E4 04 00 61 E4 08 00 62 E4 0C 00 63 E4 10 00 64 E4 01 00 63 25 2A 10 77 00 01 00 29 25 04 00 4A 25 04 00 08 25 A5 FF 40 14 21 20 60 01 25 05 20 11 21 30 40 02 21 28 60 02 21 20 00 00 00 80 08 3C 00 00 C2 8C 01 00 84 24 2A 38 89 00 08 00 43 8C 04 00 40 C4 04 00 C6 24 26 18 68 00 E8 01 A3 AF E8 01 A1 C7 3C 00 01 46 00 00 00 00 02 00 01 45 01 00 02 24 21 10 00 00 00 00 A2 AC F0 FF E0 14 04 00 A5 24 50 00 A2 8F 50 00 A3 8F 50 00 A5 8F 50 00 A6 8F 01 00 42 30 08 00 63 30 04 00 A5 30 02 00 C6 30 FF FF 24 25 21 40 60 02 21 50 00 00 21 F0 00 00 68 02 A2 AF 6C 02 A3 AF 70 02 A5 AF ?? ?? ?? 0? 74 02 A6 AF 00 00 80 C6 04 00 81 C6 08 00 82 C6 0C 00 83 C6 10 00 84 C6 14 00 A2 AE 00 00 A0 E6 04 00 A1 E6 08 00 A2 E6 0C 00 A3 E6 10 00 A4 E6 01 00 DE 27 44 00 A4 8F 01 00 43 25 2A 10 69 00 04 00 84 24 44 00 A4 AF 04 00 08 25 67 00 40 10 21 20 40 01 21 50 60 00 80 10 04 00 21 B8 62 02 0C 01 A4 8F 21 10 42 02 00 00 E6 8E 00 00 05 8D 00 00 56 8C 44 00 A2 8F 80 18 1E 00 21 18 83 00 24 20 C5 00 00 00 75 8C EA FF 80 14 00 00 54 8C 25 10 C5 00 DB FF 40 50 14 00 82 8E 08 00 C3 8E 04 00 C5 C6 04 00 82 C6 00 80 04 3C 26 18 64 00 81 10 05 46 EC 01 A3 AF 08 00 83 C6 EC 01 A0 C7 08 00 C7 C6 00 00 C4 C6 81 01 05 46 00 10 03 46 00 00 81 C6 C1 18 07 46 68 02 A2 8F 01 00 07 46 41 08 04 46 03 35 00 46 42 08 14 46 82 10 14 46 C2 18 14 46 00 21 01 46 40 29 02 46 00 38 03 46 00 00 A4 E6 04 00 A5 E6 A3 01 40 10 08 00 A0 E6 14 00 C0 C6 14 00 82 8E 00 00 03 44 60 00 80 46 23 10 43 00 00 10 82 44 00 00 00 00 20 10 80 46 02 00 14 46 00 00 01 46 0D 00 00 46 14 00 A0 E6 00 00 E6 8E 6C 02 A2 8F 0E 00 40 50 0C 01 A3 8F 10 00 C3 C6 0C 00 C2 C6 0C 00 80 C6 10 00 81 C6 01 00 02 46 41 08 03 46 02 00 14 46 42 08 14 46 80 10 00 46 C0 18 01 46 0C 00 A2 E6 10 00 A3 E6 0C 01 A3 8F 01 00 DE 27 80 10 1E 00 21 10 62 00 A8 FF C0 10 00 00 43 8C 14 00 82 8E 00 00 80 C6 04 00 81 C6 08 00 82 C6 0C 00 83 C6 10 00 84 C6 44 00 A4 8F 14 00 62 AC 00 00 60 E4 04 00 61 E4 08 00 62 E4 0C 00 63 E4 10 00 64 E4 01 00 43 25 04 00 84 24 2A 10 69 00 44 00 A4 AF 01 00 DE 27 04 00 08 25 9B FF 40 14 21 20 40 01 84 04 C0 13 0C 01 A5 8F 21 20 60 02 21 18 00 00 00 00 A2 8C 01 00 63 24 2A 30 7E 00 08 00 41 C4 04 00 40 C4 04 00 A5 24 3C 08 00 46 00 00 00 00 02 00 01 45 01 00 02 24 21 10 00 00 00 00 82 AC F3 FF C0 14 04 00 84 24 50 00 A5 8F 50 00 A6 8F 50 00 A2 8F 50 00 A3 8F 02 00 A5 30 01 00 C6 30 08 00 42 30 04 00 63 30 64 02 A5 AF FF FF C4 27 21 48 00 00 21 B8 00 00 58 02 A6 AF 5C 02 A2 AF ?? ?? ?? 0? 60 02 A3 AF 00 00 80 C6 04 00 81 C6 08 00 82 C6 0C 00 83 C6 10 00 84 C6 14 00 A2 AE 00 00 A0 E6 04 00 A1 E6 08 00 A2 E6 0C 00 A3 E6 10 00 A4 E6 01 00 F7 26 48 00 A4 8F 30 00 A5 8F 01 00 23 25 04 00 84 24 04 00 A5 24 2A 10 7E 00 48 00 A4 AF 30 00 A5 AF 63 00 40 10 21 20 20 01 21 48 60 00 80 10 04 00 30 00 A4 8F 21 40 62 02 00 00 06 8D 00 00 85 8C 0C 01 A4 8F 80 18 17 00 21 18 43 02 21 10 82 00 00 00 56 8C 48 00 A2 8F 24 20 C5 00 00 00 75 8C E7 FF 80 14 00 00 54 8C 25 10 C5 00 D8 FF 40 50 14 00 82 8E 04 00 C6 C6 04 00 82 C6 08 00 83 C6 08 00 C4 C6 81 10 06 46 00 00 C5 C6 C1 21 06 46 00 00 81 C6 01 10 03 46 C1 18 04 46 41 08 05 46 58 02 A3 8F 00 20 00 46 03 3D 00 46 42 08 14 46 82 10 14 46 C2 18 14 46 40 29 01 46 80 31 02 46 00 21 03 46 00 00 A5 E6 04 00 A6 E6 47 01 60 10 08 00 A4 E6 14 00 C0 C6 14 00 82 8E 00 00 03 44 60 00 80 46 23 10 43 00 00 10 82 44 00 00 00 00 20 10 80 46 02 00 14 46 00 00 01 46 0D 00 00 46 14 00 A0 E6 00 00 06 8D 5C 02 A2 8F 0D 00 40 10 01 00 F7 26 10 00 C3 C6 0C 00 C2 C6 0C 00 80 C6 10 00 81 C6 01 00 02 46 41 08 03 46 02 00 14 46 42 08 14 46 80 10 00 46 C0 18 01 46 0C 00 A2 E6 10 00 A3 E6 80 10 17 00 21 10 42 02 AC FF C0 10 00 00 43 8C 14 00 82 8E 00 00 80 C6 04 00 81 C6 08 00 82 C6 0C 00 83 C6 10 00 84 C6 48 00 A4 8F 30 00 A5 8F 14 00 62 AC 00 00 60 E4 04 00 61 E4 08 00 62 E4 0C 00 63 E4 10 00 64 E4 01 00 23 25 04 00 84 24 04 00 A5 24 2A 10 7E 00 48 00 A4 AF 01 00 F7 26 30 00 A5 AF 9F FF 40 14 21 20 20 01 40 00 A6 8F 05 00 C0 14 08 01 A3 8F 00 00 44 8E 00 00 62 8C 14 00 43 8C 14 00 83 AC EC 02 BF 8F 21 10 E0 02 E8 02 BE 8F E4 02 B7 8F E0 02 B6 8F DC 02 B5 8F D8 02 B4 8F D4 02 B3 8F D0 02 B2 8F CC 02 B1 8F C8 02 B0 8F FC 02 B6 C7 F8 02 B5 C7 F4 02 B4 C7 08 00 E0 03 00 03 BD 27 A0 02 A2 8F 07 02 40 14 A4 02 A3 8F 52 FD 60 10 9C 02 A2 8F 14 00 C2 8E FF 00 06 3C 14 00 84 8E 00 FF 43 30 24 30 46 00 38 00 A3 AF FF 00 42 30 34 00 A2 AF 38 00 A2 8F 00 FF 85 30 3C 00 A6 AF 23 28 A2 00 60 01 A5 AF 3C 00 A5 8F FF 00 06 3C 24 18 86 00 23 18 65 00 00 18 83 44 68 01 A3 AF 34 00 A3 8F FF 00 82 30 60 01 A0 C7 23 10 43 00 A0 18 80 46 00 18 82 44 60 00 80 46 42 08 14 46 20 18 80 46 82 10 14 46 02 00 14 46 38 00 A4 C7 00 28 85 44 00 30 83 44 E0 20 80 46 20 29 80 46 40 08 03 46 60 31 80 46 80 10 04 46 00 00 05 46 4D 08 00 46 70 01 A2 AF 8D 10 00 46 00 08 02 44 0D 00 00 46 00 10 04 44 00 00 05 44 00 FF 43 30 24 10 86 00 25 18 62 00 FF 00 A2 30 25 10 62 00 14 00 A2 AE 64 01 A1 E7 6C 01 A2 E7 74 01 A0 E7 ?? ?? ?? 0? 00 00 E6 8E 90 02 A2 8F 83 02 40 14 94 02 A3 8F B0 FD 60 10 8C 02 A2 8F 14 00 C2 8E FF 00 06 3C 14 00 84 8E 00 FF 43 30 24 30 46 00 28 00 A3 AF FF 00 42 30 24 00 A2 AF 28 00 A2 8F 00 FF 85 30 2C 00 A6 AF 23 28 A2 00 9C 01 A5 AF 2C 00 A5 8F FF 00 06 3C 24 18 86 00 23 18 65 00 00 18 83 44 A4 01 A3 AF 24 00 A3 8F FF 00 82 30 9C 01 A0 C7 23 10 43 00 A0 18 80 46 00 18 82 44 60 00 80 46 42 08 14 46 20 18 80 46 82 10 14 46 02 00 14 46 28 00 A4 C7 00 28 85 44 00 30 83 44 E0 20 80 46 20 29 80 46 40 08 03 46 60 31 80 46 80 10 04 46 00 00 05 46 4D 08 00 46 AC 01 A2 AF 8D 10 00 46 00 08 02 44 0D 00 00 46 00 10 04 44 00 00 05 44 00 FF 43 30 24 10 86 00 25 18 62 00 FF 00 A2 30 25 10 62 00 14 00 A2 AE A0 01 A1 E7 A8 01 A2 E7 B0 01 A0 E7 ?? ?? ?? 0? 00 00 06 8D 80 02 A2 8F E8 01 40 14 84 02 A3 8F 09 FE 60 10 7C 02 A2 8F 14 00 C2 8E FF 00 06 3C 14 00 84 8E 00 FF 43 30 24 30 46 00 1C 00 A3 AF FF 00 42 30 18 00 A2 AF 1C 00 A2 8F 00 FF 85 30 20 00 A6 AF 23 28 A2 00 D0 01 A5 AF 20 00 A5 8F FF 00 06 3C 24 18 86 00 23 18 65 00 00 18 83 44 D8 01 A3 AF 18 00 A3 8F FF 00 82 30 D0 01 A0 C7 23 10 43 00 A0 18 80 46 00 18 82 44 60 00 80 46 42 08 14 46 20 18 80 46 82 10 14 46 02 00 14 46 1C 00 A4 C7 00 28 85 44 00 30 83 44 E0 20 80 46 20 29 80 46 40 08 03 46 60 31 80 46 80 10 04 46 00 00 05 46 4D 08 00 46 E0 01 A2 AF 8D 10 00 46 00 08 02 44 0D 00 00 46 00 10 04 44 00 00 05 44 00 FF 43 30 24 10 86 00 25 18 62 00 FF 00 A2 30 25 10 62 00 14 00 A2 AE D4 01 A1 E7 DC 01 A2 E7 E4 01 A0 E7 ?? ?? ?? 0? 00 00 C6 8F 70 02 A2 8F BD 02 40 14 74 02 A3 8F 68 FE 60 10 6C 02 A2 8F 14 00 C2 8E FF 00 06 3C 14 00 84 8E 00 FF 43 30 24 30 46 00 10 00 A3 AF FF 00 42 30 0C 00 A2 AF 10 00 A2 8F 00 FF 85 30 }
	condition:
		$1
}

rule file_51_0_0 {
	meta:
		name = "digmid_set_pan"
		size = 60
		refs = "0000 midi_digmid 0008 .bss 0034 voice_set_pan"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 43 8C ?? ?? 02 3C ?? ?? 42 24 23 30 83 00 00 31 06 00 21 10 46 00 08 00 43 8C 80 00 63 28 03 00 60 14 00 00 00 00 08 00 E0 03 00 00 00 00 ?? ?? ?? 0? 40 28 05 00 }
	condition:
		$1
}

rule file_51_1_0 {
	meta:
		name = "digmid_set_volume"
		size = 480
		refs = "0000 midi_digmid 0008 .bss 0058 voice_get_volume 00e4 voice_set_volume 0130 voice_ramp_volume 0160 .text"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 46 8C ?? ?? 02 3C E8 FF BD 27 23 30 86 00 00 31 06 00 ?? ?? 42 24 04 00 B0 AF 21 80 46 00 08 00 03 8E 08 00 B1 AF 14 00 BF AF 80 00 63 28 10 00 B3 AF 0C 00 B2 AF 3F 00 60 10 21 88 80 00 04 00 03 8E 18 00 62 8C FF 00 42 28 41 00 40 10 40 90 05 00 ?? ?? ?? 0? 00 00 00 00 04 00 04 8E 0C 00 05 8E FF 00 06 24 18 00 87 8C 18 00 A7 00 12 18 00 00 02 00 C0 14 1A 00 66 00 CD 01 00 00 12 18 00 00 23 20 43 00 07 00 82 24 0F 00 42 2C 34 00 40 14 2A 10 65 00 45 00 40 14 00 12 04 00 21 98 00 00 00 01 02 24 18 00 47 00 00 01 03 24 12 10 00 00 02 00 60 14 1A 00 43 00 CD 01 00 00 12 10 00 00 21 10 53 00 18 00 52 00 12 20 00 00 02 FF 83 28 2D 00 60 10 01 FE 02 34 21 28 00 00 ?? ?? ?? 0? 21 20 20 02 04 00 02 8E FF 00 03 24 00 01 07 24 18 00 46 8C 10 00 45 8C 21 20 20 02 18 00 46 02 12 30 00 00 18 00 65 02 12 28 00 00 02 00 60 14 1A 00 C3 00 CD 01 00 00 12 30 00 00 02 00 E0 14 1A 00 A7 00 CD 01 00 00 ?? ?? ?? 0? 12 28 00 00 0C 00 12 AE 14 00 BF 8F 10 00 B3 8F 0C 00 B2 8F 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 18 00 BD 27 ?? ?? ?? 0? 21 28 40 02 ?? ?? ?? 0? 0C 00 12 AE 18 00 47 02 21 20 20 02 12 28 00 00 02 00 C0 14 1A 00 A6 00 CD 01 00 00 ?? ?? ?? 0? 12 28 00 00 ?? ?? ?? 0? 0C 00 12 AE 2A 10 82 00 D3 FF 40 50 FF 00 05 24 FF 00 02 24 02 00 40 14 1A 00 82 00 CD 01 00 00 ?? ?? ?? 0? 12 28 00 00 23 18 A3 00 02 00 60 14 1A 00 43 00 CD 01 00 00 00 01 04 24 21 18 00 00 12 10 00 00 2D 10 44 00 2C 98 43 00 ?? ?? ?? 0? 23 10 93 00 }
	condition:
		$1
}

rule file_51_2_0 {
	meta:
		name = "digmid_key_off"
		size = 84
		refs = "0000 midi_digmid 0008 .bss 003c voice_ramp_volume 004c voice_stop"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 43 8C ?? ?? 02 3C ?? ?? 42 24 23 28 83 00 00 29 05 00 21 10 45 00 08 00 43 8C 80 00 63 28 07 00 60 10 00 00 00 00 04 00 42 8C 14 00 45 8C 05 00 A0 18 00 00 00 00 ?? ?? ?? 0? 21 30 00 00 08 00 E0 03 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_51_3_0 {
	meta:
		name = "destroy_patch"
		size = 136
		refs = "0030 destroy_sample 003c _al_free"
	strings:
		$1 = { F0 FF BD 27 08 00 B2 AF 0C 00 BF AF 04 00 B1 AF 00 00 B0 AF 16 00 80 10 21 90 80 00 00 00 82 8C 0C 00 40 18 21 80 80 00 21 88 00 00 04 00 04 8E ?? ?? ?? 0? 01 00 31 26 04 01 04 8E ?? ?? ?? 0? 04 00 10 26 00 00 42 8E 2A 10 22 02 F8 FF 40 54 04 00 04 8E 21 20 40 02 0C 00 BF 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F ?? ?? ?? 0? 10 00 BD 27 0C 00 BF 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 10 00 BD 27 }
	condition:
		$1
}

rule file_51_4_0 {
	meta:
		name = "digmid_exit"
		size = 164
		refs = "0004 .bss 0044 .text"
	strings:
		$1 = { E8 FF BD 27 ?? ?? 02 3C 10 00 B3 AF ?? ?? 03 3C ?? ?? 53 24 0C 00 B2 AF 08 00 B1 AF 04 00 B0 AF 14 00 BF AF ?? ?? 70 24 21 88 60 02 01 00 12 24 00 00 24 8E 11 00 80 10 00 01 42 2A 0C 00 40 10 80 10 12 00 ?? ?? ?? 0? 21 18 62 02 08 00 03 12 00 00 00 00 00 00 62 8C FC FF 44 54 04 00 63 24 00 00 60 AC 04 00 63 24 FA FF 03 16 00 00 24 8E ?? ?? ?? 0? 00 00 00 00 00 00 20 AE 04 00 31 26 EB FF 11 16 01 00 52 26 14 00 BF 8F 10 00 B3 8F 0C 00 B2 8F 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_51_5_0 {
	meta:
		name = "digmid_init"
		size = 228
		refs = "0000 $LC0 0020 get_config_text 0028 midi_digmid 0038 .bss 0054 $LC1 0058 $LC2 008c __extendsfdf2 00a0 __divdf3 00ac __truncdfsf2"
	strings:
		$1 = { ?? ?? 04 3C E8 FF BD 27 ?? ?? 84 24 04 00 B0 AF 14 00 BF AF 10 00 B3 AF 0C 00 B2 AF 08 00 B1 AF ?? ?? ?? 0? 21 80 A0 00 ?? ?? 03 3C ?? ?? 64 24 08 00 82 AC ?? ?? 03 3C ?? ?? 02 3C ?? ?? 42 24 ?? ?? 63 24 00 00 40 AC 04 00 42 24 FE FF 62 54 00 00 40 AC ?? ?? 02 3C ?? ?? 03 3C ?? ?? 40 C4 D6 00 02 3C 00 D8 42 34 ?? ?? 72 8C ?? ?? 73 8C ?? ?? 03 3C 10 00 90 AC ?? ?? 62 AC ?? ?? 04 3C ?? ?? 02 3C ?? ?? 90 24 ?? ?? 51 24 ?? ?? ?? 0? 06 03 00 46 21 20 40 00 21 28 60 00 21 30 40 02 ?? ?? ?? 0? 21 38 60 02 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 4D 00 00 46 00 00 01 E6 FC FF 10 26 F2 FF 30 16 14 00 BF 8F 21 10 00 00 10 00 B3 8F 0C 00 B2 8F 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_51_6_0 {
	meta:
		name = "_digmid_find_patches"
		size = 500
		refs = "001c $LC3 005c uconvert 0064 $LC4 008c get_config_string 0094 $LC5 00b4 $LC6 00d4 $LC7 00f4 $LC8 0134 find_allegro_resource 0188 ustrrchr 019c ustrlen 0198 $LC9 01b0 ustrzcpy 01b8 usetc 01dc .text 01e4 get_filename"
	strings:
		$1 = { D0 FA BD 27 28 05 BE AF 0C 05 B1 AF 08 05 B0 AF 75 63 11 3C 53 41 10 3C 21 F0 80 00 ?? ?? 04 3C 24 05 B7 AF 20 05 B6 AF 00 05 A5 AF ?? ?? 84 24 38 43 05 36 40 00 08 24 21 B0 C0 00 21 B8 E0 00 21 30 A0 03 2E 72 27 36 2C 05 BF AF 1C 05 B5 AF 18 05 B4 AF 14 05 B3 AF 10 05 B2 AF ?? ?? ?? 0? 40 00 B3 27 ?? ?? 04 3C 2E 72 27 36 40 00 08 24 21 30 60 02 38 43 05 36 ?? ?? 84 24 ?? ?? ?? 0? 21 90 40 00 21 28 40 00 21 20 40 02 ?? ?? ?? 0? 21 30 00 00 ?? ?? 04 3C 38 43 05 36 ?? ?? 84 24 21 30 A0 03 2E 72 27 36 40 00 08 24 ?? ?? ?? 0? 21 A8 40 00 ?? ?? 04 3C 21 30 60 02 38 43 05 36 ?? ?? 84 24 2E 72 27 36 40 00 08 24 ?? ?? ?? 0? 21 A0 40 00 ?? ?? 04 3C 38 43 05 36 ?? ?? 84 24 80 00 A6 27 2E 72 27 36 40 00 08 24 ?? ?? ?? 0? 21 98 40 00 ?? ?? 04 3C 38 43 05 36 ?? ?? 84 24 2E 72 27 36 C0 00 A6 27 40 00 08 24 21 90 40 00 ?? ?? ?? 0? 00 01 B0 27 21 50 40 00 21 28 A0 02 21 38 80 02 21 40 60 02 21 48 40 02 21 20 00 02 21 30 00 00 ?? ?? ?? 0? 00 04 0B 24 0D 00 40 10 21 10 00 00 2C 05 BF 8F 28 05 BE 8F 24 05 B7 8F 20 05 B6 8F 1C 05 B5 8F 18 05 B4 8F 14 05 B3 8F 10 05 B2 8F 0C 05 B1 8F 08 05 B0 8F 08 00 E0 03 30 05 BD 27 F3 FF C0 13 FF FF 02 24 F1 FF C0 12 00 00 00 00 21 20 00 02 ?? ?? ?? 0? 23 00 05 24 14 00 40 10 21 88 40 00 ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 84 24 21 88 22 02 21 20 C0 02 21 28 E0 02 ?? ?? ?? 0? 21 30 20 02 ?? ?? 03 3C ?? ?? 66 8C 21 20 20 02 09 F8 C0 00 21 28 00 00 00 05 A5 8F 21 20 C0 03 ?? ?? ?? 0? 21 30 00 02 ?? ?? ?? 0? FF FF 02 24 ?? ?? ?? 0? 21 20 00 02 ?? ?? ?? 0? 21 88 40 00 }
	condition:
		$1
}

rule file_51_7_0 {
	meta:
		name = "digmid_detect"
		size = 96
		refs = "0024 _digmid_find_patches 0034 .text 003c get_config_text 0030 $LC10 0044 allegro_error 0050 ustrzcpy"
	strings:
		$1 = { F8 FF BD 27 05 00 80 10 04 00 BF AF 21 10 00 00 04 00 BF 8F 08 00 E0 03 08 00 BD 27 21 28 00 00 21 30 00 00 ?? ?? ?? 0? 21 38 00 00 03 00 40 50 ?? ?? 04 3C ?? ?? ?? 0? FF FF 02 24 ?? ?? ?? 0? ?? ?? 84 24 ?? ?? 04 3C ?? ?? 84 24 21 30 40 00 ?? ?? ?? 0? 00 01 05 24 ?? ?? ?? 0? 21 10 00 00 }
	condition:
		$1
}

rule file_51_8_0 {
	meta:
		name = "digmid_freq"
		size = 1060
		refs = "000c .bss 03f4 .text"
	strings:
		$1 = { 08 00 A9 8C CC 00 00 11 08 00 CA 8C ?? ?? 03 3C ?? ?? 78 24 80 10 07 00 21 10 02 03 00 00 44 8C 02 7C 09 00 FF FF 2E 31 FF FF 82 30 18 00 4F 00 02 5C 04 00 12 18 00 00 00 24 03 00 02 1C 03 00 18 00 4E 00 12 10 00 00 21 20 82 00 2B 10 82 00 18 00 6F 01 12 28 00 00 02 00 40 10 21 48 65 00 01 00 29 25 18 00 6E 01 12 10 00 00 00 1C 02 00 21 58 83 00 02 14 02 00 2B 20 64 01 E1 00 80 14 21 18 22 01 21 68 00 00 00 80 05 3C 21 48 00 00 20 00 0C 24 23 20 6A 00 2B 10 64 00 02 00 40 50 25 68 A5 01 21 20 60 00 24 10 AB 00 01 00 29 25 42 28 05 00 02 00 40 10 40 18 04 00 01 00 63 34 F5 FF 2C 15 23 20 6A 00 01 00 E2 24 80 10 02 00 21 10 02 03 00 00 44 8C FF FF 83 30 18 00 6F 00 02 3C 04 00 12 10 00 00 00 24 02 00 02 14 02 00 18 00 6E 00 12 18 00 00 21 20 83 00 2B 18 83 00 18 00 EF 00 12 28 00 00 02 00 60 10 21 48 45 00 01 00 29 25 18 00 EE 00 12 10 00 00 00 1C 02 00 21 58 83 00 02 14 02 00 2B 20 64 01 B7 00 80 14 21 18 22 01 21 48 00 00 00 80 05 3C 21 38 00 00 20 00 0C 24 23 20 6A 00 2B 10 64 00 02 00 40 50 25 48 25 01 21 20 60 00 24 10 AB 00 01 00 E7 24 42 28 05 00 02 00 40 10 40 18 04 00 01 00 63 34 F5 FF EC 14 23 20 6A 00 40 18 09 00 18 00 68 00 00 10 04 24 23 20 88 00 40 10 0D 00 12 18 00 00 18 00 44 00 12 10 00 00 21 18 62 00 02 43 03 00 20 00 CB 8C 00 04 02 24 59 00 62 11 07 00 02 3C 1C 00 C5 8C 02 24 05 00 18 00 8E 00 FF FF A6 30 12 18 00 00 00 2C 03 00 02 1C 03 00 18 00 CE 00 12 10 00 00 21 28 A2 00 2B 10 A2 00 18 00 8F 00 12 20 00 00 02 00 40 10 21 38 64 00 01 00 E7 24 18 00 CF 00 12 10 00 00 00 1C 02 00 21 48 A3 00 02 14 02 00 2B 20 25 01 84 00 80 14 21 18 E2 00 21 38 00 00 00 80 05 3C 21 30 00 00 20 00 0A 24 C4 FF 64 24 2B 10 64 00 02 00 40 50 25 38 E5 00 21 20 60 00 24 10 A9 00 01 00 C6 24 42 28 05 00 02 00 40 10 40 18 04 00 01 00 63 34 F5 FF CA 14 C4 FF 64 24 40 50 07 00 23 28 0A 01 FF FF A2 30 02 24 0B 00 18 00 44 00 FF FF 67 31 02 44 05 00 12 18 00 00 00 2C 03 00 02 1C 03 00 18 00 47 00 12 10 00 00 21 28 A2 00 2B 10 A2 00 18 00 04 01 12 20 00 00 02 00 40 10 21 30 64 00 01 00 C6 24 18 00 07 01 12 10 00 00 00 1C 02 00 21 48 A3 00 02 14 02 00 2B 20 25 01 56 00 80 14 21 18 C2 00 21 38 00 00 00 80 05 3C 21 30 00 00 20 00 08 24 00 FC 64 24 2B 10 64 00 02 00 40 50 25 38 E5 00 21 20 60 00 24 10 A9 00 01 00 C6 24 42 28 05 00 02 00 40 10 40 18 04 00 01 00 63 34 F5 FF C8 54 00 FC 64 24 40 10 07 00 21 40 4A 00 07 00 02 3C FF FF 42 34 2B 18 02 01 05 00 60 14 21 18 40 00 42 40 08 00 2B 10 03 01 FE FF 40 50 42 40 08 00 08 00 E0 03 21 10 00 01 ?? ?? 02 3C 80 18 07 00 ?? ?? 42 24 21 18 62 00 00 00 64 8C 02 7C 09 00 FF FF 2E 31 FF FF 82 30 18 00 4F 00 02 3C 04 00 12 18 00 00 00 24 03 00 02 1C 03 00 18 00 4E 00 12 10 00 00 21 20 82 00 2B 10 82 00 18 00 EF 00 12 28 00 00 02 00 40 10 21 48 65 00 01 00 29 25 18 00 EE 00 12 10 00 00 00 1C 02 00 21 40 83 00 02 14 02 00 2B 20 04 01 14 00 80 14 21 18 22 01 21 28 00 00 00 80 07 3C 21 48 00 00 20 00 0B 24 23 20 6A 00 2B 10 64 00 02 00 40 50 25 28 A7 00 21 20 60 00 24 10 E8 00 01 00 29 25 42 38 07 00 02 00 40 10 40 18 04 00 01 00 63 34 F5 FF 2B 55 23 20 6A 00 ?? ?? ?? 0? 40 40 05 00 ?? ?? ?? 0? 01 00 63 24 ?? ?? ?? 0? 01 00 63 24 ?? ?? ?? 0? 01 00 63 24 ?? ?? ?? 0? 01 00 63 24 ?? ?? ?? 0? 01 00 63 24 }
	condition:
		$1
}

rule file_51_9_0 {
	meta:
		name = "digmid_set_pitch"
		size = 116
		refs = "0000 midi_digmid 0008 .bss 0054 .text 006c voice_set_frequency"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 43 8C ?? ?? 02 3C ?? ?? 42 24 23 18 83 00 00 19 03 00 F8 FF BD 27 21 18 43 00 00 00 B0 AF 21 80 80 00 08 00 64 8C 04 00 BF AF 21 38 A0 00 80 00 82 28 05 00 40 14 21 40 C0 00 04 00 BF 8F 00 00 B0 8F 08 00 E0 03 08 00 BD 27 00 00 65 8C ?? ?? ?? 0? 04 00 66 8C 21 28 40 00 21 20 00 02 04 00 BF 8F 00 00 B0 8F ?? ?? ?? 0? 08 00 BD 27 }
	condition:
		$1
}

rule file_51_10_0 {
	meta:
		name = "digmid_trigger"
		size = 476
		refs = "0044 _midi_allocate_voice 0054 .bss 0094 midi_digmid 00c4 reallocate_voice 00d0 voice_set_playmode 00dc voice_set_volume 00e8 voice_set_frequency 00f4 voice_set_pan 0130 voice_start 0184 voice_ramp_volume 01cc .text"
	strings:
		$1 = { D8 FF BD 27 10 00 B3 AF 08 00 B1 AF 21 98 80 00 21 88 A0 00 FF FF 04 24 FF FF 05 24 20 00 B7 AF 1C 00 B6 AF 18 00 B5 AF 14 00 B4 AF 04 00 B0 AF 24 00 BF AF 0C 00 B2 AF 21 A8 C0 00 21 B0 E0 00 21 A0 00 01 ?? ?? ?? 0? 21 B8 20 01 3A 00 40 04 21 80 40 00 ?? ?? 02 3C ?? ?? 42 24 80 18 13 00 21 18 62 00 00 00 64 8C 40 00 22 26 80 18 11 00 80 10 02 00 21 10 82 00 80 00 65 2A 21 20 83 00 04 00 91 8C 4D 00 A0 14 04 00 52 8C 24 00 57 8E 08 00 35 8E ?? ?? 02 3C ?? ?? 43 8C ?? ?? 02 3C ?? ?? 42 24 23 18 03 02 00 19 03 00 21 10 43 00 08 00 53 AC 0C 00 54 AC 00 00 51 AC 04 00 52 AC 21 28 20 02 ?? ?? ?? 0? 21 20 00 02 0C 00 45 8E ?? ?? ?? 0? 21 20 00 02 21 20 00 02 ?? ?? ?? 0? 21 28 80 02 21 20 00 02 ?? ?? ?? 0? 21 28 A0 02 21 28 E0 02 ?? ?? ?? 0? 21 20 00 02 18 00 45 8E FF 00 A2 28 17 00 40 14 24 00 BF 8F 21 20 00 02 20 00 B7 8F 1C 00 B6 8F 18 00 B5 8F 14 00 B4 8F 10 00 B3 8F 0C 00 B2 8F 08 00 B1 8F 04 00 B0 8F ?? ?? ?? 0? 28 00 BD 27 24 00 BF 8F 20 00 B7 8F 1C 00 B6 8F 18 00 B5 8F 14 00 B4 8F 10 00 B3 8F 0C 00 B2 8F 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 28 00 BD 27 18 00 85 02 FF 00 02 24 10 00 45 8E 21 20 00 02 12 30 00 00 02 00 40 14 1A 00 C2 00 CD 01 00 00 ?? ?? ?? 0? 12 30 00 00 21 20 00 02 24 00 BF 8F 20 00 B7 8F 1C 00 B6 8F 18 00 B5 8F 14 00 B4 8F 10 00 B3 8F 0C 00 B2 8F 08 00 B1 8F 04 00 B0 8F ?? ?? ?? 0? 28 00 BD 27 21 38 A0 02 21 40 C0 02 21 20 60 02 21 28 20 02 ?? ?? ?? 0? 21 30 40 02 ?? ?? ?? 0? 21 A8 40 00 }
	condition:
		$1
}

rule file_51_11_0 {
	meta:
		name = "digmid_key_on"
		size = 476
		refs = "0000 .bss 0094 .text"
	strings:
		$1 = { ?? ?? 02 3C 80 18 04 00 ?? ?? 42 24 21 48 43 00 00 00 2A 8D D0 FF BD 27 28 00 BE AF 24 00 B7 AF 20 00 B6 AF 2C 00 BF AF 1C 00 B5 AF 18 00 B4 AF 14 00 B3 AF 10 00 B2 AF 0C 00 B1 AF 08 00 B0 AF 21 B0 80 00 21 B8 A0 00 3C 00 40 11 21 F0 C0 00 00 00 43 8D 39 00 60 18 40 40 08 00 40 38 07 00 01 00 02 24 04 00 A7 AF 56 00 62 10 00 00 A8 AF ?? ?? 03 3C 80 10 05 00 ?? ?? 63 24 FF 7F 04 3C 21 A8 62 00 FF FF 91 34 21 A0 20 01 21 80 00 00 21 98 00 00 ?? ?? ?? 0? FF FF 12 24 04 00 C4 8C 2A 10 85 00 1B 00 40 10 04 00 A8 8F 23 10 A4 00 23 18 02 00 2C 10 43 00 2D 10 47 00 2A 18 51 00 0B 88 43 00 0B 90 03 02 00 00 8A 8E 01 00 10 26 00 00 42 8D 2A 10 02 02 24 00 40 10 00 00 00 00 40 00 02 26 80 10 02 00 21 10 42 01 04 00 46 8C 00 00 A5 8E 00 00 C2 8C 23 20 A2 00 23 18 04 00 2A 10 A2 00 E5 FF 40 10 2C 38 83 00 ?? ?? ?? 0? 04 00 C4 8C 00 00 A9 8F 01 00 73 26 21 28 00 02 21 20 C0 02 21 30 E0 02 ?? ?? ?? 0? 21 38 C0 03 05 00 62 2A E5 FF 40 54 00 00 8A 8E 2C 00 BF 8F 28 00 BE 8F 24 00 B7 8F 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 E0 03 30 00 BD 27 F4 FF 60 16 2C 00 BF 8F FF FF 02 24 F1 FF 42 12 04 00 A8 8F 00 00 A9 8F 21 20 C0 02 21 28 40 02 21 30 E0 02 21 38 C0 03 2C 00 BF 8F 28 00 BE 8F 24 00 B7 8F 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F ?? ?? ?? 0? 30 00 BD 27 21 30 A0 00 21 38 C0 03 04 00 A8 8F 00 00 A9 8F ?? ?? ?? 0? 21 28 00 00 }
	condition:
		$1
}

rule file_51_12_0 {
	meta:
		name = "load_patch"
		size = 2936
		refs = "0044 pack_fread 004c .rodata 0058 memcmp 0080 allegro_errno 00c8 _al_malloc 00e8 pack_igetw 0104 pack_getc 013c .bss 019c pack_igetl 0458 .text 066c lock_sample 0ae8 _al_free"
	strings:
		$1 = { 90 FE BD 27 30 00 A2 27 21 30 80 00 58 01 B4 AF 38 01 A5 AF 21 A0 80 00 16 00 05 24 21 20 40 00 6C 01 BF AF 68 01 BE AF 64 01 B7 AF 60 01 B6 AF 5C 01 B5 AF 54 01 B3 AF 50 01 B2 AF 4C 01 B1 AF 48 01 B0 AF ?? ?? ?? 0? 44 01 A2 AF ?? ?? 05 3C 30 00 A4 27 ?? ?? A5 24 ?? ?? ?? 0? 0C 00 06 24 07 00 40 14 ?? ?? 05 3C ?? ?? A5 24 3C 00 A4 27 ?? ?? ?? 0? 0A 00 06 24 13 00 40 10 00 00 00 00 ?? ?? 02 3C ?? ?? 43 8C 16 00 02 24 21 B8 00 00 00 00 62 AC 6C 01 BF 8F 21 10 E0 02 68 01 BE 8F 64 01 B7 8F 60 01 B6 8F 5C 01 B5 8F 58 01 B4 8F 54 01 B3 8F 50 01 B2 8F 4C 01 B1 8F 48 01 B0 8F 08 00 E0 03 70 01 BD 27 ?? ?? ?? 0? 08 02 04 24 80 02 40 10 21 B8 40 00 41 00 05 24 21 30 80 02 ?? ?? ?? 0? 30 00 A4 27 ?? ?? ?? 0? 21 20 80 02 04 02 E2 AE 6D 00 05 24 21 30 80 02 ?? ?? ?? 0? 30 00 A4 27 ?? ?? ?? 0? 21 20 80 02 00 00 E2 AE 30 00 A4 27 28 00 05 24 ?? ?? ?? 0? 21 30 80 02 00 00 E3 8E 41 00 62 28 63 01 40 10 40 00 02 24 D9 FF 60 18 6C 01 BF 8F 38 01 A4 8F ?? ?? 02 3C ?? ?? 42 24 FF FF 83 24 80 18 03 00 21 10 62 00 18 00 A5 27 3C 01 A2 AF 21 A8 E0 02 30 01 A0 AF 40 01 A5 AF 00 01 1E 24 ?? ?? ?? 0? 24 00 04 24 7E 02 40 10 04 00 A2 AE ?? ?? ?? 0? 28 00 04 24 77 02 40 10 04 01 A2 AE 08 00 05 24 21 30 80 02 ?? ?? ?? 0? 30 00 A4 27 04 00 B0 8E ?? ?? ?? 0? 21 20 80 02 04 00 B1 8E 10 00 02 AE ?? ?? ?? 0? 21 20 80 02 04 00 B0 8E 14 00 22 AE ?? ?? ?? 0? 21 20 80 02 04 00 B1 8E 18 00 02 AE ?? ?? ?? 0? 21 20 80 02 04 01 B0 8E 08 00 22 AE ?? ?? ?? 0? 21 20 80 02 04 01 B1 8E 00 00 02 AE ?? ?? ?? 0? 21 20 80 02 04 01 B0 8E 21 20 80 02 ?? ?? ?? 0? 04 00 22 AE 08 00 02 AE ?? ?? ?? 0? 21 20 80 02 21 20 80 02 ?? ?? ?? 0? 04 01 B0 8E 11 00 03 24 18 00 43 00 21 B0 A0 03 21 98 A0 03 12 10 00 00 24 00 02 AE ?? ?? ?? 0? 21 20 80 02 00 00 62 AE 40 01 A2 8F 04 00 73 26 FA FF 53 14 18 00 B0 27 ?? ?? ?? 0? 21 20 80 02 44 01 A3 8F 00 00 02 AE 04 00 10 26 FA FF 70 14 06 00 05 24 21 30 80 02 ?? ?? ?? 0? 30 00 A4 27 ?? ?? ?? 0? 21 20 80 02 FF 00 42 30 01 00 44 30 34 01 A2 AF 10 00 03 24 08 00 02 24 0B 10 64 00 34 01 A4 8F 04 00 B1 8E 04 01 B2 8E 04 00 85 30 00 00 22 AE 04 00 20 AE 03 00 A0 10 0C 00 40 AE 01 00 05 24 0C 00 45 AE 34 01 A3 8F 08 00 62 30 05 00 40 10 34 01 A4 8F 0C 00 42 8E 05 00 42 34 0C 00 42 AE 34 01 A4 8F 10 00 82 30 04 00 40 10 21 28 A0 03 0C 00 42 8E 03 00 42 34 0C 00 42 AE 00 00 A4 8C ?? ?? 02 3C ?? ?? 42 24 83 19 04 00 80 18 03 00 21 18 43 00 00 00 62 8C 3F 00 84 30 01 00 03 24 00 14 02 00 0A 20 64 00 02 00 80 14 1A 00 44 00 CD 01 00 00 12 10 00 00 03 13 02 00 00 00 A2 AC 04 00 A5 24 EE FF B3 54 00 00 A4 8C 34 01 A3 8F 20 00 62 30 DB 00 40 50 10 00 40 AE 38 01 A4 8F D8 00 80 54 10 00 40 AE 20 00 A7 8F 10 00 40 AE 03 00 08 24 18 00 47 AE 18 00 A2 8F 00 00 A6 8F 18 00 46 00 12 30 00 00 02 00 C0 17 1A 00 DE 00 CD 01 00 00 12 30 00 00 10 00 46 AE 1C 00 A3 8F 04 00 A5 8F 23 10 62 00 23 20 02 00 2C 10 44 00 18 00 45 00 23 18 E3 00 23 20 03 00 2C 18 64 00 12 10 00 00 02 00 C0 17 1A 00 5E 00 CD 01 00 00 12 10 00 00 21 30 C2 00 10 00 46 AE 08 00 A2 8F 14 00 40 AE 18 00 62 00 12 18 00 00 02 00 C0 17 1A 00 7E 00 CD 01 00 00 12 18 00 00 21 30 C3 00 10 00 46 AE 80 10 08 00 21 18 A2 03 18 00 65 8C 00 00 66 8C 14 00 44 8E 23 10 A7 00 23 18 02 00 2C 10 43 00 18 00 46 00 10 00 A5 28 12 10 00 00 02 00 C0 17 1A 00 5E 00 CD 01 00 00 12 10 00 00 21 20 82 00 1D 00 A0 14 14 00 44 AE 01 00 09 25 80 10 09 00 18 00 A3 27 21 40 A2 03 ?? ?? ?? 0? 21 38 62 00 00 00 E5 8C FC FF E2 8C 00 00 06 8D 14 00 44 8E 23 10 A2 00 23 18 02 00 2C 10 43 00 18 00 46 00 10 00 A5 28 04 00 E7 24 04 00 08 25 12 10 00 00 02 00 C0 17 1A 00 5E 00 CD 01 00 00 12 10 00 00 21 20 82 00 04 00 A0 14 14 00 44 AE 06 00 22 29 EB FF 40 14 01 00 29 25 18 00 43 8E 10 00 62 28 BC 00 40 10 C1 00 62 28 18 00 40 AE 14 00 42 8E 0A 00 42 28 01 00 40 54 14 00 40 AE 18 00 42 8E 09 00 40 14 00 00 00 00 10 00 42 8E 06 00 40 14 FE FF 03 24 0C 00 42 8E FF 00 04 24 24 10 43 00 18 00 44 AE 0C 00 42 AE ?? ?? ?? 0? 21 20 80 02 04 01 B0 8E 1C 00 42 AE ?? ?? ?? 0? 21 20 80 02 20 00 02 AE 38 01 A2 8F B3 00 40 14 3C 01 A4 8F 30 00 A4 27 24 00 05 24 ?? ?? ?? 0? 21 30 80 02 04 00 B1 8E 10 00 02 24 00 00 23 8E A0 00 62 50 10 00 25 8E 21 98 00 00 00 00 22 8E 10 00 23 8E 01 00 05 24 08 00 42 38 02 00 04 24 0A 20 A2 00 18 00 83 00 80 00 02 24 0C 00 22 AE 1C 00 20 AE ?? ?? ?? 0? 12 20 00 00 20 00 22 AE 04 00 B1 8E 20 00 32 8E 54 01 40 12 08 00 02 24 00 00 23 8E 33 01 62 50 10 00 25 8E 10 00 22 8E 0F 00 40 18 34 01 A3 8F ?? ?? ?? 0? 21 80 00 00 20 00 32 8E ?? ?? ?? 0? 21 20 80 02 04 00 B1 8E 40 18 10 00 01 00 10 26 10 00 24 8E 21 18 43 02 2A 20 04 02 F6 FF 80 14 00 00 62 A4 34 01 A3 8F 02 00 62 30 10 00 40 14 00 00 00 00 10 00 22 8E 0D 00 40 18 00 00 00 00 21 30 00 00 00 80 07 24 20 00 23 8E 40 28 06 00 10 00 24 8E 21 18 65 00 00 00 62 94 01 00 C6 24 2A 20 C4 00 26 10 47 00 F7 FF 80 14 00 00 62 A4 0A 01 60 16 00 00 00 00 30 01 A4 8F 00 00 E3 8E 04 00 B5 26 01 00 84 24 2A 10 83 00 C5 FE 40 14 30 01 A4 AF 8E FE 60 18 04 00 F1 26 21 80 00 00 00 00 24 8E 01 00 10 26 ?? ?? ?? 0? 04 00 31 26 00 00 E2 8E 2A 10 02 02 FA FF 40 54 00 00 24 8E 6C 01 BF 8F 21 10 E0 02 68 01 BE 8F 64 01 B7 8F 60 01 B6 8F 5C 01 B5 8F 58 01 B4 8F 54 01 B3 8F 50 01 B2 8F 4C 01 B1 8F 48 01 B0 8F 08 00 E0 03 70 01 BD 27 ?? ?? ?? 0? 00 00 E2 AE 18 00 40 AE 18 00 A4 8F 21 10 00 00 14 00 A7 27 23 10 82 00 21 28 00 00 19 00 40 04 06 00 08 24 02 00 A0 54 00 00 E2 8C 21 10 00 00 23 30 82 00 00 00 C2 8E 10 00 43 8E 10 00 84 28 18 00 C2 00 12 10 00 00 02 00 C0 17 1A 00 5E 00 CD 01 00 00 12 10 00 00 21 18 62 00 19 00 80 14 10 00 43 AE 01 00 A5 24 1E 00 A8 10 04 00 D6 26 08 00 E4 8C 04 00 E2 8C 23 10 82 00 E9 FF 41 04 04 00 E7 24 21 00 A0 54 00 00 E2 8C 21 10 00 00 23 30 44 00 00 00 C2 8E 10 00 43 8E 10 00 84 28 18 00 C2 00 12 10 00 00 02 00 C0 17 1A 00 5E 00 CD 01 00 00 12 10 00 00 21 18 62 00 E9 FF 80 10 10 00 43 AE 01 00 A8 24 06 00 02 29 4B FF 40 10 14 00 40 AE 80 10 05 00 21 18 A2 03 ?? ?? ?? 0? 18 00 67 8C 18 00 43 8E 10 00 62 28 47 FF 40 14 14 00 40 AE C1 00 62 28 46 FF 40 54 14 00 42 8E FF 00 02 24 ?? ?? ?? 0? 18 00 42 AE ?? ?? ?? 0? 23 30 44 00 14 00 22 8E 18 00 23 8E 42 20 05 00 42 10 02 00 42 18 03 00 10 00 24 AE 14 00 22 AE 18 00 23 AE ?? ?? ?? 0? 01 00 B3 30 04 00 AF 8E 04 01 AC 8E 00 00 83 8C 08 00 E4 8D 08 00 8A 8D FF FF 62 30 02 6C 04 00 18 00 4D 00 FF FF 8B 30 02 3C 03 00 12 18 00 00 00 24 03 00 02 1C 03 00 18 00 4B 00 12 10 00 00 21 20 82 00 2B 10 82 00 18 00 ED 00 12 28 00 00 02 00 40 10 21 30 65 00 01 00 C6 24 18 00 EB 00 12 10 00 00 00 1C 02 00 21 40 83 00 02 14 02 00 2B 20 04 01 02 00 80 10 21 18 C2 00 01 00 63 24 21 28 00 00 00 80 06 3C 21 38 00 00 20 00 09 24 23 20 6A 00 2B 10 64 00 02 00 40 50 25 28 A6 00 21 20 60 00 24 10 C8 00 01 00 E7 24 42 30 06 00 02 00 40 10 40 18 04 00 01 00 63 34 F5 FF E9 54 23 20 6A 00 20 00 8E 8D 00 04 02 24 5A 00 C2 11 40 38 05 00 1C 00 85 8D 02 24 05 00 18 00 8B 00 FF FF A8 30 12 18 00 00 00 2C 03 00 02 1C 03 00 18 00 0B 01 12 10 00 00 21 28 A2 00 2B 10 A2 00 18 00 8D 00 12 20 00 00 02 00 40 10 21 30 64 00 01 00 C6 24 18 00 0D 01 12 10 00 00 00 1C 02 00 21 48 A3 00 02 14 02 00 2B 20 25 01 02 00 80 10 21 18 C2 00 01 00 63 24 21 40 00 00 00 80 05 3C 21 30 00 00 20 00 0A 24 C4 FF 64 24 2B 10 64 00 02 00 40 50 25 40 05 01 21 20 60 00 24 10 A9 00 01 00 C6 24 42 28 05 00 02 00 40 10 40 18 04 00 01 00 63 34 F5 FF CA 14 C4 FF 64 24 40 50 08 00 23 28 EA 00 FF FF A2 30 02 24 0E 00 18 00 44 00 FF FF C8 31 02 3C 05 00 12 18 00 00 00 2C 03 00 02 1C 03 00 18 00 48 00 12 10 00 00 21 28 A2 00 2B 10 A2 00 18 00 E4 00 12 20 00 00 02 00 40 10 21 30 64 00 01 00 C6 24 18 00 E8 00 12 10 00 00 00 1C 02 00 21 40 A3 00 02 14 02 00 2B 20 05 01 02 00 80 10 21 18 C2 00 01 00 63 24 21 38 00 00 00 80 05 3C 21 30 00 00 20 00 09 24 00 FC 64 24 2B 10 64 00 02 00 40 50 25 38 E5 00 21 20 60 00 24 10 A8 00 01 00 C6 24 42 28 05 00 02 00 40 10 40 18 04 00 01 00 63 34 F5 FF C9 14 00 FC 64 24 40 10 07 00 21 38 4A 00 07 00 03 3C FF FF 63 34 2B 10 E3 00 BD FE 40 54 08 00 E7 AD 07 00 04 3C 42 38 07 00 FF FF 84 34 2B 10 E4 00 FC FF 40 10 07 00 04 3C ?? ?? ?? 0? 08 00 E7 AD ?? ?? ?? 0? 21 20 80 02 ?? ?? ?? 0? 30 01 A4 8F 21 20 40 02 ?? ?? ?? 0? 21 30 80 02 34 01 A5 8F 02 00 A3 30 EE FE 60 14 30 01 A4 8F 04 00 A3 8E 10 00 62 8C E9 FE 40 18 21 20 00 00 80 FF 05 24 20 00 63 8C 21 18 64 00 00 00 62 90 01 00 84 24 26 10 45 00 00 00 62 A0 04 00 A3 8E 10 00 62 8C 2A 10 82 00 F7 FF 40 54 20 00 63 8C ?? ?? ?? 0? 30 01 A4 8F ?? ?? 02 3C ?? ?? 44 8C 0C 00 03 24 ?? ?? ?? 0? 00 00 83 AC ?? ?? ?? 0? 21 20 20 02 30 01 A3 8F 40 00 62 24 80 10 02 00 21 10 E2 02 ?? ?? ?? 0? 04 00 44 8C 30 01 A4 8F 00 00 E4 AE ?? ?? ?? 0? 21 20 E0 02 ?? ?? 02 3C ?? ?? 43 8C 6C 01 BF 8F 21 B8 00 00 0C 00 02 24 00 00 62 AC 68 01 BE 8F 21 10 E0 02 64 01 B7 8F 60 01 B6 8F 5C 01 B5 8F 58 01 B4 8F 54 01 B3 8F 50 01 B2 8F 4C 01 B1 8F 48 01 B0 8F 08 00 E0 03 70 01 BD 27 30 01 A3 8F ?? ?? ?? 0? 80 10 03 00 30 01 A2 8F ?? ?? ?? 0? 00 00 E2 AE }
	condition:
		$1
}

rule file_51_13_0 {
	meta:
		name = "digmid_load_patches"
		size = 2632
		refs = "04ac .bss 0068 _digmid_find_patches 00c8 usetc 00f0 ustrzcpy 0100 ustrzcat 0110 pack_fopen 0634 $LC13 0180 pack_fgets 0198 ugetc 01b4 .text 01bc uwidth 0304 ugetx 0320 uisdigit 0358 uconvert 0344 $LC16 0364 ustricmp 03cc $LC14 0400 $LC15 044c ustrtol 048c pack_fclose 0498 ustrchr 0504 is_relative_filename 0544 get_extension 063c $LC18 0748 ustrlen 075c ugetat 0778 usetat 0780 $LC17 07d4 pack_mgetl 07f8 pack_feof 087c pack_fopen_chunk 08b4 pack_fclose_chunk 0940 pack_fseek 09ec pack_fread 0a14 do_uconvert"
	strings:
		$1 = { 03 00 03 3C 10 80 BD 27 20 91 63 34 D0 7F B2 AF EC 7F BF AF E8 7F BE AF E4 7F B7 AF E0 7F B6 AF DC 7F B5 AF D8 7F B4 AF D4 7F B3 AF CC 7F B1 AF C8 7F B0 AF 04 00 02 3C 23 E8 A3 03 04 00 03 3C D8 10 42 34 DC 10 63 34 C4 04 B2 27 21 10 5D 00 21 18 7D 00 00 00 44 AC 00 00 65 AC C4 00 A4 27 00 04 05 24 21 30 40 02 ?? ?? ?? 0? 00 04 07 24 11 00 40 14 04 00 04 3C FF FF 02 24 03 00 08 3C 20 91 08 35 21 E8 A8 03 EC 7F BF 8F E8 7F BE 8F E4 7F B7 8F E0 7F B6 8F DC 7F B5 8F D8 7F B4 8F D4 7F B3 8F D0 7F B2 8F CC 7F B1 8F C8 7F B0 8F 08 00 E0 03 F0 7F BD 27 C4 10 84 34 C4 10 B3 27 21 88 A4 03 21 80 60 02 ?? ?? 1E 3C ?? ?? C3 8F 21 20 00 02 21 28 00 00 09 F8 60 00 00 04 10 26 FB FF 11 16 ?? ?? C3 8F 00 04 05 24 C4 00 A6 27 ?? ?? ?? 0? C4 08 A4 27 C4 08 A4 27 21 30 40 02 ?? ?? ?? 0? 00 04 05 24 ?? ?? 02 3C C4 08 A4 27 ?? ?? ?? 0? ?? ?? 45 24 04 00 03 3C C8 10 63 34 21 18 7D 00 D4 FF 40 10 00 00 62 AC 04 00 04 3C 04 00 02 3C 04 00 03 3C D4 10 84 34 D0 10 42 34 CC 10 63 34 21 20 9D 00 21 10 5D 00 21 18 7D 00 ?? ?? 11 3C 00 00 80 AC 00 00 40 AC 00 00 60 AC 20 00 14 24 09 00 16 24 ?? ?? 15 3C 04 00 02 3C C8 10 42 34 21 10 5D 00 00 00 46 8C C4 08 A4 27 ?? ?? ?? 0? 00 04 05 24 BD 00 40 10 21 B8 00 00 C4 08 B0 27 3D 00 12 24 ?? ?? 23 8E 09 F8 60 00 21 20 00 02 52 00 40 10 10 00 E2 2A 08 00 40 14 ?? ?? 23 8E ?? ?? ?? 0? 04 00 A2 8F ?? ?? A3 8E 09 F8 60 00 21 20 00 02 21 80 02 02 ?? ?? 23 8E 09 F8 60 00 21 20 00 02 F8 FF 54 10 21 20 00 02 ?? ?? 23 8E 09 F8 60 00 00 00 00 00 F3 FF 56 10 21 20 00 02 ?? ?? 23 8E 09 F8 60 00 00 00 00 00 EF FF 52 10 ?? ?? A3 8E ?? ?? 04 3C ?? ?? 83 8C 09 F8 60 00 21 20 00 02 23 00 03 24 34 00 43 10 00 00 00 00 ?? ?? 04 3C ?? ?? 83 8C 09 F8 60 00 21 20 00 02 1B 00 40 10 ?? ?? 23 8E 80 10 17 00 04 00 A3 27 21 10 43 00 00 00 50 AC ?? ?? ?? 0? 01 00 F7 26 ?? ?? 23 8E 09 F8 60 00 00 00 00 00 14 00 54 10 21 20 00 02 ?? ?? 23 8E 09 F8 60 00 00 00 00 00 0F 00 56 10 21 20 00 02 ?? ?? 23 8E 09 F8 60 00 00 00 00 00 0A 00 52 10 21 20 00 02 ?? ?? A3 8E 09 F8 60 00 00 00 00 00 21 80 02 02 ?? ?? 23 8E 09 F8 60 00 21 20 00 02 E9 FF 40 14 21 20 00 02 ?? ?? 23 8E 09 F8 60 00 21 20 00 02 B6 FF 40 10 ?? ?? 23 8E ?? ?? C3 8F 21 20 00 02 09 F8 60 00 21 28 00 00 ?? ?? 23 8E 21 80 02 02 09 F8 60 00 21 20 00 02 B0 FF 40 14 10 00 E2 2A 9F FF E0 12 04 00 02 3C 04 00 A2 8F 2D 00 12 24 00 00 A2 AF ?? ?? 04 3C ?? ?? 83 8C 09 F8 60 00 21 20 A0 03 21 80 40 00 27 00 40 10 21 20 40 00 ?? ?? ?? 0? 00 00 00 00 F7 FF 40 14 ?? ?? 04 3C F6 FF 12 12 ?? ?? 83 8C 04 00 B0 8F 75 63 07 3C 53 41 05 3C ?? ?? 04 3C 2E 72 E7 34 38 43 A5 34 44 00 A6 27 80 00 08 24 ?? ?? ?? 0? ?? ?? 84 24 21 28 40 00 ?? ?? ?? 0? 21 20 00 02 04 00 03 3C D0 10 63 34 21 18 7D 00 00 00 64 8C 04 00 03 3C D0 10 63 34 0A 20 02 00 21 18 7D 00 00 00 64 AC 04 00 03 3C D4 10 63 34 21 18 7D 00 00 00 64 8C 04 00 03 3C D4 10 63 34 0A 20 02 00 21 18 7D 00 ?? ?? ?? 0? 00 00 64 AC 01 00 02 24 DE FF E2 12 75 63 17 3C 08 00 B0 8F 53 41 12 3C ?? ?? 04 3C ?? ?? 84 24 38 43 45 36 44 00 A6 27 2E 72 E7 36 ?? ?? ?? 0? 80 00 08 24 21 28 40 00 ?? ?? ?? 0? 21 20 00 02 14 00 40 50 04 00 A4 8F 08 00 B0 8F ?? ?? 04 3C 38 43 45 36 ?? ?? 84 24 44 00 A6 27 2E 72 E7 36 ?? ?? ?? 0? 80 00 08 24 21 28 40 00 ?? ?? ?? 0? 21 20 00 02 94 00 40 14 04 00 03 3C 04 00 04 3C D0 10 84 34 FF FF 02 24 21 20 9D 00 ?? ?? ?? 0? 00 00 82 AC 21 28 00 00 ?? ?? ?? 0? 0A 00 06 24 04 00 03 3C FF FF 44 24 CC 10 63 34 04 00 02 3C 21 18 7D 00 D4 10 42 34 00 00 64 AC 21 10 5D 00 FF FF 03 24 ?? ?? ?? 0? 00 00 43 AC 04 00 03 3C C8 10 63 34 21 18 7D 00 ?? ?? ?? 0? 00 00 64 8C C4 00 A4 27 ?? ?? ?? 0? 23 00 05 24 A9 00 40 14 04 00 03 3C E0 10 63 34 ?? ?? 14 3C ?? ?? 04 3C 21 18 7D 00 ?? ?? 94 26 01 00 17 24 00 00 64 AC ?? ?? ?? 0? 00 01 16 24 01 00 F7 26 01 01 02 24 21 98 A0 02 66 00 E2 12 04 00 94 26 04 00 02 3C E0 10 42 34 21 10 5D 00 00 00 42 8C ?? ?? 43 8C 09 F8 60 00 21 20 60 02 F3 FF 40 10 00 04 75 26 ?? ?? ?? 0? 21 20 60 02 3C 00 40 10 C4 0C A4 27 C4 00 A6 27 ?? ?? ?? 0? 00 04 05 24 C4 0C A4 27 00 04 05 24 ?? ?? ?? 0? 21 30 60 02 04 00 03 3C E0 10 63 34 21 18 7D 00 00 00 63 8C C4 0C A4 27 ?? ?? ?? 0? ?? ?? 70 8C 09 F8 00 02 21 20 40 00 39 00 40 50 53 41 05 3C ?? ?? 05 3C C4 0C A4 27 ?? ?? ?? 0? ?? ?? A5 24 0B 00 40 10 21 80 40 00 FF FF E2 26 80 00 42 28 02 00 40 10 80 FF E5 26 21 28 00 00 ?? ?? ?? 0? 21 20 00 02 00 00 82 AE ?? ?? ?? 0? 21 20 00 02 35 00 F6 12 21 88 E0 02 ?? ?? 04 3C 00 04 75 26 80 10 17 00 ?? ?? 84 24 21 90 82 00 ?? ?? ?? 0? 21 80 A0 02 C2 FF 36 12 04 00 52 26 21 28 00 02 21 20 60 02 ?? ?? ?? 0? 01 00 31 26 F9 FF 40 54 00 04 10 26 00 00 82 8E ?? ?? C3 8F 21 20 00 02 00 00 42 AE 09 F8 60 00 21 28 00 00 ?? ?? ?? 0? 00 04 10 26 00 04 05 24 ?? ?? ?? 0? 21 30 60 02 04 00 03 3C E0 10 63 34 21 18 7D 00 00 00 63 8C C4 0C A4 27 ?? ?? ?? 0? ?? ?? 70 8C 09 F8 00 02 21 20 40 00 CB FF 40 54 ?? ?? 05 3C 53 41 05 3C ?? ?? 04 3C 75 63 07 3C 44 00 A6 27 38 43 A5 34 ?? ?? 84 24 2E 72 E7 34 ?? ?? ?? 0? 80 00 08 24 21 30 40 00 C4 0C A4 27 ?? ?? ?? 0? 00 04 05 24 ?? ?? ?? 0? ?? ?? 05 3C ?? ?? ?? 0? 21 10 00 00 D0 10 63 34 21 18 7D 00 00 00 63 8C B9 FE 60 14 04 00 02 3C 04 00 A4 8F 21 28 00 00 ?? ?? ?? 0? 0A 00 06 24 21 20 40 00 04 00 02 3C D4 10 42 34 21 10 5D 00 00 00 42 8C 01 00 40 50 FF FF 84 24 80 00 82 2C AB FE 40 10 04 00 02 3C 04 00 03 3C D4 10 63 34 21 18 7D 00 00 00 63 8C D2 00 60 10 04 00 03 3C DC 10 63 34 21 18 7D 00 00 00 63 8C 21 10 64 00 00 00 43 80 9E FE 60 10 04 00 02 3C CC 10 42 34 21 10 5D 00 00 00 42 8C 21 20 82 00 ?? ?? 03 3C ?? ?? 63 24 80 10 04 00 21 10 43 00 00 00 43 8C 93 FE 60 54 04 00 02 3C 08 00 A6 8F C4 10 A2 27 80 22 04 00 21 20 44 00 ?? ?? ?? 0? 00 04 05 24 ?? ?? ?? 0? 04 00 02 3C ?? ?? ?? 0? C4 00 A4 27 02 00 42 28 0A 00 40 14 C4 00 A4 27 ?? ?? ?? 0? FF FF 05 24 23 00 03 24 06 00 43 14 ?? ?? 05 3C C4 00 A4 27 FF FF 05 24 ?? ?? ?? 0? 21 30 00 00 ?? ?? 05 3C ?? ?? A5 24 ?? ?? ?? 0? C4 00 A4 27 39 FE 40 10 21 90 40 00 ?? ?? 02 3C 04 00 04 3C E0 10 84 34 ?? ?? 45 8C 21 20 9D 00 00 00 82 AC 09 F8 A0 00 C4 00 A4 27 23 00 03 24 7A 00 43 10 C4 00 A4 27 ?? ?? ?? 0? 23 00 05 24 7B 00 40 10 00 00 00 00 ?? ?? ?? 0? 21 20 40 02 ?? ?? C6 8F C4 0C B6 27 21 20 C0 02 09 F8 C0 00 21 28 00 00 72 70 02 3C 70 6F 57 34 ?? ?? ?? 0? 21 20 40 02 1E FE 40 14 21 10 00 00 ?? ?? ?? 0? 21 20 40 02 57 00 57 10 41 50 04 3C 20 54 84 34 45 00 44 14 21 80 00 00 ?? ?? ?? 0? 21 98 00 00 00 01 02 24 40 00 02 12 00 04 73 26 04 00 02 3C E0 10 42 34 21 10 5D 00 00 00 42 8C C4 10 A4 27 21 88 93 00 ?? ?? 43 8C 09 F8 60 00 21 20 20 02 F3 FF 40 50 01 00 10 26 21 28 20 02 ?? ?? ?? 0? 21 20 C0 02 EE FF 40 54 01 00 10 26 21 20 40 02 ?? ?? ?? 0? 21 28 00 00 21 88 40 00 80 00 02 2A 02 00 40 10 81 FF 05 26 21 28 00 00 ?? ?? ?? 0? 21 20 20 02 ?? ?? 04 3C 80 18 10 00 ?? ?? 84 24 21 A8 83 00 00 00 A2 AE ?? ?? ?? 0? 21 20 20 02 01 00 10 26 21 90 40 00 00 01 02 2A 21 00 40 10 80 12 10 00 C4 10 A4 27 21 88 82 00 ?? ?? 02 3C 80 18 10 00 ?? ?? 42 24 21 A0 93 00 21 98 43 00 21 28 20 02 21 20 80 02 ?? ?? ?? 0? 01 00 10 26 08 00 40 14 00 01 02 2A 00 00 A2 8E ?? ?? C3 8F 21 20 20 02 00 00 62 AE 09 F8 60 00 21 28 00 00 00 01 02 2A 00 04 31 26 F1 FF 40 14 04 00 73 26 ?? ?? ?? 0? ?? ?? C3 8F ?? ?? ?? 0? 21 20 40 02 04 00 45 24 ?? ?? ?? 0? 21 20 40 02 ?? ?? ?? 0? 00 00 00 00 C4 10 A2 27 21 A0 53 00 ?? ?? C3 8F 21 20 80 02 09 F8 60 00 21 28 00 00 ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 21 20 40 02 21 20 40 02 ?? ?? ?? 0? 21 80 40 00 41 4E 03 3C 45 4D 63 34 15 00 03 12 21 88 40 00 21 28 40 00 ?? ?? ?? 0? 21 20 40 02 ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? C4 00 A4 27 01 00 03 24 83 FF 43 14 C4 00 A4 27 ?? ?? ?? 0? 21 20 40 02 4C 41 03 3C 2E 4C 63 34 81 FF 43 10 00 00 00 00 ?? ?? ?? 0? 21 20 40 02 ?? ?? ?? 0? FF FF 02 24 C4 08 A4 27 21 30 40 02 ?? ?? ?? 0? 21 28 40 00 21 18 B1 03 53 41 05 3C 75 63 07 3C C4 08 A4 27 38 43 A5 34 21 30 C0 02 2E 72 E7 34 00 04 08 24 ?? ?? ?? 0? C4 08 60 A0 ?? ?? ?? 0? 00 00 00 00 D8 10 63 34 21 18 7D 00 00 00 63 8C 21 10 64 00 00 00 43 80 35 FF 60 14 ?? ?? 03 3C ?? ?? ?? 0? 04 00 02 3C }
	condition:
		$1
}

rule file_52_1_0 {
	meta:
		name = "psp_joy_poll"
		size = 124
		refs = "000c sceCtrlPeekBufferPositive 0018 joy 001c psp_controller_buttons"
	strings:
		$1 = { E8 FF BD 27 01 00 05 24 14 00 BF AF ?? ?? ?? 0? 21 20 A0 03 04 00 A5 8F ?? ?? 02 3C ?? ?? 03 3C ?? ?? 47 24 ?? ?? 69 24 21 30 00 00 40 00 08 24 21 10 26 01 04 00 43 8C 21 20 E6 00 08 00 C6 24 24 18 65 00 FA FF C8 14 38 01 83 AC 14 00 BF 8F 40 00 A2 30 80 00 A3 30 20 00 A4 30 10 00 A5 30 2C 00 E2 AC 18 00 E3 AC 21 10 00 00 1C 00 E4 AC 28 00 E5 AC 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_52_2_0 {
	meta:
		name = "_psp_init_controller"
		size = 40
		refs = "000c sceCtrlSetSamplingCycle 0020 sceCtrlSetSamplingMode"
	strings:
		$1 = { F8 FF BD 27 00 00 B0 AF 04 00 BF AF ?? ?? ?? 0? 21 80 A0 00 21 20 00 02 04 00 BF 8F 00 00 B0 8F ?? ?? ?? 0? 08 00 BD 27 }
	condition:
		$1
}

rule file_52_3_0 {
	meta:
		name = "psp_joy_init"
		size = 164
		refs = "000c _psp_init_controller 0014 num_joysticks 0020 joy 0024 psp_controller_buttons 005c $LC2 0074 $LC0 0078 $LC1"
	strings:
		$1 = { F8 FF BD 27 21 20 00 00 04 00 BF AF ?? ?? ?? 0? 21 28 00 00 ?? ?? 02 3C 01 00 04 24 ?? ?? 44 AC ?? ?? 03 3C ?? ?? 02 3C ?? ?? 67 24 ?? ?? 49 24 21 30 00 00 40 00 08 24 21 18 26 01 08 00 E2 8C 00 00 65 8C 21 20 E6 00 01 00 42 24 08 00 C6 24 3C 01 85 AC F8 FF C8 14 08 00 E2 AC ?? ?? 02 3C ?? ?? 42 24 02 00 03 24 04 00 BF 8F 44 00 E2 AC 10 00 E3 AC ?? ?? 02 3C ?? ?? 03 3C 01 00 04 24 ?? ?? 42 24 ?? ?? 63 24 20 00 E2 AC 0C 00 E4 AC 21 10 00 00 30 00 E3 AC 04 00 E4 AC 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_53_0_0 {
	meta:
		name = "psp_mouse_position"
		size = 88
		refs = "0008 _mouse_x 0018 _mouse_y"
	strings:
		$1 = { ?? ?? 03 3C 07 00 81 04 ?? ?? 64 AC ?? ?? 60 AC ?? ?? 03 3C 0A 00 A1 04 ?? ?? 65 AC 08 00 E0 03 ?? ?? 60 AC E0 01 82 28 F9 FF 40 14 DF 01 02 24 ?? ?? 62 AC ?? ?? 03 3C F8 FF A0 04 ?? ?? 65 AC 10 01 A2 28 02 00 40 14 0F 01 02 24 ?? ?? 62 AC 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_53_4_0 {
	meta:
		name = "psp_mouse_timer_poll"
		size = 1372
		refs = "0004 .bss 0020 sceCtrlPeekBufferPositive 0068 __floatsidf 0074 sqrt 0080 __fixdfsi 008c $LC0 00f4 _mouse_x 00f8 _mouse_y 0158 $LC5 0184 $LC9 01ac .text 01b4 sceCtrlReadBufferPositive 01cc _mouse_b 0264 atan2f 026c __extendsfdf2 0274 $LC1 0284 __adddf3 028c $LC2 029c __divdf3 02a4 $LC3 02b4 __muldf3 02c0 __truncdfsf2 02c8 $LC4 02e8 $LC6 0300 $LC11 0314 $LC12 0340 $LC7 0348 $LC10 03c0 $LC8 03f4 $LC13 0414 $LC14 042c $LC15 0440 $LC16 0198 $LC17 0514 $LC18"
	strings:
		$1 = { E8 FF BD 27 ?? ?? 04 3C 08 00 B0 AF ?? ?? 90 24 21 20 00 02 01 00 05 24 14 00 BF AF 10 00 B2 AF ?? ?? ?? 0? 0C 00 B1 AF 04 00 03 8E 61 00 60 54 21 20 00 02 08 00 02 92 09 00 04 92 ?? ?? 11 3C 80 FF 42 24 18 00 42 00 80 FF 84 24 ?? ?? 24 AE ?? ?? 10 3C ?? ?? 02 AE ?? ?? 12 3C 12 18 00 00 18 00 84 00 12 20 00 00 ?? ?? ?? 0? 21 20 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 00 00 82 44 ?? ?? 02 3C 60 00 80 46 ?? ?? 40 C4 3C 00 01 46 00 00 00 00 1D 00 01 45 ?? ?? 41 E6 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 82 8C 62 00 40 04 ?? ?? 03 3C E0 01 42 28 02 00 40 14 DF 01 02 24 ?? ?? 62 AC ?? ?? A2 8C 4E 00 40 04 ?? ?? 03 3C 10 01 42 28 02 00 40 14 0F 01 02 24 ?? ?? 62 AC ?? ?? 84 8C ?? ?? A5 8C 14 00 BF 8F ?? ?? 02 3C ?? ?? 03 3C 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F ?? ?? 44 AC ?? ?? 65 AC 08 00 E0 03 18 00 BD 27 ?? ?? 24 8E ?? ?? 02 8E 18 00 84 00 12 20 00 00 18 00 42 00 12 10 00 00 ?? ?? ?? 0? 21 20 44 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 1F 00 42 28 3C 00 40 10 ?? ?? 02 3C ?? ?? 40 C4 ?? ?? 03 3C C6 00 00 46 ?? ?? 60 E4 00 00 80 44 00 00 00 00 32 18 00 46 00 00 00 00 C1 00 01 45 ?? ?? 04 3C ?? ?? 02 3C ?? ?? 40 C4 32 18 00 46 00 00 00 00 DB 00 00 45 ?? ?? 02 3C ?? ?? 05 3C ?? ?? A2 8C ?? ?? 04 3C F6 FF 42 24 ?? ?? ?? 0? ?? ?? A2 AC ?? ?? ?? 0? 01 00 05 24 04 00 03 8E ?? ?? 04 3C 00 01 62 30 03 00 40 10 ?? ?? 80 AC 01 00 02 24 ?? ?? 82 AC 00 02 62 30 04 00 40 50 04 00 02 8E 02 00 02 24 ?? ?? 82 AC 04 00 02 8E 00 03 03 24 00 03 42 30 8F FF 43 54 08 00 02 92 04 00 02 24 ?? ?? ?? 0? ?? ?? 82 AC ?? ?? 60 AC ?? ?? 84 8C ?? ?? A5 8C 14 00 BF 8F ?? ?? 02 3C ?? ?? 03 3C 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F ?? ?? 44 AC ?? ?? 65 AC 08 00 E0 03 18 00 BD 27 ?? ?? ?? 0? ?? ?? 60 AC ?? ?? 02 8E ?? ?? 31 8E 23 10 02 00 00 00 82 44 00 00 B1 AF 60 03 80 46 00 00 91 44 ?? ?? ?? 0? 20 03 80 46 ?? ?? ?? 0? 06 03 00 46 ?? ?? 04 3C ?? ?? 86 8C ?? ?? 87 8C 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 ?? ?? 04 3C ?? ?? 86 8C ?? ?? 87 8C 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 ?? ?? 04 3C ?? ?? 86 8C ?? ?? 87 8C 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 ?? ?? 04 3C ?? ?? 85 C4 ?? ?? 02 3C C6 00 00 46 3E 28 00 46 00 00 00 00 07 00 00 45 ?? ?? 40 E4 ?? ?? 02 3C ?? ?? 40 C4 3E 18 00 46 00 00 00 00 29 00 01 45 ?? ?? 02 3C ?? ?? 02 3C ?? ?? 40 C4 3E 00 03 46 00 00 00 00 38 00 00 45 ?? ?? 02 3C ?? ?? 40 C4 3E 18 00 46 00 00 00 00 34 00 00 45 ?? ?? 02 3C ?? ?? 02 3C ?? ?? 41 C4 ?? ?? 02 3C ?? ?? 42 C4 41 18 01 46 ?? ?? 02 3C ?? ?? 40 C4 ?? ?? 02 3C 83 08 02 46 43 08 00 46 ?? ?? 45 C4 ?? ?? 04 3C ?? ?? 80 C4 ?? ?? 05 3C 42 08 05 46 E0 00 80 46 ?? ?? A0 C4 20 01 80 46 00 00 80 44 40 08 05 46 80 10 00 46 82 10 05 46 C0 18 02 46 00 21 01 46 CD 18 00 46 0D 21 00 46 ?? ?? 83 E4 ?? ?? ?? 0? ?? ?? A4 E4 ?? ?? 42 C4 ?? ?? 02 3C ?? ?? 41 C4 83 18 02 46 ?? ?? 04 3C 43 18 01 46 ?? ?? 80 C4 ?? ?? 05 3C ?? ?? 02 3C E0 00 80 46 ?? ?? A0 C4 20 01 80 46 00 00 80 44 80 10 05 46 40 08 00 46 ?? ?? 40 C4 ?? ?? 02 3C 82 10 00 46 ?? ?? 40 C4 ?? ?? ?? 0? 42 08 00 46 ?? ?? 02 3C ?? ?? 40 C4 3E 00 03 46 00 00 00 00 3D 00 00 45 01 00 03 24 FF 00 62 30 06 00 40 10 ?? ?? 02 3C ?? ?? 40 C4 3E 18 00 46 00 00 00 00 1C 00 01 45 ?? ?? 02 3C ?? ?? 02 3C ?? ?? 40 C4 3E 00 03 46 00 00 00 00 4B FF 00 45 ?? ?? 02 3C ?? ?? 40 C4 3E 18 00 46 00 00 00 00 46 FF 00 45 ?? ?? 02 3C ?? ?? 41 C4 ?? ?? 02 3C ?? ?? 42 C4 41 18 01 46 ?? ?? 02 3C ?? ?? 40 C4 ?? ?? 02 3C 83 08 02 46 ?? ?? 45 C4 ?? ?? ?? 0? 43 08 00 46 ?? ?? 82 8C ?? ?? 05 3C 0A 00 42 24 ?? ?? ?? 0? ?? ?? 82 AC ?? ?? 41 C4 ?? ?? 02 3C ?? ?? 42 C4 41 18 01 46 ?? ?? 02 3C ?? ?? 40 C4 ?? ?? 85 C4 83 08 02 46 43 08 00 46 ?? ?? 04 3C ?? ?? 80 C4 ?? ?? 05 3C ?? ?? 02 3C E0 00 80 46 ?? ?? A0 C4 20 01 80 46 00 00 80 44 80 10 05 46 40 08 00 46 ?? ?? 40 C4 ?? ?? 02 3C 82 10 00 46 ?? ?? 40 C4 ?? ?? ?? 0? 42 08 00 46 ?? ?? ?? 0? 00 00 03 24 ?? ?? 40 C4 32 18 00 46 00 00 00 00 07 00 00 45 ?? ?? 02 3C ?? ?? 04 3C ?? ?? 82 8C ?? ?? 05 3C F6 FF 42 24 ?? ?? ?? 0? ?? ?? 82 AC ?? ?? 40 C6 ?? ?? 41 C4 32 00 01 46 00 00 00 00 DA FE 00 45 ?? ?? 04 3C ?? ?? 05 3C ?? ?? A2 8C 0A 00 42 24 ?? ?? ?? 0? ?? ?? A2 AC }
	condition:
		$1
}

rule file_53_5_0 {
	meta:
		name = "psp_mouse_init"
		size = 40
		refs = "0008 sceCtrlSetSamplingCycle 0010 sceCtrlSetSamplingMode"
	strings:
		$1 = { F8 FF BD 27 04 00 BF AF ?? ?? ?? 0? 21 20 00 00 ?? ?? ?? 0? 01 00 04 24 04 00 BF 8F 03 00 02 24 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_0_3_115 {
	meta:
		name = "sdl_psp_exit_callback"
		size = 16
		refs = "0008 exit"
	strings:
		$1 = { F8 FF BD 27 04 00 BF AF ?? ?? ?? 0? 21 20 00 00 }
	condition:
		$1
}

rule file_54_1_0 {
	meta:
		name = "length"
		size = 112
		refs = "0020 .text 0024 ugetxc"
	strings:
		$1 = { E8 FF BD 27 10 00 B2 AF 0C 00 B1 AF 08 00 B0 AF 14 00 BF AF 00 00 A5 AF 21 88 80 00 21 80 00 00 ?? ?? ?? 0? ?? ?? 12 3C 08 00 22 8E 04 00 43 8C 09 F8 60 00 00 00 00 00 21 80 02 02 ?? ?? 43 8E 09 F8 60 00 21 20 A0 03 21 28 40 00 F6 FF 40 14 21 20 20 02 14 00 BF 8F 21 10 00 02 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_54_2_0 {
	meta:
		name = "_mono_find_glyph"
		size = 116
		refs = "0000 allegro_404_char 0050 .text"
		altNames = "_color_find_glyph"
	strings:
		$1 = { ?? ?? 02 3C 00 00 84 8C ?? ?? 47 8C 21 30 A0 00 0D 00 80 10 00 00 00 00 21 18 80 00 00 00 85 8C 2A 10 C5 00 06 00 40 54 0C 00 63 8C 04 00 62 8C 2A 10 C2 00 08 00 40 54 08 00 63 8C 0C 00 63 8C F7 FF 60 54 00 00 65 8C 08 00 C7 10 21 30 E0 00 ?? ?? ?? 0? 00 00 00 00 23 10 C5 00 80 10 02 00 21 18 62 00 08 00 E0 03 00 00 62 8C 08 00 E0 03 21 10 00 00 }
	condition:
		$1
}

rule file_54_3_0 {
	meta:
		name = "mono_char_length"
		size = 128
		refs = "0000 allegro_404_char 0050 .text"
	strings:
		$1 = { ?? ?? 02 3C 00 00 84 8C ?? ?? 47 8C 21 30 A0 00 0D 00 80 10 00 00 00 00 21 18 80 00 00 00 85 8C 2A 10 C5 00 06 00 40 54 0C 00 63 8C 04 00 62 8C 2A 10 C2 00 08 00 40 54 08 00 63 8C 0C 00 63 8C F7 FF 60 54 00 00 65 8C 0B 00 C7 10 21 30 E0 00 ?? ?? ?? 0? 00 00 00 00 23 10 C5 00 80 10 02 00 21 18 62 00 00 00 62 8C 03 00 40 10 00 00 00 00 08 00 E0 03 00 00 42 84 08 00 E0 03 21 10 00 00 }
	condition:
		$1
}

rule file_54_4_0 {
	meta:
		name = "mono_render_char"
		size = 336
		refs = "0058 allegro_404_char 00a4 .text"
	strings:
		$1 = { E0 FF BD 27 04 00 B1 AF 21 88 00 01 1C 00 08 8D 18 00 B6 AF 14 00 B5 AF 10 00 02 8D 10 00 B4 AF 0C 00 B3 AF 08 00 B2 AF 00 00 B0 AF 1C 00 BF AF 21 90 80 00 21 80 A0 00 21 A0 C0 00 21 A8 E0 00 21 98 20 01 04 00 40 10 21 B0 40 01 09 F8 40 00 21 20 20 02 1C 00 28 8E ?? ?? 02 3C ?? ?? 46 8C 00 00 44 8E 0D 00 80 10 00 00 00 00 21 18 80 00 00 00 85 8C 2A 10 05 02 06 00 40 54 0C 00 63 8C 04 00 62 8C 2A 10 02 02 08 00 40 54 08 00 63 8C 0C 00 63 8C F7 FF 60 54 00 00 65 8C 1A 00 06 52 21 80 00 00 ?? ?? ?? 0? 21 80 C0 00 23 10 05 02 80 10 02 00 21 18 62 00 00 00 70 8C 22 00 00 12 02 00 02 24 02 00 03 86 04 00 47 8E 78 00 0A 8D 23 38 E3 00 02 00 40 14 1A 00 E2 00 CD 01 00 00 21 40 80 02 21 28 00 02 21 30 60 02 21 48 A0 02 21 20 20 02 12 38 00 00 09 F8 40 01 21 38 C7 02 00 00 10 86 1C 00 28 8E 14 00 02 8D 04 00 40 10 1C 00 BF 8F 09 F8 40 00 21 20 20 02 1C 00 BF 8F 21 10 00 02 18 00 B6 8F 14 00 B5 8F 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 20 00 BD 27 ?? ?? ?? 0? 21 80 00 00 }
	condition:
		$1
}

rule file_54_5_0 {
	meta:
		name = "mono_render"
		size = 220
		refs = "0054 .text 0058 ugetxc"
	strings:
		$1 = { 1C 00 02 8D D8 FF BD 27 20 00 B6 AF 10 00 42 8C 1C 00 B5 AF 18 00 B4 AF 10 00 B2 AF 0C 00 B1 AF 08 00 B0 AF 24 00 BF AF 14 00 B3 AF 21 88 00 01 00 00 A5 AF 21 90 80 00 21 B0 C0 00 21 A8 E0 00 21 80 20 01 03 00 40 10 21 A0 40 01 09 F8 40 00 21 20 00 01 ?? ?? ?? 0? ?? ?? 13 3C 08 00 42 8E 0C 00 43 8C 09 F8 60 00 00 00 00 00 21 80 02 02 ?? ?? 63 8E 09 F8 60 00 21 20 A0 03 21 28 40 00 21 48 00 02 21 20 40 02 21 30 C0 02 21 38 A0 02 21 40 20 02 F1 FF 40 14 21 50 80 02 1C 00 22 8E 14 00 42 8C 04 00 40 10 24 00 BF 8F 09 F8 40 00 21 20 20 02 24 00 BF 8F 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_54_6_0 {
	meta:
		name = "mono_get_font_ranges"
		size = 48
		altNames = "color_get_font_ranges"
	strings:
		$1 = { 03 00 80 54 00 00 84 8C 08 00 E0 03 FF FF 02 24 FD FF 80 10 00 00 00 00 21 10 00 00 0C 00 84 8C FE FF 80 14 01 00 42 24 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_54_7_0 {
	meta:
		name = "mono_get_font_range_begin"
		size = 104
		refs = "0034 .text"
		altNames = "color_get_font_range_begin"
	strings:
		$1 = { 03 00 80 54 00 00 84 8C 08 00 E0 03 FF FF 02 24 FD FF 80 10 00 00 00 00 0C 00 86 8C 10 00 C0 10 00 00 00 00 21 10 00 00 2C 28 A2 00 0C 00 A0 10 21 18 00 00 ?? ?? ?? 0? 01 00 63 24 08 00 65 10 21 30 40 00 01 00 63 24 2A 10 A3 00 EE FF 40 14 00 00 00 00 0C 00 C2 8C F8 FF 40 14 21 20 C0 00 08 00 E0 03 00 00 82 8C }
	condition:
		$1
}

rule file_54_8_0 {
	meta:
		name = "mono_get_font_range_end"
		size = 92
		refs = "0018 .text"
		altNames = "color_get_font_range_end"
	strings:
		$1 = { 03 00 80 54 00 00 84 8C 08 00 E0 03 FF FF 02 24 FD FF 80 10 21 18 00 00 ?? ?? ?? 0? FF FF 06 24 0C 00 40 50 04 00 82 8C 09 00 A3 10 01 00 63 24 21 20 40 00 2A 10 A3 00 F9 FF 40 50 0C 00 82 8C F7 FF A6 50 0C 00 82 8C ?? ?? ?? 0? 00 00 00 00 04 00 82 8C 08 00 E0 03 FF FF 42 24 }
	condition:
		$1
}

rule file_54_9_0 {
	meta:
		name = "mono_transpose_font"
		size = 72
		altNames = "color_transpose_font"
	strings:
		$1 = { 0F 00 80 10 00 00 00 00 00 00 86 8C 0A 00 C0 10 00 00 00 00 00 00 C2 8C 04 00 C3 8C 0C 00 C4 8C 21 10 45 00 21 18 65 00 04 00 C3 AC 00 00 C2 AC F8 FF 80 14 21 30 80 00 08 00 E0 03 21 10 00 00 08 00 E0 03 FF FF 02 24 }
	condition:
		$1
}

rule file_54_11_0 {
	meta:
		name = "color_char_length"
		size = 128
		refs = "0000 allegro_404_char 0050 .text"
	strings:
		$1 = { ?? ?? 02 3C 00 00 84 8C ?? ?? 47 8C 21 30 A0 00 0D 00 80 10 00 00 00 00 21 18 80 00 00 00 85 8C 2A 10 C5 00 06 00 40 54 0C 00 63 8C 04 00 62 8C 2A 10 C2 00 08 00 40 54 08 00 63 8C 0C 00 63 8C F7 FF 60 54 00 00 65 8C 0B 00 C7 10 21 30 E0 00 ?? ?? ?? 0? 00 00 00 00 23 10 C5 00 80 10 02 00 21 18 62 00 00 00 62 8C 03 00 40 10 00 00 00 00 08 00 E0 03 00 00 42 8C 08 00 E0 03 21 10 00 00 }
	condition:
		$1
}

rule file_54_12_0 {
	meta:
		name = "trans_render_char"
		size = 456
		refs = "00a8 allegro_404_char 00f4 .text"
	strings:
		$1 = { 08 00 82 8C E0 FF BD 27 18 00 B6 AF 00 00 43 8C 14 00 B5 AF 10 00 B4 AF 0C 00 B3 AF 08 00 B2 AF 04 00 B1 AF 00 00 B0 AF 1C 00 BF AF 21 88 00 01 21 90 80 00 21 80 A0 00 21 98 E0 00 21 A8 20 01 09 F8 60 00 21 A0 40 01 21 B0 40 00 1C 00 22 8E 10 00 42 8C 03 00 40 10 00 00 00 00 09 F8 40 00 21 20 20 02 10 00 60 06 21 20 40 02 08 00 42 8E 04 00 43 8C 09 F8 60 00 21 28 00 02 1C 00 24 8E FF FF A7 26 FF FF 88 26 3C 00 83 8C 21 38 E2 00 21 40 16 01 21 48 60 02 21 20 20 02 21 28 A0 02 09 F8 60 00 21 30 80 02 ?? ?? 02 3C 00 00 44 8E ?? ?? 46 8C 0D 00 80 10 00 00 00 00 21 18 80 00 00 00 85 8C 2A 10 05 02 06 00 40 54 0C 00 63 8C 04 00 62 8C 2A 10 02 02 08 00 40 54 08 00 63 8C 0C 00 63 8C F7 FF 60 54 00 00 65 8C 1B 00 06 52 21 80 00 00 ?? ?? ?? 0? 21 80 C0 00 23 10 05 02 80 10 02 00 21 18 62 00 00 00 70 8C 2C 00 00 12 02 00 03 24 04 00 02 8E 1C 00 04 8E 23 10 C2 02 02 00 60 14 1A 00 43 00 CD 01 00 00 20 00 03 24 00 00 85 8C 12 10 00 00 19 00 A3 10 21 38 54 00 1C 00 22 8E 21 30 A0 02 21 20 20 02 58 00 43 8C 09 F8 60 00 21 28 00 02 00 00 10 8E 1C 00 22 8E 14 00 42 8C 04 00 40 10 1C 00 BF 8F 09 F8 40 00 21 20 20 02 1C 00 BF 8F 21 10 00 02 18 00 B6 8F 14 00 B5 8F 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 20 00 BD 27 1C 00 22 8E 21 30 A0 02 21 20 20 02 5C 00 43 8C 09 F8 60 00 21 28 00 02 ?? ?? ?? 0? 00 00 10 8E ?? ?? ?? 0? 21 80 00 00 }
	condition:
		$1
}

rule file_54_17_0 {
	meta:
		name = "make_trans_font"
		size = 16
		refs = "0000 font_vtable_trans"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 43 8C 08 00 E0 03 08 00 83 AC }
	condition:
		$1
}

rule file_54_18_0 {
	meta:
		name = "is_trans_font"
		size = 24
		refs = "0000 font_vtable_trans"
	strings:
		$1 = { ?? ?? 03 3C 08 00 82 8C ?? ?? 64 8C 26 10 44 00 08 00 E0 03 01 00 42 2C }
	condition:
		$1
}

rule file_54_20_0 {
	meta:
		name = "is_mono_font"
		size = 24
		refs = "0000 font_vtable_mono"
	strings:
		$1 = { ?? ?? 03 3C 08 00 82 8C ?? ?? 64 8C 26 10 44 00 08 00 E0 03 01 00 42 2C }
	condition:
		$1
}

rule file_54_19_0 {
	meta:
		name = "is_color_font"
		size = 44
		refs = "0000 font_vtable_color 0010 font_vtable_trans"
	strings:
		$1 = { ?? ?? 02 3C 08 00 84 8C ?? ?? 43 8C 05 00 83 10 ?? ?? 03 3C ?? ?? 62 8C 26 10 82 00 08 00 E0 03 01 00 42 2C 08 00 E0 03 01 00 02 24 }
	condition:
		$1
}

rule file_54_21_0 {
	meta:
		name = "is_compatible_font"
		size = 20
	strings:
		$1 = { 08 00 82 8C 08 00 A3 8C 26 10 43 00 08 00 E0 03 01 00 42 2C }
	condition:
		$1
}

rule file_54_22_0 {
	meta:
		name = "extract_font_range"
		size = 32
	strings:
		$1 = { 08 00 82 8C 24 00 59 8C 03 00 20 13 00 00 00 00 08 00 20 03 00 00 00 00 08 00 E0 03 21 10 00 00 }
	condition:
		$1
}

rule file_54_23_0 {
	meta:
		name = "merge_fonts"
		size = 120
		refs = "0070 .text"
	strings:
		$1 = { 08 00 82 8C F0 FF BD 27 08 00 B1 AF 28 00 42 8C 04 00 B0 AF 0C 00 BF AF 21 80 80 00 0A 00 40 10 21 88 A0 00 09 F8 40 00 00 00 00 00 07 00 40 50 08 00 22 8E 0C 00 BF 8F 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 10 00 BD 27 08 00 22 8E 28 00 59 8C 07 00 20 13 21 20 20 02 21 28 00 02 0C 00 BF 8F 08 00 B1 8F 04 00 B0 8F 08 00 20 03 10 00 BD 27 ?? ?? ?? 0? 21 10 00 00 }
	condition:
		$1
}

rule file_54_24_0 {
	meta:
		name = "get_font_ranges"
		size = 32
	strings:
		$1 = { 08 00 82 8C 18 00 59 8C 03 00 20 13 00 00 00 00 08 00 20 03 00 00 00 00 08 00 E0 03 FF FF 02 24 }
	condition:
		$1
}

rule file_54_25_0 {
	meta:
		name = "get_font_range_begin"
		size = 32
	strings:
		$1 = { 08 00 82 8C 1C 00 59 8C 03 00 20 13 00 00 00 00 08 00 20 03 00 00 00 00 08 00 E0 03 FF FF 02 24 }
	condition:
		$1
}

rule file_54_26_0 {
	meta:
		name = "get_font_range_end"
		size = 32
	strings:
		$1 = { 08 00 82 8C 20 00 59 8C 03 00 20 13 00 00 00 00 08 00 20 03 00 00 00 00 08 00 E0 03 FF FF 02 24 }
	condition:
		$1
}

rule file_54_27_0 {
	meta:
		name = "transpose_font"
		size = 32
	strings:
		$1 = { 08 00 82 8C 2C 00 59 8C 03 00 20 13 00 00 00 00 08 00 20 03 00 00 00 00 08 00 E0 03 FF FF 02 24 }
	condition:
		$1
}

rule file_54_28_0 {
	meta:
		name = "color_copy_glyph_range"
		size = 292
		refs = "007c _al_malloc 00e0 create_bitmap_ex 0108 blit 011c .text"
	strings:
		$1 = { 00 00 82 8C E0 FF BD 27 0C 00 B3 AF 2A 10 A2 00 08 00 B2 AF 00 00 B0 AF 1C 00 BF AF 18 00 B6 AF 14 00 B5 AF 10 00 B4 AF 04 00 B1 AF 21 98 80 00 21 90 A0 00 0D 00 40 10 21 80 C0 00 21 88 00 00 1C 00 BF 8F 21 10 20 02 18 00 B6 8F 14 00 B5 8F 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 20 00 BD 27 04 00 82 8C 2A 10 46 00 F2 FF 40 14 21 88 00 00 ?? ?? ?? 0? 10 00 04 24 EE FF 40 10 21 88 40 00 23 B0 12 02 00 00 52 AC 04 00 50 AC 0C 00 40 AC ?? ?? ?? 0? 80 20 16 00 E6 FF C0 1A 08 00 22 AE 21 A8 40 00 21 A0 00 00 00 00 62 8E 08 00 63 8E 23 10 42 02 21 10 54 00 80 10 02 00 21 18 62 00 00 00 70 8C 01 00 94 26 1C 00 02 8E 00 00 05 8E 04 00 06 8E ?? ?? ?? 0? 00 00 44 8C 00 00 0A 8E 04 00 0B 8E 00 00 A2 AE 21 28 40 00 21 20 00 02 21 30 00 00 21 38 00 00 21 40 00 00 ?? ?? ?? 0? 21 48 00 00 2A 10 96 02 E7 FF 40 14 04 00 B5 26 ?? ?? ?? 0? 1C 00 BF 8F }
	condition:
		$1
}

rule file_54_29_0 {
	meta:
		name = "color_merge_fonts"
		size = 772
		refs = "0078 font_vtable_color 0088 font_vtable_trans 0098 font_vtable_mono 00c8 _al_malloc 012c .text 01a4 destroy_font 0264 create_bitmap_ex"
	strings:
		$1 = { C8 FF BD 27 20 00 B4 AF 1C 00 B3 AF 34 00 BF AF 30 00 BE AF 2C 00 B7 AF 28 00 B6 AF 24 00 B5 AF 18 00 B2 AF 14 00 B1 AF 10 00 B0 AF 21 98 80 00 0F 00 80 14 21 A0 A0 00 21 90 00 00 34 00 BF 8F 21 10 40 02 30 00 BE 8F 2C 00 B7 8F 28 00 B6 8F 24 00 B5 8F 20 00 B4 8F 1C 00 B3 8F 18 00 B2 8F 14 00 B1 8F 10 00 B0 8F 08 00 E0 03 38 00 BD 27 F2 FF A0 10 21 90 00 00 ?? ?? 1E 3C 08 00 84 8C ?? ?? C5 8F 04 00 85 10 ?? ?? 02 3C ?? ?? 43 8C EB FF 83 14 34 00 BF 8F ?? ?? 02 3C ?? ?? 43 8C 08 00 84 8E 43 00 83 10 00 00 00 00 08 00 B4 AF ?? ?? C2 8F 04 00 44 10 ?? ?? 02 3C ?? ?? 43 8C DE FF 64 14 21 90 00 00 ?? ?? ?? 0? 0C 00 04 24 08 00 64 8E 21 90 40 00 04 00 83 8E 08 00 44 AE 08 00 A4 8F 04 00 62 8E 00 00 40 AE 00 00 90 8C 2C 10 43 00 00 00 71 8E 04 00 42 AE 21 98 00 00 10 00 20 12 00 00 00 00 05 00 00 12 00 00 23 8E 00 00 05 8E 2A 10 65 00 0D 00 40 10 00 00 00 00 18 00 60 12 21 20 20 02 04 00 26 8E ?? ?? ?? 0? 21 28 60 00 0C 00 62 AE 0C 00 31 8E ?? ?? ?? 0? 21 98 40 00 15 00 00 12 08 00 A2 8F 00 00 05 8E 07 00 60 12 04 00 06 8E ?? ?? ?? 0? 21 20 00 02 0C 00 62 AE 0C 00 10 8E ?? ?? ?? 0? 21 98 40 00 ?? ?? ?? 0? 21 20 00 02 00 00 42 AE ?? ?? ?? 0? 0C 00 10 8E 04 00 26 8E ?? ?? ?? 0? 21 28 60 00 00 00 42 AE ?? ?? ?? 0? 0C 00 31 8E A8 FF 54 50 34 00 BF 8F ?? ?? ?? 0? 21 20 40 00 ?? ?? ?? 0? 34 00 BF 8F A0 FF A4 10 00 00 86 8E ?? ?? 02 3C ?? ?? 43 8C 9D FF 83 10 21 90 00 00 0C 00 04 24 ?? ?? ?? 0? 21 A8 C0 00 08 00 A2 AF 08 00 A4 8F ?? ?? C2 8F 04 00 83 8E 08 00 82 AC 40 00 A0 12 04 00 83 AC 00 00 A0 AF 0C 00 A2 8E 10 00 04 24 ?? ?? ?? 0? 04 00 A2 AF 21 B0 40 00 04 00 A4 8E 00 00 A2 8E 23 20 82 00 ?? ?? ?? 0? 80 20 04 00 00 00 A4 8E 21 B8 40 00 08 00 C2 AE 00 00 C4 AE 04 00 A2 8E 0C 00 C0 AE 2A 18 82 00 23 00 60 10 04 00 C2 AE 21 90 80 00 08 00 A3 8E 23 10 44 02 80 10 02 00 21 18 62 00 00 00 70 8C 08 00 04 24 02 00 06 86 ?? ?? ?? 0? 00 00 05 86 1C 00 43 8C 21 88 40 00 21 20 40 00 A0 00 62 8C 09 F8 40 00 21 28 00 00 1C 00 23 8E 21 20 20 02 21 28 00 02 78 00 62 8C 21 30 00 00 21 38 00 00 01 00 08 24 09 F8 40 00 21 48 00 00 00 00 A4 8E 04 00 A3 8E 23 10 44 02 80 10 02 00 01 00 52 26 21 10 E2 02 2A 18 43 02 E0 FF 60 14 00 00 51 AC 00 00 A4 8F 0A 00 80 10 08 00 A2 8F 0C 00 96 AC 04 00 A2 8F 03 00 40 10 21 A8 40 00 ?? ?? ?? 0? 00 00 B6 AF 08 00 A2 8F ?? ?? ?? 0? 08 00 44 8C ?? ?? ?? 0? 00 00 56 AC }
	condition:
		$1
}

rule file_54_30_0 {
	meta:
		name = "color_extract_font_range"
		size = 592
		refs = "00ac _al_malloc 00d0 .text"
		altNames = "mono_extract_font_range"
	strings:
		$1 = { E8 FF BD 27 08 00 B2 AF 04 00 B1 AF 00 00 B0 AF 14 00 BF AF 10 00 B4 AF 0C 00 B3 AF 21 88 80 00 21 90 C0 00 0F 00 80 10 21 80 A0 00 FF FF 02 24 5D 00 A2 10 00 00 00 00 08 00 C2 14 2A 10 50 02 00 00 82 8C 11 00 40 14 21 18 40 00 FF FF 02 24 2A 10 50 00 15 00 40 10 2A 10 50 02 6F 00 40 10 FF FF 02 24 21 A0 00 00 14 00 BF 8F 21 10 80 02 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 18 00 BD 27 0C 00 42 8C FE FF 40 54 21 18 40 00 04 00 62 8C FF FF 42 24 2A 10 50 00 ED FF 40 14 2A 10 50 02 ?? ?? ?? 0? 0C 00 04 24 21 A0 40 00 08 00 23 8E 04 00 22 8E 00 00 80 AE 08 00 83 AE 04 00 82 AE 21 20 20 02 ?? ?? ?? 0? FF FF 05 24 2A 10 50 00 41 00 40 10 21 20 20 02 43 00 40 06 21 98 00 02 00 00 30 8E DE FF 00 12 14 00 BF 8F 21 18 00 02 0C 00 62 8C FE FF 40 54 21 18 40 00 04 00 62 8C FF FF 42 24 2A 10 42 02 47 00 40 10 21 30 40 02 00 00 05 8E 01 00 D2 24 2A 20 65 02 14 00 80 10 21 88 00 00 04 00 06 8E 2A 18 D2 00 24 00 60 14 2A 10 B2 00 22 00 40 10 00 00 00 00 2C 28 65 02 12 00 20 12 2D 30 D2 00 ?? ?? ?? 0? 21 20 00 02 0C 00 22 AE 0C 00 10 8E C1 FF 00 12 14 00 BF 8F 00 00 05 8E 2A 20 65 02 EE FF 80 14 21 88 40 00 04 00 06 8E 2A 10 66 02 EC FF 40 10 2A 18 D2 00 2C 28 65 02 F0 FF 20 16 2D 30 D2 00 ?? ?? ?? 0? 21 20 00 02 ?? ?? ?? 0? 00 00 82 AE C0 FF C5 10 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 2A 10 52 00 A7 FF 40 10 2A 10 50 02 ?? ?? ?? 0? 00 00 00 00 E4 FF 80 10 21 10 20 02 DD FF 60 54 2C 28 65 02 ?? ?? ?? 0? 0C 00 10 8E ?? ?? ?? 0? FF FF 05 24 BF FF 41 06 21 98 40 00 00 00 30 8E 9C FF 00 12 14 00 BF 8F 21 18 00 02 0C 00 62 8C FE FF 40 54 21 18 40 00 04 00 62 8C ?? ?? ?? 0? FF FF 46 24 92 FF 02 12 21 A0 00 00 A1 FF 42 16 14 00 BF 8F ?? ?? ?? 0? 00 00 00 00 21 18 00 02 0C 00 62 8C FE FF 40 54 21 18 40 00 04 00 62 8C ?? ?? ?? 0? FF FF 46 24 }
	condition:
		$1
}

rule file_54_31_0 {
	meta:
		name = "color_destroy"
		size = 200
		refs = "0058 destroy_bitmap 0070 _al_free"
	strings:
		$1 = { E8 FF BD 27 10 00 B3 AF 14 00 BF AF 0C 00 B2 AF 08 00 B1 AF 04 00 B0 AF 24 00 80 10 21 98 80 00 00 00 91 8C 1A 00 20 12 21 20 60 02 00 00 23 8E 04 00 22 8E 2A 10 62 00 0D 00 40 10 0C 00 32 8E 21 80 60 00 08 00 22 8E 23 18 03 02 80 18 03 00 21 10 43 00 00 00 44 8C ?? ?? ?? 0? 01 00 10 26 04 00 22 8E 2A 10 02 02 F6 FF 40 54 00 00 23 8E ?? ?? ?? 0? 08 00 24 8E 21 20 20 02 ?? ?? ?? 0? 21 88 40 02 EA FF 40 56 00 00 23 8E 21 20 60 02 14 00 BF 8F 10 00 B3 8F 0C 00 B2 8F 08 00 B1 8F 04 00 B0 8F ?? ?? ?? 0? 18 00 BD 27 14 00 BF 8F 10 00 B3 8F 0C 00 B2 8F 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_54_32_0 {
	meta:
		name = "mono_destroy"
		size = 200
		refs = "0058 _al_free"
	strings:
		$1 = { E8 FF BD 27 10 00 B3 AF 14 00 BF AF 0C 00 B2 AF 08 00 B1 AF 04 00 B0 AF 24 00 80 10 21 98 80 00 00 00 91 8C 1A 00 20 12 21 20 60 02 00 00 23 8E 04 00 22 8E 2A 10 62 00 0D 00 40 10 0C 00 32 8E 21 80 60 00 08 00 22 8E 23 18 03 02 80 18 03 00 21 10 43 00 00 00 44 8C ?? ?? ?? 0? 01 00 10 26 04 00 22 8E 2A 10 02 02 F6 FF 40 54 00 00 23 8E ?? ?? ?? 0? 08 00 24 8E 21 20 20 02 ?? ?? ?? 0? 21 88 40 02 EA FF 40 56 00 00 23 8E 21 20 60 02 14 00 BF 8F 10 00 B3 8F 0C 00 B2 8F 08 00 B1 8F 04 00 B0 8F ?? ?? ?? 0? 18 00 BD 27 14 00 BF 8F 10 00 B3 8F 0C 00 B2 8F 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_54_33_0 {
	meta:
		name = "color_render"
		size = 312
		refs = "0060 .text 0064 ugetxc 00f0 text_length 00fc text_height"
	strings:
		$1 = { 1C 00 02 8D D8 FF BD 27 20 00 B6 AF 10 00 42 8C 1C 00 B5 AF 18 00 B4 AF 14 00 B3 AF 10 00 B2 AF 0C 00 B1 AF 08 00 B0 AF 24 00 BF AF 21 98 00 01 21 80 A0 00 21 90 80 00 21 B0 C0 00 21 A0 E0 00 21 88 20 01 21 A8 40 01 03 00 40 10 00 00 A5 AF 09 F8 40 00 21 20 00 01 23 00 C0 06 00 00 00 00 ?? ?? ?? 0? ?? ?? 10 3C 08 00 42 8E 0C 00 43 8C 09 F8 60 00 00 00 00 00 21 88 22 02 ?? ?? 03 8E 09 F8 60 00 21 20 A0 03 21 28 40 00 21 48 20 02 21 20 40 02 21 30 C0 02 21 38 80 02 21 40 60 02 F1 FF 40 14 21 50 A0 02 1C 00 62 8E 14 00 42 8C 04 00 40 10 24 00 BF 8F 09 F8 40 00 21 20 60 02 24 00 BF 8F 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 E0 03 28 00 BD 27 DD FF 80 06 21 28 00 02 ?? ?? ?? 0? 21 20 40 02 21 20 40 02 ?? ?? ?? 0? 21 80 40 00 1C 00 63 8E FF FF 27 26 FF FF A8 26 3C 00 6A 8C 21 48 80 02 21 38 F0 00 21 40 02 01 21 20 60 02 21 28 20 02 09 F8 40 01 21 30 A0 02 ?? ?? ?? 0? FF FF 14 24 }
	condition:
		$1
}

rule file_54_34_0 {
	meta:
		name = "color_render_char"
		size = 784
		refs = "023c allegro_404_char 00c4 .text 0104 get_color_conversion 0114 set_color_conversion 0128 create_bitmap_ex 0150 blit 0194 masked_blit 019c destroy_bitmap"
	strings:
		$1 = { 08 00 82 8C D8 FF BD 27 20 00 BE AF 00 00 43 8C 1C 00 B7 AF 18 00 B6 AF 14 00 B5 AF 10 00 B4 AF 0C 00 B3 AF 04 00 B1 AF 00 00 B0 AF 24 00 BF AF 08 00 B2 AF 21 98 00 01 21 88 80 00 21 80 A0 00 21 A0 C0 00 21 A8 E0 00 21 B8 20 01 09 F8 60 00 21 F0 40 01 21 B0 40 00 1C 00 62 8E 10 00 42 8C 03 00 40 10 00 00 00 00 09 F8 40 00 21 20 60 02 60 00 80 06 00 00 00 00 ?? ?? 02 3C 00 00 24 8E ?? ?? 46 8C 0D 00 80 10 00 00 00 00 21 18 80 00 00 00 85 8C 2A 10 05 02 06 00 40 54 0C 00 63 8C 04 00 62 8C 2A 10 02 02 08 00 40 54 08 00 63 8C 0C 00 63 8C F7 FF 60 54 00 00 65 8C 3A 00 06 52 21 80 00 00 ?? ?? ?? 0? 21 80 C0 00 23 10 05 02 80 10 02 00 21 18 62 00 00 00 72 8C 8A 00 40 12 08 00 03 24 1C 00 42 8E 00 00 44 8C 54 00 83 10 00 00 00 00 1C 00 62 8E 00 00 43 8C 63 00 83 50 04 00 4B 8E ?? ?? ?? 0? 00 00 00 00 0E 04 04 3C E0 EE 84 34 ?? ?? ?? 0? 21 88 40 00 1C 00 62 8E 04 00 46 8E 00 00 45 8E ?? ?? ?? 0? 00 00 44 8C 00 00 4A 8E 04 00 4B 8E 21 28 40 00 21 30 00 00 21 38 00 00 21 40 00 00 21 48 00 00 21 20 40 02 ?? ?? ?? 0? 21 80 40 00 ?? ?? ?? 0? 21 20 20 02 04 00 4B 8E 02 00 02 24 00 00 4A 8E 23 48 CB 02 02 00 40 14 1A 00 22 01 CD 01 00 00 21 20 00 02 21 40 E0 02 21 28 60 02 21 30 00 00 21 38 00 00 12 48 00 00 ?? ?? ?? 0? 21 48 3E 01 ?? ?? ?? 0? 21 20 00 02 00 00 50 8E 1C 00 62 8E 14 00 42 8C 04 00 40 10 24 00 BF 8F 09 F8 40 00 21 20 60 02 24 00 BF 8F 21 10 00 02 20 00 BE 8F 1C 00 B7 8F 18 00 B6 8F 14 00 B5 8F 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 28 00 BD 27 A0 FF A0 06 21 20 20 02 08 00 22 8E 04 00 43 8C 09 F8 60 00 21 28 00 02 1C 00 64 8E FF FF E7 26 FF FF C8 27 3C 00 83 8C 21 38 E2 00 21 40 16 01 21 20 60 02 21 28 E0 02 21 30 C0 03 09 F8 60 00 21 48 A0 02 ?? ?? ?? 0? ?? ?? 02 3C 22 00 80 06 02 00 02 24 04 00 47 8E 1C 00 63 8E 23 38 C7 02 02 00 40 14 1A 00 E2 00 CD 01 00 00 21 30 E0 02 74 00 62 8C 21 40 80 02 21 48 A0 02 21 20 60 02 21 28 40 02 12 38 00 00 09 F8 40 00 21 38 FE 00 ?? ?? ?? 0? 00 00 50 8E 02 00 02 24 00 00 4A 8E 23 48 CB 02 02 00 40 14 1A 00 22 01 CD 01 00 00 21 40 E0 02 21 20 40 02 21 28 60 02 21 30 00 00 21 38 00 00 12 48 00 00 ?? ?? ?? 0? 21 48 3E 01 ?? ?? ?? 0? 00 00 50 8E 04 00 47 8E 1C 00 63 8E 23 38 C7 02 02 00 40 14 1A 00 E2 00 CD 01 00 00 21 30 E0 02 48 00 62 8C 21 20 60 02 21 28 40 02 12 38 00 00 09 F8 40 00 21 38 FE 00 ?? ?? ?? 0? 00 00 50 8E ?? ?? ?? 0? 21 80 00 00 }
	condition:
		$1
}

rule file_54_35_0 {
	meta:
		name = "mono_copy_glyph_range"
		size = 332
		refs = "008c _al_malloc 0130 memcpy 0144 .text"
	strings:
		$1 = { 00 00 82 8C D8 FF BD 27 10 00 B4 AF 2A 10 A2 00 0C 00 B3 AF 00 00 B0 AF 24 00 BF AF 20 00 BE AF 1C 00 B7 AF 18 00 B6 AF 14 00 B5 AF 08 00 B2 AF 04 00 B1 AF 21 A0 80 00 21 98 A0 00 0F 00 40 10 21 80 C0 00 21 90 00 00 24 00 BF 8F 21 10 40 02 20 00 BE 8F 1C 00 B7 8F 18 00 B6 8F 14 00 B5 8F 10 00 B4 8F 0C 00 B3 8F 08 00 B2 8F 04 00 B1 8F 00 00 B0 8F 08 00 E0 03 28 00 BD 27 04 00 82 8C 2A 10 46 00 F0 FF 40 14 21 90 00 00 ?? ?? ?? 0? 10 00 04 24 EC FF 40 10 21 90 40 00 23 B8 13 02 00 00 53 AC 04 00 50 AC 0C 00 40 AC ?? ?? ?? 0? 80 20 17 00 E4 FF E0 1A 08 00 42 AE 21 B0 40 00 21 A8 00 00 08 00 1E 24 00 00 82 8E 08 00 83 8E 23 10 62 02 21 10 55 00 80 10 02 00 21 18 62 00 00 00 71 8C 01 00 B5 26 00 00 30 86 02 00 22 86 07 00 10 26 02 00 C0 17 1A 00 1E 02 CD 01 00 00 12 80 00 00 18 00 02 02 12 80 00 00 ?? ?? ?? 0? 04 00 04 26 00 00 23 96 02 00 24 96 00 00 C2 AE 00 00 43 A4 02 00 44 A4 04 00 25 26 04 00 44 24 ?? ?? ?? 0? 21 30 00 02 2A 18 B7 02 E2 FF 60 14 04 00 D6 26 ?? ?? ?? 0? 24 00 BF 8F }
	condition:
		$1
}

rule file_54_36_0 {
	meta:
		name = "mono_merge_fonts"
		size = 320
		refs = "0050 font_vtable_mono 0070 _al_malloc 00d0 .text"
	strings:
		$1 = { E8 FF BD 27 08 00 B1 AF 04 00 B0 AF 14 00 BF AF 10 00 B3 AF 0C 00 B2 AF 21 80 80 00 0A 00 80 14 21 88 A0 00 21 90 00 00 14 00 BF 8F 21 10 40 02 10 00 B3 8F 0C 00 B2 8F 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 18 00 BD 27 F7 FF A0 10 21 90 00 00 ?? ?? 02 3C ?? ?? 43 8C 08 00 84 8C F3 FF 83 14 14 00 BF 8F 08 00 A2 8C F1 FF 82 14 21 10 40 02 ?? ?? ?? 0? 0C 00 04 24 21 90 40 00 04 00 23 8E 04 00 02 8E 08 00 04 8E 00 00 40 AE 2C 10 43 00 00 00 13 8E 04 00 42 AE 00 00 30 8E 08 00 44 AE 21 88 00 00 10 00 60 12 00 00 00 00 05 00 00 12 00 00 63 8E 00 00 05 8E 2A 10 65 00 0D 00 40 10 00 00 00 00 13 00 20 12 21 20 60 02 04 00 66 8E ?? ?? ?? 0? 21 28 60 00 0C 00 22 AE 0C 00 73 8E ?? ?? ?? 0? 21 88 40 00 D0 FF 00 12 14 00 BF 8F 00 00 05 8E 0D 00 20 12 04 00 06 8E ?? ?? ?? 0? 21 20 00 02 0C 00 22 AE 0C 00 10 8E ?? ?? ?? 0? 21 88 40 00 04 00 66 8E ?? ?? ?? 0? 21 28 60 00 00 00 42 AE ?? ?? ?? 0? 0C 00 73 8E ?? ?? ?? 0? 21 20 00 02 00 00 42 AE ?? ?? ?? 0? 0C 00 10 8E }
	condition:
		$1
}

rule file_54_38_0 {
	meta:
		name = "font_has_alpha"
		size = 200
		refs = "0000 font_vtable_color 0020 font_vtable_trans 0064 .text 008c _bitmap_has_alpha"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 43 8C 08 00 85 8C F0 FF BD 27 0C 00 BF AF 08 00 B1 AF 0B 00 A3 10 04 00 B0 AF ?? ?? 02 3C ?? ?? 43 8C 08 00 A3 50 00 00 91 8C 0C 00 BF 8F 21 10 00 00 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 10 00 BD 27 00 00 91 8C F9 FF 20 12 0C 00 BF 8F 00 00 24 8E 04 00 22 8E 15 00 82 10 21 80 80 00 ?? ?? ?? 0? 08 00 23 8E 12 00 50 50 0C 00 31 8E 00 00 24 8E 08 00 23 8E 23 10 04 02 80 10 02 00 21 18 62 00 00 00 64 8C ?? ?? ?? 0? 01 00 10 26 F5 FF 40 50 04 00 22 8E 0C 00 BF 8F FF FF 02 24 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 10 00 BD 27 0C 00 31 8E E7 FF 20 56 00 00 24 8E ?? ?? ?? 0? 0C 00 BF 8F }
	condition:
		$1
}

rule file_55_0_0 {
	meta:
		name = "_linear_draw_sprite_ex15"
		size = 1072
		refs = "00f4 _blender_func15 0188 _blender_alpha 0364 .text 036c _blender_col_15"
	strings:
		$1 = { B0 FF BD 27 02 00 02 24 38 00 B4 AF 4C 00 BF AF 48 00 BE AF 44 00 B7 AF 40 00 B6 AF 3C 00 B5 AF 34 00 B3 AF 30 00 B2 AF 2C 00 B1 AF 28 00 B0 AF 20 00 A4 AF 21 60 A0 00 E2 00 22 11 21 A0 00 01 01 00 03 24 6B 00 23 11 FF FF 0B 24 03 00 22 39 0B 58 62 00 18 00 AB AF 20 00 A3 8F 08 00 62 8C 6A 00 40 50 04 00 82 8D 0C 00 62 8C 10 00 63 8C 00 00 84 8D 23 50 46 00 23 18 66 00 21 10 00 00 2C 50 42 01 2D 18 64 00 23 98 6A 00 4D 00 60 1A 01 00 02 24 E1 00 22 11 21 30 46 01 03 00 02 24 DF 00 22 11 23 10 8A 00 20 00 A4 8F 14 00 82 8C 18 00 83 8C 04 00 84 8D 23 40 47 00 23 18 67 00 21 10 00 00 2C 40 02 01 2D 18 64 00 23 18 68 00 3C 00 60 18 1C 00 A3 AF FE FF 22 25 02 00 42 2C C8 00 40 14 21 28 07 01 20 00 A4 8F 00 C0 03 3C 2C 00 82 8C ?? ?? 04 3C 24 10 43 00 57 00 40 14 ?? ?? 96 8C 1C 00 A2 8F 2E 00 40 18 10 00 02 25 80 10 02 00 21 10 82 01 40 50 0A 00 40 30 06 00 0C 00 A2 AF 04 00 AA AF 00 00 A6 AF 40 A8 0B 00 21 F0 A0 00 21 B8 00 00 20 00 A2 8F 21 28 C0 03 20 00 43 8C 21 20 40 00 0C 00 A2 8F 09 F8 60 00 00 00 50 8C 12 00 60 1A 04 00 A3 8F 00 00 A4 8F 21 90 03 02 21 88 44 00 21 80 00 00 00 00 42 96 1F 7C 03 24 06 00 43 10 01 00 04 24 7B 00 84 12 02 00 03 24 73 00 83 12 ?? ?? 04 3C 00 00 22 A6 01 00 10 26 02 00 52 26 F4 FF 13 16 21 88 35 02 1C 00 A3 8F 0C 00 A4 8F 01 00 F7 26 2A 10 E3 02 18 00 A3 8F 04 00 84 24 0C 00 A4 AF DE FF 40 14 21 F0 C3 03 4C 00 BF 8F 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 50 00 BD 27 18 00 A3 AF 20 00 A3 8F 08 00 62 8C 9A FF 40 54 0C 00 62 8C 04 00 82 8D 00 00 93 8D 1C 00 A2 AF 01 00 02 24 6E 00 22 11 03 00 02 24 6C 00 22 11 FE FF 22 25 02 00 42 2C 70 00 40 14 1C 00 A3 8F 20 00 A4 8F 00 C0 03 3C 21 28 E0 00 2C 00 82 8C ?? ?? 04 3C 21 50 00 00 24 10 43 00 21 40 00 00 AB FF 40 10 ?? ?? 96 8C 1C 00 A3 8F 2D 00 60 18 10 00 02 25 80 10 02 00 21 10 82 01 40 50 0A 00 40 30 06 00 10 00 A2 AF 14 00 AA AF 08 00 A6 AF 40 A8 0B 00 21 F0 A0 00 21 B8 00 00 20 00 A4 8F 10 00 A2 8F 21 28 C0 03 20 00 83 8C 09 F8 60 00 00 00 50 8C 12 00 60 1A 14 00 A3 8F 08 00 A4 8F 21 90 03 02 21 88 44 00 21 80 00 00 00 00 42 96 1F 7C 03 24 06 00 43 10 01 00 04 24 34 00 84 12 02 00 03 24 2C 00 83 12 ?? ?? 04 3C 00 00 22 A6 01 00 10 26 02 00 52 26 F4 FF 13 16 21 88 35 02 1C 00 A3 8F 10 00 A4 8F 01 00 F7 26 2A 10 E3 02 18 00 A3 8F 04 00 84 24 10 00 A4 AF DF FF 40 14 21 F0 C3 03 20 00 A4 8F 4C 00 BF 8F 48 00 BE 8F 1C 00 82 8C 44 00 B7 8F 40 00 B6 8F 08 00 59 8C 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 20 03 50 00 BD 27 ?? ?? 86 8C 00 00 25 96 09 F8 C0 02 21 20 40 00 ?? ?? ?? 0? 00 00 22 A6 ?? ?? 03 3C ?? ?? 64 8C ?? ?? 03 3C ?? ?? 66 8C 09 F8 C0 02 21 28 40 00 ?? ?? ?? 0? 00 00 22 A6 ?? ?? 86 8C 00 00 25 96 09 F8 C0 02 21 20 40 00 ?? ?? ?? 0? 00 00 22 A6 ?? ?? 03 3C ?? ?? 64 8C ?? ?? 03 3C ?? ?? 66 8C 09 F8 C0 02 21 28 40 00 ?? ?? ?? 0? 00 00 22 A6 FF FF 02 24 01 00 0B 24 ?? ?? ?? 0? 18 00 A2 AF FF FF 62 26 21 30 46 00 FE FF 22 25 02 00 42 2C 94 FF 40 10 20 00 A4 8F 1C 00 A3 8F 21 50 00 00 21 40 00 00 FF FF 62 24 ?? ?? ?? 0? 21 28 47 00 23 10 88 00 1C 00 A4 8F 21 18 A3 00 FF FF 65 24 ?? ?? ?? 0? 23 40 44 00 23 10 8A 00 21 18 D3 00 23 50 53 00 ?? ?? ?? 0? FF FF 66 24 }
	condition:
		$1
}

rule file_55_1_0 {
	meta:
		name = "_linear_draw_sprite15"
		size = 544
	strings:
		$1 = { 08 00 82 8C D0 FF BD 27 1C 00 B5 AF 2C 00 BF AF 28 00 BE AF 24 00 B7 AF 20 00 B6 AF 18 00 B4 AF 14 00 B3 AF 10 00 B2 AF 0C 00 B1 AF 08 00 B0 AF 49 00 40 10 21 A8 80 00 0C 00 82 8C 10 00 83 8C 00 00 A4 8C 23 48 46 00 23 18 66 00 21 50 00 00 2D 18 64 00 2C 48 2A 01 23 80 69 00 65 00 00 5A 2C 00 BF 8F 14 00 A2 8E 18 00 A3 8E 04 00 A4 8C 23 40 47 00 23 18 67 00 2C 40 0A 01 2D 18 64 00 23 B0 68 00 5B 00 C0 5A 2C 00 BF 8F 2C 00 A2 8E 00 C0 03 3C 21 30 26 01 24 10 43 00 37 00 40 10 21 B8 07 01 1D 00 C0 1A 10 00 02 25 80 10 02 00 40 48 09 00 21 A0 A2 00 00 00 A9 AF 40 F0 06 00 21 90 00 00 1F 7C 13 24 20 00 A3 8E 21 20 A0 02 21 28 57 02 09 F8 60 00 00 00 91 8E 0B 00 00 1A 00 00 A3 8F 21 10 5E 00 21 28 23 02 21 18 00 00 00 00 A4 94 01 00 63 24 02 00 93 10 02 00 A5 24 00 00 44 A4 FA FF 70 14 02 00 42 24 01 00 52 26 2A 10 56 02 EC FF 40 14 04 00 94 26 1C 00 A2 8E 21 20 A0 02 2C 00 BF 8F 08 00 59 8C 28 00 BE 8F 24 00 B7 8F 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 20 03 30 00 BD 27 2C 00 A2 8E 00 C0 03 3C 00 00 B0 8C 24 10 43 00 04 00 B6 8C 21 B8 E0 00 21 48 00 00 CB FF 40 14 21 40 00 00 1C 00 C0 1A 10 00 02 25 10 00 E3 26 80 10 02 00 80 18 03 00 21 20 A2 00 21 18 A3 02 40 28 09 00 40 30 06 00 21 58 00 00 1F 7C 0C 24 00 00 82 8C 0B 00 00 1A 00 00 68 8C 21 48 45 00 21 50 06 01 21 10 00 00 00 00 28 95 01 00 42 24 02 00 0C 11 02 00 29 25 00 00 48 A5 FA FF 50 14 02 00 4A 25 01 00 6B 25 2A 10 76 01 04 00 84 24 EF FF 40 14 04 00 63 24 2C 00 BF 8F 28 00 BE 8F 24 00 B7 8F 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_55_3_0 {
	meta:
		name = "_linear_draw_256_sprite15"
		size = 620
		refs = "008c _palette_expansion_table"
		altNames = "_linear_draw_256_sprite16"
	strings:
		$1 = { 08 00 82 8C D0 FF BD 27 1C 00 B5 AF 14 00 B3 AF 2C 00 BF AF 28 00 BE AF 24 00 B7 AF 20 00 B6 AF 18 00 B4 AF 10 00 B2 AF 0C 00 B1 AF 08 00 B0 AF 21 A8 80 00 52 00 40 10 21 98 A0 00 0C 00 82 8C 10 00 83 8C 00 00 A4 8C 23 B0 46 00 23 18 66 00 21 28 00 00 2D 18 64 00 2C B0 C5 02 23 80 76 00 77 00 00 1A 2C 00 BF 8F 14 00 A2 8E 18 00 A3 8E 04 00 64 8E 23 88 47 00 23 18 67 00 2C 88 25 02 2D 18 64 00 23 B8 71 00 6D 00 E0 1A ?? ?? 02 3C 1C 00 A5 8E ?? ?? 43 8C 00 00 A4 8C 21 30 C6 02 04 00 A6 AF 09 F8 60 00 21 F0 27 02 21 90 40 00 2C 00 A2 8E 00 C0 03 3C 24 10 43 00 40 00 40 10 00 00 00 00 1F 00 E0 1A 10 00 22 26 80 10 02 00 21 A0 62 02 04 00 A2 8F 21 98 00 00 40 10 02 00 00 00 A2 AF 20 00 A3 8E 21 20 A0 02 21 28 7E 02 09 F8 60 00 00 00 91 8E 0E 00 00 1A 00 00 A3 8F 21 28 36 02 21 20 00 00 21 30 43 00 00 00 A3 90 01 00 84 24 01 00 A5 24 80 10 03 00 03 00 60 10 21 10 42 02 00 00 42 8C 00 00 C2 A4 F7 FF 90 14 02 00 C6 24 01 00 73 26 2A 10 77 02 E9 FF 40 14 04 00 94 26 1C 00 A2 8E 21 20 A0 02 2C 00 BF 8F 08 00 59 8C 28 00 BE 8F 24 00 B7 8F 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 20 03 30 00 BD 27 00 00 B0 8C 04 00 B7 8C 1C 00 A5 8E ?? ?? 02 3C ?? ?? 43 8C 00 00 A4 8C 04 00 A6 AF 09 F8 60 00 21 F0 E0 00 21 90 40 00 2C 00 A2 8E 00 C0 03 3C 21 B0 00 00 24 10 43 00 C2 FF 40 14 21 88 00 00 1E 00 E0 1A 10 00 22 26 80 10 02 00 21 28 62 02 04 00 A2 8F 10 00 C3 27 80 18 03 00 21 20 A3 02 40 30 02 00 21 58 00 00 00 00 A2 8C 0E 00 00 1A 00 00 83 8C 21 48 56 00 21 50 66 00 21 40 00 00 00 00 23 91 01 00 08 25 01 00 29 25 80 10 03 00 03 00 60 10 21 10 42 02 00 00 42 8C 00 00 42 A5 F7 FF 10 15 02 00 4A 25 01 00 6B 25 2A 10 77 01 04 00 A5 24 EC FF 40 14 04 00 84 24 2C 00 BF 8F 28 00 BE 8F 24 00 B7 8F 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_55_4_0 {
	meta:
		name = "_linear_draw_sprite_v_flip15"
		size = 560
	strings:
		$1 = { 08 00 82 8C D0 FF BD 27 1C 00 B5 AF 2C 00 BF AF 28 00 BE AF 24 00 B7 AF 20 00 B6 AF 18 00 B4 AF 14 00 B3 AF 10 00 B2 AF 0C 00 B1 AF 08 00 B0 AF 4C 00 40 10 21 A8 80 00 0C 00 82 8C 10 00 83 8C 00 00 A4 8C 23 40 46 00 23 18 66 00 21 48 00 00 2D 18 64 00 2C 40 09 01 23 80 68 00 69 00 00 5A 2C 00 BF 8F 14 00 A3 8E 18 00 A2 8E 04 00 A4 8C 23 18 67 00 23 10 47 00 2C 18 69 00 2D 10 44 00 23 B0 43 00 5E 00 C0 1A FF FF E2 24 21 10 43 00 21 B8 56 00 2C 00 A2 8E 23 18 83 00 23 20 76 00 00 C0 03 3C 24 10 43 00 38 00 40 10 21 30 06 01 1D 00 C0 1A 10 00 82 24 80 10 02 00 40 40 08 00 21 A0 A2 00 00 00 A8 AF 40 F0 06 00 21 90 00 00 1F 7C 13 24 20 00 A3 8E 21 20 A0 02 23 28 F2 02 09 F8 60 00 00 00 91 8E 0B 00 00 1A 00 00 A3 8F 21 10 5E 00 21 28 23 02 21 18 00 00 00 00 A4 94 01 00 63 24 02 00 93 10 02 00 A5 24 00 00 44 A4 FA FF 70 14 02 00 42 24 01 00 52 26 2A 10 56 02 EC FF 40 14 04 00 94 26 1C 00 A2 8E 21 20 A0 02 2C 00 BF 8F 08 00 59 8C 28 00 BE 8F 24 00 B7 8F 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 20 03 30 00 BD 27 04 00 B6 8C 00 C0 03 3C 00 00 B0 8C FF FF C2 26 21 B8 47 00 2C 00 A2 8E 21 40 00 00 24 10 43 00 CA FF 40 14 21 20 00 00 1C 00 C0 1A 10 00 82 24 10 00 E3 26 80 10 02 00 80 18 03 00 21 20 A2 00 21 18 A3 02 40 28 08 00 40 30 06 00 21 58 00 00 1F 7C 0C 24 00 00 82 8C 0B 00 00 1A 00 00 68 8C 21 48 45 00 21 50 06 01 21 10 00 00 00 00 28 95 01 00 42 24 02 00 0C 11 02 00 29 25 00 00 48 A5 FA FF 50 14 02 00 4A 25 01 00 6B 25 2A 10 76 01 04 00 84 24 EF FF 40 14 FC FF 63 24 2C 00 BF 8F 28 00 BE 8F 24 00 B7 8F 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_55_5_0 {
	meta:
		name = "_linear_draw_sprite_h_flip15"
		size = 564
	strings:
		$1 = { 08 00 82 8C D0 FF BD 27 1C 00 B5 AF 2C 00 BF AF 28 00 BE AF 24 00 B7 AF 20 00 B6 AF 18 00 B4 AF 14 00 B3 AF 10 00 B2 AF 0C 00 B1 AF 08 00 B0 AF 4C 00 40 10 21 A8 80 00 0C 00 83 8C 10 00 82 8C 00 00 AA 8C 23 48 66 00 23 10 46 00 21 58 00 00 2C 48 2B 01 2D 10 4A 00 23 80 49 00 6A 00 00 5A 2C 00 BF 8F 14 00 82 8C 18 00 83 8C 04 00 A4 8C 23 40 47 00 23 18 67 00 2C 40 0B 01 2D 18 64 00 23 B0 68 00 5F 00 C0 1A FF FF C2 24 21 10 49 00 21 30 50 00 2C 00 A2 8E 23 18 49 01 23 20 70 00 00 C0 03 3C 24 10 43 00 39 00 40 10 21 B8 07 01 1D 00 C0 1A 10 00 02 25 80 10 02 00 40 20 04 00 21 A0 A2 00 00 00 A4 AF 40 F0 06 00 21 90 00 00 1F 7C 13 24 20 00 A3 8E 21 20 A0 02 21 28 57 02 09 F8 60 00 00 00 91 8E 0B 00 00 1A 00 00 A3 8F 21 10 5E 00 21 28 23 02 21 18 00 00 00 00 A4 94 01 00 63 24 02 00 93 10 02 00 A5 24 00 00 44 A4 FA FF 70 14 FE FF 42 24 01 00 52 26 2A 10 56 02 EC FF 40 14 04 00 94 26 1C 00 A2 8E 21 20 A0 02 2C 00 BF 8F 08 00 59 8C 28 00 BE 8F 24 00 B7 8F 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 20 03 30 00 BD 27 00 00 B0 8C 00 C0 03 3C 04 00 B6 8C FF FF 02 26 21 30 46 00 2C 00 A2 8E 21 B8 E0 00 21 20 00 00 24 10 43 00 C9 FF 40 14 21 40 00 00 1C 00 C0 1A 10 00 02 25 10 00 E3 26 80 10 02 00 80 18 03 00 21 28 A2 00 21 18 A3 02 40 20 04 00 40 30 06 00 21 58 00 00 1F 7C 0C 24 00 00 A2 8C 0B 00 00 1A 00 00 68 8C 21 48 44 00 21 50 06 01 21 10 00 00 00 00 28 95 01 00 42 24 02 00 0C 11 02 00 29 25 00 00 48 A5 FA FF 50 14 FE FF 4A 25 01 00 6B 25 2A 10 76 01 04 00 A5 24 EF FF 40 14 04 00 63 24 2C 00 BF 8F 28 00 BE 8F 24 00 B7 8F 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_55_6_0 {
	meta:
		name = "_linear_draw_sprite_vh_flip15"
		size = 588
	strings:
		$1 = { 08 00 82 8C D0 FF BD 27 1C 00 B5 AF 2C 00 BF AF 28 00 BE AF 24 00 B7 AF 20 00 B6 AF 18 00 B4 AF 14 00 B3 AF 10 00 B2 AF 0C 00 B1 AF 08 00 B0 AF 21 A8 80 00 50 00 40 10 21 40 A0 00 10 00 82 8C 0C 00 83 8C 00 00 AB 8C 23 10 46 00 23 20 66 00 21 50 00 00 2C 20 8A 00 2D 10 4B 00 23 80 44 00 6F 00 00 5A 2C 00 BF 8F 14 00 A3 8E 18 00 A2 8E 04 00 A9 8C 23 28 67 00 23 10 47 00 2C 28 AA 00 2D 10 49 00 23 B0 45 00 64 00 C0 1A FF FF C2 24 21 10 44 00 FF FF E3 24 21 30 50 00 2C 00 A2 8E 21 18 65 00 21 B8 76 00 00 C0 03 3C 23 20 64 01 23 28 25 01 24 10 43 00 23 20 90 00 3A 00 40 10 23 28 B6 00 1D 00 C0 1A 10 00 A2 24 80 10 02 00 40 20 04 00 21 A0 02 01 00 00 A4 AF 40 F0 06 00 21 90 00 00 1F 7C 13 24 20 00 A3 8E 21 20 A0 02 23 28 F2 02 09 F8 60 00 00 00 91 8E 0B 00 00 1A 00 00 A3 8F 21 10 5E 00 21 28 23 02 21 18 00 00 00 00 A4 94 01 00 63 24 02 00 93 10 02 00 A5 24 00 00 44 A4 FA FF 70 14 FE FF 42 24 01 00 52 26 2A 10 56 02 EC FF 40 14 04 00 94 26 1C 00 A2 8E 21 20 A0 02 2C 00 BF 8F 08 00 59 8C 28 00 BE 8F 24 00 B7 8F 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 20 03 30 00 BD 27 00 00 B0 8C 04 00 B6 8C 21 20 00 00 FF FF 02 26 21 30 46 00 2C 00 A2 8E FF FF C3 26 21 B8 67 00 00 C0 03 3C 24 10 43 00 C8 FF 40 14 21 28 00 00 1C 00 C0 1A 10 00 A2 24 10 00 E3 26 80 10 02 00 80 18 03 00 21 28 02 01 21 18 A3 02 40 20 04 00 40 30 06 00 21 58 00 00 1F 7C 0C 24 00 00 A2 8C 0B 00 00 1A 00 00 68 8C 21 48 44 00 21 50 06 01 21 10 00 00 00 00 28 95 01 00 42 24 02 00 0C 11 02 00 29 25 00 00 48 A5 FA FF 50 14 FE FF 4A 25 01 00 6B 25 2A 10 76 01 04 00 A5 24 EF FF 40 14 FC FF 63 24 2C 00 BF 8F 28 00 BE 8F 24 00 B7 8F 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_55_7_0 {
	meta:
		name = "_linear_draw_trans_sprite15"
		size = 976
		refs = "0094 _blender_func15 00ec _blender_alpha"
	strings:
		$1 = { 08 00 82 8C B0 FF BD 27 40 00 B6 AF 4C 00 BF AF 48 00 BE AF 44 00 B7 AF 3C 00 B5 AF 38 00 B4 AF 34 00 B3 AF 30 00 B2 AF 2C 00 B1 AF 28 00 B0 AF 61 00 40 10 21 B0 80 00 0C 00 82 8C 10 00 83 8C 00 00 A4 8C 23 10 46 00 23 18 66 00 21 48 00 00 2C 10 49 00 2D 18 64 00 23 A0 62 00 91 00 80 1A 18 00 A2 AF 14 00 C2 8E 18 00 C3 8E 04 00 A4 8C 23 40 47 00 23 18 67 00 2C 40 09 01 2D 18 64 00 23 18 68 00 87 00 60 18 20 00 A3 AF 18 00 A2 8F 21 38 07 01 ?? ?? 03 3C 21 30 46 00 1C 00 A2 8C 1C 00 A7 AF 00 00 44 8C 08 00 02 24 4E 00 82 14 ?? ?? 75 8C 1C 00 C3 8E 00 00 62 8C 4B 00 44 50 2C 00 C2 8E 20 00 A4 8F 2D 00 80 18 10 00 02 25 FF FF 94 26 80 10 02 00 40 30 06 00 10 00 B4 AF 21 B8 A2 00 08 00 A6 AF 21 A0 00 00 ?? ?? 1E 3C 1C 00 A2 8F 24 00 C3 8E 21 20 C0 02 21 80 82 02 21 28 00 02 09 F8 60 00 00 00 F2 8E 20 00 C3 8E 21 28 00 02 21 20 C0 02 09 F8 60 00 21 88 40 00 10 00 A3 8F 10 00 60 04 08 00 A3 8F 18 00 A4 8F 10 00 B0 8F 21 98 44 02 21 90 23 02 21 88 43 00 00 00 64 92 00 00 45 96 ?? ?? C6 8F FF FF 10 26 09 F8 A0 02 01 00 73 26 00 00 22 A6 02 00 52 26 F7 FF 01 06 02 00 31 26 20 00 A4 8F 01 00 94 26 2A 10 84 02 DE FF 40 14 04 00 F7 26 1C 00 C3 8E 08 00 79 8C 21 20 C0 02 4C 00 BF 8F 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 20 03 50 00 BD 27 1C 00 A2 8C 04 00 A3 8C 00 00 B4 8C 00 00 44 8C 20 00 A3 AF 08 00 02 24 ?? ?? 03 3C 1C 00 A7 AF 18 00 A0 AF 21 40 00 00 B4 FF 82 10 ?? ?? 75 8C 2C 00 C2 8E 00 C0 03 3C 24 10 43 00 37 00 40 54 20 00 A3 8F 20 00 A2 8F 28 00 40 18 10 00 02 25 80 10 02 00 1C 00 A4 8F 21 F0 A2 00 18 00 A2 8F 10 00 83 24 80 18 03 00 40 30 06 00 40 10 02 00 21 B0 C3 02 0C 00 A6 AF 14 00 A2 AF 21 98 00 00 1F 7C 17 24 00 00 C2 8F 12 00 80 1A 00 00 C3 8E 14 00 A4 8F 21 80 00 00 21 90 44 00 0C 00 A2 8F 21 88 62 00 00 00 42 96 01 00 10 26 02 00 52 26 06 00 57 10 21 20 40 00 ?? ?? 03 3C 00 00 25 96 09 F8 A0 02 ?? ?? 66 8C 00 00 22 A6 F5 FF 14 16 02 00 31 26 20 00 A4 8F 01 00 73 26 04 00 DE 27 2A 10 64 02 E7 FF 40 14 04 00 D6 26 4C 00 BF 8F 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 50 00 BD 27 2F 00 60 18 18 00 A4 8F 10 00 02 25 80 10 02 00 40 30 06 00 40 20 04 00 21 F0 A2 00 04 00 A6 AF 00 00 A4 AF 21 B8 00 00 1C 00 A2 8F 24 00 C3 8E 21 20 C0 02 21 80 E2 02 21 28 00 02 09 F8 60 00 00 00 D1 8F 20 00 C3 8E 21 28 00 02 21 20 C0 02 09 F8 60 00 21 90 40 00 14 00 80 1A 04 00 A4 8F 00 00 A3 8F 21 80 00 00 21 98 44 02 21 88 23 02 21 90 44 00 00 00 22 96 1F 7C 03 24 01 00 10 26 02 00 31 26 06 00 43 10 21 20 40 00 ?? ?? 02 3C 00 00 65 96 09 F8 A0 02 ?? ?? 46 8C 00 00 42 A6 02 00 73 26 F3 FF 14 16 02 00 52 26 20 00 A3 8F 01 00 F7 26 2A 10 E3 02 DB FF 40 14 04 00 DE 27 1C 00 C2 8E 21 20 C0 02 4C 00 BF 8F 08 00 59 8C 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 20 03 50 00 BD 27 }
	condition:
		$1
}

rule file_55_8_0 {
	meta:
		name = "_linear_draw_trans_rgba_sprite15"
		size = 512
		refs = "008c _blender_func15x 00a0 .text 015c _blender_alpha"
	strings:
		$1 = { 08 00 82 8C C0 FF BD 27 30 00 B6 AF 3C 00 BF AF 38 00 BE AF 34 00 B7 AF 2C 00 B5 AF 28 00 B4 AF 24 00 B3 AF 20 00 B2 AF 1C 00 B1 AF 18 00 B0 AF 1D 00 40 10 21 B0 80 00 0C 00 82 8C 10 00 83 8C 00 00 A4 8C 23 48 46 00 23 18 66 00 21 50 00 00 2D 18 64 00 2C 48 2A 01 23 A0 69 00 5D 00 80 1A 3C 00 BF 8F 14 00 C2 8E 18 00 C3 8E 04 00 A4 8C 23 40 47 00 23 18 67 00 2C 40 0A 01 2D 18 64 00 23 18 68 00 52 00 60 18 08 00 A3 AF ?? ?? 02 3C ?? ?? 42 8C 21 38 07 01 21 30 26 01 00 00 A2 AF ?? ?? ?? 0? 04 00 A7 AF 04 00 A2 8C 00 00 B4 8C 08 00 A2 AF ?? ?? 02 3C ?? ?? 42 8C 08 00 A3 8F 34 00 60 18 00 00 A2 AF 04 00 A7 AF 21 48 00 00 21 40 00 00 10 00 02 25 80 10 02 00 21 B8 A2 00 80 48 09 00 40 30 06 00 FF 00 02 3C 10 00 A9 AF 0C 00 A6 AF FF 00 5E 34 21 A8 00 00 04 00 A2 8F 24 00 C3 8E 21 20 C0 02 21 80 A2 02 21 28 00 02 09 F8 60 00 00 00 F1 8E 20 00 C3 8E 21 28 00 02 21 20 C0 02 09 F8 60 00 21 90 40 00 14 00 80 1A 10 00 A3 8F 21 80 00 00 21 88 23 02 0C 00 A3 8F 21 98 43 02 21 90 43 00 00 00 22 8E 01 00 10 26 04 00 31 26 07 00 5E 10 21 20 40 00 ?? ?? 02 3C 00 00 65 96 00 00 A3 8F 09 F8 60 00 ?? ?? 46 8C 00 00 42 A6 02 00 73 26 F3 FF 14 16 02 00 52 26 08 00 A3 8F 01 00 B5 26 2A 10 A3 02 DB FF 40 14 04 00 F7 26 1C 00 C2 8E 21 20 C0 02 3C 00 BF 8F 08 00 59 8C 38 00 BE 8F 34 00 B7 8F 30 00 B6 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 20 03 40 00 BD 27 3C 00 BF 8F 38 00 BE 8F 34 00 B7 8F 30 00 B6 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 40 00 BD 27 }
	condition:
		$1
}

rule file_75_8_0 {
	meta:
		name = "_linear_draw_trans_rgba_sprite16"
		size = 512
		refs = "008c _blender_func16x 00a0 .text 015c _blender_alpha"
	strings:
		$1 = { 08 00 82 8C C0 FF BD 27 30 00 B6 AF 3C 00 BF AF 38 00 BE AF 34 00 B7 AF 2C 00 B5 AF 28 00 B4 AF 24 00 B3 AF 20 00 B2 AF 1C 00 B1 AF 18 00 B0 AF 1D 00 40 10 21 B0 80 00 0C 00 82 8C 10 00 83 8C 00 00 A4 8C 23 48 46 00 23 18 66 00 21 50 00 00 2D 18 64 00 2C 48 2A 01 23 A0 69 00 5D 00 80 1A 3C 00 BF 8F 14 00 C2 8E 18 00 C3 8E 04 00 A4 8C 23 40 47 00 23 18 67 00 2C 40 0A 01 2D 18 64 00 23 18 68 00 52 00 60 18 08 00 A3 AF ?? ?? 02 3C ?? ?? 42 8C 21 38 07 01 21 30 26 01 00 00 A2 AF ?? ?? ?? 0? 04 00 A7 AF 04 00 A2 8C 00 00 B4 8C 08 00 A2 AF ?? ?? 02 3C ?? ?? 42 8C 08 00 A3 8F 34 00 60 18 00 00 A2 AF 04 00 A7 AF 21 48 00 00 21 40 00 00 10 00 02 25 80 10 02 00 21 B8 A2 00 80 48 09 00 40 30 06 00 FF 00 02 3C 10 00 A9 AF 0C 00 A6 AF FF 00 5E 34 21 A8 00 00 04 00 A2 8F 24 00 C3 8E 21 20 C0 02 21 80 A2 02 21 28 00 02 09 F8 60 00 00 00 F1 8E 20 00 C3 8E 21 28 00 02 21 20 C0 02 09 F8 60 00 21 90 40 00 14 00 80 1A 10 00 A3 8F 21 80 00 00 21 88 23 02 0C 00 A3 8F 21 98 43 02 21 90 43 00 00 00 22 8E 01 00 10 26 04 00 31 26 07 00 5E 10 21 20 40 00 ?? ?? 02 3C 00 00 65 96 00 00 A3 8F 09 F8 60 00 ?? ?? 46 8C 00 00 42 A6 02 00 73 26 F3 FF 14 16 02 00 52 26 08 00 A3 8F 01 00 B5 26 2A 10 A3 02 DB FF 40 14 04 00 F7 26 1C 00 C2 8E 21 20 C0 02 3C 00 BF 8F 08 00 59 8C 38 00 BE 8F 34 00 B7 8F 30 00 B6 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 20 03 40 00 BD 27 3C 00 BF 8F 38 00 BE 8F 34 00 B7 8F 30 00 B6 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 40 00 BD 27 }
	condition:
		$1
}

rule file_55_9_0 {
	meta:
		name = "_linear_draw_lit_sprite15"
		size = 696
		refs = "0094 _blender_func15 00e8 _blender_col_15"
	strings:
		$1 = { 08 00 82 8C B8 FF BD 27 40 00 BE AF 44 00 BF AF 3C 00 B7 AF 38 00 B6 AF 34 00 B5 AF 30 00 B4 AF 2C 00 B3 AF 28 00 B2 AF 24 00 B1 AF 20 00 B0 AF 1C 00 A4 AF 5A 00 40 10 21 F0 00 01 0C 00 82 8C 10 00 83 8C 00 00 A4 8C 23 48 46 00 23 18 66 00 21 50 00 00 2D 18 64 00 2C 48 2A 01 23 98 69 00 89 00 60 1A 1C 00 A3 8F 04 00 A4 8C 14 00 62 8C 18 00 63 8C 23 40 47 00 23 18 67 00 2C 40 0A 01 2D 18 64 00 23 18 68 00 7F 00 60 18 18 00 A3 AF 1C 00 A3 8F ?? ?? 04 3C ?? ?? 84 8C 2C 00 62 8C 00 C0 03 3C 21 38 07 01 24 10 43 00 21 30 26 01 14 00 A7 AF 48 00 40 10 10 00 A4 AF 18 00 A2 8F 27 00 40 18 10 00 02 25 80 10 02 00 40 48 09 00 40 30 06 00 21 A8 A2 00 0C 00 A9 AF 00 00 A6 AF 21 A0 00 00 1F 7C 16 24 ?? ?? 17 3C 1C 00 A4 8F 14 00 A2 8F 00 00 B0 8E 20 00 83 8C 09 F8 60 00 21 28 82 02 11 00 60 1A 0C 00 A3 8F 00 00 A4 8F 21 88 03 02 21 90 44 00 21 80 00 00 00 00 22 96 21 30 C0 03 01 00 10 26 21 28 40 00 05 00 56 10 02 00 31 26 10 00 A3 8F 09 F8 60 00 ?? ?? E4 8E 00 00 42 A6 F5 FF 13 16 02 00 52 26 18 00 A4 8F 01 00 94 26 2A 10 84 02 E4 FF 40 14 04 00 B5 26 1C 00 A3 8F 44 00 BF 8F 40 00 BE 8F 1C 00 62 8C 3C 00 B7 8F 38 00 B6 8F 08 00 59 8C 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 21 20 60 00 08 00 20 03 48 00 BD 27 04 00 A4 8C 1C 00 A3 8F 00 00 B3 8C 18 00 A4 AF 2C 00 62 8C ?? ?? 04 3C ?? ?? 84 8C 00 C0 03 3C 24 10 43 00 14 00 A7 AF 21 48 00 00 21 40 00 00 BA FF 40 14 10 00 A4 AF 18 00 A4 8F 2A 00 80 18 10 00 02 25 14 00 A4 8F 80 10 02 00 21 B8 A2 00 1C 00 A2 8F 10 00 83 24 80 18 03 00 40 48 09 00 40 30 06 00 21 A8 43 00 08 00 A9 AF 04 00 A6 AF 21 A0 00 00 1F 7C 16 24 00 00 E2 8E 14 00 60 1A 00 00 A3 8E 08 00 A4 8F 21 80 00 00 21 88 44 00 04 00 A2 8F 21 90 62 00 00 00 22 96 21 30 C0 03 01 00 10 26 21 28 40 00 07 00 56 10 02 00 31 26 ?? ?? 03 3C ?? ?? 64 8C 10 00 A3 8F 09 F8 60 00 00 00 00 00 00 00 42 A6 F3 FF 13 16 02 00 52 26 18 00 A4 8F 01 00 94 26 04 00 F7 26 2A 10 84 02 E5 FF 40 14 04 00 B5 26 44 00 BF 8F 40 00 BE 8F 3C 00 B7 8F 38 00 B6 8F 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_55_10_0 {
	meta:
		name = "_linear_draw_character15"
		size = 596
		refs = "00e4 .text"
		altNames = "_linear_draw_character16"
	strings:
		$1 = { 08 00 82 8C D0 FF BD 27 20 00 B6 AF 1C 00 B5 AF 18 00 B4 AF 2C 00 BF AF 28 00 BE AF 24 00 B7 AF 14 00 B3 AF 10 00 B2 AF 0C 00 B1 AF 08 00 B0 AF 21 A0 80 00 21 B0 00 01 4A 00 40 10 21 A8 20 01 0C 00 82 8C 10 00 83 8C 00 00 A4 8C 23 B8 46 00 23 18 66 00 21 40 00 00 2D 18 64 00 2C B8 E8 02 23 80 77 00 70 00 00 5A 2C 00 BF 8F 14 00 82 8E 18 00 83 8E 04 00 A4 8C 23 10 47 00 23 18 67 00 2C 10 48 00 2D 18 64 00 23 F0 62 00 65 00 C0 1B 21 38 47 00 21 30 E6 02 38 00 A0 06 04 00 A7 AF 21 00 C0 1B 40 30 06 00 10 00 42 24 80 10 02 00 21 98 A2 00 00 00 A6 AF 21 90 00 00 04 00 A2 8F 20 00 83 8E 21 20 80 02 21 28 42 02 09 F8 60 00 00 00 71 8E 10 00 00 1A 00 00 A3 8F 21 28 37 02 21 20 43 00 ?? ?? ?? 0? 21 18 00 00 00 00 96 A4 01 00 A5 24 08 00 70 10 02 00 84 24 00 00 A2 90 FA FF 40 14 01 00 63 24 00 00 95 A4 01 00 A5 24 FA FF 70 14 02 00 84 24 01 00 52 26 2A 10 5E 02 E6 FF 40 14 04 00 73 26 1C 00 82 8E 21 20 80 02 2C 00 BF 8F 08 00 59 8C 28 00 BE 8F 24 00 B7 8F 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 20 03 30 00 BD 27 00 00 B0 8C 04 00 BE 8C 04 00 A7 AF 21 B8 00 00 CA FF A1 06 21 10 00 00 EA FF C0 1B 40 A8 06 00 10 00 42 24 80 10 02 00 21 98 A2 00 21 90 00 00 04 00 A2 8F 20 00 83 8E 21 20 80 02 21 28 42 02 09 F8 60 00 00 00 71 8E 0A 00 00 1A 21 20 37 02 21 28 55 00 21 18 00 00 00 00 82 90 01 00 63 24 02 00 40 10 01 00 84 24 00 00 B6 A4 FA FF 70 14 02 00 A5 24 01 00 52 26 2A 10 5E 02 EC FF 40 14 04 00 73 26 1C 00 82 8E 21 20 80 02 2C 00 BF 8F 08 00 59 8C 28 00 BE 8F 24 00 B7 8F 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 20 03 30 00 BD 27 2C 00 BF 8F 28 00 BE 8F 24 00 B7 8F 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_55_11_0 {
	meta:
		name = "_linear_draw_rle_sprite15"
		size = 1132
		refs = "011c .text"
	strings:
		$1 = { 08 00 82 8C D0 FF BD 27 18 00 B4 AF 2C 00 BF AF 28 00 BE AF 24 00 B7 AF 20 00 B6 AF 1C 00 B5 AF 14 00 B3 AF 10 00 B2 AF 0C 00 B1 AF 08 00 B0 AF 91 00 40 10 21 A0 80 00 0C 00 82 8C 10 00 8C 8C 00 00 A9 8C 23 98 46 00 21 58 00 00 23 10 86 01 2C 98 6B 02 2D 10 49 00 23 A8 53 00 DA 00 A0 1A 21 50 66 02 14 00 82 8C 18 00 83 8C 04 00 A4 8C 23 40 47 00 23 18 67 00 2C 40 0B 01 2D 18 64 00 23 B8 68 00 D0 00 E0 1A 21 B0 07 01 11 00 00 11 10 00 B0 24 21 28 00 00 1F 7C 04 24 00 00 03 86 FF FF 62 30 08 00 44 10 02 00 10 26 FB FF 60 18 40 10 03 00 21 80 02 02 00 00 03 86 FF FF 62 30 FA FF 44 14 02 00 10 26 01 00 A5 24 F4 FF A8 54 00 00 03 86 71 00 60 12 21 10 C9 00 40 50 0A 00 00 00 AA AF 21 90 00 00 1F 7C 11 24 FE FF 1E 24 20 00 83 8E 21 28 56 02 09 F8 60 00 21 20 80 02 21 28 40 00 00 00 06 86 1A 00 60 12 02 00 10 26 FF FF C2 30 45 00 51 10 21 20 60 02 ?? ?? ?? 0? 40 18 06 00 B4 00 42 04 40 10 04 00 21 80 03 02 00 00 06 86 21 20 40 00 0E 00 40 10 02 00 10 26 FF FF C2 30 3A 00 51 50 01 00 52 26 40 18 06 00 F4 FF C0 1C 23 10 86 00 21 30 C4 00 05 00 C0 04 21 10 C0 00 21 20 40 00 00 00 06 86 F4 FF 40 14 02 00 10 26 23 00 A0 1A FF FF C2 30 2B 00 51 10 00 00 A2 8F 21 18 A0 02 17 00 C0 18 21 40 A2 00 23 38 66 00 9B 00 E0 04 21 28 00 02 21 20 00 01 21 18 00 00 00 00 A2 84 01 00 63 24 02 00 A5 24 00 00 82 A4 FB FF 66 14 02 00 84 24 40 10 03 00 21 80 02 02 00 00 06 86 21 40 02 01 0D 00 E0 18 02 00 10 26 FF FF C2 30 15 00 51 50 01 00 52 26 EB FF C0 1C 21 18 E0 00 13 00 00 01 21 38 C3 00 1C 00 DE 00 00 00 06 86 02 00 10 26 F5 FF E0 1C 12 40 00 00 FF FF C2 30 09 00 51 50 01 00 52 26 02 00 C0 18 40 10 06 00 21 80 02 02 00 00 06 86 FF FF C2 30 FA FF 51 14 02 00 10 26 01 00 52 26 2A 10 57 02 AF FF 40 54 20 00 83 8E 1C 00 82 8E 21 20 80 02 2C 00 BF 8F 08 00 59 8C 28 00 BE 8F 24 00 B7 8F 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 20 03 30 00 BD 27 00 00 A9 8C 04 00 B7 8C 10 00 8C 8C 10 00 B0 24 21 B0 E0 00 21 A8 20 01 21 50 C0 00 21 98 00 00 21 10 C9 00 2A 10 4C 00 45 00 40 10 00 00 00 00 E4 FF E0 1A 40 98 0A 00 21 88 00 00 1F 7C 12 24 FE FF 1E 24 20 00 83 8E 21 20 80 02 09 F8 60 00 21 28 36 02 21 18 40 00 00 00 02 86 25 00 A0 1A 02 00 10 26 21 30 40 00 FF FF 42 30 21 00 52 10 21 40 73 00 18 00 C0 18 21 18 A0 02 23 38 66 00 4D 00 E0 04 21 28 00 02 21 20 00 01 21 18 00 00 00 00 A2 84 01 00 63 24 02 00 A5 24 00 00 82 A4 FB FF 66 14 02 00 84 24 40 10 03 00 21 80 02 02 21 40 02 01 00 00 02 86 0E 00 E0 18 02 00 10 26 21 30 40 00 FF FF 42 30 0B 00 52 50 01 00 31 26 EA FF C0 1C 21 18 E0 00 13 00 00 01 21 38 C3 00 00 00 02 86 02 00 10 26 1C 00 DE 00 F4 FF E0 1C 12 40 00 00 01 00 31 26 2A 10 37 02 D2 FF 40 54 20 00 83 8E 1C 00 82 8E 21 20 80 02 2C 00 BF 8F 08 00 59 8C 28 00 BE 8F 24 00 B7 8F 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 20 03 30 00 BD 27 49 FF E0 1E 40 50 0A 00 ?? ?? ?? 0? 1C 00 82 8E 2C 00 BF 8F 28 00 BE 8F 24 00 B7 8F 20 00 B6 8F 1C 00 B5 8F 18 00 B4 8F 14 00 B3 8F 10 00 B2 8F 0C 00 B1 8F 08 00 B0 8F 08 00 E0 03 30 00 BD 27 21 80 02 02 ?? ?? ?? 0? 23 30 C4 00 21 20 00 00 00 00 02 86 01 00 84 24 02 00 10 26 00 00 02 A5 FB FF 83 14 02 00 08 25 40 10 04 00 21 80 A2 00 ?? ?? ?? 0? 23 30 C4 00 21 20 00 00 00 00 02 86 01 00 84 24 02 00 10 26 00 00 02 A5 FB FF 83 14 02 00 08 25 40 10 04 00 01 00 31 26 21 80 A2 00 2A 10 37 02 98 FF 40 54 20 00 83 8E ?? ?? ?? 0? 1C 00 82 8E }
	condition:
		$1
}

rule file_55_12_0 {
	meta:
		name = "_linear_draw_trans_rle_sprite15"
		size = 1508
		refs = "00a4 _blender_func15 0168 .text 0204 _blender_alpha"
	strings:
		$1 = { 08 00 82 8C B0 FF BD 27 4C 00 BF AF 48 00 BE AF 44 00 B7 AF 40 00 B6 AF 3C 00 B5 AF 38 00 B4 AF 34 00 B3 AF 30 00 B2 AF 2C 00 B1 AF 28 00 B0 AF B8 00 40 10 24 00 A4 AF 0C 00 82 8C 10 00 8C 8C 00 00 AB 8C 23 10 46 00 10 00 A2 AF 10 00 A3 8F 21 50 00 00 23 10 86 01 2C 18 6A 00 2D 10 4B 00 23 10 43 00 10 00 A3 AF 1C 00 A2 AF 28 01 40 18 21 48 66 00 14 00 82 8C 18 00 83 8C 04 00 A4 8C 23 40 47 00 23 18 67 00 2C 40 0A 01 2D 18 64 00 23 18 68 00 21 38 07 01 18 00 A3 AF 1C 01 60 18 14 00 A7 AF ?? ?? 02 3C ?? ?? 42 8C 10 00 B5 24 11 00 00 11 0C 00 A2 AF 21 28 00 00 1F 7C 04 24 00 00 A3 86 FF FF 62 30 08 00 44 10 02 00 B5 26 FB FF 60 18 40 10 03 00 21 A8 A2 02 00 00 A3 86 FF FF 62 30 FA FF 44 14 02 00 B5 26 01 00 A5 24 F4 FF A8 54 00 00 A3 86 10 00 A2 8F 93 00 40 10 21 10 CB 00 40 48 09 00 04 00 A9 AF 20 00 A0 AF 24 00 A2 8F 20 00 A4 8F 24 00 43 8C 14 00 A2 8F 21 80 82 00 24 00 A4 8F 09 F8 60 00 21 28 00 02 24 00 A4 8F 21 28 00 02 20 00 83 8C 09 F8 60 00 21 88 40 00 21 28 40 00 10 00 A2 8F 00 00 B4 86 1C 00 40 10 02 00 B5 26 FF FF 82 32 1F 7C 03 24 57 00 43 10 10 00 A4 8F ?? ?? ?? 0? 40 18 14 00 F3 00 42 04 40 10 04 00 21 A8 A3 02 00 00 B4 86 21 20 40 00 0F 00 40 10 02 00 B5 26 FF FF 82 32 1F 7C 03 24 4B 00 43 50 20 00 A4 8F 40 18 14 00 F3 FF 80 1E 23 10 94 00 21 A0 84 02 05 00 80 06 21 10 80 02 21 20 40 00 00 00 B4 86 F3 FF 40 14 02 00 B5 26 1C 00 A4 8F 31 00 80 18 FF FF 82 32 1F 7C 03 24 3A 00 43 10 04 00 A4 8F 1C 00 B0 8F 21 F0 24 02 21 00 80 1A 21 B8 A4 00 23 B0 14 02 D6 00 C0 06 FF FF 93 26 21 90 A0 02 21 88 C0 03 21 80 E0 02 ?? ?? 02 3C 00 00 44 86 00 00 25 96 ?? ?? 46 8C 0C 00 A3 8F FF FF 73 26 09 F8 60 00 02 00 52 26 FF FF 04 24 00 00 02 A6 02 00 31 26 F4 FF 64 16 02 00 10 26 40 10 14 00 21 A8 A2 02 00 00 B4 86 21 B8 E2 02 21 F0 C2 03 10 00 C0 1A 02 00 B5 26 FF FF 82 32 1F 7C 03 24 19 00 43 10 20 00 A4 8F E1 FF 80 1E 21 80 C0 02 FE FF 03 24 18 00 83 02 21 B0 90 02 00 00 B4 86 02 00 B5 26 12 10 00 00 21 B8 E2 02 F2 FF C0 1E 21 F0 C2 03 FF FF 82 32 1F 7C 04 24 0A 00 44 10 20 00 A4 8F 02 00 80 1A 40 10 14 00 21 A8 A2 02 00 00 B4 86 1F 7C 03 24 FF FF 82 32 F9 FF 43 14 02 00 B5 26 20 00 A4 8F 18 00 A3 8F 01 00 84 24 2A 10 83 00 8F FF 40 14 20 00 A4 AF 24 00 A4 8F 4C 00 BF 8F 48 00 BE 8F 1C 00 82 8C 44 00 B7 8F 40 00 B6 8F 08 00 59 8C 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 20 03 50 00 BD 27 24 00 A4 8F ?? ?? 02 3C 00 00 AB 8C ?? ?? 42 8C 10 00 B5 24 04 00 A5 8C 10 00 8C 8C 0C 00 A2 AF 14 00 A7 AF 1C 00 AB AF 18 00 A5 AF 21 48 C0 00 10 00 A0 AF 21 10 CB 00 2A 10 4C 00 6B 00 40 10 18 00 A3 8F 18 00 A4 8F DE FF 80 18 40 48 09 00 08 00 A9 AF 00 00 A0 AF 24 00 A4 8F 00 00 A2 8F 24 00 83 8C 14 00 A4 8F 21 80 44 00 24 00 A4 8F 09 F8 60 00 21 28 00 02 21 88 40 00 24 00 A2 8F 21 28 00 02 20 00 43 8C 09 F8 60 00 21 20 40 00 1C 00 A4 8F 00 00 B4 86 21 18 40 00 32 00 80 18 02 00 B5 26 FF FF 82 32 1F 7C 04 24 3A 00 44 10 08 00 A2 8F 1C 00 B0 8F 21 F0 22 02 21 00 80 1A 21 B8 62 00 23 B0 14 02 6E 00 C0 06 FF FF 93 26 21 90 A0 02 21 88 C0 03 21 80 E0 02 ?? ?? 02 3C 00 00 44 86 00 00 25 96 ?? ?? 46 8C 0C 00 A3 8F FF FF 73 26 09 F8 60 00 02 00 52 26 FF FF 04 24 00 00 02 A6 02 00 31 26 F4 FF 64 16 02 00 10 26 40 10 14 00 21 A8 A2 02 00 00 B4 86 21 B8 E2 02 21 F0 C2 03 10 00 C0 1A 02 00 B5 26 FF FF 82 32 1F 7C 03 24 19 00 43 10 00 00 A4 8F E1 FF 80 1E 21 80 C0 02 FE FF 03 24 18 00 83 02 21 B0 90 02 00 00 B4 86 02 00 B5 26 12 10 00 00 21 B8 E2 02 F2 FF C0 1E 21 F0 C2 03 FF FF 82 32 1F 7C 04 24 0A 00 44 10 00 00 A4 8F 02 00 80 1A 40 10 14 00 21 A8 A2 02 00 00 B4 86 1F 7C 03 24 FF FF 82 32 F9 FF 43 14 02 00 B5 26 00 00 A4 8F 18 00 A3 8F 01 00 84 24 2A 10 83 00 AB FF 40 14 00 00 A4 AF 24 00 A4 8F 4C 00 BF 8F 48 00 BE 8F 1C 00 82 8C 44 00 B7 8F 40 00 B6 8F 08 00 59 8C 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 20 03 50 00 BD 27 01 FF 60 1C 40 48 09 00 ?? ?? ?? 0? 24 00 A4 8F 4C 00 BF 8F 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 50 00 BD 27 21 A8 A2 02 ?? ?? ?? 0? 23 A0 84 02 21 90 A0 02 FF FF 11 26 ?? ?? 02 3C 00 00 A4 86 00 00 C5 97 ?? ?? 46 8C 0C 00 A3 8F FF FF 31 26 09 F8 60 00 02 00 B5 26 FF FF 04 24 00 00 E2 A6 02 00 DE 27 F4 FF 24 16 02 00 F7 26 40 10 10 00 21 A8 42 02 ?? ?? ?? 0? 23 A0 90 02 21 90 A0 02 FF FF 11 26 ?? ?? 02 3C 00 00 A4 86 00 00 C5 97 ?? ?? 46 8C 0C 00 A3 8F FF FF 31 26 09 F8 60 00 02 00 B5 26 FF FF 04 24 00 00 E2 A6 02 00 DE 27 F4 FF 24 16 02 00 F7 26 40 10 10 00 21 A8 42 02 ?? ?? ?? 0? 23 A0 90 02 }
	condition:
		$1
}

rule file_55_13_0 {
	meta:
		name = "_linear_draw_trans_rgba_rle_sprite15"
		size = 1492
		refs = "00a4 _blender_func15x 0164 .text 0200 _blender_alpha"
	strings:
		$1 = { 08 00 82 8C B0 FF BD 27 4C 00 BF AF 48 00 BE AF 44 00 B7 AF 40 00 B6 AF 3C 00 B5 AF 38 00 B4 AF 34 00 B3 AF 30 00 B2 AF 2C 00 B1 AF 28 00 B0 AF B8 00 40 10 24 00 A4 AF 0C 00 82 8C 10 00 8C 8C 00 00 AB 8C 23 10 46 00 10 00 A2 AF 10 00 A3 8F 21 50 00 00 23 10 86 01 2C 18 6A 00 2D 10 4B 00 23 10 43 00 10 00 A3 AF 1C 00 A2 AF 1E 01 40 18 21 48 66 00 14 00 82 8C 18 00 83 8C 04 00 A4 8C 23 40 47 00 23 18 67 00 2C 40 0A 01 2D 18 64 00 23 18 68 00 21 38 07 01 18 00 A3 AF 12 01 60 18 14 00 A7 AF ?? ?? 02 3C ?? ?? 42 8C 10 00 B5 24 10 00 00 11 0C 00 A2 AF FF 00 02 3C FF 00 42 34 21 28 00 00 00 00 A3 8E 07 00 62 10 04 00 B5 26 FC FF 60 18 80 20 03 00 21 A8 A4 02 00 00 A3 8E FB FF 62 14 04 00 B5 26 01 00 A5 24 F6 FF A8 54 00 00 A3 8E 10 00 A2 8F 94 00 40 10 21 10 CB 00 40 48 09 00 04 00 A9 AF 20 00 A0 AF 24 00 A2 8F 20 00 A4 8F 24 00 43 8C 14 00 A2 8F 21 80 82 00 24 00 A4 8F 09 F8 60 00 21 28 00 02 24 00 A4 8F 21 28 00 02 20 00 83 8C 09 F8 60 00 21 88 40 00 21 28 40 00 10 00 A2 8F 00 00 B4 8E 1C 00 40 10 04 00 B5 26 FF 00 03 3C FF 00 63 34 58 00 83 12 21 20 40 00 ?? ?? ?? 0? 80 18 14 00 EA 00 42 04 80 10 04 00 21 A8 A3 02 00 00 B4 8E 21 20 40 00 0F 00 40 10 04 00 B5 26 FF 00 02 3C FF 00 42 34 4C 00 82 12 20 00 A3 8F 80 18 14 00 F3 FF 80 1E 23 10 94 00 21 A0 84 02 05 00 80 06 21 10 80 02 21 20 40 00 00 00 B4 8E F3 FF 40 14 04 00 B5 26 1C 00 A3 8F 32 00 60 18 FF 00 04 3C FF 00 84 34 3B 00 84 12 04 00 A2 8F 21 80 60 00 21 F0 22 02 22 00 80 1A 21 B8 A2 00 23 B0 14 02 CD 00 C0 06 FF FF 93 26 21 90 A0 02 21 88 C0 03 21 80 E0 02 ?? ?? 02 3C 00 00 44 8E 00 00 25 96 ?? ?? 46 8C 0C 00 A3 8F FF FF 73 26 09 F8 60 00 04 00 52 26 FF FF 04 24 00 00 02 A6 02 00 31 26 F4 FF 64 16 02 00 10 26 80 18 14 00 40 10 14 00 21 A8 A3 02 00 00 B4 8E 21 F0 C2 03 21 B8 E2 02 10 00 C0 1A 04 00 B5 26 FF 00 03 3C FF 00 63 34 19 00 83 12 20 00 A3 8F E0 FF 80 1E 21 80 C0 02 FE FF 03 24 18 00 83 02 21 B0 90 02 00 00 B4 8E 04 00 B5 26 12 10 00 00 21 B8 E2 02 F2 FF C0 1E 21 F0 C2 03 FF 00 04 3C FF 00 84 34 0A 00 84 12 20 00 A3 8F 02 00 80 1A 80 10 14 00 21 A8 A2 02 00 00 B4 8E FF 00 02 3C FF 00 42 34 F9 FF 82 16 04 00 B5 26 20 00 A3 8F 18 00 A4 8F 01 00 63 24 2A 10 64 00 8E FF 40 14 20 00 A3 AF 24 00 A4 8F 4C 00 BF 8F 48 00 BE 8F 1C 00 82 8C 44 00 B7 8F 40 00 B6 8F 08 00 59 8C 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 20 03 50 00 BD 27 24 00 A4 8F ?? ?? 02 3C 00 00 AB 8C ?? ?? 42 8C 10 00 B5 24 04 00 A5 8C 10 00 8C 8C 0C 00 A2 AF 14 00 A7 AF 1C 00 AB AF 18 00 A5 AF 21 48 C0 00 10 00 A0 AF 21 10 CB 00 2A 10 4C 00 61 00 40 10 18 00 A3 8F 18 00 A4 8F DE FF 80 18 40 48 09 00 08 00 A9 AF 00 00 A0 AF 24 00 A2 8F 00 00 A4 8F 24 00 43 8C 14 00 A2 8F 21 80 82 00 24 00 A4 8F 09 F8 60 00 21 28 00 02 24 00 A4 8F 21 28 00 02 20 00 83 8C 09 F8 60 00 21 88 40 00 1C 00 A4 8F 21 18 40 00 00 00 A2 8E 35 00 80 18 04 00 B5 26 21 A0 40 00 FF 00 02 3C FF 00 42 34 30 00 82 12 08 00 A4 8F 1C 00 B0 8F 21 F0 24 02 23 00 80 1A 21 B8 64 00 23 B0 14 02 64 00 C0 06 FF FF 93 26 21 90 A0 02 21 88 C0 03 21 80 E0 02 ?? ?? 03 3C 00 00 44 8E 00 00 25 96 ?? ?? 66 8C 0C 00 A3 8F FF FF 73 26 09 F8 60 00 04 00 52 26 FF FF 04 24 00 00 02 A6 02 00 31 26 F4 FF 64 16 02 00 10 26 80 18 14 00 40 10 14 00 21 A8 A3 02 21 F0 C2 03 21 B8 E2 02 00 00 A2 8E 11 00 C0 1A 04 00 B5 26 21 A0 40 00 FF 00 02 3C FF 00 42 34 0D 00 82 12 00 00 A4 8F DF FF 80 1E 21 80 C0 02 FE FF 03 24 18 00 83 02 21 B0 14 02 12 10 00 00 21 B8 E2 02 21 F0 C2 03 00 00 A2 8E F1 FF C0 1E 04 00 B5 26 00 00 A4 8F 18 00 A3 8F 01 00 84 24 2A 10 83 00 B5 FF 40 14 00 00 A4 AF 24 00 A4 8F 4C 00 BF 8F 48 00 BE 8F 1C 00 82 8C 44 00 B7 8F 40 00 B6 8F 08 00 59 8C 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 20 03 50 00 BD 27 0A FF 60 1C 40 48 09 00 ?? ?? ?? 0? 24 00 A4 8F 4C 00 BF 8F 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 50 00 BD 27 21 A8 A2 02 ?? ?? ?? 0? 23 A0 84 02 21 90 A0 02 FF FF 11 26 ?? ?? 02 3C 00 00 A4 8E 00 00 C5 97 ?? ?? 46 8C 0C 00 A3 8F FF FF 31 26 09 F8 60 00 04 00 B5 26 FF FF 04 24 00 00 E2 A6 02 00 DE 27 F4 FF 24 16 02 00 F7 26 80 10 10 00 21 A8 42 02 ?? ?? ?? 0? 23 A0 90 02 21 90 A0 02 FF FF 11 26 ?? ?? 02 3C 00 00 A4 8E 00 00 C5 97 ?? ?? 46 8C 0C 00 A3 8F FF FF 31 26 09 F8 60 00 04 00 B5 26 FF FF 04 24 00 00 E2 A6 02 00 DE 27 F4 FF 24 16 02 00 F7 26 00 00 A4 8F 18 00 A3 8F 80 10 10 00 01 00 84 24 21 A8 42 02 2A 10 83 00 69 FF 40 14 00 00 A4 AF ?? ?? ?? 0? 24 00 A4 8F }
	condition:
		$1
}

rule file_75_13_0 {
	meta:
		name = "_linear_draw_trans_rgba_rle_sprite16"
		size = 1492
		refs = "00a4 _blender_func16x 0164 .text 0200 _blender_alpha"
	strings:
		$1 = { 08 00 82 8C B0 FF BD 27 4C 00 BF AF 48 00 BE AF 44 00 B7 AF 40 00 B6 AF 3C 00 B5 AF 38 00 B4 AF 34 00 B3 AF 30 00 B2 AF 2C 00 B1 AF 28 00 B0 AF B8 00 40 10 24 00 A4 AF 0C 00 82 8C 10 00 8C 8C 00 00 AB 8C 23 10 46 00 10 00 A2 AF 10 00 A3 8F 21 50 00 00 23 10 86 01 2C 18 6A 00 2D 10 4B 00 23 10 43 00 10 00 A3 AF 1C 00 A2 AF 1E 01 40 18 21 48 66 00 14 00 82 8C 18 00 83 8C 04 00 A4 8C 23 40 47 00 23 18 67 00 2C 40 0A 01 2D 18 64 00 23 18 68 00 21 38 07 01 18 00 A3 AF 12 01 60 18 14 00 A7 AF ?? ?? 02 3C ?? ?? 42 8C 10 00 B5 24 10 00 00 11 0C 00 A2 AF FF 00 02 3C FF 00 42 34 21 28 00 00 00 00 A3 8E 07 00 62 10 04 00 B5 26 FC FF 60 18 80 20 03 00 21 A8 A4 02 00 00 A3 8E FB FF 62 14 04 00 B5 26 01 00 A5 24 F6 FF A8 54 00 00 A3 8E 10 00 A2 8F 94 00 40 10 21 10 CB 00 40 48 09 00 04 00 A9 AF 20 00 A0 AF 24 00 A2 8F 20 00 A4 8F 24 00 43 8C 14 00 A2 8F 21 80 82 00 24 00 A4 8F 09 F8 60 00 21 28 00 02 24 00 A4 8F 21 28 00 02 20 00 83 8C 09 F8 60 00 21 88 40 00 21 28 40 00 10 00 A2 8F 00 00 B4 8E 1C 00 40 10 04 00 B5 26 FF 00 03 3C FF 00 63 34 58 00 83 12 21 20 40 00 ?? ?? ?? 0? 80 18 14 00 EA 00 42 04 80 10 04 00 21 A8 A3 02 00 00 B4 8E 21 20 40 00 0F 00 40 10 04 00 B5 26 FF 00 02 3C FF 00 42 34 4C 00 82 12 20 00 A3 8F 80 18 14 00 F3 FF 80 1E 23 10 94 00 21 A0 84 02 05 00 80 06 21 10 80 02 21 20 40 00 00 00 B4 8E F3 FF 40 14 04 00 B5 26 1C 00 A3 8F 32 00 60 18 FF 00 04 3C FF 00 84 34 3B 00 84 12 04 00 A2 8F 21 80 60 00 21 F0 22 02 22 00 80 1A 21 B8 A2 00 23 B0 14 02 CD 00 C0 06 FF FF 93 26 21 90 A0 02 21 88 C0 03 21 80 E0 02 ?? ?? 02 3C 00 00 44 8E 00 00 25 96 ?? ?? 46 8C 0C 00 A3 8F FF FF 73 26 09 F8 60 00 04 00 52 26 FF FF 04 24 00 00 02 A6 02 00 31 26 F4 FF 64 16 02 00 10 26 80 18 14 00 40 10 14 00 21 A8 A3 02 00 00 B4 8E 21 F0 C2 03 21 B8 E2 02 10 00 C0 1A 04 00 B5 26 FF 00 03 3C FF 00 63 34 19 00 83 12 20 00 A3 8F E0 FF 80 1E 21 80 C0 02 FE FF 03 24 18 00 83 02 21 B0 90 02 00 00 B4 8E 04 00 B5 26 12 10 00 00 21 B8 E2 02 F2 FF C0 1E 21 F0 C2 03 FF 00 04 3C FF 00 84 34 0A 00 84 12 20 00 A3 8F 02 00 80 1A 80 10 14 00 21 A8 A2 02 00 00 B4 8E FF 00 02 3C FF 00 42 34 F9 FF 82 16 04 00 B5 26 20 00 A3 8F 18 00 A4 8F 01 00 63 24 2A 10 64 00 8E FF 40 14 20 00 A3 AF 24 00 A4 8F 4C 00 BF 8F 48 00 BE 8F 1C 00 82 8C 44 00 B7 8F 40 00 B6 8F 08 00 59 8C 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 20 03 50 00 BD 27 24 00 A4 8F ?? ?? 02 3C 00 00 AB 8C ?? ?? 42 8C 10 00 B5 24 04 00 A5 8C 10 00 8C 8C 0C 00 A2 AF 14 00 A7 AF 1C 00 AB AF 18 00 A5 AF 21 48 C0 00 10 00 A0 AF 21 10 CB 00 2A 10 4C 00 61 00 40 10 18 00 A3 8F 18 00 A4 8F DE FF 80 18 40 48 09 00 08 00 A9 AF 00 00 A0 AF 24 00 A2 8F 00 00 A4 8F 24 00 43 8C 14 00 A2 8F 21 80 82 00 24 00 A4 8F 09 F8 60 00 21 28 00 02 24 00 A4 8F 21 28 00 02 20 00 83 8C 09 F8 60 00 21 88 40 00 1C 00 A4 8F 21 18 40 00 00 00 A2 8E 35 00 80 18 04 00 B5 26 21 A0 40 00 FF 00 02 3C FF 00 42 34 30 00 82 12 08 00 A4 8F 1C 00 B0 8F 21 F0 24 02 23 00 80 1A 21 B8 64 00 23 B0 14 02 64 00 C0 06 FF FF 93 26 21 90 A0 02 21 88 C0 03 21 80 E0 02 ?? ?? 03 3C 00 00 44 8E 00 00 25 96 ?? ?? 66 8C 0C 00 A3 8F FF FF 73 26 09 F8 60 00 04 00 52 26 FF FF 04 24 00 00 02 A6 02 00 31 26 F4 FF 64 16 02 00 10 26 80 18 14 00 40 10 14 00 21 A8 A3 02 21 F0 C2 03 21 B8 E2 02 00 00 A2 8E 11 00 C0 1A 04 00 B5 26 21 A0 40 00 FF 00 02 3C FF 00 42 34 0D 00 82 12 00 00 A4 8F DF FF 80 1E 21 80 C0 02 FE FF 03 24 18 00 83 02 21 B0 14 02 12 10 00 00 21 B8 E2 02 21 F0 C2 03 00 00 A2 8E F1 FF C0 1E 04 00 B5 26 00 00 A4 8F 18 00 A3 8F 01 00 84 24 2A 10 83 00 B5 FF 40 14 00 00 A4 AF 24 00 A4 8F 4C 00 BF 8F 48 00 BE 8F 1C 00 82 8C 44 00 B7 8F 40 00 B6 8F 08 00 59 8C 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 20 03 50 00 BD 27 0A FF 60 1C 40 48 09 00 ?? ?? ?? 0? 24 00 A4 8F 4C 00 BF 8F 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 50 00 BD 27 21 A8 A2 02 ?? ?? ?? 0? 23 A0 84 02 21 90 A0 02 FF FF 11 26 ?? ?? 02 3C 00 00 A4 8E 00 00 C5 97 ?? ?? 46 8C 0C 00 A3 8F FF FF 31 26 09 F8 60 00 04 00 B5 26 FF FF 04 24 00 00 E2 A6 02 00 DE 27 F4 FF 24 16 02 00 F7 26 80 10 10 00 21 A8 42 02 ?? ?? ?? 0? 23 A0 90 02 21 90 A0 02 FF FF 11 26 ?? ?? 02 3C 00 00 A4 8E 00 00 C5 97 ?? ?? 46 8C 0C 00 A3 8F FF FF 31 26 09 F8 60 00 04 00 B5 26 FF FF 04 24 00 00 E2 A6 02 00 DE 27 F4 FF 24 16 02 00 F7 26 00 00 A4 8F 18 00 A3 8F 80 10 10 00 01 00 84 24 21 A8 42 02 2A 10 83 00 69 FF 40 14 00 00 A4 AF ?? ?? ?? 0? 24 00 A4 8F }
	condition:
		$1
}

rule file_55_14_0 {
	meta:
		name = "_linear_draw_lit_rle_sprite15"
		size = 1320
		refs = "00a8 _blender_func15 0150 .text 01e4 _blender_col_15"
	strings:
		$1 = { 08 00 82 8C B0 FF BD 27 48 00 BE AF 4C 00 BF AF 44 00 B7 AF 40 00 B6 AF 3C 00 B5 AF 38 00 B4 AF 34 00 B3 AF 30 00 B2 AF 2C 00 B1 AF 28 00 B0 AF 20 00 A4 AF AC 00 40 10 21 F0 00 01 0C 00 82 8C 10 00 8B 8C 00 00 AC 8C 23 10 46 00 0C 00 A2 AF 0C 00 A3 8F 21 50 00 00 23 10 66 01 2C 18 6A 00 2D 10 4C 00 23 10 43 00 0C 00 A3 AF 18 00 A2 AF F6 00 40 18 21 48 66 00 14 00 82 8C 18 00 83 8C 04 00 A4 8C 23 40 47 00 23 18 67 00 2C 40 0A 01 2D 18 64 00 23 18 68 00 21 38 07 01 14 00 A3 AF EA 00 60 18 10 00 A7 AF ?? ?? 02 3C ?? ?? 57 8C 11 00 00 11 10 00 B4 24 21 28 00 00 1F 7C 04 24 00 00 83 86 FF FF 62 30 08 00 44 10 02 00 94 26 FB FF 60 18 40 10 03 00 21 A0 82 02 00 00 83 86 FF FF 62 30 FA FF 44 14 02 00 94 26 01 00 A5 24 F4 FF A8 54 00 00 83 86 0C 00 A2 8F 87 00 40 10 21 10 CC 00 40 48 09 00 00 00 A9 AF 04 00 A0 AF 20 00 A6 8F 04 00 A2 8F 20 00 C3 8C 21 20 C0 00 10 00 A6 8F 09 F8 60 00 21 28 46 00 21 28 40 00 0C 00 A2 8F 00 00 93 86 1C 00 40 10 02 00 94 26 FF FF 62 32 1F 7C 03 24 51 00 43 10 0C 00 A4 8F ?? ?? ?? 0? 40 18 13 00 C8 00 42 04 40 10 04 00 21 A0 83 02 00 00 93 86 21 20 40 00 0F 00 40 10 02 00 94 26 FF FF 62 32 1F 7C 06 24 45 00 46 10 04 00 A6 8F 40 18 13 00 F3 FF 60 1E 23 10 93 00 21 98 64 02 05 00 60 06 21 10 60 02 21 20 40 00 00 00 93 86 F3 FF 40 14 02 00 94 26 18 00 A2 8F 2B 00 40 18 FF FF 62 32 1F 7C 03 24 34 00 43 10 00 00 A4 8F 18 00 B0 8F 1D 00 60 1A 21 B0 A4 00 23 A8 13 02 AC 00 A0 06 FF FF 72 26 21 88 80 02 21 80 C0 02 ?? ?? 02 3C 00 00 25 86 ?? ?? 44 8C 21 30 C0 03 09 F8 E0 02 FF FF 52 26 FF FF 03 24 00 00 02 A6 02 00 31 26 F6 FF 43 16 02 00 10 26 40 10 13 00 21 A0 82 02 00 00 93 86 21 B0 C2 02 0F 00 A0 1A 02 00 94 26 FF FF 62 32 1F 7C 