private rule architecture {
	meta:
		bits = 32
		endianness = "little"
		architecture = "ARM"
	condition:
		true
}

rule file_1_1_0 {
	meta:
		name = "__gthr_win32_recursive_mutex_unlock"
		size = 80
		refs = "0028 InterlockedDecrement 0040 ReleaseSemaphore"
	strings:
		$1 = { 30 40 2D E9 04 40 90 E5 00 50 A0 E1 01 40 44 E2 00 00 54 E3 04 40 80 E5 01 00 00 0A 00 00 A0 E3 30 80 BD E8 08 40 80 E5 ?? ?? ?? ?? 00 00 50 E3 F9 FF FF BA 0C 00 95 E5 04 20 A0 E1 01 10 A0 E3 ?? ?? ?? ?? 01 00 70 E2 00 00 A0 33 30 80 BD E8 }
	condition:
		$1
}

rule file_1_2_0 {
	meta:
		name = "__gthr_win32_mutex_unlock"
		size = 52
		refs = "0008 InterlockedDecrement 0024 ReleaseSemaphore"
	strings:
		$1 = { 10 40 2D E9 00 40 A0 E1 ?? ?? ?? ?? 00 00 50 E3 00 00 A0 B3 10 80 BD B8 04 00 94 E5 01 10 A0 E3 00 20 A0 E3 ?? ?? ?? ?? 01 00 70 E2 00 00 A0 33 10 80 BD E8 }
	condition:
		$1
}

rule file_1_3_0 {
	meta:
		name = "__gthr_win32_recursive_mutex_trylock"
		size = 88
		refs = "001c InterlockedCompareExchange"
	strings:
		$1 = { 30 40 2D E9 00 40 A0 E1 D8 FF FF EB 00 10 A0 E3 00 50 A0 E1 00 20 E0 E3 04 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 07 00 00 BA 08 30 94 E5 03 00 55 E1 04 30 94 05 01 00 A0 13 01 30 83 02 00 00 A0 03 04 30 84 05 30 80 BD E8 01 30 A0 E3 28 00 84 E9 00 00 A0 E3 30 80 BD E8 }
	condition:
		$1
}

rule file_1_4_0 {
	meta:
		name = "__gthr_win32_mutex_trylock"
		size = 28
		refs = "000c InterlockedCompareExchange"
	strings:
		$1 = { 04 E0 2D E5 00 10 A0 E3 00 20 E0 E3 ?? ?? ?? ?? 00 00 E0 E1 A0 0F A0 E1 04 F0 9D E4 }
	condition:
		$1
}

rule file_138_0_2 {
	meta:
		name = "wcstof"
		size = 16
		refs = "0004 wcstod 0008 __truncdfsf2"
	strings:
		$1 = { 04 E0 2D E5 ?? ?? ?? ?? ?? ?? ?? ?? 04 F0 9D E4 }
	condition:
		$1
}

rule file_1_5_0 {
	meta:
		name = "__gthr_win32_recursive_mutex_lock"
		size = 120
		refs = "0014 InterlockedIncrement 0034 WaitForSingleObject 0050 InterlockedDecrement"
	strings:
		$1 = { 30 40 2D E9 00 40 A0 E1 BB FF FF EB 00 50 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 07 00 00 0A 08 30 94 E5 03 00 55 E1 0B 00 00 0A 0C 00 94 E5 00 10 E0 E3 ?? ?? ?? ?? 00 00 50 E3 02 00 00 1A 01 30 A0 E3 28 00 84 E9 30 80 BD E8 04 00 A0 E1 ?? ?? ?? ?? 01 00 A0 E3 30 80 BD E8 04 00 A0 E1 ?? ?? ?? ?? 04 30 94 E5 00 00 A0 E3 01 30 83 E2 04 30 84 E5 30 80 BD E8 }
	condition:
		$1
}

rule file_1_6_0 {
	meta:
		name = "__gthr_win32_mutex_lock"
		size = 64
		refs = "0008 InterlockedIncrement 0024 WaitForSingleObject 0034 InterlockedDecrement"
	strings:
		$1 = { 10 40 2D E9 00 40 A0 E1 ?? ?? ?? ?? 00 00 50 E3 01 00 00 1A 00 00 A0 E3 10 80 BD E8 04 00 94 E5 00 10 E0 E3 ?? ?? ?? ?? 00 00 50 E3 F8 FF FF 0A 04 00 A0 E1 ?? ?? ?? ?? 01 00 A0 E3 10 80 BD E8 }
	condition:
		$1
}

rule file_1_7_0 {
	meta:
		name = "__gthr_win32_recursive_mutex_init_function"
		size = 52
		refs = "0028 CreateSemaphoreW"
	strings:
		$1 = { 00 30 A0 E3 10 40 2D E9 00 20 E0 E3 00 40 A0 E1 00 20 84 E5 03 00 A0 E1 04 30 84 E5 08 30 84 E5 03 10 A0 E1 01 28 82 E2 ?? ?? ?? ?? 0C 00 84 E5 10 80 BD E8 }
	condition:
		$1
}

rule file_1_8_0 {
	meta:
		name = "__gthr_win32_mutex_init_function"
		size = 48
		refs = "0020 CreateSemaphoreW"
	strings:
		$1 = { 10 40 2D E9 00 30 E0 E3 00 40 A0 E1 00 00 A0 E3 00 30 84 E5 00 10 A0 E1 0C 20 9F E5 00 30 A0 E1 ?? ?? ?? ?? 04 00 84 E5 10 80 BD E8 FF FF 00 00 }
	condition:
		$1
}

rule file_1_10_0 {
	meta:
		name = "__gthr_win32_setspecific"
		size = 32
		refs = "0004 TlsSetValue 001c GetLastError"
	strings:
		$1 = { 04 E0 2D E5 ?? ?? ?? ?? 00 00 50 E3 01 00 00 0A 00 00 A0 E3 04 F0 9D E4 04 E0 9D E4 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_13_0 {
	meta:
		name = "__gthr_win32_key_delete"
		size = 32
		refs = "001c GetLastError"
	strings:
		$1 = { 04 E0 2D E5 FA FF FF EB 00 00 50 E3 01 00 00 0A 00 00 A0 E3 04 F0 9D E4 04 E0 9D E4 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_11_0 {
	meta:
		name = "__gthr_win32_getspecific"
		size = 44
		refs = "0008 GetLastError 0014 TlsGetValue 0020 SetLastError"
	strings:
		$1 = { 30 40 2D E9 00 40 A0 E1 ?? ?? ?? ?? 00 50 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 30 80 BD E8 }
	condition:
		$1
}

rule file_1_15_0 {
	meta:
		name = "__gthr_win32_key_create"
		size = 48
		refs = "0024 __mingwthr_key_dtor 002c GetLastError"
	strings:
		$1 = { 30 40 2D E9 00 40 A0 E1 01 50 A0 E1 F8 FF FF EB 01 00 70 E3 03 00 00 0A 05 10 A0 E1 00 00 84 E5 30 40 BD E8 ?? ?? ?? ?? 30 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_16_0 {
	meta:
		name = "__gthr_win32_once"
		size = 116
		refs = "0034 InterlockedIncrement 005c Sleep"
	strings:
		$1 = { 00 00 50 E3 00 00 51 13 70 40 2D E9 00 40 A0 E1 01 50 A0 E1 00 00 E0 03 70 80 BD 08 00 30 94 E5 00 00 53 E3 01 00 00 0A 00 00 A0 E3 70 80 BD E8 04 00 84 E2 ?? ?? ?? ?? 00 60 50 E2 07 00 00 1A 0F E0 A0 E1 05 F0 A0 E1 01 30 A0 E3 00 30 84 E5 06 00 A0 E1 70 80 BD E8 00 00 A0 E3 ?? ?? ?? ?? 00 30 94 E5 00 00 53 E3 FA FF FF 0A 00 00 A0 E3 70 80 BD E8 }
	condition:
		$1
}

rule file_2_0_0 {
	meta:
		name = "__lshrdi3"
		size = 28
	strings:
		$1 = { 20 30 52 E2 20 C0 62 E2 30 02 A0 41 31 03 A0 51 11 0C 80 41 31 12 A0 E1 0E F0 A0 E1 }
	condition:
		$1
}

rule file_3_0_0 {
	meta:
		name = "__moddi3"
		size = 1284
		refs = "0050 __clzsi2 0078 __umodsi3 0088 __udivsi3"
	strings:
		$1 = { F0 4F 2D E9 00 00 51 E3 00 B0 A0 E1 01 C0 A0 E1 1C D0 4D E2 02 00 A0 E1 03 10 A0 E1 00 80 A0 A3 97 00 00 BA 00 00 51 E3 92 00 00 BA 00 A0 51 E2 14 70 8D E2 00 40 A0 E1 0B 50 A0 E1 0C 90 A0 E1 0C 60 A0 E1 39 00 00 1A 0C 00 50 E1 52 00 00 9A ?? ?? ?? ?? 00 A0 50 E2 20 30 6A 12 3B 33 A0 11 14 4A A0 11 19 6A 83 11 24 98 A0 E1 06 00 A0 E1 09 10 A0 E1 1B 5A A0 11 ?? ?? ?? ?? 09 10 A0 E1 00 B0 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 04 68 A0 E1 26 68 A0 E1 96 00 00 E0 25 38 A0 E1 0B B8 83 E1 0B 00 50 E1 03 00 00 9A 04 B0 9B E0 01 00 00 2A 0B 00 50 E1 04 B0 8B 80 0B B0 60 E0 09 10 A0 E1 0B 00 A0 E1 ?? ?? ?? ?? 09 10 A0 E1 00 30 A0 E1 0B 00 A0 E1 00 30 8D E5 ?? ?? ?? ?? 96 00 02 E0 05 58 A0 E1 00 30 9D E5 25 58 A0 E1 03 38 85 E1 03 00 52 E1 03 00 00 9A 04 30 93 E0 01 00 00 2A 03 00 52 E1 04 30 83 80 03 20 62 E0 32 AA A0 E1 00 30 A0 E3 00 00 58 E3 04 30 87 E5 00 A0 87 E5 07 00 00 1A 14 40 8D E2 18 00 94 E8 08 00 00 EA 0C 00 5A E1 0A 00 00 9A 00 18 87 E8 00 00 58 E3 F7 FF FF 0A 14 40 8D E2 18 00 94 E8 00 30 73 E2 00 40 E4 E2 04 10 A0 E1 03 00 A0 E1 1C D0 8D E2 F0 8F BD E8 01 00 A0 E1 00 B0 8D E5 ?? ?? ?? ?? 00 B0 50 E2 00 30 9D E5 79 00 00 1A 09 00 5A E1 05 00 54 21 02 00 00 8A 04 30 55 E0 0A 60 C9 E0 03 50 A0 E1 60 00 87 E8 E7 FF FF EA 00 00 50 E3 03 00 00 1A 00 10 A0 E1 01 00 A0 E3 ?? ?? ?? ?? 00 40 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 00 A0 A0 E1 32 00 00 1A 04 B8 A0 E1 06 60 64 E0 2B B8 A0 E1 24 98 A0 E1 06 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 09 10 A0 E1 00 30 A0 E1 06 00 A0 E1 00 30 8D E5 ?? ?? ?? ?? 9B 00 00 E0 00 30 9D E5 25 68 A0 E1 03 38 86 E1 03 00 50 E1 03 00 00 9A 04 30 93 E0 01 00 00 2A 03 00 50 E1 04 30 83 80 03 60 60 E0 09 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 09 10 A0 E1 00 20 A0 E1 06 00 A0 E1 04 20 8D E5 ?? ?? ?? ?? 90 0B 0B E0 05 58 A0 E1 04 20 9D E5 25 58 A0 E1 02 28 85 E1 02 00 5B E1 03 00 00 9A 04 20 92 E0 01 00 00 2A 02 00 5B E1 04 20 82 80 02 20 6B E0 A4 FF FF EA 00 00 70 E2 00 10 E1 E2 69 FF FF EA 00 B0 7B E2 00 C0 EC E2 00 80 E0 E3 63 FF FF EA 20 20 60 E2 36 B2 A0 E1 35 22 A0 E1 14 40 A0 E1 16 2A 82 E1 24 98 A0 E1 0B 00 A0 E1 09 10 A0 E1 0C 20 8D E5 00 A0 8D E5 ?? ?? ?? ?? 09 10 A0 E1 00 60 A0 E1 0B 00 A0 E1 ?? ?? ?? ?? 04 B8 A0 E1 2B B8 A0 E1 9B 00 00 E0 0C 10 9D E5 00 30 9D E5 21 28 A0 E1 06 68 82 E1 06 00 50 E1 01 00 00 9A 04 60 96 E0 7E 00 00 3A 06 60 60 E0 06 00 A0 E1 09 10 A0 E1 00 30 8D E5 ?? ?? ?? ?? 09 10 A0 E1 00 20 A0 E1 06 00 A0 E1 04 20 8D E5 ?? ?? ?? ?? 0C E0 9D E5 9B 00 06 E0 0E 18 A0 E1 04 20 9D E5 21 18 A0 E1 02 28 81 E1 02 00 56 E1 00 30 9D E5 03 00 00 9A 04 20 92 E0 01 00 00 2A 02 00 56 E1 04 20 82 80 15 53 A0 E1 02 60 66 E0 9C FF FF EA 20 20 6B E2 34 02 A0 E1 33 12 A0 E1 1A AB 80 E1 39 52 A0 E1 19 1B 81 E1 2A 68 A0 E1 10 10 8D E5 05 00 A0 E1 06 10 A0 E1 04 20 8D E5 00 30 8D E5 ?? ?? ?? ?? 06 10 A0 E1 00 C0 A0 E1 05 00 A0 E1 08 C0 8D E5 ?? ?? ?? ?? 00 30 9D E5 0A 58 A0 E1 13 3B A0 E1 25 58 A0 E1 95 00 01 E0 10 E0 9D E5 08 C0 9D E5 00 90 A0 E1 2E 08 A0 E1 0C 08 80 E1 00 00 51 E1 14 CB A0 E1 0C 30 8D E5 04 20 9D E5 02 00 00 9A 0A 00 90 E0 01 90 49 E2 3C 00 00 3A 00 40 61 E0 04 00 A0 E1 06 10 A0 E1 04 10 8D E9 ?? ?? ?? ?? 06 10 A0 E1 00 30 A0 E1 04 00 A0 E1 00 30 8D E5 ?? ?? ?? ?? 10 40 9D E5 90 05 05 E0 04 18 A0 E1 00 30 9D E5 21 18 A0 E1 03 38 81 E1 03 00 55 E1 04 10 9D E9 02 00 00 9A 0A 30 93 E0 01 00 40 E2 22 00 00 3A 03 30 65 E0 09 08 80 E1 20 48 A0 E1 2C 18 A0 E1 04 58 C0 E1 01 98 CC E1 95 09 00 E0 94 09 09 E0 91 05 05 E0 94 01 01 E0 05 50 99 E0 01 18 81 22 05 08 90 E0 25 18 A1 E0 01 00 53 E1 07 00 00 3A 0C E0 9D E5 00 40 A0 13 01 40 A0 03 00 00 5E E1 00 40 A0 23 01 40 04 32 00 00 54 E3 02 00 00 0A 0C 40 50 E0 0A 10 C1 E0 04 00 A0 E1 0C 40 9D E5 00 E0 54 E0 01 C0 C3 E0 1C 22 A0 E1 3C CB A0 E1 3E BB 82 E1 00 18 87 E8 18 FF FF EA 03 00 55 E1 01 00 40 82 0A 30 83 80 D8 FF FF EA 00 00 51 E1 01 90 49 82 0A 00 80 80 BE FF FF EA 06 00 50 E1 04 60 86 80 7D FF FF EA }
	condition:
		$1
}

rule file_7_0_0 {
	meta:
		name = "__divsi3"
		size = 296
		refs = "011c __div0"
	strings:
		$1 = { 00 00 51 E3 01 C0 20 E0 42 00 00 0A 00 10 61 42 01 20 51 E2 27 00 00 0A 00 30 B0 E1 00 30 60 42 01 00 53 E1 26 00 00 9A 02 00 11 E1 28 00 00 0A 0E 02 11 E3 81 11 A0 01 08 20 A0 03 01 20 A0 13 01 02 51 E3 03 00 51 31 01 12 A0 31 02 22 A0 31 FA FF FF 3A 02 01 51 E3 03 00 51 31 81 10 A0 31 82 20 A0 31 FA FF FF 3A 00 00 A0 E3 01 00 53 E1 01 30 43 20 02 00 80 21 A1 00 53 E1 A1 30 43 20 A2 00 80 21 21 01 53 E1 21 31 43 20 22 01 80 21 A1 01 53 E1 A1 31 43 20 A2 01 80 21 00 00 53 E3 22 22 B0 11 21 12 A0 11 EF FF FF 1A 00 00 5C E3 00 00 60 42 0E F0 A0 E1 00 00 3C E1 00 00 60 42 0E F0 A0 E1 00 00 A0 33 CC 0F A0 01 01 00 80 03 0E F0 A0 E1 01 08 51 E3 21 18 A0 21 10 20 A0 23 00 20 A0 33 01 0C 51 E3 21 14 A0 21 08 20 82 22 10 00 51 E3 21 12 A0 21 04 20 82 22 04 00 51 E3 03 20 82 82 A1 20 82 90 00 00 5C E3 33 02 A0 E1 00 00 60 42 0E F0 A0 E1 08 E0 2D E5 ?? ?? ?? ?? 00 00 A0 E3 08 F0 9D E4 }
	condition:
		$1
}

rule file_7_1_0 {
	meta:
		name = "__aeabi_idivmod"
		size = 24
		refs = "0004 __divsi3"
	strings:
		$1 = { 03 40 2D E9 B3 FF FF EB 06 40 BD E8 92 00 03 E0 03 10 41 E0 0E F0 A0 E1 }
	condition:
		$1
}

rule file_8_0_0 {
	meta:
		name = "__addvdi3"
		size = 108
		refs = "0068 abort"
	strings:
		$1 = { 00 48 2D E9 00 B0 92 E0 01 C0 A3 E0 00 00 53 E3 0D 00 00 BA 0C 00 51 E1 00 30 A0 E3 06 00 00 DA 01 30 A0 E3 FF 30 03 E2 00 00 53 E3 0D 00 00 1A 0C 10 A0 E1 0B 00 A0 E1 00 88 BD E8 F8 FF FF 1A 0B 00 50 E1 F6 FF FF 9A F4 FF FF EA 01 00 5C E1 00 30 A0 E3 F1 FF FF CA F1 FF FF 1A 00 00 5B E1 EF FF FF 9A ED FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_0_0 {
	meta:
		name = "__powisf2"
		size = 128
		refs = "0030 __mulsf3 0070 __divsf3"
	strings:
		$1 = { F0 40 2D E9 C1 4F 21 E0 C1 4F 44 E0 01 00 14 E3 01 70 A0 E1 00 50 A0 E1 FE 65 A0 03 00 60 A0 11 A4 40 B0 E1 05 00 A0 E1 05 10 A0 E1 0B 00 00 0A ?? ?? ?? ?? 01 00 14 E3 00 50 A0 E1 F7 FF FF 0A 06 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? A4 40 B0 E1 00 60 A0 E1 05 10 A0 E1 05 00 A0 E1 F3 FF FF 1A 00 00 57 E3 03 00 00 AA 06 10 A0 E1 FE 05 A0 E3 ?? ?? ?? ?? 00 60 A0 E1 06 00 A0 E1 F0 80 BD E8 }
	condition:
		$1
}

rule file_11_0_0 {
	meta:
		name = "__powidf2"
		size = 192
		refs = "0044 __muldf3 00a4 __divdf3"
	strings:
		$1 = { F0 45 2D E9 C2 4F 22 E0 C2 4F 44 E0 01 00 14 E3 A4 80 9F 05 02 A0 A0 E1 00 50 A0 E1 01 60 A0 E1 00 70 A0 03 00 70 A0 11 01 80 A0 11 A4 40 B0 E1 05 00 A0 E1 06 10 A0 E1 05 20 A0 E1 06 30 A0 E1 11 00 00 0A ?? ?? ?? ?? 01 00 14 E3 00 50 A0 E1 01 60 A0 E1 F4 FF FF 0A 07 00 A0 E1 08 10 A0 E1 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? A4 40 B0 E1 00 70 A0 E1 01 80 A0 E1 05 00 A0 E1 06 10 A0 E1 05 20 A0 E1 06 30 A0 E1 ED FF FF 1A 00 00 5A E3 06 00 00 AA 07 20 A0 E1 08 30 A0 E1 00 00 A0 E3 14 10 9F E5 ?? ?? ?? ?? 00 70 A0 E1 01 80 A0 E1 07 00 A0 E1 08 10 A0 E1 F0 85 BD E8 00 00 F0 3F }
	condition:
		$1
}

rule file_12_0_0 {
	meta:
		name = "__muldc3"
		size = 1824
		refs = "0030 __muldf3 00a8 __subdf3 00c0 __adddf3 00d8 __nedf2"
	strings:
		$1 = { F0 4F 2D E9 3C D0 4D E2 60 C0 9D E5 64 80 9D E5 0C B0 A0 E1 02 90 A0 E1 03 40 A0 E1 0B 20 A0 E1 08 30 A0 E1 10 C0 8D E5 01 60 A0 E1 0C 00 8D E5 ?? ?? ?? ?? 68 A0 9D E5 6C 50 9D E5 34 00 8D E5 38 10 8D E5 0A 20 A0 E1 05 30 A0 E1 09 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 0A 20 A0 E1 2C 00 8D E5 30 10 8D E5 05 30 A0 E1 0C 00 9D E5 06 10 A0 E1 ?? ?? ?? ?? 10 20 9D E5 24 00 8D E5 28 10 8D E5 08 30 A0 E1 09 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 2C 30 8D E2 0C 00 93 E8 1C 00 8D E5 20 10 8D E5 34 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 1C 30 8D E2 0C 00 93 E8 03 00 8D E9 24 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 14 00 8D E5 18 10 8D E5 03 00 9D E9 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 04 00 00 1A 03 00 9D E9 14 30 8D E2 0C 00 93 E8 3C D0 8D E2 F0 8F BD E8 14 10 8D E2 03 00 91 E8 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 F3 FF FF 0A 0C 00 9D E5 06 30 A0 E1 00 20 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 01 30 A0 E1 00 20 A0 E1 ?? ?? ?? ?? 00 00 50 E3 0C 00 9D E5 06 10 A0 E1 00 20 A0 E1 06 30 A0 E1 00 70 A0 E3 01 70 A0 13 ?? ?? ?? ?? 00 00 50 E3 00 70 A0 13 01 70 07 02 00 00 57 E3 4D 01 00 1A 09 20 A0 E1 04 30 A0 E1 09 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 01 30 A0 E1 00 20 A0 E1 ?? ?? ?? ?? 09 20 A0 E1 00 00 50 E3 04 10 A0 E1 09 00 A0 E1 04 30 A0 E1 01 70 A0 13 ?? ?? ?? ?? 00 00 50 E3 00 00 A0 13 01 00 07 02 00 00 50 E3 00 70 A0 01 16 01 00 1A 10 00 9D E5 08 30 A0 E1 00 20 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 01 30 A0 E1 00 20 A0 E1 ?? ?? ?? ?? 00 00 50 E3 10 00 9D E5 08 10 A0 E1 00 20 A0 E1 08 30 A0 E1 00 B0 A0 E3 01 B0 A0 13 ?? ?? ?? ?? 00 00 50 E3 00 B0 A0 13 01 B0 0B 02 00 00 5B E3 E3 00 00 1A 0A 20 A0 E1 05 30 A0 E1 0A 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 01 30 A0 E1 00 20 A0 E1 ?? ?? ?? ?? 05 30 A0 E1 00 00 50 E3 0A 20 A0 E1 0A 00 A0 E1 05 10 A0 E1 01 B0 A0 13 ?? ?? ?? ?? 0B 30 A0 E1 00 00 50 E3 00 30 A0 13 01 30 03 02 00 00 53 E3 4D 00 00 0A 00 30 A0 E3 00 00 58 E3 A4 C4 9F E5 03 80 A0 E1 10 30 8D E5 02 81 83 B2 00 A0 A0 E3 0C 00 9D E5 06 10 A0 E1 00 20 A0 E1 06 30 A0 E1 02 51 05 E2 05 50 8C E1 ?? ?? ?? ?? 00 00 50 E3 04 00 00 0A 00 30 A0 E3 00 00 56 E3 0C 30 8D E5 03 60 A0 E1 02 61 83 B2 09 00 A0 E1 09 20 A0 E1 04 10 A0 E1 04 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 03 00 00 0A 00 00 54 E3 00 90 A0 E3 09 40 A0 E1 02 41 89 B2 10 20 9D E5 06 10 A0 E1 08 30 A0 E1 0C 00 9D E5 ?? ?? ?? ?? 05 30 A0 E1 01 C0 A0 E1 00 B0 A0 E1 0A 20 A0 E1 09 00 A0 E1 04 10 A0 E1 00 C0 8D E5 ?? ?? ?? ?? 00 C0 9D E5 00 20 A0 E1 01 30 A0 E1 0B 00 A0 E1 0C 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E3 E0 33 9F E5 ?? ?? ?? ?? 05 30 A0 E1 03 00 8D E9 0A 20 A0 E1 06 10 A0 E1 0C 00 9D E5 ?? ?? ?? ?? 10 20 9D E5 00 50 A0 E1 01 60 A0 E1 08 30 A0 E1 09 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E3 8C 33 9F E5 ?? ?? ?? ?? 14 00 8D E5 18 10 8D E5 51 FF FF EA 00 00 57 E3 CF FF FF 1A 34 30 8D E2 0C 00 93 E8 02 00 A0 E1 03 10 A0 E1 ?? ?? ?? ?? 01 30 A0 E1 00 20 A0 E1 ?? ?? ?? ?? 00 00 50 E3 34 10 8D E2 03 00 91 E8 00 20 A0 E1 01 30 A0 E1 01 70 A0 13 ?? ?? ?? ?? 00 00 50 E3 00 70 A0 13 01 70 07 02 00 00 57 E3 3B 00 00 1A 2C 30 8D E2 0C 00 93 E8 02 00 A0 E1 03 10 A0 E1 ?? ?? ?? ?? 01 30 A0 E1 00 20 A0 E1 ?? ?? ?? ?? 00 00 50 E3 2C 10 8D E2 03 00 91 E8 00 20 A0 E1 01 30 A0 E1 01 70 A0 13 ?? ?? ?? ?? 00 00 50 E3 00 70 A0 13 01 70 07 02 00 00 57 E3 27 00 00 1A 24 30 8D E2 0C 00 93 E8 02 00 A0 E1 03 10 A0 E1 ?? ?? ?? ?? 01 30 A0 E1 00 20 A0 E1 ?? ?? ?? ?? 00 00 50 E3 24 10 8D E2 03 00 91 E8 00 20 A0 E1 01 30 A0 E1 01 70 A0 13 ?? ?? ?? ?? 00 00 50 E3 00 70 A0 13 01 70 07 02 00 00 57 E3 13 00 00 1A 1C 30 8D E2 0C 00 93 E8 02 00 A0 E1 03 10 A0 E1 ?? ?? ?? ?? 01 30 A0 E1 00 20 A0 E1 ?? ?? ?? ?? 00 00 50 E3 1C 10 8D E2 03 00 91 E8 00 20 A0 E1 01 30 A0 E1 01 70 A0 13 ?? ?? ?? ?? 00 00 50 E3 00 00 A0 13 01 00 07 02 00 00 50 E3 FF FE FF 0A 0C 00 9D E5 06 10 A0 E1 00 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 04 00 00 0A 00 30 A0 E3 00 00 56 E3 0C 30 8D E5 03 60 A0 E1 02 61 83 B2 09 00 A0 E1 09 20 A0 E1 04 10 A0 E1 04 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 03 00 00 0A 00 00 54 E3 00 90 A0 E3 09 40 A0 E1 02 41 89 B2 10 00 9D E5 08 10 A0 E1 00 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 04 00 00 0A 00 30 A0 E3 00 00 58 E3 10 30 8D E5 03 80 A0 E1 02 81 83 B2 0A 00 A0 E1 0A 20 A0 E1 05 10 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 55 FF FF 0A 00 00 55 E3 00 A0 A0 E3 0A 50 A0 E1 02 51 8A B2 50 FF FF EA 00 00 58 E3 6C 81 9F E5 00 C0 A0 E3 0A 20 A0 E1 0A 00 A0 E1 05 30 A0 E1 05 10 A0 E1 10 C0 8D E5 02 81 88 B2 ?? ?? ?? ?? 01 30 A0 E1 00 20 A0 E1 ?? ?? ?? ?? 0A 20 A0 E1 00 00 50 E3 05 10 A0 E1 0A 00 A0 E1 05 30 A0 E1 00 70 A0 E3 01 70 A0 13 ?? ?? ?? ?? 00 00 50 E3 00 00 A0 13 01 00 07 02 00 00 50 E3 00 A0 A0 01 0A C0 A0 01 04 C1 9F 15 00 A0 A0 13 19 FF FF EA 00 30 A0 E3 00 00 56 E3 F0 C0 9F E5 03 60 A0 E1 0C 30 8D E5 02 61 83 B2 00 90 A0 E3 10 00 9D E5 08 10 A0 E1 00 20 A0 E1 08 30 A0 E1 02 41 04 E2 04 40 8C E1 ?? ?? ?? ?? 00 00 50 E3 04 00 00 0A 00 30 A0 E3 00 00 58 E3 10 30 8D E5 03 80 A0 E1 02 81 83 B2 0A 00 A0 E1 0A 20 A0 E1 05 10 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 03 00 00 0A 00 00 55 E3 00 A0 A0 E3 0A 50 A0 E1 02 51 8A B2 01 70 A0 E3 C6 FE FF EA 00 00 56 E3 6C 60 9F E5 00 C0 A0 E3 09 20 A0 E1 09 00 A0 E1 04 30 A0 E1 04 10 A0 E1 0C C0 8D E5 02 61 86 B2 ?? ?? ?? ?? 01 30 A0 E1 00 20 A0 E1 ?? ?? ?? ?? 09 20 A0 E1 00 00 50 E3 04 10 A0 E1 09 00 A0 E1 04 30 A0 E1 00 70 A0 E3 01 70 A0 13 ?? ?? ?? ?? 00 00 50 E3 00 00 A0 13 01 00 07 02 00 00 50 E3 00 90 A0 01 09 C0 A0 01 04 C0 9F 15 00 90 A0 13 C6 FF FF EA 00 00 F0 3F 00 00 F0 7F }
	condition:
		$1
}

rule file_13_0_0 {
	meta:
		name = "__fixdfdi"
		size = 80
		refs = "0014 __ltdf2 002c __fixunsdfdi"
	strings:
		$1 = { 30 40 2D E9 00 20 A0 E3 00 30 A0 E3 00 50 A0 E1 01 40 A0 E1 ?? ?? ?? ?? 00 00 50 E3 03 00 00 BA 05 00 A0 E1 04 10 A0 E1 30 40 BD E8 ?? ?? ?? ?? 05 00 A0 E1 02 11 84 E2 ?? ?? ?? ?? 00 30 70 E2 00 40 E1 E2 04 10 A0 E1 03 00 A0 E1 30 80 BD E8 }
	condition:
		$1
}

rule file_16_0_0 {
	meta:
		name = "__addvsi3"
		size = 64
		refs = "003c abort"
	strings:
		$1 = { 00 00 51 E3 04 E0 2D E5 00 10 81 E0 06 00 00 BA 00 00 51 E1 00 00 A0 A3 01 00 A0 B3 00 00 50 E3 05 00 00 1A 01 00 A0 E1 04 F0 9D E4 00 00 51 E1 00 00 A0 D3 01 00 A0 C3 F7 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_0_0 {
	meta:
		name = "__make_fp"
		size = 32
		refs = "0014 __pack_f"
	strings:
		$1 = { 04 E0 2D E5 10 D0 4D E2 00 00 8D E5 0D 00 A0 E1 0E 00 8D E9 ?? ?? ?? ?? 10 D0 8D E2 00 80 BD E8 }
	condition:
		$1
}

rule file_22_2_0 {
	meta:
		name = "__adddf3"
		size = 736
	strings:
		$1 = { 30 40 2D E9 81 40 A0 E1 83 50 A0 E1 05 00 34 E1 02 00 30 01 00 C0 94 11 02 C0 95 11 C4 CA F0 11 C5 CA F0 11 86 00 00 0A A4 4A A0 E1 A5 5A 74 E0 00 50 65 B2 06 00 00 DA 05 40 84 E0 02 20 20 E0 03 30 21 E0 00 00 22 E0 01 10 23 E0 02 20 20 E0 03 30 21 E0 36 00 55 E3 30 80 BD 88 02 01 11 E3 01 16 A0 E1 01 C6 A0 E3 21 16 8C E1 01 00 00 0A 00 00 70 E2 00 10 E1 E2 02 01 13 E3 03 36 A0 E1 23 36 8C E1 01 00 00 0A 00 20 72 E2 00 30 E3 E2 05 00 34 E1 64 00 00 0A 01 40 44 E2 20 E0 75 E2 05 00 00 BA 12 CE A0 E1 32 05 90 E0 00 10 A1 E2 13 0E 90 E0 53 15 B1 E0 06 00 00 EA 20 50 45 E2 20 E0 8E E2 01 00 52 E3 13 CE A0 E1 02 C0 8C 23 53 05 90 E0 C3 1F B1 E0 02 51 01 E2 02 00 00 5A 00 C0 7C E2 00 00 F0 E2 00 10 E1 E2 01 06 51 E3 0E 00 00 3A 02 06 51 E3 06 00 00 3A A1 10 B0 E1 60 00 B0 E1 6C C0 A0 E1 01 40 84 E2 84 2A A0 E1 01 05 72 E3 62 00 00 2A 02 01 5C E3 A0 C0 B0 01 00 00 B0 E2 04 1A A1 E0 05 10 81 E1 30 80 BD E8 8C C0 B0 E1 00 00 B0 E0 01 10 A1 E0 01 06 11 E3 01 40 44 E2 F3 FF FF 1A 00 00 31 E3 14 30 A0 13 34 30 A0 03 00 10 A0 01 00 00 A0 03 01 20 A0 E1 01 08 52 E3 22 28 A0 21 10 30 43 22 01 0C 52 E3 22 24 A0 21 08 30 43 22 10 00 52 E3 22 22 A0 21 04 30 43 22 04 00 52 E3 02 30 43 22 A2 30 43 30 A2 31 43 E0 20 20 53 E2 07 00 00 AA 0C 20 92 E2 04 00 00 DA 14 C0 82 E2 0C 20 62 E2 11 0C A0 E1 31 12 A0 E1 04 00 00 EA 14 20 82 E2 20 C0 62 D2 11 12 A0 E1 30 1C 81 D1 10 02 A0 D1 03 40 54 E0 04 1A 81 A0 05 10 81 A1 30 80 BD A8 04 40 E0 E1 1F 40 54 E2 0D 00 00 AA 0C 40 94 E2 05 00 00 CA 14 40 84 E2 20 20 64 E2 30 04 A0 E1 11 02 80 E1 31 14 85 E1 30 80 BD E8 0C 40 64 E2 20 20 64 E2 30 02 A0 E1 11 04 80 E1 05 10 A0 E1 30 80 BD E8 31 04 A0 E1 05 10 A0 E1 30 80 BD E8 00 00 34 E3 01 36 23 E2 01 16 21 02 01 40 84 02 01 50 45 12 94 FF FF EA C4 CA F0 E1 C5 CA F0 11 18 00 00 0A 05 00 34 E1 02 00 30 01 03 00 00 0A 00 C0 94 E1 03 10 A0 01 02 00 A0 01 30 80 BD E8 03 00 31 E1 00 10 A0 13 00 00 A0 13 30 80 BD 18 A4 CA B0 E1 03 00 00 1A 80 00 B0 E1 01 10 B1 E0 02 11 81 23 30 80 BD E8 01 45 94 E2 01 16 81 32 30 80 BD 38 02 51 01 E2 7F 14 85 E3 0F 16 81 E3 00 00 A0 E3 30 80 BD E8 C4 CA F0 E1 03 10 A0 11 02 00 A0 11 C5 CA F0 01 01 30 A0 11 00 20 A0 11 01 46 90 E1 03 56 92 01 03 00 31 01 02 17 81 13 30 80 BD E8 }
	condition:
		$1
}

rule file_22_3_0 {
	meta:
		name = "__floatunsidf"
		size = 36
	strings:
		$1 = { 00 00 30 E3 00 10 A0 03 0E F0 A0 01 30 40 2D E9 01 4B A0 E3 32 40 84 E2 00 50 A0 E3 00 10 A0 E3 90 FF FF EA }
	condition:
		$1
}

rule file_22_4_0 {
	meta:
		name = "__floatsidf"
		size = 40
	strings:
		$1 = { 00 00 30 E3 00 10 A0 03 0E F0 A0 01 30 40 2D E9 01 4B A0 E3 32 40 84 E2 02 51 10 E2 00 00 60 42 00 10 A0 E3 86 FF FF EA }
	condition:
		$1
}

rule file_22_5_0 {
	meta:
		name = "__extendsfdf2"
		size = 64
	strings:
		$1 = { 80 20 B0 E1 C2 11 A0 E1 61 10 A0 E1 02 0E A0 E1 FF 34 12 12 FF 04 33 13 0E 13 21 12 0E F0 A0 11 00 00 32 E3 FF 04 33 13 0E F0 A0 01 30 40 2D E9 0E 4D A0 E3 02 51 01 E2 02 11 C1 E3 76 FF FF EA }
	condition:
		$1
}

rule file_22_6_0 {
	meta:
		name = "__floatundidf"
		size = 20
	strings:
		$1 = { 01 20 90 E1 0E F0 A0 01 30 40 2D E9 00 50 A0 E3 06 00 00 EA }
	condition:
		$1
}

rule file_22_7_0 {
	meta:
		name = "__floatdidf"
		size = 96
	strings:
		$1 = { 01 20 90 E1 0E F0 A0 01 30 40 2D E9 02 51 11 E2 01 00 00 5A 00 00 70 E2 00 10 E1 E2 01 4B A0 E3 32 40 84 E2 21 CB B0 E1 4F FF FF 0A 03 20 A0 E3 AC C1 B0 E1 03 20 82 12 AC C1 B0 E1 03 20 82 12 AC 21 82 E0 20 30 62 E2 10 C3 A0 E1 30 02 A0 E1 11 03 80 E1 31 12 A0 E1 02 40 84 E0 42 FF FF EA }
	condition:
		$1
}

rule file_24_0_0 {
	meta:
		name = "__clzsi2"
		size = 72
	strings:
		$1 = { 1C 10 A0 E3 01 08 50 E3 20 08 A0 21 10 10 41 22 01 0C 50 E3 20 04 A0 21 08 10 41 22 10 00 50 E3 20 02 A0 21 04 10 41 22 08 20 8F E2 00 00 D2 E7 01 00 80 E0 0E F0 A0 E1 04 03 02 02 01 01 01 01 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_26_0_0 {
	meta:
		name = "__popcountsi2"
		size = 60
		refs = "0038 __popcount_tab"
	strings:
		$1 = { 30 30 9F E5 20 18 A0 E1 20 24 A0 E1 FF 10 01 E2 FF 20 02 E2 01 C0 D3 E7 02 20 D3 E7 FF 10 00 E2 01 10 D3 E7 20 0C D3 E7 02 20 8C E0 02 30 81 E0 03 00 80 E0 0E F0 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_28_0_0 {
	meta:
		name = "__popcountdi2"
		size = 76
		refs = "0048 __popcount_tab"
	strings:
		$1 = { 30 00 2D E9 00 30 A0 E3 38 20 9F E5 03 C0 A0 E1 30 4C A0 E1 20 50 6C E2 11 45 84 E1 20 50 5C E2 31 45 A0 51 FF 40 04 E2 04 40 D2 E7 08 C0 8C E2 40 00 5C E3 04 30 83 E0 F4 FF FF 1A 03 00 A0 E1 30 00 BD E8 0E F0 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_31_0_0 {
	meta:
		name = "__umodsi3"
		size = 204
		refs = "00c0 __div0"
	strings:
		$1 = { 01 20 51 E2 2C 00 00 3A 01 00 50 11 00 00 A0 03 02 00 11 81 02 00 00 00 0E F0 A0 91 00 20 A0 E3 01 02 51 E3 00 00 51 31 01 12 A0 31 04 20 82 32 FA FF FF 3A 02 01 51 E3 00 00 51 31 81 10 A0 31 01 20 82 32 FA FF FF 3A 03 20 52 E2 0E 00 00 BA 01 00 50 E1 01 00 40 20 A1 00 50 E1 A1 00 40 20 21 01 50 E1 21 01 40 20 A1 01 50 E1 A1 01 40 20 01 00 50 E3 21 12 A0 E1 04 20 52 A2 F3 FF FF AA 03 00 12 E3 00 00 30 13 0A 00 00 0A 02 00 72 E3 06 00 00 BA 02 00 00 0A 01 00 50 E1 01 00 40 20 A1 10 A0 E1 01 00 50 E1 01 00 40 20 A1 10 A0 E1 01 00 50 E1 01 00 40 20 0E F0 A0 E1 08 E0 2D E5 ?? ?? ?? ?? 00 00 A0 E3 08 F0 9D E4 }
	condition:
		$1
}

rule file_32_0_0 {
	meta:
		name = "__modsi3"
		size = 228
		refs = "00d8 __div0"
	strings:
		$1 = { 00 00 51 E3 32 00 00 0A 00 10 61 42 00 C0 B0 E1 00 00 60 42 01 20 51 E2 01 00 50 11 00 00 A0 03 02 00 11 81 02 00 00 00 26 00 00 9A 00 20 A0 E3 01 02 51 E3 00 00 51 31 01 12 A0 31 04 20 82 32 FA FF FF 3A 02 01 51 E3 00 00 51 31 81 10 A0 31 01 20 82 32 FA FF FF 3A 03 20 52 E2 0E 00 00 BA 01 00 50 E1 01 00 40 20 A1 00 50 E1 A1 00 40 20 21 01 50 E1 21 01 40 20 A1 01 50 E1 A1 01 40 20 01 00 50 E3 21 12 A0 E1 04 20 52 A2 F3 FF FF AA 03 00 12 E3 00 00 30 13 0A 00 00 0A 02 00 72 E3 06 00 00 BA 02 00 00 0A 01 00 50 E1 01 00 40 20 A1 10 A0 E1 01 00 50 E1 01 00 40 20 A1 10 A0 E1 01 00 50 E1 01 00 40 20 00 00 5C E3 00 00 60 42 0E F0 A0 E1 08 E0 2D E5 ?? ?? ?? ?? 00 00 A0 E3 08 F0 9D E4 }
	condition:
		$1
}

rule file_33_0_0 {
	meta:
		name = "__negdi2"
		size = 36
	strings:
		$1 = { 00 10 61 E2 00 00 50 E3 01 10 41 12 00 30 60 E2 04 40 2D E5 03 00 A0 E1 01 40 A0 E1 10 00 BD E8 0E F0 A0 E1 }
	condition:
		$1
}

rule file_37_0_0 {
	meta:
		name = "__mulsf3"
		size = 408
	strings:
		$1 = { FF C0 A0 E3 A0 2B 1C E0 A1 3B 1C 10 0C 00 32 11 0C 00 33 11 3E 00 00 0A 03 20 82 E0 01 C0 20 E0 80 04 B0 E1 81 14 B0 11 10 00 00 0A 02 33 A0 E3 A0 02 83 E1 A1 12 83 E1 90 31 81 E0 02 01 0C E2 02 05 51 E3 81 10 A0 31 A3 1F 81 31 83 30 A0 31 01 00 80 E1 7F 20 C2 E2 FD 00 52 E3 0F 00 00 8A 02 01 53 E3 82 0B A0 E0 01 00 C0 03 0E F0 A0 E1 00 00 30 E3 02 C1 0C E2 81 14 A0 01 A0 04 8C E1 A1 04 80 E1 7F 20 52 E2 FF 30 72 C2 82 0B 80 C1 0E F0 A0 C1 02 05 80 E3 00 30 A0 E3 01 20 52 E2 35 00 00 CA 19 00 72 E3 02 01 00 D2 0E F0 A0 D1 00 20 62 E2 80 10 B0 E1 31 12 A0 E1 20 20 62 E2 10 C2 A0 E1 61 00 B0 E1 00 00 A0 E2 8C 30 93 E1 AC 0F C0 01 0E F0 A0 E1 00 00 32 E3 02 C1 00 E2 80 00 A0 01 02 05 10 03 01 20 42 02 FB FF FF 0A 0C 00 80 E1 00 00 33 E3 02 C1 01 E2 81 10 A0 01 02 05 11 03 01 30 43 02 FB FF FF 0A 0C 10 81 E1 C0 FF FF EA A1 3B 0C E0 0C 00 32 E1 0C 00 33 11 05 00 00 0A 02 C1 D0 E3 02 C1 D1 13 E9 FF FF 1A 01 00 20 E0 02 01 00 E2 0E F0 A0 E1 00 00 30 E3 02 01 30 13 01 00 A0 01 00 00 31 13 02 01 31 13 0D 00 00 0A 0C 00 32 E1 01 00 00 1A 80 24 B0 E1 09 00 00 1A 0C 00 33 E1 02 00 00 1A 81 34 B0 E1 01 00 A0 11 04 00 00 1A 01 00 20 E0 02 01 00 E2 7F 04 80 E3 02 05 80 E3 0E F0 A0 E1 7F 04 80 E3 03 05 80 E3 0E F0 A0 E1 }
	condition:
		$1
}

rule file_37_1_0 {
	meta:
		name = "__divsf3"
		size = 352
	strings:
		$1 = { FF C0 A0 E3 A0 2B 1C E0 A1 3B 1C 10 0C 00 32 11 0C 00 33 11 3A 00 00 0A 03 20 42 E0 01 C0 20 E0 81 14 B0 E1 80 04 A0 E1 1C 00 00 0A 01 32 A0 E3 21 12 83 E1 20 32 83 E1 02 01 0C E2 01 00 53 E1 83 30 A0 31 7D 20 A2 E2 02 C5 A0 E3 01 00 53 E1 01 30 43 20 0C 00 80 21 A1 00 53 E1 A1 30 43 20 AC 00 80 21 21 01 53 E1 21 31 43 20 2C 01 80 21 A1 01 53 E1 A1 31 43 20 AC 01 80 21 03 32 B0 E1 2C C2 B0 11 F0 FF FF 1A FD 00 52 E3 9D FF FF 8A 01 00 53 E1 82 0B A0 E0 01 00 C0 03 0E F0 A0 E1 02 C1 0C E2 A0 04 8C E1 7F 20 92 E2 FF 30 72 C2 82 0B 80 C1 0E F0 A0 C1 02 05 80 E3 00 30 A0 E3 01 20 52 E2 8F FF FF EA 00 00 32 E3 02 C1 00 E2 80 00 A0 01 02 05 10 03 01 20 42 02 FB FF FF 0A 0C 00 80 E1 00 00 33 E3 02 C1 01 E2 81 10 A0 01 02 05 11 03 01 30 43 02 FB FF FF 0A 0C 10 81 E1 C4 FF FF EA A1 3B 0C E0 0C 00 32 E1 05 00 00 1A 80 24 B0 E1 B6 FF FF 1A 0C 00 33 E1 AF FF FF 1A 01 00 A0 E1 B2 FF FF EA 0C 00 33 E1 03 00 00 1A 81 34 B0 E1 97 FF FF 0A 01 00 A0 E1 AC FF FF EA 02 C1 D0 E3 02 C1 D1 13 DE FF FF 1A 02 21 D0 E3 A2 FF FF 1A 02 31 D1 E3 8E FF FF 1A A4 FF FF EA }
	condition:
		$1
}

rule file_38_0_0 {
	meta:
		name = "__do_global_dtors"
		size = 64
		refs = "003c .data"
	strings:
		$1 = { 10 40 2D E9 30 40 9F E5 00 20 94 E5 00 30 92 E5 00 00 53 E3 10 80 BD 08 04 20 82 E2 00 20 84 E5 0F E0 A0 E1 03 F0 A0 E1 00 20 94 E5 00 30 92 E5 00 00 53 E3 F7 FF FF 1A 10 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_38_1_0 {
	meta:
		name = "__do_global_ctors"
		size = 104
		refs = "003c atexit 0060 __CTOR_LIST__ 0064 __do_global_dtors"
	strings:
		$1 = { 30 40 2D E9 54 50 9F E5 00 40 95 E5 01 00 74 E3 0A 00 00 0A 00 00 54 E3 05 00 00 0A 04 51 85 E0 04 30 15 E4 0F E0 A0 E1 03 F0 A0 E1 01 40 54 E2 FA FF FF 1A 28 00 9F E5 30 40 BD E8 ?? ?? ?? ?? 00 40 A0 E3 00 00 00 EA 03 40 A0 E1 01 30 84 E2 03 21 95 E7 00 00 52 E3 FA FF FF 1A EC FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_1_1 {
	meta:
		name = "__mingw_do_global_ctors"
		size = 104
		refs = "003c atexit 0060 __CTOR_LIST__ 0064 __mingw_do_global_dtors"
	strings:
		$1 = { 30 40 2D E9 54 50 9F E5 00 40 95 E5 01 00 74 E3 0A 00 00 0A 00 00 54 E3 05 00 00 0A 04 51 85 E0 04 30 15 E4 0F E0 A0 E1 03 F0 A0 E1 01 40 54 E2 FA FF FF 1A 28 00 9F E5 30 40 BD E8 ?? ?? ?? ?? 00 40 A0 E3 00 00 00 EA 03 40 A0 E1 01 30 84 E2 03 21 95 E7 00 00 52 E3 FA FF FF 1A EC FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_38_2_0 {
	meta:
		name = "__gccmain"
		size = 32
		refs = "0018 __do_global_ctors 001c .bss"
	strings:
		$1 = { 14 30 9F E5 00 20 93 E5 00 00 52 E3 0E F0 A0 11 01 20 A0 E3 00 20 83 E5 DE FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_2_1 {
	meta:
		name = "__gccmain"
		size = 32
		refs = "0018 __mingw_do_global_ctors 001c .bss"
	strings:
		$1 = { 14 30 9F E5 00 20 93 E5 00 00 52 E3 0E F0 A0 11 01 20 A0 E3 00 20 83 E5 DE FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_39_0_0 {
	meta:
		name = "__bswapdi2"
		size = 424
	strings:
		$1 = { F0 0F 2D E9 00 70 A0 E3 FF 8C A0 E3 FF 68 A0 E3 30 D0 4D E2 00 30 A0 E1 01 40 A0 E1 07 00 00 E0 01 60 06 E0 08 10 01 E0 10 00 8D E5 14 10 8D E5 00 50 A0 E3 26 14 A0 E1 FF 60 A0 E3 05 70 03 E0 06 80 04 E0 FF A4 A0 E3 18 70 8D E5 1C 80 8D E5 04 A0 0A E0 2A 8C A0 E1 00 90 A0 E3 00 A0 A0 E3 18 50 9D E5 00 06 8D E8 00 20 A0 E3 20 7C A0 E1 FF 94 A0 E3 14 00 9D E5 00 A0 A0 E3 08 80 8D E5 0C 20 8D E5 09 B0 03 E0 0A C0 04 E0 25 54 A0 E1 FF 98 A0 E3 00 A0 A0 E3 20 B0 8D E5 24 C0 8D E5 00 50 8D E5 09 B0 03 E0 0A C0 04 E0 00 74 87 E1 08 A0 8D E2 00 06 9A E8 20 8C A0 E1 09 50 81 E1 0A 60 82 E1 05 90 87 E1 06 A0 88 E1 08 90 8D E5 0C A0 8D E5 08 80 8D E2 80 01 98 E8 28 B0 8D E5 2C C0 8D E5 24 00 9D E5 00 B0 9D E5 1C C0 9D E5 1C A0 9D E5 20 50 9D E5 0C BC 8B E1 2C 60 9D E5 00 04 A0 E1 2A A4 A0 E1 00 B0 8D E5 04 A0 8D E5 25 5C 80 E1 05 C0 A0 E1 06 AC A0 E1 60 00 9D E8 05 70 87 E1 06 80 88 E1 20 60 9D E5 08 70 8D E5 0C 80 8D E5 28 70 9D E5 06 64 A0 E1 27 A4 8A E1 08 80 8D E2 80 01 98 E8 07 50 86 E1 08 60 8C E1 28 80 9D E5 03 04 A0 E1 08 9C A0 E1 09 B0 85 E1 0A C0 86 E1 FF 78 00 E2 03 0C A0 E1 10 50 8D E5 14 60 8D E5 0C 00 8D E5 0B 60 82 E1 0C 70 87 E1 08 20 8D E5 08 50 8D E2 30 00 95 E8 04 60 86 E1 05 70 87 E1 07 10 A0 E1 06 00 A0 E1 30 D0 8D E2 F0 0F BD E8 0E F0 A0 E1 }
	condition:
		$1
}

rule file_40_0_0 {
	meta:
		name = "__paritysi2"
		size = 36
	strings:
		$1 = { 20 08 20 E0 20 04 20 E0 10 30 9F E5 20 02 20 E0 0F 00 00 E2 53 00 A0 E1 01 00 00 E2 0E F0 A0 E1 96 69 00 00 }
	condition:
		$1
}

rule file_42_0_0 {
	meta:
		name = "__divsc3"
		size = 1280
		refs = "0028 __ltsf2 003c __divsf3 004c __mulsf3 0054 __addsf3 008c __subsf3 00a4 __nesf2 014c __eqsf2"
	strings:
		$1 = { F0 4F 2D E9 02 40 A0 E1 03 50 A0 E1 02 21 C2 E3 02 31 C3 E3 08 D0 4D E2 00 80 A0 E1 01 70 A0 E1 02 00 A0 E1 03 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 22 00 00 AA 05 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 A0 A0 E1 0A 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 0A 10 A0 E1 00 90 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 07 10 A0 E1 ?? ?? ?? ?? 09 10 A0 E1 ?? ?? ?? ?? 0A 10 A0 E1 00 60 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 08 10 A0 E1 ?? ?? ?? ?? 09 10 A0 E1 ?? ?? ?? ?? 00 A0 A0 E1 06 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 1F 00 00 1A 06 00 A0 E1 0A 10 A0 E1 08 D0 8D E2 F0 8F BD E8 04 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 A0 A0 E1 0A 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 0A 10 A0 E1 00 90 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 08 10 A0 E1 ?? ?? ?? ?? 09 10 A0 E1 ?? ?? ?? ?? 0A 10 A0 E1 00 60 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 09 10 A0 E1 ?? ?? ?? ?? 00 A0 A0 E1 DA FF FF EA 0A 00 A0 E1 0A 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 DA FF FF 0A 04 00 A0 E1 00 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 15 00 00 1A 05 00 A0 E1 00 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 10 00 00 1A 08 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 72 00 00 1A 00 00 54 E3 6C 43 9F E5 6C 43 9F B5 08 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 00 60 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 00 A0 A0 E1 BF FF FF EA 08 10 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 8D E5 ?? ?? ?? ?? 08 10 A0 E1 00 00 50 E3 08 00 A0 E1 00 90 A0 E3 01 90 A0 13 ?? ?? ?? ?? 00 00 50 E3 00 90 A0 13 01 90 09 02 00 00 59 E3 12 00 00 1A 07 10 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 07 10 A0 E1 00 B0 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 0B 10 A0 E1 01 30 70 E2 00 30 A0 33 0B 00 A0 E1 00 30 8D E5 ?? ?? ?? ?? 00 30 9D E5 00 00 50 E3 09 20 A0 E1 01 20 A0 13 02 00 13 E1 4B 00 00 0A 04 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 44 00 00 1A 05 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 3D 00 00 1A 00 00 59 E3 00 30 A0 03 FE 35 A0 13 02 31 C3 E3 07 10 A0 E1 07 00 A0 E1 02 81 08 E2 08 80 83 E1 ?? ?? ?? ?? 00 10 A0 E1 ?? ?? ?? ?? 07 10 A0 E1 00 00 50 E3 07 00 A0 E1 00 60 A0 E3 01 60 A0 13 ?? ?? ?? ?? 00 00 50 E3 00 00 A0 13 01 00 06 02 00 00 50 E3 00 30 A0 03 FE 35 A0 13 02 31 C3 E3 04 10 A0 E1 02 71 07 E2 08 00 A0 E1 07 70 83 E1 ?? ?? ?? ?? 05 10 A0 E1 00 60 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? E8 11 9F E5 ?? ?? ?? ?? 04 10 A0 E1 00 60 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 00 40 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? B4 11 9F E5 ?? ?? ?? ?? 00 A0 A0 E1 58 FF FF EA 07 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 87 FF FF 0A 08 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 04 00 8D E5 04 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 00 00 50 E3 04 00 A0 E1 00 90 A0 E3 01 90 A0 13 ?? ?? ?? ?? 00 00 50 E3 00 90 A0 13 01 90 09 02 00 00 59 E3 10 00 00 1A 05 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 00 00 50 E3 05 00 A0 E1 09 B0 A0 E1 01 B0 A0 13 ?? ?? ?? ?? 0B 30 A0 E1 00 00 50 E3 00 30 A0 13 01 30 03 02 00 00 53 E3 2E FF FF 0A 04 00 9D E5 00 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 29 FF FF 1A 07 10 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 22 FF FF 1A 00 00 59 E3 05 10 A0 E1 05 00 A0 E1 00 A0 A0 03 FE A5 A0 13 ?? ?? ?? ?? 00 10 A0 E1 ?? ?? ?? ?? 02 41 04 E2 00 00 50 E3 05 10 A0 E1 05 00 A0 E1 02 A1 CA E3 04 A0 8A E1 00 40 A0 E3 01 40 A0 13 ?? ?? ?? ?? 00 00 50 E3 00 00 A0 13 01 00 04 02 00 00 50 E3 00 30 A0 03 FE 35 A0 13 02 31 C3 E3 0A 10 A0 E1 02 51 05 E2 08 00 A0 E1 05 40 83 E1 ?? ?? ?? ?? 04 10 A0 E1 00 50 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E3 ?? ?? ?? ?? 0A 10 A0 E1 00 60 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 00 50 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E3 ?? ?? ?? ?? 00 A0 A0 E1 ED FE FF EA 00 00 80 7F 00 00 80 FF }
	condition:
		$1
}

rule file_44_0_0 {
	meta:
		name = "__gcc_bcmp"
		size = 68
	strings:
		$1 = { 00 00 52 E3 0A 00 00 0A 00 C0 D0 E5 00 30 D1 E5 03 00 5C E1 04 00 00 0A 07 00 00 EA 01 C0 F0 E5 01 30 F1 E5 03 00 5C E1 03 00 00 1A 01 20 52 E2 F9 FF FF 1A 00 00 A0 E3 0E F0 A0 E1 0C 00 63 E0 0E F0 A0 E1 }
	condition:
		$1
}

rule file_45_0_0 {
	meta:
		name = "__fixsfsi"
		size = 92
	strings:
		$1 = { 80 20 A0 E1 7F 04 52 E3 08 00 00 3A 9E 30 A0 E3 22 2C 53 E0 07 00 00 9A 00 34 A0 E1 02 31 83 E3 02 01 10 E3 33 02 A0 E1 00 00 60 12 0E F0 A0 E1 00 00 A0 E3 0E F0 A0 E1 61 00 72 E3 01 00 00 1A 80 24 B0 E1 02 00 00 1A 02 01 10 E2 02 01 E0 03 0E F0 A0 E1 00 00 A0 E3 0E F0 A0 E1 }
	condition:
		$1
}

rule file_47_0_0 {
	meta:
		name = "__fixsfdi"
		size = 64
		refs = "000c __ltsf2 0020 __fixunssfdi"
	strings:
		$1 = { 10 40 2D E9 00 10 A0 E3 00 40 A0 E1 ?? ?? ?? ?? 00 00 50 E3 02 00 00 BA 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? 02 01 84 E2 ?? ?? ?? ?? 00 30 70 E2 00 40 E1 E2 04 10 A0 E1 03 00 A0 E1 10 80 BD E8 }
	condition:
		$1
}

rule file_48_0_0 {
	meta:
		name = "__fixunssfdi"
		size = 96
		refs = "0004 __extendsfdf2 0018 __muldf3 001c __fixunsdfsi 0024 __floatunsidf 003c __adddf3"
	strings:
		$1 = { 70 40 2D E9 ?? ?? ?? ?? 00 20 A0 E3 44 30 9F E5 00 50 A0 E1 01 60 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 00 40 A0 E1 ?? ?? ?? ?? 00 20 A0 E3 28 30 9F E5 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 00 20 A0 E3 00 20 82 E1 04 10 A0 E1 02 00 A0 E1 70 80 BD E8 00 00 F0 3D 00 00 F0 C1 }
	condition:
		$1
}

rule file_50_0_0 {
	meta:
		name = "__udivdi3"
		size = 1092
		refs = "0030 __clzsi2 0058 __umodsi3 0068 __udivsi3"
	strings:
		$1 = { F0 4F 2D E9 00 00 53 E3 08 D0 4D E2 03 70 A0 E1 01 B0 A0 E1 00 50 A0 E1 02 40 A0 E1 01 60 A0 E1 35 00 00 1A 01 00 52 E1 84 00 00 9A 02 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 20 30 60 12 35 33 A0 11 14 40 A0 11 1B 60 83 11 24 78 A0 E1 15 50 A0 11 07 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 07 10 A0 E1 00 90 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 04 68 A0 E1 26 68 A0 E1 96 00 0A E0 25 38 A0 E1 09 98 83 E1 09 00 5A E1 00 80 A0 E1 05 00 00 9A 04 90 99 E0 01 80 40 E2 02 00 00 2A 09 00 5A E1 01 80 48 82 04 90 89 80 09 A0 6A E0 07 10 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 07 10 A0 E1 00 B0 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 90 06 06 E0 05 58 A0 E1 25 58 A0 E1 0B 58 85 E1 05 00 56 E1 04 00 00 9A 04 50 95 E0 01 00 40 E2 01 00 00 2A 05 00 56 E1 01 00 40 82 08 A8 80 E1 00 10 A0 E3 8F 00 00 EA 01 00 53 E1 8B 00 00 8A 03 00 A0 E1 ?? ?? ?? ?? 00 60 50 E2 82 00 00 0A 20 80 66 E2 34 28 A0 E1 17 76 82 E1 35 38 A0 E1 3B 88 A0 E1 27 A8 A0 E1 08 00 A0 E1 0A 10 A0 E1 1B B6 83 E1 ?? ?? ?? ?? 0A 10 A0 E1 00 30 A0 E1 08 00 A0 E1 00 30 8D E5 ?? ?? ?? ?? 07 88 A0 E1 28 88 A0 E1 98 00 01 E0 00 30 9D E5 2B 28 A0 E1 03 38 82 E1 03 00 51 E1 00 90 A0 E1 14 26 A0 E1 02 00 00 9A 07 30 93 E0 01 90 40 E2 A7 00 00 3A 03 40 61 E0 04 00 A0 E1 0A 10 A0 E1 04 20 8D E5 ?? ?? ?? ?? 0A 10 A0 E1 00 30 A0 E1 04 00 A0 E1 00 30 8D E5 ?? ?? ?? ?? 90 08 08 E0 0B B8 A0 E1 00 30 9D E5 2B B8 A0 E1 03 38 8B E1 03 00 58 E1 04 20 9D E5 02 00 00 9A 07 30 93 E0 01 00 40 E2 8E 00 00 3A 03 30 68 E0 09 A8 80 E1 2A C8 A0 E1 22 18 A0 E1 0C E8 CA E1 01 48 C2 E1 9E 04 00 E0 9C 04 04 E0 91 0E 0E E0 9C 01 01 E0 0E E0 94 E0 01 18 81 22 0E 08 90 E0 2E 18 A1 E0 01 00 53 E1 06 00 00 3A 00 10 A0 13 01 10 A0 03 15 06 50 E1 00 10 A0 93 01 10 01 82 00 00 51 E3 41 00 00 0A 01 A0 4A E2 00 10 A0 E3 3E 00 00 EA 00 00 52 E3 03 00 00 1A 02 10 A0 E1 01 00 A0 E3 ?? ?? ?? ?? 00 40 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 A0 50 E2 38 00 00 1A 04 88 A0 E1 0B B0 64 E0 28 88 A0 E1 24 78 A0 E1 01 60 A0 E3 07 10 A0 E1 0B 00 A0 E1 ?? ?? ?? ?? 07 10 A0 E1 00 90 A0 E1 0B 00 A0 E1 ?? ?? ?? ?? 98 00 03 E0 25 28 A0 E1 09 98 82 E1 09 00 53 E1 00 A0 A0 E1 05 00 00 9A 04 90 99 E0 01 A0 40 E2 02 00 00 2A 09 00 53 E1 01 A0 4A 82 04 90 89 80 09 90 63 E0 07 10 A0 E1 09 00 A0 E1 ?? ?? ?? ?? 07 10 A0 E1 00 B0 A0 E1 09 00 A0 E1 ?? ?? ?? ?? 90 08 08 E0 05 58 A0 E1 25 58 A0 E1 0B 58 85 E1 05 00 58 E1 04 00 00 9A 04 50 95 E0 01 00 40 E2 01 00 00 2A 05 00 58 E1 01 00 40 82 0A A8 80 E1 06 10 A0 E1 06 00 00 EA 0B 00 57 E1 05 00 54 21 06 10 A0 91 01 A0 A0 93 01 00 00 9A 00 10 A0 E3 01 A0 A0 E1 01 40 A0 E1 0A 00 A0 E1 08 D0 8D E2 F0 8F BD E8 20 60 6A E2 14 4A A0 E1 35 36 A0 E1 3B 66 A0 E1 24 78 A0 E1 06 00 A0 E1 07 10 A0 E1 1B BA 83 E1 ?? ?? ?? ?? 07 10 A0 E1 00 90 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 04 88 A0 E1 28 88 A0 E1 98 00 03 E0 2B 28 A0 E1 09 98 82 E1 09 00 53 E1 00 60 A0 E1 02 00 00 9A 04 90 99 E0 01 60 40 E2 21 00 00 3A 09 90 63 E0 07 10 A0 E1 09 00 A0 E1 ?? ?? ?? ?? 07 10 A0 E1 00 30 A0 E1 09 00 A0 E1 00 30 8D E5 ?? ?? ?? ?? 98 00 02 E0 0B B8 A0 E1 00 30 9D E5 2B B8 A0 E1 03 38 8B E1 03 00 52 E1 05 00 00 9A 04 30 93 E0 01 00 40 E2 02 00 00 2A 03 00 52 E1 01 00 40 82 04 30 83 80 15 5A A0 E1 03 B0 62 E0 06 68 80 E1 99 FF FF EA 03 00 58 E1 07 30 83 80 01 00 40 82 6C FF FF EA 03 00 51 E1 01 90 49 82 07 30 83 80 53 FF FF EA 09 00 53 E1 01 60 46 82 04 90 89 80 D9 FF FF EA }
	condition:
		$1
}

rule file_54_0_0 {
	meta:
		name = "__ashrdi3"
		size = 28
	strings:
		$1 = { 20 30 52 E2 20 C0 62 E2 30 02 A0 41 51 03 A0 51 11 0C 80 41 51 12 A0 E1 0E F0 A0 E1 }
	condition:
		$1
}

rule file_57_0_0 {
	meta:
		name = "__umoddi3"
		size = 1084
		refs = "0034 __clzsi2 005c __umodsi3 006c __udivsi3"
	strings:
		$1 = { F0 4F 2D E9 00 00 53 E3 0C D0 4D E2 03 60 A0 E1 01 80 A0 E1 02 50 A0 E1 00 B0 A0 E1 00 A0 A0 E1 01 90 A0 E1 33 00 00 1A 01 00 52 E1 41 00 00 9A 02 00 A0 E1 ?? ?? ?? ?? 00 60 50 E2 20 30 66 12 3B 33 A0 11 15 56 A0 11 18 96 83 11 25 78 A0 E1 07 10 A0 E1 09 00 A0 E1 1B A6 A0 11 ?? ?? ?? ?? 07 10 A0 E1 00 B0 A0 E1 09 00 A0 E1 ?? ?? ?? ?? 05 48 A0 E1 24 48 A0 E1 94 00 00 E0 2A 88 A0 E1 0B B8 88 E1 0B 00 50 E1 03 00 00 9A 05 B0 9B E0 01 00 00 2A 0B 00 50 E1 05 B0 8B 80 0B 80 60 E0 07 10 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 07 10 A0 E1 00 B0 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 94 00 00 E0 0A A8 A0 E1 2A A8 A0 E1 0B B8 8A E1 0B 00 50 E1 03 00 00 9A 05 B0 9B E0 01 00 00 2A 0B 00 50 E1 05 B0 8B 80 0B 00 60 E0 30 06 A0 E1 00 10 A0 E3 0C D0 8D E2 F0 8F BD E8 01 00 53 E1 01 10 A0 81 FA FF FF 8A 03 00 A0 E1 ?? ?? ?? ?? 00 40 50 E2 3C 00 00 1A 08 00 56 E1 0B 00 55 21 02 00 00 8A 05 00 5B E0 06 90 C8 E0 00 A0 A0 E1 0A 00 A0 E1 09 10 A0 E1 ED FF FF EA 00 00 52 E3 03 00 00 1A 02 10 A0 E1 01 00 A0 E3 ?? ?? ?? ?? 00 50 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 00 60 A0 E1 00 90 A0 E1 7C 00 00 1A 05 78 A0 E1 08 80 65 E0 27 78 A0 E1 25 48 A0 E1 08 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 00 90 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 97 00 00 E0 2A 88 A0 E1 09 98 88 E1 09 00 50 E1 03 00 00 9A 05 90 99 E0 01 00 00 2A 09 00 50 E1 05 90 89 80 09 80 60 E0 04 10 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 00 90 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 97 00 00 E0 0A A8 A0 E1 2A A8 A0 E1 09 98 8A E1 09 00 50 E1 03 00 00 9A 05 90 99 E0 01 00 00 2A 09 00 50 E1 05 90 89 80 09 00 60 E0 B7 FF FF EA 20 70 64 E2 35 27 A0 E1 3B 37 A0 E1 16 64 82 E1 38 97 A0 E1 18 84 83 E1 26 A8 A0 E1 09 00 A0 E1 0A 10 A0 E1 08 80 8D E5 ?? ?? ?? ?? 0A 10 A0 E1 00 30 A0 E1 09 00 A0 E1 00 30 8D E5 ?? ?? ?? ?? 06 88 A0 E1 28 88 A0 E1 98 00 01 E0 00 90 A0 E1 08 00 9D E5 00 30 9D E5 20 28 A0 E1 03 28 82 E1 02 00 51 E1 15 54 A0 E1 1B 34 A0 E1 02 00 00 9A 06 20 92 E0 01 90 49 E2 66 00 00 3A 02 B0 61 E0 0B 00 A0 E1 0A 10 A0 E1 00 30 8D E5 ?? ?? ?? ?? 0A 10 A0 E1 00 20 A0 E1 0B 00 A0 E1 04 20 8D E5 ?? ?? ?? ?? 08 10 9D E5 90 08 08 E0 01 A8 A0 E1 04 20 9D E5 2A A8 A0 E1 02 28 8A E1 02 00 58 E1 00 30 9D E5 02 00 00 9A 06 20 92 E0 01 00 40 E2 4C 00 00 3A 02 20 68 E0 09 98 80 E1 29 08 A0 E1 25 C8 A0 E1 00 88 C9 E1 0C 98 C5 E1 98 09 01 E0 90 09 09 E0 9C 08 08 E0 90 0C 0C E0 08 80 99 E0 01 C8 8C 22 08 18 91 E0 28 C8 AC E0 0C 00 52 E1 06 00 00 3A 00 00 A0 13 01 00 A0 03 01 00 53 E1 00 00 A0 23 01 00 00 32 00 00 50 E3 02 00 00 0A 05 00 51 E0 06 C0 CC E0 00 10 A0 E1 01 00 53 E0 0C 10 C2 E0 11 77 A0 E1 31 14 A0 E1 30 04 87 E1 64 FF FF EA 15 50 A0 E1 20 30 60 E2 38 73 A0 E1 3A 33 A0 E1 25 48 A0 E1 07 00 A0 E1 04 10 A0 E1 18 86 83 E1 ?? ?? ?? ?? 04 10 A0 E1 00 B0 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 05 78 A0 E1 27 78 A0 E1 97 00 00 E0 28 38 A0 E1 0B B8 83 E1 0B 00 50 E1 01 00 00 9A 05 B0 9B E0 1E 00 00 3A 0B B0 60 E0 04 10 A0 E1 0B 00 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 00 30 A0 E1 0B 00 A0 E1 00 30 8D E5 ?? ?? ?? ?? 97 00 00 E0 08 88 A0 E1 00 30 9D E5 28 88 A0 E1 03 38 88 E1 03 00 50 E1 03 00 00 9A 05 30 93 E0 01 00 00 2A 03 00 50 E1 05 30 83 80 1A A9 A0 E1 03 80 60 E0 59 FF FF EA 02 00 58 E1 01 00 40 82 06 20 82 80 AE FF FF EA 02 00 51 E1 01 90 49 82 06 20 82 80 94 FF FF EA 0B 00 50 E1 05 B0 8B 80 DD FF FF EA }
	condition:
		$1
}

rule file_58_0_0 {
	meta:
		name = "__udivmoddi4"
		size = 1360
		refs = "0038 __clzsi2 0060 __umodsi3 0070 __udivsi3"
	strings:
		$1 = { F0 4F 2D E9 00 00 53 E3 10 D0 4D E2 03 70 A0 E1 01 80 A0 E1 34 50 9D E5 02 40 A0 E1 00 90 A0 E1 00 60 A0 E1 01 A0 A0 E1 3F 00 00 1A 01 00 52 E1 5F 00 00 9A 02 00 A0 E1 ?? ?? ?? ?? 00 70 50 E2 20 30 67 12 39 33 A0 11 14 47 A0 11 18 A7 83 11 24 B8 A0 E1 0A 00 A0 E1 0B 10 A0 E1 19 67 A0 11 ?? ?? ?? ?? 0B 10 A0 E1 00 90 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 04 88 A0 E1 28 88 A0 E1 98 00 03 E0 26 28 A0 E1 09 98 82 E1 09 00 53 E1 00 A0 A0 E1 05 00 00 9A 04 90 99 E0 01 A0 40 E2 02 00 00 2A 09 00 53 E1 01 A0 4A 82 04 90 89 80 09 90 63 E0 0B 10 A0 E1 09 00 A0 E1 ?? ?? ?? ?? 0B 10 A0 E1 00 30 A0 E1 09 00 A0 E1 04 30 8D E5 ?? ?? ?? ?? 98 00 02 E0 06 68 A0 E1 04 30 9D E5 26 68 A0 E1 03 38 86 E1 03 00 52 E1 05 00 00 9A 04 30 93 E0 01 00 40 E2 02 00 00 2A 03 00 52 E1 04 30 83 80 01 00 40 82 0A A8 80 E1 03 20 62 E0 00 B0 A0 E3 00 00 55 E3 32 27 A0 11 00 30 A0 13 04 30 85 15 00 20 85 15 0B 10 A0 E1 08 00 00 EA 01 00 53 E1 0A 00 00 9A 00 00 55 E3 05 10 A0 01 00 10 A0 13 01 A0 A0 01 04 80 85 15 00 00 85 15 01 A0 A0 11 01 40 A0 E1 0A 00 A0 E1 10 D0 8D E2 F0 8F BD E8 03 00 A0 E1 ?? ?? ?? ?? 00 B0 50 E2 8A 00 00 1A 07 00 58 E1 04 00 59 91 00 90 A0 33 01 90 A0 23 03 00 00 3A 04 E0 56 E0 07 A0 C8 E0 01 90 A0 E3 0E 60 A0 E1 00 00 55 E3 04 A0 85 15 09 A0 A0 01 05 10 A0 01 00 60 85 15 09 A0 A0 11 00 10 A0 13 E6 FF FF EA 00 00 52 E3 03 00 00 1A 02 10 A0 E1 01 00 A0 E3 ?? ?? ?? ?? 00 40 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 00 70 A0 E1 00 B0 A0 E1 34 00 00 1A 04 A8 A0 E1 08 90 64 E0 2A A8 A0 E1 24 88 A0 E1 01 B0 A0 E3 09 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 08 10 A0 E1 00 20 A0 E1 09 00 A0 E1 00 20 8D E5 ?? ?? ?? ?? 9A 00 03 E0 00 20 9D E5 26 18 A0 E1 02 28 81 E1 02 00 53 E1 00 90 A0 E1 05 00 00 9A 04 20 92 E0 01 90 40 E2 02 00 00 2A 02 00 53 E1 01 90 49 82 04 20 82 80 02 30 63 E0 03 00 A0 E1 08 10 A0 E1 04 30 8D E5 ?? ?? ?? ?? 04 30 9D E5 00 20 A0 E1 08 10 A0 E1 03 00 A0 E1 00 20 8D E5 ?? ?? ?? ?? 9A 00 03 E0 06 68 A0 E1 00 20 9D E5 26 68 A0 E1 02 28 86 E1 02 00 53 E1 05 00 00 9A 04 20 92 E0 01 00 40 E2 02 00 00 2A 02 00 53 E1 04 20 82 80 01 00 40 82 09 A8 80 E1 02 20 63 E0 95 FF FF EA 20 A0 60 E2 36 3A A0 E1 14 40 A0 E1 38 AA A0 E1 18 80 83 E1 08 80 8D E5 24 88 A0 E1 0A 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 08 10 A0 E1 00 20 A0 E1 0A 00 A0 E1 00 20 8D E5 ?? ?? ?? ?? 04 A8 A0 E1 2A A8 A0 E1 9A 00 03 E0 00 90 A0 E1 08 00 9D E5 00 20 9D E5 20 18 A0 E1 02 28 81 E1 02 00 53 E1 02 00 00 9A 04 20 92 E0 01 90 49 E2 85 00 00 3A 02 30 63 E0 03 00 A0 E1 08 10 A0 E1 04 30 8D E5 ?? ?? ?? ?? 04 30 9D E5 00 20 A0 E1 08 10 A0 E1 03 00 A0 E1 00 20 8D E5 ?? ?? ?? ?? 08 C0 9D E5 9A 00 03 E0 0C 18 A0 E1 00 20 9D E5 21 18 A0 E1 02 28 81 E1 02 00 53 E1 05 00 00 9A 04 20 92 E0 01 00 40 E2 02 00 00 2A 02 00 53 E1 01 00 40 82 04 20 82 80 16 6B A0 E1 09 B8 80 E1 02 90 63 E0 96 FF FF EA 20 30 6B E2 39 23 A0 E1 34 13 A0 E1 38 63 A0 E1 17 7B 81 E1 18 8B 82 E1 0C 80 8D E5 27 88 A0 E1 06 00 A0 E1 08 10 A0 E1 04 30 8D E5 ?? ?? ?? ?? 08 10 A0 E1 00 20 A0 E1 06 00 A0 E1 00 20 8D E5 ?? ?? ?? ?? 19 9B A0 E1 07 68 A0 E1 26 68 A0 E1 96 00 01 E0 0C C0 9D E5 00 20 9D E5 00 A0 A0 E1 2C 08 A0 E1 02 08 80 E1 00 00 51 E1 14 2B A0 E1 08 90 8D E5 04 30 9D E5 02 00 00 9A 07 00 90 E0 01 A0 4A E2 42 00 00 3A 00 40 61 E0 04 00 A0 E1 08 10 A0 E1 0C 00 8D E8 ?? ?? ?? ?? 08 10 A0 E1 00 90 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 0C E0 9D E5 90 06 06 E0 0E 88 A0 E1 28 88 A0 E1 09 98 88 E1 09 00 56 E1 0C 00 9D E8 02 00 00 9A 07 90 99 E0 01 00 40 E2 2A 00 00 3A 09 90 66 E0 0A A8 80 E1 2A C8 A0 E1 22 18 A0 E1 0C 48 CA E1 01 68 C2 E1 94 06 00 E0 9C 06 06 E0 91 04 04 E0 9C 01 01 E0 04 40 96 E0 01 18 81 22 04 08 90 E0 24 18 A1 E0 01 00 59 E1 15 00 00 3A 08 E0 9D E5 00 C0 A0 13 01 C0 A0 03 0E 00 50 E1 00 C0 A0 93 01 C0 0C 82 00 00 5C E3 0D 00 00 1A 00 00 55 E3 05 10 A0 01 1B FF FF 0A 08 C0 9D E5 00 E0 5C E0 01 20 C9 E0 12 33 A0 E1 32 2B A0 E1 3E BB 83 E1 0E 90 A0 E1 04 20 85 E5 00 B0 85 E5 00 10 A0 E3 10 FF FF EA 02 C0 50 E0 07 10 C1 E0 01 A0 4A E2 0C 00 A0 E1 EC FF FF EA 09 00 56 E1 01 00 40 82 07 90 89 80 D0 FF FF EA 00 00 51 E1 01 A0 4A 82 07 00 80 80 B8 FF FF EA 02 00 53 E1 01 90 49 82 04 20 82 80 75 FF FF EA }
	condition:
		$1
}

rule file_64_0_0 {
	meta:
		name = "__clzdi2"
		size = 36
		refs = "000c __clzsi2"
	strings:
		$1 = { 10 40 2D E9 00 00 51 E3 02 00 00 1A ?? ?? ?? ?? 20 00 80 E2 01 00 00 EA 01 00 A0 E1 ?? ?? ?? ?? 10 80 BD E8 }
	condition:
		$1
}

rule file_66_0_0 {
	meta:
		name = "__subvsi3"
		size = 64
		refs = "003c abort"
	strings:
		$1 = { 00 00 51 E3 04 E0 2D E5 00 10 61 E0 06 00 00 BA 00 00 51 E1 00 00 A0 D3 01 00 A0 C3 00 00 50 E3 05 00 00 1A 01 00 A0 E1 04 F0 9D E4 00 00 51 E1 00 00 A0 A3 01 00 A0 B3 F7 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_70_0_0 {
	meta:
		name = "__muldf3"
		size = 620
	strings:
		$1 = { 70 40 2D E9 FF C0 A0 E3 07 CC 8C E3 21 4A 1C E0 23 5A 1C 10 0C 00 34 11 0C 00 35 11 6F 00 00 0B 05 40 84 E0 03 60 21 E0 8C 1A C1 E1 8C 3A C3 E1 01 56 90 E1 03 56 92 11 01 16 81 E3 01 36 83 E3 1C 00 00 0A 90 C2 8E E0 00 50 A0 E3 91 E2 A5 E0 02 21 06 E2 90 E3 A5 E0 00 60 A0 E3 91 53 A6 E0 00 00 3C E3 01 E0 8E 13 FF 40 44 E2 02 0C 56 E3 03 4C C4 E2 02 00 00 2A 8E E0 B0 E1 05 50 B5 E0 06 60 A6 E0 86 15 82 E1 A5 1A 81 E1 85 05 A0 E1 AE 0A 80 E1 8E E5 A0 E1 FD C0 54 E2 07 0C 5C 83 0F 00 00 8A 02 01 5E E3 A0 E0 B0 01 00 00 B0 E2 04 1A A1 E0 70 80 BD E8 02 61 06 E2 01 10 86 E1 02 00 80 E1 03 10 21 E0 AC 40 54 E0 0C 50 74 C0 04 1A 81 C1 70 80 BD C8 01 16 81 E3 00 E0 A0 E3 01 40 54 E2 58 00 00 CA 36 00 74 E3 00 00 A0 D3 02 11 01 D2 70 80 BD D8 00 40 64 E2 20 40 54 E2 18 00 00 AA 0C 40 94 E2 0B 00 00 CA 14 40 84 E2 20 50 64 E2 10 35 A0 E1 30 04 A0 E1 11 05 80 E1 02 21 01 E2 02 11 C1 E3 A3 0F 90 E0 31 14 A2 E0 83 E0 9E E1 A3 0F C0 01 70 80 BD E8 0C 40 64 E2 20 50 64 E2 10 34 A0 E1 30 05 A0 E1 11 04 80 E1 02 11 01 E2 A3 0F 90 E0 00 10 A1 E2 83 E0 9E E1 A3 0F C0 01 70 80 BD E8 20 50 64 E2 10 E5 8E E1 30 34 A0 E1 11 35 83 E1 31 04 A0 E1 02 11 01 E2 31 04 C0 E1 A3 0F 80 E0 83 E0 9E E1 A3 0F C0 01 70 80 BD E8 00 00 34 E3 08 00 00 1A 02 61 01 E2 80 00 B0 E1 01 10 A1 E0 01 06 11 E3 01 40 44 02 FA FF FF 0A 06 10 81 E1 00 00 35 E3 0E F0 A0 11 02 61 03 E2 82 20 B0 E1 03 30 A3 E0 01 06 13 E3 01 50 45 02 FA FF FF 0A 06 30 83 E1 0E F0 A0 E1 0C 00 34 E1 23 5A 0C E0 0C 00 35 11 06 00 00 0A 81 60 90 E1 83 60 92 11 E5 FF FF 1A 03 10 21 E0 02 11 01 E2 00 00 A0 E3 70 80 BD E8 81 60 90 E1 02 00 A0 01 03 10 A0 01 83 60 92 11 0F 00 00 0A 0C 00 34 E1 01 00 00 1A 01 66 90 E1 0B 00 00 1A 0C 00 35 E1 03 00 00 1A 03 66 92 E1 02 00 A0 11 03 10 A0 11 05 00 00 1A 03 10 21 E0 02 11 01 E2 7F 14 81 E3 0F 16 81 E3 00 00 A0 E3 70 80 BD E8 7F 14 81 E3 3E 17 81 E3 70 80 BD E8 }
	condition:
		$1
}

rule file_70_1_0 {
	meta:
		name = "__divdf3"
		size = 516
	strings:
		$1 = { 70 40 2D E9 FF C0 A0 E3 07 CC 8C E3 21 4A 1C E0 23 5A 1C 10 0C 00 34 11 0C 00 35 11 5C 00 00 0B 05 40 44 E0 03 E0 21 E0 03 56 92 E1 01 16 A0 E1 4B 00 00 0A 03 36 A0 E1 01 52 A0 E3 23 32 85 E1 22 3C 83 E1 02 24 A0 E1 21 52 85 E1 20 5C 85 E1 00 64 A0 E1 02 11 0E E2 03 00 55 E1 02 00 56 01 FD 40 A4 E2 03 4C 84 E2 01 00 00 2A A3 30 B0 E1 62 20 A0 E1 02 60 56 E0 03 50 C5 E0 A3 30 B0 E1 62 20 A0 E1 01 06 A0 E3 02 C7 A0 E3 02 E0 56 E0 03 E0 D5 E0 02 60 46 20 0E 50 A0 21 0C 00 80 21 A3 30 B0 E1 62 20 A0 E1 02 E0 56 E0 03 E0 D5 E0 02 60 46 20 0E 50 A0 21 AC 00 80 21 A3 30 B0 E1 62 20 A0 E1 02 E0 56 E0 03 E0 D5 E0 02 60 46 20 0E 50 A0 21 2C 01 80 21 A3 30 B0 E1 62 20 A0 E1 02 E0 56 E0 03 E0 D5 E0 02 60 46 20 0E 50 A0 21 AC 01 80 21 06 E0 95 E1 0D 00 00 0A 05 52 A0 E1 26 5E 85 E1 06 62 A0 E1 83 31 A0 E1 A2 3E 83 E1 82 21 A0 E1 2C C2 B0 E1 DB FF FF 1A 01 06 11 E3 06 00 00 1A 00 10 81 E1 00 00 A0 E3 02 C1 A0 E3 D5 FF FF EA 01 06 11 E3 00 10 81 01 00 00 A0 03 FD C0 54 E2 07 0C 5C 83 4A FF FF 8A 03 C0 55 E0 02 C0 56 00 A0 C0 B0 01 00 00 B0 E2 04 1A A1 E0 70 80 BD E8 02 E1 0E E2 21 16 8E E1 AC 40 94 E0 0C 50 74 C0 04 1A 81 C1 70 80 BD C8 01 16 81 E3 00 E0 A0 E3 01 40 54 E2 3A FF FF EA 06 E0 85 E1 38 FF FF EA 23 5A 0C E0 0C 00 34 E1 0C 00 35 01 93 FF FF 0A 0C 00 34 E1 06 00 00 1A 01 46 90 E1 8F FF FF 1A 0C 00 35 E1 87 FF FF 1A 02 00 A0 E1 03 10 A0 E1 8A FF FF EA 0C 00 35 E1 04 00 00 1A 03 56 92 E1 6D FF FF 0A 02 00 A0 E1 03 10 A0 E1 83 FF FF EA 81 60 90 E1 83 60 92 11 4D FF FF 1A 81 40 90 E1 78 FF FF 1A 83 50 92 E1 63 FF FF 1A 7B FF FF EA }
	condition:
		$1
}

rule file_73_0_0 {
	meta:
		name = "iszero"
		size = 20
	strings:
		$1 = { 00 00 90 E5 02 00 50 E3 00 00 A0 13 01 00 A0 03 0E F0 A0 E1 }
	condition:
		$1
}

rule file_73_1_0 {
	meta:
		name = "isnan"
		size = 20
	strings:
		$1 = { 00 00 90 E5 01 00 50 E3 00 00 A0 83 01 00 A0 93 0E F0 A0 E1 }
	condition:
		$1
}

rule file_73_2_0 {
	meta:
		name = "isinf"
		size = 20
	strings:
		$1 = { 00 00 90 E5 04 00 50 E3 00 00 A0 13 01 00 A0 03 0E F0 A0 E1 }
	condition:
		$1
}

rule file_73_3_0 {
	meta:
		name = "__pack_d"
		size = 628
		refs = "0190 __lshrdi3 01a8 __ashldi3 01d4 __ucmpdi2"
	strings:
		$1 = { F0 43 2D E9 10 D0 4D E2 00 40 A0 E1 10 70 80 E2 C0 00 97 E8 EF FF FF EB 00 00 50 E3 14 00 00 0A 00 30 A0 E3 00 10 E0 E3 02 47 A0 E3 06 30 83 E1 30 22 9F E5 07 40 84 E1 01 30 03 E0 28 12 9F E5 02 40 04 E0 B8 20 DD E1 04 C0 9D E5 A2 25 A0 E1 81 2A 82 E1 2C CA A0 E1 04 C6 8C E1 E2 2A A0 E1 6C 06 A0 E1 03 10 A0 E1 B8 20 CD E1 10 D0 8D E2 F0 83 BD E8 04 00 A0 E1 DB FF FF EB 00 00 50 E3 03 00 00 0A E0 11 9F E5 00 30 A0 E3 00 40 A0 E3 EB FF FF EA 04 00 A0 E1 C9 FF FF EB 00 00 50 E3 20 00 00 1A 07 20 96 E1 1E 00 00 0A 08 10 94 E5 B8 31 9F E5 03 00 51 E1 2B 00 00 BA 01 0B 51 E3 EF FF FF AA FF 30 06 E2 00 40 A0 E3 FF 1F 81 E2 80 00 53 E3 03 10 81 E2 16 00 00 0A 7F 30 A0 E3 00 40 A0 E3 03 60 96 E0 04 70 A7 E0 1E 02 77 E3 02 00 00 9A A7 70 B0 E1 66 60 A0 E1 01 10 81 E2 26 34 A0 E1 07 3C 83 E1 27 44 A0 E1 54 71 9F E5 81 1A A0 E1 00 60 E0 E3 06 30 03 E0 07 40 04 E0 A1 1A A0 E1 C6 FF FF EA 00 10 A0 E3 00 30 A0 E3 00 40 A0 E3 C2 FF FF EA 00 00 54 E3 E6 FF FF 1A 01 3C A0 E3 00 40 A0 E3 06 30 03 E0 07 40 04 E0 04 20 93 E1 E4 FF FF 0A 80 30 A0 E3 00 40 A0 E3 03 60 96 E0 04 70 A7 E0 DF FF FF EA 03 80 61 E0 38 00 58 E3 00 10 A0 C1 00 30 A0 C3 00 40 A0 C3 E1 FF FF CA 08 20 A0 E1 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 08 20 A0 E1 00 40 A0 E1 01 50 A0 E1 01 00 A0 E3 00 10 A0 E3 ?? ?? ?? ?? 00 20 E0 E3 00 20 92 E0 00 30 E0 E3 01 30 A3 E0 02 60 06 E0 03 70 07 E0 06 00 A0 E1 07 10 A0 E1 00 30 A0 E3 00 20 A0 E3 ?? ?? ?? ?? 01 00 50 E3 01 60 A0 13 04 60 86 E1 FF 30 06 E2 00 40 A0 E3 00 70 A0 13 80 00 53 E3 05 70 87 E1 0A 00 00 0A 7F 80 A0 E3 06 80 98 E0 00 90 A0 E3 07 90 A9 E0 28 34 A0 E1 09 3C 83 E1 1F 02 79 E3 00 10 A0 93 01 10 A0 83 29 44 A0 E1 B8 FF FF EA 00 00 54 E3 F2 FF FF 1A 01 3C A0 E3 00 40 A0 E3 06 30 03 E0 07 40 04 E0 04 20 93 E1 80 80 A0 13 EC FF FF 1A 26 34 A0 E1 07 3C 83 E1 1F 02 77 E3 00 10 A0 93 01 10 A0 83 27 44 A0 E1 A8 FF FF EA FF FF 0F 00 FF 07 00 00 02 FC FF FF }
	condition:
		$1
}

rule file_74_0_0 {
	meta:
		name = "fprintf"
		size = 48
		refs = "001c __mingw_vfprintf"
		altNames = "_open _wopen open"
	strings:
		$1 = { 0E 00 2D E9 04 E0 2D E5 04 D0 4D E2 0C 30 8D E2 03 20 A0 E1 08 10 9D E5 00 30 8D E5 ?? ?? ?? ?? 04 D0 8D E2 04 E0 9D E4 0C D0 8D E2 0E F0 A0 E1 }
	condition:
		$1
}

rule file_74_1_0 {
	meta:
		name = "__eprintf"
		size = 64
		refs = "0018 _getstdfilex 0038 fflush 003c abort"
	strings:
		$1 = { 04 D0 4D E2 01 60 A0 E1 02 50 A0 E1 00 70 A0 E1 02 00 A0 E3 03 40 A0 E1 ?? ?? ?? ?? 07 10 A0 E1 06 20 A0 E1 05 30 A0 E1 00 40 8D E5 E7 FF FF EB 02 00 A0 E3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_77_0_0 {
	meta:
		name = "__mulvdi3"
		size = 452
		refs = "0088 abort"
	strings:
		$1 = { 01 C0 A0 E1 F0 4B 2D E9 00 B0 A0 E1 CB 0F 5C E1 0B 10 A0 E1 06 00 00 1A C2 0F 53 E1 02 00 A0 E1 19 00 00 1A 92 3B C4 E0 04 10 A0 E1 03 00 A0 E1 F0 8B BD E8 C2 0F 53 E1 02 40 A0 E1 2D 00 00 1A 92 5B 86 E0 9C 24 83 E0 00 00 5C E3 03 10 64 B0 02 70 A0 E1 03 80 A0 E1 02 20 A0 B1 01 30 A0 B1 00 00 54 E3 05 00 A0 E1 1C 00 00 BA 06 20 92 E0 00 30 A3 E2 C2 1F A0 E1 03 00 51 E1 00 30 A0 01 02 40 A0 01 E7 FF FF 0A ?? ?? ?? ?? 93 4B 85 E0 92 6B 87 E0 00 00 53 E3 05 00 61 B0 04 80 A0 E1 05 90 A0 E1 04 B0 A0 E1 00 50 A0 B1 04 40 A0 B1 00 00 51 E3 06 C0 A0 E1 0B 00 00 BA 07 40 94 E0 C4 3F A0 E1 00 50 A5 E2 05 00 53 E1 04 20 A0 01 0C 30 A0 01 02 40 A0 01 D2 FF FF 0A E9 FF FF EA 0B 20 52 E0 0C 30 C3 E0 DF FF FF EA 02 40 54 E0 03 50 C5 E0 F0 FF FF EA 00 00 5C E3 0B 00 00 BA 00 00 53 E3 17 00 00 BA 00 00 5C E3 DD FF FF 1A 00 00 53 E3 DB FF FF 1A 92 5B 86 E0 00 00 56 E3 05 30 A0 E1 06 40 A0 E1 BE FF FF AA D5 FF FF EA 00 00 53 E3 16 00 00 BA 01 00 7C E3 D1 FF FF 1A 00 00 53 E3 CF FF FF 1A 92 5B 86 E0 04 40 56 E0 06 20 A0 E1 04 20 A0 41 05 30 A0 41 02 40 A0 41 B0 FF FF 4A C7 FF FF EA 00 00 5C E3 C5 FF FF 1A 01 00 73 E3 C3 FF FF 1A 92 5B 86 E0 0B 10 56 E0 06 40 A0 E1 05 30 A0 E1 01 40 A0 41 A5 FF FF 4A BC FF FF EA 01 00 7C E3 BA FF FF 1A 01 00 73 E3 B8 FF FF 1A 94 2B 83 E0 03 10 6B E0 04 10 51 E0 01 30 A0 51 03 40 A0 51 02 30 A0 51 99 FF FF 5A B0 FF FF EA }
	condition:
		$1
}

rule file_78_0_0 {
	meta:
		name = "__make_dp"
		size = 64
		refs = "002c __pack_d"
	strings:
		$1 = { 04 D0 4D E2 04 E0 2D E5 18 D0 4D E2 08 20 8D E5 20 20 9D E5 00 00 8D E5 0D 00 A0 E1 04 10 8D E5 10 30 8D E5 14 20 8D E5 1C 30 8D E5 ?? ?? ?? ?? 18 D0 8D E2 04 E0 9D E4 04 D0 8D E2 0E F0 A0 E1 }
	condition:
		$1
}

rule file_80_0_0 {
	meta:
		name = "__ucmpdi2"
		size = 44
	strings:
		$1 = { 03 00 51 E1 06 00 00 3A 03 00 00 8A 02 00 50 E1 03 00 00 3A 01 00 A0 93 0E F0 A0 91 02 00 A0 E3 0E F0 A0 E1 00 00 A0 E3 0E F0 A0 E1 }
	condition:
		$1
}

rule file_81_3_0 {
	meta:
		name = "__pack_f"
		size = 336
	strings:
		$1 = { 70 40 2D E9 00 40 A0 E1 0C 50 90 E5 04 60 90 E5 F0 FF FF EB 00 00 50 E3 08 00 00 0A 01 56 85 E3 FF 54 C5 E3 02 55 C5 E3 FF 30 A0 E3 85 54 A0 E1 83 3B A0 E1 E5 04 83 E1 86 0F 80 E1 70 80 BD E8 04 00 A0 E1 E8 FF FF EB 00 00 50 E3 06 00 00 0A FF 30 A0 E3 00 50 A0 E3 85 54 A0 E1 83 3B A0 E1 E5 04 83 E1 86 0F 80 E1 70 80 BD E8 04 00 A0 E1 D3 FF FF EB 00 00 50 E3 13 00 00 1A 00 00 55 E3 11 00 00 0A 08 30 94 E5 7E 00 73 E3 14 00 00 BA 7F 00 53 E3 ED FF FF CA 7F 20 05 E2 40 00 52 E3 7F 30 83 E2 3F 50 85 12 0A 00 00 0A 00 00 55 E3 A5 50 A0 B1 01 30 83 B2 A5 53 A0 E1 FF 54 C5 E3 02 55 C5 E3 FF 30 03 E2 D7 FF FF EA 00 30 A0 E3 03 50 A0 E1 D4 FF FF EA 80 00 15 E3 40 50 85 12 F1 FF FF EA 7D 20 E0 E3 02 20 63 E0 19 00 52 E3 00 30 A0 C1 03 50 A0 C1 EF FF FF CA 00 30 E0 E3 13 32 C5 E1 00 30 53 E2 01 30 A0 13 35 52 83 E1 7F 30 05 E2 40 00 53 E3 05 00 00 0A 3F 50 85 E2 07 01 75 E3 00 30 A0 93 01 30 A0 83 A5 53 A0 E1 E1 FF FF EA 80 00 15 E3 40 50 85 12 07 01 75 E3 00 30 A0 93 01 30 A0 83 A5 53 A0 E1 DA FF FF EA }
	condition:
		$1
}

rule file_82_0_0 {
	meta:
		name = "__unorddf2"
		size = 56
	strings:
		$1 = { 81 C0 A0 E1 CC CA F0 E1 01 00 00 1A 01 C6 90 E1 06 00 00 1A 83 C0 A0 E1 CC CA F0 E1 01 00 00 1A 03 C6 92 E1 01 00 00 1A 00 00 A0 E3 0E F0 A0 E1 01 00 A0 E3 0E F0 A0 E1 }
	condition:
		$1
}

rule file_83_0_0 {
	meta:
		name = "__mulsc3"
		size = 1312
		refs = "001c __mulsf3 005c __subsf3 006c __addsf3 007c __nesf2"
	strings:
		$1 = { F0 4F 2D E9 01 60 A0 E1 10 D0 4D E2 02 10 A0 E1 03 70 A0 E1 02 40 A0 E1 00 80 A0 E1 ?? ?? ?? ?? 07 10 A0 E1 00 90 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 07 10 A0 E1 00 A0 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 08 00 8D E5 06 00 A0 E1 ?? ?? ?? ?? 0A 10 A0 E1 04 00 8D E5 09 00 A0 E1 ?? ?? ?? ?? 04 10 9D E5 00 50 A0 E1 08 00 9D E5 ?? ?? ?? ?? 05 10 A0 E1 00 00 8D E5 05 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 03 00 00 1A 05 00 A0 E1 00 10 9D E5 10 D0 8D E2 F0 8F BD E8 00 00 9D E5 00 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 F6 FF FF 0A 08 10 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 ?? ?? ?? ?? 08 10 A0 E1 00 00 50 E3 08 00 A0 E1 00 B0 A0 E3 01 B0 A0 13 ?? ?? ?? ?? 00 00 50 E3 00 B0 A0 13 01 B0 0B 02 00 00 5B E3 F4 00 00 1A 06 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 ?? ?? ?? ?? 06 10 A0 E1 00 00 50 E3 06 00 A0 E1 01 B0 A0 13 ?? ?? ?? ?? 0B 30 A0 E1 00 00 50 E3 00 30 A0 13 01 30 03 02 00 00 53 E3 0C 30 8D 05 C9 00 00 1A 04 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 00 00 50 E3 04 00 A0 E1 00 B0 A0 E3 01 B0 A0 13 ?? ?? ?? ?? 00 00 50 E3 00 B0 A0 13 01 B0 0B 02 00 00 5B E3 A4 00 00 1A 07 10 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 ?? ?? ?? ?? 07 10 A0 E1 00 00 50 E3 07 00 A0 E1 01 B0 A0 13 ?? ?? ?? ?? 0B 30 A0 E1 00 00 50 E3 00 30 A0 13 01 30 03 02 00 00 53 E3 31 00 00 0A 00 00 54 E3 00 40 A0 E3 02 41 A0 B3 FE 35 A0 E3 02 31 C3 E3 02 71 07 E2 08 00 A0 E1 08 10 A0 E1 07 70 83 E1 ?? ?? ?? ?? 00 00 50 E3 02 00 00 0A 00 00 58 E3 00 80 A0 E3 02 81 A0 B3 06 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 02 00 00 0A 00 00 56 E3 00 60 A0 E3 02 61 A0 B3 04 10 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 07 10 A0 E1 00 50 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? DC 12 9F E5 ?? ?? ?? ?? 07 10 A0 E1 00 50 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 00 70 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 07 00 A0 E1 ?? ?? ?? ?? A8 12 9F E5 ?? ?? ?? ?? 00 00 8D E5 83 FF FF EA 0C 30 9D E5 00 00 53 E3 E1 FF FF 1A 09 10 A0 E1 09 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 ?? ?? ?? ?? 0C 30 9D E5 00 00 50 E3 09 10 A0 E1 09 00 A0 E1 03 B0 A0 E1 01 B0 A0 13 ?? ?? ?? ?? 0B 90 A0 E1 00 00 50 E3 00 90 A0 13 01 90 09 02 00 00 59 E3 2C 00 00 1A 0A 10 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 ?? ?? ?? ?? 0A 10 A0 E1 00 00 50 E3 0A 00 A0 E1 01 90 A0 13 ?? ?? ?? ?? 00 00 50 E3 00 A0 A0 13 01 A0 09 02 00 00 5A E3 1D 00 00 1A 08 10 9D E5 01 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 08 00 9D E5 01 A0 A0 13 00 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 00 A0 A0 13 01 A0 0A 02 00 00 5A E3 0E 00 00 1A 04 10 9D E5 01 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 04 00 9D E5 01 A0 A0 13 00 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 00 00 A0 13 01 00 0A 02 00 00 50 E3 41 FF FF 0A 08 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 02 00 00 0A 00 00 58 E3 00 80 A0 E3 02 81 A0 B3 06 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 02 00 00 0A 00 00 56 E3 00 60 A0 E3 02 61 A0 B3 04 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 02 00 00 0A 00 00 54 E3 00 40 A0 E3 02 41 A0 B3 07 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 85 FF FF 0A 00 00 57 E3 00 70 A0 E3 02 71 A0 B3 81 FF FF EA 00 00 54 E3 07 10 A0 E1 07 00 A0 E1 FE 45 A0 E3 00 41 9F B5 ?? ?? ?? ?? 00 10 A0 E1 ?? ?? ?? ?? 07 10 A0 E1 00 00 50 E3 07 00 A0 E1 00 50 A0 E3 01 50 A0 13 ?? ?? ?? ?? 00 00 50 E3 00 00 A0 13 01 00 05 02 00 00 50 E3 00 30 A0 03 5A FF FF 0A 58 FF FF EA 00 00 58 E3 00 80 A0 E3 02 81 A0 B3 FE 35 A0 E3 02 31 C3 E3 02 61 06 E2 04 00 A0 E1 04 10 A0 E1 06 60 83 E1 ?? ?? ?? ?? 00 00 50 E3 02 00 00 0A 00 00 54 E3 00 40 A0 E3 02 41 A0 B3 07 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 02 00 00 0A 00 00 57 E3 00 70 A0 E3 02 71 A0 B3 01 30 A0 E3 0C 30 8D E5 1B FF FF EA 00 00 58 E3 06 10 A0 E1 06 00 A0 E1 FE 85 A0 E3 44 80 9F B5 ?? ?? ?? ?? 00 10 A0 E1 ?? ?? ?? ?? 06 10 A0 E1 00 00 50 E3 06 00 A0 E1 00 B0 A0 E3 01 B0 A0 13 ?? ?? ?? ?? 0B 30 A0 E1 00 00 50 E3 00 30 A0 13 01 30 03 02 00 00 53 E3 00 30 A0 03 D4 FF FF 0A D2 FF FF EA 00 00 80 7F 00 00 80 BF }
	condition:
		$1
}

rule file_85_0_0 {
	meta:
		name = "__absvdi2"
		size = 52
		refs = "0030 abort"
	strings:
		$1 = { 00 00 51 E3 10 40 2D E9 00 30 A0 A1 01 40 A0 A1 02 00 00 BA 04 10 A0 E1 03 00 A0 E1 10 80 BD E8 00 30 70 E2 00 40 E1 E2 00 00 54 E3 F8 FF FF AA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_86_0_0 {
	meta:
		name = "__bswapsi2"
		size = 28
	strings:
		$1 = { 20 3C A0 E1 FF 28 00 E2 00 3C 83 E1 22 34 83 E1 FF 0C 00 E2 00 04 83 E1 0E F0 A0 E1 }
	condition:
		$1
}

rule file_89_0_0 {
	meta:
		name = "__ctzsi2"
		size = 24
		refs = "000c __clzsi2"
	strings:
		$1 = { 00 30 60 E2 04 E0 2D E5 00 00 03 E0 ?? ?? ?? ?? 1F 00 60 E2 04 F0 9D E4 }
	condition:
		$1
}

rule file_90_0_0 {
	meta:
		name = "__cmpdi2"
		size = 44
	strings:
		$1 = { 03 00 51 E1 06 00 00 BA 03 00 00 CA 02 00 50 E1 03 00 00 3A 01 00 A0 93 0E F0 A0 91 02 00 A0 E3 0E F0 A0 E1 00 00 A0 E3 0E F0 A0 E1 }
	condition:
		$1
}

rule file_94_0_0 {
	meta:
		name = "__paritydi2"
		size = 40
	strings:
		$1 = { 00 00 21 E0 20 08 20 E0 20 04 20 E0 10 30 9F E5 20 02 20 E0 0F 00 00 E2 53 00 A0 E1 01 00 00 E2 0E F0 A0 E1 96 69 00 00 }
	condition:
		$1
}

rule file_95_0_0 {
	meta:
		name = "__negvsi2"
		size = 44
		refs = "0028 abort"
	strings:
		$1 = { 00 00 50 E3 00 00 60 E2 04 E0 2D E5 A0 3F A0 B1 02 00 00 BA 00 00 50 E3 00 30 A0 D3 01 30 A0 C3 00 00 53 E3 04 F0 9D 04 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_98_0_0 {
	meta:
		name = "__udivsi3"
		size = 248
		refs = "00ec __div0"
	strings:
		$1 = { 01 20 51 E2 0E F0 A0 01 36 00 00 3A 01 00 50 E1 22 00 00 9A 02 00 11 E1 23 00 00 0A 0E 02 11 E3 81 11 A0 01 08 30 A0 03 01 30 A0 13 01 02 51 E3 00 00 51 31 01 12 A0 31 03 32 A0 31 FA FF FF 3A 02 01 51 E3 00 00 51 31 81 10 A0 31 83 30 A0 31 FA FF FF 3A 00 20 A0 E3 01 00 50 E1 01 00 40 20 03 20 82 21 A1 00 50 E1 A1 00 40 20 A3 20 82 21 21 01 50 E1 21 01 40 20 23 21 82 21 A1 01 50 E1 A1 01 40 20 A3 21 82 21 00 00 50 E3 23 32 B0 11 21 12 A0 11 EF FF FF 1A 02 00 A0 E1 0E F0 A0 E1 01 00 A0 03 00 00 A0 13 0E F0 A0 E1 01 08 51 E3 21 18 A0 21 10 20 A0 23 00 20 A0 33 01 0C 51 E3 21 14 A0 21 08 20 82 22 10 00 51 E3 21 12 A0 21 04 20 82 22 04 00 51 E3 03 20 82 82 A1 20 82 90 30 02 A0 E1 0E F0 A0 E1 08 E0 2D E5 ?? ?? ?? ?? 00 00 A0 E3 08 F0 9D E4 }
	condition:
		$1
}

rule file_98_1_0 {
	meta:
		name = "__aeabi_uidivmod"
		size = 24
		refs = "0004 __udivsi3"
	strings:
		$1 = { 03 40 2D E9 BF FF FF EB 06 40 BD E8 92 00 03 E0 03 10 41 E0 0E F0 A0 E1 }
	condition:
		$1
}

rule file_99_2_0 {
	meta:
		name = "__cmpsf2"
		size = 96
	strings:
		$1 = { 01 C0 A0 E3 04 C0 0D E5 80 20 A0 E1 81 30 A0 E1 42 CC F0 E1 43 CC F0 11 06 00 00 0A A3 C0 92 E1 01 00 30 11 03 00 52 50 C1 0F A0 81 C1 0F E0 31 01 00 80 13 0E F0 A0 E1 42 CC F0 E1 01 00 00 1A 80 C4 B0 E1 03 00 00 1A 43 CC F0 E1 F2 FF FF 1A 81 C4 B0 E1 F0 FF FF 0A 04 00 1D E5 0E F0 A0 E1 }
	condition:
		$1
}

rule file_99_3_0 {
	meta:
		name = "__aeabi_cfrcmple"
		size = 16
	strings:
		$1 = { 00 C0 A0 E1 01 00 A0 E1 0C 10 A0 E1 FF FF FF EA }
	condition:
		$1
}

rule file_99_4_0 {
	meta:
		name = "__aeabi_cfcmpeq"
		size = 20
		refs = "0004 __cmpsf2"
	strings:
		$1 = { 0F 40 2D E9 E1 FF FF EB 00 00 50 E3 00 00 70 43 0F 80 BD E8 }
	condition:
		$1
}

rule file_99_5_0 {
	meta:
		name = "__aeabi_fcmpeq"
		size = 20
		refs = "0004 __aeabi_cfcmple"
	strings:
		$1 = { 08 E0 2D E5 F8 FF FF EB 01 00 A0 03 00 00 A0 13 08 F0 9D E4 }
	condition:
		$1
}

rule file_101_5_0 {
	meta:
		name = "__aeabi_dcmpeq"
		size = 20
		refs = "0004 __aeabi_cdcmple"
	strings:
		$1 = { 08 E0 2D E5 F8 FF FF EB 01 00 A0 03 00 00 A0 13 08 F0 9D E4 }
	condition:
		$1
}

rule file_99_6_0 {
	meta:
		name = "__aeabi_fcmplt"
		size = 20
		refs = "0004 __aeabi_cfcmple"
	strings:
		$1 = { 08 E0 2D E5 F3 FF FF EB 01 00 A0 33 00 00 A0 23 08 F0 9D E4 }
	condition:
		$1
}

rule file_101_6_0 {
	meta:
		name = "__aeabi_dcmplt"
		size = 20
		refs = "0004 __aeabi_cdcmple"
	strings:
		$1 = { 08 E0 2D E5 F3 FF FF EB 01 00 A0 33 00 00 A0 23 08 F0 9D E4 }
	condition:
		$1
}

rule file_99_7_0 {
	meta:
		name = "__aeabi_fcmple"
		size = 20
		refs = "0004 __aeabi_cfcmple"
	strings:
		$1 = { 08 E0 2D E5 EE FF FF EB 01 00 A0 93 00 00 A0 83 08 F0 9D E4 }
	condition:
		$1
}

rule file_101_7_0 {
	meta:
		name = "__aeabi_dcmple"
		size = 20
		refs = "0004 __aeabi_cdcmple"
	strings:
		$1 = { 08 E0 2D E5 EE FF FF EB 01 00 A0 93 00 00 A0 83 08 F0 9D E4 }
	condition:
		$1
}

rule file_99_8_0 {
	meta:
		name = "__aeabi_fcmpge"
		size = 20
		refs = "0004 __aeabi_cfrcmple"
	strings:
		$1 = { 08 E0 2D E5 E5 FF FF EB 01 00 A0 93 00 00 A0 83 08 F0 9D E4 }
	condition:
		$1
}

rule file_99_9_0 {
	meta:
		name = "__aeabi_fcmpgt"
		size = 20
		refs = "0004 __aeabi_cfrcmple"
	strings:
		$1 = { 08 E0 2D E5 E0 FF FF EB 01 00 A0 33 00 00 A0 23 08 F0 9D E4 }
	condition:
		$1
}

rule file_101_2_0 {
	meta:
		name = "__cmpdf2"
		size = 132
	strings:
		$1 = { 01 C0 A0 E3 04 C0 0D E5 81 C0 A0 E1 CC CA F0 E1 83 C0 A0 E1 CC CA F0 11 0D 00 00 0A 81 C0 90 E1 83 C0 92 01 03 00 31 11 02 00 30 01 00 00 A0 03 0E F0 A0 01 00 00 70 E3 03 00 31 E1 03 00 51 51 02 00 50 01 C3 0F A0 21 C3 0F E0 31 01 00 80 E3 0E F0 A0 E1 81 C0 A0 E1 CC CA F0 E1 01 00 00 1A 01 C6 90 E1 04 00 00 1A 83 C0 A0 E1 CC CA F0 E1 E9 FF FF 1A 03 C6 92 E1 E7 FF FF 0A 04 00 1D E5 0E F0 A0 E1 }
	condition:
		$1
}

rule file_101_3_0 {
	meta:
		name = "__aeabi_cdrcmple"
		size = 28
	strings:
		$1 = { 00 C0 A0 E1 02 00 A0 E1 0C 20 A0 E1 01 C0 A0 E1 03 10 A0 E1 0C 30 A0 E1 FF FF FF EA }
	condition:
		$1
}

rule file_101_4_0 {
	meta:
		name = "__aeabi_cdcmpeq"
		size = 20
		refs = "0004 __cmpdf2"
	strings:
		$1 = { 01 40 2D E9 D5 FF FF EB 00 00 50 E3 00 00 70 43 01 80 BD E8 }
	condition:
		$1
}

rule file_101_8_0 {
	meta:
		name = "__aeabi_dcmpge"
		size = 20
		refs = "0004 __aeabi_cdrcmple"
	strings:
		$1 = { 08 E0 2D E5 E2 FF FF EB 01 00 A0 93 00 00 A0 83 08 F0 9D E4 }
	condition:
		$1
}

rule file_101_9_0 {
	meta:
		name = "__aeabi_dcmpgt"
		size = 20
		refs = "0004 __aeabi_cdrcmple"
	strings:
		$1 = { 08 E0 2D E5 DD FF FF EB 01 00 A0 33 00 00 A0 23 08 F0 9D E4 }
	condition:
		$1
}

rule file_104_0_0 {
	meta:
		name = "__divdc3"
		size = 1872
		refs = "0048 __ltdf2 0064 __divdf3 0078 __muldf3 0084 __adddf3 00d8 __subdf3 00fc __nedf2 01e8 __eqdf2"
	strings:
		$1 = { F0 4F 2D E9 2C D0 4D E2 54 60 9D E5 5C 40 9D E5 02 C1 C6 E3 50 70 9D E5 58 50 9D E5 10 C0 8D E5 02 C1 C4 E3 0C 70 8D E5 20 10 8D E9 00 90 A0 E1 01 A0 A0 E1 02 B0 A0 E1 03 80 A0 E1 0C 10 8D E2 03 00 91 E8 0C 00 9D E9 ?? ?? ?? ?? 00 00 50 E3 31 00 00 AA 05 20 A0 E1 04 30 A0 E1 07 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 03 00 8D E9 0C 00 9D E9 07 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 05 20 A0 E1 04 30 A0 E1 ?? ?? ?? ?? 0C 00 9D E9 14 00 8D E5 18 10 8D E5 09 00 A0 E1 0A 10 A0 E1 ?? ?? ?? ?? 0B 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? 14 30 8D E2 0C 00 93 E8 ?? ?? ?? ?? 0C 00 9D E9 0C 00 8D E5 10 10 8D E5 0B 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 09 20 A0 E1 0A 30 A0 E1 ?? ?? ?? ?? 14 30 8D E2 0C 00 93 E8 ?? ?? ?? ?? 03 00 8D E9 0C 10 8D E2 03 00 91 E8 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 2D 00 00 1A 0C 10 8D E2 03 00 91 E8 0C 00 9D E9 2C D0 8D E2 F0 8F BD E8 07 20 A0 E1 06 30 A0 E1 05 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 03 00 8D E9 0C 00 9D E9 05 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 07 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 0C 00 9D E9 14 00 8D E5 18 10 8D E5 0B 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 09 20 A0 E1 0A 30 A0 E1 ?? ?? ?? ?? 14 30 8D E2 0C 00 93 E8 ?? ?? ?? ?? 0C 00 9D E9 0C 00 8D E5 10 10 8D E5 09 00 A0 E1 0A 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 0B 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 14 30 8D E2 0C 00 93 E8 ?? ?? ?? ?? 03 00 8D E9 CA FF FF EA 03 00 9D E9 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 CB FF FF 0A 07 00 A0 E1 06 10 A0 E1 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 20 00 00 1A 05 00 A0 E1 04 10 A0 E1 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 19 00 00 1A 09 00 A0 E1 09 20 A0 E1 0A 10 A0 E1 0A 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 AB 00 00 1A 00 00 56 E3 0C 55 9F E5 0C 55 9F B5 00 40 A0 E3 00 40 A0 B3 09 20 A0 E1 0A 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 04 20 A0 E1 0C 00 8D E5 10 10 8D E5 05 30 A0 E1 0B 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 03 00 8D E9 A3 FF FF EA 09 20 A0 E1 0A 30 A0 E1 09 00 A0 E1 0A 10 A0 E1 ?? ?? ?? ?? 01 30 A0 E1 00 20 A0 E1 1C 00 8D E5 20 10 8D E5 ?? ?? ?? ?? 00 00 50 E3 00 C0 A0 E3 09 00 A0 E1 01 C0 A0 13 09 20 A0 E1 0A 10 A0 E1 0A 30 A0 E1 00 C0 8D E5 ?? ?? ?? ?? 00 C0 9D E5 00 00 50 E3 00 C0 A0 13 01 C0 0C 02 00 00 5C E3 14 C0 8D E5 1A 00 00 1A 0B 20 A0 E1 08 30 A0 E1 0B 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 0B 20 A0 E1 24 00 8D E5 28 10 8D E5 08 30 A0 E1 08 10 A0 E1 0B 00 A0 E1 ?? ?? ?? ?? 01 C0 70 E2 00 C0 A0 33 24 10 8D E2 03 00 91 E8 00 20 A0 E1 01 30 A0 E1 00 C0 8D E5 ?? ?? ?? ?? 14 20 9D E5 00 00 50 E3 00 C0 9D E5 02 30 A0 E1 01 30 A0 13 03 00 1C E1 71 00 00 0A 07 20 A0 E1 06 30 A0 E1 07 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 67 00 00 1A 05 20 A0 E1 04 30 A0 E1 05 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 5D 00 00 1A 14 30 9D E5 02 A1 0A E2 00 00 53 E3 03 90 A0 01 98 C3 9F 15 09 C0 A0 01 0A C0 8C E1 0B 20 A0 E1 08 30 A0 E1 0B 00 A0 E1 08 10 A0 E1 04 C0 8D E5 00 90 A0 13 ?? ?? ?? ?? 01 30 A0 E1 00 20 A0 E1 ?? ?? ?? ?? 0B 20 A0 E1 00 00 50 E3 08 10 A0 E1 08 30 A0 E1 0B 00 A0 E1 00 A0 A0 E3 01 A0 A0 13 ?? ?? ?? ?? 00 00 50 E3 00 A0 A0 13 01 A0 0A 02 00 00 5A E3 34 C3 9F 15 0A C0 A0 01 07 20 A0 E1 06 30 A0 E1 04 10 9D E5 09 00 A0 E1 02 81 08 E2 00 A0 A0 13 08 80 8C E1 ?? ?? ?? ?? 05 20 A0 E1 01 C0 A0 E1 00 B0 A0 E1 04 30 A0 E1 0A 00 A0 E1 08 10 A0 E1 00 C0 8D E5 ?? ?? ?? ?? 00 C0 9D E5 00 20 A0 E1 01 30 A0 E1 0B 00 A0 E1 0C 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E3 C8 32 9F E5 ?? ?? ?? ?? 07 20 A0 E1 0C 00 8D E5 10 10 8D E5 06 30 A0 E1 0A 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 05 20 A0 E1 00 60 A0 E1 01 70 A0 E1 04 30 A0 E1 04 10 9D E5 09 00 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E3 70 32 9F E5 ?? ?? ?? ?? 03 00 8D E9 0A FF FF EA 0B 00 A0 E1 0B 20 A0 E1 08 10 A0 E1 08 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 4C FF FF 0A 09 00 A0 E1 09 20 A0 E1 0A 10 A0 E1 0A 30 A0 E1 ?? ?? ?? ?? 1C 00 8D E5 20 10 8D E5 07 20 A0 E1 07 00 A0 E1 06 30 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 01 30 A0 E1 00 20 A0 E1 ?? ?? ?? ?? 00 00 50 E3 00 C0 A0 E3 07 20 A0 E1 01 C0 A0 13 07 00 A0 E1 06 10 A0 E1 06 30 A0 E1 00 C0 8D E5 ?? ?? ?? ?? 00 C0 9D E5 00 00 50 E3 00 70 A0 13 01 70 0C 02 00 00 57 E3 16 00 00 1A 05 20 A0 E1 04 30 A0 E1 05 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 01 30 A0 E1 00 20 A0 E1 ?? ?? ?? ?? 00 00 50 E3 07 C0 A0 E1 05 00 A0 E1 01 C0 A0 13 05 20 A0 E1 04 10 A0 E1 04 30 A0 E1 00 C0 8D E5 ?? ?? ?? ?? 00 C0 9D E5 00 00 50 E3 00 00 A0 13 01 00 0C 02 00 00 50 E3 CE FE FF 0A 1C 10 8D E2 03 00 91 E8 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 C7 FE FF 1A 0B 20 A0 E1 08 30 A0 E1 0B 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 BD FE FF 1A 00 00 57 E3 30 C1 9F 15 07 C0 A0 01 02 61 06 E2 06 C0 8C E1 05 20 A0 E1 05 00 A0 E1 04 30 A0 E1 04 10 A0 E1 04 C0 8D E5 00 70 A0 13 ?? ?? ?? ?? 01 30 A0 E1 00 20 A0 E1 ?? ?? ?? ?? 05 20 A0 E1 00 00 50 E3 04 10 A0 E1 05 00 A0 E1 04 30 A0 E1 00 60 A0 E3 01 60 A0 13 ?? ?? ?? ?? 00 00 50 E3 00 00 A0 13 01 00 06 02 00 00 50 E3 00 50 A0 01 C4 C0 9F 15 05 C0 A0 01 07 20 A0 E1 04 30 9D E5 09 00 A0 E1 0A 10 A0 E1 02 41 04 E2 00 50 A0 13 04 40 8C E1 ?? ?? ?? ?? 05 20 A0 E1 0C 00 8D E5 10 10 8D E5 04 30 A0 E1 0B 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 0C 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 07 20 A0 E1 0C 00 8D E5 10 10 8D E5 04 30 9D E5 0B 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 05 20 A0 E1 00 60 A0 E1 01 70 A0 E1 04 30 A0 E1 09 00 A0 E1 0A 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 03 00 8D E9 70 FE FF EA 00 00 F0 7F 00 00 F0 FF 00 00 F0 3F }
	condition:
		$1
}

rule file_105_0_0 {
	meta:
		name = "__unordsf2"
		size = 56
	strings:
		$1 = { 80 20 A0 E1 81 30 A0 E1 42 CC F0 E1 01 00 00 1A 80 C4 B0 E1 05 00 00 1A 43 CC F0 E1 01 00 00 1A 81 C4 B0 E1 01 00 00 1A 00 00 A0 E3 0E F0 A0 E1 01 00 A0 E3 0E F0 A0 E1 }
	condition:
		$1
}

rule file_106_0_0 {
	meta:
		name = "__subvdi3"
		size = 116
		refs = "0070 abort"
	strings:
		$1 = { 00 48 2D E9 01 C0 A0 E1 00 B0 A0 E1 02 B0 5B E0 03 C0 CC E0 00 00 53 E3 0D 00 00 BA 01 00 5C E1 00 30 A0 E3 06 00 00 DA 01 30 A0 E3 FF 30 03 E2 00 00 53 E3 0D 00 00 1A 0C 10 A0 E1 0B 00 A0 E1 00 88 BD E8 F8 FF FF 1A 00 00 5B E1 F6 FF FF 9A F4 FF FF EA 0C 00 51 E1 00 30 A0 E3 F1 FF FF CA F1 FF FF 1A 0B 00 50 E1 EF FF FF 9A ED FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_108_0_0 {
	meta:
		name = "__divdi3"
		size = 1192
		refs = "003c __clzsi2 0064 __umodsi3 0074 __udivsi3"
	strings:
		$1 = { F0 4F 2D E9 00 00 51 E3 0C D0 4D E2 00 60 A0 A3 D9 00 00 BA 00 00 53 E3 D3 00 00 BA 00 80 53 E2 01 A0 A0 E1 02 40 A0 E1 00 50 A0 E1 35 00 00 1A 01 00 52 E1 41 00 00 9A 02 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 20 30 60 12 35 33 A0 11 14 40 A0 11 1A A0 83 11 24 88 A0 E1 15 50 A0 11 08 10 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 08 10 A0 E1 00 B0 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 04 78 A0 E1 27 78 A0 E1 97 00 09 E0 25 38 A0 E1 0B B8 83 E1 0B 00 59 E1 00 A0 A0 E1 05 00 00 9A 04 B0 9B E0 01 A0 40 E2 02 00 00 2A 0B 00 59 E1 01 A0 4A 82 04 B0 8B 80 0B 90 69 E0 08 10 A0 E1 09 00 A0 E1 ?? ?? ?? ?? 08 10 A0 E1 00 B0 A0 E1 09 00 A0 E1 ?? ?? ?? ?? 90 07 07 E0 05 58 A0 E1 25 58 A0 E1 0B 58 85 E1 05 00 57 E1 04 00 00 9A 04 50 95 E0 01 00 40 E2 01 00 00 2A 05 00 57 E1 01 00 40 82 0A A8 80 E1 00 70 A0 E3 03 00 00 EA 01 00 58 E1 44 00 00 9A 00 70 A0 E3 07 A0 A0 E1 00 00 56 E3 0A 30 A0 E1 07 40 A0 E1 01 00 00 0A 00 30 73 E2 00 40 E4 E2 04 10 A0 E1 03 00 A0 E1 0C D0 8D E2 F0 8F BD E8 00 00 52 E3 03 00 00 1A 02 10 A0 E1 01 00 A0 E3 ?? ?? ?? ?? 00 40 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 90 50 E2 88 00 00 1A 04 88 A0 E1 01 00 A0 E3 0A A0 64 E0 28 88 A0 E1 24 78 A0 E1 08 00 8D E5 0A 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 07 10 A0 E1 00 B0 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 98 00 09 E0 25 38 A0 E1 0B B8 83 E1 0B 00 59 E1 00 A0 A0 E1 05 00 00 9A 04 B0 9B E0 01 A0 40 E2 02 00 00 2A 0B 00 59 E1 01 A0 4A 82 04 B0 8B 80 0B 90 69 E0 07 10 A0 E1 09 00 A0 E1 ?? ?? ?? ?? 07 10 A0 E1 00 B0 A0 E1 09 00 A0 E1 ?? ?? ?? ?? 90 08 08 E0 05 58 A0 E1 25 58 A0 E1 0B 58 85 E1 05 00 58 E1 04 00 00 9A 04 50 95 E0 01 00 40 E2 01 00 00 2A 05 00 58 E1 01 00 40 82 0A A8 80 E1 08 70 9D E5 BC FF FF EA 03 00 A0 E1 ?? ?? ?? ?? 00 70 50 E2 8B 00 00 0A 20 90 67 E2 34 29 A0 E1 35 39 A0 E1 18 87 82 E1 3A 99 A0 E1 1A 37 83 E1 28 B8 A0 E1 09 00 A0 E1 0B 10 A0 E1 08 30 8D E5 ?? ?? ?? ?? 0B 10 A0 E1 00 30 A0 E1 09 00 A0 E1 00 30 8D E5 ?? ?? ?? ?? 08 98 A0 E1 29 98 A0 E1 99 00 01 E0 08 E0 9D E5 00 30 9D E5 2E 28 A0 E1 03 38 82 E1 03 00 51 E1 00 A0 A0 E1 14 27 A0 E1 02 00 00 9A 08 30 93 E0 01 A0 40 E2 76 00 00 3A 03 40 61 E0 04 00 A0 E1 0B 10 A0 E1 04 20 8D E5 ?? ?? ?? ?? 0B 10 A0 E1 00 30 A0 E1 04 00 A0 E1 00 30 8D E5 ?? ?? ?? ?? 08 C0 9D E5 90 09 09 E0 0C 18 A0 E1 00 30 9D E5 21 18 A0 E1 03 38 81 E1 03 00 59 E1 04 20 9D E5 02 00 00 9A 08 30 93 E0 01 00 40 E2 5C 00 00 3A 03 30 69 E0 0A A8 80 E1 2A C8 A0 E1 22 18 A0 E1 0C E8 CA E1 01 48 C2 E1 9E 04 00 E0 9C 04 04 E0 91 0E 0E E0 9C 01 01 E0 0E E0 94 E0 01 18 81 22 0E 08 90 E0 2E 18 A1 E0 01 00 53 E1 06 00 00 3A 00 30 A0 13 01 30 A0 03 15 07 50 E1 00 70 A0 93 01 70 03 82 00 00 57 E3 6D FF FF 0A 01 A0 4A E2 00 70 A0 E3 6A FF FF EA 00 20 72 E2 00 30 E3 E2 06 60 E0 E1 27 FF FF EA 00 00 70 E2 00 10 E1 E2 00 60 E0 E3 21 FF FF EA 20 80 69 E2 35 38 A0 E1 14 49 A0 E1 3A 88 A0 E1 1A 39 83 E1 24 78 A0 E1 08 00 A0 E1 07 10 A0 E1 08 30 8D E5 ?? ?? ?? ?? 07 10 A0 E1 00 A0 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 04 88 A0 E1 28 88 A0 E1 98 00 03 E0 08 10 9D E5 00 B0 A0 E1 21 28 A0 E1 0A A8 82 E1 0A 00 53 E1 02 00 00 9A 04 A0 9A E0 01 B0 40 E2 28 00 00 3A 0A A0 63 E0 0A 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 07 10 A0 E1 00 30 A0 E1 0A 00 A0 E1 00 30 8D E5 ?? ?? ?? ?? 08 C0 9D E5 98 00 0A E0 0C 28 A0 E1 00 30 9D E5 22 28 A0 E1 03 38 82 E1 03 00 5A E1 05 00 00 9A 04 30 93 E0 01 00 40 E2 02 00 00 2A 03 00 5A E1 01 00 40 82 04 30 83 80 0B 08 80 E1 15 59 A0 E1 03 A0 6A E0 08 00 8D E5 46 FF FF EA 0A 00 58 E1 05 00 54 21 01 A0 A0 93 28 FF FF 9A 25 FF FF EA 03 00 59 E1 08 30 83 80 01 00 40 82 9E FF FF EA 03 00 51 E1 01 A0 4A 82 08 30 83 80 84 FF FF EA 0A 00 53 E1 01 B0 4B 82 04 A0 8A 80 D2 FF FF EA }
	condition:
		$1
}

rule file_110_0_0 {
	meta:
		name = "__fixdfsi"
		size = 92
	strings:
		$1 = { 81 20 A0 E1 02 26 92 E2 0C 00 00 2A 09 00 00 5A 3E 3E E0 E3 C2 2A 53 E0 0A 00 00 9A 81 35 A0 E1 02 31 83 E3 A0 3A 83 E1 02 01 11 E3 33 02 A0 E1 00 00 60 12 0E F0 A0 E1 00 00 A0 E3 0E F0 A0 E1 01 06 90 E1 02 00 00 1A 02 01 11 E2 02 01 E0 03 0E F0 A0 E1 00 00 A0 E3 0E F0 A0 E1 }
	condition:
		$1
}

rule file_111_0_0 {
	meta:
		name = "__fixunssfsi"
		size = 84
	strings:
		$1 = { 80 20 B0 E1 08 00 00 2A 7F 04 52 E3 06 00 00 3A 9E 30 A0 E3 22 2C 53 E0 05 00 00 4A 00 34 A0 E1 02 31 83 E3 33 02 A0 E1 0E F0 A0 E1 00 00 A0 E3 0E F0 A0 E1 61 00 72 E3 01 00 00 1A 80 24 B0 E1 01 00 00 1A 00 00 E0 E3 0E F0 A0 E1 00 00 A0 E3 0E F0 A0 E1 }
	condition:
		$1
}

rule file_112_0_0 {
	meta:
		name = "__unpack_f"
		size = 192
	strings:
		$1 = { B2 30 D0 E1 03 C0 D0 E5 00 20 90 E5 A3 33 A0 E1 AC C3 A0 E1 FF 04 C2 E3 FF 30 13 E2 04 C0 81 E5 02 05 C0 E3 11 00 00 1A 00 00 50 E3 02 30 A0 03 00 30 81 05 0E F0 A0 01 7D 30 E0 E3 08 30 81 E5 03 30 A0 E3 00 30 81 E5 7E 20 E0 E3 80 33 A0 E1 83 30 A0 E1 07 01 73 E3 02 00 A0 E1 01 20 42 E2 FA FF FF 9A 0C 30 81 E5 08 00 81 E5 0E F0 A0 E1 FF 00 53 E3 07 00 00 0A 7F 30 43 E2 80 03 A0 E1 01 01 80 E3 08 30 81 E5 03 30 A0 E3 0C 00 81 E5 00 30 81 E5 0E F0 A0 E1 00 00 50 E3 04 30 A0 03 00 30 81 05 0E F0 A0 01 01 26 12 E2 01 30 A0 13 00 30 81 15 00 20 81 05 0C 00 81 E5 0E F0 A0 E1 }
	condition:
		$1
}

rule file_113_0_0 {
	meta:
		name = "__mulvsi3"
		size = 28
		refs = "0018 abort"
	strings:
		$1 = { 10 40 2D E9 91 30 C4 E0 03 00 A0 E1 C3 3F A0 E1 04 00 53 E1 10 80 BD 08 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_115_0_0 {
	meta:
		name = "__ffssi2"
		size = 32
		refs = "0014 __clzsi2"
	strings:
		$1 = { 00 00 50 E3 04 E0 2D E5 04 F0 9D 04 00 30 60 E2 00 00 03 E0 ?? ?? ?? ?? 20 00 60 E2 04 F0 9D E4 }
	condition:
		$1
}

rule file_116_0_0 {
	meta:
		name = "__ctzdi2"
		size = 44
		refs = "001c __clzsi2"
	strings:
		$1 = { 00 00 50 E3 01 00 A0 01 00 30 60 E2 10 40 2D E9 00 00 03 E0 00 40 A0 13 20 40 A0 03 ?? ?? ?? ?? 1F 00 60 E2 04 00 80 E0 10 80 BD E8 }
	condition:
		$1
}

rule file_117_0_0 {
	meta:
		name = "__negvdi2"
		size = 84
		refs = "0050 abort"
	strings:
		$1 = { 10 40 2D E9 00 30 70 E2 00 40 E1 E2 00 00 51 E3 A4 2F A0 B1 04 00 00 BA 00 00 54 E3 00 20 A0 E3 06 00 00 DA 01 20 A0 E3 FF 20 02 E2 00 00 52 E3 06 00 00 1A 04 10 A0 E1 03 00 A0 E1 10 80 BD E8 F8 FF FF 1A 00 00 53 E3 01 20 A0 13 F5 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_118_3_0 {
	meta:
		name = "__fpcmp_parts_f"
		size = 300
	strings:
		$1 = { 30 40 2D E9 01 40 A0 E1 00 50 A0 E1 F1 FF FF EB 00 00 50 E3 01 00 00 0A 01 00 A0 E3 30 80 BD E8 04 00 A0 E1 EB FF FF EB 00 00 50 E3 F9 FF FF 1A 05 00 A0 E1 EC FF FF EB 00 00 50 E3 03 00 00 0A 04 00 A0 E1 E8 FF FF EB 00 00 50 E3 08 00 00 1A 05 00 A0 E1 E4 FF FF EB 00 00 50 E3 08 00 00 0A 04 30 95 E5 00 00 53 E3 EA FF FF 0A 00 00 E0 E3 30 80 BD E8 04 00 94 E5 04 30 95 E5 00 00 63 E0 30 80 BD E8 04 00 A0 E1 D7 FF FF EB 00 00 50 E3 03 00 00 0A 04 30 94 E5 00 00 53 E3 F2 FF FF 0A DC FF FF EA 05 00 A0 E1 C5 FF FF EB 00 00 50 E3 0A 00 00 1A 04 00 A0 E1 C1 FF FF EB 00 00 50 E3 E6 FF FF 1A 04 30 95 E5 04 20 94 E5 02 00 53 E1 08 00 00 0A 00 00 53 E3 CE FF FF 0A E2 FF FF EA 04 00 A0 E1 B6 FF FF EB 00 00 50 E3 E8 FF FF 0A 00 00 A0 E3 30 80 BD E8 08 10 95 E5 08 20 94 E5 02 00 51 E1 F2 FF FF CA 04 00 00 BA 0C 10 95 E5 0C 20 94 E5 02 00 51 E1 ED FF FF 8A F3 FF FF 2A 00 00 53 E3 D0 FF FF 0A BA FF FF EA }
	condition:
		$1
}

rule file_119_0_0 {
	meta:
		name = "__ffsdi2"
		size = 56
		refs = "002c __clzsi2"
	strings:
		$1 = { 00 00 50 E3 10 40 2D E9 20 40 A0 13 04 00 00 1A 00 00 51 E3 01 00 A0 01 10 80 BD 08 01 00 A0 E1 40 40 A0 E3 00 30 60 E2 00 00 03 E0 ?? ?? ?? ?? 04 00 60 E0 10 80 BD E8 }
	condition:
		$1
}

rule file_120_0_0 {
	meta:
		name = "__fixunsdfdi"
		size = 92
		refs = "0014 __muldf3 0018 __fixunsdfsi 0020 __floatunsidf 0038 __adddf3"
	strings:
		$1 = { 70 40 2D E9 00 20 A0 E3 44 30 9F E5 00 50 A0 E1 01 60 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 00 40 A0 E1 ?? ?? ?? ?? 00 20 A0 E3 28 30 9F E5 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 00 20 A0 E3 00 20 82 E1 04 10 A0 E1 02 00 A0 E1 70 80 BD E8 00 00 F0 3D 00 00 F0 C1 }
	condition:
		$1
}

rule file_121_0_0 {
	meta:
		name = "__unpack_d"
		size = 316
	strings:
		$1 = { 70 00 2D E9 10 D0 4D E2 B8 30 DD E1 09 C0 DD E5 00 50 90 E5 04 20 90 E5 AC C1 A0 E1 3E 0B C3 E3 FF 44 C5 E3 01 C0 0C E2 00 00 50 E3 04 C0 81 E5 02 30 A0 E1 01 60 A0 E1 00 20 8D E5 0F 46 C4 E3 19 00 00 1A 04 20 93 E1 02 30 A0 03 00 30 81 05 12 00 00 0A 04 14 A0 E1 23 1C 81 E1 03 04 A0 E1 C8 30 9F E5 1F 02 71 E3 08 30 86 E5 03 30 A0 E3 00 30 86 E5 07 00 00 8A B4 30 9F E5 00 00 90 E0 01 10 A1 E0 1F 02 71 E3 03 20 A0 E1 01 30 43 E2 F9 FF FF 9A 08 20 86 E5 10 00 86 E5 14 10 86 E5 10 D0 8D E2 70 00 BD E8 0E F0 A0 E1 84 20 9F E5 02 00 50 E1 0E 00 00 0A 04 24 A0 E1 23 2C 82 E1 03 14 A0 E1 01 42 A0 E3 00 30 A0 E3 FF 0F 40 E2 03 10 81 E1 04 20 82 E1 03 00 40 E2 03 30 A0 E3 10 10 86 E5 14 20 86 E5 08 00 86 E5 00 30 86 E5 EA FF FF EA 04 20 93 E1 04 30 A0 03 00 30 81 05 E6 FF FF 0A 00 10 A0 E3 02 27 A0 E3 04 20 02 E0 03 10 01 E0 02 10 91 E1 01 20 A0 13 00 20 86 15 00 10 86 05 10 30 86 E5 14 40 86 E5 DB FF FF EA 02 FC FF FF 01 FC FF FF FF 07 00 00 }
	condition:
		$1
}

rule file_123_3_0 {
	meta:
		name = "__fpcmp_parts_d"
		size = 340
	strings:
		$1 = { 30 40 2D E9 01 40 A0 E1 00 50 A0 E1 F1 FF FF EB 00 00 50 E3 01 00 00 0A 01 00 A0 E3 30 80 BD E8 04 00 A0 E1 EB FF FF EB 00 00 50 E3 F9 FF FF 1A 05 00 A0 E1 EC FF FF EB 00 00 50 E3 03 00 00 0A 04 00 A0 E1 E8 FF FF EB 00 00 50 E3 08 00 00 1A 05 00 A0 E1 E4 FF FF EB 00 00 50 E3 08 00 00 0A 04 30 95 E5 00 00 53 E3 EA FF FF 0A 00 00 E0 E3 30 80 BD E8 04 00 94 E5 04 30 95 E5 00 00 63 E0 30 80 BD E8 04 00 A0 E1 D7 FF FF EB 00 00 50 E3 03 00 00 0A 04 30 94 E5 00 00 53 E3 F2 FF FF 0A DC FF FF EA 05 00 A0 E1 C5 FF FF EB 00 00 50 E3 0A 00 00 1A 04 00 A0 E1 C1 FF FF EB 00 00 50 E3 E6 FF FF 1A 04 30 95 E5 04 20 94 E5 02 00 53 E1 08 00 00 0A 00 00 53 E3 CE FF FF 0A E2 FF FF EA 04 00 A0 E1 B6 FF FF EB 00 00 50 E3 E8 FF FF 0A 00 00 A0 E3 30 80 BD E8 08 10 95 E5 08 20 94 E5 02 00 51 E1 F2 FF FF CA 0B 00 00 BA 14 00 95 E5 14 C0 94 E5 10 20 95 E5 0C 00 50 E1 10 10 94 E5 EB FF FF 8A 07 00 00 0A 00 00 5C E1 02 00 00 8A EE FF FF 1A 02 00 51 E1 EC FF FF 9A 00 00 53 E3 C9 FF FF 0A B3 FF FF EA 01 00 52 E1 F5 FF FF 9A DF FF FF EA }
	condition:
		$1
}

rule file_125_2_0 {
	meta:
		name = "__addsf3"
		size = 444
	strings:
		$1 = { 80 20 B0 E1 81 30 B0 11 03 00 32 11 42 CC F0 11 43 CC F0 11 47 00 00 0A 22 2C A0 E1 23 3C 72 E0 03 20 82 C0 01 10 20 C0 00 00 21 C0 01 10 20 C0 00 30 63 B2 19 00 53 E3 0E F0 A0 81 02 01 10 E3 02 05 80 E3 FF 04 C0 E3 00 00 60 12 02 01 11 E3 02 15 81 E3 FF 14 C1 E3 00 10 61 12 03 00 32 E1 2E 00 00 0A 01 20 42 E2 51 03 90 E0 20 30 63 E2 11 13 A0 E1 02 31 00 E2 01 00 00 5A 00 10 71 E2 00 00 E0 E2 02 05 50 E3 0B 00 00 3A 01 04 50 E3 04 00 00 3A A0 00 B0 E1 61 10 A0 E1 01 20 82 E2 FE 00 52 E3 38 00 00 2A 02 01 51 E3 82 0B A0 E0 01 00 C0 03 03 00 80 E1 0E F0 A0 E1 81 10 B0 E1 00 00 A0 E0 02 05 10 E3 01 20 42 E2 F5 FF FF 1A 20 C6 B0 E1 00 06 A0 01 0C 20 42 02 FF 08 10 E3 00 04 A0 01 08 20 42 02 0F 06 10 E3 00 02 A0 01 04 20 42 02 03 05 10 E3 00 01 A0 01 02 20 42 02 02 05 50 E3 80 00 A0 31 00 20 D2 E2 82 0B 80 A0 00 20 62 B2 03 00 80 A1 30 02 83 B1 0E F0 A0 E1 00 00 32 E3 02 15 21 E2 02 05 20 02 01 20 82 02 01 30 43 12 CA FF FF EA 81 30 A0 E1 42 CC F0 E1 43 CC F0 11 13 00 00 0A 03 00 32 E1 02 00 00 0A 00 00 32 E3 01 00 A0 01 0E F0 A0 E1 01 00 30 E1 00 00 A0 13 0E F0 A0 11 FF 04 12 E3 02 00 00 1A 80 00 B0 E1 02 01 80 23 0E F0 A0 E1 02 24 92 E2 02 05 80 32 0E F0 A0 31 02 31 00 E2 7F 04 83 E3 02 05 80 E3 0E F0 A0 E1 42 2C F0 E1 01 00 A0 11 43 3C F0 01 00 10 A0 11 80 24 B0 E1 81 34 B0 01 01 00 30 01 01 05 80 13 0E F0 A0 E1 }
	condition:
		$1
}

rule file_125_4_0 {
	meta:
		name = "__floatsisf"
		size = 32
	strings:
		$1 = { 02 31 10 E2 00 00 60 42 00 C0 B0 E1 0E F0 A0 01 4B 34 83 E3 00 10 A0 E1 00 00 A0 E3 0F 00 00 EA }
	condition:
		$1
}

rule file_125_5_0 {
	meta:
		name = "__floatundisf"
		size = 16
	strings:
		$1 = { 01 20 90 E1 0E F0 A0 01 00 30 A0 E3 05 00 00 EA }
	condition:
		$1
}

rule file_125_6_0 {
	meta:
		name = "__floatdisf"
		size = 172
	strings:
		$1 = { 01 20 90 E1 0E F0 A0 01 02 31 11 E2 01 00 00 5A 00 00 70 E2 00 10 E1 E2 01 C0 B0 E1 00 C0 A0 01 00 10 A0 01 00 00 A0 03 5B 34 83 E3 01 32 43 02 02 35 43 E2 17 20 A0 E3 01 08 5C E3 2C C8 A0 21 10 20 42 22 01 0C 5C E3 2C C4 A0 21 08 20 42 22 10 00 5C E3 2C C2 A0 21 04 20 42 22 04 00 5C E3 02 20 42 22 AC 20 42 30 AC 21 52 E0 82 3B 43 E0 06 00 00 BA 11 32 83 E0 10 C2 A0 E1 20 20 62 E2 02 01 5C E3 30 02 A3 E0 01 00 C0 03 0E F0 A0 E1 20 20 82 E2 11 C2 A0 E1 20 20 62 E2 8C 00 90 E1 31 02 A3 E0 AC 0F C0 01 0E F0 A0 E1 }
	condition:
		$1
}

rule file_128_0_0 {
	meta:
		name = "__muldi3"
		size = 72
	strings:
		$1 = { 92 01 01 E0 90 13 23 E0 30 00 2D E9 20 18 A0 E1 22 58 A0 E1 01 C8 C0 E1 05 48 C2 E1 9C 04 00 E0 91 04 04 E0 95 0C 0C E0 91 05 05 E0 0C C0 94 E0 01 58 85 22 0C 08 90 E0 2C 58 A5 E0 05 10 83 E0 30 00 BD E8 0E F0 A0 E1 }
	condition:
		$1
}

rule file_129_0_0 {
	meta:
		name = "__truncdfsf2"
		size = 160
	strings:
		$1 = { 81 20 A0 E1 07 32 52 E2 02 C6 53 22 7F C5 7C 22 06 00 00 9A 02 C1 01 E2 80 21 A0 E1 A0 0E 8C E1 02 01 52 E3 03 01 A0 E0 01 00 C0 03 0E F0 A0 E1 01 01 11 E3 0F 00 00 1A 2E 26 93 E2 02 01 01 B2 0E F0 A0 B1 01 16 81 E3 A2 2A A0 E1 18 20 62 E2 20 C0 62 E2 10 3C B0 E1 30 02 A0 E1 01 00 80 13 81 35 A0 E1 A3 35 A0 E1 13 0C 80 E1 33 32 A0 E1 83 30 A0 E1 E6 FF FF EA C2 3A F0 E1 03 00 00 1A 01 36 90 E1 7F 04 A0 13 03 05 80 13 0E F0 A0 11 02 01 01 E2 7F 04 80 E3 02 05 80 E3 0E F0 A0 E1 }
	condition:
		$1
}

rule file_130_0_0 {
	meta:
		name = "__absvsi2"
		size = 28
		refs = "0018 abort"
	strings:
		$1 = { 00 00 50 E3 04 E0 2D E5 04 F0 9D A4 00 00 60 E2 00 00 50 E3 04 F0 9D A4 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_131_0_0 {
	meta:
		name = "__ashldi3"
		size = 28
	strings:
		$1 = { 20 30 52 E2 20 C0 62 E2 11 12 A0 41 10 13 A0 51 30 1C 81 41 10 02 A0 E1 0E F0 A0 E1 }
	condition:
		$1
}

rule file_132_0_0 {
	meta:
		name = "__fixunsdfsi"
		size = 84
	strings:
		$1 = { 81 20 B0 E1 0A 00 00 2A 02 26 92 E2 0A 00 00 2A 07 00 00 5A 3E 3E E0 E3 C2 2A 53 E0 08 00 00 4A 81 35 A0 E1 02 31 83 E3 A0 3A 83 E1 33 02 A0 E1 0E F0 A0 E1 00 00 A0 E3 0E F0 A0 E1 01 06 90 E1 01 00 00 1A 00 00 E0 E3 0E F0 A0 E1 00 00 A0 E3 0E F0 A0 E1 }
	condition:
		$1
}

rule file_1_0_1 {
	meta:
		name = "DllMain"
		size = 32
		refs = "0014 DisableThreadLibraryCalls"
	strings:
		$1 = { 01 00 51 E3 04 E0 2D E5 01 00 00 0A 01 00 A0 E3 04 F0 9D E4 ?? ?? ?? ?? 01 00 A0 E3 04 F0 9D E4 }
	condition:
		$1
}

rule file_4_0_1 {
	meta:
		name = "mb_wcsdup"
		size = 48
		refs = "0008 strlen 0014 malloc 0024 mbstowcs"
	strings:
		$1 = { 70 40 2D E9 00 60 A0 E1 ?? ?? ?? ?? 01 50 80 E2 85 00 A0 E1 ?? ?? ?? ?? 06 10 A0 E1 00 40 A0 E1 05 20 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 70 80 BD E8 }
	condition:
		$1
}

rule file_4_1_1 {
	meta:
		name = "_assert"
		size = 156
		refs = "0024 wcslen 0040 malloc 005c wsprintfW 0064 OutputDebugStringW 0078 MessageBoxW 0080 free 0094 abort 0098 .rdata"
	strings:
		$1 = { 04 D0 4D E2 01 40 A0 E1 02 80 A0 E1 EF FF FF EB 00 60 A0 E1 04 00 A0 E1 EC FF FF EB 00 50 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 00 84 E0 29 00 80 E2 80 00 A0 E1 ?? ?? ?? ?? 4C 70 9F E5 00 40 A0 E1 07 10 A0 E1 06 20 A0 E1 05 30 A0 E1 00 80 8D E5 ?? ?? ?? ?? 04 00 A0 E1 ?? ?? ?? ?? 00 00 A0 E3 44 10 87 E2 04 20 A0 E1 00 30 A0 E1 ?? ?? ?? ?? 06 00 A0 E1 ?? ?? ?? ?? 05 00 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_5_0_1 {
	meta:
		name = "__atexit_first"
		size = 16
		refs = "000c .bss"
	strings:
		$1 = { 04 30 9F E5 00 00 93 E5 0E F0 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_64_5_3 {
	meta:
		name = "_ZSt10unexpectedv"
		size = 16
		refs = "0008 _ZN10__cxxabiv112__unexpectedEPFvvE 000c _ZN10__cxxabiv120__unexpected_handlerE"
	strings:
		$1 = { 04 30 9F E5 00 00 93 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_64_3_3 {
	meta:
		name = "_ZSt9terminatev"
		size = 16
		refs = "0008 _ZN10__cxxabiv111__terminateEPFvvE 000c _ZN10__cxxabiv119__terminate_handlerE"
	strings:
		$1 = { 04 30 9F E5 00 00 93 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_5_2_1 {
	meta:
		name = "_exit"
		size = 28
		refs = "0008 _fcloseall 0014 TerminateProcess"
	strings:
		$1 = { 04 D0 4D E2 00 00 8D E5 ?? ?? ?? ?? 00 10 9D E5 42 00 A0 E3 ?? ?? ?? ?? FE FF FF EA }
	condition:
		$1
}

rule file_5_8_1 {
	meta:
		name = "exit"
		size = 28
		refs = "0008 _cexit 0014 TerminateProcess"
	strings:
		$1 = { 04 D0 4D E2 00 00 8D E5 F8 FF FF EB 00 10 9D E5 42 00 A0 E3 ?? ?? ?? ?? FE FF FF EA }
	condition:
		$1
}

rule file_5_3_1 {
	meta:
		name = "__dllonexit"
		size = 132
		refs = "0060 realloc"
	strings:
		$1 = { F0 40 2D E9 00 50 51 E2 04 D0 4D E2 00 40 A0 E1 03 00 00 1A 00 40 A0 E3 04 00 A0 E1 04 D0 8D E2 F0 80 BD E8 00 00 95 E5 00 00 50 E3 00 00 52 13 F7 FF FF 0A 00 30 92 E5 00 00 53 E3 F4 FF FF 0A 03 30 60 E0 43 61 A0 E1 01 70 86 E2 00 00 57 E3 EF FF FF DA 07 71 A0 E1 07 10 A0 E1 00 20 8D E5 ?? ?? ?? ?? 00 00 50 E3 00 20 9D E5 E8 FF FF 0A 07 70 80 E0 00 00 85 E5 06 41 80 E7 00 70 82 E5 E4 FF FF EA }
	condition:
		$1
}

rule file_5_4_1 {
	meta:
		name = "_onexit"
		size = 20
		refs = "0008 __dllonexit 000c .bss"
	strings:
		$1 = { 04 10 9F E5 04 20 9F E5 DB FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_5_5_1 {
	meta:
		name = "atexit"
		size = 40
		refs = "000c __dllonexit 0020 .bss"
	strings:
		$1 = { 04 E0 2D E5 14 10 9F E5 14 20 9F E5 D5 FF FF EB 00 00 50 E3 00 00 E0 03 00 00 A0 13 04 F0 9D E4 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_5_6_1 {
	meta:
		name = "__dll_exit"
		size = 108
		refs = "004c free 0060 fflush 0064 .bss"
	strings:
		$1 = { 30 40 2D E9 58 40 9F E5 00 00 94 E5 00 00 50 E3 10 00 00 0A 4C 30 9F E5 00 50 93 E5 04 30 45 E2 03 00 50 E1 08 00 00 8A 08 50 45 E2 04 30 95 E5 00 00 53 E3 0F E0 A0 11 03 F0 A0 11 00 00 94 E5 00 00 55 E1 04 50 45 E2 F7 FF FF 2A ?? ?? ?? ?? 00 30 A0 E3 00 30 84 E5 00 00 A0 E3 30 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_5_7_1 {
	meta:
		name = "_cexit"
		size = 16
		refs = "0004 __dll_exit 000c _fcloseall"
	strings:
		$1 = { 04 E0 2D E5 E2 FF FF EB 04 E0 9D E4 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_15_0_2 {
	meta:
		name = "__ieee754_gamma_r"
		size = 16
		refs = "0004 __ieee754_lgamma_r 000c exp"
	strings:
		$1 = { 04 E0 2D E5 ?? ?? ?? ?? 04 E0 9D E4 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_32_0_2 {
	meta:
		name = "__ieee754_gammaf_r"
		size = 16
		refs = "0004 __ieee754_lgammaf_r 000c __ieee754_expf"
	strings:
		$1 = { 04 E0 2D E5 ?? ?? ?? ?? 04 E0 9D E4 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_75_0_2 {
	meta:
		name = "log2f"
		size = 40
		refs = "0004 logf 0008 __extendsfdf2 0014 __divdf3 0018 __truncdfsf2"
	strings:
		$1 = { 04 E0 2D E5 ?? ?? ?? ?? ?? ?? ?? ?? 0C 20 9F E5 0C 30 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? 04 F0 9D E4 FE 82 2B 65 47 15 F7 3F }
	condition:
		$1
}

rule file_5_9_1 {
	meta:
		name = "__atexit_init"
		size = 60
		refs = "0008 malloc 0034 .bss"
	strings:
		$1 = { 04 E0 2D E5 80 00 A0 E3 ?? ?? ?? ?? 20 30 9F E5 00 00 50 E3 00 00 83 E5 04 F0 9D 04 14 30 9F E5 00 00 83 E5 00 30 A0 E3 00 30 80 E5 01 00 A0 E3 04 F0 9D E4 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_7_1_1 {
	meta:
		name = "WinMain"
		size = 48
		refs = "0024 main 0028 __argc 002c __argv"
	strings:
		$1 = { 02 00 A0 E1 04 E0 2D E5 66 FF FF EB 14 30 9F E5 00 20 A0 E3 00 00 93 E5 0C 30 9F E5 00 10 93 E5 04 E0 9D E4 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_0_1 {
	meta:
		name = "abort"
		size = 16
		refs = "0008 TerminateProcess"
	strings:
		$1 = { 42 00 A0 E3 00 10 A0 E3 ?? ?? ?? ?? FE FF FF EA }
	condition:
		$1
}

rule file_10_0_1 {
	meta:
		name = "__mingw_do_global_dtors"
		size = 64
		refs = "003c .data"
	strings:
		$1 = { 10 40 2D E9 30 40 9F E5 00 30 94 E5 00 30 93 E5 00 00 53 E3 10 80 BD 08 0F E0 A0 E1 03 F0 A0 E1 00 20 94 E5 04 30 92 E5 04 20 82 E2 00 00 53 E3 00 20 84 E5 F7 FF FF 1A 10 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_0_1 {
	meta:
		name = "_pei386_runtime_relocator"
		size = 72
		refs = "003c __RUNTIME_PSEUDO_RELOC_LIST__ 0040 __RUNTIME_PSEUDO_RELOC_LIST_END__ 0044 __image_base__"
	strings:
		$1 = { 04 40 2D E5 30 30 9F E5 30 40 9F E5 04 00 53 E1 07 00 00 2A 28 10 9F E5 04 20 93 E5 08 00 93 E4 02 C0 91 E7 04 00 53 E1 00 00 8C E0 02 00 81 E7 F8 FF FF 3A 10 00 BD E8 0E F0 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_0_0_2 {
	meta:
		name = "__ieee754_sinhf"
		size = 412
		refs = "003c __addsf3 0044 __gtsf2 0054 expm1f 0074 __mulsf3 0090 __divsf3 009c __subsf3 0100 __ieee754_expf"
	strings:
		$1 = { 80 21 9F E5 F0 40 2D E9 02 61 C0 E3 02 00 56 E1 00 40 A0 E1 31 00 00 CA 6C 31 9F E5 00 00 50 E3 BF 54 A0 B3 3F 54 A0 A3 03 00 56 E1 20 00 00 CA C6 05 56 E3 3B 00 00 AA 50 11 9F E5 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 00 00 50 E3 16 00 00 CA 02 01 C4 E3 ?? ?? ?? ?? 00 40 A0 E1 04 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 00 60 A0 E1 04 00 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 00 70 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 04 00 A0 E1 F0 80 BD E8 D8 30 9F E5 03 00 56 E1 2B 00 00 DA D0 30 9F E5 03 00 56 E1 09 00 00 DA BC 10 9F E5 ?? ?? ?? ?? 00 40 A0 E1 04 00 A0 E1 F0 80 BD E8 00 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 04 00 A0 E1 F0 80 BD E8 3F 14 A0 E3 02 01 C0 E3 ?? ?? ?? ?? ?? ?? ?? ?? 00 40 A0 E1 04 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 E0 FF FF EA 02 01 C0 E3 ?? ?? ?? ?? FE 05 56 E3 00 40 A0 E1 C7 FF FF BA FE 15 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 04 00 A0 E1 F0 80 BD E8 02 01 C0 E3 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 C8 FF FF EA FF FF 7F 7F FF FF AF 41 C2 BD F0 7C 7F 71 B1 42 FC D4 B2 42 }
	condition:
		$1
}

rule file_1_0_2 {
	meta:
		name = "rename"
		size = 96
		refs = "0020 mbstowcs 003c MoveFileW"
	strings:
		$1 = { 70 40 2D E9 41 DE 4D E2 08 D0 4D E2 83 5F 8D E2 01 60 A0 E1 41 2F A0 E3 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 06 10 A0 E1 41 2F A0 E3 0D 00 A0 E1 ?? ?? ?? ?? 05 00 A0 E1 0D 10 A0 E1 ?? ?? ?? ?? 08 40 8D E2 00 00 50 E3 08 40 44 E2 00 00 E0 03 00 00 A0 13 18 D0 8D E2 01 DB 8D E2 70 80 BD E8 }
	condition:
		$1
}

rule file_2_0_2 {
	meta:
		name = "towctrans"
		size = 40
		refs = "0020 towlower 0024 towupper"
	strings:
		$1 = { 01 18 A0 E1 21 18 A0 E1 00 08 A0 E1 01 00 51 E3 20 08 A0 E1 02 00 00 0A 02 00 51 E3 0E F0 A0 11 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_2_1_2 {
	meta:
		name = "wctrans"
		size = 72
		refs = "0010 strcmp 0044 .rdata"
	strings:
		$1 = { 30 40 2D E9 38 40 9F E5 00 50 A0 E1 00 10 94 E5 ?? ?? ?? ?? 00 00 50 E3 06 00 00 0A 05 00 A0 E1 08 10 94 E5 ?? ?? ?? ?? 00 00 50 E3 00 00 A0 13 30 80 BD 18 01 00 A0 E3 80 01 84 E0 B4 00 D0 E1 30 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_5_0_2 {
	meta:
		name = "wmemset"
		size = 48
	strings:
		$1 = { 01 18 A0 E1 00 00 50 E3 21 18 A0 E1 0E F0 A0 01 00 00 52 E3 0E F0 A0 01 00 30 A0 E3 01 20 52 E2 B3 10 80 E1 02 30 83 E2 FB FF FF 1A 0E F0 A0 E1 }
	condition:
		$1
}

rule file_6_0_2 {
	meta:
		name = "__ieee754_powf"
		size = 2524
		refs = "00c0 __mulsf3 00d8 __addsf3 00f4 __divsf3 01ac sqrtf 01c8 __subsf3 04c0 __floatsisf 0880 __gesf2 08d4 __gtsf2 0940 scalbnf 0954 .data 0964 .rdata"
	strings:
		$1 = { F0 4F 2D E9 02 31 D1 E3 01 40 A0 E1 01 50 A0 E1 1C D0 4D E2 00 10 A0 E1 FE 45 A0 03 29 00 00 0A 24 69 9F E5 02 71 C0 E3 06 00 57 E1 06 00 53 D1 00 80 A0 E1 00 60 A0 D3 01 60 A0 C3 24 00 00 CA 00 00 50 E3 39 00 00 BA FC 28 9F E5 02 00 53 E1 30 00 00 0A FE 05 53 E3 21 00 00 0A 01 01 55 E3 52 00 00 0A 3F 04 55 E3 4A 00 00 0A D8 28 9F E5 02 01 C1 E3 02 00 57 E1 00 00 57 13 1F 00 00 0A FE 05 57 E3 1D 00 00 0A A8 8F A0 E1 01 80 48 E2 08 20 96 E1 49 00 00 0A 4D 04 53 E3 57 00 00 DA A8 38 9F E5 03 00 57 E1 B3 01 00 CA 00 00 55 E3 B6 01 00 BA 98 38 9F E5 04 00 93 E5 04 10 93 E5 ?? ?? ?? ?? 00 40 A0 E1 04 00 A0 E1 1C D0 8D E2 F0 8F BD E8 04 00 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 F8 FF FF EA 00 00 55 E3 01 40 A0 A1 F5 FF FF AA FE 05 A0 E3 ?? ?? ?? ?? 00 40 A0 E1 F1 FF FF EA 00 00 55 E3 34 00 00 BA 00 00 58 E3 1A 00 00 BA 00 40 A0 E1 EB FF FF EA FE 05 57 E3 32 00 00 0A 11 00 00 DA 00 00 55 E3 00 40 A0 B3 E5 FF FF EA 20 28 9F E5 02 00 53 E1 02 60 A0 C3 C1 FF FF CA FE 05 53 E3 06 00 00 BA C3 2B A0 E1 96 20 62 E2 53 02 A0 E1 10 02 53 E1 01 00 00 02 02 60 60 02 BB FF FF 0A 00 60 A0 E3 B9 FF FF EA 00 00 55 E3 02 41 84 B2 00 40 A0 A3 D2 FF FF EA FE 75 47 E2 07 70 96 E1 0E 00 00 0A 01 00 56 E3 02 41 80 02 00 40 A0 11 CB FF FF EA 00 00 58 E3 B2 FF FF BA 01 00 A0 E1 1C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 01 00 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 C1 FF FF EA 01 00 A0 E1 00 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 BA FF FF EA 00 10 A0 E1 FE 05 A0 E3 ?? ?? ?? ?? C6 FF FF EA 04 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 B1 FF FF EA 02 05 57 E3 7E 10 E0 A3 03 00 00 AA 48 17 9F E5 ?? ?? ?? ?? 96 10 E0 E3 00 70 A0 E1 FF 34 C7 E3 38 27 9F E5 02 35 C3 E3 C7 7B 81 E0 02 00 53 E1 18 70 8D E5 FE 75 83 E3 47 01 00 CA 01 37 A0 E3 00 10 A0 E3 10 30 8D E5 14 10 8D E5 10 C7 9F E5 14 10 9D E5 07 00 A0 E1 01 11 9C E7 00 C0 8D E5 0C 10 8D E5 ?? ?? ?? ?? 07 10 A0 E1 00 B0 A0 E1 0C 00 9D E5 ?? ?? ?? ?? 00 10 A0 E1 FE 05 A0 E3 ?? ?? ?? ?? 00 20 A0 E1 02 10 A0 E1 0B 00 A0 E1 08 20 8D E5 ?? ?? ?? ?? 10 10 9D E5 C7 30 A0 E1 07 90 A0 E1 02 32 83 E3 FF 7E C0 E3 0F 70 C7 E3 01 30 83 E0 00 A0 A0 E1 03 10 A0 E1 07 00 A0 E1 04 30 8D E5 ?? ?? ?? ?? 00 10 A0 E1 0B 00 A0 E1 ?? ?? ?? ?? 04 30 9D E5 00 B0 A0 E1 0C 10 9D E5 03 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 09 00 A0 E1 ?? ?? ?? ?? 07 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 0B 00 A0 E1 ?? ?? ?? ?? 08 20 9D E5 02 10 A0 E1 ?? ?? ?? ?? 0A 10 A0 E1 00 B0 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 00 90 A0 E1 ?? ?? ?? ?? 30 16 9F E5 00 30 A0 E1 09 00 A0 E1 04 30 8D E5 ?? ?? ?? ?? 20 16 9F E5 ?? ?? ?? ?? 09 10 A0 E1 ?? ?? ?? ?? 14 16 9F E5 ?? ?? ?? ?? 09 10 A0 E1 ?? ?? ?? ?? 08 16 9F E5 ?? ?? ?? ?? 09 10 A0 E1 ?? ?? ?? ?? FC 15 9F E5 ?? ?? ?? ?? 09 10 A0 E1 ?? ?? ?? ?? F0 15 9F E5 ?? ?? ?? ?? 04 30 9D E5 00 10 A0 E1 03 00 A0 E1 ?? ?? ?? ?? 07 10 A0 E1 00 90 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 0B 10 A0 E1 ?? ?? ?? ?? 09 10 A0 E1 ?? ?? ?? ?? 07 10 A0 E1 10 00 8D E5 07 00 A0 E1 ?? ?? ?? ?? AC 15 9F E5 04 00 8D E5 ?? ?? ?? ?? 10 10 9D E5 ?? ?? ?? ?? FF 9E C0 E3 0F 90 C9 E3 09 10 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 09 10 A0 E1 00 70 A0 E1 0B 00 A0 E1 ?? ?? ?? ?? 74 15 9F E5 00 B0 A0 E1 09 00 A0 E1 ?? ?? ?? ?? 04 30 9D E5 03 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 10 00 9D E5 ?? ?? ?? ?? 0A 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 0B 00 A0 E1 ?? ?? ?? ?? 00 90 A0 E1 09 10 A0 E1 07 00 A0 E1 ?? ?? ?? ?? FF AE C0 E3 0F A0 CA E3 24 15 9F E5 0A 00 A0 E1 ?? ?? ?? ?? 1C 15 9F E5 10 00 8D E5 0A 00 A0 E1 ?? ?? ?? ?? 07 10 A0 E1 00 B0 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 09 00 A0 E1 ?? ?? ?? ?? 00 C0 9D E5 14 20 9D E5 EC 14 9F E5 02 71 8C E0 ?? ?? ?? ?? 00 10 A0 E1 0B 00 A0 E1 ?? ?? ?? ?? 08 10 97 E5 ?? ?? ?? ?? 00 A0 A0 E1 18 00 9D E5 ?? ?? ?? ?? 10 90 97 E5 00 B0 A0 E1 0A 10 A0 E1 10 00 9D E5 ?? ?? ?? ?? 09 10 A0 E1 ?? ?? ?? ?? 0B 10 A0 E1 ?? ?? ?? ?? FF 7E C0 E3 0F 70 C7 E3 0B 10 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 09 10 A0 E1 ?? ?? ?? ?? 10 10 9D E5 ?? ?? ?? ?? 00 10 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? FF 5E C5 E3 0F 50 C5 E3 01 60 46 E2 08 60 96 E1 05 10 A0 E1 00 A0 A0 E1 04 00 A0 E1 FE 85 A0 13 50 84 9F 05 ?? ?? ?? ?? 07 10 A0 E1 ?? ?? ?? ?? 0A 10 A0 E1 00 60 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 00 60 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 04 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 43 04 50 E3 00 70 A0 E1 00 50 A0 E1 68 00 00 CA C5 00 00 0A F4 33 9F E5 02 71 C0 E3 03 00 57 E1 B8 00 00 CA E8 33 9F E5 03 00 50 E1 AF 00 00 0A 3F 04 57 E3 00 70 A0 D3 07 A0 A0 D1 C7 00 00 CA 04 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? FF 5E C0 E3 0F 50 C5 E3 05 00 A0 E1 B8 13 9F E5 ?? ?? ?? ?? 04 10 A0 E1 00 90 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 98 13 9F E5 ?? ?? ?? ?? 94 13 9F E5 00 40 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 50 A0 E1 05 10 A0 E1 09 00 A0 E1 ?? ?? ?? ?? 09 10 A0 E1 00 40 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 00 60 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 44 13 9F E5 00 50 A0 E1 ?? ?? ?? ?? 3C 13 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 30 13 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 24 13 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 18 13 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 50 A0 E1 05 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 01 11 A0 E3 00 90 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 09 00 A0 E1 ?? ?? ?? ?? 06 10 A0 E1 00 50 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 06 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 FE 05 A0 E3 ?? ?? ?? ?? 07 10 80 E0 C1 3B A0 E1 00 00 53 E3 84 00 00 DA 08 00 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 63 FE FF EA 14 32 9F E5 08 00 A0 E1 00 10 93 E5 00 40 93 E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 5A FE FF EA 58 22 9F E5 02 00 53 E1 0F 00 00 CA 09 27 A0 E3 01 30 A0 E3 10 20 8D E5 14 30 8D E5 B3 FE FF EA 3C 32 9F E5 03 00 57 E1 10 00 00 DA 00 00 55 E3 48 FE FF DA BC 31 9F E5 00 00 93 E5 00 10 93 E5 ?? ?? ?? ?? 00 40 A0 E1 47 FE FF EA 18 10 9D E5 01 27 A0 E3 01 10 81 E2 00 30 A0 E3 18 10 8D E5 02 75 47 E2 10 20 8D E5 14 30 8D E5 9F FE FF EA 01 00 A0 E1 FE 15 A0 E3 ?? ?? ?? ?? E4 11 9F E5 00 70 A0 E1 ?? ?? ?? ?? DC 11 9F E5 00 90 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 07 10 A0 E1 00 A0 A0 E1 07 00 A0 E1 ?? ?? ?? ?? C0 11 9F E5 00 B0 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 58 11 9F E5 ?? ?? ?? ?? 07 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 3F 04 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 0B 00 A0 E1 ?? ?? ?? ?? 8C 11 9F E5 ?? ?? ?? ?? 00 10 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 00 A0 A0 E1 0A 10 A0 E1 09 00 A0 E1 ?? ?? ?? ?? FF 7E C0 E3 0F 70 C7 E3 09 10 A0 E1 07 00 A0 E1 24 FF FF EA 04 10 A0 E1 ?? ?? ?? ?? 06 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 15 00 00 BA C0 30 9F E5 08 00 A0 E1 04 10 93 E5 04 40 93 E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 05 FE FF EA 1C 11 9F E5 06 00 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 00 A0 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 07 70 A0 D1 94 FF FF CA C7 3B A0 E1 7F 30 43 E2 02 25 A0 E3 01 30 83 E2 52 33 85 E0 02 21 C3 E3 FF 14 C3 E3 C2 2B A0 E1 7F 20 42 E2 02 15 C1 E3 17 00 62 E2 02 15 81 E3 51 A0 A0 E1 B8 10 9F E5 00 00 55 E3 04 00 A0 E1 51 12 C3 E1 00 A0 6A B2 ?? ?? ?? ?? 8A 7B A0 E1 00 40 A0 E1 21 FF FF EA 0A 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 76 FF FF EA 00 00 80 7F F7 FF 7F 3F ?? ?? ?? ?? FF FF 7F 4B 00 00 80 4B 71 C4 1C 00 ?? ?? ?? ?? 42 F1 53 3E 55 32 6C 3E 05 A3 8B 3E AB AA AA 3E B7 6D DB 3E 9A 99 19 3F 00 00 40 40 00 38 76 3F A0 C3 9D 36 4F 38 76 3F 00 00 80 BF 00 00 16 43 00 00 16 C3 00 72 31 3F 18 72 31 3F 8C BE BF 35 4C BB 31 33 0E EA DD 35 55 B3 8A 38 61 0B 36 3B AB AA 2A 3E D6 B3 5D 00 07 00 80 3F 00 AA B8 3F 70 A5 EC 36 00 00 80 BE 3B AA B8 BF 3C AA 38 33 FF FF 7F 00 }
	condition:
		$1
}

rule file_7_0_2 {
	meta:
		name = "_conv"
		size = 116
		refs = "0020 _snprintf"
	strings:
		$1 = { 70 40 2D E9 0C D0 4D E2 02 40 A0 E1 03 50 A0 E1 01 20 A0 E1 00 30 A0 E1 0C 10 A0 E3 0D 00 A0 E1 ?? ?? ?? ?? 05 00 54 E1 0D 60 A0 E1 0D 00 00 2A 00 30 DD E5 00 00 53 E3 00 30 C4 E5 09 00 00 0A 02 60 8D E2 04 00 00 EA 01 30 56 E5 01 60 86 E2 00 00 53 E3 00 30 C4 E5 02 00 00 0A 01 40 84 E2 04 00 55 E1 F7 FF FF 8A 04 00 A0 E1 0C D0 8D E2 70 80 BD E8 }
	condition:
		$1
}

rule file_7_1_2 {
	meta:
		name = "_fmt"
		size = 2856
		refs = "00b0 .text 0918 mktime 092c _snprintf 0ad4 .rdata"
	strings:
		$1 = { F0 4F 2D E9 00 C0 D0 E5 58 D0 4D E2 00 00 5C E3 01 80 A0 E1 02 40 A0 E1 03 60 A0 E1 9E 00 00 0A AC 7A 9F E5 AC AA 9F E5 A0 10 97 E5 A8 20 97 E5 A4 30 97 E5 18 10 8D E5 98 10 97 E5 08 20 8D E5 04 30 8D E5 14 10 8D E5 9C 20 97 E5 AC 30 97 E5 48 10 8D E2 02 10 81 E2 10 20 8D E5 0C 30 8D E5 1C 10 8D E5 08 00 00 EA 06 00 54 E1 8A 00 00 0A 00 30 D0 E5 00 50 A0 E1 01 30 C4 E4 01 C0 D5 E5 01 00 85 E2 00 00 5C E3 83 00 00 0A 25 00 5C E3 F4 FF FF 1A 01 30 D0 E5 01 50 80 E2 03 3C A0 E1 43 2C A0 E1 7A 00 52 E3 02 F1 9F 97 90 00 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 04 00 A0 E1 58 D0 8D E2 F0 8F BD E8 7C 00 9D E5 03 30 A0 E3 00 30 80 E5 14 30 98 E5 1C 18 9F E5 76 3E 83 E2 0C 30 83 E2 91 C3 C0 E0 C3 1F A0 E1 C0 12 61 E0 01 11 81 E0 01 11 81 E0 01 01 43 E0 04 20 A0 E1 F8 17 9F E5 06 30 A0 E1 27 FF FF EB 00 40 A0 E1 61 FF FF EA 05 00 A0 E1 5A FF FF EA 0C 00 9D E5 04 20 A0 E1 7C E0 9D E5 08 10 A0 E1 06 30 A0 E1 00 E0 8D E5 39 FF FF EB 00 40 A0 E1 56 FF FF EA 18 30 98 E5 06 00 53 E3 03 31 87 90 B0 27 9F 85 7C 20 93 95 04 00 56 E1 4F FF FF 9A 00 30 D2 E5 00 00 53 E3 00 30 C4 E5 04 00 00 1A 4A FF FF EA 01 30 F2 E5 00 00 53 E3 00 30 C4 E5 46 FF FF 0A 01 40 84 E2 04 00 56 E1 F8 FF FF 8A 42 FF FF EA 10 30 98 E5 0B 00 53 E3 0C 30 83 92 60 27 9F 85 03 21 97 97 04 00 56 E1 3B FF FF 9A 00 30 D2 E5 00 00 53 E3 00 30 C4 E5 04 00 00 1A 36 FF FF EA 01 30 F2 E5 00 00 53 E3 00 30 C4 E5 32 FF FF 0A 01 40 84 E2 04 00 56 E1 F8 FF FF 8A 2E FF FF EA 14 30 98 E5 10 C7 9F E5 76 3E 83 E2 0C 30 83 E2 9C E3 C1 E0 C3 3F A0 E1 C1 02 63 E0 04 20 A0 E1 F8 16 9F E5 06 30 A0 E1 E7 FE FF EB 00 40 A0 E1 21 FF FF EA EC 06 9F E5 04 20 A0 E1 7C C0 9D E5 08 10 A0 E1 06 30 A0 E1 00 C0 8D E5 FB FE FF EB 00 40 A0 E1 18 FF FF EA 05 00 A0 E1 1C FF FF EA 04 20 A0 E1 C0 06 9F E5 B5 FF FF EA 14 00 98 E5 18 20 98 E5 76 0E 80 E2 0C 00 80 E2 0B C0 62 E2 03 20 00 E2 00 00 52 E3 1C 10 98 E5 20 50 8D E5 0C B0 A0 E1 32 00 00 1A 7C 26 9F E5 92 C0 CE E0 C0 CF A0 E1 CE 22 6C E0 02 21 82 E0 02 21 82 E0 02 01 50 E1 04 00 00 1A CE C3 6C E0 0C C1 8C E0 0C C1 8C E0 0C 02 50 E1 25 00 00 1A 5C 56 9F E5 02 90 A0 E3 01 20 8B E0 9A C2 CE E0 C2 CF A0 E1 02 E0 8E E0 4E C1 6C E0 8C C1 6C E0 02 C0 6C E0 03 C0 4C E2 0C 90 69 E0 03 00 79 E3 07 90 89 B2 05 90 89 E0 09 00 51 E1 5E 01 00 AA 0C 00 51 E1 6A 01 00 AA 01 00 40 E2 03 20 10 E2 13 00 00 1A F4 C5 9F E5 9C E0 C5 E0 C0 EF A0 E1 C5 C2 6E E0 0C C1 8C E0 0C C1 8C E0 0C 01 50 E1 04 00 00 1A C5 E3 6E E0 0E E1 8E E0 0E E1 8E E0 0E 02 50 E1 06 00 00 1A D4 C5 9F E5 0C 10 81 E0 00 00 52 E3 CC FF FF 0A C8 55 9F E5 01 90 A0 E3 D8 FF FF EA BC C5 9F E5 0C 10 81 E0 F7 FF FF EA 04 20 A0 E1 08 00 98 E5 94 15 9F E5 06 30 A0 E1 8E FE FF EB 00 40 A0 E1 C8 FE FF EA 08 30 98 E5 94 15 9F E5 04 20 A0 E1 91 C3 C0 E0 C3 1F A0 E1 C0 00 61 E0 80 00 80 E0 00 01 53 E0 0C 00 A0 03 5C 15 9F E5 06 30 A0 E1 80 FE FF EB 00 40 A0 E1 BA FE FF EA 04 20 A0 E1 04 00 98 E5 40 15 9F E5 06 30 A0 E1 79 FE FF EB 00 40 A0 E1 B3 FE FF EA 04 20 A0 E1 44 05 9F E5 52 FF FF EA 04 20 A0 E1 00 00 98 E5 18 15 9F E5 06 30 A0 E1 6F FE FF EB 00 40 A0 E1 A9 FE FF EA 04 20 A0 E1 20 05 9F E5 48 FF FF EA 1C 20 98 E5 18 30 98 E5 07 20 82 E2 02 30 63 E0 9A 03 C1 E0 C3 2F A0 E1 03 30 81 E0 43 01 62 E0 04 20 A0 E1 D4 14 9F E5 06 30 A0 E1 5E FE FF EB 00 40 A0 E1 98 FE FF EA 18 30 98 E5 1C 20 98 E5 00 00 53 E3 06 30 A0 03 01 30 43 12 ED FF FF EA 04 20 A0 E1 14 00 9D E5 6F FF FF EA 14 00 98 E5 04 20 A0 E1 76 0E 80 E2 0C 00 80 E2 B0 14 9F E5 06 30 A0 E1 4C FE FF EB 00 40 A0 E1 86 FE FF EA 20 20 98 E5 00 00 52 E3 83 FE FF BA 60 34 9F E5 04 20 A0 13 02 30 83 E0 04 00 56 E1 24 21 93 E5 7D FE FF 9A 00 30 D2 E5 00 00 53 E3 00 30 C4 E5 04 00 00 1A 78 FE FF EA 01 30 F2 E5 00 00 53 E3 00 30 C4 E5 74 FE FF 0A 01 40 84 E2 04 00 56 E1 F8 FF FF 8A 70 FE FF EA 18 30 98 E5 06 00 53 E3 18 30 83 92 18 24 9F 85 03 21 97 97 04 00 56 E1 69 FE FF 9A 00 30 D2 E5 00 00 53 E3 00 30 C4 E5 04 00 00 1A 64 FE FF EA 01 30 F2 E5 00 00 53 E3 00 30 C4 E5 60 FE FF 0A 01 40 84 E2 04 00 56 E1 F8 FF FF 8A 5C FE FF EA 10 30 98 E5 0B 00 53 E3 CC 23 9F 85 03 21 97 97 04 00 56 E1 56 FE FF 9A 00 30 D2 E5 00 00 53 E3 00 30 C4 E5 04 00 00 1A 51 FE FF EA 01 30 F2 E5 00 00 53 E3 00 30 C4 E5 4D FE FF 0A 01 40 84 E2 04 00 56 E1 F8 FF FF 8A 49 FE FF EA 7C C0 9D E5 04 20 A0 E1 06 30 A0 E1 18 00 9D E5 08 10 A0 E1 00 C0 8D E5 23 FE FF EB 7C E0 9D E5 00 40 A0 E1 00 30 9E E5 00 00 53 E3 01 30 A0 D3 00 30 8E D5 3B FE FF EA 04 20 A0 E1 0C 00 98 E5 44 13 9F E5 06 30 A0 E1 FA FD FF EB 00 40 A0 E1 34 FE FF EA 04 20 A0 E1 0C 00 98 E5 50 13 9F E5 06 30 A0 E1 F3 FD FF EB 00 40 A0 E1 2D FE FF EA 1C 00 98 E5 04 20 A0 E1 01 00 80 E2 34 13 9F E5 06 30 A0 E1 EB FD FF EB 00 40 A0 E1 25 FE FF EA 04 20 A0 E1 08 00 98 E5 14 13 9F E5 06 30 A0 E1 E4 FD FF EB 00 40 A0 E1 1E FE FF EA 08 30 98 E5 EC E2 9F E5 04 20 A0 E1 9E 13 C0 E0 C3 1F A0 E1 C0 00 61 E0 80 00 80 E0 00 01 53 E0 0C 00 A0 03 DC 12 9F E5 06 30 A0 E1 D6 FD FF EB 00 40 A0 E1 10 FE FF EA 10 00 98 E5 04 20 A0 E1 01 00 80 E2 94 12 9F E5 06 30 A0 E1 CE FD FF EB 00 40 A0 E1 08 FE FF EA 04 00 56 E1 06 FE FF 9A 0A 30 A0 E3 00 30 C4 E5 A0 32 9F E5 04 00 00 EA 01 20 53 E5 01 30 83 E2 00 00 52 E3 00 20 C4 E5 FD FD FF 0A 01 40 84 E2 04 00 56 E1 F7 FF FF 8A F9 FD FF EA 08 20 98 E5 08 C0 9D E5 0B 00 52 E3 04 30 9D E5 0C 30 A0 C1 04 00 56 E1 03 20 A0 E1 F1 FD FF 9A 00 30 D3 E5 00 00 53 E3 00 30 C4 E5 04 00 00 1A EC FD FF EA 01 30 F2 E5 00 00 53 E3 00 30 C4 E5 E8 FD FF 0A 01 40 84 E2 04 00 56 E1 F8 FF FF 8A E4 FD FF EA 04 20 A0 E1 20 02 9F E5 C1 FE FF EA 24 E0 8D E2 08 C0 A0 E1 0F 00 BC E8 0F 00 AE E8 0F 00 BC E8 0F 00 AE E8 00 30 9C E5 24 00 8D E2 00 30 8E E5 ?? ?? ?? ?? 0C 10 A0 E3 00 30 A0 E1 EC 21 9F E5 48 00 8D E2 ?? ?? ?? ?? 04 00 56 E1 D0 FD FF 9A 48 30 DD E5 00 00 53 E3 00 30 C4 E5 CC FD FF 0A 1C 30 9D E5 04 00 00 EA 01 20 53 E5 01 30 83 E2 00 00 52 E3 00 20 C4 E5 C5 FD FF 0A 01 40 84 E2 04 00 56 E1 F7 FF FF 8A C1 FD FF EA 04 00 56 E1 BF FD FF 9A 09 30 A0 E3 00 30 C4 E5 90 31 9F E5 04 00 00 EA 01 20 53 E5 01 30 83 E2 00 00 52 E3 00 20 C4 E5 B6 FD FF 0A 01 40 84 E2 04 00 56 E1 F7 FF FF 8A B2 FD FF EA 18 00 98 E5 04 20 A0 E1 00 00 50 E3 07 00 A0 03 58 11 9F E5 06 30 A0 E1 6F FD FF EB 00 40 A0 E1 A9 FD FF EA 04 20 A0 E1 44 01 9F E5 48 FE FF EA 04 20 A0 E1 18 00 98 E5 30 11 9F E5 06 30 A0 E1 65 FD FF EB 00 40 A0 E1 9F FD FF EA 58 C0 8D E2 01 30 A0 E3 04 30 2C E5 04 20 A0 E1 06 30 A0 E1 10 00 9D E5 08 10 A0 E1 00 C0 8D E5 77 FD FF EB 54 30 9D E5 7C E0 9D E5 03 00 53 E3 02 30 A0 03 54 30 8D 05 00 20 9E E5 00 40 A0 E1 02 00 53 E1 00 30 8E C5 8C FD FF EA 20 50 9D E5 01 00 80 E2 01 20 A0 E3 43 3C A0 E1 56 00 53 E3 1A 00 00 0A 67 00 53 E3 0D 00 00 0A 04 20 A0 E1 90 10 9F E5 06 30 A0 E1 44 FD FF EB 00 40 A0 E1 7E FD FF EA 01 10 6C E0 9A E1 CC E0 C1 2F A0 E1 01 10 8C E0 41 21 62 E0 20 50 9D E5 01 20 82 E2 EC FF FF EA 34 10 9F E5 7C C0 9D E5 91 30 C2 E0 C0 3F A0 E1 C2 32 63 E0 03 31 83 E0 03 31 83 E0 03 20 A0 E3 00 20 8C E5 03 01 40 E0 CC FE FF EA 02 00 A0 E1 CA FE FF EA ?? ?? ?? ?? 93 24 49 92 1F 85 EB 51 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 6E 01 00 00 6D 01 00 00 AB AA AA 2A ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_7_2_2 {
	meta:
		name = "strftime"
		size = 100
	strings:
		$1 = { F0 40 2D E9 08 D0 4D E2 01 50 80 E0 00 40 A0 E1 08 C0 8D E2 00 60 A0 E3 04 60 2C E5 02 00 A0 E1 01 70 A0 E1 04 20 A0 E1 03 10 A0 E1 05 30 A0 E1 00 C0 8D E5 27 FD FF EB 00 00 55 E1 00 60 C0 15 00 00 64 10 01 00 00 0A 08 D0 8D E2 F0 80 BD E8 06 00 57 E1 07 00 A0 01 01 60 45 15 06 00 A0 11 F8 FF FF EA }
	condition:
		$1
}

rule file_9_0_2 {
	meta:
		name = "lrintf"
		size = 196
		refs = "0048 __addsf3 0058 __subsf3 00c0 .rdata"
	strings:
		$1 = { 30 40 2D E9 A0 4B A0 E1 FF 30 04 E2 7F 30 43 E2 01 00 73 E3 04 D0 4D E2 00 00 A0 B3 1C 00 00 BA 1E 00 53 E3 44 44 A0 E1 1B 00 00 CA 16 00 53 E3 0B 00 00 CA 84 30 9F E5 00 00 8D E5 04 51 93 E7 00 10 9D E5 05 00 A0 E1 ?? ?? ?? ?? 00 00 8D E5 00 00 9D E5 05 10 A0 E1 ?? ?? ?? ?? 00 00 8D E5 00 00 9D E5 A0 2B A0 E1 FF 20 02 E2 FF 34 C0 E3 02 35 C3 E3 96 20 52 E2 02 35 83 E3 0A 00 00 4A 1F 00 52 E3 13 02 A0 D1 00 00 A0 C3 00 00 54 E3 00 00 60 12 04 D0 8D E2 30 80 BD E8 00 00 54 E3 02 01 A0 13 02 01 E0 03 F9 FF FF EA 1F 00 72 E3 00 20 62 A2 33 02 A0 A1 00 00 A0 B3 F2 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_0_2 {
	meta:
		name = "strtold"
		size = 260
		refs = "0024 __strtodg 0038 .text 0100 .data"
	strings:
		$1 = { 04 E0 2D E5 20 D0 4D E2 00 C0 A0 E3 1C 30 8D E2 14 E0 8D E2 E4 20 9F E5 08 C0 8D E5 00 E0 8D E5 04 C0 8D E5 ?? ?? ?? ?? 07 30 00 E2 06 00 53 E3 03 F1 9F 97 12 00 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 1C 30 9D E5 01 39 83 E2 3E 30 83 E2 BC 30 CD E1 14 20 9D E5 18 30 9D E5 22 C8 A0 E1 23 18 A0 E1 B6 C0 CD E1 BA 10 CD E1 B4 20 CD E1 B8 30 CD E1 03 00 9D E9 20 D0 8D E2 00 80 BD E8 03 39 A0 E3 BA 30 CD E1 00 30 A0 E3 B4 30 CD E1 B6 30 CD E1 B8 30 CD E1 00 30 E0 E3 BC 30 CD E1 F3 FF FF EA 00 30 A0 E3 BC 30 CD E1 BA 30 CD E1 B8 30 CD E1 B6 30 CD E1 B4 30 CD E1 EC FF FF EA 00 30 A0 E3 BC 30 CD E1 E1 FF FF EA 02 39 E0 E3 BC 30 CD E1 02 39 A0 E3 BA 30 CD E1 00 30 A0 E3 B4 30 CD E1 B6 30 CD E1 B8 30 CD E1 E0 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_11_0_2 {
	meta:
		name = "gmtime"
		size = 72
		refs = "0018 __time_t_to_FILETIME 0024 FileTimeToSystemTime 0030 __SYSTEMTIME_to_tm 0044 .bss"
	strings:
		$1 = { 70 40 2D E9 18 D0 4D E2 10 60 8D E2 06 10 A0 E1 2C 40 9F E5 00 00 90 E5 ?? ?? ?? ?? 0D 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 0D 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 0D 50 A0 E1 04 00 A0 E1 18 D0 8D E2 70 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_0_2 {
	meta:
		name = "rmdir"
		size = 80
		refs = "0018 mbstowcs 0020 RemoveDirectoryW 0040 SetLastError"
	strings:
		$1 = { 10 40 2D E9 00 10 50 E2 83 DF 4D E2 0A 00 00 0A 41 2F A0 E3 0D 00 A0 E1 ?? ?? ?? ?? 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 0D 40 A0 E1 00 00 E0 03 00 00 A0 13 83 DF 8D E2 10 80 BD E8 08 00 9F E5 ?? ?? ?? ?? 00 00 E0 E3 F9 FF FF EA E7 01 00 00 }
	condition:
		$1
}

rule file_13_0_2 {
	meta:
		name = "__g__fmt"
		size = 620
		refs = "00d8 __freedtoa 019c __divsi3"
	strings:
		$1 = { F0 45 2D E9 02 20 61 E0 20 A0 9D E5 01 40 A0 E1 06 10 82 E2 0A 00 51 E1 72 00 00 8A 1C 10 9D E5 01 A0 4A E2 00 00 51 E3 2D 10 A0 13 0A A0 80 E0 01 10 C0 14 03 00 73 E3 29 00 00 BA 05 10 82 E2 01 00 53 E1 26 00 00 CA 00 00 53 E3 6A 00 00 DA 00 20 D4 E5 00 50 A0 E1 00 00 52 E3 04 10 A0 E1 2E C0 A0 E3 00 20 C5 E5 0C 00 00 0A 01 30 53 E2 01 50 85 E2 04 00 00 1A D1 00 D1 E1 03 20 A0 E1 00 00 50 E3 01 00 00 0A 01 C0 C5 E4 01 20 D1 E5 00 00 52 E3 01 10 81 E2 00 20 C5 E5 F2 FF FF 1A 03 10 85 E0 01 00 5A E1 4E 00 00 3A 00 00 53 E3 05 00 00 DA 30 10 A0 E3 02 10 C5 E7 01 20 82 E2 03 00 52 E1 FB FF FF 1A 02 50 85 E0 00 30 A0 E3 04 00 A0 E1 00 30 C5 E5 ?? ?? ?? ?? 05 00 A0 E1 F0 85 BD E8 00 10 D4 E5 00 20 A0 E1 01 10 C2 E4 D1 10 D4 E1 00 00 51 E3 0B 00 00 0A 2E 10 A0 E3 01 10 C0 E5 01 10 D4 E5 00 00 51 E3 01 10 E2 E5 05 00 00 0A 04 10 A0 E1 02 00 D1 E5 01 10 81 E2 00 00 50 E3 01 00 E2 E5 FA FF FF 1A 01 70 53 E2 02 50 A0 E1 65 30 A0 E3 01 30 C5 E4 00 70 67 42 2D 30 A0 43 2B 30 A0 53 01 30 C2 45 01 50 85 42 01 30 C2 55 01 50 85 52 63 00 57 E3 0A 60 A0 D3 02 80 A0 D3 08 00 00 DA 64 60 A0 E3 02 80 A0 E3 00 00 00 EA 03 60 A0 E1 06 31 86 E0 83 30 A0 E1 03 00 57 E1 01 80 88 E2 F9 FF FF AA 0A 00 55 E1 14 00 00 2A 07 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 30 30 80 E2 01 30 C5 E4 01 80 48 E2 09 00 00 EA 96 00 00 E0 07 70 60 E0 07 71 87 E0 87 70 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 00 00 58 E3 30 30 80 E2 01 30 C5 E4 BC FF FF DA 05 00 5A E1 06 10 A0 E1 01 80 48 E2 F1 FF FF 8A 00 50 A0 E3 04 00 A0 E1 ?? ?? ?? ?? 05 00 A0 E1 F0 85 BD E8 00 50 A0 E1 2E 10 A0 E3 01 10 C5 E4 02 20 63 E0 02 20 85 E0 02 00 5A E1 F3 FF FF 3A 00 00 53 E3 08 00 00 0A 00 10 63 E2 01 00 80 E0 01 30 83 E2 30 20 A0 E3 03 20 C0 E7 01 30 83 E2 01 00 53 E3 FB FF FF 1A 01 50 85 E0 00 30 D4 E5 00 00 53 E3 00 30 C5 E5 E5 FF FF 0A 04 20 A0 E1 01 30 F2 E5 00 00 53 E3 01 30 E5 E5 FB FF FF 1A DF FF FF EA }
	condition:
		$1
}

rule file_14_0_2 {
	meta:
		name = "round"
		size = 280
		refs = "000c __fpclassify 0020 _isnan 003c __gedf2 0050 floor 0064 __adddf3 0070 __ledf2 00c8 __subdf3"
	strings:
		$1 = { F0 40 2D E9 00 50 A0 E1 01 40 A0 E1 ?? ?? ?? ?? 05 0C 50 E3 21 00 00 0A 05 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 1C 00 00 1A 05 00 A0 E1 04 10 A0 E1 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 18 00 00 AA 05 00 A0 E1 02 11 84 E2 ?? ?? ?? ?? 05 20 A0 E1 04 30 A0 E1 00 70 A0 E1 01 60 A0 E1 ?? ?? ?? ?? 00 20 A0 E3 9C 30 9F E5 ?? ?? ?? ?? 00 00 50 E3 06 00 00 CA 07 00 A0 E1 06 10 A0 E1 00 20 A0 E3 84 30 9F E5 ?? ?? ?? ?? 00 70 A0 E1 01 60 A0 E1 07 50 A0 E1 02 41 86 E2 05 00 A0 E1 04 10 A0 E1 F0 80 BD E8 05 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 05 20 A0 E1 04 30 A0 E1 00 70 A0 E1 01 60 A0 E1 ?? ?? ?? ?? 00 20 A0 E3 38 30 9F E5 ?? ?? ?? ?? 00 00 50 E3 07 50 A0 C1 06 40 A0 C1 ED FF FF CA 07 00 A0 E1 06 10 A0 E1 00 20 A0 E3 18 30 9F E5 ?? ?? ?? ?? 00 50 A0 E1 01 40 A0 E1 05 00 A0 E1 04 10 A0 E1 F0 80 BD E8 00 00 E0 BF 00 00 F0 3F }
	condition:
		$1
}

rule file_16_0_2 {
	meta:
		name = "tfind"
		size = 88
	strings:
		$1 = { 70 40 2D E9 00 40 51 E2 00 50 A0 E1 02 60 A0 E1 05 00 00 1A 00 00 A0 E3 70 80 BD E8 00 40 94 B5 00 40 94 A5 04 40 84 B2 08 40 84 A2 00 30 94 E5 05 00 A0 E1 00 00 53 E3 F5 FF FF 0A 00 10 93 E5 0F E0 A0 E1 06 F0 A0 E1 00 00 50 E3 F2 FF FF 1A 00 00 94 E5 70 80 BD E8 }
	condition:
		$1
}

rule file_19_0_2 {
	meta:
		name = "__cmp_D2A"
		size = 104
	strings:
		$1 = { 00 30 A0 E1 10 20 91 E5 10 00 90 E5 04 40 2D E5 02 00 50 E0 0E 00 00 1A 04 20 82 E2 02 21 A0 E1 02 10 81 E0 02 20 83 E0 04 20 82 E2 04 10 81 E2 14 30 83 E2 04 40 12 E5 04 C0 11 E5 04 20 42 E2 0C 00 54 E1 04 00 00 1A 02 00 53 E1 04 10 41 E2 F7 FF FF 3A 10 00 BD E8 0E F0 A0 E1 01 00 A0 23 00 00 E0 33 FA FF FF EA }
	condition:
		$1
}

rule file_19_1_2 {
	meta:
		name = "__strcp_D2A"
		size = 36
	strings:
		$1 = { 00 30 D1 E5 00 00 53 E3 00 30 C0 E5 0E F0 A0 01 01 30 F1 E5 00 00 53 E3 01 30 E0 E5 FB FF FF 1A 0E F0 A0 E1 }
	condition:
		$1
}

rule file_19_2_2 {
	meta:
		name = "__b2d_D2A"
		size = 208
		refs = "0024 __clzsi2"
	strings:
		$1 = { F0 40 2D E9 10 40 90 E5 00 30 A0 E1 04 40 84 E2 04 51 90 E7 04 41 80 E0 05 00 A0 E1 01 70 A0 E1 14 60 83 E2 ?? ?? ?? ?? 20 30 60 E2 0A 00 50 E3 00 30 87 E5 0C 00 00 CA 04 00 56 E1 04 20 14 35 0B 30 60 E2 32 23 A0 31 35 13 A0 E1 00 20 A0 23 15 00 80 E2 15 30 82 E1 FF 45 81 E3 03 46 84 E3 03 00 A0 E1 04 10 A0 E1 F0 80 BD E8 04 00 56 E1 04 20 14 35 00 20 A0 23 04 40 44 32 0B 00 50 E2 0C 00 00 0A 06 00 54 E1 04 C0 14 85 15 50 A0 E1 20 10 60 E2 3C C1 A0 81 FF 55 85 E3 00 C0 A0 93 03 56 85 E3 32 41 85 E1 12 30 8C E1 04 10 A0 E1 03 00 A0 E1 F0 80 BD E8 FF 45 85 E3 03 46 84 E3 02 30 A0 E1 03 00 A0 E1 04 10 A0 E1 F0 80 BD E8 }
	condition:
		$1
}

rule file_19_3_2 {
	meta:
		name = "dtoa_lock"
		size = 200
		refs = "002c Sleep 0054 InterlockedExchange 0068 InitializeCriticalSection 0078 atexit 0090 EnterCriticalSection 00bc .bss 00c4 .text"
	strings:
		$1 = { 70 40 2D E9 B0 40 9F E5 00 50 A0 E1 00 30 94 E5 02 00 53 E3 23 00 00 0A 00 00 53 E3 0A 00 00 0A 01 00 53 E3 04 00 00 1A 01 00 A0 E3 ?? ?? ?? ?? 00 30 94 E5 01 00 53 E3 FA FF FF 0A 02 00 53 E3 70 80 BD 18 74 60 9F E5 0D 00 00 EA 04 00 A0 E1 01 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 0C 00 00 1A 58 60 9F E5 06 00 A0 E1 ?? ?? ?? ?? 14 00 86 E2 ?? ?? ?? ?? 48 00 9F E5 ?? ?? ?? ?? 02 30 A0 E3 00 30 84 E5 05 51 85 E0 05 01 86 E0 70 40 BD E8 ?? ?? ?? ?? 02 00 50 E3 E4 FF FF 1A 00 00 84 E5 18 60 9F E5 F6 FF FF EA 10 30 9F E5 00 51 80 E0 05 01 83 E0 70 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_19_4_2 {
	meta:
		name = "dtoa_lock_cleanup"
		size = 56
		refs = "000c InterlockedExchange 001c DeleteCriticalSection 002c .bss"
	strings:
		$1 = { 04 E0 2D E5 20 00 9F E5 03 10 A0 E3 ?? ?? ?? ?? 02 00 50 E3 04 F0 9D 14 10 00 9F E5 ?? ?? ?? ?? 0C 00 9F E5 04 E0 9D E4 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_19_5_2 {
	meta:
		name = "dtoa_unlock"
		size = 40
		refs = "001c LeaveCriticalSection 0020 .bss"
	strings:
		$1 = { 18 30 9F E5 00 30 93 E5 02 00 53 E3 0E F0 A0 11 0C 30 9F E5 00 01 80 E0 00 01 83 E0 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_19_6_2 {
	meta:
		name = "__Bfree_D2A"
		size = 76
		refs = "0044 free 0048 .bss"
	strings:
		$1 = { 10 40 2D E9 00 40 50 E2 10 80 BD 08 04 30 94 E5 09 00 53 E3 09 00 00 CA 00 00 A0 E3 AD FF FF EB 20 30 9F E5 04 20 94 E5 00 00 A0 E3 02 11 93 E7 00 10 84 E5 02 41 83 E7 10 40 BD E8 E5 FF FF EA 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_19_7_2 {
	meta:
		name = "__Balloc_D2A"
		size = 188
		refs = "004c malloc 00b0 .bss 00b4 .data"
	strings:
		$1 = { 70 40 2D E9 00 50 A0 E1 00 00 A0 E3 9E FF FF EB 09 00 55 E3 06 00 00 CA 90 30 9F E5 05 41 93 E7 00 00 54 E3 12 00 00 0A 00 20 94 E5 05 21 83 E7 08 00 00 EA 01 60 A0 E3 16 65 A0 E1 06 01 A0 E1 1B 00 80 E2 A0 01 A0 E1 80 01 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 60 00 84 E9 00 00 A0 E3 CA FF FF EB 00 30 A0 E3 0C 30 84 E5 10 30 84 E5 04 00 A0 E1 70 80 BD E8 01 60 A0 E3 16 65 A0 E1 30 30 9F E5 06 01 A0 E1 00 40 93 E5 28 20 9F E5 1B 00 80 E2 A0 01 A0 E1 04 20 62 E0 C2 21 80 E0 12 0E 52 E3 80 01 84 90 00 00 83 95 E9 FF FF 9A E5 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_19_8_2 {
	meta:
		name = "__d2b_D2A"
		size = 236
		refs = "0018 __Balloc_D2A 0044 __ctzsi2 0094 __clzsi2"
	strings:
		$1 = { F0 4F 2D E9 00 40 A0 E1 01 00 A0 E3 01 50 A0 E1 03 90 A0 E1 02 60 A0 E1 C9 FF FF EB FF 74 C5 E3 02 31 C5 E3 23 AA B0 E1 0F 76 C7 E3 01 76 87 13 00 B0 54 E2 00 80 A0 E1 03 50 A0 E1 19 00 00 0A 04 00 A0 E1 ?? ?? ?? ?? 3B B0 A0 E1 00 00 50 E3 20 30 60 12 17 B3 8B 11 37 70 A0 11 14 B0 88 15 14 B0 88 05 00 00 57 E3 02 40 A0 13 01 40 A0 03 00 00 5A E3 18 70 88 E5 10 40 88 E5 12 00 00 1A 43 0E 40 E2 04 31 88 E0 02 00 40 E2 00 00 86 E5 10 00 93 E5 ?? ?? ?? ?? 84 02 60 E0 00 00 89 E5 08 00 A0 E1 F0 8F BD E8 07 00 A0 E1 ?? ?? ?? ?? 37 70 A0 E1 01 40 A0 E3 00 00 5A E3 14 70 88 E5 10 40 88 E5 20 00 80 E2 EC FF FF 0A 43 AE 4A E2 03 A0 4A E2 00 A0 8A E0 35 00 60 E2 00 A0 86 E5 00 00 89 E5 08 00 A0 E1 F0 8F BD E8 }
	condition:
		$1
}

rule file_19_9_2 {
	meta:
		name = "__diff_D2A"
		size = 436
		refs = "0038 __Balloc_D2A"
	strings:
		$1 = { F0 4F 2D E9 10 20 91 E5 10 30 90 E5 10 D0 4D E2 03 30 62 E0 00 00 53 E3 00 80 A0 E1 01 70 A0 E1 45 00 00 0A 00 30 A0 A3 14 B0 80 A2 5A 00 00 BA 04 00 98 E5 00 30 8D E5 86 FF FF EB 10 20 97 E5 10 60 98 E5 02 21 87 E0 00 30 9D E5 14 10 82 E2 06 81 88 E0 14 20 80 E2 0C 30 80 E5 04 00 8D E5 0B 30 A0 E1 08 40 8D E5 0C 50 8D E5 14 80 88 E2 14 70 87 E2 00 B0 A0 E3 00 C0 A0 E3 02 00 A0 E1 01 40 A0 E1 04 20 97 E4 04 10 93 E4 00 A0 A0 E3 02 10 51 E0 01 20 C1 E0 0B 10 51 E0 0C 20 C2 E0 02 90 A0 E1 04 10 80 E4 00 20 A0 E3 01 10 A0 E3 07 00 54 E1 01 B0 09 E0 02 C0 0A E0 F0 FF FF 8A 08 00 53 E1 00 20 A0 E1 08 50 8D E2 30 00 95 E8 0C 00 00 2A 01 00 A0 E3 00 10 A0 E3 04 70 93 E4 00 50 A0 E3 07 B0 7B E0 00 C0 EC E2 03 00 58 E1 0C 40 A0 E1 0B E0 A0 E1 04 B0 82 E4 00 B0 0C E0 01 C0 05 E0 F4 FF FF 8A 04 30 12 E5 00 00 53 E3 04 00 00 1A 08 30 12 E5 01 60 46 E2 00 00 53 E3 04 20 42 E2 FA FF FF 0A 04 00 9D E5 10 60 80 E5 04 00 9D E5 10 D0 8D E2 F0 8F BD E8 04 20 82 E2 02 21 A0 E1 02 10 81 E0 02 20 80 E0 04 20 82 E2 04 10 81 E2 14 B0 80 E2 04 C0 12 E5 04 00 11 E5 04 20 42 E2 00 00 5C E1 0A 00 00 1A 02 00 5B E1 04 10 41 E2 F7 FF FF 3A 00 00 A0 E3 35 FF FF EB 01 30 A0 E3 10 30 80 E5 00 30 A0 E3 04 00 8D E5 14 30 80 E5 E5 FF FF EA A4 FF FF 2A 08 30 A0 E1 07 80 A0 E1 14 B0 88 E2 03 70 A0 E1 01 30 A0 E3 9E FF FF EA }
	condition:
		$1
}

rule file_19_10_2 {
	meta:
		name = "__lshift_D2A"
		size = 260
		refs = "003c __Balloc_D2A 00c4 __Bfree_D2A"
	strings:
		$1 = { F0 41 2D E9 10 50 90 E5 08 30 90 E5 01 50 85 E2 C1 62 A0 E1 06 50 85 E0 03 00 55 E1 00 40 A0 E1 01 80 A0 E1 04 00 90 E5 03 00 00 DA 83 30 A0 E1 03 00 55 E1 01 00 80 E2 FB FF FF CA 18 FF FF EB 00 00 56 E3 00 70 A0 E1 14 20 80 E2 07 00 00 DA 00 30 A0 E3 03 10 A0 E1 03 11 82 E7 01 30 83 E2 06 00 53 E1 FB FF FF 1A 03 31 87 E0 14 20 83 E2 10 00 94 E5 1F 80 18 E2 00 01 84 E0 14 00 80 E2 14 30 84 E2 11 00 00 0A 20 E0 68 E2 00 10 A0 E3 00 C0 93 E5 1C 18 81 E1 04 10 82 E4 04 10 93 E4 03 00 50 E1 31 1E A0 E1 F8 FF FF 8A 00 00 51 E3 00 10 82 E5 01 50 85 12 01 50 45 E2 04 00 A0 E1 10 50 87 E5 E3 FE FF EB 07 00 A0 E1 F0 81 BD E8 08 10 93 E7 08 10 82 E7 04 80 88 E2 08 10 83 E0 01 00 50 E1 F3 FF FF 9A 08 10 93 E7 08 10 82 E7 04 80 88 E2 08 10 83 E0 01 00 50 E1 F3 FF FF 8A EC FF FF EA }
	condition:
		$1
}

rule file_19_11_2 {
	meta:
		name = "__mult_D2A"
		size = 344
		refs = "0048 __Balloc_D2A"
	strings:
		$1 = { F0 4F 2D E9 10 60 90 E5 10 80 91 E5 00 50 A0 E1 08 00 56 E1 01 50 A0 B1 08 30 A0 A1 00 30 A0 B1 01 A0 A0 E1 06 80 A0 A1 03 A0 A0 B1 03 60 A0 A1 08 30 95 E5 06 40 88 E0 04 00 95 E5 03 00 54 E1 10 D0 4D E2 01 00 80 C2 D4 FE FF EB 04 91 80 E0 14 90 89 E2 14 10 80 E2 09 00 51 E1 04 00 8D E5 04 00 00 2A 01 30 A0 E1 00 20 A0 E3 04 20 83 E4 03 00 59 E1 FC FF FF 8A 06 61 8A E0 14 60 86 E2 14 A0 8A E2 08 81 85 E0 06 00 5A E1 14 50 85 E2 14 80 88 E2 00 50 8D E5 1D 00 00 2A 08 90 8D E5 00 70 A0 E3 01 B0 A0 E1 06 90 A0 E1 0C 40 8D E5 07 60 9A E7 07 20 8B E0 00 00 56 E3 0E 00 00 0A 00 C0 9D E5 00 00 A0 E3 00 10 A0 E3 00 30 92 E5 04 50 9C E4 00 40 A0 E3 96 35 A4 E0 00 30 93 E0 01 40 A4 E0 0C 00 58 E1 04 00 A0 E1 04 30 82 E4 00 10 A0 E3 F4 FF FF 8A 00 40 82 E5 04 70 87 E2 07 30 8A E0 03 00 59 E1 E8 FF FF 8A 08 90 9D E5 0C 40 9D E5 00 00 54 E3 09 00 00 DA 04 30 19 E5 00 00 53 E3 04 00 00 0A 05 00 00 EA 08 30 19 E5 04 90 49 E2 00 00 53 E3 01 00 00 1A 01 40 54 E2 F9 FF FF 1A 04 30 9D E5 10 40 83 E5 03 00 A0 E1 10 D0 8D E2 F0 8F BD E8 }
	condition:
		$1
}

rule file_19_12_2 {
	meta:
		name = "__i2b_D2A"
		size = 32
		refs = "000c __Balloc_D2A"
	strings:
		$1 = { 10 40 2D E9 00 40 A0 E1 01 00 A0 E3 8D FE FF EB 01 20 A0 E3 10 20 80 E5 14 40 80 E5 10 80 BD E8 }
	condition:
		$1
}

rule file_19_13_2 {
	meta:
		name = "__multadd_D2A"
		size = 188
		refs = "008c __Balloc_D2A 00a8 memcpy 00b0 __Bfree_D2A"
	strings:
		$1 = { F0 47 2D E9 00 30 A0 E3 10 60 90 E5 02 40 A0 E1 C4 5F A0 E1 00 70 A0 E1 01 80 A0 E1 C8 9F A0 E1 14 C0 80 E2 03 20 A0 E1 03 A0 9C E7 01 20 82 E2 98 0A 81 E0 9A 19 21 E0 04 00 90 E0 05 10 A1 E0 02 00 56 E1 03 00 8C E7 01 40 A0 E1 04 30 83 E2 00 50 A0 E3 F3 FF FF CA 05 00 51 E1 06 00 00 0A 08 30 97 E5 03 00 56 E1 05 00 00 AA 01 30 86 E2 06 61 87 E0 14 40 86 E5 10 30 87 E5 07 00 A0 E1 F0 87 BD E8 04 00 97 E5 01 00 80 E2 65 FE FF EB 10 20 97 E5 0C 10 87 E2 02 20 82 E2 00 80 A0 E1 02 21 A0 E1 0C 00 80 E2 ?? ?? ?? ?? 07 00 A0 E1 49 FE FF EB 08 70 A0 E1 EB FF FF EA }
	condition:
		$1
}

rule file_19_14_2 {
	meta:
		name = "__pow5mult_D2A"
		size = 288
		refs = "0058 __mult_D2A 0064 __Bfree_D2A 00b0 __multadd_D2A 00fc __i2b_D2A 0114 .bss 0118 .rdata"
	strings:
		$1 = { 03 30 11 E2 F0 41 2D E9 01 40 A0 E1 00 70 A0 E1 22 00 00 1A 44 41 B0 E1 15 00 00 0A F0 50 9F E5 00 60 95 E5 00 00 56 E3 06 00 00 1A 22 00 00 EA C4 40 B0 E1 0E 00 00 0A 00 50 96 E5 00 00 55 E3 05 60 A0 11 0C 00 00 0A 01 00 14 E3 F7 FF FF 0A 06 10 A0 E1 07 00 A0 E1 5B FF FF EB 00 50 A0 E1 07 00 A0 E1 2D FE FF EB C4 40 B0 E1 05 70 A0 E1 F0 FF FF 1A 07 00 A0 E1 F0 81 BD E8 01 00 A0 E3 DC FD FF EB 00 80 96 E5 00 00 58 E3 12 00 00 0A 01 00 A0 E3 17 FE FF EB 08 60 A0 E1 E9 FF FF EA 70 20 9F E5 01 30 43 E2 03 11 92 E7 00 20 A0 E3 A3 FF FF EB 00 70 A0 E1 D5 FF FF EA 01 00 A0 E3 CC FD FF EB 00 60 95 E5 00 00 56 E3 09 00 00 0A 01 00 A0 E3 07 FE FF EB DA FF FF EA 06 10 A0 E1 06 00 A0 E1 38 FF FF EB 00 00 86 E5 00 80 A0 E1 00 50 80 E5 E5 FF FF EA 1C 00 9F E5 88 FF FF EB 00 30 A0 E3 00 00 85 E5 00 60 A0 E1 00 30 80 E5 EE FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? 71 02 00 00 }
	condition:
		$1
}

rule file_20_0_2 {
	meta:
		name = "lrint"
		size = 264
		refs = "005c __adddf3 0068 __subdf3 0104 .rdata"
	strings:
		$1 = { 70 40 2D E9 21 4A A0 E1 84 3A A0 E1 A3 3A A0 E1 FF 3F 43 E2 03 30 43 E2 01 00 73 E3 00 00 A0 B3 70 80 BD B8 1E 00 53 E3 C4 45 A0 E1 03 00 00 DA 00 00 54 E3 02 01 A0 13 02 01 E0 03 70 80 BD E8 01 30 A0 E1 B8 10 9F E5 00 20 A0 E1 84 11 81 E0 60 00 91 E8 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 21 3A A0 E1 83 3A A0 E1 A3 3A A0 E1 43 3E 43 E2 03 30 43 E2 FF 24 C1 E3 0F 26 C2 E3 00 00 53 E3 01 26 82 E3 0B 00 00 BA 1F 00 53 E3 10 13 A0 D1 0C 00 00 CA 20 30 93 E2 0D 00 00 4A 1F 00 53 E3 12 03 A0 D1 0E 00 00 CA 01 00 80 E1 00 00 54 E3 00 00 60 12 70 80 BD E8 1F 00 73 E3 00 10 63 A2 30 11 A0 A1 F2 FF FF AA 20 30 93 E2 00 10 A0 E3 F1 FF FF 5A 1F 00 73 E3 00 30 63 A2 32 03 A0 A1 F0 FF FF AA 00 00 A0 E3 01 00 80 E1 00 00 54 E3 00 00 60 12 70 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_21_0_2 {
	meta:
		name = "snprintf"
		size = 48
		refs = "001c __mingw_vsnprintf"
	strings:
		$1 = { 0C 00 2D E9 04 E0 2D E5 04 D0 4D E2 0C C0 8D E2 0C 30 A0 E1 08 20 9D E5 00 C0 8D E5 ?? ?? ?? ?? 04 D0 8D E2 04 E0 9D E4 08 D0 8D E2 0E F0 A0 E1 }
	condition:
		$1
}

rule file_118_0_2 {
	meta:
		name = "snwprintf"
		size = 48
		refs = "001c _vsnwprintf"
	strings:
		$1 = { 0C 00 2D E9 04 E0 2D E5 04 D0 4D E2 0C C0 8D E2 0C 30 A0 E1 08 20 9D E5 00 C0 8D E5 ?? ?? ?? ?? 04 D0 8D E2 04 E0 9D E4 08 D0 8D E2 0E F0 A0 E1 }
	condition:
		$1
}

rule file_22_0_2 {
	meta:
		name = "tdelete"
		size = 268
		refs = "00d8 free 0104 _assert 0108 .rdata"
	strings:
		$1 = { F0 40 2D E9 00 40 50 E2 02 70 A0 E1 39 00 00 0A 00 50 51 E2 01 00 00 1A 00 00 A0 E3 F0 80 BD E8 00 60 95 E5 00 00 56 E3 06 30 A0 11 08 00 00 1A F8 FF FF EA 00 60 95 E5 04 30 96 B5 08 30 96 A5 04 50 86 B2 08 50 86 A2 00 00 53 E3 F1 FF FF 0A 00 30 95 E5 00 10 93 E5 04 00 A0 E1 0F E0 A0 E1 07 F0 A0 E1 00 00 50 E3 F1 FF FF 1A 00 00 95 E5 04 40 90 E5 08 20 90 E5 00 00 54 E3 02 40 A0 01 14 00 00 0A 00 00 52 E3 12 00 00 0A 04 30 92 E5 00 00 53 E3 03 40 A0 11 02 00 00 1A 11 00 00 EA 04 20 A0 E1 03 40 A0 E1 04 30 94 E5 00 00 53 E3 FA FF FF 1A 08 30 94 E5 04 30 82 E5 00 30 95 E5 04 30 93 E5 04 30 84 E5 00 30 95 E5 08 30 93 E5 08 30 84 E5 00 00 95 E5 ?? ?? ?? ?? 00 40 85 E5 06 00 A0 E1 F0 80 BD E8 04 40 82 E5 00 00 95 E5 02 40 A0 E1 F7 FF FF EA 08 00 9F E5 21 20 A0 E3 10 10 80 E2 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_23_0_2 {
	meta:
		name = "__mingw_vsprintf"
		size = 52
		refs = "0020 __mingw_pformat"
	strings:
		$1 = { 10 40 2D E9 00 40 A0 E1 04 D0 4D E2 01 30 A0 E1 00 20 8D E5 04 10 A0 E1 00 20 A0 E3 02 0A A0 E3 ?? ?? ?? ?? 00 20 A0 E3 00 20 C4 E7 04 D0 8D E2 10 80 BD E8 }
	condition:
		$1
}

rule file_25_0_2 {
	meta:
		name = "ilogbf"
		size = 92
	strings:
		$1 = { 02 01 C0 E3 02 05 50 E3 05 00 00 BA 44 30 9F E5 03 00 50 E1 C0 0B A0 D1 02 01 E0 C3 7F 00 40 D2 0E F0 A0 E1 00 00 50 E3 06 01 A0 03 0E F0 A0 01 00 34 A0 E1 00 00 53 E3 7D 00 E0 D3 0E F0 A0 D1 7D 00 E0 E3 83 30 A0 E1 00 00 53 E3 01 00 40 E2 FB FF FF CA 0E F0 A0 E1 FF FF 7F 7F }
	condition:
		$1
}

rule file_26_0_2 {
	meta:
		name = "llabs"
		size = 48
	strings:
		$1 = { 04 40 2D E5 01 40 A0 E1 C4 1F A0 E1 01 20 A0 E1 01 30 20 E0 01 40 24 E0 01 30 53 E0 02 40 C4 E0 04 10 A0 E1 03 00 A0 E1 10 00 BD E8 0E F0 A0 E1 }
	condition:
		$1
}

rule file_27_0_2 {
	meta:
		name = "sinf"
		size = 192
		refs = "0028 __subsf3 0038 __ieee754_rem_pio2f 0064 __kernel_sinf 009c __kernel_cosf"
	strings:
		$1 = { 04 E0 2D E5 AC 20 9F E5 02 31 C0 E3 02 00 53 E1 08 D0 4D E2 00 10 A0 E1 13 00 00 DA 98 20 9F E5 02 00 53 E1 02 00 00 DA ?? ?? ?? ?? 08 D0 8D E2 00 80 BD E8 0D 10 A0 E1 ?? ?? ?? ?? 03 00 00 E2 01 00 50 E3 12 00 00 0A 02 00 50 E3 0A 00 00 0A 00 00 50 E3 12 00 00 1A 00 00 9D E5 04 10 9D E5 01 20 A0 E3 ?? ?? ?? ?? EF FF FF EA 00 10 A0 E3 00 20 A0 E3 ?? ?? ?? ?? EB FF FF EA 00 00 9D E5 04 10 9D E5 01 20 A0 E3 ?? ?? ?? ?? 02 01 80 E2 E5 FF FF EA 00 00 9D E5 04 10 9D E5 ?? ?? ?? ?? E1 FF FF EA 00 00 9D E5 04 10 9D E5 ?? ?? ?? ?? 02 01 80 E2 DC FF FF EA D8 0F 49 3F FF FF 7F 7F }
	condition:
		$1
}

rule file_28_0_2 {
	meta:
		name = "__kernel_cosf"
		size = 508
		refs = "0018 __fixsfsi 0030 __mulsf3 0044 __addsf3 0054 __subsf3"
	strings:
		$1 = { F0 45 2D E9 02 61 C0 E3 32 04 56 E3 00 50 A0 E1 01 70 A0 E1 33 00 00 AA ?? ?? ?? ?? 00 00 50 E3 FE 05 A0 03 F0 85 BD 08 05 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 9C 11 9F E5 00 40 A0 E1 ?? ?? ?? ?? 94 11 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 88 11 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 7C 11 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 70 11 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 64 11 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 00 80 A0 E1 04 00 A0 E1 3F 14 A0 E3 ?? ?? ?? ?? 08 10 A0 E1 00 60 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 07 10 A0 E1 00 40 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 FE 05 A0 E3 ?? ?? ?? ?? F0 85 BD E8 00 10 A0 E1 ?? ?? ?? ?? E0 10 9F E5 00 40 A0 E1 ?? ?? ?? ?? D8 10 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? CC 10 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? C0 10 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? B4 10 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? A8 10 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 9C 30 9F E5 00 80 A0 E1 03 00 56 E1 CD FF FF DA 90 30 9F E5 FE 05 A0 E3 03 00 56 E1 88 60 9F C5 FF 64 86 D2 06 10 A0 E1 ?? ?? ?? ?? 3F 14 A0 E3 00 A0 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 06 10 A0 E1 ?? ?? ?? ?? 08 10 A0 E1 00 60 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 07 10 A0 E1 00 40 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? F0 85 BD E8 4E D7 47 AD F6 74 0F 31 7C F2 93 34 01 0D D0 37 61 0B B6 3A AB AA 2A 3D 99 99 99 3E 00 00 48 3F 00 00 90 3E }
	condition:
		$1
}

rule file_29_0_2 {
	meta:
		name = "_chsize"
		size = 148
		refs = "0020 SetFilePointer 003c SetLastError 0068 SetEndOfFile"
	strings:
		$1 = { 01 00 70 E3 70 40 2D E9 00 40 A0 E1 01 60 A0 E1 08 00 00 0A 00 10 A0 E3 01 20 A0 E1 01 30 A0 E3 ?? ?? ?? ?? 01 00 70 E3 00 50 A0 E1 05 00 00 1A 00 00 E0 E3 70 80 BD E8 57 00 A0 E3 ?? ?? ?? ?? 04 00 A0 E1 70 80 BD E8 00 20 A0 E3 06 10 A0 E1 04 00 A0 E1 02 30 A0 E1 ?? ?? ?? ?? 01 00 70 E3 F2 FF FF 0A 04 00 A0 E1 ?? ?? ?? ?? 00 20 A0 E3 00 60 A0 E1 05 10 A0 E1 04 00 A0 E1 02 30 A0 E1 ?? ?? ?? ?? 00 00 56 E3 00 00 A0 13 70 80 BD 18 E6 FF FF EA }
	condition:
		$1
}

rule file_31_0_2 {
	meta:
		name = "_write"
		size = 52
		refs = "001c WriteFile"
	strings:
		$1 = { 04 E0 2D E5 00 00 52 E3 08 D0 4D E2 02 21 E0 B3 00 C0 A0 E3 04 30 8D E2 00 C0 8D E5 ?? ?? ?? ?? 00 00 50 E3 00 00 E0 03 04 00 9D 15 08 D0 8D E2 00 80 BD E8 }
	condition:
		$1
}

rule file_79_0_2 {
	meta:
		name = "_read"
		size = 52
		refs = "001c ReadFile"
	strings:
		$1 = { 04 E0 2D E5 00 00 52 E3 08 D0 4D E2 02 21 E0 B3 00 C0 A0 E3 04 30 8D E2 00 C0 8D E5 ?? ?? ?? ?? 00 00 50 E3 00 00 E0 03 04 00 9D 15 08 D0 8D E2 00 80 BD E8 }
	condition:
		$1
}

rule file_33_0_2 {
	meta:
		name = "__ulp_D2A"
		size = 100
	strings:
		$1 = { 04 20 90 E5 54 30 9F E5 03 30 02 E0 0D 35 43 E2 00 00 53 E3 03 10 A0 C1 00 00 A0 C3 0E F0 A0 C1 00 30 63 E2 43 3A A0 E1 13 00 53 E3 02 27 A0 D3 52 13 A0 D1 00 00 A0 D3 0E F0 A0 D1 14 30 43 E2 1E 00 53 E3 1F 30 63 D2 01 20 A0 D3 12 33 A0 D1 01 30 A0 C3 00 10 A0 E3 03 00 A0 E1 0E F0 A0 E1 00 00 F0 7F }
	condition:
		$1
}

rule file_34_0_2 {
	meta:
		name = "__mb_cur_max"
		size = 32
		refs = "0010 GetCPInfo"
	strings:
		$1 = { 04 E0 2D E5 14 D0 4D E2 0D 10 A0 E1 00 00 A0 E3 ?? ?? ?? ?? 00 00 9D E5 14 D0 8D E2 00 80 BD E8 }
	condition:
		$1
}

rule file_35_0_2 {
	meta:
		name = "tanhf"
		size = 248
		refs = "002c __divsf3 0034 __addsf3 0074 expm1f 00a8 __subsf3 00bc __mulsf3"
	strings:
		$1 = { E8 20 9F E5 02 31 C0 E3 02 00 53 E1 30 40 2D E9 00 50 A0 E1 00 40 A0 E1 07 00 00 DA 00 00 50 E3 1C 00 00 BA 00 10 A0 E1 FE 05 A0 E3 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 30 80 BD E8 B0 20 9F E5 02 00 53 E1 FE 05 A0 C3 02 00 00 DA 00 00 54 E3 02 01 80 B2 30 80 BD E8 77 03 73 E3 13 00 00 DA FE 05 53 E3 16 00 00 BA 02 01 C5 E3 00 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 01 11 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 03 01 A0 E3 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? EC FF FF EA 00 10 A0 E1 FE 05 A0 E3 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 30 80 BD E8 FE 15 A0 E3 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 30 80 BD E8 03 11 A0 E3 02 01 C5 E3 ?? ?? ?? ?? ?? ?? ?? ?? 01 11 A0 E3 02 51 80 E2 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? D6 FF FF EA FF FF 7F 7F FF FF AF 41 }
	condition:
		$1
}

rule file_36_0_2 {
	meta:
		name = "wcsftime"
		size = 136
		refs = "0018 wcslen 0024 malloc 0044 wcstombs 0058 strftime 0068 mbstowcs 0074 free"
	strings:
		$1 = { F0 47 2D E9 00 70 A0 E1 02 00 A0 E1 01 60 A0 E1 02 80 A0 E1 03 A0 A0 E1 ?? ?? ?? ?? 01 90 80 E2 09 00 A0 E1 ?? ?? ?? ?? 00 50 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 08 10 A0 E1 00 40 A0 E1 09 20 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 0A 30 A0 E1 06 10 A0 E1 05 20 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 00 20 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 00 60 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 ?? ?? ?? ?? 06 00 A0 E1 F0 87 BD E8 }
	condition:
		$1
}

rule file_37_0_2 {
	meta:
		name = "utime"
		size = 60
		refs = "000c open 0024 _futime 0030 close"
	strings:
		$1 = { 30 40 2D E9 01 50 A0 E1 02 10 A0 E3 ?? ?? ?? ?? 01 00 70 E3 00 40 A0 E1 00 50 A0 01 04 00 00 0A 05 10 A0 E1 ?? ?? ?? ?? 00 50 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 05 00 A0 E1 30 80 BD E8 }
	condition:
		$1
}

rule file_38_0_2 {
	meta:
		name = "asinhf"
		size = 312
		refs = "0028 __addsf3 0030 __gtsf2 0044 __mulsf3 0054 sqrtf 0068 __divsf3 007c log1pf 00f8 logf"
	strings:
		$1 = { 20 21 9F E5 02 31 C0 E3 02 00 53 E1 F0 40 2D E9 00 40 A0 E1 00 50 A0 E1 38 00 00 CA C6 05 53 E3 1B 00 00 AA 00 11 9F E5 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 00 00 50 E3 13 00 00 CA 04 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 00 60 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 02 41 C4 E3 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 55 E3 00 40 A0 C1 02 41 80 D2 04 00 A0 E1 F0 80 BD E8 94 20 9F E5 02 00 53 E1 1C 00 00 CA 01 01 53 E3 E4 FF FF DA 00 10 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? ?? ?? ?? ?? 02 41 C4 E3 00 70 A0 E1 04 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 00 60 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 FE 05 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? DF FF FF EA 00 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 04 00 A0 E1 F0 80 BD E8 02 01 C0 E3 ?? ?? ?? ?? 10 10 9F E5 ?? ?? ?? ?? D5 FF FF EA FF FF 7F 7F CA F2 49 71 00 00 80 4D 18 72 31 3F }
	condition:
		$1
}

rule file_39_0_2 {
	meta:
		name = "__pformat_putc"
		size = 96
		refs = "004c fputc"
	strings:
		$1 = { 04 30 91 E5 10 40 2D E9 02 0A 13 E3 01 40 A0 E1 03 00 00 1A 10 20 91 E5 14 10 91 E5 02 00 51 E1 05 00 00 DA 01 0A 13 E3 06 00 00 1A 00 20 94 E5 10 30 94 E5 03 00 C2 E7 10 20 94 E5 01 20 82 E2 10 20 84 E5 10 80 BD E8 00 10 94 E5 ?? ?? ?? ?? 10 20 94 E5 01 20 82 E2 10 20 84 E5 10 80 BD E8 }
	condition:
		$1
}

rule file_39_1_2 {
	meta:
		name = "__pformat_wputchars"
		size = 296
		refs = "0024 wcrtomb"
	strings:
		$1 = { F0 4F 2D E9 14 D0 4D E2 10 80 8D E2 02 40 A0 E1 00 A0 A0 E1 01 50 A0 E1 0D 00 A0 E1 00 10 A0 E3 08 20 A0 E1 ?? ?? ?? ?? 0C 30 94 E5 0D 70 A0 E1 00 00 53 E3 01 00 00 BA 03 00 55 E1 03 50 A0 A1 08 30 94 E5 03 00 55 E1 00 30 E0 A3 08 30 84 A5 06 00 00 AA 03 30 65 E0 00 00 53 E3 08 30 84 E5 02 00 00 DA 04 20 94 E5 01 0B 12 E3 22 00 00 0A 00 60 A0 E3 0F 00 00 EA 0D 00 A0 E1 B6 10 9A E1 08 20 A0 E1 ?? ?? ?? ?? 00 B0 50 E2 13 00 00 DA 00 90 A0 E3 D9 00 97 E1 04 10 A0 E1 01 90 89 E2 BE FF FF EB 0B 30 69 E0 00 00 53 E3 F8 FF FF CA 02 60 86 E2 01 50 45 E2 00 00 55 E3 ED FF FF CA 08 30 94 E5 00 00 53 E3 01 30 43 E2 08 30 84 E5 07 00 00 DA 20 00 A0 E3 04 10 A0 E1 AF FF FF EB 08 30 94 E5 00 00 53 E3 01 30 43 E2 08 30 84 E5 F7 FF FF CA 14 D0 8D E2 F0 8F BD E8 01 30 43 E2 08 30 84 E5 20 00 A0 E3 04 10 A0 E1 A3 FF FF EB 08 30 94 E5 00 00 53 E3 01 30 43 E2 08 30 84 E5 F7 FF FF 1A D1 FF FF EA }
	condition:
		$1
}

rule file_39_2_2 {
	meta:
		name = "__pformat_putchars"
		size = 220
	strings:
		$1 = { 0C 30 92 E5 F0 40 2D E9 00 00 53 E3 02 40 A0 E1 00 70 A0 E1 01 60 A0 E1 01 00 00 BA 03 00 56 E1 03 60 A0 A1 08 30 94 E5 03 00 56 E1 00 30 E0 A3 08 30 84 A5 06 00 00 AA 03 30 66 E0 00 00 53 E3 08 30 84 E5 02 00 00 DA 04 20 94 E5 01 0B 12 E3 16 00 00 0A 00 00 56 E3 06 00 00 0A 00 50 A0 E3 D5 00 97 E1 04 10 A0 E1 01 50 85 E2 81 FF FF EB 06 00 55 E1 F9 FF FF 1A 08 30 94 E5 00 00 53 E3 01 30 43 E2 08 30 84 E5 F0 80 BD D8 20 00 A0 E3 04 10 A0 E1 77 FF FF EB 08 30 94 E5 00 00 53 E3 01 30 43 E2 08 30 84 E5 F7 FF FF CA F0 80 BD E8 01 30 43 E2 08 30 84 E5 20 00 A0 E3 04 10 A0 E1 6C FF FF EB 08 30 94 E5 00 00 53 E3 01 30 43 E2 08 30 84 E5 F7 FF FF 1A DD FF FF EA }
	condition:
		$1
}

rule file_39_3_2 {
	meta:
		name = "__pformat_emit_inf_or_nan"
		size = 168
	strings:
		$1 = { 10 40 2D E9 00 30 E0 E3 00 00 50 E3 04 D0 4D E2 0C 30 82 E5 13 00 00 0A 04 00 8D E2 2D 30 A0 E3 04 30 60 E5 04 40 92 E5 01 E0 80 E2 20 40 04 E2 00 30 A0 E3 03 C0 D1 E7 20 C0 CC E3 0C C0 84 E1 03 C0 CE E7 01 30 83 E2 03 00 53 E3 F8 FF FF 1A 03 10 8E E2 0D 00 A0 E1 01 10 60 E0 B0 FF FF EB 04 D0 8D E2 10 80 BD E8 04 40 92 E5 01 0C 14 E3 04 00 00 0A 04 00 8D E2 2B 30 A0 E3 04 30 60 E5 01 E0 80 E2 E8 FF FF EA 40 00 14 E3 04 00 8D 12 20 30 A0 13 04 30 60 15 0D 00 A0 01 0D E0 A0 01 01 E0 80 12 E0 FF FF EA }
	condition:
		$1
}

rule file_39_4_2 {
	meta:
		name = "__pformat_int"
		size = 616
		refs = "0084 __umoddi3 00a0 __udivdi3"
	strings:
		$1 = { 0C 30 92 E5 F0 49 2D E9 08 C0 92 E5 02 40 A0 E1 C3 2F C3 E1 17 20 82 E2 0C 00 52 E1 0C 20 A0 B1 0A 20 82 E2 03 20 C2 E3 04 C0 94 E5 18 B0 8D E2 02 D0 4D E0 07 80 8D E2 80 00 1C E3 07 80 C8 E3 05 00 00 0A 00 00 51 E3 80 C0 CC A3 00 50 A0 E1 01 60 A0 E1 04 C0 84 A5 76 00 00 BA 01 20 90 E1 00 50 A0 E1 01 60 A0 E1 08 70 A0 01 11 00 00 0A 08 70 A0 E1 05 00 A0 E1 06 10 A0 E1 0A 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 30 C0 80 E2 06 10 A0 E1 05 00 A0 E1 00 30 A0 E3 0A 20 A0 E3 01 C0 C7 E4 ?? ?? ?? ?? 01 30 90 E1 00 50 A0 E1 01 60 A0 E1 EF FF FF 1A 0C 30 94 E5 00 00 53 E3 0A 00 00 DA 03 30 88 E0 03 30 67 E0 00 00 53 E3 06 00 00 DA 00 20 A0 E3 30 10 A0 E3 02 10 C7 E7 01 20 82 E2 03 00 52 E1 FB FF FF 1A 02 70 87 E0 08 00 57 E1 55 00 00 0A 08 30 94 E5 00 00 53 E3 1B 00 00 DA 03 30 88 E0 03 20 67 E0 00 00 52 E3 08 20 84 E5 16 00 00 DA 04 10 94 E5 07 0D 11 E3 01 20 42 12 08 20 84 15 0C 20 94 E5 01 30 A0 E1 00 00 52 E3 30 00 00 BA 01 0B 11 E3 0D 00 00 1A 08 30 94 E5 00 00 53 E3 01 30 43 E2 08 30 84 E5 43 00 00 DA 20 00 A0 E3 04 10 A0 E1 E5 FE FF EB 08 30 94 E5 00 00 53 E3 01 30 43 E2 08 30 84 E5 F7 FF FF CA 04 30 94 E5 80 00 13 E3 2D 30 A0 13 01 30 C7 14 0B 00 00 1A 01 0C 13 E3 2B 30 A0 13 01 30 C7 14 07 00 00 1A 40 00 13 E3 20 30 A0 13 01 30 C7 14 07 00 58 E1 0C 00 00 2A D1 00 77 E1 04 10 A0 E1 CF FE FF EB 07 00 58 E1 FA FF FF 3A 08 30 94 E5 00 00 53 E3 01 30 43 E2 08 30 84 E5 07 00 00 DA 20 00 A0 E3 04 10 A0 E1 C5 FE FF EB 08 30 94 E5 00 00 53 E3 01 30 43 E2 08 30 84 E5 F7 FF FF CA 18 D0 4B E2 F0 89 BD E8 06 2C 01 E2 02 0C 52 E3 CB FF FF 1A 08 30 94 E5 00 00 53 E3 01 30 43 E2 08 30 84 E5 30 20 A0 C3 10 00 00 DA 08 30 94 E5 01 20 C7 E4 00 00 53 E3 01 30 43 E2 08 30 84 E5 F9 FF FF CA CD FF FF EA 00 50 75 E2 00 60 E6 E2 06 10 A0 E1 05 00 A0 E1 83 FF FF EA 0C 30 94 E5 00 00 53 E3 30 30 A0 13 01 30 C7 14 A4 FF FF EA 01 30 A0 E1 C2 FF FF EA }
	condition:
		$1
}

rule file_39_5_2 {
	meta:
		name = "__pformat_xint"
		size = 632
	strings:
		$1 = { F0 4F 2D E9 6F 00 50 E3 00 90 A0 E1 0C 00 93 E5 12 C0 A0 13 18 C0 A0 03 08 50 93 E5 0F 80 A0 13 07 80 A0 03 03 40 A0 E1 04 30 A0 13 03 30 A0 03 00 00 50 E3 00 C0 8C A0 05 00 5C E1 05 C0 A0 B1 0A C0 8C E2 03 C0 CC E3 20 B0 8D E2 0C D0 4D E0 07 60 8D E2 02 C0 91 E1 07 60 C6 E3 80 00 00 0A FF 80 08 E2 06 50 A0 E1 20 C0 43 E2 20 70 63 E2 20 A0 09 E2 31 03 A0 E1 01 10 08 E0 30 10 81 E2 39 00 51 E3 01 10 C5 E4 07 10 81 C2 0A 10 81 C1 12 07 80 E1 01 10 45 C5 00 00 5C E3 32 1C A0 A1 32 23 A0 E1 00 10 A0 B1 02 00 91 E1 F0 FF FF 1A 06 00 55 E1 0C 00 94 15 68 00 00 0A 00 00 50 E3 4C 00 00 DA 00 00 86 E0 00 00 65 E0 00 00 50 E3 48 00 00 DA 00 30 A0 E3 30 20 A0 E3 03 20 C5 E7 01 30 83 E2 00 00 53 E1 FB FF FF 1A 03 50 85 E0 06 00 55 E1 47 00 00 0A 08 80 94 E5 05 30 66 E0 03 00 58 E1 00 80 E0 D3 08 80 84 D5 0E 00 00 DA 08 80 63 E0 00 00 58 E3 08 80 84 E5 0A 00 00 DA 6F 00 59 E3 05 00 00 0A 04 30 94 E5 02 0B 13 E3 02 00 00 0A 02 80 48 E2 00 00 58 E3 07 00 00 DA 0C 30 94 E5 00 00 53 E3 37 00 00 BA 6F 00 59 E3 07 00 00 0A 04 30 94 E5 02 0B 13 E3 04 00 00 0A 05 30 A0 E1 01 90 C3 E4 30 20 A0 E3 01 20 C5 E5 01 50 83 E2 00 00 58 E3 03 00 00 DA 04 30 94 E5 01 0B 13 E3 08 70 A0 01 12 00 00 0A 06 00 55 E1 05 70 A0 81 04 00 00 9A D1 00 77 E1 04 10 A0 E1 39 FE FF EB 07 00 56 E1 FA FF FF 3A 00 00 58 E3 06 00 00 DA 08 50 A0 E1 01 50 45 E2 20 00 A0 E3 04 10 A0 E1 30 FE FF EB 00 00 55 E3 F9 FF FF CA 20 D0 4B E2 F0 8F BD E8 01 70 47 E2 20 00 A0 E3 04 10 A0 E1 28 FE FF EB 00 00 57 E3 F9 FF FF CA 00 80 E0 E3 E4 FF FF EA 6F 00 59 E3 BB FF FF 1A 04 30 94 E5 02 0B 13 E3 30 30 A0 13 01 30 C5 14 06 00 55 E1 B7 FF FF 1A 0C 30 94 E5 00 00 53 E3 30 30 A0 13 01 30 C5 14 B2 FF FF EA 04 30 94 E5 06 3C 03 E2 02 0C 53 E3 C3 FF FF 1A 00 30 A0 E3 30 20 A0 E3 03 20 C5 E7 01 30 83 E2 08 00 53 E1 FB FF FF 1A 08 50 85 E0 00 80 E0 E3 BA FF FF EA 0C 00 94 E5 04 30 94 E5 06 50 A0 E1 02 3B C3 E3 04 30 84 E5 90 FF FF EA }
	condition:
		$1
}

rule file_39_6_2 {
	meta:
		name = "__pformat_emit_float"
		size = 664
	strings:
		$1 = { F0 40 2D E9 00 50 52 E2 00 60 A0 E1 01 40 A0 E1 03 70 A0 E1 81 00 00 DA 08 30 93 E5 03 00 55 E1 03 30 65 B0 00 30 E0 A3 08 30 87 B5 08 30 87 A5 55 00 00 AA 00 00 53 E3 53 00 00 BA 0C 20 97 E5 03 00 52 E1 50 00 00 AA 03 30 62 E0 00 00 53 E3 08 30 87 E5 4E 00 00 DA 00 00 52 E3 89 00 00 DA 01 30 43 E2 00 00 53 E3 08 30 87 E5 48 00 00 0A 00 00 56 E3 51 00 00 1A 04 20 97 E5 07 0D 12 E3 08 30 97 05 4D 00 00 1A 06 0C 12 E3 40 00 00 1A 01 30 43 E2 08 30 87 E5 20 00 A0 E3 07 10 A0 E1 DB FD FF EB 08 30 97 E5 00 00 53 E3 01 30 43 E2 08 30 87 E5 F7 FF FF CA 00 00 56 E3 36 00 00 0A 2D 00 A0 E3 07 10 A0 E1 D1 FD FF EB 08 30 97 E5 00 00 53 E3 03 00 00 DA 04 20 97 E5 06 2C 02 E2 02 0C 52 E3 57 00 00 0A 00 00 55 E3 61 00 00 DA 00 30 D4 E5 30 00 A0 E3 00 00 53 E3 03 0C A0 11 40 0C A0 11 01 50 45 E2 07 10 A0 E1 01 40 84 12 BF FD FF EB 00 00 55 E3 F4 FF FF CA 00 50 A0 E3 0C 30 97 E5 00 00 53 E3 2A 00 00 DA 2E 00 A0 E3 07 10 A0 E1 B6 FD FF EB 00 00 55 E3 0C 30 97 E5 29 00 00 1A 00 00 53 E3 01 30 43 E2 0C 30 87 E5 F0 80 BD D8 00 30 D4 E5 30 00 A0 E3 00 00 53 E3 03 0C A0 11 40 0C A0 11 07 10 A0 E1 01 40 84 12 A7 FD FF EB 0C 30 97 E5 00 00 53 E3 01 30 43 E2 0C 30 87 E5 F2 FF FF CA F0 80 BD E8 00 30 E0 E3 08 30 87 E5 00 00 56 E3 C8 FF FF 1A 04 30 97 E5 01 0C 13 E3 23 00 00 1A 40 00 13 E3 C6 FF FF 0A 20 00 A0 E3 07 10 A0 E1 95 FD FF EB C2 FF FF EA 01 30 43 E2 00 00 53 E3 08 30 87 E5 F0 FF FF 0A 04 20 97 E5 AB FF FF EA 04 20 97 E5 02 0B 12 E3 D1 FF FF 1A 00 00 55 E3 D5 FF FF 0A 05 30 83 E0 0C 30 87 E5 30 00 A0 E3 07 10 A0 E1 84 FD FF EB 01 50 95 E2 FA FF FF 4A 0C 30 97 E5 00 00 53 E3 01 30 43 E2 0C 30 87 E5 CD FF FF CA F0 80 BD E8 08 30 93 E5 00 00 53 E3 01 30 43 C2 08 30 87 C5 81 FF FF CA 7E FF FF EA 2B 00 A0 E3 07 10 A0 E1 73 FD FF EB A0 FF FF EA 01 30 43 E2 08 30 87 E5 30 00 A0 E3 07 10 A0 E1 6D FD FF EB 08 30 97 E5 00 00 53 E3 01 30 43 E2 08 30 87 E5 F7 FF FF CA 00 00 55 E3 9D FF FF CA 30 00 A0 E3 07 10 A0 E1 63 FD FF EB A5 FF FF EA 04 20 97 E5 02 0B 12 E3 76 FF FF 0A 71 FF FF EA }
	condition:
		$1
}

rule file_39_7_2 {
	meta:
		name = "__pformat_emit_efloat"
		size = 200
	strings:
		$1 = { BC C0 9F E5 70 48 2D E9 01 50 42 E2 9C 25 CE E0 C5 2F A0 E1 4E 21 72 E0 03 40 A0 E1 01 E0 A0 03 05 00 00 0A 01 E0 A0 E3 9C 62 C3 E0 C2 2F A0 E1 43 21 72 E0 01 E0 8E E2 FA FF FF 1A 18 60 94 E5 08 30 94 E5 06 00 5E E1 0E 60 A0 A1 06 60 A0 B1 02 60 86 E2 06 00 53 E1 03 30 66 C0 00 30 E0 D3 08 30 84 C5 08 30 84 D5 01 20 A0 E3 04 30 A0 E1 3C FF FF EB 04 30 94 E5 18 20 94 E5 07 3D 83 E3 20 00 03 E2 0C 20 84 E5 04 30 84 E5 04 10 A0 E1 45 00 80 E3 38 FD FF EB 08 30 94 E5 05 B0 A0 E1 CB CF A0 E1 01 30 43 E2 06 60 83 E0 0C 10 A0 E1 04 20 A0 E1 0B 00 A0 E1 08 60 84 E5 70 48 BD E8 F0 FD FF EA 67 66 66 66 }
	condition:
		$1
}

rule file_39_8_2 {
	meta:
		name = "__pformat_efloat"
		size = 196
		refs = "0038 ecvt 0048 __fpclassify 005c _isnan"
	strings:
		$1 = { F0 40 2D E9 02 60 A0 E1 0C 20 92 E5 0C D0 4D E2 00 00 52 E3 06 30 A0 B3 0C 30 86 B5 01 20 82 A2 07 20 A0 B3 08 C0 8D E2 04 30 8D E2 00 40 A0 E1 01 50 A0 E1 00 C0 8D E5 ?? ?? ?? ?? 05 10 A0 E1 00 70 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 05 0C 50 E3 04 00 00 0A 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 0D 00 00 0A 50 30 9F E5 04 30 8D E5 D0 30 D7 E1 2D 00 53 E3 01 00 A0 03 00 70 87 00 08 00 8D 05 00 00 00 0A 08 00 9D E5 07 10 A0 E1 06 20 A0 E1 9F FD FF EB 0C D0 8D E2 F0 80 BD E8 04 20 9D E5 02 09 72 E3 F6 FF FF 0A 07 10 A0 E1 06 30 A0 E1 08 00 9D E5 9E FF FF EB F5 FF FF EA 00 80 FF FF }
	condition:
		$1
}

rule file_39_9_2 {
	meta:
		name = "__pformat_float"
		size = 224
		refs = "0030 fcvt 0040 __fpclassify 0054 _isnan"
	strings:
		$1 = { F0 40 2D E9 02 40 A0 E1 0C 20 92 E5 0C D0 4D E2 00 00 52 E3 06 20 A0 B3 0C 20 84 B5 08 C0 8D E2 04 30 8D E2 00 50 A0 E1 01 60 A0 E1 00 C0 8D E5 ?? ?? ?? ?? 06 10 A0 E1 00 70 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 05 0C 50 E3 15 00 00 0A 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 10 00 00 1A 04 20 9D E5 02 09 72 E3 15 00 00 0A 07 10 A0 E1 08 00 9D E5 04 30 A0 E1 D7 FE FF EB 02 00 00 EA 20 00 A0 E3 04 10 A0 E1 D8 FC FF EB 08 30 94 E5 00 00 53 E3 01 30 43 E2 08 30 84 E5 F7 FF FF CA 0B 00 00 EA 30 30 9F E5 04 30 8D E5 D0 30 D7 E1 2D 00 53 E3 01 00 A0 03 00 70 87 00 08 00 8D 05 00 00 00 0A 08 00 9D E5 07 10 A0 E1 04 20 A0 E1 5F FD FF EB 0C D0 8D E2 F0 80 BD E8 00 80 FF FF }
	condition:
		$1
}

rule file_39_10_2 {
	meta:
		name = "__pformat_emit_xfloat"
		size = 1228
	strings:
		$1 = { F0 4F 2D E9 2C D0 4D E2 50 40 9D E5 08 E0 8D E2 0C C0 94 E5 0F 00 8E E8 0E 00 5C E3 C9 00 00 9A 08 10 8D E2 03 00 91 E8 01 30 90 E1 11 01 00 0A 04 E0 94 E5 00 70 A0 E1 02 3B 0E E2 00 E0 8D E5 20 B0 0E E2 0F E0 07 E2 0E 80 A0 E1 C8 9F A0 E1 18 60 8D E2 08 00 57 E1 04 30 8D E5 B0 C1 DD E1 01 A0 A0 E1 06 50 A0 E1 08 30 8D E2 0C 00 93 E8 1A 00 00 0A 0C 10 94 E5 02 00 A0 E1 00 00 51 E3 01 10 41 C2 0C 10 84 C5 03 10 A0 E1 00 00 5E E3 36 00 00 0A 09 00 5E E3 37 E0 8E C2 0B E0 8E C1 37 00 00 DA 01 E0 C5 E4 20 22 A0 E1 01 2E 82 E1 21 32 A0 E1 03 E0 92 E1 33 00 00 0A 02 70 A0 E1 0F E0 07 E2 0E 80 A0 E1 C8 9F A0 E1 08 00 57 E1 02 00 A0 E1 03 10 A0 E1 03 A0 A0 E1 E4 FF FF 1A 09 00 5A E1 E2 FF FF 1A 06 00 55 E1 05 00 00 8A 04 70 9D E5 00 00 57 E3 02 00 00 1A 0C 70 94 E5 00 00 57 E3 01 00 00 DA 2E 70 A0 E3 01 70 C5 E4 00 00 51 E3 0A 00 00 1A 01 00 50 E3 DA FF FF 9A A3 10 B0 E1 62 00 A0 E1 01 C0 4C E2 0C C8 A0 E1 00 00 51 E3 2C C8 A0 E1 08 00 00 0A 00 20 A0 E1 01 30 A0 E1 A3 10 B0 E1 62 00 A0 E1 01 C0 4C E2 0C C8 A0 E1 00 00 51 E3 2C C8 A0 E1 F6 FF FF 1A 01 00 50 E3 F4 FF FF 8A 00 00 5E E3 C8 FF FF 1A 06 00 55 E1 02 00 00 8A 0C 70 94 E5 00 00 57 E3 C8 FF FF BA 30 E0 8E E2 C5 FF FF EA 06 00 55 E1 08 20 8D E5 0C 30 8D E5 B0 C1 CD E1 C1 00 00 0A 08 C0 94 E5 00 00 5C E3 A1 00 00 DA B0 81 DD E1 0C 30 94 E5 08 88 A0 E1 08 03 9F E5 00 00 53 E3 05 20 66 E0 48 E8 A0 E1 03 20 82 C0 90 3E CE E0 00 70 9D E5 C8 3F A0 E1 07 0D 17 E3 06 10 A0 13 05 10 A0 03 4E 31 73 E0 02 10 81 E0 02 70 A0 03 08 00 00 0A 02 70 A0 E3 90 E3 C2 E0 01 70 87 E2 C3 3F A0 E1 07 78 A0 E1 42 31 73 E0 01 10 81 E2 27 78 A0 E1 F7 FF FF 1A 01 00 5C E1 6C 00 00 CA 00 30 E0 E3 08 30 84 E5 00 30 9D E5 80 00 13 E3 7B 00 00 1A 01 0C 13 E3 82 00 00 1A 40 00 13 E3 88 00 00 1A 30 00 A0 E3 04 10 A0 E1 2F FC FF EB 04 00 94 E5 04 10 A0 E1 20 00 00 E2 58 00 80 E3 2A FC FF EB 08 30 94 E5 00 00 53 E3 0C 00 00 DA 04 20 94 E5 02 0C 12 E3 09 00 00 0A 01 30 43 E2 08 30 84 E5 30 00 A0 E3 04 10 A0 E1 1F FC FF EB 08 30 94 E5 00 00 53 E3 01 30 43 E2 08 30 84 E5 F7 FF FF CA 06 00 55 E1 0E 00 00 9A D1 30 55 E1 04 10 A0 E1 03 00 A0 E1 01 50 45 E2 13 FC FF EB 05 00 56 E1 F8 FF FF 3A 0C 30 94 E5 00 00 53 E3 01 30 43 E2 0C 30 84 E5 07 00 00 DA 30 00 A0 E3 04 10 A0 E1 09 FC FF EB 0C 30 94 E5 00 00 53 E3 01 30 43 E2 0C 30 84 E5 F7 FF FF CA 04 00 94 E5 04 10 A0 E1 20 00 00 E2 50 00 80 E3 FF FB FF EB 08 20 94 E5 04 30 94 E5 07 78 A0 E1 48 88 A0 E1 47 78 82 E0 C8 9F A0 E1 07 3D 83 E3 88 00 84 E9 09 10 A0 E1 04 20 A0 E1 08 00 A0 E1 B6 FC FF EB 2C D0 8D E2 F0 8F BD E8 08 30 8D E2 0C 00 93 E8 06 01 73 E3 03 00 00 8A 02 20 92 E0 03 30 A3 E0 06 01 73 E3 FB FF FF 9A 0E E0 6C E2 0E E1 A0 E1 04 50 A0 E3 20 60 6E E2 35 16 A0 E1 A3 30 B0 E1 62 20 A0 E1 15 0E A0 E1 20 60 5E E2 15 16 A0 51 00 20 92 E0 01 30 A3 E0 00 00 53 E3 2D 00 00 BA 02 20 92 E0 03 30 A3 E0 0F E0 6C E2 0E E1 A0 E1 32 0E A0 E1 20 50 6E E2 13 05 80 E1 20 50 5E E2 33 05 A0 51 33 1E A0 E1 08 00 8D E5 0C 10 8D E5 14 FF FF EA 00 30 9D E5 0C 10 61 E0 06 0C 13 E3 08 10 84 E5 90 FF FF 1A 00 00 51 E3 01 10 41 E2 08 10 84 E5 8C FF FF DA 20 00 A0 E3 04 10 A0 E1 C2 FB FF EB 08 30 94 E5 00 00 53 E3 01 30 43 E2 08 30 84 E5 F7 FF FF CA 04 30 94 E5 80 00 13 E3 83 FF FF 0A 2D 00 A0 E3 04 10 A0 E1 B7 FB FF EB 83 FF FF EA B0 81 DD E1 00 30 9D E5 08 88 A0 E1 02 70 A0 E3 78 FF FF EA 2B 00 A0 E3 04 10 A0 E1 AE FB FF EB 7A FF FF EA B0 11 DD E1 01 10 81 E2 B0 11 CD E1 CF FF FF EA 20 00 A0 E3 04 10 A0 E1 A6 FB FF EB 72 FF FF EA 04 70 94 E5 18 60 8D E2 00 70 8D E5 00 00 5C E3 08 00 00 DA 2E 30 A0 E3 18 30 CD E5 02 50 86 E2 01 30 86 E2 30 20 A0 E3 00 20 C3 E5 3D FF FF EA 0C C0 94 E5 F4 FF FF EA 00 10 9D E5 02 0B 11 E3 01 50 86 02 06 30 A0 01 F5 FF FF 0A F0 FF FF EA 67 66 66 66 }
	condition:
		$1
}

rule file_39_11_2 {
	meta:
		name = "__pformat_gfloat"
		size = 400
		refs = "0044 ecvt 0054 __fpclassify 0068 _isnan 0150 strlen"
	strings:
		$1 = { F0 40 2D E9 02 40 A0 E1 0C 20 92 E5 0C D0 4D E2 00 00 52 E3 06 20 A0 B3 00 50 A0 E1 01 60 A0 E1 0C 20 84 B5 01 00 00 BA 01 20 A0 03 0C 20 84 05 08 C0 8D E2 04 30 8D E2 06 10 A0 E1 05 00 A0 E1 00 C0 8D E5 ?? ?? ?? ?? 06 10 A0 E1 00 70 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 05 0C 50 E3 04 00 00 0A 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 0D 00 00 0A 10 31 9F E5 04 30 8D E5 D0 30 D7 E1 2D 00 53 E3 01 00 A0 03 00 70 87 00 08 00 8D 05 00 00 00 0A 08 00 9D E5 07 10 A0 E1 04 20 A0 E1 00 FC FF EB 0C D0 8D E2 F0 80 BD E8 04 50 9D E5 02 09 75 E3 F6 FF FF 0A 03 00 75 E3 16 00 00 BA 0C 30 94 E5 03 00 55 E1 13 00 00 CA 04 20 94 E5 02 0B 12 E3 03 30 65 10 0C 30 84 15 1F 00 00 0A 07 10 A0 E1 05 20 A0 E1 08 00 9D E5 04 30 A0 E1 4E FD FF EB 02 00 00 EA 20 00 A0 E3 04 10 A0 E1 4F FB FF EB 08 30 94 E5 00 00 53 E3 01 30 43 E2 08 30 84 E5 F7 FF FF CA E1 FF FF EA 04 30 94 E5 02 0B 13 E3 08 00 00 0A 0C 30 94 E5 01 30 43 E2 0C 30 84 E5 07 10 A0 E1 05 20 A0 E1 04 30 A0 E1 08 00 9D E5 DF FD FF EB D5 FF FF EA 07 00 A0 E1 ?? ?? ?? ?? 01 00 40 E2 0C 00 84 E5 F4 FF FF EA 07 00 A0 E1 ?? ?? ?? ?? 00 00 65 E0 00 00 50 E3 0C 00 84 E5 D9 FF FF AA 08 30 94 E5 00 00 53 E3 03 30 80 C0 08 30 84 C5 D4 FF FF EA 00 80 FF FF }
	condition:
		$1
}

rule file_39_12_2 {
	meta:
		name = "__mingw_pformat"
		size = 2788
		refs = "00ac .text 0310 strlen 0534 _isnan 0568 __fpclassify 086c wcslen 0ad0 .rdata"
	strings:
		$1 = { F0 4F 2D E9 50 D0 4D E2 03 7A 00 E2 20 20 8D E5 00 00 E0 E3 03 20 A0 E3 00 80 A0 E3 24 20 8D E5 0C 10 8D E5 18 00 8D E5 10 70 8D E5 14 00 8D E5 1C 80 8D E5 00 00 D3 E5 0C 60 8D E2 0C 20 86 E2 74 50 9D E5 03 40 A0 E1 00 0C A0 E1 04 20 8D E5 40 0C B0 E1 87 00 00 0A 25 00 50 E3 01 A0 84 E2 7D 00 00 1A 00 90 E0 E3 10 70 8D E5 18 90 8D E5 14 90 8D E5 01 30 D4 E5 00 20 A0 E3 0A 40 A0 E1 08 C0 86 E2 02 10 A0 E1 03 0C A0 E1 00 00 53 E3 EE FF FF 0A 40 0C A0 E1 20 30 40 E2 01 40 84 E2 5A 00 53 E3 03 F1 9F 97 77 00 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 30 D4 E5 02 20 A0 E3 04 10 A0 E3 03 0C A0 E1 97 FF FF EA D0 30 D4 E1 6C 00 53 E3 02 20 A0 13 01 40 84 02 03 20 A0 03 10 30 9D E5 04 10 A0 E3 04 30 83 E3 10 30 8D E5 00 30 D4 E5 03 0C A0 E1 8B FF FF EA 06 10 A0 E1 93 FA FF EB 01 30 D4 E5 0A 40 A0 E1 03 0C A0 E1 40 0C B0 E1 77 FF FF 1A 1C 00 9D E5 50 D0 8D E2 F0 8F BD E8 00 00 51 E3 7F 01 00 0A 39 00 50 E3 00 30 A0 C3 01 30 A0 D3 03 00 51 E3 00 30 A0 83 00 00 53 E3 FD 01 00 0A 2F 00 50 E3 FB 01 00 DA 00 00 51 E3 01 10 A0 03 01 00 00 0A 02 00 51 E3 03 10 A0 03 00 00 5C E3 06 00 00 0A 00 30 9C E5 00 00 53 E3 A3 01 00 BA 30 00 40 E2 03 31 83 E0 83 30 80 E0 00 30 8C E5 00 30 D4 E5 03 0C A0 E1 65 FF FF EA 02 20 42 E2 01 00 52 E3 55 01 00 9A 00 A0 95 E5 00 00 5A E3 BD 01 00 0A 0A 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 0A 00 A0 E1 06 20 A0 E1 C5 FA FF EB 00 30 D4 E5 04 50 85 E2 03 0C A0 E1 46 FF FF EA 10 30 9D E5 78 00 A0 E3 02 3B 83 E3 10 30 8D E5 00 30 95 E5 4C 80 8D E5 48 30 8D E5 48 20 8D E2 06 00 92 E8 06 30 A0 E1 B1 FB FF EB 00 30 D4 E5 04 50 85 E2 03 0C A0 E1 37 FF FF EA 04 00 52 E3 05 30 A0 E1 7F 01 00 0A 01 00 52 E3 6A 01 00 0A 02 00 52 E3 01 00 00 0A 03 00 52 E3 BA 01 00 0A 00 30 93 E5 1C 20 9D E5 04 50 85 E2 00 20 83 E5 00 30 D4 E5 03 0C A0 E1 27 FF FF EA 00 30 D4 E5 03 20 A0 E3 04 10 A0 E3 03 0C A0 E1 31 FF FF EA 00 30 D4 E5 03 0C A0 E1 1A 03 50 E3 01 30 F4 05 04 20 A0 03 01 20 A0 13 04 10 A0 13 02 10 A0 01 03 0C A0 01 27 FF FF EA 10 30 9D E5 05 20 A0 E1 20 30 83 E3 10 30 8D E5 03 00 92 E8 06 20 A0 E1 99 FE FF EB 00 30 D4 E5 08 50 85 E2 03 0C A0 E1 0D FF FF EA 10 30 9D E5 05 20 A0 E1 20 30 83 E3 10 30 8D E5 03 00 92 E8 06 20 A0 E1 23 FD FF EB 00 30 D4 E5 08 50 85 E2 03 0C A0 E1 02 FF FF EA 10 30 9D E5 05 20 A0 E1 20 30 83 E3 10 30 8D E5 03 00 92 E8 06 20 A0 E1 E7 FC FF EB 00 30 D4 E5 08 50 85 E2 03 0C A0 E1 F7 FE FF EA 10 30 9D E5 03 00 52 E3 80 30 83 E3 10 30 8D E5 05 30 A0 E1 51 01 00 0A 02 00 52 E3 1C 01 00 0A 00 00 95 E5 01 00 52 E3 C0 1F A0 E1 4C 10 8D E5 04 50 85 E2 48 00 8D E5 5B 01 00 0A 04 00 52 E3 D8 24 DD 01 C2 3F A0 01 4C 30 8D 05 48 20 8D 05 48 10 8D E2 03 00 91 E8 06 20 A0 E1 BB FA FF EB 00 30 D4 E5 03 0C A0 E1 DC FE FF EA 02 20 42 E2 00 30 E0 E3 01 00 52 E3 18 30 8D E5 05 30 A0 E1 8D 00 00 9A 00 30 95 E5 50 00 8D E2 08 30 60 E5 01 10 A0 E3 84 FF FF EA 10 B0 9D E5 05 30 A0 E1 20 B0 8B E3 10 B0 8D E5 04 B0 1B E2 91 00 00 0A 00 06 93 E8 09 00 A0 E1 0A 10 A0 E1 38 90 8D E5 3C A0 8D E5 ?? ?? ?? ?? 00 00 50 E3 08 50 85 E2 00 00 A0 13 01 01 00 1A B0 B4 DD E1 09 00 A0 E1 02 39 1B E2 08 30 8D E5 10 30 9D 15 0A 10 A0 E1 80 30 83 13 10 30 8D 15 ?? ?? ?? ?? 05 0C 50 E3 0B B8 A0 E1 2D 01 00 0A 2B B8 A0 E1 8B B8 A0 E1 AB B8 A0 E1 00 00 5B E3 B0 B4 CD E1 CF 00 00 0A FF BD 4B E2 3F B0 4B E2 B0 B4 CD E1 38 30 8D E2 0F 00 93 E8 00 60 8D E5 FD FC FF EB 00 30 D4 E5 03 0C A0 E1 A5 FE FF EA 03 00 52 E3 05 30 A0 E1 F4 00 00 0A 02 00 52 E3 D3 00 00 0A 00 30 95 E5 01 00 52 E3 48 30 8D E5 04 50 85 E2 4C 80 8D E5 0A 01 00 0A 04 00 52 E3 48 20 DD 05 00 30 A0 03 4C 30 8D 05 48 20 8D 05 75 00 50 E3 AF FF FF 0A 06 30 A0 E1 48 20 8D E2 06 00 92 E8 05 FB FF EB 00 30 D4 E5 03 0C A0 E1 8C FE FF EA 01 00 51 E3 F0 00 00 9A 00 30 D4 E5 04 10 A0 E3 03 0C A0 E1 95 FE FF EA 00 00 51 E3 2A FF FF 1A 10 30 9D E5 01 3B 83 E3 10 30 8D E5 00 30 D4 E5 03 0C A0 E1 8D FE FF EA 00 00 51 E3 22 FF FF 1A 10 30 9D E5 01 3C 83 E3 10 30 8D E5 00 30 D4 E5 03 0C A0 E1 85 FE FF EA 00 00 5C E3 E9 FF FF 0A 01 B0 71 E2 00 B0 A0 33 02 00 51 E3 0B 00 A0 11 01 00 8B 03 00 00 50 E3 82 00 00 0A 00 30 95 E5 04 50 85 E2 00 00 53 E3 00 30 8C E5 E7 00 00 BA 00 30 D4 E5 00 C0 A0 E3 03 0C A0 E1 73 FE FF EA 06 10 A0 E1 7B F9 FF EB 00 30 D4 E5 03 0C A0 E1 5F FE FF EA 00 00 51 E3 03 FF FF 1A 10 30 9D E5 02 3B 83 E3 10 30 8D E5 00 30 D4 E5 03 0C A0 E1 66 FE FF EA 00 00 51 E3 FB FE FF 1A 10 30 9D E5 40 30 83 E3 10 30 8D E5 00 30 D4 E5 03 0C A0 E1 5E FE FF EA 05 20 A0 E1 43 FF FF EA 05 20 A0 E1 4C FF FF EA 00 30 E0 E3 18 30 8D E5 05 30 A0 E1 B0 30 D3 E1 48 00 8D E2 01 10 A0 E3 06 20 A0 E1 48 30 8D E5 4C 80 8D E5 72 F9 FF EB 00 30 D4 E5 04 50 85 E2 03 0C A0 E1 3D FE FF EA 10 B0 9D E5 05 30 A0 E1 04 B0 1B E2 6D FF FF 1A 00 06 93 E8 09 00 A0 E1 0A 10 A0 E1 28 90 8D E5 2C A0 8D E5 ?? ?? ?? ?? 00 00 50 E3 08 50 85 E2 6F 00 00 1A BE B2 DD E1 09 00 A0 E1 02 39 1B E2 08 30 8D E5 10 30 9D 15 0A 10 A0 E1 80 30 83 13 10 30 8D 15 ?? ?? ?? ?? 05 0C 50 E3 9D 00 00 0A 2C 30 9D E5 28 20 9D E5 03 34 A0 E1 22 3C 83 E1 2B B2 A0 E1 2C 30 8D E5 3E BB CB E3 BE 32 DD E1 B0 B3 CD E1 B0 13 DD E1 03 3A A0 E1 02 24 A0 E1 23 3A A0 E1 00 00 51 E3 28 20 8D E5 BE 32 CD E1 2E 00 00 0A FF 1F 41 E2 03 10 41 E2 01 28 A0 E1 22 28 A0 E1 02 18 A0 E1 7D 08 71 E3 01 3A 83 A2 BE 32 CD A1 B0 23 CD E1 28 30 8D E2 5D FF FF EA 00 30 D4 E5 03 0C A0 E1 40 2C A0 E1 36 00 52 E3 5C 00 00 0A 33 00 52 E3 27 00 00 0A 02 20 A0 E3 04 10 A0 E3 0E FE FF EA 05 20 A0 E1 E8 FE FF EA 04 A0 95 E4 6C 32 9F E5 00 00 5A E3 03 A0 A0 01 0A 00 A0 E1 ?? ?? ?? ?? 06 20 A0 E1 00 10 A0 E1 0A 00 A0 E1 24 F9 FF EB 00 30 D4 E5 03 0C A0 E1 F0 FD FF EA 10 30 9D E5 02 3C 83 E3 10 30 8D E5 00 30 D4 E5 03 0C A0 E1 F9 FD FF EA 00 30 D4 E5 00 C0 A0 E1 04 10 A0 E3 03 0C A0 E1 F4 FD FF EA 2C 30 9D E5 03 30 92 E1 0C 32 9F 15 B0 33 CD 11 28 30 8D E2 33 FF FF EA 3C 30 9D E5 38 20 9D E5 03 30 92 E1 2E FF FF 0A 2A FF FF EA D1 20 D4 E1 32 00 52 E3 D4 FF FF 1A 02 30 F4 E5 02 20 A0 E3 04 10 A0 E3 03 0C A0 E1 E1 FD FF EA 00 20 95 E5 04 50 85 E2 C2 3F A0 E1 4C 30 8D E5 48 20 8D E5 E8 FE FF EA 00 30 95 E5 04 50 85 E2 48 30 8D E5 4C 80 8D E5 31 FF FF EA 00 30 95 E5 BC 21 DD E1 04 50 85 E2 B0 20 C3 E1 00 30 D4 E5 03 0C A0 E1 C0 FD FF EA 0B 00 A0 E1 80 11 9F E5 06 20 A0 E1 6E F9 FF EB 00 30 D4 E5 03 0C A0 E1 B9 FD FF EA 30 00 40 E2 00 00 8C E5 00 30 D4 E5 03 0C A0 E1 C3 FD FF EA 00 30 95 E5 1C 20 9D E5 04 50 85 E2 00 20 C3 E5 00 30 D4 E5 03 0C A0 E1 AD FD FF EA 00 20 95 E5 08 50 85 E2 48 20 8D E5 04 30 93 E5 4C 30 8D E5 11 FF FF EA D1 20 D4 E1 34 00 52 E3 A1 FF FF 1A 02 30 F4 E5 03 20 A0 E3 04 10 A0 E3 03 0C A0 E1 AE FD FF EA 00 20 95 E5 08 50 85 E2 48 20 8D E5 04 30 93 E5 4C 30 8D E5 B5 FE FF EA 00 30 A0 E3 18 30 8D E5 00 30 D4 E5 04 C0 9D E5 02 10 A0 E3 03 0C A0 E1 A1 FD FF EA 06 10 A0 E3 CC A0 9F E5 41 FE FF EA B8 34 DD E1 48 30 8D E5 F6 FE FF EA F8 24 DD E1 C2 3F A0 E1 4C 30 8D E5 48 20 8D E5 A3 FE FF EA 08 00 9D E5 A4 10 9F E5 06 20 A0 E1 35 F9 FF EB 00 30 D4 E5 03 0C A0 E1 80 FD FF EA 00 00 5B E3 19 00 00 0A 10 10 9D E5 14 30 9D E5 01 1B 81 E3 00 30 63 E2 10 10 8D E5 14 30 8D E5 00 30 D4 E5 00 C0 A0 E3 0C 10 A0 E1 03 0C A0 E1 82 FD FF EA 1C 10 9D E5 00 30 95 E5 C1 2F A0 E1 06 00 83 E8 00 30 D4 E5 04 50 85 E2 03 0C A0 E1 6B FD FF EA 25 00 A0 E3 06 10 A0 E1 81 F8 FF EB 00 30 DA E5 0A 40 A0 E1 03 0C A0 E1 64 FD FF EA 18 90 8D E5 00 30 D4 E5 0B C0 A0 E1 03 0C A0 E1 6E FD FF EA ?? ?? ?? ?? 01 FC FF FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_40_0_2 {
	meta:
		name = "scalbn"
		size = 392
		refs = "0038 __muldf3 00ec __adddf3"
	strings:
		$1 = { 4C 31 9F E5 F0 40 2D E9 03 30 01 E0 43 7A B0 E1 00 50 A0 E1 01 60 A0 E1 01 C0 A0 E1 02 40 A0 E1 1B 00 00 1A 02 C1 C1 E3 00 C0 9C E1 16 00 00 0A 00 20 A0 E3 1C 31 9F E5 ?? ?? ?? ?? 18 C1 9F E5 0C 00 54 E1 20 00 00 BA 04 71 9F E5 0C 31 9F E5 07 70 01 E0 47 7A A0 E1 36 70 47 E2 04 70 87 E0 03 00 57 E1 01 C0 A0 E1 10 00 00 DA 00 00 51 E3 EC 00 9F E5 EC 10 9F E5 E4 00 9F B5 E8 10 9F B5 DC 20 9F E5 DC 30 9F E5 ?? ?? ?? ?? 01 40 A0 E1 F0 80 BD E8 D4 30 9F E5 03 00 57 E1 0F 00 00 0A B8 30 9F E5 04 70 87 E0 03 00 57 E1 EE FF FF CA 00 00 57 E3 0F 00 00 DA 7F C4 CC E3 0F C6 CC E3 07 1A 8C E1 01 40 A0 E1 F0 80 BD E8 A0 20 9F E5 A0 30 9F E5 ?? ?? ?? ?? 01 40 A0 E1 F0 80 BD E8 00 20 A0 E1 01 30 A0 E1 01 50 A0 E1 ?? ?? ?? ?? 01 40 A0 E1 F0 80 BD E8 35 00 77 E3 0B 00 00 AA 74 30 9F E5 03 00 54 E1 D7 FF FF CA 00 00 51 E3 5C 00 9F E5 5C 10 9F E5 54 00 9F B5 5C 10 9F B5 4C 20 9F E5 4C 30 9F E5 ?? ?? ?? ?? D6 FF FF EA 7F C4 CC E3 36 70 87 E2 0F C6 CC E3 07 4A 8C E1 04 10 A0 E1 00 20 A0 E3 34 30 9F E5 ?? ?? ?? ?? CD FF FF EA 00 00 F0 7F 00 00 50 43 B0 3C FF FF FE 07 00 00 9C 75 00 88 3C E4 37 7E 3C E4 37 FE FF 07 00 00 59 F3 F8 C2 1F 6E A5 01 50 C3 00 00 1F 6E A5 81 00 00 90 3C }
	condition:
		$1
}

rule file_41_0_2 {
	meta:
		name = "__ieee754_coshf"
		size = 340
		refs = "0054 __mulsf3 0068 expm1f 0074 __addsf3 00a8 __divsf3 00c0 __ieee754_expf 0150 .data"
	strings:
		$1 = { 34 31 9F E5 70 40 2D E9 02 41 C0 E3 03 00 54 E1 00 10 A0 E1 0E 00 00 CA 20 31 9F E5 03 00 54 E1 0F 00 00 DA 18 31 9F E5 03 00 54 E1 22 00 00 DA 10 31 9F E5 03 00 54 E1 2D 00 00 DA 08 31 9F E5 03 00 54 E1 30 00 00 DA 00 31 9F E5 00 00 93 E5 00 10 93 E5 ?? ?? ?? ?? 00 50 A0 E1 05 00 A0 E1 70 80 BD E8 02 01 C0 E3 ?? ?? ?? ?? FE 15 A0 E3 00 60 A0 E1 ?? ?? ?? ?? 77 03 74 E3 00 50 A0 E1 F5 FF FF DA 06 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 00 40 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 00 50 A0 E1 E7 FF FF EA 02 01 C0 E3 ?? ?? ?? ?? 3F 14 A0 E3 00 50 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 00 40 A0 E1 3F 04 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 50 A0 E1 D9 FF FF EA 02 01 C0 E3 ?? ?? ?? ?? 3F 14 A0 E3 ?? ?? ?? ?? 00 50 A0 E1 D3 FF FF EA 3F 14 A0 E3 02 01 C0 E3 ?? ?? ?? ?? ?? ?? ?? ?? 3F 14 A0 E3 00 40 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 50 A0 E1 C7 FF FF EA FF FF 7F 7F 17 72 B1 3E FF FF AF 41 7F 71 B1 42 FC D4 B2 42 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_42_0_2 {
	meta:
		name = "expm1"
		size = 1620
		refs = "0094 __muldf3 00d0 __adddf3 00e8 __subdf3 01a8 __divdf3 026c __gtdf2 029c __ltdf2 02d0 __fixdfsi 02d8 __floatsidf"
	strings:
		$1 = { F0 4D 2D E9 B4 C5 9F E5 02 31 C1 E3 0C 00 53 E1 10 D0 4D E2 00 40 A0 E1 01 50 A0 E1 02 61 01 E2 10 00 00 9A 98 C5 9F E5 0C 00 53 E1 91 00 00 9A 90 C5 9F E5 0C 00 53 E1 89 00 00 9A FF 24 C1 E3 0F 26 C2 E3 00 20 92 E1 00 70 A0 E1 01 80 A0 E1 54 01 00 1A 00 00 56 E3 CF 00 00 0A 00 40 A0 E3 64 55 9F E5 CC 00 00 EA 60 25 9F E5 02 00 53 E1 D2 00 00 8A 58 25 9F E5 02 00 53 E1 00 60 A0 83 EC 00 00 9A 00 20 A0 E3 48 35 9F E5 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 A0 A0 E1 01 B0 A0 E1 0A 20 A0 E1 0B 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 20 25 9F E5 20 35 9F E5 00 70 A0 E1 01 80 A0 E1 ?? ?? ?? ?? 14 25 9F E5 14 35 9F E5 ?? ?? ?? ?? 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? 04 25 9F E5 04 35 9F E5 ?? ?? ?? ?? 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? F4 24 9F E5 F4 34 9F E5 ?? ?? ?? ?? 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? E4 24 9F E5 E4 34 9F E5 ?? ?? ?? ?? 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E3 D0 34 9F E5 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 03 00 8D E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 00 00 A0 E3 B0 14 9F E5 ?? ?? ?? ?? 00 A0 A0 E1 01 B0 A0 E1 0A 20 A0 E1 03 00 9D E8 0B 30 A0 E1 ?? ?? ?? ?? 0A 20 A0 E1 03 00 8D E8 0B 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 00 00 A0 E3 70 14 9F E5 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 03 00 9D E8 ?? ?? ?? ?? 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? 00 00 56 E3 00 20 A0 E1 01 30 A0 E1 67 00 00 0A 08 30 8D E2 0C 00 93 E8 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 08 30 8D E2 0C 00 93 E8 ?? ?? ?? ?? 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? 01 00 76 E3 00 70 A0 E1 01 80 A0 E1 B1 00 00 0A 01 00 56 E3 98 00 00 0A 01 30 86 E2 39 00 53 E3 76 00 00 8A 13 00 56 E3 B8 00 00 CA 02 36 A0 E3 53 36 A0 E1 04 20 A0 E1 FF 85 63 E2 05 30 A0 E1 ?? ?? ?? ?? 00 70 A0 E3 03 86 88 E2 00 20 A0 E1 01 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 06 5A 81 E0 4D 00 00 EA A4 23 9F E5 A4 33 9F E5 ?? ?? ?? ?? 00 00 50 E3 B5 00 00 CA 00 00 56 E3 4C 00 00 0A 90 23 9F E5 90 33 9F E5 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 6C FF FF BA 70 73 9F E5 00 60 A0 E3 6C 23 9F E5 6C 33 9F E5 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 00 60 A0 E1 ?? ?? ?? ?? 48 23 9F E5 48 33 9F E5 00 A0 A0 E1 01 B0 A0 E1 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 30 23 9F E5 00 70 A0 E1 01 80 A0 E1 0A 00 A0 E1 0B 10 A0 E1 20 33 9F E5 ?? ?? ?? ?? 00 A0 A0 E1 01 B0 A0 E1 0A 20 A0 E1 0B 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 04 20 A0 E1 05 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? 08 00 8D E5 0C 10 8D E5 46 FF FF EA 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 04 00 A0 E1 05 10 A0 E1 10 D0 8D E2 F0 8D BD E8 00 00 56 E3 BC FF FF 1A 00 60 A0 E3 18 72 9F E5 BB FF FF EA 74 22 9F E5 02 00 53 E1 F7 FF FF 8A 00 00 56 E3 1E 00 00 1A 50 22 9F E5 60 32 9F E5 ?? ?? ?? ?? 01 60 A0 E3 48 A2 9F E5 48 B2 9F E5 00 70 A0 E1 01 80 A0 E1 C9 FF FF EA 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 00 00 A0 E3 EC 11 9F E5 ?? ?? ?? ?? 06 4A 81 E0 04 10 A0 E1 00 20 A0 E3 D8 31 9F E5 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 D8 FF FF EA 04 22 9F E5 04 32 9F E5 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 CA FF FF EA D4 21 9F E5 E4 31 9F E5 ?? ?? ?? ?? 00 60 E0 E3 CC A1 9F E5 E0 B1 9F E5 00 70 A0 E1 01 80 A0 E1 AA FF FF EA 04 00 A0 E1 05 10 A0 E1 00 20 A0 E3 C8 31 9F E5 ?? ?? ?? ?? 00 00 50 E3 37 00 00 AA 04 00 A0 E1 05 10 A0 E1 00 20 A0 E3 34 31 9F E5 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E3 03 31 A0 E3 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 B2 FF FF EA 04 00 A0 E1 05 10 A0 E1 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E3 E8 30 9F E5 ?? ?? ?? ?? 00 20 A0 E3 DC 30 9F E5 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 A4 FF FF EA FF 3F 66 E2 03 30 83 E2 00 70 A0 E3 03 8A A0 E1 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E3 C0 30 9F E5 ?? ?? ?? ?? 00 40 A0 E1 06 5A 81 E0 92 FF FF EA EC 00 9F E5 EC 10 9F E5 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 8A FF FF EA 04 00 A0 E1 05 10 A0 E1 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E3 68 30 9F E5 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 7C FF FF EA 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 76 FF FF EA 79 68 43 40 41 2E 86 40 FF FF EF 7F 00 00 F0 BF 42 2E D6 3F FF FF 8F 3C 00 00 E0 3F 2D C3 09 6E B7 FD 8A BE 39 52 E6 86 CA CF D0 3E B7 DB AA 9E 19 CE 14 3F 85 55 FE 19 A0 01 5A 3F F4 10 11 11 11 11 A1 3F 00 00 F0 3F 00 00 08 40 00 00 18 40 EF 39 FA FE 42 2E 86 40 59 F3 F8 C2 1F 6E A5 01 00 00 E0 BF FE 82 2B 65 47 15 F7 3F 00 00 E0 FE 42 2E E6 BF 76 3C 79 35 EF 39 EA 3D B1 A2 F0 3F 42 2E E6 3F 9C 75 00 88 3C E4 37 7E EF 39 EA BD 00 00 D0 BF }
	condition:
		$1
}

rule file_43_0_2 {
	meta:
		name = "basename"
		size = 496
		refs = "0030 wcstombs 0040 realloc 0070 mbstowcs 01e4 .bss 01e8 .rdata"
	strings:
		$1 = { F0 49 2D E9 00 60 50 E2 18 B0 8D E2 02 00 00 0A D0 30 D6 E1 00 00 53 E3 11 00 00 1A C0 41 9F E5 00 00 A0 E3 00 20 A0 E1 B8 11 9F E5 00 50 94 E5 ?? ?? ?? ?? 01 60 80 E2 06 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 06 20 A0 E1 98 11 9F E5 00 00 84 E5 ?? ?? ?? ?? 00 60 94 E5 06 00 A0 E1 18 D0 4B E2 F0 89 BD E8 00 00 A0 E3 06 10 A0 E1 00 20 A0 E1 ?? ?? ?? ?? 80 30 A0 E1 0C 30 83 E2 03 30 C3 E3 0D 80 A0 E1 03 D0 4D E0 07 70 8D E2 07 70 C7 E3 00 20 A0 E1 06 10 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 01 00 50 E3 03 00 00 9A B2 30 D7 E1 3A 00 53 E3 04 30 87 02 00 00 00 0A 07 30 A0 E1 80 20 A0 E1 00 10 A0 E3 B2 10 87 E1 B0 40 D3 E1 00 00 54 E3 30 00 00 0A 03 50 A0 E1 02 00 00 EA B2 40 F3 E1 00 00 54 E3 18 00 00 0A 2F 00 54 E3 5C 00 54 13 F9 FF FF 1A 03 00 00 1A B2 40 F3 E1 2F 00 54 E3 5C 00 54 13 FB FF FF 0A 00 00 54 E3 03 50 A0 11 F1 FF FF 1A 05 00 53 E1 EF FF FF 9A B2 10 73 E1 2F 00 51 E3 01 00 00 0A 5C 00 51 E3 EA FF FF 1A 00 20 A0 E3 05 00 53 E1 B0 20 C3 E1 F6 FF FF 8A B2 40 F3 E1 00 00 54 E3 E6 FF FF 1A B0 30 D5 E1 00 00 53 E3 11 00 00 0A 00 20 A0 E1 07 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 01 00 70 E3 00 40 C6 17 00 30 A0 E3 00 00 A0 E3 B0 30 C5 E1 07 10 A0 E1 00 20 A0 E1 ?? ?? ?? ?? 01 00 70 E3 00 60 86 10 08 D0 A0 E1 AF FF FF EA 08 D0 A0 E1 9E FF FF EA 3C 40 9F E5 03 20 A0 E1 03 00 A0 E1 38 10 9F E5 00 50 94 E5 ?? ?? ?? ?? 01 70 80 E2 07 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 07 20 A0 E1 18 10 9F E5 00 00 84 E5 00 60 A0 E1 ?? ?? ?? ?? 08 D0 A0 E1 9C FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_0_2 {
	meta:
		name = "copysignf"
		size = 16
	strings:
		$1 = { 02 11 01 E2 02 01 C0 E3 00 00 81 E1 0E F0 A0 E1 }
	condition:
		$1
}

rule file_46_0_2 {
	meta:
		name = "time"
		size = 64
		refs = "0018 GetSystemTime 0024 SystemTimeToFileTime 002c __FILETIME_to_time_t"
	strings:
		$1 = { 70 40 2D E9 1C D0 4D E2 00 50 50 E2 10 40 8D E2 0D 00 A0 E1 18 50 8D 02 ?? ?? ?? ?? 04 10 A0 E1 0D 00 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 ?? ?? ?? ?? 0D 60 A0 E1 00 00 85 E5 1C D0 8D E2 70 80 BD E8 }
	condition:
		$1
}

rule file_47_0_2 {
	meta:
		name = "bsearch"
		size = 112
	strings:
		$1 = { F0 47 2D E9 00 00 52 E3 00 40 A0 E1 03 80 A0 E1 20 90 9D E5 12 00 00 0A 01 A0 A0 E1 02 70 A0 E1 05 00 00 EA 01 50 47 C2 A5 50 A0 C1 08 A0 86 C0 00 00 55 E3 0A 00 00 0A 05 70 A0 E1 A7 50 A0 E1 98 A5 26 E0 04 00 A0 E1 06 10 A0 E1 0F E0 A0 E1 09 F0 A0 E1 00 00 50 E3 F1 FF FF 1A 06 00 A0 E1 F0 87 BD E8 00 60 A0 E3 06 00 A0 E1 F0 87 BD E8 }
	condition:
		$1
}

rule file_49_0_2 {
	meta:
		name = "rintf"
		size = 232
		refs = "0060 __addsf3 0068 __subsf3 00e4 .rdata"
	strings:
		$1 = { C0 2B A0 E1 FF 20 02 E2 7F 20 42 E2 16 00 52 E3 30 40 2D E9 00 10 A0 E1 00 30 A0 E1 15 00 00 CA 00 00 52 E3 A0 4F A0 E1 18 00 00 BA AC 00 9F E5 50 02 A0 E1 01 00 10 E1 0C 00 00 0A A0 00 A0 E1 01 00 10 E1 00 00 C1 11 01 36 A0 13 53 32 80 11 03 10 A0 E1 88 30 9F E5 04 41 93 E7 04 00 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 01 00 A0 E1 30 80 BD E8 80 00 52 E3 FB FF FF 1A ?? ?? ?? ?? 00 10 A0 E1 01 00 A0 E1 30 80 BD E8 02 21 C0 E3 00 00 52 E3 F4 FF FF 0A FF 24 C0 E3 02 25 C2 E3 00 10 62 E2 34 20 9F E5 20 3A A0 E1 04 51 92 E7 A1 14 A0 E1 03 3A A0 E1 01 15 01 E2 03 10 81 E1 05 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 02 11 C0 E3 84 1F 81 E1 E3 FF FF EA FF FF 7F 00 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_53_0_2 {
	meta:
		name = "trunc"
		size = 280
		refs = "005c __adddf3 0068 __gtdf2"
	strings:
		$1 = { F0 41 2D E9 41 7A A0 E1 87 7A A0 E1 A7 7A A0 E1 FF 7F 47 E2 03 70 47 E2 13 00 57 E3 00 20 A0 E1 01 30 A0 E1 00 40 A0 E1 01 50 A0 E1 01 60 A0 E1 00 80 A0 E1 14 00 00 CA 00 00 57 E3 28 00 00 BA C4 C0 9F E5 5C 77 A0 E1 01 C0 07 E0 00 C0 9C E1 0A 00 00 0A B4 20 9F E5 B4 30 9F E5 ?? ?? ?? ?? 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 07 60 C5 C1 00 40 A0 C3 06 30 A0 E1 04 20 A0 E1 02 00 A0 E1 03 10 A0 E1 F0 81 BD E8 33 00 57 E3 05 00 00 DA 01 0B 57 E3 F8 FF FF 1A ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 F4 FF FF EA 14 70 47 E2 00 C0 E0 E3 3C 77 A0 E1 00 00 17 E1 EF FF FF 0A 48 20 9F E5 48 30 9F E5 ?? ?? ?? ?? 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 07 40 C4 C1 E4 FF FF EA 24 20 9F E5 24 30 9F E5 ?? ?? ?? ?? 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 02 61 05 C2 00 40 A0 C3 DA FF FF EA FF FF 0F 00 9C 75 00 88 3C E4 37 7E }
	condition:
		$1
}

rule file_54_0_2 {
	meta:
		name = "hypotf"
		size = 56
		refs = "0008 __extendsfdf2 002c _hypot 0030 __truncdfsf2"
	strings:
		$1 = { 70 40 2D E9 01 60 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 06 00 A0 E1 01 50 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 70 80 BD E8 }
	condition:
		$1
}

rule file_55_0_2 {
	meta:
		name = "__g_ffmt"
		size = 348
		refs = "0044 __eqsf2 00dc __gdtoa 00f8 __g__fmt 0128 __strcp_D2A 0150 .data 0154 .rdata"
	strings:
		$1 = { F0 41 2D E9 C2 4F C2 E1 03 50 A0 E1 0A 30 84 E2 05 00 53 E1 20 D0 4D E2 00 60 A0 E1 15 00 00 8A 00 80 91 E5 20 31 9F E5 1C 21 9F E5 03 30 08 E0 02 00 53 E1 02 71 08 E2 30 00 00 0A 00 00 91 E5 00 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 0B 00 00 1A 00 00 58 E3 2D 30 A0 B3 01 30 C6 B4 06 00 A0 E1 30 30 A0 E3 01 30 C0 E4 00 30 A0 E3 01 30 C6 E5 20 D0 8D E2 F0 81 BD E8 00 00 A0 E3 FB FF FF EA A8 1B A0 E1 FF 84 C8 E3 FF 10 11 E2 02 85 C8 E3 18 80 8D E5 02 85 88 13 94 10 E0 03 18 80 8D 15 96 10 41 12 00 00 54 E3 02 C0 A0 13 1F 00 00 0A 00 C0 8D E5 14 C0 8D E2 18 20 8D E2 10 30 8D E2 01 E0 A0 E3 08 C0 8D E5 80 00 9F E5 1C C0 8D E2 10 E0 8D E5 04 40 8D E5 0C C0 8D E5 ?? ?? ?? ?? 1C 20 9D E5 00 10 A0 E1 14 30 9D E5 06 00 A0 E1 00 70 8D E5 04 50 8D E5 ?? ?? ?? ?? DB FF FF EA FF 84 C8 E3 02 85 C8 E3 00 00 58 E3 0B 00 00 1A 00 00 57 E3 06 00 A0 11 2D 30 A0 13 00 00 A0 01 01 30 C0 14 28 10 9F E5 ?? ?? ?? ?? CF FF FF EA 0F 00 55 E3 CF FF FF 9A 04 C0 A0 E1 DB FF FF EA 10 10 9F E5 ?? ?? ?? ?? C8 FF FF EA 00 00 80 7F ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_56_0_2 {
	meta:
		name = "__kernel_rem_pio2f"
		size = 2296
		refs = "0090 __floatsisf 00f8 __mulsf3 0104 __addsf3 0188 __fixsfsi 01d4 scalbnf 01e4 floorf 0214 __subsf3 0308 __eqsf2 04c8 __gesf2 0628 .text 08e8 .rdata"
	strings:
		$1 = { F0 4F 2D E9 17 DE 4D E2 1C 30 8D E5 94 E1 9D E5 D0 38 9F E5 03 C0 52 E2 0E 31 93 E7 04 C0 82 42 14 30 8D E5 1C 30 9D E5 CC C1 A0 E1 01 30 43 E2 CC CF CC E1 04 30 8D E5 24 C0 8D E5 0C 30 E0 E1 04 E0 9D E5 14 C0 9D E5 83 31 82 E0 0E A0 9C E0 10 30 8D E5 00 70 A0 E1 18 10 8D E5 11 00 00 4A 24 00 9D E5 98 11 9D E5 00 40 6E E0 0A A0 84 E0 04 61 81 E0 00 50 A0 E3 D0 80 8D E2 00 00 00 EA 01 40 84 E2 00 00 54 E3 00 00 A0 B3 00 00 96 A5 ?? ?? ?? ?? 0A 00 54 E1 05 00 88 E7 04 60 86 E2 04 50 85 E2 F5 FF FF 1A 14 20 9D E5 00 00 52 E3 1E 00 00 BA 1C 30 9D E5 30 C0 8D E2 04 A0 9D E5 03 B0 82 E0 00 90 A0 E3 00 C0 8D E5 03 81 A0 E1 04 00 9D E5 00 00 50 E3 00 50 A0 B3 0D 00 00 BA D0 10 8D E2 0A 61 81 E0 00 40 A0 E3 00 50 A0 E3 04 00 97 E7 04 10 16 E4 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 04 40 84 E2 08 00 54 E1 00 50 A0 E1 F5 FF FF 1A 01 A0 8A E2 00 E0 9D E5 0B 00 5A E1 09 50 8E E7 04 90 89 E2 E7 FF FF 1A 14 20 9D E5 17 CE 8D E2 01 30 42 E2 03 31 8C E0 12 EE 8D E2 50 30 43 E2 02 E1 8E E0 2C 30 8D E5 02 B0 A0 E1 28 E0 8D E5 0B 91 A0 E1 17 0E 8D E2 09 30 80 E0 00 00 5B E3 40 41 13 E5 16 00 00 DA 30 A0 8D E2 09 60 8A E0 00 50 A0 E3 EE 15 A0 E3 04 00 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 54 17 9F E5 00 80 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 12 2E 8D E2 05 00 82 E7 04 10 36 E5 08 00 A0 E1 ?? ?? ?? ?? 0A 00 56 E1 00 40 A0 E1 04 50 85 E2 EB FF FF 1A 04 00 A0 E1 10 10 9D E5 ?? ?? ?? ?? 3E 14 A0 E3 00 40 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? C1 14 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 ?? ?? ?? ?? 00 80 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 10 30 9D E5 00 50 A0 E1 00 00 53 E3 99 00 00 DA 01 10 4B E2 17 CE 8D E2 01 11 8C E0 50 00 11 E5 08 20 63 E2 50 32 A0 E1 13 22 40 E0 10 E0 9D E5 50 20 01 E5 07 60 6E E2 52 66 A0 E1 03 80 88 E0 00 00 56 E3 27 00 00 DA 00 00 5B E3 01 80 88 E2 00 40 A0 D3 14 00 00 DA 00 30 A0 E3 03 40 A0 E1 06 00 00 EA 00 00 52 E3 01 2C 62 12 03 20 81 17 04 30 83 E2 01 40 A0 13 09 00 53 E1 0A 00 00 0A 12 1E 8D E2 00 00 54 E3 03 20 91 E7 F4 FF FF 0A FF 20 62 E2 12 CE 8D E2 03 20 8C E7 04 30 83 E2 09 00 53 E1 01 40 A0 E3 F4 FF FF 1A 10 E0 9D E5 00 00 5E E3 09 00 00 DA 01 00 5E E3 73 00 00 0A 02 00 5E E3 05 00 00 1A 01 30 4B E2 17 1E 8D E2 03 31 81 E0 50 20 13 E5 3F 20 02 E2 50 20 03 E5 02 00 56 E3 55 00 00 0A 05 00 A0 E1 00 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 44 01 00 1A 14 20 9D E5 01 00 4B E2 00 00 52 E1 09 00 00 CA 12 CE 8D E2 09 30 8C E0 28 C0 9D E5 00 20 A0 E3 04 10 33 E5 0C 00 53 E1 01 20 82 E1 FB FF FF 1A 00 00 52 E3 64 00 00 1A 2C E0 9D E5 00 30 9E E5 00 00 53 E3 01 20 A0 13 06 00 00 1A 28 30 9D E5 01 20 A0 E3 08 10 13 E5 01 20 82 E2 00 00 51 E3 04 30 43 E2 FA FF FF 0A 0B 20 82 E0 02 00 5B E1 20 20 8D E5 30 00 00 AA 24 00 9D E5 1C 10 9D E5 01 20 80 E2 01 30 8B E0 0B B0 82 E0 D0 20 8D E2 0C 20 8D E5 20 00 9D E5 30 20 8D E2 98 C1 9D E5 0C E0 9D E5 09 90 82 E0 01 00 80 E0 00 90 8D E5 0B B1 8C E0 03 A0 A0 E1 03 91 8E E0 08 00 8D E5 01 81 A0 E1 00 00 9B E5 ?? ?? ?? ?? 04 10 9D E5 00 00 89 E5 00 00 51 E3 00 50 A0 B3 0D 00 00 BA 0C 20 9D E5 00 50 A0 E3 0A 61 82 E0 00 40 A0 E3 04 00 97 E7 04 10 16 E4 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 04 40 84 E2 08 00 54 E1 00 50 A0 E1 F5 FF FF 1A 00 C0 9D E5 08 30 9D E5 01 A0 8A E2 04 50 AC E5 03 00 5A E1 00 C0 8D E5 04 B0 8B E2 04 90 89 E2 E1 FF FF 1A 20 B0 9D E5 3F FF FF EA 05 10 A0 E1 FE 05 A0 E3 ?? ?? ?? ?? 00 00 54 E3 00 50 A0 E1 A3 FF FF 0A 10 10 9D E5 FE 05 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 50 A0 E1 9B FF FF EA 0B 00 00 1A 17 0E 8D E2 0B 31 80 E0 54 60 13 E5 46 64 A0 E1 6B FF FF EA 01 30 4B E2 17 0E 8D E2 03 31 80 E0 50 20 13 E5 7F 20 02 E2 50 20 03 E5 8C FF FF EA 3F 14 A0 E3 ?? ?? ?? ?? 00 00 50 E3 00 60 A0 B3 02 60 A0 A3 60 FF FF AA 87 FF FF EA 00 31 A0 E1 17 1E 8D E2 03 20 81 E0 10 C0 9D E5 50 20 12 E5 08 C0 4C E2 00 00 52 E3 40 01 8D E9 10 C0 8D E5 00 B0 A0 11 09 00 00 1A 12 EE 8D E2 10 20 9D E5 03 30 8E E0 00 B0 A0 E1 04 10 33 E5 01 B0 4B E2 00 00 51 E3 08 20 42 E2 FA FF FF 0A 10 20 8D E5 10 10 9D E5 FE 05 A0 E3 ?? ?? ?? ?? 00 00 5B E3 00 50 A0 E1 32 00 00 BA 0B 61 A0 E1 30 E0 8D E2 12 4E 8D E2 06 40 84 E0 00 E0 8D E5 06 60 8E E0 47 7F 8D E2 04 00 14 E4 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? EE 15 A0 E3 04 00 06 E4 05 00 A0 E1 ?? ?? ?? ?? 07 00 54 E1 00 50 A0 E1 F4 FF FF 1A 54 83 9F E5 14 90 9D E5 0B A0 A0 E1 00 70 A0 E3 00 00 59 E3 9C 00 00 BA 00 00 57 E3 9A 00 00 BA 00 10 9D E5 00 60 A0 E3 0A 51 81 E0 00 40 A0 E3 02 00 00 EA 07 00 54 E1 04 50 85 E2 09 00 00 CA 04 01 98 E7 00 10 95 E5 ?? ?? ?? ?? 00 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 01 40 84 E2 04 00 59 E1 00 60 A0 E1 F2 FF FF AA 01 A0 4A E2 17 0E 8D E2 07 31 80 E0 01 00 7A E3 F0 60 03 E5 01 70 87 E2 E2 FF FF 1A 94 21 9D E5 03 00 52 E3 02 F1 9F 97 10 00 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 A0 E3 04 10 9D E5 00 00 51 E3 A0 00 00 0A 80 20 9D E5 84 30 9D E5 18 E0 9D E5 02 21 82 E2 02 31 83 E2 02 01 80 E2 08 00 8E E5 00 20 8E E5 04 30 8E E5 08 10 9D E5 07 00 01 E2 17 DE 8D E2 F0 8F BD E8 00 00 5B E3 EC FF FF DA 0B 91 A0 E1 17 CE 8D E2 09 30 8C E0 80 60 8D E2 09 50 86 E0 F0 70 13 E5 05 40 A0 E1 04 A0 14 E5 07 10 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 00 80 A0 E1 08 10 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 07 10 A0 E1 ?? ?? ?? ?? 00 00 84 E5 04 80 24 E5 06 00 54 E1 08 70 A0 E1 F0 FF FF 1A 01 00 5B E3 D4 FF FF DA 17 EE 8D E2 09 90 8E E0 01 40 4B E2 F0 70 19 E5 04 41 86 E0 00 A0 94 E5 07 00 A0 E1 0A 10 A0 E1 ?? ?? ?? ?? 00 80 A0 E1 08 10 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 04 00 84 E5 04 80 04 E4 06 00 54 E1 08 70 A0 E1 EF FF FF 1A 00 00 A0 E3 04 40 84 E2 04 10 15 E4 ?? ?? ?? ?? 04 00 55 E1 FB FF FF 1A B9 FF FF EA 00 00 5B E3 00 00 A0 B3 07 00 00 BA 80 40 8D E2 00 00 A0 E3 0B 41 84 E0 7C 50 8D E2 04 10 14 E4 ?? ?? ?? ?? 05 00 54 E1 FB FF FF 1A 04 E0 9D E5 18 10 9D E5 00 00 5E E3 00 30 A0 01 02 31 80 12 00 30 81 E5 00 10 A0 E1 80 00 9D E5 ?? ?? ?? ?? 00 00 5B E3 05 00 00 DA 80 40 8D E2 0B B1 84 E0 04 10 B4 E5 ?? ?? ?? ?? 0B 00 54 E1 FB FF FF 1A 04 20 9D E5 18 30 9D E5 00 00 52 E3 02 01 80 12 04 00 83 E5 A3 FF FF EA 00 00 5B E3 00 00 A0 B3 07 00 00 BA 80 30 8D E2 00 00 A0 E3 0B B1 83 E0 7C 40 8D E2 04 10 1B E4 ?? ?? ?? ?? 04 00 5B E1 FB FF FF 1A 04 30 9D E5 18 C0 9D E5 00 00 53 E3 02 01 80 12 00 00 8C E5 92 FF FF EA 00 60 A0 E3 74 FF FF EA 10 E0 9D E5 05 00 A0 E1 00 10 6E E2 40 01 8D E9 ?? ?? ?? ?? B0 10 9F E5 00 40 A0 E1 ?? ?? ?? ?? 00 00 50 E3 18 00 00 BA EE 15 A0 E3 04 00 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 80 10 9F E5 00 50 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 17 1E 8D E2 09 90 81 E0 50 00 09 E5 05 00 A0 E1 ?? ?? ?? ?? 01 B0 8B E2 17 2E 8D E2 0B 31 82 E0 50 00 03 E5 10 30 9D E5 08 30 83 E2 10 30 8D E5 1F FF FF EA 04 00 A0 E1 ?? ?? ?? ?? 17 CE 8D E2 09 90 8C E0 50 00 09 E5 19 FF FF EA 80 20 9D E5 84 30 9D E5 18 C0 9D E5 08 00 8C E5 00 20 8C E5 04 30 8C E5 60 FF FF EA ?? ?? ?? ?? 00 00 80 C3 ?? ?? ?? ?? 00 00 80 43 }
	condition:
		$1
}

rule file_57_0_2 {
	meta:
		name = "cbrt"
		size = 568
		refs = "0070 __muldf3 007c __divdf3 0094 __adddf3 0140 __subdf3"
	strings:
		$1 = { F0 4D 2D E9 F4 61 9F E5 02 C1 C1 E3 06 00 5C E1 08 D0 4D E2 00 20 A0 E1 01 30 A0 E1 00 40 A0 E1 01 50 A0 E1 02 61 01 E2 62 00 00 CA 00 40 9C E1 5C 00 00 0A 01 06 5C E3 02 70 A0 E1 0C 80 A0 E1 60 00 00 BA B8 31 9F E5 00 40 A0 E3 93 2C CC E0 2B 54 8C E2 06 56 45 E2 87 5C 45 E2 6D 50 45 E2 04 20 A0 E1 05 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 74 21 9F E5 74 31 9F E5 ?? ?? ?? ?? 70 21 9F E5 70 31 9F E5 00 A0 A0 E1 01 B0 A0 E1 ?? ?? ?? ?? 0A 20 A0 E1 03 00 8D E8 0B 30 A0 E1 58 01 9F E5 58 11 9F E5 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 03 00 9D E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 3C 01 9F E5 3C 11 9F E5 ?? ?? ?? ?? 38 21 9F E5 38 31 9F E5 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 00 40 A0 E3 01 50 81 E2 04 20 A0 E1 05 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 00 70 A0 E1 01 80 A0 E1 ?? ?? ?? ?? 04 20 A0 E1 00 A0 A0 E1 01 B0 A0 E1 05 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 86 E1 02 00 A0 E1 03 10 A0 E1 08 D0 8D E2 F0 8D BD E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 F7 FF FF EA 0C 30 A0 E1 00 00 A0 E3 58 10 9F E5 ?? ?? ?? ?? 54 30 9F E5 01 50 A0 E1 00 40 A0 E1 95 03 83 E0 A3 30 A0 E1 2A 54 83 E2 02 55 45 E2 87 5C 45 E2 6D 50 45 E2 97 FF FF EA FF FF EF 7F 56 55 55 55 F1 15 5F F1 15 5F E1 3F 0F EA A0 0E EA A0 F6 3F 34 C8 32 25 DE 91 E6 BF 6E DB B6 6D DB B6 F9 3F B7 6D DB B6 6D DB D6 3F 00 00 50 43 AB AA AA AA }
	condition:
		$1
}

rule file_58_0_2 {
	meta:
		name = "llround"
		size = 368
		refs = "0050 __adddf3"
	strings:
		$1 = { 70 48 2D E9 21 4A A0 E1 84 3A A0 E1 A3 3A A0 E1 FF 3F 43 E2 03 30 43 E2 01 00 73 E3 00 20 A0 B3 00 30 A0 B3 26 00 00 BA 3E 00 53 E3 C4 45 A0 E1 26 00 00 CA 33 00 53 E3 05 00 00 CA 00 00 54 E3 00 20 A0 03 1C 31 9F 05 00 20 A0 13 18 31 9F 15 ?? ?? ?? ?? 21 3A A0 E1 83 3A A0 E1 A3 3A A0 E1 FF 3F 43 E2 FF 24 C1 E3 03 30 43 E2 01 C0 A0 E1 0F 26 C2 E3 34 10 53 E2 00 B0 A0 E1 01 26 82 E3 32 00 00 4A 1F 00 51 E3 1E 00 00 DA 00 B0 A0 E3 00 C0 A0 E3 20 30 91 E2 23 00 00 4A 1F 00 53 E3 00 50 A0 C3 00 60 A0 C3 10 00 00 DA 0B 20 85 E1 0C 30 86 E1 00 00 54 E3 01 00 00 0A 00 20 72 E2 00 30 E3 E2 03 10 A0 E1 02 00 A0 E1 70 88 BD E8 00 00 54 E3 00 20 E0 03 02 31 E0 03 00 20 A0 13 02 31 A0 13 03 10 A0 E1 02 00 A0 E1 70 88 BD E8 20 00 63 E2 00 00 51 E3 32 60 A0 E1 12 53 A0 E1 12 61 A0 A1 E8 FF FF EA 20 50 61 E2 30 55 A0 E1 54 30 53 E2 05 C0 A0 E1 10 C3 A0 51 10 01 A0 E1 20 30 91 E2 00 B0 A0 E1 DB FF FF 5A 1F 00 73 E3 00 30 63 A2 32 23 A0 A1 00 20 A0 B3 00 30 A0 A3 00 30 A0 B3 0B 20 82 E1 0C 30 83 E1 D8 FF FF EA 1F 00 71 E3 00 B0 61 A2 30 BB A0 A1 00 C0 A0 A3 CB FF FF AA C8 FF FF EA 00 00 E0 3F 00 00 E0 BF }
	condition:
		$1
}

rule file_59_0_2 {
	meta:
		name = "expm1f"
		size = 1136
		refs = "0044 __gtsf2 0064 __mulsf3 006c __addsf3 0070 __fixsfsi 0078 __floatsisf 00ac __subsf3 01a4 __divsf3 0268 __ltsf2 045c .data"
	strings:
		$1 = { 1C 24 9F E5 02 31 C0 E3 02 00 53 E1 F0 45 2D E9 00 40 A0 E1 02 51 00 E2 2C 00 00 9A 46 27 82 E2 EE 2B 82 E2 75 2F 82 E2 02 00 53 E1 07 00 00 9A F0 23 9F E5 02 00 53 E1 9C 00 00 8A F1 00 00 0A E4 13 9F E5 ?? ?? ?? ?? 00 00 50 E3 DE 00 00 CA 00 00 55 E3 7E 00 00 1A 3F 54 A0 E3 CC 13 9F E5 04 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 00 60 A0 E1 ?? ?? ?? ?? B0 13 9F E5 00 50 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? A0 13 9F E5 00 70 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 50 A0 E1 05 10 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 04 10 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 00 A0 A0 E1 05 00 00 EA 64 23 9F E5 02 00 53 E1 67 00 00 8A 33 04 53 E3 00 60 A0 23 84 00 00 3A 3F 14 A0 E3 04 00 A0 E1 ?? ?? ?? ?? 00 70 A0 E1 07 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 34 13 9F E5 00 50 A0 E1 ?? ?? ?? ?? 2C 13 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 20 13 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 14 13 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 08 13 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 07 10 A0 E1 00 80 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 E4 02 9F E5 ?? ?? ?? ?? 00 70 A0 E1 07 10 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 07 10 A0 E1 00 80 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 BC 02 9F E5 ?? ?? ?? ?? 00 10 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 00 00 56 E3 00 10 A0 E1 1B 00 00 0A 0A 10 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 0A 10 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 01 00 76 E3 00 50 A0 E1 65 00 00 0A 01 00 56 E3 54 00 00 0A 01 30 86 E2 39 00 53 E3 30 00 00 8A 16 00 56 E3 67 00 00 CA 01 34 A0 E3 53 36 A0 E1 04 10 A0 E1 FE 45 63 E2 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 86 4B 80 E0 07 00 00 EA 04 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 04 00 A0 E1 F0 85 BD E8 00 52 9F E5 04 00 A0 E1 04 10 95 E5 ?? ?? ?? ?? 00 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 1C 00 00 BA BF 54 A0 E3 77 FF FF EA D3 28 82 E2 A3 2C 82 E2 79 20 82 E2 02 00 53 E1 60 00 00 8A 00 00 55 E3 24 00 00 1A C0 11 9F E5 ?? ?? ?? ?? 01 60 A0 E3 00 70 A0 E1 88 51 9F E5 7C FF FF EA 00 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 E2 FF FF EA 04 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 FE 05 A0 E3 ?? ?? ?? ?? FE 15 A0 E3 86 0B 80 E0 ?? ?? ?? ?? 00 40 A0 E1 D8 FF FF EA 04 00 95 E5 FE 15 A0 E3 ?? ?? ?? ?? 00 40 A0 E1 D3 FF FF EA 58 31 9F E5 00 10 A0 E1 00 00 93 E5 00 60 93 E5 ?? ?? ?? ?? 04 10 A0 E1 00 50 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 C2 FF FF EA 2C 11 9F E5 ?? ?? ?? ?? 00 60 E0 E3 00 70 A0 E1 20 51 9F E5 57 FF FF EA 04 00 A0 E1 18 11 9F E5 ?? ?? ?? ?? 00 00 50 E3 22 00 00 AA 04 00 A0 E1 3F 14 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 03 11 A0 E3 ?? ?? ?? ?? 00 40 A0 E1 B2 FF FF EA 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 3F 14 A0 E3 ?? ?? ?? ?? 3F 14 A0 E3 ?? ?? ?? ?? 00 40 A0 E1 A9 FF FF EA 7F 10 66 E2 81 1B A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 86 4B 80 E0 9F FF FF EA 88 30 9F E5 00 00 93 E5 00 10 93 E5 ?? ?? ?? ?? 00 40 A0 E1 99 FF FF EA 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 00 40 A0 E1 90 FF FF EA 00 00 55 E3 58 40 9F 15 8D FF FF EA 00 00 55 E3 0E FF FF 0A BF 54 A0 E3 0D FF FF EA 43 B8 95 41 00 00 80 7F 80 71 B1 42 3B AA B8 3F 80 71 31 BF D1 F7 17 37 18 72 B1 3E BB ED 57 B4 54 7E 86 36 CD 70 A6 38 01 0D D0 3A 89 88 08 3D 00 00 40 40 00 00 C0 40 ?? ?? ?? ?? 80 71 31 3F D1 F7 17 B7 00 00 80 BE 00 00 80 BF }
	condition:
		$1
}

rule file_60_0_2 {
	meta:
		name = "__sum_D2A"
		size = 420
		refs = "0030 __Balloc_D2A 0188 memcpy 0190 __Bfree_D2A"
	strings:
		$1 = { F0 4F 2D E9 10 30 91 E5 10 20 90 E5 0C D0 4D E2 03 00 52 E1 00 00 8D E5 00 10 8D B5 01 90 A0 E1 00 10 9D E5 00 30 A0 B1 04 00 91 E5 03 90 A0 B1 ?? ?? ?? ?? 00 20 9D E5 00 30 9D E5 10 20 92 E5 14 A0 83 E2 10 20 80 E5 10 10 99 E5 14 80 80 E2 01 71 80 E0 04 20 8D E5 00 20 A0 E3 00 B0 A0 E1 08 10 8D E5 14 70 87 E2 14 90 89 E2 0A 40 A0 E1 08 30 A0 E1 02 00 A0 E1 02 60 9A E7 02 50 99 E7 06 18 A0 E1 05 C8 A0 E1 2C C8 A0 E1 21 18 A0 E1 01 10 8C E0 00 10 81 E0 26 68 A0 E1 01 08 01 E2 25 58 86 E0 20 58 85 E0 B2 50 C3 E1 04 30 83 E2 01 08 05 E2 03 00 57 E1 B2 10 88 E1 04 40 84 E2 20 08 A0 E1 04 20 82 E2 EA FF FF 8A 00 10 9D E5 03 C0 A0 E1 10 20 91 E5 08 10 9D E5 02 20 61 E0 02 71 87 E0 07 00 53 E1 0E 00 00 2A 00 20 A0 E3 02 50 94 E7 05 18 A0 E1 21 18 A0 E1 01 10 80 E0 25 58 A0 E1 01 08 01 E2 20 08 85 E0 B2 00 C3 E1 04 30 83 E2 03 00 57 E1 B2 10 8C E1 20 08 A0 E1 04 20 82 E2 F1 FF FF 8A 00 00 50 E3 09 00 00 0A 08 30 9B E5 04 20 9D E5 03 00 52 E1 08 00 00 0A 04 10 9D E5 01 30 81 E2 01 21 8B E0 01 10 A0 E3 14 10 82 E5 10 30 8B E5 0B 00 A0 E1 0C D0 8D E2 F0 8F BD E8 04 00 9B E5 01 00 80 E2 ?? ?? ?? ?? 10 20 9B E5 00 40 A0 E1 02 20 82 E2 0C 10 8B E2 02 21 A0 E1 0C 00 80 E2 ?? ?? ?? ?? 0B 00 A0 E1 ?? ?? ?? ?? 10 30 94 E5 04 B0 A0 E1 04 30 8D E5 E6 FF FF EA }
	condition:
		$1
}

rule file_61_0_2 {
	meta:
		name = "__ieee754_lgammaf_r"
		size = 2656
		refs = "0078 __subsf3 008c __mulsf3 00b4 __addsf3 01b4 __divsf3 01e0 __ieee754_logf 0214 __fixsfsi 021c __floatsisf 033c .text 0360 floorf 036c __nesf2 03d8 __kernel_cosf 03ec __eqsf2 0420 __ltsf2 0458 __kernel_sinf"
	strings:
		$1 = { 38 39 9F E5 F0 45 2D E9 02 41 C0 E3 03 00 54 E1 01 30 A0 E3 00 50 A0 E1 00 60 A0 E1 01 70 A0 E1 00 30 81 E5 66 00 00 CA 00 00 54 E3 5E 00 00 0A 72 05 54 E3 67 00 00 BA 00 00 50 E3 58 00 00 BA FE 05 54 E3 01 01 54 13 00 40 A0 03 4D 00 00 0A 07 01 74 E3 6B 00 00 CA E4 38 9F E5 03 00 54 E1 C5 01 00 DA DC 38 9F E5 03 00 54 E1 68 01 00 DA 05 10 A0 E1 01 01 A0 E3 ?? ?? ?? ?? 00 70 A0 E3 00 50 A0 E1 05 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? BF 14 A0 E3 00 40 A0 E1 05 00 A0 E1 ?? ?? ?? ?? A4 18 9F E5 00 A0 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 98 18 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 8C 18 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 80 18 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 74 18 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 68 18 9F E5 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 58 18 9F E5 00 50 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 4C 18 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 40 18 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 34 18 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 28 18 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 1C 18 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 07 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 00 00 56 E3 0A 00 00 AA 04 10 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 05 00 00 EA 4B 04 54 E3 68 00 00 BA FE 05 A0 E3 00 10 A0 E3 ?? ?? ?? ?? 00 40 A0 E1 04 00 A0 E1 F0 85 BD E8 00 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 04 00 A0 E1 F0 85 BD E8 00 00 50 E3 03 00 00 BA ?? ?? ?? ?? 02 41 80 E2 04 00 A0 E1 F0 85 BD E8 00 30 E0 E3 02 01 80 E2 00 30 81 E5 ?? ?? ?? ?? 02 41 80 E2 EC FF FF EA 41 04 54 E3 CA 00 00 AA 05 00 A0 E1 ?? ?? ?? ?? 00 70 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 3F 14 A0 E3 00 50 A0 E1 ?? ?? ?? ?? 3C 17 9F E5 00 40 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 30 17 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 24 17 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 18 17 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 0C 17 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 00 17 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? C0 16 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? E4 16 9F E5 00 A0 A0 E1 05 00 A0 E1 ?? ?? ?? ?? D8 16 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? CC 16 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? C0 16 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? B4 16 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? A8 16 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 03 70 47 E2 00 40 A0 E1 04 00 57 E3 07 F1 9F 97 92 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FA 05 54 E3 72 01 00 BA 02 81 80 E2 08 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 13 01 00 1A 08 00 A0 E1 4B 14 A0 E3 ?? ?? ?? ?? 01 A0 00 E2 0A 00 A0 E1 ?? ?? ?? ?? 00 80 A0 E1 0A 01 A0 E1 06 00 50 E3 00 F1 9F 97 38 00 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FF 15 A0 E3 08 00 A0 E1 ?? ?? ?? ?? D8 15 9F E5 ?? ?? ?? ?? 00 10 A0 E3 ?? ?? ?? ?? 02 01 80 E2 02 A1 80 E2 0A 00 A0 E1 00 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 6C FF FF 0A 0A 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 02 11 C0 E3 9C 05 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? 00 10 A0 E3 00 80 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 00 30 97 A5 00 30 E0 B3 02 51 85 E2 00 30 87 E5 00 FF FF EA 08 10 A0 E1 FE 05 A0 E3 ?? ?? ?? ?? 5C 15 9F E5 ?? ?? ?? ?? 00 10 A0 E3 00 20 A0 E3 ?? ?? ?? ?? DF FF FF EA 08 10 A0 E1 3F 04 A0 E3 ?? ?? ?? ?? 38 15 9F E5 ?? ?? ?? ?? 00 10 A0 E3 ?? ?? ?? ?? D7 FF FF EA 08 00 A0 E1 EF FF FF EA 08 00 A0 E1 01 11 A0 E3 ?? ?? ?? ?? EB FF FF EA 05 00 A0 E1 0C 15 9F E5 ?? ?? ?? ?? 00 70 A0 E1 04 15 9F E5 05 00 A0 E1 ?? ?? ?? ?? 07 10 A0 E1 ?? ?? ?? ?? 00 70 A0 E1 F0 14 9F E5 05 00 A0 E1 ?? ?? ?? ?? 07 10 A0 E1 ?? ?? ?? ?? 00 70 A0 E1 DC 14 9F E5 05 00 A0 E1 ?? ?? ?? ?? 07 10 A0 E1 ?? ?? ?? ?? 00 70 A0 E1 01 11 A0 E3 05 00 A0 E1 ?? ?? ?? ?? 07 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 1A FF FF EA FE 75 A0 E3 E0 FF FF EA FE 75 A0 E3 E4 FF FF EA FE 75 A0 E3 E8 FF FF EA FE 75 A0 E3 EC FF FF EA 7C 34 9F E5 03 00 54 E1 97 00 00 CA 05 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 00 A0 A0 E1 FE 05 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 00 70 A0 E1 ?? ?? ?? ?? 3F 14 A0 E3 00 40 A0 E1 05 00 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 00 50 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 24 14 9F E5 00 50 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 18 14 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 0C 14 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 00 14 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? F4 13 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? E8 13 9F E5 ?? ?? ?? ?? 07 10 A0 E1 ?? ?? ?? ?? DC 13 9F E5 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 DC FE FF EA C4 33 9F E5 03 00 54 E1 78 00 00 DA 05 00 A0 E1 B8 13 9F E5 ?? ?? ?? ?? 00 70 A0 E3 00 50 A0 E1 05 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 00 A0 A0 E1 ?? ?? ?? ?? 94 13 9F E5 00 40 A0 E1 ?? ?? ?? ?? 8C 13 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 80 13 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 74 13 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 68 13 9F E5 ?? ?? ?? ?? 00 10 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 58 13 9F E5 00 A0 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 4C 13 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 40 13 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 34 13 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 28 13 9F E5 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 18 13 9F E5 00 50 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 0C 13 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 00 13 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? F4 12 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? E8 12 9F E5 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 CC 02 9F E5 ?? ?? ?? ?? 00 10 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? BC 12 9F E5 ?? ?? ?? ?? 07 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 82 FE FF EA 05 00 A0 E1 ?? ?? ?? ?? A0 32 9F E5 02 71 80 E2 03 00 54 E1 5B 00 00 DA 05 10 A0 E1 FE 05 A0 E3 ?? ?? ?? ?? 00 50 A0 E1 36 FE FF EA 05 00 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 6F FE FF EA 3F 14 A0 E3 08 00 A0 E1 ?? ?? ?? ?? 00 80 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 ?? ?? ?? ?? C0 11 9F E5 00 80 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? E4 FE FF EA 05 00 A0 E1 FE 15 A0 E3 ?? ?? ?? ?? 00 70 A0 E3 00 50 A0 E1 BF 14 A0 E3 05 00 A0 E1 ?? ?? ?? ?? 04 12 9F E5 00 40 A0 E1 05 00 A0 E1 ?? ?? ?? ?? F8 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? EC 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? E0 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? D4 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? E4 10 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? B8 11 9F E5 00 A0 A0 E1 05 00 A0 E1 ?? ?? ?? ?? AC 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? A0 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 94 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 88 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 07 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 20 FE FF EA 4C 31 9F E5 03 00 54 E1 C1 FF FF DA 05 00 A0 E1 40 11 9F E5 ?? ?? ?? ?? 00 50 A0 E1 43 FF FF EA 80 10 9F E5 ?? ?? ?? ?? 00 10 A0 E3 00 20 A0 E3 ?? ?? ?? ?? 00 A0 A0 E1 A8 FE FF EA FF FF 7F 7F 66 66 66 3F 17 A6 DD 3F A2 83 D3 37 67 97 67 39 A1 54 9C 3A 7E 02 F2 3B 01 F0 89 3D 3F 23 9E 3D 75 2C 3C 38 45 84 E2 38 34 B6 05 3A C6 6E 3D 3B 15 99 A8 3C 66 1A A5 3E 67 FF 05 38 B4 35 F1 3A E4 40 DA 3C E6 DC 15 3E 7A CC A6 3E 5A 24 5C 3E BD D7 F5 36 D6 EE 4B 3A 54 BF 98 3C 6E 0F 30 3E C5 D0 38 3F 3B 2D B2 3F DB 0F 49 40 00 00 C0 40 00 00 A0 40 00 00 80 40 00 00 40 40 FF FF 7F 5C E8 C4 D5 BA D2 3D 5B 3A 5C 06 1C 3A FD 0C 50 3A 61 0B 36 3B AB AA AA 3D 1D 7F D6 3E 1F A6 9D 3F C3 16 BB 3F 6B 7B A5 39 76 F4 B7 3A 07 E7 C7 3B 47 4D 06 3D 5E B9 F7 3E F7 E9 AF 39 85 30 0D 3A 99 16 14 3B FE FC 28 3C 15 5A 84 3D 27 F9 A3 B9 67 F8 66 3A FE 77 71 3B 3D 37 93 3C 3C 21 17 3E 52 1C E6 31 CD CD F8 3D 1F 4A 3B 3F 5E 3C 5B 3C 78 75 6A 3E B2 4B 7A 3F E7 3A BA 3F F4 00 22 3F DB D5 52 3B AF 72 D5 3D DF EF 44 3F 2D 39 08 40 BE 2E 1D 40 07 33 6D 3E 0C 5B EC 3E }
	condition:
		$1
}

rule file_62_0_2 {
	meta:
		name = "logbf"
		size = 88
		refs = "002c __floatsisf 0034 __mulsf3 0044 __divsf3"
	strings:
		$1 = { 02 31 D0 E3 04 E0 2D E5 00 10 A0 E1 0A 00 00 0A 34 20 9F E5 02 00 53 E1 05 00 00 CA C3 3B B0 E1 28 00 9F 05 04 F0 9D 04 7F 00 43 E2 ?? ?? ?? ?? 04 F0 9D E4 ?? ?? ?? ?? 04 F0 9D E4 03 10 A0 E1 0C 00 9F E5 ?? ?? ?? ?? 04 F0 9D E4 FF FF 7F 7F 00 00 FC C2 00 00 80 BF }
	condition:
		$1
}

rule file_63_0_2 {
	meta:
		name = "__g_xfmt"
		size = 408
		refs = "001c __fpclassifyl 008c strncpy 0094 strlen 0100 __gdtoa 0118 __g__fmt 0188 .rdata 0190 .data"
	strings:
		$1 = { F0 41 2D E9 02 70 A0 E1 24 D0 4D E2 01 40 A0 E1 00 50 A0 E1 03 00 91 E8 03 60 A0 E1 ?? ?? ?? ?? C7 CF C7 E1 0A 30 8C E2 06 00 53 E1 3B 00 00 8A B0 20 D4 E1 B6 80 D4 E1 B4 10 D4 E1 B2 70 D4 E1 B8 30 D4 E1 08 18 81 E1 07 28 82 E1 01 0C 10 E3 14 10 8D E5 10 20 8D E5 02 49 03 E2 0F 00 00 0A 01 0B 10 E3 30 00 00 0A 00 00 54 E3 2D 40 A0 13 2B 40 A0 03 05 00 A0 E1 00 00 5C E3 0C 20 A0 11 08 20 A0 03 FC 10 9F E5 01 40 C0 E4 ?? ?? ?? ?? 05 00 A0 E1 ?? ?? ?? ?? 00 00 85 E0 20 00 00 EA 01 0B 10 E3 2A 00 00 0A 01 09 10 E3 83 38 A0 01 A3 38 A0 01 01 19 43 02 02 30 A0 13 01 30 A0 03 18 30 8D 15 C0 10 9F 15 18 30 8D 05 3E 10 41 02 00 00 5C E3 02 E0 A0 13 26 00 00 0A 04 C0 8D E5 1C C0 8D E2 10 20 8D E2 18 30 8D E2 08 C0 8D E5 98 00 9F E5 20 C0 8D E2 00 E0 8D E5 0C C0 8D E5 ?? ?? ?? ?? 20 20 9D E5 00 10 A0 E1 1C 30 9D E5 05 00 A0 E1 50 00 8D E8 ?? ?? ?? ?? 00 00 00 EA 00 00 A0 E3 24 D0 8D E2 F0 81 BD E8 00 00 5C E3 0C 20 A0 11 03 20 A0 03 54 10 9F E5 05 00 A0 E1 ?? ?? ?? ?? 05 00 A0 E1 ?? ?? ?? ?? 00 00 85 E0 F3 FF FF EA 00 00 54 E3 2D 30 A0 13 01 30 C5 14 05 00 A0 E1 30 30 A0 E3 01 30 C0 E4 00 30 A0 E3 01 30 C5 E5 EA FF FF EA 1F 00 56 E3 E7 FF FF 9A 0C E0 A0 E1 D4 FF FF EA ?? ?? ?? ?? C3 BF FF FF ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_65_0_2 {
	meta:
		name = "wcstoull"
		size = 736
		refs = "005c iswctype 0118 __udivdi3"
	strings:
		$1 = { F0 4F 2D E9 00 00 51 E3 00 00 81 15 01 00 52 E3 00 30 A0 13 01 30 A0 03 08 D0 4D E2 A2 3F 93 E1 00 10 8D E5 00 50 A0 E1 02 60 A0 E1 01 00 00 1A 24 00 52 E3 06 00 00 DA 00 70 A0 E3 00 80 A0 E3 08 10 A0 E1 07 00 A0 E1 08 D0 8D E2 F0 8F BD E8 02 50 85 E2 B0 00 D5 E1 08 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 F9 FF FF 1A B0 00 D5 E1 05 30 A0 E1 2D 00 50 E3 00 20 A0 13 01 20 A0 03 00 00 52 E3 04 20 8D E5 64 00 00 0A B2 00 D3 E1 02 50 85 E2 00 00 56 E3 4F 00 00 0A 10 00 56 E3 7C 00 00 0A 05 40 A0 E1 B2 00 D4 E0 04 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 4F 00 00 0A B0 70 D5 E1 30 70 47 E2 A7 9F A0 E1 07 00 56 E1 01 90 89 D3 00 00 59 E3 C7 8F A0 01 06 A0 A0 01 CA BF A0 01 D5 FF FF 1A B0 00 D4 E1 04 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 21 00 00 0A B0 50 D4 E1 30 50 45 E2 00 00 55 E3 05 00 56 A1 26 00 00 DA 0A 20 A0 E1 0B 30 A0 E1 00 00 E0 E3 00 10 E0 E3 ?? ?? ?? ?? 01 20 A0 E3 00 20 92 E0 00 30 A0 E3 01 30 A3 E0 03 00 58 E1 48 00 00 8A 45 00 00 0A 97 0B 01 E0 97 2A 83 E0 9A 18 21 E0 05 20 92 E0 03 30 81 E0 C5 3F A3 E0 03 00 58 E1 3F 00 00 8A 49 00 00 0A 02 70 A0 E1 03 80 A0 E1 02 40 84 E2 B0 00 D4 E1 04 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 DD FF FF 1A B0 00 D4 E1 01 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 34 00 00 0A B0 50 D4 E1 37 50 45 E2 00 00 55 E3 05 00 56 A1 D8 FF FF CA 00 30 9D E5 00 00 53 E3 00 40 83 15 00 00 59 E3 00 70 E0 13 00 80 E0 13 9F FF FF 1A 04 20 9D E5 00 00 52 E3 9C FF FF 0A 00 70 77 E2 00 80 E8 E2 99 FF FF EA 30 00 50 E3 0A 60 A0 13 10 00 00 0A 04 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 02 40 85 E2 AF FF FF 1A B0 00 D5 E1 01 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 2A 00 00 0A B0 70 D5 E1 37 70 47 E2 A7 9F A0 E1 A9 FF FF EA 2B 00 50 E3 9A FF FF 1A 97 FF FF EA B2 30 D5 E1 58 00 53 E3 78 00 53 13 08 60 A0 13 E9 FF FF 1A 04 50 85 E2 05 40 A0 E1 B2 00 D4 E0 10 60 A0 E3 95 FF FF EA 02 00 57 E1 B7 FF FF 9A 01 90 A0 E3 02 40 84 E2 C0 FF FF EA B0 00 D4 E1 02 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 CA FF FF 0A B0 50 D4 E1 57 50 45 E2 9D FF FF EA 02 00 57 E1 B3 FF FF 9A 01 90 A0 E3 F1 FF FF EA 30 00 50 E3 D1 FF FF 1A B2 30 D5 E1 02 40 85 E2 78 00 53 E3 58 00 53 13 B0 00 D5 11 7C FF FF 1A E0 FF FF EA B0 00 D5 E1 02 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 B0 70 D5 11 01 90 A0 03 57 70 47 12 00 70 E0 03 A7 9F A0 11 78 FF FF EA }
	condition:
		$1
}

rule file_66_0_2 {
	meta:
		name = "__ieee754_asinf"
		size = 908
		refs = "0030 __mulsf3 0048 __addsf3 0058 __subsf3 00e4 __divsf3 0134 __gtsf2 0234 sqrtf"
	strings:
		$1 = { F0 47 2D E9 02 51 C0 E3 FE 05 55 E3 00 40 A0 E1 00 70 A0 E1 4A 00 00 0A 3B 00 00 CA 3F 04 55 E3 53 00 00 AA 32 04 55 E3 3E 00 00 BA 00 10 A0 E1 ?? ?? ?? ?? 00 60 A0 E1 10 13 9F E5 06 00 A0 E1 ?? ?? ?? ?? 08 13 9F E5 ?? ?? ?? ?? 06 10 A0 E1 ?? ?? ?? ?? FC 12 9F E5 ?? ?? ?? ?? 06 10 A0 E1 ?? ?? ?? ?? F0 12 9F E5 ?? ?? ?? ?? 06 10 A0 E1 ?? ?? ?? ?? E4 12 9F E5 ?? ?? ?? ?? 06 10 A0 E1 ?? ?? ?? ?? D8 12 9F E5 ?? ?? ?? ?? 06 10 A0 E1 ?? ?? ?? ?? CC 12 9F E5 00 50 A0 E1 06 00 A0 E1 ?? ?? ?? ?? C0 12 9F E5 ?? ?? ?? ?? 06 10 A0 E1 ?? ?? ?? ?? B4 12 9F E5 ?? ?? ?? ?? 06 10 A0 E1 ?? ?? ?? ?? A8 12 9F E5 ?? ?? ?? ?? 06 10 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 04 00 A0 E1 F0 87 BD E8 00 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 04 00 A0 E1 F0 87 BD E8 48 12 9F E5 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 00 00 50 E3 F7 FF FF CA BC FF FF EA 30 12 9F E5 ?? ?? ?? ?? 2C 12 9F E5 00 50 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 04 00 A0 E1 F0 87 BD E8 02 11 C0 E3 FE 05 A0 E3 ?? ?? ?? ?? 3F 14 A0 E3 ?? ?? ?? ?? C0 11 9F E5 00 40 A0 E1 ?? ?? ?? ?? B8 11 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? AC 11 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? A0 11 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 94 11 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 88 11 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 7C 11 9F E5 00 A0 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 70 11 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 64 11 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 58 11 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 00 80 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 44 31 9F E5 00 60 A0 E1 03 00 55 E1 14 00 00 DA 08 10 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 ?? ?? ?? ?? 04 11 9F E5 ?? ?? ?? ?? 00 10 A0 E1 F4 00 9F E5 ?? ?? ?? ?? 00 00 57 E3 00 40 A0 C1 02 41 80 D2 04 00 A0 E1 F0 87 BD E8 00 10 A0 E1 ?? ?? ?? ?? 08 10 A0 E1 00 90 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 09 00 A0 E1 ?? ?? ?? ?? FF 5E C6 E3 0F 50 C5 E3 00 80 A0 E1 05 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 00 40 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 03 11 A0 E3 ?? ?? ?? ?? 70 10 9F E5 ?? ?? ?? ?? 00 10 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 03 11 A0 E3 00 40 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 54 10 9F E5 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 3C 00 9F E5 ?? ?? ?? ?? CD FF FF EA 08 EF 11 38 04 7F 4F 3A 46 11 24 3D A8 0A 4E 3E 90 B0 A6 3E AB AA 2A 3E 2E C6 9D 3D 61 33 30 3F 2D 57 01 40 39 D1 19 40 CA F2 49 71 DA 0F C9 3F 68 21 A2 33 99 99 79 3F DB 0F 49 3F }
	condition:
		$1
}

rule file_67_0_2 {
	meta:
		name = "atanf"
		size = 772
		refs = "005c __mulsf3 007c __addsf3 00dc __subsf3 01b4 __divsf3 01e4 __gtsf2 02ec .rdata"
	strings:
		$1 = { A4 22 9F E5 02 31 C0 E3 02 00 53 E1 F0 41 2D E9 00 40 A0 E1 00 60 A0 E1 07 00 00 DA 8C 22 9F E5 02 00 53 E1 66 00 00 CA 00 00 50 E3 80 42 9F D5 80 42 9F C5 04 00 A0 E1 F0 81 BD E8 78 22 9F E5 02 00 53 E1 48 00 00 CA 31 04 53 E3 61 00 00 BA 00 70 E0 E3 04 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 00 80 A0 E1 ?? ?? ?? ?? 4C 12 9F E5 00 50 A0 E1 ?? ?? ?? ?? 44 12 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 38 12 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 2C 12 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 20 12 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 14 12 9F E5 ?? ?? ?? ?? 08 10 A0 E1 ?? ?? ?? ?? 08 12 9F E5 00 80 A0 E1 05 00 A0 E1 ?? ?? ?? ?? FC 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? F0 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? E4 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? D8 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 01 00 77 E3 00 10 A0 E1 45 00 00 0A C0 51 9F E5 08 00 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 07 31 85 E0 10 10 93 E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 07 01 95 E7 ?? ?? ?? ?? 00 00 56 E3 00 40 A0 A1 02 41 80 B2 04 00 A0 E1 F0 81 BD E8 7C 21 9F E5 02 41 C0 E3 02 00 53 E1 1D 00 00 CA 70 21 9F E5 02 00 53 E1 3B 00 00 CA 04 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 01 11 A0 E3 00 50 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 70 A0 E3 00 40 A0 E1 A3 FF FF EA 00 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 04 00 A0 E1 F0 81 BD E8 18 11 9F E5 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 00 00 50 E3 97 FF FF DA 8F FF FF EA 00 21 9F E5 02 00 53 E1 17 00 00 CA FF 15 A0 E3 04 00 A0 E1 ?? ?? ?? ?? FF 15 A0 E3 00 50 A0 E1 04 00 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 02 70 A0 E3 00 40 A0 E1 85 FF FF EA 08 00 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 74 FF FF EA 04 10 A0 E1 94 00 9F E5 ?? ?? ?? ?? 03 70 A0 E3 00 40 A0 E1 76 FF FF EA FE 15 A0 E3 04 00 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 00 50 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 01 70 A0 E3 00 40 A0 E1 69 FF FF EA FF FF 7F 50 00 00 80 7F DB 0F C9 BF DB 0F C9 3F FF FF DF 3E D7 69 85 3C 59 DA 4B 3D 35 6B 88 3D 6E 2E BA 3D 25 49 12 3E AB AA AA 3E 21 A2 15 BD 6B F1 6E 3D 95 87 9D 3D 38 8E E3 3D CD CC 4C 3E ?? ?? ?? ?? FF FF 97 3F FF FF 2F 3F CA F2 49 71 FF FF 1B 40 00 00 80 BF }
	condition:
		$1
}

rule file_68_0_2 {
	meta:
		name = "__ieee754_remainder"
		size = 520
		refs = "006c __adddf3 0080 fmod 00cc __gtdf2 00e8 __subdf3 0108 __gedf2 0144 __muldf3 0150 __divdf3"
	strings:
		$1 = { F0 4F 2D E9 02 40 A0 E1 02 81 C3 E3 01 50 A0 E1 04 10 98 E1 04 D0 4D E2 03 70 A0 E1 02 A0 A0 E1 00 60 A0 E1 03 B0 A0 E1 00 C0 A0 E1 05 90 A0 E1 3F 00 00 0A C0 31 9F E5 02 B1 C5 E3 03 00 5B E1 3B 00 00 CA 03 00 58 E1 35 00 00 CA AC 31 9F E5 03 00 58 E1 0D 00 00 CA 04 20 A0 E1 07 30 A0 E1 04 00 A0 E1 07 10 A0 E1 00 60 8D E5 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 06 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 C0 9D E5 00 60 A0 E1 01 50 A0 E1 0C A0 6A E0 0B B0 68 E0 0A A0 9B E1 2E 00 00 0A 02 06 58 E3 02 51 C5 E3 02 71 C7 E3 30 00 00 AA 06 20 A0 E1 05 30 A0 E1 06 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 04 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 0E 00 00 DA 06 00 A0 E1 04 20 A0 E1 05 10 A0 E1 07 30 A0 E1 ?? ?? ?? ?? 00 60 A0 E1 01 50 A0 E1 06 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 04 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 31 00 00 AA 02 91 09 E2 06 00 A0 E1 05 10 29 E0 0B 00 00 EA 02 31 88 E2 01 36 83 E2 04 30 93 E1 D6 FF FF 0A 04 20 A0 E1 07 30 A0 E1 06 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 04 D0 8D E2 F0 8F BD E8 06 00 A0 E1 05 10 A0 E1 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? F7 FF FF EA 00 20 A0 E3 84 30 9F E5 04 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 00 A0 A0 E1 01 B0 A0 E1 06 00 A0 E1 05 10 A0 E1 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 D9 FF FF DA 06 00 A0 E1 04 20 A0 E1 05 10 A0 E1 07 30 A0 E1 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 00 60 A0 E1 01 50 A0 E1 ?? ?? ?? ?? 00 00 50 E3 CD FF FF BA 06 00 A0 E1 05 10 A0 E1 04 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? 00 60 A0 E1 01 50 A0 E1 C5 FF FF EA FF FF EF 7F FF FF DF 7F 00 00 E0 3F }
	condition:
		$1
}

rule file_69_0_2 {
	meta:
		name = "wmemcmp"
		size = 104
	strings:
		$1 = { 01 00 50 E1 00 00 52 13 04 40 2D E5 0C 00 00 0A 00 30 50 E2 01 30 A0 13 00 00 51 E3 01 30 23 12 00 00 53 E3 09 00 00 1A B3 40 90 E1 B3 C0 91 E1 02 30 83 E2 0C 00 54 E1 08 00 00 1A 01 20 52 E2 F8 FF FF 1A 00 00 A0 E3 10 00 BD E8 0E F0 A0 E1 00 00 51 E3 01 00 A0 03 00 00 E0 13 F9 FF FF EA 04 00 6C E0 F7 FF FF EA }
	condition:
		$1
}

rule file_70_0_2 {
	meta:
		name = "__ieee754_atanh"
		size = 480
		refs = "004c __adddf3 0058 __gtdf2 008c __muldf3 00a8 __subdf3 00bc __divdf3 00cc log1p"
	strings:
		$1 = { F0 4D 2D E9 01 70 A0 E1 01 40 A0 E1 00 10 60 E2 00 20 81 E1 02 61 C7 E3 A8 31 9F E5 A2 2F 86 E1 03 00 52 E1 00 A0 A0 E1 32 00 00 8A 03 00 56 E1 5B 00 00 0A 90 31 9F E5 03 00 56 E1 39 00 00 CA 88 21 9F E5 88 31 9F E5 07 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 21 00 00 CA 0A 50 A0 E1 05 20 A0 E1 06 30 A0 E1 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 00 A0 A0 E1 01 B0 A0 E1 ?? ?? ?? ?? 05 20 A0 E1 00 70 A0 E1 01 80 A0 E1 06 30 A0 E1 00 00 A0 E3 1C 11 9F E5 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 00 20 A0 E3 FC 30 9F E5 ?? ?? ?? ?? 00 00 54 E3 01 70 A0 E1 00 A0 A0 E1 02 71 81 B2 0A 00 A0 E1 07 10 A0 E1 F0 8D BD E8 07 30 A0 E1 00 20 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 00 A0 A0 E1 01 70 A0 E1 0A 00 A0 E1 07 10 A0 E1 F0 8D BD E8 AC 10 9F E5 00 50 A0 E1 01 00 56 E1 CB FF FF DA 06 30 A0 E1 00 20 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 0A 20 A0 E1 00 70 A0 E1 01 80 A0 E1 06 30 A0 E1 00 00 A0 E3 64 10 9F E5 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 00 20 A0 E3 50 30 9F E5 ?? ?? ?? ?? 00 00 54 E3 01 70 A0 E1 00 A0 A0 E1 02 71 81 B2 0A 00 A0 E1 07 10 A0 E1 F0 8D BD E8 07 10 A0 E1 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 A0 A0 E1 01 70 A0 E1 0A 00 A0 E1 07 10 A0 E1 F0 8D BD E8 00 00 F0 3F FF FF 2F 3E 9C 75 00 88 3C E4 37 7E 00 00 E0 3F FF FF DF 3F }
	condition:
		$1
}

rule file_71_0_2 {
	meta:
		name = "isinff"
		size = 28
	strings:
		$1 = { 10 30 9F E5 02 01 C0 E3 03 00 50 E1 00 00 A0 13 01 00 A0 03 0E F0 A0 E1 00 00 80 7F }
	condition:
		$1
}

rule file_74_0_2 {
	meta:
		name = "__mingw_sprintf"
		size = 72
		refs = "002c __mingw_pformat"
	strings:
		$1 = { 0E 00 2D E9 10 40 2D E9 00 40 A0 E1 08 D0 4D E2 14 C0 8D E2 04 10 A0 E1 00 20 A0 E3 10 30 9D E5 02 0A A0 E3 00 C0 8D E5 04 C0 8D E5 ?? ?? ?? ?? 00 20 A0 E3 00 20 C4 E7 08 D0 8D E2 10 40 BD E8 0C D0 8D E2 0E F0 A0 E1 }
	condition:
		$1
}

rule file_76_0_2 {
	meta:
		name = "log2"
		size = 32
		refs = "0004 log 0010 __divdf3"
	strings:
		$1 = { 04 E0 2D E5 ?? ?? ?? ?? 08 20 9F E5 08 30 9F E5 ?? ?? ?? ?? 04 F0 9D E4 FE 82 2B 65 47 15 F7 3F }
	condition:
		$1
}

rule file_77_0_2 {
	meta:
		name = "wctob"
		size = 108
		refs = "0040 WideCharToMultiByte"
	strings:
		$1 = { 10 40 2D E9 18 D0 4D E2 00 C0 A0 E3 01 E0 A0 E3 17 40 8D E2 B4 01 CD E1 00 40 8D E5 0C 00 A0 E1 0E 30 A0 E1 0C 10 A0 E1 14 20 8D E2 10 40 8D E2 0C 40 8D E5 10 C0 8D E5 04 E0 8D E5 08 C0 8D E5 ?? ?? ?? ?? 00 00 50 E3 02 00 00 1A 00 00 E0 E3 18 D0 8D E2 10 80 BD E8 10 30 9D E5 00 00 53 E3 D7 01 DD 01 F9 FF FF 0A F7 FF FF EA }
	condition:
		$1
}

rule file_78_0_2 {
	meta:
		name = "tanf"
		size = 112
		refs = "0028 __subsf3 0038 __ieee754_rem_pio2f 0050 __kernel_tanf"
	strings:
		$1 = { 04 E0 2D E5 5C 20 9F E5 02 31 C0 E3 02 00 53 E1 08 D0 4D E2 00 10 A0 E1 0E 00 00 DA 48 20 9F E5 02 00 53 E1 02 00 00 DA ?? ?? ?? ?? 08 D0 8D E2 00 80 BD E8 0D 10 A0 E1 ?? ?? ?? ?? 01 20 00 E2 82 20 A0 E1 01 20 62 E2 00 00 9D E5 04 10 9D E5 ?? ?? ?? ?? F4 FF FF EA 00 10 A0 E3 01 20 A0 E3 ?? ?? ?? ?? F0 FF FF EA DA 0F 49 3F FF FF 7F 7F }
	condition:
		$1
}

rule file_81_0_2 {
	meta:
		name = "__match_D2A"
		size = 88
	strings:
		$1 = { 04 40 2D E5 00 C0 90 E5 00 20 A0 E3 D2 40 91 E1 01 20 82 E2 00 00 54 E3 0A 00 00 0A D1 30 DC E1 01 C0 8C E2 40 00 53 E3 01 00 00 DA 5A 00 53 E3 20 30 83 D2 04 00 53 E1 F3 FF FF 0A 00 00 A0 E3 10 00 BD E8 0E F0 A0 E1 01 C0 8C E2 00 C0 80 E5 01 00 A0 E3 F9 FF FF EA }
	condition:
		$1
}

rule file_81_1_2 {
	meta:
		name = "__copybits_D2A"
		size = 124
	strings:
		$1 = { 10 30 92 E5 01 10 41 E2 03 31 82 E0 C1 12 A0 E1 14 30 83 E2 14 20 82 E2 01 10 81 E2 03 00 52 E1 04 40 2D E5 01 41 80 E0 0B 00 00 2A 00 C0 A0 E3 0C 10 92 E7 0C 10 80 E7 04 C0 8C E2 0C 10 82 E0 01 00 53 E1 F9 FF FF 8A 02 20 E0 E1 03 30 82 E0 03 30 C3 E3 04 30 83 E2 03 00 80 E0 00 00 54 E1 03 00 00 9A 00 30 A0 E3 04 30 80 E4 00 00 54 E1 FC FF FF 8A 10 00 BD E8 0E F0 A0 E1 }
	condition:
		$1
}

rule file_81_2_2 {
	meta:
		name = "__any_on_D2A"
		size = 136
	strings:
		$1 = { 10 20 90 E5 C1 32 A0 E1 03 00 52 E1 0B 00 00 BA 09 00 00 DA 1F 10 11 E2 07 00 00 0A 03 20 A0 E1 03 31 80 E0 14 30 93 E5 33 C1 A0 E1 1C 01 53 E1 02 00 00 0A 01 00 A0 E3 0E F0 A0 E1 03 20 A0 E1 04 20 82 E2 02 31 80 E0 14 10 80 E2 04 C0 83 E2 0C 00 51 E1 09 00 00 2A 02 21 90 E7 00 00 52 E3 F3 FF FF 1A 03 00 51 E1 04 00 00 2A 04 20 33 E5 00 00 52 E3 EE FF FF 1A 03 00 51 E1 FA FF FF 3A 00 00 A0 E3 0E F0 A0 E1 }
	condition:
		$1
}

rule file_81_3_2 {
	meta:
		name = "__ratio_D2A"
		size = 160
		refs = "0014 __b2d_D2A 0094 __divdf3"
	strings:
		$1 = { F0 4B 2D E9 08 D0 4D E2 01 60 A0 E1 04 10 8D E2 00 70 A0 E1 ?? ?? ?? ?? 01 50 A0 E1 00 40 A0 E1 0D 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 01 30 A0 E1 00 20 A0 E1 10 10 96 E5 10 00 97 E5 04 C0 9D E5 00 00 61 E0 00 10 9D E5 03 90 A0 E1 0C 10 61 E0 80 12 81 E0 00 00 51 E3 03 90 A0 D1 05 70 A0 E1 01 1A 49 D0 01 7A 85 C0 03 C0 A0 E1 04 60 A0 E1 01 C0 A0 D1 04 40 A0 C1 07 50 A0 C1 02 80 A0 E1 02 B0 A0 E1 0C 30 A0 D1 02 20 A0 D1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 08 D0 8D E2 F0 8B BD E8 }
	condition:
		$1
}

rule file_81_4_2 {
	meta:
		name = "__s2b_D2A"
		size = 216
		refs = "0050 __Balloc_D2A 008c __multadd_D2A"
	strings:
		$1 = { F0 45 2D E9 08 C0 82 E2 02 40 A0 E1 C0 20 9F E5 00 60 A0 E1 9C E2 C2 E0 CC CF A0 E1 C2 20 6C E0 01 00 52 E3 01 50 A0 E1 03 70 A0 E1 1C 80 9D E5 00 00 A0 D3 05 00 00 DA 01 30 A0 E3 00 00 A0 E3 83 30 A0 E1 03 00 52 E1 01 00 80 E2 FB FF FF CA ?? ?? ?? ?? 09 00 55 E3 14 70 80 E5 01 30 A0 E3 09 70 88 D2 10 30 80 E5 07 70 86 D0 09 50 A0 D3 0B 00 00 DA 09 A0 86 E2 09 70 A0 E3 D7 20 96 E1 0A 10 A0 E3 30 20 42 E2 01 70 87 E2 ?? ?? ?? ?? 07 00 55 E1 F8 FF FF CA 09 70 45 E2 07 70 8A E0 08 70 87 E0 05 00 54 E1 F0 85 BD D8 00 60 A0 E3 D6 20 97 E1 0A 10 A0 E3 30 20 42 E2 01 60 86 E2 ?? ?? ?? ?? 05 30 86 E0 03 00 54 E1 F7 FF FF CA F0 85 BD E8 39 8E E3 38 }
	condition:
		$1
}

rule file_82_0_2 {
	meta:
		name = "wmemchr"
		size = 68
	strings:
		$1 = { 01 18 A0 E1 00 00 50 E3 21 18 A0 E1 0E F0 A0 01 00 00 52 E3 08 00 00 0A B0 30 D0 E1 01 00 53 E1 03 00 00 1A 0E F0 A0 E1 B2 30 F0 E1 01 00 53 E1 0E F0 A0 01 01 20 52 E2 FA FF FF 1A 00 00 A0 E3 0E F0 A0 E1 }
	condition:
		$1
}

rule file_83_0_2 {
	meta:
		name = "__mingw_printf"
		size = 72
		refs = "0018 _getstdfilex 0034 __mingw_pformat"
	strings:
		$1 = { 0F 00 2D E9 04 E0 2D E5 08 D0 4D E2 10 30 8D E2 01 00 A0 E3 04 30 8D E5 ?? ?? ?? ?? 04 C0 9D E5 00 10 A0 E1 0C 30 9D E5 00 20 A0 E3 03 0A A0 E3 00 C0 8D E5 ?? ?? ?? ?? 08 D0 8D E2 04 E0 9D E4 10 D0 8D E2 0E F0 A0 E1 }
	condition:
		$1
}

rule file_84_0_2 {
	meta:
		name = "frexpf"
		size = 124
		refs = "005c __mulsf3"
	strings:
		$1 = { 10 40 2D E9 02 21 D0 E3 68 40 9F E5 00 C0 A0 13 01 C0 A0 03 04 00 52 E1 01 C0 8C C3 00 00 5C E3 01 40 A0 E1 00 10 A0 E3 04 D0 4D E2 00 30 A0 E1 00 10 84 E5 04 00 00 1A 02 05 52 E3 7D 10 E0 A3 04 00 00 BA A2 2B 81 E0 00 20 84 E5 03 00 A0 E1 04 D0 8D E2 10 80 BD E8 13 13 A0 E3 ?? ?? ?? ?? 18 10 E0 E3 00 10 84 E5 00 30 A0 E1 02 21 C0 E3 96 10 E0 E3 F2 FF FF EA FF FF 7F 7F }
	condition:
		$1
}

rule file_85_0_2 {
	meta:
		name = "isinf"
		size = 44
	strings:
		$1 = { 20 20 9F E5 04 40 2D E5 01 40 A0 E1 02 11 C1 E3 02 20 21 E0 00 20 92 E1 00 00 A0 13 01 00 A0 03 10 00 BD E8 0E F0 A0 E1 00 00 F0 7F }
	condition:
		$1
}

rule file_86_0_2 {
	meta:
		name = "cbrtf"
		size = 288
		refs = "0054 __mulsf3 005c __divsf3 006c __addsf3"
	strings:
		$1 = { F0 40 2D E9 F0 30 9F E5 02 51 00 E2 00 40 25 E0 03 00 54 E1 00 10 A0 E1 28 00 00 CA 00 00 54 E3 24 00 00 0A 02 05 54 E3 04 60 A0 E1 27 00 00 BA C8 30 9F E5 94 23 C3 E0 C4 4F 43 E0 A9 45 84 E2 11 48 84 E2 67 4D 84 E2 32 40 84 E2 04 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 06 10 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 94 10 9F E5 ?? ?? ?? ?? 90 10 9F E5 00 70 A0 E1 ?? ?? ?? ?? 07 10 A0 E1 00 60 A0 E1 80 00 9F E5 ?? ?? ?? ?? 00 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 6C 00 9F E5 ?? ?? ?? ?? 68 10 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 00 10 85 E1 01 00 A0 E1 F0 80 BD E8 ?? ?? ?? ?? 00 10 A0 E1 01 00 A0 E1 F0 80 BD E8 04 00 A0 E1 3C 10 9F E5 ?? ?? ?? ?? 38 40 9F E5 90 24 84 E0 A4 40 A0 E1 99 45 84 E2 11 48 84 E2 67 4D 84 E2 32 40 84 E2 D3 FF FF EA FF FF 7F 7F 56 55 55 55 B0 F8 0A 3F 50 07 B5 3F F1 8E 34 BF DB B6 CD 3F 6E DB B6 3E 00 00 80 4B AB AA AA AA }
	condition:
		$1
}

rule file_87_0_2 {
	meta:
		name = "_lfind"
		size = 104
	strings:
		$1 = { 00 20 92 E5 F0 45 2D E9 92 13 27 E0 07 00 51 E1 01 40 A0 E1 03 50 A0 E1 00 80 A0 E1 1C A0 9D E5 0E 00 00 2A 03 60 81 E0 02 00 00 EA 03 00 57 E1 05 40 84 E0 09 00 00 9A 04 00 A0 E1 08 10 A0 E1 0F E0 A0 E1 0A F0 A0 E1 05 60 86 E0 00 00 50 E3 06 30 65 E0 F4 FF FF 1A 04 00 A0 E1 F0 85 BD E8 00 00 A0 E3 F0 85 BD E8 }
	condition:
		$1
}

rule file_88_0_2 {
	meta:
		name = "tempnam_imp"
		size = 156
		refs = "001c GetTempPathW 005c GetTempFileNameW 006c DeleteFileW 0088 GetFileAttributesW 0098 .rdata"
	strings:
		$1 = { F0 40 2D E9 41 DE 4D E2 00 60 A0 E1 01 70 A0 E1 41 0F A0 E3 0D 10 A0 E1 02 50 A0 E1 ?? ?? ?? ?? 01 00 40 E2 41 0F 50 E3 0D 60 A0 31 01 00 00 3A 00 00 56 E3 02 00 00 0A B0 30 D6 E1 00 00 53 E3 0F 00 00 1A 4C 60 9F E5 82 4F 8D E2 06 00 A0 E1 07 10 A0 E1 00 20 A0 E3 04 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 04 00 00 0A 04 00 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 0F E0 A0 E1 05 F0 A0 E1 41 DE 8D E2 F0 80 BD E8 06 00 A0 E1 ?? ?? ?? ?? 10 00 10 E3 EC FF FF 1A EA FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_88_1_2 {
	meta:
		name = "_tempnam"
		size = 80
		refs = "001c mbstowcs 004c .text"
	strings:
		$1 = { 70 40 2D E9 41 DE 4D E2 82 5F 8D E2 01 60 A0 E1 41 2F A0 E3 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 06 10 A0 E1 41 2F A0 E3 0D 00 A0 E1 ?? ?? ?? ?? 05 00 A0 E1 0D 10 A0 E1 0C 20 9F E5 0D 40 A0 E1 C7 FF FF EB 41 DE 8D E2 70 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_88_4_2 {
	meta:
		name = "wcstombs_dup"
		size = 48
		refs = "0008 wcslen 0014 malloc 0024 wcstombs"
	strings:
		$1 = { 70 40 2D E9 00 60 A0 E1 ?? ?? ?? ?? 01 50 80 E2 05 00 A0 E1 ?? ?? ?? ?? 06 10 A0 E1 00 40 A0 E1 05 20 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 70 80 BD E8 }
	condition:
		$1
}

rule file_89_0_2 {
	meta:
		name = "gettimeofday"
		size = 144
		refs = "0014 GetSystemTime 0020 SystemTimeToFileTime 003c __udivdi3 0048 __umoddi3"
	strings:
		$1 = { 70 48 2D E9 00 40 50 E2 18 D0 4D E2 18 00 00 0A 0D 00 A0 E1 ?? ?? ?? ?? 10 10 8D E2 0D 00 A0 E1 ?? ?? ?? ?? 10 60 9D E5 14 50 9D E5 0A 20 A0 E3 00 30 A0 E3 06 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 38 20 9F E5 00 30 A0 E3 ?? ?? ?? ?? 04 00 84 E5 2C 00 9F E5 2C 10 9F E5 06 00 90 E0 28 20 9F E5 00 30 A0 E3 05 10 A1 E0 ?? ?? ?? ?? 06 B0 A0 E1 00 00 84 E5 00 00 A0 E3 18 D0 8D E2 70 88 BD E8 40 42 0F 00 00 80 C1 2A 21 4E 62 FE 80 96 98 00 }
	condition:
		$1
}

rule file_90_0_2 {
	meta:
		name = "wcstoll"
		size = 776
		refs = "0058 iswctype 0118 __divdi3"
	strings:
		$1 = { F0 4F 2D E9 00 90 51 E2 00 00 89 15 01 00 52 E3 00 30 A0 13 01 30 A0 03 A2 3F 93 E1 08 D0 4D E2 00 50 A0 E1 02 60 A0 E1 01 00 00 1A 24 00 52 E3 06 00 00 DA 00 70 A0 E3 00 80 A0 E3 08 10 A0 E1 07 00 A0 E1 08 D0 8D E2 F0 8F BD E8 02 50 85 E2 B0 00 D5 E1 08 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 F9 FF FF 1A B0 00 D5 E1 05 30 A0 E1 2D 00 50 E3 00 20 A0 13 01 20 A0 03 00 00 52 E3 04 20 8D E5 64 00 00 0A B2 00 D3 E1 02 50 85 E2 00 00 56 E3 4F 00 00 0A 10 00 56 E3 7E 00 00 0A 05 40 A0 E1 B2 00 D4 E0 04 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 4F 00 00 0A B0 70 D5 E1 30 70 47 E2 A7 3F A0 E1 07 00 56 E1 01 30 83 D3 00 00 53 E3 C7 8F A0 01 00 30 8D 05 06 A0 A0 01 CA BF A0 01 D4 FF FF 1A B0 00 D4 E1 04 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 1C 00 00 0A B0 50 D4 E1 30 50 45 E2 00 00 55 E3 05 00 56 A1 21 00 00 DA 0A 20 A0 E1 0B 30 A0 E1 00 00 E0 E3 02 11 E0 E3 ?? ?? ?? ?? 02 20 A0 E3 00 20 92 E0 00 30 A0 E3 01 30 A3 E0 03 00 58 E1 47 00 00 8A 44 00 00 0A 97 0B 01 E0 97 2A 83 E0 9A 18 21 E0 05 70 92 E0 03 30 81 E0 C5 8F A3 E0 02 40 84 E2 B0 00 D4 E1 04 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 E2 FF FF 1A B0 00 D4 E1 01 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 39 00 00 0A B0 50 D4 E1 37 50 45 E2 00 00 55 E3 05 00 56 A1 DD FF FF CA 04 20 9D E5 00 00 59 E3 00 40 89 15 00 00 52 E3 37 00 00 0A 02 01 58 E3 46 00 00 8A 48 00 00 0A 00 30 9D E5 00 00 53 E3 3F 00 00 1A 04 30 9D E5 00 00 53 E3 9C FF FF 0A 00 70 77 E2 00 80 E8 E2 99 FF FF EA 30 00 50 E3 0A 60 A0 13 10 00 00 0A 04 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 02 40 85 E2 AF FF FF 1A B0 00 D5 E1 01 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 35 00 00 0A B0 70 D5 E1 37 70 47 E2 A7 3F A0 E1 A9 FF FF EA 2B 00 50 E3 9A FF FF 1A 97 FF FF EA B2 30 D5 E1 58 00 53 E3 78 00 53 13 08 60 A0 13 E9 FF FF 1A 04 50 85 E2 05 40 A0 E1 B2 00 D4 E0 10 60 A0 E3 95 FF FF EA 02 00 57 E1 B8 FF FF 9A 01 30 A0 E3 00 30 8D E5 02 40 84 E2 BB FF FF EA B0 00 D4 E1 02 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 C5 FF FF 0A B0 50 D4 E1 57 50 45 E2 9D FF FF EA 06 01 78 E3 C8 FF FF 9A 00 70 E0 E3 02 81 E0 E3 68 FF FF EA 30 00 50 E3 CF FF FF 1A B2 30 D5 E1 02 40 85 E2 78 00 53 E3 58 00 53 13 B0 00 D5 11 7A FF FF 1A DE FF FF EA 04 20 9D E5 00 00 52 E3 F0 FF FF 0A 00 70 A0 E3 02 81 A0 E3 59 FF FF EA 00 00 57 E3 FA FF FF 1A B3 FF FF EA B0 00 D5 E1 02 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 B0 70 D5 11 01 30 A0 03 57 70 47 12 00 70 E0 03 A7 3F A0 11 6D FF FF EA }
	condition:
		$1
}

rule file_92_0_2 {
	meta:
		name = "nextafterf"
		size = 232
		refs = "0028 __eqsf2 0074 __mulsf3 007c __nesf2 0094 __addsf3"
	strings:
		$1 = { DC 30 9F E5 F0 40 2D E9 02 21 C1 E3 02 71 C0 E3 03 00 57 E1 03 00 52 D1 00 40 A0 E1 00 50 A0 E1 01 60 A0 E1 1A 00 00 CA ?? ?? ?? ?? 00 00 50 E3 13 00 00 0A 00 00 57 E3 19 00 00 0A 00 00 54 E3 22 00 00 BA 06 00 54 E1 23 00 00 CA 01 50 85 E2 8C 30 9F E5 88 20 9F E5 03 30 05 E0 02 00 53 E1 09 00 00 0A 02 05 53 E3 04 00 00 AA 04 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 05 40 A0 E1 04 00 A0 E1 F0 80 BD E8 04 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 04 00 A0 E1 F0 80 BD E8 02 41 06 E2 01 40 84 E3 04 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 00 50 A0 E1 ?? ?? ?? ?? 00 00 50 E3 05 40 A0 01 EC FF FF EA 06 00 54 E1 00 00 56 D3 DB FF FF BA 01 50 45 E2 DA FF FF EA 00 00 80 7F }
	condition:
		$1
}

rule file_93_0_2 {
	meta:
		name = "__ieee754_acoshf"
		size = 272
		refs = "002c __addsf3 004c __subsf3 0068 __mulsf3 0078 sqrtf 0088 log1pf 0098 __divsf3 00f0 __ieee754_logf"
	strings:
		$1 = { FE 05 50 E3 70 40 2D E9 00 40 A0 E1 1E 00 00 BA EC 20 9F E5 02 00 50 E1 05 00 00 DA 32 24 82 E2 02 00 50 E1 32 00 00 DA 00 10 A0 E1 ?? ?? ?? ?? 70 80 BD E8 FE 05 50 E3 00 00 A0 03 70 80 BD 08 01 01 54 E3 15 00 00 CA FE 15 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 00 40 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 00 50 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 70 40 BD E8 ?? ?? ?? ?? 00 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 ?? ?? ?? ?? 70 80 BD E8 04 10 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? ?? ?? ?? ?? 04 10 A0 E1 00 60 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 00 50 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 28 00 9F E5 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 70 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? 0C 10 9F E5 ?? ?? ?? ?? 70 80 BD E8 FF FF 7F 4D 00 00 80 BF 18 72 31 3F }
	condition:
		$1
}

rule file_94_0_2 {
	meta:
		name = "__hexnan_D2A"
		size = 964
		refs = "0368 hexdig_init_D2A 03c0 __hexdig_D2A"
	strings:
		$1 = { F0 4F 2D E9 B4 43 9F E5 0C D0 4D E2 30 30 D4 E5 04 00 8D E5 00 00 53 E3 01 50 A0 E1 02 90 A0 E1 D0 00 00 0A 00 30 95 E5 1F 10 13 E2 08 10 8D E5 C3 32 A0 E1 04 10 9D E5 03 21 89 E0 04 20 82 12 00 30 91 E5 00 10 A0 E3 04 10 02 E5 01 10 D3 E5 04 20 42 E2 00 00 51 E3 00 20 8D E5 08 00 00 0A 20 00 51 E3 02 00 00 9A 05 00 00 EA 20 00 52 E3 03 00 00 8A 01 30 83 E2 01 20 D3 E5 00 00 52 E3 F9 FF FF 1A D1 20 D3 E1 30 00 52 E3 A0 00 00 0A 03 10 A0 E1 00 80 9D E5 00 A0 A0 E3 08 00 A0 E1 0A B0 A0 E1 0A 60 A0 E1 01 20 D1 E5 01 30 81 E2 00 00 52 E3 33 00 00 0A 02 10 D4 E7 00 00 51 E3 6D 00 00 1A 20 00 52 E3 7C 00 00 8A 0B 00 56 E1 21 00 00 DA 07 00 5A E3 00 20 A0 C3 01 20 A0 D3 08 00 50 E1 00 20 A0 23 00 00 52 E3 0D 00 00 0A 08 70 6A E2 07 71 A0 E1 00 10 90 E5 20 A0 67 E2 00 20 A0 E1 03 50 A0 E1 04 30 92 E5 13 CA 81 E1 33 17 A0 E1 00 C0 82 E5 04 10 A2 E5 02 00 58 E1 F8 FF FF 8A 05 30 A0 E1 09 00 50 E1 03 10 A0 91 08 A0 A0 93 DB FF FF 9A 00 20 A0 E3 04 20 20 E5 02 A0 A0 E1 01 20 D3 E5 06 B0 A0 E1 20 00 52 E3 00 80 A0 E1 03 00 00 8A 01 30 83 E2 01 20 D3 E5 20 00 52 E3 FB FF FF 9A D1 20 D3 E1 30 00 52 E3 37 00 00 0A 03 10 A0 E1 01 20 D1 E5 01 30 81 E2 00 00 52 E3 CB FF FF 1A 00 00 56 E3 5D 00 00 0A 07 00 5A E3 00 30 A0 C3 01 30 A0 D3 08 00 50 E1 00 30 A0 23 00 00 53 E3 0B 00 00 0A 08 40 6A E2 04 41 A0 E1 00 20 90 E5 20 50 64 E2 00 30 A0 E1 04 10 93 E5 11 C5 82 E1 31 24 A0 E1 00 C0 83 E5 04 20 A3 E5 03 00 58 E1 F8 FF FF 8A 00 00 59 E1 54 00 00 2A 00 10 9D E5 09 30 A0 E1 04 20 90 E4 00 00 51 E1 04 20 83 E4 FB FF FF 2A 00 10 9D E5 00 20 A0 E3 04 20 83 E4 03 00 51 E1 FC FF FF 2A 00 10 9D E5 00 30 91 E5 00 00 53 E3 0A 00 00 1A 00 30 9D E5 03 00 59 E1 00 30 9D 15 02 00 00 1A 4E 00 00 EA 03 00 59 E1 4C 00 00 0A 04 20 13 E5 04 30 43 E2 00 00 52 E3 F9 FF FF 0A 05 00 A0 E3 2D 00 00 EA D2 20 D3 E1 02 10 83 E2 78 00 52 E3 58 00 52 13 C2 FF FF 1A 03 20 D3 E5 20 00 52 E3 8C FF FF 8A 03 10 A0 E1 BE FF FF EA 01 A0 8A E2 08 00 5A E3 01 60 86 E2 06 00 00 CA 00 20 90 E5 02 22 A0 E1 0F 10 01 E2 01 10 82 E1 00 10 80 E5 03 10 A0 E1 7F FF FF EA 09 00 50 E1 B0 FF FF 9A 00 20 A0 E3 04 20 20 E5 01 A0 A0 E3 F4 FF FF EA 00 60 56 E2 01 60 A0 13 29 00 52 E3 00 60 A0 13 00 00 56 E3 29 00 00 1A 29 00 52 E3 32 00 00 0A D1 20 D3 E1 01 10 83 E2 00 00 52 E3 05 00 00 0A 29 00 52 E3 01 30 A0 E1 2B 00 00 0A D1 20 F1 E1 00 00 52 E3 F9 FF FF 1A 04 00 A0 E3 0C D0 8D E2 F0 8F BD E8 D2 20 D3 E1 02 10 83 E2 78 00 52 E3 58 00 52 13 59 FF FF 1A 03 20 D3 E5 20 00 52 E3 57 FF FF 8A 55 FF FF EA 08 20 9D E5 00 00 52 E3 B2 FF FF 0A 00 30 9D E5 08 10 9D E5 00 20 93 E5 20 30 61 E2 00 10 E0 E3 31 33 02 E0 00 20 9D E5 00 30 82 E5 AB FF FF EA ?? ?? ?? ?? 2C FF FF EA 01 30 A0 E3 00 30 89 E5 05 00 A0 E3 E2 FF FF EA 04 10 9D E5 01 30 83 E2 00 30 81 E5 07 00 5A E3 00 30 A0 C3 01 30 A0 D3 08 00 50 E1 00 30 A0 23 00 00 53 E3 8C FF FF 0A 7F FF FF EA 04 20 9D E5 01 30 83 E2 00 30 82 E5 04 00 A0 E3 D2 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_95_0_2 {
	meta:
		name = "strtof"
		size = 164
		refs = "0018 __strtodg 0030 .text 0098 .data"
	strings:
		$1 = { 04 E0 2D E5 0C D0 4D E2 88 20 9F E5 04 30 8D E2 08 C0 8D E2 00 C0 8D E5 ?? ?? ?? ?? 07 20 00 E2 00 30 A0 E3 06 00 52 E3 02 F1 9F 97 07 00 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 48 30 9F E5 08 00 10 E3 02 31 83 13 03 00 A0 E1 0C D0 8D E2 00 80 BD E8 00 30 A0 E3 F8 FF FF EA 08 20 9D E5 04 30 9D E5 FF 24 C2 E3 96 30 83 E2 02 25 C2 E3 83 3B 82 E1 F1 FF FF EA 08 30 9D E5 EF FF FF EA 08 30 9F E5 ED FF FF EA ?? ?? ?? ?? 00 00 C0 FF 00 00 80 7F }
	condition:
		$1
}

rule file_96_0_2 {
	meta:
		name = "wctype"
		size = 80
		refs = "0018 strcmp 004c .rdata"
	strings:
		$1 = { 70 40 2D E9 40 60 9F E5 00 50 A0 E1 00 40 A0 E3 84 11 96 E7 05 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 84 31 A0 E1 01 40 84 E2 03 00 00 0A 0B 00 54 E3 F6 FF FF 1A 00 00 A0 E3 70 80 BD E8 08 20 9F E5 03 30 82 E0 B4 00 D3 E1 70 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_98_0_2 {
	meta:
		name = "rint"
		size = 404
		refs = "0080 __adddf3 008c __subdf3 0190 .rdata"
	strings:
		$1 = { 41 3A A0 E1 83 3A A0 E1 A3 3A A0 E1 FF 3F 43 E2 03 30 43 E2 13 00 53 E3 70 48 2D E9 01 C0 A0 E1 00 B0 A0 E1 01 50 A0 E1 00 60 A0 E1 A1 4F A0 E1 1B 00 00 CA 00 00 53 E3 2E 00 00 BA 48 21 9F E5 52 23 A0 E1 01 10 02 E0 00 10 91 E1 11 00 00 0A A2 20 A0 E1 0C 10 02 E0 00 10 91 E1 01 60 A0 01 43 00 00 1A 24 11 9F E5 05 30 A0 E1 84 41 81 E0 30 00 94 E8 06 20 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 00 B0 A0 E1 01 C0 A0 E1 0B 00 A0 E1 0C 10 A0 E1 70 88 BD E8 33 00 53 E3 07 00 00 DA 01 0B 53 E3 F8 FF FF 1A 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 00 B0 A0 E1 01 C0 A0 E1 F2 FF FF EA 14 30 43 E2 00 20 E0 E3 32 23 A0 E1 00 00 12 E1 ED FF FF 0A A2 20 A0 E1 00 00 12 E1 02 20 C0 11 01 61 A0 13 56 63 82 11 DA FF FF EA 02 31 C1 E3 00 30 93 E1 E4 FF FF 0A FF 34 C1 E3 0F 36 C3 E3 00 60 83 E1 00 30 66 E2 06 60 83 E1 26 66 A0 E1 A1 38 A0 E1 02 67 06 E2 83 38 A0 E1 03 30 86 E1 03 C0 A0 E1 58 30 9F E5 0B 20 A0 E1 84 31 83 E0 60 00 93 E8 0C 30 A0 E1 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 06 30 A0 E1 05 20 A0 E1 ?? ?? ?? ?? 01 C0 A0 E1 02 31 CC E3 84 3F 83 E1 00 B0 A0 E1 03 C0 A0 E1 C8 FF FF EA 13 00 53 E3 02 20 CC 11 02 58 A0 13 01 61 A0 03 55 53 82 11 B5 FF FF EA FF FF 0F 00 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_1_2 {
	meta:
		name = "mbrtowc"
		size = 84
		refs = "002c __mb_cur_max 0050 .bss"
	strings:
		$1 = { F0 40 2D E9 00 70 50 E2 08 D0 4D E2 02 50 A0 E1 06 70 8D 02 00 20 A0 E3 00 00 53 E3 01 60 A0 E1 B6 20 CD E1 24 40 9F E5 03 40 A0 11 ?? ?? ?? ?? 06 10 A0 E1 00 00 8D E5 05 20 A0 E1 07 00 A0 E1 04 30 A0 E1 B0 FF FF EB 08 D0 8D E2 F0 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_2_2 {
	meta:
		name = "mbsrtowcs"
		size = 276
		refs = "0020 __mb_cur_max 0110 .bss"
	strings:
		$1 = { F0 47 2D E9 00 00 53 E3 08 D0 4D E2 01 60 A0 E1 F8 A0 9F E5 00 50 A0 E1 03 A0 A0 11 02 70 A0 E1 ?? ?? ?? ?? 00 00 56 E3 00 80 A0 E1 21 00 00 0A 00 10 96 E5 00 00 51 E3 1E 00 00 0A 00 00 55 E3 1E 00 00 0A 00 00 57 E3 00 40 A0 13 07 00 00 1A 18 00 00 EA 00 10 96 E5 00 40 84 E0 00 10 81 E0 04 00 57 E1 00 10 86 E5 07 00 00 9A 02 50 85 E2 05 00 A0 E1 07 20 64 E0 0A 30 A0 E1 00 80 8D E5 8C FF FF EB 00 00 50 E3 F1 FF FF CA 01 30 70 E2 00 30 A0 33 07 00 54 E1 00 30 A0 23 00 00 53 E3 03 70 A0 E1 00 30 A0 13 00 30 86 15 04 00 A0 E1 08 D0 8D E2 F0 87 BD E8 00 40 A0 E3 FA FF FF EA 00 00 57 E3 FB FF FF 0A 08 90 8D E2 B2 50 69 E1 05 40 A0 E1 05 00 00 EA 00 10 96 E5 00 40 84 E0 00 10 81 E0 04 00 57 E1 00 10 86 E5 EE FF FF 9A 09 00 A0 E1 08 20 A0 E1 0A 30 A0 E1 00 80 8D E5 6C FF FF EB 00 00 50 E3 F2 FF FF CA E6 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_3_2 {
	meta:
		name = "mbrlen"
		size = 80
		refs = "0028 __mb_cur_max 004c .bss"
	strings:
		$1 = { F0 40 2D E9 08 D0 4D E2 00 00 52 E3 08 40 8D E2 00 30 A0 E3 01 60 A0 E1 B2 30 64 E1 28 50 9F E5 00 70 A0 E1 02 50 A0 11 ?? ?? ?? ?? 07 10 A0 E1 00 00 8D E5 06 20 A0 E1 04 00 A0 E1 05 30 A0 E1 57 FF FF EB 08 D0 8D E2 F0 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_0_2 {
	meta:
		name = "strtoull"
		size = 772
		refs = "005c _isctype 0128 __udivdi3"
	strings:
		$1 = { F0 4F 2D E9 00 00 51 E3 00 00 81 15 01 00 52 E3 00 30 A0 13 01 30 A0 03 08 D0 4D E2 A2 3F 93 E1 00 10 8D E5 00 50 A0 E1 02 60 A0 E1 01 00 00 1A 24 00 52 E3 06 00 00 DA 00 70 A0 E3 00 80 A0 E3 08 10 A0 E1 07 00 A0 E1 08 D0 8D E2 F0 8F BD E8 01 50 85 E2 D0 00 D5 E1 08 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 F9 FF FF 1A 00 30 D5 E5 05 10 A0 E1 03 2C A0 E1 42 2C A0 E1 2D 00 52 E3 00 00 A0 13 01 00 A0 03 00 00 50 E3 04 00 8D E5 68 00 00 0A 01 30 D1 E5 01 50 85 E2 00 00 56 E3 51 00 00 0A 10 00 56 E3 81 00 00 0A 05 40 A0 E1 01 30 D4 E4 03 3C A0 E1 43 0C A0 E1 04 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 51 00 00 0A D0 70 D5 E1 30 70 47 E2 A7 9F A0 E1 06 00 57 E1 01 90 89 A3 00 00 59 E3 C7 8F A0 01 06 A0 A0 01 CA BF A0 01 D1 FF FF 1A D0 00 D4 E1 04 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 21 00 00 0A D0 50 D4 E1 30 50 45 E2 00 00 55 E3 05 00 56 A1 26 00 00 DA 0A 20 A0 E1 0B 30 A0 E1 00 00 E0 E3 00 10 E0 E3 ?? ?? ?? ?? 01 20 A0 E3 00 20 92 E0 00 30 A0 E3 01 30 A3 E0 03 00 58 E1 4B 00 00 8A 48 00 00 0A 97 0B 01 E0 97 2A 83 E0 9A 18 21 E0 05 20 92 E0 03 30 81 E0 C5 3F A3 E0 03 00 58 E1 42 00 00 8A 4C 00 00 0A 02 70 A0 E1 03 80 A0 E1 01 40 84 E2 D0 00 D4 E1 04 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 DD FF FF 1A D0 00 D4 E1 01 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 37 00 00 0A D0 50 D4 E1 37 50 45 E2 00 00 55 E3 05 00 56 A1 D8 FF FF CA 00 30 9D E5 00 00 53 E3 00 40 83 15 00 00 59 E3 00 70 E0 13 00 80 E0 13 9B FF FF 1A 04 00 9D E5 00 00 50 E3 98 FF FF 0A 00 70 77 E2 00 80 E8 E2 95 FF FF EA 03 3C A0 E1 03 02 53 E3 0A 60 A0 13 11 00 00 0A 43 0C A0 E1 04 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 01 40 85 E2 AD FF FF 1A D0 00 D5 E1 01 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 2D 00 00 0A D0 70 D5 E1 37 70 47 E2 A7 9F A0 E1 A7 FF FF EA 2B 00 52 E3 96 FF FF 1A 93 FF FF EA D1 20 D5 E1 58 00 52 E3 78 00 52 13 08 60 A0 13 E8 FF FF 1A 02 50 85 E2 05 40 A0 E1 01 30 D4 E4 10 60 A0 E3 03 3C A0 E1 91 FF FF EA 02 00 57 E1 B4 FF FF 9A 01 90 A0 E3 01 40 84 E2 BD FF FF EA D0 00 D4 E1 02 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 C7 FF FF 0A D0 50 D4 E1 57 50 45 E2 9A FF FF EA 02 00 57 E1 B0 FF FF 9A 01 90 A0 E3 F1 FF FF EA 03 3C A0 E1 03 02 53 E3 CE FF FF 1A D1 30 D5 E1 01 40 85 E2 78 00 53 E3 58 00 53 13 E0 FF FF 0A 00 30 D5 E5 03 3C A0 E1 75 FF FF EA D0 00 D5 E1 02 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 D0 70 D5 11 01 90 A0 03 57 70 47 12 00 70 E0 03 A7 9F A0 11 73 FF FF EA }
	condition:
		$1
}

rule file_101_0_2 {
	meta:
		name = "ctime"
		size = 60
		refs = "0008 localtime 0030 asctime"
	strings:
		$1 = { 04 E0 2D E5 24 D0 4D E2 ?? ?? ?? ?? 0D C0 A0 E1 00 E0 A0 E1 0F 00 BE E8 0F 00 AC E8 0F 00 BE E8 0F 00 AC E8 00 30 9E E5 0D 00 A0 E1 00 30 8C E5 ?? ?? ?? ?? 24 D0 8D E2 00 80 BD E8 }
	condition:
		$1
}

rule file_102_0_2 {
	meta:
		name = "__kernel_sinf"
		size = 332
		refs = "001c __fixsfsi 0030 __mulsf3 0054 __subsf3 0064 __addsf3"
	strings:
		$1 = { 02 31 C0 E3 32 04 53 E3 F0 45 2D E9 00 40 A0 E1 01 50 A0 E1 02 80 A0 E1 02 00 00 AA ?? ?? ?? ?? 00 00 50 E3 33 00 00 0A 04 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 00 60 A0 E1 ?? ?? ?? ?? EC 10 9F E5 00 70 A0 E1 06 00 A0 E1 ?? ?? ?? ?? E0 10 9F E5 ?? ?? ?? ?? 06 10 A0 E1 ?? ?? ?? ?? D4 10 9F E5 ?? ?? ?? ?? 06 10 A0 E1 ?? ?? ?? ?? C8 10 9F E5 ?? ?? ?? ?? 06 10 A0 E1 ?? ?? ?? ?? BC 10 9F E5 ?? ?? ?? ?? 00 00 58 E3 00 A0 A0 E1 1A 00 00 0A 05 00 A0 E1 3F 14 A0 E3 ?? ?? ?? ?? 0A 10 A0 E1 00 80 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 06 10 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 74 10 9F E5 00 50 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 04 00 A0 E1 F0 85 BD E8 00 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 34 10 9F E5 ?? ?? ?? ?? 07 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 04 00 A0 E1 F0 85 BD E8 D3 C9 2E 2F 34 2F D7 32 1B EF 38 36 01 0D 50 39 89 88 08 3C AB AA 2A 3E }
	condition:
		$1
}

rule file_103_0_2 {
	meta:
		name = "__ieee754_rem_pio2"
		size = 1584
		refs = "0040 __subdf3 00c8 __fixdfsi 00cc __floatsidf 00fc __muldf3 0160 __eqdf2 01c8 __kernel_rem_pio2 0244 __adddf3 0604 .rdata"
	strings:
		$1 = { F0 4F 2D E9 D4 35 9F E5 02 41 C1 E3 03 00 54 E1 30 D0 4D E2 01 60 A0 E1 00 80 A0 E1 02 50 A0 E1 75 00 00 DA B8 35 9F E5 03 00 54 E1 19 00 00 CA 00 00 51 E3 10 01 00 DA A8 35 9F E5 A8 25 9F E5 ?? ?? ?? ?? 9C 35 9F E5 00 60 A0 E1 03 00 54 E1 01 70 A0 E1 B1 00 00 0A 90 25 9F E5 90 35 9F E5 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 03 00 85 E8 07 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 6C 25 9F E5 6C 35 9F E5 ?? ?? ?? ?? 01 70 A0 E3 08 00 85 E5 0C 10 85 E5 60 00 00 EA 58 35 9F E5 03 00 54 E1 60 00 00 DA 50 35 9F E5 03 00 54 E1 0A 01 00 CA 44 3A A0 E1 41 8E 43 E2 06 80 48 E2 08 BA 44 E0 0B 10 A0 E1 00 A0 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 00 E0 A0 E1 01 C0 A0 E1 00 20 A0 E1 01 30 A0 E1 0A 00 A0 E1 0B 10 A0 E1 18 E0 8D E5 1C C0 8D E5 ?? ?? ?? ?? 00 20 A0 E3 00 35 9F E5 ?? ?? ?? ?? 00 A0 A0 E1 01 B0 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 00 E0 A0 E1 01 C0 A0 E1 00 20 A0 E1 01 30 A0 E1 0A 00 A0 E1 0B 10 A0 E1 20 E0 8D E5 24 C0 8D E5 ?? ?? ?? ?? 00 20 A0 E3 C0 34 9F E5 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 28 00 8D E5 2C 10 8D E5 02 00 A0 E1 03 10 A0 E1 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 18 A0 8D E2 08 40 8A E2 00 00 50 E3 03 70 A0 E3 08 40 44 E2 0A 00 00 1A 08 20 94 E5 0C 30 94 E5 02 00 A0 E1 03 10 A0 E1 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 01 70 47 E2 08 40 44 E2 F4 FF FF 0A 02 C0 A0 E3 00 C0 8D E5 4C C4 9F E5 07 30 A0 E1 0A 00 A0 E1 08 20 A0 E1 05 10 A0 E1 04 C0 8D E5 ?? ?? ?? ?? 00 00 56 E3 00 70 A0 E1 10 00 00 AA 04 20 95 E5 08 30 85 E2 02 21 82 E2 04 20 85 E5 04 20 93 E5 00 70 60 E2 02 21 82 E2 04 20 83 E5 07 00 00 EA 01 40 A0 E1 00 30 A0 E1 00 10 A0 E3 00 20 A0 E3 08 10 85 E5 0C 20 85 E5 18 00 85 E8 00 70 A0 E3 07 00 A0 E1 30 D0 8D E2 F0 8F BD E8 02 A1 C1 E3 0A 10 A0 E1 D0 23 9F E5 D0 33 9F E5 ?? ?? ?? ?? 00 20 A0 E3 C8 33 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? 00 70 A0 E1 ?? ?? ?? ?? 90 23 9F E5 B4 33 9F E5 08 00 8D E5 0C 10 8D E5 ?? ?? ?? ?? 08 20 A0 E1 0A 30 A0 E1 ?? ?? ?? ?? 74 23 9F E5 00 80 A0 E1 01 90 A0 E1 6C 33 9F E5 08 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 1F 00 57 E3 00 A0 A0 E1 01 B0 A0 E1 34 00 00 CA 70 33 9F E5 01 20 47 E2 02 31 93 E7 04 00 53 E1 2F 00 00 0A 0A 20 A0 E1 0B 30 A0 E1 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 0C 00 85 E8 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 0B 30 A0 E1 0A 20 A0 E1 ?? ?? ?? ?? 00 00 56 E3 08 00 85 E5 0C 10 85 E5 08 30 85 E2 C6 FF FF AA 04 20 95 E5 00 70 67 E2 02 21 82 E2 04 20 85 E5 04 20 93 E5 02 21 82 E2 04 20 83 E5 BE FF FF EA F4 22 9F E5 C8 32 9F E5 ?? ?? ?? ?? EC 22 9F E5 EC 32 9F E5 01 70 A0 E1 00 60 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 03 00 85 E8 07 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? C0 22 9F E5 C0 32 9F E5 ?? ?? ?? ?? 01 70 A0 E3 08 00 85 E5 0C 10 85 E5 A9 FF FF EA 0A 20 A0 E1 0B 30 A0 E1 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 01 30 A0 E1 21 1A A0 E1 81 1A A0 E1 44 4A A0 E1 A1 1A A0 E1 04 10 61 E0 00 20 A0 E1 10 00 51 E3 0C 00 85 E8 C8 FF FF DA 64 22 9F E5 38 32 9F E5 08 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 A0 A0 E1 01 B0 A0 E1 0A 20 A0 E1 0B 30 A0 E1 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 10 00 8D E5 14 10 8D E5 10 30 8D E2 0C 00 93 E8 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? 10 22 9F E5 00 80 A0 E1 01 90 A0 E1 08 32 9F E5 08 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? 00 A0 A0 E1 01 B0 A0 E1 0A 20 A0 E1 0B 30 A0 E1 10 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 01 30 A0 E1 21 1A A0 E1 81 1A A0 E1 A1 1A A0 E1 04 40 61 E0 00 20 A0 E1 31 00 54 E3 0C 00 85 E8 23 00 00 CA 10 90 8D E2 00 03 99 E8 95 FF FF EA 64 31 9F E5 64 21 9F E5 ?? ?? ?? ?? 58 31 9F E5 00 60 A0 E1 03 00 54 E1 01 70 A0 E1 3B 00 00 0A 4C 21 9F E5 4C 31 9F E5 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 03 00 85 E8 07 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 28 21 9F E5 28 31 9F E5 ?? ?? ?? ?? 00 70 E0 E3 08 00 85 E5 0C 10 85 E5 4F FF FF EA 00 20 A0 E1 01 30 A0 E1 00 60 A0 E1 ?? ?? ?? ?? 00 70 A0 E3 03 00 85 E8 08 00 85 E5 0C 10 85 E5 46 FF FF EA 2E 24 A0 E3 18 31 9F E5 08 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 A0 A0 E1 01 B0 A0 E1 0A 20 A0 E1 0B 30 A0 E1 10 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 80 A0 E1 01 90 A0 E1 08 20 A0 E1 09 30 A0 E1 10 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? C8 20 9F E5 00 A0 A0 E1 01 B0 A0 E1 C0 30 9F E5 08 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? 00 A0 A0 E1 01 B0 A0 E1 49 FF FF EA 88 20 9F E5 5C 30 9F E5 ?? ?? ?? ?? 80 20 9F E5 80 30 9F E5 01 70 A0 E1 00 60 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 03 00 85 E8 07 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 54 20 9F E5 54 30 9F E5 ?? ?? ?? ?? 00 70 E0 E3 08 00 85 E5 0C 10 85 E5 0E FF FF EA FB 21 E9 3F 7B D9 02 40 FB 21 F9 3F 00 00 40 54 31 63 62 1A 61 B4 D0 3D FB 21 39 41 FF FF EF 7F 00 00 70 41 ?? ?? ?? ?? 83 C8 C9 6D 30 5F E4 3F 00 00 E0 3F FB 21 F9 BF ?? ?? ?? ?? 00 00 60 1A 73 70 03 2E 8A 19 A3 3B C1 49 20 25 9A 83 7B 39 }
	condition:
		$1
}

rule file_104_0_2 {
	meta:
		name = "__gethex_D2A"
		size = 1992
		refs = "0124 __Balloc_D2A 01a4 __clzsi2 0224 __Bfree_D2A 0400 hexdig_init_D2A 04ac __any_on_D2A 04d8 __rshift_D2A 0518 __increment_D2A 0594 __lshift_D2A 07c4 __hexdig_D2A"
	strings:
		$1 = { F0 4F 2D E9 B8 47 9F E5 00 50 A0 E1 30 00 D4 E5 10 D0 4D E2 00 00 50 E3 01 B0 A0 E1 0C 20 8D E5 04 30 8D E5 F5 00 00 0A 04 10 9D E5 00 20 95 E5 00 30 A0 E3 00 30 81 E5 02 10 D2 E5 02 60 82 E2 30 00 51 E3 05 00 00 1A 03 20 82 E2 02 60 A0 E1 01 10 D2 E4 01 30 83 E2 30 00 51 E3 FA FF FF 0A 01 20 D4 E7 00 00 52 E3 9C 00 00 0A 00 90 A0 E3 00 10 D6 E5 01 30 83 E2 06 20 A0 E1 09 00 A0 E1 00 00 00 EA 01 10 F2 E5 01 C0 D4 E7 00 00 5C E3 FB FF FF 1A 2E 00 51 E3 00 00 50 03 C7 00 00 0A 02 70 A0 E1 00 00 50 E3 00 00 67 10 08 00 8D 05 00 01 A0 11 00 20 D7 05 00 20 D7 15 08 00 8D 15 50 00 52 E3 5B 00 00 0A 70 00 52 E3 59 00 00 0A 00 20 A0 E3 00 20 8D E5 07 C0 A0 E1 02 00 A0 E1 00 00 53 E3 01 30 46 02 00 C0 85 E5 00 30 85 05 00 00 59 E3 00 70 A0 13 4B 00 00 1A 00 00 50 E3 7D 00 00 1A 01 30 47 E2 03 30 66 E0 07 00 53 E3 03 00 00 DA C3 30 A0 E1 07 00 53 E3 01 00 80 E2 FB FF FF CA ?? ?? ?? ?? 07 00 56 E1 14 A0 80 E2 00 50 A0 E1 00 A0 8D E5 0A 90 A0 21 20 00 A0 23 00 80 A0 23 17 00 00 2A 00 80 A0 E3 0A 90 A0 E1 08 30 A0 E1 00 00 00 EA 01 30 A0 E1 01 20 57 E5 04 10 83 E2 2E 00 52 E3 03 10 A0 01 08 00 00 0A 20 00 53 E3 04 80 89 04 01 20 57 05 00 80 A0 03 02 20 D4 E7 08 30 A0 01 0F 20 02 E2 12 83 88 E1 04 10 A0 03 01 70 47 E2 07 00 56 E1 ED FF FF 3A 08 00 A0 E1 ?? ?? ?? ?? 04 80 89 E4 09 90 6A E0 49 61 A0 E1 10 60 85 E5 00 40 9B E5 86 62 60 E0 04 00 56 E1 18 01 00 CA EE 00 00 BA 00 60 A0 E3 08 30 9B E5 08 10 9D E5 03 00 51 E1 E5 00 00 CA 04 70 9B E5 08 20 9D E5 07 00 52 E1 01 70 A0 A3 BD 00 00 AA 08 30 9D E5 07 70 63 E0 07 00 54 E1 A1 00 00 CA 0C 30 9B E5 02 00 53 E3 62 01 00 0A 03 00 53 E3 5C 01 00 0A 01 00 53 E3 51 01 00 0A 05 00 A0 E1 ?? ?? ?? ?? 50 70 A0 E3 07 00 A0 E1 10 D0 8D E2 F0 8F BD E8 01 20 D7 E5 01 C0 87 E2 2B 00 52 E3 76 00 00 0A 2D 00 52 E3 00 10 A0 13 00 10 8D 15 E6 00 00 0A 02 20 D4 E7 00 00 52 E3 63 00 00 0A 19 00 52 E3 61 00 00 CA 01 00 DC E5 4C 15 9F E5 10 20 42 E2 00 10 D1 E7 01 C0 8C E2 00 00 51 E3 35 01 00 0A 19 00 51 E3 33 01 00 CA 00 00 A0 E3 01 00 00 EA 19 00 51 E3 08 00 00 CA 01 A0 FC E5 10 80 41 E2 0A 10 D4 E7 3E 03 12 E3 01 00 A0 13 02 21 82 E0 00 00 51 E3 82 20 88 E0 F4 FF FF 1A 00 10 9D E5 00 00 51 E3 08 10 9D E5 00 20 62 12 02 10 81 E0 08 10 8D E5 7F FF FF EA 2E 00 51 E3 52 00 00 0A 08 20 8D E5 00 20 D6 E5 06 70 A0 E1 01 90 A0 E3 70 FF FF EA 00 20 9D E5 00 00 52 E3 3F 00 00 1A 0C 30 9B E5 02 00 53 E3 0B 01 00 0A 03 00 53 E3 E0 00 00 0A 01 00 53 E3 E1 00 00 0A 00 40 9B E5 1F 60 14 E2 C4 42 A0 E1 04 50 A0 01 01 50 84 12 C5 30 B0 E1 03 00 A0 01 03 00 00 0A 00 00 A0 E3 C3 30 B0 E1 01 00 80 E2 FC FF FF 1A ?? ?? ?? ?? 04 10 9D E5 00 00 54 E3 00 00 81 E5 10 50 80 E5 00 30 A0 D3 08 00 00 DA 00 20 A0 E1 00 30 A0 E3 00 10 E0 E3 01 30 83 E2 04 00 53 E1 14 10 82 E5 04 20 82 E2 FA FF FF 1A 04 30 A0 E1 04 00 55 E1 20 20 A0 C3 20 60 66 C2 52 26 A0 C1 03 31 80 C0 14 20 83 C5 04 30 9B E5 0C 20 9D E5 11 70 A0 E3 00 30 82 E5 9A FF FF EA 01 10 D2 E5 01 70 82 E2 01 20 D4 E7 00 00 52 E3 07 00 A0 01 32 FF FF 0A 07 20 A0 E1 01 10 F2 E5 01 10 D4 E7 00 00 51 E3 FB FF FF 1A 07 00 A0 E1 2A FF FF EA 07 C0 A0 E1 00 00 A0 E3 37 FF FF EA ?? ?? ?? ?? 07 FF FF EA 0C 30 9B E5 02 00 53 E3 A7 00 00 0A 03 00 53 E3 65 00 00 0A 50 70 A0 E3 81 FF FF EA 00 20 A0 E3 00 20 8D E5 01 20 FC E5 88 FF FF EA 01 20 D6 E5 84 13 9F E5 01 70 86 E2 02 10 D1 E7 00 00 51 E3 08 10 8D 05 01 90 A0 03 1A FF FF 0A 30 00 52 E3 A0 00 00 1A 07 20 A0 E1 01 10 F2 E5 30 00 51 E3 FC FF FF 0A 01 30 D4 E7 00 00 53 E3 9B 00 00 1A 01 90 A0 E3 07 00 A0 E1 02 60 A0 E1 09 30 A0 E1 FE FE FF EA 00 00 56 E3 01 80 47 E2 01 60 A0 13 05 00 00 1A 00 00 58 E3 03 00 00 DA 05 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 60 A0 E1 00 20 9D E5 C8 32 A0 E1 03 31 92 E7 1F 80 08 E2 01 20 A0 E3 12 38 13 E0 07 10 A0 E1 05 00 A0 E1 02 60 86 13 ?? ?? ?? ?? 04 30 9B E5 04 40 67 E0 08 30 8D E5 02 70 A0 E3 00 00 56 E3 48 00 00 0A 0C 30 9B E5 02 00 53 E3 71 00 00 1A 34 20 9D E5 01 30 62 E2 00 00 53 E3 71 00 00 0A 05 00 A0 E1 10 60 95 E5 ?? ?? ?? ?? 02 00 57 E3 00 50 A0 E1 36 00 00 0A 10 30 90 E5 03 00 56 E1 07 00 00 BA 1F 40 14 E2 7F 00 00 0A 06 61 80 E0 10 00 96 E5 ?? ?? ?? ?? 20 30 64 E2 00 00 53 E1 79 00 00 DA 01 10 A0 E3 05 00 A0 E1 ?? ?? ?? ?? 08 10 9D E5 08 30 9B E5 01 10 81 E2 03 00 51 E1 08 10 8D E5 70 00 00 DA 05 00 A0 E1 ?? ?? ?? ?? A3 70 A0 E3 28 FF FF EA 04 60 66 E0 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 08 10 9D E5 14 20 80 E2 01 10 66 E0 00 50 A0 E1 08 10 8D E5 00 20 8D E5 05 FF FF EA 34 10 9D E5 00 00 51 E3 96 FF FF 0A 00 00 A0 E3 ?? ?? ?? ?? 01 30 A0 E3 00 50 A0 E1 14 30 80 E5 10 30 80 E5 04 30 9B E5 04 20 9D E5 0C 10 9D E5 00 50 82 E5 00 30 81 E5 62 70 A0 E3 0D FF FF EA 01 10 A0 E3 00 10 8D E5 01 20 FC E5 14 FF FF EA 00 30 9B E5 01 30 43 E2 04 00 53 E1 42 00 00 0A 22 70 A0 E3 0C 00 9D E9 0C 10 9D E5 00 50 82 E5 00 30 81 E5 FF FE FF EA 06 70 64 E0 05 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 00 60 50 E2 0F 00 00 0A 01 10 47 E2 C1 32 A0 E1 03 31 85 E0 14 30 93 E5 1F 20 01 E2 01 60 A0 E3 16 32 13 E0 07 00 00 0A 00 00 51 E3 04 00 00 DA 05 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 02 60 86 12 00 00 00 1A 02 60 A0 E3 05 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 08 30 9D E5 07 30 83 E0 08 30 8D E5 CB FE FF EA 34 30 9D E5 00 00 53 E3 1D FF FF 0A A3 70 A0 E3 DD FE FF EA 34 30 9D E5 00 00 53 E3 BF FF FF 0A 50 70 A0 E3 D8 FE FF EA 03 00 53 E3 21 00 00 0A 01 00 53 E3 08 00 00 0A 10 70 87 E3 CD FF FF EA 00 10 D7 E5 07 20 A0 E1 07 00 A0 E1 02 60 A0 E1 00 90 A0 E3 01 30 A0 E3 62 FE FF EA 02 00 16 E3 F4 FF FF 0A 00 10 9D E5 00 30 91 E5 03 60 86 E1 01 00 16 E3 7D FF FF 1A 10 70 87 E3 BD FF FF EA C4 32 A0 E1 03 31 80 E0 14 30 93 E5 1F 40 04 E2 01 20 A0 E3 12 34 13 E0 B5 FF FF 0A 21 70 A0 E3 B4 FF FF EA 34 20 9D E5 00 00 52 E3 F4 FE FF 1A A3 70 A0 E3 B4 FE FF EA 34 30 9D E5 69 FF FF EA 00 00 A0 E3 D6 FE FF EA 04 00 57 E1 AB FE FF 1A 01 00 54 E3 0C 00 00 CA 00 10 9D E5 01 30 A0 E3 00 30 81 E5 10 30 85 E5 92 FF FF EA 34 20 9D E5 00 00 52 E3 A1 FE FF 0A F6 FF FF EA 34 10 9D E5 00 00 51 E3 F3 FF FF 0A 9C FE FF EA 01 10 44 E2 05 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 ED FF FF 1A 96 FE FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_105_0_2 {
	meta:
		name = "_access"
		size = 76
		refs = "0010 stat"
	strings:
		$1 = { 10 40 2D E9 20 D0 4D E2 01 40 A0 E1 0D 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 09 00 00 1A B4 30 DD E1 01 09 13 E3 03 00 00 1A 02 00 14 E3 01 00 00 0A 80 00 13 E3 02 00 00 0A 00 00 A0 E3 20 D0 8D E2 10 80 BD E8 00 00 E0 E3 FB FF FF EA }
	condition:
		$1
}

rule file_106_0_2 {
	meta:
		name = "erfcf"
		size = 1640
		refs = "0034 __mulsf3 0048 __subsf3 0078 __addsf3 00dc __divsf3 021c __floatunsisf 038c __ieee754_expf"
	strings:
		$1 = { 68 35 9F E5 F0 47 2D E9 02 41 C0 E3 03 00 54 E1 00 50 A0 E1 00 60 A0 E1 7D 00 00 CA 50 35 9F E5 03 00 54 E1 38 00 00 CA 8E 05 54 E3 F2 00 00 BA 00 10 A0 E1 ?? ?? ?? ?? 38 15 9F E5 00 40 A0 E1 ?? ?? ?? ?? 30 15 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 24 15 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 18 15 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 0C 15 9F E5 ?? ?? ?? ?? 08 15 9F E5 00 70 A0 E1 04 00 A0 E1 ?? ?? ?? ?? FC 14 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? F0 14 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? E4 14 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? D8 14 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 07 00 A0 E1 ?? ?? ?? ?? FA 05 55 E3 00 10 A0 E1 C7 00 00 AA 05 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 FE 05 A0 E3 ?? ?? ?? ?? F0 87 BD E8 8C 34 9F E5 03 00 54 E1 49 00 00 CA FE 15 A0 E3 02 01 C0 E3 ?? ?? ?? ?? 78 14 9F E5 00 40 A0 E1 ?? ?? ?? ?? 70 14 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 64 14 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 58 14 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 4C 14 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 40 14 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 34 14 9F E5 ?? ?? ?? ?? 30 14 9F E5 00 50 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 24 14 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 18 14 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 0C 14 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 00 14 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? F4 13 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 00 00 56 E3 00 10 A0 E1 CF 00 00 BA 05 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 C8 03 9F E5 ?? ?? ?? ?? F0 87 BD E8 A0 0F A0 E1 80 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 00 40 A0 E1 FE 05 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? F0 87 BD E8 94 33 9F E5 03 00 54 E1 7B 00 00 CA 02 71 C0 E3 07 10 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 FE 05 A0 E3 ?? ?? ?? ?? 70 33 9F E5 00 50 A0 E1 03 00 54 E1 74 00 00 DA 64 23 9F E5 A6 3F A0 E1 02 00 54 E1 00 40 A0 D3 01 40 03 C2 00 00 54 E3 A7 00 00 1A 4C 13 9F E5 ?? ?? ?? ?? 48 13 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 3C 13 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 30 13 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 24 13 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 18 13 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 0C 13 9F E5 ?? ?? ?? ?? 08 13 9F E5 00 A0 A0 E1 05 00 A0 E1 ?? ?? ?? ?? FC 12 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? F0 12 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? E4 12 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? D8 12 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? CC 12 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? C0 12 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? FF 4E C7 E3 0F 40 C4 E3 04 10 A0 E1 00 80 A0 E1 02 01 84 E2 ?? ?? ?? ?? 94 12 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? 07 10 A0 E1 00 50 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 00 90 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 09 00 A0 E1 ?? ?? ?? ?? 08 10 A0 E1 00 40 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 00 56 E3 59 00 00 DA 07 10 A0 E1 ?? ?? ?? ?? F0 87 BD E8 00 10 A0 E1 FE 05 A0 E3 ?? ?? ?? ?? F0 87 BD E8 05 00 A0 E1 ?? ?? ?? ?? 3F 14 A0 E3 00 40 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 3F 04 A0 E3 ?? ?? ?? ?? F0 87 BD E8 00 00 50 E3 3B 00 00 DA 00 00 A0 E3 F0 87 BD E8 D0 11 9F E5 ?? ?? ?? ?? CC 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? C0 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? B4 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? A8 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 9C 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 90 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 84 11 9F E5 ?? ?? ?? ?? 80 11 9F E5 00 A0 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 74 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 68 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 5C 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 50 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 44 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 38 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 2C 11 9F E5 88 FF FF EA 01 01 A0 E3 F0 87 BD E8 05 00 A0 E1 ?? ?? ?? ?? 18 11 9F E5 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? F0 87 BD E8 07 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 01 01 A0 E3 ?? ?? ?? ?? F0 87 BD E8 FF FF 7F 7F FF FF 57 3F B1 56 C7 B7 89 14 BD 3B 8F 52 E9 3C EB 6B A6 3E D4 75 03 3E 1A E2 84 B6 49 EE 0A 39 16 81 A6 3B 63 2A 85 3D CE BB CB 3E FF FF 9F 3F C0 F9 0D BB B3 51 11 3D C2 1C E3 3D 54 FE A2 3E 08 92 BE 3E 05 68 D4 3E C6 CD 1A 3B A3 5A 44 3C 13 6E 5F 3C 07 33 01 3E E7 1A 93 3D 85 57 0A 3F 31 F3 D9 3D D4 A7 1E 3E FF FF DF 41 6C DB 36 40 FF FF BF 40 75 C2 F1 C3 0B 23 80 44 41 64 1F 44 EA A2 20 43 4B 10 8E 41 D4 9D 4C 3F 92 A0 21 3C 12 87 B3 C1 A7 43 ED 43 CE 90 1F 45 BB FD 47 45 59 17 C0 44 71 E5 A2 43 59 B4 F2 41 00 00 10 3F 7E 07 1D C1 2B 93 A2 42 E7 9A 38 43 8C 65 22 43 57 80 79 42 22 F0 28 41 B7 A0 31 3F 93 A0 21 3C 97 7F 77 BD 7C 3F D2 40 1F 45 D9 42 0B 81 D6 43 C9 58 21 44 6F 48 D9 43 63 A8 09 43 CE 35 9D 41 0B 56 58 3F }
	condition:
		$1
}

rule file_106_1_2 {
	meta:
		name = "erff"
		size = 1604
		refs = "003c __mulsf3 0058 __addsf3 007c __subsf3 015c __divsf3 0178 __floatsisf 03b8 __ieee754_expf"
	strings:
		$1 = { 40 35 9F E5 F0 47 2D E9 02 41 C0 E3 03 00 54 E1 00 50 A0 E1 00 60 A0 E1 53 00 00 CA 28 35 9F E5 03 00 54 E1 0F 00 00 CA C6 05 54 E3 61 00 00 AA 7F 03 74 E3 91 00 00 CA 41 14 A0 E3 ?? ?? ?? ?? 08 15 9F E5 00 40 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 3E 14 A0 E3 ?? ?? ?? ?? F0 87 BD E8 E4 34 9F E5 03 00 54 E1 49 00 00 CA FE 15 A0 E3 02 01 C0 E3 ?? ?? ?? ?? D0 14 9F E5 00 40 A0 E1 ?? ?? ?? ?? C8 14 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? BC 14 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? B0 14 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? A4 14 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 98 14 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 8C 14 9F E5 ?? ?? ?? ?? 88 14 9F E5 00 50 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 7C 14 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 70 14 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 64 14 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 58 14 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 4C 14 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 00 00 56 E3 00 10 A0 E1 F0 00 00 BA 05 00 A0 E1 ?? ?? ?? ?? 24 14 9F E5 ?? ?? ?? ?? F0 87 BD E8 A0 6F A0 E1 86 00 A0 E1 01 00 60 E2 ?? ?? ?? ?? 05 10 A0 E1 00 40 A0 E1 FE 05 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? F0 87 BD E8 EC 33 9F E5 03 00 54 E1 3A 00 00 DA 00 00 50 E3 E0 03 9F B5 FE 05 A0 A3 F0 87 BD E8 00 10 A0 E1 ?? ?? ?? ?? D0 13 9F E5 00 40 A0 E1 ?? ?? ?? ?? C8 13 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? BC 13 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? B0 13 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? A4 13 9F E5 ?? ?? ?? ?? A0 13 9F E5 00 60 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 94 13 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 88 13 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 7C 13 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 70 13 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? F0 87 BD E8 20 13 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? F0 87 BD E8 02 71 C0 E3 07 10 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 FE 05 A0 E3 ?? ?? ?? ?? 08 33 9F E5 00 50 A0 E1 03 00 54 E1 5C 00 00 DA FC 12 9F E5 ?? ?? ?? ?? F8 12 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? EC 12 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? E0 12 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? D4 12 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? C8 12 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? BC 12 9F E5 ?? ?? ?? ?? B8 12 9F E5 00 A0 A0 E1 05 00 A0 E1 ?? ?? ?? ?? AC 12 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? A0 12 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 94 12 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 88 12 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 7C 12 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 70 12 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? FF 4E C7 E3 0F 40 C4 E3 04 10 A0 E1 00 80 A0 E1 02 01 84 E2 ?? ?? ?? ?? 44 12 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? 07 10 A0 E1 00 50 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 00 90 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 09 00 A0 E1 ?? ?? ?? ?? 08 10 A0 E1 00 40 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 00 56 E3 45 00 00 BA 07 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 FE 05 A0 E3 ?? ?? ?? ?? F0 87 BD E8 C4 11 9F E5 ?? ?? ?? ?? C0 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? B4 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? A8 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 9C 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 90 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 84 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 78 11 9F E5 ?? ?? ?? ?? 74 11 9F E5 00 A0 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 68 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 5C 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 50 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 44 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 38 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 2C 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 20 11 9F E5 99 FF FF EA 05 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 10 01 9F E5 ?? ?? ?? ?? F0 87 BD E8 07 10 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? F0 87 BD E8 FF FF 7F 7F FF FF 57 3F D4 75 83 3F FF FF 9F 3F C0 F9 0D BB B3 51 11 3D C2 1C E3 3D 54 FE A2 3E 08 92 BE 3E 05 68 D4 3E C6 CD 1A 3B A3 5A 44 3C 13 6E 5F 3C 07 33 01 3E E7 1A 93 3D 85 57 0A 3F 31 F3 D9 3D 0B 56 58 3F FF FF BF 40 00 00 80 BF B1 56 C7 B7 89 14 BD 3B 8F 52 E9 3C EB 6B A6 3E D4 75 03 3E 1A E2 84 B6 49 EE 0A 39 16 81 A6 3B 63 2A 85 3D CE BB CB 3E 6D DB 36 40 75 C2 F1 C3 0B 23 80 44 41 64 1F 44 EA A2 20 43 4B 10 8E 41 D4 9D 4C 3F 92 A0 21 3C 12 87 B3 C1 A7 43 ED 43 CE 90 1F 45 BB FD 47 45 59 17 C0 44 71 E5 A2 43 59 B4 F2 41 00 00 10 3F 7E 07 1D C1 2B 93 A2 42 E7 9A 38 43 8C 65 22 43 57 80 79 42 22 F0 28 41 B7 A0 31 3F 93 A0 21 3C 97 7F 77 BD 7C 3F D2 40 1F 45 D9 42 0B 81 D6 43 C9 58 21 44 6F 48 D9 43 63 A8 09 43 CE 35 9D 41 0B 56 58 BF }
	condition:
		$1
}

rule file_107_0_2 {
	meta:
		name = "_wtelldir"
		size = 52
		refs = "000c SetLastError"
	strings:
		$1 = { 10 40 2D E9 00 40 A0 E1 00 00 A0 E3 ?? ?? ?? ?? 00 00 54 E3 01 00 00 0A 30 04 94 E5 10 80 BD E8 08 00 9F E5 ?? ?? ?? ?? 00 00 E0 E3 10 80 BD E8 E7 01 00 00 }
	condition:
		$1
}

rule file_107_1_2 {
	meta:
		name = "_wrewinddir"
		size = 72
		refs = "000c SetLastError 0020 _findclose"
	strings:
		$1 = { 10 40 2D E9 00 40 A0 E1 00 00 A0 E3 ?? ?? ?? ?? 00 00 54 E3 07 00 00 0A 2C 04 94 E5 01 00 70 E3 ?? ?? ?? ?? 00 30 A0 E3 30 34 84 E5 00 30 E0 E3 2C 34 84 E5 10 80 BD E8 04 00 9F E5 10 40 BD E8 ?? ?? ?? ?? E7 01 00 00 }
	condition:
		$1
}

rule file_107_2_2 {
	meta:
		name = "_wclosedir"
		size = 84
		refs = "000c SetLastError 0028 _findclose 0034 free"
	strings:
		$1 = { 30 40 2D E9 00 40 A0 E1 00 00 A0 E3 ?? ?? ?? ?? 00 00 54 E3 09 00 00 0A 2C 04 94 E5 01 00 70 E3 00 50 A0 03 01 00 00 0A ?? ?? ?? ?? 00 50 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 05 00 A0 E1 30 80 BD E8 08 00 9F E5 ?? ?? ?? ?? 00 50 E0 E3 F9 FF FF EA E7 01 00 00 }
	condition:
		$1
}

rule file_107_3_2 {
	meta:
		name = "_wreaddir"
		size = 252
		refs = "000c SetLastError 0038 _wfindnext 0060 wcslen 0074 wcscpy 008c _wfindfirst 00c0 GetLastError 00d0 _findclose"
	strings:
		$1 = { 30 40 2D E9 00 40 A0 E1 00 00 A0 E3 ?? ?? ?? ?? 00 00 54 E3 25 00 00 0A 30 54 94 E5 00 00 55 E3 01 00 00 AA 00 00 A0 E3 30 80 BD E8 13 00 00 0A 2C 04 94 E5 04 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 1E 00 00 1A 30 34 94 E5 01 30 83 E2 00 00 53 E3 30 34 84 E5 F2 FF FF DA 14 50 84 E2 05 00 A0 E1 ?? ?? ?? ?? 88 30 9F E5 05 10 A0 E1 B3 00 84 E1 89 0F 84 E2 ?? ?? ?? ?? 87 0F 84 E2 30 80 BD E8 43 0E 84 E2 04 00 80 E2 04 10 A0 E1 ?? ?? ?? ?? 01 00 70 E3 01 30 A0 13 2C 04 84 E5 30 04 84 05 30 34 84 15 05 00 A0 01 EA FF FF 1A 30 80 BD E8 40 00 9F E5 ?? ?? ?? ?? 04 00 A0 E1 30 80 BD E8 ?? ?? ?? ?? 12 00 50 E3 06 00 00 0A 2C 04 94 E5 ?? ?? ?? ?? 00 30 E0 E3 30 34 84 E5 2C 34 84 E5 00 00 A0 E3 30 80 BD E8 00 00 A0 E3 ?? ?? ?? ?? F5 FF FF EA 22 02 00 00 E7 01 00 00 }
	condition:
		$1
}

rule file_107_4_2 {
	meta:
		name = "_wseekdir"
		size = 136
		refs = "0010 SetLastError 002c _wrewinddir 0040 _wreaddir 0058 _findclose"
	strings:
		$1 = { 30 40 2D E9 00 40 A0 E1 00 00 A0 E3 01 50 A0 E1 ?? ?? ?? ?? 00 00 54 E3 16 00 00 0A 01 00 75 E3 11 00 00 BA 09 00 00 0A 04 00 A0 E1 8D FF FF EB 30 34 94 E5 04 00 A0 E1 03 00 55 E1 30 80 BD D8 AF FF FF EB 00 00 50 E3 F8 FF FF 1A 30 80 BD E8 2C 04 94 E5 01 00 70 E3 ?? ?? ?? ?? 00 30 E0 E3 30 34 84 E5 2C 34 84 E5 30 80 BD E8 57 00 A0 E3 30 40 BD E8 ?? ?? ?? ?? 04 00 9F E5 30 40 BD E8 ?? ?? ?? ?? E7 01 00 00 }
	condition:
		$1
}

rule file_107_5_2 {
	meta:
		name = "_wopendir"
		size = 436
		refs = "0010 SetLastError 0040 GetFileAttributesW 0068 wcsncpy 0070 wcslen 00a0 malloc 00c8 wcscpy 00e4 wcscat 0118 memset 0138 wcsrchr 01a4 .rdata"
	strings:
		$1 = { F0 40 2D E9 00 50 A0 E1 82 DF 4D E2 00 00 A0 E3 ?? ?? ?? ?? 00 00 55 E3 40 00 00 0A B0 40 D5 E1 00 00 54 E3 04 00 00 1A 70 01 9F E5 ?? ?? ?? ?? 04 00 A0 E1 82 DF 8D E2 F0 80 BD E8 05 00 A0 E1 ?? ?? ?? ?? 01 00 70 E3 01 00 00 1A 00 40 A0 E3 F6 FF FF EA 10 00 10 E3 FB FF FF 0A 05 10 A0 E1 41 2F A0 E3 0D 00 A0 E1 ?? ?? ?? ?? 0D 00 A0 E1 ?? ?? ?? ?? 00 50 A0 E1 24 01 9F E5 ?? ?? ?? ?? 00 40 A0 E1 1C 01 9F E5 ?? ?? ?? ?? 04 30 85 E0 87 3F 83 E2 01 30 83 E2 00 00 83 E0 80 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 0D 60 A0 E1 00 50 A0 E1 00 40 A0 E1 DD FF FF 0A 43 7E 80 E2 04 70 87 E2 0D 10 A0 E1 07 00 A0 E1 ?? ?? ?? ?? D8 30 9F E5 B3 30 95 E1 00 00 53 E3 14 00 00 1A 07 00 A0 E1 C0 10 9F E5 ?? ?? ?? ?? 00 C0 E0 E3 00 30 A0 E3 2C C4 85 E5 22 CE A0 E3 BC 30 85 E1 02 C0 8C E2 89 0F 85 E2 03 10 A0 E1 41 2F A0 E3 BC 30 85 E1 30 34 85 E5 1C 32 85 E5 ?? ?? ?? ?? C3 FF FF EA 88 00 9F E5 ?? ?? ?? ?? 05 40 A0 E1 BF FF FF EA 2F 10 A0 E3 07 00 A0 E1 ?? ?? ?? ?? 00 60 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 85 0F 80 E2 03 00 80 E2 80 30 85 E0 04 30 83 E2 03 00 56 E1 DE FF FF 0A 5C 10 A0 E3 07 00 A0 E1 ?? ?? ?? ?? 00 60 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 85 0F 80 E2 03 00 80 E2 80 30 85 E0 04 30 83 E2 03 00 56 E1 D2 FF FF 0A 07 00 A0 E1 08 10 9F E5 ?? ?? ?? ?? CE FF FF EA 0B 01 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 34 04 00 00 E7 01 00 00 }
	condition:
		$1
}

rule file_109_0_2 {
	meta:
		name = "telldir"
		size = 52
		refs = "000c SetLastError"
	strings:
		$1 = { 10 40 2D E9 00 40 A0 E1 00 00 A0 E3 ?? ?? ?? ?? 00 00 54 E3 01 00 00 0A 28 02 94 E5 10 80 BD E8 08 00 9F E5 ?? ?? ?? ?? 00 00 E0 E3 10 80 BD E8 E7 01 00 00 }
	condition:
		$1
}

rule file_109_1_2 {
	meta:
		name = "rewinddir"
		size = 72
		refs = "000c SetLastError 0020 _findclose"
	strings:
		$1 = { 10 40 2D E9 00 40 A0 E1 00 00 A0 E3 ?? ?? ?? ?? 00 00 54 E3 07 00 00 0A 24 02 94 E5 01 00 70 E3 ?? ?? ?? ?? 00 30 A0 E3 28 32 84 E5 00 30 E0 E3 24 32 84 E5 10 80 BD E8 04 00 9F E5 10 40 BD E8 ?? ?? ?? ?? E7 01 00 00 }
	condition:
		$1
}

rule file_109_2_2 {
	meta:
		name = "closedir"
		size = 84
		refs = "000c SetLastError 0028 _findclose 0034 free"
	strings:
		$1 = { 30 40 2D E9 00 40 A0 E1 00 00 A0 E3 ?? ?? ?? ?? 00 00 54 E3 09 00 00 0A 24 02 94 E5 01 00 70 E3 00 50 A0 03 01 00 00 0A ?? ?? ?? ?? 00 50 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 05 00 A0 E1 30 80 BD E8 08 00 9F E5 ?? ?? ?? ?? 00 50 E0 E3 F9 FF FF EA E7 01 00 00 }
	condition:
		$1
}

rule file_109_3_2 {
	meta:
		name = "readdir"
		size = 248
		refs = "000c SetLastError 0038 _findnext 0060 strlen 0074 strcpy 0088 _findfirst 00bc GetLastError 00cc _findclose"
	strings:
		$1 = { 30 40 2D E9 00 40 A0 E1 00 00 A0 E3 ?? ?? ?? ?? 00 00 54 E3 24 00 00 0A 28 52 94 E5 00 00 55 E3 01 00 00 AA 00 00 A0 E3 30 80 BD E8 13 00 00 0A 24 02 94 E5 04 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 1D 00 00 1A 28 32 94 E5 01 30 83 E2 00 00 53 E3 28 32 84 E5 F2 FF FF DA 14 50 84 E2 05 00 A0 E1 ?? ?? ?? ?? 84 30 9F E5 05 10 A0 E1 B3 00 84 E1 12 0E 84 E2 ?? ?? ?? ?? 46 0F 84 E2 30 80 BD E8 8B 0F 84 E2 04 10 A0 E1 ?? ?? ?? ?? 01 00 70 E3 01 30 A0 13 24 02 84 E5 28 02 84 05 28 32 84 15 05 00 A0 01 EB FF FF 1A 30 80 BD E8 40 00 9F E5 ?? ?? ?? ?? 04 00 A0 E1 30 80 BD E8 ?? ?? ?? ?? 12 00 50 E3 06 00 00 0A 24 02 94 E5 ?? ?? ?? ?? 00 30 E0 E3 28 32 84 E5 24 32 84 E5 00 00 A0 E3 30 80 BD E8 00 00 A0 E3 ?? ?? ?? ?? F5 FF FF EA 1E 01 00 00 E7 01 00 00 }
	condition:
		$1
}

rule file_109_4_2 {
	meta:
		name = "seekdir"
		size = 136
		refs = "0010 SetLastError 002c rewinddir 0040 readdir 0058 _findclose"
	strings:
		$1 = { 30 40 2D E9 00 40 A0 E1 00 00 A0 E3 01 50 A0 E1 ?? ?? ?? ?? 00 00 54 E3 16 00 00 0A 01 00 75 E3 11 00 00 BA 09 00 00 0A 04 00 A0 E1 8E FF FF EB 28 32 94 E5 04 00 A0 E1 03 00 55 E1 30 80 BD D8 B0 FF FF EB 00 00 50 E3 F8 FF FF 1A 30 80 BD E8 24 02 94 E5 01 00 70 E3 ?? ?? ?? ?? 00 30 E0 E3 28 32 84 E5 24 32 84 E5 30 80 BD E8 57 00 A0 E3 30 40 BD E8 ?? ?? ?? ?? 04 00 9F E5 30 40 BD E8 ?? ?? ?? ?? E7 01 00 00 }
	condition:
		$1
}

rule file_109_5_2 {
	meta:
		name = "opendir"
		size = 396
		refs = "0010 SetLastError 004c mbstowcs 0054 GetFileAttributesW 0084 strncpy 008c strlen 0098 malloc 00b8 strcpy 00d0 strrchr 011c memcpy 0168 memset 0180 .rdata"
	strings:
		$1 = { F0 41 2D E9 00 40 A0 E1 C3 DF 4D E2 00 00 A0 E3 ?? ?? ?? ?? 00 00 54 E3 54 00 00 0A D0 50 D4 E1 00 00 55 E3 05 00 00 1A 4C 01 9F E5 ?? ?? ?? ?? 05 40 A0 E1 04 00 A0 E1 C3 DF 8D E2 F0 81 BD E8 04 10 A0 E1 41 2F A0 E3 0D 00 A0 E1 ?? ?? ?? ?? 0D 00 A0 E1 ?? ?? ?? ?? 01 00 70 E3 0D 50 A0 E1 01 00 00 1A 00 40 A0 E3 F1 FF FF EA 10 00 10 E3 FB FF FF 0A 82 7F 8D E2 04 10 A0 E1 41 2F A0 E3 07 00 A0 E1 ?? ?? ?? ?? 07 00 A0 E1 ?? ?? ?? ?? 23 0E 80 E2 03 00 80 E2 ?? ?? ?? ?? 00 00 50 E3 00 50 A0 E1 00 40 A0 E1 E1 FF FF 0A 8B 6F 80 E2 07 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 2C 32 D5 E5 00 00 53 E3 15 00 00 0A 2F 10 A0 E3 06 00 A0 E1 ?? ?? ?? ?? 00 80 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 00 00 85 E0 8A 7F 80 E2 03 70 87 E2 07 00 58 E1 0A 00 00 0A 06 00 A0 E1 5C 10 A0 E3 ?? ?? ?? ?? 00 00 57 E1 05 00 00 0A 06 00 A0 E1 ?? ?? ?? ?? 68 10 9F E5 00 00 86 E0 02 20 A0 E3 ?? ?? ?? ?? 06 00 A0 E1 ?? ?? ?? ?? 54 10 9F E5 00 00 86 E0 02 20 A0 E3 ?? ?? ?? ?? 00 C0 E0 E3 00 30 A0 E3 24 C2 85 E5 47 CF A0 E3 BC 30 85 E1 02 C0 8C E2 12 0E 85 E2 03 10 A0 E1 41 2F A0 E3 BC 30 85 E1 28 32 85 E5 18 31 85 E5 ?? ?? ?? ?? B0 FF FF EA 10 00 9F E5 ?? ?? ?? ?? AD FF FF EA 0B 01 00 00 ?? ?? ?? ?? ?? ?? ?? ?? E7 01 00 00 }
	condition:
		$1
}

rule file_110_0_2 {
	meta:
		name = "strtoll"
		size = 812
		refs = "0058 _isctype 0128 __divdi3"
	strings:
		$1 = { F0 4F 2D E9 00 90 51 E2 00 00 89 15 01 00 52 E3 00 30 A0 13 01 30 A0 03 A2 3F 93 E1 08 D0 4D E2 00 50 A0 E1 02 60 A0 E1 01 00 00 1A 24 00 52 E3 06 00 00 DA 00 70 A0 E3 00 80 A0 E3 08 10 A0 E1 07 00 A0 E1 08 D0 8D E2 F0 8F BD E8 01 50 85 E2 D0 00 D5 E1 08 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 F9 FF FF 1A 00 30 D5 E5 05 10 A0 E1 03 2C A0 E1 42 2C A0 E1 2D 00 52 E3 00 00 A0 13 01 00 A0 03 00 00 50 E3 04 00 8D E5 68 00 00 0A 01 30 D1 E5 01 50 85 E2 00 00 56 E3 51 00 00 0A 10 00 56 E3 83 00 00 0A 05 40 A0 E1 01 30 D4 E4 03 3C A0 E1 43 0C A0 E1 04 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 51 00 00 0A D0 70 D5 E1 30 70 47 E2 A7 3F A0 E1 06 00 57 E1 01 30 83 A3 00 00 53 E3 C7 8F A0 01 00 30 8D 05 06 A0 A0 01 CA BF A0 01 D0 FF FF 1A D0 00 D4 E1 04 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 1C 00 00 0A D0 50 D4 E1 30 50 45 E2 00 00 55 E3 05 00 56 A1 21 00 00 DA 0A 20 A0 E1 0B 30 A0 E1 00 00 E0 E3 02 11 E0 E3 ?? ?? ?? ?? 02 20 A0 E3 00 20 92 E0 00 30 A0 E3 01 30 A3 E0 03 00 58 E1 4A 00 00 8A 47 00 00 0A 97 0B 01 E0 97 2A 83 E0 9A 18 21 E0 05 70 92 E0 03 30 81 E0 C5 8F A3 E0 01 40 84 E2 D0 00 D4 E1 04 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 E2 FF FF 1A D0 00 D4 E1 01 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 3C 00 00 0A D0 50 D4 E1 37 50 45 E2 00 00 55 E3 05 00 56 A1 DD FF FF CA 04 00 9D E5 00 00 59 E3 00 40 89 15 00 00 50 E3 3A 00 00 0A 02 01 58 E3 4B 00 00 8A 4D 00 00 0A 00 30 9D E5 00 00 53 E3 44 00 00 1A 04 30 9D E5 00 00 53 E3 98 FF FF 0A 00 70 77 E2 00 80 E8 E2 95 FF FF EA 03 3C A0 E1 03 02 53 E3 0A 60 A0 13 11 00 00 0A 43 0C A0 E1 04 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 01 40 85 E2 AD FF FF 1A D0 00 D5 E1 01 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 38 00 00 0A D0 70 D5 E1 37 70 47 E2 A7 3F A0 E1 A7 FF FF EA 2B 00 52 E3 96 FF FF 1A 93 FF FF EA D1 20 D5 E1 58 00 52 E3 78 00 52 13 08 60 A0 13 E8 FF FF 1A 02 50 85 E2 05 40 A0 E1 01 30 D4 E4 10 60 A0 E3 03 3C A0 E1 91 FF FF EA 02 00 57 E1 B5 FF FF 9A 01 30 A0 E3 00 30 8D E5 01 40 84 E2 B8 FF FF EA D0 00 D4 E1 02 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 C2 FF FF 0A D0 50 D4 E1 57 50 45 E2 9A FF FF EA 06 01 78 E3 C5 FF FF 9A 00 70 E0 E3 02 81 E0 E3 61 FF FF EA 03 3C A0 E1 03 02 53 E3 CC FF FF 1A D1 30 D5 E1 01 40 85 E2 78 00 53 E3 58 00 53 13 DE FF FF 0A 00 30 D5 E5 03 3C A0 E1 73 FF FF EA 04 00 9D E5 00 00 50 E3 EE FF FF 0A 00 70 A0 E3 02 81 A0 E3 50 FF FF EA 00 00 57 E3 FA FF FF 1A AE FF FF EA D0 00 D5 E1 02 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 D0 70 D5 11 01 30 A0 03 57 70 47 12 00 70 E0 03 A7 3F A0 11 68 FF FF EA }
	condition:
		$1
}

rule file_111_0_2 {
	meta:
		name = "_lseek"
		size = 28
		refs = "0014 SetFilePointer 0018 .rdata"
	strings:
		$1 = { 02 00 52 E3 0C 30 9F 95 00 30 E0 83 02 31 93 97 00 20 A0 E3 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_112_0_2 {
	meta:
		name = "__mingw_vprintf"
		size = 56
		refs = "0014 _getstdfilex 002c __mingw_pformat"
	strings:
		$1 = { 30 40 2D E9 00 50 A0 E1 04 D0 4D E2 01 00 A0 E3 01 40 A0 E1 ?? ?? ?? ?? 05 30 A0 E1 00 10 A0 E1 00 20 A0 E3 03 0A A0 E3 00 40 8D E5 ?? ?? ?? ?? 04 D0 8D E2 30 80 BD E8 }
	condition:
		$1
}

rule file_113_0_2 {
	meta:
		name = "log1pf"
		size = 1104
		refs = "0028 __eqsf2 003c __divsf3 0074 __addsf3 0094 __subsf3 00e4 __mulsf3 012c __floatsisf 0308 __gtsf2"
	strings:
		$1 = { 0C 34 9F E5 F0 47 2D E9 03 00 50 E1 00 40 A0 E1 00 50 A0 E1 0C 00 00 CA 02 31 C0 E3 FE 05 53 E3 51 00 00 BA EC 13 9F E5 ?? ?? ?? ?? 00 00 50 E3 A6 00 00 1A 00 10 A0 E3 33 03 A0 E3 ?? ?? ?? ?? 00 40 A0 E1 04 00 A0 E1 F0 87 BD E8 C8 33 9F E5 03 00 50 E1 98 00 00 CA 5A 04 50 E3 C0 6B A0 A1 00 80 A0 A3 7F 60 46 A2 10 00 00 AA 04 00 A0 E1 FE 15 A0 E3 ?? ?? ?? ?? C0 6B A0 E1 7F 60 46 E2 00 00 56 E3 00 70 A0 E1 00 50 A0 E1 DA 00 00 DA 04 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 FE 05 A0 E3 ?? ?? ?? ?? 07 10 A0 E1 ?? ?? ?? ?? 00 80 A0 E1 68 33 9F E5 FF 44 C5 E3 02 45 C4 E3 03 00 54 E1 02 35 64 C2 3F 04 84 C3 FE 05 84 D3 FE 15 A0 E3 43 41 A0 C1 01 60 86 C2 ?? ?? ?? ?? 3F 14 A0 E3 00 50 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 00 54 E3 00 A0 A0 E1 05 40 A0 E1 00 70 A0 E1 26 00 00 1A 05 00 A0 E1 00 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 8A 00 00 1A 00 00 56 E3 00 40 A0 03 67 00 00 0A 06 00 A0 E1 ?? ?? ?? ?? EC 12 9F E5 00 50 A0 E1 ?? ?? ?? ?? E4 12 9F E5 00 40 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 56 00 00 EA 31 04 53 E3 5E 00 00 BA B0 32 9F E5 AC 22 9F E5 03 30 80 E0 02 00 53 E1 B8 FF FF 9A 3F 14 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 60 A0 E3 00 70 A0 E1 01 11 A0 E3 04 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 00 A0 A0 E1 ?? ?? ?? ?? 60 12 9F E5 00 50 A0 E1 ?? ?? ?? ?? 58 12 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 4C 12 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 40 12 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 34 12 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 28 12 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 1C 12 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 00 00 56 E3 00 50 A0 E1 50 00 00 0A 06 00 A0 E1 ?? ?? ?? ?? D4 11 9F E5 00 90 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 00 60 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 0A 10 A0 E1 ?? ?? ?? ?? B4 11 9F E5 00 50 A0 E1 09 00 A0 E1 ?? ?? ?? ?? 08 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 04 00 A0 E1 F0 87 BD E8 00 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 04 00 A0 E1 F0 87 BD E8 04 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 04 00 A0 E1 F0 87 BD E8 13 13 A0 E3 92 05 53 E3 00 50 A0 A3 01 50 A0 B3 ?? ?? ?? ?? 00 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 00 30 A0 E3 01 30 A0 C3 03 00 15 E1 E9 FF FF 1A 04 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? BF 14 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 DF FF FF EA FC 10 9F E5 05 00 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 0A 10 A0 E1 ?? ?? ?? ?? 00 00 56 E3 00 40 A0 E1 11 00 00 1A 04 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 D0 FF FF EA 00 10 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 0A 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 C3 FF FF EA 06 00 A0 E1 ?? ?? ?? ?? 5C 10 9F E5 00 70 A0 E1 ?? ?? ?? ?? 54 10 9F E5 00 60 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 A8 FF FF EA FE 15 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 23 FF FF EA D6 13 D4 3E 00 00 80 BF FF FF 7F 7F F6 04 35 00 80 71 31 3F D1 F7 17 37 E0 09 6A 41 97 88 17 3E 4F D0 1C 3E 25 33 3A 3E 29 8E 63 3E 25 49 92 3E CD CC CC 3E AB AA 2A 3F AB AA 2A BF }
	condition:
		$1
}

rule file_114_0_2 {
	meta:
		name = "__decrement_D2A"
		size = 60
	strings:
		$1 = { 10 20 90 E5 14 30 80 E2 02 01 80 E0 14 00 80 E2 00 10 E0 E3 00 20 93 E5 00 00 52 E3 03 00 00 1A 04 10 83 E4 03 00 50 E1 F9 FF FF 8A 0E F0 A0 E1 01 20 42 E2 00 20 83 E5 0E F0 A0 E1 }
	condition:
		$1
}

rule file_114_1_2 {
	meta:
		name = "__set_ones_D2A"
		size = 156
		refs = "0088 __Bfree_D2A 0090 __Balloc_D2A"
	strings:
		$1 = { 30 40 2D E9 04 20 90 E5 1F 50 81 E2 C5 52 A0 E1 02 00 55 E1 01 40 A0 E1 00 30 A0 E1 19 00 00 CA 1F 50 14 E2 C4 42 A0 E1 01 40 84 12 04 11 83 E0 14 10 81 E2 14 C0 83 E2 01 00 5C E1 10 40 83 E5 09 00 00 2A 0C 20 A0 E1 00 00 E0 E3 04 00 82 E4 02 00 51 E1 FC FF FF 8A 0C C0 E0 E1 01 C0 8C E0 03 C0 CC E3 0C C0 83 E0 18 C0 8C E2 00 00 55 E3 04 20 1C 15 20 50 65 12 32 55 A0 11 03 00 A0 E1 04 50 0C 15 30 80 BD E8 ?? ?? ?? ?? 05 00 A0 E1 ?? ?? ?? ?? 00 30 A0 E1 E0 FF FF EA }
	condition:
		$1
}

rule file_114_2_2 {
	meta:
		name = "__increment_D2A"
		size = 172
		refs = "0078 __Balloc_D2A 0094 memcpy 009c __Bfree_D2A"
	strings:
		$1 = { 10 C0 90 E5 30 40 2D E9 14 30 80 E2 00 40 A0 E1 0C 01 80 E0 14 00 80 E2 00 10 A0 E3 00 20 93 E5 01 00 72 E3 0D 00 00 1A 04 10 83 E4 03 00 50 E1 F9 FF FF 8A 08 20 94 E5 0C 30 A0 E1 02 00 5C E1 0A 00 00 AA 01 20 83 E2 01 10 A0 E3 03 31 84 E0 14 10 83 E5 10 20 84 E5 04 00 A0 E1 30 80 BD E8 01 20 82 E2 00 20 83 E5 04 00 A0 E1 30 80 BD E8 04 00 94 E5 01 00 80 E2 ?? ?? ?? ?? 10 20 94 E5 00 50 A0 E1 02 20 82 E2 0C 10 84 E2 02 21 A0 E1 0C 00 80 E2 ?? ?? ?? ?? 04 00 A0 E1 ?? ?? ?? ?? 05 40 A0 E1 10 30 95 E5 E5 FF FF EA }
	condition:
		$1
}

rule file_114_4_2 {
	meta:
		name = "rvOK"
		size = 780
		refs = "0028 __d2b_D2A 00c0 __any_on_D2A 00d0 __rshift_D2A 0130 __copybits_D2A 0148 __Bfree_D2A 01a0 __lshift_D2A 0228 __increment_D2A 0244 __clzsi2"
	strings:
		$1 = { F0 4F 2D E9 10 D0 4D E2 01 40 A0 E1 02 60 A0 E1 03 00 90 E8 03 70 A0 E1 08 20 8D E2 0C 30 8D E2 38 A0 9D E5 3C 50 9D E5 ?? ?? ?? ?? 00 90 94 E5 0C 10 9D E5 08 30 9D E5 01 10 69 E0 03 30 81 E0 00 00 51 E3 00 80 A0 E1 0C 10 8D E5 08 30 8D E5 4A 00 00 DA 35 00 59 E3 0F 00 00 0A 01 00 5A E3 13 00 00 0A 02 00 5A E3 01 C0 A0 03 04 C0 8D 05 11 00 00 0A 01 30 51 E2 61 00 00 1A 34 20 9D E5 00 00 52 E3 5C 00 00 0A 14 30 90 E5 A3 30 A0 E1 01 30 03 E2 04 30 8D E5 07 00 00 EA 34 30 9D E5 00 00 53 E3 54 00 00 0A 0C 30 94 E5 01 00 53 E3 51 00 00 1A 00 20 A0 E3 04 20 8D E5 08 00 A0 E1 ?? ?? ?? ?? 0C 10 9D E5 00 B0 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 04 30 9D E5 00 00 5B E3 10 A0 A0 13 00 A0 A0 03 00 00 53 E3 08 30 9D 05 4C 00 00 1A 04 20 94 E5 02 00 53 E1 16 00 00 AA 02 30 63 E0 03 00 59 E1 08 20 8D E5 2A 00 00 AA 50 30 A0 E3 00 A0 A0 E3 10 A0 88 E5 00 30 85 E5 08 30 9D E5 00 30 86 E5 07 00 A0 E1 09 10 A0 E1 08 20 A0 E1 ?? ?? ?? ?? 00 30 95 E5 01 40 A0 E3 0A A0 83 E1 00 A0 85 E5 08 00 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 10 D0 8D E2 F0 8F BD E8 08 20 94 E5 02 00 53 E1 EE FF FF DA 01 30 82 E2 00 A0 A0 E3 A3 20 A0 E3 00 20 85 E5 08 30 8D E5 10 A0 88 E5 E7 FF FF EA 34 20 9D E5 00 00 52 E3 1B 00 00 0A 00 00 51 E3 01 B0 A0 01 0B A0 A0 01 D4 FF FF 0A 00 10 61 E2 ?? ?? ?? ?? 00 B0 A0 E3 00 80 A0 E1 08 30 9D E5 0B A0 A0 E1 CD FF FF EA 10 20 94 E5 00 00 52 E3 D1 FF FF 1A 01 20 7B E2 00 20 A0 33 01 40 43 E2 00 00 54 E3 00 10 A0 D3 01 10 02 C2 00 00 51 E3 3A 00 00 1A 34 C0 9D E5 00 00 5C E3 00 20 A0 13 01 20 02 02 00 00 52 E3 1F 00 00 0A 00 40 A0 E3 CF FF FF EA C3 22 A0 E1 02 21 80 E0 14 20 92 E5 1F 30 03 E2 32 33 A0 E1 01 30 03 E2 04 30 8D E5 A5 FF FF EA 08 00 A0 E1 46 FF FF EB 10 30 90 E5 1F A0 19 E2 03 31 80 E0 00 80 A0 E1 10 00 93 E5 20 A0 6A 12 ?? ?? ?? ?? 00 00 5A E1 1C 00 00 0A 00 00 5B E3 14 B0 98 05 08 00 A0 E1 01 10 A0 E3 01 B0 0B 02 ?? ?? ?? ?? 08 30 9D E5 20 A0 A0 E3 01 30 83 E2 08 30 8D E5 9C FF FF EA C4 22 A0 E1 02 21 88 E0 14 20 92 E5 01 10 A0 E3 1F 40 04 E2 11 44 02 E0 08 00 A0 E1 03 10 A0 E1 ?? ?? ?? ?? 02 30 A0 E3 00 00 54 E3 00 30 85 E5 10 00 00 1A 00 00 5B E3 08 30 9D 15 50 A0 A0 13 08 30 9D 05 96 FF FF EA 08 30 9D E5 20 A0 A0 E3 87 FF FF EA 08 00 A0 E1 04 10 A0 E1 00 30 8D E5 ?? ?? ?? ?? 00 30 9D E5 00 B0 A0 E1 01 20 70 E2 00 20 A0 33 BB FF FF EA 08 00 A0 E1 12 FF FF EB 60 A0 A0 E3 00 80 A0 E1 08 30 9D E5 84 FF FF EA }
	condition:
		$1
}

rule file_114_5_2 {
	meta:
		name = "__strtodg"
		size = 6960
		refs = "0050 .text 0154 __copybits_D2A 015c __Bfree_D2A 0514 __floatunsidf 0538 __muldf3 055c __adddf3 05a8 __ctzsi2 0740 __d2b_D2A 0768 __rshift_D2A 0aa4 __s2b_D2A 0b70 __lshift_D2A 0b8c __diff_D2A 0c4c __subdf3 0c60 __ltdf2 0c7c __gtdf2 0cbc __Balloc_D2A 0cdc memcpy 0d20 __i2b_D2A 0dd0 __pow5mult_D2A 0ddc __mult_D2A 0e8c __cmp_D2A 0ec4 __ratio_D2A 0ed8 __ledf2 0f30 __match_D2A 10fc __sum_D2A 1178 __trailz_D2A 1248 __set_ones_D2A 13a0 __fixdfsi 13a8 __floatsidf 13e4 __gedf2 146c .rdata 1470 __bigtens_D2A 1498 __tinytens_D2A 149c __tens_D2A 14f8 __gethex_D2A 1574 __divdf3 1a7c __hexnan_D2A 1a98 __increment_D2A"
	strings:
		$1 = { F0 4F 2D E9 02 90 A0 E1 8C D0 4D E2 00 20 A0 E3 00 80 99 E5 00 70 A0 E1 70 20 8D E5 20 10 8D E5 3C 30 8D E5 80 20 8D E5 68 20 8D E5 6C 20 8D E5 74 00 8D E5 00 C0 A0 E1 00 20 DC E5 02 2C A0 E1 42 3C A0 E1 2D 00 53 E3 03 F1 9F 97 B1 00 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 20 A0 E3 06 30 A0 E3 24 20 8D E5 70 20 9D E5 80 30 8D E5 74 70 8D E5 20 10 9D E5 00 00 51 E3 74 30 9D 15 00 30 81 15 24 30 9D E5 00 00 53 E3 80 30 9D 15 08 30 83 13 80 30 8D 15 00 00 52 E3 04 00 00 0A B0 00 9D E5 08 10 A0 E1 ?? ?? ?? ?? 70 00 9D E5 ?? ?? ?? ?? 80 00 9D E5 8C D0 8D E2 F0 8F BD E8 01 10 A0 E3 24 10 8D E5 01 C0 8C E2 74 C0 8D E5 00 30 DC E5 00 00 53 E3 03 2C A0 11 DE FF FF 0A 03 02 52 E3 00 B0 A0 13 64 00 00 0A 42 2C A0 E1 10 00 99 E5 2F 00 52 E3 4C 00 8D E5 41 05 00 DA 39 00 52 E3 6D 00 00 CA 00 60 A0 E3 06 50 A0 E1 06 40 A0 E1 01 00 00 EA 39 00 52 E3 6A 00 00 CA 08 00 54 E3 05 51 85 D0 85 50 82 D0 30 50 45 D2 03 00 00 DA 0F 00 54 E3 06 61 86 D0 86 60 82 D0 30 60 46 D2 01 40 84 E2 04 10 8C E0 74 10 8D E5 D4 20 9C E1 2F 00 52 E3 EE FF FF CA 04 30 A0 E1 2E 00 52 E3 35 01 00 1A 01 20 81 E2 74 20 8D E5 00 00 53 E3 D1 20 D1 E1 9E 01 00 0A 00 10 A0 E3 2C C0 8D E5 03 40 A0 E1 10 10 8D E5 30 C0 42 E2 09 00 5C E3 01 C0 A0 83 38 C0 8D 85 50 00 00 8A 74 00 9D E5 01 10 81 E2 04 A0 A0 E1 28 00 8D E5 00 00 5C E3 0A 40 A0 01 20 00 00 0A 10 00 9D E5 01 00 51 E3 01 00 80 E0 10 00 8D E5 11 00 00 0A 0A 20 81 E0 01 40 42 E2 03 00 A0 E1 0A 20 A0 E1 01 20 82 E2 01 30 42 E2 08 00 53 E3 05 51 85 D0 85 50 A0 D1 02 00 00 DA 10 00 52 E3 06 61 86 D0 86 60 A0 D1 04 00 52 E1 F4 FF FF 1A 0A A0 81 E0 00 30 A0 E1 01 A0 4A E2 08 00 5A E3 05 51 85 D0 01 40 8A E2 85 50 8C D0 00 10 A0 D3 03 00 00 DA 10 00 54 E3 0A 20 A0 D3 92 C6 26 D0 00 10 A0 E3 28 A0 9D E5 01 20 8A E2 74 20 8D E5 D1 20 DA E1 CD FF FF EA 00 00 A0 E3 24 00 8D E5 99 FF FF EA 01 C0 8C E2 74 C0 8D E5 47 FF FF EA 00 30 A0 E3 03 02 52 E3 24 30 8D E5 00 B0 A0 13 9A FF FF 1A D1 30 DC E1 58 00 53 E3 69 04 00 0A 78 00 53 E3 67 04 00 0A 01 C0 8C E2 74 C0 8D E5 00 30 DC E5 03 2C A0 E1 03 02 52 E3 F9 FF FF 0A 00 00 53 E3 01 B0 A0 13 8C FF FF 1A 70 20 9D E5 6C FF FF EA 00 60 A0 E3 06 50 A0 E1 06 40 A0 E1 00 A0 A0 E3 38 A0 8D E5 2C C0 8D E5 04 30 A0 E1 0A 10 A0 E1 10 A0 8D E5 65 00 52 E3 45 00 52 13 45 00 00 1A 01 20 84 E1 0B 20 92 E1 CB 00 00 0A 74 70 9D E5 01 C0 87 E2 74 C0 8D E5 D1 20 D7 E1 2B 00 52 E3 5E 04 00 0A 2D 00 52 E3 00 A0 A0 13 28 A0 8D 15 A4 01 00 0A 30 C0 42 E2 09 00 5C E3 74 70 8D 85 00 A0 A0 83 34 00 00 8A 30 00 52 E3 07 00 00 1A 74 C0 9D E5 38 00 9D E5 01 C0 8C E2 74 C0 8D E5 D0 20 DC E1 30 00 52 E3 FA FF FF 0A 38 00 8D E5 31 C0 42 E2 08 00 5C E3 26 00 00 8A 74 A0 9D E5 30 20 42 E2 01 C0 8A E2 18 A0 8D E5 34 20 8D E5 74 C0 8D E5 D1 20 DA E1 2F 00 52 E3 12 00 00 DA 39 00 52 E3 10 00 00 CA 30 30 8D E5 34 A0 9D E5 38 00 9D E5 01 00 00 EA 39 00 52 E3 07 00 00 CA 01 C0 8C E2 74 C0 8D E5 30 30 42 E2 D0 20 DC E1 0A A1 8A E0 2F 00 52 E3 8A A0 83 E0 F5 FF FF CA 30 30 9D E5 34 A0 8D E5 38 00 8D E5 18 00 9D E5 34 A0 9D E5 0C C0 60 E0 CC 0F 9F E5 00 00 5A E1 08 00 5C D3 28 C0 9D E5 00 A0 A0 C1 00 00 5C E3 00 A0 6A 12 00 00 00 EA 00 A0 A0 E3 00 00 54 E3 56 00 00 0A 0C 20 99 E5 01 10 A0 E3 80 10 8D E5 10 10 9D E5 03 20 02 E2 0A A0 61 E0 02 00 52 E3 28 A0 8D E5 0D 04 00 0A 03 00 52 E3 0F 04 00 0A 01 20 72 E2 00 20 A0 33 40 20 8D E5 10 00 54 E3 04 70 A0 B1 10 70 A0 A3 00 00 53 E3 04 30 A0 01 05 00 A0 E1 10 30 8D E5 ?? ?? ?? ?? 09 00 57 E3 68 00 8D E5 6C 10 8D E5 0F 00 00 DA 6C 3F 9F E5 87 31 83 E0 48 30 43 E2 0C 00 93 E8 ?? ?? ?? ?? 00 A0 A0 E1 06 00 A0 E1 01 B0 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 68 00 8D E5 6C 10 8D E5 0F 00 54 E3 35 00 58 D3 63 00 00 CA 28 C0 9D E5 00 00 5C E3 32 01 00 0A 73 04 00 DA 28 C0 9D E5 16 00 5C E3 58 04 00 CA 68 00 9D E5 D0 3E 9F E5 00 00 50 E3 0C 31 83 E0 10 60 93 E5 80 04 00 0A ?? ?? ?? ?? 35 A0 60 E2 28 20 9D E5 E0 3E 9F E5 68 00 9D E5 82 31 83 E0 0C 00 93 E8 6C 10 9D E5 ?? ?? ?? ?? 06 C0 8A E0 3C 20 9D E5 B0 30 9D E5 68 00 8D E5 6C 10 8D E5 35 00 5C E3 00 C0 A0 C3 01 C0 A0 D3 68 00 8D E2 09 10 A0 E1 40 A0 9D E5 00 C0 8D E5 80 C0 8D E2 00 14 8D E9 BA FD FF EB 00 00 50 E3 00 30 A0 03 3C 00 00 0A 70 20 9D E5 C0 FE FF EA 0B 10 91 E1 4F FF FF 1A 38 00 9D E5 00 00 50 E3 29 00 00 1A 49 20 42 E2 25 00 52 E3 02 F1 9F 97 25 00 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 06 30 A0 E3 80 30 8D E5 74 70 8D E5 70 20 9D E5 8C FE FF EA 00 10 A0 E3 38 10 8D E5 2C C0 8D E5 03 40 A0 E1 10 10 8D E5 22 FF FF EA 28 30 9D E5 04 60 67 E0 03 60 86 E0 00 00 56 E3 8B 03 00 DA 0F 30 16 E2 68 00 9D 05 74 00 00 1A 0F 60 D6 E3 7B 00 00 1A 00 A0 A0 E3 6C 70 9D E5 78 20 8D E2 7C 30 8D E2 07 10 A0 E1 ?? ?? ?? ?? 7C 20 9D E5 78 30 9D E5 02 60 68 E0 03 30 8A E0 00 00 56 E3 70 00 8D E5 78 30 8D E5 06 00 00 DA 06 10 A0 E1 ?? ?? ?? ?? 78 30 9D E5 7C 80 8D E5 03 30 86 E0 78 30 8D E5 08 20 A0 E1 08 10 99 E5 03 60 82 E0 06 60 68 E0 01 10 81 E2 01 00 56 E1 00 20 A0 C3 18 20 8D C5 20 00 00 CA 04 A0 99 E5 0A 00 56 E1 00 C0 A0 A3 30 A0 8D E5 5C 60 8D A5 18 C0 8D A5 B3 00 00 AA 30 00 9D E5 03 70 60 E0 00 00 57 E3 B1 03 00 CA 66 04 00 1A 4C C0 9D E5 30 00 9D E5 00 00 5C E3 78 00 8D E5 A5 00 00 0A 01 60 86 E2 06 00 50 E1 A2 00 00 DA 70 20 9D E5 00 30 A0 E3 30 10 9D E5 3C A0 9D E5 14 30 82 E5 10 30 82 E5 50 30 A0 E3 00 10 8A E5 80 30 8D E5 0E 00 00 EA 24 A0 9D E5 00 00 5A E3 0C 02 00 0A 70 20 9D E5 00 30 A0 E3 10 30 82 E5 A3 10 A0 E3 08 30 99 E5 80 10 8D E5 3C A0 9D E5 01 30 83 E2 00 30 8A E5 18 C0 9D E5 00 00 5C E3 32 FE FF 0A 4C 00 9D E5 00 00 50 E3 04 00 00 0A 00 30 A0 E3 10 30 82 E5 50 30 A0 E3 80 30 8D E5 2A FE FF EA 10 30 92 E5 80 10 9D E5 00 00 53 E3 02 30 A0 C3 00 30 A0 D3 07 10 C1 E3 01 30 83 E1 30 00 13 E3 80 30 8D E5 40 30 83 13 80 30 8D 15 1E FE FF EA 30 00 52 E3 03 10 A0 11 06 00 00 1A 02 00 81 E2 03 10 A0 E1 74 00 8D E5 D1 20 D0 E0 01 10 81 E2 30 00 52 E3 FA FF FF 0A 31 00 42 E2 08 00 50 E3 56 00 00 8A 74 A0 9D E5 10 10 8D E5 2C A0 8D E5 28 A0 8D E5 30 C0 42 E2 00 A0 A0 E3 01 10 A0 E3 58 FE FF EA 9C 2B 9F E5 68 00 9D E5 83 31 82 E0 6C 10 9D E5 0C 00 93 E8 ?? ?? ?? ?? 6C 10 8D E5 68 00 8D E5 81 FF FF EA 46 62 A0 E1 0F 00 56 E3 00 A0 A0 D3 21 00 00 DA 3C 3B 9F E5 06 70 A0 E1 20 30 83 E2 0C 00 93 E8 18 60 8D E5 04 B0 A0 E1 05 60 A0 E1 00 A0 A0 E3 02 40 A0 E1 03 50 A0 E1 6C 30 9D E5 34 CB 9F E5 7F 14 C3 E3 0C C0 03 E0 0F 16 C1 E3 FF 35 81 E3 2C CA A0 E1 03 36 83 E3 FF CF 4C E2 03 C0 4C E2 03 10 A0 E1 04 20 A0 E1 05 30 A0 E1 0A A0 8C E0 ?? ?? ?? ?? 10 70 47 E2 0F 00 57 E3 6C 10 8D E5 68 00 8D E5 EB FF FF CA 06 50 A0 E1 18 60 9D E5 0B 40 A0 E1 0F 60 06 E2 6C 10 9D E5 D4 3A 9F E5 7F 24 C1 E3 03 30 01 E0 23 3A A0 E1 0F 26 C2 E3 FF 3F 43 E2 FF 25 82 E3 03 30 43 E2 03 26 82 E3 00 00 56 E3 0A A0 83 E0 6C 20 8D E5 50 FF FF DA 7C 7A 9F E5 00 30 A0 E1 01 00 16 E3 C6 60 A0 E1 05 00 00 0A 03 00 A0 E1 02 10 A0 E1 0C 00 97 E8 ?? ?? ?? ?? 00 30 A0 E1 01 20 A0 E1 00 00 56 E3 08 70 87 E2 F3 FF FF CA 6C 20 8D E5 68 30 8D E5 03 00 A0 E1 3E FF FF EA 00 40 A0 E3 01 A0 A0 E3 2C C0 8D E5 38 A0 8D E5 10 40 8D E5 50 FE FF EA 68 00 8D E2 09 10 A0 E1 3C 20 9D E5 B0 30 9D E5 01 C0 A0 E3 E3 FE FF EA 01 00 A0 E3 28 00 8D E5 01 20 8C E2 74 20 8D E5 D1 20 DC E1 54 FE FF EA 30 10 9D E5 01 20 A0 E3 5C 10 8D E5 18 20 8D E5 01 C0 A0 E3 05 30 A0 E1 2C 00 9D E5 10 10 9D E5 04 20 A0 E1 00 C0 8D E5 ?? ?? ?? ?? 0C C0 80 E2 34 00 8D E5 28 00 9D E5 01 30 88 E2 00 00 60 E2 2C 80 8D E5 00 A0 A0 E3 50 30 8D E5 54 C0 8D E5 60 00 8D E5 18 80 9D E5 64 90 8D E5 75 00 00 EA 01 30 02 E2 0A 30 33 E0 44 30 8D E5 34 03 00 0A 00 00 5A E3 A3 01 00 0A 21 30 A0 E3 80 30 8D E5 20 30 A0 E3 58 30 8D E5 00 90 A0 E3 64 19 9F E5 00 00 A0 E3 10 00 8D E5 14 10 8D E5 18 00 8D E5 1C 10 8D E5 00 10 A0 E3 38 10 8D E5 78 00 9D E5 00 00 58 E3 48 00 8D E5 7C A0 9D E5 02 00 00 1A 2C 10 9D E5 0A 00 51 E1 F5 01 00 CA 10 10 8D E2 03 00 91 E8 88 20 8D E2 84 30 8D E2 ?? ?? ?? ?? 88 10 9D E5 00 B0 A0 E1 00 00 51 E3 07 02 00 BA 01 00 00 0A ?? ?? ?? ?? 00 B0 A0 E1 00 00 59 E3 70 90 9D E5 5B 01 00 0A 09 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 00 00 58 E3 70 00 8D E5 10 20 99 E5 0B 00 00 1A 10 10 90 E5 01 30 42 E2 01 00 53 E1 3B 02 00 BA 5C 30 9D E5 30 C0 9D E5 0C 00 53 E1 5E 01 00 1A 7C 30 9D E5 01 80 A0 E3 01 30 43 E2 7C 30 8D E5 0B 00 A0 E1 ?? ?? ?? ?? 09 00 A0 E1 ?? ?? ?? ?? 44 C0 9D E5 00 00 5C E3 FB 00 00 1A 7C 20 9D E5 78 30 9D E5 48 00 9D E5 03 30 82 E0 38 20 9D E5 00 A0 8A E0 00 10 52 E2 01 10 A0 13 03 00 5A E1 00 10 A0 13 00 00 51 E3 01 A0 A0 E1 19 00 00 0A 10 10 8D E2 03 00 91 E8 48 28 9F E5 48 38 9F E5 ?? ?? ?? ?? 00 20 A0 E3 01 90 A0 E1 00 A0 A0 E1 38 38 9F E5 18 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 0A 20 A0 E1 02 31 89 E2 10 00 8D E5 14 10 8D E5 ?? ?? ?? ?? 00 00 50 E3 93 01 00 AA 0A 20 A0 E1 09 30 A0 E1 18 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 00 50 E3 53 03 00 CA 00 00 58 E3 00 A0 A0 13 37 01 00 0A 05 00 A0 E1 ?? ?? ?? ?? 06 00 A0 E1 ?? ?? ?? ?? 07 00 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 ?? ?? ?? ?? 34 10 9D E5 04 00 91 E5 ?? ?? ?? ?? 34 30 9D E5 54 10 9D E5 10 20 93 E5 00 60 A0 E1 02 20 82 E2 02 21 A0 E1 0C 00 80 E2 ?? ?? ?? ?? 70 30 9D E5 04 00 93 E5 ?? ?? ?? ?? 70 10 9D E5 00 50 A0 E1 10 20 91 E5 0C 00 80 E2 02 20 82 E2 0C 10 81 E2 02 21 A0 E1 ?? ?? ?? ?? 7C 30 9D E5 01 00 A0 E3 03 30 6A E0 10 30 8D E5 78 90 9D E5 ?? ?? ?? ?? 28 C0 9D E5 09 90 8A E0 00 00 5C E3 60 10 9D B5 00 10 A0 A3 0C B0 A0 A1 00 B0 A0 B3 00 70 A0 E1 10 00 9D E5 01 30 A0 A1 01 30 A0 B1 0B 40 A0 A1 0B 40 A0 B1 2C C0 9D E5 00 00 59 E3 09 30 81 A0 04 40 69 B0 09 90 80 E0 30 00 9D E5 09 20 6C E0 02 00 50 E1 50 C0 9D E5 10 00 9D E5 0C 90 60 E0 30 C0 9D C5 09 90 6C C0 02 90 89 C0 04 40 89 E0 03 90 89 E0 04 00 59 E1 09 20 A0 B1 04 20 A0 A1 03 00 52 E1 03 20 A0 A1 00 00 52 E3 03 30 62 C0 18 30 8D D5 18 30 8D C5 09 90 62 C0 04 40 62 C0 00 00 51 E3 0A 00 00 0A 07 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 00 70 A0 E1 ?? ?? ?? ?? 00 30 A0 E1 05 00 A0 E1 0C 30 8D E5 ?? ?? ?? ?? 0C 30 9D E5 03 50 A0 E1 09 10 6A E0 00 00 51 E3 B6 00 00 DA 05 00 A0 E1 ?? ?? ?? ?? 00 50 A0 E1 00 00 5B E3 03 00 00 0A 06 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 00 60 A0 E1 00 00 54 E3 03 00 00 DA 06 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 00 60 A0 E1 18 00 9D E5 00 00 50 E3 03 00 00 DA 07 00 A0 E1 18 10 9D E5 ?? ?? ?? ?? 00 70 A0 E1 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 10 30 90 E5 00 40 A0 E1 01 00 53 E3 55 00 00 DA 00 10 A0 E3 0C A0 94 E5 04 00 A0 E1 0C 10 84 E5 07 10 A0 E1 ?? ?? ?? ?? 40 20 9D E5 00 00 50 E3 00 30 A0 C3 01 30 A0 D3 00 00 52 E3 00 30 A0 03 00 00 53 E3 0A FF FF 1A 00 00 50 E3 84 02 00 BA 48 02 00 0A 04 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E3 01 31 A0 E3 18 00 8D E5 1C 10 8D E5 ?? ?? ?? ?? 00 00 50 E3 DB 00 00 CA 00 00 5A E3 58 01 00 1A 00 20 A0 E3 44 20 8D E5 10 A0 9D E5 01 00 5A E3 00 30 A0 C3 01 30 A0 D3 00 00 58 E3 00 30 A0 03 00 00 53 E3 A1 02 00 1A 10 C0 A0 E3 58 C0 8D E5 01 90 A0 E3 F8 FE FF EA 74 40 8D E2 04 00 A0 E1 50 15 9F E5 ?? ?? ?? ?? 00 00 50 E3 E6 FD FF 0A 08 30 99 E5 3C A0 9D E5 01 20 83 E2 00 20 8A E5 04 10 A0 E3 74 20 9D E5 80 10 8D E5 D0 20 D2 E1 28 00 52 E3 C2 02 00 0A 00 C0 A0 E3 18 C0 8D E5 70 20 9D E5 31 FE FF EA 74 40 8D E2 04 00 A0 E1 E8 14 9F E5 ?? ?? ?? ?? 00 00 50 E3 D2 FD FF 0A 74 30 9D E5 F0 14 9F E5 01 30 43 E2 04 00 A0 E1 74 30 8D E5 ?? ?? ?? ?? 00 00 50 E3 74 30 9D 05 00 10 A0 E3 01 30 83 02 74 30 8D 05 03 30 A0 E3 80 30 8D E5 08 30 99 E5 18 10 8D E5 70 20 9D E5 1A FE FF EA 14 30 90 E5 00 00 53 E3 A6 FF FF 1A 18 80 8D E5 64 90 9D E5 2C 80 9D E5 18 00 9D E5 00 00 50 E3 34 00 00 0A 78 30 9D E5 3C 20 9D E5 05 00 A0 E1 }
	condition:
		$1
}

rule file_115_0_2 {
	meta:
		name = "lround"
		size = 256
		refs = "005c __adddf3"
	strings:
		$1 = { 10 40 2D E9 21 4A A0 E1 01 30 A0 E1 84 1A A0 E1 A1 1A A0 E1 FF 1F 41 E2 03 10 41 E2 01 00 71 E3 00 20 A0 E1 00 00 A0 B3 10 80 BD B8 1E 00 51 E3 C4 45 A0 E1 03 00 00 DA 00 00 54 E3 02 01 A0 13 02 01 E0 03 10 80 BD E8 00 00 54 E3 00 00 A0 03 A0 10 9F 05 00 00 A0 13 9C 10 9F 15 ?? ?? ?? ?? 21 3A A0 E1 83 3A A0 E1 A3 3A A0 E1 43 3E 43 E2 03 30 43 E2 FF 24 C1 E3 0F 26 C2 E3 00 00 53 E3 01 26 82 E3 0B 00 00 BA 1F 00 53 E3 10 13 A0 D1 0C 00 00 CA 20 30 93 E2 0D 00 00 4A 1F 00 53 E3 12 03 A0 D1 0E 00 00 CA 01 00 80 E1 00 00 54 E3 00 00 60 12 10 80 BD E8 1F 00 73 E3 00 10 63 A2 30 11 A0 A1 F2 FF FF AA 20 30 93 E2 00 10 A0 E3 F1 FF FF 5A 1F 00 73 E3 00 30 63 A2 32 03 A0 A1 F0 FF FF AA 00 00 A0 E3 01 00 80 E1 00 00 54 E3 00 00 60 12 10 80 BD E8 00 00 E0 3F 00 00 E0 BF }
	condition:
		$1
}

rule file_116_0_2 {
	meta:
		name = "cosf"
		size = 184
		refs = "0028 __subsf3 0038 __ieee754_rem_pio2f 0060 __kernel_cosf 0090 __kernel_sinf"
	strings:
		$1 = { 04 E0 2D E5 A4 20 9F E5 02 31 C0 E3 02 00 53 E1 08 D0 4D E2 00 10 A0 E1 12 00 00 DA 90 20 9F E5 02 00 53 E1 02 00 00 DA ?? ?? ?? ?? 08 D0 8D E2 00 80 BD E8 0D 10 A0 E1 ?? ?? ?? ?? 03 20 00 E2 01 00 52 E3 0F 00 00 0A 02 00 52 E3 08 00 00 0A 00 00 52 E3 10 00 00 1A 00 00 9D E5 04 10 9D E5 ?? ?? ?? ?? F0 FF FF EA 00 10 A0 E3 ?? ?? ?? ?? ED FF FF EA 00 00 9D E5 04 10 9D E5 ?? ?? ?? ?? 02 01 80 E2 E8 FF FF EA 00 00 9D E5 04 10 9D E5 ?? ?? ?? ?? 02 01 80 E2 E3 FF FF EA 00 00 9D E5 04 10 9D E5 01 20 A0 E3 ?? ?? ?? ?? DE FF FF EA D8 0F 49 3F FF FF 7F 7F }
	condition:
		$1
}

rule file_117_0_2 {
	meta:
		name = "lldiv"
		size = 100
		refs = "0030 __moddi3 004c __divdi3"
	strings:
		$1 = { 04 D0 4D E2 F0 41 2D E9 18 30 8D E5 00 40 A0 E1 18 80 8D E2 80 01 98 E8 01 50 A0 E1 02 60 A0 E1 08 30 A0 E1 01 00 A0 E1 02 10 A0 E1 07 20 A0 E1 ?? ?? ?? ?? 07 20 A0 E1 08 00 84 E5 0C 10 84 E5 08 30 A0 E1 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 03 00 84 E8 04 00 A0 E1 F0 41 BD E8 04 D0 8D E2 0E F0 A0 E1 }
	condition:
		$1
}

rule file_119_0_2 {
	meta:
		name = "chmod"
		size = 80
		refs = "0018 mbstowcs 0020 GetFileAttributesW 0040 SetFileAttributesW"
	strings:
		$1 = { 30 40 2D E9 83 DF 4D E2 41 2F A0 E3 01 50 A0 E1 00 10 A0 E1 0D 00 A0 E1 ?? ?? ?? ?? 0D 00 A0 E1 ?? ?? ?? ?? 01 00 70 E3 0D 40 A0 E1 05 00 00 0A 80 00 15 E3 01 10 C0 13 01 10 80 03 0D 00 A0 E1 ?? ?? ?? ?? 00 00 A0 E3 83 DF 8D E2 30 80 BD E8 }
	condition:
		$1
}

rule file_120_0_2 {
	meta:
		name = "__mingw_fprintf"
		size = 60
		refs = "0028 __mingw_pformat"
	strings:
		$1 = { 0E 00 2D E9 04 E0 2D E5 08 D0 4D E2 10 C0 8D E2 00 10 A0 E1 00 20 A0 E3 0C 30 9D E5 03 0A A0 E3 00 C0 8D E5 04 C0 8D E5 ?? ?? ?? ?? 08 D0 8D E2 04 E0 9D E4 0C D0 8D E2 0E F0 A0 E1 }
	condition:
		$1
}

rule file_121_0_2 {
	meta:
		name = "tsearch"
		size = 124
		refs = "0058 malloc"
	strings:
		$1 = { 00 00 51 E3 F0 40 2D E9 00 40 A0 E1 02 60 A0 E1 01 50 A0 E1 01 00 A0 01 09 00 00 1A F0 80 BD E8 00 10 97 E5 0F E0 A0 E1 06 F0 A0 E1 00 00 50 E3 0F 00 00 0A 00 50 95 B5 00 50 95 A5 04 50 85 B2 08 50 85 A2 00 70 95 E5 04 00 A0 E1 00 00 57 E3 F2 FF FF 1A 0C 00 A0 E3 ?? ?? ?? ?? 00 00 50 E3 00 00 85 15 00 40 80 15 04 70 80 15 08 70 80 15 F0 80 BD E8 00 00 95 E5 F0 80 BD E8 }
	condition:
		$1
}

rule file_122_0_2 {
	meta:
		name = "__ieee754_lgamma_r"
		size = 4156
		refs = "00a4 __subdf3 00c8 __muldf3 010c __adddf3 0274 __divdf3 02b0 log 0328 floor 0344 __nedf2 03ac __fixdfsi 03c0 .text 0404 __kernel_cos 0424 __eqdf2 0478 __ltdf2 04c4 __kernel_sin 053c __floatsidf"
	strings:
		$1 = { F0 4F 2D E9 F4 3D 9F E5 02 41 C1 E3 03 00 54 E1 01 30 A0 E3 00 30 82 E5 18 D0 4D E2 00 60 A0 E1 01 50 A0 E1 00 A0 A0 E1 01 B0 A0 E1 01 70 A0 E1 02 80 A0 E1 00 30 A0 E1 94 00 00 CA 03 30 94 E1 87 00 00 0A B8 3D 9F E5 03 00 54 E1 95 00 00 DA 00 00 51 E3 7F 00 00 BA 03 31 84 E2 01 36 83 E2 0A 30 93 E1 95 00 00 0A 03 31 84 E2 0A 30 93 E1 92 00 00 0A 07 01 74 E3 28 01 00 CA 84 3D 9F E5 03 00 54 E1 D0 02 00 DA 7C 3D 9F E5 03 00 54 E1 45 02 00 DA 06 20 A0 E1 05 30 A0 E1 00 00 A0 E3 01 11 A0 E3 ?? ?? ?? ?? 00 80 A0 E3 08 90 A0 E1 00 A0 A0 E1 01 B0 A0 E1 0A 20 A0 E1 0B 30 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E3 00 40 A0 E1 01 50 A0 E1 0A 00 A0 E1 0B 10 A0 E1 28 3D 9F E5 ?? ?? ?? ?? 24 2D 9F E5 10 00 8D E5 14 10 8D E5 1C 3D 9F E5 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 10 2D 9F E5 10 3D 9F E5 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 00 2D 9F E5 00 3D 9F E5 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? F0 2C 9F E5 F0 3C 9F E5 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? E0 2C 9F E5 E0 3C 9F E5 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? D0 2C 9F E5 D0 3C 9F E5 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? B8 2C 9F E5 00 A0 A0 E1 01 B0 A0 E1 B0 3C 9F E5 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? A4 2C 9F E5 A4 3C 9F E5 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 94 2C 9F E5 94 3C 9F E5 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 84 2C 9F E5 84 3C 9F E5 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 74 2C 9F E5 74 3C 9F E5 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 64 2C 9F E5 64 3C 9F E5 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 10 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 1B 00 00 EA 14 9C 9F E5 09 00 54 E1 29 00 00 DA 00 00 A0 E3 08 1C 9F E5 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 04 00 A0 E1 05 10 A0 E1 18 D0 8D E2 F0 8F BD E8 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 F5 FF FF EA 00 00 51 E3 0F 00 00 BA ?? ?? ?? ?? 00 40 A0 E1 02 51 81 E2 EF FF FF EA 00 40 A0 E3 04 50 A0 E1 00 00 57 E3 EB FF FF AA 04 20 A0 E1 05 30 A0 E1 08 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 E3 FF FF EA 00 30 E0 E3 02 11 81 E2 00 30 82 E5 ?? ?? ?? ?? 00 40 A0 E1 02 51 81 E2 DC FF FF EA 68 3B 9F E5 02 C1 C1 E3 03 00 5C E1 47 02 00 DA 02 B1 81 E2 0B 10 A0 E1 04 C0 8D E5 ?? ?? ?? ?? 08 00 8D E5 0C 10 8D E5 08 30 8D E2 0C 00 93 E8 06 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 04 C0 9D E5 7E 01 00 0A 00 20 A0 E3 20 3B 9F E5 0B 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 00 B0 A0 E1 04 10 8D E5 ?? ?? ?? ?? 04 C0 9D E5 00 20 A0 E1 01 30 A0 E1 0B 00 A0 E1 0C 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E3 E0 3A 9F E5 00 B0 A0 E1 04 10 8D E5 ?? ?? ?? ?? ?? ?? ?? ?? 04 C0 9D E5 06 00 50 E3 00 F1 9F 97 51 00 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 0C 10 A0 E1 00 20 A0 E3 9C 3A 9F E5 0B 00 A0 E1 ?? ?? ?? ?? 94 2A 9F E5 94 3A 9F E5 ?? ?? ?? ?? 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 02 11 81 E2 00 90 A0 E1 02 B1 81 E2 09 00 A0 E1 0B 10 A0 E1 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 8C FF FF 0A 09 20 A0 E1 05 10 A0 E1 0B 30 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 02 11 C1 E3 00 20 A0 E1 01 30 A0 E1 34 0A 9F E5 34 1A 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? 00 30 A0 E3 08 00 8D E5 0C 10 8D E5 00 20 A0 E3 09 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 00 30 98 A5 00 30 E0 B3 00 30 88 E5 02 51 85 E2 F0 FE FF EA 0B 20 A0 E1 0C 30 A0 E1 00 00 A0 E3 D0 19 9F E5 ?? ?? ?? ?? DC 29 9F E5 DC 39 9F E5 ?? ?? ?? ?? 00 C0 A0 E3 00 20 A0 E3 00 30 A0 E3 00 C0 8D E5 ?? ?? ?? ?? CF FF FF EA 0C 30 A0 E1 0B 20 A0 E1 00 00 A0 E3 A0 19 9F E5 ?? ?? ?? ?? A4 29 9F E5 A4 39 9F E5 ?? ?? ?? ?? 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? C3 FF FF EA 0B 00 A0 E1 0C 10 A0 E1 E7 FF FF EA 0B 00 A0 E1 0C 10 A0 E1 00 20 A0 E3 01 31 A0 E3 ?? ?? ?? ?? E1 FF FF EA 6C 39 9F E5 03 00 54 E1 BA 00 00 CA 05 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 00 A0 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 06 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E3 20 39 9F E5 00 80 A0 E1 01 90 A0 E1 ?? ?? ?? ?? 28 29 9F E5 01 C0 A0 E1 00 B0 A0 E1 20 39 9F E5 08 00 A0 E1 09 10 A0 E1 04 C0 8D E5 ?? ?? ?? ?? 10 29 9F E5 10 39 9F E5 ?? ?? ?? ?? 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? 00 29 9F E5 00 39 9F E5 ?? ?? ?? ?? 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? F0 28 9F E5 F0 38 9F E5 ?? ?? ?? ?? 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? E0 28 9F E5 E0 38 9F E5 ?? ?? ?? ?? 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? D0 28 9F E5 D0 38 9F E5 ?? ?? ?? ?? 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? 34 28 9F E5 34 38 9F E5 ?? ?? ?? ?? 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? A8 28 9F E5 00 40 A0 E1 01 50 A0 E1 A0 38 9F E5 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 94 28 9F E5 94 38 9F E5 ?? ?? ?? ?? 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? 84 28 9F E5 84 38 9F E5 ?? ?? ?? ?? 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? 74 28 9F E5 74 38 9F E5 ?? ?? ?? ?? 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? 64 28 9F E5 64 38 9F E5 ?? ?? ?? ?? 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? 54 28 9F E5 54 38 9F E5 ?? ?? ?? ?? 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E3 C0 37 9F E5 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 04 C0 9D E5 00 20 A0 E1 01 30 A0 E1 0B 00 A0 E1 0C 10 A0 E1 ?? ?? ?? ?? 03 A0 4A E2 00 40 A0 E1 01 50 A0 E1 04 00 5A E3 0A F1 9F 97 F2 FE FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 08 00 A0 E1 09 10 A0 E1 00 20 A0 E3 D4 37 9F E5 ?? ?? ?? ?? 00 A0 A0 E1 01 B0 A0 E1 00 20 A0 E3 C4 37 9F E5 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? 00 A0 A0 E1 01 B0 A0 E1 00 20 A0 E3 24 37 9F E5 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? 00 A0 A0 E1 01 B0 A0 E1 00 20 A0 E3 78 37 9F E5 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? 00 A0 A0 E1 01 B0 A0 E1 00 20 A0 E3 01 31 A0 E3 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 B7 FE FF EA 00 A0 A0 E3 84 B6 9F E5 CD FF FF EA 00 A0 A0 E3 78 B6 9F E5 D4 FF FF EA 00 A0 A0 E3 6C B6 9F E5 DB FF FF EA 00 A0 A0 E3 60 B6 9F E5 E2 FF FF EA E4 36 9F E5 03 00 54 E1 F9 00 00 CA 06 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 06 20 A0 E1 10 00 8D E5 14 10 8D E5 05 30 A0 E1 00 00 A0 E3 2C 16 9F E5 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 00 A0 A0 E1 01 B0 A0 E1 ?? ?? ?? ?? 00 20 A0 E3 00 80 A0 E1 01 90 A0 E1 06 00 A0 E1 05 10 A0 E1 04 36 9F E5 ?? ?? ?? ?? 00 20 A0 E3 00 40 A0 E1 01 50 A0 E1 E8 35 9F E5 10 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 54 26 9F E5 00 40 A0 E1 01 50 A0 E1 08 00 A0 E1 09 10 A0 E1 44 36 9F E5 ?? ?? ?? ?? 40 26 9F E5 40 36 9F E5 ?? ?? ?? ?? 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? 30 26 9F E5 30 36 9F E5 ?? ?? ?? ?? 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? 20 26 9F E5 20 36 9F E5 ?? ?? ?? ?? 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? 10 26 9F E5 10 36 9F E5 ?? ?? ?? ?? 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? 00 26 9F E5 00 36 9F E5 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? F0 25 9F E5 F0 35 9F E5 ?? ?? ?? ?? 9D FF FF EA E8 35 9F E5 03 00 5C E1 00 B0 A0 C3 00 C0 A0 C3 E5 FE FF CA 09 00 5C E1 06 00 00 CA 06 00 A0 E1 0B 10 A0 E1 00 20 A0 E3 C4 35 9F E5 ?? ?? ?? ?? 08 00 8D E5 0C 10 8D E5 08 30 8D E2 0C 00 93 E8 01 90 02 E2 09 00 A0 E1 ?? ?? ?? ?? 00 B0 A0 E1 01 C0 A0 E1 09 01 A0 E1 81 FE FF EA 94 35 9F E5 03 00 54 E1 AB 00 00 DA 06 00 A0 E1 05 10 A0 E1 84 25 9F E5 84 35 9F E5 ?? ?? ?? ?? 00 80 A0 E3 08 90 A0 E1 00 A0 A0 E1 01 B0 A0 E1 0A 20 A0 E1 0B 30 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 10 00 8D E5 14 10 8D E5 ?? ?? ?? ?? 48 25 9F E5 48 35 9F E5 00 40 A0 E1 01 50 A0 E1 ?? ?? ?? ?? 3C 25 9F E5 3C 35 9F E5 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 2C 25 9F E5 2C 35 9F E5 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 1C 25 9F E5 1C 35 9F E5 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 0C 25 9F E5 0C 35 9F E5 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 10 10 8D E2 03 00 91 E8 ?? ?? ?? ?? F4 24 9F E5 10 00 8D E5 14 10 8D E5 EC 34 9F E5 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? E0 24 9F E5 E0 34 9F E5 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? D0 24 9F E5 D0 34 9F E5 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? C0 24 9F E5 C0 34 9F E5 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? B0 24 9F E5 B0 34 9F E5 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 98 24 9F E5 00 A0 A0 E1 01 B0 A0 E1 04 00 A0 E1 05 10 A0 E1 88 34 9F E5 ?? ?? ?? ?? 84 24 9F E5 84 34 9F E5 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 74 24 9F E5 74 34 9F E5 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 64 24 9F E5 64 34 9F E5 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 54 24 9F E5 54 34 9F E5 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 28 04 9F E5 28 14 9F E5 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 10 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 10 24 9F E5 10 34 9F E5 ?? ?? ?? ?? 9C FD FF EA 06 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? FC 33 9F E5 00 80 A0 E1 03 00 54 E1 02 91 81 E2 79 00 00 DA 06 20 A0 E1 05 30 A0 E1 00 00 A0 E3 78 12 9F E5 ?? ?? ?? ?? 00 A0 A0 E1 01 B0 A0 E1 2A FD FF EA 05 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 00 20 A0 E3 54 32 9F E5 ?? ?? ?? ?? 05 30 A0 E1 06 20 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 A2 FD FF EA 48 22 9F E5 48 32 9F E5 ?? ?? ?? ?? 00 C0 A0 E3 00 20 A0 E3 00 30 A0 E3 00 C0 8D E5 ?? ?? ?? ?? 00 90 A0 E1 01 B0 A0 E1 EA FD FF EA 06 00 A0 E1 05 10 A0 E1 00 20 A0 E3 FC 31 9F E5 ?? ?? ?? ?? 00 80 A0 E3 00 60 A0 E1 01 50 A0 E1 08 90 A0 E1 06 00 A0 E1 05 10 A0 E1 00 20 A0 E3 70 31 9F E5 ?? ?? ?? ?? 38 23 9F E5 10 00 8D E5 14 10 8D E5 30 33 9F E5 06 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 24 23 9F E5 24 33 9F E5 ?? ?? ?? ?? 06 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 14 23 9F E5 14 33 9F E5 ?? ?? ?? ?? 06 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 04 23 9F E5 04 33 9F E5 ?? ?? ?? ?? 06 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? F4 22 9F E5 F4 32 9F E5 ?? ?? ?? ?? 06 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 18 21 9F E5 18 31 9F E5 ?? ?? ?? ?? 06 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? CC 22 9F E5 00 A0 A0 E1 01 B0 A0 E1 06 00 A0 E1 05 10 A0 E1 BC 32 9F E5 ?? ?? ?? ?? B8 22 9F E5 B8 32 9F E5 ?? ?? ?? ?? 06 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? A8 22 9F E5 A8 32 9F E5 ?? ?? ?? ?? 06 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 98 22 9F E5 98 32 9F E5 ?? ?? ?? ?? 06 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 88 22 9F E5 88 32 9F E5 ?? ?? ?? ?? 06 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E3 BC 30 9F E5 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 15 FD FF EA 54 32 9F E5 03 00 54 E1 AA FF FF DA 06 00 A0 E1 05 10 A0 E1 44 22 9F E5 44 32 9F E5 ?? ?? ?? ?? 00 A0 A0 E1 01 B0 A0 E1 F6 FE FF EA FF FF EF 7F FF FF 8F 3B CC CC EC 3F C2 B4 FB 3F 00 00 E0 BF 52 FA 8C 42 74 70 FA 3E 4D E5 10 ED EC F2 2C 3F 5D 3F 6F 11 94 8A 53 3F E8 EF 8F B6 4F 40 7E 3F A7 62 55 1A 00 3E B1 3F C8 B0 7D E3 67 C4 B3 3F 37 58 A4 90 8E 85 07 3F 07 FB 7D 98 88 50 1C 3F 00 9C B9 89 C6 B6 40 3F 6B 92 B7 CC D8 AD 67 3F 7B 54 92 AC 22 13 95 3F AD 0F A6 C4 4C A3 D4 3F FF FF 2F 43 00 00 F0 3F FF FF CF 3F 00 00 E0 3F 00 00 10 40 00 00 F8 3F 18 2D 44 54 FB 21 09 40 FF FF 1F 40 45 E9 17 DD EC BF 00 3F 39 F2 68 73 B6 26 5E 3F 61 99 93 7E 1C 48 9B 3F F7 F2 E5 BE 9C BB C2 3F 59 9F 13 4F 8F D9 D4 3F 78 08 E2 36 8B 84 CB 3F 40 81 B3 A5 F7 BA DE 3E 5B A9 41 CA DA 7D 49 3F 75 D4 2E 74 EA 17 93 3F 27 DF FB CC ED 01 C6 3F DC DC D3 93 18 1A E7 3F 74 AB C4 62 A7 45 F6 3F 00 00 18 40 00 00 14 40 00 00 08 40 FF FF 8F 43 E4 43 9E 0B 9D B8 5A BF D1 D5 DA 4C BA 67 4B 3F 41 E7 0F 8C CB 80 43 3F B6 38 CF 98 9F 01 4A 3F 5C 2E B0 16 6C C1 66 3F 3B 55 55 55 55 55 B5 3F 69 7D C9 90 E3 CF DA 3F FF FF 3F 43 00 00 30 43 C3 B4 F3 3F 3F BE 56 63 D8 62 F7 3F F7 BB 0E 6C 6D AF 34 3F F1 1A 2D BF 8E FE 56 3F 44 E3 70 E3 E0 FC 78 3F 13 B7 35 DF A8 C9 A0 3F A2 38 EE C8 2B F7 DE 3F F4 D3 C2 E8 3E FD 35 3F EC E0 73 9C 10 A6 41 3F 15 C9 15 2E D3 82 62 3F 6A EC 91 BA 9F 1F 85 3F 9B 41 D5 94 42 8B B0 3F 38 8C C3 EC 24 7F 34 BF E9 A8 61 EF 0C DF 4C 3F D7 14 E9 B3 FF 2E 6E 3F EC F9 0A 97 E7 66 92 3F 09 C5 C6 8D 27 E4 C2 3F 1F 97 8A A4 CA C7 50 BC 42 8A C3 BC B9 19 BF 3F 43 69 E7 3F 09 AB 2B BF 8B 67 8B 3F 24 09 01 F6 AE 4E CD 3F 50 84 EA 44 76 49 EF 3F 6F BD 19 D1 5C 47 F7 3F }
	condition:
		$1
}

rule file_123_0_2 {
	meta:
		name = "__g_dfmt"
		size = 376
		refs = "00b4 __gdtoa 00d0 __g__fmt 014c __strcp_D2A 016c .data 0170 .rdata"
	strings:
		$1 = { F0 40 2D E9 C2 CF C2 E1 03 40 A0 E1 0A 30 8C E2 04 00 53 E1 24 D0 4D E2 00 50 A0 E1 39 00 00 8A 04 30 91 E5 38 21 9F E5 34 01 9F E5 02 20 03 E0 00 00 52 E1 02 61 03 E2 34 00 00 0A 00 20 91 E5 00 00 52 E3 24 00 00 0A 23 1A A0 E1 81 1A A0 E1 A1 1A A0 E1 FF 34 C3 E3 00 00 51 E3 0F 36 C3 E3 14 30 8D E5 43 1E 41 12 01 36 83 13 F4 10 9F 05 14 30 8D 15 03 10 41 12 00 00 5C E3 0C E0 A0 01 02 E0 A0 13 04 C0 8D E5 1C C0 8D E2 10 20 8D E5 18 30 8D E2 10 20 8D E2 08 C0 8D E5 C8 00 9F E5 20 C0 8D E2 01 70 A0 E3 18 70 8D E5 00 E0 8D E5 0C C0 8D E5 ?? ?? ?? ?? 20 20 9D E5 00 10 A0 E1 1C 30 9D E5 05 00 A0 E1 00 60 8D E5 04 40 8D E5 ?? ?? ?? ?? 24 D0 8D E2 F0 80 BD E8 06 00 53 E1 D8 FF FF 1A 00 00 53 E3 2D 30 A0 B3 01 30 C5 B4 05 00 A0 E1 30 30 A0 E3 01 30 C0 E4 00 30 A0 E3 01 30 C5 E5 F2 FF FF EA 00 00 A0 E3 F0 FF FF EA 09 00 54 E3 FB FF FF 9A FF 34 C3 E3 0F 36 C3 E3 00 00 53 E3 0A 00 00 1A 00 30 91 E5 00 00 53 E3 07 00 00 1A 00 00 56 E3 05 00 A0 11 2D 30 A0 13 05 00 A0 01 01 30 C0 14 20 10 9F E5 ?? ?? ?? ?? DF FF FF EA 05 00 A0 E1 14 10 9F E5 ?? ?? ?? ?? DB FF FF EA 00 00 F0 7F CE FB FF FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_124_0_2 {
	meta:
		name = "__ieee754_logf"
		size = 972
		refs = "0030 __mulsf3 0078 __subsf3 0098 __eqsf2 00b4 __floatsisf 00dc __addsf3 0100 __divsf3"
	strings:
		$1 = { 02 05 50 E3 F0 47 2D E9 00 10 A0 E1 00 20 A0 E1 00 70 A0 A3 09 00 00 AA 02 31 C0 E3 00 00 53 E3 7A 00 00 0A 00 00 50 E3 C0 00 00 BA 13 13 A0 E3 ?? ?? ?? ?? 18 70 E0 E3 00 10 A0 E1 00 20 A0 E1 4C 33 9F E5 03 00 52 E1 25 00 00 CA FF 44 C2 E3 40 33 9F E5 02 45 C4 E3 03 30 84 E0 02 35 03 E2 FE 05 23 E2 7F 70 47 E2 C2 7B 87 E0 04 00 80 E1 FE 15 A0 E3 A3 7B 87 E0 ?? ?? ?? ?? 0F 30 84 E2 FF 34 C3 E3 02 35 C3 E3 0F 00 53 E3 00 50 A0 E1 16 00 00 CA 00 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 5E 00 00 1A 00 00 57 E3 00 00 A0 03 F0 87 BD 08 07 00 A0 E1 ?? ?? ?? ?? DC 12 9F E5 00 50 A0 E1 ?? ?? ?? ?? D4 12 9F E5 00 40 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? F0 87 BD E8 01 00 A0 E1 ?? ?? ?? ?? F0 87 BD E8 01 11 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 80 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 08 10 A0 E1 00 90 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 00 A0 A0 E1 ?? ?? ?? ?? 70 12 9F E5 00 60 A0 E1 ?? ?? ?? ?? 68 12 9F E5 ?? ?? ?? ?? 06 10 A0 E1 ?? ?? ?? ?? 5C 12 9F E5 ?? ?? ?? ?? 06 10 A0 E1 ?? ?? ?? ?? 50 12 9F E5 ?? ?? ?? ?? 0A 10 A0 E1 ?? ?? ?? ?? 44 12 9F E5 00 A0 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 38 12 9F E5 ?? ?? ?? ?? 06 10 A0 E1 ?? ?? ?? ?? 2C 12 9F E5 ?? ?? ?? ?? 06 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 14 62 9F E5 D7 39 64 E2 06 60 84 E0 A2 3F 83 E2 06 60 83 E1 00 00 56 E3 00 A0 A0 E1 29 00 00 DA 3F 14 A0 E3 05 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 00 00 57 E3 00 40 A0 E1 39 00 00 1A 0A 10 A0 E1 ?? ?? ?? ?? 08 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? F0 87 BD E8 00 10 A0 E3 33 03 A0 E3 ?? ?? ?? ?? F0 87 BD E8 05 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 90 11 9F E5 00 40 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 3F 14 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 00 57 E3 00 40 A0 E1 38 00 00 1A 05 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? F0 87 BD E8 00 00 57 E3 3E 00 00 0A 09 00 A0 E1 1C 11 9F E5 ?? ?? ?? ?? 0A 10 A0 E1 00 40 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 08 10 A0 E1 ?? ?? ?? ?? 28 11 9F E5 00 60 A0 E1 09 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? F0 87 BD E8 C8 10 9F E5 09 00 A0 E1 ?? ?? ?? ?? 0A 10 A0 E1 00 60 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 08 10 A0 E1 ?? ?? ?? ?? A8 10 9F E5 00 70 A0 E1 09 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? F0 87 BD E8 ?? ?? ?? ?? 00 10 A0 E3 ?? ?? ?? ?? F0 87 BD E8 07 00 A0 E1 ?? ?? ?? ?? 4C 10 9F E5 00 70 A0 E1 ?? ?? ?? ?? 6C 10 9F E5 00 60 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? E9 FF FF EA 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 08 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? F0 87 BD E8 FF FF 7F 7F 20 FB 4A 00 80 71 31 3F D1 F7 17 37 97 88 17 3E 25 33 3A 3E 25 49 92 3E AB AA 2A 3F 4F D0 1C 3E 29 8E 63 3E CD CC CC 3E 30 5C CF FF AB AA AA BE D1 F7 17 B7 }
	condition:
		$1
}

rule file_125_0_2 {
	meta:
		name = "__gdtoa"
		size = 5948
		refs = "0034 .text 0070 __Balloc_D2A 00e0 __trailz_D2A 0104 __Bfree_D2A 011c __nrv_alloc_D2A 0188 __b2d_D2A 01dc __subdf3 01e8 __muldf3 01f4 __adddf3 0204 __floatsidf 027c __fixdfsi 0294 __ltdf2 02b0 __nedf2 02fc __gtdf2 03c0 __rv_alloc_D2A 04e8 __divdf3 0794 __pow5mult_D2A 07a0 __mult_D2A 07cc __i2b_D2A 081c __clzsi2 0850 __lshift_D2A 08bc __multadd_D2A 08cc __cmp_D2A 08ec __rshift_D2A 09bc __gedf2 0d20 __quorem_D2A 0d40 __diff_D2A 0dd8 __eqdf2 10bc .rdata 1104 __tens_D2A 15c8 memcpy"
	strings:
		$1 = { F0 4F 2D E9 00 80 93 E5 03 40 A0 E1 07 30 08 E2 30 80 C8 E3 8C D0 4D E2 00 90 A0 E1 01 B0 A0 E1 02 A0 A0 E1 00 80 84 E5 04 00 53 E3 03 F1 9F 97 3E 00 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 60 90 E5 20 00 56 E3 00 00 A0 D3 05 00 00 DA 00 00 A0 E3 20 30 A0 E3 83 30 A0 E1 03 00 56 E1 01 00 80 E2 FB FF FF CA ?? ?? ?? ?? 00 50 A0 E1 01 00 46 E2 C0 02 A0 E1 14 70 85 E2 00 01 8A E0 0A 30 A0 E1 07 20 A0 E1 04 10 93 E4 03 00 50 E1 04 10 82 E4 FB FF FF 2A 02 70 67 E0 47 71 A0 E1 07 31 85 E0 14 30 83 E2 00 00 00 EA 02 70 A0 E1 04 20 13 E5 04 30 43 E2 00 00 52 E3 01 20 47 E2 0F 02 00 1A 00 00 52 E3 F7 FF FF 1A 10 20 85 E5 34 20 8D E5 05 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 88 00 8D E5 38 B0 8D 05 FB 01 00 1A 10 30 95 E5 00 00 53 E3 1F 00 00 1A 05 00 A0 E1 ?? ?? ?? ?? B8 00 9D E5 01 20 A0 E3 00 20 80 E5 BC 10 9D E5 9C 0F 9F E5 ?? ?? ?? ?? 00 70 A0 E1 07 00 A0 E1 8C D0 8D E2 F0 8F BD E8 00 70 A0 E3 FA FF FF EA B8 20 9D E5 7C 3F 9F E5 BC 10 9D E5 00 30 82 E5 74 0F 9F E5 03 20 A0 E3 ?? ?? ?? ?? 00 70 A0 E1 F1 FF FF EA B8 00 9D E5 58 3F 9F E5 BC 10 9D E5 00 30 80 E5 08 20 A0 E3 50 0F 9F E5 ?? ?? ?? ?? 00 70 A0 E1 E8 FF FF EA 05 00 A0 E1 88 10 8D E2 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 18 20 8D E5 1C 30 8D E5 1C C0 9D E5 38 00 9D E5 FF 34 CC E3 0F 36 C3 E3 34 10 9D E5 FF 35 83 E3 03 36 83 E3 1C 30 8D E5 01 70 80 E0 01 70 47 E2 28 30 8D E5 00 20 A0 E3 F8 3E 9F E5 18 10 8D E2 03 00 91 E8 88 70 8D E5 ?? ?? ?? ?? E8 2E 9F E5 E8 3E 9F E5 ?? ?? ?? ?? E4 2E 9F E5 E4 3E 9F E5 ?? ?? ?? ?? 20 00 8D E5 24 10 8D E5 07 00 A0 E1 ?? ?? ?? ?? D0 2E 9F E5 D0 3E 9F E5 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 20 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 2C 00 8D E5 30 10 8D E5 C7 0F 27 E0 C7 0F 40 E0 43 0E 40 E2 05 00 40 E2 00 00 50 E3 0A 00 00 DA ?? ?? ?? ?? 94 2E 9F E5 94 3E 9F E5 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 2C 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 2C 00 8D E5 30 10 8D E5 2C 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 20 A0 E3 20 00 8D E5 00 30 A0 E3 2C 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 00 50 E3 08 00 00 AA 20 00 9D E5 ?? ?? ?? ?? 2C 30 8D E2 0C 00 93 E8 ?? ?? ?? ?? 00 00 50 E3 20 30 9D 15 01 30 43 12 20 30 8D 15 20 C0 9D E5 28 00 9D E5 16 00 5C E3 07 0A 80 E0 01 10 A0 83 1C 00 8D E5 58 10 8D 85 0E 00 00 8A 20 C0 9D E5 14 1E 9F E5 18 30 8D E2 0C 00 93 E8 8C 11 81 E0 03 00 91 E8 ?? ?? ?? ?? 00 00 50 E3 20 10 9D C5 00 00 A0 D3 01 10 41 C2 00 20 A0 C3 58 00 8D D5 20 10 8D C5 58 20 8D C5 34 C0 9D E5 20 20 9D E5 01 30 4C E2 07 70 53 E0 00 00 A0 53 00 70 67 42 00 10 A0 43 3C 70 8D 55 48 00 8D 55 48 70 8D 45 3C 10 8D 45 00 00 52 E3 21 02 00 BA 3C 30 9D E5 00 C0 A0 E3 02 30 83 E0 3C 30 8D E5 50 20 8D E5 4C C0 8D E5 B0 C0 9D E5 09 00 5C E3 00 00 A0 83 B0 00 8D 85 69 01 00 9A 06 00 A0 E1 ?? ?? ?? ?? 60 2D 9F E5 50 3D 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? 00 10 A0 E3 00 20 E0 E3 03 00 80 E2 01 30 A0 E3 40 10 8D E5 5C 20 8D E5 88 00 8D E5 54 30 8D E5 2C 20 8D E5 B4 10 8D E5 ?? ?? ?? ?? 0C 30 99 E5 00 70 A0 E1 01 30 43 E2 00 00 53 E3 28 30 8D E5 05 00 00 0A 02 20 A0 B3 28 20 8D B5 08 00 18 E3 28 30 9D 15 03 30 63 12 28 30 8D 15 40 C0 9D E5 00 00 5C E3 BD 00 00 0A 28 00 9D E5 20 10 9D E5 01 C0 90 E1 B9 00 00 1A 58 20 9D E5 88 C0 8D E5 00 00 52 E3 18 10 8D E2 03 00 91 E8 BB 01 00 0A C4 3C 9F E5 00 20 A0 E3 0C 80 A0 E1 ?? ?? ?? ?? 2C 10 9D E5 00 00 51 E3 00 30 A0 D3 01 30 A0 C3 00 00 50 E3 01 80 A0 B3 08 00 13 E1 AF 01 00 0A 5C 20 9D E5 00 00 52 E3 A4 00 00 DA 00 20 A0 E3 98 3C 9F E5 18 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 20 A0 E3 74 3C 9F E5 60 00 8D E5 64 10 8D E5 ?? ?? ?? ?? 00 20 A0 E3 64 3C 9F E5 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 40 20 8D E5 44 30 8D E5 44 30 9D E5 5C C0 9D E5 0D 35 43 E2 00 00 E0 E3 44 30 8D E5 68 C0 8D E5 74 00 8D E5 54 C0 9D E5 00 00 5C E3 50 03 00 0A 68 10 9D E5 28 3C 9F E5 00 00 A0 E3 81 31 83 E0 0C 00 13 E9 20 1C 9F E5 ?? ?? ?? ?? 40 30 8D E2 0C 00 93 E8 ?? ?? ?? ?? 00 30 A0 E3 6C 00 8D E5 70 10 8D E5 60 10 8D E2 03 00 91 E8 88 30 8D E5 ?? ?? ?? ?? 04 00 8D E5 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 60 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 04 C0 9D E5 07 80 A0 E1 30 30 8C E2 40 00 8D E5 44 10 8D E5 01 30 C8 E4 6C 30 8D E2 0C 00 93 E8 ?? ?? ?? ?? 00 00 50 E3 54 00 00 BA 40 30 8D E2 0C 00 93 E8 00 00 A0 E3 84 1B 9F E5 ?? ?? ?? ?? 6C 30 8D E2 0C 00 93 E8 ?? ?? ?? ?? 00 00 50 E3 B2 03 00 BA 88 30 9D E5 68 20 9D E5 01 30 83 E2 02 00 53 E1 88 30 8D E5 56 00 00 AA 02 30 87 E2 78 50 8D E5 7C 60 8D E5 80 90 8D E5 84 A0 8D E5 40 90 8D E2 00 03 99 E8 60 70 8D E5 40 B0 8D E5 03 60 A0 E1 04 B0 A0 E1 02 A0 A0 E1 6C 50 8D E2 30 00 95 E8 0B 00 00 EA ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 93 03 00 BA 88 30 9D E5 01 60 86 E2 01 30 83 E2 0A 00 53 E1 88 30 8D E5 36 00 00 AA 04 00 A0 E1 05 10 A0 E1 00 20 A0 E3 EC 3A 9F E5 ?? ?? ?? ?? 00 20 A0 E3 E0 3A 9F E5 00 40 A0 E1 01 50 A0 E1 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 01 90 A0 E1 00 80 A0 E1 ?? ?? ?? ?? 00 70 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 30 70 87 E2 01 70 46 E5 04 20 A0 E1 05 30 A0 E1 01 90 A0 E1 00 80 A0 E1 ?? ?? ?? ?? 00 00 50 E3 08 20 A0 E1 09 30 A0 E1 00 00 A0 E3 60 1A 9F E5 06 70 A0 E1 CF FF FF AA 60 70 9D E5 78 50 9D E5 40 80 8D E5 44 90 8D E5 0B 40 A0 E1 06 80 A0 E1 00 30 A0 E3 40 10 8D E2 03 00 91 E8 00 20 A0 E3 ?? ?? ?? ?? 00 00 50 E3 74 30 9D 05 74 C0 9D 15 01 B0 83 02 00 A0 A0 03 01 B0 8C 12 10 A0 A0 13 CC 00 00 EA 0B 40 A0 E1 60 70 9D E5 78 50 8D E2 60 06 95 E8 40 B0 9D E5 20 20 9D E5 38 30 9D E5 0E 00 52 E3 00 10 A0 C3 01 10 A0 D3 00 00 53 E3 00 10 A0 B3 00 00 51 E3 91 00 00 1A 54 C0 9D E5 00 00 5C E3 EC 01 00 1A 4C 60 9D E5 48 80 9D E5 38 C0 8D E5 3C 30 9D E5 00 00 53 E3 00 00 58 C3 09 00 00 DA 3C C0 9D E5 48 00 9D E5 08 00 53 E1 08 30 A0 A1 0C C0 63 E0 00 00 63 E0 3C C0 8D E5 88 30 8D E5 48 00 8D E5 08 80 63 E0 4C 10 9D E5 00 00 51 E3 13 00 00 DA 54 20 9D E5 00 00 52 E3 8C 02 00 0A 00 00 56 E3 0B 00 00 DA 06 10 A0 E1 38 00 9D E5 ?? ?? ?? ?? 05 10 A0 E1 38 00 8D E5 ?? ?? ?? ?? 00 30 A0 E1 05 00 A0 E1 00 30 8D E5 ?? ?? ?? ?? 00 30 9D E5 03 50 A0 E1 4C 30 9D E5 06 10 53 E0 89 02 00 1A 01 00 A0 E3 ?? ?? ?? ?? 50 C0 9D E5 18 00 8D E5 00 00 5C E3 02 00 00 DA 0C 10 A0 E1 ?? ?? ?? ?? 18 00 8D E5 B0 00 9D E5 01 00 50 E3 94 00 00 DA 00 90 A0 E3 50 C0 9D E5 00 00 5C E3 1F 00 A0 03 04 00 00 0A 18 00 9D E5 10 30 90 E5 03 31 80 E0 10 00 93 E5 ?? ?? ?? ?? 3C 10 9D E5 03 30 E0 E3 03 30 61 E0 00 30 83 E0 48 20 9D E5 1F 60 03 E2 02 10 86 E0 00 00 51 E3 88 60 8D E5 06 10 A0 D1 03 00 00 DA 05 00 A0 E1 ?? ?? ?? ?? 88 10 9D E5 00 50 A0 E1 3C 30 9D E5 03 10 81 E0 00 00 51 E3 02 00 00 DA 18 00 9D E5 ?? ?? ?? ?? 18 00 8D E5 58 C0 9D E5 00 00 5C E3 C4 01 00 1A 2C C0 9D E5 B0 00 9D E5 00 00 5C E3 00 30 A0 C3 01 30 A0 D3 02 00 50 E3 00 30 A0 D3 00 00 53 E3 D5 00 00 0A 00 00 5C E3 C3 00 00 1A 0C 20 A0 E1 05 10 A0 E3 18 00 9D E5 ?? ?? ?? ?? 18 00 8D E5 18 10 9D E5 05 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 B9 00 00 DA 20 10 9D E5 02 B0 81 E2 3D 00 00 EA 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 88 30 9D E5 34 C0 9D E5 0C C0 63 E0 03 30 8B E0 34 C0 8D E5 38 30 8D E5 F9 FD FF EA 07 31 85 E0 10 70 85 E5 10 00 93 E5 ?? ?? ?? ?? 87 72 60 E0 34 70 8D E5 EC FD FF EA 05 00 5C E3 B0 00 9D C5 01 20 A0 D3 04 00 40 C2 B0 00 8D C5 B0 10 9D E5 00 20 A0 C3 02 30 41 E2 03 00 53 E3 03 F1 9F 97 8A FE FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? B4 C0 9D E5 2C 00 9D E5 AC 6F A0 E1 8C 37 9F E5 00 00 50 E3 00 60 A0 C3 01 60 06 D2 82 31 83 E0 00 00 56 E3 06 00 93 E8 08 10 8D E5 0C 20 8D E5 F4 00 00 0A 00 00 50 E3 84 00 00 1A 01 00 A0 E1 54 37 9F E5 02 10 A0 E1 00 20 A0 E3 ?? ?? ?? ?? 18 30 8D E2 0C 00 93 E8 ?? ?? ?? ?? 00 00 50 E3 7A 00 00 AA 2C 20 9D E5 20 30 9D E5 18 20 8D E5 02 B0 83 E2 38 20 8D E5 07 80 A0 E1 31 30 A0 E3 01 30 C8 E4 38 60 9D E5 00 90 A0 E3 20 A0 A0 E3 18 00 9D E5 ?? ?? ?? ?? 00 00 56 E3 04 00 00 0A 06 00 59 E1 00 00 59 13 5E 01 00 1A 06 00 A0 E1 ?? ?? ?? ?? 05 00 A0 E1 ?? ?? ?? ?? 00 30 A0 E3 BC 20 9D E5 00 30 C8 E5 B8 30 9D E5 00 00 52 E3 00 B0 83 E5 00 30 94 E5 00 80 82 15 0A A0 83 E1 00 A0 84 E5 B5 FD FF EA 34 10 9D E5 01 00 51 E3 67 FF FF 1A 04 30 99 E5 01 30 83 E2 03 00 5B E1 63 FF FF DA 48 20 9D E5 3C 30 9D E5 01 20 82 E2 01 30 83 E2 48 20 8D E5 3C 30 8D E5 01 90 A0 E1 5C FF FF EA 01 30 A0 E3 54 30 8D E5 B4 00 9D E5 01 00 50 E3 01 00 A0 B3 0E 00 50 E3 00 20 A0 83 01 20 02 92 B4 00 8D E5 40 20 8D E5 88 00 8D E5 5C 00 8D E5 2C 00 8D E5 3F FE FF EA 00 10 A0 E3 54 10 8D E5 20 30 9D E5 B4 C0 9D E5 0C 30 83 E0 01 00 83 E2 00 00 50 E3 5C 30 8D E5 2C 00 8D E5 88 00 8D E5 AA 01 00 DA 0E 00 50 E3 00 20 A0 83 01 20 02 92 40 20 8D E5 2F FE FF EA 00 C0 A0 E3 54 C0 8D E5 E0 FF FF EA 01 C0 A0 E3 54 C0 8D E5 EB FF FF EA 18 30 8D E2 0C 00 93 E8 02 00 A0 E1 03 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E3 C4 35 9F E5 ?? ?? ?? ?? 01 30 A0 E1 00 20 A0 E1 40 20 8D E5 44 30 8D E5 44 C0 9D E5 2C 30 9D E5 0D 85 4C E2 00 00 53 E3 44 80 8D E5 9A 01 00 1A 00 20 A0 E3 94 35 9F E5 18 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 40 C0 9D E5 08 30 A0 E1 0C 20 A0 E1 60 00 8D E5 64 10 8D E5 ?? ?? ?? ?? 00 00 50 E3 9A 01 00 CA 40 00 9D E5 02 31 88 E2 00 20 A0 E1 60 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 00 50 E3 D0 FE FF AA 00 20 A0 E3 18 20 8D E5 38 20 8D E5 B4 30 9D E5 38 60 9D E5 00 B0 63 E2 07 80 A0 E1 00 90 A0 E3 10 A0 A0 E3 85 FF FF EA 48 00 9D E5 20 10 9D E5 00 30 A0 E3 00 00 61 E0 00 20 61 E2 48 00 8D E5 4C 20 8D E5 50 30 8D E5 DA FD FF EA 54 00 9D E5 00 00 50 E3 FC 00 00 0A 08 10 86 E0 00 00 51 E3 02 00 00 DA 38 00 9D E5 ?? ?? ?? ?? 38 00 8D E5 00 00 59 E3 38 60 9D 05 5B 02 00 1A 01 30 A0 E3 88 30 8D E5 38 90 9D E5 07 80 A0 E1 10 70 8D E5 34 40 8D E5 32 00 00 EA 07 00 A0 E1 00 30 8D E5 ?? ?? ?? ?? 00 30 9D E5 B0 C0 9D E5 0C C0 93 E1 04 00 00 1A 00 20 9A E5 28 00 9D E5 01 20 02 E2 02 00 90 E1 94 02 00 0A 00 00 54 E3 F5 01 00 BA B0 20 9D E5 02 20 94 E1 02 00 00 1A 00 20 9A E5 01 00 12 E3 EF 01 00 0A 28 C0 9D E5 02 00 5C E3 00 00 53 13 00 40 A0 D3 01 40 A0 C3 4A 02 00 CA 01 B0 C8 E4 88 30 9D E5 2C 20 9D E5 02 00 53 E1 58 02 00 0A 05 00 A0 E1 0A 10 A0 E3 04 20 A0 E1 ?? ?? ?? ?? 06 00 59 E1 00 50 A0 E1 A2 00 00 0A 09 00 A0 E1 0A 10 A0 E3 04 20 A0 E1 ?? ?? ?? ?? 04 20 A0 E1 00 90 A0 E1 0A 10 A0 E3 06 00 A0 E1 ?? ?? ?? ?? 00 60 A0 E1 88 30 9D E5 01 30 83 E2 88 30 8D E5 18 10 9D E5 05 00 A0 E1 ?? ?? ?? ?? 09 10 A0 E1 30 B0 80 E2 05 00 A0 E1 ?? ?? ?? ?? 06 10 A0 E1 00 40 A0 E1 18 00 9D E5 ?? ?? ?? ?? 0C 30 90 E5 00 70 A0 E1 00 00 53 E3 01 30 A0 13 BC FF FF 1A 05 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 00 30 A0 E1 B7 FF FF EA 01 C0 A0 E3 18 90 8D E2 00 03 99 E8 08 30 8D E2 0C 00 93 E8 08 00 A0 E1 09 10 A0 E1 88 C0 8D E5 ?? ?? ?? ?? ?? ?? ?? ?? 00 A0 A0 E1 ?? ?? ?? ?? 08 30 8D E2 0C 00 93 E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 07 80 A0 E1 30 30 8A E2 10 00 8D E5 14 10 8D E5 00 20 A0 E3 01 30 C8 E4 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 20 C0 9D 05 06 A0 A0 01 01 B0 8C 02 09 FF FF 0A 88 C0 9D E5 2C 00 9D E5 0C 00 50 E1 C9 00 00 0A 02 60 87 E2 18 70 8D E5 34 50 8D E5 04 B0 A0 E1 08 80 8D E2 80 01 98 E8 2C 90 9D E5 10 50 8D E2 30 00 95 E8 03 00 00 EA 88 C0 9D E5 01 60 86 E2 0C 00 59 E1 B5 00 00 0A 01 C0 8C E2 04 00 A0 E1 05 10 A0 E1 00 20 A0 E3 B8 32 9F E5 88 C0 8D E5 ?? ?? ?? ?? 07 20 A0 E1 08 30 A0 E1 00 40 A0 E1 01 50 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 00 A0 A0 E1 ?? ?? ?? ?? 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 30 30 8A E2 01 30 46 E5 00 20 A0 E3 00 30 A0 E3 00 40 A0 E1 01 50 A0 E1 ?? ?? ?? ?? 00 00 50 E3 06 30 A0 E1 DA FF FF 1A 20 30 9D E5 0B 40 A0 E1 18 70 9D E5 06 80 A0 E1 34 50 9D E5 01 B0 83 E2 00 A0 A0 E3 CE FE FF EA B0 00 9D E5 01 00 50 E3 2A 01 00 DA 2C 20 9D E5 4C C0 9D E5 01 30 42 E2 03 00 5C E1 4C 00 9D B5 50 20 9D B5 03 30 60 B0 03 00 80 B0 03 20 82 B0 0C 60 63 A0 2C 30 9D E5 4C 00 8D B5 50 20 8D B5 01 60 A0 B1 00 00 53 E3 88 30 8D E5 0A 00 00 BA 48 80 9D E5 3C 10 9D E5 48 20 9D E5 03 10 81 E0 03 20 82 E0 01 00 A0 E3 3C 10 8D E5 48 20 8D E5 ?? ?? ?? ?? 38 00 8D E5 F6 FD FF EA 48 C0 9D E5 2C 00 9D E5 00 30 A0 E3 88 30 8D E5 0C 80 60 E0 EF FF FF EA 09 00 A0 E1 04 20 A0 E1 0A 10 A0 E3 ?? ?? ?? ?? 00 90 A0 E1 00 60 A0 E1 5F FF FF EA 09 00 A0 E1 ?? ?? ?? ?? 9D FE FF EA 05 00 A0 E1 18 10 9D E5 ?? ?? ?? ?? 00 00 50 E3 35 FE FF AA 00 20 A0 E3 05 00 A0 E1 0A 10 A0 E3 ?? ?? ?? ?? 00 50 A0 E1 54 00 9D E5 20 10 9D E5 00 00 50 E3 5C 20 9D 05 01 10 41 E2 20 10 8D E5 2C 20 8D 05 28 FE FF 0A 38 00 9D E5 0A 10 A0 E3 00 20 A0 E3 ?? ?? ?? ?? 5C 30 9D E5 38 00 8D E5 2C 30 8D E5 20 FE FF EA }
	condition:
		$1
}

rule file_127_0_2 {
	meta:
		name = "__ieee754_remainderf"
		size = 316
		refs = "0058 __addsf3 0060 __gtsf2 0074 __subsf3 0088 __gesf2 00b0 __mulsf3 00b8 __divsf3 0118 fmodf"
	strings:
		$1 = { F0 41 2D E9 02 41 D1 E3 01 50 A0 E1 00 60 A0 E1 26 00 00 0A 18 31 9F E5 18 21 9F E5 02 71 C0 E3 03 00 57 E1 02 00 54 D1 00 80 A0 E1 1F 00 00 CA 7F 04 54 E3 33 00 00 BA 04 00 57 E1 38 00 00 0A 01 04 54 E3 02 61 C6 E3 02 51 C5 E3 1B 00 00 AA 06 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 0D 00 00 DA 06 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 00 60 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 03 00 00 BA 06 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 60 A0 E1 02 81 08 E2 06 00 28 E0 F0 81 BD E8 ?? ?? ?? ?? 00 10 A0 E1 ?? ?? ?? ?? F0 81 BD E8 3F 14 A0 E3 05 00 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 04 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 EF FF FF DA 06 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 00 60 A0 E1 ?? ?? ?? ?? 00 00 50 E3 E7 FF FF BA E2 FF FF EA 01 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 00 60 A0 E1 C4 FF FF EA 06 00 A0 E1 00 10 A0 E3 ?? ?? ?? ?? F0 81 BD E8 FF FF 7F 7F 00 00 80 7F }
	condition:
		$1
}

rule file_128_0_2 {
	meta:
		name = "roundf"
		size = 184
		refs = "0008 __fpclassifyf 0018 _isnanf 002c __gesf2 003c floorf 0048 __subsf3 0050 __lesf2 0068 __addsf3"
	strings:
		$1 = { 30 40 2D E9 00 40 A0 E1 ?? ?? ?? ?? 05 0C 50 E3 16 00 00 0A 04 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 12 00 00 1A 04 00 A0 E1 00 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 0F 00 00 BA 04 00 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 00 50 A0 E1 ?? ?? ?? ?? BF 14 A0 E3 ?? ?? ?? ?? 00 00 50 E3 05 40 A0 C1 03 00 00 CA 05 00 A0 E1 FE 15 A0 E3 ?? ?? ?? ?? 00 40 A0 E1 04 00 A0 E1 30 80 BD E8 02 01 84 E2 ?? ?? ?? ?? 04 10 A0 E1 00 50 A0 E1 ?? ?? ?? ?? BF 14 A0 E3 ?? ?? ?? ?? 00 00 50 E3 03 00 00 CA 05 00 A0 E1 FE 15 A0 E3 ?? ?? ?? ?? 00 50 A0 E1 02 41 85 E2 04 00 A0 E1 30 80 BD E8 }
	condition:
		$1
}

rule file_130_0_2 {
	meta:
		name = "log1p"
		size = 1712
		refs = "0038 __eqdf2 0054 __divdf3 008c __adddf3 00b8 __subdf3 0124 __muldf3 0188 __floatsidf 0428 __gtdf2"
	strings:
		$1 = { F0 4D 2D E9 1C 26 9F E5 20 D0 4D E2 02 00 51 E1 00 70 A0 E1 01 80 A0 E1 01 40 A0 E1 10 00 00 CA 04 26 9F E5 02 41 C1 E3 02 00 54 E1 68 00 00 DA 00 20 A0 E3 F4 35 9F E5 ?? ?? ?? ?? 00 00 50 E3 E8 00 00 1A 00 00 A0 E3 E4 15 9F E5 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 70 A0 E1 01 80 A0 E1 DC 00 00 EA CC 25 9F E5 02 00 51 E1 D4 00 00 CA C4 25 9F E5 02 00 51 E1 0C 01 00 CA 07 00 A0 E1 08 10 A0 E1 00 20 A0 E3 B0 35 9F E5 ?? ?? ?? ?? 41 4A A0 E1 FF 4F 44 E2 03 40 44 E2 00 00 54 E3 00 A0 A0 E1 01 B0 A0 E1 01 50 A0 E1 54 01 00 DA 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 00 00 A0 E3 70 15 9F E5 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? 08 00 8D E5 0C 10 8D E5 FF 74 C5 E3 54 35 9F E5 0F 76 C7 E3 03 00 57 E1 E5 00 00 CA FF B5 87 E3 03 B6 8B E3 0A 00 A0 E1 0B 10 A0 E1 00 20 A0 E3 2C 35 9F E5 ?? ?? ?? ?? 00 20 A0 E3 28 35 9F E5 00 50 A0 E1 01 60 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 00 00 57 E3 00 A0 A0 E1 01 B0 A0 E1 05 70 A0 E1 06 80 A0 E1 00 0C 8D E8 30 00 00 1A 05 00 A0 E1 06 10 A0 E1 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 D8 00 00 1A 00 00 54 E3 00 70 A0 03 00 80 A0 03 94 00 00 0A 04 00 A0 E1 ?? ?? ?? ?? B8 24 9F E5 B8 34 9F E5 00 40 A0 E1 01 50 A0 E1 ?? ?? ?? ?? AC 24 9F E5 00 70 A0 E1 01 80 A0 E1 04 00 A0 E1 05 10 A0 E1 9C 34 9F E5 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 08 10 8D E2 03 00 91 E8 ?? ?? ?? ?? A6 00 00 EA 80 24 9F E5 02 00 54 E1 8C 00 00 DA 78 24 9F E5 74 34 9F E5 02 20 81 E0 03 00 52 E1 A1 FF FF 9A 00 20 A0 E3 48 34 9F E5 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 03 00 8D E8 00 40 A0 E3 00 20 A0 E3 01 31 A0 E3 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 00 A0 A0 E1 01 B0 A0 E1 ?? ?? ?? ?? 04 24 9F E5 04 34 9F E5 00 50 A0 E1 01 60 A0 E1 ?? ?? ?? ?? F8 23 9F E5 F8 33 9F E5 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? E8 23 9F E5 E8 33 9F E5 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? D8 23 9F E5 D8 33 9F E5 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? C8 23 9F E5 C8 33 9F E5 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? B8 23 9F E5 B8 33 9F E5 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? A8 23 9F E5 A8 33 9F E5 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 00 00 54 E3 00 50 A0 E1 01 60 A0 E1 89 00 00 0A 04 00 A0 E1 ?? ?? ?? ?? 30 23 9F E5 30 33 9F E5 10 00 8D E5 14 10 8D E5 ?? ?? ?? ?? 05 20 A0 E1 18 00 8D E5 1C 10 8D E5 03 00 9D E8 06 30 A0 E1 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? 00 23 9F E5 00 40 A0 E1 01 50 A0 E1 F8 32 9F E5 10 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 08 30 8D E2 0C 00 93 E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 03 00 9D E8 ?? ?? ?? ?? 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 18 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 70 A0 E1 01 80 A0 E1 04 00 00 EA 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 00 70 A0 E1 01 80 A0 E1 07 00 A0 E1 08 10 A0 E1 20 D0 8D E2 F0 8D BD E8 07 20 A0 E1 08 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 00 70 A0 E1 01 80 A0 E1 F0 FF FF EA 00 20 A0 E3 7C 32 9F E5 ?? ?? ?? ?? 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 6C 22 9F E5 00 00 50 E3 00 30 A0 E3 01 30 A0 C3 02 00 54 E1 00 40 A0 C3 01 40 03 D2 00 00 54 E3 E1 FF FF 1A 07 20 A0 E1 08 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E3 34 32 9F E5 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 70 A0 E1 01 80 A0 E1 D1 FF FF EA FF B5 87 E3 02 B6 8B E3 01 76 67 E2 01 40 84 E2 0A 00 A0 E1 0B 10 A0 E1 47 71 A0 E1 15 FF FF EA 41 4A A0 E1 FF 4F 44 E2 00 20 A0 E3 00 30 A0 E3 01 50 A0 E1 03 40 44 E2 00 A0 A0 E1 08 20 8D E5 0C 30 8D E5 02 FF FF EA C8 21 9F E5 C8 31 9F E5 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E3 48 31 9F E5 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? 00 00 54 E3 00 70 A0 E1 01 80 A0 E1 1A 00 00 1A 07 20 A0 E1 08 30 A0 E1 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 00 70 A0 E1 01 80 A0 E1 A8 FF FF EA 00 20 A0 E1 01 30 A0 E1 03 00 9D E8 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 03 00 9D E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 70 A0 E1 01 80 A0 E1 95 FF FF EA 04 00 A0 E1 ?? ?? ?? ?? BC 20 9F E5 BC 30 9F E5 00 A0 A0 E1 01 B0 A0 E1 ?? ?? ?? ?? B0 20 9F E5 03 00 8D E8 AC 30 9F E5 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 08 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 03 00 9D E8 ?? ?? ?? ?? 00 70 A0 E1 01 80 A0 E1 74 FF FF EA 00 20 A0 E3 30 30 9F E5 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? A9 FE FF EA 79 82 DA 3F FF FF EF 3F 00 00 F0 BF 00 00 50 C3 FF FF EF 7F FF FF 3F 43 00 00 F0 3F 9D A0 06 00 00 00 E0 3F 00 00 E0 FE 42 2E E6 3F 76 3C 79 35 EF 39 EA 3D FF FF 1F 3E 3C 41 2D 40 44 52 3E DF 12 F1 C2 3F 9F C6 78 D0 09 9A C3 3F DE 03 CB 96 64 46 C7 3F AF 78 8E 1D C5 71 CC 3F 59 93 22 94 24 49 D2 3F 04 FA 97 99 99 99 D9 3F 93 55 55 55 55 55 E5 3F 00 00 50 43 FF FF 8F 3C 00 00 E0 BF 55 55 55 55 55 55 E5 BF }
	condition:
		$1
}

rule file_131_0_2 {
	meta:
		name = "__stat_by_file_info"
		size = 312
		refs = "0098 __FILETIME_to_time_t 00e8 FileTimeToSystemTime 0104 SystemTimeToFileTime"
	strings:
		$1 = { F0 41 2D E9 01 40 A0 E1 04 30 A0 E1 00 10 A0 E3 04 10 83 E4 04 30 83 E2 04 10 84 E5 04 10 83 E4 04 10 83 E4 04 10 83 E4 04 10 83 E4 04 10 83 E4 00 10 83 E5 1C 30 90 E5 02 19 A0 E3 10 30 84 E5 00 30 90 E5 18 D0 4D E2 10 00 13 E3 00 50 A0 E1 B4 10 C4 E1 32 00 00 0A D4 10 9F E5 01 2C A0 E3 B4 10 C4 E1 01 00 13 E3 80 20 82 03 01 10 82 E1 C2 11 81 E1 01 30 A0 E3 42 23 81 E1 04 80 85 E2 B6 30 C4 E1 BC 30 C4 E1 00 30 A0 E3 B2 30 C4 E1 B4 20 C4 E1 08 00 A0 E1 ?? ?? ?? ?? 18 00 84 E5 0C 00 85 E2 ?? ?? ?? ?? 1C 00 84 E5 14 00 85 E2 ?? ?? ?? ?? 1C 30 94 E5 00 50 A0 E1 00 00 53 E3 18 30 94 05 14 00 84 E5 1C 30 84 05 00 00 50 E3 10 00 00 1A 10 60 8D E2 03 00 98 E8 03 00 86 E8 0D 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 06 10 A0 E1 0D 00 A0 E1 BE 50 CD E1 B8 50 CD E1 BA 50 CD E1 BC 50 CD E1 ?? ?? ?? ?? 06 00 A0 E1 ?? ?? ?? ?? 0D 70 A0 E1 14 00 84 E5 00 00 A0 E3 18 D0 8D E2 F0 81 BD E8 00 00 52 E3 01 2C A0 03 05 2D A0 13 CB FF FF EA 40 40 00 00 }
	condition:
		$1
}

rule file_131_1_2 {
	meta:
		name = "_stat"
		size = 276
		refs = "0024 mbstowcs 0034 FindFirstFileW 0094 strlen 00bc FindClose 00dc _stricmp 00f0 GetLastError 0104 SetLastError 0110 .rdata"
	strings:
		$1 = { F0 40 2D E9 45 DE 4D E2 0C D0 4D E2 23 5E 8D E2 41 2F A0 E3 00 40 A0 E1 01 60 A0 E1 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 0C 10 8D E2 05 00 A0 E1 0C 10 41 E2 ?? ?? ?? ?? 01 00 70 E3 00 50 A0 E1 2A 00 00 0A 1C 10 8D E2 0C 30 8D E2 08 30 43 E2 08 10 41 E2 11 7D 8D E2 03 00 91 E8 03 00 87 E8 03 00 93 E8 00 30 9D E5 11 ED 8D E2 08 E0 8E E2 45 2E 8D E2 0C C0 8D E2 3C 34 8D E5 20 30 9D E5 03 00 8E E8 03 00 9C E8 03 00 82 E8 04 00 A0 E1 58 34 8D E5 ?? ?? ?? ?? 03 00 50 E3 0B 00 00 8A 00 20 A0 E3 43 0E 8D E2 06 10 A0 E1 0C 00 80 E2 84 FF FF EB 00 40 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 5C D0 8D E2 01 DB 8D E2 F0 80 BD E8 04 00 40 E2 00 00 84 E0 30 10 9F E5 ?? ?? ?? ?? 00 00 50 E3 01 20 A0 03 ED FF FF 0A EB FF FF EA ?? ?? ?? ?? 12 00 50 E3 05 40 A0 11 EF FF FF 1A 02 00 A0 E3 ?? ?? ?? ?? 05 40 A0 E1 EB FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_131_3_2 {
	meta:
		name = "_fstat"
		size = 108
		refs = "0010 GetFileInformationByHandle"
	strings:
		$1 = { 30 40 2D E9 54 D0 4D E2 01 40 A0 E1 0D 10 A0 E1 ?? ?? ?? ?? 38 50 8D E2 48 30 8D E2 0C 20 8D E2 14 10 8D E2 40 C0 8D E2 04 E0 8D E2 03 00 91 E8 03 00 85 E8 03 00 9E E8 03 00 8C E8 03 00 92 E8 03 00 83 E8 00 30 9D E5 04 10 A0 E1 34 30 8D E5 24 30 9D E5 34 00 8D E2 00 20 A0 E3 50 30 8D E5 52 FF FF EB 54 D0 8D E2 30 80 BD E8 }
	condition:
		$1
}

rule file_132_0_2 {
	meta:
		name = "_futime"
		size = 120
		refs = "0024 __time_t_to_FILETIME 0044 SetFileTime 0060 time"
	strings:
		$1 = { F0 40 2D E9 00 50 51 E2 1C D0 4D E2 00 70 A0 E1 11 00 00 0A 08 60 8D E2 00 00 95 E5 06 10 A0 E1 10 40 8D E2 ?? ?? ?? ?? 04 00 95 E5 04 10 A0 E1 ?? ?? ?? ?? 07 00 A0 E1 06 20 A0 E1 04 30 A0 E1 00 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 00 00 E0 03 00 00 A0 13 1C D0 8D E2 F0 80 BD E8 18 00 8D E2 ?? ?? ?? ?? 18 30 9D E5 1C 50 8D E2 1C 30 25 E5 04 30 8D E5 E6 FF FF EA }
	condition:
		$1
}

rule file_135_0_2 {
	meta:
		name = "__kernel_cos"
		size = 812
		refs = "002c __fixdfsi 0050 __muldf3 0070 __adddf3 0088 __subdf3"
	strings:
		$1 = { F0 4D 2D E9 02 61 C1 E3 F9 05 56 E3 18 D0 4D E2 00 70 A0 E1 01 80 A0 E1 00 40 A0 E1 01 50 A0 E1 02 A0 A0 E1 03 B0 A0 E1 50 00 00 AA ?? ?? ?? ?? 00 00 50 E3 00 00 A0 03 A8 12 9F 05 49 00 00 0A 07 20 A0 E1 08 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 90 22 9F E5 90 32 9F E5 00 40 A0 E1 01 50 A0 E1 ?? ?? ?? ?? 84 22 9F E5 84 32 9F E5 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 74 22 9F E5 74 32 9F E5 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 64 22 9F E5 64 32 9F E5 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 54 22 9F E5 54 32 9F E5 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 44 22 9F E5 44 32 9F E5 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 08 00 8D E5 0C 10 8D E5 04 00 A0 E1 05 10 A0 E1 00 20 A0 E3 20 32 9F E5 ?? ?? ?? ?? 08 30 8D E2 0C 00 93 E8 03 00 8D E8 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 0A 20 A0 E1 00 40 A0 E1 01 50 A0 E1 0B 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 03 00 9D E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 00 00 A0 E3 80 11 9F E5 ?? ?? ?? ?? 18 D0 8D E2 F0 8D BD E8 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 68 21 9F E5 68 31 9F E5 00 40 A0 E1 01 50 A0 E1 ?? ?? ?? ?? 5C 21 9F E5 5C 31 9F E5 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 4C 21 9F E5 4C 31 9F E5 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 3C 21 9F E5 3C 31 9F E5 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 2C 21 9F E5 2C 31 9F E5 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 1C 21 9F E5 1C 31 9F E5 ?? ?? ?? ?? 05 30 A0 E1 04 20 A0 E1 ?? ?? ?? ?? 10 31 9F E5 08 00 8D E5 0C 10 8D E5 03 00 56 E1 B2 FF FF DA 00 31 9F E5 03 00 56 E1 2B 00 00 DA F8 30 9F E5 00 20 A0 E3 0C 00 8D E8 0C 00 9D E8 00 00 A0 E3 A4 10 9F E5 ?? ?? ?? ?? 00 20 A0 E3 10 00 8D E5 14 10 8D E5 C4 30 9F E5 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 0C 00 9D E8 ?? ?? ?? ?? 08 30 8D E2 0C 00 93 E8 03 00 8D E8 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 0A 20 A0 E1 00 40 A0 E1 01 50 A0 E1 0B 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 03 00 9D E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 10 10 8D E2 03 00 91 E8 ?? ?? ?? ?? A3 FF FF EA 02 36 46 E2 00 20 A0 E3 0C 00 8D E8 D2 FF FF EA 00 00 F0 3F D4 38 88 BE E9 FA A8 BD C4 B1 B4 BD 9E EE 21 3E AD 52 9C 80 4F 7E 92 3E 90 15 CB 19 A0 01 FA 3E 77 51 C1 16 6C C1 56 3F 4C 55 55 55 55 55 A5 3F 00 00 E0 3F 32 33 D3 3F 00 00 E9 3F 00 00 D2 3F }
	condition:
		$1
}

rule file_136_0_2 {
	meta:
		name = "__ieee754_acosf"
		size = 956
		refs = "0030 __mulsf3 0044 __addsf3 0054 __subsf3 00e0 __divsf3 015c sqrtf"
	strings:
		$1 = { 02 31 C0 E3 FE 05 53 E3 F0 40 2D E9 00 40 A0 E1 45 00 00 0A 3F 00 00 CA 3F 04 53 E3 46 00 00 AA 23 04 53 E3 54 03 9F D5 F0 80 BD D8 04 10 A0 E1 ?? ?? ?? ?? 48 13 9F E5 00 50 A0 E1 ?? ?? ?? ?? 40 13 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 34 13 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 28 13 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 1C 13 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 10 13 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 04 13 9F E5 00 60 A0 E1 05 00 A0 E1 ?? ?? ?? ?? F8 12 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? EC 12 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? E0 12 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 B0 02 9F E5 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 9C 02 9F E5 ?? ?? ?? ?? F0 80 BD E8 00 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 ?? ?? ?? ?? F0 80 BD E8 00 00 50 E3 7C 02 9F D5 00 00 A0 C3 F0 80 BD E8 00 00 50 E3 4E 00 00 BA 00 10 A0 E1 FE 05 A0 E3 ?? ?? ?? ?? 3F 14 A0 E3 ?? ?? ?? ?? 00 40 A0 E1 ?? ?? ?? ?? 1C 12 9F E5 00 60 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 10 12 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 04 12 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? F8 11 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? EC 11 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? E0 11 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? D4 11 9F E5 00 50 A0 E1 04 00 A0 E1 ?? ?? ?? ?? C8 11 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? BC 11 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? B0 11 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? FF 5E C6 E3 0F 50 C5 E3 00 70 A0 E1 05 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 00 40 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 ?? ?? ?? ?? F0 80 BD E8 FE 15 A0 E3 ?? ?? ?? ?? 3F 14 A0 E3 ?? ?? ?? ?? 00 40 A0 E1 ?? ?? ?? ?? E4 10 9F E5 00 50 A0 E1 04 00 A0 E1 ?? ?? ?? ?? D8 10 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? CC 10 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? C0 10 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? B4 10 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? A8 10 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 9C 10 9F E5 00 60 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 90 10 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 84 10 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 78 10 9F E5 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 4C 10 9F E5 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 03 11 A0 E3 ?? ?? ?? ?? 3C 10 9F E5 ?? ?? ?? ?? F0 80 BD E8 DB 0F C9 3F 08 EF 11 38 04 7F 4F 3A 46 11 24 3D A8 0A 4E 3E 90 B0 A6 3E AB AA 2A 3E 2E C6 9D 3D 61 33 30 3F 2D 57 01 40 39 D1 19 40 68 21 A2 33 DA 0F C9 3F DB 0F 49 40 DA 0F 49 40 }
	condition:
		$1
}

rule file_137_1_2 {
	meta:
		name = "wcrtomb"
		size = 52
		refs = "0018 __mb_cur_max"
	strings:
		$1 = { 30 40 2D E9 01 18 A0 E1 00 50 50 E2 04 D0 4D E2 21 48 A0 E1 0D 50 A0 01 ?? ?? ?? ?? 04 10 A0 E1 00 20 A0 E1 05 00 A0 E1 ED FF FF EB 04 D0 8D E2 30 80 BD E8 }
	condition:
		$1
}

rule file_137_2_2 {
	meta:
		name = "wcsrtombs"
		size = 264
		refs = "0014 __mb_cur_max"
	strings:
		$1 = { F0 45 2D E9 04 D0 4D E2 01 A0 A0 E1 00 40 A0 E1 02 70 A0 E1 ?? ?? ?? ?? 00 60 9A E5 00 80 A0 E1 00 00 56 E3 06 50 A0 01 15 00 00 0A 00 00 54 E3 1B 00 00 0A 00 00 57 E3 07 50 A0 01 13 00 00 0A 00 50 A0 E3 06 00 00 EA D1 30 54 E1 00 50 85 E0 00 00 53 E3 0F 00 00 0A 05 00 57 E1 02 60 86 E2 0A 00 00 9A 04 00 A0 E1 B0 10 D6 E1 08 20 A0 E1 CE FF FF EB 00 00 50 E3 00 40 84 E0 F1 FF FF CA 00 50 E0 E3 05 00 A0 E1 04 D0 8D E2 F0 85 BD E8 00 60 8A E5 FA FF FF EA 00 30 8A E5 01 50 45 E2 F7 FF FF EA 00 00 57 E3 07 50 A0 01 F4 FF FF 0A 04 50 A0 E1 0D A0 A0 E1 06 00 00 EA D5 30 53 E1 00 50 85 E0 00 00 53 E3 0C 00 00 0A 05 00 57 E1 02 40 84 E2 EA FF FF 9A 08 20 A0 E1 B4 10 96 E1 0D 00 A0 E1 B1 FF FF EB 04 20 8D E2 00 00 50 E3 00 30 82 E0 F0 FF FF CA 00 50 E0 E3 E0 FF FF EA 01 50 45 E2 DE FF FF EA }
	condition:
		$1
}

rule file_139_0_2 {
	meta:
		name = "hexdig_init_D2A"
		size = 132
		refs = "0074 .rdata 0078 __hexdig_D2A"
	strings:
		$1 = { 6C 00 9F E5 6C 10 9F E5 30 20 A0 E3 10 30 A0 E3 02 30 C1 E7 01 20 F0 E5 01 30 83 E2 00 00 52 E3 FF 30 03 E2 F9 FF FF 1A 4C 00 9F E5 61 20 A0 E3 1A 30 A0 E3 02 30 C1 E7 01 20 F0 E5 01 30 83 E2 00 00 52 E3 FF 30 03 E2 F9 FF FF 1A 2C 00 9F E5 41 20 A0 E3 1A 30 A0 E3 02 30 C1 E7 01 20 F0 E5 01 30 83 E2 00 00 52 E3 FF 30 03 E2 F9 FF FF 1A 0E F0 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_140_0_2 {
	meta:
		name = "llrintf"
		size = 260
		refs = "004c __addsf3 005c __subsf3 0100 .rdata"
	strings:
		$1 = { 30 40 2D E9 A0 4B A0 E1 FF 30 04 E2 7F 30 43 E2 01 00 73 E3 04 D0 4D E2 00 20 A0 B3 00 30 A0 B3 1F 00 00 BA 3E 00 53 E3 44 44 A0 E1 20 00 00 CA 16 00 53 E3 0B 00 00 CA C0 30 9F E5 00 00 8D E5 04 51 93 E7 00 10 9D E5 05 00 A0 E1 ?? ?? ?? ?? 00 00 8D E5 00 00 9D E5 05 10 A0 E1 ?? ?? ?? ?? 00 00 8D E5 00 00 9D E5 A0 1B A0 E1 FF 10 01 E2 FF 04 C0 E3 02 05 C0 E3 96 C0 51 E2 02 05 80 E3 17 00 00 4A 1F 00 5C E3 0F 00 00 DA 00 20 A0 E3 00 30 A0 E3 00 00 54 E3 01 00 00 0A 00 20 72 E2 00 30 E3 E2 03 10 A0 E1 02 00 A0 E1 04 D0 8D E2 30 80 BD E8 00 00 54 E3 00 20 E0 03 02 31 E0 03 00 20 A0 13 02 31 A0 13 F5 FF FF EA 20 50 6C E2 30 35 A0 E1 B6 10 51 E2 10 31 A0 51 10 2C A0 E1 EB FF FF EA 1F 00 7C E3 00 C0 6C A2 30 0C A0 A1 00 20 A0 A1 00 30 A0 A3 E5 FF FF AA E2 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_141_0_2 {
	meta:
		name = "tgamma"
		size = 40
		refs = "000c __ieee754_gamma_r"
	strings:
		$1 = { 10 40 2D E9 04 D0 4D E2 0D 20 A0 E1 ?? ?? ?? ?? 00 30 9D E5 00 00 53 E3 02 11 81 B2 01 40 A0 E1 04 D0 8D E2 10 80 BD E8 }
	condition:
		$1
}

rule file_142_0_2 {
	meta:
		name = "__kernel_sin"
		size = 532
		refs = "002c __fixdfsi 0048 __muldf3 0084 __subdf3 009c __adddf3"
	strings:
		$1 = { F0 4F 2D E9 02 C1 C1 E3 F9 05 5C E3 10 D0 4D E2 00 40 A0 E1 01 50 A0 E1 00 60 A0 E1 01 70 A0 E1 02 A0 A0 E1 03 B0 A0 E1 02 00 00 AA ?? ?? ?? ?? 00 00 50 E3 52 00 00 0A 04 20 A0 E1 05 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 00 60 A0 E1 01 70 A0 E1 ?? ?? ?? ?? 78 21 9F E5 78 31 9F E5 00 80 A0 E1 01 90 A0 E1 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 64 21 9F E5 64 31 9F E5 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? 54 21 9F E5 54 31 9F E5 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? 44 21 9F E5 44 31 9F E5 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? 34 31 9F E5 34 21 9F E5 ?? ?? ?? ?? 34 30 9D E5 03 00 8D E8 00 00 53 E3 2C 00 00 0A 00 20 A0 E3 1C 31 9F E5 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 0C 00 9D E8 08 00 8D E5 0C 10 8D E5 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 08 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? CC 20 9F E5 00 60 A0 E1 01 70 A0 E1 C4 30 9F E5 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 04 00 A0 E1 05 10 A0 E1 10 D0 8D E2 F0 8F BD E8 00 20 A0 E1 01 30 A0 E1 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 5C 20 9F E5 5C 30 9F E5 ?? ?? ?? ?? 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 E8 FF FF EA 7C D5 CF 5A 3A D9 E5 3D EB 9C 2B 8A E6 E5 5A 3E 7D FE B1 57 E3 1D C7 3E D5 61 C1 19 A0 01 2A 3F 11 11 81 3F A6 F8 10 11 00 00 E0 3F 49 55 55 55 55 55 C5 3F }
	condition:
		$1
}

rule file_143_0_2 {
	meta:
		name = "llroundf"
		size = 256
		refs = "0048 __extendsfdf2 0054 __adddf3 0058 __truncdfsf2"
	strings:
		$1 = { 70 40 2D E9 A0 4B A0 E1 FF 30 04 E2 7F 30 43 E2 01 00 73 E3 00 20 A0 B3 00 30 A0 B3 1D 00 00 BA 3E 00 53 E3 44 44 A0 E1 1D 00 00 CA 16 00 53 E3 09 00 00 CA 00 00 54 E3 B8 60 9F 05 B8 60 9F 15 00 50 A0 03 00 50 A0 13 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? A0 1B A0 E1 FF 10 01 E2 FF 04 C0 E3 02 05 C0 E3 96 C0 51 E2 02 05 80 E3 18 00 00 4A 1F 00 5C E3 10 00 00 DA 00 20 A0 E3 00 30 A0 E3 00 00 54 E3 01 00 00 0A 00 20 72 E2 00 30 E3 E2 03 10 A0 E1 02 00 A0 E1 70 80 BD E8 00 00 54 E3 00 20 E0 03 02 31 E0 03 00 20 A0 13 02 31 A0 13 03 10 A0 E1 02 00 A0 E1 70 80 BD E8 20 50 6C E2 30 35 A0 E1 B6 10 51 E2 10 31 A0 51 10 2C A0 E1 EA FF FF EA 1F 00 7C E3 00 C0 6C A2 30 0C A0 A1 00 20 A0 A1 00 30 A0 A3 E4 FF FF AA E1 FF FF EA 00 00 E0 3F 00 00 E0 BF }
	condition:
		$1
}

rule file_144_0_2 {
	meta:
		name = "__fpclassifyf"
		size = 88
	strings:
		$1 = { 4C 30 9F E5 20 28 A0 E1 03 30 02 E0 00 00 53 E3 05 00 00 1A FF 04 C0 E3 02 05 C0 E3 00 00 50 E3 01 09 A0 03 11 0B A0 13 0E F0 A0 E1 20 20 9F E5 02 00 53 E1 01 0B A0 13 0E F0 A0 11 FF 04 C0 E3 02 05 C0 E3 00 00 50 E3 05 0C A0 03 01 0C A0 13 0E F0 A0 E1 80 7F 00 00 }
	condition:
		$1
}

rule file_144_1_2 {
	meta:
		name = "__fpclassify"
		size = 96
	strings:
		$1 = { 01 20 A0 E1 50 30 9F E5 00 10 A0 E1 22 08 A0 E1 03 30 00 E0 00 00 53 E3 05 00 00 1A FF 34 C2 E3 0F 36 C3 E3 01 30 93 E1 01 09 A0 03 11 0B A0 13 0E F0 A0 E1 20 00 9F E5 00 00 53 E1 01 0B A0 13 0E F0 A0 11 FF 34 C2 E3 0F 36 C3 E3 01 30 93 E1 05 0C A0 03 01 0C A0 13 0E F0 A0 E1 F0 7F 00 00 }
	condition:
		$1
}

rule file_144_2_2 {
	meta:
		name = "__fpclassifyl"
		size = 56
	strings:
		$1 = { 01 20 A0 E1 02 31 C2 E3 23 3A A0 E1 03 3A A0 E1 00 00 53 E3 00 10 A0 E1 01 0B A0 13 0E F0 A0 11 FF 34 C2 E3 0F 36 C3 E3 01 30 93 E1 01 09 A0 03 11 0B A0 13 0E F0 A0 E1 }
	condition:
		$1
}

rule file_145_0_2 {
	meta:
		name = "__ieee754_acosh"
		size = 412
		refs = "0040 __adddf3 0070 __subdf3 00a0 __muldf3 00b8 sqrt 00cc log1p 00e4 __divdf3 00ec log"
	strings:
		$1 = { 7C 21 9F E5 F0 43 2D E9 02 00 51 E1 00 40 A0 E1 01 50 A0 E1 00 60 A0 E1 01 70 A0 E1 2B 00 00 DA 60 21 9F E5 02 00 51 E1 06 00 00 DA F9 25 82 E2 02 00 51 E1 2C 00 00 DA 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? F0 83 BD E8 03 21 81 E2 01 26 82 E2 00 20 92 E1 00 00 A0 03 00 10 A0 03 F0 83 BD 08 01 01 55 E3 25 00 00 CA 00 20 A0 E3 18 31 9F E5 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 00 40 A0 E1 01 50 A0 E1 ?? ?? ?? ?? 04 20 A0 E1 00 60 A0 E1 01 70 A0 E1 05 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? F0 43 BD E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? F0 83 BD E8 ?? ?? ?? ?? 98 20 9F E5 98 30 9F E5 ?? ?? ?? ?? F0 83 BD E8 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E3 74 30 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? 04 20 A0 E1 00 60 A0 E1 01 70 A0 E1 05 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 04 20 A0 E1 00 80 A0 E1 01 90 A0 E1 05 30 A0 E1 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 00 00 A0 E3 30 10 9F E5 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? F0 43 BD E8 ?? ?? ?? ?? FF FF EF 3F FF FF AF 41 00 00 F0 3F EF 39 FA FE 42 2E E6 3F 00 00 F0 BF }
	condition:
		$1
}

rule file_146_0_2 {
	meta:
		name = "modff"
		size = 112
		refs = "004c __subsf3"
	strings:
		$1 = { C0 CB A0 E1 FF C0 0C E2 7F C0 4C E2 16 00 5C E3 10 40 2D E9 00 30 A0 E1 00 20 A0 E1 0E 00 00 CA 00 00 5C E3 02 21 00 B2 00 20 81 B5 08 00 00 BA 34 40 9F E5 54 CC A0 E1 02 00 1C E1 06 00 00 0A 0C C0 C2 E1 00 C0 81 E5 0C 10 A0 E1 ?? ?? ?? ?? 00 30 A0 E1 03 00 A0 E1 10 80 BD E8 00 30 81 E5 02 31 02 E2 03 00 A0 E1 10 80 BD E8 FF FF 7F 00 }
	condition:
		$1
}

rule file_148_0_2 {
	meta:
		name = "vsnprintf"
		size = 104
		refs = "0030 __mingw_pformat"
	strings:
		$1 = { 30 40 2D E9 00 00 51 E3 04 D0 4D E2 00 40 A0 E1 03 C0 A0 E1 0C 00 00 0A 01 50 41 E2 02 30 A0 E1 00 00 A0 E3 05 20 A0 E1 04 10 A0 E1 00 C0 8D E5 ?? ?? ?? ?? 00 30 A0 E3 05 00 50 E1 00 50 A0 31 05 30 C4 E7 04 D0 8D E2 30 80 BD E8 01 00 A0 E1 02 30 A0 E1 04 10 A0 E1 00 20 A0 E1 00 C0 8D E5 ?? ?? ?? ?? F6 FF FF EA }
	condition:
		$1
}

rule file_149_0_2 {
	meta:
		name = "__ieee754_rem_pio2f"
		size = 1096
		refs = "0038 __subsf3 00a4 __fixsfsi 00a8 __floatsisf 00c4 __mulsf3 00f8 __eqsf2 0150 __kernel_rem_pio2f 01b0 __addsf3 0428 .rdata"
	strings:
		$1 = { F0 4F 2D E9 FC 23 9F E5 02 61 C0 E3 02 00 56 E1 14 D0 4D E2 00 50 A0 E1 01 40 A0 E1 57 00 00 DA E4 23 9F E5 02 00 56 E1 13 00 00 CA 00 00 50 E3 CE 00 00 DA D4 13 9F E5 ?? ?? ?? ?? D0 33 9F E5 3E 51 C5 E3 03 00 55 E1 00 60 A0 E1 7A 00 00 0A C0 13 9F E5 ?? ?? ?? ?? 00 10 A0 E1 00 00 84 E5 06 00 A0 E1 ?? ?? ?? ?? A8 13 9F E5 ?? ?? ?? ?? 01 70 A0 E3 04 00 84 E5 44 00 00 EA 98 23 9F E5 02 00 56 E1 44 00 00 DA 90 23 9F E5 02 00 56 E1 C8 00 00 CA C6 8B A0 E1 86 80 48 E2 88 6B 46 E0 06 00 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 00 30 A0 E1 00 10 A0 E1 06 00 A0 E1 08 30 8D E5 ?? ?? ?? ?? 5C 13 9F E5 ?? ?? ?? ?? 00 60 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 00 30 A0 E1 00 10 A0 E1 06 00 A0 E1 0C 30 8D E5 ?? ?? ?? ?? 34 13 9F E5 ?? ?? ?? ?? 00 10 A0 E3 10 00 8D E5 ?? ?? ?? ?? 08 A0 8D E2 04 70 8A E2 00 00 50 E3 03 60 A0 E3 04 70 47 E2 06 00 00 1A 04 00 97 E5 00 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 01 60 46 E2 04 70 47 E2 F8 FF FF 0A 02 C0 A0 E3 00 C0 8D E5 E8 C2 9F E5 0A 00 A0 E1 08 20 A0 E1 06 30 A0 E1 04 10 A0 E1 04 C0 8D E5 ?? ?? ?? ?? 00 00 55 E3 00 70 A0 E1 0B 00 00 AA 00 30 94 E5 04 20 94 E5 02 31 83 E2 02 21 82 E2 04 20 84 E5 00 30 84 E5 00 70 67 E2 03 00 00 EA 00 30 A0 E3 00 00 84 E5 00 70 A0 E3 04 30 81 E5 07 00 A0 E1 14 D0 8D E2 F0 8F BD E8 02 81 C0 E3 84 12 9F E5 08 00 A0 E1 ?? ?? ?? ?? 3F 14 A0 E3 ?? ?? ?? ?? ?? ?? ?? ?? 00 70 A0 E1 ?? ?? ?? ?? 68 12 9F E5 00 90 A0 E1 ?? ?? ?? ?? 08 10 A0 E1 ?? ?? ?? ?? 3C 12 9F E5 00 80 A0 E1 09 00 A0 E1 ?? ?? ?? ?? 1F 00 57 E3 00 A0 A0 E1 20 00 00 CA 3C 32 9F E5 01 20 47 E2 02 31 93 E7 FF 20 C6 E3 03 00 52 E1 1A 00 00 0A 0A 10 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 00 00 84 E5 08 00 A0 E1 ?? ?? ?? ?? 0A 10 A0 E1 ?? ?? ?? ?? 00 00 55 E3 04 00 84 E5 D5 FF FF AA C8 FF FF EA F4 11 9F E5 ?? ?? ?? ?? F0 11 9F E5 00 50 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 00 00 84 E5 05 00 A0 E1 ?? ?? ?? ?? D4 11 9F E5 ?? ?? ?? ?? 01 70 A0 E3 04 00 84 E5 C6 FF FF EA 0A 10 A0 E1 08 00 A0 E1 ?? ?? ?? ?? A0 3B A0 E1 C6 6B A0 E1 FF 30 03 E2 06 30 63 E0 08 00 53 E3 00 10 A0 E1 00 00 84 E5 DE FF FF DA 90 11 9F E5 09 00 A0 E1 ?? ?? ?? ?? 00 A0 A0 E1 0A 10 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 00 B0 A0 E1 0B 10 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 0A 10 A0 E1 ?? ?? ?? ?? 60 11 9F E5 00 80 A0 E1 09 00 A0 E1 ?? ?? ?? ?? 08 10 A0 E1 ?? ?? ?? ?? 00 A0 A0 E1 0A 10 A0 E1 0B 00 A0 E1 ?? ?? ?? ?? A0 3B A0 E1 FF 30 03 E2 06 60 63 E0 19 00 56 E3 00 10 A0 E1 00 00 84 E5 0B 80 A0 D1 BF FF FF DA 1C 11 9F E5 09 00 A0 E1 ?? ?? ?? ?? 00 60 A0 E1 06 10 A0 E1 0B 00 A0 E1 ?? ?? ?? ?? 00 80 A0 E1 08 10 A0 E1 0B 00 A0 E1 ?? ?? ?? ?? 06 10 A0 E1 ?? ?? ?? ?? EC 10 9F E5 00 60 A0 E1 09 00 A0 E1 ?? ?? ?? ?? 06 10 A0 E1 ?? ?? ?? ?? 00 A0 A0 E1 A5 FF FF EA 98 10 9F E5 ?? ?? ?? ?? 94 30 9F E5 3E 51 C5 E3 03 00 55 E1 00 60 A0 E1 10 00 00 0A 84 10 9F E5 ?? ?? ?? ?? 00 10 A0 E1 00 00 84 E5 06 00 A0 E1 ?? ?? ?? ?? 6C 10 9F E5 ?? ?? ?? ?? 00 70 E0 E3 04 00 84 E5 75 FF FF EA 00 10 A0 E1 ?? ?? ?? ?? 00 70 A0 E3 00 00 84 E5 04 00 84 E5 6F FF FF EA 60 10 9F E5 ?? ?? ?? ?? 5C 10 9F E5 00 50 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 00 00 84 E5 05 00 A0 E1 ?? ?? ?? ?? 40 10 9F E5 ?? ?? ?? ?? 00 70 E0 E3 04 00 84 E5 61 FF FF EA D8 0F 49 3F E3 CB 16 40 80 0F C9 3F D0 0F C9 3F 43 44 35 37 80 0F 49 43 FF FF 7F 7F 00 00 80 43 ?? ?? ?? ?? 84 F9 22 3F 80 0F C9 BF ?? ?? ?? ?? 00 44 35 37 08 A3 85 2E 00 A3 85 2E 32 31 8D 24 }
	condition:
		$1
}

rule file_150_0_2 {
	meta:
		name = "__tm_to_SYSTEMTIME"
		size = 80
	strings:
		$1 = { 14 30 90 E5 10 20 90 E5 76 3E 83 E2 0C 30 83 E2 B0 30 C1 E1 B0 30 D0 E1 01 20 82 E2 BC 30 C1 E1 00 30 A0 E3 BE 30 C1 E1 B8 31 D0 E1 B2 20 C1 E1 B4 30 C1 E1 BC 30 D0 E1 B6 30 C1 E1 B8 30 D0 E1 B4 00 D0 E1 B8 30 C1 E1 BA 00 C1 E1 0E F0 A0 E1 }
	condition:
		$1
}

rule file_150_1_2 {
	meta:
		name = "__FILETIME_to_time_t"
		size = 64
		refs = "002c __divdi3"
	strings:
		$1 = { 70 40 2D E9 11 00 90 E8 00 30 A0 E3 20 20 9F E5 00 50 83 E1 1C 30 9F E5 02 00 95 E0 03 10 A4 E0 14 20 9F E5 00 30 A0 E3 04 60 A0 E1 ?? ?? ?? ?? 70 80 BD E8 00 80 C1 2A 21 4E 62 FE 80 96 98 00 }
	condition:
		$1
}

rule file_150_2_2 {
	meta:
		name = "__time_t_to_FILETIME"
		size = 64
	strings:
		$1 = { 2C 30 9F E5 F0 08 2D E9 00 60 A0 E1 C6 7F A0 E1 93 46 85 E0 93 57 25 E0 18 B0 9F E5 18 C0 9F E5 04 B0 9B E0 05 C0 AC E0 00 18 81 E8 F0 08 BD E8 0E F0 A0 E1 80 96 98 00 00 80 3E D5 DE B1 9D 01 }
	condition:
		$1
}

rule file_150_3_2 {
	meta:
		name = "__SYSTEMTIME_to_tm"
		size = 208
		refs = "0068 SystemTimeToFileTime 00a0 __divdi3"
	strings:
		$1 = { 70 40 2D E9 B0 C0 D0 E1 B2 20 D0 E1 20 D0 4D E2 01 40 A0 E1 B4 E0 D0 E1 00 50 A0 E1 00 60 A0 E3 B6 00 D0 E1 76 3E 4C E2 01 10 42 E2 08 20 8D E2 04 60 82 E4 0C 30 43 E2 18 E0 84 E5 00 60 82 E5 14 30 84 E5 10 10 84 E5 01 30 A0 E3 0C 00 84 E5 18 10 8D E2 0D 00 A0 E1 B0 C0 CD E1 B6 30 CD E1 B2 30 CD E1 B4 30 CD E1 ?? ?? ?? ?? 10 10 8D E2 05 00 A0 E1 ?? ?? ?? ?? 10 C0 9D E5 1C 30 9D E5 0C 00 86 E1 18 C0 9D E5 14 10 9D E5 0C 20 86 E1 02 00 50 E0 03 10 C1 E0 2C 20 9F E5 C9 30 A0 E3 ?? ?? ?? ?? BC 30 D5 E1 B8 10 D5 E1 BA 20 D5 E1 20 60 84 E5 1C 00 84 E5 08 10 84 E5 04 20 84 E5 00 30 84 E5 20 D0 8D E2 70 80 BD E8 00 C0 69 2A }
	condition:
		$1
}

rule file_151_0_2 {
	meta:
		name = "__kernel_rem_pio2"
		size = 2960
		refs = "0030 __divsi3 0098 __floatsidf 0108 __muldf3 011c __adddf3 01c0 __fixdfsi 0224 scalbn 023c floor 0284 __subdf3 03a0 __eqdf2 05cc __gedf2 0764 .text 0b70 .rdata"
	strings:
		$1 = { F0 4F 2D E9 99 DF 4D E2 02 40 A0 E1 20 30 8D E5 00 80 A0 E1 54 3B 9F E5 03 00 42 E2 88 22 9D E5 18 10 8D E5 02 31 93 E7 18 10 A0 E3 1C 30 8D E5 ?? ?? ?? ?? 20 30 9D E5 C0 0F C0 E1 01 30 43 E2 0C 30 8D E5 18 20 A0 E3 00 30 E0 E1 92 43 23 E0 28 00 8D E5 1C E0 9D E5 0C 00 9D E5 14 30 8D E5 00 70 9E E0 10 00 00 4A 28 10 9D E5 8C 22 9D E5 01 40 60 E0 07 70 84 E0 5D 6F 8D E2 04 51 82 E0 00 00 00 EA 01 40 84 E2 00 00 54 E3 00 00 A0 B3 00 10 A0 B3 00 00 95 A5 ?? ?? ?? ?? 07 00 54 E1 03 00 A6 E8 04 50 85 E2 F5 FF FF 1A 1C 30 9D E5 00 00 53 E3 24 00 00 BA 20 E0 9D E5 20 00 9D E5 0E E0 83 E0 0C 90 9D E5 34 B0 8D E2 04 E0 8D E5 80 A1 A0 E1 0C 20 9D E5 00 00 52 E3 00 60 A0 B3 00 70 A0 B3 13 00 00 BA 5D 3F 8D E2 89 51 83 E0 00 40 A0 E3 00 60 A0 E3 00 70 A0 E3 04 30 88 E0 03 00 93 E8 0C 00 95 E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 08 40 84 E2 0A 00 54 E1 00 60 A0 E1 01 70 A0 E1 08 50 45 E2 F0 FF FF 1A 04 10 9D E5 01 90 89 E2 01 00 59 E1 C0 00 AB E8 E1 FF FF 1A 1C E0 9D E5 99 0F 8D E2 01 30 4E E2 03 31 80 E0 85 1F 8D E2 50 30 43 E2 0E 11 81 E0 30 30 8D E5 0E 70 A0 E1 2C 10 8D E5 04 E0 8D E5 04 20 9D E5 04 30 9D E5 82 21 A0 E1 99 EF 8D E2 08 20 8D E5 00 00 53 E3 02 30 8E E0 2C 42 13 E5 30 52 13 E5 1D 00 00 DA 34 90 8D E2 02 60 89 E0 00 70 A0 E3 00 20 A0 E3 BC 39 9F E5 05 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 20 A0 E3 A4 39 9F E5 00 A0 A0 E1 01 B0 A0 E1 ?? ?? ?? ?? 05 20 A0 E1 04 30 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 0C 00 36 E9 85 1F 8D E2 07 00 81 E7 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 09 00 56 E1 00 50 A0 E1 01 40 A0 E1 04 70 87 E2 E4 FF FF 1A 05 00 A0 E1 04 10 A0 E1 14 20 9D E5 ?? ?? ?? ?? 00 20 A0 E3 FF 35 A0 E3 00 40 A0 E1 01 50 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 00 20 A0 E3 30 39 9F E5 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 01 50 A0 E1 00 40 A0 E1 ?? ?? ?? ?? 00 A0 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 14 20 9D E5 00 50 A0 E1 00 00 52 E3 01 60 A0 E1 B9 00 00 DA 04 30 9D E5 99 EF 8D E2 01 10 43 E2 01 11 8E E0 50 00 11 E5 18 20 62 E2 50 32 A0 E1 13 22 40 E0 14 00 9D E5 50 20 01 E5 17 70 60 E2 52 77 A0 E1 03 A0 8A E0 00 00 57 E3 2D 00 00 DA 04 30 9D E5 01 A0 8A E2 00 00 53 E3 00 40 A0 D3 17 00 00 DA 04 E0 9D E5 00 30 A0 E3 0E 11 A0 E1 03 40 A0 E1 06 00 00 EA 00 00 52 E3 01 24 62 12 03 20 80 17 04 30 83 E2 01 40 A0 13 01 00 53 E1 0B 00 00 0A 85 0F 8D E2 00 00 54 E3 03 20 90 E7 F4 FF FF 0A FF 04 E0 E3 00 00 62 E0 85 2F 8D E2 03 00 82 E7 04 30 83 E2 01 00 53 E1 01 40 A0 E3 F3 FF FF 1A 14 30 9D E5 00 00 53 E3 0B 00 00 DA 01 00 53 E3 8F 00 00 0A 02 00 53 E3 07 00 00 1A 04 10 9D E5 99 3F 8D E2 01 20 41 E2 02 21 83 E0 50 30 12 E5 FF 34 C3 E3 03 35 C3 E3 50 30 02 E5 02 00 57 E3 67 00 00 0A 05 00 A0 E1 06 10 A0 E1 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 AD 01 00 1A 04 E0 9D E5 1C 10 9D E5 01 00 4E E2 00 00 51 E1 09 00 00 CA 85 2F 8D E2 2C C0 9D E5 0E 31 82 E0 00 20 A0 E3 04 10 33 E5 0C 00 53 E1 01 20 82 E1 FB FF FF 1A 00 00 52 E3 7E 00 00 1A 30 E0 9D E5 00 30 9E E5 00 00 53 E3 01 20 A0 13 06 00 00 1A 2C 30 9D E5 01 20 A0 E3 08 10 13 E5 01 20 82 E2 00 00 51 E3 04 30 43 E2 FA FF FF 0A 04 00 9D E5 00 20 82 E0 02 00 50 E1 24 20 8D E5 3D 00 00 AA 28 10 9D E5 20 E0 9D E5 01 20 81 E2 8C 12 9D E5 00 20 82 E0 02 21 81 E0 0E 30 80 E0 08 00 9D E5 08 20 8D E5 5D 2F 8D E2 83 21 82 E0 03 90 A0 E1 24 30 9D E5 34 B0 8D E2 0E 30 83 E0 00 B0 8B E0 04 20 8D E5 10 30 8D E5 8E A1 A0 E1 08 E0 9D E5 00 00 9E E5 ?? ?? ?? ?? 0C 20 9D E5 04 30 9D E5 00 00 52 E3 03 00 83 E8 00 60 A0 B3 00 70 A0 B3 13 00 00 BA 5D EF 8D E2 89 51 8E E0 00 40 A0 E3 00 60 A0 E3 00 70 A0 E3 04 30 88 E0 03 00 93 E8 0C 00 95 E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 08 40 84 E2 0A 00 54 E1 00 60 A0 E1 01 70 A0 E1 08 50 45 E2 F0 FF FF 1A 08 10 9D E5 04 20 9D E5 10 00 9D E5 01 90 89 E2 04 10 81 E2 08 20 82 E2 00 00 59 E1 08 60 8B E5 0C 70 8B E5 08 10 8D E5 04 20 8D E5 08 B0 8B E2 D4 FF FF 1A 24 30 9D E5 04 30 8D E5 11 FF FF EA 05 20 A0 E1 06 30 A0 E1 00 00 A0 E3 3C 16 9F E5 ?? ?? ?? ?? 00 00 54 E3 00 50 A0 E1 01 60 A0 E1 8E FF FF 0A 14 20 9D E5 00 00 A0 E3 1C 16 9F E5 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 00 50 A0 E1 01 60 A0 E1 82 FF FF EA 0E 00 00 1A 04 20 9D E5 99 1F 8D E2 02 31 81 E0 54 70 13 E5 C7 7B A0 E1 4B FF FF EA 04 E0 9D E5 99 0F 8D E2 01 20 4E E2 02 21 80 E0 50 30 12 E5 FF 34 C3 E3 02 35 C3 E3 50 30 02 E5 70 FF FF EA 00 20 A0 E3 B4 35 9F E5 ?? ?? ?? ?? 00 00 50 E3 00 70 A0 B3 02 70 A0 A3 3D FF FF AA 6A FF FF EA 00 31 A0 E1 99 1F 8D E2 03 20 81 E0 14 E0 9D E5 50 20 12 E5 18 E0 4E E2 00 00 52 E3 08 70 8D E5 0C A0 8D E5 14 E0 8D E5 00 70 A0 11 09 00 00 1A 85 1F 8D E2 14 20 9D E5 03 30 81 E0 00 70 A0 E1 04 10 33 E5 01 70 47 E2 00 00 51 E3 18 20 42 E2 FA FF FF 0A 14 20 8D E5 14 20 9D E5 00 00 A0 E3 34 15 9F E5 ?? ?? ?? ?? 00 00 57 E3 00 80 A0 E1 01 90 A0 E1 3D 00 00 BA 85 5F 8D E2 34 20 8D E2 07 51 85 E0 87 41 82 E0 2C 60 8D E2 04 00 15 E4 ?? ?? ?? ?? 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E3 03 00 84 E8 E0 34 9F E5 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 08 40 44 E2 06 00 54 E1 00 80 A0 E1 01 90 A0 E1 EF FF FF 1A 1C A0 9D E5 07 B0 A0 E1 00 90 A0 E3 04 70 8D E5 00 00 5A E3 E3 00 00 BA 00 00 59 E3 E1 00 00 BA 00 70 A0 E3 34 00 8D E2 A8 64 9F E5 8B 51 80 E0 07 80 A0 E1 07 40 A0 E1 03 00 00 EA 09 00 54 E1 08 60 86 E2 08 50 85 E2 0C 00 00 CA 0C 00 95 E8 03 00 96 E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 01 40 84 E2 04 00 5A E1 00 70 A0 E1 01 80 A0 E1 EE FF FF AA 01 B0 4B E2 99 EF 8D E2 89 31 8E E0 01 00 7B E3 8C 81 03 E5 90 71 03 E5 01 90 89 E2 DB FF FF 1A 04 70 9D E5 88 12 9D E5 03 00 51 E3 01 F1 9F 97 15 00 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 30 A0 E3 03 20 A0 E1 08 10 9D E5 00 00 51 E3 EC 00 00 0A D8 C0 9D E5 E0 10 9D E5 D4 40 9D E5 DC 00 9D E5 18 E0 9D E5 02 C1 8C E2 02 11 81 E2 02 21 82 E2 14 20 8E E5 10 10 8E E8 08 00 8E E5 0C 10 8E E5 10 30 8E E5 0C 10 9D E5 07 00 01 E2 99 DF 8D E2 F0 8F BD E8 00 00 57 E3 E7 FF FF DA 87 A1 A0 E1 99 EF 8D E2 0A 30 8E E0 D4 90 8D E2 0A 40 89 E0 8C 61 13 E5 90 81 13 E5 04 50 A0 E1 08 20 A0 E1 06 30 A0 E1 03 00 15 E9 ?? ?? ?? ?? 01 C0 A0 E1 00 B0 A0 E1 0C 30 A0 E1 03 00 15 E9 0B 20 A0 E1 00 C0 8D E5 ?? ?? ?? ?? 08 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 00 C0 9D E5 03 00 85 E8 00 18 25 E9 09 00 55 E1 0C 60 A0 E1 0B 80 A0 E1 EA FF FF 1A 01 00 57 E3 C8 FF FF DA 99 0F 8D E2 0A A0 80 E0 01 50 47 E2 8C 81 1A E5 90 A1 1A E5 85 51 89 E0 04 70 A0 E1 00 18 95 E8 0A 00 A0 E1 0C 30 A0 E1 08 10 A0 E1 0B 20 A0 E1 00 C0 8D E5 ?? ?? ?? ?? 00 C0 9D E5 00 40 A0 E1 01 60 A0 E1 04 20 A0 E1 0C 10 A0 E1 06 30 A0 E1 0B 00 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 0A 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 04 20 A0 E1 06 30 A0 E1 0C 00 85 E8 08 00 85 E5 0C 10 85 E5 08 50 45 E2 09 00 55 E1 04 A0 A0 E1 06 80 A0 E1 E1 FF FF 1A 00 30 A0 E3 07 40 A0 E1 08 50 85 E2 03 20 A0 E1 03 00 A0 E1 02 10 A0 E1 0C 00 94 E8 ?? ?? ?? ?? 08 40 44 E2 05 00 54 E1 00 30 A0 E1 01 20 A0 E1 F6 FF FF 1A 97 FF FF EA 00 00 57 E3 00 C0 A0 B3 0C 10 A0 B1 0B 00 00 BA 00 C0 A0 E3 D4 40 8D E2 87 41 84 E0 CC 50 8D E2 0C 10 A0 E1 0C 00 A0 E1 0C 00 94 E8 ?? ?? ?? ?? 08 40 44 E2 05 00 54 E1 00 C0 A0 E1 F8 FF FF 1A 08 30 9D E5 D4 40 9D E5 00 00 53 E3 01 30 A0 01 02 31 81 12 D8 50 9D E5 18 E0 9D E5 0C 80 A0 E1 03 90 A0 E1 0C 20 A0 E1 01 30 A0 E1 00 03 8E E8 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 00 57 E3 01 30 A0 E1 09 00 00 DA D4 40 8D E2 87 71 84 E0 03 10 A0 E1 08 30 84 E2 0C 00 93 E8 ?? ?? ?? ?? 08 40 84 E2 07 00 54 E1 01 30 A0 E1 F7 FF FF 1A 08 10 9D E5 00 00 51 E3 02 31 83 12 03 20 A0 E1 18 30 9D E5 00 10 A0 E1 08 10 83 E5 0C 20 83 E5 72 FF FF EA 00 00 57 E3 00 20 A0 B3 02 30 A0 B1 0D 00 00 BA D4 30 8D E2 00 20 A0 E3 87 71 83 E0 CC 40 8D E2 02 30 A0 E1 02 00 A0 E1 03 10 A0 E1 0C 00 97 E8 ?? ?? ?? ?? 08 70 47 E2 04 00 57 E1 00 20 A0 E1 01 30 A0 E1 F6 FF FF 1A 08 E0 9D E5 02 00 A0 E1 00 00 5E E3 02 31 83 12 18 20 9D E5 03 10 A0 E1 03 00 82 E8 58 FF FF EA 00 70 A0 E3 07 80 A0 E1 32 FF FF EA 14 E0 9D E5 05 00 A0 E1 00 20 6E E2 06 10 A0 E1 08 70 8D E5 0C A0 8D E5 04 70 9D E5 ?? ?? ?? ?? 00 20 A0 E3 FC 30 9F E5 00 40 A0 E1 01 50 A0 E1 ?? ?? ?? ?? 00 00 50 E3 1F 00 00 BA 00 20 A0 E3 C8 30 9F E5 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 20 A0 E3 B0 30 9F E5 00 80 A0 E1 01 90 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 99 2F 8D E2 07 31 82 E0 50 00 03 E5 09 10 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 01 70 87 E2 99 EF 8D E2 07 31 8E E0 50 00 03 E5 14 00 9D E5 18 00 80 E2 14 00 8D E5 C6 FE FF EA 05 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 99 1F 8D E2 07 31 81 E0 50 00 03 E5 BF FE FF EA D4 60 9D E5 DC 40 9D E5 D8 70 9D E5 E0 50 9D E5 02 10 A0 E1 18 20 9D E5 03 00 A0 E1 10 00 82 E5 14 10 82 E5 C0 00 82 E8 08 40 82 E5 0C 50 82 E5 12 FF FF EA ?? ?? ?? ?? 00 00 70 3E 00 00 70 C1 00 00 20 C0 00 00 F0 3F 00 00 E0 3F ?? ?? ?? ?? 00 00 70 41 }
	condition:
		$1
}

rule file_153_0_2 {
	meta:
		name = "vwopen"
		size = 304
		refs = "00ec CreateFileW 0114 SetFilePointer"
	strings:
		$1 = { 70 40 2D E9 03 30 01 E2 01 00 53 E3 0C D0 4D E2 01 40 A0 E1 1B 00 00 0A 02 00 53 E3 05 00 00 0A 00 00 53 E3 02 11 A0 03 03 00 00 0A 00 00 E0 E3 0C D0 8D E2 70 80 BD E8 03 11 A0 E3 07 3C 04 E2 03 0C 53 E3 13 00 00 0A 06 00 00 DA 05 0C 53 E3 16 00 00 0A 11 00 00 CA 01 0B 53 E3 F2 FF FF 1A 03 C0 A0 E3 12 00 00 EA 01 0C 53 E3 2B 00 00 0A 02 0C 53 E3 2B 00 00 0A 00 00 53 E3 EA FF FF 1A 03 C0 A0 E3 0A 00 00 EA 07 3C 04 E2 03 0C 53 E3 01 11 A0 E3 EB FF FF 1A 02 C0 A0 E3 04 00 00 EA 06 0C 53 E3 1F 00 00 0A 07 0C 53 E3 DE FF FF 1A 01 C0 A0 E3 01 3C 14 E2 03 20 A0 01 04 00 00 0A 00 20 92 E5 80 00 12 E3 22 24 A0 E1 01 20 02 E2 02 20 82 13 00 50 A0 E3 00 C0 8D E5 05 30 A0 E1 80 C0 A0 E3 04 C0 8D E5 08 50 8D E5 ?? ?? ?? ?? 01 00 70 E3 00 60 A0 E1 CB FF FF 0A 08 00 14 E3 06 00 A0 01 C9 FF FF 0A 05 10 A0 E1 05 20 A0 E1 02 30 A0 E3 ?? ?? ?? ?? 06 00 A0 E1 C3 FF FF EA 04 C0 A0 E3 E2 FF FF EA 05 C0 A0 E3 E0 FF FF EA }
	condition:
		$1
}

rule file_153_2_2 {
	meta:
		name = "vopen"
		size = 80
		refs = "0014 strlen 0030 mbstowcs"
	strings:
		$1 = { F0 40 2D E9 82 DF 4D E2 01 50 A0 E1 02 40 A0 E1 00 70 A0 E1 ?? ?? ?? ?? 41 0F 50 E3 00 00 E0 23 08 00 00 2A 01 20 80 E2 07 10 A0 E1 0D 00 A0 E1 ?? ?? ?? ?? 0D 00 A0 E1 05 10 A0 E1 04 20 A0 E1 0D 60 A0 E1 95 FF FF EB 82 DF 8D E2 F0 80 BD E8 }
	condition:
		$1
}

rule file_155_0_2 {
	meta:
		name = "_mkdir"
		size = 60
		refs = "0014 mbstowcs 0020 CreateDirectoryW"
	strings:
		$1 = { 10 40 2D E9 82 DF 4D E2 00 10 A0 E1 41 2F A0 E3 0D 00 A0 E1 ?? ?? ?? ?? 0D 00 A0 E1 00 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 0D 40 A0 E1 00 00 E0 03 00 00 A0 13 82 DF 8D E2 10 80 BD E8 }
	condition:
		$1
}

rule file_156_0_2 {
	meta:
		name = "_close"
		size = 24
		refs = "0004 CloseHandle"
	strings:
		$1 = { 04 E0 2D E5 ?? ?? ?? ?? 00 00 50 E3 00 00 E0 03 00 00 A0 13 04 F0 9D E4 }
	condition:
		$1
}

rule file_160_5_2 {
	meta:
		name = "_findclose"
		size = 24
		refs = "0004 FindClose"
	strings:
		$1 = { 04 E0 2D E5 ?? ?? ?? ?? 00 00 50 E3 00 00 E0 03 00 00 A0 13 04 F0 9D E4 }
	condition:
		$1
}

rule file_157_0_2 {
	meta:
		name = "__mingw_vfprintf"
		size = 40
		refs = "001c __mingw_pformat"
	strings:
		$1 = { 04 E0 2D E5 04 D0 4D E2 01 30 A0 E1 00 20 8D E5 00 10 A0 E1 00 20 A0 E3 03 0A A0 E3 ?? ?? ?? ?? 04 D0 8D E2 00 80 BD E8 }
	condition:
		$1
}

rule file_158_0_2 {
	meta:
		name = "truncf"
		size = 156
		refs = "003c __addsf3 0044 __gtsf2"
	strings:
		$1 = { 30 40 2D E9 C0 5B A0 E1 FF 50 05 E2 7F 50 45 E2 16 00 55 E3 00 10 A0 E1 00 40 A0 E1 0E 00 00 CA 00 00 55 E3 12 00 00 BA 64 30 9F E5 53 55 A0 E1 00 00 15 E1 06 00 00 0A 58 10 9F E5 ?? ?? ?? ?? 00 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 05 40 C4 C1 04 10 A0 E1 01 00 A0 E1 30 80 BD E8 80 00 55 E3 FB FF FF 1A ?? ?? ?? ?? 00 10 A0 E1 01 00 A0 E1 30 80 BD E8 1C 10 9F E5 ?? ?? ?? ?? 00 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 02 41 04 C2 04 10 A0 E1 EF FF FF EA FF FF 7F 00 CA F2 49 71 }
	condition:
		$1
}

rule file_159_0_2 {
	meta:
		name = "lroundf"
		size = 184
		refs = "0044 __extendsfdf2 0050 __adddf3 0054 __truncdfsf2"
	strings:
		$1 = { 70 40 2D E9 A0 4B A0 E1 FF 30 04 E2 7F 30 43 E2 01 00 73 E3 00 00 A0 B3 70 80 BD B8 1E 00 53 E3 44 44 A0 E1 18 00 00 CA 16 00 53 E3 09 00 00 CA 00 00 54 E3 74 60 9F 05 74 60 9F 15 00 50 A0 03 00 50 A0 13 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? A0 2B A0 E1 FF 20 02 E2 FF 34 C0 E3 02 35 C3 E3 96 20 52 E2 02 35 83 E3 09 00 00 4A 1F 00 52 E3 13 02 A0 D1 00 00 A0 C3 00 00 54 E3 00 00 60 12 70 80 BD E8 00 00 54 E3 02 01 A0 13 02 01 E0 03 70 80 BD E8 1F 00 72 E3 00 20 62 A2 33 02 A0 A1 00 00 A0 B3 F3 FF FF EA 00 00 E0 3F 00 00 E0 BF }
	condition:
		$1
}

rule file_160_0_2 {
	meta:
		name = "wfd_to_fd"
		size = 160
		refs = "0074 wcscpy 007c __FILETIME_to_time_t"
	strings:
		$1 = { 00 30 90 E5 00 20 A0 E3 01 00 13 E3 00 20 81 E5 01 20 A0 13 00 20 81 15 02 00 13 E3 00 20 91 15 30 40 2D E9 02 20 82 13 00 20 81 15 04 00 13 E3 00 20 91 15 01 40 A0 E1 04 20 82 13 00 20 81 15 10 00 13 E3 00 20 91 15 00 50 A0 E1 10 20 82 13 00 20 81 15 20 00 13 E3 00 30 91 15 20 30 83 13 00 30 81 15 20 30 90 E5 28 10 80 E2 10 30 84 E5 14 00 84 E2 ?? ?? ?? ?? 0C 00 85 E2 ?? ?? ?? ?? 08 00 84 E5 04 00 85 E2 ?? ?? ?? ?? 04 00 84 E5 14 00 85 E2 ?? ?? ?? ?? 0C 00 84 E5 30 80 BD E8 }
	condition:
		$1
}

rule file_160_1_2 {
	meta:
		name = "_wfindnext"
		size = 60
		refs = "0010 FindNextFileW"
	strings:
		$1 = { 30 40 2D E9 23 DE 4D E2 01 50 A0 E1 0D 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 0D 40 A0 E1 00 00 E0 03 03 00 00 0A 0D 00 A0 E1 05 10 A0 E1 CB FF FF EB 00 00 A0 E3 23 DE 8D E2 30 80 BD E8 }
	condition:
		$1
}

rule file_160_2_2 {
	meta:
		name = "_findnext"
		size = 84
		refs = "0010 _wfindnext 0044 wcstombs"
	strings:
		$1 = { 30 40 2D E9 87 DF 4D E2 01 40 A0 E1 0D 10 A0 E1 EB FF FF EB 01 00 70 E3 0D 50 A0 E1 0A 00 00 0A 00 00 9D E5 08 10 8D E2 0E 00 91 E8 00 00 84 E5 04 00 9D E5 0F 00 84 E9 14 00 84 E2 14 10 8D E2 41 2F A0 E3 ?? ?? ?? ?? 00 00 A0 E3 87 DF 8D E2 30 80 BD E8 }
	condition:
		$1
}

rule file_160_3_2 {
	meta:
		name = "_wfindfirst"
		size = 56
		refs = "0010 FindFirstFileW"
	strings:
		$1 = { 70 40 2D E9 23 DE 4D E2 01 60 A0 E1 0D 10 A0 E1 ?? ?? ?? ?? 01 00 70 E3 0D 50 A0 E1 00 40 A0 E1 0D 00 A0 11 06 10 A0 11 A8 FF FF 1B 04 00 A0 E1 23 DE 8D E2 70 80 BD E8 }
	condition:
		$1
}

rule file_160_4_2 {
	meta:
		name = "_findfirst"
		size = 124
		refs = "0020 mbstowcs 002c _wfindfirst 0068 wcstombs"
	strings:
		$1 = { 70 40 2D E9 42 DE 4D E2 04 D0 4D E2 87 6F 8D E2 41 2F A0 E3 01 40 A0 E1 00 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 06 00 A0 E1 0D 10 A0 E1 E5 FF FF EB 04 50 8D E2 01 00 70 E3 04 50 45 E2 00 60 A0 E1 09 00 00 0A 00 00 9D E5 08 10 8D E2 0E 00 91 E8 00 00 84 E5 04 00 9D E5 0F 00 84 E9 14 00 84 E2 14 10 85 E2 41 2F A0 E3 ?? ?? ?? ?? 06 00 A0 E1 24 D0 8D E2 01 DB 8D E2 70 80 BD E8 }
	condition:
		$1
}

rule file_161_0_2 {
	meta:
		name = "wmemmove"
		size = 92
	strings:
		$1 = { 00 00 50 E3 00 00 51 13 00 30 A0 13 01 30 A0 03 0E F0 A0 01 00 00 52 E3 0E F0 A0 01 01 00 50 E1 82 30 A0 81 03 10 81 80 03 30 80 80 05 00 00 8A B3 C0 91 E1 01 20 52 E2 B3 C0 80 E1 02 30 83 E2 FA FF FF 1A 0E F0 A0 E1 B2 C0 71 E1 01 20 52 E2 B2 C0 63 E1 FB FF FF 1A 0E F0 A0 E1 }
	condition:
		$1
}

rule file_162_0_2 {
	meta:
		name = "tanh"
		size = 412
		refs = "0038 __divdf3 0044 __adddf3 00ac expm1 0104 __subdf3 0130 __muldf3"
	strings:
		$1 = { 84 21 9F E5 02 31 C1 E3 02 00 53 E1 70 40 2D E9 01 50 A0 E1 01 40 A0 E1 00 60 A0 E1 0E 00 00 DA 00 00 51 E3 2F 00 00 BA 00 20 A0 E1 01 30 A0 E1 00 00 A0 E3 54 11 9F E5 ?? ?? ?? ?? 00 20 A0 E3 48 31 9F E5 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 02 00 A0 E1 03 10 A0 E1 70 80 BD E8 30 21 9F E5 02 00 53 E1 00 20 A0 C3 20 31 9F C5 04 00 00 DA 00 00 54 E3 02 31 83 B2 02 00 A0 E1 03 10 A0 E1 70 80 BD E8 F2 05 53 E3 23 00 00 BA 04 21 9F E5 02 00 53 E1 29 00 00 DA 02 51 C1 E3 00 20 A0 E1 05 30 A0 E1 05 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 00 20 A0 E3 01 31 A0 E3 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 00 00 A0 E3 03 11 A0 E3 ?? ?? ?? ?? 00 20 A0 E3 B4 30 9F E5 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 E1 FF FF EA 00 20 A0 E1 01 30 A0 E1 00 00 A0 E3 94 10 9F E5 ?? ?? ?? ?? 00 20 A0 E3 88 30 9F E5 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 02 00 A0 E1 03 10 A0 E1 70 80 BD E8 00 20 A0 E3 68 30 9F E5 ?? ?? ?? ?? 06 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 C3 FF FF EA 00 20 A0 E3 03 31 A0 E3 02 11 C1 E3 ?? ?? ?? ?? ?? ?? ?? ?? 00 20 A0 E3 01 31 A0 E3 00 50 A0 E1 01 60 A0 E1 ?? ?? ?? ?? 02 61 86 E2 00 20 A0 E1 01 30 A0 E1 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 B8 FF FF EA FF FF EF 7F 00 00 F0 3F FF FF 35 40 FF FF EF 3F }
	condition:
		$1
}

rule file_164_0_2 {
	meta:
		name = "usleep"
		size = 60
		refs = "0028 Sleep"
	strings:
		$1 = { 00 00 50 E3 04 E0 2D E5 04 F0 9D 04 20 30 9F E5 03 00 50 E1 00 00 E0 83 04 F0 9D 84 14 30 9F E5 93 20 80 E0 20 03 A0 E1 ?? ?? ?? ?? 00 00 A0 E3 04 F0 9D E4 3F 42 0F 00 D3 4D 62 10 }
	condition:
		$1
}

rule file_165_0_2 {
	meta:
		name = "asctime"
		size = 116
		refs = "005c sprintf 006c .rdata 0070 .bss"
	strings:
		$1 = { F0 45 2D E9 14 C0 90 E5 18 20 90 E5 10 30 90 E5 54 10 9F E5 54 40 9F E5 E0 00 90 E9 00 E0 90 E5 20 A0 81 E2 38 80 81 E2 82 20 82 E0 83 30 83 E0 76 CE 8C E2 14 D0 4D E2 0C C0 8C E2 02 20 8A E0 03 30 88 E0 04 00 A0 E1 00 70 8D E5 04 60 8D E5 08 50 8D E5 0C E0 8D E5 10 C0 8D E5 ?? ?? ?? ?? 04 00 A0 E1 14 D0 8D E2 F0 85 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_167_0_2 {
	meta:
		name = "_unlink"
		size = 84
		refs = "0014 mbstowcs 0030 DeleteFileW"
	strings:
		$1 = { 10 40 2D E9 82 DF 4D E2 00 10 A0 E1 41 2F A0 E3 0D 00 A0 E1 ?? ?? ?? ?? 30 30 9F E5 01 00 40 E2 03 00 50 E1 0D 40 A0 E1 06 00 00 8A 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 00 00 A0 13 01 00 00 0A 82 DF 8D E2 10 80 BD E8 00 00 E0 E3 FB FF FF EA 02 01 00 00 }
	condition:
		$1
}

rule file_168_0_2 {
	meta:
		name = "__dtoa"
		size = 4960
		refs = "0074 __nedf2 0090 __d2b_D2A 00e0 __subdf3 00ec __muldf3 00f8 __adddf3 0108 __floatsidf 0134 __fixdfsi 014c __ltdf2 0224 __rv_alloc_D2A 02bc __pow5mult_D2A 02c8 __mult_D2A 02d4 __Bfree_D2A 02e0 __i2b_D2A 0344 __clzsi2 0384 __lshift_D2A 0430 __quorem_D2A 0440 __cmp_D2A 0450 __diff_D2A 04cc __multadd_D2A 0520 __nrv_alloc_D2A 05b0 __floatunsidf 05e8 .text 0640 __divdf3 0880 __gedf2 0bb4 __gtdf2 0d70 __Balloc_D2A 0d8c memcpy 0e9c .rdata 0ec4 __tens_D2A 0ec8 __bigtens_D2A 1168 __eqdf2"
	strings:
		$1 = { F0 4F 2D E9 01 50 A0 E1 64 D0 4D E2 00 40 A0 E1 30 00 8D E9 08 40 9D E5 18 30 8D E5 00 00 54 E3 8C 30 9D E5 02 B0 A0 E1 01 20 A0 B3 00 20 A0 A3 00 20 83 B5 00 20 83 A5 3C 3E 9F E5 02 41 C4 B3 34 2E 9F E5 04 50 A0 B1 03 30 04 E0 08 50 8D B5 02 00 53 E1 36 01 00 0A 06 00 9D E9 00 30 A0 E3 0C 10 8D E5 10 20 8D E5 01 00 A0 E1 02 10 A0 E1 00 20 A0 E3 ?? ?? ?? ?? 00 00 50 E3 22 01 00 0A 60 30 8D E2 0C 10 8D E2 03 00 91 E8 5C 20 8D E2 ?? ?? ?? ?? 24 3A A0 E1 83 3A A0 E1 A3 3A A0 E1 00 00 53 E3 00 50 A0 E1 31 01 00 0A 0C 10 8D E2 03 00 91 E8 FF 24 C1 E3 0F 26 C2 E3 FF 15 82 E3 FF 4F 43 E2 00 20 A0 E3 60 70 9D E5 03 40 44 E2 03 16 81 E3 40 20 8D E5 00 20 A0 E3 9C 3D 9F E5 ?? ?? ?? ?? 98 2D 9F E5 98 3D 9F E5 ?? ?? ?? ?? 94 2D 9F E5 94 3D 9F E5 ?? ?? ?? ?? 00 80 A0 E1 04 00 A0 E1 01 90 A0 E1 ?? ?? ?? ?? 80 2D 9F E5 80 3D 9F E5 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 00 80 A0 E1 01 90 A0 E1 ?? ?? ?? ?? 09 10 A0 E1 00 60 A0 E1 00 20 A0 E3 08 00 A0 E1 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 06 00 00 AA 06 00 A0 E1 ?? ?? ?? ?? 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 01 60 46 12 16 00 56 E3 01 10 A0 83 34 10 8D 85 0B 00 00 8A 38 3D 9F E5 0C 10 8D E2 03 00 91 E8 86 31 83 E0 0C 00 93 E8 ?? ?? ?? ?? 00 00 50 E3 00 20 A0 A3 00 30 A0 B3 34 20 8D A5 01 60 46 B2 34 30 8D B5 01 70 47 E2 04 40 57 E0 14 40 8D 55 00 40 64 42 00 40 A0 53 00 10 A0 43 20 40 8D 55 20 40 8D 45 14 10 8D 45 00 00 56 E3 7F 01 00 BA 14 20 9D E5 00 30 A0 E3 06 20 82 E0 14 20 8D E5 30 60 8D E5 3C 30 8D E5 09 00 5B E3 00 B0 A0 83 F0 00 00 9A 00 30 E0 E3 00 10 A0 E3 12 00 A0 E3 01 40 A0 E3 38 30 8D E5 2C 40 8D E5 1C 30 8D E5 18 10 8D E5 ?? ?? ?? ?? 00 90 A0 E1 5C 40 9D E5 0E 00 56 E3 00 30 A0 C3 01 30 A0 D3 00 00 54 E3 00 30 A0 B3 00 00 53 E3 EA 00 00 1A 2C 10 9D E5 00 00 51 E3 71 01 00 1A 20 40 9D E5 01 70 A0 E1 20 30 9D E5 14 20 9D E5 00 00 52 E3 00 00 53 C3 03 80 A0 D1 08 00 00 DA 14 80 9D E5 20 10 9D E5 14 20 9D E5 01 00 58 E1 01 80 A0 A1 02 20 68 E0 04 40 68 E0 14 20 8D E5 01 80 68 E0 3C 30 9D E5 00 00 53 E3 0C 00 00 0A 2C 10 9D E5 00 00 51 E3 B2 03 00 0A 03 10 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 00 70 A0 E1 ?? ?? ?? ?? 00 A0 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 0A 50 A0 E1 01 00 A0 E3 ?? ?? ?? ?? 30 20 9D E5 00 A0 A0 E1 00 00 52 E3 02 00 00 0A 02 10 A0 E1 ?? ?? ?? ?? 00 A0 A0 E1 2C 30 9D E5 01 00 5B E3 01 30 83 D3 00 00 53 E3 02 00 00 0A 04 30 9D E5 00 00 53 E3 82 02 00 0A 00 30 A0 E3 0C 30 8D E5 30 10 9D E5 00 00 51 E3 01 30 A0 03 04 00 00 0A 10 30 9A E5 03 31 8A E0 10 00 93 E5 ?? ?? ?? ?? 20 30 60 E2 14 20 9D E5 02 30 83 E0 1F 30 13 E2 1C 30 A0 03 66 01 00 1A 14 20 9D E5 03 40 84 E0 03 20 82 E0 14 20 8D E5 03 80 88 E0 00 00 54 E3 03 00 00 DA 05 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 00 50 A0 E1 14 30 9D E5 00 00 53 E3 03 00 00 DA 0A 00 A0 E1 03 10 A0 E1 ?? ?? ?? ?? 00 A0 A0 E1 34 40 9D E5 00 00 54 E3 2B 03 00 1A 1C 40 9D E5 00 00 54 E3 45 03 00 DA 2C 20 9D E5 00 00 52 E3 55 01 00 0A 00 00 58 E3 03 00 00 DA 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 70 A0 E1 0C 30 9D E5 00 00 53 E3 07 00 A0 01 5D 02 00 1A 04 40 9D E5 01 B0 5B E2 01 B0 A0 13 01 40 04 E2 01 30 A0 E3 07 80 A0 E1 20 40 8D E5 18 B0 8D E5 00 70 A0 E1 24 90 8D E5 04 90 8D E5 03 40 A0 E1 2C 60 8D E5 0A 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 08 10 A0 E1 0C 00 8D E5 05 00 A0 E1 ?? ?? ?? ?? 07 10 A0 E1 14 00 8D E5 0A 00 A0 E1 ?? ?? ?? ?? 0C 90 90 E5 0C 10 9D E5 00 00 59 E3 00 60 A0 E1 30 B0 81 E2 C9 00 00 0A ?? ?? ?? ?? 01 30 A0 E3 14 20 9D E5 00 00 52 E3 5B 03 00 BA 18 10 9D E5 00 20 A0 13 01 20 01 02 00 00 52 E3 02 00 00 0A 20 20 9D E5 00 00 52 E3 53 03 00 0A 00 00 53 E3 72 03 00 CA 1C 30 9D E5 04 20 9D E5 03 00 54 E1 01 B0 C2 E4 04 20 8D E5 80 03 00 0A 05 00 A0 E1 0A 10 A0 E3 00 20 A0 E3 ?? ?? ?? ?? 07 00 58 E1 00 50 A0 E1 C8 00 00 0A 08 00 A0 E1 0A 10 A0 E3 00 20 A0 E3 ?? ?? ?? ?? 0A 10 A0 E3 00 80 A0 E1 00 20 A0 E3 07 00 A0 E1 ?? ?? ?? ?? 01 40 84 E2 00 70 A0 E1 C6 FF FF EA 88 30 9D E5 01 20 A0 E3 00 20 83 E5 90 10 9D E5 78 09 9F E5 ?? ?? ?? ?? 00 90 A0 E1 09 00 A0 E1 64 D0 8D E2 F0 8F BD E8 04 10 9D E5 60 39 9F E5 88 20 9D E5 00 00 51 E3 00 30 82 E5 03 00 00 1A FF 44 C4 E3 0F 46 C4 E3 00 00 54 E3 87 00 00 0A 90 10 9D E5 3C 09 9F E5 03 20 A0 E3 ?? ?? ?? ?? 00 90 A0 E1 EC FF FF EA 60 70 9D E5 5C 30 9D E5 03 30 87 E0 43 3E 83 E2 02 30 83 E2 20 00 53 E3 04 10 9D C5 20 20 43 C2 31 22 A0 C1 04 20 9D D5 40 00 63 C2 20 00 63 D2 14 00 82 C1 12 00 A0 D1 43 4E 43 E2 ?? ?? ?? ?? 01 30 A0 E3 03 40 44 E2 1F 16 41 E2 40 30 8D E5 C3 FE FF EA 05 00 5B E3 04 B0 4B C2 02 30 4B E2 01 70 A0 D3 00 70 A0 C3 03 00 53 E3 03 F1 9F 97 06 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 18 40 9D E5 1C 10 9D E5 A4 3F A0 E1 00 00 51 E3 00 30 A0 C3 01 30 03 D2 00 00 53 E3 A8 38 9F E5 86 31 83 E0 06 00 93 E8 0C 10 8D E5 10 20 8D E5 8B 00 00 1A 00 0C 9D E9 02 30 A0 E1 0A 00 A0 E1 01 20 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 00 80 A0 E1 ?? ?? ?? ?? 0C 30 8D E2 0C 00 93 E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 09 40 A0 E1 30 30 88 E2 01 30 C4 E4 00 20 A0 E3 00 30 A0 E3 00 A0 A0 E1 01 B0 A0 E1 ?? ?? ?? ?? 00 00 50 E3 2B 00 00 0A 1C 30 9D E5 01 00 53 E3 01 70 A0 13 04 50 8D 15 14 60 8D 15 03 00 00 1A 9A 02 00 EA 1C 50 9D E5 05 00 57 E1 95 02 00 0A 0A 00 A0 E1 0B 10 A0 E1 00 20 A0 E3 E8 37 9F E5 ?? ?? ?? ?? 0C 30 8D E2 0C 00 93 E8 00 50 A0 E1 01 60 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 00 80 A0 E1 ?? ?? ?? ?? 0C 30 8D E2 0C 00 93 E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 30 30 88 E2 07 30 C9 E7 00 20 A0 E3 00 30 A0 E3 00 A0 A0 E1 01 B0 A0 E1 ?? ?? ?? ?? 00 00 50 E3 01 70 87 E2 01 40 84 E2 DC FF FF 1A 04 50 9D E5 14 60 9D E5 24 60 8D E5 05 00 A0 E1 ?? ?? ?? ?? 00 20 A0 E3 90 10 9D E5 24 50 9D E5 00 20 C4 E5 88 20 9D E5 01 30 85 E2 00 00 51 E3 00 30 82 E5 00 40 81 15 6A FF FF EA 90 10 9D E5 20 07 9F E5 08 20 A0 E3 ?? ?? ?? ?? 00 90 A0 E1 64 FF FF EA 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 30 A0 E1 06 00 A0 E1 00 30 8D E5 ?? ?? ?? ?? 00 30 9D E5 18 20 9D E5 00 00 53 E3 00 20 A0 13 01 20 02 02 00 00 52 E3 29 FF FF 0A 20 20 9D E5 00 00 52 E3 C5 02 00 0A 09 30 A0 E1 24 FF FF EA 20 40 9D E5 00 10 66 E2 04 40 66 E0 00 20 A0 E3 20 40 8D E5 3C 10 8D E5 30 20 8D E5 7D FE FF EA 08 00 A0 E1 0A 10 A0 E3 00 20 A0 E3 ?? ?? ?? ?? 01 40 84 E2 00 80 A0 E1 00 70 A0 E1 01 FF FF EA 40 20 9D E5 14 30 9D E5 00 00 52 E3 60 40 9D 05 43 4E 84 12 03 40 84 12 36 40 64 02 20 10 9D E5 04 30 83 E0 01 00 A0 E3 14 30 8D E5 01 40 84 E0 ?? ?? ?? ?? 00 70 A0 E1 80 FE FF EA 1C 20 9D E5 00 00 52 E3 1A 00 00 1A 00 20 A0 E3 38 36 9F E5 0C 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 0C 00 9D E9 ?? ?? ?? ?? 00 00 50 E3 11 00 00 AA 00 A0 A0 E3 0A 70 A0 E1 09 40 A0 E1 31 30 A0 E3 01 30 C4 E4 01 60 86 E2 00 80 A0 E3 0A 00 A0 E1 ?? ?? ?? ?? 00 00 57 E3 A3 FF FF 0A 07 00 58 E1 00 00 58 13 0A 00 00 1A 07 00 A0 E1 ?? ?? ?? ?? 24 60 8D E5 9D FF FF EA 00 A0 A0 E3 0A 70 A0 E1 18 10 9D E5 09 40 A0 E1 01 60 E0 E1 00 80 A0 E3 ED FF FF EA 08 00 A0 E1 ?? ?? ?? ?? F1 FF FF EA 20 30 63 E2 04 00 53 E3 92 02 00 DA 14 10 9D E5 04 30 43 E2 03 10 81 E0 14 10 8D E5 03 40 84 E0 03 80 88 E0 93 FE FF EA 07 B0 A0 E1 09 40 A0 E1 01 80 A0 E3 1C 70 9D E5 04 00 00 EA 0A 10 A0 E3 00 20 A0 E3 ?? ?? ?? ?? 01 80 88 E2 00 50 A0 E1 0A 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 30 20 80 E2 01 20 C4 E4 14 30 95 E5 05 00 A0 E1 00 00 53 E3 02 00 00 1A 10 10 95 E5 01 00 51 E3 37 02 00 DA 07 00 58 E1 EC FF FF BA 0B 70 A0 E1 00 80 A0 E3 02 B0 A0 E1 05 00 A0 E1 01 10 A0 E3 ?? ?? ?? ?? 0A 10 A0 E1 00 50 A0 E1 ?? ?? ?? ?? 00 00 50 E3 01 00 00 CA 3A 02 00 EA 03 40 A0 E1 01 20 54 E5 01 30 44 E2 39 00 52 E3 46 02 00 1A 03 00 59 E1 F8 FF FF 1A 31 30 A0 E3 00 30 C9 E5 01 60 86 E2 B1 FF FF EA 01 40 A0 E3 2C 40 8D E5 18 10 9D E5 01 10 86 E0 01 00 81 E2 00 00 50 E3 38 10 8D E5 A9 01 00 DA 0E 00 50 E3 00 40 A0 83 01 40 A0 93 1C 00 8D E5 ?? ?? ?? ?? 07 00 14 E1 00 90 A0 E1 02 FE FF 0A 00 00 56 E3 0C 01 00 DA 94 34 9F E5 0F 20 06 E2 46 42 A0 E1 82 31 83 E0 10 00 14 E3 06 00 93 E8 06 00 8D E9 F6 00 00 1A 0C 30 8D E2 0C 00 93 E8 24 20 8D E5 28 30 8D E5 02 80 A0 E3 00 00 54 E3 09 00 00 0A 5C 74 9F E5 03 00 9D E9 01 00 14 E3 0C 00 97 18 01 80 88 12 ?? ?? ?? ?? C4 40 B0 E1 08 70 87 E2 F8 FF FF 1A 03 00 8D E9 0C 00 9D E9 24 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 03 00 8D E9 34 40 9D E5 00 00 54 E3 BC 00 00 0A 03 00 9D E9 F8 33 9F E5 00 20 A0 E3 ?? ?? ?? ?? 1C 10 9D E5 00 00 50 E3 00 30 A0 E3 01 30 A0 B3 00 00 51 E3 00 30 A0 D3 01 30 03 C2 00 00 53 E3 AF 00 00 0A 38 20 9D E5 00 00 52 E3 C9 00 00 DA 00 20 A0 E3 C4 33 9F E5 03 00 9D E9 ?? ?? ?? ?? 03 00 8D E9 01 00 88 E2 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 03 00 9D E9 ?? ?? ?? ?? 94 33 9F E5 00 20 A0 E3 ?? ?? ?? ?? 01 30 46 E2 38 A0 9D E5 00 70 A0 E1 24 30 8D E5 0D 85 41 E2 2C 10 9D E5 00 00 51 E3 E1 00 00 0A 78 33 9F E5 00 00 A0 E3 8A 31 83 E0 0C 00 13 E9 64 13 9F E5 ?? ?? ?? ?? 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? 44 00 8D E5 48 10 8D E5 03 00 9D E9 ?? ?? ?? ?? 00 70 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 03 00 9D E9 ?? ?? ?? ?? 09 40 A0 E1 30 30 87 E2 4C 00 8D E5 50 10 8D E5 01 30 C4 E4 44 10 8D E2 03 00 91 E8 4C 30 8D E2 0C 00 93 E8 ?? ?? ?? ?? 00 00 50 E3 E2 FE FF CA 4C 30 8D E2 0C 00 93 E8 00 00 A0 E3 DC 12 9F E5 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 44 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 00 50 E3 0B 01 00 CA 01 00 5A E3 86 00 00 DA 04 A0 8D E5 54 50 8D E5 58 60 8D E5 01 70 A0 E3 44 60 8D E2 60 00 96 E8 44 B0 8D E5 4C B0 8D E2 00 0C 9B E8 08 00 00 EA ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 F8 00 00 BA 04 20 9D E5 02 00 57 E1 A3 01 00 AA 05 00 A0 E1 06 10 A0 E1 00 20 A0 E3 64 32 9F E5 ?? ?? ?? ?? 00 20 A0 E3 58 32 9F E5 00 50 A0 E1 01 60 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 01 B0 A0 E1 00 A0 A0 E1 ?? ?? ?? ?? 00 80 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 30 80 88 E2 07 80 C9 E7 05 20 A0 E1 06 30 A0 E1 01 B0 A0 E1 00 A0 A0 E1 ?? ?? ?? ?? 00 00 50 E3 0A 20 A0 E1 0B 30 A0 E1 01 70 87 E2 00 00 A0 E3 DC 11 9F E5 01 40 84 E2 D1 FF FF AA 54 50 9D E5 9A FE FF EA 00 10 A0 E3 2C 10 8D E5 18 20 9D E5 00 00 52 E3 F2 00 00 DA 18 30 9D E5 0E 00 53 E3 00 40 A0 83 01 40 A0 93 38 30 8D E5 1C 30 8D E5 03 00 A0 E1 3E FF FF EA 00 40 A0 E3 2C 40 8D E5 31 FF FF EA 01 30 A0 E3 2C 30 8D E5 EE FF FF EA 08 20 9D E5 FF 34 C2 E3 0F 36 C3 E3 00 00 53 E3 77 FD FF 1A 70 31 9F E5 03 30 02 E0 00 00 53 E3 73 FD FF 0A 14 10 9D E5 01 20 A0 E3 01 10 81 E2 01 40 84 E2 14 10 8D E5 0C 20 8D E5 6E FD FF EA 04 00 97 E5 ?? ?? ?? ?? 10 20 97 E5 00 40 A0 E1 02 20 82 E2 0C 10 87 E2 02 21 A0 E1 0C 00 80 E2 ?? ?? ?? ?? 04 00 A0 E1 01 10 A0 E3 ?? ?? ?? ?? 94 FD FF EA 08 00 A0 E1 ?? ?? ?? ?? 0C 00 9D E9 ?? ?? ?? ?? 00 20 A0 E3 F8 30 9F E5 ?? ?? ?? ?? 1C 40 9D E5 00 70 A0 E1 00 00 54 E3 0D 45 41 E2 04 80 A0 E1 1E 00 00 1A 03 00 9D E9 00 20 A0 E3 C8 30 9F E5 ?? ?? ?? ?? 07 20 A0 E1 04 30 A0 E1 03 00 8D E9 ?? ?? ?? ?? 00 00 50 E3 A3 FE FF CA 07 20 A0 E1 02 31 84 E2 03 00 9D E9 ?? ?? ?? ?? 00 00 50 E3 AF FE FF BA 0C 40 8D E2 18 00 94 E8 18 00 8D E9 01 FD FF EA 9C 30 9F E5 0C 10 8D E2 03 00 91 E8 20 30 83 E2 0C 00 93 E8 ?? ?? ?? ?? 0F 40 04 E2 03 80 A0 E3 24 00 8D E5 28 10 8D E5 02 FF FF EA 24 60 8D E5 1C A0 9D E5 36 FF FF EA 00 40 66 E2 00 00 54 E3 CA 00 00 1A 0C 40 8D E2 18 00 94 E8 02 80 A0 E3 18 00 8D E9 08 FF FF EA 00 00 F0 7F 00 00 F8 3F 61 43 6F 63 A7 87 D2 3F B3 C8 60 8B 28 8A C6 3F FB 79 9F 50 13 44 D3 3F ?? ?? ?? ?? 0F 27 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 14 40 00 00 F0 3F 00 00 1C 40 00 00 E0 7F 00 00 24 40 00 00 E0 3F ?? ?? ?? ?? ?? ?? ?? ?? 10 10 1F E5 07 20 A0 E1 8A 11 81 E0 08 30 A0 E1 03 00 11 E9 ?? ?? ?? ?? 44 00 8D E5 48 10 8D E5 03 00 9D E9 ?? ?? ?? ?? 00 70 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 03 00 9D E9 ?? ?? ?? ?? 00 20 A0 E3 00 30 A0 E3 03 00 8D E9 ?? ?? ?? ?? 00 00 50 E3 09 40 A0 01 18 00 00 0A 30 70 87 E2 01 00 5A E3 09 40 A0 E1 01 70 C4 E4 01 80 A0 13 14 00 00 0A 00 20 A0 E3 90 30 1F E5 03 00 9D E9 ?? ?? ?? ?? 03 00 8D E9 ?? ?? ?? ?? 00 70 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 03 00 9D E9 ?? ?? ?? ?? 00 30 A0 E3 00 20 A0 E3 03 00 8D E9 ?? ?? ?? ?? 00 00 50 E3 30 30 87 E2 1D 00 00 1A 30 70 87 E2 01 70 C4 E4 00 20 A0 E3 E0 30 1F E5 44 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 03 00 9D E9 ?? ?? ?? ?? 00 00 50 E3 17 00 00 CA 44 30 8D E2 0C 00 93 E8 00 00 A0 E3 14 11 1F E5 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 03 00 9D E9 ?? ?? ?? ?? 00 00 50 E3 89 FF FF AA 04 30 A0 E1 03 40 A0 E1 D1 20 73 E1 30 00 52 E3 FB FF FF 0A }
	condition:
		$1
}

rule file_169_0_2 {
	meta:
		name = "erfc"
		size = 2544
		refs = "004c __muldf3 006c __subdf3 00b4 __adddf3 0150 __divdf3 0330 __floatunsidf 0540 exp"
	strings:
		$1 = { F0 4F 2D E9 01 60 A0 E1 02 51 C1 E3 01 70 A0 E1 00 18 9F E5 18 D0 4D E2 01 00 55 E1 00 40 A0 E1 06 80 A0 E1 BF 00 00 CA EC 37 9F E5 03 00 55 E1 5A 00 00 CA E4 37 9F E5 03 00 55 E1 6A 01 00 DA 04 20 A0 E1 06 30 A0 E1 06 10 A0 E1 ?? ?? ?? ?? CC 27 9F E5 CC 37 9F E5 00 80 A0 E1 01 90 A0 E1 ?? ?? ?? ?? C0 27 9F E5 C0 37 9F E5 ?? ?? ?? ?? 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? B0 27 9F E5 B0 37 9F E5 ?? ?? ?? ?? 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? A0 27 9F E5 A0 37 9F E5 ?? ?? ?? ?? 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? 90 27 9F E5 90 37 9F E5 ?? ?? ?? ?? 8C 27 9F E5 00 A0 A0 E1 01 B0 A0 E1 84 37 9F E5 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 78 27 9F E5 78 37 9F E5 ?? ?? ?? ?? 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? 68 27 9F E5 68 37 9F E5 ?? ?? ?? ?? 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? 58 27 9F E5 58 37 9F E5 ?? ?? ?? ?? 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? 48 27 9F E5 48 37 9F E5 ?? ?? ?? ?? 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E3 34 37 9F E5 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 01 30 A0 E1 18 17 9F E5 00 20 A0 E1 01 00 56 E1 26 01 00 CA 04 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 04 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 00 00 A0 E3 E0 16 9F E5 04 70 A0 E1 06 80 A0 E1 ?? ?? ?? ?? 70 00 00 EA D4 36 9F E5 03 00 55 E1 6F 00 00 CA 00 20 A0 E3 BC 36 9F E5 02 11 C6 E3 ?? ?? ?? ?? BC 26 9F E5 BC 36 9F E5 00 40 A0 E1 01 50 A0 E1 ?? ?? ?? ?? B0 26 9F E5 B0 36 9F E5 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? A0 26 9F E5 A0 36 9F E5 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 90 26 9F E5 90 36 9F E5 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 80 26 9F E5 80 36 9F E5 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 70 26 9F E5 70 36 9F E5 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 60 26 9F E5 60 36 9F E5 ?? ?? ?? ?? 5C 26 9F E5 5C 36 9F E5 00 80 A0 E1 01 90 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 48 26 9F E5 48 36 9F E5 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 38 26 9F E5 38 36 9F E5 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 28 26 9F E5 28 36 9F E5 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 18 26 9F E5 18 36 9F E5 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 08 26 9F E5 08 36 9F E5 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E3 80 35 9F E5 ?? ?? ?? ?? 00 00 56 E3 00 20 A0 E1 01 30 A0 E1 31 01 00 BA 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 02 01 A0 E3 C4 15 9F E5 ?? ?? ?? ?? 0E 00 00 EA A6 0F A0 E1 80 00 A0 E1 ?? ?? ?? ?? 04 20 A0 E1 00 70 A0 E1 01 80 A0 E1 06 30 A0 E1 00 00 A0 E3 24 15 9F E5 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 18 D0 8D E2 F0 8F BD E8 78 35 9F E5 03 00 55 E1 B5 00 00 CA 02 91 C6 E3 04 20 A0 E1 09 30 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 01 30 A0 E1 00 20 A0 E1 D8 14 9F E5 00 00 A0 E3 ?? ?? ?? ?? 48 35 9F E5 00 A0 A0 E1 03 00 55 E1 01 B0 A0 E1 AD 00 00 DA 38 35 9F E5 A6 7F A0 E1 03 00 55 E1 00 50 A0 D3 01 50 07 C2 00 00 55 E3 A3 00 00 1A 20 25 9F E5 20 35 9F E5 ?? ?? ?? ?? 1C 25 9F E5 1C 35 9F E5 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? 0C 25 9F E5 0C 35 9F E5 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? FC 24 9F E5 FC 34 9F E5 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? EC 24 9F E5 EC 34 9F E5 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? DC 24 9F E5 DC 34 9F E5 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? CC 24 9F E5 CC 34 9F E5 ?? ?? ?? ?? C8 24 9F E5 08 00 8D E5 0C 10 8D E5 C0 34 9F E5 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? B4 24 9F E5 B4 34 9F E5 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? A4 24 9F E5 A4 34 9F E5 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? 94 24 9F E5 94 34 9F E5 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? 84 24 9F E5 84 34 9F E5 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? 74 24 9F E5 74 34 9F E5 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? 64 24 9F E5 64 34 9F E5 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E3 5C 33 9F E5 ?? ?? ?? ?? 00 50 A0 E3 03 00 8D E8 05 20 A0 E1 05 00 A0 E1 09 30 A0 E1 02 11 89 E2 ?? ?? ?? ?? 00 20 A0 E3 28 34 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? 04 20 A0 E1 10 00 8D E5 14 10 8D E5 09 30 A0 E1 05 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 04 20 A0 E1 00 A0 A0 E1 01 B0 A0 E1 05 00 A0 E1 09 30 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 0C 00 9D E8 00 50 A0 E1 01 60 A0 E1 08 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 10 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 00 58 E3 85 00 00 DA 04 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? 5D FF FF EA 00 20 A0 E1 06 30 A0 E1 00 00 A0 E3 74 12 9F E5 ?? ?? ?? ?? 57 FF FF EA 04 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E3 00 70 A0 E1 01 80 A0 E1 04 00 A0 E1 06 10 A0 E1 40 33 9F E5 ?? ?? ?? ?? 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 00 00 A0 E3 20 13 9F E5 ?? ?? ?? ?? 44 FF FF EA 00 00 56 E3 00 00 A0 C3 00 10 A0 C3 40 FF FF CA 00 00 A0 E3 01 11 A0 E3 3D FF FF EA FC 22 9F E5 FC 32 9F E5 ?? ?? ?? ?? F8 22 9F E5 F8 32 9F E5 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? E8 22 9F E5 E8 32 9F E5 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? D8 22 9F E5 D8 32 9F E5 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? C8 22 9F E5 C8 32 9F E5 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? B8 22 9F E5 B8 32 9F E5 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? A8 22 9F E5 A8 32 9F E5 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? 98 22 9F E5 18 32 9F E5 ?? ?? ?? ?? 90 22 9F E5 08 00 8D E5 0C 10 8D E5 88 32 9F E5 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 7C 22 9F E5 7C 32 9F E5 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? 6C 22 9F E5 6C 32 9F E5 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? 5C 22 9F E5 5C 32 9F E5 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? 4C 22 9F E5 4C 32 9F E5 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? 3C 22 9F E5 3C 32 9F E5 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? 2C 22 9F E5 2C 32 9F E5 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? 1C 22 9F E5 1C 32 9F E5 4B FF FF EA 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 06 22 A0 E3 08 32 9F E5 ?? ?? ?? ?? 00 20 A0 E3 84 30 9F E5 ?? ?? ?? ?? DB FE FF EA 04 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 00 00 A0 E3 01 11 A0 E3 ?? ?? ?? ?? D2 FE FF EA FF FF EF 7F FF FF EA 3F FF FF 6F 3C AC 16 00 12 D6 EA F8 BE E4 68 66 23 91 A2 77 3F 4F 19 D7 DB 51 2A 9D 3F 13 B9 1C 69 7D CD D4 3F 68 DB 14 82 BA 6E C0 3F 20 61 A2 42 43 9C D0 BE 10 1A 1C 22 C9 5D 21 3F 0F 6B D3 C4 22 D0 74 3F BA CE 36 55 4C A5 B0 3F 09 DC DA CD 79 77 D9 3F 00 00 F0 3F FF FF CF 3F FF FF F3 3F 3F 07 96 0A 38 BF 61 BF EB 95 97 59 36 2A A2 3F EC 28 3E 3D 98 63 BC 3F E4 20 51 80 CA 5F D4 3F F1 C3 B8 FB 40 D2 D7 3F 4D B3 92 AD 00 8D DA 3F 38 75 F7 BE B8 59 63 3F 1D 15 35 57 54 8B 88 3F 1C DD 51 6B C2 ED 8B 3F 1F 35 63 E7 60 26 C0 3F A7 E9 9F D9 5C 63 B2 3F 33 6F EB 92 F0 4A E1 3F 23 E3 EE 18 66 3E BB 3F FA D4 C3 3F FF FF 3B 40 6C DB 06 40 FF FF 17 40 3F 38 DC 9B 4E 38 7E C0 92 59 2E 6A 61 04 90 40 28 F2 75 13 88 EC 83 40 98 ED C5 43 5D 14 64 40 5A 99 5F 55 09 C2 31 40 DE 85 C2 70 BA 93 E9 3F 4A 6F E8 39 12 34 84 3F 62 2D 71 42 E2 70 36 C0 63 E7 9F E7 74 A8 7D 40 E6 3B DF CE 19 F2 A3 40 6A 24 8C 68 B7 FF A8 40 18 51 9D 18 EB 02 98 40 0A 9F 1B 22 AE 5C 74 40 90 51 1D 26 8B 56 3E 40 00 00 E2 3F 00 00 E0 3F 5C C2 9A C6 EF A0 23 C0 F2 D2 E4 57 65 52 54 40 B2 AB CC EB 5C 13 67 40 66 22 28 84 B1 4C 64 40 8D A3 CB E4 0A 30 4F 40 26 E7 B0 41 04 1E 25 40 60 73 BA E4 16 34 E6 3F 35 64 0D 60 62 9A 74 EE F2 EF AE BF 93 4A 48 8E EF 47 1A 40 2C AE 48 EE A3 28 5B 40 14 03 70 57 21 D0 7A 40 68 28 EC 21 19 2B 84 40 71 1A 8A D5 0D 29 7B 40 21 E7 6A 52 0C 35 61 40 87 76 70 BD B9 A6 33 40 C1 0A EB 3F }
	condition:
		$1
}

rule file_169_1_2 {
	meta:
		name = "erf"
		size = 2508
		refs = "0054 __muldf3 0084 __adddf3 00b0 __subdf3 0204 __divdf3 0224 __floatsidf 0588 exp"
	strings:
		$1 = { F0 4F 2D E9 01 60 A0 E1 02 51 C1 E3 01 70 A0 E1 D8 17 9F E5 1C D0 4D E2 01 00 55 E1 00 40 A0 E1 06 80 A0 E1 7B 00 00 CA C4 37 9F E5 03 00 55 E1 18 00 00 CA BC 37 9F E5 03 00 55 E1 90 00 00 CA 02 05 55 E3 DC 00 00 AA 06 10 A0 E1 00 20 A0 E3 A4 37 9F E5 ?? ?? ?? ?? A0 27 9F E5 00 70 A0 E1 01 80 A0 E1 04 00 A0 E1 06 10 A0 E1 90 37 9F E5 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E3 FF 35 A0 E3 ?? ?? ?? ?? 6F 00 00 EA 68 37 9F E5 03 00 55 E1 6E 00 00 CA 00 20 A0 E3 5C 37 9F E5 02 11 C6 E3 ?? ?? ?? ?? 54 27 9F E5 54 37 9F E5 00 40 A0 E1 01 50 A0 E1 ?? ?? ?? ?? 48 27 9F E5 48 37 9F E5 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 38 27 9F E5 38 37 9F E5 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 28 27 9F E5 28 37 9F E5 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 18 27 9F E5 18 37 9F E5 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 08 27 9F E5 08 37 9F E5 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? F8 26 9F E5 F8 36 9F E5 ?? ?? ?? ?? F4 26 9F E5 F4 36 9F E5 00 80 A0 E1 01 90 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? E0 26 9F E5 E0 36 9F E5 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? D0 26 9F E5 D0 36 9F E5 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? C0 26 9F E5 C0 36 9F E5 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? B0 26 9F E5 B0 36 9F E5 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? A0 26 9F E5 A0 36 9F E5 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E3 20 36 9F E5 ?? ?? ?? ?? 00 00 56 E3 00 20 A0 E1 01 30 A0 E1 6C 01 00 BA 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 06 22 A0 E3 64 36 9F E5 ?? ?? ?? ?? 0F 00 00 EA A6 7F A0 E1 87 00 A0 E1 01 00 60 E2 ?? ?? ?? ?? 04 20 A0 E1 00 70 A0 E1 01 80 A0 E1 06 30 A0 E1 00 00 A0 E3 C8 15 9F E5 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 1C D0 8D E2 F0 8F BD E8 14 36 9F E5 03 00 55 E1 5B 00 00 DA 00 00 56 E3 00 00 A0 B3 04 16 9F B5 00 00 A0 A3 88 15 9F A5 F4 FF FF EA 04 20 A0 E1 06 30 A0 E1 06 10 A0 E1 ?? ?? ?? ?? E8 25 9F E5 E8 35 9F E5 00 70 A0 E1 01 80 A0 E1 ?? ?? ?? ?? DC 25 9F E5 DC 35 9F E5 ?? ?? ?? ?? 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? CC 25 9F E5 CC 35 9F E5 ?? ?? ?? ?? 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? BC 25 9F E5 BC 35 9F E5 ?? ?? ?? ?? 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? AC 25 9F E5 AC 35 9F E5 ?? ?? ?? ?? A8 25 9F E5 00 A0 A0 E1 01 B0 A0 E1 07 00 A0 E1 08 10 A0 E1 98 35 9F E5 ?? ?? ?? ?? 94 25 9F E5 94 35 9F E5 ?? ?? ?? ?? 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? 84 25 9F E5 84 35 9F E5 ?? ?? ?? ?? 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? 74 25 9F E5 74 35 9F E5 ?? ?? ?? ?? 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? 64 25 9F E5 64 35 9F E5 ?? ?? ?? ?? 07 20 A0 E1 08 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E3 88 34 9F E5 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 04 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? A6 FF FF EA 06 10 A0 E1 38 24 9F E5 DC 34 9F E5 ?? ?? ?? ?? 04 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 9E FF FF EA 02 A1 C6 E3 04 20 A0 E1 0A 30 A0 E1 0A 10 A0 E1 ?? ?? ?? ?? 01 30 A0 E1 00 20 A0 E1 0C 14 9F E5 00 00 A0 E3 ?? ?? ?? ?? C8 34 9F E5 00 60 A0 E1 03 00 55 E1 01 70 A0 E1 8D 00 00 DA B8 24 9F E5 B8 34 9F E5 ?? ?? ?? ?? B4 24 9F E5 B4 34 9F E5 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? A4 24 9F E5 A4 34 9F E5 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? 94 24 9F E5 94 34 9F E5 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? 84 24 9F E5 84 34 9F E5 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? 74 24 9F E5 74 34 9F E5 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? 64 24 9F E5 64 34 9F E5 ?? ?? ?? ?? 60 24 9F E5 0C 00 8D E5 10 10 8D E5 58 34 9F E5 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 4C 24 9F E5 4C 34 9F E5 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? 3C 24 9F E5 3C 34 9F E5 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? 2C 24 9F E5 2C 34 9F E5 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? 1C 24 9F E5 1C 34 9F E5 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? 0C 24 9F E5 0C 34 9F E5 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? FC 23 9F E5 FC 33 9F E5 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E3 AC 32 9F E5 ?? ?? ?? ?? 00 50 A0 E3 03 00 8D E9 05 20 A0 E1 05 00 A0 E1 0A 30 A0 E1 02 11 8A E2 ?? ?? ?? ?? 00 20 A0 E3 C0 33 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? 04 20 A0 E1 14 00 8D E5 18 10 8D E5 0A 30 A0 E1 05 00 A0 E1 0A 10 A0 E1 ?? ?? ?? ?? 04 20 A0 E1 01 C0 A0 E1 00 B0 A0 E1 0A 30 A0 E1 05 00 A0 E1 0A 10 A0 E1 00 C0 8D E5 ?? ?? ?? ?? 00 C0 9D E5 00 20 A0 E1 01 30 A0 E1 0B 00 A0 E1 0C 10 A0 E1 ?? ?? ?? ?? 0C 00 9D E9 00 50 A0 E1 01 60 A0 E1 0C 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 14 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 00 00 58 E3 69 00 00 BA 04 20 A0 E1 0A 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 00 00 A0 E3 C0 11 9F E5 ?? ?? ?? ?? 01 FF FF EA F4 22 9F E5 F4 32 9F E5 ?? ?? ?? ?? F0 22 9F E5 F0 32 9F E5 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? E0 22 9F E5 E0 32 9F E5 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? D0 22 9F E5 D0 32 9F E5 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? C0 22 9F E5 C0 32 9F E5 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? B0 22 9F E5 B0 32 9F E5 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? A0 22 9F E5 A0 32 9F E5 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? 90 22 9F E5 14 32 9F E5 ?? ?? ?? ?? 88 22 9F E5 0C 00 8D E5 10 10 8D E5 80 32 9F E5 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 74 22 9F E5 74 32 9F E5 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? 64 22 9F E5 64 32 9F E5 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? 54 22 9F E5 54 32 9F E5 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? 44 22 9F E5 44 32 9F E5 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? 34 22 9F E5 34 32 9F E5 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? 24 22 9F E5 24 32 9F E5 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? 14 22 9F E5 14 32 9F E5 64 FF FF EA 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 06 02 A0 E3 F8 11 9F E5 ?? ?? ?? ?? A0 FE FF EA 04 20 A0 E1 0A 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E3 20 30 9F E5 ?? ?? ?? ?? 99 FE FF EA FF FF EF 7F FF FF EA 3F FF FF 2F 3E 00 00 20 40 69 DB 14 82 BA 6E F0 3F FF FF F3 3F 00 00 F0 3F 3F 07 96 0A 38 BF 61 BF EB 95 97 59 36 2A A2 3F EC 28 3E 3D 98 63 BC 3F E4 20 51 80 CA 5F D4 3F F1 C3 B8 FB 40 D2 D7 3F 4D B3 92 AD 00 8D DA 3F 38 75 F7 BE B8 59 63 3F 1D 15 35 57 54 8B 88 3F 1C DD 51 6B C2 ED 8B 3F 1F 35 63 E7 60 26 C0 3F A7 E9 9F D9 5C 63 B2 3F 33 6F EB 92 F0 4A E1 3F 23 E3 EE 18 66 3E BB 3F C1 0A EB 3F FF FF 17 40 00 00 F0 BF AC 16 00 12 D6 EA F8 BE E4 68 66 23 91 A2 77 3F 4F 19 D7 DB 51 2A 9D 3F 13 B9 1C 69 7D CD D4 3F 68 DB 14 82 BA 6E C0 3F 20 61 A2 42 43 9C D0 BE 10 1A 1C 22 C9 5D 21 3F 0F 6B D3 C4 22 D0 74 3F BA CE 36 55 4C A5 B0 3F 09 DC DA CD 79 77 D9 3F 6D DB 06 40 3F 38 DC 9B 4E 38 7E C0 92 59 2E 6A 61 04 90 40 28 F2 75 13 88 EC 83 40 98 ED C5 43 5D 14 64 40 5A 99 5F 55 09 C2 31 40 DE 85 C2 70 BA 93 E9 3F 4A 6F E8 39 12 34 84 3F 62 2D 71 42 E2 70 36 C0 63 E7 9F E7 74 A8 7D 40 E6 3B DF CE 19 F2 A3 40 6A 24 8C 68 B7 FF A8 40 18 51 9D 18 EB 02 98 40 0A 9F 1B 22 AE 5C 74 40 90 51 1D 26 8B 56 3E 40 00 00 E2 3F 5C C2 9A C6 EF A0 23 C0 F2 D2 E4 57 65 52 54 40 B2 AB CC EB 5C 13 67 40 66 22 28 84 B1 4C 64 40 8D A3 CB E4 0A 30 4F 40 26 E7 B0 41 04 1E 25 40 60 73 BA E4 16 34 E6 3F 35 64 0D 60 62 9A 74 EE F2 EF AE BF 93 4A 48 8E EF 47 1A 40 2C AE 48 EE A3 28 5B 40 14 03 70 57 21 D0 7A 40 68 28 EC 21 19 2B 84 40 71 1A 8A D5 0D 29 7B 40 21 E7 6A 52 0C 35 61 40 87 76 70 BD B9 A6 33 40 C1 0A EB BF }
	condition:
		$1
}

rule file_170_0_2 {
	meta:
		name = "tgammaf"
		size = 44
		refs = "0008 __extendsfdf2 0010 __ieee754_gammaf_r 0014 __floatsisf"
	strings:
		$1 = { 04 E0 2D E5 04 D0 4D E2 ?? ?? ?? ?? 0D 20 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 00 30 9D E5 00 00 53 E3 02 01 80 B2 04 D0 8D E2 00 80 BD E8 }
	condition:
		$1
}

rule file_86_87_3 {
	meta:
		name = "_ZSt17__copy_streambufsIcSt11char_traitsIcEEiPSt15basic_streambufIT_T0_ES6_"
		size = 24
		refs = "000c _ZSt21__copy_streambufs_eofIcSt11char_traitsIcEEiPSt15basic_streambufIT_T0_ES6_Rb"
	strings:
		$1 = { 04 E0 2D E5 04 D0 4D E2 03 20 8D E2 ?? ?? ?? ?? 04 D0 8D E2 00 80 BD E8 }
	condition:
		$1
}

rule file_86_58_3 {
	meta:
		name = "_ZSt17__copy_streambufsIwSt11char_traitsIwEEiPSt15basic_streambufIT_T0_ES6_"
		size = 24
		refs = "000c _ZSt21__copy_streambufs_eofIwSt11char_traitsIwEEiPSt15basic_streambufIT_T0_ES6_Rb"
	strings:
		$1 = { 04 E0 2D E5 04 D0 4D E2 03 20 8D E2 ?? ?? ?? ?? 04 D0 8D E2 00 80 BD E8 }
	condition:
		$1
}

rule file_171_0_2 {
	meta:
		name = "wmemcpy"
		size = 52
	strings:
		$1 = { 00 00 50 E3 00 00 51 13 00 30 A0 13 01 30 A0 03 0E F0 A0 01 00 00 52 E3 0E F0 A0 01 B3 C0 91 E1 01 20 52 E2 B3 C0 80 E1 02 30 83 E2 FA FF FF 1A 0E F0 A0 E1 }
	condition:
		$1
}

rule file_172_0_2 {
	meta:
		name = "localtime"
		size = 196
		refs = "0018 GetSystemTime 0020 GetLocalTime 002c SystemTimeToFileTime 0074 __time_t_to_FILETIME 00a0 FileTimeToSystemTime 00ac __SYSTEMTIME_to_tm 00c0 .bss"
	strings:
		$1 = { F0 45 2D E9 48 D0 4D E2 20 50 8D E2 10 40 8D E2 00 A0 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 ?? ?? ?? ?? 40 10 8D E2 05 00 A0 E1 ?? ?? ?? ?? 38 10 8D E2 04 00 A0 E1 ?? ?? ?? ?? 40 60 9D E5 44 50 9D E5 00 40 A0 E3 38 10 9D E5 3C 30 9D E5 30 80 8D E2 06 00 84 E1 01 20 84 E1 00 60 A0 E1 08 10 A0 E1 00 00 9A E5 05 70 A0 E1 02 60 56 E0 03 70 C7 E0 ?? ?? ?? ?? 30 10 9D E5 34 30 9D E5 01 20 84 E1 34 40 9F E5 06 20 52 E0 07 30 C3 E0 0D 10 A0 E1 08 00 A0 E1 30 20 8D E5 34 30 8D E5 ?? ?? ?? ?? 0D 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 0D 50 A0 E1 04 00 A0 E1 48 D0 8D E2 F0 85 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_173_0_2 {
	meta:
		name = "freopen"
		size = 120
		refs = "0014 strlen 0048 mbstowcs 006c _wfreopen"
	strings:
		$1 = { F0 45 2D E9 A2 DF 4D E2 01 50 A0 E1 02 60 A0 E1 00 A0 A0 E1 ?? ?? ?? ?? 01 70 80 E2 05 00 A0 E1 ?? ?? ?? ?? 01 40 80 E2 40 00 54 E3 41 0F 57 93 00 00 A0 83 0D 00 00 8A 07 20 A0 E1 0A 10 A0 E1 82 7F 8D E2 0D 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 04 20 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 0D 00 A0 E1 07 10 A0 E1 06 20 A0 E1 0D 80 A0 E1 ?? ?? ?? ?? A2 DF 8D E2 F0 85 BD E8 }
	condition:
		$1
}

rule file_176_0_2 {
	meta:
		name = "dirname"
		size = 752
		refs = "0030 wcstombs 0040 realloc 0070 mbstowcs 02e8 .bss 02ec .rdata"
	strings:
		$1 = { F0 49 2D E9 00 40 50 E2 18 B0 8D E2 02 00 00 0A D0 30 D4 E1 00 00 53 E3 11 00 00 1A C4 42 9F E5 00 00 A0 E3 00 20 A0 E1 BC 12 9F E5 00 50 94 E5 ?? ?? ?? ?? 01 60 80 E2 06 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 06 20 A0 E1 00 00 84 E5 98 12 9F E5 ?? ?? ?? ?? 00 40 94 E5 04 00 A0 E1 18 D0 4B E2 F0 89 BD E8 00 00 A0 E3 04 10 A0 E1 00 20 A0 E1 ?? ?? ?? ?? 80 30 A0 E1 0C 30 83 E2 03 30 C3 E3 0D 60 A0 E1 03 D0 4D E0 07 50 8D E2 07 50 C5 E3 00 20 A0 E1 04 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 20 A0 E3 80 30 A0 E1 01 00 50 E3 B3 20 85 E1 B0 30 D5 91 06 00 00 9A B0 30 D5 E1 2F 00 53 E3 5C 00 53 13 02 00 00 1A B2 20 D5 E1 03 00 52 E1 72 00 00 0A 00 00 53 E3 56 00 00 0A 03 20 A0 E1 05 C0 A0 E1 05 10 A0 E1 2F 00 52 E3 5C 00 52 13 0A 00 00 1A B0 20 D1 E1 5C 00 52 E3 2F 00 52 13 03 00 00 1A B2 20 F1 E1 2F 00 52 E3 5C 00 52 13 FB FF FF 0A 00 00 52 E3 03 00 00 0A 01 C0 A0 E1 B2 20 F1 E1 00 00 52 E3 EE FF FF 1A 05 00 5C E1 19 00 00 8A 2F 00 53 E3 5C 00 53 13 05 30 A0 11 2E 20 A0 13 B2 20 C3 10 02 30 85 02 94 71 9F E5 00 00 A0 E3 00 20 A0 E3 B0 20 C3 E1 05 10 A0 E1 00 20 A0 E1 00 40 97 E5 ?? ?? ?? ?? 01 80 80 E2 08 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 08 20 A0 E1 00 40 A0 E1 00 00 87 E5 ?? ?? ?? ?? 06 D0 A0 E1 AF FF FF EA 02 C0 A0 E1 02 20 4C E2 02 00 55 E1 03 00 00 2A B2 10 5C E1 2F 00 51 E3 5C 00 51 13 F7 FF FF 0A 02 00 55 E1 02 20 82 12 3A 00 00 0A 00 30 A0 E3 B0 30 C2 E1 B0 10 D5 E1 2F 00 51 E3 5C 00 51 13 05 20 A0 11 2B 00 00 1A 05 20 A0 E1 B2 30 F2 E1 2F 00 53 E3 5C 00 53 13 FB FF FF 0A 02 30 65 E0 05 00 53 E3 23 00 00 DA 05 20 A0 E1 B0 30 D2 E1 02 10 A0 E1 00 00 53 E3 14 00 00 0A 2F 00 53 E3 B0 30 C1 E1 07 00 00 0A B2 30 D2 E0 5C 00 53 E3 B0 30 D2 11 03 00 00 0A 02 10 81 E2 F4 FF FF EA 06 D0 A0 E1 76 FF FF EA B0 30 D2 E1 2F 00 53 E3 5C 00 53 13 F7 FF FF 1A B2 30 F2 E1 2F 00 53 E3 5C 00 53 13 FB FF FF 0A 02 10 81 E2 E8 FF FF EA B0 30 C1 E1 00 20 A0 E1 05 10 A0 E1 04 00 A0 E1 03 50 A0 E1 ?? ?? ?? ?? 01 00 70 E3 00 50 C4 17 06 D0 A0 E1 71 FF FF EA B2 30 D5 E1 01 00 53 E1 D8 FF FF 1A D8 FF FF EA B4 20 D5 E1 00 00 52 E3 89 FF FF 1A B7 FF FF EA 2F 00 53 E3 5C 00 53 13 02 20 85 12 C0 FF FF 1A B2 10 D5 E1 02 20 85 E2 03 00 51 E1 BC FF FF 1A B4 30 D5 E1 2F 00 53 E3 B9 FF FF 0A 5C 00 53 E3 02 20 8C 12 B6 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_177_0_2 {
	meta:
		name = "__kernel_tanf"
		size = 848
		refs = "0024 __fixsfsi 004c __divsf3 0078 __subsf3 0094 __addsf3 00a8 __mulsf3 0280 __floatsisf"
	strings:
		$1 = { F0 4F 2D E9 02 51 C0 E3 C6 05 55 E3 04 D0 4D E2 00 40 A0 E1 00 70 A0 E1 01 60 A0 E1 02 B0 A0 E1 0C 00 00 AA ?? ?? ?? ?? 00 00 50 E3 1B 00 00 1A 01 30 8B E2 05 30 93 E1 AE 00 00 0A 01 00 5B E3 8A 00 00 0A 04 10 A0 E1 BC 02 9F E5 ?? ?? ?? ?? 00 40 A0 E1 85 00 00 EA B0 32 9F E5 03 00 55 E1 0E 00 00 DA 00 00 50 E3 02 41 80 B2 02 61 81 B2 9C 02 9F E5 04 10 A0 E1 ?? ?? ?? ?? 06 10 A0 E1 00 40 A0 E1 8C 02 9F E5 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 60 A0 E3 00 40 A0 E1 04 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 00 A0 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 00 80 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 4C 12 9F E5 00 90 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 40 12 9F E5 ?? ?? ?? ?? 08 10 A0 E1 ?? ?? ?? ?? 34 12 9F E5 ?? ?? ?? ?? 08 10 A0 E1 ?? ?? ?? ?? 28 12 9F E5 ?? ?? ?? ?? 08 10 A0 E1 ?? ?? ?? ?? 1C 12 9F E5 ?? ?? ?? ?? 08 10 A0 E1 ?? ?? ?? ?? 10 12 9F E5 ?? ?? ?? ?? 0C 12 9F E5 00 30 A0 E1 08 00 A0 E1 00 30 8D E5 ?? ?? ?? ?? FC 11 9F E5 ?? ?? ?? ?? 08 10 A0 E1 ?? ?? ?? ?? F0 11 9F E5 ?? ?? ?? ?? 08 10 A0 E1 ?? ?? ?? ?? E4 11 9F E5 ?? ?? ?? ?? 08 10 A0 E1 ?? ?? ?? ?? D8 11 9F E5 ?? ?? ?? ?? 08 10 A0 E1 ?? ?? ?? ?? CC 11 9F E5 ?? ?? ?? ?? 0A 10 A0 E1 ?? ?? ?? ?? 00 30 9D E5 00 10 A0 E1 03 00 A0 E1 ?? ?? ?? ?? 09 10 A0 E1 ?? ?? ?? ?? 06 10 A0 E1 ?? ?? ?? ?? 0A 10 A0 E1 ?? ?? ?? ?? 06 10 A0 E1 ?? ?? ?? ?? 90 11 9F E5 00 60 A0 E1 09 00 A0 E1 ?? ?? ?? ?? 06 10 A0 E1 ?? ?? ?? ?? 00 80 A0 E1 08 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 2C 31 9F E5 00 60 A0 E1 03 00 55 E1 23 00 00 CA 01 00 5B E3 00 40 A0 01 1D 00 00 0A 00 10 A0 E1 FF 6E C0 E3 04 01 9F E5 ?? ?? ?? ?? 0F 60 C6 E3 04 10 A0 E1 00 50 A0 E1 FF 4E C0 E3 06 00 A0 E1 ?? ?? ?? ?? 0F 40 C4 E3 00 10 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 00 70 A0 E1 06 00 A0 E1 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 04 00 A0 E1 04 D0 8D E2 F0 8F BD E8 0B 00 A0 E1 ?? ?? ?? ?? 06 10 A0 E1 00 50 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 00 A0 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 08 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 03 11 A0 E3 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 47 7F A0 E1 00 40 A0 E1 02 00 07 E2 01 00 60 E2 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 DD FF FF EA 05 10 A0 E1 FE 05 A0 E3 ?? ?? ?? ?? 00 40 A0 E1 D8 FF FF EA 00 00 80 BF 3F A1 2C 3F DA 0F 49 3F 68 21 22 33 5F AE 9B B7 45 F4 A3 38 C8 26 1A 3A 16 69 6B 3B A4 27 B3 3C 89 88 08 3E 84 53 D9 37 7A C0 95 38 B9 37 81 39 48 DE BE 3A 1F 37 11 3C D1 0D 5D 3D AB AA AA 3E }
	condition:
		$1
}

rule file_178_0_2 {
	meta:
		name = "ldexpf"
		size = 140
		refs = "0010 __extendsfdf2 0024 __unorddf2 0044 __gtdf2 0064 __eqsf2 0084 scalbnf"
	strings:
		$1 = { F0 41 2D E9 00 40 A0 E1 02 01 C0 E3 01 60 A0 E1 ?? ?? ?? ?? 00 20 E0 E3 68 30 9F E5 00 70 A0 E1 01 80 A0 E1 ?? ?? ?? ?? 00 00 50 E3 00 50 A0 E3 06 00 00 1A 07 00 A0 E1 08 10 A0 E1 00 20 E0 E3 40 30 9F E5 ?? ?? ?? ?? 05 00 50 E1 00 00 00 DA 01 50 A0 E3 01 00 55 E3 04 00 00 0A 04 00 A0 E1 00 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 01 00 00 1A 04 00 A0 E1 F0 81 BD E8 04 00 A0 E1 06 10 A0 E1 F0 41 BD E8 ?? ?? ?? ?? FF FF EF 7F }
	condition:
		$1
}

rule file_179_0_2 {
	meta:
		name = "__kernel_tan"
		size = 1296
		refs = "0030 __fixdfsi 006c __divdf3 00a4 __subdf3 00d4 __adddf3 00f8 __muldf3 03b4 __floatsidf"
	strings:
		$1 = { F0 4F 2D E9 02 A1 C1 E3 01 40 A0 E1 01 B0 A0 E1 70 14 9F E5 18 D0 4D E2 01 00 5A E1 00 50 A0 E1 02 80 A0 E1 03 90 A0 E1 13 00 00 CA 04 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 2A 00 00 1A 3C 20 9D E5 05 A0 8A E1 01 30 82 E2 03 30 9A E1 05 01 00 0A 3C 30 9D E5 01 00 53 E3 D0 00 00 0A 05 20 A0 E1 04 30 A0 E1 00 00 A0 E3 1C 14 9F E5 ?? ?? ?? ?? 00 50 A0 E1 01 40 A0 E1 C8 00 00 EA 0C 34 9F E5 03 00 5A E1 17 00 00 DA 00 00 54 E3 02 41 84 B2 00 20 A0 E1 04 30 A0 E1 F4 03 9F E5 F4 13 9F E5 02 91 89 B2 ?? ?? ?? ?? 08 20 A0 E1 00 40 A0 E1 01 50 A0 E1 09 30 A0 E1 DC 03 9F E5 DC 13 9F E5 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 80 A0 E3 00 50 A0 E1 01 40 A0 E1 08 90 A0 E1 05 20 A0 E1 04 30 A0 E1 05 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 03 00 8D E8 ?? ?? ?? ?? 05 20 A0 E1 00 60 A0 E1 01 70 A0 E1 04 30 A0 E1 03 00 9D E8 ?? ?? ?? ?? 78 23 9F E5 08 00 8D E5 0C 10 8D E5 70 33 9F E5 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 64 23 9F E5 64 33 9F E5 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? 54 23 9F E5 54 33 9F E5 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? 44 23 9F E5 44 33 9F E5 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? 34 23 9F E5 34 33 9F E5 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? 24 23 9F E5 24 33 9F E5 ?? ?? ?? ?? 20 23 9F E5 10 00 8D E5 14 10 8D E5 18 33 9F E5 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 0C 23 9F E5 0C 33 9F E5 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? FC 22 9F E5 FC 32 9F E5 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? EC 22 9F E5 EC 32 9F E5 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? DC 22 9F E5 DC 32 9F E5 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? CC 22 9F E5 CC 32 9F E5 ?? ?? ?? ?? 0C 00 9D E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 10 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 08 30 8D E2 0C 00 93 E8 ?? ?? ?? ?? 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? 0C 00 9D E8 ?? ?? ?? ?? 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? 80 22 9F E5 00 60 A0 E1 01 70 A0 E1 78 32 9F E5 08 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? 03 00 8D E8 0C 00 9D E8 05 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? D0 31 9F E5 00 60 A0 E1 03 00 5A E1 01 80 A0 E1 38 00 00 CA 3C 20 9D E5 01 00 52 E3 00 50 A0 01 01 40 A0 01 2F 00 00 0A 01 70 A0 E1 00 20 A0 E1 01 30 A0 E1 00 00 A0 E3 94 11 9F E5 ?? ?? ?? ?? 00 60 A0 E3 01 B0 A0 E1 05 20 A0 E1 04 30 A0 E1 00 A0 A0 E1 07 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 03 00 9D E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 06 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 06 80 A0 E1 07 90 A0 E1 00 60 A0 E1 01 70 A0 E1 08 20 A0 E1 09 30 A0 E1 08 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E3 A0 31 9F E5 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 06 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 0A 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? 08 20 A0 E1 0B 30 A0 E1 ?? ?? ?? ?? 00 50 A0 E1 01 40 A0 E1 05 00 A0 E1 04 10 A0 E1 18 D0 8D E2 F0 8F BD E8 3C 00 9D E5 ?? ?? ?? ?? 06 20 A0 E1 00 90 A0 E1 01 A0 A0 E1 08 30 A0 E1 06 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 09 20 A0 E1 08 00 8D E5 0C 10 8D E5 0A 30 A0 E1 06 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 08 10 8D E2 03 00 91 E8 ?? ?? ?? ?? 0C 00 9D E8 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 05 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E3 03 31 A0 E3 ?? ?? ?? ?? 09 20 A0 E1 0A 30 A0 E1 ?? ?? ?? ?? 4B BF A0 E1 00 40 A0 E1 02 00 0B E2 01 50 A0 E1 01 00 60 E2 ?? ?? ?? ?? 04 20 A0 E1 05 30 A0 E1 ?? ?? ?? ?? 00 50 A0 E1 01 40 A0 E1 CD FF FF EA 05 20 A0 E1 02 31 C4 E3 00 00 A0 E3 90 10 9F E5 ?? ?? ?? ?? 00 50 A0 E1 01 40 A0 E1 C5 FF FF EA FF FF 2F 3E 00 00 F0 BF 27 94 E5 3F 18 2D 44 54 FB 21 E9 3F 07 5C 14 33 26 A6 81 3C 73 53 60 DB CB 75 F3 BE A6 92 37 A0 88 7E 14 3F 01 65 F2 F2 D8 44 43 3F 28 03 56 C9 22 6D 6D 3F 37 D6 06 84 F4 64 96 3F 7A FE 10 11 11 11 C1 3F D4 7A BF 74 70 2A FB 3E E9 A7 F0 32 0F B8 12 3F 68 10 8D 1A F7 26 30 3F 15 83 E0 FE C8 DB 57 3F 93 84 6E E9 E3 26 82 3F FE 41 B3 1B BA A1 AB 3F 63 55 55 55 55 55 D5 3F 00 00 F0 3F }
	condition:
		$1
}

rule file_180_0_2 {
	meta:
		name = "__ieee754_log10f"
		size = 256
		refs = "0030 __mulsf3 0050 __addsf3 0068 __floatsisf 0080 __ieee754_logf 00d8 __divsf3 00e0 __subsf3"
	strings:
		$1 = { 02 05 50 E3 70 40 2D E9 00 10 A0 E1 00 50 A0 E1 00 20 A0 A3 09 00 00 AA 02 31 C0 E3 00 00 53 E3 2A 00 00 0A 00 00 50 E3 2C 00 00 BA 13 13 A0 E3 ?? ?? ?? ?? 18 20 E0 E3 00 10 A0 E1 00 50 A0 E1 A8 30 9F E5 03 00 55 E1 02 00 00 DA 01 00 A0 E1 ?? ?? ?? ?? 70 80 BD E8 7F 20 42 E2 C5 0B 82 E0 A0 6F A0 E1 00 00 86 E0 ?? ?? ?? ?? FF 54 C5 E3 00 40 A0 E1 02 55 C5 E3 7F 00 66 E2 80 0B 85 E1 ?? ?? ?? ?? 68 10 9F E5 00 60 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 5C 10 9F E5 00 50 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 50 10 9F E5 00 40 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 70 80 BD E8 00 10 A0 E3 33 03 A0 E3 ?? ?? ?? ?? 70 80 BD E8 ?? ?? ?? ?? 00 10 A0 E3 ?? ?? ?? ?? 70 80 BD E8 FF FF 7F 7F 80 20 9A 3E DB 27 54 35 D9 5B DE 3E }
	condition:
		$1
}

rule file_181_0_2 {
	meta:
		name = "llrint"
		size = 384
		refs = "0058 __adddf3 0064 __subdf3 017c .rdata"
	strings:
		$1 = { 70 48 2D E9 21 4A A0 E1 84 3A A0 E1 A3 3A A0 E1 FF 3F 43 E2 03 30 43 E2 01 00 73 E3 00 20 A0 B3 00 30 A0 B3 2B 00 00 BA 3E 00 53 E3 C4 45 A0 E1 2B 00 00 CA 33 00 53 E3 0A 00 00 CA 01 30 A0 E1 34 11 9F E5 00 20 A0 E1 84 11 81 E0 60 00 91 E8 05 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 21 3A A0 E1 83 3A A0 E1 A3 3A A0 E1 FF 3F 43 E2 FF 24 C1 E3 03 30 43 E2 01 60 A0 E1 0F 26 C2 E3 34 10 53 E2 00 50 A0 E1 01 26 82 E3 32 00 00 4A 1F 00 51 E3 20 00 00 DA 00 50 A0 E3 00 60 A0 E3 20 30 91 E2 23 00 00 4A 1F 00 53 E3 00 B0 A0 C3 00 C0 A0 C3 10 00 00 DA 05 20 8B E1 06 30 8C E1 00 00 54 E3 01 00 00 0A 00 20 72 E2 00 30 E3 E2 03 10 A0 E1 02 00 A0 E1 70 88 BD E8 00 00 54 E3 00 20 E0 03 02 31 E0 03 00 20 A0 13 02 31 A0 13 03 10 A0 E1 02 00 A0 E1 70 88 BD E8 20 00 63 E2 32 00 A0 E1 00 00 51 E3 00 C0 A0 E1 12 C1 A0 A1 12 23 A0 E1 02 B0 A0 E1 E6 FF FF EA 20 C0 61 E2 30 6C A0 E1 54 30 53 E2 10 63 A0 51 20 30 91 E2 10 51 A0 E1 DB FF FF 5A 1F 00 73 E3 00 30 63 A2 32 23 A0 A1 00 20 A0 B3 00 30 A0 A3 00 30 A0 B3 05 20 82 E1 06 30 83 E1 D8 FF FF EA 1F 00 71 E3 00 50 61 A2 30 55 A0 A1 00 60 A0 A3 CB FF FF AA C8 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_182_0_2 {
	meta:
		name = "_fdopen"
		size = 76
		refs = "0014 strlen 0030 mbstowcs 0040 _wfdopen"
	strings:
		$1 = { 70 40 2D E9 00 40 A0 E1 80 D0 4D E2 01 00 A0 E1 01 60 A0 E1 ?? ?? ?? ?? 01 20 80 E2 40 00 52 E3 00 00 A0 83 06 00 00 8A 06 10 A0 E1 0D 00 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 0D 10 A0 E1 0D 50 A0 E1 ?? ?? ?? ?? 80 D0 8D E2 70 80 BD E8 }
	condition:
		$1
}

rule file_183_0_2 {
	meta:
		name = "ilogb"
		size = 164
	strings:
		$1 = { 02 31 C1 E3 01 06 53 E3 04 40 2D E5 01 40 A0 E1 07 00 00 BA 7C 20 9F E5 02 00 53 E1 43 3A A0 D1 FF 0F 43 D2 02 01 E0 C3 03 00 40 D2 10 00 BD E8 0E F0 A0 E1 00 10 93 E1 00 20 A0 E1 06 01 A0 03 F9 FF FF 0A 00 00 53 E3 08 00 00 1A 00 00 52 E3 44 00 9F D5 F4 FF FF DA 3C 00 9F E5 82 20 A0 E1 00 00 52 E3 01 00 40 E2 FB FF FF CA EE FF FF EA 83 35 A0 E1 00 00 53 E3 20 00 9F D5 EA FF FF DA 18 00 9F E5 83 30 A0 E1 00 00 53 E3 01 00 40 E2 FB FF FF CA E4 FF FF EA FF FF EF 7F ED FB FF FF 02 FC FF FF }
	condition:
		$1
}

rule file_184_0_2 {
	meta:
		name = "btowc"
		size = 88
		refs = "0044 MultiByteToWideChar"
	strings:
		$1 = { 04 E0 2D E5 01 00 70 E3 00 C0 A0 E1 0C D0 4D E2 3C 00 9F 05 0C 00 00 0A 08 10 A0 E3 01 E0 A0 E3 0B C0 CD E5 01 C0 8D E0 00 C0 8D E5 0E 30 A0 E1 00 C0 E0 E3 00 00 A0 E3 0B 20 8D E2 B8 C0 CD E1 04 E0 8D E5 ?? ?? ?? ?? B8 00 DD E1 0C D0 8D E2 00 80 BD E8 FF FF 00 00 }
	condition:
		$1
}

rule file_185_0_2 {
	meta:
		name = "__strtod"
		size = 200
		refs = "0018 __strtodg 002c .text 00bc .data"
	strings:
		$1 = { 30 40 2D E9 10 D0 4D E2 0C 30 8D E2 04 C0 8D E2 A4 20 9F E5 00 C0 8D E5 ?? ?? ?? ?? 07 30 00 E2 06 00 53 E3 03 F1 9F 97 0A 00 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 08 30 9D E5 04 40 9D E5 7F 54 83 E3 0F 56 85 E3 08 00 10 E3 02 51 85 13 04 00 A0 E1 05 10 A0 E1 10 D0 8D E2 30 80 BD E8 00 50 A0 E3 05 40 A0 E1 F6 FF FF EA 0C 30 9D E5 08 20 9D E5 43 3E 83 E2 03 30 83 E2 01 26 C2 E3 04 40 9D E5 03 5A 82 E1 EE FF FF EA 30 00 9D E9 EC FF FF EA 14 50 9F E5 00 40 A0 E3 E9 FF FF EA 00 40 A0 E3 08 50 9F E5 E6 FF FF EA ?? ?? ?? ?? 00 00 F0 7F 00 00 F8 FF }
	condition:
		$1
}

rule file_186_0_2 {
	meta:
		name = "trecurse"
		size = 160
	strings:
		$1 = { 04 30 90 E5 70 40 2D E9 00 00 53 E3 00 40 A0 E1 01 50 A0 E1 02 60 A0 E1 19 00 00 0A 04 00 A0 E1 00 10 A0 E3 06 20 A0 E1 0F E0 A0 E1 05 F0 A0 E1 04 00 94 E5 00 00 50 E3 05 10 A0 11 01 20 86 12 EE FF FF 1B 04 00 A0 E1 01 10 A0 E3 06 20 A0 E1 0F E0 A0 E1 05 F0 A0 E1 08 00 94 E5 00 00 50 E3 05 10 A0 11 01 20 86 12 E4 FF FF 1B 04 00 A0 E1 06 20 A0 E1 02 10 A0 E3 0F E0 A0 E1 05 F0 A0 E1 70 80 BD E8 08 30 90 E5 00 00 53 E3 E2 FF FF 1A 03 10 A0 E3 0F E0 A0 E1 05 F0 A0 E1 70 80 BD E8 }
	condition:
		$1
}

rule file_186_1_2 {
	meta:
		name = "twalk"
		size = 20
	strings:
		$1 = { 00 00 51 E3 00 00 50 13 0E F0 A0 01 00 20 A0 E3 D2 FF FF EA }
	condition:
		$1
}

rule file_187_0_2 {
	meta:
		name = "getopt_argerror"
		size = 148
		refs = "0048 _getstdfilex 0054 fprintf 0088 .data 008c .rdata"
	strings:
		$1 = { F0 41 2D E9 7C 40 9F E5 04 D0 4D E2 00 C0 94 E5 01 60 A0 E1 00 00 5C E3 02 80 A0 E1 03 50 A0 E1 13 00 00 0A 60 30 9F E5 01 00 50 E3 00 30 93 E5 02 00 A0 E3 23 28 A0 E1 B0 30 CD E1 00 30 A0 13 01 30 CD 15 02 20 CD E5 ?? ?? ?? ?? 08 20 A0 E1 38 10 9F E5 ?? ?? ?? ?? 02 00 A0 E3 ?? ?? ?? ?? 06 10 A0 E1 0D 20 A0 E1 00 30 95 E5 0D 70 A0 E1 ?? ?? ?? ?? 0C 30 95 E5 1C 00 9D E5 04 30 84 E5 04 D0 8D E2 F0 81 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_187_1_2 {
	meta:
		name = "getopt_parse"
		size = 2804
		refs = "06c8 _getstdfilex 06d4 fprintf 0aac __mingw_optreset 0ab0 .data 0ab4 .bss 0ac8 optarg 0ad0 .rdata"
	strings:
		$1 = { 04 30 2D E5 F0 4F 2D E9 9C 3A 9F E5 20 B0 8D E2 98 9A 9F E5 48 D0 4D E2 00 40 93 E5 08 C0 99 E5 34 00 0B E5 00 00 5C E3 01 40 84 D3 00 00 54 E3 2C 10 0B E5 00 40 83 E5 A4 00 00 0A 00 C0 A0 E3 01 10 A0 E3 68 AA 9F E5 08 10 89 E5 00 C0 83 E5 60 5A 9F E5 60 6A 9F E5 60 4A 9F E5 00 30 A0 E3 00 C0 86 E5 00 30 84 E5 00 C0 85 E5 00 C0 8A E5 00 00 95 E5 01 30 80 E2 00 30 8A E5 08 C0 8B E2 04 C0 8C E2 04 10 8C E2 34 8A 9F E5 30 C0 0B E5 4C 10 0B E5 50 A0 0B E5 2C A0 1B E5 00 30 85 E5 03 00 5A E1 03 70 A0 E1 1B 00 00 DA 03 11 92 E7 00 30 86 E5 00 10 84 E5 D0 C0 D1 E1 03 31 82 E0 2D 00 5C E3 1F 00 00 0A 04 30 9B E5 D0 10 D3 E1 2D 00 51 E3 5C 01 00 0A 00 30 98 E5 00 00 53 E3 09 00 00 1A 01 0A 11 E3 13 00 00 1A D0 A9 9F E5 01 3A A0 E3 2B 00 51 E3 00 30 8A E5 00 01 00 0A 00 00 95 E5 01 30 80 E2 E2 FF FF EA 01 0A 11 E3 09 00 00 1A 10 00 13 E3 F8 FF FF 0A 50 A0 1B E5 00 30 9A E5 00 00 E0 E3 08 30 89 E5 20 D0 4B E2 F0 4F BD E8 04 D0 8D E2 0E F0 A0 E1 01 30 83 E1 00 30 88 E5 F2 FF FF EA 70 A9 9F E5 01 C0 81 E2 00 C0 8A E5 01 10 D1 E5 00 00 51 E3 D9 FF FF 0A 2D 00 51 E3 11 01 00 0A 34 30 1B E5 01 00 53 E3 EE 00 00 DA 30 A0 1B E5 08 C0 9B E5 4C 00 1B E5 40 19 9F E5 00 A0 9A E5 00 30 A0 E3 00 00 5C E3 38 C0 0B E5 28 00 0B E5 00 30 81 E5 5C A0 0B E5 CF 00 00 0A 00 10 9C E5 03 00 51 E1 CC 00 00 0A 00 C0 94 E5 38 00 1B E5 01 30 8C E2 3C C0 0B E5 38 A0 1B E5 60 30 0B E5 3C 30 1B E5 10 00 80 E2 44 00 0B E5 48 A0 0B E5 01 C0 A0 E3 00 00 E0 E3 02 30 83 E2 50 A0 1B E5 40 C0 0B E5 58 00 0B E5 54 30 0B E5 06 70 A0 E1 3C 60 1B E5 40 C0 1B E5 00 00 D6 E5 01 C0 4C E2 00 00 50 E3 50 C0 0B E5 11 00 00 0A D0 30 D1 E1 00 0C A0 E1 40 0C 53 E1 43 01 00 1A 54 30 1B E5 02 C0 A0 E1 04 00 00 EA D0 20 D1 E1 03 60 A0 E1 40 0C 52 E1 01 30 83 E2 95 00 00 1A 01 20 53 E5 01 10 81 E2 00 00 52 E3 02 0C A0 E1 F5 FF FF 1A 0C 20 A0 E1 D0 30 D1 E1 00 00 53 E3 AB 00 00 1A 5C 10 1B E5 00 30 84 E5 00 00 51 E3 50 30 1B 15 00 30 81 15 00 30 95 E5 40 58 9F E5 01 30 83 E2 00 10 95 E5 08 30 89 E5 00 00 51 E3 14 18 9F E5 27 01 00 0A 48 60 1B E5 04 30 96 E5 00 00 53 E3 F8 00 00 0A 48 C0 1B E5 08 30 9C E5 00 00 53 E3 0C 20 9C 15 48 10 1B 05 00 00 A0 13 00 20 83 15 0C 00 91 05 96 FF FF EA DC A7 9F E5 00 30 9A E5 03 00 5C E1 01 C0 4C B2 5A FF FF BA D4 47 9F E5 00 C0 94 E5 00 00 5C E3 2C 00 00 0A 00 00 DC E5 00 00 50 E3 29 00 00 0A 00 0C A0 E1 40 3C A0 E1 04 10 9B E5 01 50 8C E2 04 30 89 E5 00 50 84 E5 00 30 D1 E5 40 0C A0 E1 03 3C A0 E1 2B 04 53 E3 2D 04 53 13 04 60 9B 05 01 30 D6 05 01 10 86 02 03 3C A0 01 3A 04 53 E3 01 30 F1 05 03 3C A0 01 00 00 00 EA 03 3C A0 E1 43 0C 50 E1 7F 00 00 0A 01 30 F1 E5 00 00 53 E3 F9 FF FF 1A 34 00 1B E5 02 00 50 E3 C0 00 00 0A 00 30 99 E5 00 00 53 E3 E2 00 00 1A 00 00 55 E3 02 00 00 0A D0 30 D5 E1 00 00 53 E3 A5 00 00 1A 20 37 9F E5 00 30 93 E5 01 30 83 E2 08 30 89 E5 3F 00 A0 E3 60 FF FF EA 0C 67 9F E5 00 10 96 E5 01 00 53 E1 FC 56 9F A5 2C FF FF AA F4 56 9F E5 00 80 96 E5 00 10 95 E5 30 D0 0B E5 01 10 81 E2 01 10 68 E0 01 31 A0 E1 08 30 83 E2 03 D0 4D E0 0B C0 8D E2 00 00 51 E3 07 C0 CC E3 08 00 00 DA 08 01 82 E0 00 30 A0 E3 02 70 A0 E1 04 20 90 E4 03 21 8C E7 01 30 83 E2 01 00 53 E1 FA FF FF 1A 07 20 A0 E1 00 00 9A E5 01 30 48 E2 03 00 50 E1 00 30 86 E5 08 00 00 CA 0C 80 A0 E1 01 C0 83 E0 03 71 92 E7 01 30 43 E2 03 00 50 E1 0C 71 82 E7 F9 FF FF DA 08 C0 A0 E1 00 30 86 E5 00 00 51 E3 0B 00 00 DA 00 70 9A E5 00 30 A0 E3 05 80 A0 E1 03 00 80 E0 03 51 9C E7 01 30 83 E2 01 00 53 E1 00 51 82 E7 07 00 A0 E1 F8 FF FF 1A 00 00 9A E5 08 50 A0 E1 01 10 80 E0 00 10 8A E5 00 00 95 E5 30 D0 1B E5 01 30 80 E2 F7 FE FF EA 0C 20 A0 E1 3D 04 50 E3 28 00 00 0A 44 60 1B E5 40 00 1B E5 06 C0 A0 E1 10 10 9C E4 01 00 80 E2 00 00 51 E3 48 60 0B E5 44 C0 0B E5 40 00 0B E5 49 FF FF 1A 58 30 1B E5 07 60 A0 E1 01 00 73 E3 50 A0 0B E5 08 01 00 1A 34 10 1B E5 01 00 51 E3 1F 01 00 0A 00 30 94 E5 D0 30 D3 E1 00 00 53 E3 F1 FE FF 0A 0C 00 00 EA C0 25 9F E5 B4 35 9F E5 50 A0 1B E5 00 20 83 E5 01 FF FF EA 58 60 1B E5 01 00 76 E3 B3 00 00 1A 50 30 1B E5 58 30 0B E5 DD FF FF EA 00 50 A0 E3 34 50 0B E5 34 00 1B E5 2C 10 1B E5 04 30 9B E5 AD FE FF EB F7 FE FF EA 74 05 9F E5 00 60 80 E5 40 FF FF EA 00 00 51 E3 80 FF FF 0A D1 30 D1 E1 3A 00 53 E3 1B 00 00 0A 54 35 9F E5 00 20 A0 E3 00 00 55 E3 00 20 83 E5 02 00 00 0A D1 30 DC E1 00 00 53 E3 05 00 00 1A 24 35 9F E5 00 30 93 E5 01 30 83 E2 08 30 89 E5 04 00 99 E5 E1 FE FF EA 0C 35 9F E5 00 30 93 E5 F9 FF FF EA D1 10 DC E1 01 C0 8C E2 00 00 51 E3 BC 00 00 0A 34 00 1B E5 00 00 50 E3 DA FF FF DA 01 10 A0 E3 00 C0 8A E5 34 10 0B E5 E5 FE FF EA E4 04 9F E5 00 50 80 E5 D1 30 DC E1 00 00 53 E3 10 00 00 1A D2 10 D1 E1 3A 00 51 E3 5E 00 00 0A B4 14 9F E5 2C A0 1B E5 00 30 91 E5 0A C0 63 E0 01 00 5C E3 67 00 00 DA 01 30 83 E2 03 21 92 E7 00 30 81 E5 00 20 80 E5 04 00 00 EA 88 34 9F E5 00 30 93 E5 59 FF FF EA 7C 34 9F E5 00 30 93 E5 00 20 A0 E3 00 20 84 E5 01 30 83 E2 D2 FF FF EA 00 30 95 E5 00 10 A0 E3 00 10 84 E5 03 21 92 E7 01 30 83 E2 08 30 89 E5 5C 34 9F E5 01 00 A0 E3 00 20 83 E5 AD FE FF EA 00 30 99 E5 00 00 53 E3 41 00 00 1A 00 30 A0 E3 00 30 84 E5 04 30 89 E5 3F FF FF EA 00 10 91 E5 00 50 92 E5 00 00 51 E3 14 00 00 0A 28 24 9F E5 34 A0 1B E5 00 20 92 E5 24 40 4B E2 22 18 A0 E1 01 00 5A E3 02 10 C4 E5 02 00 A0 E3 B4 22 4B E1 23 30 4B 15 ?? ?? ?? ?? 05 20 A0 E1 FC 13 9F E5 ?? ?? ?? ?? 02 00 A0 E3 ?? ?? ?? ?? 48 C0 1B E5 04 20 A0 E1 E8 13 9F E5 00 30 9C E5 ?? ?? ?? ?? 48 00 1B E5 0C 30 90 E5 3F 00 A0 E3 04 30 89 E5 88 FE FF EA 02 00 A0 E3 64 20 0B E5 ?? ?? ?? ?? 64 20 1B E5 90 33 9F E5 00 20 92 E5 04 30 93 E5 B0 13 9F E5 ?? ?? ?? ?? 00 50 94 E5 11 FF FF EA 60 60 1B E5 58 FF FF EA 48 50 1B E5 04 00 95 E5 01 00 50 E3 D7 FE FF 1A 2C 60 1B E5 03 00 56 E1 45 00 00 DA 03 C1 92 E7 01 20 83 E2 60 03 9F E5 08 20 81 E5 48 23 9F E5 00 C0 80 E5 00 30 82 E5 CC FE FF EA 00 30 80 E5 34 33 9F E5 00 30 93 E5 AC FF FF EA 64 20 0B E5 ?? ?? ?? ?? 00 C0 94 E5 64 20 1B E5 01 C0 4C E2 00 20 92 E5 0C 30 A0 E1 34 13 9F E5 00 C0 84 E5 ?? ?? ?? ?? B2 FF FF EA 00 30 99 E5 00 00 53 E3 21 00 00 1A 04 C0 9B E5 00 30 DC E5 03 3C A0 E1 2B 04 53 E3 2D 04 53 13 01 30 DC 05 03 3C A0 01 43 3C A0 E1 3A 00 53 E3 03 00 A0 01 4F FE FF 0A 3F 00 A0 E3 4D FE FF EA 00 30 99 E5 00 10 95 E5 00 00 53 E3 01 10 81 E2 00 30 A0 E3 00 30 84 E5 08 10 89 E5 04 30 89 E5 F4 FF FF 0A 02 00 A0 E3 64 20 0B E5 ?? ?? ?? ?? 8C 32 9F E5 B4 12 9F E5 00 30 93 E5 64 20 1B E5 03 31 92 E7 00 20 92 E5 ?? ?? ?? ?? 3F 00 A0 E3 38 FE FF EA 02 00 A0 E3 64 20 0B E5 ?? ?? ?? ?? 64 20 1B E5 50 32 9F E5 00 20 92 E5 04 30 93 E5 7C 12 9F E5 ?? ?? ?? ?? D3 FF FF EA 04 A0 9B E5 00 20 92 E5 00 30 DA E5 68 12 9F E5 03 3C A0 E1 2B 04 53 E3 2D 04 53 13 01 30 DA 05 03 3C A0 01 3A 04 53 E3 3A 30 A0 03 3F 30 A0 13 00 30 8D E5 34 00 1B E5 48 30 1B E5 AE FD FF EB 1D FE FF EA 50 A0 1B E5 00 10 9A E5 07 00 51 E1 0B 00 00 AA 00 30 93 E5 01 C0 47 E2 0C C1 92 E7 07 C1 82 E7 00 70 A0 E1 01 00 40 E2 02 C0 80 E2 0C 00 51 E1 F7 FF FF BA 00 10 9A E5 00 70 86 E5 01 31 82 E7 01 10 81 E2 08 10 89 E5 00 10 8A E5 00 00 E0 E3 08 FE FF EA 5C 60 1B E5 B4 A1 9F E5 00 00 56 E3 00 30 86 15 00 10 84 E5 00 30 95 E5 00 10 9A E5 01 30 83 E2 00 00 51 E3 08 30 89 E5 78 11 9F E5 3A 00 00 0A 58 C0 1B E5 38 00 1B E5 0C 62 A0 E1 06 50 80 E0 04 30 95 E5 00 00 53 E3 16 00 00 0A 08 30 95 E5 00 00 53 E3 0C 20 95 15 00 00 A0 13 00 20 83 15 0C 00 95 05 EE FD FF EA 00 30 99 E5 00 10 95 E5 00 00 53 E3 01 10 81 E2 00 30 A0 E3 00 30 84 E5 08 10 89 E5 04 30 89 E5 95 FF FF 0A 02 00 A0 E3 64 20 0B E5 ?? ?? ?? ?? 10 31 9F E5 44 11 9F E5 00 30 93 E5 9F FF FF EA 00 10 91 E5 00 70 92 E5 00 00 51 E3 14 00 00 0A 08 21 9F E5 34 10 1B E5 00 20 92 E5 01 00 51 E3 24 40 4B E2 22 18 A0 E1 02 10 C4 E5 02 00 A0 E3 B4 22 4B E1 23 30 4B 15 ?? ?? ?? ?? 07 20 A0 E1 DC 10 9F E5 ?? ?? ?? ?? 02 00 A0 E3 ?? ?? ?? ?? 38 20 1B E5 CC 10 9F E5 06 30 92 E7 04 20 A0 E1 ?? ?? ?? ?? 0C 30 95 E5 3F 00 A0 E3 04 30 89 E5 C1 FD FF EA 38 60 1B E5 58 A0 1B E5 0A 52 86 E0 04 00 95 E5 01 00 50 E3 C5 FF FF 1A 2C C0 1B E5 03 00 5C E1 07 00 00 DA 03 C1 92 E7 01 20 83 E2 70 00 9F E5 08 20 81 E5 58 20 9F E5 00 C0 80 E5 00 30 82 E5 BA FF FF EA 04 00 9B E5 00 20 92 E5 00 30 D0 E5 70 10 9F E5 03 3C A0 E1 2B 04 53 E3 2D 04 53 13 01 30 D0 05 03 3C A0 01 3A 04 53 E3 3A 30 A0 03 3F 30 A0 13 00 30 8D E5 34 00 1B E5 05 30 A0 E1 30 FD FF EB 9F FD FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 10 10 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_187_2_2 {
	meta:
		name = "getopt_long_only"
		size = 56
	strings:
		$1 = { 04 E0 2D E5 02 C0 A0 E1 08 D0 4D E2 01 E0 A0 E1 00 30 8D E5 0C 30 A0 E1 0C C0 9D E5 00 10 A0 E1 0E 20 A0 E1 02 00 A0 E3 04 C0 8D E5 36 FD FF EB 08 D0 8D E2 00 80 BD E8 }
	condition:
		$1
}

rule file_187_3_2 {
	meta:
		name = "getopt_long"
		size = 56
	strings:
		$1 = { 04 E0 2D E5 02 C0 A0 E1 08 D0 4D E2 01 E0 A0 E1 00 30 8D E5 0C 30 A0 E1 0C C0 9D E5 00 10 A0 E1 0E 20 A0 E1 01 00 A0 E3 04 C0 8D E5 28 FD FF EB 08 D0 8D E2 00 80 BD E8 }
	condition:
		$1
}

rule file_187_4_2 {
	meta:
		name = "getopt"
		size = 24
	strings:
		$1 = { 01 C0 A0 E1 02 30 A0 E1 00 10 A0 E1 0C 20 A0 E1 00 00 A0 E3 20 FD FF EA }
	condition:
		$1
}

rule file_189_0_2 {
	meta:
		name = "scalbnf"
		size = 304
		refs = "0030 __mulsf3 00e4 __addsf3"
	strings:
		$1 = { 0C 31 9F E5 10 40 2D E9 03 30 00 E0 C3 3B B0 E1 00 20 A0 E1 00 C0 A0 E1 01 40 A0 E1 18 00 00 1A 02 C1 C0 E3 00 00 5C E3 13 00 00 0A 13 13 A0 E3 ?? ?? ?? ?? DC 30 9F E5 00 20 A0 E1 03 00 54 E1 21 00 00 BA C8 30 9F E5 00 C0 A0 E1 03 30 00 E0 C3 3B A0 E1 19 30 43 E2 04 30 83 E0 FE 00 53 E3 0C 00 00 DA 00 00 52 E3 AC 00 9F E5 A8 10 9F E5 A8 00 9F B5 ?? ?? ?? ?? 00 20 A0 E1 02 00 A0 E1 10 80 BD E8 FF 00 53 E3 14 00 00 0A 04 30 83 E0 FE 00 53 E3 F2 FF FF CA 00 00 53 E3 7F 24 CC C3 02 25 C2 C3 83 2B 82 C1 F3 FF FF CA 18 00 73 E3 0F 00 00 AA 68 30 9F E5 03 00 54 E1 E8 FF FF CA 00 00 52 E3 5C 00 9F E5 5C 00 9F B5 54 10 9F E5 ?? ?? ?? ?? 00 20 A0 E1 02 00 A0 E1 10 80 BD E8 00 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 02 00 A0 E1 10 80 BD E8 7F C4 CC E3 19 30 83 E2 02 C5 CC E3 83 0B 8C E1 33 14 A0 E3 ?? ?? ?? ?? 00 20 A0 E1 D9 FF FF EA 00 00 80 7F B0 3C FF FF CA F2 49 71 CA F2 49 F1 50 C3 00 00 60 42 A2 0D 60 42 A2 8D }
	condition:
		$1
}

rule file_191_0_2 {
	meta:
		name = "__rshift_D2A"
		size = 232
	strings:
		$1 = { F0 01 2D E9 10 40 90 E5 C1 32 A0 E1 14 20 80 E2 04 00 53 E1 02 C0 A0 E1 1D 00 00 AA 04 30 83 E2 04 41 80 E0 03 31 80 E0 1F 10 11 E2 14 40 84 E2 04 50 83 E2 1D 00 00 0A 04 60 93 E5 04 30 85 E2 03 00 54 E1 36 61 A0 E1 20 80 61 E2 0D 00 00 9A 00 C0 A0 E3 00 70 93 E5 17 68 86 E1 0C 60 82 E7 04 60 93 E4 04 C0 8C E2 03 00 54 E1 36 61 A0 E1 F7 FF FF 8A 04 C0 65 E0 05 C0 4C E2 03 C0 CC E3 0C C0 80 E0 18 C0 8C E2 00 00 56 E3 00 60 8C E5 04 C0 8C 12 0C 20 62 E0 42 21 A0 E1 00 00 52 E3 10 20 80 E5 14 20 80 05 F0 01 BD E8 0E F0 A0 E1 05 00 54 E1 F6 FF FF 9A 01 30 95 E7 01 30 82 E7 04 10 81 E2 01 30 85 E0 03 00 54 E1 F9 FF FF 8A 05 C0 E0 E1 04 C0 8C E0 03 C0 CC E3 0C C0 80 E0 18 C0 8C E2 EA FF FF EA }
	condition:
		$1
}

rule file_191_1_2 {
	meta:
		name = "__trailz_D2A"
		size = 108
		refs = "005c __ctzsi2"
	strings:
		$1 = { 10 20 90 E5 14 30 80 E2 02 21 80 E0 14 20 82 E2 02 00 53 E1 10 40 2D E9 00 40 A0 23 0A 00 00 2A 14 40 90 E5 00 00 54 E3 03 00 00 0A 08 00 00 EA 00 00 93 E5 00 00 50 E3 07 00 00 1A 04 30 83 E2 03 00 52 E1 20 40 84 E2 F8 FF FF 8A 04 00 A0 E1 10 80 BD E8 04 00 A0 E1 00 40 A0 E3 ?? ?? ?? ?? 00 40 84 E0 04 00 A0 E1 10 80 BD E8 }
	condition:
		$1
}

rule file_193_0_2 {
	meta:
		name = "asinh"
		size = 456
		refs = "0034 __adddf3 0040 __gtdf2 005c __muldf3 0074 sqrt 0094 __divdf3 00b0 log1p 0168 log"
	strings:
		$1 = { A0 21 9F E5 02 31 C1 E3 02 00 53 E1 F0 4D 2D E9 01 60 A0 E1 01 50 A0 E1 00 40 A0 E1 53 00 00 CA 84 21 9F E5 02 00 53 E1 29 00 00 CA 7C 21 9F E5 7C 31 9F E5 ?? ?? ?? ?? 00 20 A0 E3 74 31 9F E5 ?? ?? ?? ?? 00 00 50 E3 1E 00 00 CA 06 30 A0 E1 04 20 A0 E1 06 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 20 A0 E3 4C 31 9F E5 00 70 A0 E1 01 80 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 00 20 A0 E3 34 31 9F E5 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 02 61 C6 E3 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 55 E3 00 40 A0 C1 01 60 A0 C1 00 40 A0 D1 02 61 81 D2 04 00 A0 E1 06 10 A0 E1 F0 8D BD E8 E0 20 9F E5 02 00 53 E1 2B 00 00 CA 01 01 53 E3 D8 FF FF DA 04 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 00 20 A0 E3 B8 30 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? 02 61 C6 E3 00 70 A0 E1 01 80 A0 E1 04 20 A0 E1 06 30 A0 E1 04 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 04 20 A0 E1 00 A0 A0 E1 01 B0 A0 E1 06 30 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 00 00 A0 E3 64 10 9F E5 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? D0 FF FF EA 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 01 60 A0 E1 04 00 A0 E1 06 10 A0 E1 F0 8D BD E8 02 11 C1 E3 ?? ?? ?? ?? 20 20 9F E5 20 30 9F E5 ?? ?? ?? ?? C2 FF FF EA FF FF EF 7F FF FF 2F 3E 9C 75 00 88 3C E4 37 7E 00 00 F0 3F 00 00 B0 41 EF 39 FA FE 42 2E E6 3F }
	condition:
		$1
}

rule file_194_0_2 {
	meta:
		name = "__quorem_D2A"
		size = 580
		refs = "0044 __udivsi3 0160 __cmp_D2A"
	strings:
		$1 = { F0 4F 2D E9 10 30 90 E5 10 80 91 E5 1C D0 4D E2 03 00 58 E1 00 90 A0 E1 0C 10 8D E5 00 00 A0 C3 85 00 00 CA 03 30 88 E2 0C 00 9D E5 03 31 A0 E1 03 A0 80 E0 04 10 9A E5 03 30 89 E0 01 10 81 E2 04 00 93 E5 ?? ?? ?? ?? 0C 10 9D E5 00 00 50 E3 01 80 48 E2 04 A0 8A E2 08 00 8D E5 14 50 81 E2 14 40 89 E2 3B 00 00 0A 00 B0 A0 E3 00 C0 A0 E3 00 18 8D E8 10 60 8D E5 14 70 8D E5 00 30 A0 E3 18 80 8D E5 09 E0 A0 E1 03 60 95 E7 08 10 9D E5 0B 80 A0 E1 0C 90 A0 E1 96 81 A9 E0 03 00 94 E7 00 10 E0 E3 00 20 A0 E3 09 70 A0 E1 01 80 08 E0 02 90 09 E0 00 80 78 E0 00 90 E9 E2 03 00 9D E8 00 80 58 E0 01 90 C9 E0 03 80 84 E7 04 30 83 E2 00 20 A0 E3 07 B0 A0 E1 03 00 85 E0 01 60 A0 E3 00 70 A0 E3 06 80 09 E0 00 00 5A E1 07 90 02 E0 02 C0 A0 E1 00 03 8D E8 E2 FF FF 2A 18 80 9D E5 0E 90 A0 E1 04 20 88 E2 02 31 8E E0 04 10 93 E5 10 70 8D E2 C0 00 97 E8 0C 00 51 E1 0D 00 00 1A 03 00 54 E1 0A 00 00 2A 02 21 9E E7 0C 00 52 E1 03 00 00 0A 06 00 00 EA 00 20 93 E5 00 00 52 E3 03 00 00 1A 04 30 43 E2 03 00 54 E1 01 80 48 E2 F8 FF FF 3A 10 80 89 E5 0C 10 9D E5 09 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 32 00 00 BA 08 00 9D E5 00 30 A0 E3 01 00 80 E2 08 00 8D E5 00 10 A0 E3 00 20 A0 E3 08 B0 A0 E1 09 C0 A0 E1 03 80 95 E7 00 60 E0 E3 03 00 94 E7 08 60 06 E0 00 70 A0 E3 06 80 A0 E1 07 90 A0 E1 00 80 78 E0 00 90 E9 E2 01 80 58 E0 02 90 C9 E0 03 80 84 E7 04 30 83 E2 03 20 85 E0 09 60 A0 E1 02 00 5A E1 00 70 A0 E3 01 80 A0 E3 00 90 A0 E3 08 10 06 E0 09 20 07 E0 E9 FF FF 2A 04 20 8B E2 02 31 8C E0 04 10 93 E5 0B 80 A0 E1 07 00 51 E1 0C 90 A0 E1 0D 00 00 1A 03 00 54 E1 0A 00 00 2A 02 21 9C E7 07 00 52 E1 03 00 00 0A 06 00 00 EA 00 20 93 E5 00 00 52 E3 03 00 00 1A 04 30 43 E2 03 00 54 E1 01 80 48 E2 F8 FF FF 3A 10 80 89 E5 08 00 9D E5 1C D0 8D E2 F0 8F BD E8 }
	condition:
		$1
}

rule file_194_1_2 {
	meta:
		name = "__freedtoa"
		size = 24
		refs = "0014 __Bfree_D2A"
	strings:
		$1 = { 04 30 10 E5 01 20 A0 E3 12 23 A0 E1 04 30 00 E4 08 20 80 E5 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_194_2_2 {
	meta:
		name = "__rv_alloc_D2A"
		size = 60
		refs = "0030 __Balloc_D2A"
	strings:
		$1 = { 13 00 50 E3 10 40 2D E9 00 40 A0 93 06 00 00 9A 00 40 A0 E3 04 30 A0 E3 83 30 A0 E1 10 20 83 E2 00 00 52 E1 01 40 84 E2 FA FF FF 9A 04 00 A0 E1 ?? ?? ?? ?? 04 40 80 E4 10 80 BD E8 }
	condition:
		$1
}

rule file_194_3_2 {
	meta:
		name = "__nrv_alloc_D2A"
		size = 72
		refs = "0010 __rv_alloc_D2A"
	strings:
		$1 = { 30 40 2D E9 00 40 A0 E1 02 00 A0 E1 01 50 A0 E1 EB FF FF EB 00 30 D4 E5 00 00 53 E3 00 30 C0 E5 00 20 A0 01 04 00 00 0A 00 20 A0 E1 01 30 F4 E5 00 00 53 E3 01 30 E2 E5 FB FF FF 1A 00 00 55 E3 00 20 85 15 30 80 BD E8 }
	condition:
		$1
}

rule file_196_0_2 {
	meta:
		name = "mktime"
		size = 200
		refs = "0018 GetSystemTime 0020 GetLocalTime 002c SystemTimeToFileTime 0084 __tm_to_SYSTEMTIME 0098 __FILETIME_to_time_t 00b0 __divdi3"
	strings:
		$1 = { F0 4D 2D E9 48 D0 4D E2 20 50 8D E2 10 40 8D E2 00 80 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 ?? ?? ?? ?? 40 10 8D E2 05 00 A0 E1 ?? ?? ?? ?? 38 10 8D E2 04 00 A0 E1 ?? ?? ?? ?? 38 50 9D E5 00 30 A0 E3 44 20 9D E5 03 10 A0 E1 05 A0 83 E1 40 30 9D E5 3C 40 9D E5 02 B0 A0 E1 0A 50 A0 E1 03 A0 81 E1 0A 20 A0 E1 0B 30 A0 E1 08 00 A0 E1 0D 10 A0 E1 04 60 A0 E1 30 40 8D E2 02 50 55 E0 03 60 C6 E0 ?? ?? ?? ?? 04 10 A0 E1 0D 00 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 ?? ?? ?? ?? 06 10 A0 E1 00 40 A0 E1 18 20 9F E5 05 00 A0 E1 00 30 A0 E3 ?? ?? ?? ?? 0D 70 A0 E1 04 00 60 E0 48 D0 8D E2 F0 8D BD E8 80 96 98 00 }
	condition:
		$1
}

rule file_197_0_2 {
	meta:
		name = "__ieee754_atan2f"
		size = 424
		refs = "0058 __addsf3 00ac __divsf3 00b4 atanf 00d8 __subsf3"
	strings:
		$1 = { 74 21 9F E5 F0 40 2D E9 02 61 C1 E3 02 41 C0 E3 02 00 54 E1 02 00 56 D1 00 30 A0 E1 00 50 A0 E1 0C 00 00 CA FE 05 51 E3 34 00 00 0A 41 7F A0 E1 02 70 07 E2 00 00 54 E3 A0 7F 87 E1 09 00 00 1A 02 00 57 E3 2F 00 00 0A 03 00 57 E3 03 00 00 1A 28 31 9F E5 01 00 00 EA ?? ?? ?? ?? 00 30 A0 E1 03 00 A0 E1 F0 80 BD E8 00 00 56 E3 1E 00 00 0A 02 00 56 E1 2C 00 00 0A 02 00 54 E1 1A 00 00 0A 04 40 66 E0 C4 4B A0 E1 3C 00 54 E3 F0 00 9F C5 08 00 00 CA 3C 00 74 E3 00 40 A0 A3 01 40 A0 B3 A1 4F 14 E0 00 00 A0 13 02 00 00 1A ?? ?? ?? ?? 02 01 C0 E3 ?? ?? ?? ?? 01 00 57 E3 02 31 80 02 E6 FF FF 0A 02 00 57 E3 10 00 00 0A 00 00 57 E3 03 00 00 0A AC 10 9F E5 ?? ?? ?? ?? A8 10 9F E5 ?? ?? ?? ?? 00 30 A0 E1 DC FF FF EA 00 00 55 E3 98 30 9F A5 98 30 9F B5 03 00 A0 E1 F0 80 BD E8 F0 40 BD E8 ?? ?? ?? ?? 7C 30 9F E5 D3 FF FF EA 70 10 9F E5 ?? ?? ?? ?? 00 10 A0 E1 68 00 9F E5 ?? ?? ?? ?? 00 30 A0 E1 CC FF FF EA 06 00 54 E1 07 00 00 0A 02 00 57 E3 F2 FF FF 0A 03 00 57 E3 C2 FF FF 0A 01 00 57 E3 02 31 A0 03 00 30 A0 13 C2 FF FF EA 02 00 57 E3 38 30 9F 05 BF FF FF 0A 03 00 57 E3 30 30 9F 05 BC FF FF 0A 01 00 57 E3 28 30 9F 05 28 30 9F 15 B8 FF FF EA 00 00 80 7F DA 0F 49 C0 DC 0F C9 3F 68 21 22 34 DA 0F 49 40 DB 0F C9 3F DB 0F C9 BF E4 CB 16 40 E4 CB 16 C0 DB 0F 49 BF DB 0F 49 3F }
	condition:
		$1
}

rule file_199_0_2 {
	meta:
		name = "__ieee754_expf"
		size = 748
		refs = "0030 __gtsf2 0044 __ltsf2 0058 __mulsf3 0068 __addsf3 006c __fixsfsi 0074 __floatsisf 008c __subsf3 0148 __divsf3 02c4 .rdata 02e8 .data"
	strings:
		$1 = { A8 22 9F E5 02 31 C0 E3 02 00 53 E1 F0 41 2D E9 00 40 A0 E1 A0 5F A0 E1 5D 00 00 9A 90 22 9F E5 02 00 53 E1 92 00 00 8A 9C 00 00 0A 84 12 9F E5 ?? ?? ?? ?? 00 00 50 E3 92 00 00 CA 04 00 A0 E1 74 12 9F E5 ?? ?? ?? ?? 00 00 50 E3 95 00 00 BA 68 12 9F E5 04 00 A0 E1 ?? ?? ?? ?? 60 32 9F E5 05 51 83 E0 10 10 95 E5 ?? ?? ?? ?? ?? ?? ?? ?? 00 60 A0 E1 ?? ?? ?? ?? 48 12 9F E5 00 50 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 34 12 9F E5 00 70 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 80 A0 E1 08 10 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 04 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 08 12 9F E5 00 50 A0 E1 ?? ?? ?? ?? 00 12 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? F4 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? E8 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? DC 11 9F E5 ?? ?? ?? ?? 05 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 00 56 E3 00 50 A0 E1 41 00 00 0A 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 00 40 A0 E1 01 01 A0 E3 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 07 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 FE 05 A0 E3 ?? ?? ?? ?? 7D 00 76 E3 86 4B 80 A0 04 00 00 AA 64 60 86 E2 86 0B 80 E0 36 15 A0 E3 ?? ?? ?? ?? 00 40 A0 E1 04 00 A0 E1 F0 81 BD E8 48 21 9F E5 02 00 53 E1 0F 00 00 8A C6 05 53 E3 00 60 A0 23 C1 FF FF 2A 34 31 9F E5 00 10 A0 E1 00 00 93 E5 ?? ?? ?? ?? FE 15 A0 E3 ?? ?? ?? ?? 00 00 50 E3 B9 FF FF DA 04 00 A0 E1 FE 15 A0 E3 ?? ?? ?? ?? 00 40 A0 E1 EA FF FF EA D3 28 82 E2 A3 2C 82 E2 79 20 82 E2 02 00 53 E1 96 FF FF 8A C8 40 9F E5 00 60 65 E2 05 11 94 E7 ?? ?? ?? ?? 06 60 65 E0 05 51 84 E0 08 80 95 E5 00 70 A0 E1 07 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 01 60 86 E2 00 40 A0 E1 A1 FF FF EA 05 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 01 11 A0 E3 00 60 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 FE 05 A0 E3 ?? ?? ?? ?? 00 40 A0 E1 04 00 A0 E1 F0 81 BD E8 00 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 04 00 A0 E1 F0 81 BD E8 58 30 9F E5 00 00 93 E5 00 10 93 E5 ?? ?? ?? ?? 00 40 A0 E1 BA FF FF EA 00 00 55 E3 B8 FF FF 0A 00 40 A0 E3 B6 FF FF EA 17 72 B1 42 00 00 80 7F 80 71 B1 42 B5 F1 CF C2 3B AA B8 3F ?? ?? ?? ?? 80 71 31 3F D1 F7 17 37 4C BB 31 33 0E EA DD 35 55 B3 8A 38 61 0B 36 3B AB AA 2A 3E 18 72 B1 3E ?? ?? ?? ?? }
	condition:
		$1
}

rule file_0_0_3 {
	meta:
		name = "__cxa_current_exception_type"
		size = 64
		refs = "0004 __cxa_get_globals"
	strings:
		$1 = { 10 40 2D E9 ?? ?? ?? ?? 00 00 90 E5 00 00 50 E3 10 80 BD 08 01 30 A0 E3 00 40 A0 E3 30 20 80 E2 06 00 92 E8 01 30 03 E0 02 40 04 E0 04 20 93 E1 08 00 90 15 48 00 40 12 00 00 90 E5 10 80 BD E8 }
	condition:
		$1
}

rule file_1_0_3 {
	meta:
		name = "__cxa_pure_virtual"
		size = 28
		refs = "0010 write 0014 _ZSt9terminatev 0018 .rdata"
	strings:
		$1 = { 04 E0 2D E5 0C 10 9F E5 1B 20 A0 E3 02 00 A0 E3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_0_3 {
	meta:
		name = "_ZNSt10money_base20_S_construct_patternEccc"
		size = 32
		refs = "0010 memcpy 001c _ZNSt10money_base18_S_default_patternE"
	strings:
		$1 = { 10 40 2D E9 10 10 9F E5 00 40 A0 E1 04 20 A0 E3 ?? ?? ?? ?? 04 00 A0 E1 10 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_1_3 {
	meta:
		name = "_ZNSt10moneypunctIwLb0EED1Ev"
		size = 204
		refs = "0038 _Unwind_SjLj_Register 007c _ZNSt6locale5facetD2Ev 0084 _Unwind_SjLj_Unregister 00b8 _Unwind_SjLj_Resume 00bc __gxx_personality_sj0 00c0 .gcc_except_table 00c4 .text$_ZNSt10moneypunctIwLb0EED1Ev 00c8 _ZTVSt10moneypunctIwLb0EE"
	strings:
		$1 = { 00 48 2D E9 B0 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 A4 30 9F E5 04 20 4B E2 1C 30 0B E5 9C 30 9F E5 3C 00 0B E5 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 3C 30 1B E5 3C 20 1B E5 08 00 93 E5 78 30 9F E5 00 00 50 E3 00 30 82 E5 05 00 00 0A 00 30 90 E5 01 20 A0 E3 04 30 93 E5 34 20 0B E5 0F E0 A0 E1 03 F0 A0 E1 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 A0 E3 34 30 0B E5 30 30 1B E5 3C 00 1B E5 3C 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_5_3 {
	meta:
		name = "_ZNSt10moneypunctIcLb0EED1Ev"
		size = 204
		refs = "0038 _Unwind_SjLj_Register 007c _ZNSt6locale5facetD2Ev 0084 _Unwind_SjLj_Unregister 00b8 _Unwind_SjLj_Resume 00bc __gxx_personality_sj0 00c0 .gcc_except_table 00c4 .text$_ZNSt10moneypunctIcLb0EED1Ev 00c8 _ZTVSt10moneypunctIcLb0EE"
	strings:
		$1 = { 00 48 2D E9 B0 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 A4 30 9F E5 04 20 4B E2 1C 30 0B E5 9C 30 9F E5 3C 00 0B E5 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 3C 30 1B E5 3C 20 1B E5 08 00 93 E5 78 30 9F E5 00 00 50 E3 00 30 82 E5 05 00 00 0A 00 30 90 E5 01 20 A0 E3 04 30 93 E5 34 20 0B E5 0F E0 A0 E1 03 F0 A0 E1 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 A0 E3 34 30 0B E5 30 30 1B E5 3C 00 1B E5 3C 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_6_3 {
	meta:
		name = "_ZNSt10moneypunctIcLb0EED2Ev"
		size = 204
		refs = "0038 _Unwind_SjLj_Register 007c _ZNSt6locale5facetD2Ev 0084 _Unwind_SjLj_Unregister 00b8 _Unwind_SjLj_Resume 00bc __gxx_personality_sj0 00c0 .gcc_except_table 00c4 .text$_ZNSt10moneypunctIcLb0EED2Ev 00c8 _ZTVSt10moneypunctIcLb0EE"
	strings:
		$1 = { 00 48 2D E9 B0 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 A4 30 9F E5 04 20 4B E2 1C 30 0B E5 9C 30 9F E5 3C 00 0B E5 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 3C 30 1B E5 3C 20 1B E5 08 00 93 E5 78 30 9F E5 00 00 50 E3 00 30 82 E5 05 00 00 0A 00 30 90 E5 01 20 A0 E3 04 30 93 E5 34 20 0B E5 0F E0 A0 E1 03 F0 A0 E1 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 A0 E3 34 30 0B E5 30 30 1B E5 3C 00 1B E5 3C 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_7_3 {
	meta:
		name = "_ZNSt10moneypunctIcLb1EED1Ev"
		size = 204
		refs = "0038 _Unwind_SjLj_Register 007c _ZNSt6locale5facetD2Ev 0084 _Unwind_SjLj_Unregister 00b8 _Unwind_SjLj_Resume 00bc __gxx_personality_sj0 00c0 .gcc_except_table 00c4 .text$_ZNSt10moneypunctIcLb1EED1Ev 00c8 _ZTVSt10moneypunctIcLb1EE"
	strings:
		$1 = { 00 48 2D E9 B0 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 A4 30 9F E5 04 20 4B E2 1C 30 0B E5 9C 30 9F E5 3C 00 0B E5 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 3C 30 1B E5 3C 20 1B E5 08 00 93 E5 78 30 9F E5 00 00 50 E3 00 30 82 E5 05 00 00 0A 00 30 90 E5 01 20 A0 E3 04 30 93 E5 34 20 0B E5 0F E0 A0 E1 03 F0 A0 E1 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 A0 E3 34 30 0B E5 30 30 1B E5 3C 00 1B E5 3C 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_8_3 {
	meta:
		name = "_ZNSt10moneypunctIcLb1EED2Ev"
		size = 204
		refs = "0038 _Unwind_SjLj_Register 007c _ZNSt6locale5facetD2Ev 0084 _Unwind_SjLj_Unregister 00b8 _Unwind_SjLj_Resume 00bc __gxx_personality_sj0 00c0 .gcc_except_table 00c4 .text$_ZNSt10moneypunctIcLb1EED2Ev 00c8 _ZTVSt10moneypunctIcLb1EE"
	strings:
		$1 = { 00 48 2D E9 B0 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 A4 30 9F E5 04 20 4B E2 1C 30 0B E5 9C 30 9F E5 3C 00 0B E5 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 3C 30 1B E5 3C 20 1B E5 08 00 93 E5 78 30 9F E5 00 00 50 E3 00 30 82 E5 05 00 00 0A 00 30 90 E5 01 20 A0 E3 04 30 93 E5 34 20 0B E5 0F E0 A0 E1 03 F0 A0 E1 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 A0 E3 34 30 0B E5 30 30 1B E5 3C 00 1B E5 3C 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_2_3 {
	meta:
		name = "_ZNSt10moneypunctIwLb0EED2Ev"
		size = 204
		refs = "0038 _Unwind_SjLj_Register 007c _ZNSt6locale5facetD2Ev 0084 _Unwind_SjLj_Unregister 00b8 _Unwind_SjLj_Resume 00bc __gxx_personality_sj0 00c0 .gcc_except_table 00c4 .text$_ZNSt10moneypunctIwLb0EED2Ev 00c8 _ZTVSt10moneypunctIwLb0EE"
	strings:
		$1 = { 00 48 2D E9 B0 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 A4 30 9F E5 04 20 4B E2 1C 30 0B E5 9C 30 9F E5 3C 00 0B E5 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 3C 30 1B E5 3C 20 1B E5 08 00 93 E5 78 30 9F E5 00 00 50 E3 00 30 82 E5 05 00 00 0A 00 30 90 E5 01 20 A0 E3 04 30 93 E5 34 20 0B E5 0F E0 A0 E1 03 F0 A0 E1 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 A0 E3 34 30 0B E5 30 30 1B E5 3C 00 1B E5 3C 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_3_3 {
	meta:
		name = "_ZNSt10moneypunctIwLb1EED1Ev"
		size = 204
		refs = "0038 _Unwind_SjLj_Register 007c _ZNSt6locale5facetD2Ev 0084 _Unwind_SjLj_Unregister 00b8 _Unwind_SjLj_Resume 00bc __gxx_personality_sj0 00c0 .gcc_except_table 00c4 .text$_ZNSt10moneypunctIwLb1EED1Ev 00c8 _ZTVSt10moneypunctIwLb1EE"
	strings:
		$1 = { 00 48 2D E9 B0 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 A4 30 9F E5 04 20 4B E2 1C 30 0B E5 9C 30 9F E5 3C 00 0B E5 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 3C 30 1B E5 3C 20 1B E5 08 00 93 E5 78 30 9F E5 00 00 50 E3 00 30 82 E5 05 00 00 0A 00 30 90 E5 01 20 A0 E3 04 30 93 E5 34 20 0B E5 0F E0 A0 E1 03 F0 A0 E1 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 A0 E3 34 30 0B E5 30 30 1B E5 3C 00 1B E5 3C 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_4_3 {
	meta:
		name = "_ZNSt10moneypunctIwLb1EED2Ev"
		size = 204
		refs = "0038 _Unwind_SjLj_Register 007c _ZNSt6locale5facetD2Ev 0084 _Unwind_SjLj_Unregister 00b8 _Unwind_SjLj_Resume 00bc __gxx_personality_sj0 00c0 .gcc_except_table 00c4 .text$_ZNSt10moneypunctIwLb1EED2Ev 00c8 _ZTVSt10moneypunctIwLb1EE"
	strings:
		$1 = { 00 48 2D E9 B0 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 A4 30 9F E5 04 20 4B E2 1C 30 0B E5 9C 30 9F E5 3C 00 0B E5 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 3C 30 1B E5 3C 20 1B E5 08 00 93 E5 78 30 9F E5 00 00 50 E3 00 30 82 E5 05 00 00 0A 00 30 90 E5 01 20 A0 E3 04 30 93 E5 34 20 0B E5 0F E0 A0 E1 03 F0 A0 E1 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 A0 E3 34 30 0B E5 30 30 1B E5 3C 00 1B E5 3C 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_54_2_3 {
	meta:
		name = "_ZNSt8numpunctIcED1Ev"
		size = 204
		refs = "0038 _Unwind_SjLj_Register 007c _ZNSt6locale5facetD2Ev 0084 _Unwind_SjLj_Unregister 00b8 _Unwind_SjLj_Resume 00bc __gxx_personality_sj0 00c0 .gcc_except_table 00c4 .text$_ZNSt8numpunctIcED1Ev 00c8 _ZTVSt8numpunctIcE"
	strings:
		$1 = { 00 48 2D E9 B0 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 A4 30 9F E5 04 20 4B E2 1C 30 0B E5 9C 30 9F E5 3C 00 0B E5 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 3C 30 1B E5 3C 20 1B E5 08 00 93 E5 78 30 9F E5 00 00 50 E3 00 30 82 E5 05 00 00 0A 00 30 90 E5 01 20 A0 E3 04 30 93 E5 34 20 0B E5 0F E0 A0 E1 03 F0 A0 E1 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 A0 E3 34 30 0B E5 30 30 1B E5 3C 00 1B E5 3C 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_54_3_3 {
	meta:
		name = "_ZNSt8numpunctIcED2Ev"
		size = 204
		refs = "0038 _Unwind_SjLj_Register 007c _ZNSt6locale5facetD2Ev 0084 _Unwind_SjLj_Unregister 00b8 _Unwind_SjLj_Resume 00bc __gxx_personality_sj0 00c0 .gcc_except_table 00c4 .text$_ZNSt8numpunctIcED2Ev 00c8 _ZTVSt8numpunctIcE"
	strings:
		$1 = { 00 48 2D E9 B0 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 A4 30 9F E5 04 20 4B E2 1C 30 0B E5 9C 30 9F E5 3C 00 0B E5 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 3C 30 1B E5 3C 20 1B E5 08 00 93 E5 78 30 9F E5 00 00 50 E3 00 30 82 E5 05 00 00 0A 00 30 90 E5 01 20 A0 E3 04 30 93 E5 34 20 0B E5 0F E0 A0 E1 03 F0 A0 E1 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 A0 E3 34 30 0B E5 30 30 1B E5 3C 00 1B E5 3C 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_54_0_3 {
	meta:
		name = "_ZNSt8numpunctIwED1Ev"
		size = 204
		refs = "0038 _Unwind_SjLj_Register 007c _ZNSt6locale5facetD2Ev 0084 _Unwind_SjLj_Unregister 00b8 _Unwind_SjLj_Resume 00bc __gxx_personality_sj0 00c0 .gcc_except_table 00c4 .text$_ZNSt8numpunctIwED1Ev 00c8 _ZTVSt8numpunctIwE"
	strings:
		$1 = { 00 48 2D E9 B0 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 A4 30 9F E5 04 20 4B E2 1C 30 0B E5 9C 30 9F E5 3C 00 0B E5 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 3C 30 1B E5 3C 20 1B E5 08 00 93 E5 78 30 9F E5 00 00 50 E3 00 30 82 E5 05 00 00 0A 00 30 90 E5 01 20 A0 E3 04 30 93 E5 34 20 0B E5 0F E0 A0 E1 03 F0 A0 E1 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 A0 E3 34 30 0B E5 30 30 1B E5 3C 00 1B E5 3C 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_54_1_3 {
	meta:
		name = "_ZNSt8numpunctIwED2Ev"
		size = 204
		refs = "0038 _Unwind_SjLj_Register 007c _ZNSt6locale5facetD2Ev 0084 _Unwind_SjLj_Unregister 00b8 _Unwind_SjLj_Resume 00bc __gxx_personality_sj0 00c0 .gcc_except_table 00c4 .text$_ZNSt8numpunctIwED2Ev 00c8 _ZTVSt8numpunctIwE"
	strings:
		$1 = { 00 48 2D E9 B0 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 A4 30 9F E5 04 20 4B E2 1C 30 0B E5 9C 30 9F E5 3C 00 0B E5 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 3C 30 1B E5 3C 20 1B E5 08 00 93 E5 78 30 9F E5 00 00 50 E3 00 30 82 E5 05 00 00 0A 00 30 90 E5 01 20 A0 E3 04 30 93 E5 34 20 0B E5 0F E0 A0 E1 03 F0 A0 E1 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 A0 E3 34 30 0B E5 30 30 1B E5 3C 00 1B E5 3C 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_9_3 {
	meta:
		name = "_ZNSt10moneypunctIwLb0EED0Ev"
		size = 212
		refs = "0038 _Unwind_SjLj_Register 007c _ZNSt6locale5facetD2Ev 0084 _ZdlPv 008c _Unwind_SjLj_Unregister 00c0 _Unwind_SjLj_Resume 00c4 __gxx_personality_sj0 00c8 .gcc_except_table 00cc .text$_ZNSt10moneypunctIwLb0EED0Ev 00d0 _ZTVSt10moneypunctIwLb0EE"
	strings:
		$1 = { 00 48 2D E9 B8 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 AC 30 9F E5 04 20 4B E2 1C 30 0B E5 A4 30 9F E5 3C 00 0B E5 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 3C 30 1B E5 3C 20 1B E5 08 00 93 E5 80 30 9F E5 00 00 50 E3 00 30 82 E5 05 00 00 0A 00 30 90 E5 01 20 A0 E3 04 30 93 E5 34 20 0B E5 0F E0 A0 E1 03 F0 A0 E1 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 3C 00 1B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 A0 E3 34 30 0B E5 30 30 1B E5 3C 00 1B E5 3C 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_11_3 {
	meta:
		name = "_ZNSt10moneypunctIcLb0EED0Ev"
		size = 212
		refs = "0038 _Unwind_SjLj_Register 007c _ZNSt6locale5facetD2Ev 0084 _ZdlPv 008c _Unwind_SjLj_Unregister 00c0 _Unwind_SjLj_Resume 00c4 __gxx_personality_sj0 00c8 .gcc_except_table 00cc .text$_ZNSt10moneypunctIcLb0EED0Ev 00d0 _ZTVSt10moneypunctIcLb0EE"
	strings:
		$1 = { 00 48 2D E9 B8 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 AC 30 9F E5 04 20 4B E2 1C 30 0B E5 A4 30 9F E5 3C 00 0B E5 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 3C 30 1B E5 3C 20 1B E5 08 00 93 E5 80 30 9F E5 00 00 50 E3 00 30 82 E5 05 00 00 0A 00 30 90 E5 01 20 A0 E3 04 30 93 E5 34 20 0B E5 0F E0 A0 E1 03 F0 A0 E1 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 3C 00 1B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 A0 E3 34 30 0B E5 30 30 1B E5 3C 00 1B E5 3C 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_12_3 {
	meta:
		name = "_ZNSt10moneypunctIcLb1EED0Ev"
		size = 212
		refs = "0038 _Unwind_SjLj_Register 007c _ZNSt6locale5facetD2Ev 0084 _ZdlPv 008c _Unwind_SjLj_Unregister 00c0 _Unwind_SjLj_Resume 00c4 __gxx_personality_sj0 00c8 .gcc_except_table 00cc .text$_ZNSt10moneypunctIcLb1EED0Ev 00d0 _ZTVSt10moneypunctIcLb1EE"
	strings:
		$1 = { 00 48 2D E9 B8 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 AC 30 9F E5 04 20 4B E2 1C 30 0B E5 A4 30 9F E5 3C 00 0B E5 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 3C 30 1B E5 3C 20 1B E5 08 00 93 E5 80 30 9F E5 00 00 50 E3 00 30 82 E5 05 00 00 0A 00 30 90 E5 01 20 A0 E3 04 30 93 E5 34 20 0B E5 0F E0 A0 E1 03 F0 A0 E1 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 3C 00 1B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 A0 E3 34 30 0B E5 30 30 1B E5 3C 00 1B E5 3C 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_10_3 {
	meta:
		name = "_ZNSt10moneypunctIwLb1EED0Ev"
		size = 212
		refs = "0038 _Unwind_SjLj_Register 007c _ZNSt6locale5facetD2Ev 0084 _ZdlPv 008c _Unwind_SjLj_Unregister 00c0 _Unwind_SjLj_Resume 00c4 __gxx_personality_sj0 00c8 .gcc_except_table 00cc .text$_ZNSt10moneypunctIwLb1EED0Ev 00d0 _ZTVSt10moneypunctIwLb1EE"
	strings:
		$1 = { 00 48 2D E9 B8 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 AC 30 9F E5 04 20 4B E2 1C 30 0B E5 A4 30 9F E5 3C 00 0B E5 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 3C 30 1B E5 3C 20 1B E5 08 00 93 E5 80 30 9F E5 00 00 50 E3 00 30 82 E5 05 00 00 0A 00 30 90 E5 01 20 A0 E3 04 30 93 E5 34 20 0B E5 0F E0 A0 E1 03 F0 A0 E1 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 3C 00 1B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 A0 E3 34 30 0B E5 30 30 1B E5 3C 00 1B E5 3C 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_54_5_3 {
	meta:
		name = "_ZNSt8numpunctIcED0Ev"
		size = 212
		refs = "0038 _Unwind_SjLj_Register 007c _ZNSt6locale5facetD2Ev 0084 _ZdlPv 008c _Unwind_SjLj_Unregister 00c0 _Unwind_SjLj_Resume 00c4 __gxx_personality_sj0 00c8 .gcc_except_table 00cc .text$_ZNSt8numpunctIcED0Ev 00d0 _ZTVSt8numpunctIcE"
	strings:
		$1 = { 00 48 2D E9 B8 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 AC 30 9F E5 04 20 4B E2 1C 30 0B E5 A4 30 9F E5 3C 00 0B E5 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 3C 30 1B E5 3C 20 1B E5 08 00 93 E5 80 30 9F E5 00 00 50 E3 00 30 82 E5 05 00 00 0A 00 30 90 E5 01 20 A0 E3 04 30 93 E5 34 20 0B E5 0F E0 A0 E1 03 F0 A0 E1 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 3C 00 1B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 A0 E3 34 30 0B E5 30 30 1B E5 3C 00 1B E5 3C 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_54_4_3 {
	meta:
		name = "_ZNSt8numpunctIwED0Ev"
		size = 212
		refs = "0038 _Unwind_SjLj_Register 007c _ZNSt6locale5facetD2Ev 0084 _ZdlPv 008c _Unwind_SjLj_Unregister 00c0 _Unwind_SjLj_Resume 00c4 __gxx_personality_sj0 00c8 .gcc_except_table 00cc .text$_ZNSt8numpunctIwED0Ev 00d0 _ZTVSt8numpunctIwE"
	strings:
		$1 = { 00 48 2D E9 B8 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 AC 30 9F E5 04 20 4B E2 1C 30 0B E5 A4 30 9F E5 3C 00 0B E5 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 3C 30 1B E5 3C 20 1B E5 08 00 93 E5 80 30 9F E5 00 00 50 E3 00 30 82 E5 05 00 00 0A 00 30 90 E5 01 20 A0 E3 04 30 93 E5 34 20 0B E5 0F E0 A0 E1 03 F0 A0 E1 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 3C 00 1B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 A0 E3 34 30 0B E5 30 30 1B E5 3C 00 1B E5 3C 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_13_3 {
	meta:
		name = "_ZNSt10moneypunctIwLb0EE24_M_initialize_moneypunctEPiPKc"
		size = 296
		refs = "0064 memcpy 00a8 _Znwj 0118 .rdata 011c _ZNSt10money_base18_S_default_patternE 0120 _ZNSt10money_base8_S_atomsE 0124 _ZTVSt18__moneypunct_cacheIwLb0EE"
	strings:
		$1 = { 70 40 2D E9 08 60 90 E5 00 50 A0 E1 00 00 56 E3 06 00 A0 E1 22 00 00 0A F8 20 9F E5 2E 10 A0 E3 04 30 82 E2 00 40 A0 E3 B2 11 C0 E1 2C 10 A0 E3 28 30 86 E5 18 30 86 E5 20 30 86 E5 B4 11 C6 E1 08 20 86 E5 D0 10 9F E5 04 20 A0 E3 0C 40 86 E5 1C 40 86 E5 24 40 86 E5 2C 40 86 E5 30 40 86 E5 34 00 86 E2 ?? ?? ?? ?? 08 00 95 E5 A8 10 9F E5 04 20 A0 E3 38 00 80 E2 ?? ?? ?? ?? 9C 20 9F E5 08 30 95 E5 00 10 92 E5 D4 20 91 E1 01 40 84 E2 0B 00 54 E3 BC 23 C3 E1 02 30 83 E2 F9 FF FF 1A 70 80 BD E8 54 00 A0 E3 ?? ?? ?? ?? 70 20 9F E5 34 60 C0 E5 35 60 C0 E5 36 60 C0 E5 37 60 C0 E5 38 60 C0 E5 39 60 C0 E5 3A 60 C0 E5 3B 60 C0 E5 30 60 80 E5 52 60 C0 E5 04 60 80 E5 08 60 80 E5 0C 60 80 E5 10 60 C0 E5 B2 61 C0 E1 B4 61 C0 E1 18 60 80 E5 1C 60 80 E5 20 60 80 E5 24 60 80 E5 28 60 80 E5 2C 60 80 E5 00 20 80 E5 08 00 85 E5 00 60 A0 E1 BF FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_14_3 {
	meta:
		name = "_ZNSt10moneypunctIwLb1EE24_M_initialize_moneypunctEPiPKc"
		size = 296
		refs = "0064 memcpy 00a8 _Znwj 0118 .rdata 011c _ZNSt10money_base18_S_default_patternE 0120 _ZNSt10money_base8_S_atomsE 0124 _ZTVSt18__moneypunct_cacheIwLb1EE"
	strings:
		$1 = { 70 40 2D E9 08 60 90 E5 00 50 A0 E1 00 00 56 E3 06 00 A0 E1 22 00 00 0A F8 20 9F E5 2E 10 A0 E3 04 30 82 E2 00 40 A0 E3 B2 11 C0 E1 2C 10 A0 E3 28 30 86 E5 18 30 86 E5 20 30 86 E5 B4 11 C6 E1 08 20 86 E5 D0 10 9F E5 04 20 A0 E3 0C 40 86 E5 1C 40 86 E5 24 40 86 E5 2C 40 86 E5 30 40 86 E5 34 00 86 E2 ?? ?? ?? ?? 08 00 95 E5 A8 10 9F E5 04 20 A0 E3 38 00 80 E2 ?? ?? ?? ?? 9C 20 9F E5 08 30 95 E5 00 10 92 E5 D4 20 91 E1 01 40 84 E2 0B 00 54 E3 BC 23 C3 E1 02 30 83 E2 F9 FF FF 1A 70 80 BD E8 54 00 A0 E3 ?? ?? ?? ?? 70 20 9F E5 34 60 C0 E5 35 60 C0 E5 36 60 C0 E5 37 60 C0 E5 38 60 C0 E5 39 60 C0 E5 3A 60 C0 E5 3B 60 C0 E5 30 60 80 E5 52 60 C0 E5 04 60 80 E5 08 60 80 E5 0C 60 80 E5 10 60 C0 E5 B2 61 C0 E1 B4 61 C0 E1 18 60 80 E5 1C 60 80 E5 20 60 80 E5 24 60 80 E5 28 60 80 E5 2C 60 80 E5 00 20 80 E5 08 00 85 E5 00 60 A0 E1 BF FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_15_3 {
	meta:
		name = "_ZNSt10moneypunctIcLb0EE24_M_initialize_moneypunctEPiPKc"
		size = 296
		refs = "0064 memcpy 00a8 _Znwj 0118 .rdata 011c _ZNSt10money_base18_S_default_patternE 0120 _ZNSt10money_base8_S_atomsE 0124 _ZTVSt18__moneypunct_cacheIcLb0EE"
	strings:
		$1 = { 30 40 2D E9 00 40 A0 E1 08 00 90 E5 00 00 50 E3 23 00 00 0A 2E 30 A0 E3 11 30 C0 E5 08 30 94 E5 2C 20 A0 E3 12 20 C3 E5 08 00 94 E5 E4 30 9F E5 00 50 A0 E3 24 30 80 E5 08 30 80 E5 14 30 80 E5 1C 30 80 E5 0C 50 80 E5 18 50 80 E5 20 50 80 E5 28 50 80 E5 2C 50 80 E5 BC 10 9F E5 04 20 A0 E3 30 00 80 E2 ?? ?? ?? ?? 08 00 94 E5 A8 10 9F E5 34 00 80 E2 04 20 A0 E3 ?? ?? ?? ?? 9C 30 9F E5 00 10 93 E5 08 30 94 E5 05 20 D1 E7 05 30 83 E0 01 50 85 E2 0B 00 55 E3 38 20 C3 E5 F8 FF FF 1A 30 80 BD E8 44 00 A0 E3 ?? ?? ?? ?? 70 20 9F E5 00 30 A0 E3 11 30 C0 E5 12 30 C0 E5 30 30 C0 E5 31 30 C0 E5 32 30 C0 E5 33 30 C0 E5 34 30 C0 E5 35 30 C0 E5 36 30 C0 E5 37 30 C0 E5 00 20 80 E5 43 30 C0 E5 04 30 80 E5 08 30 80 E5 0C 30 80 E5 10 30 C0 E5 14 30 80 E5 18 30 80 E5 1C 30 80 E5 20 30 80 E5 24 30 80 E5 28 30 80 E5 2C 30 80 E5 08 00 84 E5 BE FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_16_3 {
	meta:
		name = "_ZNSt10moneypunctIcLb1EE24_M_initialize_moneypunctEPiPKc"
		size = 296
		refs = "0064 memcpy 00a8 _Znwj 0118 .rdata 011c _ZNSt10money_base18_S_default_patternE 0120 _ZNSt10money_base8_S_atomsE 0124 _ZTVSt18__moneypunct_cacheIcLb1EE"
	strings:
		$1 = { 30 40 2D E9 00 40 A0 E1 08 00 90 E5 00 00 50 E3 23 00 00 0A 2E 30 A0 E3 11 30 C0 E5 08 30 94 E5 2C 20 A0 E3 12 20 C3 E5 08 00 94 E5 E4 30 9F E5 00 50 A0 E3 24 30 80 E5 08 30 80 E5 14 30 80 E5 1C 30 80 E5 0C 50 80 E5 18 50 80 E5 20 50 80 E5 28 50 80 E5 2C 50 80 E5 BC 10 9F E5 04 20 A0 E3 30 00 80 E2 ?? ?? ?? ?? 08 00 94 E5 A8 10 9F E5 34 00 80 E2 04 20 A0 E3 ?? ?? ?? ?? 9C 30 9F E5 00 10 93 E5 08 30 94 E5 05 20 D1 E7 05 30 83 E0 01 50 85 E2 0B 00 55 E3 38 20 C3 E5 F8 FF FF 1A 30 80 BD E8 44 00 A0 E3 ?? ?? ?? ?? 70 20 9F E5 00 30 A0 E3 11 30 C0 E5 12 30 C0 E5 30 30 C0 E5 31 30 C0 E5 32 30 C0 E5 33 30 C0 E5 34 30 C0 E5 35 30 C0 E5 36 30 C0 E5 37 30 C0 E5 00 20 80 E5 43 30 C0 E5 04 30 80 E5 08 30 80 E5 0C 30 80 E5 10 30 C0 E5 14 30 80 E5 18 30 80 E5 1C 30 80 E5 20 30 80 E5 24 30 80 E5 28 30 80 E5 2C 30 80 E5 08 00 84 E5 BE FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_6_0_3 {
	meta:
		name = "_ZNSt6__norm15_List_node_base4swapERS0_S1_"
		size = 152
		altNames = "_ZNSt15_List_node_base4swapERS_S0_"
	strings:
		$1 = { 00 30 90 E5 04 40 2D E5 00 00 53 E1 0E 00 00 0A 00 20 91 E5 01 00 52 E1 16 00 00 0A 04 C0 90 E5 04 40 91 E5 14 00 80 E8 08 10 81 E8 0C 00 90 E8 04 00 82 E5 00 00 83 E5 0C 00 91 E8 04 10 82 E5 00 10 83 E5 10 00 BD E8 0E F0 A0 E1 00 20 91 E5 01 00 52 E1 FA FF FF 0A 04 00 91 E5 00 20 83 E5 04 00 83 E5 00 30 80 E5 04 30 82 E5 00 10 81 E5 04 10 81 E5 F2 FF FF EA 04 10 90 E5 00 30 82 E5 04 10 82 E5 00 20 81 E5 04 20 83 E5 00 00 80 E5 04 00 80 E5 EA FF FF EA }
	condition:
		$1
}

rule file_6_1_3 {
	meta:
		name = "_ZNSt6__norm15_List_node_base8transferEPS0_S1_"
		size = 60
		altNames = "_ZNSt15_List_node_base8transferEPS_S0_"
	strings:
		$1 = { 02 00 50 E1 30 00 2D E9 09 00 00 0A 04 C0 92 E5 04 40 91 E5 04 30 90 E5 04 C0 80 E5 04 50 91 E5 00 00 8C E5 04 50 82 E5 00 20 84 E5 04 30 81 E5 00 10 83 E5 30 00 BD E8 0E F0 A0 E1 }
	condition:
		$1
}

rule file_6_2_3 {
	meta:
		name = "_ZNSt6__norm15_List_node_base7reverseEv"
		size = 52
		altNames = "_ZNSt15_List_node_base7reverseEv"
	strings:
		$1 = { 00 30 A0 E1 00 20 93 E5 04 10 93 E5 02 00 50 E1 06 00 83 E8 0E F0 A0 01 02 30 A0 E1 00 20 93 E5 04 10 93 E5 02 00 50 E1 06 00 83 E8 F9 FF FF 1A 0E F0 A0 E1 }
	condition:
		$1
}

rule file_6_3_3 {
	meta:
		name = "_ZNSt6__norm15_List_node_base4hookEPS0_"
		size = 24
		altNames = "_ZNSt15_List_node_base4hookEPS_"
	strings:
		$1 = { 04 30 91 E5 0A 00 80 E8 04 30 91 E5 04 00 81 E5 00 00 83 E5 0E F0 A0 E1 }
	condition:
		$1
}

rule file_6_4_3 {
	meta:
		name = "_ZNSt6__norm15_List_node_base6unhookEv"
		size = 16
		altNames = "_ZNSt15_List_node_base6unhookEv"
	strings:
		$1 = { 0C 00 90 E8 04 30 82 E5 00 20 83 E5 0E F0 A0 E1 }
	condition:
		$1
}

rule file_7_0_3 {
	meta:
		name = "_ZNK10__cxxabiv129__pointer_to_member_type_info15__pointer_catchEPKNS_17__pbase_type_infoEPPvj"
		size = 76
		refs = "001c _ZNKSt9type_infoeqERKS_"
	strings:
		$1 = { F0 40 2D E9 00 50 A0 E1 01 40 A0 E1 10 00 90 E5 10 10 91 E5 02 70 A0 E1 03 60 A0 E1 ?? ?? ?? ?? 00 00 50 E3 F0 80 BD 08 0C C0 95 E5 0C 10 94 E5 0C 00 A0 E1 07 20 A0 E1 02 30 86 E2 00 C0 9C E5 0F E0 A0 E1 10 F0 9C E5 F0 80 BD E8 }
	condition:
		$1
}

rule file_7_1_3 {
	meta:
		name = "_ZN10__cxxabiv129__pointer_to_member_type_infoD1Ev"
		size = 16
		refs = "0008 _ZN10__cxxabiv117__pbase_type_infoD2Ev 000c _ZTVN10__cxxabiv129__pointer_to_member_type_infoE"
		altNames = "_ZN10__cxxabiv129__pointer_to_member_type_infoD2Ev"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_28_11_3 {
	meta:
		name = "_ZN10__cxxabiv115__forced_unwindD0Ev"
		size = 16
		refs = "0008 _ZdlPv 000c _ZTVN10__cxxabiv115__forced_unwindE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_28_5_3 {
	meta:
		name = "_ZN10__cxxabiv115__forced_unwindD1Ev"
		size = 16
		refs = "000c _ZTVN10__cxxabiv115__forced_unwindE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 0E F0 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_28_4_3 {
	meta:
		name = "_ZN10__cxxabiv115__forced_unwindD2Ev"
		size = 16
		refs = "000c _ZTVN10__cxxabiv115__forced_unwindE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 0E F0 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_70_0_3 {
	meta:
		name = "_ZN10__cxxabiv116__enum_type_infoD1Ev"
		size = 16
		refs = "0008 _ZNSt9type_infoD2Ev 000c _ZTVN10__cxxabiv116__enum_type_infoE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_70_1_3 {
	meta:
		name = "_ZN10__cxxabiv116__enum_type_infoD2Ev"
		size = 16
		refs = "0008 _ZNSt9type_infoD2Ev 000c _ZTVN10__cxxabiv116__enum_type_infoE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_107_0_3 {
	meta:
		name = "_ZN10__cxxabiv117__array_type_infoD1Ev"
		size = 16
		refs = "0008 _ZNSt9type_infoD2Ev 000c _ZTVN10__cxxabiv117__array_type_infoE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_107_1_3 {
	meta:
		name = "_ZN10__cxxabiv117__array_type_infoD2Ev"
		size = 16
		refs = "0008 _ZNSt9type_infoD2Ev 000c _ZTVN10__cxxabiv117__array_type_infoE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_104_5_3 {
	meta:
		name = "_ZN10__cxxabiv117__class_type_infoD1Ev"
		size = 16
		refs = "0008 _ZNSt9type_infoD2Ev 000c _ZTVN10__cxxabiv117__class_type_infoE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_104_6_3 {
	meta:
		name = "_ZN10__cxxabiv117__class_type_infoD2Ev"
		size = 16
		refs = "0008 _ZNSt9type_infoD2Ev 000c _ZTVN10__cxxabiv117__class_type_infoE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_72_2_3 {
	meta:
		name = "_ZN10__cxxabiv117__pbase_type_infoD1Ev"
		size = 16
		refs = "0008 _ZNSt9type_infoD2Ev 000c _ZTVN10__cxxabiv117__pbase_type_infoE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_72_3_3 {
	meta:
		name = "_ZN10__cxxabiv117__pbase_type_infoD2Ev"
		size = 16
		refs = "0008 _ZNSt9type_infoD2Ev 000c _ZTVN10__cxxabiv117__pbase_type_infoE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_28_10_3 {
	meta:
		name = "_ZN10__cxxabiv119__foreign_exceptionD0Ev"
		size = 16
		refs = "0008 _ZdlPv 000c _ZTVN10__cxxabiv119__foreign_exceptionE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_28_7_3 {
	meta:
		name = "_ZN10__cxxabiv119__foreign_exceptionD1Ev"
		size = 16
		refs = "000c _ZTVN10__cxxabiv119__foreign_exceptionE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 0E F0 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_28_6_3 {
	meta:
		name = "_ZN10__cxxabiv119__foreign_exceptionD2Ev"
		size = 16
		refs = "000c _ZTVN10__cxxabiv119__foreign_exceptionE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 0E F0 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_31_2_3 {
	meta:
		name = "_ZN10__cxxabiv119__pointer_type_infoD1Ev"
		size = 16
		refs = "0008 _ZN10__cxxabiv117__pbase_type_infoD2Ev 000c _ZTVN10__cxxabiv119__pointer_type_infoE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_31_3_3 {
	meta:
		name = "_ZN10__cxxabiv119__pointer_type_infoD2Ev"
		size = 16
		refs = "0008 _ZN10__cxxabiv117__pbase_type_infoD2Ev 000c _ZTVN10__cxxabiv119__pointer_type_infoE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_24_1_3 {
	meta:
		name = "_ZN10__cxxabiv120__function_type_infoD1Ev"
		size = 16
		refs = "0008 _ZNSt9type_infoD2Ev 000c _ZTVN10__cxxabiv120__function_type_infoE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_24_2_3 {
	meta:
		name = "_ZN10__cxxabiv120__function_type_infoD2Ev"
		size = 16
		refs = "0008 _ZNSt9type_infoD2Ev 000c _ZTVN10__cxxabiv120__function_type_infoE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_69_3_3 {
	meta:
		name = "_ZN10__cxxabiv120__si_class_type_infoD1Ev"
		size = 16
		refs = "0008 _ZN10__cxxabiv117__class_type_infoD2Ev 000c _ZTVN10__cxxabiv120__si_class_type_infoE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_69_4_3 {
	meta:
		name = "_ZN10__cxxabiv120__si_class_type_infoD2Ev"
		size = 16
		refs = "0008 _ZN10__cxxabiv117__class_type_infoD2Ev 000c _ZTVN10__cxxabiv120__si_class_type_infoE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_36_3_3 {
	meta:
		name = "_ZN10__cxxabiv121__vmi_class_type_infoD1Ev"
		size = 16
		refs = "0008 _ZN10__cxxabiv117__class_type_infoD2Ev 000c _ZTVN10__cxxabiv121__vmi_class_type_infoE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_36_4_3 {
	meta:
		name = "_ZN10__cxxabiv121__vmi_class_type_infoD2Ev"
		size = 16
		refs = "0008 _ZN10__cxxabiv117__class_type_infoD2Ev 000c _ZTVN10__cxxabiv121__vmi_class_type_infoE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_92_0_3 {
	meta:
		name = "_ZN10__cxxabiv123__fundamental_type_infoD1Ev"
		size = 16
		refs = "0008 _ZNSt9type_infoD2Ev 000c _ZTVN10__cxxabiv123__fundamental_type_infoE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_92_1_3 {
	meta:
		name = "_ZN10__cxxabiv123__fundamental_type_infoD2Ev"
		size = 16
		refs = "0008 _ZNSt9type_infoD2Ev 000c _ZTVN10__cxxabiv123__fundamental_type_infoE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_65_15_3 {
	meta:
		name = "_ZN126_GLOBAL__N__home_danny_src_cegcc_svn.sf.net_cegcc_trunk_cegcc_src_gcc_4.4.0_libstdc___v3_src_system_error.cc_00000000_8AAC28BE21system_error_categoryD0Ev"
		size = 16
		refs = "0008 _ZdlPv 000c _ZTVSt14error_category"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_65_9_3 {
	meta:
		name = "_ZN126_GLOBAL__N__home_danny_src_cegcc_svn.sf.net_cegcc_trunk_cegcc_src_gcc_4.4.0_libstdc___v3_src_system_error.cc_00000000_8AAC28BE21system_error_categoryD1Ev"
		size = 16
		refs = "000c _ZTVSt14error_category"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 0E F0 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_65_14_3 {
	meta:
		name = "_ZN126_GLOBAL__N__home_danny_src_cegcc_svn.sf.net_cegcc_trunk_cegcc_src_gcc_4.4.0_libstdc___v3_src_system_error.cc_00000000_8AAC28BE22generic_error_categoryD0Ev"
		size = 16
		refs = "0008 _ZdlPv 000c _ZTVSt14error_category"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_65_10_3 {
	meta:
		name = "_ZN126_GLOBAL__N__home_danny_src_cegcc_svn.sf.net_cegcc_trunk_cegcc_src_gcc_4.4.0_libstdc___v3_src_system_error.cc_00000000_8AAC28BE22generic_error_categoryD1Ev"
		size = 16
		refs = "000c _ZTVSt14error_category"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 0E F0 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_89_6_3 {
	meta:
		name = "_ZN9__gnu_cxx20recursive_init_errorD1Ev"
		size = 16
		refs = "0008 _ZNSt9exceptionD2Ev 000c _ZTVN9__gnu_cxx20recursive_init_errorE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_89_7_3 {
	meta:
		name = "_ZN9__gnu_cxx20recursive_init_errorD2Ev"
		size = 16
		refs = "0008 _ZNSt9exceptionD2Ev 000c _ZTVN9__gnu_cxx20recursive_init_errorE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_87_10_3 {
	meta:
		name = "_ZN9__gnu_cxx24__concurrence_lock_errorD1Ev"
		size = 16
		refs = "0008 _ZNSt9exceptionD2Ev 000c _ZTVN9__gnu_cxx24__concurrence_lock_errorE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_108_4_3 {
	meta:
		name = "_ZN9__gnu_cxx26__concurrence_unlock_errorD1Ev"
		size = 16
		refs = "0008 _ZNSt9exceptionD2Ev 000c _ZTVN9__gnu_cxx26__concurrence_unlock_errorE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_106_3 {
	meta:
		name = "_ZNKSt8messagesIcE20_M_convert_from_charEPc"
		size = 16
		refs = "000c _ZNSs4_Rep20_S_empty_rep_storageE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 0E F0 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_106_3 {
	meta:
		name = "_ZNKSt8messagesIwE20_M_convert_from_charEPc"
		size = 16
		refs = "000c _ZNSbIwSt11char_traitsIwESaIwEE4_Rep20_S_empty_rep_storageE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 0E F0 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_84_10_3 {
	meta:
		name = "_ZNSbIwSt11char_traitsIwESaIwEEC1Ev"
		size = 16
		refs = "000c _ZNSbIwSt11char_traitsIwESaIwEE4_Rep20_S_empty_rep_storageE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 0E F0 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_84_9_3 {
	meta:
		name = "_ZNSbIwSt11char_traitsIwESaIwEEC2Ev"
		size = 16
		refs = "000c _ZNSbIwSt11char_traitsIwESaIwEE4_Rep20_S_empty_rep_storageE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 0E F0 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_10_3 {
	meta:
		name = "_ZNSsC1Ev"
		size = 16
		refs = "000c _ZNSs4_Rep20_S_empty_rep_storageE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 0E F0 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_9_3 {
	meta:
		name = "_ZNSsC2Ev"
		size = 16
		refs = "000c _ZNSs4_Rep20_S_empty_rep_storageE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 0E F0 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_43_1_3 {
	meta:
		name = "_ZNSt10bad_typeidD1Ev"
		size = 16
		refs = "0008 _ZNSt9exceptionD2Ev 000c _ZTVSt10bad_typeid"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_43_2_3 {
	meta:
		name = "_ZNSt10bad_typeidD2Ev"
		size = 16
		refs = "0008 _ZNSt9exceptionD2Ev 000c _ZTVSt10bad_typeid"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_6_3 {
	meta:
		name = "_ZNSt11range_errorD1Ev"
		size = 16
		refs = "0008 _ZNSt13runtime_errorD2Ev 000c _ZTVSt11range_error"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_40_18_3 {
	meta:
		name = "_ZNSt12ctype_bynameIcED1Ev"
		size = 16
		refs = "0008 _ZNSt5ctypeIcED2Ev 000c _ZTVSt12ctype_bynameIcE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_40_19_3 {
	meta:
		name = "_ZNSt12ctype_bynameIcED2Ev"
		size = 16
		refs = "0008 _ZNSt5ctypeIcED2Ev 000c _ZTVSt12ctype_bynameIcE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_83_14_3 {
	meta:
		name = "_ZNSt12ctype_bynameIwED1Ev"
		size = 16
		refs = "0008 _ZNSt5ctypeIwED2Ev 000c _ZTVSt12ctype_bynameIwE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_83_15_3 {
	meta:
		name = "_ZNSt12ctype_bynameIwED2Ev"
		size = 16
		refs = "0008 _ZNSt5ctypeIwED2Ev 000c _ZTVSt12ctype_bynameIwE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_82_36_3 {
	meta:
		name = "_ZNSt12domain_errorD1Ev"
		size = 16
		refs = "0008 _ZNSt11logic_errorD2Ev 000c _ZTVSt12domain_error"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_82_32_3 {
	meta:
		name = "_ZNSt12length_errorD1Ev"
		size = 16
		refs = "0008 _ZNSt11logic_errorD2Ev 000c _ZTVSt12length_error"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_82_30_3 {
	meta:
		name = "_ZNSt12out_of_rangeD1Ev"
		size = 16
		refs = "0008 _ZNSt11logic_errorD2Ev 000c _ZTVSt12out_of_range"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_65_19_3 {
	meta:
		name = "_ZNSt12system_errorD1Ev"
		size = 16
		refs = "0008 _ZNSt13runtime_errorD2Ev 000c _ZTVSt12system_error"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_65_20_3 {
	meta:
		name = "_ZNSt12system_errorD2Ev"
		size = 16
		refs = "0008 _ZNSt13runtime_errorD2Ev 000c _ZTVSt12system_error"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_28_13_3 {
	meta:
		name = "_ZNSt13bad_exceptionD0Ev"
		size = 16
		refs = "0008 _ZdlPv 000c _ZTVSt9exception"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_28_3_3 {
	meta:
		name = "_ZNSt13bad_exceptionD1Ev"
		size = 16
		refs = "000c _ZTVSt9exception"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 0E F0 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_28_2_3 {
	meta:
		name = "_ZNSt13bad_exceptionD2Ev"
		size = 16
		refs = "000c _ZTVSt9exception"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 0E F0 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_202_3 {
	meta:
		name = "_ZNSt14codecvt_bynameIcciED1Ev"
		size = 16
		refs = "0008 _ZNSt7codecvtIcciED2Ev 000c _ZTVSt14codecvt_bynameIcciE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_203_3 {
	meta:
		name = "_ZNSt14codecvt_bynameIcciED2Ev"
		size = 16
		refs = "0008 _ZNSt7codecvtIcciED2Ev 000c _ZTVSt14codecvt_bynameIcciE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_201_3 {
	meta:
		name = "_ZNSt14codecvt_bynameIwciED1Ev"
		size = 16
		refs = "0008 _ZNSt7codecvtIwciED2Ev 000c _ZTVSt14codecvt_bynameIwciE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_202_3 {
	meta:
		name = "_ZNSt14codecvt_bynameIwciED2Ev"
		size = 16
		refs = "0008 _ZNSt7codecvtIwciED2Ev 000c _ZTVSt14codecvt_bynameIwciE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_65_13_3 {
	meta:
		name = "_ZNSt14error_categoryD0Ev"
		size = 16
		refs = "0008 _ZdlPv 000c _ZTVSt14error_category"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_65_0_3 {
	meta:
		name = "_ZNSt14error_categoryD1Ev"
		size = 16
		refs = "000c _ZTVSt14error_category"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 0E F0 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_5_3 {
	meta:
		name = "_ZNSt14overflow_errorD1Ev"
		size = 16
		refs = "0008 _ZNSt13runtime_errorD2Ev 000c _ZTVSt14overflow_error"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_180_3 {
	meta:
		name = "_ZNSt15messages_bynameIcED1Ev"
		size = 16
		refs = "0008 _ZNSt8messagesIcED2Ev 000c _ZTVSt15messages_bynameIcE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_181_3 {
	meta:
		name = "_ZNSt15messages_bynameIcED2Ev"
		size = 16
		refs = "0008 _ZNSt8messagesIcED2Ev 000c _ZTVSt15messages_bynameIcE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_179_3 {
	meta:
		name = "_ZNSt15messages_bynameIwED1Ev"
		size = 16
		refs = "0008 _ZNSt8messagesIwED2Ev 000c _ZTVSt15messages_bynameIwE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_180_3 {
	meta:
		name = "_ZNSt15messages_bynameIwED2Ev"
		size = 16
		refs = "0008 _ZNSt8messagesIwED2Ev 000c _ZTVSt15messages_bynameIwE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_217_3 {
	meta:
		name = "_ZNSt15numpunct_bynameIcED1Ev"
		size = 16
		refs = "0008 _ZNSt8numpunctIcED2Ev 000c _ZTVSt15numpunct_bynameIcE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_218_3 {
	meta:
		name = "_ZNSt15numpunct_bynameIcED2Ev"
		size = 16
		refs = "0008 _ZNSt8numpunctIcED2Ev 000c _ZTVSt15numpunct_bynameIcE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_216_3 {
	meta:
		name = "_ZNSt15numpunct_bynameIwED1Ev"
		size = 16
		refs = "0008 _ZNSt8numpunctIwED2Ev 000c _ZTVSt15numpunct_bynameIwE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_217_3 {
	meta:
		name = "_ZNSt15numpunct_bynameIwED2Ev"
		size = 16
		refs = "0008 _ZNSt8numpunctIwED2Ev 000c _ZTVSt15numpunct_bynameIwE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_258_3 {
	meta:
		name = "_ZNSt15time_get_bynameIcSt19istreambuf_iteratorIcSt11char_traitsIcEEED1Ev"
		size = 16
		refs = "0008 _ZNSt6locale5facetD2Ev 000c _ZTVSt8time_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_259_3 {
	meta:
		name = "_ZNSt15time_get_bynameIcSt19istreambuf_iteratorIcSt11char_traitsIcEEED2Ev"
		size = 16
		refs = "0008 _ZNSt6locale5facetD2Ev 000c _ZTVSt8time_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_257_3 {
	meta:
		name = "_ZNSt15time_get_bynameIwSt19istreambuf_iteratorIwSt11char_traitsIwEEED1Ev"
		size = 16
		refs = "0008 _ZNSt6locale5facetD2Ev 000c _ZTVSt8time_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_258_3 {
	meta:
		name = "_ZNSt15time_get_bynameIwSt19istreambuf_iteratorIwSt11char_traitsIwEEED2Ev"
		size = 16
		refs = "0008 _ZNSt6locale5facetD2Ev 000c _ZTVSt8time_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_255_3 {
	meta:
		name = "_ZNSt15time_put_bynameIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEED1Ev"
		size = 16
		refs = "0008 _ZNSt6locale5facetD2Ev 000c _ZTVSt8time_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_256_3 {
	meta:
		name = "_ZNSt15time_put_bynameIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEED2Ev"
		size = 16
		refs = "0008 _ZNSt6locale5facetD2Ev 000c _ZTVSt8time_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_254_3 {
	meta:
		name = "_ZNSt15time_put_bynameIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEED1Ev"
		size = 16
		refs = "0008 _ZNSt6locale5facetD2Ev 000c _ZTVSt8time_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_255_3 {
	meta:
		name = "_ZNSt15time_put_bynameIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEED2Ev"
		size = 16
		refs = "0008 _ZNSt6locale5facetD2Ev 000c _ZTVSt8time_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_4_3 {
	meta:
		name = "_ZNSt15underflow_errorD1Ev"
		size = 16
		refs = "0008 _ZNSt13runtime_errorD2Ev 000c _ZTVSt15underflow_error"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_14_3 {
	meta:
		name = "_ZNSt16invalid_argumentD1Ev"
		size = 16
		refs = "0008 _ZNSt11logic_errorD2Ev 000c _ZTVSt16invalid_argument"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_246_3 {
	meta:
		name = "_ZNSt17moneypunct_bynameIcLb0EED1Ev"
		size = 16
		refs = "0008 _ZNSt10moneypunctIcLb0EED2Ev 000c _ZTVSt17moneypunct_bynameIcLb0EE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_247_3 {
	meta:
		name = "_ZNSt17moneypunct_bynameIcLb0EED2Ev"
		size = 16
		refs = "0008 _ZNSt10moneypunctIcLb0EED2Ev 000c _ZTVSt17moneypunct_bynameIcLb0EE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_237_3 {
	meta:
		name = "_ZNSt17moneypunct_bynameIcLb1EED1Ev"
		size = 16
		refs = "0008 _ZNSt10moneypunctIcLb1EED2Ev 000c _ZTVSt17moneypunct_bynameIcLb1EE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_238_3 {
	meta:
		name = "_ZNSt17moneypunct_bynameIcLb1EED2Ev"
		size = 16
		refs = "0008 _ZNSt10moneypunctIcLb1EED2Ev 000c _ZTVSt17moneypunct_bynameIcLb1EE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_245_3 {
	meta:
		name = "_ZNSt17moneypunct_bynameIwLb0EED1Ev"
		size = 16
		refs = "0008 _ZNSt10moneypunctIwLb0EED2Ev 000c _ZTVSt17moneypunct_bynameIwLb0EE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_246_3 {
	meta:
		name = "_ZNSt17moneypunct_bynameIwLb0EED2Ev"
		size = 16
		refs = "0008 _ZNSt10moneypunctIwLb0EED2Ev 000c _ZTVSt17moneypunct_bynameIwLb0EE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_236_3 {
	meta:
		name = "_ZNSt17moneypunct_bynameIwLb1EED1Ev"
		size = 16
		refs = "0008 _ZNSt10moneypunctIwLb1EED2Ev 000c _ZTVSt17moneypunct_bynameIwLb1EE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_237_3 {
	meta:
		name = "_ZNSt17moneypunct_bynameIwLb1EED2Ev"
		size = 16
		refs = "0008 _ZNSt10moneypunctIwLb1EED2Ev 000c _ZTVSt17moneypunct_bynameIwLb1EE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_115_3 {
	meta:
		name = "_ZNSt21__ctype_abstract_baseIcED1Ev"
		size = 16
		refs = "0008 _ZNSt6locale5facetD2Ev 000c _ZTVSt21__ctype_abstract_baseIcE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_115_3 {
	meta:
		name = "_ZNSt21__ctype_abstract_baseIwED1Ev"
		size = 16
		refs = "0008 _ZNSt6locale5facetD2Ev 000c _ZTVSt21__ctype_abstract_baseIwE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_114_3 {
	meta:
		name = "_ZNSt23__codecvt_abstract_baseIcciED1Ev"
		size = 16
		refs = "0008 _ZNSt6locale5facetD2Ev 000c _ZTVSt23__codecvt_abstract_baseIcciE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_116_3 {
	meta:
		name = "_ZNSt23__codecvt_abstract_baseIwciED1Ev"
		size = 16
		refs = "0008 _ZNSt6locale5facetD2Ev 000c _ZTVSt23__codecvt_abstract_baseIwciE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_87_14_3 {
	meta:
		name = "_ZNSt6locale5facetD0Ev"
		size = 16
		refs = "0008 _ZdlPv 000c _ZTVNSt6locale5facetE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_87_7_3 {
	meta:
		name = "_ZNSt6locale5facetD1Ev"
		size = 16
		refs = "000c _ZTVNSt6locale5facetE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 0E F0 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_87_6_3 {
	meta:
		name = "_ZNSt6locale5facetD2Ev"
		size = 16
		refs = "000c _ZTVNSt6locale5facetE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 0E F0 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_124_3 {
	meta:
		name = "_ZNSt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEED1Ev"
		size = 16
		refs = "0008 _ZNSt6locale5facetD2Ev 000c _ZTVSt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_125_3 {
	meta:
		name = "_ZNSt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEED2Ev"
		size = 16
		refs = "0008 _ZNSt6locale5facetD2Ev 000c _ZTVSt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_125_3 {
	meta:
		name = "_ZNSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEED1Ev"
		size = 16
		refs = "0008 _ZNSt6locale5facetD2Ev 000c _ZTVSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_126_3 {
	meta:
		name = "_ZNSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEED2Ev"
		size = 16
		refs = "0008 _ZNSt6locale5facetD2Ev 000c _ZTVSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_122_3 {
	meta:
		name = "_ZNSt7num_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEED1Ev"
		size = 16
		refs = "0008 _ZNSt6locale5facetD2Ev 000c _ZTVSt7num_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_123_3 {
	meta:
		name = "_ZNSt7num_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEED2Ev"
		size = 16
		refs = "0008 _ZNSt6locale5facetD2Ev 000c _ZTVSt7num_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_123_3 {
	meta:
		name = "_ZNSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEED1Ev"
		size = 16
		refs = "0008 _ZNSt6locale5facetD2Ev 000c _ZTVSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_124_3 {
	meta:
		name = "_ZNSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEED2Ev"
		size = 16
		refs = "0008 _ZNSt6locale5facetD2Ev 000c _ZTVSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_13_1_3 {
	meta:
		name = "_ZNSt8bad_castD1Ev"
		size = 16
		refs = "0008 _ZNSt9exceptionD2Ev 000c _ZTVSt8bad_cast"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_13_2_3 {
	meta:
		name = "_ZNSt8bad_castD2Ev"
		size = 16
		refs = "0008 _ZNSt9exceptionD2Ev 000c _ZTVSt8bad_cast"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_116_3 {
	meta:
		name = "_ZNSt8time_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEED1Ev"
		size = 16
		refs = "0008 _ZNSt6locale5facetD2Ev 000c _ZTVSt8time_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_117_3 {
	meta:
		name = "_ZNSt8time_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEED2Ev"
		size = 16
		refs = "0008 _ZNSt6locale5facetD2Ev 000c _ZTVSt8time_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_117_3 {
	meta:
		name = "_ZNSt8time_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEED1Ev"
		size = 16
		refs = "0008 _ZNSt6locale5facetD2Ev 000c _ZTVSt8time_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_118_3 {
	meta:
		name = "_ZNSt8time_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEED2Ev"
		size = 16
		refs = "0008 _ZNSt6locale5facetD2Ev 000c _ZTVSt8time_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_118_3 {
	meta:
		name = "_ZNSt8time_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEED1Ev"
		size = 16
		refs = "0008 _ZNSt6locale5facetD2Ev 000c _ZTVSt8time_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_119_3 {
	meta:
		name = "_ZNSt8time_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEED2Ev"
		size = 16
		refs = "0008 _ZNSt6locale5facetD2Ev 000c _ZTVSt8time_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_119_3 {
	meta:
		name = "_ZNSt8time_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEED1Ev"
		size = 16
		refs = "0008 _ZNSt6locale5facetD2Ev 000c _ZTVSt8time_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_120_3 {
	meta:
		name = "_ZNSt8time_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEED2Ev"
		size = 16
		refs = "0008 _ZNSt6locale5facetD2Ev 000c _ZTVSt8time_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_105_2_3 {
	meta:
		name = "_ZNSt9bad_allocD1Ev"
		size = 16
		refs = "0008 _ZNSt9exceptionD2Ev 000c _ZTVSt9bad_alloc"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_105_3_3 {
	meta:
		name = "_ZNSt9bad_allocD2Ev"
		size = 16
		refs = "0008 _ZNSt9exceptionD2Ev 000c _ZTVSt9bad_alloc"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_21_34_3 {
	meta:
		name = "_ZNSt9basic_iosIcSt11char_traitsIcEED1Ev"
		size = 16
		refs = "0008 _ZNSt8ios_baseD2Ev 000c _ZTVSt9basic_iosIcSt11char_traitsIcEE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_21_35_3 {
	meta:
		name = "_ZNSt9basic_iosIcSt11char_traitsIcEED2Ev"
		size = 16
		refs = "0008 _ZNSt8ios_baseD2Ev 000c _ZTVSt9basic_iosIcSt11char_traitsIcEE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_21_32_3 {
	meta:
		name = "_ZNSt9basic_iosIwSt11char_traitsIwEED1Ev"
		size = 16
		refs = "0008 _ZNSt8ios_baseD2Ev 000c _ZTVSt9basic_iosIwSt11char_traitsIwEE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_21_33_3 {
	meta:
		name = "_ZNSt9basic_iosIwSt11char_traitsIwEED2Ev"
		size = 16
		refs = "0008 _ZNSt8ios_baseD2Ev 000c _ZTVSt9basic_iosIwSt11char_traitsIwEE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_28_12_3 {
	meta:
		name = "_ZNSt9exceptionD0Ev"
		size = 16
		refs = "0008 _ZdlPv 000c _ZTVSt9exception"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_28_1_3 {
	meta:
		name = "_ZNSt9exceptionD1Ev"
		size = 16
		refs = "000c _ZTVSt9exception"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 0E F0 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_28_0_3 {
	meta:
		name = "_ZNSt9exceptionD2Ev"
		size = 16
		refs = "000c _ZTVSt9exception"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 0E F0 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_128_3 {
	meta:
		name = "_ZNSt9money_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEED1Ev"
		size = 16
		refs = "0008 _ZNSt6locale5facetD2Ev 000c _ZTVSt9money_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_129_3 {
	meta:
		name = "_ZNSt9money_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEED2Ev"
		size = 16
		refs = "0008 _ZNSt6locale5facetD2Ev 000c _ZTVSt9money_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_129_3 {
	meta:
		name = "_ZNSt9money_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEED1Ev"
		size = 16
		refs = "0008 _ZNSt6locale5facetD2Ev 000c _ZTVSt9money_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_130_3 {
	meta:
		name = "_ZNSt9money_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEED2Ev"
		size = 16
		refs = "0008 _ZNSt6locale5facetD2Ev 000c _ZTVSt9money_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_126_3 {
	meta:
		name = "_ZNSt9money_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEED1Ev"
		size = 16
		refs = "0008 _ZNSt6locale5facetD2Ev 000c _ZTVSt9money_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_127_3 {
	meta:
		name = "_ZNSt9money_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEED2Ev"
		size = 16
		refs = "0008 _ZNSt6locale5facetD2Ev 000c _ZTVSt9money_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_127_3 {
	meta:
		name = "_ZNSt9money_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEED1Ev"
		size = 16
		refs = "0008 _ZNSt6locale5facetD2Ev 000c _ZTVSt9money_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_128_3 {
	meta:
		name = "_ZNSt9money_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEED2Ev"
		size = 16
		refs = "0008 _ZNSt6locale5facetD2Ev 000c _ZTVSt9money_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_52_7_3 {
	meta:
		name = "_ZNSt9type_infoD0Ev"
		size = 16
		refs = "0008 _ZdlPv 000c _ZTVSt9type_info"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_52_1_3 {
	meta:
		name = "_ZNSt9type_infoD1Ev"
		size = 16
		refs = "000c _ZTVSt9type_info"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 0E F0 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_52_0_3 {
	meta:
		name = "_ZNSt9type_infoD2Ev"
		size = 16
		refs = "000c _ZTVSt9type_info"
	strings:
		$1 = { 04 30 9F E5 00 30 80 E5 0E F0 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_7_3_3 {
	meta:
		name = "_ZN10__cxxabiv129__pointer_to_member_type_infoD0Ev"
		size = 36
		refs = "0010 _ZN10__cxxabiv117__pbase_type_infoD2Ev 001c _ZdlPv 0020 _ZTVN10__cxxabiv129__pointer_to_member_type_infoE"
	strings:
		$1 = { 18 30 9F E5 10 40 2D E9 00 30 80 E5 00 40 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_70_2_3 {
	meta:
		name = "_ZN10__cxxabiv116__enum_type_infoD0Ev"
		size = 36
		refs = "0010 _ZNSt9type_infoD2Ev 001c _ZdlPv 0020 _ZTVN10__cxxabiv116__enum_type_infoE"
	strings:
		$1 = { 18 30 9F E5 10 40 2D E9 00 30 80 E5 00 40 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_107_2_3 {
	meta:
		name = "_ZN10__cxxabiv117__array_type_infoD0Ev"
		size = 36
		refs = "0010 _ZNSt9type_infoD2Ev 001c _ZdlPv 0020 _ZTVN10__cxxabiv117__array_type_infoE"
	strings:
		$1 = { 18 30 9F E5 10 40 2D E9 00 30 80 E5 00 40 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_104_7_3 {
	meta:
		name = "_ZN10__cxxabiv117__class_type_infoD0Ev"
		size = 36
		refs = "0010 _ZNSt9type_infoD2Ev 001c _ZdlPv 0020 _ZTVN10__cxxabiv117__class_type_infoE"
	strings:
		$1 = { 18 30 9F E5 10 40 2D E9 00 30 80 E5 00 40 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_72_4_3 {
	meta:
		name = "_ZN10__cxxabiv117__pbase_type_infoD0Ev"
		size = 36
		refs = "0010 _ZNSt9type_infoD2Ev 001c _ZdlPv 0020 _ZTVN10__cxxabiv117__pbase_type_infoE"
	strings:
		$1 = { 18 30 9F E5 10 40 2D E9 00 30 80 E5 00 40 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_31_4_3 {
	meta:
		name = "_ZN10__cxxabiv119__pointer_type_infoD0Ev"
		size = 36
		refs = "0010 _ZN10__cxxabiv117__pbase_type_infoD2Ev 001c _ZdlPv 0020 _ZTVN10__cxxabiv119__pointer_type_infoE"
	strings:
		$1 = { 18 30 9F E5 10 40 2D E9 00 30 80 E5 00 40 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_24_3_3 {
	meta:
		name = "_ZN10__cxxabiv120__function_type_infoD0Ev"
		size = 36
		refs = "0010 _ZNSt9type_infoD2Ev 001c _ZdlPv 0020 _ZTVN10__cxxabiv120__function_type_infoE"
	strings:
		$1 = { 18 30 9F E5 10 40 2D E9 00 30 80 E5 00 40 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_69_5_3 {
	meta:
		name = "_ZN10__cxxabiv120__si_class_type_infoD0Ev"
		size = 36
		refs = "0010 _ZN10__cxxabiv117__class_type_infoD2Ev 001c _ZdlPv 0020 _ZTVN10__cxxabiv120__si_class_type_infoE"
	strings:
		$1 = { 18 30 9F E5 10 40 2D E9 00 30 80 E5 00 40 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_36_5_3 {
	meta:
		name = "_ZN10__cxxabiv121__vmi_class_type_infoD0Ev"
		size = 36
		refs = "0010 _ZN10__cxxabiv117__class_type_infoD2Ev 001c _ZdlPv 0020 _ZTVN10__cxxabiv121__vmi_class_type_infoE"
	strings:
		$1 = { 18 30 9F E5 10 40 2D E9 00 30 80 E5 00 40 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_92_2_3 {
	meta:
		name = "_ZN10__cxxabiv123__fundamental_type_infoD0Ev"
		size = 36
		refs = "0010 _ZNSt9type_infoD2Ev 001c _ZdlPv 0020 _ZTVN10__cxxabiv123__fundamental_type_infoE"
	strings:
		$1 = { 18 30 9F E5 10 40 2D E9 00 30 80 E5 00 40 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_89_10_3 {
	meta:
		name = "_ZN9__gnu_cxx20recursive_init_errorD0Ev"
		size = 36
		refs = "0010 _ZNSt9exceptionD2Ev 001c _ZdlPv 0020 _ZTVN9__gnu_cxx20recursive_init_errorE"
	strings:
		$1 = { 18 30 9F E5 10 40 2D E9 00 30 80 E5 00 40 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_87_12_3 {
	meta:
		name = "_ZN9__gnu_cxx24__concurrence_lock_errorD0Ev"
		size = 36
		refs = "0010 _ZNSt9exceptionD2Ev 001c _ZdlPv 0020 _ZTVN9__gnu_cxx24__concurrence_lock_errorE"
	strings:
		$1 = { 18 30 9F E5 10 40 2D E9 00 30 80 E5 00 40 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_106_25_3 {
	meta:
		name = "_ZN9__gnu_cxx26__concurrence_unlock_errorD0Ev"
		size = 36
		refs = "0010 _ZNSt9exceptionD2Ev 001c _ZdlPv 0020 _ZTVN9__gnu_cxx26__concurrence_unlock_errorE"
	strings:
		$1 = { 18 30 9F E5 10 40 2D E9 00 30 80 E5 00 40 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_43_3_3 {
	meta:
		name = "_ZNSt10bad_typeidD0Ev"
		size = 36
		refs = "0010 _ZNSt9exceptionD2Ev 001c _ZdlPv 0020 _ZTVSt10bad_typeid"
	strings:
		$1 = { 18 30 9F E5 10 40 2D E9 00 30 80 E5 00 40 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_82_25_3 {
	meta:
		name = "_ZNSt11range_errorD0Ev"
		size = 36
		refs = "0010 _ZNSt13runtime_errorD2Ev 001c _ZdlPv 0020 _ZTVSt11range_error"
	strings:
		$1 = { 18 30 9F E5 10 40 2D E9 00 30 80 E5 00 40 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_40_20_3 {
	meta:
		name = "_ZNSt12ctype_bynameIcED0Ev"
		size = 36
		refs = "0010 _ZNSt5ctypeIcED2Ev 001c _ZdlPv 0020 _ZTVSt12ctype_bynameIcE"
	strings:
		$1 = { 18 30 9F E5 10 40 2D E9 00 30 80 E5 00 40 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_83_13_3 {
	meta:
		name = "_ZNSt12ctype_bynameIwED0Ev"
		size = 36
		refs = "0010 _ZNSt5ctypeIwED2Ev 001c _ZdlPv 0020 _ZTVSt12ctype_bynameIwE"
	strings:
		$1 = { 18 30 9F E5 10 40 2D E9 00 30 80 E5 00 40 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_82_35_3 {
	meta:
		name = "_ZNSt12domain_errorD0Ev"
		size = 36
		refs = "0010 _ZNSt11logic_errorD2Ev 001c _ZdlPv 0020 _ZTVSt12domain_error"
	strings:
		$1 = { 18 30 9F E5 10 40 2D E9 00 30 80 E5 00 40 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_82_31_3 {
	meta:
		name = "_ZNSt12length_errorD0Ev"
		size = 36
		refs = "0010 _ZNSt11logic_errorD2Ev 001c _ZdlPv 0020 _ZTVSt12length_error"
	strings:
		$1 = { 18 30 9F E5 10 40 2D E9 00 30 80 E5 00 40 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_82_29_3 {
	meta:
		name = "_ZNSt12out_of_rangeD0Ev"
		size = 36
		refs = "0010 _ZNSt11logic_errorD2Ev 001c _ZdlPv 0020 _ZTVSt12out_of_range"
	strings:
		$1 = { 18 30 9F E5 10 40 2D E9 00 30 80 E5 00 40 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_65_18_3 {
	meta:
		name = "_ZNSt12system_errorD0Ev"
		size = 36
		refs = "0010 _ZNSt13runtime_errorD2Ev 001c _ZdlPv 0020 _ZTVSt12system_error"
	strings:
		$1 = { 18 30 9F E5 10 40 2D E9 00 30 80 E5 00 40 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_201_3 {
	meta:
		name = "_ZNSt14codecvt_bynameIcciED0Ev"
		size = 36
		refs = "0010 _ZNSt7codecvtIcciED2Ev 001c _ZdlPv 0020 _ZTVSt14codecvt_bynameIcciE"
	strings:
		$1 = { 18 30 9F E5 10 40 2D E9 00 30 80 E5 00 40 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_200_3 {
	meta:
		name = "_ZNSt14codecvt_bynameIwciED0Ev"
		size = 36
		refs = "0010 _ZNSt7codecvtIwciED2Ev 001c _ZdlPv 0020 _ZTVSt14codecvt_bynameIwciE"
	strings:
		$1 = { 18 30 9F E5 10 40 2D E9 00 30 80 E5 00 40 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_8_3 {
	meta:
		name = "_ZNSt14overflow_errorD0Ev"
		size = 36
		refs = "0010 _ZNSt13runtime_errorD2Ev 001c _ZdlPv 0020 _ZTVSt14overflow_error"
	strings:
		$1 = { 18 30 9F E5 10 40 2D E9 00 30 80 E5 00 40 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_179_3 {
	meta:
		name = "_ZNSt15messages_bynameIcED0Ev"
		size = 36
		refs = "0010 _ZNSt8messagesIcED2Ev 001c _ZdlPv 0020 _ZTVSt15messages_bynameIcE"
	strings:
		$1 = { 18 30 9F E5 10 40 2D E9 00 30 80 E5 00 40 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_178_3 {
	meta:
		name = "_ZNSt15messages_bynameIwED0Ev"
		size = 36
		refs = "0010 _ZNSt8messagesIwED2Ev 001c _ZdlPv 0020 _ZTVSt15messages_bynameIwE"
	strings:
		$1 = { 18 30 9F E5 10 40 2D E9 00 30 80 E5 00 40 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_216_3 {
	meta:
		name = "_ZNSt15numpunct_bynameIcED0Ev"
		size = 36
		refs = "0010 _ZNSt8numpunctIcED2Ev 001c _ZdlPv 0020 _ZTVSt15numpunct_bynameIcE"
	strings:
		$1 = { 18 30 9F E5 10 40 2D E9 00 30 80 E5 00 40 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_215_3 {
	meta:
		name = "_ZNSt15numpunct_bynameIwED0Ev"
		size = 36
		refs = "0010 _ZNSt8numpunctIwED2Ev 001c _ZdlPv 0020 _ZTVSt15numpunct_bynameIwE"
	strings:
		$1 = { 18 30 9F E5 10 40 2D E9 00 30 80 E5 00 40 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_257_3 {
	meta:
		name = "_ZNSt15time_get_bynameIcSt19istreambuf_iteratorIcSt11char_traitsIcEEED0Ev"
		size = 36
		refs = "0010 _ZNSt6locale5facetD2Ev 001c _ZdlPv 0020 _ZTVSt8time_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 18 30 9F E5 10 40 2D E9 00 30 80 E5 00 40 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_256_3 {
	meta:
		name = "_ZNSt15time_get_bynameIwSt19istreambuf_iteratorIwSt11char_traitsIwEEED0Ev"
		size = 36
		refs = "0010 _ZNSt6locale5facetD2Ev 001c _ZdlPv 0020 _ZTVSt8time_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE"
	strings:
		$1 = { 18 30 9F E5 10 40 2D E9 00 30 80 E5 00 40 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_254_3 {
	meta:
		name = "_ZNSt15time_put_bynameIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEED0Ev"
		size = 36
		refs = "0010 _ZNSt6locale5facetD2Ev 001c _ZdlPv 0020 _ZTVSt8time_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 18 30 9F E5 10 40 2D E9 00 30 80 E5 00 40 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_253_3 {
	meta:
		name = "_ZNSt15time_put_bynameIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEED0Ev"
		size = 36
		refs = "0010 _ZNSt6locale5facetD2Ev 001c _ZdlPv 0020 _ZTVSt8time_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE"
	strings:
		$1 = { 18 30 9F E5 10 40 2D E9 00 30 80 E5 00 40 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_7_3 {
	meta:
		name = "_ZNSt15underflow_errorD0Ev"
		size = 36
		refs = "0010 _ZNSt13runtime_errorD2Ev 001c _ZdlPv 0020 _ZTVSt15underflow_error"
	strings:
		$1 = { 18 30 9F E5 10 40 2D E9 00 30 80 E5 00 40 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_15_3 {
	meta:
		name = "_ZNSt16invalid_argumentD0Ev"
		size = 36
		refs = "0010 _ZNSt11logic_errorD2Ev 001c _ZdlPv 0020 _ZTVSt16invalid_argument"
	strings:
		$1 = { 18 30 9F E5 10 40 2D E9 00 30 80 E5 00 40 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_134_3 {
	meta:
		name = "_ZNSt17__timepunct_cacheIcED0Ev"
		size = 36
		refs = "0010 _ZNSt6locale5facetD2Ev 0018 _ZdlPv 0020 _ZTVSt17__timepunct_cacheIcE"
	strings:
		$1 = { 18 30 9F E5 10 40 2D E9 00 30 80 E5 00 40 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 ?? ?? ?? ?? 10 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_135_3 {
	meta:
		name = "_ZNSt17__timepunct_cacheIwED0Ev"
		size = 36
		refs = "0010 _ZNSt6locale5facetD2Ev 0018 _ZdlPv 0020 _ZTVSt17__timepunct_cacheIwE"
	strings:
		$1 = { 18 30 9F E5 10 40 2D E9 00 30 80 E5 00 40 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 ?? ?? ?? ?? 10 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_245_3 {
	meta:
		name = "_ZNSt17moneypunct_bynameIcLb0EED0Ev"
		size = 36
		refs = "0010 _ZNSt10moneypunctIcLb0EED2Ev 001c _ZdlPv 0020 _ZTVSt17moneypunct_bynameIcLb0EE"
	strings:
		$1 = { 18 30 9F E5 10 40 2D E9 00 30 80 E5 00 40 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_236_3 {
	meta:
		name = "_ZNSt17moneypunct_bynameIcLb1EED0Ev"
		size = 36
		refs = "0010 _ZNSt10moneypunctIcLb1EED2Ev 001c _ZdlPv 0020 _ZTVSt17moneypunct_bynameIcLb1EE"
	strings:
		$1 = { 18 30 9F E5 10 40 2D E9 00 30 80 E5 00 40 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_244_3 {
	meta:
		name = "_ZNSt17moneypunct_bynameIwLb0EED0Ev"
		size = 36
		refs = "0010 _ZNSt10moneypunctIwLb0EED2Ev 001c _ZdlPv 0020 _ZTVSt17moneypunct_bynameIwLb0EE"
	strings:
		$1 = { 18 30 9F E5 10 40 2D E9 00 30 80 E5 00 40 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_235_3 {
	meta:
		name = "_ZNSt17moneypunct_bynameIwLb1EED0Ev"
		size = 36
		refs = "0010 _ZNSt10moneypunctIwLb1EED2Ev 001c _ZdlPv 0020 _ZTVSt17moneypunct_bynameIwLb1EE"
	strings:
		$1 = { 18 30 9F E5 10 40 2D E9 00 30 80 E5 00 40 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_131_3 {
	meta:
		name = "_ZNSt21__ctype_abstract_baseIcED0Ev"
		size = 36
		refs = "0010 _ZNSt6locale5facetD2Ev 001c _ZdlPv 0020 _ZTVSt21__ctype_abstract_baseIcE"
	strings:
		$1 = { 18 30 9F E5 10 40 2D E9 00 30 80 E5 00 40 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_131_3 {
	meta:
		name = "_ZNSt21__ctype_abstract_baseIwED0Ev"
		size = 36
		refs = "0010 _ZNSt6locale5facetD2Ev 001c _ZdlPv 0020 _ZTVSt21__ctype_abstract_baseIwE"
	strings:
		$1 = { 18 30 9F E5 10 40 2D E9 00 30 80 E5 00 40 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_130_3 {
	meta:
		name = "_ZNSt23__codecvt_abstract_baseIcciED0Ev"
		size = 36
		refs = "0010 _ZNSt6locale5facetD2Ev 001c _ZdlPv 0020 _ZTVSt23__codecvt_abstract_baseIcciE"
	strings:
		$1 = { 18 30 9F E5 10 40 2D E9 00 30 80 E5 00 40 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_132_3 {
	meta:
		name = "_ZNSt23__codecvt_abstract_baseIwciED0Ev"
		size = 36
		refs = "0010 _ZNSt6locale5facetD2Ev 001c _ZdlPv 0020 _ZTVSt23__codecvt_abstract_baseIwciE"
	strings:
		$1 = { 18 30 9F E5 10 40 2D E9 00 30 80 E5 00 40 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_136_3 {
	meta:
		name = "_ZNSt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEED0Ev"
		size = 36
		refs = "0010 _ZNSt6locale5facetD2Ev 001c _ZdlPv 0020 _ZTVSt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 18 30 9F E5 10 40 2D E9 00 30 80 E5 00 40 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_137_3 {
	meta:
		name = "_ZNSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEED0Ev"
		size = 36
		refs = "0010 _ZNSt6locale5facetD2Ev 001c _ZdlPv 0020 _ZTVSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE"
	strings:
		$1 = { 18 30 9F E5 10 40 2D E9 00 30 80 E5 00 40 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_135_3 {
	meta:
		name = "_ZNSt7num_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEED0Ev"
		size = 36
		refs = "0010 _ZNSt6locale5facetD2Ev 001c _ZdlPv 0020 _ZTVSt7num_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 18 30 9F E5 10 40 2D E9 00 30 80 E5 00 40 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_136_3 {
	meta:
		name = "_ZNSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEED0Ev"
		size = 36
		refs = "0010 _ZNSt6locale5facetD2Ev 001c _ZdlPv 0020 _ZTVSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE"
	strings:
		$1 = { 18 30 9F E5 10 40 2D E9 00 30 80 E5 00 40 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_13_3_3 {
	meta:
		name = "_ZNSt8bad_castD0Ev"
		size = 36
		refs = "0010 _ZNSt9exceptionD2Ev 001c _ZdlPv 0020 _ZTVSt8bad_cast"
	strings:
		$1 = { 18 30 9F E5 10 40 2D E9 00 30 80 E5 00 40 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_132_3 {
	meta:
		name = "_ZNSt8time_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEED0Ev"
		size = 36
		refs = "0010 _ZNSt6locale5facetD2Ev 001c _ZdlPv 0020 _ZTVSt8time_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 18 30 9F E5 10 40 2D E9 00 30 80 E5 00 40 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_133_3 {
	meta:
		name = "_ZNSt8time_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEED0Ev"
		size = 36
		refs = "0010 _ZNSt6locale5facetD2Ev 001c _ZdlPv 0020 _ZTVSt8time_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE"
	strings:
		$1 = { 18 30 9F E5 10 40 2D E9 00 30 80 E5 00 40 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_133_3 {
	meta:
		name = "_ZNSt8time_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEED0Ev"
		size = 36
		refs = "0010 _ZNSt6locale5facetD2Ev 001c _ZdlPv 0020 _ZTVSt8time_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 18 30 9F E5 10 40 2D E9 00 30 80 E5 00 40 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_134_3 {
	meta:
		name = "_ZNSt8time_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEED0Ev"
		size = 36
		refs = "0010 _ZNSt6locale5facetD2Ev 001c _ZdlPv 0020 _ZTVSt8time_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE"
	strings:
		$1 = { 18 30 9F E5 10 40 2D E9 00 30 80 E5 00 40 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_105_4_3 {
	meta:
		name = "_ZNSt9bad_allocD0Ev"
		size = 36
		refs = "0010 _ZNSt9exceptionD2Ev 001c _ZdlPv 0020 _ZTVSt9bad_alloc"
	strings:
		$1 = { 18 30 9F E5 10 40 2D E9 00 30 80 E5 00 40 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_21_37_3 {
	meta:
		name = "_ZNSt9basic_iosIcSt11char_traitsIcEED0Ev"
		size = 36
		refs = "0010 _ZNSt8ios_baseD2Ev 001c _ZdlPv 0020 _ZTVSt9basic_iosIcSt11char_traitsIcEE"
	strings:
		$1 = { 18 30 9F E5 10 40 2D E9 00 30 80 E5 00 40 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_21_36_3 {
	meta:
		name = "_ZNSt9basic_iosIwSt11char_traitsIwEED0Ev"
		size = 36
		refs = "0010 _ZNSt8ios_baseD2Ev 001c _ZdlPv 0020 _ZTVSt9basic_iosIwSt11char_traitsIwEE"
	strings:
		$1 = { 18 30 9F E5 10 40 2D E9 00 30 80 E5 00 40 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_138_3 {
	meta:
		name = "_ZNSt9money_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEED0Ev"
		size = 36
		refs = "0010 _ZNSt6locale5facetD2Ev 001c _ZdlPv 0020 _ZTVSt9money_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 18 30 9F E5 10 40 2D E9 00 30 80 E5 00 40 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_139_3 {
	meta:
		name = "_ZNSt9money_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEED0Ev"
		size = 36
		refs = "0010 _ZNSt6locale5facetD2Ev 001c _ZdlPv 0020 _ZTVSt9money_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE"
	strings:
		$1 = { 18 30 9F E5 10 40 2D E9 00 30 80 E5 00 40 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_137_3 {
	meta:
		name = "_ZNSt9money_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEED0Ev"
		size = 36
		refs = "0010 _ZNSt6locale5facetD2Ev 001c _ZdlPv 0020 _ZTVSt9money_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 18 30 9F E5 10 40 2D E9 00 30 80 E5 00 40 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_138_3 {
	meta:
		name = "_ZNSt9money_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEED0Ev"
		size = 36
		refs = "0010 _ZNSt6locale5facetD2Ev 001c _ZdlPv 0020 _ZTVSt9money_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE"
	strings:
		$1 = { 18 30 9F E5 10 40 2D E9 00 30 80 E5 00 40 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_8_0_3 {
	meta:
		name = "_ZNSt8ios_base5imbueERKSt6locale"
		size = 60
		refs = "0018 _ZNSt6localeC1ERKS_ 0024 _ZNSt6localeaSERKS_ 0030 _ZNSt8ios_base17_M_call_callbacksENS_5eventE"
	strings:
		$1 = { F0 40 2D E9 6C 50 81 E2 02 70 A0 E1 01 40 A0 E1 05 10 A0 E1 00 60 A0 E1 ?? ?? ?? ?? 07 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 01 10 A0 E3 ?? ?? ?? ?? 06 00 A0 E1 F0 80 BD E8 }
	condition:
		$1
}

rule file_8_1_3 {
	meta:
		name = "_ZNSt8ios_base7_M_initEv"
		size = 80
		refs = "0028 _ZNSt6localeC1Ev 0034 _ZNSt6localeaSERKS_ 0040 _ZNSt6localeD1Ev"
	strings:
		$1 = { 30 40 2D E9 06 30 A0 E3 04 30 80 E5 00 30 A0 E3 08 30 80 E5 30 30 9F E5 04 D0 4D E2 0C 30 80 E5 00 50 A0 E1 0D 00 A0 E1 ?? ?? ?? ?? 6C 00 85 E2 0D 10 A0 E1 ?? ?? ?? ?? 0D 00 A0 E1 0D 40 A0 E1 ?? ?? ?? ?? 04 D0 8D E2 30 80 BD E8 02 10 00 00 }
	condition:
		$1
}

rule file_9_0_3 {
	meta:
		name = "_ZSt18__throw_bad_typeidv"
		size = 40
		refs = "0004 __cxa_allocate_exception 0018 __cxa_throw 001c _ZTVSt10bad_typeid 0020 _ZTISt10bad_typeid 0024 _ZNSt10bad_typeidD1Ev"
	strings:
		$1 = { 04 00 A0 E3 ?? ?? ?? ?? 0C 30 9F E5 0C 10 9F E5 00 30 80 E5 08 20 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_1_3 {
	meta:
		name = "_ZSt16__throw_bad_castv"
		size = 40
		refs = "0004 __cxa_allocate_exception 0018 __cxa_throw 001c _ZTVSt8bad_cast 0020 _ZTISt8bad_cast 0024 _ZNSt8bad_castD1Ev"
	strings:
		$1 = { 04 00 A0 E3 ?? ?? ?? ?? 0C 30 9F E5 0C 10 9F E5 00 30 80 E5 08 20 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_2_3 {
	meta:
		name = "_ZSt17__throw_bad_allocv"
		size = 40
		refs = "0004 __cxa_allocate_exception 0018 __cxa_throw 001c _ZTVSt9bad_alloc 0020 _ZTISt9bad_alloc 0024 _ZNSt9bad_allocD1Ev"
	strings:
		$1 = { 04 00 A0 E3 ?? ?? ?? ?? 0C 30 9F E5 0C 10 9F E5 00 30 80 E5 08 20 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_3_3 {
	meta:
		name = "_ZSt21__throw_bad_exceptionv"
		size = 40
		refs = "0004 __cxa_allocate_exception 0018 __cxa_throw 001c _ZTVSt13bad_exception 0020 _ZTISt13bad_exception 0024 _ZNSt13bad_exceptionD1Ev"
	strings:
		$1 = { 04 00 A0 E3 ?? ?? ?? ?? 0C 30 9F E5 0C 10 9F E5 00 30 80 E5 08 20 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_18_3 {
	meta:
		name = "_ZSt20__throw_system_errori"
		size = 380
		refs = "0034 _Unwind_SjLj_Register 0040 _ZSt16generic_categoryv 004c __cxa_allocate_exception 0068 _ZNSsC1EPKcRKSaIcE 007c _ZNSt13runtime_errorC2ERKSs 00cc __cxa_throw 00fc _ZNSs4_Rep10_M_destroyERKSaIcE 0114 _ZN9__gnu_cxx18__exchange_and_addEPVii 013c _ZNSsD1Ev 0144 __cxa_free_exception 0154 _Unwind_SjLj_Resume 0158 __gxx_personality_sj0 015c .gcc_except_table 0160 .text$_ZSt20__throw_system_errori 0164 .rdata 0168 _ZNSs4_Rep20_S_empty_rep_storageE 016c _ZTVSt12system_error 0170 _ZTISt12system_error 0174 _ZNSt12system_errorD1Ev 0178 _CRT_MT"
	strings:
		$1 = { 50 31 9F E5 04 B0 4D E2 50 D0 4D E2 24 30 0B E5 44 31 9F E5 04 10 8B E2 20 30 0B E5 3C 31 9F E5 4C 00 0B E5 3C 00 4B E2 1C 10 0B E5 18 30 0B E5 14 D0 0B E5 ?? ?? ?? ?? 00 30 E0 E3 38 30 0B E5 ?? ?? ?? ?? 48 00 0B E5 10 00 A0 E3 ?? ?? ?? ?? 03 30 A0 E3 40 00 0B E5 04 11 9F E5 08 00 4B E2 0B 20 A0 E1 38 30 0B E5 ?? ?? ?? ?? 02 30 A0 E3 40 00 1B E5 08 10 4B E2 38 30 0B E5 ?? ?? ?? ?? 08 30 1B E5 0C 20 43 E2 44 20 0B E5 44 10 1B E5 D0 20 9F E5 02 00 51 E1 0C 00 00 1A 40 10 1B E5 C4 30 9F E5 48 20 1B E5 00 30 81 E5 4C 30 1B E5 0C 20 81 E5 08 30 81 E5 01 00 A0 E1 00 30 E0 E3 A8 10 9F E5 A8 20 9F E5 38 30 0B E5 ?? ?? ?? ?? A0 20 9F E5 00 20 92 E5 00 00 52 E3 08 00 00 1A 04 00 13 E5 01 20 40 E2 04 20 03 E5 00 00 50 E3 E9 FF FF CA 44 00 1B E5 04 10 4B E2 ?? ?? ?? ?? E5 FF FF EA 01 30 A0 E3 08 00 81 E2 00 10 E0 E3 38 30 0B E5 ?? ?? ?? ?? F3 FF FF EA 04 B0 4B E2 38 30 1B E5 34 20 1B E5 01 00 53 E3 44 20 0B E5 00 30 A0 03 08 00 4B 02 38 30 0B 05 ?? ?? ?? ?? 40 00 1B E5 ?? ?? ?? ?? 00 30 E0 E3 44 00 1B E5 38 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_19_3 {
	meta:
		name = "_ZSt19__throw_ios_failurePKc"
		size = 304
		refs = "0034 _Unwind_SjLj_Register 004c _ZNSsC1EPKcRKSaIcE 0054 __cxa_allocate_exception 0060 _ZNSt8ios_base7failureC1ERKSs 0094 __cxa_throw 00c4 _ZNSs4_Rep10_M_destroyERKSaIcE 00dc _ZN9__gnu_cxx18__exchange_and_addEPVii 010c _Unwind_SjLj_Resume 0110 _ZSt9terminatev 0114 __gxx_personality_sj0 0118 .gcc_except_table 011c .text$_ZSt19__throw_ios_failurePKc 0120 _ZNSs4_Rep20_S_empty_rep_storageE 0124 _ZTINSt8ios_base7failureE 0128 _ZNSt8ios_base7failureD1Ev 012c _CRT_MT"
	strings:
		$1 = { 0C 31 9F E5 04 B0 4D E2 48 D0 4D E2 24 30 0B E5 00 31 9F E5 04 10 8B E2 20 30 0B E5 F8 30 9F E5 40 00 0B E5 3C 00 4B E2 18 30 0B E5 1C 10 0B E5 14 D0 0B E5 ?? ?? ?? ?? 02 30 A0 E3 40 10 1B E5 08 00 4B E2 0B 20 A0 E1 38 30 0B E5 ?? ?? ?? ?? 08 00 A0 E3 ?? ?? ?? ?? 08 10 4B E2 44 00 0B E5 ?? ?? ?? ?? 08 30 1B E5 0C 20 43 E2 40 20 0B E5 40 10 1B E5 A4 20 9F E5 02 00 51 E1 05 00 00 1A 00 30 E0 E3 44 00 1B E5 94 10 9F E5 94 20 9F E5 38 30 0B E5 ?? ?? ?? ?? 8C 20 9F E5 00 20 92 E5 00 00 52 E3 08 00 00 1A 04 00 13 E5 01 20 40 E2 04 20 03 E5 00 00 50 E3 F0 FF FF CA 40 00 1B E5 04 10 4B E2 ?? ?? ?? ?? EC FF FF EA 01 30 A0 E3 08 00 81 E2 00 10 E0 E3 38 30 0B E5 ?? ?? ?? ?? F3 FF FF EA 04 B0 4B E2 38 30 1B E5 34 00 1B E5 01 00 53 E3 30 30 1B E5 01 00 00 0A 01 00 73 E3 02 00 00 0A 00 30 E0 E3 38 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_20_3 {
	meta:
		name = "_ZSt23__throw_underflow_errorPKc"
		size = 364
		refs = "0034 _Unwind_SjLj_Register 004c _ZNSsC1EPKcRKSaIcE 0054 __cxa_allocate_exception 0068 _ZNSt15underflow_errorC1ERKSs 0098 __cxa_throw 00c8 _ZNSs4_Rep10_M_destroyERKSaIcE 00e0 _ZN9__gnu_cxx18__exchange_and_addEPVii 012c _Unwind_SjLj_Resume 0134 __cxa_free_exception 0144 _ZNSsD1Ev 014c _ZSt9terminatev 0150 __gxx_personality_sj0 0154 .gcc_except_table 0158 .text$_ZSt23__throw_underflow_errorPKc 015c _ZNSs4_Rep20_S_empty_rep_storageE 0160 _ZTISt15underflow_error 0164 _ZNSt15underflow_errorD1Ev 0168 _CRT_MT"
	strings:
		$1 = { 48 31 9F E5 04 B0 4D E2 4C D0 4D E2 24 30 0B E5 3C 31 9F E5 04 10 8B E2 20 30 0B E5 34 31 9F E5 40 00 0B E5 3C 00 4B E2 18 30 0B E5 1C 10 0B E5 14 D0 0B E5 ?? ?? ?? ?? 04 30 A0 E3 40 10 1B E5 08 00 4B E2 0B 20 A0 E1 38 30 0B E5 ?? ?? ?? ?? 08 00 A0 E3 ?? ?? ?? ?? 03 30 A0 E3 08 10 4B E2 44 00 0B E5 38 30 0B E5 ?? ?? ?? ?? 08 30 1B E5 E4 20 9F E5 0C 10 43 E2 02 00 51 E1 40 10 0B E5 05 00 00 1A 00 30 E0 E3 44 00 1B E5 CC 10 9F E5 CC 20 9F E5 38 30 0B E5 ?? ?? ?? ?? C4 20 9F E5 00 20 92 E5 00 00 52 E3 08 00 00 1A 04 00 13 E5 01 20 40 E2 04 20 03 E5 00 00 50 E3 F0 FF FF CA 40 00 1B E5 04 10 4B E2 ?? ?? ?? ?? EC FF FF EA 01 30 A0 E3 08 00 81 E2 00 10 E0 E3 38 30 0B E5 ?? ?? ?? ?? F3 FF FF EA 04 B0 4B E2 38 20 1B E5 34 30 1B E5 01 00 52 E3 48 30 0B E5 40 20 0B E5 30 30 1B E5 03 00 00 0A 02 00 52 E3 07 00 00 0A 03 00 52 E3 01 00 00 0A 01 00 73 E3 0A 00 00 0A 00 30 E0 E3 48 00 1B E5 38 30 0B E5 ?? ?? ?? ?? 44 00 1B E5 ?? ?? ?? ?? 40 20 1B E5 08 00 4B E2 38 20 0B E5 ?? ?? ?? ?? F4 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_28_3 {
	meta:
		name = "_ZSt19__throw_logic_errorPKc"
		size = 364
		refs = "0034 _Unwind_SjLj_Register 004c _ZNSsC1EPKcRKSaIcE 0054 __cxa_allocate_exception 0068 _ZNSt11logic_errorC1ERKSs 0098 __cxa_throw 00c8 _ZNSs4_Rep10_M_destroyERKSaIcE 00e0 _ZN9__gnu_cxx18__exchange_and_addEPVii 012c _Unwind_SjLj_Resume 0134 __cxa_free_exception 0144 _ZNSsD1Ev 014c _ZSt9terminatev 0150 __gxx_personality_sj0 0154 .gcc_except_table 0158 .text$_ZSt19__throw_logic_errorPKc 015c _ZNSs4_Rep20_S_empty_rep_storageE 0160 _ZTISt11logic_error 0164 _ZNSt11logic_errorD1Ev 0168 _CRT_MT"
	strings:
		$1 = { 48 31 9F E5 04 B0 4D E2 4C D0 4D E2 24 30 0B E5 3C 31 9F E5 04 10 8B E2 20 30 0B E5 34 31 9F E5 40 00 0B E5 3C 00 4B E2 18 30 0B E5 1C 10 0B E5 14 D0 0B E5 ?? ?? ?? ?? 04 30 A0 E3 40 10 1B E5 08 00 4B E2 0B 20 A0 E1 38 30 0B E5 ?? ?? ?? ?? 08 00 A0 E3 ?? ?? ?? ?? 03 30 A0 E3 08 10 4B E2 44 00 0B E5 38 30 0B E5 ?? ?? ?? ?? 08 30 1B E5 E4 20 9F E5 0C 10 43 E2 02 00 51 E1 40 10 0B E5 05 00 00 1A 00 30 E0 E3 44 00 1B E5 CC 10 9F E5 CC 20 9F E5 38 30 0B E5 ?? ?? ?? ?? C4 20 9F E5 00 20 92 E5 00 00 52 E3 08 00 00 1A 04 00 13 E5 01 20 40 E2 04 20 03 E5 00 00 50 E3 F0 FF FF CA 40 00 1B E5 04 10 4B E2 ?? ?? ?? ?? EC FF FF EA 01 30 A0 E3 08 00 81 E2 00 10 E0 E3 38 30 0B E5 ?? ?? ?? ?? F3 FF FF EA 04 B0 4B E2 38 20 1B E5 34 30 1B E5 01 00 52 E3 48 30 0B E5 40 20 0B E5 30 30 1B E5 03 00 00 0A 02 00 52 E3 07 00 00 0A 03 00 52 E3 01 00 00 0A 01 00 73 E3 0A 00 00 0A 00 30 E0 E3 48 00 1B E5 38 30 0B E5 ?? ?? ?? ?? 44 00 1B E5 ?? ?? ?? ?? 40 20 1B E5 08 00 4B E2 38 20 0B E5 ?? ?? ?? ?? F4 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_22_3 {
	meta:
		name = "_ZSt19__throw_range_errorPKc"
		size = 364
		refs = "0034 _Unwind_SjLj_Register 004c _ZNSsC1EPKcRKSaIcE 0054 __cxa_allocate_exception 0068 _ZNSt11range_errorC1ERKSs 0098 __cxa_throw 00c8 _ZNSs4_Rep10_M_destroyERKSaIcE 00e0 _ZN9__gnu_cxx18__exchange_and_addEPVii 012c _Unwind_SjLj_Resume 0134 __cxa_free_exception 0144 _ZNSsD1Ev 014c _ZSt9terminatev 0150 __gxx_personality_sj0 0154 .gcc_except_table 0158 .text$_ZSt19__throw_range_errorPKc 015c _ZNSs4_Rep20_S_empty_rep_storageE 0160 _ZTISt11range_error 0164 _ZNSt11range_errorD1Ev 0168 _CRT_MT"
	strings:
		$1 = { 48 31 9F E5 04 B0 4D E2 4C D0 4D E2 24 30 0B E5 3C 31 9F E5 04 10 8B E2 20 30 0B E5 34 31 9F E5 40 00 0B E5 3C 00 4B E2 18 30 0B E5 1C 10 0B E5 14 D0 0B E5 ?? ?? ?? ?? 04 30 A0 E3 40 10 1B E5 08 00 4B E2 0B 20 A0 E1 38 30 0B E5 ?? ?? ?? ?? 08 00 A0 E3 ?? ?? ?? ?? 03 30 A0 E3 08 10 4B E2 44 00 0B E5 38 30 0B E5 ?? ?? ?? ?? 08 30 1B E5 E4 20 9F E5 0C 10 43 E2 02 00 51 E1 40 10 0B E5 05 00 00 1A 00 30 E0 E3 44 00 1B E5 CC 10 9F E5 CC 20 9F E5 38 30 0B E5 ?? ?? ?? ?? C4 20 9F E5 00 20 92 E5 00 00 52 E3 08 00 00 1A 04 00 13 E5 01 20 40 E2 04 20 03 E5 00 00 50 E3 F0 FF FF CA 40 00 1B E5 04 10 4B E2 ?? ?? ?? ?? EC FF FF EA 01 30 A0 E3 08 00 81 E2 00 10 E0 E3 38 30 0B E5 ?? ?? ?? ?? F3 FF FF EA 04 B0 4B E2 38 20 1B E5 34 30 1B E5 01 00 52 E3 48 30 0B E5 40 20 0B E5 30 30 1B E5 03 00 00 0A 02 00 52 E3 07 00 00 0A 03 00 52 E3 01 00 00 0A 01 00 73 E3 0A 00 00 0A 00 30 E0 E3 48 00 1B E5 38 30 0B E5 ?? ?? ?? ?? 44 00 1B E5 ?? ?? ?? ?? 40 20 1B E5 08 00 4B E2 38 20 0B E5 ?? ?? ?? ?? F4 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_27_3 {
	meta:
		name = "_ZSt20__throw_domain_errorPKc"
		size = 364
		refs = "0034 _Unwind_SjLj_Register 004c _ZNSsC1EPKcRKSaIcE 0054 __cxa_allocate_exception 0068 _ZNSt12domain_errorC1ERKSs 0098 __cxa_throw 00c8 _ZNSs4_Rep10_M_destroyERKSaIcE 00e0 _ZN9__gnu_cxx18__exchange_and_addEPVii 012c _Unwind_SjLj_Resume 0134 __cxa_free_exception 0144 _ZNSsD1Ev 014c _ZSt9terminatev 0150 __gxx_personality_sj0 0154 .gcc_except_table 0158 .text$_ZSt20__throw_domain_errorPKc 015c _ZNSs4_Rep20_S_empty_rep_storageE 0160 _ZTISt12domain_error 0164 _ZNSt12domain_errorD1Ev 0168 _CRT_MT"
	strings:
		$1 = { 48 31 9F E5 04 B0 4D E2 4C D0 4D E2 24 30 0B E5 3C 31 9F E5 04 10 8B E2 20 30 0B E5 34 31 9F E5 40 00 0B E5 3C 00 4B E2 18 30 0B E5 1C 10 0B E5 14 D0 0B E5 ?? ?? ?? ?? 04 30 A0 E3 40 10 1B E5 08 00 4B E2 0B 20 A0 E1 38 30 0B E5 ?? ?? ?? ?? 08 00 A0 E3 ?? ?? ?? ?? 03 30 A0 E3 08 10 4B E2 44 00 0B E5 38 30 0B E5 ?? ?? ?? ?? 08 30 1B E5 E4 20 9F E5 0C 10 43 E2 02 00 51 E1 40 10 0B E5 05 00 00 1A 00 30 E0 E3 44 00 1B E5 CC 10 9F E5 CC 20 9F E5 38 30 0B E5 ?? ?? ?? ?? C4 20 9F E5 00 20 92 E5 00 00 52 E3 08 00 00 1A 04 00 13 E5 01 20 40 E2 04 20 03 E5 00 00 50 E3 F0 FF FF CA 40 00 1B E5 04 10 4B E2 ?? ?? ?? ?? EC FF FF EA 01 30 A0 E3 08 00 81 E2 00 10 E0 E3 38 30 0B E5 ?? ?? ?? ?? F3 FF FF EA 04 B0 4B E2 38 20 1B E5 34 30 1B E5 01 00 52 E3 48 30 0B E5 40 20 0B E5 30 30 1B E5 03 00 00 0A 02 00 52 E3 07 00 00 0A 03 00 52 E3 01 00 00 0A 01 00 73 E3 0A 00 00 0A 00 30 E0 E3 48 00 1B E5 38 30 0B E5 ?? ?? ?? ?? 44 00 1B E5 ?? ?? ?? ?? 40 20 1B E5 08 00 4B E2 38 20 0B E5 ?? ?? ?? ?? F4 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_25_3 {
	meta:
		name = "_ZSt20__throw_length_errorPKc"
		size = 364
		refs = "0034 _Unwind_SjLj_Register 004c _ZNSsC1EPKcRKSaIcE 0054 __cxa_allocate_exception 0068 _ZNSt12length_errorC1ERKSs 0098 __cxa_throw 00c8 _ZNSs4_Rep10_M_destroyERKSaIcE 00e0 _ZN9__gnu_cxx18__exchange_and_addEPVii 012c _Unwind_SjLj_Resume 0134 __cxa_free_exception 0144 _ZNSsD1Ev 014c _ZSt9terminatev 0150 __gxx_personality_sj0 0154 .gcc_except_table 0158 .text$_ZSt20__throw_length_errorPKc 015c _ZNSs4_Rep20_S_empty_rep_storageE 0160 _ZTISt12length_error 0164 _ZNSt12length_errorD1Ev 0168 _CRT_MT"
	strings:
		$1 = { 48 31 9F E5 04 B0 4D E2 4C D0 4D E2 24 30 0B E5 3C 31 9F E5 04 10 8B E2 20 30 0B E5 34 31 9F E5 40 00 0B E5 3C 00 4B E2 18 30 0B E5 1C 10 0B E5 14 D0 0B E5 ?? ?? ?? ?? 04 30 A0 E3 40 10 1B E5 08 00 4B E2 0B 20 A0 E1 38 30 0B E5 ?? ?? ?? ?? 08 00 A0 E3 ?? ?? ?? ?? 03 30 A0 E3 08 10 4B E2 44 00 0B E5 38 30 0B E5 ?? ?? ?? ?? 08 30 1B E5 E4 20 9F E5 0C 10 43 E2 02 00 51 E1 40 10 0B E5 05 00 00 1A 00 30 E0 E3 44 00 1B E5 CC 10 9F E5 CC 20 9F E5 38 30 0B E5 ?? ?? ?? ?? C4 20 9F E5 00 20 92 E5 00 00 52 E3 08 00 00 1A 04 00 13 E5 01 20 40 E2 04 20 03 E5 00 00 50 E3 F0 FF FF CA 40 00 1B E5 04 10 4B E2 ?? ?? ?? ?? EC FF FF EA 01 30 A0 E3 08 00 81 E2 00 10 E0 E3 38 30 0B E5 ?? ?? ?? ?? F3 FF FF EA 04 B0 4B E2 38 20 1B E5 34 30 1B E5 01 00 52 E3 48 30 0B E5 40 20 0B E5 30 30 1B E5 03 00 00 0A 02 00 52 E3 07 00 00 0A 03 00 52 E3 01 00 00 0A 01 00 73 E3 0A 00 00 0A 00 30 E0 E3 48 00 1B E5 38 30 0B E5 ?? ?? ?? ?? 44 00 1B E5 ?? ?? ?? ?? 40 20 1B E5 08 00 4B E2 38 20 0B E5 ?? ?? ?? ?? F4 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_24_3 {
	meta:
		name = "_ZSt20__throw_out_of_rangePKc"
		size = 364
		refs = "0034 _Unwind_SjLj_Register 004c _ZNSsC1EPKcRKSaIcE 0054 __cxa_allocate_exception 0068 _ZNSt12out_of_rangeC1ERKSs 0098 __cxa_throw 00c8 _ZNSs4_Rep10_M_destroyERKSaIcE 00e0 _ZN9__gnu_cxx18__exchange_and_addEPVii 012c _Unwind_SjLj_Resume 0134 __cxa_free_exception 0144 _ZNSsD1Ev 014c _ZSt9terminatev 0150 __gxx_personality_sj0 0154 .gcc_except_table 0158 .text$_ZSt20__throw_out_of_rangePKc 015c _ZNSs4_Rep20_S_empty_rep_storageE 0160 _ZTISt12out_of_range 0164 _ZNSt12out_of_rangeD1Ev 0168 _CRT_MT"
	strings:
		$1 = { 48 31 9F E5 04 B0 4D E2 4C D0 4D E2 24 30 0B E5 3C 31 9F E5 04 10 8B E2 20 30 0B E5 34 31 9F E5 40 00 0B E5 3C 00 4B E2 18 30 0B E5 1C 10 0B E5 14 D0 0B E5 ?? ?? ?? ?? 04 30 A0 E3 40 10 1B E5 08 00 4B E2 0B 20 A0 E1 38 30 0B E5 ?? ?? ?? ?? 08 00 A0 E3 ?? ?? ?? ?? 03 30 A0 E3 08 10 4B E2 44 00 0B E5 38 30 0B E5 ?? ?? ?? ?? 08 30 1B E5 E4 20 9F E5 0C 10 43 E2 02 00 51 E1 40 10 0B E5 05 00 00 1A 00 30 E0 E3 44 00 1B E5 CC 10 9F E5 CC 20 9F E5 38 30 0B E5 ?? ?? ?? ?? C4 20 9F E5 00 20 92 E5 00 00 52 E3 08 00 00 1A 04 00 13 E5 01 20 40 E2 04 20 03 E5 00 00 50 E3 F0 FF FF CA 40 00 1B E5 04 10 4B E2 ?? ?? ?? ?? EC FF FF EA 01 30 A0 E3 08 00 81 E2 00 10 E0 E3 38 30 0B E5 ?? ?? ?? ?? F3 FF FF EA 04 B0 4B E2 38 20 1B E5 34 30 1B E5 01 00 52 E3 48 30 0B E5 40 20 0B E5 30 30 1B E5 03 00 00 0A 02 00 52 E3 07 00 00 0A 03 00 52 E3 01 00 00 0A 01 00 73 E3 0A 00 00 0A 00 30 E0 E3 48 00 1B E5 38 30 0B E5 ?? ?? ?? ?? 44 00 1B E5 ?? ?? ?? ?? 40 20 1B E5 08 00 4B E2 38 20 0B E5 ?? ?? ?? ?? F4 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_23_3 {
	meta:
		name = "_ZSt21__throw_runtime_errorPKc"
		size = 364
		refs = "0034 _Unwind_SjLj_Register 004c _ZNSsC1EPKcRKSaIcE 0054 __cxa_allocate_exception 0068 _ZNSt13runtime_errorC1ERKSs 0098 __cxa_throw 00c8 _ZNSs4_Rep10_M_destroyERKSaIcE 00e0 _ZN9__gnu_cxx18__exchange_and_addEPVii 012c _Unwind_SjLj_Resume 0134 __cxa_free_exception 0144 _ZNSsD1Ev 014c _ZSt9terminatev 0150 __gxx_personality_sj0 0154 .gcc_except_table 0158 .text$_ZSt21__throw_runtime_errorPKc 015c _ZNSs4_Rep20_S_empty_rep_storageE 0160 _ZTISt13runtime_error 0164 _ZNSt13runtime_errorD1Ev 0168 _CRT_MT"
	strings:
		$1 = { 48 31 9F E5 04 B0 4D E2 4C D0 4D E2 24 30 0B E5 3C 31 9F E5 04 10 8B E2 20 30 0B E5 34 31 9F E5 40 00 0B E5 3C 00 4B E2 18 30 0B E5 1C 10 0B E5 14 D0 0B E5 ?? ?? ?? ?? 04 30 A0 E3 40 10 1B E5 08 00 4B E2 0B 20 A0 E1 38 30 0B E5 ?? ?? ?? ?? 08 00 A0 E3 ?? ?? ?? ?? 03 30 A0 E3 08 10 4B E2 44 00 0B E5 38 30 0B E5 ?? ?? ?? ?? 08 30 1B E5 E4 20 9F E5 0C 10 43 E2 02 00 51 E1 40 10 0B E5 05 00 00 1A 00 30 E0 E3 44 00 1B E5 CC 10 9F E5 CC 20 9F E5 38 30 0B E5 ?? ?? ?? ?? C4 20 9F E5 00 20 92 E5 00 00 52 E3 08 00 00 1A 04 00 13 E5 01 20 40 E2 04 20 03 E5 00 00 50 E3 F0 FF FF CA 40 00 1B E5 04 10 4B E2 ?? ?? ?? ?? EC FF FF EA 01 30 A0 E3 08 00 81 E2 00 10 E0 E3 38 30 0B E5 ?? ?? ?? ?? F3 FF FF EA 04 B0 4B E2 38 20 1B E5 34 30 1B E5 01 00 52 E3 48 30 0B E5 40 20 0B E5 30 30 1B E5 03 00 00 0A 02 00 52 E3 07 00 00 0A 03 00 52 E3 01 00 00 0A 01 00 73 E3 0A 00 00 0A 00 30 E0 E3 48 00 1B E5 38 30 0B E5 ?? ?? ?? ?? 44 00 1B E5 ?? ?? ?? ?? 40 20 1B E5 08 00 4B E2 38 20 0B E5 ?? ?? ?? ?? F4 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_21_3 {
	meta:
		name = "_ZSt22__throw_overflow_errorPKc"
		size = 364
		refs = "0034 _Unwind_SjLj_Register 004c _ZNSsC1EPKcRKSaIcE 0054 __cxa_allocate_exception 0068 _ZNSt14overflow_errorC1ERKSs 0098 __cxa_throw 00c8 _ZNSs4_Rep10_M_destroyERKSaIcE 00e0 _ZN9__gnu_cxx18__exchange_and_addEPVii 012c _Unwind_SjLj_Resume 0134 __cxa_free_exception 0144 _ZNSsD1Ev 014c _ZSt9terminatev 0150 __gxx_personality_sj0 0154 .gcc_except_table 0158 .text$_ZSt22__throw_overflow_errorPKc 015c _ZNSs4_Rep20_S_empty_rep_storageE 0160 _ZTISt14overflow_error 0164 _ZNSt14overflow_errorD1Ev 0168 _CRT_MT"
	strings:
		$1 = { 48 31 9F E5 04 B0 4D E2 4C D0 4D E2 24 30 0B E5 3C 31 9F E5 04 10 8B E2 20 30 0B E5 34 31 9F E5 40 00 0B E5 3C 00 4B E2 18 30 0B E5 1C 10 0B E5 14 D0 0B E5 ?? ?? ?? ?? 04 30 A0 E3 40 10 1B E5 08 00 4B E2 0B 20 A0 E1 38 30 0B E5 ?? ?? ?? ?? 08 00 A0 E3 ?? ?? ?? ?? 03 30 A0 E3 08 10 4B E2 44 00 0B E5 38 30 0B E5 ?? ?? ?? ?? 08 30 1B E5 E4 20 9F E5 0C 10 43 E2 02 00 51 E1 40 10 0B E5 05 00 00 1A 00 30 E0 E3 44 00 1B E5 CC 10 9F E5 CC 20 9F E5 38 30 0B E5 ?? ?? ?? ?? C4 20 9F E5 00 20 92 E5 00 00 52 E3 08 00 00 1A 04 00 13 E5 01 20 40 E2 04 20 03 E5 00 00 50 E3 F0 FF FF CA 40 00 1B E5 04 10 4B E2 ?? ?? ?? ?? EC FF FF EA 01 30 A0 E3 08 00 81 E2 00 10 E0 E3 38 30 0B E5 ?? ?? ?? ?? F3 FF FF EA 04 B0 4B E2 38 20 1B E5 34 30 1B E5 01 00 52 E3 48 30 0B E5 40 20 0B E5 30 30 1B E5 03 00 00 0A 02 00 52 E3 07 00 00 0A 03 00 52 E3 01 00 00 0A 01 00 73 E3 0A 00 00 0A 00 30 E0 E3 48 00 1B E5 38 30 0B E5 ?? ?? ?? ?? 44 00 1B E5 ?? ?? ?? ?? 40 20 1B E5 08 00 4B E2 38 20 0B E5 ?? ?? ?? ?? F4 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_26_3 {
	meta:
		name = "_ZSt24__throw_invalid_argumentPKc"
		size = 364
		refs = "0034 _Unwind_SjLj_Register 004c _ZNSsC1EPKcRKSaIcE 0054 __cxa_allocate_exception 0068 _ZNSt16invalid_argumentC1ERKSs 0098 __cxa_throw 00c8 _ZNSs4_Rep10_M_destroyERKSaIcE 00e0 _ZN9__gnu_cxx18__exchange_and_addEPVii 012c _Unwind_SjLj_Resume 0134 __cxa_free_exception 0144 _ZNSsD1Ev 014c _ZSt9terminatev 0150 __gxx_personality_sj0 0154 .gcc_except_table 0158 .text$_ZSt24__throw_invalid_argumentPKc 015c _ZNSs4_Rep20_S_empty_rep_storageE 0160 _ZTISt16invalid_argument 0164 _ZNSt16invalid_argumentD1Ev 0168 _CRT_MT"
	strings:
		$1 = { 48 31 9F E5 04 B0 4D E2 4C D0 4D E2 24 30 0B E5 3C 31 9F E5 04 10 8B E2 20 30 0B E5 34 31 9F E5 40 00 0B E5 3C 00 4B E2 18 30 0B E5 1C 10 0B E5 14 D0 0B E5 ?? ?? ?? ?? 04 30 A0 E3 40 10 1B E5 08 00 4B E2 0B 20 A0 E1 38 30 0B E5 ?? ?? ?? ?? 08 00 A0 E3 ?? ?? ?? ?? 03 30 A0 E3 08 10 4B E2 44 00 0B E5 38 30 0B E5 ?? ?? ?? ?? 08 30 1B E5 E4 20 9F E5 0C 10 43 E2 02 00 51 E1 40 10 0B E5 05 00 00 1A 00 30 E0 E3 44 00 1B E5 CC 10 9F E5 CC 20 9F E5 38 30 0B E5 ?? ?? ?? ?? C4 20 9F E5 00 20 92 E5 00 00 52 E3 08 00 00 1A 04 00 13 E5 01 20 40 E2 04 20 03 E5 00 00 50 E3 F0 FF FF CA 40 00 1B E5 04 10 4B E2 ?? ?? ?? ?? EC FF FF EA 01 30 A0 E3 08 00 81 E2 00 10 E0 E3 38 30 0B E5 ?? ?? ?? ?? F3 FF FF EA 04 B0 4B E2 38 20 1B E5 34 30 1B E5 01 00 52 E3 48 30 0B E5 40 20 0B E5 30 30 1B E5 03 00 00 0A 02 00 52 E3 07 00 00 0A 03 00 52 E3 01 00 00 0A 01 00 73 E3 0A 00 00 0A 00 30 E0 E3 48 00 1B E5 38 30 0B E5 ?? ?? ?? ?? 44 00 1B E5 ?? ?? ?? ?? 40 20 1B E5 08 00 4B E2 38 20 0B E5 ?? ?? ?? ?? F4 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_0_3 {
	meta:
		name = "_ZSt21__copy_streambufs_eofIcSt11char_traitsIcEEiPSt15basic_streambufIT_T0_ES6_Rb"
		size = 376
	strings:
		$1 = { F0 41 2D E9 08 30 90 E5 0C 50 90 E5 02 80 A0 E1 01 20 A0 E3 05 00 53 E1 00 20 C8 E5 00 40 A0 E1 01 60 A0 E1 00 00 D3 35 49 00 00 2A 00 70 A0 E3 13 00 00 EA 03 10 A0 E1 06 00 A0 E1 00 30 96 E5 05 20 A0 E1 0F E0 A0 E1 30 F0 93 E5 08 30 94 E5 00 00 55 E1 00 30 83 E0 08 30 84 E5 00 70 87 E0 28 00 00 CA 00 30 94 E5 04 00 A0 E1 0F E0 A0 E1 24 F0 93 E5 01 00 70 E3 19 00 00 0A 08 30 94 E5 0C 50 94 E5 05 50 63 E0 01 00 55 E3 E8 FF FF CA 14 30 96 E5 18 20 96 E5 FF 00 00 E2 02 00 53 E1 11 00 00 2A 00 00 C3 E5 14 30 96 E5 01 30 83 E2 14 30 86 E5 08 30 94 E5 0C 50 94 E5 05 00 53 E1 01 30 83 32 08 30 84 35 18 00 00 2A 05 00 53 E1 00 00 D3 35 0F 00 00 2A 01 70 87 E2 01 00 70 E3 E5 FF FF 1A 07 00 A0 E1 F0 81 BD E8 00 10 A0 E1 00 30 96 E5 06 00 A0 E1 0F E0 A0 E1 34 F0 93 E5 01 00 70 E3 EA FF FF 1A 00 30 A0 E3 00 30 C8 E5 07 00 A0 E1 F0 81 BD E8 00 30 94 E5 04 00 A0 E1 0F E0 A0 E1 24 F0 93 E5 01 70 87 E2 EA FF FF EA 00 30 94 E5 04 00 A0 E1 0F E0 A0 E1 28 F0 93 E5 01 00 70 E3 E3 FF FF 0A 08 30 94 E5 0C 50 94 E5 DD FF FF EA 00 30 94 E5 0F E0 A0 E1 24 F0 93 E5 01 00 70 E3 08 30 94 15 0C 50 94 15 00 70 A0 03 DB FF FF 0A AC FF FF EA }
	condition:
		$1
}

rule file_10_1_3 {
	meta:
		name = "_ZSt21__copy_streambufs_eofIwSt11char_traitsIwEEiPSt15basic_streambufIT_T0_ES6_Rb"
		size = 372
	strings:
		$1 = { 08 30 90 E5 0C C0 90 E5 F0 45 2D E9 0C 00 53 E1 02 A0 A0 E1 01 20 A0 E3 00 40 A0 E1 00 20 CA E5 01 60 A0 E1 B0 00 D3 31 4C 00 00 2A 3C 81 9F E5 08 00 50 E1 00 70 A0 03 2D 00 00 0A 00 70 A0 E3 10 00 00 EA 00 30 96 E5 06 00 A0 E1 05 20 A0 E1 0F E0 A0 E1 30 F0 93 E5 08 30 94 E5 00 00 55 E1 80 30 83 E0 08 30 84 E5 00 70 87 E0 22 00 00 CA 00 30 94 E5 04 00 A0 E1 0F E0 A0 E1 24 F0 93 E5 08 00 50 E1 1A 00 00 0A 08 10 94 E5 0C 30 94 E5 03 50 61 E0 C5 50 A0 E1 01 00 55 E3 E8 FF FF CA 14 20 96 E5 18 C0 96 E5 0C 00 52 E1 B2 00 C2 30 14 20 86 35 1F 00 00 2A 03 00 51 E1 18 00 00 2A B2 00 D1 E0 08 10 84 E5 08 00 50 E1 08 00 A0 01 04 00 00 0A 08 30 94 E5 0C 20 94 E5 02 00 53 E1 B0 00 D3 31 08 00 00 2A 01 70 87 E2 08 00 50 E1 E4 FF FF 1A 07 00 A0 E1 F0 85 BD E8 00 30 A0 E3 00 30 CA E5 07 00 A0 E1 F0 85 BD E8 00 30 94 E5 04 00 A0 E1 0F E0 A0 E1 24 F0 93 E5 01 70 87 E2 F1 FF FF EA 00 30 94 E5 04 00 A0 E1 0F E0 A0 E1 28 F0 93 E5 E3 FF FF EA 00 10 A0 E1 00 30 96 E5 06 00 A0 E1 0F E0 A0 E1 34 F0 93 E5 08 00 50 E1 E9 FF FF 0A 08 10 94 E5 0C 30 94 E5 D5 FF FF EA 00 30 94 E5 0F E0 A0 E1 24 F0 93 E5 AE FF FF EA FF FF 00 00 }
	condition:
		$1
}

rule file_11_0_3 {
	meta:
		name = "_ZNSt10__num_base15_S_format_floatERKSt8ios_basePcc"
		size = 184
	strings:
		$1 = { 0C 30 90 E5 25 C0 A0 E3 01 00 A0 E1 02 0B 13 E3 01 C0 C0 E4 2B C0 A0 13 01 C0 C1 15 01 00 80 12 01 0B 13 E3 23 10 A0 13 01 10 C0 14 02 2C A0 E1 42 2C A0 E1 00 10 A0 E1 2E C0 A0 E3 01 C0 C1 E4 00 00 52 E3 2A C0 A0 E3 01 C0 C0 E5 01 20 C1 15 01 00 81 E2 41 2F 03 E2 01 00 80 12 04 00 52 E3 00 30 A0 01 66 20 A0 03 01 20 C3 04 06 00 00 0A 01 0C 52 E3 07 00 00 0A 01 09 13 E3 47 20 A0 13 67 20 A0 03 00 30 A0 E1 01 20 C3 E4 00 20 A0 E3 00 20 C3 E5 0E F0 A0 E1 01 09 13 E3 45 20 A0 13 65 20 A0 03 00 30 A0 E1 01 20 C3 E4 00 20 A0 E3 00 20 C3 E5 0E F0 A0 E1 }
	condition:
		$1
}

rule file_11_1_3 {
	meta:
		name = "_ZSt17__verify_groupingPKcjRKSs"
		size = 204
	strings:
		$1 = { 00 30 92 E5 01 10 41 E2 0C 20 13 E5 70 00 2D E9 01 20 42 E2 02 00 51 E1 02 10 A0 21 00 00 51 E3 00 60 A0 E1 00 C0 A0 13 01 00 A0 03 0E 00 00 1A 00 00 52 E3 01 00 00 0A 00 00 50 E3 16 00 00 1A 01 C0 D6 E7 01 20 4C E2 7D 00 52 E3 04 00 00 8A D0 30 D3 E1 0C CC A0 E1 4C 0C 53 E1 00 00 A0 C3 01 00 00 D2 70 00 BD E8 0E F0 A0 E1 D2 50 93 E1 DC 40 96 E1 01 C0 8C E2 04 00 55 E1 00 00 A0 13 01 00 A0 03 01 00 5C E1 01 20 42 E2 E7 FF FF 2A 00 00 50 E3 E5 FF FF 0A F3 FF FF EA 01 C0 D6 E7 0C 1C A0 E1 41 1C A0 E1 D2 00 93 E1 01 00 50 E1 00 00 A0 13 01 00 A0 03 01 20 52 E2 E0 FF FF 0A 00 00 50 E3 DE FF FF 0A F6 FF FF EA }
	condition:
		$1
}

rule file_12_0_3 {
	meta:
		name = "_Znwj"
		size = 248
		refs = "0044 _Unwind_SjLj_Register 0070 malloc 0084 _Unwind_SjLj_Unregister 0098 __cxa_allocate_exception 00b4 __cxa_throw 00d0 _Unwind_SjLj_Resume 00d8 __cxa_call_unexpected 00dc __gxx_personality_sj0 00e0 .gcc_except_table 00e4 .text$_Znwj 00e8 __new_handler 00ec _ZTVSt9bad_alloc 00f0 _ZTISt9bad_alloc 00f4 _ZNSt9bad_allocD1Ev"
	strings:
		$1 = { 00 48 2D E9 D0 30 9F E5 04 B0 8D E2 3C D0 4D E2 20 30 0B E5 C4 30 9F E5 00 00 50 E3 1C 30 0B E5 BC 30 9F E5 00 20 A0 E1 14 30 0B E5 01 20 A0 03 04 30 4B E2 38 00 4B E2 3C 20 0B E5 18 30 0B E5 10 D0 0B E5 ?? ?? ?? ?? 07 00 00 EA 94 20 9F E5 00 30 92 E5 00 00 53 E3 0D 00 00 0A 01 20 A0 E3 34 20 0B E5 0F E0 A0 E1 03 F0 A0 E1 3C 00 1B E5 ?? ?? ?? ?? 00 00 50 E3 40 00 0B E5 F2 FF FF 0A 38 00 4B E2 ?? ?? ?? ?? 40 00 1B E5 04 D0 4B E2 00 88 BD E8 04 00 A0 E3 ?? ?? ?? ?? 48 30 9F E5 48 10 9F E5 00 30 80 E5 44 20 9F E5 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 04 B0 8B E2 2C 30 1B E5 30 00 1B E5 01 00 73 E3 00 30 E0 13 34 30 0B 15 ?? ?? ?? ?? 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_14_0_3 {
	meta:
		name = "__cxa_bad_typeid"
		size = 44
		refs = "0008 __cxa_allocate_exception 001c __cxa_throw 0020 _ZTVSt10bad_typeid 0024 _ZTISt10bad_typeid 0028 _ZNSt10bad_typeidD1Ev"
	strings:
		$1 = { 04 E0 2D E5 04 00 A0 E3 ?? ?? ?? ?? 0C 30 9F E5 0C 10 9F E5 00 30 80 E5 08 20 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_14_1_3 {
	meta:
		name = "__cxa_bad_cast"
		size = 44
		refs = "0008 __cxa_allocate_exception 001c __cxa_throw 0020 _ZTVSt8bad_cast 0024 _ZTISt8bad_cast 0028 _ZNSt8bad_castD1Ev"
	strings:
		$1 = { 04 E0 2D E5 04 00 A0 E3 ?? ?? ?? ?? 0C 30 9F E5 0C 10 9F E5 00 30 80 E5 08 20 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_15_0_3 {
	meta:
		name = "_ZNKSt7codecvtIwciE9do_lengthERiPKcS3_j"
		size = 168
		refs = "0090 mbrtowc"
	strings:
		$1 = { F0 45 2D E9 04 D0 4D E2 20 50 9D E5 03 60 A0 E1 00 00 55 E3 03 00 52 11 02 40 A0 E1 01 A0 A0 E1 00 70 A0 23 01 70 A0 33 00 30 91 E5 1A 00 00 2A 04 80 8D E2 04 30 28 E5 00 70 A0 E3 0F 00 00 EA 02 00 70 E3 14 00 00 0A 00 00 50 E3 01 00 A0 03 01 50 55 E2 00 30 A0 03 01 30 A0 13 00 40 84 E0 04 00 56 E1 00 30 A0 93 01 30 03 82 00 00 53 E3 00 30 9D E5 07 70 80 E0 00 30 8A E5 06 00 00 0A 04 10 A0 E1 06 20 64 E0 00 00 A0 E3 0D 30 A0 E1 ?? ?? ?? ?? 01 00 70 E3 E8 FF FF 1A 07 00 A0 E1 04 D0 8D E2 F0 85 BD E8 }
	condition:
		$1
}

rule file_15_1_3 {
	meta:
		name = "_ZNKSt7codecvtIwciE5do_inERiPKcS3_RS3_PwS5_RS5_"
		size = 192
		refs = "0090 mbrtowc"
	strings:
		$1 = { F0 45 2D E9 04 D0 4D E2 24 50 9D E5 28 A0 9D E5 03 00 52 E1 00 00 A0 23 01 00 A0 33 0A 00 55 E1 03 00 52 31 03 60 A0 E1 02 40 A0 E1 01 80 A0 E1 00 30 91 E5 19 00 00 2A 04 70 8D E2 04 30 27 E5 0E 00 00 EA 02 00 70 E3 1A 00 00 0A 00 00 50 E3 B0 00 C5 01 01 00 A0 03 00 40 84 E0 00 30 9D E5 02 50 85 E2 04 00 56 E1 00 00 A0 93 01 00 A0 83 05 00 5A E1 04 00 56 81 00 30 88 E5 07 00 00 9A 05 00 A0 E1 04 10 A0 E1 06 20 64 E0 0D 30 A0 E1 ?? ?? ?? ?? 01 00 70 E3 E9 FF FF 1A 02 00 A0 E3 20 30 9D E5 00 40 83 E5 2C 30 9D E5 00 50 83 E5 04 D0 8D E2 F0 85 BD E8 01 00 A0 E3 F7 FF FF EA }
	condition:
		$1
}

rule file_15_2_3 {
	meta:
		name = "_ZNKSt7codecvtIwciE13do_max_lengthEv"
		size = 140
		refs = "0034 _Unwind_SjLj_Register 0040 __mb_cur_max 004c _Unwind_SjLj_Unregister 0074 _Unwind_SjLj_Resume 007c __cxa_call_unexpected 0080 __gxx_personality_sj0 0084 .gcc_except_table 0088 .text$_ZNKSt7codecvtIwciE13do_max_lengthEv"
	strings:
		$1 = { 00 48 2D E9 74 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 68 30 9F E5 38 00 4B E2 1C 30 0B E5 60 30 9F E5 10 D0 0B E5 14 30 0B E5 04 30 4B E2 18 30 0B E5 ?? ?? ?? ?? 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 3C 00 0B E5 38 00 4B E2 ?? ?? ?? ?? 3C 00 1B E5 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 2C 30 1B E5 30 00 1B E5 01 00 73 E3 00 30 E0 13 34 30 0B 15 ?? ?? ?? ?? 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_15_3_3 {
	meta:
		name = "_ZNKSt7codecvtIwciE11do_encodingEv"
		size = 152
		refs = "0034 _Unwind_SjLj_Register 0040 __mb_cur_max 0058 _Unwind_SjLj_Unregister 0080 _Unwind_SjLj_Resume 0088 __cxa_call_unexpected 008c __gxx_personality_sj0 0090 .gcc_except_table 0094 .text$_ZNKSt7codecvtIwciE11do_encodingEv"
	strings:
		$1 = { 00 48 2D E9 80 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 74 30 9F E5 38 00 4B E2 1C 30 0B E5 6C 30 9F E5 10 D0 0B E5 14 30 0B E5 04 30 4B E2 18 30 0B E5 ?? ?? ?? ?? 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 01 00 50 E3 00 00 A0 13 01 00 A0 03 3C 00 0B E5 38 00 4B E2 ?? ?? ?? ?? 3C 00 1B E5 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 2C 30 1B E5 30 00 1B E5 01 00 73 E3 00 30 E0 13 34 30 0B 15 ?? ?? ?? ?? 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_15_4_3 {
	meta:
		name = "_ZNKSt7codecvtIwciE6do_outERiPKwS3_RS3_PcS5_RS5_"
		size = 308
		refs = "0024 __mb_cur_max 0070 memcpy 009c wcrtomb"
	strings:
		$1 = { F0 4F 2D E9 01 90 A0 E1 00 10 91 E5 08 D0 4D E2 03 A0 A0 E1 02 40 A0 E1 30 50 9D E5 34 70 9D E5 00 10 8D E5 ?? ?? ?? ?? 0A 20 64 E0 C2 20 A0 E1 05 30 67 E0 92 30 23 E0 00 00 53 E3 29 00 00 DA 07 00 55 E1 00 30 A0 23 01 30 A0 33 04 00 5A E1 00 30 A0 93 00 00 53 E3 0D B0 A0 11 04 80 8D 12 0A 00 00 1A 1B 00 00 EA 03 00 56 E1 2E 00 00 8A ?? ?? ?? ?? 06 50 85 E0 02 40 84 E2 00 30 9D E5 05 00 57 E1 04 00 5A 81 00 30 89 E5 11 00 00 9A B0 10 D4 E1 0D 20 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 00 60 A0 E1 01 00 76 E3 08 10 A0 E1 05 00 A0 E1 06 20 A0 E1 07 30 65 E0 EA FF FF 1A 02 00 A0 E3 2C 30 9D E5 00 40 83 E5 38 30 9D E5 00 50 83 E5 08 D0 8D E2 F0 8F BD E8 0A 00 54 E1 00 00 A0 23 01 00 A0 33 F5 FF FF EA 04 00 5A E1 F9 FF FF 9A 0D B0 A0 E1 05 00 00 EA 02 40 84 E2 00 30 9D E5 04 00 5A E1 00 30 89 E5 00 50 85 E0 F1 FF FF 9A 05 00 A0 E1 B0 10 D4 E1 0D 20 A0 E1 ?? ?? ?? ?? 01 00 70 E3 F3 FF FF 1A E3 FF FF EA 01 00 A0 E3 E2 FF FF EA }
	condition:
		$1
}

rule file_16_1_3 {
	meta:
		name = "_ZSt18uncaught_exceptionv"
		size = 24
		refs = "0004 __cxa_get_globals"
	strings:
		$1 = { 04 E0 2D E5 ?? ?? ?? ?? 04 00 90 E5 00 00 50 E2 01 00 A0 13 04 F0 9D E4 }
	condition:
		$1
}

rule file_16_2_3 {
	meta:
		name = "__cxa_end_catch"
		size = 168
		refs = "0004 __cxa_get_globals_fast 0048 _Unwind_DeleteException 009c _ZSt9terminatev"
	strings:
		$1 = { 00 48 2D E9 ?? ?? ?? ?? 00 30 A0 E1 00 00 90 E5 00 00 50 E3 00 88 BD 08 80 10 9F E5 80 20 9F E5 30 C0 80 E2 00 18 9C E8 0B 10 91 E0 0C 20 A2 E0 00 00 52 E3 04 00 00 0A 00 20 A0 E3 30 00 80 E2 00 20 83 E5 00 48 BD E8 ?? ?? ?? ?? 01 00 51 E3 F8 FF FF 8A 14 20 90 E5 00 00 52 E3 05 00 00 BA 01 20 52 E2 07 00 00 0A 01 00 72 E3 0A 00 00 0A 14 20 80 E5 00 88 BD E8 01 20 92 E2 10 10 90 05 00 10 83 05 F9 FF FF EA 10 20 90 E5 30 00 80 E2 00 20 83 E5 00 48 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? 00 D5 D4 BC BC AA B1 B8 }
	condition:
		$1
}

rule file_16_3_3 {
	meta:
		name = "__cxa_begin_catch"
		size = 276
		refs = "0038 _Unwind_SjLj_Register 003c __cxa_get_globals 00c0 _Unwind_SjLj_Unregister 00d8 _ZSt9terminatev 00f4 _Unwind_SjLj_Resume 00fc __cxa_call_unexpected 0100 __gxx_personality_sj0 0104 .gcc_except_table 0108 .text$__cxa_begin_catch"
	strings:
		$1 = { 70 48 2D E9 F4 30 9F E5 10 B0 8D E2 38 D0 4D E2 2C 30 0B E5 E8 30 9F E5 48 00 0B E5 28 30 0B E5 E0 30 9F E5 44 00 4B E2 20 30 0B E5 10 30 4B E2 24 30 0B E5 1C D0 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? 48 30 1B E5 C0 40 9F E5 30 20 43 E2 BC 30 9F E5 30 60 82 E2 60 00 96 E8 05 30 93 E0 06 40 A4 E0 00 00 54 E3 00 10 90 E5 0F 00 00 1A 01 00 53 E3 0D 00 00 8A 14 30 92 E5 00 00 53 E3 01 30 83 A2 01 30 63 B2 14 30 82 E5 02 00 51 E1 04 30 90 E5 10 10 82 15 00 20 80 15 28 20 92 E5 01 30 43 E2 04 30 80 E5 48 20 0B E5 03 00 00 EA 00 00 51 E3 00 20 80 05 48 10 0B 05 04 00 00 1A 44 00 4B E2 ?? ?? ?? ?? 48 00 1B E5 10 D0 4B E2 70 88 BD E8 01 30 A0 E3 40 30 0B E5 ?? ?? ?? ?? 10 B0 8B E2 38 30 1B E5 3C 00 1B E5 01 00 73 E3 00 30 E0 13 40 30 0B 15 ?? ?? ?? ?? 40 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? BC AA B1 B8 00 D5 D4 BC }
	condition:
		$1
}

rule file_17_0_3 {
	meta:
		name = "_ZNKSt10moneypunctIwLb0EE13decimal_pointEv"
		size = 20
		altNames = "_ZNKSt10moneypunctIwLb1EE13decimal_pointEv _ZNKSt8messagesIcE4openERKSsRKSt6locale _ZNKSt8messagesIcE4openERKSsRKSt6localePKc _ZNKSt8messagesIwE4openERKSsRKSt6locale _ZNKSt8messagesIwE4openERKSsRKSt6localePKc _ZNKSt8numpunctIwE13decimal_pointEv _ZNKSt8time_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE10date_orderEv _ZNKSt8time_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE10date_orderEv"
	strings:
		$1 = { 04 E0 2D E5 00 30 90 E5 0F E0 A0 E1 08 F0 93 E5 04 F0 9D E4 }
	condition:
		$1
}

rule file_17_1_3 {
	meta:
		name = "_ZNKSt10moneypunctIwLb0EE13thousands_sepEv"
		size = 20
		altNames = "_ZNKSt10moneypunctIwLb1EE13thousands_sepEv _ZNKSt8numpunctIwE13thousands_sepEv _ZNSt15basic_streambufIcSt11char_traitsIcEE9pubsetbufEPci _ZNSt15basic_streambufIwSt11char_traitsIwEE9pubsetbufEPwi"
	strings:
		$1 = { 04 E0 2D E5 00 30 90 E5 0F E0 A0 E1 0C F0 93 E5 04 F0 9D E4 }
	condition:
		$1
}

rule file_17_2_3 {
	meta:
		name = "_ZNKSt10moneypunctIwLb0EE8groupingEv"
		size = 28
		altNames = "_ZNKSt10moneypunctIcLb0EE8groupingEv _ZNKSt10moneypunctIcLb1EE8groupingEv _ZNKSt10moneypunctIwLb1EE8groupingEv _ZNKSt8numpunctIcE8groupingEv _ZNKSt8numpunctIwE8groupingEv"
	strings:
		$1 = { 10 40 2D E9 00 30 91 E5 00 40 A0 E1 0F E0 A0 E1 10 F0 93 E5 04 00 A0 E1 10 80 BD E8 }
	condition:
		$1
}

rule file_17_3_3 {
	meta:
		name = "_ZNKSt10moneypunctIwLb0EE11curr_symbolEv"
		size = 28
		altNames = "_ZNKSt10moneypunctIcLb0EE11curr_symbolEv _ZNKSt10moneypunctIcLb1EE11curr_symbolEv _ZNKSt10moneypunctIwLb1EE11curr_symbolEv _ZNKSt8numpunctIcE8truenameEv _ZNKSt8numpunctIwE8truenameEv"
	strings:
		$1 = { 10 40 2D E9 00 30 91 E5 00 40 A0 E1 0F E0 A0 E1 14 F0 93 E5 04 00 A0 E1 10 80 BD E8 }
	condition:
		$1
}

rule file_17_4_3 {
	meta:
		name = "_ZNKSt10moneypunctIwLb0EE13positive_signEv"
		size = 28
		altNames = "_ZNKSt10moneypunctIcLb0EE13positive_signEv _ZNKSt10moneypunctIcLb1EE13positive_signEv _ZNKSt10moneypunctIwLb1EE13positive_signEv _ZNKSt8numpunctIcE9falsenameEv _ZNKSt8numpunctIwE9falsenameEv"
	strings:
		$1 = { 10 40 2D E9 00 30 91 E5 00 40 A0 E1 0F E0 A0 E1 18 F0 93 E5 04 00 A0 E1 10 80 BD E8 }
	condition:
		$1
}

rule file_17_5_3 {
	meta:
		name = "_ZNKSt10moneypunctIwLb0EE13negative_signEv"
		size = 28
		altNames = "_ZNKSt10moneypunctIcLb0EE13negative_signEv _ZNKSt10moneypunctIcLb1EE13negative_signEv _ZNKSt10moneypunctIwLb1EE13negative_signEv"
	strings:
		$1 = { 10 40 2D E9 00 30 91 E5 00 40 A0 E1 0F E0 A0 E1 1C F0 93 E5 04 00 A0 E1 10 80 BD E8 }
	condition:
		$1
}

rule file_17_6_3 {
	meta:
		name = "_ZNKSt10moneypunctIwLb0EE11frac_digitsEv"
		size = 20
		altNames = "_ZNKSt10moneypunctIcLb0EE11frac_digitsEv _ZNKSt10moneypunctIcLb1EE11frac_digitsEv _ZNKSt10moneypunctIwLb1EE11frac_digitsEv _ZNSt15basic_streambufIcSt11char_traitsIcEE5sgetnEPci _ZNSt15basic_streambufIwSt11char_traitsIwEE5sgetnEPwi"
	strings:
		$1 = { 04 E0 2D E5 00 30 90 E5 0F E0 A0 E1 20 F0 93 E5 04 F0 9D E4 }
	condition:
		$1
}

rule file_17_7_3 {
	meta:
		name = "_ZNKSt10moneypunctIwLb0EE10pos_formatEv"
		size = 28
		altNames = "_ZNKSt10moneypunctIcLb0EE10pos_formatEv _ZNKSt10moneypunctIcLb1EE10pos_formatEv _ZNKSt10moneypunctIwLb1EE10pos_formatEv"
	strings:
		$1 = { 10 40 2D E9 00 30 91 E5 00 40 A0 E1 0F E0 A0 E1 24 F0 93 E5 04 00 A0 E1 10 80 BD E8 }
	condition:
		$1
}

rule file_17_8_3 {
	meta:
		name = "_ZNKSt10moneypunctIwLb0EE10neg_formatEv"
		size = 28
		altNames = "_ZNKSt10moneypunctIcLb0EE10neg_formatEv _ZNKSt10moneypunctIcLb1EE10neg_formatEv _ZNKSt10moneypunctIwLb1EE10neg_formatEv"
	strings:
		$1 = { 10 40 2D E9 00 30 91 E5 00 40 A0 E1 0F E0 A0 E1 28 F0 93 E5 04 00 A0 E1 10 80 BD E8 }
	condition:
		$1
}

rule file_17_12_3 {
	meta:
		name = "_ZNKSt10moneypunctIwLb0EE13do_pos_formatEv"
		size = 32
		refs = "0014 memcpy"
		altNames = "_ZNKSt10moneypunctIcLb0EE13do_neg_formatEv _ZNKSt10moneypunctIcLb1EE13do_neg_formatEv _ZNKSt10moneypunctIwLb1EE13do_pos_formatEv"
	strings:
		$1 = { 08 10 91 E5 10 40 2D E9 34 10 81 E2 00 40 A0 E1 04 20 A0 E3 ?? ?? ?? ?? 04 00 A0 E1 10 80 BD E8 }
	condition:
		$1
}

rule file_17_13_3 {
	meta:
		name = "_ZNKSt10moneypunctIwLb0EE13do_neg_formatEv"
		size = 32
		refs = "0014 memcpy"
		altNames = "_ZNKSt10moneypunctIwLb1EE13do_neg_formatEv"
	strings:
		$1 = { 08 10 91 E5 10 40 2D E9 38 10 81 E2 00 40 A0 E1 04 20 A0 E3 ?? ?? ?? ?? 04 00 A0 E1 10 80 BD E8 }
	condition:
		$1
}

rule file_17_28_3 {
	meta:
		name = "_ZNSt18__moneypunct_cacheIwLb0EEC2Ej"
		size = 116
		refs = "0070 _ZTVSt18__moneypunct_cacheIwLb0EE"
		altNames = "_ZNSt18__moneypunct_cacheIwLb0EEC1Ej"
	strings:
		$1 = { 00 30 A0 E3 03 10 51 E0 01 10 A0 13 04 10 80 E5 58 10 9F E5 52 30 C0 E5 00 10 80 E5 30 30 80 E5 08 30 80 E5 0C 30 80 E5 10 30 C0 E5 B2 31 C0 E1 B4 31 C0 E1 18 30 80 E5 1C 30 80 E5 20 30 80 E5 24 30 80 E5 28 30 80 E5 2C 30 80 E5 34 30 C0 E5 35 30 C0 E5 36 30 C0 E5 37 30 C0 E5 38 30 C0 E5 39 30 C0 E5 3A 30 C0 E5 3B 30 C0 E5 0E F0 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_31_3 {
	meta:
		name = "_ZNSt18__moneypunct_cacheIwLb1EEC1Ej"
		size = 116
		refs = "0070 _ZTVSt18__moneypunct_cacheIwLb1EE"
	strings:
		$1 = { 00 30 A0 E3 03 10 51 E0 01 10 A0 13 04 10 80 E5 58 10 9F E5 52 30 C0 E5 00 10 80 E5 30 30 80 E5 08 30 80 E5 0C 30 80 E5 10 30 C0 E5 B2 31 C0 E1 B4 31 C0 E1 18 30 80 E5 1C 30 80 E5 20 30 80 E5 24 30 80 E5 28 30 80 E5 2C 30 80 E5 34 30 C0 E5 35 30 C0 E5 36 30 C0 E5 37 30 C0 E5 38 30 C0 E5 39 30 C0 E5 3A 30 C0 E5 3B 30 C0 E5 0E F0 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_30_3 {
	meta:
		name = "_ZNSt18__moneypunct_cacheIwLb1EEC2Ej"
		size = 116
		refs = "0070 _ZTVSt18__moneypunct_cacheIwLb1EE"
	strings:
		$1 = { 00 30 A0 E3 03 10 51 E0 01 10 A0 13 04 10 80 E5 58 10 9F E5 52 30 C0 E5 00 10 80 E5 30 30 80 E5 08 30 80 E5 0C 30 80 E5 10 30 C0 E5 B2 31 C0 E1 B4 31 C0 E1 18 30 80 E5 1C 30 80 E5 20 30 80 E5 24 30 80 E5 28 30 80 E5 2C 30 80 E5 34 30 C0 E5 35 30 C0 E5 36 30 C0 E5 37 30 C0 E5 38 30 C0 E5 39 30 C0 E5 3A 30 C0 E5 3B 30 C0 E5 0E F0 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_32_3 {
	meta:
		name = "_ZNSt9money_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEEC2Ej"
		size = 28
		refs = "0018 _ZTVSt9money_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE"
		altNames = "_ZNSt9money_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEEC1Ej"
	strings:
		$1 = { 10 30 9F E5 00 10 51 E2 01 10 A0 13 00 30 80 E5 04 10 80 E5 0E F0 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_50_3 {
	meta:
		name = "_ZNSt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEEC1Ej"
		size = 28
		refs = "0018 _ZTVSt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 10 30 9F E5 00 10 51 E2 01 10 A0 13 00 30 80 E5 04 10 80 E5 0E F0 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_49_3 {
	meta:
		name = "_ZNSt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEEC2Ej"
		size = 28
		refs = "0018 _ZTVSt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 10 30 9F E5 00 10 51 E2 01 10 A0 13 00 30 80 E5 04 10 80 E5 0E F0 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_50_3 {
	meta:
		name = "_ZNSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEEC1Ej"
		size = 28
		refs = "0018 _ZTVSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE"
	strings:
		$1 = { 10 30 9F E5 00 10 51 E2 01 10 A0 13 00 30 80 E5 04 10 80 E5 0E F0 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_49_3 {
	meta:
		name = "_ZNSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEEC2Ej"
		size = 28
		refs = "0018 _ZTVSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE"
	strings:
		$1 = { 10 30 9F E5 00 10 51 E2 01 10 A0 13 00 30 80 E5 04 10 80 E5 0E F0 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_63_3 {
	meta:
		name = "_ZNSt7num_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEEC1Ej"
		size = 28
		refs = "0018 _ZTVSt7num_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 10 30 9F E5 00 10 51 E2 01 10 A0 13 00 30 80 E5 04 10 80 E5 0E F0 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_62_3 {
	meta:
		name = "_ZNSt7num_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEEC2Ej"
		size = 28
		refs = "0018 _ZTVSt7num_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 10 30 9F E5 00 10 51 E2 01 10 A0 13 00 30 80 E5 04 10 80 E5 0E F0 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_63_3 {
	meta:
		name = "_ZNSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEEC1Ej"
		size = 28
		refs = "0018 _ZTVSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE"
	strings:
		$1 = { 10 30 9F E5 00 10 51 E2 01 10 A0 13 00 30 80 E5 04 10 80 E5 0E F0 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_62_3 {
	meta:
		name = "_ZNSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEEC2Ej"
		size = 28
		refs = "0018 _ZTVSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE"
	strings:
		$1 = { 10 30 9F E5 00 10 51 E2 01 10 A0 13 00 30 80 E5 04 10 80 E5 0E F0 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_89_3 {
	meta:
		name = "_ZNSt8time_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEEC1Ej"
		size = 28
		refs = "0018 _ZTVSt8time_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 10 30 9F E5 00 10 51 E2 01 10 A0 13 00 30 80 E5 04 10 80 E5 0E F0 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_88_3 {
	meta:
		name = "_ZNSt8time_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEEC2Ej"
		size = 28
		refs = "0018 _ZTVSt8time_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 10 30 9F E5 00 10 51 E2 01 10 A0 13 00 30 80 E5 04 10 80 E5 0E F0 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_89_3 {
	meta:
		name = "_ZNSt8time_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEEC1Ej"
		size = 28
		refs = "0018 _ZTVSt8time_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE"
	strings:
		$1 = { 10 30 9F E5 00 10 51 E2 01 10 A0 13 00 30 80 E5 04 10 80 E5 0E F0 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_88_3 {
	meta:
		name = "_ZNSt8time_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEEC2Ej"
		size = 28
		refs = "0018 _ZTVSt8time_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE"
	strings:
		$1 = { 10 30 9F E5 00 10 51 E2 01 10 A0 13 00 30 80 E5 04 10 80 E5 0E F0 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_84_3 {
	meta:
		name = "_ZNSt8time_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEEC1Ej"
		size = 28
		refs = "0018 _ZTVSt8time_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 10 30 9F E5 00 10 51 E2 01 10 A0 13 00 30 80 E5 04 10 80 E5 0E F0 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_83_3 {
	meta:
		name = "_ZNSt8time_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEEC2Ej"
		size = 28
		refs = "0018 _ZTVSt8time_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 10 30 9F E5 00 10 51 E2 01 10 A0 13 00 30 80 E5 04 10 80 E5 0E F0 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_84_3 {
	meta:
		name = "_ZNSt8time_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEEC1Ej"
		size = 28
		refs = "0018 _ZTVSt8time_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE"
	strings:
		$1 = { 10 30 9F E5 00 10 51 E2 01 10 A0 13 00 30 80 E5 04 10 80 E5 0E F0 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_83_3 {
	meta:
		name = "_ZNSt8time_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEEC2Ej"
		size = 28
		refs = "0018 _ZTVSt8time_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE"
	strings:
		$1 = { 10 30 9F E5 00 10 51 E2 01 10 A0 13 00 30 80 E5 04 10 80 E5 0E F0 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_33_3 {
	meta:
		name = "_ZNSt9money_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEEC1Ej"
		size = 28
		refs = "0018 _ZTVSt9money_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 10 30 9F E5 00 10 51 E2 01 10 A0 13 00 30 80 E5 04 10 80 E5 0E F0 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_32_3 {
	meta:
		name = "_ZNSt9money_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEEC2Ej"
		size = 28
		refs = "0018 _ZTVSt9money_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 10 30 9F E5 00 10 51 E2 01 10 A0 13 00 30 80 E5 04 10 80 E5 0E F0 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_37_3 {
	meta:
		name = "_ZNSt9money_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEEC1Ej"
		size = 28
		refs = "0018 _ZTVSt9money_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 10 30 9F E5 00 10 51 E2 01 10 A0 13 00 30 80 E5 04 10 80 E5 0E F0 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_36_3 {
	meta:
		name = "_ZNSt9money_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEEC2Ej"
		size = 28
		refs = "0018 _ZTVSt9money_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 10 30 9F E5 00 10 51 E2 01 10 A0 13 00 30 80 E5 04 10 80 E5 0E F0 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_37_3 {
	meta:
		name = "_ZNSt9money_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEEC1Ej"
		size = 28
		refs = "0018 _ZTVSt9money_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE"
	strings:
		$1 = { 10 30 9F E5 00 10 51 E2 01 10 A0 13 00 30 80 E5 04 10 80 E5 0E F0 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_36_3 {
	meta:
		name = "_ZNSt9money_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEEC2Ej"
		size = 28
		refs = "0018 _ZTVSt9money_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE"
	strings:
		$1 = { 10 30 9F E5 00 10 51 E2 01 10 A0 13 00 30 80 E5 04 10 80 E5 0E F0 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_34_3 {
	meta:
		name = "_ZNKSt9money_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE3getES3_S3_bRSt8ios_baseRSt12_Ios_IostateRe"
		size = 108
		altNames = "_ZNKSt9money_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE3getES3_S3_bRSt8ios_baseRSt12_Ios_IostateRe"
	strings:
		$1 = { 10 40 2D E9 20 D0 4D E2 18 C0 8D E2 0C 00 8C E8 30 30 DD E5 28 20 8D E2 08 30 8D E5 34 30 9D E5 01 E0 A0 E1 0C 30 8D E5 38 30 9D E5 00 40 A0 E1 10 30 8D E5 3C 30 9D E5 14 30 8D E5 0D 30 A0 E1 03 00 92 E8 03 00 83 E8 04 00 A0 E1 0C 00 9C E8 0E 10 A0 E1 00 C0 9E E5 0F E0 A0 E1 08 F0 9C E5 04 00 A0 E1 20 D0 8D E2 10 80 BD E8 }
	condition:
		$1
}

rule file_17_35_3 {
	meta:
		name = "_ZNKSt9money_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE3getES3_S3_bRSt8ios_baseRSt12_Ios_IostateRSbIwS2_SaIwEE"
		size = 108
		altNames = "_ZNKSt9money_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE3getES3_S3_bRSt8ios_baseRSt12_Ios_IostateRSs"
	strings:
		$1 = { 10 40 2D E9 20 D0 4D E2 18 C0 8D E2 0C 00 8C E8 30 30 DD E5 28 20 8D E2 08 30 8D E5 34 30 9D E5 01 E0 A0 E1 0C 30 8D E5 38 30 9D E5 00 40 A0 E1 10 30 8D E5 3C 30 9D E5 14 30 8D E5 0D 30 A0 E1 03 00 92 E8 03 00 83 E8 04 00 A0 E1 0C 00 9C E8 0E 10 A0 E1 00 C0 9E E5 0F E0 A0 E1 0C F0 9C E5 04 00 A0 E1 20 D0 8D E2 10 80 BD E8 }
	condition:
		$1
}

rule file_17_38_3 {
	meta:
		name = "_ZNKSt9money_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE3putES3_bRSt8ios_basewe"
		size = 112
	strings:
		$1 = { 70 40 2D E9 24 D0 4D E2 1C C0 8D E2 0C 00 8C E8 40 40 8D E2 18 00 94 E8 34 60 DD E5 14 30 8D E5 18 40 8D E5 0C 00 9C E8 BC 53 DD E1 00 40 A0 E1 38 00 9D E5 00 60 8D E5 21 00 8D E9 01 C0 A0 E1 0C E0 8D E2 14 10 8D E2 03 00 91 E8 03 00 8E E8 0C 10 A0 E1 04 00 A0 E1 00 C0 9C E5 0F E0 A0 E1 08 F0 9C E5 04 00 A0 E1 24 D0 8D E2 70 80 BD E8 }
	condition:
		$1
}

rule file_17_39_3 {
	meta:
		name = "_ZNKSt9money_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE3putES3_bRSt8ios_basewRKSbIwS2_SaIwEE"
		size = 80
	strings:
		$1 = { 10 40 2D E9 18 D0 4D E2 10 E0 8D E2 0C 00 8E E8 20 20 DD E5 B8 32 DD E1 00 20 8D E5 08 30 8D E5 24 20 9D E5 2C 30 9D E5 04 20 8D E5 0C 30 8D E5 00 40 A0 E1 00 C0 91 E5 0C 00 9E E8 0F E0 A0 E1 0C F0 9C E5 04 00 A0 E1 18 D0 8D E2 10 80 BD E8 }
	condition:
		$1
}

rule file_17_47_3 {
	meta:
		name = "_ZNSt16__numpunct_cacheIwEC2Ej"
		size = 72
		refs = "0044 _ZTVSt16__numpunct_cacheIwE"
		altNames = "_ZNSt16__numpunct_cacheIwEC1Ej"
	strings:
		$1 = { 00 30 A0 E3 38 20 9F E5 03 10 51 E0 01 10 A0 13 A4 30 C0 E5 04 10 80 E5 00 20 80 E5 B6 32 C0 E1 08 30 80 E5 0C 30 80 E5 10 30 C0 E5 14 30 80 E5 18 30 80 E5 1C 30 80 E5 20 30 80 E5 B4 32 C0 E1 0E F0 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_51_3 {
	meta:
		name = "_ZNKSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE3getES3_S3_RSt8ios_baseRSt12_Ios_IostateRb"
		size = 100
		altNames = "_ZNKSt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE3getES3_S3_RSt8ios_baseRSt12_Ios_IostateRb"
	strings:
		$1 = { 10 40 2D E9 1C D0 4D E2 14 C0 8D E2 0C 00 8C E8 2C 20 9D E5 24 30 8D E2 08 20 8D E5 30 20 9D E5 01 E0 A0 E1 0C 20 8D E5 34 20 9D E5 00 40 A0 E1 10 20 8D E5 03 00 93 E8 0D 30 A0 E1 03 00 83 E8 04 00 A0 E1 0C 00 9C E8 0E 10 A0 E1 00 C0 9E E5 0F E0 A0 E1 08 F0 9C E5 04 00 A0 E1 1C D0 8D E2 10 80 BD E8 }
	condition:
		$1
}

rule file_17_52_3 {
	meta:
		name = "_ZNKSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE3getES3_S3_RSt8ios_baseRSt12_Ios_IostateRl"
		size = 100
		altNames = "_ZNKSt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE3getES3_S3_RSt8ios_baseRSt12_Ios_IostateRl _ZNKSt8time_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE8get_timeES3_S3_RSt8ios_baseRSt12_Ios_IostateP2tm _ZNKSt8time_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE8get_timeES3_S3_RSt8ios_baseRSt12_Ios_IostateP2tm"
	strings:
		$1 = { 10 40 2D E9 1C D0 4D E2 14 C0 8D E2 0C 00 8C E8 2C 20 9D E5 24 30 8D E2 08 20 8D E5 30 20 9D E5 01 E0 A0 E1 0C 20 8D E5 34 20 9D E5 00 40 A0 E1 10 20 8D E5 03 00 93 E8 0D 30 A0 E1 03 00 83 E8 04 00 A0 E1 0C 00 9C E8 0E 10 A0 E1 00 C0 9E E5 0F E0 A0 E1 0C F0 9C E5 04 00 A0 E1 1C D0 8D E2 10 80 BD E8 }
	condition:
		$1
}

rule file_17_53_3 {
	meta:
		name = "_ZNKSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE3getES3_S3_RSt8ios_baseRSt12_Ios_IostateRt"
		size = 100
		altNames = "_ZNKSt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE3getES3_S3_RSt8ios_baseRSt12_Ios_IostateRt _ZNKSt8time_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE8get_dateES3_S3_RSt8ios_baseRSt12_Ios_IostateP2tm _ZNKSt8time_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE8get_dateES3_S3_RSt8ios_baseRSt12_Ios_IostateP2tm"
	strings:
		$1 = { 10 40 2D E9 1C D0 4D E2 14 C0 8D E2 0C 00 8C E8 2C 20 9D E5 24 30 8D E2 08 20 8D E5 30 20 9D E5 01 E0 A0 E1 0C 20 8D E5 34 20 9D E5 00 40 A0 E1 10 20 8D E5 03 00 93 E8 0D 30 A0 E1 03 00 83 E8 04 00 A0 E1 0C 00 9C E8 0E 10 A0 E1 00 C0 9E E5 0F E0 A0 E1 10 F0 9C E5 04 00 A0 E1 1C D0 8D E2 10 80 BD E8 }
	condition:
		$1
}

rule file_17_54_3 {
	meta:
		name = "_ZNKSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE3getES3_S3_RSt8ios_baseRSt12_Ios_IostateRj"
		size = 100
		altNames = "_ZNKSt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE3getES3_S3_RSt8ios_baseRSt12_Ios_IostateRj _ZNKSt8time_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE11get_weekdayES3_S3_RSt8ios_baseRSt12_Ios_IostateP2tm _ZNKSt8time_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE11get_weekdayES3_S3_RSt8ios_baseRSt12_Ios_IostateP2tm"
	strings:
		$1 = { 10 40 2D E9 1C D0 4D E2 14 C0 8D E2 0C 00 8C E8 2C 20 9D E5 24 30 8D E2 08 20 8D E5 30 20 9D E5 01 E0 A0 E1 0C 20 8D E5 34 20 9D E5 00 40 A0 E1 10 20 8D E5 03 00 93 E8 0D 30 A0 E1 03 00 83 E8 04 00 A0 E1 0C 00 9C E8 0E 10 A0 E1 00 C0 9E E5 0F E0 A0 E1 14 F0 9C E5 04 00 A0 E1 1C D0 8D E2 10 80 BD E8 }
	condition:
		$1
}

rule file_17_55_3 {
	meta:
		name = "_ZNKSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE3getES3_S3_RSt8ios_baseRSt12_Ios_IostateRm"
		size = 100
		altNames = "_ZNKSt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE3getES3_S3_RSt8ios_baseRSt12_Ios_IostateRm _ZNKSt8time_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE13get_monthnameES3_S3_RSt8ios_baseRSt12_Ios_IostateP2tm _ZNKSt8time_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE13get_monthnameES3_S3_RSt8ios_baseRSt12_Ios_IostateP2tm"
	strings:
		$1 = { 10 40 2D E9 1C D0 4D E2 14 C0 8D E2 0C 00 8C E8 2C 20 9D E5 24 30 8D E2 08 20 8D E5 30 20 9D E5 01 E0 A0 E1 0C 20 8D E5 34 20 9D E5 00 40 A0 E1 10 20 8D E5 03 00 93 E8 0D 30 A0 E1 03 00 83 E8 04 00 A0 E1 0C 00 9C E8 0E 10 A0 E1 00 C0 9E E5 0F E0 A0 E1 18 F0 9C E5 04 00 A0 E1 1C D0 8D E2 10 80 BD E8 }
	condition:
		$1
}

rule file_17_56_3 {
	meta:
		name = "_ZNKSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE3getES3_S3_RSt8ios_baseRSt12_Ios_IostateRx"
		size = 100
		altNames = "_ZNKSt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE3getES3_S3_RSt8ios_baseRSt12_Ios_IostateRx _ZNKSt8time_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE8get_yearES3_S3_RSt8ios_baseRSt12_Ios_IostateP2tm _ZNKSt8time_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE8get_yearES3_S3_RSt8ios_baseRSt12_Ios_IostateP2tm"
	strings:
		$1 = { 10 40 2D E9 1C D0 4D E2 14 C0 8D E2 0C 00 8C E8 2C 20 9D E5 24 30 8D E2 08 20 8D E5 30 20 9D E5 01 E0 A0 E1 0C 20 8D E5 34 20 9D E5 00 40 A0 E1 10 20 8D E5 03 00 93 E8 0D 30 A0 E1 03 00 83 E8 04 00 A0 E1 0C 00 9C E8 0E 10 A0 E1 00 C0 9E E5 0F E0 A0 E1 1C F0 9C E5 04 00 A0 E1 1C D0 8D E2 10 80 BD E8 }
	condition:
		$1
}

rule file_17_57_3 {
	meta:
		name = "_ZNKSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE3getES3_S3_RSt8ios_baseRSt12_Ios_IostateRy"
		size = 100
		altNames = "_ZNKSt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE3getES3_S3_RSt8ios_baseRSt12_Ios_IostateRy"
	strings:
		$1 = { 10 40 2D E9 1C D0 4D E2 14 C0 8D E2 0C 00 8C E8 2C 20 9D E5 24 30 8D E2 08 20 8D E5 30 20 9D E5 01 E0 A0 E1 0C 20 8D E5 34 20 9D E5 00 40 A0 E1 10 20 8D E5 03 00 93 E8 0D 30 A0 E1 03 00 83 E8 04 00 A0 E1 0C 00 9C E8 0E 10 A0 E1 00 C0 9E E5 0F E0 A0 E1 20 F0 9C E5 04 00 A0 E1 1C D0 8D E2 10 80 BD E8 }
	condition:
		$1
}

rule file_17_58_3 {
	meta:
		name = "_ZNKSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE3getES3_S3_RSt8ios_baseRSt12_Ios_IostateRf"
		size = 100
		altNames = "_ZNKSt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE3getES3_S3_RSt8ios_baseRSt12_Ios_IostateRf"
	strings:
		$1 = { 10 40 2D E9 1C D0 4D E2 14 C0 8D E2 0C 00 8C E8 2C 20 9D E5 24 30 8D E2 08 20 8D E5 30 20 9D E5 01 E0 A0 E1 0C 20 8D E5 34 20 9D E5 00 40 A0 E1 10 20 8D E5 03 00 93 E8 0D 30 A0 E1 03 00 83 E8 04 00 A0 E1 0C 00 9C E8 0E 10 A0 E1 00 C0 9E E5 0F E0 A0 E1 24 F0 9C E5 04 00 A0 E1 1C D0 8D E2 10 80 BD E8 }
	condition:
		$1
}

rule file_17_59_3 {
	meta:
		name = "_ZNKSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE3getES3_S3_RSt8ios_baseRSt12_Ios_IostateRd"
		size = 100
		altNames = "_ZNKSt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE3getES3_S3_RSt8ios_baseRSt12_Ios_IostateRd"
	strings:
		$1 = { 10 40 2D E9 1C D0 4D E2 14 C0 8D E2 0C 00 8C E8 2C 20 9D E5 24 30 8D E2 08 20 8D E5 30 20 9D E5 01 E0 A0 E1 0C 20 8D E5 34 20 9D E5 00 40 A0 E1 10 20 8D E5 03 00 93 E8 0D 30 A0 E1 03 00 83 E8 04 00 A0 E1 0C 00 9C E8 0E 10 A0 E1 00 C0 9E E5 0F E0 A0 E1 28 F0 9C E5 04 00 A0 E1 1C D0 8D E2 10 80 BD E8 }
	condition:
		$1
}

rule file_17_60_3 {
	meta:
		name = "_ZNKSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE3getES3_S3_RSt8ios_baseRSt12_Ios_IostateRe"
		size = 100
		altNames = "_ZNKSt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE3getES3_S3_RSt8ios_baseRSt12_Ios_IostateRe"
	strings:
		$1 = { 10 40 2D E9 1C D0 4D E2 14 C0 8D E2 0C 00 8C E8 2C 20 9D E5 24 30 8D E2 08 20 8D E5 30 20 9D E5 01 E0 A0 E1 0C 20 8D E5 34 20 9D E5 00 40 A0 E1 10 20 8D E5 03 00 93 E8 0D 30 A0 E1 03 00 83 E8 04 00 A0 E1 0C 00 9C E8 0E 10 A0 E1 00 C0 9E E5 0F E0 A0 E1 2C F0 9C E5 04 00 A0 E1 1C D0 8D E2 10 80 BD E8 }
	condition:
		$1
}

rule file_17_61_3 {
	meta:
		name = "_ZNKSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE3getES3_S3_RSt8ios_baseRSt12_Ios_IostateRPv"
		size = 100
		altNames = "_ZNKSt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE3getES3_S3_RSt8ios_baseRSt12_Ios_IostateRPv"
	strings:
		$1 = { 10 40 2D E9 1C D0 4D E2 14 C0 8D E2 0C 00 8C E8 2C 20 9D E5 24 30 8D E2 08 20 8D E5 30 20 9D E5 01 E0 A0 E1 0C 20 8D E5 34 20 9D E5 00 40 A0 E1 10 20 8D E5 03 00 93 E8 0D 30 A0 E1 03 00 83 E8 04 00 A0 E1 0C 00 9C E8 0E 10 A0 E1 00 C0 9E E5 0F E0 A0 E1 30 F0 9C E5 04 00 A0 E1 1C D0 8D E2 10 80 BD E8 }
	condition:
		$1
}

rule file_17_64_3 {
	meta:
		name = "_ZNKSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE3putES3_RSt8ios_basewb"
		size = 68
	strings:
		$1 = { 10 40 2D E9 14 D0 4D E2 0C E0 8D E2 0C 00 8E E8 1C C0 9D E5 B0 22 DD E1 24 30 DD E5 00 C0 8D E5 0C 00 8D E9 00 40 A0 E1 00 C0 91 E5 0C 00 9E E8 0F E0 A0 E1 08 F0 9C E5 04 00 A0 E1 14 D0 8D E2 10 80 BD E8 }
	condition:
		$1
}

rule file_17_65_3 {
	meta:
		name = "_ZNKSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE3putES3_RSt8ios_basewl"
		size = 72
	strings:
		$1 = { 10 40 2D E9 14 D0 4D E2 0C E0 8D E2 0C 00 8E E8 B0 32 DD E1 1C 20 9D E5 04 30 8D E5 24 30 9D E5 00 20 8D E5 08 30 8D E5 00 40 A0 E1 00 C0 91 E5 0C 00 9E E8 0F E0 A0 E1 0C F0 9C E5 04 00 A0 E1 14 D0 8D E2 10 80 BD E8 }
	condition:
		$1
}

rule file_17_66_3 {
	meta:
		name = "_ZNKSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE3putES3_RSt8ios_basewm"
		size = 72
	strings:
		$1 = { 10 40 2D E9 14 D0 4D E2 0C E0 8D E2 0C 00 8E E8 B0 32 DD E1 1C 20 9D E5 04 30 8D E5 24 30 9D E5 00 20 8D E5 08 30 8D E5 00 40 A0 E1 00 C0 91 E5 0C 00 9E E8 0F E0 A0 E1 10 F0 9C E5 04 00 A0 E1 14 D0 8D E2 10 80 BD E8 }
	condition:
		$1
}

rule file_17_67_3 {
	meta:
		name = "_ZNKSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE3putES3_RSt8ios_basewx"
		size = 104
	strings:
		$1 = { 30 40 2D E9 20 D0 4D E2 18 C0 8D E2 0C 00 8C E8 34 40 8D E2 18 00 94 E8 B0 53 DD E1 10 30 8D E5 14 40 8D E5 0C 00 9C E8 00 40 A0 E1 2C 00 9D E5 21 00 8D E8 01 C0 A0 E1 08 E0 8D E2 10 10 8D E2 03 00 91 E8 03 00 8E E8 0C 10 A0 E1 04 00 A0 E1 00 C0 9C E5 0F E0 A0 E1 14 F0 9C E5 04 00 A0 E1 20 D0 8D E2 30 80 BD E8 }
	condition:
		$1
}

rule file_17_68_3 {
	meta:
		name = "_ZNKSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE3putES3_RSt8ios_basewy"
		size = 104
	strings:
		$1 = { 30 40 2D E9 20 D0 4D E2 18 C0 8D E2 0C 00 8C E8 34 40 8D E2 18 00 94 E8 B0 53 DD E1 10 30 8D E5 14 40 8D E5 0C 00 9C E8 00 40 A0 E1 2C 00 9D E5 21 00 8D E8 01 C0 A0 E1 08 E0 8D E2 10 10 8D E2 03 00 91 E8 03 00 8E E8 0C 10 A0 E1 04 00 A0 E1 00 C0 9C E5 0F E0 A0 E1 18 F0 9C E5 04 00 A0 E1 20 D0 8D E2 30 80 BD E8 }
	condition:
		$1
}

rule file_17_69_3 {
	meta:
		name = "_ZNKSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE3putES3_RSt8ios_basewd"
		size = 104
	strings:
		$1 = { 30 40 2D E9 20 D0 4D E2 18 C0 8D E2 0C 00 8C E8 34 40 8D E2 18 00 94 E8 B0 53 DD E1 10 30 8D E5 14 40 8D E5 0C 00 9C E8 00 40 A0 E1 2C 00 9D E5 21 00 8D E8 01 C0 A0 E1 08 E0 8D E2 10 10 8D E2 03 00 91 E8 03 00 8E E8 0C 10 A0 E1 04 00 A0 E1 00 C0 9C E5 0F E0 A0 E1 1C F0 9C E5 04 00 A0 E1 20 D0 8D E2 30 80 BD E8 }
	condition:
		$1
}

rule file_17_70_3 {
	meta:
		name = "_ZNKSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE3putES3_RSt8ios_basewe"
		size = 104
	strings:
		$1 = { 30 40 2D E9 20 D0 4D E2 18 C0 8D E2 0C 00 8C E8 34 40 8D E2 18 00 94 E8 B0 53 DD E1 10 30 8D E5 14 40 8D E5 0C 00 9C E8 00 40 A0 E1 2C 00 9D E5 21 00 8D E8 01 C0 A0 E1 08 E0 8D E2 10 10 8D E2 03 00 91 E8 03 00 8E E8 0C 10 A0 E1 04 00 A0 E1 00 C0 9C E5 0F E0 A0 E1 20 F0 9C E5 04 00 A0 E1 20 D0 8D E2 30 80 BD E8 }
	condition:
		$1
}

rule file_17_71_3 {
	meta:
		name = "_ZNKSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE3putES3_RSt8ios_basewPKv"
		size = 72
	strings:
		$1 = { 10 40 2D E9 14 D0 4D E2 0C E0 8D E2 0C 00 8E E8 B0 32 DD E1 1C 20 9D E5 04 30 8D E5 24 30 9D E5 00 20 8D E5 08 30 8D E5 00 40 A0 E1 00 C0 91 E5 0C 00 9E E8 0F E0 A0 E1 24 F0 9C E5 04 00 A0 E1 14 D0 8D E2 10 80 BD E8 }
	condition:
		$1
}

rule file_17_72_3 {
	meta:
		name = "_ZNKSt11__timepunctIwE15_M_date_formatsEPPKw"
		size = 24
		altNames = "_ZNKSt11__timepunctIcE15_M_date_formatsEPPKc"
	strings:
		$1 = { 08 30 90 E5 08 20 93 E5 00 20 81 E5 0C 30 93 E5 04 30 81 E5 0E F0 A0 E1 }
	condition:
		$1
}

rule file_17_73_3 {
	meta:
		name = "_ZNKSt11__timepunctIwE15_M_time_formatsEPPKw"
		size = 24
		altNames = "_ZNKSt11__timepunctIcE15_M_time_formatsEPPKc"
	strings:
		$1 = { 08 30 90 E5 10 20 93 E5 00 20 81 E5 14 30 93 E5 04 30 81 E5 0E F0 A0 E1 }
	condition:
		$1
}

rule file_17_74_3 {
	meta:
		name = "_ZNKSt11__timepunctIwE20_M_date_time_formatsEPPKw"
		size = 24
		altNames = "_ZNKSt11__timepunctIcE20_M_date_time_formatsEPPKc"
	strings:
		$1 = { 08 30 90 E5 18 20 93 E5 00 20 81 E5 1C 30 93 E5 04 30 81 E5 0E F0 A0 E1 }
	condition:
		$1
}

rule file_17_76_3 {
	meta:
		name = "_ZNKSt11__timepunctIwE8_M_am_pmEPPKw"
		size = 24
		altNames = "_ZNKSt11__timepunctIcE8_M_am_pmEPPKc"
	strings:
		$1 = { 08 30 90 E5 20 20 93 E5 00 20 81 E5 24 30 93 E5 04 30 81 E5 0E F0 A0 E1 }
	condition:
		$1
}

rule file_17_77_3 {
	meta:
		name = "_ZNKSt11__timepunctIwE7_M_daysEPPKw"
		size = 64
		altNames = "_ZNKSt11__timepunctIcE7_M_daysEPPKc"
	strings:
		$1 = { 08 30 90 E5 2C 20 93 E5 00 20 81 E5 30 20 93 E5 04 20 81 E5 34 20 93 E5 08 20 81 E5 38 20 93 E5 0C 20 81 E5 3C 20 93 E5 10 20 81 E5 40 20 93 E5 14 20 81 E5 44 30 93 E5 18 30 81 E5 0E F0 A0 E1 }
	condition:
		$1
}

rule file_17_78_3 {
	meta:
		name = "_ZNKSt11__timepunctIwE19_M_days_abbreviatedEPPKw"
		size = 64
		altNames = "_ZNKSt11__timepunctIcE19_M_days_abbreviatedEPPKc"
	strings:
		$1 = { 08 30 90 E5 48 20 93 E5 00 20 81 E5 4C 20 93 E5 04 20 81 E5 50 20 93 E5 08 20 81 E5 54 20 93 E5 0C 20 81 E5 58 20 93 E5 10 20 81 E5 5C 20 93 E5 14 20 81 E5 60 30 93 E5 18 30 81 E5 0E F0 A0 E1 }
	condition:
		$1
}

rule file_17_79_3 {
	meta:
		name = "_ZNKSt11__timepunctIwE9_M_monthsEPPKw"
		size = 104
		altNames = "_ZNKSt11__timepunctIcE9_M_monthsEPPKc"
	strings:
		$1 = { 08 30 90 E5 64 20 93 E5 00 20 81 E5 68 20 93 E5 04 20 81 E5 6C 20 93 E5 08 20 81 E5 70 20 93 E5 0C 20 81 E5 74 20 93 E5 10 20 81 E5 78 20 93 E5 14 20 81 E5 7C 20 93 E5 18 20 81 E5 80 20 93 E5 1C 20 81 E5 84 20 93 E5 20 20 81 E5 88 20 93 E5 24 20 81 E5 8C 20 93 E5 28 20 81 E5 90 30 93 E5 2C 30 81 E5 0E F0 A0 E1 }
	condition:
		$1
}

rule file_17_80_3 {
	meta:
		name = "_ZNKSt11__timepunctIwE21_M_months_abbreviatedEPPKw"
		size = 104
		altNames = "_ZNKSt11__timepunctIcE21_M_months_abbreviatedEPPKc"
	strings:
		$1 = { 08 30 90 E5 94 20 93 E5 00 20 81 E5 98 20 93 E5 04 20 81 E5 9C 20 93 E5 08 20 81 E5 A0 20 93 E5 0C 20 81 E5 A4 20 93 E5 10 20 81 E5 A8 20 93 E5 14 20 81 E5 AC 20 93 E5 18 20 81 E5 B0 20 93 E5 1C 20 81 E5 B4 20 93 E5 20 20 81 E5 B8 20 93 E5 24 20 81 E5 BC 20 93 E5 28 20 81 E5 C0 30 93 E5 2C 30 81 E5 0E F0 A0 E1 }
	condition:
		$1
}

rule file_17_81_3 {
	meta:
		name = "_ZNSt17__timepunct_cacheIwEC2Ej"
		size = 224
		refs = "00dc _ZTVSt17__timepunct_cacheIwE"
		altNames = "_ZNSt17__timepunct_cacheIwEC1Ej"
	strings:
		$1 = { D4 20 9F E5 00 30 A0 E3 00 10 51 E2 01 10 A0 13 04 10 80 E5 00 20 80 E5 08 30 80 E5 0C 30 80 E5 10 30 80 E5 14 30 80 E5 18 30 80 E5 1C 30 80 E5 20 30 80 E5 24 30 80 E5 28 30 80 E5 2C 30 80 E5 30 30 80 E5 34 30 80 E5 38 30 80 E5 3C 30 80 E5 40 30 80 E5 44 30 80 E5 48 30 80 E5 4C 30 80 E5 50 30 80 E5 54 30 80 E5 58 30 80 E5 5C 30 80 E5 60 30 80 E5 64 30 80 E5 68 30 80 E5 6C 30 80 E5 70 30 80 E5 74 30 80 E5 78 30 80 E5 7C 30 80 E5 80 30 80 E5 84 30 80 E5 C4 30 C0 E5 88 30 80 E5 8C 30 80 E5 90 30 80 E5 94 30 80 E5 98 30 80 E5 9C 30 80 E5 A0 30 80 E5 A4 30 80 E5 A8 30 80 E5 AC 30 80 E5 B0 30 80 E5 B4 30 80 E5 B8 30 80 E5 BC 30 80 E5 C0 30 80 E5 0E F0 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_82_3 {
	meta:
		name = "_ZNSt17__timepunct_cacheIcEC1Ej"
		size = 224
		refs = "00dc _ZTVSt17__timepunct_cacheIcE"
	strings:
		$1 = { D4 20 9F E5 00 30 A0 E3 00 10 51 E2 01 10 A0 13 04 10 80 E5 00 20 80 E5 08 30 80 E5 0C 30 80 E5 10 30 80 E5 14 30 80 E5 18 30 80 E5 1C 30 80 E5 20 30 80 E5 24 30 80 E5 28 30 80 E5 2C 30 80 E5 30 30 80 E5 34 30 80 E5 38 30 80 E5 3C 30 80 E5 40 30 80 E5 44 30 80 E5 48 30 80 E5 4C 30 80 E5 50 30 80 E5 54 30 80 E5 58 30 80 E5 5C 30 80 E5 60 30 80 E5 64 30 80 E5 68 30 80 E5 6C 30 80 E5 70 30 80 E5 74 30 80 E5 78 30 80 E5 7C 30 80 E5 80 30 80 E5 84 30 80 E5 C4 30 C0 E5 88 30 80 E5 8C 30 80 E5 90 30 80 E5 94 30 80 E5 98 30 80 E5 9C 30 80 E5 A0 30 80 E5 A4 30 80 E5 A8 30 80 E5 AC 30 80 E5 B0 30 80 E5 B4 30 80 E5 B8 30 80 E5 BC 30 80 E5 C0 30 80 E5 0E F0 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_81_3 {
	meta:
		name = "_ZNSt17__timepunct_cacheIcEC2Ej"
		size = 224
		refs = "00dc _ZTVSt17__timepunct_cacheIcE"
	strings:
		$1 = { D4 20 9F E5 00 30 A0 E3 00 10 51 E2 01 10 A0 13 04 10 80 E5 00 20 80 E5 08 30 80 E5 0C 30 80 E5 10 30 80 E5 14 30 80 E5 18 30 80 E5 1C 30 80 E5 20 30 80 E5 24 30 80 E5 28 30 80 E5 2C 30 80 E5 30 30 80 E5 34 30 80 E5 38 30 80 E5 3C 30 80 E5 40 30 80 E5 44 30 80 E5 48 30 80 E5 4C 30 80 E5 50 30 80 E5 54 30 80 E5 58 30 80 E5 5C 30 80 E5 60 30 80 E5 64 30 80 E5 68 30 80 E5 6C 30 80 E5 70 30 80 E5 74 30 80 E5 78 30 80 E5 7C 30 80 E5 80 30 80 E5 84 30 80 E5 C4 30 C0 E5 88 30 80 E5 8C 30 80 E5 90 30 80 E5 94 30 80 E5 98 30 80 E5 9C 30 80 E5 A0 30 80 E5 A4 30 80 E5 A8 30 80 E5 AC 30 80 E5 B0 30 80 E5 B4 30 80 E5 B8 30 80 E5 BC 30 80 E5 C0 30 80 E5 0E F0 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_85_3 {
	meta:
		name = "_ZNKSt8time_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE3putES3_RSt8ios_basewPK2tmcc"
		size = 88
	strings:
		$1 = { 10 40 2D E9 1C D0 4D E2 B8 C2 DD E1 14 E0 8D E2 0C 00 8E E8 24 40 9D E5 D0 23 DD E1 D4 33 DD E1 04 C0 8D E5 2C C0 9D E5 00 40 8D E5 08 C0 8D E5 0C 20 8D E5 10 30 8D E5 00 40 A0 E1 00 C0 91 E5 0C 00 9E E8 0F E0 A0 E1 08 F0 9C E5 04 00 A0 E1 1C D0 8D E2 10 80 BD E8 }
	condition:
		$1
}

rule file_17_86_3 {
	meta:
		name = "_ZNSt15time_put_bynameIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEEC2EPKcj"
		size = 28
		refs = "0018 _ZTVSt15time_put_bynameIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE"
		altNames = "_ZNSt15time_put_bynameIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEEC1EPKcj"
	strings:
		$1 = { 10 30 9F E5 00 20 52 E2 01 20 A0 13 00 30 80 E5 04 20 80 E5 0E F0 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_98_3 {
	meta:
		name = "_ZNSt15time_get_bynameIcSt19istreambuf_iteratorIcSt11char_traitsIcEEEC1EPKcj"
		size = 28
		refs = "0018 _ZTVSt15time_get_bynameIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 10 30 9F E5 00 20 52 E2 01 20 A0 13 00 30 80 E5 04 20 80 E5 0E F0 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_97_3 {
	meta:
		name = "_ZNSt15time_get_bynameIcSt19istreambuf_iteratorIcSt11char_traitsIcEEEC2EPKcj"
		size = 28
		refs = "0018 _ZTVSt15time_get_bynameIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 10 30 9F E5 00 20 52 E2 01 20 A0 13 00 30 80 E5 04 20 80 E5 0E F0 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_98_3 {
	meta:
		name = "_ZNSt15time_get_bynameIwSt19istreambuf_iteratorIwSt11char_traitsIwEEEC1EPKcj"
		size = 28
		refs = "0018 _ZTVSt15time_get_bynameIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE"
	strings:
		$1 = { 10 30 9F E5 00 20 52 E2 01 20 A0 13 00 30 80 E5 04 20 80 E5 0E F0 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_97_3 {
	meta:
		name = "_ZNSt15time_get_bynameIwSt19istreambuf_iteratorIwSt11char_traitsIwEEEC2EPKcj"
		size = 28
		refs = "0018 _ZTVSt15time_get_bynameIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE"
	strings:
		$1 = { 10 30 9F E5 00 20 52 E2 01 20 A0 13 00 30 80 E5 04 20 80 E5 0E F0 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_87_3 {
	meta:
		name = "_ZNSt15time_put_bynameIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEEC1EPKcj"
		size = 28
		refs = "0018 _ZTVSt15time_put_bynameIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 10 30 9F E5 00 20 52 E2 01 20 A0 13 00 30 80 E5 04 20 80 E5 0E F0 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_86_3 {
	meta:
		name = "_ZNSt15time_put_bynameIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEEC2EPKcj"
		size = 28
		refs = "0018 _ZTVSt15time_put_bynameIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 10 30 9F E5 00 20 52 E2 01 20 A0 13 00 30 80 E5 04 20 80 E5 0E F0 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_101_3 {
	meta:
		name = "_ZNKSt8messagesIwE3getEiiiRKSbIwSt11char_traitsIwESaIwEE"
		size = 52
		altNames = "_ZNKSt8messagesIcE3getEiiiRKSs"
	strings:
		$1 = { 10 40 2D E9 08 D0 4D E2 10 C0 9D E5 00 40 A0 E1 00 C0 8D E5 14 C0 9D E5 04 C0 8D E5 00 C0 91 E5 0F E0 A0 E1 0C F0 9C E5 04 00 A0 E1 08 D0 8D E2 10 80 BD E8 }
	condition:
		$1
}

rule file_17_102_3 {
	meta:
		name = "_ZNKSt8messagesIwE5closeEi"
		size = 20
		altNames = "_ZNKSt7collateIcE4hashEPKcS2_ _ZNKSt7collateIwE4hashEPKwS2_ _ZNKSt8messagesIcE5closeEi"
	strings:
		$1 = { 04 E0 2D E5 00 30 90 E5 0F E0 A0 E1 10 F0 93 E5 04 F0 9D E4 }
	condition:
		$1
}

rule file_17_107_3 {
	meta:
		name = "_ZNKSt7collateIwE7compareEPKwS2_S2_S2_"
		size = 36
		altNames = "_ZNKSt7collateIcE7compareEPKcS2_S2_S2_"
	strings:
		$1 = { 04 E0 2D E5 04 D0 4D E2 08 E0 9D E5 00 C0 90 E5 00 E0 8D E5 0F E0 A0 E1 08 F0 9C E5 04 D0 8D E2 00 80 BD E8 }
	condition:
		$1
}

rule file_17_108_3 {
	meta:
		name = "_ZNKSt7collateIwE9transformEPKwS2_"
		size = 28
		altNames = "_ZNKSt7collateIcE9transformEPKcS2_"
	strings:
		$1 = { 10 40 2D E9 00 C0 91 E5 00 40 A0 E1 0F E0 A0 E1 0C F0 9C E5 04 00 A0 E1 10 80 BD E8 }
	condition:
		$1
}

rule file_17_110_3 {
	meta:
		name = "_ZNKSt7collateIwE7do_hashEPKwS2_"
		size = 36
	strings:
		$1 = { 02 00 51 E1 00 00 A0 23 0E F0 A0 21 00 00 A0 E3 B2 30 D1 E0 01 00 52 E1 E0 0C 83 E0 FB FF FF 8A 0E F0 A0 E1 }
	condition:
		$1
}

rule file_17_111_3 {
	meta:
		name = "_ZSt14__add_groupingIwEPT_S1_S0_PKcjPKS0_S5_"
		size = 420
	strings:
		$1 = { F0 0F 2D E9 01 18 A0 E1 00 C0 A0 E3 20 50 9D E5 24 40 9D E5 00 A0 D2 E5 01 B0 43 E2 21 18 A0 E1 0C 30 A0 E1 02 80 A0 E1 0A 6C A0 E1 46 7C A0 E1 04 90 65 E0 C9 00 57 E1 4A 00 00 BA 04 00 55 E1 0B 00 00 0A 00 20 A0 E3 B2 60 95 E1 B2 60 80 E1 02 20 82 E2 02 60 85 E0 06 00 54 E1 F9 FF FF 1A 02 20 85 E2 04 20 62 E0 01 20 C2 E3 02 20 82 E2 02 00 80 E0 00 00 5C E3 09 00 00 0A 00 20 A0 E1 B2 10 C2 E0 00 50 D8 E5 05 6C A0 E1 00 00 56 E3 02 00 A0 D1 11 00 00 CA 01 C0 4C E2 00 00 5C E3 F5 FF FF 1A 00 00 53 E3 0A 00 00 0A 00 20 A0 E1 B2 10 C2 E0 01 C0 58 E5 01 30 43 E2 0C 5C A0 E1 00 00 55 E3 02 00 A0 D1 15 00 00 CA 01 80 48 E2 00 00 53 E3 F4 FF FF 1A F0 0F BD E8 0E F0 A0 E1 01 50 45 E2 FF 70 05 E2 01 70 87 E2 87 70 A0 E1 00 60 A0 E3 B6 A0 94 E1 02 60 86 E2 07 00 56 E1 B2 A0 E0 E1 FA FF FF 1A FF 00 05 E2 01 00 80 E2 80 00 A0 E1 00 40 84 E0 01 C0 4C E2 00 00 82 E0 DD FF FF EA 01 C0 4C E2 FF 60 0C E2 01 60 86 E2 86 60 A0 E1 00 50 A0 E3 B5 70 94 E1 02 50 85 E2 06 00 55 E1 B2 70 E0 E1 FA FF FF 1A FF 00 0C E2 01 00 80 E2 80 00 A0 E1 00 40 84 E0 01 80 48 E2 00 00 82 E0 D9 FF FF EA 00 00 57 E3 B2 FF FF DA 7F 00 57 E3 B0 FF FF 0A 0B 00 53 E1 05 00 00 2A 01 30 83 E2 02 80 A0 E1 03 A0 F8 E7 C6 4B 44 E0 FF A0 0A E2 A3 FF FF EA FF A0 0A E2 01 C0 8C E2 F9 FF FF EA }
	condition:
		$1
}

rule file_17_112_3 {
	meta:
		name = "_ZNKSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE12_M_group_intEPKcjwRSt8ios_basePwS9_Ri"
		size = 84
		refs = "003c _ZSt14__add_groupingIwEPT_S1_S0_PKcjPKS0_S5_"
	strings:
		$1 = { 70 40 2D E9 08 D0 4D E2 24 40 9D E5 1C 50 9D E5 00 E0 94 E5 20 C0 9D E5 02 00 A0 E1 01 60 A0 E1 03 38 A0 E1 8E E0 8C E0 23 18 A0 E1 06 20 A0 E1 00 30 A0 E1 05 00 A0 E1 00 50 8D E8 ?? ?? ?? ?? 00 50 65 E0 C5 50 A0 E1 00 50 84 E5 08 D0 8D E2 70 80 BD E8 }
	condition:
		$1
}

rule file_17_113_3 {
	meta:
		name = "_ZNKSt21__ctype_abstract_baseIwE5widenEc"
		size = 28
	strings:
		$1 = { 01 1C A0 E1 04 E0 2D E5 41 1C A0 E1 00 30 90 E5 0F E0 A0 E1 28 F0 93 E5 04 F0 9D E4 }
	condition:
		$1
}

rule file_17_114_3 {
	meta:
		name = "_GLOBAL__I_wlocale_inst.cc"
		size = 500
		refs = "01c4 _ZGVNSt10moneypunctIwLb0EE2idE 01c8 _ZGVNSt10moneypunctIwLb1EE2idE 01cc _ZGVNSt9money_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE2idE 01d0 _ZGVNSt9money_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE2idE 01d4 _ZGVNSt8numpunctIwE2idE 01d8 _ZGVNSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE2idE 01dc _ZGVNSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE2idE 01e0 _ZGVNSt11__timepunctIwE2idE 01e4 _ZGVNSt8time_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE2idE 01e8 _ZGVNSt8time_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE2idE 01ec _ZGVNSt8messagesIwE2idE 01f0 _ZGVNSt7collateIwE2idE"
	strings:
		$1 = { F0 0F 2D E9 B8 91 9F E5 01 30 A0 E3 00 40 A0 E3 03 00 99 E8 AC A1 9F E5 03 00 90 E0 58 D0 4D E2 04 10 A1 E0 03 00 8D E8 06 00 9A E8 98 81 9F E5 03 10 91 E0 04 20 A2 E0 08 10 8D E5 0C 20 8D E5 03 00 98 E8 84 71 9F E5 03 00 90 E0 04 10 A1 E0 10 00 8D E5 14 10 8D E5 06 00 97 E8 70 61 9F E5 03 10 91 E0 04 20 A2 E0 18 10 8D E5 1C 20 8D E5 03 00 96 E8 5C 51 9F E5 03 00 90 E0 04 10 A1 E0 20 00 8D E5 24 10 8D E5 06 00 95 E8 48 C1 9F E5 03 10 91 E0 04 20 A2 E0 28 10 8D E5 2C 20 8D E5 03 00 9C E8 34 21 9F E5 03 00 90 E0 04 10 A1 E0 30 00 8D E5 34 10 8D E5 06 00 92 E8 20 B1 9F E5 03 10 91 E0 04 20 A2 E0 38 10 8D E5 3C 20 8D E5 03 00 9B E8 0C 21 9F E5 03 00 90 E0 04 10 A1 E0 40 00 8D E5 44 10 8D E5 06 00 92 E8 03 10 91 E0 04 20 A2 E0 48 10 8D E5 4C 20 8D E5 E8 10 9F E5 03 00 91 E8 03 00 90 E0 04 10 A1 E0 50 00 8D E5 54 10 8D E5 D4 00 9F E5 06 00 90 E8 BC 00 9F E5 03 10 91 E0 04 20 A2 E0 18 00 9D E8 18 00 89 E8 08 40 8D E2 18 00 94 E8 18 00 8A E8 10 40 8D E2 18 00 94 E8 18 00 88 E8 18 40 8D E2 18 00 94 E8 18 00 87 E8 20 40 8D E2 18 00 94 E8 18 00 86 E8 28 40 8D E2 18 00 94 E8 18 00 85 E8 30 40 8D E2 18 00 94 E8 18 00 8C E8 38 40 8D E2 18 00 94 E8 18 00 80 E8 40 40 8D E2 18 00 94 E8 54 00 9F E5 18 00 8B E8 48 40 8D E2 18 00 94 E8 18 00 80 E8 50 40 8D E2 18 00 94 E8 3C 00 9F E5 18 00 80 E8 38 30 9F E5 06 00 83 E8 58 D0 8D E2 F0 0F BD E8 0E F0 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_113_3 {
	meta:
		name = "_GLOBAL__I_locale_inst.cc"
		size = 500
		refs = "01c4 _ZGVNSt10moneypunctIcLb0EE2idE 01c8 _ZGVNSt10moneypunctIcLb1EE2idE 01cc _ZGVNSt9money_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE2idE 01d0 _ZGVNSt9money_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE2idE 01d4 _ZGVNSt8numpunctIcE2idE 01d8 _ZGVNSt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE2idE 01dc _ZGVNSt7num_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE2idE 01e0 _ZGVNSt11__timepunctIcE2idE 01e4 _ZGVNSt8time_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE2idE 01e8 _ZGVNSt8time_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE2idE 01ec _ZGVNSt8messagesIcE2idE 01f0 _ZGVNSt7collateIcE2idE"
	strings:
		$1 = { F0 0F 2D E9 B8 91 9F E5 01 30 A0 E3 00 40 A0 E3 03 00 99 E8 AC A1 9F E5 03 00 90 E0 58 D0 4D E2 04 10 A1 E0 03 00 8D E8 06 00 9A E8 98 81 9F E5 03 10 91 E0 04 20 A2 E0 08 10 8D E5 0C 20 8D E5 03 00 98 E8 84 71 9F E5 03 00 90 E0 04 10 A1 E0 10 00 8D E5 14 10 8D E5 06 00 97 E8 70 61 9F E5 03 10 91 E0 04 20 A2 E0 18 10 8D E5 1C 20 8D E5 03 00 96 E8 5C 51 9F E5 03 00 90 E0 04 10 A1 E0 20 00 8D E5 24 10 8D E5 06 00 95 E8 48 C1 9F E5 03 10 91 E0 04 20 A2 E0 28 10 8D E5 2C 20 8D E5 03 00 9C E8 34 21 9F E5 03 00 90 E0 04 10 A1 E0 30 00 8D E5 34 10 8D E5 06 00 92 E8 20 B1 9F E5 03 10 91 E0 04 20 A2 E0 38 10 8D E5 3C 20 8D E5 03 00 9B E8 0C 21 9F E5 03 00 90 E0 04 10 A1 E0 40 00 8D E5 44 10 8D E5 06 00 92 E8 03 10 91 E0 04 20 A2 E0 48 10 8D E5 4C 20 8D E5 E8 10 9F E5 03 00 91 E8 03 00 90 E0 04 10 A1 E0 50 00 8D E5 54 10 8D E5 D4 00 9F E5 06 00 90 E8 BC 00 9F E5 03 10 91 E0 04 20 A2 E0 18 00 9D E8 18 00 89 E8 08 40 8D E2 18 00 94 E8 18 00 8A E8 10 40 8D E2 18 00 94 E8 18 00 88 E8 18 40 8D E2 18 00 94 E8 18 00 87 E8 20 40 8D E2 18 00 94 E8 18 00 86 E8 28 40 8D E2 18 00 94 E8 18 00 85 E8 30 40 8D E2 18 00 94 E8 18 00 8C E8 38 40 8D E2 18 00 94 E8 18 00 80 E8 40 40 8D E2 18 00 94 E8 54 00 9F E5 18 00 8B E8 48 40 8D E2 18 00 94 E8 18 00 80 E8 50 40 8D E2 18 00 94 E8 3C 00 9F E5 18 00 80 E8 38 30 9F E5 06 00 83 E8 58 D0 8D E2 F0 0F BD E8 0E F0 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_121_3 {
	meta:
		name = "_ZNSt17__timepunct_cacheIwED1Ev"
		size = 24
		refs = "000c _ZNSt6locale5facetD2Ev 0014 _ZTVSt17__timepunct_cacheIwE"
		altNames = "_ZNSt17__timepunct_cacheIwED2Ev"
	strings:
		$1 = { 0C 30 9F E5 04 E0 2D E5 00 30 80 E5 ?? ?? ?? ?? 04 F0 9D E4 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_120_3 {
	meta:
		name = "_ZNSt17__timepunct_cacheIcED1Ev"
		size = 24
		refs = "000c _ZNSt6locale5facetD2Ev 0014 _ZTVSt17__timepunct_cacheIcE"
	strings:
		$1 = { 0C 30 9F E5 04 E0 2D E5 00 30 80 E5 ?? ?? ?? ?? 04 F0 9D E4 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_121_3 {
	meta:
		name = "_ZNSt17__timepunct_cacheIcED2Ev"
		size = 24
		refs = "000c _ZNSt6locale5facetD2Ev 0014 _ZTVSt17__timepunct_cacheIcE"
	strings:
		$1 = { 0C 30 9F E5 04 E0 2D E5 00 30 80 E5 ?? ?? ?? ?? 04 F0 9D E4 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_140_3 {
	meta:
		name = "_ZSt13__int_to_charIwyEiPT_T0_PKS0_St13_Ios_Fmtflagsb"
		size = 236
		refs = "0038 __umoddi3 0058 __udivdi3"
	strings:
		$1 = { F0 41 2D E9 1C C0 DD E5 03 70 A0 E1 00 00 5C E3 00 80 A0 E1 01 40 A0 E1 02 50 A0 E1 18 30 9D E5 14 00 00 0A 00 60 A0 E1 04 00 A0 E1 05 10 A0 E1 0A 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 80 00 87 E0 B8 00 D0 E1 05 10 A0 E1 B2 00 66 E1 0A 20 A0 E3 04 00 A0 E1 00 30 A0 E3 ?? ?? ?? ?? 00 40 A0 E1 01 50 A0 E1 05 10 94 E1 EE FF FF 1A 08 60 66 E0 C6 00 A0 E1 F0 81 BD E8 4A 20 03 E2 40 00 52 E3 0E 00 00 0A 01 09 13 E3 14 30 A0 13 04 30 A0 03 00 60 A0 E1 0F 20 04 E2 03 20 82 E0 24 12 A0 E1 82 20 A0 E1 05 4E 81 E1 B2 20 97 E1 25 52 A0 E1 05 10 94 E1 B2 20 66 E1 F5 FF FF 1A EA FF FF EA 00 60 A0 E1 07 30 04 E2 A4 21 A0 E1 83 30 87 E0 85 4E 82 E1 B8 30 D3 E1 A5 51 A0 E1 05 20 94 E1 B2 30 66 E1 F6 FF FF 1A DF FF FF EA }
	condition:
		$1
}

rule file_17_141_3 {
	meta:
		name = "_ZSt13__int_to_charIwmEiPT_T0_PKS0_St13_Ios_Fmtflagsb"
		size = 172
	strings:
		$1 = { 30 00 2D E9 08 C0 DD E5 00 00 5C E3 0E 00 00 0A 90 50 9F E5 00 C0 A0 E1 95 41 83 E0 A3 31 A0 E1 03 41 83 E0 84 10 41 E0 81 40 82 E0 B8 40 D4 E1 00 10 53 E2 B2 40 6C E1 F6 FF FF 1A 00 00 6C E0 C0 00 A0 E1 30 00 BD E8 0E F0 A0 E1 4A C0 03 E2 40 00 5C E3 0B 00 00 0A 01 09 13 E3 14 30 A0 13 04 30 A0 03 00 C0 A0 E1 0F 40 01 E2 03 40 84 E0 84 40 A0 E1 B4 40 92 E1 21 12 B0 E1 B2 40 6C E1 F8 FF FF 1A EC FF FF EA 00 C0 A0 E1 07 30 01 E2 83 30 82 E0 B8 30 D3 E1 A1 11 B0 E1 B2 30 6C E1 F9 FF FF 1A E4 FF FF EA CD CC CC CC }
	condition:
		$1
}

rule file_17_142_3 {
	meta:
		name = "_ZNSt19istreambuf_iteratorIwSt11char_traitsIwEEppEv"
		size = 80
	strings:
		$1 = { 00 30 90 E5 10 40 2D E9 00 00 53 E3 00 40 A0 E1 07 00 00 0A 08 20 93 E5 0C 10 93 E5 01 00 52 E1 02 20 82 32 08 20 83 35 03 00 00 2A 00 30 E0 E3 B4 30 C4 E1 04 00 A0 E1 10 80 BD E8 03 00 A0 E1 00 30 93 E5 0F E0 A0 E1 28 F0 93 E5 F6 FF FF EA }
	condition:
		$1
}

rule file_17_143_3 {
	meta:
		name = "_ZSt7__writeIwESt19ostreambuf_iteratorIT_St11char_traitsIS1_EES4_PKS1_i"
		size = 96
		altNames = "_ZSt7__writeIcESt19ostreambuf_iteratorIT_St11char_traitsIS1_EES4_PKS1_i"
	strings:
		$1 = { 70 40 2D E9 08 D0 4D E2 0D C0 A0 E1 06 00 8C E8 04 20 DD E5 00 40 A0 E1 00 00 52 E3 18 60 9D E5 01 50 A0 E1 02 00 A0 11 07 00 00 1A 03 10 A0 E1 05 00 A0 E1 00 30 95 E5 06 20 A0 E1 0F E0 A0 E1 30 F0 93 E5 00 00 56 E0 01 00 A0 13 04 00 C4 E5 00 50 84 E5 04 00 A0 E1 08 D0 8D E2 70 80 BD E8 }
	condition:
		$1
}

rule file_17_144_3 {
	meta:
		name = "_ZNKSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE14_M_group_floatEPKcjwPKwPwS9_Ri"
		size = 160
		refs = "0048 _ZSt14__add_groupingIwEPT_S1_S0_PKcjPKS0_S5_ 005c wmemcpy"
	strings:
		$1 = { F0 40 2D E9 08 D0 4D E2 1C 50 9D E5 03 C8 A0 E1 00 00 55 E3 01 00 A0 E1 02 30 A0 E1 2C 18 A0 E1 20 70 9D E5 24 C0 9D E5 28 40 9D E5 12 00 00 0A 05 60 6C E0 C6 60 A0 E1 86 E0 8C E0 00 20 A0 E1 07 00 A0 E1 00 50 8D E8 ?? ?? ?? ?? 00 20 94 E5 05 10 A0 E1 02 20 66 E0 00 70 67 E0 ?? ?? ?? ?? 00 30 94 E5 C7 70 A0 E1 03 60 66 E0 07 70 86 E0 00 70 84 E5 08 D0 8D E2 F0 80 BD E8 00 E0 94 E5 00 20 A0 E1 8E E0 8C E0 07 00 A0 E1 00 50 8D E8 ?? ?? ?? ?? 00 70 67 E0 C7 70 A0 E1 F3 FF FF EA }
	condition:
		$1
}

rule file_17_145_3 {
	meta:
		name = "_ZSt9has_facetISt8messagesIwEEbRKSt6locale"
		size = 232
		refs = "0038 _Unwind_SjLj_Register 0048 _ZNKSt6locale2id5_M_idEv 007c __dynamic_cast 009c _Unwind_SjLj_Unregister 00c4 _Unwind_SjLj_Resume 00cc __cxa_call_unexpected 00d0 __gxx_personality_sj0 00d4 .gcc_except_table 00d8 .text$_ZSt9has_facetISt8messagesIwEEbRKSt6locale 00dc _ZNSt8messagesIwE2idE 00e0 _ZTINSt6locale5facetE 00e4 _ZTISt8messagesIwE"
	strings:
		$1 = { 00 48 2D E9 C4 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 B8 30 9F E5 3C 00 0B E5 1C 30 0B E5 B0 30 9F E5 04 20 4B E2 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 01 30 A0 E3 94 00 9F E5 34 30 0B E5 ?? ?? ?? ?? 3C 20 1B E5 00 30 92 E5 08 20 93 E5 04 30 93 E5 02 00 50 E1 0A 00 00 2A 00 01 93 E7 00 00 50 E3 07 00 00 0A 68 10 9F E5 68 20 9F E5 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E2 01 00 A0 13 3C 00 0B E5 01 00 00 EA 00 30 A0 E3 3C 30 0B E5 38 00 4B E2 ?? ?? ?? ?? 3C 00 1B E5 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 2C 30 1B E5 30 00 1B E5 01 00 73 E3 00 30 E0 13 34 30 0B 15 ?? ?? ?? ?? 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_152_3 {
	meta:
		name = "_ZSt9has_facetISt10moneypunctIcLb0EEEbRKSt6locale"
		size = 232
		refs = "0038 _Unwind_SjLj_Register 0048 _ZNKSt6locale2id5_M_idEv 007c __dynamic_cast 009c _Unwind_SjLj_Unregister 00c4 _Unwind_SjLj_Resume 00cc __cxa_call_unexpected 00d0 __gxx_personality_sj0 00d4 .gcc_except_table 00d8 .text$_ZSt9has_facetISt10moneypunctIcLb0EEEbRKSt6locale 00dc _ZNSt10moneypunctIcLb0EE2idE 00e0 _ZTINSt6locale5facetE 00e4 _ZTISt10moneypunctIcLb0EE"
	strings:
		$1 = { 00 48 2D E9 C4 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 B8 30 9F E5 3C 00 0B E5 1C 30 0B E5 B0 30 9F E5 04 20 4B E2 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 01 30 A0 E3 94 00 9F E5 34 30 0B E5 ?? ?? ?? ?? 3C 20 1B E5 00 30 92 E5 08 20 93 E5 04 30 93 E5 02 00 50 E1 0A 00 00 2A 00 01 93 E7 00 00 50 E3 07 00 00 0A 68 10 9F E5 68 20 9F E5 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E2 01 00 A0 13 3C 00 0B E5 01 00 00 EA 00 30 A0 E3 3C 30 0B E5 38 00 4B E2 ?? ?? ?? ?? 3C 00 1B E5 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 2C 30 1B E5 30 00 1B E5 01 00 73 E3 00 30 E0 13 34 30 0B 15 ?? ?? ?? ?? 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_151_3 {
	meta:
		name = "_ZSt9has_facetISt10moneypunctIwLb0EEEbRKSt6locale"
		size = 232
		refs = "0038 _Unwind_SjLj_Register 0048 _ZNKSt6locale2id5_M_idEv 007c __dynamic_cast 009c _Unwind_SjLj_Unregister 00c4 _Unwind_SjLj_Resume 00cc __cxa_call_unexpected 00d0 __gxx_personality_sj0 00d4 .gcc_except_table 00d8 .text$_ZSt9has_facetISt10moneypunctIwLb0EEEbRKSt6locale 00dc _ZNSt10moneypunctIwLb0EE2idE 00e0 _ZTINSt6locale5facetE 00e4 _ZTISt10moneypunctIwLb0EE"
	strings:
		$1 = { 00 48 2D E9 C4 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 B8 30 9F E5 3C 00 0B E5 1C 30 0B E5 B0 30 9F E5 04 20 4B E2 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 01 30 A0 E3 94 00 9F E5 34 30 0B E5 ?? ?? ?? ?? 3C 20 1B E5 00 30 92 E5 08 20 93 E5 04 30 93 E5 02 00 50 E1 0A 00 00 2A 00 01 93 E7 00 00 50 E3 07 00 00 0A 68 10 9F E5 68 20 9F E5 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E2 01 00 A0 13 3C 00 0B E5 01 00 00 EA 00 30 A0 E3 3C 30 0B E5 38 00 4B E2 ?? ?? ?? ?? 3C 00 1B E5 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 2C 30 1B E5 30 00 1B E5 01 00 73 E3 00 30 E0 13 34 30 0B 15 ?? ?? ?? ?? 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_149_3 {
	meta:
		name = "_ZSt9has_facetISt11__timepunctIcEEbRKSt6locale"
		size = 232
		refs = "0038 _Unwind_SjLj_Register 0048 _ZNKSt6locale2id5_M_idEv 007c __dynamic_cast 009c _Unwind_SjLj_Unregister 00c4 _Unwind_SjLj_Resume 00cc __cxa_call_unexpected 00d0 __gxx_personality_sj0 00d4 .gcc_except_table 00d8 .text$_ZSt9has_facetISt11__timepunctIcEEbRKSt6locale 00dc _ZNSt11__timepunctIcE2idE 00e0 _ZTINSt6locale5facetE 00e4 _ZTISt11__timepunctIcE"
	strings:
		$1 = { 00 48 2D E9 C4 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 B8 30 9F E5 3C 00 0B E5 1C 30 0B E5 B0 30 9F E5 04 20 4B E2 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 01 30 A0 E3 94 00 9F E5 34 30 0B E5 ?? ?? ?? ?? 3C 20 1B E5 00 30 92 E5 08 20 93 E5 04 30 93 E5 02 00 50 E1 0A 00 00 2A 00 01 93 E7 00 00 50 E3 07 00 00 0A 68 10 9F E5 68 20 9F E5 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E2 01 00 A0 13 3C 00 0B E5 01 00 00 EA 00 30 A0 E3 3C 30 0B E5 38 00 4B E2 ?? ?? ?? ?? 3C 00 1B E5 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 2C 30 1B E5 30 00 1B E5 01 00 73 E3 00 30 E0 13 34 30 0B 15 ?? ?? ?? ?? 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_148_3 {
	meta:
		name = "_ZSt9has_facetISt11__timepunctIwEEbRKSt6locale"
		size = 232
		refs = "0038 _Unwind_SjLj_Register 0048 _ZNKSt6locale2id5_M_idEv 007c __dynamic_cast 009c _Unwind_SjLj_Unregister 00c4 _Unwind_SjLj_Resume 00cc __cxa_call_unexpected 00d0 __gxx_personality_sj0 00d4 .gcc_except_table 00d8 .text$_ZSt9has_facetISt11__timepunctIwEEbRKSt6locale 00dc _ZNSt11__timepunctIwE2idE 00e0 _ZTINSt6locale5facetE 00e4 _ZTISt11__timepunctIwE"
	strings:
		$1 = { 00 48 2D E9 C4 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 B8 30 9F E5 3C 00 0B E5 1C 30 0B E5 B0 30 9F E5 04 20 4B E2 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 01 30 A0 E3 94 00 9F E5 34 30 0B E5 ?? ?? ?? ?? 3C 20 1B E5 00 30 92 E5 08 20 93 E5 04 30 93 E5 02 00 50 E1 0A 00 00 2A 00 01 93 E7 00 00 50 E3 07 00 00 0A 68 10 9F E5 68 20 9F E5 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E2 01 00 A0 13 3C 00 0B E5 01 00 00 EA 00 30 A0 E3 3C 30 0B E5 38 00 4B E2 ?? ?? ?? ?? 3C 00 1B E5 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 2C 30 1B E5 30 00 1B E5 01 00 73 E3 00 30 E0 13 34 30 0B 15 ?? ?? ?? ?? 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_158_3 {
	meta:
		name = "_ZSt9has_facetISt5ctypeIcEEbRKSt6locale"
		size = 232
		refs = "0038 _Unwind_SjLj_Register 0048 _ZNKSt6locale2id5_M_idEv 007c __dynamic_cast 009c _Unwind_SjLj_Unregister 00c4 _Unwind_SjLj_Resume 00cc __cxa_call_unexpected 00d0 __gxx_personality_sj0 00d4 .gcc_except_table 00d8 .text$_ZSt9has_facetISt5ctypeIcEEbRKSt6locale 00dc _ZNSt5ctypeIcE2idE 00e0 _ZTINSt6locale5facetE 00e4 _ZTISt5ctypeIcE"
	strings:
		$1 = { 00 48 2D E9 C4 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 B8 30 9F E5 3C 00 0B E5 1C 30 0B E5 B0 30 9F E5 04 20 4B E2 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 01 30 A0 E3 94 00 9F E5 34 30 0B E5 ?? ?? ?? ?? 3C 20 1B E5 00 30 92 E5 08 20 93 E5 04 30 93 E5 02 00 50 E1 0A 00 00 2A 00 01 93 E7 00 00 50 E3 07 00 00 0A 68 10 9F E5 68 20 9F E5 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E2 01 00 A0 13 3C 00 0B E5 01 00 00 EA 00 30 A0 E3 3C 30 0B E5 38 00 4B E2 ?? ?? ?? ?? 3C 00 1B E5 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 2C 30 1B E5 30 00 1B E5 01 00 73 E3 00 30 E0 13 34 30 0B 15 ?? ?? ?? ?? 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_157_3 {
	meta:
		name = "_ZSt9has_facetISt5ctypeIwEEbRKSt6locale"
		size = 232
		refs = "0038 _Unwind_SjLj_Register 0048 _ZNKSt6locale2id5_M_idEv 007c __dynamic_cast 009c _Unwind_SjLj_Unregister 00c4 _Unwind_SjLj_Resume 00cc __cxa_call_unexpected 00d0 __gxx_personality_sj0 00d4 .gcc_except_table 00d8 .text$_ZSt9has_facetISt5ctypeIwEEbRKSt6locale 00dc _ZNSt5ctypeIwE2idE 00e0 _ZTINSt6locale5facetE 00e4 _ZTISt5ctypeIwE"
	strings:
		$1 = { 00 48 2D E9 C4 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 B8 30 9F E5 3C 00 0B E5 1C 30 0B E5 B0 30 9F E5 04 20 4B E2 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 01 30 A0 E3 94 00 9F E5 34 30 0B E5 ?? ?? ?? ?? 3C 20 1B E5 00 30 92 E5 08 20 93 E5 04 30 93 E5 02 00 50 E1 0A 00 00 2A 00 01 93 E7 00 00 50 E3 07 00 00 0A 68 10 9F E5 68 20 9F E5 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E2 01 00 A0 13 3C 00 0B E5 01 00 00 EA 00 30 A0 E3 3C 30 0B E5 38 00 4B E2 ?? ?? ?? ?? 3C 00 1B E5 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 2C 30 1B E5 30 00 1B E5 01 00 73 E3 00 30 E0 13 34 30 0B 15 ?? ?? ?? ?? 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_157_3 {
	meta:
		name = "_ZSt9has_facetISt7codecvtIcciEEbRKSt6locale"
		size = 232
		refs = "0038 _Unwind_SjLj_Register 0048 _ZNKSt6locale2id5_M_idEv 007c __dynamic_cast 009c _Unwind_SjLj_Unregister 00c4 _Unwind_SjLj_Resume 00cc __cxa_call_unexpected 00d0 __gxx_personality_sj0 00d4 .gcc_except_table 00d8 .text$_ZSt9has_facetISt7codecvtIcciEEbRKSt6locale 00dc _ZNSt7codecvtIcciE2idE 00e0 _ZTINSt6locale5facetE 00e4 _ZTISt7codecvtIcciE"
	strings:
		$1 = { 00 48 2D E9 C4 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 B8 30 9F E5 3C 00 0B E5 1C 30 0B E5 B0 30 9F E5 04 20 4B E2 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 01 30 A0 E3 94 00 9F E5 34 30 0B E5 ?? ?? ?? ?? 3C 20 1B E5 00 30 92 E5 08 20 93 E5 04 30 93 E5 02 00 50 E1 0A 00 00 2A 00 01 93 E7 00 00 50 E3 07 00 00 0A 68 10 9F E5 68 20 9F E5 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E2 01 00 A0 13 3C 00 0B E5 01 00 00 EA 00 30 A0 E3 3C 30 0B E5 38 00 4B E2 ?? ?? ?? ?? 3C 00 1B E5 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 2C 30 1B E5 30 00 1B E5 01 00 73 E3 00 30 E0 13 34 30 0B 15 ?? ?? ?? ?? 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_156_3 {
	meta:
		name = "_ZSt9has_facetISt7codecvtIwciEEbRKSt6locale"
		size = 232
		refs = "0038 _Unwind_SjLj_Register 0048 _ZNKSt6locale2id5_M_idEv 007c __dynamic_cast 009c _Unwind_SjLj_Unregister 00c4 _Unwind_SjLj_Resume 00cc __cxa_call_unexpected 00d0 __gxx_personality_sj0 00d4 .gcc_except_table 00d8 .text$_ZSt9has_facetISt7codecvtIwciEEbRKSt6locale 00dc _ZNSt7codecvtIwciE2idE 00e0 _ZTINSt6locale5facetE 00e4 _ZTISt7codecvtIwciE"
	strings:
		$1 = { 00 48 2D E9 C4 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 B8 30 9F E5 3C 00 0B E5 1C 30 0B E5 B0 30 9F E5 04 20 4B E2 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 01 30 A0 E3 94 00 9F E5 34 30 0B E5 ?? ?? ?? ?? 3C 20 1B E5 00 30 92 E5 08 20 93 E5 04 30 93 E5 02 00 50 E1 0A 00 00 2A 00 01 93 E7 00 00 50 E3 07 00 00 0A 68 10 9F E5 68 20 9F E5 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E2 01 00 A0 13 3C 00 0B E5 01 00 00 EA 00 30 A0 E3 3C 30 0B E5 38 00 4B E2 ?? ?? ?? ?? 3C 00 1B E5 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 2C 30 1B E5 30 00 1B E5 01 00 73 E3 00 30 E0 13 34 30 0B 15 ?? ?? ?? ?? 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_156_3 {
	meta:
		name = "_ZSt9has_facetISt7collateIcEEbRKSt6locale"
		size = 232
		refs = "0038 _Unwind_SjLj_Register 0048 _ZNKSt6locale2id5_M_idEv 007c __dynamic_cast 009c _Unwind_SjLj_Unregister 00c4 _Unwind_SjLj_Resume 00cc __cxa_call_unexpected 00d0 __gxx_personality_sj0 00d4 .gcc_except_table 00d8 .text$_ZSt9has_facetISt7collateIcEEbRKSt6locale 00dc _ZNSt7collateIcE2idE 00e0 _ZTINSt6locale5facetE 00e4 _ZTISt7collateIcE"
	strings:
		$1 = { 00 48 2D E9 C4 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 B8 30 9F E5 3C 00 0B E5 1C 30 0B E5 B0 30 9F E5 04 20 4B E2 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 01 30 A0 E3 94 00 9F E5 34 30 0B E5 ?? ?? ?? ?? 3C 20 1B E5 00 30 92 E5 08 20 93 E5 04 30 93 E5 02 00 50 E1 0A 00 00 2A 00 01 93 E7 00 00 50 E3 07 00 00 0A 68 10 9F E5 68 20 9F E5 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E2 01 00 A0 13 3C 00 0B E5 01 00 00 EA 00 30 A0 E3 3C 30 0B E5 38 00 4B E2 ?? ?? ?? ?? 3C 00 1B E5 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 2C 30 1B E5 30 00 1B E5 01 00 73 E3 00 30 E0 13 34 30 0B 15 ?? ?? ?? ?? 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_155_3 {
	meta:
		name = "_ZSt9has_facetISt7collateIwEEbRKSt6locale"
		size = 232
		refs = "0038 _Unwind_SjLj_Register 0048 _ZNKSt6locale2id5_M_idEv 007c __dynamic_cast 009c _Unwind_SjLj_Unregister 00c4 _Unwind_SjLj_Resume 00cc __cxa_call_unexpected 00d0 __gxx_personality_sj0 00d4 .gcc_except_table 00d8 .text$_ZSt9has_facetISt7collateIwEEbRKSt6locale 00dc _ZNSt7collateIwE2idE 00e0 _ZTINSt6locale5facetE 00e4 _ZTISt7collateIwE"
	strings:
		$1 = { 00 48 2D E9 C4 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 B8 30 9F E5 3C 00 0B E5 1C 30 0B E5 B0 30 9F E5 04 20 4B E2 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 01 30 A0 E3 94 00 9F E5 34 30 0B E5 ?? ?? ?? ?? 3C 20 1B E5 00 30 92 E5 08 20 93 E5 04 30 93 E5 02 00 50 E1 0A 00 00 2A 00 01 93 E7 00 00 50 E3 07 00 00 0A 68 10 9F E5 68 20 9F E5 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E2 01 00 A0 13 3C 00 0B E5 01 00 00 EA 00 30 A0 E3 3C 30 0B E5 38 00 4B E2 ?? ?? ?? ?? 3C 00 1B E5 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 2C 30 1B E5 30 00 1B E5 01 00 73 E3 00 30 E0 13 34 30 0B 15 ?? ?? ?? ?? 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_153_3 {
	meta:
		name = "_ZSt9has_facetISt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEEEbRKSt6locale"
		size = 232
		refs = "0038 _Unwind_SjLj_Register 0048 _ZNKSt6locale2id5_M_idEv 007c __dynamic_cast 009c _Unwind_SjLj_Unregister 00c4 _Unwind_SjLj_Resume 00cc __cxa_call_unexpected 00d0 __gxx_personality_sj0 00d4 .gcc_except_table 00d8 .text$_ZSt9has_facetISt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEEEbRKSt6locale 00dc _ZNSt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE2idE 00e0 _ZTINSt6locale5facetE 00e4 _ZTISt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 00 48 2D E9 C4 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 B8 30 9F E5 3C 00 0B E5 1C 30 0B E5 B0 30 9F E5 04 20 4B E2 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 01 30 A0 E3 94 00 9F E5 34 30 0B E5 ?? ?? ?? ?? 3C 20 1B E5 00 30 92 E5 08 20 93 E5 04 30 93 E5 02 00 50 E1 0A 00 00 2A 00 01 93 E7 00 00 50 E3 07 00 00 0A 68 10 9F E5 68 20 9F E5 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E2 01 00 A0 13 3C 00 0B E5 01 00 00 EA 00 30 A0 E3 3C 30 0B E5 38 00 4B E2 ?? ?? ?? ?? 3C 00 1B E5 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 2C 30 1B E5 30 00 1B E5 01 00 73 E3 00 30 E0 13 34 30 0B 15 ?? ?? ?? ?? 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_152_3 {
	meta:
		name = "_ZSt9has_facetISt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEEEbRKSt6locale"
		size = 232
		refs = "0038 _Unwind_SjLj_Register 0048 _ZNKSt6locale2id5_M_idEv 007c __dynamic_cast 009c _Unwind_SjLj_Unregister 00c4 _Unwind_SjLj_Resume 00cc __cxa_call_unexpected 00d0 __gxx_personality_sj0 00d4 .gcc_except_table 00d8 .text$_ZSt9has_facetISt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEEEbRKSt6locale 00dc _ZNSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE2idE 00e0 _ZTINSt6locale5facetE 00e4 _ZTISt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE"
	strings:
		$1 = { 00 48 2D E9 C4 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 B8 30 9F E5 3C 00 0B E5 1C 30 0B E5 B0 30 9F E5 04 20 4B E2 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 01 30 A0 E3 94 00 9F E5 34 30 0B E5 ?? ?? ?? ?? 3C 20 1B E5 00 30 92 E5 08 20 93 E5 04 30 93 E5 02 00 50 E1 0A 00 00 2A 00 01 93 E7 00 00 50 E3 07 00 00 0A 68 10 9F E5 68 20 9F E5 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E2 01 00 A0 13 3C 00 0B E5 01 00 00 EA 00 30 A0 E3 3C 30 0B E5 38 00 4B E2 ?? ?? ?? ?? 3C 00 1B E5 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 2C 30 1B E5 30 00 1B E5 01 00 73 E3 00 30 E0 13 34 30 0B 15 ?? ?? ?? ?? 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_154_3 {
	meta:
		name = "_ZSt9has_facetISt7num_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEEEbRKSt6locale"
		size = 232
		refs = "0038 _Unwind_SjLj_Register 0048 _ZNKSt6locale2id5_M_idEv 007c __dynamic_cast 009c _Unwind_SjLj_Unregister 00c4 _Unwind_SjLj_Resume 00cc __cxa_call_unexpected 00d0 __gxx_personality_sj0 00d4 .gcc_except_table 00d8 .text$_ZSt9has_facetISt7num_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEEEbRKSt6locale 00dc _ZNSt7num_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE2idE 00e0 _ZTINSt6locale5facetE 00e4 _ZTISt7num_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 00 48 2D E9 C4 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 B8 30 9F E5 3C 00 0B E5 1C 30 0B E5 B0 30 9F E5 04 20 4B E2 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 01 30 A0 E3 94 00 9F E5 34 30 0B E5 ?? ?? ?? ?? 3C 20 1B E5 00 30 92 E5 08 20 93 E5 04 30 93 E5 02 00 50 E1 0A 00 00 2A 00 01 93 E7 00 00 50 E3 07 00 00 0A 68 10 9F E5 68 20 9F E5 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E2 01 00 A0 13 3C 00 0B E5 01 00 00 EA 00 30 A0 E3 3C 30 0B E5 38 00 4B E2 ?? ?? ?? ?? 3C 00 1B E5 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 2C 30 1B E5 30 00 1B E5 01 00 73 E3 00 30 E0 13 34 30 0B 15 ?? ?? ?? ?? 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_153_3 {
	meta:
		name = "_ZSt9has_facetISt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEEEbRKSt6locale"
		size = 232
		refs = "0038 _Unwind_SjLj_Register 0048 _ZNKSt6locale2id5_M_idEv 007c __dynamic_cast 009c _Unwind_SjLj_Unregister 00c4 _Unwind_SjLj_Resume 00cc __cxa_call_unexpected 00d0 __gxx_personality_sj0 00d4 .gcc_except_table 00d8 .text$_ZSt9has_facetISt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEEEbRKSt6locale 00dc _ZNSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE2idE 00e0 _ZTINSt6locale5facetE 00e4 _ZTISt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE"
	strings:
		$1 = { 00 48 2D E9 C4 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 B8 30 9F E5 3C 00 0B E5 1C 30 0B E5 B0 30 9F E5 04 20 4B E2 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 01 30 A0 E3 94 00 9F E5 34 30 0B E5 ?? ?? ?? ?? 3C 20 1B E5 00 30 92 E5 08 20 93 E5 04 30 93 E5 02 00 50 E1 0A 00 00 2A 00 01 93 E7 00 00 50 E3 07 00 00 0A 68 10 9F E5 68 20 9F E5 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E2 01 00 A0 13 3C 00 0B E5 01 00 00 EA 00 30 A0 E3 3C 30 0B E5 38 00 4B E2 ?? ?? ?? ?? 3C 00 1B E5 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 2C 30 1B E5 30 00 1B E5 01 00 73 E3 00 30 E0 13 34 30 0B 15 ?? ?? ?? ?? 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_146_3 {
	meta:
		name = "_ZSt9has_facetISt8messagesIcEEbRKSt6locale"
		size = 232
		refs = "0038 _Unwind_SjLj_Register 0048 _ZNKSt6locale2id5_M_idEv 007c __dynamic_cast 009c _Unwind_SjLj_Unregister 00c4 _Unwind_SjLj_Resume 00cc __cxa_call_unexpected 00d0 __gxx_personality_sj0 00d4 .gcc_except_table 00d8 .text$_ZSt9has_facetISt8messagesIcEEbRKSt6locale 00dc _ZNSt8messagesIcE2idE 00e0 _ZTINSt6locale5facetE 00e4 _ZTISt8messagesIcE"
	strings:
		$1 = { 00 48 2D E9 C4 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 B8 30 9F E5 3C 00 0B E5 1C 30 0B E5 B0 30 9F E5 04 20 4B E2 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 01 30 A0 E3 94 00 9F E5 34 30 0B E5 ?? ?? ?? ?? 3C 20 1B E5 00 30 92 E5 08 20 93 E5 04 30 93 E5 02 00 50 E1 0A 00 00 2A 00 01 93 E7 00 00 50 E3 07 00 00 0A 68 10 9F E5 68 20 9F E5 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E2 01 00 A0 13 3C 00 0B E5 01 00 00 EA 00 30 A0 E3 3C 30 0B E5 38 00 4B E2 ?? ?? ?? ?? 3C 00 1B E5 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 2C 30 1B E5 30 00 1B E5 01 00 73 E3 00 30 E0 13 34 30 0B 15 ?? ?? ?? ?? 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_155_3 {
	meta:
		name = "_ZSt9has_facetISt8numpunctIcEEbRKSt6locale"
		size = 232
		refs = "0038 _Unwind_SjLj_Register 0048 _ZNKSt6locale2id5_M_idEv 007c __dynamic_cast 009c _Unwind_SjLj_Unregister 00c4 _Unwind_SjLj_Resume 00cc __cxa_call_unexpected 00d0 __gxx_personality_sj0 00d4 .gcc_except_table 00d8 .text$_ZSt9has_facetISt8numpunctIcEEbRKSt6locale 00dc _ZNSt8numpunctIcE2idE 00e0 _ZTINSt6locale5facetE 00e4 _ZTISt8numpunctIcE"
	strings:
		$1 = { 00 48 2D E9 C4 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 B8 30 9F E5 3C 00 0B E5 1C 30 0B E5 B0 30 9F E5 04 20 4B E2 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 01 30 A0 E3 94 00 9F E5 34 30 0B E5 ?? ?? ?? ?? 3C 20 1B E5 00 30 92 E5 08 20 93 E5 04 30 93 E5 02 00 50 E1 0A 00 00 2A 00 01 93 E7 00 00 50 E3 07 00 00 0A 68 10 9F E5 68 20 9F E5 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E2 01 00 A0 13 3C 00 0B E5 01 00 00 EA 00 30 A0 E3 3C 30 0B E5 38 00 4B E2 ?? ?? ?? ?? 3C 00 1B E5 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 2C 30 1B E5 30 00 1B E5 01 00 73 E3 00 30 E0 13 34 30 0B 15 ?? ?? ?? ?? 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_154_3 {
	meta:
		name = "_ZSt9has_facetISt8numpunctIwEEbRKSt6locale"
		size = 232
		refs = "0038 _Unwind_SjLj_Register 0048 _ZNKSt6locale2id5_M_idEv 007c __dynamic_cast 009c _Unwind_SjLj_Unregister 00c4 _Unwind_SjLj_Resume 00cc __cxa_call_unexpected 00d0 __gxx_personality_sj0 00d4 .gcc_except_table 00d8 .text$_ZSt9has_facetISt8numpunctIwEEbRKSt6locale 00dc _ZNSt8numpunctIwE2idE 00e0 _ZTINSt6locale5facetE 00e4 _ZTISt8numpunctIwE"
	strings:
		$1 = { 00 48 2D E9 C4 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 B8 30 9F E5 3C 00 0B E5 1C 30 0B E5 B0 30 9F E5 04 20 4B E2 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 01 30 A0 E3 94 00 9F E5 34 30 0B E5 ?? ?? ?? ?? 3C 20 1B E5 00 30 92 E5 08 20 93 E5 04 30 93 E5 02 00 50 E1 0A 00 00 2A 00 01 93 E7 00 00 50 E3 07 00 00 0A 68 10 9F E5 68 20 9F E5 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E2 01 00 A0 13 3C 00 0B E5 01 00 00 EA 00 30 A0 E3 3C 30 0B E5 38 00 4B E2 ?? ?? ?? ?? 3C 00 1B E5 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 2C 30 1B E5 30 00 1B E5 01 00 73 E3 00 30 E0 13 34 30 0B 15 ?? ?? ?? ?? 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_147_3 {
	meta:
		name = "_ZSt9has_facetISt8time_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEEEbRKSt6locale"
		size = 232
		refs = "0038 _Unwind_SjLj_Register 0048 _ZNKSt6locale2id5_M_idEv 007c __dynamic_cast 009c _Unwind_SjLj_Unregister 00c4 _Unwind_SjLj_Resume 00cc __cxa_call_unexpected 00d0 __gxx_personality_sj0 00d4 .gcc_except_table 00d8 .text$_ZSt9has_facetISt8time_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEEEbRKSt6locale 00dc _ZNSt8time_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE2idE 00e0 _ZTINSt6locale5facetE 00e4 _ZTISt8time_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 00 48 2D E9 C4 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 B8 30 9F E5 3C 00 0B E5 1C 30 0B E5 B0 30 9F E5 04 20 4B E2 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 01 30 A0 E3 94 00 9F E5 34 30 0B E5 ?? ?? ?? ?? 3C 20 1B E5 00 30 92 E5 08 20 93 E5 04 30 93 E5 02 00 50 E1 0A 00 00 2A 00 01 93 E7 00 00 50 E3 07 00 00 0A 68 10 9F E5 68 20 9F E5 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E2 01 00 A0 13 3C 00 0B E5 01 00 00 EA 00 30 A0 E3 3C 30 0B E5 38 00 4B E2 ?? ?? ?? ?? 3C 00 1B E5 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 2C 30 1B E5 30 00 1B E5 01 00 73 E3 00 30 E0 13 34 30 0B 15 ?? ?? ?? ?? 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_146_3 {
	meta:
		name = "_ZSt9has_facetISt8time_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEEEbRKSt6locale"
		size = 232
		refs = "0038 _Unwind_SjLj_Register 0048 _ZNKSt6locale2id5_M_idEv 007c __dynamic_cast 009c _Unwind_SjLj_Unregister 00c4 _Unwind_SjLj_Resume 00cc __cxa_call_unexpected 00d0 __gxx_personality_sj0 00d4 .gcc_except_table 00d8 .text$_ZSt9has_facetISt8time_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEEEbRKSt6locale 00dc _ZNSt8time_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE2idE 00e0 _ZTINSt6locale5facetE 00e4 _ZTISt8time_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE"
	strings:
		$1 = { 00 48 2D E9 C4 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 B8 30 9F E5 3C 00 0B E5 1C 30 0B E5 B0 30 9F E5 04 20 4B E2 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 01 30 A0 E3 94 00 9F E5 34 30 0B E5 ?? ?? ?? ?? 3C 20 1B E5 00 30 92 E5 08 20 93 E5 04 30 93 E5 02 00 50 E1 0A 00 00 2A 00 01 93 E7 00 00 50 E3 07 00 00 0A 68 10 9F E5 68 20 9F E5 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E2 01 00 A0 13 3C 00 0B E5 01 00 00 EA 00 30 A0 E3 3C 30 0B E5 38 00 4B E2 ?? ?? ?? ?? 3C 00 1B E5 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 2C 30 1B E5 30 00 1B E5 01 00 73 E3 00 30 E0 13 34 30 0B 15 ?? ?? ?? ?? 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_148_3 {
	meta:
		name = "_ZSt9has_facetISt8time_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEEEbRKSt6locale"
		size = 232
		refs = "0038 _Unwind_SjLj_Register 0048 _ZNKSt6locale2id5_M_idEv 007c __dynamic_cast 009c _Unwind_SjLj_Unregister 00c4 _Unwind_SjLj_Resume 00cc __cxa_call_unexpected 00d0 __gxx_personality_sj0 00d4 .gcc_except_table 00d8 .text$_ZSt9has_facetISt8time_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEEEbRKSt6locale 00dc _ZNSt8time_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE2idE 00e0 _ZTINSt6locale5facetE 00e4 _ZTISt8time_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 00 48 2D E9 C4 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 B8 30 9F E5 3C 00 0B E5 1C 30 0B E5 B0 30 9F E5 04 20 4B E2 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 01 30 A0 E3 94 00 9F E5 34 30 0B E5 ?? ?? ?? ?? 3C 20 1B E5 00 30 92 E5 08 20 93 E5 04 30 93 E5 02 00 50 E1 0A 00 00 2A 00 01 93 E7 00 00 50 E3 07 00 00 0A 68 10 9F E5 68 20 9F E5 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E2 01 00 A0 13 3C 00 0B E5 01 00 00 EA 00 30 A0 E3 3C 30 0B E5 38 00 4B E2 ?? ?? ?? ?? 3C 00 1B E5 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 2C 30 1B E5 30 00 1B E5 01 00 73 E3 00 30 E0 13 34 30 0B 15 ?? ?? ?? ?? 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_147_3 {
	meta:
		name = "_ZSt9has_facetISt8time_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEEEbRKSt6locale"
		size = 232
		refs = "0038 _Unwind_SjLj_Register 0048 _ZNKSt6locale2id5_M_idEv 007c __dynamic_cast 009c _Unwind_SjLj_Unregister 00c4 _Unwind_SjLj_Resume 00cc __cxa_call_unexpected 00d0 __gxx_personality_sj0 00d4 .gcc_except_table 00d8 .text$_ZSt9has_facetISt8time_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEEEbRKSt6locale 00dc _ZNSt8time_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE2idE 00e0 _ZTINSt6locale5facetE 00e4 _ZTISt8time_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE"
	strings:
		$1 = { 00 48 2D E9 C4 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 B8 30 9F E5 3C 00 0B E5 1C 30 0B E5 B0 30 9F E5 04 20 4B E2 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 01 30 A0 E3 94 00 9F E5 34 30 0B E5 ?? ?? ?? ?? 3C 20 1B E5 00 30 92 E5 08 20 93 E5 04 30 93 E5 02 00 50 E1 0A 00 00 2A 00 01 93 E7 00 00 50 E3 07 00 00 0A 68 10 9F E5 68 20 9F E5 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E2 01 00 A0 13 3C 00 0B E5 01 00 00 EA 00 30 A0 E3 3C 30 0B E5 38 00 4B E2 ?? ?? ?? ?? 3C 00 1B E5 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 2C 30 1B E5 30 00 1B E5 01 00 73 E3 00 30 E0 13 34 30 0B 15 ?? ?? ?? ?? 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_150_3 {
	meta:
		name = "_ZSt9has_facetISt9money_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEEEbRKSt6locale"
		size = 232
		refs = "0038 _Unwind_SjLj_Register 0048 _ZNKSt6locale2id5_M_idEv 007c __dynamic_cast 009c _Unwind_SjLj_Unregister 00c4 _Unwind_SjLj_Resume 00cc __cxa_call_unexpected 00d0 __gxx_personality_sj0 00d4 .gcc_except_table 00d8 .text$_ZSt9has_facetISt9money_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEEEbRKSt6locale 00dc _ZNSt9money_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE2idE 00e0 _ZTINSt6locale5facetE 00e4 _ZTISt9money_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 00 48 2D E9 C4 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 B8 30 9F E5 3C 00 0B E5 1C 30 0B E5 B0 30 9F E5 04 20 4B E2 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 01 30 A0 E3 94 00 9F E5 34 30 0B E5 ?? ?? ?? ?? 3C 20 1B E5 00 30 92 E5 08 20 93 E5 04 30 93 E5 02 00 50 E1 0A 00 00 2A 00 01 93 E7 00 00 50 E3 07 00 00 0A 68 10 9F E5 68 20 9F E5 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E2 01 00 A0 13 3C 00 0B E5 01 00 00 EA 00 30 A0 E3 3C 30 0B E5 38 00 4B E2 ?? ?? ?? ?? 3C 00 1B E5 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 2C 30 1B E5 30 00 1B E5 01 00 73 E3 00 30 E0 13 34 30 0B 15 ?? ?? ?? ?? 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_149_3 {
	meta:
		name = "_ZSt9has_facetISt9money_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEEEbRKSt6locale"
		size = 232
		refs = "0038 _Unwind_SjLj_Register 0048 _ZNKSt6locale2id5_M_idEv 007c __dynamic_cast 009c _Unwind_SjLj_Unregister 00c4 _Unwind_SjLj_Resume 00cc __cxa_call_unexpected 00d0 __gxx_personality_sj0 00d4 .gcc_except_table 00d8 .text$_ZSt9has_facetISt9money_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEEEbRKSt6locale 00dc _ZNSt9money_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE2idE 00e0 _ZTINSt6locale5facetE 00e4 _ZTISt9money_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE"
	strings:
		$1 = { 00 48 2D E9 C4 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 B8 30 9F E5 3C 00 0B E5 1C 30 0B E5 B0 30 9F E5 04 20 4B E2 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 01 30 A0 E3 94 00 9F E5 34 30 0B E5 ?? ?? ?? ?? 3C 20 1B E5 00 30 92 E5 08 20 93 E5 04 30 93 E5 02 00 50 E1 0A 00 00 2A 00 01 93 E7 00 00 50 E3 07 00 00 0A 68 10 9F E5 68 20 9F E5 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E2 01 00 A0 13 3C 00 0B E5 01 00 00 EA 00 30 A0 E3 3C 30 0B E5 38 00 4B E2 ?? ?? ?? ?? 3C 00 1B E5 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 2C 30 1B E5 30 00 1B E5 01 00 73 E3 00 30 E0 13 34 30 0B 15 ?? ?? ?? ?? 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_151_3 {
	meta:
		name = "_ZSt9has_facetISt9money_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEEEbRKSt6locale"
		size = 232
		refs = "0038 _Unwind_SjLj_Register 0048 _ZNKSt6locale2id5_M_idEv 007c __dynamic_cast 009c _Unwind_SjLj_Unregister 00c4 _Unwind_SjLj_Resume 00cc __cxa_call_unexpected 00d0 __gxx_personality_sj0 00d4 .gcc_except_table 00d8 .text$_ZSt9has_facetISt9money_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEEEbRKSt6locale 00dc _ZNSt9money_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE2idE 00e0 _ZTINSt6locale5facetE 00e4 _ZTISt9money_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 00 48 2D E9 C4 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 B8 30 9F E5 3C 00 0B E5 1C 30 0B E5 B0 30 9F E5 04 20 4B E2 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 01 30 A0 E3 94 00 9F E5 34 30 0B E5 ?? ?? ?? ?? 3C 20 1B E5 00 30 92 E5 08 20 93 E5 04 30 93 E5 02 00 50 E1 0A 00 00 2A 00 01 93 E7 00 00 50 E3 07 00 00 0A 68 10 9F E5 68 20 9F E5 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E2 01 00 A0 13 3C 00 0B E5 01 00 00 EA 00 30 A0 E3 3C 30 0B E5 38 00 4B E2 ?? ?? ?? ?? 3C 00 1B E5 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 2C 30 1B E5 30 00 1B E5 01 00 73 E3 00 30 E0 13 34 30 0B 15 ?? ?? ?? ?? 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_150_3 {
	meta:
		name = "_ZSt9has_facetISt9money_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEEEbRKSt6locale"
		size = 232
		refs = "0038 _Unwind_SjLj_Register 0048 _ZNKSt6locale2id5_M_idEv 007c __dynamic_cast 009c _Unwind_SjLj_Unregister 00c4 _Unwind_SjLj_Resume 00cc __cxa_call_unexpected 00d0 __gxx_personality_sj0 00d4 .gcc_except_table 00d8 .text$_ZSt9has_facetISt9money_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEEEbRKSt6locale 00dc _ZNSt9money_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE2idE 00e0 _ZTINSt6locale5facetE 00e4 _ZTISt9money_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE"
	strings:
		$1 = { 00 48 2D E9 C4 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 B8 30 9F E5 3C 00 0B E5 1C 30 0B E5 B0 30 9F E5 04 20 4B E2 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 01 30 A0 E3 94 00 9F E5 34 30 0B E5 ?? ?? ?? ?? 3C 20 1B E5 00 30 92 E5 08 20 93 E5 04 30 93 E5 02 00 50 E1 0A 00 00 2A 00 01 93 E7 00 00 50 E3 07 00 00 0A 68 10 9F E5 68 20 9F E5 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E2 01 00 A0 13 3C 00 0B E5 01 00 00 EA 00 30 A0 E3 3C 30 0B E5 38 00 4B E2 ?? ?? ?? ?? 3C 00 1B E5 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 2C 30 1B E5 30 00 1B E5 01 00 73 E3 00 30 E0 13 34 30 0B 15 ?? ?? ?? ?? 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_158_3 {
	meta:
		name = "_ZSt9use_facetISt8messagesIwEERKT_RKSt6locale"
		size = 92
		refs = "000c _ZNKSt6locale2id5_M_idEv 003c __dynamic_cast 0048 __cxa_bad_cast 004c _ZSt16__throw_bad_castv 0050 _ZNSt8messagesIwE2idE 0054 _ZTINSt6locale5facetE 0058 _ZTISt8messagesIwE"
	strings:
		$1 = { 10 40 2D E9 00 40 A0 E1 40 00 9F E5 ?? ?? ?? ?? 00 30 94 E5 08 20 93 E5 04 30 93 E5 02 00 50 E1 09 00 00 2A 00 01 93 E7 00 00 50 E3 06 00 00 0A 1C 10 9F E5 1C 20 9F E5 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 10 80 BD 18 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_165_3 {
	meta:
		name = "_ZSt9use_facetISt10moneypunctIcLb0EEERKT_RKSt6locale"
		size = 92
		refs = "000c _ZNKSt6locale2id5_M_idEv 003c __dynamic_cast 0048 __cxa_bad_cast 004c _ZSt16__throw_bad_castv 0050 _ZNSt10moneypunctIcLb0EE2idE 0054 _ZTINSt6locale5facetE 0058 _ZTISt10moneypunctIcLb0EE"
	strings:
		$1 = { 10 40 2D E9 00 40 A0 E1 40 00 9F E5 ?? ?? ?? ?? 00 30 94 E5 08 20 93 E5 04 30 93 E5 02 00 50 E1 09 00 00 2A 00 01 93 E7 00 00 50 E3 06 00 00 0A 1C 10 9F E5 1C 20 9F E5 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 10 80 BD 18 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_166_3 {
	meta:
		name = "_ZSt9use_facetISt10moneypunctIcLb1EEERKT_RKSt6locale"
		size = 92
		refs = "000c _ZNKSt6locale2id5_M_idEv 003c __dynamic_cast 0048 __cxa_bad_cast 004c _ZSt16__throw_bad_castv 0050 _ZNSt10moneypunctIcLb1EE2idE 0054 _ZTINSt6locale5facetE 0058 _ZTISt10moneypunctIcLb1EE"
	strings:
		$1 = { 10 40 2D E9 00 40 A0 E1 40 00 9F E5 ?? ?? ?? ?? 00 30 94 E5 08 20 93 E5 04 30 93 E5 02 00 50 E1 09 00 00 2A 00 01 93 E7 00 00 50 E3 06 00 00 0A 1C 10 9F E5 1C 20 9F E5 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 10 80 BD 18 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_164_3 {
	meta:
		name = "_ZSt9use_facetISt10moneypunctIwLb0EEERKT_RKSt6locale"
		size = 92
		refs = "000c _ZNKSt6locale2id5_M_idEv 003c __dynamic_cast 0048 __cxa_bad_cast 004c _ZSt16__throw_bad_castv 0050 _ZNSt10moneypunctIwLb0EE2idE 0054 _ZTINSt6locale5facetE 0058 _ZTISt10moneypunctIwLb0EE"
	strings:
		$1 = { 10 40 2D E9 00 40 A0 E1 40 00 9F E5 ?? ?? ?? ?? 00 30 94 E5 08 20 93 E5 04 30 93 E5 02 00 50 E1 09 00 00 2A 00 01 93 E7 00 00 50 E3 06 00 00 0A 1C 10 9F E5 1C 20 9F E5 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 10 80 BD 18 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_165_3 {
	meta:
		name = "_ZSt9use_facetISt10moneypunctIwLb1EEERKT_RKSt6locale"
		size = 92
		refs = "000c _ZNKSt6locale2id5_M_idEv 003c __dynamic_cast 0048 __cxa_bad_cast 004c _ZSt16__throw_bad_castv 0050 _ZNSt10moneypunctIwLb1EE2idE 0054 _ZTINSt6locale5facetE 0058 _ZTISt10moneypunctIwLb1EE"
	strings:
		$1 = { 10 40 2D E9 00 40 A0 E1 40 00 9F E5 ?? ?? ?? ?? 00 30 94 E5 08 20 93 E5 04 30 93 E5 02 00 50 E1 09 00 00 2A 00 01 93 E7 00 00 50 E3 06 00 00 0A 1C 10 9F E5 1C 20 9F E5 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 10 80 BD 18 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_162_3 {
	meta:
		name = "_ZSt9use_facetISt11__timepunctIcEERKT_RKSt6locale"
		size = 92
		refs = "000c _ZNKSt6locale2id5_M_idEv 003c __dynamic_cast 0048 __cxa_bad_cast 004c _ZSt16__throw_bad_castv 0050 _ZNSt11__timepunctIcE2idE 0054 _ZTINSt6locale5facetE 0058 _ZTISt11__timepunctIcE"
	strings:
		$1 = { 10 40 2D E9 00 40 A0 E1 40 00 9F E5 ?? ?? ?? ?? 00 30 94 E5 08 20 93 E5 04 30 93 E5 02 00 50 E1 09 00 00 2A 00 01 93 E7 00 00 50 E3 06 00 00 0A 1C 10 9F E5 1C 20 9F E5 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 10 80 BD 18 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_161_3 {
	meta:
		name = "_ZSt9use_facetISt11__timepunctIwEERKT_RKSt6locale"
		size = 92
		refs = "000c _ZNKSt6locale2id5_M_idEv 003c __dynamic_cast 0048 __cxa_bad_cast 004c _ZSt16__throw_bad_castv 0050 _ZNSt11__timepunctIwE2idE 0054 _ZTINSt6locale5facetE 0058 _ZTISt11__timepunctIwE"
	strings:
		$1 = { 10 40 2D E9 00 40 A0 E1 40 00 9F E5 ?? ?? ?? ?? 00 30 94 E5 08 20 93 E5 04 30 93 E5 02 00 50 E1 09 00 00 2A 00 01 93 E7 00 00 50 E3 06 00 00 0A 1C 10 9F E5 1C 20 9F E5 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 10 80 BD 18 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_172_3 {
	meta:
		name = "_ZSt9use_facetISt5ctypeIcEERKT_RKSt6locale"
		size = 92
		refs = "000c _ZNKSt6locale2id5_M_idEv 003c __dynamic_cast 0048 __cxa_bad_cast 004c _ZSt16__throw_bad_castv 0050 _ZNSt5ctypeIcE2idE 0054 _ZTINSt6locale5facetE 0058 _ZTISt5ctypeIcE"
	strings:
		$1 = { 10 40 2D E9 00 40 A0 E1 40 00 9F E5 ?? ?? ?? ?? 00 30 94 E5 08 20 93 E5 04 30 93 E5 02 00 50 E1 09 00 00 2A 00 01 93 E7 00 00 50 E3 06 00 00 0A 1C 10 9F E5 1C 20 9F E5 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 10 80 BD 18 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_171_3 {
	meta:
		name = "_ZSt9use_facetISt5ctypeIwEERKT_RKSt6locale"
		size = 92
		refs = "000c _ZNKSt6locale2id5_M_idEv 003c __dynamic_cast 0048 __cxa_bad_cast 004c _ZSt16__throw_bad_castv 0050 _ZNSt5ctypeIwE2idE 0054 _ZTINSt6locale5facetE 0058 _ZTISt5ctypeIwE"
	strings:
		$1 = { 10 40 2D E9 00 40 A0 E1 40 00 9F E5 ?? ?? ?? ?? 00 30 94 E5 08 20 93 E5 04 30 93 E5 02 00 50 E1 09 00 00 2A 00 01 93 E7 00 00 50 E3 06 00 00 0A 1C 10 9F E5 1C 20 9F E5 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 10 80 BD 18 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_171_3 {
	meta:
		name = "_ZSt9use_facetISt7codecvtIcciEERKT_RKSt6locale"
		size = 92
		refs = "000c _ZNKSt6locale2id5_M_idEv 003c __dynamic_cast 0048 __cxa_bad_cast 004c _ZSt16__throw_bad_castv 0050 _ZNSt7codecvtIcciE2idE 0054 _ZTINSt6locale5facetE 0058 _ZTISt7codecvtIcciE"
	strings:
		$1 = { 10 40 2D E9 00 40 A0 E1 40 00 9F E5 ?? ?? ?? ?? 00 30 94 E5 08 20 93 E5 04 30 93 E5 02 00 50 E1 09 00 00 2A 00 01 93 E7 00 00 50 E3 06 00 00 0A 1C 10 9F E5 1C 20 9F E5 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 10 80 BD 18 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_170_3 {
	meta:
		name = "_ZSt9use_facetISt7codecvtIwciEERKT_RKSt6locale"
		size = 92
		refs = "000c _ZNKSt6locale2id5_M_idEv 003c __dynamic_cast 0048 __cxa_bad_cast 004c _ZSt16__throw_bad_castv 0050 _ZNSt7codecvtIwciE2idE 0054 _ZTINSt6locale5facetE 0058 _ZTISt7codecvtIwciE"
	strings:
		$1 = { 10 40 2D E9 00 40 A0 E1 40 00 9F E5 ?? ?? ?? ?? 00 30 94 E5 08 20 93 E5 04 30 93 E5 02 00 50 E1 09 00 00 2A 00 01 93 E7 00 00 50 E3 06 00 00 0A 1C 10 9F E5 1C 20 9F E5 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 10 80 BD 18 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_170_3 {
	meta:
		name = "_ZSt9use_facetISt7collateIcEERKT_RKSt6locale"
		size = 92
		refs = "000c _ZNKSt6locale2id5_M_idEv 003c __dynamic_cast 0048 __cxa_bad_cast 004c _ZSt16__throw_bad_castv 0050 _ZNSt7collateIcE2idE 0054 _ZTINSt6locale5facetE 0058 _ZTISt7collateIcE"
	strings:
		$1 = { 10 40 2D E9 00 40 A0 E1 40 00 9F E5 ?? ?? ?? ?? 00 30 94 E5 08 20 93 E5 04 30 93 E5 02 00 50 E1 09 00 00 2A 00 01 93 E7 00 00 50 E3 06 00 00 0A 1C 10 9F E5 1C 20 9F E5 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 10 80 BD 18 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_169_3 {
	meta:
		name = "_ZSt9use_facetISt7collateIwEERKT_RKSt6locale"
		size = 92
		refs = "000c _ZNKSt6locale2id5_M_idEv 003c __dynamic_cast 0048 __cxa_bad_cast 004c _ZSt16__throw_bad_castv 0050 _ZNSt7collateIwE2idE 0054 _ZTINSt6locale5facetE 0058 _ZTISt7collateIwE"
	strings:
		$1 = { 10 40 2D E9 00 40 A0 E1 40 00 9F E5 ?? ?? ?? ?? 00 30 94 E5 08 20 93 E5 04 30 93 E5 02 00 50 E1 09 00 00 2A 00 01 93 E7 00 00 50 E3 06 00 00 0A 1C 10 9F E5 1C 20 9F E5 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 10 80 BD 18 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_167_3 {
	meta:
		name = "_ZSt9use_facetISt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEEERKT_RKSt6locale"
		size = 92
		refs = "000c _ZNKSt6locale2id5_M_idEv 003c __dynamic_cast 0048 __cxa_bad_cast 004c _ZSt16__throw_bad_castv 0050 _ZNSt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE2idE 0054 _ZTINSt6locale5facetE 0058 _ZTISt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 10 40 2D E9 00 40 A0 E1 40 00 9F E5 ?? ?? ?? ?? 00 30 94 E5 08 20 93 E5 04 30 93 E5 02 00 50 E1 09 00 00 2A 00 01 93 E7 00 00 50 E3 06 00 00 0A 1C 10 9F E5 1C 20 9F E5 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 10 80 BD 18 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_166_3 {
	meta:
		name = "_ZSt9use_facetISt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEEERKT_RKSt6locale"
		size = 92
		refs = "000c _ZNKSt6locale2id5_M_idEv 003c __dynamic_cast 0048 __cxa_bad_cast 004c _ZSt16__throw_bad_castv 0050 _ZNSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE2idE 0054 _ZTINSt6locale5facetE 0058 _ZTISt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE"
	strings:
		$1 = { 10 40 2D E9 00 40 A0 E1 40 00 9F E5 ?? ?? ?? ?? 00 30 94 E5 08 20 93 E5 04 30 93 E5 02 00 50 E1 09 00 00 2A 00 01 93 E7 00 00 50 E3 06 00 00 0A 1C 10 9F E5 1C 20 9F E5 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 10 80 BD 18 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_168_3 {
	meta:
		name = "_ZSt9use_facetISt7num_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEEERKT_RKSt6locale"
		size = 92
		refs = "000c _ZNKSt6locale2id5_M_idEv 003c __dynamic_cast 0048 __cxa_bad_cast 004c _ZSt16__throw_bad_castv 0050 _ZNSt7num_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE2idE 0054 _ZTINSt6locale5facetE 0058 _ZTISt7num_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 10 40 2D E9 00 40 A0 E1 40 00 9F E5 ?? ?? ?? ?? 00 30 94 E5 08 20 93 E5 04 30 93 E5 02 00 50 E1 09 00 00 2A 00 01 93 E7 00 00 50 E3 06 00 00 0A 1C 10 9F E5 1C 20 9F E5 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 10 80 BD 18 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_167_3 {
	meta:
		name = "_ZSt9use_facetISt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEEERKT_RKSt6locale"
		size = 92
		refs = "000c _ZNKSt6locale2id5_M_idEv 003c __dynamic_cast 0048 __cxa_bad_cast 004c _ZSt16__throw_bad_castv 0050 _ZNSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE2idE 0054 _ZTINSt6locale5facetE 0058 _ZTISt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE"
	strings:
		$1 = { 10 40 2D E9 00 40 A0 E1 40 00 9F E5 ?? ?? ?? ?? 00 30 94 E5 08 20 93 E5 04 30 93 E5 02 00 50 E1 09 00 00 2A 00 01 93 E7 00 00 50 E3 06 00 00 0A 1C 10 9F E5 1C 20 9F E5 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 10 80 BD 18 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_159_3 {
	meta:
		name = "_ZSt9use_facetISt8messagesIcEERKT_RKSt6locale"
		size = 92
		refs = "000c _ZNKSt6locale2id5_M_idEv 003c __dynamic_cast 0048 __cxa_bad_cast 004c _ZSt16__throw_bad_castv 0050 _ZNSt8messagesIcE2idE 0054 _ZTINSt6locale5facetE 0058 _ZTISt8messagesIcE"
	strings:
		$1 = { 10 40 2D E9 00 40 A0 E1 40 00 9F E5 ?? ?? ?? ?? 00 30 94 E5 08 20 93 E5 04 30 93 E5 02 00 50 E1 09 00 00 2A 00 01 93 E7 00 00 50 E3 06 00 00 0A 1C 10 9F E5 1C 20 9F E5 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 10 80 BD 18 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_169_3 {
	meta:
		name = "_ZSt9use_facetISt8numpunctIcEERKT_RKSt6locale"
		size = 92
		refs = "000c _ZNKSt6locale2id5_M_idEv 003c __dynamic_cast 0048 __cxa_bad_cast 004c _ZSt16__throw_bad_castv 0050 _ZNSt8numpunctIcE2idE 0054 _ZTINSt6locale5facetE 0058 _ZTISt8numpunctIcE"
	strings:
		$1 = { 10 40 2D E9 00 40 A0 E1 40 00 9F E5 ?? ?? ?? ?? 00 30 94 E5 08 20 93 E5 04 30 93 E5 02 00 50 E1 09 00 00 2A 00 01 93 E7 00 00 50 E3 06 00 00 0A 1C 10 9F E5 1C 20 9F E5 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 10 80 BD 18 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_168_3 {
	meta:
		name = "_ZSt9use_facetISt8numpunctIwEERKT_RKSt6locale"
		size = 92
		refs = "000c _ZNKSt6locale2id5_M_idEv 003c __dynamic_cast 0048 __cxa_bad_cast 004c _ZSt16__throw_bad_castv 0050 _ZNSt8numpunctIwE2idE 0054 _ZTINSt6locale5facetE 0058 _ZTISt8numpunctIwE"
	strings:
		$1 = { 10 40 2D E9 00 40 A0 E1 40 00 9F E5 ?? ?? ?? ?? 00 30 94 E5 08 20 93 E5 04 30 93 E5 02 00 50 E1 09 00 00 2A 00 01 93 E7 00 00 50 E3 06 00 00 0A 1C 10 9F E5 1C 20 9F E5 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 10 80 BD 18 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_160_3 {
	meta:
		name = "_ZSt9use_facetISt8time_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEEERKT_RKSt6locale"
		size = 92
		refs = "000c _ZNKSt6locale2id5_M_idEv 003c __dynamic_cast 0048 __cxa_bad_cast 004c _ZSt16__throw_bad_castv 0050 _ZNSt8time_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE2idE 0054 _ZTINSt6locale5facetE 0058 _ZTISt8time_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 10 40 2D E9 00 40 A0 E1 40 00 9F E5 ?? ?? ?? ?? 00 30 94 E5 08 20 93 E5 04 30 93 E5 02 00 50 E1 09 00 00 2A 00 01 93 E7 00 00 50 E3 06 00 00 0A 1C 10 9F E5 1C 20 9F E5 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 10 80 BD 18 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_159_3 {
	meta:
		name = "_ZSt9use_facetISt8time_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEEERKT_RKSt6locale"
		size = 92
		refs = "000c _ZNKSt6locale2id5_M_idEv 003c __dynamic_cast 0048 __cxa_bad_cast 004c _ZSt16__throw_bad_castv 0050 _ZNSt8time_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE2idE 0054 _ZTINSt6locale5facetE 0058 _ZTISt8time_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE"
	strings:
		$1 = { 10 40 2D E9 00 40 A0 E1 40 00 9F E5 ?? ?? ?? ?? 00 30 94 E5 08 20 93 E5 04 30 93 E5 02 00 50 E1 09 00 00 2A 00 01 93 E7 00 00 50 E3 06 00 00 0A 1C 10 9F E5 1C 20 9F E5 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 10 80 BD 18 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_161_3 {
	meta:
		name = "_ZSt9use_facetISt8time_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEEERKT_RKSt6locale"
		size = 92
		refs = "000c _ZNKSt6locale2id5_M_idEv 003c __dynamic_cast 0048 __cxa_bad_cast 004c _ZSt16__throw_bad_castv 0050 _ZNSt8time_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE2idE 0054 _ZTINSt6locale5facetE 0058 _ZTISt8time_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 10 40 2D E9 00 40 A0 E1 40 00 9F E5 ?? ?? ?? ?? 00 30 94 E5 08 20 93 E5 04 30 93 E5 02 00 50 E1 09 00 00 2A 00 01 93 E7 00 00 50 E3 06 00 00 0A 1C 10 9F E5 1C 20 9F E5 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 10 80 BD 18 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_160_3 {
	meta:
		name = "_ZSt9use_facetISt8time_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEEERKT_RKSt6locale"
		size = 92
		refs = "000c _ZNKSt6locale2id5_M_idEv 003c __dynamic_cast 0048 __cxa_bad_cast 004c _ZSt16__throw_bad_castv 0050 _ZNSt8time_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE2idE 0054 _ZTINSt6locale5facetE 0058 _ZTISt8time_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE"
	strings:
		$1 = { 10 40 2D E9 00 40 A0 E1 40 00 9F E5 ?? ?? ?? ?? 00 30 94 E5 08 20 93 E5 04 30 93 E5 02 00 50 E1 09 00 00 2A 00 01 93 E7 00 00 50 E3 06 00 00 0A 1C 10 9F E5 1C 20 9F E5 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 10 80 BD 18 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_163_3 {
	meta:
		name = "_ZSt9use_facetISt9money_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEEERKT_RKSt6locale"
		size = 92
		refs = "000c _ZNKSt6locale2id5_M_idEv 003c __dynamic_cast 0048 __cxa_bad_cast 004c _ZSt16__throw_bad_castv 0050 _ZNSt9money_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE2idE 0054 _ZTINSt6locale5facetE 0058 _ZTISt9money_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 10 40 2D E9 00 40 A0 E1 40 00 9F E5 ?? ?? ?? ?? 00 30 94 E5 08 20 93 E5 04 30 93 E5 02 00 50 E1 09 00 00 2A 00 01 93 E7 00 00 50 E3 06 00 00 0A 1C 10 9F E5 1C 20 9F E5 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 10 80 BD 18 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_162_3 {
	meta:
		name = "_ZSt9use_facetISt9money_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEEERKT_RKSt6locale"
		size = 92
		refs = "000c _ZNKSt6locale2id5_M_idEv 003c __dynamic_cast 0048 __cxa_bad_cast 004c _ZSt16__throw_bad_castv 0050 _ZNSt9money_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE2idE 0054 _ZTINSt6locale5facetE 0058 _ZTISt9money_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE"
	strings:
		$1 = { 10 40 2D E9 00 40 A0 E1 40 00 9F E5 ?? ?? ?? ?? 00 30 94 E5 08 20 93 E5 04 30 93 E5 02 00 50 E1 09 00 00 2A 00 01 93 E7 00 00 50 E3 06 00 00 0A 1C 10 9F E5 1C 20 9F E5 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 10 80 BD 18 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_164_3 {
	meta:
		name = "_ZSt9use_facetISt9money_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEEERKT_RKSt6locale"
		size = 92
		refs = "000c _ZNKSt6locale2id5_M_idEv 003c __dynamic_cast 0048 __cxa_bad_cast 004c _ZSt16__throw_bad_castv 0050 _ZNSt9money_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE2idE 0054 _ZTINSt6locale5facetE 0058 _ZTISt9money_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 10 40 2D E9 00 40 A0 E1 40 00 9F E5 ?? ?? ?? ?? 00 30 94 E5 08 20 93 E5 04 30 93 E5 02 00 50 E1 09 00 00 2A 00 01 93 E7 00 00 50 E3 06 00 00 0A 1C 10 9F E5 1C 20 9F E5 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 10 80 BD 18 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_163_3 {
	meta:
		name = "_ZSt9use_facetISt9money_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEEERKT_RKSt6locale"
		size = 92
		refs = "000c _ZNKSt6locale2id5_M_idEv 003c __dynamic_cast 0048 __cxa_bad_cast 004c _ZSt16__throw_bad_castv 0050 _ZNSt9money_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE2idE 0054 _ZTINSt6locale5facetE 0058 _ZTISt9money_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE"
	strings:
		$1 = { 10 40 2D E9 00 40 A0 E1 40 00 9F E5 ?? ?? ?? ?? 00 30 94 E5 08 20 93 E5 04 30 93 E5 02 00 50 E1 09 00 00 2A 00 01 93 E7 00 00 50 E3 06 00 00 0A 1C 10 9F E5 1C 20 9F E5 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 10 80 BD 18 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_172_3 {
	meta:
		name = "_ZNSt7collateIwED0Ev"
		size = 184
		refs = "0038 _Unwind_SjLj_Register 0050 _ZNSt6locale5facet19_S_destroy_c_localeERPi 0060 _ZNSt6locale5facetD2Ev 0068 _ZdlPv 0070 _Unwind_SjLj_Unregister 00a4 _Unwind_SjLj_Resume 00a8 __gxx_personality_sj0 00ac .gcc_except_table 00b0 .text$_ZNSt7collateIwED0Ev 00b4 _ZTVSt7collateIwE"
	strings:
		$1 = { 00 48 2D E9 9C 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 90 30 9F E5 3C 00 0B E5 1C 30 0B E5 88 30 9F E5 38 00 4B E2 14 30 0B E5 04 30 4B E2 18 30 0B E5 10 D0 0B E5 ?? ?? ?? ?? 70 30 9F E5 3C 00 1B E5 08 30 80 E4 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 3C 00 1B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 A0 E3 34 30 0B E5 30 30 1B E5 3C 00 1B E5 3C 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_272_3 {
	meta:
		name = "_ZNSt14collate_bynameIcED0Ev"
		size = 184
		refs = "0038 _Unwind_SjLj_Register 0050 _ZNSt6locale5facet19_S_destroy_c_localeERPi 0060 _ZNSt6locale5facetD2Ev 0068 _ZdlPv 0070 _Unwind_SjLj_Unregister 00a4 _Unwind_SjLj_Resume 00a8 __gxx_personality_sj0 00ac .gcc_except_table 00b0 .text$_ZNSt14collate_bynameIcED0Ev 00b4 _ZTVSt7collateIcE"
	strings:
		$1 = { 00 48 2D E9 9C 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 90 30 9F E5 3C 00 0B E5 1C 30 0B E5 88 30 9F E5 38 00 4B E2 14 30 0B E5 04 30 4B E2 18 30 0B E5 10 D0 0B E5 ?? ?? ?? ?? 70 30 9F E5 3C 00 1B E5 08 30 80 E4 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 3C 00 1B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 A0 E3 34 30 0B E5 30 30 1B E5 3C 00 1B E5 3C 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_273_3 {
	meta:
		name = "_ZNSt14collate_bynameIwED0Ev"
		size = 184
		refs = "0038 _Unwind_SjLj_Register 0050 _ZNSt6locale5facet19_S_destroy_c_localeERPi 0060 _ZNSt6locale5facetD2Ev 0068 _ZdlPv 0070 _Unwind_SjLj_Unregister 00a4 _Unwind_SjLj_Resume 00a8 __gxx_personality_sj0 00ac .gcc_except_table 00b0 .text$_ZNSt14collate_bynameIwED0Ev 00b4 _ZTVSt7collateIwE"
	strings:
		$1 = { 00 48 2D E9 9C 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 90 30 9F E5 3C 00 0B E5 1C 30 0B E5 88 30 9F E5 38 00 4B E2 14 30 0B E5 04 30 4B E2 18 30 0B E5 10 D0 0B E5 ?? ?? ?? ?? 70 30 9F E5 3C 00 1B E5 08 30 80 E4 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 3C 00 1B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 A0 E3 34 30 0B E5 30 30 1B E5 3C 00 1B E5 3C 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_173_3 {
	meta:
		name = "_ZNSt7collateIcED0Ev"
		size = 184
		refs = "0038 _Unwind_SjLj_Register 0050 _ZNSt6locale5facet19_S_destroy_c_localeERPi 0060 _ZNSt6locale5facetD2Ev 0068 _ZdlPv 0070 _Unwind_SjLj_Unregister 00a4 _Unwind_SjLj_Resume 00a8 __gxx_personality_sj0 00ac .gcc_except_table 00b0 .text$_ZNSt7collateIcED0Ev 00b4 _ZTVSt7collateIcE"
	strings:
		$1 = { 00 48 2D E9 9C 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 90 30 9F E5 3C 00 0B E5 1C 30 0B E5 88 30 9F E5 38 00 4B E2 14 30 0B E5 04 30 4B E2 18 30 0B E5 10 D0 0B E5 ?? ?? ?? ?? 70 30 9F E5 3C 00 1B E5 08 30 80 E4 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 3C 00 1B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 A0 E3 34 30 0B E5 30 30 1B E5 3C 00 1B E5 3C 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_176_3 {
	meta:
		name = "_ZNSt8messagesIcED0Ev"
		size = 184
		refs = "0038 _Unwind_SjLj_Register 0050 _ZNSt6locale5facet19_S_destroy_c_localeERPi 0060 _ZNSt6locale5facetD2Ev 0068 _ZdlPv 0070 _Unwind_SjLj_Unregister 00a4 _Unwind_SjLj_Resume 00a8 __gxx_personality_sj0 00ac .gcc_except_table 00b0 .text$_ZNSt8messagesIcED0Ev 00b4 _ZTVSt8messagesIcE"
	strings:
		$1 = { 00 48 2D E9 9C 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 90 30 9F E5 3C 00 0B E5 1C 30 0B E5 88 30 9F E5 38 00 4B E2 14 30 0B E5 04 30 4B E2 18 30 0B E5 10 D0 0B E5 ?? ?? ?? ?? 70 30 9F E5 3C 00 1B E5 08 30 80 E4 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 3C 00 1B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 A0 E3 34 30 0B E5 30 30 1B E5 3C 00 1B E5 3C 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_175_3 {
	meta:
		name = "_ZNSt8messagesIwED0Ev"
		size = 184
		refs = "0038 _Unwind_SjLj_Register 0050 _ZNSt6locale5facet19_S_destroy_c_localeERPi 0060 _ZNSt6locale5facetD2Ev 0068 _ZdlPv 0070 _Unwind_SjLj_Unregister 00a4 _Unwind_SjLj_Resume 00a8 __gxx_personality_sj0 00ac .gcc_except_table 00b0 .text$_ZNSt8messagesIwED0Ev 00b4 _ZTVSt8messagesIwE"
	strings:
		$1 = { 00 48 2D E9 9C 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 90 30 9F E5 3C 00 0B E5 1C 30 0B E5 88 30 9F E5 38 00 4B E2 14 30 0B E5 04 30 4B E2 18 30 0B E5 10 D0 0B E5 ?? ?? ?? ?? 70 30 9F E5 3C 00 1B E5 08 30 80 E4 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 3C 00 1B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 A0 E3 34 30 0B E5 30 30 1B E5 3C 00 1B E5 3C 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_173_3 {
	meta:
		name = "_ZNSt7collateIwED1Ev"
		size = 176
		refs = "0038 _Unwind_SjLj_Register 0050 _ZNSt6locale5facet19_S_destroy_c_localeERPi 0060 _ZNSt6locale5facetD2Ev 0068 _Unwind_SjLj_Unregister 009c _Unwind_SjLj_Resume 00a0 __gxx_personality_sj0 00a4 .gcc_except_table 00a8 .text$_ZNSt7collateIwED1Ev 00ac _ZTVSt7collateIwE"
	strings:
		$1 = { 00 48 2D E9 94 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 88 30 9F E5 3C 00 0B E5 1C 30 0B E5 80 30 9F E5 38 00 4B E2 14 30 0B E5 04 30 4B E2 18 30 0B E5 10 D0 0B E5 ?? ?? ?? ?? 68 30 9F E5 3C 00 1B E5 08 30 80 E4 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 A0 E3 34 30 0B E5 30 30 1B E5 3C 00 1B E5 3C 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_273_3 {
	meta:
		name = "_ZNSt14collate_bynameIcED1Ev"
		size = 176
		refs = "0038 _Unwind_SjLj_Register 0050 _ZNSt6locale5facet19_S_destroy_c_localeERPi 0060 _ZNSt6locale5facetD2Ev 0068 _Unwind_SjLj_Unregister 009c _Unwind_SjLj_Resume 00a0 __gxx_personality_sj0 00a4 .gcc_except_table 00a8 .text$_ZNSt14collate_bynameIcED1Ev 00ac _ZTVSt7collateIcE"
	strings:
		$1 = { 00 48 2D E9 94 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 88 30 9F E5 3C 00 0B E5 1C 30 0B E5 80 30 9F E5 38 00 4B E2 14 30 0B E5 04 30 4B E2 18 30 0B E5 10 D0 0B E5 ?? ?? ?? ?? 68 30 9F E5 3C 00 1B E5 08 30 80 E4 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 A0 E3 34 30 0B E5 30 30 1B E5 3C 00 1B E5 3C 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_274_3 {
	meta:
		name = "_ZNSt14collate_bynameIcED2Ev"
		size = 176
		refs = "0038 _Unwind_SjLj_Register 0050 _ZNSt6locale5facet19_S_destroy_c_localeERPi 0060 _ZNSt6locale5facetD2Ev 0068 _Unwind_SjLj_Unregister 009c _Unwind_SjLj_Resume 00a0 __gxx_personality_sj0 00a4 .gcc_except_table 00a8 .text$_ZNSt14collate_bynameIcED2Ev 00ac _ZTVSt7collateIcE"
	strings:
		$1 = { 00 48 2D E9 94 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 88 30 9F E5 3C 00 0B E5 1C 30 0B E5 80 30 9F E5 38 00 4B E2 14 30 0B E5 04 30 4B E2 18 30 0B E5 10 D0 0B E5 ?? ?? ?? ?? 68 30 9F E5 3C 00 1B E5 08 30 80 E4 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 A0 E3 34 30 0B E5 30 30 1B E5 3C 00 1B E5 3C 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_274_3 {
	meta:
		name = "_ZNSt14collate_bynameIwED1Ev"
		size = 176
		refs = "0038 _Unwind_SjLj_Register 0050 _ZNSt6locale5facet19_S_destroy_c_localeERPi 0060 _ZNSt6locale5facetD2Ev 0068 _Unwind_SjLj_Unregister 009c _Unwind_SjLj_Resume 00a0 __gxx_personality_sj0 00a4 .gcc_except_table 00a8 .text$_ZNSt14collate_bynameIwED1Ev 00ac _ZTVSt7collateIwE"
	strings:
		$1 = { 00 48 2D E9 94 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 88 30 9F E5 3C 00 0B E5 1C 30 0B E5 80 30 9F E5 38 00 4B E2 14 30 0B E5 04 30 4B E2 18 30 0B E5 10 D0 0B E5 ?? ?? ?? ?? 68 30 9F E5 3C 00 1B E5 08 30 80 E4 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 A0 E3 34 30 0B E5 30 30 1B E5 3C 00 1B E5 3C 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_275_3 {
	meta:
		name = "_ZNSt14collate_bynameIwED2Ev"
		size = 176
		refs = "0038 _Unwind_SjLj_Register 0050 _ZNSt6locale5facet19_S_destroy_c_localeERPi 0060 _ZNSt6locale5facetD2Ev 0068 _Unwind_SjLj_Unregister 009c _Unwind_SjLj_Resume 00a0 __gxx_personality_sj0 00a4 .gcc_except_table 00a8 .text$_ZNSt14collate_bynameIwED2Ev 00ac _ZTVSt7collateIwE"
	strings:
		$1 = { 00 48 2D E9 94 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 88 30 9F E5 3C 00 0B E5 1C 30 0B E5 80 30 9F E5 38 00 4B E2 14 30 0B E5 04 30 4B E2 18 30 0B E5 10 D0 0B E5 ?? ?? ?? ?? 68 30 9F E5 3C 00 1B E5 08 30 80 E4 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 A0 E3 34 30 0B E5 30 30 1B E5 3C 00 1B E5 3C 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_174_3 {
	meta:
		name = "_ZNSt7collateIcED1Ev"
		size = 176
		refs = "0038 _Unwind_SjLj_Register 0050 _ZNSt6locale5facet19_S_destroy_c_localeERPi 0060 _ZNSt6locale5facetD2Ev 0068 _Unwind_SjLj_Unregister 009c _Unwind_SjLj_Resume 00a0 __gxx_personality_sj0 00a4 .gcc_except_table 00a8 .text$_ZNSt7collateIcED1Ev 00ac _ZTVSt7collateIcE"
	strings:
		$1 = { 00 48 2D E9 94 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 88 30 9F E5 3C 00 0B E5 1C 30 0B E5 80 30 9F E5 38 00 4B E2 14 30 0B E5 04 30 4B E2 18 30 0B E5 10 D0 0B E5 ?? ?? ?? ?? 68 30 9F E5 3C 00 1B E5 08 30 80 E4 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 A0 E3 34 30 0B E5 30 30 1B E5 3C 00 1B E5 3C 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_175_3 {
	meta:
		name = "_ZNSt7collateIcED2Ev"
		size = 176
		refs = "0038 _Unwind_SjLj_Register 0050 _ZNSt6locale5facet19_S_destroy_c_localeERPi 0060 _ZNSt6locale5facetD2Ev 0068 _Unwind_SjLj_Unregister 009c _Unwind_SjLj_Resume 00a0 __gxx_personality_sj0 00a4 .gcc_except_table 00a8 .text$_ZNSt7collateIcED2Ev 00ac _ZTVSt7collateIcE"
	strings:
		$1 = { 00 48 2D E9 94 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 88 30 9F E5 3C 00 0B E5 1C 30 0B E5 80 30 9F E5 38 00 4B E2 14 30 0B E5 04 30 4B E2 18 30 0B E5 10 D0 0B E5 ?? ?? ?? ?? 68 30 9F E5 3C 00 1B E5 08 30 80 E4 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 A0 E3 34 30 0B E5 30 30 1B E5 3C 00 1B E5 3C 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_174_3 {
	meta:
		name = "_ZNSt7collateIwED2Ev"
		size = 176
		refs = "0038 _Unwind_SjLj_Register 0050 _ZNSt6locale5facet19_S_destroy_c_localeERPi 0060 _ZNSt6locale5facetD2Ev 0068 _Unwind_SjLj_Unregister 009c _Unwind_SjLj_Resume 00a0 __gxx_personality_sj0 00a4 .gcc_except_table 00a8 .text$_ZNSt7collateIwED2Ev 00ac _ZTVSt7collateIwE"
	strings:
		$1 = { 00 48 2D E9 94 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 88 30 9F E5 3C 00 0B E5 1C 30 0B E5 80 30 9F E5 38 00 4B E2 14 30 0B E5 04 30 4B E2 18 30 0B E5 10 D0 0B E5 ?? ?? ?? ?? 68 30 9F E5 3C 00 1B E5 08 30 80 E4 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 A0 E3 34 30 0B E5 30 30 1B E5 3C 00 1B E5 3C 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_177_3 {
	meta:
		name = "_ZNSt8messagesIcED1Ev"
		size = 176
		refs = "0038 _Unwind_SjLj_Register 0050 _ZNSt6locale5facet19_S_destroy_c_localeERPi 0060 _ZNSt6locale5facetD2Ev 0068 _Unwind_SjLj_Unregister 009c _Unwind_SjLj_Resume 00a0 __gxx_personality_sj0 00a4 .gcc_except_table 00a8 .text$_ZNSt8messagesIcED1Ev 00ac _ZTVSt8messagesIcE"
	strings:
		$1 = { 00 48 2D E9 94 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 88 30 9F E5 3C 00 0B E5 1C 30 0B E5 80 30 9F E5 38 00 4B E2 14 30 0B E5 04 30 4B E2 18 30 0B E5 10 D0 0B E5 ?? ?? ?? ?? 68 30 9F E5 3C 00 1B E5 08 30 80 E4 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 A0 E3 34 30 0B E5 30 30 1B E5 3C 00 1B E5 3C 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_178_3 {
	meta:
		name = "_ZNSt8messagesIcED2Ev"
		size = 176
		refs = "0038 _Unwind_SjLj_Register 0050 _ZNSt6locale5facet19_S_destroy_c_localeERPi 0060 _ZNSt6locale5facetD2Ev 0068 _Unwind_SjLj_Unregister 009c _Unwind_SjLj_Resume 00a0 __gxx_personality_sj0 00a4 .gcc_except_table 00a8 .text$_ZNSt8messagesIcED2Ev 00ac _ZTVSt8messagesIcE"
	strings:
		$1 = { 00 48 2D E9 94 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 88 30 9F E5 3C 00 0B E5 1C 30 0B E5 80 30 9F E5 38 00 4B E2 14 30 0B E5 04 30 4B E2 18 30 0B E5 10 D0 0B E5 ?? ?? ?? ?? 68 30 9F E5 3C 00 1B E5 08 30 80 E4 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 A0 E3 34 30 0B E5 30 30 1B E5 3C 00 1B E5 3C 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_176_3 {
	meta:
		name = "_ZNSt8messagesIwED1Ev"
		size = 176
		refs = "0038 _Unwind_SjLj_Register 0050 _ZNSt6locale5facet19_S_destroy_c_localeERPi 0060 _ZNSt6locale5facetD2Ev 0068 _Unwind_SjLj_Unregister 009c _Unwind_SjLj_Resume 00a0 __gxx_personality_sj0 00a4 .gcc_except_table 00a8 .text$_ZNSt8messagesIwED1Ev 00ac _ZTVSt8messagesIwE"
	strings:
		$1 = { 00 48 2D E9 94 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 88 30 9F E5 3C 00 0B E5 1C 30 0B E5 80 30 9F E5 38 00 4B E2 14 30 0B E5 04 30 4B E2 18 30 0B E5 10 D0 0B E5 ?? ?? ?? ?? 68 30 9F E5 3C 00 1B E5 08 30 80 E4 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 A0 E3 34 30 0B E5 30 30 1B E5 3C 00 1B E5 3C 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_177_3 {
	meta:
		name = "_ZNSt8messagesIwED2Ev"
		size = 176
		refs = "0038 _Unwind_SjLj_Register 0050 _ZNSt6locale5facet19_S_destroy_c_localeERPi 0060 _ZNSt6locale5facetD2Ev 0068 _Unwind_SjLj_Unregister 009c _Unwind_SjLj_Resume 00a0 __gxx_personality_sj0 00a4 .gcc_except_table 00a8 .text$_ZNSt8messagesIwED2Ev 00ac _ZTVSt8messagesIwE"
	strings:
		$1 = { 00 48 2D E9 94 30 9F E5 04 B0 8D E2 38 D0 4D E2 20 30 0B E5 88 30 9F E5 3C 00 0B E5 1C 30 0B E5 80 30 9F E5 38 00 4B E2 14 30 0B E5 04 30 4B E2 18 30 0B E5 10 D0 0B E5 ?? ?? ?? ?? 68 30 9F E5 3C 00 1B E5 08 30 80 E4 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 A0 E3 34 30 0B E5 30 30 1B E5 3C 00 1B E5 3C 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_181_3 {
	meta:
		name = "_ZNSt16__numpunct_cacheIwED0Ev"
		size = 88
		refs = "0024 _ZdaPv 0044 _ZNSt6locale5facetD2Ev 004c _ZdlPv 0054 _ZTVSt16__numpunct_cacheIwE"
	strings:
		$1 = { A4 30 D0 E5 10 40 2D E9 00 00 53 E3 40 30 9F E5 00 40 A0 E1 00 30 80 E5 08 00 00 0A 08 00 90 E5 00 00 50 E3 ?? ?? ?? ?? 14 00 94 E5 00 00 50 E3 ?? ?? ?? ?? 1C 00 94 E5 00 00 50 E3 ?? ?? ?? ?? 04 00 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 ?? ?? ?? ?? 10 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_182_3 {
	meta:
		name = "_ZNSt16__numpunct_cacheIwED1Ev"
		size = 80
		refs = "0024 _ZdaPv 0044 _ZNSt6locale5facetD2Ev 004c _ZTVSt16__numpunct_cacheIwE"
		altNames = "_ZNSt16__numpunct_cacheIwED2Ev"
	strings:
		$1 = { A4 30 D0 E5 10 40 2D E9 00 00 53 E3 38 30 9F E5 00 40 A0 E1 00 30 80 E5 08 00 00 0A 08 00 90 E5 00 00 50 E3 ?? ?? ?? ?? 14 00 94 E5 00 00 50 E3 ?? ?? ?? ?? 1C 00 94 E5 00 00 50 E3 ?? ?? ?? ?? 04 00 A0 E1 ?? ?? ?? ?? 10 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_184_3 {
	meta:
		name = "_ZNSt18__moneypunct_cacheIwLb1EED0Ev"
		size = 100
		refs = "0024 _ZdaPv 0050 _ZNSt6locale5facetD2Ev 0058 _ZdlPv 0060 _ZTVSt18__moneypunct_cacheIwLb1EE"
	strings:
		$1 = { 52 30 D0 E5 10 40 2D E9 00 00 53 E3 4C 30 9F E5 00 40 A0 E1 00 30 80 E5 0B 00 00 0A 08 00 90 E5 00 00 50 E3 ?? ?? ?? ?? 18 00 94 E5 00 00 50 E3 ?? ?? ?? ?? 20 00 94 E5 00 00 50 E3 ?? ?? ?? ?? 28 00 94 E5 00 00 50 E3 ?? ?? ?? ?? 04 00 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 ?? ?? ?? ?? 10 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_187_3 {
	meta:
		name = "_ZNSt18__moneypunct_cacheIwLb0EED0Ev"
		size = 100
		refs = "0024 _ZdaPv 0050 _ZNSt6locale5facetD2Ev 0058 _ZdlPv 0060 _ZTVSt18__moneypunct_cacheIwLb0EE"
	strings:
		$1 = { 52 30 D0 E5 10 40 2D E9 00 00 53 E3 4C 30 9F E5 00 40 A0 E1 00 30 80 E5 0B 00 00 0A 08 00 90 E5 00 00 50 E3 ?? ?? ?? ?? 18 00 94 E5 00 00 50 E3 ?? ?? ?? ?? 20 00 94 E5 00 00 50 E3 ?? ?? ?? ?? 28 00 94 E5 00 00 50 E3 ?? ?? ?? ?? 04 00 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 ?? ?? ?? ?? 10 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_185_3 {
	meta:
		name = "_ZNSt18__moneypunct_cacheIwLb1EED1Ev"
		size = 92
		refs = "0024 _ZdaPv 0050 _ZNSt6locale5facetD2Ev 0058 _ZTVSt18__moneypunct_cacheIwLb1EE"
		altNames = "_ZNSt18__moneypunct_cacheIwLb1EED2Ev"
	strings:
		$1 = { 52 30 D0 E5 10 40 2D E9 00 00 53 E3 44 30 9F E5 00 40 A0 E1 00 30 80 E5 0B 00 00 0A 08 00 90 E5 00 00 50 E3 ?? ?? ?? ?? 18 00 94 E5 00 00 50 E3 ?? ?? ?? ?? 20 00 94 E5 00 00 50 E3 ?? ?? ?? ?? 28 00 94 E5 00 00 50 E3 ?? ?? ?? ?? 04 00 A0 E1 ?? ?? ?? ?? 10 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_188_3 {
	meta:
		name = "_ZNSt18__moneypunct_cacheIwLb0EED1Ev"
		size = 92
		refs = "0024 _ZdaPv 0050 _ZNSt6locale5facetD2Ev 0058 _ZTVSt18__moneypunct_cacheIwLb0EE"
	strings:
		$1 = { 52 30 D0 E5 10 40 2D E9 00 00 53 E3 44 30 9F E5 00 40 A0 E1 00 30 80 E5 0B 00 00 0A 08 00 90 E5 00 00 50 E3 ?? ?? ?? ?? 18 00 94 E5 00 00 50 E3 ?? ?? ?? ?? 20 00 94 E5 00 00 50 E3 ?? ?? ?? ?? 28 00 94 E5 00 00 50 E3 ?? ?? ?? ?? 04 00 A0 E1 ?? ?? ?? ?? 10 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_189_3 {
	meta:
		name = "_ZNSt18__moneypunct_cacheIwLb0EED2Ev"
		size = 92
		refs = "0024 _ZdaPv 0050 _ZNSt6locale5facetD2Ev 0058 _ZTVSt18__moneypunct_cacheIwLb0EE"
	strings:
		$1 = { 52 30 D0 E5 10 40 2D E9 00 00 53 E3 44 30 9F E5 00 40 A0 E1 00 30 80 E5 0B 00 00 0A 08 00 90 E5 00 00 50 E3 ?? ?? ?? ?? 18 00 94 E5 00 00 50 E3 ?? ?? ?? ?? 20 00 94 E5 00 00 50 E3 ?? ?? ?? ?? 28 00 94 E5 00 00 50 E3 ?? ?? ?? ?? 04 00 A0 E1 ?? ?? ?? ?? 10 80 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_190_3 {
	meta:
		name = "_ZNSt7collateIwEC1EPij"
		size = 196
		refs = "0040 _Unwind_SjLj_Register 006c _ZNSt6locale5facet17_S_clone_c_localeERPi 007c _Unwind_SjLj_Unregister 00a0 _ZNSt6locale5facetD2Ev 00b0 _Unwind_SjLj_Resume 00b4 __gxx_personality_sj0 00b8 .gcc_except_table 00bc .text$_ZNSt7collateIwEC1EPij 00c0 _ZTVSt7collateIwE"
	strings:
		$1 = { 00 48 2D E9 A8 30 9F E5 04 B0 8D E2 40 D0 4D E2 24 30 0B E5 9C 30 9F E5 40 00 0B E5 20 30 0B E5 94 30 9F E5 3C 00 4B E2 18 30 0B E5 04 30 4B E2 1C 30 0B E5 44 20 0B E5 08 10 0B E5 14 D0 0B E5 ?? ?? ?? ?? 44 20 1B E5 08 00 4B E2 00 30 52 E2 01 30 A0 13 40 20 1B E5 04 30 82 E5 5C 30 9F E5 00 30 82 E5 01 30 A0 E3 38 30 0B E5 ?? ?? ?? ?? 40 30 1B E5 08 00 83 E5 3C 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 34 20 1B E5 00 30 A0 E3 40 00 1B E5 38 30 0B E5 40 20 0B E5 ?? ?? ?? ?? 00 30 E0 E3 40 00 1B E5 38 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_191_3 {
	meta:
		name = "_ZNSt7collateIcEC1EPij"
		size = 196
		refs = "0040 _Unwind_SjLj_Register 006c _ZNSt6locale5facet17_S_clone_c_localeERPi 007c _Unwind_SjLj_Unregister 00a0 _ZNSt6locale5facetD2Ev 00b0 _Unwind_SjLj_Resume 00b4 __gxx_personality_sj0 00b8 .gcc_except_table 00bc .text$_ZNSt7collateIcEC1EPij 00c0 _ZTVSt7collateIcE"
	strings:
		$1 = { 00 48 2D E9 A8 30 9F E5 04 B0 8D E2 40 D0 4D E2 24 30 0B E5 9C 30 9F E5 40 00 0B E5 20 30 0B E5 94 30 9F E5 3C 00 4B E2 18 30 0B E5 04 30 4B E2 1C 30 0B E5 44 20 0B E5 08 10 0B E5 14 D0 0B E5 ?? ?? ?? ?? 44 20 1B E5 08 00 4B E2 00 30 52 E2 01 30 A0 13 40 20 1B E5 04 30 82 E5 5C 30 9F E5 00 30 82 E5 01 30 A0 E3 38 30 0B E5 ?? ?? ?? ?? 40 30 1B E5 08 00 83 E5 3C 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 34 20 1B E5 00 30 A0 E3 40 00 1B E5 38 30 0B E5 40 20 0B E5 ?? ?? ?? ?? 00 30 E0 E3 40 00 1B E5 38 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_192_3 {
	meta:
		name = "_ZNSt7collateIcEC2EPij"
		size = 196
		refs = "0040 _Unwind_SjLj_Register 006c _ZNSt6locale5facet17_S_clone_c_localeERPi 007c _Unwind_SjLj_Unregister 00a0 _ZNSt6locale5facetD2Ev 00b0 _Unwind_SjLj_Resume 00b4 __gxx_personality_sj0 00b8 .gcc_except_table 00bc .text$_ZNSt7collateIcEC2EPij 00c0 _ZTVSt7collateIcE"
	strings:
		$1 = { 00 48 2D E9 A8 30 9F E5 04 B0 8D E2 40 D0 4D E2 24 30 0B E5 9C 30 9F E5 40 00 0B E5 20 30 0B E5 94 30 9F E5 3C 00 4B E2 18 30 0B E5 04 30 4B E2 1C 30 0B E5 44 20 0B E5 08 10 0B E5 14 D0 0B E5 ?? ?? ?? ?? 44 20 1B E5 08 00 4B E2 00 30 52 E2 01 30 A0 13 40 20 1B E5 04 30 82 E5 5C 30 9F E5 00 30 82 E5 01 30 A0 E3 38 30 0B E5 ?? ?? ?? ?? 40 30 1B E5 08 00 83 E5 3C 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 34 20 1B E5 00 30 A0 E3 40 00 1B E5 38 30 0B E5 40 20 0B E5 ?? ?? ?? ?? 00 30 E0 E3 40 00 1B E5 38 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_191_3 {
	meta:
		name = "_ZNSt7collateIwEC2EPij"
		size = 196
		refs = "0040 _Unwind_SjLj_Register 006c _ZNSt6locale5facet17_S_clone_c_localeERPi 007c _Unwind_SjLj_Unregister 00a0 _ZNSt6locale5facetD2Ev 00b0 _Unwind_SjLj_Resume 00b4 __gxx_personality_sj0 00b8 .gcc_except_table 00bc .text$_ZNSt7collateIwEC2EPij 00c0 _ZTVSt7collateIwE"
	strings:
		$1 = { 00 48 2D E9 A8 30 9F E5 04 B0 8D E2 40 D0 4D E2 24 30 0B E5 9C 30 9F E5 40 00 0B E5 20 30 0B E5 94 30 9F E5 3C 00 4B E2 18 30 0B E5 04 30 4B E2 1C 30 0B E5 44 20 0B E5 08 10 0B E5 14 D0 0B E5 ?? ?? ?? ?? 44 20 1B E5 08 00 4B E2 00 30 52 E2 01 30 A0 13 40 20 1B E5 04 30 82 E5 5C 30 9F E5 00 30 82 E5 01 30 A0 E3 38 30 0B E5 ?? ?? ?? ?? 40 30 1B E5 08 00 83 E5 3C 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 34 20 1B E5 00 30 A0 E3 40 00 1B E5 38 30 0B E5 40 20 0B E5 ?? ?? ?? ?? 00 30 E0 E3 40 00 1B E5 38 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_192_3 {
	meta:
		name = "_ZNSt7collateIwEC1Ej"
		size = 188
		refs = "003c _Unwind_SjLj_Register 0064 _ZNSt6locale5facet15_S_get_c_localeEv 0074 _Unwind_SjLj_Unregister 0098 _ZNSt6locale5facetD2Ev 00a8 _Unwind_SjLj_Resume 00ac __gxx_personality_sj0 00b0 .gcc_except_table 00b4 .text$_ZNSt7collateIwEC1Ej 00b8 _ZTVSt7collateIwE"
	strings:
		$1 = { 00 48 2D E9 A0 30 9F E5 04 B0 8D E2 3C D0 4D E2 20 30 0B E5 94 30 9F E5 04 20 4B E2 1C 30 0B E5 8C 30 9F E5 3C 00 0B E5 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 40 10 0B E5 ?? ?? ?? ?? 40 20 1B E5 00 30 52 E2 01 30 A0 13 3C 20 1B E5 04 30 82 E5 5C 30 9F E5 00 30 82 E5 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 3C 30 1B E5 08 00 83 E5 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 30 20 1B E5 00 30 A0 E3 3C 00 1B E5 34 30 0B E5 3C 20 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_193_3 {
	meta:
		name = "_ZNSt7collateIcEC1Ej"
		size = 188
		refs = "003c _Unwind_SjLj_Register 0064 _ZNSt6locale5facet15_S_get_c_localeEv 0074 _Unwind_SjLj_Unregister 0098 _ZNSt6locale5facetD2Ev 00a8 _Unwind_SjLj_Resume 00ac __gxx_personality_sj0 00b0 .gcc_except_table 00b4 .text$_ZNSt7collateIcEC1Ej 00b8 _ZTVSt7collateIcE"
	strings:
		$1 = { 00 48 2D E9 A0 30 9F E5 04 B0 8D E2 3C D0 4D E2 20 30 0B E5 94 30 9F E5 04 20 4B E2 1C 30 0B E5 8C 30 9F E5 3C 00 0B E5 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 40 10 0B E5 ?? ?? ?? ?? 40 20 1B E5 00 30 52 E2 01 30 A0 13 3C 20 1B E5 04 30 82 E5 5C 30 9F E5 00 30 82 E5 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 3C 30 1B E5 08 00 83 E5 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 30 20 1B E5 00 30 A0 E3 3C 00 1B E5 34 30 0B E5 3C 20 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_194_3 {
	meta:
		name = "_ZNSt7collateIcEC2Ej"
		size = 188
		refs = "003c _Unwind_SjLj_Register 0064 _ZNSt6locale5facet15_S_get_c_localeEv 0074 _Unwind_SjLj_Unregister 0098 _ZNSt6locale5facetD2Ev 00a8 _Unwind_SjLj_Resume 00ac __gxx_personality_sj0 00b0 .gcc_except_table 00b4 .text$_ZNSt7collateIcEC2Ej 00b8 _ZTVSt7collateIcE"
	strings:
		$1 = { 00 48 2D E9 A0 30 9F E5 04 B0 8D E2 3C D0 4D E2 20 30 0B E5 94 30 9F E5 04 20 4B E2 1C 30 0B E5 8C 30 9F E5 3C 00 0B E5 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 40 10 0B E5 ?? ?? ?? ?? 40 20 1B E5 00 30 52 E2 01 30 A0 13 3C 20 1B E5 04 30 82 E5 5C 30 9F E5 00 30 82 E5 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 3C 30 1B E5 08 00 83 E5 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 30 20 1B E5 00 30 A0 E3 3C 00 1B E5 34 30 0B E5 3C 20 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_193_3 {
	meta:
		name = "_ZNSt7collateIwEC2Ej"
		size = 188
		refs = "003c _Unwind_SjLj_Register 0064 _ZNSt6locale5facet15_S_get_c_localeEv 0074 _Unwind_SjLj_Unregister 0098 _ZNSt6locale5facetD2Ev 00a8 _Unwind_SjLj_Resume 00ac __gxx_personality_sj0 00b0 .gcc_except_table 00b4 .text$_ZNSt7collateIwEC2Ej 00b8 _ZTVSt7collateIwE"
	strings:
		$1 = { 00 48 2D E9 A0 30 9F E5 04 B0 8D E2 3C D0 4D E2 20 30 0B E5 94 30 9F E5 04 20 4B E2 1C 30 0B E5 8C 30 9F E5 3C 00 0B E5 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 40 10 0B E5 ?? ?? ?? ?? 40 20 1B E5 00 30 52 E2 01 30 A0 13 3C 20 1B E5 04 30 82 E5 5C 30 9F E5 00 30 82 E5 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 3C 30 1B E5 08 00 83 E5 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 30 20 1B E5 00 30 A0 E3 3C 00 1B E5 34 30 0B E5 3C 20 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_197_3 {
	meta:
		name = "_ZNSt8messagesIcEC1Ej"
		size = 188
		refs = "003c _Unwind_SjLj_Register 0064 _ZNSt6locale5facet15_S_get_c_localeEv 0074 _Unwind_SjLj_Unregister 0098 _ZNSt6locale5facetD2Ev 00a8 _Unwind_SjLj_Resume 00ac __gxx_personality_sj0 00b0 .gcc_except_table 00b4 .text$_ZNSt8messagesIcEC1Ej 00b8 _ZTVSt8messagesIcE"
	strings:
		$1 = { 00 48 2D E9 A0 30 9F E5 04 B0 8D E2 3C D0 4D E2 20 30 0B E5 94 30 9F E5 04 20 4B E2 1C 30 0B E5 8C 30 9F E5 3C 00 0B E5 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 40 10 0B E5 ?? ?? ?? ?? 40 20 1B E5 00 30 52 E2 01 30 A0 13 3C 20 1B E5 04 30 82 E5 5C 30 9F E5 00 30 82 E5 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 3C 30 1B E5 08 00 83 E5 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 30 20 1B E5 00 30 A0 E3 3C 00 1B E5 34 30 0B E5 3C 20 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_198_3 {
	meta:
		name = "_ZNSt8messagesIcEC2Ej"
		size = 188
		refs = "003c _Unwind_SjLj_Register 0064 _ZNSt6locale5facet15_S_get_c_localeEv 0074 _Unwind_SjLj_Unregister 0098 _ZNSt6locale5facetD2Ev 00a8 _Unwind_SjLj_Resume 00ac __gxx_personality_sj0 00b0 .gcc_except_table 00b4 .text$_ZNSt8messagesIcEC2Ej 00b8 _ZTVSt8messagesIcE"
	strings:
		$1 = { 00 48 2D E9 A0 30 9F E5 04 B0 8D E2 3C D0 4D E2 20 30 0B E5 94 30 9F E5 04 20 4B E2 1C 30 0B E5 8C 30 9F E5 3C 00 0B E5 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 40 10 0B E5 ?? ?? ?? ?? 40 20 1B E5 00 30 52 E2 01 30 A0 13 3C 20 1B E5 04 30 82 E5 5C 30 9F E5 00 30 82 E5 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 3C 30 1B E5 08 00 83 E5 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 30 20 1B E5 00 30 A0 E3 3C 00 1B E5 34 30 0B E5 3C 20 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_196_3 {
	meta:
		name = "_ZNSt8messagesIwEC1Ej"
		size = 188
		refs = "003c _Unwind_SjLj_Register 0064 _ZNSt6locale5facet15_S_get_c_localeEv 0074 _Unwind_SjLj_Unregister 0098 _ZNSt6locale5facetD2Ev 00a8 _Unwind_SjLj_Resume 00ac __gxx_personality_sj0 00b0 .gcc_except_table 00b4 .text$_ZNSt8messagesIwEC1Ej 00b8 _ZTVSt8messagesIwE"
	strings:
		$1 = { 00 48 2D E9 A0 30 9F E5 04 B0 8D E2 3C D0 4D E2 20 30 0B E5 94 30 9F E5 04 20 4B E2 1C 30 0B E5 8C 30 9F E5 3C 00 0B E5 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 40 10 0B E5 ?? ?? ?? ?? 40 20 1B E5 00 30 52 E2 01 30 A0 13 3C 20 1B E5 04 30 82 E5 5C 30 9F E5 00 30 82 E5 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 3C 30 1B E5 08 00 83 E5 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 30 20 1B E5 00 30 A0 E3 3C 00 1B E5 34 30 0B E5 3C 20 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_197_3 {
	meta:
		name = "_ZNSt8messagesIwEC2Ej"
		size = 188
		refs = "003c _Unwind_SjLj_Register 0064 _ZNSt6locale5facet15_S_get_c_localeEv 0074 _Unwind_SjLj_Unregister 0098 _ZNSt6locale5facetD2Ev 00a8 _Unwind_SjLj_Resume 00ac __gxx_personality_sj0 00b0 .gcc_except_table 00b4 .text$_ZNSt8messagesIwEC2Ej 00b8 _ZTVSt8messagesIwE"
	strings:
		$1 = { 00 48 2D E9 A0 30 9F E5 04 B0 8D E2 3C D0 4D E2 20 30 0B E5 94 30 9F E5 04 20 4B E2 1C 30 0B E5 8C 30 9F E5 3C 00 0B E5 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 40 10 0B E5 ?? ?? ?? ?? 40 20 1B E5 00 30 52 E2 01 30 A0 13 3C 20 1B E5 04 30 82 E5 5C 30 9F E5 00 30 82 E5 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 3C 30 1B E5 08 00 83 E5 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 30 20 1B E5 00 30 A0 E3 3C 00 1B E5 34 30 0B E5 3C 20 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_194_3 {
	meta:
		name = "_ZNSt8messagesIwEC1EPiPKcj"
		size = 188
		refs = "003c _Unwind_SjLj_Register 0064 _ZNSt6locale5facet15_S_get_c_localeEv 0074 _Unwind_SjLj_Unregister 0098 _ZNSt6locale5facetD2Ev 00a8 _Unwind_SjLj_Resume 00ac __gxx_personality_sj0 00b0 .gcc_except_table 00b4 .text$_ZNSt8messagesIwEC1EPiPKcj 00b8 _ZTVSt8messagesIwE"
	strings:
		$1 = { 00 48 2D E9 A0 20 9F E5 04 B0 8D E2 3C D0 4D E2 20 20 0B E5 94 20 9F E5 3C 00 0B E5 1C 20 0B E5 8C 20 9F E5 38 00 4B E2 14 20 0B E5 04 20 4B E2 18 20 0B E5 40 30 0B E5 10 D0 0B E5 ?? ?? ?? ?? 40 20 1B E5 00 30 52 E2 01 30 A0 13 3C 20 1B E5 04 30 82 E5 5C 30 9F E5 00 30 82 E5 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 3C 30 1B E5 08 00 83 E5 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 30 20 1B E5 00 30 A0 E3 3C 00 1B E5 34 30 0B E5 3C 20 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_195_3 {
	meta:
		name = "_ZNSt8messagesIcEC1EPiPKcj"
		size = 188
		refs = "003c _Unwind_SjLj_Register 0064 _ZNSt6locale5facet15_S_get_c_localeEv 0074 _Unwind_SjLj_Unregister 0098 _ZNSt6locale5facetD2Ev 00a8 _Unwind_SjLj_Resume 00ac __gxx_personality_sj0 00b0 .gcc_except_table 00b4 .text$_ZNSt8messagesIcEC1EPiPKcj 00b8 _ZTVSt8messagesIcE"
	strings:
		$1 = { 00 48 2D E9 A0 20 9F E5 04 B0 8D E2 3C D0 4D E2 20 20 0B E5 94 20 9F E5 3C 00 0B E5 1C 20 0B E5 8C 20 9F E5 38 00 4B E2 14 20 0B E5 04 20 4B E2 18 20 0B E5 40 30 0B E5 10 D0 0B E5 ?? ?? ?? ?? 40 20 1B E5 00 30 52 E2 01 30 A0 13 3C 20 1B E5 04 30 82 E5 5C 30 9F E5 00 30 82 E5 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 3C 30 1B E5 08 00 83 E5 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 30 20 1B E5 00 30 A0 E3 3C 00 1B E5 34 30 0B E5 3C 20 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_196_3 {
	meta:
		name = "_ZNSt8messagesIcEC2EPiPKcj"
		size = 188
		refs = "003c _Unwind_SjLj_Register 0064 _ZNSt6locale5facet15_S_get_c_localeEv 0074 _Unwind_SjLj_Unregister 0098 _ZNSt6locale5facetD2Ev 00a8 _Unwind_SjLj_Resume 00ac __gxx_personality_sj0 00b0 .gcc_except_table 00b4 .text$_ZNSt8messagesIcEC2EPiPKcj 00b8 _ZTVSt8messagesIcE"
	strings:
		$1 = { 00 48 2D E9 A0 20 9F E5 04 B0 8D E2 3C D0 4D E2 20 20 0B E5 94 20 9F E5 3C 00 0B E5 1C 20 0B E5 8C 20 9F E5 38 00 4B E2 14 20 0B E5 04 20 4B E2 18 20 0B E5 40 30 0B E5 10 D0 0B E5 ?? ?? ?? ?? 40 20 1B E5 00 30 52 E2 01 30 A0 13 3C 20 1B E5 04 30 82 E5 5C 30 9F E5 00 30 82 E5 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 3C 30 1B E5 08 00 83 E5 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 30 20 1B E5 00 30 A0 E3 3C 00 1B E5 34 30 0B E5 3C 20 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_195_3 {
	meta:
		name = "_ZNSt8messagesIwEC2EPiPKcj"
		size = 188
		refs = "003c _Unwind_SjLj_Register 0064 _ZNSt6locale5facet15_S_get_c_localeEv 0074 _Unwind_SjLj_Unregister 0098 _ZNSt6locale5facetD2Ev 00a8 _Unwind_SjLj_Resume 00ac __gxx_personality_sj0 00b0 .gcc_except_table 00b4 .text$_ZNSt8messagesIwEC2EPiPKcj 00b8 _ZTVSt8messagesIwE"
	strings:
		$1 = { 00 48 2D E9 A0 20 9F E5 04 B0 8D E2 3C D0 4D E2 20 20 0B E5 94 20 9F E5 3C 00 0B E5 1C 20 0B E5 8C 20 9F E5 38 00 4B E2 14 20 0B E5 04 20 4B E2 18 20 0B E5 40 30 0B E5 10 D0 0B E5 ?? ?? ?? ?? 40 20 1B E5 00 30 52 E2 01 30 A0 13 3C 20 1B E5 04 30 82 E5 5C 30 9F E5 00 30 82 E5 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 3C 30 1B E5 08 00 83 E5 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 30 20 1B E5 00 30 A0 E3 3C 00 1B E5 34 30 0B E5 3C 20 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_198_3 {
	meta:
		name = "_ZNSt15messages_bynameIwEC1EPKcj"
		size = 272
		refs = "0040 _Unwind_SjLj_Register 0054 _ZNSt8messagesIwEC2Ej 006c strcmp 0094 _Unwind_SjLj_Unregister 00b8 _ZNSt6locale5facet19_S_destroy_c_localeERPi 00c8 _ZNSt6locale5facet18_S_create_c_localeERPiPKcS1_ 00e8 _ZNSt8messagesIwED2Ev 00f8 _Unwind_SjLj_Resume 00fc __gxx_personality_sj0 0100 .gcc_except_table 0104 .text$_ZNSt15messages_bynameIwEC1EPKcj 0108 _ZTVSt15messages_bynameIwE 010c .rdata"
	strings:
		$1 = { 00 48 2D E9 F0 30 9F E5 04 B0 8D E2 40 D0 4D E2 20 30 0B E5 E4 30 9F E5 3C 00 0B E5 1C 30 0B E5 DC 30 9F E5 38 00 4B E2 14 30 0B E5 04 30 4B E2 44 20 0B E5 18 30 0B E5 40 10 0B E5 10 D0 0B E5 ?? ?? ?? ?? 00 30 E0 E3 44 10 1B E5 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? A8 30 9F E5 3C 20 1B E5 40 00 1B E5 00 30 82 E5 9C 10 9F E5 ?? ?? ?? ?? 00 00 50 E3 05 00 00 0A 8C 30 9F E5 40 00 1B E5 04 10 83 E2 ?? ?? ?? ?? 00 00 50 E3 03 00 00 1A 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 3C 20 1B E5 01 30 A0 E3 08 20 82 E2 02 00 A0 E1 44 20 0B E5 34 30 0B E5 ?? ?? ?? ?? 44 00 1B E5 40 10 1B E5 00 20 A0 E3 ?? ?? ?? ?? EF FF FF EA 04 B0 8B E2 00 30 A0 E3 34 30 0B E5 30 30 1B E5 3C 00 1B E5 3C 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_204_3 {
	meta:
		name = "_ZNSt14codecvt_bynameIcciEC1EPKcj"
		size = 272
		refs = "0040 _Unwind_SjLj_Register 0054 _ZNSt7codecvtIcciEC2Ej 006c strcmp 0094 _Unwind_SjLj_Unregister 00b8 _ZNSt6locale5facet19_S_destroy_c_localeERPi 00c8 _ZNSt6locale5facet18_S_create_c_localeERPiPKcS1_ 00e8 _ZNSt7codecvtIcciED2Ev 00f8 _Unwind_SjLj_Resume 00fc __gxx_personality_sj0 0100 .gcc_except_table 0104 .text$_ZNSt14codecvt_bynameIcciEC1EPKcj 0108 _ZTVSt14codecvt_bynameIcciE 010c .rdata"
	strings:
		$1 = { 00 48 2D E9 F0 30 9F E5 04 B0 8D E2 40 D0 4D E2 20 30 0B E5 E4 30 9F E5 3C 00 0B E5 1C 30 0B E5 DC 30 9F E5 38 00 4B E2 14 30 0B E5 04 30 4B E2 44 20 0B E5 18 30 0B E5 40 10 0B E5 10 D0 0B E5 ?? ?? ?? ?? 00 30 E0 E3 44 10 1B E5 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? A8 30 9F E5 3C 20 1B E5 40 00 1B E5 00 30 82 E5 9C 10 9F E5 ?? ?? ?? ?? 00 00 50 E3 05 00 00 0A 8C 30 9F E5 40 00 1B E5 04 10 83 E2 ?? ?? ?? ?? 00 00 50 E3 03 00 00 1A 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 3C 20 1B E5 01 30 A0 E3 08 20 82 E2 02 00 A0 E1 44 20 0B E5 34 30 0B E5 ?? ?? ?? ?? 44 00 1B E5 40 10 1B E5 00 20 A0 E3 ?? ?? ?? ?? EF FF FF EA 04 B0 8B E2 00 30 A0 E3 34 30 0B E5 30 30 1B E5 3C 00 1B E5 3C 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_205_3 {
	meta:
		name = "_ZNSt14codecvt_bynameIcciEC2EPKcj"
		size = 272
		refs = "0040 _Unwind_SjLj_Register 0054 _ZNSt7codecvtIcciEC2Ej 006c strcmp 0094 _Unwind_SjLj_Unregister 00b8 _ZNSt6locale5facet19_S_destroy_c_localeERPi 00c8 _ZNSt6locale5facet18_S_create_c_localeERPiPKcS1_ 00e8 _ZNSt7codecvtIcciED2Ev 00f8 _Unwind_SjLj_Resume 00fc __gxx_personality_sj0 0100 .gcc_except_table 0104 .text$_ZNSt14codecvt_bynameIcciEC2EPKcj 0108 _ZTVSt14codecvt_bynameIcciE 010c .rdata"
	strings:
		$1 = { 00 48 2D E9 F0 30 9F E5 04 B0 8D E2 40 D0 4D E2 20 30 0B E5 E4 30 9F E5 3C 00 0B E5 1C 30 0B E5 DC 30 9F E5 38 00 4B E2 14 30 0B E5 04 30 4B E2 44 20 0B E5 18 30 0B E5 40 10 0B E5 10 D0 0B E5 ?? ?? ?? ?? 00 30 E0 E3 44 10 1B E5 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? A8 30 9F E5 3C 20 1B E5 40 00 1B E5 00 30 82 E5 9C 10 9F E5 ?? ?? ?? ?? 00 00 50 E3 05 00 00 0A 8C 30 9F E5 40 00 1B E5 04 10 83 E2 ?? ?? ?? ?? 00 00 50 E3 03 00 00 1A 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 3C 20 1B E5 01 30 A0 E3 08 20 82 E2 02 00 A0 E1 44 20 0B E5 34 30 0B E5 ?? ?? ?? ?? 44 00 1B E5 40 10 1B E5 00 20 A0 E3 ?? ?? ?? ?? EF FF FF EA 04 B0 8B E2 00 30 A0 E3 34 30 0B E5 30 30 1B E5 3C 00 1B E5 3C 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_203_3 {
	meta:
		name = "_ZNSt14codecvt_bynameIwciEC1EPKcj"
		size = 272
		refs = "0040 _Unwind_SjLj_Register 0054 _ZNSt7codecvtIwciEC2Ej 006c strcmp 0094 _Unwind_SjLj_Unregister 00b8 _ZNSt6locale5facet19_S_destroy_c_localeERPi 00c8 _ZNSt6locale5facet18_S_create_c_localeERPiPKcS1_ 00e8 _ZNSt7codecvtIwciED2Ev 00f8 _Unwind_SjLj_Resume 00fc __gxx_personality_sj0 0100 .gcc_except_table 0104 .text$_ZNSt14codecvt_bynameIwciEC1EPKcj 0108 _ZTVSt14codecvt_bynameIwciE 010c .rdata"
	strings:
		$1 = { 00 48 2D E9 F0 30 9F E5 04 B0 8D E2 40 D0 4D E2 20 30 0B E5 E4 30 9F E5 3C 00 0B E5 1C 30 0B E5 DC 30 9F E5 38 00 4B E2 14 30 0B E5 04 30 4B E2 44 20 0B E5 18 30 0B E5 40 10 0B E5 10 D0 0B E5 ?? ?? ?? ?? 00 30 E0 E3 44 10 1B E5 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? A8 30 9F E5 3C 20 1B E5 40 00 1B E5 00 30 82 E5 9C 10 9F E5 ?? ?? ?? ?? 00 00 50 E3 05 00 00 0A 8C 30 9F E5 40 00 1B E5 04 10 83 E2 ?? ?? ?? ?? 00 00 50 E3 03 00 00 1A 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 3C 20 1B E5 01 30 A0 E3 08 20 82 E2 02 00 A0 E1 44 20 0B E5 34 30 0B E5 ?? ?? ?? ?? 44 00 1B E5 40 10 1B E5 00 20 A0 E3 ?? ?? ?? ?? EF FF FF EA 04 B0 8B E2 00 30 A0 E3 34 30 0B E5 30 30 1B E5 3C 00 1B E5 3C 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_204_3 {
	meta:
		name = "_ZNSt14codecvt_bynameIwciEC2EPKcj"
		size = 272
		refs = "0040 _Unwind_SjLj_Register 0054 _ZNSt7codecvtIwciEC2Ej 006c strcmp 0094 _Unwind_SjLj_Unregister 00b8 _ZNSt6locale5facet19_S_destroy_c_localeERPi 00c8 _ZNSt6locale5facet18_S_create_c_localeERPiPKcS1_ 00e8 _ZNSt7codecvtIwciED2Ev 00f8 _Unwind_SjLj_Resume 00fc __gxx_personality_sj0 0100 .gcc_except_table 0104 .text$_ZNSt14codecvt_bynameIwciEC2EPKcj 0108 _ZTVSt14codecvt_bynameIwciE 010c .rdata"
	strings:
		$1 = { 00 48 2D E9 F0 30 9F E5 04 B0 8D E2 40 D0 4D E2 20 30 0B E5 E4 30 9F E5 3C 00 0B E5 1C 30 0B E5 DC 30 9F E5 38 00 4B E2 14 30 0B E5 04 30 4B E2 44 20 0B E5 18 30 0B E5 40 10 0B E5 10 D0 0B E5 ?? ?? ?? ?? 00 30 E0 E3 44 10 1B E5 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? A8 30 9F E5 3C 20 1B E5 40 00 1B E5 00 30 82 E5 9C 10 9F E5 ?? ?? ?? ?? 00 00 50 E3 05 00 00 0A 8C 30 9F E5 40 00 1B E5 04 10 83 E2 ?? ?? ?? ?? 00 00 50 E3 03 00 00 1A 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 3C 20 1B E5 01 30 A0 E3 08 20 82 E2 02 00 A0 E1 44 20 0B E5 34 30 0B E5 ?? ?? ?? ?? 44 00 1B E5 40 10 1B E5 00 20 A0 E3 ?? ?? ?? ?? EF FF FF EA 04 B0 8B E2 00 30 A0 E3 34 30 0B E5 30 30 1B E5 3C 00 1B E5 3C 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_199_3 {
	meta:
		name = "_ZNSt15messages_bynameIcEC1EPKcj"
		size = 272
		refs = "0040 _Unwind_SjLj_Register 0054 _ZNSt8messagesIcEC2Ej 006c strcmp 0094 _Unwind_SjLj_Unregister 00b8 _ZNSt6locale5facet19_S_destroy_c_localeERPi 00c8 _ZNSt6locale5facet18_S_create_c_localeERPiPKcS1_ 00e8 _ZNSt8messagesIcED2Ev 00f8 _Unwind_SjLj_Resume 00fc __gxx_personality_sj0 0100 .gcc_except_table 0104 .text$_ZNSt15messages_bynameIcEC1EPKcj 0108 _ZTVSt15messages_bynameIcE 010c .rdata"
	strings:
		$1 = { 00 48 2D E9 F0 30 9F E5 04 B0 8D E2 40 D0 4D E2 20 30 0B E5 E4 30 9F E5 3C 00 0B E5 1C 30 0B E5 DC 30 9F E5 38 00 4B E2 14 30 0B E5 04 30 4B E2 44 20 0B E5 18 30 0B E5 40 10 0B E5 10 D0 0B E5 ?? ?? ?? ?? 00 30 E0 E3 44 10 1B E5 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? A8 30 9F E5 3C 20 1B E5 40 00 1B E5 00 30 82 E5 9C 10 9F E5 ?? ?? ?? ?? 00 00 50 E3 05 00 00 0A 8C 30 9F E5 40 00 1B E5 04 10 83 E2 ?? ?? ?? ?? 00 00 50 E3 03 00 00 1A 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 3C 20 1B E5 01 30 A0 E3 08 20 82 E2 02 00 A0 E1 44 20 0B E5 34 30 0B E5 ?? ?? ?? ?? 44 00 1B E5 40 10 1B E5 00 20 A0 E3 ?? ?? ?? ?? EF FF FF EA 04 B0 8B E2 00 30 A0 E3 34 30 0B E5 30 30 1B E5 3C 00 1B E5 3C 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_200_3 {
	meta:
		name = "_ZNSt15messages_bynameIcEC2EPKcj"
		size = 272
		refs = "0040 _Unwind_SjLj_Register 0054 _ZNSt8messagesIcEC2Ej 006c strcmp 0094 _Unwind_SjLj_Unregister 00b8 _ZNSt6locale5facet19_S_destroy_c_localeERPi 00c8 _ZNSt6locale5facet18_S_create_c_localeERPiPKcS1_ 00e8 _ZNSt8messagesIcED2Ev 00f8 _Unwind_SjLj_Resume 00fc __gxx_personality_sj0 0100 .gcc_except_table 0104 .text$_ZNSt15messages_bynameIcEC2EPKcj 0108 _ZTVSt15messages_bynameIcE 010c .rdata"
	strings:
		$1 = { 00 48 2D E9 F0 30 9F E5 04 B0 8D E2 40 D0 4D E2 20 30 0B E5 E4 30 9F E5 3C 00 0B E5 1C 30 0B E5 DC 30 9F E5 38 00 4B E2 14 30 0B E5 04 30 4B E2 44 20 0B E5 18 30 0B E5 40 10 0B E5 10 D0 0B E5 ?? ?? ?? ?? 00 30 E0 E3 44 10 1B E5 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? A8 30 9F E5 3C 20 1B E5 40 00 1B E5 00 30 82 E5 9C 10 9F E5 ?? ?? ?? ?? 00 00 50 E3 05 00 00 0A 8C 30 9F E5 40 00 1B E5 04 10 83 E2 ?? ?? ?? ?? 00 00 50 E3 03 00 00 1A 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 3C 20 1B E5 01 30 A0 E3 08 20 82 E2 02 00 A0 E1 44 20 0B E5 34 30 0B E5 ?? ?? ?? ?? 44 00 1B E5 40 10 1B E5 00 20 A0 E3 ?? ?? ?? ?? EF FF FF EA 04 B0 8B E2 00 30 A0 E3 34 30 0B E5 30 30 1B E5 3C 00 1B E5 3C 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_199_3 {
	meta:
		name = "_ZNSt15messages_bynameIwEC2EPKcj"
		size = 272
		refs = "0040 _Unwind_SjLj_Register 0054 _ZNSt8messagesIwEC2Ej 006c strcmp 0094 _Unwind_SjLj_Unregister 00b8 _ZNSt6locale5facet19_S_destroy_c_localeERPi 00c8 _ZNSt6locale5facet18_S_create_c_localeERPiPKcS1_ 00e8 _ZNSt8messagesIwED2Ev 00f8 _Unwind_SjLj_Resume 00fc __gxx_personality_sj0 0100 .gcc_except_table 0104 .text$_ZNSt15messages_bynameIwEC2EPKcj 0108 _ZTVSt15messages_bynameIwE 010c .rdata"
	strings:
		$1 = { 00 48 2D E9 F0 30 9F E5 04 B0 8D E2 40 D0 4D E2 20 30 0B E5 E4 30 9F E5 3C 00 0B E5 1C 30 0B E5 DC 30 9F E5 38 00 4B E2 14 30 0B E5 04 30 4B E2 44 20 0B E5 18 30 0B E5 40 10 0B E5 10 D0 0B E5 ?? ?? ?? ?? 00 30 E0 E3 44 10 1B E5 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? A8 30 9F E5 3C 20 1B E5 40 00 1B E5 00 30 82 E5 9C 10 9F E5 ?? ?? ?? ?? 00 00 50 E3 05 00 00 0A 8C 30 9F E5 40 00 1B E5 04 10 83 E2 ?? ?? ?? ?? 00 00 50 E3 03 00 00 1A 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 3C 20 1B E5 01 30 A0 E3 08 20 82 E2 02 00 A0 E1 44 20 0B E5 34 30 0B E5 ?? ?? ?? ?? 44 00 1B E5 40 10 1B E5 00 20 A0 E3 ?? ?? ?? ?? EF FF FF EA 04 B0 8B E2 00 30 A0 E3 34 30 0B E5 30 30 1B E5 3C 00 1B E5 3C 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_205_3 {
	meta:
		name = "_ZNSt11__timepunctIwED0Ev"
		size = 280
		refs = "0038 _Unwind_SjLj_Register 0058 _ZNSt6locale5facet13_S_get_c_nameEv 0074 _ZdaPv 00b0 _ZNSt6locale5facet19_S_destroy_c_localeERPi 00c0 _ZNSt6locale5facetD2Ev 00c8 _ZdlPv 00d0 _Unwind_SjLj_Unregister 0104 _Unwind_SjLj_Resume 0108 __gxx_personality_sj0 010c .gcc_except_table 0110 .text$_ZNSt11__timepunctIwED0Ev 0114 _ZTVSt11__timepunctIwE"
	strings:
		$1 = { 00 48 2D E9 FC 30 9F E5 04 B0 8D E2 3C D0 4D E2 20 30 0B E5 F0 30 9F E5 04 20 4B E2 1C 30 0B E5 E8 30 9F E5 3C 00 0B E5 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? D0 30 9F E5 3C 20 1B E5 00 30 82 E5 10 30 92 E5 40 30 0B E5 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 40 20 1B E5 00 00 52 E1 03 00 00 0A 3C 30 1B E5 10 00 93 E5 00 00 50 E3 ?? ?? ?? ?? 3C 20 1B E5 08 00 92 E5 00 00 50 E3 05 00 00 0A 00 30 90 E5 01 20 A0 E3 04 30 93 E5 34 20 0B E5 0F E0 A0 E1 03 F0 A0 E1 01 30 A0 E3 34 30 0B E5 3C 30 1B E5 0C 00 83 E2 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 3C 00 1B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 30 20 1B E5 00 30 A0 E3 3C 00 1B E5 34 30 0B E5 3C 20 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_206_3 {
	meta:
		name = "_ZNSt11__timepunctIcED0Ev"
		size = 280
		refs = "0038 _Unwind_SjLj_Register 0058 _ZNSt6locale5facet13_S_get_c_nameEv 0074 _ZdaPv 00b0 _ZNSt6locale5facet19_S_destroy_c_localeERPi 00c0 _ZNSt6locale5facetD2Ev 00c8 _ZdlPv 00d0 _Unwind_SjLj_Unregister 0104 _Unwind_SjLj_Resume 0108 __gxx_personality_sj0 010c .gcc_except_table 0110 .text$_ZNSt11__timepunctIcED0Ev 0114 _ZTVSt11__timepunctIcE"
	strings:
		$1 = { 00 48 2D E9 FC 30 9F E5 04 B0 8D E2 3C D0 4D E2 20 30 0B E5 F0 30 9F E5 04 20 4B E2 1C 30 0B E5 E8 30 9F E5 3C 00 0B E5 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? D0 30 9F E5 3C 20 1B E5 00 30 82 E5 10 30 92 E5 40 30 0B E5 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 40 20 1B E5 00 00 52 E1 03 00 00 0A 3C 30 1B E5 10 00 93 E5 00 00 50 E3 ?? ?? ?? ?? 3C 20 1B E5 08 00 92 E5 00 00 50 E3 05 00 00 0A 00 30 90 E5 01 20 A0 E3 04 30 93 E5 34 20 0B E5 0F E0 A0 E1 03 F0 A0 E1 01 30 A0 E3 34 30 0B E5 3C 30 1B E5 0C 00 83 E2 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 3C 00 1B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 30 20 1B E5 00 30 A0 E3 3C 00 1B E5 34 30 0B E5 3C 20 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_206_3 {
	meta:
		name = "_ZNSt11__timepunctIwED1Ev"
		size = 272
		refs = "0038 _Unwind_SjLj_Register 0058 _ZNSt6locale5facet13_S_get_c_nameEv 0074 _ZdaPv 00b0 _ZNSt6locale5facet19_S_destroy_c_localeERPi 00c0 _ZNSt6locale5facetD2Ev 00c8 _Unwind_SjLj_Unregister 00fc _Unwind_SjLj_Resume 0100 __gxx_personality_sj0 0104 .gcc_except_table 0108 .text$_ZNSt11__timepunctIwED1Ev 010c _ZTVSt11__timepunctIwE"
	strings:
		$1 = { 00 48 2D E9 F4 30 9F E5 04 B0 8D E2 3C D0 4D E2 20 30 0B E5 E8 30 9F E5 04 20 4B E2 1C 30 0B E5 E0 30 9F E5 3C 00 0B E5 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? C8 30 9F E5 3C 20 1B E5 00 30 82 E5 10 30 92 E5 40 30 0B E5 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 40 20 1B E5 00 00 52 E1 03 00 00 0A 3C 30 1B E5 10 00 93 E5 00 00 50 E3 ?? ?? ?? ?? 3C 20 1B E5 08 00 92 E5 00 00 50 E3 05 00 00 0A 00 30 90 E5 01 20 A0 E3 04 30 93 E5 34 20 0B E5 0F E0 A0 E1 03 F0 A0 E1 01 30 A0 E3 34 30 0B E5 3C 30 1B E5 0C 00 83 E2 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 30 20 1B E5 00 30 A0 E3 3C 00 1B E5 34 30 0B E5 3C 20 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_207_3 {
	meta:
		name = "_ZNSt11__timepunctIcED1Ev"
		size = 272
		refs = "0038 _Unwind_SjLj_Register 0058 _ZNSt6locale5facet13_S_get_c_nameEv 0074 _ZdaPv 00b0 _ZNSt6locale5facet19_S_destroy_c_localeERPi 00c0 _ZNSt6locale5facetD2Ev 00c8 _Unwind_SjLj_Unregister 00fc _Unwind_SjLj_Resume 0100 __gxx_personality_sj0 0104 .gcc_except_table 0108 .text$_ZNSt11__timepunctIcED1Ev 010c _ZTVSt11__timepunctIcE"
	strings:
		$1 = { 00 48 2D E9 F4 30 9F E5 04 B0 8D E2 3C D0 4D E2 20 30 0B E5 E8 30 9F E5 04 20 4B E2 1C 30 0B E5 E0 30 9F E5 3C 00 0B E5 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? C8 30 9F E5 3C 20 1B E5 00 30 82 E5 10 30 92 E5 40 30 0B E5 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 40 20 1B E5 00 00 52 E1 03 00 00 0A 3C 30 1B E5 10 00 93 E5 00 00 50 E3 ?? ?? ?? ?? 3C 20 1B E5 08 00 92 E5 00 00 50 E3 05 00 00 0A 00 30 90 E5 01 20 A0 E3 04 30 93 E5 34 20 0B E5 0F E0 A0 E1 03 F0 A0 E1 01 30 A0 E3 34 30 0B E5 3C 30 1B E5 0C 00 83 E2 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 30 20 1B E5 00 30 A0 E3 3C 00 1B E5 34 30 0B E5 3C 20 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_208_3 {
	meta:
		name = "_ZNSt11__timepunctIcED2Ev"
		size = 272
		refs = "0038 _Unwind_SjLj_Register 0058 _ZNSt6locale5facet13_S_get_c_nameEv 0074 _ZdaPv 00b0 _ZNSt6locale5facet19_S_destroy_c_localeERPi 00c0 _ZNSt6locale5facetD2Ev 00c8 _Unwind_SjLj_Unregister 00fc _Unwind_SjLj_Resume 0100 __gxx_personality_sj0 0104 .gcc_except_table 0108 .text$_ZNSt11__timepunctIcED2Ev 010c _ZTVSt11__timepunctIcE"
	strings:
		$1 = { 00 48 2D E9 F4 30 9F E5 04 B0 8D E2 3C D0 4D E2 20 30 0B E5 E8 30 9F E5 04 20 4B E2 1C 30 0B E5 E0 30 9F E5 3C 00 0B E5 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? C8 30 9F E5 3C 20 1B E5 00 30 82 E5 10 30 92 E5 40 30 0B E5 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 40 20 1B E5 00 00 52 E1 03 00 00 0A 3C 30 1B E5 10 00 93 E5 00 00 50 E3 ?? ?? ?? ?? 3C 20 1B E5 08 00 92 E5 00 00 50 E3 05 00 00 0A 00 30 90 E5 01 20 A0 E3 04 30 93 E5 34 20 0B E5 0F E0 A0 E1 03 F0 A0 E1 01 30 A0 E3 34 30 0B E5 3C 30 1B E5 0C 00 83 E2 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 30 20 1B E5 00 30 A0 E3 3C 00 1B E5 34 30 0B E5 3C 20 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_207_3 {
	meta:
		name = "_ZNSt11__timepunctIwED2Ev"
		size = 272
		refs = "0038 _Unwind_SjLj_Register 0058 _ZNSt6locale5facet13_S_get_c_nameEv 0074 _ZdaPv 00b0 _ZNSt6locale5facet19_S_destroy_c_localeERPi 00c0 _ZNSt6locale5facetD2Ev 00c8 _Unwind_SjLj_Unregister 00fc _Unwind_SjLj_Resume 0100 __gxx_personality_sj0 0104 .gcc_except_table 0108 .text$_ZNSt11__timepunctIwED2Ev 010c _ZTVSt11__timepunctIwE"
	strings:
		$1 = { 00 48 2D E9 F4 30 9F E5 04 B0 8D E2 3C D0 4D E2 20 30 0B E5 E8 30 9F E5 04 20 4B E2 1C 30 0B E5 E0 30 9F E5 3C 00 0B E5 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? C8 30 9F E5 3C 20 1B E5 00 30 82 E5 10 30 92 E5 40 30 0B E5 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 40 20 1B E5 00 00 52 E1 03 00 00 0A 3C 30 1B E5 10 00 93 E5 00 00 50 E3 ?? ?? ?? ?? 3C 20 1B E5 08 00 92 E5 00 00 50 E3 05 00 00 0A 00 30 90 E5 01 20 A0 E3 04 30 93 E5 34 20 0B E5 0F E0 A0 E1 03 F0 A0 E1 01 30 A0 E3 34 30 0B E5 3C 30 1B E5 0C 00 83 E2 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 30 20 1B E5 00 30 A0 E3 3C 00 1B E5 34 30 0B E5 3C 20 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_208_3 {
	meta:
		name = "_ZNSt11__timepunctIwEC1EPiPKcj"
		size = 412
		refs = "0044 _Unwind_SjLj_Register 0074 _ZNSt6locale5facet13_S_get_c_nameEv 0080 strcmp 0090 strlen 009c _Znaj 00ac memcpy 00cc _ZNSt11__timepunctIwE23_M_initialize_timepunctEPi 00d4 _Unwind_SjLj_Unregister 0120 __cxa_end_catch 0130 _ZNSt6locale5facetD2Ev 0140 _Unwind_SjLj_Resume 0148 __cxa_begin_catch 017c _ZdaPv 0188 __cxa_rethrow 018c __gxx_personality_sj0 0190 .gcc_except_table 0194 .text$_ZNSt11__timepunctIwEC1EPiPKcj 0198 _ZTVSt11__timepunctIwE"
	strings:
		$1 = { 00 48 2D E9 80 C1 9F E5 04 B0 8D E2 48 D0 4D E2 20 C0 0B E5 74 C1 9F E5 3C 00 0B E5 1C C0 0B E5 04 00 4B E2 68 C1 9F E5 18 00 0B E5 38 00 4B E2 40 30 0B E5 44 20 0B E5 14 C0 0B E5 10 D0 0B E5 48 10 0B E5 ?? ?? ?? ?? 40 20 1B E5 3C 00 1B E5 00 30 52 E2 01 30 A0 13 04 30 80 E5 34 31 9F E5 00 30 80 E5 00 30 A0 E3 08 30 80 E5 03 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 00 10 A0 E1 44 00 1B E5 ?? ?? ?? ?? 00 00 50 E3 14 00 00 0A 44 00 1B E5 ?? ?? ?? ?? 01 00 80 E2 40 00 0B E5 ?? ?? ?? ?? 40 20 1B E5 44 10 1B E5 4C 00 0B E5 ?? ?? ?? ?? 4C 20 1B E5 3C 30 1B E5 10 20 83 E5 02 30 A0 E3 48 10 1B E5 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 03 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 3C 20 1B E5 10 00 82 E5 F0 FF FF EA 04 B0 8B E2 34 00 1B E5 30 20 1B E5 01 00 50 E3 44 00 0B E5 48 20 0B E5 0B 00 00 0A 02 00 50 E3 00 30 A0 13 34 30 0B 15 ?? ?? ?? ?? 00 30 A0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 48 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 48 00 1B E5 ?? ?? ?? ?? 3C 30 1B E5 44 00 1B E5 10 30 93 E5 34 00 0B E5 48 30 0B E5 ?? ?? ?? ?? 48 20 1B E5 00 00 52 E1 03 00 00 0A 3C 30 1B E5 10 00 93 E5 00 00 50 E3 ?? ?? ?? ?? 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_209_3 {
	meta:
		name = "_ZNSt11__timepunctIcEC1EPiPKcj"
		size = 412
		refs = "0044 _Unwind_SjLj_Register 0074 _ZNSt6locale5facet13_S_get_c_nameEv 0080 strcmp 0090 strlen 009c _Znaj 00ac memcpy 00cc _ZNSt11__timepunctIcE23_M_initialize_timepunctEPi 00d4 _Unwind_SjLj_Unregister 0120 __cxa_end_catch 0130 _ZNSt6locale5facetD2Ev 0140 _Unwind_SjLj_Resume 0148 __cxa_begin_catch 017c _ZdaPv 0188 __cxa_rethrow 018c __gxx_personality_sj0 0190 .gcc_except_table 0194 .text$_ZNSt11__timepunctIcEC1EPiPKcj 0198 _ZTVSt11__timepunctIcE"
	strings:
		$1 = { 00 48 2D E9 80 C1 9F E5 04 B0 8D E2 48 D0 4D E2 20 C0 0B E5 74 C1 9F E5 3C 00 0B E5 1C C0 0B E5 04 00 4B E2 68 C1 9F E5 18 00 0B E5 38 00 4B E2 40 30 0B E5 44 20 0B E5 14 C0 0B E5 10 D0 0B E5 48 10 0B E5 ?? ?? ?? ?? 40 20 1B E5 3C 00 1B E5 00 30 52 E2 01 30 A0 13 04 30 80 E5 34 31 9F E5 00 30 80 E5 00 30 A0 E3 08 30 80 E5 03 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 00 10 A0 E1 44 00 1B E5 ?? ?? ?? ?? 00 00 50 E3 14 00 00 0A 44 00 1B E5 ?? ?? ?? ?? 01 00 80 E2 40 00 0B E5 ?? ?? ?? ?? 40 20 1B E5 44 10 1B E5 4C 00 0B E5 ?? ?? ?? ?? 4C 20 1B E5 3C 30 1B E5 10 20 83 E5 02 30 A0 E3 48 10 1B E5 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 03 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 3C 20 1B E5 10 00 82 E5 F0 FF FF EA 04 B0 8B E2 34 00 1B E5 30 20 1B E5 01 00 50 E3 44 00 0B E5 48 20 0B E5 0B 00 00 0A 02 00 50 E3 00 30 A0 13 34 30 0B 15 ?? ?? ?? ?? 00 30 A0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 48 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 48 00 1B E5 ?? ?? ?? ?? 3C 30 1B E5 44 00 1B E5 10 30 93 E5 34 00 0B E5 48 30 0B E5 ?? ?? ?? ?? 48 20 1B E5 00 00 52 E1 03 00 00 0A 3C 30 1B E5 10 00 93 E5 00 00 50 E3 ?? ?? ?? ?? 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_210_3 {
	meta:
		name = "_ZNSt11__timepunctIcEC2EPiPKcj"
		size = 412
		refs = "0044 _Unwind_SjLj_Register 0074 _ZNSt6locale5facet13_S_get_c_nameEv 0080 strcmp 0090 strlen 009c _Znaj 00ac memcpy 00cc _ZNSt11__timepunctIcE23_M_initialize_timepunctEPi 00d4 _Unwind_SjLj_Unregister 0120 __cxa_end_catch 0130 _ZNSt6locale5facetD2Ev 0140 _Unwind_SjLj_Resume 0148 __cxa_begin_catch 017c _ZdaPv 0188 __cxa_rethrow 018c __gxx_personality_sj0 0190 .gcc_except_table 0194 .text$_ZNSt11__timepunctIcEC2EPiPKcj 0198 _ZTVSt11__timepunctIcE"
	strings:
		$1 = { 00 48 2D E9 80 C1 9F E5 04 B0 8D E2 48 D0 4D E2 20 C0 0B E5 74 C1 9F E5 3C 00 0B E5 1C C0 0B E5 04 00 4B E2 68 C1 9F E5 18 00 0B E5 38 00 4B E2 40 30 0B E5 44 20 0B E5 14 C0 0B E5 10 D0 0B E5 48 10 0B E5 ?? ?? ?? ?? 40 20 1B E5 3C 00 1B E5 00 30 52 E2 01 30 A0 13 04 30 80 E5 34 31 9F E5 00 30 80 E5 00 30 A0 E3 08 30 80 E5 03 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 00 10 A0 E1 44 00 1B E5 ?? ?? ?? ?? 00 00 50 E3 14 00 00 0A 44 00 1B E5 ?? ?? ?? ?? 01 00 80 E2 40 00 0B E5 ?? ?? ?? ?? 40 20 1B E5 44 10 1B E5 4C 00 0B E5 ?? ?? ?? ?? 4C 20 1B E5 3C 30 1B E5 10 20 83 E5 02 30 A0 E3 48 10 1B E5 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 03 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 3C 20 1B E5 10 00 82 E5 F0 FF FF EA 04 B0 8B E2 34 00 1B E5 30 20 1B E5 01 00 50 E3 44 00 0B E5 48 20 0B E5 0B 00 00 0A 02 00 50 E3 00 30 A0 13 34 30 0B 15 ?? ?? ?? ?? 00 30 A0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 48 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 48 00 1B E5 ?? ?? ?? ?? 3C 30 1B E5 44 00 1B E5 10 30 93 E5 34 00 0B E5 48 30 0B E5 ?? ?? ?? ?? 48 20 1B E5 00 00 52 E1 03 00 00 0A 3C 30 1B E5 10 00 93 E5 00 00 50 E3 ?? ?? ?? ?? 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_209_3 {
	meta:
		name = "_ZNSt11__timepunctIwEC2EPiPKcj"
		size = 412
		refs = "0044 _Unwind_SjLj_Register 0074 _ZNSt6locale5facet13_S_get_c_nameEv 0080 strcmp 0090 strlen 009c _Znaj 00ac memcpy 00cc _ZNSt11__timepunctIwE23_M_initialize_timepunctEPi 00d4 _Unwind_SjLj_Unregister 0120 __cxa_end_catch 0130 _ZNSt6locale5facetD2Ev 0140 _Unwind_SjLj_Resume 0148 __cxa_begin_catch 017c _ZdaPv 0188 __cxa_rethrow 018c __gxx_personality_sj0 0190 .gcc_except_table 0194 .text$_ZNSt11__timepunctIwEC2EPiPKcj 0198 _ZTVSt11__timepunctIwE"
	strings:
		$1 = { 00 48 2D E9 80 C1 9F E5 04 B0 8D E2 48 D0 4D E2 20 C0 0B E5 74 C1 9F E5 3C 00 0B E5 1C C0 0B E5 04 00 4B E2 68 C1 9F E5 18 00 0B E5 38 00 4B E2 40 30 0B E5 44 20 0B E5 14 C0 0B E5 10 D0 0B E5 48 10 0B E5 ?? ?? ?? ?? 40 20 1B E5 3C 00 1B E5 00 30 52 E2 01 30 A0 13 04 30 80 E5 34 31 9F E5 00 30 80 E5 00 30 A0 E3 08 30 80 E5 03 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 00 10 A0 E1 44 00 1B E5 ?? ?? ?? ?? 00 00 50 E3 14 00 00 0A 44 00 1B E5 ?? ?? ?? ?? 01 00 80 E2 40 00 0B E5 ?? ?? ?? ?? 40 20 1B E5 44 10 1B E5 4C 00 0B E5 ?? ?? ?? ?? 4C 20 1B E5 3C 30 1B E5 10 20 83 E5 02 30 A0 E3 48 10 1B E5 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 03 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 3C 20 1B E5 10 00 82 E5 F0 FF FF EA 04 B0 8B E2 34 00 1B E5 30 20 1B E5 01 00 50 E3 44 00 0B E5 48 20 0B E5 0B 00 00 0A 02 00 50 E3 00 30 A0 13 34 30 0B 15 ?? ?? ?? ?? 00 30 A0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 48 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 48 00 1B E5 ?? ?? ?? ?? 3C 30 1B E5 44 00 1B E5 10 30 93 E5 34 00 0B E5 48 30 0B E5 ?? ?? ?? ?? 48 20 1B E5 00 00 52 E1 03 00 00 0A 3C 30 1B E5 10 00 93 E5 00 00 50 E3 ?? ?? ?? ?? 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_210_3 {
	meta:
		name = "_ZNSt11__timepunctIwEC1EPSt17__timepunct_cacheIwEj"
		size = 212
		refs = "0040 _Unwind_SjLj_Register 0070 _ZNSt6locale5facet13_S_get_c_nameEv 0084 _ZNSt11__timepunctIwE23_M_initialize_timepunctEPi 008c _Unwind_SjLj_Unregister 00b0 _ZNSt6locale5facetD2Ev 00c0 _Unwind_SjLj_Resume 00c4 __gxx_personality_sj0 00c8 .gcc_except_table 00cc .text$_ZNSt11__timepunctIwEC1EPSt17__timepunct_cacheIwEj 00d0 _ZTVSt11__timepunctIwE"
	strings:
		$1 = { 00 48 2D E9 B8 30 9F E5 04 B0 8D E2 40 D0 4D E2 20 30 0B E5 AC 30 9F E5 3C 00 0B E5 1C 30 0B E5 A4 30 9F E5 38 00 4B E2 14 30 0B E5 04 30 4B E2 18 30 0B E5 44 20 0B E5 10 D0 0B E5 40 10 0B E5 ?? ?? ?? ?? 44 20 1B E5 00 30 52 E2 01 30 A0 13 3C 20 1B E5 04 30 82 E5 70 30 9F E5 00 30 82 E5 40 30 1B E5 08 30 82 E5 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 3C 20 1B E5 00 10 A0 E3 10 00 82 E5 02 00 A0 E1 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 A0 E3 34 30 0B E5 30 30 1B E5 3C 00 1B E5 3C 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_211_3 {
	meta:
		name = "_ZNSt11__timepunctIcEC1EPSt17__timepunct_cacheIcEj"
		size = 212
		refs = "0040 _Unwind_SjLj_Register 0070 _ZNSt6locale5facet13_S_get_c_nameEv 0084 _ZNSt11__timepunctIcE23_M_initialize_timepunctEPi 008c _Unwind_SjLj_Unregister 00b0 _ZNSt6locale5facetD2Ev 00c0 _Unwind_SjLj_Resume 00c4 __gxx_personality_sj0 00c8 .gcc_except_table 00cc .text$_ZNSt11__timepunctIcEC1EPSt17__timepunct_cacheIcEj 00d0 _ZTVSt11__timepunctIcE"
	strings:
		$1 = { 00 48 2D E9 B8 30 9F E5 04 B0 8D E2 40 D0 4D E2 20 30 0B E5 AC 30 9F E5 3C 00 0B E5 1C 30 0B E5 A4 30 9F E5 38 00 4B E2 14 30 0B E5 04 30 4B E2 18 30 0B E5 44 20 0B E5 10 D0 0B E5 40 10 0B E5 ?? ?? ?? ?? 44 20 1B E5 00 30 52 E2 01 30 A0 13 3C 20 1B E5 04 30 82 E5 70 30 9F E5 00 30 82 E5 40 30 1B E5 08 30 82 E5 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 3C 20 1B E5 00 10 A0 E3 10 00 82 E5 02 00 A0 E1 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 A0 E3 34 30 0B E5 30 30 1B E5 3C 00 1B E5 3C 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_212_3 {
	meta:
		name = "_ZNSt11__timepunctIcEC2EPSt17__timepunct_cacheIcEj"
		size = 212
		refs = "0040 _Unwind_SjLj_Register 0070 _ZNSt6locale5facet13_S_get_c_nameEv 0084 _ZNSt11__timepunctIcE23_M_initialize_timepunctEPi 008c _Unwind_SjLj_Unregister 00b0 _ZNSt6locale5facetD2Ev 00c0 _Unwind_SjLj_Resume 00c4 __gxx_personality_sj0 00c8 .gcc_except_table 00cc .text$_ZNSt11__timepunctIcEC2EPSt17__timepunct_cacheIcEj 00d0 _ZTVSt11__timepunctIcE"
	strings:
		$1 = { 00 48 2D E9 B8 30 9F E5 04 B0 8D E2 40 D0 4D E2 20 30 0B E5 AC 30 9F E5 3C 00 0B E5 1C 30 0B E5 A4 30 9F E5 38 00 4B E2 14 30 0B E5 04 30 4B E2 18 30 0B E5 44 20 0B E5 10 D0 0B E5 40 10 0B E5 ?? ?? ?? ?? 44 20 1B E5 00 30 52 E2 01 30 A0 13 3C 20 1B E5 04 30 82 E5 70 30 9F E5 00 30 82 E5 40 30 1B E5 08 30 82 E5 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 3C 20 1B E5 00 10 A0 E3 10 00 82 E5 02 00 A0 E1 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 A0 E3 34 30 0B E5 30 30 1B E5 3C 00 1B E5 3C 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_211_3 {
	meta:
		name = "_ZNSt11__timepunctIwEC2EPSt17__timepunct_cacheIwEj"
		size = 212
		refs = "0040 _Unwind_SjLj_Register 0070 _ZNSt6locale5facet13_S_get_c_nameEv 0084 _ZNSt11__timepunctIwE23_M_initialize_timepunctEPi 008c _Unwind_SjLj_Unregister 00b0 _ZNSt6locale5facetD2Ev 00c0 _Unwind_SjLj_Resume 00c4 __gxx_personality_sj0 00c8 .gcc_except_table 00cc .text$_ZNSt11__timepunctIwEC2EPSt17__timepunct_cacheIwEj 00d0 _ZTVSt11__timepunctIwE"
	strings:
		$1 = { 00 48 2D E9 B8 30 9F E5 04 B0 8D E2 40 D0 4D E2 20 30 0B E5 AC 30 9F E5 3C 00 0B E5 1C 30 0B E5 A4 30 9F E5 38 00 4B E2 14 30 0B E5 04 30 4B E2 18 30 0B E5 44 20 0B E5 10 D0 0B E5 40 10 0B E5 ?? ?? ?? ?? 44 20 1B E5 00 30 52 E2 01 30 A0 13 3C 20 1B E5 04 30 82 E5 70 30 9F E5 00 30 82 E5 40 30 1B E5 08 30 82 E5 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 3C 20 1B E5 00 10 A0 E3 10 00 82 E5 02 00 A0 E1 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 A0 E3 34 30 0B E5 30 30 1B E5 3C 00 1B E5 3C 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_212_3 {
	meta:
		name = "_ZNSt11__timepunctIwEC1Ej"
		size = 208
		refs = "003c _Unwind_SjLj_Register 006c _ZNSt6locale5facet13_S_get_c_nameEv 0080 _ZNSt11__timepunctIwE23_M_initialize_timepunctEPi 0088 _Unwind_SjLj_Unregister 00ac _ZNSt6locale5facetD2Ev 00bc _Unwind_SjLj_Resume 00c0 __gxx_personality_sj0 00c4 .gcc_except_table 00c8 .text$_ZNSt11__timepunctIwEC1Ej 00cc _ZTVSt11__timepunctIwE"
	strings:
		$1 = { 00 48 2D E9 B4 30 9F E5 04 B0 8D E2 3C D0 4D E2 20 30 0B E5 A8 30 9F E5 04 20 4B E2 1C 30 0B E5 A0 30 9F E5 3C 00 0B E5 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 40 10 0B E5 ?? ?? ?? ?? 40 20 1B E5 00 30 52 E2 01 30 A0 13 3C 20 1B E5 04 30 82 E5 70 30 9F E5 00 30 82 E5 00 30 A0 E3 08 30 82 E5 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 3C 30 1B E5 00 10 A0 E3 10 00 83 E5 03 00 A0 E1 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 30 20 1B E5 00 30 A0 E3 3C 00 1B E5 34 30 0B E5 3C 20 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_213_3 {
	meta:
		name = "_ZNSt11__timepunctIcEC1Ej"
		size = 208
		refs = "003c _Unwind_SjLj_Register 006c _ZNSt6locale5facet13_S_get_c_nameEv 0080 _ZNSt11__timepunctIcE23_M_initialize_timepunctEPi 0088 _Unwind_SjLj_Unregister 00ac _ZNSt6locale5facetD2Ev 00bc _Unwind_SjLj_Resume 00c0 __gxx_personality_sj0 00c4 .gcc_except_table 00c8 .text$_ZNSt11__timepunctIcEC1Ej 00cc _ZTVSt11__timepunctIcE"
	strings:
		$1 = { 00 48 2D E9 B4 30 9F E5 04 B0 8D E2 3C D0 4D E2 20 30 0B E5 A8 30 9F E5 04 20 4B E2 1C 30 0B E5 A0 30 9F E5 3C 00 0B E5 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 40 10 0B E5 ?? ?? ?? ?? 40 20 1B E5 00 30 52 E2 01 30 A0 13 3C 20 1B E5 04 30 82 E5 70 30 9F E5 00 30 82 E5 00 30 A0 E3 08 30 82 E5 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 3C 30 1B E5 00 10 A0 E3 10 00 83 E5 03 00 A0 E1 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 30 20 1B E5 00 30 A0 E3 3C 00 1B E5 34 30 0B E5 3C 20 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_214_3 {
	meta:
		name = "_ZNSt11__timepunctIcEC2Ej"
		size = 208
		refs = "003c _Unwind_SjLj_Register 006c _ZNSt6locale5facet13_S_get_c_nameEv 0080 _ZNSt11__timepunctIcE23_M_initialize_timepunctEPi 0088 _Unwind_SjLj_Unregister 00ac _ZNSt6locale5facetD2Ev 00bc _Unwind_SjLj_Resume 00c0 __gxx_personality_sj0 00c4 .gcc_except_table 00c8 .text$_ZNSt11__timepunctIcEC2Ej 00cc _ZTVSt11__timepunctIcE"
	strings:
		$1 = { 00 48 2D E9 B4 30 9F E5 04 B0 8D E2 3C D0 4D E2 20 30 0B E5 A8 30 9F E5 04 20 4B E2 1C 30 0B E5 A0 30 9F E5 3C 00 0B E5 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 40 10 0B E5 ?? ?? ?? ?? 40 20 1B E5 00 30 52 E2 01 30 A0 13 3C 20 1B E5 04 30 82 E5 70 30 9F E5 00 30 82 E5 00 30 A0 E3 08 30 82 E5 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 3C 30 1B E5 00 10 A0 E3 10 00 83 E5 03 00 A0 E1 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 30 20 1B E5 00 30 A0 E3 3C 00 1B E5 34 30 0B E5 3C 20 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_213_3 {
	meta:
		name = "_ZNSt11__timepunctIwEC2Ej"
		size = 208
		refs = "003c _Unwind_SjLj_Register 006c _ZNSt6locale5facet13_S_get_c_nameEv 0080 _ZNSt11__timepunctIwE23_M_initialize_timepunctEPi 0088 _Unwind_SjLj_Unregister 00ac _ZNSt6locale5facetD2Ev 00bc _Unwind_SjLj_Resume 00c0 __gxx_personality_sj0 00c4 .gcc_except_table 00c8 .text$_ZNSt11__timepunctIwEC2Ej 00cc _ZTVSt11__timepunctIwE"
	strings:
		$1 = { 00 48 2D E9 B4 30 9F E5 04 B0 8D E2 3C D0 4D E2 20 30 0B E5 A8 30 9F E5 04 20 4B E2 1C 30 0B E5 A0 30 9F E5 3C 00 0B E5 38 00 4B E2 14 30 0B E5 18 20 0B E5 10 D0 0B E5 40 10 0B E5 ?? ?? ?? ?? 40 20 1B E5 00 30 52 E2 01 30 A0 13 3C 20 1B E5 04 30 82 E5 70 30 9F E5 00 30 82 E5 00 30 A0 E3 08 30 82 E5 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 3C 30 1B E5 00 10 A0 E3 10 00 83 E5 03 00 A0 E1 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 30 20 1B E5 00 30 A0 E3 3C 00 1B E5 34 30 0B E5 3C 20 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_214_3 {
	meta:
		name = "_ZSt16__convert_from_vRKPiPciPKcz"
		size = 52
		refs = "0020 vsprintf"
	strings:
		$1 = { 04 30 2D E5 04 E0 2D E5 04 D0 4D E2 0C 30 8D E2 01 00 A0 E1 03 20 A0 E1 08 10 9D E5 00 30 8D E5 ?? ?? ?? ?? 04 D0 8D E2 04 E0 9D E4 04 D0 8D E2 0E F0 A0 E1 }
	condition:
		$1
}

rule file_17_218_3 {
	meta:
		name = "_ZNSt8numpunctIwEC1EPij"
		size = 200
		refs = "0040 _Unwind_SjLj_Register 0078 _ZNSt8numpunctIwE22_M_initialize_numpunctEPi 0080 _Unwind_SjLj_Unregister 00a4 _ZNSt6locale5facetD2Ev 00b4 _Unwind_SjLj_Resume 00b8 __gxx_personality_sj0 00bc .gcc_except_table 00c0 .text$_ZNSt8numpunctIwEC1EPij 00c4 _ZTVSt8numpunctIwE"
	strings:
		$1 = { 00 48 2D E9 AC 30 9F E5 04 B0 8D E2 40 D0 4D E2 20 30 0B E5 A0 30 9F E5 3C 00 0B E5 1C 30 0B E5 98 30 9F E5 38 00 4B E2 14 30 0B E5 04 30 4B E2 18 30 0B E5 40 10 0B E5 44 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 44 20 1B E5 40 10 1B E5 00 30 52 E2 01 30 A0 13 3C 20 1B E5 04 30 82 E5 60 30 9F E5 02 00 A0 E1 00 30 82 E5 00 30 A0 E3 08 30 82 E5 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 A0 E3 34 30 0B E5 30 30 1B E5 3C 00 1B E5 3C 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_219_3 {
	meta:
		name = "_ZNSt8numpunctIcEC1EPij"
		size = 200
		refs = "0040 _Unwind_SjLj_Register 0078 _ZNSt8numpunctIcE22_M_initialize_numpunctEPi 0080 _Unwind_SjLj_Unregister 00a4 _ZNSt6locale5facetD2Ev 00b4 _Unwind_SjLj_Resume 00b8 __gxx_personality_sj0 00bc .gcc_except_table 00c0 .text$_ZNSt8numpunctIcEC1EPij 00c4 _ZTVSt8numpunctIcE"
	strings:
		$1 = { 00 48 2D E9 AC 30 9F E5 04 B0 8D E2 40 D0 4D E2 20 30 0B E5 A0 30 9F E5 3C 00 0B E5 1C 30 0B E5 98 30 9F E5 38 00 4B E2 14 30 0B E5 04 30 4B E2 18 30 0B E5 40 10 0B E5 44 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 44 20 1B E5 40 10 1B E5 00 30 52 E2 01 30 A0 13 3C 20 1B E5 04 30 82 E5 60 30 9F E5 02 00 A0 E1 00 30 82 E5 00 30 A0 E3 08 30 82 E5 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 A0 E3 34 30 0B E5 30 30 1B E5 3C 00 1B E5 3C 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_220_3 {
	meta:
		name = "_ZNSt8numpunctIcEC2EPij"
		size = 200
		refs = "0040 _Unwind_SjLj_Register 0078 _ZNSt8numpunctIcE22_M_initialize_numpunctEPi 0080 _Unwind_SjLj_Unregister 00a4 _ZNSt6locale5facetD2Ev 00b4 _Unwind_SjLj_Resume 00b8 __gxx_personality_sj0 00bc .gcc_except_table 00c0 .text$_ZNSt8numpunctIcEC2EPij 00c4 _ZTVSt8numpunctIcE"
	strings:
		$1 = { 00 48 2D E9 AC 30 9F E5 04 B0 8D E2 40 D0 4D E2 20 30 0B E5 A0 30 9F E5 3C 00 0B E5 1C 30 0B E5 98 30 9F E5 38 00 4B E2 14 30 0B E5 04 30 4B E2 18 30 0B E5 40 10 0B E5 44 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 44 20 1B E5 40 10 1B E5 00 30 52 E2 01 30 A0 13 3C 20 1B E5 04 30 82 E5 60 30 9F E5 02 00 A0 E1 00 30 82 E5 00 30 A0 E3 08 30 82 E5 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 A0 E3 34 30 0B E5 30 30 1B E5 3C 00 1B E5 3C 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_219_3 {
	meta:
		name = "_ZNSt8numpunctIwEC2EPij"
		size = 200
		refs = "0040 _Unwind_SjLj_Register 0078 _ZNSt8numpunctIwE22_M_initialize_numpunctEPi 0080 _Unwind_SjLj_Unregister 00a4 _ZNSt6locale5facetD2Ev 00b4 _Unwind_SjLj_Resume 00b8 __gxx_personality_sj0 00bc .gcc_except_table 00c0 .text$_ZNSt8numpunctIwEC2EPij 00c4 _ZTVSt8numpunctIwE"
	strings:
		$1 = { 00 48 2D E9 AC 30 9F E5 04 B0 8D E2 40 D0 4D E2 20 30 0B E5 A0 30 9F E5 3C 00 0B E5 1C 30 0B E5 98 30 9F E5 38 00 4B E2 14 30 0B E5 04 30 4B E2 18 30 0B E5 40 10 0B E5 44 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 44 20 1B E5 40 10 1B E5 00 30 52 E2 01 30 A0 13 3C 20 1B E5 04 30 82 E5 60 30 9F E5 02 00 A0 E1 00 30 82 E5 00 30 A0 E3 08 30 82 E5 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 A0 E3 34 30 0B E5 30 30 1B E5 3C 00 1B E5 3C 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_220_3 {
	meta:
		name = "_ZNSt8numpunctIwEC1EPSt16__numpunct_cacheIwEj"
		size = 200
		refs = "0040 _Unwind_SjLj_Register 0078 _ZNSt8numpunctIwE22_M_initialize_numpunctEPi 0080 _Unwind_SjLj_Unregister 00a4 _ZNSt6locale5facetD2Ev 00b4 _Unwind_SjLj_Resume 00b8 __gxx_personality_sj0 00bc .gcc_except_table 00c0 .text$_ZNSt8numpunctIwEC1EPSt16__numpunct_cacheIwEj 00c4 _ZTVSt8numpunctIwE"
	strings:
		$1 = { 00 48 2D E9 AC 30 9F E5 04 B0 8D E2 40 D0 4D E2 20 30 0B E5 A0 30 9F E5 3C 00 0B E5 1C 30 0B E5 98 30 9F E5 38 00 4B E2 14 30 0B E5 04 30 4B E2 18 30 0B E5 40 10 0B E5 44 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 44 20 1B E5 00 10 A0 E3 00 30 52 E2 01 30 A0 13 3C 20 1B E5 04 30 82 E5 60 30 9F E5 02 00 A0 E1 00 30 82 E5 40 30 1B E5 08 30 82 E5 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 30 20 1B E5 00 30 A0 E3 3C 00 1B E5 34 30 0B E5 3C 20 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_221_3 {
	meta:
		name = "_ZNSt8numpunctIcEC1EPSt16__numpunct_cacheIcEj"
		size = 200
		refs = "0040 _Unwind_SjLj_Register 0078 _ZNSt8numpunctIcE22_M_initialize_numpunctEPi 0080 _Unwind_SjLj_Unregister 00a4 _ZNSt6locale5facetD2Ev 00b4 _Unwind_SjLj_Resume 00b8 __gxx_personality_sj0 00bc .gcc_except_table 00c0 .text$_ZNSt8numpunctIcEC1EPSt16__numpunct_cacheIcEj 00c4 _ZTVSt8numpunctIcE"
	strings:
		$1 = { 00 48 2D E9 AC 30 9F E5 04 B0 8D E2 40 D0 4D E2 20 30 0B E5 A0 30 9F E5 3C 00 0B E5 1C 30 0B E5 98 30 9F E5 38 00 4B E2 14 30 0B E5 04 30 4B E2 18 30 0B E5 40 10 0B E5 44 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 44 20 1B E5 00 10 A0 E3 00 30 52 E2 01 30 A0 13 3C 20 1B E5 04 30 82 E5 60 30 9F E5 02 00 A0 E1 00 30 82 E5 40 30 1B E5 08 30 82 E5 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 30 20 1B E5 00 30 A0 E3 3C 00 1B E5 34 30 0B E5 3C 20 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_222_3 {
	meta:
		name = "_ZNSt8numpunctIcEC2EPSt16__numpunct_cacheIcEj"
		size = 200
		refs = "0040 _Unwind_SjLj_Register 0078 _ZNSt8numpunctIcE22_M_initialize_numpunctEPi 0080 _Unwind_SjLj_Unregister 00a4 _ZNSt6locale5facetD2Ev 00b4 _Unwind_SjLj_Resume 00b8 __gxx_personality_sj0 00bc .gcc_except_table 00c0 .text$_ZNSt8numpunctIcEC2EPSt16__numpunct_cacheIcEj 00c4 _ZTVSt8numpunctIcE"
	strings:
		$1 = { 00 48 2D E9 AC 30 9F E5 04 B0 8D E2 40 D0 4D E2 20 30 0B E5 A0 30 9F E5 3C 00 0B E5 1C 30 0B E5 98 30 9F E5 38 00 4B E2 14 30 0B E5 04 30 4B E2 18 30 0B E5 40 10 0B E5 44 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 44 20 1B E5 00 10 A0 E3 00 30 52 E2 01 30 A0 13 3C 20 1B E5 04 30 82 E5 60 30 9F E5 02 00 A0 E1 00 30 82 E5 40 30 1B E5 08 30 82 E5 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 30 20 1B E5 00 30 A0 E3 3C 00 1B E5 34 30 0B E5 3C 20 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_221_3 {
	meta:
		name = "_ZNSt8numpunctIwEC2EPSt16__numpunct_cacheIwEj"
		size = 200
		refs = "0040 _Unwind_SjLj_Register 0078 _ZNSt8numpunctIwE22_M_initialize_numpunctEPi 0080 _Unwind_SjLj_Unregister 00a4 _ZNSt6locale5facetD2Ev 00b4 _Unwind_SjLj_Resume 00b8 __gxx_personality_sj0 00bc .gcc_except_table 00c0 .text$_ZNSt8numpunctIwEC2EPSt16__numpunct_cacheIwEj 00c4 _ZTVSt8numpunctIwE"
	strings:
		$1 = { 00 48 2D E9 AC 30 9F E5 04 B0 8D E2 40 D0 4D E2 20 30 0B E5 A0 30 9F E5 3C 00 0B E5 1C 30 0B E5 98 30 9F E5 38 00 4B E2 14 30 0B E5 04 30 4B E2 18 30 0B E5 40 10 0B E5 44 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 44 20 1B E5 00 10 A0 E3 00 30 52 E2 01 30 A0 13 3C 20 1B E5 04 30 82 E5 60 30 9F E5 02 00 A0 E1 00 30 82 E5 40 30 1B E5 08 30 82 E5 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 30 20 1B E5 00 30 A0 E3 3C 00 1B E5 34 30 0B E5 3C 20 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_222_3 {
	meta:
		name = "_ZNSt8numpunctIwEC1Ej"
		size = 192
		refs = "003c _Unwind_SjLj_Register 0070 _ZNSt8numpunctIwE22_M_initialize_numpunctEPi 0078 _Unwind_SjLj_Unregister 009c _ZNSt6locale5facetD2Ev 00ac _Unwind_SjLj_Resume 00b0 __gxx_personality_sj0 00b4 .gcc_except_table 00b8 .text$_ZNSt8numpunctIwEC1Ej 00bc _ZTVSt8numpunctIwE"
	strings:
		$1 = { 00 48 2D E9 A4 30 9F E5 04 B0 8D E2 3C D0 4D E2 20 30 0B E5 98 30 9F E5 04 20 4B E2 1C 30 0B E5 90 30 9F E5 3C 00 0B E5 38 00 4B E2 14 30 0B E5 18 20 0B E5 40 10 0B E5 10 D0 0B E5 ?? ?? ?? ?? 40 20 1B E5 00 10 A0 E3 00 30 52 E2 01 30 A0 13 3C 20 1B E5 04 30 82 E5 5C 30 9F E5 08 10 82 E5 00 30 82 E5 02 00 A0 E1 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 A0 E3 34 30 0B E5 30 30 1B E5 3C 00 1B E5 3C 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_223_3 {
	meta:
		name = "_ZNSt8numpunctIcEC1Ej"
		size = 192
		refs = "003c _Unwind_SjLj_Register 0070 _ZNSt8numpunctIcE22_M_initialize_numpunctEPi 0078 _Unwind_SjLj_Unregister 009c _ZNSt6locale5facetD2Ev 00ac _Unwind_SjLj_Resume 00b0 __gxx_personality_sj0 00b4 .gcc_except_table 00b8 .text$_ZNSt8numpunctIcEC1Ej 00bc _ZTVSt8numpunctIcE"
	strings:
		$1 = { 00 48 2D E9 A4 30 9F E5 04 B0 8D E2 3C D0 4D E2 20 30 0B E5 98 30 9F E5 04 20 4B E2 1C 30 0B E5 90 30 9F E5 3C 00 0B E5 38 00 4B E2 14 30 0B E5 18 20 0B E5 40 10 0B E5 10 D0 0B E5 ?? ?? ?? ?? 40 20 1B E5 00 10 A0 E3 00 30 52 E2 01 30 A0 13 3C 20 1B E5 04 30 82 E5 5C 30 9F E5 08 10 82 E5 00 30 82 E5 02 00 A0 E1 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 A0 E3 34 30 0B E5 30 30 1B E5 3C 00 1B E5 3C 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_224_3 {
	meta:
		name = "_ZNSt8numpunctIcEC2Ej"
		size = 192
		refs = "003c _Unwind_SjLj_Register 0070 _ZNSt8numpunctIcE22_M_initialize_numpunctEPi 0078 _Unwind_SjLj_Unregister 009c _ZNSt6locale5facetD2Ev 00ac _Unwind_SjLj_Resume 00b0 __gxx_personality_sj0 00b4 .gcc_except_table 00b8 .text$_ZNSt8numpunctIcEC2Ej 00bc _ZTVSt8numpunctIcE"
	strings:
		$1 = { 00 48 2D E9 A4 30 9F E5 04 B0 8D E2 3C D0 4D E2 20 30 0B E5 98 30 9F E5 04 20 4B E2 1C 30 0B E5 90 30 9F E5 3C 00 0B E5 38 00 4B E2 14 30 0B E5 18 20 0B E5 40 10 0B E5 10 D0 0B E5 ?? ?? ?? ?? 40 20 1B E5 00 10 A0 E3 00 30 52 E2 01 30 A0 13 3C 20 1B E5 04 30 82 E5 5C 30 9F E5 08 10 82 E5 00 30 82 E5 02 00 A0 E1 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 A0 E3 34 30 0B E5 30 30 1B E5 3C 00 1B E5 3C 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_223_3 {
	meta:
		name = "_ZNSt8numpunctIwEC2Ej"
		size = 192
		refs = "003c _Unwind_SjLj_Register 0070 _ZNSt8numpunctIwE22_M_initialize_numpunctEPi 0078 _Unwind_SjLj_Unregister 009c _ZNSt6locale5facetD2Ev 00ac _Unwind_SjLj_Resume 00b0 __gxx_personality_sj0 00b4 .gcc_except_table 00b8 .text$_ZNSt8numpunctIwEC2Ej 00bc _ZTVSt8numpunctIwE"
	strings:
		$1 = { 00 48 2D E9 A4 30 9F E5 04 B0 8D E2 3C D0 4D E2 20 30 0B E5 98 30 9F E5 04 20 4B E2 1C 30 0B E5 90 30 9F E5 3C 00 0B E5 38 00 4B E2 14 30 0B E5 18 20 0B E5 40 10 0B E5 10 D0 0B E5 ?? ?? ?? ?? 40 20 1B E5 00 10 A0 E3 00 30 52 E2 01 30 A0 13 3C 20 1B E5 04 30 82 E5 5C 30 9F E5 08 10 82 E5 00 30 82 E5 02 00 A0 E1 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 A0 E3 34 30 0B E5 30 30 1B E5 3C 00 1B E5 3C 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_224_3 {
	meta:
		name = "_ZNKSt8numpunctIwE12do_falsenameEv"
		size = 148
		refs = "003c _Unwind_SjLj_Register 005c _ZNSbIwSt11char_traitsIwESaIwEEC1EPKwRKS1_ 0064 _Unwind_SjLj_Unregister 0084 _Unwind_SjLj_Resume 0088 __gxx_personality_sj0 008c .gcc_except_table 0090 .text$_ZNKSt8numpunctIwE12do_falsenameEv"
	strings:
		$1 = { 00 48 2D E9 7C 30 9F E5 04 B0 8D E2 40 D0 4D E2 24 30 0B E5 70 30 9F E5 04 20 4B E2 20 30 0B E5 68 30 9F E5 40 00 0B E5 3C 00 4B E2 18 30 0B E5 44 10 0B E5 1C 20 0B E5 14 D0 0B E5 ?? ?? ?? ?? 44 20 1B E5 40 00 1B E5 08 30 92 E5 08 20 4B E2 1C 10 93 E5 01 30 A0 E3 38 30 0B E5 ?? ?? ?? ?? 3C 00 4B E2 ?? ?? ?? ?? 40 00 1B E5 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 E0 E3 34 00 1B E5 38 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_233_3 {
	meta:
		name = "_ZNKSt10moneypunctIcLb0EE16do_positive_signEv"
		size = 148
		refs = "003c _Unwind_SjLj_Register 005c _ZNSsC1EPKcRKSaIcE 0064 _Unwind_SjLj_Unregister 0084 _Unwind_SjLj_Resume 0088 __gxx_personality_sj0 008c .gcc_except_table 0090 .text$_ZNKSt10moneypunctIcLb0EE16do_positive_signEv"
	strings:
		$1 = { 00 48 2D E9 7C 30 9F E5 04 B0 8D E2 40 D0 4D E2 24 30 0B E5 70 30 9F E5 04 20 4B E2 20 30 0B E5 68 30 9F E5 40 00 0B E5 3C 00 4B E2 18 30 0B E5 44 10 0B E5 1C 20 0B E5 14 D0 0B E5 ?? ?? ?? ?? 44 20 1B E5 40 00 1B E5 08 30 92 E5 08 20 4B E2 1C 10 93 E5 01 30 A0 E3 38 30 0B E5 ?? ?? ?? ?? 3C 00 4B E2 ?? ?? ?? ?? 40 00 1B E5 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 E0 E3 34 00 1B E5 38 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_229_3 {
	meta:
		name = "_ZNKSt10moneypunctIcLb1EE16do_positive_signEv"
		size = 148
		refs = "003c _Unwind_SjLj_Register 005c _ZNSsC1EPKcRKSaIcE 0064 _Unwind_SjLj_Unregister 0084 _Unwind_SjLj_Resume 0088 __gxx_personality_sj0 008c .gcc_except_table 0090 .text$_ZNKSt10moneypunctIcLb1EE16do_positive_signEv"
	strings:
		$1 = { 00 48 2D E9 7C 30 9F E5 04 B0 8D E2 40 D0 4D E2 24 30 0B E5 70 30 9F E5 04 20 4B E2 20 30 0B E5 68 30 9F E5 40 00 0B E5 3C 00 4B E2 18 30 0B E5 44 10 0B E5 1C 20 0B E5 14 D0 0B E5 ?? ?? ?? ?? 44 20 1B E5 40 00 1B E5 08 30 92 E5 08 20 4B E2 1C 10 93 E5 01 30 A0 E3 38 30 0B E5 ?? ?? ?? ?? 3C 00 4B E2 ?? ?? ?? ?? 40 00 1B E5 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 E0 E3 34 00 1B E5 38 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_225_3 {
	meta:
		name = "_ZNKSt8numpunctIcE12do_falsenameEv"
		size = 148
		refs = "003c _Unwind_SjLj_Register 005c _ZNSsC1EPKcRKSaIcE 0064 _Unwind_SjLj_Unregister 0084 _Unwind_SjLj_Resume 0088 __gxx_personality_sj0 008c .gcc_except_table 0090 .text$_ZNKSt8numpunctIcE12do_falsenameEv"
	strings:
		$1 = { 00 48 2D E9 7C 30 9F E5 04 B0 8D E2 40 D0 4D E2 24 30 0B E5 70 30 9F E5 04 20 4B E2 20 30 0B E5 68 30 9F E5 40 00 0B E5 3C 00 4B E2 18 30 0B E5 44 10 0B E5 1C 20 0B E5 14 D0 0B E5 ?? ?? ?? ?? 44 20 1B E5 40 00 1B E5 08 30 92 E5 08 20 4B E2 1C 10 93 E5 01 30 A0 E3 38 30 0B E5 ?? ?? ?? ?? 3C 00 4B E2 ?? ?? ?? ?? 40 00 1B E5 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 E0 E3 34 00 1B E5 38 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_225_3 {
	meta:
		name = "_ZNKSt8numpunctIwE11do_truenameEv"
		size = 148
		refs = "003c _Unwind_SjLj_Register 005c _ZNSbIwSt11char_traitsIwESaIwEEC1EPKwRKS1_ 0064 _Unwind_SjLj_Unregister 0084 _Unwind_SjLj_Resume 0088 __gxx_personality_sj0 008c .gcc_except_table 0090 .text$_ZNKSt8numpunctIwE11do_truenameEv"
	strings:
		$1 = { 00 48 2D E9 7C 30 9F E5 04 B0 8D E2 40 D0 4D E2 24 30 0B E5 70 30 9F E5 04 20 4B E2 20 30 0B E5 68 30 9F E5 40 00 0B E5 3C 00 4B E2 18 30 0B E5 44 10 0B E5 1C 20 0B E5 14 D0 0B E5 ?? ?? ?? ?? 44 20 1B E5 40 00 1B E5 08 30 92 E5 08 20 4B E2 14 10 93 E5 01 30 A0 E3 38 30 0B E5 ?? ?? ?? ?? 3C 00 4B E2 ?? ?? ?? ?? 40 00 1B E5 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 E0 E3 34 00 1B E5 38 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_234_3 {
	meta:
		name = "_ZNKSt10moneypunctIcLb0EE14do_curr_symbolEv"
		size = 148
		refs = "003c _Unwind_SjLj_Register 005c _ZNSsC1EPKcRKSaIcE 0064 _Unwind_SjLj_Unregister 0084 _Unwind_SjLj_Resume 0088 __gxx_personality_sj0 008c .gcc_except_table 0090 .text$_ZNKSt10moneypunctIcLb0EE14do_curr_symbolEv"
	strings:
		$1 = { 00 48 2D E9 7C 30 9F E5 04 B0 8D E2 40 D0 4D E2 24 30 0B E5 70 30 9F E5 04 20 4B E2 20 30 0B E5 68 30 9F E5 40 00 0B E5 3C 00 4B E2 18 30 0B E5 44 10 0B E5 1C 20 0B E5 14 D0 0B E5 ?? ?? ?? ?? 44 20 1B E5 40 00 1B E5 08 30 92 E5 08 20 4B E2 14 10 93 E5 01 30 A0 E3 38 30 0B E5 ?? ?? ?? ?? 3C 00 4B E2 ?? ?? ?? ?? 40 00 1B E5 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 E0 E3 34 00 1B E5 38 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_230_3 {
	meta:
		name = "_ZNKSt10moneypunctIcLb1EE14do_curr_symbolEv"
		size = 148
		refs = "003c _Unwind_SjLj_Register 005c _ZNSsC1EPKcRKSaIcE 0064 _Unwind_SjLj_Unregister 0084 _Unwind_SjLj_Resume 0088 __gxx_personality_sj0 008c .gcc_except_table 0090 .text$_ZNKSt10moneypunctIcLb1EE14do_curr_symbolEv"
	strings:
		$1 = { 00 48 2D E9 7C 30 9F E5 04 B0 8D E2 40 D0 4D E2 24 30 0B E5 70 30 9F E5 04 20 4B E2 20 30 0B E5 68 30 9F E5 40 00 0B E5 3C 00 4B E2 18 30 0B E5 44 10 0B E5 1C 20 0B E5 14 D0 0B E5 ?? ?? ?? ?? 44 20 1B E5 40 00 1B E5 08 30 92 E5 08 20 4B E2 14 10 93 E5 01 30 A0 E3 38 30 0B E5 ?? ?? ?? ?? 3C 00 4B E2 ?? ?? ?? ?? 40 00 1B E5 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 E0 E3 34 00 1B E5 38 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_226_3 {
	meta:
		name = "_ZNKSt8numpunctIcE11do_truenameEv"
		size = 148
		refs = "003c _Unwind_SjLj_Register 005c _ZNSsC1EPKcRKSaIcE 0064 _Unwind_SjLj_Unregister 0084 _Unwind_SjLj_Resume 0088 __gxx_personality_sj0 008c .gcc_except_table 0090 .text$_ZNKSt8numpunctIcE11do_truenameEv"
	strings:
		$1 = { 00 48 2D E9 7C 30 9F E5 04 B0 8D E2 40 D0 4D E2 24 30 0B E5 70 30 9F E5 04 20 4B E2 20 30 0B E5 68 30 9F E5 40 00 0B E5 3C 00 4B E2 18 30 0B E5 44 10 0B E5 1C 20 0B E5 14 D0 0B E5 ?? ?? ?? ?? 44 20 1B E5 40 00 1B E5 08 30 92 E5 08 20 4B E2 14 10 93 E5 01 30 A0 E3 38 30 0B E5 ?? ?? ?? ?? 3C 00 4B E2 ?? ?? ?? ?? 40 00 1B E5 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 E0 E3 34 00 1B E5 38 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_226_3 {
	meta:
		name = "_ZNKSt10moneypunctIwLb1EE16do_negative_signEv"
		size = 148
		refs = "003c _Unwind_SjLj_Register 005c _ZNSbIwSt11char_traitsIwESaIwEEC1EPKwRKS1_ 0064 _Unwind_SjLj_Unregister 0084 _Unwind_SjLj_Resume 0088 __gxx_personality_sj0 008c .gcc_except_table 0090 .text$_ZNKSt10moneypunctIwLb1EE16do_negative_signEv"
	strings:
		$1 = { 00 48 2D E9 7C 30 9F E5 04 B0 8D E2 40 D0 4D E2 24 30 0B E5 70 30 9F E5 04 20 4B E2 20 30 0B E5 68 30 9F E5 40 00 0B E5 3C 00 4B E2 18 30 0B E5 44 10 0B E5 1C 20 0B E5 14 D0 0B E5 ?? ?? ?? ?? 44 20 1B E5 40 00 1B E5 08 30 92 E5 08 20 4B E2 28 10 93 E5 01 30 A0 E3 38 30 0B E5 ?? ?? ?? ?? 3C 00 4B E2 ?? ?? ?? ?? 40 00 1B E5 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 E0 E3 34 00 1B E5 38 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_229_3 {
	meta:
		name = "_ZNKSt10moneypunctIwLb0EE16do_negative_signEv"
		size = 148
		refs = "003c _Unwind_SjLj_Register 005c _ZNSbIwSt11char_traitsIwESaIwEEC1EPKwRKS1_ 0064 _Unwind_SjLj_Unregister 0084 _Unwind_SjLj_Resume 0088 __gxx_personality_sj0 008c .gcc_except_table 0090 .text$_ZNKSt10moneypunctIwLb0EE16do_negative_signEv"
	strings:
		$1 = { 00 48 2D E9 7C 30 9F E5 04 B0 8D E2 40 D0 4D E2 24 30 0B E5 70 30 9F E5 04 20 4B E2 20 30 0B E5 68 30 9F E5 40 00 0B E5 3C 00 4B E2 18 30 0B E5 44 10 0B E5 1C 20 0B E5 14 D0 0B E5 ?? ?? ?? ?? 44 20 1B E5 40 00 1B E5 08 30 92 E5 08 20 4B E2 28 10 93 E5 01 30 A0 E3 38 30 0B E5 ?? ?? ?? ?? 3C 00 4B E2 ?? ?? ?? ?? 40 00 1B E5 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 E0 E3 34 00 1B E5 38 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_227_3 {
	meta:
		name = "_ZNKSt10moneypunctIwLb1EE16do_positive_signEv"
		size = 148
		refs = "003c _Unwind_SjLj_Register 005c _ZNSbIwSt11char_traitsIwESaIwEEC1EPKwRKS1_ 0064 _Unwind_SjLj_Unregister 0084 _Unwind_SjLj_Resume 0088 __gxx_personality_sj0 008c .gcc_except_table 0090 .text$_ZNKSt10moneypunctIwLb1EE16do_positive_signEv"
	strings:
		$1 = { 00 48 2D E9 7C 30 9F E5 04 B0 8D E2 40 D0 4D E2 24 30 0B E5 70 30 9F E5 04 20 4B E2 20 30 0B E5 68 30 9F E5 40 00 0B E5 3C 00 4B E2 18 30 0B E5 44 10 0B E5 1C 20 0B E5 14 D0 0B E5 ?? ?? ?? ?? 44 20 1B E5 40 00 1B E5 08 30 92 E5 08 20 4B E2 20 10 93 E5 01 30 A0 E3 38 30 0B E5 ?? ?? ?? ?? 3C 00 4B E2 ?? ?? ?? ?? 40 00 1B E5 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 E0 E3 34 00 1B E5 38 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_230_3 {
	meta:
		name = "_ZNKSt10moneypunctIwLb0EE16do_positive_signEv"
		size = 148
		refs = "003c _Unwind_SjLj_Register 005c _ZNSbIwSt11char_traitsIwESaIwEEC1EPKwRKS1_ 0064 _Unwind_SjLj_Unregister 0084 _Unwind_SjLj_Resume 0088 __gxx_personality_sj0 008c .gcc_except_table 0090 .text$_ZNKSt10moneypunctIwLb0EE16do_positive_signEv"
	strings:
		$1 = { 00 48 2D E9 7C 30 9F E5 04 B0 8D E2 40 D0 4D E2 24 30 0B E5 70 30 9F E5 04 20 4B E2 20 30 0B E5 68 30 9F E5 40 00 0B E5 3C 00 4B E2 18 30 0B E5 44 10 0B E5 1C 20 0B E5 14 D0 0B E5 ?? ?? ?? ?? 44 20 1B E5 40 00 1B E5 08 30 92 E5 08 20 4B E2 20 10 93 E5 01 30 A0 E3 38 30 0B E5 ?? ?? ?? ?? 3C 00 4B E2 ?? ?? ?? ?? 40 00 1B E5 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 E0 E3 34 00 1B E5 38 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_228_3 {
	meta:
		name = "_ZNKSt10moneypunctIwLb1EE14do_curr_symbolEv"
		size = 148
		refs = "003c _Unwind_SjLj_Register 005c _ZNSbIwSt11char_traitsIwESaIwEEC1EPKwRKS1_ 0064 _Unwind_SjLj_Unregister 0084 _Unwind_SjLj_Resume 0088 __gxx_personality_sj0 008c .gcc_except_table 0090 .text$_ZNKSt10moneypunctIwLb1EE14do_curr_symbolEv"
	strings:
		$1 = { 00 48 2D E9 7C 30 9F E5 04 B0 8D E2 40 D0 4D E2 24 30 0B E5 70 30 9F E5 04 20 4B E2 20 30 0B E5 68 30 9F E5 40 00 0B E5 3C 00 4B E2 18 30 0B E5 44 10 0B E5 1C 20 0B E5 14 D0 0B E5 ?? ?? ?? ?? 44 20 1B E5 40 00 1B E5 08 30 92 E5 08 20 4B E2 18 10 93 E5 01 30 A0 E3 38 30 0B E5 ?? ?? ?? ?? 3C 00 4B E2 ?? ?? ?? ?? 40 00 1B E5 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 E0 E3 34 00 1B E5 38 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_231_3 {
	meta:
		name = "_ZNKSt10moneypunctIwLb0EE14do_curr_symbolEv"
		size = 148
		refs = "003c _Unwind_SjLj_Register 005c _ZNSbIwSt11char_traitsIwESaIwEEC1EPKwRKS1_ 0064 _Unwind_SjLj_Unregister 0084 _Unwind_SjLj_Resume 0088 __gxx_personality_sj0 008c .gcc_except_table 0090 .text$_ZNKSt10moneypunctIwLb0EE14do_curr_symbolEv"
	strings:
		$1 = { 00 48 2D E9 7C 30 9F E5 04 B0 8D E2 40 D0 4D E2 24 30 0B E5 70 30 9F E5 04 20 4B E2 20 30 0B E5 68 30 9F E5 40 00 0B E5 3C 00 4B E2 18 30 0B E5 44 10 0B E5 1C 20 0B E5 14 D0 0B E5 ?? ?? ?? ?? 44 20 1B E5 40 00 1B E5 08 30 92 E5 08 20 4B E2 18 10 93 E5 01 30 A0 E3 38 30 0B E5 ?? ?? ?? ?? 3C 00 4B E2 ?? ?? ?? ?? 40 00 1B E5 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 E0 E3 34 00 1B E5 38 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_232_3 {
	meta:
		name = "_ZNKSt8numpunctIwE11do_groupingEv"
		size = 148
		refs = "003c _Unwind_SjLj_Register 005c _ZNSsC1EPKcRKSaIcE 0064 _Unwind_SjLj_Unregister 0084 _Unwind_SjLj_Resume 0088 __gxx_personality_sj0 008c .gcc_except_table 0090 .text$_ZNKSt8numpunctIwE11do_groupingEv"
	strings:
		$1 = { 00 48 2D E9 7C 30 9F E5 04 B0 8D E2 40 D0 4D E2 24 30 0B E5 70 30 9F E5 04 20 4B E2 20 30 0B E5 68 30 9F E5 40 00 0B E5 3C 00 4B E2 18 30 0B E5 44 10 0B E5 1C 20 0B E5 14 D0 0B E5 ?? ?? ?? ?? 44 20 1B E5 40 00 1B E5 08 30 92 E5 08 20 4B E2 08 10 93 E5 01 30 A0 E3 38 30 0B E5 ?? ?? ?? ?? 3C 00 4B E2 ?? ?? ?? ?? 40 00 1B E5 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 E0 E3 34 00 1B E5 38 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_235_3 {
	meta:
		name = "_ZNKSt10moneypunctIcLb0EE11do_groupingEv"
		size = 148
		refs = "003c _Unwind_SjLj_Register 005c _ZNSsC1EPKcRKSaIcE 0064 _Unwind_SjLj_Unregister 0084 _Unwind_SjLj_Resume 0088 __gxx_personality_sj0 008c .gcc_except_table 0090 .text$_ZNKSt10moneypunctIcLb0EE11do_groupingEv"
	strings:
		$1 = { 00 48 2D E9 7C 30 9F E5 04 B0 8D E2 40 D0 4D E2 24 30 0B E5 70 30 9F E5 04 20 4B E2 20 30 0B E5 68 30 9F E5 40 00 0B E5 3C 00 4B E2 18 30 0B E5 44 10 0B E5 1C 20 0B E5 14 D0 0B E5 ?? ?? ?? ?? 44 20 1B E5 40 00 1B E5 08 30 92 E5 08 20 4B E2 08 10 93 E5 01 30 A0 E3 38 30 0B E5 ?? ?? ?? ?? 3C 00 4B E2 ?? ?? ?? ?? 40 00 1B E5 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 E0 E3 34 00 1B E5 38 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_231_3 {
	meta:
		name = "_ZNKSt10moneypunctIcLb1EE11do_groupingEv"
		size = 148
		refs = "003c _Unwind_SjLj_Register 005c _ZNSsC1EPKcRKSaIcE 0064 _Unwind_SjLj_Unregister 0084 _Unwind_SjLj_Resume 0088 __gxx_personality_sj0 008c .gcc_except_table 0090 .text$_ZNKSt10moneypunctIcLb1EE11do_groupingEv"
	strings:
		$1 = { 00 48 2D E9 7C 30 9F E5 04 B0 8D E2 40 D0 4D E2 24 30 0B E5 70 30 9F E5 04 20 4B E2 20 30 0B E5 68 30 9F E5 40 00 0B E5 3C 00 4B E2 18 30 0B E5 44 10 0B E5 1C 20 0B E5 14 D0 0B E5 ?? ?? ?? ?? 44 20 1B E5 40 00 1B E5 08 30 92 E5 08 20 4B E2 08 10 93 E5 01 30 A0 E3 38 30 0B E5 ?? ?? ?? ?? 3C 00 4B E2 ?? ?? ?? ?? 40 00 1B E5 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 E0 E3 34 00 1B E5 38 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_234_3 {
	meta:
		name = "_ZNKSt10moneypunctIwLb0EE11do_groupingEv"
		size = 148
		refs = "003c _Unwind_SjLj_Register 005c _ZNSsC1EPKcRKSaIcE 0064 _Unwind_SjLj_Unregister 0084 _Unwind_SjLj_Resume 0088 __gxx_personality_sj0 008c .gcc_except_table 0090 .text$_ZNKSt10moneypunctIwLb0EE11do_groupingEv"
	strings:
		$1 = { 00 48 2D E9 7C 30 9F E5 04 B0 8D E2 40 D0 4D E2 24 30 0B E5 70 30 9F E5 04 20 4B E2 20 30 0B E5 68 30 9F E5 40 00 0B E5 3C 00 4B E2 18 30 0B E5 44 10 0B E5 1C 20 0B E5 14 D0 0B E5 ?? ?? ?? ?? 44 20 1B E5 40 00 1B E5 08 30 92 E5 08 20 4B E2 08 10 93 E5 01 30 A0 E3 38 30 0B E5 ?? ?? ?? ?? 3C 00 4B E2 ?? ?? ?? ?? 40 00 1B E5 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 E0 E3 34 00 1B E5 38 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_233_3 {
	meta:
		name = "_ZNKSt10moneypunctIwLb1EE11do_groupingEv"
		size = 148
		refs = "003c _Unwind_SjLj_Register 005c _ZNSsC1EPKcRKSaIcE 0064 _Unwind_SjLj_Unregister 0084 _Unwind_SjLj_Resume 0088 __gxx_personality_sj0 008c .gcc_except_table 0090 .text$_ZNKSt10moneypunctIwLb1EE11do_groupingEv"
	strings:
		$1 = { 00 48 2D E9 7C 30 9F E5 04 B0 8D E2 40 D0 4D E2 24 30 0B E5 70 30 9F E5 04 20 4B E2 20 30 0B E5 68 30 9F E5 40 00 0B E5 3C 00 4B E2 18 30 0B E5 44 10 0B E5 1C 20 0B E5 14 D0 0B E5 ?? ?? ?? ?? 44 20 1B E5 40 00 1B E5 08 30 92 E5 08 20 4B E2 08 10 93 E5 01 30 A0 E3 38 30 0B E5 ?? ?? ?? ?? 3C 00 4B E2 ?? ?? ?? ?? 40 00 1B E5 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 E0 E3 34 00 1B E5 38 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_227_3 {
	meta:
		name = "_ZNKSt8numpunctIcE11do_groupingEv"
		size = 148
		refs = "003c _Unwind_SjLj_Register 005c _ZNSsC1EPKcRKSaIcE 0064 _Unwind_SjLj_Unregister 0084 _Unwind_SjLj_Resume 0088 __gxx_personality_sj0 008c .gcc_except_table 0090 .text$_ZNKSt8numpunctIcE11do_groupingEv"
	strings:
		$1 = { 00 48 2D E9 7C 30 9F E5 04 B0 8D E2 40 D0 4D E2 24 30 0B E5 70 30 9F E5 04 20 4B E2 20 30 0B E5 68 30 9F E5 40 00 0B E5 3C 00 4B E2 18 30 0B E5 44 10 0B E5 1C 20 0B E5 14 D0 0B E5 ?? ?? ?? ?? 44 20 1B E5 40 00 1B E5 08 30 92 E5 08 20 4B E2 08 10 93 E5 01 30 A0 E3 38 30 0B E5 ?? ?? ?? ?? 3C 00 4B E2 ?? ?? ?? ?? 40 00 1B E5 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 00 30 E0 E3 34 00 1B E5 38 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_238_3 {
	meta:
		name = "_ZNSt10moneypunctIwLb1EEC1EPiPKcj"
		size = 204
		refs = "0044 _Unwind_SjLj_Register 007c _ZNSt10moneypunctIwLb1EE24_M_initialize_moneypunctEPiPKc 0084 _Unwind_SjLj_Unregister 00a8 _ZNSt6locale5facetD2Ev 00b8 _Unwind_SjLj_Resume 00bc __gxx_personality_sj0 00c0 .gcc_except_table 00c4 .text$_ZNSt10moneypunctIwLb1EEC1EPiPKcj 00c8 _ZTVSt10moneypunctIwLb1EE"
	strings:
		$1 = { 00 48 2D E9 B0 C0 9F E5 04 B0 8D E2 44 D0 4D E2 20 C0 0B E5 A4 C0 9F E5 3C 00 0B E5 1C C0 0B E5 04 00 4B E2 98 C0 9F E5 18 00 0B E5 38 00 4B E2 40 10 0B E5 44 20 0B E5 48 30 0B E5 14 C0 0B E5 10 D0 0B E5 ?? ?? ?? ?? 48 20 1B E5 3C 00 1B E5 00 30 52 E2 01 30 A0 13 04 30 80 E5 64 30 9F E5 40 10 1B E5 00 30 80 E5 00 30 A0 E3 08 30 80 E5 44 20 1B E5 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 30 20 1B E5 00 30 A0 E3 3C 00 1B E5 34 30 0B E5 3C 20 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_248_3 {
	meta:
		name = "_ZNSt10moneypunctIcLb0EEC1EPiPKcj"
		size = 204
		refs = "0044 _Unwind_SjLj_Register 007c _ZNSt10moneypunctIcLb0EE24_M_initialize_moneypunctEPiPKc 0084 _Unwind_SjLj_Unregister 00a8 _ZNSt6locale5facetD2Ev 00b8 _Unwind_SjLj_Resume 00bc __gxx_personality_sj0 00c0 .gcc_except_table 00c4 .text$_ZNSt10moneypunctIcLb0EEC1EPiPKcj 00c8 _ZTVSt10moneypunctIcLb0EE"
	strings:
		$1 = { 00 48 2D E9 B0 C0 9F E5 04 B0 8D E2 44 D0 4D E2 20 C0 0B E5 A4 C0 9F E5 3C 00 0B E5 1C C0 0B E5 04 00 4B E2 98 C0 9F E5 18 00 0B E5 38 00 4B E2 40 10 0B E5 44 20 0B E5 48 30 0B E5 14 C0 0B E5 10 D0 0B E5 ?? ?? ?? ?? 48 20 1B E5 3C 00 1B E5 00 30 52 E2 01 30 A0 13 04 30 80 E5 64 30 9F E5 40 10 1B E5 00 30 80 E5 00 30 A0 E3 08 30 80 E5 44 20 1B E5 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 30 20 1B E5 00 30 A0 E3 3C 00 1B E5 34 30 0B E5 3C 20 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_249_3 {
	meta:
		name = "_ZNSt10moneypunctIcLb0EEC2EPiPKcj"
		size = 204
		refs = "0044 _Unwind_SjLj_Register 007c _ZNSt10moneypunctIcLb0EE24_M_initialize_moneypunctEPiPKc 0084 _Unwind_SjLj_Unregister 00a8 _ZNSt6locale5facetD2Ev 00b8 _Unwind_SjLj_Resume 00bc __gxx_personality_sj0 00c0 .gcc_except_table 00c4 .text$_ZNSt10moneypunctIcLb0EEC2EPiPKcj 00c8 _ZTVSt10moneypunctIcLb0EE"
	strings:
		$1 = { 00 48 2D E9 B0 C0 9F E5 04 B0 8D E2 44 D0 4D E2 20 C0 0B E5 A4 C0 9F E5 3C 00 0B E5 1C C0 0B E5 04 00 4B E2 98 C0 9F E5 18 00 0B E5 38 00 4B E2 40 10 0B E5 44 20 0B E5 48 30 0B E5 14 C0 0B E5 10 D0 0B E5 ?? ?? ?? ?? 48 20 1B E5 3C 00 1B E5 00 30 52 E2 01 30 A0 13 04 30 80 E5 64 30 9F E5 40 10 1B E5 00 30 80 E5 00 30 A0 E3 08 30 80 E5 44 20 1B E5 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 30 20 1B E5 00 30 A0 E3 3C 00 1B E5 34 30 0B E5 3C 20 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_239_3 {
	meta:
		name = "_ZNSt10moneypunctIcLb1EEC1EPiPKcj"
		size = 204
		refs = "0044 _Unwind_SjLj_Register 007c _ZNSt10moneypunctIcLb1EE24_M_initialize_moneypunctEPiPKc 0084 _Unwind_SjLj_Unregister 00a8 _ZNSt6locale5facetD2Ev 00b8 _Unwind_SjLj_Resume 00bc __gxx_personality_sj0 00c0 .gcc_except_table 00c4 .text$_ZNSt10moneypunctIcLb1EEC1EPiPKcj 00c8 _ZTVSt10moneypunctIcLb1EE"
	strings:
		$1 = { 00 48 2D E9 B0 C0 9F E5 04 B0 8D E2 44 D0 4D E2 20 C0 0B E5 A4 C0 9F E5 3C 00 0B E5 1C C0 0B E5 04 00 4B E2 98 C0 9F E5 18 00 0B E5 38 00 4B E2 40 10 0B E5 44 20 0B E5 48 30 0B E5 14 C0 0B E5 10 D0 0B E5 ?? ?? ?? ?? 48 20 1B E5 3C 00 1B E5 00 30 52 E2 01 30 A0 13 04 30 80 E5 64 30 9F E5 40 10 1B E5 00 30 80 E5 00 30 A0 E3 08 30 80 E5 44 20 1B E5 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 30 20 1B E5 00 30 A0 E3 3C 00 1B E5 34 30 0B E5 3C 20 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_240_3 {
	meta:
		name = "_ZNSt10moneypunctIcLb1EEC2EPiPKcj"
		size = 204
		refs = "0044 _Unwind_SjLj_Register 007c _ZNSt10moneypunctIcLb1EE24_M_initialize_moneypunctEPiPKc 0084 _Unwind_SjLj_Unregister 00a8 _ZNSt6locale5facetD2Ev 00b8 _Unwind_SjLj_Resume 00bc __gxx_personality_sj0 00c0 .gcc_except_table 00c4 .text$_ZNSt10moneypunctIcLb1EEC2EPiPKcj 00c8 _ZTVSt10moneypunctIcLb1EE"
	strings:
		$1 = { 00 48 2D E9 B0 C0 9F E5 04 B0 8D E2 44 D0 4D E2 20 C0 0B E5 A4 C0 9F E5 3C 00 0B E5 1C C0 0B E5 04 00 4B E2 98 C0 9F E5 18 00 0B E5 38 00 4B E2 40 10 0B E5 44 20 0B E5 48 30 0B E5 14 C0 0B E5 10 D0 0B E5 ?? ?? ?? ?? 48 20 1B E5 3C 00 1B E5 00 30 52 E2 01 30 A0 13 04 30 80 E5 64 30 9F E5 40 10 1B E5 00 30 80 E5 00 30 A0 E3 08 30 80 E5 44 20 1B E5 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 30 20 1B E5 00 30 A0 E3 3C 00 1B E5 34 30 0B E5 3C 20 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_247_3 {
	meta:
		name = "_ZNSt10moneypunctIwLb0EEC1EPiPKcj"
		size = 204
		refs = "0044 _Unwind_SjLj_Register 007c _ZNSt10moneypunctIwLb0EE24_M_initialize_moneypunctEPiPKc 0084 _Unwind_SjLj_Unregister 00a8 _ZNSt6locale5facetD2Ev 00b8 _Unwind_SjLj_Resume 00bc __gxx_personality_sj0 00c0 .gcc_except_table 00c4 .text$_ZNSt10moneypunctIwLb0EEC1EPiPKcj 00c8 _ZTVSt10moneypunctIwLb0EE"
	strings:
		$1 = { 00 48 2D E9 B0 C0 9F E5 04 B0 8D E2 44 D0 4D E2 20 C0 0B E5 A4 C0 9F E5 3C 00 0B E5 1C C0 0B E5 04 00 4B E2 98 C0 9F E5 18 00 0B E5 38 00 4B E2 40 10 0B E5 44 20 0B E5 48 30 0B E5 14 C0 0B E5 10 D0 0B E5 ?? ?? ?? ?? 48 20 1B E5 3C 00 1B E5 00 30 52 E2 01 30 A0 13 04 30 80 E5 64 30 9F E5 40 10 1B E5 00 30 80 E5 00 30 A0 E3 08 30 80 E5 44 20 1B E5 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 30 20 1B E5 00 30 A0 E3 3C 00 1B E5 34 30 0B E5 3C 20 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_248_3 {
	meta:
		name = "_ZNSt10moneypunctIwLb0EEC2EPiPKcj"
		size = 204
		refs = "0044 _Unwind_SjLj_Register 007c _ZNSt10moneypunctIwLb0EE24_M_initialize_moneypunctEPiPKc 0084 _Unwind_SjLj_Unregister 00a8 _ZNSt6locale5facetD2Ev 00b8 _Unwind_SjLj_Resume 00bc __gxx_personality_sj0 00c0 .gcc_except_table 00c4 .text$_ZNSt10moneypunctIwLb0EEC2EPiPKcj 00c8 _ZTVSt10moneypunctIwLb0EE"
	strings:
		$1 = { 00 48 2D E9 B0 C0 9F E5 04 B0 8D E2 44 D0 4D E2 20 C0 0B E5 A4 C0 9F E5 3C 00 0B E5 1C C0 0B E5 04 00 4B E2 98 C0 9F E5 18 00 0B E5 38 00 4B E2 40 10 0B E5 44 20 0B E5 48 30 0B E5 14 C0 0B E5 10 D0 0B E5 ?? ?? ?? ?? 48 20 1B E5 3C 00 1B E5 00 30 52 E2 01 30 A0 13 04 30 80 E5 64 30 9F E5 40 10 1B E5 00 30 80 E5 00 30 A0 E3 08 30 80 E5 44 20 1B E5 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 30 20 1B E5 00 30 A0 E3 3C 00 1B E5 34 30 0B E5 3C 20 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_239_3 {
	meta:
		name = "_ZNSt10moneypunctIwLb1EEC2EPiPKcj"
		size = 204
		refs = "0044 _Unwind_SjLj_Register 007c _ZNSt10moneypunctIwLb1EE24_M_initialize_moneypunctEPiPKc 0084 _Unwind_SjLj_Unregister 00a8 _ZNSt6locale5facetD2Ev 00b8 _Unwind_SjLj_Resume 00bc __gxx_personality_sj0 00c0 .gcc_except_table 00c4 .text$_ZNSt10moneypunctIwLb1EEC2EPiPKcj 00c8 _ZTVSt10moneypunctIwLb1EE"
	strings:
		$1 = { 00 48 2D E9 B0 C0 9F E5 04 B0 8D E2 44 D0 4D E2 20 C0 0B E5 A4 C0 9F E5 3C 00 0B E5 1C C0 0B E5 04 00 4B E2 98 C0 9F E5 18 00 0B E5 38 00 4B E2 40 10 0B E5 44 20 0B E5 48 30 0B E5 14 C0 0B E5 10 D0 0B E5 ?? ?? ?? ?? 48 20 1B E5 3C 00 1B E5 00 30 52 E2 01 30 A0 13 04 30 80 E5 64 30 9F E5 40 10 1B E5 00 30 80 E5 00 30 A0 E3 08 30 80 E5 44 20 1B E5 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 30 20 1B E5 00 30 A0 E3 3C 00 1B E5 34 30 0B E5 3C 20 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_240_3 {
	meta:
		name = "_ZNSt10moneypunctIwLb1EEC1EPSt18__moneypunct_cacheIwLb1EEj"
		size = 204
		refs = "0040 _Unwind_SjLj_Register 007c _ZNSt10moneypunctIwLb1EE24_M_initialize_moneypunctEPiPKc 0084 _Unwind_SjLj_Unregister 00a8 _ZNSt6locale5facetD2Ev 00b8 _Unwind_SjLj_Resume 00bc __gxx_personality_sj0 00c0 .gcc_except_table 00c4 .text$_ZNSt10moneypunctIwLb1EEC1EPSt18__moneypunct_cacheIwLb1EEj 00c8 _ZTVSt10moneypunctIwLb1EE"
	strings:
		$1 = { 00 48 2D E9 B0 30 9F E5 04 B0 8D E2 40 D0 4D E2 20 30 0B E5 A4 30 9F E5 3C 00 0B E5 1C 30 0B E5 9C 30 9F E5 38 00 4B E2 14 30 0B E5 04 30 4B E2 18 30 0B E5 40 10 0B E5 44 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 44 20 1B E5 00 10 A0 E3 00 30 52 E2 01 30 A0 13 3C 20 1B E5 04 30 82 E5 64 30 9F E5 02 00 A0 E1 00 30 82 E5 40 30 1B E5 08 30 82 E5 01 30 A0 E3 01 20 A0 E1 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 30 20 1B E5 00 30 A0 E3 3C 00 1B E5 34 30 0B E5 3C 20 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_250_3 {
	meta:
		name = "_ZNSt10moneypunctIcLb0EEC1EPSt18__moneypunct_cacheIcLb0EEj"
		size = 204
		refs = "0040 _Unwind_SjLj_Register 007c _ZNSt10moneypunctIcLb0EE24_M_initialize_moneypunctEPiPKc 0084 _Unwind_SjLj_Unregister 00a8 _ZNSt6locale5facetD2Ev 00b8 _Unwind_SjLj_Resume 00bc __gxx_personality_sj0 00c0 .gcc_except_table 00c4 .text$_ZNSt10moneypunctIcLb0EEC1EPSt18__moneypunct_cacheIcLb0EEj 00c8 _ZTVSt10moneypunctIcLb0EE"
	strings:
		$1 = { 00 48 2D E9 B0 30 9F E5 04 B0 8D E2 40 D0 4D E2 20 30 0B E5 A4 30 9F E5 3C 00 0B E5 1C 30 0B E5 9C 30 9F E5 38 00 4B E2 14 30 0B E5 04 30 4B E2 18 30 0B E5 40 10 0B E5 44 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 44 20 1B E5 00 10 A0 E3 00 30 52 E2 01 30 A0 13 3C 20 1B E5 04 30 82 E5 64 30 9F E5 02 00 A0 E1 00 30 82 E5 40 30 1B E5 08 30 82 E5 01 30 A0 E3 01 20 A0 E1 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 30 20 1B E5 00 30 A0 E3 3C 00 1B E5 34 30 0B E5 3C 20 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_251_3 {
	meta:
		name = "_ZNSt10moneypunctIcLb0EEC2EPSt18__moneypunct_cacheIcLb0EEj"
		size = 204
		refs = "0040 _Unwind_SjLj_Register 007c _ZNSt10moneypunctIcLb0EE24_M_initialize_moneypunctEPiPKc 0084 _Unwind_SjLj_Unregister 00a8 _ZNSt6locale5facetD2Ev 00b8 _Unwind_SjLj_Resume 00bc __gxx_personality_sj0 00c0 .gcc_except_table 00c4 .text$_ZNSt10moneypunctIcLb0EEC2EPSt18__moneypunct_cacheIcLb0EEj 00c8 _ZTVSt10moneypunctIcLb0EE"
	strings:
		$1 = { 00 48 2D E9 B0 30 9F E5 04 B0 8D E2 40 D0 4D E2 20 30 0B E5 A4 30 9F E5 3C 00 0B E5 1C 30 0B E5 9C 30 9F E5 38 00 4B E2 14 30 0B E5 04 30 4B E2 18 30 0B E5 40 10 0B E5 44 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 44 20 1B E5 00 10 A0 E3 00 30 52 E2 01 30 A0 13 3C 20 1B E5 04 30 82 E5 64 30 9F E5 02 00 A0 E1 00 30 82 E5 40 30 1B E5 08 30 82 E5 01 30 A0 E3 01 20 A0 E1 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 30 20 1B E5 00 30 A0 E3 3C 00 1B E5 34 30 0B E5 3C 20 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_241_3 {
	meta:
		name = "_ZNSt10moneypunctIcLb1EEC1EPSt18__moneypunct_cacheIcLb1EEj"
		size = 204
		refs = "0040 _Unwind_SjLj_Register 007c _ZNSt10moneypunctIcLb1EE24_M_initialize_moneypunctEPiPKc 0084 _Unwind_SjLj_Unregister 00a8 _ZNSt6locale5facetD2Ev 00b8 _Unwind_SjLj_Resume 00bc __gxx_personality_sj0 00c0 .gcc_except_table 00c4 .text$_ZNSt10moneypunctIcLb1EEC1EPSt18__moneypunct_cacheIcLb1EEj 00c8 _ZTVSt10moneypunctIcLb1EE"
	strings:
		$1 = { 00 48 2D E9 B0 30 9F E5 04 B0 8D E2 40 D0 4D E2 20 30 0B E5 A4 30 9F E5 3C 00 0B E5 1C 30 0B E5 9C 30 9F E5 38 00 4B E2 14 30 0B E5 04 30 4B E2 18 30 0B E5 40 10 0B E5 44 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 44 20 1B E5 00 10 A0 E3 00 30 52 E2 01 30 A0 13 3C 20 1B E5 04 30 82 E5 64 30 9F E5 02 00 A0 E1 00 30 82 E5 40 30 1B E5 08 30 82 E5 01 30 A0 E3 01 20 A0 E1 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 30 20 1B E5 00 30 A0 E3 3C 00 1B E5 34 30 0B E5 3C 20 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_242_3 {
	meta:
		name = "_ZNSt10moneypunctIcLb1EEC2EPSt18__moneypunct_cacheIcLb1EEj"
		size = 204
		refs = "0040 _Unwind_SjLj_Register 007c _ZNSt10moneypunctIcLb1EE24_M_initialize_moneypunctEPiPKc 0084 _Unwind_SjLj_Unregister 00a8 _ZNSt6locale5facetD2Ev 00b8 _Unwind_SjLj_Resume 00bc __gxx_personality_sj0 00c0 .gcc_except_table 00c4 .text$_ZNSt10moneypunctIcLb1EEC2EPSt18__moneypunct_cacheIcLb1EEj 00c8 _ZTVSt10moneypunctIcLb1EE"
	strings:
		$1 = { 00 48 2D E9 B0 30 9F E5 04 B0 8D E2 40 D0 4D E2 20 30 0B E5 A4 30 9F E5 3C 00 0B E5 1C 30 0B E5 9C 30 9F E5 38 00 4B E2 14 30 0B E5 04 30 4B E2 18 30 0B E5 40 10 0B E5 44 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 44 20 1B E5 00 10 A0 E3 00 30 52 E2 01 30 A0 13 3C 20 1B E5 04 30 82 E5 64 30 9F E5 02 00 A0 E1 00 30 82 E5 40 30 1B E5 08 30 82 E5 01 30 A0 E3 01 20 A0 E1 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 30 20 1B E5 00 30 A0 E3 3C 00 1B E5 34 30 0B E5 3C 20 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_249_3 {
	meta:
		name = "_ZNSt10moneypunctIwLb0EEC1EPSt18__moneypunct_cacheIwLb0EEj"
		size = 204
		refs = "0040 _Unwind_SjLj_Register 007c _ZNSt10moneypunctIwLb0EE24_M_initialize_moneypunctEPiPKc 0084 _Unwind_SjLj_Unregister 00a8 _ZNSt6locale5facetD2Ev 00b8 _Unwind_SjLj_Resume 00bc __gxx_personality_sj0 00c0 .gcc_except_table 00c4 .text$_ZNSt10moneypunctIwLb0EEC1EPSt18__moneypunct_cacheIwLb0EEj 00c8 _ZTVSt10moneypunctIwLb0EE"
	strings:
		$1 = { 00 48 2D E9 B0 30 9F E5 04 B0 8D E2 40 D0 4D E2 20 30 0B E5 A4 30 9F E5 3C 00 0B E5 1C 30 0B E5 9C 30 9F E5 38 00 4B E2 14 30 0B E5 04 30 4B E2 18 30 0B E5 40 10 0B E5 44 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 44 20 1B E5 00 10 A0 E3 00 30 52 E2 01 30 A0 13 3C 20 1B E5 04 30 82 E5 64 30 9F E5 02 00 A0 E1 00 30 82 E5 40 30 1B E5 08 30 82 E5 01 30 A0 E3 01 20 A0 E1 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 30 20 1B E5 00 30 A0 E3 3C 00 1B E5 34 30 0B E5 3C 20 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_250_3 {
	meta:
		name = "_ZNSt10moneypunctIwLb0EEC2EPSt18__moneypunct_cacheIwLb0EEj"
		size = 204
		refs = "0040 _Unwind_SjLj_Register 007c _ZNSt10moneypunctIwLb0EE24_M_initialize_moneypunctEPiPKc 0084 _Unwind_SjLj_Unregister 00a8 _ZNSt6locale5facetD2Ev 00b8 _Unwind_SjLj_Resume 00bc __gxx_personality_sj0 00c0 .gcc_except_table 00c4 .text$_ZNSt10moneypunctIwLb0EEC2EPSt18__moneypunct_cacheIwLb0EEj 00c8 _ZTVSt10moneypunctIwLb0EE"
	strings:
		$1 = { 00 48 2D E9 B0 30 9F E5 04 B0 8D E2 40 D0 4D E2 20 30 0B E5 A4 30 9F E5 3C 00 0B E5 1C 30 0B E5 9C 30 9F E5 38 00 4B E2 14 30 0B E5 04 30 4B E2 18 30 0B E5 40 10 0B E5 44 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 44 20 1B E5 00 10 A0 E3 00 30 52 E2 01 30 A0 13 3C 20 1B E5 04 30 82 E5 64 30 9F E5 02 00 A0 E1 00 30 82 E5 40 30 1B E5 08 30 82 E5 01 30 A0 E3 01 20 A0 E1 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 30 20 1B E5 00 30 A0 E3 3C 00 1B E5 34 30 0B E5 3C 20 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_241_3 {
	meta:
		name = "_ZNSt10moneypunctIwLb1EEC2EPSt18__moneypunct_cacheIwLb1EEj"
		size = 204
		refs = "0040 _Unwind_SjLj_Register 007c _ZNSt10moneypunctIwLb1EE24_M_initialize_moneypunctEPiPKc 0084 _Unwind_SjLj_Unregister 00a8 _ZNSt6locale5facetD2Ev 00b8 _Unwind_SjLj_Resume 00bc __gxx_personality_sj0 00c0 .gcc_except_table 00c4 .text$_ZNSt10moneypunctIwLb1EEC2EPSt18__moneypunct_cacheIwLb1EEj 00c8 _ZTVSt10moneypunctIwLb1EE"
	strings:
		$1 = { 00 48 2D E9 B0 30 9F E5 04 B0 8D E2 40 D0 4D E2 20 30 0B E5 A4 30 9F E5 3C 00 0B E5 1C 30 0B E5 9C 30 9F E5 38 00 4B E2 14 30 0B E5 04 30 4B E2 18 30 0B E5 40 10 0B E5 44 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 44 20 1B E5 00 10 A0 E3 00 30 52 E2 01 30 A0 13 3C 20 1B E5 04 30 82 E5 64 30 9F E5 02 00 A0 E1 00 30 82 E5 40 30 1B E5 08 30 82 E5 01 30 A0 E3 01 20 A0 E1 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 30 20 1B E5 00 30 A0 E3 3C 00 1B E5 34 30 0B E5 3C 20 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_242_3 {
	meta:
		name = "_ZNSt10moneypunctIwLb1EEC1Ej"
		size = 196
		refs = "003c _Unwind_SjLj_Register 0074 _ZNSt10moneypunctIwLb1EE24_M_initialize_moneypunctEPiPKc 007c _Unwind_SjLj_Unregister 00a0 _ZNSt6locale5facetD2Ev 00b0 _Unwind_SjLj_Resume 00b4 __gxx_personality_sj0 00b8 .gcc_except_table 00bc .text$_ZNSt10moneypunctIwLb1EEC1Ej 00c0 _ZTVSt10moneypunctIwLb1EE"
	strings:
		$1 = { 00 48 2D E9 A8 30 9F E5 04 B0 8D E2 3C D0 4D E2 20 30 0B E5 9C 30 9F E5 3C 00 0B E5 1C 30 0B E5 04 00 4B E2 90 30 9F E5 18 00 0B E5 38 00 4B E2 14 30 0B E5 40 10 0B E5 10 D0 0B E5 ?? ?? ?? ?? 40 10 1B E5 00 30 A0 E3 3C 00 1B E5 03 20 51 E0 01 20 A0 13 04 20 80 E5 60 20 9F E5 03 10 A0 E1 00 20 80 E5 08 30 80 E5 01 20 A0 E1 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 30 10 1B E5 00 30 A0 E3 3C 00 1B E5 34 30 0B E5 3C 10 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_252_3 {
	meta:
		name = "_ZNSt10moneypunctIcLb0EEC1Ej"
		size = 196
		refs = "003c _Unwind_SjLj_Register 0074 _ZNSt10moneypunctIcLb0EE24_M_initialize_moneypunctEPiPKc 007c _Unwind_SjLj_Unregister 00a0 _ZNSt6locale5facetD2Ev 00b0 _Unwind_SjLj_Resume 00b4 __gxx_personality_sj0 00b8 .gcc_except_table 00bc .text$_ZNSt10moneypunctIcLb0EEC1Ej 00c0 _ZTVSt10moneypunctIcLb0EE"
	strings:
		$1 = { 00 48 2D E9 A8 30 9F E5 04 B0 8D E2 3C D0 4D E2 20 30 0B E5 9C 30 9F E5 3C 00 0B E5 1C 30 0B E5 04 00 4B E2 90 30 9F E5 18 00 0B E5 38 00 4B E2 14 30 0B E5 40 10 0B E5 10 D0 0B E5 ?? ?? ?? ?? 40 10 1B E5 00 30 A0 E3 3C 00 1B E5 03 20 51 E0 01 20 A0 13 04 20 80 E5 60 20 9F E5 03 10 A0 E1 00 20 80 E5 08 30 80 E5 01 20 A0 E1 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 30 10 1B E5 00 30 A0 E3 3C 00 1B E5 34 30 0B E5 3C 10 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_253_3 {
	meta:
		name = "_ZNSt10moneypunctIcLb0EEC2Ej"
		size = 196
		refs = "003c _Unwind_SjLj_Register 0074 _ZNSt10moneypunctIcLb0EE24_M_initialize_moneypunctEPiPKc 007c _Unwind_SjLj_Unregister 00a0 _ZNSt6locale5facetD2Ev 00b0 _Unwind_SjLj_Resume 00b4 __gxx_personality_sj0 00b8 .gcc_except_table 00bc .text$_ZNSt10moneypunctIcLb0EEC2Ej 00c0 _ZTVSt10moneypunctIcLb0EE"
	strings:
		$1 = { 00 48 2D E9 A8 30 9F E5 04 B0 8D E2 3C D0 4D E2 20 30 0B E5 9C 30 9F E5 3C 00 0B E5 1C 30 0B E5 04 00 4B E2 90 30 9F E5 18 00 0B E5 38 00 4B E2 14 30 0B E5 40 10 0B E5 10 D0 0B E5 ?? ?? ?? ?? 40 10 1B E5 00 30 A0 E3 3C 00 1B E5 03 20 51 E0 01 20 A0 13 04 20 80 E5 60 20 9F E5 03 10 A0 E1 00 20 80 E5 08 30 80 E5 01 20 A0 E1 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 30 10 1B E5 00 30 A0 E3 3C 00 1B E5 34 30 0B E5 3C 10 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_243_3 {
	meta:
		name = "_ZNSt10moneypunctIcLb1EEC1Ej"
		size = 196
		refs = "003c _Unwind_SjLj_Register 0074 _ZNSt10moneypunctIcLb1EE24_M_initialize_moneypunctEPiPKc 007c _Unwind_SjLj_Unregister 00a0 _ZNSt6locale5facetD2Ev 00b0 _Unwind_SjLj_Resume 00b4 __gxx_personality_sj0 00b8 .gcc_except_table 00bc .text$_ZNSt10moneypunctIcLb1EEC1Ej 00c0 _ZTVSt10moneypunctIcLb1EE"
	strings:
		$1 = { 00 48 2D E9 A8 30 9F E5 04 B0 8D E2 3C D0 4D E2 20 30 0B E5 9C 30 9F E5 3C 00 0B E5 1C 30 0B E5 04 00 4B E2 90 30 9F E5 18 00 0B E5 38 00 4B E2 14 30 0B E5 40 10 0B E5 10 D0 0B E5 ?? ?? ?? ?? 40 10 1B E5 00 30 A0 E3 3C 00 1B E5 03 20 51 E0 01 20 A0 13 04 20 80 E5 60 20 9F E5 03 10 A0 E1 00 20 80 E5 08 30 80 E5 01 20 A0 E1 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 30 10 1B E5 00 30 A0 E3 3C 00 1B E5 34 30 0B E5 3C 10 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_244_3 {
	meta:
		name = "_ZNSt10moneypunctIcLb1EEC2Ej"
		size = 196
		refs = "003c _Unwind_SjLj_Register 0074 _ZNSt10moneypunctIcLb1EE24_M_initialize_moneypunctEPiPKc 007c _Unwind_SjLj_Unregister 00a0 _ZNSt6locale5facetD2Ev 00b0 _Unwind_SjLj_Resume 00b4 __gxx_personality_sj0 00b8 .gcc_except_table 00bc .text$_ZNSt10moneypunctIcLb1EEC2Ej 00c0 _ZTVSt10moneypunctIcLb1EE"
	strings:
		$1 = { 00 48 2D E9 A8 30 9F E5 04 B0 8D E2 3C D0 4D E2 20 30 0B E5 9C 30 9F E5 3C 00 0B E5 1C 30 0B E5 04 00 4B E2 90 30 9F E5 18 00 0B E5 38 00 4B E2 14 30 0B E5 40 10 0B E5 10 D0 0B E5 ?? ?? ?? ?? 40 10 1B E5 00 30 A0 E3 3C 00 1B E5 03 20 51 E0 01 20 A0 13 04 20 80 E5 60 20 9F E5 03 10 A0 E1 00 20 80 E5 08 30 80 E5 01 20 A0 E1 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 30 10 1B E5 00 30 A0 E3 3C 00 1B E5 34 30 0B E5 3C 10 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_251_3 {
	meta:
		name = "_ZNSt10moneypunctIwLb0EEC1Ej"
		size = 196
		refs = "003c _Unwind_SjLj_Register 0074 _ZNSt10moneypunctIwLb0EE24_M_initialize_moneypunctEPiPKc 007c _Unwind_SjLj_Unregister 00a0 _ZNSt6locale5facetD2Ev 00b0 _Unwind_SjLj_Resume 00b4 __gxx_personality_sj0 00b8 .gcc_except_table 00bc .text$_ZNSt10moneypunctIwLb0EEC1Ej 00c0 _ZTVSt10moneypunctIwLb0EE"
	strings:
		$1 = { 00 48 2D E9 A8 30 9F E5 04 B0 8D E2 3C D0 4D E2 20 30 0B E5 9C 30 9F E5 3C 00 0B E5 1C 30 0B E5 04 00 4B E2 90 30 9F E5 18 00 0B E5 38 00 4B E2 14 30 0B E5 40 10 0B E5 10 D0 0B E5 ?? ?? ?? ?? 40 10 1B E5 00 30 A0 E3 3C 00 1B E5 03 20 51 E0 01 20 A0 13 04 20 80 E5 60 20 9F E5 03 10 A0 E1 00 20 80 E5 08 30 80 E5 01 20 A0 E1 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 30 10 1B E5 00 30 A0 E3 3C 00 1B E5 34 30 0B E5 3C 10 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_252_3 {
	meta:
		name = "_ZNSt10moneypunctIwLb0EEC2Ej"
		size = 196
		refs = "003c _Unwind_SjLj_Register 0074 _ZNSt10moneypunctIwLb0EE24_M_initialize_moneypunctEPiPKc 007c _Unwind_SjLj_Unregister 00a0 _ZNSt6locale5facetD2Ev 00b0 _Unwind_SjLj_Resume 00b4 __gxx_personality_sj0 00b8 .gcc_except_table 00bc .text$_ZNSt10moneypunctIwLb0EEC2Ej 00c0 _ZTVSt10moneypunctIwLb0EE"
	strings:
		$1 = { 00 48 2D E9 A8 30 9F E5 04 B0 8D E2 3C D0 4D E2 20 30 0B E5 9C 30 9F E5 3C 00 0B E5 1C 30 0B E5 04 00 4B E2 90 30 9F E5 18 00 0B E5 38 00 4B E2 14 30 0B E5 40 10 0B E5 10 D0 0B E5 ?? ?? ?? ?? 40 10 1B E5 00 30 A0 E3 3C 00 1B E5 03 20 51 E0 01 20 A0 13 04 20 80 E5 60 20 9F E5 03 10 A0 E1 00 20 80 E5 08 30 80 E5 01 20 A0 E1 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 30 10 1B E5 00 30 A0 E3 3C 00 1B E5 34 30 0B E5 3C 10 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_243_3 {
	meta:
		name = "_ZNSt10moneypunctIwLb1EEC2Ej"
		size = 196
		refs = "003c _Unwind_SjLj_Register 0074 _ZNSt10moneypunctIwLb1EE24_M_initialize_moneypunctEPiPKc 007c _Unwind_SjLj_Unregister 00a0 _ZNSt6locale5facetD2Ev 00b0 _Unwind_SjLj_Resume 00b4 __gxx_personality_sj0 00b8 .gcc_except_table 00bc .text$_ZNSt10moneypunctIwLb1EEC2Ej 00c0 _ZTVSt10moneypunctIwLb1EE"
	strings:
		$1 = { 00 48 2D E9 A8 30 9F E5 04 B0 8D E2 3C D0 4D E2 20 30 0B E5 9C 30 9F E5 3C 00 0B E5 1C 30 0B E5 04 00 4B E2 90 30 9F E5 18 00 0B E5 38 00 4B E2 14 30 0B E5 40 10 0B E5 10 D0 0B E5 ?? ?? ?? ?? 40 10 1B E5 00 30 A0 E3 3C 00 1B E5 03 20 51 E0 01 20 A0 13 04 20 80 E5 60 20 9F E5 03 10 A0 E1 00 20 80 E5 08 30 80 E5 01 20 A0 E1 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 30 10 1B E5 00 30 A0 E3 3C 00 1B E5 34 30 0B E5 3C 10 0B E5 ?? ?? ?? ?? 00 30 E0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_259_3 {
	meta:
		name = "_ZNKSt8time_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE3putES3_RSt8ios_basewPK2tmPKwSB_"
		size = 444
		refs = "002c _ZSt9use_facetISt5ctypeIwEERKT_RKSt6locale"
	strings:
		$1 = { F0 4F 2D E9 2C D0 4D E2 50 C0 9D E5 18 00 8D E5 1C A0 8D E2 6C 00 8C E2 5C 40 9D E5 60 60 9D E5 0C 00 8A E8 01 70 A0 E1 B4 B5 DD E1 ?? ?? ?? ?? 06 00 54 E1 00 50 A0 E1 45 00 00 0A 04 30 8A E2 24 90 8D E2 14 30 8D E5 07 80 A0 E1 06 00 00 EA 20 30 DD E5 B0 10 D4 E1 00 00 53 E3 43 00 00 0A 02 40 84 E2 04 00 56 E1 39 00 00 0A 00 30 95 E5 05 00 A0 E1 B0 10 D4 E1 00 20 A0 E3 0F E0 A0 E1 30 F0 93 E5 00 0C A0 E1 25 04 50 E3 EF FF FF 1A 02 40 84 E2 04 00 56 E1 2D 00 00 0A 00 20 A0 E3 00 30 95 E5 05 00 A0 E1 B0 10 D4 E1 0F E0 A0 E1 30 F0 93 E5 FF 00 00 E2 00 7C A0 E1 47 7C A0 E1 4F 00 57 E3 45 00 57 13 00 20 A0 03 01 20 A0 13 00 70 A0 13 08 00 00 1A 02 40 84 E2 04 00 56 E1 1B 00 00 0A 00 30 95 E5 05 00 A0 E1 B0 10 D4 E1 0F E0 A0 E1 30 F0 93 E5 FF 00 00 E2 50 C0 9D E5 58 30 9D E5 00 0C A0 E1 40 0C A0 E1 0C 00 8D E5 10 70 8D E5 00 C0 8D E5 04 B0 8D E5 08 30 8D E5 09 00 A0 E1 08 10 A0 E1 00 C0 98 E5 0C 00 9A E8 0F E0 A0 E1 08 F0 9C E5 03 00 99 E8 14 C0 9D E5 02 40 84 E2 04 00 56 E1 00 00 8A E5 00 10 CC E5 C5 FF FF 1A 18 30 9D E5 03 00 9A E8 00 00 83 E5 04 10 C3 E5 03 00 A0 E1 2C D0 8D E2 F0 8F BD E8 1C 30 9D E5 14 20 93 E5 18 00 93 E5 00 00 52 E1 B2 10 C2 30 14 20 83 35 04 00 00 2A 24 C0 9F E5 0C 00 51 E1 01 30 A0 03 20 30 CD 05 AF FF FF EA 03 00 A0 E1 00 30 93 E5 0F E0 A0 E1 34 F0 93 E5 00 10 A0 E1 F4 FF FF EA FF FF 00 00 }
	condition:
		$1
}

rule file_17_260_3 {
	meta:
		name = "_ZNSt5__padIwSt11char_traitsIwEE6_S_padERSt8ios_basewPwPKwii"
		size = 332
		refs = "004c wmemset 0060 wmemcpy 0068 _ZSt9use_facetISt5ctypeIwEERKT_RKSt6locale 00c8 _ZNKSt21__ctype_abstract_baseIwE5widenEc"
	strings:
		$1 = { 0C C0 90 E5 F0 47 2D E9 B0 C0 0C E2 24 40 9D E5 20 60 9D E5 01 18 A0 E1 20 00 5C E3 02 50 A0 E1 03 80 A0 E1 21 98 A0 E1 06 60 64 E0 1A 00 00 0A 10 00 5C E3 0A 00 00 0A 00 70 A0 E3 07 A0 A0 E1 09 10 A0 E1 06 20 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 86 00 85 E0 07 10 88 E0 04 20 6A E0 F0 47 BD E8 ?? ?? ?? ?? 6C 00 80 E2 ?? ?? ?? ?? 2D 10 A0 E3 00 30 90 E5 00 70 A0 E1 0F E0 A0 E1 28 F0 93 E5 B0 30 D8 E1 00 00 53 E1 0C 00 00 1A B2 00 C5 E0 02 70 A0 E3 01 A0 A0 E3 E8 FF FF EA 03 10 A0 E1 04 20 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 84 00 85 E0 09 10 A0 E1 06 20 A0 E1 F0 47 BD E8 ?? ?? ?? ?? 07 00 A0 E1 2B 10 A0 E3 ?? ?? ?? ?? B0 30 D8 E1 00 00 53 E1 EC FF FF 0A 07 00 A0 E1 30 10 A0 E3 ?? ?? ?? ?? B0 30 D8 E1 00 00 53 E1 D1 FF FF 1A 01 00 54 E3 CF FF FF DA 07 00 A0 E1 78 10 A0 E3 ?? ?? ?? ?? B2 30 D8 E1 00 00 53 E1 07 00 00 1A B0 30 D8 E1 04 70 A0 E3 B0 30 C5 E1 B2 30 D8 E1 02 A0 A0 E3 B2 30 C5 E1 04 50 85 E2 C3 FF FF EA 07 00 A0 E1 58 10 A0 E3 ?? ?? ?? ?? B2 30 D8 E1 00 00 53 E1 BB FF FF 1A F0 FF FF EA }
	condition:
		$1
}

rule file_17_261_3 {
	meta:
		name = "_ZNKSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE6_M_padEwiRSt8ios_basePwPKwRi"
		size = 60
		refs = "002c _ZNSt5__padIwSt11char_traitsIwEE6_S_padERSt8ios_basewPwPKwii"
	strings:
		$1 = { 30 40 2D E9 08 D0 4D E2 1C 40 9D E5 01 18 A0 E1 00 C0 94 E5 02 50 A0 E1 03 00 A0 E1 21 18 A0 E1 14 20 9D E5 18 30 9D E5 20 10 8D E8 ?? ?? ?? ?? 00 50 84 E5 08 D0 8D E2 30 80 BD E8 }
	condition:
		$1
}

rule file_17_262_3 {
	meta:
		name = "_ZNSt15numpunct_bynameIwEC1EPKcj"
		size = 352
		refs = "0040 _Unwind_SjLj_Register 0074 _ZNSt8numpunctIwE22_M_initialize_numpunctEPi 008c strcmp 00b4 _Unwind_SjLj_Unregister 00d4 _ZNSt6locale5facet18_S_create_c_localeERPiPKcS1_ 00e8 _ZNSt6locale5facet19_S_destroy_c_localeERPi 0114 _ZNSt6locale5facetD2Ev 0124 _Unwind_SjLj_Resume 0134 _ZNSt8numpunctIwED2Ev 0148 __gxx_personality_sj0 014c .gcc_except_table 0150 .text$_ZNSt15numpunct_bynameIwEC1EPKcj 0154 _ZTVSt8numpunctIwE 0158 _ZTVSt15numpunct_bynameIwE 015c .rdata"
	strings:
		$1 = { 00 48 2D E9 3C 31 9F E5 04 B0 8D E2 44 D0 4D E2 24 30 0B E5 30 31 9F E5 40 00 0B E5 20 30 0B E5 28 31 9F E5 3C 00 4B E2 18 30 0B E5 04 30 4B E2 1C 30 0B E5 44 10 0B E5 48 20 0B E5 14 D0 0B E5 ?? ?? ?? ?? 48 20 1B E5 00 10 A0 E3 00 30 52 E2 01 30 A0 13 40 20 1B E5 04 30 82 E5 F0 30 9F E5 08 10 82 E5 00 30 82 E5 02 00 A0 E1 01 30 A0 E3 38 30 0B E5 ?? ?? ?? ?? D8 30 9F E5 40 20 1B E5 44 00 1B E5 00 30 82 E5 CC 10 9F E5 ?? ?? ?? ?? 00 00 50 E3 05 00 00 0A BC 30 9F E5 44 00 1B E5 04 10 83 E2 ?? ?? ?? ?? 00 00 50 E3 03 00 00 1A 3C 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 02 30 A0 E3 44 10 1B E5 08 00 4B E2 00 20 A0 E3 38 30 0B E5 ?? ?? ?? ?? 40 00 1B E5 08 10 1B E5 ?? ?? ?? ?? 08 00 4B E2 ?? ?? ?? ?? EF FF FF EA 04 B0 8B E2 34 30 1B E5 44 30 0B E5 38 30 1B E5 01 00 53 E3 07 00 00 0A 00 30 A0 E3 40 00 1B E5 38 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 44 00 1B E5 38 30 0B E5 ?? ?? ?? ?? 00 30 A0 E3 40 00 1B E5 38 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 44 00 1B E5 38 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_261_3 {
	meta:
		name = "_ZNSt15numpunct_bynameIcEC1EPKcj"
		size = 352
		refs = "0040 _Unwind_SjLj_Register 0074 _ZNSt8numpunctIcE22_M_initialize_numpunctEPi 008c strcmp 00b4 _Unwind_SjLj_Unregister 00d4 _ZNSt6locale5facet18_S_create_c_localeERPiPKcS1_ 00e8 _ZNSt6locale5facet19_S_destroy_c_localeERPi 0114 _ZNSt6locale5facetD2Ev 0124 _Unwind_SjLj_Resume 0134 _ZNSt8numpunctIcED2Ev 0148 __gxx_personality_sj0 014c .gcc_except_table 0150 .text$_ZNSt15numpunct_bynameIcEC1EPKcj 0154 _ZTVSt8numpunctIcE 0158 _ZTVSt15numpunct_bynameIcE 015c .rdata"
	strings:
		$1 = { 00 48 2D E9 3C 31 9F E5 04 B0 8D E2 44 D0 4D E2 24 30 0B E5 30 31 9F E5 40 00 0B E5 20 30 0B E5 28 31 9F E5 3C 00 4B E2 18 30 0B E5 04 30 4B E2 1C 30 0B E5 44 10 0B E5 48 20 0B E5 14 D0 0B E5 ?? ?? ?? ?? 48 20 1B E5 00 10 A0 E3 00 30 52 E2 01 30 A0 13 40 20 1B E5 04 30 82 E5 F0 30 9F E5 08 10 82 E5 00 30 82 E5 02 00 A0 E1 01 30 A0 E3 38 30 0B E5 ?? ?? ?? ?? D8 30 9F E5 40 20 1B E5 44 00 1B E5 00 30 82 E5 CC 10 9F E5 ?? ?? ?? ?? 00 00 50 E3 05 00 00 0A BC 30 9F E5 44 00 1B E5 04 10 83 E2 ?? ?? ?? ?? 00 00 50 E3 03 00 00 1A 3C 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 02 30 A0 E3 44 10 1B E5 08 00 4B E2 00 20 A0 E3 38 30 0B E5 ?? ?? ?? ?? 40 00 1B E5 08 10 1B E5 ?? ?? ?? ?? 08 00 4B E2 ?? ?? ?? ?? EF FF FF EA 04 B0 8B E2 34 30 1B E5 44 30 0B E5 38 30 1B E5 01 00 53 E3 07 00 00 0A 00 30 A0 E3 40 00 1B E5 38 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 44 00 1B E5 38 30 0B E5 ?? ?? ?? ?? 00 30 A0 E3 40 00 1B E5 38 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 44 00 1B E5 38 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_262_3 {
	meta:
		name = "_ZNSt15numpunct_bynameIcEC2EPKcj"
		size = 352
		refs = "0040 _Unwind_SjLj_Register 0074 _ZNSt8numpunctIcE22_M_initialize_numpunctEPi 008c strcmp 00b4 _Unwind_SjLj_Unregister 00d4 _ZNSt6locale5facet18_S_create_c_localeERPiPKcS1_ 00e8 _ZNSt6locale5facet19_S_destroy_c_localeERPi 0114 _ZNSt6locale5facetD2Ev 0124 _Unwind_SjLj_Resume 0134 _ZNSt8numpunctIcED2Ev 0148 __gxx_personality_sj0 014c .gcc_except_table 0150 .text$_ZNSt15numpunct_bynameIcEC2EPKcj 0154 _ZTVSt8numpunctIcE 0158 _ZTVSt15numpunct_bynameIcE 015c .rdata"
	strings:
		$1 = { 00 48 2D E9 3C 31 9F E5 04 B0 8D E2 44 D0 4D E2 24 30 0B E5 30 31 9F E5 40 00 0B E5 20 30 0B E5 28 31 9F E5 3C 00 4B E2 18 30 0B E5 04 30 4B E2 1C 30 0B E5 44 10 0B E5 48 20 0B E5 14 D0 0B E5 ?? ?? ?? ?? 48 20 1B E5 00 10 A0 E3 00 30 52 E2 01 30 A0 13 40 20 1B E5 04 30 82 E5 F0 30 9F E5 08 10 82 E5 00 30 82 E5 02 00 A0 E1 01 30 A0 E3 38 30 0B E5 ?? ?? ?? ?? D8 30 9F E5 40 20 1B E5 44 00 1B E5 00 30 82 E5 CC 10 9F E5 ?? ?? ?? ?? 00 00 50 E3 05 00 00 0A BC 30 9F E5 44 00 1B E5 04 10 83 E2 ?? ?? ?? ?? 00 00 50 E3 03 00 00 1A 3C 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 02 30 A0 E3 44 10 1B E5 08 00 4B E2 00 20 A0 E3 38 30 0B E5 ?? ?? ?? ?? 40 00 1B E5 08 10 1B E5 ?? ?? ?? ?? 08 00 4B E2 ?? ?? ?? ?? EF FF FF EA 04 B0 8B E2 34 30 1B E5 44 30 0B E5 38 30 1B E5 01 00 53 E3 07 00 00 0A 00 30 A0 E3 40 00 1B E5 38 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 44 00 1B E5 38 30 0B E5 ?? ?? ?? ?? 00 30 A0 E3 40 00 1B E5 38 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 44 00 1B E5 38 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_263_3 {
	meta:
		name = "_ZNSt15numpunct_bynameIwEC2EPKcj"
		size = 352
		refs = "0040 _Unwind_SjLj_Register 0074 _ZNSt8numpunctIwE22_M_initialize_numpunctEPi 008c strcmp 00b4 _Unwind_SjLj_Unregister 00d4 _ZNSt6locale5facet18_S_create_c_localeERPiPKcS1_ 00e8 _ZNSt6locale5facet19_S_destroy_c_localeERPi 0114 _ZNSt6locale5facetD2Ev 0124 _Unwind_SjLj_Resume 0134 _ZNSt8numpunctIwED2Ev 0148 __gxx_personality_sj0 014c .gcc_except_table 0150 .text$_ZNSt15numpunct_bynameIwEC2EPKcj 0154 _ZTVSt8numpunctIwE 0158 _ZTVSt15numpunct_bynameIwE 015c .rdata"
	strings:
		$1 = { 00 48 2D E9 3C 31 9F E5 04 B0 8D E2 44 D0 4D E2 24 30 0B E5 30 31 9F E5 40 00 0B E5 20 30 0B E5 28 31 9F E5 3C 00 4B E2 18 30 0B E5 04 30 4B E2 1C 30 0B E5 44 10 0B E5 48 20 0B E5 14 D0 0B E5 ?? ?? ?? ?? 48 20 1B E5 00 10 A0 E3 00 30 52 E2 01 30 A0 13 40 20 1B E5 04 30 82 E5 F0 30 9F E5 08 10 82 E5 00 30 82 E5 02 00 A0 E1 01 30 A0 E3 38 30 0B E5 ?? ?? ?? ?? D8 30 9F E5 40 20 1B E5 44 00 1B E5 00 30 82 E5 CC 10 9F E5 ?? ?? ?? ?? 00 00 50 E3 05 00 00 0A BC 30 9F E5 44 00 1B E5 04 10 83 E2 ?? ?? ?? ?? 00 00 50 E3 03 00 00 1A 3C 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 02 30 A0 E3 44 10 1B E5 08 00 4B E2 00 20 A0 E3 38 30 0B E5 ?? ?? ?? ?? 40 00 1B E5 08 10 1B E5 ?? ?? ?? ?? 08 00 4B E2 ?? ?? ?? ?? EF FF FF EA 04 B0 8B E2 34 30 1B E5 44 30 0B E5 38 30 1B E5 01 00 53 E3 07 00 00 0A 00 30 A0 E3 40 00 1B E5 38 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 44 00 1B E5 38 30 0B E5 ?? ?? ?? ?? 00 30 A0 E3 40 00 1B E5 38 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 44 00 1B E5 38 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_264_3 {
	meta:
		name = "_ZNSt17moneypunct_bynameIwLb0EEC1EPKcj"
		size = 360
		refs = "0040 _Unwind_SjLj_Register 0078 _ZNSt10moneypunctIwLb0EE24_M_initialize_moneypunctEPiPKc 0090 strcmp 00b8 _Unwind_SjLj_Unregister 00d8 _ZNSt6locale5facet18_S_create_c_localeERPiPKcS1_ 00f0 _ZNSt6locale5facet19_S_destroy_c_localeERPi 011c _ZNSt6locale5facetD2Ev 012c _Unwind_SjLj_Resume 013c _ZNSt10moneypunctIwLb0EED2Ev 0150 __gxx_personality_sj0 0154 .gcc_except_table 0158 .text$_ZNSt17moneypunct_bynameIwLb0EEC1EPKcj 015c _ZTVSt10moneypunctIwLb0EE 0160 _ZTVSt17moneypunct_bynameIwLb0EE 0164 .rdata"
	strings:
		$1 = { 00 48 2D E9 44 31 9F E5 04 B0 8D E2 44 D0 4D E2 24 30 0B E5 38 31 9F E5 40 00 0B E5 20 30 0B E5 04 00 4B E2 2C 31 9F E5 1C 00 0B E5 3C 00 4B E2 18 30 0B E5 48 20 0B E5 44 10 0B E5 14 D0 0B E5 ?? ?? ?? ?? 48 10 1B E5 00 30 A0 E3 40 00 1B E5 03 20 51 E0 01 20 A0 13 04 20 80 E5 F8 20 9F E5 03 10 A0 E1 00 20 80 E5 08 30 80 E5 01 20 A0 E1 01 30 A0 E3 38 30 0B E5 ?? ?? ?? ?? DC 30 9F E5 40 20 1B E5 44 00 1B E5 00 30 82 E5 D0 10 9F E5 ?? ?? ?? ?? 00 00 50 E3 05 00 00 0A C0 30 9F E5 44 00 1B E5 04 10 83 E2 ?? ?? ?? ?? 00 00 50 E3 03 00 00 1A 3C 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 02 30 A0 E3 44 10 1B E5 08 00 4B E2 00 20 A0 E3 38 30 0B E5 ?? ?? ?? ?? 40 00 1B E5 08 10 1B E5 00 20 A0 E3 ?? ?? ?? ?? 08 00 4B E2 ?? ?? ?? ?? EE FF FF EA 04 B0 8B E2 38 30 1B E5 34 10 1B E5 01 00 53 E3 44 10 0B E5 07 00 00 0A 00 30 A0 E3 40 00 1B E5 38 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 44 00 1B E5 38 30 0B E5 ?? ?? ?? ?? 00 30 A0 E3 40 00 1B E5 38 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 44 00 1B E5 38 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_266_3 {
	meta:
		name = "_ZNSt17moneypunct_bynameIcLb0EEC1EPKcj"
		size = 360
		refs = "0040 _Unwind_SjLj_Register 0078 _ZNSt10moneypunctIcLb0EE24_M_initialize_moneypunctEPiPKc 0090 strcmp 00b8 _Unwind_SjLj_Unregister 00d8 _ZNSt6locale5facet18_S_create_c_localeERPiPKcS1_ 00f0 _ZNSt6locale5facet19_S_destroy_c_localeERPi 011c _ZNSt6locale5facetD2Ev 012c _Unwind_SjLj_Resume 013c _ZNSt10moneypunctIcLb0EED2Ev 0150 __gxx_personality_sj0 0154 .gcc_except_table 0158 .text$_ZNSt17moneypunct_bynameIcLb0EEC1EPKcj 015c _ZTVSt10moneypunctIcLb0EE 0160 _ZTVSt17moneypunct_bynameIcLb0EE 0164 .rdata"
	strings:
		$1 = { 00 48 2D E9 44 31 9F E5 04 B0 8D E2 44 D0 4D E2 24 30 0B E5 38 31 9F E5 40 00 0B E5 20 30 0B E5 04 00 4B E2 2C 31 9F E5 1C 00 0B E5 3C 00 4B E2 18 30 0B E5 48 20 0B E5 44 10 0B E5 14 D0 0B E5 ?? ?? ?? ?? 48 10 1B E5 00 30 A0 E3 40 00 1B E5 03 20 51 E0 01 20 A0 13 04 20 80 E5 F8 20 9F E5 03 10 A0 E1 00 20 80 E5 08 30 80 E5 01 20 A0 E1 01 30 A0 E3 38 30 0B E5 ?? ?? ?? ?? DC 30 9F E5 40 20 1B E5 44 00 1B E5 00 30 82 E5 D0 10 9F E5 ?? ?? ?? ?? 00 00 50 E3 05 00 00 0A C0 30 9F E5 44 00 1B E5 04 10 83 E2 ?? ?? ?? ?? 00 00 50 E3 03 00 00 1A 3C 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 02 30 A0 E3 44 10 1B E5 08 00 4B E2 00 20 A0 E3 38 30 0B E5 ?? ?? ?? ?? 40 00 1B E5 08 10 1B E5 00 20 A0 E3 ?? ?? ?? ?? 08 00 4B E2 ?? ?? ?? ?? EE FF FF EA 04 B0 8B E2 38 30 1B E5 34 10 1B E5 01 00 53 E3 44 10 0B E5 07 00 00 0A 00 30 A0 E3 40 00 1B E5 38 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 44 00 1B E5 38 30 0B E5 ?? ?? ?? ?? 00 30 A0 E3 40 00 1B E5 38 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 44 00 1B E5 38 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_263_3 {
	meta:
		name = "_ZNSt17moneypunct_bynameIcLb0EEC2EPKcj"
		size = 360
		refs = "0040 _Unwind_SjLj_Register 0078 _ZNSt10moneypunctIcLb0EE24_M_initialize_moneypunctEPiPKc 0090 strcmp 00b8 _Unwind_SjLj_Unregister 00d8 _ZNSt6locale5facet18_S_create_c_localeERPiPKcS1_ 00f0 _ZNSt6locale5facet19_S_destroy_c_localeERPi 011c _ZNSt6locale5facetD2Ev 012c _Unwind_SjLj_Resume 013c _ZNSt10moneypunctIcLb0EED2Ev 0150 __gxx_personality_sj0 0154 .gcc_except_table 0158 .text$_ZNSt17moneypunct_bynameIcLb0EEC2EPKcj 015c _ZTVSt10moneypunctIcLb0EE 0160 _ZTVSt17moneypunct_bynameIcLb0EE 0164 .rdata"
	strings:
		$1 = { 00 48 2D E9 44 31 9F E5 04 B0 8D E2 44 D0 4D E2 24 30 0B E5 38 31 9F E5 40 00 0B E5 20 30 0B E5 04 00 4B E2 2C 31 9F E5 1C 00 0B E5 3C 00 4B E2 18 30 0B E5 48 20 0B E5 44 10 0B E5 14 D0 0B E5 ?? ?? ?? ?? 48 10 1B E5 00 30 A0 E3 40 00 1B E5 03 20 51 E0 01 20 A0 13 04 20 80 E5 F8 20 9F E5 03 10 A0 E1 00 20 80 E5 08 30 80 E5 01 20 A0 E1 01 30 A0 E3 38 30 0B E5 ?? ?? ?? ?? DC 30 9F E5 40 20 1B E5 44 00 1B E5 00 30 82 E5 D0 10 9F E5 ?? ?? ?? ?? 00 00 50 E3 05 00 00 0A C0 30 9F E5 44 00 1B E5 04 10 83 E2 ?? ?? ?? ?? 00 00 50 E3 03 00 00 1A 3C 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 02 30 A0 E3 44 10 1B E5 08 00 4B E2 00 20 A0 E3 38 30 0B E5 ?? ?? ?? ?? 40 00 1B E5 08 10 1B E5 00 20 A0 E3 ?? ?? ?? ?? 08 00 4B E2 ?? ?? ?? ?? EE FF FF EA 04 B0 8B E2 38 30 1B E5 34 10 1B E5 01 00 53 E3 44 10 0B E5 07 00 00 0A 00 30 A0 E3 40 00 1B E5 38 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 44 00 1B E5 38 30 0B E5 ?? ?? ?? ?? 00 30 A0 E3 40 00 1B E5 38 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 44 00 1B E5 38 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_264_3 {
	meta:
		name = "_ZNSt17moneypunct_bynameIcLb1EEC1EPKcj"
		size = 360
		refs = "0040 _Unwind_SjLj_Register 0078 _ZNSt10moneypunctIcLb1EE24_M_initialize_moneypunctEPiPKc 0090 strcmp 00b8 _Unwind_SjLj_Unregister 00d8 _ZNSt6locale5facet18_S_create_c_localeERPiPKcS1_ 00f0 _ZNSt6locale5facet19_S_destroy_c_localeERPi 011c _ZNSt6locale5facetD2Ev 012c _Unwind_SjLj_Resume 013c _ZNSt10moneypunctIcLb1EED2Ev 0150 __gxx_personality_sj0 0154 .gcc_except_table 0158 .text$_ZNSt17moneypunct_bynameIcLb1EEC1EPKcj 015c _ZTVSt10moneypunctIcLb1EE 0160 _ZTVSt17moneypunct_bynameIcLb1EE 0164 .rdata"
	strings:
		$1 = { 00 48 2D E9 44 31 9F E5 04 B0 8D E2 44 D0 4D E2 24 30 0B E5 38 31 9F E5 40 00 0B E5 20 30 0B E5 04 00 4B E2 2C 31 9F E5 1C 00 0B E5 3C 00 4B E2 18 30 0B E5 48 20 0B E5 44 10 0B E5 14 D0 0B E5 ?? ?? ?? ?? 48 10 1B E5 00 30 A0 E3 40 00 1B E5 03 20 51 E0 01 20 A0 13 04 20 80 E5 F8 20 9F E5 03 10 A0 E1 00 20 80 E5 08 30 80 E5 01 20 A0 E1 01 30 A0 E3 38 30 0B E5 ?? ?? ?? ?? DC 30 9F E5 40 20 1B E5 44 00 1B E5 00 30 82 E5 D0 10 9F E5 ?? ?? ?? ?? 00 00 50 E3 05 00 00 0A C0 30 9F E5 44 00 1B E5 04 10 83 E2 ?? ?? ?? ?? 00 00 50 E3 03 00 00 1A 3C 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 02 30 A0 E3 44 10 1B E5 08 00 4B E2 00 20 A0 E3 38 30 0B E5 ?? ?? ?? ?? 40 00 1B E5 08 10 1B E5 00 20 A0 E3 ?? ?? ?? ?? 08 00 4B E2 ?? ?? ?? ?? EE FF FF EA 04 B0 8B E2 38 30 1B E5 34 10 1B E5 01 00 53 E3 44 10 0B E5 07 00 00 0A 00 30 A0 E3 40 00 1B E5 38 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 44 00 1B E5 38 30 0B E5 ?? ?? ?? ?? 00 30 A0 E3 40 00 1B E5 38 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 44 00 1B E5 38 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_265_3 {
	meta:
		name = "_ZNSt17moneypunct_bynameIcLb1EEC2EPKcj"
		size = 360
		refs = "0040 _Unwind_SjLj_Register 0078 _ZNSt10moneypunctIcLb1EE24_M_initialize_moneypunctEPiPKc 0090 strcmp 00b8 _Unwind_SjLj_Unregister 00d8 _ZNSt6locale5facet18_S_create_c_localeERPiPKcS1_ 00f0 _ZNSt6locale5facet19_S_destroy_c_localeERPi 011c _ZNSt6locale5facetD2Ev 012c _Unwind_SjLj_Resume 013c _ZNSt10moneypunctIcLb1EED2Ev 0150 __gxx_personality_sj0 0154 .gcc_except_table 0158 .text$_ZNSt17moneypunct_bynameIcLb1EEC2EPKcj 015c _ZTVSt10moneypunctIcLb1EE 0160 _ZTVSt17moneypunct_bynameIcLb1EE 0164 .rdata"
	strings:
		$1 = { 00 48 2D E9 44 31 9F E5 04 B0 8D E2 44 D0 4D E2 24 30 0B E5 38 31 9F E5 40 00 0B E5 20 30 0B E5 04 00 4B E2 2C 31 9F E5 1C 00 0B E5 3C 00 4B E2 18 30 0B E5 48 20 0B E5 44 10 0B E5 14 D0 0B E5 ?? ?? ?? ?? 48 10 1B E5 00 30 A0 E3 40 00 1B E5 03 20 51 E0 01 20 A0 13 04 20 80 E5 F8 20 9F E5 03 10 A0 E1 00 20 80 E5 08 30 80 E5 01 20 A0 E1 01 30 A0 E3 38 30 0B E5 ?? ?? ?? ?? DC 30 9F E5 40 20 1B E5 44 00 1B E5 00 30 82 E5 D0 10 9F E5 ?? ?? ?? ?? 00 00 50 E3 05 00 00 0A C0 30 9F E5 44 00 1B E5 04 10 83 E2 ?? ?? ?? ?? 00 00 50 E3 03 00 00 1A 3C 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 02 30 A0 E3 44 10 1B E5 08 00 4B E2 00 20 A0 E3 38 30 0B E5 ?? ?? ?? ?? 40 00 1B E5 08 10 1B E5 00 20 A0 E3 ?? ?? ?? ?? 08 00 4B E2 ?? ?? ?? ?? EE FF FF EA 04 B0 8B E2 38 30 1B E5 34 10 1B E5 01 00 53 E3 44 10 0B E5 07 00 00 0A 00 30 A0 E3 40 00 1B E5 38 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 44 00 1B E5 38 30 0B E5 ?? ?? ?? ?? 00 30 A0 E3 40 00 1B E5 38 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 44 00 1B E5 38 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_265_3 {
	meta:
		name = "_ZNSt17moneypunct_bynameIwLb0EEC2EPKcj"
		size = 360
		refs = "0040 _Unwind_SjLj_Register 0078 _ZNSt10moneypunctIwLb0EE24_M_initialize_moneypunctEPiPKc 0090 strcmp 00b8 _Unwind_SjLj_Unregister 00d8 _ZNSt6locale5facet18_S_create_c_localeERPiPKcS1_ 00f0 _ZNSt6locale5facet19_S_destroy_c_localeERPi 011c _ZNSt6locale5facetD2Ev 012c _Unwind_SjLj_Resume 013c _ZNSt10moneypunctIwLb0EED2Ev 0150 __gxx_personality_sj0 0154 .gcc_except_table 0158 .text$_ZNSt17moneypunct_bynameIwLb0EEC2EPKcj 015c _ZTVSt10moneypunctIwLb0EE 0160 _ZTVSt17moneypunct_bynameIwLb0EE 0164 .rdata"
	strings:
		$1 = { 00 48 2D E9 44 31 9F E5 04 B0 8D E2 44 D0 4D E2 24 30 0B E5 38 31 9F E5 40 00 0B E5 20 30 0B E5 04 00 4B E2 2C 31 9F E5 1C 00 0B E5 3C 00 4B E2 18 30 0B E5 48 20 0B E5 44 10 0B E5 14 D0 0B E5 ?? ?? ?? ?? 48 10 1B E5 00 30 A0 E3 40 00 1B E5 03 20 51 E0 01 20 A0 13 04 20 80 E5 F8 20 9F E5 03 10 A0 E1 00 20 80 E5 08 30 80 E5 01 20 A0 E1 01 30 A0 E3 38 30 0B E5 ?? ?? ?? ?? DC 30 9F E5 40 20 1B E5 44 00 1B E5 00 30 82 E5 D0 10 9F E5 ?? ?? ?? ?? 00 00 50 E3 05 00 00 0A C0 30 9F E5 44 00 1B E5 04 10 83 E2 ?? ?? ?? ?? 00 00 50 E3 03 00 00 1A 3C 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 02 30 A0 E3 44 10 1B E5 08 00 4B E2 00 20 A0 E3 38 30 0B E5 ?? ?? ?? ?? 40 00 1B E5 08 10 1B E5 00 20 A0 E3 ?? ?? ?? ?? 08 00 4B E2 ?? ?? ?? ?? EE FF FF EA 04 B0 8B E2 38 30 1B E5 34 10 1B E5 01 00 53 E3 44 10 0B E5 07 00 00 0A 00 30 A0 E3 40 00 1B E5 38 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 44 00 1B E5 38 30 0B E5 ?? ?? ?? ?? 00 30 A0 E3 40 00 1B E5 38 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 44 00 1B E5 38 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_266_3 {
	meta:
		name = "_ZNSt17moneypunct_bynameIwLb1EEC1EPKcj"
		size = 360
		refs = "0040 _Unwind_SjLj_Register 0078 _ZNSt10moneypunctIwLb1EE24_M_initialize_moneypunctEPiPKc 0090 strcmp 00b8 _Unwind_SjLj_Unregister 00d8 _ZNSt6locale5facet18_S_create_c_localeERPiPKcS1_ 00f0 _ZNSt6locale5facet19_S_destroy_c_localeERPi 011c _ZNSt6locale5facetD2Ev 012c _Unwind_SjLj_Resume 013c _ZNSt10moneypunctIwLb1EED2Ev 0150 __gxx_personality_sj0 0154 .gcc_except_table 0158 .text$_ZNSt17moneypunct_bynameIwLb1EEC1EPKcj 015c _ZTVSt10moneypunctIwLb1EE 0160 _ZTVSt17moneypunct_bynameIwLb1EE 0164 .rdata"
	strings:
		$1 = { 00 48 2D E9 44 31 9F E5 04 B0 8D E2 44 D0 4D E2 24 30 0B E5 38 31 9F E5 40 00 0B E5 20 30 0B E5 04 00 4B E2 2C 31 9F E5 1C 00 0B E5 3C 00 4B E2 18 30 0B E5 48 20 0B E5 44 10 0B E5 14 D0 0B E5 ?? ?? ?? ?? 48 10 1B E5 00 30 A0 E3 40 00 1B E5 03 20 51 E0 01 20 A0 13 04 20 80 E5 F8 20 9F E5 03 10 A0 E1 00 20 80 E5 08 30 80 E5 01 20 A0 E1 01 30 A0 E3 38 30 0B E5 ?? ?? ?? ?? DC 30 9F E5 40 20 1B E5 44 00 1B E5 00 30 82 E5 D0 10 9F E5 ?? ?? ?? ?? 00 00 50 E3 05 00 00 0A C0 30 9F E5 44 00 1B E5 04 10 83 E2 ?? ?? ?? ?? 00 00 50 E3 03 00 00 1A 3C 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 02 30 A0 E3 44 10 1B E5 08 00 4B E2 00 20 A0 E3 38 30 0B E5 ?? ?? ?? ?? 40 00 1B E5 08 10 1B E5 00 20 A0 E3 ?? ?? ?? ?? 08 00 4B E2 ?? ?? ?? ?? EE FF FF EA 04 B0 8B E2 38 30 1B E5 34 10 1B E5 01 00 53 E3 44 10 0B E5 07 00 00 0A 00 30 A0 E3 40 00 1B E5 38 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 44 00 1B E5 38 30 0B E5 ?? ?? ?? ?? 00 30 A0 E3 40 00 1B E5 38 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 44 00 1B E5 38 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_267_3 {
	meta:
		name = "_ZNSt17moneypunct_bynameIwLb1EEC2EPKcj"
		size = 360
		refs = "0040 _Unwind_SjLj_Register 0078 _ZNSt10moneypunctIwLb1EE24_M_initialize_moneypunctEPiPKc 0090 strcmp 00b8 _Unwind_SjLj_Unregister 00d8 _ZNSt6locale5facet18_S_create_c_localeERPiPKcS1_ 00f0 _ZNSt6locale5facet19_S_destroy_c_localeERPi 011c _ZNSt6locale5facetD2Ev 012c _Unwind_SjLj_Resume 013c _ZNSt10moneypunctIwLb1EED2Ev 0150 __gxx_personality_sj0 0154 .gcc_except_table 0158 .text$_ZNSt17moneypunct_bynameIwLb1EEC2EPKcj 015c _ZTVSt10moneypunctIwLb1EE 0160 _ZTVSt17moneypunct_bynameIwLb1EE 0164 .rdata"
	strings:
		$1 = { 00 48 2D E9 44 31 9F E5 04 B0 8D E2 44 D0 4D E2 24 30 0B E5 38 31 9F E5 40 00 0B E5 20 30 0B E5 04 00 4B E2 2C 31 9F E5 1C 00 0B E5 3C 00 4B E2 18 30 0B E5 48 20 0B E5 44 10 0B E5 14 D0 0B E5 ?? ?? ?? ?? 48 10 1B E5 00 30 A0 E3 40 00 1B E5 03 20 51 E0 01 20 A0 13 04 20 80 E5 F8 20 9F E5 03 10 A0 E1 00 20 80 E5 08 30 80 E5 01 20 A0 E1 01 30 A0 E3 38 30 0B E5 ?? ?? ?? ?? DC 30 9F E5 40 20 1B E5 44 00 1B E5 00 30 82 E5 D0 10 9F E5 ?? ?? ?? ?? 00 00 50 E3 05 00 00 0A C0 30 9F E5 44 00 1B E5 04 10 83 E2 ?? ?? ?? ?? 00 00 50 E3 03 00 00 1A 3C 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 02 30 A0 E3 44 10 1B E5 08 00 4B E2 00 20 A0 E3 38 30 0B E5 ?? ?? ?? ?? 40 00 1B E5 08 10 1B E5 00 20 A0 E3 ?? ?? ?? ?? 08 00 4B E2 ?? ?? ?? ?? EE FF FF EA 04 B0 8B E2 38 30 1B E5 34 10 1B E5 01 00 53 E3 44 10 0B E5 07 00 00 0A 00 30 A0 E3 40 00 1B E5 38 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 44 00 1B E5 38 30 0B E5 ?? ?? ?? ?? 00 30 A0 E3 40 00 1B E5 38 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 44 00 1B E5 38 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_268_3 {
	meta:
		name = "_ZNSt14collate_bynameIwEC1EPKcj"
		size = 348
		refs = "0040 _Unwind_SjLj_Register 0068 _ZNSt6locale5facet15_S_get_c_localeEv 0088 strcmp 00b0 _Unwind_SjLj_Unregister 00d4 _ZNSt6locale5facet19_S_destroy_c_localeERPi 00e4 _ZNSt6locale5facet18_S_create_c_localeERPiPKcS1_ 0110 _ZNSt6locale5facetD2Ev 0120 _Unwind_SjLj_Resume 0130 _ZNSt7collateIwED2Ev 0144 __gxx_personality_sj0 0148 .gcc_except_table 014c .text$_ZNSt14collate_bynameIwEC1EPKcj 0150 _ZTVSt7collateIwE 0154 _ZTVSt14collate_bynameIwE 0158 .rdata"
	strings:
		$1 = { 00 48 2D E9 38 31 9F E5 04 B0 8D E2 40 D0 4D E2 20 30 0B E5 2C 31 9F E5 3C 00 0B E5 1C 30 0B E5 24 31 9F E5 38 00 4B E2 14 30 0B E5 04 30 4B E2 18 30 0B E5 44 20 0B E5 10 D0 0B E5 40 10 0B E5 ?? ?? ?? ?? 44 20 1B E5 00 30 52 E2 01 30 A0 13 3C 20 1B E5 04 30 82 E5 F0 30 9F E5 00 30 82 E5 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 3C 30 1B E5 3C 20 1B E5 08 00 83 E5 D4 30 9F E5 40 00 1B E5 00 30 82 E5 CC 10 9F E5 ?? ?? ?? ?? 00 00 50 E3 05 00 00 0A BC 20 9F E5 40 00 1B E5 04 10 82 E2 ?? ?? ?? ?? 00 00 50 E3 03 00 00 1A 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 3C 30 1B E5 08 30 83 E2 44 30 0B E5 44 00 1B E5 02 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 44 00 1B E5 40 10 1B E5 00 20 A0 E3 ?? ?? ?? ?? EF FF FF EA 04 B0 8B E2 30 30 1B E5 40 30 0B E5 34 30 1B E5 01 00 53 E3 07 00 00 0A 00 30 A0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 40 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 00 30 A0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 40 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_267_3 {
	meta:
		name = "_ZNSt14collate_bynameIcEC1EPKcj"
		size = 348
		refs = "0040 _Unwind_SjLj_Register 0068 _ZNSt6locale5facet15_S_get_c_localeEv 0088 strcmp 00b0 _Unwind_SjLj_Unregister 00d4 _ZNSt6locale5facet19_S_destroy_c_localeERPi 00e4 _ZNSt6locale5facet18_S_create_c_localeERPiPKcS1_ 0110 _ZNSt6locale5facetD2Ev 0120 _Unwind_SjLj_Resume 0130 _ZNSt7collateIcED2Ev 0144 __gxx_personality_sj0 0148 .gcc_except_table 014c .text$_ZNSt14collate_bynameIcEC1EPKcj 0150 _ZTVSt7collateIcE 0154 _ZTVSt14collate_bynameIcE 0158 .rdata"
	strings:
		$1 = { 00 48 2D E9 38 31 9F E5 04 B0 8D E2 40 D0 4D E2 20 30 0B E5 2C 31 9F E5 3C 00 0B E5 1C 30 0B E5 24 31 9F E5 38 00 4B E2 14 30 0B E5 04 30 4B E2 18 30 0B E5 44 20 0B E5 10 D0 0B E5 40 10 0B E5 ?? ?? ?? ?? 44 20 1B E5 00 30 52 E2 01 30 A0 13 3C 20 1B E5 04 30 82 E5 F0 30 9F E5 00 30 82 E5 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 3C 30 1B E5 3C 20 1B E5 08 00 83 E5 D4 30 9F E5 40 00 1B E5 00 30 82 E5 CC 10 9F E5 ?? ?? ?? ?? 00 00 50 E3 05 00 00 0A BC 20 9F E5 40 00 1B E5 04 10 82 E2 ?? ?? ?? ?? 00 00 50 E3 03 00 00 1A 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 3C 30 1B E5 08 30 83 E2 44 30 0B E5 44 00 1B E5 02 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 44 00 1B E5 40 10 1B E5 00 20 A0 E3 ?? ?? ?? ?? EF FF FF EA 04 B0 8B E2 30 30 1B E5 40 30 0B E5 34 30 1B E5 01 00 53 E3 07 00 00 0A 00 30 A0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 40 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 00 30 A0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 40 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_268_3 {
	meta:
		name = "_ZNSt14collate_bynameIcEC2EPKcj"
		size = 348
		refs = "0040 _Unwind_SjLj_Register 0068 _ZNSt6locale5facet15_S_get_c_localeEv 0088 strcmp 00b0 _Unwind_SjLj_Unregister 00d4 _ZNSt6locale5facet19_S_destroy_c_localeERPi 00e4 _ZNSt6locale5facet18_S_create_c_localeERPiPKcS1_ 0110 _ZNSt6locale5facetD2Ev 0120 _Unwind_SjLj_Resume 0130 _ZNSt7collateIcED2Ev 0144 __gxx_personality_sj0 0148 .gcc_except_table 014c .text$_ZNSt14collate_bynameIcEC2EPKcj 0150 _ZTVSt7collateIcE 0154 _ZTVSt14collate_bynameIcE 0158 .rdata"
	strings:
		$1 = { 00 48 2D E9 38 31 9F E5 04 B0 8D E2 40 D0 4D E2 20 30 0B E5 2C 31 9F E5 3C 00 0B E5 1C 30 0B E5 24 31 9F E5 38 00 4B E2 14 30 0B E5 04 30 4B E2 18 30 0B E5 44 20 0B E5 10 D0 0B E5 40 10 0B E5 ?? ?? ?? ?? 44 20 1B E5 00 30 52 E2 01 30 A0 13 3C 20 1B E5 04 30 82 E5 F0 30 9F E5 00 30 82 E5 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 3C 30 1B E5 3C 20 1B E5 08 00 83 E5 D4 30 9F E5 40 00 1B E5 00 30 82 E5 CC 10 9F E5 ?? ?? ?? ?? 00 00 50 E3 05 00 00 0A BC 20 9F E5 40 00 1B E5 04 10 82 E2 ?? ?? ?? ?? 00 00 50 E3 03 00 00 1A 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 3C 30 1B E5 08 30 83 E2 44 30 0B E5 44 00 1B E5 02 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 44 00 1B E5 40 10 1B E5 00 20 A0 E3 ?? ?? ?? ?? EF FF FF EA 04 B0 8B E2 30 30 1B E5 40 30 0B E5 34 30 1B E5 01 00 53 E3 07 00 00 0A 00 30 A0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 40 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 00 30 A0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 40 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_269_3 {
	meta:
		name = "_ZNSt14collate_bynameIwEC2EPKcj"
		size = 348
		refs = "0040 _Unwind_SjLj_Register 0068 _ZNSt6locale5facet15_S_get_c_localeEv 0088 strcmp 00b0 _Unwind_SjLj_Unregister 00d4 _ZNSt6locale5facet19_S_destroy_c_localeERPi 00e4 _ZNSt6locale5facet18_S_create_c_localeERPiPKcS1_ 0110 _ZNSt6locale5facetD2Ev 0120 _Unwind_SjLj_Resume 0130 _ZNSt7collateIwED2Ev 0144 __gxx_personality_sj0 0148 .gcc_except_table 014c .text$_ZNSt14collate_bynameIwEC2EPKcj 0150 _ZTVSt7collateIwE 0154 _ZTVSt14collate_bynameIwE 0158 .rdata"
	strings:
		$1 = { 00 48 2D E9 38 31 9F E5 04 B0 8D E2 40 D0 4D E2 20 30 0B E5 2C 31 9F E5 3C 00 0B E5 1C 30 0B E5 24 31 9F E5 38 00 4B E2 14 30 0B E5 04 30 4B E2 18 30 0B E5 44 20 0B E5 10 D0 0B E5 40 10 0B E5 ?? ?? ?? ?? 44 20 1B E5 00 30 52 E2 01 30 A0 13 3C 20 1B E5 04 30 82 E5 F0 30 9F E5 00 30 82 E5 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 3C 30 1B E5 3C 20 1B E5 08 00 83 E5 D4 30 9F E5 40 00 1B E5 00 30 82 E5 CC 10 9F E5 ?? ?? ?? ?? 00 00 50 E3 05 00 00 0A BC 20 9F E5 40 00 1B E5 04 10 82 E2 ?? ?? ?? ?? 00 00 50 E3 03 00 00 1A 38 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 3C 30 1B E5 08 30 83 E2 44 30 0B E5 44 00 1B E5 02 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 44 00 1B E5 40 10 1B E5 00 20 A0 E3 ?? ?? ?? ?? EF FF FF EA 04 B0 8B E2 30 30 1B E5 40 30 0B E5 34 30 1B E5 01 00 53 E3 07 00 00 0A 00 30 A0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 40 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 00 30 A0 E3 3C 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 40 00 1B E5 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_270_3 {
	meta:
		name = "_ZNKSt19istreambuf_iteratorIwSt11char_traitsIwEE5equalERKS2_"
		size = 280
	strings:
		$1 = { 10 40 2D E9 00 30 90 E5 04 D0 4D E2 00 00 53 E3 00 40 A0 E1 26 00 00 0A B4 00 D0 E1 F0 20 9F E5 02 00 50 E1 17 00 00 0A 00 30 91 E5 00 40 A0 E3 00 00 53 E3 22 00 00 0A B4 00 D1 E1 D0 20 9F E5 02 00 50 E1 05 00 00 0A 00 00 A0 E3 04 00 50 E1 00 00 A0 13 01 00 A0 03 04 D0 8D E2 10 80 BD E8 08 20 93 E5 0C 00 93 E5 00 00 52 E1 B0 00 D2 31 19 00 00 2A 98 30 9F E5 03 00 50 E1 12 00 00 0A B4 00 C1 E1 EF FF FF EA 08 20 93 E5 0C 00 93 E5 00 00 52 E1 B0 00 D2 31 16 00 00 2A 70 30 9F E5 03 00 50 E1 B4 00 C4 11 DE FF FF 1A 00 30 A0 E3 00 30 84 E5 00 30 91 E5 01 40 A0 E3 00 00 53 E3 DC FF FF 1A 01 00 A0 E3 DF FF FF EA 00 30 A0 E3 00 30 81 E5 01 00 A0 E3 DB FF FF EA 03 00 A0 E1 00 10 8D E5 00 30 93 E5 0F E0 A0 E1 24 F0 93 E5 00 10 9D E5 DE FF FF EA 03 00 A0 E1 00 10 8D E5 00 30 93 E5 0F E0 A0 E1 24 F0 93 E5 00 10 9D E5 E1 FF FF EA FF FF 00 00 }
	condition:
		$1
}

rule file_17_271_3 {
	meta:
		name = "_ZNKSt19istreambuf_iteratorIwSt11char_traitsIwEEdeEv"
		size = 108
	strings:
		$1 = { 00 30 90 E5 10 40 2D E9 00 00 53 E3 00 40 A0 E1 50 00 9F 05 10 80 BD 08 B4 00 D4 E1 44 20 9F E5 02 00 50 E1 10 80 BD 18 08 20 93 E5 0C 10 93 E5 01 00 52 E1 B0 00 D2 31 05 00 00 2A 24 30 9F E5 03 00 50 E1 00 30 A0 03 B4 00 C4 11 00 30 84 05 10 80 BD E8 03 00 A0 E1 00 30 93 E5 0F E0 A0 E1 24 F0 93 E5 F4 FF FF EA FF FF 00 00 }
	condition:
		$1
}

rule file_17_272_3 {
	meta:
		name = "_ZNKSt8time_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE6do_putES3_RSt8ios_basewPK2tmcc"
		size = 240
		refs = "0034 _ZSt9use_facetISt5ctypeIwEERKT_RKSt6locale 0040 _ZSt9use_facetISt11__timepunctIwEERKT_RKSt6locale 00a0 _ZNKSt11__timepunctIwE6_M_putEPwjPKwPK2tm 00a8 wcslen"
	strings:
		$1 = { F0 4F 2D E9 20 B0 8D E2 14 D0 4D E2 30 10 4B E2 04 80 9B E5 0C 00 81 E8 6C 80 88 E2 00 40 A0 E1 08 00 A0 E1 D4 71 DB E1 D0 A1 DB E1 2C 90 5B E5 02 60 A0 E1 ?? ?? ?? ?? 00 50 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 42 DF 4D E2 00 30 95 E5 0B 20 8D E2 00 80 A0 E1 25 10 A0 E3 05 00 A0 E1 07 50 C2 E3 0F E0 A0 E1 28 F0 93 E5 00 00 57 E3 00 30 A0 13 0C C0 9B E5 B2 32 4B 11 B8 02 4B E1 05 10 A0 E1 08 00 A0 E1 80 20 A0 E3 28 30 4B E2 B4 72 4B 01 B6 72 4B 11 B6 A2 4B 01 B4 A2 4B 11 00 C0 8D E5 ?? ?? ?? ?? 05 00 A0 E1 ?? ?? ?? ?? 00 00 59 E3 00 70 A0 E1 09 00 A0 11 07 00 00 1A 05 10 A0 E1 00 30 96 E5 06 00 A0 E1 07 20 A0 E1 0F E0 A0 E1 30 F0 93 E5 00 00 57 E0 01 00 A0 13 04 00 C4 E5 00 60 84 E5 04 00 A0 E1 20 D0 4B E2 F0 8F BD E8 }
	condition:
		$1
}

rule file_17_276_3 {
	meta:
		name = "_ZNKSt7collateIwE12do_transformEPKwS2_"
		size = 792
		refs = "0044 _Unwind_SjLj_Register 0074 _ZNSbIwSt11char_traitsIwESaIwEEC1IPKwEET_S6_RKS1_ 00ac _Znaj 00f8 _ZNSbIwSt11char_traitsIwESaIwEE7reserveEj 0158 _ZNKSt7collateIwE12_M_transformEPwPKwj 017c _ZdaPv 01c8 _ZNSbIwSt11char_traitsIwESaIwEE6appendEPKwj 01d0 wcslen 0218 _Unwind_SjLj_Unregister 025c _ZNSbIwSt11char_traitsIwESaIwEED1Ev 026c _Unwind_SjLj_Resume 029c _ZNSbIwSt11char_traitsIwESaIwEE4_Rep10_M_destroyERKS1_ 02ac __cxa_end_catch 02d4 _ZN9__gnu_cxx18__exchange_and_addEPVii 02e0 __cxa_begin_catch 02fc __cxa_rethrow 0300 __gxx_personality_sj0 0304 .gcc_except_table 0308 .text$_ZNKSt7collateIwE12do_transformEPKwS2_ 030c _ZNSbIwSt11char_traitsIwESaIwEE4_Rep20_S_empty_rep_storageE 0314 _CRT_MT"
	strings:
		$1 = { 00 48 2D E9 F4 C2 9F E5 04 B0 8D E2 60 D0 4D E2 2C C0 0B E5 E8 C2 9F E5 64 00 0B E5 28 C0 0B E5 04 00 4B E2 DC C2 9F E5 24 00 0B E5 44 00 4B E2 20 C0 0B E5 50 20 0B E5 54 30 0B E5 5C 10 0B E5 1C D0 0B E5 ?? ?? ?? ?? BC 32 9F E5 64 10 1B E5 64 C0 1B E5 00 30 81 E5 05 30 A0 E3 40 30 0B E5 10 00 4B E2 50 10 1B E5 54 20 1B E5 08 30 4B E2 58 C0 0B E5 ?? ?? ?? ?? 10 00 1B E5 54 10 1B E5 48 00 0B E5 50 20 1B E5 0C 30 10 E5 48 C0 1B E5 01 10 62 E0 83 30 8C E0 04 20 A0 E3 81 00 A0 E1 54 10 0B E5 40 20 0B E5 60 30 0B E5 ?? ?? ?? ?? 4C 00 0B E5 21 00 00 EA 58 00 1B E5 00 20 90 E5 0C 30 42 E2 0C 10 12 E5 04 00 93 E5 01 C0 81 E2 00 00 5C E1 50 C0 0B E5 02 00 00 8A 08 00 93 E5 00 00 50 E3 08 00 00 DA 03 00 A0 E3 40 00 0B E5 50 10 1B E5 58 00 1B E5 ?? ?? ?? ?? 58 10 1B E5 00 20 91 E5 0C 10 12 E5 0C 30 42 E2 50 C0 1B E5 81 10 A0 E1 8C 00 83 E0 00 C0 A0 E3 B1 C0 82 E1 BC C0 C0 E1 48 00 1B E5 50 20 1B E5 02 00 80 E2 00 10 A0 E3 48 00 0B E5 08 10 83 E5 00 20 83 E5 03 00 A0 E3 40 00 0B E5 4C 10 1B E5 5C 00 1B E5 48 20 1B E5 54 30 1B E5 ?? ?? ?? ?? 54 10 1B E5 00 00 51 E1 12 00 00 8A 4C 20 1B E5 01 00 80 E2 00 00 52 E3 54 00 0B E5 02 00 A0 11 ?? ?? ?? ?? 54 C0 1B E5 03 30 A0 E3 00 10 A0 E3 8C 00 A0 E1 40 30 0B E5 4C 10 0B E5 ?? ?? ?? ?? 4C 00 0B E5 4C 10 1B E5 5C 00 1B E5 48 20 1B E5 54 30 1B E5 ?? ?? ?? ?? 03 20 A0 E3 40 20 0B E5 4C 10 1B E5 00 20 A0 E1 58 00 1B E5 ?? ?? ?? ?? 48 00 1B E5 ?? ?? ?? ?? 48 30 1B E5 60 C0 1B E5 80 00 83 E0 0C 00 50 E1 48 00 0B E5 B2 FF FF 1A 4C C0 1B E5 00 00 5C E3 0C 00 A0 11 ?? ?? ?? ?? 10 30 1B E5 08 21 9F E5 0C 00 43 E2 02 00 50 E1 48 00 0B E5 16 00 00 1A 44 00 4B E2 ?? ?? ?? ?? 64 00 1B E5 04 D0 4B E2 00 88 BD E8 04 B0 8B E2 40 30 1B E5 3C 20 1B E5 01 00 53 E3 48 20 0B E5 18 00 00 0A 02 00 53 E3 24 00 00 0A 03 00 53 E3 17 00 00 0A 00 30 A0 E3 64 00 1B E5 40 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 48 00 1B E5 40 30 0B E5 ?? ?? ?? ?? 9C 20 9F E5 00 20 92 E5 00 00 52 E3 10 00 00 1A 04 00 13 E5 01 20 40 E2 04 20 03 E5 00 00 50 E3 DF FF FF CA 48 00 1B E5 0C 10 4B E2 ?? ?? ?? ?? DB FF FF EA 00 30 A0 E3 40 30 0B E5 ?? ?? ?? ?? 00 30 A0 E3 10 00 4B E2 40 30 0B E5 ?? ?? ?? ?? E2 FF FF EA 01 30 A0 E3 08 00 80 E2 00 10 E0 E3 40 30 0B E5 ?? ?? ?? ?? EB FF FF EA 48 00 1B E5 ?? ?? ?? ?? 4C 30 1B E5 00 00 53 E3 03 00 A0 11 ?? ?? ?? ?? 02 30 A0 E3 40 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_277_3 {
	meta:
		name = "_ZNKSt7collateIwE10do_compareEPKwS2_S2_S2_"
		size = 684
		refs = "0044 _Unwind_SjLj_Register 0060 _ZNSbIwSt11char_traitsIwESaIwEEC1IPKwEET_S6_RKS1_ 00b4 wcslen 0138 _ZNKSt7collateIwE10_M_compareEPKwS2_ 017c _Unwind_SjLj_Unregister 01d0 _ZNSbIwSt11char_traitsIwESaIwEE4_Rep10_M_destroyERKS1_ 020c _Unwind_SjLj_Resume 0254 _ZN9__gnu_cxx18__exchange_and_addEPVii 0280 _ZNSbIwSt11char_traitsIwESaIwEED1Ev 0298 __gxx_personality_sj0 029c .text$_ZNKSt7collateIwE10do_compareEPKwS2_S2_S2_ 02a0 .gcc_except_table 02a4 _ZNSbIwSt11char_traitsIwESaIwEE4_Rep20_S_empty_rep_storageE 02a8 _CRT_MT"
	strings:
		$1 = { 00 48 2D E9 04 B0 8D E2 64 D0 4D E2 60 00 0B E5 04 00 4B E2 30 00 0B E5 78 02 9F E5 78 C2 9F E5 38 00 0B E5 74 02 9F E5 58 10 0B E5 34 00 0B E5 50 00 4B E2 54 20 0B E5 5C 30 0B E5 2C C0 0B E5 28 D0 0B E5 ?? ?? ?? ?? 05 30 A0 E3 4C 30 0B E5 58 10 1B E5 54 20 1B E5 18 00 4B E2 08 30 4B E2 ?? ?? ?? ?? 04 30 A0 E3 4C 30 0B E5 5C 10 1B E5 04 20 9B E5 1C 00 4B E2 0C 30 4B E2 ?? ?? ?? ?? 1C 20 1B E5 18 10 1B E5 58 20 0B E5 58 00 1B E5 0C 20 11 E5 0C 30 10 E5 82 20 81 E0 83 30 80 E0 54 10 0B E5 68 20 0B E5 64 30 0B E5 1C 00 00 EA 54 00 1B E5 ?? ?? ?? ?? 54 20 1B E5 80 00 82 E0 54 00 0B E5 58 00 1B E5 ?? ?? ?? ?? 58 30 1B E5 54 10 1B E5 68 20 1B E5 80 00 83 E0 02 00 51 E1 00 30 A0 13 01 30 A0 03 64 10 1B E5 01 00 50 E1 00 20 A0 13 01 20 A0 03 03 00 12 E1 11 00 00 1A 00 00 53 E3 20 00 00 1A 00 00 52 E3 21 00 00 1A 54 30 1B E5 02 00 80 E2 02 30 83 E2 54 30 0B E5 58 00 0B E5 03 10 A0 E3 4C 10 0B E5 60 00 1B E5 54 10 1B E5 58 20 1B E5 ?? ?? ?? ?? 00 00 50 E3 5C 00 0B E5 D9 FF FF 0A 1C 30 1B E5 50 21 9F E5 0C 10 43 E2 02 00 51 E1 58 10 0B E5 10 00 00 1A 18 30 1B E5 38 11 9F E5 0C 00 43 E2 00 00 51 E1 58 00 0B E5 25 00 00 1A 50 00 4B E2 ?? ?? ?? ?? 5C 00 1B E5 04 D0 4B E2 00 88 BD E8 00 00 E0 E3 5C 00 0B E5 EB FF FF EA 01 20 A0 E3 5C 20 0B E5 E8 FF FF EA FC 20 9F E5 00 20 92 E5 00 00 52 E3 23 00 00 1A 04 00 13 E5 01 20 40 E2 04 20 03 E5 00 00 50 E3 E5 FF FF CA 58 00 1B E5 10 10 4B E2 ?? ?? ?? ?? E1 FF FF EA 04 B0 8B E2 4C 30 1B E5 48 00 1B E5 01 00 53 E3 58 00 0B E5 24 00 00 0A 02 00 53 E3 1E 00 00 0A 03 00 53 E3 20 00 00 0A 00 30 E0 E3 58 00 1B E5 4C 30 0B E5 ?? ?? ?? ?? 90 20 9F E5 00 20 92 E5 00 00 52 E3 0E 00 00 1A 04 00 13 E5 01 20 40 E2 04 20 03 E5 00 00 50 E3 D0 FF FF CA 58 00 1B E5 14 10 4B E2 ?? ?? ?? ?? CC FF FF EA 02 30 A0 E3 08 00 81 E2 00 10 E0 E3 4C 30 0B E5 ?? ?? ?? ?? D8 FF FF EA 01 30 A0 E3 08 00 80 E2 00 10 E0 E3 4C 30 0B E5 ?? ?? ?? ?? ED FF FF EA 00 30 A0 E3 1C 00 4B E2 4C 30 0B E5 ?? ?? ?? ?? 00 30 A0 E3 18 00 4B E2 4C 30 0B E5 ?? ?? ?? ?? D9 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_278_3 {
	meta:
		name = "_ZNSt16__numpunct_cacheIwE8_M_cacheERKSt6locale"
		size = 1532
		refs = "003c _Unwind_SjLj_Register 0058 _ZSt9use_facetISt8numpunctIwEERKT_RKSt6locale 00a0 _Znaj 00d8 _ZNKSs4copyEPcjj 01bc _ZNKSbIwSt11char_traitsIwESaIwEE4copyEPwjj 02dc _ZSt9use_facetISt5ctypeIwEERKT_RKSt6locale 032c _Unwind_SjLj_Unregister 0364 _ZNSs4_Rep10_M_destroyERKSaIcE 03dc _ZNSbIwSt11char_traitsIwESaIwEE4_Rep10_M_destroyERKS1_ 04b0 _ZN9__gnu_cxx18__exchange_and_addEPVii 0594 _ZNSsD1Ev 05a4 _Unwind_SjLj_Resume 05b4 _ZNSbIwSt11char_traitsIwESaIwEED1Ev 05dc __gxx_personality_sj0 05e0 .gcc_except_table 05e4 .text$_ZNSt16__numpunct_cacheIwE8_M_cacheERKSt6locale 05e8 _ZNSs4_Rep20_S_empty_rep_storageE 05ec _ZNSbIwSt11char_traitsIwESaIwEE4_Rep20_S_empty_rep_storageE 05f0 _ZNSt10__num_base12_S_atoms_outE 05f4 _ZNSt10__num_base11_S_atoms_inE 05f8 _CRT_MT"
	strings:
		$1 = { 00 48 2D E9 D0 35 9F E5 04 B0 8D E2 78 D0 4D E2 50 30 0B E5 C4 35 9F E5 04 20 4B E2 4C 30 0B E5 BC 35 9F E5 70 00 0B E5 68 00 4B E2 44 30 0B E5 48 20 0B E5 7C 10 0B E5 40 D0 0B E5 ?? ?? ?? ?? 70 10 1B E5 01 30 A0 E3 A4 30 C1 E5 00 20 E0 E3 7C 00 1B E5 64 20 0B E5 ?? ?? ?? ?? 6C 00 0B E5 00 30 90 E5 6C 10 1B E5 20 00 4B E2 0F E0 A0 E1 10 F0 93 E5 20 30 1B E5 68 25 9F E5 0C 10 43 E2 74 10 0B E5 0C 00 13 E5 02 00 51 E1 70 10 1B E5 0C 00 81 E5 B4 00 00 1A 00 30 E0 E3 64 30 0B E5 ?? ?? ?? ?? 6C 10 1B E5 74 00 0B E5 00 30 91 E5 24 00 4B E2 0F E0 A0 E1 10 F0 93 E5 70 30 1B E5 24 00 4B E2 0C 20 93 E5 09 30 A0 E3 64 30 0B E5 74 10 1B E5 00 30 A0 E3 ?? ?? ?? ?? 24 30 1B E5 00 25 9F E5 0C 10 43 E2 01 00 52 E1 78 10 0B E5 90 00 00 1A 70 10 1B E5 74 20 1B E5 0C 30 91 E5 08 20 81 E5 00 00 53 E3 05 00 00 0A D0 20 D2 E1 00 00 52 E3 02 00 00 DA 7F 20 52 E2 01 20 A0 13 00 00 00 EA 00 20 A0 E3 6C 10 1B E5 28 00 4B E2 00 30 91 E5 70 10 1B E5 14 30 93 E5 10 20 C1 E5 00 20 E0 E3 64 20 0B E5 6C 10 1B E5 0F E0 A0 E1 03 F0 A0 E1 28 30 1B E5 8C 24 9F E5 0C 10 43 E2 74 10 0B E5 0C 00 13 E5 02 00 51 E1 70 10 1B E5 18 00 81 E5 B8 00 00 1A 00 30 E0 E3 80 00 A0 E1 64 30 0B E5 ?? ?? ?? ?? 6C 10 1B E5 74 00 0B E5 00 30 91 E5 2C 00 4B E2 0F E0 A0 E1 14 F0 93 E5 70 30 1B E5 2C 00 4B E2 18 20 93 E5 08 30 A0 E3 64 30 0B E5 74 10 1B E5 00 30 A0 E3 ?? ?? ?? ?? 2C 30 1B E5 20 24 9F E5 0C 10 43 E2 01 00 52 E1 78 10 0B E5 82 00 00 1A 6C 10 1B E5 74 20 1B E5 00 30 91 E5 70 10 1B E5 18 30 93 E5 14 20 81 E5 00 20 E0 E3 64 20 0B E5 30 00 4B E2 6C 10 1B E5 0F E0 A0 E1 03 F0 A0 E1 30 30 1B E5 D8 23 9F E5 0C 10 43 E2 74 10 0B E5 0C 00 13 E5 02 00 51 E1 70 10 1B E5 20 00 81 E5 7A 00 00 1A 00 30 E0 E3 80 00 A0 E1 64 30 0B E5 ?? ?? ?? ?? 6C 10 1B E5 74 00 0B E5 00 30 91 E5 34 00 4B E2 0F E0 A0 E1 18 F0 93 E5 70 30 1B E5 34 00 4B E2 20 20 93 E5 07 30 A0 E3 64 30 0B E5 74 10 1B E5 00 30 A0 E3 ?? ?? ?? ?? 34 30 1B E5 6C 23 9F E5 0C 10 43 E2 01 00 52 E1 78 10 0B E5 48 00 00 1A 6C 20 1B E5 74 10 1B E5 00 30 92 E5 70 20 1B E5 08 30 93 E5 1C 10 82 E5 00 20 E0 E3 64 20 0B E5 6C 00 1B E5 0F E0 A0 E1 03 F0 A0 E1 70 30 1B E5 B4 02 C3 E1 6C 00 1B E5 00 30 90 E5 0F E0 A0 E1 0C F0 93 E5 70 10 1B E5 B6 02 C1 E1 7C 00 1B E5 ?? ?? ?? ?? 70 20 1B E5 6C 00 0B E5 28 30 82 E2 FC 22 9F E5 00 C0 90 E5 00 10 92 E5 24 20 81 E2 0F E0 A0 E1 2C F0 9C E5 E8 32 9F E5 70 20 1B E5 00 10 93 E5 6C 00 1B E5 70 30 82 E2 00 C0 90 E5 1A 20 81 E2 0F E0 A0 E1 2C F0 9C E5 68 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 B8 22 9F E5 00 20 92 E5 00 00 52 E3 55 00 00 1A 04 00 13 E5 01 20 40 E2 04 20 03 E5 00 00 50 E3 65 FF FF CA 78 00 1B E5 0C 10 4B E2 ?? ?? ?? ?? 61 FF FF EA 84 22 9F E5 00 20 92 E5 00 00 52 E3 55 00 00 1A 04 00 13 E5 01 20 40 E2 04 20 03 E5 00 00 50 E3 70 30 1B C5 0C 00 93 C5 3F FF FF CA 74 00 1B E5 08 10 4B E2 ?? ?? ?? ?? 70 10 1B E5 0C 00 91 E5 39 FF FF EA 40 22 9F E5 00 20 92 E5 00 00 52 E3 51 00 00 1A 04 00 13 E5 01 20 40 E2 04 20 03 E5 00 00 50 E3 AD FF FF CA 78 00 1B E5 1C 10 4B E2 ?? ?? ?? ?? A9 FF FF EA 0C 22 9F E5 00 20 92 E5 00 00 52 E3 3E 00 00 1A 04 00 13 E5 01 20 40 E2 04 20 03 E5 00 00 50 E3 73 FF FF CA 78 00 1B E5 14 10 4B E2 ?? ?? ?? ?? 6F FF FF EA D8 21 9F E5 00 20 92 E5 00 00 52 E3 3D 00 00 1A 04 00 13 E5 01 20 40 E2 04 20 03 E5 00 00 50 E3 70 30 1B C5 20 00 93 C5 79 FF FF CA 74 00 1B E5 18 10 4B E2 ?? ?? ?? ?? 70 10 1B E5 20 00 91 E5 73 FF FF EA 94 21 9F E5 00 20 92 E5 00 00 52 E3 12 00 00 1A 04 00 13 E5 01 20 40 E2 04 20 03 E5 00 00 50 E3 70 30 1B C5 18 00 93 C5 3B FF FF CA 74 00 1B E5 10 10 4B E2 ?? ?? ?? ?? 70 10 1B E5 18 00 91 E5 35 FF FF EA 05 30 A0 E3 08 00 81 E2 00 10 E0 E3 64 30 0B E5 ?? ?? ?? ?? A6 FF FF EA 74 20 1B E5 04 30 A0 E3 00 10 E0 E3 08 00 82 E2 64 30 0B E5 ?? ?? ?? ?? E8 FF FF EA 74 20 1B E5 06 30 A0 E3 00 10 E0 E3 08 00 82 E2 64 30 0B E5 ?? ?? ?? ?? A5 FF FF EA 03 30 A0 E3 08 00 81 E2 00 10 E0 E3 64 30 0B E5 ?? ?? ?? ?? BD FF FF EA 01 30 A0 E3 08 00 81 E2 00 10 E0 E3 64 30 0B E5 ?? ?? ?? ?? AA FF FF EA 74 20 1B E5 02 30 A0 E3 00 10 E0 E3 08 00 82 E2 64 30 0B E5 ?? ?? ?? ?? BD FF FF EA 04 B0 8B E2 64 30 1B E5 60 10 1B E5 01 00 53 E3 70 10 0B E5 10 00 00 0A 02 00 53 E3 0E 00 00 0A 03 00 53 E3 0C 00 00 0A 04 00 53 E3 0A 00 00 0A 05 00 53 E3 08 00 00 0A 06 00 53 E3 0A 00 00 0A 07 00 53 E3 0D 00 00 0A 08 00 53 E3 00 30 A0 03 24 00 4B 02 64 30 0B 05 ?? ?? ?? ?? 00 30 E0 E3 70 00 1B E5 64 30 0B E5 ?? ?? ?? ?? 00 30 A0 E3 34 00 4B E2 64 30 0B E5 ?? ?? ?? ?? F6 FF FF EA 00 30 A0 E3 2C 00 4B E2 64 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 70 00 1B E5 64 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_279_3 {
	meta:
		name = "_ZNKSt11__use_cacheISt16__numpunct_cacheIwEEclERKSt6locale"
		size = 408
		refs = "0038 _Unwind_SjLj_Register 0048 _ZNKSt6locale2id5_M_idEv 0074 _Unwind_SjLj_Unregister 0090 _Znwj 00dc _ZNSt16__numpunct_cacheIwE8_M_cacheERKSt6locale 00f8 _ZNSt6locale5_Impl16_M_install_cacheEPKNS_5facetEj 0134 __cxa_end_catch 0144 _Unwind_SjLj_Resume 014c __cxa_begin_catch 0180 __cxa_rethrow 0184 __gxx_personality_sj0 0188 .gcc_except_table 018c .text$_ZNKSt11__use_cacheISt16__numpunct_cacheIwEEclERKSt6locale 0190 _ZNSt8numpunctIwE2idE 0194 _ZTVSt16__numpunct_cacheIwE"
	strings:
		$1 = { 00 48 2D E9 78 31 9F E5 04 B0 8D E2 48 D0 4D E2 20 30 0B E5 6C 31 9F E5 04 20 4B E2 1C 30 0B E5 64 31 9F E5 38 00 4B E2 44 10 0B E5 14 30 0B E5 18 20 0B E5 10 D0 0B E5 ?? ?? ?? ?? 00 30 E0 E3 48 01 9F E5 34 30 0B E5 ?? ?? ?? ?? 44 C0 1B E5 40 00 0B E5 00 30 9C E5 0C 30 93 E5 00 11 93 E7 48 30 0B E5 00 00 51 E3 3C 10 0B E5 04 00 00 0A 38 00 4B E2 ?? ?? ?? ?? 3C 00 1B E5 04 D0 4B E2 00 88 BD E8 02 30 A0 E3 A8 00 A0 E3 34 30 0B E5 ?? ?? ?? ?? F8 10 9F E5 00 30 A0 E3 00 C0 A0 E1 00 10 80 E5 B6 32 C0 E1 A4 30 CC E5 04 30 80 E5 08 30 80 E5 0C 30 80 E5 10 30 C0 E5 14 30 80 E5 18 30 80 E5 1C 30 80 E5 20 30 80 E5 B4 32 C0 E1 44 10 1B E5 4C 00 0B E5 3C 00 0B E5 ?? ?? ?? ?? 44 10 1B E5 00 30 E0 E3 00 00 91 E5 40 20 1B E5 4C 10 1B E5 34 30 0B E5 ?? ?? ?? ?? 40 20 1B E5 48 30 1B E5 02 21 93 E7 3C 20 0B E5 D7 FF FF EA 04 B0 8B E2 34 30 1B E5 30 C0 1B E5 01 00 53 E3 44 30 0B E5 40 C0 0B E5 06 00 00 0A 00 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 40 00 1B E5 34 30 0B E5 ?? ?? ?? ?? 40 00 1B E5 ?? ?? ?? ?? 3C 10 1B E5 00 00 51 E3 06 00 00 0A 00 30 91 E5 44 20 1B E5 04 30 93 E5 01 00 A0 E1 34 20 0B E5 0F E0 A0 E1 03 F0 A0 E1 01 30 A0 E3 34 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_280_3 {
	meta:
		name = "_ZNKSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE15_M_insert_floatIeEES3_S3_RSt8ios_basewcT_"
		size = 724
		refs = "0054 _ZNKSt11__use_cacheISt16__numpunct_cacheIwEEclERKSt6locale 0070 _ZNSt10__num_base15_S_format_floatERKSt8ios_basePcc 0098 _ZNSt6locale5facet15_S_get_c_localeEv 00e0 _ZSt16__convert_from_vRKPiPciPKcz 00ec _ZSt9use_facetISt5ctypeIwEERKT_RKSt6locale 0134 memchr 01e8 _ZNSt5__padIwSt11char_traitsIwEE6_S_padERSt8ios_basewPwPKwii 02b8 _ZNKSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE14_M_group_floatEPKcjwPKwPwS9_Ri"
		altNames = "_ZNKSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE15_M_insert_floatIdEES3_S3_RSt8ios_basewcT_"
	strings:
		$1 = { F0 4F 2D E9 20 B0 8D E2 44 C0 4B E2 54 D0 4D E2 0C 00 8C E8 10 30 8B E2 0C 00 93 E8 04 40 9B E5 5C 20 0B E5 58 30 0B E5 6C A0 84 E2 B8 30 DB E1 40 20 5B E5 64 10 0B E5 00 90 A0 E1 0A 10 A0 E1 24 00 4B E2 DC 50 DB E1 60 30 0B E5 54 20 0B E5 44 80 1B E5 ?? ?? ?? ?? 3C 70 4B E2 04 60 94 E5 05 20 A0 E1 07 10 A0 E1 50 00 0B E5 04 00 A0 E1 ?? ?? ?? ?? 0C 30 94 E5 00 00 56 E3 06 60 A0 B3 04 00 13 E3 4E 3F 86 12 1E 30 86 02 0A 30 83 E2 03 30 C3 E3 03 D0 4D E0 ?? ?? ?? ?? 5C 30 4B E2 0C 00 93 E8 4C 20 0B E5 48 30 0B E5 20 C0 4B E2 0D 20 A0 E1 17 50 8D E2 0C 00 2C E5 07 50 C5 E3 04 60 82 E4 4C 10 4B E2 07 30 A0 E1 03 00 91 E8 03 00 82 E8 0C 00 A0 E1 05 10 A0 E1 00 20 A0 E3 ?? ?? ?? ?? 28 00 0B E5 0A 00 A0 E1 ?? ?? ?? ?? 28 20 1B E5 00 C0 90 E5 82 30 A0 E1 0A 30 83 E2 03 30 C3 E3 03 D0 4D E0 17 60 8D E2 07 60 C6 E3 06 30 A0 E1 05 10 A0 E1 02 20 85 E0 0F E0 A0 E1 2C F0 9C E5 28 70 1B E5 2E 10 A0 E3 05 00 A0 E1 07 20 A0 E1 ?? ?? ?? ?? 00 C0 50 E2 06 10 A0 E1 07 30 A0 E1 05 00 00 0A 50 00 1B E5 0C C0 65 E0 B4 02 D0 E1 8C C0 A0 E1 BC 00 86 E1 0C C0 86 E0 50 00 1B E5 10 20 D0 E5 00 00 52 E3 0E 00 00 0A 02 00 57 E3 00 20 A0 C3 01 20 A0 D3 00 00 5C E3 01 20 82 13 00 00 52 E3 2D 00 00 1A D1 00 D5 E1 39 00 50 E3 04 00 00 CA D2 20 D5 E1 39 00 52 E3 01 00 00 CA 2F 00 50 E3 23 00 00 CA 08 50 94 E5 03 00 55 E1 03 50 A0 D1 0D 00 00 DA 85 30 A0 E1 0A 30 83 E2 03 30 C3 E3 03 D0 4D E0 17 60 8D E2 07 60 C6 E3 01 30 A0 E1 04 00 A0 E1 60 10 1B E5 06 20 A0 E1 A0 00 8D E8 ?? ?? ?? ?? 06 10 A0 E1 28 50 0B E5 54 20 1B E5 00 30 A0 E3 00 00 52 E3 08 30 84 E5 02 00 A0 11 06 00 00 1A 00 30 98 E5 08 00 A0 E1 05 20 A0 E1 0F E0 A0 E1 30 F0 93 E5 05 00 50 E0 01 00 A0 13 04 00 C9 E5 00 80 89 E5 09 00 A0 E1 20 D0 4B E2 F0 8F BD E8 2F 00 52 E3 D9 FF FF DA D0 E0 D5 E1 07 31 A0 E1 08 30 83 E2 2D 00 5E E3 2B 00 5E 13 03 D0 4D E0 B0 20 D6 01 17 50 8D E2 50 00 1B E5 07 50 C5 E3 B0 20 C5 01 00 E0 A0 13 01 E0 A0 03 02 E0 A0 03 B6 32 D0 E1 08 10 90 E5 0C 20 90 E5 0E A0 A0 11 01 70 47 02 0E 60 86 E0 00 C0 8D E5 0E E0 85 E0 28 C0 4B E2 64 00 1B E5 28 70 0B 05 01 A0 A0 03 04 E0 8D E5 08 60 8D E5 0C C0 8D E5 ?? ?? ?? ?? 28 70 1B E5 05 10 A0 E1 07 30 8A E0 28 30 0B E5 03 70 A0 E1 B5 FF FF EA }
	condition:
		$1
}

rule file_17_281_3 {
	meta:
		name = "_ZNKSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE6do_putES3_RSt8ios_basewe"
		size = 108
		refs = "005c _ZNKSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE15_M_insert_floatIeEES3_S3_RSt8ios_basewcT_"
	strings:
		$1 = { 30 40 2D E9 24 D0 4D E2 1C C0 8D E2 0C 00 8C E8 38 40 8D E2 18 00 94 E8 14 30 8D E5 18 40 8D E5 0C 00 9C E8 00 40 A0 E1 30 00 9D E5 B4 53 DD E1 00 00 8D E5 4C 00 A0 E3 01 E0 A0 E1 04 50 8D E5 08 00 8D E5 0C C0 8D E2 14 10 8D E2 03 00 91 E8 03 00 8C E8 04 00 A0 E1 0E 10 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 24 D0 8D E2 30 80 BD E8 }
	condition:
		$1
}

rule file_17_283_3 {
	meta:
		name = "_ZNKSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE6do_putES3_RSt8ios_basewd"
		size = 108
		refs = "005c _ZNKSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE15_M_insert_floatIdEES3_S3_RSt8ios_basewcT_"
	strings:
		$1 = { 30 40 2D E9 24 D0 4D E2 1C C0 8D E2 0C 00 8C E8 38 40 8D E2 18 00 94 E8 14 30 8D E5 18 40 8D E5 0C 00 9C E8 00 40 A0 E1 30 00 9D E5 B4 53 DD E1 00 00 8D E5 00 00 A0 E3 01 E0 A0 E1 04 50 8D E5 08 00 8D E5 0C C0 8D E2 14 10 8D E2 03 00 91 E8 03 00 8C E8 04 00 A0 E1 0E 10 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 24 D0 8D E2 30 80 BD E8 }
	condition:
		$1
}

rule file_17_284_3 {
	meta:
		name = "_ZNKSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE13_M_insert_intIyEES3_S3_RSt8ios_basewT_"
		size = 528
		refs = "004c _ZNKSt11__use_cacheISt16__numpunct_cacheIwEEclERKSt6locale 0094 _ZSt13__int_to_charIwyEiPT_T0_PKS0_St13_Ios_Fmtflagsb 0104 _ZNSt5__padIwSt11char_traitsIwEE6_S_padERSt8ios_basewPwPKwii 0190 _ZNKSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE12_M_group_intEPKcjwRSt8ios_basePwS9_Ri"
	strings:
		$1 = { F0 4F 2D E9 20 B0 8D E2 30 C0 4B E2 3C D0 4D E2 0C 00 8C E8 0C 20 9B E5 04 50 9B E5 10 30 9B E5 B8 C0 DB E1 40 20 0B E5 2C 20 5B E5 4C 10 0B E5 00 70 A0 E1 6C 10 85 E2 24 00 4B E2 44 30 0B E5 48 C0 0B E5 3C 20 0B E5 30 60 1B E5 ?? ?? ?? ?? 0C A0 95 E5 58 D0 4D E2 17 80 8D E2 4A 90 0A E2 07 80 C8 E3 08 00 59 E3 40 00 59 13 00 C0 A0 03 01 C0 A0 13 28 30 80 E2 00 40 A0 E1 40 10 1B E5 50 00 88 E2 44 20 1B E5 38 30 0B E5 34 C0 0B E5 00 14 8D E8 ?? ?? ?? ?? 10 30 D4 E5 28 C0 60 E2 00 00 53 E3 8C C0 88 E0 28 00 0B E5 0C 80 A0 01 28 00 00 1A 34 20 1B E5 00 00 52 E3 36 00 00 0A 08 40 95 E5 00 00 54 E1 00 40 A0 D1 0E 00 00 DA 84 30 A0 E1 0A 30 83 E2 03 30 C3 E3 03 D0 4D E0 17 A0 8D E2 07 A0 CA E3 28 C0 1B E5 08 30 A0 E1 48 10 1B E5 05 00 A0 E1 0A 20 A0 E1 10 10 8D E8 0A 80 A0 E1 ?? ?? ?? ?? 28 40 0B E5 3C 20 1B E5 00 30 A0 E3 00 00 52 E3 08 30 85 E5 02 00 A0 11 07 00 00 1A 08 10 A0 E1 00 30 96 E5 06 00 A0 E1 04 20 A0 E1 0F E0 A0 E1 30 F0 93 E5 00 00 54 E0 01 00 A0 13 04 00 C7 E5 00 60 87 E5 07 00 A0 E1 20 D0 4B E2 F0 8F BD E8 00 01 A0 E1 0C 00 80 E2 00 D0 4D E0 17 80 8D E2 07 80 C8 E3 08 10 94 E5 0C 20 94 E5 B6 32 D4 E1 4C 00 1B E5 08 C0 8D E5 04 80 88 E2 28 C0 4B E2 0C C0 8D E5 20 01 8D E8 ?? ?? ?? ?? 28 00 1B E5 C5 FF FF EA 02 0C 1A E3 12 00 00 0A 40 30 1B E5 44 C0 1B E5 0C 30 93 E1 0E 00 00 0A 40 00 59 E3 0E 00 00 0A 01 09 1A E3 2C 20 A0 03 2E 20 A0 13 02 30 48 E2 B2 20 94 E1 03 80 A0 E1 38 C0 1B E5 B2 20 48 E0 B8 C0 DC E1 02 00 80 E2 B2 C0 43 E1 28 00 0B E5 B3 FF FF EA 28 00 1B E5 B1 FF FF EA 38 20 1B E5 01 00 80 E2 B8 20 D2 E1 28 00 0B E5 B2 20 68 E1 AB FF FF EA }
	condition:
		$1
}

rule file_17_285_3 {
	meta:
		name = "_ZNKSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE6do_putES3_RSt8ios_basewy"
		size = 96
		refs = "0050 _ZNKSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE13_M_insert_intIyEES3_S3_RSt8ios_basewT_"
	strings:
		$1 = { 30 40 2D E9 20 D0 4D E2 18 C0 8D E2 0C 00 8C E8 34 40 8D E2 18 00 94 E8 B0 53 DD E1 10 30 8D E5 14 40 8D E5 0C 00 9C E8 00 40 A0 E1 2C 00 9D E5 01 E0 A0 E1 21 00 8D E8 08 C0 8D E2 10 10 8D E2 03 00 91 E8 03 00 8C E8 04 00 A0 E1 0E 10 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 20 D0 8D E2 30 80 BD E8 }
	condition:
		$1
}

rule file_17_287_3 {
	meta:
		name = "_ZNKSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE6do_putES3_RSt8ios_basewx"
		size = 96
		refs = "0050 _ZNKSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE13_M_insert_intIxEES3_S3_RSt8ios_basewT_"
	strings:
		$1 = { 30 40 2D E9 20 D0 4D E2 18 C0 8D E2 0C 00 8C E8 34 40 8D E2 18 00 94 E8 B0 53 DD E1 10 30 8D E5 14 40 8D E5 0C 00 9C E8 00 40 A0 E1 2C 00 9D E5 01 E0 A0 E1 21 00 8D E8 08 C0 8D E2 10 10 8D E2 03 00 91 E8 03 00 8C E8 04 00 A0 E1 0E 10 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 20 D0 8D E2 30 80 BD E8 }
	condition:
		$1
}

rule file_17_286_3 {
	meta:
		name = "_ZNKSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE13_M_insert_intIxEES3_S3_RSt8ios_basewT_"
		size = 652
		refs = "004c _ZNKSt11__use_cacheISt16__numpunct_cacheIwEEclERKSt6locale 00a4 _ZSt13__int_to_charIwyEiPT_T0_PKS0_St13_Ios_Fmtflagsb 0128 _ZNSt5__padIwSt11char_traitsIwEE6_S_padERSt8ios_basewPwPKwii 01cc _ZNKSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE12_M_group_intEPKcjwRSt8ios_basePwS9_Ri"
	strings:
		$1 = { F0 4F 2D E9 20 B0 8D E2 30 C0 4B E2 3C D0 4D E2 0C 00 8C E8 0C 30 8B E2 0C 00 93 E8 04 50 9B E5 38 20 0B E5 34 30 0B E5 2C 40 5B E5 B8 30 DB E1 4C 10 0B E5 00 A0 A0 E1 6C 10 85 E2 24 00 4B E2 48 30 0B E5 44 40 0B E5 30 60 1B E5 ?? ?? ?? ?? 0C 80 95 E5 34 30 1B E5 4A 20 08 E2 08 00 52 E3 40 00 52 13 58 D0 4D E2 3C 20 0B E5 00 90 A0 03 01 90 A0 13 17 70 8D E2 28 20 80 E2 00 00 53 E3 00 40 A0 E1 07 70 C7 E3 40 20 0B E5 56 00 00 DA 38 20 4B E2 06 00 92 E8 50 00 87 E2 40 30 1B E5 00 03 8D E8 ?? ?? ?? ?? 10 30 D4 E5 28 C0 60 E2 00 00 53 E3 8C C0 87 E0 28 00 0B E5 0C 70 A0 01 33 00 00 1A 00 00 59 E3 53 00 00 0A 34 20 1B E5 00 00 52 E3 3F 00 00 BA 02 0B 18 E3 26 00 00 1A 28 00 1B E5 08 40 95 E5 04 00 50 E1 00 40 A0 A1 0E 00 00 AA 84 30 A0 E1 0A 30 83 E2 03 30 C3 E3 03 D0 4D E0 17 80 8D E2 07 80 C8 E3 28 C0 1B E5 07 30 A0 E1 48 10 1B E5 05 00 A0 E1 08 20 A0 E1 10 10 8D E8 08 70 A0 E1 ?? ?? ?? ?? 28 40 0B E5 44 20 1B E5 00 30 A0 E3 00 00 52 E3 08 30 85 E5 02 00 A0 11 07 00 00 1A 07 10 A0 E1 00 30 96 E5 06 00 A0 E1 04 20 A0 E1 0F E0 A0 E1 30 F0 93 E5 04 00 50 E0 01 00 A0 13 04 00 CA E5 00 60 8A E5 0A 00 A0 E1 20 D0 4B E2 F0 8F BD E8 40 30 1B E5 01 00 80 E2 B2 30 D3 E1 28 00 0B E5 B2 30 67 E1 D3 FF FF EA 00 01 A0 E1 0C 00 80 E2 00 D0 4D E0 17 70 8D E2 07 70 C7 E3 08 10 94 E5 0C 20 94 E5 B6 32 D4 E1 4C 00 1B E5 08 C0 8D E5 04 70 87 E2 28 C0 4B E2 0C C0 8D E5 A0 00 8D E8 ?? ?? ?? ?? 28 00 1B E5 BA FF FF EA B8 42 D4 E1 01 00 80 E2 B2 40 67 E1 28 00 0B E5 BD FF FF EA 06 00 00 0A 00 00 59 E3 A5 FF FF 0A 38 20 4B E2 06 00 92 E8 00 10 71 E2 00 20 E2 E2 A2 FF FF EA 38 30 1B E5 00 00 53 E3 9D FF FF 1A F4 FF FF EA 02 0C 18 E3 AE FF FF 0A 38 20 1B E5 34 30 1B E5 03 20 92 E1 AA FF FF 0A 3C 20 1B E5 40 00 52 E3 0C 00 00 0A 01 09 18 E3 2C 20 A0 03 2E 20 A0 13 B2 20 94 E1 02 30 47 E2 03 70 A0 E1 40 40 1B E5 B2 20 47 E0 B8 40 D4 E1 02 00 80 E2 B2 40 43 E1 28 00 0B E5 9B FF FF EA 40 30 1B E5 01 00 80 E2 B8 30 D3 E1 28 00 0B E5 B2 30 67 E1 95 FF FF EA }
	condition:
		$1
}

rule file_17_288_3 {
	meta:
		name = "_ZNKSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE13_M_insert_intImEES3_S3_RSt8ios_basewT_"
		size = 516
		refs = "003c _ZNKSt11__use_cacheISt16__numpunct_cacheIwEEclERKSt6locale 008c _ZSt13__int_to_charIwmEiPT_T0_PKS0_St13_Ios_Fmtflagsb 00fc _ZNSt5__padIwSt11char_traitsIwEE6_S_padERSt8ios_basewPwPKwii 0188 _ZNKSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE12_M_group_intEPKcjwRSt8ios_basePwS9_Ri"
	strings:
		$1 = { F0 4F 2D E9 20 B0 8D E2 30 C0 4B E2 34 D0 4D E2 0C 00 8C E8 04 50 9B E5 B8 20 DB E1 2C 30 5B E5 44 10 0B E5 00 70 A0 E1 6C 10 85 E2 24 00 4B E2 40 20 0B E5 3C 30 0B E5 30 60 1B E5 ?? ?? ?? ?? 0C A0 95 E5 30 D0 4D E2 4A 90 0A E2 08 00 59 E3 40 00 59 13 00 20 A0 03 01 20 A0 13 28 C0 80 E2 34 20 0B E5 17 80 8D E2 07 80 C8 E3 38 C0 0B E5 0C 20 A0 E1 34 C0 1B E5 00 40 A0 E1 0A 30 A0 E1 28 00 88 E2 0C 10 9B E5 00 C0 8D E5 ?? ?? ?? ?? 10 30 D4 E5 14 C0 60 E2 00 00 53 E3 8C C0 88 E0 28 00 0B E5 0C 80 A0 01 28 00 00 1A 34 20 1B E5 00 00 52 E3 36 00 00 0A 08 40 95 E5 00 00 54 E1 00 40 A0 D1 0E 00 00 DA 84 30 A0 E1 0A 30 83 E2 03 30 C3 E3 03 D0 4D E0 17 A0 8D E2 07 A0 CA E3 28 C0 1B E5 08 30 A0 E1 40 10 1B E5 05 00 A0 E1 0A 20 A0 E1 10 10 8D E8 0A 80 A0 E1 ?? ?? ?? ?? 28 40 0B E5 3C 30 1B E5 00 00 53 E3 00 30 A0 E3 08 30 85 E5 3C 00 1B 15 07 00 00 1A 08 10 A0 E1 00 30 96 E5 06 00 A0 E1 04 20 A0 E1 0F E0 A0 E1 30 F0 93 E5 00 00 54 E0 01 00 A0 13 04 00 C7 E5 00 60 87 E5 07 00 A0 E1 20 D0 4B E2 F0 8F BD E8 00 01 A0 E1 0C 00 80 E2 00 D0 4D E0 17 80 8D E2 07 80 C8 E3 08 10 94 E5 0C 20 94 E5 B6 32 D4 E1 44 00 1B E5 08 C0 8D E5 04 80 88 E2 28 C0 4B E2 0C C0 8D E5 20 01 8D E8 ?? ?? ?? ?? 28 00 1B E5 C5 FF FF EA 02 0C 1A E3 11 00 00 0A 0C 30 9B E5 00 00 53 E3 0E 00 00 0A 40 00 59 E3 0E 00 00 0A 01 09 1A E3 2C 20 A0 03 2E 20 A0 13 B2 20 94 E1 02 30 48 E2 03 80 A0 E1 B2 20 48 E0 38 20 1B E5 02 00 80 E2 B8 20 D2 E1 28 00 0B E5 B2 20 43 E1 B4 FF FF EA 28 00 1B E5 B2 FF FF EA 38 C0 1B E5 01 00 80 E2 B8 C0 DC E1 28 00 0B E5 B2 C0 68 E1 AC FF FF EA }
	condition:
		$1
}

rule file_17_289_3 {
	meta:
		name = "_ZNKSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE6do_putES3_RSt8ios_basewPKv"
		size = 120
		refs = "004c _ZNKSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE13_M_insert_intImEES3_S3_RSt8ios_basewT_"
	strings:
		$1 = { F0 41 2D E9 1C D0 4D E2 34 50 9D E5 0C 40 8D E2 0C 80 95 E5 0C 00 84 E8 01 39 C8 E3 B8 C3 DD E1 4A 30 C3 E3 82 3F 83 E3 0C 30 85 E5 14 70 8D E2 0C 00 94 E8 04 C0 8D E5 3C C0 9D E5 00 60 A0 E1 07 00 A0 E1 08 C0 8D E5 00 50 8D E5 ?? ?? ?? ?? 03 00 97 E8 0C 00 8D E5 10 10 CD E5 03 00 94 E8 0C 80 85 E5 00 00 86 E5 04 10 C6 E5 06 00 A0 E1 1C D0 8D E2 F0 81 BD E8 }
	condition:
		$1
}

rule file_17_290_3 {
	meta:
		name = "_ZNKSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE6do_putES3_RSt8ios_basewm"
		size = 64
		refs = "0030 _ZNKSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE13_M_insert_intImEES3_S3_RSt8ios_basewT_"
	strings:
		$1 = { 10 40 2D E9 14 D0 4D E2 0C C0 8D E2 0C 00 8C E8 0C 00 9C E8 1C C0 9D E5 B0 E2 DD E1 00 C0 8D E5 24 C0 9D E5 00 40 A0 E1 04 E0 8D E5 08 C0 8D E5 ?? ?? ?? ?? 04 00 A0 E1 14 D0 8D E2 10 80 BD E8 }
	condition:
		$1
}

rule file_17_292_3 {
	meta:
		name = "_ZNKSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE6do_putES3_RSt8ios_basewl"
		size = 64
		refs = "0030 _ZNKSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE13_M_insert_intIlEES3_S3_RSt8ios_basewT_"
	strings:
		$1 = { 10 40 2D E9 14 D0 4D E2 0C C0 8D E2 0C 00 8C E8 0C 00 9C E8 1C C0 9D E5 B0 E2 DD E1 00 C0 8D E5 24 C0 9D E5 00 40 A0 E1 04 E0 8D E5 08 C0 8D E5 ?? ?? ?? ?? 04 00 A0 E1 14 D0 8D E2 10 80 BD E8 }
	condition:
		$1
}

rule file_17_291_3 {
	meta:
		name = "_ZNKSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE13_M_insert_intIlEES3_S3_RSt8ios_basewT_"
		size = 604
		refs = "003c _ZNKSt11__use_cacheISt16__numpunct_cacheIwEEclERKSt6locale 0094 _ZSt13__int_to_charIwmEiPT_T0_PKS0_St13_Ios_Fmtflagsb 0118 _ZNSt5__padIwSt11char_traitsIwEE6_S_padERSt8ios_basewPwPKwii 01d0 _ZNKSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE12_M_group_intEPKcjwRSt8ios_basePwS9_Ri"
	strings:
		$1 = { F0 4F 2D E9 20 B0 8D E2 30 C0 4B E2 34 D0 4D E2 0C 00 8C E8 04 50 9B E5 B8 20 DB E1 2C 30 5B E5 44 10 0B E5 00 A0 A0 E1 6C 10 85 E2 24 00 4B E2 40 20 0B E5 3C 30 0B E5 30 60 1B E5 ?? ?? ?? ?? 0C 80 95 E5 0C 30 9B E5 4A 20 08 E2 08 00 52 E3 40 00 52 13 30 D0 4D E2 34 20 0B E5 00 90 A0 03 01 90 A0 13 17 70 8D E2 28 20 80 E2 00 00 53 E3 00 40 A0 E1 07 70 C7 E3 38 20 0B E5 40 00 00 DA 0C 10 9B E5 28 00 87 E2 38 20 1B E5 08 30 A0 E1 00 90 8D E5 ?? ?? ?? ?? 10 20 D4 E5 14 30 60 E2 00 00 52 E3 83 C0 87 E0 28 00 0B E5 0C 70 A0 01 38 00 00 1A 00 00 59 E3 4C 00 00 0A 0C 20 9B E5 00 00 52 E3 44 00 00 BA 02 0B 18 E3 26 00 00 1A 28 00 1B E5 08 40 95 E5 04 00 50 E1 00 40 A0 A1 0E 00 00 AA 84 30 A0 E1 0A 30 83 E2 03 30 C3 E3 03 D0 4D E0 17 80 8D E2 07 80 C8 E3 28 C0 1B E5 07 30 A0 E1 40 10 1B E5 05 00 A0 E1 08 20 A0 E1 10 10 8D E8 08 70 A0 E1 ?? ?? ?? ?? 28 40 0B E5 3C 30 1B E5 00 00 53 E3 00 30 A0 E3 08 30 85 E5 3C 00 1B 15 07 00 00 1A 07 10 A0 E1 00 30 96 E5 06 00 A0 E1 04 20 A0 E1 0F E0 A0 E1 30 F0 93 E5 04 00 50 E0 01 00 A0 13 04 00 CA E5 00 60 8A E5 0A 00 A0 E1 20 D0 4B E2 F0 8F BD E8 38 30 1B E5 01 00 80 E2 B2 30 D3 E1 28 00 0B E5 B2 30 67 E1 D3 FF FF EA 00 00 59 E3 BC FF FF 0A 0C 30 9B E5 00 10 63 E2 BA FF FF EA 00 01 A0 E1 0C 00 80 E2 00 D0 4D E0 17 70 8D E2 07 70 C7 E3 08 10 94 E5 0C 20 94 E5 B6 32 D4 E1 44 00 1B E5 08 C0 8D E5 04 70 87 E2 28 C0 4B E2 0C C0 8D E5 A0 00 8D E8 ?? ?? ?? ?? 28 00 1B E5 B5 FF FF EA B8 42 D4 E1 01 00 80 E2 B2 40 67 E1 28 00 0B E5 B8 FF FF EA 02 0C 18 E3 B5 FF FF 0A 0C 20 9B E5 00 00 52 E3 B2 FF FF 0A 34 30 1B E5 40 00 53 E3 0C 00 00 0A 01 09 18 E3 2C 20 A0 03 2E 20 A0 13 B2 20 94 E1 02 30 47 E2 03 70 A0 E1 B2 20 47 E0 38 20 1B E5 02 00 80 E2 B8 20 D2 E1 28 00 0B E5 B2 20 43 E1 A3 FF FF EA 38 20 1B E5 01 00 80 E2 B8 20 D2 E1 28 00 0B E5 B2 20 67 E1 9D FF FF EA }
	condition:
		$1
}

rule file_17_293_3 {
	meta:
		name = "_ZNSt18__moneypunct_cacheIwLb1EE8_M_cacheERKSt6locale"
		size = 1968
		refs = "003c _Unwind_SjLj_Register 0058 _ZSt9use_facetISt10moneypunctIwLb1EEERKT_RKSt6locale 00a0 _Znaj 00d8 _ZNKSs4copyEPcjj 020c _ZNKSbIwSt11char_traitsIwESaIwEE4copyEPwjj 03f4 _ZSt9use_facetISt5ctypeIwEERKT_RKSt6locale 041c _Unwind_SjLj_Unregister 0454 _ZNSs4_Rep10_M_destroyERKSaIcE 04cc _ZNSbIwSt11char_traitsIwESaIwEE4_Rep10_M_destroyERKS1_ 0618 _ZN9__gnu_cxx18__exchange_and_addEPVii 0748 _ZNSsD1Ev 0758 _Unwind_SjLj_Resume 0768 _ZNSbIwSt11char_traitsIwESaIwEED1Ev 0794 __gxx_personality_sj0 0798 .gcc_except_table 079c .text$_ZNSt18__moneypunct_cacheIwLb1EE8_M_cacheERKSt6locale 07a0 _ZNSs4_Rep20_S_empty_rep_storageE 07a4 _ZNSbIwSt11char_traitsIwESaIwEE4_Rep20_S_empty_rep_storageE 07a8 _ZNSt10money_base8_S_atomsE 07ac _CRT_MT"
	strings:
		$1 = { 00 48 2D E9 88 37 9F E5 04 B0 8D E2 90 D0 4D E2 68 30 0B E5 7C 37 9F E5 04 20 4B E2 64 30 0B E5 74 37 9F E5 88 00 0B E5 80 00 4B E2 5C 30 0B E5 60 20 0B E5 94 10 0B E5 58 D0 0B E5 ?? ?? ?? ?? 88 10 1B E5 01 30 A0 E3 52 30 C1 E5 00 20 E0 E3 94 00 1B E5 7C 20 0B E5 ?? ?? ?? ?? 84 00 0B E5 00 30 90 E5 84 10 1B E5 28 00 4B E2 0F E0 A0 E1 10 F0 93 E5 28 30 1B E5 20 27 9F E5 0C 10 43 E2 8C 10 0B E5 0C 00 13 E5 02 00 51 E1 88 10 1B E5 0C 00 81 E5 F0 00 00 1A 00 30 E0 E3 7C 30 0B E5 ?? ?? ?? ?? 84 10 1B E5 8C 00 0B E5 00 30 91 E5 2C 00 4B E2 0F E0 A0 E1 10 F0 93 E5 88 30 1B E5 2C 00 4B E2 0C 20 93 E5 0C 30 A0 E3 7C 30 0B E5 8C 10 1B E5 00 30 A0 E3 ?? ?? ?? ?? 2C 30 1B E5 B8 26 9F E5 0C 10 43 E2 01 00 52 E1 90 10 0B E5 CC 00 00 1A 88 10 1B E5 8C 20 1B E5 0C 30 91 E5 08 20 81 E5 00 00 53 E3 05 00 00 0A D0 20 D2 E1 00 00 52 E3 02 00 00 DA 7F 20 52 E2 01 20 A0 13 00 00 00 EA 00 20 A0 E3 84 10 1B E5 84 00 1B E5 00 30 91 E5 88 10 1B E5 08 30 93 E5 10 20 C1 E5 00 20 E0 E3 7C 20 0B E5 0F E0 A0 E1 03 F0 A0 E1 84 10 1B E5 88 30 1B E5 B2 01 C3 E1 00 30 91 E5 01 00 A0 E1 0F E0 A0 E1 0C F0 93 E5 84 10 1B E5 88 20 1B E5 00 30 91 E5 B4 01 C2 E1 01 00 A0 E1 0F E0 A0 E1 20 F0 93 E5 88 20 1B E5 84 10 1B E5 30 00 82 E5 00 30 91 E5 30 00 4B E2 0F E0 A0 E1 14 F0 93 E5 30 30 1B E5 F4 15 9F E5 0C 20 43 E2 8C 20 0B E5 0C 00 13 E5 01 00 52 E1 88 20 1B E5 1C 00 82 E5 FE 00 00 1A 00 30 E0 E3 80 00 A0 E1 7C 30 0B E5 ?? ?? ?? ?? 84 10 1B E5 8C 00 0B E5 00 30 91 E5 34 00 4B E2 0F E0 A0 E1 14 F0 93 E5 88 30 1B E5 34 00 4B E2 1C 20 93 E5 0B 30 A0 E3 7C 30 0B E5 8C 10 1B E5 00 30 A0 E3 ?? ?? ?? ?? 34 30 1B E5 88 25 9F E5 0C 10 43 E2 01 00 52 E1 90 10 0B E5 B7 00 00 1A 84 10 1B E5 8C 20 1B E5 00 30 91 E5 88 10 1B E5 18 30 93 E5 18 20 81 E5 00 20 E0 E3 7C 20 0B E5 38 00 4B E2 84 10 1B E5 0F E0 A0 E1 03 F0 A0 E1 38 30 1B E5 40 25 9F E5 0C 10 43 E2 8C 10 0B E5 0C 00 13 E5 02 00 51 E1 88 10 1B E5 24 00 81 E5 C0 00 00 1A 00 30 E0 E3 80 00 A0 E1 7C 30 0B E5 ?? ?? ?? ?? 84 10 1B E5 8C 00 0B E5 00 30 91 E5 3C 00 4B E2 0F E0 A0 E1 18 F0 93 E5 88 30 1B E5 3C 00 4B E2 24 20 93 E5 0A 30 A0 E3 7C 30 0B E5 8C 10 1B E5 00 30 A0 E3 ?? ?? ?? ?? 3C 30 1B E5 D4 24 9F E5 0C 10 43 E2 01 00 52 E1 90 10 0B E5 70 00 00 1A 84 10 1B E5 8C 20 1B E5 00 30 91 E5 88 10 1B E5 1C 30 93 E5 20 20 81 E5 00 20 E0 E3 7C 20 0B E5 40 00 4B E2 84 10 1B E5 0F E0 A0 E1 03 F0 A0 E1 40 30 1B E5 8C 24 9F E5 0C 10 43 E2 8C 10 0B E5 0C 00 13 E5 02 00 51 E1 88 10 1B E5 2C 00 81 E5 82 00 00 1A 00 30 E0 E3 80 00 A0 E1 7C 30 0B E5 ?? ?? ?? ?? 84 10 1B E5 8C 00 0B E5 00 30 91 E5 44 00 4B E2 0F E0 A0 E1 1C F0 93 E5 88 30 1B E5 44 00 4B E2 2C 20 93 E5 09 30 A0 E3 7C 30 0B E5 8C 10 1B E5 00 30 A0 E3 ?? ?? ?? ?? 44 30 1B E5 20 24 9F E5 0C 10 43 E2 01 00 52 E1 90 10 0B E5 50 00 00 1A 84 20 1B E5 8C 10 1B E5 00 30 92 E5 88 20 1B E5 24 30 93 E5 28 10 82 E5 00 20 E0 E3 7C 20 0B E5 48 00 4B E2 84 10 1B E5 0F E0 A0 E1 03 F0 A0 E1 48 30 1B E5 88 20 1B E5 84 10 1B E5 34 30 82 E5 84 20 1B E5 4C 00 4B E2 00 30 92 E5 0F E0 A0 E1 28 F0 93 E5 4C 30 1B E5 88 10 1B E5 94 00 1B E5 38 30 81 E5 ?? ?? ?? ?? 88 20 1B E5 00 C0 90 E5 3C 30 82 E2 9C 23 9F E5 00 10 92 E5 0B 20 81 E2 0F E0 A0 E1 2C F0 9C E5 80 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 7C 23 9F E5 00 20 92 E5 00 00 52 E3 73 00 00 1A 04 00 13 E5 01 20 40 E2 04 20 03 E5 00 00 50 E3 29 FF FF CA 90 00 1B E5 0C 10 4B E2 ?? ?? ?? ?? 25 FF FF EA 48 23 9F E5 00 20 92 E5 00 00 52 E3 6C 00 00 1A 04 00 13 E5 01 20 40 E2 04 20 03 E5 00 00 50 E3 88 30 1B C5 0C 00 93 C5 03 FF FF CA 8C 00 1B E5 08 10 4B E2 ?? ?? ?? ?? 88 10 1B E5 0C 00 91 E5 FD FE FF EA 04 23 9F E5 00 20 92 E5 00 00 52 E3 76 00 00 1A 04 00 13 E5 01 20 40 E2 04 20 03 E5 00 00 50 E3 85 FF FF CA 90 00 1B E5 1C 10 4B E2 ?? ?? ?? ?? 81 FF FF EA D0 22 9F E5 00 20 92 E5 00 00 52 E3 5C 00 00 1A 04 00 13 E5 01 20 40 E2 04 20 03 E5 00 00 50 E3 A5 FF FF CA 90 00 1B E5 24 10 4B E2 ?? ?? ?? ?? A1 FF FF EA 9C 22 9F E5 00 20 92 E5 00 00 52 E3 62 00 00 1A 04 00 13 E5 01 20 40 E2 04 20 03 E5 00 00 50 E3 3E FF FF CA 90 00 1B E5 14 10 4B E2 ?? ?? ?? ?? 3A FF FF EA 68 22 9F E5 00 20 92 E5 00 00 52 E3 3B 00 00 1A 04 00 13 E5 01 20 40 E2 04 20 03 E5 00 00 50 E3 88 30 1B C5 2C 00 93 C5 71 FF FF CA 8C 00 1B E5 20 10 4B E2 ?? ?? ?? ?? 88 10 1B E5 2C 00 91 E5 6B FF FF EA 24 22 9F E5 00 20 92 E5 00 00 52 E3 37 00 00 1A 04 00 13 E5 01 20 40 E2 04 20 03 E5 00 00 50 E3 88 30 1B C5 24 00 93 C5 33 FF FF CA 8C 00 1B E5 18 10 4B E2 ?? ?? ?? ?? 88 10 1B E5 24 00 91 E5 2D FF FF EA E0 21 9F E5 00 20 92 E5 00 00 52 E3 39 00 00 1A 04 00 13 E5 01 20 40 E2 04 20 03 E5 00 00 50 E3 88 10 1B C5 1C 00 91 C5 F5 FE FF CA 8C 00 1B E5 10 10 4B E2 ?? ?? ?? ?? 88 20 1B E5 1C 00 92 E5 EF FE FF EA 07 30 A0 E3 08 00 81 E2 00 10 E0 E3 7C 30 0B E5 ?? ?? ?? ?? 88 FF FF EA 8C 20 1B E5 08 30 A0 E3 00 10 E0 E3 03 00 82 E0 7C 30 0B E5 ?? ?? ?? ?? 8E FF FF EA 8C 20 1B E5 02 30 A0 E3 00 10 E0 E3 08 00 82 E2 7C 30 0B E5 ?? ?? ?? ?? BF FF FF EA 01 30 A0 E3 08 00 81 E2 00 10 E0 E3 7C 30 0B E5 ?? ?? ?? ?? 9F FF FF EA 8C 20 1B E5 04 30 A0 E3 00 10 E0 E3 08 00 82 E2 7C 30 0B E5 ?? ?? ?? ?? C3 FF FF EA 03 30 A0 E3 08 00 81 E2 00 10 E0 E3 7C 30 0B E5 ?? ?? ?? ?? 85 FF FF EA 05 30 A0 E3 08 00 81 E2 00 10 E0 E3 7C 30 0B E5 ?? ?? ?? ?? 99 FF FF EA 06 30 A0 E3 7C 30 0B E5 8C 30 1B E5 00 10 E0 E3 08 00 83 E2 ?? ?? ?? ?? C1 FF FF EA 04 B0 8B E2 7C 30 1B E5 78 10 1B E5 01 00 53 E3 84 10 0B E5 16 00 00 0A 02 00 53 E3 14 00 00 0A 03 00 53 E3 12 00 00 0A 04 00 53 E3 10 00 00 0A 05 00 53 E3 0E 00 00 0A 06 00 53 E3 0C 00 00 0A 07 00 53 E3 0A 00 00 0A 08 00 53 E3 11 00 00 0A 09 00 53 E3 14 00 00 0A 0A 00 53 E3 08 00 00 0A 0B 00 53 E3 00 30 A0 03 2C 00 4B 02 7C 30 0B 05 ?? ?? ?? ?? 00 30 E0 E3 84 00 1B E5 7C 30 0B E5 ?? ?? ?? ?? 00 30 A0 E3 7C 30 0B E5 34 00 4B E2 ?? ?? ?? ?? F6 FF FF EA 00 30 A0 E3 44 00 4B E2 7C 30 0B E5 ?? ?? ?? ?? F1 FF FF EA 00 30 A0 E3 7C 30 0B E5 3C 00 4B E2 F4 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_294_3 {
	meta:
		name = "_ZNSt18__moneypunct_cacheIwLb0EE8_M_cacheERKSt6locale"
		size = 1968
		refs = "003c _Unwind_SjLj_Register 0058 _ZSt9use_facetISt10moneypunctIwLb0EEERKT_RKSt6locale 00a0 _Znaj 00d8 _ZNKSs4copyEPcjj 020c _ZNKSbIwSt11char_traitsIwESaIwEE4copyEPwjj 03f4 _ZSt9use_facetISt5ctypeIwEERKT_RKSt6locale 041c _Unwind_SjLj_Unregister 0454 _ZNSs4_Rep10_M_destroyERKSaIcE 04cc _ZNSbIwSt11char_traitsIwESaIwEE4_Rep10_M_destroyERKS1_ 0618 _ZN9__gnu_cxx18__exchange_and_addEPVii 0748 _ZNSsD1Ev 0758 _Unwind_SjLj_Resume 0768 _ZNSbIwSt11char_traitsIwESaIwEED1Ev 0794 __gxx_personality_sj0 0798 .gcc_except_table 079c .text$_ZNSt18__moneypunct_cacheIwLb0EE8_M_cacheERKSt6locale 07a0 _ZNSs4_Rep20_S_empty_rep_storageE 07a4 _ZNSbIwSt11char_traitsIwESaIwEE4_Rep20_S_empty_rep_storageE 07a8 _ZNSt10money_base8_S_atomsE 07ac _CRT_MT"
	strings:
		$1 = { 00 48 2D E9 88 37 9F E5 04 B0 8D E2 90 D0 4D E2 68 30 0B E5 7C 37 9F E5 04 20 4B E2 64 30 0B E5 74 37 9F E5 88 00 0B E5 80 00 4B E2 5C 30 0B E5 60 20 0B E5 94 10 0B E5 58 D0 0B E5 ?? ?? ?? ?? 88 10 1B E5 01 30 A0 E3 52 30 C1 E5 00 20 E0 E3 94 00 1B E5 7C 20 0B E5 ?? ?? ?? ?? 84 00 0B E5 00 30 90 E5 84 10 1B E5 28 00 4B E2 0F E0 A0 E1 10 F0 93 E5 28 30 1B E5 20 27 9F E5 0C 10 43 E2 8C 10 0B E5 0C 00 13 E5 02 00 51 E1 88 10 1B E5 0C 00 81 E5 F0 00 00 1A 00 30 E0 E3 7C 30 0B E5 ?? ?? ?? ?? 84 10 1B E5 8C 00 0B E5 00 30 91 E5 2C 00 4B E2 0F E0 A0 E1 10 F0 93 E5 88 30 1B E5 2C 00 4B E2 0C 20 93 E5 0C 30 A0 E3 7C 30 0B E5 8C 10 1B E5 00 30 A0 E3 ?? ?? ?? ?? 2C 30 1B E5 B8 26 9F E5 0C 10 43 E2 01 00 52 E1 90 10 0B E5 CC 00 00 1A 88 10 1B E5 8C 20 1B E5 0C 30 91 E5 08 20 81 E5 00 00 53 E3 05 00 00 0A D0 20 D2 E1 00 00 52 E3 02 00 00 DA 7F 20 52 E2 01 20 A0 13 00 00 00 EA 00 20 A0 E3 84 10 1B E5 84 00 1B E5 00 30 91 E5 88 10 1B E5 08 30 93 E5 10 20 C1 E5 00 20 E0 E3 7C 20 0B E5 0F E0 A0 E1 03 F0 A0 E1 84 10 1B E5 88 30 1B E5 B2 01 C3 E1 00 30 91 E5 01 00 A0 E1 0F E0 A0 E1 0C F0 93 E5 84 10 1B E5 88 20 1B E5 00 30 91 E5 B4 01 C2 E1 01 00 A0 E1 0F E0 A0 E1 20 F0 93 E5 88 20 1B E5 84 10 1B E5 30 00 82 E5 00 30 91 E5 30 00 4B E2 0F E0 A0 E1 14 F0 93 E5 30 30 1B E5 F4 15 9F E5 0C 20 43 E2 8C 20 0B E5 0C 00 13 E5 01 00 52 E1 88 20 1B E5 1C 00 82 E5 FE 00 00 1A 00 30 E0 E3 80 00 A0 E1 7C 30 0B E5 ?? ?? ?? ?? 84 10 1B E5 8C 00 0B E5 00 30 91 E5 34 00 4B E2 0F E0 A0 E1 14 F0 93 E5 88 30 1B E5 34 00 4B E2 1C 20 93 E5 0B 30 A0 E3 7C 30 0B E5 8C 10 1B E5 00 30 A0 E3 ?? ?? ?? ?? 34 30 1B E5 88 25 9F E5 0C 10 43 E2 01 00 52 E1 90 10 0B E5 B7 00 00 1A 84 10 1B E5 8C 20 1B E5 00 30 91 E5 88 10 1B E5 18 30 93 E5 18 20 81 E5 00 20 E0 E3 7C 20 0B E5 38 00 4B E2 84 10 1B E5 0F E0 A0 E1 03 F0 A0 E1 38 30 1B E5 40 25 9F E5 0C 10 43 E2 8C 10 0B E5 0C 00 13 E5 02 00 51 E1 88 10 1B E5 24 00 81 E5 C0 00 00 1A 00 30 E0 E3 80 00 A0 E1 7C 30 0B E5 ?? ?? ?? ?? 84 10 1B E5 8C 00 0B E5 00 30 91 E5 3C 00 4B E2 0F E0 A0 E1 18 F0 93 E5 88 30 1B E5 3C 00 4B E2 24 20 93 E5 0A 30 A0 E3 7C 30 0B E5 8C 10 1B E5 00 30 A0 E3 ?? ?? ?? ?? 3C 30 1B E5 D4 24 9F E5 0C 10 43 E2 01 00 52 E1 90 10 0B E5 70 00 00 1A 84 10 1B E5 8C 20 1B E5 00 30 91 E5 88 10 1B E5 1C 30 93 E5 20 20 81 E5 00 20 E0 E3 7C 20 0B E5 40 00 4B E2 84 10 1B E5 0F E0 A0 E1 03 F0 A0 E1 40 30 1B E5 8C 24 9F E5 0C 10 43 E2 8C 10 0B E5 0C 00 13 E5 02 00 51 E1 88 10 1B E5 2C 00 81 E5 82 00 00 1A 00 30 E0 E3 80 00 A0 E1 7C 30 0B E5 ?? ?? ?? ?? 84 10 1B E5 8C 00 0B E5 00 30 91 E5 44 00 4B E2 0F E0 A0 E1 1C F0 93 E5 88 30 1B E5 44 00 4B E2 2C 20 93 E5 09 30 A0 E3 7C 30 0B E5 8C 10 1B E5 00 30 A0 E3 ?? ?? ?? ?? 44 30 1B E5 20 24 9F E5 0C 10 43 E2 01 00 52 E1 90 10 0B E5 50 00 00 1A 84 20 1B E5 8C 10 1B E5 00 30 92 E5 88 20 1B E5 24 30 93 E5 28 10 82 E5 00 20 E0 E3 7C 20 0B E5 48 00 4B E2 84 10 1B E5 0F E0 A0 E1 03 F0 A0 E1 48 30 1B E5 88 20 1B E5 84 10 1B E5 34 30 82 E5 84 20 1B E5 4C 00 4B E2 00 30 92 E5 0F E0 A0 E1 28 F0 93 E5 4C 30 1B E5 88 10 1B E5 94 00 1B E5 38 30 81 E5 ?? ?? ?? ?? 88 20 1B E5 00 C0 90 E5 3C 30 82 E2 9C 23 9F E5 00 10 92 E5 0B 20 81 E2 0F E0 A0 E1 2C F0 9C E5 80 00 4B E2 ?? ?? ?? ?? 04 D0 4B E2 00 88 BD E8 7C 23 9F E5 00 20 92 E5 00 00 52 E3 73 00 00 1A 04 00 13 E5 01 20 40 E2 04 20 03 E5 00 00 50 E3 29 FF FF CA 90 00 1B E5 0C 10 4B E2 ?? ?? ?? ?? 25 FF FF EA 48 23 9F E5 00 20 92 E5 00 00 52 E3 6C 00 00 1A 04 00 13 E5 01 20 40 E2 04 20 03 E5 00 00 50 E3 88 30 1B C5 0C 00 93 C5 03 FF FF CA 8C 00 1B E5 08 10 4B E2 ?? ?? ?? ?? 88 10 1B E5 0C 00 91 E5 FD FE FF EA 04 23 9F E5 00 20 92 E5 00 00 52 E3 76 00 00 1A 04 00 13 E5 01 20 40 E2 04 20 03 E5 00 00 50 E3 85 FF FF CA 90 00 1B E5 1C 10 4B E2 ?? ?? ?? ?? 81 FF FF EA D0 22 9F E5 00 20 92 E5 00 00 52 E3 5C 00 00 1A 04 00 13 E5 01 20 40 E2 04 20 03 E5 00 00 50 E3 A5 FF FF CA 90 00 1B E5 24 10 4B E2 ?? ?? ?? ?? A1 FF FF EA 9C 22 9F E5 00 20 92 E5 00 00 52 E3 62 00 00 1A 04 00 13 E5 01 20 40 E2 04 20 03 E5 00 00 50 E3 3E FF FF CA 90 00 1B E5 14 10 4B E2 ?? ?? ?? ?? 3A FF FF EA 68 22 9F E5 00 20 92 E5 00 00 52 E3 3B 00 00 1A 04 00 13 E5 01 20 40 E2 04 20 03 E5 00 00 50 E3 88 30 1B C5 2C 00 93 C5 71 FF FF CA 8C 00 1B E5 20 10 4B E2 ?? ?? ?? ?? 88 10 1B E5 2C 00 91 E5 6B FF FF EA 24 22 9F E5 00 20 92 E5 00 00 52 E3 37 00 00 1A 04 00 13 E5 01 20 40 E2 04 20 03 E5 00 00 50 E3 88 30 1B C5 24 00 93 C5 33 FF FF CA 8C 00 1B E5 18 10 4B E2 ?? ?? ?? ?? 88 10 1B E5 24 00 91 E5 2D FF FF EA E0 21 9F E5 00 20 92 E5 00 00 52 E3 39 00 00 1A 04 00 13 E5 01 20 40 E2 04 20 03 E5 00 00 50 E3 88 10 1B C5 1C 00 91 C5 F5 FE FF CA 8C 00 1B E5 10 10 4B E2 ?? ?? ?? ?? 88 20 1B E5 1C 00 92 E5 EF FE FF EA 07 30 A0 E3 08 00 81 E2 00 10 E0 E3 7C 30 0B E5 ?? ?? ?? ?? 88 FF FF EA 8C 20 1B E5 08 30 A0 E3 00 10 E0 E3 03 00 82 E0 7C 30 0B E5 ?? ?? ?? ?? 8E FF FF EA 8C 20 1B E5 02 30 A0 E3 00 10 E0 E3 08 00 82 E2 7C 30 0B E5 ?? ?? ?? ?? BF FF FF EA 01 30 A0 E3 08 00 81 E2 00 10 E0 E3 7C 30 0B E5 ?? ?? ?? ?? 9F FF FF EA 8C 20 1B E5 04 30 A0 E3 00 10 E0 E3 08 00 82 E2 7C 30 0B E5 ?? ?? ?? ?? C3 FF FF EA 03 30 A0 E3 08 00 81 E2 00 10 E0 E3 7C 30 0B E5 ?? ?? ?? ?? 85 FF FF EA 05 30 A0 E3 08 00 81 E2 00 10 E0 E3 7C 30 0B E5 ?? ?? ?? ?? 99 FF FF EA 06 30 A0 E3 7C 30 0B E5 8C 30 1B E5 00 10 E0 E3 08 00 83 E2 ?? ?? ?? ?? C1 FF FF EA 04 B0 8B E2 7C 30 1B E5 78 10 1B E5 01 00 53 E3 84 10 0B E5 16 00 00 0A 02 00 53 E3 14 00 00 0A 03 00 53 E3 12 00 00 0A 04 00 53 E3 10 00 00 0A 05 00 53 E3 0E 00 00 0A 06 00 53 E3 0C 00 00 0A 07 00 53 E3 0A 00 00 0A 08 00 53 E3 11 00 00 0A 09 00 53 E3 14 00 00 0A 0A 00 53 E3 08 00 00 0A 0B 00 53 E3 00 30 A0 03 2C 00 4B 02 7C 30 0B 05 ?? ?? ?? ?? 00 30 E0 E3 84 00 1B E5 7C 30 0B E5 ?? ?? ?? ?? 00 30 A0 E3 7C 30 0B E5 34 00 4B E2 ?? ?? ?? ?? F6 FF FF EA 00 30 A0 E3 44 00 4B E2 7C 30 0B E5 ?? ?? ?? ?? F1 FF FF EA 00 30 A0 E3 7C 30 0B E5 3C 00 4B E2 F4 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_295_3 {
	meta:
		name = "_ZNKSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE6do_putES3_RSt8ios_basewb"
		size = 540
		refs = "0044 _ZNKSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE13_M_insert_intIlEES3_S3_RSt8ios_basewT_ 0074 _ZNKSt11__use_cacheISt16__numpunct_cacheIwEEclERKSt6locale 0120 wmemset 01e4 _ZSt7__writeIwESt19ostreambuf_iteratorIT_St11char_traitsIS1_EES4_PKS1_i"
	strings:
		$1 = { F0 4F 2D E9 20 B0 8D E2 50 D0 4D E2 04 70 9B E5 5C 40 4B E2 0C 60 97 E5 0C 00 84 E8 01 00 16 E3 00 50 A0 E1 B8 A0 DB E1 0C 80 DB E5 0E 00 00 1A 2C 60 4B E2 0C 00 94 E8 06 00 A0 E1 80 04 8D E8 08 80 8D E5 ?? ?? ?? ?? 03 00 96 E8 5C 00 0B E5 58 10 4B E5 03 00 94 E8 00 00 85 E5 04 10 C5 E5 05 00 A0 E1 20 D0 4B E2 F0 8F BD E8 24 00 4B E2 6C 10 87 E2 ?? ?? ?? ?? 00 00 58 E3 18 80 90 15 20 80 90 05 08 90 97 E5 14 C0 90 15 1C C0 90 05 09 00 58 E1 14 00 00 BA 58 A0 5B E5 00 30 A0 E3 00 00 5A E3 08 30 87 E5 5C 60 1B E5 07 00 00 1A 0C 10 A0 E1 00 30 96 E5 06 00 A0 E1 08 20 A0 E1 0F E0 A0 E1 30 F0 93 E5 00 00 58 E1 01 A0 A0 13 54 60 0B E5 50 A0 4B E5 54 30 4B E2 03 00 93 E8 5C 00 0B E5 58 10 4B E5 D9 FF FF EA 09 90 68 E0 89 30 A0 E1 0A 30 83 E2 03 30 C3 E3 03 D0 4D E0 13 30 8D E2 07 30 C3 E3 03 00 A0 E1 0A 10 A0 E1 09 20 A0 E1 B0 60 06 E2 60 30 0B E5 64 C0 0B E5 ?? ?? ?? ?? 00 30 A0 E3 20 00 56 E3 08 30 87 E5 64 C0 1B E5 25 00 00 0A 58 60 5B E5 5C 70 1B E5 00 00 56 E3 09 00 00 1A 64 C0 0B E5 60 10 1B E5 00 30 97 E5 07 00 A0 E1 09 20 A0 E1 0F E0 A0 E1 30 F0 93 E5 64 C0 1B E5 00 00 59 E1 01 60 A0 13 44 70 0B E5 40 60 4B E5 44 30 4B E2 03 00 93 E8 58 10 4B E5 58 60 5B E5 5C 00 0B E5 00 00 56 E3 00 70 A0 E1 06 00 00 1A 0C 10 A0 E1 00 30 90 E5 08 20 A0 E1 0F E0 A0 E1 30 F0 93 E5 00 00 58 E1 01 60 A0 13 4C 70 0B E5 48 60 4B E5 4C 30 4B E2 03 00 93 E8 5C 00 0B E5 58 10 4B E5 A0 FF FF EA 34 60 4B E2 06 00 94 E8 0C 30 A0 E1 06 00 A0 E1 00 80 8D E5 ?? ?? ?? ?? 03 00 96 E8 3C 60 4B E2 5C 00 0B E5 58 10 4B E5 06 00 94 E8 06 00 A0 E1 60 30 1B E5 00 90 8D E5 ?? ?? ?? ?? 03 00 96 E8 5C 00 0B E5 58 10 4B E5 8D FF FF EA }
	condition:
		$1
}

rule file_17_296_3 {
	meta:
		name = "_ZNKSt9money_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE9_M_insertILb0EEES3_S3_RSt8ios_basewRKSbIwS2_SaIwEE"
		size = 2424
		refs = "0048 _Unwind_SjLj_Register 0064 _ZSt9use_facetISt5ctypeIwEERKT_RKSt6locale 0070 _ZNKSt6locale2id5_M_idEv 0144 _Unwind_SjLj_Unregister 0170 _ZNSbIwSt11char_traitsIwESaIwEE7reserveEj 01d0 _ZNSbIwSt11char_traitsIwESaIwEE14_M_replace_auxEjjjw 01e8 _ZNSbIwSt11char_traitsIwESaIwEE12_M_leak_hardEv 0210 _ZSt14__add_groupingIwEPT_S1_S0_PKcjPKS0_S5_ 0270 _ZNSbIwSt11char_traitsIwESaIwEE9_M_mutateEjjj 0328 _ZNSbIwSt11char_traitsIwESaIwEE6appendEPKwj 03d8 .text$_ZNKSt9money_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE9_M_insertILb0EEES3_S3_RSt8ios_basewRKSbIwS2_SaIwEE 05c8 _ZNSbIwSt11char_traitsIwESaIwEE4_Rep10_M_destroyERKS1_ 05e0 _ZNSbIwSt11char_traitsIwESaIwEE6appendERKS2_ 0608 _ZNSbIwSt11char_traitsIwESaIwEE9push_backEw 0660 _ZNSbIwSt11char_traitsIwESaIwEE6appendEjw 06b0 _ZNSbIwSt11char_traitsIwESaIwEE6assignEPKwj 0730 _Znwj 07a8 _ZNSt18__moneypunct_cacheIwLb0EE8_M_cacheERKSt6locale 07c4 _ZNSt6locale5_Impl16_M_install_cacheEPKNS_5facetEj 084c _ZSt20__throw_out_of_rangePKc 0860 _ZN9__gnu_cxx18__exchange_and_addEPVii 08b0 _Unwind_SjLj_Resume 08d8 _ZNSbIwSt11char_traitsIwESaIwEED1Ev 0904 __cxa_end_catch 091c __cxa_begin_catch 0950 __cxa_rethrow 0958 __gxx_personality_sj0 095c .gcc_except_table 0960 _ZNSt10moneypunctIwLb0EE2idE 0964 _ZNSbIwSt11char_traitsIwESaIwEE4_Rep20_S_empty_rep_storageE 096c _CRT_MT 0970 _ZTVSt18__moneypunct_cacheIwLb0EE 0974 .rdata"
	strings:
		$1 = { 10 48 2D E9 08 B0 8D E2 90 D0 4D E2 2C 10 4B E2 0C 00 81 E8 38 39 9F E5 B8 10 DB E1 3C 30 0B E5 30 39 9F E5 78 00 0B E5 48 30 0B E5 08 00 4B E2 24 39 9F E5 40 00 0B E5 60 00 4B E2 80 10 0B E5 44 30 0B E5 38 D0 0B E5 ?? ?? ?? ?? 04 20 9B E5 00 30 E0 E3 6C 20 82 E2 02 00 A0 E1 5C 30 0B E5 74 20 0B E5 ?? ?? ?? ?? 6C 00 0B E5 EC 08 9F E5 ?? ?? ?? ?? 04 40 9B E5 64 00 0B E5 6C 30 94 E5 0C 30 93 E5 70 30 0B E5 00 31 93 E7 00 00 53 E3 A2 01 00 0A 0C 20 9B E5 68 30 0B E5 00 20 92 E5 BC 33 D3 E1 64 20 0B E5 B0 20 D2 E1 03 00 52 E1 6C 01 00 0A 68 E0 1B E5 64 20 1B E5 34 30 9E E5 14 30 0B E5 20 00 9E E5 24 10 9E E5 0C 30 12 E5 88 00 0B E5 74 10 0B E5 6C 10 1B E5 00 20 91 E5 01 00 A0 E1 14 C0 92 E5 00 20 E0 E3 5C 20 0B E5 64 20 1B E5 08 10 A0 E3 83 30 82 E0 0F E0 A0 E1 0C F0 A0 E1 64 30 1B E5 00 00 63 E0 C0 00 A0 E1 00 00 50 E3 6C 00 0B E5 7C 00 0B E5 0C 00 00 1A 78 E0 1B E5 04 C0 9B E5 2C 30 4B E2 00 20 A0 E3 03 00 93 E8 08 20 8C E5 00 00 8E E5 04 10 CE E5 60 00 4B E2 ?? ?? ?? ?? 78 00 1B E5 08 D0 4B E2 10 88 BD E8 08 48 9F E5 6C C0 1B E5 08 00 4B E2 10 40 20 E5 06 30 A0 E3 8C 10 A0 E1 5C 30 0B E5 ?? ?? ?? ?? 68 E0 1B E5 7C 00 1B E5 30 30 9E E5 00 00 63 E0 00 00 50 E3 70 00 0B E5 3C 00 00 DA 0C 20 9E E5 6C 10 1B E5 00 00 53 E3 00 10 A0 A1 00 00 52 E3 6C 10 0B E5 3B 01 00 0A 18 30 1B E5 6C 40 1B E5 0C 20 13 E5 06 30 A0 E3 00 10 A0 E3 5C 30 0B E5 18 00 4B E2 84 30 A0 E1 00 10 8D E5 ?? ?? ?? ?? 18 00 1B E5 04 30 10 E5 00 00 53 E3 02 00 00 BA 18 00 4B E2 ?? ?? ?? ?? 18 00 1B E5 6C 40 4B E2 10 50 94 E8 B4 11 DC E1 08 20 9C E5 0C 30 9C E5 84 C0 8E E0 04 C0 8D E5 00 E0 8D E5 ?? ?? ?? ?? 18 30 1B E5 70 00 0B E5 0C 20 43 E2 08 10 92 E5 00 00 51 E3 05 00 00 BA 06 30 A0 E3 18 00 4B E2 5C 30 0B E5 ?? ?? ?? ?? 18 30 1B E5 0C 20 43 E2 70 C0 1B E5 00 20 92 E5 0C 30 63 E0 C3 10 A0 E1 02 00 51 E1 78 01 00 8A 06 30 A0 E3 5C 30 0B E5 02 20 61 E0 18 00 4B E2 00 30 A0 E3 ?? ?? ?? ?? 68 00 1B E5 6C E0 1B E5 30 30 90 E5 70 E0 0B E5 00 00 53 E3 27 00 00 DA 68 30 1B E5 18 20 1B E5 B2 31 D3 E1 0C 10 12 E5 84 30 0B E5 0C 30 42 E2 04 00 93 E5 01 40 81 E2 00 00 54 E1 6C 40 0B E5 0A 01 00 9A 06 30 A0 E3 18 00 4B E2 6C 10 1B E5 5C 30 0B E5 ?? ?? ?? ?? 18 20 1B E5 0C 10 12 E5 0C 30 42 E2 6C E0 1B E5 81 00 A0 E1 70 10 1B E5 84 40 1B E5 8E C0 83 E0 00 00 51 E3 00 10 A0 E3 B0 40 82 E1 08 10 83 E5 BC 10 CC E1 00 E0 83 E5 33 01 00 BA 70 00 1B E5 68 C0 1B E5 64 E0 1B E5 30 20 9C E5 06 30 A0 E3 80 10 8E E0 18 00 4B E2 5C 30 0B E5 ?? ?? ?? ?? 04 40 9B E5 18 30 1B E5 0C 40 94 E5 0C 30 13 E5 02 2C 14 E2 68 C0 1B 15 74 E0 1B E5 1C 20 9C 15 03 30 8E E0 0C 16 9F E5 02 20 83 E0 08 00 4B E2 14 10 20 E5 05 30 A0 E3 82 10 A0 E1 64 40 0B E5 70 20 0B E5 5C 30 0B E5 ?? ?? ?? ?? 04 20 9B E5 64 30 1B E5 08 20 92 E5 70 E0 1B E5 B0 30 03 E2 02 00 5E E1 00 C0 A0 23 01 C0 A0 33 10 00 53 E3 00 40 A0 E3 00 C0 A0 13 02 00 6E E0 6C 20 0B E5 7C 30 0B E5 64 40 0B E5 84 C0 0B E5 70 00 0B E5 64 10 1B E5 14 20 4B E2 01 10 82 E0 D0 30 D1 E1 04 00 53 E3 03 F1 9F 97 24 00 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 84 20 1B E5 00 00 52 E3 B3 00 00 1A 1C 20 1B E5 0C 30 42 E2 0C 00 12 E5 04 10 93 E5 01 40 80 E2 01 00 54 E1 8C 40 0B E5 02 00 00 8A 08 10 93 E5 00 00 51 E3 07 00 00 DA 05 C0 A0 E3 1C 00 4B E2 8C 10 1B E5 5C C0 0B E5 ?? ?? ?? ?? 1C 20 1B E5 0C 00 12 E5 0C 30 42 E2 80 10 A0 E1 8C E0 1B E5 80 00 1B E5 8E C0 83 E0 B1 00 82 E1 00 10 A0 E3 00 20 A0 E3 BC 10 CC E1 08 20 83 E5 00 E0 83 E5 64 C0 1B E5 01 C0 8C E2 04 00 5C E3 64 C0 0B E5 CE FF FF 1A 74 E0 1B E5 01 00 5E E3 06 00 00 9A 88 00 1B E5 05 30 A0 E3 02 10 80 E2 01 20 4E E2 1C 00 4B E2 5C 30 0B E5 ?? ?? ?? ?? 1C 10 1B E5 6C 30 1B E5 0C 20 11 E5 02 00 53 E1 68 20 0B E5 10 00 00 9A 7C 40 1B E5 20 00 54 E3 89 00 00 0A 80 00 1B E5 6C 20 1B E5 68 40 1B E5 05 30 A0 E3 00 10 A0 E3 00 00 8D E5 5C 30 0B E5 1C 00 4B E2 02 30 64 E0 01 20 A0 E1 ?? ?? ?? ?? 6C C0 1B E5 1C 10 1B E5 68 C0 0B E5 28 E0 5B E5 2C 00 1B E5 00 00 5E E3 64 E0 0B E5 6C 00 0B E5 0B 00 00 1A 00 30 90 E5 05 20 A0 E3 30 30 93 E5 5C 20 0B E5 68 20 1B E5 0F E0 A0 E1 03 F0 A0 E1 68 20 1B E5 64 10 1B E5 00 00 52 E1 01 10 A0 13 64 10 0B E5 1C 30 1B E5 10 04 9F E5 6C C0 1B E5 64 E0 1B E5 0C 40 43 E2 68 40 0B E5 24 C0 0B E5 20 E0 4B E5 00 00 54 E1 24 20 4B E2 03 00 92 E8 2C 00 0B E5 28 10 4B E5 A1 00 00 1A 18 30 1B E5 D8 23 9F E5 0C 10 43 E2 01 00 52 E1 68 10 0B E5 E0 FE FF 0A C8 23 9F E5 00 20 92 E5 00 00 52 E3 C1 00 00 1A 04 00 13 E5 01 20 40 E2 04 20 03 E5 00 00 50 E3 D7 FE FF CA 68 00 1B E5 10 10 4B E2 ?? ?? ?? ?? D3 FE FF EA 05 10 A0 E3 5C 10 0B E5 1C 00 4B E2 18 10 4B E2 ?? ?? ?? ?? A0 FF FF EA 74 C0 1B E5 00 00 5C E3 9D FF FF 0A 88 E0 1B E5 05 00 A0 E3 B0 10 DE E1 5C 00 0B E5 1C 00 4B E2 ?? ?? ?? ?? 96 FF FF EA 04 20 9B E5 0C 30 92 E5 02 0C 13 E3 92 FF FF 0A 68 30 1B E5 05 40 A0 E3 18 10 93 E5 1C 20 93 E5 1C 00 4B E2 5C 40 0B E5 ?? ?? ?? ?? 8A FF FF EA 84 30 1B E5 00 00 53 E3 87 FF FF 0A 05 40 A0 E3 1C 00 4B E2 70 10 1B E5 80 20 1B E5 5C 40 0B E5 ?? ?? ?? ?? 80 FF FF EA 68 40 1B E5 64 C0 1B E5 38 30 94 E5 14 30 0B E5 0C 30 1C E5 28 E0 94 E5 00 00 53 E3 2C 00 94 E5 02 C0 8C 12 88 E0 0B E5 74 00 0B E5 64 C0 0B 15 8E FE FF EA 06 30 A0 E3 18 00 4B E2 64 10 1B E5 6C 20 1B E5 5C 30 0B E5 ?? ?? ?? ?? 68 10 1B E5 6C 20 1B E5 30 30 91 E5 70 20 0B E5 EE FE FF EA 05 30 A0 E3 1C 00 4B E2 70 10 1B E5 80 20 1B E5 5C 30 0B E5 ?? ?? ?? ?? 61 FF FF EA 08 00 93 E5 00 00 50 E3 F1 FE FF CA F8 FE FF EA 6C C0 1B E5 05 30 A0 E3 0C 10 62 E0 1C 00 4B E2 80 20 1B E5 5C 30 0B E5 ?? ?? ?? ?? 6C E0 1B E5 1C 10 1B E5 68 E0 0B E5 78 FF FF EA 04 20 A0 E3 54 00 A0 E3 5C 20 0B E5 90 30 0B E5 ?? ?? ?? ?? 00 30 A0 E3 00 C0 A0 E1 2C 12 9F E5 68 00 0B E5 34 30 CC E5 35 30 CC E5 36 30 CC E5 37 30 CC E5 38 30 CC E5 39 30 CC E5 3A 30 CC E5 3B 30 CC E5 00 10 80 E5 30 30 80 E5 52 30 CC E5 04 30 80 E5 08 30 80 E5 0C 30 80 E5 10 30 C0 E5 B2 31 C0 E1 B4 31 C0 E1 18 30 80 E5 1C 30 80 E5 20 30 80 E5 24 30 80 E5 28 30 80 E5 2C 30 80 E5 74 10 1B E5 90 00 0B E5 ?? ?? ?? ?? 04 20 9B E5 00 30 E0 E3 6C 00 92 E5 68 10 1B E5 64 20 1B E5 5C 30 0B E5 ?? ?? ?? ?? 64 40 1B E5 70 C0 1B E5 04 31 9C E7 2E FE FF EA 68 10 1B E5 06 30 A0 E3 BE 23 D1 E1 5C 30 0B E5 70 30 1B E5 18 00 4B E2 00 10 63 E2 ?? ?? ?? ?? 64 10 1B E5 7C 20 1B E5 18 00 4B E2 ?? ?? ?? ?? C7 FE FF EA 58 21 9F E5 00 20 92 E5 00 00 52 E3 0C 00 00 1A 04 00 13 E5 01 20 40 E2 04 20 03 E5 00 00 50 E3 54 FF FF CA 68 00 1B E5 0C 10 4B E2 ?? ?? ?? ?? 50 FF FF EA 06 30 A0 E3 28 01 9F E5 5C 30 0B E5 ?? ?? ?? ?? 02 30 A0 E3 08 00 84 E2 00 10 E0 E3 5C 30 0B E5 ?? ?? ?? ?? EF FF FF EA 08 B0 8B E2 5C 30 1B E5 58 40 1B E5 01 00 53 E3 68 30 0B E5 64 40 0B E5 15 00 00 0A 02 00 53 E3 1B 00 00 0A 03 00 53 E3 20 00 00 0A 04 00 53 E3 0B 00 00 0A 05 00 53 E3 0D 00 00 0A 00 30 E0 E3 64 00 1B E5 5C 30 0B E5 ?? ?? ?? ?? 01 30 A0 E3 08 00 81 E2 00 10 E0 E3 5C 30 0B E5 ?? ?? ?? ?? 3A FF FF EA 00 30 A0 E3 1C 00 4B E2 5C 30 0B E5 ?? ?? ?? ?? 00 30 A0 E3 18 00 4B E2 5C 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 64 00 1B E5 5C 30 0B E5 ?? ?? ?? ?? 00 30 A0 E3 5C 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 64 00 1B E5 5C 30 0B E5 ?? ?? ?? ?? 64 00 1B E5 ?? ?? ?? ?? 90 E0 1B E5 00 00 5E E3 06 00 00 0A 00 30 9E E5 68 10 1B E5 04 30 93 E5 0E 00 A0 E1 5C 10 0B E5 0F E0 A0 E1 03 F0 A0 E1 03 30 A0 E3 5C 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_297_3 {
	meta:
		name = "_ZNKSt9money_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE9_M_insertILb1EEES3_S3_RSt8ios_basewRKSbIwS2_SaIwEE"
		size = 2424
		refs = "0048 _Unwind_SjLj_Register 0064 _ZSt9use_facetISt5ctypeIwEERKT_RKSt6locale 0070 _ZNKSt6locale2id5_M_idEv 0144 _Unwind_SjLj_Unregister 0170 _ZNSbIwSt11char_traitsIwESaIwEE7reserveEj 01d0 _ZNSbIwSt11char_traitsIwESaIwEE14_M_replace_auxEjjjw 01e8 _ZNSbIwSt11char_traitsIwESaIwEE12_M_leak_hardEv 0210 _ZSt14__add_groupingIwEPT_S1_S0_PKcjPKS0_S5_ 0270 _ZNSbIwSt11char_traitsIwESaIwEE9_M_mutateEjjj 0328 _ZNSbIwSt11char_traitsIwESaIwEE6appendEPKwj 03d8 .text$_ZNKSt9money_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE9_M_insertILb1EEES3_S3_RSt8ios_basewRKSbIwS2_SaIwEE 05c8 _ZNSbIwSt11char_traitsIwESaIwEE4_Rep10_M_destroyERKS1_ 05e0 _ZNSbIwSt11char_traitsIwESaIwEE6appendERKS2_ 0608 _ZNSbIwSt11char_traitsIwESaIwEE9push_backEw 0660 _ZNSbIwSt11char_traitsIwESaIwEE6appendEjw 06b0 _ZNSbIwSt11char_traitsIwESaIwEE6assignEPKwj 0730 _Znwj 07a8 _ZNSt18__moneypunct_cacheIwLb1EE8_M_cacheERKSt6locale 07c4 _ZNSt6locale5_Impl16_M_install_cacheEPKNS_5facetEj 084c _ZSt20__throw_out_of_rangePKc 0860 _ZN9__gnu_cxx18__exchange_and_addEPVii 08b0 _Unwind_SjLj_Resume 08d8 _ZNSbIwSt11char_traitsIwESaIwEED1Ev 0904 __cxa_end_catch 091c __cxa_begin_catch 0950 __cxa_rethrow 0958 __gxx_personality_sj0 095c .gcc_except_table 0960 _ZNSt10moneypunctIwLb1EE2idE 0964 _ZNSbIwSt11char_traitsIwESaIwEE4_Rep20_S_empty_rep_storageE 096c _CRT_MT 0970 _ZTVSt18__moneypunct_cacheIwLb1EE 0974 .rdata"
	strings:
		$1 = { 10 48 2D E9 08 B0 8D E2 90 D0 4D E2 2C 10 4B E2 0C 00 81 E8 38 39 9F E5 B8 10 DB E1 3C 30 0B E5 30 39 9F E5 78 00 0B E5 48 30 0B E5 08 00 4B E2 24 39 9F E5 40 00 0B E5 60 00 4B E2 80 10 0B E5 44 30 0B E5 38 D0 0B E5 ?? ?? ?? ?? 04 20 9B E5 00 30 E0 E3 6C 20 82 E2 02 00 A0 E1 5C 30 0B E5 74 20 0B E5 ?? ?? ?? ?? 6C 00 0B E5 EC 08 9F E5 ?? ?? ?? ?? 04 40 9B E5 64 00 0B E5 6C 30 94 E5 0C 30 93 E5 70 30 0B E5 00 31 93 E7 00 00 53 E3 A2 01 00 0A 0C 20 9B E5 68 30 0B E5 00 20 92 E5 BC 33 D3 E1 64 20 0B E5 B0 20 D2 E1 03 00 52 E1 6C 01 00 0A 68 E0 1B E5 64 20 1B E5 34 30 9E E5 14 30 0B E5 20 00 9E E5 24 10 9E E5 0C 30 12 E5 88 00 0B E5 74 10 0B E5 6C 10 1B E5 00 20 91 E5 01 00 A0 E1 14 C0 92 E5 00 20 E0 E3 5C 20 0B E5 64 20 1B E5 08 10 A0 E3 83 30 82 E0 0F E0 A0 E1 0C F0 A0 E1 64 30 1B E5 00 00 63 E0 C0 00 A0 E1 00 00 50 E3 6C 00 0B E5 7C 00 0B E5 0C 00 00 1A 78 E0 1B E5 04 C0 9B E5 2C 30 4B E2 00 20 A0 E3 03 00 93 E8 08 20 8C E5 00 00 8E E5 04 10 CE E5 60 00 4B E2 ?? ?? ?? ?? 78 00 1B E5 08 D0 4B E2 10 88 BD E8 08 48 9F E5 6C C0 1B E5 08 00 4B E2 10 40 20 E5 06 30 A0 E3 8C 10 A0 E1 5C 30 0B E5 ?? ?? ?? ?? 68 E0 1B E5 7C 00 1B E5 30 30 9E E5 00 00 63 E0 00 00 50 E3 70 00 0B E5 3C 00 00 DA 0C 20 9E E5 6C 10 1B E5 00 00 53 E3 00 10 A0 A1 00 00 52 E3 6C 10 0B E5 3B 01 00 0A 18 30 1B E5 6C 40 1B E5 0C 20 13 E5 06 30 A0 E3 00 10 A0 E3 5C 30 0B E5 18 00 4B E2 84 30 A0 E1 00 10 8D E5 ?? ?? ?? ?? 18 00 1B E5 04 30 10 E5 00 00 53 E3 02 00 00 BA 18 00 4B E2 ?? ?? ?? ?? 18 00 1B E5 6C 40 4B E2 10 50 94 E8 B4 11 DC E1 08 20 9C E5 0C 30 9C E5 84 C0 8E E0 04 C0 8D E5 00 E0 8D E5 ?? ?? ?? ?? 18 30 1B E5 70 00 0B E5 0C 20 43 E2 08 10 92 E5 00 00 51 E3 05 00 00 BA 06 30 A0 E3 18 00 4B E2 5C 30 0B E5 ?? ?? ?? ?? 18 30 1B E5 0C 20 43 E2 70 C0 1B E5 00 20 92 E5 0C 30 63 E0 C3 10 A0 E1 02 00 51 E1 78 01 00 8A 06 30 A0 E3 5C 30 0B E5 02 20 61 E0 18 00 4B E2 00 30 A0 E3 ?? ?? ?? ?? 68 00 1B E5 6C E0 1B E5 30 30 90 E5 70 E0 0B E5 00 00 53 E3 27 00 00 DA 68 30 1B E5 18 20 1B E5 B2 31 D3 E1 0C 10 12 E5 84 30 0B E5 0C 30 42 E2 04 00 93 E5 01 40 81 E2 00 00 54 E1 6C 40 0B E5 0A 01 00 9A 06 30 A0 E3 18 00 4B E2 6C 10 1B E5 5C 30 0B E5 ?? ?? ?? ?? 18 20 1B E5 0C 10 12 E5 0C 30 42 E2 6C E0 1B E5 81 00 A0 E1 70 10 1B E5 84 40 1B E5 8E C0 83 E0 00 00 51 E3 00 10 A0 E3 B0 40 82 E1 08 10 83 E5 BC 10 CC E1 00 E0 83 E5 33 01 00 BA 70 00 1B E5 68 C0 1B E5 64 E0 1B E5 30 20 9C E5 06 30 A0 E3 80 10 8E E0 18 00 4B E2 5C 30 0B E5 ?? ?? ?? ?? 04 40 9B E5 18 30 1B E5 0C 40 94 E5 0C 30 13 E5 02 2C 14 E2 68 C0 1B 15 74 E0 1B E5 1C 20 9C 15 03 30 8E E0 0C 16 9F E5 02 20 83 E0 08 00 4B E2 14 10 20 E5 05 30 A0 E3 82 10 A0 E1 64 40 0B E5 70 20 0B E5 5C 30 0B E5 ?? ?? ?? ?? 04 20 9B E5 64 30 1B E5 08 20 92 E5 70 E0 1B E5 B0 30 03 E2 02 00 5E E1 00 C0 A0 23 01 C0 A0 33 10 00 53 E3 00 40 A0 E3 00 C0 A0 13 02 00 6E E0 6C 20 0B E5 7C 30 0B E5 64 40 0B E5 84 C0 0B E5 70 00 0B E5 64 10 1B E5 14 20 4B E2 01 10 82 E0 D0 30 D1 E1 04 00 53 E3 03 F1 9F 97 24 00 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 84 20 1B E5 00 00 52 E3 B3 00 00 1A 1C 20 1B E5 0C 30 42 E2 0C 00 12 E5 04 10 93 E5 01 40 80 E2 01 00 54 E1 8C 40 0B E5 02 00 00 8A 08 10 93 E5 00 00 51 E3 07 00 00 DA 05 C0 A0 E3 1C 00 4B E2 8C 10 1B E5 5C C0 0B E5 ?? ?? ?? ?? 1C 20 1B E5 0C 00 12 E5 0C 30 42 E2 80 10 A0 E1 8C E0 1B E5 80 00 1B E5 8E C0 83 E0 B1 00 82 E1 00 10 A0 E3 00 20 A0 E3 BC 10 CC E1 08 20 83 E5 00 E0 83 E5 64 C0 1B E5 01 C0 8C E2 04 00 5C E3 64 C0 0B E5 CE FF FF 1A 74 E0 1B E5 01 00 5E E3 06 00 00 9A 88 00 1B E5 05 30 A0 E3 02 10 80 E2 01 20 4E E2 1C 00 4B E2 5C 30 0B E5 ?? ?? ?? ?? 1C 10 1B E5 6C 30 1B E5 0C 20 11 E5 02 00 53 E1 68 20 0B E5 10 00 00 9A 7C 40 1B E5 20 00 54 E3 89 00 00 0A 80 00 1B E5 6C 20 1B E5 68 40 1B E5 05 30 A0 E3 00 10 A0 E3 00 00 8D E5 5C 30 0B E5 1C 00 4B E2 02 30 64 E0 01 20 A0 E1 ?? ?? ?? ?? 6C C0 1B E5 1C 10 1B E5 68 C0 0B E5 28 E0 5B E5 2C 00 1B E5 00 00 5E E3 64 E0 0B E5 6C 00 0B E5 0B 00 00 1A 00 30 90 E5 05 20 A0 E3 30 30 93 E5 5C 20 0B E5 68 20 1B E5 0F E0 A0 E1 03 F0 A0 E1 68 20 1B E5 64 10 1B E5 00 00 52 E1 01 10 A0 13 64 10 0B E5 1C 30 1B E5 10 04 9F E5 6C C0 1B E5 64 E0 1B E5 0C 40 43 E2 68 40 0B E5 24 C0 0B E5 20 E0 4B E5 00 00 54 E1 24 20 4B E2 03 00 92 E8 2C 00 0B E5 28 10 4B E5 A1 00 00 1A 18 30 1B E5 D8 23 9F E5 0C 10 43 E2 01 00 52 E1 68 10 0B E5 E0 FE FF 0A C8 23 9F E5 00 20 92 E5 00 00 52 E3 C1 00 00 1A 04 00 13 E5 01 20 40 E2 04 20 03 E5 00 00 50 E3 D7 FE FF CA 68 00 1B E5 10 10 4B E2 ?? ?? ?? ?? D3 FE FF EA 05 10 A0 E3 5C 10 0B E5 1C 00 4B E2 18 10 4B E2 ?? ?? ?? ?? A0 FF FF EA 74 C0 1B E5 00 00 5C E3 9D FF FF 0A 88 E0 1B E5 05 00 A0 E3 B0 10 DE E1 5C 00 0B E5 1C 00 4B E2 ?? ?? ?? ?? 96 FF FF EA 04 20 9B E5 0C 30 92 E5 02 0C 13 E3 92 FF FF 0A 68 30 1B E5 05 40 A0 E3 18 10 93 E5 1C 20 93 E5 1C 00 4B E2 5C 40 0B E5 ?? ?? ?? ?? 8A FF FF EA 84 30 1B E5 00 00 53 E3 87 FF FF 0A 05 40 A0 E3 1C 00 4B E2 70 10 1B E5 80 20 1B E5 5C 40 0B E5 ?? ?? ?? ?? 80 FF FF EA 68 40 1B E5 64 C0 1B E5 38 30 94 E5 14 30 0B E5 0C 30 1C E5 28 E0 94 E5 00 00 53 E3 2C 00 94 E5 02 C0 8C 12 88 E0 0B E5 74 00 0B E5 64 C0 0B 15 8E FE FF EA 06 30 A0 E3 18 00 4B E2 64 10 1B E5 6C 20 1B E5 5C 30 0B E5 ?? ?? ?? ?? 68 10 1B E5 6C 20 1B E5 30 30 91 E5 70 20 0B E5 EE FE FF EA 05 30 A0 E3 1C 00 4B E2 70 10 1B E5 80 20 1B E5 5C 30 0B E5 ?? ?? ?? ?? 61 FF FF EA 08 00 93 E5 00 00 50 E3 F1 FE FF CA F8 FE FF EA 6C C0 1B E5 05 30 A0 E3 0C 10 62 E0 1C 00 4B E2 80 20 1B E5 5C 30 0B E5 ?? ?? ?? ?? 6C E0 1B E5 1C 10 1B E5 68 E0 0B E5 78 FF FF EA 04 20 A0 E3 54 00 A0 E3 5C 20 0B E5 90 30 0B E5 ?? ?? ?? ?? 00 30 A0 E3 00 C0 A0 E1 2C 12 9F E5 68 00 0B E5 34 30 CC E5 35 30 CC E5 36 30 CC E5 37 30 CC E5 38 30 CC E5 39 30 CC E5 3A 30 CC E5 3B 30 CC E5 00 10 80 E5 30 30 80 E5 52 30 CC E5 04 30 80 E5 08 30 80 E5 0C 30 80 E5 10 30 C0 E5 B2 31 C0 E1 B4 31 C0 E1 18 30 80 E5 1C 30 80 E5 20 30 80 E5 24 30 80 E5 28 30 80 E5 2C 30 80 E5 74 10 1B E5 90 00 0B E5 ?? ?? ?? ?? 04 20 9B E5 00 30 E0 E3 6C 00 92 E5 68 10 1B E5 64 20 1B E5 5C 30 0B E5 ?? ?? ?? ?? 64 40 1B E5 70 C0 1B E5 04 31 9C E7 2E FE FF EA 68 10 1B E5 06 30 A0 E3 BE 23 D1 E1 5C 30 0B E5 70 30 1B E5 18 00 4B E2 00 10 63 E2 ?? ?? ?? ?? 64 10 1B E5 7C 20 1B E5 18 00 4B E2 ?? ?? ?? ?? C7 FE FF EA 58 21 9F E5 00 20 92 E5 00 00 52 E3 0C 00 00 1A 04 00 13 E5 01 20 40 E2 04 20 03 E5 00 00 50 E3 54 FF FF CA 68 00 1B E5 0C 10 4B E2 ?? ?? ?? ?? 50 FF FF EA 06 30 A0 E3 28 01 9F E5 5C 30 0B E5 ?? ?? ?? ?? 02 30 A0 E3 08 00 84 E2 00 10 E0 E3 5C 30 0B E5 ?? ?? ?? ?? EF FF FF EA 08 B0 8B E2 5C 30 1B E5 58 40 1B E5 01 00 53 E3 68 30 0B E5 64 40 0B E5 15 00 00 0A 02 00 53 E3 1B 00 00 0A 03 00 53 E3 20 00 00 0A 04 00 53 E3 0B 00 00 0A 05 00 53 E3 0D 00 00 0A 00 30 E0 E3 64 00 1B E5 5C 30 0B E5 ?? ?? ?? ?? 01 30 A0 E3 08 00 81 E2 00 10 E0 E3 5C 30 0B E5 ?? ?? ?? ?? 3A FF FF EA 00 30 A0 E3 1C 00 4B E2 5C 30 0B E5 ?? ?? ?? ?? 00 30 A0 E3 18 00 4B E2 5C 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 64 00 1B E5 5C 30 0B E5 ?? ?? ?? ?? 00 30 A0 E3 5C 30 0B E5 ?? ?? ?? ?? 00 30 E0 E3 64 00 1B E5 5C 30 0B E5 ?? ?? ?? ?? 64 00 1B E5 ?? ?? ?? ?? 90 E0 1B E5 00 00 5E E3 06 00 00 0A 00 30 9E E5 68 10 1B E5 04 30 93 E5 0E 00 A0 E1 5C 10 0B E5 0F E0 A0 E1 03 F0 A0 E1 03 30 A0 E3 5C 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_298_3 {
	meta:
		name = "_ZNKSt9money_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE6do_putES3_bRSt8ios_basewRKSbIwS2_SaIwEE"
		size = 92
		refs = "0038 _ZNKSt9money_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE9_M_insertILb0EEES3_S3_RSt8ios_basewRKSbIwS2_SaIwEE 0054 _ZNKSt9money_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE9_M_insertILb1EEES3_S3_RSt8ios_basewRKSbIwS2_SaIwEE"
	strings:
		$1 = { 70 40 2D E9 14 D0 4D E2 24 E0 DD E5 0C C0 8D E2 00 00 5E E3 0C 00 8C E8 00 40 A0 E1 28 60 9D E5 30 E0 9D E5 BC 52 DD E1 06 00 00 1A 0C 00 9C E8 00 60 8D E5 20 40 8D E9 ?? ?? ?? ?? 04 00 A0 E1 14 D0 8D E2 70 80 BD E8 0C 00 9C E8 00 60 8D E5 20 40 8D E9 ?? ?? ?? ?? F7 FF FF EA }
	condition:
		$1
}

rule file_17_299_3 {
	meta:
		name = "_ZNKSt9money_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE6do_putES3_bRSt8ios_basewe"
		size = 660
		refs = "0064 _Unwind_SjLj_Register 0074 _ZNSt6localeC1ERKS_ 0084 _ZSt9use_facetISt5ctypeIwEERKT_RKSt6locale 009c _ZNSt6locale5facet15_S_get_c_localeEv 00e0 _ZSt16__convert_from_vRKPiPciPKcz 0100 _ZNSbIwSt11char_traitsIwESaIwEEC1EjwRKS1_ 0120 _ZNSbIwSt11char_traitsIwESaIwEE12_M_leak_hardEv 0184 _ZNKSt9money_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE9_M_insertILb1EEES3_S3_RSt8ios_basewRKSbIwS2_SaIwEE 01a4 _ZNSt6localeD1Ev 01ac _Unwind_SjLj_Unregister 01ec _ZNKSt9money_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE9_M_insertILb0EEES3_S3_RSt8ios_basewRKSbIwS2_SaIwEE 0220 _ZNSbIwSt11char_traitsIwESaIwEE4_Rep10_M_destroyERKS1_ 0238 _ZN9__gnu_cxx18__exchange_and_addEPVii 0260 _ZNSbIwSt11char_traitsIwESaIwEED1Ev 0278 _Unwind_SjLj_Resume 027c .text$_ZNKSt9money_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE6do_putES3_bRSt8ios_basewe 0280 __gxx_personality_sj0 0284 .gcc_except_table 0288 .rdata 028c _ZNSbIwSt11char_traitsIwESaIwEE4_Rep20_S_empty_rep_storageE 0290 _CRT_MT"
	strings:
		$1 = { 10 48 2D E9 08 B0 8D E2 84 D0 4D E2 24 C0 4B E2 0C 00 8C E8 10 30 8B E2 0C 00 93 E8 6C 20 0B E5 68 30 0B E5 50 32 9F E5 BC C0 DB E1 3C 30 0B E5 08 30 4B E2 40 30 0B E5 40 32 9F E5 04 40 DB E5 48 30 0B E5 38 32 9F E5 70 00 0B E5 60 00 4B E2 44 30 0B E5 80 C0 0B E5 78 10 0B E5 38 D0 0B E5 7C 40 0B E5 ?? ?? ?? ?? 08 E0 9B E5 14 00 4B E2 6C 10 8E E2 ?? ?? ?? ?? 04 30 A0 E3 14 00 4B E2 5C 30 0B E5 ?? ?? ?? ?? 05 DD 4D E2 13 30 8D E2 07 30 C3 E3 64 00 0B E5 74 30 0B E5 ?? ?? ?? ?? 08 20 4B E2 10 00 22 E5 0D 30 A0 E1 00 00 A0 E3 04 00 83 E4 6C 10 4B E2 03 00 91 E8 2C 00 0B E5 28 10 0B E5 2C 10 4B E2 03 00 91 E8 03 00 83 E8 02 00 A0 E1 74 10 1B E5 00 20 A0 E3 A4 31 9F E5 ?? ?? ?? ?? 03 30 A0 E3 6C 00 0B E5 5C 30 0B E5 00 20 A0 E3 1C 00 4B E2 6C 10 1B E5 0C 30 4B E2 ?? ?? ?? ?? 1C 30 1B E5 04 20 13 E5 00 00 52 E3 04 00 00 BA 02 30 A0 E3 1C 00 4B E2 5C 30 0B E5 ?? ?? ?? ?? 1C 30 1B E5 64 10 1B E5 6C 40 1B E5 00 20 91 E5 74 10 1B E5 2C C0 92 E5 02 20 A0 E3 5C 20 0B E5 64 00 1B E5 04 20 81 E0 0F E0 A0 E1 0C F0 A0 E1 7C C0 1B E5 00 00 5C E3 16 00 00 0A 80 00 1B E5 08 E0 9B E5 1C 30 4B E2 09 00 8D E9 00 E0 8D E5 24 30 4B E2 78 10 1B E5 70 00 1B E5 0C 00 93 E8 ?? ?? ?? ?? 1C 30 1B E5 F8 20 9F E5 0C 40 43 E2 02 00 54 E1 64 40 0B E5 14 00 00 1A 14 00 4B E2 ?? ?? ?? ?? 60 00 4B E2 ?? ?? ?? ?? 70 00 1B E5 08 D0 4B E2 10 88 BD E8 80 20 1B E5 08 10 9B E5 04 20 8D E5 1C 30 4B E2 02 20 A0 E3 00 10 8D E5 08 30 8D E5 5C 20 0B E5 24 30 4B E2 78 10 1B E5 70 00 1B E5 0C 00 93 E8 ?? ?? ?? ?? E4 FF FF EA 94 20 9F E5 00 20 92 E5 00 00 52 E3 08 00 00 1A 04 00 13 E5 01 20 40 E2 04 20 03 E5 00 00 50 E3 E1 FF FF CA 64 00 1B E5 10 10 4B E2 ?? ?? ?? ?? DD FF FF EA 01 30 A0 E3 08 00 84 E2 00 10 E0 E3 5C 30 0B E5 ?? ?? ?? ?? F3 FF FF EA 08 B0 8B E2 5C 30 1B E5 58 C0 1B E5 01 00 53 E3 64 C0 0B E5 00 30 A0 03 1C 00 4B 02 5C 30 0B 05 ?? ?? ?? ?? 14 00 4B E2 ?? ?? ?? ?? 00 30 E0 E3 64 00 1B E5 5C 30 0B E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_300_3 {
	meta:
		name = "_ZNKSt8time_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE14_M_extract_numES3_S3_RiiijRSt8ios_baseRSt12_Ios_Iostate"
		size = 632
		refs = "0030 _ZSt9use_facetISt5ctypeIwEERKT_RKSt6locale"
	strings:
		$1 = { F0 4F 2D E9 14 D0 4D E2 0C 10 8D E2 0C 00 81 E8 08 00 8D E5 50 00 9D E5 BC 13 DD E1 6C 00 80 E2 02 40 A0 E1 B0 61 DD E1 04 10 8D E5 38 B0 9D E5 ?? ?? ?? ?? 4C 20 9D E5 00 A0 A0 E1 02 00 52 E3 0A 50 A0 03 03 00 00 0A 4C 30 9D E5 04 00 53 E3 FA 5F A0 03 01 50 A0 13 00 70 A0 E3 0C 82 9F E5 07 90 A0 E1 00 00 54 E3 01 30 A0 03 02 00 00 0A 08 00 56 E1 52 00 00 0A 00 30 A0 E3 00 00 5B E3 01 20 A0 03 03 00 00 0A 04 10 9D E5 08 00 51 E1 10 00 00 0A 00 20 A0 E3 02 00 53 E1 1A 00 00 1A 4C 10 9D E5 01 00 59 E1 54 20 9D 15 40 30 9D 05 00 30 92 15 00 70 83 05 04 30 83 13 00 30 82 15 08 30 9D E5 00 40 83 E5 B4 60 C3 E1 03 00 A0 E1 14 D0 8D E2 F0 8F BD E8 08 20 9B E5 0C 10 9B E5 01 00 52 E1 4D 00 00 2A B0 20 D2 E1 04 20 8D E5 04 20 9D E5 08 00 52 E1 01 20 A0 03 00 B0 A0 03 E3 FF FF 1A 02 00 53 E1 E4 FF FF 0A 4C 30 9D E5 03 00 59 E1 E1 FF FF 2A 00 00 54 E3 4C 11 9F 05 02 00 00 0A 08 00 56 E1 2F 00 00 0A 06 10 A0 E1 00 30 9A E5 0A 00 A0 E1 2A 20 A0 E3 0F E0 A0 E1 30 F0 93 E5 FF 00 00 E2 30 30 40 E2 09 00 53 E3 D2 FF FF 8A 07 71 87 E0 87 70 A0 E1 30 70 47 E2 00 0C A0 E1 40 7C 87 E0 95 07 03 E0 48 10 9D E5 01 00 53 E1 C9 FF FF CA 44 20 9D E5 05 30 83 E0 03 00 52 E1 C5 FF FF AA 00 00 54 E3 06 00 00 0A 08 30 94 E5 0C 20 94 E5 02 00 53 E1 02 30 83 32 08 30 84 35 18 00 00 2A C0 60 9F E5 C0 10 9F E5 01 90 89 E2 91 25 C3 E0 C5 5F A0 E1 43 51 65 E0 A7 FF FF EA 08 30 94 E5 0C 20 94 E5 02 00 53 E1 B0 60 D3 31 1F 00 00 2A 08 00 56 E1 01 30 A0 03 00 40 A0 03 A3 FF FF 1A A3 FF FF EA 08 30 94 E5 0C 20 94 E5 02 00 53 E1 B0 60 D3 31 0F 00 00 2A 08 00 56 E1 00 40 A0 03 C7 FF FF EA 00 30 94 E5 04 00 A0 E1 0F E0 A0 E1 28 F0 93 E5 E1 FF FF EA 00 30 8D E5 00 20 9B E5 0B 00 A0 E1 0F E0 A0 E1 24 F0 92 E5 00 30 9D E5 04 00 8D E5 AB FF FF EA 00 30 94 E5 04 00 A0 E1 0F E0 A0 E1 24 F0 93 E5 00 60 A0 E1 E9 FF FF EA 00 30 94 E5 04 00 A0 E1 0F E0 A0 E1 24 F0 93 E5 00 60 A0 E1 D9 FF FF EA FF FF 00 00 67 66 66 66 }
	condition:
		$1
}

rule file_17_301_3 {
	meta:
		name = "_ZNKSt8time_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE11do_get_yearES3_S3_RSt8ios_baseRSt12_Ios_IostateP2tm"
		size = 764
		refs = "002c _ZSt9use_facetISt5ctypeIwEERKT_RKSt6locale"
	strings:
		$1 = { F0 4F 2D E9 10 D0 4D E2 08 10 8D E2 0C 00 81 E8 04 00 8D E5 3C 00 9D E5 02 40 A0 E1 6C 00 80 E2 BC 50 DD E1 B8 B3 DD E1 34 90 9D E5 ?? ?? ?? ?? 00 A0 A0 E3 BC 62 9F E5 0A 70 A0 E1 00 80 A0 E1 00 00 54 E3 01 30 A0 03 02 00 00 0A 06 00 55 E1 39 00 00 0A 00 30 A0 E3 00 00 59 E3 01 20 A0 03 02 00 00 0A 06 00 5B E1 0A 00 00 0A 00 20 A0 E3 03 00 52 E1 12 00 00 1A 02 00 5A E3 04 00 5A 13 99 00 00 0A 40 20 9D E5 00 30 92 E5 04 30 83 E3 00 30 82 E5 10 00 00 EA 08 20 99 E5 0C 10 99 E5 01 00 52 E1 B0 B0 D2 31 70 00 00 2A 06 00 5B E1 01 20 A0 03 00 90 A0 03 EB FF FF 1A 03 00 52 E1 EC FF FF 0A 04 00 5A E3 25 00 00 1A 76 7E 47 E2 0C 70 47 E2 44 30 9D E5 14 70 83 E5 00 00 54 E3 01 60 A0 03 03 00 00 0A 08 32 9F E5 03 00 55 E1 4C 00 00 0A 00 60 A0 E3 00 00 59 E3 47 00 00 0A F0 31 9F E5 03 00 5B E1 3C 00 00 0A 00 30 A0 E3 06 00 53 E1 40 20 9D 05 00 30 92 05 02 30 83 03 00 30 82 05 04 30 9D E5 00 40 83 E5 B4 50 C3 E1 03 00 A0 E1 10 D0 8D E2 F0 8F BD E8 08 30 94 E5 0C 20 94 E5 02 00 53 E1 B0 50 D3 31 60 00 00 2A 06 00 55 E1 01 30 A0 03 00 40 A0 03 BC FF FF 1A BC FF FF EA 00 00 54 E3 88 11 9F 05 02 00 00 0A 06 00 55 E1 19 00 00 0A 05 10 A0 E1 00 30 98 E5 2A 20 A0 E3 08 00 A0 E1 0F E0 A0 E1 30 F0 93 E5 FF 30 00 E2 30 20 43 E2 09 00 52 E3 B5 FF FF 8A 00 00 54 E3 06 00 00 0A 08 20 94 E5 0C 10 94 E5 01 00 52 E1 02 20 82 32 08 20 84 35 24 00 00 2A 30 51 9F E5 07 71 87 E0 87 70 A0 E1 30 70 47 E2 03 3C A0 E1 43 7C 87 E0 01 A0 8A E2 97 FF FF EA 08 30 94 E5 0C 20 94 E5 02 00 53 E1 B0 50 D3 31 26 00 00 2A 06 00 55 E1 00 40 A0 03 DD FF FF EA 08 30 99 E5 0C 20 99 E5 02 00 53 E1 B0 00 D3 31 2A 00 00 2A DC 30 9F E5 03 00 50 E1 BA FF FF 1A 01 30 A0 E3 B9 FF FF EA 08 30 94 E5 0C 20 94 E5 02 00 53 E1 B0 50 D3 31 1A 00 00 2A B4 30 9F E5 03 00 55 E1 01 60 A0 03 00 40 A0 03 A8 FF FF 1A A8 FF FF EA 00 30 8D E5 00 20 94 E5 04 00 A0 E1 0F E0 A0 E1 28 F0 92 E5 00 30 9D E5 D3 FF FF EA 00 30 8D E5 00 20 99 E5 09 00 A0 E1 0F E0 A0 E1 24 F0 92 E5 00 30 9D E5 00 B0 A0 E1 86 FF FF EA 00 30 94 E5 04 00 A0 E1 0F E0 A0 E1 24 F0 93 E5 00 50 A0 E1 D2 FF FF EA 00 30 94 E5 04 00 A0 E1 0F E0 A0 E1 24 F0 93 E5 00 50 A0 E1 DE FF FF EA 09 00 A0 E1 00 30 99 E5 0F E0 A0 E1 24 F0 93 E5 CF FF FF EA 00 30 94 E5 04 00 A0 E1 0F E0 A0 E1 24 F0 93 E5 00 50 A0 E1 98 FF FF EA 02 00 5A E3 77 FF FF 0A 74 FF FF EA FF FF 00 00 }
	condition:
		$1
}

rule file_17_302_3 {
	meta:
		name = "_ZNKSt8time_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE15_M_extract_nameES3_S3_RiPPKwjRSt8ios_baseRSt12_Ios_Iostate"
		size = 1028
		refs = "0024 _ZSt9use_facetISt5ctypeIwEERKT_RKSt6locale 0044 _ZNKSt19istreambuf_iteratorIwSt11char_traitsIwEE5equalERKS2_ 0130 wcslen"
	strings:
		$1 = { F0 4F 2D E9 20 B0 8D E2 18 D0 4D E2 2C 00 0B E5 18 00 9B E5 28 40 4B E2 0C 00 84 E8 6C 00 80 E2 10 60 9B E5 ?? ?? ?? ?? 14 10 9B E5 00 A0 A0 E1 01 31 A0 E1 08 30 83 E2 03 D0 4D E0 04 00 A0 E1 04 10 8B E2 ?? ?? ?? ?? 07 50 8D E2 00 00 50 E3 07 50 C5 E3 0A 00 00 0A 1C C0 9B E5 00 30 9C E5 04 30 83 E3 00 30 8C E5 2C 20 1B E5 03 00 94 E8 00 00 82 E5 B4 10 C2 E1 02 00 A0 E1 20 D0 4B E2 F0 8F BD E8 28 30 1B E5 00 00 53 E3 6C 93 9F 05 03 00 00 0A B4 92 5B E1 60 23 9F E5 02 00 59 E1 7B 00 00 0A 14 20 9B E5 00 00 52 E3 E9 FF FF 0A 00 80 A0 E3 30 50 0B E5 08 70 A0 E1 02 50 A0 E1 05 00 00 EA 30 30 1B E5 07 81 83 E7 01 80 88 E2 08 00 55 E1 01 70 87 E2 0D 00 00 9A 08 31 96 E7 0A 00 A0 E1 B0 30 D3 E1 09 00 53 E1 03 10 A0 E1 F3 FF FF 0A 00 30 9A E5 0F E0 A0 E1 18 F0 93 E5 09 00 50 E1 EE FF FF 0A 01 80 88 E2 08 00 55 E1 F1 FF FF 8A 01 00 57 E3 30 50 1B E5 00 80 A0 83 A0 00 00 9A 00 30 95 E5 01 A0 A0 E3 03 01 96 E7 ?? ?? ?? ?? 00 90 A0 E1 0A 31 95 E7 01 A0 8A E2 03 01 96 E7 ?? ?? ?? ?? 00 00 59 E1 00 90 A0 21 07 00 5A E1 F7 FF FF 3A 28 30 1B E5 00 00 53 E3 07 00 00 0A 08 20 93 E5 0C 10 93 E5 01 00 52 E1 02 20 82 32 08 20 83 35 8C 00 00 2A 00 C0 E0 E3 B4 C2 4B E1 01 80 88 E2 09 00 58 E1 B1 FF FF 2A 04 00 A0 E1 04 10 8B E2 ?? ?? ?? ?? 00 A0 50 E2 AC FF FF 1A 88 20 A0 E1 0A 11 95 E7 28 30 1B E5 01 11 96 E7 00 00 53 E3 B2 90 91 E1 3C 02 9F 05 0A 11 A0 E1 03 00 00 0A B4 02 5B E1 2C C2 9F E5 0C 00 50 E1 23 00 00 0A 00 00 59 E1 01 70 47 12 07 31 95 17 01 A0 8A 02 01 30 85 17 0A 00 57 E1 EC FF FF 8A 01 00 57 E3 C9 FF FF 8A 01 00 57 E3 94 FF FF 1A 28 30 1B E5 00 00 53 E3 07 00 00 0A 08 20 93 E5 0C 10 93 E5 01 00 52 E1 02 20 82 32 08 20 83 35 55 00 00 2A 00 10 E0 E3 B4 12 4B E1 00 30 95 E5 01 80 88 E2 03 71 96 E7 07 00 A0 E1 ?? ?? ?? ?? 00 00 58 E1 00 60 A0 E1 1B 00 00 3A 06 00 58 E1 7F FF FF 1A 00 20 95 E5 0C 30 9B E5 00 20 83 E5 7F FF FF EA 08 C0 93 E5 0C 00 93 E5 00 00 5C E1 B0 00 DC 31 51 00 00 2A 7C 31 9F E5 03 00 50 E1 00 C0 A0 03 B4 02 4B 11 28 C0 0B 05 D0 FF FF EA 08 20 93 E5 0C 10 93 E5 01 00 52 E1 B0 90 D2 31 4F 00 00 2A 50 31 9F E5 03 00 59 E1 00 30 A0 03 B4 92 4B 11 28 30 0B 05 78 FF FF EA 88 70 87 E0 34 A1 9F E5 10 00 00 EA 00 00 59 E1 DE FF FF 1A 28 30 1B E5 00 00 53 E3 07 00 00 0A 08 20 93 E5 0C 10 93 E5 01 00 52 E1 02 20 82 32 08 20 83 35 1C 00 00 2A 00 20 E0 E3 B4 22 4B E1 01 80 88 E2 06 00 58 E1 02 70 87 E2 CF FF FF 2A 04 00 A0 E1 04 10 8B E2 ?? ?? ?? ?? 00 00 50 E3 CA FF FF 1A 28 30 1B E5 B0 90 D7 E1 00 00 53 E3 C8 00 9F 05 E4 FF FF 0A B4 02 5B E1 0A 00 50 E1 E1 FF FF 1A 08 20 93 E5 0C 10 93 E5 01 00 52 E1 B0 00 D2 31 0E 00 00 2A 0A 00 50 E1 00 30 A0 03 B4 02 4B 11 28 30 0B 05 D7 FF FF EA 03 00 A0 E1 00 30 93 E5 0F E0 A0 E1 28 F0 93 E5 DD FF FF EA 03 00 A0 E1 00 30 93 E5 0F E0 A0 E1 28 F0 93 E5 A4 FF FF EA 03 00 A0 E1 00 30 93 E5 0F E0 A0 E1 24 F0 93 E5 EB FF FF EA 00 80 A0 E3 92 FF FF EA 03 00 A0 E1 00 30 93 E5 0F E0 A0 E1 28 F0 93 E5 6D FF FF EA 03 00 A0 E1 34 10 0B E5 38 20 0B E5 00 30 93 E5 0F E0 A0 E1 24 F0 93 E5 38 20 1B E5 34 10 1B E5 A4 FF FF EA 03 00 A0 E1 00 30 93 E5 0F E0 A0 E1 24 F0 93 E5 00 90 A0 E1 A9 FF FF EA FF FF 00 00 }
	condition:
		$1
}

rule file_17_303_3 {
	meta:
		name = "_ZNKSt8time_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE16do_get_monthnameES3_S3_RSt8ios_baseRSt12_Ios_IostateP2tm"
		size = 1016
		refs = "0028 _ZSt9use_facetISt11__timepunctIwEERKT_RKSt6locale 0034 _ZSt9use_facetISt5ctypeIwEERKT_RKSt6locale 00e8 _ZNKSt8time_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE15_M_extract_nameES3_S3_RiPPKwjRSt8ios_baseRSt12_Ios_Iostate 0180 _ZNKSt19istreambuf_iteratorIwSt11char_traitsIwEE5equalERKS2_ 019c wcslen 0374 _ZNKSt19istreambuf_iteratorIwSt11char_traitsIwEEdeEv"
	strings:
		$1 = { F0 4F 2D E9 64 D0 4D E2 90 B0 9D E5 1C 40 8D E2 6C 60 8B E2 00 50 A0 E1 06 00 A0 E1 0C 00 84 E8 01 90 A0 E1 94 70 9D E5 ?? ?? ?? ?? 00 80 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 08 30 98 E5 00 10 A0 E3 94 20 93 E5 88 A0 8D E2 24 20 8D E5 98 20 93 E5 5C 10 8D E5 28 20 8D E5 9C 20 93 E5 03 00 9A E8 2C 20 8D E5 A0 20 93 E5 54 60 8D E2 30 20 8D E5 A4 20 93 E5 5C C0 8D E2 34 20 8D E5 A8 20 93 E5 38 20 8D E5 AC 20 93 E5 3C 20 8D E5 B0 20 93 E5 40 20 8D E5 B4 20 93 E5 44 20 8D E5 B8 20 93 E5 48 20 8D E5 BC 20 93 E5 4C 20 8D E5 C0 30 93 E5 0D 20 A0 E1 03 00 82 E8 50 30 8D E5 60 30 8D E2 08 30 8D E5 24 30 8D E2 0C 30 8D E5 0C 30 A0 E3 10 30 8D E5 09 10 A0 E1 14 B0 8D E5 06 00 A0 E1 0C 00 94 E8 18 C0 8D E5 ?? ?? ?? ?? 03 00 96 E8 5C 30 9D E5 1C 00 8D E5 00 00 53 E3 B0 12 CD E1 1C 00 00 0A 00 30 97 E5 04 30 83 E3 00 30 87 E5 1C 30 9D E5 00 00 53 E3 54 00 00 0A B0 12 DD E1 CC 22 9F E5 02 00 51 E1 60 00 00 0A 88 30 9D E5 00 60 A0 E3 00 00 53 E3 50 00 00 0A BC 18 DD E1 AC 22 9F E5 02 00 51 E1 4E 00 00 0A 00 30 A0 E3 06 00 53 E1 00 30 97 05 03 00 94 E8 02 30 83 03 00 00 85 E5 00 30 87 05 B4 10 C5 E1 05 00 A0 E1 64 D0 8D E2 F0 8F BD E8 04 00 A0 E1 0A 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 2F 00 00 1A 60 30 9D E5 64 00 8D E2 03 31 80 E0 40 00 13 E5 ?? ?? ?? ?? 08 20 98 E5 60 10 9D E5 64 30 92 E5 00 60 A0 E1 24 30 8D E5 64 00 8D E2 01 11 80 E0 68 00 92 E5 1C 30 9D E5 28 00 8D E5 6C 00 92 E5 86 90 A0 E1 2C 00 8D E5 70 00 92 E5 00 00 53 E3 30 00 8D E5 74 00 92 E5 34 00 8D E5 78 00 92 E5 38 00 8D E5 7C 00 92 E5 3C 00 8D E5 80 00 92 E5 40 00 8D E5 84 00 92 E5 44 00 8D E5 88 00 92 E5 48 00 8D E5 8C 00 92 E5 4C 00 8D E5 90 20 92 E5 D0 01 9F 05 50 20 8D E5 40 80 11 E5 B9 B0 98 E1 09 90 88 E0 03 00 00 0A B0 02 DD E1 B4 21 9F E5 02 00 50 E1 24 00 00 0A 00 00 5B E1 2D 00 00 0A 5C 30 9D E5 00 00 53 E3 AA FF FF 1A 98 30 9D E5 60 20 9D E5 10 20 83 E5 1C 30 9D E5 00 00 53 E3 AA FF FF 1A 01 60 A0 E3 88 30 9D E5 00 00 53 E3 AE FF FF 1A 01 30 A0 E3 B1 FF FF EA 08 20 93 E5 0C 10 93 E5 01 00 52 E1 B0 00 D2 31 46 00 00 2A 50 31 9F E5 03 00 50 E1 A8 FF FF 1A 01 30 A0 E3 A7 FF FF EA 08 20 93 E5 0C 10 93 E5 01 00 52 E1 B0 00 D2 31 41 00 00 2A 28 31 9F E5 03 00 50 E1 35 00 00 0A B0 02 CD E1 94 FF FF EA 08 20 93 E5 0C 10 93 E5 01 00 52 E1 B0 00 D2 31 3C 00 00 2A 00 31 9F E5 03 00 50 E1 00 30 A0 03 B0 02 CD 11 1C 30 8D 05 CF FF FF EA 08 00 A0 E1 ?? ?? ?? ?? 00 00 56 E1 00 80 A0 E1 0F 00 00 3A 08 00 56 E1 CA FF FF 0A 5C 30 9D E5 04 30 83 E3 5C 30 8D E5 74 FF FF EA 03 00 A0 E1 00 30 93 E5 0F E0 A0 E1 28 F0 93 E5 00 20 E0 E3 B0 22 CD E1 01 60 86 E2 08 00 56 E1 02 90 89 E2 EF FF FF 2A 0A 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 EA FF FF 1A 04 00 A0 E1 B0 B0 D9 E1 ?? ?? ?? ?? 00 00 5B E1 E5 FF FF 1A 1C 30 9D E5 00 00 53 E3 EE FF FF 0A 08 20 93 E5 0C 10 93 E5 02 00 82 E2 01 00 52 E1 08 00 83 35 E6 FF FF 3A E1 FF FF EA 00 30 A0 E3 1C 30 8D E5 01 60 A0 E3 AE FF FF EA 03 00 A0 E1 00 30 93 E5 0F E0 A0 E1 24 F0 93 E5 B3 FF FF EA 03 00 A0 E1 00 30 93 E5 0F E0 A0 E1 24 F0 93 E5 B8 FF FF EA 03 00 A0 E1 00 30 93 E5 0F E0 A0 E1 24 F0 93 E5 BD FF FF EA FF FF 00 00 }
	condition:
		$1
}

rule file_17_304_3 {
	meta:
		name = "_ZNKSt8time_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE14do_get_weekdayES3_S3_RSt8ios_baseRSt12_Ios_IostateP2tm"
		size = 936
		refs = "0028 _ZSt9use_facetISt11__timepunctIwEERKT_RKSt6locale 0034 _ZSt9use_facetISt5ctypeIwEERKT_RKSt6locale 00c0 _ZNKSt8time_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE15_M_extract_nameES3_S3_RiPPKwjRSt8ios_baseRSt12_Ios_Iostate 0158 _ZNKSt19istreambuf_iteratorIwSt11char_traitsIwEE5equalERKS2_ 0174 wcslen 0324 _ZNKSt19istreambuf_iteratorIwSt11char_traitsIwEEdeEv"
	strings:
		$1 = { F0 4F 2D E9 50 D0 4D E2 7C B0 9D E5 1C 40 8D E2 6C 60 8B E2 00 50 A0 E1 06 00 A0 E1 01 A0 A0 E1 0C 00 84 E8 80 70 9D E5 ?? ?? ?? ?? 00 80 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 0C 00 94 E8 08 10 98 E5 0D E0 A0 E1 48 00 91 E5 74 90 8D E2 24 00 8D E5 4C 00 91 E5 40 60 8D E2 28 00 8D E5 50 00 91 E5 2C 00 8D E5 54 00 91 E5 30 00 8D E5 58 00 91 E5 34 00 8D E5 5C 00 91 E5 38 00 8D E5 60 C0 91 E5 03 00 99 E8 03 00 8E E8 3C C0 8D E5 00 C0 A0 E3 48 C0 8D E5 4C C0 8D E2 08 C0 8D E5 24 C0 8D E2 0C C0 8D E5 07 C0 A0 E3 0A 10 A0 E1 06 00 A0 E1 10 C0 8D E5 48 C0 8D E2 14 B0 8D E5 18 C0 8D E5 ?? ?? ?? ?? 03 00 96 E8 48 30 9D E5 1C 00 8D E5 00 00 53 E3 B0 12 CD E1 1C 00 00 0A 00 30 97 E5 04 30 83 E3 00 30 87 E5 1C 30 9D E5 00 00 53 E3 4A 00 00 0A B0 12 DD E1 A4 22 9F E5 02 00 51 E1 56 00 00 0A 74 30 9D E5 00 60 A0 E3 00 00 53 E3 46 00 00 0A B8 17 DD E1 84 22 9F E5 02 00 51 E1 44 00 00 0A 00 30 A0 E3 06 00 53 E1 00 30 97 05 03 00 94 E8 02 30 83 03 00 00 85 E5 00 30 87 05 B4 10 C5 E1 05 00 A0 E1 50 D0 8D E2 F0 8F BD E8 04 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 25 00 00 1A 4C 30 9D E5 50 00 8D E2 03 31 80 E0 2C 00 13 E5 ?? ?? ?? ?? 08 20 98 E5 00 60 A0 E1 2C 30 92 E5 4C 10 9D E5 24 30 8D E5 30 00 92 E5 50 E0 8D E2 28 00 8D E5 34 00 92 E5 01 11 8E E0 2C 00 8D E5 38 00 92 E5 1C 30 9D E5 30 00 8D E5 3C 00 92 E5 86 A0 A0 E1 34 00 8D E5 40 00 92 E5 00 00 53 E3 38 00 8D E5 44 20 92 E5 D0 01 9F 05 3C 20 8D E5 2C 80 11 E5 BA B0 98 E1 0A A0 88 E0 03 00 00 0A B0 02 DD E1 B4 21 9F E5 02 00 50 E1 24 00 00 0A 00 00 5B E1 2D 00 00 0A 48 30 9D E5 00 00 53 E3 B4 FF FF 1A 84 30 9D E5 4C 20 9D E5 18 20 83 E5 1C 30 9D E5 00 00 53 E3 B4 FF FF 1A 01 60 A0 E3 74 30 9D E5 00 00 53 E3 B8 FF FF 1A 01 30 A0 E3 BB FF FF EA 08 20 93 E5 0C 10 93 E5 01 00 52 E1 B0 00 D2 31 46 00 00 2A 50 31 9F E5 03 00 50 E1 B2 FF FF 1A 01 30 A0 E3 B1 FF FF EA 08 20 93 E5 0C 10 93 E5 01 00 52 E1 B0 00 D2 31 41 00 00 2A 28 31 9F E5 03 00 50 E1 35 00 00 0A B0 02 CD E1 9E FF FF EA 08 20 93 E5 0C 10 93 E5 01 00 52 E1 B0 00 D2 31 3C 00 00 2A 00 31 9F E5 03 00 50 E1 00 30 A0 03 B0 02 CD 11 1C 30 8D 05 CF FF FF EA 08 00 A0 E1 ?? ?? ?? ?? 00 00 56 E1 00 80 A0 E1 0F 00 00 3A 08 00 56 E1 CA FF FF 0A 48 30 9D E5 04 30 83 E3 48 30 8D E5 7E FF FF EA 03 00 A0 E1 00 30 93 E5 0F E0 A0 E1 28 F0 93 E5 00 00 E0 E3 B0 02 CD E1 01 60 86 E2 08 00 56 E1 02 A0 8A E2 EF FF FF 2A 09 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 EA FF FF 1A 04 00 A0 E1 B0 B0 DA E1 ?? ?? ?? ?? 00 00 5B E1 E5 FF FF 1A 1C 30 9D E5 00 00 53 E3 EE FF FF 0A 08 20 93 E5 0C 10 93 E5 02 00 82 E2 01 00 52 E1 08 00 83 35 E6 FF FF 3A E1 FF FF EA 00 30 A0 E3 1C 30 8D E5 01 60 A0 E3 AE FF FF EA 03 00 A0 E1 00 30 93 E5 0F E0 A0 E1 24 F0 93 E5 B3 FF FF EA 03 00 A0 E1 00 30 93 E5 0F E0 A0 E1 24 F0 93 E5 B8 FF FF EA 03 00 A0 E1 00 30 93 E5 0F E0 A0 E1 24 F0 93 E5 BD FF FF EA FF FF 00 00 }
	condition:
		$1
}

rule file_17_305_3 {
	meta:
		name = "_ZNKSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE14_M_extract_intIxEES3_S3_S3_RSt8ios_baseRSt12_Ios_IostateRT_"
		size = 3816
		refs = "0040 _Unwind_SjLj_Register 0058 _ZNKSt11__use_cacheISt16__numpunct_cacheIwEEclERKSt6locale 01a0 __udivdi3 022c wmemchr 030c _ZNKSt19istreambuf_iteratorIwSt11char_traitsIwEE5equalERKS2_ 057c _Unwind_SjLj_Unregister 0678 _ZNSs7reserveEj 06c4 _ZSt17__verify_groupingPKcjRKSs 0a68 _ZNSt19istreambuf_iteratorIwSt11char_traitsIwEEppEv 0a80 _ZNKSt19istreambuf_iteratorIwSt11char_traitsIwEEdeEv 0e14 _ZNSs4_Rep10_M_destroyERKSaIcE 0e50 _ZN9__gnu_cxx18__exchange_and_addEPVii 0e78 _ZNSsD1Ev 0e88 _Unwind_SjLj_Resume 0ecc .text$_ZNKSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE14_M_extract_intIxEES3_S3_S3_RSt8ios_baseRSt12_Ios_IostateRT_ 0ed0 __gxx_personality_sj0 0ed4 .gcc_except_table 0edc _ZNSs4_Rep20_S_empty_rep_storageE 0ee4 _CRT_MT"
	strings:
		$1 = { 70 48 2D E9 10 B0 8D E2 90 D0 4D E2 24 10 4B E2 0C 00 81 E8 B0 3E 9F E5 98 00 0B E5 34 30 0B E5 A8 3E 9F E5 10 00 4B E2 40 30 0B E5 A0 3E 9F E5 38 00 0B E5 58 00 4B E2 3C 30 0B E5 30 D0 0B E5 ?? ?? ?? ?? 0C 20 9B E5 00 30 E0 E3 14 00 4B E2 6C 10 82 E2 54 30 0B E5 ?? ?? ?? ?? 0C 40 9B E5 70 50 80 E2 0C 30 94 E5 6C 00 0B E5 4A 30 03 E2 40 00 53 E3 08 60 A0 03 68 50 0B E5 7C 30 0B E5 74 60 0B 05 04 00 00 0A 7C C0 1B E5 08 00 5C E3 10 C0 A0 03 0A C0 A0 13 74 C0 0B E5 24 00 1B E5 00 00 50 E3 01 E0 A0 03 64 E0 0B 05 05 00 00 0A B0 22 5B E1 1C 3E 9F E5 03 00 52 E1 00 00 A0 13 64 00 0B 15 D3 02 00 0A 04 00 9B E5 00 00 50 E3 CB 02 00 0A B8 20 DB E1 F8 3D 9F E5 03 00 52 E1 44 02 00 0A 00 30 A0 E3 64 40 1B E5 03 00 54 E1 00 00 A0 03 64 00 0B 05 A0 00 0B 05 BE 01 00 1A 6C 20 1B E5 00 10 A0 E3 01 40 A0 E3 10 30 D2 E5 78 10 0B E5 8C 40 0B E5 84 10 0B E5 74 40 1B E5 10 00 54 E3 16 50 A0 03 7C 50 0B 05 07 00 00 0A 6C 60 1B E5 64 C0 1B E5 10 30 D6 E5 60 C0 0B E5 60 E0 1B E5 74 00 1B E5 64 E0 0B E5 7C 00 0B E5 00 00 53 E3 80 3D 9F E5 1C 30 0B E5 A0 01 00 1A A0 10 1B E5 00 00 51 E3 81 00 00 1A 00 20 E0 E3 02 31 E0 E3 94 20 0B E5 90 30 0B E5 74 50 1B E5 94 10 4B E2 03 00 91 E8 05 40 A0 E1 C4 5F A0 E1 05 30 A0 E1 04 20 A0 E1 74 40 0B E5 70 50 0B E5 ?? ?? ?? ?? 6C 60 1B E5 68 C0 1B E5 A4 30 D6 E5 08 C0 8C E2 01 00 53 E3 9C 00 0B E5 80 10 0B E5 88 C0 0B E5 6F 00 00 1A 8C E0 1B E5 00 00 5E E3 B6 02 00 1A 00 10 A0 E3 00 00 A0 E3 60 00 0B E5 5C 10 0B E5 8C 10 1B E5 68 10 0B E5 6C 20 1B E5 10 30 D2 E5 00 00 53 E3 03 00 00 0A B6 32 D2 E1 64 40 1B E5 04 00 53 E1 3E 01 00 0A 6C 60 1B E5 64 C0 1B E5 B4 32 D6 E1 0C 00 53 E1 04 01 00 0A 0C 10 A0 E1 88 00 1B E5 7C 20 1B E5 ?? ?? ?? ?? 00 00 50 E3 FE 00 00 0A 88 E0 1B E5 80 20 1B E5 00 10 6E E0 C1 10 A0 E1 5C 00 1B E5 0F 00 51 E3 06 10 41 C2 02 00 50 E1 D6 00 00 8A D1 00 00 0A 60 60 1B E5 70 00 1B E5 74 E0 1B E5 96 00 00 E0 5C 20 1B E5 96 3E 84 E0 94 60 4B E2 60 00 96 E8 9E 02 20 E0 C1 2F A0 E1 04 40 80 E0 01 50 55 E0 02 60 C6 E0 06 00 54 E1 00 00 A0 E3 17 01 00 8A 14 01 00 0A 68 60 1B E5 03 50 91 E0 06 00 80 E1 04 60 A2 E0 60 50 0B E5 5C 60 0B E5 78 60 1B E5 FF 00 00 E2 01 60 86 E2 68 00 0B E5 78 60 0B E5 24 00 1B E5 00 00 50 E3 07 00 00 0A 08 30 90 E5 0C 20 90 E5 02 00 53 E1 02 30 83 32 08 30 80 35 80 02 00 2A 00 E0 E0 E3 B0 E2 4B E1 02 00 A0 E3 54 00 0B E5 04 10 8B E2 24 00 4B E2 ?? ?? ?? ?? 00 00 50 E3 6A 00 00 1A 24 00 1B E5 00 00 50 E3 B0 1B 9F 05 64 10 0B 05 AF FF FF 0A B0 22 5B E1 A0 3B 9F E5 64 20 0B E5 03 00 52 E1 AA FF FF 1A 08 20 90 E5 0C 30 90 E5 03 00 52 E1 B2 02 00 2A B0 20 D2 E1 64 20 0B E5 64 50 1B E5 74 6B 9F E5 06 00 55 E1 00 C0 A0 03 B0 52 4B 11 24 C0 0B 05 9D FF FF EA 00 30 A0 E3 02 41 A0 E3 94 30 0B E5 90 40 0B E5 7C FF FF EA 8C 00 1B E5 00 00 50 E3 46 02 00 1A 7C 10 1B E5 00 20 A0 E3 30 30 81 E2 03 38 A0 E1 23 38 A0 E1 88 30 0B E5 00 30 A0 E3 60 20 0B E5 5C 30 0B E5 68 00 0B E5 7C 30 1B E5 0A 00 53 E3 97 00 00 9A 64 60 1B E5 30 10 46 E2 01 38 A0 E1 09 08 53 E3 04 00 00 9A 61 30 46 E2 03 38 A0 E1 05 08 53 E3 57 10 46 92 F5 00 00 8A 01 00 71 E3 8E 00 00 0A 5C 00 1B E5 80 20 1B E5 02 00 50 E1 64 00 00 8A 5F 00 00 0A 60 60 1B E5 70 00 1B E5 74 E0 1B E5 96 00 00 E0 5C 20 1B E5 96 3E 84 E0 94 60 4B E2 60 00 96 E8 9E 02 20 E0 C1 2F A0 E1 04 40 80 E0 01 50 55 E0 02 60 C6 E0 06 00 54 E1 00 00 A0 E3 A8 00 00 8A A5 00 00 0A 68 60 1B E5 03 50 91 E0 06 00 80 E1 04 60 A2 E0 60 50 0B E5 5C 60 0B E5 78 60 1B E5 FF 00 00 E2 01 60 86 E2 68 00 0B E5 78 60 0B E5 24 00 1B E5 00 00 50 E3 07 00 00 0A 08 30 90 E5 0C 20 90 E5 02 00 53 E1 02 30 83 32 08 30 80 35 0E 02 00 2A 00 C0 E0 E3 B0 C2 4B E1 02 30 A0 E3 24 00 4B E2 04 10 8B E2 54 30 0B E5 ?? ?? ?? ?? 00 00 50 E3 3F 00 00 0A 00 E0 A0 E3 01 00 A0 E3 74 E0 0B E5 8C 00 0B E5 1C 30 1B E5 0C 20 13 E5 0C 40 43 E2 00 00 52 E3 64 40 0B E5 59 00 00 1A 78 20 1B E5 00 00 52 E3 06 00 00 1A 84 30 1B E5 00 00 53 E3 03 00 00 1A 64 40 1B E5 00 30 94 E5 00 00 53 E3 02 00 00 0A 74 50 1B E5 00 00 55 E3 9B 00 00 0A 14 60 9B E5 00 30 A0 E3 00 40 A0 E3 10 C0 9B E5 18 00 86 E8 04 30 A0 E3 00 30 8C E5 8C E0 1B E5 98 29 9F E5 00 00 5E E3 10 00 9B 15 64 10 1B E5 00 30 90 15 02 30 83 13 00 30 80 15 02 00 51 E1 98 20 1B E5 24 30 4B E2 03 00 93 E8 00 00 82 E5 B4 10 C2 E1 1A 02 00 1A 58 00 4B E2 ?? ?? ?? ?? 98 00 1B E5 10 D0 4B E2 70 88 BD E8 60 30 1B E5 9C 40 1B E5 04 00 53 E1 9B FF FF 9A 01 50 A0 E3 68 50 0B E5 B4 FF FF EA 60 30 1B E5 9C 40 1B E5 04 00 53 E1 29 FF FF 9A 01 50 A0 E3 68 50 0B E5 42 FF FF EA 24 00 1B E5 00 00 50 E3 04 E9 9F 05 64 E0 0B 05 78 FF FF 0A B0 12 5B E1 F4 28 9F E5 64 10 0B E5 02 00 51 E1 73 FF FF 1A 08 20 90 E5 0C 30 90 E5 03 00 52 E1 E2 01 00 2A B0 20 D2 E1 64 20 0B E5 64 30 1B E5 C8 48 9F E5 04 00 53 E1 B0 32 4B 11 7C 30 1B E5 00 50 A0 03 24 50 0B 05 0A 00 53 E3 67 FF FF 8A 64 40 1B E5 2F 00 54 E3 99 01 00 8A 1C 30 1B E5 00 10 A0 E3 0C 20 13 E5 0C 40 43 E2 00 00 52 E3 74 10 0B E5 64 40 0B E5 A5 FF FF 0A 04 10 94 E5 01 50 82 E2 01 00 55 E1 7C 50 0B E5 14 01 00 9A 02 30 A0 E3 1C 00 4B E2 7C 10 1B E5 54 30 0B E5 ?? ?? ?? ?? 1C 30 1B E5 0C 20 13 E5 78 60 1B E5 02 60 C3 E7 10 20 4B E2 0C 00 32 E5 7C E0 1B E5 0C 10 40 E2 00 30 A0 E3 0E C0 81 E0 08 30 81 E5 0C E0 00 E5 0C 30 CC E5 6C 00 1B E5 02 30 A0 E3 0C 10 90 E5 08 00 90 E5 54 30 0B E5 ?? ?? ?? ?? 00 00 50 E3 10 10 9B 05 04 30 A0 03 00 30 81 05 1C 30 1B E5 0C 30 43 E2 64 30 0B E5 80 FF FF EA 05 00 53 E1 57 FF FF 9A 01 00 A0 E3 55 FF FF EA 05 00 53 E1 E8 FE FF 9A 01 00 A0 E3 E6 FE FF EA 78 50 1B E5 00 00 55 E3 6E 01 00 0A 1C 30 1B E5 0C 10 43 E2 0C 20 13 E5 04 00 91 E5 01 C0 82 E2 00 00 5C E1 64 C0 0B E5 02 00 00 8A 08 10 91 E5 00 00 51 E3 06 00 00 DA 02 E0 A0 E3 1C 00 4B E2 64 10 1B E5 54 E0 0B E5 ?? ?? ?? ?? 1C 30 1B E5 0C 20 13 E5 78 00 1B E5 00 50 A0 E3 02 00 C3 E7 1C 10 1B E5 64 40 1B E5 00 20 A0 E3 0C 30 41 E2 78 20 0B E5 04 20 83 E0 0C 40 01 E5 08 50 83 E5 0C 50 C2 E5 CF FE FF EA 68 60 1B E5 00 00 56 E3 88 00 00 0A A0 E0 1B E5 00 00 5E E3 C8 00 00 0A 14 00 9B E5 00 30 A0 E3 02 41 A0 E3 18 00 80 E8 10 20 9B E5 04 30 A0 E3 00 30 82 E5 5C FF FF EA 64 E0 1B E5 41 30 4E E2 03 38 A0 E1 05 08 53 E3 95 FF FF 8A 37 10 4E E2 02 FF FF EA 02 30 A0 E3 1C 00 4B E2 20 10 A0 E3 54 30 0B E5 ?? ?? ?? ?? 58 FE FF EA 24 00 1B E5 00 00 50 E3 CC 56 9F 05 64 50 0B 05 04 00 00 0A B0 62 5B E1 BC 36 9F E5 64 60 0B E5 03 00 56 E1 10 01 00 0A 6C E0 1B E5 64 00 1B E5 B0 37 DE E1 00 00 53 E1 00 30 A0 13 01 30 A0 03 00 00 53 E3 A0 30 0B E5 75 00 00 1A 68 10 1B E5 B2 30 D1 E1 00 00 53 E1 71 00 00 0A 6C C0 1B E5 64 E0 1B E5 10 30 DC E5 60 E0 0B E5 7C 10 1B E5 00 00 A0 E3 78 00 0B E5 84 00 0B E5 80 10 0B E5 00 00 53 E3 04 00 00 0A 6C 60 1B E5 60 C0 1B E5 B6 22 D6 E1 0C 00 52 E1 88 01 00 0A 6C E0 1B E5 60 00 1B E5 B4 22 DE E1 00 00 52 E1 83 01 00 0A 68 10 1B E5 B8 20 D1 E1 00 00 52 E1 A7 00 00 0A 84 40 1B E5 00 00 54 E3 77 01 00 0A 68 50 1B E5 60 60 1B E5 B4 20 D5 E1 06 00 52 E1 02 00 00 0A B6 20 D5 E1 06 00 52 E1 6F 01 00 1A 7C C0 1B E5 00 00 5C E3 92 00 00 1A 80 E0 1B E5 10 00 A0 E3 78 E0 0B E5 84 E0 0B E5 74 00 0B E5 24 00 1B E5 00 00 50 E3 72 00 00 0A 08 30 90 E5 0C 20 90 E5 02 00 53 E1 02 30 83 32 08 30 80 35 F9 00 00 2A 24 00 1B E5 00 50 E0 E3 00 00 50 E3 B0 52 4B E1 67 00 00 0A 08 30 90 E5 0C 20 90 E5 02 00 53 E1 B0 00 D3 31 4D 01 00 2A 7C C5 9F E5 0C 00 50 E1 00 00 A0 03 B0 02 4B 11 24 00 0B 05 04 00 9B E5 00 E0 A0 13 01 10 A0 03 64 E0 0B 15 64 10 0B 05 00 00 50 E3 5B 00 00 0A B8 30 DB E1 48 45 9F E5 04 00 53 E1 3F 00 00 0A 64 E0 1B E5 00 30 A0 E3 0E 00 53 E1 57 00 00 1A 60 00 1B E5 6C 10 1B E5 01 20 A0 E3 64 00 0B E5 10 30 D1 E5 8C 20 0B E5 D6 FD FF EA A0 30 1B E5 00 00 53 E3 05 00 00 0A 60 50 4B E2 30 00 95 E8 00 40 74 E2 00 50 E5 E2 60 40 0B E5 5C 50 0B E5 14 C0 9B E5 60 60 4B E2 60 00 96 E8 60 00 8C E8 D0 FE FF EA 08 30 90 E5 0C 20 90 E5 02 00 53 E1 B0 00 D3 31 D7 00 00 2A C4 34 9F E5 03 00 50 E1 78 00 00 0A B8 00 CB E1 B0 FD FF EA 6C 20 1B E5 10 30 D2 E5 00 00 53 E3 04 00 00 0A B6 42 D2 E1 64 50 1B E5 60 40 0B E5 05 00 54 E1 88 FF FF 0A 6C 60 1B E5 64 C0 1B E5 B4 62 D6 E1 0C 00 56 E1 60 60 0B E5 82 FF FF 0A 00 30 E0 E3 24 00 4B E2 54 30 0B E5 ?? ?? ?? ?? 04 10 8B E2 ?? ?? ?? ?? 00 00 50 E3 A0 FD FF 1A 24 00 4B E2 ?? ?? ?? ?? 6C E0 1B E5 60 00 0B E5 10 30 DE E5 74 FF FF EA 08 30 90 E5 0C 20 90 E5 02 00 53 E1 B0 00 D3 31 A1 00 00 2A 28 64 9F E5 06 00 50 E1 42 00 00 0A B8 00 CB E1 B5 FF FF EA 08 10 94 E5 00 00 51 E3 E7 FE FF CA ED FE FF EA 14 10 9B E5 00 30 E0 E3 02 41 E0 E3 18 00 81 E8 35 FF FF EA 04 00 9B E5 01 20 A0 E3 00 00 50 E3 64 20 0B E5 A3 FF FF 1A 01 30 A0 E3 64 E0 1B E5 0E 00 53 E1 A7 FF FF 0A 24 00 1B E5 00 00 50 E3 C4 23 9F 05 03 00 00 0A B0 22 5B E1 B8 33 9F E5 03 00 52 E1 2A 00 00 0A 84 C0 1B E5 00 00 5C E3 48 00 00 0A 6C 50 1B E5 60 20 0B E5 10 30 D5 E5 4E FF FF EA 74 10 1B E5 10 00 51 E3 2F 00 00 1A 00 30 A0 E3 78 30 0B E5 84 30 0B E5 6A FF FF EA 84 20 1B E5 00 00 52 E3 02 00 00 0A 74 40 1B E5 0A 00 54 E3 54 FF FF 1A 7C 50 1B E5 00 00 55 E3 06 00 00 1A 80 60 1B E5 01 C0 A0 E3 08 E0 A0 E3 78 60 0B E5 84 C0 0B E5 74 E0 0B E5 5A FF FF EA 74 10 1B E5 78 00 1B E5 08 00 51 E3 01 00 80 12 00 00 A0 03 01 20 A0 E3 78 00 0B E5 84 20 0B E5 51 FF FF EA 00 C0 A0 E3 04 C0 8B E5 01 30 A0 E3 C9 FF FF EA 08 30 90 E5 0C 20 90 E5 02 00 53 E1 B0 20 D3 31 59 00 00 2A EC 52 9F E5 05 00 52 E1 00 60 A0 03 B0 22 4B 11 24 60 0B 05 C9 FF FF EA 00 30 A0 E3 04 30 8B E5 01 30 A0 E3 36 FD FF EA 00 20 A0 E3 8C 20 0B E5 49 FD FF EA 08 30 90 E5 0C 20 90 E5 02 00 53 E1 B0 00 D3 31 66 00 00 2A A4 32 9F E5 03 00 50 E1 00 10 A0 13 00 30 A0 03 01 20 A0 03 B0 02 4B 11 64 10 0B 15 24 30 0B 05 64 20 0B 05 1C FD FF EA 6C E0 1B E5 64 20 0B E5 10 30 DE E5 8C C0 0B E5 2C FD FF EA 08 30 90 E5 0C 20 90 E5 02 00 53 E1 4B 00 00 2A B0 30 D3 E1 64 30 0B E5 50 32 9F E5 64 C0 1B E5 03 00 5C E1 00 30 A0 03 B0 C2 4B 11 24 30 0B 05 E1 FE FF EA 88 50 1B E5 05 00 54 E1 62 FE FF 2A 30 10 44 E2 CF FD FF EA 00 20 A0 E3 00 30 A0 E3 00 40 A0 E3 68 20 0B E5 60 30 0B E5 5C 40 0B E5 74 20 0B E5 00 FE FF EA 01 60 A0 E3 74 60 0B E5 FD FD FF EA 00 30 90 E5 28 20 93 E5 02 30 A0 E3 54 30 0B E5 0F E0 A0 E1 02 F0 A0 E1 E9 FD FF EA 00 30 90 E5 02 C0 A0 E3 28 30 93 E5 54 C0 0B E5 0F E0 A0 E1 03 F0 A0 E1 77 FD FF EA 00 30 90 E5 00 40 E0 E3 28 30 93 E5 54 40 0B E5 0F E0 A0 E1 03 F0 A0 E1 FE FE FF EA 00 30 90 E5 00 50 E0 E3 24 30 93 E5 54 50 0B E5 0F E0 A0 E1 03 F0 A0 E1 56 FF FF EA 00 30 90 E5 00 40 E0 E3 24 30 93 E5 54 40 0B E5 0F E0 A0 E1 03 F0 A0 E1 00 20 A0 E1 9D FF FF EA 00 30 90 E5 00 20 E0 E3 24 30 93 E5 54 20 0B E5 0F E0 A0 E1 03 F0 A0 E1 20 FF FF EA 00 30 90 E5 24 20 93 E5 02 30 A0 E3 54 30 0B E5 0F E0 A0 E1 02 F0 A0 E1 64 00 0B E5 16 FE FF EA 00 30 90 E5 00 20 E0 E3 24 30 93 E5 54 20 0B E5 0F E0 A0 E1 03 F0 A0 E1 64 00 0B E5 AD FF FF EA 00 30 90 E5 00 20 E0 E3 24 30 93 E5 54 20 0B E5 0F E0 A0 E1 03 F0 A0 E1 91 FF FF EA F8 30 9F E5 00 30 93 E5 00 00 53 E3 11 00 00 1A 64 40 1B E5 08 00 94 E5 01 30 40 E2 08 30 84 E5 00 00 50 E3 DA FD FF CA 64 00 1B E5 18 10 4B E2 ?? ?? ?? ?? D6 FD FF EA 00 30 90 E5 02 40 A0 E3 24 30 93 E5 54 40 0B E5 0F E0 A0 E1 03 F0 A0 E1 64 00 0B E5 46 FD FF EA 01 30 A0 E3 54 30 0B E5 64 30 1B E5 00 10 E0 E3 08 00 83 E2 ?? ?? ?? ?? EA FF FF EA 10 B0 8B E2 54 30 1B E5 50 50 1B E5 01 00 53 E3 64 50 0B E5 00 30 A0 03 1C 00 4B 02 54 30 0B 05 ?? ?? ?? ?? 00 30 E0 E3 64 00 1B E5 54 30 0B E5 ?? ?? ?? ?? 00 30 90 E5 00 60 E0 E3 24 30 93 E5 54 60 0B E5 0F E0 A0 E1 03 F0 A0 E1 AA FE FF EA 60 10 1B E5 00 20 A0 E3 64 10 0B E5 8C 20 0B E5 97 FC FF EA 00 00 A0 E3 64 20 0B E5 8C 00 0B E5 93 FC FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FF FF 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_306_3 {
	meta:
		name = "_ZNKSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE6do_getES3_S3_RSt8ios_baseRSt12_Ios_IostateRx"
		size = 92
		refs = "004c _ZNKSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE14_M_extract_intIxEES3_S3_S3_RSt8ios_baseRSt12_Ios_IostateRT_"
	strings:
		$1 = { 10 40 2D E9 1C D0 4D E2 14 C0 8D E2 0C 00 8C E8 24 30 8D E2 00 40 A0 E1 01 E0 A0 E1 03 00 93 E8 0D 30 A0 E1 03 00 83 E8 0C 00 9C E8 2C C0 9D E5 04 00 A0 E1 08 C0 8D E5 30 C0 9D E5 0E 10 A0 E1 0C C0 8D E5 34 C0 9D E5 10 C0 8D E5 ?? ?? ?? ?? 04 00 A0 E1 1C D0 8D E2 10 80 BD E8 }
	condition:
		$1
}

rule file_49_307_3 {
	meta:
		name = "_ZNKSt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE6do_getES3_S3_RSt8ios_baseRSt12_Ios_IostateRj"
		size = 92
		refs = "004c _ZNKSt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE14_M_extract_intIjEES3_S3_S3_RSt8ios_baseRSt12_Ios_IostateRT_"
	strings:
		$1 = { 10 40 2D E9 1C D0 4D E2 14 C0 8D E2 0C 00 8C E8 24 30 8D E2 00 40 A0 E1 01 E0 A0 E1 03 00 93 E8 0D 30 A0 E1 03 00 83 E8 0C 00 9C E8 2C C0 9D E5 04 00 A0 E1 08 C0 8D E5 30 C0 9D E5 0E 10 A0 E1 0C C0 8D E5 34 C0 9D E5 10 C0 8D E5 ?? ?? ?? ?? 04 00 A0 E1 1C D0 8D E2 10 80 BD E8 }
	condition:
		$1
}

rule file_49_305_3 {
	meta:
		name = "_ZNKSt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE6do_getES3_S3_RSt8ios_baseRSt12_Ios_IostateRl"
		size = 92
		refs = "004c _ZNKSt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE14_M_extract_intIlEES3_S3_S3_RSt8ios_baseRSt12_Ios_IostateRT_"
	strings:
		$1 = { 10 40 2D E9 1C D0 4D E2 14 C0 8D E2 0C 00 8C E8 24 30 8D E2 00 40 A0 E1 01 E0 A0 E1 03 00 93 E8 0D 30 A0 E1 03 00 83 E8 0C 00 9C E8 2C C0 9D E5 04 00 A0 E1 08 C0 8D E5 30 C0 9D E5 0E 10 A0 E1 0C C0 8D E5 34 C0 9D E5 10 C0 8D E5 ?? ?? ?? ?? 04 00 A0 E1 1C D0 8D E2 10 80 BD E8 }
	condition:
		$1
}

rule file_49_316_3 {
	meta:
		name = "_ZNKSt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE6do_getES3_S3_RSt8ios_baseRSt12_Ios_IostateRm"
		size = 92
		refs = "004c _ZNKSt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE14_M_extract_intImEES3_S3_S3_RSt8ios_baseRSt12_Ios_IostateRT_"
	strings:
		$1 = { 10 40 2D E9 1C D0 4D E2 14 C0 8D E2 0C 00 8C E8 24 30 8D E2 00 40 A0 E1 01 E0 A0 E1 03 00 93 E8 0D 30 A0 E1 03 00 83 E8 0C 00 9C E8 2C C0 9D E5 04 00 A0 E1 08 C0 8D E5 30 C0 9D E5 0E 10 A0 E1 0C C0 8D E5 34 C0 9D E5 10 C0 8D E5 ?? ?? ?? ?? 04 00 A0 E1 1C D0 8D E2 10 80 BD E8 }
	condition:
		$1
}

rule file_49_309_3 {
	meta:
		name = "_ZNKSt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE6do_getES3_S3_RSt8ios_baseRSt12_Ios_IostateRt"
		size = 92
		refs = "004c _ZNKSt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE14_M_extract_intItEES3_S3_S3_RSt8ios_baseRSt12_Ios_IostateRT_"
	strings:
		$1 = { 10 40 2D E9 1C D0 4D E2 14 C0 8D E2 0C 00 8C E8 24 30 8D E2 00 40 A0 E1 01 E0 A0 E1 03 00 93 E8 0D 30 A0 E1 03 00 83 E8 0C 00 9C E8 2C C0 9D E5 04 00 A0 E1 08 C0 8D E5 30 C0 9D E5 0E 10 A0 E1 0C C0 8D E5 34 C0 9D E5 10 C0 8D E5 ?? ?? ?? ?? 04 00 A0 E1 1C D0 8D E2 10 80 BD E8 }
	condition:
		$1
}

rule file_49_313_3 {
	meta:
		name = "_ZNKSt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE6do_getES3_S3_RSt8ios_baseRSt12_Ios_IostateRx"
		size = 92
		refs = "004c _ZNKSt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE14_M_extract_intIxEES3_S3_S3_RSt8ios_baseRSt12_Ios_IostateRT_"
	strings:
		$1 = { 10 40 2D E9 1C D0 4D E2 14 C0 8D E2 0C 00 8C E8 24 30 8D E2 00 40 A0 E1 01 E0 A0 E1 03 00 93 E8 0D 30 A0 E1 03 00 83 E8 0C 00 9C E8 2C C0 9D E5 04 00 A0 E1 08 C0 8D E5 30 C0 9D E5 0E 10 A0 E1 0C C0 8D E5 34 C0 9D E5 10 C0 8D E5 ?? ?? ?? ?? 04 00 A0 E1 1C D0 8D E2 10 80 BD E8 }
	condition:
		$1
}

rule file_49_311_3 {
	meta:
		name = "_ZNKSt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE6do_getES3_S3_RSt8ios_baseRSt12_Ios_IostateRy"
		size = 92
		refs = "004c _ZNKSt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE14_M_extract_intIyEES3_S3_S3_RSt8ios_baseRSt12_Ios_IostateRT_"
	strings:
		$1 = { 10 40 2D E9 1C D0 4D E2 14 C0 8D E2 0C 00 8C E8 24 30 8D E2 00 40 A0 E1 01 E0 A0 E1 03 00 93 E8 0D 30 A0 E1 03 00 83 E8 0C 00 9C E8 2C C0 9D E5 04 00 A0 E1 08 C0 8D E5 30 C0 9D E5 0E 10 A0 E1 0C C0 8D E5 34 C0 9D E5 10 C0 8D E5 ?? ?? ?? ?? 04 00 A0 E1 1C D0 8D E2 10 80 BD E8 }
	condition:
		$1
}

rule file_17_311_3 {
	meta:
		name = "_ZNKSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE6do_getES3_S3_RSt8ios_baseRSt12_Ios_IostateRj"
		size = 92
		refs = "004c _ZNKSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE14_M_extract_intIjEES3_S3_S3_RSt8ios_baseRSt12_Ios_IostateRT_"
	strings:
		$1 = { 10 40 2D E9 1C D0 4D E2 14 C0 8D E2 0C 00 8C E8 24 30 8D E2 00 40 A0 E1 01 E0 A0 E1 03 00 93 E8 0D 30 A0 E1 03 00 83 E8 0C 00 9C E8 2C C0 9D E5 04 00 A0 E1 08 C0 8D E5 30 C0 9D E5 0E 10 A0 E1 0C C0 8D E5 34 C0 9D E5 10 C0 8D E5 ?? ?? ?? ?? 04 00 A0 E1 1C D0 8D E2 10 80 BD E8 }
	condition:
		$1
}

rule file_17_308_3 {
	meta:
		name = "_ZNKSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE6do_getES3_S3_RSt8ios_baseRSt12_Ios_IostateRl"
		size = 92
		refs = "004c _ZNKSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE14_M_extract_intIlEES3_S3_S3_RSt8ios_baseRSt12_Ios_IostateRT_"
	strings:
		$1 = { 10 40 2D E9 1C D0 4D E2 14 C0 8D E2 0C 00 8C E8 24 30 8D E2 00 40 A0 E1 01 E0 A0 E1 03 00 93 E8 0D 30 A0 E1 03 00 83 E8 0C 00 9C E8 2C C0 9D E5 04 00 A0 E1 08 C0 8D E5 30 C0 9D E5 0E 10 A0 E1 0C C0 8D E5 34 C0 9D E5 10 C0 8D E5 ?? ?? ?? ?? 04 00 A0 E1 1C D0 8D E2 10 80 BD E8 }
	condition:
		$1
}

rule file_17_321_3 {
	meta:
		name = "_ZNKSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE6do_getES3_S3_RSt8ios_baseRSt12_Ios_IostateRm"
		size = 92
		refs = "004c _ZNKSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE14_M_extract_intImEES3_S3_S3_RSt8ios_baseRSt12_Ios_IostateRT_"
	strings:
		$1 = { 10 40 2D E9 1C D0 4D E2 14 C0 8D E2 0C 00 8C E8 24 30 8D E2 00 40 A0 E1 01 E0 A0 E1 03 00 93 E8 0D 30 A0 E1 03 00 83 E8 0C 00 9C E8 2C C0 9D E5 04 00 A0 E1 08 C0 8D E5 30 C0 9D E5 0E 10 A0 E1 0C C0 8D E5 34 C0 9D E5 10 C0 8D E5 ?? ?? ?? ?? 04 00 A0 E1 1C D0 8D E2 10 80 BD E8 }
	condition:
		$1
}

rule file_17_329_3 {
	meta:
		name = "_ZNKSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE6do_getES3_S3_RSt8ios_baseRSt12_Ios_IostateRt"
		size = 92
		refs = "004c _ZNKSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE14_M_extract_intItEES3_S3_S3_RSt8ios_baseRSt12_Ios_IostateRT_"
	strings:
		$1 = { 10 40 2D E9 1C D0 4D E2 14 C0 8D E2 0C 00 8C E8 24 30 8D E2 00 40 A0 E1 01 E0 A0 E1 03 00 93 E8 0D 30 A0 E1 03 00 83 E8 0C 00 9C E8 2C C0 9D E5 04 00 A0 E1 08 C0 8D E5 30 C0 9D E5 0E 10 A0 E1 0C C0 8D E5 34 C0 9D E5 10 C0 8D E5 ?? ?? ?? ?? 04 00 A0 E1 1C D0 8D E2 10 80 BD E8 }
	condition:
		$1
}

rule file_17_324_3 {
	meta:
		name = "_ZNKSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE6do_getES3_S3_RSt8ios_baseRSt12_Ios_IostateRy"
		size = 92
		refs = "004c _ZNKSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE14_M_extract_intIyEES3_S3_S3_RSt8ios_baseRSt12_Ios_IostateRT_"
	strings:
		$1 = { 10 40 2D E9 1C D0 4D E2 14 C0 8D E2 0C 00 8C E8 24 30 8D E2 00 40 A0 E1 01 E0 A0 E1 03 00 93 E8 0D 30 A0 E1 03 00 83 E8 0C 00 9C E8 2C C0 9D E5 04 00 A0 E1 08 C0 8D E5 30 C0 9D E5 0E 10 A0 E1 0C C0 8D E5 34 C0 9D E5 10 C0 8D E5 ?? ?? ?? ?? 04 00 A0 E1 1C D0 8D E2 10 80 BD E8 }
	condition:
		$1
}

rule file_17_307_3 {
	meta:
		name = "_ZNKSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE14_M_extract_intIlEES3_S3_S3_RSt8ios_baseRSt12_Ios_IostateRT_"
		size = 3484
		refs = "0040 _Unwind_SjLj_Register 0058 _ZNKSt11__use_cacheISt16__numpunct_cacheIwEEclERKSt6locale 017c __udivsi3 01f4 wmemchr 02a4 _ZNKSt19istreambuf_iteratorIwSt11char_traitsIwEE5equalERKS2_ 04c0 _Unwind_SjLj_Unregister 0590 _ZNSs7reserveEj 05dc _ZSt17__verify_groupingPKcjRKSs 094c _ZNSt19istreambuf_iteratorIwSt11char_traitsIwEEppEv 0964 _ZNKSt19istreambuf_iteratorIwSt11char_traitsIwEEdeEv 0cd8 _ZNSsD1Ev 0ce8 _Unwind_SjLj_Resume 0d1c _ZNSs4_Rep10_M_destroyERKSaIcE 0d54 _ZN9__gnu_cxx18__exchange_and_addEPVii 0d80 .text$_ZNKSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE14_M_extract_intIlEES3_S3_S3_RSt8ios_baseRSt12_Ios_IostateRT_ 0d84 __gxx_personality_sj0 0d88 .gcc_except_table 0d90 _ZNSs4_Rep20_S_empty_rep_storageE 0d98 _CRT_MT"
	strings:
		$1 = { 00 48 2D E9 04 B0 8D E2 80 D0 4D E2 18 10 4B E2 0C 00 81 E8 64 3D 9F E5 80 00 0B E5 28 30 0B E5 5C 3D 9F E5 04 00 4B E2 34 30 0B E5 54 3D 9F E5 2C 00 0B E5 4C 00 4B E2 30 30 0B E5 24 D0 0B E5 ?? ?? ?? ?? 0C 20 9B E5 00 30 E0 E3 08 00 4B E2 6C 10 82 E2 48 30 0B E5 ?? ?? ?? ?? 0C C0 9B E5 70 E0 80 E2 0C 30 9C E5 5C 00 0B E5 4A 30 03 E2 40 00 53 E3 08 00 A0 03 58 E0 0B E5 64 30 0B E5 6C 00 0B 05 04 00 00 0A 64 10 1B E5 08 00 51 E3 10 10 A0 03 0A 10 A0 13 6C 10 0B E5 18 00 1B E5 00 00 50 E3 01 20 A0 03 50 20 0B 05 05 00 00 0A D4 3C 9F E5 B4 21 5B E1 03 00 52 E1 00 30 A0 13 50 30 0B 15 83 02 00 0A 04 00 9B E5 00 00 50 E3 7B 02 00 0A B8 20 DB E1 AC 3C 9F E5 03 00 52 E1 FD 01 00 0A 00 30 A0 E3 50 00 1B E5 03 00 50 E1 00 30 A0 03 50 30 0B 05 84 30 0B 05 77 01 00 1A 5C E0 1B E5 00 C0 A0 E3 01 00 A0 E3 10 30 DE E5 60 C0 0B E5 78 00 0B E5 70 C0 0B E5 6C 10 1B E5 10 00 51 E3 16 20 A0 03 64 20 0B 05 07 00 00 0A 5C C0 1B E5 50 E0 1B E5 10 30 DC E5 54 E0 0B E5 54 00 1B E5 6C 10 1B E5 50 00 0B E5 64 10 0B E5 00 00 53 E3 34 3C 9F E5 10 30 0B E5 D0 01 00 1A 84 20 1B E5 6C 10 1B E5 00 00 52 E3 02 31 A0 13 02 31 E0 03 03 00 A0 E1 7C 30 0B E5 ?? ?? ?? ?? 5C C0 1B E5 58 E0 1B E5 A4 30 DC E5 08 E0 8E E2 01 00 53 E3 68 00 0B E5 74 E0 0B E5 5A 00 00 1A 78 00 1B E5 00 00 50 E3 70 02 00 1A 78 E0 1B E5 54 E0 0B E5 58 E0 0B E5 5C 00 1B E5 10 30 D0 E5 00 00 53 E3 03 00 00 0A B6 32 D0 E1 50 10 1B E5 01 00 53 E1 09 01 00 0A 5C 00 1B E5 50 10 1B E5 B4 32 D0 E1 01 00 53 E1 D4 00 00 0A 74 00 1B E5 64 20 1B E5 ?? ?? ?? ?? 00 00 50 E3 CF 00 00 0A 74 20 1B E5 68 C0 1B E5 00 30 62 E0 C3 30 A0 E1 54 E0 1B E5 0F 00 53 E3 06 30 43 C2 0E 00 5C E1 01 00 A0 33 58 00 0B 35 0E 00 00 3A 54 20 1B E5 6C 10 1B E5 7C C0 1B E5 91 02 02 E0 58 E0 1B E5 0C 10 63 E0 60 00 1B E5 02 00 51 E1 01 E0 8E 33 02 30 83 E0 FF 10 0E E2 01 00 80 E2 54 30 0B E5 58 10 0B E5 60 00 0B E5 18 00 1B E5 00 00 50 E3 07 00 00 0A 08 30 90 E5 0C 20 90 E5 02 00 53 E1 02 30 83 32 08 30 80 35 47 02 00 2A 00 20 E0 E3 B4 21 4B E1 02 30 A0 E3 18 00 4B E2 04 10 8B E2 48 30 0B E5 ?? ?? ?? ?? 00 00 50 E3 56 00 00 1A 18 00 1B E5 00 00 50 E3 CC CA 9F 05 50 C0 0B 05 BC FF FF 0A B4 E1 5B E1 BC 1A 9F E5 50 E0 0B E5 01 00 5E E1 B7 FF FF 1A 08 20 90 E5 0C 30 90 E5 03 00 52 E1 6B 02 00 2A B0 20 D2 E1 50 20 0B E5 50 30 1B E5 90 CA 9F E5 0C 00 53 E1 00 E0 A0 03 B4 31 4B 11 18 E0 0B 05 AA FF FF EA 78 10 1B E5 00 00 51 E3 15 02 00 1A 64 20 1B E5 54 10 0B E5 30 30 82 E2 03 38 A0 E1 23 38 A0 E1 74 30 0B E5 58 10 0B E5 64 30 1B E5 0A 00 53 E3 7C 00 00 9A 50 00 1B E5 30 30 40 E2 03 28 A0 E1 09 08 52 E3 04 00 00 9A 61 30 40 E2 03 38 A0 E1 05 08 53 E3 57 30 40 92 D6 00 00 8A 01 00 73 E3 73 00 00 0A 68 C0 1B E5 54 E0 1B E5 0E 00 5C E1 01 00 A0 33 58 00 0B 35 0E 00 00 3A 54 20 1B E5 6C 10 1B E5 7C C0 1B E5 91 02 02 E0 58 E0 1B E5 0C 10 63 E0 60 00 1B E5 02 00 51 E1 01 E0 8E 33 FF 10 0E E2 02 20 83 E0 01 00 80 E2 54 20 0B E5 58 10 0B E5 60 00 0B E5 18 00 1B E5 00 00 50 E3 07 00 00 0A 08 30 90 E5 0C 20 90 E5 02 00 53 E1 02 30 83 32 08 30 80 35 E9 01 00 2A 00 20 E0 E3 B4 21 4B E1 02 30 A0 E3 18 00 4B E2 04 10 8B E2 48 30 0B E5 ?? ?? ?? ?? 00 00 50 E3 30 00 00 0A 00 00 A0 E3 01 10 A0 E3 6C 00 0B E5 78 10 0B E5 10 30 1B E5 0C 20 13 E5 0C C0 43 E2 00 00 52 E3 50 C0 0B E5 4A 00 00 1A 60 20 1B E5 00 00 52 E3 06 00 00 1A 70 30 1B E5 00 00 53 E3 03 00 00 1A 50 C0 1B E5 00 30 9C E5 00 00 53 E3 02 00 00 0A 6C E0 1B E5 00 00 5E E3 87 00 00 0A 14 00 9B E5 00 30 A0 E3 10 10 9B E5 00 30 80 E5 04 30 A0 E3 00 30 81 E5 78 E0 1B E5 08 29 9F E5 00 00 5E E3 10 00 9B 15 50 10 1B E5 00 30 90 15 02 30 83 13 00 30 80 15 02 00 51 E1 80 20 1B E5 18 30 4B E2 03 00 93 E8 00 00 82 E5 B4 10 C2 E1 0B 02 00 1A 4C 00 4B E2 ?? ?? ?? ?? 80 00 1B E5 04 D0 4B E2 00 88 BD E8 18 00 1B E5 00 00 50 E3 AC C8 9F 05 50 C0 0B 05 93 FF FF 0A B4 E1 5B E1 9C 18 9F E5 50 E0 0B E5 01 00 5E E1 8E FF FF 1A 08 20 90 E5 0C 30 90 E5 03 00 52 E1 CC 01 00 2A B0 20 D2 E1 50 20 0B E5 50 30 1B E5 70 C8 9F E5 0C 00 53 E1 00 30 A0 03 B4 31 4B 11 18 30 0B 05 64 30 1B E5 0A 00 53 E3 82 FF FF 8A 50 C0 1B E5 2F 00 5C E3 86 01 00 8A 10 30 1B E5 00 20 A0 E3 6C 20 0B E5 0C 20 13 E5 0C C0 43 E2 00 00 52 E3 50 C0 0B E5 B4 FF FF 0A 04 10 9C E5 01 E0 82 E2 01 00 5E E1 64 E0 0B E5 02 00 00 8A 08 10 9C E5 00 00 51 E3 06 00 00 DA 02 30 A0 E3 10 00 4B E2 64 10 1B E5 48 30 0B E5 ?? ?? ?? ?? 10 30 1B E5 0C 20 13 E5 60 00 1B E5 02 00 C3 E7 04 20 4B E2 0C 00 32 E5 64 E0 1B E5 0C 10 40 E2 00 30 A0 E3 0E C0 81 E0 08 30 81 E5 0C E0 00 E5 0C 30 CC E5 5C 00 1B E5 02 30 A0 E3 0C 10 90 E5 08 00 90 E5 48 30 0B E5 ?? ?? ?? ?? 00 00 50 E3 10 10 9B 05 04 30 A0 03 00 30 81 05 10 30 1B E5 0C 30 43 E2 50 30 0B E5 8C FF FF EA 60 20 1B E5 00 00 52 E3 5D 01 00 0A 10 30 1B E5 0C 10 43 E2 0C 20 13 E5 04 00 91 E5 01 C0 82 E2 00 00 5C E1 50 C0 0B E5 02 00 00 8A 08 10 91 E5 00 00 51 E3 06 00 00 DA 02 E0 A0 E3 10 00 4B E2 50 10 1B E5 48 E0 0B E5 ?? ?? ?? ?? 10 30 1B E5 0C 20 13 E5 60 00 1B E5 00 E0 A0 E3 02 00 C3 E7 10 10 1B E5 50 C0 1B E5 00 20 A0 E3 0C 30 41 E2 60 20 0B E5 0C 20 83 E0 0C C0 01 E5 08 E0 83 E5 0C E0 C2 E5 F7 FE FF EA 58 00 1B E5 00 00 50 E3 89 00 00 0A 84 20 1B E5 10 00 9B E5 00 00 52 E3 14 C0 9B 15 14 E0 9B 05 02 31 A0 13 02 31 E0 03 00 30 8C 15 00 30 8E 05 04 30 A0 E3 00 30 80 E5 6E FF FF EA 50 20 1B E5 41 30 42 E2 03 38 A0 E1 05 08 53 E3 99 FF FF 8A 37 30 42 E2 21 FF FF EA 18 00 1B E5 00 00 50 E3 9C 16 9F 05 50 10 0B 05 04 00 00 0A B4 21 5B E1 8C 36 9F E5 50 20 0B E5 03 00 52 E1 07 01 00 0A 5C E0 1B E5 50 00 1B E5 B0 37 DE E1 00 00 53 E1 00 30 A0 13 01 30 A0 03 00 00 53 E3 84 30 0B E5 75 00 00 1A 58 10 1B E5 B2 30 D1 E1 00 00 53 E1 71 00 00 0A 5C 10 1B E5 50 20 1B E5 10 30 D1 E5 54 20 0B E5 64 E0 1B E5 00 C0 A0 E3 60 C0 0B E5 70 C0 0B E5 68 E0 0B E5 00 00 53 E3 04 00 00 0A 5C C0 1B E5 54 E0 1B E5 B6 22 DC E1 0E 00 52 E1 7C 01 00 0A 5C 00 1B E5 54 10 1B E5 B4 22 D0 E1 01 00 52 E1 77 01 00 0A 58 C0 1B E5 B8 20 DC E1 01 00 52 E1 9E 00 00 0A 70 20 1B E5 00 00 52 E3 6B 01 00 0A 58 C0 1B E5 54 E0 1B E5 B4 20 DC E1 0E 00 52 E1 02 00 00 0A B6 20 DC E1 0E 00 52 E1 63 01 00 1A 64 00 1B E5 00 00 50 E3 89 00 00 1A 68 10 1B E5 10 20 A0 E3 60 10 0B E5 70 10 0B E5 6C 20 0B E5 18 00 1B E5 00 00 50 E3 69 00 00 0A 08 30 90 E5 0C 20 90 E5 02 00 53 E1 02 30 83 32 08 30 80 35 ED 00 00 2A 18 00 1B E5 00 20 E0 E3 00 00 50 E3 B4 21 4B E1 5E 00 00 0A 08 30 90 E5 0C 20 90 E5 02 00 53 E1 B0 00 D3 31 3A 01 00 2A 4C E5 9F E5 0E 00 50 E1 B4 01 4B 11 00 00 A0 13 50 00 0B 15 04 00 9B E5 00 10 A0 03 01 20 A0 03 18 10 0B 05 50 20 0B 05 00 00 50 E3 52 00 00 0A B8 30 DB E1 18 C5 9F E5 0C 00 53 E1 3F 00 00 0A 50 C0 1B E5 00 30 A0 E3 0C 00 53 E1 4E 00 00 1A 54 E0 1B E5 5C 00 1B E5 01 10 A0 E3 50 E0 0B E5 10 30 D0 E5 78 10 0B E5 1D FE FF EA 02 30 A0 E3 10 00 4B E2 20 10 A0 E3 48 30 0B E5 ?? ?? ?? ?? 28 FE FF EA 84 10 1B E5 14 C0 9B E5 00 00 51 E3 54 20 1B 15 54 30 1B 05 00 30 62 12 00 30 8C E5 E8 FE FF EA 08 30 90 E5 0C 20 90 E5 02 00 53 E1 B0 00 D3 31 CB 00 00 2A 94 34 9F E5 03 00 50 E1 6F 00 00 0A B8 00 CB E1 F7 FD FF EA 5C 20 1B E5 10 30 D2 E5 00 00 53 E3 04 00 00 0A B6 C2 D2 E1 50 E0 1B E5 54 C0 0B E5 0E 00 5C E1 88 FF FF 0A 5C 00 1B E5 50 10 1B E5 B4 02 D0 E1 01 00 50 E1 54 00 0B E5 82 FF FF 0A 00 30 E0 E3 18 00 4B E2 48 30 0B E5 ?? ?? ?? ?? 04 10 8B E2 ?? ?? ?? ?? 00 00 50 E3 E7 FD FF 1A 18 00 4B E2 ?? ?? ?? ?? 5C 20 1B E5 54 00 0B E5 10 30 D2 E5 74 FF FF EA 08 30 90 E5 0C 20 90 E5 02 00 53 E1 B0 00 D3 31 95 00 00 2A F8 13 9F E5 01 00 50 E1 39 00 00 0A B8 00 CB E1 B5 FF FF EA 04 00 9B E5 01 30 A0 E3 00 00 50 E3 50 30 0B E5 AC FF FF 1A 01 30 A0 E3 50 C0 1B E5 0C 00 53 E1 B0 FF FF 0A 18 00 1B E5 00 00 50 E3 B8 23 9F 05 03 00 00 0A B4 21 5B E1 AC 33 9F E5 03 00 52 E1 2A 00 00 0A 70 10 1B E5 00 00 51 E3 48 00 00 0A 5C 10 1B E5 54 20 0B E5 10 30 D1 E5 57 FF FF EA 6C C0 1B E5 10 00 5C E3 2F 00 00 1A 00 00 A0 E3 60 00 0B E5 70 00 0B E5 73 FF FF EA 70 E0 1B E5 00 00 5E E3 02 00 00 0A 6C 00 1B E5 0A 00 50 E3 5D FF FF 1A 64 10 1B E5 00 00 51 E3 06 00 00 1A 68 20 1B E5 01 30 A0 E3 08 C0 A0 E3 60 20 0B E5 70 30 0B E5 6C C0 0B E5 63 FF FF EA 6C 00 1B E5 60 E0 1B E5 08 00 50 E3 01 E0 8E 12 00 E0 A0 03 01 10 A0 E3 60 E0 0B E5 70 10 0B E5 5A FF FF EA 00 20 A0 E3 04 20 8B E5 01 30 A0 E3 C9 FF FF EA 08 30 90 E5 0C 20 90 E5 02 00 53 E1 B0 20 D3 31 56 00 00 2A E0 E2 9F E5 0E 00 52 E1 00 00 A0 03 B4 21 4B 11 18 00 0B 05 C9 FF FF EA 00 30 A0 E3 04 30 8B E5 01 30 A0 E3 86 FD FF EA 00 E0 A0 E3 78 E0 0B E5 99 FD FF EA 08 30 90 E5 0C 20 90 E5 02 00 53 E1 B0 00 D3 31 63 00 00 2A 98 32 9F E5 03 00 50 E1 00 C0 A0 13 00 30 A0 03 01 E0 A0 03 B4 01 4B 11 50 C0 0B 15 18 30 0B 05 50 E0 0B 05 6C FD FF EA 50 20 0B E5 5C 20 1B E5 78 10 0B E5 10 30 D2 E5 7C FD FF EA 08 30 90 E5 0C 20 90 E5 02 00 53 E1 48 00 00 2A B0 30 D3 E1 50 30 0B E5 44 32 9F E5 50 C0 1B E5 03 00 5C E1 00 30 A0 03 B4 C1 4B 11 18 30 0B 05 EA FE FF EA 74 E0 1B E5 0E 00 5C E1 75 FE FF 2A 30 30 4C E2 FD FD FF EA 00 30 A0 E3 54 30 0B E5 58 30 0B E5 6C 30 0B E5 25 FE FF EA 01 30 A0 E3 6C 30 0B E5 22 FE FF EA 00 30 90 E5 02 10 A0 E3 28 30 93 E5 48 10 0B E5 0F E0 A0 E1 03 F0 A0 E1 0E FE FF EA 00 30 90 E5 02 10 A0 E3 28 30 93 E5 48 10 0B E5 0F E0 A0 E1 03 F0 A0 E1 B0 FD FF EA 00 30 90 E5 00 10 E0 E3 28 30 93 E5 48 10 0B E5 0F E0 A0 E1 03 F0 A0 E1 0A FF FF EA 00 30 90 E5 00 E0 E0 E3 24 30 93 E5 48 E0 0B E5 0F E0 A0 E1 03 F0 A0 E1 62 FF FF EA 00 30 90 E5 00 C0 E0 E3 24 30 93 E5 48 C0 0B E5 0F E0 A0 E1 03 F0 A0 E1 00 20 A0 E1 A0 FF FF EA 00 30 90 E5 00 20 E0 E3 24 30 93 E5 48 20 0B E5 0F E0 A0 E1 03 F0 A0 E1 2C FF FF EA 00 30 90 E5 02 20 A0 E3 24 30 93 E5 48 20 0B E5 0F E0 A0 E1 03 F0 A0 E1 50 00 0B E5 2C FE FF EA 00 30 90 E5 00 20 E0 E3 24 30 93 E5 48 20 0B E5 0F E0 A0 E1 03 F0 A0 E1 50 00 0B E5 B0 FF FF EA 00 30 90 E5 00 20 E0 E3 24 30 93 E5 48 20 0B E5 0F E0 A0 E1 03 F0 A0 E1 94 FF FF EA 00 30 90 E5 02 20 A0 E3 24 30 93 E5 48 20 0B E5 0F E0 A0 E1 03 F0 A0 E1 50 00 0B E5 8D FD FF EA 04 B0 8B E2 48 30 1B E5 44 E0 1B E5 01 00 53 E3 50 E0 0B E5 00 30 A0 03 10 00 4B 02 48 30 0B 05 ?? ?? ?? ?? 00 30 E0 E3 50 00 1B E5 48 30 0B E5 ?? ?? ?? ?? A4 30 9F E5 00 30 93 E5 00 00 53 E3 10 00 00 1A 50 C0 1B E5 08 00 9C E5 01 30 40 E2 08 30 8C E5 00 00 50 E3 E9 FD FF CA 50 00 1B E5 0C 10 4B E2 ?? ?? ?? ?? E5 FD FF EA 00 30 90 E5 00 C0 E0 E3 24 30 93 E5 48 C0 0B E5 0F E0 A0 E1 03 F0 A0 E1 BD FE FF EA 01 30 A0 E3 48 30 0B E5 50 30 1B E5 00 10 E0 E3 08 00 83 E2 ?? ?? ?? ?? EB FF FF EA 54 E0 1B E5 00 00 A0 E3 50 E0 0B E5 78 00 0B E5 EA FC FF EA 00 C0 A0 E3 50 20 0B E5 78 C0 0B E5 E6 FC FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FF FF 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_309_3 {
	meta:
		name = "_ZNKSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE6do_getES3_S3_RSt8ios_baseRSt12_Ios_IostateRb"
		size = 1364
		refs = "0084 _ZNKSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE14_M_extract_intIlEES3_S3_S3_RSt8ios_baseRSt12_Ios_IostateRT_ 0134 _ZNKSt11__use_cacheISt16__numpunct_cacheIwEEclERKSt6locale"
	strings:
		$1 = { F0 4F 2D E9 40 D0 4D E2 28 C0 8D E2 0C 00 8C E8 6C E0 9D E5 20 00 8D E5 0C 60 9E E5 B8 06 DD E1 01 60 16 E2 14 C0 8D E5 01 50 A0 E1 24 00 8D E5 64 C0 9D E5 3B 00 00 1A 60 30 8D E2 04 C0 A3 E5 B8 06 CD E1 0D 20 A0 E1 03 00 93 E8 03 00 82 E8 14 00 9D E5 30 40 8D E2 0C 00 90 E8 08 E0 8D E5 38 E0 8D E2 10 E0 8D E5 70 E0 9D E5 05 10 A0 E1 04 00 A0 E1 00 50 E0 E3 18 C0 8D E5 38 50 8D E5 0C E0 8D E5 ?? ?? ?? ?? 03 00 94 E8 38 30 9D E5 BC 12 CD E1 01 00 53 E3 28 00 8D E5 18 C0 9D E5 DC 00 00 9A 74 20 9D E5 01 30 A0 E3 70 E0 9D E5 00 10 50 E2 00 30 C2 E5 04 20 A0 E3 00 20 8E E5 03 60 A0 01 03 00 00 0A BC 22 DD E1 7C 34 9F E5 03 00 52 E1 DC 00 00 0A 00 00 5C E3 D8 00 00 0A 68 34 9F E5 24 00 9D E5 03 00 50 E1 CC 00 00 0A 00 30 A0 E3 03 00 56 E1 70 10 9D 05 00 30 91 05 02 30 83 03 00 30 81 05 20 30 9D E5 14 20 9D E5 03 00 92 E8 00 00 83 E5 B4 10 C3 E1 03 00 A0 E1 40 D0 8D E2 F0 8F BD E8 6C 10 8E E2 3C 00 8D E2 18 C0 8D E5 ?? ?? ?? ?? 20 40 90 E5 00 70 A0 E3 18 90 90 E5 07 00 54 E1 00 40 A0 13 01 40 A0 03 01 A0 A0 E3 07 00 59 E1 00 90 A0 13 01 90 A0 03 00 00 54 E3 00 B0 A0 E1 07 80 A0 E1 0A 50 A0 E1 D8 63 9F E5 24 20 9D E5 18 C0 9D E5 47 00 00 1A 28 30 9D E5 00 00 53 E3 A0 00 00 0A BC 12 DD E1 06 00 51 E1 69 00 00 0A 00 30 A0 E3 00 00 5C E3 01 10 A0 03 02 00 00 0A 06 00 52 E1 56 00 00 0A 00 10 A0 E3 03 00 51 E1 5E 00 00 0A 28 30 9D E5 00 00 53 E3 84 03 9F 05 02 00 00 0A BC 02 DD E1 06 00 50 E1 65 00 00 0A 00 00 54 E3 04 00 00 1A 1C 30 9B E5 B7 50 93 E1 00 00 55 E1 00 50 A0 13 01 50 A0 03 00 00 55 E3 59 00 00 1A 00 00 59 E3 64 00 00 1A 14 30 9B E5 B7 A0 93 E1 00 00 5A E1 00 A0 A0 13 01 A0 A0 03 00 00 5A E3 03 00 00 1A 00 00 54 E3 1F 00 00 1A 00 00 55 E3 59 00 00 0A 28 30 9D E5 01 80 88 E2 00 00 53 E3 07 00 00 0A 08 10 93 E5 0C 00 93 E5 00 00 51 E1 02 10 81 32 08 10 83 35 8D 00 00 2A 00 00 E0 E3 BC 02 CD E1 00 00 55 E3 01 40 A0 03 03 00 00 0A 20 40 9B E5 04 00 58 E1 00 40 A0 33 01 40 A0 23 00 00 5A E3 1E 00 00 0A 18 30 9B E5 03 00 58 E1 00 90 A0 33 1A 00 00 2A 02 70 87 E2 00 00 54 E3 B7 FF FF 0A 00 00 59 E3 B5 FF FF 0A 00 30 A0 E3 00 00 55 E3 39 00 00 0A 20 20 9B E5 00 10 58 E2 01 10 A0 13 08 00 52 E1 00 10 A0 13 00 00 51 E3 32 00 00 0A 74 C0 9D E5 00 10 A0 E3 00 00 5A E3 00 10 CC E5 02 00 00 0A 18 10 9B E5 01 00 52 E1 63 00 00 0A 70 00 9D E5 83 30 A0 E1 00 30 80 E5 81 FF FF EA 01 90 A0 E3 02 70 87 E2 E2 FF FF EA 08 20 9C E5 0C 10 9C E5 01 00 52 E1 B0 20 D2 31 64 00 00 2A 06 00 52 E1 01 10 A0 03 00 C0 A0 03 9F FF FF 1A 03 00 51 E1 A0 FF FF 1A 01 30 A0 E3 DA FF FF EA 08 00 93 E5 0C 10 93 E5 01 00 50 E1 B0 00 D0 31 6A 00 00 2A 06 00 50 E1 2A 00 00 0A BC 02 CD E1 8C FF FF EA 00 00 59 E3 AA FF FF 1A A4 FF FF EA 08 00 93 E5 0C 10 93 E5 01 00 50 E1 B0 00 D0 31 55 00 00 2A 06 00 50 E1 00 E0 A0 03 BC 02 CD 11 28 E0 8D 05 8F FF FF EA 00 30 A0 E3 00 00 5A E3 0E 00 00 0A 18 20 9B E5 00 10 58 E2 01 10 A0 13 08 00 52 E1 00 10 A0 13 00 00 51 E3 01 80 A0 E1 06 00 00 0A 74 C0 9D E5 70 E0 9D E5 83 30 A0 E1 01 20 A0 E3 00 20 CC E5 00 30 8E E5 49 FF FF EA 74 00 9D E5 00 00 53 E3 70 10 9D E5 00 30 A0 E3 00 30 C0 E5 04 30 A0 E3 00 30 81 E5 06 30 A0 13 00 30 81 15 3F FF FF EA 00 30 A0 E3 28 30 8D E5 01 30 A0 E3 60 FF FF EA 74 00 9D E5 00 30 C0 E5 38 FF FF EA 08 30 9C E5 0C 20 9C E5 02 00 53 E1 B0 00 D3 31 3A 00 00 2A 10 31 9F E5 03 00 50 E1 2A FF FF 1A 01 30 A0 E3 29 FF FF EA 08 30 91 E5 0C 20 91 E5 02 00 53 E1 B0 00 D3 31 35 00 00 2A E8 30 9F E5 03 00 50 E1 00 30 A0 03 BC 02 CD 11 00 60 A0 13 28 30 8D 05 01 60 A0 03 15 FF FF EA 70 E0 9D E5 04 30 A0 E3 00 30 8E E5 1D FF FF EA 03 00 A0 E1 1C 20 8D E5 18 C0 8D E5 00 30 93 E5 0F E0 A0 E1 28 F0 93 E5 18 C0 9D E5 1C 20 9D E5 68 FF FF EA 00 20 9C E5 0C 00 A0 E1 1C 30 8D E5 18 C0 8D E5 0F E0 A0 E1 24 F0 92 E5 18 C0 9D E5 00 20 A0 E1 1C 30 9D E5 90 FF FF EA 03 00 A0 E1 1C 20 8D E5 18 C0 8D E5 00 30 93 E5 0F E0 A0 E1 24 F0 93 E5 18 C0 9D E5 1C 20 9D E5 A0 FF FF EA 03 00 A0 E1 1C 20 8D E5 18 C0 8D E5 00 30 93 E5 0F E0 A0 E1 24 F0 93 E5 18 C0 9D E5 1C 20 9D E5 8B FF FF EA 0C 00 A0 E1 00 30 9C E5 0F E0 A0 E1 24 F0 93 E5 BF FF FF EA 18 C0 8D E5 00 30 91 E5 0F E0 A0 E1 24 F0 93 E5 18 C0 9D E5 C3 FF FF EA FF FF 00 00 }
	condition:
		$1
}

rule file_17_310_3 {
	meta:
		name = "_ZNKSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE14_M_extract_intIjEES3_S3_S3_RSt8ios_baseRSt12_Ios_IostateRT_"
		size = 3588
		refs = "0040 _Unwind_SjLj_Register 0058 _ZNKSt11__use_cacheISt16__numpunct_cacheIwEEclERKSt6locale 0158 __udivsi3 01d0 wmemchr 027c _ZNKSt19istreambuf_iteratorIwSt11char_traitsIwEE5equalERKS2_ 0494 _Unwind_SjLj_Unregister 0564 _ZNSs7reserveEj 05b0 _ZSt17__verify_groupingPKcjRKSs 0a48 _ZNSt19istreambuf_iteratorIwSt11char_traitsIwEEppEv 0abc _ZNKSt19istreambuf_iteratorIwSt11char_traitsIwEEdeEv 0d44 _ZNSsD1Ev 0d54 _Unwind_SjLj_Resume 0da8 _ZNSs4_Rep10_M_destroyERKSaIcE 0de0 _ZN9__gnu_cxx18__exchange_and_addEPVii 0de8 .text$_ZNKSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE14_M_extract_intIjEES3_S3_S3_RSt8ios_baseRSt12_Ios_IostateRT_ 0dec __gxx_personality_sj0 0df0 .gcc_except_table 0df8 _ZNSs4_Rep20_S_empty_rep_storageE 0e00 _CRT_MT"
	strings:
		$1 = { 00 48 2D E9 04 B0 8D E2 78 D0 4D E2 18 10 4B E2 0C 00 81 E8 CC 3D 9F E5 7C 00 0B E5 28 30 0B E5 C4 3D 9F E5 04 00 4B E2 34 30 0B E5 BC 3D 9F E5 2C 00 0B E5 4C 00 4B E2 30 30 0B E5 24 D0 0B E5 ?? ?? ?? ?? 0C 20 9B E5 00 30 E0 E3 08 00 4B E2 6C 10 82 E2 48 30 0B E5 ?? ?? ?? ?? 0C C0 9B E5 70 E0 80 E2 0C 30 9C E5 58 00 0B E5 4A 30 03 E2 40 00 53 E3 08 00 A0 03 54 E0 0B E5 64 30 0B E5 6C 00 0B 05 04 00 00 0A 64 10 1B E5 08 00 51 E3 10 10 A0 03 0A 10 A0 13 6C 10 0B E5 18 00 1B E5 00 00 50 E3 01 20 A0 03 50 20 0B 05 05 00 00 0A 3C 3D 9F E5 B4 21 5B E1 03 00 52 E1 00 30 A0 13 50 30 0B 15 44 02 00 0A 04 00 9B E5 00 00 50 E3 3C 02 00 0A B8 20 DB E1 14 3D 9F E5 03 00 52 E1 2D 02 00 0A 00 30 A0 E3 50 00 1B E5 00 00 53 E1 00 20 A0 03 50 20 0B 05 68 01 00 1A 58 C0 1B E5 00 30 A0 E3 60 30 0B E5 01 E0 A0 E3 00 00 A0 E3 10 30 DC E5 78 E0 0B E5 70 00 0B E5 6C C0 1B E5 10 00 5C E3 16 E0 A0 03 64 E0 0B 05 03 00 00 0A 58 00 1B E5 10 30 D0 E5 6C 10 1B E5 64 10 0B E5 00 00 53 E3 AC 3C 9F E5 10 30 0B E5 08 02 00 1A 00 00 E0 E3 6C 10 1B E5 ?? ?? ?? ?? 58 20 1B E5 54 C0 1B E5 A4 30 D2 E5 08 C0 8C E2 01 00 53 E3 68 00 0B E5 74 C0 0B E5 59 00 00 1A 78 E0 1B E5 00 00 5E E3 6A 02 00 1A 78 E0 1B E5 54 E0 0B E5 5C E0 0B E5 58 00 1B E5 10 30 D0 E5 00 00 53 E3 03 00 00 0A B6 32 D0 E1 50 10 1B E5 01 00 53 E1 07 01 00 0A 58 00 1B E5 50 10 1B E5 B4 32 D0 E1 01 00 53 E1 D2 00 00 0A 74 00 1B E5 64 20 1B E5 ?? ?? ?? ?? 00 00 50 E3 CD 00 00 0A 74 20 1B E5 68 C0 1B E5 00 30 62 E0 C3 30 A0 E1 54 E0 1B E5 0F 00 53 E3 06 30 43 C2 0E 00 5C E1 01 00 A0 33 5C 00 0B 35 0D 00 00 3A 54 20 1B E5 6C 10 1B E5 5C C0 1B E5 91 02 02 E0 60 E0 1B E5 03 10 E0 E1 02 00 51 E1 01 C0 8C 33 02 30 83 E0 FF 10 0C E2 01 E0 8E E2 54 30 0B E5 5C 10 0B E5 60 E0 0B E5 18 00 1B E5 00 00 50 E3 07 00 00 0A 08 30 90 E5 0C 20 90 E5 02 00 53 E1 02 30 83 32 08 30 80 35 67 02 00 2A 00 20 E0 E3 B4 21 4B E1 02 30 A0 E3 18 00 4B E2 04 10 8B E2 48 30 0B E5 ?? ?? ?? ?? 00 00 50 E3 55 00 00 1A 18 00 1B E5 00 00 50 E3 5C CB 9F 05 50 C0 0B 05 BD FF FF 0A B4 E1 5B E1 4C 1B 9F E5 50 E0 0B E5 01 00 5E E1 B8 FF FF 1A 08 20 90 E5 0C 30 90 E5 03 00 52 E1 90 02 00 2A B0 20 D2 E1 50 20 0B E5 50 30 1B E5 20 CB 9F E5 0C 00 53 E1 00 E0 A0 03 B4 31 4B 11 18 E0 0B 05 AB FF FF EA 78 00 1B E5 00 00 50 E3 10 02 00 1A 64 10 1B E5 54 00 0B E5 30 30 81 E2 03 38 A0 E1 23 38 A0 E1 74 30 0B E5 5C 00 0B E5 64 20 1B E5 0A 00 52 E3 7B 00 00 9A 50 E0 1B E5 30 30 4E E2 03 28 A0 E1 09 08 52 E3 04 00 00 9A 61 30 4E E2 03 38 A0 E1 05 08 53 E3 57 30 4E 92 D0 00 00 8A 01 00 73 E3 72 00 00 0A 68 20 1B E5 54 C0 1B E5 0C 00 52 E1 01 E0 A0 33 5C E0 0B 35 0D 00 00 3A 54 20 1B E5 6C 00 1B E5 5C C0 1B E5 90 02 02 E0 03 10 E0 E1 60 E0 1B E5 02 00 51 E1 01 C0 8C 33 FF 10 0C E2 02 20 83 E0 01 E0 8E E2 54 20 0B E5 5C 10 0B E5 60 E0 0B E5 18 00 1B E5 00 00 50 E3 07 00 00 0A 08 30 90 E5 0C 20 90 E5 02 00 53 E1 02 30 83 32 08 30 80 35 03 02 00 2A 00 20 E0 E3 B4 21 4B E1 02 30 A0 E3 18 00 4B E2 04 10 8B E2 48 30 0B E5 ?? ?? ?? ?? 00 00 50 E3 30 00 00 0A 00 00 A0 E3 01 10 A0 E3 6C 00 0B E5 78 10 0B E5 10 30 1B E5 0C 20 13 E5 0C C0 43 E2 00 00 52 E3 50 C0 0B E5 4A 00 00 1A 60 20 1B E5 00 00 52 E3 06 00 00 1A 70 30 1B E5 00 00 53 E3 03 00 00 1A 50 C0 1B E5 00 30 9C E5 00 00 53 E3 02 00 00 0A 6C E0 1B E5 00 00 5E E3 87 00 00 0A 14 00 9B E5 00 30 A0 E3 10 10 9B E5 00 30 80 E5 04 30 A0 E3 00 30 81 E5 78 10 1B E5 50 C0 1B E5 00 00 51 E3 10 20 9B 15 7C E0 1B E5 00 30 92 15 02 30 83 13 00 30 82 15 80 29 9F E5 18 30 4B E2 02 00 5C E1 03 00 93 E8 00 00 8E E5 B4 10 CE E1 39 02 00 1A 4C 00 4B E2 ?? ?? ?? ?? 7C 00 1B E5 04 D0 4B E2 00 88 BD E8 18 00 1B E5 00 00 50 E3 40 C9 9F 05 50 C0 0B 05 94 FF FF 0A B4 E1 5B E1 30 19 9F E5 50 E0 0B E5 01 00 5E E1 8F FF FF 1A 08 20 90 E5 0C 30 90 E5 03 00 52 E1 34 02 00 2A B0 20 D2 E1 50 20 0B E5 50 30 1B E5 04 C9 9F E5 64 20 1B E5 0C 00 53 E1 00 30 A0 03 B4 31 4B 11 18 30 0B 05 0A 00 52 E3 83 FF FF 8A 50 30 1B E5 2F 00 53 E3 82 01 00 8A 10 30 1B E5 00 20 A0 E3 6C 20 0B E5 0C 20 13 E5 0C C0 43 E2 00 00 52 E3 50 C0 0B E5 B4 FF FF 0A 04 10 9C E5 01 E0 82 E2 01 00 5E E1 64 E0 0B E5 02 00 00 8A 08 10 9C E5 00 00 51 E3 06 00 00 DA 02 30 A0 E3 10 00 4B E2 64 10 1B E5 48 30 0B E5 ?? ?? ?? ?? 10 30 1B E5 0C 20 13 E5 60 00 1B E5 02 00 C3 E7 04 20 4B E2 0C 00 32 E5 64 E0 1B E5 0C 10 40 E2 00 30 A0 E3 0E C0 81 E0 08 30 81 E5 0C E0 00 E5 0C 30 CC E5 58 00 1B E5 02 30 A0 E3 0C 10 90 E5 08 00 90 E5 48 30 0B E5 ?? ?? ?? ?? 00 00 50 E3 10 10 9B 05 04 30 A0 03 00 30 81 05 10 30 1B E5 0C 30 43 E2 50 30 0B E5 8C FF FF EA 60 20 1B E5 00 00 52 E3 66 01 00 0A 10 30 1B E5 0C 10 43 E2 0C 20 13 E5 04 00 91 E5 01 C0 82 E2 00 00 5C E1 50 C0 0B E5 02 00 00 8A 08 10 91 E5 00 00 51 E3 06 00 00 DA 02 E0 A0 E3 10 00 4B E2 50 10 1B E5 48 E0 0B E5 ?? ?? ?? ?? 10 30 1B E5 0C 20 13 E5 60 00 1B E5 00 E0 A0 E3 02 00 C3 E7 10 10 1B E5 50 C0 1B E5 00 20 A0 E3 0C 30 41 E2 60 20 0B E5 0C 20 83 E0 0C C0 01 E5 08 E0 83 E5 0C E0 C2 E5 F8 FE FF EA 5C 30 1B E5 00 00 53 E3 C8 00 00 0A 14 20 9B E5 00 30 E0 E3 10 C0 9B E5 00 30 82 E5 04 30 A0 E3 00 30 8C E5 73 FF FF EA 50 10 1B E5 41 30 41 E2 03 38 A0 E1 05 08 53 E3 9E FF FF 8A 37 30 41 E2 27 FF FF EA 18 00 1B E5 00 00 50 E3 44 27 9F 05 03 00 00 0A B4 21 5B E1 38 37 9F E5 03 00 52 E1 08 01 00 0A 54 10 1B E5 B2 10 D1 E1 02 00 51 E1 50 10 0B E5 D0 00 00 0A 58 C0 1B E5 50 20 0B E5 10 30 DC E5 64 00 1B E5 00 E0 A0 E3 60 E0 0B E5 70 E0 0B E5 68 00 0B E5 00 00 53 E3 04 00 00 0A 58 C0 1B E5 50 E0 1B E5 B6 22 DC E1 0E 00 52 E1 75 01 00 0A 58 00 1B E5 50 10 1B E5 B4 22 D0 E1 01 00 52 E1 70 01 00 0A 54 C0 1B E5 B8 20 DC E1 01 00 52 E1 67 00 00 0A 70 20 1B E5 00 00 52 E3 6D 01 00 0A 54 C0 1B E5 50 E0 1B E5 B4 20 DC E1 0E 00 52 E1 02 00 00 0A B6 20 DC E1 0E 00 52 E1 65 01 00 1A 64 00 1B E5 00 00 50 E3 52 00 00 1A 68 10 1B E5 10 20 A0 E3 60 10 0B E5 70 10 0B E5 6C 20 0B E5 18 00 1B E5 00 00 50 E3 32 00 00 0A 08 30 90 E5 0C 20 90 E5 02 00 53 E1 02 30 83 32 08 30 80 35 10 01 00 2A 18 00 1B E5 00 20 E0 E3 00 00 50 E3 B4 21 4B E1 27 00 00 0A 08 30 90 E5 0C 20 90 E5 02 00 53 E1 B0 00 D3 31 1B 01 00 2A 20 E6 9F E5 0E 00 50 E1 B4 01 4B 11 00 00 A0 13 5C 00 0B 15 04 00 9B E5 00 10 A0 03 01 20 A0 03 18 10 0B 05 5C 20 0B 05 00 00 50 E3 1B 00 00 0A B8 30 DB E1 EC C5 9F E5 0C 00 53 E1 08 00 00 0A 5C C0 1B E5 00 30 A0 E3 03 00 5C E1 17 00 00 1A 58 E0 1B E5 01 00 A0 E3 10 30 DE E5 78 00 0B E5 3A FE FF EA 08 30 90 E5 0C 20 90 E5 02 00 53 E1 B0 00 D3 31 F6 00 00 2A A8 15 9F E5 01 00 50 E1 39 00 00 0A B8 00 CB E1 EC FF FF EA 04 00 9B E5 01 30 A0 E3 00 00 50 E3 5C 30 0B E5 E3 FF FF 1A 01 30 A0 E3 5C C0 1B E5 03 00 5C E1 E7 FF FF 0A 18 00 1B E5 00 00 50 E3 68 25 9F 05 03 00 00 0A B4 21 5B E1 5C 15 9F E5 01 00 52 E1 2A 00 00 0A 70 E0 1B E5 00 00 5E E3 89 00 00 0A 58 10 1B E5 50 20 0B E5 10 30 D1 E5 8E FF FF EA 6C C0 1B E5 10 00 5C E3 42 00 00 1A 00 00 A0 E3 60 00 0B E5 70 00 0B E5 AA FF FF EA 70 E0 1B E5 00 00 5E E3 02 00 00 0A 6C 00 1B E5 0A 00 50 E3 94 FF FF 1A 64 10 1B E5 00 00 51 E3 06 00 00 1A 68 20 1B E5 01 30 A0 E3 08 C0 A0 E3 60 20 0B E5 70 30 0B E5 6C C0 0B E5 9A FF FF EA 6C 00 1B E5 60 E0 1B E5 08 00 50 E3 01 E0 8E 12 00 E0 A0 03 01 10 A0 E3 60 E0 0B E5 70 10 0B E5 91 FF FF EA 00 20 A0 E3 04 20 8B E5 01 30 A0 E3 C9 FF FF EA 08 30 90 E5 0C 20 90 E5 02 00 53 E1 B0 20 D3 31 FE 00 00 2A 90 34 9F E5 03 00 52 E1 00 C0 A0 03 B4 21 4B 11 18 C0 0B 05 C9 FF FF EA 02 30 A0 E3 10 00 4B E2 20 10 A0 E3 48 30 0B E5 ?? ?? ?? ?? F0 FD FF EA 54 E0 1B E5 14 00 9B E5 00 E0 80 E5 AD FE FF EA 08 30 90 E5 0C 20 90 E5 02 00 53 E1 B0 00 D3 31 C6 00 00 2A 3C 34 9F E5 03 00 50 E1 B8 00 CB 11 C8 FD FF 1A 00 30 A0 E3 04 30 8B E5 01 30 A0 E3 C5 FD FF EA 00 E0 A0 E3 78 E0 0B E5 D6 FD FF EA 08 30 90 E5 0C 20 90 E5 02 00 53 E1 B0 00 D3 31 99 00 00 2A FC 33 9F E5 03 00 50 E1 00 C0 A0 13 00 30 A0 03 01 E0 A0 03 B4 01 4B 11 50 C0 0B 15 18 30 0B 05 50 E0 0B 05 AB FD FF EA 58 C0 1B E5 10 30 DC E5 00 00 53 E3 39 00 00 1A 58 E0 1B E5 50 00 1B E5 B4 22 DE E1 00 00 52 E1 28 FF FF 0A 00 10 E0 E3 18 00 4B E2 48 10 0B E5 ?? ?? ?? ?? 60 00 0B E5 00 00 90 E5 00 00 50 E3 01 20 A0 03 60 20 0B 05 06 00 00 0A 60 30 1B E5 B4 20 D3 E1 80 33 9F E5 03 00 52 E1 00 C0 A0 13 60 C0 0B 15 41 00 00 0A 04 00 9B E5 00 00 50 E3 01 30 A0 03 04 00 00 0A B8 20 DB E1 58 33 9F E5 03 00 52 E1 29 00 00 0A 00 30 A0 E3 60 00 1B E5 00 00 53 E1 92 FD FF 0A 00 30 E0 E3 18 00 4B E2 48 30 0B E5 ?? ?? ?? ?? 58 10 1B E5 50 00 0B E5 10 30 D1 E5 03 FF FF EA 58 00 1B E5 50 20 0B E5 10 30 D0 E5 78 E0 0B E5 8D FD FF EA 08 30 90 E5 0C 20 90 E5 02 00 53 E1 B0 20 D3 31 5E 00 00 2A F4 32 9F E5 03 00 52 E1 00 30 A0 03 B4 21 4B 11 18 30 0B 05 EB FE FF EA B6 12 DC E1 02 00 51 E1 C2 FF FF 1A EF FE FF EA 74 C0 1B E5 03 00 5C E1 79 FE FF 9A 30 30 43 E2 02 FE FF EA 00 30 A0 E3 54 30 0B E5 5C 30 0B E5 6C 30 0B E5 29 FE FF EA 08 30 90 E5 0C 20 90 E5 02 00 53 E1 B0 00 D3 31 4D 00 00 2A 90 32 9F E5 03 00 50 E1 00 30 A0 03 04 30 8B 05 01 30 83 02 CB FF FF 0A B8 00 CB E1 C8 FF FF EA 01 30 A0 E3 6C 30 0B E5 19 FE FF EA 08 30 90 E5 0C 20 90 E5 02 00 53 E1 B0 00 D3 31 44 00 00 2A 50 32 9F E5 03 00 50 E1 60 10 1B 15 60 C0 1B 05 00 20 A0 13 00 30 A0 03 01 E0 A0 03 B4 00 C1 11 60 20 0B 15 00 30 8C 05 60 E0 0B 05 AC FF FF EA 00 30 90 E5 02 10 A0 E3 28 30 93 E5 48 10 0B E5 0F E0 A0 E1 03 F0 A0 E1 F4 FD FF EA 00 30 90 E5 00 10 E0 E3 28 30 93 E5 48 10 0B E5 0F E0 A0 E1 03 F0 A0 E1 E7 FE FF EA 00 30 90 E5 02 10 A0 E3 28 30 93 E5 48 10 0B E5 0F E0 A0 E1 03 F0 A0 E1 90 FD FF EA 00 30 90 E5 00 E0 E0 E3 24 30 93 E5 48 E0 0B E5 0F E0 A0 E1 03 F0 A0 E1 01 FF FF EA 00 30 90 E5 00 C0 E0 E3 24 30 93 E5 48 C0 0B E5 0F E0 A0 E1 03 F0 A0 E1 DC FE FF EA 00 30 90 E5 00 20 E0 E3 24 30 93 E5 48 20 0B E5 0F E0 A0 E1 03 F0 A0 E1 5E FF FF EA 00 30 90 E5 00 20 E0 E3 24 30 93 E5 48 20 0B E5 0F E0 A0 E1 03 F0 A0 E1 00 20 A0 E1 98 FF FF EA 00 30 90 E5 00 20 E0 E3 24 30 93 E5 48 20 0B E5 0F E0 A0 E1 03 F0 A0 E1 AA FF FF EA 00 30 90 E5 00 E0 E0 E3 24 30 93 E5 48 E0 0B E5 0F E0 A0 E1 03 F0 A0 E1 B3 FF FF EA 00 30 90 E5 00 20 E0 E3 24 30 93 E5 48 20 0B E5 0F E0 A0 E1 03 F0 A0 E1 31 FF FF EA 00 10 A0 E3 50 20 0B E5 78 10 0B E5 08 FD FF EA 00 20 A0 E3 78 20 0B E5 05 FD FF EA 00 30 90 E5 02 20 A0 E3 24 30 93 E5 48 20 0B E5 0F E0 A0 E1 03 F0 A0 E1 50 00 0B E5 68 FD FF EA 04 B0 8B E2 48 30 1B E5 44 20 1B E5 01 00 53 E3 50 20 0B E5 00 30 A0 03 10 00 4B 02 48 30 0B 05 ?? ?? ?? ?? 00 30 E0 E3 50 00 1B E5 48 30 0B E5 ?? ?? ?? ?? 00 30 90 E5 00 20 E0 E3 24 30 93 E5 48 20 0B E5 0F E0 A0 E1 03 F0 A0 E1 00 20 A0 E1 F8 FE FF EA 80 30 9F E5 00 30 93 E5 00 00 53 E3 11 00 00 1A 50 10 1B E5 08 00 91 E5 01 30 40 E2 08 30 81 E5 00 00 50 E3 BB FD FF CA 50 00 1B E5 0C 10 4B E2 ?? ?? ?? ?? B7 FD FF EA 00 30 90 E5 02 20 A0 E3 24 30 93 E5 48 20 0B E5 0F E0 A0 E1 03 F0 A0 E1 50 00 0B E5 C4 FD FF EA 01 30 A0 E3 08 00 8C E2 00 10 E0 E3 48 30 0B E5 ?? ?? ?? ?? EB FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FF FF 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_312_3 {
	meta:
		name = "_ZNKSt8time_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE21_M_extract_via_formatES3_S3_RSt8ios_baseRSt12_Ios_IostateP2tmPKw"
		size = 4232
		refs = "002c _ZSt9use_facetISt11__timepunctIwEERKT_RKSt6locale 0038 _ZSt9use_facetISt5ctypeIwEERKT_RKSt6locale 0044 wcslen 0278 .text$_ZNKSt8time_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE21_M_extract_via_formatES3_S3_RSt8ios_baseRSt12_Ios_IostateP2tmPKw 04b0 _ZNKSt8time_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE21_M_extract_via_formatES3_S3_RSt8ios_baseRSt12_Ios_IostateP2tmPKw 0550 _ZNKSt8time_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE15_M_extract_nameES3_S3_RiPPKwjRSt8ios_baseRSt12_Ios_Iostate 0670 _ZNKSt8time_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE14_M_extract_numES3_S3_RiiijRSt8ios_baseRSt12_Ios_Iostate 0a88 _ZNKSt19istreambuf_iteratorIwSt11char_traitsIwEE5equalERKS2_ 0ab0 _ZNKSt19istreambuf_iteratorIwSt11char_traitsIwEEdeEv 0ac0 _ZNKSt21__ctype_abstract_baseIwE5widenEc 0d74 _ZNSt19istreambuf_iteratorIwSt11char_traitsIwEEppEv 1038 .rdata 1048 _ZNSt17__timepunct_cacheIwE12_S_timezonesE"
	strings:
		$1 = { F0 4F 2D E9 1E DE 4D E2 40 00 8D E5 0C 02 9D E5 68 90 8D E2 6C 40 80 E2 04 00 A0 E1 14 B2 9D E5 0C 00 89 E8 44 10 8D E5 18 A2 9D E5 ?? ?? ?? ?? 4C 00 8D E5 04 00 A0 E1 ?? ?? ?? ?? 00 60 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 18 10 8B E2 10 20 8B E2 68 30 9D E5 0C C0 8B E2 08 E0 8B E2 58 10 8D E5 54 20 8D E5 04 10 8B E2 14 20 8B E2 00 40 A0 E3 5C C0 8D E5 50 E0 8D E5 64 10 8D E5 60 20 8D E5 4B CF 8D E2 81 EF 8D E2 49 1F 8D E2 47 2F 8D E2 00 00 53 E3 06 70 A0 E1 48 B0 8D E5 DC 41 8D E5 88 8F 9F E5 88 5F 9F E5 28 C0 8D E5 38 E0 8D E5 24 10 8D E5 20 20 8D E5 04 60 A0 E1 00 B0 A0 E1 31 00 00 0A 1E EE 8D E2 B8 20 9E E1 05 00 52 E1 4B 00 00 0A 04 32 9D E5 00 40 A0 E3 00 00 53 E3 2D 00 00 0A 02 CC 8D E2 B8 20 DC E1 05 00 52 E1 39 00 00 0A 00 30 A0 E3 03 00 54 E1 29 00 00 0A DC 31 9D E5 0B 00 56 E1 00 20 A0 23 01 20 A0 33 00 00 53 E3 00 20 A0 13 00 00 52 E3 22 00 00 0A 86 40 A0 E1 00 30 97 E5 07 00 A0 E1 B4 10 9A E1 00 20 A0 E3 0F E0 A0 E1 30 F0 93 E5 00 0C A0 E1 25 04 50 E3 38 00 00 0A 68 30 9D E5 B4 40 9A E1 00 00 53 E3 D8 0E 9F 05 03 00 00 0A 1E 1E 8D E2 B8 00 91 E1 05 00 50 E1 7B 00 00 0A 00 00 54 E1 86 00 00 0A DC 21 9D E5 04 20 82 E3 DC 21 8D E5 01 60 86 E2 00 00 53 E3 CD FF FF 1A 01 40 A0 E3 04 32 9D E5 00 00 53 E3 D1 FF FF 1A 01 30 A0 E3 03 00 54 E1 D5 FF FF 1A DC 31 9D E5 00 00 53 E3 10 02 9D 15 00 30 90 15 04 30 83 13 00 30 80 15 40 20 9D E5 03 00 99 E8 00 00 82 E5 B4 10 C2 E1 02 00 A0 E1 1E DE 8D E2 F0 8F BD E8 08 20 93 E5 0C 10 93 E5 01 00 52 E1 B0 00 D2 31 76 03 00 2A 05 00 50 E1 7C 00 00 0A 02 EC 8D E2 B8 00 CE E1 BB FF FF EA 08 20 93 E5 0C 10 93 E5 01 00 52 E1 B0 00 D2 31 80 03 00 2A 05 00 50 E1 8C 00 00 0A 1E 1E 8D E2 B8 00 81 E1 A9 FF FF EA 01 60 86 E2 86 30 A0 E1 B3 10 9A E1 00 20 A0 E3 00 30 97 E5 07 00 A0 E1 0F E0 A0 E1 30 F0 93 E5 00 0C A0 E1 00 20 A0 E3 45 04 50 E3 4F 04 50 13 D8 21 8D E5 58 00 00 0A 40 0C A0 E1 41 00 40 E2 38 00 50 E3 00 F1 9F 97 70 00 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 08 20 93 E5 0C 10 93 E5 01 00 52 E1 B0 00 D2 31 3B 03 00 2A 05 00 50 E1 1E 2E 8D 12 00 30 A0 03 B8 00 82 11 68 30 9D 15 68 30 8D 05 00 00 54 E1 78 FF FF 1A 00 00 53 E3 79 FF FF 0A 08 20 93 E5 0C 10 93 E5 01 00 52 E1 02 20 82 32 08 20 83 35 26 03 00 2A 00 30 E0 E3 1E CE 8D E2 B8 30 8C E1 01 60 86 E2 68 30 9D E5 6E FF FF EA 01 60 86 E2 86 30 A0 E1 B3 10 9A E1 07 00 A0 E1 00 30 97 E5 0F E0 A0 E1 30 F0 93 E5 00 0C A0 E1 9D FF FF EA 00 30 A0 E3 04 32 8D E5 01 30 A0 E3 68 FF FF EA 68 30 9D E5 00 00 53 E3 28 1C 9F 05 03 00 00 0A 1E EE 8D E2 B8 10 9E E1 05 00 51 E1 C4 02 00 0A 00 30 97 E5 07 00 A0 E1 00 20 A0 E3 0F E0 A0 E1 30 F0 93 E5 00 0C A0 E1 0A 04 50 E3 95 02 00 0A DC 21 9D E5 68 30 9D E5 04 20 82 E3 DC 21 8D E5 01 60 86 E2 4B FF FF EA 00 30 A0 E3 68 30 8D E5 01 40 A0 E3 4A FF FF EA 38 30 9D E5 0D C0 A0 E1 03 00 93 E8 03 00 8C E8 48 10 9D E5 0C E2 9D E5 4C C0 9D E5 77 0F 8D E2 0C 00 99 E8 08 E0 8D E5 0C 00 8D E5 10 10 8D E5 08 10 9C E5 53 4F 8D E2 08 C0 91 E5 04 00 A0 E1 44 10 9D E5 14 C0 8D E5 01 60 86 E2 D2 FE FF EB 03 00 94 E8 B4 10 C9 E1 00 00 89 E5 00 30 A0 E1 2E FF FF EA 4C E0 9D E5 38 20 9D E5 08 C0 9E E5 03 00 92 E8 2C 30 9C E5 71 4F 8D E2 D0 30 8D E5 30 30 9C E5 D4 30 8D E5 34 30 9C E5 D8 30 8D E5 38 E0 9C E5 0C 00 99 E8 DC E0 8D E5 3C E0 9C E5 E0 E0 8D E5 40 E0 9C E5 E4 E0 8D E5 0D E0 A0 E1 44 C0 9C E5 03 00 8E E8 44 10 9D E5 E8 C0 8D E5 04 00 A0 E1 D0 C0 8D E2 0C C0 8D E5 07 C0 A0 E3 10 C0 8D E5 58 C0 9D E5 0C E2 9D E5 08 C0 8D E5 77 CF 8D E2 14 E0 8D E5 18 C0 8D E5 ?? ?? ?? ?? 03 00 94 E8 01 60 86 E2 B4 10 C9 E1 00 00 89 E5 00 30 A0 E1 05 FF FF EA 4C C0 9D E5 38 E0 9D E5 08 30 9C E5 03 00 9E E8 64 20 93 E5 77 EF 8D E2 70 20 8D E5 68 20 93 E5 6D 4F 8D E2 74 20 8D E5 6C 20 93 E5 78 20 8D E5 70 20 93 E5 7C 20 8D E5 74 20 93 E5 80 20 8D E5 78 20 93 E5 84 20 8D E5 7C 20 93 E5 88 20 8D E5 80 20 93 E5 8C 20 8D E5 84 20 93 E5 90 20 8D E5 88 20 93 E5 94 20 8D E5 8C 20 93 E5 98 20 8D E5 90 30 93 E5 0D 20 A0 E1 03 00 82 E8 9C 30 8D E5 70 30 8D E2 0C 30 8D E5 0C 30 A0 E3 10 30 8D E5 54 30 9D E5 04 00 A0 E1 08 30 8D E5 0C C2 9D E5 18 E0 8D E5 14 C0 8D E5 44 10 9D E5 0C 00 99 E8 CB FF FF EA 38 E0 9D E5 0D 20 A0 E1 03 00 9E E8 03 00 82 E8 00 C0 A0 E3 0C 00 99 E8 0C C0 8D E5 63 C0 A0 E3 10 C0 8D E5 02 C0 A0 E3 4F 4F 8D E2 14 C0 8D E5 44 10 9D E5 60 C0 9D E5 04 00 A0 E1 0C E2 9D E5 08 C0 8D E5 77 CF 8D E2 18 E0 8D E5 1C C0 8D E5 ?? ?? ?? ?? 03 00 94 E8 01 60 86 E2 B4 10 C9 E1 00 00 89 E5 00 30 A0 E1 BD FE FF EA A4 19 9F E5 63 EF 8D E2 42 4F 8D E2 09 20 81 E2 04 30 A0 E1 34 E0 8D E5 00 C0 97 E5 07 00 A0 E1 0F E0 A0 E1 2C F0 9C E5 38 20 9D E5 0D C0 A0 E1 03 00 92 E8 0C 00 99 E8 03 00 8C E8 0C E2 9D E5 63 0F 8D E2 08 E0 8D E5 48 E0 9D E5 44 10 9D E5 77 CF 8D E2 14 40 8D E5 0C C0 8D E5 10 E0 8D E5 43 FE FF EB 34 20 9D E5 01 60 86 E2 03 00 92 E8 B4 10 C9 E1 00 00 89 E5 00 30 A0 E1 9D FE FF EA 38 30 9D E5 0D C0 A0 E1 03 00 93 E8 03 00 8C E8 00 C0 A0 E3 0C 00 99 E8 0C C0 8D E5 17 C0 A0 E3 61 4F 8D E2 10 C0 8D E5 44 10 9D E5 02 C0 A0 E3 50 E0 9D E5 04 00 A0 E1 14 C0 8D E5 0C C2 9D E5 08 E0 8D E5 77 EF 8D E2 18 C0 8D E5 1C E0 8D E5 C3 FF FF EA 38 20 9D E5 0D 30 A0 E1 03 00 92 E8 03 00 83 E8 01 C0 A0 E3 0C 00 99 E8 0C C0 8D E5 0C C0 A0 E3 5F 4F 8D E2 10 C0 8D E5 02 C0 A0 E3 14 C0 8D E5 04 00 A0 E1 44 10 9D E5 50 C0 9D E5 AE FF FF EA 38 20 9D E5 0D 30 A0 E1 03 00 92 E8 03 00 83 E8 00 C0 A0 E3 0C 00 99 E8 0C C0 8D E5 3B C0 A0 E3 5B 4F 8D E2 10 C0 8D E5 02 C0 A0 E3 14 C0 8D E5 04 00 A0 E1 44 10 9D E5 64 C0 9D E5 9E FF FF EA 54 18 9F E5 42 4F 8D E2 59 CF 8D E2 06 20 81 E2 04 30 A0 E1 30 C0 8D E5 07 00 A0 E1 00 C0 97 E5 0F E0 A0 E1 2C F0 9C E5 0C 00 99 E8 38 E0 9D E5 0D C0 A0 E1 03 00 9E E8 03 00 8C E8 0C E2 9D E5 59 0F 8D E2 08 E0 8D E5 48 E0 9D E5 44 10 9D E5 77 CF 8D E2 14 40 8D E5 0C C0 8D E5 10 E0 8D E5 EE FD FF EB 30 20 9D E5 01 60 86 E2 03 00 92 E8 B4 10 C9 E1 00 00 89 E5 00 30 A0 E1 48 FE FF EA 38 30 9D E5 0D C0 A0 E1 03 00 93 E8 03 00 8C E8 00 C0 A0 E3 0C 00 99 E8 0C C0 8D E5 3D C0 A0 E3 57 4F 8D E2 10 C0 8D E5 02 C0 A0 E3 04 00 A0 E1 44 10 9D E5 14 C0 8D E5 48 E0 9D E5 A9 FF FF EA 98 17 9F E5 42 4F 8D E2 55 CF 8D E2 09 20 81 E2 04 30 A0 E1 2C C0 8D E5 07 00 A0 E1 00 C0 97 E5 0F E0 A0 E1 2C F0 9C E5 0C 00 99 E8 38 E0 9D E5 0D C0 A0 E1 03 00 9E E8 03 00 8C E8 0C E2 9D E5 55 0F 8D E2 08 E0 8D E5 48 E0 9D E5 44 10 9D E5 77 CF 8D E2 14 40 8D E5 0C C0 8D E5 10 E0 8D E5 BE FD FF EB 2C 20 9D E5 01 60 86 E2 03 00 92 E8 B4 10 C9 E1 00 00 89 E5 00 30 A0 E1 18 FE FF EA 38 E0 9D E5 0D 20 A0 E1 03 00 9E E8 03 00 82 E8 0C C2 9D E5 48 00 9D E5 0C 00 99 E8 77 EF 8D E2 08 C0 8D E5 4C C0 9D E5 0C E0 8D E5 10 00 8D E5 08 10 9C E5 51 4F 8D E2 10 C0 91 E5 CF FE FF EA 38 E0 9D E5 0D 20 A0 E1 03 00 9E E8 03 00 82 E8 76 CF 8D E2 0C 00 99 E8 08 C0 8D E5 00 C0 A0 E3 0C C0 8D E5 B8 C6 9F E5 4D 4F 8D E2 10 C0 8D E5 04 C0 A0 E3 14 C0 8D E5 0C C2 9D E5 04 00 A0 E1 44 10 9D E5 77 EF 8D E2 18 C0 8D E5 1C E0 8D E5 ?? ?? ?? ?? 03 00 94 E8 DC 31 9D E5 00 00 89 E5 00 00 53 E3 B4 10 C9 E1 3E 01 00 1A D8 21 9D E5 48 00 9D E5 76 2E 42 E2 0C 20 42 E2 68 30 9D E5 14 20 80 E5 01 60 86 E2 E5 FD FF EA 68 30 9D E5 00 00 53 E3 38 26 9F 05 03 00 00 0A 1E 1E 8D E2 B8 20 91 E1 05 00 52 E1 3B 01 00 0A 00 30 97 E5 07 00 A0 E1 01 10 A0 E3 0F E0 A0 E1 08 F0 93 E5 00 00 50 E3 84 FE FF 0A 38 30 9D E5 0D C0 A0 E1 03 00 93 E8 03 00 8C E8 0E C0 A0 E3 0C 00 99 E8 75 EF 8D E2 10 C0 8D E5 F8 C5 9F E5 08 E0 8D E5 0C E2 9D E5 4B 0F 8D E2 44 10 9D E5 0C C0 8D E5 77 CF 8D E2 14 E0 8D E5 18 C0 8D E5 ?? ?? ?? ?? 28 E0 9D E5 03 00 9E E8 00 00 89 E5 B4 10 C9 E1 09 00 A0 E1 81 1F 8D E2 ?? ?? ?? ?? 00 00 50 E3 0C 01 00 1A DC 31 9D E5 00 00 53 E3 09 01 00 1A D4 31 9D E5 00 00 53 E3 06 01 00 1A 09 00 A0 E1 ?? ?? ?? ?? 2D 10 A0 E3 00 40 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 00 00 54 E1 F6 00 00 1A 38 20 9D E5 0D 30 A0 E1 03 00 92 E8 03 00 83 E8 17 E0 A0 E3 0C 00 99 E8 10 E0 8D E5 75 EF 8D E2 08 E0 8D E5 0C E2 9D E5 02 C0 A0 E3 00 40 A0 E3 49 0F 8D E2 44 10 9D E5 18 E0 8D E5 77 EF 8D E2 14 C0 8D E5 1C E0 8D E5 3C C0 8D E5 0C 40 8D E5 ?? ?? ?? ?? 24 20 9D E5 38 30 9D E5 03 00 92 E8 0D E0 A0 E1 00 00 89 E5 BC 16 CD E1 03 00 93 E8 03 00 8E E8 3C C0 9D E5 3B E0 A0 E3 0C 00 99 E8 10 E0 8D E5 14 C0 8D E5 0C E2 9D E5 75 CF 8D E2 47 0F 8D E2 44 10 9D E5 08 C0 8D E5 77 CF 8D E2 18 E0 8D E5 0C 40 8D E5 1C C0 8D E5 ?? ?? ?? ?? 20 E0 9D E5 01 60 86 E2 03 00 9E E8 BC 16 CD E1 00 00 89 E5 00 30 A0 E1 7A FD FF EA 4C 30 9D E5 38 E0 9D E5 08 C0 93 E5 03 00 9E E8 48 30 9C E5 73 4F 8D E2 EC 30 8D E5 4C 30 9C E5 F0 30 8D E5 50 30 9C E5 F4 30 8D E5 54 E0 9C E5 0C 00 99 E8 F8 E0 8D E5 58 E0 9C E5 FC E0 8D E5 5C E0 9C E5 00 E1 8D E5 0D E0 A0 E1 60 C0 9C E5 03 00 8E E8 04 C1 8D E5 04 00 A0 E1 44 10 9D E5 EC C0 8D E2 4A FE FF EA 4C E0 9D E5 38 C0 9D E5 08 30 9E E5 0D E0 A0 E1 94 20 93 E5 03 00 9C E8 A0 20 8D E5 98 20 93 E5 6F 4F 8D E2 A4 20 8D E5 9C 20 93 E5 A8 20 8D E5 A0 20 93 E5 AC 20 8D E5 A4 20 93 E5 B0 20 8D E5 A8 20 93 E5 B4 20 8D E5 AC 20 93 E5 B8 20 8D E5 B0 20 93 E5 BC 20 8D E5 B4 20 93 E5 C0 20 8D E5 B8 20 93 E5 C4 20 8D E5 BC 20 93 E5 C8 20 8D E5 C0 30 93 E5 03 00 8E E8 CC 30 8D E5 54 00 9D E5 A0 30 8D E2 0C 30 8D E5 0C 30 A0 E3 10 30 8D E5 08 00 8D E5 0C 12 9D E5 77 2F 8D E2 14 10 8D E5 18 20 8D E5 04 00 A0 E1 44 10 9D E5 0C 00 99 E8 26 FE FF EA 38 20 9D E5 0D 30 A0 E1 03 00 92 E8 03 00 83 E8 0C C2 9D E5 48 00 9D E5 0C 00 99 E8 77 EF 8D E2 08 C0 8D E5 4C C0 9D E5 0C E0 8D E5 10 00 8D E5 08 10 9C E5 6B 4F 8D E2 18 C0 91 E5 EA FD FF EA 38 E0 9D E5 0D 20 A0 E1 03 00 9E E8 03 00 82 E8 69 4F 8D E2 44 10 9D E5 04 00 A0 E1 01 C0 A0 E3 0C 00 99 E8 0C C0 8D E5 1F C0 A0 E3 10 C0 8D E5 02 C0 A0 E3 14 C0 8D E5 5C C0 9D E5 49 FE FF EA 68 30 9D E5 00 00 53 E3 F0 22 9F 05 03 00 00 0A 1E EE 8D E2 B8 20 9E E1 05 00 52 E1 90 00 00 0A 00 30 97 E5 07 00 A0 E1 20 10 A0 E3 0F E0 A0 E1 08 F0 93 E5 00 00 50 E3 58 00 00 0A 09 00 A0 E1 ?? ?? ?? ?? 38 20 9D E5 0D C0 A0 E1 00 30 A0 E1 03 00 92 E8 03 00 8C E8 09 10 A0 E3 0C 02 9D E5 5C E0 9D E5 01 20 A0 E3 10 10 8D E5 77 1F 8D E2 18 00 8D E5 1C 10 8D E5 14 20 8D E5 08 E0 8D E5 0C 20 8D E5 67 4F 8D E2 04 00 A0 E1 44 10 9D E5 0C 00 93 E8 28 FE FF EA 38 E0 9D E5 0D 20 A0 E1 03 00 9E E8 03 00 82 E8 76 CF 8D E2 0C 00 99 E8 08 C0 8D E5 01 C0 A0 E3 0C C0 8D E5 0C C0 A0 E3 10 C0 8D E5 02 C0 A0 E3 5D 4F 8D E2 14 C0 8D E5 0C C2 9D E5 04 00 A0 E1 44 10 9D E5 77 EF 8D E2 18 C0 8D E5 1C E0 8D E5 ?? ?? ?? ?? 03 00 94 E8 DC 31 9D E5 00 00 89 E5 00 00 53 E3 B4 10 C9 E1 23 00 00 1A D8 21 9D E5 48 00 9D E5 01 20 42 E2 68 30 9D E5 10 20 80 E5 01 60 86 E2 CB FC FF EA 68 30 9D E5 00 00 53 E3 D0 11 9F 05 03 00 00 0A 1E 0E 8D E2 B8 10 90 E1 05 00 51 E1 3B 00 00 0A 00 30 97 E5 07 00 A0 E1 00 20 A0 E3 0F E0 A0 E1 30 F0 93 E5 00 0C A0 E1 09 04 50 E3 69 FD FF 1A 09 00 A0 E1 ?? ?? ?? ?? 01 60 86 E2 68 30 9D E5 B6 FC FF EA 09 00 A0 E1 ?? ?? ?? ?? 2B 10 A0 E3 00 40 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 00 00 54 E1 00 FF FF 0A 68 30 9D E5 01 60 86 E2 AB FC FF EA 38 20 9D E5 0D 30 A0 E1 03 00 92 E8 03 00 83 E8 65 4F 8D E2 0C 00 99 E8 04 00 A0 E1 44 10 9D E5 0A C0 A0 E3 86 FF FF EA 08 20 93 E5 0C 10 93 E5 01 00 52 E1 B0 00 D2 31 38 00 00 2A 05 00 50 E1 1E 2E 8D 12 00 30 A0 03 B8 00 82 11 68 30 8D 05 00 20 A0 11 05 20 A0 01 B6 FE FF EA 08 20 93 E5 0C 10 93 E5 01 00 52 E1 B0 00 D2 31 26 00 00 2A 05 00 50 E1 1E 1E 8D 12 00 30 A0 03 B8 00 81 11 68 30 8D 05 00 10 A0 11 05 10 A0 01 2D FD FF EA 08 20 93 E5 0C 10 93 E5 01 00 52 E1 B0 00 D2 31 23 00 00 2A 05 00 50 E1 1E 1E 8D 12 00 30 A0 03 B8 00 81 11 68 30 8D 05 00 10 A0 11 05 10 A0 01 B6 FF FF EA 08 20 93 E5 0C 10 93 E5 01 00 52 E1 B0 00 D2 31 31 00 00 2A 05 00 50 E1 1E 1E 8D 12 00 30 A0 03 B8 00 81 11 00 20 A0 11 68 30 8D 05 05 20 A0 01 61 FF FF EA 03 00 A0 E1 00 30 93 E5 0F E0 A0 E1 24 F0 93 E5 83 FC FF EA 03 00 A0 E1 00 30 93 E5 0F E0 A0 E1 24 F0 93 E5 D3 FF FF EA 03 00 A0 E1 00 30 93 E5 0F E0 A0 E1 }
	condition:
		$1
}

rule file_17_313_3 {
	meta:
		name = "_ZNKSt8time_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE11do_get_dateES3_S3_RSt8ios_baseRSt12_Ios_IostateP2tm"
		size = 356
		refs = "002c _ZSt9use_facetISt11__timepunctIwEERKT_RKSt6locale 0074 _ZNKSt8time_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE21_M_extract_via_formatES3_S3_RSt8ios_baseRSt12_Ios_IostateP2tmPKw"
	strings:
		$1 = { F0 4F 2D E9 28 D0 4D E2 18 40 8D E2 0C 00 84 E8 54 B0 9D E5 00 50 A0 E1 6C 00 8B E2 01 90 A0 E1 58 A0 9D E5 B0 85 DD E1 4C 70 9D E5 ?? ?? ?? ?? 0C 00 94 E8 08 00 90 E5 48 10 8D E2 04 70 A1 E5 B0 85 CD E1 0D C0 A0 E1 08 E0 90 E5 03 00 91 E8 03 00 8C E8 20 60 8D E2 5C C0 9D E5 09 10 A0 E1 06 00 A0 E1 08 B0 8D E5 10 C0 8D E5 14 E0 8D E5 0C A0 8D E5 ?? ?? ?? ?? 03 00 96 E8 00 30 50 E2 BC 11 CD E1 18 00 8D E5 29 00 00 0A BC 11 DD E1 C8 20 9F E5 02 00 51 E1 1A 00 00 0A 00 60 A0 E3 00 00 57 E3 15 00 00 0A B0 30 9F E5 03 00 58 E1 0A 00 00 0A 00 30 A0 E3 06 00 53 E1 00 30 9A 05 03 00 94 E8 02 30 83 03 00 00 85 E5 00 30 8A 05 B4 10 C5 E1 05 00 A0 E1 28 D0 8D E2 F0 8F BD E8 08 30 97 E5 0C 20 97 E5 02 00 53 E1 B0 00 D3 31 11 00 00 2A 64 30 9F E5 03 00 50 E1 EC FF FF 1A 01 30 A0 E3 EB FF FF EA 08 20 93 E5 0C 10 93 E5 01 00 52 E1 B0 00 D2 31 0C 00 00 2A 3C 30 9F E5 03 00 50 E1 BC 01 CD 11 DB FF FF 1A 00 30 A0 E3 18 30 8D E5 01 60 A0 E3 D8 FF FF EA 07 00 A0 E1 00 30 97 E5 0F E0 A0 E1 24 F0 93 E5 E8 FF FF EA 00 30 93 E5 0F E0 A0 E1 24 F0 93 E5 EE FF FF EA FF FF 00 00 }
	condition:
		$1
}

rule file_17_314_3 {
	meta:
		name = "_ZNKSt8time_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE11do_get_timeES3_S3_RSt8ios_baseRSt12_Ios_IostateP2tm"
		size = 356
		refs = "002c _ZSt9use_facetISt11__timepunctIwEERKT_RKSt6locale 0074 _ZNKSt8time_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE21_M_extract_via_formatES3_S3_RSt8ios_baseRSt12_Ios_IostateP2tmPKw"
	strings:
		$1 = { F0 4F 2D E9 28 D0 4D E2 18 40 8D E2 0C 00 84 E8 54 B0 9D E5 00 50 A0 E1 6C 00 8B E2 01 90 A0 E1 58 A0 9D E5 B0 85 DD E1 4C 70 9D E5 ?? ?? ?? ?? 0C 00 94 E8 08 00 90 E5 48 10 8D E2 04 70 A1 E5 B0 85 CD E1 0D C0 A0 E1 10 E0 90 E5 03 00 91 E8 03 00 8C E8 20 60 8D E2 5C C0 9D E5 09 10 A0 E1 06 00 A0 E1 08 B0 8D E5 10 C0 8D E5 14 E0 8D E5 0C A0 8D E5 ?? ?? ?? ?? 03 00 96 E8 00 30 50 E2 BC 11 CD E1 18 00 8D E5 29 00 00 0A BC 11 DD E1 C8 20 9F E5 02 00 51 E1 1A 00 00 0A 00 60 A0 E3 00 00 57 E3 15 00 00 0A B0 30 9F E5 03 00 58 E1 0A 00 00 0A 00 30 A0 E3 06 00 53 E1 00 30 9A 05 03 00 94 E8 02 30 83 03 00 00 85 E5 00 30 8A 05 B4 10 C5 E1 05 00 A0 E1 28 D0 8D E2 F0 8F BD E8 08 30 97 E5 0C 20 97 E5 02 00 53 E1 B0 00 D3 31 11 00 00 2A 64 30 9F E5 03 00 50 E1 EC FF FF 1A 01 30 A0 E3 EB FF FF EA 08 20 93 E5 0C 10 93 E5 01 00 52 E1 B0 00 D2 31 0C 00 00 2A 3C 30 9F E5 03 00 50 E1 BC 01 CD 11 DB FF FF 1A 00 30 A0 E3 18 30 8D E5 01 60 A0 E3 D8 FF FF EA 07 00 A0 E1 00 30 97 E5 0F E0 A0 E1 24 F0 93 E5 E8 FF FF EA 00 30 93 E5 0F E0 A0 E1 24 F0 93 E5 EE FF FF EA FF FF 00 00 }
	condition:
		$1
}

rule file_17_315_3 {
	meta:
		name = "_ZNKSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE16_M_extract_floatES3_S3_RSt8ios_baseRSt12_Ios_IostateRSs"
		size = 5332
		refs = "0040 _Unwind_SjLj_Register 0058 _ZNKSt11__use_cacheISt16__numpunct_cacheIwEEclERKSt6locale 01b4 _ZNSs7reserveEj 045c _ZNKSt19istreambuf_iteratorIwSt11char_traitsIwEE5equalERKS2_ 05e4 _ZSt17__verify_groupingPKcjRKSs 062c _Unwind_SjLj_Unregister 068c wmemchr 0f7c _ZNKSt19istreambuf_iteratorIwSt11char_traitsIwEEdeEv 0fb4 .text$_ZNKSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE16_M_extract_floatES3_S3_RSt8ios_baseRSt12_Ios_IostateRSs 0fb8 __gxx_personality_sj0 0fbc .gcc_except_table 0fc0 _ZNSs4_Rep20_S_empty_rep_storageE 0fcc _CRT_MT 1210 _ZNSs5clearEv 1348 _ZNSsD1Ev 1358 _Unwind_SjLj_Resume 1490 _ZNSs4_Rep10_M_destroyERKSaIcE 14cc _ZN9__gnu_cxx18__exchange_and_addEPVii"
	strings:
		$1 = { 00 48 2D E9 04 B0 8D E2 74 D0 4D E2 18 10 4B E2 0C 00 81 E8 98 3F 9F E5 78 00 0B E5 28 30 0B E5 90 3F 9F E5 04 00 4B E2 34 30 0B E5 88 3F 9F E5 2C 00 0B E5 4C 00 4B E2 30 30 0B E5 24 D0 0B E5 ?? ?? ?? ?? 00 10 E0 E3 48 10 0B E5 0C 10 9B E5 08 00 4B E2 6C 10 81 E2 ?? ?? ?? ?? 5C 00 0B E5 5C 20 1B E5 18 00 1B E5 70 20 82 E2 00 00 50 E3 68 20 0B E5 2B 04 00 0A B4 21 5B E1 44 3F 9F E5 03 00 52 E1 00 C0 A0 13 50 C0 0B 15 18 04 00 0A 04 00 9B E5 00 00 50 E3 27 04 00 0A B8 20 DB E1 20 3F 9F E5 03 00 52 E1 66 03 00 0A 00 30 A0 E3 50 C0 1B E5 0C 00 53 E1 00 20 A0 03 50 20 0B 05 F8 02 00 1A 00 30 A0 E3 01 C0 A0 E3 60 30 0B E5 64 30 0B E5 54 C0 0B E5 5C 10 1B E5 10 30 D1 E5 00 00 53 E3 D4 3E 9F E5 10 30 0B E5 E7 02 00 1A 5C 20 1B E5 68 C0 1B E5 A4 30 D2 E5 08 C0 8C E2 01 00 53 E3 70 C0 0B E5 8B 00 00 1A 54 00 1B E5 00 00 50 E3 36 04 00 1A 5C C0 1B E5 54 00 1B E5 10 30 DC E5 6C 00 0B E5 00 00 53 E3 04 00 00 0A 5C 10 1B E5 50 20 1B E5 B6 32 D1 E1 02 00 53 E1 B8 01 00 0A 5C 10 1B E5 50 20 1B E5 B4 32 D1 E1 02 00 53 E1 49 01 00 1A 6C 30 1B E5 00 00 53 E3 0D 01 00 1A 54 C0 1B E5 00 00 5C E3 0A 01 00 1A 10 30 1B E5 0C 20 13 E5 0C 10 43 E2 00 00 52 E3 18 00 00 0A 04 00 91 E5 01 C0 82 E2 00 00 5C E1 50 C0 0B E5 02 00 00 8A 08 10 91 E5 00 00 51 E3 06 00 00 DA 02 00 A0 E3 48 00 0B E5 50 10 1B E5 10 00 4B E2 ?? ?? ?? ?? 10 30 1B E5 0C 20 13 E5 60 10 1B E5 00 00 A0 E3 02 10 C3 E7 10 20 1B E5 50 C0 1B E5 0C 30 42 E2 0C 10 83 E0 0C C0 02 E5 08 00 83 E5 0C 00 C1 E5 14 10 9B E5 00 30 91 E5 0C 10 43 E2 0C 20 13 E5 04 00 91 E5 01 C0 82 E2 00 00 5C E1 50 C0 0B E5 02 00 00 8A 08 10 91 E5 00 00 51 E3 07 00 00 DA 02 00 A0 E3 48 00 0B E5 50 10 1B E5 14 00 9B E5 ?? ?? ?? ?? 14 10 9B E5 00 30 91 E5 0C 20 13 E5 2E 10 A0 E3 02 10 C3 E7 14 30 9B E5 50 00 1B E5 00 20 93 E5 01 C0 A0 E3 0C 30 42 E2 0C 00 02 E5 00 10 83 E0 00 20 A0 E3 6C C0 0B E5 08 20 83 E5 0C 20 C1 E5 18 00 1B E5 00 00 50 E3 FA 00 00 0A 08 30 90 E5 0C 20 90 E5 02 00 53 E1 02 30 83 32 08 30 80 35 E8 03 00 2A 18 00 1B E5 00 20 E0 E3 00 00 50 E3 B4 21 4B E1 EF 00 00 0A 08 30 90 E5 0C 20 90 E5 02 00 53 E1 B0 00 D3 31 5B 04 00 2A 08 1D 9F E5 01 00 50 E1 B4 01 4B 11 04 00 9B E5 00 20 A0 13 00 30 A0 03 01 C0 A0 03 50 20 0B 15 18 30 0B 05 50 C0 0B 05 00 00 50 E3 E3 00 00 0A B8 30 DB E1 D4 1C 9F E5 01 00 53 E1 D0 00 00 0A 00 30 A0 E3 50 00 1B E5 03 00 50 E1 A4 00 00 0A 18 00 1B E5 00 00 50 E3 B0 1C 9F 05 50 10 0B 05 04 00 00 0A B4 21 5B E1 A0 3C 9F E5 50 20 0B E5 03 00 52 E1 4A 02 00 0A 5C C0 1B E5 10 30 DC E5 7A FF FF EA 54 10 1B E5 00 00 51 E3 AA 03 00 1A 6C 10 0B E5 50 30 1B E5 2F 00 53 E3 12 01 00 8A 5C 10 1B E5 50 20 1B E5 B4 32 D1 E1 02 00 53 E1 56 01 00 0A 68 10 1B E5 50 20 1B E5 B4 32 D1 E1 02 00 53 E1 02 00 00 0A B0 33 D1 E1 02 00 53 E1 83 00 00 1A 54 30 1B E5 00 00 53 E3 80 00 00 1A 64 C0 1B E5 00 00 5C E3 7D 00 00 0A 14 00 9B E5 00 30 90 E5 0C 10 43 E2 0C 20 13 E5 04 00 91 E5 01 C0 82 E2 00 00 5C E1 50 C0 0B E5 02 00 00 8A 08 10 91 E5 00 00 51 E3 07 00 00 DA 02 00 A0 E3 48 00 0B E5 50 10 1B E5 14 00 9B E5 ?? ?? ?? ?? 14 10 9B E5 00 30 91 E5 0C 20 13 E5 65 C0 A0 E3 02 C0 C3 E7 14 00 9B E5 50 C0 1B E5 00 20 90 E5 00 00 A0 E3 0C 30 42 E2 0C 10 83 E0 08 00 83 E5 0C C0 02 E5 0C 00 C1 E5 18 00 1B E5 00 00 50 E3 07 00 00 0A 08 30 90 E5 0C 20 90 E5 02 00 53 E1 02 30 83 32 08 30 80 35 90 03 00 2A 00 20 E0 E3 B4 21 4B E1 02 30 A0 E3 18 00 4B E2 04 10 8B E2 48 30 0B E5 ?? ?? ?? ?? 00 00 50 E3 A4 03 00 1A 18 00 1B E5 00 00 50 E3 50 CB 9F 05 50 C0 0B 05 04 00 00 0A B4 11 5B E1 40 2B 9F E5 50 10 0B E5 02 00 51 E1 E1 01 00 0A 68 C0 1B E5 50 00 1B E5 B2 30 DC E1 00 00 53 E1 2B 10 A0 03 54 10 0B 05 08 00 00 0A 5C 20 1B E5 50 C0 1B E5 B0 37 D2 E1 0C 00 53 E1 01 00 A0 13 54 00 0B 15 A0 FF FF 1A 2D 10 A0 E3 54 10 0B E5 14 20 9B E5 00 30 92 E5 0C 10 43 E2 0C 20 13 E5 04 00 91 E5 01 C0 82 E2 00 00 5C E1 50 C0 0B E5 02 00 00 8A 08 10 91 E5 00 00 51 E3 07 00 00 DA 02 00 A0 E3 48 00 0B E5 50 10 1B E5 14 00 9B E5 ?? ?? ?? ?? 14 10 9B E5 00 30 91 E5 0C 20 13 E5 54 C0 1B E5 01 10 A0 E3 02 C0 C3 E7 14 00 9B E5 54 10 0B E5 00 20 90 E5 50 C0 1B E5 0C 30 42 E2 00 00 A0 E3 0C 10 83 E0 0C C0 02 E5 08 00 83 E5 0C 00 C1 E5 18 00 1B E5 00 00 50 E3 07 00 00 0A 08 30 90 E5 0C 20 90 E5 02 00 53 E1 02 30 83 32 08 30 80 35 35 03 00 2A 00 20 E0 E3 B4 21 4B E1 02 30 A0 E3 18 00 4B E2 04 10 8B E2 48 30 0B E5 ?? ?? ?? ?? 00 00 50 E3 68 00 00 0A 10 30 1B E5 0C 20 13 E5 0C C0 43 E2 00 00 52 E3 50 C0 0B E5 13 00 00 0A 6C 00 1B E5 00 00 50 E3 02 00 00 1A 54 10 1B E5 00 00 51 E3 DD 02 00 0A 5C 00 1B E5 02 30 A0 E3 0C 10 90 E5 10 20 4B E2 08 00 90 E5 48 30 0B E5 ?? ?? ?? ?? 00 00 50 E3 10 30 9B 05 04 20 A0 03 00 20 83 05 10 30 1B E5 0C 30 43 E2 50 30 0B E5 B8 29 9F E5 50 10 1B E5 18 30 4B E2 02 00 51 E1 78 20 1B E5 03 00 93 E8 00 00 82 E5 B4 10 C2 E1 8D 03 00 1A 4C 00 4B E2 ?? ?? ?? ?? 78 00 1B E5 04 D0 4B E2 00 88 BD E8 08 30 90 E5 0C 20 90 E5 02 00 53 E1 B0 00 D3 31 7C 03 00 2A 70 39 9F E5 03 00 50 E1 7B 01 00 0A B8 00 CB E1 24 FF FF EA 01 00 A0 E3 50 00 0B E5 04 00 9B E5 00 00 50 E3 1B FF FF 1A 01 30 A0 E3 1E FF FF EA 70 00 1B E5 50 10 1B E5 0A 20 A0 E3 ?? ?? ?? ?? 00 00 50 E3 74 00 0B E5 B2 00 00 0A 14 C0 9B E5 00 30 9C E5 0C 10 43 E2 0C 20 13 E5 04 00 91 E5 01 C0 82 E2 00 00 5C E1 50 C0 0B E5 02 00 00 8A 08 10 91 E5 00 00 51 E3 07 00 00 DA 02 00 A0 E3 48 00 0B E5 50 10 1B E5 14 00 9B E5 ?? ?? ?? ?? 14 10 9B E5 00 30 91 E5 0C 20 13 E5 74 C0 1B E5 70 00 1B E5 0C 10 60 E0 C1 10 A0 E1 30 10 81 E2 02 10 C3 E7 14 10 9B E5 60 30 1B E5 00 20 91 E5 50 C0 1B E5 01 30 83 E2 60 30 0B E5 0C 30 42 E2 0C 10 83 E0 00 00 A0 E3 0C C0 02 E5 08 00 83 E5 0C 00 C1 E5 01 10 A0 E3 64 10 0B E5 CA FE FF EA 18 00 1B E5 00 00 50 E3 78 C8 9F 05 50 C0 0B 05 FD FE FF 0A B4 11 5B E1 68 28 9F E5 50 10 0B E5 02 00 51 E1 F8 FE FF 1A 08 20 90 E5 0C 30 90 E5 03 00 52 E1 E3 02 00 2A B0 20 D2 E1 50 20 0B E5 50 00 1B E5 3C 18 9F E5 50 30 1B E5 01 00 50 E1 00 20 A0 03 B4 01 4B 11 18 20 0B 05 2F 00 53 E3 EC FE FF 9A 39 00 53 E3 EA FE FF 8A 14 C0 9B E5 50 00 1B E5 00 30 9C E5 30 00 40 E2 0C 10 43 E2 0C 20 13 E5 64 00 0B E5 04 00 91 E5 01 C0 82 E2 00 00 5C E1 50 C0 0B E5 02 00 00 8A 08 10 91 E5 00 00 51 E3 07 00 00 DA 02 00 A0 E3 48 00 0B E5 50 10 1B E5 14 00 9B E5 ?? ?? ?? ?? 14 10 9B E5 00 30 91 E5 0C 20 13 E5 64 C0 1B E5 30 10 8C E2 02 10 C3 E7 14 00 9B E5 01 10 A0 E3 00 20 90 E5 64 10 0B E5 43 FF FF EA 6C 30 1B E5 00 00 53 E3 59 FF FF 1A 54 C0 1B E5 00 00 5C E3 56 FF FF 1A 60 00 1B E5 00 00 50 E3 6D 02 00 0A 10 30 1B E5 0C 10 43 E2 0C 20 13 E5 04 00 91 E5 01 C0 82 E2 00 00 5C E1 50 C0 0B E5 02 00 00 8A 08 10 91 E5 00 00 51 E3 06 00 00 DA 02 00 A0 E3 48 00 0B E5 50 10 1B E5 10 00 4B E2 ?? ?? ?? ?? 10 30 1B E5 0C 20 13 E5 60 10 1B E5 00 00 A0 E3 02 10 C3 E7 10 20 1B E5 50 C0 1B E5 00 30 A0 E3 60 30 0B E5 0C 30 42 E2 0C 10 83 E0 0C C0 02 E5 08 00 83 E5 0C 00 C1 E5 68 FE FF EA 6C 30 1B E5 00 00 53 E3 A5 FE FF 1A 54 C0 1B E5 00 00 5C E3 A2 FE FF 1A 14 00 9B E5 00 20 90 E5 0C 30 42 E2 0C 10 12 E5 04 00 93 E5 01 C0 81 E2 00 00 5C E1 50 C0 0B E5 02 00 00 8A 08 30 93 E5 00 00 53 E3 07 00 00 DA 02 00 A0 E3 48 00 0B E5 50 10 1B E5 14 00 9B E5 ?? ?? ?? ?? 14 10 9B E5 00 20 91 E5 0C 10 12 E5 2E 30 A0 E3 01 30 C2 E7 14 20 9B E5 50 C0 1B E5 00 10 92 E5 01 30 A0 E3 0C 20 41 E2 6C 30 0B E5 00 00 A0 E3 0C 30 82 E0 0C C0 01 E5 08 00 82 E5 0C 00 C3 E5 FA FE FF EA 68 20 1B E5 50 C0 1B E5 B4 32 D2 E1 0C 00 53 E1 02 00 00 0A B0 33 D2 E1 0C 00 53 E1 04 FF FF 1A 54 00 1B E5 00 00 50 E3 01 FF FF 1A 64 10 1B E5 00 00 51 E3 FE FE FF 0A 10 30 1B E5 0C 20 13 E5 0C 10 43 E2 00 00 52 E3 18 00 00 0A 6C C0 1B E5 00 00 5C E3 15 00 00 1A 04 00 91 E5 01 C0 82 E2 00 00 5C E1 50 C0 0B E5 59 00 00 9A 02 00 A0 E3 48 00 0B E5 50 10 1B E5 10 00 4B E2 ?? ?? ?? ?? 10 30 1B E5 0C 20 13 E5 60 10 1B E5 00 00 A0 E3 02 10 C3 E7 10 20 1B E5 50 C0 1B E5 0C 30 42 E2 0C 10 83 E0 0C C0 02 E5 08 00 83 E5 0C 00 C1 E5 14 10 9B E5 00 30 91 E5 0C 10 43 E2 0C 20 13 E5 04 00 91 E5 01 C0 82 E2 00 00 5C E1 50 C0 0B E5 02 00 00 8A 08 10 91 E5 00 00 51 E3 07 00 00 DA 02 00 A0 E3 48 00 0B E5 50 10 1B E5 14 00 9B E5 ?? ?? ?? ?? 14 10 9B E5 00 30 91 E5 0C 20 13 E5 65 C0 A0 E3 02 C0 C3 E7 14 00 9B E5 50 C0 1B E5 00 20 90 E5 00 00 A0 E3 0C 30 42 E2 0C 10 83 E0 08 00 83 E5 0C C0 02 E5 0C 00 C1 E5 18 00 1B E5 00 00 50 E3 07 00 00 0A 08 30 90 E5 0C 20 90 E5 02 00 53 E1 02 30 83 32 08 30 80 35 33 02 00 2A 00 20 E0 E3 B4 21 4B E1 02 30 A0 E3 18 00 4B E2 04 10 8B E2 48 30 0B E5 ?? ?? ?? ?? 00 00 50 E3 07 02 00 1A 18 00 1B E5 00 00 50 E3 DC 24 9F 05 03 00 00 0A B4 21 5B E1 D0 C4 9F E5 0C 00 52 E1 C7 00 00 0A 68 00 1B E5 B2 10 D0 E1 02 00 51 E1 00 10 A0 13 01 10 A0 03 00 00 51 E3 0C 00 00 1A 5C C0 1B E5 B0 37 DC E1 02 00 53 E1 08 00 00 0A 01 00 A0 E3 50 20 0B E5 10 30 DC E5 54 00 0B E5 7A FD FF EA 08 10 91 E5 00 00 51 E3 A2 FF FF CA A8 FF FF EA 5C C0 1B E5 10 30 DC E5 00 00 53 E3 03 00 00 0A B6 02 DC E1 02 00 50 E1 50 00 0B E5 FB 01 00 0A 5C C0 1B E5 B4 C2 DC E1 02 00 5C E1 50 C0 0B E5 F6 01 00 0A 14 00 9B E5 00 00 51 E3 00 30 90 E5 2B 10 A0 13 2D 10 A0 03 54 10 0B E5 0C 20 13 E5 0C 10 43 E2 04 00 91 E5 01 C0 82 E2 00 00 5C E1 50 C0 0B E5 02 00 00 8A 08 10 91 E5 00 00 51 E3 07 00 00 DA 02 00 A0 E3 48 00 0B E5 50 10 1B E5 14 00 9B E5 ?? ?? ?? ?? 14 10 9B E5 00 30 91 E5 0C 20 13 E5 54 C0 1B E5 02 C0 C3 E7 14 00 9B E5 50 C0 1B E5 00 10 90 E5 01 20 A0 E3 0C 30 41 E2 54 20 0B E5 00 00 A0 E3 0C 20 83 E0 0C C0 01 E5 08 00 83 E5 0C 00 C2 E5 94 FD FF EA 08 30 90 E5 0C 20 90 E5 02 00 53 E1 CF 01 00 2A B0 30 D3 E1 50 30 0B E5 50 00 1B E5 8C 13 9F E5 01 00 50 E1 00 20 A0 03 B4 01 4B 11 18 20 0B 05 10 FE FF EA 00 C0 A0 E3 04 C0 8B E5 01 30 A0 E3 A7 FD FF EA 08 30 90 E5 0C 20 90 E5 02 00 53 E1 CD 01 00 2A B0 30 D3 E1 50 30 0B E5 50 00 1B E5 48 13 9F E5 01 00 50 E1 00 20 A0 03 B4 01 4B 11 18 20 0B 05 A7 FD FF EA 02 30 A0 E3 10 00 4B E2 20 10 A0 E3 48 30 0B E5 ?? ?? ?? ?? 11 FD FF EA 18 00 1B E5 00 00 50 E3 10 03 9F 05 50 00 0B 05 04 00 00 0A B4 11 5B E1 00 33 9F E5 50 10 0B E5 03 00 51 E1 3B 01 00 0A 68 30 1B E5 50 C0 1B E5 B2 20 D3 E1 0C 00 52 E1 00 20 A0 13 01 20 A0 03 00 00 52 E3 5F 00 00 1A 5C 00 1B E5 B0 37 D0 E1 0C 00 53 E1 5B 00 00 0A 5C 10 1B E5 50 00 1B E5 10 30 D1 E5 00 20 A0 E3 60 20 0B E5 64 20 0B E5 00 00 53 E3 04 00 00 0A 5C 10 1B E5 B6 12 D1 E1 00 00 51 E1 50 10 0B E5 B2 01 00 0A 5C 20 1B E5 B4 22 D2 E1 00 00 52 E1 50 20 0B E5 AD 01 00 0A 68 30 1B E5 B8 30 D3 E1 00 00 53 E1 50 30 0B E5 E1 00 00 1A 64 00 1B E5 00 00 50 E3 AD 00 00 0A 60 10 1B E5 18 00 1B E5 01 10 81 E2 00 00 50 E3 60 10 0B E5 93 00 00 0A 08 30 90 E5 0C 20 90 E5 02 00 53 E1 02 30 83 32 08 30 80 35 1F 01 00 2A 18 00 1B E5 00 30 E0 E3 00 00 50 E3 B4 31 4B E1 88 00 00 0A 08 30 90 E5 0C 20 90 E5 02 00 53 E1 B0 00 D3 31 88 01 00 2A 00 12 9F E5 01 00 50 E1 B4 01 4B 11 04 00 9B E5 00 20 A0 13 00 30 A0 03 01 C0 A0 03 54 20 0B 15 18 30 0B 05 54 C0 0B 05 00 00 50 E3 7C 00 00 0A B8 30 DB E1 CC 11 9F E5 01 00 53 E1 62 00 00 0A 54 00 1B E5 00 30 A0 E3 00 00 53 E1 78 00 00 1A 01 10 A0 E3 54 10 0B E5 AE FC FF EA 08 20 90 E5 0C 30 90 E5 03 00 52 E1 B0 20 D2 31 99 01 00 2A 90 31 9F E5 03 00 52 E1 00 C0 A0 03 B4 21 4B 11 18 C0 0B 05 2C FF FF EA 08 30 90 E5 0C 20 90 E5 02 00 53 E1 B0 00 D3 31 6B 01 00 2A 64 31 9F E5 03 00 50 E1 D1 00 00 0A B8 00 CB E1 8E FC FF EA 5C 10 1B E5 10 30 D1 E5 00 00 53 E3 03 00 00 0A B6 02 D1 E1 50 C0 1B E5 0C 00 50 E1 9E FF FF 0A 5C 10 1B E5 50 C0 1B E5 B4 02 D1 E1 0C 00 50 E1 99 FF FF 0A 14 00 9B E5 00 00 52 E3 00 30 90 E5 2B 20 A0 13 2D 20 A0 03 54 20 0B E5 0C 10 43 E2 0C 20 13 E5 04 00 91 E5 01 C0 82 E2 00 00 5C E1 60 C0 0B E5 02 00 00 8A 08 10 91 E5 00 00 51 E3 07 00 00 DA 00 30 E0 E3 14 00 9B E5 60 10 1B E5 48 30 0B E5 ?? ?? ?? ?? 14 00 9B E5 00 30 90 E5 0C 20 13 E5 54 10 1B E5 02 10 C3 E7 14 20 9B E5 60 C0 1B E5 00 10 92 E5 00 30 A0 E3 0C 20 41 E2 0C 00 82 E0 0C C0 01 E5 08 30 82 E5 0C 30 C0 E5 18 00 1B E5 03 00 50 E1 07 00 00 0A 08 30 90 E5 0C 20 90 E5 02 00 53 E1 02 30 83 32 08 30 80 35 E2 00 00 2A 00 00 E0 E3 B4 01 4B E1 00 30 E0 E3 18 00 4B E2 04 10 8B E2 48 30 0B E5 ?? ?? ?? ?? 00 00 50 E3 52 FC FF 1A 18 00 4B E2 ?? ?? ?? ?? 5C 10 1B E5 10 30 D1 E5 5F FF FF EA 08 30 90 E5 0C 20 90 E5 02 00 53 E1 B0 00 D3 31 B2 00 00 2A 20 30 9F E5 03 00 50 E1 3E 00 00 0A B8 00 CB E1 92 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FF FF 00 00 ?? ?? ?? ?? 01 00 A0 E3 54 00 0B E5 04 00 9B E5 00 00 50 E3 82 FF FF 1A 01 30 A0 E3 54 00 1B E5 00 00 53 E1 86 FF FF 0A 18 20 1B E5 00 00 52 E3 3C 00 1F 05 }
	condition:
		$1
}

rule file_17_316_3 {
	meta:
		name = "_ZNKSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE6do_getES3_S3_RSt8ios_baseRSt12_Ios_IostateRe"
		size = 736
		refs = "0044 _Unwind_SjLj_Register 0070 _ZNSs7reserveEj 00bc _ZNKSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE16_M_extract_floatES3_S3_RSt8ios_baseRSt12_Ios_IostateRSs 00d8 _ZNSt6locale5facet15_S_get_c_localeEv 00f0 _ZSt14__convert_to_vIeEvPKcRT_RSt12_Ios_IostateRKPi 0184 _Unwind_SjLj_Unregister 022c _ZNSs4_Rep10_M_destroyERKSaIcE 026c _ZN9__gnu_cxx18__exchange_and_addEPVii 0294 _ZNSsD1Ev 02a4 _Unwind_SjLj_Resume 02c4 .text$_ZNKSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE6do_getES3_S3_RSt8ios_baseRSt12_Ios_IostateRe 02c8 __gxx_personality_sj0 02cc .gcc_except_table 02d0 _ZNSs4_Rep20_S_empty_rep_storageE 02dc _CRT_MT"
	strings:
		$1 = { 00 48 2D E9 04 B0 8D E2 78 D0 4D E2 20 C0 4B E2 0C 00 8C E8 A8 32 9F E5 60 00 0B E5 30 30 0B E5 A0 32 9F E5 04 20 4B E2 3C 30 0B E5 98 32 9F E5 54 00 4B E2 38 30 0B E5 5C 10 0B E5 34 20 0B E5 2C D0 0B E5 ?? ?? ?? ?? 80 32 9F E5 04 00 4B E2 08 30 20 E5 04 10 9B E5 B8 30 DB E1 64 10 0B E5 68 30 0B E5 20 10 A0 E3 02 30 A0 E3 50 30 0B E5 ?? ?? ?? ?? 68 20 1B E5 64 10 1B E5 0B 30 A0 E1 04 10 A3 E5 B8 20 CB E1 0D 20 A0 E1 03 00 93 E8 03 00 82 E8 0C 30 9B E5 5C 10 1B E5 08 30 8D E5 0C 30 4B E2 10 30 8D E5 10 30 9B E5 18 00 4B E2 0C 30 8D E5 20 30 4B E2 0C 00 93 E8 ?? ?? ?? ?? 18 30 4B E2 03 00 93 E8 BC 11 4B E1 0C 10 1B E5 20 00 0B E5 5C 10 0B E5 ?? ?? ?? ?? 04 30 4B E2 0C 00 23 E5 14 10 9B E5 5C 00 1B E5 10 20 9B E5 ?? ?? ?? ?? 20 00 1B E5 00 00 50 E3 3C 00 00 0A CC 31 9F E5 BC 21 5B E1 03 00 52 E1 00 30 A0 13 5C 30 0B 15 29 00 00 0A 64 30 1B E5 00 00 53 E3 24 00 00 0A A8 31 9F E5 68 10 1B E5 03 00 51 E1 17 00 00 0A 00 30 A0 E3 5C 20 1B E5 03 00 52 E1 10 10 9B 05 00 30 91 05 02 30 83 03 00 30 81 05 0C 30 1B E5 0C 20 43 E2 58 20 0B E5 58 10 1B E5 70 21 9F E5 02 00 51 E1 20 20 4B E2 03 00 92 E8 60 20 1B E5 00 00 82 E5 B4 10 C2 E1 1F 00 00 1A 54 00 4B E2 ?? ?? ?? ?? 60 00 1B E5 04 D0 4B E2 00 88 BD E8 64 20 1B E5 08 30 92 E5 0C 20 92 E5 02 00 53 E1 B0 00 D3 31 21 00 00 2A 20 31 9F E5 03 00 50 E1 DE FF FF 1A 01 30 A0 E3 DD FF FF EA 08 30 90 E5 0C 20 90 E5 02 00 53 E1 B0 00 D3 31 34 00 00 2A F8 30 9F E5 03 00 50 E1 00 10 A0 13 BC 01 4B 11 5C 10 0B 15 CA FF FF 1A 00 30 A0 E3 20 30 0B E5 01 20 A0 E3 5C 20 0B E5 C5 FF FF EA D4 20 9F E5 00 20 92 E5 00 00 52 E3 11 00 00 1A 04 00 13 E5 01 20 40 E2 04 20 03 E5 00 00 50 E3 D6 FF FF CA 58 00 1B E5 08 10 4B E2 ?? ?? ?? ?? D2 FF FF EA 64 10 1B E5 02 20 A0 E3 00 30 91 E5 01 00 A0 E1 24 30 93 E5 50 20 0B E5 0F E0 A0 E1 03 F0 A0 E1 D4 FF FF EA 01 30 A0 E3 50 30 0B E5 58 30 1B E5 00 10 E0 E3 08 00 83 E2 ?? ?? ?? ?? E9 FF FF EA 04 B0 8B E2 50 30 1B E5 4C 10 1B E5 01 00 53 E3 58 10 0B E5 00 30 A0 03 0C 00 4B 02 50 30 0B 05 ?? ?? ?? ?? 00 30 E0 E3 58 00 1B E5 50 30 0B E5 ?? ?? ?? ?? 00 30 90 E5 02 20 A0 E3 24 30 93 E5 50 20 0B E5 0F E0 A0 E1 03 F0 A0 E1 C3 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FF FF 00 00 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_317_3 {
	meta:
		name = "_ZNKSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE6do_getES3_S3_RSt8ios_baseRSt12_Ios_IostateRd"
		size = 736
		refs = "0044 _Unwind_SjLj_Register 0070 _ZNSs7reserveEj 00bc _ZNKSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE16_M_extract_floatES3_S3_RSt8ios_baseRSt12_Ios_IostateRSs 00d8 _ZNSt6locale5facet15_S_get_c_localeEv 00f0 _ZSt14__convert_to_vIdEvPKcRT_RSt12_Ios_IostateRKPi 0184 _Unwind_SjLj_Unregister 022c _ZNSs4_Rep10_M_destroyERKSaIcE 026c _ZN9__gnu_cxx18__exchange_and_addEPVii 0294 _ZNSsD1Ev 02a4 _Unwind_SjLj_Resume 02c4 .text$_ZNKSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE6do_getES3_S3_RSt8ios_baseRSt12_Ios_IostateRd 02c8 __gxx_personality_sj0 02cc .gcc_except_table 02d0 _ZNSs4_Rep20_S_empty_rep_storageE 02dc _CRT_MT"
	strings:
		$1 = { 00 48 2D E9 04 B0 8D E2 78 D0 4D E2 20 C0 4B E2 0C 00 8C E8 A8 32 9F E5 60 00 0B E5 30 30 0B E5 A0 32 9F E5 04 20 4B E2 3C 30 0B E5 98 32 9F E5 54 00 4B E2 38 30 0B E5 5C 10 0B E5 34 20 0B E5 2C D0 0B E5 ?? ?? ?? ?? 80 32 9F E5 04 00 4B E2 08 30 20 E5 04 10 9B E5 B8 30 DB E1 64 10 0B E5 68 30 0B E5 20 10 A0 E3 02 30 A0 E3 50 30 0B E5 ?? ?? ?? ?? 68 20 1B E5 64 10 1B E5 0B 30 A0 E1 04 10 A3 E5 B8 20 CB E1 0D 20 A0 E1 03 00 93 E8 03 00 82 E8 0C 30 9B E5 5C 10 1B E5 08 30 8D E5 0C 30 4B E2 10 30 8D E5 10 30 9B E5 18 00 4B E2 0C 30 8D E5 20 30 4B E2 0C 00 93 E8 ?? ?? ?? ?? 18 30 4B E2 03 00 93 E8 BC 11 4B E1 0C 10 1B E5 20 00 0B E5 5C 10 0B E5 ?? ?? ?? ?? 04 30 4B E2 0C 00 23 E5 14 10 9B E5 5C 00 1B E5 10 20 9B E5 ?? ?? ?? ?? 20 00 1B E5 00 00 50 E3 3C 00 00 0A CC 31 9F E5 BC 21 5B E1 03 00 52 E1 00 30 A0 13 5C 30 0B 15 29 00 00 0A 64 30 1B E5 00 00 53 E3 24 00 00 0A A8 31 9F E5 68 10 1B E5 03 00 51 E1 17 00 00 0A 00 30 A0 E3 5C 20 1B E5 03 00 52 E1 10 10 9B 05 00 30 91 05 02 30 83 03 00 30 81 05 0C 30 1B E5 0C 20 43 E2 58 20 0B E5 58 10 1B E5 70 21 9F E5 02 00 51 E1 20 20 4B E2 03 00 92 E8 60 20 1B E5 00 00 82 E5 B4 10 C2 E1 1F 00 00 1A 54 00 4B E2 ?? ?? ?? ?? 60 00 1B E5 04 D0 4B E2 00 88 BD E8 64 20 1B E5 08 30 92 E5 0C 20 92 E5 02 00 53 E1 B0 00 D3 31 21 00 00 2A 20 31 9F E5 03 00 50 E1 DE FF FF 1A 01 30 A0 E3 DD FF FF EA 08 30 90 E5 0C 20 90 E5 02 00 53 E1 B0 00 D3 31 34 00 00 2A F8 30 9F E5 03 00 50 E1 00 10 A0 13 BC 01 4B 11 5C 10 0B 15 CA FF FF 1A 00 30 A0 E3 20 30 0B E5 01 20 A0 E3 5C 20 0B E5 C5 FF FF EA D4 20 9F E5 00 20 92 E5 00 00 52 E3 11 00 00 1A 04 00 13 E5 01 20 40 E2 04 20 03 E5 00 00 50 E3 D6 FF FF CA 58 00 1B E5 08 10 4B E2 ?? ?? ?? ?? D2 FF FF EA 64 10 1B E5 02 20 A0 E3 00 30 91 E5 01 00 A0 E1 24 30 93 E5 50 20 0B E5 0F E0 A0 E1 03 F0 A0 E1 D4 FF FF EA 01 30 A0 E3 50 30 0B E5 58 30 1B E5 00 10 E0 E3 08 00 83 E2 ?? ?? ?? ?? E9 FF FF EA 04 B0 8B E2 50 30 1B E5 4C 10 1B E5 01 00 53 E3 58 10 0B E5 00 30 A0 03 0C 00 4B 02 50 30 0B 05 ?? ?? ?? ?? 00 30 E0 E3 58 00 1B E5 50 30 0B E5 ?? ?? ?? ?? 00 30 90 E5 02 20 A0 E3 24 30 93 E5 50 20 0B E5 0F E0 A0 E1 03 F0 A0 E1 C3 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FF FF 00 00 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_318_3 {
	meta:
		name = "_ZNKSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE6do_getES3_S3_RSt8ios_baseRSt12_Ios_IostateRf"
		size = 736
		refs = "0044 _Unwind_SjLj_Register 0070 _ZNSs7reserveEj 00bc _ZNKSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE16_M_extract_floatES3_S3_RSt8ios_baseRSt12_Ios_IostateRSs 00d8 _ZNSt6locale5facet15_S_get_c_localeEv 00f0 _ZSt14__convert_to_vIfEvPKcRT_RSt12_Ios_IostateRKPi 0184 _Unwind_SjLj_Unregister 022c _ZNSs4_Rep10_M_destroyERKSaIcE 026c _ZN9__gnu_cxx18__exchange_and_addEPVii 0294 _ZNSsD1Ev 02a4 _Unwind_SjLj_Resume 02c4 .text$_ZNKSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE6do_getES3_S3_RSt8ios_baseRSt12_Ios_IostateRf 02c8 __gxx_personality_sj0 02cc .gcc_except_table 02d0 _ZNSs4_Rep20_S_empty_rep_storageE 02dc _CRT_MT"
	strings:
		$1 = { 00 48 2D E9 04 B0 8D E2 78 D0 4D E2 20 C0 4B E2 0C 00 8C E8 A8 32 9F E5 60 00 0B E5 30 30 0B E5 A0 32 9F E5 04 20 4B E2 3C 30 0B E5 98 32 9F E5 54 00 4B E2 38 30 0B E5 5C 10 0B E5 34 20 0B E5 2C D0 0B E5 ?? ?? ?? ?? 80 32 9F E5 04 00 4B E2 08 30 20 E5 04 10 9B E5 B8 30 DB E1 64 10 0B E5 68 30 0B E5 20 10 A0 E3 02 30 A0 E3 50 30 0B E5 ?? ?? ?? ?? 68 20 1B E5 64 10 1B E5 0B 30 A0 E1 04 10 A3 E5 B8 20 CB E1 0D 20 A0 E1 03 00 93 E8 03 00 82 E8 0C 30 9B E5 5C 10 1B E5 08 30 8D E5 0C 30 4B E2 10 30 8D E5 10 30 9B E5 18 00 4B E2 0C 30 8D E5 20 30 4B E2 0C 00 93 E8 ?? ?? ?? ?? 18 30 4B E2 03 00 93 E8 BC 11 4B E1 0C 10 1B E5 20 00 0B E5 5C 10 0B E5 ?? ?? ?? ?? 04 30 4B E2 0C 00 23 E5 14 10 9B E5 5C 00 1B E5 10 20 9B E5 ?? ?? ?? ?? 20 00 1B E5 00 00 50 E3 3C 00 00 0A CC 31 9F E5 BC 21 5B E1 03 00 52 E1 00 30 A0 13 5C 30 0B 15 29 00 00 0A 64 30 1B E5 00 00 53 E3 24 00 00 0A A8 31 9F E5 68 10 1B E5 03 00 51 E1 17 00 00 0A 00 30 A0 E3 5C 20 1B E5 03 00 52 E1 10 10 9B 05 00 30 91 05 02 30 83 03 00 30 81 05 0C 30 1B E5 0C 20 43 E2 58 20 0B E5 58 10 1B E5 70 21 9F E5 02 00 51 E1 20 20 4B E2 03 00 92 E8 60 20 1B E5 00 00 82 E5 B4 10 C2 E1 1F 00 00 1A 54 00 4B E2 ?? ?? ?? ?? 60 00 1B E5 04 D0 4B E2 00 88 BD E8 64 20 1B E5 08 30 92 E5 0C 20 92 E5 02 00 53 E1 B0 00 D3 31 21 00 00 2A 20 31 9F E5 03 00 50 E1 DE FF FF 1A 01 30 A0 E3 DD FF FF EA 08 30 90 E5 0C 20 90 E5 02 00 53 E1 B0 00 D3 31 34 00 00 2A F8 30 9F E5 03 00 50 E1 00 10 A0 13 BC 01 4B 11 5C 10 0B 15 CA FF FF 1A 00 30 A0 E3 20 30 0B E5 01 20 A0 E3 5C 20 0B E5 C5 FF FF EA D4 20 9F E5 00 20 92 E5 00 00 52 E3 11 00 00 1A 04 00 13 E5 01 20 40 E2 04 20 03 E5 00 00 50 E3 D6 FF FF CA 58 00 1B E5 08 10 4B E2 ?? ?? ?? ?? D2 FF FF EA 64 10 1B E5 02 20 A0 E3 00 30 91 E5 01 00 A0 E1 24 30 93 E5 50 20 0B E5 0F E0 A0 E1 03 F0 A0 E1 D4 FF FF EA 01 30 A0 E3 50 30 0B E5 58 30 1B E5 00 10 E0 E3 08 00 83 E2 ?? ?? ?? ?? E9 FF FF EA 04 B0 8B E2 50 30 1B E5 4C 10 1B E5 01 00 53 E3 58 10 0B E5 00 30 A0 03 0C 00 4B 02 50 30 0B 05 ?? ?? ?? ?? 00 30 E0 E3 58 00 1B E5 50 30 0B E5 ?? ?? ?? ?? 00 30 90 E5 02 20 A0 E3 24 30 93 E5 50 20 0B E5 0F E0 A0 E1 03 F0 A0 E1 C3 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FF FF 00 00 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_319_3 {
	meta:
		name = "_ZNKSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE14_M_extract_intImEES3_S3_S3_RSt8ios_baseRSt12_Ios_IostateRT_"
		size = 3320
		refs = "0040 _Unwind_SjLj_Register 0058 _ZNKSt11__use_cacheISt16__numpunct_cacheIwEEclERKSt6locale 0158 __udivsi3 01d0 wmemchr 027c _ZNKSt19istreambuf_iteratorIwSt11char_traitsIwEE5equalERKS2_ 0494 _Unwind_SjLj_Unregister 0564 _ZNSs7reserveEj 05b0 _ZSt17__verify_groupingPKcjRKSs 0a48 _ZNSt19istreambuf_iteratorIwSt11char_traitsIwEEppEv 0a60 _ZNKSt19istreambuf_iteratorIwSt11char_traitsIwEEdeEv 0c38 _ZNSsD1Ev 0c48 _Unwind_SjLj_Resume 0c9c _ZNSs4_Rep10_M_destroyERKSaIcE 0cd4 _ZN9__gnu_cxx18__exchange_and_addEPVii 0cdc .text$_ZNKSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE14_M_extract_intImEES3_S3_S3_RSt8ios_baseRSt12_Ios_IostateRT_ 0ce0 __gxx_personality_sj0 0ce4 .gcc_except_table 0cec _ZNSs4_Rep20_S_empty_rep_storageE 0cf4 _CRT_MT"
	strings:
		$1 = { 00 48 2D E9 04 B0 8D E2 78 D0 4D E2 18 10 4B E2 0C 00 81 E8 C0 3C 9F E5 7C 00 0B E5 28 30 0B E5 B8 3C 9F E5 04 00 4B E2 34 30 0B E5 B0 3C 9F E5 2C 00 0B E5 4C 00 4B E2 30 30 0B E5 24 D0 0B E5 ?? ?? ?? ?? 0C 20 9B E5 00 30 E0 E3 08 00 4B E2 6C 10 82 E2 48 30 0B E5 ?? ?? ?? ?? 0C C0 9B E5 70 E0 80 E2 0C 30 9C E5 58 00 0B E5 4A 30 03 E2 40 00 53 E3 08 00 A0 03 54 E0 0B E5 64 30 0B E5 6C 00 0B 05 04 00 00 0A 64 10 1B E5 08 00 51 E3 10 10 A0 03 0A 10 A0 13 6C 10 0B E5 18 00 1B E5 00 00 50 E3 01 20 A0 03 50 20 0B 05 05 00 00 0A 30 3C 9F E5 B4 21 5B E1 03 00 52 E1 00 30 A0 13 50 30 0B 15 44 02 00 0A 04 00 9B E5 00 00 50 E3 3C 02 00 0A B8 20 DB E1 08 3C 9F E5 03 00 52 E1 2D 02 00 0A 00 30 A0 E3 50 00 1B E5 03 00 50 E1 00 20 A0 03 50 20 0B 05 68 01 00 1A 58 C0 1B E5 00 30 A0 E3 60 30 0B E5 01 E0 A0 E3 00 00 A0 E3 10 30 DC E5 78 E0 0B E5 70 00 0B E5 6C C0 1B E5 10 00 5C E3 16 E0 A0 03 64 E0 0B 05 03 00 00 0A 58 00 1B E5 10 30 D0 E5 6C 10 1B E5 64 10 0B E5 00 00 53 E3 A0 3B 9F E5 10 30 0B E5 08 02 00 1A 00 00 E0 E3 6C 10 1B E5 ?? ?? ?? ?? 58 20 1B E5 54 C0 1B E5 A4 30 D2 E5 08 C0 8C E2 01 00 53 E3 68 00 0B E5 74 C0 0B E5 59 00 00 1A 78 E0 1B E5 00 00 5E E3 53 02 00 1A 78 E0 1B E5 54 E0 0B E5 5C E0 0B E5 58 00 1B E5 10 30 D0 E5 00 00 53 E3 03 00 00 0A B6 32 D0 E1 50 10 1B E5 01 00 53 E1 07 01 00 0A 58 00 1B E5 50 10 1B E5 B4 32 D0 E1 01 00 53 E1 D2 00 00 0A 74 00 1B E5 64 20 1B E5 ?? ?? ?? ?? 00 00 50 E3 CD 00 00 0A 74 20 1B E5 68 C0 1B E5 00 30 62 E0 C3 30 A0 E1 54 E0 1B E5 0F 00 53 E3 06 30 43 C2 0E 00 5C E1 01 00 A0 33 5C 00 0B 35 0D 00 00 3A 54 20 1B E5 6C 10 1B E5 5C C0 1B E5 91 02 02 E0 60 E0 1B E5 03 10 E0 E1 02 00 51 E1 01 C0 8C 33 02 30 83 E0 FF 10 0C E2 01 E0 8E E2 54 30 0B E5 5C 10 0B E5 60 E0 0B E5 18 00 1B E5 00 00 50 E3 07 00 00 0A 08 30 90 E5 0C 20 90 E5 02 00 53 E1 02 30 83 32 08 30 80 35 32 02 00 2A 00 20 E0 E3 B4 21 4B E1 02 30 A0 E3 18 00 4B E2 04 10 8B E2 48 30 0B E5 ?? ?? ?? ?? 00 00 50 E3 55 00 00 1A 18 00 1B E5 00 00 50 E3 50 CA 9F 05 50 C0 0B 05 BD FF FF 0A B4 E1 5B E1 40 1A 9F E5 50 E0 0B E5 01 00 5E E1 B8 FF FF 1A 08 20 90 E5 0C 30 90 E5 03 00 52 E1 4D 02 00 2A B0 20 D2 E1 50 20 0B E5 50 30 1B E5 14 CA 9F E5 0C 00 53 E1 00 E0 A0 03 B4 31 4B 11 18 E0 0B 05 AB FF FF EA 78 00 1B E5 00 00 50 E3 F9 01 00 1A 64 10 1B E5 54 00 0B E5 30 30 81 E2 03 38 A0 E1 23 38 A0 E1 74 30 0B E5 5C 00 0B E5 64 20 1B E5 0A 00 52 E3 7B 00 00 9A 50 E0 1B E5 30 30 4E E2 03 28 A0 E1 09 08 52 E3 04 00 00 9A 61 30 4E E2 03 38 A0 E1 05 08 53 E3 57 30 4E 92 D0 00 00 8A 01 00 73 E3 72 00 00 0A 68 20 1B E5 54 C0 1B E5 0C 00 52 E1 01 E0 A0 33 5C E0 0B 35 0D 00 00 3A 54 20 1B E5 6C 00 1B E5 5C C0 1B E5 90 02 02 E0 03 10 E0 E1 60 E0 1B E5 02 00 51 E1 01 C0 8C 33 FF 10 0C E2 02 20 83 E0 01 E0 8E E2 54 20 0B E5 5C 10 0B E5 60 E0 0B E5 18 00 1B E5 00 00 50 E3 07 00 00 0A 08 30 90 E5 0C 20 90 E5 02 00 53 E1 02 30 83 32 08 30 80 35 CE 01 00 2A 00 20 E0 E3 B4 21 4B E1 02 30 A0 E3 18 00 4B E2 04 10 8B E2 48 30 0B E5 ?? ?? ?? ?? 00 00 50 E3 30 00 00 0A 00 00 A0 E3 01 10 A0 E3 6C 00 0B E5 78 10 0B E5 10 30 1B E5 0C 20 13 E5 0C C0 43 E2 00 00 52 E3 50 C0 0B E5 4A 00 00 1A 60 20 1B E5 00 00 52 E3 06 00 00 1A 70 30 1B E5 00 00 53 E3 03 00 00 1A 50 C0 1B E5 00 30 9C E5 00 00 53 E3 02 00 00 0A 6C E0 1B E5 00 00 5E E3 87 00 00 0A 14 00 9B E5 00 30 A0 E3 10 10 9B E5 00 30 80 E5 04 30 A0 E3 00 30 81 E5 78 10 1B E5 50 C0 1B E5 00 00 51 E3 10 20 9B 15 7C E0 1B E5 00 30 92 15 02 30 83 13 00 30 82 15 74 28 9F E5 18 30 4B E2 02 00 5C E1 03 00 93 E8 00 00 8E E5 B4 10 CE E1 F6 01 00 1A 4C 00 4B E2 ?? ?? ?? ?? 7C 00 1B E5 04 D0 4B E2 00 88 BD E8 18 00 1B E5 00 00 50 E3 34 C8 9F 05 50 C0 0B 05 94 FF FF 0A B4 E1 5B E1 24 18 9F E5 50 E0 0B E5 01 00 5E E1 8F FF FF 1A 08 20 90 E5 0C 30 90 E5 03 00 52 E1 F1 01 00 2A B0 20 D2 E1 50 20 0B E5 50 30 1B E5 F8 C7 9F E5 64 20 1B E5 0C 00 53 E1 00 30 A0 03 B4 31 4B 11 18 30 0B 05 0A 00 52 E3 83 FF FF 8A 50 30 1B E5 2F 00 53 E3 6B 01 00 8A 10 30 1B E5 00 20 A0 E3 6C 20 0B E5 0C 20 13 E5 0C C0 43 E2 00 00 52 E3 50 C0 0B E5 B4 FF FF 0A 04 10 9C E5 01 E0 82 E2 01 00 5E E1 64 E0 0B E5 02 00 00 8A 08 10 9C E5 00 00 51 E3 06 00 00 DA 02 30 A0 E3 10 00 4B E2 64 10 1B E5 48 30 0B E5 ?? ?? ?? ?? 10 30 1B E5 0C 20 13 E5 60 00 1B E5 02 00 C3 E7 04 20 4B E2 0C 00 32 E5 64 E0 1B E5 0C 10 40 E2 00 30 A0 E3 0E C0 81 E0 08 30 81 E5 0C E0 00 E5 0C 30 CC E5 58 00 1B E5 02 30 A0 E3 0C 10 90 E5 08 00 90 E5 48 30 0B E5 ?? ?? ?? ?? 00 00 50 E3 10 10 9B 05 04 30 A0 03 00 30 81 05 10 30 1B E5 0C 30 43 E2 50 30 0B E5 8C FF FF EA 60 20 1B E5 00 00 52 E3 42 01 00 0A 10 30 1B E5 0C 10 43 E2 0C 20 13 E5 04 00 91 E5 01 C0 82 E2 00 00 5C E1 50 C0 0B E5 02 00 00 8A 08 10 91 E5 00 00 51 E3 06 00 00 DA 02 E0 A0 E3 10 00 4B E2 50 10 1B E5 48 E0 0B E5 ?? ?? ?? ?? 10 30 1B E5 0C 20 13 E5 60 00 1B E5 00 E0 A0 E3 02 00 C3 E7 10 10 1B E5 50 C0 1B E5 00 20 A0 E3 0C 30 41 E2 60 20 0B E5 0C 20 83 E0 0C C0 01 E5 08 E0 83 E5 0C E0 C2 E5 F8 FE FF EA 5C 30 1B E5 00 00 53 E3 C8 00 00 0A 14 20 9B E5 00 30 E0 E3 10 C0 9B E5 00 30 82 E5 04 30 A0 E3 00 30 8C E5 73 FF FF EA 50 10 1B E5 41 30 41 E2 03 38 A0 E1 05 08 53 E3 9E FF FF 8A 37 30 41 E2 27 FF FF EA 18 00 1B E5 00 00 50 E3 38 26 9F 05 03 00 00 0A B4 21 5B E1 2C 36 9F E5 03 00 52 E1 F1 00 00 0A 54 10 1B E5 B2 10 D1 E1 02 00 51 E1 50 10 0B E5 D0 00 00 0A 58 C0 1B E5 50 20 0B E5 10 30 DC E5 64 00 1B E5 00 E0 A0 E3 60 E0 0B E5 70 E0 0B E5 68 00 0B E5 00 00 53 E3 04 00 00 0A 58 C0 1B E5 50 E0 1B E5 B6 22 DC E1 0E 00 52 E1 32 01 00 0A 58 00 1B E5 50 10 1B E5 B4 22 D0 E1 01 00 52 E1 2D 01 00 0A 54 C0 1B E5 B8 20 DC E1 01 00 52 E1 67 00 00 0A 70 20 1B E5 00 00 52 E3 2A 01 00 0A 54 C0 1B E5 50 E0 1B E5 B4 20 DC E1 0E 00 52 E1 02 00 00 0A B6 20 DC E1 0E 00 52 E1 22 01 00 1A 64 00 1B E5 00 00 50 E3 52 00 00 1A 68 10 1B E5 10 20 A0 E3 60 10 0B E5 70 10 0B E5 6C 20 0B E5 18 00 1B E5 00 00 50 E3 32 00 00 0A 08 30 90 E5 0C 20 90 E5 02 00 53 E1 02 30 83 32 08 30 80 35 DB 00 00 2A 18 00 1B E5 00 20 E0 E3 00 00 50 E3 B4 21 4B E1 27 00 00 0A 08 30 90 E5 0C 20 90 E5 02 00 53 E1 B0 00 D3 31 E6 00 00 2A 14 E5 9F E5 0E 00 50 E1 B4 01 4B 11 00 00 A0 13 5C 00 0B 15 04 00 9B E5 00 10 A0 03 01 20 A0 03 18 10 0B 05 5C 20 0B 05 00 00 50 E3 1B 00 00 0A B8 30 DB E1 E0 C4 9F E5 0C 00 53 E1 08 00 00 0A 5C C0 1B E5 00 30 A0 E3 0C 00 53 E1 17 00 00 1A 58 E0 1B E5 01 00 A0 E3 10 30 DE E5 78 00 0B E5 3A FE FF EA 08 30 90 E5 0C 20 90 E5 02 00 53 E1 B0 00 D3 31 C1 00 00 2A 9C 14 9F E5 01 00 50 E1 39 00 00 0A B8 00 CB E1 EC FF FF EA 04 00 9B E5 01 30 A0 E3 00 00 50 E3 5C 30 0B E5 E3 FF FF 1A 01 30 A0 E3 5C C0 1B E5 0C 00 53 E1 E7 FF FF 0A 18 00 1B E5 00 00 50 E3 5C 24 9F 05 03 00 00 0A B4 21 5B E1 50 14 9F E5 01 00 52 E1 2A 00 00 0A 70 E0 1B E5 00 00 5E E3 72 00 00 0A 58 10 1B E5 50 20 0B E5 10 30 D1 E5 8E FF FF EA 6C C0 1B E5 10 00 5C E3 42 00 00 1A 00 00 A0 E3 60 00 0B E5 70 00 0B E5 AA FF FF EA 70 E0 1B E5 00 00 5E E3 02 00 00 0A 6C 00 1B E5 0A 00 50 E3 94 FF FF 1A 64 10 1B E5 00 00 51 E3 06 00 00 1A 68 20 1B E5 01 30 A0 E3 08 C0 A0 E3 60 20 0B E5 70 30 0B E5 6C C0 0B E5 9A FF FF EA 6C 00 1B E5 60 E0 1B E5 08 00 50 E3 01 E0 8E 12 00 E0 A0 03 01 10 A0 E3 60 E0 0B E5 70 10 0B E5 91 FF FF EA 00 20 A0 E3 04 20 8B E5 01 30 A0 E3 C9 FF FF EA 08 30 90 E5 0C 20 90 E5 02 00 53 E1 B0 20 D3 31 BB 00 00 2A 84 33 9F E5 03 00 52 E1 00 C0 A0 03 B4 21 4B 11 18 C0 0B 05 C9 FF FF EA 02 30 A0 E3 10 00 4B E2 20 10 A0 E3 48 30 0B E5 ?? ?? ?? ?? F0 FD FF EA 54 E0 1B E5 14 00 9B E5 00 E0 80 E5 AD FE FF EA 08 30 90 E5 0C 20 90 E5 02 00 53 E1 B0 00 D3 31 83 00 00 2A 30 33 9F E5 03 00 50 E1 B8 00 CB 11 C8 FD FF 1A 00 30 A0 E3 04 30 8B E5 01 30 A0 E3 C5 FD FF EA 00 E0 A0 E3 78 E0 0B E5 D6 FD FF EA 08 30 90 E5 0C 20 90 E5 02 00 53 E1 B0 00 D3 31 64 00 00 2A F0 32 9F E5 03 00 50 E1 00 C0 A0 13 00 30 A0 03 01 E0 A0 03 B4 01 4B 11 50 C0 0B 15 18 30 0B 05 50 E0 0B 05 AB FD FF EA 58 C0 1B E5 10 30 DC E5 00 00 53 E3 22 00 00 1A 58 E0 1B E5 50 00 1B E5 B4 22 DE E1 00 00 52 E1 28 FF FF 0A 00 30 E0 E3 18 00 4B E2 48 30 0B E5 ?? ?? ?? ?? 04 10 8B E2 ?? ?? ?? ?? 00 00 50 E3 A7 FD FF 1A 18 00 4B E2 ?? ?? ?? ?? 58 10 1B E5 50 00 0B E5 10 30 D1 E5 1A FF FF EA 58 00 1B E5 50 20 0B E5 10 30 D0 E5 78 E0 0B E5 A4 FD FF EA 08 30 90 E5 0C 20 90 E5 02 00 53 E1 B0 20 D3 31 40 00 00 2A 44 32 9F E5 03 00 52 E1 00 30 A0 03 B4 21 4B 11 18 30 0B 05 02 FF FF EA B6 12 DC E1 02 00 51 E1 D9 FF FF 1A 06 FF FF EA 74 C0 1B E5 03 00 5C E1 90 FE FF 9A 30 30 43 E2 19 FE FF EA 00 30 A0 E3 54 30 0B E5 5C 30 0B E5 6C 30 0B E5 40 FE FF EA 01 30 A0 E3 6C 30 0B E5 3D FE FF EA 00 30 90 E5 02 10 A0 E3 28 30 93 E5 48 10 0B E5 0F E0 A0 E1 03 F0 A0 E1 29 FE FF EA 00 30 90 E5 00 10 E0 E3 28 30 93 E5 48 10 0B E5 0F E0 A0 E1 03 F0 A0 E1 1C FF FF EA 00 30 90 E5 02 10 A0 E3 28 30 93 E5 48 10 0B E5 0F E0 A0 E1 03 F0 A0 E1 C5 FD FF EA 00 30 90 E5 00 E0 E0 E3 24 30 93 E5 48 E0 0B E5 0F E0 A0 E1 03 F0 A0 E1 36 FF FF EA 00 30 90 E5 00 C0 E0 E3 24 30 93 E5 48 C0 0B E5 0F E0 A0 E1 03 F0 A0 E1 11 FF FF EA 00 30 90 E5 00 20 E0 E3 24 30 93 E5 48 20 0B E5 0F E0 A0 E1 03 F0 A0 E1 93 FF FF EA 00 30 90 E5 00 20 E0 E3 24 30 93 E5 48 20 0B E5 0F E0 A0 E1 03 F0 A0 E1 00 20 A0 E1 B6 FF FF EA 00 30 90 E5 00 20 E0 E3 24 30 93 E5 48 20 0B E5 0F E0 A0 E1 03 F0 A0 E1 74 FF FF EA 00 10 A0 E3 50 20 0B E5 78 10 0B E5 4B FD FF EA 00 20 A0 E3 78 20 0B E5 48 FD FF EA 00 30 90 E5 02 20 A0 E3 24 30 93 E5 48 20 0B E5 0F E0 A0 E1 03 F0 A0 E1 50 00 0B E5 AB FD FF EA 04 B0 8B E2 48 30 1B E5 44 20 1B E5 01 00 53 E3 50 20 0B E5 00 30 A0 03 10 00 4B 02 48 30 0B 05 ?? ?? ?? ?? 00 30 E0 E3 50 00 1B E5 48 30 0B E5 ?? ?? ?? ?? 00 30 90 E5 00 20 E0 E3 24 30 93 E5 48 20 0B E5 0F E0 A0 E1 03 F0 A0 E1 00 20 A0 E1 3B FF FF EA 80 30 9F E5 00 30 93 E5 00 00 53 E3 11 00 00 1A 50 10 1B E5 08 00 91 E5 01 30 40 E2 08 30 81 E5 00 00 50 E3 FE FD FF CA 50 00 1B E5 0C 10 4B E2 ?? ?? ?? ?? FA FD FF EA 00 30 90 E5 02 20 A0 E3 24 30 93 E5 48 20 0B E5 0F E0 A0 E1 03 F0 A0 E1 50 00 0B E5 07 FE FF EA 01 30 A0 E3 08 00 8C E2 00 10 E0 E3 48 30 0B E5 ?? ?? ?? ?? EB FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FF FF 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_320_3 {
	meta:
		name = "_ZNKSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE6do_getES3_S3_RSt8ios_baseRSt12_Ios_IostateRPv"
		size = 152
		refs = "0060 _ZNKSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE14_M_extract_intImEES3_S3_S3_RSt8ios_baseRSt12_Ios_IostateRT_"
	strings:
		$1 = { F0 41 2D E9 28 D0 4D E2 48 50 9D E5 14 40 8D E2 0C 80 95 E5 0C 00 84 E8 4A 30 C8 E3 08 30 83 E3 0C 30 85 E5 40 20 8D E2 0D 30 A0 E1 00 60 A0 E1 01 C0 A0 E1 03 00 92 E8 03 00 83 E8 0C 10 A0 E1 4C C0 9D E5 1C 70 8D E2 0C 00 94 E8 07 00 A0 E1 0C C0 8D E5 24 C0 8D E2 10 C0 8D E5 08 50 8D E5 ?? ?? ?? ?? 03 00 97 E8 24 20 9D E5 50 30 9D E5 14 00 8D E5 B8 11 CD E1 03 00 94 E8 0C 80 85 E5 00 00 86 E5 00 20 83 E5 B4 10 C6 E1 06 00 A0 E1 28 D0 8D E2 F0 81 BD E8 }
	condition:
		$1
}

rule file_17_322_3 {
	meta:
		name = "_ZNKSt9money_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE10_M_extractILb1EEES3_S3_S3_RSt8ios_baseRSt12_Ios_IostateRSs"
		size = 5344
		refs = "0040 _Unwind_SjLj_Register 005c _ZSt9use_facetISt5ctypeIwEERKT_RKSt6locale 0068 _ZNKSt6locale2id5_M_idEv 00d8 _ZNSs7reserveEj 0174 .text$_ZNKSt9money_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE10_M_extractILb1EEES3_S3_S3_RSt8ios_baseRSt12_Ios_IostateRSs 0334 _ZNKSt19istreambuf_iteratorIwSt11char_traitsIwEE5equalERKS2_ 0410 _ZNKSs17find_first_not_ofEcj 04e0 _ZSt17__verify_groupingPKcjRKSs 05d8 _Unwind_SjLj_Unregister 0680 wmemchr 0e4c _ZNSs4swapERSs 0f18 _ZNSs9_M_mutateEjjj 0f50 __gxx_personality_sj0 0f54 .gcc_except_table 0f58 _ZNSt10moneypunctIwLb1EE2idE 0f5c _ZNSs4_Rep20_S_empty_rep_storageE 0f64 _ZNSt10money_base8_S_atomsE 0f68 _ZTVSt18__moneypunct_cacheIwLb1EE 0f70 _CRT_MT 0f84 _Znwj 0ffc _ZNSt18__moneypunct_cacheIwLb1EE8_M_cacheERKSt6locale 1018 _ZNSt6locale5_Impl16_M_install_cacheEPKNS_5facetEj 1048 _ZNSs12_M_leak_hardEv 1094 _ZNSs14_M_replace_auxEjjjc 1260 _ZNSs4_Rep10_M_destroyERKSaIcE 1298 _ZN9__gnu_cxx18__exchange_and_addEPVii 1320 _Unwind_SjLj_Resume 1364 _ZNSsD1Ev 1390 __cxa_end_catch 13a8 __cxa_begin_catch 13dc __cxa_rethrow"
	strings:
		$1 = { 10 48 2D E9 08 B0 8D E2 A8 D0 4D E2 24 10 4B E2 0C 00 81 E8 30 3F 9F E5 A0 00 0B E5 34 30 0B E5 28 3F 9F E5 08 00 4B E2 40 30 0B E5 20 3F 9F E5 38 00 0B E5 58 00 4B E2 3C 30 0B E5 30 D0 0B E5 ?? ?? ?? ?? 0C 10 9B E5 00 30 E0 E3 6C 10 81 E2 01 00 A0 E1 54 30 0B E5 60 10 0B E5 ?? ?? ?? ?? 74 00 0B E5 EC 0E 9F E5 ?? ?? ?? ?? 0C 20 9B E5 64 00 0B E5 6C 30 92 E5 0C 30 93 E5 68 30 0B E5 00 31 93 E7 00 00 53 E3 B9 03 00 0A 6C 30 0B E5 24 30 93 E5 00 00 53 E3 03 00 00 0A 6C E0 1B E5 2C 30 9E E5 00 30 53 E2 01 30 A0 13 6C 00 1B E5 94 30 0B E5 10 30 D0 E5 9C 1E 9F E5 00 00 53 E3 14 10 0B E5 04 00 00 0A 06 30 A0 E3 14 00 4B E2 20 10 A0 E3 54 30 0B E5 ?? ?? ?? ?? 78 2E 9F E5 08 00 4B E2 10 20 20 E5 05 30 A0 E3 20 10 A0 E3 54 30 0B E5 ?? ?? ?? ?? 6C 40 1B E5 00 C0 A0 E3 38 30 94 E5 3C E0 84 E2 1C 30 0B E5 3E 00 84 E2 1C 10 5B E5 1A 20 5B E5 19 30 5B E5 74 40 1B E5 84 C0 0B E5 7C E0 0B E5 01 C0 A0 E3 00 E0 A0 E3 70 00 0B E5 AC 10 0B E5 A8 20 0B E5 A4 30 0B E5 78 40 0B E5 80 C0 0B E5 90 E0 0B E5 64 E0 0B E5 8C E0 0B E5 88 E0 0B E5 98 E0 0B E5 84 10 1B E5 1C 30 4B E2 D1 30 93 E1 04 00 53 E3 03 F1 9F 97 6C 02 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 6C 00 1B E5 24 30 90 E5 00 00 53 E3 8A 02 00 1A 6C 40 1B E5 2C 30 94 E5 00 00 53 E3 AA 02 00 1A 6C C0 1B E5 24 30 9C E5 00 00 53 E3 5E 02 00 0A 6C 10 1B E5 2C 30 91 E5 00 00 53 E3 5A 02 00 1A 01 20 A0 E3 5C 20 0B E5 98 20 0B E5 59 00 00 EA 0C 00 9B E5 0C 30 90 E5 02 0C 13 E3 41 02 00 0A 6C 30 1B E5 00 20 A0 E3 1C 30 93 E5 24 00 1B E5 5C 20 0B E5 68 30 0B E5 00 00 50 E3 01 00 A0 03 60 00 0B 05 05 00 00 0A B0 32 5B E1 50 1D 9F E5 01 00 53 E1 00 20 A0 13 60 20 0B 15 0B 02 00 0A 04 00 9B E5 00 00 50 E3 CB 01 00 0A B8 30 DB E1 2C 2D 9F E5 02 00 53 E1 11 00 00 0A 00 30 A0 E3 60 00 1B E5 00 00 53 E1 03 00 00 0A 5C 10 1B E5 68 20 1B E5 02 00 51 E1 CE 01 00 3A 5C 10 1B E5 68 20 1B E5 02 00 51 E1 2C 02 00 0A 5C C0 1B E5 00 00 5C E3 99 02 00 0A 00 10 A0 E3 5C 10 0B E5 2C 00 00 EA 08 30 90 E5 0C 20 90 E5 02 00 53 E1 B0 00 D3 31 06 04 00 2A C4 CC 9F E5 0C 00 50 E1 AB 01 00 0A B8 00 CB E1 E3 FF FF EA 24 00 1B E5 00 00 50 E3 01 20 A0 03 5C 20 0B 05 05 00 00 0A B0 32 5B E1 98 4C 9F E5 04 00 53 E1 00 C0 A0 13 5C C0 0B 15 86 02 00 0A 04 00 9B E5 00 00 50 E3 01 30 A0 03 04 00 00 0A B8 30 DB E1 70 2C 9F E5 02 00 53 E1 1E 01 00 0A 00 30 A0 E3 5C 40 1B E5 04 00 53 E1 0C 02 00 1A 00 E0 A0 E3 5C E0 0B E5 84 40 1B E5 03 00 54 E3 12 00 00 0A 05 00 A0 E3 54 00 0B E5 04 10 8B E2 24 00 4B E2 ?? ?? ?? ?? 00 00 50 E3 1B 01 00 0A 80 30 1B E5 03 00 53 E3 08 00 00 CA 84 E0 1B E5 80 00 1B E5 5C C0 1B E5 01 E0 8E E2 01 00 80 E2 00 00 5C E3 84 E0 0B E5 80 00 0B E5 7A FF FF 1A 8C 00 1B E5 01 00 50 E3 CE 02 00 9A 5C 20 1B E5 00 00 52 E3 63 00 00 0A 98 30 1B E5 01 E0 A0 E3 00 00 53 E3 6C 40 1B 15 6C C0 1B 05 28 40 94 15 20 C0 9C 05 60 40 0B 15 60 C0 0B 05 5C E0 0B E5 05 40 A0 E3 24 00 4B E2 04 10 8B E2 54 40 0B E5 ?? ?? ?? ?? 00 00 50 E3 03 00 00 1A 5C C0 1B E5 8C E0 1B E5 0E 00 5C E1 7A 02 00 3A 5C 10 1B E5 8C 20 1B E5 02 00 51 E1 4A 00 00 1A 18 30 1B E5 0C 30 13 E5 01 00 53 E3 07 00 00 9A 05 30 A0 E3 18 00 4B E2 30 10 A0 E3 00 20 A0 E3 54 30 0B E5 ?? ?? ?? ?? 00 00 50 E3 B1 02 00 1A 98 10 1B E5 00 00 51 E3 00 03 00 1A 14 30 1B E5 0C 20 13 E5 0C 10 43 E2 00 00 52 E3 2E 00 00 0A 88 40 1B E5 00 00 54 E3 90 C0 1B 15 64 E0 1B 05 0C 0C A0 11 0E 0C A0 01 40 0C A0 11 40 0C A0 01 60 00 0B 15 60 00 0B 05 04 00 91 E5 01 40 82 E2 00 00 54 E1 5C 40 0B E5 02 00 00 8A 08 10 91 E5 00 00 51 E3 06 00 00 DA 05 30 A0 E3 14 00 4B E2 