private rule architecture {
	meta:
		bits = 64
		endianness = "little"
		architecture = "x64"
	condition:
		true
}

rule file_0_0_0 {
	meta:
		name = "strlen"
		size = 168
	strings:
		$1 = { 48 8B C1 48 F7 D9 48 A9 07 00 00 00 74 0F 66 90 8A 10 48 FF C0 84 D2 74 5F A8 07 75 F3 49 B8 FF FE FE FE FE FE FE 7E 49 BB 00 01 01 01 01 01 01 81 48 8B 10 4D 8B C8 48 83 C0 08 4C 03 CA 48 F7 D2 49 33 D1 49 23 D3 74 E8 48 8B 50 F8 84 D2 74 51 84 F6 74 47 48 C1 EA 10 84 D2 74 39 84 F6 74 2F 48 C1 EA 10 84 D2 74 21 84 F6 74 17 C1 EA 10 84 D2 74 0A 84 F6 75 B9 48 8D 44 01 FF C3 48 8D 44 01 FE C3 48 8D 44 01 FD C3 48 8D 44 01 FC C3 48 8D 44 01 FB C3 48 8D 44 01 FA C3 48 8D 44 01 F9 C3 48 8D 44 01 F8 C3 }
	condition:
		$1
}

rule file_1_0_0 {
	meta:
		name = "_wspawnlpe"
		size = 893
		refs = "0049 ??_C@_1CC@JBMDNKJP@?$AAf?$AAi?$AAl?$AAe?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0055 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 006a ??_C@_1GO@PJDDHBNO@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 0074 _CrtDbgReportW 0088 _errno 00ab ??_C@_1BG@DEELLFKC@?$AA_?$AAw?$AAs?$AAp?$AAa?$AAw?$AAn?$AAl?$AAp?$AAe?$AA?$AA@ 00b7 _invalid_parameter 00fa ??_C@_1CM@DMCMCPME@?$AA?$CK?$AAf?$AAi?$AAl?$AAe?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 01a7 ??_C@_1CA@MOAFCHEI@?$AAa?$AAr?$AAg?$AAl?$AAi?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0258 ??_C@_1CK@PKCLGCC@?$AA?$CK?$AAa?$AAr?$AAg?$AAl?$AAi?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 02fc _wcapture_argv 0344 _wspawnvpe 036c _free_dbg"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 89 4C 24 08 4C 89 4C 24 20 48 81 EC 78 02 00 00 48 83 BC 24 88 02 00 00 00 74 0A C7 44 24 34 01 00 00 00 EB 08 C7 44 24 34 00 00 00 00 8B 44 24 34 89 44 24 50 83 7C 24 50 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 4F 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 50 00 75 40 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 4F 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 C7 C0 FF FF FF FF E9 AE 02 00 00 48 8B 84 24 88 02 00 00 0F B7 00 85 C0 74 0A C7 44 24 3C 01 00 00 00 EB 08 C7 44 24 3C 00 00 00 00 8B 44 24 3C 89 44 24 4C 83 7C 24 4C 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 50 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 4C 00 75 40 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 50 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 C7 C0 FF FF FF FF E9 FD 01 00 00 48 83 BC 24 90 02 00 00 00 74 0A C7 44 24 48 01 00 00 00 EB 08 C7 44 24 48 00 00 00 00 8B 44 24 48 89 44 24 54 83 7C 24 54 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 51 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 54 00 75 40 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 51 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 C7 C0 FF FF FF FF E9 50 01 00 00 48 8B 84 24 90 02 00 00 0F B7 00 85 C0 74 0A C7 44 24 30 01 00 00 00 EB 08 C7 44 24 30 00 00 00 00 8B 44 24 30 89 44 24 38 83 7C 24 38 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 52 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 38 00 75 40 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 52 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 C7 C0 FF FF FF FF E9 9F 00 00 00 48 8D 84 24 98 02 00 00 48 89 44 24 40 41 B9 40 00 00 00 4C 8D 44 24 70 48 8B 94 24 90 02 00 00 48 8D 4C 24 40 E8 ?? ?? ?? ?? 48 89 44 24 58 48 8B 44 24 40 48 83 C0 08 48 89 44 24 40 48 8B 44 24 40 48 8B 40 F8 48 89 44 24 68 48 C7 44 24 40 00 00 00 00 4C 8B 4C 24 68 4C 8B 44 24 58 48 8B 94 24 88 02 00 00 8B 8C 24 80 02 00 00 E8 ?? ?? ?? ?? 48 89 44 24 60 48 83 7C 24 58 00 74 1B 48 8D 44 24 70 48 39 44 24 58 74 0F BA 02 00 00 00 48 8B 4C 24 58 E8 ?? ?? ?? ?? 48 8B 44 24 60 48 81 C4 78 02 00 00 C3 }
	condition:
		$1
}

rule file_2_0_0 {
	meta:
		name = "_exp2"
		size = 1236
		refs = "00e0 ??_C@_04HPAFEEIN@exp2?$AA@ 00e5 _handle_error 012f ?max_exp2_arg@?1??_exp2@@9@9 0191 ?min_exp2_arg@?1??_exp2@@9@9 0219 __real@3ff0000000000000 02b8 ?log2_lead@?1??_exp2@@9@9 02e6 ?log2_tail@?1??_exp2@@9@9 033d __real@3e9208a80efa0f9c 034b __real@3f985eaf935d972d 0360 __real@3ef0e88e25daf0f3 0375 __real@3feffc6f012164ad 0384 __real@3f437d98a3a06a02 0392 __real@bf885dd726cbfa41 03a7 __real@3fbb6a194bd1cdeb 03bc __real@bfdffc2b5ee8cd41 044c ?one_by_32_lead@?1??_exp2@@9@9 0454 __real@4040000000000000 045c ?log2@?1??_exp2@@9@9 046a splitexp 0499 scaleDouble_1 04bc scaleDouble_2"
	strings:
		$1 = { F2 0F 11 44 24 08 48 81 EC D8 00 00 00 F2 0F 10 84 24 E0 00 00 00 F2 0F 11 84 24 B0 00 00 00 48 8B 84 24 B0 00 00 00 48 89 44 24 70 48 B8 FF FF FF FF FF FF FF 7F 48 8B 4C 24 70 48 23 C8 48 8B C1 48 89 44 24 78 48 B8 00 00 00 00 00 00 90 40 48 39 44 24 78 0F 82 94 01 00 00 48 B8 00 00 00 00 00 00 F0 7F 48 39 44 24 78 0F 82 B2 00 00 00 48 B8 FF FF FF FF FF FF 0F 00 48 8B 4C 24 70 48 23 C8 48 8B C1 48 85 C0 74 66 48 B8 00 00 00 00 00 00 08 00 48 8B 4C 24 70 48 0B C8 48 8B C1 C7 44 24 40 01 00 00 00 0F 57 C0 F2 0F 11 44 24 38 F2 0F 10 84 24 E0 00 00 00 F2 0F 11 44 24 30 C7 44 24 28 21 00 00 00 C7 44 24 20 00 00 00 00 41 B9 01 00 00 00 4C 8B C0 BA 14 00 00 00 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 DE 03 00 00 EB 32 48 B8 00 00 00 00 00 00 00 80 48 8B 4C 24 70 48 23 C8 48 8B C1 48 85 C0 74 0A 0F 57 C0 E9 BA 03 00 00 EB 0E F2 0F 10 84 24 E0 00 00 00 E9 AA 03 00 00 F2 0F 10 84 24 E0 00 00 00 66 0F 2F 05 ?? ?? ?? ?? 76 58 C7 44 24 40 01 00 00 00 0F 57 C0 F2 0F 11 44 24 38 F2 0F 10 84 24 E0 00 00 00 F2 0F 11 44 24 30 C7 44 24 28 22 00 00 00 C7 44 24 20 11 00 00 00 41 B9 03 00 00 00 49 B8 00 00 00 00 00 00 F0 7F BA 14 00 00 00 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 41 03 00 00 EB 62 F2 0F 10 05 ?? ?? ?? ?? 66 0F 2F 84 24 E0 00 00 00 76 4F C7 44 24 40 01 00 00 00 0F 57 C0 F2 0F 11 44 24 38 F2 0F 10 84 24 E0 00 00 00 F2 0F 11 44 24 30 C7 44 24 28 22 00 00 00 C7 44 24 20 12 00 00 00 41 B9 04 00 00 00 45 33 C0 BA 14 00 00 00 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 DD 02 00 00 48 B8 2F 6C EE 64 47 15 B7 3F 48 39 44 24 78 0F 83 17 02 00 00 48 B8 00 00 00 00 00 00 00 3C 48 39 44 24 78 73 1B F2 0F 10 05 ?? ?? ?? ?? F2 0F 58 84 24 E0 00 00 00 E9 A1 02 00 00 E9 E6 01 00 00 F2 0F 10 84 24 E0 00 00 00 F2 0F 11 44 24 68 F2 0F 10 44 24 68 F2 0F 11 84 24 B8 00 00 00 48 8B 84 24 B8 00 00 00 48 89 84 24 88 00 00 00 48 8B 84 24 88 00 00 00 48 25 00 00 00 F8 48 89 84 24 88 00 00 00 48 8B 84 24 88 00 00 00 48 89 84 24 C0 00 00 00 F2 0F 10 84 24 C0 00 00 00 F2 0F 11 44 24 68 F2 0F 10 84 24 E0 00 00 00 F2 0F 5C 44 24 68 F2 0F 11 84 24 A0 00 00 00 F2 0F 10 84 24 E0 00 00 00 F2 0F 59 05 ?? ?? ?? ?? F2 0F 11 84 24 80 00 00 00 F2 0F 10 44 24 68 F2 0F 59 05 ?? ?? ?? ?? F2 0F 5C 84 24 80 00 00 00 F2 0F 10 4C 24 68 F2 0F 59 0D ?? ?? ?? ?? F2 0F 58 C1 F2 0F 10 8C 24 A0 00 00 00 F2 0F 59 0D ?? ?? ?? ?? F2 0F 58 C1 F2 0F 10 8C 24 A0 00 00 00 F2 0F 59 0D ?? ?? ?? ?? F2 0F 58 C1 F2 0F 11 84 24 A8 00 00 00 F2 0F 10 84 24 80 00 00 00 F2 0F 58 84 24 A8 00 00 00 F2 0F 11 44 24 58 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 44 24 58 F2 0F 10 0D ?? ?? ?? ?? F2 0F 58 C8 0F 28 C1 F2 0F 59 44 24 58 F2 0F 10 0D ?? ?? ?? ?? F2 0F 58 C8 0F 28 C1 F2 0F 59 44 24 58 F2 0F 10 0D ?? ?? ?? ?? F2 0F 58 C8 0F 28 C1 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 4C 24 58 F2 0F 10 15 ?? ?? ?? ?? F2 0F 58 D1 0F 28 CA F2 0F 59 4C 24 58 F2 0F 10 15 ?? ?? ?? ?? F2 0F 58 D1 0F 28 CA F2 0F 59 4C 24 58 F2 0F 10 15 ?? ?? ?? ?? F2 0F 58 D1 0F 28 CA F2 0F 59 4C 24 58 F2 0F 10 15 ?? ?? ?? ?? F2 0F 58 D1 0F 28 CA F2 0F 5E C1 F2 0F 11 44 24 60 F2 0F 10 44 24 60 F2 0F 59 84 24 80 00 00 00 F2 0F 10 4C 24 60 F2 0F 59 8C 24 A8 00 00 00 F2 0F 58 C1 F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 44 24 60 E9 AB 00 00 00 48 8D 84 24 98 00 00 00 48 89 44 24 38 48 8D 84 24 90 00 00 00 48 89 44 24 30 48 8D 44 24 50 48 89 44 24 28 0F 57 C0 F2 0F 11 44 24 20 F2 0F 10 1D ?? ?? ?? ?? F2 0F 10 15 ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? F2 0F 10 84 24 E0 00 00 00 E8 ?? ?? ?? ?? 81 7C 24 50 02 FC FF FF 7E 2D 81 7C 24 50 FF 03 00 00 7D 23 F2 0F 10 84 24 90 00 00 00 F2 0F 58 84 24 98 00 00 00 8B 54 24 50 E8 ?? ?? ?? ?? F2 0F 11 44 24 60 EB 21 F2 0F 10 84 24 90 00 00 00 F2 0F 58 84 24 98 00 00 00 8B 54 24 50 E8 ?? ?? ?? ?? F2 0F 11 44 24 60 F2 0F 10 44 24 60 48 81 C4 D8 00 00 00 C3 }
	condition:
		$1
}

rule file_2_1_0 {
	meta:
		name = "scaleDouble_1"
		size = 61
	strings:
		$1 = { 89 54 24 10 F2 0F 11 44 24 08 48 83 EC 18 48 63 44 24 28 48 05 FF 03 00 00 48 C1 E0 34 48 89 04 24 F2 0F 10 04 24 F2 0F 11 44 24 08 F2 0F 10 44 24 20 F2 0F 59 44 24 08 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_2_2_0 {
	meta:
		name = "scaleDouble_2"
		size = 127
	strings:
		$1 = { 89 54 24 10 F2 0F 11 44 24 08 48 83 EC 38 8B 44 24 48 99 2B C2 D1 F8 89 04 24 8B 04 24 8B 4C 24 48 2B C8 8B C1 89 44 24 04 48 63 04 24 48 05 FF 03 00 00 48 C1 E0 34 48 89 44 24 08 F2 0F 10 44 24 08 F2 0F 11 44 24 18 48 63 44 24 04 48 05 FF 03 00 00 48 C1 E0 34 48 89 44 24 10 F2 0F 10 44 24 10 F2 0F 11 44 24 20 F2 0F 10 44 24 40 F2 0F 59 44 24 18 F2 0F 59 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_2_3_0 {
	meta:
		name = "splitexp"
		size = 521
		refs = "0038 __real@0000000000000000 0048 __real@3fe0000000000000 00af ?two_to_jby32_lead_table@?1??splitexp@@9@9 00c6 ?two_to_jby32_trail_table@?1??splitexp@@9@9 013c __real@3f56c1728d739765 0144 __real@3f811115b7aa905e 0160 __real@3fa5555555545d4e 017c __real@3fc5555555548f7c"
	strings:
		$1 = { F2 0F 11 5C 24 20 F2 0F 11 54 24 18 F2 0F 11 4C 24 10 F2 0F 11 44 24 08 48 83 EC 48 F2 0F 10 44 24 50 F2 0F 59 44 24 60 F2 0F 11 44 24 08 F2 0F 10 44 24 08 66 0F 2F 05 ?? ?? ?? ?? 76 17 F2 0F 10 44 24 08 F2 0F 58 05 ?? ?? ?? ?? F2 0F 2C C0 89 04 24 EB 15 F2 0F 10 44 24 08 F2 0F 5C 05 ?? ?? ?? ?? F2 0F 2C C0 89 04 24 F2 0F 2A 04 24 F2 0F 59 44 24 68 F2 0F 10 4C 24 50 F2 0F 5C C8 0F 28 C1 F2 0F 11 44 24 18 8B 04 24 F7 D8 F2 0F 2A C0 F2 0F 59 44 24 70 F2 0F 11 44 24 10 8B 04 24 83 E0 1F 89 44 24 04 48 63 44 24 04 48 8D 0D ?? ?? ?? ?? F2 0F 10 04 C1 F2 0F 11 44 24 20 48 63 44 24 04 48 8D 0D ?? ?? ?? ?? F2 0F 10 04 C1 F2 0F 11 44 24 28 8B 44 24 04 8B 0C 24 2B C8 8B C1 99 83 E2 1F 03 C2 C1 F8 05 48 8B 4C 24 78 89 01 F2 0F 10 44 24 18 F2 0F 59 44 24 58 F2 0F 11 44 24 18 F2 0F 10 44 24 10 F2 0F 59 44 24 58 F2 0F 11 44 24 10 F2 0F 10 44 24 18 F2 0F 58 44 24 10 F2 0F 11 44 24 08 F2 0F 10 44 24 08 F2 0F 59 44 24 08 F2 0F 10 4C 24 08 F2 0F 59 0D ?? ?? ?? ?? F2 0F 10 15 ?? ?? ?? ?? F2 0F 58 D1 0F 28 CA F2 0F 10 54 24 08 F2 0F 59 D1 0F 28 CA F2 0F 10 15 ?? ?? ?? ?? F2 0F 58 D1 0F 28 CA F2 0F 10 54 24 08 F2 0F 59 D1 0F 28 CA F2 0F 10 15 ?? ?? ?? ?? F2 0F 58 D1 0F 28 CA F2 0F 10 54 24 08 F2 0F 59 D1 0F 28 CA F2 0F 10 15 ?? ?? ?? ?? F2 0F 58 D1 0F 28 CA F2 0F 59 C1 F2 0F 10 4C 24 10 F2 0F 58 C8 0F 28 C1 F2 0F 10 4C 24 18 F2 0F 58 C8 0F 28 C1 F2 0F 11 44 24 30 48 8B 84 24 80 00 00 00 F2 0F 10 44 24 20 F2 0F 11 00 F2 0F 10 44 24 20 F2 0F 58 44 24 28 F2 0F 59 44 24 30 F2 0F 10 4C 24 28 F2 0F 58 C8 0F 28 C1 48 8B 84 24 88 00 00 00 F2 0F 11 00 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_3_0_0 {
	meta:
		name = "_lfind_s"
		size = 973
		refs = "004c ??_C@_1BI@OEOAAOGG@?$AAk?$AAe?$AAy?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0058 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 006d ??_C@_1GI@KJPINCJP@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 0077 _CrtDbgReportW 008b _errno 00ae ??_C@_1BC@LKOPFLDJ@?$AA_?$AAl?$AAf?$AAi?$AAn?$AAd?$AA_?$AAs?$AA?$AA@ 00ba _invalid_parameter 00f4 ??_C@_1BI@LBPPPCD@?$AAn?$AAu?$AAm?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 01a6 ??_C@_1DE@BOPBJJCA@?$AAb?$AAa?$AAs?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AA?$CK?$AAn?$AAu?$AAm?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 024e ??_C@_1BE@NJBEBBME@?$AAw?$AAi?$AAd?$AAt?$AAh?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 02f6 ??_C@_1CA@OIBGFNKD@?$AAc?$AAo?$AAm?$AAp?$AAa?$AAr?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 68 C7 44 24 30 00 00 00 00 48 83 7C 24 70 00 74 0A C7 44 24 54 01 00 00 00 EB 08 C7 44 24 54 00 00 00 00 8B 44 24 54 89 44 24 3C 83 7C 24 3C 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 53 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 3C 00 75 3B E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 53 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 E9 03 03 00 00 48 83 BC 24 80 00 00 00 00 74 0A C7 44 24 4C 01 00 00 00 EB 08 C7 44 24 4C 00 00 00 00 8B 44 24 4C 89 44 24 44 83 7C 24 44 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 54 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 44 00 75 3B E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 54 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 E9 5B 02 00 00 48 83 7C 24 78 00 75 17 48 8B 84 24 80 00 00 00 83 38 00 74 0A C7 44 24 34 00 00 00 00 EB 08 C7 44 24 34 01 00 00 00 8B 44 24 34 89 44 24 38 83 7C 24 38 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 55 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 38 00 75 3B E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 55 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 E9 A9 01 00 00 48 83 BC 24 88 00 00 00 00 76 0A C7 44 24 40 01 00 00 00 EB 08 C7 44 24 40 00 00 00 00 8B 44 24 40 89 44 24 48 83 7C 24 48 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 56 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 48 00 75 3B E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 56 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 E9 01 01 00 00 48 83 BC 24 90 00 00 00 00 74 0A C7 44 24 50 01 00 00 00 EB 08 C7 44 24 50 00 00 00 00 8B 44 24 50 89 44 24 58 83 7C 24 58 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 57 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 58 00 75 38 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 57 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 EB 5C 48 8B 84 24 80 00 00 00 8B 00 39 44 24 30 73 4A 4C 8B 44 24 78 48 8B 54 24 70 48 8B 8C 24 98 00 00 00 FF 94 24 90 00 00 00 85 C0 75 09 48 8B 44 24 78 EB 28 EB 22 48 8B 84 24 88 00 00 00 48 8B 4C 24 78 48 03 C8 48 8B C1 48 89 44 24 78 8B 44 24 30 FF C0 89 44 24 30 EB A6 33 C0 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_4_0_0 {
	meta:
		name = "__common_dsinh_cout_rare"
		size = 2080
		refs = "006b _vmldSinhHATab 0156 _2il0floatpacket_88"
	strings:
		$1 = { 55 48 81 EC E0 00 00 00 33 C0 4C 8B 01 4D 8B C8 49 C1 E9 30 F2 0F 10 11 41 81 E1 F0 7F 00 00 41 C1 E9 04 44 0F 29 7C 24 60 41 81 F9 FF 07 00 00 44 0F 29 74 24 70 44 0F 29 AC 24 80 00 00 00 44 0F 29 A4 24 90 00 00 00 44 0F 29 9C 24 A0 00 00 00 44 0F 29 94 24 B0 00 00 00 44 0F 29 8C 24 C0 00 00 00 0F 29 74 24 50 4C 8B 1D ?? ?? ?? ?? 4C 89 84 24 D0 00 00 00 0F 84 97 07 00 00 45 85 C9 0F 8E 62 07 00 00 49 8B C8 48 C1 E9 38 4C 89 44 24 38 83 E1 7F 88 4C 24 3F 41 81 F9 C9 03 00 00 0F 8E E3 06 00 00 F2 0F 10 44 24 38 F2 0F 10 0D ?? ?? ?? ?? 66 0F 2F C8 0F 86 B4 06 00 00 F2 0F 10 0D ?? ?? ?? ?? 66 0F 2F C8 0F 86 44 05 00 00 66 0F 2F 05 ?? ?? ?? ?? 0F 82 C9 04 00 00 F2 44 0F 10 2D ?? ?? ?? ?? 4C 8D 15 ?? ?? ?? ?? F2 44 0F 59 E8 F2 44 0F 10 25 ?? ?? ?? ?? F2 0F 10 25 ?? ?? ?? ?? 4C 89 5C 24 48 49 C1 EB 30 F2 44 0F 58 2D ?? ?? ?? ?? F2 44 0F 11 6C 24 30 41 81 E3 0F 80 FF FF F2 44 0F 10 74 24 30 8B 6C 24 30 44 8B CD 41 C1 E9 06 83 E5 3F 49 C1 E8 38 F2 44 0F 5C 35 ?? ?? ?? ?? F2 45 0F 59 E6 41 8D 89 FF 03 00 00 44 0F 57 35 ?? ?? ?? ?? 41 81 C1 FE 03 00 00 F2 44 0F 59 35 ?? ?? ?? ?? F2 41 0F 5C C4 44 0F 28 C8 0F 28 E8 41 81 E1 FF 07 00 00 F7 D9 41 C1 E1 04 83 C1 FC 45 0B D9 44 8D 4C 2D 00 81 E1 FF 07 00 00 66 44 89 5C 24 4E 41 81 E3 0F 80 FF FF C1 E1 04 8D 6C 2D 01 44 0B D9 41 83 E0 80 F2 45 0F 58 CE F2 44 0F 11 4C 24 40 F2 44 0F 10 54 24 40 F2 41 0F 5C EA F2 0F 11 6C 24 20 F2 44 0F 10 5C 24 40 F2 0F 10 74 24 20 F2 44 0F 58 DE F2 44 0F 11 5C 24 28 F2 44 0F 10 7C 24 20 F2 45 0F 58 F7 F2 44 0F 10 7C 24 48 F2 44 0F 11 74 24 20 F2 44 0F 10 5C 24 28 66 44 89 5C 24 4E 4D 8B DA F2 41 0F 5C C3 F2 0F 11 44 24 28 F2 44 0F 10 64 24 20 F2 44 0F 10 6C 24 28 F2 45 0F 58 E5 F2 44 0F 11 64 24 28 F2 0F 10 6C 24 40 0F 28 D5 44 0F 28 DD F2 0F 59 D4 0F 28 CD F2 44 0F 59 DD F2 0F 10 74 24 28 F2 0F 11 54 24 40 F2 44 0F 10 4C 24 40 F2 41 0F 10 14 EA 49 8B EA F2 41 0F 59 D7 F2 44 0F 5C CD F2 44 0F 11 4C 24 20 F2 44 0F 10 0D ?? ?? ?? ?? F2 45 0F 59 CB F2 0F 10 5C 24 40 F2 44 0F 10 54 24 20 F2 41 0F 5C DA F2 44 0F 10 15 ?? ?? ?? ?? F2 45 0F 59 D3 F2 44 0F 58 0D ?? ?? ?? ?? F2 0F 11 5C 24 40 F2 0F 10 44 24 40 F2 45 0F 59 CB F2 0F 5C C8 F2 44 0F 58 15 ?? ?? ?? ?? F2 44 0F 58 0D ?? ?? ?? ?? F2 45 0F 59 D3 F2 45 0F 59 CB F2 44 0F 59 D5 F2 43 0F 10 04 CA 41 F7 D9 F2 0F 11 4C 24 20 F2 41 0F 59 C7 F2 44 0F 10 5C 24 48 41 8D 89 80 00 00 00 41 81 C1 81 00 00 00 44 0F 28 F0 F2 44 0F 10 6C 24 40 F2 41 0F 10 0C CB F2 44 0F 10 64 24 20 F2 41 0F 59 CB F2 42 0F 10 5C CD 00 F2 44 0F 5C F1 F2 41 0F 59 DB F2 44 0F 11 74 24 40 44 0F 28 D8 F2 44 0F 10 7C 24 40 F2 45 0F 5C DF F2 44 0F 5C D9 F2 44 0F 11 5C 24 20 F2 44 0F 10 5C 24 40 F2 44 0F 10 74 24 20 45 0F 28 FB F2 44 0F 5C F3 F2 44 0F 58 F2 F2 0F 58 D3 F2 45 0F 58 FE F2 44 0F 11 7C 24 40 F2 44 0F 10 7C 24 40 F2 45 0F 5C DF 44 0F 28 F8 F2 44 0F 58 F9 F2 45 0F 58 DE F2 44 0F 11 5C 24 20 F2 44 0F 10 74 24 40 F2 44 0F 10 5C 24 20 F2 44 0F 11 7C 24 40 F2 44 0F 10 7C 24 40 F2 41 0F 5C C7 F2 0F 58 C1 F2 0F 11 44 24 20 F2 0F 10 4C 24 40 F2 0F 10 44 24 20 0F 28 D9 F2 0F 58 D0 F2 0F 58 DA F2 0F 11 5C 24 40 F2 0F 10 44 24 40 F2 0F 5C C8 F2 0F 58 CA F2 0F 11 4C 24 20 F2 0F 10 44 24 40 F2 0F 59 E0 0F 28 C8 F2 0F 10 5C 24 20 F2 0F 11 64 24 40 F2 0F 10 64 24 40 F2 0F 59 EB F2 0F 5C E0 F2 0F 11 64 24 20 F2 44 0F 10 7C 24 40 F2 0F 10 54 24 20 F2 44 0F 5C FA F2 44 0F 11 7C 24 40 44 0F 28 FE F2 0F 10 64 24 40 F2 44 0F 59 FB F2 0F 5C CC F2 0F 59 F0 F2 0F 11 4C 24 20 0F 28 CB F2 41 0F 59 CA F2 44 0F 59 D0 F2 44 0F 58 F9 41 0F 28 CB F2 41 0F 59 C9 F2 45 0F 59 CE F2 44 0F 58 F9 F2 0F 10 54 24 40 41 0F 28 CC F2 0F 10 64 24 20 F2 44 0F 58 FD F2 0F 59 CC F2 41 0F 59 E5 F2 44 0F 59 EA F2 44 0F 58 FE F2 44 0F 59 E2 F2 45 0F 58 DF 41 0F 28 EA 41 0F 28 D5 F2 41 0F 58 E9 F2 0F 11 6C 24 40 F2 0F 10 74 24 40 F2 44 0F 5C D6 F2 45 0F 58 D1 45 0F 28 CE F2 44 0F 11 54 24 20 F2 0F 10 5C 24 40 F2 0F 10 44 24 20 F2 0F 58 D3 F2 44 0F 58 D8 F2 0F 11 54 24 40 F2 44 0F 58 D9 F2 44 0F 58 DC F2 0F 10 64 24 40 F2 44 0F 5C EC F2 45 0F 58 DC F2 44 0F 58 EB F2 44 0F 11 6C 24 20 F2 44 0F 10 54 24 40 F2 0F 10 6C 24 20 F2 45 0F 58 CA F2 44 0F 58 DD F2 44 0F 11 4C 24 40 F2 0F 10 74 24 40 F2 44 0F 5C F6 F2 45 0F 58 F2 F2 44 0F 11 74 24 20 F2 44 0F 10 6C 24 40 F2 44 0F 10 64 24 20 F2 45 0F 58 DC F2 45 0F 58 DD F2 44 0F 11 5C 24 38 44 0F B6 54 24 3F 41 83 E2 7F 45 0B D0 44 88 54 24 3F 48 8B 4C 24 38 48 89 0A E9 FA 01 00 00 0F 28 D0 F2 0F 59 D0 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 CA 8A 8C 24 D7 00 00 00 80 E1 80 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 D1 F2 0F 59 D0 F2 0F 58 C2 F2 0F 11 44 24 38 40 8A 6C 24 3F 40 80 E5 7F 40 0A E9 40 88 6C 24 3F 4C 8B 44 24 38 4C 89 02 E9 8D 01 00 00 F2 0F 10 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? F2 0F 59 C8 F2 0F 10 15 ?? ?? ?? ?? F2 0F 10 1D ?? ?? ?? ?? 4C 89 5C 24 48 F2 0F 58 0D ?? ?? ?? ?? F2 0F 11 4C 24 30 F2 0F 10 64 24 30 F2 0F 10 0D ?? ?? ?? ?? 8B 4C 24 30 44 8B C9 41 83 E1 3F F2 0F 5C 25 ?? ?? ?? ?? F2 0F 59 D4 43 8D 2C 09 F2 0F 59 E3 F2 0F 5C C2 47 8D 54 09 01 F2 0F 5C C4 F2 0F 59 C8 C1 E9 06 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 81 C1 FE 03 00 00 81 E1 FF 07 00 00 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 81 F9 FE 07 00 00 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 59 C8 F2 0F 58 C8 F2 41 0F 10 04 E8 F2 0F 59 C8 49 8B E8 F2 42 0F 58 4C D5 00 F2 0F 58 C8 77 29 49 C1 EB 30 C1 E1 04 41 81 E3 0F 80 FF FF 44 0B D9 66 44 89 5C 24 4E F2 0F 10 44 24 48 F2 0F 59 C8 F2 0F 11 4C 24 38 EB 35 FF C9 81 E1 FF 07 00 00 0F B7 6C 24 4E C1 E1 04 81 E5 0F 80 FF FF 0B E9 66 89 6C 24 4E F2 0F 10 44 24 48 F2 0F 59 C8 F2 0F 59 0D ?? ?? ?? ?? F2 0F 11 4C 24 38 40 8A 6C 24 3F 8A 8C 24 D7 00 00 00 40 80 E5 7F 80 E1 80 40 0A E9 40 88 6C 24 3F 4C 8B 44 24 38 4C 89 02 EB 2F F2 0F 10 05 ?? ?? ?? ?? B8 03 00 00 00 F2 0F 59 C2 F2 0F 11 02 EB 18 F2 0F 10 05 ?? ?? ?? ?? F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C2 F2 0F 11 02 0F 28 74 24 50 44 0F 28 8C 24 C0 00 00 00 44 0F 28 94 24 B0 00 00 00 44 0F 28 9C 24 A0 00 00 00 44 0F 28 A4 24 90 00 00 00 44 0F 28 AC 24 80 00 00 00 44 0F 28 74 24 70 44 0F 28 7C 24 60 48 81 C4 E0 00 00 00 5D C3 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 D0 F2 0F 11 54 24 40 F2 0F 10 4C 24 40 4C 89 5C 24 48 F2 0F 58 8C 24 D0 00 00 00 F2 0F 11 0A EB 8D F2 0F 58 D2 F2 0F 11 12 EB 83 66 90 }
	condition:
		$1
}

rule file_5_0_0 {
	meta:
		name = "_finite"
		size = 73
	strings:
		$1 = { F2 0F 11 44 24 08 48 83 EC 18 F2 0F 10 44 24 20 F2 0F 11 04 24 48 8B 04 24 48 89 44 24 08 48 B8 FF FF FF FF FF FF FF 7F 48 8B 4C 24 08 48 23 C8 48 8B C1 48 B9 00 00 00 00 00 00 F0 7F 48 2B C1 48 C1 E8 3F 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_6_0_0 {
	meta:
		name = "_makepath"
		size = 76
		refs = "0043 _makepath_s"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 60 48 89 44 24 28 48 8B 44 24 58 48 89 44 24 20 4C 8B 4C 24 50 4C 8B 44 24 48 48 C7 C2 FF FF FF FF 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_659_0_0 {
	meta:
		name = "_wmakepath"
		size = 76
		refs = "0043 _wmakepath_s"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 60 48 89 44 24 28 48 8B 44 24 58 48 89 44 24 20 4C 8B 4C 24 50 4C 8B 44 24 48 48 C7 C2 FF FF FF FF 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_7_0_0 {
	meta:
		name = "wcscspn"
		size = 150
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 18 48 8B 44 24 20 48 89 04 24 48 8B 04 24 0F B7 00 85 C0 74 5D 48 8B 44 24 28 48 89 44 24 08 EB 0E 48 8B 44 24 08 48 83 C0 02 48 89 44 24 08 48 8B 44 24 08 0F B7 00 85 C0 74 29 48 8B 44 24 08 0F B7 00 48 8B 0C 24 0F B7 09 3B C1 75 14 48 8B 44 24 20 48 8B 0C 24 48 2B C8 48 8B C1 48 D1 F8 EB 22 EB BD 48 8B 04 24 48 83 C0 02 48 89 04 24 EB 98 48 8B 44 24 20 48 8B 0C 24 48 2B C8 48 8B C1 48 D1 F8 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_8_0_0 {
	meta:
		name = "_getcwd"
		size = 45
		refs = "001a _getdcwd"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 38 44 8B 44 24 48 48 8B 54 24 40 33 C9 E8 ?? ?? ?? ?? 48 89 44 24 20 48 8B 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_720_0_0 {
	meta:
		name = "_wgetcwd"
		size = 45
		refs = "001a _wgetdcwd"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 38 44 8B 44 24 48 48 8B 54 24 40 33 C9 E8 ?? ?? ?? ?? 48 89 44 24 20 48 8B 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_8_1_0 {
	meta:
		name = "_getcwd_dbg"
		size = 78
		refs = "003b _getdcwd_dbg"
	strings:
		$1 = { 4C 89 4C 24 20 44 89 44 24 18 89 54 24 10 48 89 4C 24 08 48 83 EC 48 8B 44 24 70 89 44 24 28 48 8B 44 24 68 48 89 44 24 20 44 8B 4C 24 60 44 8B 44 24 58 48 8B 54 24 50 33 C9 E8 ?? ?? ?? ?? 48 89 44 24 30 48 8B 44 24 30 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_720_1_0 {
	meta:
		name = "_wgetcwd_dbg"
		size = 78
		refs = "003b _wgetdcwd_dbg"
	strings:
		$1 = { 4C 89 4C 24 20 44 89 44 24 18 89 54 24 10 48 89 4C 24 08 48 83 EC 48 8B 44 24 70 89 44 24 28 48 8B 44 24 68 48 89 44 24 20 44 8B 4C 24 60 44 8B 44 24 58 48 8B 54 24 50 33 C9 E8 ?? ?? ?? ?? 48 89 44 24 30 48 8B 44 24 30 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_8_2_0 {
	meta:
		name = "_getdcwd"
		size = 65
		refs = "0038 _getdcwd_dbg"
	strings:
		$1 = { 44 89 44 24 18 48 89 54 24 10 89 4C 24 08 48 83 EC 38 C7 44 24 28 00 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 01 00 00 00 44 8B 44 24 50 48 8B 54 24 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_720_2_0 {
	meta:
		name = "_wgetdcwd"
		size = 65
		refs = "0038 _wgetdcwd_dbg"
	strings:
		$1 = { 44 89 44 24 18 48 89 54 24 10 89 4C 24 08 48 83 EC 38 C7 44 24 28 00 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 01 00 00 00 44 8B 44 24 50 48 8B 54 24 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_8_3_0 {
	meta:
		name = "_getdcwd_dbg"
		size = 952
		refs = "002d _validdrive 003a __doserrno 006e ??_C@_1CI@ICBAMKHM@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAD?$AAr?$AAi?$AAv?$AAe?$AA?$CC?$AA?0?$AA0?$AA?$CJ?$AA?$AA@ 007a ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 008f ??_C@_1GK@OLGNKDAB@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 0099 _CrtDbgReportW 00ad _errno 00d0 ??_C@_1BK@HFHLJEKP@?$AA_?$AAg?$AAe?$AAt?$AAd?$AAc?$AAw?$AAd?$AA_?$AAd?$AAb?$AAg?$AA?$AA@ 00dc _invalid_parameter 00ea _getdrive 0132 ??_C@_1BK@NOHKJANJ@?$AA?$CI?$AAm?$AAa?$AAx?$AAl?$AAe?$AAn?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$CJ?$AA?$AA@ 022b __report_rangecheckfailure 0283 __imp_GetFullPathNameA 0294 __imp_GetLastError 029b _dosmaperr 033e _calloc_dbg"
	strings:
		$1 = { 44 89 4C 24 20 44 89 44 24 18 48 89 54 24 10 89 4C 24 08 48 83 EC 78 83 BC 24 80 00 00 00 00 0F 84 C4 00 00 00 8B 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 85 AE 00 00 00 E8 ?? ?? ?? ?? C7 00 0F 00 00 00 33 C0 85 C0 74 0A C7 44 24 48 01 00 00 00 EB 08 C7 44 24 48 00 00 00 00 8B 44 24 48 89 44 24 4C 83 7C 24 4C 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 9F 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 4C 00 75 3B E8 ?? ?? ?? ?? C7 00 0D 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 9F 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 E9 CC 02 00 00 EB 0C E8 ?? ?? ?? ?? 89 84 24 80 00 00 00 48 83 BC 24 88 00 00 00 00 0F 84 C9 00 00 00 83 BC 24 90 00 00 00 00 7E 0A C7 44 24 3C 01 00 00 00 EB 08 C7 44 24 3C 00 00 00 00 8B 44 24 3C 89 44 24 44 83 7C 24 44 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 AC 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 44 00 75 3B E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 AC 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 E9 08 02 00 00 8B 84 24 90 00 00 00 89 44 24 38 B8 01 00 00 00 48 6B C0 00 48 8B 8C 24 88 00 00 00 C6 04 01 00 EB 08 C7 44 24 38 00 00 00 00 83 BC 24 80 00 00 00 00 74 5C 8B 84 24 80 00 00 00 83 C0 40 B9 01 00 00 00 48 6B C9 00 88 44 0C 34 B8 01 00 00 00 48 6B C0 01 C6 44 04 34 3A B8 01 00 00 00 48 6B C0 02 C6 44 04 34 2E B8 01 00 00 00 48 6B C0 03 48 89 44 24 60 48 83 7C 24 60 04 73 02 EB 05 E8 ?? ?? ?? ?? 48 8B 44 24 60 C6 44 04 34 00 EB 30 B8 01 00 00 00 48 6B C0 00 C6 44 04 34 2E 48 C7 44 24 58 01 00 00 00 48 83 7C 24 58 04 73 02 EB 05 E8 ?? ?? ?? ?? 48 8B 44 24 58 C6 44 04 34 00 4C 8D 4C 24 68 4C 8B 84 24 88 00 00 00 8B 54 24 38 48 8D 4C 24 34 FF 15 ?? ?? ?? ?? 89 44 24 30 83 7C 24 30 00 75 14 FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 33 C0 E9 0D 01 00 00 48 83 BC 24 88 00 00 00 00 74 34 8B 44 24 38 39 44 24 30 7D 0D 48 8B 84 24 88 00 00 00 E9 EB 00 00 00 E8 ?? ?? ?? ?? C7 00 22 00 00 00 48 8B 84 24 88 00 00 00 C6 00 00 33 C0 E9 CE 00 00 00 8B 84 24 90 00 00 00 39 44 24 30 7E 0A 8B 44 24 30 89 44 24 40 EB 0B 8B 84 24 90 00 00 00 89 44 24 40 8B 44 24 40 89 84 24 90 00 00 00 48 63 84 24 90 00 00 00 8B 8C 24 A8 00 00 00 89 4C 24 20 4C 8B 8C 24 A0 00 00 00 44 8B 84 24 98 00 00 00 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 48 89 44 24 50 48 83 7C 24 50 00 75 1A E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E8 ?? ?? ?? ?? C7 00 08 00 00 00 33 C0 EB 4A 4C 8D 4C 24 68 4C 8B 44 24 50 8B 94 24 90 00 00 00 48 8D 4C 24 34 FF 15 ?? ?? ?? ?? 89 44 24 30 83 7C 24 30 00 74 0D 8B 84 24 90 00 00 00 39 44 24 30 7C 11 FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 33 C0 EB 05 48 8B 44 24 50 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_8_4_0 {
	meta:
		name = "_validdrive"
		size = 381
		refs = "000b __security_cookie 0023 __doserrno 0057 ??_C@_1DE@JLKLCHND@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAD?$AAr?$AAi?$AAv?$AAe?$AA?5?$AAI?$AAn?$AAd?$AAe?$AAx?$AA?$CC?$AA?0?$AA0?$AA?$CJ?$AA?$AA@ 0063 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0078 ??_C@_1GK@OLGNKDAB@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 0082 _CrtDbgReportW 0096 _errno 00b9 ??_C@_1BI@HIJOLDJO@?$AA_?$AAv?$AAa?$AAl?$AAi?$AAd?$AAd?$AAr?$AAi?$AAv?$AAe?$AA?$AA@ 00c5 _invalid_parameter 0135 __report_rangecheckfailure 014c __imp_GetDriveTypeW 0174 __security_check_cookie"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 68 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 50 83 7C 24 70 1A 0F 86 AE 00 00 00 E8 ?? ?? ?? ?? C7 00 0F 00 00 00 33 C0 85 C0 74 0A C7 44 24 34 01 00 00 00 EB 08 C7 44 24 34 00 00 00 00 8B 44 24 34 89 44 24 38 83 7C 24 38 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 08 01 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 38 00 75 3B E8 ?? ?? ?? ?? C7 00 0D 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 08 01 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 E9 9B 00 00 00 83 7C 24 70 00 75 0A B8 01 00 00 00 E9 8A 00 00 00 8B 44 24 70 83 C0 40 B9 02 00 00 00 48 6B C9 00 66 89 44 0C 48 B8 02 00 00 00 48 6B C0 01 B9 3A 00 00 00 66 89 4C 04 48 B8 02 00 00 00 48 6B C0 02 B9 5C 00 00 00 66 89 4C 04 48 B8 02 00 00 00 48 6B C0 03 48 89 44 24 40 48 83 7C 24 40 08 73 02 EB 05 E8 ?? ?? ?? ?? 33 C0 48 8B 4C 24 40 66 89 44 0C 48 48 8D 4C 24 48 FF 15 ?? ?? ?? ?? 89 44 24 30 83 7C 24 30 00 74 07 83 7C 24 30 01 75 04 33 C0 EB 05 B8 01 00 00 00 48 8B 4C 24 50 48 33 CC E8 ?? ?? ?? ?? 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_9_0_0 {
	meta:
		name = "wcscat_s"
		size = 1577
		refs = "0050 ??_C@_1FC@PFMLEHKI@?$AA?$CI?$AA?$CI?$AA_?$AAD?$AAs?$AAt?$AA?$CJ?$AA?$CJ?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?$CI?$AA_?$AAS?$AAi?$AAz?$AAe?$AAI?$AAn?$AAW?$AAo?$AAr@ 005c ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0071 ??_C@_1HC@LMNIDGBJ@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 007b _CrtDbgReportW 008f _errno 00b2 ??_C@_1BC@PLIEPKPJ@?$AAw?$AAc?$AAs?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$AA@ 00be _invalid_parameter 011a __crtDebugFillThreshold 015b memset 018e ??_C@_1CG@OFBJMIGJ@?$AA?$CI?$AA?$CI?$AA?$CI?$AA_?$AAS?$AAr?$AAc?$AA?$CJ?$AA?$CJ?$AA?$CJ?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 02e8 ??_C@_1DM@FHLMIEG@?$AAS?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AAi?$AAs?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAn?$AAu?$AAl?$AAl?$AA?5?$AAt?$AAe?$AAr?$AAm?$AAi?$AAn?$AAa?$AAt?$AAe?$AAd?$AA?$AA@ 031b ??_C@_1FA@MJKDNFFB@?$AA?$CI?$AAL?$AA?$CC?$AAS?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AAi?$AAs?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAn?$AAu?$AAl?$AAl?$AA?5?$AAt?$AAe?$AAr?$AAm?$AAi?$AAn?$AAa?$AAt?$AAe?$AAd@ 0489 ??_C@_1CI@HCPHDDLE@?$AAB?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AAi?$AAs?$AA?5?$AAt?$AAo?$AAo?$AA?5?$AAs?$AAm?$AAa?$AAl?$AAl?$AA?$AA@ 04bc ??_C@_1DM@MADKGDLO@?$AA?$CI?$AAL?$AA?$CC?$AAB?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AAi?$AAs?$AA?5?$AAt?$AAo?$AAo?$AA?5?$AAs?$AAm?$AAa?$AAl?$AAl?$AA?$CC?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA0?$AA?$CJ?$AA?$AA@"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 81 EC 98 00 00 00 48 83 BC 24 A0 00 00 00 00 74 15 48 83 BC 24 A8 00 00 00 00 76 0A C7 44 24 4C 01 00 00 00 EB 08 C7 44 24 4C 00 00 00 00 8B 44 24 4C 89 44 24 5C 83 7C 24 5C 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 12 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 5C 00 75 3E E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 12 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 16 00 00 00 E9 55 05 00 00 48 83 BC 24 B0 00 00 00 00 0F 85 2F 01 00 00 33 C0 48 8B 8C 24 A0 00 00 00 66 89 01 48 83 BC 24 A8 00 00 00 FF 74 6C 48 81 BC 24 A8 00 00 00 FF FF FF 7F 74 5E 48 83 BC 24 A8 00 00 00 01 76 53 48 8B 84 24 A8 00 00 00 48 FF C8 48 39 05 ?? ?? ?? ?? 73 0E 48 8B 05 ?? ?? ?? ?? 48 89 44 24 78 EB 10 48 8B 84 24 A8 00 00 00 48 FF C8 48 89 44 24 78 48 8B 44 24 78 48 D1 E0 48 8B 8C 24 A0 00 00 00 48 83 C1 02 4C 8B C0 BA FE 00 00 00 E8 ?? ?? ?? ?? 48 83 BC 24 B0 00 00 00 00 74 0A C7 44 24 48 01 00 00 00 EB 08 C7 44 24 48 00 00 00 00 8B 44 24 48 89 44 24 54 83 7C 24 54 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 13 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 54 00 75 3E E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 13 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 16 00 00 00 E9 17 04 00 00 48 8B 84 24 A0 00 00 00 48 89 44 24 38 48 8B 84 24 A8 00 00 00 48 89 44 24 30 48 83 7C 24 30 00 76 29 48 8B 44 24 38 0F B7 00 85 C0 74 1D 48 8B 44 24 38 48 83 C0 02 48 89 44 24 38 48 8B 44 24 30 48 FF C8 48 89 44 24 30 EB CF 48 83 7C 24 30 00 0F 85 36 01 00 00 33 C0 48 8B 8C 24 A0 00 00 00 66 89 01 48 83 BC 24 A8 00 00 00 FF 74 6C 48 81 BC 24 A8 00 00 00 FF FF FF 7F 74 5E 48 83 BC 24 A8 00 00 00 01 76 53 48 8B 84 24 A8 00 00 00 48 FF C8 48 39 05 ?? ?? ?? ?? 73 0E 48 8B 05 ?? ?? ?? ?? 48 89 44 24 68 EB 10 48 8B 84 24 A8 00 00 00 48 FF C8 48 89 44 24 68 48 8B 44 24 68 48 D1 E0 48 8B 8C 24 A0 00 00 00 48 83 C1 02 4C 8B C0 BA FE 00 00 00 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 85 C0 74 10 33 C0 85 C0 74 0A C7 44 24 58 01 00 00 00 EB 08 C7 44 24 58 00 00 00 00 8B 44 24 58 89 44 24 50 83 7C 24 50 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 20 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 50 00 75 3E E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 20 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 16 00 00 00 E9 8A 02 00 00 48 8B 44 24 38 48 8B 8C 24 B0 00 00 00 0F B7 09 66 89 08 48 8B 44 24 38 0F B7 00 89 44 24 60 48 8B 44 24 38 48 83 C0 02 48 89 44 24 38 48 8B 84 24 B0 00 00 00 48 83 C0 02 48 89 84 24 B0 00 00 00 83 7C 24 60 00 74 17 48 8B 44 24 30 48 FF C8 48 89 44 24 30 48 83 7C 24 30 00 76 02 EB A1 48 83 7C 24 30 00 0F 85 36 01 00 00 33 C0 48 8B 8C 24 A0 00 00 00 66 89 01 48 83 BC 24 A8 00 00 00 FF 74 6C 48 81 BC 24 A8 00 00 00 FF FF FF 7F 74 5E 48 83 BC 24 A8 00 00 00 01 76 53 48 8B 84 24 A8 00 00 00 48 FF C8 48 39 05 ?? ?? ?? ?? 73 0E 48 8B 05 ?? ?? ?? ?? 48 89 44 24 70 EB 10 48 8B 84 24 A8 00 00 00 48 FF C8 48 89 44 24 70 48 8B 44 24 70 48 D1 E0 48 8B 8C 24 A0 00 00 00 48 83 C1 02 4C 8B C0 BA FE 00 00 00 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 85 C0 74 10 33 C0 85 C0 74 0A C7 44 24 44 01 00 00 00 EB 08 C7 44 24 44 00 00 00 00 8B 44 24 44 89 44 24 40 83 7C 24 40 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 2A 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 40 00 75 3E E8 ?? ?? ?? ?? C7 00 22 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 2A 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 22 00 00 00 E9 E9 00 00 00 48 83 BC 24 A8 00 00 00 FF 0F 84 D8 00 00 00 48 81 BC 24 A8 00 00 00 FF FF FF 7F 0F 84 C6 00 00 00 48 8B 44 24 30 48 8B 8C 24 A8 00 00 00 48 2B C8 48 8B C1 48 FF C0 48 3B 84 24 A8 00 00 00 0F 83 A2 00 00 00 48 8B 44 24 30 48 8B 8C 24 A8 00 00 00 48 2B C8 48 8B C1 48 FF C0 48 8B 8C 24 A8 00 00 00 48 2B C8 48 8B C1 48 39 05 ?? ?? ?? ?? 73 11 48 8B 05 ?? ?? ?? ?? 48 89 84 24 80 00 00 00 EB 2C 48 8B 44 24 30 48 8B 8C 24 A8 00 00 00 48 2B C8 48 8B C1 48 FF C0 48 8B 8C 24 A8 00 00 00 48 2B C8 48 8B C1 48 89 84 24 80 00 00 00 48 8B 84 24 80 00 00 00 48 D1 E0 48 8B 4C 24 30 48 8B 94 24 A8 00 00 00 48 2B D1 48 8B CA 48 8B 94 24 A0 00 00 00 48 8D 4C 4A 02 4C 8B C0 BA FE 00 00 00 E8 ?? ?? ?? ?? 33 C0 48 81 C4 98 00 00 00 C3 }
	condition:
		$1
}

rule file_10_0_0 {
	meta:
		name = "__vdecl_fmodf8"
		size = 199
		refs = "0011 fmodf"
	strings:
		$1 = { 48 83 EC 68 C5 FE 7F 44 24 20 C5 FE 7F 4C 24 40 E8 ?? ?? ?? ?? 66 0F 7E 44 24 20 66 0F 6E 44 24 24 66 0F 6E 4C 24 44 E8 ?? ?? ?? ?? 66 0F 7E 44 24 24 66 0F 6E 44 24 28 66 0F 6E 4C 24 48 E8 ?? ?? ?? ?? 66 0F 7E 44 24 28 66 0F 6E 44 24 2C 66 0F 6E 4C 24 4C E8 ?? ?? ?? ?? 66 0F 7E 44 24 2C 66 0F 6E 44 24 30 66 0F 6E 4C 24 50 E8 ?? ?? ?? ?? 66 0F 7E 44 24 30 66 0F 6E 44 24 34 66 0F 6E 4C 24 54 E8 ?? ?? ?? ?? 66 0F 7E 44 24 34 66 0F 6E 44 24 38 66 0F 6E 4C 24 58 E8 ?? ?? ?? ?? 66 0F 7E 44 24 38 66 0F 6E 44 24 3C 66 0F 6E 4C 24 5C E8 ?? ?? ?? ?? 66 0F 7E 44 24 3C C5 FE 6F 44 24 20 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_11_0_0 {
	meta:
		name = "??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z"
		size = 311
		refs = "0026 _getptd 006c __ptlocinfo 0080 __globallocalestatus 0091 __updatetlocinfo 00a5 __ptmbcinfo 00cb __updatetmbcinfo"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 56 57 48 83 EC 28 48 8B 44 24 40 C6 40 18 00 48 83 7C 24 48 00 0F 85 F5 00 00 00 E8 ?? ?? ?? ?? 48 8B 4C 24 40 48 89 41 10 48 8B 44 24 40 48 8B 40 10 48 8B 4C 24 40 48 8B 80 C0 00 00 00 48 89 01 48 8B 44 24 40 48 8B 40 10 48 8B 4C 24 40 48 8B 80 B8 00 00 00 48 89 41 08 48 8B 44 24 40 48 8B 0D ?? ?? ?? ?? 48 39 08 74 28 48 8B 44 24 40 48 8B 40 10 8B 0D ?? ?? ?? ?? 8B 80 C8 00 00 00 23 C1 85 C0 75 0D E8 ?? ?? ?? ?? 48 8B 4C 24 40 48 89 01 48 8B 44 24 40 48 8B 0D ?? ?? ?? ?? 48 39 48 08 74 29 48 8B 44 24 40 48 8B 40 10 8B 0D ?? ?? ?? ?? 8B 80 C8 00 00 00 23 C1 85 C0 75 0E E8 ?? ?? ?? ?? 48 8B 4C 24 40 48 89 41 08 48 8B 44 24 40 48 8B 40 10 8B 80 C8 00 00 00 83 E0 02 85 C0 75 2A 48 8B 44 24 40 48 8B 40 10 8B 80 C8 00 00 00 83 C8 02 48 8B 4C 24 40 48 8B 49 10 89 81 C8 00 00 00 48 8B 44 24 40 C6 40 18 01 EB 11 48 8B 7C 24 40 48 8B 74 24 48 B9 10 00 00 00 F3 A4 48 8B 44 24 40 48 83 C4 28 5F 5E C3 }
	condition:
		$1
}

rule file_11_1_0 {
	meta:
		name = "??1_LocaleUpdate@@QEAA@XZ"
		size = 53
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 0F B6 40 18 85 C0 74 21 48 8B 44 24 08 48 8B 40 10 8B 80 C8 00 00 00 83 E0 FD 48 8B 4C 24 08 48 8B 49 10 89 81 C8 00 00 00 F3 C3 }
	condition:
		$1
}

rule file_11_3_0 {
	meta:
		name = "_mbstrnlen"
		size = 37
		refs = "001c _mbstrnlen_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_265_65_0 {
	meta:
		name = "?Delete@?$Hash@PEAV_TaskCollection@details@Concurrency@@PEAV123@@details@Concurrency@@QEAA_NAEBQEAV_TaskCollection@23@@Z"
		size = 37
		refs = "001c ?FindAndDelete@?$Hash@PEAV_TaskCollection@details@Concurrency@@PEAV123@@details@Concurrency@@QEAA_NAEBQEAV_TaskCollection@23@PEAPEAV423@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_43_537_3 {
	meta:
		name = "?resize@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_K@Z"
		size = 37
		refs = "001c ?resize@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_KD@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_66_1333_3 {
	meta:
		name = "?resize@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEAAX_K@Z"
		size = 37
		refs = "001c ?resize@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEAAX_KG@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_66_1335_3 {
	meta:
		name = "?resize@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAAX_K@Z"
		size = 37
		refs = "001c ?resize@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAAX_K_W@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_97_9_2 {
	meta:
		name = "_Cnd_wait"
		size = 37
		refs = "001c ?do_wait@@YAHPEAPEAU_Cnd_internal_imp_t@@PEAPEAU_Mtx_internal_imp_t@@PEBUxtime@@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_393_1_0 {
	meta:
		name = "_aligned_malloc_base"
		size = 37
		refs = "001c _aligned_offset_malloc_base"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_323_3_0 {
	meta:
		name = "_atodbl"
		size = 37
		refs = "001c _atodbl_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_323_5_0 {
	meta:
		name = "_atoflt"
		size = 37
		refs = "001c _atoflt_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_323_7_0 {
	meta:
		name = "_atoldbl"
		size = 37
		refs = "001c _atoldbl_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_800_0_0 {
	meta:
		name = "_execvp"
		size = 37
		refs = "001c _execvpe"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_318_3_0 {
	meta:
		name = "_getws_s"
		size = 37
		refs = "001c _getws_helper"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_510_3_0 {
	meta:
		name = "_ismbslead"
		size = 37
		refs = "001c _ismbslead_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1110_3_0 {
	meta:
		name = "_ismbstrail"
		size = 37
		refs = "001c _ismbstrail_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1109_3_0 {
	meta:
		name = "_mbsbtype"
		size = 37
		refs = "001c _mbsbtype_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_672_3_0 {
	meta:
		name = "_mbscmp"
		size = 37
		refs = "001c _mbscmp_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_421_3_0 {
	meta:
		name = "_mbscoll"
		size = 37
		refs = "001c _mbscoll_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_228_3_0 {
	meta:
		name = "_mbscspn"
		size = 37
		refs = "001c _mbscspn_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_23_3_0 {
	meta:
		name = "_mbsdec"
		size = 37
		refs = "001c _mbsdec_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_874_3_0 {
	meta:
		name = "_mbsicmp"
		size = 37
		refs = "001c _mbsicmp_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_717_3_0 {
	meta:
		name = "_mbsicoll"
		size = 37
		refs = "001c _mbsicoll_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_468_5_0 {
	meta:
		name = "_mbslwr_s"
		size = 37
		refs = "001c _mbslwr_s_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1050_3_0 {
	meta:
		name = "_mbsnbcnt"
		size = 37
		refs = "001c _mbsnbcnt_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_70_3_0 {
	meta:
		name = "_mbsnccnt"
		size = 37
		refs = "001c _mbsnccnt_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_82_0_0 {
	meta:
		name = "_mbsninc"
		size = 37
		refs = "001c _mbsninc_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_965_3_0 {
	meta:
		name = "_mbsnlen"
		size = 37
		refs = "001c _mbsnlen_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_641_3_0 {
	meta:
		name = "_mbspbrk"
		size = 37
		refs = "001c _mbspbrk_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_486_3_0 {
	meta:
		name = "_mbsspn"
		size = 37
		refs = "001c _mbsspn_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_278_3_0 {
	meta:
		name = "_mbsspnp"
		size = 37
		refs = "001c _mbsspnp_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1120_3_0 {
	meta:
		name = "_mbsstr"
		size = 37
		refs = "001c _mbsstr_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_506_0_0 {
	meta:
		name = "_mbstok"
		size = 37
		refs = "001c _mbstok_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_921_5_0 {
	meta:
		name = "_mbsupr_s"
		size = 37
		refs = "001c _mbsupr_s_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_859_8_0 {
	meta:
		name = "_strlwr_s"
		size = 37
		refs = "001c _strlwr_s_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_21_8_0 {
	meta:
		name = "_strupr_s"
		size = 37
		refs = "001c _strupr_s_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_610_8_0 {
	meta:
		name = "_wcslwr_s"
		size = 37
		refs = "001c _wcslwr_s_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_919_8_0 {
	meta:
		name = "_wcsupr_s"
		size = 37
		refs = "001c _wcsupr_s_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_843_0_0 {
	meta:
		name = "_wexecvp"
		size = 37
		refs = "001c _wexecvpe"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1108_3_0 {
	meta:
		name = "gets_s"
		size = 37
		refs = "001c _gets_helper"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_786_4_0 {
	meta:
		name = "strcoll"
		size = 37
		refs = "001c _strcoll_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_573_4_0 {
	meta:
		name = "strtod"
		size = 37
		refs = "001c _strtod_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_400_4_0 {
	meta:
		name = "wcstod"
		size = 37
		refs = "001c _wcstod_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_11_4_0 {
	meta:
		name = "_mbstrnlen_l"
		size = 949
		refs = "0045 ??_C@_1BE@EEKACIGI@?$AAs?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0051 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0066 ??_C@_1HA@GFCAFMKG@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 0070 _CrtDbgReportW 0084 _errno 00a7 ??_C@_1BK@NDCACHED@?$AA_?$AAm?$AAb?$AAs?$AAt?$AAr?$AAn?$AAl?$AAe?$AAn?$AA_?$AAl?$AA?$AA@ 00b3 _invalid_parameter 00f5 ??_C@_1CO@HFMIILNF@?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAB?$AAy?$AAt?$AAe?$AAs?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAI?$AAN?$AAT?$AA_?$AAM?$AAA?$AAX?$AA?$AA@ 0181 ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 018b ?GetLocaleT@_LocaleUpdate@@QEAAPEAUlocaleinfo_struct@@XZ 01b4 ??_C@_1NC@EINCOKCO@?$AA_?$AAl?$AAo?$AAc?$AA_?$AAu?$AAp?$AAd?$AAa?$AAt?$AAe?$AA?4?$AAG?$AAe?$AAt?$AAL?$AAo?$AAc?$AAa?$AAl?$AAe?$AAT?$AA?$CI?$AA?$CJ?$AA?9?$AA?$DO?$AAl?$AAo?$AAc?$AAi?$AAn?$AAf@ 0212 strnlen 0226 ??1_LocaleUpdate@@QEAA@XZ 026f __imp_MultiByteToWideChar 0317 _isleadbyte_l"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 81 EC 98 00 00 00 48 83 BC 24 A0 00 00 00 00 74 0A C7 44 24 40 01 00 00 00 EB 08 C7 44 24 40 00 00 00 00 8B 44 24 40 89 44 24 44 83 7C 24 44 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 39 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 44 00 75 40 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 39 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 C7 C0 FF FF FF FF E9 EA 02 00 00 48 81 BC 24 A8 00 00 00 FF FF FF 7F 77 0A C7 44 24 38 01 00 00 00 EB 08 C7 44 24 38 00 00 00 00 8B 44 24 38 89 44 24 3C 83 7C 24 3C 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 3A 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 3C 00 75 40 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 3A 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 C7 C0 FF FF FF FF E9 3A 02 00 00 48 8B 94 24 B0 00 00 00 48 8D 4C 24 58 E8 ?? ?? ?? ?? 48 8D 4C 24 58 E8 ?? ?? ?? ?? 48 8B 00 83 B8 D4 00 00 00 01 74 50 48 8D 4C 24 58 E8 ?? ?? ?? ?? 48 8B 00 83 B8 D4 00 00 00 02 74 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 3F 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 48 8D 4C 24 58 E8 ?? ?? ?? ?? 48 8B 00 83 B8 D4 00 00 00 01 75 36 48 8B 94 24 A8 00 00 00 48 8B 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 48 98 48 89 84 24 88 00 00 00 48 8D 4C 24 58 E8 ?? ?? ?? ?? 48 8B 84 24 88 00 00 00 E9 76 01 00 00 48 8D 4C 24 58 E8 ?? ?? ?? ?? 48 8B 00 C7 44 24 28 00 00 00 00 48 C7 44 24 20 00 00 00 00 44 8B 8C 24 A8 00 00 00 4C 8B 84 24 A0 00 00 00 BA 09 00 00 00 8B 48 04 FF 15 ?? ?? ?? ?? 85 C0 75 28 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 48 C7 44 24 78 FF FF FF FF 48 8D 4C 24 58 E8 ?? ?? ?? ?? 48 8B 44 24 78 E9 0E 01 00 00 48 C7 44 24 48 00 00 00 00 48 C7 44 24 30 00 00 00 00 EB 2D 48 8B 44 24 48 48 FF C0 48 89 44 24 48 48 8B 84 24 A0 00 00 00 48 FF C0 48 89 84 24 A0 00 00 00 48 8B 44 24 30 48 FF C0 48 89 44 24 30 48 8B 84 24 A8 00 00 00 48 39 44 24 30 73 77 48 8B 84 24 A0 00 00 00 0F BE 00 85 C0 74 68 48 8D 4C 24 58 E8 ?? ?? ?? ?? 48 8B 8C 24 A0 00 00 00 0F B6 09 48 8B D0 E8 ?? ?? ?? ?? 85 C0 74 42 48 8B 44 24 30 48 FF C0 48 89 44 24 30 48 8B 84 24 A8 00 00 00 48 39 44 24 30 72 02 EB 29 48 8B 84 24 A0 00 00 00 48 FF C0 48 89 84 24 A0 00 00 00 48 8B 84 24 A0 00 00 00 0F BE 00 85 C0 75 02 EB 05 E9 4D FF FF FF 48 8B 84 24 A8 00 00 00 48 39 44 24 30 72 0F 48 8B 84 24 A8 00 00 00 48 89 44 24 50 EB 0A 48 8B 44 24 48 48 89 44 24 50 48 8B 44 24 50 48 89 84 24 80 00 00 00 48 8D 4C 24 58 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 48 81 C4 98 00 00 00 C3 }
	condition:
		$1
}

rule file_12_0_0 {
	meta:
		name = "__sse2_atan22"
		size = 736
		refs = "0027 iSignMask 005c dbPio2hi 00b8 iAbsMask 00d8 iMinWorkNum 00e1 iMaxWorkNum 012c dbPi 0158 dbA19 0160 dbA18 0168 dbA17 0170 dbA16 0193 dbA15 019b dbA14 01a3 dbA13 01ab dbA12 01c3 dbA11 01cb dbA10 01d3 dbA09 01db dbA08 01f3 dbA07 01fb dbA06 0203 dbA05 020b dbA04 0223 dbA03 022b dbA02 0233 dbA01 023b dbA00"
	strings:
		$1 = { 48 81 EC A8 00 00 00 0F 29 B4 24 90 00 00 00 0F 29 BC 24 80 00 00 00 66 0F 29 44 24 60 66 0F 29 4C 24 70 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F 54 D0 66 0F 54 D9 66 0F 29 54 24 20 66 0F 29 5C 24 30 66 0F 57 C2 66 0F 57 CB 66 0F 28 D0 66 0F C2 D1 05 66 0F 28 1D ?? ?? ?? ?? 66 0F 28 E2 66 0F 54 DA 66 0F 54 25 ?? ?? ?? ?? 66 0F 56 CC 66 0F 28 E2 66 0F 28 E8 66 0F 28 F1 66 0F 54 C2 66 0F 54 CA 66 0F 55 D6 66 0F 55 E5 66 0F 56 CC 66 0F 56 D0 66 0F 5E CA 66 0F 28 64 24 60 66 0F 28 6C 24 60 66 0F 28 74 24 70 66 0F 28 7C 24 70 66 0F 54 25 ?? ?? ?? ?? 66 0F 54 2D ?? ?? ?? ?? 66 0F 54 35 ?? ?? ?? ?? 66 0F 54 3D ?? ?? ?? ?? 66 0F C2 25 ?? ?? ?? ?? 06 66 0F C2 2D ?? ?? ?? ?? 01 66 0F C2 35 ?? ?? ?? ?? 06 66 0F C2 3D ?? ?? ?? ?? 01 66 0F 54 E5 66 0F 54 F7 66 0F 54 E6 66 0F 50 C4 83 F8 03 89 84 24 A0 00 00 00 0F 8C 63 01 00 00 66 0F 28 64 24 30 66 0F 72 E4 1F 66 0F 70 E4 F5 66 0F 54 25 ?? ?? ?? ?? 66 0F 29 64 24 40 66 0F 29 5C 24 50 66 0F 28 E1 66 0F 59 C9 66 0F 28 E9 66 0F 59 C9 66 0F 28 C1 66 0F 59 C9 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 3D ?? ?? ?? ?? 66 0F 59 D1 66 0F 59 D9 66 0F 59 F1 66 0F 59 F9 C7 84 24 A0 00 00 00 03 00 00 00 66 0F 58 15 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 58 3D ?? ?? ?? ?? 66 0F 59 D1 66 0F 59 D9 66 0F 59 F1 66 0F 59 F9 66 0F 58 15 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 58 3D ?? ?? ?? ?? 66 0F 59 D1 66 0F 59 D9 66 0F 59 F1 66 0F 59 F9 66 0F 58 15 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 58 3D ?? ?? ?? ?? 66 0F 59 D1 66 0F 59 D9 66 0F 59 F1 66 0F 59 F9 66 0F 58 15 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 58 3D ?? ?? ?? ?? 66 0F 59 D0 66 0F 59 D5 66 0F 59 D8 66 0F 59 F5 66 0F 58 D3 66 0F 58 F7 66 0F 58 F2 66 0F 59 F4 66 0F 58 74 24 50 66 0F 56 74 24 30 66 0F 58 74 24 40 66 0F 56 74 24 20 66 0F 28 C6 0F 28 B4 24 90 00 00 00 0F 28 BC 24 80 00 00 00 83 BC 24 A0 00 00 00 03 7D 34 F2 0F 10 44 24 60 F2 0F 10 4C 24 70 E8 3A 00 00 00 F2 0F 11 44 24 60 F2 0F 10 44 24 68 F2 0F 10 4C 24 78 E8 23 00 00 00 F2 0F 11 44 24 68 66 0F 28 44 24 60 48 81 C4 A8 00 00 00 C3 66 66 66 66 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_12_1_0 {
	meta:
		name = "__common_atan2_sd"
		size = 944
		refs = "0027 iSignMask 005c dbPio2hi 00b8 iAbsMask 00d8 iMinWorkNum 00e1 iMaxWorkNum 0125 dbPi 0151 dbA19 0159 dbA18 0161 dbA17 0169 dbA16 0181 dbA15 0189 dbA14 0191 dbA13 0199 dbA12 01b1 dbA11 01b9 dbA10 01c1 dbA09 01c9 dbA08 01e1 dbA07 01e9 dbA06 01f1 dbA05 01f9 dbA04 0211 dbA03 0219 dbA02 0221 dbA01 0229 dbA00 027e dbZero 0336 db3Pio4hi 0348 dbPio4hi"
	strings:
		$1 = { 48 81 EC A8 00 00 00 0F 29 B4 24 90 00 00 00 0F 29 BC 24 80 00 00 00 66 0F D6 44 24 20 66 0F D6 4C 24 30 F3 0F 7E 15 ?? ?? ?? ?? F3 0F 7E 1D ?? ?? ?? ?? 66 0F 54 D0 66 0F 54 D9 66 0F D6 54 24 40 66 0F D6 5C 24 50 66 0F 57 C2 66 0F 57 CB F3 0F 7E D0 F2 0F C2 D1 05 F3 0F 7E 1D ?? ?? ?? ?? F3 0F 7E E2 66 0F 54 DA 66 0F 54 25 ?? ?? ?? ?? 66 0F 56 CC F3 0F 7E E2 F3 0F 7E E8 F3 0F 7E F1 66 0F 54 C2 66 0F 54 CA 66 0F 55 D6 66 0F 55 E5 66 0F 56 CC 66 0F 56 D0 F2 0F 5E CA F3 0F 7E 64 24 20 F3 0F 7E 6C 24 20 F3 0F 7E 74 24 30 F3 0F 7E 7C 24 30 66 0F 54 25 ?? ?? ?? ?? 66 0F 54 2D ?? ?? ?? ?? 66 0F 54 35 ?? ?? ?? ?? 66 0F 54 3D ?? ?? ?? ?? F2 0F C2 25 ?? ?? ?? ?? 06 F2 0F C2 2D ?? ?? ?? ?? 01 F2 0F C2 35 ?? ?? ?? ?? 06 F2 0F C2 3D ?? ?? ?? ?? 01 66 0F 54 E5 66 0F 54 F7 66 0F 54 E6 66 0F 50 D4 83 E2 01 0F 84 5D 01 00 00 F3 0F 7E 64 24 50 66 0F 72 E4 1F 66 0F 70 E4 F5 66 0F 54 25 ?? ?? ?? ?? 66 0F D6 64 24 60 66 0F D6 5C 24 70 F3 0F 7E E1 F2 0F 59 C9 F3 0F 7E E9 F2 0F 59 C9 F3 0F 7E C1 F2 0F 59 C9 F3 0F 7E 15 ?? ?? ?? ?? F3 0F 7E 1D ?? ?? ?? ?? F3 0F 7E 35 ?? ?? ?? ?? F3 0F 7E 3D ?? ?? ?? ?? F2 0F 59 D1 F2 0F 59 D9 F2 0F 59 F1 F2 0F 59 F9 F2 0F 58 15 ?? ?? ?? ?? F2 0F 58 1D ?? ?? ?? ?? F2 0F 58 35 ?? ?? ?? ?? F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 D1 F2 0F 59 D9 F2 0F 59 F1 F2 0F 59 F9 F2 0F 58 15 ?? ?? ?? ?? F2 0F 58 1D ?? ?? ?? ?? F2 0F 58 35 ?? ?? ?? ?? F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 D1 F2 0F 59 D9 F2 0F 59 F1 F2 0F 59 F9 F2 0F 58 15 ?? ?? ?? ?? F2 0F 58 1D ?? ?? ?? ?? F2 0F 58 35 ?? ?? ?? ?? F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 D1 F2 0F 59 D9 F2 0F 59 F1 F2 0F 59 F9 F2 0F 58 15 ?? ?? ?? ?? F2 0F 58 1D ?? ?? ?? ?? F2 0F 58 35 ?? ?? ?? ?? F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 D0 F2 0F 59 D5 F2 0F 59 D8 F2 0F 59 F5 F2 0F 58 D3 F2 0F 58 F7 F2 0F 58 F2 F2 0F 59 F4 F2 0F 58 74 24 70 66 0F 56 74 24 50 F2 0F 58 74 24 60 66 0F 56 74 24 40 F3 0F 7E C6 E9 10 01 00 00 F3 0F 7E 54 24 20 F3 0F 7E 5C 24 30 F2 0F 58 15 ?? ?? ?? ?? F2 0F 58 1D ?? ?? ?? ?? 66 0F EB 54 24 40 66 0F EB 5C 24 50 66 0F D6 54 24 20 66 0F D6 5C 24 30 F3 0F 7E 44 24 20 48 8B 44 24 20 48 8B 54 24 30 48 23 05 ?? ?? ?? ?? 48 23 15 ?? ?? ?? ?? 48 3B 05 ?? ?? ?? ?? 0F 8F A5 00 00 00 74 42 48 3B 15 ?? ?? ?? ?? 0F 8F 96 00 00 00 48 23 D2 74 1B 48 8B 54 24 30 48 23 15 ?? ?? ?? ?? 75 71 66 0F 54 05 ?? ?? ?? ?? E9 82 00 00 00 48 23 C0 75 4D 48 8B 54 24 30 48 23 15 ?? ?? ?? ?? 75 51 EB DE 48 3B 15 ?? ?? ?? ?? 7F 58 7C 32 48 8B 54 24 30 48 23 15 ?? ?? ?? ?? 74 12 66 0F 54 05 ?? ?? ?? ?? 66 0F 56 05 ?? ?? ?? ?? EB 42 66 0F 54 05 ?? ?? ?? ?? 66 0F 56 05 ?? ?? ?? ?? EB 30 66 0F 54 05 ?? ?? ?? ?? 66 0F 56 05 ?? ?? ?? ?? EB 1E 66 0F 54 05 ?? ?? ?? ?? 66 0F 56 05 ?? ?? ?? ?? EB 0C F3 0F 7E 44 24 20 F2 0F 59 44 24 30 F2 0F 11 84 24 A0 00 00 00 0F 28 B4 24 90 00 00 00 0F 28 BC 24 80 00 00 00 F2 0F 10 84 24 A0 00 00 00 48 81 C4 A8 00 00 00 C3 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_14_0_0 {
	meta:
		name = "_heapchk"
		size = 51
		refs = "0014 _crtheap 001a __imp_HeapValidate"
	strings:
		$1 = { 48 83 EC 38 C7 44 24 20 FE FF FF FF 45 33 C0 33 D2 48 8B 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 75 08 C7 44 24 20 FC FF FF FF 8B 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_14_1_0 {
	meta:
		name = "_heapset"
		size = 18
		refs = "0009 _heapchk"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1135_0_0 {
	meta:
		name = "_fpmath"
		size = 18
		refs = "0009 _cfltcvt_init"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_15_0_0 {
	meta:
		name = "raise_fpsw_flags"
		size = 142
		refs = "0085 _set_statfp"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 38 C7 44 24 20 00 00 00 00 8B 44 24 40 83 E0 01 85 C0 74 0B 8B 44 24 20 83 C8 08 89 44 24 20 8B 44 24 40 83 E0 02 85 C0 74 0B 8B 44 24 20 83 C8 10 89 44 24 20 8B 44 24 40 83 E0 04 85 C0 74 0B 8B 44 24 20 83 C8 04 89 44 24 20 8B 44 24 40 83 E0 08 85 C0 74 0B 8B 44 24 20 83 C8 01 89 44 24 20 8B 44 24 40 83 E0 10 85 C0 74 0B 8B 44 24 20 83 C8 20 89 44 24 20 8B 44 24 20 8B C8 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_15_2_0 {
	meta:
		name = "sinhf"
		size = 1319
		refs = "0096 valf_with_flags 0138 ??_C@_05PJDDOCIG@sinhf?$AA@ 013d _handle_errorf 01b4 __xmm@80000000000000008000000000000000 01c8 ?max_sinh_arg@?1??sinhf@@9@9 0292 ?small_threshold@?1??sinhf@@9@9 02c4 ?log2_by_32_tail@?1??sinhf@@9@9 02d2 ?log2_by_32_lead@?1??sinhf@@9@9 02da ?thirtytwo_by_log2@?1??sinhf@@9@9 02e2 __real@3ff0000000000000 02ed splitexp 0312 scaleDouble_1 0369 __real@3d6b4125921ea08b 0377 __real@3de611cb2bdcb7be 038c __real@3e5ae6460fbe61c0 03a1 __real@3ec71de3a4e13e7d 03b6 __real@3f2a01a01a01ee80 03cb __real@3f811111111110fd 03e0 __real@3fc5555555555555 0409 __real@3da9984b7f63fcd7 0417 __real@3e21ee56385b7b20 042c __real@3e927e5069f1cb55 0441 __real@3efa01a019079011 0456 __real@3f56c16c16c212e5 046b __real@3fa5555555555502 0480 __real@3fe0000000000000 04b8 ?sinh_lead@?1??sinhf@@9@9 04d2 ?cosh_lead@?1??sinhf@@9@9"
	strings:
		$1 = { F3 0F 11 44 24 08 48 81 EC E8 00 00 00 F3 0F 5A 84 24 F0 00 00 00 F2 0F 11 84 24 90 00 00 00 F2 0F 10 84 24 90 00 00 00 F2 0F 11 84 24 B8 00 00 00 48 8B 84 24 B8 00 00 00 48 89 84 24 A8 00 00 00 48 B8 FF FF FF FF FF FF FF 7F 48 8B 8C 24 A8 00 00 00 48 23 C8 48 8B C1 48 89 44 24 70 48 B8 00 00 00 00 00 00 10 3F 48 39 44 24 70 73 35 48 83 7C 24 70 00 75 10 F3 0F 10 84 24 F0 00 00 00 E9 9A 04 00 00 EB 18 BA 10 00 00 00 F3 0F 10 84 24 F0 00 00 00 E8 ?? ?? ?? ?? E9 80 04 00 00 E9 BB 00 00 00 48 B8 00 00 00 00 00 00 F0 7F 48 39 44 24 70 0F 82 A6 00 00 00 48 B8 00 00 00 00 00 00 F0 7F 48 39 44 24 70 76 7E F3 0F 10 84 24 F0 00 00 00 F3 0F 11 84 24 88 00 00 00 8B 84 24 88 00 00 00 89 84 24 98 00 00 00 8B 84 24 98 00 00 00 0F BA E8 16 8B C0 C7 44 24 40 01 00 00 00 0F 57 C0 F3 0F 11 44 24 38 F3 0F 10 84 24 F0 00 00 00 F3 0F 11 44 24 30 C7 44 24 28 21 00 00 00 C7 44 24 20 00 00 00 00 41 B9 01 00 00 00 44 8B C0 BA 1F 00 00 00 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 D9 03 00 00 EB 17 F3 0F 10 84 24 F0 00 00 00 F3 0F 58 84 24 F0 00 00 00 E9 C0 03 00 00 48 8B 84 24 A8 00 00 00 48 39 44 24 70 74 0A C7 44 24 68 01 00 00 00 EB 08 C7 44 24 68 00 00 00 00 48 63 44 24 68 48 89 84 24 A0 00 00 00 F2 0F 10 84 24 90 00 00 00 F2 0F 11 44 24 60 48 83 BC 24 A0 00 00 00 00 74 17 F2 0F 10 84 24 90 00 00 00 66 0F 57 05 ?? ?? ?? ?? F2 0F 11 44 24 60 F2 0F 10 44 24 60 66 0F 2F 05 ?? ?? ?? ?? 0F 82 B6 00 00 00 48 83 BC 24 A0 00 00 00 00 74 54 C7 44 24 40 01 00 00 00 0F 57 C0 F3 0F 11 44 24 38 F3 0F 10 84 24 F0 00 00 00 F3 0F 11 44 24 30 C7 44 24 28 22 00 00 00 C7 44 24 20 01 00 00 00 41 B9 03 00 00 00 41 B8 00 00 80 FF BA 1F 00 00 00 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 F0 02 00 00 EB 52 C7 44 24 40 01 00 00 00 0F 57 C0 F3 0F 11 44 24 38 F3 0F 10 84 24 F0 00 00 00 F3 0F 11 44 24 30 C7 44 24 28 22 00 00 00 C7 44 24 20 01 00 00 00 41 B9 03 00 00 00 41 B8 00 00 80 7F BA 1F 00 00 00 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 9C 02 00 00 E9 69 02 00 00 F2 0F 10 44 24 60 66 0F 2F 05 ?? ?? ?? ?? 0F 82 88 00 00 00 48 8D 84 24 B0 00 00 00 48 89 44 24 38 48 8D 84 24 C8 00 00 00 48 89 44 24 30 48 8D 44 24 5C 48 89 44 24 28 F2 0F 10 05 ?? ?? ?? ?? F2 0F 11 44 24 20 F2 0F 10 1D ?? ?? ?? ?? F2 0F 10 15 ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? F2 0F 10 44 24 60 E8 ?? ?? ?? ?? 8B 44 24 5C FF C8 89 44 24 5C F2 0F 10 84 24 C8 00 00 00 F2 0F 58 84 24 B0 00 00 00 8B 54 24 5C E8 ?? ?? ?? ?? F2 0F 11 84 24 80 00 00 00 E9 CD 01 00 00 F2 0F 2C 44 24 60 89 44 24 58 F2 0F 2A 44 24 58 F2 0F 10 4C 24 60 F2 0F 5C C8 0F 28 C1 F2 0F 11 44 24 78 F2 0F 10 44 24 78 F2 0F 59 44 24 78 F2 0F 11 44 24 50 F2 0F 10 44 24 78 F2 0F 59 44 24 50 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 4C 24 50 F2 0F 10 15 ?? ?? ?? ?? F2 0F 58 D1 0F 28 CA F2 0F 59 4C 24 50 F2 0F 10 15 ?? ?? ?? ?? F2 0F 58 D1 0F 28 CA F2 0F 59 4C 24 50 F2 0F 10 15 ?? ?? ?? ?? F2 0F 58 D1 0F 28 CA F2 0F 59 4C 24 50 F2 0F 10 15 ?? ?? ?? ?? F2 0F 58 D1 0F 28 CA F2 0F 59 4C 24 50 F2 0F 10 15 ?? ?? ?? ?? F2 0F 58 D1 0F 28 CA F2 0F 59 4C 24 50 F2 0F 10 15 ?? ?? ?? ?? F2 0F 58 D1 0F 28 CA F2 0F 59 C1 F2 0F 10 4C 24 78 F2 0F 58 C8 0F 28 C1 F2 0F 11 84 24 D0 00 00 00 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 44 24 50 F2 0F 10 0D ?? ?? ?? ?? F2 0F 58 C8 0F 28 C1 F2 0F 59 44 24 50 F2 0F 10 0D ?? ?? ?? ?? F2 0F 58 C8 0F 28 C1 F2 0F 59 44 24 50 F2 0F 10 0D ?? ?? ?? ?? F2 0F 58 C8 0F 28 C1 F2 0F 59 44 24 50 F2 0F 10 0D ?? ?? ?? ?? F2 0F 58 C8 0F 28 C1 F2 0F 59 44 24 50 F2 0F 10 0D ?? ?? ?? ?? F2 0F 58 C8 0F 28 C1 F2 0F 59 44 24 50 F2 0F 10 0D ?? ?? ?? ?? F2 0F 58 C8 0F 28 C1 F2 0F 10 4C 24 50 F2 0F 59 C8 0F 28 C1 F2 0F 10 0D ?? ?? ?? ?? F2 0F 58 C8 0F 28 C1 F2 0F 11 84 24 C0 00 00 00 48 63 44 24 58 48 8D 0D ?? ?? ?? ?? F2 0F 10 04 C1 F2 0F 59 84 24 C0 00 00 00 48 63 44 24 58 48 8D 0D ?? ?? ?? ?? F2 0F 10 0C C1 F2 0F 59 8C 24 D0 00 00 00 F2 0F 58 C1 F2 0F 11 84 24 80 00 00 00 48 83 BC 24 A0 00 00 00 00 74 1A F2 0F 10 84 24 80 00 00 00 66 0F 57 05 ?? ?? ?? ?? F2 0F 11 84 24 80 00 00 00 F2 0F 5A 84 24 80 00 00 00 48 81 C4 E8 00 00 00 C3 }
	condition:
		$1
}

rule file_15_4_0 {
	meta:
		name = "valf_with_flags"
		size = 34
		refs = "0013 raise_fpsw_flags"
	strings:
		$1 = { 89 54 24 10 F3 0F 11 44 24 08 48 83 EC 28 8B 4C 24 38 E8 ?? ?? ?? ?? F3 0F 10 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_20_3_0 {
	meta:
		name = "_cwprintf"
		size = 56
		refs = "002f _vcwprintf_l"
	strings:
		$1 = { 48 89 4C 24 08 48 89 54 24 10 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 48 48 89 44 24 20 4C 8B 44 24 20 33 D2 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_284_3_0 {
	meta:
		name = "_cprintf"
		size = 56
		refs = "002f _vcprintf_l"
	strings:
		$1 = { 48 89 4C 24 08 48 89 54 24 10 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 48 48 89 44 24 20 4C 8B 44 24 20 33 D2 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_947_3_0 {
	meta:
		name = "_cprintf_p"
		size = 56
		refs = "002f _vcprintf_p_l"
	strings:
		$1 = { 48 89 4C 24 08 48 89 54 24 10 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 48 48 89 44 24 20 4C 8B 44 24 20 33 D2 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_842_3_0 {
	meta:
		name = "_cprintf_s"
		size = 56
		refs = "002f _vcprintf_s_l"
	strings:
		$1 = { 48 89 4C 24 08 48 89 54 24 10 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 48 48 89 44 24 20 4C 8B 44 24 20 33 D2 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_261_6_0 {
	meta:
		name = "_cscanf"
		size = 56
		refs = "002f _cprinput_l"
	strings:
		$1 = { 48 89 4C 24 08 48 89 54 24 10 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 48 48 89 44 24 20 4C 8B 44 24 20 33 D2 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1147_6_0 {
	meta:
		name = "_cscanf_s"
		size = 56
		refs = "002f _cprinput_s_l"
	strings:
		$1 = { 48 89 4C 24 08 48 89 54 24 10 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 48 48 89 44 24 20 4C 8B 44 24 20 33 D2 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1004_3_0 {
	meta:
		name = "_cwprintf_p"
		size = 56
		refs = "002f _vcwprintf_p_l"
	strings:
		$1 = { 48 89 4C 24 08 48 89 54 24 10 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 48 48 89 44 24 20 4C 8B 44 24 20 33 D2 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_888_3_0 {
	meta:
		name = "_cwprintf_s"
		size = 56
		refs = "002f _vcwprintf_s_l"
	strings:
		$1 = { 48 89 4C 24 08 48 89 54 24 10 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 48 48 89 44 24 20 4C 8B 44 24 20 33 D2 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_76_6_0 {
	meta:
		name = "_cwscanf"
		size = 56
		refs = "002f _cprinput_l"
	strings:
		$1 = { 48 89 4C 24 08 48 89 54 24 10 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 48 48 89 44 24 20 4C 8B 44 24 20 33 D2 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_746_6_0 {
	meta:
		name = "_cwscanf_s"
		size = 56
		refs = "002f _cprinput_s_l"
	strings:
		$1 = { 48 89 4C 24 08 48 89 54 24 10 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 48 48 89 44 24 20 4C 8B 44 24 20 33 D2 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_669_2_0 {
	meta:
		name = "_printf_p"
		size = 56
		refs = "002f _vprintf_p_l"
	strings:
		$1 = { 48 89 4C 24 08 48 89 54 24 10 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 48 48 89 44 24 20 4C 8B 44 24 20 33 D2 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_700_1_0 {
	meta:
		name = "_wprintf_p"
		size = 56
		refs = "002f _vwprintf_p_l"
	strings:
		$1 = { 48 89 4C 24 08 48 89 54 24 10 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 48 48 89 44 24 20 4C 8B 44 24 20 33 D2 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_669_8_0 {
	meta:
		name = "printf_s"
		size = 56
		refs = "002f _vprintf_s_l"
	strings:
		$1 = { 48 89 4C 24 08 48 89 54 24 10 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 48 48 89 44 24 20 4C 8B 44 24 20 33 D2 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_700_6_0 {
	meta:
		name = "wprintf_s"
		size = 56
		refs = "002f _vwprintf_s_l"
	strings:
		$1 = { 48 89 4C 24 08 48 89 54 24 10 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 48 48 89 44 24 20 4C 8B 44 24 20 33 D2 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_20_4_0 {
	meta:
		name = "_cwprintf_l"
		size = 59
		refs = "0032 _vcwprintf_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 50 48 89 44 24 20 4C 8B 44 24 20 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_284_4_0 {
	meta:
		name = "_cprintf_l"
		size = 59
		refs = "0032 _vcprintf_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 50 48 89 44 24 20 4C 8B 44 24 20 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_947_4_0 {
	meta:
		name = "_cprintf_p_l"
		size = 59
		refs = "0032 _vcprintf_p_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 50 48 89 44 24 20 4C 8B 44 24 20 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_842_4_0 {
	meta:
		name = "_cprintf_s_l"
		size = 59
		refs = "0032 _vcprintf_s_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 50 48 89 44 24 20 4C 8B 44 24 20 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_261_7_0 {
	meta:
		name = "_cscanf_l"
		size = 59
		refs = "0032 _cprinput_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 50 48 89 44 24 20 4C 8B 44 24 20 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1147_7_0 {
	meta:
		name = "_cscanf_s_l"
		size = 59
		refs = "0032 _cprinput_s_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 50 48 89 44 24 20 4C 8B 44 24 20 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1004_4_0 {
	meta:
		name = "_cwprintf_p_l"
		size = 59
		refs = "0032 _vcwprintf_p_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 50 48 89 44 24 20 4C 8B 44 24 20 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_888_4_0 {
	meta:
		name = "_cwprintf_s_l"
		size = 59
		refs = "0032 _vcwprintf_s_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 50 48 89 44 24 20 4C 8B 44 24 20 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_76_7_0 {
	meta:
		name = "_cwscanf_l"
		size = 59
		refs = "0032 _cprinput_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 50 48 89 44 24 20 4C 8B 44 24 20 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_746_7_0 {
	meta:
		name = "_cwscanf_s_l"
		size = 59
		refs = "0032 _cprinput_s_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 50 48 89 44 24 20 4C 8B 44 24 20 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_669_1_0 {
	meta:
		name = "_printf_l"
		size = 59
		refs = "0032 _vprintf_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 50 48 89 44 24 20 4C 8B 44 24 20 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_669_3_0 {
	meta:
		name = "_printf_p_l"
		size = 59
		refs = "0032 _vprintf_p_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 50 48 89 44 24 20 4C 8B 44 24 20 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_669_4_0 {
	meta:
		name = "_printf_s_l"
		size = 59
		refs = "0032 _vprintf_s_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 50 48 89 44 24 20 4C 8B 44 24 20 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1047_1_0 {
	meta:
		name = "_scprintf_l"
		size = 59
		refs = "0032 _vscprintf_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 50 48 89 44 24 20 4C 8B 44 24 20 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1047_3_0 {
	meta:
		name = "_scprintf_p_l"
		size = 59
		refs = "0032 _vscprintf_p_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 50 48 89 44 24 20 4C 8B 44 24 20 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_738_2_0 {
	meta:
		name = "_scwprintf_l"
		size = 59
		refs = "0032 _vscwprintf_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 50 48 89 44 24 20 4C 8B 44 24 20 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_738_4_0 {
	meta:
		name = "_scwprintf_p_l"
		size = 59
		refs = "0032 _vscwprintf_p_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 50 48 89 44 24 20 4C 8B 44 24 20 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_700_0_0 {
	meta:
		name = "_wprintf_l"
		size = 59
		refs = "0032 _vwprintf_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 50 48 89 44 24 20 4C 8B 44 24 20 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_700_2_0 {
	meta:
		name = "_wprintf_p_l"
		size = 59
		refs = "0032 _vwprintf_p_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 50 48 89 44 24 20 4C 8B 44 24 20 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_700_3_0 {
	meta:
		name = "_wprintf_s_l"
		size = 59
		refs = "0032 _vwprintf_s_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 50 48 89 44 24 20 4C 8B 44 24 20 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_20_5_0 {
	meta:
		name = "_vcwprintf"
		size = 36
		refs = "001b _vcwprintf_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 4C 8B 44 24 38 33 D2 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_284_5_0 {
	meta:
		name = "_vcprintf"
		size = 36
		refs = "001b _vcprintf_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 4C 8B 44 24 38 33 D2 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_947_5_0 {
	meta:
		name = "_vcprintf_p"
		size = 36
		refs = "001b _vcprintf_p_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 4C 8B 44 24 38 33 D2 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_842_5_0 {
	meta:
		name = "_vcprintf_s"
		size = 36
		refs = "001b _vcprintf_s_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 4C 8B 44 24 38 33 D2 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1004_5_0 {
	meta:
		name = "_vcwprintf_p"
		size = 36
		refs = "001b _vcwprintf_p_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 4C 8B 44 24 38 33 D2 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_888_5_0 {
	meta:
		name = "_vcwprintf_s"
		size = 36
		refs = "001b _vcwprintf_s_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 4C 8B 44 24 38 33 D2 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_20_6_0 {
	meta:
		name = "_vcwprintf_l"
		size = 5232
		refs = "0019 __security_cookie 0074 ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 0085 _errno 0092 _ioinit 00ae ??1_LocaleUpdate@@QEAA@XZ 00fc ??_C@_1CC@MGIEJOME@?$AA?$CI?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0108 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 011d ??_C@_1GK@BJNDONIJ@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 0127 _CrtDbgReportW 0161 ??_C@_1BK@OGEKFAEL@?$AA_?$AAv?$AAc?$AAw?$AAp?$AAr?$AAi?$AAn?$AAt?$AAf?$AA_?$AAl?$AA?$AA@ 016d _invalid_parameter 0231 __lookuptable 02ad __ImageBase 02b4 $LN157 02d0 write_char 03a2 get_int_arg 061b $LN155 0622 $LN156 069d __report_rangecheckfailure 06b7 ?GetLocaleT@_LocaleUpdate@@QEAAPEAUlocaleinfo_struct@@XZ 06f6 _mbtowc_l 0741 get_int64_arg 076a __nullstring 0779 strlen 08bf _isleadbyte_l 08ff __wnullstring 099f _get_printf_count_output 09e4 ??_C@_1EK@PNGFDECN@?$AA?$CI?$AA?$CC?$AA?8?$AAn?$AA?8?$AA?5?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AAs?$AAp?$AAe?$AAc?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?5?$AAd?$AAi?$AAs?$AAa?$AAb?$AAl?$AAe?$AAd?$AA?$CC@ 0b51 ??_C@_0DF@MNLBDNAL@f?3?2dd?2vctools?2crt_bld?2self_64_am@ 0b5e _malloc_dbg 0c55 _cfltcvt_tab 0c5f __imp_DecodePointer 11f3 write_multi_char 120e write_string 138d _free_dbg 13cd __security_check_cookie 13dc $NORMAL_STATE$159 13e0 $LN131 13e4 $LN130 13e8 $LN122 13ec $LN118 13f0 $LN117 13f4 $LN113 13f8 $LN97 13fc $LN64 1400 $LN94 1404 $LN82 1408 $LN46 140c $LN88 1410 $LN63 1414 $LN92 1418 $LN51 141c $LN69 1420 $LN41 1424 $LN47 1428 $LN80 142c $LN49 1430 $LN44 1434 $LN95"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 81 EC D8 05 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 C0 05 00 00 C7 84 24 88 00 00 00 00 00 00 00 C7 44 24 40 00 00 00 00 C7 44 24 5C 00 00 00 00 C7 44 24 48 00 00 00 00 C7 44 24 64 00 00 00 00 C7 44 24 70 00 00 00 00 C7 44 24 68 00 00 00 00 48 8B 94 24 E8 05 00 00 48 8D 8C 24 30 01 00 00 E8 ?? ?? ?? ?? 48 C7 84 24 B8 00 00 00 00 00 00 00 E8 ?? ?? ?? ?? 48 89 84 24 58 01 00 00 E8 ?? ?? ?? ?? 85 C0 7D 24 C7 84 24 00 01 00 00 FF FF FF FF 48 8D 8C 24 30 01 00 00 E8 ?? ?? ?? ?? 8B 84 24 00 01 00 00 E9 03 13 00 00 48 83 BC 24 E0 05 00 00 00 74 0D C7 84 24 E4 00 00 00 01 00 00 00 EB 0B C7 84 24 E4 00 00 00 00 00 00 00 8B 84 24 E4 00 00 00 89 84 24 E8 00 00 00 83 BC 24 E8 00 00 00 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 0D 04 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 BC 24 E8 00 00 00 00 75 58 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 0D 04 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 84 24 1C 01 00 00 FF FF FF FF 48 8D 8C 24 30 01 00 00 E8 ?? ?? ?? ?? 8B 84 24 1C 01 00 00 E9 2C 12 00 00 C7 44 24 58 00 00 00 00 C7 44 24 4C 00 00 00 00 C7 84 24 90 00 00 00 00 00 00 00 48 C7 84 24 B8 00 00 00 00 00 00 00 C7 84 24 C0 00 00 00 00 00 00 00 48 8B 84 24 E0 05 00 00 0F B7 00 66 89 44 24 44 0F B7 44 24 44 89 84 24 14 01 00 00 48 8B 84 24 E0 05 00 00 48 83 C0 02 48 89 84 24 E0 05 00 00 83 BC 24 14 01 00 00 00 0F 84 9D 11 00 00 83 7C 24 58 00 0F 8C 92 11 00 00 0F B7 44 24 44 83 F8 20 7C 2B 0F B7 44 24 44 83 F8 78 7F 21 0F B7 44 24 44 83 E8 20 48 98 48 8D 0D ?? ?? ?? ?? 0F BE 04 01 83 E0 0F 89 84 24 DC 00 00 00 EB 0B C7 84 24 DC 00 00 00 00 00 00 00 8B 84 24 DC 00 00 00 89 84 24 24 01 00 00 8B 84 24 90 00 00 00 8B 8C 24 24 01 00 00 8D 04 C8 48 98 48 8D 0D ?? ?? ?? ?? 0F BE 04 01 C1 F8 04 89 84 24 90 00 00 00 8B 84 24 90 00 00 00 89 84 24 D8 00 00 00 83 BC 24 D8 00 00 00 07 0F 87 FB 10 00 00 48 63 84 24 D8 00 00 00 48 8D 0D ?? ?? ?? ?? 8B 84 81 ?? ?? ?? ?? 48 03 C1 FF E0 C7 44 24 68 01 00 00 00 48 8D 54 24 58 0F B7 4C 24 44 E8 ?? ?? ?? ?? E9 C4 10 00 00 C7 84 24 B0 00 00 00 00 00 00 00 8B 84 24 B0 00 00 00 89 44 24 70 8B 44 24 70 89 44 24 5C 8B 44 24 5C 89 44 24 64 C7 44 24 40 00 00 00 00 C7 44 24 48 FF FF FF FF C7 44 24 68 00 00 00 00 E9 81 10 00 00 0F B7 44 24 44 89 44 24 6C 83 7C 24 6C 20 74 38 83 7C 24 6C 23 74 3E 83 7C 24 6C 2B 74 1D 83 7C 24 6C 2D 74 09 83 7C 24 6C 30 74 37 EB 40 8B 44 24 40 83 C8 04 89 44 24 40 EB 33 8B 44 24 40 83 C8 01 89 44 24 40 EB 26 8B 44 24 40 83 C8 02 89 44 24 40 EB 19 8B 44 24 40 0F BA E8 07 89 44 24 40 EB 0B 8B 44 24 40 83 C8 08 89 44 24 40 E9 0E 10 00 00 0F B7 44 24 44 83 F8 2A 75 2F 48 8D 8C 24 F0 05 00 00 E8 ?? ?? ?? ?? 89 44 24 5C 83 7C 24 5C 00 7D 15 8B 44 24 40 83 C8 04 89 44 24 40 8B 44 24 5C F7 D8 89 44 24 5C EB 14 8B 44 24 5C 6B C0 0A 0F B7 4C 24 44 8D 44 08 D0 89 44 24 5C E9 BC 0F 00 00 C7 44 24 48 00 00 00 00 E9 AF 0F 00 00 0F B7 44 24 44 83 F8 2A 75 22 48 8D 8C 24 F0 05 00 00 E8 ?? ?? ?? ?? 89 44 24 48 83 7C 24 48 00 7D 08 C7 44 24 48 FF FF FF FF EB 14 8B 44 24 48 6B C0 0A 0F B7 4C 24 44 8D 44 08 D0 89 44 24 48 E9 6A 0F 00 00 0F B7 44 24 44 89 84 24 94 00 00 00 83 BC 24 94 00 00 00 49 74 6D 83 BC 24 94 00 00 00 68 0F 84 68 01 00 00 83 BC 24 94 00 00 00 6C 74 13 83 BC 24 94 00 00 00 77 0F 84 5D 01 00 00 E9 64 01 00 00 48 8B 84 24 E0 05 00 00 0F B7 00 83 F8 6C 75 22 48 8B 84 24 E0 05 00 00 48 83 C0 02 48 89 84 24 E0 05 00 00 8B 44 24 40 0F BA E8 0C 89 44 24 40 EB 0B 8B 44 24 40 83 C8 10 89 44 24 40 E9 22 01 00 00 8B 44 24 40 0F BA E8 0F 89 44 24 40 48 8B 84 24 E0 05 00 00 0F B7 00 83 F8 36 75 36 48 8B 84 24 E0 05 00 00 0F B7 40 02 83 F8 34 75 25 48 8B 84 24 E0 05 00 00 48 83 C0 04 48 89 84 24 E0 05 00 00 8B 44 24 40 0F BA E8 0F 89 44 24 40 E9 B5 00 00 00 48 8B 84 24 E0 05 00 00 0F B7 00 83 F8 33 75 33 48 8B 84 24 E0 05 00 00 0F B7 40 02 83 F8 32 75 22 48 8B 84 24 E0 05 00 00 48 83 C0 04 48 89 84 24 E0 05 00 00 8B 44 24 40 0F BA F0 0F 89 44 24 40 EB 72 48 8B 84 24 E0 05 00 00 0F B7 00 83 F8 64 74 50 48 8B 84 24 E0 05 00 00 0F B7 00 83 F8 69 74 40 48 8B 84 24 E0 05 00 00 0F B7 00 83 F8 6F 74 30 48 8B 84 24 E0 05 00 00 0F B7 00 83 F8 75 74 20 48 8B 84 24 E0 05 00 00 0F B7 00 83 F8 78 74 10 48 8B 84 24 E0 05 00 00 0F B7 00 83 F8 58 75 02 EB 10 C7 84 24 90 00 00 00 00 00 00 00 E9 00 FD FF FF EB 19 8B 44 24 40 83 C8 20 89 44 24 40 EB 0C 8B 44 24 40 0F BA E8 0B 89 44 24 40 E9 C0 0D 00 00 0F B7 44 24 44 89 84 24 84 00 00 00 8B 84 24 84 00 00 00 83 E8 41 89 84 24 84 00 00 00 83 BC 24 84 00 00 00 37 0F 87 2A 0B 00 00 48 63 84 24 84 00 00 00 48 8D 0D ?? ?? ?? ?? 0F B6 84 01 ?? ?? ?? ?? 8B 84 81 ?? ?? ?? ?? 48 03 C1 FF E0 8B 44 24 40 25 30 08 00 00 85 C0 75 0B 8B 44 24 40 83 C8 20 89 44 24 40 C7 44 24 68 01 00 00 00 48 8D 8C 24 F0 05 00 00 E8 ?? ?? ?? ?? 66 89 44 24 60 8B 44 24 40 83 E0 20 85 C0 0F 84 9C 00 00 00 0F B7 44 24 60 25 FF 00 00 00 B9 01 00 00 00 48 6B C9 00 88 44 0C 7C 48 C7 84 24 68 01 00 00 01 00 00 00 48 83 BC 24 68 01 00 00 02 73 02 EB 05 E8 ?? ?? ?? ?? 48 8B 84 24 68 01 00 00 C6 44 04 7C 00 48 8D 8C 24 30 01 00 00 E8 ?? ?? ?? ?? 48 89 84 24 A8 01 00 00 48 8D 8C 24 30 01 00 00 E8 ?? ?? ?? ?? 48 8B 00 48 63 80 D4 00 00 00 48 8B 8C 24 A8 01 00 00 4C 8B C9 4C 8B C0 48 8D 54 24 7C 48 8D 8C 24 C0 01 00 00 E8 ?? ?? ?? ?? 85 C0 7D 08 C7 44 24 70 01 00 00 00 EB 16 B8 02 00 00 00 48 6B C0 00 0F B7 4C 24 60 66 89 8C 04 C0 01 00 00 48 8D 84 24 C0 01 00 00 48 89 44 24 50 C7 44 24 4C 01 00 00 00 E9 FA 09 00 00 48 8D 8C 24 F0 05 00 00 E8 ?? ?? ?? ?? 48 89 84 24 D0 00 00 00 48 83 BC 24 D0 00 00 00 00 74 0F 48 8B 84 24 D0 00 00 00 48 83 78 08 00 75 1C 48 8B 05 ?? ?? ?? ?? 48 89 44 24 50 48 8B 4C 24 50 E8 ?? ?? ?? ?? 89 44 24 4C EB 64 8B 44 24 40 25 00 08 00 00 85 C0 74 2F 48 8B 84 24 D0 00 00 00 48 8B 40 08 48 89 44 24 50 48 8B 84 24 D0 00 00 00 0F BF 00 99 2B C2 D1 F8 89 44 24 4C C7 44 24 68 01 00 00 00 EB 28 C7 44 24 68 00 00 00 00 48 8B 84 24 D0 00 00 00 48 8B 40 08 48 89 44 24 50 48 8B 84 24 D0 00 00 00 0F BF 00 89 44 24 4C E9 46 09 00 00 8B 44 24 40 25 30 08 00 00 85 C0 75 0B 8B 44 24 40 83 C8 20 89 44 24 40 83 7C 24 48 FF 75 0D C7 84 24 EC 00 00 00 FF FF FF 7F EB 0B 8B 44 24 48 89 84 24 EC 00 00 00 8B 84 24 EC 00 00 00 89 84 24 8C 00 00 00 48 8D 8C 24 F0 05 00 00 E8 ?? ?? ?? ?? 48 89 44 24 50 8B 44 24 40 83 E0 20 85 C0 0F 84 A2 00 00 00 48 83 7C 24 50 00 75 0C 48 8B 05 ?? ?? ?? ?? 48 89 44 24 50 48 8B 44 24 50 48 89 84 24 C8 00 00 00 C7 44 24 4C 00 00 00 00 EB 0A 8B 44 24 4C FF C0 89 44 24 4C 8B 84 24 8C 00 00 00 39 44 24 4C 7D 5B 48 8B 84 24 C8 00 00 00 0F BE 00 85 C0 74 4C 48 8D 8C 24 30 01 00 00 E8 ?? ?? ?? ?? 48 8B 8C 24 C8 00 00 00 0F B6 09 48 8B D0 E8 ?? ?? ?? ?? 85 C0 74 13 48 8B 84 24 C8 00 00 00 48 FF C0 48 89 84 24 C8 00 00 00 48 8B 84 24 C8 00 00 00 48 FF C0 48 89 84 24 C8 00 00 00 EB 8E E9 90 00 00 00 48 83 7C 24 50 00 75 0C 48 8B 05 ?? ?? ?? ?? 48 89 44 24 50 C7 44 24 68 01 00 00 00 48 8B 44 24 50 48 89 84 24 F8 00 00 00 8B 84 24 8C 00 00 00 89 84 24 04 01 00 00 8B 84 24 8C 00 00 00 FF C8 89 84 24 8C 00 00 00 83 BC 24 04 01 00 00 00 74 25 48 8B 84 24 F8 00 00 00 0F B7 00 85 C0 74 16 48 8B 84 24 F8 00 00 00 48 83 C0 02 48 89 84 24 F8 00 00 00 EB B3 48 8B 44 24 50 48 8B 8C 24 F8 00 00 00 48 2B C8 48 8B C1 48 D1 F8 89 44 24 4C E9 A9 07 00 00 48 8D 8C 24 F0 05 00 00 E8 ?? ?? ?? ?? 48 89 84 24 60 01 00 00 E8 ?? ?? ?? ?? 85 C0 0F 85 D7 00 00 00 33 C0 85 C0 74 0D C7 84 24 F4 00 00 00 01 00 00 00 EB 0B C7 84 24 F4 00 00 00 00 00 00 00 8B 84 24 F4 00 00 00 89 84 24 F0 00 00 00 83 BC 24 F0 00 00 00 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 9B 06 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 BC 24 F0 00 00 00 00 75 58 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 9B 06 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 84 24 10 01 00 00 FF FF FF FF 48 8D 8C 24 30 01 00 00 E8 ?? ?? ?? ?? 8B 84 24 10 01 00 00 E9 44 09 00 00 E9 B0 06 00 00 8B 44 24 40 83 E0 20 85 C0 74 12 48 8B 84 24 60 01 00 00 0F B7 4C 24 58 66 89 08 EB 0E 48 8B 84 24 60 01 00 00 8B 4C 24 58 89 08 C7 44 24 70 01 00 00 00 E9 78 06 00 00 C7 84 24 B0 00 00 00 01 00 00 00 0F B7 44 24 44 83 C0 20 66 89 44 24 44 8B 44 24 40 83 C8 40 89 44 24 40 48 8D 84 24 C0 01 00 00 48 89 44 24 50 C7 84 24 C0 00 00 00 00 02 00 00 83 7C 24 48 00 7D 0A C7 44 24 48 06 00 00 00 EB 2D 83 7C 24 48 00 75 14 0F B7 44 24 44 83 F8 67 75 0A C7 44 24 48 01 00 00 00 EB 12 81 7C 24 48 00 02 00 00 7E 08 C7 44 24 48 00 02 00 00 81 7C 24 48 A3 00 00 00 7E 5F 8B 44 24 48 05 5D 01 00 00 48 98 41 B9 E0 06 00 00 4C 8D 05 ?? ?? ?? ?? BA 02 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 48 89 84 24 B8 00 00 00 48 83 BC 24 B8 00 00 00 00 74 1F 48 8B 84 24 B8 00 00 00 48 89 44 24 50 8B 44 24 48 05 5D 01 00 00 89 84 24 C0 00 00 00 EB 08 C7 44 24 48 A3 00 00 00 33 C0 85 C0 74 2A 48 8B 84 24 F0 05 00 00 48 83 C0 08 48 89 84 24 F0 05 00 00 48 8B 84 24 F0 05 00 00 48 8B 40 F8 48 89 84 24 50 01 00 00 EB 28 48 8B 84 24 F0 05 00 00 48 83 C0 08 48 89 84 24 F0 05 00 00 48 8B 84 24 F0 05 00 00 48 83 E8 08 48 89 84 24 50 01 00 00 48 8B 84 24 50 01 00 00 48 89 84 24 B0 01 00 00 48 8B 84 24 B0 01 00 00 48 8B 00 48 89 84 24 70 01 00 00 48 8D 8C 24 30 01 00 00 E8 ?? ?? ?? ?? 48 89 84 24 B8 01 00 00 0F BE 4C 24 44 89 8C 24 18 01 00 00 48 63 94 24 C0 00 00 00 48 89 94 24 88 01 00 00 41 B8 08 00 00 00 4D 6B C0 06 4C 8D 0D ?? ?? ?? ?? 4B 8B 0C 01 FF 15 ?? ?? ?? ?? 48 8B 8C 24 B8 01 00 00 48 89 4C 24 30 8B 8C 24 B0 00 00 00 89 4C 24 28 8B 4C 24 48 89 4C 24 20 8B 8C 24 18 01 00 00 44 8B C9 48 8B 8C 24 88 01 00 00 4C 8B C1 48 8B 54 24 50 48 8D 8C 24 70 01 00 00 FF D0 8B 44 24 40 25 80 00 00 00 85 C0 74 48 83 7C 24 48 00 75 41 48 8D 8C 24 30 01 00 00 E8 ?? ?? ?? ?? 48 89 84 24 98 01 00 00 B9 08 00 00 00 48 6B C9 09 48 8D 15 ?? ?? ?? ?? 48 8B 0C 0A FF 15 ?? ?? ?? ?? 48 8B 8C 24 98 01 00 00 48 8B D1 48 8B 4C 24 50 FF D0 0F B7 44 24 44 83 F8 67 75 4E 8B 44 24 40 25 80 00 00 00 85 C0 75 41 48 8D 8C 24 30 01 00 00 E8 ?? ?? ?? ?? 48 89 84 24 78 01 00 00 B9 08 00 00 00 48 6B C9 08 48 8D 15 ?? ?? ?? ?? 48 8B 0C 0A FF 15 ?? ?? ?? ?? 48 8B 8C 24 78 01 00 00 48 8B D1 48 8B 4C 24 50 FF D0 48 8B 44 24 50 0F BE 00 83 F8 2D 75 19 8B 44 24 40 0F BA E8 08 89 44 24 40 48 8B 44 24 50 48 FF C0 48 89 44 24 50 48 8B 4C 24 50 E8 ?? ?? ?? ?? 89 44 24 4C E9 A5 03 00 00 8B 44 24 40 83 C8 40 89 44 24 40 C7 44 24 78 0A 00 00 00 E9 A4 00 00 00 C7 44 24 78 0A 00 00 00 E9 97 00 00 00 C7 44 24 48 10 00 00 00 8B 44 24 40 0F BA E8 0F 89 44 24 40 C7 84 24 88 00 00 00 07 00 00 00 EB 0B C7 84 24 88 00 00 00 27 00 00 00 C7 44 24 78 10 00 00 00 8B 44 24 40 25 80 00 00 00 85 C0 74 33 B8 02 00 00 00 48 6B C0 00 B9 30 00 00 00 66 89 4C 04 74 8B 84 24 88 00 00 00 83 C0 51 B9 02 00 00 00 48 6B C9 01 66 89 44 0C 74 C7 44 24 64 02 00 00 00 EB 21 C7 44 24 78 08 00 00 00 8B 44 24 40 25 80 00 00 00 85 C0 74 0C 8B 44 24 40 0F BA E8 09 89 44 24 40 8B 44 24 40 25 00 80 00 00 85 C0 74 1A 48 8D 8C 24 F0 05 00 00 E8 ?? ?? ?? ?? 48 89 84 24 A0 00 00 00 E9 AD 00 00 00 8B 44 24 40 25 00 10 00 00 85 C0 74 1A 48 8D 8C 24 F0 05 00 00 E8 ?? ?? ?? ?? 48 89 84 24 A0 00 00 00 E9 86 00 00 00 8B 44 24 40 83 E0 20 85 C0 74 40 8B 44 24 40 83 E0 40 85 C0 74 1B 48 8D 8C 24 F0 05 00 00 E8 ?? ?? ?? ?? 48 0F BF C0 48 89 84 24 A0 00 00 00 EB 18 48 8D 8C 24 F0 05 00 00 E8 ?? ?? ?? ?? 0F B7 C0 48 89 84 24 A0 00 00 00 EB 3B 8B 44 24 40 83 E0 40 85 C0 74 19 48 8D 8C 24 F0 05 00 00 E8 ?? ?? ?? ?? 48 98 48 89 84 24 A0 00 00 00 EB 17 48 8D 8C 24 F0 05 00 00 E8 ?? ?? ?? ?? 8B C0 48 89 84 24 A0 00 00 00 8B 44 24 40 83 E0 40 85 C0 74 2C 48 83 BC 24 A0 00 00 00 00 7D 21 48 8B 84 24 A0 00 00 00 48 F7 D8 48 89 84 24 98 00 00 00 8B 44 24 40 0F BA E8 08 89 44 24 40 EB 10 48 8B 84 24 A0 00 00 00 48 89 84 24 98 00 00 00 8B 44 24 40 25 00 80 00 00 85 C0 75 28 8B 44 24 40 25 00 10 00 00 85 C0 75 1B B8 FF FF FF FF 48 8B 8C 24 98 00 00 00 48 23 C8 48 8B C1 48 89 84 24 98 00 00 00 83 7C 24 48 00 7D 0A C7 44 24 48 01 00 00 00 EB 1D 8B 44 24 40 83 E0 F7 89 44 24 40 81 7C 24 48 00 02 00 00 7E 08 C7 44 24 48 00 02 00 00 48 83 BC 24 98 00 00 00 00 75 08 C7 44 24 64 00 00 00 00 B8 01 00 00 00 48 69 C0 FF 01 00 00 48 8D 84 04 C0 01 00 00 48 89 44 24 50 8B 44 24 48 89 84 24 20 01 00 00 8B 44 }
	condition:
		$1
}

rule file_20_7_0 {
	meta:
		name = "get_int64_arg"
		size = 101
		altNames = "get_crtdouble_arg"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 18 33 C0 85 C0 74 29 48 8B 44 24 20 48 8B 00 48 83 C0 08 48 8B 4C 24 20 48 89 01 48 8B 44 24 20 48 8B 00 48 8B 40 F8 48 8B 00 48 89 04 24 EB 24 48 8B 44 24 20 48 8B 00 48 83 C0 08 48 8B 4C 24 20 48 89 01 48 8B 44 24 20 48 8B 00 48 8B 40 F8 48 89 04 24 48 8B 04 24 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_20_8_0 {
	meta:
		name = "get_int_arg"
		size = 96
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 18 33 C0 85 C0 74 27 48 8B 44 24 20 48 8B 00 48 83 C0 08 48 8B 4C 24 20 48 89 01 48 8B 44 24 20 48 8B 00 48 8B 40 F8 8B 00 89 04 24 EB 22 48 8B 44 24 20 48 8B 00 48 83 C0 08 48 8B 4C 24 20 48 89 01 48 8B 44 24 20 48 8B 00 8B 40 F8 89 04 24 8B 04 24 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_20_9_0 {
	meta:
		name = "write_char"
		size = 68
		refs = "0014 _putwch_nolock"
	strings:
		$1 = { 48 89 54 24 10 66 89 4C 24 08 48 83 EC 28 0F B7 4C 24 30 E8 ?? ?? ?? ?? 0F B7 C0 3D FF FF 00 00 75 0D 48 8B 44 24 38 C7 00 FF FF FF FF EB 10 48 8B 44 24 38 8B 00 FF C0 48 8B 4C 24 38 89 01 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_20_10_0 {
	meta:
		name = "write_multi_char"
		size = 77
		refs = "0036 write_char"
	strings:
		$1 = { 4C 89 44 24 18 89 54 24 10 66 89 4C 24 08 48 83 EC 38 8B 44 24 48 89 44 24 20 8B 44 24 48 FF C8 89 44 24 48 83 7C 24 20 00 7E 1D 48 8B 54 24 50 0F B7 4C 24 40 E8 ?? ?? ?? ?? 48 8B 44 24 50 83 38 FF 75 02 EB 02 EB CA 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_20_11_0 {
	meta:
		name = "write_string"
		size = 178
		refs = "005e write_char"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 58 8B 00 89 44 24 28 48 8B 44 24 58 C7 00 00 00 00 00 8B 44 24 48 89 44 24 24 8B 44 24 48 FF C8 89 44 24 48 83 7C 24 24 00 7E 52 48 8B 44 24 40 0F B7 00 66 89 44 24 20 48 8B 54 24 50 0F B7 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 40 48 83 C0 02 48 89 44 24 40 48 8B 44 24 50 83 38 FF 75 1C 48 8B 44 24 58 83 38 2A 75 10 48 8B 54 24 50 66 B9 3F 00 E8 ?? ?? ?? ?? EB 02 EB 02 EB 95 48 8B 44 24 58 83 38 00 75 0B 48 8B 44 24 58 8B 4C 24 28 89 08 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_21_3_0 {
	meta:
		name = "?_strupr_s_l_stat@@YAHPEAD_KPEAUlocaleinfo_struct@@@Z"
		size = 1679
		refs = "004d ??_C@_1BO@JIBAMMGI@?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0059 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 006e ??_C@_1GK@MFMGKHGP@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 0078 _CrtDbgReportW 008c _errno 00af ??_C@_1CC@NFHGNMIC@?$AA_?$AAs?$AAt?$AAr?$AAu?$AAp?$AAr?$AA_?$AAs?$AA_?$AAl?$AA_?$AAs?$AAt?$AAa?$AAt?$AA?$AA@ 00bb _invalid_parameter 00da strnlen 0133 __crtDebugFillThreshold 0179 memset 0180 ??_C@_1DM@FHLMIEG@?$AAS?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AAi?$AAs?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAn?$AAu?$AAl?$AAl?$AA?5?$AAt?$AAe?$AAr?$AAm?$AAi?$AAn?$AAa?$AAt?$AAe?$AAd?$AA?$AA@ 01bc ??_C@_1FA@MJKDNFFB@?$AA?$CI?$AAL?$AA?$CC?$AAS?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AAi?$AAs?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAn?$AAu?$AAl?$AAl?$AA?5?$AAt?$AAe?$AAr?$AAm?$AAi?$AAn?$AAa?$AAt?$AAe?$AAd@ 03c2 __crtLCMapStringA 0485 ??_C@_1CI@HCPHDDLE@?$AAB?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AAi?$AAs?$AA?5?$AAt?$AAo?$AAo?$AA?5?$AAs?$AAm?$AAa?$AAl?$AAl?$AA?$AA@ 04b8 ??_C@_1DM@MADKGDLO@?$AA?$CI?$AAL?$AA?$CC?$AAB?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AAi?$AAs?$AA?5?$AAt?$AAo?$AAo?$AA?5?$AAs?$AAm?$AAa?$AAl?$AAl?$AA?$CC?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA0?$AA?$CJ?$AA?$AA@ 0575 malloc 0582 _MarkAllocaS 0659 strcpy_s 067f _freea"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 81 EC C8 00 00 00 C7 44 24 54 00 00 00 00 48 83 BC 24 D0 00 00 00 00 74 0A C7 44 24 70 01 00 00 00 EB 08 C7 44 24 70 00 00 00 00 8B 44 24 70 89 44 24 78 83 7C 24 78 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 78 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 78 00 75 3E E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 78 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 16 00 00 00 E9 BE 05 00 00 48 8B 94 24 D8 00 00 00 48 8B 8C 24 D0 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 68 48 8B 84 24 D8 00 00 00 48 39 44 24 68 0F 82 42 01 00 00 48 8B 84 24 D0 00 00 00 C6 00 00 48 83 BC 24 D8 00 00 00 FF 74 71 48 81 BC 24 D8 00 00 00 FF FF FF 7F 74 63 48 83 BC 24 D8 00 00 00 01 76 58 48 8B 84 24 D8 00 00 00 48 FF C8 48 39 05 ?? ?? ?? ?? 73 11 48 8B 05 ?? ?? ?? ?? 48 89 84 24 98 00 00 00 EB 13 48 8B 84 24 D8 00 00 00 48 FF C8 48 89 84 24 98 00 00 00 48 8B 84 24 D0 00 00 00 48 FF C0 4C 8B 84 24 98 00 00 00 BA FE 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 85 C0 74 13 33 C0 85 C0 74 0D C7 84 24 80 00 00 00 01 00 00 00 EB 0B C7 84 24 80 00 00 00 00 00 00 00 8B 84 24 80 00 00 00 89 44 24 74 83 7C 24 74 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 7D 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 74 00 75 3E E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 7D 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 16 00 00 00 E9 4F 04 00 00 48 83 BC 24 D8 00 00 00 FF 0F 84 99 00 00 00 48 81 BC 24 D8 00 00 00 FF FF FF 7F 0F 84 87 00 00 00 48 8B 44 24 68 48 FF C0 48 3B 84 24 D8 00 00 00 73 75 48 8B 44 24 68 48 FF C0 48 8B 8C 24 D8 00 00 00 48 2B C8 48 8B C1 48 39 05 ?? ?? ?? ?? 73 11 48 8B 05 ?? ?? ?? ?? 48 89 84 24 A8 00 00 00 EB 1E 48 8B 44 24 68 48 FF C0 48 8B 8C 24 D8 00 00 00 48 2B C8 48 8B C1 48 89 84 24 A8 00 00 00 48 8B 84 24 D0 00 00 00 48 8B 4C 24 68 48 8D 44 08 01 4C 8B 84 24 A8 00 00 00 BA FE 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 48 8B 84 24 E0 00 00 00 48 8B 00 B9 08 00 00 00 48 6B C9 02 48 83 BC 08 28 01 00 00 00 75 5D 48 8B 84 24 D0 00 00 00 48 89 44 24 58 EB 0D 48 8B 44 24 58 48 FF C0 48 89 44 24 58 48 8B 44 24 58 0F BE 00 85 C0 74 2E 48 8B 44 24 58 0F BE 00 83 F8 61 7C 1F 48 8B 44 24 58 0F BE 00 83 F8 7A 7F 12 48 8B 44 24 58 0F BE 00 83 E8 20 48 8B 4C 24 58 88 01 EB B9 33 C0 E9 2B 03 00 00 48 8B 84 24 E0 00 00 00 48 8B 00 48 8B 8C 24 E0 00 00 00 48 8B 09 BA 08 00 00 00 48 6B D2 02 C7 44 24 40 01 00 00 00 8B 40 04 89 44 24 38 C7 44 24 30 00 00 00 00 48 C7 44 24 28 00 00 00 00 C7 44 24 20 FF FF FF FF 4C 8B 8C 24 D0 00 00 00 41 B8 00 02 00 00 48 8B 94 11 28 01 00 00 48 8B 8C 24 E0 00 00 00 E8 ?? ?? ?? ?? 89 44 24 50 83 7C 24 50 00 75 17 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 E8 ?? ?? ?? ?? 8B 00 E9 9F 02 00 00 48 63 44 24 50 48 39 84 24 D8 00 00 00 0F 83 39 01 00 00 48 8B 84 24 D0 00 00 00 C6 00 00 48 83 BC 24 D8 00 00 00 FF 74 71 48 81 BC 24 D8 00 00 00 FF FF FF 7F 74 63 48 83 BC 24 D8 00 00 00 01 76 58 48 8B 84 24 D8 00 00 00 48 FF C8 48 39 05 ?? ?? ?? ?? 73 11 48 8B 05 ?? ?? ?? ?? 48 89 84 24 90 00 00 00 EB 13 48 8B 84 24 D8 00 00 00 48 FF C8 48 89 84 24 90 00 00 00 48 8B 84 24 D0 00 00 00 48 FF C0 4C 8B 84 24 90 00 00 00 BA FE 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 85 C0 74 10 33 C0 85 C0 74 0A C7 44 24 7C 01 00 00 00 EB 08 C7 44 24 7C 00 00 00 00 8B 44 24 7C 89 44 24 60 83 7C 24 60 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 A3 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 60 00 75 3E E8 ?? ?? ?? ?? C7 00 22 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 A3 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 22 00 00 00 E9 53 01 00 00 83 7C 24 50 00 7E 55 33 C0 85 C0 75 4F 48 63 44 24 50 48 89 84 24 B0 00 00 00 33 D2 48 C7 C0 E0 FF FF FF 48 8B 8C 24 B0 00 00 00 48 F7 F1 48 83 F8 01 72 28 48 63 44 24 50 48 83 C0 10 48 8B C8 E8 ?? ?? ?? ?? BA DD DD 00 00 48 8B C8 E8 ?? ?? ?? ?? 48 89 84 24 A0 00 00 00 EB 0C 48 C7 84 24 A0 00 00 00 00 00 00 00 48 8B 84 24 A0 00 00 00 48 89 84 24 88 00 00 00 48 83 BC 24 88 00 00 00 00 75 17 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E8 ?? ?? ?? ?? 8B 00 E9 B9 00 00 00 48 8B 84 24 E0 00 00 00 48 8B 00 48 8B 8C 24 E0 00 00 00 48 8B 09 BA 08 00 00 00 48 6B D2 02 C7 44 24 40 01 00 00 00 8B 40 04 89 44 24 38 8B 44 24 50 89 44 24 30 48 8B 84 24 88 00 00 00 48 89 44 24 28 C7 44 24 20 FF FF FF FF 4C 8B 8C 24 D0 00 00 00 41 B8 00 02 00 00 48 8B 94 11 28 01 00 00 48 8B 8C 24 E0 00 00 00 E8 ?? ?? ?? ?? 85 C0 74 23 4C 8B 84 24 88 00 00 00 48 8B 94 24 D8 00 00 00 48 8B 8C 24 D0 00 00 00 E8 ?? ?? ?? ?? 89 44 24 54 EB 13 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 C7 44 24 54 2A 00 00 00 48 8B 8C 24 88 00 00 00 E8 ?? ?? ?? ?? 8B 44 24 54 48 81 C4 C8 00 00 00 C3 }
	condition:
		$1
}

rule file_21_4_0 {
	meta:
		name = "_MarkAllocaS"
		size = 48
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 7C 24 08 00 74 19 48 8B 44 24 08 8B 4C 24 10 89 08 48 8B 44 24 08 48 83 C0 10 48 89 44 24 08 48 8B 44 24 08 C3 }
	condition:
		$1
}

rule file_21_5_0 {
	meta:
		name = "_freea"
		size = 67
		refs = "003a free"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 83 7C 24 40 00 74 2D 48 8B 44 24 40 48 83 E8 10 48 89 44 24 40 48 8B 44 24 40 8B 00 89 44 24 20 81 7C 24 20 DD DD 00 00 75 0A 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_21_6_0 {
	meta:
		name = "_strupr"
		size = 306
		refs = "000b __locale_changed 0042 ??_C@_1BO@JIBAMMGI@?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 004e ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0063 ??_C@_1GK@MFMGKHGP@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 006d _CrtDbgReportW 0081 _errno 00a4 ??_C@_1BA@DIKNJIGG@?$AA_?$AAs?$AAt?$AAr?$AAu?$AAp?$AAr?$AA?$AA@ 00b0 _invalid_parameter 0124 _strupr_s_l"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 48 83 3D ?? ?? ?? ?? 00 0F 85 FE 00 00 00 48 83 7C 24 50 00 74 0A C7 44 24 30 01 00 00 00 EB 08 C7 44 24 30 00 00 00 00 8B 44 24 30 89 44 24 34 83 7C 24 34 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 41 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 34 00 75 38 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 41 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 EB 75 48 8B 44 24 50 48 89 44 24 38 EB 0D 48 8B 44 24 38 48 FF C0 48 89 44 24 38 48 8B 44 24 38 0F BE 00 85 C0 74 2E 48 8B 44 24 38 0F BE 00 83 F8 61 7C 1F 48 8B 44 24 38 0F BE 00 83 F8 7A 7F 12 48 8B 44 24 38 0F BE 00 83 E8 20 48 8B 4C 24 38 88 01 EB B9 48 8B 44 24 50 EB 1B EB 19 45 33 C0 48 C7 C2 FF FF FF FF 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_21_7_0 {
	meta:
		name = "_strupr_l"
		size = 46
		refs = "0020 _strupr_s_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 4C 8B 44 24 38 48 C7 C2 FF FF FF FF 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_859_7_0 {
	meta:
		name = "_strlwr_l"
		size = 46
		refs = "0020 _strlwr_s_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 4C 8B 44 24 38 48 C7 C2 FF FF FF FF 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_610_7_0 {
	meta:
		name = "_wcslwr_l"
		size = 46
		refs = "0020 _wcslwr_s_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 4C 8B 44 24 38 48 C7 C2 FF FF FF FF 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_919_7_0 {
	meta:
		name = "_wcsupr_l"
		size = 46
		refs = "0020 _wcsupr_s_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 4C 8B 44 24 38 48 C7 C2 FF FF FF FF 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_21_9_0 {
	meta:
		name = "_strupr_s_l"
		size = 85
		refs = "001e ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 0028 ?GetLocaleT@_LocaleUpdate@@QEAAPEAUlocaleinfo_struct@@XZ 003a ?_strupr_s_l_stat@@YAHPEAD_KPEAUlocaleinfo_struct@@@Z 0048 ??1_LocaleUpdate@@QEAA@XZ"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 58 48 8B 54 24 70 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8D 4C 24 28 E8 ?? ?? ?? ?? 4C 8B C0 48 8B 54 24 68 48 8B 4C 24 60 E8 ?? ?? ?? ?? 89 44 24 20 48 8D 4C 24 28 E8 ?? ?? ?? ?? 8B 44 24 20 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_859_9_0 {
	meta:
		name = "_strlwr_s_l"
		size = 85
		refs = "001e ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 0028 ?GetLocaleT@_LocaleUpdate@@QEAAPEAUlocaleinfo_struct@@XZ 003a ?_strlwr_s_l_stat@@YAHPEAD_KPEAUlocaleinfo_struct@@@Z 0048 ??1_LocaleUpdate@@QEAA@XZ"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 58 48 8B 54 24 70 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8D 4C 24 28 E8 ?? ?? ?? ?? 4C 8B C0 48 8B 54 24 68 48 8B 4C 24 60 E8 ?? ?? ?? ?? 89 44 24 20 48 8D 4C 24 28 E8 ?? ?? ?? ?? 8B 44 24 20 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_610_9_0 {
	meta:
		name = "_wcslwr_s_l"
		size = 85
		refs = "001e ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 0028 ?GetLocaleT@_LocaleUpdate@@QEAAPEAUlocaleinfo_struct@@XZ 003a ?_wcslwr_s_l_stat@@YAHPEA_W_KPEAUlocaleinfo_struct@@@Z 0048 ??1_LocaleUpdate@@QEAA@XZ"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 58 48 8B 54 24 70 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8D 4C 24 28 E8 ?? ?? ?? ?? 4C 8B C0 48 8B 54 24 68 48 8B 4C 24 60 E8 ?? ?? ?? ?? 89 44 24 20 48 8D 4C 24 28 E8 ?? ?? ?? ?? 8B 44 24 20 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_919_9_0 {
	meta:
		name = "_wcsupr_s_l"
		size = 85
		refs = "001e ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 0028 ?GetLocaleT@_LocaleUpdate@@QEAAPEAUlocaleinfo_struct@@XZ 003a ?_wcsupr_s_l_stat@@YAHPEA_W_KPEAUlocaleinfo_struct@@@Z 0048 ??1_LocaleUpdate@@QEAA@XZ"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 58 48 8B 54 24 70 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8D 4C 24 28 E8 ?? ?? ?? ?? 4C 8B C0 48 8B 54 24 68 48 8B 4C 24 60 E8 ?? ?? ?? ?? 89 44 24 20 48 8D 4C 24 28 E8 ?? ?? ?? ?? 8B 44 24 20 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_22_0_0 {
	meta:
		name = "_wsplitpath"
		size = 226
		refs = "00d9 _wsplitpath_helper"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 68 48 83 BC 24 90 00 00 00 00 74 0A C7 44 24 50 00 01 00 00 EB 08 C7 44 24 50 00 00 00 00 48 83 BC 24 88 00 00 00 00 74 0A C7 44 24 54 00 01 00 00 EB 08 C7 44 24 54 00 00 00 00 48 83 BC 24 80 00 00 00 00 74 0A C7 44 24 58 00 01 00 00 EB 08 C7 44 24 58 00 00 00 00 48 83 7C 24 78 00 74 0A C7 44 24 5C 03 00 00 00 EB 08 C7 44 24 5C 00 00 00 00 48 63 44 24 50 48 63 4C 24 54 48 63 54 24 58 4C 63 44 24 5C 48 89 44 24 40 48 8B 84 24 90 00 00 00 48 89 44 24 38 48 89 4C 24 30 48 8B 84 24 88 00 00 00 48 89 44 24 28 48 89 54 24 20 4C 8B 8C 24 80 00 00 00 48 8B 54 24 78 48 8B 4C 24 70 E8 ?? ?? ?? ?? 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_916_0_0 {
	meta:
		name = "_splitpath"
		size = 226
		refs = "00d9 _splitpath_helper"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 68 48 83 BC 24 90 00 00 00 00 74 0A C7 44 24 50 00 01 00 00 EB 08 C7 44 24 50 00 00 00 00 48 83 BC 24 88 00 00 00 00 74 0A C7 44 24 54 00 01 00 00 EB 08 C7 44 24 54 00 00 00 00 48 83 BC 24 80 00 00 00 00 74 0A C7 44 24 58 00 01 00 00 EB 08 C7 44 24 58 00 00 00 00 48 83 7C 24 78 00 74 0A C7 44 24 5C 03 00 00 00 EB 08 C7 44 24 5C 00 00 00 00 48 63 44 24 50 48 63 4C 24 54 48 63 54 24 58 4C 63 44 24 5C 48 89 44 24 40 48 8B 84 24 90 00 00 00 48 89 44 24 38 48 89 4C 24 30 48 8B 84 24 88 00 00 00 48 89 44 24 28 48 89 54 24 20 4C 8B 8C 24 80 00 00 00 48 8B 54 24 78 48 8B 4C 24 70 E8 ?? ?? ?? ?? 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_22_1_0 {
	meta:
		name = "_wsplitpath_helper"
		size = 1572
		refs = "01a0 wcsncpy_s 04e2 ??_C@_1CI@MLPLHPBP@?$AA?$CI?$AA?$CI?$AA?$CI?$AA_?$AAP?$AAa?$AAt?$AAh?$AA?$CJ?$AA?$CJ?$AA?$CJ?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 04ee ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0503 ??_C@_1HK@EFMPOKKI@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 050d _CrtDbgReportW 0521 _errno 0544 ??_C@_1CG@KKMPPB@?$AA_?$AAw?$AAs?$AAp?$AAl?$AAi?$AAt?$AAp?$AAa?$AAt?$AAh?$AA_?$AAh?$AAe?$AAl?$AAp?$AAe?$AAr?$AA?$AA@ 0550 _invalid_parameter 0593 ??_C@_1DE@MLEJGPLF@?$AA?$CI?$AAL?$AA?$CC?$AAI?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAp?$AAa?$AAr?$AAa?$AAm?$AAe?$AAt?$AAe?$AAr?$AA?$CC?$AA?0?$AA?5?$AA0?$AA?$CJ?$AA?$AA@"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 81 EC 88 00 00 00 C7 44 24 68 00 00 00 00 48 C7 44 24 38 00 00 00 00 C7 44 24 58 00 00 00 00 48 83 BC 24 90 00 00 00 00 75 05 E9 DB 03 00 00 48 83 BC 24 98 00 00 00 00 75 0B 48 83 BC 24 A0 00 00 00 00 75 16 48 83 BC 24 98 00 00 00 00 74 10 48 83 BC 24 A0 00 00 00 00 75 05 E9 AA 03 00 00 48 83 BC 24 A8 00 00 00 00 75 0B 48 83 BC 24 B0 00 00 00 00 75 16 48 83 BC 24 A8 00 00 00 00 74 10 48 83 BC 24 B0 00 00 00 00 75 05 E9 79 03 00 00 48 83 BC 24 B8 00 00 00 00 75 0B 48 83 BC 24 C0 00 00 00 00 75 16 48 83 BC 24 B8 00 00 00 00 74 10 48 83 BC 24 C0 00 00 00 00 75 05 E9 48 03 00 00 48 83 BC 24 C8 00 00 00 00 75 0B 48 83 BC 24 D0 00 00 00 00 75 16 48 83 BC 24 C8 00 00 00 00 74 10 48 83 BC 24 D0 00 00 00 00 75 05 E9 17 03 00 00 83 7C 24 68 00 0F 85 BC 00 00 00 48 C7 44 24 70 01 00 00 00 48 8B 84 24 90 00 00 00 48 89 44 24 30 48 83 7C 24 70 00 76 29 48 8B 44 24 30 0F B7 00 85 C0 74 1D 48 8B 44 24 70 48 FF C8 48 89 44 24 70 48 8B 44 24 30 48 83 C0 02 48 89 44 24 30 EB CF 48 8B 44 24 30 0F B7 00 83 F8 3A 75 50 48 83 BC 24 98 00 00 00 00 74 32 48 83 BC 24 A0 00 00 00 03 73 05 E9 A5 02 00 00 41 B9 02 00 00 00 4C 8B 84 24 90 00 00 00 48 C7 C2 FF FF FF FF 48 8B 8C 24 98 00 00 00 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C0 02 48 89 84 24 90 00 00 00 EB 18 48 83 BC 24 98 00 00 00 00 74 0D 33 C0 48 8B 8C 24 98 00 00 00 66 89 01 48 C7 44 24 60 00 00 00 00 48 C7 44 24 40 00 00 00 00 48 8B 84 24 90 00 00 00 48 89 44 24 30 EB 0E 48 8B 44 24 30 48 83 C0 02 48 89 44 24 30 48 8B 44 24 30 0F B7 00 85 C0 74 43 48 8B 44 24 30 0F B7 00 83 F8 2F 74 0D 48 8B 44 24 30 0F B7 00 83 F8 5C 75 10 48 8B 44 24 30 48 83 C0 02 48 89 44 24 60 EB 17 48 8B 44 24 30 0F B7 00 83 F8 2E 75 0A 48 8B 44 24 30 48 89 44 24 40 EB A3 48 83 7C 24 60 00 74 6A 48 83 BC 24 A8 00 00 00 00 74 50 48 8B 84 24 90 00 00 00 48 8B 4C 24 60 48 2B C8 48 8B C1 48 D1 F8 48 89 44 24 38 48 8B 44 24 38 48 39 84 24 B0 00 00 00 77 05 E9 98 01 00 00 4C 8B 4C 24 38 4C 8B 84 24 90 00 00 00 48 C7 C2 FF FF FF FF 48 8B 8C 24 A8 00 00 00 E8 ?? ?? ?? ?? 48 8B 44 24 60 48 89 84 24 90 00 00 00 EB 18 48 83 BC 24 A8 00 00 00 00 74 0D 33 C0 48 8B 8C 24 A8 00 00 00 66 89 01 48 83 7C 24 40 00 0F 84 C5 00 00 00 48 8B 84 24 90 00 00 00 48 39 44 24 40 0F 82 B2 00 00 00 48 83 BC 24 B8 00 00 00 00 74 50 48 8B 84 24 90 00 00 00 48 8B 4C 24 40 48 2B C8 48 8B C1 48 D1 F8 48 89 44 24 38 48 8B 44 24 38 48 39 84 24 C0 00 00 00 77 05 E9 F7 00 00 00 4C 8B 4C 24 38 4C 8B 84 24 90 00 00 00 48 C7 C2 FF FF FF FF 48 8B 8C 24 B8 00 00 00 E8 ?? ?? ?? ?? 48 83 BC 24 C8 00 00 00 00 74 4A 48 8B 44 24 40 48 8B 4C 24 30 48 2B C8 48 8B C1 48 D1 F8 48 89 44 24 38 48 8B 44 24 38 48 39 84 24 D0 00 00 00 77 05 E9 9F 00 00 00 4C 8B 4C 24 38 4C 8B 44 24 40 48 C7 C2 FF FF FF FF 48 8B 8C 24 C8 00 00 00 E8 ?? ?? ?? ?? EB 70 48 83 BC 24 B8 00 00 00 00 74 4D 48 8B 84 24 90 00 00 00 48 8B 4C 24 30 48 2B C8 48 8B C1 48 D1 F8 48 89 44 24 38 48 8B 44 24 38 48 39 84 24 C0 00 00 00 77 02 EB 48 4C 8B 4C 24 38 4C 8B 84 24 90 00 00 00 48 C7 C2 FF FF FF FF 48 8B 8C 24 B8 00 00 00 E8 ?? ?? ?? ?? 48 83 BC 24 C8 00 00 00 00 74 0D 33 C0 48 8B 8C 24 C8 00 00 00 66 89 01 33 C0 E9 FD 01 00 00 C7 44 24 58 01 00 00 00 48 83 BC 24 98 00 00 00 00 74 18 48 83 BC 24 A0 00 00 00 00 76 0D 33 C0 48 8B 8C 24 98 00 00 00 66 89 01 48 83 BC 24 A8 00 00 00 00 74 18 48 83 BC 24 B0 00 00 00 00 76 0D 33 C0 48 8B 8C 24 A8 00 00 00 66 89 01 48 83 BC 24 B8 00 00 00 00 74 18 48 83 BC 24 C0 00 00 00 00 76 0D 33 C0 48 8B 8C 24 B8 00 00 00 66 89 01 48 83 BC 24 C8 00 00 00 00 74 18 48 83 BC 24 D0 00 00 00 00 76 0D 33 C0 48 8B 8C 24 C8 00 00 00 66 89 01 48 83 BC 24 90 00 00 00 00 74 0A C7 44 24 50 01 00 00 00 EB 08 C7 44 24 50 00 00 00 00 8B 44 24 50 89 44 24 4C 83 7C 24 4C 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 D5 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 4C 00 75 3E E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 D5 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 16 00 00 00 E9 BE 00 00 00 83 7C 24 58 00 0F 84 A3 00 00 00 33 C0 85 C0 74 0A C7 44 24 54 01 00 00 00 EB 08 C7 44 24 54 00 00 00 00 8B 44 24 54 89 44 24 48 83 7C 24 48 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 D8 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 48 00 75 3B E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 D8 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 16 00 00 00 EB 10 E8 ?? ?? ?? ?? C7 00 22 00 00 00 B8 22 00 00 00 48 81 C4 88 00 00 00 C3 }
	condition:
		$1
}

rule file_23_4_0 {
	meta:
		name = "_mbsdec_l"
		size = 618
		refs = "0045 ??_C@_1BO@JIBAMMGI@?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0051 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0066 ??_C@_1GK@DMNKIFHI@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 0070 _CrtDbgReportW 0084 _errno 00a7 ??_C@_1BE@KLNCOLCD@?$AA_?$AAm?$AAb?$AAs?$AAd?$AAe?$AAc?$AA_?$AAl?$AA?$AA@ 00b3 _invalid_parameter 00ed ??_C@_1CA@HPEMMJMJ@?$AAc?$AAu?$AAr?$AAr?$AAe?$AAn?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 018d ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 0197 ?GetLocaleT@_LocaleUpdate@@QEAAPEAUlocaleinfo_struct@@XZ 01cb ??1_LocaleUpdate@@QEAA@XZ"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 81 EC 88 00 00 00 48 83 BC 24 90 00 00 00 00 74 0A C7 44 24 44 01 00 00 00 EB 08 C7 44 24 44 00 00 00 00 8B 44 24 44 89 44 24 40 83 7C 24 40 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 34 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 40 00 75 3B E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 34 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 E9 A4 01 00 00 48 83 BC 24 98 00 00 00 00 74 0A C7 44 24 48 01 00 00 00 EB 08 C7 44 24 48 00 00 00 00 8B 44 24 48 89 44 24 30 83 7C 24 30 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 35 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 30 00 75 3B E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 35 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 E9 FC 00 00 00 48 8B 84 24 98 00 00 00 48 39 84 24 90 00 00 00 72 07 33 C0 E9 E3 00 00 00 48 8B 94 24 A0 00 00 00 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8B 40 08 83 78 08 00 75 34 48 8B 84 24 98 00 00 00 48 FF C8 48 89 84 24 98 00 00 00 48 8B 84 24 98 00 00 00 48 89 44 24 50 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8B 44 24 50 E9 89 00 00 00 48 8B 84 24 98 00 00 00 48 FF C8 48 89 44 24 38 48 8B 44 24 38 48 FF C8 48 89 44 24 38 48 8B 44 24 38 48 39 84 24 90 00 00 00 77 24 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8B 40 08 48 8B 4C 24 38 0F B6 09 0F B6 44 08 19 83 E0 04 85 C0 74 02 EB C0 48 8B 84 24 98 00 00 00 48 FF C8 48 8B 4C 24 38 48 8B 94 24 98 00 00 00 48 2B D1 48 8B CA 48 83 E1 01 48 2B C1 48 89 44 24 58 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8B 44 24 58 48 81 C4 88 00 00 00 C3 }
	condition:
		$1
}

rule file_24_3_0 {
	meta:
		name = "_mbsnbcpy"
		size = 47
		refs = "0026 _mbsnbcpy_l"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C9 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_393_6_0 {
	meta:
		name = "_aligned_realloc_base"
		size = 47
		refs = "0026 _aligned_offset_realloc_base"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C9 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_489_0_0 {
	meta:
		name = "_mbscat_s"
		size = 47
		refs = "0026 _mbscat_s_l"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C9 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_238_0_0 {
	meta:
		name = "_mbscpy_s"
		size = 47
		refs = "0026 _mbscpy_s_l"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C9 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_621_3_0 {
	meta:
		name = "_mbsnbcat"
		size = 47
		refs = "0026 _mbsnbcat_l"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C9 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_948_3_0 {
	meta:
		name = "_mbsnbcmp"
		size = 47
		refs = "0026 _mbsnbcmp_l"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C9 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_704_3_0 {
	meta:
		name = "_mbsnbcoll"
		size = 47
		refs = "0026 _mbsnbcoll_l"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C9 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_670_3_0 {
	meta:
		name = "_mbsnbicmp"
		size = 47
		refs = "0026 _mbsnbicmp_l"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C9 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_804_3_0 {
	meta:
		name = "_mbsnbicoll"
		size = 47
		refs = "0026 _mbsnbicoll_l"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C9 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_250_3_0 {
	meta:
		name = "_mbsncat"
		size = 47
		refs = "0026 _mbsncat_l"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C9 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_283_3_0 {
	meta:
		name = "_mbsncmp"
		size = 47
		refs = "0026 _mbsncmp_l"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C9 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1038_3_0 {
	meta:
		name = "_mbsncoll"
		size = 47
		refs = "0026 _mbsncoll_l"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C9 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_463_3_0 {
	meta:
		name = "_mbsncpy"
		size = 47
		refs = "0026 _mbsncpy_l"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C9 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1079_3_0 {
	meta:
		name = "_mbsnicmp"
		size = 47
		refs = "0026 _mbsnicmp_l"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C9 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_623_3_0 {
	meta:
		name = "_mbsnicoll"
		size = 47
		refs = "0026 _mbsnicoll_l"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C9 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_264_3_0 {
	meta:
		name = "_mbstok_s"
		size = 47
		refs = "0026 _mbstok_s_l"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C9 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_721_4_0 {
	meta:
		name = "mbtowc"
		size = 47
		refs = "0026 _mbtowc_l"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C9 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_575_4_0 {
	meta:
		name = "strxfrm"
		size = 47
		refs = "0026 _strxfrm_l"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C9 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_412_7_0 {
	meta:
		name = "wcstombs"
		size = 47
		refs = "0026 _wcstombs_l_helper"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C9 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1100_4_0 {
	meta:
		name = "wcsxfrm"
		size = 47
		refs = "0026 _wcsxfrm_l"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C9 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_24_4_0 {
	meta:
		name = "_mbsnbcpy_l"
		size = 1023
		refs = "0036 ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 0074 ??_C@_1DA@DGICPMP@?$AAd?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AAc?$AAn?$AAt?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 0080 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0095 ??_C@_1GO@NCCALHFF@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 009f _CrtDbgReportW 00b3 _errno 00d6 ??_C@_1BI@HCGBGHAL@?$AA_?$AAm?$AAb?$AAs?$AAn?$AAb?$AAc?$AAp?$AAy?$AA_?$AAl?$AA?$AA@ 00e2 _invalid_parameter 00f5 ??1_LocaleUpdate@@QEAA@XZ 013d ??_C@_1DA@LIIANGMH@?$AAs?$AAr?$AAc?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AAc?$AAn?$AAt?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 01d2 ?GetLocaleT@_LocaleUpdate@@QEAAPEAUlocaleinfo_struct@@XZ 01f9 strncpy"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 81 EC A8 00 00 00 48 8B 84 24 B0 00 00 00 48 89 44 24 58 48 8B 94 24 C8 00 00 00 48 8D 4C 24 78 E8 ?? ?? ?? ?? 48 83 BC 24 B0 00 00 00 00 75 15 48 83 BC 24 C0 00 00 00 00 74 0A C7 44 24 3C 00 00 00 00 EB 08 C7 44 24 3C 01 00 00 00 8B 44 24 3C 89 44 24 38 83 7C 24 38 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 39 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 38 00 75 51 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 39 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 C7 44 24 48 00 00 00 00 48 8D 4C 24 78 E8 ?? ?? ?? ?? 48 8B 44 24 48 E9 F4 02 00 00 48 83 BC 24 B8 00 00 00 00 75 15 48 83 BC 24 C0 00 00 00 00 74 0A C7 44 24 30 00 00 00 00 EB 08 C7 44 24 30 01 00 00 00 8B 44 24 30 89 44 24 34 83 7C 24 34 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 3A 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 34 00 75 51 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 3A 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 C7 44 24 70 00 00 00 00 48 8D 4C 24 78 E8 ?? ?? ?? ?? 48 8B 44 24 70 E9 2B 02 00 00 48 8D 4C 24 78 E8 ?? ?? ?? ?? 48 8B 40 08 83 78 08 00 75 36 4C 8B 84 24 C0 00 00 00 48 8B 94 24 B8 00 00 00 48 8B 8C 24 B0 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 60 48 8D 4C 24 78 E8 ?? ?? ?? ?? 48 8B 44 24 60 E9 E1 01 00 00 48 83 BC 24 C0 00 00 00 00 0F 84 71 01 00 00 48 8B 84 24 C0 00 00 00 48 FF C8 48 89 84 24 C0 00 00 00 48 8D 4C 24 78 E8 ?? ?? ?? ?? 48 8B 40 08 48 8B 8C 24 B8 00 00 00 0F B6 09 0F B6 44 08 19 83 E0 04 85 C0 0F 84 DD 00 00 00 48 8B 84 24 B0 00 00 00 48 8B 8C 24 B8 00 00 00 0F B6 09 88 08 48 8B 84 24 B0 00 00 00 48 FF C0 48 89 84 24 B0 00 00 00 48 8B 84 24 B8 00 00 00 48 FF C0 48 89 84 24 B8 00 00 00 48 83 BC 24 C0 00 00 00 00 75 1A B8 01 00 00 00 48 6B C0 FF 48 8B 8C 24 B0 00 00 00 C6 04 01 00 E9 D5 00 00 00 48 8B 84 24 C0 00 00 00 48 FF C8 48 89 84 24 C0 00 00 00 48 8B 84 24 B0 00 00 00 48 8B 8C 24 B8 00 00 00 0F B6 09 88 08 48 8B 84 24 B0 00 00 00 0F B6 00 89 44 24 40 48 8B 84 24 B0 00 00 00 48 FF C0 48 89 84 24 B0 00 00 00 48 8B 84 24 B8 00 00 00 48 FF C0 48 89 84 24 B8 00 00 00 83 7C 24 40 00 75 17 B8 01 00 00 00 48 6B C0 FE 48 8B 8C 24 B0 00 00 00 C6 04 01 00 EB 5A EB 53 48 8B 84 24 B0 00 00 00 48 8B 8C 24 B8 00 00 00 0F B6 09 88 08 48 8B 84 24 B0 00 00 00 0F B6 00 89 44 24 44 48 8B 84 24 B0 00 00 00 48 FF C0 48 89 84 24 B0 00 00 00 48 8B 84 24 B8 00 00 00 48 FF C0 48 89 84 24 B8 00 00 00 83 7C 24 44 00 75 02 EB 05 E9 80 FE FF FF 48 8B 84 24 C0 00 00 00 48 89 44 24 50 48 8B 84 24 C0 00 00 00 48 FF C8 48 89 84 24 C0 00 00 00 48 83 7C 24 50 00 74 20 48 8B 84 24 B0 00 00 00 C6 00 00 48 8B 84 24 B0 00 00 00 48 FF C0 48 89 84 24 B0 00 00 00 EB B8 48 8B 44 24 58 48 89 44 24 68 48 8D 4C 24 78 E8 ?? ?? ?? ?? 48 8B 44 24 68 48 81 C4 A8 00 00 00 C3 }
	condition:
		$1
}

rule file_25_0_0 {
	meta:
		name = "__sse2_sinhf4"
		size = 432
		refs = "003f __common_ssinh_data 01a1 __common_ssinh_cout_rare"
	strings:
		$1 = { 48 81 EC 08 01 00 00 44 0F 29 AC 24 F0 00 00 00 44 0F 29 9C 24 C0 00 00 00 44 0F 29 94 24 D0 00 00 00 44 0F 29 8C 24 E0 00 00 00 44 0F 28 C8 4C 89 AC 24 00 01 00 00 4C 8D 6C 24 6F 0F 28 05 ?? ?? ?? ?? 49 83 E5 C0 41 0F 54 C1 44 0F 28 E8 0F 28 25 ?? ?? ?? ?? 45 0F 57 E9 41 0F 59 E5 41 0F 28 CD 44 0F 28 15 ?? ?? ?? ?? 66 0F 66 0D ?? ?? ?? ?? 41 0F 58 E2 0F 50 D1 0F 28 CC 66 0F 72 F4 17 44 0F 28 1D ?? ?? ?? ?? 85 D2 0F 28 2D ?? ?? ?? ?? 41 0F 5C CA 44 0F 59 D9 44 0F 28 15 ?? ?? ?? ?? 45 0F 5C EB 44 0F 59 D1 0F 28 1D ?? ?? ?? ?? 45 0F 5C EA 41 0F 28 CD 41 0F 59 CD 0F 59 E9 0F 59 D9 0F 58 2D ?? ?? ?? ?? 0F 58 1D ?? ?? ?? ?? 0F 59 E9 0F 59 D9 41 0F 59 ED 0F 58 1D ?? ?? ?? ?? 41 0F 58 ED 0F 59 D9 66 0F 6F 15 ?? ?? ?? ?? 66 44 0F 6F D2 66 0F FA D4 66 44 0F FE D4 66 41 0F 6F E2 44 0F 5C D2 0F 58 E2 41 0F 59 DA 0F 59 E5 0F 58 E3 41 0F 58 E2 0F 56 C4 75 34 44 0F 28 8C 24 E0 00 00 00 44 0F 28 94 24 D0 00 00 00 44 0F 28 9C 24 C0 00 00 00 44 0F 28 AC 24 F0 00 00 00 4C 8B AC 24 00 01 00 00 48 81 C4 08 01 00 00 C3 45 0F 29 4D 00 41 0F 29 45 40 74 C0 33 C0 48 89 5C 24 28 8B D8 48 89 74 24 20 8B F2 8B CB 41 B8 01 00 00 00 41 D3 E0 41 85 F0 75 18 FF C3 83 FB 20 7C E9 48 8B 5C 24 28 48 8B 74 24 20 41 0F 28 45 40 EB 88 49 8D 4C 9D 00 49 8D 54 9D 40 E8 ?? ?? ?? ?? EB D7 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_27_3_0 {
	meta:
		name = "_ismbcalpha"
		size = 24
		refs = "000f _ismbcalpha_l"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 33 D2 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_799_13_0 {
	meta:
		name = "_ismbbkana"
		size = 24
		refs = "000f _ismbbkana_l"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 33 D2 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_353_3_0 {
	meta:
		name = "_ismbcalnum"
		size = 24
		refs = "000f _ismbcalnum_l"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 33 D2 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_480_3_0 {
	meta:
		name = "_ismbcdigit"
		size = 24
		refs = "000f _ismbcdigit_l"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 33 D2 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_815_3_0 {
	meta:
		name = "_ismbcgraph"
		size = 24
		refs = "000f _ismbcgraph_l"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 33 D2 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_880_3_0 {
	meta:
		name = "_ismbchira"
		size = 24
		refs = "000f _ismbchira_l"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 33 D2 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_880_5_0 {
	meta:
		name = "_ismbckata"
		size = 24
		refs = "000f _ismbckata_l"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 33 D2 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1144_3_0 {
	meta:
		name = "_ismbcl0"
		size = 24
		refs = "000f _ismbcl0_l"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 33 D2 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1144_5_0 {
	meta:
		name = "_ismbcl1"
		size = 24
		refs = "000f _ismbcl1_l"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 33 D2 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1144_7_0 {
	meta:
		name = "_ismbcl2"
		size = 24
		refs = "000f _ismbcl2_l"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 33 D2 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_374_3_0 {
	meta:
		name = "_ismbclegal"
		size = 24
		refs = "000f _ismbclegal_l"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 33 D2 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1065_3_0 {
	meta:
		name = "_ismbclower"
		size = 24
		refs = "000f _ismbclower_l"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 33 D2 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_769_3_0 {
	meta:
		name = "_ismbcprint"
		size = 24
		refs = "000f _ismbcprint_l"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 33 D2 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1122_3_0 {
	meta:
		name = "_ismbcpunct"
		size = 24
		refs = "000f _ismbcpunct_l"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 33 D2 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_157_3_0 {
	meta:
		name = "_ismbcspace"
		size = 24
		refs = "000f _ismbcspace_l"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 33 D2 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_880_7_0 {
	meta:
		name = "_ismbcsymbol"
		size = 24
		refs = "000f _ismbcsymbol_l"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 33 D2 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_470_3_0 {
	meta:
		name = "_ismbcupper"
		size = 24
		refs = "000f _ismbcupper_l"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 33 D2 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_798_3_0 {
	meta:
		name = "_mbbtombc"
		size = 24
		refs = "000f _mbbtombc_l"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 33 D2 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_644_3_0 {
	meta:
		name = "_mbcjistojms"
		size = 24
		refs = "000f _mbcjistojms_l"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 33 D2 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_644_5_0 {
	meta:
		name = "_mbcjmstojis"
		size = 24
		refs = "000f _mbcjmstojis_l"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 33 D2 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_590_0_0 {
	meta:
		name = "_mbctohira"
		size = 24
		refs = "000f _mbctohira_l"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 33 D2 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1039_0_0 {
	meta:
		name = "_mbctokata"
		size = 24
		refs = "000f _mbctokata_l"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 33 D2 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_425_3_0 {
	meta:
		name = "_mbctolower"
		size = 24
		refs = "000f _mbctolower_l"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 33 D2 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_798_5_0 {
	meta:
		name = "_mbctombb"
		size = 24
		refs = "000f _mbctombb_l"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 33 D2 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_327_3_0 {
	meta:
		name = "_mbctoupper"
		size = 24
		refs = "000f _mbctoupper_l"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 33 D2 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_277_19_0 {
	meta:
		name = "isleadbyte"
		size = 24
		refs = "000f _isleadbyte_l"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 33 D2 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_27_4_0 {
	meta:
		name = "_ismbcalpha_l"
		size = 520
		refs = "001f ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 0087 ?GetLocaleT@_LocaleUpdate@@QEAAPEAUlocaleinfo_struct@@XZ 00a3 ??1_LocaleUpdate@@QEAA@XZ 0105 __crtGetStringTypeA"
	strings:
		$1 = { 48 89 54 24 10 89 4C 24 08 57 48 81 EC 90 00 00 00 48 8B 94 24 A8 00 00 00 48 8D 4C 24 60 E8 ?? ?? ?? ?? 81 BC 24 A0 00 00 00 FF 00 00 00 0F 86 4C 01 00 00 33 C0 66 89 44 24 44 48 8D 44 24 46 48 8B F8 33 C0 B9 02 00 00 00 F3 AA 8B 84 24 A0 00 00 00 C1 E8 08 25 FF 00 00 00 B9 01 00 00 00 48 6B C9 00 88 44 0C 40 8B 84 24 A0 00 00 00 25 FF 00 00 00 B9 01 00 00 00 48 6B C9 01 88 44 0C 40 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8B 40 08 83 78 08 00 75 1B C7 44 24 50 00 00 00 00 48 8D 4C 24 60 E8 ?? ?? ?? ?? 8B 44 24 50 E9 4F 01 00 00 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8B 40 08 48 89 84 24 80 00 00 00 48 8D 4C 24 60 E8 ?? ?? ?? ?? C7 44 24 30 01 00 00 00 48 8B 8C 24 80 00 00 00 8B 49 04 89 4C 24 28 48 8D 4C 24 44 48 89 4C 24 20 41 B9 02 00 00 00 4C 8D 44 24 40 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 75 1B C7 44 24 58 00 00 00 00 48 8D 4C 24 60 E8 ?? ?? ?? ?? 8B 44 24 58 E9 D7 00 00 00 B8 02 00 00 00 48 6B C0 01 0F B7 44 04 44 85 C0 75 21 B8 02 00 00 00 48 6B C0 00 0F B7 44 04 44 25 03 01 00 00 85 C0 74 0A C7 44 24 48 01 00 00 00 EB 08 C7 44 24 48 00 00 00 00 8B 44 24 48 89 44 24 5C 48 8D 4C 24 60 E8 ?? ?? ?? ?? 8B 44 24 5C E9 81 00 00 00 EB 75 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8B 00 0F B6 8C 24 A0 00 00 00 48 8B 80 08 01 00 00 0F B7 04 48 25 03 01 00 00 85 C0 75 2C 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8B 40 08 0F B6 8C 24 A0 00 00 00 0F B6 44 08 19 83 E0 01 85 C0 75 0A C7 44 24 4C 00 00 00 00 EB 08 C7 44 24 4C 01 00 00 00 8B 44 24 4C 89 44 24 54 48 8D 4C 24 60 E8 ?? ?? ?? ?? 8B 44 24 54 EB 0A 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 81 C4 90 00 00 00 5F C3 }
	condition:
		$1
}

rule file_28_0_0 {
	meta:
		name = "_fseeki64"
		size = 419
		refs = "003f ??_C@_1CC@FADMNIL@?$AA?$CI?$AAs?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 004b ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0060 ??_C@_1GO@MIODNAKM@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 006a _CrtDbgReportW 007e _errno 00a1 ??_C@_1BE@LFNEFJFD@?$AA_?$AAf?$AAs?$AAe?$AAe?$AAk?$AAi?$AA6?$AA4?$AA?$AA@ 00ad _invalid_parameter 00f4 ??_C@_1IO@PMHBOLJK@?$AA?$CI?$AA?$CI?$AAw?$AAh?$AAe?$AAn?$AAc?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAS?$AAE?$AAE?$AAK?$AA_?$AAS?$AAE?$AAT?$AA?$CJ?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AA?$CI?$AAw?$AAh?$AAe?$AAn?$AAc?$AAe@ 0173 _lock_file 0188 _fseeki64_nolock 0196 _unlock_file"
	strings:
		$1 = { 44 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 58 48 83 7C 24 60 00 74 0A C7 44 24 30 01 00 00 00 EB 08 C7 44 24 30 00 00 00 00 8B 44 24 30 89 44 24 34 83 7C 24 34 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 3B 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 34 00 75 3E E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 3B 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 FF FF FF FF E9 E3 00 00 00 83 7C 24 70 00 74 18 83 7C 24 70 01 74 11 83 7C 24 70 02 74 0A C7 44 24 38 00 00 00 00 EB 08 C7 44 24 38 01 00 00 00 8B 44 24 38 89 44 24 3C 83 7C 24 3C 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 3C 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 3C 00 75 3B E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 3C 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 FF FF FF FF EB 31 48 8B 4C 24 60 E8 ?? ?? ?? ?? 90 44 8B 44 24 70 48 8B 54 24 68 48 8B 4C 24 60 E8 ?? ?? ?? ?? 89 44 24 40 48 8B 4C 24 60 E8 ?? ?? ?? ?? 8B 44 24 40 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_28_1_0 {
	meta:
		name = "_fseeki64$fin$0"
		size = 26
		refs = "000e _unlock_file"
		altNames = "clearerr_s$fin$0 fseek$fin$0"
	strings:
		$1 = { 40 55 48 83 EC 30 48 8B EA 48 8B 4D 60 E8 ?? ?? ?? ?? 90 48 83 C4 30 5D C3 CC }
	condition:
		$1
}

rule file_28_2_0 {
	meta:
		name = "_fseeki64_nolock"
		size = 381
		refs = "001e ??_C@_1BI@MFCLPIBM@?$AAs?$AAt?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 002a ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 003f ??_C@_1GO@MIODNAKM@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 0049 _CrtDbgReportW 0086 _errno 00ba _ftelli64_nolock 00dc _flush 0147 _fileno 0158 _lseeki64"
	strings:
		$1 = { 44 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 48 83 7C 24 50 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 63 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 48 8B 44 24 50 48 89 44 24 38 48 8B 44 24 38 8B 40 18 25 83 00 00 00 85 C0 74 15 83 7C 24 60 00 74 23 83 7C 24 60 01 74 1C 83 7C 24 60 02 74 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 B8 FF FF FF FF E9 DE 00 00 00 48 8B 44 24 38 8B 40 18 83 E0 EF 48 8B 4C 24 38 89 41 18 83 7C 24 60 01 75 22 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B 4C 24 58 48 03 C8 48 8B C1 48 89 44 24 58 C7 44 24 60 00 00 00 00 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B 44 24 38 8B 40 18 25 80 00 00 00 85 C0 74 15 48 8B 44 24 38 8B 40 18 83 E0 FC 48 8B 4C 24 38 89 41 18 EB 3B 48 8B 44 24 38 8B 40 18 83 E0 01 85 C0 74 2C 48 8B 44 24 38 8B 40 18 83 E0 08 85 C0 74 1D 48 8B 44 24 38 8B 40 18 25 00 04 00 00 85 C0 75 0C 48 8B 44 24 38 C7 40 24 00 02 00 00 48 8B 4C 24 38 E8 ?? ?? ?? ?? 44 8B 44 24 60 48 8B 54 24 58 8B C8 E8 ?? ?? ?? ?? 48 83 F8 FF 75 0A C7 44 24 30 FF FF FF FF EB 08 C7 44 24 30 00 00 00 00 8B 44 24 30 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_29_0_0 {
	meta:
		name = "_getstream"
		size = 574
		refs = "0013 _lock 002e _nstream 0044 __piob 00ab _mtinitlocknum 00cd _lock_file2 0102 _unlock_file2 0133 ??_C@_0DF@MDFFADLF@f?3?2dd?2vctools?2crt_bld?2self_64_am@ 0142 _malloc_dbg 0186 __imp_InitializeCriticalSectionAndSpinCount 01a3 __imp_EnterCriticalSection 0230 _unlock"
	strings:
		$1 = { 48 83 EC 48 48 C7 44 24 28 00 00 00 00 B9 01 00 00 00 E8 ?? ?? ?? ?? 90 C7 44 24 20 00 00 00 00 EB 0A 8B 44 24 20 FF C0 89 44 24 20 8B 05 ?? ?? ?? ?? 39 44 24 20 0F 8D 93 01 00 00 48 63 44 24 20 48 8B 0D ?? ?? ?? ?? 48 83 3C C1 00 0F 84 D7 00 00 00 48 63 44 24 20 48 8B 0D ?? ?? ?? ?? 48 8B 04 C1 8B 40 18 25 83 00 00 00 85 C0 0F 85 B2 00 00 00 48 63 44 24 20 48 8B 0D ?? ?? ?? ?? 48 8B 04 C1 8B 40 18 25 00 80 00 00 85 C0 0F 85 92 00 00 00 83 7C 24 20 02 7E 1E 83 7C 24 20 14 7D 17 8B 44 24 20 83 C0 10 8B C8 E8 ?? ?? ?? ?? 85 C0 75 05 E9 17 01 00 00 48 63 44 24 20 48 8B 0D ?? ?? ?? ?? 48 8B 14 C1 8B 4C 24 20 E8 ?? ?? ?? ?? 48 63 44 24 20 48 8B 0D ?? ?? ?? ?? 48 8B 04 C1 8B 40 18 25 83 00 00 00 85 C0 74 1E 48 63 44 24 20 48 8B 0D ?? ?? ?? ?? 48 8B 14 C1 8B 4C 24 20 E8 ?? ?? ?? ?? E9 17 FF FF FF 48 63 44 24 20 48 8B 0D ?? ?? ?? ?? 48 8B 04 C1 48 89 44 24 28 E9 AA 00 00 00 E9 A0 00 00 00 41 B9 59 00 00 00 4C 8D 05 ?? ?? ?? ?? BA 02 00 00 00 B9 58 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 30 48 63 44 24 20 48 8B 0D ?? ?? ?? ?? 48 8B 54 24 30 48 89 14 C1 48 83 7C 24 30 00 74 60 48 63 44 24 20 48 8B 0D ?? ?? ?? ?? 48 8B 04 C1 48 83 C0 30 BA A0 0F 00 00 48 8B C8 FF 15 ?? ?? ?? ?? 48 63 44 24 20 48 8B 0D ?? ?? ?? ?? 48 8B 04 C1 48 83 C0 30 48 8B C8 FF 15 ?? ?? ?? ?? 48 63 44 24 20 48 8B 0D ?? ?? ?? ?? 48 8B 04 C1 48 89 44 24 28 48 8B 44 24 28 C7 40 18 00 00 00 00 EB 05 E9 53 FE FF FF 48 83 7C 24 28 00 74 53 48 8B 44 24 28 8B 40 18 25 00 80 00 00 48 8B 4C 24 28 89 41 18 48 8B 44 24 28 C7 40 08 00 00 00 00 48 8B 44 24 28 48 C7 40 10 00 00 00 00 48 8B 44 24 28 48 C7 00 00 00 00 00 48 8B 44 24 28 48 C7 40 28 00 00 00 00 48 8B 44 24 28 C7 40 1C FF FF FF FF B9 01 00 00 00 E8 ?? ?? ?? ?? 48 8B 44 24 28 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_29_1_0 {
	meta:
		name = "_getstream$fin$0"
		size = 27
		refs = "000f _unlock"
		altNames = "_fcloseall$fin$0 _rmtmp$fin$1 flsall$fin$1"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA B9 01 00 00 00 E8 ?? ?? ?? ?? 90 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_30_0_0 {
	meta:
		name = "_wscanf_l"
		size = 66
		refs = "0034 _winput_l 0039 vwscanf"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 50 48 89 44 24 20 4C 8B 4C 24 20 4C 8B 44 24 48 48 8B 54 24 40 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_553_0_0 {
	meta:
		name = "_scanf_l"
		size = 66
		refs = "0034 _input_l 0039 vscanf"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 50 48 89 44 24 20 4C 8B 4C 24 20 4C 8B 44 24 48 48 8B 54 24 40 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_553_1_0 {
	meta:
		name = "_scanf_s_l"
		size = 66
		refs = "0034 _input_s_l 0039 vscanf"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 50 48 89 44 24 20 4C 8B 4C 24 20 4C 8B 44 24 48 48 8B 54 24 40 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_30_1_0 {
	meta:
		name = "_wscanf_s_l"
		size = 66
		refs = "0034 _winput_s_l 0039 vwscanf"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 50 48 89 44 24 20 4C 8B 4C 24 20 4C 8B 44 24 48 48 8B 54 24 40 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_30_2_0 {
	meta:
		name = "vwscanf"
		size = 296
		refs = "0044 ??_C@_1CC@MGIEJOME@?$AA?$CI?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0050 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0065 ??_C@_1GK@GKCANAP@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 006f _CrtDbgReportW 0083 _errno 00a6 ??_C@_1BA@EJOHPNHF@?$AAv?$AAw?$AAs?$AAc?$AAa?$AAn?$AAf?$AA?$AA@ 00b2 _invalid_parameter 00be __iob_func 00d4 _lock_file2 011b _unlock_file2"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 48 83 7C 24 58 00 74 0A C7 44 24 30 01 00 00 00 EB 08 C7 44 24 30 00 00 00 00 8B 44 24 30 89 44 24 34 83 7C 24 34 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 32 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 34 00 75 3B E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 32 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 FF FF FF FF EB 66 E8 ?? ?? ?? ?? B9 30 00 00 00 48 6B C9 00 48 03 C1 48 8B D0 33 C9 E8 ?? ?? ?? ?? 90 E8 ?? ?? ?? ?? B9 30 00 00 00 48 6B C9 00 48 03 C1 4C 8B 4C 24 68 4C 8B 44 24 60 48 8B 54 24 58 48 8B C8 FF 54 24 50 89 44 24 38 E8 ?? ?? ?? ?? B9 30 00 00 00 48 6B C9 00 48 03 C1 48 8B D0 33 C9 E8 ?? ?? ?? ?? 8B 44 24 38 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_553_4_0 {
	meta:
		name = "vscanf"
		size = 296
		refs = "0044 ??_C@_1CC@MGIEJOME@?$AA?$CI?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0050 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0065 ??_C@_1GI@BLPJENF@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 006f _CrtDbgReportW 0083 _errno 00a6 ??_C@_1O@GFBPPEGM@?$AAv?$AAs?$AAc?$AAa?$AAn?$AAf?$AA?$AA@ 00b2 _invalid_parameter 00be __iob_func 00d4 _lock_file2 011b _unlock_file2"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 48 83 7C 24 58 00 74 0A C7 44 24 30 01 00 00 00 EB 08 C7 44 24 30 00 00 00 00 8B 44 24 30 89 44 24 34 83 7C 24 34 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 32 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 34 00 75 3B E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 32 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 FF FF FF FF EB 66 E8 ?? ?? ?? ?? B9 30 00 00 00 48 6B C9 00 48 03 C1 48 8B D0 33 C9 E8 ?? ?? ?? ?? 90 E8 ?? ?? ?? ?? B9 30 00 00 00 48 6B C9 00 48 03 C1 4C 8B 4C 24 68 4C 8B 44 24 60 48 8B 54 24 58 48 8B C8 FF 54 24 50 89 44 24 38 E8 ?? ?? ?? ?? B9 30 00 00 00 48 6B C9 00 48 03 C1 48 8B D0 33 C9 E8 ?? ?? ?? ?? 8B 44 24 38 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_30_3_0 {
	meta:
		name = "vwscanf$fin$0"
		size = 45
		refs = "000a __iob_func 0021 _unlock_file2"
		altNames = "_gets_helper$fin$0 _getws_helper$fin$0 vscanf$fin$0"
	strings:
		$1 = { 40 55 48 83 EC 30 48 8B EA E8 ?? ?? ?? ?? 90 B9 30 00 00 00 48 6B C9 00 48 03 C1 48 8B D0 33 C9 E8 ?? ?? ?? ?? 90 48 83 C4 30 5D C3 CC }
	condition:
		$1
}

rule file_30_4_0 {
	meta:
		name = "wscanf"
		size = 64
		refs = "0032 _winput_l 0037 vwscanf"
	strings:
		$1 = { 48 89 4C 24 08 48 89 54 24 10 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 48 48 89 44 24 20 4C 8B 4C 24 20 45 33 C0 48 8B 54 24 40 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_553_2_0 {
	meta:
		name = "scanf"
		size = 64
		refs = "0032 _input_l 0037 vscanf"
	strings:
		$1 = { 48 89 4C 24 08 48 89 54 24 10 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 48 48 89 44 24 20 4C 8B 4C 24 20 45 33 C0 48 8B 54 24 40 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_553_3_0 {
	meta:
		name = "scanf_s"
		size = 64
		refs = "0032 _input_s_l 0037 vscanf"
	strings:
		$1 = { 48 89 4C 24 08 48 89 54 24 10 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 48 48 89 44 24 20 4C 8B 4C 24 20 45 33 C0 48 8B 54 24 40 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_30_5_0 {
	meta:
		name = "wscanf_s"
		size = 64
		refs = "0032 _winput_s_l 0037 vwscanf"
	strings:
		$1 = { 48 89 4C 24 08 48 89 54 24 10 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 48 48 89 44 24 20 4C 8B 4C 24 20 45 33 C0 48 8B 54 24 40 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_32_0_0 {
	meta:
		name = "_fwprintf_l"
		size = 64
		refs = "0037 _vfwprintf_l"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 58 48 89 44 24 20 4C 8B 4C 24 20 4C 8B 44 24 50 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_738_0_0 {
	meta:
		name = "__swprintf_l"
		size = 64
		refs = "0037 __vswprintf_l"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 58 48 89 44 24 20 4C 8B 4C 24 20 4C 8B 44 24 50 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_247_0_0 {
	meta:
		name = "_fprintf_l"
		size = 64
		refs = "0037 _vfprintf_l"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 58 48 89 44 24 20 4C 8B 4C 24 20 4C 8B 44 24 50 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_247_2_0 {
	meta:
		name = "_fprintf_p_l"
		size = 64
		refs = "0037 _vfprintf_p_l"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 58 48 89 44 24 20 4C 8B 4C 24 20 4C 8B 44 24 50 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_247_3_0 {
	meta:
		name = "_fprintf_s_l"
		size = 64
		refs = "0037 _vfprintf_s_l"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 58 48 89 44 24 20 4C 8B 4C 24 20 4C 8B 44 24 50 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_32_2_0 {
	meta:
		name = "_fwprintf_p_l"
		size = 64
		refs = "0037 _vfwprintf_p_l"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 58 48 89 44 24 20 4C 8B 4C 24 20 4C 8B 44 24 50 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_32_3_0 {
	meta:
		name = "_fwprintf_s_l"
		size = 64
		refs = "0037 _vfwprintf_s_l"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 58 48 89 44 24 20 4C 8B 4C 24 20 4C 8B 44 24 50 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1047_6_0 {
	meta:
		name = "_sprintf_l"
		size = 64
		refs = "0037 _vsprintf_l"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 58 48 89 44 24 20 4C 8B 4C 24 20 4C 8B 44 24 50 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_32_1_0 {
	meta:
		name = "_fwprintf_p"
		size = 62
		refs = "0035 _vfwprintf_p_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 50 48 89 44 24 20 4C 8B 4C 24 20 45 33 C0 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_247_1_0 {
	meta:
		name = "_fprintf_p"
		size = 62
		refs = "0035 _vfprintf_p_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 50 48 89 44 24 20 4C 8B 4C 24 20 45 33 C0 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_247_6_0 {
	meta:
		name = "fprintf_s"
		size = 62
		refs = "0035 _vfprintf_s_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 50 48 89 44 24 20 4C 8B 4C 24 20 45 33 C0 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_32_6_0 {
	meta:
		name = "fwprintf_s"
		size = 62
		refs = "0035 _vfwprintf_s_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 50 48 89 44 24 20 4C 8B 4C 24 20 45 33 C0 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_32_4_0 {
	meta:
		name = "fwprintf"
		size = 466
		refs = "0044 ??_C@_1BM@JMKHIAHP@?$AA?$CI?$AAs?$AAt?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0050 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0065 ??_C@_1GO@EPDDMOOF@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 006f _CrtDbgReportW 0083 _errno 00a6 ??_C@_1BC@BHLPNJBO@?$AAf?$AAw?$AAp?$AAr?$AAi?$AAn?$AAt?$AAf?$AA?$AA@ 00b2 _invalid_parameter 00ec ??_C@_1CC@MGIEJOME@?$AA?$CI?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0182 _lock_file 018d _stbuf 01a8 _woutput_l 01ba _ftbuf 01c5 _unlock_file"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 68 48 83 7C 24 70 00 74 0A C7 44 24 30 01 00 00 00 EB 08 C7 44 24 30 00 00 00 00 8B 44 24 30 89 44 24 34 83 7C 24 34 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 38 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 34 00 75 3E E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 38 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 FF FF FF FF E9 0D 01 00 00 48 83 7C 24 78 00 74 0A C7 44 24 38 01 00 00 00 EB 08 C7 44 24 38 00 00 00 00 8B 44 24 38 89 44 24 3C 83 7C 24 3C 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 39 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 3C 00 75 3B E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 39 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 FF FF FF FF EB 68 48 8D 84 24 80 00 00 00 48 89 44 24 50 48 8B 44 24 70 48 89 44 24 48 48 8B 4C 24 48 E8 ?? ?? ?? ?? 90 48 8B 4C 24 48 E8 ?? ?? ?? ?? 89 44 24 40 4C 8B 4C 24 50 45 33 C0 48 8B 54 24 78 48 8B 4C 24 48 E8 ?? ?? ?? ?? 89 44 24 44 48 8B 54 24 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 4C 24 48 E8 ?? ?? ?? ?? 8B 44 24 44 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_32_5_0 {
	meta:
		name = "fwprintf$fin$0"
		size = 26
		refs = "000e _unlock_file"
		altNames = "_fdopen$fin$0 _wfdopen$fin$0 vfwprintf_helper$fin$0"
	strings:
		$1 = { 40 55 48 83 EC 30 48 8B EA 48 8B 4D 48 E8 ?? ?? ?? ?? 90 48 83 C4 30 5D C3 CC }
	condition:
		$1
}

rule file_268_95_0 {
	meta:
		name = "?fin$0@?0??DetachStealers@ContextBase@details@Concurrency@@QEAAXXZ@4HA"
		size = 26
		refs = "000e ?ReleaseWrite@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QEBAXXZ"
	strings:
		$1 = { 40 55 48 83 EC 30 48 8B EA 48 8B 4D 48 E8 ?? ?? ?? ?? 90 48 83 C4 30 5D C3 CC }
	condition:
		$1
}

rule file_33_3_0 {
	meta:
		name = "_mbsnset_s_l"
		size = 2138
		refs = "008d ??_C@_1FC@NCPEPIBI@?$AA?$CI?$AA?$CI?$AA_?$AAD?$AAs?$AAt?$AA?$CJ?$AA?$CJ?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?$CI?$AA_?$AAS?$AAi?$AAz?$AAe?$AAI?$AAn?$AAB?$AAy?$AAt@ 0099 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 00ae ??_C@_1HE@PPOLBKNM@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 00b8 _CrtDbgReportW 00cc _errno 00ef ??_C@_1BK@JMCNLJKB@?$AA_?$AAm?$AAb?$AAs?$AAn?$AAs?$AAe?$AAt?$AA_?$AAs?$AA_?$AAl?$AA?$AA@ 00fb _invalid_parameter 011a ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 0127 ?GetLocaleT@_LocaleUpdate@@QEAAPEAUlocaleinfo_struct@@XZ 0156 _strnset_s 0167 ??1_LocaleUpdate@@QEAA@XZ 01d4 _ismbblead_l 0248 __crtDebugFillThreshold 028e memset 02bc _CrtGetCheckCount 02d9 ??_C@_1CI@HCPHDDLE@?$AAB?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AAi?$AAs?$AA?5?$AAt?$AAo?$AAo?$AA?5?$AAs?$AAm?$AAa?$AAl?$AAl?$AA?$AA@ 0654 ??_C@_1DM@FHLMIEG@?$AAS?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AAi?$AAs?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAn?$AAu?$AAl?$AAl?$AA?5?$AAt?$AAe?$AAr?$AAm?$AAi?$AAn?$AAa?$AAt?$AAe?$AAd?$AA?$AA@ 0687 ??_C@_1FA@MJKDNFFB@?$AA?$CI?$AAL?$AA?$CC?$AAS?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AAi?$AAs?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAn?$AAu?$AAl?$AAl?$AA?5?$AAt?$AAe?$AAr?$AAm?$AAi?$AAn?$AAa?$AAt?$AAe?$AAd@"
	strings:
		$1 = { 4C 89 4C 24 20 44 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 81 EC C8 00 00 00 C7 44 24 4C 00 00 00 00 C7 44 24 48 00 00 00 00 48 83 BC 24 E8 00 00 00 00 75 1D 48 83 BC 24 D0 00 00 00 00 75 12 48 83 BC 24 D8 00 00 00 00 75 07 33 C0 E9 FF 07 00 00 48 83 BC 24 D0 00 00 00 00 74 15 48 83 BC 24 D8 00 00 00 00 76 0A C7 44 24 58 01 00 00 00 EB 08 C7 44 24 58 00 00 00 00 8B 44 24 58 89 44 24 68 83 7C 24 68 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 1E 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 68 00 75 3E E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 1E 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 16 00 00 00 E9 49 07 00 00 48 8B 94 24 F0 00 00 00 48 8D 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 48 8D 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 48 8B 40 08 83 78 08 00 75 3F 4C 8B 8C 24 E8 00 00 00 44 8B 84 24 E0 00 00 00 48 8B 94 24 D8 00 00 00 48 8B 8C 24 D0 00 00 00 E8 ?? ?? ?? ?? 89 44 24 78 48 8D 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 8B 44 24 78 E9 DE 06 00 00 48 8B 84 24 D0 00 00 00 48 89 44 24 38 48 8B 84 24 D8 00 00 00 48 89 44 24 40 8B 84 24 E0 00 00 00 C1 E8 08 88 44 24 30 8B 84 24 E0 00 00 00 25 FF 00 00 00 88 44 24 31 0F B6 44 24 30 85 C0 74 27 0F B6 44 24 31 85 C0 74 4D 48 8D 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 0F B6 4C 24 30 48 8B D0 E8 ?? ?? ?? ?? 85 C0 74 2F 0F B6 44 24 30 85 C0 0F 85 D2 00 00 00 48 8D 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 0F B6 4C 24 31 48 8B D0 E8 ?? ?? ?? ?? 85 C0 0F 84 B0 00 00 00 48 8B 84 24 D0 00 00 00 C6 00 00 48 83 BC 24 D8 00 00 00 FF 74 71 48 81 BC 24 D8 00 00 00 FF FF FF 7F 74 63 48 83 BC 24 D8 00 00 00 01 76 58 48 8B 84 24 D8 00 00 00 48 FF C8 48 39 05 ?? ?? ?? ?? 73 11 48 8B 05 ?? ?? ?? ?? 48 89 84 24 A0 00 00 00 EB 13 48 8B 84 24 D8 00 00 00 48 FF C8 48 89 84 24 A0 00 00 00 48 8B 84 24 D0 00 00 00 48 FF C0 4C 8B 84 24 A0 00 00 00 BA FE 00 00 00 48 8B C8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 00 2A 00 00 00 C7 44 24 74 2A 00 00 00 48 8D 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 8B 44 24 74 E9 97 05 00 00 E8 ?? ?? ?? ?? 85 C0 74 4C 48 8B 84 24 D8 00 00 00 48 39 84 24 E8 00 00 00 72 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 35 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 0F B6 44 24 30 85 C0 0F 84 4A 01 00 00 48 8B 44 24 38 0F B6 00 85 C0 0F 84 35 01 00 00 48 83 BC 24 E8 00 00 00 00 0F 86 26 01 00 00 48 8B 44 24 40 48 FF C8 48 89 44 24 40 48 83 7C 24 40 00 0F 86 0D 01 00 00 B8 01 00 00 00 48 6B C0 01 48 8B 4C 24 38 0F B6 04 01 85 C0 75 22 48 8B 44 24 38 C6 00 00 48 8B 44 24 40 48 FF C0 48 89 44 24 40 C7 44 24 4C 01 00 00 00 E9 D5 00 00 00 83 7C 24 48 00 74 0A C7 44 24 64 00 00 00 00 EB 21 48 8D 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 48 8B 4C 24 38 0F B6 09 48 8B D0 E8 ?? ?? ?? ?? 89 44 24 64 8B 44 24 64 89 44 24 48 48 8B 44 24 38 0F B6 4C 24 30 88 08 48 8B 44 24 38 48 FF C0 48 89 44 24 38 48 8B 44 24 40 48 FF C8 48 89 44 24 40 48 83 7C 24 40 00 75 02 EB 6B 83 7C 24 48 00 74 0A C7 44 24 60 00 00 00 00 EB 21 48 8D 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 48 8B 4C 24 38 0F B6 09 48 8B D0 E8 ?? ?? ?? ?? 89 44 24 60 8B 44 24 60 89 44 24 48 48 8B 44 24 38 0F B6 4C 24 31 88 08 48 8B 44 24 38 48 FF C0 48 89 44 24 38 48 8B 84 24 E8 00 00 00 48 FF C8 48 89 84 24 E8 00 00 00 E9 BB FE FF FF E9 9F 00 00 00 48 8B 44 24 38 0F B6 00 85 C0 0F 84 8F 00 00 00 48 83 BC 24 E8 00 00 00 00 0F 86 80 00 00 00 48 8B 44 24 40 48 FF C8 48 89 44 24 40 48 83 7C 24 40 00 76 6B 83 7C 24 48 00 74 0A C7 44 24 5C 00 00 00 00 EB 21 48 8D 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 48 8B 4C 24 38 0F B6 09 48 8B D0 E8 ?? ?? ?? ?? 89 44 24 5C 8B 44 24 5C 89 44 24 48 48 8B 44 24 38 0F B6 4C 24 31 88 08 48 8B 44 24 38 48 FF C0 48 89 44 24 38 48 8B 84 24 E8 00 00 00 48 FF C8 48 89 84 24 E8 00 00 00 E9 61 FF FF FF 48 83 BC 24 E8 00 00 00 00 75 72 83 7C 24 48 00 74 6B 48 8B 44 24 38 0F B6 00 85 C0 74 5F 48 8B 44 24 40 48 FF C8 48 89 44 24 40 48 83 7C 24 40 00 76 4A C7 44 24 4C 01 00 00 00 B8 01 00 00 00 48 6B C0 01 48 8B 4C 24 38 0F B6 04 01 85 C0 75 17 48 8B 44 24 38 C6 00 00 48 8B 44 24 40 48 FF C0 48 89 44 24 40 EB 15 48 8B 44 24 38 C6 00 20 48 8B 44 24 38 48 FF C0 48 89 44 24 38 48 83 BC 24 E8 00 00 00 00 75 30 48 8B 44 24 38 0F B6 00 85 C0 74 24 48 8B 44 24 40 48 FF C8 48 89 44 24 40 48 83 7C 24 40 00 76 0F 48 8B 44 24 38 48 FF C0 48 89 44 24 38 EB D0 48 83 7C 24 40 00 0F 85 4D 01 00 00 48 8B 84 24 D0 00 00 00 C6 00 00 48 83 BC 24 D8 00 00 00 FF 74 71 48 81 BC 24 D8 00 00 00 FF FF FF 7F 74 63 48 83 BC 24 D8 00 00 00 01 76 58 48 8B 84 24 D8 00 00 00 48 FF C8 48 39 05 ?? ?? ?? ?? 73 11 48 8B 05 ?? ?? ?? ?? 48 89 84 24 B0 00 00 00 EB 13 48 8B 84 24 D8 00 00 00 48 FF C8 48 89 84 24 B0 00 00 00 48 8B 84 24 D0 00 00 00 48 FF C0 4C 8B 84 24 B0 00 00 00 BA FE 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 85 C0 74 10 33 C0 85 C0 74 0A C7 44 24 54 01 00 00 00 EB 08 C7 44 24 54 00 00 00 00 8B 44 24 54 89 44 24 50 83 7C 24 50 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 81 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 50 00 75 52 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 81 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 44 24 70 16 00 00 00 48 8D 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 8B 44 24 70 E9 3B 01 00 00 48 83 BC 24 D8 00 00 00 FF 0F 84 D5 00 00 00 48 81 BC 24 D8 00 00 00 FF FF FF 7F 0F 84 C3 00 00 00 48 8B 44 24 40 48 8B 8C 24 D8 00 00 00 48 2B C8 48 8B C1 48 FF C0 48 3B 84 24 D8 00 00 00 0F 83 9F 00 00 00 48 8B 44 24 40 48 8B 8C 24 D8 00 00 00 48 2B C8 48 8B C1 48 FF C0 48 8B 8C 24 D8 00 00 00 48 2B C8 48 8B C1 48 39 05 ?? ?? ?? ?? 73 11 48 8B 05 ?? ?? ?? ?? 48 89 84 24 A8 00 00 00 EB 2C 48 8B 44 24 40 48 8B 8C 24 D8 00 00 00 48 2B C8 48 8B C1 48 FF C0 48 8B 8C 24 D8 00 00 00 48 2B C8 48 8B C1 48 89 84 24 A8 00 00 00 48 8B 44 24 40 48 8B 8C 24 D8 00 00 00 48 2B C8 48 8B C1 48 8B 8C 24 D0 00 00 00 48 8D 44 01 01 4C 8B 84 24 A8 00 00 00 BA FE 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 83 7C 24 4C 00 74 28 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 C7 44 24 6C 2A 00 00 00 48 8D 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 8B 44 24 6C EB 2A EB 1B C7 44 24 7C 00 00 00 00 48 8D 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 8B 44 24 7C EB 0D 48 8D 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 C8 00 00 00 C3 }
	condition:
		$1
}

rule file_36_0_0 {
	meta:
		name = "_invoke_watson_if_error"
		size = 72
		refs = "003f _invoke_watson"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 89 4C 24 08 48 83 EC 38 83 7C 24 40 00 75 02 EB 23 48 8B 44 24 68 48 89 44 24 20 44 8B 4C 24 60 4C 8B 44 24 58 48 8B 54 24 50 48 8B 4C 24 48 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_36_1_0 {
	meta:
		name = "_wcsdup"
		size = 35
		refs = "001a _wcsdup_dbg"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 45 33 C9 45 33 C0 BA 01 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1146_60_0 {
	meta:
		name = "_heap_alloc"
		size = 35
		refs = "001a _heap_alloc_dbg"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 45 33 C9 45 33 C0 BA 01 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1002_1_0 {
	meta:
		name = "_strdup"
		size = 35
		refs = "001a _strdup_dbg"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 45 33 C9 45 33 C0 BA 01 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_36_2_0 {
	meta:
		name = "_wcsdup_dbg"
		size = 190
		refs = "0035 wcslen 005e _calloc_dbg 007f wcscpy_s 0097 ??_C@_1GK@HLAODKFO@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 009e ??_C@_1BI@JDKFAFNF@?$AA_?$AAw?$AAc?$AAs?$AAd?$AAu?$AAp?$AA_?$AAd?$AAb?$AAg?$AA?$AA@ 00a5 ??_C@_1DO@DDNFKJAL@?$AAw?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAm?$AAe?$AAm?$AAo?$AAr?$AAy?$AA?0?$AA?5?$AAs?$AAi?$AAz?$AAe?$AA?0?$AA?5?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?$CJ?$AA?$AA@ 00ac _invoke_watson_if_error"
	strings:
		$1 = { 44 89 4C 24 20 4C 89 44 24 18 89 54 24 10 48 89 4C 24 08 48 83 EC 48 48 C7 44 24 30 00 00 00 00 48 83 7C 24 50 00 75 07 33 C0 E9 8A 00 00 00 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 FF C0 48 89 44 24 30 8B 44 24 68 89 44 24 20 4C 8B 4C 24 60 44 8B 44 24 58 BA 02 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 89 44 24 38 48 83 7C 24 38 00 74 48 4C 8B 44 24 50 48 8B 54 24 30 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 52 00 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 48 8B 44 24 38 EB 02 33 C0 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_37_0_0 {
	meta:
		name = "_wfopen"
		size = 40
		refs = "001f _wfsopen"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 41 B8 40 00 00 00 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_614_2_0 {
	meta:
		name = "fopen"
		size = 40
		refs = "001f _fsopen"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 41 B8 40 00 00 00 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_37_1_0 {
	meta:
		name = "_wfopen_s"
		size = 240
		refs = "003f ??_C@_1CA@LLJLFCDN@?$AA?$CI?$AAp?$AAf?$AAi?$AAl?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 004b ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0060 ??_C@_1GI@LIMKHKB@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 006a _CrtDbgReportW 007e _errno 00a1 ??_C@_1BE@JDODBHOJ@?$AA_?$AAw?$AAf?$AAo?$AAp?$AAe?$AAn?$AA_?$AAs?$AA?$AA@ 00ad _invalid_parameter 00c9 _wfsopen"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 48 83 7C 24 50 00 74 0A C7 44 24 30 01 00 00 00 EB 08 C7 44 24 30 00 00 00 00 8B 44 24 30 89 44 24 34 83 7C 24 34 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 9F 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 34 00 75 3B E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 9F 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 16 00 00 00 EB 33 41 B8 80 00 00 00 48 8B 54 24 60 48 8B 4C 24 58 E8 ?? ?? ?? ?? 48 8B 4C 24 50 48 89 01 48 8B 44 24 50 48 83 38 00 74 04 33 C0 EB 07 E8 ?? ?? ?? ?? 8B 00 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_614_3_0 {
	meta:
		name = "fopen_s"
		size = 240
		refs = "003f ??_C@_1CA@LLJLFCDN@?$AA?$CI?$AAp?$AAf?$AAi?$AAl?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 004b ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0060 ??_C@_1GI@LIMKHKB@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 006a _CrtDbgReportW 007e _errno 00a1 ??_C@_1BA@PBGKCCAP@?$AAf?$AAo?$AAp?$AAe?$AAn?$AA_?$AAs?$AA?$AA@ 00ad _invalid_parameter 00c9 _fsopen"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 48 83 7C 24 50 00 74 0A C7 44 24 30 01 00 00 00 EB 08 C7 44 24 30 00 00 00 00 8B 44 24 30 89 44 24 34 83 7C 24 34 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 9F 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 34 00 75 3B E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 9F 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 16 00 00 00 EB 33 41 B8 80 00 00 00 48 8B 54 24 60 48 8B 4C 24 58 E8 ?? ?? ?? ?? 48 8B 4C 24 50 48 89 01 48 8B 44 24 50 48 83 38 00 74 04 33 C0 EB 07 E8 ?? ?? ?? ?? 8B 00 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_37_2_0 {
	meta:
		name = "_wfsopen"
		size = 701
		refs = "0059 ??_C@_1BO@CLGIAEOJ@?$AA?$CI?$AAf?$AAi?$AAl?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0065 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 007a ??_C@_1GI@LIMKHKB@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 0084 _CrtDbgReportW 0098 _errno 00bb ??_C@_1BC@PAJNLEOB@?$AA_?$AAw?$AAf?$AAs?$AAo?$AAp?$AAe?$AAn?$AA?$AA@ 00c7 _invalid_parameter 0101 ??_C@_1BO@MJMKAKCJ@?$AA?$CI?$AAm?$AAo?$AAd?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 01ad ??_C@_1CI@HBNALCBB@?$AA?$CI?$AA?$CK?$AAm?$AAo?$AAd?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$CJ?$AA?$AA@ 0227 _getstream 0277 _local_unwind 0299 _wopenfile 02a8 _unlock_file"
	strings:
		$1 = { 44 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 78 48 89 64 24 68 48 C7 44 24 40 00 00 00 00 48 C7 44 24 58 00 00 00 00 48 83 BC 24 80 00 00 00 00 74 0A C7 44 24 50 01 00 00 00 EB 08 C7 44 24 50 00 00 00 00 8B 44 24 50 89 44 24 38 83 7C 24 38 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 36 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 38 00 75 3B E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 36 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 E9 E6 01 00 00 48 83 BC 24 88 00 00 00 00 74 0A C7 44 24 4C 01 00 00 00 EB 08 C7 44 24 4C 00 00 00 00 8B 44 24 4C 89 44 24 48 83 7C 24 48 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 37 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 48 00 75 3B E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 37 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 E9 3E 01 00 00 48 8B 84 24 88 00 00 00 0F B7 00 85 C0 74 0A C7 44 24 30 01 00 00 00 EB 08 C7 44 24 30 00 00 00 00 8B 44 24 30 89 44 24 34 83 7C 24 34 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 38 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 34 00 75 3B E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 38 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 E9 92 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 40 48 83 7C 24 40 00 75 0F E8 ?? ?? ?? ?? C7 00 18 00 00 00 33 C0 EB 71 48 8B 84 24 80 00 00 00 0F B7 00 85 C0 75 25 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 60 00 00 00 00 48 8D 15 42 00 00 00 48 8B 4C 24 68 E8 ?? ?? ?? ?? 4C 8B 4C 24 40 44 8B 84 24 90 00 00 00 48 8B 94 24 88 00 00 00 48 8B 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 58 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 44 24 58 EB 05 48 8B 44 24 60 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_37_3_0 {
	meta:
		name = "_wfsopen$fin$0"
		size = 26
		refs = "000e _unlock_file"
		altNames = "_fsopen$fin$0 fputwc$fin$0 rewind$fin$0 vprintf_helper$fin$0 vwprintf_helper$fin$0"
	strings:
		$1 = { 40 55 48 83 EC 30 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 90 48 83 C4 30 5D C3 CC }
	condition:
		$1
}

rule file_38_0_0 {
	meta:
		name = "_lsearch"
		size = 1003
		refs = "004c ??_C@_1BI@OEOAAOGG@?$AAk?$AAe?$AAy?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0058 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 006d ??_C@_1GM@OCJANOGF@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 0077 _CrtDbgReportW 008b _errno 00ae ??_C@_1BC@OCILDANA@?$AA_?$AAl?$AAs?$AAe?$AAa?$AAr?$AAc?$AAh?$AA?$AA@ 00ba _invalid_parameter 00f4 ??_C@_1BI@LBPPPCD@?$AAn?$AAu?$AAm?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0199 ??_C@_1BK@FFEIJADH@?$AAb?$AAa?$AAs?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0240 ??_C@_1BE@NJBEBBME@?$AAw?$AAi?$AAd?$AAt?$AAh?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 02e8 ??_C@_1CA@OIBGFNKD@?$AAc?$AAo?$AAm?$AAp?$AAa?$AAr?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 03c7 memcpy"
	strings:
		$1 = { 44 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 68 C7 44 24 30 00 00 00 00 48 83 7C 24 70 00 74 0A C7 44 24 54 01 00 00 00 EB 08 C7 44 24 54 00 00 00 00 8B 44 24 54 89 44 24 3C 83 7C 24 3C 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 55 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 3C 00 75 3B E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 55 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 E9 21 03 00 00 48 83 BC 24 80 00 00 00 00 74 0A C7 44 24 4C 01 00 00 00 EB 08 C7 44 24 4C 00 00 00 00 8B 44 24 4C 89 44 24 44 83 7C 24 44 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 56 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 44 00 75 3B E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 56 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 E9 79 02 00 00 48 83 7C 24 78 00 74 0A C7 44 24 34 01 00 00 00 EB 08 C7 44 24 34 00 00 00 00 8B 44 24 34 89 44 24 38 83 7C 24 38 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 57 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 38 00 75 3B E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 57 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 E9 D4 01 00 00 83 BC 24 88 00 00 00 00 76 0A C7 44 24 40 01 00 00 00 EB 08 C7 44 24 40 00 00 00 00 8B 44 24 40 89 44 24 48 83 7C 24 48 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 58 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 48 00 75 3B E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 58 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 E9 2D 01 00 00 48 83 BC 24 90 00 00 00 00 74 0A C7 44 24 50 01 00 00 00 EB 08 C7 44 24 50 00 00 00 00 8B 44 24 50 89 44 24 58 83 7C 24 58 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 59 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 58 00 75 3B E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 59 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 E9 85 00 00 00 48 8B 84 24 80 00 00 00 8B 00 39 44 24 30 73 41 48 8B 54 24 78 48 8B 4C 24 70 FF 94 24 90 00 00 00 85 C0 75 09 48 8B 44 24 78 EB 59 EB 21 8B 84 24 88 00 00 00 48 8B 4C 24 78 48 03 C8 48 8B C1 48 89 44 24 78 8B 44 24 30 FF C0 89 44 24 30 EB AF 8B 84 24 88 00 00 00 44 8B C0 48 8B 54 24 70 48 8B 4C 24 78 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 8B 00 FF C0 48 8B 8C 24 80 00 00 00 89 01 48 8B 44 24 78 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_39_0_0 {
	meta:
		name = "_tell"
		size = 30
		refs = "0015 _lseek"
		altNames = "_telli64"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 41 B8 01 00 00 00 33 D2 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_40_3_0 {
	meta:
		name = "_output_s_l"
		size = 6604
		refs = "001e __security_cookie 007c ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 008d _errno 009a _ioinit 00b6 ??1_LocaleUpdate@@QEAA@XZ 0104 ??_C@_1CC@FADMNIL@?$AA?$CI?$AAs?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0110 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0125 ??_C@_1GK@BJNDONIJ@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 012f _CrtDbgReportW 0169 ??_C@_1BI@COFBLHCG@?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAs?$AA_?$AAl?$AA?$AA@ 0175 _invalid_parameter 01cc _fileno 01ee __pioinfo 0214 __badioinfo 02cf ??_C@_1BAA@ODEGEDCK@?$AA?$CI?$AA?5?$AA?$CI?$AA_?$AAS?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?9?$AA?$DO?$AA_?$AAf?$AAl?$AAa?$AAg?$AA?5?$AA?$CG?$AA?5?$AA_?$AAI?$AAO?$AAS?$AAT?$AAR?$AAG?$AA?$CJ?$AA?5?$AA?$HM?$AA?$HM?$AA?5@ 03a6 ??_C@_1CC@MGIEJOME@?$AA?$CI?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 04d6 __lookuptable_s 0569 ??_C@_1EE@DMAIGNBG@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAc?$AAo?$AAr?$AAr?$AAe?$AAc?$AAt?$AA?5?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AAs?$AAp?$AAe?$AAc?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?$CC?$AA?0?$AA?5?$AA0@ 0626 __ImageBase 062d $LN181 0647 ?GetLocaleT@_LocaleUpdate@@QEAAPEAUlocaleinfo_struct@@XZ 0654 _isleadbyte_l 0673 write_char 06d5 ??_C@_1CC@IFFHEMNF@?$AA?$CI?$AAc?$AAh?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$CJ?$AA?$AA@ 0859 get_int_arg 0ace $LN179 0ad5 $LN180 0b18 get_short_arg 0b41 wctomb_s 0bb3 get_int64_arg 0bdc __nullstring 0beb strlen 0ccf __wnullstring 0de3 _get_printf_count_output 0e28 ??_C@_1EK@PNGFDECN@?$AA?$CI?$AA?$CC?$AA?8?$AAn?$AA?8?$AA?5?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AAs?$AAp?$AAe?$AAc?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?5?$AAd?$AAi?$AAs?$AAa?$AAb?$AAl?$AAe?$AAd?$AA?$CC@ 0f97 ??_C@_0DF@MNLBDNAL@f?3?2dd?2vctools?2crt_bld?2self_64_am@ 0fa4 _malloc_dbg 109b _cfltcvt_tab 10a5 __imp_DecodePointer 163f write_multi_char 1667 write_string 1814 _free_dbg 186a ??_C@_1FK@LNCFKALM@?$AA?$CI?$AA?$CI?$AAs?$AAt?$AAa?$AAt?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAS?$AAT?$AA_?$AAN?$AAO?$AAR?$AAM?$AAA?$AAL?$AA?$CJ?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AA?$CI?$AAs?$AAt?$AAa?$AAt?$AAe?$AA?5@ 192b __security_check_cookie 1938 $NORMAL_STATE$183 193c $LN131 1940 $LN130 1944 $LN122 1948 $LN118 194c $LN117 1950 $LN113 1954 $LN97 1958 $LN66 195c $LN94 1960 $LN82 1964 $LN48 1968 $LN88 196c $LN65 1970 $LN92 1974 $LN53 1978 $LN71 197c $LN43 1980 $LN49 1984 $LN80 1988 $LN51 198c $LN46 1990 $LN95"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 81 EC 38 04 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 28 04 00 00 C7 84 24 8C 00 00 00 00 00 00 00 C7 44 24 44 00 00 00 00 C7 44 24 64 00 00 00 00 C7 44 24 48 00 00 00 00 C7 44 24 68 00 00 00 00 C7 84 24 80 00 00 00 00 00 00 00 C7 44 24 78 00 00 00 00 48 8B 94 24 50 04 00 00 48 8D 8C 24 90 01 00 00 E8 ?? ?? ?? ?? 48 C7 84 24 C0 00 00 00 00 00 00 00 E8 ?? ?? ?? ?? 48 89 84 24 50 01 00 00 E8 ?? ?? ?? ?? 85 C0 7D 24 C7 84 24 64 01 00 00 FF FF FF FF 48 8D 8C 24 90 01 00 00 E8 ?? ?? ?? ?? 8B 84 24 64 01 00 00 E9 59 18 00 00 48 83 BC 24 40 04 00 00 00 74 0D C7 84 24 EC 00 00 00 01 00 00 00 EB 0B C7 84 24 EC 00 00 00 00 00 00 00 8B 84 24 EC 00 00 00 89 84 24 0C 01 00 00 83 BC 24 0C 01 00 00 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 08 04 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 BC 24 0C 01 00 00 00 75 58 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 08 04 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 84 24 84 01 00 00 FF FF FF FF 48 8D 8C 24 90 01 00 00 E8 ?? ?? ?? ?? 8B 84 24 84 01 00 00 E9 82 17 00 00 48 8B 84 24 40 04 00 00 48 89 84 24 B0 01 00 00 48 8B 84 24 B0 01 00 00 8B 40 18 83 E0 40 85 C0 0F 85 E6 00 00 00 48 8B 8C 24 B0 01 00 00 E8 ?? ?? ?? ?? 89 44 24 6C 83 7C 24 6C FF 74 36 83 7C 24 6C FE 74 2F 8B 44 24 6C C1 F8 05 48 98 48 8D 0D ?? ?? ?? ?? 8B 54 24 6C 83 E2 1F 48 63 D2 48 6B D2 58 48 03 14 C1 48 8B C2 48 89 84 24 C8 01 00 00 EB 0F 48 8D 05 ?? ?? ?? ?? 48 89 84 24 C8 01 00 00 48 8B 84 24 C8 01 00 00 0F B6 40 38 D0 E0 D0 F8 0F BE C0 85 C0 75 65 83 7C 24 6C FF 74 36 83 7C 24 6C FE 74 2F 8B 44 24 6C C1 F8 05 48 98 48 8D 0D ?? ?? ?? ?? 8B 54 24 6C 83 E2 1F 48 63 D2 48 6B D2 58 48 03 14 C1 48 8B C2 48 89 84 24 B8 01 00 00 EB 0F 48 8D 05 ?? ?? ?? ?? 48 89 84 24 B8 01 00 00 48 8B 84 24 B8 01 00 00 0F B6 40 38 C0 E0 00 C0 F8 07 0F BE C0 85 C0 74 0D C7 84 24 14 01 00 00 00 00 00 00 EB 0B C7 84 24 14 01 00 00 01 00 00 00 8B 84 24 14 01 00 00 89 84 24 1C 01 00 00 83 BC 24 1C 01 00 00 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 0A 04 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 BC 24 1C 01 00 00 00 75 58 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 0A 04 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 84 24 74 01 00 00 FF FF FF FF 48 8D 8C 24 90 01 00 00 E8 ?? ?? ?? ?? 8B 84 24 74 01 00 00 E9 B7 15 00 00 48 83 BC 24 48 04 00 00 00 74 0D C7 84 24 24 01 00 00 01 00 00 00 EB 0B C7 84 24 24 01 00 00 00 00 00 00 8B 84 24 24 01 00 00 89 84 24 20 01 00 00 83 BC 24 20 01 00 00 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 0D 04 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 BC 24 20 01 00 00 00 75 58 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 0D 04 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 84 24 5C 01 00 00 FF FF FF FF 48 8D 8C 24 90 01 00 00 E8 ?? ?? ?? ?? 8B 84 24 5C 01 00 00 E9 E0 14 00 00 C7 44 24 5C 00 00 00 00 C7 44 24 58 00 00 00 00 C7 44 24 70 00 00 00 00 48 C7 84 24 C0 00 00 00 00 00 00 00 C7 84 24 A8 00 00 00 00 00 00 00 48 8B 84 24 48 04 00 00 0F B6 00 88 44 24 40 0F BE 44 24 40 89 84 24 60 01 00 00 48 8B 84 24 48 04 00 00 48 FF C0 48 89 84 24 48 04 00 00 83 BC 24 60 01 00 00 00 0F 84 7F 13 00 00 83 7C 24 5C 00 0F 8C 74 13 00 00 0F BE 44 24 40 83 F8 20 7C 2B 0F BE 44 24 40 83 F8 78 7F 21 0F BE 44 24 40 83 E8 20 48 98 48 8D 0D ?? ?? ?? ?? 0F B6 04 01 83 E0 0F 89 84 24 04 01 00 00 EB 0B C7 84 24 04 01 00 00 00 00 00 00 8B 84 24 04 01 00 00 89 84 24 68 01 00 00 8B 84 24 68 01 00 00 6B C0 09 03 44 24 70 48 98 48 8D 0D ?? ?? ?? ?? 0F B6 04 01 C1 F8 04 89 44 24 70 83 7C 24 70 08 0F 85 D2 00 00 00 33 C0 85 C0 74 0D C7 84 24 E4 00 00 00 01 00 00 00 EB 0B C7 84 24 E4 00 00 00 00 00 00 00 8B 84 24 E4 00 00 00 89 84 24 E8 00 00 00 83 BC 24 E8 00 00 00 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 66 04 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 BC 24 E8 00 00 00 00 75 58 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 66 04 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 84 24 70 01 00 00 FF FF FF FF 48 8D 8C 24 90 01 00 00 E8 ?? ?? ?? ?? 8B 84 24 70 01 00 00 E9 1D 13 00 00 8B 44 24 70 89 84 24 08 01 00 00 83 BC 24 08 01 00 00 07 0F 87 09 12 00 00 48 63 84 24 08 01 00 00 48 8D 0D ?? ?? ?? ?? 8B 84 81 ?? ?? ?? ?? 48 03 C1 FF E0 C7 44 24 78 00 00 00 00 48 8D 8C 24 90 01 00 00 E8 ?? ?? ?? ?? 0F B6 4C 24 40 48 8B D0 E8 ?? ?? ?? ?? 85 C0 0F 84 0E 01 00 00 4C 8D 44 24 5C 48 8B 94 24 40 04 00 00 0F B6 4C 24 40 E8 ?? ?? ?? ?? 48 8B 84 24 48 04 00 00 0F B6 00 88 44 24 40 48 8B 84 24 48 04 00 00 48 FF C0 48 89 84 24 48 04 00 00 0F BE 44 24 40 85 C0 74 0D C7 84 24 F0 00 00 00 01 00 00 00 EB 0B C7 84 24 F0 00 00 00 00 00 00 00 8B 84 24 F0 00 00 00 89 84 24 18 01 00 00 83 BC 24 18 01 00 00 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 8C 04 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 BC 24 18 01 00 00 00 75 58 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 8C 04 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 84 24 78 01 00 00 FF FF FF FF 48 8D 8C 24 90 01 00 00 E8 ?? ?? ?? ?? 8B 84 24 78 01 00 00 E9 B1 11 00 00 4C 8D 44 24 5C 48 8B 94 24 40 04 00 00 0F B6 4C 24 40 E8 ?? ?? ?? ?? E9 9A 10 00 00 C7 84 24 BC 00 00 00 00 00 00 00 8B 84 24 BC 00 00 00 89 84 24 80 00 00 00 8B 84 24 80 00 00 00 89 44 24 64 8B 44 24 64 89 44 24 68 C7 44 24 44 00 00 00 00 C7 44 24 48 FF FF FF FF C7 44 24 78 00 00 00 00 E9 51 10 00 00 0F B6 44 24 40 88 44 24 7C 80 7C 24 7C 20 74 38 80 7C 24 7C 23 74 3E 80 7C 24 7C 2B 74 1D 80 7C 24 7C 2D 74 09 80 7C 24 7C 30 74 37 EB 40 8B 44 24 44 83 C8 04 89 44 24 44 EB 33 8B 44 24 44 83 C8 01 89 44 24 44 EB 26 8B 44 24 44 83 C8 02 89 44 24 44 EB 19 8B 44 24 44 0F BA E8 07 89 44 24 44 EB 0B 8B 44 24 44 83 C8 08 89 44 24 44 E9 DE 0F 00 00 0F BE 44 24 40 83 F8 2A 75 2F 48 8D 8C 24 58 04 00 00 E8 ?? ?? ?? ?? 89 44 24 64 83 7C 24 64 00 7D 15 8B 44 24 44 83 C8 04 89 44 24 44 8B 44 24 64 F7 D8 89 44 24 64 EB 14 8B 44 24 64 6B C0 0A 0F BE 4C 24 40 8D 44 08 D0 89 44 24 64 E9 8C 0F 00 00 C7 44 24 48 00 00 00 00 E9 7F 0F 00 00 0F BE 44 24 40 83 F8 2A 75 22 48 8D 8C 24 58 04 00 00 E8 ?? ?? ?? ?? 89 44 24 48 83 7C 24 48 00 7D 08 C7 44 24 48 FF FF FF FF EB 14 8B 44 24 48 6B C0 0A 0F BE 4C 24 40 8D 44 08 D0 89 44 24 48 E9 3A 0F 00 00 0F B6 44 24 40 88 84 24 88 00 00 00 80 BC 24 88 00 00 00 49 74 6C 80 BC 24 88 00 00 00 68 0F 84 64 01 00 00 80 BC 24 88 00 00 00 6C 74 13 80 BC 24 88 00 00 00 77 0F 84 59 01 00 00 E9 60 01 00 00 48 8B 84 24 48 04 00 00 0F BE 00 83 F8 6C 75 21 48 8B 84 24 48 04 00 00 48 FF C0 48 89 84 24 48 04 00 00 8B 44 24 44 0F BA E8 0C 89 44 24 44 EB 0B 8B 44 24 44 83 C8 10 89 44 24 44 E9 1F 01 00 00 8B 44 24 44 0F BA E8 0F 89 44 24 44 48 8B 84 24 48 04 00 00 0F BE 00 83 F8 36 75 36 48 8B 84 24 48 04 00 00 0F BE 40 01 83 F8 34 75 25 48 8B 84 24 48 04 00 00 48 83 C0 02 48 89 84 24 48 04 00 00 8B 44 24 44 0F BA E8 0F 89 44 24 44 E9 B2 00 00 00 48 8B 84 24 48 04 00 00 0F BE 00 83 F8 33 75 33 48 8B 84 24 48 04 00 00 0F BE 40 01 83 F8 32 75 22 48 8B 84 24 48 04 00 00 48 83 C0 02 48 89 84 24 48 04 00 00 8B 44 24 44 0F BA F0 0F 89 44 24 44 EB 6F 48 8B 84 24 48 04 00 00 0F BE 00 83 F8 64 74 50 48 8B 84 24 48 04 00 00 0F BE 00 83 F8 69 74 40 48 8B 84 24 48 04 00 00 0F BE 00 83 F8 6F 74 30 48 8B 84 24 48 04 00 00 0F BE 00 83 F8 75 74 20 48 8B 84 24 48 04 00 00 0F BE 00 83 F8 78 74 10 48 8B 84 24 48 04 00 00 0F BE 00 83 F8 58 75 02 EB 0D C7 44 24 70 00 00 00 00 E9 C6 FB FF FF EB 19 8B 44 24 44 83 C8 20 89 44 24 44 EB 0C 8B 44 24 44 0F BA E8 0B 89 44 24 44 E9 94 0D 00 00 0F BE 44 24 40 89 84 24 94 00 00 00 8B 84 24 94 00 00 00 83 E8 41 89 84 24 94 00 00 00 83 BC 24 94 00 00 00 37 0F 87 C9 0A 00 00 48 63 84 24 94 00 00 00 48 8D 0D ?? ?? ?? ?? 0F B6 84 01 ?? ?? ?? ?? 8B 84 81 ?? ?? ?? ?? 48 03 C1 FF E0 8B 44 24 44 25 30 08 00 00 85 C0 75 0C 8B 44 24 44 0F BA E8 0B 89 44 24 44 8B 44 24 44 25 10 08 00 00 85 C0 74 5F C7 84 24 F8 00 00 00 00 00 00 00 48 8D 8C 24 58 04 00 00 E8 ?? ?? ?? ?? 66 89 84 24 C8 00 00 00 44 0F B7 8C 24 C8 00 00 00 41 B8 00 02 00 00 48 8D 94 24 20 02 00 00 48 8D 4C 24 58 E8 ?? ?? ?? ?? 89 84 24 F8 00 00 00 83 BC 24 F8 00 00 00 00 74 0B C7 84 24 80 00 00 00 01 00 00 00 EB 35 48 8D 8C 24 58 04 00 00 E8 ?? ?? ?? ?? 66 89 84 24 AC 00 00 00 B8 01 00 00 00 48 6B C0 00 0F B6 8C 24 AC 00 00 00 88 8C 04 20 02 00 00 C7 44 24 58 01 00 00 00 48 8D 84 24 20 02 00 00 48 89 44 24 50 E9 DA 09 00 00 48 8D 8C 24 58 04 00 00 E8 ?? ?? ?? ?? 48 89 84 24 D0 00 00 00 48 83 BC 24 D0 00 00 00 00 74 0F 48 8B 84 24 D0 00 00 00 48 83 78 08 00 75 1C 48 8B 05 ?? ?? ?? ?? 48 89 44 24 50 48 8B 4C 24 50 E8 ?? ?? ?? ?? 89 44 24 58 EB 64 8B 44 24 44 25 00 08 00 00 85 C0 74 2F 48 8B 84 24 D0 00 00 00 48 8B 40 08 48 89 44 24 50 48 8B 84 24 D0 00 00 00 0F BF 00 99 2B C2 D1 F8 89 44 24 58 C7 44 24 78 01 00 00 00 EB 28 C7 44 24 78 00 00 00 00 48 8B 84 24 D0 00 00 00 48 8B 40 08 48 89 44 24 50 48 8B 84 24 D0 00 00 00 0F BF 00 89 44 24 58 E9 26 09 00 00 8B 44 24 44 25 30 08 00 00 85 C0 75 0C 8B 44 24 44 0F BA E8 0B 89 44 24 44 83 7C 24 48 FF 75 0D C7 84 24 10 01 00 00 FF FF FF 7F EB 0B 8B 44 24 48 89 84 24 10 01 00 00 8B 84 24 10 01 00 00 89 44 24 74 48 8D 8C 24 58 04 00 00 E8 ?? ?? ?? ?? 48 89 44 24 50 8B 44 24 44 25 10 08 00 00 85 C0 0F 84 89 00 00 00 48 83 7C 24 50 00 75 0C 48 8B 05 ?? ?? ?? ?? 48 89 44 24 50 C7 44 24 78 01 00 00 00 48 8B 44 24 50 48 89 84 24 30 01 00 00 8B 44 24 74 89 84 24 48 01 00 00 8B 44 24 74 FF C8 89 44 24 74 83 BC 24 48 01 00 00 00 74 25 48 8B 84 24 30 01 00 00 0F B7 00 85 C0 74 16 48 8B 84 24 30 01 00 00 48 83 C0 02 48 89 84 24 30 01 00 00 EB BC 48 8B 44 24 50 48 8B 8C 24 30 01 00 00 48 2B C8 48 8B C1 48 D1 F8 89 44 24 58 EB 7B 48 83 7C 24 50 00 75 0C 48 8B 05 ?? ?? ?? ?? 48 89 44 24 50 48 8B 44 24 50 48 89 84 24 28 01 00 00 8B 44 24 74 89 84 24 80 01 00 00 8B 44 24 74 FF C8 89 44 24 74 83 BC 24 80 01 00 00 00 74 24 48 8B 84 24 28 01 00 00 0F BE 00 85 C0 74 15 48 8B 84 24 28 01 00 00 48 FF C0 48 89 84 24 28 01 00 00 EB BD 48 8B 44 24 50 48 8B 8C 24 28 01 00 00 48 2B C8 48 8B C1 89 44 24 58 E9 B7 07 00 00 48 8D 8C 24 58 04 00 00 E8 ?? ?? ?? ?? 48 89 84 24 C0 01 00 00 E8 ?? ?? ?? ?? 85 C0 0F 85 D7 00 00 00 33 C0 85 C0 74 0D C7 84 24 00 01 00 00 01 00 00 00 EB 0B C7 84 24 00 01 00 00 00 00 00 00 8B 84 24 00 01 00 00 89 84 24 E0 00 00 00 83 BC 24 E0 00 00 00 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 9B 06 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 BC 24 E0 00 00 00 00 75 58 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 9B 06 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 84 24 58 01 00 00 FF FF FF FF 48 8D 8C 24 90 01 00 00 E8 ?? ?? ?? ?? 8B 84 24 58 01 00 00 E9 5E 0A 00 00 E9 BE 06 00 00 8B 44 24 44 83 E0 20 85 C0 74 12 48 8B 84 24 C0 01 00 00 0F B7 4C 24 5C 66 89 08 EB 0E 48 8B 84 24 C0 01 00 00 8B 4C 24 5C 89 08 C7 84 24 80 00 00 00 01 00 00 00 E9 83 06 00 00 C7 84 24 BC 00 00 00 01 00 00 00 0F BE 44 24 40 83 C0 20 88 44 24 40 8B 44 24 44 83 C8 40 89 44 24 44 48 8D 84 24 20 02 00 00 48 89 44 24 50 C7 84 24 A8 00 00 00 00 02 00 00 83 7C 24 48 00 7D 0A C7 44 24 48 06 00 00 00 EB 2D 83 7C 24 48 00 75 14 0F BE 44 24 40 83 F8 67 75 0A C7 44 24 48 01 00 00 00 EB 12 81 7C 24 48 00 02 00 00 7E 08 C7 44 24 48 00 02 00 00 81 7C 24 48 A3 00 00 00 7E 5F 8B 44 24 48 05 5D 01 00 00 48 98 41 B9 E0 06 00 00 4C 8D 05 ?? ?? ?? ?? BA 02 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 48 89 84 24 C0 00 00 00 48 83 BC 24 C0 00 00 00 00 74 1F 48 8B 84 24 C0 00 00 00 48 89 44 24 50 8B 44 24 48 05 5D 01 00 00 89 84 24 A8 00 00 00 EB 08 C7 44 24 48 A3 00 00 00 33 C0 85 C0 74 2A 48 8B 84 24 58 04 00 00 48 83 C0 08 48 89 84 24 58 04 00 00 48 8B 84 24 }
	condition:
		$1
}

rule file_40_6_0 {
	meta:
		name = "get_short_arg"
		size = 101
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 18 33 C0 85 C0 74 29 48 8B 44 24 20 48 8B 00 48 83 C0 08 48 8B 4C 24 20 48 89 01 48 8B 44 24 20 48 8B 00 48 8B 40 F8 0F B7 00 66 89 04 24 EB 24 48 8B 44 24 20 48 8B 00 48 83 C0 08 48 8B 4C 24 20 48 89 01 48 8B 44 24 20 48 8B 00 0F B7 40 F8 66 89 04 24 0F B7 04 24 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_40_7_0 {
	meta:
		name = "write_char"
		size = 211
		refs = "00a2 _flsbuf"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 88 4C 24 08 48 83 EC 38 48 8B 44 24 48 8B 40 18 83 E0 40 85 C0 74 21 48 8B 44 24 48 48 83 78 10 00 75 15 48 8B 44 24 50 8B 00 FF C0 48 8B 4C 24 50 89 01 E9 8C 00 00 00 48 8B 44 24 48 8B 40 08 FF C8 89 44 24 20 48 8B 44 24 48 8B 4C 24 20 89 48 08 83 7C 24 20 00 7C 32 48 8B 44 24 48 48 8B 00 0F B6 4C 24 40 88 08 0F BE 44 24 40 25 FF 00 00 00 89 44 24 24 48 8B 44 24 48 48 8B 00 48 FF C0 48 8B 4C 24 48 48 89 01 EB 15 0F BE 44 24 40 48 8B 54 24 48 8B C8 E8 ?? ?? ?? ?? 89 44 24 24 83 7C 24 24 FF 75 0D 48 8B 44 24 50 C7 00 FF FF FF FF EB 10 48 8B 44 24 50 8B 00 FF C0 48 8B 4C 24 50 89 01 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_40_8_0 {
	meta:
		name = "write_multi_char"
		size = 86
		refs = "003f write_char"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 89 54 24 10 88 4C 24 08 48 83 EC 38 8B 44 24 48 89 44 24 20 8B 44 24 48 FF C8 89 44 24 48 83 7C 24 20 00 7E 22 4C 8B 44 24 58 48 8B 54 24 50 0F B6 4C 24 40 E8 ?? ?? ?? ?? 48 8B 44 24 58 83 38 FF 75 02 EB 02 EB C5 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_40_9_0 {
	meta:
		name = "write_string"
		size = 234
		refs = "0094 write_char"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 60 8B 00 89 44 24 28 48 8B 44 24 50 8B 40 18 83 E0 40 85 C0 74 23 48 8B 44 24 50 48 83 78 10 00 75 17 48 8B 44 24 58 8B 00 03 44 24 48 48 8B 4C 24 58 89 01 E9 91 00 00 00 48 8B 44 24 60 C7 00 00 00 00 00 8B 44 24 48 89 44 24 24 8B 44 24 48 FF C8 89 44 24 48 83 7C 24 24 00 7E 58 48 8B 44 24 40 0F B6 00 88 44 24 20 4C 8B 44 24 58 48 8B 54 24 50 0F B6 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 40 48 FF C0 48 89 44 24 40 48 8B 44 24 58 83 38 FF 75 1F 48 8B 44 24 60 83 38 2A 75 13 4C 8B 44 24 58 48 8B 54 24 50 B1 3F E8 ?? ?? ?? ?? EB 02 EB 02 EB 8F 48 8B 44 24 60 83 38 00 75 0B 48 8B 44 24 60 8B 4C 24 28 89 08 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_41_0_0 {
	meta:
		name = "__sse4_exp2"
		size = 752
		refs = "0012 s_dwInvLn 001a s_dwNegRS 002b s_dwLnHi 0033 s_dwBias 0062 s_dwLnLo 0076 s_dwExp2 0094 s_dwA4 00b3 s_dwA5 00d6 s_dwA3 00de s_dwA2 00f6 s_dwOne 01c2 iAbsMask 01ce dbB1 01e7 dbB2 026a dbInf"
	strings:
		$1 = { 48 83 EC 68 0F 29 7C 24 40 0F 29 74 24 50 66 0F 28 1D ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 59 D8 66 0F C5 C8 03 66 0F 28 25 ?? ?? ?? ?? 66 0F 28 0D ?? ?? ?? ?? 66 0F 58 D3 66 0F 3A 09 DB 00 66 0F 28 E8 66 0F 7E D0 81 E1 FF 7F 00 00 66 0F 59 E3 66 0F C5 D2 04 81 F9 86 40 00 00 66 0F 59 1D ?? ?? ?? ?? 66 0F FE CA 66 0F C5 C8 07 66 0F 5C C4 4C 8D 05 ?? ?? ?? ?? 0F 8D A0 00 00 00 81 E1 FF 7F 00 00 83 E0 3F 83 E2 3F 66 0F 5C C3 66 0F 28 1D ?? ?? ?? ?? 66 0F 73 D1 06 F3 41 0F 7E 24 C0 81 F9 86 40 00 00 0F 8D 91 00 00 00 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 E8 66 0F 59 C0 66 0F 73 F1 34 66 41 0F 16 24 D0 66 0F 59 D0 66 0F 59 D8 66 0F 58 15 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 D0 66 0F 59 C3 66 0F 59 D5 66 0F 58 C5 66 0F 58 15 ?? ?? ?? ?? 66 0F EB CC 66 0F 58 C2 66 0F 59 C1 0F 28 74 24 50 0F 28 7C 24 40 48 83 C4 68 C3 66 66 66 0F 1F 84 00 00 00 00 00 83 E0 3F 83 E2 3F 66 0F 5C C3 66 0F 28 1D ?? ?? ?? ?? 66 0F 73 D1 06 F3 41 0F 7E 24 C0 0F 1F 00 89 44 24 20 89 54 24 24 8B 44 24 20 8B 54 24 24 89 44 24 28 89 54 24 30 8B 44 24 28 8B 54 24 30 4C 8D 05 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 F8 66 0F 59 C0 66 0F 73 F1 34 66 41 0F 16 24 D0 66 0F 59 F0 66 0F 59 D8 66 0F 58 35 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 F0 66 0F 59 C3 66 0F 59 F7 66 0F 58 C7 66 0F 58 35 ?? ?? ?? ?? 66 0F EB CC 66 0F 58 C6 66 0F 59 C8 66 0F 28 1D ?? ?? ?? ?? 66 0F DB DD 66 0F C2 1D ?? ?? ?? ?? 01 66 0F DB CB 66 0F 28 35 ?? ?? ?? ?? 66 0F DB F5 66 0F C2 35 ?? ?? ?? ?? 01 66 0F DF DE 66 0F DB C3 66 0F DB D3 66 0F DB E3 66 0F C5 C5 03 66 0F C5 D5 07 C1 E8 0F C1 EA 0F 66 0F FE 15 ?? ?? ?? ?? 66 0F 73 D2 06 F3 41 0F 7E BC C0 00 02 00 00 66 41 0F 16 BC D0 00 02 00 00 66 0F FE D7 66 0F 73 F2 34 66 0F EB D4 66 0F 59 C2 F3 41 0F 7E BC C0 10 02 00 00 66 41 0F 16 BC D0 10 02 00 00 66 0F 59 C7 66 0F EB C1 66 0F 28 3D ?? ?? ?? ?? 66 0F DB FD 66 0F C2 3D ?? ?? ?? ?? 01 66 0F DF F7 F3 41 0F 7E 8C C0 20 02 00 00 66 41 0F 16 8C D0 20 02 00 00 66 0F DB CE 66 0F 28 35 ?? ?? ?? ?? 66 0F DB F5 66 0F C2 35 ?? ?? ?? ?? 00 F3 41 0F 7E BC C0 30 02 00 00 66 41 0F 16 BC D0 30 02 00 00 66 0F DB F7 66 0F EB CE 66 0F 28 35 ?? ?? ?? ?? 66 0F C2 F5 03 66 0F DB EE 66 0F EB CD 66 0F 59 C9 66 0F EB C1 0F 28 74 24 50 0F 28 7C 24 40 48 83 C4 68 C3 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_43_0_0 {
	meta:
		name = "log10"
		size = 798
		refs = "0026 __mask_1023 003a __real_inf 0050 __real_mant 0058 __real_one 0060 __mask_1023_f 0070 __mask_mant_all8 0077 __mask_mant9 008a __real_notsign 0092 __real_threshold 00aa __real_half 00b9 __log_F_inv_qword 00e0 __log_256_lead_special 00e8 __real_1_over_6 00f0 __real_1_over_3 0108 __real_1_over_5 0110 __real_1_over_2 0124 __real_1_over_4 0138 __real_log10_e 0140 __real_log10_2_tail 0155 __log_256_tail_special 0166 __real_log10_2_lead 0194 __real_two 01b0 __real_ca2 01b8 __real_ca4 01dc __real_ca1 01e4 __real_ca3 020c __mask_lower 0224 __real_log10_e_tail 0234 __real_log10_e_lead 0284 __mask_2045 02a6 __real_ninf 02ad __flag_x_zero 02b2 _log10_special 02c4 __real_neg_qnan 02cb __flag_x_neg 02f5 __real_qnanbit 0301 __flag_x_nan"
	strings:
		$1 = { 48 81 EC 98 00 00 00 66 0F 7F 74 24 40 48 33 C0 66 0F 6F D8 F2 0F 10 E0 66 0F 73 D3 34 66 48 0F 7E C0 66 0F FB 1D ?? ?? ?? ?? 66 0F 6F D0 F3 0F E6 F3 66 0F 6F E8 66 0F 54 2D ?? ?? ?? ?? 66 0F 2F 2D ?? ?? ?? ?? 0F 84 94 02 00 00 66 0F DB 15 ?? ?? ?? ?? F2 0F 5C 25 ?? ?? ?? ?? 66 0F 2F 35 ?? ?? ?? ?? 0F 84 F0 01 00 00 4C 8B C8 48 23 05 ?? ?? ?? ?? 4C 23 0D ?? ?? ?? ?? 49 D1 E1 49 03 C1 48 89 44 24 30 66 0F 54 25 ?? ?? ?? ?? 66 0F 2F 25 ?? ?? ?? ?? 0F 82 F4 00 00 00 F2 0F 10 4C 24 30 48 C1 E8 2C 66 0F EB 15 ?? ?? ?? ?? 66 0F EB 0D ?? ?? ?? ?? 4C 8D 0D ?? ?? ?? ?? 66 0F 57 ED 66 0F 2F C5 0F 86 D5 01 00 00 F2 0F 5C CA F2 41 0F 59 0C C1 F2 0F 10 D1 F2 0F 10 C1 4C 8D 0D ?? ?? ?? ?? F2 0F 10 1D ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 DA F2 0F 59 CA F2 0F 59 C2 F2 0F 10 E0 F2 0F 58 1D ?? ?? ?? ?? F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 E0 F2 0F 59 DA F2 0F 59 C8 F2 0F 58 1D ?? ?? ?? ?? F2 0F 58 CA F2 0F 59 DC F2 0F 58 CB F2 0F 59 0D ?? ?? ?? ?? F2 0F 10 2D ?? ?? ?? ?? F2 0F 59 EE F2 0F 5C E9 F2 41 0F 10 04 C1 48 8D 15 ?? ?? ?? ?? F2 0F 10 14 C2 F2 0F 58 D5 F2 0F 10 25 ?? ?? ?? ?? F2 0F 59 E6 F2 0F 58 C4 F2 0F 58 C2 66 0F 6F 74 24 40 48 81 C4 98 00 00 00 C3 66 66 66 66 0F 1F 84 00 00 00 00 00 F2 0F 10 15 ?? ?? ?? ?? F2 0F 5C 05 ?? ?? ?? ?? F2 0F 58 D0 F2 0F 10 C8 F2 0F 5E CA F2 0F 10 25 ?? ?? ?? ?? F2 0F 10 2D ?? ?? ?? ?? F2 0F 10 F0 F2 0F 59 F1 F2 0F 58 C9 F2 0F 10 D1 F2 0F 59 D1 F2 0F 59 E2 F2 0F 59 EA F2 0F 58 25 ?? ?? ?? ?? F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 D1 F2 0F 59 E2 F2 0F 59 D2 F2 0F 59 D1 F2 0F 59 EA F2 0F 58 E5 F2 0F 5C E6 66 0F 6F D8 66 0F DB 1D ?? ?? ?? ?? F2 0F 5C C3 F2 0F 58 E0 F2 0F 10 C3 F2 0F 10 CC F2 0F 59 25 ?? ?? ?? ?? F2 0F 59 05 ?? ?? ?? ?? F2 0F 59 0D ?? ?? ?? ?? F2 0F 59 1D ?? ?? ?? ?? F2 0F 58 C4 F2 0F 58 C1 F2 0F 58 C3 66 0F 6F 74 24 40 48 81 C4 98 00 00 00 C3 66 0F EB 15 ?? ?? ?? ?? F2 0F 5C 15 ?? ?? ?? ?? F2 0F 10 EA 66 0F DB 15 ?? ?? ?? ?? 66 48 0F 7E D0 66 0F 73 D5 34 66 0F FA 2D ?? ?? ?? ?? F3 0F E6 F5 E9 D9 FD FF FF 66 66 66 66 66 66 66 0F 1F 84 00 00 00 00 00 75 1E F2 0F 10 0D ?? ?? ?? ?? 44 8B 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 58 0F 1F 84 00 00 00 00 00 F2 0F 10 0D ?? ?? ?? ?? 44 8B 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 3A 66 66 0F 1F 84 00 00 00 00 00 48 3B 05 ?? ?? ?? ?? 74 27 48 3B 05 ?? ?? ?? ?? 74 CE 48 0B 05 ?? ?? ?? ?? 66 48 0F 6E C8 44 8B 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 04 0F 1F 40 00 66 0F 6F 74 24 40 48 81 C4 98 00 00 00 C3 }
	condition:
		$1
}

rule file_44_0_0 {
	meta:
		name = "strtok_s"
		size = 1016
		refs = "0019 __security_cookie 0064 ??_C@_1CG@NGEOKDE@?$AA?$CI?$AA_?$AAC?$AAo?$AAn?$AAt?$AAe?$AAx?$AAt?$AA?$CJ?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0070 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0085 ??_C@_1HC@ENCCCHCO@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 008f _CrtDbgReportW 00a3 _errno 00c6 ??_C@_1BC@LFCPBNCF@?$AAs?$AAt?$AAr?$AAt?$AAo?$AAk?$AA_?$AAs?$AA?$AA@ 00d2 _invalid_parameter 010c ??_C@_1CG@CBDCOOGB@?$AA?$CI?$AA_?$AAC?$AAo?$AAn?$AAt?$AAr?$AAo?$AAl?$AA?$CJ?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 01c2 ??_C@_1GK@OCGBCEPL@?$AA?$CI?$AA_?$AAS?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA?$CI?$AA?$CI?$AAv?$AAo?$AAi?$AAd?$AA?5?$AA?$CK?$AA?$CJ?$AA0?$AA?$CJ?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AA?$CK?$AA_?$AAC?$AAo?$AAn@ 026b __report_rangecheckfailure 03ec __security_check_cookie"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 81 EC A8 00 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 90 00 00 00 48 8B 84 24 B8 00 00 00 48 89 44 24 40 48 83 BC 24 C0 00 00 00 00 74 0A C7 44 24 58 01 00 00 00 EB 08 C7 44 24 58 00 00 00 00 8B 44 24 58 89 44 24 5C 83 7C 24 5C 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 14 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 5C 00 75 3B E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 14 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 E9 03 03 00 00 48 83 BC 24 B8 00 00 00 00 74 0A C7 44 24 50 01 00 00 00 EB 08 C7 44 24 50 00 00 00 00 8B 44 24 50 89 44 24 54 83 7C 24 54 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 15 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 54 00 75 3B E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 15 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 E9 5B 02 00 00 48 83 BC 24 B0 00 00 00 00 75 18 48 8B 84 24 C0 00 00 00 48 83 38 00 75 0A C7 44 24 48 00 00 00 00 EB 08 C7 44 24 48 01 00 00 00 8B 44 24 48 89 44 24 4C 83 7C 24 4C 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 16 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 4C 00 75 3B E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 16 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 E9 A5 01 00 00 C7 44 24 38 00 00 00 00 EB 0A 8B 44 24 38 FF C0 89 44 24 38 83 7C 24 38 20 7D 25 48 63 44 24 38 48 89 44 24 68 48 83 7C 24 68 20 73 02 EB 05 E8 ?? ?? ?? ?? 48 8B 44 24 68 C6 44 04 70 00 EB CA 48 8B 44 24 40 0F B6 00 C1 F8 03 48 98 48 8B 4C 24 40 0F B6 09 83 E1 07 BA 01 00 00 00 D3 E2 8B CA 0F B6 44 04 70 0B C1 48 8B 4C 24 40 0F B6 09 C1 F9 03 48 63 C9 88 44 0C 70 48 8B 44 24 40 0F B6 00 89 44 24 60 48 8B 44 24 40 48 FF C0 48 89 44 24 40 83 7C 24 60 00 75 A6 48 83 BC 24 B0 00 00 00 00 74 0F 48 8B 84 24 B0 00 00 00 48 89 44 24 30 EB 10 48 8B 84 24 C0 00 00 00 48 8B 00 48 89 44 24 30 48 8B 44 24 30 0F B6 00 C1 F8 03 48 98 0F B6 44 04 70 48 8B 4C 24 30 0F B6 09 83 E1 07 BA 01 00 00 00 D3 E2 8B CA 23 C1 85 C0 74 1B 48 8B 44 24 30 0F B6 00 85 C0 74 0F 48 8B 44 24 30 48 FF C0 48 89 44 24 30 EB B9 48 8B 44 24 30 48 89 84 24 B0 00 00 00 EB 0D 48 8B 44 24 30 48 FF C0 48 89 44 24 30 48 8B 44 24 30 0F B6 00 85 C0 74 45 48 8B 44 24 30 0F B6 00 C1 F8 03 48 98 0F B6 44 04 70 48 8B 4C 24 30 0F B6 09 83 E1 07 BA 01 00 00 00 D3 E2 8B CA 23 C1 85 C0 74 17 48 8B 44 24 30 C6 00 00 48 8B 44 24 30 48 FF C0 48 89 44 24 30 EB 02 EB A2 48 8B 84 24 C0 00 00 00 48 8B 4C 24 30 48 89 08 48 8B 44 24 30 48 39 84 24 B0 00 00 00 75 06 33 C0 EB 0A EB 08 48 8B 84 24 B0 00 00 00 48 8B 8C 24 90 00 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 A8 00 00 00 C3 }
	condition:
		$1
}

rule file_46_0_0 {
	meta:
		name = "_strtime"
		size = 49
		refs = "0014 _strtime_s"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 BA 09 00 00 00 48 8B 4C 24 40 E8 ?? ?? ?? ?? 89 44 24 20 83 7C 24 20 00 74 04 33 C0 EB 05 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_121_0_0 {
	meta:
		name = "_strdate"
		size = 49
		refs = "0014 _strdate_s"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 BA 09 00 00 00 48 8B 4C 24 40 E8 ?? ?? ?? ?? 89 44 24 20 83 7C 24 20 00 74 04 33 C0 EB 05 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_881_0_0 {
	meta:
		name = "_wstrdate"
		size = 49
		refs = "0014 _wstrdate_s"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 BA 09 00 00 00 48 8B 4C 24 40 E8 ?? ?? ?? ?? 89 44 24 20 83 7C 24 20 00 74 04 33 C0 EB 05 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1127_0_0 {
	meta:
		name = "_wstrtime"
		size = 49
		refs = "0014 _wstrtime_s"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 BA 09 00 00 00 48 8B 4C 24 40 E8 ?? ?? ?? ?? 89 44 24 20 83 7C 24 20 00 74 04 33 C0 EB 05 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_46_1_0 {
	meta:
		name = "_strtime_s"
		size = 845
		refs = "0011 __security_cookie 0057 ??_C@_1EM@GNJBJFJJ@?$AA?$CI?$AA?5?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAC?$AAh?$AAa?$AAr?$AAs?$AA?5@ 0063 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0078 ??_C@_1GM@JOGOPHHP@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 0082 _CrtDbgReportW 0096 _errno 00b9 ??_C@_1BG@GMOAACJH@?$AA_?$AAs?$AAt?$AAr?$AAt?$AAi?$AAm?$AAe?$AA_?$AAs?$AA?$AA@ 00c5 _invalid_parameter 0110 __crtDebugFillThreshold 014d memset 0180 ??_C@_1CK@EJMACHNH@?$AA?$CI?$AA?5?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAC?$AAh?$AAa?$AAr?$AAs?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA9?$AA?5?$AA?$CJ?$AA?$AA@ 0203 __imp_GetLocalTime 0344 __security_check_cookie"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 78 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 68 48 83 BC 24 80 00 00 00 00 74 15 48 83 BC 24 88 00 00 00 00 76 0A C7 44 24 34 01 00 00 00 EB 08 C7 44 24 34 00 00 00 00 8B 44 24 34 89 44 24 44 83 7C 24 44 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 33 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 44 00 75 3E E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 33 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 16 00 00 00 E9 68 02 00 00 48 8B 84 24 80 00 00 00 C6 00 00 48 83 BC 24 88 00 00 00 FF 74 68 48 81 BC 24 88 00 00 00 FF FF FF 7F 74 5A 48 83 BC 24 88 00 00 00 01 76 4F 48 8B 84 24 88 00 00 00 48 FF C8 48 39 05 ?? ?? ?? ?? 73 0E 48 8B 05 ?? ?? ?? ?? 48 89 44 24 50 EB 10 48 8B 84 24 88 00 00 00 48 FF C8 48 89 44 24 50 48 8B 84 24 80 00 00 00 48 FF C0 4C 8B 44 24 50 BA FE 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 48 83 BC 24 88 00 00 00 09 72 0A C7 44 24 3C 01 00 00 00 EB 08 C7 44 24 3C 00 00 00 00 8B 44 24 3C 89 44 24 48 83 7C 24 48 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 35 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 48 00 75 3E E8 ?? ?? ?? ?? C7 00 22 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 35 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 22 00 00 00 E9 3F 01 00 00 48 8D 4C 24 58 FF 15 ?? ?? ?? ?? 0F B7 44 24 60 89 44 24 30 0F B7 44 24 62 89 44 24 38 0F B7 44 24 64 89 44 24 40 B8 01 00 00 00 48 6B C0 05 48 8B 8C 24 80 00 00 00 C6 04 01 3A B8 01 00 00 00 48 6B C0 02 48 8B 8C 24 80 00 00 00 C6 04 01 3A B8 01 00 00 00 48 6B C0 08 48 8B 8C 24 80 00 00 00 C6 04 01 00 8B 44 24 30 99 B9 0A 00 00 00 F7 F9 83 C0 30 B9 01 00 00 00 48 6B C9 00 48 8B 94 24 80 00 00 00 88 04 0A 8B 44 24 30 99 B9 0A 00 00 00 F7 F9 8B C2 83 C0 30 B9 01 00 00 00 48 6B C9 01 48 8B 94 24 80 00 00 00 88 04 0A 8B 44 24 38 99 B9 0A 00 00 00 F7 F9 83 C0 30 B9 01 00 00 00 48 6B C9 03 48 8B 94 24 80 00 00 00 88 04 0A 8B 44 24 38 99 B9 0A 00 00 00 F7 F9 8B C2 83 C0 30 B9 01 00 00 00 48 6B C9 04 48 8B 94 24 80 00 00 00 88 04 0A 8B 44 24 40 99 B9 0A 00 00 00 F7 F9 83 C0 30 B9 01 00 00 00 48 6B C9 06 48 8B 94 24 80 00 00 00 88 04 0A 8B 44 24 40 99 B9 0A 00 00 00 F7 F9 8B C2 83 C0 30 B9 01 00 00 00 48 6B C9 07 48 8B 94 24 80 00 00 00 88 04 0A 33 C0 48 8B 4C 24 68 48 33 CC E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_47_0_0 {
	meta:
		name = "?GetPdbDll@@YAPEAUHINSTANCE__@@XZ"
		size = 332
		refs = "000a __security_cookie 001b ?alreadyTried@?1??GetPdbDll@@YAPEAUHINSTANCE__@@XZ@4_NA 002e ?GetPdbDllFromInstallPath@@YAPEAUHINSTANCE__@@XZ 003e msvcrdFilename 0044 __imp_GetModuleHandleW 0060 __imp_GetModuleFileNameW 007c ?GetPdbDllPathFromFilePath@@YAHPEB_WPEA_W_K@Z 0093 __imp_LoadLibraryExW 00a2 __imp_GetLastError 00c4 ??_C@_1BC@MIBIBMGK@?$AAM?$AAS?$AAP?$AAD?$AAB?$AA1?$AA1?$AA0?$AA?$AA@ 0140 __security_check_cookie"
	strings:
		$1 = { 48 81 EC 58 04 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 40 04 00 00 80 3D ?? ?? ?? ?? 00 0F 85 0C 01 00 00 C6 05 ?? ?? ?? ?? 01 E8 ?? ?? ?? ?? 48 85 C0 0F 85 F9 00 00 00 48 8D 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 85 C0 74 74 48 8D 94 24 30 02 00 00 41 B8 04 01 00 00 48 8B C8 FF 15 ?? ?? ?? ?? 85 C0 74 59 48 8D 54 24 20 48 8D 8C 24 30 02 00 00 41 B8 04 01 00 00 E8 ?? ?? ?? ?? 85 C0 74 3D 48 8D 4C 24 20 33 D2 41 B8 00 09 00 00 FF 15 ?? ?? ?? ?? 48 85 C0 0F 85 94 00 00 00 FF 15 ?? ?? ?? ?? 83 F8 57 75 16 44 8D 40 B1 48 8D 4C 24 20 33 D2 FF 15 ?? ?? ?? ?? 48 85 C0 75 73 48 8D 0D ?? ?? ?? ?? 33 D2 41 B8 00 0A 00 00 FF 15 ?? ?? ?? ?? 48 85 C0 75 59 FF 15 ?? ?? ?? ?? 83 F8 57 75 4C 48 8D 94 24 30 02 00 00 41 B8 04 01 00 00 33 C9 FF 15 ?? ?? ?? ?? 85 C0 74 32 48 8D 54 24 20 48 8D 8C 24 30 02 00 00 41 B8 04 01 00 00 E8 ?? ?? ?? ?? 85 C0 74 16 33 D2 48 8D 4C 24 20 44 8D 42 08 FF 15 ?? ?? ?? ?? 48 85 C0 75 02 33 C0 48 8B 8C 24 40 04 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 58 04 00 00 C3 }
	condition:
		$1
}

rule file_47_1_0 {
	meta:
		name = "?GetPdbDllFromInstallPath@@YAPEAUHINSTANCE__@@XZ"
		size = 615
		refs = "000c __security_cookie 001e ??_C@_1BK@GAEMIDIL@?$AAA?$AAD?$AAV?$AAA?$AAP?$AAI?$AA3?$AA2?$AA?4?$AAD?$AAL?$AAL?$AA?$AA@ 002c __imp_LoadLibraryExW 003a __imp_GetLastError 004c __imp_LoadLibraryW 0062 ??_C@_0O@COHOBMLB@RegOpenKeyExW?$AA@ 0073 __imp_GetProcAddress 0086 ??_C@_0BB@GLNAEDBD@RegQueryValueExW?$AA@ 00aa ??_C@_0M@HLOHPNFA@RegCloseKey?$AA@ 00cf ??_C@_1HE@IMMJFLBI@?$AAS?$AAO?$AAF?$AAT?$AAW?$AAA?$AAR?$AAE?$AA?2?$AAW?$AAo?$AAw?$AA6?$AA4?$AA3?$AA2?$AAN?$AAo?$AAd?$AAe?$AA?2?$AAM?$AAi?$AAc?$AAr?$AAo?$AAs?$AAo?$AAf?$AAt?$AA?2?$AAV@ 00f3 __imp_FreeLibrary 011a ??_C@_1BG@EABPBLLF@?$AAP?$AAr?$AAo?$AAd?$AAu?$AAc?$AAt?$AAD?$AAi?$AAr?$AA?$AA@ 01aa mspdbName 025a __security_check_cookie"
	strings:
		$1 = { 40 57 48 81 EC 60 02 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 50 02 00 00 48 8D 0D ?? ?? ?? ?? 33 D2 41 B8 00 08 00 00 FF 15 ?? ?? ?? ?? 48 8B F8 48 85 C0 75 27 FF 15 ?? ?? ?? ?? 83 F8 57 75 15 48 8D 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8B F8 48 85 C0 75 07 33 C0 E9 EF 01 00 00 48 8D 15 ?? ?? ?? ?? 48 8B CF 48 89 9C 24 70 02 00 00 FF 15 ?? ?? ?? ?? 48 8B D8 48 85 C0 0F 84 C3 01 00 00 48 8D 15 ?? ?? ?? ?? 48 8B CF 48 89 B4 24 80 02 00 00 FF 15 ?? ?? ?? ?? 48 8B F0 48 85 C0 0F 84 97 01 00 00 48 8D 15 ?? ?? ?? ?? 48 8B CF 48 89 AC 24 78 02 00 00 FF 15 ?? ?? ?? ?? 48 8B E8 48 85 C0 74 30 48 8D 44 24 38 48 8D 15 ?? ?? ?? ?? 41 B9 01 00 00 00 45 33 C0 48 C7 C1 02 00 00 80 48 89 44 24 20 FF D3 85 C0 74 10 48 8B CF FF 15 ?? ?? ?? ?? 33 C0 E9 38 01 00 00 48 8B 4C 24 38 48 8D 44 24 30 4C 8D 4C 24 34 48 89 44 24 28 48 8D 44 24 40 48 8D 15 ?? ?? ?? ?? 45 33 C0 C7 44 24 30 08 02 00 00 48 89 44 24 20 FF D6 48 8B 4C 24 38 8B D8 FF D5 48 8B CF FF 15 ?? ?? ?? ?? 85 DB 75 B1 83 7C 24 34 01 75 AA 8B 54 24 30 F6 C2 01 75 A1 D1 EA 83 FA 02 72 9A 41 83 C8 FF 4C 8D 4C 24 40 41 03 D0 66 41 39 1C 51 4D 8D 0C 51 75 83 8D 42 FF 66 83 7C 44 40 5C 74 0B B8 5C 00 00 00 FF C2 66 41 89 01 44 2B C2 41 83 F8 18 0F 82 60 FF FF FF 48 8D 42 17 48 3D 04 01 00 00 0F 87 50 FF FF FF 48 8B 05 ?? ?? ?? ?? 48 8D 4C 24 40 41 B8 00 09 00 00 48 89 44 54 40 48 8B 05 ?? ?? ?? ?? 48 89 44 54 48 48 8B 05 ?? ?? ?? ?? 48 89 44 54 50 48 8B 05 ?? ?? ?? ?? 48 89 44 54 58 48 8B 05 ?? ?? ?? ?? 48 89 44 54 60 8B 05 ?? ?? ?? ?? 89 44 54 68 0F B7 05 ?? ?? ?? ?? 66 89 44 54 6C 33 D2 FF 15 ?? ?? ?? ?? 48 8B D8 48 85 C0 75 1F FF 15 ?? ?? ?? ?? 83 F8 57 75 14 44 8D 43 08 48 8D 4C 24 40 33 D2 FF 15 ?? ?? ?? ?? 48 8B D8 48 8B C3 48 8B AC 24 78 02 00 00 48 8B B4 24 80 02 00 00 48 8B 9C 24 70 02 00 00 48 8B 8C 24 50 02 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 60 02 00 00 5F C3 }
	condition:
		$1
}

rule file_47_2_0 {
	meta:
		name = "?GetPdbDllPathFromFilePath@@YAHPEB_WPEA_W_K@Z"
		size = 261
		refs = "0010 __security_cookie 006b _wsplitpath_s 007a ?mspdbFilename@?1??GetPdbDllPathFromFilePath@@YAHPEB_WPEA_W_K@Z@4QB_WB 008c wcscpy_s 0097 ?dllExt@?1??GetPdbDllPathFromFilePath@@YAHPEB_WPEA_W_K@Z@4QB_WB 00d7 _wmakepath_s 00f0 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 20 57 48 81 EC 70 06 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 60 06 00 00 48 C7 44 24 40 00 01 00 00 48 8D 44 24 60 48 8B DA 48 89 44 24 38 48 8D 84 24 60 02 00 00 49 8B F8 48 C7 44 24 30 00 01 00 00 48 89 44 24 28 4C 8D 8C 24 60 04 00 00 48 8D 54 24 50 41 B8 03 00 00 00 48 C7 44 24 20 00 01 00 00 E8 ?? ?? ?? ?? 85 C0 74 04 33 C0 EB 6D 4C 8D 05 ?? ?? ?? ?? 48 8D 8C 24 60 02 00 00 BA 09 00 00 00 E8 ?? ?? ?? ?? 85 C0 75 DF 4C 8D 05 ?? ?? ?? ?? 8D 50 04 48 8D 4C 24 60 E8 ?? ?? ?? ?? 85 C0 75 C7 48 8D 44 24 60 4C 8D 8C 24 60 04 00 00 4C 8D 44 24 50 48 89 44 24 28 48 8D 84 24 60 02 00 00 48 8B D7 48 8B CB 48 89 44 24 20 E8 ?? ?? ?? ?? 33 C9 85 C0 0F 94 C1 8B C1 48 8B 8C 24 60 06 00 00 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 98 06 00 00 48 81 C4 70 06 00 00 5F C3 }
	condition:
		$1
}

rule file_47_3_0 {
	meta:
		name = "?_RTC_GetSrcLine@@YAHPEAEPEA_WKPEAH1K@Z"
		size = 906
		refs = "003a __imp_VirtualQuery 0063 __imp_GetModuleFileNameW 00e9 ?PDBOK@?BM@??_RTC_GetSrcLine@@YAHPEAEPEA_WKPEAH1K@Z@4_NA 00f2 mspdb 00f9 ?GetPdbDll@@YAPEAUHINSTANCE__@@XZ 011c ??_C@_0BB@KCIACLNC@PDBOpenValidate5?$AA@ 0125 __imp_GetProcAddress 0182 ??_C@_01KDCPPGHE@r?$AA@ 0280 __imp_GetProcessHeap 028e __imp_HeapAlloc 0339 __imp_HeapFree"
	strings:
		$1 = { 44 89 44 24 18 55 56 41 54 41 55 41 56 48 8D 6C 24 D9 48 81 EC C0 00 00 00 45 33 F6 48 8D 71 FF 4C 8B EA 45 89 31 66 44 89 32 48 8D 55 DF 45 8D 46 30 48 8B CE 4D 8B E1 FF 15 ?? ?? ?? ?? 48 85 C0 75 12 33 C0 48 81 C4 C0 00 00 00 41 5E 41 5D 41 5C 5E 5D C3 44 8B 45 7F 48 8B 55 77 48 8B 4D E7 FF 15 ?? ?? ?? ?? 85 C0 74 D8 4C 8B 45 E7 B8 4D 5A 00 00 66 41 39 00 75 C9 49 63 40 3C 85 C0 7E C1 41 81 3C 00 50 45 00 00 49 8D 0C 00 75 B3 44 0F B7 49 14 0F B7 51 06 48 89 9C 24 B8 00 00 00 4C 03 C9 41 2B F0 48 89 BC 24 B0 00 00 00 41 8B FE 41 8B DE 85 D2 74 27 0F 1F 80 00 00 00 00 8B C3 48 8D 0C 80 41 8B 44 C9 24 3B F0 72 0B 8B FE 2B F8 41 3B 74 C9 20 72 06 FF C3 3B DA 72 E0 3B DA 74 78 FF C3 44 38 35 ?? ?? ?? ?? 75 23 4C 39 35 ?? ?? ?? ?? 75 64 E8 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 85 C0 74 53 C6 05 ?? ?? ?? ?? 01 EB 07 48 8B 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B C8 FF 15 ?? ?? ?? ?? 48 85 C0 74 2E 48 8D 4D BF 45 33 C9 45 33 C0 48 89 4C 24 38 48 8D 4D D7 4C 89 74 24 30 4C 89 74 24 28 48 89 4C 24 20 48 8B 4D 77 33 D2 FF D0 85 C0 75 07 33 C0 E9 07 02 00 00 48 8B 4D BF 48 8B 01 FF 10 3D 41 91 32 01 0F 85 E6 01 00 00 48 8B 4D BF 4C 8D 4D CF 4C 8D 05 ?? ?? ?? ?? 48 8B 01 33 D2 FF 50 38 85 C0 0F 84 C7 01 00 00 48 8B 4D CF 4C 89 74 24 30 4C 8D 4D AF 48 8B 01 44 8B C7 0F B7 D3 4C 89 74 24 28 4C 89 74 24 20 FF 50 40 85 C0 0F 84 92 01 00 00 48 8B 4D AF 4C 89 75 A7 48 8D 55 A7 48 8B 01 FF 90 D0 00 00 00 84 C0 0F 84 68 01 00 00 48 8B 4D A7 48 85 C9 0F 84 5B 01 00 00 48 8B 01 49 8B F6 FF 50 10 85 C0 0F 84 2D 01 00 00 0F 1F 40 00 48 8B 4D A7 48 8D 55 5F 4C 89 74 24 30 48 8B 01 48 89 54 24 28 48 8D 55 C7 48 89 54 24 20 4C 8D 4D 57 4C 8D 45 6F 33 D2 FF 50 18 84 C0 0F 84 0A 01 00 00 0F B7 45 57 3B C3 75 0E 8B 4D 6F 3B CF 77 07 03 4D C7 3B F9 72 13 48 8B 4D A7 48 8B 01 FF 50 10 85 C0 75 A9 E9 CD 00 00 00 8B 5D 5F 48 B9 FD FF FF FF FF FF FF 1F 48 8D 43 FF 48 3B C1 0F 87 C7 00 00 00 48 8D 1C DD 00 00 00 00 FF 15 ?? ?? ?? ?? 4C 8B C3 48 8B C8 33 D2 FF 15 ?? ?? ?? ?? 48 8B F0 48 85 C0 0F 84 9F 00 00 00 48 8B 4D A7 48 89 44 24 30 48 8D 45 5F 4C 8B 11 48 89 44 24 28 48 8D 55 B7 45 33 C9 45 33 C0 4C 89 74 24 20 41 FF 52 18 84 C0 74 5F 2B 7D 6F 3B 3E 72 58 8B 55 5F BB 01 00 00 00 8B CB 3B D3 76 0E 90 8B C1 3B 3C C6 72 06 FF C1 3B CA 72 F3 8B 55 B7 8D 41 FF 48 8B 4D AF 8B 44 C6 04 4C 89 74 24 30 4C 8D 4D 67 25 FF FF FF 00 4D 8B C5 4C 89 74 24 28 41 89 04 24 48 8B 01 4C 89 74 24 20 FF 90 E0 00 00 00 84 C0 44 0F 45 F3 FF 15 ?? ?? ?? ?? 4C 8B C6 33 D2 48 8B C8 FF 15 ?? ?? ?? ?? 48 8B 4D A7 48 8B 01 FF 10 48 8B 4D AF 48 8B 11 FF 92 80 00 00 00 48 8B 4D CF 48 8B 11 FF 52 70 48 8B 4D BF 48 8B 11 FF 52 58 41 8B C6 48 8B 9C 24 B8 00 00 00 48 8B BC 24 B0 00 00 00 48 81 C4 C0 00 00 00 41 5E 41 5D 41 5C 5E 5D C3 }
	condition:
		$1
}

rule file_48_0_0 {
	meta:
		name = "_wspawnl"
		size = 863
		refs = "0049 ??_C@_1CC@MODLNCFO@?$AAp?$AAa?$AAt?$AAh?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0055 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 006a ??_C@_1GK@LHEJPOIC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 0074 _CrtDbgReportW 0088 _errno 00ab ??_C@_1BC@LBNADFPC@?$AA_?$AAw?$AAs?$AAp?$AAa?$AAw?$AAn?$AAl?$AA?$AA@ 00b7 _invalid_parameter 00fa ??_C@_1CM@PKENOFGE@?$AA?$CK?$AAp?$AAa?$AAt?$AAh?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 01a7 ??_C@_1CA@MOAFCHEI@?$AAa?$AAr?$AAg?$AAl?$AAi?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0258 ??_C@_1CK@PKCLGCC@?$AA?$CK?$AAa?$AAr?$AAg?$AAl?$AAi?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 02fc _wcapture_argv 0326 _wspawnve 034e _free_dbg"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 89 4C 24 08 4C 89 4C 24 20 48 81 EC 78 02 00 00 48 83 BC 24 88 02 00 00 00 74 0A C7 44 24 48 01 00 00 00 EB 08 C7 44 24 48 00 00 00 00 8B 44 24 48 89 44 24 38 83 7C 24 38 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 46 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 38 00 75 40 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 46 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 C7 C0 FF FF FF FF E9 90 02 00 00 48 8B 84 24 88 02 00 00 0F B7 00 85 C0 74 0A C7 44 24 44 01 00 00 00 EB 08 C7 44 24 44 00 00 00 00 8B 44 24 44 89 44 24 40 83 7C 24 40 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 47 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 40 00 75 40 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 47 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 C7 C0 FF FF FF FF E9 DF 01 00 00 48 83 BC 24 90 02 00 00 00 74 0A C7 44 24 4C 01 00 00 00 EB 08 C7 44 24 4C 00 00 00 00 8B 44 24 4C 89 44 24 30 83 7C 24 30 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 48 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 30 00 75 40 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 48 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 C7 C0 FF FF FF FF E9 32 01 00 00 48 8B 84 24 90 02 00 00 0F B7 00 85 C0 74 0A C7 44 24 34 01 00 00 00 EB 08 C7 44 24 34 00 00 00 00 8B 44 24 34 89 44 24 3C 83 7C 24 3C 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 49 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 3C 00 75 40 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 49 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 C7 C0 FF FF FF FF E9 81 00 00 00 48 8D 84 24 98 02 00 00 48 89 44 24 58 41 B9 40 00 00 00 4C 8D 44 24 70 48 8B 94 24 90 02 00 00 48 8D 4C 24 58 E8 ?? ?? ?? ?? 48 89 44 24 50 48 C7 44 24 58 00 00 00 00 45 33 C9 4C 8B 44 24 50 48 8B 94 24 88 02 00 00 8B 8C 24 80 02 00 00 E8 ?? ?? ?? ?? 48 89 44 24 60 48 83 7C 24 50 00 74 1B 48 8D 44 24 70 48 39 44 24 50 74 0F BA 02 00 00 00 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 8B 44 24 60 48 81 C4 78 02 00 00 C3 }
	condition:
		$1
}

rule file_49_0_0 {
	meta:
		name = "_realloc_base"
		size = 281
		refs = "0026 _malloc_base 003d _free_base 0079 _crtheap 007f __imp_HeapReAlloc 0090 _callnewh 0095 _errno 00ad _newmode 00c0 __imp_GetLastError 00c7 _get_errno_from_oserr"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 48 8B 44 24 58 48 89 44 24 30 48 83 7C 24 50 00 75 0F 48 8B 4C 24 58 E8 ?? ?? ?? ?? E9 E5 00 00 00 48 83 7C 24 58 00 75 11 48 8B 4C 24 50 E8 ?? ?? ?? ?? 33 C0 E9 CC 00 00 00 48 C7 44 24 28 00 00 00 00 48 83 7C 24 58 E0 77 31 48 83 7C 24 58 00 75 09 48 C7 44 24 58 01 00 00 00 4C 8B 4C 24 58 4C 8B 44 24 50 33 D2 48 8B 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 89 44 24 28 EB 19 48 8B 4C 24 58 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 00 0C 00 00 00 33 C0 EB 71 48 83 7C 24 28 00 75 09 83 3D ?? ?? ?? ?? 00 75 2D 48 83 7C 24 28 00 74 02 EB 1C FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 89 44 24 20 E8 ?? ?? ?? ?? 8B 4C 24 20 89 08 48 8B 44 24 28 EB 33 48 8B 4C 24 58 E8 ?? ?? ?? ?? 85 C0 75 20 FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 89 44 24 24 E8 ?? ?? ?? ?? 8B 4C 24 24 89 08 33 C0 EB 05 E9 34 FF FF FF 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_50_0_0 {
	meta:
		name = "__sse2_atan2f4"
		size = 1328
		refs = "0014 s_dwAbsMask 003d s_dwMaxNormal 0045 s_dwMinBound 0053 s_dwSignMask 0062 s_fOne 00ae s_fPi2 00be s_fPi 00d1 s_fA8 00db s_fA7 00e5 s_fA6 00ec s_fA5 00f9 s_fA4 0100 s_fA3 010d s_fA2 0114 s_fA1 0121 s_fA0 0155 INFP 015f INFN 016a NEGZERO 02b1 _2il0floatpacket_16 02db pi_or_zero 02f2 _2il0floatpacket_11 02fe _2il0floatpacket_10 0307 _2il0floatpacket_14 0317 _2il0floatpacket_9 032b _2il0floatpacket_8 033e _2il0floatpacket_7 034a _2il0floatpacket_15 035c _2il0floatpacket_13 0371 _2il0floatpacket_12 03f5 _2il0floatpacket_17 0400 _2il0floatpacket_18 041f _2il0floatpacket_20 0427 _2il0floatpacket_19 043b _2il0floatpacket_21 0449 _2il0floatpacket_22 047e _2il0floatpacket_23 048c _2il0floatpacket_24"
	strings:
		$1 = { 48 81 EC C8 00 00 00 0F 29 7C 24 60 0F 29 74 24 70 0F 28 15 ?? ?? ?? ?? 0F 28 EA 0F 11 84 24 80 00 00 00 66 0F DB E9 66 0F DB D0 0F 11 8C 24 90 00 00 00 0F 28 FD 0F 28 F2 66 0F 66 35 ?? ?? ?? ?? 66 0F 66 3D ?? ?? ?? ?? 66 0F DF F7 0F 50 C6 0F 28 35 ?? ?? ?? ?? 66 0F DB C6 0F 28 FE 66 0F EB 05 ?? ?? ?? ?? 0F 28 DD 66 0F DB F9 0F 11 44 24 50 66 0F EB 3D ?? ?? ?? ?? 0F C2 DA 01 0F 28 E3 66 0F DB E5 0F 28 C3 66 0F DF C2 66 0F EB E0 66 0F DB D3 0F 28 C3 66 0F DF C5 66 0F EB D0 0F 5E E2 66 0F DB F3 66 0F EF ED 66 0F DB 1D ?? ?? ?? ?? 0F C2 CD 01 66 0F EB E6 66 0F DB 0D ?? ?? ?? ?? 0F 28 C4 0F 59 C4 0F 28 D0 0F 59 D0 0F 28 35 ?? ?? ?? ?? 0F 59 F2 0F 28 2D ?? ?? ?? ?? 0F 59 EA 0F 58 35 ?? ?? ?? ?? 0F 58 2D ?? ?? ?? ?? 0F 59 F2 0F 59 EA 0F 58 35 ?? ?? ?? ?? 0F 58 2D ?? ?? ?? ?? 0F 59 F2 0F 59 EA 0F 58 35 ?? ?? ?? ?? 0F 58 2D ?? ?? ?? ?? 0F 59 F2 0F 59 C5 0F 58 35 ?? ?? ?? ?? 0F 58 C6 0F 59 C4 0F 28 6C 24 50 0F 58 C3 0F 59 C7 89 84 24 B0 00 00 00 0F 58 C1 0F 59 C5 83 BC 24 B0 00 00 00 0F 0F 84 8D 02 00 00 F3 0F 10 1D ?? ?? ?? ?? 33 C9 F3 0F 10 15 ?? ?? ?? ?? 0F 57 C0 F3 0F 10 0D ?? ?? ?? ?? 33 D2 44 0F 29 44 24 40 B8 00 00 80 3F 44 0F 29 4C 24 30 44 0F 29 54 24 20 44 8B 8C 8C 90 00 00 00 45 8B C1 44 8B 94 8C 80 00 00 00 45 8B DA 41 81 E3 00 00 00 80 44 89 8C 24 C4 00 00 00 41 81 E1 FF FF FF 7F 41 81 E0 00 00 00 80 F3 44 0F 10 8C 8C 80 00 00 00 41 81 F9 00 00 80 7F F3 0F 10 A4 8C 90 00 00 00 89 94 24 B4 00 00 00 89 94 24 B8 00 00 00 89 84 24 BC 00 00 00 44 89 94 24 C0 00 00 00 7F 10 41 81 E2 FF FF FF 7F 41 81 FA 00 00 80 7F 7E 0A F3 44 0F 58 CC E9 A0 01 00 00 44 0F 2E C8 7A 06 0F 84 A0 02 00 00 0F 2E E0 7A 06 0F 84 71 02 00 00 0F 2E E3 7A 06 0F 84 23 02 00 00 0F 2E E2 7A 06 0F 84 CC 01 00 00 44 0F 2E CB 7A 06 0F 84 B5 01 00 00 44 0F 2E CA 7A 06 0F 84 9E 01 00 00 44 8B 8C 24 C0 00 00 00 41 81 CB 00 00 80 3F 44 8B 94 24 C4 00 00 00 41 81 E1 FF FF FF 7F 41 81 E2 FF FF FF 7F 44 89 8C 24 B4 00 00 00 44 89 94 24 B8 00 00 00 F3 44 0F 10 84 24 B4 00 00 00 F3 0F 10 A4 24 B8 00 00 00 44 89 9C 24 BC 00 00 00 44 0F 2F C4 76 1E 44 0F 28 D0 F2 44 0F 10 0D ?? ?? ?? ?? F3 44 0F 5C D4 F3 45 0F 5E D0 F3 45 0F 5A C2 EB 0E F3 44 0F 5E C4 F3 45 0F 5A C0 45 0F 57 C9 41 0F 28 F0 4C 8D 0D ?? ?? ?? ?? F2 41 0F 59 F0 4D 8B D1 0F 28 FE F2 0F 59 FE F2 0F 10 2D ?? ?? ?? ?? F2 0F 59 EF F2 0F 10 25 ?? ?? ?? ?? F2 44 0F 10 15 ?? ?? ?? ?? F2 0F 58 EC F2 0F 59 EF F2 0F 10 25 ?? ?? ?? ?? 41 C1 F8 1F F2 0F 58 EC F2 0F 59 EF F2 0F 10 25 ?? ?? ?? ?? 4D 63 C0 F2 0F 58 EC F2 0F 59 EF F2 0F 10 25 ?? ?? ?? ?? F2 0F 58 EC F2 0F 10 25 ?? ?? ?? ?? F2 0F 59 E7 F2 41 0F 58 E2 F2 44 0F 10 15 ?? ?? ?? ?? F2 0F 59 E7 F2 41 0F 58 E2 F2 0F 59 E7 F2 0F 10 3D ?? ?? ?? ?? F2 0F 58 E7 F2 0F 59 F4 F2 0F 58 EE F2 44 0F 59 C5 F2 45 0F 58 C8 F3 44 0F 5A 84 24 BC 00 00 00 F2 47 0F 59 4C C1 18 F2 47 0F 58 4C C2 08 F2 45 0F 59 C8 F2 45 0F 5A C9 F3 44 0F 11 8C 8C A0 00 00 00 48 FF C1 48 83 F9 04 0F 8C C3 FD FF FF 44 0F 28 44 24 40 44 0F 28 4C 24 30 44 0F 28 54 24 20 0F 28 84 24 A0 00 00 00 0F 28 74 24 70 0F 28 7C 24 60 48 81 C4 C8 00 00 00 C3 F3 44 0F 10 0D ?? ?? ?? ?? EB B2 F3 44 0F 10 0D ?? ?? ?? ?? EB A7 44 0F 2E CB 7A 02 74 36 44 0F 2E CA 7A 02 74 20 44 0F 2F C8 F3 44 0F 10 0D ?? ?? ?? ?? F3 0F 10 25 ?? ?? ?? ?? 77 80 44 0F 28 CC E9 77 FF FF FF F3 44 0F 10 0D ?? ?? ?? ?? E9 69 FF FF FF F3 44 0F 10 0D ?? ?? ?? ?? E9 5B FF FF FF 44 0F 2E CB 7A 02 74 2D 44 0F 2E CA 7A 02 74 17 41 0F 2F C1 44 0F 28 C9 0F 87 3D FF FF FF 44 0F 28 C8 E9 34 FF FF FF F3 44 0F 10 0D ?? ?? ?? ?? E9 26 FF FF FF F3 44 0F 10 0D ?? ?? ?? ?? E9 18 FF FF FF 44 0F 2F C8 F3 44 0F 10 0D ?? ?? ?? ?? F3 0F 10 25 ?? ?? ?? ?? 0F 87 FD FE FF FF 44 0F 28 CC E9 F4 FE FF FF 45 85 DB 74 36 0F 2F E0 0F 87 E6 FE FF FF 0F 2F C4 76 0E F3 44 0F 10 0D ?? ?? ?? ?? E9 D3 FE FF FF 45 85 C0 F3 0F 10 25 ?? ?? ?? ?? 0F 84 C2 FE FF FF 44 0F 28 CC E9 B9 FE FF FF 0F 2F E0 0F 87 B0 FE FF FF 0F 2F C4 76 0E F3 44 0F 10 0D ?? ?? ?? ?? E9 9D FE FF FF 45 85 C0 F3 0F 10 25 ?? ?? ?? ?? 0F 84 8C FE FF FF 44 0F 28 CC E9 83 FE FF FF 66 0F 1F 44 00 00 }
	condition:
		$1
}

rule file_52_0_0 {
	meta:
		name = "strnlen"
		size = 82
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 18 48 C7 04 24 00 00 00 00 EB 18 48 8B 04 24 48 FF C0 48 89 04 24 48 8B 44 24 20 48 FF C0 48 89 44 24 20 48 8B 44 24 28 48 39 04 24 73 0E 48 8B 44 24 20 0F BE 00 85 C0 74 02 EB CF 48 8B 04 24 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_53_0_0 {
	meta:
		name = "__remainder_piby2f_inline"
		size = 1206
		refs = "0019 __security_cookie 00e1 ?pibits@?1??__remainder_piby2f_inline@@9@9 048e ?piby2@?1??__remainder_piby2f_inline@@9@9 04aa __security_check_cookie"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 81 EC C8 00 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 B0 00 00 00 48 B8 00 00 00 00 00 00 F0 7F 48 8B 8C 24 D0 00 00 00 48 23 C8 48 8B C1 48 C1 E8 34 48 2D FF 03 00 00 89 44 24 40 48 B8 FF FF FF FF FF FF 0F 00 48 8B 8C 24 D0 00 00 00 48 23 C8 48 8B C1 48 B9 00 00 00 00 00 00 10 00 48 0B C1 48 C1 E8 1D 48 89 84 24 D0 00 00 00 48 C7 44 24 20 01 00 00 00 48 8B 44 24 20 48 C1 E0 24 48 FF C8 48 89 44 24 20 8B 44 24 40 99 B9 24 00 00 00 F7 F9 89 44 24 2C 8B 44 24 2C 6B C0 24 8B 4C 24 40 2B C8 8B C1 89 44 24 18 8B 44 24 2C 83 C0 03 89 44 24 30 B8 08 00 00 00 48 6B C0 04 48 C7 44 04 60 00 00 00 00 48 63 44 24 30 48 8D 0D ?? ?? ?? ?? 48 8B 04 C1 48 0F AF 84 24 D0 00 00 00 48 89 44 24 10 48 8B 44 24 20 48 8B 4C 24 10 48 23 C8 48 8B C1 B9 08 00 00 00 48 6B C9 03 48 89 44 0C 60 48 8B 44 24 10 48 C1 E8 24 48 89 44 24 38 8B 44 24 30 FF C8 48 98 48 8D 0D ?? ?? ?? ?? 48 8B 04 C1 48 0F AF 84 24 D0 00 00 00 48 03 44 24 38 48 89 44 24 10 48 8B 44 24 20 48 8B 4C 24 10 48 23 C8 48 8B C1 B9 08 00 00 00 48 6B C9 02 48 89 44 0C 60 48 8B 44 24 10 48 C1 E8 24 48 89 44 24 38 8B 44 24 30 83 E8 02 48 98 48 8D 0D ?? ?? ?? ?? 48 8B 04 C1 48 0F AF 84 24 D0 00 00 00 48 03 44 24 38 48 89 44 24 10 48 8B 44 24 20 48 8B 4C 24 10 48 23 C8 48 8B C1 B9 08 00 00 00 48 6B C9 01 48 89 44 0C 60 48 8B 44 24 10 48 C1 E8 24 48 89 44 24 38 48 63 44 24 2C 48 8D 0D ?? ?? ?? ?? 48 8B 04 C1 48 0F AF 84 24 D0 00 00 00 48 03 44 24 38 48 89 44 24 10 48 8B 44 24 20 48 8B 4C 24 10 48 23 C8 48 8B C1 B9 08 00 00 00 48 6B C9 00 48 89 44 0C 60 B8 08 00 00 00 48 6B C0 00 48 8B 44 04 60 48 C1 E0 24 B9 08 00 00 00 48 6B C9 01 48 0B 44 0C 60 B9 23 00 00 00 2B 4C 24 18 48 D3 E8 48 83 E0 07 89 44 24 28 8B 44 24 28 83 E0 01 89 44 24 34 C7 44 24 08 01 00 00 00 83 7C 24 34 00 0F 84 A1 00 00 00 8B 44 24 28 D1 F8 FF C0 83 E0 03 48 8B 8C 24 E0 00 00 00 89 01 48 C7 04 24 01 00 00 00 B8 08 00 00 00 48 6B C0 01 48 8B 44 04 60 48 F7 D0 B9 24 00 00 00 2B 4C 24 18 48 8B 14 24 48 D3 E2 48 8B CA 48 FF C9 48 23 C1 48 89 04 24 48 81 3C 24 00 00 01 00 73 2D 8B 44 24 08 FF C0 89 44 24 08 48 8B 04 24 48 C1 E0 24 48 63 4C 24 08 48 8B 4C CC 60 48 F7 D1 48 23 4C 24 20 48 0B C1 48 89 04 24 EB C9 8B 44 24 08 FF C0 48 98 48 8B 44 C4 60 48 F7 D0 48 23 44 24 20 48 89 44 24 48 E9 81 00 00 00 8B 44 24 28 D1 F8 48 8B 8C 24 E0 00 00 00 89 01 48 C7 04 24 01 00 00 00 B8 08 00 00 00 48 6B C0 01 B9 24 00 00 00 2B 4C 24 18 48 8B 14 24 48 D3 E2 48 8B CA 48 FF C9 48 8B 44 04 60 48 23 C1 48 89 04 24 48 81 3C 24 00 00 01 00 73 22 8B 44 24 08 FF C0 89 44 24 08 48 8B 04 24 48 C1 E0 24 48 63 4C 24 08 48 0B 44 CC 60 48 89 04 24 EB D4 8B 44 24 08 FF C0 48 98 48 8B 44 C4 60 48 89 44 24 48 C7 44 24 0C 00 00 00 00 48 B8 00 00 00 00 00 40 00 00 48 39 04 24 73 19 8B 44 24 0C 83 C0 06 89 44 24 0C 48 8B 04 24 48 C1 E0 06 48 89 04 24 EB D7 48 B8 00 00 00 00 00 00 10 00 48 39 04 24 73 17 8B 44 24 0C FF C0 89 44 24 0C 48 8B 04 24 48 D1 E0 48 89 04 24 EB D9 B8 24 00 00 00 2B 44 24 0C 0F B6 C8 48 8B 44 24 48 48 D3 E8 48 8B 0C 24 48 0B C8 48 8B C1 48 89 04 24 8B 44 24 18 83 C0 34 2B 44 24 0C 8B 4C 24 08 6B C9 24 2B C1 89 44 24 44 48 63 44 24 44 48 05 FF 03 00 00 48 C1 E0 34 48 89 44 24 10 48 B8 FF FF FF FF FF FF 0F 00 48 8B 0C 24 48 23 C8 48 8B C1 48 0B 44 24 10 48 89 84 24 D0 00 00 00 83 7C 24 34 00 74 20 48 B8 00 00 00 00 00 00 00 80 48 8B 8C 24 D0 00 00 00 48 0B C8 48 8B C1 48 89 84 24 D0 00 00 00 48 8B 84 24 D0 00 00 00 48 89 44 24 50 F2 0F 10 44 24 50 F2 0F 11 44 24 58 F2 0F 10 44 24 58 F2 0F 59 05 ?? ?? ?? ?? 48 8B 84 24 D8 00 00 00 F2 0F 11 00 48 8B 8C 24 B0 00 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 C8 00 00 00 C3 }
	condition:
		$1
}

rule file_1139_0_0 {
	meta:
		name = "__remainder_piby2f"
		size = 1206
		refs = "0019 __security_cookie 00e1 ?pibits@?1??__remainder_piby2f@@9@9 048e ?piby2@?1??__remainder_piby2f@@9@9 04aa __security_check_cookie"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 81 EC C8 00 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 B0 00 00 00 48 B8 00 00 00 00 00 00 F0 7F 48 8B 8C 24 D0 00 00 00 48 23 C8 48 8B C1 48 C1 E8 34 48 2D FF 03 00 00 89 44 24 40 48 B8 FF FF FF FF FF FF 0F 00 48 8B 8C 24 D0 00 00 00 48 23 C8 48 8B C1 48 B9 00 00 00 00 00 00 10 00 48 0B C1 48 C1 E8 1D 48 89 84 24 D0 00 00 00 48 C7 44 24 20 01 00 00 00 48 8B 44 24 20 48 C1 E0 24 48 FF C8 48 89 44 24 20 8B 44 24 40 99 B9 24 00 00 00 F7 F9 89 44 24 2C 8B 44 24 2C 6B C0 24 8B 4C 24 40 2B C8 8B C1 89 44 24 18 8B 44 24 2C 83 C0 03 89 44 24 30 B8 08 00 00 00 48 6B C0 04 48 C7 44 04 60 00 00 00 00 48 63 44 24 30 48 8D 0D ?? ?? ?? ?? 48 8B 04 C1 48 0F AF 84 24 D0 00 00 00 48 89 44 24 10 48 8B 44 24 20 48 8B 4C 24 10 48 23 C8 48 8B C1 B9 08 00 00 00 48 6B C9 03 48 89 44 0C 60 48 8B 44 24 10 48 C1 E8 24 48 89 44 24 38 8B 44 24 30 FF C8 48 98 48 8D 0D ?? ?? ?? ?? 48 8B 04 C1 48 0F AF 84 24 D0 00 00 00 48 03 44 24 38 48 89 44 24 10 48 8B 44 24 20 48 8B 4C 24 10 48 23 C8 48 8B C1 B9 08 00 00 00 48 6B C9 02 48 89 44 0C 60 48 8B 44 24 10 48 C1 E8 24 48 89 44 24 38 8B 44 24 30 83 E8 02 48 98 48 8D 0D ?? ?? ?? ?? 48 8B 04 C1 48 0F AF 84 24 D0 00 00 00 48 03 44 24 38 48 89 44 24 10 48 8B 44 24 20 48 8B 4C 24 10 48 23 C8 48 8B C1 B9 08 00 00 00 48 6B C9 01 48 89 44 0C 60 48 8B 44 24 10 48 C1 E8 24 48 89 44 24 38 48 63 44 24 2C 48 8D 0D ?? ?? ?? ?? 48 8B 04 C1 48 0F AF 84 24 D0 00 00 00 48 03 44 24 38 48 89 44 24 10 48 8B 44 24 20 48 8B 4C 24 10 48 23 C8 48 8B C1 B9 08 00 00 00 48 6B C9 00 48 89 44 0C 60 B8 08 00 00 00 48 6B C0 00 48 8B 44 04 60 48 C1 E0 24 B9 08 00 00 00 48 6B C9 01 48 0B 44 0C 60 B9 23 00 00 00 2B 4C 24 18 48 D3 E8 48 83 E0 07 89 44 24 28 8B 44 24 28 83 E0 01 89 44 24 34 C7 44 24 08 01 00 00 00 83 7C 24 34 00 0F 84 A1 00 00 00 8B 44 24 28 D1 F8 FF C0 83 E0 03 48 8B 8C 24 E0 00 00 00 89 01 48 C7 04 24 01 00 00 00 B8 08 00 00 00 48 6B C0 01 48 8B 44 04 60 48 F7 D0 B9 24 00 00 00 2B 4C 24 18 48 8B 14 24 48 D3 E2 48 8B CA 48 FF C9 48 23 C1 48 89 04 24 48 81 3C 24 00 00 01 00 73 2D 8B 44 24 08 FF C0 89 44 24 08 48 8B 04 24 48 C1 E0 24 48 63 4C 24 08 48 8B 4C CC 60 48 F7 D1 48 23 4C 24 20 48 0B C1 48 89 04 24 EB C9 8B 44 24 08 FF C0 48 98 48 8B 44 C4 60 48 F7 D0 48 23 44 24 20 48 89 44 24 48 E9 81 00 00 00 8B 44 24 28 D1 F8 48 8B 8C 24 E0 00 00 00 89 01 48 C7 04 24 01 00 00 00 B8 08 00 00 00 48 6B C0 01 B9 24 00 00 00 2B 4C 24 18 48 8B 14 24 48 D3 E2 48 8B CA 48 FF C9 48 8B 44 04 60 48 23 C1 48 89 04 24 48 81 3C 24 00 00 01 00 73 22 8B 44 24 08 FF C0 89 44 24 08 48 8B 04 24 48 C1 E0 24 48 63 4C 24 08 48 0B 44 CC 60 48 89 04 24 EB D4 8B 44 24 08 FF C0 48 98 48 8B 44 C4 60 48 89 44 24 48 C7 44 24 0C 00 00 00 00 48 B8 00 00 00 00 00 40 00 00 48 39 04 24 73 19 8B 44 24 0C 83 C0 06 89 44 24 0C 48 8B 04 24 48 C1 E0 06 48 89 04 24 EB D7 48 B8 00 00 00 00 00 00 10 00 48 39 04 24 73 17 8B 44 24 0C FF C0 89 44 24 0C 48 8B 04 24 48 D1 E0 48 89 04 24 EB D9 B8 24 00 00 00 2B 44 24 0C 0F B6 C8 48 8B 44 24 48 48 D3 E8 48 8B 0C 24 48 0B C8 48 8B C1 48 89 04 24 8B 44 24 18 83 C0 34 2B 44 24 0C 8B 4C 24 08 6B C9 24 2B C1 89 44 24 44 48 63 44 24 44 48 05 FF 03 00 00 48 C1 E0 34 48 89 44 24 10 48 B8 FF FF FF FF FF FF 0F 00 48 8B 0C 24 48 23 C8 48 8B C1 48 0B 44 24 10 48 89 84 24 D0 00 00 00 83 7C 24 34 00 74 20 48 B8 00 00 00 00 00 00 00 80 48 8B 8C 24 D0 00 00 00 48 0B C8 48 8B C1 48 89 84 24 D0 00 00 00 48 8B 84 24 D0 00 00 00 48 89 44 24 50 F2 0F 10 44 24 50 F2 0F 11 44 24 58 F2 0F 10 44 24 58 F2 0F 59 05 ?? ?? ?? ?? 48 8B 84 24 D8 00 00 00 F2 0F 11 00 48 8B 8C 24 B0 00 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 C8 00 00 00 C3 }
	condition:
		$1
}

rule file_53_2_0 {
	meta:
		name = "tanf"
		size = 1271
		refs = "00b6 valf_with_flags 00d7 __real@3fd5555555555555 00ff tanf_piby4 01c7 ??_C@_04MHPLPEIA@tanf?$AA@ 01cc _handle_errorf 024a __xmm@80000000000000008000000000000000 0258 __real@411e848000000000 02ef ?twobypi@?L@??tanf@@9@9 02f7 __real@3fe0000000000000 030d ?piby2_1@?L@??tanf@@9@9 032e ?piby2_1tail@?L@??tanf@@9@9 03b1 ?piby2_2@?L@??tanf@@9@9 03da ?piby2_2tail@?L@??tanf@@9@9 0421 ?piby2_3@?L@??tanf@@9@9 044a ?piby2_3tail@?L@??tanf@@9@9 04a2 __remainder_piby2f_inline"
	strings:
		$1 = { F3 0F 11 44 24 08 48 81 EC D8 00 00 00 F3 0F 5A 84 24 E0 00 00 00 F2 0F 11 44 24 58 F2 0F 10 44 24 58 F2 0F 11 84 24 B8 00 00 00 48 8B 84 24 B8 00 00 00 48 89 84 24 88 00 00 00 48 B8 FF FF FF FF FF FF FF 7F 48 8B 8C 24 88 00 00 00 48 23 C8 48 8B C1 48 89 44 24 60 48 B8 18 2D 44 54 FB 21 E9 3F 48 39 44 24 60 0F 87 A4 00 00 00 48 B8 00 00 00 00 00 00 80 3F 48 39 44 24 60 73 75 48 B8 00 00 00 00 00 00 20 3F 48 39 44 24 60 73 32 48 83 7C 24 60 00 75 10 F3 0F 10 84 24 E0 00 00 00 E9 4A 04 00 00 EB 18 BA 10 00 00 00 F3 0F 10 84 24 E0 00 00 00 E8 ?? ?? ?? ?? E9 30 04 00 00 EB 30 F2 0F 10 44 24 58 F2 0F 59 44 24 58 F2 0F 59 44 24 58 F2 0F 59 05 ?? ?? ?? ?? F2 0F 10 4C 24 58 F2 0F 58 C8 0F 28 C1 F2 0F 5A C0 E9 FE 03 00 00 EB 19 F3 0F 5A 84 24 E0 00 00 00 33 D2 E8 ?? ?? ?? ?? F2 0F 5A C0 E9 E3 03 00 00 E9 18 01 00 00 48 B8 00 00 00 00 00 00 F0 7F 48 8B 8C 24 88 00 00 00 48 23 C8 48 8B C1 48 B9 00 00 00 00 00 00 F0 7F 48 3B C1 0F 85 ED 00 00 00 48 B8 FF FF FF FF FF FF 0F 00 48 8B 8C 24 88 00 00 00 48 23 C8 48 8B C1 48 85 C0 74 7E F3 0F 10 84 24 E0 00 00 00 F3 0F 11 84 24 94 00 00 00 8B 84 24 94 00 00 00 89 84 24 90 00 00 00 8B 84 24 90 00 00 00 0F BA E8 16 8B C0 C7 44 24 40 01 00 00 00 0F 57 C0 F3 0F 11 44 24 38 F3 0F 10 84 24 E0 00 00 00 F3 0F 11 44 24 30 C7 44 24 28 21 00 00 00 C7 44 24 20 00 00 00 00 41 B9 01 00 00 00 44 8B C0 BA 20 00 00 00 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 1A 03 00 00 EB 52 C7 44 24 40 01 00 00 00 0F 57 C0 F3 0F 11 44 24 38 F3 0F 10 84 24 E0 00 00 00 F3 0F 11 44 24 30 C7 44 24 28 21 00 00 00 C7 44 24 20 08 00 00 00 41 B9 01 00 00 00 41 B8 00 00 C0 FF BA 20 00 00 00 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 C6 02 00 00 48 8B 84 24 88 00 00 00 48 C1 E8 3F 89 44 24 7C 83 7C 24 7C 00 74 14 F2 0F 10 44 24 58 66 0F 57 05 ?? ?? ?? ?? F2 0F 11 44 24 58 F2 0F 10 05 ?? ?? ?? ?? 66 0F 2F 44 24 58 0F 86 27 02 00 00 48 8B 44 24 60 48 C1 E8 34 48 89 84 24 C0 00 00 00 48 B8 5E 38 55 29 7A 6A 0F 40 48 39 44 24 60 77 25 48 B8 D2 21 33 7F 7C D9 02 40 48 39 44 24 60 77 0A C7 44 24 50 01 00 00 00 EB 08 C7 44 24 50 02 00 00 00 EB 54 48 B8 BB B2 CC BE 3A 46 1C 40 48 39 44 24 60 77 25 48 B8 75 A7 BB E9 BB FD 15 40 48 39 44 24 60 77 0A C7 44 24 50 03 00 00 00 EB 08 C7 44 24 50 04 00 00 00 EB 1E F2 0F 10 44 24 58 F2 0F 59 05 ?? ?? ?? ?? F2 0F 58 05 ?? ?? ?? ?? F2 0F 2C C0 89 44 24 50 F2 0F 2A 44 24 50 F2 0F 59 05 ?? ?? ?? ?? F2 0F 10 4C 24 58 F2 0F 5C C8 0F 28 C1 F2 0F 11 44 24 70 F2 0F 2A 44 24 50 F2 0F 59 05 ?? ?? ?? ?? F2 0F 11 44 24 68 F2 0F 10 44 24 70 F2 0F 11 84 24 A8 00 00 00 48 8B 84 24 A8 00 00 00 48 89 84 24 B0 00 00 00 48 B8 00 00 00 00 00 00 F0 7F 48 8B 8C 24 B0 00 00 00 48 23 C8 48 8B C1 48 C1 E8 34 48 8B 8C 24 C0 00 00 00 48 2B C8 48 8B C1 48 89 84 24 A0 00 00 00 48 83 BC 24 A0 00 00 00 0F 0F 86 D5 00 00 00 F2 0F 10 44 24 70 F2 0F 11 84 24 80 00 00 00 F2 0F 2A 44 24 50 F2 0F 59 05 ?? ?? ?? ?? F2 0F 11 44 24 68 F2 0F 10 84 24 80 00 00 00 F2 0F 5C 44 24 68 F2 0F 11 44 24 70 F2 0F 2A 44 24 50 F2 0F 59 05 ?? ?? ?? ?? F2 0F 10 8C 24 80 00 00 00 F2 0F 5C 4C 24 70 F2 0F 5C 4C 24 68 F2 0F 5C C1 F2 0F 11 44 24 68 48 83 BC 24 A0 00 00 00 30 76 65 F2 0F 10 44 24 70 F2 0F 11 84 24 80 00 00 00 F2 0F 2A 44 24 50 F2 0F 59 05 ?? ?? ?? ?? F2 0F 11 44 24 68 F2 0F 10 84 24 80 00 00 00 F2 0F 5C 44 24 68 F2 0F 11 44 24 70 F2 0F 2A 44 24 50 F2 0F 59 05 ?? ?? ?? ?? F2 0F 10 8C 24 80 00 00 00 F2 0F 5C 4C 24 70 F2 0F 5C 4C 24 68 F2 0F 5C C1 F2 0F 11 44 24 68 F2 0F 10 44 24 70 F2 0F 5C 44 24 68 F2 0F 11 84 24 98 00 00 00 8B 44 24 50 83 E0 03 89 44 24 78 EB 17 4C 8D 44 24 78 48 8D 94 24 98 00 00 00 48 8B 4C 24 60 E8 ?? ?? ?? ?? 83 7C 24 7C 00 74 27 8B 44 24 78 83 E0 01 8B D0 F2 0F 10 84 24 98 00 00 00 E8 ?? ?? ?? ?? 66 0F 57 05 ?? ?? ?? ?? F2 0F 5A C0 EB 1D EB 1B 8B 44 24 78 83 E0 01 8B D0 F2 0F 10 84 24 98 00 00 00 E8 ?? ?? ?? ?? F2 0F 5A C0 48 81 C4 D8 00 00 00 C3 }
	condition:
		$1
}

rule file_53_3_0 {
	meta:
		name = "tanf_piby4"
		size = 181
		refs = "002e __real@3f919dba6efd6aad 003b __real@3fd8a8b0da56cb17 004e __real@3f92e29003c692d9 005b __real@bfe07266d7b3511b 006f __real@3ff27e84a3e73a2e 009c __real@bff0000000000000"
	strings:
		$1 = { 89 54 24 10 F2 0F 11 44 24 08 48 83 EC 18 F2 0F 10 44 24 20 F2 0F 59 44 24 20 F2 0F 11 04 24 F2 0F 10 44 24 20 F2 0F 59 04 24 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 0C 24 F2 0F 10 15 ?? ?? ?? ?? F2 0F 5C D1 0F 28 CA F2 0F 59 C1 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 0C 24 F2 0F 10 15 ?? ?? ?? ?? F2 0F 58 D1 0F 28 CA F2 0F 59 0C 24 F2 0F 10 15 ?? ?? ?? ?? F2 0F 58 D1 0F 28 CA F2 0F 5E C1 F2 0F 10 4C 24 20 F2 0F 58 C8 0F 28 C1 F2 0F 11 44 24 08 83 7C 24 28 00 74 12 F2 0F 10 05 ?? ?? ?? ?? F2 0F 5E 44 24 08 EB 08 EB 06 F2 0F 10 44 24 08 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_54_1_0 {
	meta:
		name = "_wassert"
		size = 3699
		refs = "0019 __security_cookie 002e _set_error_mode 004b __app_type 005d __imp_GetStdHandle 00a1 _assertstring 00b3 swprintf 00c2 __imp_GetFileType 00d4 wcslen 00fb __imp_WriteConsoleW 0104 abort 0109 __iob_func 0143 setvbuf 017e fwprintf 0197 fflush 01ac ??_C@_1CE@OJBNHDMO@?$AAA?$AAs?$AAs?$AAe?$AAr?$AAt?$AAi?$AAo?$AAn?$AA?5?$AAf?$AAa?$AAi?$AAl?$AAe?$AAd?$AA?$CB?$AA?$AA@ 01be wcscpy_s 01d6 ??_C@_1GK@EAMFLNLB@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 01dd ??_C@_1BC@LNOOMFNA@?$AA_?$AAw?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AA?$AA@ 01e4 ??_C@_1GM@PANFFKAD@?$AAw?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AA?5?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA6?$AA4?$AA?5?$AA?$CK?$AA?5?$AA9?$AA?$CJ?$AA?0?$AA?5?$AAL@ 01eb _invoke_watson_if_error 01f2 dblnewline 0204 wcscat_s 022a ??_C@_1FI@OJONHFCN@?$AAw?$AAc?$AAs?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AA?5?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA6?$AA4?$AA?5?$AA?$CK?$AA?5?$AA9?$AA?$CJ?$AA?0?$AA?5?$AAd@ 0238 ??_C@_1BE@PHKBBGE@?$AAP?$AAr?$AAo?$AAg?$AAr?$AAa?$AAm?$AA?3?$AA?5?$AA?$AA@ 0270 ??_C@_1FM@JONFCKBO@?$AAw?$AAc?$AAs?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AA?5?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA6?$AA4?$AA?5?$AA?$CK?$AA?5?$AA9?$AA?$CJ?$AA?0?$AA?5?$AAL@ 0292 __imp_GetModuleHandleExW 02c2 __report_rangecheckfailure 02ea __imp_GetModuleFileNameW 02f5 ??_C@_1CO@EAEJAADC@?$AA?$DM?$AAp?$AAr?$AAo?$AAg?$AAr?$AAa?$AAm?$AA?5?$AAn?$AAa?$AAm?$AAe?$AA?5?$AAu?$AAn?$AAk?$AAn?$AAo?$AAw?$AAn?$AA?$DO?$AA?$AA@ 032d ??_C@_1HA@EPFCONEE@?$AAw?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AA?5?$AAp?$AAr?$AAo?$AAg?$AAn?$AAa?$AAm?$AAe?$AA?0?$AA?5?$AA2?$AA6?$AA0?$AA?5?$AA?$CL?$AA?5?$AA1?$AA?0?$AA?5?$AAL?$AA?$CC?$AA?$DM@ 03a9 dotdotdot 03b6 memcpy_s 03dc ??_C@_1LK@LGFOFOMH@?$AAm?$AAe?$AAm?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAp?$AAc?$AAh?$AA?0?$AA?5?$AAs?$AAi?$AAz?$AAe?$AAo?$AAf?$AA?$CI?$AAT?$AAC?$AAH?$AAA?$AAR?$AA?$CJ?$AA?5?$AA?$CK?$AA?5?$AA?$CI?$AA?$CI@ 0420 ??_C@_1EK@BFAHOLDO@?$AAw?$AAc?$AAs?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AA?5?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA6?$AA4?$AA?5?$AA?$CK?$AA?5?$AA9?$AA?$CJ?$AA?0?$AA?5?$AAp@ 042e newline 0466 ??_C@_1FC@GNPGDADJ@?$AAw?$AAc?$AAs?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AA?5?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA6?$AA4?$AA?5?$AA?$CK?$AA?5?$AA9?$AA?$CJ?$AA?0?$AA?5?$AAn@ 0474 ??_C@_1O@HEMHKNDC@?$AAF?$AAi?$AAl?$AAe?$AA?3?$AA?5?$AA?$AA@ 04ac ??_C@_1FG@NHACFNEK@?$AAw?$AAc?$AAs?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AA?5?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA6?$AA4?$AA?5?$AA?$CK?$AA?5?$AA9?$AA?$CJ?$AA?0?$AA?5?$AAL@ 05cd wcsncat_s 05f3 ??_C@_1GG@PKOIFPHI@?$AAw?$AAc?$AAs?$AAn?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AA?5?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA6?$AA4?$AA?5?$AA?$CK?$AA?5?$AA9?$AA?$CJ?$AA?0?$AA?5@ 0639 ??_C@_1FG@PLMFGJFG@?$AAw?$AAc?$AAs?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AA?5?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA6?$AA4?$AA?5?$AA?$CK?$AA?5?$AA9?$AA?$CJ?$AA?0?$AA?5?$AAd@ 0694 ??_C@_1FO@HPHMICDB@?$AAw?$AAc?$AAs?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AA?5?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA6?$AA4?$AA?5?$AA?$CK?$AA?5?$AA9?$AA?$CJ?$AA?0?$AA?5?$AAp@ 0840 ??_C@_1GO@KNIHEHNA@?$AAw?$AAc?$AAs?$AAn?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AA?5?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA6?$AA4?$AA?5?$AA?$CK?$AA?5?$AA9?$AA?$CJ?$AA?0?$AA?5@ 08f6 ??_C@_1HG@FHHFPPED@?$AAw?$AAc?$AAs?$AAn?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AA?5?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA6?$AA4?$AA?5?$AA?$CK?$AA?5?$AA9?$AA?$CJ?$AA?0?$AA?5@ 09db ??_C@_1IC@JGCGJJHO@?$AAw?$AAc?$AAs?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AA?5?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA6?$AA4?$AA?5?$AA?$CK?$AA?5?$AA9?$AA?$CJ?$AA?0?$AA?5?$AAp@ 0a24 ??_C@_1FE@NDOBOCBD@?$AAw?$AAc?$AAs?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AA?5?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA6?$AA4?$AA?5?$AA?$CK?$AA?5?$AA9?$AA?$CJ?$AA?0?$AA?5?$AAf@ 0a78 ??_C@_1O@KCAFKHJE@?$AAL?$AAi?$AAn?$AAe?$AA?3?$AA?5?$AA?$AA@ 0ab0 ??_C@_1FG@HLHNIBH@?$AAw?$AAc?$AAs?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AA?5?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA6?$AA4?$AA?5?$AA?$CK?$AA?5?$AA9?$AA?$CJ?$AA?0?$AA?5?$AAL@ 0b06 _itow_s 0b2c ??_C@_1KG@NJJPHNOK@?$AA_?$AAi?$AAt?$AAo?$AAw?$AA_?$AAs?$AA?$CI?$AA?5?$AAl?$AAi?$AAn?$AAe?$AAn?$AAo?$AA?0?$AA?5?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AAb?$AAu?$AAf?$AA?5?$AA?$CL?$AA?5?$AAw?$AAc?$AAs@ 0b80 ??_C@_1BK@PEDCIPMA@?$AAE?$AAx?$AAp?$AAr?$AAe?$AAs?$AAs?$AAi?$AAo?$AAn?$AA?3?$AA?5?$AA?$AA@ 0bb8 ??_C@_1GC@CFDADAM@?$AAw?$AAc?$AAs?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AA?5?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA6?$AA4?$AA?5?$AA?$CK?$AA?5?$AA9?$AA?$CJ?$AA?0?$AA?5?$AAL@ 0c58 ??_C@_1CHM@HIHGOMKE@?$AAw?$AAc?$AAs?$AAn?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AA?5?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA6?$AA4?$AA?5?$AA?$CK?$AA?5?$AA9?$AA?$CJ?$AA?0?$AA?5@ 0ce7 ??_C@_1EM@DAMJKKKC@?$AAw?$AAc?$AAs?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AA?5?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA6?$AA4?$AA?5?$AA?$CK?$AA?5?$AA9?$AA?$CJ?$AA?0?$AA?5?$AAe@ 0d3b ??_C@_1OA@EGMLFBHJ@?$AAF?$AAo?$AAr?$AA?5?$AAi?$AAn?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AAi?$AAo?$AAn?$AA?5?$AAo?$AAn?$AA?5?$AAh?$AAo?$AAw?$AA?5?$AAy?$AAo?$AAu?$AAr?$AA?5?$AAp?$AAr?$AAo?$AAg@ 0d73 ??_C@_1BCO@GAGHDLIF@?$AAw?$AAc?$AAs?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA6?$AA4?$AA?5?$AA?$CK?$AA?5?$AA9?$AA?$CJ?$AA?0?$AA?5?$AAL?$AA?$CC@ 0db9 ??_C@_1FG@IFIHHMNM@?$AAw?$AAc?$AAs?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA6?$AA4?$AA?5?$AA?$CK?$AA?5?$AA9?$AA?$CJ?$AA?0?$AA?5?$AAd?$AAb@ 0dc7 ??_C@_1HK@POCJMFGK@?$AA?$CI?$AAP?$AAr?$AAe?$AAs?$AAs?$AA?5?$AAR?$AAe?$AAt?$AAr?$AAy?$AA?5?$AAt?$AAo?$AA?5?$AAd?$AAe?$AAb?$AAu?$AAg?$AA?5?$AAt?$AAh?$AAe?$AA?5?$AAa?$AAp?$AAp?$AAl?$AAi?$AAc@ 0dff ??_C@_1LO@CHAFGADE@?$AAw?$AAc?$AAs?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA6?$AA4?$AA?5?$AA?$CK?$AA?5?$AA9?$AA?$CJ?$AA?0?$AA?5?$AAL?$AA?$CC@ 0e13 ??_C@_1EK@MBDPDCGA@?$AAM?$AAi?$AAc?$AAr?$AAo?$AAs?$AAo?$AAf?$AAt?$AA?5?$AAV?$AAi?$AAs?$AAu?$AAa?$AAl?$AA?5?$AAC?$AA?$CL?$AA?$CL?$AA?5?$AAR?$AAu?$AAn?$AAt?$AAi?$AAm?$AAe?$AA?5?$AAL?$AAi?$AAb@ 0e20 __crtMessageBoxW 0e35 raise 0e3f _exit 0e67 __security_check_cookie"
	strings:
		$1 = { 44 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 81 EC C8 0B 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 B0 0B 00 00 B9 03 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 74 1F B9 03 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 85 57 01 00 00 83 3D ?? ?? ?? ?? 01 0F 85 4A 01 00 00 B9 F4 FF FF FF FF 15 ?? ?? ?? ?? 48 89 44 24 58 48 83 7C 24 58 FF 0F 84 96 00 00 00 48 83 7C 24 58 00 0F 84 8A 00 00 00 8B 84 24 E0 0B 00 00 89 44 24 28 48 8B 84 24 D8 0B 00 00 48 89 44 24 20 4C 8B 8C 24 D0 0B 00 00 4C 8D 05 ?? ?? ?? ?? BA 40 02 00 00 48 8D 8C 24 30 07 00 00 E8 ?? ?? ?? ?? 85 C0 7C 4D 48 8B 4C 24 58 FF 15 ?? ?? ?? ?? 83 F8 02 75 3D 48 8D 8C 24 30 07 00 00 E8 ?? ?? ?? ?? 48 C7 44 24 20 00 00 00 00 4C 8D 8C 24 90 00 00 00 44 8B C0 48 8D 94 24 30 07 00 00 48 8B 4C 24 58 FF 15 ?? ?? ?? ?? 85 C0 74 05 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? B9 30 00 00 00 48 6B C9 02 8B 44 08 18 25 0C 01 00 00 85 C0 75 24 E8 ?? ?? ?? ?? B9 30 00 00 00 48 6B C9 02 48 03 C1 45 33 C9 41 B8 04 00 00 00 33 D2 48 8B C8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? B9 30 00 00 00 48 6B C9 02 48 03 C1 8B 8C 24 E0 0B 00 00 89 4C 24 20 4C 8B 8C 24 D8 0B 00 00 4C 8B 84 24 D0 0B 00 00 48 8D 15 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? B9 30 00 00 00 48 6B C9 02 48 03 C1 48 8B C8 E8 ?? ?? ?? ?? E9 B6 0C 00 00 48 C7 44 24 60 00 00 00 00 4C 8D 05 ?? ?? ?? ?? BA 40 02 00 00 48 8D 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 B4 00 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 4C 8B 05 ?? ?? ?? ?? BA 40 02 00 00 48 8D 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 B5 00 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? BA 40 02 00 00 48 8D 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 BA 00 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 48 8B 84 24 C8 0B 00 00 4C 8D 44 24 60 48 8B D0 B9 06 00 00 00 FF 15 ?? ?? ?? ?? 85 C0 75 09 48 C7 44 24 60 00 00 00 00 B8 02 00 00 00 48 69 C0 04 01 00 00 48 89 44 24 68 48 81 7C 24 68 0A 02 00 00 73 02 EB 05 E8 ?? ?? ?? ?? 33 C0 48 8B 4C 24 68 66 89 84 0C 20 05 00 00 41 B8 04 01 00 00 48 8D 94 24 20 05 00 00 48 8B 4C 24 60 FF 15 ?? ?? ?? ?? 85 C0 75 46 4C 8D 05 ?? ?? ?? ?? BA 05 01 00 00 48 8D 8C 24 20 05 00 00 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 CA 00 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 48 8D 84 24 20 05 00 00 48 89 44 24 30 48 8D 8C 24 20 05 00 00 E8 ?? ?? ?? ?? 48 83 C0 0B 48 83 F8 40 0F 86 87 00 00 00 48 8D 8C 24 20 05 00 00 E8 ?? ?? ?? ?? 48 8B 4C 24 30 48 8D 44 41 96 48 89 44 24 30 48 8D 84 24 20 05 00 00 48 8B 4C 24 30 48 2B C8 48 8B C1 48 D1 F8 B9 05 01 00 00 48 2B C8 48 8B C1 48 D1 E0 41 B9 06 00 00 00 4C 8B 05 ?? ?? ?? ?? 48 8B D0 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 D3 00 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 4C 8B 44 24 30 BA 40 02 00 00 48 8D 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 D7 00 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 4C 8B 05 ?? ?? ?? ?? BA 40 02 00 00 48 8D 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 D8 00 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? BA 40 02 00 00 48 8D 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 DD 00 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 48 8B 8C 24 D8 0B 00 00 E8 ?? ?? ?? ?? 48 83 C0 08 48 83 F8 40 0F 86 16 05 00 00 48 8B 84 24 D8 0B 00 00 48 89 44 24 30 48 C7 44 24 40 38 00 00 00 48 8B 8C 24 D8 0B 00 00 E8 ?? ?? ?? ?? 48 89 44 24 48 48 C7 44 24 38 01 00 00 00 EB 0D 48 8B 44 24 38 48 FF C0 48 89 44 24 38 48 8B 44 24 38 48 8B 4C 24 48 48 2B C8 48 8B C1 48 8B 4C 24 30 0F B7 04 41 83 F8 5C 74 2C 48 8B 44 24 38 48 8B 4C 24 48 48 2B C8 48 8B C1 48 8B 4C 24 30 0F B7 04 41 83 F8 2F 74 0E 48 8B 44 24 48 48 39 44 24 38 73 02 EB A9 33 D2 48 8B 44 24 40 B9 03 00 00 00 48 F7 F1 48 8B 4C 24 40 48 2B C8 48 8B C1 48 8B 4C 24 38 48 8B 54 24 48 48 2B D1 48 8B CA 48 3B C1 0F 83 15 01 00 00 33 D2 48 8B 44 24 40 B9 03 00 00 00 48 F7 F1 48 3B 44 24 38 0F 86 FB 00 00 00 48 8B 44 24 40 48 83 E8 03 48 2B 44 24 38 4C 8B C8 4C 8B 44 24 30 BA 40 02 00 00 48 8D 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 F2 00 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 4C 8B 05 ?? ?? ?? ?? BA 40 02 00 00 48 8D 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 F3 00 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8B 4C 24 48 48 8D 04 48 48 8B 4C 24 38 48 D1 E1 48 2B C1 4C 8B C0 BA 40 02 00 00 48 8D 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 F4 00 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? E9 42 03 00 00 33 D2 48 8B 44 24 40 B9 03 00 00 00 48 F7 F1 48 8B 4C 24 40 48 2B C8 48 8B C1 48 8B 4C 24 38 48 8B 54 24 48 48 2B D1 48 8B CA 48 3B C1 0F 86 0F 01 00 00 33 D2 48 8B 44 24 38 B9 02 00 00 00 48 F7 F1 48 89 44 24 38 48 8B 44 24 40 48 83 E8 03 48 2B 44 24 38 4C 8B C8 4C 8B 44 24 30 BA 40 02 00 00 48 8D 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 FC 00 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 4C 8B 05 ?? ?? ?? ?? BA 40 02 00 00 48 8D 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 FD 00 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8B 4C 24 48 48 8D 04 48 48 8B 4C 24 38 48 D1 E1 48 2B C1 4C 8B C0 BA 40 02 00 00 48 8D 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 FE 00 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? E9 00 02 00 00 33 D2 48 8B 44 24 40 B9 03 00 00 00 48 F7 F1 48 8B 4C 24 40 48 2B C8 48 8B C1 48 83 E8 03 4C 8B C8 4C 8B 44 24 30 BA 40 02 00 00 48 8D 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 05 01 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 4C 8B 05 ?? ?? ?? ?? BA 40 02 00 00 48 8D 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 06 01 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 33 D2 48 8B 44 24 40 B9 06 00 00 00 48 F7 F1 48 FF C8 48 8B 4C 24 30 48 8B 54 24 48 48 8D 0C 51 48 8B 54 24 38 48 D1 E2 48 2B CA 4C 8B C8 4C 8B C1 BA 40 02 00 00 48 8D 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 07 01 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 4C 8B 05 ?? ?? ?? ?? BA 40 02 00 00 48 8D 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 08 01 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8B 4C 24 48 48 8D 04 48 48 89 84 24 88 00 00 00 33 D2 48 8B 44 24 40 B9 03 00 00 00 48 F7 F1 48 89 84 24 80 00 00 00 33 D2 48 8B 44 24 40 B9 06 00 00 00 48 F7 F1 48 8B 8C 24 80 00 00 00 48 2B C8 48 8B C1 48 8D 44 00 FC 48 8B 8C 24 88 00 00 00 48 2B C8 48 8B C1 4C 8B C0 BA 40 02 00 00 48 8D 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 09 01 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? EB 47 4C 8B 84 24 D8 0B 00 00 BA 40 02 00 00 48 8D 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 0F 01 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 4C 8B 05 ?? ?? ?? ?? BA 40 02 00 00 48 8D 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 11 01 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? BA 40 02 00 00 48 8D 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 16 01 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 48 8D 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? B9 40 02 00 00 48 2B C8 48 8B C1 48 89 44 24 70 48 8D 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 48 8D 84 44 A0 00 00 00 41 B9 0A 00 00 00 48 8B 4C 24 70 4C 8B C1 48 8B D0 8B 8C 24 E0 0B 00 00 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 17 01 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 4C 8B 05 ?? ?? ?? ?? BA 40 02 00 00 48 8D 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 18 01 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? BA 40 02 00 00 48 8D 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 1D 01 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 48 8D 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 78 48 8B 8C 24 D0 0B 00 00 E8 ?? ?? ?? ?? 48 8B 4C 24 78 48 8D 84 01 B0 00 00 00 48 3D 40 02 00 00 0F 86 B0 00 00 00 48 8D 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 48 05 B3 00 00 00 B9 40 02 00 00 48 2B C8 48 8B C1 4C 8B C8 4C 8B 84 24 D0 0B 00 00 BA 40 02 00 00 48 8D 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 2D 01 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 4C 8B 05 ?? ?? ?? ?? BA 40 02 00 00 48 8D 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 2E 01 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? EB 47 4C 8B 84 24 D0 0B 00 00 BA 40 02 00 00 48 8D 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 31 01 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 4C 8B 05 ?? ?? ?? ?? BA 40 02 00 00 48 8D 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 33 01 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? BA 40 02 00 00 48 8D 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 39 01 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 4C 8B 05 ?? ?? ?? ?? BA 40 02 00 00 48 8D 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 3A 01 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? BA 40 02 00 00 48 8D 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 3F 01 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 41 B8 12 20 01 00 48 8D 15 ?? ?? ?? ?? 48 8D 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 89 44 24 50 83 7C 24 50 03 75 14 B9 16 00 00 00 E8 ?? ?? ?? ?? B9 03 00 00 00 E8 ?? ?? ?? ?? 83 7C 24 50 04 75 03 CC EB 0E 83 7C 24 50 05 75 02 EB 05 E8 ?? ?? ?? ?? 48 8B 8C 24 B0 0B 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 C8 0B 00 00 C3 }
	condition:
		$1
}

rule file_54_2_0 {
	meta:
		name = "swprintf"
		size = 89
		refs = "003f _vswprintf_c_l"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 4C 89 4C 24 20 48 83 EC 48 48 8D 44 24 68 48 89 44 24 38 48 8B 44 24 38 48 89 44 24 20 45 33 C9 4C 8B 44 24 60 48 8B 54 24 58 48 8B 4C 24 50 E8 ?? ?? ?? ?? 89 44 24 30 48 C7 44 24 38 00 00 00 00 8B 44 24 30 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_322_0_0 {
	meta:
		name = "?swprintf@@YAHPEAG_KPEBGZZ"
		size = 89
		refs = "003f ?_vswprintf_l@@YAHPEA_W_KPEB_WPEAUlocaleinfo_struct@@PEAD@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 4C 89 4C 24 20 48 83 EC 48 48 8D 44 24 68 48 89 44 24 38 48 8B 44 24 38 48 89 44 24 20 45 33 C9 4C 8B 44 24 60 48 8B 54 24 58 48 8B 4C 24 50 E8 ?? ?? ?? ?? 89 44 24 30 48 C7 44 24 38 00 00 00 00 8B 44 24 30 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_55_0_0 {
	meta:
		name = "_wchdir"
		size = 717
		refs = "000f __security_cookie 0067 ??_C@_1BO@DPAOGEII@?$AA?$CI?$AAp?$AAa?$AAt?$AAh?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0073 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0088 ??_C@_1GI@CKCOMCBO@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 0092 _CrtDbgReportW 00a6 __doserrno 00b1 _errno 00d4 ??_C@_1BA@PNMFGAMJ@?$AA_?$AAw?$AAc?$AAh?$AAd?$AAi?$AAr?$AA?$AA@ 00e0 _invalid_parameter 00f8 __imp_SetCurrentDirectoryW 0110 __imp_GetCurrentDirectoryW 0135 ??_C@_0DE@DECLBFKJ@f?3?2dd?2vctools?2crt_bld?2self_64_am@ 0148 _calloc_dbg 021d towupper 025b __report_rangecheckfailure 0277 __imp_SetEnvironmentVariableW 0290 __imp_GetLastError 0297 _dosmaperr 02ad _free_dbg 02c1 __security_check_cookie"
	strings:
		$1 = { 48 89 4C 24 08 48 81 EC 88 02 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 70 02 00 00 48 8D 44 24 60 48 89 44 24 38 C7 44 24 44 00 00 00 00 C7 44 24 40 FF FF FF FF 48 83 BC 24 90 02 00 00 00 74 0A C7 44 24 4C 01 00 00 00 EB 08 C7 44 24 4C 00 00 00 00 8B 44 24 4C 89 44 24 48 83 7C 24 48 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 31 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 48 00 75 49 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 31 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 FF FF FF FF E9 C7 01 00 00 48 8B 8C 24 90 02 00 00 FF 15 ?? ?? ?? ?? 85 C0 0F 84 83 01 00 00 48 8B 54 24 38 B9 05 01 00 00 FF 15 ?? ?? ?? ?? 89 44 24 30 81 7C 24 30 04 01 00 00 7E 67 8B 44 24 30 FF C0 48 98 C7 44 24 20 4B 00 00 00 4C 8D 0D ?? ?? ?? ?? 41 B8 02 00 00 00 BA 02 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 48 89 44 24 38 48 83 7C 24 38 00 75 0A C7 44 24 30 00 00 00 00 EB 08 C7 44 24 44 01 00 00 00 83 7C 24 30 00 74 17 8B 44 24 30 FF C0 48 8B 54 24 38 8B C8 FF 15 ?? ?? ?? ?? 89 44 24 30 83 7C 24 30 00 0F 84 F3 00 00 00 B8 02 00 00 00 48 6B C0 00 48 8B 4C 24 38 0F B7 04 01 83 F8 5C 74 17 B8 02 00 00 00 48 6B C0 00 48 8B 4C 24 38 0F B7 04 01 83 F8 2F 75 35 B8 02 00 00 00 48 6B C0 00 48 8B 4C 24 38 0F B7 04 01 B9 02 00 00 00 48 6B C9 01 48 8B 54 24 38 0F B7 0C 0A 3B C1 75 0D C7 44 24 40 00 00 00 00 E9 90 00 00 00 B8 02 00 00 00 48 6B C0 00 B9 3D 00 00 00 66 89 4C 04 58 B8 02 00 00 00 48 6B C0 00 48 8B 4C 24 38 0F B7 0C 01 E8 ?? ?? ?? ?? B9 02 00 00 00 48 6B C9 01 66 89 44 0C 58 B8 02 00 00 00 48 6B C0 02 B9 3A 00 00 00 66 89 4C 04 58 B8 02 00 00 00 48 6B C0 03 48 89 44 24 50 48 83 7C 24 50 08 73 02 EB 05 E8 ?? ?? ?? ?? 33 C0 48 8B 4C 24 50 66 89 44 0C 58 48 8B 54 24 38 48 8D 4C 24 58 FF 15 ?? ?? ?? ?? 85 C0 74 08 C7 44 24 40 00 00 00 00 83 7C 24 40 00 74 0D FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 83 7C 24 44 00 74 0F BA 02 00 00 00 48 8B 4C 24 38 E8 ?? ?? ?? ?? 8B 44 24 40 48 8B 8C 24 70 02 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 88 02 00 00 C3 }
	condition:
		$1
}

rule file_56_0_0 {
	meta:
		name = "rewind"
		size = 429
		refs = "0035 ??_C@_1BM@JMKHIAHP@?$AA?$CI?$AAs?$AAt?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0041 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0056 ??_C@_1GK@GMNJPJGG@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 0060 _CrtDbgReportW 0074 _errno 0097 ??_C@_1O@MIDPMBMH@?$AAr?$AAe?$AAw?$AAi?$AAn?$AAd?$AA?$AA@ 00a3 _invalid_parameter 00ad _ioinit 00ca _fileno 00d8 _lock_file 00e3 _flush 0114 __pioinfo 0137 __badioinfo 0182 _lseek 01a4 _unlock_file"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 58 48 83 7C 24 60 00 74 0A C7 44 24 34 01 00 00 00 EB 08 C7 44 24 34 00 00 00 00 8B 44 24 34 89 44 24 38 83 7C 24 38 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 2A 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 38 00 75 39 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 2A 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 FC 00 00 00 E8 ?? ?? ?? ?? 85 C0 7D 05 E9 EE 00 00 00 48 8B 44 24 60 48 89 44 24 40 48 8B 4C 24 40 E8 ?? ?? ?? ?? 89 44 24 30 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 44 24 40 8B 40 18 83 E0 CF 48 8B 4C 24 40 89 41 18 83 7C 24 30 FF 74 33 83 7C 24 30 FE 74 2C 8B 44 24 30 C1 F8 05 48 98 48 8D 0D ?? ?? ?? ?? 8B 54 24 30 83 E2 1F 48 63 D2 48 6B D2 58 48 03 14 C1 48 8B C2 48 89 44 24 48 EB 0C 48 8D 05 ?? ?? ?? ?? 48 89 44 24 48 48 8B 44 24 48 0F BE 40 08 83 E0 FD 48 8B 4C 24 48 88 41 08 48 8B 44 24 40 8B 40 18 25 80 00 00 00 85 C0 74 13 48 8B 44 24 40 8B 40 18 83 E0 FC 48 8B 4C 24 40 89 41 18 45 33 C0 33 D2 8B 4C 24 30 E8 ?? ?? ?? ?? 83 F8 FF 75 13 48 8B 44 24 40 8B 40 18 83 C8 20 48 8B 4C 24 40 89 41 18 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_58_0_0 {
	meta:
		name = "??0SchedulerPolicy@Concurrency@@QEAA@AEBV01@@Z"
		size = 104
		refs = "0029 ??_C@_0EE@DPLIDMMI@f?3?2dd?2vctools?2crt_bld?2self_64_am@ 0038 ??2@YAPEAX_KV_ConcRTNewMoniker@@PEBDH@Z 0059 ?_Assign@SchedulerPolicy@Concurrency@@AEAAXAEBV12@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 57 48 83 EC 30 48 8D 44 24 20 48 8B F8 33 C0 B9 01 00 00 00 F3 AA 41 B9 80 00 00 00 4C 8D 05 ?? ?? ?? ?? 0F B6 54 24 20 B9 28 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 28 48 8B 44 24 40 48 8B 4C 24 28 48 89 08 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 44 24 40 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_58_1_0 {
	meta:
		name = "??0SchedulerPolicy@Concurrency@@QEAA@XZ"
		size = 34
		refs = "0014 ?_Initialize@SchedulerPolicy@Concurrency@@AEAAX_KPEAPEAD@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 45 33 C0 33 D2 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_58_2_0 {
	meta:
		name = "??0SchedulerPolicy@Concurrency@@QEAA@_KZZ"
		size = 64
		refs = "0032 ?_Initialize@SchedulerPolicy@Concurrency@@AEAAX_KPEAPEAD@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 50 48 89 44 24 20 4C 8D 44 24 20 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_58_3_0 {
	meta:
		name = "??0invalid_scheduler_policy_key@Concurrency@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7invalid_scheduler_policy_key@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_265_11_0 {
	meta:
		name = "??0_Interruption_exception@details@Concurrency@@QEAA@AEBV012@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7_Interruption_exception@details@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_771_0_0 {
	meta:
		name = "??0__non_rtti_object@std@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0bad_typeid@std@@QEAA@AEBV01@@Z 0025 ??_7__non_rtti_object@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_771_1_0 {
	meta:
		name = "??0__non_rtti_object@std@@QEAA@PEBD@Z"
		size = 54
		refs = "0019 ??0bad_typeid@std@@QEAA@PEBD@Z 0025 ??_7__non_rtti_object@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_584_0_0 {
	meta:
		name = "??0bad_alloc@std@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7bad_alloc@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_771_2_0 {
	meta:
		name = "??0bad_cast@std@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7bad_cast@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_637_44_0 {
	meta:
		name = "??0bad_exception@std@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7bad_exception@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_47_32_3 {
	meta:
		name = "??0bad_function_call@std@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7bad_function_call@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_61_403_2 {
	meta:
		name = "??0bad_target@Concurrency@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7bad_target@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_771_4_0 {
	meta:
		name = "??0bad_typeid@std@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7bad_typeid@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_75_55_1 {
	meta:
		name = "??0codecvt_base@std@@QEAA@_K@Z"
		size = 54
		refs = "0019 ??0facet@locale@std@@IEAA@_K@Z 0025 ??_7codecvt_base@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_996_6_0 {
	meta:
		name = "??0context_self_unblock@Concurrency@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7context_self_unblock@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_996_7_0 {
	meta:
		name = "??0context_unblock_unbalanced@Concurrency@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7context_unblock_unbalanced@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_109_88_3 {
	meta:
		name = "??0ctype_base@std@@QEAA@_K@Z"
		size = 54
		refs = "0019 ??0facet@locale@std@@IEAA@_K@Z 0025 ??_7ctype_base@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_439_64_0 {
	meta:
		name = "??0default_scheduler_exists@Concurrency@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7default_scheduler_exists@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_124_23_1 {
	meta:
		name = "??0failure@ios_base@std@@QEAA@AEBV012@@Z"
		size = 54
		refs = "0019 ??0system_error@std@@QEAA@AEBV01@@Z 0025 ??_7failure@ios_base@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_279_18_0 {
	meta:
		name = "??0improper_lock@Concurrency@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7improper_lock@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_439_65_0 {
	meta:
		name = "??0improper_scheduler_attach@Concurrency@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7improper_scheduler_attach@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_439_66_0 {
	meta:
		name = "??0improper_scheduler_detach@Concurrency@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7improper_scheduler_detach@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_439_67_0 {
	meta:
		name = "??0improper_scheduler_reference@Concurrency@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7improper_scheduler_reference@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_47_37_3 {
	meta:
		name = "??0invalid_argument@std@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0logic_error@std@@QEAA@AEBV01@@Z 0025 ??_7invalid_argument@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_61_405_2 {
	meta:
		name = "??0invalid_argument@std@@QEAA@PEBD@Z"
		size = 54
		refs = "0019 ??0logic_error@std@@QEAA@PEBD@Z 0025 ??_7invalid_argument@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_61_406_2 {
	meta:
		name = "??0invalid_link_target@Concurrency@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7invalid_link_target@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_265_25_0 {
	meta:
		name = "??0invalid_multiple_scheduling@Concurrency@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7invalid_multiple_scheduling@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_88_6_0 {
	meta:
		name = "??0invalid_operation@Concurrency@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7invalid_operation@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_996_8_0 {
	meta:
		name = "??0invalid_oversubscribe_operation@Concurrency@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7invalid_oversubscribe_operation@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_58_4_0 {
	meta:
		name = "??0invalid_scheduler_policy_thread_specification@Concurrency@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7invalid_scheduler_policy_thread_specification@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_58_5_0 {
	meta:
		name = "??0invalid_scheduler_policy_value@Concurrency@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7invalid_scheduler_policy_value@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_47_39_3 {
	meta:
		name = "??0length_error@std@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0logic_error@std@@QEAA@AEBV01@@Z 0025 ??_7length_error@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_91_48_3 {
	meta:
		name = "??0length_error@std@@QEAA@PEBD@Z"
		size = 54
		refs = "0019 ??0logic_error@std@@QEAA@PEBD@Z 0025 ??_7length_error@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_10_21_1 {
	meta:
		name = "??0lock_error@threads@stdext@@QEAA@AEBV012@@Z"
		size = 54
		refs = "0019 ??0runtime_error@std@@QEAA@AEBV01@@Z 0025 ??_7lock_error@threads@stdext@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_88_7_0 {
	meta:
		name = "??0logic_error@std@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7logic_error@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_13_410_3 {
	meta:
		name = "??0message_not_found@Concurrency@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7message_not_found@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_92_130_2 {
	meta:
		name = "??0messages_base@std@@QEAA@_K@Z"
		size = 54
		refs = "0019 ??0facet@locale@std@@IEAA@_K@Z 0025 ??_7messages_base@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_265_26_0 {
	meta:
		name = "??0missing_wait@Concurrency@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7missing_wait@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_36_310_2 {
	meta:
		name = "??0money_base@std@@QEAA@_K@Z"
		size = 54
		refs = "0019 ??0facet@locale@std@@IEAA@_K@Z 0025 ??_7money_base@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_491_16_0 {
	meta:
		name = "??0nested_scheduler_missing_detach@Concurrency@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7nested_scheduler_missing_detach@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_13_411_3 {
	meta:
		name = "??0operation_timed_out@Concurrency@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7operation_timed_out@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_47_43_3 {
	meta:
		name = "??0out_of_range@std@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0logic_error@std@@QEAA@AEBV01@@Z 0025 ??_7out_of_range@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_47_44_3 {
	meta:
		name = "??0out_of_range@std@@QEAA@PEBD@Z"
		size = 54
		refs = "0019 ??0logic_error@std@@QEAA@PEBD@Z 0025 ??_7out_of_range@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_30_34_1 {
	meta:
		name = "??0overflow_error@std@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0runtime_error@std@@QEAA@AEBV01@@Z 0025 ??_7overflow_error@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_47_46_3 {
	meta:
		name = "??0overflow_error@std@@QEAA@PEBD@Z"
		size = 54
		refs = "0019 ??0runtime_error@std@@QEAA@PEBD@Z 0025 ??_7overflow_error@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_79_42_1 {
	meta:
		name = "??0range_error@std@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0runtime_error@std@@QEAA@AEBV01@@Z 0025 ??_7range_error@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_91_54_3 {
	meta:
		name = "??0range_error@std@@QEAA@PEBD@Z"
		size = 54
		refs = "0019 ??0runtime_error@std@@QEAA@PEBD@Z 0025 ??_7range_error@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_66_345_3 {
	meta:
		name = "??0runtime_error@std@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7runtime_error@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_199_1_0 {
	meta:
		name = "??0scheduler_not_attached@Concurrency@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7scheduler_not_attached@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_999_4_0 {
	meta:
		name = "??0scheduler_worker_creation_error@Concurrency@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0scheduler_resource_allocation_error@Concurrency@@QEAA@AEBV01@@Z 0025 ??_7scheduler_worker_creation_error@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_84_446_2 {
	meta:
		name = "??0task_canceled@Concurrency@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7task_canceled@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_10_25_1 {
	meta:
		name = "??0thread_resource_error@threads@stdext@@QEAA@AEBV012@@Z"
		size = 54
		refs = "0019 ??0runtime_error@std@@QEAA@AEBV01@@Z 0025 ??_7thread_resource_error@threads@stdext@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_28_258_1 {
	meta:
		name = "??0time_base@std@@QEAA@_K@Z"
		size = 54
		refs = "0019 ??0facet@locale@std@@IEAA@_K@Z 0025 ??_7time_base@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_171_28_0 {
	meta:
		name = "??0unsupported_os@Concurrency@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7unsupported_os@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_58_6_0 {
	meta:
		name = "??1GlobalCore@details@Concurrency@@QEAA@XZ"
		size = 38
		refs = "001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 48 8B 40 28 48 89 44 24 20 48 8B 4C 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_58_7_0 {
	meta:
		name = "??1SchedulerPolicy@Concurrency@@QEAA@XZ"
		size = 37
		refs = "001c ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 48 8B 00 48 89 44 24 20 48 8B 4C 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_268_25_0 {
	meta:
		name = "??1CancellationBeaconNode@CancellationBeaconStack@ContextBase@details@Concurrency@@QEAA@XZ"
		size = 37
		refs = "001c ??_V@YAXPEAX@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 48 8B 00 48 89 44 24 20 48 8B 4C 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_58_8_0 {
	meta:
		name = "??1invalid_scheduler_policy_key@Concurrency@@UEAA@XZ"
		size = 24
		refs = "000f ??1exception@std@@UEAA@XZ"
		altNames = "??1_Interruption_exception@details@Concurrency@@UEAA@XZ ??1bad_function_call@std@@UEAA@XZ ??1bad_target@Concurrency@@UEAA@XZ ??1context_self_unblock@Concurrency@@UEAA@XZ ??1context_unblock_unbalanced@Concurrency@@UEAA@XZ ??1default_scheduler_exists@Concurrency@@UEAA@XZ ??1improper_lock@Concurrency@@UEAA@XZ ??1improper_scheduler_attach@Concurrency@@UEAA@XZ ??1improper_scheduler_detach@Concurrency@@UEAA@XZ ??1improper_scheduler_reference@Concurrency@@UEAA@XZ ??1invalid_link_target@Concurrency@@UEAA@XZ ??1invalid_multiple_scheduling@Concurrency@@UEAA@XZ ??1invalid_operation@Concurrency@@UEAA@XZ ??1invalid_oversubscribe_operation@Concurrency@@UEAA@XZ ??1invalid_scheduler_policy_thread_specification@Concurrency@@UEAA@XZ ??1invalid_scheduler_policy_value@Concurrency@@UEAA@XZ ??1logic_error@std@@UEAA@XZ ??1message_not_found@Concurrency@@UEAA@XZ ??1missing_wait@Concurrency@@UEAA@XZ ??1nested_scheduler_missing_detach@Concurrency@@UEAA@XZ ??1operation_timed_out@Concurrency@@UEAA@XZ ??1runtime_error@std@@UEAA@XZ ??1scheduler_not_attached@Concurrency@@UEAA@XZ ??1scheduler_resource_allocation_error@Concurrency@@UEAA@XZ ??1task_canceled@Concurrency@@UEAA@XZ ??1unsupported_os@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_78_420_1 {
	meta:
		name = "??1?$_Dynamic_array@PEAV?$ISource@W4agent_status@Concurrency@@@Concurrency@@@details@Concurrency@@QEAA@XZ"
		size = 24
		refs = "000f ?_Clear@?$_Dynamic_array@PEAV?$ISource@W4agent_status@Concurrency@@@Concurrency@@@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_78_421_1 {
	meta:
		name = "??1?$_Dynamic_array@PEAV?$ISource@_K@Concurrency@@@details@Concurrency@@QEAA@XZ"
		size = 24
		refs = "000f ?_Clear@?$_Dynamic_array@PEAV?$ISource@_K@Concurrency@@@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_13_422_3 {
	meta:
		name = "??1?$_Dynamic_array@PEAV?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@details@Concurrency@@QEAA@XZ"
		size = 24
		refs = "000f ?_Clear@?$_Dynamic_array@PEAV?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_13_423_3 {
	meta:
		name = "??1?$_Dynamic_array@PEAV?$ITarget@_K@Concurrency@@@details@Concurrency@@QEAA@XZ"
		size = 24
		refs = "000f ?_Clear@?$_Dynamic_array@PEAV?$ITarget@_K@Concurrency@@@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_13_428_3 {
	meta:
		name = "??1?$_Func_class@XAEB_KU_Nil@std@@U12@U12@U12@U12@U12@@std@@QEAA@XZ"
		size = 24
		refs = "000f ?_Tidy@?$_Func_class@XAEB_KU_Nil@std@@U12@U12@U12@U12@U12@@std@@IEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_84_454_2 {
	meta:
		name = "??1?$_Func_class@XEU_Nil@std@@U12@U12@U12@U12@U12@@std@@QEAA@XZ"
		size = 24
		refs = "000f ?_Tidy@?$_Func_class@XEU_Nil@std@@U12@U12@U12@U12@U12@@std@@IEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_13_429_3 {
	meta:
		name = "??1?$_Func_class@XPEAV?$message@W4agent_status@Concurrency@@@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@QEAA@XZ"
		size = 24
		refs = "000f ?_Tidy@?$_Func_class@XPEAV?$message@W4agent_status@Concurrency@@@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@IEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_78_430_1 {
	meta:
		name = "??1?$_Func_class@XPEAV?$message@_K@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@QEAA@XZ"
		size = 24
		refs = "000f ?_Tidy@?$_Func_class@XPEAV?$message@_K@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@IEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_54_488_3 {
	meta:
		name = "??1?$_Func_class@XU?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@U_Nil@2@U32@U32@U32@U32@U32@@std@@QEAA@XZ"
		size = 24
		refs = "000f ?_Tidy@?$_Func_class@XU?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@U_Nil@2@U32@U32@U32@U32@U32@@std@@IEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_78_431_1 {
	meta:
		name = "??1?$_Func_class@XU_Nil@std@@U12@U12@U12@U12@U12@U12@@std@@QEAA@XZ"
		size = 24
		refs = "000f ?_Tidy@?$_Func_class@XU_Nil@std@@U12@U12@U12@U12@U12@U12@@std@@IEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_84_457_2 {
	meta:
		name = "??1?$_Func_class@XV?$task@X@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@QEAA@XZ"
		size = 24
		refs = "000f ?_Tidy@?$_Func_class@XV?$task@X@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@IEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_13_432_3 {
	meta:
		name = "??1?$_Func_class@_NAEBW4agent_status@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@QEAA@XZ"
		size = 24
		refs = "000f ?_Tidy@?$_Func_class@_NAEBW4agent_status@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@IEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_78_433_1 {
	meta:
		name = "??1?$_Func_class@_NAEB_KU_Nil@std@@U12@U12@U12@U12@U12@@std@@QEAA@XZ"
		size = 24
		refs = "000f ?_Tidy@?$_Func_class@_NAEB_KU_Nil@std@@U12@U12@U12@U12@U12@@std@@IEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_109_106_3 {
	meta:
		name = "??1?$_Iterator012@Urandom_access_iterator_tag@std@@D_JPEBDAEBDU_Iterator_base12@2@@std@@QEAA@XZ"
		size = 24
		refs = "000f ??1_Iterator_base12@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_36_314_2 {
	meta:
		name = "??1?$_Iterator012@Urandom_access_iterator_tag@std@@G_JPEBGAEBGU_Iterator_base12@2@@std@@QEAA@XZ"
		size = 24
		refs = "000f ??1_Iterator_base12@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_54_493_3 {
	meta:
		name = "??1?$_Iterator012@Urandom_access_iterator_tag@std@@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@2@_JPEBV32@AEBV32@U_Iterator_base12@2@@std@@QEAA@XZ"
		size = 24
		refs = "000f ??1_Iterator_base12@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_84_461_2 {
	meta:
		name = "??1?$_Iterator012@Urandom_access_iterator_tag@std@@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@2@_JPEBV32@AEBV32@U_Iterator_base12@2@@std@@QEAA@XZ"
		size = 24
		refs = "000f ??1_Iterator_base12@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_66_349_3 {
	meta:
		name = "??1?$_Iterator012@Urandom_access_iterator_tag@std@@_W_JPEB_WAEB_WU_Iterator_base12@2@@std@@QEAA@XZ"
		size = 24
		refs = "000f ??1_Iterator_base12@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_637_53_0 {
	meta:
		name = "??1?$_Ref_count@V__ExceptionPtr@@@std@@UEAA@XZ"
		size = 24
		refs = "000f ??1_Ref_count_base@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_5_355_1 {
	meta:
		name = "??1?$_Ref_count_obj@U_ExceptionHolder@details@Concurrency@@@std@@UEAA@XZ"
		size = 24
		refs = "000f ??1_Ref_count_base@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_85_97_3 {
	meta:
		name = "??1?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ??1?$_Iterator012@Urandom_access_iterator_tag@std@@D_JPEBDAEBDU_Iterator_base12@2@@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_66_355_3 {
	meta:
		name = "??1?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ??1?$_Iterator012@Urandom_access_iterator_tag@std@@G_JPEBGAEBGU_Iterator_base12@2@@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_87_60_2 {
	meta:
		name = "??1?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ??1?$_Iterator012@Urandom_access_iterator_tag@std@@_W_JPEB_WAEB_WU_Iterator_base12@2@@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_49_109_3 {
	meta:
		name = "??1?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ??1?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_36_323_2 {
	meta:
		name = "??1?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ??1?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_36_324_2 {
	meta:
		name = "??1?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ??1?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_95_93_2 {
	meta:
		name = "??1?$_String_val@U?$_Simple_types@D@std@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ??1_Container_base12@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_66_360_3 {
	meta:
		name = "??1?$_String_val@U?$_Simple_types@G@std@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ??1_Container_base12@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_36_327_2 {
	meta:
		name = "??1?$_String_val@U?$_Simple_types@_W@std@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ??1_Container_base12@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_105_477_2 {
	meta:
		name = "??1?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ??1?$_Iterator012@Urandom_access_iterator_tag@std@@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@2@_JPEBV32@AEBV32@U_Iterator_base12@2@@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_105_478_2 {
	meta:
		name = "??1?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ??1?$_Iterator012@Urandom_access_iterator_tag@std@@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@2@_JPEBV32@AEBV32@U_Iterator_base12@2@@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_92_512_3 {
	meta:
		name = "??1?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ??1?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_105_480_2 {
	meta:
		name = "??1?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ??1?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_92_514_3 {
	meta:
		name = "??1?$_Vector_val@U?$_Simple_types@E@std@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ??1_Container_base12@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_105_482_2 {
	meta:
		name = "??1?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ??1_Container_base12@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_54_512_3 {
	meta:
		name = "??1?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ??1_Container_base12@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_105_484_2 {
	meta:
		name = "??1?$_Vector_val@U?$_Simple_types@V_ContextCallback@details@Concurrency@@@std@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ??1_Container_base12@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_85_74_1 {
	meta:
		name = "??1?$_Yarn@D@std@@QEAA@XZ"
		size = 24
		refs = "000f ?_Tidy@?$_Yarn@D@std@@AEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_124_101_3 {
	meta:
		name = "??1?$_Yarn@_W@std@@QEAA@XZ"
		size = 24
		refs = "000f ?_Tidy@?$_Yarn@_W@std@@AEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_105_489_2 {
	meta:
		name = "??1?$shared_ptr@U?$_Task_completion_event_impl@E@details@Concurrency@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ?_Decref@?$_Ptr_base@U?$_Task_completion_event_impl@E@details@Concurrency@@@std@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_105_358_1 {
	meta:
		name = "??1?$shared_ptr@U?$_Task_completion_event_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ?_Decref@?$_Ptr_base@U?$_Task_completion_event_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_5_364_1 {
	meta:
		name = "??1?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ?_Decref@?$_Ptr_base@U?$_Task_impl@E@details@Concurrency@@@std@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_105_360_1 {
	meta:
		name = "??1?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ?_Decref@?$_Ptr_base@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_84_488_2 {
	meta:
		name = "??1?$shared_ptr@U_ExceptionHolder@details@Concurrency@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ?_Decref@?$_Ptr_base@U_ExceptionHolder@details@Concurrency@@@std@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_84_489_2 {
	meta:
		name = "??1?$shared_ptr@U_Task_impl_base@details@Concurrency@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ?_Decref@?$_Ptr_base@U_Task_impl_base@details@Concurrency@@@std@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_637_56_0 {
	meta:
		name = "??1?$shared_ptr@V__ExceptionPtr@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ?_Decref@?$_Ptr_base@V__ExceptionPtr@@@std@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_5_372_1 {
	meta:
		name = "??1?$vector@EV?$allocator@E@std@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ?_Tidy@?$vector@EV?$allocator@E@std@@@std@@IEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_5_373_1 {
	meta:
		name = "??1?$vector@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@2@@std@@QEAA@XZ"
		size = 24
		refs = "000f ?_Tidy@?$vector@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@2@@std@@IEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_5_374_1 {
	meta:
		name = "??1?$vector@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@2@@std@@QEAA@XZ"
		size = 24
		refs = "000f ?_Tidy@?$vector@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@2@@std@@IEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_105_370_1 {
	meta:
		name = "??1?$vector@V_ContextCallback@details@Concurrency@@V?$allocator@V_ContextCallback@details@Concurrency@@@std@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ?_Tidy@?$vector@V_ContextCallback@details@Concurrency@@V?$allocator@V_ContextCallback@details@Concurrency@@@std@@@std@@IEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_439_79_0 {
	meta:
		name = "??1CacheLocalScheduleGroup@details@Concurrency@@UEAA@XZ"
		size = 24
		refs = "000f ??1ScheduleGroupBase@details@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_439_80_0 {
	meta:
		name = "??1CacheLocalScheduleGroupSegment@details@Concurrency@@UEAA@XZ"
		size = 24
		refs = "000f ??1ScheduleGroupSegmentBase@details@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_606_11_0 {
	meta:
		name = "??1CancellationTokenRegistration_TaskProc@@UEAA@XZ"
		size = 24
		refs = "000f ??1_CancellationTokenRegistration@details@Concurrency@@MEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_439_81_0 {
	meta:
		name = "??1FairScheduleGroup@details@Concurrency@@UEAA@XZ"
		size = 24
		refs = "000f ??1ScheduleGroupBase@details@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_439_82_0 {
	meta:
		name = "??1FairScheduleGroupSegment@details@Concurrency@@UEAA@XZ"
		size = 24
		refs = "000f ??1ScheduleGroupSegmentBase@details@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_88_10_0 {
	meta:
		name = "??1FreeVirtualProcessorRoot@details@Concurrency@@UEAA@XZ"
		size = 24
		refs = "000f ??1VirtualProcessorRoot@details@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_439_87_0 {
	meta:
		name = "??1RealizedChore@details@Concurrency@@UEAA@XZ"
		size = 24
		refs = "000f ??1_Chore@details@Concurrency@@MEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_303_6_0 {
	meta:
		name = "??1TimerObj@?6??wait@Concurrency@@YAXI@Z@UEAA@XZ"
		size = 24
		refs = "000f ??1_Timer@details@Concurrency@@MEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_10_104_2 {
	meta:
		name = "??1_Container_base12@std@@QEAA@XZ"
		size = 24
		refs = "000f ?_Orphan_all@_Container_base12@std@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_92_540_3 {
	meta:
		name = "??1_Future_error_category@std@@UEAA@XZ"
		size = 24
		refs = "000f ??1_Generic_error_category@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_85_53_2 {
	meta:
		name = "??1_Generic_error_category@std@@UEAA@XZ"
		size = 24
		refs = "000f ??1error_category@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_87_67_2 {
	meta:
		name = "??1_Iostream_error_category@std@@UEAA@XZ"
		size = 24
		refs = "000f ??1_Generic_error_category@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_5_38_2 {
	meta:
		name = "??1_System_error_category@std@@UEAA@XZ"
		size = 24
		refs = "000f ??1_Generic_error_category@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_84_511_2 {
	meta:
		name = "??1cancellation_token@Concurrency@@QEAA@XZ"
		size = 24
		refs = "000f ?_Clear@cancellation_token@Concurrency@@AEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_5_388_1 {
	meta:
		name = "??1cancellation_token_registration@Concurrency@@QEAA@XZ"
		size = 24
		refs = "000f ?_Clear@cancellation_token_registration@Concurrency@@AEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_105_520_2 {
	meta:
		name = "??1exception_ptr@std@@QEAA@XZ"
		size = 24
		refs = "000f ?__ExceptionPtrDestroy@@YAXPEAX@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_7_92_1 {
	meta:
		name = "??1failure@ios_base@std@@UEAA@XZ"
		size = 24
		refs = "000f ??1system_error@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_105_521_2 {
	meta:
		name = "??1future_error@std@@UEAA@XZ"
		size = 24
		refs = "000f ??1logic_error@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_13_557_3 {
	meta:
		name = "??1invalid_argument@std@@UEAA@XZ"
		size = 24
		refs = "000f ??1logic_error@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_637_61_0 {
	meta:
		name = "??1length_error@std@@UEAA@XZ"
		size = 24
		refs = "000f ??1logic_error@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_55_45_3 {
	meta:
		name = "??1lock_error@threads@stdext@@UEAA@XZ"
		size = 24
		refs = "000f ??1runtime_error@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_28_303_1 {
	meta:
		name = "??1messages_base@std@@UEAA@XZ"
		size = 24
		refs = "000f ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_64_131_1 {
	meta:
		name = "??1money_base@std@@UEAA@XZ"
		size = 24
		refs = "000f ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_47_63_3 {
	meta:
		name = "??1out_of_range@std@@UEAA@XZ"
		size = 24
		refs = "000f ??1logic_error@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_85_63_2 {
	meta:
		name = "??1overflow_error@std@@UEAA@XZ"
		size = 24
		refs = "000f ??1runtime_error@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_79_56_1 {
	meta:
		name = "??1range_error@std@@UEAA@XZ"
		size = 24
		refs = "000f ??1runtime_error@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_30_51_1 {
	meta:
		name = "??1regex_error@std@@UEAA@XZ"
		size = 24
		refs = "000f ??1runtime_error@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_273_73_0 {
	meta:
		name = "??1scheduler_worker_creation_error@Concurrency@@UEAA@XZ"
		size = 24
		refs = "000f ??1scheduler_resource_allocation_error@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_7_96_1 {
	meta:
		name = "??1system_error@std@@UEAA@XZ"
		size = 24
		refs = "000f ??1runtime_error@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_27_46_2 {
	meta:
		name = "??1thread_resource_error@threads@stdext@@UEAA@XZ"
		size = 24
		refs = "000f ??1runtime_error@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_78_565_1 {
	meta:
		name = "??2_AllocBase@details@Concurrency@@SAPEAX_K@Z"
		size = 24
		refs = "000f ?Alloc@Concurrency@@YAPEAX_K@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_61_568_2 {
	meta:
		name = "??3_AllocBase@details@Concurrency@@SAXPEAX@Z"
		size = 24
		refs = "000f ?Free@Concurrency@@YAXPEAX@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_105_547_2 {
	meta:
		name = "??C?$shared_ptr@U?$_Task_completion_event_impl@E@details@Concurrency@@@std@@QEBAPEAU?$_Task_completion_event_impl@E@details@Concurrency@@XZ"
		size = 24
		refs = "000f ?_Get@?$_Ptr_base@U?$_Task_completion_event_impl@E@details@Concurrency@@@std@@QEBAPEAU?$_Task_completion_event_impl@E@details@Concurrency@@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_105_409_1 {
	meta:
		name = "??C?$shared_ptr@U?$_Task_completion_event_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@QEBAPEAU?$_Task_completion_event_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@XZ"
		size = 24
		refs = "000f ?_Get@?$_Ptr_base@U?$_Task_completion_event_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@QEBAPEAU?$_Task_completion_event_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_92_582_3 {
	meta:
		name = "??C?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@QEBAPEAU?$_Task_impl@E@details@Concurrency@@XZ"
		size = 24
		refs = "000f ?_Get@?$_Ptr_base@U?$_Task_impl@E@details@Concurrency@@@std@@QEBAPEAU?$_Task_impl@E@details@Concurrency@@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_105_411_1 {
	meta:
		name = "??C?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@QEBAPEAU?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@XZ"
		size = 24
		refs = "000f ?_Get@?$_Ptr_base@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@QEBAPEAU?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_92_584_3 {
	meta:
		name = "??C?$shared_ptr@U_Task_impl_base@details@Concurrency@@@std@@QEBAPEAU_Task_impl_base@details@Concurrency@@XZ"
		size = 24
		refs = "000f ?_Get@?$_Ptr_base@U_Task_impl_base@details@Concurrency@@@std@@QEBAPEAU_Task_impl_base@details@Concurrency@@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_637_68_0 {
	meta:
		name = "??C?$shared_ptr@V__ExceptionPtr@@@std@@QEBAPEAV__ExceptionPtr@@XZ"
		size = 24
		refs = "000f ?_Get@?$_Ptr_base@V__ExceptionPtr@@@std@@QEBAPEAV__ExceptionPtr@@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_120_143_3 {
	meta:
		name = "??D?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEBAAEADXZ"
		size = 24
		refs = "000f ??D?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEBAAEBDXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_36_408_2 {
	meta:
		name = "??D?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QEBAAEAGXZ"
		size = 24
		refs = "000f ??D?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QEBAAEBGXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_80_80_3 {
	meta:
		name = "??D?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QEBAAEA_WXZ"
		size = 24
		refs = "000f ??D?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QEBAAEB_WXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_92_587_3 {
	meta:
		name = "??D?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@QEBAAEAV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@1@XZ"
		size = 24
		refs = "000f ??D?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@QEBAAEBV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@1@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_84_549_2 {
	meta:
		name = "??D?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@QEBAAEAV?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@1@XZ"
		size = 24
		refs = "000f ??D?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@QEBAAEBV?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@1@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_103_0_3 {
	meta:
		name = "??_U@YAPEAX_K@Z"
		size = 24
		refs = "000f ??2@YAPEAX_K@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_258_0_0 {
	meta:
		name = "??_V@YAXPEAX@Z"
		size = 24
		refs = "000f ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_993_101_0 {
	meta:
		name = "?CheckForDeletionBridge@?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@CAXPEAV123@@Z"
		size = 24
		refs = "000f ?CheckForDeletion@?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@AEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_439_177_0 {
	meta:
		name = "?CheckForDeletionBridge@?$ListArray@VExternalStatistics@details@Concurrency@@@details@Concurrency@@CAXPEAV123@@Z"
		size = 24
		refs = "000f ?CheckForDeletion@?$ListArray@VExternalStatistics@details@Concurrency@@@details@Concurrency@@AEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_439_178_0 {
	meta:
		name = "?CheckForDeletionBridge@?$ListArray@VScheduleGroupBase@details@Concurrency@@@details@Concurrency@@CAXPEAV123@@Z"
		size = 24
		refs = "000f ?CheckForDeletion@?$ListArray@VScheduleGroupBase@details@Concurrency@@@details@Concurrency@@AEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_180_23_0 {
	meta:
		name = "?CheckForDeletionBridge@?$ListArray@VScheduleGroupSegmentBase@details@Concurrency@@@details@Concurrency@@CAXPEAV123@@Z"
		size = 24
		refs = "000f ?CheckForDeletion@?$ListArray@VScheduleGroupSegmentBase@details@Concurrency@@@details@Concurrency@@AEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_321_41_0 {
	meta:
		name = "?CheckForDeletionBridge@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@CAXPEAV123@@Z"
		size = 24
		refs = "000f ?CheckForDeletion@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@AEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_268_74_0 {
	meta:
		name = "?CheckForDeletionBridge@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@CAXPEAV123@@Z"
		size = 24
		refs = "000f ?CheckForDeletion@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@AEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_171_76_0 {
	meta:
		name = "?Count@?$List@VExecutionResource@details@Concurrency@@VCount@CollectionTypes@23@@details@Concurrency@@QEBAHXZ"
		size = 24
		refs = "000f ?Value@Count@CollectionTypes@details@Concurrency@@QEBAHXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_742_14_0 {
	meta:
		name = "?DecodePointer@Security@details@Concurrency@@SAPEAXPEAX@Z"
		size = 24
		refs = "000f ?EncodePointer@Security@details@Concurrency@@SAPEAXPEAX@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1096_47_0 {
	meta:
		name = "?Destroy@WaitAllBlock@details@Concurrency@@UEAAXXZ"
		size = 24
		refs = "000f ?NotifyCompletedNode@MultiWaitBlock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1136_56_0 {
	meta:
		name = "?FromUMSContext@UMSFreeThreadProxy@details@Concurrency@@SAPEAV123@PEAX@Z"
		size = 24
		refs = "000f ?FromUMSContext@UMSThreadProxy@details@Concurrency@@SAPEAV123@PEAX@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_439_314_0 {
	meta:
		name = "?InitializeSchedulerEventHandlers@SchedulerBase@details@Concurrency@@MEAAXXZ"
		size = 24
		refs = "000f ?IncrementInternalContextCount@SchedulerBase@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_268_141_0 {
	meta:
		name = "?InternalSignal@CancellationBeacon@ContextBase@details@Concurrency@@QEAAXXZ"
		size = 24
		refs = "000f ?Raise@CancellationBeacon@ContextBase@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_439_371_0 {
	meta:
		name = "?Reference@ScheduleGroupBase@details@Concurrency@@UEAAIXZ"
		size = 24
		refs = "000f ?InternalReference@ScheduleGroupBase@details@Concurrency@@IEAAJXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_993_181_0 {
	meta:
		name = "?Release@ScheduleGroupBase@details@Concurrency@@UEAAIXZ"
		size = 24
		refs = "000f ?InternalRelease@ScheduleGroupBase@details@Concurrency@@IEAAJXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_439_411_0 {
	meta:
		name = "?SetDefaultSchedulerPolicy@Scheduler@Concurrency@@SAXAEBVSchedulerPolicy@2@@Z"
		size = 24
		refs = "000f ?SetDefaultSchedulerPolicy@SchedulerBase@details@Concurrency@@SAXAEBVSchedulerPolicy@3@@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_993_201_0 {
	meta:
		name = "?_Acquire@_NonReentrantLock@details@Concurrency@@QEAAXXZ"
		size = 24
		refs = "000f ?_DebugAcquire@_NonReentrantLock@details@Concurrency@@AEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_105_655_2 {
	meta:
		name = "?_Cancel@?$task_completion_event@E@Concurrency@@QEBA_NXZ"
		size = 24
		refs = "000f ?_CancelInternal@?$task_completion_event@E@Concurrency@@AEBA_NXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_84_648_2 {
	meta:
		name = "?_Cancel@?$task_completion_event@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@Concurrency@@QEBA_NXZ"
		size = 24
		refs = "000f ?_CancelInternal@?$task_completion_event@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@Concurrency@@AEBA_NXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_265_120_0 {
	meta:
		name = "?_CancelViaToken@_StructuredTaskCollection@details@Concurrency@@CAXPEAV123@@Z"
		size = 24
		refs = "000f ?_Cancel@_StructuredTaskCollection@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_265_121_0 {
	meta:
		name = "?_CancelViaToken@_TaskCollection@details@Concurrency@@CAXPEAV123@@Z"
		size = 24
		refs = "000f ?_Cancel@_TaskCollection@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_265_158_0 {
	meta:
		name = "?_NotificationHandler@_AsyncTaskCollection@details@Concurrency@@AEAAXXZ"
		size = 24
		refs = "000f ?_Release@_RefCounterBase@details@Concurrency@@QEAAJXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_887_28_0 {
	meta:
		name = "?_RethrowException@exception_ptr@std@@QEBAXXZ"
		size = 24
		refs = "000f ?__ExceptionPtrRethrow@@YAXPEBX@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_742_46_0 {
	meta:
		name = "?_TryAcquire@_NonReentrantLock@details@Concurrency@@QEAA_NXZ"
		size = 24
		refs = "000f ?_DebugTryAcquire@_NonReentrantLock@details@Concurrency@@AEAA_NXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_285_7_0 {
	meta:
		name = "?_type_info_dtor_internal_method@type_info@@QEAAXXZ"
		size = 24
		refs = "000f ?_Type_info_dtor_internal@type_info@@CAXPEAV1@@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_40_243_2 {
	meta:
		name = "?c_str@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBAPEBDXZ"
		size = 24
		refs = "000f ?_Myptr@?$_String_val@U?$_Simple_types@D@std@@@std@@QEBAPEBDXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_36_965_2 {
	meta:
		name = "?c_str@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEBAPEBGXZ"
		size = 24
		refs = "000f ?_Myptr@?$_String_val@U?$_Simple_types@G@std@@@std@@QEBAPEBGXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_28_834_1 {
	meta:
		name = "?c_str@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEBAPEB_WXZ"
		size = 24
		refs = "000f ?_Myptr@?$_String_val@U?$_Simple_types@_W@std@@@std@@QEBAPEB_WXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_78_1001_1 {
	meta:
		name = "?count@?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UEAA_KXZ"
		size = 24
		refs = "000f ?_Count@?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@AEBA_KXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_13_1002_3 {
	meta:
		name = "?count@?$multi_link_registry@V?$ISource@_K@Concurrency@@@Concurrency@@UEAA_KXZ"
		size = 24
		refs = "000f ?_Count@?$multi_link_registry@V?$ISource@_K@Concurrency@@@Concurrency@@AEBA_KXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_13_1003_3 {
	meta:
		name = "?count@?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UEAA_KXZ"
		size = 24
		refs = "000f ?_Count@?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@AEBA_KXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_13_1004_3 {
	meta:
		name = "?count@?$multi_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@UEAA_KXZ"
		size = 24
		refs = "000f ?_Count@?$multi_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@AEBA_KXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_13_1023_3 {
	meta:
		name = "?empty@?$concurrent_queue@PEAV?$message@W4agent_status@Concurrency@@@Concurrency@@V?$allocator@PEAV?$message@W4agent_status@Concurrency@@@Concurrency@@@std@@@Concurrency@@QEBA_NXZ"
		size = 24
		refs = "000f ?_Internal_empty@_Concurrent_queue_base_v4@details@Concurrency@@IEBA_NXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_61_1024_2 {
	meta:
		name = "?empty@?$concurrent_queue@PEAV?$message@_K@Concurrency@@V?$allocator@PEAV?$message@_K@Concurrency@@@std@@@Concurrency@@QEBA_NXZ"
		size = 24
		refs = "000f ?_Internal_empty@_Concurrent_queue_base_v4@details@Concurrency@@IEBA_NXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_637_146_0 {
	meta:
		name = "?get@?$shared_ptr@V__ExceptionPtr@@@std@@QEBAPEAV__ExceptionPtr@@XZ"
		size = 24
		refs = "000f ?_Get@?$_Ptr_base@V__ExceptionPtr@@@std@@QEBAPEAV__ExceptionPtr@@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_61_111_1 {
	meta:
		name = "?max_size@?$_Wrap_alloc@V?$allocator@D@std@@@std@@QEBA_KXZ"
		size = 24
		refs = "000f ?max_size@?$allocator_traits@V?$allocator@D@std@@@std@@SA_KAEBV?$allocator@D@2@@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_66_1274_3 {
	meta:
		name = "?max_size@?$_Wrap_alloc@V?$allocator@G@std@@@std@@QEBA_KXZ"
		size = 24
		refs = "000f ?max_size@?$allocator_traits@V?$allocator@G@std@@@std@@SA_KAEBV?$allocator@G@2@@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_54_945_3 {
	meta:
		name = "?max_size@?$_Wrap_alloc@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@QEBA_KXZ"
		size = 24
		refs = "000f ?max_size@?$allocator_traits@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@SA_KAEBV?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@2@@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_84_905_2 {
	meta:
		name = "?max_size@?$_Wrap_alloc@V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@QEBA_KXZ"
		size = 24
		refs = "000f ?max_size@?$allocator_traits@V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@SA_KAEBV?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@2@@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_28_1101_1 {
	meta:
		name = "?max_size@?$_Wrap_alloc@V?$allocator@_W@std@@@std@@QEBA_KXZ"
		size = 24
		refs = "000f ?max_size@?$allocator_traits@V?$allocator@_W@std@@@std@@SA_KAEBV?$allocator@_W@2@@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_39_368_3 {
	meta:
		name = "?max_size@?$allocator_traits@V?$allocator@D@std@@@std@@SA_KAEBV?$allocator@D@2@@Z"
		size = 24
		refs = "000f ?max_size@?$allocator@D@std@@QEBA_KXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_66_1280_3 {
	meta:
		name = "?max_size@?$allocator_traits@V?$allocator@G@std@@@std@@SA_KAEBV?$allocator@G@2@@Z"
		size = 24
		refs = "000f ?max_size@?$allocator@G@std@@QEBA_KXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_92_961_3 {
	meta:
		name = "?max_size@?$allocator_traits@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@SA_KAEBV?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@2@@Z"
		size = 24
		refs = "000f ?max_size@?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@QEBA_KXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_92_962_3 {
	meta:
		name = "?max_size@?$allocator_traits@V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@SA_KAEBV?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@2@@Z"
		size = 24
		refs = "000f ?max_size@?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@QEBA_KXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_80_232_3 {
	meta:
		name = "?max_size@?$allocator_traits@V?$allocator@_W@std@@@std@@SA_KAEBV?$allocator@_W@2@@Z"
		size = 24
		refs = "000f ?max_size@?$allocator@_W@std@@QEBA_KXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_171_232_0 {
	meta:
		name = "?set_task_execution_resources@Concurrency@@YAX_K@Z"
		size = 24
		refs = "000f ?SetTaskExecutionResources@ResourceManager@details@Concurrency@@SAX_K@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_9_0_3 {
	meta:
		name = "_LDtest"
		size = 24
		refs = "000f _Dtest"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_61_6_0 {
	meta:
		name = "__free_locale"
		size = 24
		refs = "000f _free_locale"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1146_35_0 {
	meta:
		name = "_aligned_free"
		size = 24
		refs = "000f _aligned_free_dbg"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_806_0_0 {
	meta:
		name = "_ftime32"
		size = 24
		refs = "000f _ftime32_s"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_89_0_0 {
	meta:
		name = "_ftime64"
		size = 24
		refs = "000f _ftime64_s"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_626_6_0 {
	meta:
		name = "_inc"
		size = 24
		refs = "000f _fgetwc_nolock"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_122_0_0 {
	meta:
		name = "_unlink"
		size = 24
		refs = "000f remove"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1114_0_0 {
	meta:
		name = "_wtoi"
		size = 24
		refs = "000f _wtol"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_528_1_0 {
	meta:
		name = "_wunlink"
		size = 24
		refs = "000f _wremove"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_971_4_0 {
	meta:
		name = "atoi"
		size = 24
		refs = "000f atol"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_62_0_0 {
	meta:
		name = "clearerr"
		size = 24
		refs = "000f clearerr_s"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_266_3_0 {
	meta:
		name = "getwc"
		size = 24
		refs = "000f fgetwc"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_58_11_0 {
	meta:
		name = "??2@YAPEAX_KV_ConcRTNewMoniker@@PEBDH@Z"
		size = 53
		refs = "002c ??2@YAPEAX_KHPEBDH@Z"
	strings:
		$1 = { 44 89 4C 24 20 4C 89 44 24 18 88 54 24 10 48 89 4C 24 08 48 83 EC 28 44 8B 4C 24 48 4C 8B 44 24 40 BA 02 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_491_49_0 {
	meta:
		name = "??_U@YAPEAX_KV_ConcRTNewMoniker@@PEBDH@Z"
		size = 53
		refs = "002c ??_U@YAPEAX_KHPEBDH@Z"
	strings:
		$1 = { 44 89 4C 24 20 4C 89 44 24 18 88 54 24 10 48 89 4C 24 08 48 83 EC 28 44 8B 4C 24 48 4C 8B 44 24 40 BA 02 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_58_12_0 {
	meta:
		name = "??4SchedulerPolicy@Concurrency@@QEAAAEAV01@AEBV01@@Z"
		size = 39
		refs = "0019 ?_Assign@SchedulerPolicy@Concurrency@@AEAAXAEBV12@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_105_209_1 {
	meta:
		name = "??$make_move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@YA?AV?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@0@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@0@@Z"
		size = 39
		refs = "0019 ??0?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@QEAA@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@1@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_105_210_1 {
	meta:
		name = "??$make_move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@YA?AV?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@0@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@0@@Z"
		size = 39
		refs = "0019 ??0?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@QEAA@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@1@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_78_222_1 {
	meta:
		name = "??0?$_Callable_fun@Q6A_NAEBW4agent_status@Concurrency@@@Z$0A@@std@@QEAA@AEBQ6A_NAEBW4agent_status@Concurrency@@@Z@Z"
		size = 39
		refs = "0019 ??$?0AEBQ6A_NAEBW4agent_status@Concurrency@@@Z@?$_Callable_base@Q6A_NAEBW4agent_status@Concurrency@@@Z$0A@@std@@QEAA@AEBQ6A_NAEBW4agent_status@Concurrency@@@Z@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_43_69_3 {
	meta:
		name = "??0?$_Iterator012@Urandom_access_iterator_tag@std@@D_JPEBDAEBDU_Iterator_base12@2@@std@@QEAA@AEBU01@@Z"
		size = 39
		refs = "0019 ??0_Iterator_base12@std@@QEAA@AEBU01@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_36_163_2 {
	meta:
		name = "??0?$_Iterator012@Urandom_access_iterator_tag@std@@G_JPEBGAEBGU_Iterator_base12@2@@std@@QEAA@AEBU01@@Z"
		size = 39
		refs = "0019 ??0_Iterator_base12@std@@QEAA@AEBU01@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_92_377_3 {
	meta:
		name = "??0?$_Iterator012@Urandom_access_iterator_tag@std@@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@2@_JPEBV32@AEBV32@U_Iterator_base12@2@@std@@QEAA@AEBU01@@Z"
		size = 39
		refs = "0019 ??0_Iterator_base12@std@@QEAA@AEBU01@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_92_379_3 {
	meta:
		name = "??0?$_Iterator012@Urandom_access_iterator_tag@std@@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@2@_JPEBV32@AEBV32@U_Iterator_base12@2@@std@@QEAA@AEBU01@@Z"
		size = 39
		refs = "0019 ??0_Iterator_base12@std@@QEAA@AEBU01@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_66_199_3 {
	meta:
		name = "??0?$_Iterator012@Urandom_access_iterator_tag@std@@_W_JPEB_WAEB_WU_Iterator_base12@2@@std@@QEAA@AEBU01@@Z"
		size = 39
		refs = "0019 ??0_Iterator_base12@std@@QEAA@AEBU01@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_92_68_2 {
	meta:
		name = "??0?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEAA@AEBV01@@Z"
		size = 39
		refs = "0019 ??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEAA@AEBV01@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_66_219_3 {
	meta:
		name = "??0?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QEAA@AEBV01@@Z"
		size = 39
		refs = "0019 ??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QEAA@AEBV01@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_80_36_3 {
	meta:
		name = "??0?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QEAA@AEBV01@@Z"
		size = 39
		refs = "0019 ??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QEAA@AEBV01@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_105_367_2 {
	meta:
		name = "??0?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@QEAA@AEBV01@@Z"
		size = 39
		refs = "0019 ??0?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@QEAA@AEBV01@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_105_369_2 {
	meta:
		name = "??0?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@QEAA@AEBV01@@Z"
		size = 39
		refs = "0019 ??0?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@QEAA@AEBV01@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_92_71_2 {
	meta:
		name = "??0?$_Wrap_alloc@V?$allocator@D@std@@@std@@QEAA@AEBV?$allocator@D@1@@Z"
		size = 39
		refs = "0019 ??0?$allocator@D@std@@QEAA@AEBV01@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_36_193_2 {
	meta:
		name = "??0?$_Wrap_alloc@V?$allocator@G@std@@@std@@QEAA@AEBV?$allocator@G@1@@Z"
		size = 39
		refs = "0019 ??0?$allocator@G@std@@QEAA@AEBV01@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_36_195_2 {
	meta:
		name = "??0?$_Wrap_alloc@V?$allocator@_W@std@@@std@@QEAA@AEBV?$allocator@_W@1@@Z"
		size = 39
		refs = "0019 ??0?$allocator@_W@std@@QEAA@AEBV01@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_105_444_2 {
	meta:
		name = "??0exception_ptr@std@@QEAA@AEBV01@@Z"
		size = 39
		refs = "0019 ?__ExceptionPtrCopy@@YAXPEAXPEBX@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_268_20_0 {
	meta:
		name = "??0location@Concurrency@@QEAA@AEBV01@@Z"
		size = 39
		refs = "0019 ?_Assign@location@Concurrency@@QEAAXAEBV12@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_92_171_2 {
	meta:
		name = "??4?$_Iterator012@Urandom_access_iterator_tag@std@@D_JPEBDAEBDU_Iterator_base12@2@@std@@QEAAAEAU01@AEBU01@@Z"
		size = 39
		refs = "0019 ??4_Iterator_base12@std@@QEAAAEAU01@AEBU01@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_36_378_2 {
	meta:
		name = "??4?$_Iterator012@Urandom_access_iterator_tag@std@@G_JPEBGAEBGU_Iterator_base12@2@@std@@QEAAAEAU01@AEBU01@@Z"
		size = 39
		refs = "0019 ??4_Iterator_base12@std@@QEAAAEAU01@AEBU01@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_66_413_3 {
	meta:
		name = "??4?$_Iterator012@Urandom_access_iterator_tag@std@@_W_JPEB_WAEB_WU_Iterator_base12@2@@std@@QEAAAEAU01@AEBU01@@Z"
		size = 39
		refs = "0019 ??4_Iterator_base12@std@@QEAAAEAU01@AEBU01@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_439_121_0 {
	meta:
		name = "??4QuickBitSet@details@Concurrency@@QEAAAEAV012@AEBV012@@Z"
		size = 39
		refs = "0019 ?CopyFrom@QuickBitSet@details@Concurrency@@IEAAXAEBV123@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_993_72_0 {
	meta:
		name = "??4location@Concurrency@@QEAAAEAV01@AEBV01@@Z"
		size = 39
		refs = "0019 ?_Assign@location@Concurrency@@QEAAXAEBV12@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_43_213_3 {
	meta:
		name = "??Y?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEAAAEAV01@_J@Z"
		size = 39
		refs = "0019 ??Y?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEAAAEAV01@_J@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_28_357_1 {
	meta:
		name = "??Y?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QEAAAEAV01@_J@Z"
		size = 39
		refs = "0019 ??Y?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QEAAAEAV01@_J@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_87_82_2 {
	meta:
		name = "??Y?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QEAAAEAV01@_J@Z"
		size = 39
		refs = "0019 ??Y?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QEAAAEAV01@_J@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_54_633_3 {
	meta:
		name = "??Y?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@QEAAAEAV01@_J@Z"
		size = 39
		refs = "0019 ??Y?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@QEAAAEAV01@_J@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_92_640_3 {
	meta:
		name = "??Y?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@QEAAAEAV01@_J@Z"
		size = 39
		refs = "0019 ??Y?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@QEAAAEAV01@_J@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_658_124_0 {
	meta:
		name = "?getVbTableType@UnDecorator@@CA?AVDName@@AEBV2@@Z"
		size = 39
		refs = "0019 ?getVfTableType@UnDecorator@@CA?AVDName@@AEBV2@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_58_13_0 {
	meta:
		name = "??_EGlobalCore@details@Concurrency@@QEAAPEAXI@Z"
		size = 135
		refs = "001b ??1GlobalCore@details@Concurrency@@QEAA@XZ 0033 ??_M@YAXPEAX_KHP6AX0@Z@Z 004f ??_V@YAXPEAX@Z 0079 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 8B 44 24 38 83 E0 02 85 C0 74 46 4C 8D 0D ?? ?? ?? ?? 48 8B 44 24 30 44 8B 40 F8 BA 30 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 11 48 8B 44 24 30 48 83 E8 08 48 8B C8 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 E8 08 EB 24 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_58_14_0 {
	meta:
		name = "??_Ginvalid_scheduler_policy_key@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1invalid_scheduler_policy_key@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_13_619_3 {
	meta:
		name = "??_G?$ISource@W4agent_status@Concurrency@@@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$ISource@W4agent_status@Concurrency@@@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_13_620_3 {
	meta:
		name = "??_G?$ISource@_K@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$ISource@_K@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_13_621_3 {
	meta:
		name = "??_G?$ITarget@W4agent_status@Concurrency@@@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$ITarget@W4agent_status@Concurrency@@@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_61_622_2 {
	meta:
		name = "??_G?$ITarget@_K@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$ITarget@_K@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_63_37_0 {
	meta:
		name = "??_G?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_63_38_0 {
	meta:
		name = "??_G?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_61_623_2 {
	meta:
		name = "??_G?$_AnonymousOriginator@W4agent_status@Concurrency@@@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$_AnonymousOriginator@W4agent_status@Concurrency@@@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_13_624_3 {
	meta:
		name = "??_G?$_AnonymousOriginator@_K@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$_AnonymousOriginator@_K@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_13_625_3 {
	meta:
		name = "??_G?$_Func_base@XAEB_KU_Nil@std@@U12@U12@U12@U12@U12@@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$_Func_base@XAEB_KU_Nil@std@@U12@U12@U12@U12@U12@@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_13_626_3 {
	meta:
		name = "??_G?$_Func_base@XPEAV?$message@W4agent_status@Concurrency@@@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$_Func_base@XPEAV?$message@W4agent_status@Concurrency@@@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_78_627_1 {
	meta:
		name = "??_G?$_Func_base@XPEAV?$message@_K@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$_Func_base@XPEAV?$message@_K@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_54_638_3 {
	meta:
		name = "??_G?$_Func_base@XU_Nil@std@@U12@U12@U12@U12@U12@U12@@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$_Func_base@XU_Nil@std@@U12@U12@U12@U12@U12@U12@@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_61_628_2 {
	meta:
		name = "??_G?$_Func_base@_NAEBW4agent_status@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$_Func_base@_NAEBW4agent_status@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_61_629_2 {
	meta:
		name = "??_G?$_Func_impl@U?$_Callable_fun@Q6A_NAEBW4agent_status@Concurrency@@@Z$0A@@std@@V?$allocator@V?$_Func_class@_NAEBW4agent_status@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@@2@_NAEBW4agent_status@Concurrency@@U_Nil@2@U62@U62@U62@U62@U62@@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$_Func_impl@U?$_Callable_fun@Q6A_NAEBW4agent_status@Concurrency@@@Z$0A@@std@@V?$allocator@V?$_Func_class@_NAEBW4agent_status@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@@2@_NAEBW4agent_status@Concurrency@@U_Nil@2@U62@U62@U62@U62@U62@@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_61_636_2 {
	meta:
		name = "??_G?$_Greedy_node@W4agent_status@Concurrency@@@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$_Greedy_node@W4agent_status@Concurrency@@@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1096_36_0 {
	meta:
		name = "??_G?$_MallocaArrayHolder@PEAVContext@Concurrency@@@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$_MallocaArrayHolder@PEAVContext@Concurrency@@@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_265_46_0 {
	meta:
		name = "??_G?$_MallocaArrayHolder@PEAVevent@Concurrency@@@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$_MallocaArrayHolder@PEAVevent@Concurrency@@@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_64_163_1 {
	meta:
		name = "??_G?$_Mpunct@D@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$_Mpunct@D@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_36_447_2 {
	meta:
		name = "??_G?$_Mpunct@G@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$_Mpunct@G@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_66_482_3 {
	meta:
		name = "??_G?$_Mpunct@_W@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$_Mpunct@_W@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_13_637_3 {
	meta:
		name = "??_G?$_Order_node_base@W4agent_status@Concurrency@@@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$_Order_node_base@W4agent_status@Concurrency@@@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_637_69_0 {
	meta:
		name = "??_G?$_Ref_count@V__ExceptionPtr@@@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$_Ref_count@V__ExceptionPtr@@@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_637_70_0 {
	meta:
		name = "??_G?$_Ref_count_del_alloc@V__ExceptionPtr@@P6AXPEAV1@@ZV?$_DebugMallocator@H@@@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$_Ref_count_del_alloc@V__ExceptionPtr@@P6AXPEAV1@@ZV?$_DebugMallocator@H@@@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_92_646_3 {
	meta:
		name = "??_G?$_Ref_count_obj@U_ExceptionHolder@details@Concurrency@@@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$_Ref_count_obj@U_ExceptionHolder@details@Concurrency@@@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_92_647_3 {
	meta:
		name = "??_G?$_RunAllParam@E@details@Concurrency@@QEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$_RunAllParam@E@details@Concurrency@@QEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_84_608_2 {
	meta:
		name = "??_G?$_RunAnyParam@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@QEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$_RunAnyParam@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@QEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_78_638_1 {
	meta:
		name = "??_G?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_78_639_1 {
	meta:
		name = "??_G?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@_K@Concurrency@@@Concurrency@@@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@_K@Concurrency@@@Concurrency@@@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_78_640_1 {
	meta:
		name = "??_G?$_SyncOriginator@W4agent_status@Concurrency@@@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$_SyncOriginator@W4agent_status@Concurrency@@@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_61_641_2 {
	meta:
		name = "??_G?$_SyncOriginator@_K@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$_SyncOriginator@_K@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_15_108_1 {
	meta:
		name = "??_G?$basic_filebuf@DU?$char_traits@D@std@@@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$basic_filebuf@DU?$char_traits@D@std@@@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_76_129_2 {
	meta:
		name = "??_G?$basic_filebuf@GU?$char_traits@G@std@@@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$basic_filebuf@GU?$char_traits@G@std@@@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_45_146_3 {
	meta:
		name = "??_G?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_89_131_2 {
	meta:
		name = "??_G?$basic_ios@DU?$char_traits@D@std@@@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$basic_ios@DU?$char_traits@D@std@@@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_115_130_2 {
	meta:
		name = "??_G?$basic_ios@GU?$char_traits@G@std@@@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$basic_ios@GU?$char_traits@G@std@@@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_81_108_1 {
	meta:
		name = "??_G?$basic_ios@_WU?$char_traits@_W@std@@@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$basic_ios@_WU?$char_traits@_W@std@@@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_107_111_1 {
	meta:
		name = "??_G?$basic_streambuf@DU?$char_traits@D@std@@@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$basic_streambuf@DU?$char_traits@D@std@@@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_32_132_2 {
	meta:
		name = "??_G?$basic_streambuf@GU?$char_traits@G@std@@@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$basic_streambuf@GU?$char_traits@G@std@@@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_49_149_3 {
	meta:
		name = "??_G?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_78_642_1 {
	meta:
		name = "??_G?$call@_KV?$function@$$A6AXAEB_K@Z@std@@@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$call@_KV?$function@$$A6AXAEB_K@Z@std@@@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_54_134_2 {
	meta:
		name = "??_G?$codecvt@DDH@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$codecvt@DDH@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_76_133_2 {
	meta:
		name = "??_G?$codecvt@GDH@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$codecvt@GDH@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_81_111_1 {
	meta:
		name = "??_G?$codecvt@_WDH@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$codecvt@_WDH@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_64_164_1 {
	meta:
		name = "??_G?$collate@D@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$collate@D@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_66_485_3 {
	meta:
		name = "??_G?$collate@G@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$collate@G@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_66_486_3 {
	meta:
		name = "??_G?$collate@_W@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$collate@_W@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_13_643_3 {
	meta:
		name = "??_G?$concurrent_queue@PEAV?$message@W4agent_status@Concurrency@@@Concurrency@@V?$allocator@PEAV?$message@W4agent_status@Concurrency@@@Concurrency@@@std@@@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$concurrent_queue@PEAV?$message@W4agent_status@Concurrency@@@Concurrency@@V?$allocator@PEAV?$message@W4agent_status@Concurrency@@@Concurrency@@@std@@@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_13_644_3 {
	meta:
		name = "??_G?$concurrent_queue@PEAV?$message@_K@Concurrency@@V?$allocator@PEAV?$message@_K@Concurrency@@@std@@@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$concurrent_queue@PEAV?$message@_K@Concurrency@@V?$allocator@PEAV?$message@_K@Concurrency@@@std@@@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_64_165_1 {
	meta:
		name = "??_G?$ctype@D@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$ctype@D@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_28_372_1 {
	meta:
		name = "??_G?$ctype@G@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$ctype@G@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_40_134_2 {
	meta:
		name = "??_G?$ctype@_W@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$ctype@_W@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_61_645_2 {
	meta:
		name = "??_G?$function@$$A6A_NAEBW4agent_status@Concurrency@@@Z@std@@QEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$function@$$A6A_NAEBW4agent_status@Concurrency@@@Z@std@@QEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_13_646_3 {
	meta:
		name = "??_G?$function@$$A6A_NAEB_K@Z@std@@QEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$function@$$A6A_NAEB_K@Z@std@@QEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_13_647_3 {
	meta:
		name = "??_G?$message@W4agent_status@Concurrency@@@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$message@W4agent_status@Concurrency@@@Concurrency@@UEAA@XZ 0028 ??3_AllocBase@details@Concurrency@@SAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_13_648_3 {
	meta:
		name = "??_G?$message@_K@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$message@_K@Concurrency@@UEAA@XZ 0028 ??3_AllocBase@details@Concurrency@@SAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_64_166_1 {
	meta:
		name = "??_G?$messages@D@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$messages@D@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_36_455_2 {
	meta:
		name = "??_G?$messages@G@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$messages@G@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_36_456_2 {
	meta:
		name = "??_G?$messages@_W@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$messages@_W@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_64_167_1 {
	meta:
		name = "??_G?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_66_491_3 {
	meta:
		name = "??_G?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_66_492_3 {
	meta:
		name = "??_G?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_92_210_2 {
	meta:
		name = "??_G?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_28_378_1 {
	meta:
		name = "??_G?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_36_460_2 {
	meta:
		name = "??_G?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_64_169_1 {
	meta:
		name = "??_G?$moneypunct@D$00@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$moneypunct@D$00@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_92_212_2 {
	meta:
		name = "??_G?$moneypunct@D$0A@@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$moneypunct@D$0A@@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_36_461_2 {
	meta:
		name = "??_G?$moneypunct@G$00@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$moneypunct@G$00@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_66_496_3 {
	meta:
		name = "??_G?$moneypunct@G$0A@@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$moneypunct@G$0A@@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_66_497_3 {
	meta:
		name = "??_G?$moneypunct@_W$00@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$moneypunct@_W$00@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_36_464_2 {
	meta:
		name = "??_G?$moneypunct@_W$0A@@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$moneypunct@_W$0A@@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_78_649_1 {
	meta:
		name = "??_G?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_78_650_1 {
	meta:
		name = "??_G?$multi_link_registry@V?$ISource@_K@Concurrency@@@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$multi_link_registry@V?$ISource@_K@Concurrency@@@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_61_651_2 {
	meta:
		name = "??_G?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_13_652_3 {
	meta:
		name = "??_G?$multi_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$multi_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_100_115_1 {
	meta:
		name = "??_G?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_28_384_1 {
	meta:
		name = "??_G?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_28_385_1 {
	meta:
		name = "??_G?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_39_140_3 {
	meta:
		name = "??_G?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_66_501_3 {
	meta:
		name = "??_G?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_66_502_3 {
	meta:
		name = "??_G?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_100_117_1 {
	meta:
		name = "??_G?$numpunct@D@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$numpunct@D@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_36_469_2 {
	meta:
		name = "??_G?$numpunct@G@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$numpunct@G@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_36_470_2 {
	meta:
		name = "??_G?$numpunct@_W@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$numpunct@_W@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_78_653_1 {
	meta:
		name = "??_G?$ordered_message_processor@W4agent_status@Concurrency@@@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$ordered_message_processor@W4agent_status@Concurrency@@@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_13_654_3 {
	meta:
		name = "??_G?$ordered_message_processor@_K@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$ordered_message_processor@_K@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_61_655_2 {
	meta:
		name = "??_G?$overwrite_buffer@W4agent_status@Concurrency@@@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$overwrite_buffer@W4agent_status@Concurrency@@@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_61_656_2 {
	meta:
		name = "??_G?$propagator_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$propagator_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_13_657_3 {
	meta:
		name = "??_G?$propagator_block@V?$multi_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@_K@Concurrency@@@2@V?$ordered_message_processor@_K@2@@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$propagator_block@V?$multi_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@_K@Concurrency@@@2@V?$ordered_message_processor@_K@2@@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_13_658_3 {
	meta:
		name = "??_G?$propagator_block@V?$single_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@_K@2@@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$propagator_block@V?$single_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@_K@2@@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_54_644_3 {
	meta:
		name = "??_G?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@QEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@QEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_105_475_1 {
	meta:
		name = "??_G?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@QEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@QEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_637_71_0 {
	meta:
		name = "??_G?$shared_ptr@V__ExceptionPtr@@@std@@QEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$shared_ptr@V__ExceptionPtr@@@std@@QEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_13_659_3 {
	meta:
		name = "??_G?$single_assignment@_K@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$single_assignment@_K@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_78_660_1 {
	meta:
		name = "??_G?$single_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$single_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_78_661_1 {
	meta:
		name = "??_G?$single_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$single_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_13_662_3 {
	meta:
		name = "??_G?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_78_663_1 {
	meta:
		name = "??_G?$source_block@V?$multi_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@V?$ordered_message_processor@_K@2@@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$source_block@V?$multi_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@V?$ordered_message_processor@_K@2@@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_78_664_1 {
	meta:
		name = "??_G?$source_block@V?$single_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@V?$ordered_message_processor@_K@2@@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$source_block@V?$single_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@V?$ordered_message_processor@_K@2@@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_13_665_3 {
	meta:
		name = "??_G?$target_block@V?$multi_link_registry@V?$ISource@_K@Concurrency@@@Concurrency@@V?$ordered_message_processor@_K@2@@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$target_block@V?$multi_link_registry@V?$ISource@_K@Concurrency@@@Concurrency@@V?$ordered_message_processor@_K@2@@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_43_224_3 {
	meta:
		name = "??_G?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_36_471_2 {
	meta:
		name = "??_G?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_36_472_2 {
	meta:
		name = "??_G?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_43_225_3 {
	meta:
		name = "??_G?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_36_473_2 {
	meta:
		name = "??_G?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_36_474_2 {
	meta:
		name = "??_G?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_171_48_0 {
	meta:
		name = "??_GAffinityRestriction@ResourceManager@details@Concurrency@@QEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1AffinityRestriction@ResourceManager@details@Concurrency@@QEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_439_127_0 {
	meta:
		name = "??_GCacheLocalScheduleGroup@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1CacheLocalScheduleGroup@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_439_128_0 {
	meta:
		name = "??_GCacheLocalScheduleGroupSegment@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1CacheLocalScheduleGroupSegment@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_996_27_0 {
	meta:
		name = "??_GCancellationBeaconNode@CancellationBeaconStack@ContextBase@details@Concurrency@@QEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1CancellationBeaconNode@CancellationBeaconStack@ContextBase@details@Concurrency@@QEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_606_23_0 {
	meta:
		name = "??_GCancellationTokenRegistration_TaskProc@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1CancellationTokenRegistration_TaskProc@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_996_28_0 {
	meta:
		name = "??_GContext@Concurrency@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1Context@Concurrency@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_268_49_0 {
	meta:
		name = "??_GContextBase@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1ContextBase@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1003_21_0 {
	meta:
		name = "??_GExecutionResource@details@Concurrency@@QEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1ExecutionResource@details@Concurrency@@QEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_996_29_0 {
	meta:
		name = "??_GExternalContextBase@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1ExternalContextBase@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_439_129_0 {
	meta:
		name = "??_GFairScheduleGroup@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1FairScheduleGroup@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_439_130_0 {
	meta:
		name = "??_GFairScheduleGroupSegment@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1FairScheduleGroupSegment@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_63_39_0 {
	meta:
		name = "??_GFreeThreadProxy@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1FreeThreadProxy@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_63_40_0 {
	meta:
		name = "??_GFreeThreadProxyFactory@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1FreeThreadProxyFactory@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_88_20_0 {
	meta:
		name = "??_GFreeVirtualProcessorRoot@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1FreeVirtualProcessorRoot@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_63_41_0 {
	meta:
		name = "??_GIThreadProxyFactory@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1IThreadProxyFactory@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_491_41_0 {
	meta:
		name = "??_GInternalContextBase@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1InternalContextBase@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_439_131_0 {
	meta:
		name = "??_GRealizedChore@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1RealizedChore@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_171_49_0 {
	meta:
		name = "??_GResourceManager@details@Concurrency@@AEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1ResourceManager@details@Concurrency@@AEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_439_132_0 {
	meta:
		name = "??_GScheduleGroup@Concurrency@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1ScheduleGroup@Concurrency@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_439_133_0 {
	meta:
		name = "??_GScheduleGroupBase@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1ScheduleGroupBase@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_993_79_0 {
	meta:
		name = "??_GScheduleGroupSegmentBase@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1ScheduleGroupSegmentBase@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_439_134_0 {
	meta:
		name = "??_GScheduler@Concurrency@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1Scheduler@Concurrency@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_439_135_0 {
	meta:
		name = "??_GSchedulerBase@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1SchedulerBase@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_439_136_0 {
	meta:
		name = "??_GSchedulerPolicy@Concurrency@@QEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1SchedulerPolicy@Concurrency@@QEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1003_22_0 {
	meta:
		name = "??_GSchedulerProxy@details@Concurrency@@IEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1SchedulerProxy@details@Concurrency@@IEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_439_137_0 {
	meta:
		name = "??_GSchedulingNode@details@Concurrency@@QEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1SchedulingNode@details@Concurrency@@QEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_439_138_0 {
	meta:
		name = "??_GSchedulingRing@details@Concurrency@@QEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1SchedulingRing@details@Concurrency@@QEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_67_28_0 {
	meta:
		name = "??_GSegment@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1Segment@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_268_50_0 {
	meta:
		name = "??_GSegment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1Segment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_439_139_0 {
	meta:
		name = "??_GSubAllocator@details@Concurrency@@QEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1SubAllocator@details@Concurrency@@QEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_265_47_0 {
	meta:
		name = "??_GTaskStack@details@Concurrency@@QEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1TaskStack@details@Concurrency@@QEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1076_14_0 {
	meta:
		name = "??_GThreadInternalContext@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1ThreadInternalContext@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_999_10_0 {
	meta:
		name = "??_GThreadProxy@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1ThreadProxy@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1076_15_0 {
	meta:
		name = "??_GThreadScheduler@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1ThreadScheduler@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_192_5_0 {
	meta:
		name = "??_GThreadVirtualProcessor@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1ThreadVirtualProcessor@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_303_10_0 {
	meta:
		name = "??_GTimerObj@?6??wait@Concurrency@@YAXI@Z@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1TimerObj@?6??wait@Concurrency@@YAXI@Z@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1091_15_0 {
	meta:
		name = "??_GTransmogrifiedPrimary@details@Concurrency@@QEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1TransmogrifiedPrimary@details@Concurrency@@QEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_63_42_0 {
	meta:
		name = "??_GUMSFreeThreadProxy@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1UMSFreeThreadProxy@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_63_43_0 {
	meta:
		name = "??_GUMSFreeThreadProxyFactory@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1UMSFreeThreadProxyFactory@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1136_31_0 {
	meta:
		name = "??_GUMSFreeVirtualProcessorRoot@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1UMSFreeVirtualProcessorRoot@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1136_32_0 {
	meta:
		name = "??_GUMSSchedulerProxy@details@Concurrency@@QEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1UMSSchedulerProxy@details@Concurrency@@QEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_726_11_0 {
	meta:
		name = "??_GUMSSchedulingContext@details@Concurrency@@QEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1UMSSchedulingContext@details@Concurrency@@QEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_87_9_0 {
	meta:
		name = "??_GUMSThreadInternalContext@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1UMSThreadInternalContext@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_86_13_0 {
	meta:
		name = "??_GUMSThreadProxy@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1UMSThreadProxy@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_338_14_0 {
	meta:
		name = "??_GUMSThreadScheduler@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1UMSThreadScheduler@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_726_12_0 {
	meta:
		name = "??_GUMSThreadVirtualProcessor@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1UMSThreadVirtualProcessor@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_321_29_0 {
	meta:
		name = "??_GVirtualProcessor@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1VirtualProcessor@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1136_33_0 {
	meta:
		name = "??_GVirtualProcessorRoot@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1VirtualProcessorRoot@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_993_81_0 {
	meta:
		name = "??_GWorkQueue@details@Concurrency@@QEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1WorkQueue@details@Concurrency@@QEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_265_48_0 {
	meta:
		name = "??_G_AsyncTaskCollection@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1_AsyncTaskCollection@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_61_666_2 {
	meta:
		name = "??_G_Blocking_recipient@?1???$_Receive_impl@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@1@PEAV?$ISource@W4agent_status@Concurrency@@@1@IPEBV?$function@$$A6A_NAEBW4agent_status@Concurrency@@@Z@std@@@Z@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1_Blocking_recipient@?1???$_Receive_impl@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@1@PEAV?$ISource@W4agent_status@Concurrency@@@1@IPEBV?$function@$$A6A_NAEBW4agent_status@Concurrency@@@Z@std@@@Z@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_61_667_2 {
	meta:
		name = "??_G_Blocking_recipient@?1???$_Receive_impl@_K@Concurrency@@YA_KPEAV?$ISource@_K@1@IPEBV?$function@$$A6A_NAEB_K@Z@std@@@Z@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1_Blocking_recipient@?1???$_Receive_impl@_K@Concurrency@@YA_KPEAV?$ISource@_K@1@IPEBV?$function@$$A6A_NAEB_K@Z@std@@@Z@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_105_476_1 {
	meta:
		name = "??_G_CancellationTokenRegistration@details@Concurrency@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1_CancellationTokenRegistration@details@Concurrency@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_606_25_0 {
	meta:
		name = "??_G_CancellationTokenState@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1_CancellationTokenState@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_439_140_0 {
	meta:
		name = "??_G_Chore@details@Concurrency@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1_Chore@details@Concurrency@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_109_38_1 {
	meta:
		name = "??_G_Concurrent_queue_base_v4@details@Concurrency@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1_Concurrent_queue_base_v4@details@Concurrency@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_61_1_3 {
	meta:
		name = "??_G_Condition_variable@details@Concurrency@@QEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1_Condition_variable@details@Concurrency@@QEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_92_652_3 {
	meta:
		name = "??_G_ExceptionHolder@details@Concurrency@@QEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1_ExceptionHolder@details@Concurrency@@QEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_536_5_5 {
	meta:
		name = "??_G_Fac_node@std@@QEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1_Fac_node@std@@QEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_46_135_2 {
	meta:
		name = "??_G_Facet_base@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1_Facet_base@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_105_618_2 {
	meta:
		name = "??_G_Future_error_category@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1_Future_error_category@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_15_115_1 {
	meta:
		name = "??_G_Generic_error_category@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1_Generic_error_category@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_705_8_0 {
	meta:
		name = "??_G_Interruption_exception@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1_Interruption_exception@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_3_68_3 {
	meta:
		name = "??_G_Iostream_error_category@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1_Iostream_error_category@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_23_68_2 {
	meta:
		name = "??_G_Locimp@locale@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1_Locimp@locale@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_105_621_2 {
	meta:
		name = "??_G_RefCounterBase@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1_RefCounterBase@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_84_616_2 {
	meta:
		name = "??_G_Ref_count_base@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1_Ref_count_base@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_124_138_2 {
	meta:
		name = "??_G_System_error_category@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1_System_error_category@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_268_52_0 {
	meta:
		name = "??_G_TaskCollection@details@Concurrency@@QEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1_TaskCollection@details@Concurrency@@QEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_92_659_3 {
	meta:
		name = "??_G_TaskProcThunk@details@Concurrency@@QEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1_TaskProcThunk@details@Concurrency@@QEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_303_11_0 {
	meta:
		name = "??_G_Timer@details@Concurrency@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1_Timer@details@Concurrency@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_637_73_0 {
	meta:
		name = "??_G__ExceptionPtr@@QEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1__ExceptionPtr@@QEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_771_15_0 {
	meta:
		name = "??_G__non_rtti_object@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1__non_rtti_object@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_78_668_1 {
	meta:
		name = "??_Gagent@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1agent@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_30_60_1 {
	meta:
		name = "??_Gbad_alloc@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1bad_alloc@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_771_16_0 {
	meta:
		name = "??_Gbad_cast@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1bad_cast@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_637_75_0 {
	meta:
		name = "??_Gbad_exception@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1bad_exception@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_47_75_3 {
	meta:
		name = "??_Gbad_function_call@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1bad_function_call@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_78_669_1 {
	meta:
		name = "??_Gbad_target@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1bad_target@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_771_17_0 {
	meta:
		name = "??_Gbad_typeid@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1bad_typeid@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_89_140_2 {
	meta:
		name = "??_Gcodecvt_base@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1codecvt_base@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_491_42_0 {
	meta:
		name = "??_Gcontext_self_unblock@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1context_self_unblock@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_491_43_0 {
	meta:
		name = "??_Gcontext_unblock_unbalanced@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1context_unblock_unbalanced@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_5_50_2 {
	meta:
		name = "??_Gcritical_section@Concurrency@@QEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1critical_section@Concurrency@@QEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_92_219_2 {
	meta:
		name = "??_Gctype_base@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1ctype_base@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_439_141_0 {
	meta:
		name = "??_Gdefault_scheduler_exists@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1default_scheduler_exists@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_23_70_2 {
	meta:
		name = "??_Gerror_category@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1error_category@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_771_18_0 {
	meta:
		name = "??_Gexception@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1exception@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_887_7_0 {
	meta:
		name = "??_Gexception_ptr@std@@QEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1exception_ptr@std@@QEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_100_125_1 {
	meta:
		name = "??_Gfacet@locale@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1facet@locale@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_32_143_2 {
	meta:
		name = "??_Gfailure@ios_base@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1failure@ios_base@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_105_626_2 {
	meta:
		name = "??_Gfuture_error@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1future_error@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_273_82_0 {
	meta:
		name = "??_Gimproper_lock@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1improper_lock@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_439_142_0 {
	meta:
		name = "??_Gimproper_scheduler_attach@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1improper_scheduler_attach@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_439_143_0 {
	meta:
		name = "??_Gimproper_scheduler_detach@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1improper_scheduler_detach@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_439_144_0 {
	meta:
		name = "??_Gimproper_scheduler_reference@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1improper_scheduler_reference@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_85_76_2 {
	meta:
		name = "??_Ginvalid_argument@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1invalid_argument@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_13_671_3 {
	meta:
		name = "??_Ginvalid_link_target@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1invalid_link_target@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_265_54_0 {
	meta:
		name = "??_Ginvalid_multiple_scheduling@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1invalid_multiple_scheduling@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_273_88_0 {
	meta:
		name = "??_Ginvalid_operation@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1invalid_operation@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_273_89_0 {
	meta:
		name = "??_Ginvalid_oversubscribe_operation@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1invalid_oversubscribe_operation@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_273_91_0 {
	meta:
		name = "??_Ginvalid_scheduler_policy_thread_specification@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1invalid_scheduler_policy_thread_specification@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_273_92_0 {
	meta:
		name = "??_Ginvalid_scheduler_policy_value@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1invalid_scheduler_policy_value@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_22_161_3 {
	meta:
		name = "??_Gios_base@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1ios_base@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_91_87_3 {
	meta:
		name = "??_Glength_error@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1length_error@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_71_123_1 {
	meta:
		name = "??_Glocale@std@@QEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1locale@std@@QEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_55_56_3 {
	meta:
		name = "??_Glock_error@threads@stdext@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1lock_error@threads@stdext@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_91_87_2 {
	meta:
		name = "??_Glogic_error@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1logic_error@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_61_674_2 {
	meta:
		name = "??_Gmessage_not_found@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1message_not_found@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_92_222_2 {
	meta:
		name = "??_Gmessages_base@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1messages_base@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_265_55_0 {
	meta:
		name = "??_Gmissing_wait@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1missing_wait@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_66_518_3 {
	meta:
		name = "??_Gmoney_base@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1money_base@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_491_47_0 {
	meta:
		name = "??_Gnested_scheduler_missing_detach@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1nested_scheduler_missing_detach@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_273_96_0 {
	meta:
		name = "??_Goperation_timed_out@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1operation_timed_out@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_91_89_3 {
	meta:
		name = "??_Gout_of_range@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1out_of_range@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_30_67_1 {
	meta:
		name = "??_Goverflow_error@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1overflow_error@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_91_89_2 {
	meta:
		name = "??_Grange_error@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1range_error@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_85_81_2 {
	meta:
		name = "??_Gregex_error@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1regex_error@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_35_65_2 {
	meta:
		name = "??_Gruntime_error@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1runtime_error@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_273_97_0 {
	meta:
		name = "??_Gscheduler_not_attached@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1scheduler_not_attached@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_317_20_0 {
	meta:
		name = "??_Gscheduler_resource_allocation_error@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1scheduler_resource_allocation_error@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_273_99_0 {
	meta:
		name = "??_Gscheduler_worker_creation_error@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1scheduler_worker_creation_error@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_57_67_3 {
	meta:
		name = "??_Gsystem_error@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1system_error@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_54_656_3 {
	meta:
		name = "??_Gtask_canceled@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1task_canceled@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_55_58_3 {
	meta:
		name = "??_Gthread_resource_error@threads@stdext@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1thread_resource_error@threads@stdext@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_92_225_2 {
	meta:
		name = "??_Gtime_base@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1time_base@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_285_5_0 {
	meta:
		name = "??_Gtype_info@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1type_info@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_273_101_0 {
	meta:
		name = "??_Gunsupported_os@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1unsupported_os@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_58_17_0 {
	meta:
		name = "??_H@YAXPEAX_KHP6APEAX0@Z@Z"
		size = 78
	strings:
		$1 = { 4C 89 4C 24 20 44 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 8B 44 24 40 FF C8 89 44 24 40 83 7C 24 40 00 7C 20 48 8B 4C 24 30 FF 54 24 48 48 8B 44 24 38 48 8B 4C 24 30 48 03 C8 48 8B C1 48 89 44 24 30 EB CF 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_58_18_0 {
	meta:
		name = "??__Eallocator_arg@std@@YAXXZ"
		size = 28
		altNames = "??__E_10@placeholders@std@@YAXXZ ??__E_11@placeholders@std@@YAXXZ ??__E_12@placeholders@std@@YAXXZ ??__E_13@placeholders@std@@YAXXZ ??__E_14@placeholders@std@@YAXXZ ??__E_15@placeholders@std@@YAXXZ ??__E_16@placeholders@std@@YAXXZ ??__E_17@placeholders@std@@YAXXZ ??__E_18@placeholders@std@@YAXXZ ??__E_19@placeholders@std@@YAXXZ ??__E_1@placeholders@std@@YAXXZ ??__E_20@placeholders@std@@YAXXZ ??__E_2@placeholders@std@@YAXXZ ??__E_3@placeholders@std@@YAXXZ ??__E_4@placeholders@std@@YAXXZ ??__E_5@placeholders@std@@YAXXZ ??__E_6@placeholders@std@@YAXXZ ??__E_7@placeholders@std@@YAXXZ ??__E_8@placeholders@std@@YAXXZ ??__E_9@placeholders@std@@YAXXZ ??__E_Tuple_alloc@std@@YAXXZ ??__Eadopt_lock@std@@YAXXZ ??__Edefer_lock@std@@YAXXZ ??__Enothrow@std@@YAXXZ ??__Epiecewise_construct@std@@YAXXZ ??__Etry_to_lock@std@@YAXXZ"
	strings:
		$1 = { 40 57 48 83 EC 10 48 8D 04 24 48 8B F8 33 C0 B9 01 00 00 00 F3 AA 48 83 C4 10 5F C3 }
	condition:
		$1
}

rule file_58_20_0 {
	meta:
		name = "?GetPolicyValue@SchedulerPolicy@Concurrency@@QEBAIW4PolicyElementKey@2@@Z"
		size = 89
		refs = "0012 ?_ValidPolicyKey@SchedulerPolicy@Concurrency@@CA_NW4PolicyElementKey@2@@Z 0022 ?_StringFromPolicyKey@SchedulerPolicy@Concurrency@@CAPEADI@Z 002f ??0invalid_scheduler_policy_key@Concurrency@@QEAA@PEBD@Z 0036 _TI2?AVinvalid_scheduler_policy_key@Concurrency@@ 0040 _CxxThrowException"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 48 8B 4C 24 58 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 27 8B 4C 24 58 E8 ?? ?? ?? ?? 48 8B D0 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 8B 00 48 63 4C 24 58 8B 04 88 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_58_21_0 {
	meta:
		name = "?SetConcurrencyLimits@SchedulerPolicy@Concurrency@@QEAAXII@Z"
		size = 330
		refs = "0022 ?_ValidPolicyValue@SchedulerPolicy@Concurrency@@CA_NW4PolicyElementKey@2@I@Z 0033 ?_StringFromPolicyKey@SchedulerPolicy@Concurrency@@CAPEADI@Z 0040 ??0invalid_scheduler_policy_value@Concurrency@@QEAA@PEBD@Z 0047 _TI2?AVinvalid_scheduler_policy_value@Concurrency@@ 0051 _CxxThrowException 00a4 ?_AreConcurrencyLimitsValid@SchedulerPolicy@Concurrency@@CA_NII@Z 00b5 ??0invalid_scheduler_policy_thread_specification@Concurrency@@QEAA@XZ 00bc _TI2?AVinvalid_scheduler_policy_thread_specification@Concurrency@@ 00d3 ?_ArePolicyCombinationsValid@SchedulerPolicy@Concurrency@@AEBA_NXZ 00e4 ??0invalid_scheduler_policy_value@Concurrency@@QEAA@XZ 013e ?_ResolvePolicyValues@SchedulerPolicy@Concurrency@@AEAAXXZ"
	strings:
		$1 = { 44 89 44 24 18 89 54 24 10 48 89 4C 24 08 48 81 EC 88 00 00 00 8B 94 24 A0 00 00 00 B9 01 00 00 00 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 28 B9 01 00 00 00 E8 ?? ?? ?? ?? 48 8B D0 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 20 E8 ?? ?? ?? ?? 8B 94 24 98 00 00 00 B9 02 00 00 00 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 28 B9 02 00 00 00 E8 ?? ?? ?? ?? 48 8B D0 48 8D 4C 24 38 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8B 94 24 A0 00 00 00 8B 8C 24 98 00 00 00 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 1B 48 8D 4C 24 50 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 50 E8 ?? ?? ?? ?? 48 8B 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 1B 48 8D 4C 24 68 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 68 E8 ?? ?? ?? ?? 48 8B 84 24 90 00 00 00 48 8B 00 B9 04 00 00 00 48 6B C9 01 8B 94 24 A0 00 00 00 89 14 08 48 8B 84 24 90 00 00 00 48 8B 00 B9 04 00 00 00 48 6B C9 02 8B 94 24 98 00 00 00 89 14 08 48 8B 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 88 00 00 00 C3 }
	condition:
		$1
}

rule file_58_22_0 {
	meta:
		name = "?SetPolicyValue@SchedulerPolicy@Concurrency@@QEAAIW4PolicyElementKey@2@I@Z"
		size = 209
		refs = "0017 ?_ValidPolicyKey@SchedulerPolicy@Concurrency@@CA_NW4PolicyElementKey@2@@Z 0035 ?_StringFromPolicyKey@SchedulerPolicy@Concurrency@@CAPEADI@Z 0042 ??0invalid_scheduler_policy_key@Concurrency@@QEAA@PEBD@Z 0049 _TI2?AVinvalid_scheduler_policy_key@Concurrency@@ 0053 _CxxThrowException 0063 ?_ValidPolicyValue@SchedulerPolicy@Concurrency@@CA_NW4PolicyElementKey@2@I@Z 0080 ??0invalid_scheduler_policy_value@Concurrency@@QEAA@PEBD@Z 0087 _TI2?AVinvalid_scheduler_policy_value@Concurrency@@ 009f ?GetPolicyValue@SchedulerPolicy@Concurrency@@QEBAIW4PolicyElementKey@2@@Z 00c4 ?_ResolvePolicyValues@SchedulerPolicy@Concurrency@@AEAAXXZ"
	strings:
		$1 = { 44 89 44 24 18 89 54 24 10 48 89 4C 24 08 48 83 EC 68 8B 4C 24 78 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 0E 83 7C 24 78 02 74 07 83 7C 24 78 01 75 27 8B 4C 24 78 E8 ?? ?? ?? ?? 48 8B D0 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 28 E8 ?? ?? ?? ?? 8B 94 24 80 00 00 00 8B 4C 24 78 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 27 8B 4C 24 78 E8 ?? ?? ?? ?? 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 40 E8 ?? ?? ?? ?? 8B 54 24 78 48 8B 4C 24 70 E8 ?? ?? ?? ?? 89 44 24 20 48 8B 44 24 70 48 8B 00 48 63 4C 24 78 8B 94 24 80 00 00 00 89 14 88 48 8B 4C 24 70 E8 ?? ?? ?? ?? 8B 44 24 20 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_58_23_0 {
	meta:
		name = "?_AreConcurrencyLimitsValid@SchedulerPolicy@Concurrency@@AEBA_NXZ"
		size = 61
		refs = "0014 ?GetPolicyValue@SchedulerPolicy@Concurrency@@QEBAIW4PolicyElementKey@2@@Z 0034 ?_AreConcurrencyLimitsValid@SchedulerPolicy@Concurrency@@CA_NII@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 BA 01 00 00 00 48 8B 4C 24 40 E8 ?? ?? ?? ?? 89 44 24 20 BA 02 00 00 00 48 8B 4C 24 40 E8 ?? ?? ?? ?? 8B 4C 24 20 8B D1 8B C8 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_58_24_0 {
	meta:
		name = "?_AreConcurrencyLimitsValid@SchedulerPolicy@Concurrency@@CA_NII@Z"
		size = 40
	strings:
		$1 = { 89 54 24 10 89 4C 24 08 83 7C 24 10 FF 74 15 83 7C 24 08 FF 74 0E 8B 44 24 08 39 44 24 10 73 04 32 C0 EB 02 B0 01 F3 C3 }
	condition:
		$1
}

rule file_58_26_0 {
	meta:
		name = "?_Assign@SchedulerPolicy@Concurrency@@AEAAXAEBV12@@Z"
		size = 57
		refs = "0030 memcpy"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 28 00 00 00 48 8B 44 24 48 48 8B 00 48 8B 4C 24 40 48 8B 09 4C 8B 44 24 20 48 8B D0 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_58_27_0 {
	meta:
		name = "?_Initialize@SchedulerPolicy@Concurrency@@AEAAX_KPEAPEAD@Z"
		size = 710
		refs = "0043 ??_C@_0EE@DPLIDMMI@f?3?2dd?2vctools?2crt_bld?2self_64_am@ 0052 ??2@YAPEAX_KV_ConcRTNewMoniker@@PEBDH@Z 0082 ?PolicyDefaults@details@Concurrency@@3PAIA 008a memcpy 0194 ?_ValidPolicyKey@SchedulerPolicy@Concurrency@@CA_NW4PolicyElementKey@2@@Z 01aa ?_StringFromPolicyKey@SchedulerPolicy@Concurrency@@CAPEADI@Z 01c1 ??0invalid_scheduler_policy_key@Concurrency@@QEAA@PEBD@Z 01c8 _TI2?AVinvalid_scheduler_policy_key@Concurrency@@ 01d5 _CxxThrowException 01e2 ?_ValidPolicyValue@SchedulerPolicy@Concurrency@@CA_NW4PolicyElementKey@2@I@Z 020c ??0invalid_scheduler_policy_value@Concurrency@@QEAA@PEBD@Z 0213 _TI2?AVinvalid_scheduler_policy_value@Concurrency@@ 0240 ?_AreConcurrencyLimitsValid@SchedulerPolicy@Concurrency@@AEBA_NXZ 025a ??0invalid_scheduler_policy_thread_specification@Concurrency@@QEAA@XZ 0261 _TI2?AVinvalid_scheduler_policy_thread_specification@Concurrency@@ 027b ?_ArePolicyCombinationsValid@SchedulerPolicy@Concurrency@@AEBA_NXZ 0295 ??0invalid_scheduler_policy_value@Concurrency@@QEAA@XZ 02b6 ?_ResolvePolicyValues@SchedulerPolicy@Concurrency@@AEAAXXZ"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 57 48 81 EC E0 00 00 00 48 C7 44 24 70 FE FF FF FF 48 C7 44 24 60 28 00 00 00 48 8D 44 24 24 48 8B F8 33 C0 B9 01 00 00 00 F3 AA 41 B9 50 00 00 00 4C 8D 05 ?? ?? ?? ?? 0F B6 54 24 24 B9 28 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 68 48 8B 44 24 68 48 89 44 24 38 48 8B 84 24 F0 00 00 00 48 8B 4C 24 38 48 89 08 48 8B 44 24 38 4C 8B 44 24 60 48 8D 15 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 C7 44 24 40 00 00 00 00 EB 0D 48 8B 44 24 40 48 FF C0 48 89 44 24 40 48 8B 84 24 F8 00 00 00 48 39 44 24 40 0F 83 7E 01 00 00 33 C0 85 C0 74 31 48 8B 84 24 00 01 00 00 48 8B 00 48 83 C0 08 48 8B 8C 24 00 01 00 00 48 89 01 48 8B 84 24 00 01 00 00 48 8B 00 48 8B 40 F8 8B 00 89 44 24 34 EB 2C 48 8B 84 24 00 01 00 00 48 8B 00 48 83 C0 08 48 8B 8C 24 00 01 00 00 48 89 01 48 8B 84 24 00 01 00 00 48 8B 00 8B 40 F8 89 44 24 34 8B 44 24 34 89 44 24 28 33 C0 85 C0 74 31 48 8B 84 24 00 01 00 00 48 8B 00 48 83 C0 08 48 8B 8C 24 00 01 00 00 48 89 01 48 8B 84 24 00 01 00 00 48 8B 00 48 8B 40 F8 8B 00 89 44 24 2C EB 2C 48 8B 84 24 00 01 00 00 48 8B 00 48 83 C0 08 48 8B 8C 24 00 01 00 00 48 89 01 48 8B 84 24 00 01 00 00 48 8B 00 8B 40 F8 89 44 24 2C 8B 44 24 2C 89 44 24 30 8B 4C 24 28 E8 ?? ?? ?? ?? 88 44 24 23 0F B6 44 24 23 85 C0 75 34 8B 4C 24 28 E8 ?? ?? ?? ?? 48 89 44 24 50 48 8B 54 24 50 48 8D 8C 24 A8 00 00 00 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 8C 24 A8 00 00 00 E8 ?? ?? ?? ?? 8B 54 24 30 8B 4C 24 28 E8 ?? ?? ?? ?? 88 44 24 21 0F B6 44 24 21 85 C0 75 2E 8B 4C 24 28 E8 ?? ?? ?? ?? 48 89 44 24 58 48 8B 54 24 58 48 8D 4C 24 78 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 78 E8 ?? ?? ?? ?? 48 63 44 24 28 48 8B 4C 24 38 8B 54 24 30 89 14 81 E9 62 FE FF FF 48 8B 8C 24 F0 00 00 00 E8 ?? ?? ?? ?? 88 44 24 22 0F B6 44 24 22 85 C0 75 21 48 8D 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 8B 8C 24 F0 00 00 00 E8 ?? ?? ?? ?? 88 44 24 20 0F B6 44 24 20 85 C0 75 21 48 8D 8C 24 C0 00 00 00 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 8C 24 C0 00 00 00 E8 ?? ?? ?? ?? 48 8B 8C 24 F0 00 00 00 E8 ?? ?? ?? ?? 90 EB 00 48 81 C4 E0 00 00 00 5F C3 }
	condition:
		$1
}

rule file_58_29_0 {
	meta:
		name = "__catch$?_Initialize@SchedulerPolicy@Concurrency@@AEAAX_KPEAPEAD@Z$0"
		size = 41
		refs = "000d ??3@YAXPEAX@Z 0016 _CxxThrowException 001e $LN18"
	strings:
		$1 = { 48 8B 45 38 48 89 45 48 48 8B 4D 48 E8 ?? ?? ?? ?? 33 D2 33 C9 E8 ?? ?? ?? ?? 90 48 8D 05 ?? ?? ?? ?? 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_58_30_0 {
	meta:
		name = "?_ResolvePolicyValues@SchedulerPolicy@Concurrency@@AEAAXXZ"
		size = 572
		refs = "0022 ?GetProcessorCount@Concurrency@@YAIXZ 003e ??_C@_1FK@IPKDCJGJ@?$AA?$CI?$AAc?$AAo?$AAr?$AAe?$AAC?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AAc?$AAo?$AAr?$AAe?$AAC?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DM?$AA?$DN@ 004a ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 005f ??_C@_1II@FOCFIAPJ@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 0069 _CrtDbgReportW 01ec ??_C@_1BGA@LBCCHDAG@?$AA_?$AAM?$AA_?$AAp?$AAP?$AAo?$AAl?$AAi?$AAc?$AAy?$AAB?$AAa?$AAg?$AA?9?$AA?$DO?$AA_?$AAM?$AA_?$AAv?$AAa?$AAl?$AAu?$AAe?$AAs?$AA?4?$AA_?$AAM?$AA_?$AAp?$AAP?$AAo?$AAl@"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 48 48 8B 44 24 50 48 8B 00 B9 04 00 00 00 48 6B C9 00 C7 04 08 00 00 00 00 E8 ?? ?? ?? ?? 89 44 24 30 83 7C 24 30 00 76 0A 81 7C 24 30 FF FF FF 7F 76 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 06 01 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 33 C0 85 C0 75 AF 33 C0 85 C0 75 A9 48 8B 44 24 50 48 8B 00 B9 04 00 00 00 48 6B C9 02 83 3C 08 FF 0F 85 9F 00 00 00 48 8B 44 24 50 48 8B 00 B9 04 00 00 00 48 6B C9 01 83 3C 08 FF 75 32 48 8B 44 24 50 48 8B 00 B9 04 00 00 00 48 6B C9 01 8B 54 24 30 89 14 08 48 8B 44 24 50 48 8B 00 B9 04 00 00 00 48 6B C9 02 8B 54 24 30 89 14 08 EB 54 48 8B 44 24 50 48 8B 00 B9 04 00 00 00 48 6B C9 01 8B 54 24 30 39 14 08 73 1A 48 8B 44 24 50 48 8B 00 B9 04 00 00 00 48 6B C9 01 8B 04 08 89 44 24 34 EB 08 8B 44 24 30 89 44 24 34 48 8B 44 24 50 48 8B 00 B9 04 00 00 00 48 6B C9 02 8B 54 24 34 89 14 08 EB 6B 48 8B 44 24 50 48 8B 00 B9 04 00 00 00 48 6B C9 01 83 3C 08 FF 75 54 48 8B 44 24 50 48 8B 00 B9 04 00 00 00 48 6B C9 02 8B 54 24 30 39 14 08 76 1A 48 8B 44 24 50 48 8B 00 B9 04 00 00 00 48 6B C9 02 8B 04 08 89 44 24 38 EB 08 8B 44 24 30 89 44 24 38 48 8B 44 24 50 48 8B 00 B9 04 00 00 00 48 6B C9 01 8B 54 24 38 89 14 08 48 8B 44 24 50 48 8B 00 B9 04 00 00 00 48 6B C9 02 83 3C 08 00 72 2C 48 8B 44 24 50 48 8B 00 B9 04 00 00 00 48 6B C9 01 48 8B 54 24 50 48 8B 12 41 B8 04 00 00 00 4D 6B C0 02 42 8B 14 02 39 14 08 73 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 1D 01 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 33 C0 85 C0 0F 85 79 FF FF FF 33 C0 85 C0 0F 85 6F FF FF FF 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_58_31_0 {
	meta:
		name = "?_StringFromPolicyKey@SchedulerPolicy@Concurrency@@CAPEADI@Z"
		size = 35
		refs = "001a ?PolicyElementKeyStrings@details@Concurrency@@3PAPEADA"
	strings:
		$1 = { 89 4C 24 08 83 7C 24 08 0A 76 08 C7 44 24 08 0A 00 00 00 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 8B 04 C1 C3 }
	condition:
		$1
}

rule file_58_32_0 {
	meta:
		name = "?_ValidPolicyKey@SchedulerPolicy@Concurrency@@CA_NW4PolicyElementKey@2@@Z"
		size = 47
	strings:
		$1 = { 89 4C 24 08 48 83 EC 18 83 7C 24 20 00 7C 10 83 7C 24 20 0A 7D 09 C7 04 24 01 00 00 00 EB 07 C7 04 24 00 00 00 00 0F B6 04 24 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_58_33_0 {
	meta:
		name = "?_ValidPolicyValue@SchedulerPolicy@Concurrency@@CA_NW4PolicyElementKey@2@I@Z"
		size = 436
		refs = "002c __ImageBase 0033 $LN35 013c ??_C@_1M@HLGKFCJM@?$AAf?$AAa?$AAl?$AAs?$AAe?$AA?$AA@ 0148 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 015d ??_C@_1II@FOCFIAPJ@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 0167 _CrtDbgReportW 018c $LN29 0190 $LN22 0194 $LN19 0198 $LN14 019c $LN16 01a4 $LN27 01a8 $LN24 01ac $LN11 01b0 $LN9"
	strings:
		$1 = { 89 54 24 10 89 4C 24 08 48 83 EC 48 C6 44 24 30 01 8B 44 24 50 89 44 24 38 83 7C 24 38 09 0F 87 13 01 00 00 48 63 44 24 38 48 8D 0D ?? ?? ?? ?? 8B 84 81 ?? ?? ?? ?? 48 03 C1 FF E0 83 7C 24 58 00 74 05 C6 44 24 30 00 E9 32 01 00 00 8B 44 24 58 89 44 24 34 83 7C 24 34 F9 7C 07 83 7C 24 34 07 7C 1D 83 7C 24 34 0F 74 16 83 7C 24 34 F1 74 0F 81 7C 24 34 00 F0 00 00 74 05 C6 44 24 30 00 E9 FA 00 00 00 83 7C 24 58 00 74 0C 83 7C 24 58 01 74 05 C6 44 24 30 00 E9 E2 00 00 00 83 7C 24 58 00 76 0A 81 7C 24 58 FF FF FF 7F 76 0C 83 7C 24 58 FF 74 05 C6 44 24 30 00 E9 C0 00 00 00 83 7C 24 58 00 72 0A 81 7C 24 58 FF FF FF 7F 76 0C 83 7C 24 58 FF 74 05 C6 44 24 30 00 E9 9E 00 00 00 81 7C 24 58 FF FF FF 7F 76 05 C6 44 24 30 00 E9 8A 00 00 00 83 7C 24 58 00 76 0A 81 7C 24 58 FF FF FF 7F 76 05 C6 44 24 30 00 EB 72 83 7C 24 58 01 74 0C 83 7C 24 58 00 74 05 C6 44 24 30 00 EB 5D 83 7C 24 58 00 74 0C 83 7C 24 58 01 74 05 C6 44 24 30 00 EB 48 33 C0 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 7C 01 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? CC 33 C0 33 C0 85 C0 75 C3 33 C0 85 C0 75 BD C6 44 24 30 00 0F B6 44 24 30 48 83 C4 48 C3 0F 1F 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_34_0 {
	meta:
		name = "?_ValidateConcRTPolicy@SchedulerPolicy@Concurrency@@QEBAXXZ"
		size = 146
		refs = "0014 ?GetPolicyValue@SchedulerPolicy@Concurrency@@QEBAIW4PolicyElementKey@2@@Z 0029 ?_StringFromPolicyKey@SchedulerPolicy@Concurrency@@CAPEADI@Z 0036 ??0invalid_scheduler_policy_value@Concurrency@@QEAA@PEBD@Z 003d _TI2?AVinvalid_scheduler_policy_value@Concurrency@@ 0047 _CxxThrowException"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 68 BA 02 00 00 00 48 8B 4C 24 70 E8 ?? ?? ?? ?? 89 44 24 20 83 7C 24 20 00 75 28 B9 02 00 00 00 E8 ?? ?? ?? ?? 48 8B D0 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 28 E8 ?? ?? ?? ?? BA 08 00 00 00 48 8B 4C 24 70 E8 ?? ?? ?? ?? 89 44 24 24 83 7C 24 24 00 75 28 B9 08 00 00 00 E8 ?? ?? ?? ?? 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_59_0_0 {
	meta:
		name = "_chmod"
		size = 98
		refs = "0029 __copy_path_to_wide_string 0042 _wchmod 0055 _free_dbg"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 28 00 00 00 00 48 83 7C 24 40 00 74 1A 48 8D 54 24 28 48 8B 4C 24 40 E8 ?? ?? ?? ?? 85 C0 75 07 B8 FF FF FF FF EB 25 8B 54 24 48 48 8B 4C 24 28 E8 ?? ?? ?? ?? 89 44 24 20 BA 02 00 00 00 48 8B 4C 24 28 E8 ?? ?? ?? ?? 8B 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_60_0_0 {
	meta:
		name = "feof"
		size = 187
		refs = "0035 ??_C@_1CC@FADMNIL@?$AA?$CI?$AAs?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0041 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0056 ??_C@_1GM@FJLDENGM@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 0060 _CrtDbgReportW 0074 _errno 0097 ??_C@_19LPGIFIDB@?$AAf?$AAe?$AAo?$AAf?$AA?$AA@ 00a3 _invalid_parameter"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 48 48 83 7C 24 50 00 74 0A C7 44 24 30 01 00 00 00 EB 08 C7 44 24 30 00 00 00 00 8B 44 24 30 89 44 24 34 83 7C 24 34 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 2C 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 34 00 75 38 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 2C 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 EB 0B 48 8B 44 24 50 8B 40 18 83 E0 10 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_60_1_0 {
	meta:
		name = "ferror"
		size = 187
		refs = "0035 ??_C@_1CC@FADMNIL@?$AA?$CI?$AAs?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0041 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0056 ??_C@_1GM@FJLDENGM@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 0060 _CrtDbgReportW 0074 _errno 0097 ??_C@_1O@MOPHEPGP@?$AAf?$AAe?$AAr?$AAr?$AAo?$AAr?$AA?$AA@ 00a3 _invalid_parameter"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 48 48 83 7C 24 50 00 74 0A C7 44 24 30 01 00 00 00 EB 08 C7 44 24 30 00 00 00 00 8B 44 24 30 89 44 24 34 83 7C 24 34 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 47 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 34 00 75 38 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 47 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 EB 0B 48 8B 44 24 50 8B 40 18 83 E0 20 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_61_1_0 {
	meta:
		name = "_locterm"
		size = 72
		refs = "0007 __initiallocinfo 000e __ptlocinfo 001a _lock 002e _updatetlocinfoEx_nolock 003f _unlock"
	strings:
		$1 = { 48 83 EC 28 48 8D 05 ?? ?? ?? ?? 48 39 05 ?? ?? ?? ?? 74 2F B9 0C 00 00 00 E8 ?? ?? ?? ?? 90 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? B9 0C 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_61_4_0 {
	meta:
		name = "__copy_locale_name"
		size = 204
		refs = "0023 wcsnlen 004e ??_C@_0DH@HAHIHJNC@f?3?2dd?2vctools?2crt_bld?2self_64_am@ 005b _malloc_dbg 0091 wcsncpy_s 00a9 ??_C@_1GO@PGHIOOKM@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 00b0 ??_C@_1CG@HCGEAFEA@?$AA_?$AA_?$AAc?$AAo?$AAp?$AAy?$AA_?$AAl?$AAo?$AAc?$AAa?$AAl?$AAe?$AA_?$AAn?$AAa?$AAm?$AAe?$AA?$AA@ 00b7 ??_C@_1GI@HBNMCKGD@?$AAw?$AAc?$AAs?$AAn?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAl?$AAo?$AAc?$AAa?$AAl?$AAe?$AAN?$AAa?$AAm?$AAe?$AAC?$AAo?$AAp?$AAy?$AA?0?$AA?5?$AAc?$AAc?$AAh?$AA?$CL?$AA1?$AA?0@ 00be _invoke_watson_if_error"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 48 48 83 7C 24 50 00 75 07 33 C0 E9 AF 00 00 00 BA 55 00 00 00 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 89 44 24 30 48 83 7C 24 30 55 72 07 33 C0 E9 8C 00 00 00 48 8B 44 24 30 48 8D 44 00 02 41 B9 5F 04 00 00 4C 8D 05 ?? ?? ?? ?? BA 02 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 48 89 44 24 38 48 83 7C 24 38 00 75 04 33 C0 EB 57 48 8B 44 24 30 48 FF C0 48 8B 4C 24 30 48 FF C1 4C 8B C8 4C 8B 44 24 50 48 8B D1 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 62 04 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 48 8B 44 24 38 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_61_5_0 {
	meta:
		name = "__create_locale"
		size = 32
		refs = "0017 _create_locale"
	strings:
		$1 = { 48 89 54 24 10 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_61_8_0 {
	meta:
		name = "__lc_lctowcs"
		size = 232
		refs = "0026 wcscpy_s 003e ??_C@_1GO@PGHIOOKM@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 0045 ??_C@_1BK@HEBMGPEK@?$AA_?$AA_?$AAl?$AAc?$AA_?$AAl?$AAc?$AAt?$AAo?$AAw?$AAc?$AAs?$AA?$AA@ 004c ??_C@_1GM@FOFMGOEK@?$AAw?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAl?$AAo?$AAc?$AAa?$AAl?$AAe?$AA?0?$AA?5?$AAn?$AAu?$AAm?$AAb?$AAe?$AAr?$AAO?$AAf?$AAE?$AAl?$AAe?$AAm?$AAe?$AAn?$AAt@ 0053 _invoke_watson_if_error 0084 ??_C@_13ENNFDPBH@?$AA_?$AA?$AA@ 0099 _wcscats 00ca ??_C@_13JOFGPIOO@?$AA?4?$AA?$AA@"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 50 4C 8B C0 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 4B 04 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? B8 02 00 00 00 48 6B C0 00 48 8B 4C 24 50 0F B7 84 01 80 00 00 00 85 C0 74 2C 48 8B 44 24 50 48 05 80 00 00 00 48 89 44 24 20 4C 8D 0D ?? ?? ?? ?? 41 B8 02 00 00 00 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? B8 02 00 00 00 48 6B C0 00 48 8B 4C 24 50 0F B7 84 01 00 01 00 00 85 C0 74 2C 48 8B 44 24 50 48 05 00 01 00 00 48 89 44 24 20 4C 8D 0D ?? ?? ?? ?? 41 B8 02 00 00 00 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_61_9_0 {
	meta:
		name = "__lc_wcstolc"
		size = 692
		refs = "001c memset 0093 wcsncpy_s 00ab ??_C@_1GO@PGHIOOKM@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 00b2 ??_C@_1BK@GNCHCGCN@?$AA_?$AA_?$AAl?$AAc?$AA_?$AAw?$AAc?$AAs?$AAt?$AAo?$AAl?$AAc?$AA?$AA@ 00b9 ??_C@_1NI@NELJHJBO@?$AAw?$AAc?$AAs?$AAn?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAn?$AAa?$AAm?$AAe?$AAs?$AA?9?$AA?$DO?$AAs?$AAz?$AAC?$AAo?$AAd?$AAe?$AAP?$AAa?$AAg?$AAe?$AA?0?$AA?5?$AA?$CI?$AAs?$AAi@ 00c0 _invoke_watson_if_error 00fa ??_C@_17MBJJLFDM@?$AA_?$AA?4?$AA?0?$AA?$AA@ 0104 wcscspn 0189 ??_C@_1MO@PBGOIBFL@?$AAw?$AAc?$AAs?$AAn?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAn?$AAa?$AAm?$AAe?$AAs?$AA?9?$AA?$DO?$AAs?$AAz?$AAL?$AAa?$AAn?$AAg?$AAu?$AAa?$AAg?$AAe?$AA?0?$AA?5?$AA?$CI?$AAs?$AAi@ 01f6 ??_C@_1MI@CLMFNAAJ@?$AAw?$AAc?$AAs?$AAn?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAn?$AAa?$AAm?$AAe?$AAs?$AA?9?$AA?$DO?$AAs?$AAz?$AAC?$AAo?$AAu?$AAn?$AAt?$AAr?$AAy?$AA?0?$AA?5?$AA?$CI?$AAs?$AAi?$AAz@ 0269 ??_C@_1MO@NBFBMKCB@?$AAw?$AAc?$AAs?$AAn?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAn?$AAa?$AAm?$AAe?$AAs?$AA?9?$AA?$DO?$AAs?$AAz?$AAC?$AAo?$AAd?$AAe?$AAP?$AAa?$AAg?$AAe?$AA?0?$AA?5?$AA?$CI?$AAs?$AAi@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 41 B8 CA 01 00 00 33 D2 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 8B 44 24 58 0F B7 00 85 C0 75 07 33 C0 E9 7C 02 00 00 B8 02 00 00 00 48 6B C0 00 48 8B 4C 24 58 0F B7 04 01 83 F8 2E 0F 85 95 00 00 00 B8 02 00 00 00 48 6B C0 01 48 8B 4C 24 58 0F B7 04 01 85 C0 74 7F B8 02 00 00 00 48 6B C0 01 48 8B 4C 24 58 48 03 C8 48 8B C1 48 8B 4C 24 50 48 81 C1 00 01 00 00 41 B9 0F 00 00 00 4C 8B C0 BA 10 00 00 00 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 21 04 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? B8 02 00 00 00 48 6B C0 0F 33 C9 48 8B 54 24 50 66 89 8C 02 00 01 00 00 33 C0 E9 CC 01 00 00 C7 44 24 34 00 00 00 00 EB 0A 8B 44 24 34 FF C0 89 44 24 34 48 8D 15 ?? ?? ?? ?? 48 8B 4C 24 58 E8 ?? ?? ?? ?? 48 89 44 24 38 48 83 7C 24 38 00 75 0A B8 FF FF FF FF E9 90 01 00 00 48 8B 44 24 58 48 8B 4C 24 38 0F B7 04 48 66 89 44 24 30 83 7C 24 34 00 75 60 48 83 7C 24 38 40 73 58 0F B7 44 24 30 83 F8 2E 74 4E 48 8B 44 24 50 4C 8B 4C 24 38 4C 8B 44 24 58 BA 40 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 2F 04 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? E9 E4 00 00 00 83 7C 24 34 01 75 63 48 83 7C 24 38 40 73 5B 0F B7 44 24 30 83 F8 5F 74 51 48 8B 44 24 50 48 05 80 00 00 00 4C 8B 4C 24 38 4C 8B 44 24 58 BA 40 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 32 04 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? EB 7A 83 7C 24 34 02 75 6C 48 83 7C 24 38 10 73 64 0F B7 44 24 30 85 C0 74 0A 0F B7 44 24 30 83 F8 2C 75 51 48 8B 44 24 50 48 05 00 01 00 00 4C 8B 4C 24 38 4C 8B 44 24 58 BA 10 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 35 04 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? EB 07 B8 FF FF FF FF EB 32 0F B7 44 24 30 83 F8 2C 75 02 EB 24 0F B7 44 24 30 85 C0 75 02 EB 19 48 8B 44 24 58 48 8B 4C 24 38 48 8D 44 48 02 48 89 44 24 58 E9 40 FE FF FF 33 C0 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_61_10_0 {
	meta:
		name = "_configthreadlocale"
		size = 352
		refs = "0009 _getptd 00a7 __globallocalestatus 00de ??_C@_1GA@LDEGDKD@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAp?$AAa?$AAr?$AAa?$AAm?$AAe?$AAt?$AAe?$AAr?$AA?5?$AAf?$AAo?$AAr?$AA?5?$AA_?$AAc?$AAo?$AAn?$AAf?$AAi?$AAg?$AAt@ 00ea ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 00ff ??_C@_1GO@PGHIOOKM@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 0109 _CrtDbgReportW 011d _errno 0140 ??_C@_1CI@FGIONOJM@?$AA_?$AAc?$AAo?$AAn?$AAf?$AAi?$AAg?$AAt?$AAh?$AAr?$AAe?$AAa?$AAd?$AAl?$AAo?$AAc?$AAa?$AAl?$AAe?$AA?$AA@ 014c _invalid_parameter"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 58 E8 ?? ?? ?? ?? 48 89 44 24 48 48 8B 44 24 48 8B 80 C8 00 00 00 83 E0 02 85 C0 75 0A C7 44 24 34 02 00 00 00 EB 08 C7 44 24 34 01 00 00 00 8B 44 24 34 89 44 24 40 8B 44 24 60 89 44 24 30 83 7C 24 30 FF 74 58 83 7C 24 30 00 74 4C 83 7C 24 30 01 74 09 83 7C 24 30 02 74 20 EB 50 48 8B 44 24 48 8B 80 C8 00 00 00 83 C8 02 48 8B 4C 24 48 89 81 C8 00 00 00 E9 D5 00 00 00 48 8B 44 24 48 8B 80 C8 00 00 00 83 E0 FD 48 8B 4C 24 48 89 81 C8 00 00 00 E9 B7 00 00 00 E9 B2 00 00 00 C7 05 ?? ?? ?? ?? FF FF FF FF E9 A3 00 00 00 33 C0 85 C0 74 0A C7 44 24 38 01 00 00 00 EB 08 C7 44 24 38 00 00 00 00 8B 44 24 38 89 44 24 3C 83 7C 24 3C 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 B1 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 3C 00 75 3B E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 B1 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 FF FF FF FF EB 04 8B 44 24 40 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_61_11_0 {
	meta:
		name = "_copytlocinfo_nolock"
		size = 89
		refs = "004e __addlocaleref"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 56 57 48 83 EC 28 48 83 7C 24 48 00 74 3A 48 83 7C 24 40 00 74 32 48 8B 44 24 48 48 39 44 24 40 74 26 48 8B 7C 24 40 48 8B 74 24 48 B9 58 01 00 00 F3 A4 48 8B 44 24 40 C7 00 00 00 00 00 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 28 5F 5E C3 }
	condition:
		$1
}

rule file_61_12_0 {
	meta:
		name = "_create_locale"
		size = 160
		refs = "0013 __security_cookie 006b __imp_MultiByteToWideChar 0084 _wcreate_locale 0094 __security_check_cookie"
	strings:
		$1 = { 48 89 54 24 10 89 4C 24 08 48 81 EC 58 01 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 40 01 00 00 83 BC 24 60 01 00 00 00 7C 15 83 BC 24 60 01 00 00 05 7F 0B 48 83 BC 24 68 01 00 00 00 75 04 33 C0 EB 43 C7 44 24 28 83 00 00 00 48 8D 44 24 30 48 89 44 24 20 41 B9 FF FF FF FF 4C 8B 84 24 68 01 00 00 33 D2 33 C9 FF 15 ?? ?? ?? ?? 85 C0 75 04 33 C0 EB 11 48 8D 54 24 30 8B 8C 24 60 01 00 00 E8 ?? ?? ?? ?? 48 8B 8C 24 40 01 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 58 01 00 00 C3 }
	condition:
		$1
}

rule file_61_13_0 {
	meta:
		name = "_expandlocale"
		size = 1385
		refs = "001e __security_cookie 002e _getptd 00c3 wcsncpy_s 00db ??_C@_1GO@PGHIOOKM@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 00e2 ??_C@_1BM@OIIBLEFG@?$AA_?$AAe?$AAx?$AAp?$AAa?$AAn?$AAd?$AAl?$AAo?$AAc?$AAa?$AAl?$AAe?$AA?$AA@ 00e9 ??_C@_1BFG@FHLOBJGM@?$AAw?$AAc?$AAs?$AAn?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAl?$AAo?$AAc?$AAa?$AAl?$AAe?$AAN?$AAa?$AAm?$AAe?$AAO?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?0?$AA?5?$AAl?$AAo?$AAc?$AAa@ 00f0 _invoke_watson_if_error 0124 ??_C@_13FHBKNHDA@?$AAC?$AA?$AA@ 0139 wcscpy_s 015f ??_C@_1EI@OCINLCHN@?$AAw?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?0?$AA?5?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAC?$AAh?$AAa?$AAr?$AAs?$AA?0?$AA?5?$AAL?$AA?$CC@ 0199 wcslen 01bb wcscmp 01e4 ??_C@_11LOCGONAA@?$AA?$AA@ 0207 __lc_wcstolc 0229 __get_qualified_locale 0248 __lc_lctowcs 02a9 ??_C@_1MO@NNCNEOAP@?$AAw?$AAc?$AAs?$AAn?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAl?$AAo?$AAc?$AAa?$AAl?$AAe?$AAN?$AAa?$AAm?$AAe?$AAO?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?0?$AA?5?$AAl?$AAo?$AAc?$AAa@ 02c2 __crtIsValidLocaleName 02e7 __crtGetLocaleInfoEx 02f8 __imp_GetACP 0350 ??_C@_1IG@MKDIEKFD@?$AAw?$AAc?$AAs?$AAn?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAc?$AAa?$AAc?$AAh?$AAe?$AAo?$AAu?$AAt?$AA?0?$AA?5?$AAc?$AAa?$AAc?$AAh?$AAe?$AAo?$AAu?$AAt?$AAL?$AAe?$AAn?$AA?0@ 03a5 ??_C@_1KK@KMIFPBBC@?$AAw?$AAc?$AAs?$AAn?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAl?$AAo?$AAc?$AAa?$AAl?$AAe?$AAN?$AAa?$AAm?$AAe?$AAO?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?0?$AA?5?$AAl?$AAo?$AAc?$AAa@ 03fb ??_C@_1BEK@OJDMMIMP@?$AAw?$AAc?$AAs?$AAn?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AA_?$AAp?$AAs?$AAe?$AAt?$AAl?$AAo?$AAc?$AA_?$AAd?$AAa?$AAt?$AAa?$AA?9?$AA?$DO?$AA_?$AAc?$AAa?$AAc?$AAh?$AAe?$AAL@ 045b ??_C@_1BGG@FCLLNAOE@?$AAw?$AAc?$AAs?$AAn?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AA_?$AAp?$AAs?$AAe?$AAt?$AAl?$AAo?$AAc?$AA_?$AAd?$AAa?$AAt?$AAa?$AA?9?$AA?$DO?$AA_?$AAc?$AAa?$AAc?$AAh?$AAe?$AAL@ 04cb ??_C@_1IC@FCCDBGLL@?$AAw?$AAc?$AAs?$AAn?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAc?$AAa?$AAc?$AAh?$AAe?$AAi?$AAn?$AA?0?$AA?5?$AAc?$AAa?$AAc?$AAh?$AAe?$AAi?$AAn?$AAL?$AAe?$AAn?$AA?0?$AA?5?$AAe@ 0501 memcpy 0541 ??_C@_1FA@HOOAAHFF@?$AAw?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?0?$AA?5?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAC?$AAh?$AAa?$AAr?$AAs?$AA?0?$AA?5?$AAc?$AAa@ 055d __security_check_cookie"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 81 EC 68 02 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 50 02 00 00 E8 ?? ?? ?? ?? 48 05 40 01 00 00 48 89 44 24 40 48 8B 44 24 40 48 83 C0 20 48 89 44 24 50 48 8B 44 24 40 48 83 C0 24 48 89 44 24 58 48 C7 44 24 68 83 00 00 00 48 8B 44 24 40 48 05 2A 01 00 00 48 89 44 24 48 48 C7 44 24 60 83 00 00 00 48 C7 44 24 38 00 00 00 00 C7 44 24 30 00 00 00 00 48 83 BC 24 70 02 00 00 00 75 07 33 C0 E9 B3 04 00 00 48 8B 44 24 40 48 05 58 02 00 00 41 B9 55 00 00 00 4C 8B C0 48 8B 94 24 90 02 00 00 48 8B 8C 24 88 02 00 00 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 B1 03 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 48 8B 84 24 70 02 00 00 0F B7 00 83 F8 43 0F 85 88 00 00 00 B8 02 00 00 00 48 6B C0 01 48 8B 8C 24 70 02 00 00 0F B7 04 01 85 C0 75 6F 4C 8D 05 ?? ?? ?? ?? 48 8B 94 24 80 02 00 00 48 8B 8C 24 78 02 00 00 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 B7 03 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 48 83 BC 24 98 02 00 00 00 74 0E 48 8B 84 24 98 02 00 00 C7 00 00 00 00 00 48 8B 84 24 78 02 00 00 E9 C1 03 00 00 48 8B 8C 24 70 02 00 00 E8 ?? ?? ?? ?? 48 89 44 24 38 48 81 7C 24 38 83 00 00 00 73 34 48 8B 94 24 70 02 00 00 48 8B 4C 24 48 E8 ?? ?? ?? ?? 85 C0 0F 84 1B 03 00 00 48 8B 94 24 70 02 00 00 48 8B 4C 24 58 E8 ?? ?? ?? ?? 85 C0 0F 84 01 03 00 00 48 8D 05 ?? ?? ?? ?? 48 89 44 24 78 48 C7 44 24 70 00 00 00 00 48 8B 94 24 70 02 00 00 48 8D 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 85 A6 00 00 00 4C 8D 84 24 80 00 00 00 48 8B 54 24 50 48 8D 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 84 84 00 00 00 4C 8D 84 24 80 00 00 00 48 8B 54 24 60 48 8B 4C 24 48 E8 ?? ?? ?? ?? 48 83 BC 24 88 02 00 00 00 74 5D 48 8D 8C 24 A0 01 00 00 E8 ?? ?? ?? ?? 48 FF C0 4C 8B C8 4C 8D 84 24 A0 01 00 00 48 8B 94 24 90 02 00 00 48 8B 8C 24 88 02 00 00 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 D0 03 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? E9 B4 01 00 00 48 8B 8C 24 70 02 00 00 E8 ?? ?? ?? ?? 85 C0 0F 84 3A 01 00 00 41 B9 02 00 00 00 4C 8D 44 24 30 BA 04 10 00 20 48 8B 8C 24 70 02 00 00 E8 ?? ?? ?? ?? 85 C0 74 07 83 7C 24 30 00 75 0A FF 15 ?? ?? ?? ?? 89 44 24 30 0F B7 44 24 30 48 8B 4C 24 50 89 01 48 8B 44 24 38 48 FF C0 4C 8B C8 4C 8B 84 24 70 02 00 00 48 8B 54 24 60 48 8B 4C 24 48 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 E0 03 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 48 8B 44 24 38 48 FF C0 4C 8B C8 4C 8B 84 24 70 02 00 00 48 8B 94 24 90 02 00 00 48 8B 8C 24 88 02 00 00 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 E3 03 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 48 8B 44 24 38 48 FF C0 48 8B 4C 24 40 48 81 C1 58 02 00 00 4C 8B C8 4C 8B 84 24 70 02 00 00 BA 55 00 00 00 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 E6 03 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? EB 65 48 8B 8C 24 88 02 00 00 E8 ?? ?? ?? ?? 48 FF C0 48 8B 4C 24 40 48 81 C1 58 02 00 00 4C 8B C8 4C 8B 84 24 88 02 00 00 BA 55 00 00 00 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 EB 03 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 33 C0 E9 E4 00 00 00 48 8B 84 24 70 02 00 00 0F B7 00 85 C0 74 5C 48 81 7C 24 38 83 00 00 00 73 51 48 8B 44 24 38 48 FF C0 4C 8B C8 4C 8B 84 24 70 02 00 00 48 8B 54 24 68 48 8B 4C 24 58 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 F0 03 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? EB 0A 33 C0 48 8B 4C 24 58 66 89 01 48 83 BC 24 98 02 00 00 00 74 18 41 B8 04 00 00 00 48 8B 54 24 50 48 8B 8C 24 98 02 00 00 E8 ?? ?? ?? ?? 4C 8B 44 24 48 48 8B 94 24 80 02 00 00 48 8B 8C 24 78 02 00 00 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 FA 03 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 48 8B 44 24 48 48 8B 8C 24 50 02 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 68 02 00 00 C3 }
	condition:
		$1
}

rule file_61_14_0 {
	meta:
		name = "_free_locale"
		size = 238
		refs = "001b _lock 0049 __initialmbcinfo 0067 _free_dbg 0072 _unlock 0095 __removelocaleref 00b4 __initiallocinfo 00cb __freetlocinfo"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 83 7C 24 30 00 0F 84 D4 00 00 00 B9 0D 00 00 00 E8 ?? ?? ?? ?? 90 48 8B 44 24 30 48 83 78 08 00 74 40 48 8B 44 24 30 48 8B 40 08 B9 FF FF FF FF F0 0F C1 08 FF C9 8B C1 85 C0 75 26 48 8D 05 ?? ?? ?? ?? 48 8B 4C 24 30 48 39 41 08 74 14 BA 02 00 00 00 48 8B 44 24 30 48 8B 48 08 E8 ?? ?? ?? ?? 90 B9 0D 00 00 00 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 38 00 74 59 B9 0C 00 00 00 E8 ?? ?? ?? ?? 90 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 38 00 74 2C 48 8B 44 24 30 48 8B 00 83 38 00 75 1F 48 8D 05 ?? ?? ?? ?? 48 8B 4C 24 30 48 39 01 74 0E 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 90 B9 0C 00 00 00 E8 ?? ?? ?? ?? BA 02 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_61_15_0 {
	meta:
		name = "_free_locale$fin$0"
		size = 27
		refs = "000f _unlock"
		altNames = "__updatetmbcinfo$fin$0 _freefls$fin$0 _initptd$fin$0 _setmbcp$fin$0"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA B9 0D 00 00 00 E8 ?? ?? ?? ?? 90 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_61_16_0 {
	meta:
		name = "_free_locale$fin$1"
		size = 27
		refs = "000f _unlock"
		altNames = "__updatetlocinfo$fin$0 _freefls$fin$1 _initptd$fin$1 _locterm$fin$0"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA B9 0C 00 00 00 E8 ?? ?? ?? ?? 90 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_61_17_0 {
	meta:
		name = "_get_current_locale"
		size = 216
		refs = "000e _getptd 0022 ??_C@_0DH@HAHIHJNC@f?3?2dd?2vctools?2crt_bld?2self_64_am@ 0037 _calloc_dbg 0049 _errno 0058 __updatetlocinfo 005d __updatetmbcinfo 0090 _lock 009e __addlocaleref 00a9 _unlock"
	strings:
		$1 = { 48 83 EC 48 48 C7 44 24 30 00 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 38 C7 44 24 20 AB 01 00 00 4C 8D 0D ?? ?? ?? ?? 41 B8 02 00 00 00 BA 01 00 00 00 B9 10 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 30 48 83 7C 24 30 00 75 0F E8 ?? ?? ?? ?? C7 00 0C 00 00 00 33 C0 EB 7C E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8B 4C 24 38 48 8B 89 C0 00 00 00 48 89 08 48 8B 44 24 30 48 8B 4C 24 38 48 8B 89 B8 00 00 00 48 89 48 08 B9 0C 00 00 00 E8 ?? ?? ?? ?? 90 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 90 B9 0C 00 00 00 E8 ?? ?? ?? ?? B9 0D 00 00 00 E8 ?? ?? ?? ?? 90 48 8B 44 24 30 48 8B 40 08 F0 FF 00 B9 0D 00 00 00 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_61_18_0 {
	meta:
		name = "_get_current_locale$fin$0"
		size = 27
		refs = "000f _unlock"
		altNames = "_wsetlocale$fin$0 _wsetlocale$fin$1"
	strings:
		$1 = { 40 55 48 83 EC 30 48 8B EA B9 0C 00 00 00 E8 ?? ?? ?? ?? 90 48 83 C4 30 5D C3 CC }
	condition:
		$1
}

rule file_61_19_0 {
	meta:
		name = "_get_current_locale$fin$1"
		size = 27
		refs = "000f _unlock"
	strings:
		$1 = { 40 55 48 83 EC 30 48 8B EA B9 0D 00 00 00 E8 ?? ?? ?? ?? 90 48 83 C4 30 5D C3 CC }
	condition:
		$1
}

rule file_61_22_0 {
	meta:
		name = "_wcreate_locale"
		size = 551
		refs = "003e ??_C@_0DH@HAHIHJNC@f?3?2dd?2vctools?2crt_bld?2self_64_am@ 0053 _calloc_dbg 0065 _errno 00bf _free_dbg 014a __initiallocinfo 0157 _copytlocinfo_nolock 016d _wsetlocale_nolock 017f __removelocaleref 018c __freetlocinfo 01bf _setmbcp_nolock"
	strings:
		$1 = { 48 89 54 24 10 89 4C 24 08 48 83 EC 58 48 C7 44 24 30 00 00 00 00 83 7C 24 60 00 7C 0F 83 7C 24 60 05 7F 08 48 83 7C 24 68 00 75 07 33 C0 E9 EF 01 00 00 C7 44 24 20 4C 01 00 00 4C 8D 0D ?? ?? ?? ?? 41 B8 02 00 00 00 BA 01 00 00 00 B9 10 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 30 48 83 7C 24 30 00 75 12 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 33 C0 E9 AC 01 00 00 C7 44 24 20 51 01 00 00 4C 8D 0D ?? ?? ?? ?? 41 B8 02 00 00 00 BA 01 00 00 00 B9 58 01 00 00 E8 ?? ?? ?? ?? 48 89 44 24 38 48 8B 44 24 30 48 8B 4C 24 38 48 89 08 48 83 7C 24 38 00 75 21 BA 02 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 00 0C 00 00 00 33 C0 E9 4D 01 00 00 C7 44 24 20 57 01 00 00 4C 8D 0D ?? ?? ?? ?? 41 B8 02 00 00 00 BA 01 00 00 00 B9 28 02 00 00 E8 ?? ?? ?? ?? 48 89 44 24 40 48 8B 44 24 30 48 8B 4C 24 40 48 89 48 08 48 83 7C 24 40 00 75 33 BA 02 00 00 00 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? BA 02 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 00 0C 00 00 00 33 C0 E9 DB 00 00 00 48 8D 15 ?? ?? ?? ?? 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 4C 8B 44 24 68 8B 54 24 60 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 48 85 C0 75 34 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? BA 02 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 C7 44 24 30 00 00 00 00 EB 73 48 8B 44 24 30 48 8B 00 48 8B 4C 24 30 48 8B 51 08 8B 48 04 E8 ?? ?? ?? ?? 85 C0 74 47 BA 02 00 00 00 48 8B 44 24 30 48 8B 48 08 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? BA 02 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 C7 44 24 30 00 00 00 00 EB 0F 48 8B 44 24 30 48 8B 40 08 C7 00 01 00 00 00 48 8B 44 24 30 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_61_23_0 {
	meta:
		name = "_wcscats"
		size = 163
		refs = "0062 wcscat_s 007a ??_C@_1GO@PGHIOOKM@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 0081 ??_C@_1BC@LEOKFFML@?$AA_?$AAw?$AAc?$AAs?$AAc?$AAa?$AAt?$AAs?$AA?$AA@ 0088 ??_C@_1CCE@OOPDKDD@?$AAw?$AAc?$AAs?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AAo?$AAu?$AAt?$AAs?$AAt?$AAr?$AA?0?$AA?5?$AAn?$AAu?$AAm?$AAb?$AAe?$AAr?$AAO?$AAf?$AAE?$AAl?$AAe?$AAm?$AAe?$AAn?$AAt@ 008f _invoke_watson_if_error"
	strings:
		$1 = { 44 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 4C 89 4C 24 20 48 83 EC 48 48 8D 44 24 68 48 89 44 24 38 C7 44 24 30 00 00 00 00 EB 0A 8B 44 24 30 FF C0 89 44 24 30 8B 44 24 60 39 44 24 30 7D 55 48 8B 44 24 38 48 83 C0 08 48 89 44 24 38 48 8B 44 24 38 4C 8B 40 F8 48 8B 54 24 58 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 0E 04 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? EB 97 48 C7 44 24 38 00 00 00 00 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_61_24_0 {
	meta:
		name = "_wsetlocale"
		size = 600
		refs = "0051 ??_C@_1FG@OHLFEKMC@?$AAL?$AAC?$AA_?$AAM?$AAI?$AAN?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AA_?$AAc?$AAa?$AAt?$AAe?$AAg?$AAo?$AAr?$AAy?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA_?$AAc?$AAa?$AAt?$AAe?$AAg?$AAo?$AAr?$AAy@ 005d ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0072 ??_C@_1GO@PGHIOOKM@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 007c _CrtDbgReportW 0090 _errno 00b3 ??_C@_1BI@KJNPAEHL@?$AA_?$AAw?$AAs?$AAe?$AAt?$AAl?$AAo?$AAc?$AAa?$AAl?$AAe?$AA?$AA@ 00bf _invalid_parameter 00cb _getptd 00d5 __updatetlocinfo 00fd ??_C@_0DH@HAHIHJNC@f?3?2dd?2vctools?2crt_bld?2self_64_am@ 0112 _calloc_dbg 012d _lock 0144 _copytlocinfo_nolock 014f _unlock 016e _wsetlocale_nolock 018e __wclocalestr 0198 wcscmp 01a2 __locale_changed 01c9 _updatetlocinfoEx_nolock 01d3 __removelocaleref 01eb __globallocalestatus 0205 __ptlocinfo 020f sync_legacy_variables_lk 0230 __freetlocinfo"
	strings:
		$1 = { 48 89 54 24 10 89 4C 24 08 48 83 EC 58 48 C7 44 24 48 00 00 00 00 48 C7 44 24 40 00 00 00 00 83 7C 24 60 00 7C 11 83 7C 24 60 05 7F 0A C7 44 24 30 01 00 00 00 EB 08 C7 44 24 30 00 00 00 00 8B 44 24 30 89 44 24 34 83 7C 24 34 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 0C 02 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 34 00 75 3B E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 0C 02 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 E9 89 01 00 00 E8 ?? ?? ?? ?? 48 89 44 24 38 E8 ?? ?? ?? ?? 48 8B 44 24 38 8B 80 C8 00 00 00 83 C8 10 48 8B 4C 24 38 89 81 C8 00 00 00 C7 44 24 20 17 02 00 00 4C 8D 0D ?? ?? ?? ?? 41 B8 02 00 00 00 BA 01 00 00 00 B9 58 01 00 00 E8 ?? ?? ?? ?? 48 89 44 24 40 48 83 7C 24 40 00 0F 84 0E 01 00 00 B9 0C 00 00 00 E8 ?? ?? ?? ?? 90 48 8B 44 24 38 48 8B 90 C0 00 00 00 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 B9 0C 00 00 00 E8 ?? ?? ?? ?? 48 83 7C 24 40 00 0F 84 C1 00 00 00 4C 8B 44 24 68 8B 54 24 60 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 89 44 24 48 48 83 7C 24 48 00 0F 84 9D 00 00 00 48 83 7C 24 68 00 74 1F 48 8D 15 ?? ?? ?? ?? 48 8B 4C 24 68 E8 ?? ?? ?? ?? 85 C0 74 0A C7 05 ?? ?? ?? ?? 01 00 00 00 B9 0C 00 00 00 E8 ?? ?? ?? ?? 90 48 8B 44 24 38 48 05 C0 00 00 00 48 8B 54 24 40 48 8B C8 E8 ?? ?? ?? ?? 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 44 24 38 8B 80 C8 00 00 00 83 E0 02 85 C0 75 2B 8B 05 ?? ?? ?? ?? 83 E0 01 85 C0 75 1E 48 8B 44 24 38 48 8B 90 C0 00 00 00 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 B9 0C 00 00 00 E8 ?? ?? ?? ?? EB 15 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 38 8B 80 C8 00 00 00 83 E0 EF 48 8B 4C 24 38 89 81 C8 00 00 00 48 8B 44 24 48 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_61_27_0 {
	meta:
		name = "_wsetlocale$fin$2"
		size = 39
	strings:
		$1 = { 40 55 48 83 EC 30 48 8B EA 48 8B 45 38 8B 80 C8 00 00 00 83 E0 EF 48 8B 4D 38 89 81 C8 00 00 00 48 83 C4 30 5D C3 CC }
	condition:
		$1
}

rule file_61_28_0 {
	meta:
		name = "_wsetlocale_get_all"
		size = 1257
		refs = "0047 ??_C@_0DH@HAHIHJNC@f?3?2dd?2vctools?2crt_bld?2self_64_am@ 0056 _malloc_dbg 00d2 __lc_category 00e8 ??_C@_13NMPKAAJP@?$AA?$DN?$AA?$AA@ 0106 _wcscats 0118 ??_C@_13PJJBFPED@?$AA?$DL?$AA?$AA@ 0127 wcscat_s 013f ??_C@_1GO@PGHIOOKM@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 0146 ??_C@_1CI@LKOPFFBD@?$AA_?$AAw?$AAs?$AAe?$AAt?$AAl?$AAo?$AAc?$AAa?$AAl?$AAe?$AA_?$AAg?$AAe?$AAt?$AA_?$AAa?$AAl?$AAl?$AA?$AA@ 014d ??_C@_1DC@HMLJMODP@?$AAw?$AAc?$AAs?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AAp?$AAc?$AAh?$AA?0?$AA?5?$AAc?$AAc?$AAh?$AA?0?$AA?5?$AAL?$AA?$CC?$AA?$DL?$AA?$CC?$AA?$CJ?$AA?$AA@ 0154 _invoke_watson_if_error 0182 wcscmp 01ee ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 020d _CrtDbgReportW 0232 _free_dbg"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 68 C7 44 24 34 01 00 00 00 48 C7 44 24 38 00 00 00 00 48 C7 44 24 50 00 00 00 00 48 C7 44 24 40 00 00 00 00 48 C7 44 24 48 00 00 00 00 48 C7 44 24 48 A6 06 00 00 41 B9 63 03 00 00 4C 8D 05 ?? ?? ?? ?? BA 02 00 00 00 48 8B 4C 24 48 E8 ?? ?? ?? ?? 48 89 44 24 40 48 83 7C 24 40 00 75 07 33 C0 E9 76 04 00 00 48 8B 44 24 40 48 83 C0 04 48 89 44 24 38 48 8B 44 24 48 48 83 E8 04 33 D2 B9 02 00 00 00 48 F7 F1 48 89 44 24 50 33 C0 48 8B 4C 24 38 66 89 01 48 8B 44 24 40 C7 00 01 00 00 00 C7 44 24 30 01 00 00 00 EB 0A 8B 44 24 30 FF C0 89 44 24 30 48 63 44 24 30 48 6B C0 20 48 63 4C 24 30 48 6B C9 18 48 8D 15 ?? ?? ?? ?? 4C 8B 44 24 70 49 8B 44 00 18 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 4C 8B 0C 0A 41 B8 03 00 00 00 48 8B 54 24 50 48 8B 4C 24 38 E8 ?? ?? ?? ?? 83 7C 24 30 05 0F 8D 82 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8B 54 24 50 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 6F 03 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 44 24 30 FF C0 48 98 48 6B C0 20 48 63 4C 24 30 48 6B C9 20 48 8B 54 24 70 48 8B 54 02 18 48 8B 44 24 70 48 8B 4C 08 18 E8 ?? ?? ?? ?? 85 C0 74 08 C7 44 24 34 00 00 00 00 E9 48 03 00 00 83 7C 24 34 00 0F 85 95 01 00 00 B8 20 00 00 00 48 6B C0 00 48 8B 4C 24 70 48 83 7C 01 28 00 74 7E B8 20 00 00 00 48 6B C0 00 48 8B 4C 24 70 48 8B 44 01 28 B9 FF FF FF FF F0 0F C1 08 FF C9 8B C1 85 C0 75 5A 33 C0 85 C0 75 37 48 C7 44 24 28 00 00 00 00 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 78 03 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 B8 20 00 00 00 48 6B C0 00 BA 02 00 00 00 48 8B 4C 24 70 48 8B 4C 01 28 E8 ?? ?? ?? ?? B8 20 00 00 00 48 6B C0 00 48 8B 4C 24 70 48 83 7C 01 20 00 74 7E B8 20 00 00 00 48 6B C0 00 48 8B 4C 24 70 48 8B 44 01 20 B9 FF FF FF FF F0 0F C1 08 FF C9 8B C1 85 C0 75 5A 33 C0 85 C0 75 37 48 C7 44 24 28 00 00 00 00 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 7D 03 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 B8 20 00 00 00 48 6B C0 00 BA 02 00 00 00 48 8B 4C 24 70 48 8B 4C 01 20 E8 ?? ?? ?? ?? B8 20 00 00 00 48 6B C0 00 48 8B 4C 24 70 48 C7 44 01 20 00 00 00 00 B8 20 00 00 00 48 6B C0 00 48 8B 4C 24 70 48 C7 44 01 10 00 00 00 00 B8 20 00 00 00 48 6B C0 00 48 8B 4C 24 70 48 8B 54 24 40 48 89 54 01 28 B8 20 00 00 00 48 6B C0 00 48 8B 4C 24 70 48 8B 54 24 38 48 89 54 01 18 48 8B 44 24 38 E9 B2 01 00 00 E9 A8 01 00 00 BA 02 00 00 00 48 8B 4C 24 40 E8 ?? ?? ?? ?? B8 20 00 00 00 48 6B C0 00 48 8B 4C 24 70 48 83 7C 01 28 00 74 7E B8 20 00 00 00 48 6B C0 00 48 8B 4C 24 70 48 8B 44 01 28 B9 FF FF FF FF F0 0F C1 08 FF C9 8B C1 85 C0 75 5A 33 C0 85 C0 75 37 48 C7 44 24 28 00 00 00 00 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 88 03 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 B8 20 00 00 00 48 6B C0 00 BA 02 00 00 00 48 8B 4C 24 70 48 8B 4C 01 28 E8 ?? ?? ?? ?? B8 20 00 00 00 48 6B C0 00 48 8B 4C 24 70 48 83 7C 01 20 00 74 7E B8 20 00 00 00 48 6B C0 00 48 8B 4C 24 70 48 8B 44 01 20 B9 FF FF FF FF F0 0F C1 08 FF C9 8B C1 85 C0 75 5A 33 C0 85 C0 75 37 48 C7 44 24 28 00 00 00 00 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 8D 03 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 B8 20 00 00 00 48 6B C0 00 BA 02 00 00 00 48 8B 4C 24 70 48 8B 4C 01 20 E8 ?? ?? ?? ?? B8 20 00 00 00 48 6B C0 00 48 8B 4C 24 70 48 C7 44 01 20 00 00 00 00 B8 20 00 00 00 48 6B C0 00 48 8B 4C 24 70 48 C7 44 01 10 00 00 00 00 B8 20 00 00 00 48 6B C0 00 48 8B 4C 24 70 48 C7 44 01 28 00 00 00 00 B8 20 00 00 00 48 6B C0 00 48 8B 4C 24 70 48 C7 44 01 18 00 00 00 00 B8 20 00 00 00 48 6B C0 02 48 8B 4C 24 70 48 8B 44 01 18 EB 05 E9 CF FB FF FF 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_61_29_0 {
	meta:
		name = "_wsetlocale_nolock"
		size = 1133
		refs = "0018 __security_cookie 0054 _wsetlocale_set_cat 0115 ??_C@_15NBPDDFIP@?$AA?$DN?$AA?$DL?$AA?$AA@ 011f wcspbrk 018b __lc_category 019e wcsncmp 01bb wcslen 01db ??_C@_13PJJBFPED@?$AA?$DL?$AA?$AA@ 01e5 wcscspn 022d wcsncpy_s 0245 ??_C@_1GO@PGHIOOKM@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 024c ??_C@_1CG@DKJCBBPP@?$AA_?$AAw?$AAs?$AAe?$AAt?$AAl?$AAo?$AAc?$AAa?$AAl?$AAe?$AA_?$AAn?$AAo?$AAl?$AAo?$AAc?$AAk?$AA?$AA@ 0253 ??_C@_1IA@DGCOPCLP@?$AAw?$AAc?$AAs?$AAn?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAl?$AAc?$AAt?$AAe?$AAm?$AAp?$AA?0?$AA?5?$AA?$CI?$AAs?$AAi?$AAz?$AAe?$AAo?$AAf?$AA?$CI?$AAl?$AAc?$AAt?$AAe?$AAm?$AAp@ 025a _invoke_watson_if_error 0279 __report_rangecheckfailure 0301 _wsetlocale_get_all 0355 _expandlocale 03ab wcscmp 0461 __security_check_cookie"
	strings:
		$1 = { 4C 89 44 24 18 89 54 24 10 48 89 4C 24 08 48 81 EC 58 02 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 40 02 00 00 83 BC 24 68 02 00 00 00 74 5B 48 83 BC 24 70 02 00 00 00 74 23 4C 8B 84 24 70 02 00 00 8B 94 24 68 02 00 00 48 8B 8C 24 60 02 00 00 E8 ?? ?? ?? ?? 48 89 44 24 78 EB 1E 48 63 84 24 68 02 00 00 48 6B C0 20 48 8B 8C 24 60 02 00 00 48 8B 44 01 18 48 89 44 24 78 48 8B 44 24 78 48 89 44 24 50 E9 C4 03 00 00 C7 44 24 58 01 00 00 00 C7 44 24 34 00 00 00 00 48 83 BC 24 70 02 00 00 00 0F 84 93 03 00 00 B8 02 00 00 00 48 6B C0 00 48 8B 8C 24 70 02 00 00 0F B7 04 01 83 F8 4C 0F 85 5B 02 00 00 B8 02 00 00 00 48 6B C0 01 48 8B 8C 24 70 02 00 00 0F B7 04 01 83 F8 43 0F 85 3D 02 00 00 B8 02 00 00 00 48 6B C0 02 48 8B 8C 24 70 02 00 00 0F B7 04 01 83 F8 5F 0F 85 1F 02 00 00 48 8B 84 24 70 02 00 00 48 89 44 24 48 48 8D 15 ?? ?? ?? ?? 48 8B 4C 24 48 E8 ?? ?? ?? ?? 48 89 44 24 38 48 83 7C 24 38 00 74 2D 48 8B 44 24 48 48 8B 4C 24 38 48 2B C8 48 8B C1 48 D1 F8 48 89 44 24 40 48 83 7C 24 40 00 74 0D 48 8B 44 24 38 0F B7 00 83 F8 3B 75 07 33 C0 E9 F1 02 00 00 C7 44 24 30 01 00 00 00 EB 0A 8B 44 24 30 FF C0 89 44 24 30 83 7C 24 30 05 7F 4B 48 63 44 24 30 48 6B C0 18 48 8D 0D ?? ?? ?? ?? 4C 8B 44 24 40 48 8B 54 24 48 48 8B 0C 01 E8 ?? ?? ?? ?? 85 C0 75 22 48 63 44 24 30 48 6B C0 18 48 8D 0D ?? ?? ?? ?? 48 8B 0C 01 E8 ?? ?? ?? ?? 48 39 44 24 40 75 02 EB 02 EB A4 48 8B 44 24 38 48 83 C0 02 48 89 44 24 38 48 8D 15 ?? ?? ?? ?? 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 89 44 24 40 48 83 7C 24 40 00 75 14 48 8B 44 24 38 0F B7 00 83 F8 3B 74 07 33 C0 E9 4B 02 00 00 83 7C 24 30 05 0F 8F 9F 00 00 00 4C 8B 4C 24 40 4C 8B 44 24 38 BA 83 00 00 00 48 8D 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 83 02 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 48 8B 44 24 40 48 03 C0 48 89 44 24 70 48 81 7C 24 70 06 01 00 00 73 02 EB 05 E8 ?? ?? ?? ?? 33 C0 48 8B 4C 24 70 66 89 84 0C 80 00 00 00 4C 8D 84 24 80 00 00 00 8B 54 24 30 48 8B 8C 24 60 02 00 00 E8 ?? ?? ?? ?? 48 85 C0 74 0A 8B 44 24 34 FF C0 89 44 24 34 48 8B 44 24 38 48 8B 4C 24 40 48 8D 04 48 48 89 44 24 48 48 8B 44 24 48 0F B7 00 85 C0 74 0E 48 8B 44 24 48 48 83 C0 02 48 89 44 24 48 48 8B 44 24 48 0F B7 00 85 C0 0F 85 21 FE FF FF 83 7C 24 34 00 74 14 48 8B 8C 24 60 02 00 00 E8 ?? ?? ?? ?? 48 89 44 24 60 EB 09 48 C7 44 24 60 00 00 00 00 48 8B 44 24 60 48 89 44 24 50 E9 18 01 00 00 48 C7 44 24 28 00 00 00 00 48 C7 44 24 20 55 00 00 00 4C 8D 8C 24 90 01 00 00 41 B8 83 00 00 00 48 8D 94 24 80 00 00 00 48 8B 8C 24 70 02 00 00 E8 ?? ?? ?? ?? 48 89 44 24 50 48 83 7C 24 50 00 0F 84 D2 00 00 00 C7 44 24 30 00 00 00 00 EB 0A 8B 44 24 30 FF C0 89 44 24 30 83 7C 24 30 05 7F 6E 83 7C 24 30 00 74 65 48 63 44 24 30 48 6B C0 20 48 8B 8C 24 60 02 00 00 48 8B 54 01 18 48 8D 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 85 C0 74 34 4C 8D 84 24 80 00 00 00 8B 54 24 30 48 8B 8C 24 60 02 00 00 E8 ?? ?? ?? ?? 48 85 C0 74 0C 8B 44 24 34 FF C0 89 44 24 34 EB 08 C7 44 24 58 00 00 00 00 EB 0A 8B 44 24 34 FF C0 89 44 24 34 EB 81 83 7C 24 58 00 74 14 48 8B 8C 24 60 02 00 00 E8 ?? ?? ?? ?? 48 89 44 24 50 EB 2E 83 7C 24 34 00 74 14 48 8B 8C 24 60 02 00 00 E8 ?? ?? ?? ?? 48 89 44 24 68 EB 09 48 C7 44 24 68 00 00 00 00 48 8B 44 24 68 48 89 44 24 50 EB 12 48 8B 8C 24 60 02 00 00 E8 ?? ?? ?? ?? 48 89 44 24 50 48 8B 44 24 50 48 8B 8C 24 40 02 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 58 02 00 00 C3 }
	condition:
		$1
}

rule file_61_30_0 {
	meta:
		name = "_wsetlocale_set_cat"
		size = 1806
		refs = "0018 __security_cookie 0046 _getptd 009f _expandlocale 00d1 wcscmp 0100 wcslen 0125 ??_C@_0DH@HAHIHJNC@f?3?2dd?2vctools?2crt_bld?2self_64_am@ 0132 _malloc_dbg 01be wcscpy_s 01d6 ??_C@_1GO@PGHIOOKM@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 01dd ??_C@_1CI@ODOPEMNJ@?$AA_?$AAw?$AAs?$AAe?$AAt?$AAl?$AAo?$AAc?$AAa?$AAl?$AAe?$AA_?$AAs?$AAe?$AAt?$AA_?$AAc?$AAa?$AAt?$AA?$AA@ 01e4 ??_C@_1EM@MHOCNIAA@?$AAw?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAp?$AAc?$AAh?$AA_?$AAc?$AAa?$AAt?$AA_?$AAl?$AAo?$AAc?$AAa?$AAl?$AAe?$AA?0?$AA?5?$AAc?$AAc?$AAh?$AA?0?$AA?5?$AAl?$AAc@ 01eb _invoke_watson_if_error 025f __copy_locale_name 039e _first_127char 03aa __crtGetStringTypeA 03ff _ctype_loc_style 040c memcmp 04db __lc_category 0542 _free_dbg 058e __wclocalestr 05e0 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 05ff _CrtDbgReportW 0702 __security_check_cookie"
	strings:
		$1 = { 4C 89 44 24 18 89 54 24 10 48 89 4C 24 08 48 81 EC 88 03 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 70 03 00 00 48 C7 44 24 60 00 00 00 00 48 C7 44 24 68 00 00 00 00 48 C7 84 24 80 00 00 00 00 00 00 00 E8 ?? ?? ?? ?? 48 89 84 24 A0 00 00 00 48 8B 84 24 A0 00 00 00 48 05 70 03 00 00 48 89 44 24 48 C7 44 24 54 05 00 00 00 48 8D 44 24 58 48 89 44 24 28 48 C7 44 24 20 55 00 00 00 4C 8D 8C 24 C0 02 00 00 41 B8 83 00 00 00 48 8D 94 24 B0 00 00 00 48 8B 8C 24 A0 03 00 00 E8 ?? ?? ?? ?? 48 85 C0 75 07 33 C0 E9 47 06 00 00 48 63 84 24 98 03 00 00 48 6B C0 20 48 8B 8C 24 90 03 00 00 48 8B 54 01 18 48 8D 8C 24 B0 00 00 00 E8 ?? ?? ?? ?? 85 C0 75 1E 48 63 84 24 98 03 00 00 48 6B C0 20 48 8B 8C 24 90 03 00 00 48 8B 44 01 18 E9 FF 05 00 00 48 8D 8C 24 B0 00 00 00 E8 ?? ?? ?? ?? 48 FF C0 48 89 84 24 80 00 00 00 48 8B 84 24 80 00 00 00 48 8D 44 00 04 41 B9 DE 02 00 00 4C 8D 05 ?? ?? ?? ?? BA 02 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 48 89 44 24 60 48 83 7C 24 60 00 75 07 33 C0 E9 AC 05 00 00 48 8B 44 24 60 48 83 C0 04 48 89 44 24 68 48 63 84 24 98 03 00 00 48 6B C0 20 48 8B 8C 24 90 03 00 00 48 8B 44 01 18 48 89 84 24 88 00 00 00 48 63 84 24 98 03 00 00 48 8B 8C 24 90 03 00 00 48 8B 84 C1 28 01 00 00 48 89 84 24 98 00 00 00 48 8B 84 24 90 03 00 00 8B 40 04 89 44 24 70 4C 8D 84 24 B0 00 00 00 48 8B 94 24 80 00 00 00 48 8B 4C 24 68 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 E9 02 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 48 63 84 24 98 03 00 00 48 6B C0 20 48 8B 8C 24 90 03 00 00 48 8B 54 24 68 48 89 54 01 18 B8 02 00 00 00 48 6B C0 00 0F B7 84 04 B0 00 00 00 83 F8 43 75 33 B8 02 00 00 00 48 6B C0 01 0F B7 84 04 B0 00 00 00 85 C0 75 1E 48 63 84 24 98 03 00 00 48 8B 8C 24 90 03 00 00 48 C7 84 C1 28 01 00 00 00 00 00 00 EB 25 48 8D 8C 24 C0 02 00 00 E8 ?? ?? ?? ?? 48 63 8C 24 98 03 00 00 48 8B 94 24 90 03 00 00 48 89 84 CA 28 01 00 00 83 BC 24 98 03 00 00 02 0F 85 0F 02 00 00 48 8B 84 24 90 03 00 00 8B 4C 24 58 89 48 04 8B 44 24 54 FF C8 48 98 48 8B 4C 24 48 48 8B 04 C1 48 89 44 24 78 C7 44 24 40 00 00 00 00 EB 0A 8B 44 24 40 FF C0 89 44 24 40 8B 44 24 54 39 44 24 40 0F 8D 93 00 00 00 48 63 44 24 40 48 8B 8C 24 90 03 00 00 48 8B 54 24 48 8B 04 C2 39 41 04 75 3E 83 7C 24 40 00 74 33 48 63 44 24 40 48 8B 4C 24 48 48 8B 04 C1 B9 08 00 00 00 48 6B C9 00 48 8B 54 24 48 48 89 04 0A 48 63 44 24 40 48 8B 4C 24 48 48 8B 54 24 78 48 89 14 C1 EB 3D EB 36 48 63 44 24 40 48 8B 4C 24 48 48 8B 04 C1 48 89 84 24 90 00 00 00 48 63 44 24 40 48 8B 4C 24 48 48 8B 54 24 78 48 89 14 C1 48 8B 84 24 90 00 00 00 48 89 44 24 78 E9 55 FF FF FF 8B 44 24 54 39 44 24 40 0F 85 05 01 00 00 C7 44 24 30 01 00 00 00 48 8B 84 24 90 03 00 00 8B 40 04 89 44 24 28 48 8D 84 24 C0 01 00 00 48 89 44 24 20 41 B9 7F 00 00 00 4C 8D 05 ?? ?? ?? ?? BA 01 00 00 00 33 C9 E8 ?? ?? ?? ?? 85 C0 0F 84 8E 00 00 00 C7 44 24 50 00 00 00 00 EB 0A 8B 44 24 50 FF C0 89 44 24 50 48 63 44 24 50 48 83 F8 7F 73 21 48 63 44 24 50 0F BF 84 44 C0 01 00 00 25 FF 01 00 00 48 63 4C 24 50 66 89 84 4C C0 01 00 00 EB CA 41 B8 FE 00 00 00 48 8B 15 ?? ?? ?? ?? 48 8D 8C 24 C0 01 00 00 E8 ?? ?? ?? ?? 85 C0 75 18 B8 08 00 00 00 48 6B C0 00 48 8B 4C 24 48 C7 44 01 04 01 00 00 00 EB 16 B8 08 00 00 00 48 6B C0 00 48 8B 4C 24 48 C7 44 01 04 00 00 00 00 EB 16 B8 08 00 00 00 48 6B C0 00 48 8B 4C 24 48 C7 44 01 04 00 00 00 00 B8 08 00 00 00 48 6B C0 00 48 8B 4C 24 48 48 8B 94 24 90 03 00 00 8B 52 04 89 14 01 B8 08 00 00 00 48 6B C0 00 48 8B 8C 24 90 03 00 00 48 8B 54 24 48 8B 44 02 04 89 81 D0 00 00 00 EB 34 83 BC 24 98 03 00 00 01 75 11 48 8B 84 24 90 03 00 00 8B 4C 24 58 89 48 08 EB 19 83 BC 24 98 03 00 00 05 75 0F 48 8B 84 24 90 03 00 00 8B 4C 24 58 89 48 0C 48 63 84 24 98 03 00 00 48 6B C0 18 48 8D 0D ?? ?? ?? ?? 48 89 8C 24 A8 00 00 00 48 8B 8C 24 90 03 00 00 48 8B 94 24 A8 00 00 00 FF 54 02 10 85 C0 0F 84 88 00 00 00 48 63 84 24 98 03 00 00 48 6B C0 20 48 8B 8C 24 90 03 00 00 48 8B 94 24 88 00 00 00 48 89 54 01 18 48 63 84 24 98 03 00 00 BA 02 00 00 00 48 8B 8C 24 90 03 00 00 48 8B 8C C1 28 01 00 00 E8 ?? ?? ?? ?? 48 63 84 24 98 03 00 00 48 8B 8C 24 90 03 00 00 48 8B 94 24 98 00 00 00 48 89 94 C1 28 01 00 00 BA 02 00 00 00 48 8B 4C 24 60 E8 ?? ?? ?? ?? 48 8B 84 24 90 03 00 00 8B 4C 24 70 89 48 04 33 C0 E9 6B 01 00 00 48 8D 05 ?? ?? ?? ?? 48 39 84 24 88 00 00 00 0F 84 0C 01 00 00 48 63 84 24 98 03 00 00 48 6B C0 20 48 8B 8C 24 90 03 00 00 48 8B 44 01 28 B9 FF FF FF FF F0 0F C1 08 FF C9 8B C1 85 C0 0F 85 DE 00 00 00 33 C0 85 C0 75 37 48 C7 44 24 28 00 00 00 00 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 47 03 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 48 63 84 24 98 03 00 00 48 6B C0 20 BA 02 00 00 00 48 8B 8C 24 90 03 00 00 48 8B 4C 01 28 E8 ?? ?? ?? ?? 48 63 84 24 98 03 00 00 48 6B C0 20 BA 02 00 00 00 48 8B 8C 24 90 03 00 00 48 8B 4C 01 20 E8 ?? ?? ?? ?? 48 63 84 24 98 03 00 00 BA 02 00 00 00 48 8B 8C 24 90 03 00 00 48 8B 8C C1 28 01 00 00 E8 ?? ?? ?? ?? 48 63 84 24 98 03 00 00 48 6B C0 20 48 8B 8C 24 90 03 00 00 48 C7 44 01 18 00 00 00 00 48 63 84 24 98 03 00 00 48 8B 8C 24 90 03 00 00 48 C7 84 C1 28 01 00 00 00 00 00 00 48 83 7C 24 60 00 74 0B 48 8B 44 24 60 C7 00 01 00 00 00 48 63 84 24 98 03 00 00 48 6B C0 20 48 8B 8C 24 90 03 00 00 48 8B 54 24 60 48 89 54 01 28 48 63 84 24 98 03 00 00 48 6B C0 20 48 8B 8C 24 90 03 00 00 48 8B 44 01 18 48 8B 8C 24 70 03 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 88 03 00 00 C3 }
	condition:
		$1
}

rule file_61_31_0 {
	meta:
		name = "sync_legacy_variables_lk"
		size = 62
		refs = "0003 __ptlocinfo 0011 __lconv 0026 _pctype 0039 __mb_cur_max"
	strings:
		$1 = { 48 8B 05 ?? ?? ?? ?? 48 8B 80 F0 00 00 00 48 89 05 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 8B 80 08 01 00 00 48 89 05 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 8B 80 D4 00 00 00 89 05 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_62_1_0 {
	meta:
		name = "clearerr_s"
		size = 377
		refs = "0035 ??_C@_1CC@FADMNIL@?$AA?$CI?$AAs?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0041 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0056 ??_C@_1GO@HOEPFCPC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 0060 _CrtDbgReportW 0074 _errno 0097 ??_C@_1BG@GHDODAOE@?$AAc?$AAl?$AAe?$AAa?$AAr?$AAe?$AAr?$AAr?$AA_?$AAs?$AA?$AA@ 00a3 _invalid_parameter 00b2 _ioinit 00ca _lock_file 00e8 _fileno 0117 __pioinfo 014b __badioinfo 016e _unlock_file"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 58 48 83 7C 24 60 00 74 0A C7 44 24 30 01 00 00 00 EB 08 C7 44 24 30 00 00 00 00 8B 44 24 30 89 44 24 34 83 7C 24 34 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 25 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 34 00 75 3E E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 25 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 16 00 00 00 E9 C3 00 00 00 E8 ?? ?? ?? ?? 85 C0 7D 0A B8 16 00 00 00 E9 B0 00 00 00 48 8B 4C 24 60 E8 ?? ?? ?? ?? 90 48 8B 44 24 60 8B 40 18 83 E0 CF 48 8B 4C 24 60 89 41 18 48 8B 4C 24 60 E8 ?? ?? ?? ?? 83 F8 FF 74 57 48 8B 4C 24 60 E8 ?? ?? ?? ?? 83 F8 FE 74 48 48 8B 4C 24 60 E8 ?? ?? ?? ?? C1 F8 05 48 98 48 89 44 24 48 48 8D 0D ?? ?? ?? ?? 48 89 4C 24 40 48 8B 4C 24 60 E8 ?? ?? ?? ?? 83 E0 1F 48 98 48 6B C0 58 48 8B 54 24 40 48 8B 4C 24 48 48 03 04 CA 48 89 44 24 38 EB 0C 48 8D 05 ?? ?? ?? ?? 48 89 44 24 38 48 8B 44 24 38 0F BE 40 08 83 E0 FD 48 8B 4C 24 38 88 41 08 48 8B 4C 24 60 E8 ?? ?? ?? ?? 33 C0 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_63_0_0 {
	meta:
		name = "??0?$LockFreeStack@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@QEAA@XZ"
		size = 33
		refs = "0013 __imp_InitializeSListHead"
		altNames = "??0?$LockFreeStack@VExternalContextBase@details@Concurrency@@@details@Concurrency@@QEAA@XZ ??0?$LockFreeStack@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QEAA@XZ ??0?$LockFreeStack@VRealizedChore@details@Concurrency@@@details@Concurrency@@QEAA@XZ ??0?$LockFreeStack@VSubAllocator@details@Concurrency@@@details@Concurrency@@QEAA@XZ ??0?$LockFreeStack@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B C8 FF 15 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_63_2_0 {
	meta:
		name = "??0?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@IEAA@PEAVThreadProxyFactoryManager@12@@Z"
		size = 113
		refs = "001d ??0IThreadProxyFactory@details@Concurrency@@QEAA@XZ 002a ??_7?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@6B@ 0037 ?GetExecutionResourceTls@ThreadProxyFactoryManager@details@Concurrency@@QEBAKXZ 004f ??0?$LockFreeStack@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@QEAA@XZ 0062 ??_H@YAXPEAX_KHP6APEAX0@Z@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 48 E8 ?? ?? ?? ?? 48 8B 4C 24 40 89 41 08 48 8B 44 24 40 48 83 C0 10 4C 8D 0D ?? ?? ?? ?? 41 B8 04 00 00 00 BA 10 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_63_4_0 {
	meta:
		name = "??0?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@IEAA@PEAVThreadProxyFactoryManager@12@@Z"
		size = 113
		refs = "001d ??0IThreadProxyFactory@details@Concurrency@@QEAA@XZ 002a ??_7?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@6B@ 0037 ?GetExecutionResourceTls@ThreadProxyFactoryManager@details@Concurrency@@QEBAKXZ 004f ??0?$LockFreeStack@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@QEAA@XZ 0062 ??_H@YAXPEAX_KHP6APEAX0@Z@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 48 E8 ?? ?? ?? ?? 48 8B 4C 24 40 89 41 08 48 8B 44 24 40 48 83 C0 10 4C 8D 0D ?? ?? ?? ?? 41 B8 04 00 00 00 BA 10 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_63_3_0 {
	meta:
		name = "?dtor$0@?0???0?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@IEAA@PEAVThreadProxyFactoryManager@12@@Z@4HA"
		size = 24
		refs = "000e ??1IThreadProxyFactory@details@Concurrency@@UEAA@XZ"
		altNames = "?dtor$0@?0???0?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@IEAA@PEAVThreadProxyFactoryManager@12@@Z@4HA"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_61_1_2 {
	meta:
		name = "?dtor$0@?0???$?0$$A6A_NAEBW4agent_status@Concurrency@@@Z@?$function@$$A6A_NAEBW4agent_status@Concurrency@@@Z@std@@QEAA@A6A_NAEBW4agent_status@Concurrency@@@Z@Z@4HA"
		size = 24
		refs = "000e ??1?$_Func_class@_NAEBW4agent_status@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_61_3_2 {
	meta:
		name = "?dtor$0@?0???$?0AEAU?$_Callable_fun@Q6A_NAEBW4agent_status@Concurrency@@@Z$0A@@std@@@?$_Func_impl@U?$_Callable_fun@Q6A_NAEBW4agent_status@Concurrency@@@Z$0A@@std@@V?$allocator@V?$_Func_class@_NAEBW4agent_status@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@@2@_NAEBW4agent_status@Concurrency@@U_Nil@2@U62@U62@U62@U62@U62@@std@@QEAA@AEAU?$_Callable_fun@Q6A_NAEBW4agent_status@Concurrency@@@Z$0A@@1@AEBV?$allocator@V?$_Func_impl@U?$_Callable_fun@Q6A_NAEBW4agent_status@Concurrency@@@Z$0A@@std@@V?$allocator@V?$_Func_class@_NAEBW4agent_status@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@@2@_NAEBW4agent_status@Concurrency@@U_Nil@2@U62@U62@U62@U62@U62@@std@@@1@@Z@4HA"
		size = 24
		refs = "000e ??1?$_Func_base@_NAEBW4agent_status@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_13_24_3 {
	meta:
		name = "?dtor$0@?0???$?0AEBQ6A_NAEBW4agent_status@Concurrency@@@Z@?$_Func_impl@U?$_Callable_fun@Q6A_NAEBW4agent_status@Concurrency@@@Z$0A@@std@@V?$allocator@V?$_Func_class@_NAEBW4agent_status@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@@2@_NAEBW4agent_status@Concurrency@@U_Nil@2@U62@U62@U62@U62@U62@@std@@QEAA@AEBQ6A_NAEBW4agent_status@Concurrency@@@ZAEBV?$allocator@V?$_Func_impl@U?$_Callable_fun@Q6A_NAEBW4agent_status@Concurrency@@@Z$0A@@std@@V?$allocator@V?$_Func_class@_NAEBW4agent_status@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@@2@_NAEBW4agent_status@Concurrency@@U_Nil@2@U62@U62@U62@U62@U62@@std@@@1@@Z@4HA"
		size = 24
		refs = "000e ??1?$_Func_base@_NAEBW4agent_status@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_78_28_1 {
	meta:
		name = "?dtor$0@?0???$?0U?$_Callable_fun@Q6A_NAEBW4agent_status@Concurrency@@@Z$0A@@std@@@?$_Func_impl@U?$_Callable_fun@Q6A_NAEBW4agent_status@Concurrency@@@Z$0A@@std@@V?$allocator@V?$_Func_class@_NAEBW4agent_status@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@@2@_NAEBW4agent_status@Concurrency@@U_Nil@2@U62@U62@U62@U62@U62@@std@@QEAA@$$QEAU?$_Callable_fun@Q6A_NAEBW4agent_status@Concurrency@@@Z$0A@@1@AEBV?$allocator@V?$_Func_impl@U?$_Callable_fun@Q6A_NAEBW4agent_status@Concurrency@@@Z$0A@@std@@V?$allocator@V?$_Func_class@_NAEBW4agent_status@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@@2@_NAEBW4agent_status@Concurrency@@U_Nil@2@U62@U62@U62@U62@U62@@std@@@1@@Z@4HA"
		size = 24
		refs = "000e ??1?$_Func_base@_NAEBW4agent_status@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_43_72_3 {
	meta:
		name = "?dtor$0@?0???0?$_Mpunct@D@std@@QEAA@AEBV_Locinfo@1@_K_N2@Z@4HA"
		size = 24
		refs = "000e ??1money_base@std@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_28_140_1 {
	meta:
		name = "?dtor$0@?0???0?$_Mpunct@G@std@@QEAA@AEBV_Locinfo@1@_K_N2@Z@4HA"
		size = 24
		refs = "000e ??1money_base@std@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_28_142_1 {
	meta:
		name = "?dtor$0@?0???0?$_Mpunct@_W@std@@QEAA@AEBV_Locinfo@1@_K_N2@Z@4HA"
		size = 24
		refs = "000e ??1money_base@std@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_88_16_2 {
	meta:
		name = "?dtor$0@?0???0?$_String_alloc@$0A@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAA@AEBV?$allocator@D@1@@Z@4HA"
		size = 24
		refs = "000e ??1?$_String_val@U?$_Simple_types@D@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_66_208_3 {
	meta:
		name = "?dtor$0@?0???0?$_String_alloc@$0A@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QEAA@AEBV?$allocator@G@1@@Z@4HA"
		size = 24
		refs = "000e ??1?$_String_val@U?$_Simple_types@G@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_66_210_3 {
	meta:
		name = "?dtor$0@?0???0?$_String_alloc@$0A@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QEAA@AEBV?$allocator@_W@1@@Z@4HA"
		size = 24
		refs = "000e ??1?$_String_val@U?$_Simple_types@_W@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_124_28_2 {
	meta:
		name = "?dtor$0@?0???0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEAA@PEBDPEBU_Container_base12@1@@Z@4HA"
		size = 24
		refs = "000e ??1?$_Iterator012@Urandom_access_iterator_tag@std@@D_JPEBDAEBDU_Iterator_base12@2@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_36_179_2 {
	meta:
		name = "?dtor$0@?0???0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QEAA@PEBGPEBU_Container_base12@1@@Z@4HA"
		size = 24
		refs = "000e ??1?$_Iterator012@Urandom_access_iterator_tag@std@@G_JPEBGAEBGU_Iterator_base12@2@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_66_217_3 {
	meta:
		name = "?dtor$0@?0???0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QEAA@PEB_WPEBU_Container_base12@1@@Z@4HA"
		size = 24
		refs = "000e ??1?$_Iterator012@Urandom_access_iterator_tag@std@@_W_JPEB_WAEB_WU_Iterator_base12@2@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_13_276_3 {
	meta:
		name = "?dtor$0@?0???0?$_SyncOriginator@W4agent_status@Concurrency@@@details@Concurrency@@QEAA@XZ@4HA"
		size = 24
		refs = "000e ??1?$ISource@W4agent_status@Concurrency@@@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_78_280_1 {
	meta:
		name = "?dtor$0@?0???0?$_SyncOriginator@_K@details@Concurrency@@QEAA@XZ@4HA"
		size = 24
		refs = "000e ??1?$ISource@_K@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_105_358_2 {
	meta:
		name = "?dtor$0@?0???0?$_Vector_alloc@$0A@U?$_Vec_base_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@2@@std@@@std@@QEAA@AEBV?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@1@@Z@4HA"
		size = 24
		refs = "000e ??1?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_105_360_2 {
	meta:
		name = "?dtor$0@?0???0?$_Vector_alloc@$0A@U?$_Vec_base_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@2@@std@@@std@@QEAA@AEBV?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@1@@Z@4HA"
		size = 24
		refs = "000e ??1?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_84_363_2 {
	meta:
		name = "?dtor$0@?0???0?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@QEAA@PEAV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@1@PEBU_Container_base12@1@@Z@4HA"
		size = 24
		refs = "000e ??1?$_Iterator012@Urandom_access_iterator_tag@std@@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@2@_JPEBV32@AEBV32@U_Iterator_base12@2@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_92_399_3 {
	meta:
		name = "?dtor$0@?0???0?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@QEAA@PEAV?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@1@PEBU_Container_base12@1@@Z@4HA"
		size = 24
		refs = "000e ??1?$_Iterator012@Urandom_access_iterator_tag@std@@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@2@_JPEBV32@AEBV32@U_Iterator_base12@2@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_107_28_1 {
	meta:
		name = "?dtor$0@?0???0?$basic_filebuf@DU?$char_traits@D@std@@@std@@QEAA@PEAU_iobuf@@@Z@4HA"
		size = 24
		refs = "000e ??1?$basic_streambuf@DU?$char_traits@D@std@@@std@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_84_54_3 {
	meta:
		name = "?dtor$0@?0???0?$basic_filebuf@GU?$char_traits@G@std@@@std@@QEAA@PEAU_iobuf@@@Z@4HA"
		size = 24
		refs = "000e ??1?$basic_streambuf@GU?$char_traits@G@std@@@std@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_53_37_2 {
	meta:
		name = "?dtor$0@?0???0?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@QEAA@PEAU_iobuf@@@Z@4HA"
		size = 24
		refs = "000e ??1?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_92_80_2 {
	meta:
		name = "?dtor$0@?0???0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@AEBV01@@Z@4HA"
		size = 24
		refs = "000e ??1?$_String_alloc@$0A@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_48_23_3 {
	meta:
		name = "?dtor$0@?0???0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@PEBD@Z@4HA"
		size = 24
		refs = "000e ??1?$_String_alloc@$0A@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_43_95_3 {
	meta:
		name = "?dtor$0@?0???0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@PEBD_K@Z@4HA"
		size = 24
		refs = "000e ??1?$_String_alloc@$0A@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_85_50_3 {
	meta:
		name = "?dtor$0@?0???0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@XZ@4HA"
		size = 24
		refs = "000e ??1?$_String_alloc@$0A@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_36_211_2 {
	meta:
		name = "?dtor$0@?0???0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@_KD@Z@4HA"
		size = 24
		refs = "000e ??1?$_String_alloc@$0A@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_36_214_2 {
	meta:
		name = "?dtor$0@?0???0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEAA@AEBV01@@Z@4HA"
		size = 24
		refs = "000e ??1?$_String_alloc@$0A@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_36_216_2 {
	meta:
		name = "?dtor$0@?0???0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEAA@PEBG@Z@4HA"
		size = 24
		refs = "000e ??1?$_String_alloc@$0A@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_66_252_3 {
	meta:
		name = "?dtor$0@?0???0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEAA@PEBG_K@Z@4HA"
		size = 24
		refs = "000e ??1?$_String_alloc@$0A@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_66_254_3 {
	meta:
		name = "?dtor$0@?0???0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEAA@XZ@4HA"
		size = 24
		refs = "000e ??1?$_String_alloc@$0A@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_66_256_3 {
	meta:
		name = "?dtor$0@?0???0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEAA@_KG@Z@4HA"
		size = 24
		refs = "000e ??1?$_String_alloc@$0A@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_66_259_3 {
	meta:
		name = "?dtor$0@?0???0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAA@AEBV01@@Z@4HA"
		size = 24
		refs = "000e ??1?$_String_alloc@$0A@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_87_46_2 {
	meta:
		name = "?dtor$0@?0???0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAA@PEB_W@Z@4HA"
		size = 24
		refs = "000e ??1?$_String_alloc@$0A@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_36_229_2 {
	meta:
		name = "?dtor$0@?0???0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAA@PEB_W_K@Z@4HA"
		size = 24
		refs = "000e ??1?$_String_alloc@$0A@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_36_231_2 {
	meta:
		name = "?dtor$0@?0???0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAA@XZ@4HA"
		size = 24
		refs = "000e ??1?$_String_alloc@$0A@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_66_267_3 {
	meta:
		name = "?dtor$0@?0???0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAA@_K_W@Z@4HA"
		size = 24
		refs = "000e ??1?$_String_alloc@$0A@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_61_308_2 {
	meta:
		name = "?dtor$0@?0???0?$call@_KV?$function@$$A6AXAEB_K@Z@std@@@Concurrency@@QEAA@AEBV?$function@$$A6AXAEB_K@Z@std@@@Z@4HA"
		size = 24
		refs = "000e ??1?$target_block@V?$multi_link_registry@V?$ISource@_K@Concurrency@@@Concurrency@@V?$ordered_message_processor@_K@2@@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_124_54_3 {
	meta:
		name = "?dtor$0@?0???0?$codecvt@DDH@std@@QEAA@AEBV_Locinfo@1@_K@Z@4HA"
		size = 24
		refs = "000e ??1codecvt_base@std@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_32_49_2 {
	meta:
		name = "?dtor$0@?0???0?$codecvt@GDH@std@@QEAA@AEBV_Locinfo@1@_K@Z@4HA"
		size = 24
		refs = "000e ??1codecvt_base@std@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_49_66_3 {
	meta:
		name = "?dtor$0@?0???0?$codecvt@_WDH@std@@QEAA@AEBV_Locinfo@1@_K@Z@4HA"
		size = 24
		refs = "000e ??1codecvt_base@std@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_92_90_2 {
	meta:
		name = "?dtor$0@?0???0?$collate@D@std@@QEAA@AEBV_Locinfo@1@_K@Z@4HA"
		size = 24
		refs = "000e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_28_188_1 {
	meta:
		name = "?dtor$0@?0???0?$collate@G@std@@QEAA@AEBV_Locinfo@1@_K@Z@4HA"
		size = 24
		refs = "000e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_66_275_3 {
	meta:
		name = "?dtor$0@?0???0?$collate@_W@std@@QEAA@AEBV_Locinfo@1@_K@Z@4HA"
		size = 24
		refs = "000e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_85_56_3 {
	meta:
		name = "?dtor$0@?0???0?$ctype@D@std@@QEAA@AEBV_Locinfo@1@_K@Z@4HA"
		size = 24
		refs = "000e ??1ctype_base@std@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_7_39_1 {
	meta:
		name = "?dtor$0@?0???0?$ctype@G@std@@QEAA@AEBV_Locinfo@1@_K@Z@4HA"
		size = 24
		refs = "000e ??1ctype_base@std@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_53_51_2 {
	meta:
		name = "?dtor$0@?0???0?$ctype@_W@std@@QEAA@AEBV_Locinfo@1@_K@Z@4HA"
		size = 24
		refs = "000e ??1ctype_base@std@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_61_313_2 {
	meta:
		name = "?dtor$0@?0???0?$function@$$A6AXAEB_K@Z@std@@QEAA@AEBV01@@Z@4HA"
		size = 24
		refs = "000e ??1?$_Func_class@XAEB_KU_Nil@std@@U12@U12@U12@U12@U12@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_92_428_3 {
	meta:
		name = "?dtor$0@?0???0?$function@$$A6AXE@Z@std@@QEAA@AEBV01@@Z@4HA"
		size = 24
		refs = "000e ??1?$_Func_class@XEU_Nil@std@@U12@U12@U12@U12@U12@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_84_397_2 {
	meta:
		name = "?dtor$0@?0???0?$function@$$A6AXU?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@Z@std@@QEAA@AEBV01@@Z@4HA"
		size = 24
		refs = "000e ??1?$_Func_class@XU?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@U_Nil@2@U32@U32@U32@U32@U32@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_84_399_2 {
	meta:
		name = "?dtor$0@?0???0?$function@$$A6AXV?$task@X@Concurrency@@@Z@std@@QEAA@AEBV01@@Z@4HA"
		size = 24
		refs = "000e ??1?$_Func_class@XV?$task@X@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_84_401_2 {
	meta:
		name = "?dtor$0@?0???0?$function@$$A6AXXZ@std@@QEAA@AEBV01@@Z@4HA"
		size = 24
		refs = "000e ??1?$_Func_class@XU_Nil@std@@U12@U12@U12@U12@U12@U12@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_13_318_3 {
	meta:
		name = "?dtor$0@?0???0?$function@$$A6A_NAEBW4agent_status@Concurrency@@@Z@std@@QEAA@AEBV01@@Z@4HA"
		size = 24
		refs = "000e ??1?$_Func_class@_NAEBW4agent_status@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_61_320_2 {
	meta:
		name = "?dtor$0@?0???0?$function@$$A6A_NAEB_K@Z@std@@QEAA@AEBV01@@Z@4HA"
		size = 24
		refs = "000e ??1?$_Func_class@_NAEB_KU_Nil@std@@U12@U12@U12@U12@U12@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_64_70_1 {
	meta:
		name = "?dtor$0@?0???0?$messages@D@std@@QEAA@AEBV_Locinfo@1@_K@Z@4HA"
		size = 24
		refs = "000e ??1messages_base@std@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_28_196_1 {
	meta:
		name = "?dtor$0@?0???0?$messages@G@std@@QEAA@AEBV_Locinfo@1@_K@Z@4HA"
		size = 24
		refs = "000e ??1messages_base@std@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_66_283_3 {
	meta:
		name = "?dtor$0@?0???0?$messages@_W@std@@QEAA@AEBV_Locinfo@1@_K@Z@4HA"
		size = 24
		refs = "000e ??1messages_base@std@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_92_96_2 {
	meta:
		name = "?dtor$0@?0???0?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z@4HA"
		size = 24
		refs = "000e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_66_285_3 {
	meta:
		name = "?dtor$0@?0???0?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z@4HA"
		size = 24
		refs = "000e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_36_253_2 {
	meta:
		name = "?dtor$0@?0???0?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z@4HA"
		size = 24
		refs = "000e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_92_98_2 {
	meta:
		name = "?dtor$0@?0???0?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z@4HA"
		size = 24
		refs = "000e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_28_204_1 {
	meta:
		name = "?dtor$0@?0???0?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z@4HA"
		size = 24
		refs = "000e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_66_291_3 {
	meta:
		name = "?dtor$0@?0???0?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z@4HA"
		size = 24
		refs = "000e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_100_50_1 {
	meta:
		name = "?dtor$0@?0???0?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z@4HA"
		size = 24
		refs = "000e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_28_212_1 {
	meta:
		name = "?dtor$0@?0???0?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z@4HA"
		size = 24
		refs = "000e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_36_265_2 {
	meta:
		name = "?dtor$0@?0???0?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z@4HA"
		size = 24
		refs = "000e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_39_71_3 {
	meta:
		name = "?dtor$0@?0???0?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z@4HA"
		size = 24
		refs = "000e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_66_301_3 {
	meta:
		name = "?dtor$0@?0???0?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z@4HA"
		size = 24
		refs = "000e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_66_303_3 {
	meta:
		name = "?dtor$0@?0???0?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z@4HA"
		size = 24
		refs = "000e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_39_73_3 {
	meta:
		name = "?dtor$0@?0???0?$numpunct@D@std@@QEAA@AEBV_Locinfo@1@_K_N@Z@4HA"
		size = 24
		refs = "000e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_28_220_1 {
	meta:
		name = "?dtor$0@?0???0?$numpunct@G@std@@QEAA@AEBV_Locinfo@1@_K_N@Z@4HA"
		size = 24
		refs = "000e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_36_273_2 {
	meta:
		name = "?dtor$0@?0???0?$numpunct@_W@std@@QEAA@AEBV_Locinfo@1@_K_N@Z@4HA"
		size = 24
		refs = "000e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_61_338_2 {
	meta:
		name = "?dtor$0@?0???0?$overwrite_buffer@W4agent_status@Concurrency@@@Concurrency@@QEAA@XZ@4HA"
		size = 24
		refs = "000e ??1?$propagator_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_61_340_2 {
	meta:
		name = "?dtor$0@?0???0?$propagator_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@QEAA@XZ@4HA"
		size = 24
		refs = "000e ??1?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_61_343_2 {
	meta:
		name = "?dtor$0@?0???0?$propagator_block@V?$multi_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@_K@Concurrency@@@2@V?$ordered_message_processor@_K@2@@Concurrency@@QEAA@XZ@4HA"
		size = 24
		refs = "000e ??1?$source_block@V?$multi_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@V?$ordered_message_processor@_K@2@@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_61_346_2 {
	meta:
		name = "?dtor$0@?0???0?$propagator_block@V?$single_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@_K@2@@Concurrency@@QEAA@XZ@4HA"
		size = 24
		refs = "000e ??1?$source_block@V?$single_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@V?$ordered_message_processor@_K@2@@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_61_349_2 {
	meta:
		name = "?dtor$0@?0???0?$single_assignment@_K@Concurrency@@QEAA@XZ@4HA"
		size = 24
		refs = "000e ??1?$propagator_block@V?$multi_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@_K@Concurrency@@@2@V?$ordered_message_processor@_K@2@@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_78_354_1 {
	meta:
		name = "?dtor$0@?0???0?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@QEAA@XZ@4HA"
		size = 24
		refs = "000e ??1?$ISource@W4agent_status@Concurrency@@@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_13_359_3 {
	meta:
		name = "?dtor$0@?0???0?$source_block@V?$multi_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@V?$ordered_message_processor@_K@2@@Concurrency@@QEAA@XZ@4HA"
		size = 24
		refs = "000e ??1?$ISource@_K@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_13_364_3 {
	meta:
		name = "?dtor$0@?0???0?$source_block@V?$single_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@V?$ordered_message_processor@_K@2@@Concurrency@@QEAA@XZ@4HA"
		size = 24
		refs = "000e ??1?$ISource@_K@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_13_369_3 {
	meta:
		name = "?dtor$0@?0???0?$source_link_manager@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@QEAA@XZ@4HA"
		size = 24
		refs = "000e ??1_ReentrantPPLLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_78_372_1 {
	meta:
		name = "?dtor$0@?0???0?$source_link_manager@V?$multi_link_registry@V?$ISource@_K@Concurrency@@@Concurrency@@@Concurrency@@QEAA@XZ@4HA"
		size = 24
		refs = "000e ??1_ReentrantPPLLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_61_375_2 {
	meta:
		name = "?dtor$0@?0???0?$target_block@V?$multi_link_registry@V?$ISource@_K@Concurrency@@@Concurrency@@V?$ordered_message_processor@_K@2@@Concurrency@@QEAA@XZ@4HA"
		size = 24
		refs = "000e ??1?$ITarget@_K@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_43_113_3 {
	meta:
		name = "?dtor$0@?0???0?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z@4HA"
		size = 24
		refs = "000e ??1time_base@std@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_36_275_2 {
	meta:
		name = "?dtor$0@?0???0?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z@4HA"
		size = 24
		refs = "000e ??1time_base@std@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_28_226_1 {
	meta:
		name = "?dtor$0@?0???0?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z@4HA"
		size = 24
		refs = "000e ??1time_base@std@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_92_104_2 {
	meta:
		name = "?dtor$0@?0???0?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z@4HA"
		size = 24
		refs = "000e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_36_279_2 {
	meta:
		name = "?dtor$0@?0???0?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z@4HA"
		size = 24
		refs = "000e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_28_231_1 {
	meta:
		name = "?dtor$0@?0???0?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z@4HA"
		size = 24
		refs = "000e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_92_451_3 {
	meta:
		name = "?dtor$0@?0???0?$vector@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@2@@std@@QEAA@$$QEAV01@@Z@4HA"
		size = 24
		refs = "000e ??1?$_Vector_alloc@$0A@U?$_Vec_base_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@2@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_84_421_2 {
	meta:
		name = "?dtor$0@?0???0?$vector@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@2@@std@@QEAA@$$QEAV01@@Z@4HA"
		size = 24
		refs = "000e ??1?$_Vector_alloc@$0A@U?$_Vec_base_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@2@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_439_26_0 {
	meta:
		name = "?dtor$0@?0???0CacheLocalScheduleGroupSegment@details@Concurrency@@QEAA@PEAVScheduleGroupBase@12@PEAVSchedulingRing@12@PEAVlocation@2@@Z@4HA"
		size = 24
		refs = "000e ??1ScheduleGroupSegmentBase@details@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_439_32_0 {
	meta:
		name = "?dtor$0@?0???0FairScheduleGroupSegment@details@Concurrency@@QEAA@PEAVScheduleGroupBase@12@PEAVSchedulingRing@12@PEAVlocation@2@@Z@4HA"
		size = 24
		refs = "000e ??1ScheduleGroupSegmentBase@details@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_63_7_0 {
	meta:
		name = "?dtor$0@?0???0FreeThreadProxy@details@Concurrency@@QEAA@PEAUIThreadProxyFactory@12@I@Z@4HA"
		size = 24
		refs = "000e ??1ThreadProxy@details@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_439_35_0 {
	meta:
		name = "?dtor$0@?0???0NumaInformation@SchedulerBase@details@Concurrency@@QEAA@XZ@4HA"
		size = 24
		refs = "000e ??1QuickBitSet@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_439_40_0 {
	meta:
		name = "?dtor$0@?0???0RealizedChore@details@Concurrency@@QEAA@P6AXPEAX@Z0@Z@4HA"
		size = 24
		refs = "000e ??1_Chore@details@Concurrency@@MEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_993_21_0 {
	meta:
		name = "?dtor$0@?0???0ScheduleGroupBase@details@Concurrency@@QEAA@PEAVSchedulerBase@12@PEAVlocation@2@@Z@4HA"
		size = 24
		refs = "000e ??1ScheduleGroup@Concurrency@@MEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_192_1_0 {
	meta:
		name = "?dtor$0@?0???0ThreadVirtualProcessor@details@Concurrency@@QEAA@PEAVSchedulingNode@12@PEAUIVirtualProcessorRoot@2@@Z@4HA"
		size = 24
		refs = "000e ??1VirtualProcessor@details@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_303_1_0 {
	meta:
		name = "?dtor$0@?0???0TimerObj@?6??wait@Concurrency@@YAXI@Z@QEAA@I@Z@4HA"
		size = 24
		refs = "000e ??1_Timer@details@Concurrency@@MEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_63_14_0 {
	meta:
		name = "?dtor$0@?0???0UMSFreeThreadProxy@details@Concurrency@@QEAA@PEAUIThreadProxyFactory@12@PEAXI@Z@4HA"
		size = 24
		refs = "000e ??1UMSThreadProxy@details@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_726_2_0 {
	meta:
		name = "?dtor$0@?0???0UMSThreadVirtualProcessor@details@Concurrency@@QEAA@PEAVSchedulingNode@12@PEAUIVirtualProcessorRoot@2@@Z@4HA"
		size = 24
		refs = "000e ??1VirtualProcessor@details@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_595_6_0 {
	meta:
		name = "?dtor$0@?0???0WorkQueue@details@Concurrency@@QEAA@XZ@4HA"
		size = 24
		refs = "000e ??1?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_265_9_0 {
	meta:
		name = "?dtor$0@?0???0_AsyncTaskCollection@details@Concurrency@@AEAA@PEAV_CancellationTokenState@12@@Z@4HA"
		size = 24
		refs = "000e ??1_RefCounterBase@details@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_61_383_2 {
	meta:
		name = "?dtor$0@?0???0_Blocking_recipient@?1???$_Receive_impl@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@1@PEAV?$ISource@W4agent_status@Concurrency@@@1@IPEBV?$function@$$A6A_NAEBW4agent_status@Concurrency@@@Z@std@@@Z@QEAA@0I@Z@4HA"
		size = 24
		refs = "000e ??1?$ITarget@W4agent_status@Concurrency@@@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_78_390_1 {
	meta:
		name = "?dtor$0@?0???0_Blocking_recipient@?1???$_Receive_impl@_K@Concurrency@@YA_KPEAV?$ISource@_K@1@IPEBV?$function@$$A6A_NAEB_K@Z@std@@@Z@QEAA@0I@Z@4HA"
		size = 24
		refs = "000e ??1?$ITarget@_K@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_3_34_3 {
	meta:
		name = "?dtor$0@?0???0_Locimp@locale@std@@AEAA@AEBV012@@Z@4HA"
		size = 24
		refs = "000e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_23_36_2 {
	meta:
		name = "?dtor$0@?0???0_Locimp@locale@std@@AEAA@_N@Z@4HA"
		size = 24
		refs = "000e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_76_76_2 {
	meta:
		name = "?dtor$0@?0???0facet@locale@std@@IEAA@_K@Z@4HA"
		size = 24
		refs = "000e ??1_Facet_base@std@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_61_28_1 {
	meta:
		name = "?dtor$0@?0???0sentry@?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAA@AEAV12@@Z@4HA"
		size = 24
		refs = "000e ??1_Sentry_base@?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_124_29_1 {
	meta:
		name = "?dtor$0@?0???0sentry@?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAA@AEAV12@@Z@4HA"
		size = 24
		refs = "000e ??1_Sentry_base@?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_48_40_3 {
	meta:
		name = "?dtor$0@?0???0sentry@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAA@AEAV12@@Z@4HA"
		size = 24
		refs = "000e ??1_Sentry_base@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_25_38_3 {
	meta:
		name = "?dtor$0@?0???0system_error@std@@QEAA@HAEBVerror_category@1@PEBD@Z@4HA"
		size = 24
		refs = "000e ??1runtime_error@std@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_637_55_0 {
	meta:
		name = "?dtor$0@?0???1?$_Ref_count_del_alloc@V__ExceptionPtr@@P6AXPEAV1@@ZV?$_DebugMallocator@H@@@std@@UEAA@XZ@4HA"
		size = 24
		refs = "000e ??1_Ref_count_base@std@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_54_498_3 {
	meta:
		name = "?dtor$0@?0???1?$_RunAnyParam@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@QEAA@XZ@4HA"
		size = 24
		refs = "000e ??1?$task_completion_event@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_61_463_2 {
	meta:
		name = "?dtor$0@?0???1?$call@_KV?$function@$$A6AXAEB_K@Z@std@@@Concurrency@@UEAA@XZ@4HA"
		size = 24
		refs = "000e ??1?$target_block@V?$multi_link_registry@V?$ISource@_K@Concurrency@@@Concurrency@@V?$ordered_message_processor@_K@2@@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_78_466_1 {
	meta:
		name = "?dtor$0@?0???1?$concurrent_queue@PEAV?$message@W4agent_status@Concurrency@@@Concurrency@@V?$allocator@PEAV?$message@W4agent_status@Concurrency@@@Concurrency@@@std@@@Concurrency@@UEAA@XZ@4HA"
		size = 24
		refs = "000e ??1_Concurrent_queue_base_v4@details@Concurrency@@MEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_78_468_1 {
	meta:
		name = "?dtor$0@?0???1?$concurrent_queue@PEAV?$message@_K@Concurrency@@V?$allocator@PEAV?$message@_K@Concurrency@@@std@@@Concurrency@@UEAA@XZ@4HA"
		size = 24
		refs = "000e ??1_Concurrent_queue_base_v4@details@Concurrency@@MEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_13_498_3 {
	meta:
		name = "?dtor$0@?0???1?$overwrite_buffer@W4agent_status@Concurrency@@@Concurrency@@UEAA@XZ@4HA"
		size = 24
		refs = "000e ??1?$propagator_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_61_512_2 {
	meta:
		name = "?dtor$0@?0???1?$single_assignment@_K@Concurrency@@UEAA@XZ@4HA"
		size = 24
		refs = "000e ??1?$propagator_block@V?$multi_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@_K@Concurrency@@@2@V?$ordered_message_processor@_K@2@@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_268_29_0 {
	meta:
		name = "?dtor$0@?0???1ContextBase@details@Concurrency@@UEAA@XZ@4HA"
		size = 24
		refs = "000e ??1Context@Concurrency@@MEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_996_18_0 {
	meta:
		name = "?dtor$0@?0???1ExternalContextBase@details@Concurrency@@UEAA@XZ@4HA"
		size = 24
		refs = "000e ??1ContextBase@details@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_439_85_0 {
	meta:
		name = "?dtor$0@?0???1NumaInformation@SchedulerBase@details@Concurrency@@QEAA@XZ@4HA"
		size = 24
		refs = "000e ??1QuickBitSet@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_439_91_0 {
	meta:
		name = "?dtor$0@?0???1ScheduleGroupBase@details@Concurrency@@UEAA@XZ@4HA"
		size = 24
		refs = "000e ??1ScheduleGroup@Concurrency@@MEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_439_94_0 {
	meta:
		name = "?dtor$0@?0???1SchedulerBase@details@Concurrency@@UEAA@XZ@4HA"
		size = 24
		refs = "000e ??1Scheduler@Concurrency@@MEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_63_31_0 {
	meta:
		name = "?dtor$0@?0???1UMSFreeThreadProxyFactory@details@Concurrency@@UEAA@XZ@4HA"
		size = 24
		refs = "000e ??1?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_268_35_0 {
	meta:
		name = "?dtor$0@?0???1WorkQueue@details@Concurrency@@QEAA@XZ@4HA"
		size = 24
		refs = "000e ??1?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_265_31_0 {
	meta:
		name = "?dtor$0@?0???1_AsyncTaskCollection@details@Concurrency@@UEAA@XZ@4HA"
		size = 24
		refs = "000e ??1_RefCounterBase@details@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_13_993_3 {
	meta:
		name = "?dtor$0@?0??consume_message@?$overwrite_buffer@W4agent_status@Concurrency@@@Concurrency@@MEAAPEAV?$message@W4agent_status@Concurrency@@@2@H@Z@4HA"
		size = 24
		refs = "000e ??3_AllocBase@details@Concurrency@@SAXPEAX@Z"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_887_33_0 {
	meta:
		name = "?dtor$0@?0??rethrow_exception@std@@YAXVexception_ptr@1@@Z@4HA"
		size = 24
		refs = "000e ??1exception_ptr@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_92_66_3 {
	meta:
		name = "?dtor$1@?0???$_Debug_range2@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@@std@@YAXV?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@0@0PEB_WIUrandom_access_iterator_tag@0@@Z@4HA"
		size = 24
		refs = "000e ??1?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_92_69_3 {
	meta:
		name = "?dtor$1@?0???$_Debug_range2@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@@std@@YAXV?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@0@0PEB_WIUrandom_access_iterator_tag@0@@Z@4HA"
		size = 24
		refs = "000e ??1?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_54_94_3 {
	meta:
		name = "?dtor$1@?0???$_Distance2@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@_K@std@@YAXV?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@0@0AEA_KUrandom_access_iterator_tag@0@@Z@4HA"
		size = 24
		refs = "000e ??1?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_54_97_3 {
	meta:
		name = "?dtor$1@?0???$_Distance2@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@_K@std@@YAXV?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@0@0AEA_KUrandom_access_iterator_tag@0@@Z@4HA"
		size = 24
		refs = "000e ??1?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_637_36_0 {
	meta:
		name = "?dtor$1@?0???0?$_Ref_count_del_alloc@V__ExceptionPtr@@P6AXPEAV1@@ZV?$_DebugMallocator@H@@@std@@QEAA@PEAV__ExceptionPtr@@P6AX0@ZV?$_DebugMallocator@V?$_Ref_count_del_alloc@V__ExceptionPtr@@P6AXPEAV1@@ZV?$_DebugMallocator@H@@@std@@@@@Z@4HA"
		size = 24
		refs = "000e ??1_Ref_count_base@std@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_63_6_0 {
	meta:
		name = "??0FreeThreadProxy@details@Concurrency@@QEAA@PEAUIThreadProxyFactory@12@I@Z"
		size = 92
		refs = "002c ??0ThreadProxy@details@Concurrency@@QEAA@PEAUIThreadProxyFactory@12@I@Z 0039 ??_7FreeThreadProxy@details@Concurrency@@6B@ 004d ??0HardwareAffinity@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 44 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 44 8B 44 24 50 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 40 48 83 C0 48 48 8B C8 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_63_8_0 {
	meta:
		name = "??0FreeThreadProxyFactory@details@Concurrency@@IEAA@PEAVThreadProxyFactoryManager@12@@Z"
		size = 75
		refs = "0019 ??0?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@IEAA@PEAVThreadProxyFactoryManager@12@@Z 0025 ??_7FreeThreadProxyFactory@details@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 C7 40 50 01 00 00 00 48 8B 44 24 30 C6 40 54 00 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_63_9_0 {
	meta:
		name = "??0HardwareAffinity@details@Concurrency@@QEAA@XZ"
		size = 63
		refs = "001a memset"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 41 B8 10 00 00 00 33 D2 48 8B C8 E8 ?? ?? ?? ?? 33 C0 48 8B 4C 24 30 66 89 41 08 48 8B 44 24 30 48 C7 00 00 00 00 00 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_63_10_0 {
	meta:
		name = "??0IThreadProxyFactory@details@Concurrency@@QEAA@XZ"
		size = 26
		refs = "000d ??_7IThreadProxyFactory@details@Concurrency@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 08 C3 }
	condition:
		$1
}

rule file_78_216_1 {
	meta:
		name = "??0?$ISource@W4agent_status@Concurrency@@@Concurrency@@QEAA@XZ"
		size = 26
		refs = "000d ??_7?$ISource@W4agent_status@Concurrency@@@Concurrency@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 08 C3 }
	condition:
		$1
}

rule file_78_217_1 {
	meta:
		name = "??0?$ISource@_K@Concurrency@@QEAA@XZ"
		size = 26
		refs = "000d ??_7?$ISource@_K@Concurrency@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 08 C3 }
	condition:
		$1
}

rule file_61_218_2 {
	meta:
		name = "??0?$ITarget@W4agent_status@Concurrency@@@Concurrency@@QEAA@XZ"
		size = 26
		refs = "000d ??_7?$ITarget@W4agent_status@Concurrency@@@Concurrency@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 08 C3 }
	condition:
		$1
}

rule file_13_219_3 {
	meta:
		name = "??0?$ITarget@_K@Concurrency@@QEAA@XZ"
		size = 26
		refs = "000d ??_7?$ITarget@_K@Concurrency@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 08 C3 }
	condition:
		$1
}

rule file_13_240_3 {
	meta:
		name = "??0?$_Func_base@XAEB_KU_Nil@std@@U12@U12@U12@U12@U12@@std@@QEAA@XZ"
		size = 26
		refs = "000d ??_7?$_Func_base@XAEB_KU_Nil@std@@U12@U12@U12@U12@U12@@std@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 08 C3 }
	condition:
		$1
}

rule file_78_241_1 {
	meta:
		name = "??0?$_Func_base@XPEAV?$message@W4agent_status@Concurrency@@@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@QEAA@XZ"
		size = 26
		refs = "000d ??_7?$_Func_base@XPEAV?$message@W4agent_status@Concurrency@@@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 08 C3 }
	condition:
		$1
}

rule file_78_242_1 {
	meta:
		name = "??0?$_Func_base@XPEAV?$message@_K@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@QEAA@XZ"
		size = 26
		refs = "000d ??_7?$_Func_base@XPEAV?$message@_K@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 08 C3 }
	condition:
		$1
}

rule file_5_255_1 {
	meta:
		name = "??0?$_Func_base@XU_Nil@std@@U12@U12@U12@U12@U12@U12@@std@@QEAA@XZ"
		size = 26
		refs = "000d ??_7?$_Func_base@XU_Nil@std@@U12@U12@U12@U12@U12@U12@@std@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 08 C3 }
	condition:
		$1
}

rule file_61_243_2 {
	meta:
		name = "??0?$_Func_base@_NAEBW4agent_status@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@QEAA@XZ"
		size = 26
		refs = "000d ??_7?$_Func_base@_NAEBW4agent_status@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 08 C3 }
	condition:
		$1
}

rule file_13_323_3 {
	meta:
		name = "??0?$message_processor@W4agent_status@Concurrency@@@Concurrency@@QEAA@XZ"
		size = 26
		refs = "000d ??_7?$message_processor@W4agent_status@Concurrency@@@Concurrency@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 08 C3 }
	condition:
		$1
}

rule file_61_324_2 {
	meta:
		name = "??0?$message_processor@_K@Concurrency@@QEAA@XZ"
		size = 26
		refs = "000d ??_7?$message_processor@_K@Concurrency@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 08 C3 }
	condition:
		$1
}

rule file_61_329_2 {
	meta:
		name = "??0?$network_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@QEAA@XZ"
		size = 26
		refs = "000d ??_7?$network_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 08 C3 }
	condition:
		$1
}

rule file_61_330_2 {
	meta:
		name = "??0?$network_link_registry@V?$ISource@_K@Concurrency@@@Concurrency@@QEAA@XZ"
		size = 26
		refs = "000d ??_7?$network_link_registry@V?$ISource@_K@Concurrency@@@Concurrency@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 08 C3 }
	condition:
		$1
}

rule file_61_331_2 {
	meta:
		name = "??0?$network_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@QEAA@XZ"
		size = 26
		refs = "000d ??_7?$network_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 08 C3 }
	condition:
		$1
}

rule file_13_332_3 {
	meta:
		name = "??0?$network_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@QEAA@XZ"
		size = 26
		refs = "000d ??_7?$network_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 08 C3 }
	condition:
		$1
}

rule file_268_9_0 {
	meta:
		name = "??0Context@Concurrency@@QEAA@XZ"
		size = 26
		refs = "000d ??_7Context@Concurrency@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 08 C3 }
	condition:
		$1
}

rule file_658_10_0 {
	meta:
		name = "??0DNameNode@@IEAA@XZ"
		size = 26
		refs = "000d ??_7DNameNode@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 08 C3 }
	condition:
		$1
}

rule file_397_1_0 {
	meta:
		name = "??0IExecutionContext@Concurrency@@QEAA@XZ"
		size = 26
		refs = "000d ??_7IExecutionContext@Concurrency@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 08 C3 }
	condition:
		$1
}

rule file_739_0_0 {
	meta:
		name = "??0IExecutionResource@Concurrency@@QEAA@XZ"
		size = 26
		refs = "000d ??_7IExecutionResource@Concurrency@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 08 C3 }
	condition:
		$1
}

rule file_171_9_0 {
	meta:
		name = "??0IResourceManager@Concurrency@@QEAA@XZ"
		size = 26
		refs = "000d ??_7IResourceManager@Concurrency@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 08 C3 }
	condition:
		$1
}

rule file_1076_0_0 {
	meta:
		name = "??0IScheduler@Concurrency@@QEAA@XZ"
		size = 26
		refs = "000d ??_7IScheduler@Concurrency@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 08 C3 }
	condition:
		$1
}

rule file_1003_2_0 {
	meta:
		name = "??0ISchedulerProxy@Concurrency@@QEAA@XZ"
		size = 26
		refs = "000d ??_7ISchedulerProxy@Concurrency@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 08 C3 }
	condition:
		$1
}

rule file_86_1_0 {
	meta:
		name = "??0IThreadProxy@Concurrency@@QEAA@XZ"
		size = 26
		refs = "000d ??_7IThreadProxy@Concurrency@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 08 C3 }
	condition:
		$1
}

rule file_171_10_0 {
	meta:
		name = "??0ITopologyExecutionResource@Concurrency@@QEAA@XZ"
		size = 26
		refs = "000d ??_7ITopologyExecutionResource@Concurrency@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 08 C3 }
	condition:
		$1
}

rule file_171_11_0 {
	meta:
		name = "??0ITopologyNode@Concurrency@@QEAA@XZ"
		size = 26
		refs = "000d ??_7ITopologyNode@Concurrency@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 08 C3 }
	condition:
		$1
}

rule file_317_0_0 {
	meta:
		name = "??0IUMSCompletionList@Concurrency@@QEAA@XZ"
		size = 26
		refs = "000d ??_7IUMSCompletionList@Concurrency@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 08 C3 }
	condition:
		$1
}

rule file_86_3_0 {
	meta:
		name = "??0IUMSUnblockNotification@Concurrency@@QEAA@XZ"
		size = 26
		refs = "000d ??_7IUMSUnblockNotification@Concurrency@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 08 C3 }
	condition:
		$1
}

rule file_993_19_0 {
	meta:
		name = "??0ScheduleGroup@Concurrency@@QEAA@XZ"
		size = 26
		refs = "000d ??_7ScheduleGroup@Concurrency@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 08 C3 }
	condition:
		$1
}

rule file_439_42_0 {
	meta:
		name = "??0Scheduler@Concurrency@@IEAA@XZ"
		size = 26
		refs = "000d ??_7Scheduler@Concurrency@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 08 C3 }
	condition:
		$1
}

rule file_86_4_0 {
	meta:
		name = "??0UMSBaseObject@details@Concurrency@@QEAA@XZ"
		size = 26
		refs = "000d ??_7UMSBaseObject@details@Concurrency@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 08 C3 }
	condition:
		$1
}

rule file_439_58_0 {
	meta:
		name = "??0_Chore@details@Concurrency@@IEAA@XZ"
		size = 26
		refs = "000d ??_7_Chore@details@Concurrency@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 08 C3 }
	condition:
		$1
}

rule file_39_76_3 {
	meta:
		name = "??0_Facet_base@std@@QEAA@XZ"
		size = 26
		refs = "000d ??_7_Facet_base@std@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 08 C3 }
	condition:
		$1
}

rule file_123_81_2 {
	meta:
		name = "??0error_category@std@@QEAA@XZ"
		size = 26
		refs = "000d ??_7error_category@std@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 08 C3 }
	condition:
		$1
}

rule file_85_86_3 {
	meta:
		name = "??0ios_base@std@@IEAA@XZ"
		size = 26
		refs = "000d ??_7ios_base@std@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 08 C3 }
	condition:
		$1
}

rule file_63_11_0 {
	meta:
		name = "??0ThreadProxyFactoryManager@details@Concurrency@@QEAA@XZ"
		size = 139
		refs = "0038 ??0_NonReentrantBlockingLock@details@Concurrency@@QEAA@XZ 003f __imp_TlsAlloc 0058 __imp_GetLastError 005f HRESULT_FROM_WIN32 006b ??0scheduler_resource_allocation_error@Concurrency@@QEAA@J@Z 0072 _TI2?AVscheduler_resource_allocation_error@Concurrency@@ 007c _CxxThrowException"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 58 48 C7 44 24 20 FE FF FF FF 48 8B 44 24 60 48 C7 00 00 00 00 00 48 8B 44 24 60 48 C7 40 08 00 00 00 00 48 8B 44 24 60 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 FF 15 ?? ?? ?? ?? 48 8B 4C 24 60 89 41 10 48 8B 44 24 60 83 78 10 FF 75 2B FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B D0 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 28 E8 ?? ?? ?? ?? 90 48 8B 44 24 60 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_63_12_0 {
	meta:
		name = "?dtor$0@?0???0ThreadProxyFactoryManager@details@Concurrency@@QEAA@XZ@4HA"
		size = 28
		refs = "0012 ??1_NonReentrantBlockingLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 60 48 83 C1 18 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_606_16_0 {
	meta:
		name = "?dtor$1@?0???1_CancellationTokenState@details@Concurrency@@UEAA@XZ@4HA"
		size = 28
		refs = "0012 ??1event@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 60 48 83 C1 18 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_63_13_0 {
	meta:
		name = "??0UMSFreeThreadProxy@details@Concurrency@@QEAA@PEAUIThreadProxyFactory@12@PEAXI@Z"
		size = 136
		refs = "0036 ??0UMSThreadProxy@details@Concurrency@@QEAA@PEAUIThreadProxyFactory@12@PEAXI@Z 0043 ??_7UMSFreeThreadProxy@details@Concurrency@@6BUMSBaseObject@12@@ 0052 ??_7UMSFreeThreadProxy@details@Concurrency@@6BIUMSThreadProxy@2@@ 0062 ??_7UMSFreeThreadProxy@details@Concurrency@@6BIUMSUnblockNotification@2@@ 0079 ??0HardwareAffinity@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 44 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 44 8B 4C 24 58 4C 8B 44 24 50 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 48 08 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 48 10 48 8B 44 24 40 48 05 20 01 00 00 48 8B C8 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_63_15_0 {
	meta:
		name = "??0UMSFreeThreadProxyFactory@details@Concurrency@@IEAA@PEAVThreadProxyFactoryManager@12@@Z"
		size = 418
		refs = "002c ??0?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@IEAA@PEAVThreadProxyFactoryManager@12@@Z 003c ??_7UMSFreeThreadProxyFactory@details@Concurrency@@6B@ 0053 ??0Transmogrificator@details@Concurrency@@QEAA@XZ 0090 ?CreateUmsCompletionList@UMS@details@Concurrency@@SAHPEAPEAX@Z 009a __imp_GetLastError 00a1 HRESULT_FROM_WIN32 00ad ??0scheduler_resource_allocation_error@Concurrency@@QEAA@J@Z 00b4 _TI2?AVscheduler_resource_allocation_error@Concurrency@@ 00be _CxxThrowException 00e3 ?GetUmsCompletionListEvent@UMS@details@Concurrency@@SAHPEAXPEAPEAX@Z 0139 ??_C@_0EB@BIJLEILF@f?3?2dd?2vctools?2crt_bld?2self_64_am@ 014b ??2@YAPEAX_KV_ConcRTNewMoniker@@PEBDH@Z 0162 ??0TransmogrifiedPrimary@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 57 48 81 EC 90 00 00 00 48 C7 44 24 48 FE FF FF FF 48 8B 94 24 A8 00 00 00 48 8B 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 90 48 8B 84 24 A0 00 00 00 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 84 24 A0 00 00 00 48 83 C0 60 48 8B C8 E8 ?? ?? ?? ?? 90 48 8B 84 24 A0 00 00 00 48 C7 80 B0 00 00 00 00 00 00 00 48 8B 84 24 A0 00 00 00 48 C7 80 B8 00 00 00 00 00 00 00 48 8B 84 24 A0 00 00 00 48 05 B0 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 75 2A FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B D0 48 8D 4C 24 50 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 50 E8 ?? ?? ?? ?? 48 8B 84 24 A0 00 00 00 48 05 B8 00 00 00 48 8B D0 48 8B 84 24 A0 00 00 00 48 8B 88 B0 00 00 00 E8 ?? ?? ?? ?? 85 C0 75 2A FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B D0 48 8D 4C 24 70 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 70 E8 ?? ?? ?? ?? 48 8D 44 24 20 48 8B F8 33 C0 B9 01 00 00 00 F3 AA 48 8D 44 24 20 48 89 44 24 38 41 B9 BF 01 00 00 4C 8D 05 ?? ?? ?? ?? 48 8B 44 24 38 0F B6 10 B9 80 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 28 48 83 7C 24 28 00 74 11 48 8B 4C 24 28 E8 ?? ?? ?? ?? 48 89 44 24 30 EB 09 48 C7 44 24 30 00 00 00 00 48 8B 44 24 30 48 89 44 24 40 48 8B 84 24 A0 00 00 00 48 8B 4C 24 40 48 89 48 50 48 8B 84 24 A0 00 00 00 48 81 C4 90 00 00 00 5F C3 }
	condition:
		$1
}

rule file_63_16_0 {
	meta:
		name = "?dtor$0@?0???0UMSFreeThreadProxyFactory@details@Concurrency@@IEAA@PEAVThreadProxyFactoryManager@12@@Z@4HA"
		size = 27
		refs = "0011 ??1?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 8D A0 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_84_75_2 {
	meta:
		name = "?dtor$1@?0???$_Distance@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@_K@std@@YAXV?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@0@0AEA_K@Z@4HA"
		size = 27
		refs = "0011 ??1?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 8D A0 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_92_104_3 {
	meta:
		name = "?dtor$1@?0???$_Distance@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@_K@std@@YAXV?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@0@0AEA_K@Z@4HA"
		size = 27
		refs = "0011 ??1?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 8D A0 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_105_95_2 {
	meta:
		name = "?dtor$3@?0???$_Insert@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@@?$vector@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@2@@std@@QEAAXV?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@1@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@1@1Uforward_iterator_tag@1@@Z@4HA"
		size = 27
		refs = "0011 ??1?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 8D A0 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_105_104_2 {
	meta:
		name = "?dtor$3@?0???$_Insert@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@@?$vector@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@2@@std@@QEAAXV?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@1@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@1@1Uforward_iterator_tag@1@@Z@4HA"
		size = 27
		refs = "0011 ??1?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 8D A0 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_43_532_3 {
	meta:
		name = "?dtor$9@?0??replace@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@V?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@2@0V?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@2@1@Z@4HA"
		size = 27
		refs = "0011 ??1?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 8D A0 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_36_1280_2 {
	meta:
		name = "?dtor$9@?0??replace@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEAAAEAV12@V?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@2@0V?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@2@1@Z@4HA"
		size = 27
		refs = "0011 ??1?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 8D A0 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_66_1328_3 {
	meta:
		name = "?dtor$9@?0??replace@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAAAEAV12@V?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@2@0V?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@2@1@Z@4HA"
		size = 27
		refs = "0011 ??1?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 8D A0 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_63_17_0 {
	meta:
		name = "?dtor$1@?0???0UMSFreeThreadProxyFactory@details@Concurrency@@IEAA@PEAVThreadProxyFactoryManager@12@@Z@4HA"
		size = 31
		refs = "0015 ??1Transmogrificator@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 8D A0 00 00 00 48 83 C1 60 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_265_16_0 {
	meta:
		name = "?dtor$0@?0???0_TaskCollection@details@Concurrency@@AEAA@PEAV012@_N@Z@4HA"
		size = 31
		refs = "0015 ??1event@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 8D A0 00 00 00 48 83 C1 60 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_63_18_0 {
	meta:
		name = "?dtor$2@?0???0UMSFreeThreadProxyFactory@details@Concurrency@@IEAA@PEAVThreadProxyFactoryManager@12@@Z@4HA"
		size = 44
		refs = "0012 ??_C@_0EB@BIJLEILF@f?3?2dd?2vctools?2crt_bld?2self_64_am@ 0022 ??3@YAXPEAXV_ConcRTNewMoniker@@PEBDH@Z"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 41 B9 BF 01 00 00 4C 8D 05 ?? ?? ?? ?? 48 8B 45 38 0F B6 10 48 8B 4D 28 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_63_19_0 {
	meta:
		name = "??0_Scoped_lock@_NonReentrantBlockingLock@details@Concurrency@@QEAA@AEAV123@@Z"
		size = 50
		refs = "0024 ?_Acquire@_NonReentrantBlockingLock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 4C 24 38 48 89 08 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_491_4_0 {
	meta:
		name = "??0ScopedCriticalRegion@ContextBase@details@Concurrency@@QEAA@PEAV123@@Z"
		size = 50
		refs = "0024 ?EnterCriticalRegion@ContextBase@details@Concurrency@@QEAAHXZ"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 4C 24 38 48 89 08 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_606_9_0 {
	meta:
		name = "??0_Scoped_lock@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QEAA@AEAV123@@Z"
		size = 50
		refs = "0024 ?AcquireWrite@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QEBAXXZ"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 4C 24 38 48 89 08 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_268_17_0 {
	meta:
		name = "??0_Scoped_lock@_CriticalNonReentrantLock@details@Concurrency@@QEAA@AEAV123@@Z"
		size = 50
		refs = "0024 ?_Acquire@_CriticalNonReentrantLock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 4C 24 38 48 89 08 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_67_12_0 {
	meta:
		name = "??0_Scoped_lock@_HyperNonReentrantLock@details@Concurrency@@QEAA@AEAV123@@Z"
		size = 50
		refs = "0024 ?_Acquire@_HyperNonReentrantLock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 4C 24 38 48 89 08 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1091_7_0 {
	meta:
		name = "??0_Scoped_lock@_NonReentrantLock@details@Concurrency@@QEAA@AEAV123@@Z"
		size = 50
		refs = "0024 ?_Acquire@_NonReentrantLock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 4C 24 38 48 89 08 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_477_3_0 {
	meta:
		name = "??0_Scoped_lock@_ReaderWriterLock@details@Concurrency@@QEAA@AEAV123@@Z"
		size = 50
		refs = "0024 ?_AcquireWrite@_ReaderWriterLock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 4C 24 38 48 89 08 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1003_6_0 {
	meta:
		name = "??0_Scoped_lock@_ReentrantBlockingLock@details@Concurrency@@QEAA@AEAV123@@Z"
		size = 50
		refs = "0024 ?_Acquire@_ReentrantBlockingLock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 4C 24 38 48 89 08 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_268_19_0 {
	meta:
		name = "??0_Scoped_lock_read@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QEAA@AEAV123@@Z"
		size = 50
		refs = "0024 ?AcquireRead@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QEBAXXZ"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 4C 24 38 48 89 08 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_279_25_0 {
	meta:
		name = "??0scoped_lock_read@reader_writer_lock@Concurrency@@QEAA@AEAV12@@Z"
		size = 50
		refs = "0024 ?lock_read@reader_writer_lock@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 4C 24 38 48 89 08 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_63_20_0 {
	meta:
		name = "??0scheduler_resource_allocation_error@Concurrency@@QEAA@AEBV01@@Z"
		size = 70
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7scheduler_resource_allocation_error@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 8B 4C 24 38 8B 49 18 89 48 18 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_30_36_1 {
	meta:
		name = "??0regex_error@std@@QEAA@AEBV01@@Z"
		size = 70
		refs = "0019 ??0runtime_error@std@@QEAA@AEBV01@@Z 0025 ??_7regex_error@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 8B 4C 24 38 8B 49 18 89 48 18 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_63_21_0 {
	meta:
		name = "??1?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@UEAA@XZ"
		size = 39
		refs = "0011 ??_7?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@6B@ 001e ??1IThreadProxyFactory@details@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_63_22_0 {
	meta:
		name = "??1?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@UEAA@XZ"
		size = 39
		refs = "0011 ??_7?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@6B@ 001e ??1IThreadProxyFactory@details@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_61_434_2 {
	meta:
		name = "??1?$_Func_impl@U?$_Callable_fun@Q6A_NAEBW4agent_status@Concurrency@@@Z$0A@@std@@V?$allocator@V?$_Func_class@_NAEBW4agent_status@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@@2@_NAEBW4agent_status@Concurrency@@U_Nil@2@U62@U62@U62@U62@U62@@std@@UEAA@XZ"
		size = 39
		refs = "0011 ??_7?$_Func_impl@U?$_Callable_fun@Q6A_NAEBW4agent_status@Concurrency@@@Z$0A@@std@@V?$allocator@V?$_Func_class@_NAEBW4agent_status@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@@2@_NAEBW4agent_status@Concurrency@@U_Nil@2@U62@U62@U62@U62@U62@@std@@6B@ 001e ??1?$_Func_base@_NAEBW4agent_status@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_10_98_2 {
	meta:
		name = "??1?$basic_ios@DU?$char_traits@D@std@@@std@@UEAA@XZ"
		size = 39
		refs = "0011 ??_7?$basic_ios@DU?$char_traits@D@std@@@std@@6B@ 001e ??1ios_base@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_76_97_2 {
	meta:
		name = "??1?$basic_ios@GU?$char_traits@G@std@@@std@@UEAA@XZ"
		size = 39
		refs = "0011 ??_7?$basic_ios@GU?$char_traits@G@std@@@std@@6B@ 001e ??1ios_base@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_53_97_2 {
	meta:
		name = "??1?$basic_ios@_WU?$char_traits@_W@std@@@std@@UEAA@XZ"
		size = 39
		refs = "0011 ??_7?$basic_ios@_WU?$char_traits@_W@std@@@std@@6B@ 001e ??1ios_base@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_60_102_2 {
	meta:
		name = "??1?$codecvt@DDH@std@@MEAA@XZ"
		size = 39
		refs = "0011 ??_7?$codecvt@DDH@std@@6B@ 001e ??1codecvt_base@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_71_81_1 {
	meta:
		name = "??1?$codecvt@GDH@std@@MEAA@XZ"
		size = 39
		refs = "0011 ??_7?$codecvt@GDH@std@@6B@ 001e ??1codecvt_base@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_95_101_2 {
	meta:
		name = "??1?$codecvt@_WDH@std@@MEAA@XZ"
		size = 39
		refs = "0011 ??_7?$codecvt@_WDH@std@@6B@ 001e ??1codecvt_base@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_92_146_2 {
	meta:
		name = "??1?$messages@D@std@@MEAA@XZ"
		size = 39
		refs = "0011 ??_7?$messages@D@std@@6B@ 001e ??1messages_base@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_36_339_2 {
	meta:
		name = "??1?$messages@G@std@@MEAA@XZ"
		size = 39
		refs = "0011 ??_7?$messages@G@std@@6B@ 001e ??1messages_base@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_66_374_3 {
	meta:
		name = "??1?$messages@_W@std@@MEAA@XZ"
		size = 39
		refs = "0011 ??_7?$messages@_W@std@@6B@ 001e ??1messages_base@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_92_147_2 {
	meta:
		name = "??1?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEAA@XZ"
		size = 39
		refs = "0011 ??_7?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@ 001e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_66_375_3 {
	meta:
		name = "??1?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEAA@XZ"
		size = 39
		refs = "0011 ??_7?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@ 001e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_28_275_1 {
	meta:
		name = "??1?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEAA@XZ"
		size = 39
		refs = "0011 ??_7?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@ 001e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_92_148_2 {
	meta:
		name = "??1?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEAA@XZ"
		size = 39
		refs = "0011 ??_7?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@ 001e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_66_377_3 {
	meta:
		name = "??1?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEAA@XZ"
		size = 39
		refs = "0011 ??_7?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@ 001e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_66_378_3 {
	meta:
		name = "??1?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEAA@XZ"
		size = 39
		refs = "0011 ??_7?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@ 001e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_43_160_3 {
	meta:
		name = "??1?$moneypunct@D$00@std@@MEAA@XZ"
		size = 39
		refs = "0011 ??_7?$moneypunct@D$00@std@@6B@ 001e ??1?$_Mpunct@D@std@@MEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_43_161_3 {
	meta:
		name = "??1?$moneypunct@D$0A@@std@@MEAA@XZ"
		size = 39
		refs = "0011 ??_7?$moneypunct@D$0A@@std@@6B@ 001e ??1?$_Mpunct@D@std@@MEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_66_379_3 {
	meta:
		name = "??1?$moneypunct@G$00@std@@MEAA@XZ"
		size = 39
		refs = "0011 ??_7?$moneypunct@G$00@std@@6B@ 001e ??1?$_Mpunct@G@std@@MEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_28_279_1 {
	meta:
		name = "??1?$moneypunct@G$0A@@std@@MEAA@XZ"
		size = 39
		refs = "0011 ??_7?$moneypunct@G$0A@@std@@6B@ 001e ??1?$_Mpunct@G@std@@MEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_36_347_2 {
	meta:
		name = "??1?$moneypunct@_W$00@std@@MEAA@XZ"
		size = 39
		refs = "0011 ??_7?$moneypunct@_W$00@std@@6B@ 001e ??1?$_Mpunct@_W@std@@MEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_66_382_3 {
	meta:
		name = "??1?$moneypunct@_W$0A@@std@@MEAA@XZ"
		size = 39
		refs = "0011 ??_7?$moneypunct@_W$0A@@std@@6B@ 001e ??1?$_Mpunct@_W@std@@MEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_100_83_1 {
	meta:
		name = "??1?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEAA@XZ"
		size = 39
		refs = "0011 ??_7?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@ 001e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_28_282_1 {
	meta:
		name = "??1?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEAA@XZ"
		size = 39
		refs = "0011 ??_7?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@ 001e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_36_350_2 {
	meta:
		name = "??1?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEAA@XZ"
		size = 39
		refs = "0011 ??_7?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@ 001e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_39_107_3 {
	meta:
		name = "??1?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEAA@XZ"
		size = 39
		refs = "0011 ??_7?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@ 001e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_66_385_3 {
	meta:
		name = "??1?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEAA@XZ"
		size = 39
		refs = "0011 ??_7?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@ 001e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_36_352_2 {
	meta:
		name = "??1?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEAA@XZ"
		size = 39
		refs = "0011 ??_7?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@ 001e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_63_23_0 {
	meta:
		name = "??1FreeThreadProxy@details@Concurrency@@UEAA@XZ"
		size = 39
		refs = "0011 ??_7FreeThreadProxy@details@Concurrency@@6B@ 001e ??1ThreadProxy@details@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_63_24_0 {
	meta:
		name = "??1FreeThreadProxyFactory@details@Concurrency@@UEAA@XZ"
		size = 39
		refs = "0011 ??_7FreeThreadProxyFactory@details@Concurrency@@6B@ 001e ??1?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_192_3_0 {
	meta:
		name = "??1ThreadVirtualProcessor@details@Concurrency@@UEAA@XZ"
		size = 39
		refs = "0011 ??_7ThreadVirtualProcessor@details@Concurrency@@6B@ 001e ??1VirtualProcessor@details@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_771_10_0 {
	meta:
		name = "??1__non_rtti_object@std@@UEAA@XZ"
		size = 39
		refs = "0011 ??_7__non_rtti_object@std@@6B@ 001e ??1bad_typeid@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_85_56_2 {
	meta:
		name = "??1bad_alloc@std@@UEAA@XZ"
		size = 39
		refs = "0011 ??_7bad_alloc@std@@6B@ 001e ??1exception@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_771_11_0 {
	meta:
		name = "??1bad_cast@std@@UEAA@XZ"
		size = 39
		refs = "0011 ??_7bad_cast@std@@6B@ 001e ??1exception@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_637_60_0 {
	meta:
		name = "??1bad_exception@std@@UEAA@XZ"
		size = 39
		refs = "0011 ??_7bad_exception@std@@6B@ 001e ??1exception@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_771_12_0 {
	meta:
		name = "??1bad_typeid@std@@UEAA@XZ"
		size = 39
		refs = "0011 ??_7bad_typeid@std@@6B@ 001e ??1exception@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_120_127_3 {
	meta:
		name = "??1codecvt_base@std@@UEAA@XZ"
		size = 39
		refs = "0011 ??_7codecvt_base@std@@6B@ 001e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_40_111_2 {
	meta:
		name = "??1ctype_base@std@@UEAA@XZ"
		size = 39
		refs = "0011 ??_7ctype_base@std@@6B@ 001e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_771_13_0 {
	meta:
		name = "??1exception@std@@UEAA@XZ"
		size = 39
		refs = "0011 ??_7exception@std@@6B@ 001e ?_Tidy@exception@std@@AEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_39_118_3 {
	meta:
		name = "??1facet@locale@std@@MEAA@XZ"
		size = 39
		refs = "0011 ??_7facet@locale@std@@6B@ 001e ??1_Facet_base@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_122_121_3 {
	meta:
		name = "??1ios_base@std@@UEAA@XZ"
		size = 39
		refs = "0011 ??_7ios_base@std@@6B@ 001e ?_Ios_base_dtor@ios_base@std@@CAXPEAV12@@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_43_179_3 {
	meta:
		name = "??1time_base@std@@UEAA@XZ"
		size = 39
		refs = "0011 ??_7time_base@std@@6B@ 001e ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_285_1_0 {
	meta:
		name = "??1type_info@@UEAA@XZ"
		size = 39
		refs = "0011 ??_7type_info@@6B@ 001e ?_Type_info_dtor@type_info@@CAXPEAV1@@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_63_26_0 {
	meta:
		name = "??1IThreadProxyFactory@details@Concurrency@@UEAA@XZ"
		size = 21
		refs = "000d ??_7IThreadProxyFactory@details@Concurrency@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 89 08 C3 }
	condition:
		$1
}

rule file_78_412_1 {
	meta:
		name = "??1?$ISource@W4agent_status@Concurrency@@@Concurrency@@UEAA@XZ"
		size = 21
		refs = "000d ??_7?$ISource@W4agent_status@Concurrency@@@Concurrency@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 89 08 C3 }
	condition:
		$1
}

rule file_13_413_3 {
	meta:
		name = "??1?$ISource@_K@Concurrency@@UEAA@XZ"
		size = 21
		refs = "000d ??_7?$ISource@_K@Concurrency@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 89 08 C3 }
	condition:
		$1
}

rule file_78_414_1 {
	meta:
		name = "??1?$ITarget@W4agent_status@Concurrency@@@Concurrency@@UEAA@XZ"
		size = 21
		refs = "000d ??_7?$ITarget@W4agent_status@Concurrency@@@Concurrency@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 89 08 C3 }
	condition:
		$1
}

rule file_78_415_1 {
	meta:
		name = "??1?$ITarget@_K@Concurrency@@UEAA@XZ"
		size = 21
		refs = "000d ??_7?$ITarget@_K@Concurrency@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 89 08 C3 }
	condition:
		$1
}

rule file_61_424_2 {
	meta:
		name = "??1?$_Func_base@XAEB_KU_Nil@std@@U12@U12@U12@U12@U12@@std@@UEAA@XZ"
		size = 21
		refs = "000d ??_7?$_Func_base@XAEB_KU_Nil@std@@U12@U12@U12@U12@U12@@std@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 89 08 C3 }
	condition:
		$1
}

rule file_13_425_3 {
	meta:
		name = "??1?$_Func_base@XPEAV?$message@W4agent_status@Concurrency@@@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@UEAA@XZ"
		size = 21
		refs = "000d ??_7?$_Func_base@XPEAV?$message@W4agent_status@Concurrency@@@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 89 08 C3 }
	condition:
		$1
}

rule file_13_426_3 {
	meta:
		name = "??1?$_Func_base@XPEAV?$message@_K@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@UEAA@XZ"
		size = 21
		refs = "000d ??_7?$_Func_base@XPEAV?$message@_K@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 89 08 C3 }
	condition:
		$1
}

rule file_92_490_3 {
	meta:
		name = "??1?$_Func_base@XU_Nil@std@@U12@U12@U12@U12@U12@U12@@std@@UEAA@XZ"
		size = 21
		refs = "000d ??_7?$_Func_base@XU_Nil@std@@U12@U12@U12@U12@U12@U12@@std@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 89 08 C3 }
	condition:
		$1
}

rule file_61_427_2 {
	meta:
		name = "??1?$_Func_base@_NAEBW4agent_status@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@UEAA@XZ"
		size = 21
		refs = "000d ??_7?$_Func_base@_NAEBW4agent_status@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 89 08 C3 }
	condition:
		$1
}

rule file_61_475_2 {
	meta:
		name = "??1?$message@W4agent_status@Concurrency@@@Concurrency@@UEAA@XZ"
		size = 21
		refs = "000d ??_7?$message@W4agent_status@Concurrency@@@Concurrency@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 89 08 C3 }
	condition:
		$1
}

rule file_78_476_1 {
	meta:
		name = "??1?$message@_K@Concurrency@@UEAA@XZ"
		size = 21
		refs = "000d ??_7?$message@_K@Concurrency@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 89 08 C3 }
	condition:
		$1
}

rule file_996_13_0 {
	meta:
		name = "??1Context@Concurrency@@MEAA@XZ"
		size = 21
		refs = "000d ??_7Context@Concurrency@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 89 08 C3 }
	condition:
		$1
}

rule file_439_89_0 {
	meta:
		name = "??1ScheduleGroup@Concurrency@@MEAA@XZ"
		size = 21
		refs = "000d ??_7ScheduleGroup@Concurrency@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 89 08 C3 }
	condition:
		$1
}

rule file_439_92_0 {
	meta:
		name = "??1Scheduler@Concurrency@@MEAA@XZ"
		size = 21
		refs = "000d ??_7Scheduler@Concurrency@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 89 08 C3 }
	condition:
		$1
}

rule file_726_5_0 {
	meta:
		name = "??1UMSSchedulingContext@details@Concurrency@@QEAA@XZ"
		size = 21
		refs = "000d ??_7UMSSchedulingContext@details@Concurrency@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 89 08 C3 }
	condition:
		$1
}

rule file_439_107_0 {
	meta:
		name = "??1_Chore@details@Concurrency@@MEAA@XZ"
		size = 21
		refs = "000d ??_7_Chore@details@Concurrency@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 89 08 C3 }
	condition:
		$1
}

rule file_45_121_3 {
	meta:
		name = "??1_Facet_base@std@@UEAA@XZ"
		size = 21
		refs = "000d ??_7_Facet_base@std@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 89 08 C3 }
	condition:
		$1
}

rule file_92_545_3 {
	meta:
		name = "??1_Ref_count_base@std@@UEAA@XZ"
		size = 21
		refs = "000d ??_7_Ref_count_base@std@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 89 08 C3 }
	condition:
		$1
}

rule file_5_390_1 {
	meta:
		name = "??1error_category@std@@UEAA@XZ"
		size = 21
		refs = "000d ??_7error_category@std@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 89 08 C3 }
	condition:
		$1
}

rule file_63_27_0 {
	meta:
		name = "??1ThreadProxyFactoryManager@details@Concurrency@@QEAA@XZ"
		size = 124
		refs = "0061 __imp_TlsFree 0073 ??1_NonReentrantBlockingLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 44 24 40 48 83 38 00 74 16 48 8B 44 24 40 48 8B 00 48 8B 4C 24 40 48 8B 09 48 8B 00 FF 50 30 48 8B 44 24 40 48 83 78 08 00 74 18 48 8B 44 24 40 48 8B 40 08 48 8B 4C 24 40 48 8B 49 08 48 8B 00 FF 50 30 48 8B 44 24 40 8B 48 10 FF 15 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_63_28_0 {
	meta:
		name = "?dtor$0@?0???1ThreadProxyFactoryManager@details@Concurrency@@QEAA@XZ@4HA"
		size = 28
		refs = "0012 ??1_NonReentrantBlockingLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 48 83 C1 18 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_78_355_1 {
	meta:
		name = "?dtor$1@?0???0?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@QEAA@XZ@4HA"
		size = 28
		refs = "0012 ??1?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 48 83 C1 18 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_78_360_1 {
	meta:
		name = "?dtor$1@?0???0?$source_block@V?$multi_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@V?$ordered_message_processor@_K@2@@Concurrency@@QEAA@XZ@4HA"
		size = 28
		refs = "0012 ??1?$multi_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 48 83 C1 18 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_78_365_1 {
	meta:
		name = "?dtor$1@?0???0?$source_block@V?$single_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@V?$ordered_message_processor@_K@2@@Concurrency@@QEAA@XZ@4HA"
		size = 28
		refs = "0012 ??1?$single_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 48 83 C1 18 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_63_29_0 {
	meta:
		name = "??1UMSFreeThreadProxy@details@Concurrency@@UEAA@XZ"
		size = 71
		refs = "0011 ??_7UMSFreeThreadProxy@details@Concurrency@@6BUMSBaseObject@12@@ 0020 ??_7UMSFreeThreadProxy@details@Concurrency@@6BIUMSThreadProxy@2@@ 0030 ??_7UMSFreeThreadProxy@details@Concurrency@@6BIUMSUnblockNotification@2@@ 003e ??1UMSThreadProxy@details@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 48 08 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 48 10 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_63_30_0 {
	meta:
		name = "??1UMSFreeThreadProxyFactory@details@Concurrency@@UEAA@XZ"
		size = 66
		refs = "001a ??_7UMSFreeThreadProxyFactory@details@Concurrency@@6B@ 002e ??1Transmogrificator@details@Concurrency@@QEAA@XZ 0039 ??1?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 40 48 83 C0 60 48 8B C8 E8 ?? ?? ?? ?? 90 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_63_32_0 {
	meta:
		name = "??1_Scoped_lock@_NonReentrantBlockingLock@details@Concurrency@@QEAA@XZ"
		size = 27
		refs = "0012 ?_Release@_NonReentrantBlockingLock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_491_27_0 {
	meta:
		name = "??1ScopedCriticalRegion@ContextBase@details@Concurrency@@QEAA@XZ"
		size = 27
		refs = "0012 ?ExitCriticalRegion@ContextBase@details@Concurrency@@QEAAHXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_606_18_0 {
	meta:
		name = "??1_Scoped_lock@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QEAA@XZ"
		size = 27
		refs = "0012 ?ReleaseWrite@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QEBAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_268_37_0 {
	meta:
		name = "??1_Scoped_lock@_CriticalNonReentrantLock@details@Concurrency@@QEAA@XZ"
		size = 27
		refs = "0012 ?_Release@_CriticalNonReentrantLock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_67_22_0 {
	meta:
		name = "??1_Scoped_lock@_HyperNonReentrantLock@details@Concurrency@@QEAA@XZ"
		size = 27
		refs = "0012 ?_Release@_HyperNonReentrantLock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_171_36_0 {
	meta:
		name = "??1_Scoped_lock@_NonReentrantLock@details@Concurrency@@QEAA@XZ"
		size = 27
		refs = "0012 ?_Release@_NonReentrantLock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_279_29_0 {
	meta:
		name = "??1_Scoped_lock@_NonReentrantPPLLock@details@Concurrency@@QEAA@XZ"
		size = 27
		refs = "0012 ?_Release@_NonReentrantPPLLock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_439_110_0 {
	meta:
		name = "??1_Scoped_lock@_ReaderWriterLock@details@Concurrency@@QEAA@XZ"
		size = 27
		refs = "0012 ?_ReleaseWrite@_ReaderWriterLock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1003_15_0 {
	meta:
		name = "??1_Scoped_lock@_ReentrantBlockingLock@details@Concurrency@@QEAA@XZ"
		size = 27
		refs = "0012 ?_Release@_ReentrantBlockingLock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_279_30_0 {
	meta:
		name = "??1_Scoped_lock@_ReentrantPPLLock@details@Concurrency@@QEAA@XZ"
		size = 27
		refs = "0012 ?_Release@_ReentrantPPLLock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_268_39_0 {
	meta:
		name = "??1_Scoped_lock_read@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QEAA@XZ"
		size = 27
		refs = "0012 ?ReleaseRead@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QEBAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_66_400_3 {
	meta:
		name = "??1_Timevec@std@@QEAA@XZ"
		size = 27
		refs = "0012 free"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_279_35_0 {
	meta:
		name = "??1scoped_lock@critical_section@Concurrency@@QEAA@XZ"
		size = 27
		refs = "0012 ?unlock@critical_section@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_279_36_0 {
	meta:
		name = "??1scoped_lock@reader_writer_lock@Concurrency@@QEAA@XZ"
		size = 27
		refs = "0012 ?unlock@reader_writer_lock@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_279_37_0 {
	meta:
		name = "??1scoped_lock_read@reader_writer_lock@Concurrency@@QEAA@XZ"
		size = 27
		refs = "0012 ?unlock@reader_writer_lock@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_439_344_0 {
	meta:
		name = "?Next@?$LockFreePushStack@VContextNode@SchedulerBase@details@Concurrency@@@details@Concurrency@@SAPEAVContextNode@SchedulerBase@23@PEAV4523@@Z"
		size = 27
		refs = "0012 ?Delta@?$LockFreePushStack@VContextNode@SchedulerBase@details@Concurrency@@@details@Concurrency@@CAPEAVContextNode@SchedulerBase@23@PEAX@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_439_449_0 {
	meta:
		name = "?Unsafe_Top@?$LockFreePushStack@VContextNode@SchedulerBase@details@Concurrency@@@details@Concurrency@@QEAAPEAVContextNode@SchedulerBase@23@XZ"
		size = 27
		refs = "0012 ?Delta@?$LockFreePushStack@VContextNode@SchedulerBase@details@Concurrency@@@details@Concurrency@@CAPEAVContextNode@SchedulerBase@23@PEAX@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_5_88_2 {
	meta:
		name = "?cancel@cancellation_token_source@Concurrency@@QEBAXXZ"
		size = 27
		refs = "0012 ?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_63_35_0 {
	meta:
		name = "??3@YAXPEAXV_ConcRTNewMoniker@@PEBDH@Z"
		size = 38
		refs = "001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 44 89 4C 24 20 4C 89 44 24 18 88 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_171_58_0 {
	meta:
		name = "??_V@YAXPEAXV_ConcRTNewMoniker@@PEBDH@Z"
		size = 38
		refs = "001d ??_V@YAXPEAX@Z"
	strings:
		$1 = { 44 89 4C 24 20 4C 89 44 24 18 88 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_63_48_0 {
	meta:
		name = "?ClearCriticalRegion@UMSThreadProxy@details@Concurrency@@QEAAXXZ"
		size = 36
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 C7 80 90 00 00 00 00 00 00 00 48 8B 44 24 08 C7 80 8C 00 00 00 00 00 00 00 C3 }
	condition:
		$1
}

rule file_63_49_0 {
	meta:
		name = "?Count@?$LockFreeStack@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@QEBAHXZ"
		size = 31
		refs = "0013 __imp_QueryDepthSList"
		altNames = "?Count@?$LockFreeStack@VExternalContextBase@details@Concurrency@@@details@Concurrency@@QEBAHXZ ?Count@?$LockFreeStack@VRealizedChore@details@Concurrency@@@details@Concurrency@@QEBAHXZ ?Count@?$LockFreeStack@VSubAllocator@details@Concurrency@@@details@Concurrency@@QEBAHXZ ?Count@?$LockFreeStack@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@QEBAHXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B C8 FF 15 ?? ?? ?? ?? 0F B7 C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_63_51_0 {
	meta:
		name = "?Create@FreeThreadProxyFactory@details@Concurrency@@EEAAPEAVFreeThreadProxy@23@I@Z"
		size = 151
		refs = "003b ??_C@_0EB@BIJLEILF@f?3?2dd?2vctools?2crt_bld?2self_64_am@ 004d ??2@YAPEAX_KV_ConcRTNewMoniker@@PEBDH@Z 006e ??0FreeThreadProxy@details@Concurrency@@QEAA@PEAUIThreadProxyFactory@12@I@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 57 48 83 EC 50 48 C7 44 24 48 FE FF FF FF 48 8D 44 24 20 48 8B F8 33 C0 B9 01 00 00 00 F3 AA 48 8D 44 24 20 48 89 44 24 38 41 B9 53 01 00 00 4C 8D 05 ?? ?? ?? ?? 48 8B 44 24 38 0F B6 10 B9 80 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 28 48 83 7C 24 28 00 74 1B 44 8B 44 24 68 48 8B 54 24 60 48 8B 4C 24 28 E8 ?? ?? ?? ?? 48 89 44 24 30 EB 09 48 C7 44 24 30 00 00 00 00 48 8B 44 24 30 48 89 44 24 40 48 8B 44 24 40 48 83 C4 50 5F C3 }
	condition:
		$1
}

rule file_63_52_0 {
	meta:
		name = "?dtor$0@?0??Create@FreeThreadProxyFactory@details@Concurrency@@EEAAPEAVFreeThreadProxy@23@I@Z@4HA"
		size = 44
		refs = "0012 ??_C@_0EB@BIJLEILF@f?3?2dd?2vctools?2crt_bld?2self_64_am@ 0022 ??3@YAXPEAXV_ConcRTNewMoniker@@PEBDH@Z"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 41 B9 53 01 00 00 4C 8D 05 ?? ?? ?? ?? 48 8B 45 38 0F B6 10 48 8B 4D 28 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_63_53_0 {
	meta:
		name = "?Create@UMSFreeThreadProxyFactory@details@Concurrency@@EEAAPEAVUMSFreeThreadProxy@23@I@Z"
		size = 524
		refs = "0041 ??_C@_0EB@BIJLEILF@f?3?2dd?2vctools?2crt_bld?2self_64_am@ 0053 ??2@YAPEAX_KV_ConcRTNewMoniker@@PEBDH@Z 0089 ??0UMSFreeThreadProxy@details@Concurrency@@QEAA@PEAUIThreadProxyFactory@12@PEAXI@Z 010b __imp_WaitForMultipleObjectsEx 013b ?DequeueUmsCompletionListItems@UMS@details@Concurrency@@SAHPEAXKPEAPEAX@Z 0192 __imp_GetLastError 0199 HRESULT_FROM_WIN32 01a8 ??0scheduler_resource_allocation_error@Concurrency@@QEAA@J@Z 01af _TI2?AVscheduler_resource_allocation_error@Concurrency@@ 01bc _CxxThrowException 01ce ?FromUMSContext@UMSFreeThreadProxy@details@Concurrency@@SAPEAV123@PEAX@Z 01dd ?GetNextUmsListItem@UMS@details@Concurrency@@SAPEAXPEAX@Z 01f8 ?QueueToCompletion@TransmogrifiedPrimary@details@Concurrency@@QEAAXPEAVUMSThreadProxy@23@@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 57 48 81 EC D0 00 00 00 48 C7 84 24 A0 00 00 00 FE FF FF FF 48 8D 44 24 30 48 8B F8 33 C0 B9 01 00 00 00 F3 AA 48 8D 44 24 30 48 89 44 24 68 41 B9 CB 01 00 00 4C 8D 05 ?? ?? ?? ?? 48 8B 44 24 68 0F B6 10 B9 30 01 00 00 E8 ?? ?? ?? ?? 48 89 44 24 58 48 83 7C 24 58 00 74 30 44 8B 8C 24 E8 00 00 00 48 8B 84 24 E0 00 00 00 4C 8B 80 B0 00 00 00 48 8B 94 24 E0 00 00 00 48 8B 4C 24 58 E8 ?? ?? ?? ?? 48 89 44 24 60 EB 09 48 C7 44 24 60 00 00 00 00 48 8B 44 24 60 48 89 44 24 78 48 8B 44 24 78 48 89 44 24 40 B8 08 00 00 00 48 6B C0 00 48 8B 4C 24 40 48 8B 49 30 48 89 8C 04 90 00 00 00 B8 08 00 00 00 48 6B C0 01 48 8B 8C 24 E0 00 00 00 48 8B 89 B8 00 00 00 48 89 8C 04 90 00 00 00 C7 44 24 20 00 00 00 00 41 B9 FF FF FF FF 45 33 C0 48 8D 94 24 90 00 00 00 B9 02 00 00 00 FF 15 ?? ?? ?? ?? 89 44 24 50 83 7C 24 50 00 75 0A 48 8B 44 24 40 E9 DF 00 00 00 4C 8D 44 24 38 33 D2 48 8B 84 24 E0 00 00 00 48 8B 88 B0 00 00 00 E8 ?? ?? ?? ?? 85 C0 75 7D 48 8B 44 24 40 48 89 84 24 80 00 00 00 48 8B 84 24 80 00 00 00 48 89 44 24 48 48 83 7C 24 48 00 74 1F 48 8B 44 24 48 48 8B 00 BA 01 00 00 00 48 8B 4C 24 48 FF 50 08 48 89 84 24 88 00 00 00 EB 0C 48 C7 84 24 88 00 00 00 00 00 00 00 FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B D0 48 8D 8C 24 A8 00 00 00 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 8C 24 A8 00 00 00 E8 ?? ?? ?? ?? 48 83 7C 24 38 00 74 36 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 89 44 24 70 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 89 44 24 38 48 8B 54 24 70 48 8B 84 24 E0 00 00 00 48 8B 48 50 E8 ?? ?? ?? ?? EB C2 E9 E8 FE FF FF 48 81 C4 D0 00 00 00 5F C3 }
	condition:
		$1
}

rule file_63_54_0 {
	meta:
		name = "?dtor$0@?0??Create@UMSFreeThreadProxyFactory@details@Concurrency@@EEAAPEAVUMSFreeThreadProxy@23@I@Z@4HA"
		size = 44
		refs = "0012 ??_C@_0EB@BIJLEILF@f?3?2dd?2vctools?2crt_bld?2self_64_am@ 0022 ??3@YAXPEAXV_ConcRTNewMoniker@@PEBDH@Z"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 41 B9 CB 01 00 00 4C 8D 05 ?? ?? ?? ?? 48 8B 45 68 0F B6 10 48 8B 4D 58 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_63_55_0 {
	meta:
		name = "?CreateFactory@FreeThreadProxyFactory@details@Concurrency@@SAPEAV123@PEAVThreadProxyFactoryManager@23@@Z"
		size = 147
		refs = "0014 ?StaticInitialize@?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@KAXXZ 003c ??_C@_0EB@BIJLEILF@f?3?2dd?2vctools?2crt_bld?2self_64_am@ 004e ??2@YAPEAX_KV_ConcRTNewMoniker@@PEBDH@Z 006a ??0FreeThreadProxyFactory@details@Concurrency@@IEAA@PEAVThreadProxyFactoryManager@12@@Z"
	strings:
		$1 = { 48 89 4C 24 08 57 48 83 EC 50 48 C7 44 24 48 FE FF FF FF E8 ?? ?? ?? ?? 48 8D 44 24 20 48 8B F8 33 C0 B9 01 00 00 00 F3 AA 48 8D 44 24 20 48 89 44 24 38 41 B9 E3 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8B 44 24 38 0F B6 10 B9 60 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 28 48 83 7C 24 28 00 74 16 48 8B 54 24 60 48 8B 4C 24 28 E8 ?? ?? ?? ?? 48 89 44 24 30 EB 09 48 C7 44 24 30 00 00 00 00 48 8B 44 24 30 48 89 44 24 40 48 8B 44 24 40 48 83 C4 50 5F C3 }
	condition:
		$1
}

rule file_63_56_0 {
	meta:
		name = "?dtor$0@?0??CreateFactory@FreeThreadProxyFactory@details@Concurrency@@SAPEAV123@PEAVThreadProxyFactoryManager@23@@Z@4HA"
		size = 44
		refs = "0012 ??_C@_0EB@BIJLEILF@f?3?2dd?2vctools?2crt_bld?2self_64_am@ 0022 ??3@YAXPEAXV_ConcRTNewMoniker@@PEBDH@Z"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 41 B9 E3 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8B 45 38 0F B6 10 48 8B 4D 28 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_63_57_0 {
	meta:
		name = "?CreateFactory@UMSFreeThreadProxyFactory@details@Concurrency@@SAPEAV123@PEAVThreadProxyFactoryManager@23@@Z"
		size = 147
		refs = "0014 ?StaticInitialize@?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@KAXXZ 003c ??_C@_0EB@BIJLEILF@f?3?2dd?2vctools?2crt_bld?2self_64_am@ 004e ??2@YAPEAX_KV_ConcRTNewMoniker@@PEBDH@Z 006a ??0UMSFreeThreadProxyFactory@details@Concurrency@@IEAA@PEAVThreadProxyFactoryManager@12@@Z"
	strings:
		$1 = { 48 89 4C 24 08 57 48 83 EC 50 48 C7 44 24 48 FE FF FF FF E8 ?? ?? ?? ?? 48 8D 44 24 20 48 8B F8 33 C0 B9 01 00 00 00 F3 AA 48 8D 44 24 20 48 89 44 24 38 41 B9 73 01 00 00 4C 8D 05 ?? ?? ?? ?? 48 8B 44 24 38 0F B6 10 B9 C0 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 28 48 83 7C 24 28 00 74 16 48 8B 54 24 60 48 8B 4C 24 28 E8 ?? ?? ?? ?? 48 89 44 24 30 EB 09 48 C7 44 24 30 00 00 00 00 48 8B 44 24 30 48 89 44 24 40 48 8B 44 24 40 48 83 C4 50 5F C3 }
	condition:
		$1
}

rule file_63_58_0 {
	meta:
		name = "?dtor$0@?0??CreateFactory@UMSFreeThreadProxyFactory@details@Concurrency@@SAPEAV123@PEAVThreadProxyFactoryManager@23@@Z@4HA"
		size = 44
		refs = "0012 ??_C@_0EB@BIJLEILF@f?3?2dd?2vctools?2crt_bld?2self_64_am@ 0022 ??3@YAXPEAXV_ConcRTNewMoniker@@PEBDH@Z"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 41 B9 73 01 00 00 4C 8D 05 ?? ?? ?? ?? 48 8B 45 38 0F B6 10 48 8B 4D 28 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_63_59_0 {
	meta:
		name = "?Delta@?$LockFreeStack@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@CAPEAVFreeThreadProxy@23@PEAX@Z"
		size = 49
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 18 48 83 7C 24 20 00 75 0A 48 C7 04 24 00 00 00 00 EB 0D 48 8B 44 24 20 48 83 E8 60 48 89 04 24 48 8B 04 24 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_63_60_0 {
	meta:
		name = "?Delta@?$LockFreeStack@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@CAPEAVUMSFreeThreadProxy@23@PEAX@Z"
		size = 51
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 18 48 83 7C 24 20 00 75 0A 48 C7 04 24 00 00 00 00 EB 0F 48 8B 44 24 20 48 2D 10 01 00 00 48 89 04 24 48 8B 04 24 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_63_61_0 {
	meta:
		name = "?EnterCriticalRegion@UMSThreadProxy@details@Concurrency@@UEAAHXZ"
		size = 96
		refs = "000a ?GetCurrent@UMSThreadProxy@details@Concurrency@@SAPEAV123@XZ 0027 ??_C@_0DN@OEELINLA@f?3?2dd?2vctools?2crt_bld?2self_64_am@ 002e ??_C@_0CF@CMDNGDOH@UMSThreadProxy?3?3GetCurrent?$CI?$CJ?5?$DN?$DN?5@ 0033 ?_ConcRT_CoreAssert@details@Concurrency@@YAXPEBD0H@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 E8 ?? ?? ?? ?? 48 8B 4C 24 40 48 83 E9 08 48 3B C1 75 02 EB 19 41 B8 AD 00 00 00 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 44 24 40 8B 80 84 00 00 00 FF C0 89 44 24 20 48 8B 44 24 40 8B 4C 24 20 89 88 84 00 00 00 8B 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_63_62_0 {
	meta:
		name = "?EnterHyperCriticalRegion@UMSThreadProxy@details@Concurrency@@UEAAHXZ"
		size = 77
		refs = "000a ?GetCurrent@UMSThreadProxy@details@Concurrency@@SAPEAV123@XZ 0027 ??_C@_0DN@OEELINLA@f?3?2dd?2vctools?2crt_bld?2self_64_am@ 002e ??_C@_0CF@CMDNGDOH@UMSThreadProxy?3?3GetCurrent?$CI?$CJ?5?$DN?$DN?5@ 0033 ?_ConcRT_CoreAssert@details@Concurrency@@YAXPEBD0H@Z 0044 ?ForceEnterHyperCriticalRegion@UMSThreadProxy@details@Concurrency@@QEAAHXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 E8 ?? ?? ?? ?? 48 8B 4C 24 30 48 83 E9 08 48 3B C1 75 02 EB 19 41 B8 D9 00 00 00 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 E8 08 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_63_63_0 {
	meta:
		name = "?ExitCriticalRegion@UMSThreadProxy@details@Concurrency@@UEAAHXZ"
		size = 91
		refs = "0022 ??_C@_0DN@OEELINLA@f?3?2dd?2vctools?2crt_bld?2self_64_am@ 0029 ??_C@_0BK@KHDLBAFP@m_criticalRegionCount?5?$DO?50?$AA@ 002e ?_ConcRT_CoreAssert@details@Concurrency@@YAXPEBD0H@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 83 B8 84 00 00 00 00 76 02 EB 19 41 B8 BC 00 00 00 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 44 24 40 8B 80 84 00 00 00 FF C8 89 44 24 20 48 8B 44 24 40 8B 4C 24 20 89 88 84 00 00 00 8B 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_63_64_0 {
	meta:
		name = "?ExitHyperCriticalRegion@UMSThreadProxy@details@Concurrency@@UEAAHXZ"
		size = 164
		refs = "0022 ??_C@_0DN@OEELINLA@f?3?2dd?2vctools?2crt_bld?2self_64_am@ 0029 ??_C@_0BP@KFKOBDFI@m_hyperCriticalRegionCount?5?$DO?50?$AA@ 002e ?_ConcRT_CoreAssert@details@Concurrency@@YAXPEBD0H@Z 0052 ??_C@_0BK@KHDLBAFP@m_criticalRegionCount?5?$DO?50?$AA@"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 83 B8 88 00 00 00 00 76 02 EB 19 41 B8 E9 00 00 00 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 44 24 40 83 B8 84 00 00 00 00 76 02 EB 19 41 B8 EA 00 00 00 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 44 24 40 8B 80 88 00 00 00 FF C8 89 44 24 20 48 8B 44 24 40 8B 4C 24 20 89 88 88 00 00 00 8B 44 24 20 89 44 24 24 48 8B 44 24 40 8B 80 84 00 00 00 FF C8 48 8B 4C 24 40 89 81 84 00 00 00 8B 44 24 24 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_63_65_0 {
	meta:
		name = "?Flush@?$LockFreeStack@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@QEAAPEAVFreeThreadProxy@23@XZ"
		size = 36
		refs = "0013 __imp_InterlockedFlushSList 001b ?Delta@?$LockFreeStack@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@CAPEAVFreeThreadProxy@23@PEAX@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B C8 FF 15 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_439_237_0 {
	meta:
		name = "?Flush@?$LockFreeStack@VExternalContextBase@details@Concurrency@@@details@Concurrency@@QEAAPEAVExternalContextBase@23@XZ"
		size = 36
		refs = "0013 __imp_InterlockedFlushSList 001b ?Delta@?$LockFreeStack@VExternalContextBase@details@Concurrency@@@details@Concurrency@@CAPEAVExternalContextBase@23@PEAX@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B C8 FF 15 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_439_238_0 {
	meta:
		name = "?Flush@?$LockFreeStack@VRealizedChore@details@Concurrency@@@details@Concurrency@@QEAAPEAVRealizedChore@23@XZ"
		size = 36
		refs = "0013 __imp_InterlockedFlushSList 001b ?Delta@?$LockFreeStack@VRealizedChore@details@Concurrency@@@details@Concurrency@@CAPEAVRealizedChore@23@PEAX@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B C8 FF 15 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_63_66_0 {
	meta:
		name = "?Flush@?$LockFreeStack@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@QEAAPEAVUMSFreeThreadProxy@23@XZ"
		size = 36
		refs = "0013 __imp_InterlockedFlushSList 001b ?Delta@?$LockFreeStack@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@CAPEAVUMSFreeThreadProxy@23@PEAX@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B C8 FF 15 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_439_357_0 {
	meta:
		name = "?Pop@?$LockFreeStack@VExternalContextBase@details@Concurrency@@@details@Concurrency@@QEAAPEAVExternalContextBase@23@XZ"
		size = 36
		refs = "0013 __imp_InterlockedPopEntrySList 001b ?Delta@?$LockFreeStack@VExternalContextBase@details@Concurrency@@@details@Concurrency@@CAPEAVExternalContextBase@23@PEAX@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B C8 FF 15 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_63_87_0 {
	meta:
		name = "?Pop@?$LockFreeStack@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@QEAAPEAVFreeThreadProxy@23@XZ"
		size = 36
		refs = "0013 __imp_InterlockedPopEntrySList 001b ?Delta@?$LockFreeStack@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@CAPEAVFreeThreadProxy@23@PEAX@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B C8 FF 15 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_397_35_0 {
	meta:
		name = "?Pop@?$LockFreeStack@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QEAAPEAVInternalContextBase@23@XZ"
		size = 36
		refs = "0013 __imp_InterlockedPopEntrySList 001b ?Delta@?$LockFreeStack@VInternalContextBase@details@Concurrency@@@details@Concurrency@@CAPEAVInternalContextBase@23@PEAX@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B C8 FF 15 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_439_359_0 {
	meta:
		name = "?Pop@?$LockFreeStack@VRealizedChore@details@Concurrency@@@details@Concurrency@@QEAAPEAVRealizedChore@23@XZ"
		size = 36
		refs = "0013 __imp_InterlockedPopEntrySList 001b ?Delta@?$LockFreeStack@VRealizedChore@details@Concurrency@@@details@Concurrency@@CAPEAVRealizedChore@23@PEAX@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B C8 FF 15 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_439_360_0 {
	meta:
		name = "?Pop@?$LockFreeStack@VSubAllocator@details@Concurrency@@@details@Concurrency@@QEAAPEAVSubAllocator@23@XZ"
		size = 36
		refs = "0013 __imp_InterlockedPopEntrySList 001b ?Delta@?$LockFreeStack@VSubAllocator@details@Concurrency@@@details@Concurrency@@CAPEAVSubAllocator@23@PEAX@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B C8 FF 15 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_63_88_0 {
	meta:
		name = "?Pop@?$LockFreeStack@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@QEAAPEAVUMSFreeThreadProxy@23@XZ"
		size = 36
		refs = "0013 __imp_InterlockedPopEntrySList 001b ?Delta@?$LockFreeStack@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@CAPEAVUMSFreeThreadProxy@23@PEAX@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B C8 FF 15 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_63_67_0 {
	meta:
		name = "?ForceEnterHyperCriticalRegion@UMSThreadProxy@details@Concurrency@@QEAAHXZ"
		size = 71
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 18 48 8B 44 24 20 8B 80 8C 00 00 00 FF C0 48 8B 4C 24 20 89 81 8C 00 00 00 48 8B 44 24 20 8B 80 90 00 00 00 FF C0 89 04 24 48 8B 44 24 20 8B 0C 24 89 88 90 00 00 00 8B 04 24 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_63_69_0 {
	meta:
		name = "?GetContext@UMSFreeThreadProxy@details@Concurrency@@UEAAPEAUIExecutionContext@3@XZ"
		size = 18
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8B 80 F0 00 00 00 C3 }
	condition:
		$1
}

rule file_63_70_0 {
	meta:
		name = "?GetCriticalRegionType@UMSThreadProxy@details@Concurrency@@UEBA?AW4CriticalRegionType@3@XZ"
		size = 51
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 83 B8 88 00 00 00 00 76 07 B8 02 00 00 00 EB 17 48 8B 44 24 08 83 B8 84 00 00 00 00 76 07 B8 01 00 00 00 EB 02 33 C0 F3 C3 }
	condition:
		$1
}

rule file_63_71_0 {
	meta:
		name = "?GetCurrent@UMSThreadProxy@details@Concurrency@@SAPEAV123@XZ"
		size = 22
		refs = "0005 ?GetCurrentUmsThread@UMS@details@Concurrency@@SAPEAXXZ 000d ?FromUMSContext@UMSThreadProxy@details@Concurrency@@SAPEAV123@PEAX@Z"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_439_200_0 {
	meta:
		name = "?CurrentScheduler@SchedulerBase@details@Concurrency@@SAPEAV123@XZ"
		size = 22
		refs = "0005 ?CurrentContext@SchedulerBase@details@Concurrency@@SAPEAVContextBase@23@XZ 000d ?GetScheduler@ContextBase@details@Concurrency@@QEBAPEAVSchedulerBase@23@XZ"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_63_75_0 {
	meta:
		name = "?GetFreeThreadProxyFactory@ThreadProxyFactoryManager@details@Concurrency@@QEAAPEAVFreeThreadProxyFactory@23@XZ"
		size = 104
		refs = "002f ??0_Scoped_lock@_NonReentrantBlockingLock@details@Concurrency@@QEAA@AEAV123@@Z 0045 ?CreateFactory@FreeThreadProxyFactory@details@Concurrency@@SAPEAV123@PEAVThreadProxyFactoryManager@23@@Z 0057 ??1_Scoped_lock@_NonReentrantBlockingLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 28 FE FF FF FF 48 8B 44 24 40 48 83 38 00 75 3E 48 8B 44 24 40 48 83 C0 18 48 8B D0 48 8D 4C 24 20 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 38 00 75 12 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 4C 24 40 48 89 01 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 40 48 8B 00 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_63_76_0 {
	meta:
		name = "?dtor$0@?0??GetFreeThreadProxyFactory@ThreadProxyFactoryManager@details@Concurrency@@QEAAPEAVFreeThreadProxyFactory@23@XZ@4HA"
		size = 24
		refs = "000e ??1_Scoped_lock@_NonReentrantBlockingLock@details@Concurrency@@QEAA@XZ"
		altNames = "?dtor$0@?0??GetUMSFreeThreadProxyFactory@ThreadProxyFactoryManager@details@Concurrency@@QEAAPEAVUMSFreeThreadProxyFactory@23@XZ@4HA"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 20 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_92_569_3 {
	meta:
		name = "?dtor$0@?0???4_Iterator_base12@std@@QEAAAEAU01@AEBU01@@Z@4HA"
		size = 24
		refs = "000e ??1_Lockit@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 20 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_705_16_0 {
	meta:
		name = "?dtor$0@?0??AddTail@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QEAAXPEAUListEntry@23@@Z@4HA"
		size = 24
		refs = "000e ??1_Scoped_lock@_ReaderWriterLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 20 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_439_163_0 {
	meta:
		name = "?dtor$0@?0??AddTail@?$SafeRWList@VWaitNode@SchedulerBase@details@Concurrency@@VNoCount@CollectionTypes@34@V_ReaderWriterLock@34@@details@Concurrency@@QEAAXPEAVWaitNode@SchedulerBase@23@@Z@4HA"
		size = 24
		refs = "000e ??1_Scoped_lock@_ReaderWriterLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 20 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_439_181_0 {
	meta:
		name = "?dtor$0@?0??CheckStaticConstruction@SchedulerBase@details@Concurrency@@CAXXZ@4HA"
		size = 24
		refs = "000e ??1_Scoped_lock@_NonReentrantLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 20 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_439_216_0 {
	meta:
		name = "?dtor$0@?0??Dequeue@?$SafeSQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QEAAPEAVInternalContextBase@23@XZ@4HA"
		size = 24
		refs = "000e ??1_Scoped_lock@_HyperNonReentrantLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 20 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_993_115_0 {
	meta:
		name = "?dtor$0@?0??Dequeue@?$SafeSQueue@VRealizedChore@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QEAAPEAVRealizedChore@23@XZ@4HA"
		size = 24
		refs = "000e ??1_Scoped_lock@_HyperNonReentrantLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 20 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_1091_24_0 {
	meta:
		name = "?dtor$0@?0??Dequeue@?$SafeSQueue@VUMSThreadProxy@details@Concurrency@@V_NonReentrantLock@23@@details@Concurrency@@QEAAPEAVUMSThreadProxy@23@XZ@4HA"
		size = 24
		refs = "000e ??1_Scoped_lock@_NonReentrantLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 20 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_251_30_0 {
	meta:
		name = "?dtor$0@?0??Enqueue@?$SafeSQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QEAAXPEAVInternalContextBase@23@@Z@4HA"
		size = 24
		refs = "000e ??1_Scoped_lock@_HyperNonReentrantLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 20 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_993_123_0 {
	meta:
		name = "?dtor$0@?0??Enqueue@?$SafeSQueue@VRealizedChore@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QEAAXPEAVRealizedChore@23@@Z@4HA"
		size = 24
		refs = "000e ??1_Scoped_lock@_HyperNonReentrantLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 20 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_1091_27_0 {
	meta:
		name = "?dtor$0@?0??Enqueue@?$SafeSQueue@VUMSThreadProxy@details@Concurrency@@V_NonReentrantLock@23@@details@Concurrency@@QEAAXPEAVUMSThreadProxy@23@@Z@4HA"
		size = 24
		refs = "000e ??1_Scoped_lock@_NonReentrantLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 20 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_171_116_0 {
	meta:
		name = "?dtor$0@?0??GetCoreCount@ResourceManager@details@Concurrency@@SAIXZ@4HA"
		size = 24
		refs = "000e ??1_Scoped_lock@_NonReentrantLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 20 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_171_133_0 {
	meta:
		name = "?dtor$0@?0??GetNodeCount@ResourceManager@details@Concurrency@@SAIXZ@4HA"
		size = 24
		refs = "000e ??1_Scoped_lock@_NonReentrantLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 20 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_705_30_0 {
	meta:
		name = "?dtor$0@?0??Remove@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QEAAXPEAUListEntry@23@@Z@4HA"
		size = 24
		refs = "000e ??1_Scoped_lock@_ReaderWriterLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 20 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_477_26_0 {
	meta:
		name = "?dtor$0@?0??RemoveHead@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QEAAPEAUListEntry@23@XZ@4HA"
		size = 24
		refs = "000e ??1_Scoped_lock@_ReaderWriterLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 20 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_439_393_0 {
	meta:
		name = "?dtor$0@?0??RemoveHead@?$SafeRWList@VWaitNode@SchedulerBase@details@Concurrency@@VNoCount@CollectionTypes@34@V_ReaderWriterLock@34@@details@Concurrency@@QEAAPEAVWaitNode@SchedulerBase@23@XZ@4HA"
		size = 24
		refs = "000e ??1_Scoped_lock@_ReaderWriterLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 20 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_1059_132_0 {
	meta:
		name = "?dtor$0@?0??Steal@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QEAAPEAVInternalContextBase@23@_N@Z@4HA"
		size = 24
		refs = "000e ??1_Scoped_lock@_HyperNonReentrantLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 20 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_595_50_0 {
	meta:
		name = "?dtor$0@?0??Steal@WorkQueue@details@Concurrency@@QEAAPEAV_UnrealizedChore@23@_N@Z@4HA"
		size = 24
		refs = "000e ??1_Scoped_lock@_CriticalNonReentrantLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 20 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_606_41_0 {
	meta:
		name = "?dtor$0@?0??Swap@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QEAAXPEAV?$List@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@@23@@Z@4HA"
		size = 24
		refs = "000e ??1_Scoped_lock@_ReaderWriterLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 20 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_171_227_0 {
	meta:
		name = "?dtor$0@?0??Version@ResourceManager@details@Concurrency@@SA?AW4OSVersion@IResourceManager@3@XZ@4HA"
		size = 24
		refs = "000e ??1_Scoped_lock@_NonReentrantLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 20 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_49_185_3 {
	meta:
		name = "?dtor$0@?0??_Adopt@_Iterator_base12@std@@QEAAXPEBU_Container_base12@2@@Z@4HA"
		size = 24
		refs = "000e ??1_Lockit@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 20 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_637_110_0 {
	meta:
		name = "?dtor$0@?0??_DeleteExceptionPtr@@YAXQEAV__ExceptionPtr@@@Z@4HA"
		size = 24
		refs = "000e ??1?$_DebugMallocator@V__ExceptionPtr@@@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 20 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_637_113_0 {
	meta:
		name = "?dtor$0@?0??_Delete_this@?$_Ref_count_del_alloc@V__ExceptionPtr@@P6AXPEAV1@@ZV?$_DebugMallocator@H@@@std@@EEAAXXZ@4HA"
		size = 24
		refs = "000e ??1?$_DebugMallocator@V?$_Ref_count_del_alloc@V__ExceptionPtr@@P6AXPEAV1@@ZV?$_DebugMallocator@H@@@std@@@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 20 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_3_112_3 {
	meta:
		name = "?dtor$0@?0??_Init@locale@std@@CAPEAV_Locimp@12@_N@Z@4HA"
		size = 24
		refs = "000e ??1_Lockit@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 20 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_105_607_1 {
	meta:
		name = "?dtor$0@?0??_JoinAllTokens_Add@details@Concurrency@@YAXAEBVcancellation_token_source@2@PEAV_CancellationTokenState@12@@Z@4HA"
		size = 24
		refs = "000e ??1cancellation_token@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 20 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_23_116_2 {
	meta:
		name = "?dtor$0@?0??_Locimp_dtor@_Locimp@locale@std@@CAXPEAV123@@Z@4HA"
		size = 24
		refs = "000e ??1_Lockit@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 20 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_92_822_3 {
	meta:
		name = "?dtor$0@?0??_Orphan_range@?$vector@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@2@@std@@IEBAXPEAV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@2@0@Z@4HA"
		size = 24
		refs = "000e ??1_Lockit@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 20 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_54_817_3 {
	meta:
		name = "?dtor$0@?0??_Orphan_range@?$vector@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@2@@std@@IEBAXPEAV?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@2@0@Z@4HA"
		size = 24
		refs = "000e ??1_Lockit@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 20 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_637_15_0 {
	meta:
		name = "?dtor$1@?0???$_Resetp@V__ExceptionPtr@@P6AXPEAV1@@ZV?$_DebugMallocator@H@@@?$shared_ptr@V__ExceptionPtr@@@std@@AEAAXPEAV__ExceptionPtr@@P6AX0@ZV?$_DebugMallocator@H@@@Z@4HA"
		size = 24
		refs = "000e ??1?$_DebugMallocator@V?$_Ref_count_del_alloc@V__ExceptionPtr@@P6AXPEAV1@@ZV?$_DebugMallocator@H@@@std@@@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 20 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_637_90_0 {
	meta:
		name = "?dtor$2@?0??_CopyException@__ExceptionPtr@@SA?AV?$shared_ptr@V__ExceptionPtr@@@std@@PEBXPEBU_s_ThrowInfo@@_N@Z@4HA"
		size = 24
		refs = "000e ??1?$_DebugMallocator@V__ExceptionPtr@@@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 20 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_63_77_0 {
	meta:
		name = "?GetNextUnblockNotification@UMSThreadProxy@details@Concurrency@@UEAAPEAUIUMSUnblockNotification@3@XZ"
		size = 111
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 80 90 00 00 00 48 89 04 24 48 83 3C 24 00 75 0B 48 C7 44 24 08 00 00 00 00 EB 0F 48 8B 04 24 48 2D A0 00 00 00 48 89 44 24 08 48 8B 44 24 08 48 89 44 24 10 48 83 7C 24 10 00 74 10 48 8B 44 24 10 48 83 C0 10 48 89 44 24 18 EB 09 48 C7 44 24 18 00 00 00 00 48 8B 44 24 18 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_63_82_0 {
	meta:
		name = "?GetUMSFreeThreadProxyFactory@ThreadProxyFactoryManager@details@Concurrency@@QEAAPEAVUMSFreeThreadProxyFactory@23@XZ"
		size = 108
		refs = "0030 ??0_Scoped_lock@_NonReentrantBlockingLock@details@Concurrency@@QEAA@AEAV123@@Z 0047 ?CreateFactory@UMSFreeThreadProxyFactory@details@Concurrency@@SAPEAV123@PEAVThreadProxyFactoryManager@23@@Z 005a ??1_Scoped_lock@_NonReentrantBlockingLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 28 FE FF FF FF 48 8B 44 24 40 48 83 78 08 00 75 40 48 8B 44 24 40 48 83 C0 18 48 8B D0 48 8D 4C 24 20 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 78 08 00 75 13 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 4C 24 40 48 89 41 08 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 40 48 8B 40 08 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_63_85_0 {
	meta:
		name = "?Next@?$LockFreeStack@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@SAPEAVFreeThreadProxy@23@PEAV423@@Z"
		size = 28
		refs = "0013 ?Delta@?$LockFreeStack@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@CAPEAVFreeThreadProxy@23@PEAX@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 48 60 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_63_86_0 {
	meta:
		name = "?Next@?$LockFreeStack@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@SAPEAVUMSFreeThreadProxy@23@PEAV423@@Z"
		size = 31
		refs = "0016 ?Delta@?$LockFreeStack@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@CAPEAVUMSFreeThreadProxy@23@PEAX@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 88 10 01 00 00 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_63_89_0 {
	meta:
		name = "?Prepare@?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@MEAAXPEAVFreeThreadProxy@23@H@Z"
		size = 54
		refs = "0019 ?GetPriority@ThreadProxy@details@Concurrency@@QEAAHXZ 002d ?SetPriority@ThreadProxy@details@Concurrency@@QEAAXH@Z"
	strings:
		$1 = { 44 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 38 E8 ?? ?? ?? ?? 3B 44 24 40 74 0E 8B 54 24 40 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_63_90_0 {
	meta:
		name = "?Prepare@?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@MEAAXPEAVUMSFreeThreadProxy@23@H@Z"
		size = 54
		refs = "0019 ?GetPriority@UMSThreadProxy@details@Concurrency@@QEAAHXZ 002d ?SetPriority@UMSThreadProxy@details@Concurrency@@QEAAXH@Z"
	strings:
		$1 = { 44 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 38 E8 ?? ?? ?? ?? 3B 44 24 40 74 0E 8B 54 24 40 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_63_91_0 {
	meta:
		name = "?Prepare@UMSFreeThreadProxyFactory@details@Concurrency@@EEAAXPEAVUMSFreeThreadProxy@23@H@Z"
		size = 54
		refs = "0023 ?Prepare@?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@MEAAXPEAVUMSFreeThreadProxy@23@H@Z 002d ?ClearCriticalRegion@UMSThreadProxy@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 44 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 44 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_63_92_0 {
	meta:
		name = "?Push@?$LockFreeStack@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@QEAAXPEAVFreeThreadProxy@23@@Z"
		size = 42
		refs = "0021 __imp_InterlockedPushEntrySList"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 38 48 83 C0 60 48 8B 4C 24 30 48 8B D0 FF 15 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_63_93_0 {
	meta:
		name = "?Push@?$LockFreeStack@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@QEAAXPEAVUMSFreeThreadProxy@23@@Z"
		size = 44
		refs = "0023 __imp_InterlockedPushEntrySList"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 38 48 05 10 01 00 00 48 8B 4C 24 30 48 8B D0 FF 15 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_63_94_0 {
	meta:
		name = "?ReclaimProxy@?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@UEAAXPEAUIThreadProxy@3@@Z"
		size = 192
		refs = "0039 ?GetStackSize@ThreadProxy@details@Concurrency@@QEAAIXZ 0045 ?s_proxyStackSize@?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@1QBIB 0065 ?Count@?$LockFreeStack@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@QEBAHXZ 006b ?s_bucketSize@?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@1HA 008d ?Push@?$LockFreeStack@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@QEAAXPEAVFreeThreadProxy@23@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 48 48 89 44 24 28 C7 44 24 20 00 00 00 00 EB 0A 8B 44 24 20 FF C0 89 44 24 20 83 7C 24 20 04 7D 6B 48 8B 4C 24 28 E8 ?? ?? ?? ?? 48 63 4C 24 20 48 8D 15 ?? ?? ?? ?? 3B 04 8A 75 4E 48 63 44 24 20 48 6B C0 10 48 8B 4C 24 40 48 8D 44 01 10 48 8B C8 E8 ?? ?? ?? ?? 3B 05 ?? ?? ?? ?? 7D 29 48 63 44 24 20 48 6B C0 10 48 8B 4C 24 40 48 8D 44 01 10 48 8B 54 24 28 48 8B C8 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 EB 02 EB 84 48 83 7C 24 28 00 74 15 48 8B 44 24 40 48 8B 00 48 8B 54 24 28 48 8B 4C 24 40 FF 50 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_63_95_0 {
	meta:
		name = "?ReclaimProxy@?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@UEAAXPEAUIThreadProxy@3@@Z"
		size = 225
		refs = "005a ?GetStackSize@UMSThreadProxy@details@Concurrency@@QEAAIXZ 0066 ?s_proxyStackSize@?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@1QBIB 0086 ?Count@?$LockFreeStack@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@QEBAHXZ 008c ?s_bucketSize@?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@1HA 00ae ?Push@?$LockFreeStack@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@QEAAXPEAVUMSFreeThreadProxy@23@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 48 83 7C 24 58 00 74 10 48 8B 44 24 58 48 83 E8 08 48 89 44 24 30 EB 09 48 C7 44 24 30 00 00 00 00 48 8B 44 24 30 48 89 44 24 28 C7 44 24 20 00 00 00 00 EB 0A 8B 44 24 20 FF C0 89 44 24 20 83 7C 24 20 04 7D 6B 48 8B 4C 24 28 E8 ?? ?? ?? ?? 48 63 4C 24 20 48 8D 15 ?? ?? ?? ?? 3B 04 8A 75 4E 48 63 44 24 20 48 6B C0 10 48 8B 4C 24 50 48 8D 44 01 10 48 8B C8 E8 ?? ?? ?? ?? 3B 05 ?? ?? ?? ?? 7D 29 48 63 44 24 20 48 6B C0 10 48 8B 4C 24 50 48 8D 44 01 10 48 8B 54 24 28 48 8B C8 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 EB 02 EB 84 48 83 7C 24 28 00 74 15 48 8B 44 24 50 48 8B 00 48 8B 54 24 28 48 8B 4C 24 50 FF 50 40 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_63_96_0 {
	meta:
		name = "?ReclaimProxy@FreeThreadProxyFactory@details@Concurrency@@UEAAXPEAUIThreadProxy@3@@Z"
		size = 331
		refs = "0051 ?GetStackSize@ThreadProxy@details@Concurrency@@QEAAIXZ 005d ?s_proxyStackSize@?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@1QBIB 0081 ?Count@?$LockFreeStack@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@QEBAHXZ 0087 ?s_bucketSize@?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@1HA 00ad ?Push@?$LockFreeStack@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@QEAAXPEAVFreeThreadProxy@23@@Z 00d8 ?Flush@?$LockFreeStack@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@QEAAPEAVFreeThreadProxy@23@XZ 00ef ?Next@?$LockFreeStack@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@SAPEAVFreeThreadProxy@23@PEAV423@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 48 8B 44 24 58 48 89 44 24 28 48 8B 44 24 50 0F B6 40 54 0F B6 C0 85 C0 0F 85 FD 00 00 00 C7 44 24 20 00 00 00 00 EB 0A 8B 44 24 20 FF C0 89 44 24 20 83 7C 24 20 04 0F 8D DE 00 00 00 48 8B 4C 24 28 E8 ?? ?? ?? ?? 48 63 4C 24 20 48 8D 15 ?? ?? ?? ?? 3B 04 8A 0F 85 BA 00 00 00 48 63 44 24 20 48 6B C0 10 48 8B 4C 24 50 48 8D 44 01 10 48 8B C8 E8 ?? ?? ?? ?? 3B 05 ?? ?? ?? ?? 0F 8D 91 00 00 00 48 63 44 24 20 48 6B C0 10 48 8B 4C 24 50 48 8D 44 01 10 48 8B 54 24 28 48 8B C8 E8 ?? ?? ?? ?? 48 8B 44 24 50 0F B6 40 54 0F B6 C0 85 C0 74 58 48 63 44 24 20 48 6B C0 10 48 8B 4C 24 50 48 8D 44 01 10 48 8B C8 E8 ?? ?? ?? ?? 48 89 44 24 28 48 83 7C 24 28 00 74 30 48 8B 4C 24 28 E8 ?? ?? ?? ?? 48 89 44 24 30 48 8B 44 24 50 48 8B 00 48 8B 54 24 28 48 8B 4C 24 50 FF 50 40 48 8B 44 24 30 48 89 44 24 28 EB C8 48 C7 44 24 28 00 00 00 00 EB 05 E9 0D FF FF FF 48 83 7C 24 28 00 74 15 48 8B 44 24 50 48 8B 00 48 8B 54 24 28 48 8B 4C 24 50 FF 50 40 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_63_97_0 {
	meta:
		name = "?Reference@FreeThreadProxyFactory@details@Concurrency@@UEAAJXZ"
		size = 28
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 83 C0 50 B9 01 00 00 00 F0 0F C1 08 FF C1 8B C1 C3 }
	condition:
		$1
}

rule file_63_99_0 {
	meta:
		name = "?Release@FreeThreadProxyFactory@details@Concurrency@@UEAAJXZ"
		size = 116
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 48 48 8B 44 24 50 48 83 C0 50 B9 FF FF FF FF F0 0F C1 08 FF C9 8B C1 89 44 24 20 83 7C 24 20 00 75 41 48 8B 44 24 50 48 89 44 24 30 48 8B 44 24 30 48 89 44 24 28 48 83 7C 24 28 00 74 1C 48 8B 44 24 28 48 8B 00 BA 01 00 00 00 48 8B 4C 24 28 FF 50 28 48 89 44 24 38 EB 09 48 C7 44 24 38 00 00 00 00 8B 44 24 20 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_63_101_0 {
	meta:
		name = "?RequestProxy@?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@UEAAPEAUIThreadProxy@3@IH@Z"
		size = 196
		refs = "003e ?s_proxyStackSize@?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@1QBIB 0062 ?Pop@?$LockFreeStack@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@QEAAPEAVFreeThreadProxy@23@XZ"
	strings:
		$1 = { 44 89 44 24 18 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 28 00 00 00 00 C7 44 24 20 00 00 00 00 EB 0A 8B 44 24 20 FF C0 89 44 24 20 83 7C 24 20 04 7D 41 48 63 44 24 20 48 8D 0D ?? ?? ?? ?? 8B 04 81 39 44 24 48 77 2A 48 63 44 24 20 48 6B C0 10 48 8B 4C 24 40 48 8D 44 01 10 48 8B C8 E8 ?? ?? ?? ?? 48 89 44 24 28 48 83 7C 24 28 00 74 02 EB 02 EB AE 48 83 7C 24 28 00 75 19 48 8B 44 24 40 48 8B 00 8B 54 24 48 48 8B 4C 24 40 FF 50 38 48 89 44 24 28 48 83 7C 24 28 00 74 1A 48 8B 44 24 40 48 8B 00 44 8B 44 24 50 48 8B 54 24 28 48 8B 4C 24 40 FF 50 48 48 8B 44 24 28 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_63_102_0 {
	meta:
		name = "?RequestProxy@?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@UEAAPEAUIThreadProxy@3@IH@Z"
		size = 229
		refs = "003e ?s_proxyStackSize@?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@1QBIB 0062 ?Pop@?$LockFreeStack@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@QEAAPEAVUMSFreeThreadProxy@23@XZ"
	strings:
		$1 = { 44 89 44 24 18 89 54 24 10 48 89 4C 24 08 48 83 EC 48 48 C7 44 24 28 00 00 00 00 C7 44 24 20 00 00 00 00 EB 0A 8B 44 24 20 FF C0 89 44 24 20 83 7C 24 20 04 7D 41 48 63 44 24 20 48 8D 0D ?? ?? ?? ?? 8B 04 81 39 44 24 58 77 2A 48 63 44 24 20 48 6B C0 10 48 8B 4C 24 50 48 8D 44 01 10 48 8B C8 E8 ?? ?? ?? ?? 48 89 44 24 28 48 83 7C 24 28 00 74 02 EB 02 EB AE 48 83 7C 24 28 00 75 19 48 8B 44 24 50 48 8B 00 8B 54 24 58 48 8B 4C 24 50 FF 50 38 48 89 44 24 28 48 83 7C 24 28 00 74 1A 48 8B 44 24 50 48 8B 00 44 8B 44 24 60 48 8B 54 24 28 48 8B 4C 24 50 FF 50 48 48 83 7C 24 28 00 74 10 48 8B 44 24 28 48 83 C0 08 48 89 44 24 30 EB 09 48 C7 44 24 30 00 00 00 00 48 8B 44 24 30 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_63_103_0 {
	meta:
		name = "?Retire@FreeThreadProxyFactory@details@Concurrency@@EEAAXPEAVFreeThreadProxy@23@@Z"
		size = 29
		refs = "0014 ?Cancel@ThreadProxy@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_63_104_0 {
	meta:
		name = "?Retire@UMSFreeThreadProxyFactory@details@Concurrency@@EEAAXPEAVUMSFreeThreadProxy@23@@Z"
		size = 48
		refs = "0014 ?Cancel@UMSThreadProxy@details@Concurrency@@QEAAXXZ 0027 ?QueueToCompletion@TransmogrifiedPrimary@details@Concurrency@@QEAAXPEAVUMSThreadProxy@23@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B 54 24 38 48 8B 44 24 30 48 8B 48 50 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_63_105_0 {
	meta:
		name = "?RetireThreadProxies@?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@QEAAXXZ"
		size = 131
		refs = "003b ?Flush@?$LockFreeStack@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@QEAAPEAVFreeThreadProxy@23@XZ 0052 ?Next@?$LockFreeStack@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@SAPEAVFreeThreadProxy@23@PEAV423@@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 48 C7 44 24 20 00 00 00 00 EB 0A 8B 44 24 20 FF C0 89 44 24 20 83 7C 24 20 04 7D 5A 48 63 44 24 20 48 6B C0 10 48 8B 4C 24 50 48 8D 44 01 10 48 8B C8 E8 ?? ?? ?? ?? 48 89 44 24 28 48 83 7C 24 28 00 74 30 48 8B 4C 24 28 E8 ?? ?? ?? ?? 48 89 44 24 30 48 8B 44 24 50 48 8B 00 48 8B 54 24 28 48 8B 4C 24 50 FF 50 40 48 8B 44 24 30 48 89 44 24 28 EB C8 EB 95 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_63_106_0 {
	meta:
		name = "?RetireThreadProxies@?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@QEAAXXZ"
		size = 131
		refs = "003b ?Flush@?$LockFreeStack@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@QEAAPEAVUMSFreeThreadProxy@23@XZ 0052 ?Next@?$LockFreeStack@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@SAPEAVUMSFreeThreadProxy@23@PEAV423@@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 48 C7 44 24 20 00 00 00 00 EB 0A 8B 44 24 20 FF C0 89 44 24 20 83 7C 24 20 04 7D 5A 48 63 44 24 20 48 6B C0 10 48 8B 4C 24 50 48 8D 44 01 10 48 8B C8 E8 ?? ?? ?? ?? 48 89 44 24 28 48 83 7C 24 28 00 74 30 48 8B 4C 24 28 E8 ?? ?? ?? ?? 48 89 44 24 30 48 8B 44 24 50 48 8B 00 48 8B 54 24 28 48 8B 4C 24 50 FF 50 40 48 8B 44 24 30 48 89 44 24 28 EB C8 EB 95 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_63_107_0 {
	meta:
		name = "?Shutdown@TransmogrifiedPrimary@details@Concurrency@@QEAAXXZ"
		size = 29
		refs = "0014 __imp_SetEvent"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 48 28 FF 15 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_63_108_0 {
	meta:
		name = "?ShutdownFactory@FreeThreadProxyFactory@details@Concurrency@@UEAAXXZ"
		size = 49
		refs = "0018 ?RetireThreadProxies@?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 C6 40 54 01 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8B 00 48 8B 4C 24 30 FF 50 18 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_63_109_0 {
	meta:
		name = "?ShutdownFactory@UMSFreeThreadProxyFactory@details@Concurrency@@UEAAXXZ"
		size = 135
		refs = "000f ?RetireThreadProxies@?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@QEAAXXZ 001d ?Shutdown@TransmogrifiedPrimary@details@Concurrency@@QEAAXXZ 003d ?DeleteUmsCompletionList@UMS@details@Concurrency@@SAHPEAX@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 48 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 8B 48 50 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 83 B8 B0 00 00 00 00 74 11 48 8B 44 24 50 48 8B 88 B0 00 00 00 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 89 44 24 28 48 8B 44 24 28 48 89 44 24 20 48 83 7C 24 20 00 74 1C 48 8B 44 24 20 48 8B 00 BA 01 00 00 00 48 8B 4C 24 20 FF 50 28 48 89 44 24 30 EB 09 48 C7 44 24 30 00 00 00 00 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_63_110_0 {
	meta:
		name = "?StaticInitialize@?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@KAXXZ"
		size = 111
		refs = "0006 ?s_bucketSize@?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@1HA 000e ?GetProcessorCount@Concurrency@@YAIXZ 0027 ??_C@_1CE@MGGJLKBC@?$AAs?$AA_?$AAb?$AAu?$AAc?$AAk?$AAe?$AAt?$AAS?$AAi?$AAz?$AAe?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA4?$AA?$AA@ 0033 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0048 ??_C@_1IC@GOFOIKIP@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 0052 _CrtDbgReportW"
	strings:
		$1 = { 48 83 EC 38 83 3D ?? ?? ?? ?? 00 75 0E E8 ?? ?? ?? ?? C1 E0 02 89 05 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 04 7D 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 A0 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 33 C0 85 C0 75 B7 33 C0 85 C0 75 B1 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_63_111_0 {
	meta:
		name = "?StaticInitialize@?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@KAXXZ"
		size = 111
		refs = "0006 ?s_bucketSize@?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@1HA 000e ?GetProcessorCount@Concurrency@@YAIXZ 0027 ??_C@_1CE@MGGJLKBC@?$AAs?$AA_?$AAb?$AAu?$AAc?$AAk?$AAe?$AAt?$AAS?$AAi?$AAz?$AAe?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA4?$AA?$AA@ 0033 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0048 ??_C@_1IC@GOFOIKIP@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 0052 _CrtDbgReportW"
	strings:
		$1 = { 48 83 EC 38 83 3D ?? ?? ?? ?? 00 75 0E E8 ?? ?? ?? ?? C1 E0 02 89 05 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 04 7D 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 A0 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 33 C0 85 C0 75 B7 33 C0 85 C0 75 B1 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_63_112_0 {
	meta:
		name = "?YieldToSystem@FreeThreadProxy@details@Concurrency@@UEAAXXZ"
		size = 20
		refs = "000b __imp_SwitchToThread"
		altNames = "?YieldToSystem@UMSFreeVirtualProcessorRoot@details@Concurrency@@UEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 FF 15 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_63_113_0 {
	meta:
		name = "HRESULT_FROM_WIN32"
		size = 53
	strings:
		$1 = { 89 4C 24 08 48 83 EC 18 83 7C 24 20 00 7F 09 8B 44 24 20 89 04 24 EB 15 8B 44 24 20 25 FF FF 00 00 0D 00 00 07 00 0F BA E8 1F 89 04 24 8B 04 24 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_64_0_0 {
	meta:
		name = "_mbsnbset_s"
		size = 63
		refs = "0036 _mbsnbset_s_l"
	strings:
		$1 = { 4C 89 4C 24 20 44 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 00 00 00 00 4C 8B 4C 24 58 44 8B 44 24 50 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_924_0_0 {
	meta:
		name = "_mbsnset_s"
		size = 63
		refs = "0036 _mbsnset_s_l"
	strings:
		$1 = { 4C 89 4C 24 20 44 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 00 00 00 00 4C 8B 4C 24 58 44 8B 44 24 50 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_66_0_0 {
	meta:
		name = "strstr"
		size = 1604
		refs = "002f __isa_available"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 81 EC 88 00 00 00 48 8B 84 24 98 00 00 00 0F BE 00 85 C0 75 0D 48 8B 84 24 90 00 00 00 E9 0F 06 00 00 83 3D ?? ?? ?? ?? 02 0F 8D 10 03 00 00 B8 01 00 00 00 48 6B C0 00 48 8B 8C 24 98 00 00 00 0F B6 04 01 B9 01 00 00 00 48 6B C9 00 48 8B 94 24 98 00 00 00 0F B6 0C 0A C1 E1 08 0B C1 66 0F 6E C0 66 0F 7F 44 24 40 F2 0F 70 44 24 40 00 66 0F 7F 44 24 40 66 0F 6F 44 24 40 66 0F 70 C0 00 66 0F 7F 44 24 40 66 0F 6F 44 24 70 66 0F EF 44 24 70 66 0F 7F 44 24 70 48 8B 84 24 90 00 00 00 48 25 FF 0F 00 00 48 3D F0 0F 00 00 0F 87 9B 00 00 00 48 8B 84 24 90 00 00 00 F3 0F 6F 00 66 0F 7F 44 24 20 66 0F 6F 44 24 20 66 0F 74 44 24 70 66 0F 7F 44 24 60 66 0F 6F 44 24 20 66 0F 74 44 24 40 66 0F 7F 44 24 20 66 0F 6F 44 24 20 66 0F EB 44 24 60 66 0F 7F 44 24 20 66 0F 6F 44 24 20 66 0F D7 C0 89 44 24 18 83 7C 24 18 00 75 19 48 8B 84 24 90 00 00 00 48 83 C0 10 48 89 84 24 90 00 00 00 E9 70 FF FF FF 8B 44 24 18 0F BC C0 89 44 24 30 8B 44 24 30 48 8B 8C 24 90 00 00 00 48 03 C8 48 8B C1 48 89 84 24 90 00 00 00 B8 01 00 00 00 48 6B C0 00 48 8B 8C 24 90 00 00 00 0F BE 04 01 85 C0 75 07 33 C0 E9 C4 04 00 00 B8 01 00 00 00 48 6B C0 00 48 8B 8C 24 98 00 00 00 0F BE 04 01 B9 01 00 00 00 48 6B C9 00 48 8B 94 24 90 00 00 00 0F BE 0C 0A 3B C1 0F 85 83 01 00 00 48 8B 84 24 90 00 00 00 48 89 44 24 10 48 8B 84 24 98 00 00 00 48 89 44 24 08 48 8B 44 24 08 48 25 FF 0F 00 00 48 3D F0 0F 00 00 0F 87 E6 00 00 00 48 8B 44 24 10 48 25 FF 0F 00 00 48 3D F0 0F 00 00 0F 87 CF 00 00 00 48 8B 44 24 10 F3 0F 6F 00 66 0F 7F 44 24 20 48 8B 44 24 08 F3 0F 6F 00 66 0F 7F 44 24 60 66 0F 6F 44 24 20 66 0F 74 44 24 60 66 0F 7F 44 24 20 66 0F 6F 44 24 60 66 0F 74 44 24 70 66 0F 7F 44 24 60 66 0F 6F 44 24 20 66 0F 74 44 24 70 66 0F 7F 44 24 20 66 0F 6F 44 24 20 66 0F EB 44 24 60 66 0F 7F 44 24 60 66 0F 6F 44 24 60 66 0F D7 C0 89 44 24 18 83 7C 24 18 00 75 21 48 8B 44 24 10 48 83 C0 10 48 89 44 24 10 48 8B 44 24 08 48 83 C0 10 48 89 44 24 08 E9 36 FF FF FF 8B 44 24 18 0F BC C0 89 44 24 30 8B 44 24 30 48 8B 4C 24 10 48 03 C8 48 8B C1 48 89 44 24 10 8B 44 24 30 48 8B 4C 24 08 48 03 C8 48 8B C1 48 89 44 24 08 B8 01 00 00 00 48 6B C0 00 48 8B 4C 24 08 0F BE 04 01 85 C0 75 0D 48 8B 84 24 90 00 00 00 E9 58 03 00 00 B8 01 00 00 00 48 6B C0 00 48 8B 4C 24 10 0F BE 04 01 B9 01 00 00 00 48 6B C9 00 48 8B 54 24 08 0F BE 0C 0A 3B C1 74 02 EB 1F 48 8B 44 24 10 48 FF C0 48 89 44 24 10 48 8B 44 24 08 48 FF C0 48 89 44 24 08 E9 97 FE FF FF 48 8B 84 24 90 00 00 00 48 FF C0 48 89 84 24 90 00 00 00 E9 5E FD FF FF E9 F2 02 00 00 48 8B 84 24 98 00 00 00 48 25 FF 0F 00 00 48 3D F0 0F 00 00 77 17 48 8B 84 24 98 00 00 00 F3 0F 6F 00 66 0F 7F 44 24 40 E9 91 00 00 00 66 0F 6F 44 24 40 66 0F EF 44 24 40 66 0F 7F 44 24 40 48 8B 84 24 98 00 00 00 48 89 44 24 08 48 8B 44 24 08 0F B6 00 88 04 24 C7 44 24 50 00 00 00 00 EB 0A 8B 44 24 50 FF C0 89 44 24 50 8B 44 24 50 48 83 F8 10 73 49 66 0F 6F 44 24 40 66 0F 73 D8 01 66 0F 7F 44 24 40 0F BE 04 24 66 0F 6F 44 24 40 66 0F 3A 20 C0 0F 66 0F 7F 44 24 40 0F BE 04 24 85 C0 74 18 48 8B 44 24 08 48 FF C0 48 89 44 24 08 48 8B 44 24 08 0F B6 00 88 04 24 EB A3 48 8B 84 24 90 00 00 00 48 25 FF 0F 00 00 48 3D F0 0F 00 00 0F 87 99 00 00 00 48 8B 84 24 90 00 00 00 F3 0F 6F 00 66 0F 7F 44 24 20 66 0F 6F 44 24 40 66 0F 3A 63 44 24 20 0C B8 01 00 00 00 B9 00 00 00 00 0F 47 C8 85 C9 74 18 48 8B 84 24 90 00 00 00 48 83 C0 10 48 89 84 24 90 00 00 00 EB 9F EB 26 66 0F 6F 44 24 40 66 0F 3A 63 44 24 20 0C B8 01 00 00 00 B9 00 00 00 00 0F 42 C8 85 C9 75 07 33 C0 E9 AB 01 00 00 66 0F 6F 44 24 40 66 0F 3A 63 44 24 20 0C 8B C1 48 98 48 8B 8C 24 90 00 00 00 48 03 C8 48 8B C1 48 89 84 24 90 00 00 00 EB 48 48 8B 84 24 90 00 00 00 0F BE 00 85 C0 75 07 33 C0 E9 6B 01 00 00 48 8B 84 24 90 00 00 00 0F BE 00 48 8B 8C 24 98 00 00 00 0F BE 09 3B C1 74 18 48 8B 84 24 90 00 00 00 48 FF C0 48 89 84 24 90 00 00 00 E9 05 FF FF FF 48 8B 84 24 90 00 00 00 48 89 44 24 10 48 8B 84 24 98 00 00 00 48 89 44 24 08 48 8B 44 24 10 48 25 FF 0F 00 00 48 3D F0 0F 00 00 0F 87 A5 00 00 00 48 8B 44 24 08 48 25 FF 0F 00 00 48 3D F0 0F 00 00 0F 87 8E 00 00 00 48 8B 44 24 10 F3 0F 6F 00 66 0F 7F 44 24 20 48 8B 44 24 08 F3 0F 6F 00 66 0F 7F 44 24 60 66 0F 6F 44 24 60 66 0F 3A 63 44 24 20 0C B8 01 00 00 00 B9 00 00 00 00 0F 40 C8 85 C9 75 07 E9 97 00 00 00 EB 2C 66 0F 6F 44 24 60 66 0F 3A 63 44 24 20 0C B8 01 00 00 00 B9 00 00 00 00 0F 48 C8 85 C9 74 0D 48 8B 84 24 90 00 00 00 E9 81 00 00 00 48 8B 44 24 10 48 83 C0 10 48 89 44 24 10 48 8B 44 24 08 48 83 C0 10 48 89 44 24 08 EB 46 48 8B 44 24 08 0F BE 00 85 C0 75 0A 48 8B 84 24 90 00 00 00 EB 4D 48 8B 44 24 10 0F BE 00 48 8B 4C 24 08 0F BE 09 3B C1 74 02 EB 1F 48 8B 44 24 10 48 FF C0 48 89 44 24 10 48 8B 44 24 08 48 FF C0 48 89 44 24 08 E9 F9 FE FF FF 48 8B 84 24 90 00 00 00 48 FF C0 48 89 84 24 90 00 00 00 E9 CC FD FF FF 48 81 C4 88 00 00 00 C3 }
	condition:
		$1
}

rule file_67_1_0 {
	meta:
		name = "??$_InternalDeleteHelper@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@YAXPEAVVirtualProcessor@01@@Z"
		size = 78
		altNames = "??$_InternalDeleteHelper@VScheduleGroupSegmentBase@details@Concurrency@@@details@Concurrency@@YAXPEAVScheduleGroupSegmentBase@01@@Z ?_Destroy@_AsyncTaskCollection@details@Concurrency@@EEAAXXZ ?_Destroy@_CancellationTokenState@details@Concurrency@@EEAAXXZ ?_Destroy@_RefCounterBase@details@Concurrency@@MEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 48 48 8B 44 24 50 48 89 44 24 28 48 8B 44 24 28 48 89 44 24 20 48 83 7C 24 20 00 74 1B 48 8B 44 24 20 48 8B 00 BA 01 00 00 00 48 8B 4C 24 20 FF 10 48 89 44 24 30 EB 09 48 C7 44 24 30 00 00 00 00 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_67_2_0 {
	meta:
		name = "??0?$Hash@II@details@Concurrency@@QEAA@H@Z"
		size = 178
		refs = "0064 ??_C@_0DK@HDEIFPBC@f?3?2dd?2vctools?2crt_bld?2self_64_am@ 0071 ??_U@YAPEAX_KV_ConcRTNewMoniker@@PEBDH@Z 00a3 memset"
		altNames = "??0?$Hash@PEAV_TaskCollection@details@Concurrency@@PEAV123@@details@Concurrency@@QEAA@H@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 57 48 83 EC 40 48 8B 44 24 50 8B 4C 24 58 89 08 48 8B 44 24 50 C7 40 04 00 00 00 00 48 8D 44 24 20 48 8B F8 33 C0 B9 01 00 00 00 F3 AA 48 8B 44 24 50 48 63 00 48 89 44 24 28 B8 08 00 00 00 48 8B 4C 24 28 48 F7 E1 48 C7 C1 FF FF FF FF 48 0F 40 C1 41 B9 E1 02 00 00 4C 8D 05 ?? ?? ?? ?? 0F B6 54 24 20 48 8B C8 E8 ?? ?? ?? ?? 48 89 44 24 30 48 8B 44 24 50 48 8B 4C 24 30 48 89 48 08 48 8B 44 24 50 48 63 00 48 C1 E0 03 4C 8B C0 33 D2 48 8B 44 24 50 48 8B 48 08 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_67_3_0 {
	meta:
		name = "??0?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QEAA@PEAVSchedulerBase@12@HH@Z"
		size = 878
		refs = "01ae ??_C@_0DK@HDEIFPBC@f?3?2dd?2vctools?2crt_bld?2self_64_am@ 01bb ??_U@YAPEAX_KV_ConcRTNewMoniker@@PEBDH@Z 01e9 memset 0223 ??2@YAPEAX_KV_ConcRTNewMoniker@@PEBDH@Z 023f ??0ArrayNode@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QEAA@PEAPEAVVirtualProcessor@23@@Z 030a __imp_InitializeSListHead"
	strings:
		$1 = { 44 89 4C 24 20 44 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 57 48 81 EC 80 00 00 00 48 C7 44 24 70 FE FF FF FF 48 8B 84 24 90 00 00 00 48 C7 40 20 00 00 00 00 48 8B 84 24 90 00 00 00 48 8B 8C 24 98 00 00 00 48 89 48 48 48 8B 84 24 90 00 00 00 C7 40 54 00 00 00 00 48 8B 84 24 90 00 00 00 48 C7 40 58 00 00 00 00 48 8B 84 24 90 00 00 00 C7 40 68 00 02 00 00 48 8B 84 24 90 00 00 00 C7 40 6C 01 00 00 00 48 8B 84 24 90 00 00 00 C7 40 70 00 00 00 00 48 8B 84 24 90 00 00 00 8B 8C 24 A8 00 00 00 89 48 74 48 8B 84 24 90 00 00 00 C7 40 78 00 00 00 00 8B 84 24 A0 00 00 00 FF C8 8B 8C 24 A0 00 00 00 23 C8 8B C1 85 C0 0F 84 87 00 00 00 8B 84 24 A0 00 00 00 D1 F8 0B 84 24 A0 00 00 00 89 84 24 A0 00 00 00 8B 84 24 A0 00 00 00 C1 F8 02 0B 84 24 A0 00 00 00 89 84 24 A0 00 00 00 8B 84 24 A0 00 00 00 C1 F8 04 0B 84 24 A0 00 00 00 89 84 24 A0 00 00 00 8B 84 24 A0 00 00 00 C1 F8 08 0B 84 24 A0 00 00 00 89 84 24 A0 00 00 00 8B 84 24 A0 00 00 00 C1 F8 10 0B 84 24 A0 00 00 00 89 84 24 A0 00 00 00 8B 84 24 A0 00 00 00 FF C0 89 84 24 A0 00 00 00 48 8B 84 24 90 00 00 00 8B 8C 24 A0 00 00 00 89 48 50 48 8D 44 24 22 48 8B F8 33 C0 B9 01 00 00 00 F3 AA 48 8B 84 24 90 00 00 00 48 63 40 50 48 89 44 24 58 B8 08 00 00 00 48 8B 4C 24 58 48 F7 E1 48 C7 C1 FF FF FF FF 48 0F 40 C1 41 B9 B5 04 00 00 4C 8D 05 ?? ?? ?? ?? 0F B6 54 24 22 48 8B C8 E8 ?? ?? ?? ?? 48 89 44 24 68 48 8B 44 24 68 48 89 44 24 38 48 8B 84 24 90 00 00 00 48 63 40 50 48 C1 E0 03 4C 8B C0 33 D2 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8D 44 24 20 48 8B F8 33 C0 B9 01 00 00 00 F3 AA 48 8D 44 24 20 48 89 44 24 40 41 B9 B7 04 00 00 4C 8D 05 ?? ?? ?? ?? 48 8B 44 24 40 0F B6 10 B9 18 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 30 48 83 7C 24 30 00 74 16 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 89 44 24 28 EB 09 48 C7 44 24 28 00 00 00 00 48 8B 44 24 28 48 89 44 24 48 48 8B 84 24 90 00 00 00 48 8B 4C 24 48 48 89 48 58 48 8D 44 24 21 48 8B F8 33 C0 B9 01 00 00 00 F3 AA 48 8B 84 24 90 00 00 00 48 63 40 68 48 89 44 24 50 B8 08 00 00 00 48 8B 4C 24 50 48 F7 E1 48 C7 C1 FF FF FF FF 48 0F 40 C1 41 B9 BA 04 00 00 4C 8D 05 ?? ?? ?? ?? 0F B6 54 24 21 48 8B C8 E8 ?? ?? ?? ?? 48 89 44 24 60 48 8B 84 24 90 00 00 00 48 8B 4C 24 60 48 89 48 60 B8 08 00 00 00 48 6B C0 00 48 8B 8C 24 90 00 00 00 48 8B 49 60 48 8B 94 24 90 00 00 00 48 8B 52 58 48 89 14 08 48 8B 84 24 90 00 00 00 48 8B C8 FF 15 ?? ?? ?? ?? 48 8B 84 24 90 00 00 00 48 83 C0 10 48 8B C8 FF 15 ?? ?? ?? ?? 48 8B 84 24 90 00 00 00 8B 40 50 89 44 24 24 8B 44 24 24 D1 F8 89 44 24 24 83 7C 24 24 00 74 1A 48 8B 84 24 90 00 00 00 8B 40 54 FF C0 48 8B 8C 24 90 00 00 00 89 41 54 EB D5 48 8B 84 24 90 00 00 00 48 81 C4 80 00 00 00 5F C3 }
	condition:
		$1
}

rule file_993_2_0 {
	meta:
		name = "??0?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@QEAA@PEAVSchedulerBase@12@HH@Z"
		size = 878
		refs = "01ae ??_C@_0DK@HDEIFPBC@f?3?2dd?2vctools?2crt_bld?2self_64_am@ 01bb ??_U@YAPEAX_KV_ConcRTNewMoniker@@PEBDH@Z 01e9 memset 0223 ??2@YAPEAX_KV_ConcRTNewMoniker@@PEBDH@Z 023f ??0ArrayNode@?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@QEAA@PEAPEAU?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@23@@Z 030a __imp_InitializeSListHead"
	strings:
		$1 = { 44 89 4C 24 20 44 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 57 48 81 EC 80 00 00 00 48 C7 44 24 70 FE FF FF FF 48 8B 84 24 90 00 00 00 48 C7 40 20 00 00 00 00 48 8B 84 24 90 00 00 00 48 8B 8C 24 98 00 00 00 48 89 48 48 48 8B 84 24 90 00 00 00 C7 40 54 00 00 00 00 48 8B 84 24 90 00 00 00 48 C7 40 58 00 00 00 00 48 8B 84 24 90 00 00 00 C7 40 68 00 02 00 00 48 8B 84 24 90 00 00 00 C7 40 6C 01 00 00 00 48 8B 84 24 90 00 00 00 C7 40 70 00 00 00 00 48 8B 84 24 90 00 00 00 8B 8C 24 A8 00 00 00 89 48 74 48 8B 84 24 90 00 00 00 C7 40 78 00 00 00 00 8B 84 24 A0 00 00 00 FF C8 8B 8C 24 A0 00 00 00 23 C8 8B C1 85 C0 0F 84 87 00 00 00 8B 84 24 A0 00 00 00 D1 F8 0B 84 24 A0 00 00 00 89 84 24 A0 00 00 00 8B 84 24 A0 00 00 00 C1 F8 02 0B 84 24 A0 00 00 00 89 84 24 A0 00 00 00 8B 84 24 A0 00 00 00 C1 F8 04 0B 84 24 A0 00 00 00 89 84 24 A0 00 00 00 8B 84 24 A0 00 00 00 C1 F8 08 0B 84 24 A0 00 00 00 89 84 24 A0 00 00 00 8B 84 24 A0 00 00 00 C1 F8 10 0B 84 24 A0 00 00 00 89 84 24 A0 00 00 00 8B 84 24 A0 00 00 00 FF C0 89 84 24 A0 00 00 00 48 8B 84 24 90 00 00 00 8B 8C 24 A0 00 00 00 89 48 50 48 8D 44 24 22 48 8B F8 33 C0 B9 01 00 00 00 F3 AA 48 8B 84 24 90 00 00 00 48 63 40 50 48 89 44 24 58 B8 08 00 00 00 48 8B 4C 24 58 48 F7 E1 48 C7 C1 FF FF FF FF 48 0F 40 C1 41 B9 B5 04 00 00 4C 8D 05 ?? ?? ?? ?? 0F B6 54 24 22 48 8B C8 E8 ?? ?? ?? ?? 48 89 44 24 68 48 8B 44 24 68 48 89 44 24 38 48 8B 84 24 90 00 00 00 48 63 40 50 48 C1 E0 03 4C 8B C0 33 D2 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8D 44 24 20 48 8B F8 33 C0 B9 01 00 00 00 F3 AA 48 8D 44 24 20 48 89 44 24 40 41 B9 B7 04 00 00 4C 8D 05 ?? ?? ?? ?? 48 8B 44 24 40 0F B6 10 B9 18 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 30 48 83 7C 24 30 00 74 16 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 89 44 24 28 EB 09 48 C7 44 24 28 00 00 00 00 48 8B 44 24 28 48 89 44 24 48 48 8B 84 24 90 00 00 00 48 8B 4C 24 48 48 89 48 58 48 8D 44 24 21 48 8B F8 33 C0 B9 01 00 00 00 F3 AA 48 8B 84 24 90 00 00 00 48 63 40 68 48 89 44 24 50 B8 08 00 00 00 48 8B 4C 24 50 48 F7 E1 48 C7 C1 FF FF FF FF 48 0F 40 C1 41 B9 BA 04 00 00 4C 8D 05 ?? ?? ?? ?? 0F B6 54 24 21 48 8B C8 E8 ?? ?? ?? ?? 48 89 44 24 60 48 8B 84 24 90 00 00 00 48 8B 4C 24 60 48 89 48 60 B8 08 00 00 00 48 6B C0 00 48 8B 8C 24 90 00 00 00 48 8B 49 60 48 8B 94 24 90 00 00 00 48 8B 52 58 48 89 14 08 48 8B 84 24 90 00 00 00 48 8B C8 FF 15 ?? ?? ?? ?? 48 8B 84 24 90 00 00 00 48 83 C0 10 48 8B C8 FF 15 ?? ?? ?? ?? 48 8B 84 24 90 00 00 00 8B 40 50 89 44 24 24 8B 44 24 24 D1 F8 89 44 24 24 83 7C 24 24 00 74 1A 48 8B 84 24 90 00 00 00 8B 40 54 FF C0 48 8B 8C 24 90 00 00 00 89 41 54 EB D5 48 8B 84 24 90 00 00 00 48 81 C4 80 00 00 00 5F C3 }
	condition:
		$1
}

rule file_439_7_0 {
	meta:
		name = "??0?$ListArray@VExternalStatistics@details@Concurrency@@@details@Concurrency@@QEAA@PEAVSchedulerBase@12@HH@Z"
		size = 878
		refs = "01ae ??_C@_0DK@HDEIFPBC@f?3?2dd?2vctools?2crt_bld?2self_64_am@ 01bb ??_U@YAPEAX_KV_ConcRTNewMoniker@@PEBDH@Z 01e9 memset 0223 ??2@YAPEAX_KV_ConcRTNewMoniker@@PEBDH@Z 023f ??0ArrayNode@?$ListArray@VExternalStatistics@details@Concurrency@@@details@Concurrency@@QEAA@PEAPEAVExternalStatistics@23@@Z 030a __imp_InitializeSListHead"
	strings:
		$1 = { 44 89 4C 24 20 44 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 57 48 81 EC 80 00 00 00 48 C7 44 24 70 FE FF FF FF 48 8B 84 24 90 00 00 00 48 C7 40 20 00 00 00 00 48 8B 84 24 90 00 00 00 48 8B 8C 24 98 00 00 00 48 89 48 48 48 8B 84 24 90 00 00 00 C7 40 54 00 00 00 00 48 8B 84 24 90 00 00 00 48 C7 40 58 00 00 00 00 48 8B 84 24 90 00 00 00 C7 40 68 00 02 00 00 48 8B 84 24 90 00 00 00 C7 40 6C 01 00 00 00 48 8B 84 24 90 00 00 00 C7 40 70 00 00 00 00 48 8B 84 24 90 00 00 00 8B 8C 24 A8 00 00 00 89 48 74 48 8B 84 24 90 00 00 00 C7 40 78 00 00 00 00 8B 84 24 A0 00 00 00 FF C8 8B 8C 24 A0 00 00 00 23 C8 8B C1 85 C0 0F 84 87 00 00 00 8B 84 24 A0 00 00 00 D1 F8 0B 84 24 A0 00 00 00 89 84 24 A0 00 00 00 8B 84 24 A0 00 00 00 C1 F8 02 0B 84 24 A0 00 00 00 89 84 24 A0 00 00 00 8B 84 24 A0 00 00 00 C1 F8 04 0B 84 24 A0 00 00 00 89 84 24 A0 00 00 00 8B 84 24 A0 00 00 00 C1 F8 08 0B 84 24 A0 00 00 00 89 84 24 A0 00 00 00 8B 84 24 A0 00 00 00 C1 F8 10 0B 84 24 A0 00 00 00 89 84 24 A0 00 00 00 8B 84 24 A0 00 00 00 FF C0 89 84 24 A0 00 00 00 48 8B 84 24 90 00 00 00 8B 8C 24 A0 00 00 00 89 48 50 48 8D 44 24 22 48 8B F8 33 C0 B9 01 00 00 00 F3 AA 48 8B 84 24 90 00 00 00 48 63 40 50 48 89 44 24 58 B8 08 00 00 00 48 8B 4C 24 58 48 F7 E1 48 C7 C1 FF FF FF FF 48 0F 40 C1 41 B9 B5 04 00 00 4C 8D 05 ?? ?? ?? ?? 0F B6 54 24 22 48 8B C8 E8 ?? ?? ?? ?? 48 89 44 24 68 48 8B 44 24 68 48 89 44 24 38 48 8B 84 24 90 00 00 00 48 63 40 50 48 C1 E0 03 4C 8B C0 33 D2 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8D 44 24 20 48 8B F8 33 C0 B9 01 00 00 00 F3 AA 48 8D 44 24 20 48 89 44 24 40 41 B9 B7 04 00 00 4C 8D 05 ?? ?? ?? ?? 48 8B 44 24 40 0F B6 10 B9 18 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 30 48 83 7C 24 30 00 74 16 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 89 44 24 28 EB 09 48 C7 44 24 28 00 00 00 00 48 8B 44 24 28 48 89 44 24 48 48 8B 84 24 90 00 00 00 48 8B 4C 24 48 48 89 48 58 48 8D 44 24 21 48 8B F8 33 C0 B9 01 00 00 00 F3 AA 48 8B 84 24 90 00 00 00 48 63 40 68 48 89 44 24 50 B8 08 00 00 00 48 8B 4C 24 50 48 F7 E1 48 C7 C1 FF FF FF FF 48 0F 40 C1 41 B9 BA 04 00 00 4C 8D 05 ?? ?? ?? ?? 0F B6 54 24 21 48 8B C8 E8 ?? ?? ?? ?? 48 89 44 24 60 48 8B 84 24 90 00 00 00 48 8B 4C 24 60 48 89 48 60 B8 08 00 00 00 48 6B C0 00 48 8B 8C 24 90 00 00 00 48 8B 49 60 48 8B 94 24 90 00 00 00 48 8B 52 58 48 89 14 08 48 8B 84 24 90 00 00 00 48 8B C8 FF 15 ?? ?? ?? ?? 48 8B 84 24 90 00 00 00 48 83 C0 10 48 8B C8 FF 15 ?? ?? ?? ?? 48 8B 84 24 90 00 00 00 8B 40 50 89 44 24 24 8B 44 24 24 D1 F8 89 44 24 24 83 7C 24 24 00 74 1A 48 8B 84 24 90 00 00 00 8B 40 54 FF C0 48 8B 8C 24 90 00 00 00 89 41 54 EB D5 48 8B 84 24 90 00 00 00 48 81 C4 80 00 00 00 5F C3 }
	condition:
		$1
}

rule file_439_9_0 {
	meta:
		name = "??0?$ListArray@VScheduleGroupBase@details@Concurrency@@@details@Concurrency@@QEAA@PEAVSchedulerBase@12@HH@Z"
		size = 878
		refs = "01ae ??_C@_0DK@HDEIFPBC@f?3?2dd?2vctools?2crt_bld?2self_64_am@ 01bb ??_U@YAPEAX_KV_ConcRTNewMoniker@@PEBDH@Z 01e9 memset 0223 ??2@YAPEAX_KV_ConcRTNewMoniker@@PEBDH@Z 023f ??0ArrayNode@?$ListArray@VScheduleGroupBase@details@Concurrency@@@details@Concurrency@@QEAA@PEAPEAVScheduleGroupBase@23@@Z 030a __imp_InitializeSListHead"
	strings:
		$1 = { 44 89 4C 24 20 44 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 57 48 81 EC 80 00 00 00 48 C7 44 24 70 FE FF FF FF 48 8B 84 24 90 00 00 00 48 C7 40 20 00 00 00 00 48 8B 84 24 90 00 00 00 48 8B 8C 24 98 00 00 00 48 89 48 48 48 8B 84 24 90 00 00 00 C7 40 54 00 00 00 00 48 8B 84 24 90 00 00 00 48 C7 40 58 00 00 00 00 48 8B 84 24 90 00 00 00 C7 40 68 00 02 00 00 48 8B 84 24 90 00 00 00 C7 40 6C 01 00 00 00 48 8B 84 24 90 00 00 00 C7 40 70 00 00 00 00 48 8B 84 24 90 00 00 00 8B 8C 24 A8 00 00 00 89 48 74 48 8B 84 24 90 00 00 00 C7 40 78 00 00 00 00 8B 84 24 A0 00 00 00 FF C8 8B 8C 24 A0 00 00 00 23 C8 8B C1 85 C0 0F 84 87 00 00 00 8B 84 24 A0 00 00 00 D1 F8 0B 84 24 A0 00 00 00 89 84 24 A0 00 00 00 8B 84 24 A0 00 00 00 C1 F8 02 0B 84 24 A0 00 00 00 89 84 24 A0 00 00 00 8B 84 24 A0 00 00 00 C1 F8 04 0B 84 24 A0 00 00 00 89 84 24 A0 00 00 00 8B 84 24 A0 00 00 00 C1 F8 08 0B 84 24 A0 00 00 00 89 84 24 A0 00 00 00 8B 84 24 A0 00 00 00 C1 F8 10 0B 84 24 A0 00 00 00 89 84 24 A0 00 00 00 8B 84 24 A0 00 00 00 FF C0 89 84 24 A0 00 00 00 48 8B 84 24 90 00 00 00 8B 8C 24 A0 00 00 00 89 48 50 48 8D 44 24 22 48 8B F8 33 C0 B9 01 00 00 00 F3 AA 48 8B 84 24 90 00 00 00 48 63 40 50 48 89 44 24 58 B8 08 00 00 00 48 8B 4C 24 58 48 F7 E1 48 C7 C1 FF FF FF FF 48 0F 40 C1 41 B9 B5 04 00 00 4C 8D 05 ?? ?? ?? ?? 0F B6 54 24 22 48 8B C8 E8 ?? ?? ?? ?? 48 89 44 24 68 48 8B 44 24 68 48 89 44 24 38 48 8B 84 24 90 00 00 00 48 63 40 50 48 C1 E0 03 4C 8B C0 33 D2 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8D 44 24 20 48 8B F8 33 C0 B9 01 00 00 00 F3 AA 48 8D 44 24 20 48 89 44 24 40 41 B9 B7 04 00 00 4C 8D 05 ?? ?? ?? ?? 48 8B 44 24 40 0F B6 10 B9 18 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 30 48 83 7C 24 30 00 74 16 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 89 44 24 28 EB 09 48 C7 44 24 28 00 00 00 00 48 8B 44 24 28 48 89 44 24 48 48 8B 84 24 90 00 00 00 48 8B 4C 24 48 48 89 48 58 48 8D 44 24 21 48 8B F8 33 C0 B9 01 00 00 00 F3 AA 48 8B 84 24 90 00 00 00 48 63 40 68 48 89 44 24 50 B8 08 00 00 00 48 8B 4C 24 50 48 F7 E1 48 C7 C1 FF FF FF FF 48 0F 40 C1 41 B9 BA 04 00 00 4C 8D 05 ?? ?? ?? ?? 0F B6 54 24 21 48 8B C8 E8 ?? ?? ?? ?? 48 89 44 24 60 48 8B 84 24 90 00 00 00 48 8B 4C 24 60 48 89 48 60 B8 08 00 00 00 48 6B C0 00 48 8B 8C 24 90 00 00 00 48 8B 49 60 48 8B 94 24 90 00 00 00 48 8B 52 58 48 89 14 08 48 8B 84 24 90 00 00 00 48 8B C8 FF 15 ?? ?? ?? ?? 48 8B 84 24 90 00 00 00 48 83 C0 10 48 8B C8 FF 15 ?? ?? ?? ?? 48 8B 84 24 90 00 00 00 8B 40 50 89 44 24 24 8B 44 24 24 D1 F8 89 44 24 24 83 7C 24 24 00 74 1A 48 8B 84 24 90 00 00 00 8B 40 54 FF C0 48 8B 8C 24 90 00 00 00 89 41 54 EB D5 48 8B 84 24 90 00 00 00 48 81 C4 80 00 00 00 5F C3 }
	condition:
		$1
}

rule file_180_1_0 {
	meta:
		name = "??0?$ListArray@VScheduleGroupSegmentBase@details@Concurrency@@@details@Concurrency@@QEAA@PEAVSchedulerBase@12@HH@Z"
		size = 878
		refs = "01ae ??_C@_0DK@HDEIFPBC@f?3?2dd?2vctools?2crt_bld?2self_64_am@ 01bb ??_U@YAPEAX_KV_ConcRTNewMoniker@@PEBDH@Z 01e9 memset 0223 ??2@YAPEAX_KV_ConcRTNewMoniker@@PEBDH@Z 023f ??0ArrayNode@?$ListArray@VScheduleGroupSegmentBase@details@Concurrency@@@details@Concurrency@@QEAA@PEAPEAVScheduleGroupSegmentBase@23@@Z 030a __imp_InitializeSListHead"
	strings:
		$1 = { 44 89 4C 24 20 44 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 57 48 81 EC 80 00 00 00 48 C7 44 24 70 FE FF FF FF 48 8B 84 24 90 00 00 00 48 C7 40 20 00 00 00 00 48 8B 84 24 90 00 00 00 48 8B 8C 24 98 00 00 00 48 89 48 48 48 8B 84 24 90 00 00 00 C7 40 54 00 00 00 00 48 8B 84 24 90 00 00 00 48 C7 40 58 00 00 00 00 48 8B 84 24 90 00 00 00 C7 40 68 00 02 00 00 48 8B 84 24 90 00 00 00 C7 40 6C 01 00 00 00 48 8B 84 24 90 00 00 00 C7 40 70 00 00 00 00 48 8B 84 24 90 00 00 00 8B 8C 24 A8 00 00 00 89 48 74 48 8B 84 24 90 00 00 00 C7 40 78 00 00 00 00 8B 84 24 A0 00 00 00 FF C8 8B 8C 24 A0 00 00 00 23 C8 8B C1 85 C0 0F 84 87 00 00 00 8B 84 24 A0 00 00 00 D1 F8 0B 84 24 A0 00 00 00 89 84 24 A0 00 00 00 8B 84 24 A0 00 00 00 C1 F8 02 0B 84 24 A0 00 00 00 89 84 24 A0 00 00 00 8B 84 24 A0 00 00 00 C1 F8 04 0B 84 24 A0 00 00 00 89 84 24 A0 00 00 00 8B 84 24 A0 00 00 00 C1 F8 08 0B 84 24 A0 00 00 00 89 84 24 A0 00 00 00 8B 84 24 A0 00 00 00 C1 F8 10 0B 84 24 A0 00 00 00 89 84 24 A0 00 00 00 8B 84 24 A0 00 00 00 FF C0 89 84 24 A0 00 00 00 48 8B 84 24 90 00 00 00 8B 8C 24 A0 00 00 00 89 48 50 48 8D 44 24 22 48 8B F8 33 C0 B9 01 00 00 00 F3 AA 48 8B 84 24 90 00 00 00 48 63 40 50 48 89 44 24 58 B8 08 00 00 00 48 8B 4C 24 58 48 F7 E1 48 C7 C1 FF FF FF FF 48 0F 40 C1 41 B9 B5 04 00 00 4C 8D 05 ?? ?? ?? ?? 0F B6 54 24 22 48 8B C8 E8 ?? ?? ?? ?? 48 89 44 24 68 48 8B 44 24 68 48 89 44 24 38 48 8B 84 24 90 00 00 00 48 63 40 50 48 C1 E0 03 4C 8B C0 33 D2 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8D 44 24 20 48 8B F8 33 C0 B9 01 00 00 00 F3 AA 48 8D 44 24 20 48 89 44 24 40 41 B9 B7 04 00 00 4C 8D 05 ?? ?? ?? ?? 48 8B 44 24 40 0F B6 10 B9 18 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 30 48 83 7C 24 30 00 74 16 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 89 44 24 28 EB 09 48 C7 44 24 28 00 00 00 00 48 8B 44 24 28 48 89 44 24 48 48 8B 84 24 90 00 00 00 48 8B 4C 24 48 48 89 48 58 48 8D 44 24 21 48 8B F8 33 C0 B9 01 00 00 00 F3 AA 48 8B 84 24 90 00 00 00 48 63 40 68 48 89 44 24 50 B8 08 00 00 00 48 8B 4C 24 50 48 F7 E1 48 C7 C1 FF FF FF FF 48 0F 40 C1 41 B9 BA 04 00 00 4C 8D 05 ?? ?? ?? ?? 0F B6 54 24 21 48 8B C8 E8 ?? ?? ?? ?? 48 89 44 24 60 48 8B 84 24 90 00 00 00 48 8B 4C 24 60 48 89 48 60 B8 08 00 00 00 48 6B C0 00 48 8B 8C 24 90 00 00 00 48 8B 49 60 48 8B 94 24 90 00 00 00 48 8B 52 58 48 89 14 08 48 8B 84 24 90 00 00 00 48 8B C8 FF 15 ?? ?? ?? ?? 48 8B 84 24 90 00 00 00 48 83 C0 10 48 8B C8 FF 15 ?? ?? ?? ?? 48 8B 84 24 90 00 00 00 8B 40 50 89 44 24 24 8B 44 24 24 D1 F8 89 44 24 24 83 7C 24 24 00 74 1A 48 8B 84 24 90 00 00 00 8B 40 54 FF C0 48 8B 8C 24 90 00 00 00 89 41 54 EB D5 48 8B 84 24 90 00 00 00 48 81 C4 80 00 00 00 5F C3 }
	condition:
		$1
}

rule file_993_4_0 {
	meta:
		name = "??0?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QEAA@PEAVSchedulerBase@12@HH@Z"
		size = 878
		refs = "01ae ??_C@_0DK@HDEIFPBC@f?3?2dd?2vctools?2crt_bld?2self_64_am@ 01bb ??_U@YAPEAX_KV_ConcRTNewMoniker@@PEBDH@Z 01e9 memset 0223 ??2@YAPEAX_KV_ConcRTNewMoniker@@PEBDH@Z 023f ??0ArrayNode@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QEAA@PEAPEAVWorkQueue@23@@Z 030a __imp_InitializeSListHead"
	strings:
		$1 = { 44 89 4C 24 20 44 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 57 48 81 EC 80 00 00 00 48 C7 44 24 70 FE FF FF FF 48 8B 84 24 90 00 00 00 48 C7 40 20 00 00 00 00 48 8B 84 24 90 00 00 00 48 8B 8C 24 98 00 00 00 48 89 48 48 48 8B 84 24 90 00 00 00 C7 40 54 00 00 00 00 48 8B 84 24 90 00 00 00 48 C7 40 58 00 00 00 00 48 8B 84 24 90 00 00 00 C7 40 68 00 02 00 00 48 8B 84 24 90 00 00 00 C7 40 6C 01 00 00 00 48 8B 84 24 90 00 00 00 C7 40 70 00 00 00 00 48 8B 84 24 90 00 00 00 8B 8C 24 A8 00 00 00 89 48 74 48 8B 84 24 90 00 00 00 C7 40 78 00 00 00 00 8B 84 24 A0 00 00 00 FF C8 8B 8C 24 A0 00 00 00 23 C8 8B C1 85 C0 0F 84 87 00 00 00 8B 84 24 A0 00 00 00 D1 F8 0B 84 24 A0 00 00 00 89 84 24 A0 00 00 00 8B 84 24 A0 00 00 00 C1 F8 02 0B 84 24 A0 00 00 00 89 84 24 A0 00 00 00 8B 84 24 A0 00 00 00 C1 F8 04 0B 84 24 A0 00 00 00 89 84 24 A0 00 00 00 8B 84 24 A0 00 00 00 C1 F8 08 0B 84 24 A0 00 00 00 89 84 24 A0 00 00 00 8B 84 24 A0 00 00 00 C1 F8 10 0B 84 24 A0 00 00 00 89 84 24 A0 00 00 00 8B 84 24 A0 00 00 00 FF C0 89 84 24 A0 00 00 00 48 8B 84 24 90 00 00 00 8B 8C 24 A0 00 00 00 89 48 50 48 8D 44 24 22 48 8B F8 33 C0 B9 01 00 00 00 F3 AA 48 8B 84 24 90 00 00 00 48 63 40 50 48 89 44 24 58 B8 08 00 00 00 48 8B 4C 24 58 48 F7 E1 48 C7 C1 FF FF FF FF 48 0F 40 C1 41 B9 B5 04 00 00 4C 8D 05 ?? ?? ?? ?? 0F B6 54 24 22 48 8B C8 E8 ?? ?? ?? ?? 48 89 44 24 68 48 8B 44 24 68 48 89 44 24 38 48 8B 84 24 90 00 00 00 48 63 40 50 48 C1 E0 03 4C 8B C0 33 D2 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8D 44 24 20 48 8B F8 33 C0 B9 01 00 00 00 F3 AA 48 8D 44 24 20 48 89 44 24 40 41 B9 B7 04 00 00 4C 8D 05 ?? ?? ?? ?? 48 8B 44 24 40 0F B6 10 B9 18 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 30 48 83 7C 24 30 00 74 16 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 89 44 24 28 EB 09 48 C7 44 24 28 00 00 00 00 48 8B 44 24 28 48 89 44 24 48 48 8B 84 24 90 00 00 00 48 8B 4C 24 48 48 89 48 58 48 8D 44 24 21 48 8B F8 33 C0 B9 01 00 00 00 F3 AA 48 8B 84 24 90 00 00 00 48 63 40 68 48 89 44 24 50 B8 08 00 00 00 48 8B 4C 24 50 48 F7 E1 48 C7 C1 FF FF FF FF 48 0F 40 C1 41 B9 BA 04 00 00 4C 8D 05 ?? ?? ?? ?? 0F B6 54 24 21 48 8B C8 E8 ?? ?? ?? ?? 48 89 44 24 60 48 8B 84 24 90 00 00 00 48 8B 4C 24 60 48 89 48 60 B8 08 00 00 00 48 6B C0 00 48 8B 8C 24 90 00 00 00 48 8B 49 60 48 8B 94 24 90 00 00 00 48 8B 52 58 48 89 14 08 48 8B 84 24 90 00 00 00 48 8B C8 FF 15 ?? ?? ?? ?? 48 8B 84 24 90 00 00 00 48 83 C0 10 48 8B C8 FF 15 ?? ?? ?? ?? 48 8B 84 24 90 00 00 00 8B 40 50 89 44 24 24 8B 44 24 24 D1 F8 89 44 24 24 83 7C 24 24 00 74 1A 48 8B 84 24 90 00 00 00 8B 40 54 FF C0 48 8B 8C 24 90 00 00 00 89 41 54 EB D5 48 8B 84 24 90 00 00 00 48 81 C4 80 00 00 00 5F C3 }
	condition:
		$1
}

rule file_67_4_0 {
	meta:
		name = "?dtor$0@?0???0?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QEAA@PEAVSchedulerBase@12@HH@Z@4HA"
		size = 44
		refs = "0012 ??_C@_0DK@HDEIFPBC@f?3?2dd?2vctools?2crt_bld?2self_64_am@ 0022 ??3@YAXPEAXV_ConcRTNewMoniker@@PEBDH@Z"
		altNames = "?dtor$0@?0???0?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@QEAA@PEAVSchedulerBase@12@HH@Z@4HA ?dtor$0@?0???0?$ListArray@VExternalStatistics@details@Concurrency@@@details@Concurrency@@QEAA@PEAVSchedulerBase@12@HH@Z@4HA ?dtor$0@?0???0?$ListArray@VScheduleGroupBase@details@Concurrency@@@details@Concurrency@@QEAA@PEAVSchedulerBase@12@HH@Z@4HA ?dtor$0@?0???0?$ListArray@VScheduleGroupSegmentBase@details@Concurrency@@@details@Concurrency@@QEAA@PEAVSchedulerBase@12@HH@Z@4HA ?dtor$0@?0???0?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QEAA@PEAVSchedulerBase@12@HH@Z@4HA"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 41 B9 B7 04 00 00 4C 8D 05 ?? ?? ?? ?? 48 8B 45 40 0F B6 10 48 8B 4D 30 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_67_5_0 {
	meta:
		name = "??0?$_SpinWait@$00@details@Concurrency@@QEAA@P6AXXZ@Z"
		size = 42
		altNames = "??0?$_SpinWait@$0A@@details@Concurrency@@QEAA@P6AXXZ@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 8B 44 24 08 C7 40 08 00 00 00 00 48 8B 44 24 08 48 8B 4C 24 10 48 89 48 10 48 8B 44 24 08 C3 }
	condition:
		$1
}

rule file_67_6_0 {
	meta:
		name = "??0ArrayNode@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QEAA@PEAPEAVVirtualProcessor@23@@Z"
		size = 54
		altNames = "??0ArrayNode@?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@QEAA@PEAPEAU?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@23@@Z ??0ArrayNode@?$ListArray@VExternalStatistics@details@Concurrency@@@details@Concurrency@@QEAA@PEAPEAVExternalStatistics@23@@Z ??0ArrayNode@?$ListArray@VScheduleGroupBase@details@Concurrency@@@details@Concurrency@@QEAA@PEAPEAVScheduleGroupBase@23@@Z ??0ArrayNode@?$ListArray@VScheduleGroupSegmentBase@details@Concurrency@@@details@Concurrency@@QEAA@PEAPEAVScheduleGroupSegmentBase@23@@Z ??0ArrayNode@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QEAA@PEAPEAVWorkQueue@23@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 8B 44 24 08 48 8B 4C 24 10 48 89 08 48 8B 44 24 08 48 C7 40 08 00 00 00 00 48 8B 44 24 08 C7 40 10 FF FF FF FF 48 8B 44 24 08 C3 }
	condition:
		$1
}

rule file_67_7_0 {
	meta:
		name = "??0QuickBitSet@details@Concurrency@@QEAA@AEBV012@@Z"
		size = 63
		refs = "0031 ?CopyFrom@QuickBitSet@details@Concurrency@@IEAAXAEBV123@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 C7 00 00 00 00 00 48 8B 44 24 30 48 C7 40 08 00 00 00 00 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_67_8_0 {
	meta:
		name = "??0SchedulingNode@details@Concurrency@@QEAA@AEBVQuickBitSet@12@KPEAVSchedulingRing@12@@Z"
		size = 243
		refs = "0041 ??0QuickBitSet@details@Concurrency@@QEAA@AEBV012@@Z 0058 ??0?$Hash@II@details@Concurrency@@QEAA@H@Z 00ba ??0?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QEAA@PEAVSchedulerBase@12@HH@Z 00dd ?Id@SchedulingRing@details@Concurrency@@QEBAHXZ"
	strings:
		$1 = { 4C 89 4C 24 20 44 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 44 24 40 48 8B 4C 24 58 48 89 48 08 48 8B 44 24 40 48 83 C0 10 48 8B 54 24 48 48 8B C8 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 C0 20 BA 01 10 00 00 48 8B C8 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 C7 40 30 00 00 00 00 48 8B 44 24 40 C7 40 34 00 00 00 00 48 8B 44 24 40 C7 40 38 00 00 00 00 48 8B 44 24 40 C7 40 3C 00 00 00 00 48 8B 44 24 40 8B 4C 24 50 89 48 40 48 8B 44 24 40 48 83 C0 50 41 B9 FF FF FF 7F 41 B8 00 01 00 00 48 8B 4C 24 58 48 8B 11 48 8B C8 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 8B 40 08 48 8B 4C 24 40 48 8B 00 48 89 01 48 8B 44 24 40 48 8B 48 08 E8 ?? ?? ?? ?? 48 8B 4C 24 40 89 41 44 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_67_9_0 {
	meta:
		name = "?dtor$0@?0???0SchedulingNode@details@Concurrency@@QEAA@AEBVQuickBitSet@12@KPEAVSchedulingRing@12@@Z@4HA"
		size = 28
		refs = "0012 ??1QuickBitSet@details@Concurrency@@QEAA@XZ"
		altNames = "?dtor$0@?0???1SchedulingNode@details@Concurrency@@QEAA@XZ@4HA"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 48 83 C1 10 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_321_9_0 {
	meta:
		name = "?dtor$0@?0???0VirtualProcessor@details@Concurrency@@QEAA@XZ@4HA"
		size = 28
		refs = "0012 ??1?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 48 83 C1 10 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_739_3_0 {
	meta:
		name = "?dtor$0@?0???0VirtualProcessorRoot@details@Concurrency@@QEAA@PEAVSchedulerProxy@12@PEAUSchedulerNode@12@I@Z@4HA"
		size = 28
		refs = "0012 ??1ExecutionResource@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 48 83 C1 10 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_491_26_0 {
	meta:
		name = "?dtor$0@?0???1InternalContextBase@details@Concurrency@@UEAA@XZ@4HA"
		size = 28
		refs = "0012 ??1ContextBase@details@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 48 83 C1 10 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_78_277_1 {
	meta:
		name = "?dtor$1@?0???0?$_SyncOriginator@W4agent_status@Concurrency@@@details@Concurrency@@QEAA@XZ@4HA"
		size = 28
		refs = "0012 ??1event@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 48 83 C1 10 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_78_281_1 {
	meta:
		name = "?dtor$1@?0???0?$_SyncOriginator@_K@details@Concurrency@@QEAA@XZ@4HA"
		size = 28
		refs = "0012 ??1event@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 48 83 C1 10 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_64_81_1 {
	meta:
		name = "?dtor$1@?0???0?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z@4HA"
		size = 28
		refs = "0012 ??1_Timevec@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 48 83 C1 10 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_66_314_3 {
	meta:
		name = "?dtor$1@?0???0?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z@4HA"
		size = 28
		refs = "0012 ??1_Timevec@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 48 83 C1 10 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_36_283_2 {
	meta:
		name = "?dtor$1@?0???0?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z@4HA"
		size = 28
		refs = "0012 ??1_Timevec@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 48 83 C1 10 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_265_10_0 {
	meta:
		name = "?dtor$1@?0???0_AsyncTaskCollection@details@Concurrency@@AEAA@PEAV_CancellationTokenState@12@@Z@4HA"
		size = 28
		refs = "0012 ??1_TaskCollection@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 48 83 C1 10 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_105_470_2 {
	meta:
		name = "?dtor$1@?0???1?$_RunAnyParam@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@QEAA@XZ@4HA"
		size = 28
		refs = "0012 ??1cancellation_token_source@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 48 83 C1 10 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_67_10_0 {
	meta:
		name = "?dtor$1@?0???0SchedulingNode@details@Concurrency@@QEAA@AEBVQuickBitSet@12@KPEAVSchedulingRing@12@@Z@4HA"
		size = 28
		refs = "0012 ??1?$Hash@II@details@Concurrency@@QEAA@XZ"
		altNames = "?dtor$1@?0???1SchedulingNode@details@Concurrency@@QEAA@XZ@4HA"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 48 83 C1 20 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_67_11_0 {
	meta:
		name = "?dtor$2@?0???0SchedulingNode@details@Concurrency@@QEAA@AEBVQuickBitSet@12@KPEAVSchedulingRing@12@@Z@4HA"
		size = 28
		refs = "0012 ??1?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QEAA@XZ"
		altNames = "?dtor$2@?0???1SchedulingNode@details@Concurrency@@QEAA@XZ@4HA"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 48 83 C1 50 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_67_13_0 {
	meta:
		name = "??1?$Hash@II@details@Concurrency@@QEAA@XZ"
		size = 48
		refs = "000f ?Wipe@?$Hash@II@details@Concurrency@@QEAAXXZ 0027 ??_V@YAXPEAX@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 44 24 40 48 8B 40 08 48 89 44 24 20 48 8B 4C 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_268_22_0 {
	meta:
		name = "??1?$Hash@PEAV_TaskCollection@details@Concurrency@@PEAV123@@details@Concurrency@@QEAA@XZ"
		size = 48
		refs = "000f ?Wipe@?$Hash@PEAV_TaskCollection@details@Concurrency@@PEAV123@@details@Concurrency@@QEAAXXZ 0027 ??_V@YAXPEAX@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 44 24 40 48 8B 40 08 48 89 44 24 20 48 8B 4C 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_67_14_0 {
	meta:
		name = "??1?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QEAA@XZ"
		size = 285
		refs = "0013 __imp_InterlockedFlushSList 0027 ?DeleteElements@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@AEAAXPEAU_SLIST_ENTRY@@@Z 00b2 ??$_InternalDeleteHelper@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@YAXPEAVVirtualProcessor@01@@Z 00d9 ??_V@YAXPEAX@Z 00ed ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 68 48 8B 44 24 70 48 8B C8 FF 15 ?? ?? ?? ?? 48 89 44 24 30 48 8B 54 24 30 48 8B 4C 24 70 E8 ?? ?? ?? ?? 48 8B 44 24 70 48 83 C0 10 48 8B C8 FF 15 ?? ?? ?? ?? 48 89 44 24 30 48 8B 54 24 30 48 8B 4C 24 70 E8 ?? ?? ?? ?? 48 8B 44 24 70 48 8B 50 20 48 8B 4C 24 70 E8 ?? ?? ?? ?? 48 8B 44 24 70 48 8B 40 58 48 89 44 24 28 48 83 7C 24 28 00 0F 84 82 00 00 00 C7 44 24 20 00 00 00 00 EB 0A 8B 44 24 20 FF C0 89 44 24 20 48 8B 44 24 70 8B 40 50 39 44 24 20 7D 18 48 63 44 24 20 48 8B 4C 24 28 48 8B 09 48 8B 0C C1 E8 ?? ?? ?? ?? EB D0 48 8B 44 24 28 48 8B 40 08 48 89 44 24 48 48 8B 44 24 28 48 8B 00 48 89 44 24 38 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B 44 24 28 48 89 44 24 40 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 44 24 48 48 89 44 24 28 E9 72 FF FF FF 48 8B 44 24 70 48 8B 40 60 48 89 44 24 50 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_993_43_0 {
	meta:
		name = "??1?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@QEAA@XZ"
		size = 285
		refs = "0013 __imp_InterlockedFlushSList 0027 ?DeleteElements@?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@AEAAXPEAU_SLIST_ENTRY@@@Z 00b2 ??$_InternalDeleteHelper@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@YAXPEAU?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@01@@Z 00d9 ??_V@YAXPEAX@Z 00ed ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 68 48 8B 44 24 70 48 8B C8 FF 15 ?? ?? ?? ?? 48 89 44 24 30 48 8B 54 24 30 48 8B 4C 24 70 E8 ?? ?? ?? ?? 48 8B 44 24 70 48 83 C0 10 48 8B C8 FF 15 ?? ?? ?? ?? 48 89 44 24 30 48 8B 54 24 30 48 8B 4C 24 70 E8 ?? ?? ?? ?? 48 8B 44 24 70 48 8B 50 20 48 8B 4C 24 70 E8 ?? ?? ?? ?? 48 8B 44 24 70 48 8B 40 58 48 89 44 24 28 48 83 7C 24 28 00 0F 84 82 00 00 00 C7 44 24 20 00 00 00 00 EB 0A 8B 44 24 20 FF C0 89 44 24 20 48 8B 44 24 70 8B 40 50 39 44 24 20 7D 18 48 63 44 24 20 48 8B 4C 24 28 48 8B 09 48 8B 0C C1 E8 ?? ?? ?? ?? EB D0 48 8B 44 24 28 48 8B 40 08 48 89 44 24 48 48 8B 44 24 28 48 8B 00 48 89 44 24 38 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B 44 24 28 48 89 44 24 40 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 44 24 48 48 89 44 24 28 E9 72 FF FF FF 48 8B 44 24 70 48 8B 40 60 48 89 44 24 50 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_439_76_0 {
	meta:
		name = "??1?$ListArray@VExternalStatistics@details@Concurrency@@@details@Concurrency@@QEAA@XZ"
		size = 285
		refs = "0013 __imp_InterlockedFlushSList 0027 ?DeleteElements@?$ListArray@VExternalStatistics@details@Concurrency@@@details@Concurrency@@AEAAXPEAU_SLIST_ENTRY@@@Z 00b2 ??$_InternalDeleteHelper@VExternalStatistics@details@Concurrency@@@details@Concurrency@@YAXPEAVExternalStatistics@01@@Z 00d9 ??_V@YAXPEAX@Z 00ed ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 68 48 8B 44 24 70 48 8B C8 FF 15 ?? ?? ?? ?? 48 89 44 24 30 48 8B 54 24 30 48 8B 4C 24 70 E8 ?? ?? ?? ?? 48 8B 44 24 70 48 83 C0 10 48 8B C8 FF 15 ?? ?? ?? ?? 48 89 44 24 30 48 8B 54 24 30 48 8B 4C 24 70 E8 ?? ?? ?? ?? 48 8B 44 24 70 48 8B 50 20 48 8B 4C 24 70 E8 ?? ?? ?? ?? 48 8B 44 24 70 48 8B 40 58 48 89 44 24 28 48 83 7C 24 28 00 0F 84 82 00 00 00 C7 44 24 20 00 00 00 00 EB 0A 8B 44 24 20 FF C0 89 44 24 20 48 8B 44 24 70 8B 40 50 39 44 24 20 7D 18 48 63 44 24 20 48 8B 4C 24 28 48 8B 09 48 8B 0C C1 E8 ?? ?? ?? ?? EB D0 48 8B 44 24 28 48 8B 40 08 48 89 44 24 48 48 8B 44 24 28 48 8B 00 48 89 44 24 38 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B 44 24 28 48 89 44 24 40 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 44 24 48 48 89 44 24 28 E9 72 FF FF FF 48 8B 44 24 70 48 8B 40 60 48 89 44 24 50 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_439_77_0 {
	meta:
		name = "??1?$ListArray@VScheduleGroupBase@details@Concurrency@@@details@Concurrency@@QEAA@XZ"
		size = 285
		refs = "0013 __imp_InterlockedFlushSList 0027 ?DeleteElements@?$ListArray@VScheduleGroupBase@details@Concurrency@@@details@Concurrency@@AEAAXPEAU_SLIST_ENTRY@@@Z 00b2 ??$_InternalDeleteHelper@VScheduleGroupBase@details@Concurrency@@@details@Concurrency@@YAXPEAVScheduleGroupBase@01@@Z 00d9 ??_V@YAXPEAX@Z 00ed ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 68 48 8B 44 24 70 48 8B C8 FF 15 ?? ?? ?? ?? 48 89 44 24 30 48 8B 54 24 30 48 8B 4C 24 70 E8 ?? ?? ?? ?? 48 8B 44 24 70 48 83 C0 10 48 8B C8 FF 15 ?? ?? ?? ?? 48 89 44 24 30 48 8B 54 24 30 48 8B 4C 24 70 E8 ?? ?? ?? ?? 48 8B 44 24 70 48 8B 50 20 48 8B 4C 24 70 E8 ?? ?? ?? ?? 48 8B 44 24 70 48 8B 40 58 48 89 44 24 28 48 83 7C 24 28 00 0F 84 82 00 00 00 C7 44 24 20 00 00 00 00 EB 0A 8B 44 24 20 FF C0 89 44 24 20 48 8B 44 24 70 8B 40 50 39 44 24 20 7D 18 48 63 44 24 20 48 8B 4C 24 28 48 8B 09 48 8B 0C C1 E8 ?? ?? ?? ?? EB D0 48 8B 44 24 28 48 8B 40 08 48 89 44 24 48 48 8B 44 24 28 48 8B 00 48 89 44 24 38 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B 44 24 28 48 89 44 24 40 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 44 24 48 48 89 44 24 28 E9 72 FF FF FF 48 8B 44 24 70 48 8B 40 60 48 89 44 24 50 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_180_9_0 {
	meta:
		name = "??1?$ListArray@VScheduleGroupSegmentBase@details@Concurrency@@@details@Concurrency@@QEAA@XZ"
		size = 285
		refs = "0013 __imp_InterlockedFlushSList 0027 ?DeleteElements@?$ListArray@VScheduleGroupSegmentBase@details@Concurrency@@@details@Concurrency@@AEAAXPEAU_SLIST_ENTRY@@@Z 00b2 ??$_InternalDeleteHelper@VScheduleGroupSegmentBase@details@Concurrency@@@details@Concurrency@@YAXPEAVScheduleGroupSegmentBase@01@@Z 00d9 ??_V@YAXPEAX@Z 00ed ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 68 48 8B 44 24 70 48 8B C8 FF 15 ?? ?? ?? ?? 48 89 44 24 30 48 8B 54 24 30 48 8B 4C 24 70 E8 ?? ?? ?? ?? 48 8B 44 24 70 48 83 C0 10 48 8B C8 FF 15 ?? ?? ?? ?? 48 89 44 24 30 48 8B 54 24 30 48 8B 4C 24 70 E8 ?? ?? ?? ?? 48 8B 44 24 70 48 8B 50 20 48 8B 4C 24 70 E8 ?? ?? ?? ?? 48 8B 44 24 70 48 8B 40 58 48 89 44 24 28 48 83 7C 24 28 00 0F 84 82 00 00 00 C7 44 24 20 00 00 00 00 EB 0A 8B 44 24 20 FF C0 89 44 24 20 48 8B 44 24 70 8B 40 50 39 44 24 20 7D 18 48 63 44 24 20 48 8B 4C 24 28 48 8B 09 48 8B 0C C1 E8 ?? ?? ?? ?? EB D0 48 8B 44 24 28 48 8B 40 08 48 89 44 24 48 48 8B 44 24 28 48 8B 00 48 89 44 24 38 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B 44 24 28 48 89 44 24 40 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 44 24 48 48 89 44 24 28 E9 72 FF FF FF 48 8B 44 24 70 48 8B 40 60 48 89 44 24 50 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_993_44_0 {
	meta:
		name = "??1?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QEAA@XZ"
		size = 285
		refs = "0013 __imp_InterlockedFlushSList 0027 ?DeleteElements@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@AEAAXPEAU_SLIST_ENTRY@@@Z 00b2 ??$_InternalDeleteHelper@VWorkQueue@details@Concurrency@@@details@Concurrency@@YAXPEAVWorkQueue@01@@Z 00d9 ??_V@YAXPEAX@Z 00ed ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 68 48 8B 44 24 70 48 8B C8 FF 15 ?? ?? ?? ?? 48 89 44 24 30 48 8B 54 24 30 48 8B 4C 24 70 E8 ?? ?? ?? ?? 48 8B 44 24 70 48 83 C0 10 48 8B C8 FF 15 ?? ?? ?? ?? 48 89 44 24 30 48 8B 54 24 30 48 8B 4C 24 70 E8 ?? ?? ?? ?? 48 8B 44 24 70 48 8B 50 20 48 8B 4C 24 70 E8 ?? ?? ?? ?? 48 8B 44 24 70 48 8B 40 58 48 89 44 24 28 48 83 7C 24 28 00 0F 84 82 00 00 00 C7 44 24 20 00 00 00 00 EB 0A 8B 44 24 20 FF C0 89 44 24 20 48 8B 44 24 70 8B 40 50 39 44 24 20 7D 18 48 63 44 24 20 48 8B 4C 24 28 48 8B 09 48 8B 0C C1 E8 ?? ?? ?? ?? EB D0 48 8B 44 24 28 48 8B 40 08 48 89 44 24 48 48 8B 44 24 28 48 8B 00 48 89 44 24 38 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B 44 24 28 48 89 44 24 40 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 44 24 48 48 89 44 24 28 E9 72 FF FF FF 48 8B 44 24 70 48 8B 40 60 48 89 44 24 50 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_67_16_0 {
	meta:
		name = "??1QuickBitSet@details@Concurrency@@QEAA@XZ"
		size = 38
		refs = "001d ??_V@YAXPEAX@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 48 8B 40 08 48 89 44 24 20 48 8B 4C 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_171_29_0 {
	meta:
		name = "??1AffinityRestriction@ResourceManager@details@Concurrency@@QEAA@XZ"
		size = 38
		refs = "001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 48 8B 40 08 48 89 44 24 20 48 8B 4C 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_67_17_0 {
	meta:
		name = "??1SchedulingNode@details@Concurrency@@QEAA@XZ"
		size = 87
		refs = "0018 ?Cleanup@SchedulingNode@details@Concurrency@@AEAAXXZ 002a ??1?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QEAA@XZ 003c ??1?$Hash@II@details@Concurrency@@QEAA@XZ 004e ??1QuickBitSet@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 C0 50 48 8B C8 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 C0 20 48 8B C8 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 C0 10 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_67_21_0 {
	meta:
		name = "??1Segment@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QEAA@XZ"
		size = 55
		refs = "001d ??_V@YAXPEAX@Z 002e ??1QuickBitSet@details@Concurrency@@QEAA@XZ"
		altNames = "??1Segment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 48 8B 40 18 48 89 44 24 20 48 8B 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 40 48 83 C0 08 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_67_26_0 {
	meta:
		name = "??A?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QEBAPEAVVirtualProcessor@12@H@Z"
		size = 223
		altNames = "??A?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@QEBAPEAU?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@12@H@Z ??A?$ListArray@VExternalStatistics@details@Concurrency@@@details@Concurrency@@QEBAPEAVExternalStatistics@12@H@Z ??A?$ListArray@VScheduleGroupSegmentBase@details@Concurrency@@@details@Concurrency@@QEBAPEAVScheduleGroupSegmentBase@12@H@Z ??A?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QEBAPEAVWorkQueue@12@H@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 18 48 8B 44 24 20 8B 40 54 0F B6 C8 8B 44 24 28 D3 F8 89 04 24 48 8B 44 24 20 8B 40 6C 39 04 24 7C 07 33 C0 E9 A5 00 00 00 48 C7 44 24 08 00 00 00 00 48 8B 44 24 20 8B 40 68 39 04 24 7C 59 48 8B 44 24 20 8B 40 68 FF C8 48 98 48 8B 4C 24 20 48 8B 49 60 48 8B 04 C1 48 89 44 24 08 C7 44 24 04 00 00 00 00 EB 0A 8B 44 24 04 FF C0 89 44 24 04 48 8B 44 24 20 8B 40 68 8B 0C 24 2B C8 8B C1 39 44 24 04 7F 10 48 8B 44 24 08 48 8B 40 08 48 89 44 24 08 EB D1 EB 16 48 63 04 24 48 8B 4C 24 20 48 8B 49 60 48 8B 04 C1 48 89 44 24 08 48 8B 44 24 20 8B 40 50 FF C8 8B 4C 24 28 23 C8 8B C1 48 98 48 8B 4C 24 08 48 8B 09 48 8B 04 C1 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_67_33_0 {
	meta:
		name = "?ASIZE@QuickBitSet@details@Concurrency@@IEBAIXZ"
		size = 19
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 8B 00 83 C0 1F C1 E8 05 C3 }
	condition:
		$1
}

rule file_67_34_0 {
	meta:
		name = "?Add@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QEAAHPEAVVirtualProcessor@23@@Z"
		size = 1243
		refs = "003d ??_C@_1BK@NMGGIMFF@?$AAm?$AA_?$AAp?$AAA?$AAr?$AAr?$AAa?$AAy?$AAH?$AAe?$AAa?$AAd?$AA?$AA@ 0049 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 005e ??_C@_1HE@BOBCMOIJ@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 0068 _CrtDbgReportW 029a ??_C@_0DK@HDEIFPBC@f?3?2dd?2vctools?2crt_bld?2self_64_am@ 02a7 ??_U@YAPEAX_KV_ConcRTNewMoniker@@PEBDH@Z 02db memset 031b ??2@YAPEAX_KV_ConcRTNewMoniker@@PEBDH@Z 0337 ??0ArrayNode@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QEAA@PEAPEAVVirtualProcessor@23@@Z 03df ?_UnderlyingYield@details@Concurrency@@YAXXZ 03ec ??0?$_SpinWait@$00@details@Concurrency@@QEAA@P6AXXZ@Z 03f9 ?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QEAA_NXZ 042b ??_C@_1HM@PHFLIKEP@?$AAi?$AAn?$AAs?$AAe?$AAr?$AAt?$AAe?$AAd?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAt?$AAr?$AAu?$AAe?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AA?$CI?$AAi?$AAn?$AAs?$AAe?$AAr?$AAt?$AAe?$AAd?$AA?5?$AA?$DN?$AA?$DN@ 048b ??_C@_1BG@HMJJDGFN@?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?$AA@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 57 48 81 EC E0 00 00 00 48 C7 84 24 C0 00 00 00 FE FF FF FF C6 44 24 30 00 C7 44 24 38 00 00 00 00 48 8B 84 24 F0 00 00 00 48 83 78 58 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 26 05 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 33 C0 85 C0 75 B1 33 C0 85 C0 75 AB 48 8B 84 24 F0 00 00 00 48 8B 40 58 48 89 44 24 40 0F B6 44 24 30 85 C0 0F 85 E3 03 00 00 48 8B 44 24 40 83 78 10 FF 0F 8C 14 01 00 00 48 8B 44 24 40 48 8B 00 48 89 44 24 78 C7 44 24 34 00 00 00 00 EB 0A 8B 44 24 34 FF C0 89 44 24 34 48 8B 84 24 F0 00 00 00 8B 40 50 39 44 24 34 0F 8D DE 00 00 00 48 63 44 24 34 48 8B 4C 24 78 48 83 3C C1 00 74 02 EB CE 8B 44 24 34 8B 4C 24 38 03 C8 8B C1 48 8B 8C 24 F8 00 00 00 89 81 8C 00 00 00 48 8B 84 24 F0 00 00 00 8B 40 70 89 44 24 48 48 63 44 24 34 48 8B 4C 24 78 48 8D 04 C1 48 8B 8C 24 F8 00 00 00 48 89 44 24 60 33 C0 48 8B 54 24 60 48 8B 54 24 60 F0 48 0F B1 0A 48 89 84 24 98 00 00 00 48 83 BC 24 98 00 00 00 00 75 5E C6 44 24 30 01 8B 44 24 34 8B 4C 24 38 03 C8 8B C1 89 44 24 38 8B 44 24 48 39 44 24 38 7C 0F 48 8B 84 24 F0 00 00 00 48 83 C0 70 F0 FF 00 48 8B 44 24 40 48 83 C0 10 B9 FF FF FF FF 48 89 84 24 90 00 00 00 8B 44 24 34 48 8B 94 24 90 00 00 00 48 8B 94 24 90 00 00 00 F0 0F B1 0A EB 05 E9 03 FF FF FF 0F B6 44 24 30 85 C0 0F 85 3B 02 00 00 48 8B 44 24 40 48 83 C0 10 B9 FE FF FF FF 48 89 84 24 88 00 00 00 B8 FF FF FF FF 48 8B 94 24 88 00 00 00 48 8B 94 24 88 00 00 00 F0 0F B1 0A 48 8B 84 24 F0 00 00 00 8B 40 50 8B 4C 24 38 03 C8 8B C1 89 44 24 38 48 8B 44 24 40 48 83 78 08 00 0F 85 AC 01 00 00 48 8B 44 24 40 48 83 C0 08 B9 01 00 00 00 48 89 44 24 50 33 C0 48 8B 54 24 50 48 8B 54 24 50 F0 48 0F B1 0A 48 85 C0 0F 85 7F 01 00 00 48 8D 44 24 3D 48 8B F8 33 C0 B9 01 00 00 00 F3 AA 48 8B 84 24 F0 00 00 00 48 63 40 50 48 89 84 24 B8 00 00 00 B8 08 00 00 00 48 8B 8C 24 B8 00 00 00 48 F7 E1 48 C7 C1 FF FF FF FF 48 0F 40 C1 41 B9 78 05 00 00 4C 8D 05 ?? ?? ?? ?? 0F B6 54 24 3D 48 8B C8 E8 ?? ?? ?? ?? 48 89 84 24 B0 00 00 00 48 8B 84 24 B0 00 00 00 48 89 44 24 68 48 8B 84 24 F0 00 00 00 48 63 40 50 48 C1 E0 03 4C 8B C0 33 D2 48 8B 4C 24 68 E8 ?? ?? ?? ?? 48 8D 44 24 3C 48 8B F8 33 C0 B9 01 00 00 00 F3 AA 48 8D 44 24 3C 48 89 84 24 A0 00 00 00 41 B9 7E 05 00 00 4C 8D 05 ?? ?? ?? ?? 48 8B 84 24 A0 00 00 00 0F B6 10 B9 18 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 70 48 83 7C 24 70 00 74 19 48 8B 54 24 68 48 8B 4C 24 70 E8 ?? ?? ?? ?? 48 89 84 24 80 00 00 00 EB 0C 48 C7 84 24 80 00 00 00 00 00 00 00 48 8B 84 24 80 00 00 00 48 89 84 24 A8 00 00 00 48 8B 84 24 A8 00 00 00 48 89 44 24 58 48 8B 84 24 F0 00 00 00 48 8B 8C 24 F0 00 00 00 8B 49 68 39 48 6C 7D 39 48 8B 84 24 F0 00 00 00 48 63 40 6C 48 8B 8C 24 F0 00 00 00 48 8B 49 60 48 8B 54 24 58 48 89 14 C1 48 8B 84 24 F0 00 00 00 8B 40 6C FF C0 48 8B 8C 24 F0 00 00 00 89 41 6C 48 8B 44 24 40 48 83 C0 08 48 8B 4C 24 58 48 87 08 48 8B 44 24 40 48 83 78 08 01 75 2D 48 8D 15 ?? ?? ?? ?? 48 8D 8C 24 C8 00 00 00 E8 ?? ?? ?? ?? 48 8D 8C 24 C8 00 00 00 E8 ?? ?? ?? ?? 48 8B 44 24 40 48 83 78 08 01 74 E7 0F B6 44 24 30 83 F8 01 74 4F 0F B6 44 24 30 85 C0 75 0C 48 8B 44 24 40 48 83 78 08 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 A3 05 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 33 C0 85 C0 75 A1 33 C0 85 C0 75 9B 48 8B 44 24 40 48 8B 40 08 48 89 44 24 40 E9 10 FC FF FF 83 7C 24 38 00 7D 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 A9 05 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 33 C0 85 C0 75 B9 33 C0 85 C0 75 B3 8B 44 24 38 48 81 C4 E0 00 00 00 5F C3 }
	condition:
		$1
}

rule file_67_35_0 {
	meta:
		name = "?dtor$0@?0??Add@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QEAAHPEAVVirtualProcessor@23@@Z@4HA"
		size = 47
		refs = "0012 ??_C@_0DK@HDEIFPBC@f?3?2dd?2vctools?2crt_bld?2self_64_am@ 0025 ??3@YAXPEAXV_ConcRTNewMoniker@@PEBDH@Z"
		altNames = "?dtor$0@?0??Add@?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@QEAAHPEAU?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@23@@Z@4HA ?dtor$0@?0??Add@?$ListArray@VExternalStatistics@details@Concurrency@@@details@Concurrency@@QEAAHPEAVExternalStatistics@23@@Z@4HA ?dtor$0@?0??Add@?$ListArray@VScheduleGroupBase@details@Concurrency@@@details@Concurrency@@QEAAHPEAVScheduleGroupBase@23@@Z@4HA ?dtor$0@?0??Add@?$ListArray@VScheduleGroupSegmentBase@details@Concurrency@@@details@Concurrency@@QEAAHPEAVScheduleGroupSegmentBase@23@@Z@4HA ?dtor$0@?0??Add@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QEAAHPEAVWorkQueue@23@@Z@4HA"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 41 B9 7E 05 00 00 4C 8D 05 ?? ?? ?? ?? 48 8B 85 A0 00 00 00 0F B6 10 48 8B 4D 70 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_67_36_0 {
	meta:
		name = "?AddVirtualProcessor@SchedulingNode@details@Concurrency@@QEAAPEAVVirtualProcessor@23@PEAUIVirtualProcessorRoot@3@_N@Z"
		size = 735
		refs = "0014 ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPEAVContextBase@23@XZ 002d ?PullFromFreePool@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QEAAPEAVVirtualProcessor@23@XZ 00b2 ?IsExternal@ContextBase@details@Concurrency@@QEBA_NXZ 00c0 ??_C@_1GO@IHMKLJHI@?$AAp?$AAC?$AAu?$AAr?$AAr?$AAe?$AAn?$AAt?$AAC?$AAo?$AAn?$AAt?$AAe?$AAx?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CB?$AAp?$AAC?$AAu?$AAr?$AAr?$AAe?$AAn@ 00cc ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 00e1 ??_C@_1HO@IEHEMAIL@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 00eb _CrtDbgReportW 0156 ?SetOversubscribedVProc@InternalContextBase@details@Concurrency@@QEAAXPEAVVirtualProcessor@23@@Z 016f ?GetMaskId@VirtualProcessor@details@Concurrency@@QEBAIXZ 0181 ?IncrementActiveResourcesByMask@SchedulerBase@details@Concurrency@@QEAAXI@Z 01dc ??_C@_1FA@JIICECBF@?$AAp?$AAC?$AAu?$AAr?$AAr?$AAe?$AAn?$AAt?$AAC?$AAo?$AAn?$AAt?$AAe?$AAx?$AAt?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AAf?$AAO?$AAv?$AAe?$AAr?$AAs?$AAu?$AAb@ 0234 ?Add@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QEAAHPEAVVirtualProcessor@23@@Z 0246 ?VirtualProcessorActive@SchedulerBase@details@Concurrency@@QEAA_N_N@Z 0265 ?GetScheduleGroupSegment@ContextBase@details@Concurrency@@QEBAPEAVScheduleGroupSegmentBase@23@XZ 027d ?GetAnonymousScheduleGroupSegment@SchedulingRing@details@Concurrency@@QEBAPEAVScheduleGroupSegmentBase@23@XZ 02d1 ?MakeAvailable@VirtualProcessor@details@Concurrency@@IEAAXW4AvailabilityType@123@_N@Z"
	strings:
		$1 = { 44 88 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 78 E8 ?? ?? ?? ?? 48 89 44 24 40 48 8B 84 24 80 00 00 00 48 83 C0 50 48 8B C8 E8 ?? ?? ?? ?? 48 89 44 24 38 48 83 7C 24 38 00 75 36 48 8B 84 24 80 00 00 00 48 8B 00 48 8B 8C 24 80 00 00 00 48 8B 09 48 8B 00 4C 8B 84 24 88 00 00 00 48 8B 94 24 80 00 00 00 FF 90 B8 00 00 00 48 89 44 24 38 EB 20 48 8B 44 24 38 48 8B 00 4C 8B 84 24 88 00 00 00 48 8B 94 24 80 00 00 00 48 8B 4C 24 38 FF 50 30 0F B6 84 24 90 00 00 00 85 C0 0F 84 B6 00 00 00 48 83 7C 24 40 00 74 11 48 8B 4C 24 40 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 50 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 33 C0 85 C0 75 A7 33 C0 85 C0 75 A1 48 83 7C 24 40 00 74 10 48 8B 44 24 40 48 83 E8 10 48 89 44 24 48 EB 09 48 C7 44 24 48 00 00 00 00 48 8B 44 24 48 48 89 44 24 50 48 8B 44 24 38 C6 80 F0 00 00 00 01 48 8B 44 24 38 48 8B 4C 24 50 48 89 88 F8 00 00 00 48 8B 54 24 38 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 48 83 C0 38 F0 FF 00 48 8B 4C 24 38 E8 ?? ?? ?? ?? 8B D0 48 8B 84 24 80 00 00 00 48 8B 08 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 48 8B 00 48 8B 8C 24 80 00 00 00 48 8B 09 8B 80 9C 02 00 00 8B 89 A0 02 00 00 3B C1 0F 85 FB 00 00 00 48 8B 84 24 80 00 00 00 48 8B 00 8B 40 1C 85 C0 0F 8E E5 00 00 00 48 83 7C 24 40 00 74 46 0F B6 84 24 90 00 00 00 85 C0 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 6D 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 33 C0 85 C0 75 AC 33 C0 85 C0 75 A6 48 8B 84 24 80 00 00 00 48 83 C0 50 48 8B 54 24 38 48 8B C8 E8 ?? ?? ?? ?? B2 01 48 8B 84 24 80 00 00 00 48 8B 08 E8 ?? ?? ?? ?? 88 44 24 30 0F B6 44 24 30 85 C0 74 51 48 83 7C 24 40 00 74 11 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 89 44 24 58 EB 16 48 8B 84 24 80 00 00 00 48 8B 48 08 E8 ?? ?? ?? ?? 48 89 44 24 58 48 8B 44 24 58 48 89 44 24 60 48 8B 44 24 38 48 8B 00 45 33 C0 48 8B 54 24 60 48 8B 4C 24 38 FF 50 38 EB 2B 48 8B 84 24 80 00 00 00 48 83 C0 50 48 8B 54 24 38 48 8B C8 E8 ?? ?? ?? ?? 45 33 C0 BA 01 00 00 00 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B 44 24 38 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_67_37_0 {
	meta:
		name = "?Claim@Slot@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QEAA_NPEAPEAVInternalContextBase@34@@Z"
		size = 226
		refs = "0036 ??_C@_1BK@NBINLAEN@?$AAp?$AAO?$AAb?$AAj?$AAe?$AAc?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 0042 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0057 ??_C@_1GM@BMGMKHD@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 0061 _CrtDbgReportW 00d7 ?Dereference@Segment@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 48 8B 44 24 50 48 8B 00 48 8B 4C 24 50 8B 49 08 48 8B 40 18 48 8B 04 C8 48 89 44 24 30 48 83 7C 24 30 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 DE 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 33 C0 85 C0 75 B8 33 C0 85 C0 75 B2 48 83 7C 24 30 01 74 4D 48 8B 44 24 50 48 8B 00 48 8B 4C 24 50 8B 49 08 48 8B 40 18 48 8D 04 C8 B9 01 00 00 00 48 87 08 48 8B C1 48 89 44 24 38 48 8B 44 24 30 48 39 44 24 38 75 19 48 83 7C 24 58 00 74 0D 48 8B 44 24 58 48 8B 4C 24 30 48 89 08 B0 01 EB 0F 48 8B 44 24 50 48 8B 08 E8 ?? ?? ?? ?? 32 C0 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_268_75_0 {
	meta:
		name = "?Claim@Slot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QEAA_NPEAPEAV_UnrealizedChore@34@@Z"
		size = 226
		refs = "0036 ??_C@_1BK@NBINLAEN@?$AAp?$AAO?$AAb?$AAj?$AAe?$AAc?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 0042 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0057 ??_C@_1GM@BMGMKHD@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 0061 _CrtDbgReportW 00d7 ?Dereference@Segment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 48 8B 44 24 50 48 8B 00 48 8B 4C 24 50 8B 49 08 48 8B 40 18 48 8B 04 C8 48 89 44 24 30 48 83 7C 24 30 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 DE 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 33 C0 85 C0 75 B8 33 C0 85 C0 75 B2 48 83 7C 24 30 01 74 4D 48 8B 44 24 50 48 8B 00 48 8B 4C 24 50 8B 49 08 48 8B 40 18 48 8D 04 C8 B9 01 00 00 00 48 87 08 48 8B C1 48 89 44 24 38 48 8B 44 24 30 48 39 44 24 38 75 19 48 83 7C 24 58 00 74 0D 48 8B 44 24 58 48 8B 4C 24 30 48 89 08 B0 01 EB 0F 48 8B 44 24 50 48 8B 08 E8 ?? ?? ?? ?? 32 C0 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_67_39_0 {
	meta:
		name = "?CopyFrom@QuickBitSet@details@Concurrency@@IEAAXAEBV123@@Z"
		size = 131
		refs = "002b ?Reallocate@QuickBitSet@details@Concurrency@@IEAAXI@Z 0035 ?ASIZE@QuickBitSet@details@Concurrency@@IEBAIXZ"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 48 8B 4C 24 48 8B 09 39 08 74 11 48 8B 44 24 48 8B 10 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 4C 24 40 E8 ?? ?? ?? ?? 89 44 24 24 C7 44 24 20 00 00 00 00 EB 0A 8B 44 24 20 FF C0 89 44 24 20 8B 44 24 24 39 44 24 20 73 23 8B 44 24 20 48 8B 4C 24 48 48 8B 49 08 8B 54 24 20 4C 8B 44 24 40 4D 8B 40 08 8B 04 81 41 89 04 90 EB C9 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_67_40_0 {
	meta:
		name = "?DeferToAffineSearchers@Slot@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QEBA_NXZ"
		size = 172
		refs = "000a ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPEAVContextBase@23@XZ 0059 ?HasSearchers@SchedulerBase@details@Concurrency@@QEBA_NAEBVQuickBitSet@23@@Z 006a ?_GetVirtualProcessor@InternalContextBase@details@Concurrency@@IEBAPEAVVirtualProcessor@23@XZ 0072 ?GetMaskId@VirtualProcessor@details@Concurrency@@QEBAIXZ 0085 ?IsSet@QuickBitSet@details@Concurrency@@QEBA_NI@Z"
		altNames = "?DeferToAffineSearchers@Slot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QEBA_NXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 48 E8 ?? ?? ?? ?? 48 89 44 24 28 48 83 7C 24 28 00 74 10 48 8B 44 24 28 48 83 E8 10 48 89 44 24 30 EB 09 48 C7 44 24 30 00 00 00 00 48 8B 44 24 30 48 89 44 24 38 48 8B 44 24 50 48 8B 00 48 83 C0 08 48 8B 4C 24 50 48 8B 09 48 8B D0 48 8B 09 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 36 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 8B 4C 24 50 48 8B 09 48 83 C1 08 8B D0 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 0A C7 44 24 20 01 00 00 00 EB 08 C7 44 24 20 00 00 00 00 0F B6 44 24 20 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_67_41_0 {
	meta:
		name = "?DeleteElements@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@AEAAXPEAU_SLIST_ENTRY@@@Z"
		size = 68
		refs = "0039 ??$_InternalDeleteHelper@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@YAXPEAVVirtualProcessor@01@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 83 7C 24 48 00 74 29 48 8B 44 24 48 48 2D 10 01 00 00 48 89 44 24 20 48 8B 44 24 48 48 8B 00 48 89 44 24 48 48 8B 4C 24 20 E8 ?? ?? ?? ?? EB CF 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_67_44_0 {
	meta:
		name = "?Dereference@Segment@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QEAAXXZ"
		size = 50
		refs = "0029 ?Expire@Segment@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 83 C0 24 B9 FF FF FF FF F0 0F C1 08 FF C9 8B C1 85 C0 75 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_268_92_0 {
	meta:
		name = "?Dereference@Segment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QEAAXXZ"
		size = 50
		refs = "0029 ?Expire@Segment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 83 C0 24 B9 FF FF FF FF F0 0F C1 08 FF C9 8B C1 85 C0 75 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_67_45_0 {
	meta:
		name = "?Expire@Segment@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QEAAXXZ"
		size = 51
		refs = "0022 ?StaticDelete@Segment@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@SAXPEAU1234@@Z 002a ?InvokeAtNextSafePoint@SafePointInvocation@details@Concurrency@@QEAAXP6AXPEAX@Z0PEAVSchedulerBase@23@@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 83 C0 30 48 8B 4C 24 30 4C 8B 09 4C 8B 44 24 30 48 8D 15 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_268_107_0 {
	meta:
		name = "?Expire@Segment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QEAAXXZ"
		size = 51
		refs = "0022 ?StaticDelete@Segment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@SAXPEAU1234@@Z 002a ?InvokeAtNextSafePoint@SafePointInvocation@details@Concurrency@@QEAAXP6AXPEAX@Z0PEAVSchedulerBase@23@@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 83 C0 30 48 8B 4C 24 30 4C 8B 09 4C 8B 44 24 30 48 8D 15 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_67_46_0 {
	meta:
		name = "?FindMatchingVirtualProcessor@SchedulingNode@details@Concurrency@@QEAAPEAVVirtualProcessor@23@PEAUIVirtualProcessorRoot@3@@Z"
		size = 131
		refs = "001b ?MaxIndex@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QEAAHXZ 0052 ??A?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QEBAPEAVVirtualProcessor@12@H@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 48 83 C0 50 48 8B C8 E8 ?? ?? ?? ?? 89 44 24 24 C7 44 24 20 00 00 00 00 EB 0A 8B 44 24 20 FF C0 89 44 24 20 8B 44 24 24 39 44 24 20 7D 3B 48 8B 44 24 40 48 83 C0 50 8B 54 24 20 48 8B C8 E8 ?? ?? ?? ?? 48 89 44 24 28 48 83 7C 24 28 00 74 17 48 8B 44 24 28 48 8B 4C 24 48 48 39 48 78 75 07 48 8B 44 24 28 EB 04 EB B1 33 C0 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_67_47_0 {
	meta:
		name = "?FindVirtualProcessorByLocation@SchedulingNode@details@Concurrency@@QEAAPEAVVirtualProcessor@23@PEBVlocation@3@@Z"
		size = 198
		refs = "0014 ?_GetType@location@Concurrency@@QEBA?AW4_Type@12@XZ 0032 ?IsLocationBound@SchedulerBase@details@Concurrency@@QEBA_NPEBVlocation@3@@Z 0043 ??$_As@VVirtualProcessor@details@Concurrency@@@location@Concurrency@@QEBAPEAVVirtualProcessor@details@1@XZ 006a ?MaxIndex@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QEAAHXZ 0085 ??A?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QEBAPEAVVirtualProcessor@12@H@Z 009c ?GetExecutionResourceId@VirtualProcessor@details@Concurrency@@QEBAIXZ 00aa ?_GetId@location@Concurrency@@QEBAIXZ"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 4C 24 48 E8 ?? ?? ?? ?? 83 F8 03 74 07 33 C0 E9 9D 00 00 00 48 8B 54 24 48 48 8B 44 24 40 48 8B 08 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 0C 48 8B 4C 24 48 E8 ?? ?? ?? ?? EB 78 C7 44 24 20 00 00 00 00 EB 0A 8B 44 24 20 FF C0 89 44 24 20 48 8B 44 24 40 48 83 C0 50 48 8B C8 E8 ?? ?? ?? ?? 39 44 24 20 7D 4B 48 8B 44 24 40 48 83 C0 50 8B 54 24 20 48 8B C8 E8 ?? ?? ?? ?? 48 89 44 24 28 48 83 7C 24 28 00 74 27 48 8B 4C 24 28 E8 ?? ?? ?? ?? 89 44 24 24 48 8B 4C 24 48 E8 ?? ?? ?? ?? 8B 4C 24 24 3B C8 75 07 48 8B 44 24 28 EB 04 EB 94 33 C0 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_67_48_0 {
	meta:
		name = "?FoundAvailableVirtualProcessor@SchedulingNode@details@Concurrency@@AEAA_NAEAVClaimTicket@VirtualProcessor@23@Vlocation@3@K@Z"
		size = 386
		refs = "0027 ?_GetType@location@Concurrency@@QEBA?AW4_Type@12@XZ 003f ?FindVirtualProcessorByLocation@SchedulingNode@details@Concurrency@@QEAAPEAVVirtualProcessor@23@PEBVlocation@3@@Z 0056 ?GetOwningNode@VirtualProcessor@details@Concurrency@@QEAAPEAVSchedulingNode@23@XZ 0064 ??_C@_1GC@CGLBAGJD@?$AA?$CB?$AAp?$AAB?$AAi?$AAa?$AAs?$AAP?$AAr?$AAo?$AAc?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AAp?$AAB?$AAi?$AAa?$AAs?$AAP?$AAr?$AAo?$AAc?$AA?9?$AA?$DO?$AAG?$AAe?$AAt?$AAO?$AAw?$AAn?$AAi@ 0070 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0085 ??_C@_1HO@IEHEMAIL@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 008f _CrtDbgReportW 00c2 ?ClaimExclusiveOwnership@VirtualProcessor@details@Concurrency@@QEAA_NAEAVClaimTicket@123@K_N@Z 00d8 ??1location@Concurrency@@QEAA@XZ 0107 ?MaxIndex@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QEAAHXZ 0122 ??A?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QEBAPEAVVirtualProcessor@12@H@Z"
	strings:
		$1 = { 44 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 58 48 C7 44 24 48 FE FF FF FF 48 8B 4C 24 70 E8 ?? ?? ?? ?? 83 F8 03 0F 85 B2 00 00 00 48 8B 54 24 70 48 8B 4C 24 60 E8 ?? ?? ?? ?? 48 89 44 24 38 48 83 7C 24 38 00 74 4B 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 3B 44 24 60 74 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 F3 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 33 C0 85 C0 75 A7 33 C0 85 C0 75 A1 48 83 7C 24 38 00 74 37 41 B1 01 44 8B 44 24 78 48 8B 54 24 68 48 8B 4C 24 38 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 19 C6 44 24 30 01 48 8B 4C 24 70 E8 ?? ?? ?? ?? 0F B6 44 24 30 E9 97 00 00 00 C7 44 24 34 00 00 00 00 EB 0A 8B 44 24 34 FF C0 89 44 24 34 48 8B 44 24 60 48 83 C0 50 48 8B C8 E8 ?? ?? ?? ?? 39 44 24 34 7D 58 48 8B 44 24 60 48 83 C0 50 8B 54 24 34 48 8B C8 E8 ?? ?? ?? ?? 48 89 44 24 40 48 83 7C 24 40 00 74 34 41 B1 01 44 8B 44 24 78 48 8B 54 24 68 48 8B 4C 24 40 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 16 C6 44 24 31 01 48 8B 4C 24 70 E8 ?? ?? ?? ?? 0F B6 44 24 31 EB 16 EB 87 C6 44 24 32 00 48 8B 4C 24 70 E8 ?? ?? ?? ?? 0F B6 44 24 32 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_67_49_0 {
	meta:
		name = "?dtor$0@?0??FoundAvailableVirtualProcessor@SchedulingNode@details@Concurrency@@AEAA_NAEAVClaimTicket@VirtualProcessor@23@Vlocation@3@K@Z@4HA"
		size = 24
		refs = "000e ??1location@Concurrency@@QEAA@XZ"
		altNames = "?dtor$0@?0??StartupNewVirtualProcessor@SchedulerBase@details@Concurrency@@UEAAXPEAVScheduleGroupSegmentBase@23@Vlocation@3@@Z@4HA"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 70 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_61_447_2 {
	meta:
		name = "?dtor$0@?0???1?$_Order_node_base@W4agent_status@Concurrency@@@Concurrency@@UEAA@XZ@4HA"
		size = 24
		refs = "000e ??1?$propagator_block@V?$single_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@_K@2@@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 70 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_78_545_1 {
	meta:
		name = "?dtor$0@?0???1_Blocking_recipient@?1???$_Receive_impl@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@1@PEAV?$ISource@W4agent_status@Concurrency@@@1@IPEBV?$function@$$A6A_NAEBW4agent_status@Concurrency@@@Z@std@@@Z@UEAA@XZ@4HA"
		size = 24
		refs = "000e ??1?$ITarget@W4agent_status@Concurrency@@@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 70 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_78_548_1 {
	meta:
		name = "?dtor$0@?0???1_Blocking_recipient@?1???$_Receive_impl@_K@Concurrency@@YA_KPEAV?$ISource@_K@1@IPEBV?$function@$$A6A_NAEB_K@Z@std@@@Z@UEAA@XZ@4HA"
		size = 24
		refs = "000e ??1?$ITarget@_K@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 70 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_105_277_2 {
	meta:
		name = "?dtor$4@?0???$insert@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@@?$vector@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@2@@std@@QEAA?AV?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@1@V?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@1@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@1@1@Z@4HA"
		size = 24
		refs = "000e ??1?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 70 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_105_284_2 {
	meta:
		name = "?dtor$4@?0???$insert@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@@?$vector@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@2@@std@@QEAA?AV?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@1@V?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@1@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@1@1@Z@4HA"
		size = 24
		refs = "000e ??1?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 70 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_92_519_2 {
	meta:
		name = "?dtor$7@?0??replace@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@V?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@2@0V?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@2@1@Z@4HA"
		size = 24
		refs = "000e ??1?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 70 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_66_1314_3 {
	meta:
		name = "?dtor$7@?0??replace@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEAAAEAV12@V?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@2@0V?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@2@1@Z@4HA"
		size = 24
		refs = "000e ??1?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 70 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_36_1292_2 {
	meta:
		name = "?dtor$7@?0??replace@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAAAEAV12@V?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@2@0V?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@2@1@Z@4HA"
		size = 24
		refs = "000e ??1?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 70 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_67_50_0 {
	meta:
		name = "?FreeNode@?$Hash@II@details@Concurrency@@CAXPEAUListNode@123@@Z"
		size = 68
		refs = "0016 ?DeleteKey@?$Hash@II@details@Concurrency@@CAXAEAI@Z 0027 ?DeleteValue@?$Hash@II@details@Concurrency@@CAXAEAI@Z 003b ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 48 83 C0 08 48 8B C8 E8 ?? ?? ?? ?? 48 8B 44 24 40 48 83 C0 0C 48 8B C8 E8 ?? ?? ?? ?? 48 8B 44 24 40 48 89 44 24 20 48 8B 4C 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_67_52_0 {
	meta:
		name = "?GetExecutionResourceId@VirtualProcessor@details@Concurrency@@QEBAIXZ"
		size = 17
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 8B 80 C0 00 00 00 C3 }
	condition:
		$1
}

rule file_67_53_0 {
	meta:
		name = "?GetLocation@SchedulingNode@details@Concurrency@@QEAA?AVlocation@3@XZ"
		size = 102
		refs = "004d ??0location@Concurrency@@QEAA@W4_Type@01@IIPEAX@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 C7 44 24 30 00 00 00 00 48 8B 44 24 50 48 8B 00 48 8B 4C 24 50 48 8B 09 48 8B 00 FF 50 08 48 8B 4C 24 50 48 89 4C 24 20 44 8B C8 48 8B 44 24 50 44 8B 40 44 BA 02 00 00 00 48 8B 4C 24 58 E8 ?? ?? ?? ?? 8B 44 24 30 83 C8 01 89 44 24 30 48 8B 44 24 58 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_67_54_0 {
	meta:
		name = "?GetMaskId@VirtualProcessor@details@Concurrency@@QEBAIXZ"
		size = 17
		altNames = "?ContextStackSize@SchedulerProxy@details@Concurrency@@QEBAHXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 8B 80 C4 00 00 00 C3 }
	condition:
		$1
}

rule file_67_56_0 {
	meta:
		name = "?HasSearchers@SchedulerBase@details@Concurrency@@QEBA_NAEBVQuickBitSet@23@@Z"
		size = 41
		refs = "0020 ?Intersects@QuickBitSet@details@Concurrency@@QEBA_NAEBV123@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 83 C0 60 48 8B 54 24 38 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_78_1186_1 {
	meta:
		name = "?set_bound@?$source_link_manager@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@QEAAX_K@Z"
		size = 41
		refs = "0020 ?set_bound@?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@QEAAX_K@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 83 C0 60 48 8B 54 24 38 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_67_57_0 {
	meta:
		name = "?Id@SchedulingRing@details@Concurrency@@QEBAHXZ"
		size = 17
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 8B 80 28 01 00 00 C3 }
	condition:
		$1
}

rule file_67_58_0 {
	meta:
		name = "?IncrementActiveResourcesByMask@SchedulerBase@details@Concurrency@@QEAAXI@Z"
		size = 39
		refs = "001e ?InterlockedSet@ReferenceCountedQuickBitSet@details@Concurrency@@QEAAII@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 83 C0 48 8B 54 24 38 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_321_50_0 {
	meta:
		name = "?DecrementActiveResourcesByMask@SchedulerBase@details@Concurrency@@QEAAXI@Z"
		size = 39
		refs = "001e ?InterlockedClear@ReferenceCountedQuickBitSet@details@Concurrency@@QEAAII@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 83 C0 48 8B 54 24 38 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_67_59_0 {
	meta:
		name = "?InterlockedSet@QuickBitSet@details@Concurrency@@QEAAXI@Z"
		size = 151
		refs = "001d ??_C@_1CG@LFGKFKE@?$AAb?$AAi?$AAt?$AAN?$AAu?$AAm?$AAb?$AAe?$AAr?$AA?5?$AA?$DM?$AA?5?$AAm?$AA_?$AAs?$AAi?$AAz?$AAe?$AA?$AA@ 0029 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 003e ??_C@_1HE@BOBCMOIJ@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 0048 _CrtDbgReportW"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 48 48 8B 44 24 50 8B 00 39 44 24 58 72 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 AF 07 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 33 C0 85 C0 75 B3 33 C0 85 C0 75 AD 8B 44 24 58 83 E0 1F B9 01 00 00 00 89 4C 24 30 0F B6 C8 8B 44 24 30 D3 E0 8B 4C 24 58 C1 E9 05 8B C9 48 8B 54 24 50 48 8B 52 08 48 8D 0C 8A F0 09 01 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_67_60_0 {
	meta:
		name = "?InterlockedSet@ReferenceCountedQuickBitSet@details@Concurrency@@QEAAII@Z"
		size = 251
		refs = "001d ??_C@_1CG@LFGKFKE@?$AAb?$AAi?$AAt?$AAN?$AAu?$AAm?$AAb?$AAe?$AAr?$AA?5?$AA?$DM?$AA?5?$AAm?$AA_?$AAs?$AAi?$AAz?$AAe?$AA?$AA@ 0029 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 003e ??_C@_1HE@BOBCMOIJ@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 0048 _CrtDbgReportW 008c ??_C@_1BA@ILKEJOIJ@?$AAv?$AAa?$AAl?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 00e0 ?SpinUntilClear@QuickBitSet@details@Concurrency@@QEBAXI@Z 00ee ?InterlockedSet@QuickBitSet@details@Concurrency@@QEAAXI@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 48 48 8B 44 24 50 8B 00 39 44 24 58 72 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 65 08 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 33 C0 85 C0 75 B3 33 C0 85 C0 75 AD 8B 44 24 58 48 8B 4C 24 50 48 8B 49 10 48 8D 04 81 B9 01 00 00 00 F0 0F C1 08 FF C1 8B C1 89 44 24 30 83 7C 24 30 00 7F 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 68 08 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 33 C0 85 C0 75 B9 33 C0 85 C0 75 B3 83 7C 24 30 01 75 1C 8B 54 24 58 48 8B 4C 24 50 E8 ?? ?? ?? ?? 8B 54 24 58 48 8B 4C 24 50 E8 ?? ?? ?? ?? 8B 44 24 30 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_67_61_0 {
	meta:
		name = "?Intersects@QuickBitSet@details@Concurrency@@QEBA_NAEBV123@@Z"
		size = 243
		refs = "0021 ??_C@_1DI@DPDJJEPO@?$AAc?$AAo?$AAm?$AAp?$AAa?$AAr?$AAa?$AAt?$AAo?$AAr?$AA?4?$AAm?$AA_?$AAs?$AAi?$AAz?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAm?$AA_?$AAs?$AAi?$AAz?$AAe?$AA?$AA@ 002d ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0042 ??_C@_1HE@BOBCMOIJ@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 004c _CrtDbgReportW 0072 ?ASIZE@QuickBitSet@details@Concurrency@@IEBAIXZ"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 48 8B 44 24 58 48 8B 4C 24 50 8B 09 39 08 74 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 8A 07 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 33 C0 85 C0 75 B0 33 C0 85 C0 75 AA C7 44 24 34 00 00 00 00 48 8B 4C 24 50 E8 ?? ?? ?? ?? 89 44 24 3C C7 44 24 30 00 00 00 00 EB 0A 8B 44 24 30 FF C0 89 44 24 30 8B 44 24 3C 39 44 24 30 73 38 83 7C 24 34 00 75 31 8B 44 24 30 48 8B 4C 24 50 48 8B 49 08 8B 54 24 30 4C 8B 44 24 58 4D 8B 40 08 41 8B 14 90 8B 04 81 23 C2 8B 4C 24 34 0B C8 8B C1 89 44 24 34 EB B4 83 7C 24 34 00 74 0A C7 44 24 38 01 00 00 00 EB 08 C7 44 24 38 00 00 00 00 0F B6 44 24 38 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_67_62_0 {
	meta:
		name = "?IsExternal@ContextBase@details@Concurrency@@QEBA_NXZ"
		size = 18
		altNames = "?ExecutingAffine@VirtualProcessor@details@Concurrency@@QEAA_NXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 0F B6 80 88 00 00 00 C3 }
	condition:
		$1
}

rule file_67_63_0 {
	meta:
		name = "?IsLocationBound@SchedulerBase@details@Concurrency@@QEBA_NPEBVlocation@3@@Z"
		size = 65
		refs = "0014 ?_GetBindingId@location@Concurrency@@QEBAIXZ"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 4C 24 48 E8 ?? ?? ?? ?? 48 8B 4C 24 40 3B 81 58 02 00 00 75 0A C7 44 24 20 01 00 00 00 EB 08 C7 44 24 20 00 00 00 00 0F B6 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_67_64_0 {
	meta:
		name = "?IsSet@QuickBitSet@details@Concurrency@@QEBA_NI@Z"
		size = 98
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 18 8B 44 24 28 C1 E8 05 8B C0 48 8B 4C 24 20 48 8B 49 08 48 89 4C 24 08 8B 54 24 28 83 E2 1F 41 B8 01 00 00 00 0F B6 CA 41 8B D0 D3 E2 8B CA 48 8B 54 24 08 8B 04 82 23 C1 85 C0 74 09 C7 04 24 01 00 00 00 EB 07 C7 04 24 00 00 00 00 0F B6 04 24 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_67_66_0 {
	meta:
		name = "?PullFromFreePool@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QEAAPEAVVirtualProcessor@23@XZ"
		size = 66
		refs = "0013 __imp_InterlockedPopEntrySList"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 48 8B C8 FF 15 ?? ?? ?? ?? 48 89 44 24 20 48 83 7C 24 20 00 75 04 33 C0 EB 15 48 8B 44 24 20 48 2D 10 01 00 00 48 89 44 24 28 48 8B 44 24 28 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_67_67_0 {
	meta:
		name = "?Reallocate@QuickBitSet@details@Concurrency@@IEAAXI@Z"
		size = 158
		refs = "0022 ??_V@YAXPEAX@Z 0048 ?ASIZE@QuickBitSet@details@Concurrency@@IEBAIXZ 0074 ??_C@_0DK@HDEIFPBC@f?3?2dd?2vctools?2crt_bld?2self_64_am@ 0081 ??_U@YAPEAX_KV_ConcRTNewMoniker@@PEBDH@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 57 48 83 EC 40 48 8B 44 24 50 48 8B 40 08 48 89 44 24 28 48 8B 4C 24 28 E8 ?? ?? ?? ?? 48 8B 44 24 50 8B 4C 24 58 89 08 48 8D 44 24 20 48 8B F8 33 C0 B9 01 00 00 00 F3 AA 48 8B 4C 24 50 E8 ?? ?? ?? ?? 8B C0 48 89 44 24 30 B8 04 00 00 00 48 8B 4C 24 30 48 F7 E1 48 C7 C1 FF FF FF FF 48 0F 40 C1 41 B9 15 08 00 00 4C 8D 05 ?? ?? ?? ?? 0F B6 54 24 20 48 8B C8 E8 ?? ?? ?? ?? 48 89 44 24 38 48 8B 44 24 50 48 8B 4C 24 38 48 89 48 08 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_67_68_0 {
	meta:
		name = "?SetDebugBits@InternalContextBase@details@Concurrency@@QEAAXK@Z"
		size = 38
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 8B 44 24 08 8B 4C 24 10 8B 80 3C 01 00 00 0B C1 48 8B 4C 24 08 89 81 3C 01 00 00 C3 }
	condition:
		$1
}

rule file_67_69_0 {
	meta:
		name = "?SetOversubscribedVProc@InternalContextBase@details@Concurrency@@QEAAXPEAVVirtualProcessor@23@@Z"
		size = 28
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 8B 44 24 08 48 8B 4C 24 10 48 89 88 10 01 00 00 C3 }
	condition:
		$1
}

rule file_67_70_0 {
	meta:
		name = "?SpinUntilClear@QuickBitSet@details@Concurrency@@QEBAXI@Z"
		size = 133
		refs = "0057 ?_Sleep0@details@Concurrency@@YAXXZ 0061 ??0?$_SpinWait@$00@details@Concurrency@@QEAA@P6AXXZ@Z 007a ?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QEAA_NXZ"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 58 8B 44 24 68 C1 E8 05 8B C0 48 8B 4C 24 60 48 8B 49 08 48 8D 04 81 48 89 44 24 28 8B 44 24 68 83 E0 1F B9 01 00 00 00 89 4C 24 24 0F B6 C8 8B 44 24 24 D3 E0 89 44 24 20 48 8B 44 24 28 8B 00 23 44 24 20 85 C0 74 2C 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 28 8B 00 23 44 24 20 85 C0 74 0C 48 8D 4C 24 30 E8 ?? ?? ?? ?? EB E5 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_67_71_0 {
	meta:
		name = "?StaticDelete@Segment@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@SAXPEAU1234@@Z"
		size = 73
		refs = "0030 ??_GSegment@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QEAAPEAXI@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 48 48 8B 44 24 50 48 89 44 24 28 48 8B 44 24 28 48 89 44 24 20 48 83 7C 24 20 00 74 16 BA 01 00 00 00 48 8B 4C 24 20 E8 ?? ?? ?? ?? 48 89 44 24 30 EB 09 48 C7 44 24 30 00 00 00 00 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_268_0_0 {
	meta:
		name = "??$_InternalDeleteHelper@VWorkQueue@details@Concurrency@@@details@Concurrency@@YAXPEAVWorkQueue@01@@Z"
		size = 73
		refs = "0030 ??_GWorkQueue@details@Concurrency@@QEAAPEAXI@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 48 48 8B 44 24 50 48 89 44 24 28 48 8B 44 24 28 48 89 44 24 20 48 83 7C 24 20 00 74 16 BA 01 00 00 00 48 8B 4C 24 20 E8 ?? ?? ?? ?? 48 89 44 24 30 EB 09 48 C7 44 24 30 00 00 00 00 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_1003_52_0 {
	meta:
		name = "?DeleteThis@SchedulerProxy@details@Concurrency@@MEAAXXZ"
		size = 73
		refs = "0030 ??_GSchedulerProxy@details@Concurrency@@IEAAPEAXI@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 48 48 8B 44 24 50 48 89 44 24 28 48 8B 44 24 28 48 89 44 24 20 48 83 7C 24 20 00 74 16 BA 01 00 00 00 48 8B 4C 24 20 E8 ?? ?? ?? ?? 48 89 44 24 30 EB 09 48 C7 44 24 30 00 00 00 00 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_268_199_0 {
	meta:
		name = "?StaticDelete@Segment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@SAXPEAU1234@@Z"
		size = 73
		refs = "0030 ??_GSegment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QEAAPEAXI@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 48 48 8B 44 24 50 48 89 44 24 28 48 8B 44 24 28 48 89 44 24 20 48 83 7C 24 20 00 74 16 BA 01 00 00 00 48 8B 4C 24 20 E8 ?? ?? ?? ?? 48 89 44 24 30 EB 09 48 C7 44 24 30 00 00 00 00 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_67_72_0 {
	meta:
		name = "?Steal@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QEAAPEAVInternalContextBase@23@_N@Z"
		size = 82
		refs = "0025 ??0_Scoped_lock@_HyperNonReentrantLock@details@Concurrency@@QEAA@AEAV123@@Z 0035 ?UnlockedSteal@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QEAAPEAVInternalContextBase@23@_N@Z 0044 ??1_Scoped_lock@_HyperNonReentrantLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 88 54 24 10 48 89 4C 24 08 48 83 EC 48 48 C7 44 24 30 FE FF FF FF 48 8B 44 24 50 48 8B 50 20 48 8D 4C 24 20 E8 ?? ?? ?? ?? 90 0F B6 54 24 58 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 89 44 24 28 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 28 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_67_74_0 {
	meta:
		name = "?StealLocalRunnableContext@SchedulingNode@details@Concurrency@@AEAAPEAVInternalContextBase@23@PEAVVirtualProcessor@23@@Z"
		size = 246
		refs = "0024 ?MaxIndex@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QEAAHXZ 00a3 ??A?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QEBAPEAVVirtualProcessor@12@H@Z 00c5 ?Steal@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QEAAPEAVInternalContextBase@23@_N@Z 00e1 ?SetDebugBits@InternalContextBase@details@Concurrency@@QEAAXK@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 58 48 C7 44 24 38 00 00 00 00 48 8B 44 24 60 48 83 C0 50 48 8B C8 E8 ?? ?? ?? ?? 89 44 24 2C 48 83 7C 24 68 00 74 19 48 8B 44 24 68 8B 80 8C 00 00 00 89 44 24 28 C7 44 24 24 01 00 00 00 EB 10 C7 44 24 28 00 00 00 00 C7 44 24 24 00 00 00 00 8B 44 24 24 89 44 24 20 EB 0A 8B 44 24 20 FF C0 89 44 24 20 8B 44 24 2C 39 44 24 20 7D 71 8B 44 24 28 8B 4C 24 20 03 C8 8B C1 99 F7 7C 24 2C 8B C2 89 44 24 30 48 8B 44 24 60 48 83 C0 50 8B 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 48 89 44 24 40 48 83 7C 24 40 00 75 02 EB B1 48 8B 44 24 40 48 83 C0 10 33 D2 48 8B C8 E8 ?? ?? ?? ?? 48 89 44 24 38 48 83 7C 24 38 00 74 11 BA 10 00 00 00 48 8B 4C 24 38 E8 ?? ?? ?? ?? EB 05 E9 7B FF FF FF 48 8B 44 24 38 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_67_75_0 {
	meta:
		name = "?UnlockedSteal@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QEAAPEAVInternalContextBase@23@_N@Z"
		size = 327
		refs = "0083 ?DeferToAffineSearchers@Slot@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QEBA_NXZ 0102 ?Claim@Slot@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QEAA_NPEAPEAVInternalContextBase@34@@Z"
	strings:
		$1 = { 88 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 8B 00 48 8B 4C 24 40 8B 49 04 3B C1 0F 8D 1C 01 00 00 48 8B 44 24 40 8B 00 89 44 24 20 48 8B 44 24 40 8B 40 08 8B 4C 24 20 23 C8 8B C1 48 98 48 8B 4C 24 40 48 8B 49 10 48 8B 04 C1 48 83 E0 01 48 85 C0 74 3E 0F B6 44 24 48 85 C0 75 35 48 8B 44 24 40 8B 40 08 8B 4C 24 20 23 C8 8B C1 48 98 48 6B C0 10 48 8B 4C 24 40 48 03 41 18 48 8B C8 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 07 33 C0 E9 AD 00 00 00 48 8B 44 24 40 8B 40 08 8B 4C 24 20 23 C8 8B C1 48 98 48 8B 4C 24 40 48 8B 49 10 48 8D 04 C1 33 C9 48 87 08 48 8B C1 48 89 44 24 28 48 8B 44 24 28 48 83 E0 01 48 85 C0 74 50 48 8B 44 24 28 48 83 E0 FE 48 89 44 24 28 48 8B 44 24 40 8B 40 08 8B 4C 24 20 23 C8 8B C1 48 98 48 6B C0 10 48 8B 4C 24 40 48 03 41 18 33 D2 48 8B C8 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 12 8B 44 24 20 FF C0 48 8B 4C 24 40 89 01 E9 EE FE FF FF 48 83 7C 24 28 00 74 0D 8B 44 24 20 FF C0 48 8B 4C 24 40 89 01 48 8B 44 24 28 EB 07 E9 CD FE FF FF 33 C0 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_595_56_0 {
	meta:
		name = "?UnlockedSteal@?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QEAAPEAV_UnrealizedChore@23@_N@Z"
		size = 327
		refs = "0083 ?DeferToAffineSearchers@Slot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QEBA_NXZ 0102 ?Claim@Slot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QEAA_NPEAPEAV_UnrealizedChore@34@@Z"
	strings:
		$1 = { 88 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 8B 00 48 8B 4C 24 40 8B 49 04 3B C1 0F 8D 1C 01 00 00 48 8B 44 24 40 8B 00 89 44 24 20 48 8B 44 24 40 8B 40 08 8B 4C 24 20 23 C8 8B C1 48 98 48 8B 4C 24 40 48 8B 49 10 48 8B 04 C1 48 83 E0 01 48 85 C0 74 3E 0F B6 44 24 48 85 C0 75 35 48 8B 44 24 40 8B 40 08 8B 4C 24 20 23 C8 8B C1 48 98 48 6B C0 10 48 8B 4C 24 40 48 03 41 18 48 8B C8 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 07 33 C0 E9 AD 00 00 00 48 8B 44 24 40 8B 40 08 8B 4C 24 20 23 C8 8B C1 48 98 48 8B 4C 24 40 48 8B 49 10 48 8D 04 C1 33 C9 48 87 08 48 8B C1 48 89 44 24 28 48 8B 44 24 28 48 83 E0 01 48 85 C0 74 50 48 8B 44 24 28 48 83 E0 FE 48 89 44 24 28 48 8B 44 24 40 8B 40 08 8B 4C 24 20 23 C8 8B C1 48 98 48 6B C0 10 48 8B 4C 24 40 48 03 41 18 33 D2 48 8B C8 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 12 8B 44 24 20 FF C0 48 8B 4C 24 40 89 01 E9 EE FE FF FF 48 83 7C 24 28 00 74 0D 8B 44 24 20 FF C0 48 8B 4C 24 40 89 01 48 8B 44 24 28 EB 07 E9 CD FE FF FF 33 C0 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_67_76_0 {
	meta:
		name = "?Wipe@?$Hash@II@details@Concurrency@@QEAAXXZ"
		size = 173
		refs = "006b ?FreeNode@?$Hash@II@details@Concurrency@@CAXPEAUListNode@123@@Z 00a4 memset"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 48 48 8B 44 24 50 83 78 04 00 0F 8E 90 00 00 00 C7 44 24 20 00 00 00 00 EB 0A 8B 44 24 20 FF C0 89 44 24 20 48 8B 44 24 50 8B 00 39 44 24 20 7D 44 48 63 44 24 20 48 8B 4C 24 50 48 8B 49 08 48 8B 04 C1 48 89 44 24 28 48 83 7C 24 28 00 74 23 48 8B 44 24 28 48 8B 00 48 89 44 24 30 48 8B 4C 24 28 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 89 44 24 28 EB D5 EB A5 48 8B 44 24 50 C7 40 04 00 00 00 00 48 8B 44 24 50 48 63 00 48 C1 E0 03 4C 8B C0 33 D2 48 8B 44 24 50 48 8B 48 08 E8 ?? ?? ?? ?? 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_268_221_0 {
	meta:
		name = "?Wipe@?$Hash@PEAV_TaskCollection@details@Concurrency@@PEAV123@@details@Concurrency@@QEAAXXZ"
		size = 173
		refs = "006b ?FreeNode@?$Hash@PEAV_TaskCollection@details@Concurrency@@PEAV123@@details@Concurrency@@CAXPEAUListNode@123@@Z 00a4 memset"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 48 48 8B 44 24 50 83 78 04 00 0F 8E 90 00 00 00 C7 44 24 20 00 00 00 00 EB 0A 8B 44 24 20 FF C0 89 44 24 20 48 8B 44 24 50 8B 00 39 44 24 20 7D 44 48 63 44 24 20 48 8B 4C 24 50 48 8B 49 08 48 8B 04 C1 48 89 44 24 28 48 83 7C 24 28 00 74 23 48 8B 44 24 28 48 8B 00 48 89 44 24 30 48 8B 4C 24 28 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 89 44 24 28 EB D5 EB A5 48 8B 44 24 50 C7 40 04 00 00 00 00 48 8B 44 24 50 48 63 00 48 C1 E0 03 4C 8B C0 33 D2 48 8B 44 24 50 48 8B 48 08 E8 ?? ?? ?? ?? 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_67_77_0 {
	meta:
		name = "?_DoYield@?$_SpinWait@$00@details@Concurrency@@IEAAXXZ"
		size = 116
		refs = "0026 ??_C@_1CM@DGAKBIOO@?$AA_?$AAM?$AA_?$AAy?$AAi?$AAe?$AAl?$AAd?$AAF?$AAu?$AAn?$AAc?$AAt?$AAi?$AAo?$AAn?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 0032 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0047 ??_C@_1GK@ONGAFFLC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 0051 _CrtDbgReportW"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 48 C6 44 24 30 01 0F B6 44 24 30 85 C0 74 56 48 8B 44 24 50 48 83 78 10 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 D8 02 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 33 C0 85 C0 75 B4 48 8B 44 24 50 FF 50 10 EB 02 F3 90 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_67_80_0 {
	meta:
		name = "?_GetType@location@Concurrency@@QEBA?AW4_Type@12@XZ"
		size = 18
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 8B 00 25 FF FF FF 0F C3 }
	condition:
		$1
}

rule file_67_81_0 {
	meta:
		name = "?_GetVirtualProcessor@InternalContextBase@details@Concurrency@@IEBAPEAVVirtualProcessor@23@XZ"
		size = 92
		refs = "0027 ?IsInsideCriticalRegion@ContextBase@details@Concurrency@@QEBA_NXZ 003b ??_C@_0EC@PEIBFLHK@f?3?2dd?2vctools?2crt_bld?2self_64_am@ 0042 ??_C@_0DJ@FICHJDBF@_m_pVirtualProcessor?5?$DN?$DN?5NULL?5?$HM?$HM?5@ 0047 ?_ConcRT_CoreAssert@details@Concurrency@@YAXPEBD0H@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 80 08 01 00 00 48 85 C0 74 31 48 8B 44 24 30 48 83 C0 10 48 8B C8 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 19 41 B8 E8 01 00 00 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8B 80 08 01 00 00 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_67_83_0 {
	meta:
		name = "?_Reset@?$_SpinWait@$00@details@Concurrency@@IEAAXXZ"
		size = 118
		refs = "0016 ?_Value@_SpinCount@details@Concurrency@@SAIXZ 0022 ?_SetSpinCount@?$_SpinWait@$00@details@Concurrency@@QEAAXI@Z 0034 ??_C@_1DE@BFFKFMDD@?$AA_?$AAM?$AA_?$AAs?$AAt?$AAa?$AAt?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAS?$AAt?$AAa?$AAt?$AAe?$AAI?$AAn?$AAi?$AAt?$AAi?$AAa?$AAl?$AA?$AA@ 0040 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0055 ??_C@_1GK@ONGAFFLC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 005f _CrtDbgReportW"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 C7 40 08 00 00 00 00 E8 ?? ?? ?? ?? 8B D0 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 44 24 40 83 78 08 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 ED 02 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 33 C0 85 C0 75 B5 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_268_244_0 {
	meta:
		name = "?_Reset@?$_SpinWait@$0A@@details@Concurrency@@IEAAXXZ"
		size = 118
		refs = "0016 ?_Value@_SpinCount@details@Concurrency@@SAIXZ 0022 ?_SetSpinCount@?$_SpinWait@$0A@@details@Concurrency@@QEAAXI@Z 0034 ??_C@_1DE@BFFKFMDD@?$AA_?$AAM?$AA_?$AAs?$AAt?$AAa?$AAt?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAS?$AAt?$AAa?$AAt?$AAe?$AAI?$AAn?$AAi?$AAt?$AAi?$AAa?$AAl?$AA?$AA@ 0040 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0055 ??_C@_1GK@ONGAFFLC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 005f _CrtDbgReportW"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 C7 40 08 00 00 00 00 E8 ?? ?? ?? ?? 8B D0 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 44 24 40 83 78 08 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 ED 02 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 33 C0 85 C0 75 B5 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_67_84_0 {
	meta:
		name = "?_SetSpinCount@?$_SpinWait@$00@details@Concurrency@@QEAAXI@Z"
		size = 149
		refs = "001b ??_C@_1DE@FNIGIOLJ@?$AA_?$AAM?$AA_?$AAs?$AAt?$AAa?$AAt?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA_?$AAS?$AAt?$AAa?$AAt?$AAe?$AAI?$AAn?$AAi?$AAt?$AAi?$AAa?$AAl?$AA?$AA@ 0027 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 003c ??_C@_1GK@ONGAFFLC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 0046 _CrtDbgReportW"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 83 78 08 00 74 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 72 02 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 33 C0 85 C0 75 B5 83 7C 24 48 00 75 0E 48 8B 44 24 40 C7 40 08 04 00 00 00 EB 23 48 8B 44 24 40 8B 4C 24 48 89 08 48 8B 44 24 40 C7 40 04 01 00 00 00 48 8B 44 24 40 C7 40 08 01 00 00 00 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_67_85_0 {
	meta:
		name = "?_ShouldSpinAgain@?$_SpinWait@$00@details@Concurrency@@IEAA_NXZ"
		size = 65
		altNames = "?_ShouldSpinAgain@?$_SpinWait@$0A@@details@Concurrency@@IEAA_NXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 18 48 8B 44 24 20 8B 00 FF C8 89 04 24 48 8B 44 24 20 8B 0C 24 89 08 83 3C 24 00 76 0A C7 44 24 04 01 00 00 00 EB 08 C7 44 24 04 00 00 00 00 0F B6 44 24 04 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_67_86_0 {
	meta:
		name = "?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QEAA_NXZ"
		size = 381
		refs = "0053 ?_NumberOfSpins@?$_SpinWait@$00@details@Concurrency@@IEAAKXZ 0083 ?_ShouldSpinAgain@?$_SpinWait@$00@details@Concurrency@@IEAA_NXZ 00cc ??_C@_1CI@KMNHIHDG@?$AA_?$AAM?$AA_?$AAc?$AAu?$AAr?$AAr?$AAe?$AAn?$AAt?$AAY?$AAi?$AAe?$AAl?$AAd?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 00d8 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 00ed ??_C@_1GK@ONGAFFLC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 00f7 _CrtDbgReportW 013c ?_DoYield@?$_SpinWait@$00@details@Concurrency@@IEAAXXZ 014a ?_Reset@?$_SpinWait@$00@details@Concurrency@@IEAAXXZ 0170 ?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QEAA_NXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 58 48 8B 44 24 60 8B 40 08 89 44 24 30 83 7C 24 30 00 0F 84 40 01 00 00 83 7C 24 30 01 74 26 83 7C 24 30 02 0F 84 8C 00 00 00 83 7C 24 30 03 0F 84 07 01 00 00 83 7C 24 30 04 0F 84 0A 01 00 00 E9 29 01 00 00 48 8B 4C 24 60 E8 ?? ?? ?? ?? 89 44 24 40 C7 44 24 34 00 00 00 00 EB 0A 8B 44 24 34 FF C0 89 44 24 34 8B 44 24 40 39 44 24 34 73 04 F3 90 EB E8 48 8B 4C 24 60 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 29 48 8B 44 24 60 83 78 04 00 75 0A C7 44 24 38 03 00 00 00 EB 08 C7 44 24 38 02 00 00 00 48 8B 44 24 60 8B 4C 24 38 89 48 08 B0 01 E9 BA 00 00 00 48 8B 44 24 60 83 78 04 00 77 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 A2 02 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 33 C0 85 C0 75 B5 48 8B 44 24 60 8B 40 04 FF C8 89 44 24 3C 48 8B 44 24 60 8B 4C 24 3C 89 48 04 83 7C 24 3C 00 75 0C 48 8B 44 24 60 C7 40 08 03 00 00 00 48 8B 4C 24 60 E8 ?? ?? ?? ?? B0 01 EB 34 48 8B 4C 24 60 E8 ?? ?? ?? ?? 32 C0 EB 26 48 8B 4C 24 60 E8 ?? ?? ?? ?? 32 C0 EB 18 48 8B 4C 24 60 E8 ?? ?? ?? ?? 48 8B 4C 24 60 E8 ?? ?? ?? ?? EB 02 32 C0 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_268_251_0 {
	meta:
		name = "?_SpinOnce@?$_SpinWait@$0A@@details@Concurrency@@QEAA_NXZ"
		size = 381
		refs = "0053 ?_NumberOfSpins@?$_SpinWait@$0A@@details@Concurrency@@IEAAKXZ 0083 ?_ShouldSpinAgain@?$_SpinWait@$0A@@details@Concurrency@@IEAA_NXZ 00cc ??_C@_1CI@KMNHIHDG@?$AA_?$AAM?$AA_?$AAc?$AAu?$AAr?$AAr?$AAe?$AAn?$AAt?$AAY?$AAi?$AAe?$AAl?$AAd?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 00d8 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 00ed ??_C@_1GK@ONGAFFLC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 00f7 _CrtDbgReportW 013c ?_DoYield@?$_SpinWait@$0A@@details@Concurrency@@IEAAXXZ 014a ?_Reset@?$_SpinWait@$0A@@details@Concurrency@@IEAAXXZ 0170 ?_SpinOnce@?$_SpinWait@$0A@@details@Concurrency@@QEAA_NXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 58 48 8B 44 24 60 8B 40 08 89 44 24 30 83 7C 24 30 00 0F 84 40 01 00 00 83 7C 24 30 01 74 26 83 7C 24 30 02 0F 84 8C 00 00 00 83 7C 24 30 03 0F 84 07 01 00 00 83 7C 24 30 04 0F 84 0A 01 00 00 E9 29 01 00 00 48 8B 4C 24 60 E8 ?? ?? ?? ?? 89 44 24 40 C7 44 24 34 00 00 00 00 EB 0A 8B 44 24 34 FF C0 89 44 24 34 8B 44 24 40 39 44 24 34 73 04 F3 90 EB E8 48 8B 4C 24 60 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 29 48 8B 44 24 60 83 78 04 00 75 0A C7 44 24 38 03 00 00 00 EB 08 C7 44 24 38 02 00 00 00 48 8B 44 24 60 8B 4C 24 38 89 48 08 B0 01 E9 BA 00 00 00 48 8B 44 24 60 83 78 04 00 77 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 A2 02 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 33 C0 85 C0 75 B5 48 8B 44 24 60 8B 40 04 FF C8 89 44 24 3C 48 8B 44 24 60 8B 4C 24 3C 89 48 04 83 7C 24 3C 00 75 0C 48 8B 44 24 60 C7 40 08 03 00 00 00 48 8B 4C 24 60 E8 ?? ?? ?? ?? B0 01 EB 34 48 8B 4C 24 60 E8 ?? ?? ?? ?? 32 C0 EB 26 48 8B 4C 24 60 E8 ?? ?? ?? ?? 32 C0 EB 18 48 8B 4C 24 60 E8 ?? ?? ?? ?? 48 8B 4C 24 60 E8 ?? ?? ?? ?? EB 02 32 C0 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_69_0_0 {
	meta:
		name = "__sse2_atanf4"
		size = 192
		refs = "0007 s_dwAbsMask 000e s_fOne 002e s_dwSignMask 0035 s_fPi2 005d s_fA8 0064 s_fA7 0071 s_fA6 0078 s_fA5 0085 s_fA4 008c s_fA3 0099 s_fA2 00a0 s_fA1 00ad s_fA0"
	strings:
		$1 = { 0F 28 E8 66 0F DB 05 ?? ?? ?? ?? 0F 28 1D ?? ?? ?? ?? 0F 5F D8 0F 28 E0 0F 5D 05 ?? ?? ?? ?? 0F 5E C3 66 0F 66 25 ?? ?? ?? ?? 66 0F DB 2D ?? ?? ?? ?? 0F 28 15 ?? ?? ?? ?? 66 0F DB D4 66 0F DB 25 ?? ?? ?? ?? 66 0F EF D5 66 0F EF E5 66 0F EF E0 0F 59 C0 0F 28 D8 0F 59 C0 0F 28 2D ?? ?? ?? ?? 0F 28 0D ?? ?? ?? ?? 0F 59 E8 0F 59 C8 0F 58 2D ?? ?? ?? ?? 0F 58 0D ?? ?? ?? ?? 0F 59 E8 0F 59 C8 0F 58 2D ?? ?? ?? ?? 0F 58 0D ?? ?? ?? ?? 0F 59 E8 0F 59 C8 0F 58 2D ?? ?? ?? ?? 0F 58 0D ?? ?? ?? ?? 0F 59 C5 0F 59 CB 0F 58 05 ?? ?? ?? ?? 0F 58 C1 0F 59 C4 0F 58 C2 C3 0F 1F 44 00 00 }
	condition:
		$1
}

rule file_70_4_0 {
	meta:
		name = "_mbsnccnt_l"
		size = 494
		refs = "0024 ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 0062 ??_C@_1DI@PIPNGDHN@?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AAb?$AAc?$AAn?$AAt?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 006e ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0083 ??_C@_1GO@ONENPCKJ@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 008d _CrtDbgReportW 00a1 _errno 00c4 ??_C@_1BI@ENAMCCPH@?$AA_?$AAm?$AAb?$AAs?$AAn?$AAc?$AAc?$AAn?$AAt?$AA_?$AAl?$AA?$AA@ 00d0 _invalid_parameter 00e3 ??1_LocaleUpdate@@QEAA@XZ 015d ?GetLocaleT@_LocaleUpdate@@QEAAPEAUlocaleinfo_struct@@XZ"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 81 EC 88 00 00 00 48 8B 94 24 A0 00 00 00 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 83 BC 24 90 00 00 00 00 75 15 48 83 BC 24 98 00 00 00 00 74 0A C7 44 24 34 00 00 00 00 EB 08 C7 44 24 34 01 00 00 00 8B 44 24 34 89 44 24 30 83 7C 24 30 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 37 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 30 00 75 51 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 37 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 C7 44 24 40 00 00 00 00 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8B 44 24 40 E9 F5 00 00 00 48 C7 44 24 38 00 00 00 00 EB 20 48 8B 44 24 38 48 FF C0 48 89 44 24 38 48 8B 84 24 90 00 00 00 48 FF C0 48 89 84 24 90 00 00 00 48 8B 84 24 98 00 00 00 48 89 44 24 58 48 8B 84 24 98 00 00 00 48 FF C8 48 89 84 24 98 00 00 00 48 83 7C 24 58 00 0F 84 85 00 00 00 48 8B 84 24 90 00 00 00 0F B6 00 85 C0 74 76 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8B 40 08 48 8B 8C 24 90 00 00 00 0F B6 09 0F B6 44 08 19 83 E0 04 85 C0 74 4C 48 8B 84 24 98 00 00 00 48 89 44 24 48 48 8B 84 24 98 00 00 00 48 FF C8 48 89 84 24 98 00 00 00 48 83 7C 24 48 00 74 22 48 8B 84 24 90 00 00 00 48 FF C0 48 89 84 24 90 00 00 00 48 8B 84 24 90 00 00 00 0F B6 00 85 C0 75 02 EB 05 E9 2F FF FF FF 48 8B 44 24 38 48 89 44 24 50 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 81 C4 88 00 00 00 C3 }
	condition:
		$1
}

rule file_71_0_0 {
	meta:
		name = "wcstok"
		size = 328
		refs = "000f _getptd"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 E8 ?? ?? ?? ?? 48 89 44 24 28 48 83 7C 24 50 00 75 0E 48 8B 44 24 28 48 8B 40 28 48 89 44 24 50 48 8B 44 24 50 0F B7 00 85 C0 74 5A 48 8B 44 24 58 48 89 44 24 20 EB 0E 48 8B 44 24 20 48 83 C0 02 48 89 44 24 20 48 8B 44 24 20 0F B7 00 85 C0 74 16 48 8B 44 24 20 0F B7 00 48 8B 4C 24 50 0F B7 09 3B C1 74 02 EB D0 48 8B 44 24 20 0F B7 00 85 C0 75 02 EB 10 48 8B 44 24 50 48 83 C0 02 48 89 44 24 50 EB 9A 48 8B 44 24 50 48 89 44 24 30 EB 0E 48 8B 44 24 50 48 83 C0 02 48 89 44 24 50 48 8B 44 24 50 0F B7 00 85 C0 74 64 48 8B 44 24 58 48 89 44 24 20 EB 0E 48 8B 44 24 20 48 83 C0 02 48 89 44 24 20 48 8B 44 24 20 0F B7 00 85 C0 74 16 48 8B 44 24 20 0F B7 00 48 8B 4C 24 50 0F B7 09 3B C1 74 02 EB D0 48 8B 44 24 20 0F B7 00 85 C0 74 1A 33 C0 48 8B 4C 24 50 66 89 01 48 8B 44 24 50 48 83 C0 02 48 89 44 24 50 EB 02 EB 82 48 8B 44 24 28 48 8B 4C 24 50 48 89 48 28 48 8B 44 24 50 48 39 44 24 30 75 06 33 C0 EB 07 EB 05 48 8B 44 24 30 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_72_0_0 {
	meta:
		name = "?_CrtDbgReportW@@YAHHPEBGH00ZZ"
		size = 118
		refs = "005c _CrtDbgReportWV"
		altNames = "_CrtDbgReportW"
	strings:
		$1 = { 4C 89 4C 24 20 44 89 44 24 18 48 89 54 24 10 89 4C 24 08 48 83 EC 58 48 8D 84 24 88 00 00 00 48 89 44 24 48 48 8B 44 24 58 48 8B 4C 24 48 48 89 4C 24 30 48 8B 8C 24 80 00 00 00 48 89 4C 24 28 48 8B 4C 24 78 48 89 4C 24 20 44 8B 4C 24 70 4C 8B 44 24 68 48 8B D0 8B 4C 24 60 E8 ?? ?? ?? ?? 89 44 24 40 48 C7 44 24 48 00 00 00 00 8B 44 24 40 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_969_0_0 {
	meta:
		name = "_CrtDbgReport"
		size = 118
		refs = "005c _CrtDbgReportV"
	strings:
		$1 = { 4C 89 4C 24 20 44 89 44 24 18 48 89 54 24 10 89 4C 24 08 48 83 EC 58 48 8D 84 24 88 00 00 00 48 89 44 24 48 48 8B 44 24 58 48 8B 4C 24 48 48 89 4C 24 30 48 8B 8C 24 80 00 00 00 48 89 4C 24 28 48 8B 4C 24 78 48 89 4C 24 20 44 8B 4C 24 70 4C 8B 44 24 68 48 8B D0 8B 4C 24 60 E8 ?? ?? ?? ?? 89 44 24 40 48 C7 44 24 48 00 00 00 00 8B 44 24 40 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_72_2_0 {
	meta:
		name = "_CrtDbgReportWV"
		size = 85
		refs = "004c _VCrtDbgReportW"
	strings:
		$1 = { 44 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 89 4C 24 08 48 83 EC 48 48 8B 84 24 80 00 00 00 48 89 44 24 30 48 8B 44 24 78 48 89 44 24 28 48 8B 44 24 70 48 89 44 24 20 44 8B 4C 24 68 4C 8B 44 24 60 48 8B 54 24 58 8B 4C 24 50 E8 ?? ?? ?? ?? 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_969_1_0 {
	meta:
		name = "_CrtDbgReportV"
		size = 85
		refs = "004c _VCrtDbgReportA"
	strings:
		$1 = { 44 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 89 4C 24 08 48 83 EC 48 48 8B 84 24 80 00 00 00 48 89 44 24 30 48 8B 44 24 78 48 89 44 24 28 48 8B 44 24 70 48 89 44 24 20 44 8B 4C 24 68 4C 8B 44 24 60 48 8B 54 24 58 8B 4C 24 50 E8 ?? ?? ?? ?? 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_72_3_0 {
	meta:
		name = "_CrtSetReportHookW2"
		size = 1026
		refs = "003f ??_C@_1HI@OFEHGPPC@?$AAm?$AAo?$AAd?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA_?$AAC?$AAR?$AAT?$AA_?$AAR?$AAP?$AAT?$AAH?$AAO?$AAO?$AAK?$AA_?$AAI?$AAN?$AAS?$AAT?$AAA?$AAL?$AAL?$AA?5?$AA?$HM?$AA?$HM?$AA?5@ 004b ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0060 ??_C@_1GK@OPBLBEGA@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 006a _CrtDbgReportW 007e _errno 00a1 ??_C@_1CI@IIHEAKEI@?$AA_?$AAC?$AAr?$AAt?$AAS?$AAe?$AAt?$AAR?$AAe?$AAp?$AAo?$AAr?$AAt?$AAH?$AAo?$AAo?$AAk?$AAW?$AA2?$AA?$AA@ 00ad _invalid_parameter 00e7 ??_C@_1CG@JBJEFOCM@?$AAp?$AAf?$AAn?$AAN?$AAe?$AAw?$AAH?$AAo?$AAo?$AAk?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0169 _lock 0171 _pReportHookListW 0243 _free_dbg 0252 ??_C@_1FI@PHIAFFHM@?$AA?$CI?$AA?$CC?$AAT?$AAh?$AAe?$AA?5?$AAh?$AAo?$AAo?$AAk?$AA?5?$AAf?$AAu?$AAn?$AAc?$AAt?$AAi?$AAo?$AAn?$AA?5?$AAi?$AAs?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAi?$AAn?$AA?5?$AAt?$AAh@ 0357 ??_C@_0DF@OKIEDDMM@f?3?2dd?2vctools?2crt_bld?2self_64_am@ 0366 _malloc_dbg 03f5 _unlock"
	strings:
		$1 = { 48 89 54 24 10 89 4C 24 08 48 83 EC 68 83 7C 24 70 00 74 11 83 7C 24 70 01 74 0A C7 44 24 34 00 00 00 00 EB 08 C7 44 24 34 01 00 00 00 8B 44 24 34 89 44 24 38 83 7C 24 38 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 74 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 38 00 75 3E E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 74 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 FF FF FF FF E9 42 03 00 00 48 83 7C 24 78 00 74 0A C7 44 24 3C 01 00 00 00 EB 08 C7 44 24 3C 00 00 00 00 8B 44 24 3C 89 44 24 40 83 7C 24 40 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 75 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 40 00 75 3E E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 75 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 FF FF FF FF E9 9A 02 00 00 B9 0F 00 00 00 E8 ?? ?? ?? ?? 90 48 8B 05 ?? ?? ?? ?? 48 89 44 24 50 EB 0E 48 8B 44 24 50 48 8B 40 08 48 89 44 24 50 48 83 7C 24 50 00 74 14 48 8B 44 24 50 48 8B 4C 24 78 48 39 48 18 75 02 EB 02 EB D6 83 7C 24 70 01 0F 85 F0 00 00 00 48 83 7C 24 50 00 0F 84 8C 00 00 00 48 8B 44 24 50 8B 40 10 FF C8 89 44 24 44 48 8B 44 24 50 8B 4C 24 44 89 48 10 8B 44 24 44 89 44 24 30 83 7C 24 30 00 75 61 48 8B 44 24 50 48 83 78 08 00 74 14 48 8B 44 24 50 48 8B 40 08 48 8B 4C 24 50 48 8B 09 48 89 08 48 8B 44 24 50 48 83 38 00 74 17 48 8B 44 24 50 48 8B 00 48 8B 4C 24 50 48 8B 49 08 48 89 48 08 EB 10 48 8B 44 24 50 48 8B 40 08 48 89 05 ?? ?? ?? ?? BA 02 00 00 00 48 8B 4C 24 50 E8 ?? ?? ?? ?? EB 53 33 C0 85 C0 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 92 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 C7 44 24 30 FF FF FF FF E8 ?? ?? ?? ?? C7 00 16 00 00 00 E9 4E 01 00 00 48 83 7C 24 50 00 0F 84 A1 00 00 00 48 8B 44 24 50 8B 40 10 FF C0 89 44 24 48 48 8B 44 24 50 8B 4C 24 48 89 48 10 8B 44 24 48 89 44 24 30 48 8B 05 ?? ?? ?? ?? 48 39 44 24 50 74 6C 48 8B 44 24 50 48 83 78 08 00 74 14 48 8B 44 24 50 48 8B 40 08 48 8B 4C 24 50 48 8B 09 48 89 08 48 8B 44 24 50 48 8B 00 48 8B 4C 24 50 48 8B 49 08 48 89 48 08 48 8B 44 24 50 48 C7 00 00 00 00 00 48 8B 44 24 50 48 8B 0D ?? ?? ?? ?? 48 89 48 08 48 8B 05 ?? ?? ?? ?? 48 8B 4C 24 50 48 89 08 48 8B 44 24 50 48 89 05 ?? ?? ?? ?? E9 A1 00 00 00 41 B9 AC 00 00 00 4C 8D 05 ?? ?? ?? ?? BA 02 00 00 00 B9 20 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 50 48 83 7C 24 50 00 75 15 C7 44 24 30 FF FF FF FF E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB 63 48 8B 44 24 50 48 C7 00 00 00 00 00 48 8B 44 24 50 48 8B 0D ?? ?? ?? ?? 48 89 48 08 48 83 3D ?? ?? ?? ?? 00 74 0F 48 8B 05 ?? ?? ?? ?? 48 8B 4C 24 50 48 89 08 48 8B 44 24 50 C7 40 10 01 00 00 00 C7 44 24 30 01 00 00 00 48 8B 44 24 50 48 8B 4C 24 78 48 89 48 18 48 8B 44 24 50 48 89 05 ?? ?? ?? ?? B9 0F 00 00 00 E8 ?? ?? ?? ?? 8B 44 24 30 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_969_2_0 {
	meta:
		name = "_CrtSetReportHook2"
		size = 1026
		refs = "003f ??_C@_1HI@OFEHGPPC@?$AAm?$AAo?$AAd?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA_?$AAC?$AAR?$AAT?$AA_?$AAR?$AAP?$AAT?$AAH?$AAO?$AAO?$AAK?$AA_?$AAI?$AAN?$AAS?$AAT?$AAA?$AAL?$AAL?$AA?5?$AA?$HM?$AA?$HM?$AA?5@ 004b ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0060 ??_C@_1GK@OPBLBEGA@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 006a _CrtDbgReportW 007e _errno 00a1 ??_C@_1CG@GNMJDMIO@?$AA_?$AAC?$AAr?$AAt?$AAS?$AAe?$AAt?$AAR?$AAe?$AAp?$AAo?$AAr?$AAt?$AAH?$AAo?$AAo?$AAk?$AA2?$AA?$AA@ 00ad _invalid_parameter 00e7 ??_C@_1CG@JBJEFOCM@?$AAp?$AAf?$AAn?$AAN?$AAe?$AAw?$AAH?$AAo?$AAo?$AAk?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0169 _lock 0171 _pReportHookList 0243 _free_dbg 0252 ??_C@_1FI@PHIAFFHM@?$AA?$CI?$AA?$CC?$AAT?$AAh?$AAe?$AA?5?$AAh?$AAo?$AAo?$AAk?$AA?5?$AAf?$AAu?$AAn?$AAc?$AAt?$AAi?$AAo?$AAn?$AA?5?$AAi?$AAs?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAi?$AAn?$AA?5?$AAt?$AAh@ 0357 ??_C@_0DF@OKIEDDMM@f?3?2dd?2vctools?2crt_bld?2self_64_am@ 0366 _malloc_dbg 03f5 _unlock"
	strings:
		$1 = { 48 89 54 24 10 89 4C 24 08 48 83 EC 68 83 7C 24 70 00 74 11 83 7C 24 70 01 74 0A C7 44 24 34 00 00 00 00 EB 08 C7 44 24 34 01 00 00 00 8B 44 24 34 89 44 24 38 83 7C 24 38 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 74 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 38 00 75 3E E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 74 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 FF FF FF FF E9 42 03 00 00 48 83 7C 24 78 00 74 0A C7 44 24 3C 01 00 00 00 EB 08 C7 44 24 3C 00 00 00 00 8B 44 24 3C 89 44 24 40 83 7C 24 40 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 75 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 40 00 75 3E E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 75 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 FF FF FF FF E9 9A 02 00 00 B9 0F 00 00 00 E8 ?? ?? ?? ?? 90 48 8B 05 ?? ?? ?? ?? 48 89 44 24 50 EB 0E 48 8B 44 24 50 48 8B 40 08 48 89 44 24 50 48 83 7C 24 50 00 74 14 48 8B 44 24 50 48 8B 4C 24 78 48 39 48 18 75 02 EB 02 EB D6 83 7C 24 70 01 0F 85 F0 00 00 00 48 83 7C 24 50 00 0F 84 8C 00 00 00 48 8B 44 24 50 8B 40 10 FF C8 89 44 24 44 48 8B 44 24 50 8B 4C 24 44 89 48 10 8B 44 24 44 89 44 24 30 83 7C 24 30 00 75 61 48 8B 44 24 50 48 83 78 08 00 74 14 48 8B 44 24 50 48 8B 40 08 48 8B 4C 24 50 48 8B 09 48 89 08 48 8B 44 24 50 48 83 38 00 74 17 48 8B 44 24 50 48 8B 00 48 8B 4C 24 50 48 8B 49 08 48 89 48 08 EB 10 48 8B 44 24 50 48 8B 40 08 48 89 05 ?? ?? ?? ?? BA 02 00 00 00 48 8B 4C 24 50 E8 ?? ?? ?? ?? EB 53 33 C0 85 C0 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 92 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 C7 44 24 30 FF FF FF FF E8 ?? ?? ?? ?? C7 00 16 00 00 00 E9 4E 01 00 00 48 83 7C 24 50 00 0F 84 A1 00 00 00 48 8B 44 24 50 8B 40 10 FF C0 89 44 24 48 48 8B 44 24 50 8B 4C 24 48 89 48 10 8B 44 24 48 89 44 24 30 48 8B 05 ?? ?? ?? ?? 48 39 44 24 50 74 6C 48 8B 44 24 50 48 83 78 08 00 74 14 48 8B 44 24 50 48 8B 40 08 48 8B 4C 24 50 48 8B 09 48 89 08 48 8B 44 24 50 48 8B 00 48 8B 4C 24 50 48 8B 49 08 48 89 48 08 48 8B 44 24 50 48 C7 00 00 00 00 00 48 8B 44 24 50 48 8B 0D ?? ?? ?? ?? 48 89 48 08 48 8B 05 ?? ?? ?? ?? 48 8B 4C 24 50 48 89 08 48 8B 44 24 50 48 89 05 ?? ?? ?? ?? E9 A1 00 00 00 41 B9 AC 00 00 00 4C 8D 05 ?? ?? ?? ?? BA 02 00 00 00 B9 20 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 50 48 83 7C 24 50 00 75 15 C7 44 24 30 FF FF FF FF E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB 63 48 8B 44 24 50 48 C7 00 00 00 00 00 48 8B 44 24 50 48 8B 0D ?? ?? ?? ?? 48 89 48 08 48 83 3D ?? ?? ?? ?? 00 74 0F 48 8B 05 ?? ?? ?? ?? 48 8B 4C 24 50 48 89 08 48 8B 44 24 50 C7 40 10 01 00 00 00 C7 44 24 30 01 00 00 00 48 8B 44 24 50 48 8B 4C 24 78 48 89 48 18 48 8B 44 24 50 48 89 05 ?? ?? ?? ?? B9 0F 00 00 00 E8 ?? ?? ?? ?? 8B 44 24 30 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_72_4_0 {
	meta:
		name = "_CrtSetReportHookW2$fin$0"
		size = 27
		refs = "000f _unlock"
		altNames = "_CrtSetReportHook2$fin$0"
	strings:
		$1 = { 40 55 48 83 EC 30 48 8B EA B9 0F 00 00 00 E8 ?? ?? ?? ?? 90 48 83 C4 30 5D C3 CC }
	condition:
		$1
}

rule file_72_5_0 {
	meta:
		name = "__crtMessageWindowW"
		size = 1660
		refs = "0019 __chkstk 0023 __security_cookie 0081 __imp_GetModuleHandleExW 00ba __report_rangecheckfailure 00e8 __imp_GetModuleFileNameW 00f3 ??_C@_1CO@EAEJAADC@?$AA?$DM?$AAp?$AAr?$AAo?$AAg?$AAr?$AAa?$AAm?$AA?5?$AAn?$AAa?$AAm?$AAe?$AA?5?$AAu?$AAn?$AAk?$AAn?$AAo?$AAw?$AAn?$AA?$DO?$AA?$AA@ 0105 wcscpy_s 011d ??_C@_1GK@OPBLBEGA@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 0124 ??_C@_1CI@PGJIFDEK@?$AA_?$AA_?$AAc?$AAr?$AAt?$AAM?$AAe?$AAs?$AAs?$AAa?$AAg?$AAe?$AAW?$AAi?$AAn?$AAd?$AAo?$AAw?$AAW?$AA?$AA@ 012b ??_C@_1GI@DEDNNLCI@?$AAw?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAs?$AAz?$AAE?$AAx?$AAe?$AAN?$AAa?$AAm?$AAe?$AA?0?$AA?5?$AA2?$AA6?$AA0?$AA?0?$AA?5?$AAL?$AA?$CC?$AA?$DM?$AAp?$AAr?$AAo?$AAg@ 0132 _invoke_watson_if_error 014f wcslen 01af dotdotdot 01bf memcpy_s 01e5 ??_C@_1NO@LECLLHOL@?$AAm?$AAe?$AAm?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAs?$AAz?$AAS?$AAh?$AAo?$AAr?$AAt?$AAP?$AAr?$AAo?$AAg?$AAN?$AAa?$AAm?$AAe?$AA?0?$AA?5?$AAs?$AAi?$AAz?$AAe?$AAo?$AAf@ 0231 _errno 0256 ??_C@_1OG@PMPPFHAF@?$AA?6?$AA?6?$AAF?$AAo?$AAr?$AA?5?$AAi?$AAn?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AAi?$AAo?$AAn?$AA?5?$AAo?$AAn?$AA?5?$AAh?$AAo?$AAw?$AA?5?$AAy?$AAo?$AAu?$AAr?$AA?5?$AAp?$AAr@ 0267 ??_C@_11LOCGONAA@?$AA?$AA@ 02d3 ??_C@_1BK@PEDCIPMA@?$AAE?$AAx?$AAp?$AAr?$AAe?$AAs?$AAs?$AAi?$AAo?$AAn?$AA?3?$AA?5?$AA?$AA@ 030c ??_C@_15IABLJNFO@?$AA?6?$AA?6?$AA?$AA@ 0363 ??_C@_1BA@GLLGCPCK@?$AA?6?$AAL?$AAi?$AAn?$AAe?$AA?3?$AA?5?$AA?$AA@ 03ba ??_C@_1BA@LNHECFIM@?$AA?6?$AAF?$AAi?$AAl?$AAe?$AA?3?$AA?5?$AA?$AA@ 043e ??_C@_17LGKOMLJ@?$AA?4?$AA?4?$AA?4?$AA?$AA@ 0469 ??_C@_1BE@CGCJKGHI@?$AA?6?$AAM?$AAo?$AAd?$AAu?$AAl?$AAe?$AA?3?$AA?5?$AA?$AA@ 0491 _CrtDbgModeMsg 0540 ??_C@_1KM@HNMIBKJH@?$AAD?$AAe?$AAb?$AAu?$AAg?$AA?5?$AA?$CF?$AAs?$AA?$CB?$AA?6?$AA?6?$AAP?$AAr?$AAo?$AAg?$AAr?$AAa?$AAm?$AA?3?$AA?5?$AA?$CF?$AAs?$AA?$CF?$AAs?$AA?$CF?$AAs?$AA?$CF?$AAs?$AA?$CF?$AAs?$AA?$CF?$AAs@ 0558 _snwprintf_s 059e ??_C@_1BI@KALLJECN@?$AA?$CI?$AA?$CK?$AA_?$AAe?$AAr?$AAr?$AAn?$AAo?$AA?$CI?$AA?$CJ?$AA?$CJ?$AA?$AA@ 05b0 _invoke_watson_if_oneof 05cf ??_C@_1FG@BBOLDHGF@?$AA_?$AAC?$AAr?$AAt?$AAD?$AAb?$AAg?$AAR?$AAe?$AAp?$AAo?$AAr?$AAt?$AA?3?$AA?5?$AAS?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AAt?$AAo?$AAo?$AA?5?$AAl?$AAo?$AAn?$AAg?$AA?5?$AAo@ 0607 ??_C@_1JI@EACPGHID@?$AAw?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAs?$AAz?$AAO?$AAu?$AAt?$AAM?$AAe?$AAs?$AAs?$AAa?$AAg?$AAe?$AA?0?$AA?5?$AA4?$AA0?$AA9?$AA6?$AA?0?$AA?5?$AAL?$AA?$CC?$AA_@ 061b ??_C@_1EK@MBDPDCGA@?$AAM?$AAi?$AAc?$AAr?$AAo?$AAs?$AAo?$AAf?$AAt?$AA?5?$AAV?$AAi?$AAs?$AAu?$AAa?$AAl?$AA?5?$AAC?$AA?$CL?$AA?$CL?$AA?5?$AAR?$AAu?$AAn?$AAt?$AAi?$AAm?$AAe?$AA?5?$AAL?$AAi?$AAb@ 0628 __crtMessageBoxW 0643 raise 064d _exit 0670 __security_check_cookie"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 89 4C 24 08 B8 48 23 00 00 E8 ?? ?? ?? ?? 48 2B E0 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 30 23 00 00 48 C7 84 24 A0 00 00 00 00 00 00 00 C7 84 24 98 00 00 00 00 00 00 00 48 C7 84 24 B0 00 00 00 00 00 00 00 48 83 BC 24 78 23 00 00 00 75 0A B8 01 00 00 00 E9 FA 05 00 00 4C 8D 84 24 B0 00 00 00 48 8B 94 24 58 23 00 00 B9 06 00 00 00 FF 15 ?? ?? ?? ?? 85 C0 75 0C 48 C7 84 24 B0 00 00 00 00 00 00 00 B8 02 00 00 00 48 69 C0 04 01 00 00 48 89 84 24 E0 00 00 00 48 81 BC 24 E0 00 00 00 0A 02 00 00 73 02 EB 05 E8 ?? ?? ?? ?? 33 C0 48 8B 8C 24 E0 00 00 00 66 89 84 0C 20 01 00 00 41 B8 04 01 00 00 48 8D 94 24 20 01 00 00 48 8B 8C 24 B0 00 00 00 FF 15 ?? ?? ?? ?? 85 C0 75 46 4C 8D 05 ?? ?? ?? ?? BA 04 01 00 00 48 8D 8C 24 20 01 00 00 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 5F 01 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 48 8D 84 24 20 01 00 00 48 89 84 24 90 00 00 00 48 8B 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 83 F8 40 0F 86 93 00 00 00 48 8B 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 8B 8C 24 90 00 00 00 48 8D 44 41 80 48 89 84 24 90 00 00 00 48 8D 84 24 20 01 00 00 48 8B 8C 24 90 00 00 00 48 2B C8 48 8B C1 48 D1 F8 B9 04 01 00 00 48 2B C8 48 8B C1 48 D1 E0 41 B9 06 00 00 00 4C 8B 05 ?? ?? ?? ?? 48 8B D0 48 8B 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 68 01 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 48 83 BC 24 70 23 00 00 00 74 35 48 8B 8C 24 70 23 00 00 E8 ?? ?? ?? ?? 48 83 F8 40 76 22 48 8B 8C 24 70 23 00 00 E8 ?? ?? ?? ?? 48 8B 8C 24 70 23 00 00 48 8D 44 41 86 48 89 84 24 A0 00 00 00 E8 ?? ?? ?? ?? 8B 00 89 84 24 A8 00 00 00 E8 ?? ?? ?? ?? C7 00 00 00 00 00 83 BC 24 50 23 00 00 02 75 11 48 8D 05 ?? ?? ?? ?? 48 89 84 24 D0 00 00 00 EB 0F 48 8D 05 ?? ?? ?? ?? 48 89 84 24 D0 00 00 00 B8 02 00 00 00 48 6B C0 00 48 8B 8C 24 78 23 00 00 0F B7 04 01 85 C0 74 12 48 8B 84 24 78 23 00 00 48 89 84 24 00 01 00 00 EB 0F 48 8D 05 ?? ?? ?? ?? 48 89 84 24 00 01 00 00 B8 02 00 00 00 48 6B C0 00 48 8B 8C 24 78 23 00 00 0F B7 04 01 85 C0 74 1B 83 BC 24 50 23 00 00 02 75 11 48 8D 05 ?? ?? ?? ?? 48 89 84 24 B8 00 00 00 EB 0F 48 8D 05 ?? ?? ?? ?? 48 89 84 24 B8 00 00 00 B8 02 00 00 00 48 6B C0 00 48 8B 8C 24 78 23 00 00 0F B7 04 01 85 C0 74 11 48 8D 05 ?? ?? ?? ?? 48 89 84 24 18 01 00 00 EB 0F 48 8D 05 ?? ?? ?? ?? 48 89 84 24 18 01 00 00 48 83 BC 24 68 23 00 00 00 74 12 48 8B 84 24 68 23 00 00 48 89 84 24 F0 00 00 00 EB 0F 48 8D 05 ?? ?? ?? ?? 48 89 84 24 F0 00 00 00 48 83 BC 24 68 23 00 00 00 74 11 48 8D 05 ?? ?? ?? ?? 48 89 84 24 C0 00 00 00 EB 0F 48 8D 05 ?? ?? ?? ?? 48 89 84 24 C0 00 00 00 48 83 BC 24 60 23 00 00 00 74 12 48 8B 84 24 60 23 00 00 48 89 84 24 C8 00 00 00 EB 0F 48 8D 05 ?? ?? ?? ?? 48 89 84 24 C8 00 00 00 48 83 BC 24 60 23 00 00 00 74 11 48 8D 05 ?? ?? ?? ?? 48 89 84 24 D8 00 00 00 EB 0F 48 8D 05 ?? ?? ?? ?? 48 89 84 24 D8 00 00 00 48 83 BC 24 A0 00 00 00 00 74 12 48 8B 84 24 A0 00 00 00 48 89 84 24 E8 00 00 00 EB 3C 48 83 BC 24 70 23 00 00 00 74 12 48 8B 84 24 70 23 00 00 48 89 84 24 10 01 00 00 EB 0F 48 8D 05 ?? ?? ?? ?? 48 89 84 24 10 01 00 00 48 8B 84 24 10 01 00 00 48 89 84 24 E8 00 00 00 48 83 BC 24 A0 00 00 00 00 74 11 48 8D 05 ?? ?? ?? ?? 48 89 84 24 F8 00 00 00 EB 0F 48 8D 05 ?? ?? ?? ?? 48 89 84 24 F8 00 00 00 48 83 BC 24 70 23 00 00 00 74 11 48 8D 05 ?? ?? ?? ?? 48 89 84 24 08 01 00 00 EB 0F 48 8D 05 ?? ?? ?? ?? 48 89 84 24 08 01 00 00 48 63 84 24 50 23 00 00 48 8D 0D ?? ?? ?? ?? 48 8B 94 24 D0 00 00 00 48 89 94 24 80 00 00 00 48 8B 94 24 00 01 00 00 48 89 54 24 78 48 8B 94 24 B8 00 00 00 48 89 54 24 70 48 8B 94 24 18 01 00 00 48 89 54 24 68 48 8B 94 24 F0 00 00 00 48 89 54 24 60 48 8B 94 24 C0 00 00 00 48 89 54 24 58 48 8B 94 24 C8 00 00 00 48 89 54 24 50 48 8B 94 24 D8 00 00 00 48 89 54 24 48 48 8B 94 24 E8 00 00 00 48 89 54 24 40 48 8B 94 24 F8 00 00 00 48 89 54 24 38 48 8B 94 24 08 01 00 00 48 89 54 24 30 48 8B 94 24 90 00 00 00 48 89 54 24 28 48 8B 04 C1 48 89 44 24 20 4C 8D 0D ?? ?? ?? ?? 41 B8 FF 0F 00 00 BA 00 10 00 00 48 8D 8C 24 30 03 00 00 E8 ?? ?? ?? ?? 89 84 24 98 00 00 00 83 BC 24 98 00 00 00 00 7D 47 E8 ?? ?? ?? ?? 48 C7 44 24 38 00 00 00 00 C7 44 24 30 7F 01 00 00 48 8D 0D ?? ?? ?? ?? 48 89 4C 24 28 48 8D 0D ?? ?? ?? ?? 48 89 4C 24 20 4C 8D 0D ?? ?? ?? ?? 41 B8 22 00 00 00 BA 16 00 00 00 8B 08 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 8C 24 A8 00 00 00 89 08 83 BC 24 98 00 00 00 00 7D 46 4C 8D 05 ?? ?? ?? ?? BA 00 10 00 00 48 8D 8C 24 30 03 00 00 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 82 01 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 41 B8 12 20 01 00 48 8D 15 ?? ?? ?? ?? 48 8D 8C 24 30 03 00 00 E8 ?? ?? ?? ?? 89 84 24 9C 00 00 00 83 BC 24 9C 00 00 00 03 75 14 B9 16 00 00 00 E8 ?? ?? ?? ?? B9 03 00 00 00 E8 ?? ?? ?? ?? 83 BC 24 9C 00 00 00 04 75 07 B8 01 00 00 00 EB 02 33 C0 48 8B 8C 24 30 23 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 48 23 00 00 C3 }
	condition:
		$1
}

rule file_72_7_0 {
	meta:
		name = "_invoke_watson_if_oneof"
		size = 99
		refs = "0056 _invoke_watson"
	strings:
		$1 = { 4C 89 4C 24 20 44 89 44 24 18 89 54 24 10 89 4C 24 08 48 83 EC 38 83 7C 24 40 00 74 14 8B 44 24 48 39 44 24 40 74 10 8B 44 24 50 39 44 24 40 74 06 8B 44 24 40 EB 27 48 8B 44 24 78 48 89 44 24 20 44 8B 4C 24 70 4C 8B 44 24 68 48 8B 54 24 60 48 8B 4C 24 58 E8 ?? ?? ?? ?? 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_73_3_0 {
	meta:
		name = "_mbsnbcat_s_l"
		size = 3373
		refs = "0085 ??_C@_1FC@NCPEPIBI@?$AA?$CI?$AA?$CI?$AA_?$AAD?$AAs?$AAt?$AA?$CJ?$AA?$CJ?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?$CI?$AA_?$AAS?$AAi?$AAz?$AAe?$AAI?$AAn?$AAB?$AAy?$AAt@ 0091 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 00a6 ??_C@_1HE@BEIFGGPP@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 00b0 _CrtDbgReportW 00c4 _errno 00e7 ??_C@_1BM@BENFBNLI@?$AA_?$AAm?$AAb?$AAs?$AAn?$AAb?$AAc?$AAa?$AAt?$AA_?$AAs?$AA_?$AAl?$AA?$AA@ 00f3 _invalid_parameter 015c __crtDebugFillThreshold 01a2 memset 01d5 ??_C@_1CG@OFBJMIGJ@?$AA?$CI?$AA?$CI?$AA?$CI?$AA_?$AAS?$AAr?$AAc?$AA?$CJ?$AA?$CJ?$AA?$CJ?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0262 ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 026f ?GetLocaleT@_LocaleUpdate@@QEAAPEAUlocaleinfo_struct@@XZ 029e strncat_s 02b2 ??1_LocaleUpdate@@QEAA@XZ 03a2 ??_C@_1DM@FHLMIEG@?$AAS?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AAi?$AAs?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAn?$AAu?$AAl?$AAl?$AA?5?$AAt?$AAe?$AAr?$AAm?$AAi?$AAn?$AAa?$AAt?$AAe?$AAd?$AA?$AA@ 03de ??_C@_1FA@MJKDNFFB@?$AA?$CI?$AAL?$AA?$CC?$AAS?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AAi?$AAs?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAn?$AAu?$AAl?$AAl?$AA?5?$AAt?$AAe?$AAr?$AAm?$AAi?$AAn?$AAa?$AAt?$AAe?$AAd@ 04f0 _ismbblead_l 05e1 _CrtGetCheckCount 05fb ??_C@_1CI@HCPHDDLE@?$AAB?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AAi?$AAs?$AA?5?$AAt?$AAo?$AAo?$AA?5?$AAs?$AAm?$AAa?$AAl?$AAl?$AA?$AA@ 0a6a ??_C@_1DM@MADKGDLO@?$AA?$CI?$AAL?$AA?$CC?$AAB?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AAi?$AAs?$AA?5?$AAt?$AAo?$AAo?$AA?5?$AAs?$AAm?$AAa?$AAl?$AAl?$AA?$CC?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA0?$AA?$CJ?$AA?$AA@"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 81 EC 58 01 00 00 C7 44 24 44 00 00 00 00 48 83 BC 24 78 01 00 00 00 75 1D 48 83 BC 24 60 01 00 00 00 75 12 48 83 BC 24 68 01 00 00 00 75 07 33 C0 E9 DA 0C 00 00 48 83 BC 24 60 01 00 00 00 74 15 48 83 BC 24 68 01 00 00 00 76 0A C7 44 24 5C 01 00 00 00 EB 08 C7 44 24 5C 00 00 00 00 8B 44 24 5C 89 44 24 68 83 7C 24 68 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 20 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 68 00 75 3E E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 20 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 16 00 00 00 E9 24 0C 00 00 48 83 BC 24 78 01 00 00 00 0F 84 41 01 00 00 48 83 BC 24 70 01 00 00 00 0F 85 32 01 00 00 48 8B 84 24 60 01 00 00 C6 00 00 48 83 BC 24 68 01 00 00 FF 74 71 48 81 BC 24 68 01 00 00 FF FF FF 7F 74 63 48 83 BC 24 68 01 00 00 01 76 58 48 8B 84 24 68 01 00 00 48 FF C8 48 39 05 ?? ?? ?? ?? 73 11 48 8B 05 ?? ?? ?? ?? 48 89 84 24 08 01 00 00 EB 13 48 8B 84 24 68 01 00 00 48 FF C8 48 89 84 24 08 01 00 00 48 8B 84 24 60 01 00 00 48 FF C0 4C 8B 84 24 08 01 00 00 BA FE 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 48 83 BC 24 70 01 00 00 00 74 0A C7 44 24 70 01 00 00 00 EB 08 C7 44 24 70 00 00 00 00 8B 44 24 70 89 44 24 50 83 7C 24 50 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 23 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 50 00 75 3E E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 23 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 16 00 00 00 E9 D4 0A 00 00 48 8B 94 24 80 01 00 00 48 8D 8C 24 C8 00 00 00 E8 ?? ?? ?? ?? 48 8D 8C 24 C8 00 00 00 E8 ?? ?? ?? ?? 48 8B 40 08 83 78 08 00 75 45 4C 8B 8C 24 78 01 00 00 4C 8B 84 24 70 01 00 00 48 8B 94 24 68 01 00 00 48 8B 8C 24 60 01 00 00 E8 ?? ?? ?? ?? 89 84 24 C4 00 00 00 48 8D 8C 24 C8 00 00 00 E8 ?? ?? ?? ?? 8B 84 24 C4 00 00 00 E9 63 0A 00 00 48 8B 84 24 60 01 00 00 48 89 44 24 38 48 8B 84 24 68 01 00 00 48 89 44 24 30 48 83 7C 24 30 00 76 28 48 8B 44 24 38 0F B6 00 85 C0 74 1C 48 8B 44 24 38 48 FF C0 48 89 44 24 38 48 8B 44 24 30 48 FF C8 48 89 44 24 30 EB D0 48 83 7C 24 30 00 0F 85 5C 01 00 00 48 8B 84 24 60 01 00 00 C6 00 00 48 83 BC 24 68 01 00 00 FF 74 71 48 81 BC 24 68 01 00 00 FF FF FF 7F 74 63 48 83 BC 24 68 01 00 00 01 76 58 48 8B 84 24 68 01 00 00 48 FF C8 48 39 05 ?? ?? ?? ?? 73 11 48 8B 05 ?? ?? ?? ?? 48 89 84 24 E8 00 00 00 EB 13 48 8B 84 24 68 01 00 00 48 FF C8 48 89 84 24 E8 00 00 00 48 8B 84 24 60 01 00 00 48 FF C0 4C 8B 84 24 E8 00 00 00 BA FE 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 85 C0 74 13 33 C0 85 C0 74 0D C7 84 24 80 00 00 00 01 00 00 00 EB 0B C7 84 24 80 00 00 00 00 00 00 00 8B 84 24 80 00 00 00 89 44 24 58 83 7C 24 58 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 40 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 58 00 75 58 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 40 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 84 24 B4 00 00 00 16 00 00 00 48 8D 8C 24 C8 00 00 00 E8 ?? ?? ?? ?? 8B 84 24 B4 00 00 00 E9 B1 08 00 00 48 8B 84 24 68 01 00 00 48 39 44 24 30 0F 83 E7 00 00 00 C7 44 24 40 00 00 00 00 48 8B 84 24 60 01 00 00 48 89 84 24 28 01 00 00 B8 01 00 00 00 48 6B C0 FF 48 8B 4C 24 38 48 03 C8 48 8B C1 48 89 84 24 F8 00 00 00 48 8B 84 24 F8 00 00 00 48 89 44 24 78 48 8B 84 24 28 01 00 00 48 39 44 24 78 72 30 48 8D 8C 24 C8 00 00 00 E8 ?? ?? ?? ?? 48 8B 4C 24 78 0F B6 09 48 8B D0 E8 ?? ?? ?? ?? 85 C0 74 0F 48 8B 44 24 78 48 FF C8 48 89 44 24 78 EB C1 48 8B 44 24 78 48 8B 8C 24 F8 00 00 00 48 2B C8 48 8B C1 48 83 E0 01 48 85 C0 74 0A C7 44 24 74 01 00 00 00 EB 08 C7 44 24 74 00 00 00 00 8B 44 24 74 89 44 24 40 83 7C 24 40 00 74 2A 48 8B 44 24 38 48 FF C8 48 89 44 24 38 48 8B 44 24 38 C6 00 00 48 8B 44 24 30 48 FF C0 48 89 44 24 30 C7 44 24 44 01 00 00 00 48 83 BC 24 78 01 00 00 FF 75 67 48 8B 44 24 38 48 8B 8C 24 70 01 00 00 0F B6 09 88 08 48 8B 44 24 38 0F B6 00 89 84 24 A4 00 00 00 48 8B 44 24 38 48 FF C0 48 89 44 24 38 48 8B 84 24 70 01 00 00 48 FF C0 48 89 84 24 70 01 00 00 83 BC 24 A4 00 00 00 00 74 17 48 8B 44 24 30 48 FF C8 48 89 44 24 30 48 83 7C 24 30 00 76 02 EB 9E E9 F2 00 00 00 E8 ?? ?? ?? ?? 85 C0 74 49 48 8B 44 24 30 48 39 84 24 78 01 00 00 72 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 5D 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 48 83 BC 24 78 01 00 00 00 76 75 48 8B 44 24 38 48 8B 8C 24 70 01 00 00 0F B6 09 88 08 48 8B 44 24 38 0F B6 00 89 84 24 A8 00 00 00 48 8B 44 24 38 48 FF C0 48 89 44 24 38 48 8B 84 24 70 01 00 00 48 FF C0 48 89 84 24 70 01 00 00 83 BC 24 A8 00 00 00 00 74 2A 48 8B 44 24 30 48 FF C8 48 89 44 24 30 48 83 7C 24 30 00 76 15 48 8B 84 24 78 01 00 00 48 FF C8 48 89 84 24 78 01 00 00 EB 80 48 83 BC 24 78 01 00 00 00 75 15 48 8B 44 24 38 C6 00 00 48 8B 44 24 38 48 FF C0 48 89 44 24 38 48 83 7C 24 30 00 0F 85 22 04 00 00 48 8B 84 24 70 01 00 00 0F B6 00 85 C0 74 0F 48 83 BC 24 78 01 00 00 01 0F 85 08 01 00 00 48 8B 84 24 60 01 00 00 48 89 84 24 40 01 00 00 B8 01 00 00 00 48 6B C0 FF 48 8B 4C 24 38 48 03 C8 48 8B C1 48 89 84 24 10 01 00 00 48 8B 84 24 10 01 00 00 48 89 84 24 88 00 00 00 48 8B 84 24 40 01 00 00 48 39 84 24 88 00 00 00 72 39 48 8D 8C 24 C8 00 00 00 E8 ?? ?? ?? ?? 48 8B 8C 24 88 00 00 00 0F B6 09 48 8B D0 E8 ?? ?? ?? ?? 85 C0 74 15 48 8B 84 24 88 00 00 00 48 FF C8 48 89 84 24 88 00 00 00 EB B5 48 8B 84 24 88 00 00 00 48 8B 8C 24 10 01 00 00 48 2B C8 48 8B C1 48 83 E0 01 48 85 C0 74 0A C7 44 24 48 01 00 00 00 EB 08 C7 44 24 48 00 00 00 00 8B 44 24 48 89 44 24 40 83 7C 24 40 00 74 41 B8 01 00 00 00 48 6B C0 FF 48 8B 4C 24 38 C6 04 01 00 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 C7 84 24 B0 00 00 00 2A 00 00 00 48 8D 8C 24 C8 00 00 00 E8 ?? ?? ?? ?? 8B 84 24 B0 00 00 00 E9 21 05 00 00 48 83 BC 24 78 01 00 00 FF 0F 85 9A 01 00 00 83 7C 24 44 00 74 0B E8 ?? ?? ?? ?? C7 00 2A 00 00 00 48 83 BC 24 68 01 00 00 01 0F 86 3B 01 00 00 C7 44 24 40 00 00 00 00 48 8B 84 24 60 01 00 00 48 89 84 24 38 01 00 00 48 8B 84 24 60 01 00 00 48 8B 8C 24 68 01 00 00 48 8D 44 08 FE 48 89 84 24 20 01 00 00 48 8B 84 24 20 01 00 00 48 89 84 24 98 00 00 00 48 8B 84 24 38 01 00 00 48 39 84 24 98 00 00 00 72 39 48 8D 8C 24 C8 00 00 00 E8 ?? ?? ?? ?? 48 8B 8C 24 98 00 00 00 0F B6 09 48 8B D0 E8 ?? ?? ?? ?? 85 C0 74 15 48 8B 84 24 98 00 00 00 48 FF C8 48 89 84 24 98 00 00 00 EB B5 48 8B 84 24 98 00 00 00 48 8B 8C 24 20 01 00 00 48 2B C8 48 8B C1 48 83 E0 01 48 85 C0 74 0D C7 84 24 90 00 00 00 01 00 00 00 EB 0B C7 84 24 90 00 00 00 00 00 00 00 8B 84 24 90 00 00 00 89 44 24 40 83 7C 24 40 00 74 62 48 8B 84 24 68 01 00 00 48 8B 8C 24 60 01 00 00 48 03 C8 48 8B C1 C6 40 FE 00 48 83 3D ?? ?? ?? ?? 00 76 1A 48 8B 84 24 68 01 00 00 48 8B 8C 24 60 01 00 00 48 03 C8 48 8B C1 C6 40 FF FE C7 84 24 B8 00 00 00 50 00 00 00 48 8D 8C 24 C8 00 00 00 E8 ?? ?? ?? ?? 8B 84 24 B8 00 00 00 E9 B6 03 00 00 48 8B 84 24 68 01 00 00 48 8B 8C 24 60 01 00 00 48 03 C8 48 8B C1 C6 40 FF 00 C7 84 24 C0 00 00 00 50 00 00 00 48 8D 8C 24 C8 00 00 00 E8 ?? ?? ?? ?? 8B 84 24 C0 00 00 00 E9 78 03 00 00 48 8B 84 24 60 01 00 00 C6 00 00 48 83 BC 24 68 01 00 00 FF 74 71 48 81 BC 24 68 01 00 00 FF FF FF 7F 74 63 48 83 BC 24 68 01 00 00 01 76 58 48 8B 84 24 68 01 00 00 48 FF C8 48 39 05 ?? ?? ?? ?? 73 11 48 8B 05 ?? ?? ?? ?? 48 89 84 24 18 01 00 00 EB 13 48 8B 84 24 68 01 00 00 48 FF C8 48 89 84 24 18 01 00 00 48 8B 84 24 60 01 00 00 48 FF C0 4C 8B 84 24 18 01 00 00 BA FE 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 85 C0 74 10 33 C0 85 C0 74 0A C7 44 24 6C 01 00 00 00 EB 08 C7 44 24 6C 00 00 00 00 8B 44 24 6C 89 44 24 4C 83 7C 24 4C 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 BC 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 4C 00 75 58 E8 ?? ?? ?? ?? C7 00 22 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 BC 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 84 24 A0 00 00 00 22 00 00 00 48 8D 8C 24 C8 00 00 00 E8 ?? ?? ?? ?? 8B 84 24 A0 00 00 00 E9 25 02 00 00 48 8B 84 24 68 01 00 00 48 39 44 24 30 0F 83 DC 00 00 00 48 8B 84 24 60 01 00 00 48 89 84 24 30 01 00 00 B8 01 00 00 00 48 6B C0 FE 48 8B 4C 24 38 48 03 C8 48 8B C1 48 89 84 24 00 01 00 00 48 8B 84 24 00 01 00 00 48 89 44 24 60 48 8B 84 24 30 01 00 00 48 39 44 24 60 72 30 48 8D 8C 24 C8 00 00 00 E8 ?? ?? ?? ?? 48 8B 4C 24 60 0F B6 09 48 8B D0 E8 ?? ?? ?? ?? 85 C0 74 0F 48 8B 44 24 60 48 FF C8 48 89 44 24 60 EB C1 48 8B 44 24 60 48 8B 8C 24 00 01 00 00 48 2B C8 48 8B C1 48 83 E0 01 48 85 C0 74 0A C7 44 24 54 01 00 00 00 EB 08 C7 44 24 54 00 00 00 00 8B 44 24 54 89 44 24 40 83 7C 24 40 00 74 27 B8 01 00 00 00 48 6B C0 FE 48 8B 4C 24 38 C6 04 01 00 48 8B 44 24 30 48 FF C0 48 89 44 24 30 C7 44 24 44 01 00 00 00 48 83 BC 24 68 01 00 00 FF 0F 84 D5 00 00 00 48 81 BC 24 68 01 00 00 FF FF FF 7F 0F 84 C3 00 00 00 48 8B 44 24 30 48 8B 8C 24 68 01 00 00 48 2B C8 48 8B C1 48 FF C0 48 3B 84 24 68 01 00 00 0F 83 9F 00 00 00 48 8B 44 24 30 48 8B 8C 24 68 01 00 00 48 2B C8 48 8B C1 48 FF C0 48 8B 8C 24 68 01 00 00 48 2B C8 48 8B C1 48 39 05 ?? ?? ?? ?? 73 11 48 8B 05 ?? ?? ?? ?? 48 89 84 24 F0 00 00 00 EB 2C 48 8B 44 24 30 48 8B 8C 24 68 01 00 00 48 2B C8 48 8B C1 48 FF C0 48 8B 8C 24 68 01 00 00 48 2B C8 48 8B C1 48 89 84 24 F0 00 00 00 48 8B 44 24 30 48 8B 8C 24 68 01 00 00 48 2B C8 48 8B C1 48 8B 8C 24 60 01 00 00 48 8D 44 01 01 4C 8B 84 24 F0 00 00 00 BA FE 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 83 7C 24 44 00 74 2C E8 ?? ?? ?? ?? C7 00 2A 00 00 00 C7 84 24 AC 00 00 00 2A 00 00 00 48 8D 8C 24 C8 00 00 00 E8 ?? ?? ?? ?? 8B 84 24 AC 00 00 00 EB 1F C7 84 24 BC 00 00 00 00 00 00 00 48 8D 8C 24 C8 00 00 00 E8 ?? ?? ?? ?? 8B 84 24 BC 00 00 00 48 81 C4 58 01 00 00 C3 }
	condition:
		$1
}

rule file_74_0_0 {
	meta:
		name = "__read_mxcsr"
		size = 16
	strings:
		$1 = { 48 83 EC 10 0F AE 1C 24 8B 04 24 48 83 C4 10 C3 }
	condition:
		$1
}

rule file_74_1_0 {
	meta:
		name = "__write_mxcsr"
		size = 16
	strings:
		$1 = { 48 83 EC 10 89 0C 24 0F AE 14 24 48 83 C4 10 C3 }
	condition:
		$1
}

rule file_74_2_0 {
	meta:
		name = "__int_addss"
		size = 17
	strings:
		$1 = { 66 0F 6E C1 66 0F 6E CA F3 0F 58 C1 66 0F 7E C0 C3 }
	condition:
		$1
}

rule file_74_3_0 {
	meta:
		name = "__int_subss"
		size = 17
	strings:
		$1 = { 66 0F 6E C1 66 0F 6E CA F3 0F 5C C1 66 0F 7E C0 C3 }
	condition:
		$1
}

rule file_74_4_0 {
	meta:
		name = "__int_mulss"
		size = 17
	strings:
		$1 = { 66 0F 6E C1 66 0F 6E CA F3 0F 59 C1 66 0F 7E C0 C3 }
	condition:
		$1
}

rule file_74_5_0 {
	meta:
		name = "__int_divss"
		size = 17
	strings:
		$1 = { 66 0F 6E C1 66 0F 6E CA F3 0F 5E C1 66 0F 7E C0 C3 }
	condition:
		$1
}

rule file_74_12_0 {
	meta:
		name = "__int_cmpss"
		size = 137
	strings:
		$1 = { 66 0F 6E C1 66 0F 6E CA 49 83 F8 00 74 2B 49 83 F8 01 74 2F 49 83 F8 02 74 33 49 83 F8 03 74 37 49 83 F8 04 74 3B 49 83 F8 05 74 3F 49 83 F8 06 74 43 49 83 F8 07 74 47 C3 F3 0F C2 C1 00 66 0F 7E C0 C3 F3 0F C2 C1 01 66 0F 7E C0 C3 F3 0F C2 C1 02 66 0F 7E C0 C3 F3 0F C2 C1 03 66 0F 7E C0 C3 F3 0F C2 C1 04 66 0F 7E C0 C3 F3 0F C2 C1 05 66 0F 7E C0 C3 F3 0F C2 C1 06 66 0F 7E C0 C3 F3 0F C2 C1 07 66 0F 7E C0 C3 }
	condition:
		$1
}

rule file_74_15_0 {
	meta:
		name = "__int_maxss"
		size = 17
	strings:
		$1 = { 66 0F 6E C1 66 0F 6E CA F3 0F 5F C1 66 0F 7E C0 C3 }
	condition:
		$1
}

rule file_74_16_0 {
	meta:
		name = "__int_minss"
		size = 17
	strings:
		$1 = { 66 0F 6E C1 66 0F 6E CA F3 0F 5D C1 66 0F 7E C0 C3 }
	condition:
		$1
}

rule file_74_18_0 {
	meta:
		name = "__int_addsd"
		size = 40
	strings:
		$1 = { 48 83 EC 10 48 89 0C 24 F2 0F 10 04 24 48 89 14 24 F2 0F 10 0C 24 F2 0F 58 C1 F2 0F 11 04 24 48 8B 04 24 48 83 C4 10 C3 }
	condition:
		$1
}

rule file_74_19_0 {
	meta:
		name = "__int_subsd"
		size = 40
	strings:
		$1 = { 48 83 EC 10 48 89 0C 24 F2 0F 10 04 24 48 89 14 24 F2 0F 10 0C 24 F2 0F 5C C1 F2 0F 11 04 24 48 8B 04 24 48 83 C4 10 C3 }
	condition:
		$1
}

rule file_74_20_0 {
	meta:
		name = "__int_mulsd"
		size = 40
	strings:
		$1 = { 48 83 EC 10 48 89 0C 24 F2 0F 10 04 24 48 89 14 24 F2 0F 10 0C 24 F2 0F 59 C1 F2 0F 11 04 24 48 8B 04 24 48 83 C4 10 C3 }
	condition:
		$1
}

rule file_74_21_0 {
	meta:
		name = "__int_divsd"
		size = 40
	strings:
		$1 = { 48 83 EC 10 48 89 0C 24 F2 0F 10 04 24 48 89 14 24 F2 0F 10 0C 24 F2 0F 5E C1 F2 0F 11 04 24 48 8B 04 24 48 83 C4 10 C3 }
	condition:
		$1
}

rule file_74_22_0 {
	meta:
		name = "__int_cmpsd"
		size = 227
	strings:
		$1 = { 48 83 EC 10 48 89 0C 24 F2 0F 10 04 24 48 89 14 24 F2 0F 10 0C 24 49 83 F8 00 74 2F 49 83 F8 01 74 3C 49 83 F8 02 74 49 49 83 F8 03 74 56 49 83 F8 04 74 63 49 83 F8 05 74 70 49 83 F8 06 74 7D 49 83 F8 07 0F 84 86 00 00 00 C3 F2 0F C2 C1 00 F2 0F 11 04 24 48 8B 04 24 48 83 C4 10 C3 F2 0F C2 C1 01 F2 0F 11 04 24 48 8B 04 24 48 83 C4 10 C3 F2 0F C2 C1 02 F2 0F 11 04 24 48 8B 04 24 48 83 C4 10 C3 F2 0F C2 C1 03 F2 0F 11 04 24 48 8B 04 24 48 83 C4 10 C3 F2 0F C2 C1 04 F2 0F 11 04 24 48 8B 04 24 48 83 C4 10 C3 F2 0F C2 C1 05 F2 0F 11 04 24 48 8B 04 24 48 83 C4 10 C3 F2 0F C2 C1 06 F2 0F 11 04 24 48 8B 04 24 48 83 C4 10 C3 F2 0F C2 C1 07 F2 0F 11 04 24 48 8B 04 24 48 83 C4 10 C3 }
	condition:
		$1
}

rule file_74_23_0 {
	meta:
		name = "__int_comisd"
		size = 31
	strings:
		$1 = { 48 83 EC 10 48 89 0C 24 F2 0F 10 04 24 48 89 14 24 F2 0F 10 0C 24 66 0F 2F C1 48 83 C4 10 C3 }
	condition:
		$1
}

rule file_74_24_0 {
	meta:
		name = "__int_ucomisd"
		size = 31
	strings:
		$1 = { 48 83 EC 10 48 89 0C 24 F2 0F 10 04 24 48 89 14 24 F2 0F 10 0C 24 66 0F 2E C1 48 83 C4 10 C3 }
	condition:
		$1
}

rule file_74_25_0 {
	meta:
		name = "__int_cvtsd2si"
		size = 22
	strings:
		$1 = { 48 83 EC 10 48 89 0C 24 F2 0F 10 04 24 F2 0F 2D C0 48 83 C4 10 C3 }
	condition:
		$1
}

rule file_74_26_0 {
	meta:
		name = "__int64_cvtsd2si"
		size = 23
	strings:
		$1 = { 48 83 EC 10 48 89 0C 24 F2 0F 10 04 24 F2 48 0F 2D C0 48 83 C4 10 C3 }
	condition:
		$1
}

rule file_74_27_0 {
	meta:
		name = "__int_cvttsd2si"
		size = 22
	strings:
		$1 = { 48 83 EC 10 48 89 0C 24 F2 0F 10 04 24 F2 0F 2C C0 48 83 C4 10 C3 }
	condition:
		$1
}

rule file_74_28_0 {
	meta:
		name = "__int64_cvttsd2si"
		size = 23
	strings:
		$1 = { 48 83 EC 10 48 89 0C 24 F2 0F 10 04 24 F2 48 0F 2C C0 48 83 C4 10 C3 }
	condition:
		$1
}

rule file_74_29_0 {
	meta:
		name = "__int_cvtss2sd"
		size = 26
	strings:
		$1 = { 48 83 EC 10 66 0F 6E C1 F3 0F 5A C0 F2 0F 11 04 24 48 8B 04 24 48 83 C4 10 C3 }
	condition:
		$1
}

rule file_74_30_0 {
	meta:
		name = "__int_cvtsd2ss"
		size = 26
	strings:
		$1 = { 48 83 EC 10 48 89 0C 24 F2 0F 10 04 24 F2 0F 5A C0 66 0F 7E C0 48 83 C4 10 C3 }
	condition:
		$1
}

rule file_74_31_0 {
	meta:
		name = "__int_maxsd"
		size = 40
	strings:
		$1 = { 48 83 EC 10 48 89 0C 24 F2 0F 10 04 24 48 89 14 24 F2 0F 10 0C 24 F2 0F 5F C1 F2 0F 11 04 24 48 8B 04 24 48 83 C4 10 C3 }
	condition:
		$1
}

rule file_74_32_0 {
	meta:
		name = "__int_minsd"
		size = 40
	strings:
		$1 = { 48 83 EC 10 48 89 0C 24 F2 0F 10 04 24 48 89 14 24 F2 0F 10 0C 24 F2 0F 5D C1 F2 0F 11 04 24 48 8B 04 24 48 83 C4 10 C3 }
	condition:
		$1
}

rule file_74_33_0 {
	meta:
		name = "__int_sqrtsd"
		size = 31
	strings:
		$1 = { 48 83 EC 10 48 89 0C 24 F2 0F 10 04 24 F2 0F 51 C0 F2 0F 11 04 24 48 8B 04 24 48 83 C4 10 C3 }
	condition:
		$1
}

rule file_75_2_0 {
	meta:
		name = "?wcstoxq@@YA_KPEAUlocaleinfo_struct@@PEB_WPEAPEB_WHH@Z"
		size = 1663
		refs = "0038 ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 008a ??_C@_1BK@LAOAACLJ@?$AAn?$AAp?$AAt?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0096 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 00ab ??_C@_1GK@ILDAMGBN@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 00b5 _CrtDbgReportW 00c9 _errno 00ec ??_C@_1BA@FACINJJA@?$AAw?$AAc?$AAs?$AAt?$AAo?$AAx?$AAq?$AA?$AA@ 00f8 _invalid_parameter 010e ??1_LocaleUpdate@@QEAA@XZ 015e ??_C@_1FE@CEHLKAHD@?$AAi?$AAb?$AAa?$AAs?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AA?$CI?$AA2?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAi?$AAb?$AAa?$AAs?$AAe?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAi?$AAb?$AAa@ 022b iswctype 0321 _wchartodigit"
	strings:
		$1 = { 44 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 81 EC C8 00 00 00 48 C7 84 24 B8 00 00 00 FE FF FF FF 48 8B 94 24 D0 00 00 00 48 8D 8C 24 98 00 00 00 E8 ?? ?? ?? ?? 90 48 83 BC 24 E0 00 00 00 00 74 13 48 8B 84 24 E0 00 00 00 48 8B 8C 24 D8 00 00 00 48 89 08 48 83 BC 24 D8 00 00 00 00 74 0A C7 44 24 58 01 00 00 00 EB 08 C7 44 24 58 00 00 00 00 8B 44 24 58 89 44 24 5C 83 7C 24 5C 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 5F 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 5C 00 75 54 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 5F 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 C7 44 24 68 00 00 00 00 48 8D 8C 24 98 00 00 00 E8 ?? ?? ?? ?? 48 8B 44 24 68 E9 5B 05 00 00 83 BC 24 E8 00 00 00 00 74 1E 83 BC 24 E8 00 00 00 02 7C 0A 83 BC 24 E8 00 00 00 24 7E 0A C7 44 24 50 00 00 00 00 EB 08 C7 44 24 50 01 00 00 00 8B 44 24 50 89 44 24 54 83 7C 24 54 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 60 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 54 00 75 54 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 60 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 C7 44 24 78 00 00 00 00 48 8D 8C 24 98 00 00 00 E8 ?? ?? ?? ?? 48 8B 44 24 78 E9 87 04 00 00 48 8B 84 24 D8 00 00 00 48 89 44 24 38 48 C7 44 24 40 00 00 00 00 48 8B 44 24 38 0F B7 00 66 89 44 24 30 48 8B 44 24 38 48 83 C0 02 48 89 44 24 38 66 BA 08 00 0F B7 4C 24 30 E8 ?? ?? ?? ?? 85 C0 74 1D 48 8B 44 24 38 0F B7 00 66 89 44 24 30 48 8B 44 24 38 48 83 C0 02 48 89 44 24 38 EB D1 0F B7 44 24 30 83 F8 2D 75 2E 8B 84 24 F0 00 00 00 83 C8 02 89 84 24 F0 00 00 00 48 8B 44 24 38 0F B7 00 66 89 44 24 30 48 8B 44 24 38 48 83 C0 02 48 89 44 24 38 EB 25 0F B7 44 24 30 83 F8 2B 75 1B 48 8B 44 24 38 0F B7 00 66 89 44 24 30 48 8B 44 24 38 48 83 C0 02 48 89 44 24 38 83 BC 24 E8 00 00 00 00 7C 14 83 BC 24 E8 00 00 00 01 74 0A 83 BC 24 E8 00 00 00 24 7E 46 48 83 BC 24 E0 00 00 00 00 74 13 48 8B 84 24 E0 00 00 00 48 8B 8C 24 D8 00 00 00 48 89 08 48 C7 84 24 90 00 00 00 00 00 00 00 48 8D 8C 24 98 00 00 00 E8 ?? ?? ?? ?? 48 8B 84 24 90 00 00 00 E9 68 03 00 00 EB 57 83 BC 24 E8 00 00 00 00 75 4D 0F B7 4C 24 30 E8 ?? ?? ?? ?? 85 C0 74 0D C7 84 24 E8 00 00 00 0A 00 00 00 EB 32 48 8B 44 24 38 0F B7 00 83 F8 78 74 0D 48 8B 44 24 38 0F B7 00 83 F8 58 75 0D C7 84 24 E8 00 00 00 10 00 00 00 EB 0B C7 84 24 E8 00 00 00 08 00 00 00 83 BC 24 E8 00 00 00 10 75 51 0F B7 4C 24 30 E8 ?? ?? ?? ?? 85 C0 75 43 48 8B 44 24 38 0F B7 00 83 F8 78 74 0D 48 8B 44 24 38 0F B7 00 83 F8 58 75 29 48 8B 44 24 38 48 83 C0 02 48 89 44 24 38 48 8B 44 24 38 0F B7 00 66 89 44 24 30 48 8B 44 24 38 48 83 C0 02 48 89 44 24 38 48 63 84 24 E8 00 00 00 48 89 84 24 88 00 00 00 33 D2 48 C7 C0 FF FF FF FF 48 8B 8C 24 88 00 00 00 48 F7 F1 48 89 44 24 60 0F B7 4C 24 30 E8 ?? ?? ?? ?? 89 44 24 48 83 7C 24 48 FF 74 02 EB 65 0F B7 44 24 30 83 F8 41 7C 0A 0F B7 44 24 30 83 F8 5A 7E 14 0F B7 44 24 30 83 F8 61 7C 42 0F B7 44 24 30 83 F8 7A 7F 38 0F B7 44 24 30 83 F8 61 7C 18 0F B7 44 24 30 83 F8 7A 7F 0E 0F B7 44 24 30 83 E8 20 89 44 24 4C EB 09 0F B7 44 24 30 89 44 24 4C 8B 44 24 4C 83 E8 37 89 44 24 48 EB 05 E9 C5 00 00 00 8B 84 24 E8 00 00 00 39 44 24 48 72 05 E9 B3 00 00 00 8B 84 24 F0 00 00 00 83 C8 08 89 84 24 F0 00 00 00 48 8B 44 24 60 48 39 44 24 40 72 36 48 8B 44 24 60 48 39 44 24 40 75 4C 8B 44 24 48 48 89 44 24 70 48 63 8C 24 E8 00 00 00 33 D2 48 C7 C0 FF FF FF FF 48 F7 F1 48 8B C2 48 8B 4C 24 70 48 3B C8 77 22 48 63 84 24 E8 00 00 00 48 8B 4C 24 40 48 0F AF C8 48 8B C1 8B 4C 24 48 48 03 C1 48 89 44 24 40 EB 1E 8B 84 24 F0 00 00 00 83 C8 04 89 84 24 F0 00 00 00 48 83 BC 24 E0 00 00 00 00 75 02 EB 20 48 8B 44 24 38 0F B7 00 66 89 44 24 30 48 8B 44 24 38 48 83 C0 02 48 89 44 24 38 E9 BF FE FF FF 48 8B 44 24 38 48 83 E8 02 48 89 44 24 38 8B 84 24 F0 00 00 00 83 E0 08 85 C0 75 26 48 83 BC 24 E0 00 00 00 00 74 0D 48 8B 84 24 D8 00 00 00 48 89 44 24 38 48 C7 44 24 40 00 00 00 00 E9 B0 00 00 00 8B 84 24 F0 00 00 00 83 E0 04 85 C0 75 50 8B 84 24 F0 00 00 00 83 E0 01 85 C0 0F 85 90 00 00 00 8B 84 24 F0 00 00 00 83 E0 02 85 C0 74 11 48 B8 00 00 00 00 00 00 00 80 48 39 44 24 40 77 1F 8B 84 24 F0 00 00 00 83 E0 02 85 C0 75 63 48 B8 FF FF FF FF FF FF FF 7F 48 39 44 24 40 76 52 E8 ?? ?? ?? ?? C7 00 22 00 00 00 8B 84 24 F0 00 00 00 83 E0 01 85 C0 74 0B 48 C7 44 24 40 FF FF FF FF EB 2E 8B 84 24 F0 00 00 00 83 E0 02 85 C0 74 11 48 B8 00 00 00 00 00 00 00 80 48 89 44 24 40 EB 0F 48 B8 FF FF FF FF FF FF FF 7F 48 89 44 24 40 48 83 BC 24 E0 00 00 00 00 74 10 48 8B 84 24 E0 00 00 00 48 8B 4C 24 38 48 89 08 8B 84 24 F0 00 00 00 83 E0 02 85 C0 74 0D 48 8B 44 24 40 48 F7 D8 48 89 44 24 40 48 8B 44 24 40 48 89 84 24 80 00 00 00 48 8D 8C 24 98 00 00 00 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 48 81 C4 C8 00 00 00 C3 }
	condition:
		$1
}

rule file_75_3_0 {
	meta:
		name = "?dtor$0@?0??wcstoxq@@YA_KPEAUlocaleinfo_struct@@PEB_WPEAPEB_WHH@Z@4HA"
		size = 27
		refs = "0011 ??1_LocaleUpdate@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 8D 98 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_15_156_1 {
	meta:
		name = "?dtor$0@?0??_Endwrite@?$basic_filebuf@DU?$char_traits@D@std@@@std@@IEAA_NXZ@4HA"
		size = 27
		refs = "0011 ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 8D 98 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_7_156_1 {
	meta:
		name = "?dtor$0@?0??_Endwrite@?$basic_filebuf@GU?$char_traits@G@std@@@std@@IEAA_NXZ@4HA"
		size = 27
		refs = "0011 ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 8D 98 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_85_156_1 {
	meta:
		name = "?dtor$0@?0??_Endwrite@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@IEAA_NXZ@4HA"
		size = 27
		refs = "0011 ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 8D 98 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_66_705_3 {
	meta:
		name = "?dtor$0@?0??_Getffld@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@1AEAVios_base@2@PEAH@Z@4HA"
		size = 27
		refs = "0011 ??1locale@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 8D 98 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_66_710_3 {
	meta:
		name = "?dtor$0@?0??_Getffld@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@1AEAVios_base@2@PEAH@Z@4HA"
		size = 27
		refs = "0011 ??1locale@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 8D 98 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_66_838_3 {
	meta:
		name = "?dtor$0@?0??_Iput@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@AEBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AEAVios_base@2@GPEAD_K@Z@4HA"
		size = 27
		refs = "0011 ??1locale@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 8D 98 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_36_808_2 {
	meta:
		name = "?dtor$0@?0??_Iput@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@AEBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AEAVios_base@2@_WPEAD_K@Z@4HA"
		size = 27
		refs = "0011 ??1locale@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 8D 98 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_92_452_2 {
	meta:
		name = "?dtor$0@?0??do_put@?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@_NAEAVios_base@2@DAEBV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@@Z@4HA"
		size = 27
		refs = "0011 ??1locale@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 8D 98 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_36_1122_2 {
	meta:
		name = "?dtor$0@?0??do_put@?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@_NAEAVios_base@2@GAEBV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@@Z@4HA"
		size = 27
		refs = "0011 ??1locale@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 8D 98 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_36_1128_2 {
	meta:
		name = "?dtor$0@?0??do_put@?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@_NAEAVios_base@2@_WAEBV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@@Z@4HA"
		size = 27
		refs = "0011 ??1locale@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 8D 98 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_100_189_1 {
	meta:
		name = "?dtor$1@?0??_Getifld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1HAEBVlocale@2@@Z@4HA"
		size = 27
		refs = "0011 ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 8D 98 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_654_38_0 {
	meta:
		name = "?dtor$1@?0??current@location@Concurrency@@SA?AV12@XZ@4HA"
		size = 27
		refs = "0011 ??1location@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 8D 98 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_84_925_2 {
	meta:
		name = "?dtor$1@?0??set@?$task_completion_event@E@Concurrency@@QEBA_NE@Z@4HA"
		size = 27
		refs = "0011 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 8D 98 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_13_1255_3 {
	meta:
		name = "?dtor$1@?0??wait_for_all@agent@Concurrency@@SAX_KPEAPEAV12@PEAW4agent_status@2@I@Z@4HA"
		size = 27
		refs = "0011 ??1?$function@$$A6AXAEB_K@Z@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 8D 98 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_39_206_3 {
	meta:
		name = "?dtor$2@?0??_Getffld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1AEAVios_base@2@PEAH@Z@4HA"
		size = 27
		refs = "0011 ??1locale@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 8D 98 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_39_237_3 {
	meta:
		name = "?dtor$2@?0??_Iput@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@DPEAD_K@Z@4HA"
		size = 27
		refs = "0011 ??1locale@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 8D 98 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_54_311_3 {
	meta:
		name = "?dtor$6@?0???$insert@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@@?$vector@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@2@@std@@QEAA?AV?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@1@V?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@1@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@1@1@Z@4HA"
		size = 27
		refs = "0011 ??1?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 8D 98 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_84_285_2 {
	meta:
		name = "?dtor$6@?0???$insert@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@@?$vector@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@2@@std@@QEAA?AV?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@1@V?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@1@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@1@1@Z@4HA"
		size = 27
		refs = "0011 ??1?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 8D 98 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_75_4_0 {
	meta:
		name = "_wcstoi64"
		size = 102
		refs = "0015 __locale_changed 0036 __initiallocalestructinfo 003b ?wcstoxq@@YA_KPEAUlocaleinfo_struct@@PEB_WPEAPEB_WHH@Z"
	strings:
		$1 = { 44 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 83 3D ?? ?? ?? ?? 00 75 27 C7 44 24 20 00 00 00 00 44 8B 4C 24 50 4C 8B 44 24 48 48 8B 54 24 40 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 20 EB 1E C7 44 24 20 00 00 00 00 44 8B 4C 24 50 4C 8B 44 24 48 48 8B 54 24 40 33 C9 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_394_5_0 {
	meta:
		name = "_strtoi64"
		size = 102
		refs = "0015 __locale_changed 0036 __initiallocalestructinfo 003b ?strtoxq@@YA_KPEAUlocaleinfo_struct@@PEBDPEAPEBDHH@Z"
	strings:
		$1 = { 44 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 83 3D ?? ?? ?? ?? 00 75 27 C7 44 24 20 00 00 00 00 44 8B 4C 24 50 4C 8B 44 24 48 48 8B 54 24 40 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 20 EB 1E C7 44 24 20 00 00 00 00 44 8B 4C 24 50 4C 8B 44 24 48 48 8B 54 24 40 33 C9 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_629_7_0 {
	meta:
		name = "strtol"
		size = 102
		refs = "0015 __locale_changed 0036 __initiallocalestructinfo 003b ?strtoxl@@YAKPEAUlocaleinfo_struct@@PEBDPEAPEBDHH@Z"
	strings:
		$1 = { 44 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 83 3D ?? ?? ?? ?? 00 75 27 C7 44 24 20 00 00 00 00 44 8B 4C 24 50 4C 8B 44 24 48 48 8B 54 24 40 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 20 EB 1E C7 44 24 20 00 00 00 00 44 8B 4C 24 50 4C 8B 44 24 48 48 8B 54 24 40 33 C9 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_75_5_0 {
	meta:
		name = "_wcstoi64_l"
		size = 62
		refs = "0035 ?wcstoxq@@YA_KPEAUlocaleinfo_struct@@PEB_WPEAPEB_WHH@Z"
	strings:
		$1 = { 4C 89 4C 24 20 44 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 C7 44 24 20 00 00 00 00 44 8B 4C 24 50 4C 8B 44 24 48 48 8B 54 24 40 48 8B 4C 24 58 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_394_6_0 {
	meta:
		name = "_strtoi64_l"
		size = 62
		refs = "0035 ?strtoxq@@YA_KPEAUlocaleinfo_struct@@PEBDPEAPEBDHH@Z"
	strings:
		$1 = { 4C 89 4C 24 20 44 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 C7 44 24 20 00 00 00 00 44 8B 4C 24 50 4C 8B 44 24 48 48 8B 54 24 40 48 8B 4C 24 58 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_629_5_0 {
	meta:
		name = "_strtol_l"
		size = 62
		refs = "0035 ?strtoxl@@YAKPEAUlocaleinfo_struct@@PEBDPEAPEBDHH@Z"
	strings:
		$1 = { 4C 89 4C 24 20 44 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 C7 44 24 20 00 00 00 00 44 8B 4C 24 50 4C 8B 44 24 48 48 8B 54 24 40 48 8B 4C 24 58 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_75_6_0 {
	meta:
		name = "_wcstoui64"
		size = 102
		refs = "0015 __locale_changed 0036 __initiallocalestructinfo 003b ?wcstoxq@@YA_KPEAUlocaleinfo_struct@@PEB_WPEAPEB_WHH@Z"
	strings:
		$1 = { 44 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 83 3D ?? ?? ?? ?? 00 75 27 C7 44 24 20 01 00 00 00 44 8B 4C 24 50 4C 8B 44 24 48 48 8B 54 24 40 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 20 EB 1E C7 44 24 20 01 00 00 00 44 8B 4C 24 50 4C 8B 44 24 48 48 8B 54 24 40 33 C9 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_394_7_0 {
	meta:
		name = "_strtoui64"
		size = 102
		refs = "0015 __locale_changed 0036 __initiallocalestructinfo 003b ?strtoxq@@YA_KPEAUlocaleinfo_struct@@PEBDPEAPEBDHH@Z"
	strings:
		$1 = { 44 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 83 3D ?? ?? ?? ?? 00 75 27 C7 44 24 20 01 00 00 00 44 8B 4C 24 50 4C 8B 44 24 48 48 8B 54 24 40 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 20 EB 1E C7 44 24 20 01 00 00 00 44 8B 4C 24 50 4C 8B 44 24 48 48 8B 54 24 40 33 C9 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_629_8_0 {
	meta:
		name = "strtoul"
		size = 102
		refs = "0015 __locale_changed 0036 __initiallocalestructinfo 003b ?strtoxl@@YAKPEAUlocaleinfo_struct@@PEBDPEAPEBDHH@Z"
	strings:
		$1 = { 44 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 83 3D ?? ?? ?? ?? 00 75 27 C7 44 24 20 01 00 00 00 44 8B 4C 24 50 4C 8B 44 24 48 48 8B 54 24 40 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 20 EB 1E C7 44 24 20 01 00 00 00 44 8B 4C 24 50 4C 8B 44 24 48 48 8B 54 24 40 33 C9 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_75_7_0 {
	meta:
		name = "_wcstoui64_l"
		size = 62
		refs = "0035 ?wcstoxq@@YA_KPEAUlocaleinfo_struct@@PEB_WPEAPEB_WHH@Z"
	strings:
		$1 = { 4C 89 4C 24 20 44 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 C7 44 24 20 01 00 00 00 44 8B 4C 24 50 4C 8B 44 24 48 48 8B 54 24 40 48 8B 4C 24 58 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_394_8_0 {
	meta:
		name = "_strtoui64_l"
		size = 62
		refs = "0035 ?strtoxq@@YA_KPEAUlocaleinfo_struct@@PEBDPEAPEBDHH@Z"
	strings:
		$1 = { 4C 89 4C 24 20 44 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 C7 44 24 20 01 00 00 00 44 8B 4C 24 50 4C 8B 44 24 48 48 8B 54 24 40 48 8B 4C 24 58 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_629_6_0 {
	meta:
		name = "_strtoul_l"
		size = 62
		refs = "0035 ?strtoxl@@YAKPEAUlocaleinfo_struct@@PEBDPEAPEBDHH@Z"
	strings:
		$1 = { 4C 89 4C 24 20 44 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 C7 44 24 20 01 00 00 00 44 8B 4C 24 50 4C 8B 44 24 48 48 8B 54 24 40 48 8B 4C 24 58 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_76_3_0 {
	meta:
		name = "_INTRN_LOCALE_CONV"
		size = 34
		refs = "000f ?GetLocaleT@_LocaleUpdate@@QEAAPEAUlocaleinfo_struct@@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 00 48 8B 80 F0 00 00 00 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_76_4_0 {
	meta:
		name = "__check_float_string"
		size = 376
		refs = "002a ??_C@_1DO@MBOKMJPK@?$AAn?$AAF?$AAl?$AAo?$AAa?$AAt?$AAS?$AAt?$AAr?$AAU?$AAs?$AAe?$AAd?$AA?$DM?$AA?$DN?$AA?$CI?$AA?$CK?$AAp?$AAn?$AAF?$AAl?$AAo?$AAa?$AAt?$AAS?$AAt?$AAr?$AAS?$AAz?$AA?$CJ?$AA?$AA@ 0036 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 004b ??_C@_1GI@NCLMINOG@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 0055 _CrtDbgReportW 0092 ??_C@_0DE@NOAHFJIJ@f?3?2dd?2vctools?2crt_bld?2self_64_am@ 00aa _calloc_dbg 00ef memcpy 0139 _recalloc_dbg"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 48 8B 44 24 58 48 8B 00 48 39 44 24 50 76 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 AF 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 48 8B 44 24 58 48 8B 00 48 39 44 24 50 0F 85 FA 00 00 00 48 8B 44 24 60 48 8B 4C 24 68 48 39 08 0F 85 81 00 00 00 C7 44 24 20 B4 00 00 00 4C 8D 0D ?? ?? ?? ?? 41 B8 02 00 00 00 BA 04 00 00 00 48 8B 44 24 58 48 8B 08 E8 ?? ?? ?? ?? 48 8B 4C 24 60 48 89 01 48 8B 44 24 60 48 83 38 00 75 07 33 C0 E9 AB 00 00 00 48 8B 44 24 70 C7 00 01 00 00 00 48 8B 44 24 58 48 8B 00 48 D1 E0 4C 8B C0 48 8B 54 24 68 48 8B 44 24 60 48 8B 08 E8 ?? ?? ?? ?? 48 8B 44 24 58 48 8B 00 48 D1 E0 48 8B 4C 24 58 48 89 01 EB 66 C7 44 24 28 BE 00 00 00 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 41 B9 02 00 00 00 41 B8 04 00 00 00 48 8B 44 24 58 48 8B 10 48 8B 44 24 60 48 8B 08 E8 ?? ?? ?? ?? 48 89 44 24 30 48 83 7C 24 30 00 75 04 33 C0 EB 25 48 8B 44 24 60 48 8B 4C 24 30 48 89 08 48 8B 44 24 58 48 8B 00 48 D1 E0 48 8B 4C 24 58 48 89 01 B8 01 00 00 00 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_76_5_0 {
	meta:
		name = "_cprinput_l"
		size = 6868
		refs = "0019 __security_cookie 00c0 ??_C@_1CC@MGIEJOME@?$AA?$CI?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 00cc ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 00e1 ??_C@_1GI@NCLMINOG@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 00eb _CrtDbgReportW 0102 _errno 0125 ??_C@_1BI@KNCPPIAC@?$AA_?$AAc?$AAp?$AAr?$AAi?$AAn?$AAp?$AAu?$AAt?$AA_?$AAl?$AA?$AA@ 0131 _invalid_parameter 0140 _ioinit 0163 ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 01a3 iswctype 01bb _whiteout 01c3 _un_inc 02e4 isdigit 0347 __ImageBase 034f $LN239 0356 $LN240 065c _inc 06cb $LN238 079c ??_C@_0DE@NOAHFJIJ@f?3?2dd?2vctools?2crt_bld?2self_64_am@ 07ab _malloc_dbg 07e3 memset 0b54 wctomb_s 0b84 ??_C@_1FA@OAMCKJNL@?$AAw?$AAc?$AAt?$AAo?$AAm?$AAb?$AA_?$AAs?$AA?$CI?$AA?$CG?$AAt?$AAe?$AAm?$AAp?$AA?0?$AA?5?$AA?$CI?$AAc?$AAh?$AAa?$AAr?$AA?5?$AA?$CK?$AA?$CJ?$AAp?$AAo?$AAi?$AAn?$AAt?$AAe?$AAr?$AA?0@ 0b96 _invoke_watson_if_oneof 0e4b isxdigit 0e6d _hextodec 12ea __check_float_string 1319 _INTRN_LOCALE_CONV 1793 wcstombs_s 17c3 ??_C@_1IE@NKBCJFAM@?$AAw?$AAc?$AAs?$AAt?$AAo?$AAm?$AAb?$AAs?$AA_?$AAs?$AA?5?$AA?$CI?$AA0?$AA?0?$AA?5?$AAc?$AAf?$AAl?$AAo?$AAa?$AAt?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?0?$AA?5?$AAc?$AAf?$AAs@ 17e2 ?GetLocaleT@_LocaleUpdate@@QEAAPEAUlocaleinfo_struct@@XZ 1808 _cfltcvt_tab 1812 __imp_DecodePointer 1848 _free_dbg 19dc ??1_LocaleUpdate@@QEAA@XZ 19f3 __security_check_cookie 1a00 $LN197 1a04 $LN214 1a08 $LN212 1a0c $LN202 1a10 $LN213 1a14 $LN201 1a18 $LN198 1a1c $DEFAULT_LABEL$241 1a70 $LN179 1a74 $LN110 1a78 $LN53 1a84 $LN13 1a88 $LN129 1a9c $LN55 1aa4 $LN111 1ab0 $LN175 1ac4 $LN128 1ad0 $LN172"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 81 EC 48 04 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 30 04 00 00 48 8D 84 24 70 01 00 00 48 89 84 24 A0 00 00 00 48 C7 44 24 78 00 00 00 00 48 C7 84 24 D0 00 00 00 5E 01 00 00 C7 84 24 B4 00 00 00 00 00 00 00 48 C7 84 24 B8 00 00 00 00 00 00 00 C7 84 24 E4 00 00 00 00 00 00 00 48 C7 84 24 A8 00 00 00 00 00 00 00 33 C0 66 89 44 24 40 48 83 BC 24 50 04 00 00 00 74 0D C7 84 24 E0 00 00 00 01 00 00 00 EB 0B C7 84 24 E0 00 00 00 00 00 00 00 8B 84 24 E0 00 00 00 89 84 24 DC 00 00 00 83 BC 24 DC 00 00 00 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 B3 01 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 BC 24 DC 00 00 00 00 75 3E E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 B3 01 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 FF FF FF FF E9 A8 18 00 00 E8 ?? ?? ?? ?? 85 C0 7D 0A B8 FF FF FF FF E9 95 18 00 00 48 8B 94 24 58 04 00 00 48 8D 8C 24 50 01 00 00 E8 ?? ?? ?? ?? C6 44 24 60 00 0F BE 44 24 60 89 44 24 48 8B 44 24 48 89 84 24 B0 00 00 00 48 8B 84 24 50 04 00 00 0F B7 00 85 C0 0F 84 FA 17 00 00 66 BA 08 00 48 8B 84 24 50 04 00 00 0F B7 08 E8 ?? ?? ?? ?? 85 C0 74 5D 8B 44 24 48 FF C8 89 44 24 48 48 8D 4C 24 48 E8 ?? ?? ?? ?? 0F B7 C8 E8 ?? ?? ?? ?? 48 8B 84 24 50 04 00 00 48 83 C0 02 48 89 84 24 50 04 00 00 48 8B 84 24 50 04 00 00 0F B7 00 66 89 84 24 CC 00 00 00 66 BA 08 00 0F B7 8C 24 CC 00 00 00 E8 ?? ?? ?? ?? 85 C0 75 C4 E9 78 FF FF FF 48 8B 84 24 50 04 00 00 0F B7 00 83 F8 25 0F 85 CB 16 00 00 48 8B 84 24 50 04 00 00 0F B7 40 02 83 F8 25 0F 84 B6 16 00 00 C7 84 24 80 00 00 00 00 00 00 00 33 C0 66 89 44 24 64 C7 44 24 6C 00 00 00 00 8B 44 24 6C 89 44 24 70 8B 44 24 70 89 44 24 50 C6 44 24 68 00 0F B6 44 24 68 88 44 24 57 0F B6 44 24 57 88 44 24 54 0F B6 44 24 54 88 44 24 44 0F B6 44 24 44 88 44 24 56 C6 44 24 4C 00 C6 44 24 55 01 C7 84 24 84 00 00 00 00 00 00 00 0F BE 44 24 44 85 C0 0F 85 9B 02 00 00 48 8B 84 24 50 04 00 00 48 83 C0 02 48 89 84 24 50 04 00 00 48 8B 84 24 50 04 00 00 0F B7 00 89 44 24 5C 0F B7 44 24 5C 25 00 FF 00 00 85 C0 75 3B 0F B7 44 24 5C 25 FF 00 00 00 8B C8 E8 ?? ?? ?? ?? 85 C0 74 26 8B 44 24 70 FF C0 89 44 24 70 8B 44 24 50 8B 4C 24 50 8D 04 88 8B 4C 24 5C 8D 44 41 D0 89 44 24 50 E9 2A 02 00 00 8B 44 24 5C 89 84 24 C4 00 00 00 8B 84 24 C4 00 00 00 83 E8 2A 89 84 24 C4 00 00 00 83 BC 24 C4 00 00 00 4D 0F 87 F5 01 00 00 48 63 84 24 C4 00 00 00 48 8D 0D ?? ?? ?? ?? 0F B6 84 01 ?? ?? ?? ?? 8B 84 81 ?? ?? ?? ?? 48 03 C1 FF E0 E9 D8 01 00 00 0F B6 44 24 55 FE C8 88 44 24 55 0F B6 44 24 4C FE C8 88 44 24 4C E9 BD 01 00 00 48 8B 84 24 50 04 00 00 0F B7 40 02 83 F8 36 75 4B 48 8B 84 24 50 04 00 00 0F B7 40 04 83 F8 34 75 3A 48 8B 84 24 50 04 00 00 48 83 C0 04 48 89 84 24 50 04 00 00 8B 84 24 84 00 00 00 FF C0 89 84 24 84 00 00 00 48 C7 84 24 98 00 00 00 00 00 00 00 E9 66 01 00 00 E9 BA 00 00 00 48 8B 84 24 50 04 00 00 0F B7 40 02 83 F8 33 75 2C 48 8B 84 24 50 04 00 00 0F B7 40 04 83 F8 32 75 1B 48 8B 84 24 50 04 00 00 48 83 C0 04 48 89 84 24 50 04 00 00 E9 26 01 00 00 EB 7D 48 8B 84 24 50 04 00 00 0F B7 40 02 83 F8 64 74 44 48 8B 84 24 50 04 00 00 0F B7 40 02 83 F8 69 74 33 48 8B 84 24 50 04 00 00 0F B7 40 02 83 F8 6F 74 22 48 8B 84 24 50 04 00 00 0F B7 40 02 83 F8 78 74 11 48 8B 84 24 50 04 00 00 0F B7 40 02 83 F8 58 75 28 33 C0 83 F8 01 74 1C 8B 84 24 84 00 00 00 FF C0 89 84 24 84 00 00 00 48 C7 84 24 98 00 00 00 00 00 00 00 E9 A7 00 00 00 33 C0 83 F8 01 74 1C 8B 84 24 84 00 00 00 FF C0 89 84 24 84 00 00 00 48 C7 84 24 98 00 00 00 00 00 00 00 EB 77 0F B6 44 24 55 FE C0 88 44 24 55 EB 75 48 8B 84 24 50 04 00 00 0F B7 40 02 83 F8 6C 75 34 48 8B 84 24 50 04 00 00 48 83 C0 02 48 89 84 24 50 04 00 00 8B 84 24 84 00 00 00 FF C0 89 84 24 84 00 00 00 48 C7 84 24 98 00 00 00 00 00 00 00 EB 32 EB 0B 0F B6 44 24 55 FE C0 88 44 24 55 0F B6 44 24 4C FE C0 88 44 24 4C EB 18 0F B6 44 24 54 FE C0 88 44 24 54 EB 0B 0F B6 44 24 44 FE C0 88 44 24 44 E9 58 FD FF FF 0F BE 44 24 54 85 C0 75 7D 48 8B 84 24 60 04 00 00 48 89 84 24 40 01 00 00 33 C0 85 C0 74 2D 48 8B 84 24 60 04 00 00 48 83 C0 08 48 89 84 24 60 04 00 00 48 8B 84 24 60 04 00 00 48 8B 40 F8 48 8B 00 48 89 84 24 38 01 00 00 EB 28 48 8B 84 24 60 04 00 00 48 83 C0 08 48 89 84 24 60 04 00 00 48 8B 84 24 60 04 00 00 48 8B 40 F8 48 89 84 24 38 01 00 00 48 8B 84 24 38 01 00 00 48 89 84 24 A8 00 00 00 EB 0C 48 C7 84 24 A8 00 00 00 00 00 00 00 C6 44 24 44 00 0F BE 44 24 4C 85 C0 75 38 48 8B 84 24 50 04 00 00 0F B7 00 83 F8 53 74 10 48 8B 84 24 50 04 00 00 0F B7 00 83 F8 43 75 0D 0F B6 44 24 4C FE C8 88 44 24 4C EB 0B 0F B6 44 24 4C FE C0 88 44 24 4C 48 8B 84 24 50 04 00 00 0F B7 00 83 C8 20 89 44 24 5C 83 7C 24 5C 6E 74 33 83 7C 24 5C 63 74 18 83 7C 24 5C 7B 74 11 48 8D 4C 24 48 E8 ?? ?? ?? ?? 66 89 44 24 40 EB 14 8B 44 24 48 FF C0 89 44 24 48 E8 ?? ?? ?? ?? 66 89 44 24 40 83 7C 24 5C 6E 74 11 0F B7 44 24 40 3D FF FF 00 00 75 05 E9 10 13 00 00 83 7C 24 70 00 74 0B 83 7C 24 50 00 0F 84 26 12 00 00 8B 44 24 5C 89 84 24 C8 00 00 00 8B 84 24 C8 00 00 00 83 E8 63 89 84 24 C8 00 00 00 83 BC 24 C8 00 00 00 18 0F 87 9C 11 00 00 48 63 84 24 C8 00 00 00 48 8D 0D ?? ?? ?? ?? 8B 84 81 ?? ?? ?? ?? 48 03 C1 FF E0 83 7C 24 70 00 75 14 8B 44 24 70 FF C0 89 44 24 70 8B 44 24 50 FF C0 89 44 24 50 0F BE 44 24 4C 85 C0 7E 0B 0F B6 44 24 56 FE C0 88 44 24 56 E9 14 03 00 00 0F BE 44 24 4C 85 C0 7E 0B 0F B6 44 24 56 FE C0 88 44 24 56 E9 FB 02 00 00 0F BE 44 24 4C 85 C0 7E 0B 0F B6 44 24 56 FE C0 88 44 24 56 48 8B 84 24 50 04 00 00 48 83 C0 02 48 89 84 24 50 04 00 00 48 8B 84 24 50 04 00 00 48 89 84 24 90 00 00 00 48 8B 84 24 90 00 00 00 0F B7 00 83 F8 5E 75 1F 48 8B 84 24 90 00 00 00 48 83 C0 02 48 89 84 24 90 00 00 00 0F B6 44 24 68 FE C8 88 44 24 68 48 83 BC 24 B8 00 00 00 00 75 3F 41 B9 AC 02 00 00 4C 8D 05 ?? ?? ?? ?? BA 02 00 00 00 B9 00 20 00 00 E8 ?? ?? ?? ?? 48 89 84 24 B8 00 00 00 48 83 BC 24 B8 00 00 00 00 75 05 E9 C6 11 00 00 C7 84 24 E4 00 00 00 01 00 00 00 41 B8 00 20 00 00 33 D2 48 8B 8C 24 B8 00 00 00 E8 ?? ?? ?? ?? 83 7C 24 5C 7B 75 43 48 8B 84 24 90 00 00 00 0F B7 00 83 F8 5D 75 33 B8 5D 00 00 00 66 89 44 24 64 48 8B 84 24 90 00 00 00 48 83 C0 02 48 89 84 24 90 00 00 00 B8 01 00 00 00 48 6B C0 0B 48 8B 8C 24 B8 00 00 00 C6 04 01 20 48 8B 84 24 90 00 00 00 0F B7 00 83 F8 5D 0F 84 AC 01 00 00 48 8B 84 24 90 00 00 00 0F B7 00 66 89 44 24 58 48 8B 84 24 90 00 00 00 48 83 C0 02 48 89 84 24 90 00 00 00 0F B7 44 24 58 83 F8 2D 75 19 0F B7 44 24 64 85 C0 74 10 48 8B 84 24 90 00 00 00 0F B7 00 83 F8 5D 75 4E 0F B7 44 24 58 66 89 44 24 64 0F B7 44 24 64 C1 F8 03 48 98 0F B7 4C 24 58 83 E1 07 BA 01 00 00 00 D3 E2 8B CA 48 8B 94 24 B8 00 00 00 0F BE 04 02 0B C1 0F B7 4C 24 64 C1 F9 03 48 63 C9 48 8B 94 24 B8 00 00 00 88 04 0A E9 12 01 00 00 48 8B 84 24 90 00 00 00 0F B7 00 66 89 44 24 58 48 8B 84 24 90 00 00 00 48 83 C0 02 48 89 84 24 90 00 00 00 0F B7 44 24 64 0F B7 4C 24 58 3B C1 7D 0F 0F B7 44 24 58 66 89 84 24 88 00 00 00 EB 17 0F B7 44 24 64 66 89 84 24 88 00 00 00 0F B7 44 24 58 66 89 44 24 64 0F B7 44 24 64 66 89 44 24 58 EB 0D 0F B7 44 24 58 66 FF C0 66 89 44 24 58 0F B7 44 24 58 0F B7 8C 24 88 00 00 00 3B C1 7D 41 0F B7 44 24 58 C1 F8 03 48 98 0F B7 4C 24 58 83 E1 07 BA 01 00 00 00 D3 E2 8B CA 48 8B 94 24 B8 00 00 00 0F BE 04 02 0B C1 0F B7 4C 24 58 C1 F9 03 48 63 C9 48 8B 94 24 B8 00 00 00 88 04 0A EB A1 0F B7 84 24 88 00 00 00 C1 F8 03 48 98 0F B7 8C 24 88 00 00 00 83 E1 07 BA 01 00 00 00 D3 E2 8B CA 48 8B 94 24 B8 00 00 00 0F BE 04 02 0B C1 0F B7 8C 24 88 00 00 00 C1 F9 03 48 63 C9 48 8B 94 24 B8 00 00 00 88 04 0A 33 C0 66 89 44 24 64 E9 40 FE FF FF 48 8B 84 24 90 00 00 00 0F B7 00 85 C0 75 05 E9 88 0F 00 00 83 7C 24 5C 7B 75 10 48 8B 84 24 90 00 00 00 48 89 84 24 50 04 00 00 48 8B 84 24 A8 00 00 00 48 89 84 24 08 01 00 00 8B 44 24 48 FF C8 89 44 24 48 0F B7 4C 24 40 E8 ?? ?? ?? ?? 83 7C 24 70 00 74 23 8B 44 24 50 89 84 24 F0 00 00 00 8B 44 24 50 FF C8 89 44 24 50 83 BC 24 F0 00 00 00 00 0F 84 85 01 00 00 8B 44 24 48 FF C0 89 44 24 48 E8 ?? ?? ?? ?? 66 89 44 24 40 83 7C 24 5C 63 74 68 83 7C 24 5C 73 75 1E 0F B7 44 24 40 83 F8 09 7C 0A 0F B7 44 24 40 83 F8 0D 7E 0A 0F B7 44 24 40 83 F8 20 75 43 83 7C 24 5C 7B 0F 85 1F 01 00 00 0F B7 44 24 40 C1 F8 03 48 98 48 8B 8C 24 B8 00 00 00 0F BE 04 01 0F BE 4C 24 68 33 C1 0F B7 4C 24 40 83 E1 07 BA 01 00 00 00 D3 E2 8B CA 23 C1 85 C0 0F 84 E7 00 00 00 0F BE 44 24 54 85 C0 0F 85 C4 00 00 00 0F BE 44 24 56 85 C0 74 29 48 8B 84 24 A8 00 00 00 0F B7 4C 24 40 66 89 08 48 8B 84 24 A8 00 00 00 48 83 C0 02 48 89 84 24 A8 00 00 00 E9 90 00 00 00 C7 84 24 D8 00 00 00 00 00 00 00 44 0F B7 4C 24 40 41 B8 05 00 00 00 48 8B 94 24 A8 00 00 00 48 8D 8C 24 D8 00 00 00 E8 ?? ?? ?? ?? 48 C7 44 24 38 00 00 00 00 C7 44 24 30 48 03 00 00 48 8D 0D ?? ?? ?? ?? 48 89 4C 24 28 48 8D 0D ?? ?? ?? ?? 48 89 4C 24 20 4C 8D 0D ?? ?? ?? ?? 41 B8 22 00 00 00 BA 16 00 00 00 8B C8 E8 ?? ?? ?? ?? 85 C0 75 1E 48 63 84 24 D8 00 00 00 48 8B 8C 24 A8 00 00 00 48 03 C8 48 8B C1 48 89 84 24 A8 00 00 00 EB 14 48 8B 84 24 08 01 00 00 48 83 C0 02 48 89 84 24 08 01 00 00 EB 16 8B 44 24 48 FF C8 89 44 24 48 0F B7 4C 24 40 E8 ?? ?? ?? ?? EB 05 E9 51 FE FF FF 48 8B 84 24 A8 00 00 00 48 39 84 24 08 01 00 00 74 45 0F BE 44 24 54 85 C0 75 3A 8B 84 24 B0 00 00 00 FF C0 89 84 24 B0 00 00 00 83 7C 24 5C 63 74 23 0F BE 44 24 56 85 C0 74 0F 33 C0 48 8B 8C 24 A8 00 00 00 66 89 01 EB 0B 48 8B 84 24 A8 00 00 00 C6 00 00 EB 05 E9 42 0D 00 00 E9 58 0C 00 00 C7 44 24 5C 64 00 00 00 0F B7 44 24 40 83 F8 2D 75 0F 0F B6 44 24 57 FE C0 88 44 24 57 EB 0C EB 43 0F B7 44 24 40 83 F8 2B 75 39 8B 44 24 50 FF C8 89 44 24 50 83 7C 24 50 00 75 14 83 7C 24 70 00 74 0D 0F B6 44 24 44 FE C0 88 44 24 44 EB 14 8B 44 24 48 FF C0 89 44 24 48 E8 ?? ?? ?? ?? 66 89 44 24 40 0F B7 44 24 40 83 F8 30 0F 85 C6 00 00 00 8B 44 24 48 FF C0 89 44 24 48 E8 ?? ?? ?? ?? 66 89 44 24 40 0F B7 44 24 40 83 F8 78 74 0A 0F B7 44 24 40 83 F8 58 75 42 8B 44 24 48 FF C0 89 44 24 48 E8 ?? ?? ?? ?? 66 89 44 24 40 83 7C 24 70 00 74 1D 8B 44 24 50 83 E8 02 89 44 24 50 83 7C 24 50 01 7D 0B 0F B6 44 24 44 FE C0 88 44 24 44 C7 44 24 5C 78 00 00 00 EB 5C 8B 44 24 6C FF C0 89 44 24 6C 83 7C 24 5C 78 74 2D 83 7C 24 70 00 74 1C 8B 44 24 50 FF C8 89 44 24 50 83 7C 24 50 00 75 0B 0F B6 44 24 44 FE C0 88 44 24 44 C7 44 24 5C 6F 00 00 00 EB 1E 8B 44 24 48 FF C8 89 44 24 48 0F B7 4C 24 40 E8 ?? ?? ?? ?? B8 30 00 00 00 66 89 44 24 40 EB 7D C6 44 24 55 01 8B 84 24 84 00 00 00 FF C0 89 84 24 84 00 00 00 48 C7 84 24 98 00 00 00 00 00 00 00 0F B7 44 24 40 83 F8 2D 75 0F 0F B6 44 24 57 FE C0 88 44 24 57 EB 0C EB 43 0F B7 44 24 40 83 F8 2B 75 39 8B 44 24 50 FF C8 89 44 24 50 83 7C 24 50 00 75 14 83 7C 24 70 00 74 0D 0F B6 44 24 44 FE C0 88 44 24 44 EB 14 8B 44 24 48 FF C0 89 44 24 48 E8 ?? ?? ?? ?? 66 89 44 24 40 83 BC 24 84 00 00 00 00 0F 84 9E 01 00 00 0F BE 44 24 44 85 C0 0F 85 70 01 00 00 83 7C 24 5C 78 74 07 83 7C 24 5C 70 75 58 0F B7 44 24 40 25 00 FF 00 00 85 C0 75 3A 0F B7 44 24 40 25 FF 00 00 00 8B C8 E8 ?? ?? ?? ?? 85 C0 74 25 48 8B 84 24 98 00 00 00 48 C1 E0 04 48 89 84 24 98 00 00 00 0F B7 4C 24 40 E8 ?? ?? ?? ?? 66 89 44 24 40 EB 0B 0F B6 44 24 44 FE C0 88 44 24 44 E9 83 00 00 00 0F B7 44 24 40 25 00 FF 00 00 85 C0 75 6A 0F B7 44 24 40 25 FF 00 00 00 8B C8 E8 ?? ?? ?? ?? 85 C0 74 55 83 7C 24 5C 6F 75 2D 0F B7 44 24 40 83 F8 38 7D 16 48 8B 84 24 98 00 00 00 48 C1 E0 03 48 89 84 24 98 00 00 00 EB 0B 0F B6 44 24 44 FE C0 88 44 24 44 EB 1F 48 8B 84 24 98 00 00 00 48 8B 8C 24 98 00 00 00 48 8D 04 88 48 D1 E0 48 89 84 24 98 00 00 00 EB 0B 0F B6 44 24 44 FE C0 88 44 24 44 0F BE 44 24 44 85 C0 75 65 8B 44 24 6C FF C0 89 44 24 6C 0F B7 44 24 40 83 E8 30 48 98 48 8B 8C 24 98 00 00 00 48 03 C8 48 8B C1 48 89 84 24 98 00 00 00 83 7C 24 70 00 74 1E 8B 44 24 50 FF C8 89 44 24 50 83 7C 24 50 00 75 0D 0F B6 44 24 44 FE C0 88 44 24 44 EB 14 8B 44 24 48 FF C0 89 44 24 48 E8 ?? ?? ?? ?? 66 89 44 24 40 EB 14 8B 44 24 48 FF C8 89 44 24 48 0F B7 4C 24 40 E8 ?? ?? ?? ?? E9 83 FE FF FF 0F BE 44 24 57 85 C0 74 13 48 8B 84 24 98 00 00 00 48 F7 D8 48 89 84 24 98 00 00 00 E9 7F 01 00 00 0F BE 44 24 44 85 C0 0F 85 59 01 00 00 83 7C 24 5C 78 74 07 83 7C 24 5C 70 75 52 0F B7 44 24 40 25 00 FF 00 00 85 C0 75 37 0F B7 44 24 40 25 FF 00 00 00 8B C8 E8 ?? ?? ?? ?? 85 C0 74 22 8B 84 24 80 00 00 00 C1 E0 04 89 84 24 80 00 }
	condition:
		$1
}

rule file_76_8_0 {
	meta:
		name = "_hextodec"
		size = 80
		refs = "0024 isdigit"
	strings:
		$1 = { 66 89 4C 24 08 48 83 EC 38 0F B7 44 24 40 25 00 FF 00 00 85 C0 75 20 0F B7 44 24 40 25 FF 00 00 00 8B C8 E8 ?? ?? ?? ?? 85 C0 74 0B 0F B7 44 24 40 89 44 24 20 EB 0F 0F B7 44 24 40 83 E0 DF 83 E8 07 89 44 24 20 0F B7 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_76_11_0 {
	meta:
		name = "_un_inc"
		size = 36
		refs = "001b _ungetwch_nolock"
	strings:
		$1 = { 66 89 4C 24 08 48 83 EC 28 0F B7 44 24 30 3D FF FF 00 00 74 0A 0F B7 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_76_12_0 {
	meta:
		name = "_whiteout"
		size = 77
		refs = "001a _inc 003b iswctype"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 8B 00 FF C0 48 8B 4C 24 40 89 01 E8 ?? ?? ?? ?? 66 89 44 24 20 0F B7 44 24 20 3D FF FF 00 00 75 02 EB 12 66 BA 08 00 0F B7 4C 24 20 E8 ?? ?? ?? ?? 85 C0 75 C6 0F B7 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_77_0_0 {
	meta:
		name = "realloc"
		size = 61
		refs = "002a _realloc_dbg"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 C7 44 24 20 00 00 00 00 45 33 C9 41 B8 01 00 00 00 48 8B 54 24 58 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 89 44 24 30 48 8B 44 24 30 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_1146_53_0 {
	meta:
		name = "_expand"
		size = 61
		refs = "002a _expand_dbg"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 C7 44 24 20 00 00 00 00 45 33 C9 41 B8 01 00 00 00 48 8B 54 24 58 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 89 44 24 30 48 8B 44 24 30 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_1115_0_0 {
	meta:
		name = "calloc"
		size = 61
		refs = "002a _calloc_dbg"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 C7 44 24 20 00 00 00 00 45 33 C9 41 B8 01 00 00 00 48 8B 54 24 58 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 89 44 24 30 48 8B 44 24 30 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_78_0_0 {
	meta:
		name = "IsRootUNCName"
		size = 391
		refs = "000f wcslen"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 F8 05 0F 82 63 01 00 00 B8 02 00 00 00 48 6B C0 00 48 8B 4C 24 40 0F B7 04 01 83 F8 5C 74 1B B8 02 00 00 00 48 6B C0 00 48 8B 4C 24 40 0F B7 04 01 83 F8 2F 0F 85 31 01 00 00 B8 02 00 00 00 48 6B C0 01 48 8B 4C 24 40 0F B7 04 01 83 F8 5C 74 1B B8 02 00 00 00 48 6B C0 01 48 8B 4C 24 40 0F B7 04 01 83 F8 2F 0F 85 FF 00 00 00 B8 02 00 00 00 48 6B C0 02 48 8B 4C 24 40 0F B7 04 01 83 F8 5C 0F 84 E4 00 00 00 B8 02 00 00 00 48 6B C0 02 48 8B 4C 24 40 0F B7 04 01 83 F8 2F 0F 84 C9 00 00 00 48 8B 44 24 40 48 83 C0 04 48 89 44 24 20 48 8B 44 24 20 48 83 C0 02 48 89 44 24 20 48 8B 44 24 20 0F B7 00 85 C0 74 1E 48 8B 44 24 20 0F B7 00 83 F8 5C 74 0D 48 8B 44 24 20 0F B7 00 83 F8 2F 75 02 EB 02 EB C8 48 8B 44 24 20 0F B7 00 85 C0 74 77 B8 02 00 00 00 48 6B C0 01 48 8B 4C 24 20 0F B7 04 01 85 C0 74 61 48 8B 44 24 20 48 83 C0 02 48 89 44 24 20 48 8B 44 24 20 0F B7 00 85 C0 74 1E 48 8B 44 24 20 0F B7 00 83 F8 5C 74 0D 48 8B 44 24 20 0F B7 00 83 F8 2F 75 02 EB 02 EB C8 48 8B 44 24 20 0F B7 00 85 C0 74 16 B8 02 00 00 00 48 6B C0 01 48 8B 4C 24 20 0F B7 04 01 85 C0 75 07 B8 01 00 00 00 EB 02 33 C0 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_78_1_0 {
	meta:
		name = "_wfullpath_helper"
		size = 158
		refs = "0019 _errno 003e _wfullpath"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 E8 ?? ?? ?? ?? 8B 00 89 44 24 20 E8 ?? ?? ?? ?? C7 00 00 00 00 00 4C 8B 44 24 50 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 89 44 24 28 48 83 7C 24 28 00 74 12 E8 ?? ?? ?? ?? 8B 4C 24 20 89 08 48 8B 44 24 28 EB 38 E8 ?? ?? ?? ?? 83 38 22 74 04 33 C0 EB 2A E8 ?? ?? ?? ?? 8B 4C 24 20 89 08 45 33 C0 48 8B 54 24 48 33 C9 E8 ?? ?? ?? ?? 48 8B 4C 24 58 48 89 01 48 8B 44 24 58 48 8B 00 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_78_2_0 {
	meta:
		name = "_wstat64i32"
		size = 2194
		refs = "0014 __security_cookie 005a ??_C@_1BO@PCMLKEJK@?$AA?$CI?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0066 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 007b ??_C@_1GK@DIOGEODK@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 0085 _CrtDbgReportW 0099 __doserrno 00a4 _errno 00c7 ??_C@_1BI@CDEGEEHA@?$AA_?$AAw?$AAs?$AAt?$AAa?$AAt?$AA6?$AA4?$AAi?$AA3?$AA2?$AA?$AA@ 00d3 _invalid_parameter 0110 ??_C@_1BM@KFJLMBPG@?$AA?$CI?$AAb?$AAu?$AAf?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 019a ??_C@_15HEJOKEHO@?$AA?$DP?$AA?$CK?$AA?$AA@ 01a7 wcspbrk 023e towlower 024f _getdrive 027f __imp_FindFirstFileExW 02a0 ??_C@_17BAAFHAL@?$AA?4?$AA?1?$AA?2?$AA?$AA@ 02d2 _wfullpath_helper 02f2 wcslen 0305 IsRootUNCName 0317 __imp_GetDriveTypeW 032e free 03c4 __loctotime64_t 0479 _wsopen_s 04c2 _fstat64i32 04cf _close 04da __imp_FindClose 0513 __imp_FileTimeToLocalFileTime 052a __imp_FileTimeToSystemTime 0534 __imp_GetLastError 053b _dosmaperr 07c6 __wdtoxmode 0886 __security_check_cookie"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 81 EC 28 05 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 10 05 00 00 C7 44 24 40 00 00 00 00 48 83 BC 24 30 05 00 00 00 74 0A C7 44 24 60 01 00 00 00 EB 08 C7 44 24 60 00 00 00 00 8B 44 24 60 89 44 24 70 83 7C 24 70 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 7C 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 70 00 75 49 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 7C 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 FF FF FF FF E9 99 07 00 00 48 83 BC 24 38 05 00 00 00 74 0A C7 44 24 74 01 00 00 00 EB 08 C7 44 24 74 00 00 00 00 8B 44 24 74 89 44 24 58 83 7C 24 58 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 7D 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 58 00 75 49 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 7D 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 FF FF FF FF E9 E3 06 00 00 48 8D 15 ?? ?? ?? ?? 48 8B 8C 24 30 05 00 00 E8 ?? ?? ?? ?? 48 85 C0 74 20 E8 ?? ?? ?? ?? C7 00 02 00 00 00 E8 ?? ?? ?? ?? C7 00 02 00 00 00 B8 FF FF FF FF E9 AA 06 00 00 B8 02 00 00 00 48 6B C0 01 48 8B 8C 24 30 05 00 00 0F B7 04 01 83 F8 3A 75 64 48 8B 84 24 30 05 00 00 0F B7 00 85 C0 74 39 B8 02 00 00 00 48 6B C0 02 48 8B 8C 24 30 05 00 00 0F B7 04 01 85 C0 75 20 E8 ?? ?? ?? ?? C7 00 02 00 00 00 E8 ?? ?? ?? ?? C7 00 02 00 00 00 B8 FF FF FF FF E9 48 06 00 00 48 8B 84 24 30 05 00 00 0F B7 08 E8 ?? ?? ?? ?? 0F B7 C0 83 E8 60 89 44 24 64 EB 09 E8 ?? ?? ?? ?? 89 44 24 64 C7 44 24 28 00 00 00 00 48 C7 44 24 20 00 00 00 00 45 33 C9 4C 8D 84 24 B0 00 00 00 33 D2 48 8B 8C 24 30 05 00 00 FF 15 ?? ?? ?? ?? 48 89 44 24 50 48 83 7C 24 50 FF 0F 85 75 01 00 00 48 C7 44 24 78 00 00 00 00 48 8D 15 ?? ?? ?? ?? 48 8B 8C 24 30 05 00 00 E8 ?? ?? ?? ?? 48 85 C0 74 6A 4C 8D 4C 24 78 41 B8 04 01 00 00 48 8B 94 24 30 05 00 00 48 8D 8C 24 00 03 00 00 E8 ?? ?? ?? ?? 48 89 84 24 80 00 00 00 48 83 BC 24 80 00 00 00 00 74 37 48 8B 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 48 83 F8 03 74 11 48 8B 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 85 C0 74 13 48 8B 8C 24 80 00 00 00 FF 15 ?? ?? ?? ?? 83 F8 01 77 32 48 83 7C 24 78 00 74 0A 48 8B 4C 24 78 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 00 02 00 00 00 E8 ?? ?? ?? ?? C7 00 02 00 00 00 B8 FF FF FF FF E9 28 05 00 00 48 83 7C 24 78 00 74 0A 48 8B 4C 24 78 E8 ?? ?? ?? ?? C7 84 24 B0 00 00 00 10 00 00 00 C7 84 24 CC 00 00 00 00 00 00 00 C7 84 24 D0 00 00 00 00 00 00 00 B8 02 00 00 00 48 6B C0 00 33 C9 66 89 8C 04 DC 00 00 00 C7 44 24 30 FF FF FF FF C7 44 24 28 00 00 00 00 C7 44 24 20 00 00 00 00 45 33 C9 41 B8 01 00 00 00 BA 01 00 00 00 B9 BC 07 00 00 E8 ?? ?? ?? ?? 48 8B 8C 24 38 05 00 00 48 89 41 20 48 8B 84 24 38 05 00 00 48 8B 8C 24 38 05 00 00 48 8B 49 20 48 89 48 18 48 8B 84 24 38 05 00 00 48 8B 8C 24 38 05 00 00 48 8B 49 20 48 89 48 28 E9 AD 03 00 00 8B 84 24 B0 00 00 00 25 00 04 00 00 85 C0 0F 84 CF 00 00 00 81 BC 24 D4 00 00 00 0C 00 00 A0 0F 85 BE 00 00 00 C7 44 24 44 FF FF FF FF C7 44 24 48 00 00 00 00 8B 84 24 B0 00 00 00 83 E0 10 85 C0 74 0C 8B 44 24 48 0F BA E8 0D 89 44 24 48 C7 44 24 20 00 00 00 00 41 B9 40 00 00 00 44 8B 44 24 48 48 8B 94 24 30 05 00 00 48 8D 4C 24 44 E8 ?? ?? ?? ?? 89 84 24 88 00 00 00 83 BC 24 88 00 00 00 00 75 07 83 7C 24 44 FF 75 20 E8 ?? ?? ?? ?? C7 00 02 00 00 00 E8 ?? ?? ?? ?? C7 00 02 00 00 00 B8 FF FF FF FF E9 C5 03 00 00 48 8B 94 24 38 05 00 00 8B 4C 24 44 E8 ?? ?? ?? ?? 89 44 24 40 8B 4C 24 44 E8 ?? ?? ?? ?? 48 8B 4C 24 50 FF 15 ?? ?? ?? ?? 8B 44 24 40 E9 93 03 00 00 E9 CA 02 00 00 83 BC 24 C4 00 00 00 00 75 0E 83 BC 24 C8 00 00 00 00 0F 84 BD 00 00 00 48 8D 54 24 68 48 8D 8C 24 C4 00 00 00 FF 15 ?? ?? ?? ?? 85 C0 74 17 48 8D 94 24 98 00 00 00 48 8D 4C 24 68 FF 15 ?? ?? ?? ?? 85 C0 75 22 FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 48 8B 4C 24 50 FF 15 ?? ?? ?? ?? B8 FF FF FF FF E9 26 03 00 00 0F B7 84 24 A4 00 00 00 0F B7 8C 24 A2 00 00 00 0F B7 94 24 A0 00 00 00 44 0F B7 84 24 9E 00 00 00 44 0F B7 8C 24 9A 00 00 00 44 89 8C 24 8C 00 00 00 44 0F B7 94 24 98 00 00 00 C7 44 24 30 FF FF FF FF 89 44 24 28 89 4C 24 20 44 8B CA 8B 84 24 8C 00 00 00 8B D0 41 8B CA E8 ?? ?? ?? ?? 48 8B 8C 24 38 05 00 00 48 89 41 20 EB 10 48 8B 84 24 38 05 00 00 48 C7 40 20 00 00 00 00 83 BC 24 BC 00 00 00 00 75 0E 83 BC 24 C0 00 00 00 00 0F 84 BD 00 00 00 48 8D 54 24 68 48 8D 8C 24 BC 00 00 00 FF 15 ?? ?? ?? ?? 85 C0 74 17 48 8D 94 24 98 00 00 00 48 8D 4C 24 68 FF 15 ?? ?? ?? ?? 85 C0 75 22 FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 48 8B 4C 24 50 FF 15 ?? ?? ?? ?? B8 FF FF FF FF E9 41 02 00 00 0F B7 84 24 A4 00 00 00 0F B7 8C 24 A2 00 00 00 0F B7 94 24 A0 00 00 00 44 0F B7 84 24 9E 00 00 00 44 0F B7 8C 24 9A 00 00 00 44 89 8C 24 94 00 00 00 44 0F B7 94 24 98 00 00 00 C7 44 24 30 FF FF FF FF 89 44 24 28 89 4C 24 20 44 8B CA 8B 84 24 94 00 00 00 8B D0 41 8B CA E8 ?? ?? ?? ?? 48 8B 8C 24 38 05 00 00 48 89 41 18 EB 18 48 8B 84 24 38 05 00 00 48 8B 8C 24 38 05 00 00 48 8B 49 20 48 89 48 18 83 BC 24 B4 00 00 00 00 75 0E 83 BC 24 B8 00 00 00 00 0F 84 BD 00 00 00 48 8D 54 24 68 48 8D 8C 24 B4 00 00 00 FF 15 ?? ?? ?? ?? 85 C0 74 17 48 8D 94 24 98 00 00 00 48 8D 4C 24 68 FF 15 ?? ?? ?? ?? 85 C0 75 22 FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 48 8B 4C 24 50 FF 15 ?? ?? ?? ?? B8 FF FF FF FF E9 54 01 00 00 0F B7 84 24 A4 00 00 00 0F B7 8C 24 A2 00 00 00 0F B7 94 24 A0 00 00 00 44 0F B7 84 24 9E 00 00 00 44 0F B7 8C 24 9A 00 00 00 44 89 8C 24 90 00 00 00 44 0F B7 94 24 98 00 00 00 C7 44 24 30 FF FF FF FF 89 44 24 28 89 4C 24 20 44 8B CA 8B 84 24 90 00 00 00 8B D0 41 8B CA E8 ?? ?? ?? ?? 48 8B 8C 24 38 05 00 00 48 89 41 28 EB 18 48 8B 84 24 38 05 00 00 48 8B 8C 24 38 05 00 00 48 8B 49 20 48 89 48 28 48 8B 4C 24 50 FF 15 ?? ?? ?? ?? 48 8B 94 24 30 05 00 00 8B 8C 24 B0 00 00 00 E8 ?? ?? ?? ?? 48 8B 8C 24 38 05 00 00 66 89 41 06 B8 01 00 00 00 48 8B 8C 24 38 05 00 00 66 89 41 08 48 8B 84 24 38 05 00 00 8B 8C 24 D0 00 00 00 89 48 14 83 BC 24 CC 00 00 00 00 74 22 E8 ?? ?? ?? ?? C7 00 84 00 00 00 48 8B 84 24 38 05 00 00 C7 40 14 00 00 00 00 C7 44 24 40 FF FF FF FF 33 C0 48 8B 8C 24 38 05 00 00 66 89 41 04 33 C0 48 8B 8C 24 38 05 00 00 66 89 41 0C 33 C0 48 8B 8C 24 38 05 00 00 66 89 41 0A 8B 44 24 64 FF C8 89 44 24 5C 48 8B 84 24 38 05 00 00 8B 4C 24 5C 89 08 48 8B 84 24 38 05 00 00 8B 4C 24 5C 89 48 10 8B 44 24 40 48 8B 8C 24 10 05 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 28 05 00 00 C3 }
	condition:
		$1
}

rule file_79_0_0 {
	meta:
		name = "__wtomb_environ"
		size = 342
		refs = "0010 _wenviron 005f __imp_WideCharToMultiByte 0088 ??_C@_0DH@KAIEDBJJ@f?3?2dd?2vctools?2crt_bld?2self_64_am@ 009b _calloc_dbg 0101 _free_dbg 0114 __crtsetenv"
	strings:
		$1 = { 48 83 EC 68 48 C7 44 24 48 00 00 00 00 48 8B 05 ?? ?? ?? ?? 48 89 44 24 50 48 8B 44 24 50 48 83 38 00 0F 84 27 01 00 00 48 C7 44 24 38 00 00 00 00 48 C7 44 24 30 00 00 00 00 C7 44 24 28 00 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 FF FF FF FF 48 8B 44 24 50 4C 8B 00 33 D2 33 C9 FF 15 ?? ?? ?? ?? 89 44 24 40 83 7C 24 40 00 75 0A B8 FF FF FF FF E9 D9 00 00 00 48 63 44 24 40 C7 44 24 20 3D 00 00 00 4C 8D 0D ?? ?? ?? ?? 41 B8 02 00 00 00 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 48 89 44 24 48 48 83 7C 24 48 00 75 0A B8 FF FF FF FF E9 9B 00 00 00 48 C7 44 24 38 00 00 00 00 48 C7 44 24 30 00 00 00 00 8B 44 24 40 89 44 24 28 48 8B 44 24 48 48 89 44 24 20 41 B9 FF FF FF FF 48 8B 44 24 50 4C 8B 00 33 D2 33 C9 FF 15 ?? ?? ?? ?? 85 C0 75 16 BA 02 00 00 00 48 8B 4C 24 48 E8 ?? ?? ?? ?? B8 FF FF FF FF EB 45 33 D2 48 8D 4C 24 48 E8 ?? ?? ?? ?? 85 C0 7D 20 48 83 7C 24 48 00 74 18 BA 02 00 00 00 48 8B 4C 24 48 E8 ?? ?? ?? ?? 48 C7 44 24 48 00 00 00 00 48 8B 44 24 50 48 83 C0 08 48 89 44 24 50 E9 CA FE FF FF 33 C0 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_81_0_0 {
	meta:
		name = "_calloc_base"
		size = 93
		refs = "0026 _calloc_impl 003f _errno"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 C7 44 24 20 00 00 00 00 4C 8D 44 24 20 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 89 44 24 28 48 83 7C 24 28 00 75 1C 83 7C 24 20 00 74 15 E8 ?? ?? ?? ?? 48 85 C0 74 0B E8 ?? ?? ?? ?? 8B 4C 24 20 89 08 48 8B 44 24 28 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_82_1_0 {
	meta:
		name = "_mbsninc_l"
		size = 69
		refs = "002f _mbsnbcnt_l"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 83 7C 24 30 00 75 04 33 C0 EB 21 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B C0 48 8B 4C 24 30 48 03 C8 48 8B C1 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_83_0_0 {
	meta:
		name = "__sse4_tan2"
		size = 3120
		refs = "0023 MMDPI1 002b MMDPI2 0033 MMIABSMASK 003b MMDINVPI2 0047 MMDRSHIFT 0055 MMDPI3 0069 MMDHUGE 007d MMDPI4 00b8 MMDP3 00c0 MMDQ3 00cc MMDP2 00d8 MMDQ2 00e4 MMDP1 00f0 MMDQ1 00fc MMDP0 0108 MMDQ0 0164 MMISIGNMASK 018c TWO_POW_30 01a1 flAllOnes 021a THE_PI04_INV 022f MMI_ONE 0237 MSK_LOW_BIT 023f RS 0253 PI04C_0 025f PI04C_1 026f PI04C_2 02a0 PI04C_3 02cc PI04C_4 06c6 __spec_table"
	strings:
		$1 = { 48 81 EC 18 01 00 00 0F 29 BC 24 F0 00 00 00 0F 29 B4 24 00 01 00 00 66 0F 28 F8 66 0F 28 D0 66 0F 28 25 ?? ?? ?? ?? 66 0F 28 2D ?? ?? ?? ?? 66 0F 54 3D ?? ?? ?? ?? 66 0F 59 05 ?? ?? ?? ?? 66 0F 28 D8 66 0F 58 1D ?? ?? ?? ?? 66 0F 3A 09 C0 00 66 0F 28 35 ?? ?? ?? ?? 66 0F 59 E0 66 0F 59 E8 66 0F 59 F0 66 0F 66 3D ?? ?? ?? ?? 66 0F 50 C7 0B C0 0F 85 DF 00 00 00 66 0F 28 3D ?? ?? ?? ?? 66 0F 59 F8 66 0F 28 C3 66 0F 73 F3 3E 66 0F 5C D4 66 0F 5C D5 66 0F 5C D6 66 0F 57 C9 66 0F C2 D9 04 66 0F 73 F0 3F 66 0F 28 CA 66 0F 59 D2 66 0F 5C CF 66 0F 28 25 ?? ?? ?? ?? 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 E2 66 0F 58 25 ?? ?? ?? ?? 66 0F 59 EA 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 E2 66 0F 58 25 ?? ?? ?? ?? 66 0F 59 EA 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 E2 66 0F 58 25 ?? ?? ?? ?? 66 0F 59 EA 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 E1 66 0F 28 CB 66 0F 54 CC 66 0F 28 D3 66 0F 55 D5 66 0F 56 CA 66 0F 28 F3 66 0F 55 F4 66 0F 28 FB 66 0F 54 FD 66 0F 56 F7 66 0F 5E F1 66 0F 57 C6 0F 28 B4 24 00 01 00 00 0F 28 BC 24 F0 00 00 00 48 81 C4 18 01 00 00 C3 C7 44 24 20 00 00 00 00 66 0F 28 0D ?? ?? ?? ?? 66 0F DB CA 66 0F 29 54 24 70 66 0F 70 FF F5 66 0F DB 15 ?? ?? ?? ?? 66 0F 29 8C 24 80 00 00 00 66 0F 28 0D ?? ?? ?? ?? 66 0F 66 CA 66 0F 29 BC 24 90 00 00 00 66 0F 57 3D ?? ?? ?? ?? 66 0F 50 D1 66 0F 29 94 24 A0 00 00 00 66 0F 29 BC 24 B0 00 00 00 66 0F 28 3D ?? ?? ?? ?? 83 F2 03 0F 85 81 03 00 00 83 F8 03 74 45 66 0F 59 F8 66 0F 5C D4 66 0F 5C D5 66 0F 5C D6 66 0F 57 C9 66 0F 5C D7 66 0F 54 9C 24 B0 00 00 00 66 0F 54 94 24 B0 00 00 00 66 0F 29 9C 24 C0 00 00 00 66 0F 29 94 24 D0 00 00 00 66 0F 28 94 24 A0 00 00 00 66 0F 28 1D ?? ?? ?? ?? 66 0F 59 DA 66 0F E6 DB 66 0F 70 DB 10 66 0F FE 1D ?? ?? ?? ?? 66 0F DB 1D ?? ?? ?? ?? 66 0F 28 05 ?? ?? ?? ?? 66 0F 56 C3 66 0F 5C 05 ?? ?? ?? ?? 66 0F 28 0D ?? ?? ?? ?? 66 0F 59 C8 66 0F 28 25 ?? ?? ?? ?? 66 0F 59 E0 66 0F 5C D1 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 E8 66 0F 28 CA 66 0F 5C D4 66 0F 5C CA 66 0F 28 F2 66 0F 5C CC 66 0F 5C D5 66 0F 72 E3 01 66 0F 5C F2 66 0F 28 FA 66 0F 28 25 ?? ?? ?? ?? 66 0F 5C F5 66 0F 58 CE 66 0F 58 D1 66 0F 59 E0 66 0F 5C FA 66 0F 28 EA 66 0F 5C D4 66 0F 58 CF 66 0F 5C EA 66 0F 59 05 ?? ?? ?? ?? 66 0F 5C EC 66 0F 58 CD 66 0F 5C C8 66 0F 58 D1 66 0F 28 25 ?? ?? ?? ?? 66 0F 28 2D ?? ?? ?? ?? 66 0F 28 F2 66 0F 59 D2 83 F8 03 74 24 66 0F 54 9C 24 90 00 00 00 66 0F 54 8C 24 90 00 00 00 66 0F 56 9C 24 C0 00 00 00 66 0F 56 8C 24 D0 00 00 00 66 0F 28 C3 66 0F 73 F3 3E 66 0F 73 F0 3F 66 0F 59 E2 66 0F 59 EA 66 0F 58 25 ?? ?? ?? ?? 66 0F 58 2D ?? ?? ?? ?? 66 0F EF 84 24 80 00 00 00 66 0F 59 E2 66 0F 59 EA 66 0F EF C9 66 0F 58 25 ?? ?? ?? ?? 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 E2 66 0F 59 EA 66 0F C2 D9 04 66 0F 58 25 ?? ?? ?? ?? 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 E6 66 0F 28 CB 66 0F 54 CC 66 0F 28 D3 66 0F 55 D5 66 0F 56 CA 66 0F 28 F3 66 0F 55 F4 66 0F 28 FB 66 0F 54 FD 66 0F 56 F7 66 0F 5E F1 66 0F 57 C6 E9 E4 02 00 00 66 0F 28 1D ?? ?? ?? ?? 66 0F 59 DA 66 0F E6 DB 66 0F 70 DB 10 66 0F FE 1D ?? ?? ?? ?? 66 0F DB 1D ?? ?? ?? ?? 66 0F 28 05 ?? ?? ?? ?? 66 0F 56 C3 66 0F 5C 05 ?? ?? ?? ?? 66 0F 28 0D ?? ?? ?? ?? 66 0F 59 C8 66 0F 28 25 ?? ?? ?? ?? 66 0F 59 E0 66 0F 5C D1 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 E8 66 0F 28 CA 66 0F 5C D4 66 0F 5C CA 66 0F 28 F2 66 0F 5C CC 66 0F 5C D5 66 0F 72 E3 01 66 0F 5C F2 66 0F 28 FA 66 0F 28 25 ?? ?? ?? ?? 66 0F 5C F5 66 0F 58 CE 66 0F 58 D1 66 0F 59 E0 66 0F 5C FA 66 0F 28 EA 66 0F 5C D4 66 0F 58 CF 66 0F 5C EA 66 0F 59 05 ?? ?? ?? ?? 66 0F 5C EC 66 0F 58 CD 66 0F 5C C8 66 0F 58 D1 66 0F 28 C3 66 0F 73 F0 3F 66 0F EF 84 24 80 00 00 00 66 0F 73 F3 3E 66 0F EF C9 66 0F C2 D9 04 66 0F 28 CA 66 0F 59 D2 66 0F 28 25 ?? ?? ?? ?? 66 0F 28 2D ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 3D ?? ?? ?? ?? 66 0F 59 E2 66 0F 58 25 ?? ?? ?? ?? 66 0F 59 EA 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 E2 66 0F 58 25 ?? ?? ?? ?? 66 0F 59 EA 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 E2 66 0F 58 E6 66 0F 59 EA 66 0F 58 EF 66 0F 59 E1 66 0F 28 CB 66 0F 54 CC 66 0F 28 D3 66 0F 55 D5 66 0F 56 CA 66 0F 28 F3 66 0F 55 F4 66 0F 28 FB 66 0F 54 FD 66 0F 56 F7 66 0F 5E F1 66 0F 57 C6 E9 59 01 00 00 89 44 24 20 83 F8 03 0F 84 F4 00 00 00 66 0F 28 54 24 70 66 0F 59 F8 66 0F 5C D4 66 0F EF E4 66 0F 5C D5 66 0F 5C D6 66 0F 57 C9 66 0F 28 CA 66 0F 59 D2 66 0F 5C CF 66 0F 29 8C 24 E0 00 00 00 66 0F 28 C3 66 0F 73 F0 3F 66 0F EF C4 66 0F 73 F3 3E 66 0F EF C9 66 0F C2 D9 04 66 0F 28 8C 24 E0 00 00 00 66 0F 28 25 ?? ?? ?? ?? 66 0F 28 2D ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 3D ?? ?? ?? ?? 66 0F 59 E2 66 0F 58 25 ?? ?? ?? ?? 66 0F 59 EA 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 E2 66 0F 58 25 ?? ?? ?? ?? 66 0F 59 EA 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 E2 66 0F 58 E6 66 0F 59 EA 66 0F 58 EF 66 0F 59 E1 66 0F 28 CB 66 0F 54 CC 66 0F 28 D3 66 0F 55 D5 66 0F 56 CA 66 0F 28 F3 66 0F 55 F4 66 0F 28 FB 66 0F 54 FD 66 0F 56 F7 66 0F 5E F1 66 0F 57 C6 66 0F 29 84 24 E0 00 00 00 33 C0 8B 54 24 20 48 89 5C 24 58 48 89 74 24 50 48 89 7C 24 48 4C 89 64 24 40 48 89 6C 24 60 48 8B E8 F6 C2 01 75 49 48 FF C5 D1 FA 89 54 24 20 48 83 FD 02 7C EC 48 8B 5C 24 58 48 8B 74 24 50 48 8B 7C 24 48 4C 8B 64 24 40 48 8B 6C 24 60 66 0F 28 84 24 E0 00 00 00 0F 28 B4 24 00 01 00 00 0F 28 BC 24 F0 00 00 00 48 81 C4 18 01 00 00 C3 48 8B 54 EC 70 48 8D 0D ?? ?? ?? ?? 48 89 54 24 28 48 89 4C 24 30 F2 0F 10 44 24 28 4C 8B 64 24 30 66 0F C5 C0 03 25 F0 7F 00 00 3D F0 7F 00 00 0F 84 0E 05 00 00 8B C8 81 E9 60 3F 00 00 C1 E9 07 81 E1 FC FF 00 00 4D 8D 9C 24 40 01 00 00 49 03 CB 66 48 0F 7E C0 44 8B 51 14 44 8B 41 18 8B D0 48 C1 E8 15 0D 00 00 00 80 C1 E8 0B 45 8B CA 4C 0F AF D2 4C 0F AF C8 4C 0F AF C0 8B 71 10 8B 79 0C 45 8B DA 49 C1 EA 20 4D 03 CA 4D 03 D8 45 8B C3 49 C1 EB 20 4D 03 CB 44 8B D6 48 0F AF F2 4C 0F AF D0 44 8B DF 48 0F AF FA 8B DE 48 C1 EE 20 4C 03 CB 41 8B D9 49 C1 E9 20 4C 03 D6 4D 03 D1 48 C1 E3 20 4C 0B C3 4C 0F AF D8 44 8B 49 08 8B 71 04 8B DF 48 C1 EF 20 4C 03 D3 41 8B DA 49 C1 EA 20 4C 03 DF 4D 03 DA 49 8B F9 4C 0F AF CA 48 0F AF F8 45 8B D1 49 C1 E9 20 4D 03 DA 45 8B D3 49 C1 EB 20 49 03 F9 49 03 FB 4C 8B CE 48 0F AF F2 4C 0F AF C8 49 C1 E2 20 4C 0B D3 8B 01 44 8B DE 48 C1 EE 20 49 03 FB 44 8B DF 48 C1 EF 20 4C 03 CE 4C 03 CF 48 0F AF D0 66 0F C5 D8 03 49 8D BC 24 40 01 00 00 48 2B CF 03 C9 03 C9 03 C9 83 C1 13 BE 00 80 00 00 23 F3 C1 EB 04 81 E3 FF 07 00 00 81 EB FF 03 00 00 2B CB 4C 03 CA 8B D1 83 C2 20 83 F9 00 0F 8C 16 03 00 00 F7 D9 83 C1 1D 41 D3 E1 41 8B F9 41 81 E1 FF FF FF 3F 41 F7 C1 00 00 00 20 0F 85 20 03 00 00 41 D3 E9 BB 00 00 00 00 49 C1 E1 20 4D 0B CB 49 83 F9 00 0F 84 89 02 00 00 4D 0F BD D9 B9 1D 00 00 00 41 2B CB 0F 8E A9 02 00 00 49 D3 E1 49 8B C2 49 D3 E2 03 D1 F7 D9 83 C1 40 48 D3 E8 49 D3 E8 4C 0B C8 4D 0B D0 F2 49 0F 2A C1 49 D1 EA F2 49 0F 2A DA 66 0F 57 E4 C1 E2 04 F7 DA 81 C2 F0 3F 00 00 0B D6 33 D3 66 0F C4 E2 03 F3 41 0F 7E 54 24 60 F3 41 0F 7E 7C 24 68 66 0F 57 ED 81 EA F0 03 00 00 66 0F C4 EA 03 F2 0F 59 C4 C1 E6 10 C1 FE 1F F2 0F 59 DD F3 0F 7E C8 F2 0F 59 C2 C1 EF 1E F2 0F 58 CB F2 0F 59 DA 03 FE 33 FE F2 0F 59 F9 8B C7 F2 0F 58 FB F3 0F 7E D0 F2 0F 58 C7 F2 0F 5C D0 F2 0F 58 FA 66 41 0F 28 0C 24 F2 0F 12 C0 66 0F 59 C8 F2 0F 12 FF F2 0F 2D D1 66 41 0F 28 54 24 10 66 0F 58 CA 66 41 0F 28 5C 24 20 66 0F 5C CA F3 41 0F 7E AC 24 80 00 00 00 C1 E0 04 81 C2 00 29 07 00 66 41 0F 28 64 24 30 66 0F 59 D9 03 D0 83 E2 1F F2 0F 59 E9 8B CA 66 0F 59 E1 D1 E1 66 0F 5C C3 66 41 0F 59 4C 24 40 03 D1 C1 E1 02 03 D1 F2 0F 58 E8 66 0F 28 D0 66 0F 5C C4 F3 41 0F 7E B4 24 90 00 00 00 C1 E2 04 49 8D 84 24 F0 01 00 00 66 41 0F 54 6C 24 50 66 0F 28 D8 48 03 C2 66 0F 5C D0 66 0F 15 C0 F2 0F 5E F5 66 0F 5C D4 F2 0F 5C DD 66 0F 5C D1 66 0F 28 48 30 66 0F 58 D7 66 0F 28 78 10 66 0F 59 F8 66 0F 28 60 60 66 0F 59 C8 66 0F 59 E0 F2 0F 58 D3 66 0F 28 D8 66 0F 59 C0 66 0F 58 38 66 0F 58 48 20 66 0F 59 C8 66 0F 58 60 50 66 0F 58 F9 66 0F 28 48 70 66 0F 59 C8 66 0F 59 C0 66 0F 58 E1 66 0F 28 48 40 66 0F 59 C8 66 0F 58 F9 66 0F 28 CB 66 0F 59 D8 F2 0F 59 C0 66 0F 59 88 90 00 00 00 66 0F 59 E3 F3 0F 7E D9 66 0F 58 FC F3 0F 7E E1 F2 0F 59 C7 66 0F 15 FF F2 0F 58 C7 66 0F 15 C9 F2 0F 58 D9 F2 0F 5C E3 F2 0F 58 CC F3 0F 7E E2 F3 0F 7E B8 90 00 00 00 66 0F 15 D2 F2 0F 58 B8 98 00 00 00 F2 0F 59 FA F2 0F 58 B8 88 00 00 00 F2 0F 58 F9 F2 0F 58 C7 F3 41 0F 7E BC 24 90 00 00 00 F2 0F 59 E6 F3 0F 7E 90 A8 00 00 00 66 0F 54 D6 F2 0F 59 EA F2 0F 59 B0 A0 00 00 00 F2 0F 5C FD F2 0F 5C 90 80 00 00 00 F2 0F 5C FC F2 0F 59 FE F3 0F 7E E3 F2 0F 5C DA F2 0F 58 D3 F2 0F 5C E2 F2 0F 58 C4 F2 0F 5C C7 F2 0F 58 C3 E9 0B 01 00 00 83 C2 40 4D 8B CA 4D 8B D0 49 C7 C0 00 00 00 00 49 83 F9 00 0F 85 5D FD FF FF 83 C2 40 4D 8B CA 4D 8B D0 49 83 F9 00 0F 85 4A FD FF FF E9 73 FD FF FF 0F 84 6D FD FF FF F7 D9 49 D3 EA 49 8B C1 49 D3 E9 2B D1 F7 D9 83 C1 40 48 D3 E0 4C 0B D0 E9 50 FD FF FF F7 D1 49 C1 E1 20 4D 0B CB 49 D3 E1 49 8B F9 41 F7 C1 00 00 00 80 75 56 41 D3 E9 BB 00 00 00 00 48 C1 EF 02 E9 EF FC FF FF 41 D3 E9 BB 00 00 00 40 D3 EB 49 C1 E1 20 4D 0B CB 48 C1 E3 20 81 C7 00 00 00 40 48 C7 C1 00 00 00 00 49 C7 C3 00 00 00 00 49 2B C8 4D 1B DA 49 1B D9 4C 8B C1 4D 8B D3 4C 8B CB BB 00 80 00 00 E9 AA FC FF FF 41 D3 E9 48 BB 00 00 00 00 01 00 00 00 48 D3 EB 48 C7 C1 00 00 00 00 49 C7 C3 00 00 00 00 49 2B C8 4D 1B DA 49 1B D9 4C 8B C1 4D 8B D3 4C 8B CB BB 00 80 00 00 48 C1 EF 02 81 C7 00 00 00 40 E9 66 FC FF FF F2 0F 5C C0 F2 0F 11 44 24 38 48 8B 54 24 38 48 89 94 EC E0 00 00 00 8B 54 24 20 E9 53 FA FF FF 66 66 66 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_84_0_0 {
	meta:
		name = "__dtold"
		size = 418
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 C7 44 24 18 00 00 00 80 33 C0 66 89 04 24 48 8B 44 24 38 0F B7 40 06 25 F0 7F 00 00 C1 F8 04 66 89 44 24 04 48 8B 44 24 38 0F B7 40 06 25 00 80 00 00 66 89 44 24 08 48 8B 44 24 38 8B 40 04 25 FF FF 0F 00 89 44 24 14 48 8B 44 24 38 8B 00 89 44 24 0C 0F B7 44 24 04 89 44 24 10 83 7C 24 10 00 74 17 81 7C 24 10 FF 07 00 00 74 02 EB 5B B8 FF 7F 00 00 66 89 04 24 EB 6D 83 7C 24 14 00 75 31 83 7C 24 0C 00 75 2A 48 8B 44 24 30 C7 40 04 00 00 00 00 48 8B 44 24 30 C7 00 00 00 00 00 48 8B 44 24 30 0F B7 4C 24 08 66 89 48 08 E9 DD 00 00 00 0F BF 44 24 04 05 01 3C 00 00 66 89 04 24 C7 44 24 18 00 00 00 00 EB 1D 0F B7 44 24 04 2D FF 03 00 00 66 89 44 24 04 0F BF 44 24 04 05 FF 3F 00 00 66 89 04 24 8B 44 24 14 C1 E0 0B 8B 4C 24 18 0B C8 8B C1 8B 4C 24 0C C1 E9 15 0B C1 48 8B 4C 24 30 89 41 04 8B 44 24 0C C1 E0 0B 48 8B 4C 24 30 89 01 48 8B 44 24 30 8B 40 04 25 00 00 00 80 85 C0 75 55 48 8B 44 24 30 8B 00 25 00 00 00 80 85 C0 74 0A C7 44 24 1C 01 00 00 00 EB 08 C7 44 24 1C 00 00 00 00 48 8B 44 24 30 8B 40 04 D1 E0 0B 44 24 1C 48 8B 4C 24 30 89 41 04 48 8B 44 24 30 8B 00 D1 E0 48 8B 4C 24 30 89 01 0F B7 04 24 66 FF C8 66 89 04 24 EB 9A 0F B7 44 24 08 0F B7 0C 24 0B C1 48 8B 4C 24 30 66 89 41 08 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_84_1_0 {
	meta:
		name = "_fltout2"
		size = 272
		refs = "0020 __security_cookie 003a __dtold 0068 $I10_OUTPUT 00ac strcpy_s 00c4 ??_C@_1HM@JLHEPEIG@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 00cb ??_C@_1BC@BPMMEHLK@?$AA_?$AAf?$AAl?$AAt?$AAo?$AAu?$AAt?$AA2?$AA?$AA@ 00d2 ??_C@_1FK@KODCOBKF@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAr?$AAe?$AAs?$AAu?$AAl?$AAt?$AAs?$AAt?$AAr?$AA?0?$AA?5?$AAr?$AAe?$AAs?$AAu?$AAl?$AAt?$AAs?$AAi?$AAz?$AAe?$AA?0?$AA?5@ 00d9 _invoke_watson_if_error 0102 __security_check_cookie"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 56 57 48 81 EC 88 00 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 70 48 8D 94 24 A0 00 00 00 48 8D 4C 24 40 E8 ?? ?? ?? ?? 48 8D 44 24 30 48 8D 4C 24 40 48 8B F8 48 8B F1 B9 0A 00 00 00 F3 A4 4C 8D 4C 24 50 45 33 C0 BA 11 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 8C 24 A8 00 00 00 89 41 08 0F BE 44 24 52 48 8B 8C 24 A8 00 00 00 89 01 0F BF 44 24 50 48 8B 8C 24 A8 00 00 00 89 41 04 4C 8D 44 24 54 48 8B 94 24 B8 00 00 00 48 8B 8C 24 B0 00 00 00 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 28 00 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 48 8B 84 24 A8 00 00 00 48 8B 8C 24 B0 00 00 00 48 89 48 10 48 8B 84 24 A8 00 00 00 48 8B 4C 24 70 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 88 00 00 00 5F 5E C3 }
	condition:
		$1
}

rule file_85_1_0 {
	meta:
		name = "__wdtoxmode"
		size = 403
		refs = "00e1 wcsrchr 00f5 ??_C@_19DOGDICKI@?$AA?4?$AAe?$AAx?$AAe?$AA?$AA@ 00ff _wcsicmp 010a ??_C@_19BDKLHPGC@?$AA?4?$AAc?$AAm?$AAd?$AA?$AA@ 011f ??_C@_19PINKOIBI@?$AA?4?$AAb?$AAa?$AAt?$AA?$AA@ 0134 ??_C@_19CDGLJBOD@?$AA?4?$AAc?$AAo?$AAm?$AA?$AA@"
	strings:
		$1 = { 48 89 54 24 10 89 4C 24 08 48 83 EC 48 8B 44 24 50 25 FF 00 00 00 89 44 24 28 48 8B 44 24 58 48 89 44 24 30 B8 02 00 00 00 48 6B C0 01 48 8B 4C 24 30 0F B7 04 01 83 F8 3A 75 0E 48 8B 44 24 30 48 83 C0 04 48 89 44 24 30 48 8B 44 24 30 0F B7 00 83 F8 5C 74 0D 48 8B 44 24 30 0F B7 00 83 F8 2F 75 16 B8 02 00 00 00 48 6B C0 01 48 8B 4C 24 30 0F B7 04 01 85 C0 74 21 8B 44 24 28 83 E0 10 85 C0 75 16 48 8B 44 24 30 0F B7 00 85 C0 74 0A C7 44 24 24 00 80 00 00 EB 08 C7 44 24 24 40 40 00 00 0F B7 44 24 24 66 89 44 24 20 8B 44 24 28 83 E0 01 85 C0 74 0A C7 44 24 2C 00 01 00 00 EB 08 C7 44 24 2C 80 01 00 00 0F B7 44 24 20 0B 44 24 2C 66 89 44 24 20 66 BA 2E 00 48 8B 4C 24 58 E8 ?? ?? ?? ?? 48 89 44 24 30 48 83 7C 24 30 00 74 61 48 8D 15 ?? ?? ?? ?? 48 8B 4C 24 30 E8 ?? ?? ?? ?? 85 C0 74 3F 48 8D 15 ?? ?? ?? ?? 48 8B 4C 24 30 E8 ?? ?? ?? ?? 85 C0 74 2A 48 8D 15 ?? ?? ?? ?? 48 8B 4C 24 30 E8 ?? ?? ?? ?? 85 C0 74 15 48 8D 15 ?? ?? ?? ?? 48 8B 4C 24 30 E8 ?? ?? ?? ?? 85 C0 75 0D 0F B7 44 24 20 83 C8 40 66 89 44 24 20 0F B7 44 24 20 25 C0 01 00 00 C1 F8 03 0F B7 4C 24 20 0B C8 8B C1 66 89 44 24 20 0F B7 44 24 20 25 C0 01 00 00 C1 F8 06 0F B7 4C 24 20 0B C8 8B C1 66 89 44 24 20 0F B7 44 24 20 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_85_3_0 {
	meta:
		name = "_wstat32"
		size = 2181
		refs = "0014 __security_cookie 005a ??_C@_1BO@PCMLKEJK@?$AA?$CI?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0066 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 007b ??_C@_1GG@NPCFJIAM@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 0085 _CrtDbgReportW 0099 __doserrno 00a4 _errno 00c7 ??_C@_1BC@KHJLGKNG@?$AA_?$AAw?$AAs?$AAt?$AAa?$AAt?$AA3?$AA2?$AA?$AA@ 00d3 _invalid_parameter 0110 ??_C@_1BM@KFJLMBPG@?$AA?$CI?$AAb?$AAu?$AAf?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 019a ??_C@_15HEJOKEHO@?$AA?$DP?$AA?$CK?$AA?$AA@ 01a7 wcspbrk 023e towlower 024f _getdrive 027f __imp_FindFirstFileExW 02a0 ??_C@_17BAAFHAL@?$AA?4?$AA?1?$AA?2?$AA?$AA@ 02d2 _wfullpath_helper 02f2 wcslen 0305 IsRootUNCName 0317 __imp_GetDriveTypeW 032e free 03c4 __loctotime32_t 0474 _wsopen_s 04bd _fstat32 04ca _close 04d5 __imp_FindClose 050e __imp_FileTimeToLocalFileTime 0525 __imp_FileTimeToSystemTime 052f __imp_GetLastError 0536 _dosmaperr 07b9 __wdtoxmode 0879 __security_check_cookie"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 81 EC 28 05 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 10 05 00 00 C7 44 24 40 00 00 00 00 48 83 BC 24 30 05 00 00 00 74 0A C7 44 24 60 01 00 00 00 EB 08 C7 44 24 60 00 00 00 00 8B 44 24 60 89 44 24 70 83 7C 24 70 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 BA 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 70 00 75 49 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 BA 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 FF FF FF FF E9 8C 07 00 00 48 83 BC 24 38 05 00 00 00 74 0A C7 44 24 74 01 00 00 00 EB 08 C7 44 24 74 00 00 00 00 8B 44 24 74 89 44 24 58 83 7C 24 58 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 BB 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 58 00 75 49 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 BB 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 FF FF FF FF E9 D6 06 00 00 48 8D 15 ?? ?? ?? ?? 48 8B 8C 24 30 05 00 00 E8 ?? ?? ?? ?? 48 85 C0 74 20 E8 ?? ?? ?? ?? C7 00 02 00 00 00 E8 ?? ?? ?? ?? C7 00 02 00 00 00 B8 FF FF FF FF E9 9D 06 00 00 B8 02 00 00 00 48 6B C0 01 48 8B 8C 24 30 05 00 00 0F B7 04 01 83 F8 3A 75 64 48 8B 84 24 30 05 00 00 0F B7 00 85 C0 74 39 B8 02 00 00 00 48 6B C0 02 48 8B 8C 24 30 05 00 00 0F B7 04 01 85 C0 75 20 E8 ?? ?? ?? ?? C7 00 02 00 00 00 E8 ?? ?? ?? ?? C7 00 02 00 00 00 B8 FF FF FF FF E9 3B 06 00 00 48 8B 84 24 30 05 00 00 0F B7 08 E8 ?? ?? ?? ?? 0F B7 C0 83 E8 60 89 44 24 64 EB 09 E8 ?? ?? ?? ?? 89 44 24 64 C7 44 24 28 00 00 00 00 48 C7 44 24 20 00 00 00 00 45 33 C9 4C 8D 84 24 B0 00 00 00 33 D2 48 8B 8C 24 30 05 00 00 FF 15 ?? ?? ?? ?? 48 89 44 24 50 48 83 7C 24 50 FF 0F 85 70 01 00 00 48 C7 44 24 78 00 00 00 00 48 8D 15 ?? ?? ?? ?? 48 8B 8C 24 30 05 00 00 E8 ?? ?? ?? ?? 48 85 C0 74 6A 4C 8D 4C 24 78 41 B8 04 01 00 00 48 8B 94 24 30 05 00 00 48 8D 8C 24 00 03 00 00 E8 ?? ?? ?? ?? 48 89 84 24 80 00 00 00 48 83 BC 24 80 00 00 00 00 74 37 48 8B 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 48 83 F8 03 74 11 48 8B 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 85 C0 74 13 48 8B 8C 24 80 00 00 00 FF 15 ?? ?? ?? ?? 83 F8 01 77 32 48 83 7C 24 78 00 74 0A 48 8B 4C 24 78 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 00 02 00 00 00 E8 ?? ?? ?? ?? C7 00 02 00 00 00 B8 FF FF FF FF E9 1B 05 00 00 48 83 7C 24 78 00 74 0A 48 8B 4C 24 78 E8 ?? ?? ?? ?? C7 84 24 B0 00 00 00 10 00 00 00 C7 84 24 CC 00 00 00 00 00 00 00 C7 84 24 D0 00 00 00 00 00 00 00 B8 02 00 00 00 48 6B C0 00 33 C9 66 89 8C 04 DC 00 00 00 C7 44 24 30 FF FF FF FF C7 44 24 28 00 00 00 00 C7 44 24 20 00 00 00 00 45 33 C9 41 B8 01 00 00 00 BA 01 00 00 00 B9 BC 07 00 00 E8 ?? ?? ?? ?? 48 8B 8C 24 38 05 00 00 89 41 1C 48 8B 84 24 38 05 00 00 48 8B 8C 24 38 05 00 00 8B 49 1C 89 48 18 48 8B 84 24 38 05 00 00 48 8B 8C 24 38 05 00 00 8B 49 1C 89 48 20 E9 A5 03 00 00 8B 84 24 B0 00 00 00 25 00 04 00 00 85 C0 0F 84 CF 00 00 00 81 BC 24 D4 00 00 00 0C 00 00 A0 0F 85 BE 00 00 00 C7 44 24 44 FF FF FF FF C7 44 24 48 00 00 00 00 8B 84 24 B0 00 00 00 83 E0 10 85 C0 74 0C 8B 44 24 48 0F BA E8 0D 89 44 24 48 C7 44 24 20 00 00 00 00 41 B9 40 00 00 00 44 8B 44 24 48 48 8B 94 24 30 05 00 00 48 8D 4C 24 44 E8 ?? ?? ?? ?? 89 84 24 88 00 00 00 83 BC 24 88 00 00 00 00 75 07 83 7C 24 44 FF 75 20 E8 ?? ?? ?? ?? C7 00 02 00 00 00 E8 ?? ?? ?? ?? C7 00 02 00 00 00 B8 FF FF FF FF E9 BD 03 00 00 48 8B 94 24 38 05 00 00 8B 4C 24 44 E8 ?? ?? ?? ?? 89 44 24 40 8B 4C 24 44 E8 ?? ?? ?? ?? 48 8B 4C 24 50 FF 15 ?? ?? ?? ?? 8B 44 24 40 E9 8B 03 00 00 E9 C2 02 00 00 83 BC 24 C4 00 00 00 00 75 0E 83 BC 24 C8 00 00 00 00 0F 84 BC 00 00 00 48 8D 54 24 68 48 8D 8C 24 C4 00 00 00 FF 15 ?? ?? ?? ?? 85 C0 74 17 48 8D 94 24 98 00 00 00 48 8D 4C 24 68 FF 15 ?? ?? ?? ?? 85 C0 75 22 FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 48 8B 4C 24 50 FF 15 ?? ?? ?? ?? B8 FF FF FF FF E9 1E 03 00 00 0F B7 84 24 A4 00 00 00 0F B7 8C 24 A2 00 00 00 0F B7 94 24 A0 00 00 00 44 0F B7 84 24 9E 00 00 00 44 0F B7 8C 24 9A 00 00 00 44 89 8C 24 8C 00 00 00 44 0F B7 94 24 98 00 00 00 C7 44 24 30 FF FF FF FF 89 44 24 28 89 4C 24 20 44 8B CA 8B 84 24 8C 00 00 00 8B D0 41 8B CA E8 ?? ?? ?? ?? 48 8B 8C 24 38 05 00 00 89 41 1C EB 0F 48 8B 84 24 38 05 00 00 C7 40 1C 00 00 00 00 83 BC 24 BC 00 00 00 00 75 0E 83 BC 24 C0 00 00 00 00 0F 84 BC 00 00 00 48 8D 54 24 68 48 8D 8C 24 BC 00 00 00 FF 15 ?? ?? ?? ?? 85 C0 74 17 48 8D 94 24 98 00 00 00 48 8D 4C 24 68 FF 15 ?? ?? ?? ?? 85 C0 75 22 FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 48 8B 4C 24 50 FF 15 ?? ?? ?? ?? B8 FF FF FF FF E9 3B 02 00 00 0F B7 84 24 A4 00 00 00 0F B7 8C 24 A2 00 00 00 0F B7 94 24 A0 00 00 00 44 0F B7 84 24 9E 00 00 00 44 0F B7 8C 24 9A 00 00 00 44 89 8C 24 94 00 00 00 44 0F B7 94 24 98 00 00 00 C7 44 24 30 FF FF FF FF 89 44 24 28 89 4C 24 20 44 8B CA 8B 84 24 94 00 00 00 8B D0 41 8B CA E8 ?? ?? ?? ?? 48 8B 8C 24 38 05 00 00 89 41 18 EB 16 48 8B 84 24 38 05 00 00 48 8B 8C 24 38 05 00 00 8B 49 1C 89 48 18 83 BC 24 B4 00 00 00 00 75 0E 83 BC 24 B8 00 00 00 00 0F 84 BC 00 00 00 48 8D 54 24 68 48 8D 8C 24 B4 00 00 00 FF 15 ?? ?? ?? ?? 85 C0 74 17 48 8D 94 24 98 00 00 00 48 8D 4C 24 68 FF 15 ?? ?? ?? ?? 85 C0 75 22 FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 48 8B 4C 24 50 FF 15 ?? ?? ?? ?? B8 FF FF FF FF E9 51 01 00 00 0F B7 84 24 A4 00 00 00 0F B7 8C 24 A2 00 00 00 0F B7 94 24 A0 00 00 00 44 0F B7 84 24 9E 00 00 00 44 0F B7 8C 24 9A 00 00 00 44 89 8C 24 90 00 00 00 44 0F B7 94 24 98 00 00 00 C7 44 24 30 FF FF FF FF 89 44 24 28 89 4C 24 20 44 8B CA 8B 84 24 90 00 00 00 8B D0 41 8B CA E8 ?? ?? ?? ?? 48 8B 8C 24 38 05 00 00 89 41 20 EB 16 48 8B 84 24 38 05 00 00 48 8B 8C 24 38 05 00 00 8B 49 1C 89 48 20 48 8B 4C 24 50 FF 15 ?? ?? ?? ?? 48 8B 94 24 30 05 00 00 8B 8C 24 B0 00 00 00 E8 ?? ?? ?? ?? 48 8B 8C 24 38 05 00 00 66 89 41 06 B8 01 00 00 00 48 8B 8C 24 38 05 00 00 66 89 41 08 48 8B 84 24 38 05 00 00 8B 8C 24 D0 00 00 00 89 48 14 83 BC 24 CC 00 00 00 00 74 22 E8 ?? ?? ?? ?? C7 00 84 00 00 00 48 8B 84 24 38 05 00 00 C7 40 14 00 00 00 00 C7 44 24 40 FF FF FF FF 33 C0 48 8B 8C 24 38 05 00 00 66 89 41 04 33 C0 48 8B 8C 24 38 05 00 00 66 89 41 0C 33 C0 48 8B 8C 24 38 05 00 00 66 89 41 0A 8B 44 24 64 FF C8 89 44 24 5C 48 8B 84 24 38 05 00 00 8B 4C 24 5C 89 08 48 8B 84 24 38 05 00 00 8B 4C 24 5C 89 48 10 8B 44 24 40 48 8B 8C 24 10 05 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 28 05 00 00 C3 }
	condition:
		$1
}

rule file_86_2_0 {
	meta:
		name = "??0IUMSThreadProxy@Concurrency@@QEAA@XZ"
		size = 44
		refs = "000f ??0IThreadProxy@Concurrency@@QEAA@XZ 001b ??_7IUMSThreadProxy@Concurrency@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_10_38_2 {
	meta:
		name = "??0?$basic_ios@DU?$char_traits@D@std@@@std@@IEAA@XZ"
		size = 44
		refs = "000f ??0ios_base@std@@IEAA@XZ 001b ??_7?$basic_ios@DU?$char_traits@D@std@@@std@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_75_29_1 {
	meta:
		name = "??0?$basic_ios@GU?$char_traits@G@std@@@std@@IEAA@XZ"
		size = 44
		refs = "000f ??0ios_base@std@@IEAA@XZ 001b ??_7?$basic_ios@GU?$char_traits@G@std@@@std@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_45_55_3 {
	meta:
		name = "??0?$basic_ios@_WU?$char_traits@_W@std@@@std@@IEAA@XZ"
		size = 44
		refs = "000f ??0ios_base@std@@IEAA@XZ 001b ??_7?$basic_ios@_WU?$char_traits@_W@std@@@std@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_338_1_0 {
	meta:
		name = "??0IUMSScheduler@Concurrency@@QEAA@XZ"
		size = 44
		refs = "000f ??0IScheduler@Concurrency@@QEAA@XZ 001b ??_7IUMSScheduler@Concurrency@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_739_1_0 {
	meta:
		name = "??0IVirtualProcessorRoot@Concurrency@@QEAA@XZ"
		size = 44
		refs = "000f ??0IExecutionResource@Concurrency@@QEAA@XZ 001b ??_7IVirtualProcessorRoot@Concurrency@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_5_321_1 {
	meta:
		name = "??0_Future_error_category@std@@QEAA@XZ"
		size = 44
		refs = "000f ??0_Generic_error_category@std@@QEAA@XZ 001b ??_7_Future_error_category@std@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_48_26_3 {
	meta:
		name = "??0_Generic_error_category@std@@QEAA@XZ"
		size = 44
		refs = "000f ??0error_category@std@@QEAA@XZ 001b ??_7_Generic_error_category@std@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_273_1_0 {
	meta:
		name = "??0_Interruption_exception@details@Concurrency@@QEAA@XZ"
		size = 44
		refs = "000f ??0exception@std@@QEAA@XZ 001b ??_7_Interruption_exception@details@Concurrency@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_35_16_1 {
	meta:
		name = "??0_Iostream_error_category@std@@QEAA@XZ"
		size = 44
		refs = "000f ??0_Generic_error_category@std@@QEAA@XZ 001b ??_7_Iostream_error_category@std@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_112_29_3 {
	meta:
		name = "??0_System_error_category@std@@QEAA@XZ"
		size = 44
		refs = "000f ??0_Generic_error_category@std@@QEAA@XZ 001b ??_7_System_error_category@std@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_273_3_0 {
	meta:
		name = "??0bad_target@Concurrency@@QEAA@XZ"
		size = 44
		refs = "000f ??0exception@std@@QEAA@XZ 001b ??_7bad_target@Concurrency@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_273_5_0 {
	meta:
		name = "??0context_self_unblock@Concurrency@@QEAA@XZ"
		size = 44
		refs = "000f ??0exception@std@@QEAA@XZ 001b ??_7context_self_unblock@Concurrency@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_273_7_0 {
	meta:
		name = "??0context_unblock_unbalanced@Concurrency@@QEAA@XZ"
		size = 44
		refs = "000f ??0exception@std@@QEAA@XZ 001b ??_7context_unblock_unbalanced@Concurrency@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_273_9_0 {
	meta:
		name = "??0default_scheduler_exists@Concurrency@@QEAA@XZ"
		size = 44
		refs = "000f ??0exception@std@@QEAA@XZ 001b ??_7default_scheduler_exists@Concurrency@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_273_11_0 {
	meta:
		name = "??0improper_lock@Concurrency@@QEAA@XZ"
		size = 44
		refs = "000f ??0exception@std@@QEAA@XZ 001b ??_7improper_lock@Concurrency@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_273_13_0 {
	meta:
		name = "??0improper_scheduler_attach@Concurrency@@QEAA@XZ"
		size = 44
		refs = "000f ??0exception@std@@QEAA@XZ 001b ??_7improper_scheduler_attach@Concurrency@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_273_15_0 {
	meta:
		name = "??0improper_scheduler_detach@Concurrency@@QEAA@XZ"
		size = 44
		refs = "000f ??0exception@std@@QEAA@XZ 001b ??_7improper_scheduler_detach@Concurrency@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_273_17_0 {
	meta:
		name = "??0improper_scheduler_reference@Concurrency@@QEAA@XZ"
		size = 44
		refs = "000f ??0exception@std@@QEAA@XZ 001b ??_7improper_scheduler_reference@Concurrency@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_273_19_0 {
	meta:
		name = "??0invalid_link_target@Concurrency@@QEAA@XZ"
		size = 44
		refs = "000f ??0exception@std@@QEAA@XZ 001b ??_7invalid_link_target@Concurrency@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_273_21_0 {
	meta:
		name = "??0invalid_multiple_scheduling@Concurrency@@QEAA@XZ"
		size = 44
		refs = "000f ??0exception@std@@QEAA@XZ 001b ??_7invalid_multiple_scheduling@Concurrency@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_273_23_0 {
	meta:
		name = "??0invalid_operation@Concurrency@@QEAA@XZ"
		size = 44
		refs = "000f ??0exception@std@@QEAA@XZ 001b ??_7invalid_operation@Concurrency@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_273_25_0 {
	meta:
		name = "??0invalid_oversubscribe_operation@Concurrency@@QEAA@XZ"
		size = 44
		refs = "000f ??0exception@std@@QEAA@XZ 001b ??_7invalid_oversubscribe_operation@Concurrency@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_273_27_0 {
	meta:
		name = "??0invalid_scheduler_policy_key@Concurrency@@QEAA@XZ"
		size = 44
		refs = "000f ??0exception@std@@QEAA@XZ 001b ??_7invalid_scheduler_policy_key@Concurrency@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_273_29_0 {
	meta:
		name = "??0invalid_scheduler_policy_thread_specification@Concurrency@@QEAA@XZ"
		size = 44
		refs = "000f ??0exception@std@@QEAA@XZ 001b ??_7invalid_scheduler_policy_thread_specification@Concurrency@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_273_31_0 {
	meta:
		name = "??0invalid_scheduler_policy_value@Concurrency@@QEAA@XZ"
		size = 44
		refs = "000f ??0exception@std@@QEAA@XZ 001b ??_7invalid_scheduler_policy_value@Concurrency@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_273_33_0 {
	meta:
		name = "??0message_not_found@Concurrency@@QEAA@XZ"
		size = 44
		refs = "000f ??0exception@std@@QEAA@XZ 001b ??_7message_not_found@Concurrency@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_273_35_0 {
	meta:
		name = "??0missing_wait@Concurrency@@QEAA@XZ"
		size = 44
		refs = "000f ??0exception@std@@QEAA@XZ 001b ??_7missing_wait@Concurrency@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_273_37_0 {
	meta:
		name = "??0nested_scheduler_missing_detach@Concurrency@@QEAA@XZ"
		size = 44
		refs = "000f ??0exception@std@@QEAA@XZ 001b ??_7nested_scheduler_missing_detach@Concurrency@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_273_39_0 {
	meta:
		name = "??0operation_timed_out@Concurrency@@QEAA@XZ"
		size = 44
		refs = "000f ??0exception@std@@QEAA@XZ 001b ??_7operation_timed_out@Concurrency@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_273_41_0 {
	meta:
		name = "??0scheduler_not_attached@Concurrency@@QEAA@XZ"
		size = 44
		refs = "000f ??0exception@std@@QEAA@XZ 001b ??_7scheduler_not_attached@Concurrency@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_273_47_0 {
	meta:
		name = "??0task_canceled@Concurrency@@QEAA@XZ"
		size = 44
		refs = "000f ??0exception@std@@QEAA@XZ 001b ??_7task_canceled@Concurrency@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_273_49_0 {
	meta:
		name = "??0unsupported_os@Concurrency@@QEAA@XZ"
		size = 44
		refs = "000f ??0exception@std@@QEAA@XZ 001b ??_7unsupported_os@Concurrency@@6B@"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_86_5_0 {
	meta:
		name = "??0UMSThreadProxy@details@Concurrency@@QEAA@PEAUIThreadProxyFactory@12@PEAXI@Z"
		size = 1382
		refs = "0025 ??0UMSBaseObject@details@Concurrency@@QEAA@XZ 0039 ??0IUMSThreadProxy@Concurrency@@QEAA@XZ 004d ??0IUMSUnblockNotification@Concurrency@@QEAA@XZ 005c ??_7UMSThreadProxy@details@Concurrency@@6BUMSBaseObject@12@@ 006e ??_7UMSThreadProxy@details@Concurrency@@6BIUMSThreadProxy@2@@ 0081 ??_7UMSThreadProxy@details@Concurrency@@6BIUMSUnblockNotification@2@@ 01ca __imp_CreateEventW 01eb __imp_GetLastError 01f2 HRESULT_FROM_WIN32 0201 ??0scheduler_resource_allocation_error@Concurrency@@QEAA@J@Z 0208 _TI2?AVscheduler_resource_allocation_error@Concurrency@@ 0215 _CxxThrowException 021a ?GetThreadProxyId@ResourceManager@details@Concurrency@@SAIXZ 023c ?CreateUmsThreadContext@UMS@details@Concurrency@@SAHPEAPEAX@Z 029e ?SetUmsThreadInformation@UMS@details@Concurrency@@SAHPEAXW4_RTL_UMS_THREAD_INFO_CLASS@@0K@Z 0315 ?InitializeProcThreadAttributeList@UMS@details@Concurrency@@SAHPEAU_PROC_THREAD_ATTRIBUTE_LIST@@KKPEA_K@Z 0327 ??_C@_1CO@HEGGIGOB@?$AAG?$AAe?$AAt?$AAL?$AAa?$AAs?$AAt?$AAE?$AAr?$AAr?$AAo?$AAr?$AA?$CI?$AA?$CJ?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA1?$AA2?$AA2?$AAL?$AA?$AA@ 0333 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0348 ??_C@_1HO@LBEPJECD@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 0352 _CrtDbgReportW 0384 ??_C@_0DP@NLADCDMJ@f?3?2dd?2vctools?2crt_bld?2self_64_am@ 0393 ??_U@YAPEAX_KV_ConcRTNewMoniker@@PEBDH@Z 0422 ?UpdateProcThreadAttribute@UMS@details@Concurrency@@SAHPEAU_PROC_THREAD_ATTRIBUTE_LIST@@K_KPEAX12PEA_K@Z 0483 __imp_GetCurrentProcess 04b3 ?UMSThreadProxyMain@UMSThreadProxy@details@Concurrency@@CAKPEAX@Z 04c5 ?CreateRemoteThreadEx@UMS@details@Concurrency@@SAPEAXPEAXPEAU_SECURITY_ATTRIBUTES@@_KP6AK0@Z0KPEAU_PROC_THREAD_ATTRIBUTE_LIST@@PEAK@Z 04db ?DeleteProcThreadAttributeList@UMS@details@Concurrency@@SAXPEAU_PROC_THREAD_ATTRIBUTE_LIST@@@Z 04ef ??_V@YAXPEAX@Z 050f ?DeleteUmsThreadContext@UMS@details@Concurrency@@SAHPEAX@Z 0521 __imp_CloseHandle 053d ??0scheduler_worker_creation_error@Concurrency@@QEAA@J@Z 0544 _TI3?AVscheduler_worker_creation_error@Concurrency@@"
	strings:
		$1 = { 44 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 57 48 81 EC 60 01 00 00 48 8B 8C 24 70 01 00 00 E8 ?? ?? ?? ?? 48 8B 84 24 70 01 00 00 48 83 C0 08 48 8B C8 E8 ?? ?? ?? ?? 48 8B 84 24 70 01 00 00 48 83 C0 10 48 8B C8 E8 ?? ?? ?? ?? 48 8B 84 24 70 01 00 00 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 84 24 70 01 00 00 48 8D 0D ?? ?? ?? ?? 48 89 48 08 48 8B 84 24 70 01 00 00 48 8D 0D ?? ?? ?? ?? 48 89 48 10 48 8B 84 24 70 01 00 00 48 8B 8C 24 78 01 00 00 48 89 48 18 48 8B 84 24 70 01 00 00 48 C7 40 20 00 00 00 00 48 8B 84 24 70 01 00 00 48 C7 40 28 00 00 00 00 48 8B 84 24 70 01 00 00 48 C7 40 30 00 00 00 00 48 8B 84 24 70 01 00 00 C7 40 38 00 00 00 00 48 8B 84 24 70 01 00 00 48 C7 40 40 00 00 00 00 48 8B 84 24 70 01 00 00 48 C7 40 48 00 00 00 00 48 8B 84 24 70 01 00 00 8B 8C 24 88 01 00 00 89 48 50 48 8B 84 24 70 01 00 00 C7 40 54 00 00 00 00 48 8B 84 24 70 01 00 00 C6 40 58 00 48 8B 84 24 70 01 00 00 C7 40 5C 00 00 00 00 48 8B 84 24 70 01 00 00 48 C7 40 68 00 00 00 00 48 8B 84 24 70 01 00 00 C7 40 70 00 00 00 00 48 8B 84 24 70 01 00 00 C7 40 78 00 00 00 00 48 8B 84 24 70 01 00 00 C7 80 8C 00 00 00 00 00 00 00 48 8B 84 24 70 01 00 00 C7 80 90 00 00 00 00 00 00 00 48 8B 84 24 70 01 00 00 48 C7 80 E8 00 00 00 00 00 00 00 48 8B 84 24 70 01 00 00 C7 80 F0 00 00 00 00 00 00 00 48 8B 84 24 70 01 00 00 C6 80 F8 00 00 00 00 45 33 C9 45 33 C0 33 D2 33 C9 FF 15 ?? ?? ?? ?? 48 8B 8C 24 70 01 00 00 48 89 41 30 48 8B 84 24 70 01 00 00 48 83 78 30 00 75 30 FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B D0 48 8D 8C 24 98 00 00 00 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 8C 24 98 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 8C 24 70 01 00 00 89 81 88 00 00 00 48 8B 84 24 70 01 00 00 48 83 C0 20 48 8B C8 E8 ?? ?? ?? ?? 85 C0 75 30 FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B D0 48 8D 8C 24 D8 00 00 00 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 8C 24 D8 00 00 00 E8 ?? ?? ?? ?? 48 8B 84 24 70 01 00 00 48 89 44 24 70 41 B9 08 00 00 00 4C 8D 44 24 70 BA 01 00 00 00 48 8B 84 24 70 01 00 00 48 8B 48 20 E8 ?? ?? ?? ?? 85 C0 75 30 FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B D0 48 8D 8C 24 18 01 00 00 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 8C 24 18 01 00 00 E8 ?? ?? ?? ?? C7 84 24 80 00 00 00 00 01 00 00 48 8B 84 24 70 01 00 00 48 8B 40 20 48 89 84 24 88 00 00 00 48 8B 84 24 80 01 00 00 48 89 84 24 90 00 00 00 4C 8D 4C 24 50 45 33 C0 BA 01 00 00 00 33 C9 E8 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 83 F8 7A 74 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 46 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 33 C0 85 C0 75 B5 33 C0 85 C0 75 AF 48 8D 44 24 40 48 8B F8 33 C0 B9 01 00 00 00 F3 AA 41 B9 48 00 00 00 4C 8D 05 ?? ?? ?? ?? 0F B6 54 24 40 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 89 44 24 68 48 8B 44 24 68 48 89 44 24 48 4C 8D 4C 24 50 45 33 C0 BA 01 00 00 00 48 8B 4C 24 48 E8 ?? ?? ?? ?? 85 C0 75 30 FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B D0 48 8D 8C 24 B8 00 00 00 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 8C 24 B8 00 00 00 E8 ?? ?? ?? ?? 48 C7 44 24 30 00 00 00 00 48 C7 44 24 28 00 00 00 00 48 C7 44 24 20 18 00 00 00 4C 8D 8C 24 80 00 00 00 41 B8 06 00 03 00 33 D2 48 8B 4C 24 48 E8 ?? ?? ?? ?? 85 C0 75 30 FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B D0 48 8D 8C 24 F8 00 00 00 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 8C 24 F8 00 00 00 E8 ?? ?? ?? ?? 48 8B 84 24 70 01 00 00 48 05 94 00 00 00 48 89 44 24 78 8B 8C 24 88 01 00 00 69 C9 00 04 00 00 8B C9 48 89 4C 24 60 FF 15 ?? ?? ?? ?? 48 8B 4C 24 78 48 89 4C 24 38 48 8B 4C 24 48 48 89 4C 24 30 C7 44 24 28 00 00 01 00 48 8B 8C 24 70 01 00 00 48 89 4C 24 20 4C 8D 0D ?? ?? ?? ?? 48 8B 4C 24 60 4C 8B C1 33 D2 48 8B C8 E8 ?? ?? ?? ?? 48 8B 8C 24 70 01 00 00 48 89 41 28 48 8B 4C 24 48 E8 ?? ?? ?? ?? 48 8B 44 24 48 48 89 44 24 58 48 8B 4C 24 58 E8 ?? ?? ?? ?? 48 8B 84 24 70 01 00 00 48 83 78 28 00 75 53 48 8B 84 24 70 01 00 00 48 8B 48 20 E8 ?? ?? ?? ?? 48 8B 84 24 70 01 00 00 48 8B 48 30 FF 15 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B D0 48 8D 8C 24 38 01 00 00 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 8C 24 38 01 00 00 E8 ?? ?? ?? ?? 48 8B 84 24 70 01 00 00 48 81 C4 60 01 00 00 5F C3 }
	condition:
		$1
}

rule file_86_9_0 {
	meta:
		name = "??1UMSThreadProxy@details@Concurrency@@UEAA@XZ"
		size = 351
		refs = "0011 ??_7UMSThreadProxy@details@Concurrency@@6BUMSBaseObject@12@@ 0020 ??_7UMSThreadProxy@details@Concurrency@@6BIUMSThreadProxy@2@@ 0030 ??_7UMSThreadProxy@details@Concurrency@@6BIUMSUnblockNotification@2@@ 0047 ??_C@_1BM@EMPCBBNC@?$AAm?$AA_?$AAh?$AAB?$AAl?$AAo?$AAc?$AAk?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 0053 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0068 ??_C@_1HO@LBEPJECD@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 0072 _CrtDbgReportW 0095 __imp_CloseHandle 00a8 ??_C@_1DA@BDEENCBC@?$AAm?$AA_?$AAh?$AAP?$AAh?$AAy?$AAs?$AAi?$AAc?$AAa?$AAl?$AAC?$AAo?$AAn?$AAt?$AAe?$AAx?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 0109 ??_C@_1CG@HCNJBFKP@?$AAm?$AA_?$AAp?$AAU?$AAM?$AAS?$AAC?$AAo?$AAn?$AAt?$AAe?$AAx?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 0156 ?DeleteUmsThreadContext@UMS@details@Concurrency@@SAHPEAX@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 48 08 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 48 10 48 8B 44 24 40 48 83 78 30 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 6E 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 33 C0 85 C0 75 B4 33 C0 85 C0 75 AE 48 8B 44 24 40 48 8B 48 30 FF 15 ?? ?? ?? ?? 48 8B 44 24 40 48 83 78 28 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 71 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 33 C0 85 C0 75 B4 33 C0 85 C0 75 AE 48 8B 44 24 40 48 8B 48 28 FF 15 ?? ?? ?? ?? 48 8B 44 24 40 48 83 78 20 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 74 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 33 C0 85 C0 75 B4 33 C0 85 C0 75 AE 48 8B 44 24 40 48 8B 48 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_86_20_0 {
	meta:
		name = "?Cancel@UMSThreadProxy@details@Concurrency@@QEAAXXZ"
		size = 18
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 C7 40 78 01 00 00 00 C3 }
	condition:
		$1
}

rule file_86_21_0 {
	meta:
		name = "?Deactivate@UMSThreadProxy@details@Concurrency@@IEAA_NXZ"
		size = 316
		refs = "003a ??_C@_0DP@NLADCDMJ@f?3?2dd?2vctools?2crt_bld?2self_64_am@ 0041 ??_C@_0DB@LMDFMBBJ@GetCriticalRegionType?$CI?$CJ?5?$CB?$DN?5Outsi@ 0046 ?_ConcRT_CoreAssert@details@Concurrency@@YAXPEBD0H@Z 006a ??_C@_0BA@FLMGJFBL@m_pRoot?5?$CB?$DN?5NULL?$AA@ 00b4 ?UmsThreadYield@UMS@details@Concurrency@@SAHPEAX@Z 00d5 ??_C@_0CJ@GEEJDKLD@m_activationCause?5?$CB?$DN?5ActivationC@"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 48 48 8B 44 24 50 48 83 C0 08 48 8B 4C 24 50 48 8B 49 08 48 89 4C 24 28 48 8B C8 48 8B 44 24 28 FF 50 40 85 C0 74 02 EB 19 41 B8 5E 01 00 00 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 44 24 50 48 8B 40 40 48 85 C0 74 02 EB 19 41 B8 5F 01 00 00 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 44 24 50 48 83 C0 08 48 8B 4C 24 50 48 8B 49 08 48 89 4C 24 30 48 8B C8 48 8B 44 24 30 FF 50 30 48 8B 44 24 50 C7 40 5C 05 00 00 00 48 8B 44 24 50 48 C7 40 60 00 00 00 00 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 8B 44 24 50 83 78 70 00 74 02 EB 19 41 B8 6B 01 00 00 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 44 24 50 83 78 70 01 75 0A C7 44 24 24 01 00 00 00 EB 08 C7 44 24 24 00 00 00 00 0F B6 44 24 24 88 44 24 20 48 8B 44 24 50 C7 40 70 00 00 00 00 48 8B 44 24 50 48 83 C0 08 48 8B 4C 24 50 48 8B 49 08 48 89 4C 24 38 48 8B C8 48 8B 44 24 38 FF 50 38 0F B6 44 24 20 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_86_27_0 {
	meta:
		name = "?FreeViaExit@UMSThreadProxy@details@Concurrency@@IEAAXXZ"
		size = 110
		refs = "0043 ??_C@_0DP@NLADCDMJ@f?3?2dd?2vctools?2crt_bld?2self_64_am@ 004a ??_C@_0P@GDJNMJMI@?$CBm_fIdlePooled?$AA@ 004f ?_ConcRT_CoreAssert@details@Concurrency@@YAXPEBD0H@Z 0065 ?UmsThreadYield@UMS@details@Concurrency@@SAHPEAX@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 48 83 C0 08 48 8B 4C 24 40 48 8B 49 08 48 89 4C 24 20 48 8B C8 48 8B 44 24 20 FF 50 30 48 8B 44 24 40 0F B6 40 58 85 C0 75 02 EB 19 41 B8 7F 01 00 00 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 44 24 40 C7 40 5C 06 00 00 00 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_86_28_0 {
	meta:
		name = "?FromListEntry@UMSThreadProxy@details@Concurrency@@SAPEAV123@PEAU_SLIST_ENTRY@@@Z"
		size = 30
	strings:
		$1 = { 48 89 4C 24 08 48 83 7C 24 08 00 75 04 33 C0 EB 0B 48 8B 44 24 08 48 2D A0 00 00 00 F3 C3 }
	condition:
		$1
}

rule file_86_29_0 {
	meta:
		name = "?FromUMSContext@UMSThreadProxy@details@Concurrency@@SAPEAV123@PEAX@Z"
		size = 260
		refs = "0050 ?QueryUmsThreadInformation@UMS@details@Concurrency@@SAHPEAXW4_RTL_UMS_THREAD_INFO_CLASS@@0KPEAK@Z 005a __imp_GetLastError 0061 HRESULT_FROM_WIN32 006d ??0scheduler_resource_allocation_error@Concurrency@@QEAA@J@Z 0074 _TI2?AVscheduler_resource_allocation_error@Concurrency@@ 007e _CxxThrowException 008f ??_C@_1DK@FPDPMLPO@?$AAr?$AAe?$AAt?$AAu?$AAr?$AAn?$AAL?$AAe?$AAn?$AAg?$AAt?$AAh?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAs?$AAi?$AAz?$AAe?$AAo?$AAf?$AA?$CI?$AAp?$AAO?$AAb?$AAj?$AA?$CJ?$AA?$AA@ 009b ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 00b0 ??_C@_1HO@LBEPJECD@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 00ba _CrtDbgReportW"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 83 BC 24 80 00 00 00 00 75 07 33 C0 E9 E4 00 00 00 48 C7 44 24 38 00 00 00 00 48 C7 44 24 40 00 00 00 00 48 8D 44 24 30 48 89 44 24 20 41 B9 08 00 00 00 4C 8D 44 24 38 BA 01 00 00 00 48 8B 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 85 C0 75 2A FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B D0 48 8D 4C 24 48 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 48 E8 ?? ?? ?? ?? 8B 44 24 30 48 83 F8 08 74 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 BC 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 33 C0 85 C0 75 B6 33 C0 85 C0 75 B0 48 83 7C 24 38 00 74 20 48 8B 44 24 38 48 8B 00 48 8B 4C 24 38 FF 10 0F B6 C0 85 C0 75 0A 48 8B 44 24 38 48 89 44 24 40 48 8B 44 24 40 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_86_32_0 {
	meta:
		name = "?GetExecutingProxy@UMSFreeVirtualProcessorRoot@details@Concurrency@@QEAAPEAVUMSThreadProxy@23@XZ"
		size = 18
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 8B 80 B0 00 00 00 C3 }
	condition:
		$1
}

rule file_86_33_0 {
	meta:
		name = "?GetId@UMSThreadProxy@details@Concurrency@@UEBAIXZ"
		size = 17
		altNames = "?GetThreadId@ExternalContextBase@details@Concurrency@@UEBAKXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 8B 80 80 00 00 00 C3 }
	condition:
		$1
}

rule file_86_35_0 {
	meta:
		name = "?GetThreadProxyId@ResourceManager@details@Concurrency@@SAIXZ"
		size = 21
		refs = "0003 ?s_threadProxyIdCount@ResourceManager@details@Concurrency@@0JC"
	strings:
		$1 = { 48 8D 05 ?? ?? ?? ?? B9 01 00 00 00 F0 0F C1 08 FF C1 8B C1 C3 }
	condition:
		$1
}

rule file_171_120_0 {
	meta:
		name = "?GetExecutionContextId@ResourceManager@details@Concurrency@@SAIXZ"
		size = 21
		refs = "0003 ?s_executionContextIdCount@ResourceManager@details@Concurrency@@0JC"
	strings:
		$1 = { 48 8D 05 ?? ?? ?? ?? B9 01 00 00 00 F0 0F C1 08 FF C1 8B C1 C3 }
	condition:
		$1
}

rule file_439_271_0 {
	meta:
		name = "?GetNewWorkQueueId@SchedulerBase@details@Concurrency@@SAIXZ"
		size = 21
		refs = "0003 ?s_workQueueIdCounter@SchedulerBase@details@Concurrency@@0JC"
	strings:
		$1 = { 48 8D 05 ?? ?? ?? ?? B9 01 00 00 00 F0 0F C1 08 FF C1 8B C1 C3 }
	condition:
		$1
}

rule file_171_150_0 {
	meta:
		name = "?GetSchedulerId@ResourceManager@details@Concurrency@@SAIXZ"
		size = 21
		refs = "0003 ?s_schedulerIdCount@ResourceManager@details@Concurrency@@0JC"
	strings:
		$1 = { 48 8D 05 ?? ?? ?? ?? B9 01 00 00 00 F0 0F C1 08 FF C1 8B C1 C3 }
	condition:
		$1
}

rule file_742_23_0 {
	meta:
		name = "?ReferenceStaticOneShot@SchedulerBase@details@Concurrency@@SAJXZ"
		size = 21
		refs = "0003 ?s_oneShotInitializationState@SchedulerBase@details@Concurrency@@0JA"
	strings:
		$1 = { 48 8D 05 ?? ?? ?? ?? B9 01 00 00 00 F0 0F C1 08 FF C1 8B C1 C3 }
	condition:
		$1
}

rule file_105_581_1 {
	meta:
		name = "?_GetNextAsyncId@details@Concurrency@@YAIXZ"
		size = 21
		refs = "0003 s_asyncId"
	strings:
		$1 = { 48 8D 05 ?? ?? ?? ?? B9 01 00 00 00 F0 0F C1 08 FF C1 8B C1 C3 }
	condition:
		$1
}

rule file_86_37_0 {
	meta:
		name = "?InternalSwitchOut@UMSThreadProxy@details@Concurrency@@IEAAXW4SwitchingProxyState@3@@Z"
		size = 276
		refs = "004f ??_C@_0DP@NLADCDMJ@f?3?2dd?2vctools?2crt_bld?2self_64_am@ 0056 ??_C@_0BO@INMGKHCF@m_pTransmogrification?5?$DN?$DN?5NULL?$AA@ 005b ?_ConcRT_CoreAssert@details@Concurrency@@YAXPEBD0H@Z 0065 ?RequestTransmogrification@UMSThreadProxy@details@Concurrency@@IEAAXXZ 0088 ?UmsThreadYield@UMS@details@Concurrency@@SAHPEAX@Z 00a7 ??_C@_0BI@EMBEECGG@switchState?5?$DN?$DN?5Blocking?$AA@"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 48 83 C0 08 48 8B 4C 24 40 48 8B 49 08 48 89 4C 24 20 48 8B C8 48 8B 44 24 20 FF 50 30 83 7C 24 48 02 75 58 48 8B 44 24 40 48 8B 40 68 48 85 C0 75 02 EB 19 41 B8 1E 01 00 00 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 44 24 40 C7 40 5C 04 00 00 00 48 8B 44 24 40 48 C7 40 60 00 00 00 00 48 8B 4C 24 40 E8 ?? ?? ?? ?? EB 5F 83 7C 24 48 01 75 02 EB 19 41 B8 2E 01 00 00 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 44 24 40 48 8B 40 68 48 85 C0 74 19 48 8B 44 24 40 48 C7 40 68 00 00 00 00 48 8B 4C 24 40 E8 ?? ?? ?? ?? EB 16 48 8B 44 24 40 C7 40 5C 07 00 00 00 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 44 24 40 48 83 C0 08 48 8B 4C 24 40 48 8B 49 08 48 89 4C 24 28 48 8B C8 48 8B 44 24 28 FF 50 38 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_86_38_0 {
	meta:
		name = "?InternalSwitchTo@UMSThreadProxy@details@Concurrency@@IEAAXPEAV123@W4SwitchingProxyState@3@@Z"
		size = 464
		refs = "0016 __security_cookie 007c ??_C@_0DP@NLADCDMJ@f?3?2dd?2vctools?2crt_bld?2self_64_am@ 0083 ??_C@_0BO@INMGKHCF@m_pTransmogrification?5?$DN?$DN?5NULL?$AA@ 0088 ?_ConcRT_CoreAssert@details@Concurrency@@YAXPEBD0H@Z 0092 ?RequestTransmogrification@UMSThreadProxy@details@Concurrency@@IEAAXXZ 00b6 ??_C@_0CP@INFNHJJD@?$CIint?$CJswitchState?5?$DO?$DN?50?5?$CG?$CG?5?$CIint?$CJsw@ 00fb ??_C@_0BM@KNFFHNPB@m_yieldAction?5?$CB?$DN?5ActionNone?$AA@ 0130 ?GetExecutingProxy@UMSFreeVirtualProcessorRoot@details@Concurrency@@QEAAPEAVUMSThreadProxy@23@XZ 014d ??_C@_0FC@CGDDJHHA@m_pRoot?5?$CB?$DN?5NULL?5?$CG?$CG?5m_pRoot?5?$DN?$DN?5m_@ 015c ?UmsThreadYield@UMS@details@Concurrency@@SAHPEAX@Z 01b5 ??_C@_0CP@JOFLDPOI@m_hyperCriticalRegionCount?5?$DN?$DN?50?5@ 01c7 __security_check_cookie"
	strings:
		$1 = { 44 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 58 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 40 C7 44 24 30 02 00 00 00 C7 44 24 34 01 00 00 00 C7 44 24 38 03 00 00 00 48 8B 44 24 60 48 83 C0 08 48 8B 4C 24 60 48 8B 49 08 48 89 4C 24 28 48 8B C8 48 8B 44 24 28 FF 50 30 83 7C 24 70 02 75 33 48 8B 44 24 60 48 8B 40 68 48 85 C0 75 02 EB 19 41 B8 F3 00 00 00 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 4C 24 60 E8 ?? ?? ?? ?? 83 7C 24 70 00 7C 09 83 7C 24 70 02 7F 02 EB 19 41 B8 FC 00 00 00 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 63 44 24 70 48 8B 4C 24 60 8B 44 84 30 89 41 5C 48 8B 44 24 60 48 8B 4C 24 68 48 89 48 60 48 8B 44 24 60 83 78 5C 00 74 02 EB 19 41 B8 FF 00 00 00 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 44 24 60 48 8B 40 40 48 85 C0 74 2B 48 8B 44 24 60 48 8B 40 40 48 8B 4C 24 60 48 3B 41 48 75 17 48 8B 44 24 60 48 8B 48 40 E8 ?? ?? ?? ?? 48 3B 44 24 60 75 02 EB 19 41 B8 00 01 00 00 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 4C 24 60 E8 ?? ?? ?? ?? 83 7C 24 70 00 74 24 48 8B 44 24 60 48 83 C0 08 48 8B 4C 24 60 48 8B 49 08 48 89 4C 24 20 48 8B C8 48 8B 44 24 20 FF 50 38 EB 33 48 8B 44 24 60 83 B8 90 00 00 00 00 74 25 48 8B 44 24 60 8B 40 78 85 C0 75 19 41 B8 10 01 00 00 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 4C 24 40 48 33 CC E8 ?? ?? ?? ?? 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_86_39_0 {
	meta:
		name = "?InternalYieldToSystem@UMSThreadProxy@details@Concurrency@@IEAAXXZ"
		size = 276
		refs = "000a ?GetCurrent@UMSThreadProxy@details@Concurrency@@SAPEAV123@XZ 0020 ??_C@_0DP@NLADCDMJ@f?3?2dd?2vctools?2crt_bld?2self_64_am@ 0027 ??_C@_0CF@CMDNGDOH@UMSThreadProxy?3?3GetCurrent?$CI?$CJ?5?$DN?$DN?5@ 002c ?_ConcRT_CoreAssert@details@Concurrency@@YAXPEBD0H@Z 0088 ??_C@_0BM@KNFFHNPB@m_yieldAction?5?$CB?$DN?5ActionNone?$AA@ 00bd ?GetExecutingProxy@UMSFreeVirtualProcessorRoot@details@Concurrency@@QEAAPEAVUMSThreadProxy@23@XZ 00da ??_C@_0FC@CGDDJHHA@m_pRoot?5?$CB?$DN?5NULL?5?$CG?$CG?5m_pRoot?5?$DN?$DN?5m_@ 00e9 ?UmsThreadYield@UMS@details@Concurrency@@SAHPEAX@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 E8 ?? ?? ?? ?? 48 3B 44 24 40 75 02 EB 19 41 B8 47 01 00 00 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 44 24 40 48 83 C0 08 48 8B 4C 24 40 48 8B 49 08 48 89 4C 24 20 48 8B C8 48 8B 44 24 20 FF 50 30 48 8B 44 24 40 C7 40 5C 09 00 00 00 48 8B 44 24 40 48 C7 40 60 00 00 00 00 48 8B 44 24 40 83 78 5C 00 74 02 EB 19 41 B8 4D 01 00 00 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 44 24 40 48 8B 40 40 48 85 C0 74 2B 48 8B 44 24 40 48 8B 40 40 48 8B 4C 24 40 48 3B 41 48 75 17 48 8B 44 24 40 48 8B 48 40 E8 ?? ?? ?? ?? 48 3B 44 24 40 75 02 EB 19 41 B8 4E 01 00 00 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 44 24 40 48 83 C0 08 48 8B 4C 24 40 48 8B 49 08 48 89 4C 24 28 48 8B C8 48 8B 44 24 28 FF 50 38 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_86_40_0 {
	meta:
		name = "?IsDeleting@UMSFreeVirtualProcessorRoot@details@Concurrency@@QEBA_NXZ"
		size = 18
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 0F B6 80 C2 00 00 00 C3 }
	condition:
		$1
}

rule file_86_42_0 {
	meta:
		name = "?IsSuspended@UMSThreadProxy@details@Concurrency@@QEAA_NXZ"
		size = 90
		refs = "0031 ?QueryUmsThreadInformation@UMS@details@Concurrency@@SAHPEAXW4_RTL_UMS_THREAD_INFO_CLASS@@0KPEAK@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 48 C6 44 24 30 00 48 C7 44 24 20 00 00 00 00 41 B9 01 00 00 00 4C 8D 44 24 30 BA 05 00 00 00 48 8B 44 24 50 48 8B 48 20 E8 ?? ?? ?? ?? 0F B6 44 24 30 85 C0 74 0A C7 44 24 34 01 00 00 00 EB 08 C7 44 24 34 00 00 00 00 0F B6 44 24 34 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_86_43_0 {
	meta:
		name = "?IsTerminated@UMSThreadProxy@details@Concurrency@@QEAA_NXZ"
		size = 90
		refs = "0031 ?QueryUmsThreadInformation@UMS@details@Concurrency@@SAHPEAXW4_RTL_UMS_THREAD_INFO_CLASS@@0KPEAK@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 48 C6 44 24 30 00 48 C7 44 24 20 00 00 00 00 41 B9 01 00 00 00 4C 8D 44 24 30 BA 06 00 00 00 48 8B 44 24 50 48 8B 48 20 E8 ?? ?? ?? ?? 0F B6 44 24 30 85 C0 74 0A C7 44 24 34 01 00 00 00 EB 08 C7 44 24 34 00 00 00 00 0F B6 44 24 34 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_86_44_0 {
	meta:
		name = "?NotifyTransmogrification@UMSThreadProxy@details@Concurrency@@QEAAXXZ"
		size = 132
		refs = "0020 ??_C@_0DP@NLADCDMJ@f?3?2dd?2vctools?2crt_bld?2self_64_am@ 0027 ??_C@_0BD@MCNDDNMG@m_pFactory?5?$CB?$DN?5NULL?$AA@ 002c ?_ConcRT_CoreAssert@details@Concurrency@@YAXPEBD0H@Z 0044 ?GetTransmogrificator@UMSFreeThreadProxyFactory@details@Concurrency@@QEAAPEAVTransmogrificator@23@XZ 0067 ??_C@_0BL@IDGBDMJ@pTransmogrificator?5?$CB?$DN?5NULL?$AA@ 007b ?UnblockTransmogrification@Transmogrificator@details@Concurrency@@QEAAXPEAVUMSThreadProxy@23@@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 48 83 78 18 00 74 02 EB 19 41 B8 DF 01 00 00 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 44 24 40 48 8B 40 18 48 89 44 24 28 48 8B 4C 24 28 E8 ?? ?? ?? ?? 48 89 44 24 20 48 83 7C 24 20 00 74 02 EB 19 41 B8 E3 01 00 00 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 54 24 40 48 8B 4C 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_86_45_0 {
	meta:
		name = "?PrepareToRun@UMSThreadProxy@details@Concurrency@@IEAAXPEAVUMSFreeVirtualProcessorRoot@23@@Z"
		size = 72
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 0F 31 48 C1 E2 20 48 0B C2 48 8B 4C 24 08 48 89 81 E8 00 00 00 48 8B 44 24 08 C7 40 38 00 00 00 00 48 8B 44 24 08 48 8B 4C 24 10 48 89 48 48 48 8B 44 24 08 48 8B 4C 24 10 48 89 48 40 C3 }
	condition:
		$1
}

rule file_86_46_0 {
	meta:
		name = "?ReadyForDispatch@UMSThreadProxy@details@Concurrency@@AEAAXXZ"
		size = 70
		refs = "003d ?UmsThreadYield@UMS@details@Concurrency@@SAHPEAX@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 48 83 C0 08 48 8B 4C 24 40 48 8B 49 08 48 89 4C 24 20 48 8B C8 48 8B 44 24 20 FF 50 30 48 8B 44 24 40 C7 40 5C 08 00 00 00 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_86_47_0 {
	meta:
		name = "?RequestTransmogrification@UMSThreadProxy@details@Concurrency@@IEAAXXZ"
		size = 132
		refs = "0020 ??_C@_0DP@NLADCDMJ@f?3?2dd?2vctools?2crt_bld?2self_64_am@ 0027 ??_C@_0BD@MCNDDNMG@m_pFactory?5?$CB?$DN?5NULL?$AA@ 002c ?_ConcRT_CoreAssert@details@Concurrency@@YAXPEBD0H@Z 0044 ?GetTransmogrificator@UMSFreeThreadProxyFactory@details@Concurrency@@QEAAPEAVTransmogrificator@23@XZ 0067 ??_C@_0BL@IDGBDMJ@pTransmogrificator?5?$CB?$DN?5NULL?$AA@ 007b ?PerformTransmogrification@Transmogrificator@details@Concurrency@@QEAAXPEAVUMSThreadProxy@23@@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 48 83 78 18 00 74 02 EB 19 41 B8 D2 01 00 00 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 44 24 40 48 8B 40 18 48 89 44 24 28 48 8B 4C 24 28 E8 ?? ?? ?? ?? 48 89 44 24 20 48 83 7C 24 20 00 74 02 EB 19 41 B8 D6 01 00 00 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 54 24 40 48 8B 4C 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_86_48_0 {
	meta:
		name = "?SetPriority@UMSThreadProxy@details@Concurrency@@QEAAXH@Z"
		size = 99
		refs = "002c __imp_SetThreadPriority 0036 __imp_GetLastError 003d HRESULT_FROM_WIN32 0049 ??0scheduler_resource_allocation_error@Concurrency@@QEAA@J@Z 0050 _TI2?AVscheduler_resource_allocation_error@Concurrency@@ 005a _CxxThrowException"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 48 48 8B 44 24 50 8B 4C 24 58 89 48 54 48 8B 44 24 50 8B 50 54 48 8B 44 24 50 48 8B 48 28 FF 15 ?? ?? ?? ?? 85 C0 75 2A FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B D0 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_86_49_0 {
	meta:
		name = "?SpinOnAndReturnBlockingType@UMSThreadProxy@details@Concurrency@@IEAA?AW4BlockingType@123@XZ"
		size = 73
		refs = "0018 ?_Sleep0@details@Concurrency@@YAXXZ 0022 ??0?$_SpinWait@$00@details@Concurrency@@QEAA@P6AXXZ@Z 002c ?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QEAA_NXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 48 48 8B 44 24 50 8B 40 38 85 C0 75 27 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 50 8B 40 38 85 C0 74 EA 48 8B 44 24 50 8B 40 38 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_86_50_0 {
	meta:
		name = "?SpinUntilBlocked@UMSThreadProxy@details@Concurrency@@IEAAXXZ"
		size = 69
		refs = "001a ?_Sleep0@details@Concurrency@@YAXXZ 0024 ??0?$_SpinWait@$00@details@Concurrency@@QEAA@P6AXXZ@Z 002e ?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QEAA_NXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 48 48 8B 44 24 50 48 8B 40 40 48 85 C0 74 29 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 8B 40 40 48 85 C0 75 E8 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_86_51_0 {
	meta:
		name = "?UMSThreadProxyMain@UMSThreadProxy@details@Concurrency@@CAKPEAX@Z"
		size = 218
		refs = "0019 ?ReadyForDispatch@UMSThreadProxy@details@Concurrency@@AEAAXXZ 004d ?IsDeleting@UMSFreeVirtualProcessorRoot@details@Concurrency@@QEBA_NXZ 0061 ??_C@_0DP@NLADCDMJ@f?3?2dd?2vctools?2crt_bld?2self_64_am@ 0068 ??_C@_0GG@JPPLLLJC@pThreadProxy?9?$DOGetCriticalRegionT@ 006d ?_ConcRT_CoreAssert@details@Concurrency@@YAXPEBD0H@Z 0090 ??_C@_1DE@ODNKHOPH@?$AAp?$AAT?$AAh?$AAr?$AAe?$AAa?$AAd?$AAP?$AAr?$AAo?$AAx?$AAy?$AA?9?$AA?$DO?$AAm?$AA_?$AAf?$AAC?$AAa?$AAn?$AAc?$AAe?$AAl?$AAe?$AAd?$AA?$AA@ 009c ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 00b1 ??_C@_1HO@LBEPJECD@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 00bb _CrtDbgReportW"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 48 48 8B 44 24 50 48 89 44 24 30 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C0 08 48 8B 4C 24 30 48 8B 49 08 48 89 4C 24 38 48 8B C8 48 8B 44 24 38 FF 50 40 85 C0 74 2E 48 8B 44 24 30 48 8B 48 40 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 19 41 B8 8C 00 00 00 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8B 00 48 8B 4C 24 30 FF 50 10 48 8B 44 24 30 8B 40 78 85 C0 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 8F 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 33 C0 85 C0 75 B4 33 C0 85 C0 75 AE 33 C0 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_87_1_0 {
	meta:
		name = "??0UMSThreadInternalContext@details@Concurrency@@QEAA@PEAVSchedulerBase@12@@Z"
		size = 85
		refs = "0019 ??0InternalContextBase@details@Concurrency@@QEAA@PEAVSchedulerBase@12@@Z 0025 ??_7UMSThreadInternalContext@details@Concurrency@@6BIExecutionContext@2@@ 0034 ??_7UMSThreadInternalContext@details@Concurrency@@6BContextBase@12@@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 48 10 48 8B 44 24 30 C7 80 80 01 00 00 00 00 00 00 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_87_5_0 {
	meta:
		name = "??1UMSThreadInternalContext@details@Concurrency@@UEAA@XZ"
		size = 55
		refs = "0011 ??_7UMSThreadInternalContext@details@Concurrency@@6BIExecutionContext@2@@ 0020 ??_7UMSThreadInternalContext@details@Concurrency@@6BContextBase@12@@ 002e ??1InternalContextBase@details@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 48 10 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1076_6_0 {
	meta:
		name = "??1ThreadInternalContext@details@Concurrency@@UEAA@XZ"
		size = 55
		refs = "0011 ??_7ThreadInternalContext@details@Concurrency@@6BIExecutionContext@2@@ 0020 ??_7ThreadInternalContext@details@Concurrency@@6BContextBase@12@@ 002e ??1InternalContextBase@details@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 48 10 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_87_14_0 {
	meta:
		name = "?Block@UMSThreadInternalContext@details@Concurrency@@UEAAXXZ"
		size = 559
		refs = "0012 ?EnterCriticalRegion@ContextBase@details@Concurrency@@QEAAHXZ 0042 ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPEAVContextBase@23@XZ 0050 ??_C@_1FI@CKINOG@?$AAt?$AAh?$AAi?$AAs?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAS?$AAc?$AAh?$AAe?$AAd?$AAu?$AAl?$AAe?$AAr?$AAB?$AAa?$AAs?$AAe?$AA?3?$AA?3?$AAF?$AAa?$AAs?$AAt?$AAC?$AAu?$AAr?$AAr?$AAe@ 005c ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0071 ??_C@_1JC@HGLGKHD@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 007b _CrtDbgReportW 00a0 ?_GetVirtualProcessor@InternalContextBase@details@Concurrency@@IEBAPEAVVirtualProcessor@23@XZ 00ac ??_C@_1DC@PAMPGHKM@?$AAm?$AA_?$AAp?$AAV?$AAi?$AAr?$AAt?$AAu?$AAa?$AAl?$AAP?$AAr?$AAo?$AAc?$AAe?$AAs?$AAs?$AAo?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 0124 ?TraceContextEvent@ContextBase@details@Concurrency@@IEAAXW4ConcRT_EventType@3@EKK@Z 013d ?IsMarkedForRetirement@VirtualProcessor@details@Concurrency@@QEAA_NXZ 01a0 ?SwitchOut@InternalContextBase@details@Concurrency@@IEAA_NW4ReasonForSwitch@123@@Z 0219 ?SwitchTo@InternalContextBase@details@Concurrency@@IEAAXPEAV123@W4ReasonForSwitch@123@@Z 0226 ?ExitCriticalRegion@ContextBase@details@Concurrency@@QEAAHXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 58 48 8B 44 24 60 48 8B C8 E8 ?? ?? ?? ?? 48 8B 44 24 60 48 83 E8 10 48 85 C0 74 14 48 8B 44 24 60 48 83 E8 10 48 83 C0 10 48 89 44 24 30 EB 09 48 C7 44 24 30 00 00 00 00 E8 ?? ?? ?? ?? 48 39 44 24 30 74 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 4D 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 33 C0 85 C0 75 89 33 C0 85 C0 75 83 48 8B 44 24 60 48 83 E8 10 48 8B C8 E8 ?? ?? ?? ?? 48 85 C0 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 4E 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 33 C0 85 C0 75 AA 33 C0 85 C0 75 A4 48 8B 44 24 60 48 8B 40 38 48 8B 4C 24 60 48 8B 49 38 48 8B 00 FF 50 08 48 8B 4C 24 60 48 8B 54 24 60 8B 52 20 89 54 24 20 44 8B C8 41 B0 04 BA 03 00 00 00 E8 ?? ?? ?? ?? 48 8B 44 24 60 48 83 E8 10 48 8B C8 E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 76 48 8B 44 24 60 48 83 C0 54 B9 01 00 00 00 F0 0F C1 08 FF C1 8B C1 83 F8 01 75 43 48 8B 44 24 60 48 83 C0 54 B9 02 00 00 00 48 89 44 24 38 B8 01 00 00 00 48 8B 54 24 38 48 8B 54 24 38 F0 0F B1 0A 83 F8 01 75 18 48 8B 44 24 60 48 83 E8 10 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? EB 16 48 8B 44 24 60 48 83 E8 10 BA 02 00 00 00 48 8B C8 E8 ?? ?? ?? ?? EB 5F 48 8B 44 24 60 48 83 C0 54 B9 01 00 00 00 F0 0F C1 08 FF C1 8B C1 83 F8 01 75 44 48 8B 44 24 60 48 83 C0 54 B9 02 00 00 00 48 89 44 24 40 B8 01 00 00 00 48 8B 54 24 40 48 8B 54 24 40 F0 0F B1 0A 83 F8 01 75 19 48 8B 44 24 60 48 83 E8 10 41 B8 01 00 00 00 33 D2 48 8B C8 E8 ?? ?? ?? ?? 48 8B 44 24 60 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_87_15_0 {
	meta:
		name = "?CanCriticalEnter@UMSThreadVirtualProcessor@details@Concurrency@@QEAA_NXZ"
		size = 49
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 18 48 8B 44 24 20 48 83 B8 60 01 00 00 00 75 09 C7 04 24 01 00 00 00 EB 07 C7 04 24 00 00 00 00 0F B6 04 24 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_87_16_0 {
	meta:
		name = "?Dispatch@UMSThreadInternalContext@details@Concurrency@@UEAAXPEAUDispatchState@3@@Z"
		size = 102
		refs = "0042 ??_C@_0EJ@FLFMGEDK@f?3?2dd?2vctools?2crt_bld?2self_64_am@ 0049 ??_C@_0DB@DDJEDPDL@GetCriticalRegionType?$CI?$CJ?5?$DN?$DN?5Outsi@ 004e ?_ConcRT_CoreAssert@details@Concurrency@@YAXPEBD0H@Z 005d ?Dispatch@InternalContextBase@details@Concurrency@@UEAAXPEAUDispatchState@3@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 48 83 C0 10 48 8B 4C 24 40 48 8B 49 10 48 89 4C 24 20 48 8B C8 48 8B 44 24 20 FF 90 80 00 00 00 85 C0 75 02 EB 19 41 B8 8A 00 00 00 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_87_17_0 {
	meta:
		name = "?EnterCriticalRegionHelper@ContextBase@details@Concurrency@@UEAAHXZ"
		size = 83
		refs = "000a ?CurrentContext@Context@Concurrency@@SAPEAV12@XZ 0020 ??_C@_0DK@HANMFGFF@f?3?2dd?2vctools?2crt_bld?2self_64_am@ 0027 ??_C@_0CC@DPOLDNHN@Context?3?3CurrentContext?$CI?$CJ?5?$DN?$DN?5thi@ 002c ?_ConcRT_CoreAssert@details@Concurrency@@YAXPEBD0H@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 E8 ?? ?? ?? ?? 48 3B 44 24 40 75 02 EB 19 41 B8 92 00 00 00 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 44 24 40 8B 40 24 FF C0 89 44 24 20 48 8B 44 24 40 8B 4C 24 20 89 48 24 8B 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_87_18_0 {
	meta:
		name = "?EnterCriticalRegionHelper@UMSThreadInternalContext@details@Concurrency@@UEAAHXZ"
		size = 240
		refs = "0025 ??_C@_0EJ@FLFMGEDK@f?3?2dd?2vctools?2crt_bld?2self_64_am@ 002c ??_C@_0BH@MFNLHCGI@m_pThreadProxy?5?$CB?$DN?5NULL?$AA@ 0031 ?_ConcRT_CoreAssert@details@Concurrency@@YAXPEBD0H@Z 0051 ?EnterCriticalRegionHelper@ContextBase@details@Concurrency@@UEAAHXZ 0092 ?_GetVirtualProcessor@InternalContextBase@details@Concurrency@@IEBAPEAVVirtualProcessor@23@XZ 00a9 ?CanCriticalEnter@UMSThreadVirtualProcessor@details@Concurrency@@QEAA_NXZ 00da __imp_Sleep"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 48 48 8B 44 24 50 48 8B 80 F0 00 00 00 48 85 C0 74 02 EB 19 41 B8 96 00 00 00 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 44 24 20 00 00 00 00 33 C0 83 F8 01 0F 84 9F 00 00 00 48 8B 44 24 50 48 8B C8 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 8B 80 F0 00 00 00 48 89 44 24 28 48 8B 44 24 28 48 8B 00 48 8B 4C 24 28 FF 50 20 89 44 24 20 48 8B 44 24 50 83 78 24 01 75 5B 48 8B 44 24 50 48 83 E8 10 48 8B C8 E8 ?? ?? ?? ?? 48 89 44 24 30 48 83 7C 24 30 00 74 11 48 8B 4C 24 30 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 02 EB 31 48 8B 44 24 50 48 8B 4C 24 50 48 8B 09 48 89 4C 24 38 48 8B C8 48 8B 44 24 38 FF 50 70 B9 01 00 00 00 FF 15 ?? ?? ?? ?? EB 02 EB 05 E9 56 FF FF FF 8B 44 24 20 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_87_19_0 {
	meta:
		name = "?EnterHyperCriticalRegionHelper@ContextBase@details@Concurrency@@UEAAHXZ"
		size = 59
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 18 48 8B 44 24 20 8B 40 24 FF C0 48 8B 4C 24 20 89 41 24 48 8B 44 24 20 8B 40 28 FF C0 89 04 24 48 8B 44 24 20 8B 0C 24 89 48 28 8B 04 24 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_87_20_0 {
	meta:
		name = "?EnterHyperCriticalRegionHelper@UMSThreadInternalContext@details@Concurrency@@UEAAHXZ"
		size = 240
		refs = "0025 ??_C@_0EJ@FLFMGEDK@f?3?2dd?2vctools?2crt_bld?2self_64_am@ 002c ??_C@_0BH@MFNLHCGI@m_pThreadProxy?5?$CB?$DN?5NULL?$AA@ 0031 ?_ConcRT_CoreAssert@details@Concurrency@@YAXPEBD0H@Z 0051 ?EnterHyperCriticalRegionHelper@ContextBase@details@Concurrency@@UEAAHXZ 0092 ?_GetVirtualProcessor@InternalContextBase@details@Concurrency@@IEBAPEAVVirtualProcessor@23@XZ 00a9 ?CanCriticalEnter@UMSThreadVirtualProcessor@details@Concurrency@@QEAA_NXZ 00da __imp_Sleep"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 48 48 8B 44 24 50 48 8B 80 F0 00 00 00 48 85 C0 74 02 EB 19 41 B8 D2 00 00 00 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 44 24 20 00 00 00 00 33 C0 83 F8 01 0F 84 9F 00 00 00 48 8B 44 24 50 48 8B C8 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 8B 80 F0 00 00 00 48 89 44 24 28 48 8B 44 24 28 48 8B 00 48 8B 4C 24 28 FF 50 30 89 44 24 20 48 8B 44 24 50 83 78 24 01 75 5B 48 8B 44 24 50 48 83 E8 10 48 8B C8 E8 ?? ?? ?? ?? 48 89 44 24 30 48 83 7C 24 30 00 74 11 48 8B 4C 24 30 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 02 EB 31 48 8B 44 24 50 48 8B 4C 24 50 48 8B 09 48 89 4C 24 38 48 8B C8 48 8B 44 24 38 FF 50 78 B9 01 00 00 00 FF 15 ?? ?? ?? ?? EB 02 EB 05 E9 56 FF FF FF 8B 44 24 20 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_87_21_0 {
	meta:
		name = "?ExitCriticalRegionHelper@ContextBase@details@Concurrency@@UEAAHXZ"
		size = 121
		refs = "001f ??_C@_0DK@HANMFGFF@f?3?2dd?2vctools?2crt_bld?2self_64_am@ 0026 ??_C@_0BK@KHDLBAFP@m_criticalRegionCount?5?$DO?50?$AA@ 002b ?_ConcRT_CoreAssert@details@Concurrency@@YAXPEBD0H@Z 0030 ?CurrentContext@Context@Concurrency@@SAPEAV12@XZ 004d ??_C@_0CC@DPOLDNHN@Context?3?3CurrentContext?$CI?$CJ?5?$DN?$DN?5thi@"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 83 78 24 00 76 02 EB 19 41 B8 B5 00 00 00 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 3B 44 24 40 75 02 EB 19 41 B8 B6 00 00 00 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 44 24 40 8B 40 24 FF C8 89 44 24 20 48 8B 44 24 40 8B 4C 24 20 89 48 24 8B 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_87_22_0 {
	meta:
		name = "?ExitCriticalRegionHelper@UMSThreadInternalContext@details@Concurrency@@UEAAHXZ"
		size = 104
		refs = "0025 ??_C@_0EJ@FLFMGEDK@f?3?2dd?2vctools?2crt_bld?2self_64_am@ 002c ??_C@_0BH@MFNLHCGI@m_pThreadProxy?5?$CB?$DN?5NULL?$AA@ 0031 ?_ConcRT_CoreAssert@details@Concurrency@@YAXPEBD0H@Z 003e ?ExitCriticalRegionHelper@ContextBase@details@Concurrency@@UEAAHXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 48 8B 80 F0 00 00 00 48 85 C0 74 02 EB 19 41 B8 C4 00 00 00 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 44 24 40 48 8B C8 E8 ?? ?? ?? ?? 48 8B 44 24 40 48 8B 80 F0 00 00 00 48 89 44 24 20 48 8B 44 24 20 48 8B 00 48 8B 4C 24 20 FF 50 28 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_87_23_0 {
	meta:
		name = "?ExitHyperCriticalRegionHelper@ContextBase@details@Concurrency@@UEAAHXZ"
		size = 138
		refs = "001f ??_C@_0DK@HANMFGFF@f?3?2dd?2vctools?2crt_bld?2self_64_am@ 0026 ??_C@_0BP@KFKOBDFI@m_hyperCriticalRegionCount?5?$DO?50?$AA@ 002b ?_ConcRT_CoreAssert@details@Concurrency@@YAXPEBD0H@Z 004c ??_C@_0BK@KHDLBAFP@m_criticalRegionCount?5?$DO?50?$AA@"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 83 78 28 00 76 02 EB 19 41 B8 C6 00 00 00 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 44 24 40 83 78 24 00 76 02 EB 19 41 B8 C7 00 00 00 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 44 24 40 8B 40 24 FF C8 48 8B 4C 24 40 89 41 24 48 8B 44 24 40 8B 40 28 FF C8 89 44 24 20 48 8B 44 24 40 8B 4C 24 20 89 48 28 8B 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_87_24_0 {
	meta:
		name = "?ExitHyperCriticalRegionHelper@UMSThreadInternalContext@details@Concurrency@@UEAAHXZ"
		size = 104
		refs = "0025 ??_C@_0EJ@FLFMGEDK@f?3?2dd?2vctools?2crt_bld?2self_64_am@ 002c ??_C@_0BH@MFNLHCGI@m_pThreadProxy?5?$CB?$DN?5NULL?$AA@ 0031 ?_ConcRT_CoreAssert@details@Concurrency@@YAXPEBD0H@Z 003e ?ExitHyperCriticalRegionHelper@ContextBase@details@Concurrency@@UEAAHXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 48 8B 80 F0 00 00 00 48 85 C0 74 02 EB 19 41 B8 00 01 00 00 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 44 24 40 48 8B C8 E8 ?? ?? ?? ?? 48 8B 44 24 40 48 8B 80 F0 00 00 00 48 89 44 24 20 48 8B 44 24 20 48 8B 00 48 8B 4C 24 20 FF 50 38 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_87_26_0 {
	meta:
		name = "?GetCriticalRegionType@UMSThreadInternalContext@details@Concurrency@@UEBA?AW4CriticalRegionType@3@XZ"
		size = 91
		refs = "0025 ??_C@_0EH@HBCCNGNB@f?3?2dd?2vctools?2crt_bld?2self_64_am@ 002c ??_C@_0BH@MFNLHCGI@m_pThreadProxy?5?$CB?$DN?5NULL?$AA@ 0031 ?_ConcRT_CoreAssert@details@Concurrency@@YAXPEBD0H@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 48 8B 80 F0 00 00 00 48 85 C0 74 02 EB 19 41 B8 5E 00 00 00 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 44 24 40 48 8B 80 F0 00 00 00 48 89 44 24 20 48 8B 44 24 20 48 8B 00 48 8B 4C 24 20 FF 50 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_87_28_0 {
	meta:
		name = "?GetLocation@VirtualProcessor@details@Concurrency@@QEBAAEBVlocation@3@XZ"
		size = 17
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 05 C8 00 00 00 C3 }
	condition:
		$1
}

rule file_87_29_0 {
	meta:
		name = "?IsMarkedForRetirement@VirtualProcessor@details@Concurrency@@QEAA_NXZ"
		size = 18
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 0F B6 80 F1 00 00 00 C3 }
	condition:
		$1
}

rule file_87_30_0 {
	meta:
		name = "?IsSynchronouslyBlocked@InternalContextBase@details@Concurrency@@UEBA_NXZ"
		size = 47
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 18 48 8B 44 24 20 8B 40 54 83 F8 02 75 09 C7 04 24 01 00 00 00 EB 07 C7 04 24 00 00 00 00 0F B6 04 24 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_87_31_0 {
	meta:
		name = "?IsSynchronouslyBlocked@UMSThreadInternalContext@details@Concurrency@@UEBA_NXZ"
		size = 72
		refs = "0012 ?IsSynchronouslyBlocked@InternalContextBase@details@Concurrency@@UEBA_NXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 48 8B C8 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 19 48 8B 44 24 40 8B 40 50 83 E0 02 85 C0 75 0A C7 44 24 20 00 00 00 00 EB 08 C7 44 24 20 01 00 00 00 0F B6 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_87_32_0 {
	meta:
		name = "?NotifyBlocked@UMSThreadInternalContext@details@Concurrency@@AEAAX_N@Z"
		size = 72
		refs = "0015 ?UNSAFE_SetVirtualProcessor@InternalContextBase@details@Concurrency@@IEAAXPEAVVirtualProcessor@23@@Z"
	strings:
		$1 = { 88 54 24 10 48 89 4C 24 08 48 83 EC 38 33 D2 48 8B 4C 24 40 E8 ?? ?? ?? ?? 0F B6 44 24 48 85 C0 74 0A C7 44 24 20 04 00 00 00 EB 08 C7 44 24 20 02 00 00 00 48 8B 44 24 40 48 83 C0 60 8B 4C 24 20 87 08 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_87_33_0 {
	meta:
		name = "?Oversubscribe@UMSThreadInternalContext@details@Concurrency@@UEAAX_N@Z"
		size = 309
		refs = "0039 ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPEAVContextBase@23@XZ 0047 ??_C@_1FI@PHNNBKGB@?$AAS?$AAc?$AAh?$AAe?$AAd?$AAu?$AAl?$AAe?$AAr?$AAB?$AAa?$AAs?$AAe?$AA?3?$AA?3?$AAF?$AAa?$AAs?$AAt?$AAC?$AAu?$AAr?$AAr?$AAe?$AAn?$AAt?$AAC?$AAo?$AAn?$AAt?$AAe?$AAx@ 0053 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0068 ??_C@_1JC@HGLGKHD@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 0072 _CrtDbgReportW 00a1 ??_C@_1DE@GDDGFPFF@?$AAm?$AA_?$AAo?$AAv?$AAe?$AAr?$AAs?$AAu?$AAb?$AAs?$AAc?$AAr?$AAi?$AAb?$AAe?$AAC?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 0109 ??0invalid_oversubscribe_operation@Concurrency@@QEAA@XZ 0110 _TI2?AVinvalid_oversubscribe_operation@Concurrency@@ 011a _CxxThrowException"
	strings:
		$1 = { 88 54 24 10 48 89 4C 24 08 48 83 EC 58 48 8B 44 24 60 48 83 E8 10 48 85 C0 74 14 48 8B 44 24 60 48 83 E8 10 48 83 C0 10 48 89 44 24 30 EB 09 48 C7 44 24 30 00 00 00 00 E8 ?? ?? ?? ?? 48 3B 44 24 30 74 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 31 01 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 33 C0 85 C0 75 89 33 C0 85 C0 75 83 0F B6 44 24 68 85 C0 74 65 48 8B 44 24 60 83 78 2C 00 73 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 34 01 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 33 C0 85 C0 75 B5 33 C0 85 C0 75 AF 48 8B 44 24 60 8B 40 2C FF C0 48 8B 4C 24 60 89 41 2C EB 38 48 8B 44 24 60 83 78 2C 00 75 1B 48 8D 4C 24 38 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 38 E8 ?? ?? ?? ?? 48 8B 44 24 60 8B 40 2C FF C8 48 8B 4C 24 60 89 41 2C 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_87_34_0 {
	meta:
		name = "?PrepareToRun@InternalContextBase@details@Concurrency@@MEAAXPEAVVirtualProcessor@23@@Z"
		size = 148
		refs = "003d __imp_GetCurrentThreadId 0057 ?_PutVirtualProcessor@InternalContextBase@details@Concurrency@@IEAAXPEAVVirtualProcessor@23@@Z 0072 ??_C@_0EC@PEIBFLHK@f?3?2dd?2vctools?2crt_bld?2self_64_am@ 0079 ??_C@_0BD@EFMKKNNJ@m_pSegment?5?$CB?$DN?5NULL?$AA@ 007e ?_ConcRT_CoreAssert@details@Concurrency@@YAXPEBD0H@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 0F 31 48 C1 E2 20 48 0B C2 48 8B 4C 24 30 48 89 81 30 01 00 00 48 8B 44 24 30 8B 80 38 01 00 00 FF C0 48 8B 4C 24 30 89 81 38 01 00 00 FF 15 ?? ?? ?? ?? 48 8B 4C 24 30 89 81 48 01 00 00 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 78 40 00 74 02 EB 19 41 B8 D0 01 00 00 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C0 60 33 C9 87 08 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_87_35_0 {
	meta:
		name = "?PrepareToRun@UMSThreadInternalContext@details@Concurrency@@EEAAXPEAVVirtualProcessor@23@@Z"
		size = 66
		refs = "0039 ?PrepareToRun@InternalContextBase@details@Concurrency@@MEAAXPEAVVirtualProcessor@23@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 4C 24 38 48 89 88 78 01 00 00 48 8B 44 24 30 C7 80 80 01 00 00 00 00 00 00 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_87_36_0 {
	meta:
		name = "?RMAwaken@UMSThreadInternalContext@details@Concurrency@@EEAAXXZ"
		size = 122
		refs = "0048 ?_GetVirtualProcessor@InternalContextBase@details@Concurrency@@IEBAPEAVVirtualProcessor@23@XZ 0050 ?GetLocation@VirtualProcessor@details@Concurrency@@QEBAAEBVlocation@3@XZ 005d ??0location@Concurrency@@QEAA@AEBV01@@Z 0071 ?MoveCompletionListToRunnables@UMSThreadScheduler@details@Concurrency@@QEAA_NVlocation@3@@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 68 48 8D 44 24 40 48 89 44 24 30 48 8B 44 24 70 48 8B 40 48 48 89 44 24 20 48 83 7C 24 20 00 74 10 48 8B 44 24 20 48 83 E8 10 48 89 44 24 28 EB 09 48 C7 44 24 28 00 00 00 00 48 8B 4C 24 70 E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 8B D0 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 89 44 24 38 48 8B 54 24 38 48 8B 4C 24 28 E8 ?? ?? ?? ?? 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_87_37_0 {
	meta:
		name = "?SpinOnAndReturnBlockingType@UMSThreadInternalContext@details@Concurrency@@AEAA?AW4BlockingType@123@XZ"
		size = 82
		refs = "001b ?_Sleep0@details@Concurrency@@YAXXZ 0025 ??0?$_SpinWait@$00@details@Concurrency@@QEAA@P6AXXZ@Z 002f ?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QEAA_NXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 48 48 8B 44 24 50 8B 80 80 01 00 00 85 C0 75 2A 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 50 8B 80 80 01 00 00 85 C0 74 E7 48 8B 44 24 50 8B 80 80 01 00 00 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_87_38_0 {
	meta:
		name = "?TraceContextEvent@ContextBase@details@Concurrency@@IEAAXW4ConcRT_EventType@3@EKK@Z"
		size = 82
		refs = "0025 ?g_TraceInfo@details@Concurrency@@3U_CONCRT_TRACE_INFO@12@A 002a ?_IsEnabled@_CONCRT_TRACE_INFO@details@Concurrency@@QEBA_NEK@Z 0049 ?ThrowContextEvent@ContextBase@details@Concurrency@@KAXW4ConcRT_EventType@3@EKK@Z"
	strings:
		$1 = { 44 89 4C 24 20 44 88 44 24 18 89 54 24 10 48 89 4C 24 08 48 83 EC 28 41 B8 02 00 00 00 0F B6 54 24 40 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 18 44 8B 4C 24 50 44 8B 44 24 48 0F B6 54 24 40 8B 4C 24 38 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_87_39_0 {
	meta:
		name = "?UNSAFE_SetVirtualProcessor@InternalContextBase@details@Concurrency@@IEAAXPEAVVirtualProcessor@23@@Z"
		size = 28
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 8B 44 24 08 48 8B 4C 24 10 48 89 88 08 01 00 00 C3 }
	condition:
		$1
}

rule file_87_40_0 {
	meta:
		name = "?_Assign@location@Concurrency@@QEAAXAEBV12@@Z"
		size = 147
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 8B 44 24 10 8B 00 25 FF FF FF 0F 25 FF FF FF 0F 48 8B 4C 24 08 8B 09 81 E1 00 00 00 F0 0B C8 8B C1 48 8B 4C 24 08 89 01 48 8B 44 24 10 8B 00 C1 E8 1C 83 E0 0F 83 E0 0F C1 E0 1C 48 8B 4C 24 08 8B 09 81 E1 FF FF FF 0F 0B C8 8B C1 48 8B 4C 24 08 89 01 48 8B 44 24 08 48 8B 4C 24 10 48 8B 49 08 48 89 48 08 48 8B 44 24 08 48 8B 4C 24 10 8B 49 04 89 48 04 48 8B 44 24 08 48 8B 4C 24 10 48 8B 49 10 48 89 48 10 C3 }
	condition:
		$1
}

rule file_87_43_0 {
	meta:
		name = "?_IsEnabled@_CONCRT_TRACE_INFO@details@Concurrency@@QEBA_NEK@Z"
		size = 81
	strings:
		$1 = { 44 89 44 24 18 88 54 24 10 48 89 4C 24 08 48 83 EC 18 0F B6 44 24 28 48 8B 4C 24 20 0F B6 49 04 0F B6 C9 3B C1 7F 1A 48 8B 44 24 20 8B 00 23 44 24 30 3B 44 24 30 75 09 C7 04 24 01 00 00 00 EB 07 C7 04 24 00 00 00 00 0F B6 04 24 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_87_45_0 {
	meta:
		name = "?_PutVirtualProcessor@InternalContextBase@details@Concurrency@@IEAAXPEAVVirtualProcessor@23@@Z"
		size = 102
		refs = "002c ?IsInsideCriticalRegion@ContextBase@details@Concurrency@@QEBA_NXZ 0040 ??_C@_0EC@PEIBFLHK@f?3?2dd?2vctools?2crt_bld?2self_64_am@ 0047 ??_C@_0DJ@FICHJDBF@_m_pVirtualProcessor?5?$DN?$DN?5NULL?5?$HM?$HM?5@ 004c ?_ConcRT_CoreAssert@details@Concurrency@@YAXPEBD0H@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 80 08 01 00 00 48 85 C0 74 31 48 8B 44 24 30 48 83 C0 10 48 8B C8 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 19 41 B8 DD 01 00 00 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8B 4C 24 38 48 89 88 08 01 00 00 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_88_1_0 {
	meta:
		name = "??0FreeVirtualProcessorRoot@details@Concurrency@@QEAA@PEAVSchedulerProxy@12@PEAUSchedulerNode@12@I@Z"
		size = 106
		refs = "002d ??0VirtualProcessorRoot@details@Concurrency@@QEAA@PEAVSchedulerProxy@12@PEAUSchedulerNode@12@I@Z 0039 ??_7FreeVirtualProcessorRoot@details@Concurrency@@6B@"
	strings:
		$1 = { 44 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 44 8B 4C 24 48 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 C7 80 80 00 00 00 00 00 00 00 48 8B 44 24 30 48 C7 80 88 00 00 00 00 00 00 00 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_88_2_0 {
	meta:
		name = "??0HardwareAffinity@details@Concurrency@@QEAA@AEBU012@@Z"
		size = 48
		refs = "0022 memcpy"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 38 48 8B 4C 24 30 41 B8 10 00 00 00 48 8B D0 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_88_3_0 {
	meta:
		name = "??0HardwareAffinity@details@Concurrency@@QEAA@G_K@Z"
		size = 77
		refs = "0024 memset"
	strings:
		$1 = { 4C 89 44 24 18 66 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 41 B8 10 00 00 00 33 D2 48 8B C8 E8 ?? ?? ?? ?? 48 8B 44 24 30 0F B7 4C 24 38 66 89 48 08 48 8B 44 24 30 48 8B 4C 24 40 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_88_8_0 {
	meta:
		name = "??0logic_error@std@@QEAA@PEBD@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBQEBD@Z 0025 ??_7logic_error@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8D 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_273_0_0 {
	meta:
		name = "??0_Interruption_exception@details@Concurrency@@QEAA@PEBD@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBQEBD@Z 0025 ??_7_Interruption_exception@details@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8D 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_771_3_0 {
	meta:
		name = "??0bad_cast@std@@QEAA@PEBD@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBQEBD@Z 0025 ??_7bad_cast@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8D 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_593_2_0 {
	meta:
		name = "??0bad_exception@std@@QEAA@PEBD@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBQEBD@Z 0025 ??_7bad_exception@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8D 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_273_2_0 {
	meta:
		name = "??0bad_target@Concurrency@@QEAA@PEBD@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBQEBD@Z 0025 ??_7bad_target@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8D 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_771_5_0 {
	meta:
		name = "??0bad_typeid@std@@QEAA@PEBD@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBQEBD@Z 0025 ??_7bad_typeid@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8D 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_273_4_0 {
	meta:
		name = "??0context_self_unblock@Concurrency@@QEAA@PEBD@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBQEBD@Z 0025 ??_7context_self_unblock@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8D 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_273_6_0 {
	meta:
		name = "??0context_unblock_unbalanced@Concurrency@@QEAA@PEBD@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBQEBD@Z 0025 ??_7context_unblock_unbalanced@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8D 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_273_8_0 {
	meta:
		name = "??0default_scheduler_exists@Concurrency@@QEAA@PEBD@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBQEBD@Z 0025 ??_7default_scheduler_exists@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8D 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_273_10_0 {
	meta:
		name = "??0improper_lock@Concurrency@@QEAA@PEBD@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBQEBD@Z 0025 ??_7improper_lock@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8D 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_273_12_0 {
	meta:
		name = "??0improper_scheduler_attach@Concurrency@@QEAA@PEBD@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBQEBD@Z 0025 ??_7improper_scheduler_attach@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8D 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_273_14_0 {
	meta:
		name = "??0improper_scheduler_detach@Concurrency@@QEAA@PEBD@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBQEBD@Z 0025 ??_7improper_scheduler_detach@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8D 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_273_16_0 {
	meta:
		name = "??0improper_scheduler_reference@Concurrency@@QEAA@PEBD@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBQEBD@Z 0025 ??_7improper_scheduler_reference@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8D 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_273_18_0 {
	meta:
		name = "??0invalid_link_target@Concurrency@@QEAA@PEBD@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBQEBD@Z 0025 ??_7invalid_link_target@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8D 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_273_20_0 {
	meta:
		name = "??0invalid_multiple_scheduling@Concurrency@@QEAA@PEBD@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBQEBD@Z 0025 ??_7invalid_multiple_scheduling@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8D 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_273_22_0 {
	meta:
		name = "??0invalid_operation@Concurrency@@QEAA@PEBD@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBQEBD@Z 0025 ??_7invalid_operation@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8D 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_273_24_0 {
	meta:
		name = "??0invalid_oversubscribe_operation@Concurrency@@QEAA@PEBD@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBQEBD@Z 0025 ??_7invalid_oversubscribe_operation@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8D 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_273_26_0 {
	meta:
		name = "??0invalid_scheduler_policy_key@Concurrency@@QEAA@PEBD@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBQEBD@Z 0025 ??_7invalid_scheduler_policy_key@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8D 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_273_28_0 {
	meta:
		name = "??0invalid_scheduler_policy_thread_specification@Concurrency@@QEAA@PEBD@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBQEBD@Z 0025 ??_7invalid_scheduler_policy_thread_specification@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8D 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_273_30_0 {
	meta:
		name = "??0invalid_scheduler_policy_value@Concurrency@@QEAA@PEBD@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBQEBD@Z 0025 ??_7invalid_scheduler_policy_value@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8D 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_273_32_0 {
	meta:
		name = "??0message_not_found@Concurrency@@QEAA@PEBD@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBQEBD@Z 0025 ??_7message_not_found@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8D 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_273_34_0 {
	meta:
		name = "??0missing_wait@Concurrency@@QEAA@PEBD@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBQEBD@Z 0025 ??_7missing_wait@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8D 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_273_36_0 {
	meta:
		name = "??0nested_scheduler_missing_detach@Concurrency@@QEAA@PEBD@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBQEBD@Z 0025 ??_7nested_scheduler_missing_detach@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8D 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_273_38_0 {
	meta:
		name = "??0operation_timed_out@Concurrency@@QEAA@PEBD@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBQEBD@Z 0025 ??_7operation_timed_out@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8D 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_62_34_2 {
	meta:
		name = "??0runtime_error@std@@QEAA@PEBD@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBQEBD@Z 0025 ??_7runtime_error@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8D 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_273_40_0 {
	meta:
		name = "??0scheduler_not_attached@Concurrency@@QEAA@PEBD@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBQEBD@Z 0025 ??_7scheduler_not_attached@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8D 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_273_46_0 {
	meta:
		name = "??0task_canceled@Concurrency@@QEAA@PEBD@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBQEBD@Z 0025 ??_7task_canceled@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8D 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_273_48_0 {
	meta:
		name = "??0unsupported_os@Concurrency@@QEAA@PEBD@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBQEBD@Z 0025 ??_7unsupported_os@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8D 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_88_9_0 {
	meta:
		name = "??1ExecutionResource@details@Concurrency@@QEAA@XZ"
		size = 110
		refs = "0011 ??_7ExecutionResource@details@Concurrency@@6B@ 0026 ??_C@_1DM@ECFJJEKP@?$AAm?$AA_?$AAn?$AAu?$AAm?$AAT?$AAh?$AAr?$AAe?$AAa?$AAd?$AAS?$AAu?$AAb?$AAs?$AAc?$AAr?$AAi?$AAp?$AAt?$AAi?$AAo?$AAn?$AAs?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 0032 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0047 ??_C@_1IA@FIGHGBKO@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 0051 _CrtDbgReportW"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 40 83 78 4C 00 74 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 3C 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 33 C0 85 C0 75 B5 33 C0 85 C0 75 AF 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_88_12_0 {
	meta:
		name = "??1VirtualProcessorRoot@details@Concurrency@@UEAA@XZ"
		size = 46
		refs = "0011 ??_7VirtualProcessorRoot@details@Concurrency@@6B@ 0025 ??1ExecutionResource@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C0 10 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_88_16_0 {
	meta:
		name = "??4HardwareAffinity@details@Concurrency@@QEAAAEAU012@AEBU012@@Z"
		size = 50
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 8B 44 24 08 48 8B 4C 24 10 0F B7 49 08 66 89 48 08 48 8B 44 24 08 48 8B 4C 24 10 48 8B 09 48 89 08 48 8B 44 24 08 C3 }
	condition:
		$1
}

rule file_88_17_0 {
	meta:
		name = "??8HardwareAffinity@details@Concurrency@@QEAA_NAEBU012@@Z"
		size = 79
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 18 48 8B 44 24 28 0F B7 40 08 48 8B 4C 24 20 0F B7 49 08 3B C1 75 1B 48 8B 44 24 28 48 8B 4C 24 20 48 8B 09 48 39 08 75 09 C7 04 24 01 00 00 00 EB 07 C7 04 24 00 00 00 00 0F B6 04 24 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_88_18_0 {
	meta:
		name = "??9HardwareAffinity@details@Concurrency@@QEAA_NAEBU012@@Z"
		size = 64
		refs = "0019 ??8HardwareAffinity@details@Concurrency@@QEAA_NAEBU012@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 0A C7 44 24 20 01 00 00 00 EB 08 C7 44 24 20 00 00 00 00 0F B6 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_78_77_1 {
	meta:
		name = "??$?9$$A6AXXZ@std@@YA_NAEBV?$function@$$A6AXXZ@0@$$T@Z"
		size = 64
		refs = "0019 ??$?8$$A6AXXZ@std@@YA_NAEBV?$function@$$A6AXXZ@0@$$T@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 0A C7 44 24 20 01 00 00 00 EB 08 C7 44 24 20 00 00 00 00 0F B6 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_78_78_1 {
	meta:
		name = "??$?9$$A6A_NAEBW4agent_status@Concurrency@@@Z@std@@YA_NAEBV?$function@$$A6A_NAEBW4agent_status@Concurrency@@@Z@0@$$T@Z"
		size = 64
		refs = "0019 ??$?8$$A6A_NAEBW4agent_status@Concurrency@@@Z@std@@YA_NAEBV?$function@$$A6A_NAEBW4agent_status@Concurrency@@@Z@0@$$T@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 0A C7 44 24 20 01 00 00 00 EB 08 C7 44 24 20 00 00 00 00 0F B6 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_78_79_1 {
	meta:
		name = "??$?9$$A6A_NAEB_K@Z@std@@YA_NAEBV?$function@$$A6A_NAEB_K@Z@0@$$T@Z"
		size = 64
		refs = "0019 ??$?8$$A6A_NAEB_K@Z@std@@YA_NAEBV?$function@$$A6A_NAEB_K@Z@0@$$T@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 0A C7 44 24 20 01 00 00 00 EB 08 C7 44 24 20 00 00 00 00 0F B6 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_123_3_2 {
	meta:
		name = "??$?9DD@std@@YA_NAEBV?$allocator@D@0@0@Z"
		size = 64
		refs = "0019 ??$?8DD@std@@YA_NAEBV?$allocator@D@0@0@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 0A C7 44 24 20 01 00 00 00 EB 08 C7 44 24 20 00 00 00 00 0F B6 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_64_3_1 {
	meta:
		name = "??$?9DU?$char_traits@D@std@@@std@@YA_NAEBV?$istreambuf_iterator@DU?$char_traits@D@std@@@0@0@Z"
		size = 64
		refs = "0019 ??$?8DU?$char_traits@D@std@@@std@@YA_NAEBV?$istreambuf_iterator@DU?$char_traits@D@std@@@0@0@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 0A C7 44 24 20 01 00 00 00 EB 08 C7 44 24 20 00 00 00 00 0F B6 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_66_6_3 {
	meta:
		name = "??$?9GG@std@@YA_NAEBV?$allocator@G@0@0@Z"
		size = 64
		refs = "0019 ??$?8GG@std@@YA_NAEBV?$allocator@G@0@0@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 0A C7 44 24 20 01 00 00 00 EB 08 C7 44 24 20 00 00 00 00 0F B6 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_66_7_3 {
	meta:
		name = "??$?9GU?$char_traits@G@std@@@std@@YA_NAEBV?$istreambuf_iterator@GU?$char_traits@G@std@@@0@0@Z"
		size = 64
		refs = "0019 ??$?8GU?$char_traits@G@std@@@std@@YA_NAEBV?$istreambuf_iterator@GU?$char_traits@G@std@@@0@0@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 0A C7 44 24 20 01 00 00 00 EB 08 C7 44 24 20 00 00 00 00 0F B6 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_84_33_2 {
	meta:
		name = "??$?9V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@V01@@std@@YA_NAEBV?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@0@0@Z"
		size = 64
		refs = "0019 ??$?8V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@V01@@std@@YA_NAEBV?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@0@0@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 0A C7 44 24 20 01 00 00 00 EB 08 C7 44 24 20 00 00 00 00 0F B6 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_105_34_2 {
	meta:
		name = "??$?9V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@V01@@std@@YA_NAEBV?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@0@0@Z"
		size = 64
		refs = "0019 ??$?8V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@V01@@std@@YA_NAEBV?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@0@0@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 0A C7 44 24 20 01 00 00 00 EB 08 C7 44 24 20 00 00 00 00 0F B6 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_43_4_3 {
	meta:
		name = "??$?9V?$allocator@D@std@@V01@@std@@YA_NAEBU?$_Wrap_alloc@V?$allocator@D@std@@@0@0@Z"
		size = 64
		refs = "0019 ??$?8V?$allocator@D@std@@V01@@std@@YA_NAEBU?$_Wrap_alloc@V?$allocator@D@std@@@0@0@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 0A C7 44 24 20 01 00 00 00 EB 08 C7 44 24 20 00 00 00 00 0F B6 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_28_8_1 {
	meta:
		name = "??$?9V?$allocator@G@std@@V01@@std@@YA_NAEBU?$_Wrap_alloc@V?$allocator@G@std@@@0@0@Z"
		size = 64
		refs = "0019 ??$?8V?$allocator@G@std@@V01@@std@@YA_NAEBU?$_Wrap_alloc@V?$allocator@G@std@@@0@0@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 0A C7 44 24 20 01 00 00 00 EB 08 C7 44 24 20 00 00 00 00 0F B6 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_84_35_2 {
	meta:
		name = "??$?9V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@V01@@std@@YA_NAEBU?$_Wrap_alloc@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@0@0@Z"
		size = 64
		refs = "0019 ??$?8V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@V01@@std@@YA_NAEBU?$_Wrap_alloc@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@0@0@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 0A C7 44 24 20 01 00 00 00 EB 08 C7 44 24 20 00 00 00 00 0F B6 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_54_36_3 {
	meta:
		name = "??$?9V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@V01@@std@@YA_NAEBU?$_Wrap_alloc@V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@0@0@Z"
		size = 64
		refs = "0019 ??$?8V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@V01@@std@@YA_NAEBU?$_Wrap_alloc@V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@0@0@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 0A C7 44 24 20 01 00 00 00 EB 08 C7 44 24 20 00 00 00 00 0F B6 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_28_9_1 {
	meta:
		name = "??$?9V?$allocator@_W@std@@V01@@std@@YA_NAEBU?$_Wrap_alloc@V?$allocator@_W@std@@@0@0@Z"
		size = 64
		refs = "0019 ??$?8V?$allocator@_W@std@@V01@@std@@YA_NAEBU?$_Wrap_alloc@V?$allocator@_W@std@@@0@0@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 0A C7 44 24 20 01 00 00 00 EB 08 C7 44 24 20 00 00 00 00 0F B6 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_36_10_2 {
	meta:
		name = "??$?9_WU?$char_traits@_W@std@@@std@@YA_NAEBV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@0@0@Z"
		size = 64
		refs = "0019 ??$?8_WU?$char_traits@_W@std@@@std@@YA_NAEBV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@0@0@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 0A C7 44 24 20 01 00 00 00 EB 08 C7 44 24 20 00 00 00 00 0F B6 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_36_11_2 {
	meta:
		name = "??$?9_W_W@std@@YA_NAEBV?$allocator@_W@0@0@Z"
		size = 64
		refs = "0019 ??$?8_W_W@std@@YA_NAEBV?$allocator@_W@0@0@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 0A C7 44 24 20 01 00 00 00 EB 08 C7 44 24 20 00 00 00 00 0F B6 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_43_193_3 {
	meta:
		name = "??9?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEBA_NAEBV01@@Z"
		size = 64
		refs = "0019 ??8?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEBA_NAEBV01@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 0A C7 44 24 20 01 00 00 00 EB 08 C7 44 24 20 00 00 00 00 0F B6 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_66_431_3 {
	meta:
		name = "??9?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QEBA_NAEBV01@@Z"
		size = 64
		refs = "0019 ??8?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QEBA_NAEBV01@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 0A C7 44 24 20 01 00 00 00 EB 08 C7 44 24 20 00 00 00 00 0F B6 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_36_398_2 {
	meta:
		name = "??9?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QEBA_NAEBV01@@Z"
		size = 64
		refs = "0019 ??8?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QEBA_NAEBV01@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 0A C7 44 24 20 01 00 00 00 EB 08 C7 44 24 20 00 00 00 00 0F B6 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_105_403_1 {
	meta:
		name = "??9?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@QEBA_NAEBV01@@Z"
		size = 64
		refs = "0019 ??8?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@QEBA_NAEBV01@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 0A C7 44 24 20 01 00 00 00 EB 08 C7 44 24 20 00 00 00 00 0F B6 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_5_410_1 {
	meta:
		name = "??9?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@QEBA_NAEBV01@@Z"
		size = 64
		refs = "0019 ??8?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@QEBA_NAEBV01@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 0A C7 44 24 20 01 00 00 00 EB 08 C7 44 24 20 00 00 00 00 0F B6 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_268_44_0 {
	meta:
		name = "??9location@Concurrency@@QEBA_NAEBV01@@Z"
		size = 64
		refs = "0019 ??8location@Concurrency@@QEBA_NAEBV01@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 0A C7 44 24 20 01 00 00 00 EB 08 C7 44 24 20 00 00 00 00 0F B6 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_88_28_0 {
	meta:
		name = "?AcquireActivatedContext@VirtualProcessorRoot@details@Concurrency@@QEAAPEAUIExecutionContext@3@XZ"
		size = 89
		refs = "000c ?_Sleep0@details@Concurrency@@YAXXZ 0016 ??0?$_SpinWait@$00@details@Concurrency@@QEAA@P6AXXZ@Z 002e ?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QEAA_NXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 48 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 8B 40 08 48 85 C0 75 0C 48 8D 4C 24 28 E8 ?? ?? ?? ?? EB E6 48 8B 44 24 50 48 8B 40 08 48 89 44 24 20 48 8B 44 24 50 48 C7 40 08 00 00 00 00 48 8B 44 24 20 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_88_29_0 {
	meta:
		name = "?Activate@FreeVirtualProcessorRoot@details@Concurrency@@UEAAXPEAUIExecutionContext@3@@Z"
		size = 890
		refs = "001f ??_C@_08BAFMHLII@pContext?$AA@ 0029 ??0invalid_argument@std@@QEAA@PEBD@Z 0030 _TI3?AVinvalid_argument@std@@ 003a _CxxThrowException 006a ?GetSchedulerProxy@VirtualProcessorRoot@details@Concurrency@@QEAAPEAVSchedulerProxy@23@XZ 00cb ??_C@_1DC@NHHAFCCO@?$AAm?$AA_?$AAp?$AAD?$AAe?$AAa?$AAc?$AAt?$AAi?$AAv?$AAa?$AAt?$AAe?$AAd?$AAP?$AAr?$AAo?$AAx?$AAy?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 00d7 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 00ec ??_C@_1JC@KHEBEDFN@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 00f6 _CrtDbgReportW 011f ?SetActivatedContext@VirtualProcessorRoot@details@Concurrency@@QEAAXPEAUIExecutionContext@3@@Z 0132 ??_C@_1BI@LOEGHIFA@?$AAn?$AAe?$AAw?$AAV?$AAa?$AAl?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA1?$AA?$AA@ 017e ?SpinUntilIdle@FreeVirtualProcessorRoot@details@Concurrency@@IEAAXXZ 01a8 ??_C@_1FC@HLACLNBG@?$AAm?$AA_?$AAp?$AAE?$AAx?$AAe?$AAc?$AAu?$AAt?$AAi?$AAn?$AAg?$AAP?$AAr?$AAo?$AAx?$AAy?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAm?$AA_?$AAp?$AAD?$AAe?$AAa?$AAc?$AAt?$AAi?$AAv?$AAa@ 021b ??0invalid_operation@Concurrency@@QEAA@XZ 0222 _TI2?AVinvalid_operation@Concurrency@@ 024c ?Subscribe@VirtualProcessorRoot@details@Concurrency@@QEAAXXZ 025e ?Affinitize@FreeVirtualProcessorRoot@details@Concurrency@@QEAAXPEAVFreeThreadProxy@23@@Z 027b ??_C@_1DI@FKHKLPAG@?$AAm?$AA_?$AAp?$AAE?$AAx?$AAe?$AAc?$AAu?$AAt?$AAi?$AAn?$AAg?$AAP?$AAr?$AAo?$AAx?$AAy?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAp?$AAP?$AAr?$AAo?$AAx?$AAy?$AA?$AA@ 02c4 ?GetVirtualProcessorRoot@ThreadProxy@details@Concurrency@@QEAAPEAVVirtualProcessorRoot@23@XZ 02d0 ??_C@_1EO@KOIOAGCL@?$AAp?$AAP?$AAr?$AAo?$AAx?$AAy?$AA?9?$AA?$DO?$AAG?$AAe?$AAt?$AAV?$AAi?$AAr?$AAt?$AAu?$AAa?$AAl?$AAP?$AAr?$AAo?$AAc?$AAe?$AAs?$AAs?$AAo?$AAr?$AAR?$AAo?$AAo?$AAt?$AA?$CI@ 0319 ?GetExecutionContext@FreeThreadProxy@details@Concurrency@@QEAAPEAUIExecutionContext@3@XZ 0325 ??_C@_1EG@KHPEHIHA@?$AAp?$AAP?$AAr?$AAo?$AAx?$AAy?$AA?9?$AA?$DO?$AAG?$AAe?$AAt?$AAE?$AAx?$AAe?$AAc?$AAu?$AAt?$AAi?$AAo?$AAn?$AAC?$AAo?$AAn?$AAt?$AAe?$AAx?$AAt?$AA?$CI?$AA?$CJ?$AA?5?$AA?$CB?$AA?$DN@ 036e ?ResumeExecution@ThreadProxy@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 81 EC 88 00 00 00 48 83 BC 24 98 00 00 00 00 75 22 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 48 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 48 E8 ?? ?? ?? ?? 48 8B 84 24 98 00 00 00 48 8B 00 48 8B 8C 24 98 00 00 00 FF 50 10 48 89 44 24 38 48 83 7C 24 38 00 75 2F 48 8B 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 40 48 8B 44 24 40 48 8B 00 48 8B 94 24 98 00 00 00 48 8B 4C 24 40 FF 50 38 48 89 44 24 38 48 8B 84 24 90 00 00 00 48 83 C0 78 B9 01 00 00 00 F0 0F C1 08 FF C1 8B C1 89 44 24 30 83 7C 24 30 02 75 74 48 8B 84 24 90 00 00 00 48 8B 80 88 00 00 00 48 85 C0 74 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 B0 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 33 C0 85 C0 75 AC 33 C0 85 C0 75 A6 48 8B 94 24 98 00 00 00 48 8B 8C 24 90 00 00 00 E8 ?? ?? ?? ?? E9 4A 02 00 00 83 7C 24 30 01 74 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 BC 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 33 C0 85 C0 75 B9 33 C0 85 C0 75 B3 48 8B 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 8B 84 24 90 00 00 00 48 8B 80 80 00 00 00 48 8B 8C 24 90 00 00 00 48 8B 89 88 00 00 00 48 3B C1 74 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 BF 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 33 C0 85 C0 75 9D 33 C0 85 C0 75 97 48 8B 84 24 90 00 00 00 48 8B 80 80 00 00 00 48 85 C0 74 31 48 8B 84 24 90 00 00 00 48 8B 80 80 00 00 00 48 39 44 24 38 74 1B 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8B 84 24 90 00 00 00 48 C7 80 88 00 00 00 00 00 00 00 48 8B 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 8B 54 24 38 48 8B 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 8B 84 24 90 00 00 00 48 8B 80 80 00 00 00 48 3B 44 24 38 74 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 DD 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 33 C0 85 C0 75 AA 33 C0 85 C0 75 A4 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 85 C0 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 DE 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 33 C0 85 C0 75 B1 33 C0 85 C0 75 AB 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 85 C0 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 DF 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 33 C0 85 C0 75 B1 33 C0 85 C0 75 AB 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 81 C4 88 00 00 00 C3 }
	condition:
		$1
}

rule file_88_30_0 {
	meta:
		name = "?Affinitize@FreeVirtualProcessorRoot@details@Concurrency@@QEAAXPEAVFreeThreadProxy@23@@Z"
		size = 176
		refs = "0011 __security_cookie 0023 ?SpinUntilBlocked@ThreadProxy@details@Concurrency@@QEAAXXZ 0043 ?SetVirtualProcessorRoot@ThreadProxy@details@Concurrency@@QEAAXPEAVVirtualProcessorRoot@23@@Z 0060 ?GetSchedulerProxy@VirtualProcessorRoot@details@Concurrency@@QEAAPEAVSchedulerProxy@23@XZ 0074 ?GetNodeAffinity@SchedulerProxy@details@Concurrency@@QEAA?AUHardwareAffinity@23@I@Z 008d ??0HardwareAffinity@details@Concurrency@@QEAA@AEBU012@@Z 009a ?SetAffinity@FreeThreadProxy@details@Concurrency@@QEAAXUHardwareAffinity@23@@Z 00a7 __security_check_cookie"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 68 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 50 48 8B 4C 24 78 E8 ?? ?? ?? ?? 48 8B 44 24 70 48 8B 4C 24 78 48 89 88 80 00 00 00 48 8B 54 24 70 48 8B 4C 24 78 E8 ?? ?? ?? ?? 48 8B 44 24 70 48 8B 00 48 8B 4C 24 70 FF 10 89 44 24 20 48 8B 4C 24 70 E8 ?? ?? ?? ?? 8B 4C 24 20 44 8B C1 48 8D 54 24 40 48 8B C8 E8 ?? ?? ?? ?? 48 8D 44 24 30 48 89 44 24 28 48 8D 54 24 40 48 8B 4C 24 28 E8 ?? ?? ?? ?? 48 8B D0 48 8B 4C 24 78 E8 ?? ?? ?? ?? 48 8B 4C 24 50 48 33 CC E8 ?? ?? ?? ?? 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_88_31_0 {
	meta:
		name = "?CurrentSubscriptionLevel@VirtualProcessorRoot@details@Concurrency@@UEBAIXZ"
		size = 48
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 48 83 C0 10 48 8B 4C 24 40 48 8B 49 10 48 89 4C 24 20 48 8B C8 48 8B 44 24 20 FF 50 18 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_88_32_0 {
	meta:
		name = "?Deactivate@FreeVirtualProcessorRoot@details@Concurrency@@UEAA_NPEAUIExecutionContext@3@@Z"
		size = 471
		refs = "001f ??_C@_08BAFMHLII@pContext?$AA@ 0029 ??0invalid_argument@std@@QEAA@PEBD@Z 0030 _TI3?AVinvalid_argument@std@@ 003a _CxxThrowException 0058 ??0invalid_operation@Concurrency@@QEAA@XZ 005f _TI2?AVinvalid_operation@Concurrency@@ 0106 ?Unsubscribe@VirtualProcessorRoot@details@Concurrency@@QEAAXXZ 0110 ?SuspendExecution@ThreadProxy@details@Concurrency@@QEAAXXZ 0123 ??_C@_1BI@LOEGHIFA@?$AAn?$AAe?$AAw?$AAV?$AAa?$AAl?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA1?$AA?$AA@ 012f ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0144 ??_C@_1JC@KHEBEDFN@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 014e _CrtDbgReportW 016f ?AcquireActivatedContext@VirtualProcessorRoot@details@Concurrency@@QEAAPEAUIExecutionContext@3@XZ 018a ??_C@_1DM@NNOJBNCB@?$AAp?$AAA?$AAc?$AAt?$AAi?$AAv?$AAa?$AAt?$AAe?$AAd?$AAC?$AAo?$AAn?$AAt?$AAe?$AAx?$AAt?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAp?$AAC?$AAo?$AAn?$AAt?$AAe?$AAx?$AAt?$AA?$AA@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 81 EC 98 00 00 00 48 83 BC 24 A8 00 00 00 00 75 22 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8B 84 24 A0 00 00 00 48 8B 80 80 00 00 00 48 85 C0 75 1B 48 8D 4C 24 48 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 48 E8 ?? ?? ?? ?? 48 8B 84 24 A8 00 00 00 48 8B 00 48 8B 8C 24 A8 00 00 00 FF 50 10 48 89 44 24 38 48 8B 84 24 A0 00 00 00 48 8B 80 80 00 00 00 48 3B 44 24 38 74 1B 48 8D 4C 24 78 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 78 E8 ?? ?? ?? ?? 48 8B 84 24 A0 00 00 00 48 83 C0 78 B9 FF FF FF FF F0 0F C1 08 FF C9 8B C1 89 44 24 30 83 7C 24 30 00 75 3C 48 8B 84 24 A0 00 00 00 48 05 88 00 00 00 48 8B 8C 24 A0 00 00 00 48 8B 89 80 00 00 00 48 87 08 48 8B 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 48 8B 4C 24 38 E8 ?? ?? ?? ?? E9 B4 00 00 00 83 7C 24 30 01 74 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 0B 01 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 33 C0 85 C0 75 B9 33 C0 85 C0 75 B3 48 8B 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 40 48 8B 84 24 A8 00 00 00 48 39 44 24 40 74 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 13 01 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 33 C0 85 C0 75 B1 33 C0 85 C0 75 AB B0 01 48 81 C4 98 00 00 00 C3 }
	condition:
		$1
}

rule file_88_33_0 {
	meta:
		name = "?DeleteThis@FreeVirtualProcessorRoot@details@Concurrency@@UEAAXXZ"
		size = 231
		refs = "0018 ?GetSchedulerProxy@VirtualProcessorRoot@details@Concurrency@@QEAAPEAVSchedulerProxy@23@XZ 0020 ?GetResourceManager@SchedulerProxy@details@Concurrency@@QEBAPEAVResourceManager@23@XZ 0028 ?GetExecutionResourceTls@ResourceManager@details@Concurrency@@QEBAKXZ 0036 __imp_TlsGetValue 0091 ?SetVirtualProcessorRoot@ThreadProxy@details@Concurrency@@QEAAXPEAVVirtualProcessorRoot@23@@Z 009d ?SpinUntilIdle@FreeVirtualProcessorRoot@details@Concurrency@@IEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 68 48 C7 44 24 28 00 00 00 00 48 8B 4C 24 70 E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 89 44 24 20 8B 4C 24 20 FF 15 ?? ?? ?? ?? 48 89 44 24 38 48 8B 44 24 38 48 89 44 24 40 48 83 7C 24 38 00 74 1D 48 8B 44 24 40 48 83 E0 03 48 83 F8 01 75 0E 48 8B 44 24 40 48 83 E0 FE 48 89 44 24 28 48 83 7C 24 28 00 74 21 48 8B 44 24 70 48 8B 80 80 00 00 00 48 39 44 24 28 75 0E 33 D2 48 8B 4C 24 28 E8 ?? ?? ?? ?? EB 0A 48 8B 4C 24 70 E8 ?? ?? ?? ?? 48 8B 44 24 70 48 89 44 24 48 48 8B 44 24 48 48 89 44 24 30 48 83 7C 24 30 00 74 1C 48 8B 44 24 30 48 8B 00 BA 01 00 00 00 48 8B 4C 24 30 FF 50 40 48 89 44 24 50 EB 09 48 C7 44 24 50 00 00 00 00 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_88_34_0 {
	meta:
		name = "?EnsureAllTasksVisible@FreeVirtualProcessorRoot@details@Concurrency@@UEAAXPEAUIExecutionContext@3@@Z"
		size = 193
		refs = "001c ??_C@_08BAFMHLII@pContext?$AA@ 0026 ??0invalid_argument@std@@QEAA@PEBD@Z 002d _TI3?AVinvalid_argument@std@@ 0037 _CxxThrowException 0055 ??0invalid_operation@Concurrency@@QEAA@XZ 005c _TI2?AVinvalid_operation@Concurrency@@ 00b8 __imp_FlushProcessWriteBuffers"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 78 48 83 BC 24 88 00 00 00 00 75 22 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 48 8B 80 80 00 00 00 48 85 C0 75 1B 48 8D 4C 24 40 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 40 E8 ?? ?? ?? ?? 48 8B 84 24 88 00 00 00 48 8B 00 48 8B 8C 24 88 00 00 00 FF 50 10 48 89 44 24 20 48 8B 84 24 80 00 00 00 48 8B 80 80 00 00 00 48 3B 44 24 20 74 1B 48 8D 4C 24 58 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 58 E8 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_88_37_0 {
	meta:
		name = "?GetExecutionResourceId@VirtualProcessorRoot@details@Concurrency@@UEBAIXZ"
		size = 48
		altNames = "?GetId@ThreadScheduler@details@Concurrency@@UEBAIXZ ?GetId@UMSThreadScheduler@details@Concurrency@@UEBAIXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 48 83 C0 10 48 8B 4C 24 40 48 8B 49 10 48 89 4C 24 20 48 8B C8 48 8B 44 24 20 FF 50 08 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_88_38_0 {
	meta:
		name = "?GetExecutionResourceTls@ResourceManager@details@Concurrency@@QEBAKXZ"
		size = 33
		refs = "0018 ?GetExecutionResourceTls@ThreadProxyFactoryManager@details@Concurrency@@QEBAKXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 05 A0 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_88_41_0 {
	meta:
		name = "?GetNodeAffinity@SchedulerProxy@details@Concurrency@@QEAA?AUHardwareAffinity@23@I@Z"
		size = 276
		refs = "0027 ??_C@_1CK@PJDMDIJP@?$AAn?$AAo?$AAd?$AAe?$AAI?$AAd?$AA?5?$AA?$DM?$AA?5?$AAm?$AA_?$AAn?$AAo?$AAd?$AAe?$AAC?$AAo?$AAu?$AAn?$AAt?$AA?$AA@ 0033 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0048 ??_C@_1HK@FIKLIHEK@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AA6?$AA4?$AA_?$AAa?$AAm@ 0052 _CrtDbgReportW 0088 ??_C@_1FC@OILOLPEF@?$AAm?$AA_?$AAp?$AAA?$AAl?$AAl?$AAo?$AAc?$AAa?$AAt?$AAe?$AAd?$AAN?$AAo?$AAd?$AAe?$AAs?$AA?$FL?$AAn?$AAo?$AAd?$AAe?$AAI?$AAd?$AA?$FN?$AA?4?$AAm?$AA_?$AAi?$AAd?$AA?5?$AA?$DN@ 0106 ??0HardwareAffinity@details@Concurrency@@QEAA@G_K@Z"
	strings:
		$1 = { 44 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 48 8B 44 24 50 8B 80 F0 00 00 00 39 44 24 60 72 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 5E 01 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 33 C0 85 C0 75 AF 33 C0 85 C0 75 A9 8B 44 24 60 48 6B C0 40 48 8B 4C 24 50 48 8B 49 20 8B 54 24 60 39 54 01 14 74 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 5F 01 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 33 C0 85 C0 75 A5 33 C0 85 C0 75 9F 8B 44 24 60 48 6B C0 40 48 8B 4C 24 50 48 8B 49 20 8B 54 24 60 48 6B D2 40 4C 8B 44 24 50 4D 8B 40 20 4C 89 44 24 30 4C 8B 04 01 48 8B 44 24 30 0F B7 54 10 10 48 8B 4C 24 58 E8 ?? ?? ?? ?? 48 8B 44 24 58 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_88_43_0 {
	meta:
		name = "?GetNodeId@VirtualProcessorRoot@details@Concurrency@@UEBAIXZ"
		size = 47
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 48 83 C0 10 48 8B 4C 24 40 48 8B 49 10 48 89 4C 24 20 48 8B C8 48 8B 44 24 20 FF 10 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_88_46_0 {
	meta:
		name = "?GetSchedulerProxy@VirtualProcessorRoot@details@Concurrency@@QEAAPEAVSchedulerProxy@23@XZ"
		size = 31
		refs = "0016 ?GetSchedulerProxy@ExecutionResource@details@Concurrency@@QEAAPEAVSchedulerProxy@23@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 83 C0 10 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_439_154_0 {
	meta:
		name = "?Acquire@?$SafeSQueue@VSafePointInvocation@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QEBAXXZ"
		size = 31
		refs = "0016 ?_Acquire@_HyperNonReentrantLock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 83 C0 10 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1003_61_0 {
	meta:
		name = "?GetCoreIndex@VirtualProcessorRoot@details@Concurrency@@QEAAHXZ"
		size = 31
		refs = "0016 ?GetCoreIndex@ExecutionResource@details@Concurrency@@QEAAIXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 83 C0 10 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_439_375_0 {
	meta:
		name = "?Release@?$SafeSQueue@VSafePointInvocation@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QEBAXXZ"
		size = 31
		refs = "0016 ?_Release@_HyperNonReentrantLock@details@Concurrency@@QEAAXXZ"
	s