/*
 * Decompiled with CFR 0.152.
 */
package slothLib.linearAlgebra.featureVector;

import slothLib.linearAlgebra.featureVector.ClusteringDistanceType;
import slothLib.linearAlgebra.featureVector.HierarchicalClusteringResult;
import slothLib.linearAlgebra.featureVector.ICalculatorScalarFromTwoVectors;
import slothLib.linearAlgebra.featureVector.IDistanceCalculator;
import slothLib.linearAlgebra.featureVector.IHierarchicalClustering;
import slothLib.linearAlgebra.featureVector.IHierarchicalClusteringProcess;
import slothLib.linearAlgebra.featureVector.ISimilarityCalculator;
import slothLib.linearAlgebra.featureVector.IVector;

public abstract class HierarchicalClustering<T>
implements IHierarchicalClustering<T> {
    protected ICalculatorScalarFromTwoVectors<T> calculator;
    protected ClusteringDistanceType dType;

    public HierarchicalClustering(IDistanceCalculator<T> distanceCalculator) {
        this.calculator = distanceCalculator;
        this.dType = ClusteringDistanceType.Distance;
    }

    public HierarchicalClustering(ISimilarityCalculator<T> similarityCalculator) {
        this.calculator = similarityCalculator;
        this.dType = ClusteringDistanceType.Similarity;
    }

    protected abstract IHierarchicalClusteringProcess<T> getProcess(IVector<T>[] var1);

    @Override
    public HierarchicalClusteringResult<T> doClustering(IVector<T>[] vectors, int thresholdClusterCount, double thresholdDistanceOrSimilarity) {
        IHierarchicalClusteringProcess<T> process = this.getProcess(vectors);
        return process.doClustering(thresholdClusterCount, thresholdDistanceOrSimilarity);
    }

    @Override
    public HierarchicalClusteringResult<T> doClustering(IVector<T>[] vectors) {
        IHierarchicalClusteringProcess<T> process = this.getProcess(vectors);
        return process.doClustering();
    }

    @Override
    public HierarchicalClusteringResult<T> doClustering(IVector<T>[] vectors, int thresholdClusterCount) {
        IHierarchicalClusteringProcess<T> process = this.getProcess(vectors);
        return this.doClustering(vectors, thresholdClusterCount);
    }

    @Override
    public HierarchicalClusteringResult<T> doClustering(IVector<T>[] vectors, double thresholdDistanceOrSimilarity) {
        IHierarchicalClusteringProcess<T> process = this.getProcess(vectors);
        return this.doClustering(vectors, thresholdDistanceOrSimilarity);
    }
}

