/*
 * Decompiled with CFR 0.152.
 */
package slothLib.web.search;

import GoogleSearch.GoogleSearchPort;
import GoogleSearch.GoogleSearchResult;
import GoogleSearch.GoogleSearchServiceLocator;
import GoogleSearch.ResultElement;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.xml.rpc.ServiceException;
import slothLib.SlothLib;
import slothLib.portUtil.PortUtil;
import slothLib.web.search.GoogleSOAPElement;
import slothLib.web.search.GoogleSOAPSearchAPIResult;
import slothLib.web.search.IWebSearch;
import slothLib.web.search.WebSearchException;

public class GoogleSOAPSearchAPI
implements IWebSearch {
    private String apiKey;
    private String defaultLr;
    public static final String KEY_PROP = "slothlib.web.search.GoogleSOAPSearchAPI.key";

    static {
        SlothLib.init();
    }

    public GoogleSOAPSearchAPI(String apiKey, Language defaultLanguage) {
        this.apiKey = apiKey;
        switch (defaultLanguage) {
            case All: {
                this.defaultLr = "";
                break;
            }
            case Japanese: {
                this.defaultLr = "lang_ja";
                break;
            }
            case English: {
                this.defaultLr = "lang_en";
            }
        }
    }

    public GoogleSOAPSearchAPI(String apiKey) {
        this(apiKey, Language.Japanese);
    }

    public GoogleSOAPSearchAPI(String apiKey, String defaultLr) {
        this.apiKey = apiKey;
        this.defaultLr = defaultLr;
    }

    public GoogleSOAPSearchAPI() throws WebSearchException {
        String tmp = System.getProperty(KEY_PROP);
        if (tmp == null) {
            throw new WebSearchException("cannot find property: slothlib.web.search.GoogleSOAPSearchAPI.key");
        }
        this.apiKey = tmp.trim();
    }

    @Override
    public GoogleSOAPSearchAPIResult doSearch(String query, int maxResult) throws WebSearchException {
        try {
            return this.doGoogleSearchAPI(query, maxResult, this.defaultLr);
        }
        catch (RemoteException e) {
            throw new WebSearchException(e);
        }
        catch (ServiceException e) {
            throw new WebSearchException(e);
        }
    }

    private String modQuery(String query) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)bos, "UTF-8");
            writer.write(query);
            writer.close();
            byte[] tmp = bos.toByteArray();
            char[] ctmp = new char[tmp.length];
            int index = 0;
            while (index < tmp.length) {
                ctmp[index] = (char)(tmp[index] & 0xFF);
                ++index;
            }
            String tmpStr = new String(ctmp);
            System.err.println(tmpStr);
            return tmpStr;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return query;
    }

    private GoogleSOAPSearchAPIResult doGoogleSearchAPI(String query, int maxResult, String lr) throws ServiceException, RemoteException {
        ArrayList<GoogleSOAPElement> ResultElementList = new ArrayList<GoogleSOAPElement>();
        GoogleSearchPort s = new GoogleSearchServiceLocator().getGoogleSearchPort();
        long totalResult = 0L;
        int i = 0;
        while (i <= maxResult - 10) {
            int range = maxResult - i;
            if (range > 10) {
                range = 10;
            }
            String codedQuery = this.modQuery(query);
            GoogleSearchResult r = s.doGoogleSearch(this.apiKey, codedQuery, i, range, false, "", false, lr, "", "");
            int rank = 0;
            ResultElement[] resultElementArray = r.getResultElements();
            int n = resultElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                ResultElement re = resultElementArray[n2];
                re.setTitle(re.getTitle().replaceAll("<[^>]*>", ""));
                re.setSnippet(re.getSnippet().replaceAll("<[^>]*>", ""));
                GoogleSOAPElement sere = new GoogleSOAPElement(++rank, re.getURL(), re.getTitle(), re.getSnippet());
                ResultElementList.add(sere);
                ++n2;
            }
            totalResult = r.getEstimatedTotalResultsCount();
            i += 10;
        }
        return new GoogleSOAPSearchAPIResult(query, totalResult, ResultElementList.toArray(new GoogleSOAPElement[0]));
    }

    public static void openResultPage(String query, Language language) {
        String openURL = "http://www.google.co.jp/search?num=100&hl=ja&q=";
        try {
            openURL = String.valueOf(openURL) + URLEncoder.encode(query, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            openURL = String.valueOf(openURL) + query;
        }
        switch (language) {
            case All: {
                break;
            }
            case English: {
                openURL = String.valueOf(openURL) + "&lr=lang_en";
                break;
            }
            case Japanese: {
                openURL = String.valueOf(openURL) + "&lr=lang_ja";
            }
        }
        PortUtil.openUrl(openURL);
    }

    public static void OpenResultPage(String query) {
        GoogleSOAPSearchAPI.openResultPage(query, Language.Japanese);
    }

    public static enum Language {
        Japanese,
        English,
        All;

    }
}

