/*
 * Decompiled with CFR 0.152.
 */
package slothLib.linearAlgebra.featureVector;

import slothLib.linearAlgebra.featureVector.ClusteringDistanceType;
import slothLib.linearAlgebra.featureVector.HierarchicalClusteringProcess;
import slothLib.linearAlgebra.featureVector.ICalculatorScalarFromTwoVectors;
import slothLib.linearAlgebra.featureVector.IVector;

public class GroupAverageClusteringProcess<T>
extends HierarchicalClusteringProcess<T> {
    protected int[] itemCountInCluster;

    public GroupAverageClusteringProcess(IVector<T>[] vectors, ICalculatorScalarFromTwoVectors<T> calculator, ClusteringDistanceType dType) {
        super(vectors, calculator, dType);
        this.itemCountInCluster = new int[this.itemCount];
        int i = 0;
        while (i < this.itemCount) {
            this.itemCountInCluster[i] = 1;
            ++i;
        }
    }

    @Override
    protected void union(int cid1, int cid2) {
        int c;
        this.clusterID[cid2] = cid1;
        this.itemCountInCluster[cid1] = c = this.itemCountInCluster[cid1] + this.itemCountInCluster[cid2];
        int i = 0;
        while (i < this.itemCount) {
            if (this.clusterID[i] == i && i != cid1 && i != cid2) {
                this.setDistance(cid1, i, (this.getDistance(i, cid1) * (double)this.itemCountInCluster[cid1] + this.getDistance(i, cid2) * (double)this.itemCountInCluster[cid2]) / (double)(this.itemCountInCluster[cid1] + this.itemCountInCluster[cid2]));
            }
            ++i;
        }
    }
}

