/*
 * Decompiled with CFR 0.152.
 */
package com.sheepit.client;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.List;
import java.util.NoSuchElementException;
import lombok.NonNull;

public class ChunkInputStream
extends InputStream {
    @NonNull
    private final ArrayDeque<Path> chunkPaths;
    @NonNull
    private BufferedInputStream currentStream;

    public ChunkInputStream(List<Path> chunkPaths) throws IOException {
        this.chunkPaths = new ArrayDeque<Path>(chunkPaths);
        this.prepareNextChunk();
    }

    private void prepareNextChunk() throws FileNotFoundException, NoSuchElementException {
        this.currentStream = new BufferedInputStream(new FileInputStream(this.chunkPaths.removeFirst().toFile()));
    }

    @Override
    public int read() throws IOException {
        int result = this.currentStream.read();
        if (result == -1) {
            try {
                this.prepareNextChunk();
            }
            catch (NoSuchElementException e) {
                return -1;
            }
            result = this.currentStream.read();
        }
        return result;
    }
}

