/*
 * Decompiled with CFR 0.152.
 */
package com.sheepit.client;

import com.sheepit.client.Configuration;
import com.sheepit.client.DirectoryManager;
import com.sheepit.client.DownloadManager;
import com.sheepit.client.Error;
import com.sheepit.client.Gui;
import com.sheepit.client.Job;
import com.sheepit.client.Log;
import com.sheepit.client.Pair;
import com.sheepit.client.Server;
import com.sheepit.client.Utils;
import com.sheepit.client.datamodel.Chunk;
import com.sheepit.client.exception.SheepItException;
import com.sheepit.client.exception.SheepItExceptionNoRendererAvailable;
import com.sheepit.client.exception.SheepItExceptionNoRightToRender;
import com.sheepit.client.exception.SheepItExceptionNoSession;
import com.sheepit.client.exception.SheepItExceptionNoSpaceLeftOnDevice;
import com.sheepit.client.exception.SheepItExceptionNoWritePermission;
import com.sheepit.client.exception.SheepItExceptionPathInvalid;
import com.sheepit.client.exception.SheepItExceptionSessionDisabled;
import com.sheepit.client.exception.SheepItExceptionSessionDisabledDenoisingNotSupported;
import com.sheepit.client.exception.SheepItExceptionWithRequiredWait;
import com.sheepit.client.hardware.cpu.CPU;
import com.sheepit.client.os.OS;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Observable;
import java.util.Observer;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.stream.Collectors;
import okhttp3.HttpUrl;

public class Client {
    public static final int MIN_JOB_ID = 20;
    private static final Locale LOCALE = Locale.ENGLISH;
    private DirectoryManager directoryManager;
    private Gui gui;
    private Server server;
    private Configuration configuration;
    private Log log;
    private Job renderingJob;
    private Job previousJob;
    private BlockingQueue<QueuedJob> jobsToValidate;
    private boolean isValidatingJob;
    private long startTime;
    private boolean sessionStarted;
    private boolean disableErrorSending;
    private boolean running;
    private boolean awaitingStop;
    private boolean suspended;
    private boolean shuttingdown;
    private int uploadQueueSize;
    private long uploadQueueVolume;
    private int noJobRetryIter;

    public Client(Gui gui_, Configuration configuration, String url_) {
        this.configuration = configuration;
        this.server = new Server(url_, this.configuration, this);
        this.log = Log.getInstance(this.configuration);
        this.gui = gui_;
        this.directoryManager = new DirectoryManager(this.configuration, this.log);
        this.renderingJob = null;
        this.previousJob = null;
        this.jobsToValidate = new ArrayBlockingQueue<QueuedJob>(5);
        this.isValidatingJob = false;
        this.disableErrorSending = false;
        this.running = false;
        this.awaitingStop = false;
        this.suspended = false;
        this.shuttingdown = false;
        this.uploadQueueSize = 0;
        this.uploadQueueVolume = 0L;
        this.noJobRetryIter = 0;
        this.sessionStarted = false;
    }

    public String toString() {
        return String.format("Client (configuration %s, server %s)", this.configuration, this.server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run() {
        if (!this.configuration.checkOSisSupported()) {
            this.gui.error(Error.humanString(Error.Type.OS_NOT_SUPPORTED));
            return -3;
        }
        if (!this.configuration.checkCPUisSupported()) {
            this.gui.error(Error.humanString(Error.Type.CPU_NOT_SUPPORTED));
            return -4;
        }
        this.running = true;
        try {
            int step = this.log.newCheckPoint();
            this.gui.status("Starting");
            Error.Type ret = this.server.getConfiguration();
            if (ret != Error.Type.OK) {
                this.gui.error(Error.humanString(ret));
                if (ret != Error.Type.AUTHENTICATION_FAILED) {
                    Log.printCheckPoint(step);
                }
                return -1;
            }
            if (this.configuration.getShutdownTime() > 0L) {
                new Timer().schedule(new TimerTask(){

                    @Override
                    public void run() {
                        Client.this.shuttingdown = true;
                        Client.this.log.debug("Initiating the computer's shutting down process");
                        if (Client.this.configuration.getShutdownMode().equals("wait")) {
                            Client.this.askForStop();
                        } else {
                            Client.this.stop();
                        }
                    }
                }, this.configuration.getShutdownTime());
            }
            step = this.log.newCheckPoint();
            this.log.info("OS: " + OS.getOS().getVersion() + " " + System.getProperty("os.arch"));
            this.log.info(this.configuration.toString());
            for (String logline : this.configuration.filesystemHealthCheck()) {
                this.log.info(logline);
            }
            this.sendError(step, null, Error.Type.OK);
            this.configuration.cleanWorkingDirectory();
            this.startTime = new Date().getTime();
            this.server.start();
            Runnable runnable_sender = new Runnable(){

                @Override
                public void run() {
                    Client.this.senderLoop();
                }
            };
            Thread thread_sender = new Thread(runnable_sender);
            thread_sender.start();
            while (true) {
                if (this.running) {
                    this.renderingJob = null;
                    Client client = this;
                    synchronized (client) {
                        if (this.suspended) {
                            this.gui.status("Client paused", true);
                            this.log.debug("Client paused");
                        }
                        while (this.suspended && !this.shuttingdown) {
                            this.wait();
                        }
                    }
                    step = this.log.newCheckPoint();
                    try {
                        Calendar next_request = this.nextJobRequest();
                        if (next_request != null) {
                            Date now = new Date();
                            this.gui.status(String.format("Waiting until %tR before requesting job", next_request));
                            long wait = next_request.getTimeInMillis() - now.getTime();
                            if (wait < 0L) {
                                wait += 86400000L;
                            }
                            this.sleep(wait);
                        }
                        this.gui.status("Requesting Job");
                        this.renderingJob = this.server.requestJob();
                    }
                    catch (SheepItExceptionNoRightToRender e) {
                        this.gui.error("User does not have enough right to render project");
                        return -2;
                    }
                    catch (SheepItExceptionSessionDisabled e) {
                        this.gui.error(Error.humanString(Error.Type.SESSION_DISABLED));
                        this.waitForever();
                    }
                    catch (SheepItExceptionSessionDisabledDenoisingNotSupported e) {
                        this.gui.error(Error.humanString(Error.Type.DENOISING_NOT_SUPPORTED));
                        this.waitForever();
                    }
                    catch (SheepItExceptionNoRendererAvailable e) {
                        this.gui.error(Error.humanString(Error.Type.RENDERER_NOT_AVAILABLE));
                        this.waitForever();
                    }
                    catch (SheepItExceptionNoSession e) {
                        this.log.debug("User has no session and needs to re-authenticate");
                        ret = this.server.getConfiguration();
                        if (ret != Error.Type.OK) {
                            this.renderingJob = null;
                        } else {
                            this.startTime = new Date().getTime();
                            try {
                                Calendar next_request = this.nextJobRequest();
                                if (next_request != null) {
                                    Date now = new Date();
                                    this.gui.status(String.format("Waiting until %tR before requesting job", next_request));
                                    long timeToSleep = next_request.getTimeInMillis() - now.getTime();
                                    this.activeSleep(timeToSleep);
                                }
                                if (!this.running || this.shuttingdown) continue;
                                this.gui.status("Requesting Job");
                                this.renderingJob = this.server.requestJob();
                            }
                            catch (SheepItException e1) {
                                this.renderingJob = null;
                            }
                        }
                    }
                    catch (SheepItExceptionWithRequiredWait e) {
                        int time_sleep = e.getWaitDuration();
                        this.gui.status(String.format(e.getHumanText(), new Date(new Date().getTime() + (long)time_sleep)));
                        if (!this.activeSleep(time_sleep)) {
                            return -3;
                        }
                        this.log.removeCheckPoint(step);
                        continue;
                    }
                    catch (SheepItException e) {
                        this.gui.error("Client::run exception requestJob (1) " + e.getMessage());
                        StringWriter sw = new StringWriter();
                        PrintWriter pw = new PrintWriter(sw);
                        e.printStackTrace(pw);
                        this.log.debug("Client::run exception " + e + " stacktrace: " + sw.toString());
                        this.sendError(step);
                        this.log.removeCheckPoint(step);
                        continue;
                    }
                    if (this.renderingJob == null) {
                        int n;
                        int[] retrySchemeInMilliSeconds = new int[]{300000, 480000, 720000, 900000, 1200000};
                        if (this.noJobRetryIter < retrySchemeInMilliSeconds.length) {
                            int n2 = this.noJobRetryIter;
                            n = n2;
                            this.noJobRetryIter = n2 + 1;
                        } else {
                            n = retrySchemeInMilliSeconds.length - 1;
                        }
                        int time_sleep = retrySchemeInMilliSeconds[n];
                        this.gui.status(String.format("No job available. Will try again at %tR", new Date(new Date().getTime() + (long)time_sleep)));
                        if (!this.activeSleep(time_sleep)) {
                            return -3;
                        }
                        this.log.removeCheckPoint(step);
                        continue;
                    }
                    this.log.debug("Got work to do id: " + this.renderingJob.getId() + " frame: " + this.renderingJob.getFrameNumber());
                    this.noJobRetryIter = 0;
                    ret = this.work(this.renderingJob);
                    if (ret == Error.Type.NO_SPACE_LEFT_ON_DEVICE || ret == Error.Type.PATH_INVALID || ret == Error.Type.NO_WRITE_PERMISSION) {
                        Job frame_to_reset = this.renderingJob;
                        this.renderingJob = null;
                        this.gui.error(Error.humanString(ret));
                        this.sendError(step, frame_to_reset, ret);
                        this.log.removeCheckPoint(step);
                        return -50;
                    }
                    if (ret != Error.Type.OK) {
                        Job currentJob = this.renderingJob;
                        this.renderingJob = null;
                        this.gui.error(Error.humanString(ret));
                        this.sendError(step, currentJob, ret);
                        this.log.removeCheckPoint(step);
                        if (Integer.parseInt(currentJob.getId()) >= 20) continue;
                        this.gui.error(Error.humanString(ret) + " The error happened during the test frame render. Restart the client and try again.");
                        this.waitForever();
                    } else {
                        if (this.renderingJob.isSynchronousUpload()) {
                            this.gui.status(String.format("Uploading frame (%.2fMB)", (double)this.renderingJob.getOutputImageSize() / 1024.0 / 1024.0));
                            ret = this.confirmJob(this.renderingJob, step);
                            if (ret != Error.Type.OK) {
                                this.gui.error("Client::run problem with confirmJob (returned " + ret + ")");
                                this.sendError(step, this.renderingJob, Error.Type.VALIDATION_FAILED);
                            }
                            this.renderingJob = null;
                        } else {
                            this.gui.status(String.format("Queuing frame for upload (%.2fMB)", (double)this.renderingJob.getOutputImageSize() / 1024.0 / 1024.0));
                            this.jobsToValidate.add(new QueuedJob(step, this.renderingJob));
                            ++this.uploadQueueSize;
                            this.uploadQueueVolume += this.renderingJob.getOutputImageSize();
                            this.gui.displayUploadQueueStats(this.uploadQueueSize, this.uploadQueueVolume);
                            this.renderingJob = null;
                        }
                        if (this.shouldWaitBeforeRender()) {
                            this.gui.status("Sending frames. Please wait");
                            while (this.shouldWaitBeforeRender()) {
                                this.sleep(4000L);
                            }
                        }
                        this.log.removeCheckPoint(step);
                        continue;
                    }
                }
                this.gui.status("Uploading rendered frames before exiting. Please wait");
                this.sleep(2300L);
                if (this.uploadQueueSize <= 0) break;
            }
        }
        catch (Exception e1) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e1.printStackTrace(pw);
            this.log.debug("Client::run exception(D) " + e1 + " stacktrace: " + sw.toString());
            return -99;
        }
        if (this.shuttingdown) {
            this.log.debug("Shutting down the computer in 1 minute");
            OS.getOS().shutdownComputer(1);
        }
        this.gui.stop();
        return 0;
    }

    public synchronized int stop() {
        this.running = false;
        this.disableErrorSending = true;
        if (this.renderingJob != null) {
            this.gui.status("Stopping");
            if (this.renderingJob.getProcessRender().getProcess() != null) {
                this.renderingJob.setAskForRendererKill(true);
                this.renderingJob.getProcessRender().kill();
            }
        }
        this.configuration.removeWorkingDirectory();
        if (this.server == null) {
            return 0;
        }
        if (!this.server.getPage("logout").isEmpty()) {
            this.gui.status("Disconnecting from SheepIt server");
            try {
                this.server.HTTPRequest(this.server.getPage("logout"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.server.interrupt();
        try {
            this.server.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.server = null;
        return 0;
    }

    public void suspend() {
        this.suspended = true;
        this.gui.status("Client will pause when the current job finishes", true);
    }

    public synchronized void resume() {
        this.suspended = false;
        this.notify();
    }

    public void waitForever() {
        while (!this.shuttingdown) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public boolean activeSleep(long wait) {
        try {
            for (long timeSlept = 0L; timeSlept < wait && this.running && !this.shuttingdown; timeSlept += 1000L) {
                Thread.sleep(1000L);
            }
            return true;
        }
        catch (InterruptedException ignored) {
            return false;
        }
    }

    public boolean sleep(long wait) {
        try {
            int timeSlept = 0;
            while ((long)timeSlept < wait) {
                Thread.sleep(1000L);
                timeSlept += 1000;
            }
            return true;
        }
        catch (InterruptedException ignored) {
            return false;
        }
    }

    public void askForStop() {
        this.log.debug("Client::askForStop");
        this.running = false;
        this.awaitingStop = true;
    }

    public void cancelStop() {
        this.log.debug("Client::cancelStop");
        this.running = true;
        this.awaitingStop = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int senderLoop() {
        int step = -1;
        Error.Type ret = null;
        while (true) {
            QueuedJob queuedJob = null;
            try {
                queuedJob = this.jobsToValidate.take();
                step = queuedJob.checkpoint;
                this.log.debug(step, "will validate " + queuedJob.job);
                ret = this.confirmJob(queuedJob.job, step);
                if (ret != Error.Type.OK) {
                    this.gui.error(Error.humanString(ret));
                    this.log.debug(step, "Client::senderLoop confirm failed, ret: " + ret);
                }
                if (ret != Error.Type.OK) {
                    if (queuedJob.job != null) {
                        this.sendError(step, queuedJob.job, ret);
                    } else {
                        this.sendError(step);
                    }
                }
                this.log.removeCheckPoint(step);
                --this.uploadQueueSize;
                if (queuedJob.job != null) {
                    this.uploadQueueVolume -= queuedJob.job.getOutputImageSize();
                }
                this.gui.displayUploadQueueStats(this.uploadQueueSize, this.uploadQueueVolume);
                continue;
            }
            catch (InterruptedException e) {
                try {
                    this.log.error(step, "Client::senderLoop Exception " + e.getMessage());
                    if (ret != Error.Type.OK) {
                        if (queuedJob.job != null) {
                            this.sendError(step, queuedJob.job, ret);
                        } else {
                            this.sendError(step);
                        }
                    }
                    this.log.removeCheckPoint(step);
                    --this.uploadQueueSize;
                    if (queuedJob.job != null) {
                        this.uploadQueueVolume -= queuedJob.job.getOutputImageSize();
                    }
                    this.gui.displayUploadQueueStats(this.uploadQueueSize, this.uploadQueueVolume);
                    continue;
                }
                catch (Throwable throwable) {
                    if (ret != Error.Type.OK) {
                        if (queuedJob.job != null) {
                            this.sendError(step, queuedJob.job, ret);
                        } else {
                            this.sendError(step);
                        }
                    }
                    this.log.removeCheckPoint(step);
                    --this.uploadQueueSize;
                    if (queuedJob.job != null) {
                        this.uploadQueueVolume -= queuedJob.job.getOutputImageSize();
                    }
                    this.gui.displayUploadQueueStats(this.uploadQueueSize, this.uploadQueueVolume);
                    throw throwable;
                }
            }
            break;
        }
    }

    protected void sendError(int step_) {
        this.sendError(step_, null, null);
    }

    protected void sendError(int step_, Job job_to_reset_, Error.Type error) {
        if (this.disableErrorSending) {
            this.log.debug("Error sending is disabled, do not send log");
            return;
        }
        this.log.debug("Sending error to server (type: " + error + ")");
        try {
            File temp_file = File.createTempFile("farm_", ".txt");
            temp_file.createNewFile();
            temp_file.deleteOnExit();
            FileOutputStream writer = new FileOutputStream(temp_file);
            Configuration conf = this.configuration;
            CPU cpu = OS.getOS().getCPU();
            StringBuilder logHeader = new StringBuilder().append("====================================================================================================\n").append(String.format("%s  /  %s  /  %s  /  SheepIt v%s\n", conf.getLogin(), conf.getHostname(), OS.getOS().name(), Configuration.jarVersion)).append(String.format("%s  x%d  %.1f GB RAM\n", cpu.getName(), conf.getNbCores(), (double)conf.getMaxAllowedMemory() / 1024.0 / 1024.0));
            if (conf.getComputeMethod() == Configuration.ComputeType.GPU || conf.getComputeMethod() == Configuration.ComputeType.CPU_GPU) {
                logHeader.append(String.format("%s   %s   %.1f GB VRAM\n", conf.getGPUDevice().getId(), conf.getGPUDevice().getModel(), (double)conf.getGPUDevice().getMemory() / 1024.0 / 1024.0 / 1024.0));
            }
            logHeader.append("====================================================================================================\n");
            if (job_to_reset_ != null) {
                logHeader.append(String.format("Project ::: %s\n", job_to_reset_.getName())).append(String.format("Project id: %s  frame: %s\n", job_to_reset_.getId(), job_to_reset_.getFrameNumber())).append(String.format("blender ::: %s\n\n", job_to_reset_.getBlenderLongVersion())).append(String.format("ERROR Type :: %s\n", new Object[]{error}));
            } else {
                logHeader.append("Project ::: No project allocated.\n").append(String.format("ERROR Type :: %s\n", error != null ? error : "N/A"));
            }
            logHeader.append("====================================================================================================\n\n");
            writer.write(logHeader.toString().getBytes());
            Optional<ArrayList<String>> logs = this.log.getForCheckPoint(step_);
            if (logs.isPresent()) {
                for (String line : logs.get()) {
                    writer.write(line.getBytes());
                    writer.write(10);
                }
            }
            writer.close();
            HttpUrl.Builder remoteURL = HttpUrl.parse(this.server.getPage("error")).newBuilder();
            remoteURL.addQueryParameter("type", error == null ? "" : Integer.toString(error.getValue()));
            if (job_to_reset_ != null) {
                remoteURL.addQueryParameter("frame", job_to_reset_.getFrameNumber());
                remoteURL.addQueryParameter("job", job_to_reset_.getId());
                remoteURL.addQueryParameter("render_time", Integer.toString(job_to_reset_.getProcessRender().getRenderDuration()));
                remoteURL.addQueryParameter("memoryused", Long.toString(job_to_reset_.getProcessRender().getPeakMemoryUsed()));
            }
            this.server.HTTPSendFile(remoteURL.build().toString(), temp_file.getAbsolutePath(), step_, this.gui);
            temp_file.delete();
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            this.log.debug("Client::sendError Exception " + e + " stacktrace: " + sw.toString());
        }
    }

    public Calendar nextJobRequest() {
        if (this.configuration.getRequestTime() == null) {
            return null;
        }
        Calendar next = null;
        ArrayList<Calendar> dates = new ArrayList<Calendar>();
        Calendar now = Calendar.getInstance();
        for (Pair<Calendar, Calendar> interval : this.configuration.getRequestTime()) {
            Calendar start = (Calendar)now.clone();
            Calendar end = (Calendar)now.clone();
            start.set(13, 0);
            start.set(12, ((Calendar)interval.first).get(12));
            start.set(11, ((Calendar)interval.first).get(11));
            end.set(13, 59);
            end.set(12, ((Calendar)interval.second).get(12));
            end.set(11, ((Calendar)interval.second).get(11));
            if (start.before(now) && now.before(end)) {
                return null;
            }
            Calendar startTomorow = (Calendar)start.clone();
            startTomorow.add(5, 1);
            dates.add(start);
            dates.add(startTomorow);
        }
        for (Calendar cal : dates) {
            if (!cal.after(now) || next != null && cal.getTimeInMillis() - now.getTimeInMillis() >= next.getTimeInMillis() - now.getTimeInMillis()) continue;
            next = cal;
        }
        return next;
    }

    public Error.Type work(Job ajob) {
        this.gui.setRenderingProjectName(ajob.getName());
        try {
            Error.Type downloadRet = this.downloadExecutable(ajob);
            if (downloadRet != Error.Type.OK) {
                this.gui.setRenderingProjectName("");
                for (String logline : this.configuration.filesystemHealthCheck()) {
                    this.log.debug(logline);
                }
                this.log.error("Client::work problem with downloadExecutable (ret " + downloadRet + ")");
                return downloadRet;
            }
            downloadRet = this.downloadSceneFile(ajob);
            if (downloadRet != Error.Type.OK) {
                this.gui.setRenderingProjectName("");
                for (String logline : this.configuration.filesystemHealthCheck()) {
                    this.log.debug(logline);
                }
                this.log.error("Client::work problem with downloadSceneFile (ret " + downloadRet + ")");
                return downloadRet;
            }
            int ret = this.prepareWorkingDirectory(ajob);
            if (ret != 0) {
                this.gui.setRenderingProjectName("");
                for (String logline : this.configuration.filesystemHealthCheck()) {
                    this.log.debug(logline);
                }
                this.log.error("Client::work problem with this.prepareWorkingDirectory (ret " + ret + ")");
                return Error.Type.CAN_NOT_CREATE_DIRECTORY;
            }
        }
        catch (SheepItException e) {
            this.gui.setRenderingProjectName("");
            for (String logline : this.configuration.filesystemHealthCheck()) {
                this.log.debug(logline);
            }
            if (e instanceof SheepItExceptionNoSpaceLeftOnDevice) {
                return Error.Type.NO_SPACE_LEFT_ON_DEVICE;
            }
            if (e instanceof SheepItExceptionPathInvalid) {
                return Error.Type.PATH_INVALID;
            }
            if (e instanceof SheepItExceptionNoWritePermission) {
                return Error.Type.NO_WRITE_PERMISSION;
            }
            return Error.Type.UNKNOWN;
        }
        final File scene_file = new File(ajob.getScenePath());
        File renderer_file = new File(ajob.getRendererPath());
        if (!scene_file.exists()) {
            this.gui.setRenderingProjectName("");
            for (String logline : this.configuration.filesystemHealthCheck()) {
                this.log.debug(logline);
            }
            this.log.error("Client::work job preparation failed (scene file '" + scene_file.getAbsolutePath() + "' does not exist), cleaning directory in hope to recover");
            this.configuration.cleanWorkingDirectory();
            return Error.Type.MISSING_SCENE;
        }
        if (!renderer_file.exists()) {
            this.gui.setRenderingProjectName("");
            for (String logline : this.configuration.filesystemHealthCheck()) {
                this.log.debug(logline);
            }
            this.log.error("Client::work job preparation failed (renderer file '" + renderer_file.getAbsolutePath() + "' does not exist), cleaning directory in hope to recover");
            this.configuration.cleanWorkingDirectory();
            return Error.Type.MISSING_RENDERER;
        }
        Observer removeSceneDirectoryOnceRenderHasStartedObserver = new Observer(){

            @Override
            public void update(Observable observable2, Object o) {
                scene_file.delete();
            }
        };
        Error.Type err = ajob.render(removeSceneDirectoryOnceRenderHasStartedObserver);
        this.gui.setRenderingProjectName("");
        this.gui.setRemainingTime("");
        this.gui.setRenderingTime("");
        this.gui.setComputeMethod("");
        this.removeSceneDirectory(ajob);
        if (err != Error.Type.OK) {
            this.log.error("Client::work problem with runRenderer (ret " + err + ")");
            if (err == Error.Type.RENDERER_CRASHED_PYTHON_ERROR) {
                this.log.error("Client::work failed with python error, cleaning directory in hope to recover");
                this.configuration.cleanWorkingDirectory();
            }
            return err;
        }
        return Error.Type.OK;
    }

    protected Error.Type downloadSceneFile(Job ajob_) throws SheepItException {
        int total = ajob_.getArchiveChunks().size();
        for (int i = 0; i < total; ++i) {
            Chunk chunk = ajob_.getArchiveChunks().get(i);
            DownloadManager downloadManager = new DownloadManager(this.server, this.gui, this.log, String.format(LOCALE, "chunk %d/%d", i + 1, total), this.directoryManager.getActualStoragePathFor(chunk), chunk.getMd5(), String.format(LOCALE, "%s?chunk=%s", this.server.getPage("download-chunk"), chunk.getId()));
            Error.Type ret = downloadManager.download();
            if (ret == Error.Type.OK) continue;
            return ret;
        }
        return Error.Type.OK;
    }

    protected Error.Type downloadExecutable(Job ajob) throws SheepItException {
        return new DownloadManager(this.server, this.gui, this.log, "renderer", this.directoryManager.getActualStorageBinaryPathFor(ajob), ajob.getRendererMD5(), String.format(LOCALE, "%s?job=%s", this.server.getPage("download-binary"), ajob.getId())).download();
    }

    protected void removeSceneDirectory(Job ajob) {
        Utils.delete(new File(ajob.getSceneDirectory()));
    }

    protected int prepareWorkingDirectory(Job ajob) {
        int ret;
        String renderer_archive = this.directoryManager.getCacheBinaryPathFor(ajob);
        String renderer_path = ajob.getRendererDirectory();
        File renderer_path_file = new File(renderer_path);
        if (this.directoryManager.isSharedEnabled() && new File(this.directoryManager.getSharedBinaryPathFor(ajob)).exists()) {
            this.gui.status("Copying renderer from shared downloads directory");
            this.log.debug("Client::prepareWorkingDirectory Copying renderer from shared downloads directory " + this.directoryManager.getSharedBinaryPathFor(ajob) + " into " + this.directoryManager.getCacheBinaryPathFor(ajob));
            if (!this.directoryManager.copyBinaryFromSharedToCache(ajob)) {
                this.log.error("Error while copying " + renderer_archive + " from shared downloads directory to working dir");
            }
        }
        if (!renderer_path_file.exists()) {
            renderer_path_file.mkdir();
            this.gui.status("Extracting renderer");
            this.log.debug("Client::prepareWorkingDirectory Extracting renderer " + renderer_archive + " into " + renderer_path);
            ret = Utils.unzipFileIntoDirectory(renderer_archive, renderer_path, null, this.log);
            if (ret != 0) {
                this.log.error("Client::prepareWorkingDirectory, error(1) with Utils.unzipFileIntoDirectory(" + renderer_archive + ", " + renderer_path + ") returned " + ret);
                this.gui.error(String.format("Unable to extract the renderer (error %d)", ret));
                return -1;
            }
            try {
                File f = new File(ajob.getRendererPath());
                f.setExecutable(true);
            }
            catch (SecurityException f) {
                // empty catch block
            }
        }
        String scene_path = ajob.getSceneDirectory();
        File scene_path_file = new File(scene_path);
        for (Chunk chunk2 : ajob.getArchiveChunks()) {
            if (!this.directoryManager.isSharedEnabled() || !new File(this.directoryManager.getSharedPathFor(chunk2)).exists()) continue;
            this.gui.status("Copying chunk from common directory");
            if (this.directoryManager.copyChunkFromSharedToCache(chunk2)) continue;
            this.log.error("Error while copying " + this.directoryManager.getSharedPathFor(chunk2) + " from shared downloads directory to working dir");
        }
        if (!scene_path_file.exists()) {
            scene_path_file.mkdir();
            this.gui.status("Extracting project");
            this.log.debug("Client::prepareWorkingDirectory Extracting project into " + scene_path);
            ret = Utils.unzipChunksIntoDirectory(ajob.getArchiveChunks().stream().map(chunk -> this.directoryManager.getCachePathFor((Chunk)chunk)).collect(Collectors.toList()), scene_path, ajob.getPassword(), this.log);
            if (ret != 0) {
                this.log.error("Client::prepareWorkingDirectory, error(2) with Utils.unzipChunksIntoDirectory returned " + ret);
                this.gui.error(String.format("Unable to extract the scene (error %d)", ret));
                return -2;
            }
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Error.Type confirmJob(Job ajob, int checkpoint) {
        Object url_real = String.format(LOCALE, "%s&rendertime=%d&memoryused=%s", ajob.getValidationUrl(), ajob.getProcessRender().getRenderDuration(), ajob.getProcessRender().getPeakMemoryUsed());
        if ((double)ajob.getSpeedSamplesRendered() > 0.0) {
            url_real = (String)url_real + String.format(LOCALE, "&speedsamples=%s", Float.valueOf(ajob.getSpeedSamplesRendered()));
        }
        this.log.debug(checkpoint, "Client::confirmeJob url " + (String)url_real);
        this.log.debug(checkpoint, "path frame " + ajob.getOutputImagePath());
        this.isValidatingJob = true;
        int max_try = 3;
        int timeToSleep = 22000;
        Error.ServerCode ret = Error.ServerCode.UNKNOWN;
        Error.Type confirmJobReturnCode = Error.Type.OK;
        block11: for (int nb_try = 0; nb_try < max_try; ++nb_try) {
            if (nb_try >= 1) {
                this.log.debug(checkpoint, "Sleep for " + timeToSleep / 1000 + "s before trying to re-upload the frame, previous error: " + confirmJobReturnCode);
                try {
                    Thread.sleep(timeToSleep);
                }
                catch (InterruptedException e) {
                    confirmJobReturnCode = Error.Type.UNKNOWN;
                }
                timeToSleep *= 2;
            }
            ret = this.server.HTTPSendFile((String)url_real, ajob.getOutputImagePath(), checkpoint, this.gui);
            switch (ret) {
                case OK: {
                    break block11;
                }
                case JOB_VALIDATION_ERROR_SESSION_DISABLED: 
                case JOB_VALIDATION_ERROR_BROKEN_MACHINE: {
                    confirmJobReturnCode = Error.Type.SESSION_DISABLED;
                    break block11;
                }
                case JOB_VALIDATION_ERROR_IMAGE_WRONG_DIMENSION: {
                    confirmJobReturnCode = Error.Type.IMAGE_WRONG_DIMENSION;
                    break block11;
                }
                case JOB_VALIDATION_ERROR_MISSING_PARAMETER: {
                    confirmJobReturnCode = Error.Type.UNKNOWN;
                    break block11;
                }
                case JOB_VALIDATION_IMAGE_TOO_LARGE: {
                    confirmJobReturnCode = Error.Type.IMAGE_TOO_LARGE;
                    break block11;
                }
                case SERVER_CONNECTION_FAILED: {
                    confirmJobReturnCode = Error.Type.NETWORK_ISSUE;
                    break;
                }
                case ERROR_BAD_RESPONSE: {
                    confirmJobReturnCode = Error.Type.ERROR_BAD_UPLOAD_RESPONSE;
                }
            }
        }
        this.isValidatingJob = false;
        this.previousJob = ajob;
        if (confirmJobReturnCode == Error.Type.OK && Integer.parseInt(ajob.getId()) >= 20) {
            this.gui.AddFrameRendered();
        }
        File frame = new File(ajob.getOutputImagePath());
        frame.delete();
        ajob.setOutputImagePath(null);
        if (ajob.getPreviewImagePath() != null) {
            frame = new File(ajob.getPreviewImagePath());
            frame.delete();
            ajob.setPreviewImagePath(null);
        }
        return confirmJobReturnCode;
    }

    protected boolean shouldWaitBeforeRender() {
        int concurrent_job = this.jobsToValidate.size();
        if (this.isValidatingJob) {
            ++concurrent_job;
        }
        return concurrent_job >= this.configuration.getMaxUploadingJob();
    }

    public DirectoryManager getDirectoryManager() {
        return this.directoryManager;
    }

    public Gui getGui() {
        return this.gui;
    }

    public Server getServer() {
        return this.server;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Log getLog() {
        return this.log;
    }

    public Job getRenderingJob() {
        return this.renderingJob;
    }

    public Job getPreviousJob() {
        return this.previousJob;
    }

    public BlockingQueue<QueuedJob> getJobsToValidate() {
        return this.jobsToValidate;
    }

    public boolean isValidatingJob() {
        return this.isValidatingJob;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public boolean isSessionStarted() {
        return this.sessionStarted;
    }

    public boolean isDisableErrorSending() {
        return this.disableErrorSending;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isAwaitingStop() {
        return this.awaitingStop;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public boolean isShuttingdown() {
        return this.shuttingdown;
    }

    public int getUploadQueueSize() {
        return this.uploadQueueSize;
    }

    public long getUploadQueueVolume() {
        return this.uploadQueueVolume;
    }

    public int getNoJobRetryIter() {
        return this.noJobRetryIter;
    }

    public void setDirectoryManager(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }

    public void setGui(Gui gui) {
        this.gui = gui;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public void setRenderingJob(Job renderingJob) {
        this.renderingJob = renderingJob;
    }

    public void setPreviousJob(Job previousJob) {
        this.previousJob = previousJob;
    }

    public void setJobsToValidate(BlockingQueue<QueuedJob> jobsToValidate) {
        this.jobsToValidate = jobsToValidate;
    }

    public void setValidatingJob(boolean isValidatingJob) {
        this.isValidatingJob = isValidatingJob;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void setSessionStarted(boolean sessionStarted) {
        this.sessionStarted = sessionStarted;
    }

    public void setDisableErrorSending(boolean disableErrorSending) {
        this.disableErrorSending = disableErrorSending;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public void setAwaitingStop(boolean awaitingStop) {
        this.awaitingStop = awaitingStop;
    }

    public void setSuspended(boolean suspended) {
        this.suspended = suspended;
    }

    public void setShuttingdown(boolean shuttingdown) {
        this.shuttingdown = shuttingdown;
    }

    public void setUploadQueueSize(int uploadQueueSize) {
        this.uploadQueueSize = uploadQueueSize;
    }

    public void setUploadQueueVolume(long uploadQueueVolume) {
        this.uploadQueueVolume = uploadQueueVolume;
    }

    public void setNoJobRetryIter(int noJobRetryIter) {
        this.noJobRetryIter = noJobRetryIter;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Client)) {
            return false;
        }
        Client other = (Client)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isValidatingJob() != other.isValidatingJob()) {
            return false;
        }
        if (this.getStartTime() != other.getStartTime()) {
            return false;
        }
        if (this.isSessionStarted() != other.isSessionStarted()) {
            return false;
        }
        if (this.isDisableErrorSending() != other.isDisableErrorSending()) {
            return false;
        }
        if (this.isRunning() != other.isRunning()) {
            return false;
        }
        if (this.isAwaitingStop() != other.isAwaitingStop()) {
            return false;
        }
        if (this.isSuspended() != other.isSuspended()) {
            return false;
        }
        if (this.isShuttingdown() != other.isShuttingdown()) {
            return false;
        }
        if (this.getUploadQueueSize() != other.getUploadQueueSize()) {
            return false;
        }
        if (this.getUploadQueueVolume() != other.getUploadQueueVolume()) {
            return false;
        }
        if (this.getNoJobRetryIter() != other.getNoJobRetryIter()) {
            return false;
        }
        DirectoryManager this$directoryManager = this.getDirectoryManager();
        DirectoryManager other$directoryManager = other.getDirectoryManager();
        if (this$directoryManager == null ? other$directoryManager != null : !this$directoryManager.equals(other$directoryManager)) {
            return false;
        }
        Gui this$gui = this.getGui();
        Gui other$gui = other.getGui();
        if (this$gui == null ? other$gui != null : !this$gui.equals(other$gui)) {
            return false;
        }
        Server this$server = this.getServer();
        Server other$server = other.getServer();
        if (this$server == null ? other$server != null : !this$server.equals(other$server)) {
            return false;
        }
        Configuration this$configuration = this.getConfiguration();
        Configuration other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration)) {
            return false;
        }
        Log this$log = this.getLog();
        Log other$log = other.getLog();
        if (this$log == null ? other$log != null : !this$log.equals(other$log)) {
            return false;
        }
        Job this$renderingJob = this.getRenderingJob();
        Job other$renderingJob = other.getRenderingJob();
        if (this$renderingJob == null ? other$renderingJob != null : !((Object)this$renderingJob).equals(other$renderingJob)) {
            return false;
        }
        Job this$previousJob = this.getPreviousJob();
        Job other$previousJob = other.getPreviousJob();
        if (this$previousJob == null ? other$previousJob != null : !((Object)this$previousJob).equals(other$previousJob)) {
            return false;
        }
        BlockingQueue<QueuedJob> this$jobsToValidate = this.getJobsToValidate();
        BlockingQueue<QueuedJob> other$jobsToValidate = other.getJobsToValidate();
        return !(this$jobsToValidate == null ? other$jobsToValidate != null : !this$jobsToValidate.equals(other$jobsToValidate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Client;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isValidatingJob() ? 79 : 97);
        long $startTime = this.getStartTime();
        result = result * 59 + (int)($startTime >>> 32 ^ $startTime);
        result = result * 59 + (this.isSessionStarted() ? 79 : 97);
        result = result * 59 + (this.isDisableErrorSending() ? 79 : 97);
        result = result * 59 + (this.isRunning() ? 79 : 97);
        result = result * 59 + (this.isAwaitingStop() ? 79 : 97);
        result = result * 59 + (this.isSuspended() ? 79 : 97);
        result = result * 59 + (this.isShuttingdown() ? 79 : 97);
        result = result * 59 + this.getUploadQueueSize();
        long $uploadQueueVolume = this.getUploadQueueVolume();
        result = result * 59 + (int)($uploadQueueVolume >>> 32 ^ $uploadQueueVolume);
        result = result * 59 + this.getNoJobRetryIter();
        DirectoryManager $directoryManager = this.getDirectoryManager();
        result = result * 59 + ($directoryManager == null ? 43 : $directoryManager.hashCode());
        Gui $gui = this.getGui();
        result = result * 59 + ($gui == null ? 43 : $gui.hashCode());
        Server $server = this.getServer();
        result = result * 59 + ($server == null ? 43 : $server.hashCode());
        Configuration $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
        Log $log = this.getLog();
        result = result * 59 + ($log == null ? 43 : $log.hashCode());
        Job $renderingJob = this.getRenderingJob();
        result = result * 59 + ($renderingJob == null ? 43 : ((Object)$renderingJob).hashCode());
        Job $previousJob = this.getPreviousJob();
        result = result * 59 + ($previousJob == null ? 43 : ((Object)$previousJob).hashCode());
        BlockingQueue<QueuedJob> $jobsToValidate = this.getJobsToValidate();
        result = result * 59 + ($jobsToValidate == null ? 43 : $jobsToValidate.hashCode());
        return result;
    }

    class QueuedJob {
        private final int checkpoint;
        private final Job job;

        public QueuedJob(int checkpoint, Job job) {
            this.checkpoint = checkpoint;
            this.job = job;
        }
    }
}

