/*
 * Decompiled with CFR 0.152.
 */
package com.sheepit.client;

import com.sheepit.client.Client;
import com.sheepit.client.Pair;
import com.sheepit.client.Utils;
import com.sheepit.client.hardware.cpu.CPU;
import com.sheepit.client.hardware.gpu.GPUDevice;
import com.sheepit.client.os.OS;
import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class Configuration {
    public static final String jarVersion = Configuration.getJarVersion();
    private String configFilePath;
    private File workingDirectory;
    private File sharedDownloadsDirectory;
    private File storageDirectory;
    private boolean userHasSpecifiedACacheDir;
    private String static_exeDirName;
    private String login;
    private String password;
    private String proxy;
    private int maxUploadingJob;
    private int nbCores;
    private long maxAllowedMemory;
    private int maxRenderTime;
    private int priority;
    private ComputeType computeMethod;
    private GPUDevice GPUDevice;
    private boolean detectGPUs;
    private boolean printLog;
    private List<Pair<Calendar, Calendar>> requestTime;
    private long shutdownTime;
    private String shutdownMode;
    private String extras;
    private boolean autoSignIn;
    private boolean useSysTray;
    private boolean headless;
    private String UIType;
    private String hostname;
    private String theme;

    public Configuration(File cache_dir_, String login_, String password_) {
        this.configFilePath = null;
        this.login = login_;
        this.password = password_;
        this.proxy = null;
        this.hostname = this.getDefaultHostname();
        this.static_exeDirName = "exe";
        this.maxUploadingJob = 1;
        this.nbCores = -1;
        this.maxAllowedMemory = -1L;
        this.maxRenderTime = -1;
        this.priority = 19;
        this.computeMethod = null;
        this.GPUDevice = null;
        this.userHasSpecifiedACacheDir = false;
        this.detectGPUs = true;
        this.workingDirectory = null;
        this.sharedDownloadsDirectory = null;
        this.storageDirectory = null;
        this.setCacheDir(cache_dir_);
        this.printLog = false;
        this.requestTime = null;
        this.shutdownTime = -1L;
        this.shutdownMode = "soft";
        this.extras = "";
        this.autoSignIn = false;
        this.useSysTray = false;
        this.headless = GraphicsEnvironment.isHeadless();
        this.UIType = null;
        this.theme = null;
    }

    public String toString() {
        String c = "    CFG: ";
        String n = "\n";
        return c + "version:                   " + Configuration.getJarVersion() + n + c + "configFilePath:            " + this.configFilePath + n + c + "workingDirectory:          " + this.workingDirectory + n + c + "sharedDownloadsDirectory:  " + this.sharedDownloadsDirectory + n + c + "storageDirectory:          " + this.storageDirectory + n + c + "userHasSpecifiedACacheDir: " + this.userHasSpecifiedACacheDir + n + c + "static_exeDirName:         " + this.static_exeDirName + n + c + "login:                     " + this.login + n + c + "proxy:                     " + this.proxy + n + c + "maxUploadingJob:           " + this.maxUploadingJob + n + c + "nbCores:                   " + this.nbCores + n + c + "maxAllowedMemory:          " + this.maxAllowedMemory + n + c + "maxRenderTime:             " + this.maxRenderTime + n + c + "priority:                  " + this.priority + n + c + "computeMethod:             " + this.computeMethod + n + c + "GPUDevice:                 " + this.GPUDevice + n + c + "detectGPUs:                " + this.detectGPUs + n + c + "printLog:                  " + this.printLog + n + c + "requestTime:               " + this.requestTime + n + c + "shutdownTime:              " + this.shutdownTime + n + c + "shutdownMode:              " + this.shutdownMode + n + c + "extras:                    " + this.extras + n + c + "autoSignIn:                " + this.autoSignIn + n + c + "useSysTray:                " + this.useSysTray + n + c + "headless:                  " + this.headless + n + c + "UIType:                    " + this.UIType + n + c + "hostname:                  " + this.hostname + n + c + "theme:                     " + this.theme;
    }

    public void setPriority(int priority) {
        if (priority > 19) {
            priority = 19;
        } else if (priority < -19) {
            priority = -19;
        }
        this.priority = priority;
    }

    public int computeMethodToInt() {
        return this.computeMethod.ordinal();
    }

    public void setCacheDir(File cache_dir_) {
        this.removeWorkingDirectory();
        if (cache_dir_ == null) {
            this.userHasSpecifiedACacheDir = false;
            try {
                this.workingDirectory = File.createTempFile("farm_", "");
                this.workingDirectory.createNewFile();
                this.workingDirectory.delete();
                this.workingDirectory.mkdir();
                this.workingDirectory.deleteOnExit();
                this.storageDirectory = new File(this.workingDirectory.getParent() + File.separator + "sheepit_binary_cache");
                this.storageDirectory.mkdir();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.userHasSpecifiedACacheDir = true;
            this.workingDirectory = new File(cache_dir_.getAbsolutePath() + File.separator + "sheepit");
            this.storageDirectory = new File(cache_dir_.getAbsolutePath() + File.separator + "sheepit_binary_cache");
            this.workingDirectory.mkdirs();
            this.storageDirectory.mkdirs();
        }
        if (this.sharedDownloadsDirectory != null) {
            this.sharedDownloadsDirectory.mkdirs();
            if (!this.sharedDownloadsDirectory.exists()) {
                System.err.println("Configuration::setCacheDir Unable to create common directory " + this.sharedDownloadsDirectory.getAbsolutePath());
            }
        }
    }

    public File getStorageDir() {
        return this.storageDirectory == null ? this.workingDirectory : this.storageDirectory;
    }

    public File getCacheDirForSettings() {
        return !this.userHasSpecifiedACacheDir ? null : this.workingDirectory.getParentFile();
    }

    public String getDefaultHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "";
        }
    }

    public void cleanWorkingDirectory() {
        this.cleanDirectory(this.workingDirectory);
        this.cleanDirectory(this.storageDirectory);
    }

    public boolean cleanDirectory(File dir) {
        if (dir == null) {
            return false;
        }
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    Utils.delete(file);
                    continue;
                }
                try {
                    String extension = file.getName().substring(file.getName().lastIndexOf(46)).toLowerCase();
                    String name = file.getName().substring(0, file.getName().length() - 1 * extension.length());
                    if (extension.equals(".zip") || extension.equals(".wool")) {
                        String md5_local = Utils.md5(file.getAbsolutePath());
                        if (md5_local.equals(name)) continue;
                        file.delete();
                        continue;
                    }
                    file.delete();
                }
                catch (StringIndexOutOfBoundsException e) {
                    file.delete();
                }
            }
        }
        return true;
    }

    public void removeWorkingDirectory() {
        if (this.userHasSpecifiedACacheDir) {
            this.cleanWorkingDirectory();
        } else {
            Utils.delete(this.workingDirectory);
        }
    }

    public List<File> getLocalCacheFiles() {
        File[] filesInDirectory;
        LinkedList<File> files_local = new LinkedList<File>();
        LinkedList<File> files = new LinkedList<File>();
        if (this.workingDirectory != null && (filesInDirectory = this.workingDirectory.listFiles()) != null) {
            files.addAll(Arrays.asList(filesInDirectory));
        }
        if (this.storageDirectory != null && (filesInDirectory = this.storageDirectory.listFiles()) != null) {
            files.addAll(Arrays.asList(filesInDirectory));
        }
        if (this.sharedDownloadsDirectory != null && (filesInDirectory = this.sharedDownloadsDirectory.listFiles()) != null) {
            files.addAll(Arrays.asList(filesInDirectory));
        }
        for (File file : files) {
            if (!file.isFile()) continue;
            try {
                String md5_local;
                String extension = file.getName().substring(file.getName().lastIndexOf(46)).toLowerCase();
                String name = file.getName().substring(0, file.getName().length() - 1 * extension.length());
                if (!extension.equals(".zip") && !extension.equals(".wool") || !(md5_local = Utils.md5(file.getAbsolutePath())).equals(name)) continue;
                files_local.add(file);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
        }
        return files_local;
    }

    public ArrayList<String> filesystemHealthCheck() {
        ArrayList<String> logs = new ArrayList<String>();
        String f = "FSHealth: ";
        logs.add(f + "FilesystemHealthCheck started");
        ArrayList<File> dirsToCheck = new ArrayList<File>();
        ArrayList<File> dirsChecked = new ArrayList<File>();
        dirsToCheck.add(this.workingDirectory.getAbsoluteFile());
        if (this.sharedDownloadsDirectory != null && !dirsToCheck.contains(this.sharedDownloadsDirectory.getAbsoluteFile())) {
            dirsToCheck.add(this.sharedDownloadsDirectory.getAbsoluteFile());
        }
        if (this.storageDirectory != null && !dirsToCheck.contains(this.storageDirectory.getAbsoluteFile())) {
            dirsToCheck.add(this.storageDirectory.getAbsoluteFile());
        }
        ListIterator<File> dirs = dirsToCheck.listIterator();
        while (dirs.hasNext()) {
            File dir = (File)dirs.next();
            dirs.remove();
            dirsChecked.add(dir);
            File[] fileList = dir.listFiles();
            if (fileList == null) {
                logs.add(f + "File list of " + dir + " is null");
                continue;
            }
            for (File file : fileList) {
                file = file.getAbsoluteFile();
                boolean canRead = file.canRead();
                boolean canWrite = file.canWrite();
                boolean isDir = file.isDirectory();
                if (!canRead) {
                    logs.add(f + "Can't read from " + file);
                }
                if (!canWrite) {
                    logs.add(f + "Can't write to " + file);
                }
                if (!canRead || !canWrite || !isDir) continue;
                if (dirsChecked.contains(file)) {
                    logs.add(f + "Dir " + file + " already checked. Loop detected");
                } else {
                    dirs.add(file);
                }
                long usableSpace = file.getUsableSpace();
                if (usableSpace >= 524288L) continue;
                logs.add(f + "Usable space is " + usableSpace + " for " + file);
            }
        }
        return logs;
    }

    private static String getJarVersion() {
        String versionPath = "/VERSION";
        String version = "6.0.0";
        InputStream versionStream = Client.class.getResourceAsStream(versionPath);
        if (versionStream != null) {
            try {
                BufferedReader in = new BufferedReader(new InputStreamReader(versionStream));
                version = in.readLine();
            }
            catch (IOException ex) {
                System.err.println("Configuration::getJarVersion error while reading manifest file (" + versionPath + "): " + ex.getMessage());
            }
        } else {
            System.err.println("Configuration::getJarVersion Failed to get version file");
        }
        return version;
    }

    public boolean checkOSisSupported() {
        return OS.getOS() != null && OS.getOS().isSupported();
    }

    public boolean checkCPUisSupported() {
        OS os = OS.getOS();
        if (os != null) {
            CPU cpu = os.getCPU();
            return cpu != null && cpu.haveData();
        }
        return false;
    }

    public Configuration(String configFilePath, File workingDirectory, File sharedDownloadsDirectory, File storageDirectory, boolean userHasSpecifiedACacheDir, String static_exeDirName, String login, String password, String proxy, int maxUploadingJob, int nbCores, long maxAllowedMemory, int maxRenderTime, int priority, ComputeType computeMethod, GPUDevice GPUDevice2, boolean detectGPUs, boolean printLog, List<Pair<Calendar, Calendar>> requestTime, long shutdownTime, String shutdownMode, String extras, boolean autoSignIn, boolean useSysTray, boolean headless, String UIType, String hostname, String theme) {
        this.configFilePath = configFilePath;
        this.workingDirectory = workingDirectory;
        this.sharedDownloadsDirectory = sharedDownloadsDirectory;
        this.storageDirectory = storageDirectory;
        this.userHasSpecifiedACacheDir = userHasSpecifiedACacheDir;
        this.static_exeDirName = static_exeDirName;
        this.login = login;
        this.password = password;
        this.proxy = proxy;
        this.maxUploadingJob = maxUploadingJob;
        this.nbCores = nbCores;
        this.maxAllowedMemory = maxAllowedMemory;
        this.maxRenderTime = maxRenderTime;
        this.priority = priority;
        this.computeMethod = computeMethod;
        this.GPUDevice = GPUDevice2;
        this.detectGPUs = detectGPUs;
        this.printLog = printLog;
        this.requestTime = requestTime;
        this.shutdownTime = shutdownTime;
        this.shutdownMode = shutdownMode;
        this.extras = extras;
        this.autoSignIn = autoSignIn;
        this.useSysTray = useSysTray;
        this.headless = headless;
        this.UIType = UIType;
        this.hostname = hostname;
        this.theme = theme;
    }

    public String getConfigFilePath() {
        return this.configFilePath;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public File getSharedDownloadsDirectory() {
        return this.sharedDownloadsDirectory;
    }

    public File getStorageDirectory() {
        return this.storageDirectory;
    }

    public boolean isUserHasSpecifiedACacheDir() {
        return this.userHasSpecifiedACacheDir;
    }

    public String getStatic_exeDirName() {
        return this.static_exeDirName;
    }

    public String getLogin() {
        return this.login;
    }

    public String getPassword() {
        return this.password;
    }

    public String getProxy() {
        return this.proxy;
    }

    public int getMaxUploadingJob() {
        return this.maxUploadingJob;
    }

    public int getNbCores() {
        return this.nbCores;
    }

    public long getMaxAllowedMemory() {
        return this.maxAllowedMemory;
    }

    public int getMaxRenderTime() {
        return this.maxRenderTime;
    }

    public int getPriority() {
        return this.priority;
    }

    public ComputeType getComputeMethod() {
        return this.computeMethod;
    }

    public GPUDevice getGPUDevice() {
        return this.GPUDevice;
    }

    public boolean isDetectGPUs() {
        return this.detectGPUs;
    }

    public boolean isPrintLog() {
        return this.printLog;
    }

    public List<Pair<Calendar, Calendar>> getRequestTime() {
        return this.requestTime;
    }

    public long getShutdownTime() {
        return this.shutdownTime;
    }

    public String getShutdownMode() {
        return this.shutdownMode;
    }

    public String getExtras() {
        return this.extras;
    }

    public boolean isAutoSignIn() {
        return this.autoSignIn;
    }

    public boolean isUseSysTray() {
        return this.useSysTray;
    }

    public boolean isHeadless() {
        return this.headless;
    }

    public String getUIType() {
        return this.UIType;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getTheme() {
        return this.theme;
    }

    public void setConfigFilePath(String configFilePath) {
        this.configFilePath = configFilePath;
    }

    public void setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public void setSharedDownloadsDirectory(File sharedDownloadsDirectory) {
        this.sharedDownloadsDirectory = sharedDownloadsDirectory;
    }

    public void setStorageDirectory(File storageDirectory) {
        this.storageDirectory = storageDirectory;
    }

    public void setUserHasSpecifiedACacheDir(boolean userHasSpecifiedACacheDir) {
        this.userHasSpecifiedACacheDir = userHasSpecifiedACacheDir;
    }

    public void setStatic_exeDirName(String static_exeDirName) {
        this.static_exeDirName = static_exeDirName;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setProxy(String proxy) {
        this.proxy = proxy;
    }

    public void setMaxUploadingJob(int maxUploadingJob) {
        this.maxUploadingJob = maxUploadingJob;
    }

    public void setNbCores(int nbCores) {
        this.nbCores = nbCores;
    }

    public void setMaxAllowedMemory(long maxAllowedMemory) {
        this.maxAllowedMemory = maxAllowedMemory;
    }

    public void setMaxRenderTime(int maxRenderTime) {
        this.maxRenderTime = maxRenderTime;
    }

    public void setComputeMethod(ComputeType computeMethod) {
        this.computeMethod = computeMethod;
    }

    public void setGPUDevice(GPUDevice GPUDevice2) {
        this.GPUDevice = GPUDevice2;
    }

    public void setDetectGPUs(boolean detectGPUs) {
        this.detectGPUs = detectGPUs;
    }

    public void setPrintLog(boolean printLog) {
        this.printLog = printLog;
    }

    public void setRequestTime(List<Pair<Calendar, Calendar>> requestTime) {
        this.requestTime = requestTime;
    }

    public void setShutdownTime(long shutdownTime) {
        this.shutdownTime = shutdownTime;
    }

    public void setShutdownMode(String shutdownMode) {
        this.shutdownMode = shutdownMode;
    }

    public void setExtras(String extras) {
        this.extras = extras;
    }

    public void setAutoSignIn(boolean autoSignIn) {
        this.autoSignIn = autoSignIn;
    }

    public void setUseSysTray(boolean useSysTray) {
        this.useSysTray = useSysTray;
    }

    public void setHeadless(boolean headless) {
        this.headless = headless;
    }

    public void setUIType(String UIType) {
        this.UIType = UIType;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setTheme(String theme) {
        this.theme = theme;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Configuration)) {
            return false;
        }
        Configuration other = (Configuration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isUserHasSpecifiedACacheDir() != other.isUserHasSpecifiedACacheDir()) {
            return false;
        }
        if (this.getMaxUploadingJob() != other.getMaxUploadingJob()) {
            return false;
        }
        if (this.getNbCores() != other.getNbCores()) {
            return false;
        }
        if (this.getMaxAllowedMemory() != other.getMaxAllowedMemory()) {
            return false;
        }
        if (this.getMaxRenderTime() != other.getMaxRenderTime()) {
            return false;
        }
        if (this.getPriority() != other.getPriority()) {
            return false;
        }
        if (this.isDetectGPUs() != other.isDetectGPUs()) {
            return false;
        }
        if (this.isPrintLog() != other.isPrintLog()) {
            return false;
        }
        if (this.getShutdownTime() != other.getShutdownTime()) {
            return false;
        }
        if (this.isAutoSignIn() != other.isAutoSignIn()) {
            return false;
        }
        if (this.isUseSysTray() != other.isUseSysTray()) {
            return false;
        }
        if (this.isHeadless() != other.isHeadless()) {
            return false;
        }
        String this$configFilePath = this.getConfigFilePath();
        String other$configFilePath = other.getConfigFilePath();
        if (this$configFilePath == null ? other$configFilePath != null : !this$configFilePath.equals(other$configFilePath)) {
            return false;
        }
        File this$workingDirectory = this.getWorkingDirectory();
        File other$workingDirectory = other.getWorkingDirectory();
        if (this$workingDirectory == null ? other$workingDirectory != null : !((Object)this$workingDirectory).equals(other$workingDirectory)) {
            return false;
        }
        File this$sharedDownloadsDirectory = this.getSharedDownloadsDirectory();
        File other$sharedDownloadsDirectory = other.getSharedDownloadsDirectory();
        if (this$sharedDownloadsDirectory == null ? other$sharedDownloadsDirectory != null : !((Object)this$sharedDownloadsDirectory).equals(other$sharedDownloadsDirectory)) {
            return false;
        }
        File this$storageDirectory = this.getStorageDirectory();
        File other$storageDirectory = other.getStorageDirectory();
        if (this$storageDirectory == null ? other$storageDirectory != null : !((Object)this$storageDirectory).equals(other$storageDirectory)) {
            return false;
        }
        String this$static_exeDirName = this.getStatic_exeDirName();
        String other$static_exeDirName = other.getStatic_exeDirName();
        if (this$static_exeDirName == null ? other$static_exeDirName != null : !this$static_exeDirName.equals(other$static_exeDirName)) {
            return false;
        }
        String this$login = this.getLogin();
        String other$login = other.getLogin();
        if (this$login == null ? other$login != null : !this$login.equals(other$login)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$proxy = this.getProxy();
        String other$proxy = other.getProxy();
        if (this$proxy == null ? other$proxy != null : !this$proxy.equals(other$proxy)) {
            return false;
        }
        ComputeType this$computeMethod = this.getComputeMethod();
        ComputeType other$computeMethod = other.getComputeMethod();
        if (this$computeMethod == null ? other$computeMethod != null : !((Object)((Object)this$computeMethod)).equals((Object)other$computeMethod)) {
            return false;
        }
        GPUDevice this$GPUDevice = this.getGPUDevice();
        GPUDevice other$GPUDevice = other.getGPUDevice();
        if (this$GPUDevice == null ? other$GPUDevice != null : !((Object)this$GPUDevice).equals(other$GPUDevice)) {
            return false;
        }
        List<Pair<Calendar, Calendar>> this$requestTime = this.getRequestTime();
        List<Pair<Calendar, Calendar>> other$requestTime = other.getRequestTime();
        if (this$requestTime == null ? other$requestTime != null : !((Object)this$requestTime).equals(other$requestTime)) {
            return false;
        }
        String this$shutdownMode = this.getShutdownMode();
        String other$shutdownMode = other.getShutdownMode();
        if (this$shutdownMode == null ? other$shutdownMode != null : !this$shutdownMode.equals(other$shutdownMode)) {
            return false;
        }
        String this$extras = this.getExtras();
        String other$extras = other.getExtras();
        if (this$extras == null ? other$extras != null : !this$extras.equals(other$extras)) {
            return false;
        }
        String this$UIType = this.getUIType();
        String other$UIType = other.getUIType();
        if (this$UIType == null ? other$UIType != null : !this$UIType.equals(other$UIType)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        String this$theme = this.getTheme();
        String other$theme = other.getTheme();
        return !(this$theme == null ? other$theme != null : !this$theme.equals(other$theme));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Configuration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUserHasSpecifiedACacheDir() ? 79 : 97);
        result = result * 59 + this.getMaxUploadingJob();
        result = result * 59 + this.getNbCores();
        long $maxAllowedMemory = this.getMaxAllowedMemory();
        result = result * 59 + (int)($maxAllowedMemory >>> 32 ^ $maxAllowedMemory);
        result = result * 59 + this.getMaxRenderTime();
        result = result * 59 + this.getPriority();
        result = result * 59 + (this.isDetectGPUs() ? 79 : 97);
        result = result * 59 + (this.isPrintLog() ? 79 : 97);
        long $shutdownTime = this.getShutdownTime();
        result = result * 59 + (int)($shutdownTime >>> 32 ^ $shutdownTime);
        result = result * 59 + (this.isAutoSignIn() ? 79 : 97);
        result = result * 59 + (this.isUseSysTray() ? 79 : 97);
        result = result * 59 + (this.isHeadless() ? 79 : 97);
        String $configFilePath = this.getConfigFilePath();
        result = result * 59 + ($configFilePath == null ? 43 : $configFilePath.hashCode());
        File $workingDirectory = this.getWorkingDirectory();
        result = result * 59 + ($workingDirectory == null ? 43 : ((Object)$workingDirectory).hashCode());
        File $sharedDownloadsDirectory = this.getSharedDownloadsDirectory();
        result = result * 59 + ($sharedDownloadsDirectory == null ? 43 : ((Object)$sharedDownloadsDirectory).hashCode());
        File $storageDirectory = this.getStorageDirectory();
        result = result * 59 + ($storageDirectory == null ? 43 : ((Object)$storageDirectory).hashCode());
        String $static_exeDirName = this.getStatic_exeDirName();
        result = result * 59 + ($static_exeDirName == null ? 43 : $static_exeDirName.hashCode());
        String $login = this.getLogin();
        result = result * 59 + ($login == null ? 43 : $login.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $proxy = this.getProxy();
        result = result * 59 + ($proxy == null ? 43 : $proxy.hashCode());
        ComputeType $computeMethod = this.getComputeMethod();
        result = result * 59 + ($computeMethod == null ? 43 : ((Object)((Object)$computeMethod)).hashCode());
        GPUDevice $GPUDevice = this.getGPUDevice();
        result = result * 59 + ($GPUDevice == null ? 43 : ((Object)$GPUDevice).hashCode());
        List<Pair<Calendar, Calendar>> $requestTime = this.getRequestTime();
        result = result * 59 + ($requestTime == null ? 43 : ((Object)$requestTime).hashCode());
        String $shutdownMode = this.getShutdownMode();
        result = result * 59 + ($shutdownMode == null ? 43 : $shutdownMode.hashCode());
        String $extras = this.getExtras();
        result = result * 59 + ($extras == null ? 43 : $extras.hashCode());
        String $UIType = this.getUIType();
        result = result * 59 + ($UIType == null ? 43 : $UIType.hashCode());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        String $theme = this.getTheme();
        result = result * 59 + ($theme == null ? 43 : $theme.hashCode());
        return result;
    }

    public static enum ComputeType {
        CPU_GPU,
        CPU,
        GPU;

    }
}

