/*
 * Decompiled with CFR 0.152.
 */
package com.sheepit.client;

import com.sheepit.client.Configuration;
import com.sheepit.client.Job;
import com.sheepit.client.Log;
import com.sheepit.client.datamodel.Chunk;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;

public class DirectoryManager {
    private Configuration configuration;
    private Log log;

    public String getActualStoragePathFor(Chunk chunk) {
        return this.isSharedEnabled() ? this.getSharedPathFor(chunk) : this.getCachePathFor(chunk);
    }

    public String getActualStorageBinaryPathFor(Job job) {
        return this.isSharedEnabled() ? this.getSharedBinaryPathFor(job) : this.getCacheBinaryPathFor(job);
    }

    public String getCachePathFor(Chunk chunk) {
        return this.configuration.getWorkingDirectory().getAbsolutePath() + File.separator + chunk.getId() + ".wool";
    }

    public String getSharedPathFor(Chunk chunk) {
        return this.configuration.getSharedDownloadsDirectory().getAbsolutePath() + File.separator + chunk.getId() + ".wool";
    }

    public String getCacheBinaryPathFor(Job job) {
        return this.configuration.getStorageDir().getAbsolutePath() + File.separator + job.getRendererMD5() + ".zip";
    }

    public String getSharedBinaryPathFor(Job job) {
        return this.configuration.getSharedDownloadsDirectory().getAbsolutePath() + File.separator + job.getRendererMD5() + ".zip";
    }

    public boolean isSharedEnabled() {
        return this.configuration.getSharedDownloadsDirectory() != null && this.configuration.getSharedDownloadsDirectory().exists();
    }

    public boolean copyBinaryFromSharedToCache(Job job) {
        return this.copyFileFromSharedToCache(this.getSharedBinaryPathFor(job), this.getCacheBinaryPathFor(job));
    }

    public boolean copyChunkFromSharedToCache(Chunk chunk) {
        return this.copyFileFromSharedToCache(this.getSharedPathFor(chunk), this.getCachePathFor(chunk));
    }

    private boolean copyFileFromSharedToCache(String source2, String target) {
        Path targetArchivePath;
        Path existingArchivePath = Paths.get(source2, new String[0]);
        if (existingArchivePath.equals(targetArchivePath = Paths.get(target, new String[0]))) {
            return true;
        }
        try {
            try {
                Files.createLink(targetArchivePath, existingArchivePath);
                this.log.debug("Created hardlink from " + targetArchivePath + " to " + existingArchivePath);
            }
            catch (SecurityException | UnsupportedOperationException | FileSystemException ignore) {
                this.log.debug("Failed to create hardlink, falling back to copying file to " + targetArchivePath);
                Files.copy(existingArchivePath, targetArchivePath, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException e) {
            this.log.error("Error while copying " + source2 + " from shared downloads directory to working dir");
            return false;
        }
        return true;
    }

    public DirectoryManager(Configuration configuration, Log log) {
        this.configuration = configuration;
        this.log = log;
    }
}

