/*
 * Decompiled with CFR 0.152.
 */
package com.sheepit.client;

import com.sheepit.client.Error;
import com.sheepit.client.Gui;
import com.sheepit.client.Log;
import com.sheepit.client.Server;
import com.sheepit.client.Utils;
import com.sheepit.client.exception.SheepItException;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Random;
import java.util.concurrent.TimeUnit;

public class DownloadManager {
    private static int maxDownloadFileAttempts = 5;
    private Server server;
    private Gui gui;
    private Log log;
    private String gui_text;
    private String local_target;
    private String md5;
    private String remote;

    public DownloadManager(Server server, Gui gui, Log log, String gui_text, String local_target, String md5, String remote) {
        this.server = server;
        this.gui = gui;
        this.gui_text = gui_text;
        this.log = log;
        this.local_target = local_target;
        this.md5 = md5;
        this.remote = remote;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Error.Type download() throws SheepItException {
        File local_path_file = new File(this.local_target);
        int remaining = 1800000;
        try {
            int wait;
            do {
                if (local_path_file.exists()) {
                    this.gui.status("Reusing cached " + this.gui_text);
                    Error.Type type = Error.Type.OK;
                    return type;
                }
                if (!this.lockExists()) {
                    this.createLock();
                    break;
                }
                if (remaining % 10000 == 0) {
                    this.gui.status(String.format("Another client is downloading the %s. Cancel in %dmin %ds", this.gui_text, TimeUnit.MILLISECONDS.toMinutes(remaining), TimeUnit.MILLISECONDS.toSeconds(remaining) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(remaining))));
                }
                wait = 1 + new Random().nextInt(2000);
                Thread.sleep(wait);
            } while ((remaining -= wait) > 0);
        }
        catch (InterruptedException e) {
            this.log.debug("Error in the thread wait. Exception " + e.getMessage());
        }
        finally {
            if (remaining <= 0) {
                this.log.debug("ERROR while waiting for download to finish in another client. Deleting the partial file and downloading a fresh copy now!.");
                this.removeLock();
            }
        }
        this.gui.status(String.format("Downloading %s", this.gui_text));
        return this.downloadActual();
    }

    private Error.Type downloadActual() throws SheepItException {
        String update_ui = "Downloading " + this.gui_text;
        Error.Type ret = this.server.HTTPGetFile(this.remote, this.local_target, this.gui, update_ui);
        if (ret == Error.Type.RENDERER_KILLED_BY_SERVER || ret == Error.Type.RENDERER_KILLED_BY_USER_OVER_TIME || ret == Error.Type.RENDERER_KILLED_BY_USER) {
            return ret;
        }
        boolean md5_check = this.check();
        int attempts = 1;
        if (ret != Error.Type.OK || !md5_check) {
            if (attempts < maxDownloadFileAttempts) {
                if (ret != Error.Type.OK) {
                    this.gui.error(String.format("Unable to download %s (error %s). Retrying now", new Object[]{this.gui_text, ret}));
                    this.log.debug("DownloadManager::downloadActual problem with Server.HTTPGetFile (return: " + ret + ") removing local file (path: " + this.local_target + ")");
                } else if (!md5_check) {
                    this.gui.error(String.format("Verification of downloaded %s has failed. Retrying now", this.gui_text));
                    this.log.debug("DownloadManager::downloadActual problem with Client::checkFile mismatch on md5, removing local file (path: " + this.local_target + ")");
                }
                new File(this.local_target).delete();
                this.log.debug("DownloadManager::downloadActual failed, let's try again (" + (attempts + 1) + "/" + maxDownloadFileAttempts + ") ...");
                String partial_target = this.local_target + ".partial";
                ret = this.server.HTTPGetFile(this.remote, partial_target, this.gui, update_ui);
                md5_check = this.check();
                ++attempts;
                if (ret != Error.Type.OK || !md5_check) {
                    if (attempts >= maxDownloadFileAttempts) {
                        this.log.debug("DownloadManager::downloadActual failed after " + maxDownloadFileAttempts + " attempts, removing local file (path: " + this.local_target + "), stopping...");
                        return Error.Type.DOWNLOAD_FILE;
                    }
                }
                return new File(partial_target).renameTo(new File(this.local_target)) ? Error.Type.OK : Error.Type.DOWNLOAD_FILE;
            }
        }
        return Error.Type.OK;
    }

    private boolean check() {
        File local_path_file = new File(this.local_target);
        if (!local_path_file.exists()) {
            this.log.error("DownloadManager::check cannot check md5 on a nonexistent file (path: " + this.local_target + ")");
            return false;
        }
        String md5_local = Utils.md5(this.local_target);
        if (!md5_local.equals(this.md5)) {
            this.log.error("DownloadManager::check mismatch on md5 local: '" + md5_local + "' server: '" + this.md5 + "' (local size: " + new File(this.local_target).length() + ")");
            return false;
        }
        return true;
    }

    private boolean lockExists() {
        return new File(this.local_target + ".partial").exists();
    }

    private void createLock() {
        try {
            File file = new File(this.local_target + ".partial");
            file.createNewFile();
            file.deleteOnExit();
        }
        catch (IOException e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            this.log.error("DownloadManager::createLock Unable to create .partial temp file for binary/scene " + this.local_target);
            this.log.error("DownloadManager::createLock Exception " + e + " stacktrace " + sw.toString());
        }
    }

    private void removeLock() {
        new File(this.local_target + ".partial").delete();
    }
}

