/*
 * Decompiled with CFR 0.152.
 */
package com.sheepit.client;

import com.sheepit.client.Configuration;
import com.sheepit.client.Error;
import com.sheepit.client.Gui;
import com.sheepit.client.Log;
import com.sheepit.client.RenderProcess;
import com.sheepit.client.Utils;
import com.sheepit.client.datamodel.Chunk;
import com.sheepit.client.os.OS;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Optional;
import java.util.TimeZone;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Job {
    public static final String UPDATE_METHOD_BY_REMAINING_TIME = "remainingtime";
    public static final String UPDATE_METHOD_BY_TILE = "by_tile";
    public static final String POST_LOAD_NOTIFICATION = "POST_LOAD_SCRIPT_loaded";
    public static final int SHOW_BASE_ICON = -1;
    private String frameNumber;
    private List<Chunk> archiveChunks;
    private String rendererMD5;
    private String id;
    private String outputImagePath;
    private String previewImagePath;
    private long outputImageSize;
    private String path;
    private String rendererCommand;
    private String validationUrl;
    private String script;
    private boolean useGPU;
    private String name;
    private char[] password;
    private String updateRenderingStatusMethod;
    private String blenderShortVersion;
    private String blenderLongVersion;
    private boolean synchronousUpload;
    private float speedSamplesRendered;
    private RenderProcess render;
    private boolean askForRendererKill;
    private boolean userBlockJob;
    private boolean serverBlockJob;
    private Gui gui;
    private Configuration configuration;
    private Log log;

    public Job(Configuration config_, Gui gui_, Log log_, String id_, String frame_, String path_, boolean use_gpu, String command_, String validationUrl_, String script_, List<Chunk> archiveChunks_, String rendererMd5_, String name_, char[] password_, boolean synchronous_upload_, String update_method_) {
        this.configuration = config_;
        this.id = id_;
        this.frameNumber = frame_;
        this.path = path_;
        this.useGPU = use_gpu;
        this.rendererCommand = command_;
        this.validationUrl = validationUrl_;
        this.archiveChunks = archiveChunks_;
        this.rendererMD5 = rendererMd5_;
        this.name = name_;
        this.password = password_;
        this.synchronousUpload = synchronous_upload_;
        this.gui = gui_;
        this.outputImagePath = null;
        this.outputImageSize = 0L;
        this.script = script_;
        this.updateRenderingStatusMethod = update_method_;
        this.askForRendererKill = false;
        this.userBlockJob = false;
        this.serverBlockJob = false;
        this.log = log_;
        this.render = new RenderProcess(log_);
        this.blenderShortVersion = null;
        this.blenderLongVersion = null;
        this.speedSamplesRendered = 0.0f;
    }

    public void block() {
        this.setAskForRendererKill(true);
        this.setUserBlockJob(true);
        RenderProcess process = this.getProcessRender();
        if (process != null) {
            process.kill();
        }
    }

    public RenderProcess getProcessRender() {
        return this.render;
    }

    public String toString() {
        return String.format("Job (numFrame '%s' archiveChunks %s rendererMD5 '%s' ID '%s' pictureFilename '%s' jobPath '%s' gpu %s name '%s' updateRenderingStatusMethod '%s' render %s)", this.frameNumber, this.archiveChunks, this.rendererMD5, this.id, this.outputImagePath, this.path, this.useGPU, this.name, this.updateRenderingStatusMethod, this.render);
    }

    public String getPrefixOutputImage() {
        return this.id + "_";
    }

    public String getRendererDirectory() {
        return this.configuration.getWorkingDirectory().getAbsolutePath() + File.separator + this.rendererMD5;
    }

    public String getRendererPath() {
        return this.getRendererDirectory() + File.separator + OS.getOS().getRenderBinaryPath();
    }

    public String getSceneDirectory() {
        return this.configuration.getWorkingDirectory().getAbsolutePath() + File.separator + this.id;
    }

    public String getScenePath() {
        return this.getSceneDirectory() + File.separator + this.path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Error.Type render(Observer renderStarted) {
        Object os;
        this.gui.status("Rendering");
        RenderProcess process = this.getProcessRender();
        Timer timerOfMaxRenderTime = null;
        Object core_script = "";
        String ignore_signal_script = "import signal\ndef hndl(signum, frame):\n    pass\nsignal.signal(signal.SIGINT, hndl)\n";
        if (this.isUseGPU() && this.configuration.getGPUDevice() != null && this.configuration.getComputeMethod() != Configuration.ComputeType.CPU) {
            core_script = "sheepit_set_compute_device(\"" + this.configuration.getGPUDevice().getType() + "\", \"GPU\", \"" + this.configuration.getGPUDevice().getId() + "\")\n";
            this.gui.setComputeMethod("GPU");
        } else {
            core_script = "sheepit_set_compute_device(\"NONE\", \"CPU\", \"CPU\")\n";
            this.gui.setComputeMethod("CPU");
        }
        core_script = (String)core_script + ignore_signal_script;
        File disableViewportScript = null;
        File script_file = null;
        String[] command1 = this.getRendererCommand().split(" ");
        int size_command = command1.length + 2;
        if (this.configuration.getNbCores() > 0) {
            size_command += 2;
        }
        ArrayList<String> command = new ArrayList<String>(size_command);
        HashMap<String, String> new_env = new HashMap<String, String>();
        new_env.put("BLENDER_USER_RESOURCES", "");
        new_env.put("BLENDER_USER_CONFIG", "");
        new_env.put("BLENDER_USER_SCRIPTS", "");
        new_env.put("BLENDER_USER_DATAFILES", "");
        new_env.put("BLENDER_SYSTEM_RESOURCES", "");
        new_env.put("BLENDER_SYSTEM_SCRIPTS", "");
        new_env.put("BLENDER_SYSTEM_DATAFILES", "");
        new_env.put("BLENDER_SYSTEM_PYTHON", "");
        new_env.put("OCIO", "");
        new_env.put("TEMP", this.configuration.getWorkingDirectory().getAbsolutePath().replace("\\", "\\\\"));
        new_env.put("TMP", this.configuration.getWorkingDirectory().getAbsolutePath().replace("\\", "\\\\"));
        new_env.put("CORES", Integer.toString(this.configuration.getNbCores()));
        new_env.put("PRIORITY", Integer.toString(this.configuration.getPriority()));
        String currentLDLibraryPath = Optional.ofNullable(System.getenv("LD_LIBRARY_PATH")).orElse("");
        new_env.put("LD_LIBRARY_PATH", this.getRendererDirectory() + "/lib:" + currentLDLibraryPath);
        String[] stringArray = command1;
        int n = stringArray.length;
        block27: for (int i = 0; i < n; ++i) {
            String arg;
            switch (arg = stringArray[i]) {
                case ".c": {
                    StringWriter sw;
                    Object out;
                    File file2;
                    command.add("-P");
                    try {
                        disableViewportScript = File.createTempFile("pre_load_script_", ".py", this.configuration.getWorkingDirectory());
                        file2 = new File(disableViewportScript.getAbsolutePath());
                        FileWriter fwriter = new FileWriter(file2);
                        out = new PrintWriter(fwriter);
                        ((PrintWriter)out).write("import bpy");
                        ((PrintWriter)out).write("\n");
                        ((PrintWriter)out).write("import sys");
                        ((PrintWriter)out).write("\n");
                        ((PrintWriter)out).write("from bpy.app.handlers import persistent");
                        ((PrintWriter)out).write("\n");
                        ((PrintWriter)out).write("@persistent");
                        ((PrintWriter)out).write("\n");
                        ((PrintWriter)out).write("def hide_stuff(hide_dummy):");
                        ((PrintWriter)out).write("\n");
                        ((PrintWriter)out).write("\tprint('PRE_LOAD_SCRIPT_hide_viewport')");
                        ((PrintWriter)out).write("\n");
                        ((PrintWriter)out).write("\t#Hide collections in the viewport");
                        ((PrintWriter)out).write("\n");
                        ((PrintWriter)out).write("\tfor col in bpy.data.collections:");
                        ((PrintWriter)out).write("\n");
                        ((PrintWriter)out).write("\t\tcol.hide_viewport = True");
                        ((PrintWriter)out).write("\n");
                        ((PrintWriter)out).write("\tfor obj in bpy.data.objects:");
                        ((PrintWriter)out).write("\n");
                        ((PrintWriter)out).write("\t\t#Hide objects in the viewport");
                        ((PrintWriter)out).write("\n");
                        ((PrintWriter)out).write("\t\tobj.hide_viewport = True");
                        ((PrintWriter)out).write("\n");
                        ((PrintWriter)out).write("\t\t#Hide modifier in the viewport");
                        ((PrintWriter)out).write("\n");
                        ((PrintWriter)out).write("\t\tfor mod in obj.modifiers:");
                        ((PrintWriter)out).write("\n");
                        ((PrintWriter)out).write("\t\t\tmod.show_viewport = False");
                        ((PrintWriter)out).write("\n");
                        ((PrintWriter)out).write("\tsys.stdout.flush()");
                        ((PrintWriter)out).write("\n");
                        ((PrintWriter)out).write("bpy.app.handlers.version_update.append(hide_stuff)");
                        ((PrintWriter)out).write("\n");
                        ((PrintWriter)out).close();
                        command.add(disableViewportScript.getAbsolutePath());
                    }
                    catch (IOException e) {
                        sw = new StringWriter();
                        e.printStackTrace(new PrintWriter(sw));
                        out = this.configuration.filesystemHealthCheck().iterator();
                        while (true) {
                            if (!out.hasNext()) {
                                this.log.error("Job::render exception on script generation, will return UNKNOWN " + e + " stacktrace " + sw.toString());
                                return Error.Type.UNKNOWN;
                            }
                            String logline = out.next();
                            this.log.debug(logline);
                        }
                    }
                    command.add(this.getScenePath());
                    command.add("-P");
                    try {
                        script_file = File.createTempFile("post_load_script_", ".py", this.configuration.getWorkingDirectory());
                        file2 = new File(script_file.getAbsolutePath());
                        FileWriter txt = new FileWriter(file2);
                        out = new PrintWriter(txt);
                        ((PrintWriter)out).write(this.getScript());
                        ((PrintWriter)out).write("\n");
                        ((PrintWriter)out).write("import sys");
                        ((PrintWriter)out).write("\n");
                        ((PrintWriter)out).write("print('POST_LOAD_SCRIPT_loaded')");
                        ((PrintWriter)out).write("\n");
                        ((PrintWriter)out).write("sys.stdout.flush()");
                        ((PrintWriter)out).write("\n");
                        ((PrintWriter)out).write((String)core_script);
                        ((PrintWriter)out).write("\n");
                        ((PrintWriter)out).close();
                        command.add(script_file.getAbsolutePath());
                    }
                    catch (IOException e) {
                        sw = new StringWriter();
                        e.printStackTrace(new PrintWriter(sw));
                        out = this.configuration.filesystemHealthCheck().iterator();
                        while (true) {
                            if (!out.hasNext()) {
                                this.log.error("Job::render exception on script generation, will return UNKNOWN " + e + " stacktrace " + sw.toString());
                                return Error.Type.UNKNOWN;
                            }
                            String logline = out.next();
                            this.log.debug(logline);
                        }
                    }
                    script_file.deleteOnExit();
                    continue block27;
                }
                case ".e": {
                    command.add(this.getRendererPath());
                    if (this.configuration.getNbCores() <= 0) continue block27;
                    command.add("-t");
                    command.add(Integer.toString(this.configuration.getNbCores()));
                    continue block27;
                }
                case ".o": {
                    command.add(this.configuration.getWorkingDirectory().getAbsolutePath() + File.separator + this.getPrefixOutputImage());
                    continue block27;
                }
                case ".f": {
                    command.add(this.getFrameNumber());
                    continue block27;
                }
                default: {
                    command.add(arg);
                }
            }
        }
        Timer memoryCheck = new Timer();
        try {
            renderStartedObservable event = new renderStartedObservable(renderStarted);
            this.log.debug(((Object)command).toString());
            os = OS.getOS();
            process.setCoresUsed(this.configuration.getNbCores());
            process.start();
            this.getProcessRender().setProcess(((OS)os).exec(command, new_env));
            this.getProcessRender().setOsProcess(OS.operatingSystem.getProcess((int)this.getProcessRender().getProcess().pid()));
            BufferedReader input = new BufferedReader(new InputStreamReader(this.getProcessRender().getProcess().getInputStream()));
            memoryCheck.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    Job.this.updateProcess();
                }
            }, 0L, 200L);
            if (this.configuration.getMaxRenderTime() > 0 && Integer.parseInt(this.getId()) >= 20) {
                timerOfMaxRenderTime = new Timer();
                timerOfMaxRenderTime.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        RenderProcess process = Job.this.getProcessRender();
                        if (process != null) {
                            long duration = (new Date().getTime() - process.getStartTime()) / 1000L;
                            if (Job.this.configuration.getMaxRenderTime() > 0 && duration > (long)Job.this.configuration.getMaxRenderTime()) {
                                Job.this.setAskForRendererKill(true);
                                Job.this.log.debug("Killing render - exceeding allowed process duration");
                                process.kill();
                            }
                        }
                    }
                }, this.configuration.getMaxRenderTime() * 1000 + 2000);
            }
            this.log.debug("renderer output");
            try {
                Duration phaseDuration;
                String line;
                int progress = -1;
                Pattern progressPattern = Pattern.compile(" (Rendered|Path Tracing Tile|Rendering|Sample) (\\d+)\\s?\\/\\s?(\\d+)( Tiles| samples|,)*");
                Pattern beginScenePrepPattern = Pattern.compile(POST_LOAD_NOTIFICATION);
                Pattern beginPostProcessingPattern = Pattern.compile("^Fra:\\d* \\w*(.)* \\| (Compositing|Denoising)");
                Pattern savingPattern = Pattern.compile("Time: \\d\\d:\\d\\d.\\d\\d \\(Saving: (\\d\\d:\\d\\d.\\d\\d)");
                int savingTimeSeconds = -1;
                Instant timeStamp = null;
                boolean scenePrepStarted = false;
                boolean renderingStarted = false;
                boolean postProcessingStarted = false;
                this.gui.updateTrayIcon(0);
                this.gui.status("Preparing project", 0);
                while ((line = input.readLine()) != null) {
                    Object savingTime;
                    Matcher savingTimeDetector;
                    Pattern blenderPattern;
                    Matcher blendDetectedVersion;
                    this.log.debug(line);
                    if (this.blenderLongVersion == null && (blendDetectedVersion = (blenderPattern = Pattern.compile("Blender (([0-9]{1,3}\\.[0-9]{0,3}).*)$")).matcher(line)).find()) {
                        this.blenderLongVersion = blendDetectedVersion.group(1);
                        this.blenderShortVersion = blendDetectedVersion.group(2);
                    }
                    Matcher scenePrepDetector = beginScenePrepPattern.matcher(line);
                    if (!scenePrepStarted && scenePrepDetector.find()) {
                        scenePrepStarted = true;
                        timeStamp = Instant.now();
                    }
                    progress = this.computeRenderingProgress(line, progressPattern, progress);
                    if (!renderingStarted && progress != -1) {
                        renderingStarted = true;
                        if (timeStamp == null) {
                            timeStamp = new Date(process.getStartTime()).toInstant();
                        }
                        phaseDuration = Duration.between(timeStamp, Instant.now());
                        timeStamp = Instant.now();
                        process.setScenePrepDuration((int)phaseDuration.toSeconds());
                    }
                    Matcher postProcessingDetector = beginPostProcessingPattern.matcher(line);
                    if (!postProcessingStarted && postProcessingDetector.find()) {
                        postProcessingStarted = true;
                        if (timeStamp == null) {
                            timeStamp = new Date(process.getStartTime()).toInstant();
                        }
                        phaseDuration = Duration.between(timeStamp, Instant.now());
                        timeStamp = Instant.now();
                        process.setRenderDuration((int)phaseDuration.toSeconds());
                    }
                    if ((savingTimeDetector = savingPattern.matcher(line)).find() && (savingTime = savingTimeDetector.group(1)) != null) {
                        savingTimeSeconds = (int)Duration.between(LocalTime.MIN, LocalTime.parse("00:" + savingTime)).toSeconds();
                    }
                    if (this.configuration.getMaxAllowedMemory() != -1L && this.getProcessRender().getMemoryUsed().get() > this.configuration.getMaxAllowedMemory()) {
                        this.log.debug("Blocking render because process ram used (" + this.getProcessRender().getMemoryUsed().get() + "k) is over user setting (" + this.configuration.getMaxAllowedMemory() + "k)");
                        process.finish();
                        if (process.getRenderDuration() == -1) {
                            if (timeStamp == null) {
                                timeStamp = new Date(process.getStartTime()).toInstant();
                            }
                            phaseDuration = Duration.between(timeStamp, Instant.now());
                            process.setRenderDuration((int)phaseDuration.toSeconds());
                        }
                        if (script_file != null) {
                            script_file.delete();
                        }
                        if (disableViewportScript != null) {
                            disableViewportScript.delete();
                        }
                        this.gui.updateTrayIcon(-1);
                        savingTime = Error.Type.RENDERER_OUT_OF_MEMORY;
                        return savingTime;
                    }
                    this.updateSpeedSamplesRendered(line, progress);
                    this.updateRenderingStatus(line, progress);
                    Error.Type error = this.detectError(line);
                    if (error != Error.Type.OK) {
                        if (script_file != null) {
                            script_file.delete();
                        }
                        if (disableViewportScript != null) {
                            disableViewportScript.delete();
                        }
                        if (process.getRenderDuration() == -1) {
                            if (timeStamp == null) {
                                timeStamp = new Date(process.getStartTime()).toInstant();
                            }
                            phaseDuration = Duration.between(timeStamp, Instant.now());
                            process.setRenderDuration((int)phaseDuration.toSeconds());
                        }
                        this.gui.updateTrayIcon(-1);
                        process.kill();
                        Object object = this.configuration.filesystemHealthCheck().iterator();
                        while (true) {
                            if (!object.hasNext()) {
                                object = error;
                                return object;
                            }
                            String logline = object.next();
                            this.log.debug(logline);
                        }
                    }
                    if (event.isStarted() || (this.getProcessRender().getMemoryUsed().get() <= 0L || !scenePrepStarted) && process.getRemainingDuration() <= 0) continue;
                    event.doNotifyIsStarted();
                }
                if (timeStamp == null) {
                    timeStamp = new Date(process.getStartTime()).toInstant();
                }
                if (!postProcessingStarted) {
                    phaseDuration = Duration.between(timeStamp, Instant.now());
                    process.setRenderDuration((int)phaseDuration.toSeconds());
                    if (savingTimeSeconds > 0 && process.getRenderDuration() > 0) {
                        process.setRenderDuration(Math.max(0, process.getRenderDuration() - savingTimeSeconds));
                    }
                } else {
                    phaseDuration = Duration.between(timeStamp, Instant.now());
                    process.setPostProcessingDuration((int)phaseDuration.toSeconds());
                }
                input.close();
                this.log.debug(String.format("render times: %n\tScene prep: %ds%n\tRendering: %ds%n\tPost: %ss%n\tTotal: %ds%n\tRendering/Total: %.03f%n", process.getScenePrepDuration(), process.getRenderDuration(), process.getPostProcessingDuration(), process.getDuration(), (double)Math.max(process.getRenderDuration(), 0) * 100.0 / (double)process.getDuration()));
            }
            catch (IOException err1) {
                this.log.error("Job::render exception(B) (silent error) " + err1);
            }
            finally {
                memoryCheck.cancel();
            }
            this.gui.updateTrayIcon(-1);
            this.log.debug("end of rendering");
        }
        catch (Exception err) {
            if (script_file != null) {
                script_file.delete();
            }
            if (disableViewportScript != null) {
                disableViewportScript.delete();
            }
            StringWriter sw = new StringWriter();
            err.printStackTrace(new PrintWriter(sw));
            os = this.configuration.filesystemHealthCheck().iterator();
            while (true) {
                if (!os.hasNext()) {
                    this.log.error("Job::render exception(A) " + err + " stacktrace " + sw.toString());
                    return Error.Type.FAILED_TO_EXECUTE;
                }
                String logline = (String)os.next();
                this.log.debug(logline);
            }
        }
        int exit_value = process.exitValue();
        process.finish();
        if (timerOfMaxRenderTime != null) {
            timerOfMaxRenderTime.cancel();
        }
        if (script_file != null) {
            script_file.delete();
        }
        if (disableViewportScript != null) {
            disableViewportScript.delete();
        }
        final String filename_without_extension = this.getPrefixOutputImage() + this.getFrameNumber();
        FilenameFilter textFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(filename_without_extension);
            }
        };
        Object[] files = this.configuration.getWorkingDirectory().listFiles(textFilter);
        if (this.isAskForRendererKill()) {
            this.log.debug("Job::render been asked to end render");
            long duration = (new Date().getTime() - process.getStartTime()) / 1000L;
            if (this.configuration.getMaxRenderTime() > 0 && duration > (long)this.configuration.getMaxRenderTime() && Integer.parseInt(this.getId()) >= 20) {
                this.log.debug("Render killed because process duration (" + duration + "s) is over user setting (" + this.configuration.getMaxRenderTime() + "s)");
                return Error.Type.RENDERER_KILLED_BY_USER_OVER_TIME;
            }
            if (files.length != 0) {
                Arrays.stream(files).forEach(file -> new File(file.getAbsolutePath()).delete());
            }
            if (this.isServerBlockJob()) {
                return Error.Type.RENDERER_KILLED_BY_SERVER;
            }
            if (!this.isUserBlockJob()) return Error.Type.RENDERER_KILLED;
            return Error.Type.RENDERER_KILLED_BY_USER;
        }
        if (files.length == 0) {
            String logline;
            Iterator<String> iterator2;
            for (String logline2 : this.configuration.filesystemHealthCheck()) {
                this.log.debug(logline2);
            }
            this.log.error("Job::render no picture file found (after finished render (filename_without_extension " + filename_without_extension + ")");
            String basename = "";
            try {
                basename = this.getPath().substring(0, this.getPath().lastIndexOf(46));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            File crash_file = new File(this.configuration.getWorkingDirectory() + File.separator + basename + ".crash.txt");
            if (crash_file.exists()) {
                iterator2 = this.configuration.filesystemHealthCheck().iterator();
                while (true) {
                    if (!iterator2.hasNext()) {
                        this.log.error("Job::render crash file found => the renderer crashed");
                        crash_file.delete();
                        return Error.Type.RENDERER_CRASHED;
                    }
                    logline = iterator2.next();
                    this.log.debug(logline);
                }
            }
            if (exit_value != 127) return Error.Type.NOOUTPUTFILE;
            if (process.getDuration() >= 10) return Error.Type.NOOUTPUTFILE;
            iterator2 = this.configuration.filesystemHealthCheck().iterator();
            while (true) {
                if (!iterator2.hasNext()) {
                    this.log.error("Job::render renderer returned 127 and took " + process.getDuration() + "s, some libraries may be missing");
                    return Error.Type.RENDERER_MISSING_LIBRARIES;
                }
                logline = iterator2.next();
                this.log.debug(logline);
            }
        }
        if (files.length == 2) {
            Arrays.sort(files);
            String path = ((File)files[1]).getAbsolutePath();
            String extension = path.substring(path.lastIndexOf(".") + 1).toLowerCase();
            if ("jpg".equals(extension)) {
                this.setPreviewImagePath(((File)files[1]).getAbsolutePath());
            }
        }
        this.setOutputImagePath(((File)files[0]).getAbsolutePath());
        this.outputImageSize = new File(this.getOutputImagePath()).length();
        this.log.debug(String.format("Job::render pictureFilename: %s, size: %d'", this.getOutputImagePath(), this.outputImageSize));
        File scene_dir = new File(this.getSceneDirectory());
        long date_modification_scene_directory = (long)Utils.lastModificationTime(scene_dir);
        if (date_modification_scene_directory > process.getStartTime()) {
            scene_dir.delete();
        }
        this.gui.status(String.format("Render time: %dmin%ds", process.getRenderDuration() / 60, process.getRenderDuration() % 60));
        return Error.Type.OK;
    }

    private int computeRenderingProgress(String line, Pattern tilePattern, int currentProgress) {
        Matcher standardTileInfo = tilePattern.matcher(line);
        int newProgress = currentProgress;
        if (standardTileInfo.find()) {
            int tileJustProcessed = Integer.parseInt(standardTileInfo.group(2));
            int totalTilesInJob = Integer.parseInt(standardTileInfo.group(3));
            newProgress = Math.abs(tileJustProcessed * 100 / totalTilesInJob);
        }
        if (newProgress != currentProgress) {
            this.gui.updateTrayIcon(newProgress);
            this.gui.status("Rendering", newProgress);
        }
        return newProgress;
    }

    private void updateSpeedSamplesRendered(String line, int progress) {
        Pattern pattern = Pattern.compile("^Rendered (\\d+) samples in ([\\d.]+) seconds$");
        Matcher matcher = pattern.matcher(line);
        if (matcher.find()) {
            int amount = Integer.parseInt(matcher.group(1));
            float duration = Float.parseFloat(matcher.group(2));
            if (duration != 0.0f && amount != 0) {
                this.speedSamplesRendered = (float)amount / duration;
            }
        }
    }

    private void updateRenderingStatus(String line, int progress) {
        if (this.getUpdateRenderingStatusMethod() == null || this.getUpdateRenderingStatusMethod().equals(UPDATE_METHOD_BY_REMAINING_TIME)) {
            String search_remaining = "remaining:";
            int index = line.toLowerCase().indexOf(search_remaining);
            if (index != -1) {
                String buf1 = line.substring(index + search_remaining.length());
                if ((index = buf1.indexOf(" ")) != -1) {
                    String remaining_time = buf1.substring(0, index).trim();
                    int last_index = remaining_time.lastIndexOf(46);
                    if (last_index > 0) {
                        remaining_time = remaining_time.substring(0, last_index);
                    }
                    try {
                        SimpleDateFormat date_parse_minute = new SimpleDateFormat("m:s");
                        SimpleDateFormat date_parse_hour = new SimpleDateFormat("h:m:s");
                        SimpleDateFormat date_parse = date_parse_minute;
                        if (remaining_time.split(":").length > 2) {
                            date_parse = date_parse_hour;
                        }
                        date_parse.setTimeZone(TimeZone.getTimeZone("GMT"));
                        Date date = date_parse.parse(remaining_time);
                        this.gui.setRemainingTime(Utils.humanDuration(date));
                        this.getProcessRender().setRemainingDuration((int)(date.getTime() / 1000L));
                    }
                    catch (ParseException err) {
                        this.log.error("Client::updateRenderingStatus ParseException " + err);
                    }
                }
            } else if (line.contains("Time")) {
                long timeRendered = new Date().getTime() - this.getProcessRender().getStartTime();
                if (progress > 0 && timeRendered > 0L) {
                    long linearTimeEstimation = (long)(100.0 / (double)progress * (double)timeRendered);
                    long timeRemaining = linearTimeEstimation - timeRendered;
                    Date date = new Date(timeRemaining);
                    this.gui.setRemainingTime(Utils.humanDuration(date));
                    this.getProcessRender().setRemainingDuration((int)(date.getTime() / 1000L));
                }
            }
        } else if (this.getUpdateRenderingStatusMethod().equals(UPDATE_METHOD_BY_TILE)) {
            String buf;
            String[] parts;
            String search = " Tile ";
            int index = line.lastIndexOf(search);
            if (index != -1 && (parts = (buf = line.substring(index + search.length())).split("/")).length == 2) {
                try {
                    int current = Integer.parseInt(parts[0]);
                    int total = Integer.parseInt(parts[1]);
                    if (total != 0) {
                        this.gui.status(String.format("Rendering %s %%", (int)(100.0 * (double)current / (double)total)));
                        return;
                    }
                }
                catch (NumberFormatException e) {
                    System.out.println("Exception 94: " + e);
                }
            }
            this.gui.status("Rendering");
        }
    }

    private void updateProcess() {
        this.getProcessRender().update();
    }

    private Error.Type detectError(String line) {
        if (line.contains("version `GLIBC_2.28' not found")) {
            return Error.Type.OS_NOT_SUPPORTED;
        }
        if (line.contains("Color management:")) {
            String[] errors;
            for (String error : errors = new String[]{" not found", " is not compatible ", " Error could not find role", "using fallback mode"}) {
                if (!line.contains(error)) continue;
                return Error.Type.COLOR_MANAGEMENT_ERROR;
            }
        } else {
            if (line.contains("OpenColorIO Error:")) {
                return Error.Type.COLOR_MANAGEMENT_ERROR;
            }
            if (line.contains("CUDA error: Out of memory")) {
                return Error.Type.RENDERER_OUT_OF_VIDEO_MEMORY;
            }
            if (line.contains("CUDA error at cuCtxCreate: Out of memory")) {
                return Error.Type.RENDERER_OUT_OF_VIDEO_MEMORY;
            }
            if (line.contains("Error: Out of memory in CUDA") || line.contains("Error: Out of memory in OPTIX")) {
                return Error.Type.RENDERER_OUT_OF_VIDEO_MEMORY;
            }
            if (line.contains("CUDA error: Launch exceeded timeout in") || line.contains("CUDA error: Invalid value in cuTexRefSetAddress(") || line.contains("CUDA error: Launch failed in cuCtxSynchronize()") || line.contains("CUDA error: Illegal address in cuCtxSynchronize()")) {
                return Error.Type.GPU_OR_DRIVER_ERROR;
            }
            if (line.contains("System is out of GPU memory")) {
                return Error.Type.RENDERER_OUT_OF_VIDEO_MEMORY;
            }
            if (line.contains("CUDA device supported only with compute capability") || line.contains("OPTIX device supported only with compute capability")) {
                return Error.Type.GPU_NOT_SUPPORTED;
            }
            if (line.contains("terminate called after throwing an instance of 'boost::filesystem::filesystem_error'")) {
                return Error.Type.NOOUTPUTFILE;
            }
            if (line.contains("terminate called after throwing an instance of 'std::bad_alloc'")) {
                return Error.Type.RENDERER_OUT_OF_MEMORY;
            }
            if (line.contains("what(): std::bad_alloc")) {
                return Error.Type.RENDERER_OUT_OF_MEMORY;
            }
            if (line.contains("EXCEPTION_ACCESS_VIOLATION")) {
                return Error.Type.RENDERER_CRASHED;
            }
            if (line.contains("Fatal Python error:")) {
                return Error.Type.RENDERER_CRASHED_PYTHON_ERROR;
            }
            if (line.contains("Calloc returns null")) {
                return Error.Type.RENDERER_OUT_OF_MEMORY;
            }
            if (line.contains("Malloc returns null")) {
                return Error.Type.RENDERER_OUT_OF_MEMORY;
            }
            if (line.contains("Error: run out of memory!")) {
                return Error.Type.RENDERER_OUT_OF_MEMORY;
            }
            if (line.contains("CUDA kernel compilation failed") || line.contains("OPTIX kernel compilation failed")) {
                return Error.Type.GPU_NOT_SUPPORTED;
            }
            if (line.contains("Engine 'CYCLES' not available for scene") || line.contains("Engine 'BLENDER_EEVEE' not available for scene") || line.contains("Engine 'BLENDER_WORKBENCH' not available for scene") || line.contains("Engine 'HYDRA_STORM' not available for scene")) {
                return Error.Type.ENGINE_NOT_AVAILABLE;
            }
            if (line.contains("Warning: Cycles is not enabled!")) {
                return Error.Type.ENGINE_NOT_AVAILABLE;
            }
            if (line.contains("OpenImageDenoise error: SSE4.1 support is required at minimum") || line.contains("OpenImageDenoiser is not supported on this CPU:") || line.contains("No device available to denoise on")) {
                return Error.Type.DENOISING_NOT_SUPPORTED;
            }
            if (line.contains("Error: File format is not supported")) {
                return Error.Type.RENDERER_CRASHED;
            }
            if (line.contains("Unable to open a display") || line.contains("Managed to successfully fallback to surfaceless EGL rendering!")) {
                return Error.Type.CURRENTLY_HEADLESS;
            }
            if (line.contains("Error: Cannot read file") || line.contains("Error: Failed to read blend file")) {
                return Error.Type.CANNOT_READ_FILE;
            }
            if (line.contains("DETECT_DEVICE_ERROR")) {
                return Error.Type.DETECT_DEVICE_ERROR;
            }
        }
        return Error.Type.OK;
    }

    public String getFrameNumber() {
        return this.frameNumber;
    }

    public List<Chunk> getArchiveChunks() {
        return this.archiveChunks;
    }

    public String getRendererMD5() {
        return this.rendererMD5;
    }

    public String getId() {
        return this.id;
    }

    public String getOutputImagePath() {
        return this.outputImagePath;
    }

    public String getPreviewImagePath() {
        return this.previewImagePath;
    }

    public long getOutputImageSize() {
        return this.outputImageSize;
    }

    public String getPath() {
        return this.path;
    }

    public String getRendererCommand() {
        return this.rendererCommand;
    }

    public String getValidationUrl() {
        return this.validationUrl;
    }

    public String getScript() {
        return this.script;
    }

    public boolean isUseGPU() {
        return this.useGPU;
    }

    public String getName() {
        return this.name;
    }

    public char[] getPassword() {
        return this.password;
    }

    public String getUpdateRenderingStatusMethod() {
        return this.updateRenderingStatusMethod;
    }

    public String getBlenderShortVersion() {
        return this.blenderShortVersion;
    }

    public String getBlenderLongVersion() {
        return this.blenderLongVersion;
    }

    public boolean isSynchronousUpload() {
        return this.synchronousUpload;
    }

    public float getSpeedSamplesRendered() {
        return this.speedSamplesRendered;
    }

    public RenderProcess getRender() {
        return this.render;
    }

    public boolean isAskForRendererKill() {
        return this.askForRendererKill;
    }

    public boolean isUserBlockJob() {
        return this.userBlockJob;
    }

    public boolean isServerBlockJob() {
        return this.serverBlockJob;
    }

    public Gui getGui() {
        return this.gui;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Log getLog() {
        return this.log;
    }

    public void setFrameNumber(String frameNumber) {
        this.frameNumber = frameNumber;
    }

    public void setArchiveChunks(List<Chunk> archiveChunks) {
        this.archiveChunks = archiveChunks;
    }

    public void setRendererMD5(String rendererMD5) {
        this.rendererMD5 = rendererMD5;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setOutputImagePath(String outputImagePath) {
        this.outputImagePath = outputImagePath;
    }

    public void setPreviewImagePath(String previewImagePath) {
        this.previewImagePath = previewImagePath;
    }

    public void setOutputImageSize(long outputImageSize) {
        this.outputImageSize = outputImageSize;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setRendererCommand(String rendererCommand) {
        this.rendererCommand = rendererCommand;
    }

    public void setValidationUrl(String validationUrl) {
        this.validationUrl = validationUrl;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public void setUseGPU(boolean useGPU) {
        this.useGPU = useGPU;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPassword(char[] password) {
        this.password = password;
    }

    public void setUpdateRenderingStatusMethod(String updateRenderingStatusMethod) {
        this.updateRenderingStatusMethod = updateRenderingStatusMethod;
    }

    public void setBlenderShortVersion(String blenderShortVersion) {
        this.blenderShortVersion = blenderShortVersion;
    }

    public void setBlenderLongVersion(String blenderLongVersion) {
        this.blenderLongVersion = blenderLongVersion;
    }

    public void setSynchronousUpload(boolean synchronousUpload) {
        this.synchronousUpload = synchronousUpload;
    }

    public void setSpeedSamplesRendered(float speedSamplesRendered) {
        this.speedSamplesRendered = speedSamplesRendered;
    }

    public void setRender(RenderProcess render) {
        this.render = render;
    }

    public void setAskForRendererKill(boolean askForRendererKill) {
        this.askForRendererKill = askForRendererKill;
    }

    public void setUserBlockJob(boolean userBlockJob) {
        this.userBlockJob = userBlockJob;
    }

    public void setServerBlockJob(boolean serverBlockJob) {
        this.serverBlockJob = serverBlockJob;
    }

    public void setGui(Gui gui) {
        this.gui = gui;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Job)) {
            return false;
        }
        Job other = (Job)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getOutputImageSize() != other.getOutputImageSize()) {
            return false;
        }
        if (this.isUseGPU() != other.isUseGPU()) {
            return false;
        }
        if (this.isSynchronousUpload() != other.isSynchronousUpload()) {
            return false;
        }
        if (Float.compare(this.getSpeedSamplesRendered(), other.getSpeedSamplesRendered()) != 0) {
            return false;
        }
        if (this.isAskForRendererKill() != other.isAskForRendererKill()) {
            return false;
        }
        if (this.isUserBlockJob() != other.isUserBlockJob()) {
            return false;
        }
        if (this.isServerBlockJob() != other.isServerBlockJob()) {
            return false;
        }
        String this$frameNumber = this.getFrameNumber();
        String other$frameNumber = other.getFrameNumber();
        if (this$frameNumber == null ? other$frameNumber != null : !this$frameNumber.equals(other$frameNumber)) {
            return false;
        }
        List<Chunk> this$archiveChunks = this.getArchiveChunks();
        List<Chunk> other$archiveChunks = other.getArchiveChunks();
        if (this$archiveChunks == null ? other$archiveChunks != null : !((Object)this$archiveChunks).equals(other$archiveChunks)) {
            return false;
        }
        String this$rendererMD5 = this.getRendererMD5();
        String other$rendererMD5 = other.getRendererMD5();
        if (this$rendererMD5 == null ? other$rendererMD5 != null : !this$rendererMD5.equals(other$rendererMD5)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$outputImagePath = this.getOutputImagePath();
        String other$outputImagePath = other.getOutputImagePath();
        if (this$outputImagePath == null ? other$outputImagePath != null : !this$outputImagePath.equals(other$outputImagePath)) {
            return false;
        }
        String this$previewImagePath = this.getPreviewImagePath();
        String other$previewImagePath = other.getPreviewImagePath();
        if (this$previewImagePath == null ? other$previewImagePath != null : !this$previewImagePath.equals(other$previewImagePath)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$rendererCommand = this.getRendererCommand();
        String other$rendererCommand = other.getRendererCommand();
        if (this$rendererCommand == null ? other$rendererCommand != null : !this$rendererCommand.equals(other$rendererCommand)) {
            return false;
        }
        String this$validationUrl = this.getValidationUrl();
        String other$validationUrl = other.getValidationUrl();
        if (this$validationUrl == null ? other$validationUrl != null : !this$validationUrl.equals(other$validationUrl)) {
            return false;
        }
        String this$script = this.getScript();
        String other$script = other.getScript();
        if (this$script == null ? other$script != null : !this$script.equals(other$script)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        if (!Arrays.equals(this.getPassword(), other.getPassword())) {
            return false;
        }
        String this$updateRenderingStatusMethod = this.getUpdateRenderingStatusMethod();
        String other$updateRenderingStatusMethod = other.getUpdateRenderingStatusMethod();
        if (this$updateRenderingStatusMethod == null ? other$updateRenderingStatusMethod != null : !this$updateRenderingStatusMethod.equals(other$updateRenderingStatusMethod)) {
            return false;
        }
        String this$blenderShortVersion = this.getBlenderShortVersion();
        String other$blenderShortVersion = other.getBlenderShortVersion();
        if (this$blenderShortVersion == null ? other$blenderShortVersion != null : !this$blenderShortVersion.equals(other$blenderShortVersion)) {
            return false;
        }
        String this$blenderLongVersion = this.getBlenderLongVersion();
        String other$blenderLongVersion = other.getBlenderLongVersion();
        if (this$blenderLongVersion == null ? other$blenderLongVersion != null : !this$blenderLongVersion.equals(other$blenderLongVersion)) {
            return false;
        }
        RenderProcess this$render = this.getRender();
        RenderProcess other$render = other.getRender();
        if (this$render == null ? other$render != null : !((Object)this$render).equals(other$render)) {
            return false;
        }
        Gui this$gui = this.getGui();
        Gui other$gui = other.getGui();
        if (this$gui == null ? other$gui != null : !this$gui.equals(other$gui)) {
            return false;
        }
        Configuration this$configuration = this.getConfiguration();
        Configuration other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration)) {
            return false;
        }
        Log this$log = this.getLog();
        Log other$log = other.getLog();
        return !(this$log == null ? other$log != null : !this$log.equals(other$log));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Job;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $outputImageSize = this.getOutputImageSize();
        result = result * 59 + (int)($outputImageSize >>> 32 ^ $outputImageSize);
        result = result * 59 + (this.isUseGPU() ? 79 : 97);
        result = result * 59 + (this.isSynchronousUpload() ? 79 : 97);
        result = result * 59 + Float.floatToIntBits(this.getSpeedSamplesRendered());
        result = result * 59 + (this.isAskForRendererKill() ? 79 : 97);
        result = result * 59 + (this.isUserBlockJob() ? 79 : 97);
        result = result * 59 + (this.isServerBlockJob() ? 79 : 97);
        String $frameNumber = this.getFrameNumber();
        result = result * 59 + ($frameNumber == null ? 43 : $frameNumber.hashCode());
        List<Chunk> $archiveChunks = this.getArchiveChunks();
        result = result * 59 + ($archiveChunks == null ? 43 : ((Object)$archiveChunks).hashCode());
        String $rendererMD5 = this.getRendererMD5();
        result = result * 59 + ($rendererMD5 == null ? 43 : $rendererMD5.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $outputImagePath = this.getOutputImagePath();
        result = result * 59 + ($outputImagePath == null ? 43 : $outputImagePath.hashCode());
        String $previewImagePath = this.getPreviewImagePath();
        result = result * 59 + ($previewImagePath == null ? 43 : $previewImagePath.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $rendererCommand = this.getRendererCommand();
        result = result * 59 + ($rendererCommand == null ? 43 : $rendererCommand.hashCode());
        String $validationUrl = this.getValidationUrl();
        result = result * 59 + ($validationUrl == null ? 43 : $validationUrl.hashCode());
        String $script = this.getScript();
        result = result * 59 + ($script == null ? 43 : $script.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        result = result * 59 + Arrays.hashCode(this.getPassword());
        String $updateRenderingStatusMethod = this.getUpdateRenderingStatusMethod();
        result = result * 59 + ($updateRenderingStatusMethod == null ? 43 : $updateRenderingStatusMethod.hashCode());
        String $blenderShortVersion = this.getBlenderShortVersion();
        result = result * 59 + ($blenderShortVersion == null ? 43 : $blenderShortVersion.hashCode());
        String $blenderLongVersion = this.getBlenderLongVersion();
        result = result * 59 + ($blenderLongVersion == null ? 43 : $blenderLongVersion.hashCode());
        RenderProcess $render = this.getRender();
        result = result * 59 + ($render == null ? 43 : ((Object)$render).hashCode());
        Gui $gui = this.getGui();
        result = result * 59 + ($gui == null ? 43 : $gui.hashCode());
        Configuration $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
        Log $log = this.getLog();
        result = result * 59 + ($log == null ? 43 : $log.hashCode());
        return result;
    }

    public static class renderStartedObservable
    extends Observable {
        private boolean isStarted;

        public renderStartedObservable(Observer observer) {
            this.addObserver(observer);
        }

        public void doNotifyIsStarted() {
            this.setChanged();
            this.notifyObservers();
            this.isStarted = true;
        }

        public boolean isStarted() {
            return this.isStarted;
        }
    }
}

