/*
 * Decompiled with CFR 0.152.
 */
package com.sheepit.client;

import com.sheepit.client.Configuration;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class Log {
    private static Log instance = null;
    private Map<Integer, ArrayList<String>> checkpoints = new HashMap<Integer, ArrayList<String>>();
    private int lastCheckPoint;
    private DateFormat dateFormat;
    private boolean printStdOut;

    private Log(boolean print_) {
        this.printStdOut = print_;
        this.lastCheckPoint = 0;
        this.checkpoints.put(this.lastCheckPoint, new ArrayList());
        this.dateFormat = new SimpleDateFormat("dd-MM HH:mm:ss");
    }

    public void debug(String msg_) {
        this.debug(-1, msg_);
    }

    public void debug(int point_, String msg_) {
        this.append(point_, "debug", msg_);
    }

    public void info(String msg_) {
        this.info(-1, msg_);
    }

    public void info(int point_, String msg_) {
        this.append(point_, "info", msg_);
    }

    public void error(String msg_) {
        this.error(-1, msg_);
    }

    public void error(int point_, String msg_) {
        this.append(point_, "error", msg_);
    }

    private synchronized void append(int point_, String level_, String msg_) {
        String line = null;
        try {
            int checkpointToWrite;
            int n = checkpointToWrite = point_ > 0 ? point_ : this.lastCheckPoint;
            if (!msg_.equals("")) {
                line = this.dateFormat.format(new Date()) + " (" + level_ + ") " + msg_;
                if (this.checkpoints.containsKey(checkpointToWrite) && this.checkpoints.get(checkpointToWrite) != null) {
                    this.checkpoints.get(checkpointToWrite).add(line);
                }
                if (this.printStdOut) {
                    System.out.println(line);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int newCheckPoint() {
        int time = (int)new Date().getTime();
        this.checkpoints.put(time, new ArrayList());
        this.lastCheckPoint = time;
        return this.lastCheckPoint;
    }

    public Optional<ArrayList<String>> getForCheckPoint(int point_) {
        return Optional.ofNullable(this.checkpoints.get(point_));
    }

    public void removeCheckPoint(int point_) {
        try {
            this.checkpoints.remove(point_);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public static synchronized Log getInstance(Configuration config) {
        if (instance == null) {
            boolean print = false;
            if (config != null) {
                print = config.isPrintLog();
            }
            instance = new Log(print);
        }
        return instance;
    }

    public static synchronized void printCheckPoint(int point_) {
        Log log = Log.getInstance(null);
        Optional<ArrayList<String>> logs = log.getForCheckPoint(point_);
        if (logs.isPresent()) {
            for (String alog : logs.get()) {
                System.out.println(alog);
            }
        }
    }
}

