/*
 * Decompiled with CFR 0.152.
 */
package com.sheepit.client;

import com.sheepit.client.Utils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;

public class Md5 {
    private static Map<String, String> cache = new HashMap<String, String>();

    public String get(String path) {
        String key = this.getUniqueKey(path);
        if (!cache.containsKey(key)) {
            this.generate(path);
        }
        return cache.get(key);
    }

    private void generate(String path) {
        String key = this.getUniqueKey(path);
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            InputStream is = Files.newInputStream(Paths.get(path, new String[0]), new OpenOption[0]);
            DigestInputStream dis = new DigestInputStream(is, md);
            byte[] buffer = new byte[8192];
            while (dis.read(buffer) > 0) {
            }
            String data = Utils.convertBinaryToHex(md.digest());
            dis.close();
            is.close();
            cache.put(key, data);
        }
        catch (IOException | NoSuchAlgorithmException e) {
            cache.put(key, "");
        }
    }

    private String getUniqueKey(String path) {
        File file = new File(path);
        return Long.toString(file.lastModified()) + "_" + path;
    }
}

