/*
 * Decompiled with CFR 0.152.
 */
package com.sheepit.client;

import com.sheepit.client.Log;
import com.sheepit.client.os.OS;
import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;
import oshi.software.os.OSProcess;

public class RenderProcess {
    private long startTime = -1L;
    private long endTime = -1L;
    private int scenePrepDuration = -1;
    private int renderDuration = -1;
    private int postProcessingDuration = -1;
    private int remainingDuration = 0;
    private AtomicLong memoryUsed = new AtomicLong(0L);
    private long peakMemoryUsed = 0L;
    private int coresUsed = 0;
    private Process process = null;
    private OSProcess osProcess = null;
    private Log log;

    public RenderProcess(Log _log) {
        this.log = _log;
    }

    public void update() {
        OSProcess osp = this.osProcess;
        try {
            long mem;
            if (osp != null && osp.updateAttributes() && (mem = osp.getResidentSetSize() / 1024L) != 0L) {
                this.memoryUsed.set(mem);
                if (this.peakMemoryUsed < mem) {
                    this.peakMemoryUsed = mem;
                }
            }
        }
        catch (NullPointerException ex) {
            this.log.debug("RenderProcess::Handled process becoming unavailable mid-update");
            this.osProcess = null;
            this.memoryUsed.set(0L);
        }
    }

    public int getDuration() {
        if (this.startTime != -1L && this.endTime != -1L) {
            return (int)((this.endTime - this.startTime) / 1000L);
        }
        if (this.startTime != -1L) {
            return (int)((new Date().getTime() - this.startTime) / 1000L);
        }
        return 0;
    }

    public void kill() {
        if (this.process != null) {
            try {
                OS.getOS().kill(this.process);
                this.log.debug("RenderProcess::Process killed");
            }
            catch (NullPointerException ex) {
                this.log.debug("RenderProcess::Handled process becoming unavailable before getting killed");
            }
        }
    }

    public void finish() {
        this.kill();
        this.endTime = new Date().getTime();
        this.osProcess = null;
        this.process = null;
    }

    public void start() {
        this.startTime = new Date().getTime();
    }

    public int exitValue() {
        int value = 0;
        if (this.process == null) {
            return -1;
        }
        try {
            value = this.process.exitValue();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public int getScenePrepDuration() {
        return this.scenePrepDuration;
    }

    public int getRenderDuration() {
        return this.renderDuration;
    }

    public int getPostProcessingDuration() {
        return this.postProcessingDuration;
    }

    public int getRemainingDuration() {
        return this.remainingDuration;
    }

    public AtomicLong getMemoryUsed() {
        return this.memoryUsed;
    }

    public long getPeakMemoryUsed() {
        return this.peakMemoryUsed;
    }

    public int getCoresUsed() {
        return this.coresUsed;
    }

    public Process getProcess() {
        return this.process;
    }

    public OSProcess getOsProcess() {
        return this.osProcess;
    }

    public Log getLog() {
        return this.log;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public void setRemainingDuration(int remainingDuration) {
        this.remainingDuration = remainingDuration;
    }

    public void setMemoryUsed(AtomicLong memoryUsed) {
        this.memoryUsed = memoryUsed;
    }

    public void setPeakMemoryUsed(long peakMemoryUsed) {
        this.peakMemoryUsed = peakMemoryUsed;
    }

    public void setCoresUsed(int coresUsed) {
        this.coresUsed = coresUsed;
    }

    public void setProcess(Process process) {
        this.process = process;
    }

    public void setOsProcess(OSProcess osProcess) {
        this.osProcess = osProcess;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RenderProcess)) {
            return false;
        }
        RenderProcess other = (RenderProcess)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStartTime() != other.getStartTime()) {
            return false;
        }
        if (this.getEndTime() != other.getEndTime()) {
            return false;
        }
        if (this.getScenePrepDuration() != other.getScenePrepDuration()) {
            return false;
        }
        if (this.getRenderDuration() != other.getRenderDuration()) {
            return false;
        }
        if (this.getPostProcessingDuration() != other.getPostProcessingDuration()) {
            return false;
        }
        if (this.getRemainingDuration() != other.getRemainingDuration()) {
            return false;
        }
        if (this.getPeakMemoryUsed() != other.getPeakMemoryUsed()) {
            return false;
        }
        if (this.getCoresUsed() != other.getCoresUsed()) {
            return false;
        }
        AtomicLong this$memoryUsed = this.getMemoryUsed();
        AtomicLong other$memoryUsed = other.getMemoryUsed();
        if (this$memoryUsed == null ? other$memoryUsed != null : !this$memoryUsed.equals(other$memoryUsed)) {
            return false;
        }
        Process this$process = this.getProcess();
        Process other$process = other.getProcess();
        if (this$process == null ? other$process != null : !this$process.equals(other$process)) {
            return false;
        }
        OSProcess this$osProcess = this.getOsProcess();
        OSProcess other$osProcess = other.getOsProcess();
        if (this$osProcess == null ? other$osProcess != null : !this$osProcess.equals(other$osProcess)) {
            return false;
        }
        Log this$log = this.getLog();
        Log other$log = other.getLog();
        return !(this$log == null ? other$log != null : !this$log.equals(other$log));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RenderProcess;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $startTime = this.getStartTime();
        result = result * 59 + (int)($startTime >>> 32 ^ $startTime);
        long $endTime = this.getEndTime();
        result = result * 59 + (int)($endTime >>> 32 ^ $endTime);
        result = result * 59 + this.getScenePrepDuration();
        result = result * 59 + this.getRenderDuration();
        result = result * 59 + this.getPostProcessingDuration();
        result = result * 59 + this.getRemainingDuration();
        long $peakMemoryUsed = this.getPeakMemoryUsed();
        result = result * 59 + (int)($peakMemoryUsed >>> 32 ^ $peakMemoryUsed);
        result = result * 59 + this.getCoresUsed();
        AtomicLong $memoryUsed = this.getMemoryUsed();
        result = result * 59 + ($memoryUsed == null ? 43 : $memoryUsed.hashCode());
        Process $process = this.getProcess();
        result = result * 59 + ($process == null ? 43 : $process.hashCode());
        OSProcess $osProcess = this.getOsProcess();
        result = result * 59 + ($osProcess == null ? 43 : $osProcess.hashCode());
        Log $log = this.getLog();
        result = result * 59 + ($log == null ? 43 : $log.hashCode());
        return result;
    }

    public String toString() {
        return "RenderProcess(startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", scenePrepDuration=" + this.getScenePrepDuration() + ", renderDuration=" + this.getRenderDuration() + ", postProcessingDuration=" + this.getPostProcessingDuration() + ", remainingDuration=" + this.getRemainingDuration() + ", memoryUsed=" + this.getMemoryUsed() + ", peakMemoryUsed=" + this.getPeakMemoryUsed() + ", coresUsed=" + this.getCoresUsed() + ", process=" + this.getProcess() + ", osProcess=" + this.getOsProcess() + ", log=" + this.getLog() + ")";
    }

    public void setScenePrepDuration(int scenePrepDuration) {
        this.scenePrepDuration = scenePrepDuration;
    }

    public void setRenderDuration(int renderDuration) {
        this.renderDuration = renderDuration;
    }

    public void setPostProcessingDuration(int postProcessingDuration) {
        this.postProcessingDuration = postProcessingDuration;
    }
}

