/*
 * Decompiled with CFR 0.152.
 */
package com.sheepit.client;

import com.sheepit.client.Client;
import com.sheepit.client.Configuration;
import com.sheepit.client.Error;
import com.sheepit.client.Gui;
import com.sheepit.client.Job;
import com.sheepit.client.Log;
import com.sheepit.client.RenderProcess;
import com.sheepit.client.Speedtest;
import com.sheepit.client.Stats;
import com.sheepit.client.TransferStats;
import com.sheepit.client.Utils;
import com.sheepit.client.datamodel.CacheFileMD5;
import com.sheepit.client.datamodel.FileMD5;
import com.sheepit.client.datamodel.HeartBeatInfos;
import com.sheepit.client.datamodel.JobInfos;
import com.sheepit.client.datamodel.JobValidation;
import com.sheepit.client.datamodel.RequestEndPoint;
import com.sheepit.client.datamodel.ServerConfig;
import com.sheepit.client.datamodel.SpeedTestResult;
import com.sheepit.client.datamodel.SpeedTestTarget;
import com.sheepit.client.datamodel.SpeedTestTargetResult;
import com.sheepit.client.exception.SheepItException;
import com.sheepit.client.exception.SheepItExceptionBadResponseFromServer;
import com.sheepit.client.exception.SheepItExceptionNoRendererAvailable;
import com.sheepit.client.exception.SheepItExceptionNoRightToRender;
import com.sheepit.client.exception.SheepItExceptionNoSession;
import com.sheepit.client.exception.SheepItExceptionServerInMaintenance;
import com.sheepit.client.exception.SheepItExceptionServerOverloaded;
import com.sheepit.client.exception.SheepItExceptionSessionDisabled;
import com.sheepit.client.exception.SheepItExceptionSessionDisabledDenoisingNotSupported;
import com.sheepit.client.exception.SheepItServerDown;
import com.sheepit.client.hardware.cpu.CPU;
import com.sheepit.client.hardware.hwid.HWIdentifier;
import com.sheepit.client.os.OS;
import com.sheepit.client.os.Windows;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.CallSite;
import java.net.ConnectException;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.NoRouteToHostException;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import okhttp3.Call;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.JavaNetCookieJar;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.simpleframework.xml.core.Persister;

public class Server
extends Thread {
    private static final int NUMBER_OF_SPEEDTEST_RESULTS = 3;
    private final String HTTP_USER_AGENT = "Java/" + System.getProperty("java.version");
    private String base_url;
    private final OkHttpClient httpClient;
    private ServerConfig serverConfig;
    private Configuration user_config;
    private Client client;
    private Log log;
    private long lastRequestTime;
    private int keepmealive_duration;
    private TransferStats dlStats = new TransferStats();
    private TransferStats ulStats = new TransferStats();

    public Server(String url_, Configuration user_config_, Client client_) {
        this.base_url = url_;
        this.user_config = user_config_;
        this.client = client_;
        this.log = Log.getInstance(this.user_config);
        this.lastRequestTime = 0L;
        this.keepmealive_duration = 900000;
        this.httpClient = this.getOkHttpClient();
    }

    @Override
    public void run() {
        this.stayAlive();
    }

    public void stayAlive() {
        while (true) {
            PrintWriter pw;
            StringWriter sw;
            block15: {
                long current_time;
                if ((current_time = new Date().getTime()) - this.lastRequestTime > (long)this.keepmealive_duration) {
                    try {
                        Response response;
                        HttpUrl.Builder urlBuilder = Objects.requireNonNull(HttpUrl.parse(this.getPage("keepmealive"))).newBuilder();
                        urlBuilder.addQueryParameter("paused", String.valueOf(this.client.isSuspended()));
                        if (this.client != null && this.client.getRenderingJob() != null) {
                            Job job = this.client.getRenderingJob();
                            urlBuilder.addQueryParameter("frame", job.getFrameNumber()).addQueryParameter("job", job.getId());
                            RenderProcess process = job.getProcessRender();
                            if (process != null) {
                                urlBuilder.addQueryParameter("rendertime", String.valueOf(process.getDuration())).addQueryParameter("remainingtime", String.valueOf(process.getRemainingDuration()));
                            }
                        }
                        if ((response = this.HTTPRequest(urlBuilder)).code() != 200 || !response.body().contentType().toString().startsWith("text/xml")) break block15;
                        String in = response.body().string();
                        try {
                            HeartBeatInfos heartBeatInfos = (HeartBeatInfos)((Object)new Persister().read(HeartBeatInfos.class, in));
                            Error.ServerCode serverCode = Error.ServerCode.fromInt(heartBeatInfos.getStatus());
                            if (serverCode == Error.ServerCode.KEEPMEALIVE_STOP_RENDERING) {
                                this.log.debug("Server::stayAlive server asked to kill local render process");
                                if (this.client != null && this.client.getRenderingJob() != null) {
                                    this.client.getRenderingJob().setServerBlockJob(true);
                                    if (this.client.getRenderingJob().getProcessRender().getProcess() != null) {
                                        this.client.getRenderingJob().setAskForRendererKill(true);
                                        this.client.getRenderingJob().getProcessRender().kill();
                                    }
                                }
                            }
                        }
                        catch (Exception e) {
                            this.log.debug("Server::stayAlive Exception " + e);
                        }
                    }
                    catch (NoRouteToHostException e) {
                        this.log.debug("Server::stayAlive can not connect to server");
                    }
                    catch (IOException e) {
                        sw = new StringWriter();
                        pw = new PrintWriter(sw);
                        e.printStackTrace(pw);
                        this.log.debug("Server::stayAlive IOException " + e + " stacktrace: " + sw.toString());
                    }
                }
            }
            try {
                Thread.sleep(60000L);
                continue;
            }
            catch (InterruptedException e) {
                return;
            }
            catch (Exception e) {
                sw = new StringWriter();
                pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                this.log.debug("Server::stayAlive Exception " + e + " stacktrace: " + sw.toString());
                continue;
            }
            break;
        }
    }

    @Override
    public String toString() {
        return String.format("Server (base_url '%s', user_config %s", this.base_url, this.user_config);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Error.Type getConfiguration() {
        OS os = OS.getOS();
        String publickey = null;
        try {
            HttpUrl.Builder remoteURL = Objects.requireNonNull(HttpUrl.parse(this.base_url + "/server/config.php")).newBuilder();
            FormBody formBody = new FormBody.Builder().add("login", this.user_config.getLogin()).add("password", this.user_config.getPassword()).add("cpu_family", os.getCPU().getFamily()).add("cpu_model", os.getCPU().getModel()).add("cpu_model_name", os.getCPU().getName()).add("cpu_cores", String.valueOf(this.user_config.getNbCores() == -1 ? os.getCPU().cores() : Math.max(CPU.MIN_CORES, this.user_config.getNbCores()))).add("os", os.name()).add("os_version", os.getVersion()).add("ram", String.valueOf(os.getTotalMemory())).add("bits", os.getCPU().getArch()).add("version", Configuration.jarVersion).add("hostname", this.user_config.getHostname()).add("ui", this.client.getGui().getClass().getSimpleName()).add("extras", this.user_config.getExtras()).add("headless", GraphicsEnvironment.isHeadless() ? "1" : (this.user_config.isHeadless() ? "1" : "0")).add("hwid", new HWIdentifier(this.log).getHardwareHash()).build();
            this.log.debug("Server::getConfiguration url " + remoteURL.build().toString());
            Response response = this.HTTPRequest(remoteURL, formBody, false);
            int r = response.code();
            String contentType = response.body().contentType().toString();
            if (r != 200) return Error.Type.ERROR_BAD_SERVER_RESPONSE;
            if (!contentType.startsWith("text/xml")) {
                return Error.Type.ERROR_BAD_SERVER_RESPONSE;
            }
            if (r == 404) {
                return Error.Type.SERVER_DOWN;
            }
            String in = response.body().string();
            this.serverConfig = (ServerConfig)((Object)new Persister().read(ServerConfig.class, in));
            if (Error.ServerCode.fromInt(this.serverConfig.getStatus()) != Error.ServerCode.OK) {
                return Error.ServerCodeToType(Error.ServerCode.fromInt(this.serverConfig.getStatus()));
            }
            publickey = this.serverConfig.getPublickey();
            if (publickey.isEmpty()) {
                publickey = null;
            } else {
                this.user_config.setPassword(publickey);
            }
        }
        catch (ConnectException e) {
            this.log.error("Server::getConfiguration error ConnectException " + e);
            return Error.Type.NETWORK_ISSUE;
        }
        catch (UnknownHostException e) {
            this.log.error("Server::getConfiguration: exception UnknownHostException " + e);
            return Error.Type.NETWORK_ISSUE;
        }
        catch (UnsupportedEncodingException e) {
            this.log.error("Server::getConfiguration: exception UnsupportedEncodingException " + e);
            return Error.Type.UNKNOWN;
        }
        catch (IOException e) {
            this.log.error("Server::getConfiguration: exception IOException " + e);
            return Error.Type.UNKNOWN;
        }
        catch (Exception e) {
            this.log.error("Server::getConfiguration: exception Exception " + e);
            return Error.Type.UNKNOWN;
        }
        if (this.serverConfig.getSpeedTestTargets() != null && !this.serverConfig.getSpeedTestTargets().isEmpty()) {
            try {
                this.client.getGui().status("Checking mirror connection speeds");
                Speedtest speedtest = new Speedtest(this.log);
                List<SpeedTestTarget> bestSpeedTestTargets = speedtest.doSpeedtests(this.serverConfig.getSpeedTestTargets().stream().map(m -> m.getUrl()).collect(Collectors.toList()), 3);
                SpeedTestResult result = new SpeedTestResult();
                result.setResults(bestSpeedTestTargets.stream().map(m -> {
                    SpeedTestTargetResult targetResult = new SpeedTestTargetResult();
                    targetResult.setTarget(m.getUrl());
                    targetResult.setSpeed(m.getSpeedtest());
                    targetResult.setPing((int)m.getPing().getAverage());
                    return targetResult;
                }).collect(Collectors.toList()));
                Persister persister = new Persister();
                try (StringWriter writer = new StringWriter();){
                    persister.write((Object)result, writer);
                    HttpUrl.Builder urlBuilder = Objects.requireNonNull(HttpUrl.parse(this.getPage("speedtest-answer"))).newBuilder();
                    Response response = this.HTTPRequest(urlBuilder, RequestBody.create(MediaType.parse("application/xml"), writer.toString()));
                    if (response.code() != 200) {
                        this.log.error("Server::getConfiguration Speedtest unexpected response");
                        Error.Type type = Error.Type.ERROR_BAD_SERVER_RESPONSE;
                        return type;
                    }
                }
                catch (Exception e) {
                    throw new IOException("Server::getConfiguration Speedtest failed to generate payload");
                }
            }
            catch (IOException e) {
                this.log.error("Server::getConfiguration Speedtest failed: " + e);
                return Error.Type.NETWORK_ISSUE;
            }
        }
        this.client.setSessionStarted(true);
        this.client.getGui().successfulAuthenticationEvent(publickey);
        return Error.Type.OK;
    }

    public Job requestJob() throws SheepItException {
        this.log.debug("Server::requestJob");
        String url_contents = "";
        try {
            Error.ServerCode serverCode;
            Response response;
            int r;
            OS os = OS.getOS();
            long maxMemory = this.user_config.getMaxAllowedMemory();
            long freeMemory = os.getFreeMemory() - 1024L ^ (long)(2 * (os instanceof Windows ? 2 : 1));
            if (maxMemory < 0L) {
                maxMemory = freeMemory;
            } else if (freeMemory > 0L && maxMemory > 0L) {
                maxMemory = Math.min(maxMemory, freeMemory);
            }
            HttpUrl.Builder urlBuilder = Objects.requireNonNull(HttpUrl.parse(this.getPage("request-job"))).newBuilder().addQueryParameter("computemethod", String.valueOf(this.user_config.computeMethodToInt())).addQueryParameter("network_dl", String.valueOf(this.dlStats.getRawAverageSessionSpeed())).addQueryParameter("network_up", String.valueOf(this.ulStats.getRawAverageSessionSpeed())).addQueryParameter("cpu_cores", String.valueOf(this.user_config.getNbCores() == -1 ? os.getCPU().cores() : Math.max(this.user_config.getNbCores(), CPU.MIN_CORES))).addQueryParameter("ram_max", String.valueOf(maxMemory)).addQueryParameter("rendertime_max", String.valueOf(this.user_config.getMaxRenderTime()));
            if (this.user_config.getComputeMethod() != Configuration.ComputeType.CPU && this.user_config.getGPUDevice() != null) {
                urlBuilder.addQueryParameter("gpu_model", this.user_config.getGPUDevice().getModel()).addQueryParameter("gpu_ram", String.valueOf(this.user_config.getGPUDevice().getMemory())).addQueryParameter("gpu_type", this.user_config.getGPUDevice().getType());
            }
            if ((r = (response = this.HTTPRequest(urlBuilder, RequestBody.create(this.generateXMLForMD5cache(), MediaType.parse("application/xml")))).code()) == 503 || r == 408) {
                this.log.error("Server::requestJob server unavailable or down: " + response);
                throw new SheepItServerDown();
            }
            if (!response.body().contentType().toString().startsWith("text/xml")) {
                this.log.error("Server::requestJob bad contentType received: " + response);
                throw new SheepItExceptionBadResponseFromServer();
            }
            if (r != 200) {
                this.log.error("Server::requestJob unexpected response" + response);
                throw new SheepItException();
            }
            String in = response.body().string();
            JobInfos jobData = (JobInfos)((Object)new Persister().read(JobInfos.class, in));
            this.handleFileMD5DeleteDocument(jobData.getFileMD5s());
            if (jobData.getSessionStats() != null) {
                this.client.getGui().displayStats(new Stats(jobData.getSessionStats().getRemainingFrames(), jobData.getSessionStats().getPointsEarnedByUser(), jobData.getSessionStats().getPointsEarnedOnSession(), jobData.getSessionStats().getRenderableProjects(), jobData.getSessionStats().getWaitingProjects(), jobData.getSessionStats().getConnectedMachines()));
            }
            if ((serverCode = Error.ServerCode.fromInt(jobData.getStatus())) != Error.ServerCode.OK) {
                switch (serverCode) {
                    case JOB_REQUEST_NOJOB: {
                        return null;
                    }
                    case JOB_REQUEST_ERROR_NO_RENDERING_RIGHT: {
                        throw new SheepItExceptionNoRightToRender();
                    }
                    case JOB_REQUEST_ERROR_DEAD_SESSION: {
                        throw new SheepItExceptionNoSession();
                    }
                    case JOB_REQUEST_ERROR_SESSION_DISABLED: {
                        throw new SheepItExceptionSessionDisabled();
                    }
                    case JOB_REQUEST_ERROR_SESSION_DISABLED_DENOISING_NOT_SUPPORTED: {
                        throw new SheepItExceptionSessionDisabledDenoisingNotSupported();
                    }
                    case JOB_REQUEST_ERROR_INTERNAL_ERROR: {
                        throw new SheepItExceptionBadResponseFromServer();
                    }
                    case JOB_REQUEST_ERROR_RENDERER_NOT_AVAILABLE: {
                        throw new SheepItExceptionNoRendererAvailable();
                    }
                    case JOB_REQUEST_SERVER_IN_MAINTENANCE: {
                        throw new SheepItExceptionServerInMaintenance();
                    }
                    case JOB_REQUEST_SERVER_OVERLOADED: {
                        throw new SheepItExceptionServerOverloaded();
                    }
                }
                throw new SheepItException("error requestJob: status is not ok (it's " + serverCode + ")");
            }
            String validationUrl = URLDecoder.decode(jobData.getRenderTask().getValidationUrl(), "UTF-8");
            return new Job(this.user_config, this.client.getGui(), this.client.getLog(), jobData.getRenderTask().getId(), jobData.getRenderTask().getFrame(), jobData.getRenderTask().getPath().replace("/", File.separator), jobData.getRenderTask().getUseGpu() == 1, jobData.getRenderTask().getRendererInfos().getCommandline(), validationUrl, jobData.getRenderTask().getScript(), jobData.getRenderTask().getChunks(), jobData.getRenderTask().getRendererInfos().getMd5(), jobData.getRenderTask().getName(), jobData.getRenderTask().getPassword(), jobData.getRenderTask().getSynchronous_upload().equals("1"), jobData.getRenderTask().getRendererInfos().getUpdate_method());
        }
        catch (SheepItException e) {
            throw e;
        }
        catch (NoRouteToHostException e) {
            throw new SheepItServerDown();
        }
        catch (UnknownHostException e) {
            throw new SheepItServerDown();
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            throw new SheepItException("error requestJob: unknown exception " + e + " stacktrace: " + sw.toString());
        }
    }

    public Response HTTPRequest(String url) throws IOException {
        HttpUrl.Builder httpUrlBuilder = Objects.requireNonNull(HttpUrl.parse(url)).newBuilder();
        return this.HTTPRequest(httpUrlBuilder, null);
    }

    public Response HTTPRequest(HttpUrl.Builder httpUrlBuilder) throws IOException {
        return this.HTTPRequest(httpUrlBuilder, null);
    }

    public Response HTTPRequest(HttpUrl.Builder httpUrlBuilder, RequestBody data_) throws IOException {
        String url = httpUrlBuilder.build().toString();
        Request.Builder builder = new Request.Builder().addHeader("User-Agent", this.HTTP_USER_AGENT).url(url);
        this.log.debug("Server::HTTPRequest url(" + url + ")");
        if (data_ != null) {
            builder.post(data_);
        }
        Request request = builder.build();
        Response response = null;
        try {
            response = this.httpClient.newCall(request).execute();
            if (!response.isSuccessful()) {
                this.log.error("Received unsuccessful HTTP response " + response);
            }
            this.lastRequestTime = new Date().getTime();
            return response;
        }
        catch (IOException e) {
            throw new IOException("Unexpected response from HTTP Stack" + e.getMessage());
        }
    }

    public Response HTTPRequest(HttpUrl.Builder httpUrlBuilder, RequestBody data_, boolean checkIsSuccessful) throws IOException {
        String url = httpUrlBuilder.build().toString();
        Request.Builder builder = new Request.Builder().addHeader("User-Agent", this.HTTP_USER_AGENT).url(url);
        this.log.debug("Server::HTTPRequest url(" + url + ")");
        if (data_ != null) {
            builder.post(data_);
        }
        Request request = builder.build();
        Response response = null;
        try {
            response = this.httpClient.newCall(request).execute();
            if (checkIsSuccessful && !response.isSuccessful()) {
                throw new IOException("Unexpected code " + response);
            }
            this.lastRequestTime = new Date().getTime();
            return response;
        }
        catch (ConnectException e) {
            throw new ConnectException("Unexpected response from HTTP Stack" + e.getMessage());
        }
        catch (IOException e) {
            throw new IOException("Unexpected response from HTTP Stack" + e.getMessage());
        }
    }

    /*
     * Exception decompiling
     */
    public Error.Type HTTPGetFile(String url_, String destination_, Gui gui_, String status_) throws SheepItException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 19[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Error.ServerCode HTTPSendFile(String surl, String file1, int checkpoint, Gui gui) {
        this.log.debug(checkpoint, "Server::HTTPSendFile(" + surl + "," + file1 + ")");
        try {
            String fileMimeType = Utils.findMimeType(file1);
            File fileHandler = new File(file1);
            MediaType MEDIA_TYPE = MediaType.parse(fileMimeType);
            MultipartBody uploadContent = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("file", fileHandler.getName(), RequestBody.create(fileHandler, MEDIA_TYPE)).build();
            Request request = new Request.Builder().addHeader("User-Agent", this.HTTP_USER_AGENT).url(surl).post(uploadContent).build();
            LocalDateTime startRequestTime = LocalDateTime.now();
            Call call = this.httpClient.newCall(request);
            Response response = call.execute();
            LocalDateTime endRequestTime = LocalDateTime.now();
            Duration duration = Duration.between(startRequestTime, endRequestTime);
            this.ulStats.calc(fileHandler.length(), duration.getSeconds() * 1000L + (long)(duration.getNano() / 1000000));
            gui.displayTransferStats(this.dlStats, this.ulStats);
            this.log.debug(String.format("File uploaded at %s/s, uploaded %d bytes", new TransferStats(fileHandler.length(), duration.toMillis() + 1L).getAverageSessionSpeed(), fileHandler.length()));
            int r = response.code();
            String contentType = response.body().contentType().toString();
            if (r == 200 && contentType.startsWith("text/xml")) {
                try {
                    String in = response.body().string();
                    JobValidation jobValidation = (JobValidation)((Object)new Persister().read(JobValidation.class, in));
                    this.lastRequestTime = new Date().getTime();
                    Error.ServerCode serverCode = Error.ServerCode.fromInt(jobValidation.getStatus());
                    if (serverCode != Error.ServerCode.OK) {
                        this.log.error(checkpoint, "Server::HTTPSendFile wrong status (is " + serverCode + ")");
                        return serverCode;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return Error.ServerCode.OK;
            }
            if (r == 200 && contentType.startsWith("text/html")) {
                return Error.ServerCode.ERROR_BAD_RESPONSE;
            }
            if (r == 413) {
                this.log.error(response.body().string());
                return Error.ServerCode.JOB_VALIDATION_IMAGE_TOO_LARGE;
            }
            if (r == 500) {
                return Error.ServerCode.ERROR_BAD_RESPONSE;
            }
            this.log.error(String.format("Server::HTTPSendFile Unknown response received from server: %s", response.body().string()));
            return Error.ServerCode.UNKNOWN;
        }
        catch (ConnectException e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            this.log.error(checkpoint, String.format("Server::HTTPSendFile Error in upload process. Exception %s stacktrace ", e.getMessage()) + sw.toString());
            return Error.ServerCode.SERVER_CONNECTION_FAILED;
        }
        catch (IOException e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            this.log.error(checkpoint, String.format("Server::HTTPSendFile Error in upload process. Exception %s stacktrace ", e.getMessage()) + sw.toString());
            return Error.ServerCode.UNKNOWN;
        }
        catch (OutOfMemoryError e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            this.log.error(checkpoint, "Server::HTTPSendFile, OutOfMemoryError " + e + " stacktrace " + sw.toString());
            return Error.ServerCode.JOB_VALIDATION_ERROR_UPLOAD_FAILED;
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            this.log.error(checkpoint, "Server::HTTPSendFile, Exception " + e + " stacktrace " + sw.toString());
            return Error.ServerCode.UNKNOWN;
        }
    }

    private String generateXMLForMD5cache() {
        String string;
        ArrayList<FileMD5> md5s = new ArrayList<FileMD5>();
        for (File local_file : this.user_config.getLocalCacheFiles()) {
            try {
                String extension = local_file.getName().substring(local_file.getName().lastIndexOf(46)).toLowerCase();
                String name = local_file.getName().substring(0, local_file.getName().length() - 1 * extension.length());
                if (!extension.equals(".zip") && !extension.equals(".wool")) continue;
                FileMD5 fileMD5 = new FileMD5();
                fileMD5.setMd5(name);
                md5s.add(fileMD5);
            }
            catch (StringIndexOutOfBoundsException extension) {}
        }
        CacheFileMD5 cache = new CacheFileMD5();
        cache.setMd5s(md5s);
        Persister persister = new Persister();
        StringWriter writer = new StringWriter();
        try {
            persister.write((Object)cache, writer);
            string = writer.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                this.log.debug("Failed to dump md5s " + e);
                return "";
            }
        }
        writer.close();
        return string;
    }

    private void handleFileMD5DeleteDocument(List<FileMD5> fileMD5s) {
        if (fileMD5s != null && !fileMD5s.isEmpty()) {
            for (FileMD5 fileMD5 : fileMD5s) {
                if (!"delete".equals(fileMD5.getAction()) || fileMD5.getMd5() == null || fileMD5.getMd5().isEmpty()) continue;
                ArrayList<CallSite> paths = new ArrayList<CallSite>();
                paths.add((CallSite)((Object)(this.user_config.getStorageDirectory().getAbsolutePath() + File.separator + fileMD5.getMd5())));
                paths.add((CallSite)((Object)(this.user_config.getWorkingDirectory().getAbsolutePath() + File.separator + fileMD5.getMd5())));
                if (this.user_config.getSharedDownloadsDirectory() != null) {
                    paths.add((CallSite)((Object)(this.user_config.getSharedDownloadsDirectory().getAbsolutePath() + File.separator + fileMD5.getMd5())));
                }
                for (String string : paths) {
                    new File(string + ".wool").delete();
                    new File(string + ".zip").delete();
                    Utils.delete(new File(string));
                }
            }
        }
    }

    public String getPage(String key) {
        RequestEndPoint endpoint;
        if (this.serverConfig != null && (endpoint = this.serverConfig.getRequestEndPoint(key)) != null) {
            return this.base_url + endpoint.getPath();
        }
        return "";
    }

    private OkHttpClient getOkHttpClient() {
        try {
            OkHttpClient.Builder builder = new OkHttpClient.Builder();
            CookieManager cookieManager = new CookieManager();
            cookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
            builder.cookieJar(new JavaNetCookieJar(cookieManager));
            builder.connectTimeout(30L, TimeUnit.SECONDS);
            builder.writeTimeout(60L, TimeUnit.SECONDS);
            if (this.user_config.getProxy() != null) {
                builder.readTimeout(10L, TimeUnit.MINUTES);
            } else {
                builder.readTimeout(1L, TimeUnit.MINUTES);
            }
            return builder.build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ServerConfig getServerConfig() {
        return this.serverConfig;
    }
}

