/*
 * Decompiled with CFR 0.152.
 */
package com.sheepit.client;

import com.sheepit.client.Utils;

public class TransferStats {
    private long bytes;
    private long millis;

    public TransferStats() {
        this.bytes = 0L;
        this.millis = 0L;
    }

    public void calc(long bytes, long millis) {
        this.bytes += bytes;
        this.millis += millis;
    }

    public String getSessionTraffic() {
        return Utils.formatDataConsumption(this.bytes);
    }

    public String getAverageSessionSpeed() {
        try {
            return Utils.formatDataConsumption((long)((float)this.bytes / ((float)this.millis / 1000.0f)));
        }
        catch (ArithmeticException e) {
            return Utils.formatDataConsumption((long)((float)this.bytes / 0.1f));
        }
    }

    public long getRawAverageSessionSpeed() {
        return this.millis != 0L ? (long)((float)this.bytes / ((float)this.millis / 1000.0f)) : 0L;
    }

    public TransferStats(long bytes, long millis) {
        this.bytes = bytes;
        this.millis = millis;
    }
}

