/*
 * Decompiled with CFR 0.152.
 */
package com.sheepit.client.hardware.cpu;

import com.sheepit.client.Log;
import com.sheepit.client.os.OS;
import com.sheepit.client.os.Windows;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class CPU {
    public static final int MIN_CORES = Runtime.getRuntime().availableProcessors() > 1 ? 2 : 1;
    private String name;
    private String model;
    private String family;
    private final String arch = CPU.detectArch();
    private static final Log log = Log.getInstance(null);
    private static Integer logicalCores = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int cores() {
        if (logicalCores == -1) {
            logicalCores = Runtime.getRuntime().availableProcessors();
            if (OS.getOS() instanceof Windows) {
                ProcessBuilder powershellProcess = new ProcessBuilder("powershell.exe", "((Get-CimInstance -ClassName Win32_Processor).NumberOfLogicalProcessors | Measure-Object -Sum ).Sum");
                powershellProcess.redirectErrorStream(true);
                Process process = null;
                try {
                    process = powershellProcess.start();
                }
                catch (IOException ex) {
                    log.error("CPU::cores Error starting Powershell Process. Stacktrace:" + ex);
                }
                if (process != null) {
                    try (BufferedReader shellStdOut = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                        String shellLine;
                        while ((shellLine = shellStdOut.readLine()) != null) {
                            if (shellLine.matches("^[+-]?\\d+$")) {
                                logicalCores = Integer.parseInt(shellLine);
                                continue;
                            }
                            log.error("CPU::cores Powershell error: " + shellLine);
                        }
                        process.waitFor();
                    }
                    catch (Exception ex) {
                        log.error("CPU::cores Error in Powershell Script. Stacktrace: " + ex);
                    }
                    finally {
                        process.destroy();
                    }
                } else {
                    log.error("CPU::cores Error powershell process is NULL! Cannot run script.");
                }
            }
        }
        return logicalCores;
    }

    private static String detectArch() {
        String arch;
        switch (arch = System.getProperty("os.arch").toLowerCase()) {
            case "i386": 
            case "i686": 
            case "x86": {
                return "32bit";
            }
            case "amd64": 
            case "x86_64": 
            case "x64": 
            case "aarch64": {
                return "64bit";
            }
        }
        return null;
    }

    public boolean haveData() {
        return this.name != null && this.model != null && this.family != null && this.arch != null;
    }

    public String getName() {
        return this.name;
    }

    public String getModel() {
        return this.model;
    }

    public String getFamily() {
        return this.family;
    }

    public String getArch() {
        return this.arch;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setFamily(String family) {
        this.family = family;
    }
}

