/*
 * Decompiled with CFR 0.152.
 */
package com.sheepit.client.hardware.gpu;

import com.sheepit.client.Configuration;
import com.sheepit.client.hardware.gpu.GPUDevice;
import com.sheepit.client.hardware.gpu.hip.HIP;
import com.sheepit.client.hardware.gpu.nvidia.Nvidia;
import com.sheepit.client.os.OS;
import com.sheepit.client.os.Windows;
import java.util.LinkedList;
import java.util.List;

public class GPU {
    public static List<GPUDevice> devices = null;

    public static boolean generate() {
        devices = new LinkedList<GPUDevice>();
        List<GPUDevice> gpus = new Nvidia().getGpus();
        if (gpus != null) {
            devices.addAll(gpus);
        }
        return true;
    }

    public static List<String> listModels() {
        if (devices == null) {
            GPU.generate();
        }
        LinkedList<String> devs = new LinkedList<String>();
        for (GPUDevice dev : devices) {
            devs.add(dev.getModel());
        }
        return devs;
    }

    public static List<GPUDevice> listDevices(Configuration config) {
        if (devices == null) {
            if (config.isDetectGPUs()) {
                GPU.generate();
            } else {
                devices = new LinkedList<GPUDevice>();
            }
        }
        return devices;
    }

    public static boolean hasHIPDevices() {
        OS os = OS.getOS();
        if (os instanceof Windows) {
            return HIP.hasHIPDevices();
        }
        return false;
    }

    public static GPUDevice getGPUDevice(String deviceId) {
        if (deviceId == null) {
            return null;
        }
        if (devices == null) {
            GPU.generate();
        }
        if (devices == null) {
            return null;
        }
        for (GPUDevice dev : devices) {
            if (!deviceId.equals(dev.getId()) && !deviceId.equals(dev.getOldId())) continue;
            return dev;
        }
        return null;
    }
}

