/*
 * Decompiled with CFR 0.152.
 */
package com.sheepit.client.hardware.gpu.hip;

import com.sheepit.client.hardware.gpu.hip.HIPLib;
import com.sheepit.client.os.OS;
import com.sheepit.client.os.Windows;
import com.sun.jna.Native;
import com.sun.jna.ptr.IntByReference;

public class HIP {
    private static final String HIP_LIBRARY = "amdhip64";
    public static final String TYPE = "HIP";
    private static int HIP_DEVICES_CACHED = -1;

    private static int getNumberOfDevices(HIPLib hipLib) {
        IntByReference deviceCount = new IntByReference();
        int status = hipLib.hipGetDeviceCount(deviceCount);
        if (status != 0) {
            System.err.println("Error");
            return -1;
        }
        return deviceCount.getValue();
    }

    public static boolean hasHIPDevices() {
        if (HIP_DEVICES_CACHED >= 0) {
            return HIP_DEVICES_CACHED > 0;
        }
        OS os = OS.getOS();
        if (os instanceof Windows) {
            try {
                HIPLib hip = Native.load(HIP_LIBRARY, HIPLib.class);
                HIP_DEVICES_CACHED = HIP.getNumberOfDevices(hip);
            }
            catch (UnsatisfiedLinkError e) {
                System.out.println("HIP::getGpus failed(A) to load HIP lib (path: amdhip64)");
            }
            catch (ExceptionInInitializerError e) {
                System.out.println("HIP::getGpus failed(B) ExceptionInInitializerError " + e);
            }
            catch (Exception e) {
                System.out.println("HIP::getGpus failed(C) generic exception " + e);
            }
            if (HIP_DEVICES_CACHED < 0) {
                HIP_DEVICES_CACHED = 0;
            }
        } else {
            HIP_DEVICES_CACHED = 0;
        }
        return HIP_DEVICES_CACHED > 0;
    }
}

