/*
 * Decompiled with CFR 0.152.
 */
package com.sheepit.client.hardware.hwid;

import com.sheepit.client.Log;
import com.sheepit.client.hardware.hwid.BasicHWInfoStrategy;
import com.sheepit.client.hardware.hwid.impl.BaseHWInfoImpl;
import java.io.File;
import java.math.BigInteger;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;

public class HWIdentifier {
    private final BasicHWInfoStrategy strategy = new BaseHWInfoImpl();
    private Log log;

    public HWIdentifier(Log log) {
        this.log = log;
    }

    public String getMAC() {
        return this.strategy.getMAC().orElse("");
    }

    public String getHarddriveSerial() {
        return this.strategy.getHarddriveID().orElse("");
    }

    public String getProcessorName() {
        return this.strategy.getProcessorName().orElse("");
    }

    public String getHardwareHash() {
        try {
            byte[] hash;
            MessageDigest digest = MessageDigest.getInstance("md5");
            String hdSerial = this.getHarddriveSerial();
            if (hdSerial.length() > 0) {
                hash = digest.digest(hdSerial.getBytes(StandardCharsets.UTF_8));
                this.log.debug("Hardware::loaded Hardware definitions ver 1.1");
            } else {
                String mac = this.getMAC();
                if (mac.length() > 0) {
                    hash = digest.digest(mac.getBytes(StandardCharsets.UTF_8));
                    this.log.debug("Hardware::loaded Hardware definitions ver 1.2");
                } else {
                    this.log.debug("Hardware::loaded Hardware definitions ver 1.3");
                    String cpuName = this.getProcessorName();
                    if (cpuName.isEmpty()) {
                        this.log.error("Hardware::failed to load Hardware definitions");
                        throw new UnsupportedOperationException("Unable to load CPU information!");
                    }
                    String homeDir = System.getProperty("user.home");
                    URL clientURL = this.getClass().getProtectionDomain().getCodeSource().getLocation();
                    String clientPath = new File(clientURL.toString()).getParent();
                    hash = digest.digest((homeDir + clientPath + cpuName).getBytes(StandardCharsets.UTF_8));
                }
            }
            BigInteger num = new BigInteger(1, hash);
            return num.toString(16);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.error("HWIdentifier::getHardwareHash could not retrieve hash: " + e);
            return "unknown";
        }
    }
}

