/*
 * Decompiled with CFR 0.152.
 */
package com.sheepit.client.os;

import com.sheepit.client.hardware.cpu.CPU;
import com.sheepit.client.os.Linux;
import com.sheepit.client.os.Mac;
import com.sheepit.client.os.MacM1;
import com.sheepit.client.os.Windows;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.software.os.OperatingSystem;

public abstract class OS {
    private static SystemInfo systemInfo = new SystemInfo();
    public static OperatingSystem operatingSystem = systemInfo.getOperatingSystem();
    private static HardwareAbstractionLayer hardwareAbstractionLayer = systemInfo.getHardware();
    private static OS instance = null;

    public abstract String name();

    public boolean isSupported() {
        return "64bit".equals(this.getCPU().getArch());
    }

    public String getVersion() {
        return (this.name() + " " + operatingSystem.getVersionInfo()).toLowerCase();
    }

    public long getTotalMemory() {
        return hardwareAbstractionLayer.getMemory().getTotal() / 1024L;
    }

    public long getFreeMemory() {
        return hardwareAbstractionLayer.getMemory().getAvailable() / 1024L;
    }

    public abstract String getRenderBinaryPath();

    public String getCUDALib() {
        return null;
    }

    public String getNVMLLib() {
        return null;
    }

    public abstract boolean isHighPrioritySupported();

    public abstract boolean isNiceAvailable();

    public abstract void shutdownComputer(int var1);

    public CPU getCPU() {
        CentralProcessor.ProcessorIdentifier cpuID = hardwareAbstractionLayer.getProcessor().getProcessorIdentifier();
        CPU ret = new CPU();
        ret.setName(cpuID.getName());
        ret.setModel(cpuID.getModel());
        ret.setFamily(cpuID.getFamily());
        return ret;
    }

    public abstract Process exec(List<String> var1, Map<String, String> var2) throws IOException;

    public boolean kill(Process proc) {
        if (proc != null) {
            proc.destroy();
            return true;
        }
        return false;
    }

    public static OS getOS() {
        if (instance == null) {
            switch (operatingSystem.getManufacturer()) {
                case "Microsoft": {
                    instance = new Windows();
                    break;
                }
                case "Apple": {
                    if ("aarch64".equalsIgnoreCase(System.getProperty("os.arch"))) {
                        instance = new MacM1();
                        break;
                    }
                    instance = new Mac();
                    break;
                }
                case "GNU/Linux": {
                    instance = new Linux();
                }
            }
        }
        return instance;
    }

    public String getDefaultConfigFilePath() {
        File file;
        Object xdgConfigHome = System.getenv("XDG_CONFIG_HOME");
        String userHome = System.getProperty("user.home");
        if (xdgConfigHome == null || ((String)xdgConfigHome).isEmpty()) {
            xdgConfigHome = userHome + File.separator + ".config";
        }
        if ((file = new File((String)(xdgConfigHome = (String)xdgConfigHome + File.separator + "sheepit") + File.separator + "sheepit.conf")).exists()) {
            return file.getAbsolutePath();
        }
        file = new File(userHome + File.separator + ".sheepit.conf");
        if (file.exists()) {
            return file.getAbsolutePath();
        }
        file = new File((String)xdgConfigHome);
        file.mkdirs();
        return file.getAbsolutePath() + File.separator + "sheepit.conf";
    }
}

