/*
 * Decompiled with CFR 0.152.
 */
package com.sheepit.client.standalone;

import com.sheepit.client.Client;
import com.sheepit.client.Gui;
import com.sheepit.client.Log;
import com.sheepit.client.Stats;
import com.sheepit.client.TransferStats;
import com.sheepit.client.standalone.text.CLIInputActionHandler;
import com.sheepit.client.standalone.text.CLIInputObserver;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class GuiText
implements Gui {
    public static final String type = "text";
    private int framesRendered = 0;
    private int sigIntCount = 0;
    private Log log = Log.getInstance(null);
    private DateFormat df = new SimpleDateFormat("MMM dd HH:mm:ss");
    private String eta = "";
    private Client client;

    @Override
    public void start() {
        if (this.client != null) {
            CLIInputObserver cli_input_observer = new CLIInputObserver(this.client);
            cli_input_observer.addListener(new CLIInputActionHandler());
            Thread cli_input_observer_thread = new Thread(cli_input_observer);
            cli_input_observer_thread.start();
            Signal.handle(new Signal("INT"), new SignalHandler(){

                @Override
                public void handle(Signal signal) {
                    ++GuiText.this.sigIntCount;
                    if (GuiText.this.sigIntCount == 4) {
                        System.out.println("WARNING: Hitting Ctrl-C again will force close the application.");
                    } else if (GuiText.this.sigIntCount == 5) {
                        Signal.raise(new Signal("INT"));
                        Runtime.getRuntime().halt(0);
                    } else if (GuiText.this.client.isRunning() && !GuiText.this.client.isSuspended()) {
                        GuiText.this.client.askForStop();
                        System.out.println("Will exit after current frame... Press Ctrl+C again to exit now.");
                    } else {
                        GuiText.this.client.stop();
                        GuiText.this.stop();
                    }
                }
            });
            this.client.run();
            this.client.stop();
        }
        this.stop();
    }

    @Override
    public void stop() {
        Runtime.getRuntime().halt(0);
    }

    @Override
    public void updateTrayIcon(Integer percentage) {
    }

    @Override
    public void status(String msg_) {
        this.status(msg_, false);
    }

    @Override
    public void status(String msg_, boolean overwriteSuspendedMsg) {
        this.log.debug("GUI " + msg_);
        if (this.client != null && this.client.isSuspended()) {
            if (overwriteSuspendedMsg) {
                System.out.println(String.format("%s %s", this.df.format(new Date()), msg_));
            }
        } else {
            System.out.println(String.format("%s %s", this.df.format(new Date()), msg_));
        }
    }

    @Override
    public void status(String msg, int progress) {
        this.status(msg, progress, 0L);
    }

    @Override
    public void status(String msg, int progress, long size) {
        System.out.print("\r");
        System.out.print(String.format("%s %s", this.df.format(new Date()), this.showProgress(msg, progress, size)));
    }

    @Override
    public void error(String err_) {
        System.out.println(String.format("ERROR: %s %s", this.df.format(new Date()), err_));
        this.log.error("Error " + err_);
    }

    @Override
    public void AddFrameRendered() {
        ++this.framesRendered;
        System.out.println(String.format("%s Frames rendered: %d", this.df.format(new Date()), this.framesRendered));
    }

    @Override
    public synchronized void displayTransferStats(TransferStats downloads, TransferStats uploads) {
        System.out.println(String.format("%s Session downloads: %s @ %s/s / Uploads: %s @ %s/s", this.df.format(new Date()), downloads.getSessionTraffic(), downloads.getAverageSessionSpeed(), uploads.getSessionTraffic(), uploads.getAverageSessionSpeed()));
    }

    @Override
    public void displayStats(Stats stats) {
        System.out.println(String.format("%s Frames remaining: %d", this.df.format(new Date()), stats.getRemainingFrame()));
        System.out.println(String.format("%s Credits earned: %d", this.df.format(new Date()), stats.getCreditsEarnedDuringSession()));
    }

    @Override
    public void displayUploadQueueStats(int queueSize, long queueVolume) {
        System.out.println(String.format("%s Queued uploads: %d (%.2fMB)", this.df.format(new Date()), queueSize, (double)queueVolume / 1024.0 / 1024.0));
    }

    @Override
    public void setRenderingProjectName(String name_) {
        if (name_ != null && !name_.isEmpty()) {
            System.out.println(String.format("%s Rendering project \"%s\"", this.df.format(new Date()), name_));
        }
    }

    @Override
    public void setRemainingTime(String time_) {
        this.eta = time_;
    }

    @Override
    public void setRenderingTime(String time_) {
        System.out.println(String.format("%s Rendering %s", this.df.format(new Date()), time_));
    }

    @Override
    public void setClient(Client cli) {
        this.client = cli;
    }

    @Override
    public void setComputeMethod(String computeMethod) {
        System.out.println(String.format("%s Compute method: %s", this.df.format(new Date()), computeMethod));
    }

    @Override
    public Client getClient() {
        return this.client;
    }

    @Override
    public void successfulAuthenticationEvent(String publickey) {
    }

    private String showProgress(String message, int progress, long size) {
        StringBuilder progressBar = new StringBuilder(140);
        if (progress < 100) {
            progressBar.append(message).append(" ").append(String.join((CharSequence)"", Collections.nCopies(progress == 0 ? 2 : 2 - (int)Math.log10(progress), " "))).append(String.format("%d%% [", progress)).append(String.join((CharSequence)"", Collections.nCopies(progress / 5, "="))).append('>').append(String.join((CharSequence)"", Collections.nCopies(20 - progress / 5, " "))).append(']');
            if (size > 0L) {
                progressBar.append(String.format(" %dMB", size / 1024L / 1024L));
            }
            if (!this.eta.equals("")) {
                progressBar.append(String.format(" ETA %s", this.eta));
            }
            progressBar.append(String.join((CharSequence)"", Collections.nCopies(60 - progressBar.length(), " ")));
        } else {
            progressBar.append(message).append(" done").append(String.join((CharSequence)"", Collections.nCopies(60 - progressBar.length(), " "))).append("\n");
        }
        return progressBar.toString();
    }
}

