/*
 * Decompiled with CFR 0.152.
 */
package com.sheepit.client.standalone;

import com.sheepit.client.Configuration;
import com.sheepit.client.hardware.gpu.GPU;
import com.sheepit.client.hardware.gpu.GPUDevice;
import java.util.List;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Parameters;
import org.kohsuke.args4j.spi.Setter;

public class ListGpuParameterHandler<T>
extends OptionHandler<T> {
    public ListGpuParameterHandler(CmdLineParser parser, OptionDef option, Setter<? super T> setter) {
        super(parser, option, setter);
    }

    @Override
    public int parseArguments(Parameters params) throws CmdLineException {
        List<GPUDevice> gpus = GPU.listDevices(new Configuration(null, null, null));
        if (gpus != null) {
            for (GPUDevice gpu : gpus) {
                System.out.println("GPU_ID    : " + gpu.getOldId());
                System.out.println("Long ID   : " + gpu.getId());
                System.out.println("Model     : " + gpu.getModel());
                System.out.println("Memory, MB: " + (int)(gpu.getMemory() / 0x100000L));
                System.out.println();
            }
        }
        if (GPU.hasHIPDevices()) {
            System.out.println("HIP devices are not supported");
        }
        System.exit(0);
        return 0;
    }

    @Override
    public String getDefaultMetaVariable() {
        return null;
    }
}

