/*
 * Decompiled with CFR 0.152.
 */
package com.sheepit.client.standalone;

import com.sheepit.client.Client;
import com.sheepit.client.Configuration;
import com.sheepit.client.Error;
import com.sheepit.client.Gui;
import com.sheepit.client.Log;
import com.sheepit.client.Pair;
import com.sheepit.client.SettingsLoader;
import com.sheepit.client.ShutdownHook;
import com.sheepit.client.Utils;
import com.sheepit.client.hardware.gpu.GPU;
import com.sheepit.client.hardware.gpu.GPUDevice;
import com.sheepit.client.hardware.gpu.nvidia.Nvidia;
import com.sheepit.client.network.Proxy;
import com.sheepit.client.os.OS;
import com.sheepit.client.standalone.GuiSwing;
import com.sheepit.client.standalone.GuiText;
import com.sheepit.client.standalone.GuiTextOneLine;
import com.sheepit.client.standalone.ListGpuParameterHandler;
import com.sheepit.client.standalone.VersionParameterHandler;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.net.MalformedURLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.OptionHandlerFilter;

public class Worker {
    @Option(name="-server", usage="Render-farm server, default https://client.sheepit-renderfarm.com", metaVar="URL", required=false)
    private String server = "https://client.sheepit-renderfarm.com";
    @Option(name="-login", usage="User's login", metaVar="LOGIN", required=false)
    private String login = "";
    @Option(name="-password", usage="User's password or public key (accessible under the Keys tab of the profile page)", metaVar="PASSWORD", required=false)
    private String password = "";
    @Option(name="-cache-dir", usage="Cache/Working directory. Caution, everything in it not related to the render-farm will be removed", metaVar="/tmp/cache", required=false)
    private String cache_dir = null;
    @Option(name="-shared-zip", usage="Shared directory for downloaded binaries and scenes. Useful when running two or more clients in the same computer/network to download once and render many times. IMPORTANT: This option and value must be identical in ALL clients sharing the directory.", required=false)
    private String sharedDownloadsDir = null;
    @Option(name="-gpu", usage="Name of the GPU used for the render, for example OPTIX_0 for Nvidia cards.", metaVar="OPTIX_0", required=false)
    private String gpu_device = null;
    @Option(name="--no-gpu", usage="Don't detect GPUs", required=false)
    private boolean no_gpu_detection = false;
    @Option(name="-compute-method", usage="CPU: only use cpu, GPU: only use gpu, CPU_GPU: can use cpu and gpu (not at the same time) if -gpu is not use it will not use the gpu", metaVar="CPU", required=false)
    private String method = null;
    @Option(name="-cores", usage="Number of cores/threads to use for the render. The minimum is two cores unless your system only has one", metaVar="3", required=false)
    private int nb_cores = -1;
    @Option(name="-memory", usage="Maximum memory allow to be used by renderer, number with unit (800M, 2G, ...)", required=false)
    private String max_ram = null;
    @Option(name="-rendertime", usage="Maximum time allow for each frame (in minutes)", required=false)
    private int max_rendertime = -1;
    @Option(name="--verbose", usage="Display full log", required=false)
    private boolean print_log = false;
    @Option(name="-request-time", usage="H1:M1-H2:M2,H3:M3-H4:M4 Use the 24h format. For example to request job between 2am-8.30am and 5pm-11pm you should do -request-time 2:00-8:30,17:00-23:00 Caution, it's the requesting job time to get a project, not the working time", metaVar="2:00-8:30,17:00-23:00", required=false)
    private String request_time = null;
    @Option(name="-shutdown", usage="Specify when the client will close and the host computer will shut down in a proper way. The time argument can have two different formats: an absolute date and time in the format yyyy-mm-ddThh:mm:ss (24h format) or a relative time in the format +m where m is the number of minutes from now.", metaVar="DATETIME or +N", required=false)
    private String shutdown = null;
    @Option(name="-shutdown-mode", usage="Indicates if the shutdown process waits for the upload queue to finish (wait) or interrupt all the pending tasks immediately (hard). The default shutdown mode is wait.", metaVar="MODE", required=false)
    private String shutdownMode = null;
    @Option(name="-proxy", usage="URL of the proxy", metaVar="http://login:password@host:port", required=false)
    private String proxy = null;
    @Option(name="-extras", usage="Extras data push on the authentication request", required=false)
    private String extras = null;
    @Option(name="-ui", usage="Specify the user interface to use, default 'swing', available 'oneLine', 'text', 'swing' (graphical)", required=false)
    private String ui_type = null;
    @Option(name="-config", usage="Specify the configuration file", required=false)
    private String config_file = null;
    @Option(name="--version", usage="Display application version", required=false, handler=VersionParameterHandler.class)
    private VersionParameterHandler versionHandler;
    @Option(name="--show-gpu", usage="Print available GPU devices and exit", required=false, handler=ListGpuParameterHandler.class)
    private ListGpuParameterHandler listGpuParameterHandler;
    @Option(name="--no-systray", usage="Don't use SysTray", required=false)
    private boolean useSysTray = false;
    @Option(name="-priority", usage="Set render process priority (19 lowest to -19 highest)", required=false)
    private int priority = 19;
    @Option(name="-title", usage="Custom title for the GUI Client", required=false)
    private String title = "SheepIt Render Farm";
    @Option(name="-theme", usage="Specify the theme to use for the graphical client, default 'light', available 'light', 'dark'", required=false)
    private String theme = null;
    @Option(name="-hostname", usage="Set a custom hostname name (name change will be lost when client is closed)", required=false)
    private String hostname = null;
    @Option(name="--headless", usage="Mark your client manually as headless to block Eevee projects", required=false)
    private boolean headless = GraphicsEnvironment.isHeadless();

    public static void main(String[] args2) {
        if (OS.getOS() == null) {
            System.err.println(Error.humanString(Error.Type.OS_NOT_SUPPORTED));
            System.exit(1);
        }
        new Worker().doMain(args2);
    }

    public void doMain(String[] args2) {
        Gui gui;
        String type;
        String[] intervals;
        CmdLineParser parser = new CmdLineParser(this);
        try {
            parser.parseArgument(args2);
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            System.err.println("Usage: ");
            parser.printUsage(System.err);
            System.err.println();
            System.err.println("Example: java " + this.getClass().getName() + " " + parser.printExample(OptionHandlerFilter.REQUIRED));
            return;
        }
        Configuration.ComputeType compute_method = null;
        Configuration config = new Configuration(null, this.login, this.password);
        config.setPrintLog(this.print_log);
        config.setPriority(this.priority);
        config.setDetectGPUs(!this.no_gpu_detection);
        if (this.sharedDownloadsDir != null) {
            File dir = new File(this.sharedDownloadsDir);
            if (!dir.exists() && dir.mkdirs()) {
                Log.getInstance(config).debug("created shared-zip directory " + dir);
            } else if (!dir.exists()) {
                System.err.println("ERROR: The shared-zip directory " + dir + " does not exist and cannot be automatically created");
                return;
            }
            if (!dir.canWrite()) {
                System.err.println("ERROR: The shared-zip directory " + dir + " must be writeable");
                return;
            }
            config.setSharedDownloadsDirectory(dir);
        }
        if (this.cache_dir != null) {
            Pattern cache_dirValidator = Pattern.compile("^(\\/|\\\\|[a-z]:)?[a-z0-9\\/\\\\\\s-_.]+$", 2);
            Matcher cache_dirCandidate = cache_dirValidator.matcher(this.cache_dir);
            if (cache_dirCandidate.find()) {
                String[] a_dir = new File(this.cache_dir);
                a_dir.mkdirs();
                if (a_dir.isDirectory() && a_dir.canWrite()) {
                    config.setCacheDir((File)a_dir);
                } else {
                    System.err.println("ERROR: The entered cache path is either not a directory or is not writable!");
                    System.exit(2);
                }
            } else {
                System.err.println("ERROR: The entered cache path (-cache-dir parameter) contains invalid characters. Allowed characters are a-z, A-Z, 0-9, /, \\, ., - and _");
                System.exit(2);
            }
        }
        config.setMaxUploadingJob(3);
        config.setUseSysTray(!this.useSysTray);
        config.setHeadless(this.headless);
        if (this.gpu_device != null) {
            if (this.gpu_device.startsWith("HIP")) {
                System.err.println("ERROR: HIP devices are not supported");
            } else if (!this.gpu_device.startsWith(Nvidia.TYPE)) {
                System.err.println("ERROR: The entered GPU_ID is invalid. The GPU_ID should look like '" + Nvidia.TYPE + "_#. Please use the proper GPU_ID from the GPU list below\n");
                this.showGPUList(parser);
            }
            GPUDevice gpu = GPU.getGPUDevice(this.gpu_device);
            if (gpu == null) {
                System.err.println("ERROR: The entered GPU_ID is invalid. Please use the proper GPU_ID from the GPU list below\n");
                this.showGPUList(parser);
            }
            config.setGPUDevice(gpu);
        }
        if (this.request_time != null && (intervals = this.request_time.split(",")) != null) {
            config.setRequestTime(new LinkedList<Pair<Calendar, Calendar>>());
            SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm");
            for (String interval : intervals) {
                String[] times = interval.split("-");
                if (times == null || times.length != 2) continue;
                Calendar start = Calendar.getInstance();
                Calendar end = Calendar.getInstance();
                try {
                    start.setTime(timeFormat.parse(times[0]));
                    end.setTime(timeFormat.parse(times[1]));
                }
                catch (ParseException e) {
                    System.err.println(String.format("ERROR: The entered time slot (-request-time parameter) doesn't seem to be valid. Please check the format is correct [%s]", e.getMessage()));
                    System.exit(2);
                }
                if (start.before(end)) {
                    config.getRequestTime().add(new Pair<Calendar, Calendar>(start, end));
                    continue;
                }
                try {
                    Calendar midnightBefore = Calendar.getInstance();
                    midnightBefore.setTime(timeFormat.parse("23:59"));
                    Calendar midnightAfter = Calendar.getInstance();
                    midnightAfter.setTime(timeFormat.parse("00:00"));
                    config.getRequestTime().add(new Pair<Calendar, Calendar>(start, midnightBefore));
                    config.getRequestTime().add(new Pair<Calendar, Calendar>(midnightAfter, end));
                }
                catch (ParseException e) {
                    System.err.println("Failed to parse date");
                    System.exit(2);
                }
            }
        }
        if (this.nb_cores < -1 || this.nb_cores == 0) {
            System.err.println("ERROR: The entered number of CPU cores (-cores parameter) is not valid. Please enter a number greater than zero");
            return;
        }
        config.setNbCores(this.nb_cores);
        if (this.max_ram != null) {
            try {
                config.setMaxAllowedMemory(Utils.parseNumber(this.max_ram) / 1024L);
            }
            catch (IllegalStateException e) {
                System.err.println(String.format("ERROR: The entered value of maximum memory (-memory parameter) doesn't seem to be a valid number [%s]", e.getMessage()));
                return;
            }
        }
        if (this.max_rendertime > 0) {
            config.setMaxRenderTime(this.max_rendertime * 60);
        }
        if (this.method != null) {
            try {
                compute_method = Configuration.ComputeType.valueOf(this.method);
            }
            catch (IllegalArgumentException e) {
                System.err.println(String.format("ERROR: The entered compute method (-compute-method parameter) is not valid. Available values are CPU, GPU or CPU_GPU [%s]", e.getMessage()));
                System.exit(2);
            }
        } else if (config.getGPUDevice() != null) {
            compute_method = Configuration.ComputeType.GPU;
        }
        if (this.proxy != null) {
            try {
                Proxy.set(this.proxy);
            }
            catch (MalformedURLException e) {
                System.err.println(String.format("ERROR: The entered proxy URL (-proxy parameter) doesn't seem to have the right format. Please check it [%s]", e.getMessage()));
                System.exit(2);
            }
        }
        if (this.extras != null) {
            config.setExtras(this.extras);
        }
        if (compute_method != null) {
            if (compute_method == Configuration.ComputeType.CPU && config.getGPUDevice() != null) {
                System.err.println("ERROR: The compute method is set to use CPU only, but a GPU has also been specified. Change the compute method to CPU_GPU or remove the GPU");
                System.exit(2);
            } else if (compute_method == Configuration.ComputeType.CPU_GPU && config.getGPUDevice() == null) {
                System.err.println("ERROR: The compute method is set to use both CPU and GPU, but no GPU has been specified. Change the compute method to CPU or add a GPU (via -gpu parameter)");
                System.exit(2);
            } else if (compute_method == Configuration.ComputeType.GPU && config.getGPUDevice() == null) {
                System.err.println("ERROR: The compute method is set to use GPU only, but not GPU has been specified. Please add a GPU (via -gpu parameter)");
                System.exit(2);
            } else if (compute_method == Configuration.ComputeType.CPU) {
                config.setGPUDevice(null);
            }
        }
        config.setComputeMethod(compute_method);
        if (this.ui_type != null) {
            config.setUIType(this.ui_type);
        }
        if (this.theme != null) {
            if (!this.theme.equals("light") && !this.theme.equals("dark")) {
                System.err.println("ERROR: The entered theme (-theme parameter) doesn't exist. Please choose either 'light' or 'dark'");
                System.exit(2);
            }
            config.setTheme(this.theme);
        }
        if (this.shutdown != null) {
            Pattern absoluteTimePattern = Pattern.compile("^([12]\\d{3}-(0[1-9]|1[0-2])-(0[1-9]|[12]\\d|3[01]))T([01]?[0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9]$");
            Pattern relativeTimePattern = Pattern.compile("^\\+([0-9]{2,4})$");
            LocalDateTime shutdownTime = null;
            Matcher timeAbsolute = absoluteTimePattern.matcher(this.shutdown);
            Matcher timeRelative = relativeTimePattern.matcher(this.shutdown);
            if (timeAbsolute.find()) {
                shutdownTime = this.shutdownTimeParse(this.shutdown);
                if (shutdownTime != null) {
                    long diffInMillies = ChronoUnit.MILLIS.between(LocalDateTime.now(), shutdownTime);
                    if (diffInMillies < 0L) {
                        System.err.println(String.format("\nERROR: The entered shutdown time (%s) is a date on the past. Shutdown time must be at least 30 minutes from now", this.shutdown));
                        System.err.println("Aborting");
                        System.exit(2);
                    } else if (diffInMillies < 600000L) {
                        System.err.println(String.format("\nERROR: The specified shutdown time (%s) is expected to happen in less than 10 minutes. Shutdown time must be at least 30 minutes from now", this.shutdown));
                        System.err.println("Aborting");
                        System.exit(2);
                    }
                    config.setShutdownTime(diffInMillies);
                } else {
                    System.err.println(String.format("\nERROR: The format of the entered shutdown time (%s) is not correct.\nThe time argument can have two different formats: an absolute date and time in the format yyyy-mm-ddThh:mm:ss (24h format) or a relative time in the format +m where m is the number of minutes from now (min. +10 minutes, max. +9999 minutes)", this.shutdown));
                    System.err.println("Aborting");
                    System.exit(2);
                }
            } else if (timeRelative.find()) {
                int minutesUntilShutdown = Integer.parseInt(timeRelative.group(1));
                config.setShutdownTime(minutesUntilShutdown * 60 * 1000);
                shutdownTime = LocalDateTime.now().plusMinutes(minutesUntilShutdown);
            } else {
                System.err.println(String.format("\nERROR: The time especified (%s) is less than 10 minutes or the format is not correct.\nThe time argument can have two different formats: an absolute date and time in the format yyyy-mm-ddThh:mm:ss (24h format) or a relative time in the format +m where m is the number of minutes from now (min. +10 minutes, max. +9999 minutes)", this.shutdown));
                System.err.println("Aborting");
                System.exit(2);
            }
            if (this.shutdownMode != null) {
                if (this.shutdownMode.toLowerCase().equals("wait") || this.shutdownMode.toLowerCase().equals("hard")) {
                    config.setShutdownMode(this.shutdownMode.toLowerCase());
                } else {
                    System.err.println(String.format("ERROR: The entered shutdown-mode (%s) is invalid. Please enter wait or hard shutdown mode.", this.shutdownMode));
                    System.err.println("  - Wait: the shutdown process is initiated once the current job and all the queued uploads are finished.");
                    System.err.println("  - Hard: Then shutdown process is executed immediately. Any ongoing rendering process or upload queues will be cancelled.");
                    System.err.println("Aborting");
                    System.exit(2);
                }
            } else {
                config.setShutdownMode("wait");
            }
            System.out.println("==============================================================================");
            if (config.getShutdownMode().equals("wait")) {
                System.out.println(String.format("WARNING!\n\nThe client will stop requesting new jobs at %s.\nTHE EFFECTIVE SHUTDOWN MIGHT OCCUR LATER THAN THE REQUESTED TIME AS THE UPLOAD\nQUEUE MUST BE FULLY UPLOADED BEFORE THE SHUTDOWN PROCESS STARTS.\n\nIf you want to shutdown the computer sharp at the specified time, please\ninclude the '-shutdown-mode hard' parameter in the application call", shutdownTime));
            } else {
                System.out.println(String.format("WARNING!\n\nThe client will initiate the shutdown process at %s.\nALL RENDERS IN PROGRESS AND UPLOAD QUEUES WILL BE CANCELED.\n\nIf you prefer to shutdown the computer once the pending jobs are completed,\nplease include the '-shutdown-mode wait' parameter in the application call", shutdownTime));
            }
            System.out.println("==============================================================================\n");
        } else if (this.shutdown == null && this.shutdownMode != null) {
            System.err.println("ERROR: The shutdown-mode parameter cannot be entered alone. Please make sure that you also enter a valid shutdown time (using -shutdown parameter)");
            System.err.println("Aborting");
            System.exit(2);
        }
        if (this.config_file != null) {
            if (!new File(this.config_file).exists()) {
                System.err.println("ERROR: The entered configuration file (-config parameter) cannot be loaded. Please check that you've entered an existing filename");
                System.exit(2);
            }
            config.setConfigFilePath(this.config_file);
        }
        SettingsLoader settingsLoader = new SettingsLoader(this.config_file);
        settingsLoader.merge(config, true);
        if (args2.length > 0) {
            settingsLoader.markLaunchSettings(List.of(args2));
        }
        Log.getInstance(config).debug("client version " + Configuration.jarVersion);
        if (this.hostname != null) {
            Pattern hostnameValidator = Pattern.compile("[^a-z0-9-_]", 2);
            Matcher hostnameCandidate = hostnameValidator.matcher(this.hostname);
            if (hostnameCandidate.find()) {
                System.err.println("ERROR: The entered hostname (-hostname parameter) contains invalid characters. Allowed hostname characters are a-z, A-Z, 0-9, - and _");
                System.exit(2);
            } else {
                config.setHostname(this.hostname);
            }
        }
        if ((type = config.getUIType()) == null) {
            type = "swing";
        }
        switch (type) {
            case "oneLine": {
                if (config.isPrintLog()) {
                    System.err.println("ERROR: The oneLine UI and the --verbose parameter cannot be used at the same time. Please either change the ui to text or remove the verbose mode");
                    System.exit(2);
                }
                gui = new GuiTextOneLine();
                break;
            }
            case "text": {
                gui = new GuiText();
                break;
            }
            default: {
                if (GraphicsEnvironment.isHeadless()) {
                    System.err.println("ERROR: Your current configuration doesn't support graphical UI.");
                    System.err.println("Please use one of the text-based UIs provided (using -ui oneLine or -ui text)");
                    System.exit(3);
                }
                gui = new GuiSwing(config.isUseSysTray(), this.title);
                ((GuiSwing)gui).setSettingsLoader(settingsLoader);
            }
        }
        Client cli = new Client(gui, config, this.server);
        gui.setClient(cli);
        ShutdownHook hook = new ShutdownHook(cli);
        hook.attachShutDownHook();
        gui.start();
    }

    private void showGPUList(CmdLineParser parser) {
        try {
            parser.parseArgument("--show-gpu");
        }
        catch (CmdLineException e) {
            System.err.println(String.format("ERROR: Unable to parse the provided parameter [%s]", e.getMessage()));
        }
    }

    private LocalDateTime shutdownTimeParse(String shutdownTime) {
        try {
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss");
            return LocalDateTime.parse(shutdownTime, df);
        }
        catch (DateTimeParseException e) {
            e.printStackTrace();
            return null;
        }
    }
}

