/*
 * Decompiled with CFR 0.152.
 */
package com.sheepit.client.standalone.swing.activity;

import com.sheepit.client.Client;
import com.sheepit.client.Job;
import com.sheepit.client.Log;
import com.sheepit.client.Stats;
import com.sheepit.client.TransferStats;
import com.sheepit.client.Utils;
import com.sheepit.client.standalone.GuiSwing;
import com.sheepit.client.standalone.swing.activity.Activity;
import com.sheepit.client.standalone.swing.components.CollapsibleJPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.Objects;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.UIManager;

public class Working
implements Activity {
    public static final String ACTION_CLOSE_WINDOW = "Invoked close action by pressing x";
    private GuiSwing parent;
    private CollapsibleJPanel session_info_panel;
    private CollapsibleJPanel global_stats_panel;
    private CollapsibleJPanel last_frame_panel;
    private JLabel statusContent;
    private String previousStatus;
    private JLabel renderedFrameContent;
    private JLabel remainingFrameContent;
    private JLabel lastRenderTime;
    private JLabel lastRender;
    private JLabel creditEarned;
    private JButton pauseButton;
    private JButton exitAfterFrame;
    private JLabel current_project_name_value;
    private JLabel current_project_duration_value;
    private JLabel currrent_project_progression_value;
    private JLabel current_project_compute_method_value;
    private JLabel user_info_points_total_value;
    private JLabel renderable_projects_value;
    private JLabel waiting_projects_value;
    private JLabel connected_machines_value;
    private JLabel user_info_total_rendertime_this_session_value;
    private JLabel userInfoQueuedUploadsAndSizeValue;
    private JLabel sessionDownloadsStatsValue;
    private JLabel sessionUploadsStatsValue;
    private String currentTheme;
    private Log log;

    public Working(GuiSwing parent_) {
        this.parent = parent_;
        this.statusContent = new JLabel("Init");
        this.renderedFrameContent = new JLabel("0");
        this.remainingFrameContent = new JLabel("");
        this.creditEarned = new JLabel("");
        this.current_project_name_value = new JLabel("");
        this.current_project_duration_value = new JLabel("");
        this.currrent_project_progression_value = new JLabel("");
        this.current_project_compute_method_value = new JLabel("");
        this.user_info_points_total_value = new JLabel("");
        this.renderable_projects_value = new JLabel("");
        this.waiting_projects_value = new JLabel("");
        this.connected_machines_value = new JLabel("");
        this.user_info_total_rendertime_this_session_value = new JLabel("");
        this.lastRenderTime = new JLabel(" ");
        this.lastRender = new JLabel("");
        this.userInfoQueuedUploadsAndSizeValue = new JLabel("0");
        this.sessionDownloadsStatsValue = new JLabel("0KB");
        this.sessionUploadsStatsValue = new JLabel("0KB");
        this.currentTheme = UIManager.getLookAndFeel().getName();
        this.previousStatus = "";
        this.log = Log.getInstance(parent_.getConfiguration());
        this.parent.setDefaultCloseOperation(0);
        this.parent.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                super.windowClosing(e);
                if (Working.this.parent == null || !Working.this.parent.getClient().isRunning()) {
                    System.exit(0);
                }
                ExitAfterAction exitAction = new ExitAfterAction();
                exitAction.actionPerformed(new ActionEvent(this, 1001, Working.ACTION_CLOSE_WINDOW));
            }
        });
    }

    @Override
    public void show() {
        if (!this.currentTheme.equals(UIManager.getLookAndFeel().getName())) {
            this.statusContent = new JLabel(this.statusContent.getText());
            this.renderedFrameContent = new JLabel(this.renderedFrameContent.getText());
            this.remainingFrameContent = new JLabel(this.remainingFrameContent.getText());
            this.creditEarned = new JLabel(this.creditEarned.getText());
            this.current_project_name_value = new JLabel(this.current_project_name_value.getText());
            this.current_project_duration_value = new JLabel(this.current_project_duration_value.getText());
            this.currrent_project_progression_value = new JLabel(this.currrent_project_progression_value.getText());
            this.current_project_compute_method_value = new JLabel(this.current_project_compute_method_value.getText());
            this.user_info_points_total_value = new JLabel(this.user_info_points_total_value.getText());
            this.renderable_projects_value = new JLabel(this.renderable_projects_value.getText());
            this.waiting_projects_value = new JLabel(this.waiting_projects_value.getText());
            this.connected_machines_value = new JLabel(this.connected_machines_value.getText());
            this.user_info_total_rendertime_this_session_value = new JLabel(this.user_info_total_rendertime_this_session_value.getText());
            this.lastRenderTime = new JLabel(this.lastRenderTime.getText());
            this.lastRender = new JLabel(this.lastRender.getText());
            this.userInfoQueuedUploadsAndSizeValue = new JLabel(this.userInfoQueuedUploadsAndSizeValue.getText());
            this.sessionDownloadsStatsValue = new JLabel(this.sessionDownloadsStatsValue.getText());
            this.sessionUploadsStatsValue = new JLabel(this.sessionUploadsStatsValue.getText());
            this.currentTheme = UIManager.getLookAndFeel().getName();
        }
        JPanel current_project_panel = new JPanel(new GridLayout(5, 2));
        current_project_panel.setBorder(BorderFactory.createTitledBorder("Project"));
        JLabel current_project_status = new JLabel("Status: ", 11);
        JLabel current_project_name = new JLabel("Name: ", 11);
        JLabel current_project_duration = new JLabel("Rendering for: ", 11);
        JLabel current_project_progression = new JLabel("Remaining: ", 11);
        JLabel current_project_compute_method_label = new JLabel("Compute method: ", 11);
        current_project_panel.add(current_project_status);
        current_project_panel.add(this.statusContent);
        current_project_panel.add(current_project_name);
        current_project_panel.add(this.current_project_name_value);
        current_project_panel.add(current_project_duration);
        current_project_panel.add(this.current_project_duration_value);
        current_project_panel.add(current_project_progression);
        current_project_panel.add(this.currrent_project_progression_value);
        current_project_panel.add(current_project_compute_method_label);
        current_project_panel.add(this.current_project_compute_method_value);
        this.session_info_panel = new CollapsibleJPanel((LayoutManager)new GridLayout(7, 2), this);
        this.session_info_panel.setBorder(BorderFactory.createTitledBorder("Session infos"));
        JLabel user_info_credits_this_session = new JLabel("Points earned: ", 11);
        JLabel user_info_total_rendertime_this_session = new JLabel("Duration: ", 11);
        JLabel user_info_pending_uploads_and_size = new JLabel("Queued uploads: ", 11);
        JLabel session_download_stats = new JLabel("Total Downloads: ", 11);
        JLabel session_upload_stats = new JLabel("Total Uploads: ", 11);
        JLabel user_info_rendered_frame_this_session = new JLabel("Rendered frames: ", 11);
        JLabel global_static_renderable_project = new JLabel("Renderable projects: ", 11);
        this.session_info_panel.add(user_info_credits_this_session);
        this.session_info_panel.add(this.creditEarned);
        this.session_info_panel.add(user_info_rendered_frame_this_session);
        this.session_info_panel.add(this.renderedFrameContent);
        this.session_info_panel.add(user_info_pending_uploads_and_size);
        this.session_info_panel.add(this.userInfoQueuedUploadsAndSizeValue);
        this.session_info_panel.add(session_download_stats);
        this.session_info_panel.add(this.sessionDownloadsStatsValue);
        this.session_info_panel.add(session_upload_stats);
        this.session_info_panel.add(this.sessionUploadsStatsValue);
        this.session_info_panel.add(global_static_renderable_project);
        this.session_info_panel.add(this.renderable_projects_value);
        this.session_info_panel.add(user_info_total_rendertime_this_session);
        this.session_info_panel.add(this.user_info_total_rendertime_this_session_value);
        this.global_stats_panel = new CollapsibleJPanel((LayoutManager)new GridLayout(4, 2), this);
        this.global_stats_panel.setBorder(BorderFactory.createTitledBorder("Global stats"));
        JLabel global_stats_machine_connected = new JLabel("Machines connected: ", 11);
        JLabel global_stats_remaining_frame = new JLabel("Remaining frames: ", 11);
        JLabel global_stats_waiting_project = new JLabel("Active projects: ", 11);
        JLabel global_stats_user_points = new JLabel("User's points: ", 11);
        this.global_stats_panel.add(global_stats_waiting_project);
        this.global_stats_panel.add(this.waiting_projects_value);
        this.global_stats_panel.add(global_stats_machine_connected);
        this.global_stats_panel.add(this.connected_machines_value);
        this.global_stats_panel.add(global_stats_remaining_frame);
        this.global_stats_panel.add(this.remainingFrameContent);
        this.global_stats_panel.add(global_stats_user_points);
        this.global_stats_panel.add(this.user_info_points_total_value);
        this.last_frame_panel = new CollapsibleJPanel((LayoutManager)new GridLayout(2, 2), this);
        this.last_frame_panel.setLayout(new BoxLayout(this.last_frame_panel, 1));
        this.last_frame_panel.setBorder(BorderFactory.createTitledBorder("Last uploaded frame"));
        this.lastRender.setIcon(new ImageIcon(new BufferedImage(200, 120, 2)));
        this.lastRender.setAlignmentX(0.5f);
        this.lastRenderTime.setAlignmentX(0.5f);
        this.last_frame_panel.add(this.lastRenderTime);
        this.last_frame_panel.add(this.lastRender);
        JLabel labelImage = GuiSwing.createLogoWithWatermark();
        labelImage.setAlignmentX(0.5f);
        this.parent.getContentPanel().add(labelImage);
        JPanel buttonsPanel = new JPanel(new GridLayout(2, 2));
        JButton settingsButton = new JButton("Settings");
        settingsButton.addActionListener(new SettingsAction());
        this.pauseButton = new JButton("Pause getting new jobs");
        Client client = this.parent.getClient();
        if (client != null && client.isSuspended()) {
            this.pauseButton.setText("Resume getting jobs");
        }
        this.pauseButton.addActionListener(new PauseAction());
        JButton blockJob = new JButton("Block this project");
        blockJob.addActionListener(new blockJobAction());
        this.exitAfterFrame = new JButton("Exit");
        ExitAfterAction exitAfterAction = new ExitAfterAction();
        this.exitAfterFrame.addActionListener(exitAfterAction);
        if (client != null && client.isAwaitingStop()) {
            exitAfterAction.finishJobBeforeExit(client, this.getJobsQueueSize(client));
        }
        buttonsPanel.add(settingsButton);
        buttonsPanel.add(this.pauseButton);
        buttonsPanel.add(blockJob);
        buttonsPanel.add(this.exitAfterFrame);
        this.parent.getContentPanel().setLayout(new GridBagLayout());
        GridBagConstraints global_constraints = new GridBagConstraints();
        global_constraints.fill = 2;
        global_constraints.weightx = 1.0;
        global_constraints.gridx = 0;
        this.parent.getContentPanel().add((Component)new JLabel(" "), global_constraints);
        this.parent.getContentPanel().add((Component)current_project_panel, global_constraints);
        this.parent.getContentPanel().add((Component)this.global_stats_panel, global_constraints);
        this.parent.getContentPanel().add((Component)this.session_info_panel, global_constraints);
        this.parent.getContentPanel().add((Component)this.last_frame_panel, global_constraints);
        this.parent.getContentPanel().add((Component)new JLabel(" "), global_constraints);
        this.parent.getContentPanel().add((Component)buttonsPanel, global_constraints);
        this.parent.setSize(540, 820);
    }

    @Override
    public void resizeWindow() {
        this.parent.revalidate();
        this.parent.repaint();
    }

    public void setStatus(String msg_) {
        this.setStatus(msg_, false);
    }

    public void setStatus(String msg_, boolean overwriteSuspendedMsg) {
        Client client = this.parent.getClient();
        if (!msg_.equals("")) {
            this.previousStatus = msg_;
        }
        if (client != null && client.isSuspended()) {
            if (overwriteSuspendedMsg) {
                this.statusContent.setText("<html>" + msg_ + "</html>");
            }
        } else {
            this.statusContent.setText("<html>" + msg_ + "</html>");
        }
    }

    public void setRenderingProjectName(String msg_) {
        this.current_project_name_value.setText("<html>" + (msg_.length() > 26 ? msg_.substring(0, 26) : msg_) + "</html>");
    }

    public void setRemainingTime(String time_) {
        this.currrent_project_progression_value.setText("<html>" + time_ + "</html>");
    }

    public void setRenderingTime(String time_) {
        this.current_project_duration_value.setText("<html>" + time_ + "</html>");
    }

    public void setComputeMethod(String computeMethod_) {
        this.current_project_compute_method_value.setText(computeMethod_);
    }

    public void displayTransferStats(TransferStats downloads, TransferStats uploads) {
        this.sessionDownloadsStatsValue.setText(String.format("%s @ %s/s", downloads.getSessionTraffic(), downloads.getAverageSessionSpeed()));
        this.sessionUploadsStatsValue.setText(String.format("%s @ %s/s", uploads.getSessionTraffic(), uploads.getAverageSessionSpeed()));
        this.updateTime();
    }

    public void displayStats(Stats stats) {
        DecimalFormat df = new DecimalFormat("##,##,##,##,##,##,##0");
        this.remainingFrameContent.setText(df.format(stats.getRemainingFrame()));
        this.creditEarned.setText(df.format(stats.getCreditsEarnedDuringSession()));
        this.user_info_points_total_value.setText(df.format(stats.getCreditsEarned()));
        this.renderable_projects_value.setText(df.format(stats.getRenderableProject()));
        this.waiting_projects_value.setText(df.format(stats.getWaitingProject()));
        this.connected_machines_value.setText(df.format(stats.getConnectedMachine()));
        this.updateTime();
    }

    public void displayUploadQueueStats(int queueSize, long queueVolume) {
        this.userInfoQueuedUploadsAndSizeValue.setText(String.format("%d%s%s", queueSize, queueSize > 0 ? String.format(" (%.2fMB) ", (double)queueVolume / 1024.0 / 1024.0) : "", queueSize == this.parent.getConfiguration().getMaxUploadingJob() ? "- Queue full!" : ""));
        if (this.exitAfterFrame.getText().startsWith("Cancel")) {
            Client client = this.parent.getClient();
            if (client != null && client.isRunning()) {
                ++queueSize;
            }
            this.exitAfterFrame.setText(String.format("Cancel exit (%s frame%s to go)", queueSize, queueSize > 1 ? "s" : ""));
        }
    }

    public synchronized void updateTime() {
        Job job;
        if (this.parent.getClient().getStartTime() != 0L) {
            this.user_info_total_rendertime_this_session_value.setText(Utils.humanDuration(new Date(new Date().getTime() - this.parent.getClient().getStartTime())));
        }
        if ((job = this.parent.getClient().getRenderingJob()) != null && job.getProcessRender() != null && job.getProcessRender().getStartTime() > 0L) {
            this.current_project_duration_value.setText("<html>" + Utils.humanDuration(new Date(new Date().getTime() - job.getProcessRender().getStartTime())) + "</html>");
        } else {
            this.current_project_duration_value.setText("");
        }
    }

    public void setRenderedFrame(int n) {
        this.renderedFrameContent.setText(String.valueOf(n));
        this.showLastRender();
    }

    public void showLastRender() {
        Job lastJob;
        Client client = this.parent.getClient();
        if (client != null && (lastJob = client.getPreviousJob()) != null) {
            ImageIcon icon = null;
            int idInt = Integer.parseInt(lastJob.getId());
            if (idInt == 1) {
                icon = new ImageIcon(this.getClass().getResource("/frame_compute_method.jpg"));
            } else if (idInt < 20) {
                icon = new ImageIcon(this.getClass().getResource("/frame_power_detection.jpg"));
            } else {
                String path = null;
                try {
                    boolean hasPreview = lastJob.getPreviewImagePath() != null;
                    path = hasPreview ? lastJob.getPreviewImagePath() : lastJob.getOutputImagePath();
                    BufferedImage img = ImageIO.read(new File(path));
                    float width = img.getWidth();
                    float height = img.getHeight();
                    float factor = 1.0f;
                    if (height > 200.0f) {
                        factor = 200.0f / height;
                    }
                    if (width * factor > 200.0f) {
                        factor = Math.min(factor, 200.0f / width);
                    }
                    icon = new ImageIcon(img.getScaledInstance((int)(width * factor), (int)(height * factor), 2));
                }
                catch (Exception e) {
                    this.log.error(String.format("Working::showLastRender() Unable to load/preview rendered frame [%s]. Exception %s", path, e.getMessage()));
                }
            }
            if (icon != null) {
                this.lastRender.setIcon(icon);
                if (lastJob.getProcessRender().getDuration() > 1) {
                    this.lastRenderTime.setText("Render time : " + Utils.humanDuration(new Date((long)lastJob.getProcessRender().getRenderDuration() * 1000L)));
                }
            }
        }
    }

    private void alignPanel(Container parent, int rows, int cols, Spring width) {
        int r;
        SpringLayout layout;
        try {
            layout = (SpringLayout)parent.getLayout();
        }
        catch (ClassCastException exc) {
            System.err.println("The first argument to makeCompactGrid must use SpringLayout.");
            return;
        }
        Spring x = Spring.constant(0);
        for (int c = 0; c < cols; ++c) {
            for (r = 0; r < rows; ++r) {
                SpringLayout.Constraints constraints = this.getConstraintsForCell(r, c, parent, cols);
                constraints.setX(x);
                constraints.setWidth(width);
            }
            x = Spring.sum(x, width);
        }
        Spring y = Spring.constant(0);
        for (r = 0; r < rows; ++r) {
            int c;
            Spring height = Spring.constant(0);
            for (c = 0; c < cols; ++c) {
                height = Spring.max(height, this.getConstraintsForCell(r, c, parent, cols).getHeight());
            }
            for (c = 0; c < cols; ++c) {
                SpringLayout.Constraints constraints = this.getConstraintsForCell(r, c, parent, cols);
                constraints.setY(y);
                constraints.setHeight(height);
            }
            y = Spring.sum(y, height);
        }
        SpringLayout.Constraints pCons = layout.getConstraints(parent);
        pCons.setConstraint("South", y);
        pCons.setConstraint("East", x);
    }

    private Spring getBestWidth(Container parent, int rows, int cols) {
        Spring x = Spring.constant(0);
        Spring width = Spring.constant(0);
        for (int c = 0; c < cols; ++c) {
            for (int r = 0; r < rows; ++r) {
                width = Spring.max(width, this.getConstraintsForCell(r, c, parent, cols).getWidth());
            }
        }
        return width;
    }

    private SpringLayout.Constraints getConstraintsForCell(int row, int col, Container parent, int cols) {
        SpringLayout layout = (SpringLayout)parent.getLayout();
        Component c = parent.getComponent(row * cols + col);
        return layout.getConstraints(c);
    }

    private int getJobsQueueSize(Client client) {
        return client.getUploadQueueSize() + (client.getRenderingJob() != null ? 1 : 0);
    }

    class blockJobAction
    implements ActionListener {
        blockJobAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Job job;
            Client client = Working.this.parent.getClient();
            if (client != null && (job = client.getRenderingJob()) != null) {
                job.block();
            }
        }
    }

    class ExitAfterAction
    implements ActionListener {
        ExitAfterAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Client client = Working.this.parent.getClient();
            if (client != null) {
                if (!client.isRunning() && !Objects.equals(e.getActionCommand(), Working.ACTION_CLOSE_WINDOW)) {
                    this.cancelExit(client);
                    return;
                }
                int jobsQueueSize = Working.this.getJobsQueueSize(client);
                if (jobsQueueSize == 0) {
                    int userDecision = this.showCloseDialogNoFrame();
                    if (userDecision == 0) {
                        this.exitImmediately(client);
                    }
                } else {
                    int userDecision = this.showCloseDialog(jobsQueueSize);
                    if (userDecision == 0) {
                        this.finishJobBeforeExit(client, jobsQueueSize);
                    } else if (userDecision == 1) {
                        this.exitImmediately(client);
                    }
                }
            }
        }

        public int showCloseDialogNoFrame() {
            Object[] exitJobOptions = new String[]{"Exit Immediately", "Do Nothing"};
            return JOptionPane.showOptionDialog(null, "Exit Now or Later", "Exit Now or Later", -1, 3, null, exitJobOptions, exitJobOptions[1]);
        }

        public int showCloseDialog(int jobsQueueSize) {
            Object[] exitJobOptions = new String[]{"Exit after current Jobs", "Exit Immediately", "Do Nothing"};
            return JOptionPane.showOptionDialog(null, String.format("<html>You have <strong>%d frame%s</strong> being uploaded or rendered. Do you want to finish the jobs or exit now?.\n\n", jobsQueueSize, jobsQueueSize > 1 ? "s" : "", jobsQueueSize > 1 ? jobsQueueSize + " " : "", jobsQueueSize > 1 ? "s" : ""), "Exit Now or Later", -1, 3, null, exitJobOptions, exitJobOptions[2]);
        }

        public void finishJobBeforeExit(Client client, int jobsQueueSize) {
            Working.this.exitAfterFrame.setText(String.format("Cancel exit (%s frame%s to go)", jobsQueueSize, jobsQueueSize > 1 ? "s" : ""));
            client.askForStop();
        }

        public void exitImmediately(Client client) {
            client.stop();
            System.exit(0);
        }

        public void cancelExit(Client client) {
            Working.this.exitAfterFrame.setText("Exit");
            client.cancelStop();
        }
    }

    class SettingsAction
    implements ActionListener {
        SettingsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (Working.this.parent != null) {
                Working.this.parent.showActivity(GuiSwing.ActivityType.SETTINGS);
            }
        }
    }

    class PauseAction
    implements ActionListener {
        PauseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Client client = Working.this.parent.getClient();
            if (client != null) {
                if (client.isSuspended()) {
                    Working.this.pauseButton.setText("Pause getting new jobs");
                    client.resume();
                    Working.this.setStatus(Working.this.previousStatus);
                } else {
                    Working.this.pauseButton.setText("Resume getting jobs");
                    client.suspend();
                    Working.this.setStatus("");
                }
            }
        }
    }
}

