/*
 * Decompiled with CFR 0.152.
 */
package com.sheepit.client.standalone.swing.components;

import com.sheepit.client.standalone.swing.activity.Activity;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class CollapsibleJPanel
extends JPanel {
    private boolean isCompnentsVisible = true;
    private int originalHeight;
    private String borderTitle = "";
    private int COLLAPSED_HEIGHT = 22;
    private boolean[] originalVisibilty;
    private Activity parent;

    public CollapsibleJPanel(LayoutManager layoutManager, Activity parent) {
        this.setLayout(layoutManager);
        this.addMouseListener(new onClickHandler());
        this.parent = parent;
    }

    public void setCollapsed(boolean aFlag) {
        if (aFlag) {
            this.hideComponents();
        } else {
            this.showComponents();
        }
    }

    public void toggleCollapsed() {
        if (this.isCompnentsVisible) {
            this.setCollapsed(true);
        } else {
            this.setCollapsed(false);
        }
    }

    private void hideComponents() {
        Component[] components = this.getComponents();
        this.originalVisibilty = new boolean[components.length];
        for (int i = 0; i < components.length; ++i) {
            this.originalVisibilty[i] = components[i].isVisible();
            components[i].setVisible(false);
        }
        this.setHeight(this.COLLAPSED_HEIGHT);
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " + " + this.borderTitle));
        this.isCompnentsVisible = false;
    }

    private void showComponents() {
        Component[] components = this.getComponents();
        for (int i = 0; i < components.length; ++i) {
            components[i].setVisible(this.originalVisibilty[i]);
        }
        this.setHeight(this.originalHeight);
        this.setBorder(BorderFactory.createTitledBorder(" - " + this.borderTitle));
        this.isCompnentsVisible = true;
    }

    private void setHeight(int height) {
        this.setPreferredSize(new Dimension(this.getPreferredSize().width, height));
        this.setMinimumSize(new Dimension(this.getMinimumSize().width, height));
        this.setMaximumSize(new Dimension(this.getMaximumSize().width, height));
    }

    @Override
    public Component add(Component component) {
        Component returnComponent = super.add(component);
        this.originalHeight = this.getPreferredSize().height;
        return returnComponent;
    }

    @Override
    public void setBorder(Border border) {
        if (border instanceof TitledBorder && this.borderTitle == "") {
            this.borderTitle = ((TitledBorder)border).getTitle();
            ((TitledBorder)border).setTitle(" - " + this.borderTitle);
        }
        super.setBorder(border);
    }

    public class onClickHandler
    implements MouseListener {
        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getPoint().y < CollapsibleJPanel.this.COLLAPSED_HEIGHT) {
                ((CollapsibleJPanel)e.getComponent()).toggleCollapsed();
            }
            CollapsibleJPanel.this.parent.resizeWindow();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }
}

