/*
 * Decompiled with CFR 0.152.
 */
package com.sheepit.client;

import com.sheepit.client.Log;
import com.sheepit.client.Pair;
import com.sheepit.client.datamodel.SpeedTestTarget;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.LongStream;

public class Speedtest {
    public static final int PORT = 443;
    private static final Comparator<SpeedTestTarget> ORDERED = Comparator.comparing(speedTestTarget -> speedTestTarget.getPing().getAverage());
    private Log log;

    public Speedtest(Log log) {
        this.log = log;
    }

    public List<SpeedTestTarget> doSpeedtests(List<String> urls2, int numberOfResults) {
        List pingResult = urls2.stream().map(this::measure).filter(target -> target.getPing().getAverage() > 0.0).sorted(ORDERED).collect(Collectors.toList());
        numberOfResults = Math.min(numberOfResults, urls2.size());
        ArrayList<SpeedTestTarget> result = new ArrayList<SpeedTestTarget>(numberOfResults);
        int i = 0;
        while (result.size() < numberOfResults && i < pingResult.size()) {
            SpeedTestTarget m = (SpeedTestTarget)pingResult.get(i);
            try {
                Pair<Long, Integer> speedtestResult = this.runTimed(() -> this.speedtest(m.getUrl()));
                m.setSpeedtest(Math.round((double)((Integer)speedtestResult.second).intValue() / ((double)((Long)speedtestResult.first).longValue() / 1000.0)));
            }
            catch (Exception e) {
                this.log.error("Speedtest::doSpeedtests Exception " + e);
                ++i;
                continue;
            }
            result.add(m);
            ++i;
        }
        result.sort(Comparator.comparing(SpeedTestTarget::getSpeedtest).reversed());
        return result;
    }

    private SpeedTestTarget measure(String mirror) {
        long pingCount = 12L;
        LongStream.Builder streamBuilder = LongStream.builder();
        int i = 0;
        while ((long)i < pingCount) {
            try {
                streamBuilder.add((Long)this.runTimed((Callable<Integer>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$measure$3(java.lang.String ), ()Ljava/lang/Integer;)((String)mirror)).first);
            }
            catch (Exception e) {
                this.log.error("Speedtest::ping Exception " + e);
                pingCount /= 2L;
                streamBuilder.add(Long.MAX_VALUE);
            }
            ++i;
        }
        LongSummaryStatistics pingStatistics = streamBuilder.build().summaryStatistics();
        return new SpeedTestTarget(mirror, -1L, pingStatistics);
    }

    private <T> Pair<Long, T> runTimed(Callable<T> task) throws Exception {
        long start = System.nanoTime();
        T callValue = task.call();
        long end = System.nanoTime();
        return new Pair<Long, T>(Duration.ofNanos(end - start).toMillis(), callValue);
    }

    private int speedtest(String url) {
        int n;
        block9: {
            InputStream stream = new URL(url).openStream();
            try {
                n = stream.readAllBytes().length;
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException("Invalid speedtest URL: " + url, e);
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to execute speedtest to: " + url, e);
                }
            }
            stream.close();
        }
        return n;
    }

    private static int ping(String url, int port) {
        InetAddress mirrorIP = null;
        try (Socket socket = new Socket();){
            mirrorIP = InetAddress.getByName(new URL(url).getHost());
            InetSocketAddress socketAddress = new InetSocketAddress(mirrorIP, port);
            int maxWaitingTime_ms = 3000;
            socket.connect(socketAddress, maxWaitingTime_ms);
        }
        catch (IOException e) {
            String problemURL = mirrorIP != null ? mirrorIP + " (derived from: " + url + ")" : url;
            throw new RuntimeException("Unable to connect to " + problemURL, e);
        }
        return -1;
    }

    private static /* synthetic */ Integer lambda$measure$3(String mirror) throws Exception {
        return Speedtest.ping(mirror, 443);
    }
}

