/*
 * Decompiled with CFR 0.152.
 */
package com.sheepit.client.standalone;

import com.sheepit.client.Client;
import com.sheepit.client.Gui;
import com.sheepit.client.Stats;
import com.sheepit.client.TransferStats;
import com.sheepit.client.standalone.text.CLIInputActionHandler;
import com.sheepit.client.standalone.text.CLIInputObserver;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class GuiTextOneLine
implements Gui {
    public static final String type = "oneLine";
    private String project = "";
    private int rendered = 0;
    private int remaining = 0;
    private String creditsEarned = null;
    private int sigIntCount = 0;
    private DateFormat df = new SimpleDateFormat("MMM dd HH:mm:ss");
    private String computeMethod = "";
    private String status = "";
    private String line = "";
    private String eta = "";
    private int uploadQueueSize = 0;
    private long uploadQueueVolume = 0L;
    private boolean exiting = false;
    private Client client;

    @Override
    public void start() {
        if (this.client != null) {
            CLIInputObserver cli_input_observer = new CLIInputObserver(this.client);
            cli_input_observer.addListener(new CLIInputActionHandler());
            Thread cli_input_observer_thread = new Thread(cli_input_observer);
            cli_input_observer_thread.start();
            Signal.handle(new Signal("INT"), new SignalHandler(){

                @Override
                public void handle(Signal signal) {
                    ++GuiTextOneLine.this.sigIntCount;
                    if (GuiTextOneLine.this.sigIntCount == 5) {
                        Signal.raise(new Signal("INT"));
                        Runtime.getRuntime().halt(0);
                    } else if (GuiTextOneLine.this.client.isRunning() && !GuiTextOneLine.this.client.isSuspended()) {
                        GuiTextOneLine.this.client.askForStop();
                        GuiTextOneLine.this.exiting = true;
                    } else {
                        GuiTextOneLine.this.client.stop();
                        GuiTextOneLine.this.stop();
                    }
                }
            });
            this.client.run();
            this.client.stop();
        }
        this.stop();
    }

    @Override
    public void stop() {
        Runtime.getRuntime().halt(0);
    }

    @Override
    public void updateTrayIcon(Integer percentage) {
    }

    @Override
    public void status(String msg_) {
        this.status(msg_, false);
    }

    @Override
    public void status(String msg_, boolean overwriteSuspendedMsg) {
        if (this.client != null && this.client.isSuspended()) {
            if (overwriteSuspendedMsg) {
                this.status = msg_;
                this.updateLine();
            }
        } else {
            this.status = msg_;
            this.updateLine();
        }
    }

    @Override
    public void status(String msg, int progress) {
        this.status(msg, progress, 0L);
    }

    @Override
    public void status(String msg, int progress, long size) {
        this.status = this.showProgress(msg, progress, size);
        this.updateLine();
    }

    @Override
    public void setRenderingProjectName(String name_) {
        this.project = name_ == null || name_.isEmpty() ? "" : name_ + " |";
        this.updateLine();
    }

    @Override
    public void error(String msg_) {
        this.status = "Error " + msg_;
        this.updateLine();
    }

    @Override
    public void AddFrameRendered() {
        ++this.rendered;
        this.updateLine();
    }

    @Override
    public synchronized void displayTransferStats(TransferStats downloads, TransferStats uploads) {
    }

    @Override
    public void displayStats(Stats stats) {
        this.remaining = stats.getRemainingFrame();
        this.creditsEarned = String.valueOf(stats.getCreditsEarnedDuringSession());
        this.updateLine();
    }

    @Override
    public void displayUploadQueueStats(int queueSize, long queueVolume) {
        this.uploadQueueSize = queueSize;
        this.uploadQueueVolume = queueVolume;
    }

    @Override
    public void setRemainingTime(String time_) {
        this.eta = time_;
        this.updateLine();
    }

    @Override
    public void setRenderingTime(String time_) {
        this.status = "Rendering " + time_;
        this.updateLine();
    }

    @Override
    public void setClient(Client cli) {
        this.client = cli;
    }

    @Override
    public void setComputeMethod(String computeMethod_) {
        this.computeMethod = computeMethod_;
    }

    @Override
    public Client getClient() {
        return this.client;
    }

    @Override
    public void successfulAuthenticationEvent(String publickey) {
    }

    private void updateLine() {
        int charToRemove = this.line.length();
        System.out.print("\r");
        this.line = String.format("%s Frames: %d Points: %s | Upload Queue: %d%s | %%s %s %s", this.df.format(new Date()), this.rendered, this.creditsEarned != null ? this.creditsEarned : "unknown", this.uploadQueueSize, this.uploadQueueSize > 0 ? String.format(" (%.2fMB)", (double)this.uploadQueueVolume / 1024.0 / 1024.0) : "", this.computeMethod, this.status + (this.exiting ? " (Exiting after all frames are uploaded)" : ""));
        if (this.line.length() + this.project.length() > 120) {
            int lineLength = Math.min(this.line.length(), 117);
            this.line = String.format(this.line, this.project.substring(0, 117 - lineLength) + "...");
        } else {
            this.line = String.format(this.line, this.project);
        }
        System.out.print(this.line);
        for (int i = this.line.length(); i <= charToRemove; ++i) {
            System.out.print(" ");
        }
    }

    private String showProgress(String message, int progress, long size) {
        StringBuilder progressBar = new StringBuilder(140);
        progressBar.append(message).append(String.join((CharSequence)"", Collections.nCopies(progress == 0 ? 2 : 2 - (int)Math.log10(progress), " "))).append(String.format(" %d%%%% [", progress)).append(String.join((CharSequence)"", Collections.nCopies(progress / 10, "="))).append('>').append(String.join((CharSequence)"", Collections.nCopies(10 - progress / 10, " "))).append(']');
        if (size > 0L) {
            progressBar.append(String.format(" %dMB", size / 1024L / 1024L));
        }
        if (!this.eta.equals("")) {
            progressBar.append(String.format(" ETA %s", this.eta));
        }
        return progressBar.toString();
    }
}

