/*
 * Decompiled with CFR 0.152.
 */
package com.sheepit.client.standalone.text;

import com.sheepit.client.Client;
import com.sheepit.client.standalone.text.CLIInputListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class CLIInputObserver
implements Runnable {
    private BufferedReader in;
    private Client client;
    private List<CLIInputListener> listeners = new ArrayList<CLIInputListener>();

    public CLIInputObserver(Client client) {
        this.client = client;
    }

    public void addListener(CLIInputListener toAdd) {
        this.listeners.add(toAdd);
    }

    @Override
    public void run() {
        this.in = new BufferedReader(new InputStreamReader(System.in));
        String line = "";
        while (line != null && !line.equalsIgnoreCase("quit")) {
            try {
                line = this.in.readLine();
            }
            catch (IOException e) {
                this.client.getLog().info("Unable to read user input, ignoring all further inputs");
                break;
            }
            for (CLIInputListener cliil : this.listeners) {
                cliil.commandEntered(this.client, line);
            }
        }
        try {
            this.in.close();
        }
        catch (Exception e) {
            this.client.getLog().error("FIXME: Unhandled exception while closing InputStreamReader(): " + e);
        }
    }
}

