/*
 * Decompiled with CFR 0.152.
 */
package com.sheepit.client.standalone;

import com.formdev.flatlaf.FlatDarkLaf;
import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.FlatLightLaf;
import com.sheepit.client.Client;
import com.sheepit.client.Configuration;
import com.sheepit.client.Gui;
import com.sheepit.client.SettingsLoader;
import com.sheepit.client.Stats;
import com.sheepit.client.TransferStats;
import com.sheepit.client.standalone.swing.activity.Settings;
import com.sheepit.client.standalone.swing.activity.Working;
import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.RenderingHints;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Timer;
import java.util.TimerTask;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;

public class GuiSwing
extends JFrame
implements Gui {
    public static final String type = "swing";
    private static final String logoPath = "/sheepit-logo.png";
    public static final int WIDTH = 540;
    private SystemTray sysTray;
    private JPanel panel;
    private Working activityWorking;
    private Settings activitySettings;
    private TrayIcon trayIcon;
    private boolean useSysTray;
    private String title;
    private int framesRendered = 0;
    private boolean waitingForAuthentication;
    private Client client;
    private BufferedImage iconSprites;
    private BufferedImage[] trayIconSprites;
    private SettingsLoader settingsLoader;
    private ThreadClient threadClient;

    public static void drawVersionStringOnImage(BufferedImage image, String versionString) {
        int watermarkWidth = image.getWidth();
        int watermarkHeight = image.getHeight();
        Graphics2D gph = (Graphics2D)image.getGraphics();
        gph.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        gph.setFont(gph.getFont().deriveFont(12.0f));
        FontMetrics fontMetrics = gph.getFontMetrics();
        int x = watermarkWidth - fontMetrics.stringWidth(versionString);
        int y = watermarkHeight - fontMetrics.getMaxDescent();
        gph.drawString(versionString, x, y);
        gph.dispose();
    }

    @NotNull
    public static JLabel createLogoWithWatermark() {
        JLabel labelImage;
        URL logoURL = GuiSwing.class.getResource(logoPath);
        if (logoURL == null) {
            System.err.println("Error: Unable to find logo /sheepit-logo.png");
            return new JLabel();
        }
        try {
            BufferedImage watermark = ImageIO.read(logoURL);
            String versionString = "v" + Configuration.jarVersion;
            GuiSwing.drawVersionStringOnImage(watermark, versionString);
            labelImage = new JLabel(new ImageIcon(watermark));
        }
        catch (Exception e) {
            ImageIcon image = new ImageIcon(logoURL);
            labelImage = new JLabel(image);
        }
        return labelImage;
    }

    public GuiSwing(boolean useSysTray_, String title_) {
        this.useSysTray = useSysTray_;
        this.title = title_;
        this.waitingForAuthentication = true;
        new Timer().scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (GuiSwing.this.activityWorking != null) {
                    GuiSwing.this.activityWorking.updateTime();
                }
            }
        }, 2000L, 2000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        URL spriteSequenceUrl;
        if (this.useSysTray) {
            try {
                this.sysTray = SystemTray.getSystemTray();
                if (SystemTray.isSupported()) {
                    this.addWindowStateListener(new WindowStateListener(){

                        @Override
                        public void windowStateChanged(WindowEvent e) {
                            if (e.getNewState() == 1) {
                                GuiSwing.this.hideToTray();
                            }
                        }
                    });
                }
            }
            catch (UnsupportedOperationException e) {
                this.sysTray = null;
            }
        }
        if ((spriteSequenceUrl = this.getClass().getResource("/icon-sprites.png")) != null) {
            try {
                this.iconSprites = ImageIO.read(spriteSequenceUrl);
                this.trayIconSprites = new BufferedImage[101];
                this.setIconImage(this.extractImageFromSprite(-1));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.setTitle(this.title);
        this.setSize(540, 760);
        this.setDefaultCloseOperation(3);
        this.panel = new JPanel();
        this.panel.setLayout(new GridBagLayout());
        Dimension panelPrefSize = new Dimension(this.getSize().width - 20, this.getSize().height);
        this.panel.setPreferredSize(panelPrefSize);
        JScrollPane scrollPane = new JScrollPane(this.panel);
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.getVerticalScrollBar().setPreferredSize(new Dimension(13, 0));
        scrollPane.getHorizontalScrollBar().setPreferredSize(new Dimension(0, 13));
        scrollPane.getVerticalScrollBar().setUnitIncrement(50);
        scrollPane.getHorizontalScrollBar().setUnitIncrement(50);
        this.setContentPane(scrollPane);
        this.panel.setBorder(new EmptyBorder(20, 20, 20, 20));
        this.activityWorking = new Working(this);
        this.activitySettings = new Settings(this);
        this.showActivity(ActivityType.SETTINGS);
        try {
            if (this.client.getConfiguration().getTheme().equals("light")) {
                UIManager.setLookAndFeel(new FlatLightLaf());
            } else if (this.client.getConfiguration().getTheme().equals("dark")) {
                UIManager.setLookAndFeel(new FlatDarkLaf());
            }
            SwingUtilities.invokeAndWait(() -> FlatLaf.updateUI());
        }
        catch (UnsupportedLookAndFeelException e1) {
            e1.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        while (this.waitingForAuthentication) {
            try {
                GuiSwing e = this;
                synchronized (e) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void stop() {
        System.exit(0);
    }

    @Override
    public void status(String msg_) {
        this.status(msg_, false);
    }

    @Override
    public void status(String msg_, boolean overwriteSuspendedMsg) {
        if (this.activityWorking != null) {
            this.activityWorking.setStatus(msg_, overwriteSuspendedMsg);
        }
    }

    @Override
    public void status(String msg, int progress) {
        if (this.activityWorking != null) {
            this.activityWorking.setStatus(String.format("%s %d%%", msg, progress));
        }
    }

    @Override
    public void status(String msg, int progress, long size) {
        this.status(msg, progress);
    }

    @Override
    public void setRenderingProjectName(String name_) {
        if (this.activityWorking != null) {
            this.activityWorking.setRenderingProjectName(name_);
        }
    }

    @Override
    public void error(String msg_) {
        this.status(msg_, true);
    }

    @Override
    public void setRemainingTime(String time_) {
        if (this.activityWorking != null) {
            this.activityWorking.setRemainingTime(time_);
        }
    }

    @Override
    public void setRenderingTime(String time_) {
        if (this.activityWorking != null) {
            this.activityWorking.setRenderingTime(time_);
        }
    }

    @Override
    public synchronized void displayTransferStats(TransferStats downloads, TransferStats uploads) {
        this.activityWorking.displayTransferStats(downloads, uploads);
    }

    @Override
    public void AddFrameRendered() {
        ++this.framesRendered;
        if (this.activityWorking != null) {
            this.activityWorking.setRenderedFrame(this.framesRendered);
        } else {
            System.out.println("GuiSwing::AddFrameRendered() error: no working activity");
        }
    }

    @Override
    public void displayStats(Stats stats) {
        if (this.activityWorking != null) {
            this.activityWorking.displayStats(stats);
        }
    }

    @Override
    public void displayUploadQueueStats(int queueSize, long queueVolume) {
        if (this.activityWorking != null) {
            this.activityWorking.displayUploadQueueStats(queueSize, queueVolume);
        }
    }

    @Override
    public Client getClient() {
        return this.client;
    }

    @Override
    public void setClient(Client cli) {
        this.client = cli;
    }

    @Override
    public void setComputeMethod(String computeMethod) {
        this.activityWorking.setComputeMethod(computeMethod);
    }

    public Configuration getConfiguration() {
        return this.client.getConfiguration();
    }

    @Override
    public void successfulAuthenticationEvent(String publickey) {
        if (this.settingsLoader != null) {
            if (publickey != null && !this.settingsLoader.getLogin().isLaunchCommand()) {
                this.settingsLoader.getPassword().setValue(publickey);
            }
            this.settingsLoader.saveFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCredentials(String contentLogin, String contentPassword) {
        this.client.getConfiguration().setLogin(contentLogin);
        this.client.getConfiguration().setPassword(contentPassword);
        this.waitingForAuthentication = false;
        GuiSwing guiSwing = this;
        synchronized (guiSwing) {
            this.notifyAll();
        }
        if (this.threadClient == null || !this.threadClient.isAlive()) {
            this.threadClient = new ThreadClient();
            this.threadClient.start();
        }
        this.showActivity(ActivityType.WORKING);
    }

    public void showActivity(ActivityType type) {
        this.panel.removeAll();
        this.panel.doLayout();
        if (type == ActivityType.WORKING) {
            this.activityWorking.show();
        } else if (type == ActivityType.SETTINGS) {
            this.activitySettings.show();
        }
        this.setVisible(true);
        this.panel.repaint();
    }

    public void hideToTray() {
        if (this.sysTray == null || !SystemTray.isSupported()) {
            System.out.println("GuiSwing::hideToTray SystemTray not supported!");
            return;
        }
        try {
            this.trayIcon = this.getTrayIcon();
            this.sysTray.add(this.trayIcon);
        }
        catch (AWTException e) {
            System.out.println("GuiSwing::hideToTray an error occured while trying to add system tray icon (exception: " + e + ")");
            return;
        }
        this.setVisible(false);
    }

    public void restoreFromTray() {
        if (this.sysTray != null && SystemTray.isSupported()) {
            this.sysTray.remove(this.trayIcon);
            this.setVisible(true);
            this.setExtendedState(this.getExtendedState() & 0xFFFFFFFE & 0);
            this.toFront();
            this.requestFocus();
        }
    }

    public TrayIcon getTrayIcon() {
        PopupMenu trayMenu = new PopupMenu();
        Image img = this.extractImageFromSprite(-1);
        TrayIcon icon = new TrayIcon(img);
        MenuItem exit = new MenuItem("Exit");
        exit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        trayMenu.add(exit);
        MenuItem open = new MenuItem("Open...");
        open.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiSwing.this.restoreFromTray();
            }
        });
        trayMenu.add(open);
        MenuItem settings = new MenuItem("Settings...");
        settings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiSwing.this.restoreFromTray();
                GuiSwing.this.showActivity(ActivityType.SETTINGS);
            }
        });
        trayMenu.add(settings);
        icon.setPopupMenu(trayMenu);
        icon.setImageAutoSize(true);
        icon.setToolTip("SheepIt! Client");
        icon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiSwing.this.restoreFromTray();
            }
        });
        return icon;
    }

    public JPanel getContentPanel() {
        return this.panel;
    }

    private Image extractImageFromSprite(int spriteNumber) {
        ImageIcon img = new ImageIcon(this.iconSprites.getSubimage(0, (spriteNumber + 1) * 114, 114, 114));
        return img.getImage();
    }

    @Override
    public void updateTrayIcon(Integer percentage) {
        Image img = this.extractImageFromSprite(percentage);
        this.setIconImage(img);
        if (this.sysTray != null && SystemTray.isSupported() && this.trayIcon != null) {
            this.trayIcon.setImage(img);
            this.trayIcon.setImageAutoSize(true);
        }
    }

    public SettingsLoader getSettingsLoader() {
        return this.settingsLoader;
    }

    public void setSettingsLoader(SettingsLoader settingsLoader) {
        this.settingsLoader = settingsLoader;
    }

    public class ThreadClient
    extends Thread {
        @Override
        public void run() {
            if (GuiSwing.this.client != null) {
                GuiSwing.this.client.run();
            }
        }
    }

    public static enum ActivityType {
        WORKING,
        SETTINGS;

    }
}

