/*
 * Decompiled with CFR 0.152.
 */
package com.sheepit.client.os;

import com.sheepit.client.Log;
import com.sheepit.client.os.OS;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Linux
extends OS {
    private final String NICE_BINARY_PATH = "nice";
    private final String ID_COMMAND_INVOCATION = "id -u";

    @Override
    public String name() {
        return "linux";
    }

    @Override
    public String getRenderBinaryPath() {
        return "rend.exe";
    }

    @Override
    public String getCUDALib() {
        return "cuda";
    }

    @Override
    public String getNVMLLib() {
        return "nvidia-ml";
    }

    @Override
    public Process exec(List<String> command, Map<String, String> env_overight) throws IOException {
        HashMap<String, Object> new_env = new HashMap<String, Object>();
        new_env.putAll(System.getenv());
        if (!this.isOpenGLAlreadyInstalled(command.get(0))) {
            Boolean has_ld_library_path = new_env.containsKey("LD_LIBRARY_PATH");
            String lib_dir = new File(command.get(0)).getParent() + File.separator + "lib";
            if (!has_ld_library_path.booleanValue()) {
                new_env.put("LD_LIBRARY_PATH", lib_dir);
            } else {
                new_env.put("LD_LIBRARY_PATH", (String)new_env.get("LD_LIBRARY_PATH") + ":" + lib_dir);
            }
        }
        List<String> actual_command = command;
        if (this.isNiceAvailable()) {
            if (env_overight != null) {
                actual_command.add(0, env_overight.get("PRIORITY"));
            } else {
                actual_command.add(0, "19");
            }
            actual_command.add(0, "-n");
            actual_command.add(0, "nice");
        } else {
            Log.getInstance(null).error("No low priority binary, will not launch renderer in normal priority");
        }
        ProcessBuilder builder = new ProcessBuilder(actual_command);
        builder.redirectErrorStream(true);
        Map<String, String> env = builder.environment();
        env.putAll(new_env);
        if (env_overight != null) {
            env.putAll(env_overight);
        }
        return builder.start();
    }

    @Override
    public boolean isSupported() {
        String arch = System.getProperty("os.arch").toLowerCase();
        return super.isSupported() && ("amd64".equals(arch) || "x64".equals(arch) || "x86_64".equals(arch));
    }

    @Override
    public boolean isHighPrioritySupported() {
        try {
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            builder.command("bash", "-c", "id -u");
            builder.redirectErrorStream(true);
            Process process = builder.start();
            InputStream is = process.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            String userLevel = null;
            userLevel = reader.readLine();
            if (userLevel != null) {
                return userLevel.equals("0") & this.isNiceAvailable();
            }
        }
        catch (IOException e) {
            System.err.println(String.format("ERROR Linux::getSupportHighPriority Unable to execute id command. IOException %s", e.getMessage()));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isNiceAvailable() {
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.command("nice");
        builder.redirectErrorStream(true);
        Process process = null;
        boolean hasNiceBinary = false;
        try {
            process = builder.start();
            hasNiceBinary = true;
        }
        catch (IOException e) {
            Log.getInstance(null).error("Failed to find low priority binary, will not launch renderer in normal priority (" + e + ")");
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
        return hasNiceBinary;
    }

    protected boolean isOpenGLAlreadyInstalled(String pathToRendEXE) {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.command("bash", "-c", "ldd '" + pathToRendEXE + "'");
        processBuilder.redirectErrorStream(true);
        try {
            String line;
            Process process = processBuilder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            StringBuilder screenOutput = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                if (line.toLowerCase().contains("libgl.so")) {
                    return !line.toLowerCase().contains("not found");
                }
                screenOutput.append(line);
            }
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                System.err.println(String.format("ERROR Linux::isOpenGLAlreadyInstalled Unable to execute ldd command. Exit code %d", exitCode));
                System.err.println(String.format("Screen output from ldd execution: %s", screenOutput.toString()));
            }
        }
        catch (IOException e) {
            System.err.println(String.format("ERROR Linux::isOpenGLAreadyInstalled Unable to execute ldd command. IOException %s", e.getMessage()));
        }
        catch (InterruptedException e) {
            System.err.println(String.format("ERROR Linux::isOpenGLAreadyInstalled Unable to execute ldd command. InterruptedException %s", e.getMessage()));
        }
        return false;
    }

    @Override
    public void shutdownComputer(int delayInMinutes) {
        try {
            ProcessBuilder builder = new ProcessBuilder("shutdown", "-h", String.valueOf(delayInMinutes));
            Process process = builder.inheritIO().start();
        }
        catch (IOException e) {
            System.err.println(String.format("Linux::shutdownComputer Unable to execute the 'shutdown -h 1' command. Exception %s", e.getMessage()));
        }
    }
}

