/*
 * Decompiled with CFR 0.152.
 */
package com.sheepit.client;

import com.sheepit.client.Configuration;
import com.sheepit.client.Option;
import com.sheepit.client.Utils;
import com.sheepit.client.hardware.gpu.GPU;
import com.sheepit.client.hardware.gpu.GPUDevice;
import com.sheepit.client.os.OS;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;

public class SettingsLoader {
    public static final String ARG_SERVER = "-server";
    public static final String ARG_LOGIN = "-login";
    public static final String ARG_PASSWORD = "-password";
    public static final String ARG_CACHE_DIR = "-cache-dir";
    public static final String ARG_SHARED_ZIP = "-shared-zip";
    public static final String ARG_GPU = "-gpu";
    public static final String ARG_NO_GPU = "--no-gpu";
    public static final String ARG_COMPUTE_METHOD = "-compute-method";
    public static final String ARG_CORES = "-cores";
    public static final String ARG_MEMORY = "-memory";
    public static final String ARG_RENDERTIME = "-rendertime";
    public static final String ARG_VERBOSE = "--verbose";
    public static final String ARG_REQUEST_TIME = "-request-time";
    public static final String ARG_SHUTDOWN = "-shutdown";
    public static final String ARG_SHUTDOWN_MODE = "-shutdown-mode";
    public static final String ARG_PROXY = "-proxy";
    public static final String ARG_EXTRAS = "-extras";
    public static final String ARG_UI = "-ui";
    public static final String ARG_CONFIG = "-config";
    public static final String ARG_VERSION = "--version";
    public static final String ARG_SHOW_GPU = "--show-gpu";
    public static final String ARG_NO_SYSTRAY = "--no-systray";
    public static final String ARG_PRIORITY = "-priority";
    public static final String ARG_TITLE = "-title";
    public static final String ARG_THEME = "-theme";
    public static final String ARG_HOSTNAME = "-hostname";
    public static final String ARG_HEADLESS = "--headless";
    private String path;
    private Option<String> login;
    private Option<String> password;
    private Option<String> proxy;
    private Option<String> hostname;
    private Option<String> computeMethod;
    private Option<String> gpu;
    private Option<String> cores;
    private Option<String> ram;
    private Option<String> renderTime;
    private Option<String> cacheDir;
    private Option<String> sharedZip;
    private Option<String> autoSignIn;
    private Option<String> useSysTray;
    private Option<String> headless;
    private Option<String> ui;
    private Option<String> theme;
    private Option<Integer> priority;

    public SettingsLoader(String path_) {
        this.path = path_ == null ? OS.getOS().getDefaultConfigFilePath() : path_;
    }

    public void setSettings(String path_, String login_, String password_, String proxy_, String hostname_, Configuration.ComputeType computeMethod_, GPUDevice gpu_, Integer cores_, Long maxRam_, Integer maxRenderTime_, String cacheDir_, String sharedZip_, Boolean autoSignIn_, Boolean useSysTray_, Boolean isHeadless, String ui_, String theme_, Integer priority_) {
        this.path = path_ == null ? OS.getOS().getDefaultConfigFilePath() : path_;
        this.login = this.setValue(login_, this.login, ARG_LOGIN);
        this.password = this.setValue(password_, this.password, ARG_PASSWORD);
        this.proxy = this.setValue(proxy_, this.proxy, ARG_PROXY);
        this.hostname = this.setValue(hostname_, this.hostname, ARG_HOSTNAME);
        this.cacheDir = this.setValue(cacheDir_, this.cacheDir, ARG_CACHE_DIR);
        this.sharedZip = this.setValue(sharedZip_, this.sharedZip, ARG_SHARED_ZIP);
        this.autoSignIn = this.setValue(autoSignIn_.toString(), this.autoSignIn, "");
        this.useSysTray = this.setValue(useSysTray_.toString(), this.useSysTray, ARG_NO_SYSTRAY);
        this.headless = this.setValue(isHeadless.toString(), this.headless, ARG_HEADLESS);
        this.ui = this.setValue(ui_, this.ui, ARG_UI);
        this.priority = this.setValue(priority_, this.priority, ARG_PRIORITY);
        this.theme = this.setValue(theme_, this.theme, ARG_THEME);
        if (cores_ > 0) {
            this.cores = this.setValue(cores_.toString(), this.cores, ARG_CORES);
        }
        if (maxRam_ > 0L) {
            this.ram = this.setValue(maxRam_ + "k", this.ram, ARG_MEMORY);
        }
        if (maxRenderTime_ > 0) {
            this.renderTime = this.setValue(maxRenderTime_.toString(), this.renderTime, ARG_RENDERTIME);
        }
        if (computeMethod_ != null) {
            try {
                this.computeMethod = this.setValue(computeMethod_.name(), this.computeMethod, ARG_COMPUTE_METHOD);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (gpu_ != null) {
            this.gpu = this.setValue(gpu_.getId(), this.gpu, ARG_GPU);
        }
    }

    private <T> Option<T> setValue(T value, Option<T> option, String launchFlag) {
        if (option == null && value != null) {
            option = new Option<T>(value, launchFlag);
        } else if (value != null) {
            option.setValue(value);
        }
        return option;
    }

    public String getFilePath() {
        return this.path;
    }

    public void markLaunchSettings(List<String> argsList) {
        Option[] options;
        for (Option option : options = new Option[]{this.login, this.password, this.proxy, this.hostname, this.computeMethod, this.gpu, this.cores, this.ram, this.renderTime, this.cacheDir, this.sharedZip, this.autoSignIn, this.useSysTray, this.headless, this.ui, this.theme, this.priority}) {
            if (option == null || !argsList.contains(option.getLaunchFlag())) continue;
            option.setLaunchCommand(true);
        }
    }

    private void setProperty(Properties saveTo, Properties configFileProperties, PropertyNames property, Option<String> option) {
        if (option != null) {
            if (option.isLaunchCommand()) {
                String configValue = configFileProperties.getProperty(property.propertyName);
                if (configValue != null) {
                    saveTo.setProperty(property.propertyName, configValue);
                }
            } else {
                saveTo.setProperty(property.propertyName, option.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveFile() {
        Properties configFileProp = new Properties();
        if (new File(this.path).exists()) {
            FileInputStream input = null;
            try {
                input = new FileInputStream(this.path);
                configFileProp.load(input);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Properties prop = new Properties();
        FileOutputStream output = null;
        try {
            output = new FileOutputStream(this.path);
            this.setProperty(prop, configFileProp, PropertyNames.PRIORITY, new Option<String>(this.priority != null ? this.priority.getValue().toString() : null, this.priority.isLaunchCommand(), ARG_PRIORITY));
            this.setProperty(prop, configFileProp, PropertyNames.CACHE_DIR, this.cacheDir);
            this.setProperty(prop, configFileProp, PropertyNames.SHARED_ZIP, this.sharedZip);
            this.setProperty(prop, configFileProp, PropertyNames.COMPUTE_METHOD, this.computeMethod);
            this.setProperty(prop, configFileProp, PropertyNames.GPU, this.gpu);
            this.setProperty(prop, configFileProp, PropertyNames.CORES, this.cores);
            this.setProperty(prop, configFileProp, PropertyNames.RAM, this.ram);
            this.setProperty(prop, configFileProp, PropertyNames.RENDER_TIME, this.renderTime);
            this.setProperty(prop, configFileProp, PropertyNames.LOGIN, this.login);
            this.setProperty(prop, configFileProp, PropertyNames.PASSWORD, this.password);
            this.setProperty(prop, configFileProp, PropertyNames.PROXY, this.proxy);
            this.setProperty(prop, configFileProp, PropertyNames.HOSTNAME, this.hostname);
            this.setProperty(prop, configFileProp, PropertyNames.AUTO_SIGNIN, this.autoSignIn);
            this.setProperty(prop, configFileProp, PropertyNames.USE_SYSTRAY, this.useSysTray);
            this.setProperty(prop, configFileProp, PropertyNames.HEADLESS, this.headless);
            this.setProperty(prop, configFileProp, PropertyNames.UI, this.ui);
            this.setProperty(prop, configFileProp, PropertyNames.THEME, this.theme);
            prop.store(output, null);
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        finally {
            if (output != null) {
                try {
                    ((OutputStream)output).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
        perms.add(PosixFilePermission.OWNER_READ);
        perms.add(PosixFilePermission.OWNER_WRITE);
        try {
            Files.setPosixFilePermissions(Paths.get(this.path, new String[0]), perms);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Option<String> loadConfigOption(Properties config, PropertyNames property, Option<String> option, String launchFlag) {
        if (config.containsKey(property.propertyName)) {
            String configValue = config.getProperty(property.propertyName);
            if (option == null && configValue != null) {
                option = new Option<String>(configValue, launchFlag);
            } else if (configValue != null) {
                option.setValue(configValue);
            }
        }
        return option;
    }

    public void loadFile(boolean initialize) throws Exception {
        if (initialize) {
            this.initWithDefaults();
        }
        if (!new File(this.path).exists()) {
            return;
        }
        Properties prop = new Properties();
        FileInputStream input = null;
        try {
            input = new FileInputStream(this.path);
            prop.load(input);
            this.cacheDir = this.loadConfigOption(prop, PropertyNames.CACHE_DIR, this.cacheDir, ARG_CACHE_DIR);
            this.sharedZip = this.loadConfigOption(prop, PropertyNames.SHARED_ZIP, this.sharedZip, ARG_SHARED_ZIP);
            this.computeMethod = this.loadConfigOption(prop, PropertyNames.COMPUTE_METHOD, this.computeMethod, ARG_COMPUTE_METHOD);
            this.gpu = this.loadConfigOption(prop, PropertyNames.GPU, this.gpu, ARG_GPU);
            this.cores = this.loadConfigOption(prop, PropertyNames.CORES_BACKWARDS_COMPAT, this.cores, ARG_CORES);
            this.cores = this.loadConfigOption(prop, PropertyNames.CORES, this.cores, ARG_CORES);
            this.ram = this.loadConfigOption(prop, PropertyNames.RAM, this.ram, ARG_MEMORY);
            this.renderTime = this.loadConfigOption(prop, PropertyNames.RENDER_TIME, this.renderTime, ARG_RENDERTIME);
            this.login = this.loadConfigOption(prop, PropertyNames.LOGIN, this.login, ARG_LOGIN);
            this.password = this.loadConfigOption(prop, PropertyNames.PASSWORD, this.password, ARG_PASSWORD);
            this.proxy = this.loadConfigOption(prop, PropertyNames.PROXY, this.proxy, ARG_PROXY);
            this.hostname = this.loadConfigOption(prop, PropertyNames.HOSTNAME, this.hostname, ARG_HOSTNAME);
            this.autoSignIn = this.loadConfigOption(prop, PropertyNames.AUTO_SIGNIN, this.autoSignIn, "");
            this.useSysTray = this.loadConfigOption(prop, PropertyNames.USE_SYSTRAY, this.useSysTray, ARG_NO_SYSTRAY);
            this.headless = this.loadConfigOption(prop, PropertyNames.HEADLESS, this.headless, ARG_HEADLESS);
            this.ui = this.loadConfigOption(prop, PropertyNames.UI, this.ui, ARG_UI);
            this.theme = this.loadConfigOption(prop, PropertyNames.THEME, this.theme, ARG_THEME);
            if (prop.containsKey(PropertyNames.PRIORITY.propertyName)) {
                int prio = Integer.parseInt(prop.getProperty(PropertyNames.PRIORITY.propertyName));
                if (this.priority == null) {
                    this.priority = new Option<Integer>(prio, ARG_PRIORITY);
                } else {
                    this.priority.setValue(prio);
                }
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (input != null) {
                try {
                    ((InputStream)input).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void merge(Configuration config, boolean initialize) {
        if (config == null) {
            System.out.println("SettingsLoader::merge config is null");
        }
        try {
            this.loadFile(initialize);
            this.applyConfigFileValues(config);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Exception while reading the config file. Falling back to defaults");
            this.initWithDefaults();
            this.applyConfigFileValues(config);
        }
    }

    private void applyConfigFileValues(Configuration config) {
        if (config.getLogin().isEmpty() && this.login != null) {
            config.setLogin(this.login.getValue());
        }
        if (config.getPassword().isEmpty() && this.password != null) {
            config.setPassword(this.password.getValue());
        }
        if ((config.getProxy() == null || config.getProxy().isEmpty()) && this.proxy != null) {
            config.setProxy(this.proxy.getValue());
        }
        if ((config.getHostname() == null || config.getHostname().isEmpty() || config.getHostname().equals(config.getDefaultHostname())) && this.hostname != null) {
            config.setHostname(this.hostname.getValue());
        }
        if (!config.isHeadless() && this.headless != null) {
            config.setHeadless(Boolean.parseBoolean(this.headless.getValue()));
        }
        if (config.getPriority() == 19) {
            config.setPriority(this.priority.getValue());
        }
        try {
            if (config.getComputeMethod() == null && this.computeMethod == null) {
                config.setComputeMethod(Configuration.ComputeType.CPU);
            } else if ((config.getComputeMethod() == null && this.computeMethod != null || this.computeMethod != null && config.getComputeMethod() != Configuration.ComputeType.valueOf(this.computeMethod.getValue())) && config.getComputeMethod() == null) {
                config.setComputeMethod(Configuration.ComputeType.valueOf(this.computeMethod.getValue()));
            }
        }
        catch (IllegalArgumentException e) {
            System.err.println("SettingsLoader::merge failed to handle compute method (raw value: '" + this.computeMethod + "')");
            this.computeMethod = null;
        }
        if (config.getGPUDevice() == null && this.gpu != null) {
            GPUDevice device = GPU.getGPUDevice(this.gpu.getValue());
            if (device != null) {
                config.setGPUDevice(device);
            } else if (config.getUIType() != null && (config.getUIType().equals("text") || config.getUIType().equals("oneLine"))) {
                System.err.println("SettingsLoader::merge could not find specified GPU");
                System.exit(2);
            }
        }
        if (config.getNbCores() == -1 && this.cores != null) {
            config.setNbCores(Integer.parseInt(this.cores.getValue()));
        }
        if (config.getMaxAllowedMemory() == -1L && this.ram != null) {
            config.setMaxAllowedMemory(Utils.parseNumber(this.ram.getValue()) / 1000L);
        }
        if (config.getMaxRenderTime() == -1 && this.renderTime != null) {
            config.setMaxRenderTime(Integer.parseInt(this.renderTime.getValue()));
        }
        if (config.getSharedDownloadsDirectory() == null && this.sharedZip != null) {
            config.setSharedDownloadsDirectory(new File(this.sharedZip.getValue()));
        }
        if (!config.isUserHasSpecifiedACacheDir() && this.cacheDir != null) {
            config.setCacheDir(new File(this.cacheDir.getValue()));
        }
        if (config.getUIType() == null && this.ui != null) {
            config.setUIType(this.ui.getValue());
        }
        if (config.getTheme() == null) {
            if (this.theme != null && (this.theme.getValue().equals("dark") || this.theme.getValue().equals("light"))) {
                config.setTheme(this.theme.getValue());
            } else {
                config.setTheme("light");
            }
        }
        if (!config.isUseSysTray() || config.isUseSysTray() && this.useSysTray != null && this.useSysTray.getValue().equals("false")) {
            config.setUseSysTray(false);
        }
        if (!config.isAutoSignIn() && this.autoSignIn != null) {
            config.setAutoSignIn(Boolean.parseBoolean(this.autoSignIn.getValue()));
        }
    }

    private void initWithDefaults() {
        Configuration defaultConfigValues = new Configuration(null, null, null);
        this.login = null;
        this.password = null;
        this.proxy = null;
        this.hostname = null;
        this.computeMethod = null;
        this.gpu = null;
        this.cacheDir = null;
        this.sharedZip = null;
        this.autoSignIn = null;
        this.useSysTray = new Option<String>(String.valueOf(defaultConfigValues.isUseSysTray()), ARG_NO_SYSTRAY);
        this.headless = new Option<String>(String.valueOf(defaultConfigValues.isHeadless()), ARG_HEADLESS);
        this.ui = null;
        this.priority = new Option<Integer>(defaultConfigValues.getPriority(), ARG_PRIORITY);
        this.ram = null;
        this.renderTime = null;
        this.theme = null;
        this.cores = new Option<String>(String.valueOf(defaultConfigValues.getNbCores()), ARG_CORES);
    }

    public String toString() {
        return String.format("SettingsLoader [path=%s, login=%s, password=%s, computeMethod=%s, gpu=%s, cacheDir=%s, sharedZip=%s, theme=%s, priority=%d, autosign=%s, usetray=%s, headless=%s]", this.path, this.login, this.password, this.computeMethod, this.gpu, this.cacheDir, this.sharedZip, this.theme, this.priority, this.autoSignIn, this.useSysTray, this.headless);
    }

    public String getPath() {
        return this.path;
    }

    public Option<String> getLogin() {
        return this.login;
    }

    public Option<String> getPassword() {
        return this.password;
    }

    public Option<String> getProxy() {
        return this.proxy;
    }

    public Option<String> getHostname() {
        return this.hostname;
    }

    public Option<String> getComputeMethod() {
        return this.computeMethod;
    }

    public Option<String> getGpu() {
        return this.gpu;
    }

    public Option<String> getCores() {
        return this.cores;
    }

    public Option<String> getRam() {
        return this.ram;
    }

    public Option<String> getRenderTime() {
        return this.renderTime;
    }

    public Option<String> getCacheDir() {
        return this.cacheDir;
    }

    public Option<String> getSharedZip() {
        return this.sharedZip;
    }

    public Option<String> getAutoSignIn() {
        return this.autoSignIn;
    }

    public Option<String> getUseSysTray() {
        return this.useSysTray;
    }

    public Option<String> getHeadless() {
        return this.headless;
    }

    public Option<String> getUi() {
        return this.ui;
    }

    public Option<String> getTheme() {
        return this.theme;
    }

    public Option<Integer> getPriority() {
        return this.priority;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setLogin(Option<String> login) {
        this.login = login;
    }

    public void setPassword(Option<String> password) {
        this.password = password;
    }

    public void setProxy(Option<String> proxy) {
        this.proxy = proxy;
    }

    public void setHostname(Option<String> hostname) {
        this.hostname = hostname;
    }

    public void setComputeMethod(Option<String> computeMethod) {
        this.computeMethod = computeMethod;
    }

    public void setGpu(Option<String> gpu) {
        this.gpu = gpu;
    }

    public void setCores(Option<String> cores) {
        this.cores = cores;
    }

    public void setRam(Option<String> ram) {
        this.ram = ram;
    }

    public void setRenderTime(Option<String> renderTime) {
        this.renderTime = renderTime;
    }

    public void setCacheDir(Option<String> cacheDir) {
        this.cacheDir = cacheDir;
    }

    public void setSharedZip(Option<String> sharedZip) {
        this.sharedZip = sharedZip;
    }

    public void setAutoSignIn(Option<String> autoSignIn) {
        this.autoSignIn = autoSignIn;
    }

    public void setUseSysTray(Option<String> useSysTray) {
        this.useSysTray = useSysTray;
    }

    public void setHeadless(Option<String> headless) {
        this.headless = headless;
    }

    public void setUi(Option<String> ui) {
        this.ui = ui;
    }

    public void setTheme(Option<String> theme) {
        this.theme = theme;
    }

    public void setPriority(Option<Integer> priority) {
        this.priority = priority;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SettingsLoader)) {
            return false;
        }
        SettingsLoader other = (SettingsLoader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        Option<String> this$login = this.getLogin();
        Option<String> other$login = other.getLogin();
        if (this$login == null ? other$login != null : !((Object)this$login).equals(other$login)) {
            return false;
        }
        Option<String> this$password = this.getPassword();
        Option<String> other$password = other.getPassword();
        if (this$password == null ? other$password != null : !((Object)this$password).equals(other$password)) {
            return false;
        }
        Option<String> this$proxy = this.getProxy();
        Option<String> other$proxy = other.getProxy();
        if (this$proxy == null ? other$proxy != null : !((Object)this$proxy).equals(other$proxy)) {
            return false;
        }
        Option<String> this$hostname = this.getHostname();
        Option<String> other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !((Object)this$hostname).equals(other$hostname)) {
            return false;
        }
        Option<String> this$computeMethod = this.getComputeMethod();
        Option<String> other$computeMethod = other.getComputeMethod();
        if (this$computeMethod == null ? other$computeMethod != null : !((Object)this$computeMethod).equals(other$computeMethod)) {
            return false;
        }
        Option<String> this$gpu = this.getGpu();
        Option<String> other$gpu = other.getGpu();
        if (this$gpu == null ? other$gpu != null : !((Object)this$gpu).equals(other$gpu)) {
            return false;
        }
        Option<String> this$cores = this.getCores();
        Option<String> other$cores = other.getCores();
        if (this$cores == null ? other$cores != null : !((Object)this$cores).equals(other$cores)) {
            return false;
        }
        Option<String> this$ram = this.getRam();
        Option<String> other$ram = other.getRam();
        if (this$ram == null ? other$ram != null : !((Object)this$ram).equals(other$ram)) {
            return false;
        }
        Option<String> this$renderTime = this.getRenderTime();
        Option<String> other$renderTime = other.getRenderTime();
        if (this$renderTime == null ? other$renderTime != null : !((Object)this$renderTime).equals(other$renderTime)) {
            return false;
        }
        Option<String> this$cacheDir = this.getCacheDir();
        Option<String> other$cacheDir = other.getCacheDir();
        if (this$cacheDir == null ? other$cacheDir != null : !((Object)this$cacheDir).equals(other$cacheDir)) {
            return false;
        }
        Option<String> this$sharedZip = this.getSharedZip();
        Option<String> other$sharedZip = other.getSharedZip();
        if (this$sharedZip == null ? other$sharedZip != null : !((Object)this$sharedZip).equals(other$sharedZip)) {
            return false;
        }
        Option<String> this$autoSignIn = this.getAutoSignIn();
        Option<String> other$autoSignIn = other.getAutoSignIn();
        if (this$autoSignIn == null ? other$autoSignIn != null : !((Object)this$autoSignIn).equals(other$autoSignIn)) {
            return false;
        }
        Option<String> this$useSysTray = this.getUseSysTray();
        Option<String> other$useSysTray = other.getUseSysTray();
        if (this$useSysTray == null ? other$useSysTray != null : !((Object)this$useSysTray).equals(other$useSysTray)) {
            return false;
        }
        Option<String> this$headless = this.getHeadless();
        Option<String> other$headless = other.getHeadless();
        if (this$headless == null ? other$headless != null : !((Object)this$headless).equals(other$headless)) {
            return false;
        }
        Option<String> this$ui = this.getUi();
        Option<String> other$ui = other.getUi();
        if (this$ui == null ? other$ui != null : !((Object)this$ui).equals(other$ui)) {
            return false;
        }
        Option<String> this$theme = this.getTheme();
        Option<String> other$theme = other.getTheme();
        if (this$theme == null ? other$theme != null : !((Object)this$theme).equals(other$theme)) {
            return false;
        }
        Option<Integer> this$priority = this.getPriority();
        Option<Integer> other$priority = other.getPriority();
        return !(this$priority == null ? other$priority != null : !((Object)this$priority).equals(other$priority));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SettingsLoader;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        Option<String> $login = this.getLogin();
        result = result * 59 + ($login == null ? 43 : ((Object)$login).hashCode());
        Option<String> $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : ((Object)$password).hashCode());
        Option<String> $proxy = this.getProxy();
        result = result * 59 + ($proxy == null ? 43 : ((Object)$proxy).hashCode());
        Option<String> $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : ((Object)$hostname).hashCode());
        Option<String> $computeMethod = this.getComputeMethod();
        result = result * 59 + ($computeMethod == null ? 43 : ((Object)$computeMethod).hashCode());
        Option<String> $gpu = this.getGpu();
        result = result * 59 + ($gpu == null ? 43 : ((Object)$gpu).hashCode());
        Option<String> $cores = this.getCores();
        result = result * 59 + ($cores == null ? 43 : ((Object)$cores).hashCode());
        Option<String> $ram = this.getRam();
        result = result * 59 + ($ram == null ? 43 : ((Object)$ram).hashCode());
        Option<String> $renderTime = this.getRenderTime();
        result = result * 59 + ($renderTime == null ? 43 : ((Object)$renderTime).hashCode());
        Option<String> $cacheDir = this.getCacheDir();
        result = result * 59 + ($cacheDir == null ? 43 : ((Object)$cacheDir).hashCode());
        Option<String> $sharedZip = this.getSharedZip();
        result = result * 59 + ($sharedZip == null ? 43 : ((Object)$sharedZip).hashCode());
        Option<String> $autoSignIn = this.getAutoSignIn();
        result = result * 59 + ($autoSignIn == null ? 43 : ((Object)$autoSignIn).hashCode());
        Option<String> $useSysTray = this.getUseSysTray();
        result = result * 59 + ($useSysTray == null ? 43 : ((Object)$useSysTray).hashCode());
        Option<String> $headless = this.getHeadless();
        result = result * 59 + ($headless == null ? 43 : ((Object)$headless).hashCode());
        Option<String> $ui = this.getUi();
        result = result * 59 + ($ui == null ? 43 : ((Object)$ui).hashCode());
        Option<String> $theme = this.getTheme();
        result = result * 59 + ($theme == null ? 43 : ((Object)$theme).hashCode());
        Option<Integer> $priority = this.getPriority();
        result = result * 59 + ($priority == null ? 43 : ((Object)$priority).hashCode());
        return result;
    }

    private static enum PropertyNames {
        PRIORITY("priority"),
        CACHE_DIR("cache-dir"),
        SHARED_ZIP("shared-zip"),
        COMPUTE_METHOD("compute-method"),
        GPU("compute-gpu"),
        CORES("cores"),
        CORES_BACKWARDS_COMPAT("cpu-cores"),
        RAM("ram"),
        RENDER_TIME("rendertime"),
        LOGIN("login"),
        PASSWORD("password"),
        PROXY("proxy"),
        HOSTNAME("hostname"),
        AUTO_SIGNIN("auto-signin"),
        USE_SYSTRAY("use-systray"),
        HEADLESS("headless"),
        UI("ui"),
        THEME("theme");

        String propertyName;

        private PropertyNames(String prop) {
            this.propertyName = prop;
        }

        public String toString() {
            return this.propertyName;
        }
    }
}

