/*
 * Decompiled with CFR 0.152.
 */
package com.sheepit.client;

import com.sheepit.client.ChunkInputStream;
import com.sheepit.client.Log;
import com.sheepit.client.Md5;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.io.inputstream.ZipInputStream;
import net.lingala.zip4j.model.LocalFileHeader;

public class Utils {
    private static Map<String, String> mimeTypes = new HashMap<String, String>();

    public static int unzipFileIntoDirectory(String zipFileName_, String destinationDirectory, char[] password, Log log) {
        try {
            ZipFile zipFile = new ZipFile(zipFileName_);
            if (password != null && zipFile.isEncrypted()) {
                zipFile.setPassword(password);
            }
            zipFile.extractAll(destinationDirectory);
        }
        catch (ZipException e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            log.debug("Utils::unzipFileIntoDirectory(" + zipFileName_ + "," + destinationDirectory + ") exception " + e + " stacktrace: " + sw.toString());
            return -1;
        }
        return 0;
    }

    public static int unzipChunksIntoDirectory(List<String> full_path_chunks, String destinationDirectory, char[] password, Log log) {
        try {
            ChunkInputStream chunkInputStream = new ChunkInputStream(full_path_chunks.stream().map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList()));
            ZipInputStream zipInputStream = new ZipInputStream(chunkInputStream);
            if (password != null) {
                zipInputStream.setPassword(password);
            }
            LocalFileHeader fileHeader = null;
            while ((fileHeader = zipInputStream.getNextEntry()) != null) {
                String outFilePath = destinationDirectory + File.separator + fileHeader.getFileName();
                File outFile = new File(outFilePath);
                if (fileHeader.isDirectory()) {
                    outFile.mkdirs();
                    continue;
                }
                File parentDir = outFile.getParentFile();
                if (!parentDir.exists()) {
                    parentDir.mkdirs();
                }
                FileOutputStream os = new FileOutputStream(outFile);
                int readLen = -1;
                byte[] buff = new byte[1024];
                while ((readLen = zipInputStream.read(buff)) != -1) {
                    os.write(buff, 0, readLen);
                }
                os.close();
            }
            zipInputStream.close();
        }
        catch (IOException e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            log.debug("Utils::unzipChunksIntoDirectory exception " + e + " stacktrace: " + sw.toString());
            return -1;
        }
        return 0;
    }

    public static String md5(String path_of_file_) {
        Md5 md5 = new Md5();
        return md5.get(path_of_file_);
    }

    public static String convertBinaryToHex(byte[] bytes) {
        StringBuilder hexStringBuilder = new StringBuilder();
        for (byte aByte : bytes) {
            char[] hex = new char[]{Character.forDigit(aByte >> 4 & 0xF, 16), Character.forDigit(aByte & 0xF, 16)};
            hexStringBuilder.append(new String(hex));
        }
        return hexStringBuilder.toString();
    }

    public static double lastModificationTime(File directory_) {
        double max = 0.0;
        if (directory_.isDirectory()) {
            File[] list = directory_.listFiles();
            if (list != null) {
                for (File aFile : list) {
                    double max1 = Utils.lastModificationTime(aFile);
                    if (!(max1 > max)) continue;
                    max = max1;
                }
            }
        } else if (directory_.isFile()) {
            return directory_.lastModified();
        }
        return max;
    }

    public static void delete(File file) {
        String[] files;
        if (file == null) {
            return;
        }
        if (file.isDirectory() && (files = file.list()) != null && files.length != 0) {
            for (String temp : files) {
                File fileDelete = new File(file, temp);
                Utils.delete(fileDelete);
            }
        }
        file.delete();
    }

    public static long parseNumber(String in) {
        in = in.trim();
        in = in.replaceAll(",", ".");
        try {
            return Long.parseLong(in);
        }
        catch (NumberFormatException numberFormatException) {
            Matcher m = Pattern.compile("([\\d.,]+)\\s*(\\w)").matcher(in);
            m.find();
            long scale = 1L;
            switch (Character.toUpperCase(m.group(2).charAt(0))) {
                case 'T': {
                    scale *= 1000L;
                }
                case 'G': {
                    scale *= 1000L;
                }
                case 'M': {
                    scale *= 1000L;
                }
                case 'K': {
                    scale *= 1000L;
                }
            }
            return Math.round(Double.parseDouble(m.group(1)) * (double)scale);
        }
    }

    public static String humanDuration(Date date) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.setTime(date);
        int hours = (calendar.get(5) - 1) * 24 + calendar.get(11);
        int minutes = calendar.get(12);
        int seconds = calendar.get(13);
        Object output = "";
        if (hours > 0) {
            output = (String)output + hours + "h ";
        }
        if (minutes > 0) {
            output = (String)output + minutes + "min ";
        }
        if (seconds > 0) {
            output = (String)output + seconds + "s";
        }
        return output;
    }

    public static boolean noFreeSpaceOnDisk(String destination_, Log log) {
        try {
            File file = new File(destination_);
            for (int i = 0; i < 5; ++i) {
                long space = file.getUsableSpace();
                if (space > 524288L) {
                    return false;
                }
                if (i >= 4) continue;
                long time = (long)(Math.random() * 51.0 + 50.0 + (double)(i * 500));
                log.debug("Utils::Not enough free disk space(" + space + ") encountered on try " + i + ", waiting " + time + "ms");
                Thread.sleep(time);
            }
            return true;
        }
        catch (InterruptedException | SecurityException exception) {
            return false;
        }
    }

    public static String findMimeType(String file) throws IOException {
        String mimeType = Files.probeContentType(Paths.get(file, new String[0]));
        if (mimeType == null) {
            BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));
            mimeType = URLConnection.guessContentTypeFromStream(stream);
        }
        if (mimeType == null) {
            mimeType = URLConnection.guessContentTypeFromName(file);
        }
        if (mimeType == null || mimeType.equals("image/aces") && file.toLowerCase().endsWith(".exr")) {
            try {
                String extension = file.substring(file.lastIndexOf(46));
                mimeType = mimeTypes.get(extension);
            }
            catch (IndexOutOfBoundsException e) {
                e.printStackTrace();
            }
        }
        return mimeType;
    }

    public static String formatDataConsumption(long bytes) {
        float divider = 0.0f;
        String suffix = "";
        if ((float)bytes > 1.0995116E12f) {
            divider = 1.0995116E12f;
            suffix = "TB";
        } else if (bytes > 0x40000000L) {
            divider = 1.0737418E9f;
            suffix = "GB";
        } else {
            divider = 1048576.0f;
            suffix = "MB";
        }
        return String.format("%.2f%s", Float.valueOf((float)bytes / divider), suffix);
    }

    static {
        mimeTypes.put(".tga", "image/tga");
        mimeTypes.put(".exr", "image/x-exr");
    }
}

