/*
 * Decompiled with CFR 0.152.
 */
package com.sheepit.client.hardware.hwid.impl;

import com.sheepit.client.hardware.hwid.BasicHWInfoStrategy;
import com.sun.jna.Platform;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import oshi.SystemInfo;
import oshi.hardware.HWDiskStore;
import oshi.hardware.HWPartition;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.NetworkIF;

public class BaseHWInfoImpl
implements BasicHWInfoStrategy {
    protected HardwareAbstractionLayer hardware = new SystemInfo().getHardware();

    @Override
    public Optional<String> getMAC() {
        ArrayList<String> macs = new ArrayList<String>();
        List<NetworkIF> nics = this.hardware.getNetworkIFs();
        for (NetworkIF nic : nics) {
            macs.add(nic.getMacaddr());
        }
        Collections.sort(macs);
        return Optional.of(String.join((CharSequence)" ", macs));
    }

    @Override
    public Optional<String> getProcessorName() {
        return Optional.of(this.hardware.getProcessor().getProcessorIdentifier().getName());
    }

    @Override
    public Optional<String> getHarddriveID() {
        String rootMountpoint = Platform.isWindows() ? "C:" : "/";
        return this.getHarddriveID(rootMountpoint);
    }

    private Optional<String> getHarddriveID(String rootMountpoint) {
        List<HWDiskStore> drives = this.hardware.getDiskStores();
        String hddSerial = "";
        boolean rootFound = false;
        Iterator<HWDiskStore> iterator2 = drives.iterator();
        block0: while (!rootFound && iterator2.hasNext()) {
            HWDiskStore drive = iterator2.next();
            for (HWPartition partition : drive.getPartitions()) {
                if (!partition.getMountPoint().equals(rootMountpoint) && (!Platform.isWindows() || !partition.getMountPoint().equals(rootMountpoint + File.separator))) continue;
                hddSerial = drive.getSerial();
                rootFound = true;
                continue block0;
            }
        }
        return hddSerial.isEmpty() ? Optional.empty() : Optional.of(hddSerial);
    }
}

