/*
 * Decompiled with CFR 0.152.
 */
package com.sheepit.client.os;

import com.sheepit.client.Log;
import com.sheepit.client.os.OS;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;

public class Mac
extends OS {
    private final String NICE_BINARY_PATH = "nice";
    private final String ID_COMMAND_INVOCATION = "id -u";

    @Override
    public String name() {
        return "mac";
    }

    @Override
    public String getRenderBinaryPath() {
        return "Blender" + File.separator + "Blender.app" + File.separator + "Contents" + File.separator + "MacOS" + File.separator + "Blender";
    }

    @Override
    public Process exec(List<String> command, Map<String, String> env) throws IOException {
        List<String> actual_command = command;
        if (this.isNiceAvailable()) {
            if (env != null) {
                actual_command.add(0, env.get("PRIORITY"));
            } else {
                actual_command.add(0, "19");
            }
            actual_command.add(0, "-n");
            actual_command.add(0, "nice");
        } else {
            Log.getInstance(null).error("No low priority binary, will not launch renderer in normal priority");
        }
        ProcessBuilder builder = new ProcessBuilder(actual_command);
        builder.redirectErrorStream(true);
        if (env != null) {
            builder.environment().putAll(env);
        }
        return builder.start();
    }

    @Override
    public boolean isSupported() {
        String[] ver = operatingSystem.getVersionInfo().getVersion().split("\\.");
        int majorVer = Integer.parseInt(ver[0]);
        int minorVer = Integer.parseInt(ver[1]);
        return super.isSupported() && (majorVer == 10 && minorVer >= 13 || majorVer >= 11);
    }

    @Override
    public String getCUDALib() {
        return "/usr/local/cuda/lib/libcuda.dylib";
    }

    @Override
    public boolean isHighPrioritySupported() {
        try {
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            builder.command("bash", "-c", "id -u");
            builder.redirectErrorStream(true);
            Process process = builder.start();
            InputStream is = process.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            String userLevel = null;
            userLevel = reader.readLine();
            if (userLevel != null) {
                return userLevel.equals("0") & this.isNiceAvailable();
            }
        }
        catch (IOException e) {
            System.err.println(String.format("ERROR Mac::getSupportHighPriority Unable to execute id command. IOException %s", e.getMessage()));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isNiceAvailable() {
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.command("nice");
        builder.redirectErrorStream(true);
        Process process = null;
        boolean hasNiceBinary = false;
        try {
            process = builder.start();
            hasNiceBinary = true;
        }
        catch (IOException e) {
            Log.getInstance(null).error("Failed to find low priority binary, will not launch renderer in normal priority (" + e + ")");
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
        return hasNiceBinary;
    }

    @Override
    public void shutdownComputer(int delayInMinutes) {
        try {
            ProcessBuilder builder = new ProcessBuilder("shutdown", "-h", String.valueOf(delayInMinutes));
            Process process = builder.inheritIO().start();
        }
        catch (IOException e) {
            System.err.println(String.format("Mac::shutdownComputer Unable to execute the 'shutdown -h 1' command. Exception %s", e.getMessage()));
        }
    }
}

