/*
 * Decompiled with CFR 0.152.
 */
package com.sheepit.client.os;

import com.sheepit.client.os.OS;
import com.sheepit.client.os.windows.Kernel32Lib;
import com.sheepit.client.os.windows.WinProcess;
import com.sun.jna.Native;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import oshi.software.os.OperatingSystem;

public class Windows
extends OS {
    private static final int MINIMUM_SUPPORTED_BUILD = 9600;

    @Override
    public String name() {
        return "windows";
    }

    @Override
    public String getRenderBinaryPath() {
        return "rend.exe";
    }

    @Override
    public String getCUDALib() {
        return "nvcuda";
    }

    @Override
    public String getNVMLLib() {
        return "nvml";
    }

    @Override
    public Process exec(List<String> command, Map<String, String> env) throws IOException {
        Kernel32Lib kernel32lib = null;
        try {
            kernel32lib = Native.load("kernel32", Kernel32Lib.class);
            kernel32lib.SetErrorMode(Kernel32Lib.SEM_NOGPFAULTERRORBOX);
        }
        catch (UnsatisfiedLinkError e) {
            System.out.println("OS.Windows::exec failed to load kernel32lib " + e);
        }
        catch (ExceptionInInitializerError e) {
            System.out.println("OS.Windows::exec failed to load kernel32lib " + e);
        }
        catch (Exception e) {
            System.out.println("OS.Windows::exec failed to load kernel32lib " + e);
        }
        ProcessBuilder builder = new ProcessBuilder(command);
        builder.redirectErrorStream(true);
        if (env != null) {
            builder.environment().putAll(env);
        }
        Process p = builder.start();
        WinProcess wproc = new WinProcess(p);
        if (env != null) {
            String priority = env.get("PRIORITY");
            wproc.setPriority(this.getPriorityClass(Integer.parseInt(priority)));
        } else {
            wproc.setPriority(16384);
        }
        return p;
    }

    @Override
    public boolean isSupported() {
        long buildNumber = Long.MIN_VALUE;
        String arch = System.getProperty("os.arch").toLowerCase();
        try {
            buildNumber = Long.parseLong(operatingSystem.getVersionInfo().getBuildNumber());
        }
        catch (NumberFormatException e) {
            System.err.println("Windows::isSupported Failed to extract Windows build number: " + e);
        }
        catch (NullPointerException e) {
            System.err.println("Windows::isSupported Failed to extract Windows build number: " + e);
            OperatingSystem.OSVersionInfo versionInfo = operatingSystem.getVersionInfo();
            if (versionInfo == null) {
                return false;
            }
            String ver = versionInfo.getVersion();
            List<String> supportedVersions = List.of("8.1", "10", "11", "Server 2016", "Server 2012 R2", "Server 2019", "Server 2022");
            return super.isSupported() && supportedVersions.contains(ver);
        }
        return super.isSupported() && buildNumber >= 9600L && ("amd64".equals(arch) || "x64".equals(arch) || "x86_64".equals(arch));
    }

    int getPriorityClass(int priority) {
        int process_class = 64;
        switch (priority) {
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                process_class = 64;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                process_class = 16384;
                break;
            }
            case -3: 
            case -2: 
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                process_class = 32;
                break;
            }
            case -9: 
            case -8: 
            case -7: 
            case -6: 
            case -5: 
            case -4: {
                process_class = 32768;
                break;
            }
            case -14: 
            case -13: 
            case -12: 
            case -11: 
            case -10: {
                process_class = 128;
                break;
            }
            case -19: 
            case -18: 
            case -17: 
            case -16: 
            case -15: {
                process_class = 256;
            }
        }
        return process_class;
    }

    @Override
    public boolean kill(Process process) {
        if (process != null) {
            WinProcess wproc = new WinProcess(process);
            wproc.kill();
            return true;
        }
        return false;
    }

    @Override
    public boolean isHighPrioritySupported() {
        return true;
    }

    @Override
    public boolean isNiceAvailable() {
        return true;
    }

    @Override
    public void shutdownComputer(int delayInMinutes) {
        try {
            ProcessBuilder builder = new ProcessBuilder("shutdown", "/s", "/f", "/t", String.valueOf(delayInMinutes * 60), "/c", "\"SheepIt App has initiated this computer shutdown.\"");
            Process process = builder.inheritIO().start();
        }
        catch (IOException e) {
            System.err.println(String.format("Windows::shutdownComputer Unable to execute the command 'shutdown /s /f /t 60...' command. Exception %s", e.getMessage()));
        }
    }

    @Override
    public String getDefaultConfigFilePath() {
        return System.getProperty("user.home") + File.separator + ".sheepit.conf";
    }
}

