/*
 * Decompiled with CFR 0.152.
 */
package com.sheepit.client.os.windows;

import com.sheepit.client.os.windows.Kernel32Lib;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

public class WinProcess {
    public static final int PRIORITY_IDLE = 64;
    public static final int PRIORITY_BELOW_NORMAL = 16384;
    public static final int PRIORITY_NORMAL = 32;
    public static final int PRIORITY_ABOVE_NORMAL = 32768;
    public static final int PRIORITY_HIGH = 128;
    public static final int PRIORITY_REALTIME = 256;
    private WinNT.HANDLE handle = null;
    private int pid = -1;
    Kernel32Lib kernel32lib = null;

    public WinProcess() {
        try {
            this.kernel32lib = Native.load("kernel32", Kernel32Lib.class);
        }
        catch (UnsatisfiedLinkError e) {
            System.out.println("WinProcess::construct " + e);
        }
        catch (ExceptionInInitializerError e) {
            System.out.println("WinProcess::construct " + e);
        }
        catch (Exception e) {
            System.out.println("WinProcess::construct " + e);
        }
    }

    private static boolean processHasGetPid() {
        try {
            if (Process.class.getMethod("pid", new Class[0]) != null) {
                return true;
            }
        }
        catch (NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
        return false;
    }

    private static long getPid(Process process) {
        try {
            return (Long)Process.class.getMethod("pid", new Class[0]).invoke((Object)process, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            return 0L;
        }
    }

    private static WinNT.HANDLE getHandleByPid(int pid_) throws IOException {
        WinNT.HANDLE handle = Kernel32.INSTANCE.OpenProcess(0x100E01, false, pid_);
        if (handle == null) {
            throw new IOException("OpenProcess failed: " + Kernel32Util.formatMessageFromLastErrorCode(Kernel32.INSTANCE.GetLastError()) + " (pid: " + pid_ + ")");
        }
        return handle;
    }

    public WinProcess(Process process) {
        this();
        if (WinProcess.processHasGetPid()) {
            int _pid = (int)WinProcess.getPid(process);
            try {
                this.handle = WinProcess.getHandleByPid(_pid);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.pid = _pid;
        } else {
            try {
                Field f = process.getClass().getDeclaredField("handle");
                f.setAccessible(true);
                long val = f.getLong(process);
                this.handle = new WinNT.HANDLE();
                this.handle.setPointer(Pointer.createConstant(val));
                this.pid = Kernel32.INSTANCE.GetProcessId(this.handle);
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public WinProcess(int pid_) throws IOException {
        this();
        this.handle = WinProcess.getHandleByPid(pid_);
        this.pid = pid_;
    }

    protected void finalize() throws Throwable {
        if (this.handle != null) {
            this.handle = null;
        }
        this.pid = -1;
    }

    public boolean kill() {
        try {
            List<WinProcess> children = this.getChildren();
            this.terminate();
            for (WinProcess child : children) {
                child.kill();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean setPriority(int priority) {
        return this.kernel32lib.SetPriorityClass(this.handle, priority);
    }

    private void terminate() {
        Kernel32.INSTANCE.TerminateProcess(this.handle, 0);
        Kernel32.INSTANCE.CloseHandle(this.handle);
    }

    private List<WinProcess> getChildren() throws IOException {
        Kernel32Lib.PROCESSENTRY32.ByReference ent;
        ArrayList<WinProcess> result = new ArrayList<WinProcess>();
        WinNT.HANDLE hSnap = this.kernel32lib.CreateToolhelp32Snapshot(Kernel32Lib.TH32CS_SNAPPROCESS, new WinDef.DWORD(0L));
        if (!this.kernel32lib.Process32First(hSnap, ent = new Kernel32Lib.PROCESSENTRY32.ByReference())) {
            return result;
        }
        do {
            if (ent.th32ParentProcessID.intValue() != this.pid) continue;
            try {
                result.add(new WinProcess(ent.th32ProcessID.intValue()));
            }
            catch (IOException e) {
                System.err.println("WinProcess::getChildren, IOException " + e);
            }
        } while (this.kernel32lib.Process32Next(hSnap, ent));
        Kernel32.INSTANCE.CloseHandle(hSnap);
        return result;
    }

    public String toString() {
        return "WinProcess(pid: " + this.pid + ", handle " + this.handle + ")";
    }
}

