/*
 * Decompiled with CFR 0.152.
 */
package com.sheepit.client.standalone.swing.activity;

import com.formdev.flatlaf.FlatDarkLaf;
import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.FlatLightLaf;
import com.sheepit.client.Configuration;
import com.sheepit.client.hardware.cpu.CPU;
import com.sheepit.client.hardware.gpu.GPU;
import com.sheepit.client.hardware.gpu.GPUDevice;
import com.sheepit.client.hardware.gpu.nvidia.Nvidia;
import com.sheepit.client.network.Proxy;
import com.sheepit.client.os.OS;
import com.sheepit.client.standalone.GuiSwing;
import com.sheepit.client.standalone.swing.SwingTooltips;
import com.sheepit.client.standalone.swing.activity.Activity;
import com.sheepit.client.standalone.swing.components.CollapsibleJPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.net.MalformedURLException;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;

public class Settings
implements Activity {
    private static final String DUMMY_CACHE_DIR = "Auto detected";
    private GuiSwing parent;
    private JTextField login;
    private JPasswordField password;
    private JLabel cacheDirText;
    private File cacheDir;
    private JFileChooser cacheDirChooser;
    private JCheckBox useCPU;
    private List<JCheckBoxGPU> useGPUs;
    private JCheckBox useSysTray;
    private JCheckBox headlessCheckbox;
    private JSlider cpuCores;
    private JSlider ram;
    private JSpinner renderTime;
    private JSlider priority;
    private JTextField proxy;
    private JTextField hostname;
    private ButtonGroup themeOptionsGroup;
    private JRadioButton lightMode;
    private JRadioButton darkMode;
    private JCheckBox saveFile;
    private JCheckBox autoSignIn;
    JButton cancelButton;
    JButton saveButton;
    private boolean haveAutoStarted;
    private boolean useSysTrayPrevState;
    private boolean isHeadlessPrevState;
    private boolean sessionStarted;

    public Settings(GuiSwing parent_) {
        this.parent = parent_;
        this.cacheDir = null;
        this.useGPUs = new LinkedList<JCheckBoxGPU>();
        this.haveAutoStarted = false;
        this.sessionStarted = false;
    }

    @Override
    public void show() {
        CPU cpu;
        Configuration config = this.parent.getConfiguration();
        this.parent.getSettingsLoader().merge(config, false);
        this.useSysTrayPrevState = config.isUseSysTray();
        this.isHeadlessPrevState = config.isHeadless();
        this.applyTheme(config.getTheme());
        List<GPUDevice> gpus = GPU.listDevices(config);
        this.useGPUs.clear();
        GridBagConstraints constraints = new GridBagConstraints();
        int currentRow = 0;
        JLabel labelImage = GuiSwing.createLogoWithWatermark();
        constraints.fill = 10;
        constraints.gridwidth = 2;
        constraints.gridx = 0;
        constraints.gridy = currentRow++;
        this.parent.getContentPanel().add((Component)labelImage, constraints);
        constraints.gridy = currentRow++;
        this.parent.getContentPanel().add((Component)new JLabel(" "), constraints);
        CollapsibleJPanel authentication_panel = new CollapsibleJPanel((LayoutManager)new GridLayout(2, 2), this);
        authentication_panel.setBorder(BorderFactory.createTitledBorder("Authentication"));
        JLabel loginLabel = new JLabel("Username:");
        this.login = new JTextField();
        this.login.setText(this.parent.getConfiguration().getLogin());
        this.login.setColumns(20);
        this.login.addKeyListener(new CheckCanStart());
        JLabel passwordLabel = new JLabel("Password:");
        this.password = new JPasswordField();
        this.password.setText(this.parent.getConfiguration().getPassword());
        this.password.setColumns(10);
        this.password.addKeyListener(new CheckCanStart());
        authentication_panel.add(loginLabel);
        authentication_panel.add(this.login);
        authentication_panel.add(passwordLabel);
        authentication_panel.add(this.password);
        constraints.gridx = 0;
        constraints.gridy = currentRow++;
        constraints.fill = 2;
        this.parent.getContentPanel().add((Component)authentication_panel, constraints);
        CollapsibleJPanel themePanel = new CollapsibleJPanel((LayoutManager)new GridLayout(1, 3), this);
        themePanel.setBorder(BorderFactory.createTitledBorder("Theme"));
        this.themeOptionsGroup = new ButtonGroup();
        this.lightMode = new JRadioButton("Light");
        this.lightMode.setActionCommand("light");
        this.lightMode.setSelected(config.getTheme().equals("light"));
        this.lightMode.addActionListener(new ApplyThemeAction());
        this.darkMode = new JRadioButton("Dark");
        this.darkMode.setActionCommand("dark");
        this.darkMode.setSelected(config.getTheme().equals("dark"));
        this.darkMode.addActionListener(new ApplyThemeAction());
        themePanel.add(this.lightMode);
        themePanel.add(this.darkMode);
        this.themeOptionsGroup.add(this.lightMode);
        this.themeOptionsGroup.add(this.darkMode);
        constraints.gridx = 0;
        constraints.gridy = currentRow;
        constraints.gridwidth = 2;
        this.parent.getContentPanel().add((Component)themePanel, constraints);
        CollapsibleJPanel directory_panel = new CollapsibleJPanel((LayoutManager)new GridLayout(1, 3), this);
        directory_panel.setBorder(BorderFactory.createTitledBorder("Cache"));
        JLabel cacheLabel = new JLabel("Working directory:");
        cacheLabel.setToolTipText(SwingTooltips.WORKING_DIRECTORY.getText());
        directory_panel.add(cacheLabel);
        String destination = DUMMY_CACHE_DIR;
        if (config.isUserHasSpecifiedACacheDir()) {
            destination = config.getCacheDirForSettings().getName();
        }
        JPanel cacheDirWrapper = new JPanel();
        cacheDirWrapper.setLayout(new BoxLayout(cacheDirWrapper, 2));
        this.cacheDirText = new JLabel(destination);
        cacheDirWrapper.add(this.cacheDirText);
        cacheDirWrapper.add(Box.createHorizontalGlue());
        this.cacheDirChooser = new JFileChooser();
        this.cacheDirChooser.setFileSelectionMode(1);
        JButton openButton = new JButton("...");
        openButton.addActionListener(new ChooseFileAction());
        cacheDirWrapper.add(openButton);
        directory_panel.add(cacheDirWrapper);
        constraints.gridx = 0;
        constraints.gridy = ++currentRow;
        constraints.gridwidth = 2;
        this.parent.getContentPanel().add((Component)directory_panel, constraints);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints compute_devices_constraints = new GridBagConstraints();
        CollapsibleJPanel compute_devices_panel = new CollapsibleJPanel((LayoutManager)gridbag, this);
        compute_devices_panel.setBorder(BorderFactory.createTitledBorder("Compute devices"));
        compute_devices_panel.setToolTipText(SwingTooltips.COMPUTE_DEVICES.getText());
        Configuration.ComputeType method = config.getComputeMethod();
        this.useCPU = new JCheckBox("CPU");
        boolean gpuChecked = false;
        if (method == Configuration.ComputeType.CPU_GPU) {
            this.useCPU.setSelected(true);
            gpuChecked = true;
        } else if (method == Configuration.ComputeType.CPU) {
            this.useCPU.setSelected(true);
            gpuChecked = false;
        } else if (method == Configuration.ComputeType.GPU) {
            this.useCPU.setSelected(false);
            gpuChecked = true;
        }
        this.useCPU.addActionListener(new CpuChangeAction());
        compute_devices_constraints.gridx = 1;
        compute_devices_constraints.gridy = 0;
        compute_devices_constraints.fill = 1;
        compute_devices_constraints.weightx = 1.0;
        compute_devices_constraints.weighty = 1.0;
        gridbag.setConstraints(this.useCPU, compute_devices_constraints);
        compute_devices_panel.add(this.useCPU);
        if (gpus.size() > 0 || GPU.hasHIPDevices()) {
            for (GPUDevice gpu : gpus) {
                GPUDevice config_gpu;
                JCheckBoxGPU gpuCheckBox = new JCheckBoxGPU(gpu);
                gpuCheckBox.setToolTipText(gpu.getId());
                if (gpuChecked && (config_gpu = config.getGPUDevice()) != null && config_gpu.getId().equals(gpu.getId())) {
                    gpuCheckBox.setSelected(gpuChecked);
                }
                gpuCheckBox.addActionListener(new GpuChangeAction());
                ++compute_devices_constraints.gridy;
                gridbag.setConstraints(gpuCheckBox, compute_devices_constraints);
                compute_devices_panel.add(gpuCheckBox);
                this.useGPUs.add(gpuCheckBox);
            }
            if (GPU.hasHIPDevices()) {
                JCheckBox gpuCheckBox = new JCheckBox("Unsupported HIP device(s)");
                gpuCheckBox.setToolTipText("SheepIt does not support AMD GPUs due to a lack of use");
                gpuCheckBox.setEnabled(false);
                gpuCheckBox.setSelected(false);
                ++compute_devices_constraints.gridy;
                gridbag.setConstraints(gpuCheckBox, compute_devices_constraints);
                compute_devices_panel.add(gpuCheckBox);
            }
            compute_devices_constraints.gridx = 1;
            compute_devices_constraints.weightx = 1.0;
            compute_devices_panel.add((Component)new JLabel(" "), compute_devices_constraints);
        }
        if ((cpu = new CPU()).cores() > 1) {
            double step = 1.0;
            double display = (double)cpu.cores() / step;
            while (display > 10.0) {
                display = (double)cpu.cores() / (step += 1.0);
            }
            this.cpuCores = new JSlider(CPU.MIN_CORES, cpu.cores());
            this.cpuCores.setMajorTickSpacing((int)step);
            this.cpuCores.setMinorTickSpacing(1);
            this.cpuCores.setPaintTicks(true);
            this.cpuCores.setSnapToTicks(true);
            this.cpuCores.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    Settings.this.cpuCores.setToolTipText(String.valueOf(Settings.this.cpuCores.getValue()));
                }
            });
            this.cpuCores.setPaintLabels(true);
            this.cpuCores.setValue(config.getNbCores() != -1 ? Math.max(config.getNbCores(), CPU.MIN_CORES) : this.cpuCores.getMaximum());
            JLabel coreLabel = new JLabel("CPU cores:");
            coreLabel.setToolTipText(SwingTooltips.CPU_CORES.getText());
            compute_devices_constraints.weightx = 1.0 / (double)gpus.size();
            compute_devices_constraints.gridx = 0;
            ++compute_devices_constraints.gridy;
            gridbag.setConstraints(coreLabel, compute_devices_constraints);
            compute_devices_panel.add(coreLabel);
            compute_devices_constraints.gridx = 1;
            compute_devices_constraints.weightx = 1.0;
            gridbag.setConstraints(this.cpuCores, compute_devices_constraints);
            compute_devices_panel.add((Component)new JLabel(" "), compute_devices_constraints);
            compute_devices_panel.add(this.cpuCores);
        }
        OS os = OS.getOS();
        int all_ram = (int)os.getTotalMemory();
        this.ram = new JSlider(0, all_ram);
        int step = 1000000;
        double display = (double)all_ram / (double)step;
        while (display > 10.0) {
            display = (double)all_ram / (double)(step += 1000000);
        }
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        for (int g = 0; g < all_ram; g += step) {
            labelTable.put(g, new JLabel("" + g / 1000000));
        }
        this.ram.setMajorTickSpacing(step);
        this.ram.setLabelTable(labelTable);
        this.ram.setPaintTicks(true);
        this.ram.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Settings.this.ram.setToolTipText(String.format("%,d MiB", Settings.this.ram.getValue() / 1024));
            }
        });
        this.ram.setPaintLabels(true);
        this.ram.setValue((int)(config.getMaxAllowedMemory() != -1L ? config.getMaxAllowedMemory() : os.getTotalMemory()));
        JLabel ramLabel = new JLabel("Memory:");
        ramLabel.setToolTipText(SwingTooltips.MEMORY.getText());
        compute_devices_constraints.weightx = 1.0 / (double)gpus.size();
        compute_devices_constraints.gridx = 0;
        ++compute_devices_constraints.gridy;
        gridbag.setConstraints(ramLabel, compute_devices_constraints);
        compute_devices_panel.add(ramLabel);
        compute_devices_constraints.gridx = 1;
        compute_devices_constraints.weightx = 1.0;
        gridbag.setConstraints(this.ram, compute_devices_constraints);
        compute_devices_panel.add((Component)new JLabel(" "), compute_devices_constraints);
        compute_devices_panel.add(this.ram);
        this.parent.getContentPanel().add((Component)compute_devices_panel, constraints);
        boolean high_priority_support = os.isHighPrioritySupported();
        this.priority = new JSlider(high_priority_support ? -19 : 0, 19);
        Hashtable<Integer, JLabel> labelTablePriority = new Hashtable<Integer, JLabel>();
        labelTablePriority.put(high_priority_support ? -19 : 0, new JLabel("Low"));
        labelTablePriority.put(19, new JLabel("High"));
        this.priority.setLabelTable(labelTablePriority);
        this.priority.setMinorTickSpacing(1);
        this.priority.setPaintTicks(true);
        this.priority.setSnapToTicks(true);
        this.priority.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Settings.this.priority.setToolTipText(String.valueOf(Settings.this.priority.getValue()));
            }
        });
        this.priority.setPaintLabels(true);
        if (high_priority_support) {
            this.priority.setValue(-1 * config.getPriority());
        } else {
            this.priority.setValue(19 - config.getPriority());
        }
        JLabel priorityLabel = new JLabel("Priority");
        priorityLabel.setToolTipText(SwingTooltips.PRIORITY.getText());
        boolean showPrioritySlider = os.isNiceAvailable();
        this.priority.setVisible(showPrioritySlider);
        priorityLabel.setVisible(showPrioritySlider);
        compute_devices_constraints.weightx = 1.0 / (double)gpus.size();
        compute_devices_constraints.gridx = 0;
        ++compute_devices_constraints.gridy;
        gridbag.setConstraints(priorityLabel, compute_devices_constraints);
        compute_devices_panel.add(priorityLabel);
        compute_devices_constraints.gridx = 1;
        compute_devices_constraints.weightx = 1.0;
        gridbag.setConstraints(this.priority, compute_devices_constraints);
        compute_devices_panel.add(this.priority);
        constraints.gridx = 0;
        constraints.gridy = ++currentRow;
        constraints.gridwidth = 2;
        this.parent.getContentPanel().add((Component)compute_devices_panel, constraints);
        CollapsibleJPanel advanced_panel = new CollapsibleJPanel((LayoutManager)new GridLayout(5, 2), this);
        advanced_panel.setBorder(BorderFactory.createTitledBorder("Advanced options"));
        JLabel useSysTrayLabel = new JLabel("Minimize to SysTray");
        useSysTrayLabel.setToolTipText(SwingTooltips.MINIMIZE_TO_SYSTRAY.getText());
        this.useSysTray = new JCheckBox();
        this.useSysTray.setSelected(config.isUseSysTray());
        advanced_panel.add(useSysTrayLabel);
        advanced_panel.add(this.useSysTray);
        JLabel headlessLabel = new JLabel("Block Eevee projects");
        this.headlessCheckbox = new JCheckBox();
        this.headlessCheckbox.setSelected(config.isHeadless());
        advanced_panel.add(headlessLabel);
        advanced_panel.add(this.headlessCheckbox);
        JLabel proxyLabel = new JLabel("Proxy:");
        proxyLabel.setToolTipText("http://login:password@host:port\n" + SwingTooltips.PROXY.getText());
        this.proxy = new JTextField();
        this.proxy.setToolTipText("http://login:password@host:port");
        this.proxy.setText(this.parent.getConfiguration().getProxy());
        this.proxy.addKeyListener(new CheckCanStart());
        advanced_panel.add(proxyLabel);
        advanced_panel.add(this.proxy);
        JLabel hostnameLabel = new JLabel("Computer name:");
        hostnameLabel.setToolTipText(SwingTooltips.COMPUTER_NAME.getText());
        this.hostname = new JTextField();
        this.hostname.setText(this.parent.getConfiguration().getHostname());
        advanced_panel.add(hostnameLabel);
        advanced_panel.add(this.hostname);
        JLabel renderTimeLabel = new JLabel("Max time per frame (in minute):");
        renderTimeLabel.setToolTipText(SwingTooltips.MAX_TIME_PER_FRAME.getText());
        int val = 0;
        if (this.parent.getConfiguration().getMaxRenderTime() > 0) {
            val = this.parent.getConfiguration().getMaxRenderTime() / 60;
        }
        this.renderTime = new JSpinner(new SpinnerNumberModel(val, 0, 1000, 1));
        advanced_panel.add(renderTimeLabel);
        advanced_panel.add(this.renderTime);
        ++currentRow;
        constraints.gridx = 0;
        constraints.gridy = currentRow++;
        constraints.gridwidth = 2;
        this.parent.getContentPanel().add((Component)advanced_panel, constraints);
        JPanel general_panel = new JPanel(new GridLayout(1, 2));
        this.saveFile = new JCheckBox("Write settings to file", true);
        this.saveFile.addActionListener(new SaveSettingsFileAction());
        general_panel.add(this.saveFile);
        this.autoSignIn = new JCheckBox("Auto sign in", config.isAutoSignIn());
        this.autoSignIn.addActionListener(new AutoSignInChangeAction());
        general_panel.add(this.autoSignIn);
        constraints.gridx = 0;
        constraints.gridy = currentRow++;
        constraints.gridwidth = 2;
        this.parent.getContentPanel().add((Component)general_panel, constraints);
        constraints.gridx = 0;
        constraints.gridy = currentRow;
        constraints.gridwidth = 2;
        this.parent.getContentPanel().add((Component)new JLabel(" "), constraints);
        boolean isClientRunning = this.parent.getClient() != null && this.parent.getClient().isRunning();
        int savePanelCols = isClientRunning ? 2 : 1;
        JPanel savePanel = new JPanel(new GridLayout(1, savePanelCols));
        if (isClientRunning) {
            this.cancelButton = new JButton("Discard & go back");
            this.cancelButton.addActionListener(new CancelAction());
            savePanel.add(this.cancelButton);
        }
        this.saveButton = new JButton("Save & go back");
        this.checkDisplaySaveButton();
        this.saveButton.addActionListener(new SaveAction());
        savePanel.add(this.saveButton);
        constraints.gridwidth = 2;
        constraints.gridx = 0;
        constraints.gridy = ++currentRow;
        this.parent.getContentPanel().add((Component)savePanel, constraints);
        this.parent.setSize(540, 850);
        if (!this.haveAutoStarted && config.isAutoSignIn() && this.checkDisplaySaveButton()) {
            this.haveAutoStarted = true;
            new SaveAction().actionPerformed(null);
        }
    }

    @Override
    public void resizeWindow() {
    }

    public boolean checkDisplaySaveButton() {
        boolean isClientRunning;
        boolean selected = this.useCPU.isSelected();
        for (JCheckBoxGPU box : this.useGPUs) {
            if (!box.isSelected()) continue;
            selected = true;
        }
        if (this.login.getText().isEmpty() || this.password.getPassword().length == 0 || !Proxy.isValidURL(this.proxy.getText())) {
            selected = false;
        }
        boolean bl = isClientRunning = this.parent.getClient() != null && this.parent.getClient().isRunning();
        if (isClientRunning) {
            if (this.saveFile.isSelected()) {
                this.saveButton.setText("Save & go back");
            } else {
                this.saveButton.setText("Apply & go back");
            }
        } else if (this.saveFile.isSelected()) {
            this.saveButton.setText("Save & start");
        } else {
            this.saveButton.setText("Apply & start");
        }
        this.saveButton.setEnabled(selected);
        return selected;
    }

    private void applyTheme(String theme_) {
        try {
            if (theme_.equals("light")) {
                UIManager.setLookAndFeel(new FlatLightLaf());
            } else if (theme_.equals("dark")) {
                UIManager.setLookAndFeel(new FlatDarkLaf());
            }
            FlatLaf.updateUI();
        }
        catch (UnsupportedLookAndFeelException e1) {
            e1.printStackTrace();
        }
    }

    public class CheckCanStart
    implements KeyListener {
        @Override
        public void keyPressed(KeyEvent arg0) {
        }

        @Override
        public void keyReleased(KeyEvent arg0) {
            Settings.this.checkDisplaySaveButton();
        }

        @Override
        public void keyTyped(KeyEvent arg0) {
        }
    }

    class JCheckBoxGPU
    extends JCheckBox {
        private GPUDevice gpu;

        public JCheckBoxGPU(GPUDevice gpu) {
            super(gpu.getModel());
            this.gpu = gpu;
        }

        public GPUDevice getGPUDevice() {
            return this.gpu;
        }
    }

    class SaveSettingsFileAction
    implements ActionListener {
        SaveSettingsFileAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Settings.this.checkDisplaySaveButton();
        }
    }

    class SaveAction
    implements ActionListener {
        SaveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean restartRequired;
            OS os;
            boolean high_priority_support;
            File fromConfig;
            if (Settings.this.parent == null) {
                return;
            }
            Configuration config = Settings.this.parent.getConfiguration();
            if (config == null) {
                return;
            }
            if (Settings.this.themeOptionsGroup.getSelection().getActionCommand() != null) {
                config.setTheme(Settings.this.themeOptionsGroup.getSelection().getActionCommand());
            }
            if (Settings.this.cacheDir != null && (fromConfig = config.getStorageDir()) != null && !fromConfig.getAbsolutePath().equals(Settings.this.cacheDir.getAbsolutePath())) {
                config.setCacheDir(Settings.this.cacheDir);
            }
            GPUDevice selected_gpu = null;
            for (JCheckBoxGPU box : Settings.this.useGPUs) {
                if (!box.isSelected()) continue;
                selected_gpu = box.getGPUDevice();
            }
            Configuration.ComputeType method = this.getComputeType(selected_gpu);
            config.setComputeMethod(method);
            if (selected_gpu != null) {
                config.setGPUDevice(selected_gpu);
            }
            int cpu_cores = -1;
            if (Settings.this.cpuCores != null) {
                cpu_cores = Settings.this.cpuCores.getValue();
            }
            if (cpu_cores > 0) {
                config.setNbCores(cpu_cores);
            }
            long max_ram = -1L;
            if (Settings.this.ram != null) {
                max_ram = Settings.this.ram.getValue();
            }
            if (max_ram > 0L) {
                config.setMaxAllowedMemory(max_ram);
            }
            int max_rendertime = -1;
            if (Settings.this.renderTime != null) {
                max_rendertime = (Integer)Settings.this.renderTime.getValue() * 60;
                config.setMaxRenderTime(max_rendertime);
            }
            if (high_priority_support = (os = OS.getOS()).isHighPrioritySupported()) {
                config.setPriority(-1 * Settings.this.priority.getValue());
            } else {
                config.setPriority(19 - Settings.this.priority.getValue());
            }
            config.setHeadless(Settings.this.headlessCheckbox.isSelected());
            String proxyText = null;
            if (Settings.this.proxy != null) {
                try {
                    Proxy.set(Settings.this.proxy.getText());
                    proxyText = Settings.this.proxy.getText();
                }
                catch (MalformedURLException e1) {
                    System.err.println("Error: wrong url for proxy");
                    System.err.println(e1);
                    System.exit(2);
                }
            }
            config.setProxy(proxyText);
            Settings.this.parent.setCredentials(Settings.this.login.getText(), new String(Settings.this.password.getPassword()));
            String hostnameText = Settings.this.hostname.getText();
            if (hostnameText == null || hostnameText.isEmpty()) {
                hostnameText = Settings.this.parent.getConfiguration().getHostname();
            }
            config.setHostname(hostnameText);
            config.setAutoSignIn(Settings.this.autoSignIn.isSelected());
            config.setUseSysTray(Settings.this.useSysTray.isSelected());
            if (Settings.this.saveFile.isSelected()) {
                Settings.this.parent.getSettingsLoader().setSettings(config.getConfigFilePath(), Settings.this.login.getText(), new String(Settings.this.password.getPassword()), proxyText, hostnameText, method, selected_gpu, cpu_cores, max_ram, max_rendertime, this.getCachePath(config), this.getSharedPath(config), Settings.this.autoSignIn.isSelected(), Settings.this.useSysTray.isSelected(), Settings.this.headlessCheckbox.isSelected(), "swing", Settings.this.themeOptionsGroup.getSelection().getActionCommand(), config.getPriority());
                if (Settings.this.parent.getClient().getServer().getServerConfig() != null && Settings.this.parent.getClient().getServer().getServerConfig().getPublickey() != null) {
                    Settings.this.parent.getSettingsLoader().saveFile();
                    Settings.this.sessionStarted = true;
                }
            }
            boolean sysTrayChanged = Settings.this.useSysTray.isSelected() != Settings.this.useSysTrayPrevState;
            boolean headlessChanged = Settings.this.headlessCheckbox.isSelected() != Settings.this.isHeadlessPrevState;
            boolean bl = restartRequired = sysTrayChanged || headlessChanged;
            if (restartRequired) {
                String warning = "The following changes require a restart to take effect: %s";
                LinkedList<String> changes = new LinkedList<String>();
                if (sysTrayChanged) {
                    changes.add("Minimize to SysTray");
                }
                if (headlessChanged && Settings.this.sessionStarted) {
                    changes.add("Block Eevee Projects");
                }
                if (changes.size() > 0) {
                    warning = String.format(warning, String.join((CharSequence)", ", changes));
                    JOptionPane.showMessageDialog(null, warning);
                }
            }
        }

        @NotNull
        private Configuration.ComputeType getComputeType(GPUDevice selected_gpu) {
            Configuration.ComputeType method = Configuration.ComputeType.CPU;
            if (Settings.this.useCPU.isSelected() && selected_gpu == null) {
                method = Configuration.ComputeType.CPU;
            } else if (!Settings.this.useCPU.isSelected() && selected_gpu != null) {
                method = Configuration.ComputeType.GPU;
            } else if (Settings.this.useCPU.isSelected() && selected_gpu != null) {
                method = Configuration.ComputeType.CPU_GPU;
            }
            return method;
        }

        private String getCachePath(Configuration config) {
            String cachePath = null;
            if (config.isUserHasSpecifiedACacheDir() && config.getCacheDirForSettings() != null) {
                cachePath = config.getCacheDirForSettings().getAbsolutePath();
            }
            return cachePath;
        }

        private String getSharedPath(Configuration config) {
            String sharedPath = null;
            if (config.getSharedDownloadsDirectory() != null) {
                sharedPath = config.getSharedDownloadsDirectory().getAbsolutePath();
            }
            return sharedPath;
        }
    }

    class CancelAction
    implements ActionListener {
        CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (Settings.this.parent == null) {
                return;
            }
            Configuration config = Settings.this.parent.getConfiguration();
            if (config == null) {
                return;
            }
            Settings.this.applyTheme(config.getTheme());
            Settings.this.parent.showActivity(GuiSwing.ActivityType.WORKING);
        }
    }

    class ApplyThemeAction
    implements ActionListener {
        ApplyThemeAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Settings.this.applyTheme(Settings.this.themeOptionsGroup.getSelection().getActionCommand());
        }
    }

    class AutoSignInChangeAction
    implements ActionListener {
        AutoSignInChangeAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (Settings.this.autoSignIn.isSelected()) {
                Settings.this.saveFile.setSelected(true);
            }
        }
    }

    class GpuChangeAction
    implements ActionListener {
        GpuChangeAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int counter = 0;
            for (JCheckBox jCheckBox : Settings.this.useGPUs) {
                if (!jCheckBox.isSelected()) {
                    jCheckBox.setSelected(false);
                } else if (Settings.this.useGPUs.get(counter).getGPUDevice().getType().equals(Nvidia.TYPE)) {
                    Nvidia nvidia = new Nvidia();
                }
                if (!jCheckBox.equals(e.getSource())) {
                    jCheckBox.setSelected(false);
                }
                ++counter;
            }
            Settings.this.checkDisplaySaveButton();
        }
    }

    class CpuChangeAction
    implements ActionListener {
        CpuChangeAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Settings.this.checkDisplaySaveButton();
        }
    }

    class ChooseFileAction
    implements ActionListener {
        ChooseFileAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            JOptionPane.showMessageDialog(Settings.this.parent.getContentPane(), "<html>The working directory has to be dedicated directory. <br />Caution, everything not related to SheepIt-Renderfarm will be removed.<br />You should create a directory specifically for it.</html>", "Warning: files will be removed!", 2);
            int returnVal = Settings.this.cacheDirChooser.showOpenDialog(Settings.this.parent.getContentPane());
            if (returnVal == 0) {
                File file;
                Settings.this.cacheDir = file = Settings.this.cacheDirChooser.getSelectedFile();
                Settings.this.cacheDirText.setText(Settings.this.cacheDir.getName());
            }
        }
    }
}

