/*
 * This file has been generated by the onto2vocabularyclass tool
 * copyright (C) 2007-2011 Sebastian Trueg <trueg@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _SOPRANO_NAO_H_
#define _SOPRANO_NAO_H_

#include <QtCore/QUrl>
#include "soprano_export.h"

namespace Soprano {
    namespace Vocabulary {
        namespace NAO {
            /**
             * http://www.semanticdesktop.org/ontologies/2007/08/15/nao#
             */
            SOPRANO_EXPORT QUrl naoNamespace();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/08/15/nao#FreeDesktopIcon 
             * 
             * Represents a desktop icon as defined in the FreeDesktop Icon 
             * Naming Standard 
             */
            SOPRANO_EXPORT QUrl FreeDesktopIcon();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/08/15/nao#Party 
             * 
             * Represents a single or a group of individuals 
             */
            SOPRANO_EXPORT QUrl Party();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/08/15/nao#Symbol 
             * 
             * Represents a symbol 
             */
            SOPRANO_EXPORT QUrl Symbol();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/08/15/nao#Tag 
             * 
             * Represents a generic tag 
             */
            SOPRANO_EXPORT QUrl Tag();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/08/15/nao#altLabel 
             * 
             * An alternative label alongside the preferred label for a resource 
             */
            SOPRANO_EXPORT QUrl altLabel();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/08/15/nao#altSymbol 
             * 
             * An alternative symbol representation for a resource 
             */
            SOPRANO_EXPORT QUrl altSymbol();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/08/15/nao#annotation 
             * 
             * Generic annotation for a resource 
             */
            SOPRANO_EXPORT QUrl annotation();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/08/15/nao#contributor 
             * 
             * Refers to a single or a group of individuals that contributed 
             * to a resource 
             */
            SOPRANO_EXPORT QUrl contributor();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/08/15/nao#created 
             * 
             * States the creation, or first modification time for a resource 
             */
            SOPRANO_EXPORT QUrl created();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/08/15/nao#creator 
             * 
             * Refers to the single or group of individuals that created the 
             * resource 
             */
            SOPRANO_EXPORT QUrl creator();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/08/15/nao#deprecated 
             * 
             * If this property is assigned, the subject class, property, 
             * or resource, is deprecated and should not be used in production 
             * systems any longer. It may be removed without further notice. 
             */
            SOPRANO_EXPORT QUrl deprecated();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/08/15/nao#description 
             * 
             * A non-technical textual annotation for a resource 
             */
            SOPRANO_EXPORT QUrl description();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/08/15/nao#engineeringTool 
             * 
             * Specifies the engineering tool used to generate the graph 
             */
            SOPRANO_EXPORT QUrl engineeringTool();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/08/15/nao#hasDefaultNamespace 
             * 
             * Defines the default static namespace for a graph 
             */
            SOPRANO_EXPORT QUrl hasDefaultNamespace();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/08/15/nao#hasDefaultNamespaceAbbreviation 
             * 
             * Defines the default static namespace abbreviation for a graph 
             */
            SOPRANO_EXPORT QUrl hasDefaultNamespaceAbbreviation();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/08/15/nao#hasSubResource 
             * 
             * Defines a relationship between a resource and one or more sub 
             * resources 
             */
            SOPRANO_EXPORT QUrl hasSubResource();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/08/15/nao#hasSuperResource 
             * 
             * Defines a relationship between a resource and one or more super 
             * resources 
             */
            SOPRANO_EXPORT QUrl hasSuperResource();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/08/15/nao#hasSymbol 
             * 
             * Annotation for a resource in the form of a symbol representation 
             */
            SOPRANO_EXPORT QUrl hasSymbol();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/08/15/nao#hasTag 
             * 
             * Defines an existing tag for a resource 
             */
            SOPRANO_EXPORT QUrl hasTag();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/08/15/nao#hasTopic 
             * 
             * Defines a relationship between two resources, where the object 
             * is a topic of the subject 
             */
            SOPRANO_EXPORT QUrl hasTopic();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/08/15/nao#iconName 
             * 
             * Defines a name for a FreeDesktop Icon as defined in the FreeDesktop 
             * Icon Naming Standard 
             */
            SOPRANO_EXPORT QUrl iconName();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/08/15/nao#identifier 
             * 
             * Defines a generic identifier for a resource 
             */
            SOPRANO_EXPORT QUrl identifier();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/08/15/nao#isDataGraphFor 
             * 
             * Links a named graph to the resource for which it contains metadata. 
             * Its typical usage would be to link the graph containing extracted 
             * file metadata to the file resource. This allows for easy maintenance 
             * later on. 
             */
            SOPRANO_EXPORT QUrl isDataGraphFor();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/08/15/nao#isRelated 
             * 
             * Defines an annotation for a resource in the form of a relationship 
             * between the subject resource and another resource 
             */
            SOPRANO_EXPORT QUrl isRelated();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/08/15/nao#isTagFor 
             * 
             * States which resources a tag is associated with 
             */
            SOPRANO_EXPORT QUrl isTagFor();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/08/15/nao#isTopicOf 
             * 
             * Defines a relationship between two resources, where the subject 
             * is a topic of the object 
             */
            SOPRANO_EXPORT QUrl isTopicOf();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/08/15/nao#lastModified 
             * 
             * States the last modification time for a resource 
             */
            SOPRANO_EXPORT QUrl lastModified();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/08/15/nao#modified 
             * 
             * States the modification time for a resource 
             */
            SOPRANO_EXPORT QUrl modified();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/08/15/nao#numericRating 
             * 
             * Annotation for a resource in the form of a numeric rating (float 
             * value), allowed values are between 1 and 10 whereas 0 is interpreted 
             * as not set 
             */
            SOPRANO_EXPORT QUrl numericRating();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/08/15/nao#personalIdentifier 
             * 
             * Defines a personal string identifier for a resource 
             */
            SOPRANO_EXPORT QUrl personalIdentifier();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/08/15/nao#pluralPrefLabel 
             * 
             * The plural form of the preferred label for a resource 
             */
            SOPRANO_EXPORT QUrl pluralPrefLabel();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/08/15/nao#prefLabel 
             * 
             * A preferred label for a resource 
             */
            SOPRANO_EXPORT QUrl prefLabel();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/08/15/nao#prefSymbol 
             * 
             * A unique preferred symbol representation for a resource 
             */
            SOPRANO_EXPORT QUrl prefSymbol();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/08/15/nao#rating 
             * 
             * Annotation for a resource in the form of an unrestricted rating 
             */
            SOPRANO_EXPORT QUrl rating();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/08/15/nao#score 
             * 
             * An authoritative score for an item valued between 0 and 1 
             */
            SOPRANO_EXPORT QUrl score();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/08/15/nao#scoreParameter 
             * 
             * A marker property to mark selected properties which are input 
             * to a mathematical algorithm to generate scores for resources. 
             * Properties are marked by being defined as subproperties of 
             * this property 
             */
            SOPRANO_EXPORT QUrl scoreParameter();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/08/15/nao#serializationLanguage 
             * 
             * States the serialization language for a named graph that is 
             * represented within a document 
             */
            SOPRANO_EXPORT QUrl serializationLanguage();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/08/15/nao#status 
             * 
             * Specifies the status of a graph, stable, unstable or testing 
             */
            SOPRANO_EXPORT QUrl status();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/08/15/nao#userVisible 
             * 
             * Mark a property, class, or even resource as user visible or not. 
             * Non-user-visible entities should never be presented to the 
             * user. By default everything is user-visible. 
             */
            SOPRANO_EXPORT QUrl userVisible();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/08/15/nao#version 
             * 
             * Specifies the version of a graph, in numeric format 
             */
            SOPRANO_EXPORT QUrl version();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/08/15/nao#Agent
             *
             * An agent is the artificial counterpart to nao:Party. It can be a software component or some service.
             */
            SOPRANO_EXPORT QUrl Agent();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/08/15/nao#maintainedBy
             *
             * The agent that maintains this resource, ie. created it and knows what to do with it.
             */
            SOPRANO_EXPORT QUrl maintainedBy();
        }
    }
}

#endif
