package Spidy::Database::Group;

use Spidy::Group;
@ISA = qw( Spidy::Group );
use Spidy::GraphicsBuilder;
use CGI;

use strict;

sub autoload_members {
    my $self = shift;
    return {
        %{$self->SUPER::autoload_members()},
        # just for cgi mode
        'script_name'              => 'scalar',
        'cgi'                      => 'scalar',
    };
}

sub new {
  my $self = shift->SUPER::new(@_);
#  $self->{'cgi'} = CGI->new();
  return $self;
}

sub set_defaults { 
  my $self = shift;
  my %defaults;
  if( ref($_[0]) ) {
    %defaults = %{$_[0]};
  } else {
    %defaults = @_;
  }
  
  for my $key ( keys %defaults ) {
    $self->{$key} = $defaults{$key}
      unless defined $self->{$key};
  }
  
  #
  # Data here is for html file generation
  # of image generation.  Also html data
  # that is recursive in nature (directory paths)
  # is set here for efficiency's sake.
  # 
  #

  if( my $parent = $self->{'parent'} ) {

    $self->{'top_html_path'} 
      =  $parent->{'top_html_path'}
      unless $self->{'top_html_path'};
  }
  $self->SUPER::set_defaults(%defaults);
  return;
}  

sub cgi {
  my $self = shift;
  return $self->{'cgi'} if $self->{'cgi'};
  return $self->{'cgi'} = CGI->new();
}

sub set_param_data { 
  my $self = shift;
  my $p = shift;
  my $size = shift;
  my $caller = shift || $self;
  
  if( $p eq 'href' ) {
    my $path = $self->set_param_data('path', $size, $caller);
    return $self->cgi()->script_name()."?size=$size->{'name'}&path=$path";
  } elsif( $p eq 'path' ) {
    return $self->{'path'} if defined $self->{'path'};
    return $self->clean_path( "$caller->{'top_html_path'}/$self->{'html_path'}" );
  } elsif( $p eq 'xml_id' ) {
    return $self->{'id'};
  } elsif( $p eq 'src' ) {
    return $self->{'src'} if defined $self->{'src'};
  } elsif( $p eq 'top_html_path' ) {
    return '.';
  } elsif( $p eq 'width' || 
           $p eq 'height' ||
           $p eq 'column_count' ||
           $p eq 'count' ||
           $p eq 'max_height' ||
           $p eq 'max_widht') {
    return $self->{$p} if defined $self->{$p};
  } elsif( $p eq 'type' ) {
    return $self->{'type'} if defined $self->{'type'};
    return 'group';
  } elsif( $p eq 'left_group_src' ) {
    my $prev = $self->previous_group();
    return $prev->set_param_data( 'src', $size->first(), $caller )
      if $prev;
    return;
  } elsif( $p eq 'right_group_src' ) {
    my $next = $self->next_group();
    return $next->set_param_data( 'src', $size->first(), $caller )
      if $next;
    return;
  }

  
  return $self->SUPER::set_param_data($p, $size, $caller);
}

sub clean_path {
  my $self = shift;
  my $path = shift;
  # remove groups of "stuff/../" from the path
  # so t/gallery/set1/../medium_index.html will turn into
  # t/gallery/medium_index.html
  while( $path =~ /[.][.]\// ) {
    $path =~ s/[^\/]+\/[.][.]\///;
  }
  
  # clean up the "./" in the middle path.  This is needtd
  # to make sure the path names are unique for the cache.
  
  $path =~ s/[.]\///g;
  return $path;
}
1;    

