package Spidy::Object;

use strict;
use vars '$AUTOLOAD', '@ISA';
use Carp;
# use Tie::Hash;
# @ISA = qw( Tie::StdHash );

sub new {
  my $package = shift;
  my %self;
  my %args = @_;
  for ( keys %args ) {
    delete $args{$_} unless defined $args{$_};
  }

  while( my ($a, $b) = each %args ) { 
    my $orig = $a;
    if( $a =~ s/([a-z])([A-Z])/${1}_\l$2/g ) {
      $args{$a} = $b;
      delete $args{$orig};
    }
  }

  my $self = bless {%args}, $package;
  $self->init();
  return $self;
#  tie %self, $package;
#  return bless \%self, $package;
}

sub init {
  my $self = shift;
  my $attributes = $self->autoload_members;
  while( my ($k, $v)  = each %$attributes ) {
    my( $default ) = ( $v =~ /scalar\=([^;]+)/ );
    $self->{$k} = $default 
      if $default && !defined($self->{$k});
  }
}

sub copy {
  my $self = shift;
  my $copy = new( ref($self), %$self );
  my %args = @_;
  while( my ($a, $b) = each %args ) {
    $copy->{$a} = $b;
  }
  return $copy;
  
# bless { %{$_[0]}, @_[1 .. $#_] }, ref($_[0]);
}

#just here to ensure it exists for inheritance.
sub autoload_members {
  return {}
};

sub FETCH {
  my $self = shift;
  my $key = shift;
  my $data_type = $self->autoload_members()->{$key};
  confess "Error: '$key' is not a member of ", ref($self), "\n"
    unless $data_type;
  my ($default) = ($data_type =~ /scalar\=(.+)$/);
  if( $data_type =~ /array/ ) {
    if( exists $self->{$key} ) {
      return wantarray ? @{$self->{$key}} : $self->{$key};
    } else {
      return ();
    }
  } elsif( $data_type =~ /list/ ) {
    if( wantarray ) {
      my @array;
      my $cursor = $self->{$key};
      return unless $cursor;
      do {
        push @array, $cursor;
      } while( $cursor = $cursor->get_next() );
      return @array;
    } else {
      return $self->{$key};
    }
  } elsif( $data_type =~ /boolean/ ) {
    $data_type =~ /boolean=(.*)$/;
    my $value = $1 ? $1 : 0;
    return exists $self->{$key} ? $self->{$key} : $value;
  } else {
    if( defined $self->{$key} ) {
      return $self->{$key};
    } else {
      return $default
    }
  }
}  
  

sub STORE {
  my $self = shift;
  my $key = shift;
  my $value = shift;

  my $data_type = $self->autoload_members()->{$key};
  confess "Error: '$key' is not a member of ", ref($self), "\n"
    unless $data_type;
  if( $data_type =~ /array/ ) {
    confess(
      "Data Member \"$key\" can only be assigned an Array Reference for object \"",
      ref($self), '"'
    ) unless ref($value) eq "ARRAY";
    my $ret_val = $self->{$key}; 
    $self->{$key} = $value;
    return $ret_val;
  } elsif( $data_type =~ /object/) {
    my ($mod_name) = ( $data_type =~ /object\=(.+)$/ );
    unless( $mod_name ) {
      $mod_name = $key;
      $mod_name =~ s/(\w)_(\w)/$1\u$2/g;
      $mod_name = "Spidy::" . ucfirst($mod_name);
    }
    confess(
      "Data Member \"$key\" can only be assigned ",
      "an object of type \"$mod_name\""
    ) unless ref($value) && $value->isa($mod_name);
    my $ret_val = $self->{$key}; 
    $self->{$key} = $value;
    return $ret_val;
  } elsif( $data_type =~ /list/ ) {
    if( ref($value) eq 'ARRAY' ) {
      my $cursor = shift @$value;
      $self->{$key} = $cursor;
      while( my $next = shift @$value) {
        $cursor->{'next'} = $next;
        $next->{'previous'} = $cursor;
        $cursor = $next;
      }
    } else {
      $self->{$key} = $value;
    }
    return;
  } else {      
    my $ret_val = $self->{$key}; 
    $self->{$key} = $value;
    return $ret_val;
  }
}
 
# sub DESTROY {
#   my $self = shift;
#   untie $self;
# }
# sub search_data_members {
#   my $self = shift;
#   my $key = shift;
#   my @isa = grep { $_ ne __PACKAGE__ } eval( "@".ref($self)."::ISA" );
#   my $data_type;
#   for my $package ( ref($self), @isa ) {
#     no strict 'refs';
#     $data_type = eval "${package}::autoload_members()->{'$key'}";
#     last if $data_type;
#   }
#   confess( 
#     "Data Member \"$key\" does not exist in object type \"", ref($self), '"'
#   ) unless $data_type;
#   return $data_type;
# }

# sub AUTOLOAD
# {
#     my ($self) = @_;
#  
#     my $sub_name = $AUTOLOAD;
#  
#     # strip package names
#     $sub_name =~ s/.*://;
#  
#     # skip all-caps (assumed system) functions
#     return unless $sub_name =~ /[a-z]/;
#  
#     my $action;
#     my $variable;
#     if( $sub_name =~ /^([gs]et|add)_(.*)$/ ) {
#           $action = $1;
#           $variable = $2;
#     } else {
#       confess( "ERROR: '$AUTOLOAD' is not a proper function name!\n" .
#              "It should start with 'get', 'set' or 'add'");
#     }
# 
#     # actual variable name starts lowercase
#     $variable = lcfirst $variable;
#     
#     my @isa = grep { $_ ne __PACKAGE__ } eval( "@".ref($self)."::ISA" );
#     my $data_type;
#     for my $package ( ref($self), @isa ) {
#       no strict 'refs';
#       $data_type = eval "${package}::autoload_members()->{'$variable'}";
#       last if $data_type;
#     }
#     unless( $data_type ) {
#       confess( "ERROR: Routine type for '$variable' not found in " . 
#              ref($self) . "::autoload_members\n".
#              "for autoloaded function $AUTOLOAD");
#     }
#     
#     my $sub;
#     if( $action eq 'get' ) {
#       my ($default) = ($data_type =~ /scalar\=(.+)$/);
#       if( $data_type =~ /array/ ) {
#         $sub = sub {
#           my $group = shift;
#           if( exists $group->{$variable} ) {
#             return wantarray ? @{$group->{$variable}} : $group->{$variable};
#           } else {
#             return ();
#           }
#         }
#       } elsif( $data_type =~ /list/ ) {
#         $sub = sub {
#           my $self = shift;
#           if( wantarray ) {
#             my @array;
#             my $cursor = $self->{$variable};
#             return unless $cursor;
#             do {
#               push @array, $cursor;
#             } while( $cursor = $cursor->get_next() );
#             return @array;
#           } else {
#             return $self->{$variable};
#           }
#         }
#       } elsif( $data_type =~ /boolean/ ) {
#         $data_type =~ /boolean=(.*)$/;
#         my $value = $1 ? $1 : 0;
# 
#         $sub = sub {
#             return exists $_[0]->{$variable} ? $_[0]->{$variable} : $value;
#         };
#       } else {
#         $sub = sub { 
#           my $group = shift;
#           if( exists $group->{$variable} ) {
#             return $group->{$variable};
#           } else {
#             return $group->{$variable} = $default if $default;
#           };
#         }  
#       }
#     }
#     elsif( $action eq 'set' ) {
#       if( $data_type =~ /array/ ) {
#         $sub = sub { 
#             confess("$sub_name: Argument '$_[1]' must be an Array Reference") unless ref($_[1]) eq "ARRAY";
#             my $ret_val = $_[0]->{$variable}; 
#             $_[0]->{$variable} = $_[1];
#             return $ret_val;
#         };        
#       } elsif( $data_type =~ /object/) {
#         my ($mod_name) = ( $data_type =~ /object\=(.+)$/ );
#         unless( $mod_name ) {
#           $mod_name = $variable;
#           $mod_name =~ s/(\w)_(\w)/$1\u$2/g;
#           $mod_name = "Spidy::" . ucfirst($mod_name);
#         }
#         $sub = sub { 
#             confess("$sub_name: Argument must be an object of type $mod_name") unless ref($_[1]) && $_[1]->isa($mod_name);
#             my $ret_val = $_[0]->{$variable}; 
#             $_[0]->{$variable} = $_[1];
#             return $ret_val;
#         };
#       } elsif( $data_type =~ /list/ ) {
#         $sub = sub {
#           my $self = shift;
#           my $cursor = shift;
#           $self->{$variable} = $cursor;
#           while( my $next = shift ) {
#             $cursor->set_next($next);
#             $next->set_previous($cursor);
#             $cursor = $next;
#           }
#           return;
#         }
#       } else {      
#         $sub = sub { 
#             my $ret_val = $_[0]->{$variable}; 
#             $_[0]->{$variable} = $_[1];
#             return $ret_val;
#         };
#       }
#     } elsif( $action eq 'add' ) {
#       if( $data_type =~ /object/ && $data_type =~ /array/ ) {
#         my ($mod_name) = ( $data_type =~ /object\=(.+)$/ );
#         $mod_name = "Spidy::" . ucfirst($variable) unless $mod_name;
# 
#         $sub = sub {
#           confess("$sub_name: Argument must be an object of type $mod_name") unless ref($_[1]) && $_[1]->isa($mod_name);
#           push @{$_[0]->{$variable}}, @_[1 .. $#_];
#         };
#       } elsif( $data_type =~ /array/ ) {
#         $sub = sub {
#           if( ref($_[1]) eq 'ARRAY' ) {
#               push @{$_[0]->{$variable}}, @{$_[1]};
#           } else {
#               push @{$_[0]->{$variable}}, @_[1 .. $#_];
#           }
#         };
#       } elsif( $data_type =~ /object/ && $data_type =~ /scalar/ ) {
#         croak( "ERROR: What the hell are you doing trying to call\n" .
#                "an 'add' function on a SCALAR OBJECT variable?" );
#       } elsif( $data_type =~ /scalar/ ) {
#         $sub = sub {
#           my $ret_val = $_[0]->{$variable}; 
#           $_[0]->{$variable} .= $_[1];
#           return $ret_val;
#         };
#       } else {
#         croak( "ERROR: What the hell are you doing trying to call\n" .
#                "an 'add' function on a ". uc($data_type). " variable?" );
#       }
#     }
#     no strict 'refs';                                                           
# 
#     *{$AUTOLOAD} = $sub;
# 
#     goto &{$AUTOLOAD};
# }
1;
