package Spidy::ConfigWriter;

use strict;

sub new {
  my $package = shift;
  my $self = {
    's' => shift,
    'include_size' => shift,
  };
  
  return bless $self, $package;
}


sub convert {
  my $self = shift;
  $self->{content} = $self->_content($self->{'s'}->{'tree'});
  $self->{content} = $self->globals($self->{'s'}->{'globals'}, $self->{'content'});
  return $self->{'content'};
}

sub globals {
  my $self = shift;
  my $globals = shift;
  my $content = shift;
  
  my $size_content;
  if( $globals->{'sizes'} ) {
    for my $size ( @{$globals->{'sizes'}} ) {
      $size_content .= $self->xml($size, 2);
    }
  }
  if( $size_content ) {
    chomp($size_content);
    chomp($content);
    $content =~ s/^/  /gm;
    $content =<<EOF;
<gallery>
  <globals>
    <custom-sizes>
$size_content
    </custom-sizes>
  </globals>
$content
</gallery>
EOF
  }
  return $content;
}

sub _content {
  my $self = shift;
  my $tree = shift;
  my $content = shift;
  my $depth = shift || 0;
  
  
  if( $self->isa( "Spidy::Image" ) ) {
    $content .= $self->xml( $tree, $depth );
  } else {
    my( $open, $close ) = $self->xml( $tree, $depth );

    $content .= $open;
    
    my @groups = $tree->{'groups'}->list() if $tree->{'groups'};
    @groups = $tree->{'images'}->list() if $tree->{'images'};
    
    for my $g ( @groups ) {
      $content = $self->_content( $g, $content, $depth + 1 );
    }
    
    $content .= $close;
  }
  return $content;
}

{ 
  # scoped static variable
  my %attr_cache;
  
  sub get_attribute_names {
    my $self = shift;
    my $obj = shift;
    my $tag = shift;
    
#     return $attr_cache{ $tag } if exists $attr_cache{ $tag };
#     
#     my $attributes = $obj->autoload_members();
#     for my $attr ( keys %$attributes ) {
#       if( $attributes->{$attr} =~ /xml=attr(?:<(\w+)>)?/ ) {
#         my $sub_tag = $1;
#         if( $sub_tag ) {
#           $attr_cache{$sub_tag}->{$attr}++;
#         } else {
#           $attr_cache{$tag}->{$attr}++;
#         }
#       }
#     }
#     
#     return $attr_cache{ $tag } || {};

    my $type = ref($obj);
    return $attr_cache{ $type }->{ $tag } || {}
      if exists $attr_cache{ $type };
    
    my $attributes = $obj->autoload_members();
    for my $attr ( keys %$attributes ) {
      if( $attributes->{$attr} =~ /xml=attr(?:<(\w+)>)?/ ) {
        my $sub_tag = $1;
        if( $sub_tag ) {
          $attr_cache{$type}->{$sub_tag}->{$attr}++;
        } else {
          $attr_cache{$type}->{$tag}->{$attr}++;
        }
      }
    }
    
    return $attr_cache{ $type }->{ $tag } || {};
  }
  
  my %tag_cache;
  sub get_tag_names {
    my $self = shift;
    my $obj = shift;
    
    my $key = ref( $obj );
    
    return $tag_cache{ $key } if exists $tag_cache{ $key };

    my $attributes = $obj->autoload_members();
    for my $attr ( keys %$attributes ) {
      if( $attributes->{$attr} =~ /xml=tag/ ) {
        $tag_cache{$key}->{$attr}++;
      }
    }

    return $tag_cache{ $key } || {}
  }
  
  my %content_cache;
  
  sub get_content_name {
    my $self = shift;
    my $obj = shift;
    
    my $key = ref( $obj );
    
    return $content_cache{ $key } if exists $tag_cache{ $key };

    my $attributes = $obj->autoload_members();
    for my $attr ( keys %$attributes ) {
      if( $attributes->{$attr} =~ /xml=content/ ) {
        $content_cache{$key} = $attr;
      }
    }

    return $content_cache{ $key } || {}
  }
}

sub xml_open {
  my $self = shift;
  my $obj = shift;
  my $tag = shift;
  my $depth = shift;
  my $prefix = shift;

  my $tab = "    " x $depth;
  my $content = "$tab<$prefix$tag";
  
  my $count;
  my $attributes;
  for my $attr ( keys %{ $self->get_attribute_names($obj, $tag) } ) {
    if( exists $obj->{$attr} && defined $obj->{$attr} && !$obj->is_default($attr)) {
      #$attributes .= "\n$tab"." "x(length($tag)+2+length($prefix)) if $count++;
      my $new_attr = $attr;
      if( $attr =~ /path_type$/ ) {
        $new_attr = 'type';
      }
      $attributes .= " $new_attr=\"$obj->{$attr}\"";
    }
  }
  
  return "$content$attributes>";
#    unless $attributes;
#   return "$content $attributes>";
}
  

sub xml {
  my $self  = shift;
  my $obj   = shift;
  my $depth = shift;
  
  
  my $tag;
  if( $obj->isa("Spidy::Image") ) {
    $tag = 'image';
  } elsif( $obj->isa("Spidy::Size") ) {
    $tag = 'size';
  } else {
    $tag = "group";
  }
    
  my $prefix;
  if( $obj->{'is_autogroup'} ) {
    $prefix = 'auto';
  }
  if( $obj->{'is_pattern'} ) {
    $obj->{'name'} =~ s/^(?:pattern)?/pattern:/;
  }
  
  my $content = $self->xml_open($obj, $tag, $depth, $prefix);
  $content .= "\n";
  
  my $data = 0;

  for my $sub_tag ( keys %{ $self->get_tag_names( $obj ) } ) {
    next if( !$obj->{$sub_tag} || $obj->is_default($sub_tag) );
    $content .= $self->xml_open( $obj, $sub_tag, $depth + 1 );
    $content .= "$obj->{$sub_tag}</$sub_tag>\n";
    $data++;
  }
  
  if( $obj->{'comment'} ) {
    my $comment = $obj->{'comment'};
    my $comment_content = $comment->{ $self->get_content_name( $obj->{'comment'} ) };
    if( $comment_content =~ /\S/ ) {
      $content .= $self->xml_open($comment, 'comment', $depth + 1);
      $content .= "$comment_content";
      $content .= $comment_content =~ /\n/ 
        ? "\n"."    "x($depth + 1) . "</comment>\n"
        : "</comment>\n";
      $data++;
    }
  }
  
  if( $obj->{'links'} ) {
    for my $link ( @{$obj->{'links'}} ) {
      $content .= $self->xml_open($link, 'link', $depth + 1);
      my $link_content = $link->{ $self->get_content_name( $link ) };
      $content .= "$link_content</link>\n";
      $data++;
    }
  }
  if( $data ) {
    if( $tag eq 'image' ) {
      if( $self->{'include_size'} ) {
        if( $obj->{'output_image'} ne $obj->{'input_image'} ) {
          $content .= "    "x($depth+1)."<output_image name='$obj->{'output_image'}'/>\n";
        }
        for my $size ( $self->{'s'}->{'graphics_builder'}->{'sizes'}->list() ) {
          my $w = $obj->set_param_data("width", $size);
          my $h = $obj->set_param_data("height", $size);
          $content .= "    "x($depth+1) . "<size name='$size->{'name'}' width='$w' height='$h'/>\n";
  #        print "size name = $size->{'name'}\n";
        }
      }
    }
    if( $tag eq 'group' ) {
      return ($content, "    "x$depth . "</$prefix$tag>\n");
    }
    return $content. "    "x$depth . "</$prefix$tag>\n";
  } else {
    if( $tag eq 'image' ) {
      if( $self->{'include_size'} ) {
        if( $obj->{'output_image'} ne $obj->{'input_image'} ) {
          $content .= "    "x($depth+1)."<output_image name='$obj->{'output_image'}'/>\n";
        }
        for my $size ( $self->{'s'}->{'graphics_builder'}->{'sizes'}->list() ) {
          my $w = $obj->set_param_data("width", $size);
          my $h = $obj->set_param_data("height", $size);
          $content .= "    "x($depth+1) . "<size name='$size->{'name'}' width='$w' height='$h'/>\n";
        }
      }
      return $content. "    "x$depth . "</$prefix$tag>\n";
    } else {
      chop($content);  # chop off \n
      chop($content);  # chop off >
      return "$content/>\n";
    }
  }
}
  
sub xml_size {
  my $self = shift;
  my $size = shift;
  my $depth = shift;
}

1;
